﻿USE sofia;
DROP TABLE IF EXISTS sofia.mva_vpl;
CREATE TABLE mva_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mva_vpl WRITE;
INSERT INTO mva_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ngaedi nge Iesus Kristus labu rangaka: Iesus nge Debiti labunao ka ipura. Be Debiti nge Abaram labunao ka ipura. ");
INSERT INTO mva_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Be Abaram nge Aisak tama. Aisak nge Zekop tama. Zekop nge Zuda taritoka zaiza tamadi. ");
INSERT INTO mva_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda nge Perez be Zera tama-diaru. Tina-diaru ara Tema. Perez nge Ezron tama. Ezron nge Ram tama. ");
INSERT INTO mva_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram nge Aminadab tama. Aminadab nge Nason tama. Nason nge Samon tama. ");
INSERT INTO mva_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Samon nge Boaz tama. Boaz tina ara Reab. Boaz nge Obed tama. Obed tina ara Rut. Obed nge Zesi tama. ");
INSERT INTO mva_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi nge anuatanepoa biabia ara Debiti nge tama. Debiti nge Solomon tama. Solomon tina matamata nge Iuraia roa. ");
INSERT INTO mva_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon nge Reoboam tama. Reoboam nge Abaiza tama. Abaiza nge Asa tama. ");
INSERT INTO mva_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa nge Zeosapat tama. Zeosapat nge Zeoram tama. Zeoram nge Uzaia tama. ");
INSERT INTO mva_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaia nge Zotam tama. Zotam nge Eaz tama. Eaz nge Ezekaia tama. ");
INSERT INTO mva_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekaia nge Manase tama. Manase nge Emon tama. Emon nge Zosaia tama. ");
INSERT INTO mva_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zosaia nge Zekonaia taritoka zaiza tamadi. Dia-lo be ungguma aradi Babilon dipura be ungguma Iuda diundi be diuauridi be kaba nedia-lo dibagadialako. ");
INSERT INTO mva_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Uaura-lo be dimule nge nanaritakadi bokai dieno: Zekonaia nge Sealtiel tama. Sealtiel nge Zerubabel tama. ");
INSERT INTO mva_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabel nge Abaiud tama. Abaiud nge Eliakim tama. Eliakim nge Azo tama. ");
INSERT INTO mva_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azo nge Zadok tama. Zadok nge Akim tama. Akim nge Eliud tama. ");
INSERT INTO mva_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud nge Elieza tama. Elieza nge Matan tama. Matan nge Zekop tama. ");
INSERT INTO mva_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zekop nge Iosep tama. Iosep roa Maria. Be Maria Iesus inekiaki. Iesus ka Kristus. ");
INSERT INTO mva_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abaram-lo be imai Debiti-lo nge tubu kulemoa-be-oati moarunga. Debiti-lo be imai ramani ungguma Babilon dipura be Iuda diundi be diuauridi be dibagadi nge tubu kulemoa-be-oati moarunga. Babilon-lo be dimule be imai Kristus puraianao nge tubu kulemoa-be-oati moarunga. ");
INSERT INTO mva_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesus Kristus bokainatuka be nekiaka ipura. Tina Maria nge Iosep dirauamani. Ata tago isi disoaki-buduru be Maria ambe Oli Spirit kaiboang nena-lo be itine. ");
INSERT INTO mva_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria roa rarauam Iosep nge tamoata iauia be muzinga moarunga nge adoadodi be tago irere lili-be-matao Maria ngaruku-goalai. Bokaibe ilo ilelenaki be zugumaba-lo be Maria ngasegeaki kana. ");
INSERT INTO mva_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ata Iosep isi ilo ilelelenakia-la be Tanepoa Nanaranga ‘enzel’ ne teke rai-o ipura be bokai irai, “Iosep, Debiti tubu! Maria gobagai be gouati kana nge moaki taburim ira, bakara nge Oli Spirit kaiboang nena-lo ka itine. ");
INSERT INTO mva_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Masa natu moane teke nganekiaki be ara ‘Iesus’ gobuleakini. Natu ngae ka tamoata be aine ne moarunga muzigoala nedia-lo be ngauketidi kana.” ");
INSERT INTO mva_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kana ngaedi bokainatuka dipura be Tanepoa pilenga tekedi toira ‘propet’ teke aoa-nalo dipusika nge dikalingo. ");
INSERT INTO mva_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Toira be Tanepoa pilenga bokai dieno, “Aine teke moane zaiza tago sesu isi dieno-budu masa ngatine be natu moane teke nganekiaki ara Imanuel.” Ara Imanuel nge labu bokai: “Nanaranga marada isoaki.” ");
INSERT INTO mva_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bokaibe Iosep imarang nge Tanepoa ‘enzel’ ne pilenga itagadi be Maria ibagai be iuati. ");
INSERT INTO mva_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ata tago sesu dieno-buduru nibe natu-ba moane ngae nekiaka ipura, be ara Iesus ibuleakini. ");
INSERT INTO mva_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erot nge Zudea kaba anuatanepoa nedi bokana isoaki be Iesus Betlem anua, ege Zudea kaba-lo nekiaka ipura. Alauri nge tamoata marourou alu ege amari rakeanao be ditui be Ierusalem anua-lo dipura. ");
INSERT INTO mva_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tamoata ngaedi Ierusalem-lo dipura nge bokai ditegi, “Natu moane ungguma Iuda ngatanepoadi kana be nekiaka ipura inanga isoaki? Goai ne ege amari rakeanao irakerake be kite ka kipura be garakeaki kana.” ");
INSERT INTO mva_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Erot pile ngaedi ilongo nge ilo ibuku-tina. Be tamoata be aine moarunga Ierusalem-lo nge bokaina-doi ilodi dibuku. ");
INSERT INTO mva_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kodeka Erot itaguraki be tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki nge ikiladi be bokai itegidi, “Kristus masa anua nangatana-lo nekiaka ngapura?” ");
INSERT INTO mva_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Be di dikatu be bokai dipile, “Betlem anua, ege Zudea kaba-lo. Maka ma ‘propet’ bokai igere: ");
INSERT INTO mva_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlem anua, Zuda kateka nenao ka kueno! Zuda bagi tamoata nedi bibia maradi nge aram tago ileua-tina! Kaiko-lo ka tamoata biabia teke ngapura kana. Ngai ka ungguma negu Israel ngamuadi kana.’” (Mai 5:2) ");
INSERT INTO mva_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kodeka Erot itaguraki be tamoata marourou ege amari rakeana-onaona nge ikeliakidi be zugumaba-lo be inaguridi be bong-tina ono goai ipura nge ikauataki. ");
INSERT INTO mva_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Kodeka Erot bokai iradi, “Kamalale Betlem-lo be natu-muku ngae kamaleleia-tina uia. Kate nge kamapura be kamaraia, be mialale be mrakeaki.” ");
INSERT INTO mva_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tamoata marourou Erot pilenga ngaedi dilongo nge dialale. Zala-lo nge goai matamata ege amari rakeanao dite nge kababe ipura be arodi imuamua be ditagatagai. Goai ngae imuamua nibe ilako be kaba odio natu-muku ieno kana nge atabaladi itui. ");
INSERT INTO mva_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tamoata marourou goai ngae dite nge suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kodeka makara be pera ono natu-muku ieno kanana-lo disili. Disili nge natu-muku tina Maria diaru disoakiru be dite. Be tukudio dirokazokuria be natu-muku ngae dirakeaki. Dirakeakia-doi kodeka raba kandi diuasari be lumaluma didokidokini nge diani. ‘Gol,’ au-kusi boaudi rongorongo be bureng boaudi otioti nge lumaluma bokana natu-muku diani. ");
INSERT INTO mva_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ata rai-o nge pile bokai didoki, “Erot-lo moaki kamule.” Bokaibe zala takaia ditagai be anua nedia-lo dimule. ");
INSERT INTO mva_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tamoata marourou ege amari rakeana-onaona dialale nge Tanepoa ‘enzel’ ne teke Iosep rai-o ipurakani be bokai irai, “Gomarang be natu-muku tina diaru godoki-diaru be kamairatuto be Izip kamalakoto. Makara kamasoakito nibe masa kaba mra-kamingto be kamamuleto. Erot ambe natu-muku ngalelei be ngaumoatei kana.” ");
INSERT INTO mva_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Makara nge Iosep imarang be natu-muku tina diaru idoki-diaru be oabubu-lanalo be Izip diratu-lakoto. ");
INSERT INTO mva_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Be makara Izip kaba-lo disukoakito nibe Erot imate. Bokainatuka be Tanepoa pilenga tekedi ‘propet’ teke aoa-nalo dipusika nge dikalingo. ‘Propet’ ngae bokai ipile, “Natu-gu moane Izip kaba-lo be ukeliaki.” ");
INSERT INTO mva_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Alauri be Erot kaba bokai ita tamoata marourou ege amari rakeana-onaona dibolesi nge nama ira-tina. Bokaibe ipile be Betlem anua-lo be anua saringa dieno-lo nge natu-muku moane moarunga barasi nedi rua be ibala nge diumoatedi. Tamoata marourou pilengadi itagadi be natu-muku umoateadi dipura. Di ka bong-tina ono goai ipura nge dirangakani. ");
INSERT INTO mva_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bokai imuzi be ono ‘propet’ ara Zeremaia nge pilenga dikalingo. Zeremaia bokai ipile: ");
INSERT INTO mva_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Malonga teke Rama anua-lo longora ipura. Itangtang be ilo nge itakoro-tina. Resel ka natu kanabe itangtang. Natu moarunga nge dimate-doi. Bokaibe tago teke iboadu ilo ngaka-uiai.” (Zer 31:15) ");
INSERT INTO mva_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Erot imate nge rai-o Tanepoa ‘enzel’ ne teke Iosep Izip kaba-lo isoaki be ipurakani. ");
INSERT INTO mva_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Be bokai irai, “Gotui be natu-muku tina diaru godoki-diaru be kaba Israel kateka-lo kamamulelakoto. Tamoata maka natu-muku daumoatei kana nge ambe dimate-doi.” ");
INSERT INTO mva_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kodeka Iosep itaguraki be natu-muku tina diaru idoki-diaru be Israel kaba-lo dimulelakoto. ");
INSERT INTO mva_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bong Iosep bokai ilongo Akelas ambe tama Erot kaba idoki be Zudea kaba itanepoadi nge taburi irani be tago ilako be Zudea kaba-lo isoaki. Rai-o be pile ngaedi idoki. Bokaibe Galili kaba-lo ilako, ");
INSERT INTO mva_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","be anua ara Nasaret-lo anua idoki. Iosep bokai imuzi be ‘propet’ pilengadi ngaedi dikalingo. ‘Propet’ bokai dipile, “Ngai masa Nasaret tamoata kana dakilakilai.” ");
INSERT INTO mva_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Alauri nge Zon Baptais ipura be Zudea masaua kaba-lo be tamoata be aine isulesuledi ");
INSERT INTO mva_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","be mangata bokai iraradi, “Ilo-ming kamabuiri be muzigoala neming kamasegeaki! Bong ono Nanaranga ngatanepoa kana ambe isaringa!” ");
INSERT INTO mva_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","‘Propet’ ara Aisaia toira bokainatuka ipile nge Zon ka irangaki. Aisaia bokai ipile: “Malonga teke masaua kaba-lo bokai ikilaulau, ‘Tanepoa zalaka kamamoataungakini. Zala adoadodi kamaemaki be odio ngalale.’” (Ais 40:3) ");
INSERT INTO mva_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zon kusi ne nge ngado aradi ‘kamel’ pulekedi ane ka emakadi dipura. Soa-nao nge angapi ngado aradi ‘bulumakau’ kusidi ane emaka ipura nge inanganangai. Kangkang kana nge oazikezike be kutum-patu damakadi. ");
INSERT INTO mva_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Makara nge tamoata be aine kokoko-tina Zon-lo dilako. Tamoata be aine ngaedi nge Ierusalem anua-lo, be Zudea kaba-lo, be kaba moarunga Zodan zagura zagenao dieno-lo ka ditui be dilako. ");
INSERT INTO mva_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Be muzigoala nedi mangata dirangaki be Zon itaguraki be ruku ono tamalinga ane be Zodan zagura-lo irukudi. ");
INSERT INTO mva_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ata Zon kaba bokai ita ‘Parasi’ be ‘Sadiusi’ kokoko-tina dipura be ruku ono tamalinga ane ngarukudi kana nge pile kaiboangdia-lo bokai iradi, “Kam moata goalakadi ulunga kaoa! Naita ira-kaming kam kaboadu Nanaranga nama ratinga ambe ngapura kana nge kamairatui? ");
INSERT INTO mva_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ilo-ming kabuiri be muzigoala neming kasegeaki nge mangata ma kamaememaki be teadi dapura kam ambe muzigoala neming kasegeaki. ");
INSERT INTO mva_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Be moaki ilo-ming bokai kananga, ‘Abaram nge keka tubuma’ ngena masa moatubu ngaedi kamairatudi? Tago-la! Ngau ka ura-kaming! Nanaranga iboadu patu ngaedi ngadoki be Abaram tubu ne ngapurakidi! ");
INSERT INTO mva_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ogi ambe kai labudia-lo ikatiuana be ieno, be ono kai ziridia-lo poloadialako dapura kana. Kai moarunga kalingodi tago uia dipupuraki masa poloadi be eoa-lo rokakadialako dapura. ");
INSERT INTO mva_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ngau dang ane ka ruku ono tamalinga ane uruku-kaming be ono kaua ngapura kana kam ambe ilo-ming kabuiri be muzigoala neming kasegeaki. Ata murigu nge tamoata teke kaiboang ne ngau kaiboang negu diuasadi nge ngamai kana. Ngau erumaruma-tina! Bokaibe tagona-tina uboadu ae sukuma ne mbazidi. Ngai masa Oli Spirit be eoa ane be ruku ono tamalinga ane ngaruku-kaming. Bakara, Oli Spirit be eoa ka kulubobi. ");
INSERT INTO mva_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Taramang ne ono niu kozoma idokidoki. Masa niu ngakozo be kalingodi ngadoki be kangkang pera nena-lo ngakoazalaki, be zipidi masa eoa tago matemate-lo ngarokakilako.” ");
INSERT INTO mva_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kodeka Iesus Galili kaba-lo ka itui be ipura Zodan zagura-lo be Zon ruku ono tamalinga ane be ngarukui kana. ");
INSERT INTO mva_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ata ono Zon Iesus ngaemaki be ilo takaia nganangai kana nge Zon bokai ipile, “Ngau urere kaiko gorukuia! Ata kaiko ngau-lo kupura.” ");
INSERT INTO mva_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Be Iesus ikatu be bokai ipile, “Kaituka-tina nge ambe kana bokai emakadi dipura. Bokaibe bokaina-la daeno. Moaki tabuiri-ramo. Maka ma bokai tamuzi masa mata adoadodi taemaki be dakalingo.” Iesus bokai ipile nge Zon isumoala. ");
INSERT INTO mva_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Alauri Iesus rukuia ipura nge oaikiki-tina laka-o ituilako. Laka-o ituilako nge lang ono itakakalako be Oli Spirit nge mang bune bokana ibalabala be ite. Bune ngae ibala be Iesus ono itokaria. ");
INSERT INTO mva_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Be malonga teke lang-lo bokai ipile, “Nge Natugu! Ngau urereretakia-tina. Be ilogu iuiatakia-tina.” ");
INSERT INTO mva_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kodeka Oli Spirit ipura be Iesus ibagalako masaua kaba-lo be Satang Iesus ngatoi kana. ");
INSERT INTO mva_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Amaridi kulemoadi oati be oabubudi kulemoadi oati makara iali be isoaki be ambe tole imate. ");
INSERT INTO mva_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kodeka Satang ipura be bokai irai, “Kaiko Nanaranga Natu nge patu ngaedi goradi be kangkang dapura.” ");
INSERT INTO mva_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Be Iesus ikatu be bokai ipile, “Nanaranga ‘Buku’ ne bokai ipile, ‘Tamoata tago masa kangkang-ba ngakangkang be ngasukoaki. Tago. Nanaranga pilenga moarunga ngatagatagadi be ngasukoaki.’” (Diut 8:3) ");
INSERT INTO mva_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kodeka Satang itaguraki be Iesus ibagalako anua rata ara Ierusalem-lo be Nanaranga pera ne atabalanatuka inangai. ");
INSERT INTO mva_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Be bokai irai, “Kaiko Nanaranga Natu nge makare be nem-la be ea kateka-o gorokakikolako. Maka ma Nanaranga ‘Buku’ ne bokai ipile: ‘Nanaranga masa kaiko kanabe ‘enzel’ ne nganepidi be luma-di ane dasabosaboiko. Bokai masa aem-baba tagona-tina patu-o gototoki.’” (Sam 91:11-12) ");
INSERT INTO mva_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Be Iesus ikatu be bokai ipile, “Ata Nanaranga ‘Buku’ ne kababe bokai ipile, ‘Nanaranga nem Tanepoa moaki kutoi.’” (Diut 6:16) ");
INSERT INTO mva_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Alaurituka nge Satang itaguraki be Iesus ibagai be buku teke salagabulina-tinao inangai, be anua be kaba moarunga kateka-o nge itikini. Anua be kaba moarunga kateka-o nge kulang be kaiboang nedia-lo dieno be itikini. ");
INSERT INTO mva_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Be bokai irai, “Tukum-o kurokazokuria be aragu kurakeaki masa kana moarunga ngaedi nge nem miangko.” ");
INSERT INTO mva_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ata Iesus ikatu be bokai ipile, “Satang, goiratu! Nanaranga ‘Buku’ ne bokai ipile, ‘Nanaranga nem Tanepoa-la ka gorakerakeaki be ngaia-la ka gomalipilipini.’” (Diut 6:13) ");
INSERT INTO mva_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kodeka Satang ialale be Nanaranga ‘enzel’ ne dipura be Iesus didumai. ");
INSERT INTO mva_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Bong Iesus bokai ilongo Zon ambe uaura-lo dinangai nge kaba ngaradi ipereki be Galili kaba-lo imulelako. ");
INSERT INTO mva_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ialale nge tago ilako be Nasaret anua-lo isoaki. Ilako be Kaperneam anua-lo isoaki. Anua ngae nge dang boakuboaku kanabiabia ara Galili zagenao ka ieno. Dang kanabiabia nge Zebulun be Naptali kateka-o ka ieno. ");
INSERT INTO mva_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Bokaibe ‘Propet’ ara Aisaia nge pilenga tekedi dikalingo. Aisaia bokai ipile: ");
INSERT INTO mva_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun kateka be Naptali kateka, ege makasi lakoianao, Zodan zagura ege takaianao. Galili kaba nge Ungguma Takadi kaba nedi. ");
INSERT INTO mva_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“Tamoata malama tagongana-lo disukoaki ambe malama kanabiabia teke dite. Tamoata be aine mate-kaba anunukana-lo disukoaki masa malama odio ngabala.” (Ais 9:1-2) ");
INSERT INTO mva_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kodeka bong ngaradia-lo be Iesus pilenga ngaedi mangata ipilepile, “Ilo-ming kamabuiri be muzigoala neming kamasegeaki! Bong ono Nanaranga ngatanepoa kana ambe isaringa!” ");
INSERT INTO mva_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesus dang biabia boakuboaku ara Galili zagenao ialalale nge taritokatoka rua Saimon ara takaia Pita be Endru ite-diaru. Diaru nge raka kandiaru tekena-lo ika didokidokiru, bakara diaru nge ika dokidoki kaoa. ");
INSERT INTO mva_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kodeka Iesus itaguraki be bokai ira-diaru, “Kamamairu! Kamatagaiaru be tamoata dokiadi mitiking-kamingru.” ");
INSERT INTO mva_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Makara nge oaikiki-tina raka kandiaru diperekiru be Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mukuna-la ilako nge kaba taritokatoka rua ara-diaru Zems be Zon ite-diaru. Diaru nge Zebidi natu ruoti. Tama-diaru Zebidi zaiza be kati nediatoi-o disoakito be raka kandiato diolaoladi be Iesus ikila-diaru. ");
INSERT INTO mva_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ikila-diaru nge oaikiki-tina tama-diaru be kati nediato diperekiru be Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesus ege-ege Galili kaba-lo ilakolako be Iuda pera nedi ono serereinga-lo isilisili be Pile Uia bong ono Nanaranga ngatanepoa kana nge mangata irangarangaki. Be more be goala bakarairai-bakarairai nge iadoadoraki. ");
INSERT INTO mva_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bokaibe rangaka nge ege-ege Siria kaba-lo dilako be tamoata more be goala bakarairai-bakarairai odio dieno, be tamoata sururu bibia odio dieno, tamoata mariaba goalakadi dibagabagadi, tamoata zuzudi bokaudi, tamoata aedi be luma-di matedi nge dieluakidia-doi be Iesus iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Bokaibe tamoata be aine dum kokoko-tina Galili kaba-lonalona be ‘Dekapolis’ kaba-lonalona, Ierusalem anua-lonalona, Zudea kaba-lonalona be Zodan zagura ege takanao disukoaki nge Iesus ditagai. ");
INSERT INTO mva_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesus tamoata be aine kokoko-tina dipura be itedi nge buku muku tekenao ilako be zagenao isoakiria. Be tagataga ne dipura be disoakiria. ");
INSERT INTO mva_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kodeka makara be isuledi. Bokai ipile: ");
INSERT INTO mva_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tamoata dikaua Nanaranga mata-nao kana nedi tagotago nge suridi dauia! Bong ono Nanaranga ngatanepoa kana nge tamoata bokainaina nedi! ");
INSERT INTO mva_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Tamoata ilodi dinodonodo be ditangtang nge suridi dauia! Nanaranga masa ilodi ngaka-maliedi. ");
INSERT INTO mva_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Tamoata nedia-la dibabalakidi be malielie-ba disukoaki nge suridi dauia! Kana moarunga kateka-o masa dadoki be danemdi. ");
INSERT INTO mva_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Tamoata dimoatangtang-tina be Nanaranga mata ne adoadodi daememaki kana nge suridi dauia! Nanaranga masa rerengadi ngamambuaki. ");
INSERT INTO mva_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Tamoata maka tamoata takadi ilodi ditagatagadi nge suridi dauia! Nanaranga masa ilo ngatagadi. ");
INSERT INTO mva_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Tamoata ilodia-lo giriki tago teke ieno nge suridi dauia! Di masa Nanaranga date. ");
INSERT INTO mva_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Tamoata anua-uia didokidoki nge suridi dauia! Nanaranga masa natu kana ngarangakidi. ");
INSERT INTO mva_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Tamoata Nanaranga rerenga ditagatagadi be tamoata takadi ditaguraki be sururu dianiandi nge suridi dauia! Bong ono Nanaranga ngatanepoa kana nge tamoata bokainaina nedi. ");
INSERT INTO mva_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Ngau kanabe tamoata takadi diebulo-kaming, ki sururu diang-kaming, ki boli-pile bakarairai-bakarairai ane be mata goalakadi moarunga omingo dinangalako nge suri-ming dauia! ");
INSERT INTO mva_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ilo-ming moaki dibuku! Suri-ming dauia! Bakara, zazanga neming bibia-tina lang anua-lo dieno! ‘Propet’ tongira aro-ming dilako nge bokainatuka-la sururu aniadi dipura.” ");
INSERT INTO mva_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Kam tamoata be aine kateka-o makasi kandi. Ata bong makasi kapisanga daleua masa baituka tabasaki be kaba kapisanga tamuleaki? Makasi bokainaina nge malipi nedi tago. Bokaibe rokakadi dipurapura be tamoata ae-di ane diduaposaposa. ");
INSERT INTO mva_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kam kateka moarunga malama ne. Anua biabia buku-o emaka ipura nge tago iboadu ngakoma. ");
INSERT INTO mva_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Bokainatuka-la, tamoata baratui dibubulai nge tago tabira-baba erumadi dinangananga. Tago. Kadanga-lo dinangananga be tamoata moarunga pera-lo malama dianiandi. ");
INSERT INTO mva_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Be baratui-la ngae bokana, tamoata be aine takadi matadi-o kamamalamalama be muzi uia kamaememaki be daitaita. Bokai masa Tama-ming lang anua-lo isoaki ara darakerakeaki! ");
INSERT INTO mva_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moaki ilo-ming dipile Moses Mata ne be ‘Propet’ gerengadi mgamang be mrokaki kana ka upura. Tago mgamang be mrokaki kana ka upura. Memaki be dakalingo kana ka upura. ");
INSERT INTO mva_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Moimoi ka ura-kaming! Bong lang be kateka daeno nibe ngalako manubungadi-o masa Moses Mata ne nge tagona-tina muku teke ngaleua! Tago be tago-soasoa! Siriki mukumukunatuka, ki gere siriki nedi mukumukunatuka teke tago iboadu ngaleua. Gere ngaedi masa daeno nibe kana moarunga rangakadi dipura nge emakadi dapura be dakalingo. ");
INSERT INTO mva_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bokaibe tamoata naita mata ngaedi ege mukumukunatuka teke ikotoi be idoki be tamoata takadi itikingdi be ngai bokana dimuzi nge masa lang anua-lo ara ngalaurituka. Ata tamoata naita mata ngaedi itagatagadi, be idoki be tamoata takadi itikingdi nge masa lang anua-lo ara biabiatuka. ");
INSERT INTO mva_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngau ka ura-kaming! Muzinga-ming adongadi Parasi be tamoata Moses Mata ne disulesuletaki muzingadi tago diuasadi nge tagona-tina iboadu anua ono Nanaranga ngatanepoa kanana-lo kamasili! ");
INSERT INTO mva_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Toira bokai diradi be kam ambe kalongo, ‘Tamoata takaia moaki kumoatei. (Eks 20:13) Tamoata takaia kumoatei masa giriki nem lilitadi dapura.’ ");
INSERT INTO mva_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ata ngau bokai ura-kaming: Tamoata naita taritoka giriki tagonganaba-lo nama irataki masa giriki ne lilitadi dapura. Tamoata naita taritoka bokai irai, ‘Moangaruru,’ masa Iuda ‘Kansolo’ nedi arodi ngatui. Tamoata naita taritoka bokai irai, ‘Ngaongaom-tina’ masa eoa tago matemate-lo ngalako. ");
INSERT INTO mva_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Bokaibe tabataba nem kueluaki be bagi ono tabataba aninga-o kunanga, ata taritokam teke kamru edua nemingru tekedi ilom iandi nge ");
INSERT INTO mva_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tabataba nem makara bagi ono tabataba aninga aro gonangaria be goalale be taritokam kamru soakinga-mingru kamadorakiru be ono kamaeruangamiru, kodeka gomule be tabataba nem Nanaranga goani. ");
INSERT INTO mva_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tamoata teke ibagaiko be ‘koto’-lo ngalakuakiko kana nge zala-lanalo be pile kamadorakiru be kamaeruangamiru. Pile tago kadorakiru be kaeruangamiru masa tamoata ngae ngaeluakiko be tamoata giriki adoadoraki aro ngatuirakiko. Kodeka tamoata giriki adoadoraki masa ngadokiko be katonga-oaoa luma-nao ngasalangakiko be uaura-lo ngarokakikolako. ");
INSERT INTO mva_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Moimoi ka ura-kaming! Makara uaura-lo gosoaki nibe oti nem moarunga gokatu-doi. ");
INSERT INTO mva_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Toira bokai diradi be kam ambe kalongo, ‘Roti mata moaki kugamani be aine ki moane takaia kurepeki be kaeno-buduru.’ (Eks 20:14) ");
INSERT INTO mva_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Ata ngau bokai ura-kaming! Tamoata naita aine teke matanaba-lo ite be ireretaki be daeno-buduru kana nge ambe roti mata ka igamani be dieno-buduru bokana. Ilonaba-lo ka ipile, ata nge ambe roti mata ka igamani. ");
INSERT INTO mva_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Bokaibe matam oanam-onaona ka iemakiko be muzigoala kuemaki nge gopasiki be gorokaki! Kaniam tekena-la ileua nge iuia. Ere-moarungam be eoa tago matemate-lo kulako nge tagona-tina iuia! ");
INSERT INTO mva_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lumam oanam ka iemakiko be muzigoala kuemaki nge gototoki be gorokaki! Lumam takaia ileua nge iuia. Ere-moarungam be eoa tago matemate-lo kulako nge tagona-tina iuia. ");
INSERT INTO mva_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Toira bokai dipile, ‘Tamoata naita roa ngasegeaki kana nge ‘pepa’ ono roti totoka ngagereti be aine ngani.’ ");
INSERT INTO mva_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ata ngau bokai ura-kaming! Aine nangata roa tago ono imanai, ata moane-ba ka isegeaki be aine kababe iroti nge moane ngae ka aine iemaki be roti mata igamani be moane takaia diaru dieno-buduru. Be moane nangata itaguraki be aine segesegeaki bokainaina iuati nge moane ngae roti mata igamani be aine takaia diaru dieno-buduru! ");
INSERT INTO mva_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Pile takadi tamoata toira diradi be kam ambe kalongo nge bokai, ‘Pile tekedi tamoata ki kana teke aranao be kupile be moimoibe goemaki kana nge goemaki be ngakalingo. Moaki kuboli. Tanepoa aranao be kupile nge kana kurangaki goemakia-soasoa be ngakalingo.’ ");
INSERT INTO mva_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ata ngau bokai ura-kaming! Pile tago tototo kamaemaki kana nge moaki kana teke ara-nao be kaemaki. Moaki-la! Moaki lang anua katugani be ono pile neming kaka-kaidi. Moaki-tina! Lang anua nge Nanaranga bagi ono tanepoanga ne. ");
INSERT INTO mva_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Moaki kateka ara-nao be pile neming kaka-kaidi. Moaki-tina. Kateka nge Nanaranga ae salangaka ne. Moaki Ierusalem ara-nao be pile neming kaka-kaidi. Moaki-tina. Ierusalem nge Anuatanepoa Biabia-tina anua ne. ");
INSERT INTO mva_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Moaki pangana-ming karangaki be ono pile neming kaka-kaidi. Maka ma tago kaboadu donga-ming kamaemaki be daoaoaoa ki dazimzim. ");
INSERT INTO mva_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","‘E!’ kana kapile nge ‘E!’-la kana kamapile. ‘Tago!’ kana kapile nge ‘Tago!’-la kana kamapile. Bakara, pile takadi ono pilenga-ming kababe kamabatadi kana masa Satang-lo dapusika. ");
INSERT INTO mva_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Toira bokai dipile be kam ambe kalongo, ‘Tamoata matam ipasiki nge mata gopasikani. Tamoata ilem ikoto nge ile gokoto.’ ");
INSERT INTO mva_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ata ngau bokai ura-kaming! Tamoata muzinga goalakadi kata bakara ibasakiko nge luma moaki kukatu. Tamoata naita poapoam oanam-o izamposaniko nge gobuiriko be egedi takadi ngazamposa. ");
INSERT INTO mva_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tamoata kata nga‘koto’takiko kana be angapi nem idoki nge malo nem goani be. ");
INSERT INTO mva_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tamoata kata ipura be tago rerengam-lo iakangaoiko be kana ne moatubudi masauakadi kaleti pile-lo ‘mail’ teke goalaleaki kana nge kaiko ‘mail’ rua goalaleaki. ");
INSERT INTO mva_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tamoata teke isinauiko nge kana ireretaki goani. Tamoata teke ipura be isinauiko be kana nem teke ngabagai kana nge luma zokuzoku-ba goani. Moaki kukapangai. ");
INSERT INTO mva_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Toira bokai dipile be kam ambe kalongo, ‘Ruangam gorereretaki be erekei nem gosegesegeaki.’ (Leb 19:18) ");
INSERT INTO mva_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","“Ata ngau bokai ura-kaming! Erekei neming kamarereretakidi, be tamoata sururu dianiang-kaming nge di kanabe Nanaranga kamaraboraboi. ");
INSERT INTO mva_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Bokai kamuzimuzi masa Tama-ming lang anua-lo isoaki natu kamapura. Ngai ka amari iememaki be tamoata uia be tamoata goalakadi malama ianiandi. Be ngai ka ura iememaki be tamoata muzingadi adoadodi be tamoata muzingadi goalakadi odio ibalabala. ");
INSERT INTO mva_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tamoata direreretaki-kamingla karereretakidi masa zazanga uia nangatadi kamadoki? Maka ma tamoata ‘tagisi’ didokidoki bokai dimuzimuzi! ");
INSERT INTO mva_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ruanga-mingla kadumadumadi nge kana oauoau kata kapuraki ki? Nge tago oauoau ka kapuraki! Tamoata Nanaranga pilenga tago ditagatagadi bokai dimuzimuzi! ");
INSERT INTO mva_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Adoado-tina kamasukoaki, Tama-mingla adoado-tina lang anua-lo isoaki bokana. ");
INSERT INTO mva_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Eke! Muzinga-ming adongadi tamoata takadi matadi-o kamaememaki be date-kaming takana! Muzinga-ming bokainaina mangata lili-be-matao kaememaki masa Tama-ming lang anua-lo isoaki zazanga uia tago ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tamoata kana ne tagotago kata kana teke goani kana nge tauru eueuri moaki arom dilako be kutagadi! Muzi bokainaina nge tamoata bolingadi ratadi muzi nedi. Muzi ngaedi nge pera ono serereinga-lo be zala bibia-lo diememaki. Bokai dimuzimuzi be tamoata be aine takadi ditetedi be aradi dirakerakeaki. Moimoi ka ura-kaming! Tamoata bokainaina ambe zazanga nedi ere-moarungadi be didoki-doi. ");
INSERT INTO mva_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tamoata kana ne tagotago kata godumai kana nge lumam oanam rakana iememaki nge ngasim moakina-tina ikaua. ");
INSERT INTO mva_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bokai masa kana tamoata kuiani nge zugumaba-lo ngaeno. Tamoata takadi moakina-tina dikaua. Kana moarunga zuguma-lo emakadi dipurapura nge Tama-ming itaita-doi. Bokai kamuzimuzi masa zazanga neming uia ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Bong Nanaranga karaboraboi nge moaki tamoata bolingadi ratadi diraborabo bokana karaborabo. Zala bibia zagedi-o be pera ono serereinga-lo nge tuitui-ba rabo kana direrere-tina. Bokai dimuzimuzi be ono tamoata be aine moarunga datetedi kana. Moimoi ka ura-kaming! Zazanga nedi ambe ere-moarungadi be didoki-doi. ");
INSERT INTO mva_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ata bong kam kamarabo kana nge pera kanaming-lo kamasili be babaduadua kana-ming kamaono-uia be Tama-ming tago kateate nge kamaraboi. Muzi moarunga komanga-lo emakadi dipurapura nge Tama-ming itaita-doi. Bokai masa zazanga uia ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Bong Nanaranga karaboraboi nge moaki pile kokoko labudi tagotago ane be karabo. Muzi bokainaina nge tamoata Nanaranga pilenga tago ditagatagadi muzi nedi. Ilodi dipilepile pile kokoko daememaki masa Nanaranga ngalongoridi. ");
INSERT INTO mva_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","“Muzingadi moaki katagatagadi. Rakana karere-taki be Tama-ming kamasinaui kana nge ikauatakia-doi mua. Alauri ka kasinaunaui. ");
INSERT INTO mva_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Bokainatuka kamaraborabo: ‘Tama-ma lang anua-lo kusukoaki. Aram ratana-la ngaeneno. ");
INSERT INTO mva_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","‘Bong ono gotanepoa kana nge ngapura-kama. Rerengam lang anua-lo ditagatagadi bokana nge kateka-o datagatagadi. ");
INSERT INTO mva_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‘Kangkang amari ngaena-lonalona goang-kama. ");
INSERT INTO mva_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‘Oti nema gorokakile-kama, tamoata takadi oti nedi kirorokakiledi bokana. ");
INSERT INTO mva_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","‘Moaki toitoi-lo kulakuaki-kama. Ata Satang gorokakale-kama. Bong ono gotanepoa kana, kaiboang, be ara bibia nge nem-doi, be nem-kueno daeneno. Moimoi.’ ");
INSERT INTO mva_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Kamalongo! Tamoata ki aine teke oti ne kam-lo dieno be karokakile masa Tama-ming lang anua-lo oti neming ngarokakile-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ata tamoata be aine takadi oti nedi tago karokakiledi masa Tama-ming lang anua-lo oti neming tagona-tina ngarokakile-kaming! ");
INSERT INTO mva_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Bong kangkang kazirau nge lili-ming moaki nodonodo bokana kaemaki. Muzi bokainaina nge tamoata bolingadi ratadi muzi nedi. Dalalale masa teadi tole matemate bokana dalalale. Tamoata be aine takadi datedi masa dapile-ra tamoata ngaedi kangkang dizirau. Moimoi ka ura-kaming! Tamoata bokainaina ambe zazanga nedi ere-moarungadi be didoki-doi. ");
INSERT INTO mva_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ata bong kam kangkang kazirau nge lili-ming kamasaki be kamabureng uia be donga-ming kamaruati. ");
INSERT INTO mva_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bokai kamuzi masa tamoata be aine takadi tago dakaua kangkang kazirau. Ata Tama-ming tago itaita-la ka ikaua. Kana moarunga zuguma-lo emakadi dipurapura nge Tama-ming itaita-doi. Bokaibe zazanga uia masa ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kana neming uia aburoming-tina nge moaki kateka-o kakakabung. Makare kateka-o nge boaboaziri kana digagamang be kana alu digalagalalai. Be anako babari disaresare be disilisili be dianakonako! ");
INSERT INTO mva_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kana neming uia kamakabung kana nge lang anua-lo kamakabung. Kana makara kabunadi dipurapura nge boaboaziri tago digagamang, be tago digalagalalai. Be anako tago babari disaresare be disilisili be dianakonako. ");
INSERT INTO mva_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kana neming uia aburoming-lonalona dieno kana masa ilo-ming makarana-la daeneno. ");
INSERT INTO mva_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Mata-ming nge koalea neming. Mata-ming uia masa tamoata-ming ere-moarungadio malama daeno. ");
INSERT INTO mva_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mata-ming digoala masa tamoata-mingo oabubu daeno. Malama omingo dieno tago diuia masa teaming daoabubu-tina. Be oabubu ngae masa ngagoala-tina! ");
INSERT INTO mva_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tamoata teke tago iboadu tanepoa rua dududu kandiaru bokana ngasoaki. Takaia masa ngarereretaki be takaia masa ngasegesegeaki. Be takaia masa ngatalatalari be takaia masa ngamurinarinai. Kam tago iboadu Nanaranga be ‘mone’ malipi nedi bong-doi teke kamadokidoki. ");
INSERT INTO mva_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nge bokai ka bokai mra-kaming kana! Kangkang kamakangkang be dang kamasingsing be neming uia kamasoaki kana nge moaki ilo-ming dibukubukutaki. Be rakana kamaokori kana nge moaki ilo-ming dibukutaki. Rakana ka ilo-ming dabukutakia-mua kana? Soakinga-ming be tamoata-ming ki kangkang be kusi kamanangananga ka ilo-ming dabukutaki mua kana? Soakinga-ming be tamoata-ming ka ilo-ming dabukutaki-mua kana! ");
INSERT INTO mva_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mang makatabala diroro kamatedi. Di kangkang tago ditanotano, be tago diuaroeroe, be kangkang tago kangkang pera-lo dikoazakoazalaki. Tago-la! Tama-ming lang anua-lo isoaki ka kangkang ianiandi. Bokaibe Tama-ming masa kam ngailo-bukutaki-kaming mua. Alauri ka mang ngailo-bukutakidi kana. ");
INSERT INTO mva_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Naita teke iboadu soakingana-ba ngailo-bukubukutaki be iboadu barasi ne ono ne iauia ngasoaki kana nge ngaka-salagati? ");
INSERT INTO mva_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Bakara ka kusi kamanangananga kana nge ilo-ming dibukubukutaki? Moare kabukabu purangadi kamaita. Tago dimalipilipi! Kusi nedi tago nedia-la diememaki! ");
INSERT INTO mva_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ata ngau ka ura-kaming! Toira Solomon ngazim ne uia-tina inangananga. Ata ngazim ne malamakadi nge tagona-tina teke moare kabukabu malamakadi iuasadi. ");
INSERT INTO mva_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Siresire nge Nanaranga ka ingazingdi. Siresire kaituka kaitaita ma! Ata zama masa totokadi dapura be eoa-lo rokakadialako dapura. Ilo-ming dipile Nanaranga tago iboadu kusi ngang-kaming be kamaoko ki? Lama unianga-ming disiki-tina! ");
INSERT INTO mva_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ilo-ming moaki bokai dibuku, ‘Masa rakana gakang?’ ki ‘Masa rakana gasing?’ ki ‘Masa rakana gaokori?’ ");
INSERT INTO mva_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ilo-buku ngaedi nge tamoata Nanaranga pilenga tago ditagatagadi nedi. Tama-ming lang anua-lo isoaki ikaua kana moarunga ngaedi nge kareretaki. ");
INSERT INTO mva_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ata bong ono Nanaranga ngatanepoa kana be mata ne adoadodi kamalelei be kamaita mua noko. Alauri masa kana takadi ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bokaibe zama moaki ilo-ming dibukutaki. Zama masa nena-la be ngailo-bukutaki. Amari teke ilo-buku ne nge amarina-la tekena-lo daeno. Moaki zamazama-lo kalakuaki.” ");
INSERT INTO mva_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tamoata takadi giriki nedi moaki kaliliti be kapile digoala. Tamoata takadi giriki nedi kaliliti masa Nanaranga kam giriki neming ngaliliti. ");
INSERT INTO mva_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tamoata takadi giriki nedi kaliliti be baituka karangaki nge masa Nanaranga bokainatuka-la ka ngabasaki-kaming kana. Mata bakarairai katagadi be tamoata takadi giriki nedi kaliliti masa Nanaranga mata-la ngaradi ngatagadi be kam giriki neming ngaliliti. ");
INSERT INTO mva_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Bakara ka robuka mukuna-tina teke taritokam matana-lo ieno nge kute, ata nem matam-lo nge kai mapala biabia tago ilom iani? ");
INSERT INTO mva_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Masa baituka be taritokam bokai gorai, ‘Robuka mukumuku matam-lo mpasiki,’ ata kaiko nem matam-lo nge kai mapala biabia ieno! ");
INSERT INTO mva_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Bolinga-ming ratadi! Kai mapala biabia nem matam-lo gopasiki be kaba goita uia noko taritokam matana-lo robuka mukumuku ieno nge gopasiki. ");
INSERT INTO mva_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kana uia Nanaranga kaiboang ne odio dieno nge moaki keu kandi! Kandi masa damulenaki be dabatotoki-kaming be mukumuku kamapura! Ra neming uia moaki boro arodia-lo karokakilako. Arodi karokakilako masa odio datuilako be daduaposa. ");
INSERT INTO mva_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gosinau masa kana aniam ngapura. Kana golelei masa gote. Babaduadua gopaliti masa ngatakakaniko. ");
INSERT INTO mva_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Maka ma tamoata isinaunau-la masa kana ngadokidoki-la. Tamoata kana ilelelei-la masa ngaitaita-la, be tamoata babaduadua ipalipali-la masa datakakaka-la. ");
INSERT INTO mva_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Kaiko kamoang kata natum ipura be kangkang kana isinauiko masa patu goani ki? Tago! ");
INSERT INTO mva_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ika kana isinauiko masa moata goalaka goani ki? Nge tago! ");
INSERT INTO mva_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Moimoi muzinga-ming ra goalakadi, ata kana uia natu-ming aniadi nge kamang! Bokainatuka-la, bong Tama-ming lang anua-lo isoaki kasinaui masa lumaluma uia bibia-la be ngang-kaming kana! Tago iboadu ngakapangadi! ");
INSERT INTO mva_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Bokaibe kana moarunga-lo nge bokainatuka kamamuzimuzi: Tamoata takadi baituka dababasaki-kaming kana karerere nge kam bokainatuka-la kamababasakidi. Mata ngae ka Moses Mata ne moarunga be ‘Propet’ gerengadi moarunga labudi. ");
INSERT INTO mva_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Babaduadua aoa ugugu-lo kamasili. Maka ma babaduadua ono leuanga nge ilaba-tina be zala ono eoa tago matemate-lo ilako nge ipala-tina! Bokaibe tamoata be aine kokoko-tina zala ngae ditagatagai. ");
INSERT INTO mva_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ata babaduadua ono moauriuri-la soaki-lo ilako nge imukumuku be zalaka iugu-tina. Tamoata be aine teke-tina-teke ka zala ngae diteate. ");
INSERT INTO mva_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Eke! ‘Propet’ bolingadi ratadi kamatetedia-tina uia! Masa ‘sipisipi’ kusidi dananga be dapura, ata ilodia-lo nge keu kabukabu bokana. ");
INSERT INTO mva_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Muzingadiaba-lo masa kamakaua. ‘Uain’ kalingodi tago oakum-o ka dipurapura! Paepae tago kai ragaragadi-o ka dipurapura. Tago-la! ");
INSERT INTO mva_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Bokainatuka-la, kai iauia patu uia ipupuraki. Ata kai goalaka patu goalakadi ipupuraki. ");
INSERT INTO mva_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kai iauia tago iboadu patu goalakadi ngapuraki. Be kai goalaka tago iboadu patu uia ngapuraki. ");
INSERT INTO mva_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kai kalingodi tago uia dipupuraki nge poloadi dipurapura be eoa-lo rokakadialako dipurapura. ");
INSERT INTO mva_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bokaibe ‘propet’ bolingadi ratadi nge muzingadiaba-lo masa kauatakadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Moaki ilo-ming dipile tamoata be aine moarunga ‘Tanepoa! Tanepoa!’ kana dikilakilaia masa bong ono Nanaranga ngatanepoa kanana-lo dasili. Tago-la! Tamoata naita Tama-gu lang anua-lo isukoaki rerenga itagatagadia-la ka masa ngasili. ");
INSERT INTO mva_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bong biabia ono giriki adorakangao masa kokoko-tina bokai dapile, ‘Tanepoa! Tanepoa! Aram-o be Nanaranga pilenga mangata kirangaki. Aram-o be mariaba goalakadi kitaodi be kilala kaiboangdi nem kiemaki.’ ");
INSERT INTO mva_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ata ngau masa tatalari-la ka bokai mradi, ‘Tagona-tina muku ukauataki-kaming! Kamairatu! Kam muzi goalakadi kaememaki!’ ");
INSERT INTO mva_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Bokaibe tamoata pilengagu ngaedi ilongo be idoki be itoatoaki nge tamoata kaua-kaua pera kana ea-ruma patu-o labu inangai be ikeli bokana. ");
INSERT INTO mva_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ura ibala be zagura dirokasapa, be oasa kanabibia dipura be pera ngae dirurukaki. Ata tago itapulo. Maka ma pera ngae labu ono kainga ne nge patu-o ka dieno. ");
INSERT INTO mva_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Tamoata pilengagu ngaedi ilongo be tago itoatoaki nge tamoata ngaongao pera kana kateka-ba kusi-nao ikeli bokana. ");
INSERT INTO mva_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ura ibala be zagura dirokasapa, be oasa kanabibia dipura be pera ngae irurukaki be itapulo. Tapulonga nge digoala-tina!” ");
INSERT INTO mva_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesus kana ngaedi irangaki-doi be tamoata be aine moarunga dilongo nge dipitilaki-tina be dikabaki. ");
INSERT INTO mva_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sulenga ngaedi nge tamoata aradi bibia bokana isuletaki. Tago tamoata nedi Moses Mata ne disulesuletaki bokana pile ngaedi isuletaki. ");
INSERT INTO mva_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesus buku ono isoaki ipereki be itaoio nge tamoata be aine kokoko-tina ditagai. ");
INSERT INTO mva_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Makara nge tamoata teke kikiri dokia ipura be Iesus aro tuku-nao irokazokuria be bokai ipile, “Biabiadi, kusumoala nge bolo oguo dieno gorokaki be mgoaza!” ");
INSERT INTO mva_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kodeka Iesus luma inanaraki be tamoata ngae idoki be bokai ipile, “Ngau usumoala! Gogoaza!” Iesus bokai ipile nge oaikiki-tina kikiri tamoata ngaenao dieno nge dileua be iuia. ");
INSERT INTO mva_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kodeka Iesus itaguraki be tamoata ngae bokai irai, “Golongo! Kana ngae nge moakina-tina teke kurangakani. Ata golako be tamoata Nanaranga ditabatabai teke ngalilitiko. Ililitiko-doi nge goalale be tabataba ono goazanga Moses irangaki nge goemaki be ono moarunga dakaua kaiko ambe moimoi kugoaza.” ");
INSERT INTO mva_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesus ilako be Kaperneam anua-lo isilisili nge Rom tamoata teke koai-bagi nedi teke imuamuadi nge ipura be ngadumai kana be bokai iakoroi, ");
INSERT INTO mva_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Biabiadi, malipilipi kanagu imore-tina be pera-lo ieno. Tapou moarunga dimate-doi be tago iboadu ngamoakusu-ramo. Sururu bibia-tina idokidoki.” ");
INSERT INTO mva_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Be Iesus ikatu be bokai ipile, “Masa mialale be miaka-uiaki.” ");
INSERT INTO mva_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ata tamoata ngae bokai ipile, “Iei, Biabiadi! Ngau tamoata tago iauia kata be masa kaiko kuboadu pera kanagu-lo gosili! Ata gopile-ba be malipilipi negu ngauia. ");
INSERT INTO mva_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Maka ma ngau negu-la nge bibiadi negu erumadi usoaki, be koai-bagi tamoata kokoko ngau erumagu disoaki. Bokaibe ngae bokai mrai, ‘Golako’ be ngalako. Be ngara bokai mrai, ‘Gomai’ be ngamai. Dududu kanagu bokai mrai, ‘Kana ngae goemakana’ be ngaemakana.” ");
INSERT INTO mva_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Bong Iesus pile ngaedi ilongo nge ipitilaki-tina be tamoata be aine ditagatagai bokai iradi, “Moimoi ka ura-kaming! Israel-lo tamoata lama unianga biatangadi bokainaina tago teke ute. ");
INSERT INTO mva_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngau ka ura-kaming! Tamoata be aine kokoko-tina masa ege amari rakeanao be ege amari balaianao be dapura be anua ono Nanaranga ngatanepoa kanana-lo kabadi dadoki be Abaram, Aisak be Zekop zaiza dasoakiria be moanako biabia daemakia-budu. ");
INSERT INTO mva_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ata tamoata maka aradi anua ono Nanaranga ngatanepoa kanana-lo dieno masa eluku malama tagongana-lo rokakadialako dapura. Makara masa datangtang be iledi dakaraposaposa.” ");
INSERT INTO mva_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Kodeka Iesus itaguraki be Rom tamoata bokai irai, “Goalale. Kana kureretaki be lama kuni bokana masa ngapuraniko.” Be bong-la ngaranao nge malipilipi kana iuia. ");
INSERT INTO mva_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iesus ilako Pita pera kanana-lo nge Pita roa tina more kusi-ragogo idoki be bokai zirapu-lo ieno be ite. ");
INSERT INTO mva_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kodeka Iesus ilako be luma idoki be more ileuani, be imarang be kangkang iemakani. ");
INSERT INTO mva_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rairaituka zili-kisikisi bokana nge tamoata be aine ditaguraki be tamoata mariaba goalakadi ilodia-lo disoaki nge kokoko-tina Iesus-lo dieluakidi. Pile-la tekedi ipile be mariaba goalakadi nge itaodi. Be moremore iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Bokai imuzi be pile tekedi ‘propet’ Aisaia ipile nge dikalingo. Aisaia bokai ipile: “Nena-la be goalakingada irokaki, be morengada ibaga be ialale.” (Ais 53:4) ");
INSERT INTO mva_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesus tamoata be aine kokoko-tina diboalingi be itedi nge tagataga ne iradi be dang biabia Galili ege takaianao dalakuaki kana. ");
INSERT INTO mva_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kodeka tamoata Moses Mata ne disulesuletaki teke ipura be Iesus bokai itegi, “‘Tisa!’ Ngau urere ege-ege kulakolako nge mtagatagaiko-la!” ");
INSERT INTO mva_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Be Iesus itaguraki be tamoata ngae bokai irai, “Keu kabukabu boazinga ono enonga nedi dieno. Mang makatabala diroro nge gupadi otioti. Ata Tamoata Natu kaba ono pangana nganangaria be ngamanaua kana nge tago!” ");
INSERT INTO mva_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kodeka tagataga ne teke bokai ipile, “Biabiadi! Golikitaka be mialale be tama-gu mkumraki noko.” ");
INSERT INTO mva_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ata Iesus ikatu be bokai irai, “Gotagaia! Matedi masa nedia-la be mate ruangadi dakumrakidi.” ");
INSERT INTO mva_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kodeka Iesus kati rebareba tekenao ibuli be tagataga ne ditagai be dialale-budu. ");
INSERT INTO mva_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Dang-lo direbareba noko anua-goala teke inangai-ba ka ipura be kati ambe ibubulolo. Ata Iesus-ra ienosoa. ");
INSERT INTO mva_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kodeka tagataga ne dilako be dianguni be bokai dipile, “Tanepoa! Gouketi-kita. Ambe tamoaloba kana.” ");
INSERT INTO mva_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Be Iesus ikatu be bokai ipile, “Kam lama unianga-ming disiki-tina! Bakara ka taburi-ming dira?” Be ituirake be oasa be nugunugu kaikai-la iradi be kodeka malino ibala. ");
INSERT INTO mva_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Moarunga kati-o disoaki kaba bokai dita nge dipitilaki-tina be bokai dipile, “Tamoata ngae nge bakarairai kata? Oasa be nugunugu dilongolongori!” ");
INSERT INTO mva_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesus dang biabia ege takaianao ilako nge Gadara kaba-lo ipura. Makara ipura nge tamoata rua mariaba goalakadi ilodiarua-lo disoaki nge dipurakaniaru. Tamoata ngae-diaru nge buna ono matedi kumrakadi dipurapura-lo ka dipusikaru. Diaru nge gagaragara-tina kaoa. Bokaibe tamoata tago teke iboadu kaba ngaradia-lo ngalako. ");
INSERT INTO mva_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kodeka tamoata ngae-diaru nge kaikai-la dimereru be bokai dipileru, “Nanaranga Natu! Bakara gobasaki-kama kana? Bong nem isi tago dipura! Bakara ka kupuraba-mua be sururu goang-kama kana?” ");
INSERT INTO mva_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kasauba muku nge boro ulunga biabia teke diramomomo be disoaki. ");
INSERT INTO mva_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bokaibe mariaba goalakadi tamoata ruoti ngaediarua-lo disoaki nge Iesus bokai diakoroi, “Gotao-kama kana nge boro ulunga ngarana-lo gonepikamailako.” ");
INSERT INTO mva_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kodeka Iesus bokai iradi, “Kamalako!” Be mariaba goalakadi nge tamoata ruoti ngaedia-lo ka dipusika be dilako boro ulungana-lo disili. Kodeka boro ngaedi nge didupu be ierokateteki be dipananalako melu-o be dang-lo dinokulako be dang dising be dimate. ");
INSERT INTO mva_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tamoata boro diakolakola kaba bokai dita nge dipapanana-la be anua-lo dilako be kana moarunga dipura nge dirangaki. Be tamoata ruoti mariaba goalakadi ilodiarua-lo disoaki kana dipura-diaru nge dirangaki be. ");
INSERT INTO mva_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kodeka anua-marau moarunga anua nedi dipereki be Iesus date kana. Be bong Iesus dipurakani nge bokai diakoroi, “Moaki makare kaba ngaedia-lo kusoaki. Kaba takadia-lo golako.” ");
INSERT INTO mva_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kodeka Iesus kababe kati rebareba-o ibuli be dang biabia Galili ege takaianao ilako be anua-tina nena-lo ipura. ");
INSERT INTO mva_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Makara ipura nge tamoata alu tamoata kaulokuloku teke tapou matedi rara-o be dibazi be dipura. Bong Iesus kaba bokai ita tamoata ngaedi lama diuni ngai iboadu tamoata kaulokuloku ngadoraki nge bokai irai, “Natugu! Taburim moaki ira! Muzigoala nem ambe rokakadi dipura.” ");
INSERT INTO mva_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tamoata Moses Mata ne disulesuletaki alu makara disoaki pile ngaedi dilongo nge nedia-la ilodia-lo bokai dipile, “Tamoata ngae bokai ipile nge suri Nanaranga diaru iriringa-diaru tekedi bokana be Nanaranga iduai!” ");
INSERT INTO mva_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ata Iesus ilodia-lo pile ngaedi italako be ikaua. Be bokai iradi, “Bakara ka mata goalakadi bokainaina ilo-ming dieno? ");
INSERT INTO mva_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pile nangatadi ka emakadi tago dira? ‘Muzigoala nem ambe rokakadi dipura’ ki ‘Gotui be goalale?’ ");
INSERT INTO mva_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ata nge ono mitiking-kaming kana Tamoata Natu kaiboang ne kateka ngaenao dieno be iboadu-tina tamoata be aine moarunga muzigoala nedi ngarokakiledi.” Kodeka tamoata kaulokuloku nge bokai irai, “Gotuirake, zirapu nem godokitate be pera kanam-lo golako.” ");
INSERT INTO mva_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kodeka tamoata ngae itui be pera kanana-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bong tamoata be aine moarunga kaba bokai dita nge aoa-diaba disanganga be dikabaki. Makara nge Nanaranga ara dirakeaki, bakara Nanaranga ambe kaiboang bokainaina tamoata-ramo iandi! ");
INSERT INTO mva_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesus kaba ngaradi ipereki be ialalale nge tamoata teke ‘tagisi’ dokidoki ara Matiu pera ono ‘tagisi’ dokinga-lo isoaki be ite. Kodeka bokai irai, “Gotagaia!” Iesus bokai ipile nge Matiu itui be itagai. ");
INSERT INTO mva_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Alauri Iesus ilako Matiu pera kanana-lo be moanako-lo isoaki nge ‘tagisi’ dokidoki be muzigoala ememaki kokoko dipura be Iesus tagataga ne zaiza disoakiria be dimoanako-budu. ");
INSERT INTO mva_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parasi alu kaba bokai dita nge Iesus tagataga ne bokai diradi, “Bakara ka ‘tisa’ neming ‘tagisi’ dokidoki be tamoata muzigoala ememaki zaiza dimoanakonako?” ");
INSERT INTO mva_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesus pilengadi ngaedi ilongo nge bokai ikatu, “Tamoata nedi uia tago iboadu karai tatate-lo dalako. Moremore-la ka dilakolako. ");
INSERT INTO mva_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ata kamalale be Nanaranga ‘Buku’ nena-lo pile ngaedi labudi kamakauataki, ‘Ngado kudoki be tabataba bokana kuiana nge ngau tago rerengagu. Tamoata takaia ilom ngatagai nge ngau rerengagu.’ Maka ma ngau tago tamoata adoadodi ka mkiladi kana ka upura. Tago. Ngau muzigoala ememaki ka mkiladi kana ka upura.” ");
INSERT INTO mva_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kodeka Zon Baptais tagataga ne dipura be Iesus bokai ditegi, “Nge baituka ka keka be Parasi tagataga nedi kangkang kiziraurau, ata kaiko tagataga nem kangkang tago diziraurau?” ");
INSERT INTO mva_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Be Iesus ikatu be bokai ipile, “Bong tamoata kodeka-ka iroti lou ne zaiza moanako-lo disoaki nge lou ne iboadu kangkang tagotago dasoaki ki tago? Tago iboadu! Ata bong tekedi masa dapura be ono tamoata kodeka-ka iroti nge bagaia ngapura be tago lou ne maradi ngasoaki. Bong ngaradia-lo kodeka lou ne masa kangkang dazirau. ");
INSERT INTO mva_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tamoata tago teke kusi oauoau mapala idoki be ono kusi muamua masarenga ioladi. Maka ma kusi oauoau mapala masa ngatakaka, be kusi muamua kodeka masarenga dalaba-tina kana! ");
INSERT INTO mva_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Bokainatuka-la, tamoata tago teke ‘uain’ oauoau idoki be ‘uain’-kusi muamuana-lo inangalako. Bokai imuzi masa ‘uain’ oauoau ngadodoraki be ‘uain’-kusi muamua ngasereki be ‘uain’ ngamoasubu be ‘uain’-kusi ngagoala. ‘Uain’ oauoau nge ‘uain’-kusi oauoau-lo ka nangadialako dipurapura. Bokai masa ‘uian’ be ‘uian’-kusi uia-la daeno.” ");
INSERT INTO mva_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesus pile ngaedi isi ipilepile-la be Iuda tamoata nedi biabia teke pera ono serereinga nedia-lo imuamua nge ipura be Iesus aro tuku-nao irokazokuria be bokai ipile, “Natugu aineka kaituka-tina ka imate. Ata gomai-ba be lumam ono gonangaria be ngamarang be ne iauia ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kodeka Iesus itui be tamoata ngae itagai, be tagataga ne ditagai be dialale-budu. ");
INSERT INTO mva_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Zala-lo dialalale nge aine teke dara iuni be ambe barasi kulemoa-be-rua iuasadi nge Iesus muri ipura be kusi ne isilisili zagenao idauraki. ");
INSERT INTO mva_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aine ngae ilona-lo bokai ipile, “Kusi-ba nenao mdauraki masa muia.” ");
INSERT INTO mva_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ata Iesus ibuiri be aine ngae ite be bokai irai, “Natugu, taburim moaki ira! Lama uniangam ka iemakiko be kuia!” Be aine ngae nge bong-la ngaranao iuia. ");
INSERT INTO mva_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kodeka Iesus ialale be Iuda tamoata biabia natu aineka imate nge pera kanana-lo ipura. Pera-lo ipura nge gopu eueuri ambe gopu dieueuri be mate rang didokidoki be moarunga makara mate-lo disoaki nge ditangtang be dinaboakiboaki, be ilodi nge dinodo-tina be itedi. ");
INSERT INTO mva_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Be bokai iradi, “Kamapusika! Natu aine ngae nge tago imate. Ngena ieno-ba!” Tamoata be aine moarunga makara disoaki pile ngaedi dilongo nge Iesus dingengeri. ");
INSERT INTO mva_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Alauri tamoata be aine pera-lo disoaki eluku dilako, kodeka Iesus isili be natu aine imate nge luma-nao idauraki, be natu ngae imarang. ");
INSERT INTO mva_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iesus kana ngae bokai iemaki nge rangaka ege-ege kaba ngaradia-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kodeka Iesus kaba ngaradi ipereki be ialale. Ialalale nge tamoata rua mata-diaru leuadi ditagaiaru be dimereru be bokai dipileru, “Debiti Natu, ilom ngataga-kamairu!” ");
INSERT INTO mva_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesus pera-lo isili nge tamoata ruoti ngae-diaru dimairu be Iesus bokai itegi-diaru, “Ilo-mingru dipile ngau uboadu miadoraki-kamingru ki tago?” Be diaru dikaturu be dipileru, “E, Biabiadi, kaiko kuboadu.” ");
INSERT INTO mva_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kodeka matadiarua-lo idaurakilako be bokai ipile, “Lama unianga-mingru ka ngatagai be kana kareretakiaru nge ngapura-kamingru kana.” ");
INSERT INTO mva_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iesus bokai ipile nge mata-diaru ditakaka be kaba ditaru. Kodeka pile kaiboangdi ane bokai ira-diaru, “Kana ngae nge moakina-tina teke karangakaniaru.” ");
INSERT INTO mva_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ata diaru dialaleru be ege-ege kaba ngaradia-lo Iesus dirangakiaru. ");
INSERT INTO mva_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tamoata ruoti ngae-diaru dialalaleru nge kababe tamoata teke pile bebebe Iesus-lo dieluaki. Mariaba goalaka teke tamoata ngaena-lo isoaki. Bokai ka pile ibebe. ");
INSERT INTO mva_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Be bong mariaba goalaka taona ipura nge tamoata pile bebebe nge aoa ikakati be ipilepile. Tamoata be aine makara disoaki kaba bokai dita nge dipitilaki-tina be bokai dikabaki, “Toira be imai kana bokainaina tago teke Israel kaba-lo kite!” ");
INSERT INTO mva_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ata Parasi bokai dipile, “Ngena-ra mariaba goalakadi biabiadi nedi kaiboang nena-lo ka mariaba goalakadi itaotaodi!” ");
INSERT INTO mva_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Makara be kodeka Iesus ege-ege anua bibia-lo be sisiki-lo ilakolako be pera nedi ono serereinga-lo isilisili be Pile Uia bong ono Nanaranga ngatanepoa kana nge isulesuletakadi. Be more be goala bakarairai-bakarairai tamoata be aine odio dieno nge iadoraki. ");
INSERT INTO mva_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tamoata be aine kokoko-tina itedi nge ilo itagadia-tina. Ilodi nge dibuku-ramo be tago dikaua rakana masa daemaki. Di nge ‘sipisipi’ tamadi tagotago bokana disukoaki be tago dikaua naita masa ngamuamuadi. ");
INSERT INTO mva_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kodeka Iesus itaguraki be tagataga ne bokai iradi, “Kangkang kokoko-tina uma-lo ambe dimaure. Ata tamoata kangkang dauaroe kana nge tago dikoko. ");
INSERT INTO mva_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bokaibe kangkang dimaure be dieno nge Tanepoa nedi kamasinaui be masa malipilipi nganepidi be kangkang dauaroe.” ");
INSERT INTO mva_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iesus tagataga ne kulemoa-be-rua ikiladi be disoaki-budu, kodeka kaiboang iandi be mariaba goalakadi iboadu dataodi be more moarunga be goala moarunga iboadu dadoraki. ");
INSERT INTO mva_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Be nge tamoata kulemoa-be-rua ngaedi ka ‘apostel’ ne bokana inangadi. Matamatanatuka Saimon, ara takaia Pita; tari Endru; Zebidi natu Zems taritoka Zon diaru; ");
INSERT INTO mva_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip; Batolomiu; Tomas; Matiu ‘tagisi’ dokidoki; Zems, Alpeas natu; Tadius; ");
INSERT INTO mva_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon maka ‘Zilot’ kata, be Iudas Iskariot. Iudas Iskariot ngae ka alauri Iesus idoki be erekei ne luma-dio inangai. ");
INSERT INTO mva_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bong Iesus tagataga ne kulemoa-be-rua ‘apostel’ bokana inepidi be dalale kana nge bokai iradi, “Ungguma Takadi anua nedi be ungguma Samaria anua nedia-lo moaki kalako. ");
INSERT INTO mva_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","‘Sipisipi’ leuadi Israel-lonalona-lo ka kamalako mua noko. ");
INSERT INTO mva_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kalako nge mangata bokai kamaradi, ‘Bong ono Nanaranga ngatanepoa kana ambe isaringa!’ ");
INSERT INTO mva_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bokaibe kamalale be kana ngaedi kamaemaki: Moremore kamaka-uiakidi; matedi kamamarangakidi be nedi uia dasoaki; kikiri dokiadi kamaka-goazadi, be mariaba goalakadi kamataodi. Kaiboang ngaedi nge luma zokuzoku-ba kadoki. Tago kazazadi. Bokaibe kalale nge kamandia-ba. Moaki zazanga kadoki. ");
INSERT INTO mva_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Mone’ ‘gol’ ki ‘siliua’ ki ‘kapa’ oti ememaki nge moakina-tina teke goate neming-lo kabagabagai. ");
INSERT INTO mva_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Raba sausau, ki ae-sukuma, ki sika ono alalenga nge moaki teke kabagabagai. Kusi silisili moaki karuadi. Bakara, tamoata imalipi nge bubuna ne otioti, be bubuna ne ngaedi nge ania ngapura. ");
INSERT INTO mva_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Anua tekena-lo kapura nge kamalako be tamoata iauia teke iboadu ngadoki-kaming be ngadoraki-kaming nge kamalelei. Kate nge makara sakenao kamasoaki nibe kaba ngaradi kamapereki. ");
INSERT INTO mva_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pera tekena-lo kalako nge pera-marau bokai kamaradi, ‘Ilo-uia kam-lo ngaeno.’ ");
INSERT INTO mva_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Pera-marau dimolataki-kaming be didoki-kaming nge ilo-uia neming ngaenoladi. Dikusi-kaming nge ilo-uia neming kamamuleaki. ");
INSERT INTO mva_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Pera ki anua nangata tago idoki-kaming be iadoraki-kaming ki tago ilongori-kaming nge kaba ngaradi kamapereki be ae-ming gapukadi kamatatai. ");
INSERT INTO mva_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Moimoi ka ura-kaming! Bong biabia ono giriki adorakangao masa anua ki pera bokainaina Nanaranga tagona-tina iboadu ilo ngatagadi. Tago-la. Sodom be Gomora masa muku ilo ngatagadi. Ata anua nangata tago idoki-kaming masa tagona-tina muku ilo ngatagadi.” ");
INSERT INTO mva_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Kamalongo! Ambe ‘sipisipi’ bokana be keu kabukabu maradi unepikaming-lako. Bokaibe mang moane bokana ilo-ming kamalelelenaki noko kana kamaememaki. Ata muzinga-ming moarunga nge malielie-ba bune bokana. ");
INSERT INTO mva_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tamoata kamatetedia-uia! Masa dauauri-kaming be ‘koto’-lo dananga-kaming be pera nedi ono serereinga-lo be darautotoki-kaming. ");
INSERT INTO mva_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngau kanabe masa anuatanepoa be tamoata bibia arodi kamatui. Bokai masa kam mata-ita negu bokana be Pile Uia negu di be Ungguma Takadi mangata kamarangakadi. ");
INSERT INTO mva_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Diuauri-kaming nge moaki taburi-ming dira be ilo-ming bokai kalelenaki, ‘Masa ba gapile? Masa baituka gapile?’ Moaki ilo-ming dibuku. Bong ngaranao masa pile ania-ming dapura. ");
INSERT INTO mva_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Maka ma nge tago kam ka kamapile kana. Tago! Nge Tama-ming Oli Spirit ne ka kam-lo be ngapilepile kana. ");
INSERT INTO mva_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Tamoata alu masa dataguraki be taritokadi dadokidi be tamoata takadi luma-dio danangadi be daumoatedi. Be kamoang masa dataguraki be natudi bokai dabasakidi. Be natu masa kamoang be kipi daerekeidi be tamoata takadi luma-dio danangadi be umoateadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Lili-guo be masa moarunga-tina dasegeaki-kaming. Ata tamoata ngau kanabe ikaiboang be isoaki-la nibe manubunga-nao masa Nanaranga ngauketi. ");
INSERT INTO mva_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Anua tekena-lo sururu diang-kaming nge kamairatu be anua takaiana-lo kamalako. Moimoi ka ura-kaming! Malipi neming masa Israel anua moarunga-lo tagona-la kamamambuaki be Tamoata Natu ngamule. ");
INSERT INTO mva_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Sulesule teke tago iboadu ‘tisa’ ne atabala ngalako. Dududu tago iboadu biabiadi kana atabala ngalako. ");
INSERT INTO mva_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sulesule ‘tisa’ ne bokana ipura nge iuia. Dududu biabiadi ne bokana ipura nge iuia. Bokaibe bokai kamakaua: tamoata teke dara nena-lo ara biabiatuka ‘Bielzebul’ kana dikilai masa dara ne takadi ara goalakadiatina-lo dakiladi. ");
INSERT INTO mva_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Bokaibe tamoata-ramo moaki kamatakuridi. Bakara, kana kukubati masa kakatadi dapura. Be kana komangamanga masa mangata nangadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pile urara-kaming nge oabubu-lo ka ura-kaming. Ata kamalale be ariata kamarangaki. Pile zuguma-lo be dimalongasiki-kaming nge kamalako malala-lo be kamameremere be kamararangaki. ");
INSERT INTO mva_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tamoata daumoate-kaming kana nge moaki kamatakuridi. Maka ma di nge tamoataming-la ka daumoatedi kana. Nanaranga ka kamamatakuri. Bakara, ngai ka tamoata-ming be mariabaka-ming eoa tago matemate-lo be ngaumoate-kaming kana. ");
INSERT INTO mva_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“‘Mone’ daradara tekena-lo iboadu mang-sisiki rua gozazadi. Ata mang-sisiki tagona-tina iboadu teke ne rerenganaba-lo be kateka-o ngasapasiria. Tago-la! Tama-ming ngasumoala masa kateka-o ngasapasiria. Tago isumoala be tago! ");
INSERT INTO mva_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ata kam-ra mang-sisiki kauasadi. Maka ma donga-ming pangana-mingo nge ka teke-teke ambe uareadia-doi dipura! ");
INSERT INTO mva_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Bokaibe taburi-ming moakina-tina dira! Maka ma kam zaza-ming nge mang-sisiki kokoko-tina zazangadi diuasadi! ");
INSERT INTO mva_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tamoata naita lili-be-matao ipile ngai ngau tamoata negu kata masa ngau lang anua-lo Tama-gu lili-be-matanao mpile tamoata ngae nge ngau tamoata negu. ");
INSERT INTO mva_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ata tamoata naita lili-be-matao imurinaia be ipile tago ikauataka masa ngau lang anua-lo Tama-gu lili-be-matanao mrai tamoata ngae tago ukauataki. ");
INSERT INTO mva_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Moaki ilo-ming dipile anua-uia kateka ngaenao mdoki kana ka upura. Tago-la! Tago anua-uia ka ueluaki, asi ono eunga ka ueluaki. ");
INSERT INTO mva_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Labu ono asi ono eunga ueluaki nge bokai: ‘Natu moane masa tamadi daerekeikeidi, be natu aine masa tinadi daerekeikeidi. Aine rotiroti masa rauadi ainekadi daerekeikeidi. ");
INSERT INTO mva_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tamoata erekei-tina ne nge tamoata be aine pera tekena-lo disukoaki-budu.’ (Mai 7:6) ");
INSERT INTO mva_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Tamoata naita tina be tama ireretakidia-tina be ngau tago, nge ngau tago ikonaia. Tamoata naita natu moane ki aine ireretakidia-tina be ngau tago, nge tagona-tina ikonaia be tago iboadu tagataga negu ngapura. ");
INSERT INTO mva_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tamoata kai kapalapala uauau ne tago ibazi, nge tago ikonaia be tago iboadu ngatagaia. ");
INSERT INTO mva_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tamoata naita irere moauriuri-la ngasoaki kana masa ngaleua. Ata tamoata naita ngau kanabe imate masa moauriuri-la ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tamoata naita idoki-kaming be iadoraki-kaming nge ngau ka idoka be iadoraka. Be tamoata ngau idoka be iadoraka nge ngau nepinepi negu ka idoki be iadoraki. ");
INSERT INTO mva_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tamoata naita itaguraki be ‘propet’ kata idoki be iadoraki, bakara ngai ‘propet’ kata masa ‘propet’ zazanga nedi ngadoki. Tamoata naita itaguraki be ‘tamoata adoado’ kata idoki be iadoraki, bakara ngai tamoata adoado kata masa tamoata adoadodi zazanga nedi ngadoki. ");
INSERT INTO mva_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Be tamoata naita itaguraki be tagataga negu ara tagotago-tina kata dang mukuna-tina iani be ising nge ngau ka uraka-ming zazanga ne tagona-tina iboadu daleua!” ");
INSERT INTO mva_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesus tagataga ne kulemoa-be-rua pile ngaedi iradia-doi kodeka ialale be anua makara saringa dieno Galili kaba-lo isulesule be Nanaranga pilenga mangata irarangaki be ialalale. ");
INSERT INTO mva_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zon Baptais nge uaura-lo isoaki be Kristus malipinga ilongoraki. Bokaibe tagataga ne alu inepidi be Iesus-lo dilako ");
INSERT INTO mva_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","be bokai ditegi, “Gora-kama! Kaiko ka toira rangakam ipura be gopura kana ki takaia garapungi?” ");
INSERT INTO mva_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Be Iesus ikatu be bokai ipile, “Kamamule Zon-lo be pile kalongo be kana kaita nge kamarangakini. ");
INSERT INTO mva_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bokai kamarai: Matadi leuadi ambe kaba ditaita, aedi matedi ambe diuia be dialalale, kikiri dokiadi ambe digoaza, kungizadi ambe pile dilongolongo, matedi ambe dimarang be nedi uia disoaki, be tamoata kana nedi tagotago ambe Nanaranga Pile Uia ne dilongo. ");
INSERT INTO mva_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tamoata naita ngau tago ilo-ruataka nge suri dauia!” ");
INSERT INTO mva_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zon tagataga ne ambe dialalale nge Iesus itaguraki be Zon bokainatuka tamoata be aine moarunga irangakadi, “Bong Zon lulu kaba-lo kamate kana be kalako nge rakana-tina kata ka kamate kana ilo-ming dipile? Lulua kata oasa ieueuri ka kamate kana ka kalako ki rakana? ");
INSERT INTO mva_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tago lulua nge rakana-tina kata ka kamate kana ka kalako? Masa tamoata kusi be ngazim uia inangananga kata ka kamate kana ka kalako? Tago-la! Kusi uia be ngazim uia nangananga nge anuatanepoa bibia pera kandia-lo ka disukoaki. ");
INSERT INTO mva_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kamaraia! Rakana-tina ka kamate kana ka kalale? ‘Propet’ kata ki? E! Moimoi ka ura-kaming! Kana kate nge tago ‘propet’-la kata ka kate. Kana kate ngara nge ‘propet’ kata, be kababe atabala-tina be iuasa-tina. ");
INSERT INTO mva_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Maka ma Nanaranga ‘Buku’ nena-lo nge Zon ka bokai rangaka ipura: ‘Ngau masa pile eleluaki negu teke mnepi be arom ngamua. Ngai ka zalakam ngauasari be ngamua be gotagai kana.’ (Mal 3:1) ");
INSERT INTO mva_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Moimoi ka ura-kaming! Tamoata moarunga kateka-o nekiakadi dipura toira be imai nge Zon Baptais iuasadi be ara ilaba-tina! Ata tamoata naita bong ono Nanaranga ngatanepoa kanana-lo ara ialaurituka nge Zon iuasai be ara atabala-tina ieno. ");
INSERT INTO mva_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bong Zon matamatanatuka pile ne isuletaki nibe imai kaituka nge bong ono Nanaranga ngatanepoa kana ambe pangana izelekia-la be ilako-la be ieno. Be tamoata panganadi patu bokana ambe didoki-reperepeki. ");
INSERT INTO mva_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bakara, Moses be ‘Propet’ moarunga nge pile mumuakadi dipilepile nibe imai Zon-lo daga. ");
INSERT INTO mva_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Bokaibe pilengadi digere moimoi kana kapile be kadoki nge bokai kamalongo: Zon nge moimoi be Ilaiza. Toira be rangaka ipura ngai masa ngapura mua. ");
INSERT INTO mva_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kungi-ming otioti nge pile kamalongo! ");
INSERT INTO mva_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tamoata be aine bong ngaedia-lonalona masa rakana oti mtonangadi? Di nge natu-muku malala-lo digong-gong bokana. Uko teke ruangadi takadi dikiladi be bokai diradi: ");
INSERT INTO mva_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Oagu kipali-kaming, ata tago kaoagu. Mate rang kidoki-kaming, ata tago katang.’ ");
INSERT INTO mva_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","“Maka ma bong Zon ipura be kangkang be ‘uain’ izirau nge moarunga bokai dirangaki, ‘Mariaba goalaka ilona-lo isoaki.’ ");
INSERT INTO mva_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ata bong Tamoata Natu ipura be imoanakonako be ‘uain’ isingsing nge bokai dirangaki, ‘Tamoata ngae kamate! Moanakonga be dilaba-tina, be ‘uain’ isingsing! Ngai ‘tagisi’ dokidoki be muzigoala ememaki ruangadi.’ Ata Nanaranga ambe malipinganaba-lo be kaba bokai taita Nanaranga kauanga malaidi nge moimoi be kalingodi.” ");
INSERT INTO mva_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kodeka Iesus itaguraki be anua maka kilala ne kaiboangdi kokoko-tina iemaki kanana-lo nge iauadi, bakara anua-marau ilodi tago dibuiri be muzigoala nedi disegeaki. Bokai iauadi, ");
INSERT INTO mva_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ue! Kaiko Korazin anua. Kumakadoma-tina! Abe-ma kuleua-re! Ue! Kaiko Betsaida anua. Kumakadoma-tina! Abe-ma kuleua-re! Kilala kaiboangdi kam-lo uemaki Taia anua be Saidon anua-lo memaki bokana nge ambe norane be ngado kusi dananga be apoang-lo dasoaki be ono kaua ngapura di ambe ilodi dibuiri be muzigoala nedi disegeaki. ");
INSERT INTO mva_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngau ka ura-kaming! Bong biabia ono giriki adorakangao masa Nanaranga Taia be Saidon ilo muku ngatagadi, ata kam masa tagona-tina muku ilo ngataga-kaming! ");
INSERT INTO mva_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Be kaiko Kaperneam nge nem-la be lang-lo gokautakingakiko kana! Tagona-tina kuboadu! Eoa tago matemate-lo rokakamlako ngapura kana! Kilala kaiboangdi kaituka kaiko-lo emakadi dipura tongira Sodom anua-lo emakadi dapura bokana nge ambe Sodom anua kaituka ngaeno-la. Tago ngaleua. ");
INSERT INTO mva_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngau ka urakaming! Bong biabia ono giriki adorakangao masa Nanaranga Sodom anua ilo muku ngatagai. Ata kaiko Kaperneam masa tagona-tina muku ilo ngatagaiko!” ");
INSERT INTO mva_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bong ngaradia-lo be Iesus bokai ipile, “Mamo! Kaiko ka lang be kateka Tanepoa nedi. Kana ngaedi nge tamoata kauakauadi be tamoata sule-lo dilako tago kuitikingdi. Ata natu mukumukudia-tina nge mangata kuitikingdi. Bokai kumuzi be uperuiko-tina! ");
INSERT INTO mva_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Mamo! Moimoi be kana ngaedi nge rerengam-tina-lo be suri-uiatina nem-lo ka kuemaki. ");
INSERT INTO mva_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kana moarunga ambe Tama-gu lumagu-o isalangaki. Maka ma tamoata tago teke Natu ikauataki. Tama-la ka Natu ikauataki. Be bokainatuka-la, tamoata tago teke Tama ikauataki. Natu-la ka Tama ikauataki. Ata tamoata be aine nangatadi Natu ireretakidia-la ka masa Natu ngataguraki be Tama mangata ngaitikingdi. ");
INSERT INTO mva_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kaiko naita malipi kaiboangdi kudokidoki be kana moatubudi kubazibazi be kumamalo-tina nge ngau-lo gomai be manaua miangko. ");
INSERT INTO mva_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Suku ono moatubu bazinga negu godoki be omo gonangaria, be sule oguo godoki. Maka ma ngau muzingagu nge malielie-ba be uia-ba, be ilogu-lo be negu-la ubalabalaka. Bokaibe ngau-lo ka manaua uia goita kana. ");
INSERT INTO mva_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Maka ma suku ngau miangko be ono kana gobazidi kana nge tago imoatubu, be kana moatubudi omo mnanga kana nge baziadi tago dira!” ");
INSERT INTO mva_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Bong ngaradia-lo nge Iesus bong ono manauanga ‘Sabat’-o ‘uit’ uma-lo ialalale. Tagataga ne nge tole dimate be ‘uit’ kalingodi didoki be patudi dipasipasi be dikangkang. ");
INSERT INTO mva_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parasi kaba bokai dita nge Iesus bokai dirai, “Kaba goita! Bakara ka tagataga nem bokai dimuzimuzi? Mata neda dibabari-kita tago iboadu bong ono manauanga ‘Sabat’-o bokai damuzi!” ");
INSERT INTO mva_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Be Iesus ikatu be bokai ipile, “Bong Debiti tamoata ne zaiza tole dimate be kana Debiti iemaki masa tago sesu kaleze? ");
INSERT INTO mva_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Debiti ilako Nanaranga pera nena-lo be ‘bereti’ ambe Nanaranga ditabangakini nge idoki be ruanga zaiza dikang. ‘Bereti’ ambe Nanaranga tabangakadiani dipura nge mata neda ibabari tagona-tina iboadu di dakang! Tamoata Nanaranga ditabatabaia-la ka iboadu dakang. ");
INSERT INTO mva_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Be kana takaia nge bokai: Moses Mata nena-lo pile ngaedi kaleze ki tago? Tamoata Nanaranga ditabatabai bong ono manauanga-o Nanaranga pera nena-lo disilisili nge ‘Sabat’ mata ne ka dikotokotoi. Bokai dimuzimuzi nge giriki nedi tago! ");
INSERT INTO mva_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ata ngau bokai ura-kaming! Tamoata teke makare isoaki nge ara ilaba-tina be Nanaranga pera ne iuasai. ");
INSERT INTO mva_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Maka ma Nanaranga ‘Buku’ ne bokai ipile, ‘Ngado kudoki be tabataba bokana kuiana nge ngau tago rerengagu. Tamoata takaia ilom ngatagai nge ka rerengagu.’ (Osea 6:6) Bokaibe pile ngaedi labudi kamakauataki bokana nge ambe tamoata girikidi tagotago moatubu tago kamandi. ");
INSERT INTO mva_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bakara, Tamoata Natu ka bong ono manauanga ‘Sabat’ nge Tanepoa ne.” ");
INSERT INTO mva_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kodeka Iesus kaba ngaradi ipereki be Iuda pera nedi ono serereinga-lo isili. ");
INSERT INTO mva_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tamoata teke luma takaia mate nge makara isoaki. Tamoata alu makara disoaki nge zala dilelelei be ono Iesus datoi be giriki ono danangalako kana. Be bokai ditegi, “Mata neda teke isumoala ki tago moremore iboadu bong ono manauanga-o aka-uiaka ngapura?” ");
INSERT INTO mva_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Be Iesus ikatu be ipile, “Tamoata tekem ‘sipisipi’ nem teke bong ono manauanga-o be gimoa-lo isapasilako masa golako be gopasiki ki tago? ");
INSERT INTO mva_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tamoata ka ara biabia be ‘sipisipi’ iuasai! Bokaibe mata neda iboadu tatagadi be bong ono manauanga ‘Sabat’-o nge tamoata muzi uia taemakini!” ");
INSERT INTO mva_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kodeka Iesus itaguraki be tamoata luma takaia mate nge bokai irai, “Lumam gonanaraki!” Tamoata ngae luma inanaraki nge luma takaia bokana iuiani. ");
INSERT INTO mva_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ata Parasi dialale be diraba be Iesus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bong Iesus bokai ilongo daumoatei kana nge kaba ngaradi ipereki be ialale. Be tamoata be aine nge kokoko-tina ditagai. Be moremore dieluakidi nge moarunga-doi iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Moremore iadorakidi nge pile kaiboangdia-lo be bokai iradi, “Moakina-tina tamoata takadi karadi.” ");
INSERT INTO mva_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Bokai imuzi be ‘Propet’ ara Aisaia nge pilenga dikalingo. Aisaia bokai ipile: ");
INSERT INTO mva_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Malipilipi kanagu negu-la be unangai nge maka. Ureretakia-tina be ilogu iuiatakia-tina. Oli Spirit negu masa onao mnangaria. Be muzi negu adoadodi masa ungguma takadia-lo ngalakuaki. ");
INSERT INTO mva_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ata tago iboadu ngare-sabaridi ki kaikai-la ngameredi. Tago-la. Tago iboadu malala bibia-lo ngameremere be ngapilepile. ");
INSERT INTO mva_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Lulua muku imakoto be ieno tago iboadu ngakingkotoi. Koalea ikarakara be ambe saringatuka ngamate kana nge tago iboadu ngaumoatei. Ngai masa ngamuamua-la nibe mata adoadodi ngaemaki be dakai be dauasa. ");
INSERT INTO mva_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Be tamoata moarunga be ungguma moarunga masa ngai ono dakai be darapurapu.” (Ais 42:1-4) ");
INSERT INTO mva_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kodeka tamoata alu tamoata teke mata leuadi Iesus-lo dieluaki. Tamoata ngae nge mariaba goalaka teke ilona-lo isoaki. Bokaibe pile ibebe. Kodeka Iesus itaguraki be tamoata ngae iadoraki be mata diuia be aoa itakaka be ipilepile. ");
INSERT INTO mva_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tamoata be aine moarunga makara disoaki kaba bokai dita nge dipitilaki-tina be bokai dipile, “Nge ka Debiti Natu ki taila?” ");
INSERT INTO mva_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ata Parasi pile ngaedi dilongo nge bokai dipile, “Mariaba goalakadi biabiadi nedi ara Bielzebul kaiboang nena-lo ka mariaba goalakadi itaotaodi.” ");
INSERT INTO mva_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ata Iesus ilodi ikauataki be bokai iradi, “Ungguma teke dienegei be nedia-la dieunung masa ara-be-leuanga dadoki. Anua ki tubu teke dienegei be nedia-la dieunung masa tago dasoaki-salaga. ");
INSERT INTO mva_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satang itaguraki be nena-la itaoni be inegea-ramo nge ne ka iemaki be nena-la iduaduai. Bokai nge masa baituka be anua ne ngakai? ");
INSERT INTO mva_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kam kapile Bielzebul kaiboang nena-lo ka mariaba goalakadi utaotaodi ki? Aria, kamaraia! Naita ka tagataga neming kaiboang iandi be mariaba goalakadi ditaotaodi? Tagataga neming kana diememaki nge kamaita be masa kamakaua kam moangi be boliboli! ");
INSERT INTO mva_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ata kam bokai kakaua ngau Nanaranga Oli Spirit ne kaiboang nena-lo ka mariaba goalakadi utaotaodi nge bong ono Nanaranga ngatanepoa kana ambe ipuraka-kaming! ");
INSERT INTO mva_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Tamoata tago teke iboadu tamoata teke kaiboangi pera kanana-lo ngalako be kana ne nganakoaki. Tago-tina. Ngalako be ngauauri noko pera kanana-lo nganako. ");
INSERT INTO mva_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tamoata tago iruangama nge moimoi be ierekeia. Tamoata tago idumaia be kana kibudinakiru nge ngaia-tina ka kana iraramoaki. ");
INSERT INTO mva_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bokai ka ngau bokai ura-kaming: Tamoata nangata muzigoala ki pile goalakadi iemaki nge iboadu giriki ne ngae rokaka-le ngapura. Ata tamoata naita pile-goala ane Oli Spirit iebuloi nge tagona-tina iboadu muzigoala ne ngae rokakale ngapura! Tago be tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tamoata naita Tamoata Natu pile goala-lo iebuloi masa giriki ne ngae rokakale ngapura. Ata tamoata naita pile-goala ane Oli Spirit iebuloi nge muzigoala ne ngae tagona-tina iboadu kaituka ki alauri rokaka-le ngapura. Tago be tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Kai iauia masa patu uia ngapupuraki. Kai goalaka masa patu goalakadi ngapupuraki. Kai patu-nalo ka masa kauataka ngapura. ");
INSERT INTO mva_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kam moata elu! Iloming-lo muzigoala dikauri masa baituka be pile uia kamapile? Kana iloming-lo dikauri ka aoaming-lo dipusikasika. ");
INSERT INTO mva_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tamoata iauia pile uia ilona-lo inangananga. Bokaibe pile-la uia ka ipilepile. Tamoata goalaka nge pile goalakadi ilona-lo dikauri. Bokaibe pile goalakadia-la ka ipilepile. ");
INSERT INTO mva_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ngau ka ura-kaming! Bong biabia ono giriki adorakangao masa pile tago uia ramoramo-ba tamoata ki aine teke-teke dipile masa Nanaranga darai. ");
INSERT INTO mva_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Maka ma Nanaranga masa pilengam-la ka ngatagadi be ngapile giriki nem tago, be pilengam-la ka ngatagadi be giriki omo nganangalako kana.” ");
INSERT INTO mva_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kodeka Parasi be tamoata Moses Mata ne disulesuletaki alu ditaguraki be Iesus bokai ditegi, “‘Tisa!’ Keka kirere kilala kaiboangdi Nanaranga-la iboadu ngaemaki nge teke goemaki be gate.” ");
INSERT INTO mva_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Be Iesus ikatu be bokai ipile, “Kam tamoata be aine bong ngaedia-lonalona nge muzinga-ming goalakadi. Muzinga-ming nge aine roa ono ngamanainai bokana! Kam kilala kaiboangi teke lang anua-lonalona kareretaki ki? Tagona-tina iboadu kilala bokainaina teke memaki! Kilala maka ‘Propet’ ara Zona emakani ipura-la ka masa kamate. ");
INSERT INTO mva_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Toira-la Zona amaridi toli be oabubudi toli ika ilona-lo ieno bokana, Tamoata Natu masa amaridi toli be oabubudi toli kateka ilona-lo ngaeno. ");
INSERT INTO mva_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bokaibe alauri bong biabia ono giriki adorakangao masa Ninibe dataguraki be datunuri-kaming be giriki omingo danangalako. Bakara, bong Zona Ninibe anua-lo ilako be Nanaranga pilenga mangata iradi nge ilodi dibuiri be muzigoala nedi disegeaki. Ata moimoi ka ura-kaming! Tamoata teke makare isoaki nge Zona iuasai. ");
INSERT INTO mva_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Alauri bong biabia ono giriki adorakangao masa Siba moaede kandi ngatuirake be tamoata be aine kaituka kasoaki nge ngatunuri-kaming be giriki omingo nganangalako. Maka ma moaede ngae nge kateka buru ege takaianao ka itui be ipura be Solomon kauanga malaidi isuletaki be ilongo. Ata tamoata teke kaituka makare isoaki nge Solomon iuasai! ");
INSERT INTO mva_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Bong ‘mariaba goalaka’ tamoata ipereki masa ngalale be kaba baradegadia-lo be kaba ono manauanga ngalelei. Kaba ono manauanga tago teke ite ");
INSERT INTO mva_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","masa nena-la bokai ngarai, ‘Kaba be pera kanagu-lo mule.’ Ngamule masa pera ubana-ba ngaeno be ngate. Pera ilo nge roroia ngapura be ngagoaza-tina be kana moarunga pera-lo nge adoado daeno be ngamule. ");
INSERT INTO mva_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kodeka ngalale be mariaba goalakadi muzingadi goalakingadi ngai diuasai nge lima-rua ngabagadi be pera ngae ilona-lo dasili be makara dasukoaki. Be tamoata ngae kodeka masa muzinga dagoala-tina. Muzi bokainaina masa tamoata be aine muzinga-ming goalakadi bong ngaedia-lo kasoaki nge dapura-kaming.” ");
INSERT INTO mva_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesus isi tamoata be aine isulesule-ladi be tina be taritoka dipura be dapile-budu kana be eluku dituitui.  ");
INSERT INTO mva_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kodeka tamoata teke Iesus bokai irai, “Tinam be taritokam kamapile-budu kana direre be eluku dituitui.” ");
INSERT INTO mva_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Be Iesus ikatu be bokai ipile, “Tinagu naita? Naita ka taritokagu?” ");
INSERT INTO mva_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kodeka tagataga ne itunuridi be bokai ipile, “Ngaedi ka tinagu be taritokagu! ");
INSERT INTO mva_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tamoata naita Tama-gu lang anua-lo isoaki rerenga itagatagadi ka taritoka-gu, marau-gu be tina-gu.” ");
INSERT INTO mva_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Amarina-la ngaranao be Iesus pera ono isoaki nge ipereki be ilako dang biabia Galili zagenao isoaki. ");
INSERT INTO mva_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tamoata be aine kokoko-tina dipura be diboalingi bokana kati tekenao ibulilako be ilona-lo isoaki. Be tamoata be aine moarunga dipura nge kabu-lo dituitui. ");
INSERT INTO mva_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Be pile ono tonanga ane be kana kokoko-tina irangakidi. Bokai ipile, “Tamoata kangkang tanotano teke ialale uma kanana-lo kangkang-patu iliki. ");
INSERT INTO mva_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bong ilikiliki nge kangkang-patu alu zala muku ono alalenga-lo disapasiria, be mang dipura be dikang. ");
INSERT INTO mva_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aludi kateka garaparapanao disapasiria. Makara nge kateka tago imatoli. Moimoi oaikiki-la be didula, ");
INSERT INTO mva_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ata ziridi tago ditaoio-tina. Bokaibe bong amari ikai nge imoamoapoato be dimarango. ");
INSERT INTO mva_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aludi moamoaesa be siresire maradi disapasilako. Bokaibe siresire be moamoaesa dilaba nge kangkang-patu didula nge disukumdi be dileua. ");
INSERT INTO mva_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ata aludi nge kateka iauia-o disapasiria be dilaba be kangkang dipuraki. Aludi kalingodi tamoatadi-lima moarunga dipuraki, aludi tamoatadi-toli dipuraki, be aludi kalingodi kulemoadi toli dipuraki.” ");
INSERT INTO mva_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pile ngaedi ono ngamambuaki kana nge Iesus bokai ipile, “Kungi-ming otioti nge kamalongo.” ");
INSERT INTO mva_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kodeka tagataga ne dipura be bokai ditegi, “Bakara ka pile ono tonanga ane be kusulesuledi?” ");
INSERT INTO mva_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Be Iesus ikatu be bokai ipile, “Bong ono Nanaranga ngatanepoa kana labu sikita kauataka nge ambe kam ania-ming ipura. Ata di tago. ");
INSERT INTO mva_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bokaibe tamoata kana ne otioti masa kaba kokoko-la be ania ngapura, be dakoko-tinani be bagabaga darai. Ata tamoata kana ne tago masa dokiadia-le dapura. Kana nena-ra tago kokoko, ata masa dokiadia-le dapura. ");
INSERT INTO mva_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bakara ka pile ono tonanga ane be usulesuledi nge labu bokai: “Moimoi matadi kaba ditaita, ata kana tago teke dite. Moimoi kungidi dilongolongo, ata pile tago teke dilongo ki labu dikauataki. ");
INSERT INTO mva_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Bokaibe Aisaia pilenga mumuakadi ngaedi nge di diemaki be dikalingo: ‘Kam masa pile kamalongo be kamalongolongo, ata masa pile labudi tago kamakauataki. Kaba masa kamaita be kamaitaita, ata masa kana tago teke kamate be kamakilalangi. ");
INSERT INTO mva_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bakara, tamoata ngaedi ambe panganadi dingao-ramo. Kungidi ambe diono. Be matadi ambe dikotoaki. Tago bokana nge ambe matadi kaba daitaita; kungidi dalongo be ilodia-lo be pile labudi dakauataki, be ngau-lo damai be miaka-uiakidi.’ (Ais 6:9-10) ");
INSERT INTO mva_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ata kam kauia-tina! Mata-ming kaba dita be kungi-ming pile dilongo. ");
INSERT INTO mva_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Moimoina-tina ka ura-kaming! ‘Propet’ be tamoata uia kokoko-tina kana kam kaitaita nge daita-tina kana direre, ata tago dita. Pile kam kalongolongo nge dalongo-tina kana direre, ata tago dilongo. ");
INSERT INTO mva_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kamalongolongo be masa tamoata uma-lo kangkang-patu ilikiliki labu kamakauataki. ");
INSERT INTO mva_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tamoata bong ono Nanaranga ngatanepoa kana dilongoraki be pile labudi tago dikaua nge kangkang-patudi zala mukuna-lo disapasi bokana. Satang oaikiki-la be ipura be pile Nanaranga ilodia-lo inanga nge idokiledi. ");
INSERT INTO mva_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kateka garaparapa-nao disapasiria nge tamoata maka Nanaranga pilenga dilongo be oaikiki-tina suri-uia-lo be didoki bokana. ");
INSERT INTO mva_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ata tamoata bokainaina nge ziridi tagotago be soakingadi tago disalaga. Bokaibe giriki be moatubu bibia Pile Uia ara-nao be dapura masa oaikiki-tina dasege be dairatu. ");
INSERT INTO mva_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Siresire be moamoaesa-lo dibala nge tamoata pile dilongo bokana. Ata kana ono moauriuri dasukoaki kana nge ilodi dibukubukutaki, be ‘mone’ be kateka kana ono suri uianga nge direreretaki-tina. Bokaibe kana direreretaki ngaedi ka Nanaranga pilenga dikubati be kangkang tago dipuraki. ");
INSERT INTO mva_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kateka iauia-o dibala nge tamoata pile dilongo be labudi dikauataki bokana. Tamoata bokainaina ka kangkang dipupuraki. Alu kangkang tamoatadi-lima dipuraki, aludi tamoatadi toli dipuraki, be aludi kulemoadi toli dipuraki.” ");
INSERT INTO mva_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Kodeka Iesus pile ono tonanga takadi bokai ipile, “Bong ono Nanaranga ngatanepoa kana nge bokainatuka. Tamoata teke ilako be uma kanana-lo kangkang-patu uia iliki. ");
INSERT INTO mva_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Oabubu tekena-lo moarungabiabia dieno nge uma-marau erekei ne ipura be kangkang-patudi uia maradi nge siresire iliki. ");
INSERT INTO mva_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kangkang dilaba be dirobu nge siresire ambe didula. ");
INSERT INTO mva_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Kodeka uma-marau malipilipi ne dipura be bokai ditegi, ‘Biabiadi, kangkang-patu uia ka uma-lo kuliki. Siresire inanga ka dipura?’ ");
INSERT INTO mva_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Be ngai ikatu be bokai ipile, ‘Erekei kata ka bokai imuzi.’ “Be malipilipi ne bokai dipile, ‘Galako be siresire gatate ki moaki?’ ");
INSERT INTO mva_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ata uma-marau ikatu be bokai ipile, ‘Moaki katate. Siresire kamatatate masa kangkang zaiza be kamatate-budu takana. ");
INSERT INTO mva_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kangkang be siresire dalabalaba-budu nibe kangkang damaure. Kodeka bong ono uaroenga-lo masa tamoata kangkang diuaroeroe bokai mradi, “Siresire kamatate-mua be bidana-lo kamauau be eoa-lo kamarokakilako. Alauri nge kangkang kamabudinaki be pera ono kangkang koazalaka negu-lo kamananga.” ’” ");
INSERT INTO mva_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesus kababe pile ono tonanga takadi bokai ipile, “Bong ono Nanaranga ngatanepoa kana nge bokai. Tamoata teke kai ara ‘mastet’ patu idoki be uma nena-lo itanomi. ");
INSERT INTO mva_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kai-patu moarunga maradi nge ‘mastet’ patu ka mukumukunatuka, ata ngalaba nge kai biabiatuka ngapura, be mang dapura be sapara-nao gupadi daemaki.” ");
INSERT INTO mva_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iesus kaba pile ono tonanga takadi bokai iradi, “Bong ono Nanaranga ngatanepoa kana nge bokainatuka. Aine teke ‘is’ idoki be ‘palaua’ zaiza ibairi. Alauri nge ‘is’ ege-ege ‘palaua’-lo isili be iemaki be idodoraki.” ");
INSERT INTO mva_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesus nge pile ono tonanga-la ane be tamoata be aine isulesuledi. Sule tago teke bokaina-ba isuledi. Sule moarunga nge pile ono tonanga-la ane be isuledi. ");
INSERT INTO mva_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iesus bokai imuzi be ono ‘propet’ teke pilenga iemaki be dikalingo. ‘Propet’ ngae bokai ipile: “Bong mraradi masa pile ono tonanga ane be mraradi. Be kana moarunga zumkakadi dipura tongira kateka emaka ipura-lo be imai masa mrangakidi.” (Sam 78:2) ");
INSERT INTO mva_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesus isule-doi kodeka tamoata be aine moarunga iperekidi be pera-lo isili. Be tagataga ne disili nge bokai dirai, “Siresire goalakadi uma-lo dipura nge labu gorangaka-kama.” ");
INSERT INTO mva_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Be Iesus bokai ipile, “Tamoata kangkang-patu uia uma-lo iliki nge Tamoata Natu. ");
INSERT INTO mva_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Uma nge kateka ngae. Kangkang nge tamoata uia moarunga bong ono Nanaranga ngatanepoa kanana-lo dalako kana. Siresire goalakadi nge Satang ruanga zaiza. ");
INSERT INTO mva_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Erekei siresire goalakadi iliki nge Satang. Bong ono uaroenga nge kateka manubunga. Tamoata uaroeroe nge Nanaranga ‘enzel’ ne. ");
INSERT INTO mva_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Siresire didokidoki be dibubulai bokana masa kateka manubunga-nao bokainatuka damuzi kana. ");
INSERT INTO mva_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tamoata Natu masa ‘enzel’ ne nganepidi be tamoata muzingadi goalakadi be tamoata rangguma tamoata takadi diememakidi be muzigoala diememaki nge datetekidi be anua ne ono Nanaranga ngatanepoa kana nge dapereki. ");
INSERT INTO mva_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Be dadokidi be eoa kanabibia tago matemate-lo darokakidia-lako. Makara masa datangtang be iledi dakaraposaposa. ");
INSERT INTO mva_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kodeka Nanaranga tamoata be aine ne masa Tama-di anua nena-lo amari bokana damalamalama. Bokaibe kungi-ming otioti nge kamalongo! ");
INSERT INTO mva_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Bong ono Nanaranga ngatanepoa kana nge bokai. Kana teke zazaia atabalabala-tina nge uma tekena-lo dikumraki be ieno. Tamoata teke ite, ata kababe ikumraki. Suri nge diuia-tina. Bokaibe ialale be kana ne moarunga tamoata takadi iandi be dizaza be ‘mone’ ono idoki, be imule be uma ngae izazai. ");
INSERT INTO mva_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Bong ono Nanaranga ngatanepoa kana takadi bokai. Tamoata teke kaloiloi uarikadi ilelelei. ");
INSERT INTO mva_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Bong ialalale nge kaloiloi teke uarikana-tina zazaia atabalabala-tina nge ite. Kodeka ialale be kana ne moarunga tamoata takadi iandi be dizaza be ‘mone’ ono idoki, be imule be kaloiloi ngae izazai. ");
INSERT INTO mva_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Bong ono Nanaranga ngatanepoa kana suletaka takaia nge bokai. Raka teke dang-lo rokakalako ipura be ieno, be ika bakarairai-bakarairai nge ono dokiadi dipurapura. ");
INSERT INTO mva_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Raka-lo ika dikauri nge kabu-lo direpekalako be kodeka disoakiria be ika dinege. Irakingadi nge didokidoki be raba diauiau be goalakingadi nge dirorokaki. ");
INSERT INTO mva_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kateka manubunga-nao masa bokainatuka-la muzi ngapura kana. Nanaranga ‘enzel’ ne masa dapura be tamoata goalakadi tamoata adoadodi maradi ka dadokidi be dazageakidi. ");
INSERT INTO mva_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dazageakidia-doi kodeka dadokidi be eoa kanabibia tago matemate-lo darokakidia-lako. Makara masa datangtang be iledi dakaraposaposa.” ");
INSERT INTO mva_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kodeka Iesus tagataga ne bokai itegidi, “Pile moarunga ngaedi nge labudi kakaua ki tago?” Be di dikatu be dipile, “E! Kikaua!” ");
INSERT INTO mva_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kodeka bokai iradi, “Bokaibe tamoata Moses Mata ne disulesuletaki kata itaguraki be bong ono Nanaranga ngatanepoa kana tagataga ne ipura masa pera-marau teke pera nena-lo kana oauoau be kana muamuadi ipasipasi bokana.” ");
INSERT INTO mva_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesus pile ono tonanga ngaedi ipile-doi kodeka kaba ngaradi ipereki. ");
INSERT INTO mva_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Be ialale be anua-tina nena-lo ipura. Makara ipura nge ilako be pera nedi ono serereinga-lo isili be isuledi. Tamoata be aine dipura be pilenga dilongo nge dipitilaki-tina be bokai dipile, “Kaua malaidi bokainaina inanga ka ita? Kilala iememaki nge kaiboang nedi inanga ka ita? ");
INSERT INTO mva_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pera kelikeli natu ki taila? Ngai ki naita ka tina Maria? Ngai ki taila ka tari Zems, Iosep, Saimon be Iudas? ");
INSERT INTO mva_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ngai marau ki naita marau sisiki ka makare disoaki? Kana ngaedi ina ka ita?” ");
INSERT INTO mva_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Bokai ditegiaki be kodeka diebuloni be disegeaki. Be Iesus itaguraki be bokai iradi, “‘Propet’ anua-tina nena-lo be dara-tina nena-lo nge muaka ne tagotago.” ");
INSERT INTO mva_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Bokaibe makara Nasaret-lo nge kilala kaiboangdi tago kokoko iemaki, bakara lama tago diuni. ");
INSERT INTO mva_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bong ngaradia-lo nge Erot Galili kaba lasa-tanepoa nedi bokana isoaki be Iesus ilongoraki. ");
INSERT INTO mva_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kodeka Erot itaguraki be tamoata ne bibia bokai iradi, “Moimoina-tina Zon Baptais ka mate-lo be imarang. Bokai ka kaiboang ono kilala kaiboangdi emakinga bokainaina dienoni.” ");
INSERT INTO mva_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Erot ka ipile be Zon oarige ane diuauri be uaura pera-lo dinangai. Erodias lili-nao ka uaura-lo inangai. Erodias nge Erot taritoka Pilip roa. ");
INSERT INTO mva_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Zon Baptais izamazama Erot bokai irarai, “Erodias kuati nge mata neda-lo tagona-tina iuia.” ");
INSERT INTO mva_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot nge Zon ngaumoatei kana, ata Iuda imatakuridi. Bakara, Iuda tamoata be aine dipile Zon nge ‘propet’ kata. ");
INSERT INTO mva_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bong teke bong ono Erot tina inekiaki dipura nge Erodias natu aineka ipura be Erot ruanga zaiza ioagudi. Makara nge Erot suri diuia-tina. ");
INSERT INTO mva_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kodeka Erot itaguraki be natu aine ngae pile tago tototo ane be bokai irai, “Moimoina-tina ka uraiko! Kana kureretaki be kurangaki masa miangko!” ");
INSERT INTO mva_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erodias nge ambe natu iraia-doi. Bokaibe natu aine ngae bokai ipile, “Kaituka-tina makare be Zon Baptais pangana tabira tekena-lo be goana.” ");
INSERT INTO mva_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Erot bokai ilongo nge ilo ibuku-tina. Ata ambe lou ne matadi-o be pile tago tototo iemaki. Bokaibe ipile be natu aine ngae rerenga ditagadi. ");
INSERT INTO mva_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Be inepidi be dilako uaura pera-lo be Zon dudu ditotoki. ");
INSERT INTO mva_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kodeka pangana didoki be tabira tekena-lo dinangalako be natu aine ngae diani be tina-nalo ilakuaki. ");
INSERT INTO mva_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Alauri nge Zon tagataga ne dipura be Zon tamoata dibagai be dikumraki. Dikumrakia-doi kodeka dialale be Iesus dirai. ");
INSERT INTO mva_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesus Zon rangaka ilongo nge kaba ngaradi ipereki be kati tekenao ibuli be kaba tekedi tamoata tagongana-lo ilako. Tamoata be aine kokoko-tina dilongoraki nge anua nedi dipereki be ae-dialo ditagai. ");
INSERT INTO mva_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesus kati-o be inokuria be tamoata be aine kokoko-tina itedi nge ilo itagadia-tina. Be moremore kokoko iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rairai-tuka nge tagataga ne dimai be bokai dirai, “Ambe irairai-tina be kaba ngaedi nge masauaba-tinao ka dieno. Tamoata be aine anua-lo gonepidialako be kangkang kandi dazaza.” ");
INSERT INTO mva_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ata Iesus ikatu be bokai ipile, “Bakara ka dalale? Kam kangkang kamandi be dakang.” ");
INSERT INTO mva_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Be di dikatu be dipile, “Kangkang kana-ma tago. ‘Bereti’-la lima be ika rua ka maka dieno!” ");
INSERT INTO mva_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kodeka Iesus bokai ipile, “Kamadokimai.” ");
INSERT INTO mva_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kodeka tamoata be aine iradi be siresire-o disoakiria. Disoakiria kodeka ‘bereti’ lima be ika rua idoki be lang-lo itadalako be Nanaranga iperui. Kodeka ‘bereti’ isare be tagataga ne iandi be tamoata be aine dinegedi. ");
INSERT INTO mva_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Moarunga dimoanako be didoli-tina. Didoli be kangkang dimuleaki nge Iesus tagataga ne raba bibia kulemoa-be-rua diau. ");
INSERT INTO mva_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tamoata moane makara dimoanako nge ‘5,000’ moarunga. Aine be natu tago uareadi dipura. ");
INSERT INTO mva_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Alauri nge Iesus tagataga ne inepidi be kati-o be damua be dang ege takaianao dalako kana. Be ngai isoaki be tamoata be aine inepidi be dialale. ");
INSERT INTO mva_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Inepidi be dialale kodeka buku muku teke ieneki be rubenaba be ngarabo kana. Makara rubenaba isoaki be irodo. ");
INSERT INTO mva_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kati ono tagataga ne dialale nge ambe kasau-tina-lo irebareba. Oasa nge kati aro ipurapura be nugunugu ambe kati dirokarokaki. ");
INSERT INTO mva_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mang-o nge Iesus dang kusi-nao ialale be itagadi. ");
INSERT INTO mva_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dang kusi-nao ialalale be tagataga ne dite nge taburidi dira-tina be bokai dipile, “Anunu kata!” Taburidi nge dira-tina be dingangaraki be kaba dirati. ");
INSERT INTO mva_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ata Iesus oaikiki-tina bokai iradi, “Kamakaiboang! Moaki taburi-ming dira! Ngena ngau!” ");
INSERT INTO mva_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Kodeka Pita ikatu be bokai ipile, “Tanepoa! Nge moimoi kaiko nge gopile be dang kusi-nao mialale be mai.” ");
INSERT INTO mva_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Be Iesus ikatu be irai, “Gomai.” Kodeka Pita iposi be dang kusi-nao ialale be Iesus taona itao. ");
INSERT INTO mva_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ilakolako be oasa ite nge taburi-ira be ambe imoalobaloba. Pita kaba bokai ita nge ikilau, “Tanepoa! Gouketa!” ");
INSERT INTO mva_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Makara nge Iesus oaikiki-tina luma inanaraki be Pita idoki be bokai irai, “Lama uniangam disiki-tina! Bakara ka ilom irua?” ");
INSERT INTO mva_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Be bong kati-o dibulilakoru nge oasa ileua. ");
INSERT INTO mva_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Makara nge tamoata kati-o disoaki Iesus dirakeaki be bokai dipile, “Moimoina-tina kaiko Nanaranga Natu.” ");
INSERT INTO mva_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bong dang biabia ditotoki be ege takaianao dilako nge Genesaret kaba-lo ditoka. ");
INSERT INTO mva_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Makara nge anua-marau Iesus dikilalangi. Kodeka pile dinanga be anua moarunga makara saringa dieno-lo nge moremore nedi Iesus-lo dieluakidi. ");
INSERT INTO mva_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Be diakoroi be ngasumoala be moremore kusi-ba ne zagenao dadauraki be dauia kana. Bokaibe moarunga kusi ne zagenao didauraki nge diuia-doi. ");
INSERT INTO mva_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kodeka Parasi alu be tamoata Moses Mata ne disulesuletaki alu Ierusalem-lo be dipura be Iesus bokai ditegi, ");
INSERT INTO mva_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Bakara ka tagataga nem tago tubuda mata nedi ditagatagadi be luma-di diasasaki noko dimoanakonako?” ");
INSERT INTO mva_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Be Iesus ikatu be bokai ipile, “Bakara ka Nanaranga pilenga muriming kananga be neming sulenga-ming katagatagadi? ");
INSERT INTO mva_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nanaranga bokai ipile, ‘Tinam be tamam gomuamuakidi be pilengadi golongolongo.’ Be takadi bokai, ‘Tamoata naita tina ki tama ingesuaki nge umoatea ngapura.’ ");
INSERT INTO mva_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ata kam tamoata be aine bokai kasulesuledi: Tamoata teke kana teke iboadu ono tina be tama ngadumadi kana, ata bokai ipile, ‘Kana ngae Nanaranga ne’ ");
INSERT INTO mva_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nge tago iboadu tina be tama ono ngadumadi. Bokainatuka kamuzimuzi be Nanaranga pilenga muriming kanangananga be neming sulenga-ming katagatagadi. ");
INSERT INTO mva_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Boli-ngaming ratadi! ‘Propet’ Aisaia tongira nge kam-tina ka irangaki-kaming be ambe pilenga ngaedi dikalingo. Aisaia bokai ipile: ");
INSERT INTO mva_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Tamoata ngaedi nge oasi-diaba ane ka dirakerakeaka. Ata ilodi nge kasauba-tina-lo ka dieno. ");
INSERT INTO mva_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tamoata-ramo sulengadi didokidoki be tamoata takadi disulesuledi be dipilepile-ra nge Nanaranga pilenga. Rakeaka ra dirakerakeaka, ata dimamalomalo-ba’” (Ais 29:13) ");
INSERT INTO mva_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kodeka Iesus tamoata be aine moarunga ikiladia-mai saringa be bokai iradi, “Kamalongo be kamakaua. ");
INSERT INTO mva_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kana tamoata ilona-lo dilakolako nge tago iboadu daemaki be ngabolo. Tago. Kana ilona-lo be dirake be aoa-nalo dipusika ka masa daemaki be ngabolo.” ");
INSERT INTO mva_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kodeka tagataga ne dimai be bokai dirai, “Pile ngaedi kupile nge Parasi kuemakidi be namadi dira-tina.” ");
INSERT INTO mva_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Be Iesus ikatu be bokai ipile, “Kai moarunga Tama-gu lang anua-lo isoaki tago itano masa tetekadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ilo-ming moaki dibukutakidi. Matadi leuadi kaoa ka dimuamua be tamoata takadi ditagatagadi! Mata-leua kata ka mata-leua ruanga iaromuamuani masa gimoa-lo dasapasilakoru.” ");
INSERT INTO mva_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kodeka Pita itaguraki be bokai ipile, “Pile ngaedi labudi gopasi-kama.” ");
INSERT INTO mva_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Be Iesus ikatu be bokai iradi, “Kam isi takadi bokana be ilo-ming tago dizama ki? ");
INSERT INTO mva_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tago kakaua? Kana tamoata aoa-nalo disili nge boura-nalo dilako be kababe dipusika. ");
INSERT INTO mva_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ata kana maka tamoata aoa-nalo be dipusika nge ilona-lo ka dikautaki be dipusika. Be nge kana bokainaina ka tamoata diememakidi be dibolobolo. ");
INSERT INTO mva_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tamoata ilona-lo be muzi goalakadi ngaedi ilelelenaki be iememaki: Tamoata takadi iumoatemoatedi; roti igagamang; ipogizagiza-ramo; ianakonako; iboliboli; be Nanaranga be tamoata takadi boli-pile ane be iebulobulodi. ");
INSERT INTO mva_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kana ngaedi ka tamoata diememakidi be dibolobolo. Tamoata luma tago iasaki noko imoanako, di sulengadi bokana nge tago iboadu tamoata ngaemaki be ngabolo.” ");
INSERT INTO mva_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kodeka Iesus kaba ngaradi ipereki be ilako be kaba Saidon be Taia anua saringadi dieno-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenan aine teke makara isukoaki nge ipura be Iesus bokai irai, “Tanepoa, Debiti Natu! Ilom ngatagaia! Natu-gu aineka mariaba goalaka ilona-lo isoaki be sururu bibia-tina idokidoki.” ");
INSERT INTO mva_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ata Iesus imoadubulae-ba be tago sesu ipile. Be tagataga ne dimai be bokai dirai, “Aine ngae gonepi be ngalale! Itagataga-kita be inaboakiboaki be ambe iaka-poakikita-tina.” ");
INSERT INTO mva_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Be Iesus ikatu be bokai ipile, “Ngau Israel ‘sipisipi’ ne leuadia-lo ka nepiagulako ipura.” ");
INSERT INTO mva_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ata aine ngae imai be Iesus ae-nalo itapuloria be bokai ipile, “Tanepoa. Godumaia!” ");
INSERT INTO mva_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Be Iesus ikatu be bokai ipile, “Nge tago iuia natu-muku kangkang kandi keu nedi aniadi dapura.” ");
INSERT INTO mva_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kodeka aine ngae bokai ipile, “Tanepoa, ngara moimoi! Ata keu kababe kangkang bururuingadi tamadi dikangkang be disapasipasi nge dikangkang.” ");
INSERT INTO mva_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Makara nge Iesus ikatu be aine ngae bokai irai, “Aine, kaiko lama uniangam dilaba-tina! Bokaibe kana kureretaki masa ngapuraniko.” Be bong-la ngaranao natu aineka iuia. ");
INSERT INTO mva_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesus kaba ngaradi ipereki be Galili dang biabia isauani be ialale. Ialale be buku muku teke ieneki be isoakiria. ");
INSERT INTO mva_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tamoata be aine kokoko-tina dipura be tamoata aedi matedi, matadi leuadi, tapoudi matedi, pile bebebedi be moremore kokoko-tina nge dieluakidi be Iesus ae babadia-lo dinangadiaria. Be Iesus itaguraki be iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tamoata be aine moarunga kaba bokai dita pile bebebedi dipilepile, tapoudi matedi diuia, aedi matedi dialalale, matadi leuadi kaba ditaita nge dipitilaki-tina be Iesus dikabaki. Bokaibe Israel Nanaranga nedi dirakeaki. ");
INSERT INTO mva_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kodeka Iesus tagataga ne ikiladi be bokai iradi, “Tamoata be aine ngaedi ilogu itagadia-tina. Ambe amaridi toli sakeguo disoaki. Masa rakana dakang? Tago urere toletole-ba mnepidi be dalale. Zala-lo matadi dasoalili be datamong takana.” ");
INSERT INTO mva_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kodeka tagataga ne bokai dipile, “Kaba ngaedi nge masaua-lo ka dieno. Kangkang masa inanga gate be gandi be dakang?” ");
INSERT INTO mva_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Be Iesus ikatu be ipile, “‘Bereti’ kana-ming ira dieno?” Be di dikatu be bokai dipile, “Lima-rua, ika mukumukudi alu zaiza.” ");
INSERT INTO mva_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kodeka Iesus itaguraki be tamoata be aine iradi be kateka-o disoakiria. ");
INSERT INTO mva_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Disoaki-doiria kodeka ‘bereti’ lima-rua be ika idoki be Nanaranga iperui be ikoto. Kodeka tagataga ne iandi be tamoata be aine dinegedi. ");
INSERT INTO mva_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tamoata be aine moarunga dimoanako be didoli-tina. Didoli be kangkang dimuleaki nge Iesus tagataga ne raba bibia lima-rua diau. ");
INSERT INTO mva_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tamoata moane makara dimoanako nge ‘4,000’ moarunga. Aine be natu tago uareadi dipura. ");
INSERT INTO mva_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Alauri nge tamoata be aine inepidi be dialale. Kodeka kati-o ibuli be Magadan kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parasi alu be Sadiusi alu dipura be Iesus datoi kana. Be ditegi be kilala kaiboangi teke lang anua-lonalona ngaemaki kana.  ");
INSERT INTO mva_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ata Iesus ikatu be bokai ipile, “Amari ambe ilakolako masa bokai kamapile, ‘Lang idaradara. Anua masa ngauia.’ ");
INSERT INTO mva_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Oabuna-biabia masa bokai kamapile, ‘Lang izimzim be idaradara. Ura masa ngapura.’ Lang-ba kateate be ono anua irakinga be goalakinga kakauakauataki. Ata kilala kaituka bong ngaedia-lo dipurapura nge tago kaita be kakauataki! ");
INSERT INTO mva_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Muzinga-ming goalakadi be Nanaranga ono kamanainai! Kam kilala lang anua-lonalona kareretaki ki? Tagona-tina iboadu teke ania-ming ngapura! Zona-la kilala ne ka masa ania-ming ngapura.” Ipile-doi kodeka iperekidi be ialale. ");
INSERT INTO mva_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Iesus tagataga ne zaiza dang biabia ara Galili ditotoki be ege takaianao dilako nge tagataga ne ilodi dikoko be ‘bereti’ tago teke didokidoki. ");
INSERT INTO mva_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kodeka Iesus bokai iradi, “Eke! Ilo-ming kauakaua! Parasi be Sadiusi ‘is’ ono ‘bereti’ emakanga nedi kamamatakoakia-tina uia.” ");
INSERT INTO mva_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iesus bokai ipile nge tagataga ne ditaguraki be ambe nedia-la maradi pile ngaedi diegoregoretaki. Kodeka bokai dipile, “Ngena ‘bereti’ tago teke tadokidoki ka bokai ipile!” ");
INSERT INTO mva_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ata Iesus ikaua rakana ka dirangarangaki. Bokaibe, bokai itegi, “Bakara ka neming-la kapilepile ‘bereti’ tago? Lama unianga-ming disiki-tina! ");
INSERT INTO mva_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tago isi kakaua ki? ‘Bereti’ lima tamoata moane ‘5,000’ moarunga usaredi nge ilo-ming diandi ki tago? Dimoanako-doi be raba bibia ira kaiau? ");
INSERT INTO mva_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","‘Bereti’ lima-rua tamoata moane ‘4,000’ moarunga usare be dikang nge ilo-ming diandi ki tago? Didoli nge raba bibia ira kaiau? ");
INSERT INTO mva_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Baituka ka tago kakaua ngau tago ‘bereti’ ka urarangaki? Ata Parasi be Sadiusi ‘is’ nedi kamamatakoaki-tina uia!” ");
INSERT INTO mva_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kodeka tagataga ne dikaua, nge tago ‘is’ ono ‘bereti’ emakanga ka irangarangaki. Tago. Nge Parasi be Sadiusi sulengadi ka irarangaki. ");
INSERT INTO mva_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bong Iesus ilako be anua ara Sisaria Pilipai isaringai nge tagataga ne bokai itegidi, “Tamoata be aine moarunga Tamoata Natu naita kana dirangaki?” ");
INSERT INTO mva_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Be di dikatu be dipile, “Alu Zon Baptais kana dipile. Alu Ilaiza kana dipile. Alu Zeremaia ki ‘propet’ kata kana dipile.” ");
INSERT INTO mva_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Be Iesus kaba itegidi, “Be kam ba ilo-ming dipile? Ngau naita kana karangaka?” ");
INSERT INTO mva_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kodeka Saimon Pita ikatu be bokai ipile, “Kaiko ka Kristus. Kaiko Nanaranga moauriuri-la nem-kusoaki isukoaki nge Natu.” ");
INSERT INTO mva_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Be Iesus itaguraki be Saimon Pita bokai irai, “Saimon, Zona natu, surim dauia! Pile ngaedi nge tago tamoata-ramo kata ka iraiko. Tago! Pile ngaedi nge Tama-gu lang anua-lo isoaki ka iraiko. ");
INSERT INTO mva_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Bokaibe ngau bokai uraiko: Kaiko nge Pita. Be patu ngaenao masa ‘sios’ negu mnaguraki kana. Mate kaiboang ne tagona-tina iboadu ‘sios’ ngae ngabalaki. ");
INSERT INTO mva_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Bong ono Nanaranga ngatanepoa kana babaduadua uasara ne nge masa miangko. Rakana teke makare kateka-o kubabari masa lang anua-lo babaria ngapura. Rakana teke makare kateka-o kusumoalataki masa lang anua-lo sumoalataka ngapura.” ");
INSERT INTO mva_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kodeka tagataga ne moarunga ibabaridi moakina-tina sesu dipile ngai ka Kristus. ");
INSERT INTO mva_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bong ngaranao be ilako nge Iesus mangata-la be tagataga ne iraradi masa Ierusalem ngalako be Iuda tamoata nedi bibia, be tamoata Nanaranga ditabatabai dimuamuadi, be tamoata Moses Mata ne disulesuletaki dataguraki be sururu bibia-tina dani be umoatea ngapura. Ata amaridi tolianao masa kababe ngamarang be moauriuri ngasoaki. ");
INSERT INTO mva_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Kodeka Pita itaguraki be Iesus laua-ba ilakuaki be bokai irai, “Tanepoa! Ngau tago urere Nanaranga bokai ngabasakiko! Tagona-tina iboadu! Kana bokainaina moakina-tina teke ipuraniko!” ");
INSERT INTO mva_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kodeka Iesus ibuiri be Pita bokai irai, “Satang, goiratu! Murigu golako! Zalakagu kuono-la be ieno! Kana ilom ianiandi nge tago Nanaranga-lo ka dipura. Tago! Nge tamoata-ramo-lo ka dipura!” ");
INSERT INTO mva_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kodeka tagataga ne bokai iradi, “Tamoata naita ngau ngatagaia kana nge nena-la ngailo-leuataki, be kai ne kapalapala uauau ngabazi be ngatagaia. ");
INSERT INTO mva_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bakara, tamoata naita ne moauriuri soakinga ngauketi kana masa ngaleua. Ata tamoata naita ngau kanabe imate masa moauriuri soakinga ngaita. ");
INSERT INTO mva_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Maka ma bokai kamakaua: Tamoata teke kana moarunga kateka-onaona idoki be inemdi, ata mariabaka eoa tago matemate-lo ilako be makara nem-kusoaki isukoaki. Bokai nge kana kateka-onaona masa baituka be dadumai? Ki tamoata bokainaina masa rakana-tina teke ngauasai be nganemi? Tago-la! Ki masa rakana ane be tamoata teke iboadu ne mariabaka ngazazai be ono moauriuri-la ngasukoaki! Tagona-tina iboadu! ");
INSERT INTO mva_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bakara, Tamoata Natu ambe Tama malama ne be kaiboang nena-lo be ‘enzel’ ne zaiza be dapura kana. Be masa tamoata teke-teke kana diemaki nge ngatagadi be zazanga ngandi. ");
INSERT INTO mva_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngau ka ura-kaming! Alu makare dituitui masa mate bubuna tagona-la date be Tamoata Natu ngatanepoa be ngapurapura be date.” ");
INSERT INTO mva_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Amaridi lima-teke dimanubu kodeka Iesus itaguraki be Pita be Zems taritoka Zon diaru ibagadiato be buku salagalaga tekenao rubediabato dilakoto. ");
INSERT INTO mva_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kaba ditaitato noko Iesus itabuli be takana-ba ipura. Lili nge amari bokana dimalama be kusi ne nge diuasuaua-tina amari malamaka bokana. ");
INSERT INTO mva_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Makara nge Moses be Ilaiza inangai-ba ka matadi-o dipuraru be Iesus diato dipilepileto. ");
INSERT INTO mva_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Makara nge Pita itaguraki be bokai ipile, “Tanepoa! Nge iuia-tina makare tasoaki. Kurere nge bazarua toli memaki. Teke nem, teke Moses ne, teke Ilaiza ne.” ");
INSERT INTO mva_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita isi ipilepile-la be oaru malamaka otioti teke ipura be isukumdi be malonga teke bokai ipile, “Nge Natugu! Ngau urereretakia-tina, be surigu diuiatakia-tina! Kamalongolongori.” ");
INSERT INTO mva_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iesus tagataga ne toli ngaedi malonga ngae dilongori nge taburidiato dira-tina be lili-diato kateka-lo dinangalakoto. ");
INSERT INTO mva_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ata Iesus ilako be luma odiatoio inangaria be bokai ipile, “Kamatui-raketo! Taburi-mingto moaki dira.” ");
INSERT INTO mva_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ditada-raketo nge tamoata tago teke dite. Iesus-la rube ituitui be diteato. ");
INSERT INTO mva_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Buku-o be ditaotao nge Iesus bokai iradiato, “Kana kaita ngaedi nge moakina-tina teke karangakini nibe ngalako Tamoata Natu-ba mate-lo be ngamarang!” ");
INSERT INTO mva_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kodeka tagataga ne bokai ditegi, “Bakara ka tamoata Moses Mata ne disulesuletaki bokai dipile Ilaiza ngapura mua noko?” ");
INSERT INTO mva_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Be Iesus ikatu be bokai ipile, “Ilaiza moimoi ngapura mua kana. Ngai ka kana moarunga kabadia-lo ngananga kana. ");
INSERT INTO mva_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ata ngau bokai ura-kaming! Ilaiza ambe ipura-doi. Ata tamoata be aine tago dikilalangi be rerengadiaba-lo dipulonaki. Be bokainatuka-la, Tamoata Natu masa bokainatuka-la dapulonaki be sururu dani.” ");
INSERT INTO mva_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Makara nge tagataga ne dikaua nge Zon Baptais ka irangarangaki. ");
INSERT INTO mva_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Dilakoto be tamoata be aine moarunga dipurakadi nge tamoata teke ipura be Iesus aro tuku-nao irokazokuria. ");
INSERT INTO mva_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Be bokai ipile, “Tanepoa, natu-gu moaneka ilom ngatagai! Ingao-ngao be ambe igoala-tina! Ngaonga dipurapura nge eoa-lo be dang-lo itapulopulolako. Ambe bong kokoko-tina bokai imuzi. ");
INSERT INTO mva_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tagataga nem-lo ulakuaki, ata tago diboadu dadoraki.” ");
INSERT INTO mva_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Be Iesus ikatu be bokai ipile, “Kam tamoata be aine bong ngaedia-lo kasoaki nge lama tagona-tina kauni, be tago kakaua inanga kalakolako! Masa uanana salagatikadi baituka makare sakeming-lanao msukoaki? Ambe ilogu iakataki-kaming-tina! Aira-tina be masa kamakaua? Natu moane ngara maka kamadokamai!” ");
INSERT INTO mva_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kodeka Iesus itaguraki be mariaba goalaka itaoni be bong-la ngaranao natu moane ngae iuia. ");
INSERT INTO mva_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Alauri nge tagataga ne nedia-ba be dipura be Iesus bokai ditegi, “Bakara ka keka tago kiboadu mariaba goalakadi gataodi?” ");
INSERT INTO mva_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Be Iesus ikatu be bokai ipile, “Lama unianga-ming isi disiki-tina ka tago kaboadu! Moimoi ka ura-kaming. Lama una-ming labatikadi dedau-patu bokana nge iboadu buku ngara bokai kamarai, ‘Makare be ene golako.’ Be ngalongori-kaming be ngalako. Iboadu-tina kolo-kolo be kamaemaki.  ");
INSERT INTO mva_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Rabo be kangkang zirau ka diboadu mariaba goalakadi dataodi. Kana takadi tago diboadu.” ");
INSERT INTO mva_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Bong ambe Galili kaba-lo diepurapurari nge Iesus bokai iradi, “Tamoata Natu ambe saringatuka dadoki be tamoata luma-dio dasalangaki kana. ");
INSERT INTO mva_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Be tamoata ngaedi masa daumoatei, be amaridi toli muridi masa marangaka ngapura be moauriuri ngasoaki.” Tagataga ne bokai dilongo nge ilodi dinodo-tina. ");
INSERT INTO mva_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kaperneam anua-lo dipura nge tamoata Nanaranga pera nena-lo ‘tagisi’ didokidoki dilako be Pita bokai ditegi, “Biabiadi nem ‘tagisi’ Nanaranga pera nena-lonalona izazazai ki tago?” ");
INSERT INTO mva_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Be Pita ikatu be ipile, “E, izazazai.” Be bong Pita pera-lo ilako nge Iesus matamatanatuka itegi-rake, “Saimon, bakara ilom ipile? Rangguma ka anuatanepoa kateka-onaona ‘tagisi’ dianiandi? Anua-marau ki akerengadi?” ");
INSERT INTO mva_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Be Pita ikatu be ipile, “Akerengadi.” Kodeka Iesus bokai ipile, “Bokai nge anua-marau moaki ‘tagisi’ dizazazai. ");
INSERT INTO mva_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ata kita tago tarere tamoata ngaedi tailo-sururudi. Dang biabia-lo golako be kilolo ono konanga kanam teke gorokakalako. Ika kurepekiatuka-mua aoa-nalo masa ‘mone’ teke ngaeno be gote. ‘Mone’ ngae iboadu-tina ‘tagisi’ Nanaranga pera nena-lonalona ngazazaia-kitaru. Godoki be goalale be ono go‘tagisi’-kitaru.” ");
INSERT INTO mva_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Bong ngaranao nge Iesus tagataga ne dipura be bokai ditegi, “Anua ono Nanaranga ngatanepoa kanana-lo masa naita ka ara biabiatuka?” ");
INSERT INTO mva_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Be Iesus itaguraki be natu-muku teke ikilai be arodi ituiraki ");
INSERT INTO mva_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","be bokai ipile, “Moimoi ka ura-kaming. Ilo-ming tago ditabuli be natu-muku bokana kapura nge tagona-tina iboadu anua ono Nanaranga ngatanepoa kanana-lo kamalako. ");
INSERT INTO mva_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bokaibe tamoata naita nena-la ibalaki be muzinga natu-muku ngae bokana masa anua ono Nanaranga ngatanepoa kanana-lo ara biabiatuka. ");
INSERT INTO mva_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Be tamoata naita aragu-o be natu-muku bokainaina idoki be iadoraki nge ngau ka iadoraka. ");
INSERT INTO mva_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ata tamoata naita natu-muku bokainaina teke ngau lama iunana idoki be muzigoala itikini nge iuia-tina patu kanabiabia teke duduna-lo tukua-lako ngapura be makasi biatangana-lo patuae kautadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kateka ngae nge imakadoma-tina! Maka ma kateka ngaenao ka kana goalakadi dieneno be ono tamoata diememakidi be muzigoala diememaki. Kana ngaedi masa dapurapura. Ata tamoata muzigoala ngaedi labudia-tina nge imakadoma-tina! ");
INSERT INTO mva_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Lumam ki aem iemakiko be muzigoala kuemaki nge gotaratotoki be gorokaki. Lumam tekena-la ki aem tekena-la be moauriuri-la soaki-lo kulako nge iuia. Lumam ruoti-doi ki aem ruoti-doi dieno-la be eoa tago matemate-lo kulako nge tagona-tina iuia! ");
INSERT INTO mva_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Matam takaia ka iemakiko be muzigoala kuemaki nge gokingpasiki be gorokaki. Matam tekena-la be moauriuri-la soaki-lo kulako nge iuia. Ata matam rua dieno-la be eoa tago matemate-lo kulako nge tagona-tina iuia! ");
INSERT INTO mva_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Natu-muku moakina-tina teke kabalaki. Ngau ka ura-kaming. Lang anua-lo nge natu-muku ‘enzel’ nedi izamaizama Tama-gu lang anua-lo isukoaki aro dituitui.  ");
INSERT INTO mva_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tamoata Natu nge tamoata be aine leuadi ka ngauketidi kana ka ipura. ");
INSERT INTO mva_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ilo-ming bakara dipile? Tamoata teke ‘sipisipi’ ne ‘100’ moarunga be teke ileua masa rakana ngaemaki? Kamalongo! Takadi ‘99’ masa bukuo ngaperekidi be daramomomo be ngalale be teke ileua nge ngalelei. ");
INSERT INTO mva_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Moimoi ka ura-kaming! Ite masa teke leua ngae nge suri dauiatakia-tina. Takadi ‘99’ tago dileua nge sakenao ka disoaki. Bokaibe tago ngailo-bukutakidi kana. ");
INSERT INTO mva_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Bokainatuka-la, Tama-ming lang anua-lo isoaki tago irere mukumukudi ngaedi nge teke ngaleua. ");
INSERT INTO mva_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Taritokam kata muzigoala teke iemakaniko nge golako be giriki ne goitikini. Ata zuguma-ba be gorai. Ilongoriko nge ambe taritokam kaba kumuleaki. ");
INSERT INTO mva_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ata tago ilongoriko nge tamoata teke ki rua gobagadi. Bokai masa ‘tamoata rua ki toli pile tekedia-doi diemaki nge pilengadi moimoi be kalingodi.’ ");
INSERT INTO mva_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tago ilongoriko nge golako be tamoata be aine moarunga ‘sios’-lo goradi. Tamoata be aine ‘sios’-lo tago ilongoridi nge kodeka akerenga ki ‘tagisi’ dokidoki bokana gobasabasaki. ");
INSERT INTO mva_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Moimoi ka ura-kaming. Rakana teke kateka-o kababari masa lang anua-lo babaria ngapura. Be rakana teke kateka-o kasumoalataki masa lang anua-lo sumoalataka ngapura. ");
INSERT INTO mva_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Kaba moimoi ka ura-kaming! Tamoata rua maka kateka-o kana teke direretakiaru be disinauru be dadokiaru kana, masa Tama-gu lang anua-lo isoaki kana disinautakiaru nge ngaemaka-diaru. ");
INSERT INTO mva_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tamoata rua ki toli aragu-o be dipura be disoaki-budu nge ngau maradi usoaki.” ");
INSERT INTO mva_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kodeka Pita imai be Iesus bokai itegi, “Tanepoa! Bong ira taritokagu muzigoala ngaemakina be mrokakile? Bong lima-rua ki ira?” ");
INSERT INTO mva_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Be Iesus ikatu be bokai ipile, “Moaki bong lima-rua-la. Bong kulemoadi-lima-rua-be-lima-rua. ");
INSERT INTO mva_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bokainatuka mtonanga: bong ono Nanaranga ngatanepoa kana nge bokai. Anuatanepoa teke ilako be malipilipi nena-lo oti nedi ngaia-lo dieno nge ngadoraki kana. ");
INSERT INTO mva_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iadoadoraki be isoaki nge tamoata teke ‘mone 10 tausen’ moarunga idoki be tago isi ikatu nge dieluaki. ");
INSERT INTO mva_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ata malipilipi ngae tago iboadu ngakatu. Bokaibe anuatanepoa ngae ipile be roa be natu be kana ne moarunga zaiza be ‘mone’ odio dadoki be ono oti ne ngakatu kana. ");
INSERT INTO mva_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ata malipilipi ngae itaguraki be tanepoa kana aro tuku-nao irokazokuria be iakoroi be bokai ipile, ‘Ilom ngatagaia be gorapu be ‘mone’ moarunga udoki nge mkatu.’ ");
INSERT INTO mva_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Bokaibe anuatanepoa ngae nge malipilipi ne ilo itagai be bokai irai, ‘Oti nem ngaedi moaki kukatu.’ Be ilikitaki be ialale. ");
INSERT INTO mva_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ata tamoata ngae ipusika nge malipilipi-budu ruanga teke ngaia-lo ‘mone’ kulemoa-la idoki nge ite. Kodeka itaguraki be malipilipi-budu ruanga nge idokimatei be audo-nalo idaurakilako be bokai irai, ‘Oti nem moarunga ngau-lo dieno oaikiki-tina gokatu.’ ");
INSERT INTO mva_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kodeka malipilipi-budu ruanga nge aro tuku-nao irokazokuria be iakoroi be bokai irai, ‘Ilom ngatagaia be gorapu masa oti nem mkatu.’ ");
INSERT INTO mva_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ata tamoata ngae isege be itaguraki be malipilipi-budu ruanga uaura-lo inangai. Be makara uaura-lo ngasoaki nibe oti ne moarunga nge ngakatu-doi. ");
INSERT INTO mva_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Malipilipi takadi kaba bokai dita nge ilodi tagona-tina diuia. Bokaibe dilako be kana moarunga tamoata ngae iemaki nge anuatanepoa kandi dirangakini. ");
INSERT INTO mva_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kodeka anuatanepoa ngae itaguraki be tamoata ngae ikilai be bokai irai, ‘Kaiko malipilipi tago iauia! Kutangna be oti nem moarunga ngau-lo dieno nge ilogu itagaiko be tago kukatu. ");
INSERT INTO mva_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Bakara ka malipilipi-budu ruangam ilom tago itagai ngau-la ilogu itagaiko bokana?’ ");
INSERT INTO mva_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Anuatanepoa ngae nge tamoata ngae ilo iratakia-tina. Bokaibe ipile be uaura-lo dinangai be sururu bibia-tina ngadokidoki nibe oti ne moarunga dieno nge ngakatu-doi.” ");
INSERT INTO mva_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Be Iesus pile ngaedi bokainatuka imambuaki, “Kam moarunga tarito-kaming tago iloming-lo be giriki nedi karokakiledi masa Tama-gu lang anua-lo bokainatuka-la ngabasaki-kaming.” ");
INSERT INTO mva_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesus pile ngaedi imambuaki be Galili ipereki be Zudea kaba-lo ilako. Zudea kaba ngaedi nge Zodan zagura ege takaianao ka dieno. ");
INSERT INTO mva_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Be tamoata be aine dum kokoko-tina nge ditagai be makara be moremore nedi iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Makara nge Parasi alu dipura be Iesus datoi kana. Be bokai ditegi, “Mata neda disumoala ki tago tamoata teke iboadu rerenganaba-lo roa ngasegeaki?” ");
INSERT INTO mva_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Be Iesus ikatu be ipile, “Gere ngaedi kaleze ki tago? ‘Matamatana-tina Nanaranga moane be aine iemakidi.’ (Zen 1:27) ");
INSERT INTO mva_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Be bokai ipile, ‘Bokaibe moane tina be tama ngaperekidi be roa diaru dataga-buduru be tamoata teke dapuraru.’ ");
INSERT INTO mva_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Diaru nge ambe tago rua. Diaru ambe tamoata teke. Bokaibe kana Nanaranga iuau-tekenanadi nge tamoata tago teke iboadu ngaramoaki.” ");
INSERT INTO mva_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ata Parasi kaba ditegi, “Nge bakara ka Moses ipile moane iboadu ‘pepa’ ono roti gamana teke roa ngageretani be ngani be nganepi be ngalale?” ");
INSERT INTO mva_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Be Iesus ikatu be bokai ipile, “Pangana-ming dipatungaki be raia-ming dira. Bokai ka Moses isumoala-kaming be iboadu roa-ming kamasegeakidi. Ata matamata kateka emaka ipura-lo nge tago bokai. ");
INSERT INTO mva_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ata ngau bokai ura-kaming: Tamoata naita roa tago ono imanai, ata isegeakia-ba be aine takaia iuati nge moane ngae roti igamani be aine takaia diaru dieno-buduru.” ");
INSERT INTO mva_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kodeka tagataga ne bokai dipile, “Muzi bokai rotiroti maradi dieno nge moakina-ma roti ipurapura.” ");
INSERT INTO mva_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Be Iesus ikatu be bokai ipile, “Sule ngaedi nge masa tago tamoata moarunga dadoki. Tago. Tamoata-la rangguma Nanaranga kaiboang iandi ka masa dadoki. ");
INSERT INTO mva_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tamoata alu bokainaina be tinadi dinekiakidi be ono tago iboadu daroti. Aludi tamoata ruangadi ka diaka-goaladi be tago iboadu daroti. Aludi nge bong ono Nanaranga ngatanepoa kana lili-nao ka nedia-la be roti disege. Bokaibe tamoata naita sule ngaedi ireretaki be idoki nge ngadoki.” ");
INSERT INTO mva_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kodeka tamoata alu natu-muku dieluakidi be Iesus luma odio nganangaria be ngarabodi kana. Ata Iesus tagataga ne ditaguraki be tamoata ngaedi diebulodi. ");
INSERT INTO mva_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Makara nge Iesus bokai ipile, “Natu-muku kamalikitakidi be ngau-lo damai. Moaki zalakadi kaono. Bong ono Nanaranga ngatanepoa kana nge natu-muku bokainaina nedi.” ");
INSERT INTO mva_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kodeka natu-muku dimai be luma odio inangaria be ialale. ");
INSERT INTO mva_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tamoata amuna teke ipura be Iesus bokai itegi, “‘Tisa,’ rakana iauia memaki be masa moauriuri-la nem-kusoaki soaki ipurapura nge mdoki?” ");
INSERT INTO mva_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Be Iesus ikatu be bokai ipile, “Bakara ka kana iauia kana be kutegia? Nanaranga-la ka iauia. Bokaibe moauriuri-la gosukoaki kana nge Nanaranga mata ne moarunga gotagatagadi.” ");
INSERT INTO mva_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kodeka tamoata ngae bokai itegi, “Nanaranga mata ne nangatadi?” Be Iesus ikatu be bokai ipile, “Tamoata takaia moaki kumoatei; roti moaki kugamani be aine takaia kamru kaeno-buduru; moaki kuianako; tamoata takaia moaki kuboliaki; ");
INSERT INTO mva_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘tamam be tinam gomuamuaki-di;’ be ‘tamoata ruangam gorereretakidi nem-la kurereretakiko bokana.’” ");
INSERT INTO mva_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Be tamoata ngae bokai ipile, “Mata moarunga ngaedi nge ulongolongo be utagatagadi. Rakana-tina tekena-lo isi utukura?” ");
INSERT INTO mva_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kodeka Iesus itaguraki be tamoata ngae bokai irai, “Kurere gouia be goado-tina kana nge goalale be kana nem ‘mone’ odio godoki, be ‘mone’ ngaedi godoki be tamoata kana nedi tagotago goandi. Bokai masa kana uia-tina Nanaranga lang anua-lo ngangko be kana nem dakoko-tina. Kana ngaedi goemaki-doi, kodeka gomai be gotagaia.” ");
INSERT INTO mva_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tamoata ngae nge kana ne kokoko-tina. Bokaibe pile ngaedi ilongo nge ilo ibuku-tina be ialale. ");
INSERT INTO mva_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Kodeka Iesus itaguraki be tagataga ne bokai iradi, “Moimoi ka ura-kaming. Tamoata kana nedi kokoko masa anua ono Nanaranga ngatanepoa kanana-lo sili daradia-tina. ");
INSERT INTO mva_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kababe mra-kaming kana! ‘Kamel’ lili kusi-kalaura boazingana-lo ngasili kana masa sili tagona-tina darai. Ata tamoata kana ne kokoko anua ono Nanaranga ngatanepoa kanana-lo ngasili kana, masa sili daraia-tina.” ");
INSERT INTO mva_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bong tagataga ne pile ngaedi dilongo nge dipitilaki-tina be bokai dipile, “Bokai nge alauri masa Nanaranga naita ngauketi be ngamuleaki?” ");
INSERT INTO mva_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kodeka Iesus adoado-la matadia-lo idededialako be bokai iradi, “Moimoi tamoata tago diboadu kana ngae daemaki, ata Nanaranga-lo nge kanaba. Maka ma Nanaranga iboadu-tina kana moarunga ngaemaki.” ");
INSERT INTO mva_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Be Pita ikatu be bokai irai, “Gote! Keka kana nema moarunga kipereki be kitagaiko. Masa rakana-tina ngaeno-kama be ganemi?” ");
INSERT INTO mva_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Be Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming. Alauri kana oauoau emakadi dapura kanana-o masa kam kulemoa-be-rua ngau katagaia nge bagi ono tanepoanga-o kamasoaki be Israel bagi nedi kulemoa-be-rua kamapapananuaki. Bong ngaradi-o masa Tamoata Natu bagi ono tanepoanga ne malamaka kaiboangdi-o ngasoaki. ");
INSERT INTO mva_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Be tamoata naita ngau kanabe pera kana, taritoka, marau, tama, tina, natu, ki uma ne ipereki masa zazanga bibia-tina ngadoki be alauri masa nem-kusoaki ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ata tamoata kokoko-tina dimua masa dalauri, be alalauri masa damua.” ");
INSERT INTO mva_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Bong ono Nanaranga ngatanepoa kana nge bokai: Tamoata teke uma kana otioti nge oabunabe ialale be tamoata alu itedi be ‘uain’ uma kanana-lo damalipini kana. ");
INSERT INTO mva_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tamoata alu itedi be isumoala masa ‘mone siliua’ teke-teke ane amari ngarana-lo ngazazadi. Kodeka inepidi be dialale be uma kanana-lo damalipi kana. ");
INSERT INTO mva_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Amari ambe ikai nge kababe ilako malala-lo be tamoata alu makara dituitui-ba nge itedi ");
INSERT INTO mva_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","be bokai iradi, ‘Kamalale be uma kanagu-lo kamamalipi be zazanga adoadodi miang-kaming.’ ");
INSERT INTO mva_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Be tamoata ngaedi dialale be dimalipini. “Amari-soasoa-tina be amari ambe aoa-lo ibala nge kababe ialale be tamoata alu ibagadi be dimalipini. ");
INSERT INTO mva_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ambe amari ngasapasilako kana nge kaba ilako malala-lo be tamoata alu makara dituitui-ba itedi be bokai itegidi, ‘Bakara ka bokaina-ba katuitui be ambe amari-ba ngamanubu kana?’ ");
INSERT INTO mva_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Be di dikatu be dipile, ‘Tamoata tago teke malipi iang-kama.’ “Kodeka tamoata ngae bokai iradi, ‘Kamalale be uma kanagu-lo kamamalipi.’ ");
INSERT INTO mva_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Rairaituka-tina nge uma-marau itaguraki be tamoata ne malipi-lo imuamua ikilai be bokai irai, ‘Malipilipi gokiladi be zazanga goandi. Tamoata alaurituka dipura zazanga goandia-mua. Be bokai goaniandi nibe dipura mua nge alaurituka zazanga nedi goandi.’ ");
INSERT INTO mva_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kodeka tamoata rairaituka dipura be dimalipi nge dimai be ‘mone siliua’ teke-teke didoki. ");
INSERT INTO mva_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ilako be tamoata dipura mua dimai nge ilodi dipile masa zazanga bibia dadoki. Ata moarunga dimalipituka-mua nge ‘mone siliua’ teke-teke didoki. ");
INSERT INTO mva_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Zazanga nedi didoki be dita nge uma-marau digulungaetaki. ");
INSERT INTO mva_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Be bokai dipile, ‘Tamoata alaurituka dipura nge tago uanana sasalaga dimalipi. Keka oabunabe kimalipi nibe irairai-ba. Amari iumoate-kamai-tina, ata zazanga tekedia-doi kuiang-kama!’ ");
INSERT INTO mva_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kodeka uma-marau itaguraki be teke bokai irai, ‘Ruanga, ngau tago upakaiko. Kusumoala ka kupura be ‘mone siliua’ teke amari ngaena-lo kumalipitaki. ");
INSERT INTO mva_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Zazanga nem godoki be goalale. Tamoata alaurituka ipura kamru zazanga tekedia-doi miang-kamingru kana urere. ");
INSERT INTO mva_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‘Mone’ ngaedi nge negu. Be rerengagu-lo bakara mbasaki kana nge tago teke iboadu ba ngaraia. Ki masa muzi iauia uemaki ka kuilo-rataka?’” ");
INSERT INTO mva_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Be Iesus pile ngaedi ane be sule ne ngaedi nge imambuaki, “Alalaurituka masa damua, be muamuatuka masa dalauri.” ");
INSERT INTO mva_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iesus Ierusalem ilakolako nge tagataga ne kulemoa-be-rua nedia-ba ilakuakidi be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Kamalongo. Ambe Ierusalem talakolako. Makara masa Tamoata Natu dadoki be tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki luma-dio danangai. Be masa umoatea kana be dasumoalataki. ");
INSERT INTO mva_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kodeka dadoki be Ungguma Takadi dandi be ono damanai be darautotoki be kai kapalapala uauau-o darokatagaki. Ata amaridi tolianao be masa ngamarang be moauriuri ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kodeka Zebidi natu Zems be Zon nge tina-diaru zaiza be dipurato. Be tina-diaru ilako Iesus aro tuku-nao irokazokuria be bokai irai, “Kana teke goemakana kana urere.” ");
INSERT INTO mva_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Be Iesus itaguraki be bokai itegi, “Rakana kurere?” Be aine ngae ikatu be ipile, “Gosumoalana be bong kutanepoa masa natugu ruoti oanam be ngasimo dasoakiru.” ");
INSERT INTO mva_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kodeka Iesus bokai ira-diaru, “Tagona-tina kakauaru rakana kata ka kasinautakiaru. Sema ono ngau saringatuka dang msing kana nge kaboaduru ono kamasingru ki tago?” Be diaru dikaturu be bokai dipileru, “Keru kiboaduru.” ");
INSERT INTO mva_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Bokai dipileru nge Iesus bokai ipile, “Moimoi masa sema kanagu-lo dang kamasingru. Ata naita oanagu-o ki ngasigu-o ngasoaki kana nge ngau tago uboadu msumoalataki. Tamoata maka Tama-gu kabadi ambe makara iadoraki be dieno-la ka masa oanagu-o be ngasigu-o dasoaki.” ");
INSERT INTO mva_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bong tagataga ne kulemoa takadi dilongo nge Zems be Zon dilo-ratakidiaru. ");
INSERT INTO mva_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kodeka Iesus ikiladia-doi be bokai iradi, “Kam kakaua Ungguma Takadi anuatanepoa kandi nge gadagada nedi diduamatematedia-tina uia. Be tamoata nedi aradi bibia nge dikaikai-tina be gadagada pile dilongolongo be ditagatagadi. ");
INSERT INTO mva_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ata muzi ngaedi moaki kam-lo dieno. Tamoata naita aram ngalaba kana kurere nge kam moarunga malipilipi kana-ming ngapura. ");
INSERT INTO mva_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Be tamoata naita ngamuatuka-kaming kana irere nge kam moarunga dududu kana-ming bokana ngasoaki. ");
INSERT INTO mva_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tamoata Natu nge bokainaina. Ngai tago damalipini kana ka ipura. Tago. Ngamalipidi kana ka ipura, be ngamate be ono kokoko-tina ngazazadi be ngamuleakidi.” ");
INSERT INTO mva_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Zeriko anua dipereki be dialalale nge tamoata be aine kokoko-tina ditagadi. ");
INSERT INTO mva_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tamoata rua mata-diaru leuadi nge makara zala zage-o disoakiru. Bong bokai dilongoru Iesus ambe ngabagapaliti-diaru kana nge dimereru be bokai dipileru, “Tanepoa, Debiti Natu, ilom ngataga-kamairu.” ");
INSERT INTO mva_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Makara nge tamoata be aine Iesus zaiza dialalale-budu ditaguraki be diebulo-diaru be aoa-diaru daonoru kana dira-diaru. Ata diaru kaikai-la dimereru be bokai dipileru, “Tanepoa, Debiti Natu, ilom ngataga-kamairu!” ");
INSERT INTO mva_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kodeka Iesus itui be ikila-diaru be itegi-diaru, “Rakana memaka-kamingru kana karereru?” ");
INSERT INTO mva_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Be diaru dikaturu be dipileru, “Tanepoa, mata-mairu gouasari be kaba gaitaitaru kana kirereru.” ");
INSERT INTO mva_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Makara nge Iesus ilo itaga-diaru be mata-diarua-lo idaurakilako be oaikiki-tina mata-diaru diuia be kaba ditaru. Kodeka ditagurakiru be Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Iesus tagataga ne zaiza Ierusalem dilakolako nge Betpeiz anua-lo dipura. Anua muku ngae nge buku muku ara ‘Olib’ saringa ka ieno. Makara be tagataga ne rua inepi-diaru be dimuaru. ");
INSERT INTO mva_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Dalaleru kana nge bokai ira-diaru, “Anua ene aro-mingru ieno kanana-lo kamalakoru. Makara masa oaikiki-tina ‘dongki’ teke ditukui be natu diaru dituituiru nge kamatearu. Kamarubetakiaru be kamabaga-dianauru. ");
INSERT INTO mva_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tamoata teke bakara ira-kamingru nge bokai kamaraiaru, ‘Biabiadi nema ireretaki-diaru. Masa oaikiki-la ngamuleakidi.’” ");
INSERT INTO mva_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kana ngaedi bokai dipura be ‘propet’ teke pilenga dikalingo. ‘Propet’ ngae bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zaion anua bokai kamarai: ‘Kamate. Anuatanepoa neming teke ambe ipurapura-kaming. Ngai muzinga malielie-ba, be ‘dongki’ tekenao isoaki be ipurapura. ‘Dongki’ natu tekenao isoaki be ipura.’” (Zek 9:9) ");
INSERT INTO mva_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kodeka tagataga ne ruoti nge dialaleru be Iesus-la ira-diaru bokana kana diemakiru. ");
INSERT INTO mva_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Be dialaleru be ‘dongki’ natu diaru dibaga-diaru be kusi-sili nediaru ‘dongki’-o dinangaru be Iesus odio isoakiria. ");
INSERT INTO mva_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Makara nge tamoata be aine dum kanabiabia teke nge kusi nedi dipasi be zala-lo diulalaki. Aludi kai sapara dikoto be diulalaki. ");
INSERT INTO mva_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kodeka tamoata be aine ngaedi nge Iesus aro be muri dialalale be dimoaguruguru be bokai dipilepile, “Debiti Natu tarakeaki! Tamoata naita Tanepoa ara-nao be ipura masa Nanaranga ngamaroui. (Sam 118:26) Nanaranga ara atabala-tina tanangai!” ");
INSERT INTO mva_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesus Ierusalem-lo ipura nge tamoata be aine makara nge dipitilaki-tina be bokai ditegi, “Ngara naita kata?” ");
INSERT INTO mva_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Be tamoata be aine Iesus zaiza dialalale-budu nge bokai dipile, “Iesus. Ngai ‘propet’ kata. Anua ne Nasaret, ege Galili kaba-lo.” ");
INSERT INTO mva_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kodeka Iesus ilako be Nanaranga pera nena-lo isili be tamoata makara ditabulibuli be kana dizazaza nge itaodi. Tamoata ‘mone’ didokidoki be dibubuiri nge bagi nedi ibagabuiri. Be tamoata maka bune didokidoki tamoata takadi dianiandi be dizazaza nge bagi nedi ioreaki-iotiaki. ");
INSERT INTO mva_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Be bokai iradi, “Nanaranga ‘Buku’ nena-lo bokai digere, ‘Pera negu nge ono rabonga.’ Ata kam ambe ‘anako gupadi’ bokana kabasaki.” ");
INSERT INTO mva_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kodeka Iesus makara Nanaranga pera nena-lo isoaki be matadi leuadi be aedi matedi nge dipura be iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ata tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki kaba bokai dita kana uia iememaki be natu-muku Nanaranga pera nena-lo dimeremere be bokai dipilepile, “Debiti Natu tarakeaki” nge ilodi dira-tina. ");
INSERT INTO mva_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kodeka ditaguraki be Iesus bokai dirai, “Natu-muku pilengadi kulongo ki tago?” Be Iesus ikatu be ibokai pile, “Ulongo! Nanaranga ‘Buku’ nena-lo pile ngaedi kaleze ki tago? ‘Natu-muku be natu ruru-kangkang aoa-dialo masa rakeaka uia dapusika.’” (Sam 8:2) ");
INSERT INTO mva_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bokai ipile be kodeka iperekidi be oabubu ngarana-lo nge Betani-lo ieno. ");
INSERT INTO mva_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Izama nge Iesus oabuna-tina be imarang be Ierusalem ilako. Zala-lo ialalale nge tole imate-tina. ");
INSERT INTO mva_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bokaibe kai kalingo kangkang ara ‘pig’ teke zala zagenao ituitui be ite nge ilako. Ata kalingo tago teke ite. Dauna-ba ita. Kodeka kai ngae bokai irai, “Tago iboadu kaba alauri kalingom dapura!” Makara nge kai ngae oaikikitina-la imarango. ");
INSERT INTO mva_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tagataga ne kaba bokai dita nge dipitilaki-tina. Be bokai ditegi, “Baituka be kai ngae oaikiki-tina imarango?” ");
INSERT INTO mva_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Be Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming! Lama kaunia-tina be ilo-ming tago dirua nge iboadu kai ngae uemaki bokana kana kamaememaki. Tago kana-la bokainaina kamaememaki. Iboadu buku ngae bokai kamarai, ‘Gomatate be nem-la be makasi-lo gorokakikolako.’ Be kana ngae masa emaka-ming ngapura. ");
INSERT INTO mva_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lama kauni be karabo masa kana kareretakia-tina be Nanaranga karaboi nge kamadoki.” ");
INSERT INTO mva_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kodeka Iesus Nanaranga pera nena-lo isili be tamoata be aine isuledi. Isulesuledi nge tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia dipura be Iesus bokai ditegi, “Kaiboang nangatadi-o ka kana ngaedi kuememaki? Be kaiboang ngaedi naita ka iangko?” ");
INSERT INTO mva_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Be Iesus ikatu be bokai ipile, “Ngau tegi negu teke mtegi-kaming noko. Kakatungi masa mra-kaming kaiboang nangatadi-o ka kana ngaedi uememaki. ");
INSERT INTO mva_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kaiboang ono Zon ruku ono tamalinga ane tamoata be aine irukudi nge inanga ka dipura? Nanaranga-lo ki tamoata-lo ka dipura?” Iesus bokai itegi nge nedia-la maradi bokai diegore, “Masa bakara tapile? Nanaranga-lo kana tapile masa bokai ngapile, ‘Bokai nge bakara ka lama tago kaunani?’ ");
INSERT INTO mva_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ata tamoata-lo ka dipura kana tapile nge tamoata be aine tamatakuridi. Maka ma tamoata be aine moarunga dipile Zon nge ‘propet’ kata.” ");
INSERT INTO mva_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kodeka ditaguraki be Iesus bokai dirai, “Tago kikaua!” Be Iesus bokai iradi, “E, ngau bokai. Tago iboadu mra-kaming kaiboang ngaedi inanga ka uita be kana ngaedi uememaki.” ");
INSERT INTO mva_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kodeka Iesus bokai ipile, “Bakara ilo-ming dipile? Tamoata teke natu moane rua. Ilako be labalaba bokai irai, ‘Natugu, kaituka uma-lo golako be gomalipi.’ ");
INSERT INTO mva_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Be natu ngae bokai ipile, ‘Tago urere.’ Ata alauri nge ilo takaia inangai be uma-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kodeka tamoata ngae kaba ilako be natu sikisiki pile-la ngaedi ka kaba irai. Be natu ngae ikatu be bokai ipile, ‘Biabiadi, masa mlako.’ Ata tago ilako! ");
INSERT INTO mva_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Natu nangata ka tama rerenga itagadi?” Be di dikatu be dipile, “Labalaba.” Kodeka Iesus bokai iradi, “Moimoi ka ura-kaming. ‘Tagisi’ dokidoki be aine pogizagiza masa aro-ming damua, be anua ono Nanaranga ngatanepoa kanana-lo dasili mua. ");
INSERT INTO mva_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zon ipura be zala adoado itiking-kaming be tago lama kaunani. Ata ‘tagisi’ dokidoki be aine pogizagiza nge lama diunani. Kam kana iememaki kaita-tina, ata alauri nge tago ilo-ming kabuiri be lama kaunani. ");
INSERT INTO mva_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pile ono tonanga takadi kamalongo. Tamoata teke uma kanabiabia teke iemaki be ‘uain’ itanomi be iaringi. Uma ilona-lo nge gimoa ono ‘uain’ pisaka teke iemaki, be bazarua rakebuli ono tamoata danarinari kana nge ikeli. Alauri nge tamoata alu iandi be damalipilipitaki kana. Be ngai itui be kasau anua tekena-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bong ono ‘uain’ dokia ngapura kana nge uma-marau malipilipi kana inepidi be ‘uain’ kana dabagani kana. ");
INSERT INTO mva_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Malipilipi kana uma ngaena-lo dilako nge tamoata uma dimalipilipitaki ditaguraki be teke dipaliti, teke diumoatei be tolia dipatui. ");
INSERT INTO mva_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Makara nge uma-marau kaba malipilipi kana kokoko-la be inepidi be dialale be ‘uain’ kana alu dabagani kana. Ata tamoata uma dimalipilipitaki ditaguraki be malipilipi kana matamata dipura dibasakidi bokana dibasakidi. ");
INSERT INTO mva_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Alaurituka nge ne natu inepi. Ilona-lo nge bokai ipile, ‘Natu-gu masa damuaki.’ ");
INSERT INTO mva_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ata tamoata uma dimalipilipitaki natu dite nge bokai dipile, ‘Nge uma-marau natu, be ngai ka tama kana ne ngadoki be nganemdi kana. Aria, taumoatei be uma ne tadoka-le.’ ");
INSERT INTO mva_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kodeka uma-lo ka didoki be eluku dirokakalako be diumoatei.” ");
INSERT INTO mva_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kodeka Iesus bokai itegidi, “Ilo-ming bakara dipile? Uma-marau ngapura masa tamoata ngaedi bakara ngabasakidi?” ");
INSERT INTO mva_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Be di dikatu be dipile, “Tamoata goalakadi ngaedi masa sururu kana-tina-bibia ngandi be ono ngara-leuadi. Be masa ngataguraki be uma ngae ngadoki be tamoata takadi ngandi be bong-tina ono ‘uain’ dokinga-o nge ‘uain’ kana daniani.” ");
INSERT INTO mva_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kodeka Iesus bokai iradi, “Nanaranga ‘Buku’ nena-lo pile ngaedi kaleze ki tago? ‘Ariri maka pera kelikeli disegeaki ka pera kaiboang ne. Kana ngae nge Tanepoa ka iemaki. Tea nge diuia-tina!’ (Sam 118:22-23) ");
INSERT INTO mva_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nge bokai ka ngau ura-kaming! Nanaranga masa ngataguraki be bong ono ngatanepoa kana nge ngadokale-kaming be tamoata takadi ngandi be bong-tina ono ‘uain’ dokinga-o ‘uain’ ne dapupurakini.  ");
INSERT INTO mva_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tamoata naita ariri ngaenao itapuloria masa muku-muku ngapura. Ata ariri ngae tamoata nangatana-o isapasiria masa ngatake-babai.” ");
INSERT INTO mva_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tamoata Nanaranga ditabatabai dimuamuadi be Parasi pile ono tonanga ngaedi dilongo nge dikaua Iesus di ka irarangakidi. ");
INSERT INTO mva_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bokaibe dauauri kana, ata tamoata be aine dimatakuridi. Maka ma tamoata be aine moarunga dipile Iesus nge ‘propet’ kata. ");
INSERT INTO mva_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesus kababe pile ono tonanga ane be isuledi. Bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bong ono Nanaranga ngatanepoa kana nge bokainatuka: Anuatanepoa teke natu moaneka iroti be moanako ono rotinga biabia teke iemaki. ");
INSERT INTO mva_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Moanako iemakia-doi kodeka malipilipi ne inepidi be dialale be tamoata moanako ngaena-lo ikeliakidi nge dialuludi be dapura kana. Ata pura disege. ");
INSERT INTO mva_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Bokaibe malipilipi ne kaba takadi inepidi. Dalale kana nge bokai iradi, ‘Tamoata moanako-lo ukiladi bokai kamaluludi, “Moanako negu ambe uadoraki be ieno. ‘Bulumakau’ negu be natudi negu dabudabudi ambe umoateadi dipura. Kana moarunga ambe moataungakadi dipura be dieno. Moanako ono rotinga-lo kamapura!” ’ ");
INSERT INTO mva_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kodeka malipilipi kana dialale be tamoata kiladi dipura nge dialuludi, ata di tago dilongo be malipi kandia-lo dilako. Teke uma kanana-lo ilako. Teke ‘mone’ ne malipitakana-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ata aludi ditaguraki be malipilipi didokimatedi be dipalitidi be diumoatedi. ");
INSERT INTO mva_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Anuatanepoa ngae ilongo nge nama ira-tina be koai-bagi ne inepidi be tamoata gagazigazi nge diumoatedi be anua nedi dibulai. ");
INSERT INTO mva_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Alauri nge anuatanepoa ngae itaguraki be malipilipi ne ikiladi be bokai iradi, ‘Roti moanako ambe moataungaka ipura be ieno. Ata tamoata moanako-lo ukiladi nge kana iauia tago teke diemaki be ono bubuna iauia miandi be moanako ngaena-lo dapura! ");
INSERT INTO mva_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Zala moarunga-lo kamalako be tamoata be aine mata-mingo didung nge kamaluludi be moanako-lo dapura.’ ");
INSERT INTO mva_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kodeka malipilipi dialale kaba moarunga-lo be tamoata matadi-o didung nge dialuludi. Tamoata goalakadi be uia nge dialuludia-doi be dipura. Dipurapura nibe pera ono moanako ngapura kana nge ikauri. ");
INSERT INTO mva_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Disoakiria kodeka anuatanepoa ngae ipura be itedi. Makara nge tamoata teke ngazing ono rotinga tago inangananga be isili nge makara maradi ite. ");
INSERT INTO mva_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kodeka bokai itegi, ‘Ruanga, baituka be kusili? Ngazing ono rotinga tago kunangananga!’ Ata tamoata ngae tago sesu ipile. ");
INSERT INTO mva_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Be anuatanepoa ngae itaguraki be malipilipi kana bokai iradi, ‘Ae be luma kamauau be eluku malama tagongana-lo kamarokakalako. Makara masa ngatangtang be ile ngakaraposaposa.’” ");
INSERT INTO mva_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Be Iesus pile ne ngaedi bokainatuka imambuaki, “Tamoata kokoko-tina aluludi dipura, ata teke-tina-teke ka Nanaranga idokidokidi.” ");
INSERT INTO mva_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Makara nge Parasi dialale be diepilei be tegitegi ane be Iesus ne pilenga datagadi be datoi kana. ");
INSERT INTO mva_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kodeka tagataga nedi be Erot tamoata ne alu dinepidi be Iesus bokai dirai, “‘Tisa,’ keka kikaua kaiko adoadom-tina. Pile kalingodia-lo be Nanaranga mata ne kusulesuletaki. Tamoata tago teke ireperepekiko be rerenga kutagatagadi. Maka ma tamoata aradi otioti ki aradi tagotago nge suridi tekedia-doi bokana kubabasakidi. ");
INSERT INTO mva_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Gora-kama! Ilom bakara ipile? Rom ‘Sisa’ nedi ‘tagisi’ ania ngapurapura ki moaki?” ");
INSERT INTO mva_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ata Iesus ikaua nge muzi goalakadi ilodia-lo dieno ka bokai dipile. Be bokai iradi, “Bolinga-ming ratadi! Bakara ka katoia be giriki memaki kana? ");
INSERT INTO mva_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","‘Mone’ ono ‘tagisi’nga teke kamaitikina!” Kodeka ‘mone’ teke dieluakani. ");
INSERT INTO mva_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Be bokai itegidi, “Naita anunuka be ara ka makare ‘mone’-o dieno?” ");
INSERT INTO mva_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Be di dikatu be dipile, “‘Sisa’ anunuka be ara.” Kodeka Iesus itaguraki be bokai iradi, “‘Sisa’ kana ne nge ‘Sisa’ kamaniani. Be Nanaranga kana ne nge Nanaranga kamaniani.” ");
INSERT INTO mva_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tamoata ngaedi pile bokai dilongo nge dipitilaki-tina be Iesus dipereki be dialale. ");
INSERT INTO mva_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Amarina-la ngaranao nge Sadiusi alu Iesus-lo dipura. Sadiusi dipile matemate tago iboadu damarang. ");
INSERT INTO mva_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Kodeka Iesus bokai dirai, “‘Tisa,’ Moses bokainatuka isule, ‘Tamoata iroti be natu tago teke isi ipura be imate nge tari iboadu aine ngauati be toka imate nge natu ngapurakidiani.’ ");
INSERT INTO mva_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Taritokatoka lima-rua marama disoaki. Labalabatuka iroti be natu tagona-la teke ipura be imate. Bokaibe tari muri itagai nge itaguraki be toka aine ipereki nge iuati. ");
INSERT INTO mva_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tari ruaianao be ilako lima-ruaianao nge bokaina-doi dimuzi. Aine-doi teke diuati. ");
INSERT INTO mva_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Alauri-tuka nge aine imate. ");
INSERT INTO mva_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bong ono matemate damarang kanana-o masa naita roa? Maka ma diato lima-rua nge diuatia-doito!” ");
INSERT INTO mva_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Be Iesus ikatu be bokai ipile, “Pile ngaradi nge kapakadi! Nanaranga ‘Buku’ ne be kaiboang ne tago kakauataki ki? ");
INSERT INTO mva_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bong matemate damarang masa lang anua-lo Nanaranga ‘enzel’ ne bokana dasukoaki, be tago masa darotiroti be tago masa roti kana be negeadi dapurapura. ");
INSERT INTO mva_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ata mate-lo be marang rangaka nge bokai mtegi-kaming kana. Nanaranga pilenga ngaedi ira-kaming kaleze ki tago? Nanaranga bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngau Abaram Nanaranga ne, Aisak Nanaranga ne be Zekop Nanaranga ne.’ Bokaibe Nanaranga ngae nge moauriuri-la disukoaki Nanaranga nedi. Tago matedi Nanaranga nedi.” ");
INSERT INTO mva_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tamoata be aine moarunga Iesus sulenga dilongo nge dipitilaki-tina be aoa-diaba disanganga. ");
INSERT INTO mva_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parasi bokai dilongo Iesus ambe Sadiusi aoa-di iono nge dipura be diekapotaki be kabu-doi teke disoaki. ");
INSERT INTO mva_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kodeka teke itui be Iesus ngatoi kana. Tamoata ngae nge Moses Mata ne disulesuletaki kata. ");
INSERT INTO mva_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tamoata ngae bokai itegi, “‘Tisa,’ Nanaranga mata ne Moses igere nge nangata ka ara biabiatuka?” ");
INSERT INTO mva_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Be Iesus ikatu be bokai ipile, “‘Nanaranga nem Tanepoa nge moagem be pusom-lo, be mariabakam-lo be ilo lelenaka nem moarungana-lo be gorereretaki.’ ");
INSERT INTO mva_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mata ngae ka muamuatuka be biabiatuka. ");
INSERT INTO mva_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Mata ngae ruaia nge bokai, ‘Tamoata takadi gorereretakidi nem-la kurereretakiko bokana.’ ");
INSERT INTO mva_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses Mata ne moarunga be ‘Propet’ pilengadi moarunga labudi nge mata ruoti ngaedi.” ");
INSERT INTO mva_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parasi nge isi diekapotaki be disoaki-la. Kodeka Iesus bokai itegidi, ");
INSERT INTO mva_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ilo-ming bakara dipile? Kristus nge naita natu?” Be di dikatu be dipile, “Debiti natu.” ");
INSERT INTO mva_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kodeka Iesus bokai ipile, “Bokai nge bakara ka Oli Spirit Debiti ilona-lo isili be Debiti itaguraki be ne natu Tanepoa kana ikilai. Debiti bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nanaranga Tanepoa itaguraki be Tanepoa negu bokai irai: Makare kaba aradi bibiatuka oana-guo gosoakiria, nibe erekei nem mduaposakidi be aem babadi erumadi mnangadiaria.’ (Sam 110:1) ");
INSERT INTO mva_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Kamate. Debiti nena-la be Kristus Tanepoa kana ikilai nge Kristus masa bakara be Debiti natu?” ");
INSERT INTO mva_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ata tamoata tago teke pilenga ikatu. Maka ma dimatakuri. Bokaibe bong ngaranao be ilako nge tago teke iboadu ngategi. ");
INSERT INTO mva_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kodeka Iesus itaguraki be tamoata be aine moarunga be tagataga ne bokai iradi, ");
INSERT INTO mva_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Parasi be tamoata Moses Mata ne disulesuletaki nge Moses kaba didoki be disulesule-kaming. ");
INSERT INTO mva_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bokaibe pile moarunga dirara-kaming nge kamalongolongo be kamatagatagadi. Ata muzingadi nge moakina-tina kadoki be katagatagadi. Pile-ra disulesuletaki, ata tago ditagatagadi. ");
INSERT INTO mva_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kana moatubudi didokidoki be tamoata bage-dio dinanganangaria. Ata tago sesu didumadumadi be kana moatubudi ngaedi nge dibazibazidi. Tago-la! Kabodi siki dananga be daduma ki! Tago be tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Kana moarunga diememaki nge ono-ba tamoata takadi daitaita kana ka diememaki. Goate nedi ono Nanaranga pilenga dieneno nge dilaba-tina. Be kusi nedi ono Nanaranga muaka ipurapura nge zagedi disalaga-tina! ");
INSERT INTO mva_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Moanako bibia-lo nge kaba irakingadi didokidoki. Be pera ono serereinga-lo nge aro-tina-lo soaki direrere. ");
INSERT INTO mva_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Malala-lo dialalale nge direrere tamoata takadi di damuamuakidi be direrere-tina ‘Tisa’ kana dakilakiladi. ");
INSERT INTO mva_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ata kam moaki ‘Tisa’ kana dikilakila-kaming! ‘Tisa’ neming nge tekena-la, be kam moarunga nge taritokatoka. ");
INSERT INTO mva_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Makare kateka-o nge moaki teke ‘mama’ kana kakilakilai. Maka ma Tama-ming tekena-la be lang anua-lo isukoaki. ");
INSERT INTO mva_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Moaki teke ‘biabiadi’ kana dikilakilaiko. Biabiadi neming tekena-la. Kristus ka biabiadi neming. ");
INSERT INTO mva_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Tamoata naita ara bibiatuka kana irere nge moarunga malipilipi neming ngapura. ");
INSERT INTO mva_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bokaibe tamoata naita nena-la irakerakeaki masa balaka ngapura. Be tamoata naita nena-la ibalabalaki masa rakeaka ngapura. ");
INSERT INTO mva_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ue! Kam Parasi be kam tamoata Moses Mata ne kasulesuletaki! Kamakadoma-tina! Giriki bibia didoki-kaming! Bolinga-ming ratadi! Anua ono Nanaranga ngatanepoa kana aoa ono silinga nge tamoata matadia-lo kaononotalako. Ata kam neming-la nge tago iboadu kamasili. Be tamoata maka kapipi be kamasiliakidi kana nge tago masa dasili!  ");
INSERT INTO mva_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ue! Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Giriki bibia didoki-kaming! Kam bolinga-ming ratadi! Aine narenare kabobolesidi be pera kandi katototoledi! Be ono giriki neming kamakubati kana nge rabo salagabulidi kaememaki. Bokaibe sururu kamadoki kana nge dasalaga-tina kana! ");
INSERT INTO mva_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ue! Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Kamakadoma-tina! Giriki bibia ditaga-kaming! Kam bolinga-ming ratadi! Makasi bibia be kaba bibia kalalaleaki be tamoata teke kamauasai be sulenga-ming ngatagatagadi kana. Be bong tamoata teke kauasai nge tamoata ngae masa muzigoala emakinga kam muzigoala emakanga-ming ngauasadi. Bokaibe kam-la bokana masa eoa tago matemate-lo ngalako! ");
INSERT INTO mva_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Mata-ming leuadi ka tamoata takadi zala kaititikingdi! Giriki bibia didoki-kaming! Tamoata takadi bokai kararadi: ‘Tamoata Nanaranga pera ne irangaki be pile tago tototo iemaki nge kanaba. Ata ‘gol’ pera ilona-lo dieno irangaki be pile tago tototo iemaki nge nena-la pilenga ngatagadi be kana irangaki nge ngaemaki.’ ");
INSERT INTO mva_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ngaongao-ming! Mata-ming leuadi! Nangata ka ara biabia? Nanaranga pera ne maka ‘gol’ iemaki be irata ki ‘gol’ ka ara biabia? ");
INSERT INTO mva_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sulenga-ming takadi bokai: ‘Tamoata bagi ono Nanaranga tabaia ipurapura irangaki be pile tago tototo iemaki nge kanaba. Ata tamoata tabataba bagi atabala dieno aradi-o be pile tago tototo iemaki nge pilenga ngatagadi be kana irangaki nge ngaemaki.’ ");
INSERT INTO mva_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mata-ming leuadi! Nangata ka ara biabia? Bagi maka tabataba iemaki be dirata ki tabataba ka aradi bibia? ");
INSERT INTO mva_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bokaibe tamoata naita bagi ono Nanaranga tabaia ipurapura irangaki be pile tago tototo iemaki nge bagi be kana moarunga bagi-o dieno aradi-o be pile tago tototo iemaki. ");
INSERT INTO mva_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tamoata naita Nanaranga pera ne irangaki be pile tago tototo iemaki nge pera be Nanaranga aradi-o be pile tago tototo iemaki. Maka ma Nanaranga ka makara isukoaki. ");
INSERT INTO mva_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tamoata naita lang anua ara-nao be pile tago tototo iemaki nge Nanaranga bagi ne ono tanepoanga be bagi-marau aradi-o be pile tago tototo iemaki. ");
INSERT INTO mva_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Kamakadoma-tina! Giriki bibia didoki-kaming! Dagurai kana-ming uma-lo katanotano nge kulemoa-kulemoa-lo kanegenege be tekedi nge Nanaranga kaniani. Ata Nanaranga mata-tina ne nge tago katagatagadi. Nanaranga mata ne ngaedia-re: Muzi uia tamoata takadi kamaememakidi, tamoata takadi ilo-ming datagatagadi, be Nanaranga-la ka kamatagatagai. Nanaranga mata ne ngaedi nge kamatagatagadi be kamaememaki, ata takadi matamata urangaki nge moaki ilo-ming dileuataki. ");
INSERT INTO mva_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mata-ming leuadi ka tamoata takadi zala kaititikingdi! Suru kanaming-lo nge lango karorokaki, ata boro moamoarunga kadokidoki be suru zaiza be katonotono. ");
INSERT INTO mva_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Kamakadoma-tina! Giriki bibia didoki-kaming! Kam bolinga-ming ratadi! Tabira be sema kana-ming nokudi nge kasasaki be digoazagoaza, ata ilodia-lo nge kapisa be muzi-ramo dikauri! ");
INSERT INTO mva_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kam Parasi! Mata-ming leuadi! Sema kana-ming ilodi kamasaki be dagoaza noko. Bokai masa nokudi dagoaza! ");
INSERT INTO mva_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Kamakadoma-tina! Giriki bibia didoki-kaming! Kam bolinga-ming ratadi! Tea-ming nge buna ono tamoata matedi kumrakadi dipurapura bokana oaoa-sepukadi! Nokudi-o nge teadi gokulang-tina, ata ilodia-lo nge tamoata tapou be matedi moapurukadi dikauri! ");
INSERT INTO mva_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kam tea-ming bokainaina. Tamoata moarunga ditete-kaming nge ilodi dipilepile kam tamoata uia kaoa, ata iloming-lo nge boli mata be muzi goalakadi dikauri. ");
INSERT INTO mva_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kam tamoata Moses Mata ne kasulesuletaki be kam Parasi! Kamakadoma! Giriki bibia didoki-kaming! Kam bolinga-ming ratadi! ‘Propet’ podadi-o nge bazarua kakelikeli be tamoata adoadodi podadi nge kangazingzingdi. ");
INSERT INTO mva_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Be bokai kapilepile, ‘Toira tubuma soakingadia-lo be gapura bokana nge ambe tago gadumadi be ‘propet’ ngaedi gaumoatedi.’ ");
INSERT INTO mva_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bokai kapile nge ambe neming-la karangaki-kaming kam ka tamoata ‘propet’ diumoatedi tubudi. ");
INSERT INTO mva_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aria, kamatui be kana tubu-ming dimarangaki nge kamamambuaki! ");
INSERT INTO mva_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kam moata natu be moata elu! Moaki ilo-ming dipile eoa tago matemate masa kamairatudi! ");
INSERT INTO mva_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ngau ka ura-kaming! ‘Propet’ be tamoata kauakauadi be tamoata maka tamoata takadi disulesuledi nge masa alu mnepidi be dapura-kaming. Alu masa kamaumoatedi. Alu masa kai-o kamarokatagakidi. Be alu masa pera neming ono serereinga-lo be kamarautotokidi be anua-anua-lo kamataotaodi be kamalalaleakidi. ");
INSERT INTO mva_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Bokaibe tamoata moarunga girikidi tagotago darakadi maka kateka ngaenao dibala masa kam omingo dalako. Tamoata girikidi tagotago nge Abel maka giriki tagotago-lo be imai Barakaia natu Zekaraia-lo daga. Zekaraia nge Nanaranga pera ne be bagi ono Nanaranga tabaia ipurapura maradi ka kaumoatei. ");
INSERT INTO mva_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Moimoi ka ura-kaming! Giriki moarunga ngaedi masa tamoata be aine kaituka makare disoaki odi-o dabala. ");
INSERT INTO mva_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ierusalem! Ierusalem! Kaiko ‘propet’ kumoatedi be tamoata Nanaranga inepidianiko nge patu oti kundi be dimate. Bong kokoko-tina urere be luma-gu mnanaraki be mboabuniko mang-la aineka natu bazi eruma inanganangadi bokana, ata tago kusumoala! ");
INSERT INTO mva_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pera nem kodeka masa segeaka ngapura be ubana-ba ngaeno! ");
INSERT INTO mva_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngau ka bokai uraiko: Tago iboadu kababe gotea nibe bokai gopile, ‘Tamoata naita Tanepoa ara-nao ipura nge Nanaranga iboadu ngamaroui.’” (Sam 118:26) ");
INSERT INTO mva_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesus Nanaranga pera ne ipereki be ialalale nge tagataga ne dimai be pera kailo kania moarunga disikengtakini. ");
INSERT INTO mva_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ata Iesus bokai iradi, “Kana moarunga ngaedi nge kaita uia ki tago? Moimoi ka ura-kaming! Patu ngaedi masa tago teke kabana-lo ngaeno. Moarunga masa dagamang be darokakiria.” ");
INSERT INTO mva_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iesus ilako ‘Olib’ Buku-o isoaki be tagataga ne rubediaba dipura. Be bokai ditegi, “Gora-kama! Aira-tina be masa kana ngaedi dapura? Be kilala ono mulenga nem masa nangata ngapura noko, be kodeka kateka manubunga ngapura?” ");
INSERT INTO mva_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Be Iesus ikatu be bokai iradi, “Kaba kamaitaita-tina uia! Tamoata teke ngabolesi-kaming takana! ");
INSERT INTO mva_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tamoata kokoko-tina masa aragu-o be dapura be bokai dapile, ‘Ngau ka Kristus.’ Be masa dataguraki be tamoata kokoko-tina dabolesidi. ");
INSERT INTO mva_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Koai saringatuka dipurapura masa malongadi kamalongolongo. Be koai kasau-lo diememaki masa rukudi kamalongolongo. Ata ilom-ing moaki dibuku. Kana bokainaina masa dapurapura, ata ilo-ming moaki dipile kateka manubunga ambe isaringa. ");
INSERT INTO mva_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Anua teke masa ngataguraki be anua takaia diaru daeungru. Ungguma teke masa ngataguraki be ungguma takaia diaru daeungru. Kaba takadia-lo masa tole bibia be rike bibia dapurapura. ");
INSERT INTO mva_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kana ngaedi nge aine saringatuka nganeki kana be surururu matamata dipurapurani bokana kaoa. ");
INSERT INTO mva_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kodeka, masa dauauri-kaming be sururu bibia dang-kaming be daumoate-kaming. Ngau kanabe ungguma moarunga kateka-o masa dasegeaki-kaming. ");
INSERT INTO mva_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Bong ngaradia-lo masa tamoata kokoko-tina lama diunana nge damurinaia. Be tamoata kokoko-tina masa nedia-la daesegesegeaki be ruangadi dadokidi be erekei nedi luma-dio danangadi. ");
INSERT INTO mva_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kodeka ‘propet’ bolingadi ratadi masa kokoko-tina dapura be tamoata kokoko-tina dabolesidi. ");
INSERT INTO mva_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Be muzi goalakadi masa dakoko. Bokaibe tamoata kokoko-tina masa reretaka mata darokaki. ");
INSERT INTO mva_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ata tamoata naita ikaiboang be isoaki-la nibe manubunga-nao masa Nanaranga ngauketi be ngamuleaki. ");
INSERT INTO mva_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pile Uia ngae ege-ege kateka-o dasuletaki be tamoata be aine moarunga dalongo noko, kodeka kateka manubunga masa ngapura. ");
INSERT INTO mva_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“‘Kana goalakana-tina anua gagamang’ masa kaba ratadia-lo ngatuitui be kamate. Kana goalaka ngae ka tongira ‘Propet’ Daniel irangaki.” (Tamoata ilezeleze nge pile labudi ngakauataki.) ");
INSERT INTO mva_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Bong ngaradia-lo masa tamoata moarunga Zudea kaba-lo disoaki nge dairatu be buku kaba-lo dalako. ");
INSERT INTO mva_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bokaibe tamoata eluku isoaki nge moaki pera kanana-lo isili be kana ne moarunga idoki. ");
INSERT INTO mva_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Be tamoata uma kanana-lo isoaki nge moaki imule be kusi-sili ne ibagai. ");
INSERT INTO mva_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bong ngaradia-lo nge aine tinetine be aine natu-muku diarururungdi nge dimakadoma-tina! ");
INSERT INTO mva_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nanaranga kamaraboi be kana ngae moaki madidi bong-lo ki bong ono manauanga ‘Sabat’-o ipura. ");
INSERT INTO mva_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bong ngaradia-lo masa sururu dalaba-tina be kana moarunga masa dakauborua-ramo. Toira kateka emaka ipura be imai nge kana tago teke bokai ipura. Be alauri masa kana bokainaina tago teke ngapura! ");
INSERT INTO mva_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ata Nanaranga ambe kana ngae iaka-tukurai. Tago ngaka-tukurai bokana nge ambe tamoata tago teke ne iauia ngasoaki. Ata nge Nanaranga tamoata be aine ne kanabe kana goalaka ngae iaka-tukurai. ");
INSERT INTO mva_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Bong ngaradia-lo be tamoata teke bokai ira-kaming, ‘Kamate! Kristus makare isoaki,’ ki bokai ipile, ‘Kamate, ene isoaki,’ nge moaki kalongori. ");
INSERT INTO mva_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tamoata alu masa dapura be daboli be dapile di ka Kristus. Alu masa daboli be dapile di nge ‘propet’ kaoa. Be kilala kaiboangdi masa daemaki be ono tamoata dabolesidi. Be iboadu-tina Nanaranga tamoata ne be aine ne inangadi be disoaki nge dabolesidi. Nge maka ma diboadu-re! Ata tago diboadu. ");
INSERT INTO mva_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kamalongo! Kana ngaedi nge isi tagona-la dipura be urakaming-ba mua. ");
INSERT INTO mva_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Bokaibe tamoata teke itaguraki be bokai iraka-ming, ‘Lulu kaba-lo isoaki,’ nge moaki kalako. Ki bokai ira-kaming, ‘Ene pera ilona-lo ikoma be isoaki,’ nge moaki kalongo. ");
INSERT INTO mva_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bokai kamakaua: Lamalama ipitikaoakaoa nge ege amari rakeanao be ilakolako ege amari balaianao be lang ere-moarunga nge imalamalama-doi. Be bokainatuka-la, Tamoata Natu puranga masa lamalama-la bokana. ");
INSERT INTO mva_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tamoata mate ieno kana masa mang aradi kalo dapura be dakabuni. ");
INSERT INTO mva_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kana goalakadi ngaedi muridi masa oaikiki-tina ‘amari mata daleua, kalea masa tago ngamalamalama, goai masa lang-lo ka dasapasi, be kaiboang moarunga makatabala lang-lo dieno nge damoakusu-ramo be tago nedi zalakadi datagatagadi.’ (Ais 13:10; 34:4) ");
INSERT INTO mva_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Kodeka masa Tamoata Natu kilala ne lang-lo ngapura be tamoata be aine moarunga kateka-o disoaki nge datang. Be Tamoata Natu masa oaru lang anua-lonalona nenao ngasoaki be kaiboang be malama ne zaiza be ngabalabala be date. ");
INSERT INTO mva_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kodeka tauru teke masa ngakaba be ‘enzel’ ne ege-ege kateka-o nganepidialako. Be masa kateka ege takanao be dalako ege takaianao be tamoata be aine ne irangakidi be disoaki nge dabagadi. ");
INSERT INTO mva_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Sule uia nge kai ara ‘pig’-o kamadoki. Dikadodo be dimoga be daudi dipura nge ambe kamakaua kana amari bong ka dapura kana. ");
INSERT INTO mva_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Bokainatuka-la kai ngae bokana, kana urangaki ngaedi kaita nge ambe kamakaua kana bong ngae ambe isaringa be babaduadua kanaming-lo ieno. ");
INSERT INTO mva_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Moimoi ka ura-kaming! Zugu kaituka maka disoaki ngaedi nge tagona-la damate be masa kana ngaedi dapura. ");
INSERT INTO mva_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Lang be kateka masa daleua, ata pilengagu tagona-tina iboadu daleua. ");
INSERT INTO mva_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tamoata tago teke bong ngae ki amari siriki ne ngae ikauataki. ‘Enzel’ lang anua-lo tago dikaua. Natu tago ikaua. Tamagu-la rube ka ikaua. ");
INSERT INTO mva_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tamoata Natu puranga masa toira-la Noa bong nena-lo be kana emakadi dipura bokana emakadi dapura. ");
INSERT INTO mva_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bong ura be urua bibia arodi nge tamoata dimoanakonako be dang disingsing be dirotiroti be nedia-la dienegenegei be dirotiroti nibe ilako bong ono Noa kati-o ibuli. ");
INSERT INTO mva_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ata tamoata be aine moarunga tago dikaua rakana ka ipurapura nibe urua-ba dipura be diara-leuadi. Be bokainatuka-la, Tamoata Natu puranga masa bokainatuka. ");
INSERT INTO mva_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Bong ngara-dio masa tamoata rua uma-lo damalipilipiru. Takaia masa bagaia ngapura be taka masa pereka ngapura. ");
INSERT INTO mva_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Aine rua masa kangkang darasirasiru. Takaia masa bagaia ngapura be taka masa pereka ngapura. ");
INSERT INTO mva_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaba kamaitaita uia! Tago kakaua bong nangatanao masa Tanepoa neming ngapura. ");
INSERT INTO mva_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ilo-ming kauakaua! Pera-marau ngakaua oabubu lukanga nangatanao anako ngapura kana nge ambe mata poapoara ngasoaki be anako tago iboadu pera kana ngasereki. ");
INSERT INTO mva_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Bokaibe kamakatiuana be kamasoaki. Tamoata Natu puranga tago kakauataki. Ilo-ming dapilepile bong takaianao ka ngapura kana, ata kaituka baraoa ngapura. ");
INSERT INTO mva_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Malipilipi nangata ka kauakaua be malipi ne iememaki? Biabiadi ne irai be malipilipi takadi itetedi be daga-tinao nge kangkang kandi ianiandi. ");
INSERT INTO mva_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Alauri biabiadi ne ngamule be ngate malipi ne iememaki masa malipilipi ngae suri dauia-tina. ");
INSERT INTO mva_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Moimoi ka ura-kaming! Biabiadi ne masa ngataguraki be kana ne moarunga malipilipi ngae ngani be ngaitaita be ngadoadorakini. ");
INSERT INTO mva_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ata malipilipi goalaka bokana nge ambe bokai ngapile, ‘Biabiadi negu uananaka disalaga-tina! Masa tago ngamule-marakai kana!’ ");
INSERT INTO mva_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bokaibe ngataguraki be malipilipi ruanga ngaunundi be tamoata muzingadi goalakadi zaiza damoanakonako be ‘uain’ dasingsing be daboangboang. ");
INSERT INTO mva_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bokai ngamuzimuzi masa biabiadi ne mulenga tago ngakauataki. Ilo ngapileni bong takaianao ka ngapura kana be puranga tago irapung. ");
INSERT INTO mva_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kodeka biabiadi ne masa ngataguraki be tamoata ngae ngataratotoki be mukumuku ngapura. Be masa tamoata bolingadi ratadi zaiza kaba tekedia-lo nganangadia-budu, be sururu bibia-tina ngadoki. Makara masa ngatangtang be ile ngakaraposaposa.” ");
INSERT INTO mva_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Bong ngaranao nge masa bong ono Nanaranga ngatanepoa kana nge bokainatuka: Aine barasi kulemoa isi moane zaiza tago sesu dieno-budu nge ‘lam’ nedi didoki be dialale be moane teke kodeka-ka iroti dazaladoki kana. ");
INSERT INTO mva_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima kauakauadi, be lima takadi nge ngaongaodi bokana. ");
INSERT INTO mva_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ngaongaodi bokana nge ‘lam’-la nedi didoki be dialale. ‘Karasing’ tago sesu didokidoki. ");
INSERT INTO mva_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kauakauadi nge ‘lam’ nedi be ‘karasing’ nedi sema-lo be didoki be dialale. ");
INSERT INTO mva_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Rotiroti ngae nge uananaka disalaga. Bokaibe aine kulemoa ngaedi nge ditungtung be ambe dienosoa. ");
INSERT INTO mva_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Oabubu lukangana-tinao nge malonga teke bokai ikilau, ‘Rotiroti ambe maka imaimai! Kamamai be kamate.’ ");
INSERT INTO mva_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Aine barasi kulemoa ngaedi nge ambe ‘lam’ nedia-lo ‘karasing’ dimanubu be dadoraki be dakarataki kana. ");
INSERT INTO mva_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kodeka aine lima ngaongaodi nge ditaguraki be kauakauadi bokai diradi, ‘Karasing’ neming muku kamang-kama. ‘Lam’ nema ambe dimatemate. ");
INSERT INTO mva_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Be aine kauakaua dikatu be bokai dipile, ‘Tago iboadu! ‘Karasing’ ngaedi nge tago diboadung-kita. Kamalale be neming kamazaza.’ ");
INSERT INTO mva_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ata bong aine ngaongaodi lima dialale be ‘karasing’ dazazai kana nge muridi rotiroti ngae ipura. Aine barasi lima disoaki be dirapurapu nge roti-roti zaiza be moanako ngaena-lo disili-budu. Be babaduadua dionoti. ");
INSERT INTO mva_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Alauri nge aine lima ngaongaodi nge dimule. Be dikilau be bokai dipile, ‘Biabiadi! Biabiadi! Babaduadua gokakata-kama!’ ");
INSERT INTO mva_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ata tamoata ngae ikatu be bokai ipile, ‘Moimoi ka ura-kaming! Tagona-tina ukauataki-kaming!’” ");
INSERT INTO mva_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kodeka Iesus pile ngaedi bokainatuka imambuaki, “Kamasoaki be kaba kamaitaita-tina uia! Bong nangata ki amari siriki nangata tago kakauataki!” ");
INSERT INTO mva_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Bong ngaradia-lo masa bong ono Nanaranga ngatanepoa kana nge bokainatuka: Tamoata biabia teke anua ne ipereki be kasau ngalako kana. Ngalale kana nge malipilipi kana ikiladi be kana ne moarunga luma-dio inanga. ");
INSERT INTO mva_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Malipingadi ita kodeka ‘mone’ iandi. Teke ‘mone tausen’ lima bokana iani. Teke ‘mone tausen’ rua bokana iani. Be teke ‘mone tausen’ teke bokana iani. Iandia-doi kodeka ialale. ");
INSERT INTO mva_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kodeka tamoata ‘mone tausen’ lima idoki nge oaikiki-tina ilako be odio imalipi be ‘mone tausen’ lima takadi ipuraki. ");
INSERT INTO mva_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be tamoata ‘mone tausen’ rua idoki nge bokai imuzi be ‘mone tausen’ rua takadi ipuraki. ");
INSERT INTO mva_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ata tamoata ‘mone tausen’ teke idoki nge ilako be gimoa teke ikeli be biabiadi ne ‘mone’ ne izumkaki. ");
INSERT INTO mva_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Uanana disalaga-tina kodeka tamoata biabia ngae imule be malipilipi kana zaiza ‘mone’ iandi nge diadoraki. ");
INSERT INTO mva_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tamoata ‘mone tausen’ lima idoki nge ‘mone tausen’ lima takadi ipuraki zaiza be ieluaki be bokai ipile, ‘Biabiadi, kaiko ‘mone tausen’ lima ka kuiana. Goita! Ata ngau kaba ‘mone tausen’ lima takadi upuraki!’ ");
INSERT INTO mva_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Be biabiadi ne ikatu be bokai irai, ‘Kaiko muzi iauia-tina ka kuemaki. Kaiko malipilipi iauia! Be kumalipi-tina uia! Malipi mukumukudi emakadi be adorakadi kuamang. Bokaibe mnangaiko be malipi bibia gopapananuaki kana. Gomai be suri-uia negu-lo tasoaki-buduru!’ ");
INSERT INTO mva_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Kodeka tamoata ‘mone tausen’ rua idoki nge imai be bokai ipile, ‘Biabiadi, kaiko ‘mone tausen’ rua ka kuiana. Goita! Ata ngau kaba ‘mone tausen’ rua takadi upuraki!’ ");
INSERT INTO mva_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Be biabiadi ne ikatu be bokai irai, ‘Kaiko muzi iauia-tina ka kuemaki! Kaiko malipilipi iauia! Kumalipi-tina uia! Malipi mukumukudi emakadi be adorakadi kuamang. Bokaibe mnangaiko be malipi bibia gopapananuaki kana. Gomai be suri-uia negu-lo tasoaki-buduru!’ ");
INSERT INTO mva_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Kodeka tamoata ‘mone tausen’ teke idoki nge imai be bokai ipile, ‘Biabiadi, ngau ukaua kaiko panganam patu bokana. Kangkang tamoata takadi ditanotano nge kanam bokana kuaroeroe. Be kangkang tamoata takadi dilikiliki nge kanam bokana kubagabaga. ");
INSERT INTO mva_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Bokaibe umatakuriko be ulako be ‘mone’ nem kateka-lo uzumkaki. Naka! ‘Mone’ nem maka! Godoki!’ ");
INSERT INTO mva_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Be biabiadi ne ikatu be bokai irai, ‘Kaiko malipilipi goalakam! Sukoakim-ba kata! Kaiko moimoi kukauataka kangkang tago utanotano nge uaroeroe, be kangkang tago ulikiliki nge ubagabaga? ");
INSERT INTO mva_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bakara ka ‘mone’ negu tago ‘beng’-lo kunanga? ‘Beng’-lo gonanga bokana nge ambe mulengaguo be ulikadi mdoki! ");
INSERT INTO mva_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Kodeka tamoata bibia ngae bokai ipile, ‘Tamoata ngaena-lo ‘mone tausen’ teke nge kamadoki be tamoata ‘mone tausen’ kulemoa ieluaki nge kamani. ");
INSERT INTO mva_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tamoata kana dienoni masa kokoko-la be ania ngapura be dakoko-tinani, be bagabaga darai. Ata tamoata kana ne tagotago, be kana nena-ra toli-la masa dokiadia-le dapura. ");
INSERT INTO mva_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Malipilipi goalaka ngae kamadoki be eluku malama tagongana-lo kamarokakalako. Makara masa ngatangtang be ile ngakaraposaposa. ");
INSERT INTO mva_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Alauri masa Tamoata Natu anuatanepoa bokana be ‘enzel’ zaiza be ngapura. Masa bagi ono tanepoanga ne kaiboang be malamaka otioti lang anua-lo be ibagabagai nge ono ngasoaki be ngapura. ");
INSERT INTO mva_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Be ungguma moarunga kateka-o masa dapura be aro dakabuni. Kodeka Tamoata Natu masa ngataguraki be ngaizarakidi, tamoata ngado akolakola ‘sipisipi’ be ‘meme’ izaizarakidi bokana. ");
INSERT INTO mva_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","‘Sipisipi’ masa ngadokidi be oana-nao nganangadi, be ‘meme’ masa ngasina-o nganangadi. ");
INSERT INTO mva_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Kodeka Anuatanepoa masa ngataguraki be tamoata be aine oana-nao disoaki bokai ngaradi, ‘Kam Tamagu marou ne omingo dieno! Kamamai be lang anua toira kateka emakana-la ipura be Tamagu iadoraki be ieno nge kamadoki be kamanemi. ");
INSERT INTO mva_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bakara, tole umate be kangkang kana. Madole umate be dang kana. Akerenga-gu kata, ata pera kanaming-lo kabagaiaulako. ");
INSERT INTO mva_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nemoala-ba usoaki be kusi kana be uokori. Umore be katarurutaka nibe uia. Uaura-lo usoaki be kapura be katea.’ ");
INSERT INTO mva_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Be tamoata be aine uia ngaedi masa bokai dapile, ‘Tanepoa! Aira-tina tole kumate be kangkang kiangko, ki madole kumate be dang kiangko? ");
INSERT INTO mva_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aira-tina ka akerengam bokana kiteko be pera kanamai-lo kibagaikolako, ki nemoala-ba kusoaki be kusi kiangko be kuokori? ");
INSERT INTO mva_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aira-tina ka kumore ki uaura-lo kusoaki be kipura be kiteko?’ ");
INSERT INTO mva_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Be Anuatanepoa ngae masa ngakatu be bokai ngapile, ‘Moimoi ka ura-kaming! Rakana muku teke taritokagu ngaedi aradi tagotago-tina kaemakadi nge ngau ka kaemakana!’ ");
INSERT INTO mva_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Kodeka ngasina-o disoaki masa bokai ngaradi, ‘Kamairatu! Kam Nanaranga ngesuaki ne omingo dieno! Eoa tago matemate Satang ‘enzel’ ne zaiza emakadiadi ipura-lo kamalako! ");
INSERT INTO mva_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tole umate be kangkang tago kana. Madole umate be dang tago kana. ");
INSERT INTO mva_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Akerenga-gu, ata pera kanaming-lo tago kabagaiaulako. Nemoala-ba usoaki, ata kusi tago kana be uokori. Umore, ata tago katea be kadoraka. Uaura-lo usoaki, ata tago kapura be katea.’ ");
INSERT INTO mva_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Be di masa dakatu be bokai darai, ‘Tanepoa! Bong nangatanao ka tole kumate, madole kumate, nemoala-ba kusoaki, akerengam bokana kusoaki, kumore ki uaura-lo kusoaki be tago kidumaiko?’ ");
INSERT INTO mva_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Be Anuatanepoa ngae masa bokai ngaradi, ‘Moimoi ka ura-kaming! Tamoata ngaedi aradi tagotago-tina dumadi kasege nge ngau ka dumaia-gu kasege.’ ");
INSERT INTO mva_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Be goalakadi ngaedi masa sururu nem-kueno dieneno-lo dalako. Tamoata uia adoadodi masa soaki-uia date be nem-kusoaki dasukoaki.” ");
INSERT INTO mva_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesus pile ngaedi ipile-doi kodeka tagataga ne bokai iradi, ");
INSERT INTO mva_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kam kakaua-doi. Amaridi rua muridi be masa moanako biabia ara ‘Pasoba’ rakeaka ngapura. Be Tamoata Natu masa erekei luma-dio danangai be kai kapalapala uauau-o darokatagaki.” ");
INSERT INTO mva_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kaiapas nge tamoata Nanaranga ditabatabai biabiatuka nedi. Bokaibe tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia nge Kaiapas pera kana-nalo dipura be dikabuni be disoaki. ");
INSERT INTO mva_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Makara be diraba be zugumaba-lo be Iesus dauauri be daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bokaibe bokai dipile, “Kana ngae moaki ‘Pasoba’ bong-lo be taemaki. Taemaki masa tamoata dataguraki be eung teke damarangaki takana.” ");
INSERT INTO mva_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesus nge tamoata kikiri dokia ara Saimon pera kanana-lo isoaki Betani anua-lo. ");
INSERT INTO mva_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Makara isoakiria be imoanakonako nge aine teke bureng zazaia atabalabala-tina bulo teke uarikana-lo idoki be ipura be Iesus pangana-nao isuburakaria. ");
INSERT INTO mva_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iesus tagataga ne kaba bokai dita nge ilodi dira-tina be bokai dipile, “Bakara ka bureng ngae bizagamana-ba ipura? ");
INSERT INTO mva_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bureng ngae nge iboadu ono ‘mone’ biabia-tina dokia ngapura be tamoata kana nedi tagotago tandi!” ");
INSERT INTO mva_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesus pile ngaedi ilodia-lo italako nge bokai ipile, “Bakara ka aine ngae kailo-bukui? Nge muzi kulanglang-tina ka iemakana! ");
INSERT INTO mva_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tamoata kana nedi tagotago masa izamazama sakeming-o dasukoaki. Ata ngau masa tago sakeming-lanao msukoaki. ");
INSERT INTO mva_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Bokaibe aine ngae bureng oguo isuburakaria nge ono ikalukanaka be kumrakagu ngapura kana. ");
INSERT INTO mva_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Moimoi ka ura-kaming. Kaba nangatadia-lo, ege-ege kateka-o Pile Uia ngae disulesuletaki masa aine ngae kana ngae iemakana masa darangarangaki. Be masa aine ngae ilodi daniani be darangarangaki.” ");
INSERT INTO mva_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kodeka Iesus tagataga ne kulemoa-be-rua teke ara Iudas Iskariot nge tamoata Nanaranga ditabatabai dimuamuadia-lo ilako ");
INSERT INTO mva_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","be bokai itegidi, “Iesus luma-mingo mnangai masa rakana kamana?” Kodeka ditaguraki be ‘mone siliua’ kulemoadi-toli diuare be diani. ");
INSERT INTO mva_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daga ngaranao be ilako nge Iudas zala ilelelei be bong nangata iauia-o be ngataguraki be Iesus ngadoki be erekei luma-dio nganangai kana. ");
INSERT INTO mva_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Moanako biabia ono ‘Bereti’ Bababa kania ipurapura imai nge Iesus tagataga ne dipura be bokai ditegi, “Inangaio kana gadorakiniko be ‘Pasoba’ gokani kana kurere?” ");
INSERT INTO mva_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Be Iesus ikatu be ipile, “Ierusalem kamalako be tamoata katana-lo kamalako be bokai kamarai, ‘Tisa’ bokai ipile: Bong negu nangadi dipura ambe disaringa. Tagataga negu zaiza pera kanam-lo ‘Pasoba’ gakani kana.’” ");
INSERT INTO mva_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kodeka tagataga ne dialale be Iesus kana irangaki nge diemaki, be dilako be kana ono ‘Pasoba’ dakani kana nge dimoataungaki. ");
INSERT INTO mva_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rairaituka nge Iesus tagataga ne kulemoa-be-rua zaiza disoakiria be damoanako kana. ");
INSERT INTO mva_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Dimoanakonako nge Iesus bokai iradi, “Moimoi ka ura-kaming. Tekem masa erekei luma-dio gonangaia.” ");
INSERT INTO mva_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Makara nge tagataga ne ilodi dibuku be teke-teke bokai ditegi, “Tanepoa, ngau ka kurangarangaka ki?” ");
INSERT INTO mva_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Be Iesus ikatu be ipile, “Tamoata naita tabira-baba-lo luma-mairu kinanga-budu-lakoru masa ngadoka be erekei luma-dio nganangaia. ");
INSERT INTO mva_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tamoata Natu masa Nanaranga-la ‘Buku’ ne irangaki bokana be ngamate. Ata tamoata naita itaguraki be Tamoata Natu erekei luma-dio inangai nge imakadoma-tina! Bakarai-tina ma ka tina inekiaki!” ");
INSERT INTO mva_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kodeka Iudas, maka Iesus erekei luma-dio inangai nge itaguraki be bokai ipile, “‘Tisa,’ ngau ka kurangarangaka ki?” Be Iesus ikatu be bokai irai, “Kupile-la bokana.” ");
INSERT INTO mva_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Dimoanakonako nge Iesus ‘bereti’ teke idoki be Nanaranga iperui be ikotoi be tagataga ne iandi be bokai ipile, “Kamadoki be kamakani. Ngae nge ngau tamoata-gu.” ");
INSERT INTO mva_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kodeka ‘uain’ sema tekena-lo idoki be Nanaranga iperui be iandi be bokai ipile, “Kamadoki be kam moarunga kamasing. ");
INSERT INTO mva_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ngae nge ngau darakagu. Be nge darakagu ngae oti ka Nanaranga taoa ne oauoau tamoata be aine ne zaiza iemakadi. Darakagu usuburaki be ono Nanaranga itaguraki be tamoata kokoko-tina oti nedi irokakiledi. ");
INSERT INTO mva_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Moimoi ka ura-kaming. Tago iboadu ‘uain’ kababe msing nibe ngalako bong ono Tama-gu ngatanepoa kanana-lo ‘uain’ oauoau tasing-budu.” ");
INSERT INTO mva_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kodeka rang teke didoki be Olib buku-nao dilako. ");
INSERT INTO mva_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Makara nge Iesus itaguraki be tagataga ne bokai iradi, “Oabubu ngaena-lo masa kamairatuia be kamapereka. Maka ma Nanaranga ‘Buku’ nena-lo bokai dieno, ‘Sipisipi’ akolakola masa mumoatei be ‘sipisipi’ ulunga dairatu-ramo. (Zek 13:7) ");
INSERT INTO mva_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Ata alauri mate-lo be marang masa aro-ming mua be Galili mlako.” ");
INSERT INTO mva_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Kodeka Pita itaguraki be bokai ipile, “Moarunga masa dairatu! Ngau tagona-tina iboadu mperekiko!” ");
INSERT INTO mva_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Be Iesus ikatu be bokai irai, “Moimoi ka uraiko! Kaituka oabubu ngaena-lo masa mang tagona-la ngakatararaua be bong toli gopile tago kukauataka.” ");
INSERT INTO mva_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ata Pita bokai ipile, “Iboadu msoaki-la be tamate-buduru, ata tagona-tina iboadu mpile tago ukauatakiko!” Be tagataga ne moarunga nge bokaina-doi dipile. ");
INSERT INTO mva_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kodeka Iesus tagataga ne zaiza be kaba aradi Getsemani-lo dilako. Makara nge bokai iradi, “Maka kamasoaki be ene mlako be mrabo.” ");
INSERT INTO mva_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kodeka Pita be Zebidi natu ruoti Zems be Zon nge idokidiato be dialaleto. Makara nge ilo isururu-tina be ilo nge inodo-tina. ");
INSERT INTO mva_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Be bokai ira-diato, “Mariabaka-gu isururu-tina be mate bokana kana. Maka kamasoakito be kaba taitaita-budu.” ");
INSERT INTO mva_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kodeka Iesus mukuna-la iperekidiato be lili kateka-lo inangalako be bokai ipile, “Mamo! Iboadu nge sema ngae ono sururu mdoki kana nge godokalea! Ata moaki rerengagu kutagadi. Rerengam gotagadi.” ");
INSERT INTO mva_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Irabo-doi be tagataga nena-lo imulelako nge dienosoato be itediato. Kodeka itaguraki be Pita bokai irai, “Baituka ka tago kaboadu mukunaba tasoaki-salaga-budu? ");
INSERT INTO mva_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kamasoaki be Nanaranga kamaraboraboi. Toitoi teke ngapura be ngatoi-kaming be kamatapulo takana. Mariaba-ra isumoala, ata tamoata kusi imangongo-tina.” ");
INSERT INTO mva_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ipile-doi nge kababe ialale be bokai irabo, “Mamo! Sema ngae tago iboadu godokalea kana, be ambe mdoki be ono dang msing kana. Bokai masa rerengam mambuakadi dapura.” ");
INSERT INTO mva_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Irabo-doi be imule nge tagataga ne dienosoato be itediato. Mata-diato nge dimoarore-tina be tago iboadu poapoara-la daeno. ");
INSERT INTO mva_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kodeka kaba ialale be bong tolia enumua-la irabo bokana irabo. ");
INSERT INTO mva_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Irabo-doi nge tagataga nena-lo imule be bokai ira-diato, “Isi kamanaua be kaeno ki? Kaba kamaita! Bong ono Tamoata Natu tamoata muzigoala ememaki luma-dio danangai kana ambe ipura! ");
INSERT INTO mva_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kamatui be talale! Kamate! Tamoata erekei luma-dio nganangaia kana ambe ipura.” ");
INSERT INTO mva_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesus isi ipilepile-la be Iudas ipura. Iudas nge Iesus tagataga ne kulemoa-be-rua teke kata. Tamoata kokoko-tina asi ono eunga be meng didoki be Iudas zaiza be dipura. Tamoata ngaedi nge tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia ka dinepidi be dipura. ");
INSERT INTO mva_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Matamata be Iudas itaguraki be tamoata ditagai nge bokai iradi, “Ulako be tamoata uaroki nge ngai. Kamauauri!” ");
INSERT INTO mva_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Bokaibe Iudas ipura nge adoado-la ilako Iesus-lo be bokai ipile, “‘Tisa,’ ilo-uia kaiko-lo ngaeno.” Kodeka iaroki. ");
INSERT INTO mva_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Makara nge Iesus bokai ipile, “Ruanga, kana goemaki kana be kupura nge oaikiki-tina goemaki.” Kodeka tamoata Iudas zaiza dipura nge dilako be Iesus didokimatei be diuauri. ");
INSERT INTO mva_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Makara nge tamoata teke Iesus diaru disoakiru nge itaguraki be asi ne ono eunga ipasiki be Kaiapas dududu kana izampoaki. Ata itarapakai be kungi itaratotoki. ");
INSERT INTO mva_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ata Iesus itaguraki be tamoata ngae bokai irai, “Asi nem godoki be kabana-lo gonangalako. Tamoata moarunga asi ane dieunung masa asi ane be damate. ");
INSERT INTO mva_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tago kakaua ngau uboadu Tama-gu duma kana mkilai be ‘enzel’ ne kokoko-tina koai-bagi kulemoa-be-rua be atabala bokana nganepidi be dadumaia? ");
INSERT INTO mva_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bokai umuzi masa baituka be Nanaranga pilenga dakalingo? Nanaranga ‘Buku’ nena-lo nge kana bokainatuka-la ka dapura kana nge dieno.” ");
INSERT INTO mva_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kodeka Iesus itaguraki be tamoata dipura nge bokai iradi, “Ngau anako kata ka asi ono eunga be meng kadoki be kapura be kamauaura kana? Izamaizama Nanaranga pera nena-lo usukoaki be usulesule nge tago kauaura. ");
INSERT INTO mva_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ata kana ngaedi bokai dipura be ono ‘propet’ pilengadi dikalingo, Nanaranga-la ‘Buku’ nena-lo dieno bokana.” Makara nge Iesus tagataga ne diratu be dipereki. ");
INSERT INTO mva_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tamoata dipura be Iesus diuauri nge ditaguraki be Iesus dibagai be Kaiapas pera kanana-lo dilakuaki. Kaiapas nge tamoata Nanaranga ditabatabai biabiatuka nedi. Tamoata Moses Mata ne disulesuletaki be Iuda tamoata nedi bibia nge makarana-doi Kaiapas pera kanana-lo dikabuni be disoaki. ");
INSERT INTO mva_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita nge muridiaba laua-o be Iesus itagatagai. Itagai nibe ilako be Kaiapas pera kana ari-dialo. Tamoata Kaiapas pera kana dinarinaringi nge makara disoaki be ilako be disoaki-budu be ono ngakaua kana masa rakana ngapura. ");
INSERT INTO mva_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia ‘Kansolo’ nedia-lo disoaki moarunga nge tamoata aludi dileledi be boli-pile Iesus ono danangalako be daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ata boli-pile tago tekedi dita be ono dinangalako. Tamoata-ra kokoko mata-ita bokana diboli be dipura, ata giriki labu tago teke diteani. Kodeka, alauri nge tamoata rua dipuraru ");
INSERT INTO mva_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","be bokai dipileru, “Tamoata ngae bokai ipile, ‘Ngau uboadu Nanaranga pera ne mgamani be amaridi toli ilodia-lo be kababe mnaguraki.’” ");
INSERT INTO mva_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kodeka Kaiapas ituirake be Iesus bokai irai, “Pile nem ono nem-la goiakiko kana tekedi dieno ki tago? Pile ngaedi omo dinangalako nge bakarairai kaoa?” ");
INSERT INTO mva_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ata Iesus imoadubulae-ba. Kodeka Kaiapas bokai ipile, “Nanaranga moauriuri-la isukoaki ara-nao be pile tago tototo ngaedi goemaki! Kaiko moimoi be Kristus, Nanaranga Natu?” ");
INSERT INTO mva_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Be Iesus ikatu be bokai ipile, “E. Kupile-doi! Ata ngau kam moarunga bokai ura-kaming! Alauri masa Tamoata Natu Nanaranga Kaiboangina-tina oana-nao ngasoaki be oaru lang anua-lonalonao be ngabalabala be kamate.” ");
INSERT INTO mva_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kodeka Kaiapas itaguraki be kusi ne inangananga nge idokisare be bokai ipile, “Nanaranga ono imanai! Tamoata pile ono danangalako kana nge takadi moaki takeliakidi! Kaituka-tina ka pilenga ono Nanaranga imanai nge kalongo! ");
INSERT INTO mva_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bakara ilo-ming dipile?” Be di dikatu be dipile, “Giriki ipuraki. Bokaibe ngamate.” ");
INSERT INTO mva_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kodeka ditaguraki be lili dimoangorini be dizamposani. Tamoata dizamposani ");
INSERT INTO mva_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nge bokai dirai, “Kristus, pile mumuakadi gopile. Naita ka iungko?” ");
INSERT INTO mva_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita eluku isoaki nge aine Kaiapas dimalipilipini teke ipura be bokai irai, “Kaiko be. Galili tamoata Iesus zaiza kasukoaki-budu!” ");
INSERT INTO mva_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ata tamoata moarunga makara disoaki matadi-o be Pita iaoli be bokai ipile, “Tagona-tina ukaua rakana ka kurangarangaki!” ");
INSERT INTO mva_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bokai ipile be Kaiapas pera kana aridi ipereki be eluku ilako. Aine takaia Kaiapas imalipilipini Pita ite nge tamoata makara disoaki bokai iradi, “Tamoata ngara nge Nasaret tamoata ara Iesus diaru disukoaki-buduru.” ");
INSERT INTO mva_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Makara nge Pita kababe Iesus iaolitaki be pile tago tototo ane be bokai ipile, “Moimoina-tina tago ukauataki!” ");
INSERT INTO mva_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mukuna-la makara isoaki be tamoata alu dimai be bokai dirai, “Moimoina-tina kaiko di kata. Memem moatubunga ambe mangata inangaiko.” ");
INSERT INTO mva_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kodeka Pita pile tago tototo-tina iemaki be nena-la ingesuaki be bokai ipile, “Tamoata ngae ukauataki nge Nanaranga iboadu ngaumoatea! Tamoata ngae tagona-tina ukauataki!” Pile ngaedi be idokitoto nge mang ikatararaua. ");
INSERT INTO mva_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Makara nge Pita Iesus pilenga ilo iandi, “Mang tagona-la ngakatararaua be masa bong toli gopile tago kukauataka!” Makara nge Pita eluku ilako be tang biabia-tina iemaki. ");
INSERT INTO mva_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Izama nge oabuna-tina be tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia pile dipali be Iesus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kodeka ditaguraki be oarige kaiboangdi ane diuauri be Pailot-lo dilakuaki. Pailot nge ungguma aradi Rom biabiadi nedi teke be ngai ka kaba ngaradi ipapananuaki. ");
INSERT INTO mva_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Makara nge tamoata maka Iesus erekei luma-dio inangai ara Iudas kaba bokai ita ambe pile dipali be Iesus daumoatei kana nge nena-la ingongoi be muzinga ngaedi ilo iandi be inodo-tina. Kodeka ‘mone siliua’ kulemoadi-toli diani nge idoki be ialale be tamoata Nanaranga ditabatabai dimuamuadi be Iuda bibia nedi nge iandi. ");
INSERT INTO mva_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Be bokai iradi, “Ngau muzigoala uemaki. Tamoata giriki ne tagotago erekei luma-dio unangai be ngamate kana.” Ata di dikatu be bokai dipile, “Kana ngara keka tagona-tina iloma dibukutaki! Ngara nge kaiko-la ka malipi nem!” ");
INSERT INTO mva_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kodeka Iudas itaguraki be ‘mone’ ngaedi Nanaranga pera nena-lo irokakilako be ialale be nena-la itapai. ");
INSERT INTO mva_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Alauri nge tamoata Nanaranga ditabatabai dimuamuadi ‘mone’ ngaedi didoki be bokai dipile, “‘Mone’ ngaedi dara odio dieno. Bokaibe tago iboadu Nanaranga pera nena-lo daeno!” ");
INSERT INTO mva_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kodeka diepilei be ‘mone’ ngaedi didoki be tamoata boadi be agora iememaki kateka ne ono dizazai. Di direre kateka ngae nge tamoata akerengadi ono dakumkumrakidi. ");
INSERT INTO mva_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bokaibe kateka ngara nge ‘Dara Uma’ kana dirangarangaki nibe kaituka-ba. ");
INSERT INTO mva_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kana ngaedi bokai dipura be ‘Propet’ ara Zeremaia nge pilenga dikalingo. Zeremaia bokai ipile, “‘Siliua mone’ kulemoadi-toli didoki. ‘Mone’ ngaedi ka Israel dirangaki be tamoata ngae ono dizazai. ");
INSERT INTO mva_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Alauri nge ‘mone’ ngaedi didoki be tamoata boadi be agora iememaki kateka ne ono dizazai, Tanepoa-la ipile bokana.” ");
INSERT INTO mva_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kodeka Iesus dieluaki be Pailot aro dituiraki. Be Pailot itaguraki be bokai itegi, “Kaiko Iuda anuatanepoa kandi ki?” Be Iesus ikatu be ipile, “Kupile-la bokana.” ");
INSERT INTO mva_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kodeka tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia nge ditaguraki be pile moarunga Iesus ono dinangalako. Ata Iesus tago sesu pile ikatu. ");
INSERT INTO mva_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Alauri nge Pailot bokai itegi, “Pile ngaedi omo dinanganangalako nge kulongolongo ki tago?” ");
INSERT INTO mva_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ata Iesus tago sesu ipile. Iesus imoadubulae-ba nge Pailot ipitilaki-tina be tago sesu ba ipile. ");
INSERT INTO mva_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Barasi moarunga ‘Pasoba’ bong-lo nge Pailot bokai imuzimuzi: Tamoata be aine moarunga dapura be rerengadia-lo tamoata uaura-lo disoaki nge teke darangaki be ngarubetaki. ");
INSERT INTO mva_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Bong ngaradia-lo nge tamoata teke goalakana-tina ara Barabas nge uaura-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Bokaibe bong tamoata be aine dipura nge Pailot bokai itegidi, “Naita mrubetaki kana karere? Barabas ki Iesus maka Kristus kana rangaka ipurapura?” ");
INSERT INTO mva_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot ikaua Iuda tamoata nedi dimuamuadi nge Iesus dinama-rataki ka ngaia-lo dieluaki. ");
INSERT INTO mva_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailot nge bagi ne ono giriki adoraka-o isoaki be roa pile bokai inangamaini, “Tamoata ngara giriki ne tago. Moakina-tina sesu bakara kubasaki. Rodo rai-o ute be ilogu ibuku-ramo-tina.” ");
INSERT INTO mva_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ata tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia nge tamoata be aine ilodia-lo disili be diradi be bokai dapile kana, “Barabas rubetaka ngapura be Iesus umoatea ngapura.” ");
INSERT INTO mva_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kodeka Pailot bokai itegi, “Naita mrubetaki be miang-kaming kana karere?” Be di dikatu be dipile, “Barabas!” ");
INSERT INTO mva_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Be Pailot kababe itegidi, “Iesus maka Kristus kana rangaka ipurapura bakara mbasaki?” Be di dikatu be dipile, “Kai kapalapala uauau-o rokatagaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ata Pailot bokai itegidi, “Giriki nangata iemaki?” Kodeka dipi-tina be bokai dipile, “Kai kapalapala uauau-o rokatagaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailot nge ambe kilalanga inanga tamoata be aine ambe dikai-tina be ngai tago iboadu ngabalakidi. Be saringatuka ambe eung teke ngamarang kana bokana. Bokaibe dang idoki be matadi-o be luma iasaki be bokai ipile, “Tamoata ngae imate nge malipi neming. Ngau tago. Giriki ngae nge kam-la ka neming!” ");
INSERT INTO mva_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kodeka tamoata be aine bokai dipile, “Daraka masa keka be natu-maio dalako.” ");
INSERT INTO mva_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Makara nge Pailot itaguraki be Barabas irubetaki be iandi. Kodeka iradi be Iesus dirautotoki be iandi be kai kapalapala uauau-o darokatagaki kana. ");
INSERT INTO mva_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dipalitia-doi kodeka Pailot koai-bagi tamoata ne pera kana dinarinaringi nge Iesus dibagalako Pailot pera kana ilona-lo. Be koai-bagi ne ngaena-lo nge tamoata ne moarunga dipura-doi be Iesus diboalingi. ");
INSERT INTO mva_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kodeka ditaguraki be kusi ne inangananga nge dipasile be daradara teke ono disiliakani. ");
INSERT INTO mva_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Be oarige ragaragadi kauta bokana diraulemoang nge dibaga be pangana-nao dinangai be sika teke luma oanana-lo dinangalako. Dingazingia-doi kodeka aro diboadukuduku-ria be ono disamanaganaga be bokai dipilepile, “Iuda anuatanepoa nedi! Soakingam dasalaga-tina!” ");
INSERT INTO mva_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Be ono dimoangomoangoria be pangana-nao kai ane diuniuni. ");
INSERT INTO mva_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ono disamanaga-doi kodeka kusi daradara disiliakani nge dipasiki be nena-tina dinangani. Kodeka eluku dilakuaki be kai-o darokatagaki kana. ");
INSERT INTO mva_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Dipusika be dialalale nge Sairini tamoata teke ara Saimon dite be diakangaoi be Iesus kai ne kapalapala uauau nge ibazi. ");
INSERT INTO mva_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Makara be dialale be kaba aradi Golgota-lo dipura. Ara Golgota nge labu bokai, “Tamoata mate pangana pakina-ba nge kaba ne.” ");
INSERT INTO mva_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Makara nge ‘uain’ kana mangini teke diaru dibairi-budu diani be ngasing kana. Itoi nge imangini be isege. ");
INSERT INTO mva_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kodeka kai kapalapala uauau-o dirokatagaki. Kai kapalapala uauau-o dirokatagakia-doi kodeka kusi ne didoki be guzui teke diemaki be nem-nem dinege. ");
INSERT INTO mva_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Alauri nge makara disoaki be dimatananganangai. ");
INSERT INTO mva_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pangana atabala nge kai mapala tekenao bokai digere, “Nge Iesus. Iuda Anuatanepoa kandi. ");
INSERT INTO mva_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Be tamoata anakonako rua nge sakenao kai kapalapala uauau-o dirokatagakidi. Takaia oanana-o be takaia ngasina-o. ");
INSERT INTO mva_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Be tamoata be aine makara dilakolako be dimulemule nge panganadi ditatatai be Iesus diebulobuloi. ");
INSERT INTO mva_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Be bokai dirarai, “Kupile-ra Nanaranga pera ne gogamani be amaridi toli ilodia-lo be kababe gonaguraki! Kaiko Nanaranga Natu nge nem-la be gouketiko be kai ngaranao be maka gobala!” ");
INSERT INTO mva_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki be Iuda tamoata nedi bibia nge bokaina-doi ono disamanaga be bokai dipile, ");
INSERT INTO mva_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Tamoata takadi nge uketadi iamang! Ata nena-la nge tago iboadu ngauketi! Ngai ki taila ka Iuda anuatanepoa kandi? Kai ngaranao be maka kubala masa omo lama gauni! ");
INSERT INTO mva_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ngai Nanaranga ono ikaikai be pilenga itagatagadi be ipile ngai ka Nanaranga Natu! Bokai nge makara ngatobitobi be tate Nanaranga iboadu ngauketi ki tago!” ");
INSERT INTO mva_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Be anakonako ruoti Iesus zaiza dirokatagaki-diaru nge bokaina-doi Iesus ono disamanagaru. ");
INSERT INTO mva_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ilako be amari-soasoa-tina nge oabubu kaba moarunga isukum nibe ilako rairai amari siriki tolianao. ");
INSERT INTO mva_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rairai amari siriki tolianao bokana nge Iesus ipi-tina be inaboaki be bokai ipile, “Eloi, Eloi, lema sabaktani?” Pile ngaedi tabuiri nge labudi bokai, “Nanaranga negu, Nanaranga negu, bakara ka kupereka?” ");
INSERT INTO mva_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bong tamoata alu makara dituitui dilongo nge bokai dipile, “Ilaiza ka ikilakilai.” ");
INSERT INTO mva_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kodeka tamoata teke ipananalako be kusi mapala matoli teke idoki be ‘uain’ manginina-lo inangalako be kai teke burunao inangai be Iesus izuzunakani be ngasing kana. ");
INSERT INTO mva_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ata takadi bokai dipile, “Abo. Bokai ngatobitobi be tateate! Baraoa Ilaiza ngapura be ngadumai!” ");
INSERT INTO mva_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kodeka Iesus kaikai-la imere be rerengana-lo be imate. ");
INSERT INTO mva_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iesus imate nge kusi biabia Nanaranga pera nena-lo itobitobi nge imasare be ege rua ipura. Atabala be ibala be ilako eruma. Be rike kanabiabia ipura be patu kanabibia nge dimasare. ");
INSERT INTO mva_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Be poda ditakaka be Nanaranga tamoata ne dimate nge kokoko-tina dimarang be moauriuri disoaki. ");
INSERT INTO mva_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kodeka podadi dipereki be bong Iesus mate-lo be marangaka ipura nge Anua Biabia Ratana-lo dilako be tamoata be aine kokoko-tina ditedi. ");
INSERT INTO mva_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tamoata koai-bagi imuamuadi makara tamoata ne zaiza Iesus dinarinaringi rike be kana moarunga dita nge taburidi dira-tina be bokai dipile, “Moimoina-tina ngai Nanaranga Natu!” ");
INSERT INTO mva_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aine kokoko-tina Galili-lo be Iesus ditagatagai be didumadumai nge kasauba ditui be kaba ditaita. ");
INSERT INTO mva_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Magdala aine ara Maria, Maria Zems be Iosep tina-diaru be Zebidi natu ruoti tina-diaru nge makara aine ngaedi maradi disoaki. ");
INSERT INTO mva_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rairaituka nge Arimatea tamoata teke ‘mone’ ne kokoko ara Iosep nge ipura. Ngai nge Iesus tagataga ne kata. ");
INSERT INTO mva_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kodeka ilako Pailot-lo be itegi be Iesus tamoata mate nge ngabagai kana. Be Pailot ipile be Iesus mate nge Iosep diani. ");
INSERT INTO mva_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosep ialale be Iesus mate idoki be kusi manipidi goazagoaza-tina nge idoki be ono isukumi. ");
INSERT INTO mva_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Be ilako be gimoa nena-tina kodeka-ka ikelia-lo inangalako. Gimoa ngae nge patu kanabibia ka ilodia-lo emakalako ipura. Inangalako-doi kodeka patu kanabiabia teke igegeaka-lako be gimoa aoa ono ionoti be ialale. ");
INSERT INTO mva_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Magdala aine ara Maria be Maria-la taka nge makara Iesus poda ditalariaru be disoakiru. ");
INSERT INTO mva_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Izama nge bong biabia ono manauanga, ara ‘Sabat.’ Bokaibe tamoata Nanaranga ditabatabai dimuamuadi be Parasi dilako be Pailot dite ");
INSERT INTO mva_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","be bokai dipile, “Biabiadi, tamoata bolinga ratadi isi ne iauia nge bokai ipile, ‘Amaridi toli muridi be masa ngamarang be moauriuri ngasoaki.’ ");
INSERT INTO mva_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bokaibe pile kaiboangdi gonanga be poda naringa ngapurapura nibe amaridi toli damanubu. Tagataga ne dapura be danakuaki be bokai dapile takana, ‘Ambe mate-lo be imarang!’ Boli ngaedi masa dagoala-tina takana. Matamata be ipile-doi masa ngamarang, be kababe pile ngaedi atabaladi danangaria nge kodeka dagoala-tina kana.” ");
INSERT INTO mva_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kodeka Pailot bokai ipile, “Koai-bagi tamoata negu alu kamadokidi be kamalale be poda kamanaringia-tina uia, kauanga-ming-lo bokana.” ");
INSERT INTO mva_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Be dialale be poda dionoti. Babari kaiboangina-tina ono dinangai be tamoata alu makara dinangadi be poda dinarinaringi. ");
INSERT INTO mva_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Bong ono manauanga ‘Sabat’ imanubu be kaba izama-seresereki nge Magdala aine Maria be Maria-la takaia nge dialaleru be Iesus poda datearu kana. ");
INSERT INTO mva_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Makara nge oaikiki-tina rike kanabiabia teke ipura be Tanepoa ‘enzel’ ne teke lang anua-lo be ibala be patu ono poda onota ipura nge igegeaki be ono isoaki. ");
INSERT INTO mva_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tea nge lamalama piti-kaoanga bokana be kusi ne nge oaru oaoaoadi bokana dimalamalama. ");
INSERT INTO mva_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tamoata poda dinari-naringi nge taburidi dira-tina be reresabu nge tagona-tina diuia be makara matedi bokana dituitui. ");
INSERT INTO mva_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Kodeka ‘enzel’ itaguraki be aine ruoti ngae-diaru bokai ira-diaru, “Taburi-mingru moaki dira! Ngau ukaua Iesus maka kai kapalapala uauau-o dirokatagaki ka kaleleleiaru! ");
INSERT INTO mva_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tago maka isoaki. Ambe imarang, ne ipile bokana. Kamamairu be kaba odio ieno kamaitaru. ");
INSERT INTO mva_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Be oaikiki-tina kamalaleru be tagataga ne bokai kamaradi, ‘Ambe mate-lo be imarang be aro-ming ngamua be Galili ngalako kana. Masa makara kamate.’ Pile ura-kamingru ngaedi nge ilo-mingru kauakaua-la.” ");
INSERT INTO mva_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Moimoi aine ruoti ngae-diaru nge taburi-diaru dira, ata suri-diaru diuia-tina. Kodeka poda diperekiaru be dipapanana-lanaru be Iesus tagataga ne daradi kana. ");
INSERT INTO mva_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ata oaikiki-tina Iesus zala-lo ipuraka-diaru be bokai ira-diaru, “Suri-uia ngaeno-kamingru!” Kaba bokai ditaru nge dilakoru be dirokazokuriaru be Iesus ae diboabungru be dirakeakiaru. ");
INSERT INTO mva_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kodeka Iesus bokai ipile, “Taburi-mingru moaki dira! Kamalaleru be taritokagu kamaradi be Galili dalako. Masa makara datea.” ");
INSERT INTO mva_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aine ruoti ngaedi isi dialalalelanaru be tamoata poda dinarinaringi nge alu anua-lo dilako be kana moarunga dipura nge tamoata Nanaranga ditabatabai dimuamuadi nge dirangakidi. ");
INSERT INTO mva_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kodeka tamoata Nanaranga ditabatabai dimuamuadi nge dilako be Iuda tamoata bibia zaiza diepilei. Be ‘mone’ kokoko-tina didoki be tamoata poda dinarinaringi nge diandi ");
INSERT INTO mva_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","be bokai diradi, “Bokainatuka kamapile, ‘Tagataga ne oabubu-lo kieno be dipura be dianakuaki.’ ");
INSERT INTO mva_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Pailot ilongo masa keka galako be gakoroi be kam masa giriki neming tago.” ");
INSERT INTO mva_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Makara be tamoata poda dinarinaringi nge ‘mone’ didoki be dialale be diradia-la bokana dipile. Be pile ngaedi ka Iuda moarunga isi dipilepile nibe kaituka-ba. ");
INSERT INTO mva_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iesus tagataga ne kulemoa-be-teke Galili dilako be buku muku Iesus irangakia-lo dipura. ");
INSERT INTO mva_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Makara be Iesus dite nge dirakeaki. Ata aludi nge ilodi dirua. ");
INSERT INTO mva_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kodeka Iesus saringadi ilako be bokai iradi, “Kaiboang moarunga lang anua-lo be kateka-o ambe ngau aniagu ipura. ");
INSERT INTO mva_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kamalale be ungguma moarunga kateka-o nge kamaemakidi be tagataga negu dapura. ‘Tama be Natu be Oli Spirit aradi-o be kamarukudi’ be tagataga negu dapura. ");
INSERT INTO mva_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Be kamaradi be sule moarunga uang-kaming nge dalongolongo be datagatagadi. Ilo-ming kauakaua! Ngau masa sakeming-lanao msukoaki nibe ngalako kateka-ba manubunga-nao.” ");
INSERT INTO mva_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pile Uia ngae nge Iesus Kristus Nanaranga Natu rangaka. ");
INSERT INTO mva_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Be ‘Propet’ Aisaia-la igere bokana be labu nangaia ipura. ‘Propet’ Aisaia bokai igere: “Nanaranga bokainatuka Natu irangaki, ‘Ngau masa pile eleluaki negu teke mnepi be arom ngamua. Ngai ka zalakam ngauasari be ngamua be gotagai kana.’ (Mal 3:1) ");
INSERT INTO mva_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Malonga teke masaua kaba-lo bokai ikilaulau, ‘Tanepoa zalaka kamamoataungakini. Zala adoadodi kamaemaki be odio ngalale.’” (Ais 40:3) ");
INSERT INTO mva_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Be ono pile ngaedi dakalingo kana nge tamoata teke ara Zon Baptais ipura be masaua kaba-lo isoaki be tamoata be aine ruku ono tamalinga ane irukurukudi be mangata bokai iraradi, “Ilo-ming kamabuiri be muzigoala neming kamasegeaki, be ruku ono tamalinga ane rukua-ming dapura. Bokai masa Nanaranga muzigoala neming ngarokakile-kaming.” ");
INSERT INTO mva_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bokaibe tamoata be aine moarunga Zudea kaba-lo be anua biabia Ierusalem-lo nge dilako Zon-lo be muzigoala nedi mangata dirangaki, be ruku ono tamalinga ane Zodan zagura-lo irukudi. ");
INSERT INTO mva_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zon kusi inangananga nge ngado aradi ‘kamel’ pulekedi ane ka emakadi dipura. Soa-nao nge angapi ngado aradi ‘bulumakau’ kusidi ane emaka ipura nge inanganangai. Kangkang kana nge oazikezike be kutum-patu damakadi. ");
INSERT INTO mva_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kodeka tamoata be aine mangata bokai iradi, “Murigu masa tamoata teke kaiboang ne ngau kaiboang negu diuasadi nge ngamai kana. Ngau erumaruma-tina! Bokaibe tagona-tina uboadu mboadukuria be ae-sukuma ne oarigedi mrube. ");
INSERT INTO mva_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngau dang-ba oti ka ruku ono tamalinga ane uruku-kaming. Ata ngai masa Oli Spirit kulubobi oti be ngaruku-kaming.” ");
INSERT INTO mva_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Bong ngaradia-lo nge Iesus Nasaret anua, ege Galili kaba-lo be itui be Zodan zagura-lo ipura be Zon itaguraki be ruku ono tamalinga ane irukui. ");
INSERT INTO mva_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bong Iesus rukuia ipura be dang-lo be ipusika-rake nge lang ite itakaka, be Oli Spirit nge bune bokana be ono ibalabala be ite. ");
INSERT INTO mva_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kodeka malonga teke lang-lo bokai ibala, “Kaiko ngau Natugu! Ngau urereretakiko-tina, be ilogu iuiatakiko-tina.” ");
INSERT INTO mva_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Makara nge oaikiki-tina Oli Spirit itaguraki be Iesus inepi be lulu kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Be amaridi kulemoadi-oati moarunga makara lulu kaba-lo isoaki. Makara isoaki nge Satang ipura be Iesus itoitoi. Iesus nge ngado kabukabu-ba zaiza disoaki be ‘enzel’ dipura be didumai. ");
INSERT INTO mva_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bong Zon ambe uaura-lo dinangai nge Iesus ege-ege Galili kaba-lo ilako be Nanaranga Pile Uia ne mangata irangaki. ");
INSERT INTO mva_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Iesus bokai ipile, “Bong kararapung ambe dipura! Bong ono Nanaranga ngatanepoa kana nge ambe isaringa! Ilo-ming kamabuiri be muzigoala neming kamasegeaki, be Nanaranga Pile Uia ne lama kamaunani.” ");
INSERT INTO mva_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iesus dang biabia boakuboaku ara Galili zagenao ialalale nge ika dokidoki rua Saimon tari Endru diaru raka kandiaru tekena-lo ika didokidokiru be ite-diaru. ");
INSERT INTO mva_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Be bokai ira-diaru, “Kamamairu be kamatagaiauru, be masa tamoata dokiadi mitiking-kamingru.” ");
INSERT INTO mva_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Makara nge oaikiki-tina raka kandiaru diperekiru be Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iesus kaba mukuna-la ilako nge Zebidi natu ara Zems taritoka Zon diaru kati-o disoakiru be ite-diaru. Diaru nge raka kandiaru dimoatautaungakiru be disoakiru. ");
INSERT INTO mva_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Be bong Iesus ite-diaru nge ikila-diaru. Ikila-diaru nge oaikiki-tina tama-diaru Zebidi be tamoata dimalipilipidiato nge diperekidi be Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iesus tagataga ne zaiza dialale be Kaperneam anua-lo dipura. Be bong ono manauanga ‘Sabat’ ipura nge Iesus pera ono serereinga nedia-lo isili be ambe isulesuledi. ");
INSERT INTO mva_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tamoata be aine Iesus sulenga dilongo nge dipitilaki-tina be dikabaki. Maka ma ngai tago tamoata Moses Mata ne disulesuletaki bokana isuledi. Sulenga nge dikaiboang-tina be malamakadi otioti. ");
INSERT INTO mva_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Makara pera ono serereinga-lo disoaki noko tamoata teke mariaba goalaka ilona-lo isoaki nge bokai ingangaraki, ");
INSERT INTO mva_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesus Nasaret tamoata! Ba gobasaki-kama kana? Gogamang-kama kana ka kupura ki? Ngau ukauatakiko! Kaiko Nanaranga ne, be Kusim Rata!” ");
INSERT INTO mva_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Be Iesus itaguraki be mariaba goalaka ngae kaikai-la bokai irai, “Aoam gonoti, be tamoata ngarana-lo be gopusika!” ");
INSERT INTO mva_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Makara nge mariaba goalaka nge tamoata ngae kaikai-la irurukaki be kaikai-la ingangaraki be tamoata ngaena-lo ka ipusika be iratu. ");
INSERT INTO mva_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tamoata be aine makara disoaki kaba bokai dita nge dipitilaki-tina be nedia-la dietegi, “Nge rakana kata? Sule ngaedi nge oauoau pura kaoa ki? Sulenga kalo malamakadi otioti! Maka ma mariaba goalakadi ka itaotaodi be dilongolongori!” ");
INSERT INTO mva_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bokaibe Iesus rangaka nge oaikiki-tina ege-ege Galili kaba-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pera ono serereinga-lo be dipusika nge dilako-soasoa Saimon be Endru pera kandiarua-lo. Be Zems be Zon nge dialale-budu. ");
INSERT INTO mva_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon roa tina nge more kusi-ragogo idoki be bokai zirapu-lo ieno. Bokaibe bong Iesus makara ipura nge dirangakia-soasoa. ");
INSERT INTO mva_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Bokaibe Iesus ilako aine ngaena-lo be luma-nao idoki be idokiteteki. Makara nge more ileuani be imarang be kangkang iemakadi. ");
INSERT INTO mva_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rairaituka amari ambe itaoio nge moremore be tamoata mariaba goalakadi ilodia-lo disoaki nge Iesus-lo dieluakidi. ");
INSERT INTO mva_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tamoata be aine anua ngarana-lonalona nge moarunga-doi pera aro dikabuni. ");
INSERT INTO mva_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Makara be more bakarairai-bakarairai tamoata odio be ilodia-lo dieno nge iadoraki. Be mariaba goalakadi ilodia-lo nge itaodi, ata mariaba goalakadi nge tago sesu ilikitakidi be ba sesu dipile. Maka ma mariaba goalakadi dikaua Iesus nge naita kata. ");
INSERT INTO mva_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Izama nge oabuna-tina isi tago izama uia be Iesus imarang be pera ono isoaki ipereki be ilako kaba rubedia-ba tamoata tagongana-lo be irabo. ");
INSERT INTO mva_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ata Saimon ruanga zaiza dialale be Iesus dilelei. ");
INSERT INTO mva_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Be bong dite nge bokai dirai, “Moarunga-tina dileleleiko.” ");
INSERT INTO mva_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ata Iesus ikatu be bokai ipile, “Kaba takadia-lo talako. Anua saringa dieno-lo talako be msuledi. Nge bokai kana ka upura.” ");
INSERT INTO mva_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bokaibe ege-ege Galili kaba-lo ilakolako be pera nedi ono serereinga-lo be isulesuledi be mariaba goalakadi itaotaodi. ");
INSERT INTO mva_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tamoata teke kikiri dokia ipura be Iesus aro tuku-nao irokazokuria be bokai iakoroi, “Kusumoala nge bolo oguo gorokaki be mgoaza.” ");
INSERT INTO mva_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesus tamoata ngae ite nge ilo itagaia-tina bokana luma inanaraki be ono idauraki be bokai ipile, “Ngau usumoala! Gogoaza!” ");
INSERT INTO mva_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Makara nge oaikiki-tina-la kikiri dileuani be iuia. ");
INSERT INTO mva_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Kodeka Iesus itaguraki be tamoata ngae oaikiki-tina inepi be ialale. Ngalale kana nge pile kakai ane bokai irai, ");
INSERT INTO mva_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kana ngae nge moakina-tina teke kurangakani. Ata golako-soasoa be tamoata Nanaranga ditabatabai teke ngalilitiko. Ililitiko-doi nge tabataba ono sangala rokaka Moses irangaki nge Nanaranga goemakani be ono moarunga dakaua kaiko ambe moimoi be kugoaza.” ");
INSERT INTO mva_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ata tamoata ngae ialale be kana ngae ipurani nge mangata irangarangaki be ialalale, be ono Iesus rangaka ege-ege ilakuaki. Bokaibe Iesus tago iboadu anua tekena-lo mangata ngasili. Eluku-ba kaba rubediaba-lo isukoaki. Ata tago-ma. Tamoata be aine ege-ege be dipurapurani. ");
INSERT INTO mva_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Amaridi alu muridi nge Iesus kababe Kaperneam-lo imule, be tamoata be aine nge ruku dilongo ngai ambe anua nena-lo imule. ");
INSERT INTO mva_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bokaibe tamoata be aine kokoko-tina dipura be pera Iesus ono isoaki nge diauni be iparoro-tina. Be zala aoa-nalo nge kaba tago-tina. Iesus nge ambe Nanaranga pilenga mangata irarangaki. ");
INSERT INTO mva_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Makara iraradi nge tamoata aludi tamoata kaulokuloku tapou matedi teke dieluaki. Tamoata oati dibazi be dipura. ");
INSERT INTO mva_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ata tamoata be aine dikoko-tina be tago iboadu Iesus-lo dalakuaki. Bokaibe pera boadi-kounao dilako be Iesus isoaki kana nge atabalana-tina boazinga biabia teke diemaki. Boazinga diemakia-doi, kodeka tamoata kaulokuloku nge ere-zirapu be ea diurumalako. ");
INSERT INTO mva_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bong Iesus kaba bokai ita tamoata ngaedi lama diuni ngai iboadu tamoata kaulokuloku ngae ngadoraki nge bokai irai, “Natugu! Muzigoala nem ambe rokakadi dipura.” ");
INSERT INTO mva_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tamoata Moses Mata ne disulesuletaki nge alu makara disoaki. Bokaibe bong Iesus pilenga ngaedi dilongo nge ilodia-lo pile bokai dilelenaki, ");
INSERT INTO mva_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tamoata ngae bakara ka bokai ipile? Nge suri Nanaranga diaru iriringa-diaru tekedi be iduai bokana! Maka ma tamoata-ramo tago iboadu muzigoala ngarokaki! Nanaranga-la ka iboadu!” ");
INSERT INTO mva_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Makara nge Iesus oaikiki-tina kilalanga inanga pile bokainaina ka ilodia-lo dilelelenaki. Bokaibe bokai iradi, “Bakara ka pile bokainaina ilo-ming dianiandi? ");
INSERT INTO mva_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pile nangatadi ka emakadi tago dira be iboadu tamoata kaulokuloku nge mrai, ‘Muzigoala nem ambe rokakadi dipura’ ki ‘Gotui-rake zirapu nem godoki be goalale?’ ");
INSERT INTO mva_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ata nge ono kamakaua Tamoata Natu kateka ngaenao kaiboang ne dieno, be iboadu-tina tamoata be aine moarunga muzigoala nedi ngarokakiledi!” Bokaibe tamoata kaulokuloku nge bokai irai, ");
INSERT INTO mva_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngau ka uraiko! Gotuirake, zirapu nem godokitate be pera kanam-lo golako!” ");
INSERT INTO mva_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Makara nge tamoata ngae moarunga mata-dio ka ituirake be zirapu ne ibazidi be ipusika. Tamoata moarunga kaba bokai dita nge dipitilaki-tina be Iesus dikabaki. Makara nge Nanaranga ara dirakeaki. Be bokai dipile, “Toira be imai nge kana bokainaina tago teke kite!” ");
INSERT INTO mva_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Alauri nge Iesus kaba imulelako dang biabia boakuboaku ara Galili zagenao. Makara nge tamoata dum biabia-tina teke itagai, be makara be isuledi. ");
INSERT INTO mva_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Isule-doidi be ialale be ilako nge tamoata ‘tagisi’ dokidoki teke ara Libai, Alpeas natu nge bokai pera ono ‘tagisi’ dokinga-lo isoaki be ite. Kodeka Iesus itaguraki be Libai bokai irai, “Gotagaia.” Iesus bokai ipile nge Libai itui be itagai. ");
INSERT INTO mva_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Alauri Iesus ilako be Libai pera kanana-lo imoanakonako nge ‘tagisi’ dokidoki be muzigoala ememaki kokoko dipura be Iesus tagataga ne zaiza disoakiria be dimoanako-budu. Maka ma ‘tagisi’ dokidoki be muzigoala ememaki nge kokoko-tina Iesus ditagai be makara disoaki. ");
INSERT INTO mva_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tamoata Moses Mata ne disulesuletaki Parasi kaoa kaba bokai dita Iesus muzigoala ememaki be ‘tagisi’ dokidoki zaiza dimoanakonako nge tagataga ne bokai ditegidi, “Bakara ka ‘tagisi’ dokidoki be muzigoala ememaki zaiza dimoanakonako?” ");
INSERT INTO mva_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesus pilengadi ngaedi ilongo nge bokai iradi, “Tamoata nedi uia tago iboadu karai tatate-lo dalako. Moremore-la ka dilakolako. Ngau tago tamoata adoadodi ka mkiladi kana ka upura. Tago! Ngau muzigoala ememaki ka mkiladi kana ka upura!” ");
INSERT INTO mva_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Bong teke nge Zon Baptais tagataga ne be Parasi tagataga nedi kangkang dizirau. Makara nge tamoata alu Iesus-lo dipura be bokai ditegi, “Nge baituka ka Zon tagataga ne be Parasi tagataga nedi kangkang dizirau, ata kaiko nem tago?” ");
INSERT INTO mva_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Be Iesus ikatu be bokai ipile, “Bong tamoata kodeka-ka iroti lou ne zaiza moanako-lo disoaki nge lou ne iboadu kangkang tagotago dasoaki ki tago? Tago iboadu! Maka ma tamoata kodeka-ka iroti isi sakedio isoaki! ");
INSERT INTO mva_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ata bong tekedi masa dapura be ono tamoata kodeka-ka iroti nge bagaia ngapura be tago lou ne maradi ngasoaki. Bong ngaradia-lo kodeka lou ne masa kangkang dazirau. ");
INSERT INTO mva_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Tamoata tago teke kusi oauoau mapala idoki be ono kusi muamua masarenga ioladi. Bokai imuzi masa kusi oauoau mapala ngatakaka, be kusi muamua kodeka masarenga dalaba-tina kana! ");
INSERT INTO mva_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Bokainatuka-la, tamoata tago teke ‘uain’ oauoau idoki be ‘uain’-kusi muamuana-lo inangalako. Bokai imuzi masa ‘uain’ oauoau ngadodoraki be ‘uain’-kusi muamua ngasereki be ‘uain’ be ‘uain’-kusi dagoala-doiru. ‘Uain’ oauoau nge ‘uain’-kusi oauoau-lo nangalako ngapura.” ");
INSERT INTO mva_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Bong ono manauanga ‘Sabat’ tekenao nge Iesus ‘uit’ uma aluna-lo ialalale. Be tagataga ne dialalale-budu ditaguraki be ‘uit’ kalingodi dikotokoto. ");
INSERT INTO mva_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Makara nge Parasi alu Iesus bokai dirai, “Kaba goita! Bakara ka tagataga nem bokai dimuzimuzi? Mata neda dibabari-kita tago iboadu bong ono manauanga ‘Sabat’-o bokai tamuzi!” ");
INSERT INTO mva_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Be Iesus ikatu be bokai ipile, “Bong Debiti tamoata ne zaiza tole dimate be kana teke direretaki be Debiti itaguraki be kana iemaki masa tago sesu kaleze? ");
INSERT INTO mva_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Debiti bokai imuzi: Nanaranga pera nena-lo isili be ‘bereti’ ambe Nanaranga tabangakadiani dipura nge idoki be ikang. Mata neda ipile tamoata Nanaranga ditabatabaia-la ka diboadu ‘bereti’ bokainaina dakang. Ata Debiti idoki be ikang be alu ruanga iandi be dikang. Kana ngaedi nge tamoata Nanaranga ditabatabai biabiatuka nedi ara Abaita bong nena-lo be iemaki.” ");
INSERT INTO mva_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kodeka Iesus pile ngaedi bokai imambuaki, “‘Sabat’ nge ono tamoata dumaia ngapura kana ka nangaia ipura. Tago ‘Sabat’ kana ka tamoata emaka ipura. Tago-la. ");
INSERT INTO mva_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bokaibe Tamoata Natu ka Tanepoa, be bong ono manauanga ‘Sabat’ nge Tamoata Natu ka Tanepoa ne.” ");
INSERT INTO mva_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","‘Sabat’ takaianao nge Iesus kababe pera ono serereinga-lo ilako. Makara nge tamoata teke luma takaia mate nge isoaki. ");
INSERT INTO mva_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tamoata alu makara disoaki nge Iesus dimatananganangai giriki teke ngaemaki be moatubu ono danangalako kana. Bokaibe diteate iboadu bong ono manauanga ‘Sabat’-o tamoata luma mate nge ngadoraki ki tago. ");
INSERT INTO mva_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kodeka Iesus tamoata ngae bokai irai, “Moarunga arodia-lo gotuimai.” ");
INSERT INTO mva_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kodeka Iesus itaguraki be tamoata be aine bokai itegidi, “Mata neda baituka dipile ‘Sabat’-o iboadu rakana taemaki? Muzi uia ki muzi goalakadi tamoata taemakini kana? Tamoata tadoraki be ne iauia ngasoaki ki tateatea-ba be ngamate?” Ata di dimoadubulae-ba. ");
INSERT INTO mva_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Bokaibe Iesus igea-ramo be itedi nge nama ira-tina, ata kaba ilo itagadi. Bakara, di dikaua mata iauia ka emaka ngapura kana, ata pile ngaedi ilodia-lo nangadi disege. Bokaibe tamoata luma mate nge bokai irai, “Lumam gonanaraki.” Tamoata ngae luma inanaraki nge luma ere-moarunga be iuia-doi. ");
INSERT INTO mva_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Makara nge Parasi dipusika be dialale be Erot ruanga alu zaiza be diraba be baituka be Iesus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesus tagataga ne zaiza dilako dang biabia boakuboaku ara Galili-lo nge tamoata be aine dum biabia-tina teke itagadi. ");
INSERT INTO mva_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tamoata be aine ngaedi nge Zudea kaba-lo, Ierusalem anua-lo, Idumea kaba-lo, Zodan zagura ege takaianao be Taia be Saidon anua-lo ka dipura be Iesus ditagai. Iesus kana iememaki dilongoraki ka dipura. ");
INSERT INTO mva_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tamoata be aine nge dikoko-tina. Bokaibe tagataga ne iradi be kati teke diteani be bokai dinaringakani be ieno, bakara tago irere tamoata be aine ono dakabunalako. ");
INSERT INTO mva_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Maka ma kokoko-tina nedi ambe iaka-uiadi. Be moremore takadi nge nedia-la be dierokateteki be dalako be Iesus ono dadauraki kana. ");
INSERT INTO mva_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Be bong mariaba goalakadi tamoata ilodia-lo disoaki Iesus date nge tamoatadi dataguraki be Iesus ae babadia-lo datapuloria be bokai dangangaraki, “Kaiko Nanaranga Natu!” ");
INSERT INTO mva_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ata Iesus mariaba goalakadi kaikai-la iradi moaki sesu dipile ngai naita kata. ");
INSERT INTO mva_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesus buku tekenao ikautaki kodeka tamoata ireretakidi nge ikiladi. Dimai nge ");
INSERT INTO mva_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","kulemoa-be-rua idokidi be ‘apostel’ ne bokana inangadi. Be bokai iradi, “Ngau kaituka udoki-kaming be talalale-budu kana. Be alauri masa mnepi-kaming be kamalale be pilengagu tamoata be aine takadi mangata kamarangakadi. ");
INSERT INTO mva_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Alauri masa kaiboang kamadoki be mariaba goalakadi kamataotaodi.” ");
INSERT INTO mva_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tamoata kulemoa-be-rua ngaedi ka Iesus idokidi be inangadi: Saimon (Iesus ara inangani Pita), ");
INSERT INTO mva_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebidi natu Zems taritoka Zon diaru. Iesus ara iandiaru nge Boaneres. Ara ngae labu nge bokai: “Lamalama Tamoata.” ");
INSERT INTO mva_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endru, Pilip, Batolomiu, Matiu, Tomas, Alpeas natu Zems, Tadius, Saimon Zilot kata ");
INSERT INTO mva_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","be Iudas Iskariot. Iudas Iskariot ka alauri Iesus idoki be erekei lumadi-o inangai. ");
INSERT INTO mva_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Makara be Iesus imule be pera tekena-lo isili. Ata tamoata kababe dikabuni be tagataga ne zaiza tago sesu dimoanako. ");
INSERT INTO mva_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tamoata alu nge ambe dipilepile Iesus ambe iboang. Bokaibe bong Iesus dara ne bokai dilongo nge dipura be dabagai kana. ");
INSERT INTO mva_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tamoata aludi Moses Mata ne disulesuletaki Ierusalem anua-lo ka dimai nge Iesus bokai dirangaki, “Satang-ma Bielzebul ka ilona-lo isoaki! Be nge mariaba goalakadi biabia nedi kaiboang ianiani ka mariaba goalakadi itaotaodi.” ");
INSERT INTO mva_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kodeka Iesus itaguraki be tamoata be aine ikiladi be pile ono tonanga ane be bokai iradi, “Satang masa Satang-la ne baituka ngataoni? ");
INSERT INTO mva_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Anua teke nena-la inegei be tamoata ne nedia-la maradi dieunung masa tagona-tina ngakai. ");
INSERT INTO mva_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Dara teke nedia-la dienegei be dieunung masa teke-teke dalako be tago dasukoaki-budu. ");
INSERT INTO mva_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Bokaibe Satang nena-la ienegei be ieduateteteki masa ngaleua be ngamanubu. ");
INSERT INTO mva_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Tago teke iboadu ngalako be tamoata kaiboangi teke pera kana ngasereki be kana ne ngadoki be ngairatu. Tago-la! Tamoata kaiboangi nge ngauauri noko nganakoi. Bokaibe Satang uaura ngapura noko mariaba ne goalakadi taonadi dapura. ");
INSERT INTO mva_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Moimoi ka ura-kaming! Muzigoala be pile-goala tamoata Nanaranga diememakini nge Nanaranga iboadu ngarokakiledi. ");
INSERT INTO mva_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ata tamoata naita Oli Spirit ipile-goalai nge Nanaranga tago iboadu muzigoala ne ngae ngarokakale. Tago-tina. Muzigoala ne ngae nge nem-kueno ngaeneno kana.” ");
INSERT INTO mva_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesus pile ngaedi ipile, bakara, tamoata alu bokai dipile, “Mariaba goalakadi Iesus ilona-lo disoaki.” ");
INSERT INTO mva_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesus makara isoaki be tina be taritoka dipura. Be eluku ditui be tamoata teke dinepi be ngarai kana. ");
INSERT INTO mva_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lili-kokoko-tina Iesus diboalingi be disoaki bokana bokai dirai, “Tinam be taritokam makare eluku dituitui. Ditegitegiakiko.” ");
INSERT INTO mva_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Be Iesus ikatu be bokai ipile, “Naita ka tinagu? Naita-guma ka taritoka-gu?” ");
INSERT INTO mva_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kodeka igea-ramo be tamoata sakenao diboalingi be disoaki itedi be bokai ipile, “Kamate! Nge ngau tinagu be taritokagu! ");
INSERT INTO mva_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tamoata naita Nanaranga rerenga itagatagadi ka ngau taritokagu, maraugu, be tinagu.” ");
INSERT INTO mva_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iesus kaba dang biabia boakuboaku ara Galili zagenao be isule. Tamoata be aine dalongori kana be dipura nge dikoko-tina. Bokaibe kati tekenao ibulilako be dang-lo ipoatipoati be di kabu-lo disoaki be isuledi. ");
INSERT INTO mva_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesus pile ono tonanga ane be kana kokoko isuledi. Be sulenga tekedia-lo nge bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kamalongo! Tamoata kangkang tanotano teke ialale be uma kanana-lo kangkang-patu iliki. ");
INSERT INTO mva_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Be bong ilikiliki nge kangkang-patu alu zala mukudi uma ilona-lo dieno-lo dibala, be mang dibala be dikang. ");
INSERT INTO mva_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Alu patu-kouo disapasiria. Makara nge kangkang-patu oaikiki-tina didula, ata kateka tago imatoli. ");
INSERT INTO mva_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bokaibe bong amari ikai nge imoamoapoato be dimarango, bakara ziridi tago ditao-uia bokana dimarango. ");
INSERT INTO mva_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Alu moamoaesa maradi disapasiria be didula be dilaba. Ata moamoaesa dilaba be dikubati be kalingodi tago dipuraki. ");
INSERT INTO mva_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Alu nge kateka iauia-o dibala. Be ngaedi nge didula be dilaba be kalingodi dipuraki. Alu kalingodi kulemoadi-toli dipuraki, alu kalingodi tamoatadi-toli dipuraki, be alu kalingodi tamoatadi-lima dipuraki.” ");
INSERT INTO mva_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Sulenga ono ngamambuaki kana nge Iesus bokai ipile, “Kungi-ming otioti nge kamalongo!” ");
INSERT INTO mva_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesus isule-doi be ilako be rubena-ba isoaki nge tamoata alu sulenga dilongo nge tagataga ne kulemoa-be-rua zaiza dipura be dirai be pile ono tonanga irangaki ngae nge labu nganagupasikadi kana. ");
INSERT INTO mva_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Be Iesus itaguraki be bokai iradi, “Kam ambe bong ono Nanaranga ngatanepoa kana nge labu sikitaka kakauataki. Ata tamoata eluku bong ono Nanaranga ngatanepoa kanana-lo disoaki masa pile ono tonanga ane be mraradi. ");
INSERT INTO mva_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Di masa bokainatuka basakadi dapura, ‘Kaba masa daita be daitaita, ata kana masa tago teke date. Longo masa dalongolongo, ata masa ilodi tago damoatoba. Dakaua bokana nge ambe ilodi dabuiri be Nanaranga muzigoala nedi ngarokakiledi.’” (Ais 6:9-10) ");
INSERT INTO mva_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kodeka Iesus itaguraki be bokai itegidi, “Pile ono tonanga ngae labu tago kakaua ki? Ngae labu tago kakaua masa baituka be pile ono tonanga takadi labudi kamakauataki? ");
INSERT INTO mva_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamoata kangkang-patu iliki nge Nanaranga pilenga ka iliki. ");
INSERT INTO mva_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tamoata alu nge kangkang-patu zala mukudia-lo likiradi dipura bokana. Nanaranga pilenga dilongo, ata Satang oaikiki-la imai be Nanaranga pilenga ilodia-lo likiradi dipura nge irokakiledi. ");
INSERT INTO mva_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tamoata alu nge kangkang-patu patu-kouo likiradi dipura bokana. Nanaranga pilenga dilongo be oaikiki-tina-la suri-uia-lo be didoki. ");
INSERT INTO mva_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ata tamoata bokainaina nge ziridi tagotago kaoa. Bokaibe soakingadi tago disalaga. Bong Nanaranga pilenga ara-nao be giriki daita ki sururu bibia dadoki nge oaikiki-tina-la dasege. ");
INSERT INTO mva_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ata tamoata alu nge kangkang-patu moamoaesa maradi dibala bokana. Nanaranga pilenga dilongo, ");
INSERT INTO mva_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ata ilo-buku ono bakara be nedi uia kateka-o dasoaki, kateka kana reretakadi, be ilo-buku takadi nge ilodia-lo dikauri. Kana ngaedi ka Nanaranga pilenga ilodia-lo ditapadi. Bokaibe kangkang tago dipuraki. ");
INSERT INTO mva_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ata tamoata aludi nge kangkang-patu kateka iauia-lo likiradi dipura bokana. Nanaranga pilenga dilongo be direretaki be didoki be ilodia-lo dieno. Be pile ngaedi ka kangkang-patu teke-teke bokana be kalingodi kokoko dipuraki. Teke kulemoadi-toli ipuraki, teke tamoatadi-toli ipuraki be teke kalingo tamoatadi-lima ipuraki.” ");
INSERT INTO mva_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Be Iesus kaba bokai iradi, “Bong tamoata teke baratui ne ibulai be pera kanana-lo isiliaki masa tabira-baba eruma nganangai ki bagi ono enonga eruma nganangai? Tago-la! Masa ngadoki be baratui kabadia-lo nganai be kaba malama ngandi. ");
INSERT INTO mva_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Bakara, kana zumkaka ipura nge tago iboadu ngakoma. Mangata-lo ngapura kana! Kana kubata ipura nge tago iboadu kukubati-la ngaeneno. Kakata ngapura kana! ");
INSERT INTO mva_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kungim otioti nge pile ngaedi golongo!” ");
INSERT INTO mva_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesus kaba pile takadi bokai iradi, “Pile kalongolongo nge ilo-minglo kamanangananga! Daga bakarairai katagadi be ono Nanaranga kakauataki masa Nanaranga daga-la katagadi be ono kakauataki nge ngatagadi be ono kamakauakauatakia-la, be kababe biabia-la be ngang-kaming. ");
INSERT INTO mva_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tamoata naita kana ne otioti masa kana kokoko ania ngapura. Tamoata kana ne tagotago masa dokiadia-le dapura. Kana nena-ra tago kokoko, ata masa dokiadia-le dapura.” ");
INSERT INTO mva_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesus kaba bokai iradi, “Bong ono Nanaranga ngatanepoa kana nge bokai: Tamoata teke kangkang-patudi uma kanana-lo iliki. ");
INSERT INTO mva_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Oabubu-lo nge tamoata ngae ieneno. Ariata nge ibanabanangaki be ialalale. Be bong ngaedia-lo nge kangkang-patu didula be dilabalaba. Baituka be dipura be dilaba nge tamoata ngae tago ikaua. ");
INSERT INTO mva_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kateka ka nena-la imalipi be kangkang ipuraki be kalingodi dipura. Matamatana-tina dirobu. Kodeka dirauposa be kalingodi dipura. ");
INSERT INTO mva_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kangkang damalai masa tamoata ngae asi ne ngadoki be ngatoto. Nge ambe bong ono uaroenga ka dipura.” ");
INSERT INTO mva_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesus kababe bokai iradi, “Bong ono Nanaranga ngatanepoa masa baituka tarangaki? Masa pile ono tonanga nangatadi ane be tarangaki? ");
INSERT INTO mva_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bokainatuka tarangaki! Kai-patu ara ‘mastet’ bokana. Kai-patu moarunga maradi nge ‘mastet’-patu ka mukumukunatuka. Tamoata teke idoki be kateka-lo itanomi. ");
INSERT INTO mva_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Alauri ilaba nge kai biabiatuka ipura, be sapara bibia sasalaga inanga be mang dipura be sapara aungakadia-lo gupa diemaki.” ");
INSERT INTO mva_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesus pile ono tonanga kokoko bokainaina ane be Nanaranga pilenga isuletaki. Ngasuledi nibe ngalako kauangadia-la daga. ");
INSERT INTO mva_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pile tago sesu labudi inagupasidi. Pile ono tonanga-la ane be iraradi. Ata bong tagataga ne zaiza rubedia-ba dasoaki masa kana moarunga labudi nganagupasidi. ");
INSERT INTO mva_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Amarina-la ngaranao ambe rairaituka nge Iesus tagataga ne bokai iradi, “Kamamai be dang ege takanao talako.” ");
INSERT INTO mva_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Makara be tamoata dum biabia nge dipereki. Iesus nge enumua be kati-o isoaki nge ka isoaki-la. Bokaibe tagataga ne kati ono isoaki-o dibuli be kati alu zaiza be dialale. ");
INSERT INTO mva_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Makara direbareba noko oasa kanabiabia ipura be nugunugu dilaba be kati-lo dilakolako be ambe dang ikauri. ");
INSERT INTO mva_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesus nge kati kabinao ikaluka uia be ienosoadi. Kodeka tagataga ne dianguni be bokai dipile, “‘Tisa!’ Ilom ibuku ki tago? Ambe taleua kana!” ");
INSERT INTO mva_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Kodeka Iesus ituirake be oasa imerei be bokai irai, “Gomoarugada!” Be nugunugu bokai iradi, “Kamamalie.” Kodeka oasa imalie be malino ibala. ");
INSERT INTO mva_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Makara nge Iesus tagataga ne bokai iradi, “Bakara ka taburi-ming dira? Lama unianga-ming isi tago-tina ki bakara?” ");
INSERT INTO mva_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ata di taburidi dira-tina, be nedia-la maradi bokai dipile, “Tamoata nge naita kata? Oasa be nugunugu dilongori be!” ");
INSERT INTO mva_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Dang biabia Galili ditotoki be ege takanao dilako nge Gerasa kaba-lo dipura. ");
INSERT INTO mva_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Be bong Iesus kati-o be inokuria nge tamoata teke mariaba goalaka ilona-lo isoaki nge ipurakani. Tamoata ngae nge buna ono tamoata matedi kumrakadi dipurapura kanana-lo ka ipusika. ");
INSERT INTO mva_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Makara buna ono tamoata kumrakadi dipurapura-lo anua idoki. Bokaibe tago teke iboadu ngauauri. Kaleti oarige kaiboangdi ‘seng’ ane tago iboadu dadokimatei. ");
INSERT INTO mva_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bong kokoko ambe luma be ae uauradi dipura. Ata ‘seng’ kanaba bokana idokitototo, be ‘aen’ ae ono uauradi dipurapura nge izamposaposa. Tamoata tago teke iboadu ngadokimatei. Ikai-tina. ");
INSERT INTO mva_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ariata be oabubu-lo nge bokai buna ono tamoata kumrakadi dipurapura-lo be buku kaba-balo inaboakiboaki be ialalale. Be patu zagedi sagodedi idokidoki be nena-la ono ikorokoroti. ");
INSERT INTO mva_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bong tamoata ngae kasau-la be Iesus ite nge ipanana be Iesus aro tuku-nao irokazokuria. ");
INSERT INTO mva_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kodeka mariaba goalaka nge tamoata ngae ilona-lo ka kaikai-tina imere be bokai ipile, “Iesus, Nanaranga Atabalabala-tina Natu! Ngau-lo rakana kurere? Nanaranga ara-nao moaki sururu kuiana.” ");
INSERT INTO mva_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Mariaba goalaka tamoata ngae ilona-lo nge bokai ipile, bakara Iesus ambe bokai irarai, “Mariaba goalakam, tamoata ngaena-lo gopusika!” ");
INSERT INTO mva_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kodeka Iesus tamoata ngae itegi, “Aram bakara?” Be mariaba goalaka tamoata ngae ilona-lo bokai ipile, “Aragu Labara. Maka ma keka kokoko-tina!” ");
INSERT INTO mva_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Makara nge mariaba goalakadi tamoata ngae ilona-lo ditaguraki be kababe Iesus diakorokoroi moaki itaodi be kaba ngaradi dipereki. ");
INSERT INTO mva_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Saringa makara nge boro ulunga teke bokai garangakadi-o diramomomo. ");
INSERT INTO mva_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kodeka mariaba goalakadi nge Iesus diakoroi be dipile, “Boro ngaradia-lo gonepi-kamailako! Be gosumoala be ilodia-lo gasili.” ");
INSERT INTO mva_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Be Iesus isumoaladi. Kodeka mariaba goalakadi nge tamoata ngae ilona-lo ka dipusika be dilako boro ilodia-lo disili. Be boro ulunga biabia kokotangadi ‘2,000’ bokana nge dipanana be garangakadi-o ditaolako be dang biabia-lo dinokulako be dang dising be dimoaloba. ");
INSERT INTO mva_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tamoata boro diakolakola kaba bokai dita nge diratu. Be dilako anua-lo be kaba makara saringa dieno-lo be kana dita nge dirangaki. Kodeka tamoata pile dilongo nge dipura be kana makara dipura nge daita kana. ");
INSERT INTO mva_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Be bong tamoata kaba daita kana be dipura nge tamoata mariaba goalakadi labara biabia ilona-lo disoaki nge Iesus diaru disoakiru be dite. Tamoata ngae ambe kusi teke iokori be bokai isoaki. Ngaonga dileuani be ambe ilo ikauani. Tamoata be aine kaba daita kana be dipura kaba bokai dita nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tamoata kaba-ita kaba dita-doi kodeka dimule be moarunga diradi. Be tamoata mariaba goalakadi ilona-lo disoaki kana dipurani, be boro ba diuai nge dirangaki-doi. ");
INSERT INTO mva_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bokaibe Iesus diakoroi be kaba nedi ngapereki be kaba takadia-lo ngalako kana direre. ");
INSERT INTO mva_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Bong ambe Iesus kati-o ibulibuli nge tamoata mariaba goalakadi ilona-lo disoaki be Iesus itaodi nge itegi be ngatagai kana. ");
INSERT INTO mva_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ata Iesus tago isumoala bokana bokai irai, “Gomule pera kanam-lo be kana uia Tanepoa ilo itagaiko be iemakiniko nge dara nem gorangakidi.” ");
INSERT INTO mva_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ata tamoata ngae makara be ialale be Dekapolis kaba ialaleaki be kana Iesus iemakini nge irangaki. Moarunga pile ngaedi dilongo nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Makara be Iesus kaba kati-o ibuli be dang biabia boakuboaku Galili ege takaianao ilako. Dang ege takaianao ipura nge tamoata kokoko-tina makara dang biabia zagenao dikabuni. ");
INSERT INTO mva_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kodeka Iuda tamoata nedi biabia teke pera nedi ono serereinga-lo imuamua ara Zairus nge ipura. Be bong Iesus ite nge ilako be aena-lo tapuloria. ");
INSERT INTO mva_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Be Iesus iakoro-matei be bokai irai, “Natugu aineka ambe imatemate. Gomai be lumam ono gonangaria be ngauia be ne iauia ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kodeka Iesus itaguraki be tamoata ngae itagai. Ata tamoata Iesus ditagatagai nge dikoko-tina be ono dipopopokaki. ");
INSERT INTO mva_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aine teke dara tongira be iuni nge makara maradi dialalale-budu. Aine ngae dara bokaina-la iuniuni be ambe barasi kulemoa-be-rua iuasadi. ");
INSERT INTO mva_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Bong kokoko-tina tamoata more adoadoraki-lo ilakolako be ‘mone’ ne ambe imambuaki-doi. Ata ngauia kana nge tago, goalakinga nge kodeka digoala-la be dieno. ");
INSERT INTO mva_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Aine ngae Iesus ruku ilongo bokana tamoata dum biabia Iesus ditagatagai nge maradi ilako, be Iesus murina-tina itagai be kusi-sili nenao idauraki. ");
INSERT INTO mva_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aine ngae ilona-lo nge bokai ipile, “Kusi-ba nenao mdauraki masa muia.” ");
INSERT INTO mva_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Be bong aine ngae Iesus kusi nenao idauraki nge oaikiki-tina dara unianga ngaedi nge dileua. Be kilalanga inanga more ne ngae ambe ileua. ");
INSERT INTO mva_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Bong aine ngae Iesus kusi nenao idauraki nge Iesus kilalanga inanga kaiboang ne alu dipusika. Be itaguraki be lili-kokoko maradi ka ibuiri be itegi, “Naita kata kusi neguo idauraki?” ");
INSERT INTO mva_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Be tagataga ne dikatu be bokai dirai, “Tamoata maka gotedi. Dikoko-tina be omo dipopopokaki. Nge bakara ka kupile naita omo idauraki?” ");
INSERT INTO mva_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ata Iesus isi igeagea be tamoata naita kusi nenao idauraki nge ngakauataki kana. ");
INSERT INTO mva_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aine maka iuia kaba bokai ita nge taburi ira-tina. Kodeka reresabu zaiza be imai be Iesus ae-nalo itapuloria be kana moarunga dipurani nge mangata irangaki. ");
INSERT INTO mva_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Be Iesus itaguraki be bokai irai, “Natugu! Lama uniangam ka iemakiko be kuia. Ilo-uia ngaenoniko be goalale. Be iboadu sururu nem ngaedi nge damanubu be gosoaki uia!” ");
INSERT INTO mva_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesus pilenga tagona-la imambuaki be tamoata alu Zairus pera kanana-lo dimai be Zairus bokai dirai, “Natum ambe imate. ‘Tisa’ moaki kuakangaoi.” ");
INSERT INTO mva_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ata Iesus tamoata ngaedi pilengadi tago ilo-bukutaki be Zairus bokai irai, “Ilom moaki ibuku. Lama-ba ka gouni.” ");
INSERT INTO mva_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Makara be Iesus itaguraki be tamoata moarunga imuleakidi. Pita-la be Zems taritoka Zon diaru ibagadiato be dialale-buduto. ");
INSERT INTO mva_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Bong Zairus pera kanana-lo dipura nge ambe tang be naboaki ienuaki. ");
INSERT INTO mva_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Iesus pera-lo isili nge itegidi, “Bakara ka katangtang be kanaboakiboaki? Natu ngae tago imate. Ngena ieno-ba!” ");
INSERT INTO mva_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ata moarunga pera-lo disoaki be ditangtang nge Iesus dingengeri. Bokaibe Iesus inepidi be dipusika. Kodeka itaguraki be natu-la mate tina be tama be tagataga ne toli ibagadi be disili natu mate ieno kana. ");
INSERT INTO mva_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Makara nge Iesus itaguraki be natu ngae luma-nao idauraki be bokai irai, “Talita kum.” Pile ngaedi labudi nge bokai, “Aine mukumukum. Ngau upile gomarang.” ");
INSERT INTO mva_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Makara nge natu aine ngae oaikiki-tina-la imarang be ialalale. Natu aine ngae barasi ne nge kulemoa-be-rua. Tamoata makara Iesus zaiza disoaki kaba bokai dita nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Makara nge Iesus ibabaridia-tina tamoata moaki teke kana ngae dirangakani. Kodeka iradi be natu aine ngae nge kangkang teke dani be ngakani kana. ");
INSERT INTO mva_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesus kaba ngaradi ipereki be anua nena-lo ilako. Be tagataga ne ditagai be dialale-budu. ");
INSERT INTO mva_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Be bong ono manauanga ‘Sabat’ ipura nge Iesus ilako pera ono serereinga-lo be isule. Tamoata be aine kokoko dilongori nge dipitilaki-tina be bokai dipile, “Tamoata ngae kana moarunga ngaedi inanga ka idoki? Kaua malaidi bakarairai kaoa ka ania ipura? Be kilala kaiboangdi iememaki nge baituka be iememaki? ");
INSERT INTO mva_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tamoata ngae ka pera kelikeli ki taila? Ngai ki naita ka Maria natu? Be nge ngai ki naita taritoka ka Zems, Iosep, Iudas be Saimon? Nge suri ngai marau bokana makare disukoaki?” Be makara nge namadi diratakia-tina. ");
INSERT INTO mva_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kodeka Iesus itaguraki be bokai iradi, “‘Propet’ anua moarunga-lo nge muaka otioti. Anua-tina nena-lo be pera kana be dara nena-lo nge muaka tagotago.” ");
INSERT INTO mva_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bokaibe kilala kaiboangdi iememaki nge tago teke makara iemaki. Moremore-la alu ka luma odio inangaria be iadorakidi. ");
INSERT INTO mva_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Iesus kaba bokai ita lama tago diunani nge ipitilaki-tina. Kodeka Iesus ialale anua-anua-lo be isulesuledi be ialalale. ");
INSERT INTO mva_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Makara nge tagataga ne kulemoa-be-rua ikiladi be kaiboang iandi be iboadu mariaba goalakadi dataodi. Kodeka rua-rua inepidi be dialale. ");
INSERT INTO mva_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dalale kana nge bokai iradi, “Alale ngaena-lo nge kana moaki teke kadokidoki be kalale. Sika ono alalenga-la neming ka kamadokidoki. Kangkang, ki raba, ki ‘mone’ moaki teke kadokidoki. ");
INSERT INTO mva_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ae-sukuma kamananga, ata kusi-sili moaki karuadi. ");
INSERT INTO mva_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Bong kalako anua tekena-lo be pera tekena-lo dimolataki-kaming be diadoraki-kaming nge pera-la ngara-nalo kamasoaki nibe anua-ba ngara kamapereki. ");
INSERT INTO mva_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Anua nangatana-lo kapura be tago didoki-kaming be diadoraki-kaming ki tago dilongori-kaming nge bong kalalale nge ae-ming gapukadi kamatatai. Bokai masa tonanga bokana ono dadoki be alauri masa Nanaranga sururu ngandi!” ");
INSERT INTO mva_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kodeka makara be tagataga ne dialale be tamoata be aine mangata bokai diraradi, “Ilo-ming kamabuiri be muzigoala neming kamasegeaki.” ");
INSERT INTO mva_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Be mariaba goalakadi kokoko tamoata ilodia-lo disoaki nge ditaodi, be moremore kokoko bureng ane diburengdi be diuia. ");
INSERT INTO mva_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iesus rangaka be kana iememaki nge ambe ege-ege kaba moarunga-lo dilako. Bokaibe Iuda anuatanepoa kandi ara Erot nge kana ngaedi ilongoraki. Tamoata alu nge Iesus bokai dirangarangaki, “Ngena Zon Baptais ka kababe imoauri. Nge bokai ka kilala kaiboangdi iememaki.” ");
INSERT INTO mva_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Alu bokai dirangaki, “Ngena Ilaiza.” Ata kaba alu bokai dipile, “Ngena ‘propet’ kata. Toira-ma alu dipurapura-kita bokanana-re!” ");
INSERT INTO mva_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ata bong Erot pile ngaedi ilongo nge bokai ipile, “Zon-ma maka ngau norane be dudu utotokani nge ka kababe imoauri!” ");
INSERT INTO mva_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Maka ma Erot ka ipile be Zon didokimatei be oarige ane diuauri be uaura pera-lo dinangai. Erodias lili-nao ka Erot itaguraki be Zon uaura-lo inangai. Erodias nge Erot taritoka Pilip roa, ata Erot ibagai be iuati. ");
INSERT INTO mva_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Nge bokai ka Zon nge izamaizama Erot bokai irarai, “Kaiko kupakai be taritokam roa kuati.” ");
INSERT INTO mva_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Bokaibe Erodias nge Zon nama irarataki. Be Erodias itaguraki be Zon ngaumoatei kana, ata Erot imatakuri. Bokai ka tago iboadu ngaumoatei. ");
INSERT INTO mva_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Erot ikaua Zon nge tamoata iauia be ngai nge Nanaranga tamoata ne kata. Moimoi Zon pilenga nge Erot diaka-boangboangi be pile labudi tago ikauakauataki, ata pilenga longoradi irerere. Bokaibe imatakutakuri be ioioiaki be tago iboadu ba ngauai. ");
INSERT INTO mva_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kodeka bong teke nge Erodias zalaka dipura be ono Zon ngaumoatei kana. Bong ngae nge Erot bong ne ono tina inekiaki. Bokaibe Erot moanako biabia teke iemaki be tamoata ne bibia, tamoata koai-bagi panganadi be Galili tamoata bibia ikiladi. ");
INSERT INTO mva_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Makara be Erodias natu aineka nge isili be ioagudi. Ioagu-doi nge Erot lou ne zaiza oagunga dikulang-tina. Kodeka Erot itaguraki be natu aine ngae bokai itegi, “Rakana kurere? Kana kureretaki be kurangaki nge miangko-ba kana!” ");
INSERT INTO mva_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Makara be pile tago tototo ane be moimoi be bokai ipile, “Rakana rerengam-lo kurangaki be miangko kana nge miangko-la be kana. Kaba negu be kana negu moarunga egedi takadi kureretaki be kurangaki nge miangko kana. Tago iboadu msege.” ");
INSERT INTO mva_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Natu aine ngae pile bokai ilongo nge ilako be tina Erodias itegi, “Rakana ngana kana mpile?” Be tina bokai ipile, “Zon pangana.” ");
INSERT INTO mva_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bokaibe natu aine ngae oaikiki-tina imule be Erot bokai irai, “Ngau urere kaituka-tina-la Zon Baptais pangana tabira tekena-lo be goana.” ");
INSERT INTO mva_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Erot natu aine ngae pilenga bokai ilongo nge ilo inodo-tina. Ata tago iboadu ngasege. Maka ma ambe lou ne matadi-o be pile tago tototo natu aine ngae iemakini. ");
INSERT INTO mva_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bokaibe oaikiki-tina tamoata dudu tototo teke inepi be Zon dudu ngatotoki be ngabagai kana. Be tamoata ngae ilako uaura pera-lo be Zon dudu itotoki. ");
INSERT INTO mva_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kodeka tabira-lo inangalako be natu aine ngae iani. Be natu aine ngae idoki be ilako tina iani. ");
INSERT INTO mva_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Alauri Zon tagataga ne pile dilongo nge dipura be Zon tamoata dibagai be dikumraki. ");
INSERT INTO mva_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","‘Apostel’ Iesus inepidi dimule nge kana diemaki be pile disuletaki nge Iesus dirangakini. ");
INSERT INTO mva_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ata tamoata be aine nge kokoko-tina dilakolako be dimulemule. Bokaibe Iesus tagataga ne zaiza tago diboadu damoanako. Kodeka tagataga ne bokai iradi, “Kamatagaia be kaba rubedia-ba tekedia-lo talako be sesu kamamanaua.” ");
INSERT INTO mva_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Makara be rubedia-ba kati-o dibuli be kaba tekedi rubediaba-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ata tamoata kokoko-tina Iesus tagataga ne zaiza kati-o dibulibuli be ditedi nge dikilalangdi. Bokaibe ege-ege anua moarunga-lo nge kabu-lo dipanana be dilako be kaba Iesus tagataga ne zaiza ono datoka kanana-lo nge makara dirapurapu. ");
INSERT INTO mva_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bong Iesus tagataga ne zaiza ditoka be Iesus tamoata be aine kokoko-tina itedi nge ilo itagadia-tina. Bakara, di nge ‘sipisipi’ tamadi tagotago bokana. Kodeka kana kokoko isuledi. ");
INSERT INTO mva_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Makara isulesuledi be ambe irairai. Tagataga ne dilako be dirai, “Ambe irairai-tina be kaba ngaedi nge masauaba-tinao ka dieno. ");
INSERT INTO mva_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Gonepidi be dalale be anua be kaba maka saringa dieno-lo be kangkang kandia-la be dazaza be dakang.” ");
INSERT INTO mva_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ata Iesus ikatu be bokai iradi, “Kam kangkang kamandi be dakang.” Be tagataga ne bokai dipile, “‘Mone’ biabia-tina garokaki masa iboadu kangkang gazaza be tamoata be aine ngaedi akolangadi dapura. Kurere galale be ‘mone’ biabia-tina bokainaina garokaki be ono kangkang gazaza?” ");
INSERT INTO mva_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Kodeka Iesus itegidi, “‘Bereti’ ira makara dieno? Kamalako be kamaita.” Dilako be dita nge bokai dipile, “‘Bereti’ lima be ika rua.” ");
INSERT INTO mva_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kodeka Iesus tagataga ne iradi be tamoata be aine diradi be uko-uko be siresire-o disoakiria. ");
INSERT INTO mva_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Bokaibe tamoata be aine dienegei be uko-uko be disoaki, aludi tamoatadi-lima be aludi kulemoadi-lima-lo disoaki. ");
INSERT INTO mva_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kodeka Iesus ‘bereti’ lima be ika rua ngaedi idoki be lang-lo itadalako be Nanaranga iperui. Iperuia-doi, kodeka ‘bereti’ ikingpoato be tagataga ne iradi be tamoata be aine dinegedi. Be ika rua nge ikoto be iandi be dinege. ");
INSERT INTO mva_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Be tamoata be aine moarunga dimoanako be didoli. ");
INSERT INTO mva_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kodeka tagataga ne raba bibia kulemoa-be-rua didoki be ono ‘bereti’ be ika muleakadi dipura nge diau. ");
INSERT INTO mva_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tamoata moane dimoanako nge ‘5,000’ moarunga. ");
INSERT INTO mva_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Makara nge oaikiki-tina Iesus itaguraki be tagataga ne inepidi be kati-o dabuli be aro damua be dang ege takanao Betsaida dalako kana. Ata ngai isoaki be tamoata be aine inepidi be dialale. ");
INSERT INTO mva_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Inepidi be dialale kodeka buku muku tekenao ilako be Nanaranga iraboi. ");
INSERT INTO mva_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ambe rairaituka-tina nge kati tagataga ne ono direbareba nge ambe dang lukangana-tinao irebareba. Ata Iesus isi rubenaba kabu-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Iesus kaba italako nge oasa arodi ipurapura be tagataga ne nge dipipi-tina be dioreore. Ambe mang uludi-o nge Iesus dang kusina-o ialale be itagadi be ilako be ambe ngabagapalitidi kana. ");
INSERT INTO mva_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ata bong tagataga ne dite nge ilodi dipile anunu kata be dinaboaki be kaba dirati. ");
INSERT INTO mva_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maka ma di moarunga nge ditea-doi. Bokaibe taburidi nge dira-tina. Ata Iesus oaikiki-la bokai iradi, “Kamakaiboang. Ngena ngau. Moaki taburi-ming dira.” ");
INSERT INTO mva_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kodeka kati-o ibulilako be oasa imalie. Tagataga ne nge dipitilaki-ba be aoa-di disanganga. ");
INSERT INTO mva_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Maka ma ilodi dikaiboang be tago iboadu lama dauni. Be ‘bereti’ lima be ika rua tamoata kokoko iandi nge labudi tago dikauataki uia. ");
INSERT INTO mva_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Makara be dialale be Genesaret kaba-lo dipura, be kati makara ditukui. ");
INSERT INTO mva_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iesus tagataga ne zaiza nge kodeka-la kati-o be dinokunokuria be tamoata be aine makara nge ambe Iesus dikilalangi. ");
INSERT INTO mva_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kodeka ege-ege kaba ngaradia-lo dipananalako be moremore zirapu nedia-lo be dibazidi be Iesus-lo dieluakidi. ");
INSERT INTO mva_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Be ege-ege anua bibia-lo be sisiki-lo ilakolako nge moremore malala nedia-lo dieleluakidi be diakorokoroi be kusi-ba ne zage odio dadaudauraki kana. Moarunga kusi ne zage-dio didaudauraki nge diuiauia-doi. ");
INSERT INTO mva_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parasi be tamoata Moses Mata ne disulesuletaki alu Ierusalem-lo ka dipura nge dilako be Iesus diboalingi be disoaki. ");
INSERT INTO mva_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tamoata ngaedi kaba bokai dita Iesus tagataga ne alu nge tago Iuda mata nedi ditagadi be luma-di diasaki noko dimoanako. Bokai dimuzi nge lumadi isi dibolo be dimoanako. ");
INSERT INTO mva_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parasi be Iuda moarunga nge sikeng be mata toirairadi tubudi be tamadi nedi ka ditagatagadi. Luma-di nge mata nedia-lo dasaki-uia noko damoanako. ");
INSERT INTO mva_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Malala-lo ki kaba tamoata kokoko disoaki kanana-lo dilako be dimule nge tagona-tina damoanako noko. Datamalidi mata nedia-lo kodeka damoanako. Tubudi mata nedi takadi toirairadi nge kokoko-tina ditagatagadi be. Mata bokainaina: Boadi, tabira, sema-sai be bagi mukudi ono moanakonga nge mata nedi datagadi be dasaki noko odio damoanako. ");
INSERT INTO mva_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bokai ka Parasi be tamoata Moses Mata ne disulesuletaki nge Iesus ditegi, “Bakara ka tagataga nem tubu-da be tama-da mata nedi tago ditagatagadi? Luma-di isi bolobolo, tago mata neda-lo diasasaki noko dimoanakonako!” ");
INSERT INTO mva_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Be Iesus ikatu be bokai ipile, “Toira Aisaia isoaki be pile mumuakadi oti be irangaki-kaming nge moimoina-tina ka irangaki-kaming! Bolinga-ming ratadi! Nge kam-tina-ma ka bokainatuka irangaki-kaming be rangaka-ming igere: ‘Tamoata ngaedi nge uasi-diaba ane ka dimuamuaka, ata ilodi nge kasauba-tina ka dieno. ");
INSERT INTO mva_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rakeaka ra dirakerakeaka, ata dimamalomalo-ba. Tamoata-ramo sulengadi didokidoki be tamoata takadi disulesuledi be dipilepile-ra nge Nanaranga pilenga.’ (Ais 29:13) ");
INSERT INTO mva_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Bokaibe kam Nanaranga pilenga karokaki be tamoata muzi nedi kadokimatedi be katagatagadi.” ");
INSERT INTO mva_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Be Iesus kaba bokai iradi, “Kam zala ono Nanaranga mata ne sibongakadi be neming-la mata ne-ming dokimateadi nge kamang-tina! ");
INSERT INTO mva_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maka ma Moses bokai ipile, ‘Tinam be tamam gomuamuakidi.’ Be pilenga takadi bokai, ‘Tamoata naita tama ki tina ingesuaki nge umoatea ngapura.’ ");
INSERT INTO mva_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ata kam sulenga-ming bokai, ‘Tamoata teke iboadu-tina tina be tama bokai ngaradi, “Kana ngaeni ane be mduma-kamingru kana, ata tago iboadu miang-kamingru. Maka ma ambe Nanaranga uiani.” ’ ");
INSERT INTO mva_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tamoata bokai ipile nge iboadu tina be tama tago ngadumadi, kam sulenga-ming bokana. ");
INSERT INTO mva_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Bokaibe Nanaranga pilenga karorokaki be mata neming toira be kabatadi be dimai nge kasulesuletaki! Be kana kokoko-tina takadi bokainaina nge bokai kaememaki be.” ");
INSERT INTO mva_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Kodeka Iesus tamoata be aine moarunga ikiladi be bokai iradi, “Kam moarunga kamalongora, be ilo-ming damoatoba. ");
INSERT INTO mva_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kana tago teke eluku-lo be ilo-lo isili iboadu tamoata ngaemaki be ngabolo. Tago-tina! Kana ilo-lo be dipusikasika ka tamoata diememakidi be dibolobolo.  ");
INSERT INTO mva_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Kungi-ming otioti nge kamalongo!” ");
INSERT INTO mva_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Bong Iesus tamoata be aine iperekidi be pera-lo isili nge tagataga ne ditagai be dirai be pile ono tonanga ngae labu nganagupasikadi kana. ");
INSERT INTO mva_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Be Iesus ikatu be bokai iradi, “Kam isi tago kazama uia ki? Tago kakaua kana eluku-lo be tamoata ilona-lo ilako nge tago iboadu ngaemaki be ngabolo? ");
INSERT INTO mva_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Maka ma nge tago pangana-nalo ka dilako. Nge boura-nalo ka dilako be kababe dipusika.” Iesus bokai ipile nge ono ira-kita kangkang moarunga nge uia-doi, be iboadu takangkang. ");
INSERT INTO mva_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Be Iesus kaba pilenga ibatadi be bokai ipile, “Kana tamoata ilodia-lo be dipusikasika ka diememakidi be muzigoala diememaki be ono dibolobolo. ");
INSERT INTO mva_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tamoata ilona-lo ka muzi goalakadi ngaedi ilo ianiandi be ono muzigoala iememaki: kana-goala ilo ianiandi, pogiza-ramo muzi iememaki, ianakonako, tamoata takadi iumoatemoatedi, roti igagamang be aine ki moane takadi zaiza dieneno-budu, ");
INSERT INTO mva_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kana kokoko nemiadi irerere, tamoata takadi ibobolesidi, imangazingazi, tamoata takadi aradi igoalagoalangaki, tamoata takadi ibabalakidi, nena-la iraketukatukai, be ngao-ramo. ");
INSERT INTO mva_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kana moarunga ngaedi ka tamoata ilodia-lo be dikaukautaki be diememakidi be muzigoala diememaki be ono dibolobolo.” ");
INSERT INTO mva_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Makara be Iesus itui be ialale be kaba tekedi Taia anua saringa dieno-lo ilako, be pera teke-nalo isili. Iesus tago irere tamoata teke ngakaua ngai makara isoaki. Ata tago iboadu ngakoma. ");
INSERT INTO mva_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uanana tagona-la disalaga be aine teke ipura be Iesus ae-nalo itapuloria. Aine ngae natu aineka nge mariaba goalaka teke ilona-lo isoaki. Be bong aine ngae Iesus ilongoraki nge oaikiki-tina ipura. ");
INSERT INTO mva_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aine nge Grik kata, be Pinisia anua-lo ka nekiaka ipura. Pinisia nge Siria kaba-lo ka ieno. Aine ngae ipura be Iesus iakoroi be mariaba goalaka natu aineka ilona-lo isoaki nge ngataoni kana. ");
INSERT INTO mva_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ata Iesus aine ngae bokai irai, “Natu-muku kangkang kandi tandi be damoanako noko. Nge tago iuia natu-muku kangkang kandi tadoki be keu nedi tarokakidi.” ");
INSERT INTO mva_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ata aine ngae ikatu be bokai ipile, “Biabiadi, nge moimoi, ata keu kaba bagi ono moanakonga erumadi disukoaki be natu-muku kangkang kandi bururuingadi dikangkang.” ");
INSERT INTO mva_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Makara nge Iesus aine ngae bokai irai, “Pilengam-ba ngaedia-lo nge ngau ka uraiko, ‘Kaba kanam golako. Mariaba goalaka ambe natum-lo ipusika be iratu.’” ");
INSERT INTO mva_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Be aine ngae pera kanana-lo ilako nge natu bokai zirapu-o ieno be ite. Mariaba goalaka ambe ipereki be iuia-tina. ");
INSERT INTO mva_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Kodeka Iesus kaba ngaradi Taia anua saringa nge ipereki be ilako Saidon anua itotoki be Galili dang-lo ipura be ilako-soasoa Dekapolis kaba-lo. ");
INSERT INTO mva_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Makara nge tamoata teke kungiza dieluaki be Iesus diakoroi be luma ono nganangaria kana. Tamoata ngae nge tago ipilepile uia. ");
INSERT INTO mva_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kodeka Iesus ilako be tamoata kungiza nge ibagai be tamoata be aine moarunga dipereki-diaru be rubedia-baru dilakoru. Kodeka Iesus itaguraki be luma kabodi ene tamoata ngae kungina-lo inabadialako, be kabo-nalo imoango-lako be tamoata ngae meme-nao inangaria. ");
INSERT INTO mva_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kodeka etatabala lang-lo itadalako be oasaka kaikai-tina irape be bokai ipile, “Epata!” Nge bokai ipile, “Gotakaka.” ");
INSERT INTO mva_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iesus bokai ipile nge tamoata ngae kungi pile dilongo, be meme itarube be kodeka ipilepile uia. ");
INSERT INTO mva_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Makara nge ibabaridia-tina moakina-tina teke dirai. Ata bong Iesus ibabaridia-la be ieno nge di kodeka dipi be mangata dirangarangakia-la. ");
INSERT INTO mva_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Moarunga kana ngaedi dilongoraki nge dipitilaki-tina be bokai dipile, “Kana moarunga iememaki nge diuiauia-doi. Tamoata kungizadi nge iememakidi be dilongolongo, be tamoata pile bebebedi nge iememakidi be dipilepile.” ");
INSERT INTO mva_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bong ngaradia-lo nge tamoata be aine dum kanabiabia takaia ipura. Be bong kangkang tago nge Iesus tagataga ne ikiladi be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tamoata be aine ngaedi ilo-gu itagadi. Ambe amaridi toli sakeguo disoaki be kangkang dakang kana nge tago. ");
INSERT INTO mva_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aludi kasau-tina-lo ka dipura. Bokaibe toletole-ba mnepidi be dalale masa zala-lo matadi dasoalili be datamong.” ");
INSERT INTO mva_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ata tagataga ne ditegi, “Makare masaua kaba-lo masa kangkang inanga tea ngapura be iboadu tamoata be aine kokotangadi bokainaina ono akolangadi dapura?” ");
INSERT INTO mva_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Be Iesus kaba itegidi, “‘Bereti’ ira dieno-kaming?” Be di dikatu be dipile, “Lima-rua.” ");
INSERT INTO mva_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kodeka Iesus itaguraki be tamoata be aine iradi be kateka-o disoakiria. Disoaki-doiria, kodeka ‘bereti’ lima-rua ngaedi idoki be Nanaranga iperui be ikingkoto be tagataga ne iandi be tamoata be aine danegedi kana. Be tagataga ne didoki be dinege. ");
INSERT INTO mva_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ika mukumukudi alu dienodi be. Bokaibe Iesus idoki be Nanaranga iperui be tagataga ne iradi be dinege. ");
INSERT INTO mva_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Moarunga-biabia makara disoaki nge dimoanako be didoli. Dimoanako-doi, kodeka Iesus tagataga ne raba bibia lima-rua didoki be kangkang dimuleaki nge diau. ");
INSERT INTO mva_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tamoata moane makara dimoanako nge ‘4,000’ moarunga. Alauri Iesus tamoata be aine inepidi be dialale, ");
INSERT INTO mva_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nge tagataga ne zaiza kati-o dibuli be Dalmanuta kaba-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parasi alu dipura be ditaguraki be Iesus zaiza diegore. Be ono datoi kana nge bokai dirai, “Keka kilala teke lang anua-lonalona gate ka kirere.” ");
INSERT INTO mva_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Makara nge Iesus kaikai-la oasa irape be bokai iradi, “Bakara ka tamoata bong ngaedia-lonalona kilala kaiboangi dikeliaki? Moimoi ka ura-kaming! Tagona-tina iboadu tamoata kaituka disoaki kilala kaiboangi teke memakadi! Tago-tina!” ");
INSERT INTO mva_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kodeka iperekidi be kati-o ibuli be dang biabia Galili ege takaianao ilako. ");
INSERT INTO mva_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Iesus tagataga ne nge ilodi dikoko be ‘bereti’ tago teke dibagabagai. Tekena-la dibagabagai nge kati-lanao ieno. ");
INSERT INTO mva_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kodeka Iesus bokai iradi, “Eke! Kaba kamaitaita-tina uia! Parasi be Erot ‘is’ nedi kamamatakuakia-tina uia!” ");
INSERT INTO mva_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iesus bokai ipile nge tagataga ne ditaguraki be nedia-la bokai diegore, “Masa ‘bereti’ tago teke tabagabagai ka bokai ipile.” ");
INSERT INTO mva_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ata Iesus ikaua nge rakana ka diegoregoretaki. Bokaibe itegidi, “Bakara ka ‘bereti’ tago teke kadokidoki kana kapilepile? Kaba tago kaitaita? Tago isi kazama ki? Pangana-ming isi ipatungaki be pilenga-gu dokiadi kasege ki? ");
INSERT INTO mva_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mata-ming otioti ki tagotago kaoa? Bakara ka kaba tago kaitaita? Kungi-ming otioti ki tagotago kaoa? Bakara ka tago kalongolongo? Ak, ilo-ming kauakaua ki tago? ");
INSERT INTO mva_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bong ngau ‘bereti’ lima ‘5,000’ tamoata usaredi nge raba bibia ira kaiau?” Be di dikatu be dipile, “Kulemoa-be-rua.” ");
INSERT INTO mva_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Be Iesus kaba itegidi, “Be bong bereti lima-rua ‘4,000’ tamoata usaredi nge raba bibia ira kaiau?” Be di dikatu be dipile, “Lima-rua.” ");
INSERT INTO mva_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kodeka bokai itegidi, “Ata isi tago kazama uia ki?” ");
INSERT INTO mva_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Makara be dialale be Betsaida anua-lo dipura. Makara nge tamoata teke mata leuadi dieluaki be Iesus diakoroi be luma ono nganangaria kana. ");
INSERT INTO mva_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kodeka Iesus itaguraki be tamoata mata leuadi luma-nao idoki be iaromuani be anua diperekiaru be eluku dilakoru. Eluku nge Iesus itaguraki be tamoata ngae mata-nao imongoria be luma ono inangaria. Kodeka itegi, “Kana teke kute ki tago?” ");
INSERT INTO mva_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tamoata ngae itadarake be bokai ipile, “E! Tamoata utedi. Ata kai-ba bokana dialalale be utetedi.” ");
INSERT INTO mva_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Makara nge Iesus kaba be luma tamoata ngae mata-nalo inangalako. Kodeka tamoata ngae mata inanaraki be mata ditakaka be kaba ita uia. ");
INSERT INTO mva_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iadorakia-doi, kodeka pera kana-nalo inepalako. Ngalale kana nge bokai irai, “Moaki anua-lo kulako!” ");
INSERT INTO mva_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Alauri nge Iesus tagataga ne zaiza dialale be anua moarunga Sisaria Pilipai kaba-lo nge dialaleaki. Be zala-lo nge bokai itegidi, “Kamaraia! Tamoata be aine ngau naita kana dirangaka?” ");
INSERT INTO mva_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Be di dikatu be bokai dipile, “Alu dipile kaiko Zon Baptais. Alu dipile kaiko Ilaiza. Kaba alu dipile kaiko nge ‘propet’ kata.” ");
INSERT INTO mva_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Be Iesus kaba itegidi, “Be kam? Ngau naita kana karangaka?” Be Pita ikatu be bokai ipile, “Kaiko ka Nanaranga iburengiko be Kristus.” ");
INSERT INTO mva_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Makara nge Iesus ibabaridia-tina moaki dipile ngai naita kata. ");
INSERT INTO mva_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kodeka Iesus itaguraki be tagataga ne isuledi. Bokai iradi, “Tamoata Natu masa sururu bibia-tina ngadoki. Iuda tamoata nedi bibia, tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki masa dasegeaki be umoatea ngapura be amaridi toli muridi masa mate-lo be ngamarang.” ");
INSERT INTO mva_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pile ngaedi nge mangata-la ka iraradi. Bokaibe Pita itaguraki be Iesus kasau-ba ilakuaki be iebulobuloni. ");
INSERT INTO mva_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ata Iesus ibuiri be tagataga ne itedi be Pita bokai iebuloi, “Satang! Goiratu be murigu-lo golako! Nge tago kana Nanaranga ilona-lo dieno bokana ka ilom-lo dieno. Nge kana tamoata-ramo ilodia-lo dieno ka dienoniko.” ");
INSERT INTO mva_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kodeka Iesus itaguraki be tamoata be aine moarunga be tagataga ne ikiladi be bokai iradi, “Tamoata naita ngau ngatagaia kana nge nena-la ngailo-leuataki, be kai ne kapalapala uauau ngabazi be ngatagaia. ");
INSERT INTO mva_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bakara, tamoata naita ne moauriuri soakinga ngauketi kana masa ngaleua. Ata tamoata naita ngau be Pile Uia kanabe imate masa moauriuri soakinga ngauketi. ");
INSERT INTO mva_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Maka ma bokai kamakaua: Tamoata teke kana moarunga kateka-onaona idoki be inemdi, ata mariabaka eoa tago matemate-lo ilako be makara nem-kusoaki isukoaki. Bokai nge kana kateka-onaona ngaedi masa baituka be dadumai? ");
INSERT INTO mva_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ki masa rakana oti be tamoata teke iboadu ne mariabaka ngazazai be ono moauriuri-la ngasukoaki? Tagona-tina iboadu! ");
INSERT INTO mva_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Bong ngaedia-lo nge tamoata be aine makare kateka-o nge Nanaranga ono dimanainai aine-la roa ono ngamanainai bokana, be muzi goalakadia-tina diememaki. Bokaibe bong ngaedia-lo be tamoata naita ngau be pilengagu imakaki masa alauri Tamoata Natu Tama kaiboang be malama nena-lo be ‘enzel’ kusidi ratadi zaiza ngapura masa tamoata ngae ngamakaki.” ");
INSERT INTO mva_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Be Iesus kaba bokai iradi, “Moimoi ka ura-kaming. Alu maka dituitui masa mate bubuna tagona-la date be bong ono Nanaranga ngatanepoa kana nge kaiboang ne zaiza be ngapurapura be date.” ");
INSERT INTO mva_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Amaridi lima-teke muridi nge Iesus itaguraki be Pita, Zon be Zems ibagadiato be buku salagalaga tekenao dilakoto be makara rubediabato disoakito. Makara disoaki noko Iesus itabuli be takaiana-ba ipura. ");
INSERT INTO mva_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kusi ne inangananga nge dioaoa-sepuka. Tamoata kateka ngaenao tago teke iboadu kusi ne ngasaki be bokainatuka daoaoaoa. ");
INSERT INTO mva_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Makara nge Ilaiza be Moses inangai-ba ka dipura-ru, be Iesus diato dipilepileto. ");
INSERT INTO mva_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kodeka Pita itaguraki be Iesus bokai irai, “‘Tisa,’ uari-tina be maka kisoakito be masa bazarua toli gakelito. Teke nem. Teke Moses ne, be teke Ilaiza ne.” ");
INSERT INTO mva_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita nge ramoramo-ba ka ipile. Maka ma taburi-diato dira-tina. Nge bokai ka tago ikaua masa ba ngapile. ");
INSERT INTO mva_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Makara nge oaru biabia teke ipura be isukumdi be malonga teke oaru ilona-lo bokai ipile, “Nge Natugu-tina. Ngau ureretakia-tina! Kamalongolongori!” ");
INSERT INTO mva_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pile ngaedi dimanubu be oaikiki-tina ditadaraketo be digeato nge tamoata tago teke diteato. Iesus-la rube sake-diatoio isoaki. ");
INSERT INTO mva_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bong ambe ditaotaoto nge Iesus bokai ira-diato, “Kana kaituka kaita nge moakina-tina teke karangakini nibe ngalako Tamoata Natu mate-lo be ngamarang.” ");
INSERT INTO mva_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bokaibe kana ngaedi nge tago sesu dirangakiato, ata nedia-lanato maradiato nge bokai diegoreto, “Pile ngaedi mate-lo be marang nge labudi bakara?” ");
INSERT INTO mva_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kodeka ditagurakito be Iesus bokai ditegi, “Bakara ka tamoata Moses Mata ne disulesuletaki dipile Ilaiza masa ngapura mua noko?” ");
INSERT INTO mva_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Be Iesus ikatu be bokai ipile, “Moimoi tamoata teke Ilaiza bokana ngapura mua be kana moarunga ngamoataungaki kana. Ata bokai kamakaua: Nanaranga ‘Buku’ nena-lo bokai digere, ‘Tamoata Natu masa sururu bibia-tina ngadoki be dasegeaki!’ ");
INSERT INTO mva_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ata ngau ka ura-kaming! Tamoata teke Ilaiza bokana ambe ipura-doi. Ata tagona-tina diadoraki. Be kana moarunga rerengadia-lo dabasaki kana be rangakadi Nanaranga ‘Buku’ nena-lo geretadi dipura nge ambe diemaki-doini.” ");
INSERT INTO mva_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Dilako-to be tagataga takadi dipurakadi nge tamoata dum biabia teke makara isoaki. Tamoata Moses Mata ne disulesuletaki alu ambe Iesus tagataga ne makara disoaki zaiza diegoregore. ");
INSERT INTO mva_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Be bong tamoata be aine moarunga Iesus dite nge dimakaraia-tina be dipanana be dimolataki. ");
INSERT INTO mva_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kodeka Iesus tagataga ne itegidi, “Rakana kaegoregoretaki?” ");
INSERT INTO mva_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ata tamoata teke moarunga maradi ka bokai ipile, “‘Tisa!’ Natugu mariaba goalaka ilona-lo isoaki ka kaiko-lo ueluaki. Mariaba goalaka ngae ka iemaki be pile ibebe. ");
INSERT INTO mva_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Bong mariaba goalaka ngae natugu ngaduamatei nge kateka-o ngarokakaria be natu ngae busobuso aoa-nalo dapusika, be ile ngakaraposaposa be kania moarunga nge dakaiboang-doi. Tagataga nem uradi be mariaba goalaka ngae dataoni kana, ata tago diboadu.” ");
INSERT INTO mva_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Be Iesus ikatu be bokai iradi, “Kam tamoata be aine kaituka kasoaki, lama tagona-tina kauni! Masa uanana salagatikadi baituka maka-la sakeming msukoaki? Ambe ilogu iakataki-kaming-tina! Aira-tina be masa kamakaua? Natu moane ngara makare ngau-lo kamadokamai!” ");
INSERT INTO mva_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kodeka natu moane ngae nge Iesus-lo didokamai. Be bong mariaba goalaka ngae Iesus ite nge natu ngae ilona-lo ka ipataraki-ramo be natu ngae kateka-o irokakaria. Be makara kateka-o ieno be itaputapu, be busobuso aoa-nalo dipusika. ");
INSERT INTO mva_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Kodeka Iesus natu ngae tama itegi, “Ambe bong ira kana ngaedi bokainatuka dipurani?” Be kamoang ikatu be bokai ipile, “Bong isi natu mukuna-tina be. ");
INSERT INTO mva_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Bong kokoko-tina mariaba goalaka ngae eoa-lo be dang-lo irokarokakalako be ngaumoatei kana. Ata kaiko kuboadu be kana teke goemaki kana nge ilom ngataga-kama be goduma-kama!” ");
INSERT INTO mva_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Be Iesus tamoata ngae bokai irai, “Bakara ka bokai kutegi, ‘Kaiko kuboadu?’ Tamoata naita lama iuni nge Nanaranga iboadu-tina kana moarunga tamoata bokainaina ngaemakini!” ");
INSERT INTO mva_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iesus bokai ipile nge natu moane ngae tama oaikiki-la bokai ipile, “Ngau lama uni, ata lama uniangagu isi tago dikai! Kaiko godumaia be lama unianga-gu dakai!” ");
INSERT INTO mva_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesus kaba bokai ita lili-kokoko-tina ambe dimai be kaba daita kana. Bokaibe mariaba goalaka nge bokai irai, “Kaiko mariaba goalakam aoa onono be kungi onono, ngau uraiko, natu ngaena-lo gopusika! Be kaba moaki ilona-lo kusili.” ");
INSERT INTO mva_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kodeka mariaba goalaka nge kaikai-tina imere be natu ngae kaikai-la ireresabungaki be kodeka ilona-lo ipusika be iratu. Be natu ngae makara mate bokana ieno nge tamoata kokoko bokai dipile, “Ambe imate.” ");
INSERT INTO mva_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ata Iesus natu ngae luma-nao idoki be idokiteteki be ituirake. ");
INSERT INTO mva_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesus pera-lo isili nge tagataga ne bokai ditegi, “Bakara ka keka tago kiboadu mariaba goalaka ngae gataoni?” ");
INSERT INTO mva_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Be Iesus ikatu be bokai iradi, “Rabo-la ka iboadu mariaba goalakadi ngataodi. Kana takaia tago iboadu.” ");
INSERT INTO mva_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Iesus tagataga ne zaiza anua ngara dipereki be dialale be Galili kaba-lo dilako. Iesus tago irere tamoata teke soakinga ngakauataki, ");
INSERT INTO mva_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bakara ngai tagataga ne isulesuledi. Bong isulesuledi nge bokai iradi, “Tamoata Natu masa tamoata luma-dio nangaia ngapura, be masa dataguraki be daumoatei. Ata amaridi toli muridi be masa kaba ngamarang.” ");
INSERT INTO mva_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ata di pile ngaedi labudi tago dikauataki. Dategi kana nge taburidi dira. ");
INSERT INTO mva_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kodeka dialalale nibe Kaperneam anua-lo dipusika. Pera-lo disili nge Iesus tagataga ne itegidi, “Zala-lo nge rakana kata kaegoregoretaki?” ");
INSERT INTO mva_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ata di dimoadubulaeba. Maka ma bong zala-lo dialalale nge diegoregore naita ka ara biabiatuka. ");
INSERT INTO mva_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Makara be Iesus isoakiria be tagataga ne kulemoa-be-rua ikiladi sakenao be bokai iradi, “Tamoata naita ngamuatuka kana nge nena-la ngabalaki be ngalaurituka, be tamoata moarunga malipilipi kandi ngapura.” ");
INSERT INTO mva_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kodeka itaguraki be natu-muku teke idoki be maradi ituiraki. Be lumana-lo iboabuni be bokai ipile, ");
INSERT INTO mva_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tamoata naita aragu-o be natu-muku bokainaina idoki be iadoraki nge ngau ka idoka be iadoraka. Be tamoata naita ngau idoka be iadoraka nge ngau nepinepi negu ka iadoaraki.” ");
INSERT INTO mva_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Kodeka Zon itaguraki be Iesus bokai irai, “‘Tisa,’ keka tamoata teke kite aram-o be mariaba goalakadi itaotaodi. Ata ngai tago kita kata. Bokaibe kibabari.” ");
INSERT INTO mva_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Be Iesus bokai ipile, “Moaki kababari. Tamoata naita araguo be kilala kaiboangdi iememaki nge tago iboadu oaikiki-la be pile goalakadi oti be ngarangaka. ");
INSERT INTO mva_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tamoata naita tago ierekei-kita nge iruangam-kita. ");
INSERT INTO mva_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Moimoi ka ura-kaming! Tamoata teke ite-kaming be bokai ipile, ‘Ngau Kristus tamoata ne ngaradi mdumadi kana,’ be araguo be dang sema teke iang-kaming nge zazanga ne tagona-tina iboadu daleua. ");
INSERT INTO mva_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tamoata naita itaguraki be natu-muku ngau lama iunana iemaki be muzigoala iemaki, nge iuia-tina patu kanabiabia teke dudu-nalo tukuia ngapura be makasi-lo rokakalako ngapura! ");
INSERT INTO mva_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Bokaibe lumam taka ka iemakiko be muzigoala kuemaki nge gototoki be gorokaki. Lumam tekena-la be moauriuri-la soaki-lo kulako nge iuia. Lumam ruoti dieno be eoa tago matemate-lo kulako nge tagona-tina iuia!  ");
INSERT INTO mva_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kaba ngaedia-lo nge moatamoata mukumukudi tago matemate nge bokaina-la tamoata odio disukoaki. Be makara nge eoa bokaina-la dikarakara. ");
INSERT INTO mva_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Aem taka ka iemakiko be muzigoala kuemaki nge gototoki be gorokaki. Aem tekena-la be moauriuri-la soaki-lo kulako nge iuia. Aem ruoti-doi dieno be eoa tago matemate-lo rokakam-lako ipura nge tagona-tina iuia!  ");
INSERT INTO mva_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Makara nge moatamoata mukumukudi tago matemate nge bokaina-la tamoata odio disukoaki. Be makara nge eoa bokaina-la dikarakara. ");
INSERT INTO mva_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Matam takaia ka iemakiko be muzigoala kuemaki nge gopasiki be gorokaki. Matam tekena-la ieno be bong ono Nanaranga ngatanepoa kanana-lo kusili nge iuia. Matam ruoti dieno be eoa tago matemate-lo rokakam-lako ipura nge tagona-tina iuia! ");
INSERT INTO mva_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Makara nge ‘moatamoata mukumukudi tago matemate nge bokaina-la tamoata odio disukoaki. Be makara nge eoa bokaina-la dikarakara.’ ");
INSERT INTO mva_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Eoa masa tamoata moarunga-lo ngalako be tamoata be aine moarunga ilodia-lo muzigoala damoamoapoato be makasi kana moarunga idoki-kaikaidi be enongadi disalagalaga bokana ilodi dagoaza. ");
INSERT INTO mva_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Makasi nge kana iauia, ata bong kapisanga daleua masa baituka tabasaki be kababe kapisanga tamuleaki? Makasi iloming-lo ngaeno masa tarito-kaming zaiza ilo-uia-lo be kamasukoaki-budu.” ");
INSERT INTO mva_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kodeka Iesus kaba ngaradi ipereki be Zudea kaba-lo ilako be Zodan zagura itotoki be ege takaianao ilako. Makara nge tamoata be aine kokoko-tina dipura. Kodeka itaguraki be isuledi izamaizama imuzimuzi bokana. ");
INSERT INTO mva_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Isulesuledi nge Parasi alu Iesus datoi kana be dipura be bokai ditegi, “Mata neda disumoala ki tago tamoata teke iboadu roa ngasegeaki?” ");
INSERT INTO mva_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ata Iesus tegitegi ane be bokai ikatudi, “Moses mata baituka iang-kaming?” ");
INSERT INTO mva_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Be di bokai dikatu, “Moses isumoala moane teke iboadu ‘pepa’ ono aine segeaka teke ngagereti be aine ngani be nganepi be ngalale.” ");
INSERT INTO mva_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ata Iesus bokai iradi, “Pangana-ming dipatungaki be raia-ming dira ka Moses mata ngae igereta-kaming. ");
INSERT INTO mva_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ata matamatana-tina bong lang be kateka be kana moarunga emakadi dipura nge ‘Nanaranga moane be aine iemaki-diaru. ");
INSERT INTO mva_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Labu ngaenao ka moane tina be tama ngaperekidi be roa diaru dataga-buduru ");
INSERT INTO mva_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","be tamoata teke dapura-ru.’ Bokaibe diaru ambe tago tamoata rua. Tago. Diaru ambe tamoata teke. ");
INSERT INTO mva_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bokaibe kana Nanaranga iuau-tekenanadi nge tamoata tago teke iboadu ngaduaramoaki.” ");
INSERT INTO mva_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Alauri pera-lo dimulelako nge Iesus tagataga ne pile ngaedi ditegiaki. ");
INSERT INTO mva_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Be Iesus ikatu be bokai iradi, “Tamoata naita roa isegeaki be aine takaia iuati nge moane ka aine ngae roti igamanale be aine takaia diaru dieno-buduru. ");
INSERT INTO mva_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Bokainatuka-la, aine nangata roa isegeaki be moane takaia iuati nge aine ngae ka roti igamani be moane takaia diaru dieno-buduru.” ");
INSERT INTO mva_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Makara nge tamoata alu natu-muku dieluakidi be Iesus luma odio nganangaria kana. Ata tagataga ne ditaguraki be diebulodi. ");
INSERT INTO mva_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesus kaba bokai ita nge tagataga ne ilo iratakidi be bokai iradi, “Natu-muku kamalikitakidi be ngau-lo damai. Moaki zalakadi kaono. Maka ma bong ono Nanaranga ngatanepoa kana nge tamoata muzingadi natu-muku bokana nge nedi. ");
INSERT INTO mva_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Moimoi ka ura-kaming! Tamoata naita bong ono Nanaranga ngatanepoa kana tago natu-muku bokana be idoki nge tagona-tina iboadu makara ngalako.” ");
INSERT INTO mva_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kodeka natu-muku iboabungdi be luma odio inangaria be imaroudi. ");
INSERT INTO mva_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesus ambe ialalale nge tamoata teke ipananamai be aro tuku-nao irokazokuria be itegi, “‘Tisa’ iauia, rakana memaki be masa moauriuri-la nem-kusoaki soaki ipurapura nge mdoki be mnemi?” ");
INSERT INTO mva_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Be Iesus ikatu be bokai irai, “Bakara ka iauia kana kukilaia? Tamoata tago teke iauia! Nanaranga-la ka rube iauia! ");
INSERT INTO mva_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kaiko Nanaranga mata ne kukauataki. Mata-ma ne ngaedia-re: ‘Tamoata takaia moaki kumoatei. Roti moaki kugamani be aine takaia kamru kaeno-buduru. Moaki kuianako. Tamoata takaia moaki kuboliaki. Moaki kuboli-ba be tamoata takaia kana ne kudoki-le. Tamam be tinam gomuamuakidi.’” ");
INSERT INTO mva_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Be tamoata ngae ikatu be bokai ipile, “‘Tisa,’ ngau isi natu-tina be mata ngaedi utagatagadi.” ");
INSERT INTO mva_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesus adoado-tina tamoata ngae idedei nge ireretaki be bokai irai, “Kana-la tekena-lo ka isi kutukura. Goalale be kana nem moarunga ‘mone’ odio godoki, be ‘mone’ ngaedi godoki be tamoata kana nedi tagotago goandi. Bokai masa Nanaranga kana uia-tina lang anua-lo ngangko be kana nem dakoko-tina. Kana ngaedi goemaki-doi, kodeka gomai be gotagaia.” ");
INSERT INTO mva_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tamoata ngae nge kana ne kokoko-tina. Bokaibe bong pile ngaedi ilongo nge ilo ibuku-tina be lili itaongaki be ialale. ");
INSERT INTO mva_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kodeka Iesus igea-ramo be tagataga ne itedi be bokai iradi, “Tamoata kana nedi kokoko masa anua ono Nanaranga ngatanepoa kanana-lo lako daradia-tina.” ");
INSERT INTO mva_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tagataga ne pile ngaedi dilongo nge dipitilaki-tina be ilodi lelenakadi dira. Ata Iesus kaba bokai iradi, “Natu-gu negu, bong ono Nanaranga ngatanepoa kanana-lo nge sili dara-tina kana! ");
INSERT INTO mva_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","‘Kamel’ lili kusi-kalaura boazinga-nalo ngasili kana masa sili tagona-tina darai. Ata tamoata kana ne kokoko anua ono Nanaranga ngatanepoa kanana-lo ngasili kana masa sili daraia-tina!” ");
INSERT INTO mva_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iesus bokai ipile nge tagataga ne kodeka dipitilaki-tina be nedia-la bokai dietegi, “Bokai nge alauri masa Nanaranga naita ngauketi be ngamuleaki?” ");
INSERT INTO mva_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kodeka Iesus adoado-tina idededi be bokai iradi, “Moimoi tamoata tago diboadu kana ngae daemaki, ata Nanaranga-lo nge kanaba. Maka ma Nanaranga iboadu-tina kana moarunga ngaemaki.” ");
INSERT INTO mva_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Be Pita itaguraki be Iesus bokai irai, “Gote! Keka kana nema moarunga kipereki be kitagaiko.” ");
INSERT INTO mva_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Be Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming! Tamoata naita ngau be Pile Uia ngae kanabe pera kana, ki taritoka, ki marau, ki tina, ki tama, ki natu, ki uma ne ipereki ");
INSERT INTO mva_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","masa zazanga ne kana-tina-bibia ngadoki kaituka bong ngaedia-lo. (Masa pera kana, taritoka, marau, tina, natu be uma ne kokoko-tina ngadoki. Ata masa sururu bibia-tina ngaita noko kana bokainaina ngadoki.) Be bong alalauri-lo masa moauriuri-la nem-kusoaki ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ata tamoata kokoko-tina dimuamua masa dalauri, be alalauri masa damua.” ");
INSERT INTO mva_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iesus tagataga ne zaiza nge ambe dialale be Ierusalem dalako kana. Be Iesus nge imuatuka. Tagataga ne muri ditagatagai kaba bokai dita nge dipitilaki-tina be ilodi lelenakadi dira. Tamoata be aine muridi ditagatagadi nge taburidi dira-tina. Kodeka tagataga ne kulemoa-be-rua nge kababe laua-o ilakuakidi be kana dapurani kana nge irangakidi. ");
INSERT INTO mva_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Bokai iradi, “Kamalongo! Ambe Ierusalem talakolako. Makara masa Tamoata Natu dadoki be tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki luma-dio danangai. Be di ka matea dasumoalataki be dadoki be Ungguma Takadi luma-dio danangai. ");
INSERT INTO mva_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Be Ungguma Takadi masa ono dasaoi, damoangori be darautotoki be daumoatei. Ata amaridi toli muridi masa kababe ngamarang.” ");
INSERT INTO mva_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kodeka Zebidi natu ruoti Zems be Zon dimairu be Iesus bokai diraiaru, “‘Tisa,’ kana teke goemaka-kamairu kana kirere-ru!” ");
INSERT INTO mva_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Be Iesus itegi-diaru, “Rakana-tina memaka-kamingru kana karereru?” ");
INSERT INTO mva_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Be diaru dikaturu be bokai dipileru, “Gosumoala be bong kaiboang be malama nem-lo kusoaki nge keru takaia oanam-o ngasoaki be takaia ngasim-o ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Makara nge Iesus bokai ipile, “Kamru tago kakauaru rakana ka kasinautakiaru! Kamru kaboaduru sema ngau ono dang msing kanana-lo dang kamasingru? Be kamru kaboaduru sururu bibia ono ngau rukuiagu be tamalagu ngapura kana nge kamadokiru?” ");
INSERT INTO mva_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Be diaru dikaturu be dipileru, “Keru kiboaduru!” Makara nge Iesus bokai ira-diaru, “Moimoi sema ngau ono dang msing kanana-lo masa dang kamasingru. Be sururu bibia ono rukuiagu ngapura kana masa kamadokiru. ");
INSERT INTO mva_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ata naita oanagu-o ki ngasigu-o ngasoaki kana nge ngau tago uboadu msumoalataki. Maka ma Nanaranga ambe tamoata ne idokidi be inangadi nge kaba ngaradi imoataungakidi be inem-ngakidi be dieno.” ");
INSERT INTO mva_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tagataga ne kulemoa takadi bokai dilongo nge Zems be Zon namadi diratakidi. ");
INSERT INTO mva_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kodeka Iesus ikiladia-doi saringa be bokai iradi, “Kam kakaua Ungguma Takadi nge anuatanepoa kandi ka atabaladi disoaki be dipapananuakidi. Be tamoata aradi bibia nge kaiboang nedi ane be rerengadia-lo gadagada diraradi be ba dibabasakidi be ono gadagada dikauakaua tamoata nedi bibia nge kaiboang nedi otioti. ");
INSERT INTO mva_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ata kam moaki di bokana. Tamoata naita biabiadi neming ngapura kana nge kam malipilipi kana-ming ngapura. ");
INSERT INTO mva_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Be tamoata naita ngamuatuka-kaming kana nge tamoata moarunga dududu kandi ngapura. ");
INSERT INTO mva_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Bakara, Tamoata Natu nge bokainaina. Ngai tago damalipini kana ka ipura. Tago! Ngai ngamalipidi kana ka ipura. Be masa di kanabe ngamate be ono kokoko-tina ngazazadi be ngamuleakidi.” ");
INSERT INTO mva_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Makara be dialale be Zeriko anua-lo dipura. Iesus nge ambe tagataga ne be tamoata be aine dum teke zaiza be anua diperepereki nge tamoata teke mata leuadi zala zagena-o isoaki be dipurakani. Makara zala zagena-o isoaki be isinaunau. Tamoata ngae ara Batimeas, be ngai nge Timieas natu. ");
INSERT INTO mva_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bokaibe bong ilongo Nasaret tamoata Iesus ka makara ialalale nge imere be bokai ipile, “Iesus, Debiti Natu! Ilom ngatagaia!” ");
INSERT INTO mva_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ata tamoata kokoko diebuloni be bokai dirai, “Aoam gonoti!” Ata ngai kodeka ipi-tina be ikilau, “Debiti Natu! Ilom ngatagaia!” ");
INSERT INTO mva_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kodeka Iesus itui be bokai ipile, “Maka kamakilamai!” Bokaibe mata-leua ngae dikilai be bokai dirai, “Surim dauia. Gotuirake! Ambe ikelikeliakiko!” ");
INSERT INTO mva_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tamoata ngae bokai ilongo nge kusi-sili ne inanganangai nge irokaki be oaikiki-la ituirake be Iesus-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kodeka Iesus itaguraki be tamoata ngae bokai itegi, “Rakana memakamko kana kurere?” Be tamoata ngae ikatu be ipile, “‘Tisa,’ ngau kaba mitaita kana urere!” ");
INSERT INTO mva_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Kodeka Iesus bokai irai, “Goalale! Lama uniangam ka iemakiko be kuia!” Makara nge oaikiki-tina tamoata ngae mata diuia be kaba itaita, be itaguraki be Iesus itagai zala ngarana-lo. ");
INSERT INTO mva_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bong ambe Ierusalem disaringaringai nge anua rua ara-diaru Betpeiz be Betani-lo dipura. Makara be dilako Olib buku-nao. Kodeka Iesus tagataga ne rua inepi-diaru be damuaru kana. ");
INSERT INTO mva_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Dalaleru kana nge bokai ira-diaru, “Anua ene aro-mingru ieno kanana-lo kamalakoru. Kasilisiliru masa ‘dongki’ natu teke makara ditukui nge kamatearu. Tamoata tago teke isi ono ibuli be ialaleaki. Kamarubetakiaru be makare kamadoka-mairu. ");
INSERT INTO mva_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Teke itegi-kamingru, ‘Bakara ka bokai kamuzimuziru?’ nge kamaraiaru, ‘Tisa’ malipi ne ono dieno. Masa oaikiki-la be ngamuleaki.’” ");
INSERT INTO mva_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kodeka tagataga rua nge dialaleru. Dilakopuraru nge ‘dongki’ natu teke eluku zala bibia-lo tukuia ipura nge ditearu. ‘Dongki’ ngae nge pera teke babaduadua-nalo ka ditukui be ituitui. Diruberubetiaru nge ");
INSERT INTO mva_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tamoata alu zala-lo dituitui bokai ditegi, “Nge rakana kaememakiaru? Bakara ka ‘dongki’ ngara karuberubetiaru?” ");
INSERT INTO mva_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Be diaru Iesus-la ira-diaru bokana pilengadi dikatu. Bokaibe tamoata ngaedi nge dilikitaki-diaru be ‘dongki’ dibagaiaru be dialaleru. ");
INSERT INTO mva_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","‘Dongki’ ngae Iesus-lo dilakuakiaru, kodeka kusi-sili nediaru dipasiru be ‘dongki’ ono dinangariaru be Iesus ikautaki be odio isoaki. ");
INSERT INTO mva_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Be tamoata be aine kokoko-tina kusi nedi zala-lo diulalakiria. Be alu kai sapara singaba-lo ditoto nge diulalaki. ");
INSERT INTO mva_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kodeka alu dimua be alu dialauri nge ditaguraki be dimeremere be bokai dipilepile, “Nanaranga tarakeaki! Tamoata naita Tanepoa ara-nao be ipura masa marou ngadoki! (Sam 118:26) ");
INSERT INTO mva_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tubuda Debiti tanepoanga ambe dapura kana nge Nanaranga iboadu marou ngandi! Nanaranga tarakeaki be atabala-tina tanangai!” ");
INSERT INTO mva_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesus Ierusalem-lo ipura nge ilako-sosoa be Nanaranga pera nena-lo isili be kana moarunga ililiti. Ata ambe irairai-tina bokana tagataga ne kulemoa-be-rua zaiza be Betani anua-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Izama be Betani anua dipereki be dialalale nge Iesus tole imate-tina. ");
INSERT INTO mva_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Makara nge kai teke kalingo kangkang ara ‘pig’ kasau-lo dau italako, be taona itao be kalingo ngaita be ngakang kana. Ata isi tago bong ono nainga nedi. Bokaibe ilako nge kalingo tago. Daunaba ita. ");
INSERT INTO mva_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kodeka Iesus kai ngae bokainatuka irai, “Alauri masa tagona-tina teke iboadu kalingom teke ngakang!” Bokai ipile nge tagataga ne dilongo. ");
INSERT INTO mva_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ierusalem-lo dilakopura nge Iesus ilako-sosoa Nanaranga pera nena-lo. Be tamoata makara pera zage-o ditabulibuli be kana dizazaza nge itaodi. Tamoata ‘mone’ dibubuiri nge bagi nedi ibagabuiri. Be tamoata bune dinegenege be tamoata takadi dizazaza nge bagi nedi ono soakinga isuburaki. ");
INSERT INTO mva_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Be babari bibia inanga be tamoata tago teke iboadu kana ne ono tabulinga ngabazidi be Nanaranga pera nena-lo ngasiliaki. ");
INSERT INTO mva_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kodeka makara be isuledi. Isulesuledi nge bokai iradi, “Nanaranga ‘Buku’ nena-lo bokai ipile, ‘Pera negu masa ungguma moarunga ono rabonga nedi kana rangaka ngapura.’ (Ais 56:7) Ata kam ambe anako ono komanga nedi bokana kabasaki!” ");
INSERT INTO mva_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki nge zala dilelei be ono Iesus daumoatei kana. Di nge ambe Iesus dimatakuri, bakara tamoata be aine moarunga sulenga dilongolongo nge dikabakabakia-tina. ");
INSERT INTO mva_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ambe irairai nge Iesus tagataga ne zaiza Ierusalem dipereki be dialale. ");
INSERT INTO mva_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Izama be dialale be dilako nge kai ara ‘pig’ nora Iesus ingesuaki nge dite. Marango nge sakurina-lo be dibala be zirina-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Makara nge Pita ilo ikauani be itaguraki be Iesus bokai irai, “‘Tisa!’ Gote! Kai kungesuaki ambe imarango!” ");
INSERT INTO mva_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Be Iesus ikatu be bokai ipile, “Nanaranga lama kamaunani! ");
INSERT INTO mva_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Moimoina-tina ka ura-kaming! Iboadu-tina tekem buku ngae bokai gorai, ‘Nem-la godokiko be makasi-lo gorokakikolako.’ Bokai ipile be ilona-lo be ilo tago iruani, be ne pilenga lama iungdi be kana ngapurani kana irere nge masa emakani ngapura! ");
INSERT INTO mva_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nge bokai ka ngau bokai ura-kaming: Kana teke kareretaki be Nanaranga karaboi be moimoi be lama kauni kamadoki kana nge kamadokia-la be kana! Rakana kareretaki be rabo-lo be kasinau nge Nanaranga ngang-kaming kana, ata lama kamaunia-ba mua, suri kana kareretaki nge ambe kadokia-doi bokana. ");
INSERT INTO mva_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Be bong katui be karaborabo be tamoata kata giriki ne teke kam-lo ieno nge giriki ne ngae kamarokaka-le! Bokai masa Tama-ming lang anua-lo isoaki muzigoala neming ngarokakile-kaming.  ");
INSERT INTO mva_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bokainatuka-la, tamoata takadi muzigoala nedi tago karokakiledi masa Tama-ming lang anua-lo isoaki muzigoala neming tago ngarokakile-kaming.” ");
INSERT INTO mva_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Kaba Ierusalem-lo dimule nge Iesus ilako be Nanaranga pera nena-lo ialalale. Bokai ialalale nge tamoata Nanaranga ditabatabai dimuamuadi, tamoata Moses Mata ne disulesuletaki be Iuda tamoata nedi bibia alu dipurakani. ");
INSERT INTO mva_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Be bokai ditegi, “Kaiboang nangatadi-o ka bokai kumuzimuzi? Naita kaiboang iangko ka bokai kumuzimuzi?” ");
INSERT INTO mva_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Be Iesus pilengadi ikatu be bokai iradi, “Ngau tegi teke mtegi-kaming, be kakatu uiana masa mra-kaming kaiboang nangatadi-o ka kana ngaedi uememaki. ");
INSERT INTO mva_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kamaraia! Ruku ono tamalinga Zon tamoata be aine ono irukudi nge kaiboang nedi inanga ka dipura? Lang anua-lo ka dipura ki tamoata-lo ka dipura?” ");
INSERT INTO mva_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Makara nge nedia-la bokai dietegi, “Masa baituka tapile? Lang anua-lo kana tapile masa bokai ngara-kita, ‘Nge bakara ka lama tago kaunani?’ ");
INSERT INTO mva_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tamoata-lo kana tapile...!” (Tamoata be aine dimatakuridi, bakara, di dipile Zon nge moimoina-tina ‘propet’ kata.) ");
INSERT INTO mva_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bokaibe bokai dirai, “Tago kikaua.” Kodeka Iesus itaguraki be bokai iradi, “E, ngau bokai! Tago iboadu mra-kaming kaiboang ono kana ngaedi uememaki nge inanga ka udoki!” ");
INSERT INTO mva_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kodeka makara be Iesus itaguraki be pile ono tonanga-la ane be iraradi, “Tamoata teke uma tekena-lo ‘uain’ ipuruki be iaringi. Uma ilona-lo nge kaba ono ‘uain’ kalingo pisaka ipurapura nge tekedi iemaki. Be bazarua rakebuli teke ono tamoata narinari dasukoaki kana nge teke ikeli. Kana ngaedi iemaki-doi, kodeka tamoata alu uma ngae iandi be damalipilipitaki be danarinaringi kana. Be ngai itui be kasau kaba tekedia-lo ilako. ");
INSERT INTO mva_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ambe ‘uain’ patudi dinoka nge uma marau malipilipi kana teke inepi be ialale be ‘uain’ kalingodi kana alu ngabagani kana. ");
INSERT INTO mva_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ata bong uma-marau malipilipi kana ilako nge tamoata uma dimalipilipitaki nge ditaguraki be didokitagaki be dipaliti be kababe kalingona-ba dinepi be imule. ");
INSERT INTO mva_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kabana-ma ka uma marau malipilipi kana takaia inepi be ilako. Ilako nge uma malipilipitaki ditaguraki nge pangana-nao diuni be maia mata-lo dibasaki. ");
INSERT INTO mva_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kabana-ma ka malipilipi taka inepi. Ngaeni nge kodeka diumoatei. Kokoko-ramoia inepinepidi be dilakolako. Alu diumoatedi be alu dipalitidia-ramoba. ");
INSERT INTO mva_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Kodeka alaurituka nge tamoata tekena-la isoaki. Ambe ne natu irereretakia-tina-la ka isoaki bokana inepi. Uma-marau ne ilona-lo nge bokai ipile, ‘Natu-gu masa damuaki.’ ");
INSERT INTO mva_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ata bong uma-marau natu ngae ilakopura be dite nge bokai dipile, ‘Nge natuna-tina ka maka! Aria! Taumoatei! Ngai ka alauri tama kana ne moarunga ngadoki be nganemdi kana! Taumoatei masa alauri kana ne moarunga neda tadoki.’ ");
INSERT INTO mva_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kodeka ditaguraki be diumoatei be eluku ‘uain’ uma muri dirokakalako.” ");
INSERT INTO mva_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kodeka Iesus itaguraki be bokai itegi, “Ilo-ming ba dipile? Uma-marau masa rakana ngaemaki? Ngai masa ngalako be tamoata uma dimalipilipitaki ngaedi nge ngaumoatedi be ‘uain’ uma ngae ngadoki be tamoata takadi ngandi be damalipilipitaki be danarinaringi. ");
INSERT INTO mva_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kam ambe Nanaranga pilenga ngaedi kaleze be kakauataki! Nanaranga bokai ipile, ‘Ariri maka pera kelikeli disegeaki ka pera kaiboang ne. ");
INSERT INTO mva_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tanepoa ka kana ngae iemaki! Tea nge diuia-tina!’” ");
INSERT INTO mva_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iuda tamoata bibia nedi pile ono tonanga ngaedi dilongo nge dikaua nge di ka Iesus odio itonanga. Bokaibe zala dilelei be ono Iesus uaura-lo danangai kana. Ata tamoata be aine moarunga dimatakuridi. Bokaibe dipereki be dialale. ");
INSERT INTO mva_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Alauri nge Parasi alu be Erot tamoata ne alu dinepidi be Iesus ne pilenga datagadiani be datoi kana be dipura. ");
INSERT INTO mva_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kodeka dilako be Iesus bokai ditegi, “‘Tisa!’ Keka kikaua kaiko pile kalingodia-la ka kupilepile. Kaiko tago oasa bagaiam kata be masa tamoata-la teke pilenga gotagatagadi. Tamoata bakarairai kaoa nge kaiko tagona-tina kuilo-bukubukutakidi. Ata pile kalingodi ane be Nanaranga mata ne kusulesuletaki. Gora-kama! Mata neda disumoala ki tago, iboadu Rom ‘Sisa’ nedi ‘tagisi’ taniani? ");
INSERT INTO mva_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","‘Tagisi’ tazazazai ki moaki tazazazai?” Ata Iesus ambe pile ono bolinga nedi ngaedi ikauataki. Bokaibe bokai iradi, “Bakara ka kabolebolesa be tegi neming katunga mpakai be kama-uaura kana? ‘Mone siliua’ teke kamaeluaki be mte.” ");
INSERT INTO mva_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kodeka ‘mone siliua’ teke dieluakani be itegidi, “Nge naita anunuka be ara ka maka ‘mone’o dieno?” Be di dikatu be dipile, “‘Sisa’.” ");
INSERT INTO mva_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Be Iesus bokai iradi, “Bokai nge ‘Sisa’ kana ne nge ‘Sisa’ kamaniani, be Nanaranga kana ne nge Nanaranga kamaniani.” Iesus pilenga ngaedi dilongo nge dipitilaki-tina. (Ilodi dipile ngai tago iboadu tegi nedi ngae nge ngakatungia-uia.) ");
INSERT INTO mva_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Kodeka Sadiusi alu dipura be Iesus dategi kana. Di sulengadia-lo nge dipile matemate tago iboadu damarang. Bokaibe Iesus bokai ditegi, ");
INSERT INTO mva_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“‘Tisa!’ Moses bokai igere-kita: Tamoata teke iroti be natu tagona-la teke ipura be imate nge tari ngataguraki be toka nare ngauati be toka imate nge natu ngapurakidiani. ");
INSERT INTO mva_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Taritokatoka lima-rua disoaki. Labalabatuka aine teke iuati, ata natu tago-la be imate. ");
INSERT INTO mva_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tari muri tagaia nge aine ngae iuati, ata natu tago teke dipurakiaru be moane imate. Taritokadi tolia nge bokai imuzi be. ");
INSERT INTO mva_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Diato lima-rua nge aine-doi teke diuatiato. Ata natu tago teke dipurakiato. Alaurituka nge aine imate. ");
INSERT INTO mva_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bong biabia alauri ngapura be tamoata matedi damarang kananao masa aine ngae naita roa? Maka ma taritokatoka ngaedi nge aine-doi ngae diuati.” ");
INSERT INTO mva_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Kodeka Iesus bokai iradi, “Pile ngaradi kapakadi! Maka ma Nanaranga ‘Buku’ ne labudi ki kaiboang ne tago kakauataki. ");
INSERT INTO mva_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Alauri matemate moarunga damarang masa ‘enzel’ lang anua-lonalona bokana dasukoaki. Tago masa darotiroti ki roti kana be eluakadi dapurapura. ");
INSERT INTO mva_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Kam kapile matemate tago iboadu damarang nge ngau bokai mra-kaming kana: Moses ‘Buku’ nena-lo egedi maka singaba ipurupururui, ata singaba tago ialololo nge kalezetaki be kakauataki ki tago? Makara nge Nanaranga Moses bokai irai, ‘Ngau Abaram Nanaranga ne, be Aisak Nanaranga ne, be Zekop Nanaranga ne.’ ");
INSERT INTO mva_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bokaibe ngai nge moauriuri-la sukoaki Nanaranga nedi. Tago matemate Nanaranga nedi. Bokaibe pilenga-ming ngaedi nge kapakadia-tina.” ");
INSERT INTO mva_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tamoata Moses Mata ne disulesuletaki nge teke bokai maradi isoaki be Iesus Sadiusi zaiza dipilepile be ilongo. Kaba bokai ita Iesus Sadiusi tegi nedi ikatungia-uia nge ilako be Iesus bokai itegi, “Nanaranga mata ne moarunga maradi nge nangata ka ara biabiatuka?” ");
INSERT INTO mva_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Be Iesus ikatu be bokai ipile, “Nanaranga mata ne ngae ka ara biabiatuka, ‘Israel! Kamalongo! Nanaranga neda Tanepoa ka rube Tanepoa! ");
INSERT INTO mva_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nanaranga nem Tanepoa nge ilom ere-moarungana-lo, mariabakam ere-moarungana-lo, ilo lelenaka nem ere-moarungana-lo, be kaiboang nem ere-moarungadia-lo be gorereretaki.’ ");
INSERT INTO mva_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ngae ruaia nge bokai: ‘Tamoata takaia gorereretaki nem-la kurereretakiko bokana.’ Mata takaia tago ieno mata ruoti ngae-diaru iuasadi. Mata-la rua ngaedi ka Nanaranga mata ne moarunga diuasadi.” ");
INSERT INTO mva_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kodeka tamoata ngae Iesus bokai irai, “‘Tisa!’ Kupile-tina uia! Tanepoa-la rube ka Nanaranga. Takaia tago. Ngaia-la rube! ");
INSERT INTO mva_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bokaibe tamoata moarunga nge ilodi ere-moarungadia-lo, ilo lelenaka nedi ere-moarungadia-lo be kaiboang nedi ere-moarungadia-lo be Nanaranga darereretaki. Be tamoata takadi darereretakidi nedia-la direreretaki bokana. Mata-la rua ngae-diaru ka ara-diaru bibiatuka. Ngado moamoapoatopoato be kana takadi tabataba bokana Nanaranga ania ipurapura nge kanaba. Mata rua ngaedi ka tabataba moarunga diuasadi.” ");
INSERT INTO mva_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesus tamoata ngae ilongori pile ikatu uia nge bokai irai, “Bong ono Nanaranga ngatanepoa kanana-lo nge tago kasau-tina ka kusoaki!” Makara be alauri nge tamoata tago teke kababe Iesus itegi. ");
INSERT INTO mva_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesus Nanaranga pera nena-lo isoaki be tamoata be aine isulesuledi nge bokai itegidi, “Tamoata Moses Mata ne disulesuletaki dipile Kristus nge Debiti natu! Nge masa baituka be bokai? ");
INSERT INTO mva_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Maka ma Debiti nena-la be Oli Spirit kaiboang nena-lo be mangata bokai ipile, ‘Nanaranga Tanepoa itaguraki be Tanepoa negu bokai irai: Makare kaba aradi bibiatuka oanagu-o gosoaki, nibe erekei nem mduaposakidi be ae salangaka nem bokana aem babadi erumadi mnangadi.’” ");
INSERT INTO mva_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Debiti nena-la be ne natu kaba Tanepoa kana ikilai. Nge masa baituka be Kristus kababe alauri Debiti labu-nao ngapura?” Tamoata be aine dum bibia makara isoaki Iesus pilenga dilongo nge direre-tina. ");
INSERT INTO mva_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesus tamoata be aine isulesuledi nge bokai ipile, “Tamoata Moses Mata ne disulesuletaki kamamatakuakidia-tina uia! Di masa dangazim uia be lili-be-matao dalalale. Be bong malala-lo dialalale nge direrere tamoata be aine takadi di damuamuakidi. ");
INSERT INTO mva_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pera ono serereinga-lo nge aro-tina-lo soaki direrere. Moanako bibia-lo nge kaba irakingadia-lo soaki direrere-tina. ");
INSERT INTO mva_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Narenare dibobolesidi be kana nedi pera kandia-lo nge didokidokiledi. Be ono-ba muzingadi goalakingadi dazumzumkaki kana nge rabo nedi diaka-sasalagati. Bokainaina masa suru bibia-tina dadoki!” ");
INSERT INTO mva_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesus makara ‘mone’ nangalakonga sakenao isoaki nge tamoata be aine dipurapura be ‘tagisi’ Nanaranga pera nena-lonalona nge dinanganangalako be itetedi. Tamoata kana nedi kokoko nge ‘mone’ kokoko-la be dinangalako. ");
INSERT INTO mva_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ata narenare teke kana ne tagotago ipura nge ‘mone’ mukumukudi daradaradi rua inangalako. ‘Mone’ ngae-diaru kaiboang nedi nge disiki-tina, ‘toea’ teke bokana. ");
INSERT INTO mva_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Kodeka Iesus tagataga ne ikiladi be bokai iradi, “Moimoi ka ura-kaming! Aine ngae ‘mone’ inangalako nge moarunga ‘mone’ nangangadi iuasadi. ");
INSERT INTO mva_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Di moarunga nge ‘mone’ nedi enobangadia-ba ka dinangalako. Egedi takadi nedi dieno. Ata narenare ngae ‘mone’ ne surikakadi ono kangkang zazanga dienoni ka inangalako. Moimoi kana ne tagotago-tina, ata ‘mone’ ne surikakadi ono ngasoaki kana nge ka inangalako.” ");
INSERT INTO mva_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesus ambe Nanaranga pera ne ipepereki nge tagataga ne teke Nanaranga pera ne kailo itunuri be bokai ipile, “‘Tisa!’ Goita! Pera kailo keliadi dileuakia-tina! Patu uarikadia-tina ane ka dikeli.” ");
INSERT INTO mva_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Be Iesus ikatu be bokai ipile, “Pera bibia moarunga maka kaita? Tago teke masa nena-la bokana ngatuitui. Patu ono keliadi dipura masa tago teke kabana-lo ngaeno. Moarunga masa gamanadi dapura be dagalalai!” ");
INSERT INTO mva_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Olib buku nge Nanaranga pera ne ege takaianao ka ieno. Bokaibe Iesus Nanaranga pera ne ipereki nge makara Olib buku-nao ilako. Makara isoaki be Pita, Zems, Zon be Endru rubediato dipurato be ditegiato, ");
INSERT INTO mva_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gorakama! Masa aira be kana ngaedi dapura? Masa rakana teke ngapura be ono kaua ngapura kana ngaedi ambe emakadi dapura be dakalingo kana?” ");
INSERT INTO mva_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Be Iesus ikatu be bokai iradi, “Kaba kamaitaita uia! Tamoata teke ngabolesi-kaming takana! ");
INSERT INTO mva_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tamoata kokoko masa aragu-o daboli be dapura be masa bokai dapile, ‘Ngau ka ngai.’ Be masa tamoata kokoko-tina dabolesidi be dabaga-uiadi. ");
INSERT INTO mva_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Koai bibia masa kamalolongori. Be alu masa rukudia-ba kamalongolongoraki. Ata moaki ilo-ming dibuku. Kana bokainaina masa dapura mua noko. Ata bong ono manubunga masa noko ngapura. ");
INSERT INTO mva_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ungguma alu masa dataguraki be ungguma takadi zaiza daeung. Anuatanepoa alu gadagada nedi zaiza masa dataguraki be anuatanepoa takadi gadagada nedi zaiza daundi. Rike masa ege-ege dapurapura. Tole bibia masa dapurapura. Kana ngaedi nge sururu matamatanatuka aine nganekineki be dapurani bokana kaoa. ");
INSERT INTO mva_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Kam neming-la kaba kamaitaita uia! Masa dauauri-kaming be giriki adoadoraki arodi datuiraki-kaming. Be pera ono serereinga-lo be rautotoki-kaming dapura. Ngau kanabe masa tamoata bibia aradi otioti be anuatanepoa arodi kamatui. Bokai masa kam mata-ita bokana be Pile Uia mangata kamarangakadi. ");
INSERT INTO mva_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ata Pile Uia ngae nge ungguma moarunga-lo rangaka ngapura noko bong on manubunga ngapura. ");
INSERT INTO mva_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bong diuauri-kaming be giriki adoadoraki arodi dituiraki-kaming nge moaki ilo-ming dibuku-ba mua masa bakara kamapile. Bong ngaradi-o be pile ania-ming dipura nge ramoramo kamapile-lako. Nge tago kam ka kamapile kana. Pile kamapile kana nge Oli Spirit ka ngang-kaming be kamapile kana. ");
INSERT INTO mva_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Tamoata alu masa taritokadia-tina dadoki be erekei luma-dio danangadi be masa daumoatedi. Be kamoang masa natudi bokai dabasakidi. Be natu masa dataguraki be tinadi be tamadi daerekeidi be dadokidi be tamoata takadi luma-dio danangadi be daumoatedi. ");
INSERT INTO mva_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tamoata moarunga masa ngau kanabe dasegeaki-kaming! Ata tamoata ikaiboang be isoaki-la nibe ilako manubunga-nao masa uketa ngapura.” ");
INSERT INTO mva_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kana goalakana-tina anua gagamang masa kaba tago ngatuitui kanana-lo ngatuitui be kamate.” Tamoata naita pile ngaedi ileze nge labudi ngakaua-tina uia. “Bong ngaradia-lo masa tamoata Zudea kaba-lo disoaki nge dairatu be buku kaba-lo dalako. ");
INSERT INTO mva_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tamoata pera kana aro isoaki nge moaki pera-lo isili be kana ne teke idoki. ");
INSERT INTO mva_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tamoata uma-lo isoaki nge moaki imule be kusi-sili ne ibagai. ");
INSERT INTO mva_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aine tinetine be aine isi natu diarururungdi nge dimakadoma-tina! ");
INSERT INTO mva_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nanaranga kamaraboi be kana ngaedi nge moaki aoara bong-lo dipura. ");
INSERT INTO mva_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sururu bong ngaedia-lonalona nge dalaba-tina kana. Toira Nanaranga lang be kateka iemaki be imai kaituka nge sururu bokainaina tago teke ipura. Sururu ngaedi dagoala-tina kana. Be alauri masa sururu bokainaina tago teke kababe ngapura. ");
INSERT INTO mva_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ata Tanepoa ambe amaridi salagatikadi ono kana goalakadi ngaedi dapura kana nge iaka-tukuradi. Tago ngaka-tukuradi bokana nge ambe tago teke moauriuri ngasoaki. Nanaranga ambe tamoata ne inangadi be idokidi be disoaki. Bokaibe di kanabe bong ngaedi iaka-tukuradi. ");
INSERT INTO mva_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bong ngaradia-lo be tamoata teke ira-kaming, ‘Kamate! Kristus makare isoaki’ ki ngapile ‘Kristus ene isoaki’ nge moakina-tina pilenga kalongo be lama kaunani. ");
INSERT INTO mva_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kristus bolingadi ratadi be ‘propet’ bolingadi ratadi masa dapura be Nanaranga tamoata ne inangadi be disoaki nge dabobolesidi. Masa kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki nge kokoko-tina daemaki be ono dabolesidi. Iboadu-tina dabolesidi be dabaga-uiadi, ata tago iboadu. ");
INSERT INTO mva_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaba kamaitaita-tina uia! Kana ngaedi isi tagona-la dipura be ngau urakaming-ba mua. ");
INSERT INTO mva_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bong goalakadi ngaedi muridi masa ‘amari ngaoabubu be kalea masa tago ngamalamalama. ");
INSERT INTO mva_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Goai masa lang-lo be dasapasi be kaiboang moarunga makatabala lang-lo dieno nge damoakusu-ramo.’ (Ais 13:10; 34:4) ");
INSERT INTO mva_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kodeka bong ngaradia-lo masa tamoata be aine moarunga Tamoata Natu ngapurapura be date. Masa oaru-o ngasoaki be ngapura. Be masa kaiboang ne ono tanepoanga, be kaiboang be malama ne zaiza be ngapura. ");
INSERT INTO mva_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Be masa ‘enzel’ ne nganepidi be kateka ege oati-lo dalako be tamoata ne ambe Nanaranga inangadi be disoaki nge dabagadi. Masa kateka ege takaianao be dabagabagadi nibe dalako ege takaianao darokasapangaki. ");
INSERT INTO mva_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Kai ara ‘pig’ kamate be ono tonanga kamadoki. Sapara dikarai be kauneunedi uia dipura nge ambe kamakaua kana nge amari bong ka dapura kana. ");
INSERT INTO mva_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Bokainatuka-la, alauri kaba bokai kaita nge ambe kamakaua kana ngaedi ambe disaringa be babaduadua kanaming-lo dieno. ");
INSERT INTO mva_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moimoi ka ura-kaming! Tamoata bong ngaedia-lonalona masa tagona-la damate be kana ngaedi dapura. ");
INSERT INTO mva_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Lang be kateka masa damanubu, ata pilengagu tagona-tina iboadu damanubu. ");
INSERT INTO mva_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tamoata tago teke bong ngae ki amari siriki ngae ikauataki. ‘Enzel’ lang anua-lo tago dikaua. Tamoata Natu tago ikaua. Tamagu-la ka ikaua. ");
INSERT INTO mva_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kamanarinari-tina uia be kamasukoaki. Kaba kamaitaita-tina uia! Bong ono kana ngaedi dapura kana nge tago kakaua. ");
INSERT INTO mva_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kana ngaedi nge tamoata teke pera kana ipereki be masaua-lo ilako bokana. Ngalale kana nge malipilipi kana inangadi be malipi kana daememakini kana. Malipi nge nem-nem be iandi be diememaki. Tamoata babaduadua inarinaringi nge irai be nganarinari-tina uia be kaba ngaitaita. ");
INSERT INTO mva_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bokaibe kamanarinari uia be kaba kamaitaita uia! Tago kakaua bong nangatanao masa pera-marau ngamule. Masa rairaituka, ki oabubu lukanganao, ki mang-o, ki anua ngazamazama ka ngamule. ");
INSERT INTO mva_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Puranga tago kakauataki be oaikiki-tina ipura nge moaki kaeno be ite-kaming. ");
INSERT INTO mva_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pile ngaedi ura-kaming nge tamoata be aine moarunga ka uradi: ‘Kaba kamaitaita uia!’” ");
INSERT INTO mva_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Amaridi rua muridi nge Iuda moanako nedi bibia rua Pasoba be ‘Bereti’ Bababadi dapura kana. Tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki nge zala dilelelei be komanga-lo be Iesus dauauri be daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tamoata ngaedi bokai dipile, “Moaki moanako bibia ngaedia-lo be tauauri. Nge masa tamoata daebulo be eung teke damarangaki takana!” ");
INSERT INTO mva_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bong ngaradia-lo nge Iesus Betani-lo isoaki, tamoata kikiri dokia ara Saimon pera kanana-lo. Makara isoaki be imoanakonako nge aine teke bureng-dang teke boau oarika nge bulo tekena-lo idoki be ipura. Bureng ngae nge kai ara ‘nad’ oti ka emaka ipura, be zazaia nge atabala-tina. Kodeka aine ngae bureng ngae iuasari be Iesus pangana-nao isuburakaria. ");
INSERT INTO mva_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tamoata alu makara disoaki be kaba bokai dita nge ilodi dira be nedia-la bokai dipile, “Bakara be bureng uarika nge bizagama-naba ipura? ");
INSERT INTO mva_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bureng ngae iboadu ono ‘mone’ biabia tadoki be tamoata kana nedi tagotago tandi.” Be tamoata ngaedi ditaguraki be aine ngae diauaia-tina. ");
INSERT INTO mva_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ata Iesus bokai ipile, “Aine ngae kamalikitakini! Bakara ka kailo-bukui? Ngai kana kulanglang-tina ka iemakana. ");
INSERT INTO mva_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tamoata kana nedi tagotago masa izamaizama sakemingo dasukoaki. Be bong nangatanao kamadumadi kana karere nge kamadumadi kana! Ata ngau masa tago sakeming-lanao msukoaki. ");
INSERT INTO mva_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aine ngae duma ne surika ka ono idumaia. Ngai imuasoadi be bureng oguo isuburakaria be ono ikalukanaka be kumrakagu ngapura kana. ");
INSERT INTO mva_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Moimoi ka ura-kaming! Ege-ege kateka ngaenao Pile Uia ngae disulesuletaki masa aine ngae muzinga ngaedi nge dararangaki. Be masa muzinga ngaedi kanabe ilodi daniani.” ");
INSERT INTO mva_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kodeka Iesus tagataga ne kulemoa-be-rua teke ara Iudas Iskariot nge itaguraki be tamoata Nanaranga ditabatabai dimuamuadia-lo ilako be Iesus ngadoki be luma-dio nganangai kana. ");
INSERT INTO mva_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tamoata ngaedi Iudas pilenga dilongo nge direre-tina be dirai masa alauri ‘mone’ oti dazazai. Makara be Iudas zala ilelelei masa bong nangatanao zala iauia ngapurani be Iesus ngadoki be luma-dio nganangai kana. ");
INSERT INTO mva_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Amari muamuatuka ono moanako ara ‘Bereti’ Bababadi emaka ipurapurao nge tagataga ne Iesus bokai ditegi, “Inanga galako be kana gadoraki be ono ‘Pasoba’ takani kana kurere?” Maka ma bong ngaedia-lo ka ‘sipisipi’ ono ‘Pasoba’ kania ipurapura nge diumoatemoatedi. ");
INSERT INTO mva_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bokaibe tagataga ne rua inepi-diaru be bokainatuka ira-diaru, “Ierusalem kamalakoru. Makara masa tamoata teke dang boadi ibazibazi nge ngate-kamingru. Kamatagaiaru ");
INSERT INTO mva_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","be pera isililako kanana-lo nge kamalakoru be pera-marau bokai kamaraiaru, ‘Tisa’ bokai ipile, ‘Pera ege ono lou dokinga negu inanga ieno be ono tagataga negu zaiza ‘Pasoba’ gakani?’ ");
INSERT INTO mva_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Be ngai masa pera ilo biabia atabalabala teke ngarangaka-kamingru. Kaba ono soakinga be bagi ono moanakonga nge ambe adorakadi dipura be dieno. Kana makara kamamoataungakiru be masa makara tamoanako.” ");
INSERT INTO mva_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kodeka tagataga rua nge dialaleru. Dialale-ru nge Iesus-la kana irangaki bokana dita-ru. Be kana ono ‘Pasoba’ dakani kana nge diadorakiru. ");
INSERT INTO mva_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ambe rairaituka nge Iesus tagataga ne kulemoa-be-rua zaiza be kaba ono damoanako kanana-lo dilako. ");
INSERT INTO mva_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Disoakiria bagi ono moanakonga-lo be dimoanakonako nge Iesus tagataga ne bokai iradi, “Moimoi ka ura-kaming! Tekem masa erekei luma-dio gonangaia. Tamoata ngae makare kimoanakonako-buduru.” ");
INSERT INTO mva_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tagataga ne pile bokai dilongo nge ilodi dibuku be teke-teke ditegitegi, “Masa ngau ki?” ");
INSERT INTO mva_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Makara nge Iesus bokai iradi, “Kam ma kulemoa-be-rua mara-ming ka teke masa erekei lumadi-o gonangaia. Tamoata-ma maka ‘bereti’ kana idoki be ngau keru tabira-lo kinangalako-budurua-re! ");
INSERT INTO mva_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Moimoina-tina Tamoata Natu masa Nanaranga-la ‘Buku’ ne ipile bokana be ngamate. Ata tamoata maka Tamoata Natu erekei luma-di inangai nge imakadoma-tina! Bai-tina-ma ka tina inekiaki!” ");
INSERT INTO mva_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bong dimoanakonako nge Iesus ‘bereti’ teke idoki be Nanaranga iperui be ikotoi be tagataga ne iandi be bokai iradi, “Kamadoki be kamakani. Ngae nge negu tamoata-gu.” ");
INSERT INTO mva_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dimoanako-doi kodeka ‘uain’ sema tekena-lo idoki be Nanaranga iperui be iandi be dising. ");
INSERT INTO mva_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Be bokai iradi, “Ngae nge negu daraka-gu. Darakagu ngaedi ane ka Nanaranga taoa ne oauoau tamoata moarunga zaiza iemakadi. Tamoata be aine kokoko-tina kanabe darakagu suburakadi dapura kana. ");
INSERT INTO mva_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Moimoina-tina ka ura-kaming! Tagona-tina iboadu ‘uain’ damaka kaba msing nibe ngalako bong ono Nanaranga ngatanepoa kanana-lo be masa ‘uain’ oauoau msing.” ");
INSERT INTO mva_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kodeka rang teke dimoasi be Olib buku-nao dilako. ");
INSERT INTO mva_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Makara be Iesus bokai iradi, “Kam moarunga masa kamairatu be kamapereka! Nanaranga ‘Buku’ nena-lo bokai digere, ‘Ngau masa ‘sipisipi’ akolakola mpaliti be ‘sipisipi’ dairatu.’ (Zek 13:7) ");
INSERT INTO mva_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ata mate-lo be marang masa aro-ming mua be Galili-lo msoaki.” ");
INSERT INTO mva_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Iesus bokai ipile nge Pita ikatu be bokai irai, “Moarunga masa dairatu. Ngau tagona-tina iboadu miratuiko!” ");
INSERT INTO mva_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kodeka Iesus itaguraki be Pita bokai irai, “Pita! Moimoi ka uraiko! Kaituka oabubu ngaena-lo masa mang tagona-la bong rua ngakatararaua be kaiko masa bong toli gopile tago kukauataka!” ");
INSERT INTO mva_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ata Pita ikai-tina be bokai ipile, “Iboadu tamate-buduru, ata ngau tagona-tina iboadu mpile tago ukauatakiko!” Be tagataga ne takadi nge bokaina-doi dipile. ");
INSERT INTO mva_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Kodeka dialale be kaba aradi Getsemani-lo dipura. Makara nge Iesus tagataga ne bokai iradi, “Bokai kamasoaki be mlako be mrabo.” ");
INSERT INTO mva_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kodeka itaguraki be Pita, Zems be Zon ibagadiato be dialale-buduto. Iesus nge ilo inodo-tina be ilo ibuku-ramoi. ");
INSERT INTO mva_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Be bokai ipile, “Ilogu inodo-tina be ambe saringatuka mate bokana kana. Bokai kamasoakito be kaba kamaitaita-to!” ");
INSERT INTO mva_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kodeka mukuna-la ilako be kateka-o itapuloria be irabo, iboadu-tina nge bong ngaedi ono sururu ngadoki kana nge moaki sesu ono didauraki. Dalako-ba. ");
INSERT INTO mva_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kodeka bokai ipile, “Tama-gu. Negu Tamagu, kaiko kuboadu kana moarunga goemaki. Sururu ngaedi godokilea. Ata moaki rerengagu kutagadi. Kaiko-la rerengam gotagadi.” ");
INSERT INTO mva_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bokai irabo be imule nge tagataga ne itedi ambe dienosoa. Be itaguraki be Pita bokai irai, “Saimon, kaiko kueno ki? Tago iboadu amari siriki ne tekena-la bokana gonari be gosoaki ki?” ");
INSERT INTO mva_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kodeka bokai ira-diato, “Kaba kamaitaita uia! Kamaraborabo be masa toitoi tago teke ngatoi-kaming. Moimoi ilogu isumoala, ata kusi-gu imangongo-tina.” ");
INSERT INTO mva_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesus bokai ipile be kaba ialale be enumua-la irabo bokana irabo. ");
INSERT INTO mva_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kabana-ma ka imule be tagataga ne itediato nge dienosoa-tinato. Mata-diato nge dimoatubu-tina, be tago dikauato masa baituka daraiato. ");
INSERT INTO mva_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Alauri Iesus bong tolia imule nge bokai ira-diato, “Kam isi kamanaua be kaeno! Eno iboadu! Kaba kamaita! Tamoata Natu ambe muzigoala ememaki luma-dio dinangai. ");
INSERT INTO mva_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kamatui be talale. Kamate! Tamoata erekei luma-dio nganangaia kana ambe ipura.” ");
INSERT INTO mva_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesus isi ipilepile-la be tagataga ne kulemoa-be-rua teke ara Iudas ipura. Tamoata dum biabia teke nge asi ono eunga be meng dibazi be Iudas muri ditagatagai. Tamoata Nanaranga ditabatabai dimuamuadi, tamoata Moses Mata ne disulesuletaki be Iuda tamoata nedi bibia ka dinepidi be dipura. ");
INSERT INTO mva_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iudas enumua be tamoata ditagai nge bokai iradi, “Tamoata uaroki nge ngai! Kamauauri be kamabagai!” ");
INSERT INTO mva_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Bokaibe bong Iudas ipura nge oaikiki-tina ilako be Iesus bokai irai, “‘Tisa,’” be iaroki. ");
INSERT INTO mva_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tamoata Iudas ditagai kaba bokai dita nge ditaguraki be Iesus didokimatei be diuauri. ");
INSERT INTO mva_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Makara nge Iesus tagataga ne teke saringa bokai ituitui asi ne idoki be tamoata ngaedi teke kungi izamtotokani. Tamoata kungi izamtotokani nge tamoata Nanaranga ditabatabai biabiatuka nedi malipilipi kana kata. ");
INSERT INTO mva_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kodeka Iesus itaguraki be bokai iradi, “Ngau eung kata marangaki kana ka asi ono eunga be meng kadoki be kapura be kauaura? ");
INSERT INTO mva_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Izamaizama sakemingo usukoaki be Nanaranga pera nena-lo be usulesule-kaming nge tago kadoka be kauaura! Ata nge ono pile Nanaranga ‘Buku’ nena-lo dieno nge emakadi dapura be dakalingo kana ka bokai kamuzi!” ");
INSERT INTO mva_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Makara be tagataga ne diratu be dipereki. ");
INSERT INTO mva_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tamoata amuna teke nge kusi ne tekena-la manipi oaoaoa iokori be Iesus itagai. Makara nge tamoata Iudas ditagai ditaguraki be dadokitagaki kana, ");
INSERT INTO mva_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ata iratu. Iratu-ratu nge kusi ne itarube be nemoalala-ba iratu. ");
INSERT INTO mva_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kodeka Iesus dibagai be tamoata Nanaranga ditabatabai biabiatuka nedi pera kanana-lo dilakuaki. Be tamoata Nanaranga ditabatabai dimuamuadi moarunga, Iuda tamoata nedi bibia be tamoata Moses Mata ne disulesuletaki nge dipura be dikabuni. ");
INSERT INTO mva_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita nge ne lauaba-nao be itagatagadi. Be ilako tamoata Nanaranga ditabatabai biabiatuka nedi pera kana ari-dialo isili. Makara nge tamoata pera dinarinaringi zaiza isoaki be eoa iboatoboato. ");
INSERT INTO mva_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kodeka tamoata Nanaranga ditabatabai dimuamuadi, be Iuda tamoata nedi bibia ‘Kansolo’ nedi-o disoaki moarunga nge tamoata alu dikiladi be Iesus-o giriki danangalako be daumoatei kana. Ata giriki tago teke diteani. ");
INSERT INTO mva_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tamoata kokoko-tina boli pile ono dinangalako, ata pile nem-nem be diemaki be tago tekedi suridi tekedi. ");
INSERT INTO mva_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kodeka tamoata alu ditui be boli pile tekedi Iesus ono dinangalako be bokai dipile, ");
INSERT INTO mva_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Keka Iesus kilongori bokai ipile-ra Nanaranga pera ne tamoata dikeli nge ngagamani be amaridi toli ilodia-lo be takaia tamoata tago dikeli nge nganaguraki.” ");
INSERT INTO mva_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ata tamoata ngaedi nge pile nem-nem be diemaki. Pile nedi labudi tago tekedia-doi. ");
INSERT INTO mva_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kodeka tamoata Nanaranga ditabatabai biabiatuka nedi arodi ituirake be Iesus bokai itegi, “Pilengadi gokatu ki tago? Rakana pile kaoa ka omo diununglako?” ");
INSERT INTO mva_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ata Iesus imoadubulae-ba be pilengadi tago sesu ikatu. Makara nge tamoata biabia ngae kaba itegi, “Kaiko Kristus, Nanaranga rakeaka ipurapura Natu ki tago?” ");
INSERT INTO mva_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Be Iesus ikatu be bokai ipile, “E! Ngau-ma. Tamoata Natu masa Nanaranga Kaiboangina-tina luma oana-nao ngasoaki be kamate. Be masa oaru lang anua-lonalona odio ngasoaki be ngapura.” ");
INSERT INTO mva_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iesus bokai ipile nge tamoata Nanaranga ditabatabai biabiatuka nedi itaguraki be kusi-sili ne sasalaga idoki-sare be bokai ipile, “Tamoata kaba moaki teke takilai be pile ono inangalako! ");
INSERT INTO mva_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kam moarunga ambe kalongo-doi! Nanaranga ono imanai. Ilo-ming ba dipile?” Kodeka moarunga makara disoaki nge pile ono dinangalako be dipile umoatea ngapura. ");
INSERT INTO mva_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kodeka tamoata alu ditaguraki be dimoangori. Be kusi mapala teke didoki be mata ono disuku be luma-di dikinglulu be diuni be bokai dipile, “Pile mumuakadi alu gopile naita ka iungko!” Kodeka tamoata pera dinarinaringi nge ditaguraki be dibagai be dapaliti. ");
INSERT INTO mva_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita nge isi eruma pera ari-dialo isoaki. Makara isoaki nge aine teke tamoata Nanaranga ditabatabai biabiatuka nedi imalipilipini nge ipura. ");
INSERT INTO mva_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Be bong aine ngae Pita eoa iboatoboato be ite nge idedeia-uia be bokai irai, “Kaiko be! Nasaret tamoata Iesus kam-ru kalalale-buduru.” ");
INSERT INTO mva_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ata Pita ikatu be bokai ipile, “Ngau tago ukaua! Ilogu tagona-tina ikaua rakana kata ka kurangarangaki!” Be itui be zala aoa-nalo ilako. Makara nge mang teke ikatararaua. ");
INSERT INTO mva_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kabana-ma ka aine malipilipi ngae Pita ite be tamoata makara dituitui nge bokai iradi, “Tamoata ngae nge di kata!” ");
INSERT INTO mva_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ata Pita kaba iaoli. Alauri nge tamoata makara dituitui ditaguraki be Pita bokai dirai, “Moimoina-tina be kaiko di kata! Kaiko Galili tamoata kata!” ");
INSERT INTO mva_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Makara nge itaguraki be nena-la ingesuaki be pile tago tototo ane be bokai ipile, “Nanaranga iboadu sururu bibia-tina ngana! Moimoina-tina ka upile tamoata karangarangaki nge tagona-tina ukauataki.” ");
INSERT INTO mva_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pita bokai ipile nge mang bong ruaia ikatararaua. Makara nge Pita Iesus pilenga ilo iandi. Iesus Pita bokai irai, “Mang tagona-la bong rua ngakatararaua be masa kaiko bong toli gopile tago kukauataka.” Bokaibe Pita tang kana-tina-biabia iemaki. ");
INSERT INTO mva_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Izama nge oabuna-tina be tamoata Nanaranga ditabatabai dimuamuadi, tamoata Moses Mata ne disulesuletaki, Iuda tamoata nedi bibia, be Iuda tamoata nedi bibia ‘Kansolo’ nedia-lo disoaki nge dipura be pile dipali be Iesus diuauri be dieluaki Pailot-lo. ");
INSERT INTO mva_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Kodeka Pailot itaguraki be Iesus bokai itegi, “Kaiko Iuda anuatanepoa nedi?” Be Iesus pilenga ikatu be bokai ipile, “Kaiko-la kupile bokana.” ");
INSERT INTO mva_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tamoata Nanaranga ditabatabai dimuamuadi nge pile moagili-moagili Iesus ono dinangalako. ");
INSERT INTO mva_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kabana-ma ka Pailot bong ruaia itegi, “Bakara? Pile nem ono goiakiko kana tago ki? Gote! Pile kokoko-tina omo diuaulako!” ");
INSERT INTO mva_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ata Iesus pile tago tekena-tina ikatungi. Iesus pile tago sesu ikatu nge Pailot ipitilaki-tina be tago sesu ipile. ");
INSERT INTO mva_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bong ‘Pasoba’ moanako rakeaka ipurapura barasi teke-teke ilodia-lo nge muzi nedi teke bokai ieno: Tamoata be aine dapura kodeka tamoata uaura-lo disoaki nge rerengadia-lo teke darangaki be Pailot ngarubetaki. ");
INSERT INTO mva_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bong ngaedia-lo nge tamoata teke uaura-lo isoaki, ara Barabas. Tamoata ngae nge Iuda tamoata alu zaiza be eung biabia teke ungguma Rom diemakadi be tamoata alu diundi be dimate. ");
INSERT INTO mva_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Kodeka tamoata be aine dipura be barasi moarunga-lo dimuzimuzi bokana Pailot dirai be tamoata uaura-lo disoaki nge teke ngarubetaki kana. ");
INSERT INTO mva_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Makara be Pailot ikatu be bokai iradi, “Kam karere Iuda anuatanepoa kandi mrubetaki be miang-kaming ki?” ");
INSERT INTO mva_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot ikaua tamoata Nanaranga ditabatabai dimuamuadi ka Iesus dinama-rataki be ngaia-lo dieluaki. ");
INSERT INTO mva_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ata tamoata Nanaranga ditabatabai dimuamuadi ditaguraki be tamoata be aine ilodi diung be dapile Barabas ngarubetaki be ngandi. ");
INSERT INTO mva_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bokaibe Pailot kaba itegidi, “Be tamoata ngae kam Iuda anuatanepoa kana-ming kana kapile nge ba mbasaki?” ");
INSERT INTO mva_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Be tamoata be aine dimere be bokai dipile, “Kai kapalapala uauau-o rokatagaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Be Pailot kaba itegidi, “Bakara ka? Giriki nangata iemaki?” Ata di kodeka dipi-tina be dimere be bokai dipile, “Kai kapalapala uauau-o rokatagaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Be ono ilodi ngaka-uiadi kana nge Pailot itaguraki be Barabas irubetaki be iandi. Kodeka ipile be Iesus dirautotoki be kai kapalapala uauau-o darokatagaki kana. ");
INSERT INTO mva_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Alauri nge Rom koai-bagi tamoata Iesus didoki be dilakuaki Pailot pera kana malala-nalo disoakingaki, kodeka koai-bagi tamoata takadi dikiladi be dipura. ");
INSERT INTO mva_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Makara be kusi-sili biabia daradara teke disiliakani be oarige ragaragadi diraulemoang be pangana-nao dinangaria. ");
INSERT INTO mva_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kodeka luma-di dirorokakini be bokai dirarai, “Aram atabala-tina ngaeno, Iuda anuatanepoa nedi!” ");
INSERT INTO mva_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Be kai oti pangana-nao diuniuni. Kodeka dimoangori be aro tukudi-o dirokazokuria be diboadukuni. ");
INSERT INTO mva_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ono dimanai-doi kodeka kusi-sili daradara dipasikani be nena-tina disiliakani. Kodeka dibagai be dieluaki be kai kapalapala uauau-o darokatagaki kana. ");
INSERT INTO mva_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Zala-lo nge Sairini tamoata teke Aleksanda be Rupus tama-diaru ara Saimon dite be diakangaoi be Iesus kai kapalapala uauau ne ibazi. Saimon nge anua sisiki-lo ka Ierusalem ilakolako. ");
INSERT INTO mva_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Makara be Iesus dilakuaki kaba tekedi aradi Golgota-lo. Ara ngae labu bokai, “Tamoata pangana paki kaba ne.” ");
INSERT INTO mva_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Makara be ‘uain’ ngesi ara ‘mir’ zaiza dibairi nge diani be ngasing kana, ata isege. ");
INSERT INTO mva_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kodeka kai kapalapala uauau-o dirokatagaki, be kusi ne dinege be nedi didoki. Kusi ne dadoki kana nge guzui teke diemaki be ono dikaua kusi nangata masa naita ngauasai be ngadoki. ");
INSERT INTO mva_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Amari isi malala zage atata ieno, kaleti dipile ‘9 kiloki’ be Iesus kai kapalapala uauau-o dirokatagaki. ");
INSERT INTO mva_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pile Iesus ono dinangalako be ono diumoatei nge bokainatuka digere, “Iuda Anuatanepoa Kandi.” ");
INSERT INTO mva_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tamoata anakonako rua nge Iesus zaiza dirokatagakidi. Takaia oanana-o be takaia ngasina-o. ");
INSERT INTO mva_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Bokaibe pile tekedi Nanaranga ‘Buku’ nena-lo nge dikalingo, “Masa anakonako zaiza uarea ngapura.” ");
INSERT INTO mva_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tamoata be aine bokai dilakolako be dimulemule nge panganadi ditatatai be Iesus dingengengeri be bokai dipilepile, “Ni! Nge kaiko ka Nanaranga pera ne gogamani be amaridi toli ilodia-lo be kaba gokeli kana! ");
INSERT INTO mva_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ak, nem-la gouketiko be kai ngaranao be maka gobala!” ");
INSERT INTO mva_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Be tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki nge bokaina-doi Iesus ono dimanai be nedia-la bokai dipile, “Tamoata takadi nge iuketidi, ata tago iboadu nena-la ngauketi! ");
INSERT INTO mva_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nge ka Kristus-re! Be ngai ka Iuda anuatanepoa kandi! Kai ngaranao be makare gobala masa gateko be lama gauni!” Tamoata rua Iesus zaiza dirokatagakidi nge bokaina-doi takadi bokana dingengeria-ru. ");
INSERT INTO mva_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Amari malala-tina ieno nge kateka oabubu isukumi. Oabubu ieno-la nibe amari aoa-lo ibala. ");
INSERT INTO mva_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ambe amari malala zage-aoa nge Iesus ipi-tina be ikilau be bokai ipile, “Eloi, Eloi, lema sabaktani?” Nge bokainatuka ka ipile, “Nanaranga negu! Nanaranga negu! Bakara ka kupereka?” ");
INSERT INTO mva_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tamoata alu saringa dituitui be dilongori nge bokai dipile, “Kamalongo! Ilaiza ikilakilai.” ");
INSERT INTO mva_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kodeka tamoata teke kusi mapala matoli idoki be ipananalako be ‘uain’ kapisana-lo ibizari be kai teke buruna-o inangai be idokiteteki be Iesus ngani be ngasing kana, ata bokai ipile, “Iei, abo noko! Tarapu be kaba taita noko! Baraoa Ilaiza ngapura be ngaori!” ");
INSERT INTO mva_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kodeka Iesus ipi-tina be inaboaki be imate. ");
INSERT INTO mva_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iesus imate nge kusi biabia Nanaranga pera nena-lo itobitobi nge imasare atabala be ibala be ilako ege rua ipura. ");
INSERT INTO mva_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Koai-bagi pangana nedi makara Iesus kai ne aro ituitui be merenga ilongo be baituka be imate ita nge bokai ipile, “Moimoina-tina tamoata ngae Nanaranga Natu.” ");
INSERT INTO mva_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Aine alu nge muku kasauba ditui be kaba ditaita. Aine ngaedi teke nge Magdala aine ara Maria. Takaia nge Maria, Zems sikisiki be Iosep tina-diaru. Be teke nge Salome. ");
INSERT INTO mva_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bong Iesus Galili-lo isoaki nge aine ngaedi ka ditagatagai be didumadumai. Be aine takadi Iesus zaiza be Ierusalem dilako-budu nge kokoko makara disoaki be. ");
INSERT INTO mva_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Amari ono Iesus imate nge Iuda bong nedi ono ‘Pasoba’ Moanako dimoatautaungaki. Ngazama nge bong ono manauanga ‘Sabat’ kana. Ambe rairai-tuka nge ");
INSERT INTO mva_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatea tamoata ara Iosep ipura. Iuda tamoata nedi bibia maradi nge ngai ara otioti. Ngai tamoata iauia be bong ono Nanaranga ngatanepoa kana nge irapurapungi. Bokaibe nena-la ikaingaki be ilako Pailot aro itui be Iesus mate ikeliaki. ");
INSERT INTO mva_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailot ilongo Iesus ambe imate nge ipitilaki-tina. Kodeka koai-bagi pangana nedi ikilai be itegi Iesus ambe moimoi be enumua be imate ki? ");
INSERT INTO mva_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailot koai-bagi pangana nedi ngae pilenga ilongo Iesus ambe imate nge isumoala be Iosep itaguraki be Iesus mate nge ibagai. ");
INSERT INTO mva_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kodeka Iosep kusi oaoaoa teke ibagai be Iesus ioraria be kusi ngae oti ikingsukumi be gimoa teke ilona-lo inangalako. Gimoa ngae nge patu kanabiabia teke ilona-lo ka emaka ipura. Kodeka Iosep patu kanabiabia teke igegeakalako be Iesus poda aoa ono ionoti. ");
INSERT INTO mva_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdala aine ara Maria be Maria, Iosep tina nge makara disoakiru be kaba ono Iesus dinangai nge ditaru. ");
INSERT INTO mva_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bong ono manauanga ‘Sabat’ imanubu nge Magdala aine ara Maria, Salome be Maria-la taka Zems tina nge bureng be kana takadi boaudi uarikadi dizazato be dalaleto be ono Iesus mate daburengiato kana. ");
INSERT INTO mva_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bokaibe izama ‘Sabat’ muri nge oabuna-tina amari ambe irakerake be Iesus poda-nalo dilakoto. ");
INSERT INTO mva_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Zala-lo dialalaleto nge nedialanato bokai diepilei-to, “Masa naita patu biabia poda aoa ono onota ipura ngagegeaki?” ");
INSERT INTO mva_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ata bong dilakopurato nge patu biabia poda aoa ono onota ipura nge ambe gegeaka ipura. ");
INSERT INTO mva_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Be poda kaka ieno be diteato bokana disilito. Disili-to nge tamoata amuna teke kusi-sili salagakoe oaoaoa isilisili nge bokai poda ege oana-nao isoaki be diteato. Diteato nge dipitilaki-tinato. ");
INSERT INTO mva_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Makara nge tamoata ngae bokai ira-diato, “Taburi-mingto moaki dira! Ngau ukaua kamto Nasaret tamoata Iesus, kai kapalapala uauau-o rokatagaka ipura ka kaleleleato. Tago ambe maka ieno. Ambe imarang. Kaba ono dinangai maka kamaitato. ");
INSERT INTO mva_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kamalaleto be tagataga ne be Pita bokai kamaradi, ‘Aro-ming ngamua be Galili ngalako kana. Masa makara kamate, ne iraka-ming bokana.’” ");
INSERT INTO mva_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aine ngaediato nge pitilaki tagona-tina diuiato. Bokaibe taburi-diato nge dira-tina be reresabu zaiza be dipusikato be diratuto. Be kana ditato nge tago teke dirangakini. Taburidia-mato dira-tina!  ");
INSERT INTO mva_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesus nge amari muamuatuka-lo be oabuna-tina be mate-lo be imarang. Mate-lo be imarang nge Magdala aine ara Maria ipurakani. Aine ngae ka toira Iesus mariaba goalakadi lima-rua ilona-lo itaodi. ");
INSERT INTO mva_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Be nge Maria ngae ka ilako be Iesus sukoaki-budu ruanga iradi. Di nge ilodi dibuku be ditangtang be disoaki. ");
INSERT INTO mva_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ata bong bokai dilongo Iesus ambe moauriuri isoaki be Maria ite nge lama tago diuni. ");
INSERT INTO mva_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Alauri nge Iesus itabuli be takaiana-ba ipura be tagataga ne rua ipuraka-diaru. Tagataga ne rua nge anua diperekiaru be masauaba-lo dialalaleru be ipuraka-diaru. ");
INSERT INTO mva_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Be tagataga rua ngae-diaru nge dilakoru be tagataga ne takadi diradi. Ata di tagataga ngae-diaru pilengadi tago lama diungdi. ");
INSERT INTO mva_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Alauri nge tagataga ne kulemoa-be-teke disoaki be dimoanakonako be ipurakadi. Makara nge itaguraki be iebulodi, bakara, ilodi nge dikaingaki be lama tago diuni. Labu takaia ono tagataga ne iebulodi nge tamoata be aine takadi Iesus dite ambe mate-lo be imarang be diradi, ata di lama tago diuni. ");
INSERT INTO mva_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kodeka bokai iradi, “Kamalale be ege-ege kateka-o Pile Uia ngae tamoata be aine moarunga mangata kamarangakadi. ");
INSERT INTO mva_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tamoata naita lama iuni be araguo be rukuia ipura masa Nanaranga ngauketi be ngamuleaki. Ata tamoata naita lama tago iuni masa alauri sururu bibia-tina dadoki. ");
INSERT INTO mva_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tamoata lama iuni masa kaiboang ania ngapura be kilala kaiboangdi ngaememaki. Aragu-o be masa mariaba goalakadi ngataotaodi be iboadu pile takadia-lo ngapilepile. ");
INSERT INTO mva_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Be moata goalakadi idoki ki zere goalakadi ising masa tago ngamate. Be luma masa moremore odio ngananga-nangaria be dauiauia.” ");
INSERT INTO mva_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tanepoa Iesus tagataga ne iradia-doi, kodeka Nanaranga idoki be lang anua-lo ikautakingaki be kaba aradi bibiatuka oana-nao isoaki. ");
INSERT INTO mva_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kodeka makara be tagataga ne dialale be ege-ege Pile Uia mangata dirangaki. Be Tanepoa nge ne zaiza be dimalipilipi-budu. Be pile ne ono iemaki be dikalingo nge kilala ne kaiboangdi iememaki. ");
INSERT INTO mva_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Biabiadi Teopilus, tamoata kokoko-tina panganadi dizeleki be kana Iesus Kristus marada ipuraki be dikalingo nge digere. ");
INSERT INTO mva_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kana ngaedi nge tago tamoata-ramo kaoa ka dirangaki. Tago. Nge tamoata nedi matadia-lo matamatana-tina be kaba dita, be tamoata maka Nanaranga pilenga dirarangaki ka dira-kama be geretadi dipura. ");
INSERT INTO mva_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kaiko Biabiadia-tina Teopilus, kana ngaedi nge negu-la be labudia-lo be uliliti-uia be ukauataki-uia ka mgereniko kana. Be nge iuia kana ngaedi nge dipura-la bokana mtagadi be mgereniko kana. ");
INSERT INTO mva_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Bokai muzi be masa bokai gokaua kana moarunga makare rangakadianiko dipura nge moimoi be dipura be dikalingo. ");
INSERT INTO mva_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bong Erot Zudea anuatanepoa kandi bokana isoaki nge tamoata teke isoaki ara Sakarias. Tamoata ngae tama be tubu nge tamoata Nanaranga ditabatabai kaoa. Bokaibe ngai nge tamoata Nanaranga ditabatabai ara Abaiza labunao ka ipura. Roa ara Elisabet. Be Elisabet tama be tubu nge bokaina-doi tamoata Nanaranga ditabatabai kaoa. ");
INSERT INTO mva_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Soakinga-diaru Nanaranga mata-nao nge diado-tina, be Tanepoa mata ne be pilenga moarunga nge ditagatagadia-tinaru. ");
INSERT INTO mva_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ata natu-diaru tago, bakara Elisabet ikupi, be Sakarias ambe ikamoangbia be Elisabet ambe iainebia. ");
INSERT INTO mva_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bong teke nge tamoata Nanaranga ditabatabai Abaiza labunao dipura nge bong nedi ono Nanaranga pera ne ilo ratana-lo malipi nedi daemaki kana. Ramani ngaranao nge Sakarias bong ne ono makara ngamalipi kana. ");
INSERT INTO mva_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tamoata Nanaranga ditabatabai mata nedi teke bokai ieno: Aradi dagere be dazumkaki. Kodeka ara teke darepeki. Ara nangata direpeki nge tamoata ma ngae ka ngalako Nanaranga pera nena-lo be au-kusi boaudi rongorongo ngabulai. Bong ngaranao ara teke direpeki nge Sakarias ara ipusika. Bokaibe Sakarias ilako be Tanepoa pera nena-lo au-kusi boaudi rongorongo ngabulai kana. ");
INSERT INTO mva_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bong ono au-kusi bulanga dipura be Sakarias isili be au-kusi ngabulai kana nge tamoata be aine kokoko-tina dipura be eluku ditui be diraborabo. ");
INSERT INTO mva_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bong Sakarias Nanaranga pera ne ilo ratana-lo isili be bagi ono au-kusi bulanga-lo ituitui nge Tanepoa ‘enzel’ ne ipura be bagi ege oananao itui. ");
INSERT INTO mva_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakarias ‘enzel’ ite nge ipitilaki-tina, be taburi nge ira-tina. ");
INSERT INTO mva_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ata ‘enzel’ ngae bokai ipile, “Sakarias, taburim moaki ira. Nanaranga ambe rabo nem ilongo. Roam Elisabet masa natu moane teke nganekiakamko, be masa ara Zon gobuleakani. ");
INSERT INTO mva_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Natu ngae masa ngaemakiko be surim dauia be ilom ngauaria-tina. Be bong tina nganekiaki masa tamoata be aine kokoko-tina ngaemakidi be suri-uia bibia-tina dadoki. ");
INSERT INTO mva_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Be Tanepoa mata-nao masa ara ngalaba-tina. ‘Uain’ ki dang kaikai moakina-tina teke ising. Bakara, isi tina ilona-lo ngaeno be masa Oli Spirit natu ngaena-lo ngakauri. ");
INSERT INTO mva_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Be nge ngai ka Israel tamoata be aine kokoko-tina ngamuleakidi be Nanaranga nedi Tanepoa-lo damule kana. ");
INSERT INTO mva_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ngai masa Ilaiza mariabaka be kaiboang nena-lo be Tanepoa aro ngamua, be ono kamoang ilodi ngabuiri be natudi datalaridi. Be tamoata panganadi patu bokana masa ilodi ngabuiri be tamoata adoadodi kauangadi malaidi nge datagadi. Ngai ka Tanepoa tamoata be aine ne ngamoataungakidi be dasoaki be Tanepoa ngapura kana.” ");
INSERT INTO mva_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kodeka Sakarias itaguraki be Nanaranga ‘enzel’ ne bokai itegi, “Nge masa baituka be mkaua pile ngaedi nge kalingodi ki tago? Ngau ambe ukamoangbia-tina be roagu ambe iainebia-tina!” ");
INSERT INTO mva_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Be ‘enzel’ ikatu be bokai ipile, “Ngau Gabriel. Ngau ka izamaizama Nanaranga aro utuitui. Nanaranga ka inepia be taepileiru be pile uia ngaedi mraiko kana. ");
INSERT INTO mva_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pilengagu ngaedi lama tago kundi bokana masa pile gobebe be tago sesu gopilepile nibe ngalako kana-ba ngaedi dapura. Pilengagu ngaedi masa bong-tina nedi-o be dapura be dakalingo.” ");
INSERT INTO mva_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tamoata be aine eluku disoaki be dirapurapu nge ilodi dilelelenaki bakara ka Sakarias uanana sasalaga-tina Nanaranga pera nena-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bong ipusika nge pile ibebe be lumana-ba ane iraradi. Makara nge tamoata be aine eluku disoaki dikaua Sakarias kaba takadia-ba Nanaranga pera nena-lo ita. Nge bokai ka pile ibebe be lumana-ba ane iraradi. ");
INSERT INTO mva_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakarias Nanaranga pera nena-lo malipi ne dimanubu nge pera kanana-lo imulelako. ");
INSERT INTO mva_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Alauri nge roa Elisabet itine, be pera kandiaru tago sesu ipereki nibe kalea lima dimanubu. ");
INSERT INTO mva_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kodeka Elisabet bokai ipile, “Tanepoa ka kana ngae iemakana. Bong ngaedia-lo be ilo iuiataka be tamoata moarunga matadi-o maiangagu irokaki.” ");
INSERT INTO mva_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet itine be kalea lima-tekeanao nge Nanaranga itaguraki be ‘enzel’ ne Gabriel inepalako anua ara Nasaret-lo, ege Galili kaba-lo. ");
INSERT INTO mva_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Makara Nasaret-lo nge Gabriel ilako be aine barasi teke moane zaiza isi tago sesu dieno-budu ara Maria nge ipurakani. Aine barasi ngae nge tamoata teke Israel Anuatanepoa nedi biabia Debiti labunao ipura ara Iosep dirauamani be ngauati kana. ");
INSERT INTO mva_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bokaibe ‘enzel’ Gabriel ilako aine ngaena-lo nge bokai ipile, “Ilo-uia kaiko-lo ngaeno! Nanaranga ilo iuiatakiko-tina. Tanepoa kaiko-lo isoaki be marou ne bibia-tina ane imarouiko!” ");
INSERT INTO mva_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria pile ngaedi ilongo nge ilo ibuku-tina be ilo bokai ilelenaki, “Nge rakana pile kaoa?” ");
INSERT INTO mva_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ata Nanaranga ‘enzel’ ne bokai ipile, “Maria, taburim moaki ira! Nanaranga ilo iuiatakiko-tina be marou ne uia-tina ane imarouiko! ");
INSERT INTO mva_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Masa gotine be natu moane teke gonekiaki, be masa ara Iesus gobuleakani. ");
INSERT INTO mva_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Natu ngae masa ara ngalaba-tina be Nanaranga Atabalabala-tina Natu kana dakilakilai. Nanaranga Tanepoa masa ngataguraki be tubu Debiti tanepoa ne ngadoki be Natu ngae ngani. ");
INSERT INTO mva_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Be masa Zekop tubu anuatanepoa nedi bokana ngasukoaki. Tanepoanga nge tago manubunubu, nem-kueno daeneno kana!” ");
INSERT INTO mva_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Be Maria itaguraki be ‘enzel’ bokai itegi, “Nge masa baituka? Ngau isi moane tago teke keru kieno-buduru!” ");
INSERT INTO mva_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Be ‘enzel’ ikatu be bokai ipile, “Oli Spirit masa omo ngabala be Nanaranga Atabalabala-tina kaiboang ne masa aungakadi dakubatiko. Bokaibe natu kusi-rata gonekiaki kana nge masa Nanaranga Natu kana kilaia ngapurapura. ");
INSERT INTO mva_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dara nem Elisabet ilom ngani. Ngai ikupi kana dirangaki, ata ambe itine, be nge ambe kalea ne lima-tekeana-lo ka isoaki. Moimoi iainebia, ata itine. ");
INSERT INTO mva_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Bokai gokaua: Kana tago teke Nanaranga tago iboadu ngaemaki. Nanaranga iboadu kana moarunga ngaemaki.” ");
INSERT INTO mva_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Be Maria bokai ipile, “Ngau Tanepoa dududu kana. Kana ngaedi iboadu kupile-la bokana dapurana!” Makara be Nanaranga ‘enzel’ ne Maria ipereki be ialale. ");
INSERT INTO mva_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","‘Enzel’ ialale be muri nge Maria ikatiuana be itui be oaikiki-tina anua teke Zudea buku kaba-lo ieno-lo ilako. ");
INSERT INTO mva_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Makara nge ilako Sakarias pera kanana-lo be Elisabet bokai irai, “Ilo-uia kaiko-lo ngaeno!” ");
INSERT INTO mva_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria bokai ipile nge natu-muku Elisabet ilona-lo inaulaki, be Oli Spirit ibala be Elisabet ilona-lo ikauri. ");
INSERT INTO mva_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kodeka Elisabet kaikai-la inaboaki be bokai ipile, “Aine moarunga maradi nge marou bibia-tina kaiko-lo daeno. Be natu gonekiaki kana nge iboadu marou bibia ono daeno. ");
INSERT INTO mva_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ata nge bakara ka ngau muaka bibia udoki be Tanepoa negu tina ngau-lo ipura? ");
INSERT INTO mva_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Maka ma kupura be ilo-uia kuana be malongam kungigu-lo ilako nge oaikiki-tina natu-muku ilogu-lo suri diuia be inaulaki. ");
INSERT INTO mva_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Surim dauia! Tanepoa masa iraiko-la bokana kana irangaki nge ngaemaki be dakalingo!” ");
INSERT INTO mva_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Makara nge Maria bokai ipile, “Ilogu ere-moarunga be Tanepoa urakeaki. ");
INSERT INTO mva_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mariabakagu Nanaranga isuri-uiataki, bakara ngai ka Uketiketi negu. ");
INSERT INTO mva_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ngau malipilipi kana erumaruma-tina ka ilo iana. Bong ngaenao be ilako masa tamoata be aine moarunga zugu moarunga-lo suri-uia kana dakilakilaia. ");
INSERT INTO mva_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Kana kana-tina-bibia ka Nanaranga Kaiboangina-tina iemakana. Ara ratana-la ngaeneno! ");
INSERT INTO mva_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tamoata be aine dimatakutakuri nge ilo-taga ne ianiandi. Be tubu alalauri-lo masa bokaina-la ngamuzimuzi be ngalako-la be ngaeno. ");
INSERT INTO mva_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Luma ane be malipi kaiboangdia-tina iememaki. Tamoata maka ilodia-lo be nedia-la diraketukatukadi nge idua-raramoakidi. ");
INSERT INTO mva_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tamoata aradi bibia rakerakedi nge atabala disukoaki ka ibabalakidi be dileualeua, ata tamoata nedia-la dibabalakidi nge irakerakeakidi. ");
INSERT INTO mva_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tamoata toletole-ba disukoaki nge kangkang uia ane iakokolangdi, ata tamoata kana nedi kokoko nge kalingodia-ba inepinepidi be dialalale. ");
INSERT INTO mva_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tubuda pile moimoibe kalingodi iradi nge tago ilo dileuataki. Bokaibe itaguraki be malipilipi kana Israel idumai. ");
INSERT INTO mva_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ilo-taga ne ilo iani be Abaram tubu ne zaiza ilo itagadi. Ilo-taga ne ngae masa nem-kueno ngaeneno!” ");
INSERT INTO mva_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Alauri nge Maria makara kalea toli Elisabet sakenao isoaki be kaba anua nena-lo imule. ");
INSERT INTO mva_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Bong ono Elisabet nganeki kana dipura nge natu moane teke inekiaki. ");
INSERT INTO mva_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Anua-budu ruanga be dara ne bokai dilongo Tanepoa ambe Elisabet ilo iuiataki nge Elisabet zaiza be suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Be alauri amari lima-toli dimanubu nge natu-muku ngae kusi dakorototoki be tama ara Sakarias dabuleakini kana. ");
INSERT INTO mva_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ata tina Elisabet bokai ipile, “Iei, moaki tama ara kabuleakini! Zon kamabuleakini.” ");
INSERT INTO mva_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Be di dikatu be bokai dirai, “Dara nem tago teke ara bokainaina!” ");
INSERT INTO mva_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kodeka lumadia-ba ane be natu-muku tama Sakarias ditegi be ono dakaua kana ara nangata masa natu-muku ngabuleakini. ");
INSERT INTO mva_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Be Sakarias itaguraki be patu-baba ono gerenga ikeliaki be bokai igere, “Ara Zon.” Tamoata be aine makara disoaki kaba bokai dita nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Makara nge oaikiki-tina Sakarias meme itarube be aoa itakaka be kaba ipilepile. Be itaguraki be Nanaranga ara irakeaki. ");
INSERT INTO mva_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sakarias anua-budu-ruanga kaba bokai dita nge dipitilaki-tina be tago sesu ba dipile. Be rangaka nge ege-ege Zudea buku kaba-lo dilako be tamoata be aine moarunga makara nge kana ngae Sakarias ipurani dirangarangaki. ");
INSERT INTO mva_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tamoata be aine moarunga kana ngae dilongoraki nge ilodia-ba dilelenaki be bokai ditegi, “Alauri masa natu ngae tamoata bakarairai ngapura?” Maka ma di dikaua Tanepoa kaiboang ne natu-muku ngaena-lo dieno. ");
INSERT INTO mva_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zon tama Sakarias nge Oli Spirit ilona-lo ikauri be itaguraki be pile mumuakadia-lo bokai ipile, ");
INSERT INTO mva_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tanepoa, Israel Nanaranga ne tarakeaki! Ambe ipura be tamoata be aine ne idumadi be izazadi be imuleakidi. ");
INSERT INTO mva_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Malipilipi kana Debiti tubu nena-lo ka Uketiketi ne kaiboangi teke inaguraki be muzigoala neda-lo tasoaki be iuketi-kita be imuleaki-kita. ");
INSERT INTO mva_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Toira be ‘propet’ ne kusidi-ratadi aoa-dialo be ipile-doi. ");
INSERT INTO mva_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ngai masa erekei neda luma-dio be ngauketi-kita, be tamoata disegesegeaki-kita masa lumadia-lo tasoaki be ngarubetaki-kita. ");
INSERT INTO mva_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ngai bokai ipile masa tubuda be tamada ilo ngatagadi be ngadumadi, be taoa ne rata toira tubuda zaiza iemaki nge ilo ngani. ");
INSERT INTO mva_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ngai tubuda Abaram pile tago tototo moimoibe irai. Bokai ka pilenga ngaedi nge ngaemaki be dakalingo kana. ");
INSERT INTO mva_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Erekei neda luma-dio be ngauketi-kita kana, be ono ngaemaki-kita be iboadu tago taburi-ralo be tamalipilipini. ");
INSERT INTO mva_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Izamaizama bong neda uia tasukoaki nge malipi ne mata ratadia-lo be mata adoadodia-lo be mata-nao taememaki.” ");
INSERT INTO mva_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Sakarias Nanaranga irakeakia-doi kodeka natu bokai irangaki, “Be kaiko natu-gu, alauri masa Nanaranga Atabalabala-tina ‘propet’ ne gopura. Masa Tanepoa aro gomua be zalaka gomoataungakini. ");
INSERT INTO mva_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Be tamoata be aine ne goradi be bokai dakaua: Muzigoala nedi Nanaranga irokakiledi masa ngauketadi be ngamuleakidi. ");
INSERT INTO mva_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nanaranga neda nge ilo itagataga-kita be malielie-ba ka ibabasaki-kita. Be anua-zamanga malamaka otioti masa ngaemaki be amari bokana lang anua-lo be odao ngarake. ");
INSERT INTO mva_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Be masa lang anua-lo be malamaka mate kaba-lo dalako be tamoata makara disukoaki odio ngabala. Be ae-da masa ngasingaradi be zala ono anua-uia ieno kanana-lo talako!” ");
INSERT INTO mva_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Alauri natu ngae ilaba nge tamoatana-lo be mariabakana-lo nge ikaiboang-tina. Be masaua kaba-lo isukoaki nibe ilako bong Israel lilidi-be-matadio mangata ipusika. ");
INSERT INTO mva_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Bong ngaradia-lo nge Rom ‘Sisa’ nedi Augustus pile inanga be tamoata be aine moarunga ungguma Rom erumadi disoaki nge aradi dadoraki kana. ");
INSERT INTO mva_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ara adoraki ngae nge matamatanatuka bong Sairinius, Siria kaba biabiadi nedi bokana isoaki be diemaki. ");
INSERT INTO mva_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bokaibe tamoata be aine moarunga nge tubudi anua nedia-lo dilako be aradi dadoraki kana. ");
INSERT INTO mva_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Bokaibe Iosep nge Nasaret anua ege Galili kaba-lo ka itui be ilako anua ara Betlem, ege Zudea kaba-lo be ara dadoraki kana. Betlem nge Debiti anua ne, be Iosep nge Debiti tubu be dara ne kata. ");
INSERT INTO mva_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Be roa rarauam Maria nge dialale-buduru be ara-diaru dadoraki kana. Maria nge ambe bong ne ono nekinga dipura. ");
INSERT INTO mva_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bokaibe makara Betlem-lo disoakiru be ineki. ");
INSERT INTO mva_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Be natu moane muamuatuka inekiaki be kusi zirezire ane isukumi be ‘bulumakau’ taramogida kandia-lo inangalako. Bakara, pera dizazaza be ono soaki be eno ipurapura nge dikauri. Bokai ka ‘bulumakau’ pera kandia-lo ineki. ");
INSERT INTO mva_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Oabubu ngarana-lo nge ‘sipisipi’ akolakola alu makara ege ngarana-lo ‘sipisipi’ nedi dinaringdi be disoaki. ");
INSERT INTO mva_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Makara nge Tanepoa ‘enzel’ ne teke ipurakadi be Tanepoa kaiboang be malama ne odio dibala be diboalingdi. ‘Sipisipi’ akolakola kaba bokai dita nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ata Tanepoa ‘enzel’ ne bokai ipile, “Taburi-ming moaki dira! Ngau pile uia ka ueluaki-kaming. Pile uia ngaedi masa tamoata be aine moarunga daemakidi be suridi dauia! ");
INSERT INTO mva_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kaituka Debiti anua nena-lo nge Uketiketi neming nekiaka ipura. Ngai ka Kristus Tanepoa. ");
INSERT INTO mva_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kilala ne ono kamakauataki kana nge bokai: Natu-muku teke kusi mapaladi zirezire ane disukumi be ‘bulumakau’ taramogida kandia-lo ieno masa kamate.” ");
INSERT INTO mva_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Makara nge oaikiki-tina Nanaranga ‘enzel’ ne lang anua-lonalona nge kokoko-tina dipura be ‘enzel’ ngae zaiza Nanaranga ara dirakerakeaki be bokai dipilepile, ");
INSERT INTO mva_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nanaranga etatabalabalatuka lang anua-lo isoaki nge ara tarakeaki! Be kateka-o nge tamoata maka Nanaranga ireretakidi nge ilo-uia ngaenodi!” ");
INSERT INTO mva_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Alauri ambe Nanaranga ‘enzel’ ne lang anua-lo dilako nge ‘sipisipi’ akolakola bokai dipile, “Talale Betlem-lo be kana ipura be Tanepoa ira-kita nge tate.” ");
INSERT INTO mva_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bokaibe ditui be oaikiki-tina dialale be Maria be Iosep dite-diaru. Natu-muku nge ‘bulumakau’ taramogida kandia-lo ieno be dite, ‘enzel’-la iradi bokana. ");
INSERT INTO mva_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","‘Sipisipi’ akolakola natu-muku ngae dite kodeka ditaguraki be alauri masa natu ngae bakarairai ngapura kana nge tamoata makara disoaki diradi, ‘enzel’-la iradi bokana. ");
INSERT INTO mva_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","‘Sipisipi’ akolakola dipilepile be tamoata be aine moarunga pilengadi dilongo nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ata Maria kana ngaedi moarunga ilona-lo inanga be ilonaba-lo ilelelenaki. ");
INSERT INTO mva_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kodeka ‘sipisipi’ akolakola ditaguraki be Nanaranga ara atabala-tina dinanganangai be dirakerakeaki be dimule. Kana moarunga dilongo be dita nge Nanaranga-la ‘enzel’ ne iradi bokana dita. ");
INSERT INTO mva_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Amaridi lima-toli dimanubu nge natu-muku kusi korototoka ipura be ara Iesus buleakini ipura. Tago isi nekiaka ipura be ara ngae Nanaranga ‘enzel’ ne inangani. ");
INSERT INTO mva_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Moses Mata ne bokai dipile: aine itaruru nge ibolo bokana. Bokaibe Moses Mata ne datagadi be taruru bolo ngaedi nge darokakile. Nge bokai ka bong Maria taruru bolo dirokaki-le nge Iosep be natu-muku Iesus zaiza be Ierusalem dilakoto. Be makara ka tabataba ono bolo rokaka daemaki be ono moarunga dakaua Maria ambe igoaza, Tanepoa-la ipile bokana, “Bune rua ki baliboro sauadi rua,” tabangakadi dapura. Be kana takaia daemaki kana nge natu-muku Iesus nge Nanaranga databangakani kana, Tanepoa-la ipile bokana, “Natu-muku moane ipuratuka-mua nge Tanepoa ania ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Makara Ierusalem-lo nge kamoangbiabia teke isoaki ara Simion. Ngai nge tamoata adoado be Nanaranga imatakutakuri, be bong ono Israel uketa be muleaka ngapura kana nge irarapung. Oli Spirit nge tamoata ngaena-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bokaibe Oli Spirit ambe norane be Simion pile mangata bokai inangani, “Tago iboadu oaikiki-la be gomate. Tanepoa Kristus ne moimoibe irangaki nge gote noko gomate.” ");
INSERT INTO mva_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Makara nge Oli Spirit itaguraki be Simion ibagai be Nanaranga pera nena-lo ilakuaki. Be bong Iosep be Maria natu-muku Iesus dieluakiaru be Moses Mata ne dataga-diaru be natu-muku databangakiaru kana nge ");
INSERT INTO mva_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion itaguraki be natu-muku lumana-lo idoki be Nanaranga iperui be bokai ipile, ");
INSERT INTO mva_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tanepoa! Kodeka malipilipi kanam ngae ilo-uia ane be golikitaki be ngamate, norane be moimoi be kupile bokana. ");
INSERT INTO mva_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Negu matagu-lo be tamoata maka tamoata be aine moarunga ono gouketidi be gomuleakidi kana nge ute. ");
INSERT INTO mva_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kana ngae nge tamoata be aine moarunga matadi-o be kumoataungaki be ieno. ");
INSERT INTO mva_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ngai nge malama kata, be masa nem-la be Ungguma Takadia-lo mangata gonangai be date. Be tamoata be aine nem Israel masa ara biabia-tina dadoki.” ");
INSERT INTO mva_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simion natu-muku ngae bokai irangaki nge tina be tama dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Kodeka Simion itaguraki be imaroudiato be natu-muku tina Maria bokai irai, “Natu-muku ngaeni nge matamata be nangaia ipura masa tamoata be aine kokoko-tina Israel-lo ngaemakidi be datapulo, be kokoko-tina masa ngaemakidi be damarang. Ngai nge kilala ono Nanaranga nena-la mangata inanga bokana, be tamoata kokoko-tina masa dare-kaini. ");
INSERT INTO mva_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Be pile nedi zumzumkaki masa mangata ngapile. Be kaiko masa ilom nganodo-tina, suri asi ono eunga mata sagode kaboakim nganagutobai bokana.” ");
INSERT INTO mva_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aine ‘propet’ teke isoaki ara Ana. Tama ara Panuel, bagi ne Ase. Ana nge ambe iainebia-tina. Moane teke iuati, ata barasi lima-rua-la disoaki-buduru be moane imate. ");
INSERT INTO mva_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Be narenare-ba bokai isukoaki nibe barasi ne ambe ‘84’ moarunga. Nanaranga pera ne tago sesu iperepereki. Ariata be oabubu moarunga nge Nanaranga irakerakeaki, iraborabo be kangkang iziraurau. ");
INSERT INTO mva_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bong-tina ono Iesus ambe Nanaranga pera nena-lo lakuaka ipurapura nge Ana ipura be Nanaranga iperui. Kodeka itaguraki be natu-muku ngae idoki be bong ono Ierusalem tamoata be aine moarunga Nanaranga ngazazadi be ngarubetakidi kana nge irangaki. ");
INSERT INTO mva_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Alauri be Iosep be Maria kana moarunga Tanepoa-la Mata ne dipile bokana diemakiru kodeka anua nediaru Nasaret, ege Galili kaba-lo dimulelakoru. ");
INSERT INTO mva_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Be natu-muku ngae ilaba be ikaiboang. Kaua malaidi nge ilona-lo dikauri-tina, be Nanaranga marou ne bibia-tina nge natu ngaenao dieno. ");
INSERT INTO mva_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Barasi moarunga ilodia-lo nge Iesus tina be tama Ierusalem dilakolakoru be ‘Pasoba’ moanako dirakerakeakiaru. ");
INSERT INTO mva_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bokaibe bong Iesus barasi ne ambe kulemoa-be-rua nge ‘Pasoba’ moanako-lo dilako-buduto, barasi moarunga-lo dimuzimuzi bokana. ");
INSERT INTO mva_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Alauri moanako biabia ngae imanubu nge tina be tama dimuleru, ata Iesus Ierusalem-lanalo isoaki. Ata tina be tama tago dikauaru ngai Ierusalem-lanalo isoaki. ");
INSERT INTO mva_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ilo-diaru dipile tamoata be aine takadi maradi ialalale, be dialale be ambe amari teke dimambuaki. Makara nge dilakoru be dara ne-diaru be ruanga-diaru maradi dilelearu. ");
INSERT INTO mva_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dilelearu be tago ditearu nge kababe Ierusalem-lo dimuleru be dalelearu kana. ");
INSERT INTO mva_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Makara Ierusalem-lo dilelelearu nibe amaridi tolia-nao be Nanaranga pera nena-lo ditearu. Iuda ‘tisa’ nedi maradi isoaki be ilolongoridi be itegitegidi be ditearu. ");
INSERT INTO mva_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tamoata moarunga makara disoaki dilongori Iesus kauanga dilaba be tegitegi moarunga katungadi iamang-tina nge dikabakia-tina. ");
INSERT INTO mva_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Bokaibe bong tina be tama makara ditearu nge dipitilaki-tinaru. Kodeka tina ilako be bokai irai, “Natugu, nge bakara ka bokai kubasaki-kamairu? Tamam keru ilo-mairu dibukutakiko-tinaru ka kileleleikoru!” ");
INSERT INTO mva_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Be Iesus ikatu be bokai iradiaru, “Bakara ka kaleleleauru? Tago kakauaru ngau Tamagu-la pera kanana-lo msukoaki kana?” ");
INSERT INTO mva_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ata diaru pile ngaedi labudi tago dikauatakiru. ");
INSERT INTO mva_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kodeka Iesus itui be itaga-diaru be Nasaret dilakoto. Makara Nasaret-lo nge pilenga-diaru ilongolongo-tina. Ata tina nge kana moarunga ngaedi ilona-lo inanga be idokimatedia-tina uia. ");
INSERT INTO mva_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Be bong Iesus ilabalaba nge kaua malaidia-lo nge iboadu-tina. Be Nanaranga be tamoata moarunga ilo-rere nedi nge Iesus-o dieno. ");
INSERT INTO mva_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Taibirias nge ambe barasi kulemoa-be-lima Rom ‘Sisa’ nedi bokana isoaki. Bong ngaradia-lo nge Ponsius Pailot, Zudea kaba biabiadi nedi bokana isoaki, be Erot nge Galili kaba lasa-tanepoa kandi bokana isoaki. Erot tari Pilip nge Ituria kaba be Trakonaitis kaba lasa-tanepoa kandi bokana isoaki. Be Laisinias nge Abilini kaba lasa-tanepoa kandi bokana isoaki. ");
INSERT INTO mva_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Be Ananias be Kaiapas nge tamoata Nanaranga ditabatabai bibiatuka nedi bokana disoakiru. Bong ngaradia-lo nge Sakarias natu Zon masaua kaba-lo isoaki be Nanaranga pilenga dipurani. ");
INSERT INTO mva_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Bokaibe ialale be kaba moarunga Zodan zagura zagenao dieno-lo bokai isulesule be ialalale, “Ilo-ming kamabuiri be muzigoala neming kamasegeaki, be ruku ono tamalinga ane rukua-ming dapura! Bokai masa Nanaranga muzigoala neming ngarokakile-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","‘Propet’ ara Aisaia-la ‘Buku’ nena-lo igere bokana, “Malonga teke masaua kaba-balo bokai ikilaulau, ‘Tanepoa zalaka kamamoataungakini. Zala adoadodi kamaemaki be odio ngalale. ");
INSERT INTO mva_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ilokadi bibia moarunga kamataununuri be dado. Bukudi bibia be sisiki moarunga kamaka-babadi be dado. Zala bokaudi nge kamadoraki be dado, be zala sisiki dikatipoa-ramo nge kamadoraki be dauia. ");
INSERT INTO mva_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Be tamoata be aine moarunga masa Nanaranga malipi iemaki be ono tamoata moarunga iuketidi be imuleakidi nge date.’” (Ais 40:3-5) ");
INSERT INTO mva_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Makara be tamoata be aine dum bibia-tina dipura be ruku ono tamalinga ane be Zon ngarukudi kana. Zon kaba bokai ita nge bokai iradi, “Kam moata goalakadi ulunga kaoa! Naita ira-kaming kam kaboadu Nanaranga nama ratinga ambe ngapura kana nge kamairatui? ");
INSERT INTO mva_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ilo-ming kabuiri be muzigoala neming kasegeaki nge mangata ma kamaemaki be teadi dapura kam ambe muzigoala neming kasegeaki! Be moaki kataguraki be neming-la mara-ming bokai kapile, ‘Abaram nge keka tubuma,’ ngena masa moatubu ngaedi kamairatudi! Tagona-tina iboadu! Ngau ka ura-kaming! Nanaranga iboadu patu ngaedi ngadoki be Abaram tubu ne ngapurakidi. ");
INSERT INTO mva_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ogi ambe kai labudia-lo ikatiuana be ieno, be ono kai ziri-dialo poloadialako dapura kana. Kai moarunga kalingodi tago uia dipupuraki masa poloadi be eoa-lo rokakadialako dapura.” ");
INSERT INTO mva_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Makara nge tamoata be aine ditaguraki be bokai ditegi, “Bokai nge masa rakana gaemaki?” ");
INSERT INTO mva_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Be Zon ikatu be bokai iradi, “Tamoata naita kusi-sili ne rua dienoni nge takaia tamoata kusi-sili ne tagotago ngani. Tamoata naita kangkang kana otioti nge nganege.” ");
INSERT INTO mva_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Be tamoata ‘tagisi’ dokidoki alu dipura be ruku ono tamalinga ane ngarukudi kana nge bokai ditegi, “‘Tisa,’ be keka rakana gaemaki?” ");
INSERT INTO mva_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Be Zon ikatu be iradi, “‘Tagisi’ kadokidoki nge bibiadi neming dira-kaming-la bokana kamadokidoki. Moaki atabala kalako be rerenga-minglo ‘tagisi’ bibia-la be kadokidoki!” ");
INSERT INTO mva_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kodeka koai-bagi tamoata alu dipura be bokai ditegi, “Be keka? Masa rakana gaemaki?” Be Zon ikatu be bokai iradi, “Tamoata takadi ‘mone’ nedi moaki kadokiraperapeledi, be moaki ramoramo-ba tamoata giriki odio kananganangalako. Be zazanga neming dianang-kaming nge suri-ming dauiauiataki.” ");
INSERT INTO mva_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Makara nge tamoata be aine moarunga ilodi dimarang be ilodi bokai dilelelenaki, “Masa Zon ka Kristus?” ");
INSERT INTO mva_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ata Zon kilala iung bokana bokai iradi, “Ngau dang-ba ane ka ruku ono tamalinga ane uruku-kaming. Ata tamoata teke kaiboang ne ngau kaiboang negu diuasadi masa ngapura. Ngau erumaruma-tina! Ngau tagona-tina uboadu ae-sukuma ne oarigedi mrube. Ngai masa Oli Spirit kulubobi be eoa ane be ruku ono tamalinga ane ngaruku-kaming. ");
INSERT INTO mva_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Taramang ono niu kozoma ne idokidoki. Masa niu ngakozo be kalingodi ngadoki be pera nena-lo ngakoazalaki, ata zipidi masa eoa tago matemate ane ngabulai.” ");
INSERT INTO mva_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zon nge pile kokoko ane be Pile Uia mangata irangarangaki, be ono tamoata be aine moarunga gang iunungdi be ono muzigoala nedi dasegeaki kana. ");
INSERT INTO mva_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ata Zon itaguraki be lasa-tanepoa nedi Erot iebuloi. Bakara, Erot nge tari Pilip roa ara Erodias iuati, be muzi goalakadi kokoko takadi nge iemaki. ");
INSERT INTO mva_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Be ono muzigoala ne ibatadi nge itaguraki be Zon uaura-lo inangai. ");
INSERT INTO mva_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bong Zon tamoata be aine moarunga ruku ono tamalinga ane irukudia-doi kodeka Iesus irukui. Iesus rukuia ipura be iraborabo nge lang itakaka, ");
INSERT INTO mva_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","be Oli Spirit nge ne tamoata-nalo be mang bune bokana be ono ibala. Be malonga teke lang-lo bokai ipile-ria, “Kaiko ngau Natu-gu! Ngau urereretakiko-tina, be ilogu iuiatakiko-tina!” ");
INSERT INTO mva_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Iesus ambe barasi ne kulemoadi-toli be malipi ne imarangaki. Tamoata be aine ilodi dipile ngai nge Iosep natu. Iosep nge Eli natu, ");
INSERT INTO mva_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli nge Matat natu, Matat nge Libai natu, Libai nge Melkai natu, Melkai nge Zanai natu, Zanai nge Iosep natu, ");
INSERT INTO mva_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Iosep nge Matataias natu, Matataias nge Aimos natu, Aimos nge Neum natu, Neum nge Eslai natu, Eslai nge Nagai natu, ");
INSERT INTO mva_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nge Mat natu, Mat nge Matataias natu, Matataias nge Semen natu, Semen nge Zosek natu, Zosek nge Zoda natu, ");
INSERT INTO mva_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda nge Zoanan natu, Zoanan nge Resa natu, Resa nge Zerubabel natu, Zerubabel nge Sealtiel natu, Sealtiel nge Nerai natu, ");
INSERT INTO mva_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai nge Melkai natu, Melkai nge Adai natu, Adai nge Kosam natu, Kosam nge Elmadam natu, Elmadam nge Er natu, ");
INSERT INTO mva_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er nge Zosua natu, Zosua nge Elieza natu, Elieza nge Zorim natu, Zorim nge Matat natu, Matat nge Libai natu, ");
INSERT INTO mva_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai nge Simion natu, Simion nge Zuda natu, Zuda nge Iosep natu, Iosep nge Zonam natu, Zonam nge Eliakim natu, ");
INSERT INTO mva_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim nge Melea natu, Melea nge Mena natu, Mena nge Matata natu, Matata nge Zonatan natu, Zonatan nge Debiti natu, ");
INSERT INTO mva_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Debiti nge Zesi natu, Zesi nge Obed natu, Obed nge Boaz natu, Boaz nge Samon natu, Samon nge Nason natu, ");
INSERT INTO mva_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason nge Aminadab natu, Aminadab nge Admin natu, Admin nge Ani natu, Ani nge Ezron natu, Ezron nge Perez natu, Perez nge Zuda natu, ");
INSERT INTO mva_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda nge Zekop natu, Zekop nge Aisak natu, Aisak nge Abaram natu, Abaram nge Tera natu, Tera nge Neo natu, ");
INSERT INTO mva_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neo nge Serug natu, Serug nge Reu natu, Reu nge Pelek natu, Pelek nge Ebe natu, Ebe nge Sela natu, ");
INSERT INTO mva_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela nge Kainan natu, Kainan nge Apaksad natu, Apaksad nge Sem natu, Sem nge Noa natu, Noa nge Lamek natu, ");
INSERT INTO mva_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nge Metusela natu, Metusela nge Inok natu, Inok nge Zared natu, Zared nge Maelalil, natu Maelalil nge Kenan natu, ");
INSERT INTO mva_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan nge Inos natu, Inos nge Set natu, Set nge Adam natu, be Adam nge Nanaranga natu. ");
INSERT INTO mva_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Bong Iesus Zodan zagura-lo ruku ono tamalinga ane rukuia ipura be imule nge Oli Spirit ilona-lo ikauri-tina. Be makara be Oli Spirit itaguraki be Iesus ibagalako masaua kaba-lo, ");
INSERT INTO mva_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","be makara amaridi kulemoadi oati isoaki be Satang itaguraki be itoitoi. Bong makara masaua kaba-lo isoaki nge kangkang tagotago isoaki. Bokaibe toitoi ngaedi muridi nge ambe tole imate. ");
INSERT INTO mva_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kodeka Satang itaguraki be Iesus bokai irai, “Kaiko Nanaranga Natu nge patu ngaedi goradi be databuli be kangkang dapura.” ");
INSERT INTO mva_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Be Iesus ikatu be bokai ipile, “Nanaranga ‘Buku’ ne bokai ipile, ‘Tamoata tago masa kangkang-ba ngakangkang be ngasukoaki.’” (Diut 8:3) ");
INSERT INTO mva_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kodeka Satang itaguraki be Iesus etatabala-tina ibagalako kaba tekedia-lo be anua be kaba moarunga kateka-o dieno nge kaituka-tina-la itikini be ita. ");
INSERT INTO mva_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Be Satang bokai ipile, “Anua be kaba moarunga ngaedi ambe aniagu-doi dipura, be iboadu rerengagu-lo naita miani kana nge miania-ba. Ngau uboadu kaba moarunga ngaedi be kaiboang ono pananuakadi nedi miangko. ");
INSERT INTO mva_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bokaibe tukum-o kurokazokuria be kurakeaka masa nem-doi aniam dapura!” ");
INSERT INTO mva_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Be Iesus ikatu be bokai ipile, “Nanaranga ‘Buku’ ne bokai ipile, ‘Nanaranga nem Tanepoa-la ka gorakerakeaki be ngaia-la ka gomalipilipini.’” (Diut 6:13) ");
INSERT INTO mva_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kodeka Satang itaguraki be Iesus ibagalako Ierusalem-lo be Nanaranga pera ne atabalanatuka inangai be bokai irai, “Kaiko moimoi be Nanaranga Natu nge nem-la be ea gorokakikolako. ");
INSERT INTO mva_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Maka ma Nanaranga ‘Buku’ ne bokai ipile, ‘Nanaranga masa kaiko kanabe ‘enzel’ ne nganepidi be danarinaringiko uia. ");
INSERT INTO mva_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Be masa luma-di ane be dasabosaboiko. Bokai masa aem-baba tagona-tina patu-o gototoki.’” (Sam 91:11-12) ");
INSERT INTO mva_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Be Iesus ikatu be bokai ipile, “Nanaranga ‘Buku’ ne bokai ipile, ‘Nanaranga nem Tanepoa moaki kutoi.’” (Diut 6:16) ");
INSERT INTO mva_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satang toitoi moagili-moagili ane be Iesus itoi be kodeka ialale be bong iauia teke irapurapungi be kaba Iesus ngatoi kana. ");
INSERT INTO mva_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kodeka Iesus kaba Galili kaba-lo imulelako. Be Oli Spirit kaiboang ne nge Iesus-lo dieno. Bokaibe Iesus rangaka nge ege-ege anua be kaba ngara-dialo dilako. ");
INSERT INTO mva_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Makara be pera nedi ono serereinga-lo isulesuledi be moarunga-tina dilongori nge ara dirakeaki. ");
INSERT INTO mva_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kodeka Iesus itui be Nasaret anua-lo ilako. Makara ka ilaba be itamoata. Bong ono manauanga ‘Sabat’ tekenao nge pera nedi ono serereinga-lo isili, izamaizama imuzimuzi bokana. Ituirake be ngaleze kana ");
INSERT INTO mva_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","nge ‘propet’ ara Aisaia ‘Buku’ ne diani be ngaleze kana. Kodeka itaguraki be ‘Buku’ iuasari be gere ngaedi ita be ileze, ");
INSERT INTO mva_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“‘Tanepoa Oli Spirit ne nge oguo isoaki, bakara ngau ka inangaia be tamoata kana nedi tagotago Pile Uia mangata mrangakadi kana. Tanepoa inepia be kana ngaedi memaki kana: Tamoata uaura-lo disoaki nge rubetaka muzi mangata mrangakadi, matadi leuadi nge miadorakidi be kaba daitaita, tamoata sururu bibia didokidoki nge mrubetakidi, ");
INSERT INTO mva_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","be barasi ono Tanepoa tamoata be aine ne ngauketidi kana nge mangata mrangakadi.’” (Ais 61:1-2) ");
INSERT INTO mva_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ileze-doi nge ‘Buku’ iono be tamoata makara imalipilipi iani be isoakiria. Tamoata be aine makara pera ono serereinga-lo disoaki nge matadi ngaia-doio dinanga bokana ");
INSERT INTO mva_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","itaguraki be bokai iradi, “Kaituka Nanaranga ‘Buku’ ne kili ngae nge ambe emaka ipura be ikalingo, kalongo-la bokana.” ");
INSERT INTO mva_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tamoata be aine makara disoaki nge Iesus dimakaraia-tina, be pile aoa-nalo dipusika nge dikabaki-tina. Ata bokai dipile, “Ngai ka Iosep natu ki taila?” ");
INSERT INTO mva_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Be Iesus ikatu be bokai iradi, “Moimoina-tina pile kara-mumuakadi ngaedi ane be masa kamaraia, ‘Karai tatate! Nem-la be goaka-uiakiko.’ Be pile takadi masa bokai kamaraia, ‘Kana maka Kaperneam anua-lo kuemaki be kilongoraki nge makare anua-tina nem-lo goemaki.’” ");
INSERT INTO mva_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iesus kaba pile ne bokai ibatadi, “Moimoi ka ura-kaming! ‘Propet’ anua-tina nena-lo nge tago iboadu molataka ngapura. ");
INSERT INTO mva_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Kamalongo! Moimoina-tina Ilaiza bong nena-lo nge ura tago sesu ipura barasi toli be kapapadi ilodia-lo. Bokaibe tole kanabiabia-tina kaba moarunga-lo ipura. Be bong ngaradia-lo nge narenare kokoko-tina Israel kaba-lo disoaki. ");
INSERT INTO mva_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ata bong Ilaiza nepia ipura nge tago ilako narenare ngaedi katana-lo. Tago-la. Nepia ipura nge ilako Zarepat anua-lo, ege Saidon kaba-lo, be narenare teke makara isoaki-lo ilako. ");
INSERT INTO mva_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Be bokainatuka-la, ‘propet’ ara Ilaisa bong nena-lo nge tamoata kikiri dokiadi kokoko-tina Israel-lo disoaki. Ata tago teke aka-uiaka ipura. Siria-la tamoata Neman ka aka-uiaka ipura.” ");
INSERT INTO mva_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tamoata be aine makara pera ono serereinga-lo disoaki pile ngaedi dilongo nge namadi dira-tina. ");
INSERT INTO mva_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kodeka dituirake be Iesus ditaoni be eluku dilakuaki be anua ipereki. Be dilakuaki be buku-makinga ono anua kelia ipura zagedi-o be melu-lo darokakalako kana. ");
INSERT INTO mva_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ata Iesus itaguraki be maradi isili be ialale, be anua ngara ipereki. ");
INSERT INTO mva_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kodeka Iesus ialale be Kaperneam anua-lo ipura. Anua ngae nge ege Galili kaba-lo ka ieno. Be bong ono manauanga ‘Sabat’-o nge ilako pera nedi ono serereinga-lo be tamoata be aine isuledi. ");
INSERT INTO mva_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tamoata be aine sulenga dilongo nge dipitilaki-tina be sulenga dikabaki. Maka ma pilenga nge dikaiboang-tina be malamakadi otioti. ");
INSERT INTO mva_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Makara pera ono serereinga-lo nge tamoata teke isoaki. Mariaba goala teke mariabaka nge tamoata ngena-lo isoaki. Kodeka tamoata ngae kaikai-la imere be bokai ipile, ");
INSERT INTO mva_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Aa! Iesus, Nasaret tamoata! Ba gobasaki-kama kana? Gogamang-kama kana ka kupura ki? Ngau ukaua kaiko naita kata. Kaiko nge Nanaranga tamoata ne, be Kusim Rata!” ");
INSERT INTO mva_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Be Iesus itaguraki be mariaba goalaka nge kaikai-la bokai irai, “Aoam gonoti, be tamoata ngarana-lo gopusika!” Kodeka mariaba goalaka ngae nge itaguraki be tamoata ngae makara moarunga arodi kateka-o irokakaria be ipusika be iratu. Bong mariaba goalaka ngae tamoata ngae kateka-o irokakaria nge tamoata ngae tago sesu kania teke ba iuai. Ne iauia-la. ");
INSERT INTO mva_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tamoata be aine makara disoaki nge dipitilaki-tina be nedia-la bokai dipile, “Nge rakana sule kaoa? Maka ma kaiboang ne nge dikai-tina be pilenga nge malamakadi otioti be mariaba goalakadi ipile-kaikaidi be dilongolongori!” ");
INSERT INTO mva_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Bokaibe Iesus rangaka nge ege-ege kaba ngaradia-lo dilako. ");
INSERT INTO mva_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesus pera ono serereinga ipereki be Saimon pera kanana-lo ilako. Saimon roa tina nge more kusi-ragogo igoalangakia-tina be bokai ieno. Bokaibe Iesus dirai be ngadumai kana. ");
INSERT INTO mva_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bokaibe Iesus ilako be atabala iboadukulako be more iebuloi be more ileuani. Makara nge Saimon raua oaikiki-tina imarang be kangkang iemakadi. ");
INSERT INTO mva_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Amari ambe itaoio nge tamoata be aine ditaguraki be tamoata more bakarairai-bakarairai odio dieno nge Iesus-lo dieluakidi. Be Iesus luma odio inangaria, be moarunga luma odio inangaria nge iaka-uiadi. ");
INSERT INTO mva_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Be mariaba goalakadi nge kaba tamoata kokoko-tina-lo be dipusika. Be bong dipusikasika nge bokai dimeremere, “Kaiko Nanaranga Natu!” Ata Iesus itaguraki be iebulodi be tago ilikitakidi be sesu muku dipile. Maka ma mariaba goalakadi dikaua ngai ka Kristus. ");
INSERT INTO mva_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Anua izama nge anua ipereki be ilako kaba tekedi rubediaba-lo. Ata tamoata be aine dilelelei nibe dite. Dite nge diakoroi be bokai dirai, “Kaba ngaedi moaki kupereki.” ");
INSERT INTO mva_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ata Iesus bokai iradi, “Pile Uia ono Nanaranga ngatanepoa kana nge tago makarena-la ka mangata mrangaki kana. Anua takadia-lo mangata mrangaki kana be. Bokai muzi kana ka Nanaranga inepia be upura.” ");
INSERT INTO mva_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Bokaibe ege-ege kaba ngaradia-lo nge pera nedi ono serereinga-lo isulesuledi be ialalale. ");
INSERT INTO mva_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bong teke Iesus dang boakuboaku biabia ara Genesaret zagenao ituitui nge tamoata be aine dipura be dirokateteki be saringa dalako be Nanaranga pilenga dalongo kana. ");
INSERT INTO mva_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Makara ituitui nge kati rua kabu-lo diele-oro be dieno nge ita. Tamoata ika dokidoki kaoa ka diele be dieno, be dilako be raka kandi diasasaki. ");
INSERT INTO mva_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Kodeka Iesus ilako be kati takaiana-lo isoakilako. Kati ono isoakilako nge Saimon ne. Bokaibe Iesus itaguraki be Saimon irai be kati ngae dang-lo ielealako be kabu mukuna-ba ipereki. Be makara kati-o isoaki be tamoata be aine isuledi. ");
INSERT INTO mva_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Isule-doidi, kodeka Saimon bokai irai, “Kati goelealako dang biatangana-lo be ruangam zaiza raka kana-ming kamarokakilako be ika kamadoki.” ");
INSERT INTO mva_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ata Saimon ikatu be bokai ipile, “Biabiadi, rodo oabubu-lo nge kimamalo-tina, ata ika tago teke kidoki. Ata nge kaiko kupile bokana masa raka kaba ganangalako.” ");
INSERT INTO mva_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Be bong raka dinangalako nge ika kokoko-tina didoki be raka kandi ambe dimasaresare. ");
INSERT INTO mva_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Bokaibe ruangadi kati takana-lo nge dikiladi be dadumadi kana. Dimai be ika kati ruoti ngae-diaru diau nge kati saringatuka dabulolo kana. ");
INSERT INTO mva_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita kaba bokai ita nge ilako Iesus aro tuku-nao irokazokuria be bokai ipile, “Tanepoa! Gopereka be goalale! Ngau muzigoala ememaki kata!” ");
INSERT INTO mva_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Maka ma Pita ruanga zaiza kaba bokai dita ika kokoko-tina didoki nge dipitilaki-tina be ba dapile. ");
INSERT INTO mva_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Be Saimon ruanga ruoti Zems be Zon nge bokaina-doi dipitilakiru. Zems be Zon nge Zebidi natu ruoti. Kodeka Iesus itaguraki be Saimon bokai irai, “Taburim moaki ira! Kaituka be ngalako masa tamoata godokidokidi!” ");
INSERT INTO mva_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Makara nge kati kabu-lo dielelako be kana nedi moarunga dipereki be Iesus ditagai. ");
INSERT INTO mva_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bong teke Iesus anua tekena-lo isoaki nge tamoata teke kikiri dokia ipura. Bong tamoata ngae Iesus ite nge lili kateka-lo inangalako be bokai iakoroi, “Biabiadi, kusumoala nge bolo oguo dieno gorokaki be mgoaza!” ");
INSERT INTO mva_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Be Iesus luma inanaraki be tamoata ngae ono idauraki be bokai ipile, “Ngau usumoala! Gogoaza!” Makara nge oaikiki-tina kikiri dileuani. ");
INSERT INTO mva_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kodeka Iesus itaguraki be pile kakai oti be tamoata ngae bokai irai, “Golongo! Kana ngae nge moakina-tina teke kurangakani! Ata golako-soasoa be tamoata Nanaranga ditabatabai teke ngalilitiko. Ililitiko-doi nge goalale be tabataba ono goazanga Moses irangaki nge goemaki be ono moarunga dakaua kaiko ambe moimoi kugoaza.” ");
INSERT INTO mva_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ata Iesus rangaka nge kodeka dilaba-tina. Bokaibe tamoata dum bibia-tina dipura be pilenga dilongo be moremore iaka-uiakidi. ");
INSERT INTO mva_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ata bong kokoko nge Iesus kaba rubediaba-lo ilakolako be iraborabo. ");
INSERT INTO mva_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bong teke Iesus tamoata be aine isulesuledi nge Parasi alu be tamoata Moses Mata ne disulesuletaki alu dipura be makara maradi disoaki. Parasi be tamoata Moses Mata ne disulesuletaki ngaedi nge anua moarunga Galili kaba-lo be Zudea kaba-lo be Ierusalem anua-lo ka dipura. Be Tanepoa kaiboang ne nge makara dieno be ono Iesus iboadu moremore ngaka-uiakidi. ");
INSERT INTO mva_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kodeka tamoata alu tamoata teke kaulokuloku tapou matedi rara-lo dibazi be dipura be pera-lo dasiliaki be Iesus aro danangaria kana. ");
INSERT INTO mva_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ata tamoata be aine nge dikoko-tina be tago diboadu dasiliaki. Muzi dira bokana pera boadi-kounao dilako be boazinga teke diemaki be tamoata kaulokuloku nge ere-zirapu be earuma tamoata be aine maradi diurumalako Iesus aro. ");
INSERT INTO mva_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bong Iesus kaba bokai ita tamoata ngaedi lama diuni ngai iboadu tamoata kaulokuloku ngae ngadoraki nge bokai irai, “Ruanga, muzigoala nem ambe rokakadialeko dipura.” ");
INSERT INTO mva_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Makara nge Parasi be tamoata Moses Mata ne disulesuletaki nedia-la ilodia-lo bokai dipile, “Tamoata nge naita kata be Nanaranga ono imanai! Nanaranga-la ka iboadu muzigoala ngarokaki!” ");
INSERT INTO mva_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ata Iesus pile ilodia-lo dilelelenaki ngaedi nge ikauataki bokana bokai iradi, “Bakara ka pile bokainaina ilo-ming dianiandi? ");
INSERT INTO mva_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Pile nangatadi ka emakadi tago dira? ‘Muzigoala nem ambe rokakadialeko dipura,’ ki ‘Gotui be goalale?’ ");
INSERT INTO mva_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ata nge ono mitiking-kaming kana Tamoata Natu kateka ngaenao kaiboang ne dieno be iboadu-tina tamoata be aine moarunga muzigoala nedi ngarokakiledi!” Bokaibe tamoata kaulokuloku nge bokai irai, “Ngau ka uraiko! Gotuirake, zirapu nem godokitate be pera kanam-lo golako!” ");
INSERT INTO mva_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Makara nge tamoata ngae oaikiki-tina ituirake moarunga matadi-o be zirapu ne ibazidi be Nanaranga irakerakeaki be pera kanana-lo ilako. ");
INSERT INTO mva_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tamoata be aine moarunga makara disoaki nge dipitilaki-tina be Iesus dikabaki! Taburidi nge dira-tina be Nanaranga ara dirakeaki be bokai dipile, “Kana tailadia-ba kaituka taita!” ");
INSERT INTO mva_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kana ngaedi muridi nge Iesus ipusika be ialale. Ialalale nge tamoata ‘tagisi’ dokidoki teke ara Libai pera ne ono ‘tagisi’ dokinga-lo isoaki be ite. Kodeka Iesus itaguraki be bokai irai, “Gotagaia!” ");
INSERT INTO mva_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Iesus bokai ipile nge Libai itui be kana moarunga ipereki be itagai. ");
INSERT INTO mva_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Alauri nge Libai moanako biabia teke pera kanana-lo Iesus iemakani. ‘Tagisi’ dokidoki kokoko-tina be tamoata takadi nge disoaki-budu be dimoanakonako. ");
INSERT INTO mva_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ata Parasi alu be tamoata Moses Mata ne disulesuletaki Parasi kaoa makara disoaki nge ditaguraki be Iesus tagataga nena-lo ditotoi be bokai dipile, “Bakara ka ‘tagisi’ dokidoki be muzigoala ememaki zaiza kamoanakonako?” ");
INSERT INTO mva_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Be Iesus ikatu be bokai ipile, “Tamoata nedi uia tago iboadu karai tatate-lo dalako. Moremore-la ka dilakolako. ");
INSERT INTO mva_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngau tago tamoata adoadodi mkiladi kana ka upura. Tago. Ngau muzigoala ememaki ka mkiladi be ilodi dabuiri be muzigoala nedi dasegeaki kana ka upura.” ");
INSERT INTO mva_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tamoata alu ditaguraki be Iesus bokai dirai, “Zon tagataga ne bong kokoko kangkang diziraurau be rabo nedi Nanaranga ditabatabangakini. Be Parasi tagataga nedi bokai dimuzimuzi be. Ata kaiko tagataga nem nge moanako be dang sing-la kata ka diteate! Tago sesu kangkang dizirau!” ");
INSERT INTO mva_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Be Iesus ikatu be bokai ipile, “Iboadu tamoata teke kodeka-ka iroti lou ne goemakidi be moanako ono rotinga nena-lo kangkang tagotago dasoaki ki tago? Tago iboadu! ");
INSERT INTO mva_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ata bong tekedi masa dapura be ono moane kodeka-ka iroti nge bagaia ngapura be tago lou ne maradi ngasoaki. Bong ngaradia-lo kodeka lou ne masa kangkang dazirau.” ");
INSERT INTO mva_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kodeka Iesus itaguraki be pile ono tonanga ngaedi ane be bokai iradi, “Tamoata tago teke kusi oauoau teke mapala isereki be ono kusi muamua masarenga ioladi. Bokai imuzi masa kusi oauoau ngagamani, be kusi oauoau mapala idoki nge tago iboadu kusi muamua boazinga ngakazoami. ");
INSERT INTO mva_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Be tamoata tago teke ‘uain’ oauoau idoki be ‘uain’-kusi muamuana-lo inangalako. Bokai imuzi masa ‘uain’ oauoau ngadodoraki be ‘uain’-kusi muamua ngasereki be ‘uain’ ngamoasubu, be ‘uain’-kusi ngagoala. ");
INSERT INTO mva_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tago iboadu bokai ngamuzi! ‘Uain’ oauoau-la ka iboadu ‘uain’-kusi oauoau-lo nangalako ngapura. ");
INSERT INTO mva_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Be tamoata ‘uain’ muamua ising masa ‘uain’ oauoau sing ngasege be bokai ngapile, “‘Uain’ toiraira nge kababe iuia-tina, be ‘uain’ oauoau iuasai.” ");
INSERT INTO mva_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bong ono manauanga ‘Sabat’ tekenao nge Iesus ‘uit’ uma aluna-lo ialalale. Be tagataga ne nge ditaguraki be ‘uit’ kalingodi dikotokoto be lumadia-lo dipopoporaki be patudi dikangkang. ");
INSERT INTO mva_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parasi kaba bokai dita nge dipile, “Mata neda ibabari-kita tago iboadu bong ono manauanga ‘Sabat’-o bokai tamuzi! Nge bakara ka kam bokai kamuzimuzi?” ");
INSERT INTO mva_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Be Iesus ikatu be bokai iradi, “Bong Debiti ruanga zaiza tole dimate be Debiti kana iemaki nge kaleze ki tago? ");
INSERT INTO mva_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Debiti Nanaranga pera nena-lo isili be ‘bereti’ ambe Nanaranga ditabangakini nge idoki be ikang be alu ruanga iandi be dikang. Mata neda ibabari-tina ngai tago iboadu ‘bereti’ bokainaina ngakang. Tamoata Nanaranga ditabatabaia-la ka diboadu dakang.” ");
INSERT INTO mva_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kodeka Iesus pile ngaedi bokai imambuaki, “Tamoata Natu ka bong ono manauanga ‘Sabat’ nge Tanepoa ne.” ");
INSERT INTO mva_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bong ono manauanga ‘Sabat’ takaianao nge Iesus pera ono serereinga-lo isili be isulesuledi. Tamoata teke luma oana mate nge makara isoaki. ");
INSERT INTO mva_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Parasi be tamoata Moses Mata ne disulesuletaki nge labu teke date be ono Iesus giriki ono danangalako kana. Bokaibe dimatanangaia-tina uia bong ono manauanga ‘Sabat’-o moremore teke ngadoraki ki tago. ");
INSERT INTO mva_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ata Iesus ilodi ita be ikaua bokana tamoata luma mate nge bokai irai, “Gotuirake be tamoata moarunga arodi gotui.” Be tamoata ngae ituirake be moarunga arodi itui. ");
INSERT INTO mva_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kodeka Iesus bokai itegi, “Ngau mtegi-kaming kana! Mata neda bakara dira-kita? Bong ono manauanga ‘Sabat’-o masa rakana taemaki? Muzi uia ki muzi goalakadi taemaki? Tamoata tadumai be ngauia ki taumoatei?” ");
INSERT INTO mva_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Makara be igea-ramo be moarunga itedi, kodeka tamoata luma mate nge bokai irai, “Lumam gonanaraki!” Tamoata ngae luma inanaraki nge iuiani. ");
INSERT INTO mva_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ata Parasi be tamoata Moses Mata ne disulesuletaki namadi dira-tina be nedia-la maradi diepilei be ono Iesus ba dabasaki kana. ");
INSERT INTO mva_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bong ngaradia-lo nge Iesus buku-o ikautaki be ngarabo kana. Be makara Nanaranga iraboraboi nibe anua izama. ");
INSERT INTO mva_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Izama nge tagataga ne moarunga ikiladi be kodeka kulemoa-be-rua inangadi tagataga ne bokana. Be dialana-ma ka ‘apostel’ bokana inangadi. Tamoata ngaedi nge ");
INSERT INTO mva_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon (ara takaia ibuleakini Pita); Saimon tari, Endru; Zems; Zon; Pilip; Batolomiu; ");
INSERT INTO mva_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Tomas; Zems, Alpeas natu; Saimon maka Zilot kata; ");
INSERT INTO mva_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Iudas, Zems natu, be Iudas Iskariot. Iudas Iskariot ka alauri Iesus idoki be erekei luma-dio inangai. ");
INSERT INTO mva_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iesus tagataga ne ngaedi zaiza be eta buku-o ka ditaoio be kaba-baba tekedia-lo dipura. Makara dipura be dituitui nge tagataga ne kokoko-tina, be tamoata be aine dum kanabiabia Zudea kaba-lo be Ierusalem anua-lo, be anua makasi zage-o dienoru Saidon be Taia-lo nge dipura be makara disoaki. ");
INSERT INTO mva_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iesus sulenga dalongo be moremore ngaka-uiakidi kana ka dipura. Be tamoata be aine mariaba goalakadi ilodia-lo disoaki nge dipura be iadorakidi. ");
INSERT INTO mva_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kaiboang bibia nge Iesus-lo dipusikasika. Be moremore moarunga dipurapura nge ono didaudauraki be iaka-uiauiadi. ");
INSERT INTO mva_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iesus tagataga ne idededi kodeka bokai ipile, “Kam tamoata kana neming tagotago nge suri-ming dauia! Maka ma anua ono Nanaranga ngatanepoa kana nge kam neming. ");
INSERT INTO mva_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kam tamoata kaituka tole kamatemate nge suri-ming dauia! Maka ma alauri masa kamamoanako be kamadoli. Kam tamoata kaituka katangtang nge suri-ming dauia. Maka ma alauri masa kamaiao. ");
INSERT INTO mva_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Kam tamoata Tamoata Natu kanabe tamoata takadi disegeaki-kaming, ki dimurina-kaming, ki diebulo-kaming, ki tamoata goala kana dirangaki-kaming nge suri-ming dauia! ");
INSERT INTO mva_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bokai dibasaki-kaming nge suri-ming dauia be kama-gaki be kamanaulaki, bakara zazanga neming bibia-tina lang anua-lo dieno! Maka ma bokai kamakaua: tamoata ngaedi tubudi toirairadi nge ‘propet’ bokainatuka-la ka dibasakidi. ");
INSERT INTO mva_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ata kam tamoata kaituka kana neming kokoko nge kamakadoma-tina! Ambe-ma kaleua-re! Bakara, kana ono suri-ming diuiauia ambe kadoki-doi! ");
INSERT INTO mva_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kam tamoata kaituka kamoanakonako be kadolidoli nge kamakadoma-tina! Ambe-ma kaleua-re! Bakara, tole kamamate kana! Kam tamoata kaituka kaiaoiao nge kamakadoma-tina! Ambe-ma kaleua-re! Bakara, kamatangtang be kamanodonodo kana! ");
INSERT INTO mva_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kam tamoata maka tamoata takadi dipilepile kam tamoata uia nge kamakadoma-tina! Ambe-ma kaleua-re! Maka ma tubu-ming toirairadi nge ‘propet’ bolingadi ratadi bokai dibasakidi! ");
INSERT INTO mva_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ata tamoata pilengagu kalongo nge bokai mra-kaming kana: Erekei neming kamarereretakidi, be tamoata disegesegeaki-kaming nge muzi uia kamaememakidi. ");
INSERT INTO mva_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tamoata ingesuaki-kaming nge kamamaroui, be tamoata tago iadoadoraki-kaming nge ngai kanabe Nanaranga kamaraboraboi. ");
INSERT INTO mva_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Bokaibe tamoata teke poapoam takadi-o izamposaniko nge gobuiriko be egedi takadi-o ngazamposaniko. Tamoata teke angapi nem idoki nge luma-zokuzokuba malo nem goani be. ");
INSERT INTO mva_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tamoata teke kana tekena-lo isinauiko nge goania-ba, be tamoata teke kana nem kata ibagai nge moaki kaba kukeliaki! ");
INSERT INTO mva_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tamoata takadi baituka dababasaki-kaming kana karerere nge bokainatuka-la kamababasakidi. ");
INSERT INTO mva_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Tamoata direreretaki-kaming-la karereretakidi nge masa ulika iauia nangata kamadoki? Maka ma tamoata ‘muzigoala ememaki’ nge bokai dimuzimuzi! ");
INSERT INTO mva_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Be tamoata diuiauia-kaming-la kauiauiadi nge masa ulika iauia nangata kamadoki? Maka ma tamoata ‘muzigoala ememaki’ bokai dimuzimuzi be! ");
INSERT INTO mva_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tamoata teke kana teke kani be karere ngakatungi nge masa ulika iauia nangata kamadoki? Maka ma tamoata ‘muzigoala ememaki’ nge ‘muzigoala ememaki’ ruangadi kana dianiandi be katungadi ere-moarungadi be dadokidoki kana direrere! ");
INSERT INTO mva_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ata kam moaki bokai kamuzimuzi! Erekei neming kamarereretakidi, be mata uia kamaememakidi. Be kana neming tamoata takadi kandi nge moaki katungadi kana karerere. Bokai masa zazanga neming dalaba-tina, be Nanaranga Atabalabala-tina natu kamapura. Maka ma ngai nge tamoata maka tago diperuperui be tamoata muzingadi goalakadi nge ilo itagatagadi. ");
INSERT INTO mva_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tama-mingla ilo itagataga-kaming bokana tamoata takadi ilo-ming datagatagadi. ");
INSERT INTO mva_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tamoata takadi giriki nedi moaki kaliliti be kapile digoala. Bokai masa Nanaranga giriki neming tago ngaliliti. Tamoata takadi moaki moatubu odio kanangalako. Bokai masa Nanaranga tago giriki omingo nganangalako. Tamoata takadi muzigoala nedi karokakiledi masa Nanaranga muzigoala neming ngarokakile-kaming. ");
INSERT INTO mva_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tamoata takadi kana kamaniandi masa Nanaranga kana nganiang-kaming. Moimoina-tina masa kana kokoko-tina nganiang-kaming. Be kana ngaedi masa kokoko-la be nganiang-kaming nibe bagabaga dara-kaming. Kana moatubungadi bakarairai katagadi be tamoata takadi kana kandi nge Nanaranga masa kana moatubungadi bokainaina-la ngatagadi be kam kana ngang-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be Iesus pile ono tonanga ngaedi ane be bokai iradi, “Tamoata mata leuadi tago iboadu mata-leua ruanga zala ngaitikini. Zala itikini masa ruoti-doi be gimoa-lo dasapasilakoru! ");
INSERT INTO mva_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tamoata kodeka-ka itoto tago iboadu tamoata amangi atabala ngalako. Tago-tina! Tamoata-la tongaka ipura be iamang-tina ka iboadu tamoata amangi diaru iriringa-diaru tekedi. ");
INSERT INTO mva_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Bakara ka robuka muku teke taritokam matana-lo ieno nge kute, ata nem matam-lo nge kai-mapala biabia ilom tago iani? ");
INSERT INTO mva_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Masa baituka be taritokam bokai gorai, ‘Tarito, matam-lo robuka mukumukuna-tina mpasiki,’ ata nem matam-lo nge kai mapala biabia tago kute? Bolinga-ming ratadi! Kai mapala biabia nem matam-lo gopasiki be kaba goita uia noko taritokam matana-lo robuka mukumuku ieno nge gopasiki! ");
INSERT INTO mva_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kai iauia tago teke kalingo goalakadi ipupuraki. Bokainatuka-la, kai goalaka tago teke kalingo uia ipupuraki. ");
INSERT INTO mva_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kai teke-teke nge kalingodia-lo ka kauatakadi dipurapura. Paepae tago iboadu oakum-o ngapura. Bokainatuka-la, udi tago iboadu moamoaesa-o ngapura. ");
INSERT INTO mva_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tamoata iauia nge kolo-kolo iauia ilona-lo ikoazalaki ka ipasipasi-rake. Tamoata goalaka nge kolo-kolo goalaka ilona-lo ikoazalaki ka ipasipasi-rake. Bokai kamakaua: Kana bakarairai kaoa tamoata ilona-lo dikauri be dieno ka aoa-nalo dipusikasika. ");
INSERT INTO mva_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Bakara ka ‘Tanepoa, Tanepoa,’ kana kakilakilaia, ata kana urarangaki nge tago kaememaki? ");
INSERT INTO mva_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tamoata naita ngau-lo imai be pilengagu ilongo be itoatoaki nge bokainatuka ono mto be kamakaua: ");
INSERT INTO mva_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tamoata bokainaina nge tamoata teke pera ikelikeli bokana. Pera labu nganangai kana nge ikeli nibe patu-baba kateka ilona-lo ita be kodeka ono pera kaiboang ne inanga. Bokaibe bong ura ipura be dang dikauri nge nori bibia dipanana be pera ngae diuni. Diuni nge tago iboadu damoakusungaki, bakara, pera ngae nge ikaiboang-tina! ");
INSERT INTO mva_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ata tamoata pilengagu ilongo be tago itoatoaki nge tamoata pera kana kateka-ba kusinao ikeli bokana. Labu ono kainga ne tago. Bokaibe bong ura ipura be dang dikauri nge nori bibia dipanana be pera ngae diuni. Diuni nge itapulo, be ileua be imanubu!” ");
INSERT INTO mva_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesus pile ngaedi tamoata be aine iradia-doi, kodeka Kaperneam ilako. ");
INSERT INTO mva_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom koai-bagi pangana nedi teke tamoata eunung ‘100’ imuamuadi nge makara isoaki. Tamoata ngae malipilipi kana irereretakia-tina nge imore-tina be saringatuka ngamate kana. ");
INSERT INTO mva_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Rom tamoata ngae Iesus ilongoraki bokana Iuda tamoata bibia alu inepidi be dalako be Iesus darai be malipilipi kana ngaka-uiaki kana. ");
INSERT INTO mva_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kodeka Iuda tamoata bibia nge dilako Iesus-lo be diakoroia-tina be bokai dirai, “Ngai tamoata iauia-tina, be iboadu-tina godumai! ");
INSERT INTO mva_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ngai kita Iuda irereretakikita-tina, be iduma be pera nema ono serereinga nge ikeli.” ");
INSERT INTO mva_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bokaibe Iesus itagadi be dialale-budu. Iesus ilako be ambe pera isaringai nge Rom tamoata biabia ngae ruanga alu inepidi be bokai dirai, “Tanepoa, moaki nem-la kuilo-bukuiko! Ngau tago tamoata iauia kata be masa kaiko kuboadu pera kanagu-lo gosili. ");
INSERT INTO mva_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nge bokai ka tago negu-la be umai be uteko. Maka ma ngau tago tamoata iauia. Ata gopile-ba be malipilipi kanagu ngauia. ");
INSERT INTO mva_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bakara, ngau negu-la nge tamoata negu bibia erumadi ka usoaki, be koai-tamoata kokoko erumagu disoaki. Bokaibe ngae bokai mrai, ‘Golako,’ be ngalako. Be ngara bokai mrai, ‘Gomai,’ be ngamai. Be malipilipi kanagu bokai mrai, ‘Kana ngae goemakana,’ be ngaemaki.” ");
INSERT INTO mva_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bong Iesus pile ngaedi ilongo nge ipitilaki-tina, be ibuiri be tamoata be aine ditagatagai bokai iradi, “Ngau ka ura-kaming! Israel-tina-malo ka lama uninga biatanga bokainaina tago teke ute.” ");
INSERT INTO mva_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kodeka tamoata pile dieluaki nge Rom tamoata pera kanana-lo dimule. Dimule nge malipilipi ngae iuia be isoaki be dite. ");
INSERT INTO mva_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kana iemaki ngae muri nge Iesus itui be Nain anua-lo ilako. Be tagataga ne be tamoata be aine dum biabia teke ditagai. ");
INSERT INTO mva_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iesus anua ngae babaduadua ne taona itaotao nge tamoata teke mate dibazi be dipusikasika. Tamoata mate nge aine narenare kata natu, be natu ngae nge tekena-la. Tamoata be aine kokoko-tina anua ngarana-lo nge narenare ngae zaiza dialalale-budu. ");
INSERT INTO mva_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bong Tanepoa aine ngae ite nge ilo itagaia-tina be bokai irai, “Moaki kutang!” ");
INSERT INTO mva_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kodeka Iesus ilako be kati-boadikou ono dinangalako be dakumraki kana nge ono idauraki, be tamoata maka tamoata mate dibazibazi nge ditui. Kodeka Iesus bokai ipile, “Tamoata amuna, ngau ka uraiko, gomarang!” ");
INSERT INTO mva_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Makara nge tamoata mate nge imarangrake be isoaki, be itaguraki be ipilepile. Kodeka Iesus itaguraki be tamoata ngae idoki be tina iani. ");
INSERT INTO mva_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tamoata be aine moarunga makara nge dipitilaki-tina be ditaguraki be Nanaranga dirakeaki. Be bokai dipile, “‘Propet’ teke ara biabia-tina ambe marada ipura. Nanaranga ambe tamoata be aine ne ngadumadi kana be ipura!” ");
INSERT INTO mva_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Makara nge Iesus rangaka ngaedi ege-ege Zudea kaba-lo be kaba moarunga makara saringa dieno-lo dilako. ");
INSERT INTO mva_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Be Zon Baptais tagataga ne dialale be kana moarunga ngaedi nge Zon dirangakini. Kodeka tagataga ne rua ikila-diaru ");
INSERT INTO mva_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","be inepi-diaru be Tanepoa-lo dalakoru be bokai dategiaru kana, “Kaiko ki naita ka Zon irangaki ngapura kana, ki tamoata takaia garapungi?” ");
INSERT INTO mva_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Dialale be Iesus dipurakaniaru nge bokai ditegiaru, “Zon Baptais inepi-kamairu be bokai gategiko-ru kana ka kipura-ru, ‘Kaiko ki naita ka ngapura kana, ki tamoata takaia garapungi?’” ");
INSERT INTO mva_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bong tamoata ruoti ngae-diaru Iesus dipurakaniaru nge Iesus ambe tamoata more be goala odio dieno nge iaka-uiauiakidi, be mariaba goalakadi tamoata ilodia-lo disoaki nge itaotaodi, be tamoata matadi leuadi nge iadoadorakidi be kaba ditaita. ");
INSERT INTO mva_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kodeka Iesus itaguraki be tamoata Zon pilenga dieluakiru nge bokai ira-diaru, “Kamamuleru be kana kaitaru be pile kalongoru nge Zon kamarangakiniaru: Matadi leuadi ambe kaba ditaita, aedi matedi ambe dialalale, kikiri dokiadi ambe digoaza, kungizadi ambe pile dilongolongo, matedi ambe marangakadi dipura be nedi uia disoaki, be Pile Uia ambe tamoata kana nedi tagotago-lo mangata rangaka ipura. ");
INSERT INTO mva_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Be bokai kamarai: tamoata naita ngau tago ilo iruataka nge suri dauiani!” ");
INSERT INTO mva_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tamoata Zon pilenga dieluakiru ambe dialale-ru nge Iesus tamoata be aine moarunga Zon bokai irangakadi, “Bong lulu kaba-lo kalako be Zon kamate kana nge rakana-tina kata ka kamate kana ka kalako? Lulua kata oasa ieuieuri ka kamate kana ka kalako ki rakana? ");
INSERT INTO mva_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tago nge rakana-tina ka kamate kana ka kalako? Tamoata ngazing uia inangananga kata ka kamate kana ki rakana? Tago-la! Maka ma tamoata ngazing uia dinangananga nge boaduboadudi be anuatanepoa pera kandi bibia-lo ka disukoaki! ");
INSERT INTO mva_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kamaraia! Rakana-tina ka kamate kana ka kalako? ‘Propet’ kata ki? E, ‘propet’ kata! Ata ngau ka ura-kaming. Tago ‘propet’-ramoba kata. Ngai kaba iuasa-tina! ");
INSERT INTO mva_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ngai ka rangaka bokainatuka geretadi dipura, ‘Ngau masa pile eleluaki negu teke mnepi be arom ngamua. Ngai ka zalakam ngauasari be ngamua be gotagai kana.’ (Mal 3:1) ");
INSERT INTO mva_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ngau ka ura-kaming! Tamoata moarunga makare kateka-o nekiakadi dipura maradi nge Zon iuasa-tina. Ata tamoata naita bong ono Nanaranga ngatanepoa kanana-lo ara ialaurituka nge tamoata ngae Zon iuasai be ara ilaba-tina!” ");
INSERT INTO mva_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tamoata be aine moarunga be tamoata ‘tagisi’ dokidoki pile ngaedi dilongo nge dipile Nanaranga mata ne diado-tina, bakara di nge Zon ka ruku ono tamalingaa oti irukudi. ");
INSERT INTO mva_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ata Parasi be tamoata Moses Mata ne disulesuletaki nge Nanaranga labu ne ono ngadumadi kana nge disegeaki, bakara Zon tago ruku ono tamalinga oti irukudi. ");
INSERT INTO mva_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nge bokai ka Iesus pile ne ngaedi ibatadi be bokai ipile, “Tamoata be aine kaituka makare disoaki masa rakana oti odio mtonanga? Di nge rakana bokana? ");
INSERT INTO mva_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Di nge natu-muku malala-lo disoaki be nedia-la diekilaulau-ri bokana. Uko takaia ngataguraki be uko takaia bokai ngarai, ‘Keka oagu kipalita-kaming, ata tago kaoagu. Mate rang kidoki, ata tago katang.’ ");
INSERT INTO mva_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Bakara, bong Zon Baptais ipura be kangkang izirau be ‘uain’ tago isingsing nge kam bokai kapile, ‘Mariaba goalaka ilona-lo isoaki.’ ");
INSERT INTO mva_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ata Tamoata Natu ipura be imoanakonako be ‘uain’ isingsing nge bokai kapile, ‘Tamoata ngae kamate! Moanakonga dilaba-tina be ‘uain’ sinumanga dira-tina! Tamoata ‘tagisi’ dokidoki be “muzigoala ememaki” ruangadi kata!’ ");
INSERT INTO mva_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ata tamoata be aine rangguma Nanaranga kauanga malaidi didoki nge ambe ditiking-kaming Nanaranga kauanga nge kalingodi be moimoi.” ");
INSERT INTO mva_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parasi teke Iesus ialului be damoanako-buduru kana. Bokaibe Iesus ialale be Parasi ngae pera kanana-lo isili be isoakiria be ngamoanako kana. ");
INSERT INTO mva_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Anua ngaena-lo nge aine teke isoaki. Aine ngae nge muzigoala mata-la itagatagadi. Bong aine ngae bokai ilongo Iesus Parasi ngae pera kanana-lo imoanakonako nge bureng boaudi rongorongo bulo tekena-lo ieno nge idoki be ipura ");
INSERT INTO mva_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","be Iesus muri ae-babadi zagedi-o itui be itangtang be mata-dangi ane be Iesus ae-babadi itutuburi. Kodeka donga ane be Iesus ae-babadi iutuni. Iutu-doi kodeka ae-babadi nge iaroki be bureng boau rongorongo idoki be ono iburengdi. ");
INSERT INTO mva_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Bong Parasi maka Iesus moanako-lo ialului kaba bokai ita nge nena-la bokai ipile, “Tamoata ngae moangi be ‘propet’ kata nge iboadu ngakaua naita kata ka ono idaudauraki, be iboadu ngakaua aine ngae bakarairai kata! Aine ngae nge muzigoala ememaki kata!” ");
INSERT INTO mva_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kodeka Iesus bokai ipile, “Saimon, ngau kana teke mrangakaniko kana.” Be Parasi ngae bokai ipile, “‘Tisa,’ goraia!” ");
INSERT INTO mva_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Be Iesus itaguraki be bokai ipile, “Tamoata ‘mone’ negenege teke oti ne tamoata rua-lo dieno. Tamoata takaia oti nge ‘500 kina,’ be takaia ‘50 kina.’ ");
INSERT INTO mva_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ata tamoata ngae-diaru tago diboaduru oti nediaru ngaedi nge dakaturu. Bokaibe tamoata ngae oti nediaru ngaedi nge irokakile-diaru. Bakara ilom ipile? Nangata ka masa tamoata ngae ngarereretakia-tina?” ");
INSERT INTO mva_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Be Saimon ikatu be bokai ipile, “Ngau ilogu ipile tamoata maka oti ne bibia rokakadia-le dipura.” Be Iesus bokai ipile, “Kupile-tina uia!” ");
INSERT INTO mva_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kodeka Iesus ibuiri be aine ngae italari be Saimon bokai irai, “Aine ngae kute? Ngau pera kanam-lo usili, ata dang tago kuiana be ae-gu ono uasaki. Ata aine ngae mata-dangi ane be aegu iasaki be donga ane iutu. ");
INSERT INTO mva_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kaiko tago kuaroka, ata aine ngae bong pera kanam-lo usili nge aegu babadi iaroroki-la nibe imai-ba kaituka-tina. Tago sesu imanaua. ");
INSERT INTO mva_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kaiko tago bureng panganagu-o kunangai, ata aine ngae bureng boau rongorongo ane be aegu babadi iburengdi. ");
INSERT INTO mva_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bokai ka ngau uraiko! Reretaka mata ne bibia ngaedi nge ambe ono ne mangata inangai muzigoala nena-ra kokoko-tina, ata ambe rokakadia-le dipura. Ata tamoata naita muzigoala ne mukudi be rokakadia-le dipura nge ne mangata inangai reretaka mata ne mukumukudi.” ");
INSERT INTO mva_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kodeka Iesus itaguraki be aine ngae bokai irai, “Muzigoala nem ambe rokakadialeko dipura!” ");
INSERT INTO mva_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iesus bokai ipile nge lou takadi makara moanako-lo disoaki-budu nge bokai dipile, “Nge naita kata, be iboadu muzigoala ngarorokaki?” ");
INSERT INTO mva_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ata Iesus aine ngae bokai irai, “Ilo-uialo be goalale! Lama uniangam ka iuketiko!” ");
INSERT INTO mva_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Alauri nge Iesus ege-ege anua bibia be sisiki-lo ialalale be Pile Uia bong ono Nanaranga ngatanepoa kana nge mangata irangarangaki be ialalale. Be tagataga ne kulemoa-be-rua nge dialalale-budu. ");
INSERT INTO mva_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Be aine alu mariaba goalakadi ilodia-lo taonadi dipura be alu more goalakadi odio dieno be adorakadi dipura nge ditagadi. Teke nge Magdala aine ara Maria. Ngaia-lo ka mariaba goalakadi lima-rua taonadi dipura. ");
INSERT INTO mva_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Teke ara Zoana. Zoana roa ara Kuza, be Kuza nge Erot pera kanana-lo kana ne moarunga ipapananuaki. Teke ara Susana, be aine kokoko-tina takadi. Aine ngaedi nge kana nedi oti be Iesus tagataga ne zaiza malipi nedia-lo didumadumadi. ");
INSERT INTO mva_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tamoata be aine nge kokoko-la be Iesus-lo dipurapura. Anua moarunga-lo be dipurapura nibe dum kana-tina-biabia teke diemaki. Kodeka Iesus itaguraki be pile ono tonanga ngae iradi, ");
INSERT INTO mva_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tamoata kangkang tanotano teke ialale be uma kanana-lo kangkang-patu iliki. Bong ilikiliki nge kangkang-patu alu zala muku ono alalenga-lo disapasiria, be duaposakadi dipura be mang dipura be dikang. ");
INSERT INTO mva_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Alu kateka garaparapanao disapasiria be dirauposa, ata kateka ibaradega be dang-ka tago. Bokaibe dimarango. ");
INSERT INTO mva_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Takadi moamoaesa maradi disapasiria, be moamoaesa dilaba be disukum be dileua. ");
INSERT INTO mva_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Be alu kateka iauia-o disapasiria, be didula be dilaba be kangkang dipuraki. Kangkang-patu likiradi dipura nge teke-teke kangkang tamoatadi-lima dipuraki.” Be pile ngaedi ono ngamambuaki kana nge Iesus bokai ipile, “Kungi-ming ono pile longonga dieno nge kamalongo!” ");
INSERT INTO mva_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kodeka tagataga ne Iesus bokai ditegi, “Pile ono tonanga ngae labu baituka?” ");
INSERT INTO mva_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Be Iesus bokai iradi, “Bong ono Nanaranga ngatanepoa kana labu sikita kauataka nge ambe kam ania-ming ipura. Ata tamoata be aine takadi nge pile ono tonanga ane be uraradi. Bokai masa ‘moimoi matadi masa kaba daita be daitaita, ata masa kana tago teke date. Moimoi pile masa dalongo be dalongolongo, ata masa pile tago teke labu dakauataki.’ (Ais 6:9) ");
INSERT INTO mva_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kodeka Iesus bokai ipile, “Pile ono tonanga ngae labu bokai: Kangkang-patu nge Nanaranga pilenga. ");
INSERT INTO mva_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kangkang-patu zala mukuna-lo disapasiria nge tamoata pile dilongo bokana, ata Satang ipura be pile ngaedi ilodia-lo ka ipasi be idokiledi. Satang tago irere tamoata ngaedi lama dauni be uketadi dapura. ");
INSERT INTO mva_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kangkang-patu kateka garaparapanao disapasiria nge tamoata pile dilongo be suri-uialo be didoki bokana. Ata ziridi tagotago. Bokaibe uanana tago sasalaga lama diuni. Be bong toitoi dapura nge oaikiki-tina datapulo. ");
INSERT INTO mva_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Moamoaesa maradi disapasiria nge tamoata pile dilongo bokana. Ata ilo-buku be ‘mone’ be suri-uia kateka ngaena-onaona ilodi dibukubukutaki, be kana ngaedi ditaguraki be ditapadi bokana. Bokaibe tago dimalai. ");
INSERT INTO mva_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ata kangkang-patu kateka iauia-o disapasiria nge tamoata pile dilongo be didokimatedi bokana. Tamoata bokainaina nge ilodi adoadodi be uia-ba, be dikaiboang be disoaki-la be kalingodi dipura. ");
INSERT INTO mva_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Tamoata tago teke baratui ibulai be tabira-baba oti ikubati ki bagi ono enonga eruma inangai. Tago! Ibulai masa ngadoki be baratui kabadia-lo nganangai be tamoata naita pera-lo isili nge iboadu baratui malamaka ngaita. ");
INSERT INTO mva_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Bakara, kana moarunga zumkakadi dipura masa kadanga-lo nangadi dapura, be kana moarunga kubatadi dipura masa kauatakadi dapura be kakatadi dapura be mangata daeno. ");
INSERT INTO mva_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nge bokai ka pile baituka be kalongo nge kamakauakaua-tina uia! Tamoata naita kana dienoni masa kokoko-la be ania ngapura. Ata tamoata naita kana ne tago, masa dokiadia-le dapura. Moimoi masa ilo ipileni kana ne otioti, ata masa dokiadia-le dapura.” ");
INSERT INTO mva_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iesus tina be taritoka dipura be date kana, ata tamoata be aine dikoko-tina. Bokaibe tago iboadu dasaringai. ");
INSERT INTO mva_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Makara nge tamoata teke Iesus bokai irai, “Tinam be taritokam dateko kana be eluku dituitui.” ");
INSERT INTO mva_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kodeka Iesus itaguraki be moarunga makara disoaki bokai iradi, “Tinagu be taritokagu nge tamoata be aine maka Nanaranga pilenga dilongolongo be ditagatagadi.” ");
INSERT INTO mva_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bong teke Iesus tagataga ne bokai iradi, “Dang biabia Galili ege takaianao talako.” Bokaibe kati rebareba tekenao dibuli be dang ege takanao dalako kana. ");
INSERT INTO mva_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Dang biabia-lo direbareba nge Iesus ienosoa. Makara nge oaikiki-tina anua-goala teke dang biabia-lo ipura, be kati-lo ambe dang ikauriuri, be ambe saringatuka giriki daita kana. ");
INSERT INTO mva_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kodeka tagataga ne dilako be Iesus dianguni be bokai dirai, “Biabiadi, Biabiadi! Ambe taleua kana!” Be Iesus iturake be oasa be anua-goala dang-lo dipura nge kaikai-la iradi be malino ibala. ");
INSERT INTO mva_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kodeka tagataga ne bokai itegidi, “Lama unianga-ming inanga dieno?” Ata dia-ra taburidi dira be Iesus dikabaki be bokai dipile, “Tamoata ngae naita kata? Oasa be nugunugu ipile-kaidi be pilenga dilongo!” ");
INSERT INTO mva_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Makara be direba be dilako be kaba aradi Gerasin-lo dipura. Galili kaba-lo be adoado-la goreba masa makara kaba ngaradia-lo gopura. ");
INSERT INTO mva_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Be bong Iesus kabu-lo ituilako nge anua-marau teke mariaba goalaka ilona-lo isoaki nge ipurakani. Ambe uanana sasalaga-tina nemoala-ba ialalale, be pera tago tekena-lo isukoaki. Buna ono matedi kumrakadi dipurapura-lo isukoaki. ");
INSERT INTO mva_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bong tamoata ngae Iesus ite nge ipi-tina be imere be Iesus ae-nalo itapuloria be bokai ipile, “Iesus, Nanaranga Atabalabala-tina Natu, ba gobasaka kana? Ngau uakoroiko, moaki sururu kuiana!” ");
INSERT INTO mva_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tamoata ngae bokai ipile, bakara, Iesus nge ambe mariaba goalaka tamoata ngae ilona-lo nge itaotaoni. Ambe bong kokoko-tina mariaba goalaka ngae tamoata ngae idokimatei. Kaleti oarige ‘seng’ ane be ae be luma diuauau, ata itototo. Be mariaba goalaka ngae nge tamoata ngae ibagabagai be kaba tamoata tagongana-lo ialalaleaki. ");
INSERT INTO mva_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kodeka Iesus itaguraki be tamoata ngae bokai itegi, “Aram bakara?” Be tamoata ngae ikatu be bokai ipile, “Aragu ‘Labara.’” Maka ma mariaba goalakadi kokoko-tina tamoata ngae ilona-lo disoaki. Nge bokai ka ara ‘Labara’ kana ipile. ");
INSERT INTO mva_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Makara nge mariaba goalakadi ngaedi Iesus diakoroi be bokai dirai, “Moaki boazinga biabia kabi tagotago-lo kunepi-kamailako.” ");
INSERT INTO mva_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Saringa makara nge boro ulunga teke buku muku teka zagena-o diramomomo be disoaki. Bokaibe mariaba goalakadi tamoata ngae ilona-lo nge Iesus bokai diakoroi, “Gosumoala be boro ulunga ngara ilodia-lo gasili!” Be Iesus isumoala. ");
INSERT INTO mva_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Be bong mariaba goalakadi tamoata ngaena-lo be dipusika nge dilako boro ulunga ngaena-lo disili. Be boro ngaedi dipanana dilako garangakadi-o be dang-lo disapasilako be dang dising be dimoaloba. ");
INSERT INTO mva_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bong tamoata boro akolakola kaba bokai dita nge dipapanana-la be dilako anua-lo be kaba makara saringa dieno-lo be kana dipura ngaedi nge dirangaki. ");
INSERT INTO mva_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Be tamoata be aine makara nge dipura be kana ngaedi dipura daita kana. Be bong Iesus dipurakani nge tamoata maka mariaba goalakadi ilona-lo taonadi dipura nge Iesus aena-lo isoaki be dite. Ambe kusi inangananga be ngaonga dileua be isoaki be dite. Kaba bokai dita nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kodeka tamoata kaba dita nge dilako be bakara be tamoata ngae iuia nge tamoata be aine makara diradi. ");
INSERT INTO mva_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Makara nge tamoata be aine kaba ngaradia-lonalona nge taburidi dira-tina. Bokaibe Iesus dirai be Gerasin kaba ngapereki kana. Kodeka Iesus kati-o ibuli be ialale. ");
INSERT INTO mva_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tamoata maka mariaba goalakadi ilona-lo taonadi dipura nge Iesus iakoroi be dalale-buduru kana. Ata Iesus inepi be bokai irai, ");
INSERT INTO mva_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Anua nem-lo gomule be kana moarunga Nanaranga iemakiniko nge gorangaki.” Bokaibe tamoata ngae ialale be ege-ege anua ngarana-lo ilako be kana moarunga Iesus iemakini nge irangaki. ");
INSERT INTO mva_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bong Iesus kababe dang biabia ege takanao imule-lako nge tamoata be aine dum kanabiabia teke suri-uia oti be didoki. Tamoata be aine ngaedi nge dirapurapungi be disoaki. ");
INSERT INTO mva_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kodeka tamoata teke ara Zairus ipura. Tamoata ngae nge pera nedi ono serereinga-lo muamua nedi kata. Ipura nge ilako be Iesus ae babadia-lo itapuloria be bokai iakoroi, “Pera kanagu-lo gomai. ");
INSERT INTO mva_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Natugu aineka surikaka barasi ne kulemoa-be-rua ambe imatemate!” Bokaibe Iesus itui be itagai. Iesus zala-o ialalale nge tamoata be aine kokoko-tina ditagai. Tamoata be aine nge dikoko-tina be odio-banao ipopopokaki. ");
INSERT INTO mva_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Aine teke dara iuni be ambe barasi kulemoa-be-rua imambuaki nge makara maradi ialalale. ‘Mone’ ne surikakadi nge ambe tamoata more adoadoraki iandi be ono dadoraki kana, ata tago teke iboadu ngadoraki. ");
INSERT INTO mva_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bokaibe aine ngae Iesus muri ipura be Iesus kusi-sili ne salagalaga nge zage idoki. Makara nge oaikiki-tina dara unianga ngaedi nge dileua. ");
INSERT INTO mva_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Kodeka Iesus bokai ipile, “Naita oguo idauraki?” Moarunga makara diaoli bokana Pita bokai irai, “Biabiadi, tamoata be aine dikoko-tina be omo dipopopokaki!” ");
INSERT INTO mva_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ata Iesus itaguraki be bokai ipile, “Tamoata teke oguo idauraki! Ngau ukaua kaiboang negu alu dipusika!” ");
INSERT INTO mva_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aine ngae kaba bokai ita ambe kauataka ipura nge ilako be Iesus ae babadia-lo itapuloria. Kodeka makara tamoata be aine moarunga matadi-o ka Iesus irai bakara ka ono idauraki, be bakara be oaikiki-tina iuia. ");
INSERT INTO mva_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Makara nge Iesus aine ngae bokai irai, “Natugu, lama uniangam ka iemakiko be kuia! Ilo-uia ngaenoniko be goalale!” ");
INSERT INTO mva_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesus isi bokaina-la ipilepile be tamoata teke Zairus pera kanana-lo ka ipura be Zairus pile bokai ieluakini, “Natum aineka ambe imate! ‘Tisa’ moaki kaba kuilo-bukui!” ");
INSERT INTO mva_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesus bokai ilongo nge Zairus bokai irai, “Taburim moaki ira! Lama-ba ka gouni! Natum masa ngauia!” ");
INSERT INTO mva_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Iesus ilako be Zarius pera kanana-lo ipura nge itaguraki be moarunga ibabaridi be tago teke pera ilona-lo isili. Kodeka Pita, Zon be Zems, be natu-la aine ngae tina be tama ka ibagadi be disili-budu. ");
INSERT INTO mva_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tamoata be aine nge kokoko-tina dipura be natu aine ngae dinodonodomi be ditangitangiri be disoaki. Kodeka Iesus bokai iradi, “Moaki katang! Natu ngae tago imate! Ngena ieno-ba!” ");
INSERT INTO mva_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iesus bokai ipile nge tamoata be aine makara disoaki ditaguraki be Iesus dingengeri. Maka ma di dikaua natu aine ngae ambe imate! ");
INSERT INTO mva_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ata Iesus itaguraki be natu aine ngae luma takaianao idauraki be bokai ipile, “Natu-muku, gomarang!” ");
INSERT INTO mva_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Makara nge natu ngae mariabaka imule be oaikiki-tina imarang-rake. Kodeka Iesus iradi be kangkang muku dani be ngakani kana. ");
INSERT INTO mva_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Natu aine ngae tina be tama nge dipitilaki-tina be ba dapile. Ata Iesus bokai ira-diaru, “Kana ngae nge moakina-tina teke karangakaniaru!” ");
INSERT INTO mva_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iesus tagataga ne kulemoa-be-rua ikiladi be disoaki-budu, kodeka kaiboang ono mariaba goalakadi taonadi be kaiboang ono more adoraka iandi. ");
INSERT INTO mva_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kodeka inepidi be dalale be bong ono Nanaranga ngatanepoa kana nge mangata darangaki, be moremore dadorakidi kana. ");
INSERT INTO mva_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Dalale kana nge bokai iradi, “Alale ngaena-lo nge kana moaki teke kadokidoki: sika ono alalenga, ki raba kana-ming, ki kangkang, ki ‘mone,’ ki kusi-sili ka-ruadi. Moaki-tina! ");
INSERT INTO mva_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pera nangatana-lo kasili nge pera-la ngarana-lo kamasoaki nibe anua-ba ngara kamapereki. ");
INSERT INTO mva_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tamoata be aine anua nangatana-lo tago dimolataki-kaming be didoki-kaming nge bong anua ngara kaperepereki nge ae-ming gapukadi kamatatai be ono kamailo-kauadi nge tago muzi iauia ka diemaka-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bokaibe Iesus tagataga ne dialale be anua-anua-lo be dialalale be Pile Uia mangata dirangarangaki be moremore diadoadorakidi be dialalale. ");
INSERT INTO mva_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bong Galili kaba anuatanepoa kandi Erot kana ngaedi bokai dipurapura be ilongo nge iboang-tina be tago ikaua naita ka kana ngaedi iememaki. Bakara, tamoata alu dipile Zon Baptais ka imoauri. ");
INSERT INTO mva_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Alu dipile Ilaiza ka ipura, ata alu dipile ‘propet’ toirairadi ka teke imoauri be imarang. ");
INSERT INTO mva_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ata Erot bokai ipile, “Ngau ka upile be Zon dudu totoka ipura! Nge naita kata ka ruku ulongolongo?” Be irere-tina Iesus ngate kana. ");
INSERT INTO mva_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bong ‘apostel’ Iesus inepidi dimule nge kana moarunga diemaki Iesus dirangakini. Kodeka Iesus ibagadi be rubedia-ba anua ara Betsaida-lo dilako. ");
INSERT INTO mva_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ata tamoata be aine moarunga dikaua Iesus makara ilako. Makara be ditagai. Iesus tamoata be aine ngaedi itedi nge suri diuia be imolatakidi be bong ono Nanaranga ngatanepoa kana nge mangata irangakadi. Be tamoata be aine more dienodi nge iaka-uiakidi. ");
INSERT INTO mva_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Amari ambe itaotaoio nge tagataga kulemoa-be-rua dilako Iesus-lo be bokai dirai, “Tamoata be aine gonepidi be dalale. Kaba ngaedi nge masoasoaba-tinao ka dieno. Gonepidi be dalale anua saringa dieno-lo, be kaba maka saringa dieno-lo be kangkang be kaba ono enonga dalelei.” ");
INSERT INTO mva_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ata Iesus itaguraki be bokai iradi, “Kam kangkang kamandi be dakang!” Be di dikatu be bokai dipile, “Keka ‘bereti’ lima-la be ika rua ka maka dieno-kama. Ki kurere galale be tamoata be aine ngaedi kangkang gazazadi ki?” ");
INSERT INTO mva_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Tamoata moane makara disoaki nge ‘5,000’ moarunga.) Kodeka Iesus itaguraki be tagataga ne bokai iradi, “Tamoata be aine kamaradi be uko-uko be dasoaki. Uko tekena-lo nge tamoata kulemoadi-lima dasoaki, be bokai-bokai be ngalako.” ");
INSERT INTO mva_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Be tagataga ne ditaguraki be tamoata be aine diradi be Iesus-la ipile bokana uko-uko be disoaki. ");
INSERT INTO mva_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kodeka Iesus ‘bereti’ lima be ika rua nge idoki be lang-lo itadalako be Nanaranga iperui be ikingkoto, be tagataga ne iandi be tamoata be aine dinegedi. ");
INSERT INTO mva_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Be tamoata be aine dimoanako nibe didoli-tina. Kodeka tagataga ne raba kanabibia kulemoa-be-rua didoki be kangkang dimuleaki nge diau. ");
INSERT INTO mva_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bong teke nge Iesus rubena-ba isoaki be iraborabo. Be tagataga ne nge disoaki-budu. Kodeka Iesus bokai itegidi, “Tamoata be aine dum bibia nge ngau naita kana dirangaka?” ");
INSERT INTO mva_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Be tagataga ne dikatu be bokai dipile, “Alu dipile Zon Baptais, alu dipile Ilaiza. Be alu dipile ‘propet’ toirairadi kata ka kaba teke imarang be moauriuri isoaki.” ");
INSERT INTO mva_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Be Iesus kaba itegidi, “Be kam? Ngau naita kana karangaka?” Be Pita ikatu be bokai irai, “Kaiko Nanaranga Kristus ne!” ");
INSERT INTO mva_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kodeka Iesus itaguraki be ipile-kaidi moakina-tina teke kana ngae dirangakani. ");
INSERT INTO mva_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kodeka Iesus bokai iradi, “Tamoata Natu masa sururu bibia-tina ngadoki. Iuda tamoata nedi bibia, tamoata Nanaranga ditabatabai dimuamuadi, be tamoata Moses Mata ne disulesuletaki masa dataguraki be dasegeaki, be umoatea ngapura. Ata amaridi toli muridi masa kaba ngamarang be moauriuri ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kodeka moarunga bokai iradi, “Tamoata naita ngau ngatagaia kana nge nena-la ngailo-leuataki be izamazama kai kapalapala uauau ne ngabazibazi be ngatagatagaia. ");
INSERT INTO mva_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Bakara, tamoata naita ne moauriuri soakinga ngauketi kana masa ngaleua. Ata tamoata naita ngau kanabe imate masa moauriuri soakinga ngauketi. ");
INSERT INTO mva_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bokai kamakaua: Tamoata teke kana moarunga kateka-onaona idoki be inemdi, ata ne tamoata ileua ki eoa tago matemate-lo ilako be makara nem-kusoaki isukoaki. Bokai nge kana kateka-onaona ngaedi masa baituka be dadumai? Tagona-tina iboadu! ");
INSERT INTO mva_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bokainatuka-la, tamoata naita ngau be sulengagu imakaki masa Tamoata Natu mulenganao be ngamakaki. Bong ngaranao masa Tamoata Natu ne malamaka, be Tama malamaka be ‘enzel’ ratadi malama nedia-lo be ngapura. ");
INSERT INTO mva_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Moimoi ka ura-kaming! Alu maka dituitui masa mate bubuna tagona-la date be bong ono Nanaranga ngatanepoa kana nge date.” ");
INSERT INTO mva_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Amaridi lima-toli bokana muridi nge Iesus itaguraki be Pita, Zon be Zems ibagadiato be buku tekenao dikautakito be Iesus ngarabo kana. ");
INSERT INTO mva_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iraborabo nge Iesus lili ditabuli be takadia-ba dipura. Be kusi ne inangananga nge lamalama pitikaoanga bokana dioaoaoa. ");
INSERT INTO mva_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Makara nge oaikiki-tina Moses be Ilaiza dipuraru be dipilepileto. ");
INSERT INTO mva_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Malama kaiboangdi lang anua-lonalona ane be dipuraru. Kodeka makara be Iesus zaiza be baituka be Iesus masa Nanaranga rerenga saringatuka ngamambuaki kana Ierusalem-lo nge dirarangakito. ");
INSERT INTO mva_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ruanga zaiza-ra matadiato dimoarore be ditungtungto, ata mata-diato dipoara nge Iesus malama ne kaiboangdi be tamoata rua zaiza disoakito nge dita. ");
INSERT INTO mva_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tamoata ngae-diaru ambe Iesus dipereperekiaru nge Pita itaguraki be Iesus bokai irai, “Biabiadi, nge iuia-tina makare kisoaki! Bazarua toli gaemaki. Teke nem, teke Moses ne be teke Ilaiza ne.” (Maka ma Pita tago ikaua rakana ka irangarangaki.) ");
INSERT INTO mva_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita isi ipilepile-la be oaru teke ipura be isukumdi. Bong oaru ngae isukusukumdi nge Iesus tagataga ne toli ngaedi nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Makara nge malonga teke oaru ngaena-lo ka ipusika be bokai ipile, “Nge Natugu! Ngau negu-la be unangai! Kamalongolongori!” ");
INSERT INTO mva_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bong malonga ngae ipile-doi nge Iesus-la rube isoaki be dite. Ata bong ngaradia-lo nge tagataga toli ngaedi nge kana dipura ngaedi tamoata tago teke dirangakini. Nedia-la ilodia-lo dinanga be dieno. ");
INSERT INTO mva_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Izama be Iesus tagataga ne toli ngaedi zaiza be buku-o be ditaotao nge tamoata be aine dum kanabiabia teke dipurakani. ");
INSERT INTO mva_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Makara nge tamoata teke maradi ka bokai imere, “‘Tisa,’ ngau uakoroiko! Ngau urere natugu moane gote. Natugu nge surikana-tina! ");
INSERT INTO mva_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mariaba teke ilona-lo isoaki be bong ngaduamatei nge oaikiki-tina nganaboaki. Be ngareresabungaki be aoa-nalo busobuso ngakarabagadi. Mariaba goalaka nge tagona-tina iboadu natu ngae ngapereki. Be ambe igamagamani. ");
INSERT INTO mva_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tagataga nem uakorodi be mariaba goalaka nge dataoni kana, ata tago diboadu.” ");
INSERT INTO mva_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ata Iesus ikatu be bokai ipile, “Kam tamoata be aine bong ngaedia-lo kasoaki, tagona-tina lama kauni. Be muzinga-ming tagona-tina diado! Masa uanana salagatikadi ira sakeming-lanao msoaki? Ambe ilogu iakataki-kaming-tina!” Kodeka Iesus tamoata ngae bokai irai, “Natum maka godokamai!” ");
INSERT INTO mva_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Be bong natu ngae Iesus-lo ilakolako nge mariaba goalaka ilona-lo itaguraki be natu ngae kateka-o irokakaria be ireresabungaki. Ata Iesus itaguraki be mariaba goalaka nge itaoni be natu moane ngae iadoraki be kaba tamana-lo imuleaki. ");
INSERT INTO mva_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tamoata be aine moarunga makara nge Nanaranga kaiboang ne kaiboangdia-tina dita nge dipitilaki-tina be dikabaki. Tamoata be aine isi Iesus kana iemaki ngae dite be dikabakabakia-la be Iesus itaguraki be tagataga ne bokai iradi, ");
INSERT INTO mva_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pile mra-kaming ngaedi kana nge kamalongo-tina uia! Tamoata Natu masa dadoki be tamoata luma-dio dasalangaki.” ");
INSERT INTO mva_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ata tagataga ne pile ngaedi labudi tago dikauataki. Pile ngaedi labudi nge zumkakadiadi dipura. Bokaibe tago dikauataki. Dategi kana nge taburidi dira. ");
INSERT INTO mva_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iesus tagataga ne pile tekedi nedia-la maradi bokai diegoretaki: naita maradi ka biabiatuka. ");
INSERT INTO mva_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ata Iesus ikaua pile ngaedi ilodia-lo dieno. Bokaibe natu-muku teke idoki be sakenao ituiraki ");
INSERT INTO mva_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","be bokai iradi, “Tamoata naita araguo be natu-muku ngae idoki be iadoraki nge ngau ka idoka be iadoraka. Be tamoata naita ngau idoka be iadoraka nge ngau nepinepi negu ka idoki be iadoraki. Maka ma bokai kamakaua: Tamoata naita mara-ming ara ialaurituka nge ngai ka ara biabiatuka.” ");
INSERT INTO mva_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Be Zon itaguraki be bokai ipile, “Biabiadi, keka tamoata teke kite aramo be mariaba goalakadi itaotaodi. Ata ngai tago kita kata. Bokaibe kibabari be kana ngaedi tago iememaki.” ");
INSERT INTO mva_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Be Iesus ikatu be bokai ipile, “Moaki kababari! Tamoata naita tago ierekei-kaming nge kam muri-ming ituitui.” ");
INSERT INTO mva_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bong ono Iesus lang anua-lo ngakautaki kana disaringa nge ilo ilelenaki be ngatui be Ierusalem ngalako kana. ");
INSERT INTO mva_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngalako kana nge tamoata alu inepidi be aro dimua. Tamoata ngaedi dilako Samaria anua tekena-lo be kana damoataungakini kana. ");
INSERT INTO mva_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ata tamoata be aine anua ngarana-lo nge Iesus tago dimoalataki be didoki. Bakara, di dikaua ngai ambe Ierusalem ka ilakolako. ");
INSERT INTO mva_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iesus tagataga ne Zems be Zon kaba bokai ditaru nge bokai dipileru, “Tanepoa, kurere ki tago eoa lang-lo takeliaki be dabala be dara-leuadi?” ");
INSERT INTO mva_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ata Iesus ibagabuiri be iebulo-diaru. ");
INSERT INTO mva_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Makara be dialale be anua takaiana-lo dilako. ");
INSERT INTO mva_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Zala-lo dialalale nge tamoata teke itaguraki be Iesus bokai irai, “Inanga-inanga kulakolako nge mtagatagaiko-la kana.” ");
INSERT INTO mva_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Be Iesus ikatu be bokai irai, “Keu kabukabu boazinga nedi otioti, be mang makatabala diroro gupadi otioti! Ata Tamoata Natu kaba ne odio ngaenoria be ngamanaua kana nge tago!” ");
INSERT INTO mva_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kodeka Iesus itaguraki be tamoata takaia bokai irai, “Gotagaia!” Ata tamoata ngae ikatu be bokai irai, “Tanepoa, mialale be tama-gu mkumraki noko!” ");
INSERT INTO mva_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ata Iesus ikatu be bokai irai, “Matedi masa nedia-la mate-ruangadi dakumrakidi. Kaiko goalale be bong ono Nanaranga ngatanepoa kana nge mangata gorangaki.” ");
INSERT INTO mva_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Makara nge tamoata takaia bokai ipile, “Tanepoa, ngau mtagaiko kana, ata mialale be dara negu mraboakidi noko.” ");
INSERT INTO mva_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ata Iesus ikatu be bokai irai, “Tamoata naita uma-lo pangana izeleki be kateka iokiokiri kababe murina-lo igeagealako nge tagona-tina iboadu bong ono Nanaranga ngatanepoa kana nge ngamalipini.” ");
INSERT INTO mva_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kana ngaedi muridi nge Tanepoa itaguraki be kababe ‘72’ tamoata takadi inepidi be aro damua kana. Rua rua inangadi be anua be kaba moarunga nena-la be ngalako kanana-lo inepidialako. ");
INSERT INTO mva_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Dalale kana nge bokai iradi, “Kangkang biabia-tina uma-lo imaure be ieno, ata tamoata malipilipi kangkang ngae dauaroe be dabagai kana nge tago dikoko. Bokaibe uma-marau kamasinaui be malipilipi nganepidi be dalale be kangkang imaure be ieno nge dauaroe be dabagai. ");
INSERT INTO mva_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kamalale! Ambe ‘sipisipi’ natu bokana be keu kabukabu maradi unepi-kaming-lako. ");
INSERT INTO mva_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","‘Mone’ goate, ki raba, ki ae-sukuma moaki teke kadokidoki be kalale. Be zala-lo kalalale nge moaki teke kamolataki be ilo-uia kani. ");
INSERT INTO mva_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Bong pera tekena-lo kamasili kana nge bokai kamapile noko, “Pera ngaena-lo ilo-uia ngaeno!” ");
INSERT INTO mva_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamoata ilo-uia ienoni kata ka pera ngaena-lo isoaki nge ilo-uia neming kani nge ngaeno-lani. Tago nge ilo-uia neming kababe kamamuleaki. ");
INSERT INTO mva_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Makara pera ngarana-lo kamasukoaki be rakana dianiang-kaming nge kamakangkang be kamasukoaki. Maka ma tamoata imalipi nge bubuna ne otioti, be bubuna ne ngaedi nge ngadokidoki-la. Moaki pera pera-lo be kalakolako. Kabu-la teke kamasukoaki. ");
INSERT INTO mva_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Bong anua tekena-lo kalako be didoki-kaming be diadoraki-kaming, be rakana aro-ming dinangai nge kamadoki be kamakani. ");
INSERT INTO mva_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Be moremore makara kamaka-uiakidi be tamoata be aine bokai kamaradi, ‘Bong ono Nanaranga ngatanepoa kana ambe isaringa-kaming.’ ");
INSERT INTO mva_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ata anua katana-lo kalako be tago dimolataki-kaming be didoki-kaming nge zala nedi bibia-lo kamalako be bokai kamapile, ");
INSERT INTO mva_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gapugapu neming anua neming-lonalona ae-ma babadi-o ditaga nge ka kababe neming-la omingo kitatailako. Ata ilo-ming kauakaua, bong ono Nanaranga ngatanepoa kana ambe isaringa!’ ");
INSERT INTO mva_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngau ka ura-kaming! Bong ono tamoata be aine moarunga Nanaranga aro datui be giriki nedi ngaliliti kananao masa Sodom anua Nanaranga ilo muku ngatagai. Ata anua ae-ming gapukadi ono katatailako ngae nge tagona-tina iboadu ilo muku ngatagai kana! ");
INSERT INTO mva_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Korazin anua! Kumakadoma-tina! Ambe-ma kuleua-re! Betsaida anua! Kumakadoma-tina! Ambe-ma kuleua-re! Kilala kaiboangdi kam-lo emakadi dipura Taia be Saidon anua-lo emakadi dapura bokana nge ambe norane be ngado-kusi ono nodonga dananga be apoang-lo dasoaki be apoang dabureng be ono nedia-la mangata danangadi di ambe ilodi dibuiri be muzigoala nedi disegeaki. ");
INSERT INTO mva_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ata bong ono tamoata be aine moarunga Nanaranga aro datui kananao masa Nanaranga Taia be Saidon anua ilo muku ngatagadi. Kam tagona-tina ilo ngataga-kaming kana! ");
INSERT INTO mva_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Be kam Kaperneam nge neming-la be lang-lo kamakautaki kana ki? Tagona-tina kaboadu! Eoa tago matemate-lo rokaka-ming-lako dapura kana!” ");
INSERT INTO mva_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Tamoata naita ilongori-kaming nge ngau ka ilongora. Tamoata naita isegeaki-kaming nge ngau ka isegeaka. Be tamoata naita ngau isegeaka nge nepinepi negu ka isegeaki.” ");
INSERT INTO mva_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","‘72’ tamoata Iesus inepidi nge suri-uia ane be dimule be bokai dipile, “Tanepoa, mariaba goalakadi aramo be kipile-kaidi nge dilongori-kama!” ");
INSERT INTO mva_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Be Iesus ikatu be bokai iradi, “Satang lamalama pitikaoanga bokana be lang anua-lo be itapulopulo be ute. ");
INSERT INTO mva_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kamalongo! Ngau ambe kaiboang uang-kaming be iboadu moata goalakadi be moraba kamaduaposa, be Erekei kaiboang ne moarunga masa kamabalaki. Kana tago teke iboadu ba ngabasaki-kaming. ");
INSERT INTO mva_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ata ilo-ming kauakaua. Moaki mariaba goalakadi dilongori-kaming ngena suri-ming diuia! Moaki! Kana ono suri-ming dauia kana nge bokai: ara-ming ambe lang anua-lo geretadi dipura!” ");
INSERT INTO mva_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bong ngaranao nge Oli Spirit suri-uia Iesus iani be Iesus itaguraki be bokai ipile, “Mamo, kaiko ka lang anua be kateka Tanepoa nedi! Kaiko ambe kana uia tamoata kauakauadi be sule-lo lakolako kuzumkakiledi be kudoki be natu-muku kuitikingdi. Bokaibe uperuiko-tina! E, Mamo, moimoina-tina kana ngaedi nge rerengam-tina-lo. ");
INSERT INTO mva_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Tamagu ambe kana moarunga lumagu-o isalangaki. Tamoata tago teke Natu ikauataki. Tama-la ka Natu ikauataki. Be tamoata tago teke Tama ikauataki, Natu-la ka Tama ikauataki. Be tamoata maka Natu nena-la be inangadi be ono Tama mangata nganangaiadi kana nge ka Tama dikauataki.” ");
INSERT INTO mva_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kodeka Iesus ibuiri be tagataga ne italaridi be zuguma-ba bokai iradi, “Kam moimoi kauia-tina be kana ngaedi kaitaita! ");
INSERT INTO mva_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Moimoi ka ura-kaming! ‘Propet’ be anuatanepoa kokoko-tina kana kam kaitaita nge daita-tina kana direre, ata tago dita. Be pile kalongolongo nge dalongo-tina kana direre, ata tago dilongo.” ");
INSERT INTO mva_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ramani teke tamoata Moses Mata ne disulesuletaki teke itaguraki be Iesus ngatoi kana. Be bokai itegi, “‘Tisa,’ rakana memaki be masa moauriuri-la nem-kusoaki msukoaki?” ");
INSERT INTO mva_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Be Iesus ikatu be bokai irai, “Moses Mata ne baituka dipile? Kaiko kuleze nge labudi baituka kukauataki?” ");
INSERT INTO mva_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Be tamoata ngae ikatu be bokai ipile, “‘Nanaranga nem Tanepoa nge ilom moarungana-lo, mariabakam moarungana-lo, kaiboang nem moarungana-lo, be ilo lelenaka nem moarungana-lo be gorereretaki.’ Be takadi bokai, ‘Tamoata ruangam gorereretakidi nem-la kurereretakiko bokana.’” ");
INSERT INTO mva_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Be Iesus ikatu be bokai irai, “Pile ngaradi nge kukatu-tina uia! Bokainatuka gomuzimuzi be masa moauriuri-la gosoaki!” ");
INSERT INTO mva_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ata tamoata ngae nge nena-la be tamoata adoado kana ngarangaki kana. Bokaibe itaguraki be Iesus bokai itegi, “Naita ka tamoata ruangagu?” ");
INSERT INTO mva_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Be Iesus ikatu be bokai ipile, “Tamoata teke Ierusalem-lo be itui be Zeriko ilakolako noko anakonako lumadia-lo isapasilako. Kusi ne disare-le be dizangi dizangi be matena-ba makara zala-lo dinangai be diratu. ");
INSERT INTO mva_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Uari-tina be tamoata Nanaranga ditabatabai nge teke makara zala ngarana-lo ialalale. Bong tamoata ngae ite nge ibagapaliti zala ege takanao be ialale. ");
INSERT INTO mva_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bokainatuka-la, Libai teke makara ipura. Be itea-ba be ibagapaliti zala ege takaianao be ialale. ");
INSERT INTO mva_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ata Samaria tamoata teke makara zala ngarana-lo ialalale be tamoata ngae ipurakani. Be bong ite nge ilo itagaia-tina. ");
INSERT INTO mva_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kodeka bureng be ‘uain’ idoki be ilako be poake iasakini be kusi-mapala oti isuku. Kodeka idokiteteki be ‘dongki’ nenao isalangaki be pera ono enonga tekena-lo ilakuaki be makara itarurutaki be disoakiru. ");
INSERT INTO mva_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Izama nge Samaria tamoata nge itaguraki be ‘mone’ rua ipasi be pera-marau iani be bokai irai, ‘Tamoata ngae goadorakia-tina uia. ‘Mone’ ira tamoata ngaenao kurokaki masa mulemule be mkatuniko.’” ");
INSERT INTO mva_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Be pile ono ngamambuaki kana nge Iesus bokai itegi, “Tamoata nangata ka tamoata maka anakonako lumadia-lo isapasilako nge ruanga?” ");
INSERT INTO mva_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Be tamoata Moses Mata ne isulesuletaki nge ikatu be bokai ipile, “Tamoata maka ilo itagai.” Kodeka Iesus bokai irai, “Goalale be bokainatuka-la ka gomuzimuzi!” ");
INSERT INTO mva_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesus tagataga ne zaiza dialalale nge anua tekena-lo dipura. Makara nge aine teke ara Marta nge pera kanana-lo ibagadialako. ");
INSERT INTO mva_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta taritoka teke isoaki ara Maria. Makara nge Maria ilako be Tanepoa ae babadia-lo isoakiria be sulenga ilongolongo. ");
INSERT INTO mva_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta nge rubena-ba malipi iememaki, be ilo nge kolo-kolo be ianiani. Bokaibe ilako be bokai ipile, “Tanepoa, ilom tago ibuku taritokagu ipereka be malipi moarunga rubegu-la uememaki? Gorai be ngadumaia!” ");
INSERT INTO mva_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Be Tanepoa ikatu be bokai irai, “Marta, Marta! Kolo-kolo be ilom ianiani. Bokaibe ilom ibukuramo-tina. ");
INSERT INTO mva_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ata kana tekenalana-tina ka reretaka ipurapura. Be Maria ambe kana iauia ngae idoki. Bokaibe tago iboadu totoka-le ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bong teke nge Iesus kaba tekedia-lo isoaki be iraborabo. Irabo-doi nge tagataga ne teke itaguraki be bokai irai, “Tanepoa, rabo goitiking-kama, Zon-la tagataga ne rabo itikingdi bokana.” ");
INSERT INTO mva_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Be Iesus bokai iradi, “Bong karaborabo nge bokai kamapile, ‘Tama-ma, aram rata iboadu muaka ngapurapura. Bong ono gotanepoa kana iboadu ngapura. ");
INSERT INTO mva_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Amaridi teke-teke-lo nge kangkang goaniang-kama. ");
INSERT INTO mva_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Muzigoala nema gorokakile-kama, bakara tamoata takadi muzigoala diememaki-kama nge kirorokakiledi. Be toitoi moaki kuiang-kama.’” ");
INSERT INTO mva_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kodeka Iesus tagataga ne bokai iradi, “Tekem ruangam teke isoaki, be oabubu lukanganao kulako be bokai kurai, ‘Ruanga, iboadu bang toli goana, be masa kababe mkatuniko. ");
INSERT INTO mva_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ruangagu teke zala salagalaga itagatagai be ambe ipura be pera kanagu-lo isoaki. Ngau kangkang miani kana nge tago!’ ");
INSERT INTO mva_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Kodeka ruangam pera ilona-lo masa bokai ngapile, ‘Moaki kuilo-bukuia! Babaduadua ambe onota ipura, be ngau natugu zaiza ambe zirapu-lo kieno. Tago iboadu marang be kana teke miangko.’ ");
INSERT INTO mva_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bokai nge masa ba gouai? Moimoi ka ura-kaming! Moimoi tamoata ngae ruangam kata, ata nge tago kuruangami ka tago iboadu ngamarang be bang kusinaui ngangko. Tago-tina! Ngena tago kumakaki be kusinauia-la be ieno ka ngamarang be rakana kureretaki nge ngangko kana. ");
INSERT INTO mva_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nge bokai ka ngau bokai ura-kaming: Gosinau masa kana aniam ngapura. Kana golelei masa gote. Babaduadua gopaliti masa ngatakakaniko. ");
INSERT INTO mva_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Maka ma tamoata isinaunau-la masa kana ngadokidoki-la. Tamoata kana ilelelei-la masa ngaitaita-la, be tamoata babaduadua ipalipali-la masa datakakaka-la. ");
INSERT INTO mva_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Kaiko kamoang kata be natum ipura be ika kana isinauko masa moata goani ki? Tago! ");
INSERT INTO mva_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ki mang-patu kana isinauiko masa moraba goani? Nge tago! ");
INSERT INTO mva_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Moimoi muzinga-ming ra goalakadi, ata natu-ming kana uia aniadi nge kamang. Bokainatuka-la, Tama-ming lang anua-lo isoaki masa Oli Spirit ngadoki be tamoata naita isinaui nge ere-moarunga be ngani.” ");
INSERT INTO mva_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesus nge ambe mariaba goalaka teke pile bebebe itaotaoni. Be bong mariaba goalaka ngae iratu nge tamoata pile bebebe nge aoa itakaka be ipilepile. Tamoata be aine moarunga kaba bokai dita nge dipitilaki-tina be Iesus dikabaki. ");
INSERT INTO mva_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ata tamoata alu bokai dipile, “Ngena mariaba goalakadi biabiadi nedi Bielzebul ka kaiboang ianiani be mariaba goalakadi itaotaodi.” ");
INSERT INTO mva_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Be aludi ditaguraki be Iesus datoi kana. Bokaibe ditegi be kilala kaiboangi lang anua-lonalona teke ngaemaki kana. ");
INSERT INTO mva_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ata Iesus pile nedi ilodia-lo italako be bokai iradi, “Anua kata tamoata ne uko-uko dienegei be nedia-la dieunung nge masa nedia-la dara-leuadi. Dara teke kata ka nedia-la dienegei be dieunung nge daesereki be nem-nem dalako kana. ");
INSERT INTO mva_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Bokaibe Satang anua ne ienegei be nena-la ieunung masa baituka be anua ne ngakaiboang? Nge kapile ngau Bielzebul kaiboang iana ka mariaba goalakadi utaotaodi ka bokai upile. ");
INSERT INTO mva_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kam kapile ngau Bielzebul ara-nao be mariaba goalakadi utaotaodi, ak kam tagataga neming naita ara-nao ka mariaba goalakadi ditaotaodi? Bokaibe di ka masa dara-kaming naita aranao ka mariaba goalakadi ditaotaodi! ");
INSERT INTO mva_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ata tamoata naita ikaua ngau Nanaranga kaiboang nena-lo ka mariaba goalakadi utaotaodi nge bong ono Nanaranga ngatanepoa kana nge ambe tamoata ngaena-lo ipura. ");
INSERT INTO mva_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Bong tamoata kaiboangi kata ka io be meng ne ane be pera kana inarinaringi masa kana ne moarunga adoado-la daeno. Kana ne tago teke iboadu ba ngauai. ");
INSERT INTO mva_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ata tamoata takaia kaiboang-lo ngai uasai ipura be io be meng ne idoki-le be iuasai nge masa kana ne moarunga ngadoki-le be nganege. Maka ma tamoata kaiboangi ngae nge io be meng ne ka odio ikaikai! ");
INSERT INTO mva_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tamoata naita tago iruangama nge moimoi be erekei negu. Tamoata naita tago ngau keru kana kibudinaki-buduru nge ngaia-tina ka kana idua-raramoaki. ");
INSERT INTO mva_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Bong mariaba goalaka tamoata tekena-lo ngapusika masa ngalako be kaba baradegadi ngalaleaki be kaba ono manauanga ne ngalelei. Ngalelei be tago tekedi ita nge nena-la bokai ngarai, ‘Kaba pera uperekia-lo mule-lako.’ ");
INSERT INTO mva_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bong ngamule masa pera kana adoraka ngapura be goazagoaza ngaeno be ngate. ");
INSERT INTO mva_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kodeka ngalale be mariaba goalakadi muzingadi goalakingadi ngai diuasai nge lima-rua ngatedi be ngabagadi be pera ngarana-lo dasukoaki-budu. Bokaibe tamoata ngae kodeka muzinga dagoala-tina. Toira muzinga mukuna-la digoala, ata kodeka muzinga dagoala-tina.” ");
INSERT INTO mva_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iesus pile ngaedi ipilepile nge aine teke tamoata be aine maradi ka bokai ipile, “Aine maka inekiakiko be iaka-labatiko nge iboadu marou bibia ngadoki!” ");
INSERT INTO mva_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ata Iesus ikatu be bokai ipile, “Tago. Tamoata maka Nanaranga pilenga ilongo be itagatagadi ka iboadu marou bibia ngadoki!” ");
INSERT INTO mva_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tamoata be aine nge isi dipurapura-la. Bokaibe Iesus itaguraki be pilenga bokai ibatadi, “Tamoata be aine kaituka bong ngaedia-lo disukoaki nge muzingadi digoala-tina! Kilala kaiboangi teke aniadi ngapura kana direre! Ata tagona-tina iboadu teke aniadi ngapura. Kilala kaiboangi toira Zona emakani ipura-la ka masa aniadi ngapura. ");
INSERT INTO mva_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Toira-la Nanaranga itaguraki be Zona idoki be Ninibe tamoata be aine kilala bokana iemakadi, Nanaranga masa ngataguraki be Tamoata Natu ngadoki be tamoata be aine kaituka bong ngaedia-lo disoaki nge kilala bokana ngaemakadi. ");
INSERT INTO mva_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Bong ono tamoata be aine moarunga Nanaranga aro datui be giriki nedi ngaliliti kananao masa Siba moaede kandi ngatui-rake be tamoata be aine kaituka bong ngaedia-lo disoaki ngatunuridi be giriki odio nganangalako. Labu ono giriki odio ngananga-lako kana nge ngai kateka ege takanao ka itui be ipura be anuatanepoa ara Solomon nge kauanga malaidi ilongori. Ata ngau bokai ura-kaming! Tamoata teke makare isoaki nge Solomon iuasai! ");
INSERT INTO mva_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bong ono tamoata be aine moarunga Nanaranga aro datui kananao masa Ninibe tamoata be aine datuirake be tamoata be aine kaituka disoaki datunuridi be giriki odio danangalako. Labu ono giriki odio danangalako kana nge bong Zona ilako be Ninibe ipile-kaidi nge ilodi dibuiri be muzigoala nedi disegeaki. Ata ngau bokai ura-kaming! Tamoata teke makare isoaki nge Zona iuasai! ");
INSERT INTO mva_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Tamoata tago teke baratui ibulai be komanga-lo inangai ki tabira-baba eruma inangai. Tago-tina! Baratui kabadia-lo nganangai be bong tamoata pera-lo disilisili masa malamaka daita. ");
INSERT INTO mva_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mata-ming nge tamoata-ming baratui nedi. Mata-ming uia masa tamoata-mingo malama dalaba. Ata bong mata-ming dagoala masa tamoata-ming ere-moarungadi-o oabubu ngaeno. ");
INSERT INTO mva_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eke! Malama omingo dieno nge daoabubu takana! ");
INSERT INTO mva_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Bokaibe tamoata-ming ere-moarungadio malama dieno masa kania-ming tago teke oabubu ngadoki. Maka ma kania-ming moarunga-o masa malama daeno, baratui-la imalamalama bokana.” ");
INSERT INTO mva_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesus pile ngaedi ipile-doi nge Parasi teke ipura be ialului be pera kanana-lo ngamoanako kana. Bokaibe ialale be ambe isoakiria be ngamoanako kana. ");
INSERT INTO mva_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ata Parasi ngae kaba bokai ita Iesus luma tago iasaki be ambe ngamoanako kana nge ipitilaki-tina be ilo lelenaka irai. ");
INSERT INTO mva_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kodeka Tanepoa itaguraki be bokai irai, “Kam Parasi, sema kana-ming be tabira kana-ming nge nokudi kasasaki, ata ilo-minglo nge kana moarunga nem-doi mata be mata goalakadi dikauri. ");
INSERT INTO mva_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ngaongao-ming! Tago kakaua tamoata maka kana ilodi iemaki nge ka nokudi iemaki? ");
INSERT INTO mva_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bokaibe ilo-ming dagoaza kana nge kana moarunga dieno-kaming nge tamoata kana nedi tagotago kamandi. Bokai masa ilo-ming be kania-ming moarunga dagoaza! ");
INSERT INTO mva_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ue! Kam Parasi! Ambe-ma kaleua-re! Dagurai kana-ming nge kulemoa-kulemoa-lo kanangananga be tekedi Nanaranga kaniani, ata muzi uia emakadi be Nanaranga reretaka nge tago dieno-kaming! Mata rua urangaki ngaedi ka kamatagatagadi kana. Ata mata atabala urangaki-mua nge kamaememaki be! ");
INSERT INTO mva_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ue! Kam Parasi! Ambe-ma kaleua-re! Pera ono serereinga-lo nge aro-tinalo soaki karerere, be malala-lo nge tamoata takadi daboadukuduku-kaming kana karerere. ");
INSERT INTO mva_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ue! Ambe-ma kaleua-re! Tea-ming nge poda tago sasauki bokana. Bokaibe tamoata be aine tago dikauataki be atabaladi dialalale.” ");
INSERT INTO mva_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bokai ipile nge tamoata Moses Mata ne disulesuletaki teke bokai ipile, “‘Tisa,’ bokai kupile nge keka kuebulo-kama be!” ");
INSERT INTO mva_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Be Iesus ikatu be bokai ipile, “Ue! Kam tamoata Moses Mata ne kasulesuletaki! Ambe-ma kaleua-re! Tamoata takadi nokudi-o nge kana moatubudi baziadi ratadi kananganangaria, ata kam neming-la nge kabo-ming tago teke kananganangai be ono kadumadumadi! Tago be tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ue! Ambe-ma kaleua-re! Kam-tina ma ka ‘propet’ podadi kangazimdi. ‘Propet’ ma maka tubu-ming diumoatedia-re! ");
INSERT INTO mva_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bokaibe nge ambe neming-la be bokainatuka mangata kananga-kaming: Kana maka tubu-ming diemaki nge kam kasumoala ka diemaki. Bokaibe tubu-ming ‘propet’ diumoatedi, be kam podadi kangazimdi. ");
INSERT INTO mva_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nge labu ngaenao ka Nanaranga kauanga malaidi ane be bokai ipile, ‘Ngau masa ‘propet’ be ‘apostel’ negu mnepidi be dia-lo dalako. Aludi masa daumoatedi be takadi masa sururu bibia-tina dandi.’ ");
INSERT INTO mva_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bokaibe ‘propet’ moarunga-tina umoateadi dipura toira kateka emaka ipura-lo be imai kaituka, darakadi masa tamoata be aine kaituka bong ngaedia-lo disoaki nge dadoki, be masa sururu bibia-tina dabazidi. ");
INSERT INTO mva_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel-lo be imai Zekaraia-lo daga darakadi masa tamoata be aine kaituka bong ngaedia-lo disoaki dadoki. Zekaraia nge bagi ono Nanaranga tabaia ipurapura be kaba ratadi maradi ka umoatea ipura. Moimoina-tina ka ura-kaming! Tamoata ngaedi darakadi masa tamoata be aine kaituka bong ngaedia-lo disoaki-o dabala. ");
INSERT INTO mva_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ue! Kam tamoata Moses Mata ne kasulesuletaki! Ambe-ma kaleua-re! Kam nge kaua bibia babaduadua uasara ne kadokimatei be tago kanegei! Bokaibe kam neming-la nge tago kasili! Be tamoata takadi dipipi be dasili kana nge zalakadi kaonono.” ");
INSERT INTO mva_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Iesus ipile-doi be kaba ngaradi ipereki nge Parasi be tamoata Moses Mata ne disulesuletaki ditaguraki be diduaia-tina, be pile ono dinangalako be tegitegi kokoko ane dategi kana. ");
INSERT INTO mva_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Be makara be dirapurapungi be ono pile tekedi ngapakadi be giriki ono danangalako kana. ");
INSERT INTO mva_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tamoata be aine ‘tausen’ kokoko-tina nge dipura be ambe nedia-la dieduaposaposaki. Kodeka Iesus itaguraki be matamata tagataga ne bokai iradi, “Parasi ‘is’ nedi kamamatamatakuakia uia! ‘Is’ nedi ngae nge bolingadi ratingadi! ");
INSERT INTO mva_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kana moarunga kubatadi dipura masa kakatadi dapura, be kana moarunga zumkakadi dipura masa mangata-lo kauatakadi dapura. ");
INSERT INTO mva_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rakana pile kaoa oabubu-lo kapile masa ariata longoradi dapura. Be rakana pile kaoa zugumaba pera ilodia-lo be kamalongasiki masa malala-lo be rangakadi dapura. ");
INSERT INTO mva_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ruangagu, ngau ka ura-kaming. Tamoata maka tamoata-ming daumoatedi be kababe alauri tago diboadu kana takaia daemaki nge moaki kamatakuridi! ");
INSERT INTO mva_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ata ngau masa mitiking-kaming naita ka kamamatakuri kana. Nanaranga ka kamamatakuri kana! Ngai kaiboang dienoni be iboadu tamoata-ming ambe umoateadi dipura nge ngadoki be eoa tago matemate-lo ngarokakilako. E, ngau ka ura-kaming! Ngai ka kamamatakuri! ");
INSERT INTO mva_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Moimoi mangsisiki lima nge ‘mone’ dadara rua ane ka zazadi dipurapura! Ata Nanaranga mangsisiki tagona-tina teke ilo dileualeuataki! ");
INSERT INTO mva_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bokai kamakaua: Moimoina-tina dongaming teke-teke pangana-mingo nge ambe uareadia-doi dipura. Bokaibe moaki taburi-ming dira! Kam zaza-ming nge mangsisiki kokoko-tina zazadi diuasadi! ");
INSERT INTO mva_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ngau ka ura-kaming! Tamoata naita lili-be-matao ipile ngai ngau tamoata negu masa Tamoata Natu ngataguraki be Nanaranga ‘enzel’ ne moarunga lilidi-be-matadio ngarangaki ngai tamoata ne. ");
INSERT INTO mva_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ata tamoata naita lili-be-matao ipile ngai tago tamoata negu masa Tamoata Natu ngataguraki be Nanaranga ‘enzel’ ne moarunga lilidi-be-matadio ngarangaki ngai tago tamoata negu. ");
INSERT INTO mva_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Tamoata naita edua pile kaoa Tamoata Natu ono inangalako masa giriki ne rokakadia-le dapura, ata tamoata naita Oli Spirit ono imanai nge tagona-tina iboadu giriki ne rokakadia-le dapura. ");
INSERT INTO mva_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Bong pera ono serereinga-lo, ki tamoata dimuamua, ki tamoata bibia arodi dituiraki-kaming nge moaki ilo-ming dibuku masa rakana pile kamapile ki baituka kamapile be ono kamaoiaki-kaming! Moaki-tina! ");
INSERT INTO mva_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Maka ma pile baituka bong ngaradia-lo kamapile kana masa Oli Spirit ngasule-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Makara nge tamoata teke tamoata be aine moarunga maradi ka bokai irai, “‘Tisa,’ taritokagu gorai be tama-mairu kana ne moarunga nganege-kamairu.” ");
INSERT INTO mva_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Be Iesus ikatu be bokai irai, “Tamoata! Naita sumoala iana be ngau uboadu giriki mliliti be miadoraki ki tama-mingru kana ne mnege-kamingru?” ");
INSERT INTO mva_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kodeka Iesus itaguraki be moarunga makara disoaki bokai iradi, “Eke! Kaba kamaitaita uia! Kana kokoko reretakadi be dokiadi mata kamatagadi takana! Tamoata soakingadi nge tago kana nedi kokotangadia-lo ka disukoaki uia. Tago. Kana nedia-ra kokoko, ata tago iboadu soaki kalingo dadoki.” ");
INSERT INTO mva_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kodeka Iesus itaguraki be pile ono tonanga tekedi bokai iradi, “Tamoata teke kana ne kokoko nge uma kana moarunga kangkang uia dipurakini. ");
INSERT INTO mva_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Bokaibe nena-la bokai ilo ilelenaki, ‘Kangkang negu dikoko-tina be kaba ono kangkang negu moarunga mkoazalaki kana nge disiki. Masa rakana memaki?’ ");
INSERT INTO mva_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kodeka nena-la bokai ipile, ‘Masa bokainatuka muzi: Pera negu ono kangkang koazalaka mgamang be bibia mkeli be ono kangkang negu be kana negu moarunga mkoazalaki. ");
INSERT INTO mva_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kodeka masa negu-la bokai mraia, “Kaiko kuia! Ambe kana uia kokoko kukoazalaki be iboadu barasi kokoko bokai daeneno. Kana moaki teke ilom ibukutaki. Moaki kumalipilipi be ono kusim imamalomalo. Gomoanakonako, dang gosingsing be surim dauiauia!” ’ ");
INSERT INTO mva_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ata Nanaranga itaguraki be tamoata ngae bokai irai, ‘Ngaongaom! Oabubu-la ngaena-lo masa soakingam ngaedi dokiadialeko dapura. Bokai masa kana nem moarunga nem-la kukoazalakiniko nge masa naita ngadoki?’” ");
INSERT INTO mva_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Be Iesus pile ngaedi bokainatuka imambuaki, “Tamoata kateka-o kana dikoazakoazalaki, ata Nanaranga mata-nao kana nedi tago dikoko masa bokainatuka-la ka basakadi dapura kana.” ");
INSERT INTO mva_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kodeka Iesus tagataga ne bokai iradi, “Bokai ka ngau bokai mra-kaming kana! Kangkang kamakangkang be moauriuri kamasukoaki kana nge moaki kailo-bukutaki. Be kusi kamaokoko kana nge moaki kailo-bukutaki. ");
INSERT INTO mva_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bokai kamakaua: Moauriuri soakinga-ming ka ara biabia, be kangkang kamakangkang kana nge iuasadi. Be tamoata-ming ka ara biabia, be kusi kamaokoko kana nge iuasadi. ");
INSERT INTO mva_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Du ilo-ming dandi. Kangkang tago ditanotano ki diuaroeroe. Pera nedi ono kana koazalaka be pera nedi ono kangkang koazalaka nge tagotago. Maka ma Nanaranga ka iakolakoladi! Ata kam adoraka-ming nge mang adorakadi diuasadi! ");
INSERT INTO mva_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naita tekem masa kana-ba ngae goilo-bukubukutaki be kuboadu soakingam goaka-salagati? Tago be tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Bokaibe kana muku ngae emaka kubebe nge bakara ka kana moarunga kuilo-bukubukutaki? ");
INSERT INTO mva_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Moare ilo-ming dandi! Tago dimalipilipi ki kusi nedi diememaki. Ata ngau bokai ura-kaming! Toira Solomon ngazing ne malageri-tina ka inangananga, ata ngazing ne tago teke moare malagerisisingadi iuasadi. Tago-la. ");
INSERT INTO mva_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lama uinianga-ming disiki-tina! Moimoi Nanaranga ka siresire ingazingzingdi, ata kam kababe siresire kauasadia-tina. Bokaibe Nanaranga masa ngangazing-kaming mua kana. Alauri ka siresire ngangazingdi kana. Maka ma siresire nge kaituka makare dieno, ata zama nge eoa ragogodia-lo buladi dapura kana! ");
INSERT INTO mva_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Bokaibe rakana kamakani be kamasing kana nge ilo-ming moaki dibukutaki. Moakina-tina ilo-ming dibuku. ");
INSERT INTO mva_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bakara, tamoata Nanaranga pilenga tago ditagatagadi nge kana ngaedi dilo-bukubukutaki be dilelelei. Be bokai kamakaua: Tama-ming ikaua kana ngaedi kareretaki. ");
INSERT INTO mva_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ata bong ono Nanaranga ngatanepoa kana nge kamalelei noko, alauri ka masa kana moarunga ngaedi ania-ming dapura. ");
INSERT INTO mva_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kam ‘sipisipi’ ulunga muku kata, taburi-ming moaki dira! Moaki-tina! Maka ma Tama-ming ambe ilo iuiataki-kaming be bong ono ngatanepoa kana nge ngang-kaming kana. ");
INSERT INTO mva_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kana ne-ming moarunga ono ‘mone’ kamadoki be ‘mone’ ngaedi kamadoki be tamoata kana nedi tagotago kamandi. Bokai masa ‘mone’ goate neming lang anua-lo dakauri-tina. ‘Mone’-goate lang anua-lonalona nge tago dimasaresare be dimoatobatoba. Makara nge tago iboadu kana tekena-lo kamatukura, be anako tago iboadu danako-kaming, be boaboaziri tago iboadu kana neming dagamang. ");
INSERT INTO mva_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Maka ma bokai kamakaua: Kana neming irakingadi dieno kana masa ilo-ming makarana-la daeneno. ");
INSERT INTO mva_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Kamakatiuana uia be kamasoaki! Giriki puradi tago kakaua. Kusi neming kamaoko uia be baratui neming kamabulai be kamakatiuana be kamasoaki. ");
INSERT INTO mva_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Malipilipi-la biabiadi nedi moanako ono rotinga-lo be mulenga dirarapung bokana kam kamakatiuana be kamarapurapu. Bokaibe bong biabiadi nedi ipura be babaduadua ipaliti masa oaikiki-tina dauasarani. ");
INSERT INTO mva_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Biabiadi nedi ipura be matadi poapoara be dikatiuana be disoaki be itedi masa malipilipi suridi dauia-tina! Moimoi ka ura-kaming! Biabiadi nedi masa ngataguraki be malipilipi kana bagi ono moanakonga-lo ngasoakingakidi be kusi ono moanako adoraka ngananga be kangkang ngandi. ");
INSERT INTO mva_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kana-ra oabubu lukanganao ki mang uludi-o bokana ka ipura, ata malipilipi kana dikatiuana be disoaki be itedi masa malipilipi kana suridi dauia-tina! ");
INSERT INTO mva_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ata kana ngae ilo-ming daniani: Pera-marau ikaua bong nangatanao anako ngapura be pera kana ngasereki kana nge ambe pera-marau tago iboadu anako ngalikitaki be pera kana ngasereki. Maka ma pera-marau mata poapoara be irapurapu! ");
INSERT INTO mva_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bokainatuka-la, kamakatiuana be kamasoaki. Bakara, Tamoata Natu masa puranga tago kamakauataki. Ramani nangatanao ngapura nge tago kakaua.” ");
INSERT INTO mva_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Be Pita bokai ipile, “Tanepoa, pile ono tonanga ngaedi kupile nge kekai-la ka kura-kama ki moarunga zaiza be kura-kama?” ");
INSERT INTO mva_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Be Tanepoa ikatu be bokai ipile, “Bokai nge malipilipi nangata ka kauakaua be malipi ne iememaki-tina uia? Biabiadi ne itaguraki be kana ne moarunga pera kanana-lo nge luma-nao isalangaki, be bong-tina ono kangkang negenga-o nge malipilipi takadi kangkang kandi ianiandi. ");
INSERT INTO mva_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Be bong biabiadi ne ipura pera kanana-lo be malipilipi ngae kana bokai iememaki be ita masa malipilipi ngae suri dauia-tina. ");
INSERT INTO mva_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Moimoina-tina ka ura-kaming! Biabiadi ne masa ngataguraki be malipilipi ngae nganangai be kana ne moarunga ngaitaita be ngadoadorakini. ");
INSERT INTO mva_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ata malipilipi ngae ilona-lo bokai ngapile bokana, ‘Biabiadi negu isi tago ngapura-mado kana.’ Be ngataguraki be malipilipi moane be malipilipi aine takadi ngaunundi, be ngamoanakonako be dang kakai ngasingsing be ngaboangboang be ngasoaki. ");
INSERT INTO mva_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Bokai imuzimuzi masa biabiadi ne puranga tago ngatautaki ki amari nangatanao ngapura kana nge tago ngailo-bukutaki. Bokaibe biabiadi ne masa ngataguraki be mukumuku ngataratotoki be sururu bibia tamoata panganadi patu bokana didokidoki nge ngani. ");
INSERT INTO mva_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Malipilipi nangata biabiadi ne rerenga ikauataki, ata tago ikatiuana be isoaki ki biabiadi ne rerenga tago itagadi masa kalaua kokoko-tina ngadoki. ");
INSERT INTO mva_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ata malipilipi tago ikaua be giriki ono iboadu sururu ngadoki iemaki nge masa kalaua tago kokoko-tina ngadoki. Bokaibe tamoata naita kana kokoko ania ipura masa akangaoia ngapura be kana kokoko-la be ngamuleaki. Be tamoata naita kana bibia luma-nao salangakadi dipura masa tegia ngapura be kana bibia-la be ngakatu. ");
INSERT INTO mva_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ngau kateka ngae eoa oti mbulai kana ka upura. Iei, urere-tina nge kaituka-la be eoa ngaedi damarang. ");
INSERT INTO mva_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ata ngau isi sururu bibia ono rukuiagu ngapura kana nge arogu dieno be utalari! Kaituka-tina nge ilogu isururu-tina, be ilogu bokai ngasusururu nibe sururu bibia mdoki kana nge damanubu! ");
INSERT INTO mva_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ilo-ming dipile ngau anua-uia ka kateka ngae ueluakani ki? Tago-soasoa! Ngau ka ura-kaming! Edua be dua-ramoaki ka ueluaki! ");
INSERT INTO mva_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kaituka be ngalako masa dara tekena-lo tamoata lima disoaki nge daenegei, toli masa rua. ");
INSERT INTO mva_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Masa bokainatuka daenegei: kamoang masa natudi moanekadi daduaduadi, be natu moane masa kamoang daduaduadi. Kipi masa natudi ainekadi daduaduadi, be natu ainekadi masa kipi daduaduadi. Aine barasi masa rauadi kipi daduaduadi, be kipi masa rauadi ainekadi daduaduadi.” ");
INSERT INTO mva_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iesus kababe tamoata be aine bokai iradi, “Bong zim ege amari balaianao ituitui be kate masa bokai kamapile, ‘Ura ngapura kana.’ Be moimoina-tina ura ngapura kana. ");
INSERT INTO mva_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Be bong gamaia oasa ngapura nge bokai kamapile, ‘Kaba daragogo kana.’ Be moimoina-tina kaba daragogo kana. ");
INSERT INTO mva_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bolinga-ming ratadi! Kateka be lang kaitaita be anua irakinga be goalakinga kakauakauataki-ba mua. Bokai nge bakara ka tago kaboadu bong ngaedi kaituka-tina dieno nge kakauataki-ba mua? ");
INSERT INTO mva_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Bakara ka tago neming-la kaliliti-kaming be muzi adoadodi kakauataki? ");
INSERT INTO mva_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamoata kata ‘koto’-lo nganangaiko kana be ibagabagaiko nge gopi-tina be zala-lo be giriki ngaedi goadoraki. Giriki ngaedi zala-lo be tago kuadoraki masa tamoata ngae ngadokirepekiko be tamoata giriki adoadoraki aro ngatuirakiko. Be giriki adoadoraki masa ngadokiko be katonga-oaoa luma-nao nganangaiko be uaura pera-lo ngarokakikolako. ");
INSERT INTO mva_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngau ka ura-kaming! Masa makara uaura pera-lo gosoaki nibe ‘mone’ moarunga gokatu-doi.” ");
INSERT INTO mva_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Bong ngaranao nge tamoata alu dipura be Iesus bokai dirai, “Galili tamoata alu nge Nanaranga tabataba dianiani be Pailot ipile be diumoatedi!” ");
INSERT INTO mva_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Be Iesus ikatu be bokai ipile, “Ilo-ming bakara dipile? Galili tamoata be aine moarunga maradi nge di muzigoala emakingadi digoala-tina ka sururu bibia ngaedi didoki ki? ");
INSERT INTO mva_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ngau ka ura-kaming! Tago be tago-soasoa! Ilo-ming tago kabuiri be muzigoala neming tago kasegeaki nge masa dia-la ara-leuadi dipura bokana ara-leuaming dapura! ");
INSERT INTO mva_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tamoata kulemoa-be-lima-toli pera rakerake odio imakotolako Siloam anua-lo ilo-ming dandi! Nge di muzingadi goalakingadi tamoata be aine moarunga Ierusalem anua-lo diuasadi ka bokai ara-leuadi dipura ki? ");
INSERT INTO mva_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ngau ka ura-kaming! Tago be tago-soasoa! Ilo-ming tago kabuiri be muzigoala neming tago kasegeaki masa dia-la ara-leuadi dipura bokana ara-leuaming dapura!” ");
INSERT INTO mva_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kodeka makara be Iesus pile ono tonanga ngae iradi, “Tamoata teke kai ara ‘pig’ ‘uain’-uma nena-lo itanomi be ilaba. Ilaba nge ilako be kalingo ilelei, ata tago teke ite. ");
INSERT INTO mva_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Bokaibe tamoata ngae itaguraki be tamoata maka uma ne ngae imalipilipitaki bokai irai, ‘Barasi toli ngaedi ilodia-lo nge makare upurapura be kai ngae kalingo mita kana, ata tago teke uteate. Gopoloi! Bakara ka kateka-ba iauia ibizagami?’ ");
INSERT INTO mva_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ata tamoata uma imalipilipitaki bokai ipile, ‘Biabiadi, golikitaki be bokai ngatuitui be barasi tekena-la ngamambuaki noko. Masa msauki be kangkang miani be mte. ");
INSERT INTO mva_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Barasi takaianao kalingo ipuraki nge iuia! Tago nge poloia ngapura!’” ");
INSERT INTO mva_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bong ono manauanga ‘Sabat’ tekenao nge Iesus pera ono serereinga tekena-lo isulesule. ");
INSERT INTO mva_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aine-biabia teke zuzu boaroka nge makara isoaki. Mariaba goalaka kata ilona-lo isoaki ka iemaki be zuzu iboaroka be ambe barasi kulemoa-be-lima-toli dimanubu. Be zuzu nge ambe iboaroka-tina be tago iboadu ngapoaga-rake. ");
INSERT INTO mva_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Bong Iesus aine ngae ite nge ikilamai saringa be bokai irai, “Aine, more nem ngaena-lo ambe rubetakam ipura!” ");
INSERT INTO mva_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kodeka luma ono inangaria be oaikiki-tina zuzu iado be ipoaga-rake be Nanaranga irakeaki. ");
INSERT INTO mva_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tamoata pera ono serereinga ngaena-lo imuamua kaba bokai ita Iesus bong ono manauanga-o ka aine ngae iadoraki nge nama ira-tina, be tamoata be aine makara disoaki bokai iradi, “Amaridi lima-teke nge ono malipinga. Bokaibe amaridi ngaradi ilodia-lo nge kamapurapura be adoraka-ming dapurapura! Moaki bong ono manauanga-o kapurapura!” ");
INSERT INTO mva_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Be Tanepoa ikatu be bokai irai, “Bolinga-ming ratadi! Bong ono manauanga-o nge kalakolako be ‘bulumakau’ be ‘dongki’ neming pera nedia-lo be karurubeti be dang kaniandi be disingsing ki tago? ");
INSERT INTO mva_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aine ngae nge Abaram tubu kata, ata ambe barasi kulemoa-be-lima-toli Satang uaura nena-lo isoaki. Bakara ka tago iboadu bong ono manauanga-o rubetaka ngapura?” ");
INSERT INTO mva_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Bokai ipile nge erekei ne dimaia-tina. Ata tamoata be aine nge kana uarikadi iememaki disuri-uiataki. ");
INSERT INTO mva_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kodeka Iesus kaba bokai itegi, “Bong ono Nanaranga ngatanepoa kana nge rakana bokana? Masa rakana oti mtonangai? ");
INSERT INTO mva_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bokainatuka mtonangai: Tamoata teke ‘mastet’ patu idoki be uma kanana-lo itanomi. Ilaba be kai ipura, be mang dipura be sapara-nao gupadi diemaki.” ");
INSERT INTO mva_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iesus kaba bokai ipile, “Bong ono Nanaranga ngatanepoa kana masa rakana ane mtonangai? ");
INSERT INTO mva_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bokaina-tuka mtonangai: Aine teke ‘is’ idoki be ‘palaua’ biabia-tina zaiza ibairi. Ibairi nibe ‘is’ ngae ‘palaua’ ere-moarunganalo ilako be ‘palaua’ idodoraki-tina.” ");
INSERT INTO mva_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kodeka Iesus itui be Ierusalem anua taona itao. Ialalale nge anua sisiki be bibia makara dieno ialalaleaki be tamoata be aine isulesuledi be ialalale. ");
INSERT INTO mva_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Makara nge tamoata teke Iesus bokai itegi, “Tanepoa, masa tamoata tago kokoko uketadi dapura ki?” Be Iesus ikatu be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kamapi-tina be babaduadua aoa ugugu-lo kamasili. Ngau ka ura-kaming. Tamoata kokoko-tina masa dapi be dasili kana, ata tago diboadu dasili. ");
INSERT INTO mva_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pera-marau ngataguraki be babaduadua ngaonoti masa eluku kamatui be babaduadua kamapalipaliti be bokai kamakorokoroi, ‘Biabiadi, babaduadua gouasara-kama!’ “Ata ngai masa ngakatu be bokai ngapile, ‘Tago ukauataki-kaming! Be tago ukaua inanga ka kapura!’ ");
INSERT INTO mva_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Kodeka kam masa bokai kamarai, ‘Kaiko zaiza tamoanako be dang tasing-budu. Be anua nemai-lo kusule-kama!’ ");
INSERT INTO mva_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ata masa kababe bokai ngapile, ‘Ngau tago ukauataki-kaming! Tago ukaua inanga ka kapura! Kamairatu, kam muzinga-ming goalakadi!’ ");
INSERT INTO mva_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Masa Abaram, Aisak, Zekop be ‘propet’ moarunga bong ono Nanaranga ngatanepoa kanana-lo dasoaki be kamatedi, ata kam masa eluku rokaka-ming-lako dapura. Makara masa kamatangtang be ile-ming kamakaraposaposa! ");
INSERT INTO mva_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tamoata be aine masa ilau, auta, ata be aoa be dapura be kabadi dadoki be bong ono Nanaranga ngatanepoa kanana-lo dasoakiria be moanako biabia daemaki. ");
INSERT INTO mva_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Moimoina-tina tamoata alalauri masa damua, be tamoata muamua masa dalauri.” ");
INSERT INTO mva_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Bong ngaranao nge Parasi alu dipura Iesus-lo be bokai dirai, “Kaba ngaedi gopereki be kaba takadia-lo golako. Erot ambe ngaumoateiko kana.” ");
INSERT INTO mva_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Be Iesus ikatu be bokai iradi, “Kamalale be keu kabukabu ngara bokai kamarai, ‘Ngau masa kaituka be zama mariaba goalakadi tamoata be aine ilodia-lo mtaotaodi be moremore miaka-uiauiakidi, be amaridi tolianao masa malipi negu mambuaki.’ ");
INSERT INTO mva_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ata kaituka be zama be zamane nge mialalale-la kana. Maka ma ‘propet’ tago teke iboadu anua takaiana-lo ngamate. Moarunga nge Ierusalem anua-lo ka dimatemate! ");
INSERT INTO mva_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O, Ierusalem, Ierusalem! Kaiko ‘propet’ moarunga kumoatedi, be tamoata Nanaranga pilenga dieluakiniko nge patu oti kundi! Bong kokoko-tina luma-gu unanaraki be tamoata nem mboabundi kana, mang-la aineka natu bazi erumadi inanganangadi bokana. Ata tago kusumoalana! ");
INSERT INTO mva_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaba goita! Pera nem masa tauna-ba ngaeno! Moimoi ka uraiko! Tago iboadu gotea nibe kaba bokai gopile, ‘Tamoata naita Tanepoa aranao be ipura nge Nanaranga iboadu ngamaroui!’” ");
INSERT INTO mva_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bong ono manauanga ‘Sabat’ tekenao nge Iesus ilako Parasi teke ara otioti pera kanana-lo ngamoanako kana. Makara isoaki nge dimatananganangaia-tina uia. ");
INSERT INTO mva_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tamoata teke ae be luma kauridi nge makara isoaki. ");
INSERT INTO mva_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kodeka Iesus itaguraki be tamoata Moses Mata ne disulesuletaki be Parasi bokai itegidi, “Mata neda Moses igere disumoala ki tago, iboadu bong ono manauanga-o moremore tadoraki?” ");
INSERT INTO mva_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ata di dimoadubulae-ba. Bokaibe Iesus itaguraki be tamoata ngae luma-nao idoki be iaka-uiaki be inepi be ialale. ");
INSERT INTO mva_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kodeka bokai itegidi, “Tekem natum moaneka ki ‘bulumakau’ nem teke bong ono manauanga ‘Sabat’-o be dang-kesua-lo isapasilako masa oaikiki-tina gopasika-rake ki tago?” ");
INSERT INTO mva_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ata tago sesu pilenga dikatu. ");
INSERT INTO mva_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iesus kaba bokai ita tamoata aluluadi dipura be moanako-lo dipura nge alu kaba irakingadi didokidoki. Bokaibe itaguraki be pile ono tonanga ngae iradi, ");
INSERT INTO mva_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bong tamoata teke ialuluiko be moanako ono rotinga nena-lo kulako nge moaki kaba irakingadi kudoki. Baraoa tamoata takaia ara otioti moanako ngarana-lo kilaia ipura! ");
INSERT INTO mva_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bokai masa tamoata maka moanako ngaena-lo ikeliaki-kamingru ngamai be bokai ngaraiko, ‘Tamoata ara otioti ngae kaba irakingadi ngaedi goani.’ Bokai ngaraiko masa gomaia, be golako be muritina-lo kaba godoki. ");
INSERT INTO mva_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ata bong aluluiam ipura be moanako-lo kulako nge kaba muritina-lo godoki. Bokai masa bong tamoata ikilaiko ipura masa bokai ngaraiko, ‘Ruanga, gomai be kaba irakingadi arotina-lo godoki.’ Bokai masa tamoata aluluadi dipura maradi nge muaka bibia godoki. ");
INSERT INTO mva_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tamoata naita nena-la iraketukai masa balaka ngapura. Be tamoata naita nena-la ibalaki masa rakeaka ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kodeka Iesus itaguraki be tamoata moanako ngaena-lo ikeliaki bokai irai, “Bong amari-soasoa moanako, ki rairai moanako kata kuemaki nge moaki ruangam, ki taritokam, ki dara nem, ki tamoata saringam disukoaki kana nedi kokoko kualuludi. Moaki! Bokai kumuzi masa di kaba daluluiko be kamamoanako-budu be ono oti nem dakatuniko. ");
INSERT INTO mva_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bong moanako biabia teke kuemaki nge tamoata kana nedi tagotago, tamoata luma-di matedi, tamoata aedi matedi, be tamoata matadi leuadi goaluludi. ");
INSERT INTO mva_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tamoata bokainaina kualuludi masa Nanaranga-lo marou bibia-tina godoki. Moimoi di tago diboadu oti nem dakatu, ata bong tamoata adoadodi mate-lo be damarang kananao masa oti nem ngaedi Nanaranga ngakatuniko.” ");
INSERT INTO mva_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tamoata teke makara bagi ono moanakonga-lo isoaki pile ngaedi ilongo nge Iesus bokai irai, “Tamoata naita bong ono Nanaranga ngatanepoa kanana-lo moanako biabia-lo ngamoanako kana nge iboadu marou bibia ngadoki!” ");
INSERT INTO mva_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Be Iesus pilenga ikatu be bokai ipile, “Tamoata teke moanako biabia teke iememaki bokana lou kokoko-tina ialuludi be dapura kana. ");
INSERT INTO mva_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Moanako biabia ngae bong ne dipura nge malipilipi kana bokai irai, ‘Goalale be tamoata moanako ngaena-lo aluluiadi dipura bokai goradi, “Kamapura, kana moarunga ambe adorakadi dipura be dieno.” ’ ");
INSERT INTO mva_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ata di moarunga nge zala dilelei be ono moanako ngaena-lo tago dapura kana. Teke bokai ipile, ‘Uma teke uzazai be mialale be mte kana. Bokaibe tago masa mpura.’ ");
INSERT INTO mva_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Takaia bokai ipile, ‘Ngau ‘bulumakau’ kulemoa uzazadi be mialale be mtoidi kana. Bokaibe tago masa mpura.’ ");
INSERT INTO mva_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Be kaba takaia bokai ipile, ‘Ngau kodeka ka uroti. Bokaibe tago masa mpura.’ ");
INSERT INTO mva_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kodeka malipilipi ngae imule be kana moarunga ngaedi nge biabiadi ne irangakini. Biabiadi ne ilongo nge nama ira-tina be malipilipi kana bokai irai, ‘Oaikiki-tina goalale anua-lo be zala bibia moarunga-lo, be zala mukudi moarunga-lo be tamoata kana nedi tagotago, tamoata luma-di matedi, tamoata matadi leuadi, be tamoata aedi matedi goaluludi be dapura.’ ");
INSERT INTO mva_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Be malipilipi ngae oaikiki-tina ialale be imule nge bokai ipile, ‘Biabiadi, pilengam ambe tagadi dipura, ata isi kaba bibia-tina dieno.’ ");
INSERT INTO mva_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Bokaibe biabiadi ne bokai ipile, ‘Goalale zala bibia be sisiki anua takadia-lo dilako-lo be tamoata kutedi nge goaluludi be dapura. Bokai masa pera kanagu ngakauri.’ ");
INSERT INTO mva_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ngau ka ura-kaming. Tamoata aluluiadi dipura nge tagona-tina iboadu teke moanako negu monanga datoi!” ");
INSERT INTO mva_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tamoata be aine nge dum kokoko-tina Iesus zaiza zala-lo dialalale-budu. Kodeka Iesus ibuiri be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tamoata naita ngau-lo imai nge tago iboadu tagataga negu ngapura. Tago-la! Tama be tina, roa be natu, be taritoka be marau isegeakidi, be nena-tina ma ka isegeaki ka masa iboadu tagataga negu ngapura. Tago be tago! ");
INSERT INTO mva_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Be tamoata naita kai ne kapalapala uauau tago ibazi be itagaia nge tago iboadu tagataga negu ngapura. ");
INSERT INTO mva_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Bokai mtonanga be kamakaua: Tekem pera rakebuli teke ngakeli kana nge masa baituka ngamuzi? Matamata ngasoakiria be kai be kana ono pera kelinga ngakauataki be masa ‘mone’-di ngalelei. ‘Mone’ iboadu masa pera ngae ngakeli. Tago iboadu nge tago ngakeli. ");
INSERT INTO mva_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tago bokai imuzi mua masa pera ngae aririna-ba ngatuiraki, ata tago iboadu ngamambuaki. Be tamoata moarunga pera aririna-ba daita masa dasakorangaki be ");
INSERT INTO mva_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","bokai dapile, ‘Tamoata ngae pera imarangaki, ata tago iboadu ngamambuaki.’ ");
INSERT INTO mva_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Kababe bokai mtonanga: Anuatanepoa kata ‘10,000’ koai-tamoata ne idokidi be ilako anuatanepoa takaia koai-tamoata ne ‘20,000’ zaiza daeung kana masa rakana ngaemaki? Matamata ngasoakiria be ilo ngalelenaki ngai kaiboang ne dieno be iboadu anuatanepoa takaia ‘20,000’ koai-tamoata ne zaiza ngauasadi ki tago? ");
INSERT INTO mva_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tago iboadu nge masa ngataguraki be tamoata alu nganepidi be dalale be anuatanepoa takaia isi kasau isoaki be date be pile dapali be kaba anua-uia dadoki. ");
INSERT INTO mva_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bokainatuka-la, tamoata naita mara-ming kana ne moarunga tago isegeaki nge tagona-tina iboadu tagataga negu ngapura! ");
INSERT INTO mva_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Makasi nge kana iauia, ata bong kapisanga daleua masa baituka tabasaki be kaba kapisanga tamuleaki? ");
INSERT INTO mva_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Makasi bokainaina nge tago iboadu kana teke ono emaka ngapura ki uma-lo nangaia ngapura be ono kateka monanga ngapuraki. Tago-la! Makasi bokainaina nge rokaka ipurapura. Be Iesus pile ne ngaedi ono ngamambuaki kana nge bokai ipile, “Tamoata kungi otioti nge pile ngaedi ngalongo!” ");
INSERT INTO mva_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bong teke tamoata ‘tagisi’ dokidoki be tamoata muzigoala ememaki dipura be dikabuni be Iesus dalongori kana. ");
INSERT INTO mva_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Makara nge Parasi be tamoata Moses Mata ne disulesuletaki ditaguraki be ambe Iesus bokai digulugulungaetaki, “Tamoata ngae nge muzigoala ememaki imolamolatakidi be dimoanakonako-budu.” ");
INSERT INTO mva_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Kodeka Iesus itaguraki be pile ono tonanga ngae iradi, ");
INSERT INTO mva_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tamoata teke mara-ming ‘sipisipi’ ne ‘100’ moarunga, be teke ileua masa rakana ngaemaki? Tamoata ngae masa ngataguraki be ‘99’ takadi kaba ono ramomonga-lo ngaperekidi daramomomo be ngalale be teke ileua nge ngalelei nibe ngate. ");
INSERT INTO mva_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bong ngate masa suri dauia-tina be bage-nao ngasalangaki be ngabazi ");
INSERT INTO mva_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","be kaba kana ngalako. Kodeka ruanga be tamoata saringa disukoaki ngakiladi be bokai ngaradi, ‘Ngau zaiza suri-uia taemaki. ‘Sipisipi’ negu ileua ambe ute.’ ");
INSERT INTO mva_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngau ka ura-kaming. Bokainatuka-la, ‘sipisipi’-la leua ngae bokana, lang anua-lo masa suri-uia bibia-tina emakadi dapura bong tamoata muzigoala ememaki teke ilo ibuiri be muzigoala ne isegeaki. Tamoata ‘99’ uia nge diado ka disoaki, ata tamoata muzigoala ememaki kata ilo ibuiri be muzigoala ne isegeaki nge suri-uiataka dalaba-tina kana! ");
INSERT INTO mva_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Aine teke ‘mone’ ne kulemoa, be teke ileua masa rakana ngaemaki? Masa baratui ne ngabulai be pera kana ngaroroi be ‘mone’ leua nge ngalelea-tina uia nibe ngate. ");
INSERT INTO mva_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Be bong ite masa ruanga be tamoata saringa disukoaki ngakiladi be bokai ngaradi, ‘Ngau zaiza suri-uia taemaki. ‘Mone’ negu ileua ambe ute.’ ");
INSERT INTO mva_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngau ka ura-kaming. Bokainatuka-la, ‘mone’-la ngae leua bokana, bong tamoata muzigoala ememaki ilo ibuiri be muzigoala ne isegeaki masa Nanaranga ‘enzel’ ne suridi dauia-tina.” ");
INSERT INTO mva_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Be Iesus kaba bokai ipile, “Tamoata teke isoaki natu moanekadi rua. ");
INSERT INTO mva_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Natu sikisiki itaguraki be tama bokai irai, ‘Mamo, kana nem moarunga gonege-kamairu be egedi takadi negu goana.’ Bokaibe tamoata ngae itaguraki be kana ne moarunga nge natu ruoti ngae-diaru inege-diaru. ");
INSERT INTO mva_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Uanana tago disalaga be natu sikisiki nge kana ne moarunga idoki be masoasoa kaba tekedia-lo ilako. Makara isoaki be kana ne moarunga nge ramoramo-ba rerengana-lo irokaki be ono ne kusi suri-uia iani. ");
INSERT INTO mva_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kana ne moarunga irokaki-doi, kodeka alauri nge tole biabia teke kaba ngaradia-lo ipura. Be natu ngae nge kana ne tago-tina. ");
INSERT INTO mva_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Bokaibe ilako be anua-marau tekena-lo be ngamalipini kana. Be anua-marau ngae itaguraki be inepi be ilako boro ne iakolakola. ");
INSERT INTO mva_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Makara imalipilipi nge tole-toleba imalipilipi. Be tamoata tago teke kangkang ianiani be ikangkang. Ilo nge boro kangkang kandi alu ngakangkang kana irere. ");
INSERT INTO mva_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Makara isukoaki nibe ilo ipitilaki nge bokai ipile, ‘Tamagu malipilipi ne moarunga nge kangkang-lo diboaduboadu-tina be alu dieneno-ba, be ngau makare nge ambe saringatuka tole matea mate kana! ");
INSERT INTO mva_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Masa mtui be mialale be tamagu-lo be bokai mrai: Mamo, ngau Nanaranga-lo be kaiko-lo muzigoala uemaki. ");
INSERT INTO mva_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ngau tago uboadu natum kana gokilakilaia. Godoka be malipilipi nem bokana be malipilipiniko.’ ");
INSERT INTO mva_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bokaibe itui be tamana-lo ilako. “Ata tama nge natu isi kasau-lanalo be itealako nge ilo itagaia-tina. Bokaibe ipapanana-la be ilako be natu iboabuni be iaroki. ");
INSERT INTO mva_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Kodeka natu ngae tama bokai irai, ‘Mamo, ngau Nanaranga-lo be kaiko-lo muzigoala uemaki. Tago iboadu natum kana gokilakilaia.’ ");
INSERT INTO mva_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ata tama itaguraki be malipilipi ne ikiladi be bokai iradi, ‘Kusi-sili uarikana-tina kamabagai be kamasiliakani. Be bokiboki kabona-lo kamanangalako be ae-sukuma aena-lo kamananga. ");
INSERT INTO mva_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kamangazingia-doi kodeka kamalako be ‘bulumakau’ natu moaneka dabudabu uarikana-tina nge kamadoki be kamaumoatei, be ono moanako biabia teke taemaki be surida dauia. ");
INSERT INTO mva_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Labu ono surida dauia kana nge bokai: Natugu ngae nge imate, ata ambe imoauri. Ileua, ata ambe tea ipura.’ Bokaibe ditaguraki be moanako biabia be suri-uia ngae dimarangaki. ");
INSERT INTO mva_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bong kana ngaedi bokai emakadi dipurapura nge natu labalaba uma-lo imalipilipi. Be bong pera-lo imulemule nge oagu be moasi ilongo. ");
INSERT INTO mva_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bokaibe malipilipi teke ikilai be bokai itegi, ‘Rakana diememaki?’ ");
INSERT INTO mva_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Be malipilipi ngae ikatu be bokai ipile, ‘Tarim imule ka tamam ‘bulumakau’ natu moaneka dabudabu uarika nge iumoatei be ono moanako biabia teke emaka ipurapura. Bakara, tarim ne iauia-la be imule. Tago sesu ba iuai.’ ");
INSERT INTO mva_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Labalaba pile ngaedi ilongo nge nama ira-tina, be pera-lo sili isege. Bokaibe tama ipusika be ilako iakoroi be ngasili kana. ");
INSERT INTO mva_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ata natu labalaba itaguraki be tama pilenga bokai ikatu, ‘Kaba goita! Ngau barasi kokoko-tina dududu-ba bokana umalipiniko. Pilengam moarunga nge ulongolongo-la. Tago sesu ukai-niko. Ata kana tago teke kuemakana! ‘Meme’ natu-ba teke goana be ono ruangagu zaiza moanako biabia teke gaemaki nge tago-soasoa! ");
INSERT INTO mva_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ata natum ngae maka kana nem moarunga igamangramo-ba aine pogizagizadi zaiza be bong imule nge ‘bulumakau’ natu dabudabu uarika kumoateani!’ ");
INSERT INTO mva_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Be tama ikatu be bokai ipile, ‘Natugu, kaiko izamaizama sakeguo kusukoaki. Be kana negu moarunga nge nem. ");
INSERT INTO mva_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ata nge iuia-tina suri-uia taemaki be surida dauia, bakara tarim ngae nge imate, ata kaba imoauri. Ileua, ata kaba tea ipura.’” ");
INSERT INTO mva_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kodeka Iesus itaguraki be tagataga ne bokai iradi, “Tamoata teke ‘mone’ ne kokoko nge tamoata kauakaua teke ‘mone’ pananuakadi iamang idoki be ‘mone’ ne be kana ne moarunga ipapananuakini. Bong teke tamoata ‘mone’ ne kokoko bokai dirai, ‘Malipilipi nem ‘mone’ nem ibibizagam-ba!’ ");
INSERT INTO mva_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bokaibe tamoata ngae malipilipi ne ikilai be bokai irai, ‘Baituka ka bokai dirangarangakiko be ulongo? Golako be kana negu moarunga rangakadi moarunga gogere be mita. Ambe umambuakiko! Tago ambe gomalipilipina kana!’ ");
INSERT INTO mva_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Makara nge malipilipi ngae bokai ilo ilelenaki, ‘Masa rakana memaki? Biabiadi negu ambe ngataona kana. Kateka mokiri kana nge kaiboang-ma negu tago! Be ‘mone’ be kangkang msinaunau kana nge umaia-ma! ");
INSERT INTO mva_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kodeka ukaua masa rakana memaki! Alauri malipi negu ngaedia-lo ditaona masa ruangagu otioti be pera kandia-lo dabagaiaulako.’ ");
INSERT INTO mva_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Bokaibe tamoata moarunga oti nedi biabiadi nena-lo dieno nge ikiladi be dipura. Tamoata ipuratuka-mua nge bokai itegi, ‘Biabiadi negu-lo oti nem bakarairai kaoa dieno?’ ");
INSERT INTO mva_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Be tamoata ngae ikatu be bokai ipile, “800 galen olib’ damaka.’ “Kodeka malipilipi ngae bokai ipile, ‘Pepa’ ono oti katunga maka! Godoki be gosoakiria be ‘400’-la kana gogere!’ ");
INSERT INTO mva_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kodeka itaguraki be tamoata takaia ipura bokai itegi, ‘Be kaiko? Oti nem bakarairai kaoa dieno?’ “Be tamoata ngae ikatu be bokai ipile, ‘1,000 ‘uit’ mazapi!’ Kodeka malipilipi ngae itaguraki be tamoata ngae bokai irai, ‘Pepa’ ono oti katunga maka! Godoki be gosoakiria be ‘800’-la kana gogere!’ ");
INSERT INTO mva_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Malipilipi ngae bibiadi kana bokai ilongo nge itaguraki be malipilipi pangana dadaka ngae nge irakeaki, bakara malipilipi ngae nge aro-lo ilo ilelenakalako be kana bokainaina iemaki. Bokainatuka-la, tamoata kateka ngaena-onaona nge aro-lo kana ilodi dianiandialako be boli muzi-lo be tamoata ruangadi diruaruangamdi. Ata tamoata malama-lo disukoaki nge kana bokainaina emakadi tago dikaua uia. ");
INSERT INTO mva_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Bokai ka ngau bokai ura-kaming: Kateka kana ane be tamoata takadi kamaruangamdi. Be bong kateka kana ngaedi dimanubu-kaming masa nem-kusoaki soaki ipurapura-lo kamalako. ");
INSERT INTO mva_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tamoata naita malipi mukumukudi luma-nao nangadi dipura be emakadi iamang masa malipi bibia emakadi ngamang. Tamoata naita malipi mukumukudi emakadi tago iamang uia masa malipi bibia emakadi tago ngamang uia. ");
INSERT INTO mva_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bokaibe, kateka kana lumam-o nangadi dipura be adorakadi tago kuiamang-uia masa baituka be kana nem-kueno dieneno nge emakadi goamang-uia? ");
INSERT INTO mva_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Be tamoata takaia kana ne tago kuadoadoraki-uia masa naita kana nem-tina ngangko? ");
INSERT INTO mva_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Tago teke iboadu bong-doi teke tamoata bibia rua ngamalipilipidi. Takaia masa ngasegesegeaki be takaia masa ngarereretaki. Takaia masa ngatalatalari be takaia masa ngamurinarinai. Tago iboadu Nanaranga be ‘mone’ malipi nedi bong-doi teke kamaememaki.” ");
INSERT INTO mva_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","‘Mone’ kokoko dokiadi kana nge Parasi moaledi dipusikasika-tina. Bokaibe bong Iesus pile ngaedi ipile nge dingengeri. ");
INSERT INTO mva_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ata Iesus bokai iradi, “Kam-tina ma ka tamoata takadi matadi-o neming-la kararangaki-kaming kam tamoata adoado-ming, ata Nanaranga ilo-ming moapurungadi ikauataki. Maka ma kana moarunga tamoata dirarangaki aradi bibia nge Nanaranga mata-nao kanaba-tina. ");
INSERT INTO mva_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moses Mata ne be ‘Propet’ gerengadi nge disingarangara-kaming nibe imai-ba Zon Baptais bong nena-lo daga. Be Zon Baptais bong nena-lo be imai nge Pile Uia bong ono Nanaranga ngatanepoa kana nge mangata rangaka ipurapura. Bokaibe tamoata moarunga ambe nedia-la be panganadi dizezeleki be disilisili. ");
INSERT INTO mva_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ata bokai kamakaua: lang be kateka nge iboadu-tina daleua, ata siriki mukumukunatuka Moses Mata nena-lo dieno nge tago teke iboadu ngaleua. ");
INSERT INTO mva_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Tamoata naita roa isegeaki be aine takaia iuati nge roti igamani. Be tamoata naita aine sesegeaki iuati nge roti igamani be. ");
INSERT INTO mva_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tamoata teke ‘mone’ be kana ne kokoko isoaki. Tamoata ngae nge kusi ne uarikadia-ba oti ingazingzing. Izamaizama nge kangkang uia ikangkang be kana ne moarunga nge zazadi atabalabala-tina. Bokaibe soakingana-lo nge iboadu-tina. ");
INSERT INTO mva_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Bong ngaradia-lo nge tamoata teke kana ne tagotago isoaki ara Lasarus. Tamoata ngae kusi moarunga-o nge poake dieno. Izamaizama nge Lasarus dieleluaka be tamoata kana ne kokoko pera kana babaduaduana-lo isukoaki be isinaunau. ");
INSERT INTO mva_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ilo ipilepile makara ngasukoaki masa kangkang bururuingadi tamoata kana ne kokoko bagi ne ono moanakonga-lo dasapasipasi be ngadokidoki be ngakangkang. Makara bokai isukoaki nge keu dipurapura be poake didadamili. ");
INSERT INTO mva_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Bong Lasarus imate nge Nanaranga ‘enzel’ ne dibagai be Abaram malolona-lo dilakuaki. Be tamoata kana ne kokoko nge imate be kumraka ipura, be eoa tago matemate-lo ilako. ");
INSERT INTO mva_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Makara nge sururu bibia-tina idokidoki. Eoa tago matemate-lo be itadarake nge Abaram kasautina-lo itealako. Be Lasarus nge Abaram malolona-lo isoaki be ite. ");
INSERT INTO mva_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Bokaibe ipi-tina be bokai imere, ‘Tamagu Abaram! Ilom ngatagaia. Lasarus gonepi be kabo dang-lo nganangalako be ono memegu ngaka-tumurai. Maka ma sururu bibia-tina eoa ngaedia-lo udokidoki!’ ");
INSERT INTO mva_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ata Abaram ikatu be bokai ipile, ‘Natugu, ilom bokai ngakaua! Bong kateka-o kusoaki nge kana irakingadi kudoki, be Lasarus kana goalakingadi idoki. Ata kaituka ambe ngai suri diuiauia be kaiko sururu bibia kudokidoki. ");
INSERT INTO mva_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ak, kana takaia nge bokai: Dugua ilo totobali teke marada ieno. Bokaibe tamoata teke makare be makara kam-lo ngamai kana nge tago iboadu. Be teke makara kam-lo be makare kekai-lo ngamai kana nge tago iboadu!’ ");
INSERT INTO mva_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Be tamoata kana ne kokoko itaguraki be bokai ipile, ‘Tamagu Abaram, bokai nge ngau bokai uakoroiko! Lasarus gonepi be tamagu pera kanana-lo ngalako. ");
INSERT INTO mva_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Maka ma taritokagu lima makara disoaki. Ngalako be ngailo-kauadi kaba ono sururunga ngaedia-lo dalako takana!’ ");
INSERT INTO mva_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Be Abaram bokai ikatu, ‘Taritokam Moses be ‘Propet’ gerengadi dienodi. Datagatagadi!’ ");
INSERT INTO mva_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Kodeka tamoata kana ne kokoko itaguraki be bokai ipile, ‘Tamagu Abaram, nge tago iboadu! Tamoata teke imate be kababe dia-lo imule masa ilodi dabuiri be muzigoala nedi dasegeaki.’ ");
INSERT INTO mva_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ata Abaram ikatu be bokai ipile, ‘Moses be ‘Propet’ pilengadi tago dilongo nge tagona-tina iboadu tamoata teke mate-lo be ngamule nge pilenga dalongo! Tago-la!’” ");
INSERT INTO mva_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesus tagataga ne bokai iradi, “Kana maka tamoata direrepekidi be muzigoala diememaki nge dapurapura kana! Ata muzigoala labuna-tina nge imakadoma-tina! ");
INSERT INTO mva_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nge iuia tamoata bokainaina patu kanabiabia teke duduna-lo tukuia be makasi-lo rokakalako ngapura. Ngasoaki be natu-muku teke ngarepeki be muzigoala teke ngaemaki takana! ");
INSERT INTO mva_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Bokaibe kaba kamaitaita uia! “Taritokam kata muzigoala iemaki nge goebuloi. Ilo ibuiri be muzigoala ne isegeaki nge muzigoala ne gorokakile. ");
INSERT INTO mva_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bong lima-rua amari tekena-lo muzigoala iemakiniko, be bong lima-rua ipuraniko be bokai iraiko, ‘Muzigoala negu gorokakilea,’ nge muzigoala ne gororokaki-la.” ");
INSERT INTO mva_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kodeka ‘apostel’ ditaguraki be Tanepoa bokai dirai, “Lama uniangama goaka-labati!” ");
INSERT INTO mva_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Be Tanepoa ikatu be bokai ipile, “Lama unianga-ming labatikadi dedau patu bokana nge iboadu kai biabia teke bokai kamarai, ‘Nem-la be ere-zirim gotetekiko be makasi-lo gotanomiko,’ nge ngalongori-kaming-la be kana! ");
INSERT INTO mva_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Tekem malipilipi kanam uma-lo kateka iokiokiri ki ‘sipisipi’ nem iakolakola be bong imule nge masa gorai be oaikiki-tina ngamaraka be ngamoanako ki? ");
INSERT INTO mva_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Tago iboadu! Masa bokai gorai, ‘Kangkang kanagu goemakana! Goemaki-doi, kodeka kangkang kanagu goeluakina be sakeguo gosoaki be moanako be dang msing. Alauri ka kaiko gomoanako!’ ");
INSERT INTO mva_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Malipilipi kanam bokai imuzi masa gotaguraki be goperui ki tago? Tago-soasoa! Ngena malipi ne ka iemaki! ");
INSERT INTO mva_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Bokaibe kam nge bokainatuka-la malipilipi ngae imuzi bokana. Bong malipi moarunga rangakadi dipura kaemaki-doi nge bokai kamapile, ‘Keka malipilipi-ramo kaoa. Ngena malipi nema ka kiemaki!’” ");
INSERT INTO mva_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Bong Iesus Ierusalem ilakolako nge Samaria kaba be Galili kaba dagadaga nedia-lo ialale. ");
INSERT INTO mva_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Anua tekena-lo isilisili nge tamoata kulemoa kikiri odio dieno nge ipurakadi. Tamoata ngaedi nge lauaba-nao ditui ");
INSERT INTO mva_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","be dimere be bokai dipile, “Iesus! Biabiadi! Ilom ngataga-kama!” ");
INSERT INTO mva_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Iesus itedi nge bokai ipile, “Kamalale be tamoata Nanaranga ditabatabai teke ngaliliti-kaming!” Dialalale zala-lo nge nedia-la ditedi ambe digoaza. ");
INSERT INTO mva_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bong tamoata teke maradi kaba bokai ita ambe iuia nge kababe imule. Imulemule nge ipi-tina be Nanaranga irakerakeaki be imule. ");
INSERT INTO mva_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kodeka ilako be Iesus ae babadia-lo itapuloria be iperui. Tamoata ngae nge Samaria tamoata kata. ");
INSERT INTO mva_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Makara nge Iesus bokai ipile, “Tamoata kulemoa ka aka-goazadi dipura! Lima-oati takadi inanga disoaki? ");
INSERT INTO mva_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bakara ka ungguma akerengana-tina ngae nge ngaia-la ipura be Nanaranga iperui?” ");
INSERT INTO mva_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kodeka Iesus itaguraki be tamoata ngae bokai irai, “Gotui-rake be goalale! Lama uniangam ka iemakiko be kuia!” ");
INSERT INTO mva_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bong teke Parasi alu ditaguraki be Iesus bokai ditegi, “Aira be masa bong ono Nanaranga ngatanepoa kana nge ngapura?” Be Iesus ikatu be bokai ipile, “Bong ono Nanaranga ngatanepoa kana masa tago tea ngapurapura be ngapura. ");
INSERT INTO mva_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Be tago teke iboadu bokai ngarangaki, ‘Kamate, maka ieno,’ ki bokai ngapile, ‘Ene ieno!’ Maka ma bong ono Nanaranga ngatanepoa kana nge ambe mara-ming isoaki.” ");
INSERT INTO mva_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Kodeka tagataga ne bokai iradi, “Bong masa dapura, be bong ngaradio nge masa bokai kamapile, ‘Tamoata Natu bong ne teke gatea-tina kana kirere.’ Ata tago iboadu masa kamate. ");
INSERT INTO mva_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tamoata masa bokai dara-kaming, ‘Kamate, enera isoaki,’ ki bokai dara-kaming, ‘Kamate, makare isoaki!’ Ata moaki kalako be kalelei. ");
INSERT INTO mva_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Bakara, Tamoata Natu bong nenao masa lamalama-la bokana ngamuzi. Masa lamalama ipitikaoakaoai be lang ege takaianao be ilakolako ege takaianao be lang iaka-malamalamai bokana ngamuzi. ");
INSERT INTO mva_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ata sururu bibia-tina ngadoki be tamoata bong ngaedia-lonalona damurinai noko. ");
INSERT INTO mva_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noa-la bong nena-lo bokana, Tamoata Natu bong nena-lo masa bokainatuka-la. ");
INSERT INTO mva_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tamoata be aine moarunga nge dimoanakonako be dang disingsing, moane be aine dirotiroti-la nibe ilako bong Noa kati-o ibulilako, be ura be dang bibia dipura be moarunga diara-leuadi. ");
INSERT INTO mva_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Bokainatuka-la, Lot bong nena-lo nge bokai dimuzi be. Tamoata moarunga nge dimoanakonako be dang disingsing, kana dizaza be ditabulibuli, kangkang ditanotano be pera dikelikeli. ");
INSERT INTO mva_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amari ngarana-lo bong Lot Sodom anua ipereki nge eoa be sosodabu ura bokana lang-lo dibala be moarunga diara-leuadi. ");
INSERT INTO mva_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tamoata Natu bong ne ono mangata ngapura kananao masa kana bokainatuka-la ka dapura kana. ");
INSERT INTO mva_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Bong ngaranao nge tamoata pera kana aro isoaki moaki ikautaki pera kanana-lo be kana ne idoki. Bokainatuka-la, tamoata uma kanana-lo isoaki nge moaki pera kanana-lo imulelako be kana ne teke ibagai. ");
INSERT INTO mva_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot roa ilo-ming dani! ");
INSERT INTO mva_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tamoata naita nena-la ngauketi be moauriuri ngasoaki kana masa ngaleua. Ata tamoata naita nena-la ileua masa nena-la ngauketi be moauriuri ngasoaki. ");
INSERT INTO mva_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ngau ka ura-kaming! Oabubu ngarana-lo masa tamoata rua zirapu tekedia-lo daenoru. Takaia masa bagaia ngapura, be takaia masa pereka ngapura. ");
INSERT INTO mva_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aine rua masa kangkang darasirasiru. Takaia masa bagaia ngapura, be takaia masa pereka ngapura.  ");
INSERT INTO mva_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tamoata rua masa uma-lo damalipilipiru. Takaia masa bagaia ngapura, be takaia masa pereka ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tagataga ne pile ngaedi dilongo nge bokai ditegi, “Tanepoa, kana ngaedi masa inangaituka be dapura?” Be Iesus ikatu be bokai ipile, “Ngado imate be ieno kana masa mang moapuru kangkang dapura be dakabuni.” ");
INSERT INTO mva_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kodeka Iesus itaguraki be pile ono tonanga tekedi tagataga ne iradi be ono itikingdi izamaizama daraborabo be moaki sesu sakuli nedi dibala. ");
INSERT INTO mva_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Iesus bokai ipile, “Anua tekena-lo nge tamoata giriki adoadoraki teke isoaki. Ngai Nanaranga tago imatakutakuri, be tamoata tago imuamuakidi. ");
INSERT INTO mva_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Be anua-la ngarana-lo nge aine narenare teke isoaki. Izamaizama nge narenare ngae tamoata biabia ngaena-lo ipurapura be bokai iakorokoroi, ‘Erekei negu teke igoalangakau-tina. Godumaia!’ ");
INSERT INTO mva_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Narenare nge bokai ilakolako imulemule, ata tamoata ngae dumaia isege-tina. Narenare ilakolako imulemule nibe alaurituka nge tamoata ngae nena-la bokai ipile, ‘Moimoi ngau Nanaranga tago umatakutakuri ki tamoata takadi tago umuamuakidi. ");
INSERT INTO mva_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ata narenare ngae nge ambe ilako be imule-na, be ambe ilogu iaka-tina. Mduma-lako be giriki ne adorakadi dapura! Tago udumai masa ngalakolako ngamulemule nibe ngakangaoia be mpoaki kana!’” ");
INSERT INTO mva_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Be Tanepoa itaguraki be bokai ipile, “Tamoata giriki adoadoraki goalaka ngae pilenga kamalongo uia! ");
INSERT INTO mva_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bokaibe ilo-ming bakara dipile? Nanaranga masa tamoata be aine ne izamaizama ariata be oabubu-lo ditangtangni ngadumadi be moatubu nedi ngadorakidi ki tago? Be masa oaikiki-la be ngadumadi ki tago? ");
INSERT INTO mva_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngau ka ura-kaming! Masa ngadumadi be muridi ngatui kana! Be kana ngae masa oaikiki-la be ngaemaki. Ata bong Tamoata Natu kateka ngaenao ngapura masa lama uninga ngate ki tago?” ");
INSERT INTO mva_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tamoata alu nge nedia-la diraketukatukadi be dipilepile di tamoata adoadodi be tamoata be aine takadi dibabalakidi. Bokai ka Iesus itaguraki be pile ono tonanga ngaedi ipile, ");
INSERT INTO mva_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tamoata rua dilakoru Nanaranga pera nena-lo be daraboru kana. Takaia nge Parasi kata, be takaia nge ‘tagisi’ dokidoki kata. ");
INSERT INTO mva_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parasi itui be nena-la bokai irabotaki, ‘Nanaranga, uperuiko-tina. Ngau tago tamoata takadi bokana. Tago uanakonako, tago uboliboli, be roti mata tago ugamagamani be aine takadi zaiza kieneno-budu. Uperuiko ngau tago tamoata ‘tagisi’ dokidoki ngara bokana. ");
INSERT INTO mva_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bong rua-rua ‘uiki’ teke ilona-lo nge kangkang uziraurau, be kana negu moarunga nge kulemoa-kulemoa-lo unegenege be egedi tekedi uianangko.’ ");
INSERT INTO mva_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ata tamoata ‘tagisi’ dokidoki nge lauaba-nao itui. Lili nge tagona-tina idokitate. Tutudu-la be nena-la barabara izabonununuki be bokai ipilepile, ‘Nanaranga, ilom ngatagaia. Ngau muzigoala ememaki!’” ");
INSERT INTO mva_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Makara nge Iesus itaguraki be bokai ipile, “Ngau ka ura-kaming! Tamoata ngae, tago takaia, ka Nanaranga mata-nao iado be pera kanana-lo ilako. Bakara, tamoata naita nena-la irakerakeaki masa balaka ngapura. Be tamoata naita nena-la ibalabalaki masa rakeaka ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tamoata alu natudi dieluakidi be Iesus luma odio nganangaria be ngamaroudi kana. Ata tagataga ne kaba bokai dita nge ditaguraki be diebulodi. ");
INSERT INTO mva_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ata Iesus itaguraki be natu-muku ikiladiamai be bokai ipile, “Natu-muku kamalikitakidi be ngau-lo damai. Moaki zalakadi kaono. Bakara, bong ono Nanaranga ngatanepoa kana nge bokainaina nedi. ");
INSERT INTO mva_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Moimoi ka ura-kaming! Tamoata naita bong ono Nanaranga ngatanepoa kana tago natu-muku bokana be idoki nge tago iboadu ilona-lo ngasili.” ");
INSERT INTO mva_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Iuda tamoata nedi biabia teke itaguraki be Iesus bokai itegi, “‘Tisa’ iauia, rakana memaki masa moauriuri-la nem-kusoaki soaki ipurapura nge mdoki be mnemi?” ");
INSERT INTO mva_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Be Iesus ikatu be bokai itegi, “Bakara ka iauia kana kukilaia? Tamoata tago teke iauia. Nanaranga-la rube ka iauia! ");
INSERT INTO mva_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kaiko Nanaranga mata ne kukauataki. Mata ma ngaedia-re: ‘Roti moaki kugamani be aine takaia kamru kaeno-buduru; tamoata takaia moaki kumoatei; moaki kuianako; tamoata takaia moaki kuboliaki; be tinam be tamam gomuamuakidi.’” ");
INSERT INTO mva_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Be tamoata ngae ikatu be bokai ipile, “Ngau isi natu-tina be mata ngaedi utagatagadi.” ");
INSERT INTO mva_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesus pilenga ngaedi ilongo nge bokai irai, “Isi kana-la tekena-lo ka kutukura. Goalale be kana nem moarunga ‘mone’ odio godoki be ‘mone’ ngaedi godoki be tamoata kana nedi tagotago goandi. Bokai masa Nanaranga kana uia-tina lang anua-lo ngangko be kana nem dakoko-tina. Kana ngaedi goemaki-doi, kodeka gomai be gotagaia.” ");
INSERT INTO mva_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tamoata ngae nge kana ne kokoko-tina. Bokaibe pile ngaedi ilongo nge ilo inodo-tina. ");
INSERT INTO mva_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesus kaba bokai ita tamoata ngae ilo inodo-tina nge bokai ipile, “Tamoata kana nedi kokoko masa anua ono Nanaranga ngatanepoa kanana-lo lako daradia-tina! ");
INSERT INTO mva_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Bokainatuka mtonanga. ‘Kamel’ lili kusi-kalaura boazingana-lo ngasili kana masa sili tagona-tina darai. Ata tamoata kana ne kokoko anua ono Nanaranga ngatanepoa kanana-lo ngasili kana masa sili daraia-tina!” ");
INSERT INTO mva_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Be tamoata pile ngaedi dilongo nge bokai ditegi, “Bokai nge alauri masa Nanaranga naita ngauketi be ngamuleaki?” ");
INSERT INTO mva_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Be Iesus ikatu be bokai ipile, “Kana maka tamoata tagona-tina diboadu daemaki nge Nanaranga iboadu ngaemaki.” ");
INSERT INTO mva_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kodeka Pita itaguraki be bokai ipile, “Gote! Keka kana nema moarunga kipereki be kitagaiko.” ");
INSERT INTO mva_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Be Iesus ikatu be bokai iradi, “Moimoina-tina ka ura-kaming! Tamoata naita bong ono Nanaranga ngatanepoa lili-nao be pera kana, ki roa, ki taritoka, ki tama be tina, ki natu iperekidi ");
INSERT INTO mva_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","masa kaituka-tina bong ngaedia-lo zazanga bibia-tina Nanaranga-lo ngadoki. Be bong alalauri-lo masa moauriuri-la nem-kusoaki ngasukoaki.” ");
INSERT INTO mva_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kodeka Iesus tagataga ne kulemoa-be-rua lauaba-nao ilakuakidi be bokai iradi, “Kamalongo! Ambe Ierusalem talakolako. Makara masa kana moarunga ‘propet’ digere nge Tamoata Natu dapurani be dakalingo. ");
INSERT INTO mva_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Masa dadoki be Ungguma Takadi luma-dio danangai be dataguraki be ono damanai, daebuloi, damoangori, darautotoki be daumoatei be ngamate. ");
INSERT INTO mva_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ata amaridi tolianao masa kaba ngamarang.” ");
INSERT INTO mva_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ata tagataga ne kana ngaedi tagona-tina teke dikauataki. Pilenga ngaedi labudi nge zumkakadia-ledi dipura, be tago dikaua Iesus rakana ka irangarangaki. ");
INSERT INTO mva_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesus ilako be ambe Zeriko anua isaringaringai nge tamoata teke mata leuadi zala zagena-o isoaki be ‘mone’ isinaunau be isoaki. ");
INSERT INTO mva_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Bong tamoata be aine kokoko-tina dibagapalipaliti be ilongoridi nge bokai itegi, “Nge rakana ipurapura?” ");
INSERT INTO mva_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Be di dikatu be bokai dirai, “Nasaret tamoata ara Iesus ka maka ilakolako.” ");
INSERT INTO mva_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Makara nge tamoata ngae kaikai-la imere be bokai ipile, “Iesus, Debiti Natu! Ilom ngatagaia!” ");
INSERT INTO mva_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tamoata be aine dimuamua nge ditaguraki be diebuloni be bokai dirai, “Aoam gonoti.” Ata ngai kodeka ipi-tina be imere be bokai ipile, “Debiti Natu! Ilom ngatagaia!” ");
INSERT INTO mva_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kodeka Iesus itui be ipile be tamoata mata leuadi nge dadokamai kana. Tamoata ngae isaringa-mai nge Iesus bokai itegi, ");
INSERT INTO mva_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Rakana memakamko kana kurere?” Be tamoata ngae ikatu be bokai ipile, “Tanepoa, ngau kaba mitaita kana urere.” ");
INSERT INTO mva_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kodeka Iesus bokai irai, “Matam dauia be kaba goitaita. Lama uniangam ka iemakiko be kuia!” ");
INSERT INTO mva_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Makara nge oaikiki-tina mata diuia be kaba itaita. Be itaguraki be Nanaranga iperuperui be Iesus itagai. Tamoata be aine moarunga kaba bokai dita nge Nanaranga dirakeaki. ");
INSERT INTO mva_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesus ilako-soasoa Zeriko anua-lo be ambe anua ialalaleaki. ");
INSERT INTO mva_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tamoata teke ara Zakias makara isoaki. Ngai nge tamoata ‘tagisi’ dokidoki muamua nedi kata, be ‘mone’ be kana ne nge kokoko. ");
INSERT INTO mva_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakias irere Iesus ngate ngai bakarairai kata, ata tamoata be aine dikoko-tina be ngai nge tamoata tukuranga kata. ");
INSERT INTO mva_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bokaibe ipanana be imua be kai aradi ‘saikamo’ teke ieneki be Iesus ngate kana. Iesus nge makara bokai ngalako kana. ");
INSERT INTO mva_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Bokaibe bong Iesus kai ituitui kanana-lo ipura nge itadarake be Zakias bokai irai, “Zakias, oaikiki-tina gobala. Kaituka masa pera kanam-lo msoaki.” ");
INSERT INTO mva_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Makara nge Zakias oaikiki-tina ibala, be Iesus ibagai be pera kanana-lo dilakoru. Zakias nge suri diuia-tina. ");
INSERT INTO mva_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tamoata be aine moarunga kaba bokai dita nge ditaguraki be Iesus bokai digulungaetaki, “Tamoata ngae nge tamoata muzigoala ememaki pera kanana-lo lou ne bokana ilako!” ");
INSERT INTO mva_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ata Zakias ituirake be Tanepoa bokai irai, “Tanepoa, golongo! Kaituka be ngalakao masa kana negu moarunga egedi rua-lo mnege be egedi takadi tamoata kana nedi tagotago miandi. Be tamoata teke ubolesi be kana ne teke udokale-naba masa oati oti mkatuni.” ");
INSERT INTO mva_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Makara nge Iesus itaguraki be bokai irai, “Nanaranga ambe kaituka tamoata pera-marau ngae iuketi be imuleaki. Tamoata ngae nge Abaram tubu kata. ");
INSERT INTO mva_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Maka ma Tamoata Natu nge leuadi ka ngaleledi be ngauketidi kana ka ipura.” ");
INSERT INTO mva_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iesus nge ambe Ierusalem anua isaringai, be tamoata be aine moarunga nge ilodi dipile bong ono Nanaranga ngatanepoa kana ambe saringatuka ngapura kana. Makara nge tamoata be aine isi Iesus dilongolongoria-la bokana pile ono tonanga tekedi iradi. ");
INSERT INTO mva_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bokai ipile, “Tamoata teke tanepoa-dara kata nge ngalale masoasoa kaba tekedia-lo be datanepoai be alauri nge ngamule be makara ngatanepoa kana. ");
INSERT INTO mva_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ngalale kana nge malipilipi kana kulemoa ikiladi be ‘gol-mone’ teke-teke iandi be bokai iradi, ‘Mone’ ngaedi kamadoki be odio kamamalipilipi nibe mumule-ba.’ ");
INSERT INTO mva_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ata gadagada ne tago direretaki. Bokaibe tamoata aludi dinepidi be muri ditagai be bokai dirai, ‘Gadagada bokai dipile, “Keka tago kirere tamoata ngae anuatanepoa kanama ngapura.” ’ ");
INSERT INTO mva_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ata tamoata ngae nge ditanepoai be kaba anua nena-lo imule. Kodeka pile inanga be malipilipi kana ‘mone’ iandi nge dapura be ngakauatakidi ‘mone’ iandi nge ulikadi dipuraki ki tago. ");
INSERT INTO mva_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Malipilipi muamuatuka ipura be bokai ipile, ‘Biabiadi, ‘mone’ teke kuiana nge ono umalipi be kulemoa takadi upurakiniko.’ ");
INSERT INTO mva_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Be tamoata biabia ngae ikatu be bokai irai, ‘Malipi uia-tina ka kuemaki! Kaiko malipilipi negu iauia! Malipi mukumukudia-tina emakadi kuiamang. Bokaibe anua bibia kulemoa gopapananuaki.’ ");
INSERT INTO mva_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Malipilipi kana takaia imai be bokai ipile, ‘Biabiadi, ‘mone’ teke kuiana nge ono umalipi be lima takadi upurakiniko.’ ");
INSERT INTO mva_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Be biabiadi ne ikatu be bokai irai, ‘Kaiko anua bibia lima gopapananuaki.’ ");
INSERT INTO mva_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Kodeka malipilipi kana teke imai be bokai ipile, ‘Biabiadi, ‘mone’ nem maka! Kusi mapala tekena-lo usukumi be uzumkaki. ");
INSERT INTO mva_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Umatakuriko-ma! Bakara, kaiko panganam patu bokana. Kana tago nem, ata kudokiraperape. Kangkang tago kutanotano nge ramoramo-ba kuaroeroe.’ ");
INSERT INTO mva_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Kodeka biabiadi ne itaguraki be bokai irai, ‘Kaiko malipilipi goalakam! Masa nem pilengam-la mtagadi be ono sururu miangko. Kaiko kukaua ngau panganagu patu bokana. Kana tago negu nge udokiraperape, be kangkang tago utanotano nge uaroeroe. ");
INSERT INTO mva_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bokai nge bakara ka ‘mone’ negu tago tamoata takadi kuiandi be ono dimalipi be mulengagu-o ulika udoki?’ ");
INSERT INTO mva_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kodeka biabiadi nge itaguraki be tamoata makara saringa dituitui bokai iradi, ‘Tamoata ngae ‘mone’ kamadoka-le be tamoata ‘mone’ kulemoa takadi iemaki nge kamani.’ ");
INSERT INTO mva_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Ata tamoata ngaedi bokai dirai, ‘Biabiadi, ngai ambe ‘mone’ kulemoa dienoni!’ ");
INSERT INTO mva_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Be biabiadi ngae ikatu be bokai ipile, ‘Moimoi ka ura-kaming! Tamoata kana nedi mukudi dieno masa kokoko-la be aniadi dapura. Ata tamoata kana ne tago masa dokiadia-le dapura. Moimoi kana nena-ra mukudia-tina ka dienoni, ata masa dokiadia-le dapura. ");
INSERT INTO mva_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Be erekei negu tago direre anuatanepoa bokana be mtanepoadi kana nge kamabagadia-mai be matagu-o be kamaumoatedi!’” ");
INSERT INTO mva_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesus pile ngaedi imambuaki kodeka tamoata be aine arodi imua be Ierusalem ilako. ");
INSERT INTO mva_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ilako be Betpeiz anua be Betani anua isaringadi nge tagataga ne rua inepi-diaru be damuaru kana. Anua ruoti ngaedi nge buku ara ‘Olib’ saringa ka dienoru. ");
INSERT INTO mva_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tagataga ne ruoti dalaleru kana nge bokai ira-diaru, “Anua ene aro-mingru ieno kanana-lo kamalakoru. Kasilisiliru masa ‘dongki’ natu teke makara ditukui kamatearu. Tamoata tago teke isi ono ibuli be ialaleaki. Kamarubetakiaru be makare kamadokamairu. ");
INSERT INTO mva_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Teke itegi-kamingru, ‘Bakara ka karuberubetakiaru?’ nge kamaraiaru, ‘Tanepoa ireretaki.’” ");
INSERT INTO mva_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tagataga ruoti ngae-diaru dialaleru nge kana moarunga Iesus-la ira-diaru bokana dieno be ditaru. ");
INSERT INTO mva_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Makara be ‘dongki’ natu dirubetakiaru. Diruberubetakiaru nge kana-marau bokai ditegi-diaru, “Bakara ka karuberube-takiaru?” ");
INSERT INTO mva_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Be diaru dikaturu be bokai diradi, “Tanepoa ireretaki.” ");
INSERT INTO mva_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kodeka ‘dongki’ natu ngae dibagaiaru be Iesus-lo dilakuakiaru. Makara be kusi-sili nedi dipasi be ‘dongki’ natu-o dinanga be Iesus dibara-lako be odio isoaki. ");
INSERT INTO mva_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","‘Dongki’ natu-o isoaki be ialalale nge tamoata be aine kusi-sili nedi dipasi be zala-lo diulalaki be odio ialale. ");
INSERT INTO mva_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ilako be zala earuma buku ara ‘Olib’-lo itaolako isaringai nge tagataga ne moarunga dum biabia ditaguraki be dipipi-tina be dimeremere be Nanaranga diperuperui. Di nge Iesus malipi kaiboangdi iemaki ilodi diandi ka dimeremere be bokai dipilepile, ");
INSERT INTO mva_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Anuatanepoa nangata Tanepoa ara-nao be ipura nge Nanaranga iboadu ngamaroui! (Sam 118:26) Lang anua-lo anua-uia ngaeno be Nanaranga atabalabala-tina iboadu rakeaka bibia-tina ania ngapura!” ");
INSERT INTO mva_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kodeka Parasi alu makara tamoata be aine moarunga maradi ka Iesus bokai dirai, “‘Tisa,’ tagataga nem goebulodi be aoa-di daono!” ");
INSERT INTO mva_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Be Iesus ikatu be bokai ipile, “Ngau ka ura-kaming! Aoa-di daono masa patu dataguraki be dameremere!” ");
INSERT INTO mva_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesus ilako be Ierusalem isaringai, be bong anua kailo ite nge itangiri. ");
INSERT INTO mva_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Be bokai ipile, “Iboadu-tina kaituka nem-la be gokaua rakana ka iboadu anua-uia ngangko. Ata kaituka tago iboadu gote! Ambe matam-lo zumkaka ipura! ");
INSERT INTO mva_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bong teke masa ngapuraniko. Be bong ngaenao masa erekei nem ari matolidi bokana daboalingiko be daringiko uia be egem moarunga-lo be dapura be dasukumiko! ");
INSERT INTO mva_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Be masa dagamaniko be bababa goeno. Be tamoata be aine makara disukoaki nge dara-leuadi. Bakara, kaiko bong ono Nanaranga ipura be ngauketiko kana nge tago kukilalangi. Bokaibe patu ono emakam ipura nge masa tago teke kabana-lo ngaeno! Dagalalai-doi kana!” ");
INSERT INTO mva_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kodeka Iesus Nanaranga pera nena-lo isili be tamoata kana nedi dinangananga be zazadi dipurapura nge itaodi be dipusika. ");
INSERT INTO mva_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Be bokai iradi, “Nanaranga ‘Buku’ nena-lo bokai digere, ‘Pera negu nge ono rabonga,’ ata ‘kam ambe kaemaki be anako ono komanga nedi bokana ipura.’” ");
INSERT INTO mva_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Alauri nge ariata moarunga-lo Nanaranga pera nena-lo be tamoata be aine isulesuledi, ata tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki be Iuda tamoata nedi bibia nge daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ata labu teke date be ono daumoatei kana nge tago teke dite. Maka ma tamoata be aine moarunga pilenga dilongolongo nge didokimatematedia-tina uia. ");
INSERT INTO mva_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bong teke Iesus Nanaranga pera ne bazina-lo be tamoata be aine isulesuledi be Pile Uia mangata irangarangaki nge tamoata Nanaranga ditabatabai dimuamuadi, be tamoata Moses Mata ne disulesuletaki, be Iuda tamoata nedi bibia dipura. ");
INSERT INTO mva_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Be bokai ditegi, “Gora-kama! Kaiboang nangatadi-o ka kana ngaedi kuememaki? Naita ka kaiboang ngaedi iangko?” ");
INSERT INTO mva_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Be Iesus ikatu be bokai iradi, “Tegi negu teke mtegi-kaming kana. Kamaraia! ");
INSERT INTO mva_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ruku ono tamalinga ono Zon tamoata be aine irukudi nge kaiboang nedi inanga ka dipura? Lang anua-lo ka dipura ki tamoata ka diani?” ");
INSERT INTO mva_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bokai itegi nge nedia-la maradi bokai diegore, “Lang anua-lo kana tapile masa bokai ngategi-kita, ‘Nge bakara ka tago lama kaunani?’ ");
INSERT INTO mva_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ata bokai tapile, ‘Tamoata-lo ka dipura,’ masa tamoata be aine patu oti daung-kita. Maka ma tamoata be aine ambe ilodi ditekenanadi Zon nge ‘propet’ kata.” ");
INSERT INTO mva_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bokaibe ditaguraki be bokai dipile, “Keka tago kikaua kaiboang ne inanga ka dipura.” ");
INSERT INTO mva_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Be Iesus itaguraki be bokai iradi, “Bokai nge ngau tago uboadu mra-kaming kaiboang nangatadio ka kana ngaedi uememaki.” ");
INSERT INTO mva_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Be Iesus kababe sule ne ibatadi be pile ono tonanga takadi tamoata be aine iradi, “Tamoata teke ‘uian’ uma kana teke iemaki. Iemakia-doi, kodeka idoki be tamoata uma adoadoraki alu iandi be damalipilipitakani kana. Be ngai itui be ialale, be alalenga nge uananakadi disasalaga-tina. ");
INSERT INTO mva_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bong ‘uain’ dimalai be dokiadi dapura kana nge tamoata ngae malipilipi kana teke inepi be ‘uain’ kana alu uma malipilipitaki-lo ngabagani kana. Ata tamoata uma dimalipilipitaki ditaguraki be malipilipi ngae dipaliti be kalingona-ba dinepi be ialale. ");
INSERT INTO mva_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bokaibe uma-marau ngae kaba malipilipi kana takaia inepi be ilako. Ilako nge uma malipilipitaki dipaliti be maia muzi-lo diemaki be dinepi be kalingona-ba ialale. ");
INSERT INTO mva_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Makara nge uma-marau kaba malipilipi kana tolia inepi be ilako. Ata bong ilako nge uma malipilipitaki ditaguraki be dipaliti nibe kusi itakoro-ramo, be didoki be eluku dirokakalako. ");
INSERT INTO mva_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kodeka uma-marau itaguraki be bokai ipile, ‘Masa rakana memaki? Natugu urereretakia-tina masa mnepi be ngalale. Damuaki baraoa!’ ");
INSERT INTO mva_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ata bong natu ngae ilako be tamoata uma dimalipilipitaki dite nge nedia-la bokai diepilei, ‘Natu ngae ka tama kana ne ngadoki be nganemdi kana. Taumoatei be kana ne moarunga masa neda tadoki be tanemdi.’ ");
INSERT INTO mva_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bokaibe ditaguraki be eluku dirokakalako be diumoatei. “Ilo-ming bakara dipile? Uma-marau masa rakana ngaemaki? ");
INSERT INTO mva_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Masa ngapura be uma malipilipitaki ngaedi ngaumoatedi be ‘uain’ uma ngadoki be tamoata takadi ngandi.” Bong tamoata be aine pile ngaedi dilongo nge bokai dipile, “Moakina-tina bokai!” ");
INSERT INTO mva_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kodeka Iesus adoado-tina idededi be bokai ipile, “Pile bokainatuka digere nge labudi bakara? ‘Ariri maka pera kelikeli disegeaki ka pera kaiboang ne.’ (Sam 118:22) ");
INSERT INTO mva_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Bokaibe tamoata naita ariri ngaenao itapuloria masa mukumuku ngapura, ata ariri ngae tamoata nangatanao isapasiria masa ngatake-babai.” ");
INSERT INTO mva_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Makara nge tamoata Moses Mata ne disulesuletaki be tamoata Nanaranga ditabatabai dimuamuadi dikaua pile ono tonanga ngae nge di ka iduadi bokana. Bokaibe zala dilelei be kaituka-tina-la dauauri kana. Ata tamoata be aine dimatakuridi. ");
INSERT INTO mva_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bokaibe dimatananganangaia-tina uia. Makara be tamoata alu oazike-pali nedi bokana dinepidi be Iesus-lo dilako. Tamoata ngaedi nge diboli-ba be muzi uia-lo be dipura be ono Iesus dabolesi be ne pilenga tekedia-lo be dadoki be Rom biabiadi nedi luma-nao danangai kana. ");
INSERT INTO mva_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kodeka oazike-pali ngaedi ditaguraki be Iesus bokai ditegi, “‘Tisa,’ keka kikaua kaiko pile be sule adoadodi ka kurarangaki. Be tamoata aradi otioti ki aradi tagotago nge suridia-doi tekedi bokana kubabasakidi. Kaiko Nanaranga muzinga nge pile kalingodi ane be kurarangaki. ");
INSERT INTO mva_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gora-kama! Mata neda bibia Moses igere disumoala ki tago, iboadu Rom ‘Sisa’ nedi ‘tagisi’ taniani?” ");
INSERT INTO mva_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ata Iesus bolingadi ilodia-lo italako be bokai ipile, ");
INSERT INTO mva_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“‘Mone siliua’ teke kamaitikina! Naita anunuka be ara ka ono dieno?” Be di dikatu be bokai dipile, “‘Sisa’ anunuka be ara!” ");
INSERT INTO mva_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kodeka Iesus itaguraki be bokai iradi, “Bokai nge ‘Sisa’ kana ne nge ‘Sisa’ kamaniani, be Nanaranga kana ne nge Nanaranga kamaniani.” ");
INSERT INTO mva_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nge tamoata be aine moarunga lilidi-be-matadio be dabolesi kana nge ka tago diboadu. Bokaibe bong tegi nedi ngae ikataungia-uia ngena dimoadubulae-ba. ");
INSERT INTO mva_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadiusi dipile matemate tago iboadu kaba damarang. Bokaibe alu dipura be Iesus bokai ditegi, ");
INSERT INTO mva_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“‘Tisa,’ Moses bokainatuka igere-kama, ‘Tamoata teke toka iroti, ata isi natu tago-la be imate be roa ipereki nge tamoata ngae iboadu toka nare ngauati be toka imate nge natu ngapurakidiani.’ ");
INSERT INTO mva_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Taritokatoka lima-rua disoaki. Labalabatuka iroti be natu tagona-la teke ipura be imate. ");
INSERT INTO mva_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kodeka tari muri tagaia itaguraki be aine iuati, ata natu tago-la be imate. ");
INSERT INTO mva_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kaba alauri nge tari tolia bokai imuzi. Bokai ilakolako nibe taritokatoka lima-rua ngaedi nge bokaina-doi dimate-ba. Natu tago teke dipuraki be dimate-ba. ");
INSERT INTO mva_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Alaurituka nge aine imate. ");
INSERT INTO mva_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bokai nge bong matemate damarang kananao masa naita roa? Maka ma diato moarunga nge diuatia-doito!” ");
INSERT INTO mva_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Be Iesus ikatu be bokai ipile, “Tamoata be aine bong ngaedia-lonalona nge dirotiroti be roti kana be neneadi dipurapura. ");
INSERT INTO mva_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ata tamoata be aine maka Nanaranga irangakidi di diboadu-tina bong alalauritukao mate-lo be damarang masa tago darotiroti be tago masa roti kana be neneadi dapurapura. ");
INSERT INTO mva_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bakara, di nge ambe Nanaranga ‘enzel’ ne bokana be tago iboadu damatemate. Bokaibe ambe Nanaranga natu dipura. Maka ma di nge mate-lo be marang natu kaoa! ");
INSERT INTO mva_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Toira singaba ipurupururui ata tago ialololo be Moses ite nge ilo-ming dani. Mangata-tina ka ilo-kauakita matemate moimoi be dimarangrang. Maka ma Moses itaguraki be Tanepoa bokai irangaki, ‘Abaram Nanaranga ne, Aisak Nanaranga ne, be Zekop Nanaranga ne.’ ");
INSERT INTO mva_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kodeka bokai kamakaua: Ngai tago matemate Nanaranga nedi. Tago. Ngai moauriuri-la disukoaki Nanaranga nedi.” ");
INSERT INTO mva_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kodeka tamoata Moses Mata ne disulesuletaki alu ditaguraki be bokai dipile, “‘Tisa,’ pile ngaradi kukatu-tina uia!” ");
INSERT INTO mva_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Makara nge tago teke kaba itegi. ");
INSERT INTO mva_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kodeka Iesus itaguraki be bokai itegidi, “Baituka ka dipile Kristus nge Debiti natu? ");
INSERT INTO mva_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maka ma Debiti nena-la be ‘Buku’ ara ‘Sam’-lo bokai mangata ipile, ‘Nanaranga Tanepoa itaguraki be Tanepoa negu bokai irai: Makare kaba aradi bibiatuka oanagu-o gosoaki, ");
INSERT INTO mva_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nibe erekei nem mduaposakidi be ae salangaka nem bokana aem babadi erumadi mnangadi.’ (Sam 110:1) ");
INSERT INTO mva_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Debiti nena-la be Kristus ‘Tanepoa’ kana ikilai. Nge masa Kristus bakara be Debiti natu?” ");
INSERT INTO mva_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tamoata be aine isi dilongolongo-la be Iesus itaguraki be tagataga ne bokai iradi, ");
INSERT INTO mva_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Eke! Tamoata Moses Mata ne disulesuletaki kamamatakuakidia-tina uia! Kusi-sili salagabulidi dinangananga be malala-lo alale direrere-tina. Malala-lo dialalale nge direrere tamoata takadi damuamuakidi be biabiadi kana dakilakiladi. Pera ono serereinga-lo nge arotina-lo soaki direrere. Be moanako bibia-lo nge bagi ono moanakonga irakingadi didokidoki. ");
INSERT INTO mva_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Aine narenare pera kandi ditototo, be ono giriki nedi dazumkaki kana nge rabo salagabulidi diememaki. Tamoata bokainaina masa sururu bibia-tina dadoki.” ");
INSERT INTO mva_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesus Nanaranga pera nena-lo isoaki be igea nge tamoata ‘mone’ nedi kokoko ambe lumaluma nedi Nanaranga dianiani. Lumaluma nedi ngaedi nge dinangananga be ono Nanaranga pera ne adoraka ipurapura. ");
INSERT INTO mva_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Makara kaba itaita nge aine narenare teke kana ne tagotago ‘mone’ daradaradi rua inanganangalako be ite. ");
INSERT INTO mva_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Be bokai ipile, “Moimoi ka ura-kaming! Narenare kana ne tagotago ngae nge ‘mone’ biabia-tina ka inangai be tamoata takadi ‘mone’ nangadi iuasadi. ");
INSERT INTO mva_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tamoata be aine moarunga ngaedi nge ‘mone’ nedi kokoko ka alu didoki be lumaluma bokana dinanga. Ata aine ngae nge ‘mone’ tagotago. Moimoi kana ne nge surikakadi kaoa be odio ngasukoaki kana, ata lumaluma ne bokana inanga-doilako.” ");
INSERT INTO mva_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iesus tagataga ne alu nge Nanaranga pera ne bokai dirangarangaki: Leuakana-tina ipura be patu uarikadia-tina ane ka emaka ipura, be lumaluma kukulang-tina Nanaranga-la ania ipura ane ka ngazinga ipura. Ata Iesus itaguraki be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kana moarunga ngaedi kaita? Bong teke masa ngapura, be bong ngaranao masa patu ngaedi nge tago teke takaia atabala ngaeno. Masa gamanadi dapura be dagalalai-doi.” ");
INSERT INTO mva_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Be tagataga ne ditaguraki be bokai ditegi, “‘Tisa,’ masa aira-tina be kana ngaedi dapura? Be kilala nangata masa ngapura mua noko kana ngaedi dapura?” ");
INSERT INTO mva_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Be Iesus ikatu be bokai ipile, “Kaba kamaitaita uia! Tamoata teke ngabolesi-kaming takana! Maka ma tamoata kokoko-tina masa araguo be dapura be bokai dapile, ‘Ngau ngai,’ be alu bokai dapile, ‘Bong ambe disaringa.’ Ata moakina-tina katagadi. ");
INSERT INTO mva_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Koai be eung bibia rukudi kalongo nge moaki taburi-ming dira. Kana ngaedi masa dapura mua noko, ata kana moarunga manubungadi masa tago ngapura-mado!” ");
INSERT INTO mva_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kodeka Iesus kababe bokai iradi, “Ungguma tekedi masa dataguraki be ungguma takadi daungdi. Anuatanepoa alu masa dataguraki be anuatanepoa takadi daundi. ");
INSERT INTO mva_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Rike bibia, tole bibia, be more be kana-goala kokoko masa kaba kokoko-lo dapurapura. Kolo-kolo matakuradi otioti masa dapurapura. Be lang-lo masa kilala moagili-moagili dapurapura. ");
INSERT INTO mva_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ata kana ngaedi masa tagona-la dapura be dauauri-kaming be sururu bibia dang-kaming. Masa dadoki-kaming be pera ono serereinga-lo be giriki neming daliliti be uaura pera-lo dananga-kaming. Ngau aragu-o be masa anuatanepoa be tamoata bibia arodi datuiraki-kaming. ");
INSERT INTO mva_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bokai dibasaki-kaming nge ono ka zalaka-ming dipuraki be iboadu Pile Uia mangata kamarangakadi. ");
INSERT INTO mva_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ata matamata be ilo-ming bokai kamatekenanadi: Rakana kamarangaki be ono neming-la kamaoiaki-kaming kana nge moaki ilo-ming dibukutaki. ");
INSERT INTO mva_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Maka ma ngau masa pile be kaua malaidi miang-kaming. Bokai masa erekei neming tago diboadu pile-lo dabalaki-kaming ki dapile-ra pilenga-ming nge tago kalingodi. ");
INSERT INTO mva_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tina-ming be tama-ming, taritoka-ming, dara neming be ruanga-ming masa dadoki-kaming be erekei neming luma-dio dananga-kaming. Be alu masa umoatea-ming dapura. ");
INSERT INTO mva_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngau kanabe tamoata moarunga masa dasegeaki-kaming. ");
INSERT INTO mva_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ata donga-ming pangana-mingo masa tagona-tina teke iboadu ngaleua. ");
INSERT INTO mva_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kamakaiboang-tina uia! Bokai masa neming-la kamauketi-kaming be moauriuri kamasoaki. ");
INSERT INTO mva_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Alauri koai-bagi bibia dipura be Ierusalem anua diboalingi nge ambe kamakaua kana Ierusalem ambe saringatuka gamana ngapura kana. ");
INSERT INTO mva_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Bong ngaradi-o masa tamoata Zudea kaba-lo disoaki dairatu be buku kaba-lo dalako, be tamoata be aine Ierusalem-lo disoaki nge dairatu be dapusika. Be tamoata eluku disoaki nge moaki anua ilona-lo disili. ");
INSERT INTO mva_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bakara, bong ngaedia-lo ka sururu bibia maka Nanaranga ‘Buku’ nena-lo digere nge emakadi dapura be dakalingo kana. ");
INSERT INTO mva_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aine tinetine be aine natu-muku diarururungdi nge bong ngaedia-lo dimakadoma-tina! Sururu be moatubu bibia-tina masa kateka ngaenao dapura, be Nanaranga nama ratinga masa tamoata be aine ngaedi-o ngabala. ");
INSERT INTO mva_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Alu masa umoateadi dapura. Alu masa dauauridi be Ungguma Takadia-lo dabagadialako. Be Ierusalem anua masa Ungguma Takadi dagamagamani be daduaposaposaki nibe bong nedi ono gamanga nge damambuaki. ");
INSERT INTO mva_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Makatabala lang-lo masa kilala kokoko amari-lo, kalea-lo be goai-lo dapurapura. Be kateka-o masa ungguma moarunga ilodi dasusururu, be makasi garuruinga be dupunga masa damatakuri. ");
INSERT INTO mva_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tamoata be aine masa rakana kateka-o ngapura kana nge aburodi datungtungra be darapurapungi be taburi-rabanao be damate-mule. Maka ma kaiboang moarunga makatabala lang-lo dieno masa damoakusu-ramo be tago zalakadi datagatagadi. ");
INSERT INTO mva_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kodeka bong ngaradia-lo masa Tamoata Natu ngapurapura be date. Masa kaiboang ne bibia-tina be malama ne kaiboangdia-tina zaiza be oaru-o ngasoaki be ngapura. ");
INSERT INTO mva_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bong kana ngaedi dipurapura nge kamatuirake be pangana-ming kamadokitate, bakara bong ono Nanaranga ngazaza-kaming be ngamuleaki-kaming kana nge ambe isaringa.” ");
INSERT INTO mva_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kodeka Iesus itaguraki be pile ono tonanga ngaedi iradi, “Kai ara ‘pig’ be kai takadi ilo-ming dandi. ");
INSERT INTO mva_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bong dimoga nge ambe kamakaua kana amari bong ambe disaringa. ");
INSERT INTO mva_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kai-la ngae bokana, bong kana ngaedi dipurapura be kaita nge ambe kamakaua kana bong ono Nanaranga ngatanepoa kana nge ambe isaringa. ");
INSERT INTO mva_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Moimoi ka ura-kaming! Tamoata be aine zugu kaituka disoaki ngaedi masa tagona-la damate be kana ngaedi dapura. ");
INSERT INTO mva_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Lang be kateka masa damanubu, ata pilengagu masa tagona-tina iboadu damanubu. ");
INSERT INTO mva_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Eke! Kaba kamaitaita uia! Moaki moanako bibia kaememaki be dang kakai kasingsing be kaboangboang be kateka kana dikung-leualeua-kaming. Bokai kamamuzimuzi masa Bong biabia ngae saringatuka-ba ngapuraka-kaming, suri sausau omingo rokakalako ngapura bokana! ");
INSERT INTO mva_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Maka ma Bong biabia ngae masa tamoata be aine moarunga ege-ege kateka-o disoaki odio ngapusikalako. ");
INSERT INTO mva_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bokaibe izamaizama nge kaba kamaitaita uia be kamasukoaki! Nanaranga kamaraboraboi be masa kaiboang kamadoki be kamaboadu kana-goala ngaedi dapura kana nge kamairatudi, be masa iboadu-tina Tamoata Natu aro kamatui.” ");
INSERT INTO mva_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Izamaizama nge Iesus ilakolako Nanaranga pera nena-lo be tamoata be aine isulesuledi, be ngarairai nge buku ara Olib-lo ngalako be oabubu-lo makara ngaeno. ");
INSERT INTO mva_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Be tamoata be aine nge oabunabe dimarangrang be Nanaranga pera nena-lo dilakolako be sulenga dilongolongo. ");
INSERT INTO mva_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bong ono ‘Bereti’ Bababadi dirakerakeaki ‘Pasoba’ moanako biabia-lo nge ambe isaringa. ");
INSERT INTO mva_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki nge Iesus daumoatei kana be zala dilelelei. Ata tamoata be aine dimatakuridi. Bokaibe komangaba-lo be zala dilelelei be Iesus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kodeka Satang itaguraki be Iudas maka Iskariot kana kilaia ipurapura nge ilona-lo isili. Iudas nge Iesus tagataga ne kulemoa-be-rua kata. ");
INSERT INTO mva_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Bokaibe Iudas ialale be tamoata Nanaranga ditabatabai dimuamuadi be koai-bagi Nanaranga pera ne dinarinaringi dimuamuadi zaiza diepilei masa baituka be Iesus ngadoki be lumadi-o nganangai kana. ");
INSERT INTO mva_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tamoata ngaedi Iudas pilenga dilongo nge suridi diuia-tina, be disumoala be Iudas ‘mone’ dani kana. ");
INSERT INTO mva_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Iudas ilongo ‘mone’ dani kana nge isumoala. Kodeka makara be zala ilelelei be bong iauia nangatanao tamoata be aine moarunga tago dasoaki be Iesus ngadoki be lumadi-o nganangai kana. ");
INSERT INTO mva_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bong ono ‘Bereti’ Bababadi rakeaka ipurapura nge ambe ipura. Bong ngaenao ka ‘sipisipi’ natu moanekadi diumoatemoatedi be ono ‘Pasoba’ moanako dikangkani. ");
INSERT INTO mva_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bokaibe Iesus itaguraki be Pita be Zon inepi-diaru be bokai ira-diaru, “Kamalaleru be ‘Pasoba’ moanako kamamoataungakiaru be masa tamoanako.” ");
INSERT INTO mva_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Be diaru bokai ditegiaru, “Inanga kana gamoataungakiru kana kurere?” ");
INSERT INTO mva_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Be Iesus ikatu be bokai ira-diaru, “Ierusalem-lo kasilisiliru masa tamoata teke dang agora teke ibazibazi ngapuraka-kamingru. Kamatagaiaru be pera nangatana-lo isili nge kamasiliru ");
INSERT INTO mva_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","be pera-marau bokai kamaraiaru: ‘Tisa’ bokai ipile, ‘Pera ege ono tagataga negu zaiza ‘Pasoba’ moanako gakani kana inanga ieno?’ ");
INSERT INTO mva_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Be ngai masa pera ilo biabia atabala diadoraki be ieno nge ngaitiking-kamingru. Kamalakoru be makara kana kamamoataungakiru.” ");
INSERT INTO mva_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dialaleru nge kana moarunga Iesus-la irangaki bokana dieno be ditaru. Kodeka ditagurakiru be ‘Pasoba’ moanako dimoataungakiaru. ");
INSERT INTO mva_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bong ambe damoanako kana nge Iesus ‘apostel’ ne zaiza dilako pera ngaena-lo be bagi ono moanakonga-lo disoakiria. ");
INSERT INTO mva_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kodeka Iesus bokai iradi, “Ngau ilogu irere-tina ‘Pasoba’ ngae takania-budu noko sururu bibia mdoki. ");
INSERT INTO mva_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bakara, ngau ka ura-kaming: Tago iboadu kaba mkani nibe ngalako bong ono Nanaranga ngatanepoa kanana-lo be moanako biabia ngae labu moarunga kauataka ngapura be ono ngakalingo.” ");
INSERT INTO mva_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kodeka Iesus ‘uian’ sema teke idoki be Nanaranga iperui be bokai ipile, “Kamadoki be kamanegei be kamasing. ");
INSERT INTO mva_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bakara, ngau ka urakaming: Kaituka be ngalako nge tago iboadu ‘uain’ damaka kaba msing nibe ngalako bong ono Nanaranga ngatanepoa kana nge ngapura.” ");
INSERT INTO mva_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kodeka ‘bereti’ idoki be Nanaranga iperui be ikotoi be iandi be bokai ipile, “Ngae nge tamoata-gu. Kam kana ka negea ipura. Bokai kamamuzimuzi be ono ilo-ming danana.” ");
INSERT INTO mva_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Matamatana-la imuzi bokana, dimoanako-doi nge ‘uian’ sema teke ilona-lo ieno nge idokiteteki be bokai ipile, “‘Uain’ sema ngae nge taoa oauoau ngau darakagu ane ka Nanaranga iemaki. Darakagu ngaedi nge kam kana ka suburakadi dipura. ");
INSERT INTO mva_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ata kaba kamaita! Tamoata erekei luma-dio nganangaia kana nge makare bagi ono moanakonga-lo kisoaki-buduru. ");
INSERT INTO mva_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tamoata Natu masa Nanaranga-la toira be pile inanga bokana ngalako. Ata tamoata naita erekei luma-dio inangai nge imakadoma-tina!” ");
INSERT INTO mva_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bokai ipile nge tagataga ne nedia-la maradi dietegi masa naita bokai ngamuzi. ");
INSERT INTO mva_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Egore teke Iesus tagataga ne maradi imarang naita ka biabiatuka nedi. ");
INSERT INTO mva_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kodeka Iesus itaguraki be bokai iradi, “Ungguma Takadi anuatanepoa kandi bokai dimuzimuzi: gadagada nedi nge diduamatematedia-tina uia be dipapananuakidi. Be tamoata aradi otioti nge nedia-la be dipilepile di ka gadagada diadoadorakidi. ");
INSERT INTO mva_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ata kam moaki bokai kamuzimuzi. Moaki-tina. Tamoata biabiatuka neming ngapura kana nge sikisiki-tuka neming bokana ngapura. Be tamoata ngatanepoa kana irere nge dududu bokana ngasoaki. ");
INSERT INTO mva_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Maka ma tamoata nangata ka ara biabia? Tamoata isoakiria be ngamoanako kana, ki tamoata maka kangkang iboadi be ieluaki? Tamoata isoakiria be ngamoanako kana nge ka ara biabia! Ata ngau tago bokai. Ngau malipilipi bokana mara-ming usoaki be umalipilipi-kaming. ");
INSERT INTO mva_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kam ka bong moatubu bibia udokidoki nge sakeguo kasukoaki. ");
INSERT INTO mva_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Bokaibe Tamagu-la kaiboang iana be ono utanepoa bokana, kam masa kaiboang suri teke miang-kaming be ono kamatanepoa. ");
INSERT INTO mva_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Be anua ngau ono mtanepoa kanana-lo masa bagi negu ono moanakonga-lo kamasoaki be kamamoanako be dang kamasing, be masa bagi ono tanepoanga-o kamasoaki be Israel bagi nedi kulemoa-be-rua kamapapananuaki.” ");
INSERT INTO mva_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kodeka Iesus Pita bokai irai, “Saimon! Saimon! Golongo! Satang ambe itegi be toia-ming ngapura kana, suri niu kozomadi dipurapura bokana. Kozomadi dapura be kalingodi dokiadi dapura be zipidi rokakadi dapura. ");
INSERT INTO mva_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ata ngau ambe kaiko kanabe Nanaranga uraboi. Bokai masa lama uniangam tago daleua. Be alauri kaba ngau-lo kumule masa taritokam goaka-kaidi.” ");
INSERT INTO mva_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ata Saimon ikatu be bokai ipile, “Tanepoa, ngau ambe ukatiuana ka usoaki, be uboadu-tina kaiko kitaru be uaura-lo talakoru be tamate-buduru.” ");
INSERT INTO mva_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Be Iesus ikatu be bokai irai, “Pita! Ngau ka uraiko. Kaituka masa mang tagona-la ngakatararaua be masa bong toli goaoli be gopile tago kukauataka.” ");
INSERT INTO mva_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kodeka Iesus itaguraki be tagataga ne itegidi, “Bong kalingo-mingba unepi-kaming be kalale nge kana tekena-lo katukura ki tago? Bong maka ura-kaming be goate ono ‘mone’ nangalakonga, raba be ae-sukuma tago teke kadokidoki be kalale-ma!” Be di dikatu be bokai dipile, “Tago-tina! Kana tago tekena-lo kitukura!” ");
INSERT INTO mva_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Be Iesus bokai iradi, “Ata kaituka nge tago bokai. Tamoata nangata goate ono ‘mone’ nangalakonga nem ieno nge godoki. Raba kanam ieno nge godoki. Asi ono eunga nem tago nge kusi-sili nem ono ‘mone’ godoki be teke gozazai. ");
INSERT INTO mva_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bakara, Nanaranga ‘Buku’ nena-lo bokai digere, ‘Tamoata panganadi patu bokana zaiza diuaredia-budu.’ (Ais 53:12) Be nge ngau ka ura-kaming. Pile ngaedi nge ngau oguo ka emakadi dapura be dakalingo kana. E, moimoina-tina. Pile ono ngau rangakagu ipura be digere nge ambe saringatuka emekadi dapura be dakalingo kana.” ");
INSERT INTO mva_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Be tagataga ne bokai dipile, “Tanepoa, kaba goita! Asi ono eunga rua maka dieno!” Be Iesus ikatu be bokai ipile, “Ngara diboadu-tina!” ");
INSERT INTO mva_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesus itaguraki be ne imuzimuzi bokana be ilako buku ara Olib-lo, be tagataga ne ditagai. ");
INSERT INTO mva_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kaba ngaradia-lo dipura nge Iesus tagataga ne bokai iradi, “Kamaraborabo be masa tago iboadu toitoi teke ngadoki-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bokai ipile kodeka muku kasauba ilako, masauakadi tamoata patu teke ngadoki be ngarokaki be ngabala bokana, be tuku-nao irokazokuria be bokai irabo, ");
INSERT INTO mva_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamagu, kurere nge sema ono sururu dokinga ngae godokalea. Ata moaki rerengagu kutagadi, kaiko-la ka rerengam tagadi dapura.” ");
INSERT INTO mva_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Makara nge Nanaranga ‘enzel’ ne teke lang anua-lo ipura be Iesus iaka-kai. ");
INSERT INTO mva_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iesus nge ambe kilalanga inanga ilo isururu-tina. Bokaibe ilo-buku ane be rabo ne iaka-kaidi. Be suburauanga nge dara bokana kateka-o ditikiria. ");
INSERT INTO mva_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Irabo-doi be ituirake be tagataga nena-lo imule nge dienosoa-tina be itedi. Ilodi nge dinodo-tina ka aburodi dipoaki be dieno. ");
INSERT INTO mva_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bokaibe Iesus itaguraki be bokai itegidi, “Bakara ka kaenosoa? Kama-marang be kamaraborabo masa toitoi tago teke ngadoki-kaming!” ");
INSERT INTO mva_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesus isi ipilepile-la be tamoata dum teke ipura, be tamoata ara Iudas nge imuadi be dipura. Iudas nge Iesus tagataga ne kulemoa-be-rua kata. Bokaibe imai be Iesus taona itao be ngaroki kana, ");
INSERT INTO mva_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ata Iesus itaguraki be bokai itegi, “Iudas, ambe aroki ane be Tamoata Natu erekei luma-dio gonangai kana ki?” ");
INSERT INTO mva_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bong Iesus tagataga ne kaba bokai dita rakana ngapura kana nge bokai ditegi, “Tanepoa, asi ono eunga nema ane gaeung ki moaki?” ");
INSERT INTO mva_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Makara nge tagataga ne teke itaguraki be asi ono eunga ne ipasiki be tamoata Nanaranga ditabatabai biabiatuka nedi malipilipi kana kungi oana izantotoki be itakoro. ");
INSERT INTO mva_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ata Iesus itaguraki be bokai ipile, “Iboadu! Moaki kaba bokai kamuzi!” Kodeka Iesus ilako be tamoata ngae kungi idoki be kabana-lo inangalako be iadoraki. ");
INSERT INTO mva_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Makara be Iesus itaguraki be tamoata Nanaranga ditabatabai dimuamuadi, be tamoata Nanaranga pera ne dinarinaringi, be Iuda tamoata nedi bibia dipura be dauauri kana nge bokai iradi, “Ngau koai kata uememaki ka meng be asi ono eunga kadoki be kapura ki? ");
INSERT INTO mva_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Izamaizama nge sakemingo Nanaranga pera ne aridia-lo tasukoaki-budu, ata luma-ming tago sesu oguo kanangaria! Ata nge bong neming. Bong ngaedi-o ka malama tagonga kaba idoki be itanepoa.” ");
INSERT INTO mva_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kodeka ditaguraki be Iesus didokimatei be diuauri be tamoata Nanaranga ditabatabai biabiatuka nedi pera kanana-lo dilakuaki. Pita nge lauaba-nao be itagatagadi. ");
INSERT INTO mva_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eoa bibia tekedi nge pera ngae aro ditau be tamoata alu nge diboaling be disoaki. Be Pita ilako be disoaki-budu. ");
INSERT INTO mva_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Makara nge malipilipi aine teke Pita eoa malamakadia-lo isoaki be ite nge ililitia-uia be bokai ipile, “Tamoata ngae nge dialalale-buduru.” ");
INSERT INTO mva_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ata Pita iaoli be bokai ipile, “Aine kaiko, ngau tamoata ngara tago ukauataki.” ");
INSERT INTO mva_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mukuna-la disoaki nge tamoata teke Pita ite be bokai ipile, “Kaiko di kata.” Be Pita ikatu be bokai ipile, “Tamoata, ngau tago di kata.” ");
INSERT INTO mva_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Amari siriki ne teke bokana ilako muri nge tamoata teke ikai-tina be bokai ipile, “Kaiko-ma! Moimoina-tina tamoata ngae nge Iesus diaru disukoaki-buduru. Ngai Galili tamoata kata.” ");
INSERT INTO mva_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Be Pita itaguraki be bokai ipile, “Tamoata, ngau tago ukaua rakana kata ka kurangarangaki!” Makara nge oaikiki-tina Pita isi ipilepile-la be mang ikatararaua. ");
INSERT INTO mva_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Mang ikatararaua nge Tanepoa ibuiri be Pita adoado-tina idedei. Adoado-tina idedei nge Pita Tanepoa pilenga ngaedi ilo iandi, “Mang tagona-la ngakatararaua be masa bong toli goaoli be gopile tago kukauataka.” ");
INSERT INTO mva_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bokaibe Pita eluku ilako be tang biabia-tina iemaki. ");
INSERT INTO mva_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kodeka tamoata maka Iesus dinarinaringi nge ditaguraki be Iesus ono disamanaganaga be dirautototoki. ");
INSERT INTO mva_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ono disamanaganaga nge ditaguraki be kusi mapala teke didoki be mata ono disuku be bokai dirarai, “Pile mumuakadi gopile! Naita ka iungko?” ");
INSERT INTO mva_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Be ditaguraki be ebulo pile kokoko takadi ane diebuloi. ");
INSERT INTO mva_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Anua izama nge Iuda tamoata nedi bibia moarunga ‘Kansolo’ nedi-o disoaki nge dikabuni be disoaki. Tamoata bibia ngaedi nge Iuda tamoata nedi bibia, tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki. Kodeka Iesus dieluaki be arodi dituiraki. ");
INSERT INTO mva_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Be tamoata bibia ngaedi bokai dipile, “Gora-kama! Kaiko ka Kristus ki?” Be Iesus ikatu be bokai iradi, “Mra-kaming masa lama tago kamaunana. ");
INSERT INTO mva_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Be mtegi-kaming kana nge masa ma tago kaboadu kamakatuna! ");
INSERT INTO mva_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ata kaituka be ngalako masa Tamoata Natu Nanaranga Kaiboangina-tina luma oana-nao ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Be kaba bokai ditegi, “Bokai nge kaiko Nanaranga Natu ki?” Be Iesus ikatu be bokai ipile, “Bokai kapile nge moimoi ka kapile.” ");
INSERT INTO mva_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kodeka bokai dipile, “Tago iboadu kababe tamoata takadi tatedi be pile ono daunglako. Ne aoa-nalo be pilenga ambe talongo-doi.” ");
INSERT INTO mva_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kodeka tamoata bibia moarunga ngaedi nge dituirake be Iesus diaromuani be Pailot-lo dilakuaki. ");
INSERT INTO mva_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pailot-lo dilakuaki kodeka pile moagili-moagili ono diununglako, be bokai dipile, “Tamoata ngae kite Iuda tamoata be aine nema irerepekidi be zala takadia-lo ilakulakuakidi. Be iraradi Rom ‘Sisa’ nedi moaki ‘tagisi’ dianiani. Ngai nena-la irangaki ngai ka Kristus, be ngai nge anuatanepoa kata.” ");
INSERT INTO mva_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bokaibe Pailot itaguraki be Iesus bokai itegi, “Kaiko Iuda anuatanepoa kandi ki?” Be Iesus ikatu be bokai ipile, “E, kupile-la bokana.” ");
INSERT INTO mva_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kodeka Pailot itaguraki be tamoata Nanaranga ditabatabai dimuamuadi be tamoata be aine moarunga bokai iradi, “Ngau giriki labu tago teke tamoata ngaenao utealako.” ");
INSERT INTO mva_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ata di dikai-tina be dikatu be bokai dipile, “Sulenga ane be tamoata be aine ilodi iunung ege-ege Zudea kaba-lo. Matamata Galili kaba-lo imarangaki. Be nge ambe makare ipuraki.” ");
INSERT INTO mva_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot bokai ilongo nge itegidi, “Tamoata ngae Galili tamoata kata ki?” ");
INSERT INTO mva_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Be bong Pailot bokai ilongo Iesus Galili tamoata kata nge Erot-lo inepalako. Bong ngaradia-lo nge Erot ka Galili kaba ipapananuaki. Be Erot kailo nge ambe ipura be Ierusalem-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erot nge Iesus ruku ilongolongo be irere-tina ngate. Bokaibe bong Iesus dieluaki nge suri diuia-tina. Irere Iesus kilala kaiboangdi teke ngaememaki be ngate. ");
INSERT INTO mva_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Be itaguraki be tegi kokoko-tina ane be Iesus itegitegi, ata Iesus tago sesu tegi ne ikatu. ");
INSERT INTO mva_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Makara be tamoata Nanaranga ditabatabai dimuamuadi be tamoata Moses Mata ne disulesuletaki makara disoaki nge saringa dimai be pile kaiboangdi Iesus ono dinangalako. ");
INSERT INTO mva_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kodeka Erot koai-bagi tamoata ne zaiza ditaguraki be Iesus dingengeri be ono disamanaga. Ono disamanaga-doi, kodeka kusi-sili kanabiabia uarika teke disiliakani be kaba Pailot-lo dinepalako. ");
INSERT INTO mva_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Bokaibe amarina-la ngarana-lo be Pailot be Erot dieruangamiru. Matamata nge diaru erekai kaoa. ");
INSERT INTO mva_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kodeka Pailot itaguraki be tamoata Nanaranga ditabatabai dimuamuadi, be Iuda tamoata nedi bibia be tamoata be aine moarunga ikiladi ");
INSERT INTO mva_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","be bokai iradi, “Tamoata ngae kaeluakana be kapile-ra tamoata be aine tinedi iunung be eung biabia teke damarangaki kana. Bokaibe ubagai be makare mata-mingo be giriki ne uliliti-uia. Ata pile ono kaunglako nge labu tago teke ute. ");
INSERT INTO mva_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Be ngau-la bokana Erot giriki tago teke ono itealako. Bokai ka kaba kita-lo inepiamai. Kaba kamaita! Giriki tago teke iemaki be iboadu ono umoatea ngapura. ");
INSERT INTO mva_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nge bokai ka rautotoka ngapura be mlikitaki be ngalale kana.”  ");
INSERT INTO mva_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","‘Pasoba’ bong moarunga-lo nge Pailot bokai imuzimuzi: tamoata uaura-lo disoaki nge maradi teke ngapasiki be ngarubetaki be tamoata be aine ngandi. ");
INSERT INTO mva_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ata tamoata be aine moarunga makara disoaki nge kaikai-la dimere be bokai dipile, “Umoatea ngapura! Barabas gorubetaki be goang-kama!” ");
INSERT INTO mva_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas nge eung biabia teke ungguma Rom imarangakadi Ierusalem-lo, be giriki ne takadi nge tamoata takadi iumoatedi. Nge bokai ka uaura-lo isoaki.) ");
INSERT INTO mva_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailot irere Iesus ngalikitaki be ngalale. Bokaibe tamoata be aine makara disoaki nge kababe iakorodi. ");
INSERT INTO mva_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ata di dimere be bokai dipile, “Kai kapalapala uauau-o rokatagaka ngapura! Kai kapalapala uauau-o rokatagaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kodeka Pailot bong tolia bokai iradi, “Bakara ka? Tamoata ngae giriki nangata iemaki? Ngau giriki tago teke uteani be iboadu ono umoatea ngapura! Bokaibe ngau masa mpile be rautotoka ngapura be mlikitaki be ngalale.” ");
INSERT INTO mva_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ata di dipipi-tina be dimeremere be dipilepile Iesus kai kapalapala uauau-o rokatagaka ngapura. Dimeremere nibe merengadiaba-lo be diuasa. ");
INSERT INTO mva_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bokaibe Pailot itaguraki be rerengadi itagadi be kana direretaki nge isumoalataki. ");
INSERT INTO mva_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Be tamoata maka eung biabia teke ungguma Rom imarangakadi be tamoata iumoatedi nge uaura pera-lo ka irubetaki be ialale. Tamoata be aine direre ka tamoata ngae rubetaka ipura. Kodeka Pailot itaguraki be Iesus idoki be luma-dio isalangaki be rerengadia-lo ba dabasaki kana nge dabasaki. ");
INSERT INTO mva_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Makara be dibagai be dialale. Diaromuani be Ierusalem dipereki be dipusikasika nge Sairini tamoata teke ara Saimon dipurakani be didokirepeki be kai kapalapala uauau ono dinangaria be ibazi be Iesus muri itagai. Saimon nge anua sisiki-lo ka Ierusalem ilakolako. ");
INSERT INTO mva_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tamoata be aine dum kana-tina-biabia teke nge Iesus itagai. Be aine alu nge dialale-budu. Aine ngaedi nge ditangtang be ilodi nge ditakoro-tina. ");
INSERT INTO mva_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Makara nge Iesus ibagabuiri be bokai iradi, “Ierusalem aine, moaki ngau katangira. Kam neming be natu-ming kanabe kamatang! ");
INSERT INTO mva_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Bakara, bong teke masa ngapura, be bong ngaranao masa bokai kamapile, ‘Aine kupidi, be aine tago dinekineki, be aine natu-muku tago sesu diarurungdi nge suridi dauia!’ ");
INSERT INTO mva_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bong ngaradi-o ka tamoata masa buku bibia sasalaga bokai daradi, ‘Omaio kamatapuloria!’ be buku mukumukudi bokai daradi, ‘Kamakubati-kama!’ ");
INSERT INTO mva_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bakara, bong kai isi karairai be tamoata bokai dimuzimuzi, ak ngamarango masa rakana ngapura?” ");
INSERT INTO mva_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tamoata anakonako rua nge Iesus zaiza be diaromuandi be daumoatedi kana. ");
INSERT INTO mva_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kaba aradi Tamoata Pangana Paki-nalo dipura nge kai kapalapala uauau-o dirokatagaki tamoata anakonako ruoti zaiza. Takaia ege oana-nao dirokatagaki be takaia ege ngasi-nao dirokatagaki. ");
INSERT INTO mva_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kodeka Iesus itaguraki be bokai ipile, “Mamo, kana ngae diemaki nge gorokakaledi! Tago dikaua rakana ka diememaki!” Alauri nge guzui teke diemaki be ono kusi ne inangananga nge diuasadi be didoki. ");
INSERT INTO mva_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tamoata be aine Iesus ditagai nge ditui be diteate, be Iuda tamoata nedi bibia nge dingengeri be bokai dipile, “Tamoata be aine takadi nge iuketidi. Bokaibe kamalikitakini ngai moimoi be Kristus, Nanaranga ka inangai nge nena-la be ngauketi!” ");
INSERT INTO mva_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Be koai-bagi tamoata nge dimai be ono disamanaga be. Kodeka ditaguraki be ‘uain’ mangini diani ");
INSERT INTO mva_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","be bokai dipile, “Kaiko moimoi be Iuda anuatanepoa kandi nge nem-la gouketiko!” ");
INSERT INTO mva_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iesus atabala nge kai mapala tekenao bokai digere: Ngae Ka Iuda Anuatanepoa Kandi. ");
INSERT INTO mva_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Anakonako rua Iesus zaiza dirokatagaki-diaru nge takaia bokai ipile, “Kaiko ka Kristus ki? Nem-la gouketiko be keru gouketi-kamairu!” ");
INSERT INTO mva_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ata anakonako takaia itaguraki be ruanga bokai iebuloni, “Nanaranga kumatakuri ki tago? Kitato nge mate-doi aoa-nalo ka tasoakito. ");
INSERT INTO mva_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ata sururu kitaru tadokiru nge diado. Kitaru giriki taemakiru ka sururu tadokiru. Bokaibe sururu nedaru ngaedi nge muzingadaru ka itagadi be tadokiru. Ata tamoata ngae giriki tago teke iemaki.” ");
INSERT INTO mva_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kodeka anakonako ngae bokai ipile, “Iesus, bong anua nem gotanepoa kanana-lo kulako nge ilom ngana.” ");
INSERT INTO mva_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Be Iesus ikatu be bokai irai, “Moimoi ka uraiko! Kaituka masa lang anua-lo gosoaki ngau kitaru!” ");
INSERT INTO mva_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Amari-soasoatina nge oabubu kateka isukumi nibe ilako rairai amari siriki tolianao bokana. ");
INSERT INTO mva_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Amari nge ileua be tago imalamalama. Makara nge kusi biabia Nanaranga pera ne ilona-lo itobitobi nge imasare be ege rua ipura. ");
INSERT INTO mva_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kodeka Iesus kaikai-la bokai imere, “Mamo! Mariabakagu lumam-o usalangaki!” Bokai ipile be imate. ");
INSERT INTO mva_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rom tamoata koai-bagi nedi imuamuadi makara ituitui be kaba bokai ita nge Nanaranga irakeaki be bokai ipile, “Moimoina-tina tamoata ngae nge adoadona-tina!” ");
INSERT INTO mva_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tamoata be aine moarunga makara dipura be kana ngaedi daita kana kaba bokai dita nge ilodi dinodo-tina be panganadi ditaongaki be dialale. ");
INSERT INTO mva_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ata tamoata be aine Iesus dikauataki nge kasauba ditui be kaba ditaita. Be aine maka Galili kaba-lo be ditagatagai nge makara maradi dituitui-budu. ");
INSERT INTO mva_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tamoata teke isoaki ara Iosep. Ngai nge tamoata iauia be adoadona-tina. ");
INSERT INTO mva_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Anua ne ara Arimatea, ege Zudea kaba-lo. Tamoata ngae nge bong ono Nanaranga ngatanepoa kana puraia nge irarapung. Moimoi ngai Iuda ‘Kansolo’ nedi-o isoaki, ata kana maka ‘Kansolo’ dirangaki be diemaki nge tago isumoalataki. ");
INSERT INTO mva_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Bokaibe ilako Pailot-lo be Iesus mate nge ikeliaki. ");
INSERT INTO mva_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kodeka iori be kusi manipidi zazadi atabalabala-tina tekena-lo isukumi be poda tekena-lo inangalako. Poda ngae nge patu kanabiabia teke ilona-lo ka diemaki, be tamoata matedi isi tago teke makara dinangalako. ");
INSERT INTO mva_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Amari ngarana-lo ka kangkang dimoatautaungaki, be nge ambe irairai be bong ono manauanga ‘Sabat’ nge ambe ngamarang kana. ");
INSERT INTO mva_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aine maka Galili kaba-lo be Iesus ditagai nge Iosep ditagai be poda dite, be baituka Iesus mate dinangai nge ditea-uia. ");
INSERT INTO mva_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kodeka pera kandia-lo dimule be ngesi be bureng boaudi kaiboangdi ono matedi diburengrengdi nge dimoataungaki be dieno. Ata bong ono manauanga ‘Sabat’ imai bokana Moses Mata ne ditagadi be dimanaua. ");
INSERT INTO mva_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Bong ono manauanga ‘Sabat’ imanubu be izama nge oabuna-tina be aine Iesus ditagatagai nge ngesi boaudi kaiboangdi ono tamoata matedi diburengrengdi dimoataungaki be dieno nge didoki be Iesus podana-lo dilako. ");
INSERT INTO mva_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Poda-lo dilakopura nge patu kanabiabia ono poda aoa onota ipura nge ambe gegeaka ipura be poda sasanganga ieno. ");
INSERT INTO mva_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ata bong aine ngaedi poda ilona-lo disili nge Tanepoa Iesus mate tago ieno be dite. ");
INSERT INTO mva_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aine ngaedi isi ilodi dilelelenaki-la be oaikiki-tina tamoata rua dipuraru be maradi dituitui. Kusi dinanganangaru nge malamakadi lamalama pitikaoanga bokana. ");
INSERT INTO mva_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Makara nge aine ngaedi taburidi dira-tina ngena diboadukuria be lilidi kateka-lo dilakuaki, ata tamoata ruoti nge bokai dipileru, “Bakara ka moauriuri sukoaki matedi maradi kalelelei? ");
INSERT INTO mva_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tago makare isoaki! Ambe imarang! Ilo-ming kauakaua ki tago bong isi Galili-lo kasukoaki-budu nge ba ira-kaming? Bokai ipile, ");
INSERT INTO mva_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tamoata Natu masa dokia ngapura be muzigoala ememaki luma-dio danangai be kai kapalapala uauau-o darokatagaki, be amaridi toli muridi masa mate-lo be ngamarang!’” ");
INSERT INTO mva_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kodeka makara be aine ngaedi Iesus pilenga ilodi diandi. ");
INSERT INTO mva_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bong aine ngaedi poda-lo be dimule nge kana moarunga ngaedi Iesus tagataga ne kulemoa-be-teke dirangakidi tamoata be aine takadi zaiza. ");
INSERT INTO mva_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aine ngaedi ka ‘apostel’ diradi: Maria Magdala aine, Zuana, Maria Zems tina, be aine takadi dialale-budu. ");
INSERT INTO mva_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ata Iesus tagataga ne nge aine ngaedi lama tago diunadi, bakara aine ngaedi pilengadi dilongo nge suri ngao pile bokana. ");
INSERT INTO mva_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ata Pita itaguraki be ipapanana-la be Iesus poda-nalo ilako. Makara ipura be poda-lo itudulako nge kusi manipidi ono Iesus sukuma ipura nge nedia-ba dieno be ita. Makara nge nena-ba ilo ilelenaki be ipile nge masa rakana ipura. Ilo nge ilelelenakia-la be pera-lo imule. ");
INSERT INTO mva_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Amarina-la ngaranao nge tagataga rua anua ara Emeas-lo dilakolakoru. Ierusalem anua-lo be Emeas golako kana nge masauakadi sasalaga-tina, kaleti dipile ‘11 kilomita.’ ");
INSERT INTO mva_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tamoata ruoti ngae-diaru zala-lo dialalaleru nge kana moarunga dipura nge dirarangakiru be dialalaleru. ");
INSERT INTO mva_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kana ngaedi diegoregoretakiru be pile dilakulakuakiru be dimulemuleakiru nge Iesus nena-la be isaringa-diaru be dialalale-buduto. ");
INSERT INTO mva_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tamoata ngae-diaru nge Iesus ditearu, ata tago iboadu dakilalangiaru. ");
INSERT INTO mva_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kodeka Iesus itaguraki be bokai itegi-diaru, “Kalalaleru nge rakana kata ka kaegoregoretakiaru be kalalaleru?” Bokai itegi-diaru nge dituiru be lili-diaru nge dinodo-tina. ");
INSERT INTO mva_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kodeka takaia ara Keleopas itaguraki be bokai itegi, “Ierusalem anua-lo masa kaiko-la rubem ka kana bong ngaedia-lo dipura tago kukauataki?” ");
INSERT INTO mva_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Be Iesus itegi, “Rakana kaoa?” Be diaru dikaturu be bokai dipile-ru, “Kana-ma maka Nasaret tamoata ara Iesus dipurania-re! Moimoi ngai ‘propet’ kata. Maka ma Nanaranga be tamoata be aine moarunga matadi-o nge ngai malipi kaiboangdia-tina iememaki be pile malamakadi otioti ipilepile. ");
INSERT INTO mva_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata bibia nema didoki be Rom luma-dio dinangai be disumoalataki be didoki be kai kapalapala uauau-o dirokatagaki. ");
INSERT INTO mva_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Keka moimoi be kilalangama kinanga ngai ka Israel ngazazai be ngarubetaki kana. E, moimoina-tina kana ngaedi dipura, ata kana kanabiabia nge amaridi ambe toli dilako be kana ngaedi dipura! ");
INSERT INTO mva_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kaba kana takaia nge bokai: Aine nema alu kisukoaki-budu nge diaka-pitilakikamai-tina. Kaituka oabuana-tina be Iesus poda-nalo dilako, ");
INSERT INTO mva_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ata tamoata mate tago dite. Be dimule be dira-kama raio bokana ‘enzel’ diradia-ra Iesus ambe moauriuri isoaki. ");
INSERT INTO mva_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ruangama alu dilako poda-lo nge aine-la dipile bokana kana dieno be dita, ata Iesus tago sesu dite.” ");
INSERT INTO mva_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kodeka Iesus bokai ira-diaru, “Kangao-tinaru ki bakara? Baituka ka tago oaikiki-la be ‘propet’ pilengadi moarunga lama kaungdi? ");
INSERT INTO mva_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tago kakauaru Kristus masa sururu ngaedi ngadoki be ono kaiboang be malama ne ania ngapura?” ");
INSERT INTO mva_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kodeka Iesus itaguraki be ne rangaka moarunga Nanaranga ‘Buku’ nena-lo dieno nge labudi inagupasi-diaru. Moses Mata ne be ‘Propet’ gerengadia-lo be pile labudi inanga nibe Nanaranga ‘Buku’ ne imambuaki. ");
INSERT INTO mva_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Dilakoto be anua ono dilakolakoru disaringaiato nge Iesus suri isi ngalako-la be ngaeno bokana imuzi. ");
INSERT INTO mva_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ata tamoata ngae-diaru dikairu be dimuleakiaru be bokai diraiaru, “Amari ambe saringatuka ngalako be ambe ngarodo kana. Makare tasoakito.” Bokaibe itaga-diaru be disoaki-buduto. ");
INSERT INTO mva_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Anua-lo dilakoto be ambe disoakiriato be damoanakoto kana nge Iesus ‘bereti’ idoki be iperutaki be ikotoi be ambe ianian-diaru. ");
INSERT INTO mva_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Makara nge mata-diaru dipoara be dikilalangiaru, ata ngai matadiarua-lo ka ileuaba. ");
INSERT INTO mva_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kodeka tamoata ruoti ngae-diaru nge nedia-lanaru bokai dietegiru, “Bong zala-lo taepipileito be Nanaranga ‘Buku’ ne labudi inagupasipasi-kitaru nge ilo-daru dimarang-tina be eoa bokana dikarakara ki tago?” ");
INSERT INTO mva_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Makara nge oaikiki-tina dituiru be kaba Ierusalem-lo dimuleru. Kodeka dilakoru be Iesus tagataga ne kulemoa-be-teke tamoata be aine takadi Iesus ditagatagai zaiza disoaki be ditedi. ");
INSERT INTO mva_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Be bokai dipileru, “Moimoina-tina! Tanepoa ambe imarang be Saimon ipurakani!” ");
INSERT INTO mva_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kodeka ditagurakiru be kana moarunga zala-lo dipura-diaru nge dirangakiru. Be bakara be bong ‘bereti’ ikotoi be dikilalangiaru nge dirangakiru. ");
INSERT INTO mva_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kana ngaedi isi dirarangaki-laru be Iesus nena-la be ipura be maradi itui be bokai iradi, “Ilo-uia kam-lo ngaeno!” ");
INSERT INTO mva_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Makara nge pitilaki tagona-tina diuia be taburidi nge dira-tina. Ilodi dipile tamoata mate mariabaka kata ka dite. ");
INSERT INTO mva_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kodeka Iesus bokai iradi, “Bakara ka ilo-ming dibuku! Bakara ka ilo-ming-lo ilo-rua dimarang? ");
INSERT INTO mva_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Lumagu babadi be aegu babadi kamaita! Ngena ngau! Oguo kamadauraki be kamatea! Mariaba kusidi be tapoudi tagotago! Kamatea! Ngau kusigu be tapougu otioti!” ");
INSERT INTO mva_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bokai ipile, kodeka luma be ae itikingdi. ");
INSERT INTO mva_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ata di isi pitilaki tagona-tina diuia be suridi nge diuia-tina be isi ilodi lelenakadi dira nge Iesus ka ipurakadi. Bokaibe itegidi, “Kangkang teke ieno-kaming ki tago?” ");
INSERT INTO mva_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kodeka ika moamoamoa teke diani, ");
INSERT INTO mva_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","be idoki be matadi-o be ikani. ");
INSERT INTO mva_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Makara be bokai iradi, “Bong isi sake-mingo usoaki be bokai ura-kaming: Rangakagu moarunga Moses Mata nena-lo dieno, ‘Propet’ gerengadia-lo dieno be ‘Sam’ moarunga-lo dieno nge emakadi dapura be dakalingo kana.” ");
INSERT INTO mva_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kodeka ilodi iuasari be iboadu gere moarunga Nanaranga ‘Buku’ nena-lo dieno nge labudi dakauataki. ");
INSERT INTO mva_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Be bokai iradi, “Nanaranga ‘Buku’ nena-lo bokai digere: Kristus masa sururu bibia ngadoki be amari tolianao be kaba mate-lo be ngamarang. ");
INSERT INTO mva_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Be aranao be masa ungguma moarunga-lo pile ono ilodi dabuiri be muzigoala nedi dasegeaki be ono Nanaranga muzigoala nedi ngarokakile-di nge mangata rangakadi dapura. Malipi ngaedi masa Ierusalem anua-lo be marangakadi dapura. ");
INSERT INTO mva_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kam ka kana ngaedi mata-ita nedi be mangata kamarangaki kana. ");
INSERT INTO mva_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngau masa kana maka Tamagu moimoi be irangaka-kaming nge mnepi be ngapura. Ata makarena-la Ierusalem anua-lo kamasoaki nibe kaiboang etatabalabala omingo ngabala be ngasukum-kaming.” ");
INSERT INTO mva_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kodeka ibagadi be dilako Betani anua saringa be luma etatabala-lo idokitatelako be imaroudi. ");
INSERT INTO mva_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Isi imarouroudia-la be iperekidi, be lang anua-lo ikautaki. ");
INSERT INTO mva_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kodeka tagataga ne ditaguraki be Iesus ara dirakeaki be Ierusalem-lo dimule. Suridi nge diuia-tina be dimule. ");
INSERT INTO mva_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Be bong nedi moarunga nge Nanaranga pera nena-lo disukoaki be Nanaranga dirakerakeaki. ");
INSERT INTO mva_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Matamatana-tina kateka be lang isi tago emakadi dipura be Pile isoaki. Pile ngae ka Nanaranga, be Nanaranga diaru disoaki-buduru. ");
INSERT INTO mva_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Matamatana-la be Pile ngae Nanaranga diaru disoakiru, ata diaru teke-diaru. ");
INSERT INTO mva_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ngaia-lo ka kana moarunga emakadi dipura. Be ngai isoaki be kana moarunga emakadi dipura. Kana moarunga taitaita nge tago teke ngai tago isoaki be emaka ipura. Isoaki-doi. ");
INSERT INTO mva_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ono moauringa labu nge Pile ngaena-lo ka ieno. Be tamoata be aine moarunga kateka-o nge muzigoala be moatubu erumadi disoaki be ngai ka gapu irokaki be malama iandi. ");
INSERT INTO mva_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Malama ngae ka oabubukadia-lo imalamalama. Ata oabubu tago malama ngae iumoatei be ibalaki. ");
INSERT INTO mva_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Makara be tamoata teke ipura. Nanaranga ka inepi be ipura. Tamoata ngae ara Zon. ");
INSERT INTO mva_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Zon nge mata-ita bokana be malama ngae mangata ngarangaki kana ka ipura. Bokaibe Zon malipingana-lo be masa tamoata be aine moarunga malama ngae dalongoraki be lama daunani. ");
INSERT INTO mva_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Zon nena-la nge tago malama ngae. Ngai nge malama ngae mata-ita ne bokana be mangata ngarangaki kana ka ipura. ");
INSERT INTO mva_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Malama ngae ka moimoi be kalingo be ambe kateka-o ipurapura. Ngai ka tamoata be aine moarunga kateka-o malama ianiandi. ");
INSERT INTO mva_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pile ngae makare kateka-o isoaki. Moimoi ngai luma inanga be kateka ngae emaka ipura, ata tamoata be aine moarunga kateka ngaenao tago dikilalangi. ");
INSERT INTO mva_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ungguma-tina be dara-tina nena-lo ilako, ata tago dimolataki be didoki. ");
INSERT INTO mva_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ata tamoata be aine ranguma Pile ngae didoki be lama diunani nge sumoala iandi be iboadu dapi be Nanaranga natu dapura. ");
INSERT INTO mva_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tago tina-di be tama-di darakadia-lo, ki moane be aine rerengadia-lo, ki tama-di rerengadia-lo ka Nanaranga natu dipura. Tago. Nanaranga-lo ka nekiakadi dipura be inatumdi. ");
INSERT INTO mva_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pile ngae ka tamoata-ramo bokana ipura be marada anua idoki be isoaki. Kita ambe kaiboang ne malamakadi otioti taita-doi. Ngai ka tekenalana-tina, be Tama Natu. Be Tama kaiboang ne malamakadi otioti nge Natu iani. Be Nanaranga marou ne tadokidoki-ba be pile kalingodi nge ngaia-lo dikauri-tina. ");
INSERT INTO mva_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Bong Zon mata-ita bokana be mangata ipilepile nge ngai ka irangarangaki. Zon bokainatuka kaikai ipile, “Ngai ka urangarangaki bong bokai upile, ‘Murigu ngatagaia kana nge ara ilaba-tina be ngau iuasaiau-tina. Bakara, ngau isi tinagu tago inekiaka be ngai isoaki mua.’” ");
INSERT INTO mva_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ne rerengana-lo be marou ne tadokidoki-ba nge ianiang-kita-la. Tekedi tadoki be kaba takadi tadoki be bokaina-la tadokidoki kana. ");
INSERT INTO mva_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Maka ma bokai takaua: Nanaranga Mata ne moarunga nge Moses ania ipura be kita tadoki. Ata Nanaranga marou ne tadokidoki-ba be pile kalingodi ono Nanaranga kauataka ipurapura nge Iesus Kristus-lo ka tadoki. ");
INSERT INTO mva_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tamoata tagona-tina teke Nanaranga ite. Tago-la. Nanaranga Natu tekenalana-tina ka ite. Be Nanaranga ilo moarunga nge Natu-lo dieno, be Tama sakenao isukoaki. Be nge Natu ka Tama Nanaranga mangata inangai be tate. ");
INSERT INTO mva_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Iuda tamoata nedi bibia Ierusalem-lonalona ditaguraki be tamoata Nanaranga ditabatabai be Libai alu dinepidi be Zon dategi ngai naita kata. ");
INSERT INTO mva_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Bokai ditegi nge Zon pile tago izumkaki. Adoado-la mangata bokai ipile, “Ngau tago Kristus.” ");
INSERT INTO mva_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Be kaba ditegi, “Bokai nge kaiko naita? Kaiko Ilaiza ki?” Be Zon ikatu be ipile, “Tago, ngau tago ngai.” Be kaba ditegi, “Kaiko ka ‘Propet’ ngae ki?” Be Zon ipile, “Tago.” ");
INSERT INTO mva_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Alaurituka nge bokai ditegi, “Gora-kama, kaiko naita kata? Pile ono katunga tekedi gora-kama be galale be tamoata dinepi-kama garadi. Nem-la baituka kurangakiko?” ");
INSERT INTO mva_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kodeka Zon itaguraki be ‘propet’ ara Aisaia nge pilenga itoaki be bokai ipile, “Ngau nge tamoata maka masaua kaba-lo ikilaulau nge malonga. Malonga ngae bokai ikilaulau, ‘Zala adoado-tina teke Tanepoa kamaemakani be ono ngalale.’” (Ais 40:3) ");
INSERT INTO mva_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Makara nge Parasi alu dinepidia-budu be dipura nge ");
INSERT INTO mva_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Zon bokai ditegi, “Kaiko kupile kaiko tago Kristus ki Ilaiza ki ‘Propet’ ngae! Bokai nge bakara ka tamoata be aine ruku ono tamalinga ane kurukurukudi?” ");
INSERT INTO mva_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Be Zon ikatu be bokai ipile, “Ngau dang-ba ane ka ruku ono tamalinga ane uruku-kaming. Ata tamoata teke mara-ming ituitui tago kakauataki. ");
INSERT INTO mva_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ngai ka murigu ngatagaia kana. Ngau gadagada-tina be tagona-tina uboadu ae sukuma ne oarigedi mrube.” ");
INSERT INTO mva_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kana ngaedi nge Betani anua-lo ka dipura. Betani anua nge Zodan zagura ege takaianao ka ieno. Makara ka Zon ruku ono tamalinga ane be tamoata be aine irukurukudi. ");
INSERT INTO mva_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Izama nge Iesus ipurapura be Zon ite. Zon Iesus ite nge bokai ipile, “Kamate! Ngai ka Nanaranga ‘Sipisipi’ Natu ne. Ngai ka tamoata be aine moarunga kateka-o muzigoala nedi irorokaki-ledi. ");
INSERT INTO mva_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ngai ka urangaki bong bokai upile, ‘Tamoata murigu ngatagaia kana nge ara ilaba-tina be iuasaiau-tina. Bakara, ngau isi tinagu tago inekiaka be ngai isoaki mua.’ ");
INSERT INTO mva_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngau negu-la nge tago ukaua ngai ka Kristus. Ata labu ono ngau upura be dang ane ruku ono tamalinga ane urukuruku-kaming nge ono ngai mangata nangaia ngapura be Israel tamoata be aine moarunga date.” ");
INSERT INTO mva_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kodeka Zon itaguraki be kaikai-la mangata bokai ipile, “Oli Spirit nge bune bokana lang-lo ibalabala be ute. Ibala be tamoata ngaena-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ngau ambe tago mkauataki! Ngena Nanaranga, maka ngau inepia be dang ane be ruku ono tamalinga ane uruku-kaming nge ka bokai iraia, ‘Tamoata naita Oli Spirit ibala be ono isoaki nge ngai ka Oli Spirit kulubobi ane be ngaruku-kaming kana.’ ");
INSERT INTO mva_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngau ambe ute be mangata upile ngai ka Nanaranga Natu.” ");
INSERT INTO mva_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Izama nge Zon kaba tagataga ne rua zaiza be makara nora disoaki kana disoakito. ");
INSERT INTO mva_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Be bong Zon Iesus ite be ambe ngabagapalitidiato kana nge bokai ipile, “Kamate! Nanaranga ‘Sipisipi’ Natu ne!” ");
INSERT INTO mva_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bong Zon bokai ipile be tagataga ne ruoti dilongoru nge Iesus ditagaiaru. ");
INSERT INTO mva_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Be Iesus ibuiri be ite-diaru ditagatagaiaru nge bokai itegi-diaru, “Rakana karereru?” Be diaru dikaturu be bokai dipileru, “‘Rabai,’ inanga kusukoaki?” Ara ‘Rabai’ nge labu bokai: ‘Tisa.’ ");
INSERT INTO mva_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Be Iesus ikatu be bokai ipile, “Kamamairu be kaba kamaitaru.” Kodeka ditagaiaru be kaba ono isukoaki nge ditaru. Be amari ngarana-lo nge makara disoakiru. (Nge rairai amari siriki oatia-nao bokana ka makara kaba ngaradia-lo dilako.) ");
INSERT INTO mva_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tamoata ruoti Zon pilenga dilongoru be Iesus ditagaiaru nge takaia ara Endru. Endru nge Saimon Pita tari. ");
INSERT INTO mva_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bokaibe kana matamatanatuka bong ngaranao Endru iemaki nge oaikiki-tina ialale be toka Saimon ite be bokai irai, “Keka ambe ‘Mesaia’ kite.” Ara ‘Mesaia’ nge Kristus. ");
INSERT INTO mva_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kodeka ibagai be Iesus-lo ilakuaki. Iesus Saimon ite nge bokai irai, “Kaiko Saimon, Zon natu. Alauri masa aram Sipas.” (Ara Sipas nge Pita. Be ara Pita tabuiri nge “Patu-baba bibia” kana tapile.) ");
INSERT INTO mva_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Izama nge Iesus ilo ilelenaki be Galili ilako. Zala-o Pilip ite nge bokai irai, “Gotagaia.” ");
INSERT INTO mva_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip nge Betsaida tamoata kata. Endru be Pita nge ngai anua-budu-ruanga kaoa. ");
INSERT INTO mva_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Alauri Pilip ialalale be Nataniel ite nge bokai irai, “Tamoata maka Moses Mata nena-lo rangaka ipura nge ambe kite. Ngai ka rangaka ‘propet’ digere. Ara Iesus. Iosep natu. Nasaret tamoata kata.” ");
INSERT INTO mva_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Be Nataniel bokai itegi, “Nasaret? Rakana iauia teke masa Nasaret anua-lo ngapura?” Be Pilip ikatu be bokai ipile, “Gomai be gote.” ");
INSERT INTO mva_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bong Iesus Nataniel ite taona itaotao nge bokai ipile, “Kamate! Nge moangi be Israel tamoata kata. Boli mata tago teke ilona-lo ieno.” ");
INSERT INTO mva_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Makara nge Nataniel itaguraki be bokai itegi, “Bakara be kukauataka?” Be Iesus ikatu be bokai ipile, “Pilip isi tago iteko be ngau uteko mua. Kai ara ‘pig’ eruma kutuitui be Pilip ipurakangko be ikilaiko kanana-lo be uteko.” ");
INSERT INTO mva_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Kodeka Nataniel bokai ipile, “‘Tisa.’ Kaiko Nanaranga Natu. Kaiko ka Israel Anuatanepoa kandi.” ");
INSERT INTO mva_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Makara nge Iesus bokai ipile, “Kai eruma kutuitui be uteko kana upile ka lama kuni. Ata alauri masa kana kaiboangdia-tina kana ngae iuasai nge goita.” ");
INSERT INTO mva_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Kodeka Iesus ne pilenga bokai ibatadi, “Moimoi ka ura-kaming! Lang anua masa ngatakaka be Nanaranga ‘enzel’ ne Tamoata Natu-o dakautakitaki be dataotao be kamate.” ");
INSERT INTO mva_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Amaridi rua dimanubu be muridi nge tamoata teke Kena anua, ege Galili kaba-lo iroti. Be Iesus tina Maria nge roti ngarana-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bokaibe Iesus tagataga ne zaiza nge aluluiadi dipura be roti ngarana-lo dilako. ");
INSERT INTO mva_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Dimoanakonako be ‘uain’ imanubu nge Iesus tina itaguraki be Iesus bokai irai, “‘Uain’ kandi ambe imanubu.” ");
INSERT INTO mva_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Be Iesus ikatu be bokai ipile, “Tinagu negu, bakara ka ilo-buku ngaena-lo kunangaiaulako? Bong negu ono malipi negu marangaki kana isi tago dipura.” ");
INSERT INTO mva_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kodeka Iesus tina itaguraki be malipilipi pera ngarana-lonalona bokai iradi, “Rakana kamaemaki kana be ipile nge kamaemakia-ba.” ");
INSERT INTO mva_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Saringa makara nge agora kanabibia lima-teke dieno. Agora ngaedia-lo nge dang diauiau be Iuda mata nedi ditagatagadi be ono dirukuruku. Agora tekena-lo iboadu dang biabia-tina auna ngapura, kaleti pile-lo ‘20’ ki ‘30 galen’ bokana. ");
INSERT INTO mva_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kodeka Iesus malipilipi bokai iradi, “Agora ngaedia-lo dang kamaiau.” Be dang diau nibe agora lima-rua nge dikauriboadega. ");
INSERT INTO mva_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Diau-doi, kodeka Iesus bokai ipile, “Agora tekena-lo dang alu kamakesi be tamoata moanako ngaena-lo imuamua kamaeluakani.” Be malipilipi ditaguraki be agora tekena-lo dang alu dikesi be tamoata imuamua nge dieluakani. ");
INSERT INTO mva_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kodeka tamoata ngae zerea itoi. Kana-ra dang ka dieluakani, ata ambe itabuli be ‘uain’ ipura. Tamoata ngae tago ikaua inanga ka ‘uain’ ngae ipura. Ata malipilipi dang dikesi nge dikaua. Bokaibe tamoata ngae ilako be tamoata iroti nge rubenaba laua-o ilakuaki ");
INSERT INTO mva_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","be bokai irai, “‘Uain’ uia ka negedia-mua dipurapura. Muzi teke bokai ieno: Lou moarunga ‘uain’ iauia biabia-tina dasing be daboadu noko ‘uain’ tago iauia nge negea ngapura. Ata kaiko ‘uain’ iauia kudokimatei nibe alaurituka kunegei.” ");
INSERT INTO mva_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kilala kaiboangi ngae ka Iesus matamatanatuka iemaki. Kena anua, ege Galili kaba-lo be kilala ngae iemaki. Be nge ono Iesus ne malamaka kaiboangdi nge mangata inanga. Makara be tagataga ne nge lama diunania-uia. ");
INSERT INTO mva_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kana ngae muri nge Iesus tina be taritoka be tagataga ne zaiza be Kaperneam anua-lo dilako be amaridi alu makara disoaki. ");
INSERT INTO mva_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Iuda moanako nedi biabia ara ‘Pasoba’ nge ambe saringatuka ngapura kana. Bokaibe Iesus itui be Ierusalem ilako. ");
INSERT INTO mva_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ierusalem-lo ipura nge Nanaranga pera nena-lo ilako. Makara ilako nge tamoata kokoko itedi ‘bulumakau,’ ‘sipisipi’ be bune tamoata takadi dianiandi be dizazaza. Be tamoata maka ungguma takadi ‘mone’ nedi didokidoki be Iuda ‘mone’ nedia-lo dibubuiri-lako nge makara bagi nedi ono ‘mone’ nanganga-lo disoaki. ");
INSERT INTO mva_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Bokaibe Iesus itaguraki be oarige idoki be raia kili teke bokana ipoiraki be ono ngado nedi itaodi be eluku ilakuakidi. ‘Bulumakau’ be ‘sipisipi’ nedi nge itaodia-doi. Tamoata ‘mone’ didokidoki be dibubuiri nge bagi nedi isuburaki be ‘mone’ nedi idua-ramoaki. ");
INSERT INTO mva_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Be tamoata bune ono ‘mone’ didokidoki nge bokai iradi, “Kana ngaedi kamadoki be kamairatu! Nge bakara ka Tamagu pera ne ono tabulinga be kana ono zazanga bokana kabasaki?” ");
INSERT INTO mva_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Makara nge Iesus tagataga ne pile tekedi Nanaranga ‘Buku’ nena-lo dieno nge ilodi diandi. Pile ngaedi bokai dieno, “Pera nem reretaka nge ilogu-lo eoa bokana idududui.” (Sam 69:9) ");
INSERT INTO mva_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iuda tamoata nedi bibia kaba bokai dita nge dipura be Iesus bokai ditegi, “Kilala kaiboangi nangata goemaki be masa keka gate be gakaua kaiko kaiboang dienoniko be iboadu bokai gomuzi?” ");
INSERT INTO mva_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Be Iesus ikatu be bokai iradi, “Nanaranga pera ne ngae kamagamani masa amaridi toli ilodia-lo be kaba marangaki!” ");
INSERT INTO mva_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Makara nge Iuda bibia nedi bokai dipile, “Pera ngae nge barasi kulemoadi-oati-be-lima-teke ilodia-lo be kelia ipura! Nge masa baituka be amaridi toli ilodia-lo be kaba gomarangaki?” ");
INSERT INTO mva_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ata Nanaranga pera ne Iesus irangarangaki nge ne tamoata ka irangarangaki. Tago pera-tina kata ka irangarangaki. ");
INSERT INTO mva_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Alauri imate be kaba marangaka ipura nge tagataga ne pile ngaedi ipile nge ilodi diandi. Makara nge pile Nanaranga ‘Buku’ nena-lo digere be Iesus pilenga ngaedi nge lama diungdi. ");
INSERT INTO mva_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iesus makara moanako biabia ara ‘Pasoba’-lo isoaki Ierusalem-lo nge kilala kaiboangdi kokoko iemaki be teadi dipura. Bokaibe tamoata be aine kokoko-tina lama diuni. ");
INSERT INTO mva_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ata Iesus tagona-tina lama iunadi. Tago-la! Maka ma ngai tamoata moarunga ikauatakidia-tina uia! ");
INSERT INTO mva_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tago teke iboadu tamoata ilodi ngarangakidiani. Rakana ka tamoata ilodia-lo dieno nge Iesus ikauataki-doi. ");
INSERT INTO mva_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iuda tamoata nedi biabia teke isoaki ara Nikodimas. Ngai nge Parasi kata. ");
INSERT INTO mva_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bong teke oabubu-lo ipura be Iesus bokai irai, “‘Tisa,’ keka kikaua kaiko gosule-kama kana ka Nanaranga inepiko be kupura. Tamoata tago teke iboadu kilala kaiboangdi kaiko kuememaki bokana ngaemaki. Tago-tina. Nanaranga nena-la be tamoata bokainaina sakenao isukoaki-la ka iboadu kilala kaiboangdi ngaememaki. Tago be tago!” ");
INSERT INTO mva_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Be Iesus ikatu be bokai ipile, “Moimoi ka uraiko! Tamoata tago kaba nekiaka ipura nge tagona-tina iboadu bong ono Nanaranga ngatanepoa kana nge ngate!” ");
INSERT INTO mva_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Makara nge Nikodimas itegi, “Nge masa baituka? Tamoata ambe ikamoangbia masa bakara be kaba nekiaka ngapura? Tago iboadu tina ilona-lo ngasili be kaba bong ruaia nekiaka ngapura!” ");
INSERT INTO mva_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Be Iesus ikatu be bokai ipile, “Moimoi ka uraiko! Tamoata naita tago dang be Oli Spirit ane nekiaka ipura nge tagona-tina iboadu anua ono Nanaranga ngatanepoa kanana-lo ngasili. ");
INSERT INTO mva_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Tamoata nge tamoata dipupurakidi. Ata Oli Spirit nge mariabakada ipupuraki. ");
INSERT INTO mva_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bokai uraiko, ‘Kaba nekiakam ngapura’ ngena moaki kupitilaki be ilom lelenaka ira. ");
INSERT INTO mva_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Oasa nge rerengana-lo ka ialalale. Inanga ngalako kana nge ngalako-ba. Malonga kulongolongo, ata inanga ka ipura be ambe inanga ilakolako nge tago kukaua. Be bokainatuka-la, tamoata Oli Spirit-lo nekiaka ipura nge bokainatuka oasa bokana ialalale.” ");
INSERT INTO mva_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Kodeka Nikodimas bokai itegi, “Nge masa baituka?” ");
INSERT INTO mva_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Be Iesus ikatu be bokai ipile, “Kaiko Israel anua-singara nedi kata, ata bakara be kana ngaedi tago kukauataki? ");
INSERT INTO mva_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Moimoi ka uraiko! Keka kana kikauataki ka kirarangaki, be kana kita ka mangata kirarangaki. Ata kam tago teke isumoala be pile mangata kirangaki nge idoki. ");
INSERT INTO mva_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ngau kateka kana ane be pile ura-kaming, ata lama tago kauni. Bokaibe lang anua kana ane be mra-kaming masa bakara be lama kamauni? ");
INSERT INTO mva_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tamoata tago teke lang anua-lo ilako. Tamoata Natu-la ka ilako. Maka ma ngai ka lang anua-lo be ibala. ");
INSERT INTO mva_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Moses-la lulu kaba-lo be moata ‘bronz’ oti ememaki kai burunao be idokiteteki be ono tamoata dite be diuia bokana, Tamoata Natu masa bokainatuka-la dokiteteka ngapura. ");
INSERT INTO mva_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Bokai masa tamoata naita Tamoata Natu lama iunani nge moauriuri-la nem-kusoaki ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Maka ma Nanaranga tamoata be aine moarunga kateka ngaenao ireretakidia-tina. Bokaibe Natu tekenalana-tina nge idoki be tamoata be aine moarunga kateka ngaenao iandi. Bokai masa tamoata naita Natu ngae lama iunani nge tago iboadu ngaleua. Masa moauriuri-la nem-kusoaki ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nanaranga nena-la be Natu makare kateka-o inepiaria nge tago tamoata be aine maka kateka-o ngalilitidi be ngara-leuadi kana. Tago-la. Ngauketidi be ngamuleakidi kana ka ipura. ");
INSERT INTO mva_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Tamoata naita Natu ngae lama iunani masa tago lilita be ara-leuaia ngapura. Ata tamoata naita tago lama iunani nge ambe lilita be ara-leuaia ipura-doi, bakara tamoata ngae Nanaranga Natu tekenalana-tina nge lama tago iunani. ");
INSERT INTO mva_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nanaranga bokainatuka be tamoata be aine lama tago diuni saranga aoa-dialo ngarokakalako be giriki odio nganangalako kana: Malama teke kateka-o ipura, ata tamoata be aine kateka-o oabubu direretaki. Muzi goalakadia-tina diememaki. Bokai ka oabubu direretaki be malama disegesegeaki. ");
INSERT INTO mva_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tamoata muzingadi goalakadi masa oabubu dareretaki be taburidi dara be malama-lo lako dasege. Tago direre muzingadi goalakingadi nge mangata-bulaelae daeno. ");
INSERT INTO mva_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ata tamoata muzi uia kalingodi diememaki masa malama-lo lako darere. Bokai masa malama ngaitikingdi malipi diemaki nge Nanaranga rerengana-lo ka diemaki.” ");
INSERT INTO mva_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kana ngae muri nge Iesus tagataga ne zaiza Zudea kaba-lo dilako. Be makara muku disoaki-budu, be ruku ono tamalinga ane be tamoata be aine irukurukudi. ");
INSERT INTO mva_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Zon nge Aenon anua-lo tamoata be aine ruku ono tamalinga ane irukurukudi. Aenon anua nge Salim anua saringa ka ieno. Makara nge dang kokoko dieno, be tamoata be aine isi dipurapura-la be ruku ono tamalinga ane irukurukudi. ");
INSERT INTO mva_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Bong ngaradia-lo nge Zon isi tago uaura-lo nangaia ipura. ");
INSERT INTO mva_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Zon tagataga ne alu ditaguraki be Iuda tamoata teke zaiza Iuda mata nedi ono dirukuruku be bolo dirorokaki nge diegoretaki. ");
INSERT INTO mva_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bokaibe dilako be Zon bokai dirai, “‘Tisa!’ Ilom kauakaua ki tago? Tamoata ma maka Zodan zagura ege takaianao kasoaki-buduru be mangata kurangakia-re! Ngai ambe tamoata be aine ruku ono tamalinga ane irukurukudi be moarunga be ngaia-doi-lo dilakolako!” ");
INSERT INTO mva_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Zon bokai ilongo nge ikatu be bokai ipile, “Tamoata tago teke iboadu kana teke rerenganaba-lo be Nanaranga-lo ngadoki. Tago-la. Nanaranga iani ka iboadu kana teke ngaenoni. Tago be tago. ");
INSERT INTO mva_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kam nge ngau mata-ita negu bokana be iboadu mangata bokai kamarangaka, ‘Zon tago Kristus. Ngai ka nepia ipura be Kristus aro imua.’ ");
INSERT INTO mva_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bokai kamakaua: Aine kodeka-ka iroti nge moane kodeka-ka iroti roa. Ata tamoata kodeka-ka iroti ruanga masa bokai ngatuitui be kaba ngaitaita. Be bong ruanga kodeka-ka iroti malonga ngalongo masa suri dauia-tina! Suri uia ngaedi nge ngau negu, be ambe dikalingo. ");
INSERT INTO mva_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngai ara ngakautaki be ngau aragu ngataoio. ");
INSERT INTO mva_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tamoata naita etatabala be ibala nge ara biabia be moarunga iuasadi. Tamoata naita kateka ngaena-onaona nge kateka-tamoata be kateka kana irarangaki. Ata tamoata naita lang anua-lo be ibala nge moarunga iuasadi be atabaladi isoaki. ");
INSERT INTO mva_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Moimoi ngai Nanaranga-lo kana ita be ilongo ka mangata irarangaki, ata tago teke pilenga ilongo be idoki. ");
INSERT INTO mva_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tamoata naita pilenga ilongo be idoki nge ambe mangata ipile bokana Nanaranga moimoi be pilenga kalingodi. ");
INSERT INTO mva_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tamoata maka Nanaranga inepi be ipura nge Nanaranga pilenga ka ipilepile. Tamoata bokainaina nge Nanaranga ambe Oli Spirit ne ere-moarunga be ono inangai. ");
INSERT INTO mva_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Tama nge Natu ireretakia-tina, be Tama kana ne moarunga nge ambe Natu luma-nao isalangaki. ");
INSERT INTO mva_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tamoata naita Natu lama iunani masa moauriuri-la nem-kusoaki ngasukoaki. Tamoata naita Natu pilenga imurinadi masa moauriuri-la soaki tago ngate. Maka ma Nanaranga nama ratinga masa nem-kueno ono daeneno.” ");
INSERT INTO mva_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parasi nge bokai dilongo Iesus ambe Zon iuasauasai be tagataga ne kokoko idokidokidi be ruku ono tamalinga ane irukurukudi. ");
INSERT INTO mva_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ata Iesus nena-tina nge tamoata tago teke ruku ono tamalinga ane irukui. Tagataga ne ka tamoata be aine dirukurukudi.) ");
INSERT INTO mva_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesus bokai ilongo nge Zudea kaba ipereki be kababe Galili kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Zudea kaba-lo be Galili ngalako kana nge Samaria kaba ngalaleaki noko Galili kaba-lo ngapura. ");
INSERT INTO mva_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ialale be Samaria kaba-lo nge anua ara Saika-lo ipura. Anua ngae nge kateka teke toira Zekop natu Iosep iani nge saringa ka ieno. ");
INSERT INTO mva_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Be makara ka Zekop dang-kesua ne ieno. Iesus nge kasau ialale be imamalo-tina. Bokaibe makara dang-kesua ngae sakenao isoakiria. Ambe amari-soasoa-tina bokana. ");
INSERT INTO mva_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Iesus makara isoaki nge Samaria aine teke ipura be dang ngakesi kana. Be aine ngae ambe dang kana ikesikesi nge Iesus bokai ipile, “Dang muku goana be msing.” ");
INSERT INTO mva_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Tagataga ne nge anua-lo dilako be kangkang dazaza kana.) ");
INSERT INTO mva_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kodeka Samaria aine nge bokai ipile, “Kaiko Iuda kata be ngau Samaria ainegu. Nge baituka ka dang gosing kana be kusinauia?” (Iuda tago diboadu Samaria tabira be sema kandia-lo damoanako ki dang dasing.) ");
INSERT INTO mva_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Be Iesus ikatu be bokai ipile, “Nanaranga lumaluma ne gokauataki bokana, be gokaua naita kata ka dang sing kana be isinauiko nge ambe iboadu gotegi be dang papanana ngangko.” ");
INSERT INTO mva_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Be aine ngae ipile, “Biabiadi, dang-kesua ngae nge itaoio-tina be kana ono dang kesia be repekarake ngapura kana nge tago. Dang papanana masa inanga gokesi? ");
INSERT INTO mva_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kaiko masa tubuma Zekop kuasai be iboadu dang papanana teke makare gopuraki ki? Ngai ka toira be dang-kesua ngae iang-kama. Ngai ne, natu, be ‘sipisipi’ be ‘bulumakau’ ne nge makarena-doi dang-kesua ngaena-lo dang dising.” ");
INSERT INTO mva_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Kodeka Iesus bokai ikatuni, “Tamoata naita dang-kesua ngaena-lo dang ising masa kaba madole ngamate, ");
INSERT INTO mva_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ata tamoata naita ngau dang uiani be ising nge tagona-tina iboadu kaba madole ngamate. Dang ngau uiani masa dang kateka-lo ipanapanatakarake bokana ilona-lo ngapapanana be ono moauriuri-la nem-kusoaki ngasukoaki.” ");
INSERT INTO mva_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Be aine nge bokai ipile, “Biabiadi, dang ngae goana! Bokai masa tago iboadu madole matemate be tago iboadu kaba makare mpurapura be dang mkesikesi!” ");
INSERT INTO mva_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Makara nge Iesus bokai ipile, “Goalale be roam gobagai.” ");
INSERT INTO mva_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Be aine ngae ikatu be bokai ipile, “Roagu tago.” Kodeka Iesus bokai irai, “Roam tago kana kupile nge moimoi ka kupile. ");
INSERT INTO mva_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kaiko toira moane lima kuatidi, be tamoata kaituka-tina kasukoaki-buduru nge tago roam. Pile kaituka-tina kupile nge moimoi ka kupile!” ");
INSERT INTO mva_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Makara nge aine ngae bokai ipile, “Biabiadi, kodeka kaba uita kaiko moimoi be ‘propet’ kata. ");
INSERT INTO mva_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Keka Samaria tubuma makare buku ngaenao Nanaranga dirakerakeaki, ata kam Iuda kapile Ierusalem-lanalo ka iboadu Nanaranga tarakerakeaki.” ");
INSERT INTO mva_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Kodeka Iesus aine ngae bokai irai, “Aine kaiko, pilengagu golongo uia, bong masa dapura, be bong ngaradio masa Tama-gu tago makare buku ngaenao ki Ierusalem-lo kamarakerakeaki. Tago-la. ");
INSERT INTO mva_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kam Samaria nge Nanaranga karakerakeaki, ata tago kakauatakia-uia! Tago-la. Kekai-la Iuda ka kikaua naita ka kirakerakeaki, bakara Nanaranga tamoata be aine moarunga ngauketidi be ngamuleakidi kana labuna-tina nge ungguma Iuda-lo ka ipura. ");
INSERT INTO mva_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ata bong masa dapura, be ambe dipura. Bong ngaedia-lo masa tamoata be aine moimoi be Tama-gu dirakerakeaki nge ere-mariabakadi be muzi kalingodia-lo be Tama-gu nena-tina bokana darakerakeaki. Tamoata bokainatuka mata kalingodia-lo be Tama-gu dirakerakeaki ka darakerakeaki kana irerere. ");
INSERT INTO mva_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nanaranga nge Mariaba. Bokaibe tamoata dirakerakeaki nge ere-mariabakadi be pile kalingodia-lo be darakerakeaki.” ");
INSERT INTO mva_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Be aine ngae bokai ipile, “Ngau ukaua Mesaia maka Kristus kana rangaka ipurapura nge ngapura kana. Bong ipura masa kana moarunga labudi ngara-kama.” ");
INSERT INTO mva_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kodeka Iesus bokai ipile, “Ngau makare tapilepile-buduru ka tamoata ngae!” ");
INSERT INTO mva_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Makara dipilepile-ru nge Iesus tagataga ne dimule. Kaba dita bokana nge aine kata diaru ka dipilepile-ru. Makara nge dipitilaki-tina. Ata tago teke bokai itegi, “Aine ngae rakana irere?” ki “Bakara ka aine ngae kamru kapilepile-ru?” ");
INSERT INTO mva_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kodeka aine ngae boadi kana ono dang kesinga makara ipereki be kababe anua-lo imule be tamoata be aine bokai iradi, ");
INSERT INTO mva_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kamamai be tamoata kata kana moarunga norane be uemaki irangakina nge kamate. Masa ngai ka Kristus?” ");
INSERT INTO mva_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bokaibe tamoata be aine anua nedi dipereki be Iesus-lo dilako. ");
INSERT INTO mva_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iesus tagataga ne nge ambe Iesus bokai diakorokoroi, “‘Tisa’ kana teke gokang!” ");
INSERT INTO mva_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ata Iesus bokai ipile, “Kangkang kanagu ukangkang nge kam tago kakauataki!” ");
INSERT INTO mva_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bokai ipile nge tagataga ne nedia-la bokai dietegi, “Masa tamoata teke kangkang ieluakini ki?” ");
INSERT INTO mva_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Kodeka Iesus bokai iradi, “Kangkang kanagu nge nepinepi negu rerenga mtagatagadi be malipi ne mememaki be mambuaki kana. ");
INSERT INTO mva_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pilenga-ming tekedi bokai dieno, ‘Kangkang tanomadi dapura be daeno nibe kalea oati damanubu be kodeka bong ono uaroenga dapura.’ Ata ngau bokai ura-kaming. Mata-ming kamapoarakaki, be kamagea-ramo be uma kamaita! Kangkang ambe dimaure, be nge ambe uaroe bong ka dipura! ");
INSERT INTO mva_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kaituka-tina ambe tamoata kangkang iuaroeroe nge zazanga ne imalipilipitaki. Be kaituka-tina ambe kaba odio nem-kusoaki soaki ipurapura-lo kangkang ngalakuaki kana nge iuaroeroe. Bokai masa tamoata kangkang itano be tamoata kangkang iuaroe nge bong-doi teke suri-diaru dauia. ");
INSERT INTO mva_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Bokaibe pile ngaedi ‘Tamoata taka kangkang itano be tamoata takaia iuaroe’ nge moimoi be kalingodi. ");
INSERT INTO mva_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ngau unepi-kaming be kalako be uma tago kamalipitakia-lo kangkang kauaroe. Tamoata takadi makara malipi bibia diemaki, be kam nge dia-ba mamalongadia-lo ka kana uia kauaroe.” ");
INSERT INTO mva_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria aine nge ialale be bokai ipile, “Kana moarunga uemaki nge irangakina.” Bokaibe tamoata be aine kokoko-tina anua ngarana-lo nge Iesus lama diunani. ");
INSERT INTO mva_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Be bong Samaria tamoata be aine Iesus dipurakani nge diakoroi be makara anua nedia-lo sakedi-o muku ngasoaki kana dirai. Bokaibe amaridi rua makara isoaki. ");
INSERT INTO mva_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tamoata be aine makara anua ngarana-lo Iesus pilenga dilongo nge kaba kokoko-tina lama diuni. ");
INSERT INTO mva_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kodeka aine ngae bokai dirai, “Kodeka lama kiuni. Tago kaiko pilengam kilongo ka lama kiuni. Tago. Kodeka nemai-la be kilongo ka lama kiuni. Be kodeka kikaua ngai moimoi be tamoata be aine moarunga kateka ngaenao Uketiketi nedi.” ");
INSERT INTO mva_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Iesus makara Samaria kaba-lo amaridi rua isoaki be muridi nge Galili kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","45","Bokaibe bong Galili kaba-lo ipura nge anua-marau suridi diuia be didoki. Maka ma Iesus nena-la be bokai ipile, “‘Propet’ kaba-tina nena-lo nge muaka tagotago.” Bokaibe matamata nge disegeaki, ata alauri ‘Pasoba’ bong-o be kana moarunga Ierusalem-lo iemaki dita nge kaba disuri-uiataki, bakara bong ngaranao nge di moarunga makara dilako. ");
INSERT INTO mva_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kodeka Iesus kaba imule anua ara Kena-lo, ege Galili kaba-lo. Makara ka norane be dang ibuiri be ‘uain’ ipura. Be Iesus makara Kena-lo isoaki nge Erot tamoata ne biabia teke Kaperneam anua-lo ka itui be makara ipurakani. Tamoata ngae natu moaneka imore be Kaperneam-lo ieno ka ipura. ");
INSERT INTO mva_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tamoata ngae bokai ilongo Iesus ambe Zudea kaba ipereki be Galili kaba-lo ipura bokana ialale be Iesus bokai iakoroi, “Gomai Kaperneam-lo be natu-gu goaka-uiaki. Ambe saringatuka ngamate kana.” ");
INSERT INTO mva_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Makara nge Iesus itaguraki be tamoata ngae bokai irai, “Tago teke masa iboadu lama-ba gouni ki? Kilala be malipi kaiboangdi kamaita masa lama kamauni. Tago nge tago!” ");
INSERT INTO mva_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ata tamoata ngae bokai ipile, “Biabiadi, gomai marakai! Natugu ngamate takana!” ");
INSERT INTO mva_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Be Iesus tamoata ngae bokai irai, “Goalale! Natum masa ne iauia ngasoaki!” Makara nge tamoata ngae Iesus pilenga lama iungdi be kaba Kaperneam-lo imule. Ialale be zala-o ieno. Izama be kaba itui be ialalale nge ");
INSERT INTO mva_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","isi zala-lanalo ialalale be malipilipi kana dipura be bokai dirai natu ambe ne iauia isoaki. ");
INSERT INTO mva_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Itegidi amari baituka ieno be natu iuia nge bokai dipile, “Nora amari ambe mukuna-la malala ipereki be more kusi-ragogo ileuani.” ");
INSERT INTO mva_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Makara nge tamoata ngae ilo ikauani amari bokainatuka ieno be Iesus bokai ipile, “Natum masa ne iauia ngasoaki.” Bokaibe ngai be roa be natu moarunga nge lama diuni. ");
INSERT INTO mva_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Bong Iesus Zudea kaba ipereki be kaba Galili-lo imule nge kilala kaiboangdi ruaia ka iemaki. ");
INSERT INTO mva_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Bong alu dilako be muridi nge Iuda bong nedi biabia teke be Iesus Ierusalem ilako. ");
INSERT INTO mva_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Makara Ierusalem-lo nge ilako-soasoa ‘Sipisipi’ Babaduadua-lo. Babaduadua ngae sakenao nge dang teke boakuboaku Ibru pile-lo Betzata nge ieno. Be bagi sumadi otioti nge lima dang boakuboaku ngae diboalingi. ");
INSERT INTO mva_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Makara bagi dang diboalingi-o nge tamoata moremore kokoko-tina dieno: matadi leuadi, aedi matedi be tapoudi matedi. Dang moakusunga dirarapung. ");
INSERT INTO mva_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bong teke-teke nge Tanepoa ‘enzel’ ne ipurapura be dang ilona-lo ilakolako be imoakusukusungaki. Ngamoakusungakia-doi be tamoata nangata ilako-tuka mua nge more bakarairai ienoni nge ngaleua. ");
INSERT INTO mva_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tamoata teke makara ieno nge more ono ieno be ambe barasi kulemoadi-toli-be-lima-toli iuasadi. ");
INSERT INTO mva_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesus tamoata ngae bokai ieno be ite nge ikaua more ngae toira-tina be ono ieno. Bokaibe itegi, “Kurere goiua ki?” ");
INSERT INTO mva_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Be tamoata ngae ikatu be bokai ipile, “Biabiadi, bong dang moakusungaka ipurapura nge tamoata tago teke idumadumaia be dang-lo inanganangaiaulako. Negu-la be mlako kana nge mbebebe-la be tamoata takaia ngalako mua.” ");
INSERT INTO mva_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Be Iesus itaguraki be tamoata ngae bokai irai, “Gotui be zirapu nem godokitate be goalalale!” ");
INSERT INTO mva_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Makara nge oaikiki-tina tamoata ngae iuia, be zirapu ne idoki be makara maradi ialalale. Bong ono kana ngae emaka ipura nge bong ono manauanga ‘Sabat’-o ka emaka ipura. ");
INSERT INTO mva_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bokaibe Iuda tamoata nedi bibia nge ditaguraki be tamoata adoraka ipura nge bokai dirai, “Kaituka nge bong ono manauanga. Moses Mata ne ibabari-kita tago iboadu bong ono manauanga-o zirapu nem gobazi.” ");
INSERT INTO mva_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ata tamoata ngae ikatu be bokai ipile, “Tamoata iadoraka be uia nge bokai iraia, ‘Zirapu nem godokitate be goalalale.’” ");
INSERT INTO mva_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Makara nge bokai ditegi, “Tamoata nangata ka iraiko zirapu nem godokitate be goalalale?” ");
INSERT INTO mva_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tamoata be aine makara nge dikoko-tina. Bokaibe tamoata maka adoraka ipura nge tago ikaua naita ka iadoraki, bakara Iesus ambe tamoata be aine maradi isili be ialale. ");
INSERT INTO mva_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Alauri Iesus tamoata iadoraki ngae Nanaranga pera nena-lo ite nge bokai irai, “Goteko! Ambe kuia. Moaki kaba teke muzigoala kuemaki. Muzigoala teke kaba kuemaki masa kana goalakana-tina teke ngapuraniko.” ");
INSERT INTO mva_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kodeka tamoata ngae ialale be Iuda tamoata nedi bibia iradi Iesus ka iadoraki. ");
INSERT INTO mva_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iesus kana ngaedi bong ono manauanga ‘Sabat’-o ka iememaki bokana Iuda ditaguraki be moatubu ono dinangalako. ");
INSERT INTO mva_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bokaibe Iesus bokai iradi, “Tama-gu malipi ne izamaizama iememaki-la nibe imai-ba kaituka-tina. Bokaibe ngau masa malipilipi-la kana.” ");
INSERT INTO mva_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bokai ipile nge kodeka Iuda bibia nedi iemakidi be ono tinedi ikaubaluri be daumoateia-tina kana direre. Nge tago bong ono manauanga-la ka igamani, ata ipile Nanaranga nge Tamana-tina be nge iriringa-diaru tekedi bokana. ");
INSERT INTO mva_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Bokaibe Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming! Natu tago iboadu kana teke rerenganaba-lo ngaemaki. Tago-la. Natu nge Tama kana iememaki itaita ka iememaki. Rakana Tama iemaki nge Natu ngaemaki be. ");
INSERT INTO mva_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maka ma Tama nge Natu irereretakia-tina, be kana moarunga iememaki nge Natu itikitikini. Tama masa kana kaiboangdia-tina kana ngaedi iememaki diuasadi nge Natu ngaitikini be ngaemaki. Be kam masa kamaita be kamapitilaki-tina be kamakabaki. ");
INSERT INTO mva_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tama-nala matedi imarangrangakidi be ono moauringa ianiandi bokana, Natu masa rerengana-lo tamoata nangata ireretaki nge ono moauringa ngani. ");
INSERT INTO mva_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Bokaibe bokai kamakaua: Tama tago sesu-tina tamoata teke giriki ne ililiti. Tago-la! Malipi ngaedi nge ambe ere-moarungadi be Natu luma-nao isalangaki. ");
INSERT INTO mva_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Bokai masa Tama-la moarunga-biabia dimuamuaki bokana nge Natu damuamuaki. Tamoata naita Natu tago imuamuaki nge Tama tago imuamuaki. Maka ma Tama ka Natu inepi be makare ipura. ");
INSERT INTO mva_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Moimoi ka ura-kaming! Tamoata naita pilengagu ilongo be nepinepi negu lama iunani nge ambe moauriuri-la nem-kusoaki ngasukoaki kana. Tago masa lilita be ara-leuaia ngapura. Tago-la. Maka ma nge ambe mate-lo ka imule be moauriuri soaki-lo ilako. ");
INSERT INTO mva_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Moimoi ka ura-kaming! Bong teke masa ngapura, be ambe ipura. Bong ngaenao masa matemate Nanaranga Natu malonga dalongo. Be tamoata malonga ngae dilongori masa moauriuri-la dasoaki. ");
INSERT INTO mva_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maka ma Tama ka nena-la be ono moauringa labu ienoni. Bokaibe Natu nge bokainatuka-la iemaki be Natu nge ono moauringa labu ienoni. ");
INSERT INTO mva_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tama ka isumoala be Natu iboadu tamoata be aine giriki nedi ngaliliti be ngadoraki, bakara ngai ka Tamoata Natu. ");
INSERT INTO mva_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Moaki pile ngaedi kalongo be kapitilaki! Bong teke masa ngapura, be bong ngaenao masa matedi moarunga poda-dialo dieno nge Natu malonga dalongo ");
INSERT INTO mva_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","be podadi dapereki be eluku dapusikalako. Tamoata muzi uia diemaki masa damarang be moauriuri-la dasoaki. Be tamoata muzi goalakadi diemaki masa damarang be eoa tago matemate-lo dalako. ");
INSERT INTO mva_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Negu-ba tago iboadu kana teke memaki. Ngau Nanaranga iraraia be ulongolongo-la bokana ka giriki ulililiti be uadoadoraki. Bokaibe giriki adorakingagu nge diadoado-tina. Maka ma ngau tago rerengagu ka utagatagadi. Tago-la. Nge nepinepi negu ka rerenga utagatagadi. ");
INSERT INTO mva_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ngau negu-la be mangata urangaka nge negu-ba ka urangaka bokana, be pilengagu ono urangaka nge kalingodi tagotago. ");
INSERT INTO mva_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ata takaia isoaki be pile-lo murigu ituitui be mangata irangarangaka. Be ngau ukaua mangata bakara irangarangaka nge pilenga moimoi be kalingodi otioti. ");
INSERT INTO mva_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Kam tamoata neming Zon-lo kanepidialako be pile dalongo kana. Be ambe pile bokai dilongo Zon nge pile moimoi be kalingodi ka mangata irarangaki. ");
INSERT INTO mva_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ngau tago kateka-tamoata murigu datui be mangata darangaka kana urere ka bokai upile! Tago. Ngena ono Nanaranga ngauketi-kaming be ngamuleaki-kaming kana ka bokai upile. ");
INSERT INTO mva_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zon nge baratui bokana be ikarakara be imalamalama, be kam nge uanana tago sasalaga malama ngae kadoki be ono suri-ming diuia. ");
INSERT INTO mva_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ata ngau kana negu teke ieno be ono mangata ngarangaka kana. Kana ngae nge Zon pilenga iuasadia-tina. Kana negu ngae nge bokai: Malipi-ma maka Tama-gu iana be memaki kana, be ambe uememaki ngaedi ka mangata darangaka kana. Nge ono mangata kaba kamaita be kamakaua Tama-gu ka inepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tago Zon-la ka mangata irangarangaka. Tama-gu murigu itui be mangata irangarangaka be! Maka ma ngai ka inepia be makare upura! Kam tago sesu malonga kalongo, be lili tago kaita. ");
INSERT INTO mva_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Be pilenga nge tago ilo-minglo dieno, maka ma tamoata maka Tama kateka ngaenao ineparia nge lama tago kaunani! ");
INSERT INTO mva_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Be kana takaia bokai: Nanaranga ‘Buku’ nena-ra kalezeleze-tina uia be pile labudi kalelelei-tina uia. Be ilo-ming bokai dipilepile ‘Buku’ ngaedi ilodia-lo ka ono moauriuri-la nem-kusoaki soaki ipurapura nge ieno. Ata bokai kamakaua: ‘Buku’-tina ma ngaedi ka ngau murigu ditui be mangata dirangaka, ");
INSERT INTO mva_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ata ngau-lo kamamai be moauriuri-la kamasoaki kana nge kasege. ");
INSERT INTO mva_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ngau tago kateka-tamoata rakeaka dana kana ka bokai upilepile. Tago-tina. ");
INSERT INTO mva_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ata ngau ilo-ming ukauataki. Ngau ukaua Nanaranga reretaka tago ilo-minglo ieno. ");
INSERT INTO mva_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngau Tama-gu ara-nao be makare upura, ata tago kareretaka be kadoka. Tago-la. Ata tamoata teke ne ara-nao be ipura nge masa kamareretaki be kamadoki. ");
INSERT INTO mva_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kam karerere tamoata ruanga-ming darakerakeaki-kaming. Ata rakeaka uia Nanaranga tekenalana-tina-lo dipurapura nge uasadi be dokiadi kasegesege. Bokai nge, masa baituka be lama kamauni? ");
INSERT INTO mva_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Moaki ilo-ming dipile Tama-gu lili-be-matanao masa mtuirake be mtunuri-kaming be giriki omingo mnangalako. Tago-la. Moses Mata nena-ma maka ilo-ming dianiandi be ono kakaiboang nge ka aoa-minglo saranga darokakilako be giriki omingo nganangalako kana. ");
INSERT INTO mva_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses nge ngau ka rangakagu igere. Bokaibe Moses Mata ne lama kamaungdi bokana nge ambe ngau lama kamaunana. ");
INSERT INTO mva_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ata kam Moses kana igere nge lama tagona-tina kaungdi. Bokai nge masa baituka be kana ngau urangaki nge lama kamaungdi?” ");
INSERT INTO mva_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Bong alu dilako muridi nge Iesus dang biabia ara Galili (ara takaia Taibirias) nge itotoki be ege takaianao ilako. ");
INSERT INTO mva_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Be tamoata be aine dum kanabiabia teke nge itagai. Iesus kilala kaiboangdi moremore-o iemaki nge dita ka ditagai. ");
INSERT INTO mva_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kodeka Iesus buku tekenao ilako be isoakiria tagataga ne zaiza. ");
INSERT INTO mva_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Iuda moanako nedi biabia ara ‘Pasoba’ nge ambe isaringa. ");
INSERT INTO mva_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesus igea be tamoata be aine dum kanabiabia teke taona ditaotao be ite nge Pilip bokai irai, “Kangkang inanga tazazai be tamoata be aine ngaedi tandi be dakang?” ");
INSERT INTO mva_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Iesus nena-la nge ikaua masa rakana ngaemaki. Ata ngena ono Pilip ngatoi kana ka bokai ipile.) ");
INSERT INTO mva_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Be Pilip ikatu be bokai ipile, “Kalea lima-toli zazanga nedi tadoki be kangkang tazazai nge tago iboadu tamoata be aine ngaedi ono takolangdi. Dikoko-tina-ma! Muku-tina-muku tanege, ata tago masa daboadu.” ");
INSERT INTO mva_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Makara nge tagataga ne teke ara Endru, Saimon Pita tari bokai ipile, ");
INSERT INTO mva_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Natu moane teke maka isoaki ‘bereti’ kana kangkang ‘bali’ oti ememaki lima be ika kana rua idokidoki. Ata nge masa tamoata ira dakang? Dikoko-tina ma!” ");
INSERT INTO mva_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Be Iesus itaguraki be bokai iradi, “Kamaradi be dasoakiria.” Makara nge siresire iauia ono soakinga ieno. Bokaibe tamoata be aine moarunga disoakiria. Moane-la makara disoaki nge ‘5,000’ moarunga. ");
INSERT INTO mva_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kodeka Iesus ‘bereti’ idoki be Nanaranga iperui be tamoata be aine makara disoaki nge inegedi. Alauri nge ika bokai ibasaki. ‘Bereti’ be ika inege be moarunga nge rerengadia-lo iandi nibe diboadu-tina. ");
INSERT INTO mva_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Moarunga dimoanako be didoli-tina nge Iesus tagataga ne bokai iradi, “Kangkang enobangadi kamabudinaki. Moaki tabizagam-ba.” ");
INSERT INTO mva_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kodeka tagataga ne ditaguraki be kangkang tamoata be aine dimoanako be dimuleaki nge dibudinaki be raba kanabibia kulemoa-be-rua diau. ‘Bereti’ lima ane ka kangkang ngae emaka ipura be tamoata be aine dimoanako, ata zongzong-la ieno-ba. ");
INSERT INTO mva_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Tamoata be aine makara disoaki Iesus kilala kaiboangi ngae iemaki be dite nge bokai dipile, “Moimoina-tina ngai ka ‘Propet’ makare kateka-o ngapura kana!” ");
INSERT INTO mva_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Makara nge Iesus ikaua tamoata be aine ngaedi ambe damai be dadoki-repeki be tago rerengana-lo be anuatanepoa kandi bokana danangai kana. Bokaibe rubena-ba be buku kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ambe rairaituka nge Iesus tagataga ne ditaolako dang biabia ara Galili-lo. ");
INSERT INTO mva_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kodeka kati rebareba-o dibuli be Kaperneam dalako kana. Ambe irodo, ata Iesus tago isi ipurakadi. ");
INSERT INTO mva_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Oasa ambe ikai be dang ambe ikauborua-ramo. ");
INSERT INTO mva_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iesus tagataga ne nge diore be ambe dang lukangana-o direbareba noko Iesus dang kusi-nao ialale be taonadi itaotao be dite. Dite nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kodeka Iesus bokai ipile, “Taburi-ming moaki dira! Ngena ngau.” ");
INSERT INTO mva_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Makara nge direre-tina Iesus kati-o dasalangaki kana, ata ambe oaikiki-tina kaba odio dilakolako-lo ditoka. ");
INSERT INTO mva_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Izama nge tamoata be aine dum biabia dang biabia Galili ege takaianao disoaki be perekadi dipura nge kaba bokai dita kati rebareba tekena-la ka makara ieno. Di dikaua Iesus tago kati ono tagataga ne dialale-o ibuli. Tagataga ne nge rubediaba ka dialale. ");
INSERT INTO mva_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kodeka kati takadi Taibirias-lonalona nge makara dipura be kaba odio tamoata be aine Tanepoa ‘bereti’ iperutaki be dikang kana nge saringadi ditoka. ");
INSERT INTO mva_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tamoata be aine kaba bokai dita Iesus ki tagataga ne tago makara disoaki nge kati-o dibuli be Kaperneam-lo Iesus dalelei kana be dilako. ");
INSERT INTO mva_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bong tamoata be aine dang biabia ditotoki be ege takaianao dilako be Iesus dite nge bokai ditegi, “‘Tisa,’ aira be makare kupura?” ");
INSERT INTO mva_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Be Iesus ikatu be bokai ipile, “Moimoi ka ura-kaming! Nge tago kilala kaiboangdi uemaki kaita be labudi kakauataki ka kaleleleia. Tago! Ngena uakolang-kaming be kadoli-tina ka kaleleleia! ");
INSERT INTO mva_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moaki kangkang maka digoalagoala kanabe kamalipilipi. Moaki. Kangkang ono moauriuri-la nem-kusoaki soaki ipurapura kanabe kamamalipilipi. Kangkang bokainaina masa Tamoata Natu ngang-kaming. Tamoata Natu-o ka Nanaranga kilala ne ono kauataka nge inangai, be labu ngaenao ka inepi be makare kateka-o ipura.” ");
INSERT INTO mva_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kodeka bokai ditegi, “Rakana gaemaki be masa Nanaranga malipi ne gaememaki?” ");
INSERT INTO mva_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Be Iesus ikatu be bokai ipile, “Nanaranga malipi ne nge bokai: Tamoata maka inepi be makare ipura nge lama kamaunani.” ");
INSERT INTO mva_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Be di kaba ditegi, “Kilala kaiboangi nangata masa goemaki be gate be lama gauni? Masa rakana goemaki? ");
INSERT INTO mva_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tubuma toira kangkang ara ‘mana’ nge lulu kaba-lo dikang, Nanaranga-la ‘Buku’ ne ipile bokana. Nanaranga ‘Buku’ ne bokai ipile, ‘Kangkang lang anua-lonalona iandi be dikang.’” ");
INSERT INTO mva_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Be Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming. Kangkang Moses toira tubu-ming iandi nge tago kangkang lang anua-lo ka ibala. Tago! Ata kangkang maka Tamagu iang-kaming nge ka kangkang kalingo be lang anua-lo be ibala. ");
INSERT INTO mva_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Maka ma Nanaranga kangkang ne nge tamoata lang anua-lo be ibala. Be ngai ka tamoata be aine kateka ngaenao ono moauringa ianiandi.” ");
INSERT INTO mva_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Be di bokai dipile, “Biabiadi, kangkang ngae izamaizama goaniang-kama.” ");
INSERT INTO mva_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Makara nge Iesus bokai iradi, “Ngau ka kangkang ngae gokangkang be moauriuri-la gosukoaki! Tamoata naita ngau-lo imai nge tagona-tina iboadu tole ngamate. Be tamoata naita ngau lama iunana nge tagona-tina iboadu madole ngamate. ");
INSERT INTO mva_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ata ambe urakaming-doi. Katea, ata lama tago kaunana! ");
INSERT INTO mva_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tama-gu ka itaguraki be tamoata nangata idoki be ngau iana masa tamoata ngae ngau-lo ngamai. Bokaibe tamoata naita ngau-lo imai nge tagona-tina iboadu mtaoni be ngalale. ");
INSERT INTO mva_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Maka ma ngau lang anua-lo be makare ubala nge tago rerengagu ka mtagadi kana ka ubala. Tago-tina. Nepinepi negu rerengana mtagadi kana ka makare ubala. ");
INSERT INTO mva_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nepinepi negu rerenga bokai dieno: Tamoata be aine ngau iana nge moakina-tina teke ileua. Moaki-tina. Tamoata be aine ngau iana nge moarunga marangakidi be bong alalaurituka-o nge moauriuri-la dasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bakara, Tamagu rerenga nge bokai: Tamoata moarunga Natu dite be lama diunani nge moauriuri-la nem-kusoaki dasukoaki. Bokai masa bong alalauritukao marangakidi be moauriuri-la dasukoaki.” ");
INSERT INTO mva_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iesus bokai ipile, “Ngau ka kangkang ngae lang anua-lo be ubala,” nge Iuda tamoata ditaguraki be digulungaetaki. ");
INSERT INTO mva_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Be bokai dipile, “Tamoata ngae ka Iesus, Iosep natu ki taila? Tama be tina takauatakidi! Nge bakara be bokai ipile lang anua-lo be ibala?” ");
INSERT INTO mva_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Be Iesus ikatu be bokai iradi, “Moaki makara neming-la mara-ming kagulungaengae! ");
INSERT INTO mva_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tamoata tago teke iboadu rerenganaba-lo be ngau-lo ngamai. Tago-tina! Tamagu inepia be makare upura ka ngarepeki be masa ngau-lo ngamai. Tago irepeki nge tago ngamai. Be bong alalaurituka-o masa ngau marangaki be moauriuri-la ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘Propet’ bokai digere, ‘Tamoata moarunga masa Nanaranga ngasuledi.’ Bokaibe tamoata naita Tama-gu ilongori be sule ne idoki be ikaua masa ngau-lo ngamai. ");
INSERT INTO mva_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ata nge tago bokai upile tamoata teke ambe Tamagu ite. Tago. Tamoata-la Nanaranga-lo be ipura ka Tama-gu ite. ");
INSERT INTO mva_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Moimoi ka ura-kaming! Tamoata naita lama iuni nge moauriuri-la nem-kusoaki ngasukoaki kana. ");
INSERT INTO mva_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngau ka kangkang gokang be moauriuri-la gosukoaki kana! ");
INSERT INTO mva_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Toira tubu-ming kangkang ara ‘mana’ lulu kaba-lo dikani, ata ambe dimate. ");
INSERT INTO mva_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ata kangkang lang anua-lo be ibala nge bokainaina: Tamoata naita ikani nge tagona-tina iboadu ngamate. ");
INSERT INTO mva_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngau ka kangkang moauriuri-la isukoaki ngae lang anua-lo be ibala. Tamoata naita kangkang ngae ikani nge tagona-tina iboadu ngamate. Masa bokaina-la moauriuri ngasukoaki. Kangkang maka ngau miani kana nge negu tamoata-gu. Tamoata-gu ngae ka tamoata be aine moarunga kateka-o uiandi be ono moauriuri-la dasukoaki kana.” ");
INSERT INTO mva_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Iesus bokai ipile nge Iuda namadi dira-tina be nedia-la maradi bokai diegore, “Masa bakara be tamoata ngae ne tamoata ngang-kita be takani?” ");
INSERT INTO mva_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Bokaibe Iesus bokai iradi, “Moimoi ka ura-kaming! Tamoata Natu ne tamoata tago kakani ki daraka tago kasing nge tagona-tina iboadu ono moauringa ngaeno-kaming. ");
INSERT INTO mva_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tamoata naita tamoata-gu ikani be daraka-gu ising masa nem-kusoaki ngasukoaki, be bong alalaurituka-o masa ngau marangaki be moauriuri ngasoaki. ");
INSERT INTO mva_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Maka ma tamoata-gu nge kangkang-tina, be daraka-gu nge dang-tina singsing. ");
INSERT INTO mva_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tamoata naita tamoata-gu ikani be daraka-gu ising nge ngau-lo isoaki be ngau ngaia-lo usoaki. ");
INSERT INTO mva_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tama-gu moauriuri-la sukoaki ka inepia be ngai kana ka ngau moauriuri usoaki. Bokainatuka-la, tamoata naita ngau ikana masa ngau kanabe moauriuri-la ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kangkang ngae ka lang anua-lo be ibala. Kangkang ngae nge tago kangkang toira tubu-ming dikani be dimate bokana. Tago. Tamoata naita kangkang ngae ikani masa moauriuri-la ngasukoaki. Tago iboadu ngamate.” ");
INSERT INTO mva_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesus pile ngaedi Kaperneam anua-lo be ipile. Pera nedi ono serereinga-lo isulesuledi be ipile. ");
INSERT INTO mva_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pile bokainaina dilongo nge tagataga ne kokoko-tina bokai dipile, “Sule ngaedi nge dikaiboang-tina! Masa naita sule bokainaina ngadoki?” ");
INSERT INTO mva_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ata Iesus ikaua rakana kata ka tagataga ne digulungaengaetaki. Bokaibe bokai iradi, “Pile ngaedi dilo-sururu-kaming ki? ");
INSERT INTO mva_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ak, Tamoata Natu matamata isoaki kanana-lo ngakaukautaki be kamate masa bakara? ");
INSERT INTO mva_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bokai kamakaua: Oli Spirit ka ono moauriuri soakinga tamoata ianiandi. Tamoata-ming nge kanaba. Bokaibe pile ngaedi ura-kaming nge Oli Spirit ne, be ono moauringa odio dieno. ");
INSERT INTO mva_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ata kam alu nge lama tago diuni.” Iesus bokai ipile, bakara, matamatana-la be Iesus ikaua tagataga ne nangatadi masa lama tago dauni, be naita masa ngadoki be erekei ne luma-dio nganangai. ");
INSERT INTO mva_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Bokaibe kaba bokai iradi, “Labu ngaenao ka bokai ura-kaming: Tamoata tago teke iboadu ngau-lo ngamai. Tago-la. Tama-gu isumoalani ka iboadu ngau-lo ngamai. Tago be tago!” ");
INSERT INTO mva_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Bokaibe tagataga ne kokoko-tina dipereki be dialale, be kaba alauri nge tago ditagatagai. ");
INSERT INTO mva_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kodeka Iesus tagataga ne kulemoa-be-rua itegidi, “Be kam? Kamapereka kana karere ki?” ");
INSERT INTO mva_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Be Saimon Pita ikatu be bokai irai, “Tanepoa, masa naitai-lo galako? Moauriuri-la nem-kusoaki soaki ipurapura nge pilengam-lo ka ieno. ");
INSERT INTO mva_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Keka lama kiuni be kikaua kaiko Kusim Rata, be kaiko nge Nanaranga tamoata ne.” ");
INSERT INTO mva_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kodeka Iesus bokai iradi, “Ngau ka kam kulemoa-be-rua udoki-kaming be unanga-kaming. Ata teke mara-ming nge Satang!” ");
INSERT INTO mva_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nge bokai ipile nge Iudas, Saimon Iskariot natu ka irangaki. Iudas nge Iesus tagataga ne kulemoa-be-rua kata, ata alauri masa Iesus ngadoki be erekei luma-dio nganangai. ");
INSERT INTO mva_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kana ngaedi muridi nge Iesus ege-ege Galili kaba-lo ialale. Iuda tamoata nedi bibia nge daumoatei kana. Bokaibe Zudea kaba nge imoangi be isibongaki-tina. ");
INSERT INTO mva_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ata bong Iuda moanako nedi biabia teke ono bazarua ngado kusi-lo ememaki dirakerakeaki isaringa nge ");
INSERT INTO mva_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesus taritoka bokai dirai, “Kaba ngaedi gopereki be Zudea kaba-lo golako be tagataga nem moarunga masa kana kuememaki daita. ");
INSERT INTO mva_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tamoata naita irere moarunga dakauataki kana nge kana iememaki tago iboadu ngazumkaki. Kaiko ambe kana ngaedi kuememaki. Bokaibe nem-la be mangata gonangaiko be tamoata be aine moarunga kateka-o dakauatakiko!” ");
INSERT INTO mva_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iesus taritokana-tina nge lama tago diuni. Nge bokai ka pile ngaedi dipile. ");
INSERT INTO mva_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Bokaibe Iesus itaguraki be bokai iradi, “Bong-tina negu isi tago dipura. Bong moarunga nge kam bong uia neming. ");
INSERT INTO mva_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tamoata be aine moarunga kateka-o tago iboadu dasegeaki-kaming. Ata ngau masa dasegeaka. Maka ma ngau mangata bokai upilepile kana moarunga diememaki nge muzi goalakadi odio dieno. ");
INSERT INTO mva_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kam Moanako biabia ngaena-lo kamalako. Ngau bong-tina negu isi tago dipura. Bokaibe tago iboadu Moanako biabia ngaena-lo mlako.” ");
INSERT INTO mva_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Bokai ipile be makarana-la Galili kaba-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iesus taritoka Moanako biabia ngaena-lo dilako muridi nge Iesus nena-la be itui be Moanako biabia ngaena-lo ilako. Ata tago mangata ilako. Komangaba-lo be ilako. ");
INSERT INTO mva_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Moanako biabia ngaena-lo nge Iuda tamoata be aine Iesus dilelelei be bokai ditegitegiaki, “Tamoata ngae inanga isoaki?” ");
INSERT INTO mva_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tamoata be aine moarunga nge nedia-la Iesus dimalonga-sikisikitaki. Alu bokai dipile, “Ngai tamoata iauia.” Takadi dikatu be bokai dipile, “Tago! Ngai tamoata ibobolesidi.” ");
INSERT INTO mva_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ata tago teke mangata lili-be-matao irangaki, bakara, moarunga nge Iuda tamoata nedi bibia dimatakuridi. ");
INSERT INTO mva_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Bong Moanako bibia ngae lukangana-tinao kodeka Iesus ilako Nanaranga pera nena-lo be tamoata be aine isuledi. ");
INSERT INTO mva_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iuda dilongori nge dipitilaki-tina be bokai dipile, “Tamoata ngae tago sule bibia-lo ilako, ata bakara be kauanga dilaba-tina!” ");
INSERT INTO mva_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Be Iesus ikatu be bokai iradi, “Sule ngau usulesule-kaming nge tago negu. Sule ngaedi nge Nanaranga ne. Ngai ka inepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tamoata naita irere Nanaranga rerenga ngatagadi kana nge masa ngakaua sule usulesule-kaming ngaedi nge Nanaranga-lo ka dipura ki negu kaiboang negu-lo ka usulesuletaki. ");
INSERT INTO mva_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tamoata nena-la kaiboang nena-lo isulesule nge nena-la ara biabia ngadoki kana ka isulesule. Ata tamoata naita nepinepi ara atabala nganangai kana be imalipilipi nge pilenga moimoi be kalingodi, be boli mata tago teke ono ieno. ");
INSERT INTO mva_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses ka toira Mata ne iang-kaming. Ata kam tagona-tina Mata bibia ngaedi katagatagadi. Tago-la. Nge bakara ka kamaumoatea kana?” ");
INSERT INTO mva_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Be di dikatu be bokai dipile, “Nge mariaba goalaka kata ibagabagaiko! Naita ngaumoateiko kana?” ");
INSERT INTO mva_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Be Iesus bokai iradi, “Kilala kaiboangdi teke memaki nge kamapitilaki be kamakabaka. ");
INSERT INTO mva_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses ira-kaming be natu-ming moane kusidi kakorotototo ngena (tago Moses-tina ka ira-kaming, tubu-ming bibia ka dira-kaming) kataguraki be bong ono manauanga ‘Sabat’-o natu-ming moane kusidi kakorotototo. ");
INSERT INTO mva_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ak, ono-ba Moses Mata ne gamanadi kamasibongaki kana nge ‘Sabat’-o natu-ming moane kusidi kakorotototo. Ata ngau ‘Sabat’-o tamoata teke ere-moarunga be uadoraki nge bakara ka nama-ming dirataka? ");
INSERT INTO mva_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Moaki kana atabalangadia-ba kaitaita be kadoadoraki. Muzi adoado kamatagatagadi be kana kamaitaita be kamadoadoraki!” ");
INSERT INTO mva_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Makara nge Ierusalem tamoata alu bokai ditegitegi, “Tamoata ngae ki nangata ka daumoatei kana? ");
INSERT INTO mva_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kamate! Ambe lili-be-matao ipilepile, ata tago teke bakara irai! Iuda tamoata bibia masa ambe dipile ngai ka Kristus! ");
INSERT INTO mva_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ata kita ambe takaua ngai inanga tamoata kata! Maka ma bong Kristus ngapura nge tamoata tago teke ngakaua ngai inanga kata.” ");
INSERT INTO mva_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesus nge isi Nanaranga pera nena-lo isoaki be isulesule nge kaikai-la bokai ipile, “Kam moimoi be kakauataka ki? Be inanga ka upura nge kakaua-ma? Ata tago negu rerengagu-lo ka makare upura. Tago-tina. Nepinepi negu ka inepia be makare upura. Be ngai moimoi be kalingo. Kam tago kakauataki, ");
INSERT INTO mva_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ata ngau ukauataki. Bakara, ngau ngaia-lo ka upura be ngai ka inepia be makare upura.” ");
INSERT INTO mva_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Makara nge ditaguraki be dadokimatei be dauauri kana. Ata bong-tina ne isi tago dipura. Bokaibe tamoata tago teke itaguraki be luma Iesus-o inanga be idokimatei. ");
INSERT INTO mva_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ata tamoata be aine kokoko-tina Iesus lama diunani. Be bokai dipile, “Tamoata ngae kilala kaiboangdi kokoko-tina iemaki. Bong Kristus ngapura masa kilala kaiboangdi nangatadi tamoata ngae tago iboadu ngaemaki nge ngaememaki?” ");
INSERT INTO mva_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tamoata be aine moarunga nge pile bokainaina ane be Iesus dimalonga-sikisikitaki be Parasi dilongo. Bokaibe tamoata Nanaranga ditabatabai dimuamuadi zaiza be ditaguraki be tamoata Nanaranga pera ne dinarinaringi nge dinepidi be Iesus dauauri kana. ");
INSERT INTO mva_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Makara nge Iesus bokai ipile, “Uanana tago sasalaga masa mara-ming msoaki be kaba nepinepi negu inepia be makare upura-lo mlako. ");
INSERT INTO mva_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kaba ngau odio msoaki kanana-lo nge kam tago kaboadu kamalako. Bokaibe, masa kamalelelea, ata tago kamatea.” ");
INSERT INTO mva_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Makara nge Iuda tamoata nedi bibia nedia-la bokai dipile, “Masa kaba nangatadia-lo ngalako be kita tago taboadu tate? Masa Gris kaba-lo ngalako be Iuda makara disoaki-lo ngalako, be Gris tamoata be aine ngasuledi kana? ");
INSERT INTO mva_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nge masa baituka ipile masa kamalelea, ata tago kamatea, be pile takadi ipile kaba odio ngalako kana nge kita tago taboadu talako?” ");
INSERT INTO mva_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Bong alalaurituka Moanako biabia ngaena-lo nge ara biabiatuka. Bokaibe bong alalaurituka ngaenao nge Iesus ituirake be bokainatuka ipi be ipile, “Tamoata naita madole imate nge ngau-lo ngamai be dang ngasing! ");
INSERT INTO mva_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nanaranga-la ‘Buku’ ne ipile bokana, ‘Tamoata naita lama iunana masa dang papanana ono moauringa ilona-lo be ngapapanana be ngapusikasika.’” ");
INSERT INTO mva_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesus bokai ipile nge Oli Spirit ka irangaki. Tamoata naita Iesus lama iunani masa alauri Oli Spirit ngabalani. Imai be bong ngaradia-lo nge Oli Spirit isi tago ibala, bakara, Iesus isi tago mate-lo be marangaka ipura be ara bibia idoki. ");
INSERT INTO mva_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tamoata be aine moarunga pilenga dilongo nge aludi bokai dipile, “Moimoina-tina ngai ka ‘Propet’ ngae!” ");
INSERT INTO mva_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Takadi bokai dipile, “Ngai ka Kristus!” Ata takadi bokai dipile, “Kristus tago masa Galili kaba-lo be ngapura! Tago. ");
INSERT INTO mva_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nanaranga ‘Buku’ nena-lo bokai dieno: Kristus nge Debiti tubu ne kata, be masa Betlem anua-lo be nekiaka ngapura. Anua Betlem nge toira Debiti ono isukoaki.” ");
INSERT INTO mva_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Makara nge Iesus kanabe tamoata be aine nge dienegei-ramo. ");
INSERT INTO mva_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Moimoi aludi dauauri kana, ata tago teke itaguraki be luma ono inanga. ");
INSERT INTO mva_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bong tamoata Nanaranga pera ne dinarinaringi dimule nge tamoata Nanaranga ditabatabai dimuamuadi be Parasi ditaguraki be bokai ditegidi, “Bakara ka tago kabagai be kapura?” ");
INSERT INTO mva_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Be tamoata Nanaranga pera ne dinarinaringi dikatu be bokai dipile, “Toira be imai tamoata tago teke tamoata ngae ipilepile bokana ipile!” ");
INSERT INTO mva_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kodeka Parasi bokai dipile, “Masa ambe irepeki-kaming be iaka-boang-kaming ki? ");
INSERT INTO mva_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kaba kamaita! Parasi ki Iuda tamoata nedi bibia tago teke irepeki be iaka-boangi! Tago-tina! ");
INSERT INTO mva_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tamoata be aine moarunga ngaedi nge Moses Mata ne tago dikauataki. Bokaibe, nge ambe Nanaranga ngesuaki ne eruma ka disoaki!” ");
INSERT INTO mva_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas nge di kata. Ngai ka norane be ilako be Iesus ite. Kodeka Nikodimas itaguraki be bokai iradi, ");
INSERT INTO mva_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mata neda dipile tamoata talongori be takaua rakana ka iememaki noko giriki ne taliliti be tarokaki!” ");
INSERT INTO mva_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Be di dikatu be bokai dipile, “Kaiko masa Galili tamoata kata? Nanaranga ‘Buku’ ne goleze uia masa gokaua ‘propet’ tago teke Galili kaba-lo ipura!”  ");
INSERT INTO mva_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kodeka makara be kaba kanam-kanam dilako. ");
INSERT INTO mva_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ata Iesus buku ara Olib-o ilako be makara isoaki. ");
INSERT INTO mva_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Izama nge oabuna-tina be Nanaranga pera nena-lo ilako. Tamoata be aine kokoko-tina dipura be diboalingi, be isoakiria be isuledi. ");
INSERT INTO mva_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tamoata Moses Mata ne disulesuletaki be Parasi ditaguraki be aine teke dieluaki be tamoata be aine moarunga maradi dituiraki. Aine nge roti igamani be moane takaia diaru dieno-buduru be dite ka dieluaki. ");
INSERT INTO mva_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Kodeka ditaguraki be Iesus bokai dirai, “‘Tisa,’ aine ngae moane takaia diaru dieno-buduru be kite. ");
INSERT INTO mva_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mata neda Moses iang-kita bokai ipile aine bokainaina nge patu ane unia ngapura be ngamate. Ak, kaiko bakara ilom ipile?” ");
INSERT INTO mva_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nge ono datoi be pile ngapakadi be labu nedi teke ngapuradi be ono giriki ono danangalako kana ka bokai ditegi. Ata Iesus iboadukuria be kabo tudu ane be kateka-o igeregere. ");
INSERT INTO mva_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ditegitegia-la bokana ipoagarake be bokai iradi, “Tamoata naita muzigoala tago teke kuemaki nge matamatanatuka patu godoki be aine ngae ono gouni!” ");
INSERT INTO mva_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Be kaba iboadukuria be kateka-o igeregere. ");
INSERT INTO mva_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pile bokai dilongo nge teke-teke nem be alale dipuraki. Matamata kamoangbibia dialale, alauri nge takadi dialale. Dialale-doi be Iesus-la rube isoaki, be aine ngae isi bokaina-la ituitui. ");
INSERT INTO mva_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kodeka Iesus ipoagarake be aine ngae bokai irai, “Aine, tamoata ngaedi inanga disoaki? Tago teke isoaki be giriki omo nganangalako kana ki?” ");
INSERT INTO mva_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Be aine ngae ikatu be bokai ipile, “Biabiadi, tago teke isoaki.” Be Iesus bokai ipile, “E, ngau bokai. Tago iboadu giriki omo mnangalako! Goalale, ata moaki kaba muzigoala kuememaki!” ");
INSERT INTO mva_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kodeka Iesus kababe tamoata be aine bokai iradi, “Ngau ka kateka ngae malama ne! Tamoata naita malama ngae itagai nge tagona-tina iboadu malama tagotago ngalale. Tago-la! Ngau masa malama ono moauringa miani.” ");
INSERT INTO mva_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Makara nge Parasi ditaguraki be bokai dirai, “Nge ambe nem-la be nem murim kutui be mangata kurangarangakiko. Bokaibe kana nem-la ono mangata kurangarangakiko nge kalingodi tagotago.” ");
INSERT INTO mva_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Be Iesus ikatu be bokai iradi, “Tago iboadu! Ngau negu-la murigu utui be negu-la mangata urangaka nge pilengagu ono mangata urangaka nge kalingodi. Bakara, ngau negu-la ukaua inanga ka upura, be ukaua inanga mlako kana. Ata kam tago kakaua inanga ka upura be inanga mlako kana. ");
INSERT INTO mva_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kam tamoata mata nedi katagatagadi be tamoata takadi giriki nedi kalililiti. Ata ngau tamoata tago teke giriki ne uliliti. Tago-tina. ");
INSERT INTO mva_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ngau tamoata giriki nedi mlililiti bokana nge ambe giriki lilitangagu dado-tina. Bakara, ngau tago rubegu-ba ka utui be kana moarunga uememaki. Tago. Tama-gu inepia be makare upura keru be kana moarunga uememaki. ");
INSERT INTO mva_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Kam mata neming Moses iangkaming-lo nge bokainatuka dieno: Tamoata rua pile tekedi mangata dirangakiru nge pilenga-diaru ngaedi nge kalingodi. ");
INSERT INTO mva_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Bokaibe nge tago ngau-la ka negu mangata urangarangaka. Tago. Takaia murigu itui be mangata irangarangaka nge Tama-gu. Ngai ka inepia be makare upura!” ");
INSERT INTO mva_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kodeka bokai ditegi, “Tamam goitiking-kama, inanga isoaki?” Be Iesus ikatu be bokai ipile, “Kam tago kakauataka, bokaibe Tamagu tago kakauataki! Kamakauataka bokana nge ambe Tama-gu kamakauataki.” ");
INSERT INTO mva_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesus pile ngaedi nge Nanaranga pera nena-lo, ege ono ‘mone’ budinakadi dipurapura kanana-lo be ipile. Ata tamoata tago teke itaguraki be iuauri. Maka ma bong-tina ne ono matenga isi tago dipura. ");
INSERT INTO mva_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Be Iesus kaba bokai iradi, “Ngau masa mialale be mpereki-kaming. Be kam masa kamalelea. Ata masa muzigoala neming-lo be kamamate. Kam tago kaboadu kaba ngau odio mlako kanana-lo kamalako.” ");
INSERT INTO mva_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bokai ipile nge Iuda tamoata bokai dipile, “Bakara be bokai ipile, ‘Kam tago kaboadu kaba ngau odio mlako kanana-lo kamalako’? Masa nena-la ngaumoatei kana ki?” ");
INSERT INTO mva_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Be Iesus ikatu be bokai iradi, “Kam nge makare erumaruma kaoa. Ata ngau nge etatabalabala kata. Kam nge makare kateka ngaena-onaona kaoa. Ata ngau tago kateka ngaena-onaona kata. ");
INSERT INTO mva_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nge bokai ka ura-kaming masa muzigoala neming-lo be kamamate. Lama tago kauni ‘Ngau nge Ngai’ nge moimoina-tina muzigoala neming-lo be kamamate kana!” ");
INSERT INTO mva_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Be di ditegi, “Kaiko naita kata?” Be Iesus ikatu be bokai iradi, “Ngau naita kata nge matamatana-la be urara-kaming nibe imai-ba be kaituka. ");
INSERT INTO mva_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kana kokoko-tina dieno mrangaki-kaming be ono giriki omingo mnangalako kana. Ata Nanaranga inepia be makare upura nge pilenga kalingodi. Bokaibe pile moarunga ngaia-lo ulongo nge tamoata be aine moarunga kateka-o uradi.” ");
INSERT INTO mva_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ata di tago dikaua nge Tama ka irangarangaki. ");
INSERT INTO mva_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Bokaibe Iesus bokai ipile, “Alauri masa Tamoata Natu etatabala kamadokitetekalako. Bong ngaranao masa kamakaua ‘Ngau nge Ngai.’ Be masa kamakaua kana tago teke ngau negu rerengagu-lo be uememaki. Tago-tina. Pile moarunga upilepile nge Tama-gu ka isikengna. ");
INSERT INTO mva_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bokaibe nepinepi negu nge sakegulanao isukoaki. Be kana moarunga uememaki nge rerengana-lo ka uememaki. Bokai ka tago ipereka be rubegu-ba usoaki.” ");
INSERT INTO mva_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tamoata be aine pile ngaedi dilongo nge kokoko-tina Iesus lama diunani. ");
INSERT INTO mva_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iuda tamoata be aine Iesus lama diunani nge bokai iradi, “Sulengagu kadoki be katagatagadi nge kam moimoi be tagataga negu. ");
INSERT INTO mva_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Bokai masa pile kalingo ngae nge kamakauataki. Be pile kalingo ngae ka ngarubetaki-kaming be adoado kamasoaki kana.” ");
INSERT INTO mva_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Be di dikatu be bokai dipile, “Keka Abaram tubu. Bong tago tekedio keka tamoata takaia dududu ne bokana kisoaki. Tago-la. Nge bakara ka bokai kupile, ‘Masa mrubetaki-kaming be adoado kamasoaki?’” ");
INSERT INTO mva_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Kodeka Iesus bokai iradi, “Moimoi ka ura-kaming! Tamoata moarunga muzigoala diemaki nge muzigoala iuauridi, be ambe muzigoala dududu kana bokana ka disoaki. ");
INSERT INTO mva_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bokai mtonanga be kamakaua: Tamoata dududu kata ka ilako be tamoata teke roa be natu zaiza disukoaki-budu nge tago kaba-tina kanana-lo ka isukoaki. Nge idaudau-ba. Ata tamoata pera-marau natu moaneka nge kaba-marau. Bokaibe masa makarana-la ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Bokainatuka-la, muzigoala ka diuauriko be Nanaranga Natu irubetakiko nge ambe moimoibe rubetakam-tina uia ipura. Tago ambe muzigoala uaura nena-lo ka kusoaki. ");
INSERT INTO mva_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ngau ukaua kam Abaram tubu. Ata ilo-minglo nge pilengagu kabadi tago! Bokai ka kamaumoatea kana! ");
INSERT INTO mva_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngau kana urarangaki nge Tama-gu ne matanao be itikina ka urarangaki. Be bokainatuka-la, kam tama-ming kana dirangaki-kaming ka kaememaki.” ");
INSERT INTO mva_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Makara nge bokai dipile, “Abaram nge keka tubuma!” Be Iesus bokai ipile, “Kam moimoi Abaram tubu nge ambe malipi ngai iemaki nge kamaememaki. Ata nge tago! ");
INSERT INTO mva_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngau giriki tago teke uemaki. Kana moarunga moimoi be kalingodi Nanaranga irangakina ka urangaki-kaming. Ata kam ambe kamaumoatea kana. Bokai kamakaua: Abaram kana bokainaina ngau uememaki bokana nge tago teke iemaki. ");
INSERT INTO mva_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kam kana kaememaki nge tama-ming iemaki ka kaememaki.” Makara nge ditaguraki be bokai dirai, “Keka tago numnum ka kidula! Tago. Nanaranga-la ka Tama-ma, be keka nge natuna-tina.” ");
INSERT INTO mva_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kodeka Iesus bokai iradi, “Nanaranga moimoi be tama-ming nge ambe kamareretaka. Bakara, ngau Nanaranga-lo ka upura be ambe makare usoaki. Ngau tago negu rerengagu-lo ka upura. Tago. Nanaranga ka inepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bakara ka pile ngau upilepile nge labudi tago kakauataki? Labu neming ono pilengagu labudi tago kakauataki nge bokai: Pilengagu tagona-tina kalongo! ");
INSERT INTO mva_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kam nge tama-ming Satang natu! Bokai ka tama-ming rerenga kamatagadi kana, be rerenga ngaedi nge kamaemaki be dakalingo kana. Matamatana-la be imai nge ngai tamoata kangkang kata. Be mata kalingodi nge tago sesu itagadi, bakara, mata kalingodi nge tago teke ngaia-lo ieno. Be bong boli-pile ipilepile nge pile-tina ne ka ipilepile. Maka ma ngai bolinga ratadi be ngai ka boli moarunga tamadi. ");
INSERT INTO mva_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ngau pile kalingodi ka upilepile. Nge bokai ka lama tago kaunana. ");
INSERT INTO mva_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kam kapile ngau muzigoala uemaki! Moimoi be muzigoala teke uemaki nge tekem mangata gonangai be tate! Pile kalingodi ka upilepile nge bakara ka tago lama kaunana? ");
INSERT INTO mva_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tamoata naita Nanaranga-lo ka ipura nge Nanaranga pilenga ilongolongo. Labu ono pilengagu tago kalongolongo nge bokai: Kam tago Nanaranga-lo ka kapura.” ");
INSERT INTO mva_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Kodeka Iuda ditaguraki be Iesus bokai dirai, “Moimoi ka bokai kirangakiko: Kaiko Samaria kata be mariaba goalaka kata ibagabagaiko!” ");
INSERT INTO mva_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Be Iesus ikatu be bokai ipile, “Mariaba goalaka tago teke ibagabagaia. Ngau Tama-gu umuamuakia-tina, ata kam ngau kabalabalakau-tina! ");
INSERT INTO mva_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngau tago negu aragu atabala mnangai kana ka bokai umuzimuzi. Tago-la! Tama-gu ka ara atabala mnangai kana irere. Be ngai ka tamoata be aine kateka-o giriki nedi ngaliliti be ngadoraki kana. ");
INSERT INTO mva_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Moimoi ka ura-kaming. Tamoata naita pilengagu itagatagadi nge tagona-tina iboadu mate bubuna ngate!” ");
INSERT INTO mva_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Makara nge Iuda ditaguraki be bokai dirai, “Kodeka kikaua kaiko moimoi be mariaba goalaka ibagabagaiko! Maka ma Abaram be ‘propet’ dimate, ata kaiko kupile tamoata pilengam itagatagadi nge tagona-tina mate bubuna ngate. ");
INSERT INTO mva_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kaiko nem-la kurangakiko kaiko tubuma Abaram kuasai ki? Ngai imate, be bokainatuka-la, ‘propet’ moarunga nge dimate-doi! Kaiko naita kata ka bokai kupile?” ");
INSERT INTO mva_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Be Iesus ikatu be bokai iradi, “Ngau negu-la be aragu atabala mnangai kana nge negu aragu nge kana-ba. Ata nge tago bokai. Tamagu-ma kam kapile Nanaranga neming ka aragu atabala nganangai kana. ");
INSERT INTO mva_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kam tago kakauataki. Ngau ukauataki. Tago ukauataki kana upile nge ngau boliboli-tina, kam-la bokana! Ata ngau ukauataki be pilenga ulongolongo be utagatagadi. ");
INSERT INTO mva_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tubu-ming Abaram irere-tina ngau purangagu ngaita kan. Be ambe ita be suri diuiani.” ");
INSERT INTO mva_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Iesus bokai ipile nge Iuda bokai dipile, “Kaiko isi barasi nem tago kulemoadi-lima diuasadi! Nge bakara be Abaram kute?” ");
INSERT INTO mva_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Be Iesus ikatu be bokai iradi, “Moimoi ka ura-kaming! Abaram isi tago ipura be ‘Ngau-ma’ nge usoaki!” ");
INSERT INTO mva_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bokaibe Iuda ditaguraki be patu ane dauni kana, ata Iesus maradi ikoma-lako be aboabolana-ba be Nanaranga pera ne ipereki be eluku ilako. ");
INSERT INTO mva_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iesus bokai ialalale nge tamoata teke mata leuadi ite. Tamoata ngae nge mata leuadi be tina inekiaki. ");
INSERT INTO mva_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kodeka tagataga ne ditaguraki be bokai ditegi, “‘Tisa,’ naita muzigoala ne lilidi-o ka tamoata ngae mata leuadi be tina inekiaki? Ne muzigoala ne lilidi-o, ki tina be tama muzigoala nedi lilidi-o?” ");
INSERT INTO mva_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Be Iesus ikatu be bokai ipile, “Nge tago ne muzigoala ne lilidi-o ki tina be tama muzigoala nedi lilidi-o. Tago. Nge ono Nanaranga kaiboang ne mangata tamoata ngaenao damalipi be teadi dapura kana ka mata leuadi be tina inekiaki. ");
INSERT INTO mva_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Amari isi ieno nge nepinepi negu malipi ne taememaki. Oabubu ambe imaimai, be bong ngaranao masa tago teke iboadu ngamalipi. ");
INSERT INTO mva_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bong ngau kateka ngaenao usoaki nge ngau kateka ngae malama ne.” ");
INSERT INTO mva_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Bokai ipile, kodeka kateka-o imoangoria be kateka-poasa iemaki, be kateka-poasa ngae idoki be tamoata mata leuadi mata-nao inanga. ");
INSERT INTO mva_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Be bokai irai, “Goalale be dang boakuboaku ara Siloam-lo lilim goasaki!” Kita ara Siloam tabuiri nge bokai tapile, “Nepi.” Bokaibe tamoata mata leuadi ialale be lili iasaki. Lili iasaki nge mata diuiani be kaba itaita be imule. ");
INSERT INTO mva_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tamoata ngae anua-budu-ruanga be tamoata takadi norane be ‘mone’ be kana takadi tamoata takadia-lo isinaunau be dite nge bokai dipile, “Tamoata ngae ki taila ka norane be ‘mone’ be kana takadi tamoata takadia-lo isinaunau?” ");
INSERT INTO mva_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Alu bokai dipile, “Ngaia-ma!” Ata alu bokai dipile, “Tago. Tea ka ngai bokana!” Bokaibe tamoata ngae bokai ipile, “Ngau-ma!” ");
INSERT INTO mva_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kodeka ditaguraki be bokai ditegi, “Baituka be matam diuia be kaba kuitaita?” ");
INSERT INTO mva_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Be ngai ikatu be bokai ipile, “Tamoata ara Iesus kateka-poasa iemaki be matagu-o inanga be bokai iraia, ‘Goalale be Siloam dang-lo lilim goasaki.’ Be ngau ualale be liligu uasaki nge oaikiki-tina kaba uitaita.” ");
INSERT INTO mva_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Kodeka tamoata ngaedi bokai ditegi, “Tamoata ngae inanga isoaki?” Be ngai ikatu be bokai ipile, “Tago ukaua.” ");
INSERT INTO mva_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kodeka ditaguraki be tamoata mata leuadi adoraka ipura nge didoki be Parasi-lo dilakuaki. ");
INSERT INTO mva_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bong ngara ono Iesus kateka-poasa iemaki be tamoata ngae mata iuasari nge bong ono manauanga ‘Sabat.’ ");
INSERT INTO mva_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bokaibe Parasi kaba tamoata adoraka ipura nge ditegi bakara be mata diuia be kaba itaita. Be tamoata ngae bokai iradi, “Kateka-poasa alu matagu-o inanga be uasaki nge matagu diuia be kaba uitaita.” ");
INSERT INTO mva_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Makara nge Parasi alu bokai dipile, “Tamoata ngae bong ono manauanga ‘Sabat’ mata ne tago itagatagadi. Bokaibe tamoata bokainaina nge tago Nanaranga-lo ka ipura!” Ata takadi bokai dipile, “Tamoata muzigoala ememaki masa bakara be malipi kaiboangdi bokainaina ngaememaki?” Bokaibe Parasi nge Iesus-ba rangakanao nedia-la dienegei be uko rua dipura. ");
INSERT INTO mva_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kodeka Parasi ditaguraki be tamoata ngae kaba bokai ditegi, “Tamoata ngae bakara kurangaki? Kaiko ka matam iusari!” Be tamoata ngae ikatu be bokai iradi, “Ngai ‘propet’ kata.” ");
INSERT INTO mva_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ata Iuda tagona-tina tamoata ngae lama diunani ngai mata leuadi be ambe mata diuia be kaba itaita. Bokaibe tamoata mata adorakadi dipura nge tina be tama dikiladi ");
INSERT INTO mva_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","be bokai ditegi-diaru, “Nge natu-mingru ki? Ngai ka karangakiaru mata leuadi be nekiaka ipura ki? Nge bakara be ambe kaba itaita?” ");
INSERT INTO mva_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Be diaru dikaturu be bokai dipileru, “Keru kikauaru nge natu-mairu, be kikauaru mata leuadi be nekiaka ipura. ");
INSERT INTO mva_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ata bakara be ambe kaba itaita, ki naita ka iadoraki nge keru tago kikauaru. Kamategi. Ngai ambe tamoata biabia kata. Iboadu nena-la be ngapile.” ");
INSERT INTO mva_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tamoata adoraka ipura tina be tama nge Iuda dimatakuridi ka bokai dipile. Maka ma Iuda bokai dipile tamoata naita ipile Iesus ka Kristus masa pera nedi ono serereinga-lo taona ngapura be tago iboadu makara ngasilisili. ");
INSERT INTO mva_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Labu ngaenao ka tina be tama bokai dipile, “Ngai ambe tamoata biabia. Kamategi!” ");
INSERT INTO mva_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Makara nge tamoata mata leuadi be nekiaka ipura nge kaba bong ruaia dikilai be bokai dirai, “Nanaranga ara atabala-tina gonangai, be ne mata-nao be pile tago tototo ane be moimoi be gopile tago iboadu goboli. Keka kikaua tamoata ngae nge muzigoala ememaki kata!” ");
INSERT INTO mva_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ata tamoata ngae bokai ipile, “Ngau tago ukaua tamoata ngae muzigoala ememaki ki tago. Kana teke nge ukaua. Ngau mata-gu leuadi, ata ambe kaba uitaita!” ");
INSERT INTO mva_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Kodeka kaba bokai ditegi, “Bakara ibasakiko? Bakara be matam iuasari?” ");
INSERT INTO mva_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Be tamoata ngae ikatu be bokai iradi, “Ambe urakaming-doi, ata kam longo kasege! Bakara ka kaba kamalongo kana? Tagataga ne kamapura kana ka kategitegi ki?” ");
INSERT INTO mva_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Makara nge ditaguraki be diebuloni be bokai dirai, “Kaiko ka tamoata ngae tagataga ne! Keka Moses tagataga ne. ");
INSERT INTO mva_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Keka kikaua Nanaranga nge Moses-la ka diepilei-buduru. Ata tamoata ngara nge tago kikauataki. Tago be tago-soasoa. Inanga ka ipura nge tagona-tina kikaua!” ");
INSERT INTO mva_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Be tamoata ngae bokai iradi, “A? Nge baituka ka kana ngae labu tago kakauataki? Kaba kamaita! Tagona-ra kakaua inanga ka ipura, ata ngai ka matagu iuasari! ");
INSERT INTO mva_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kita takaua tamoata muzigoala ememaki nge Nanaranga tago ilolongoridi. Nanaranga nge tamoata rangguma dimuamuaki be rerengana-lo kana diememaki ka ilolongoridi. ");
INSERT INTO mva_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Matamatana-tina kateka emaka ipura-lo be imai nge tamoata tago teke mata leuadi be nekiaka ipura nge adoraka ipura be ruku kilongo. Tago-la! ");
INSERT INTO mva_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamoata ngae tago Nanaranga-lo ka ipura nge tagona-tina iboadu kana teke ngaemaki. Tago-la!” ");
INSERT INTO mva_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Makara nge Iuda ditaguraki be bokai dirai, “Kaiko muzigoala-lo be tinam inekiakiko be iaka-labatiko! Nge kaiko bokainaina kata ka gosulekama kana ki?” Kodeka ditaguraki be pera ono serereinga-lo ka ditaoni be ipusika. ");
INSERT INTO mva_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesus bokai ilongo tamoata mata iadoraki nge ambe ditaoni be pera nedi ono serereinga ipereki. Be bong ite nge bokai irai, “Tamoata Natu lama kunani ki tago?” ");
INSERT INTO mva_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Be tamoata ngae ikatu be ipile, “Biabiadi, goraia naita kata be lama munani!” ");
INSERT INTO mva_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kodeka Iesus bokai ipile, “Ambe kutea-doi! Nge ngai ka kaituka-tina kapilepile-buduru.” ");
INSERT INTO mva_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Be tamoata ngae bokai ipile, “Tanepoa! Lama uni!” Kodeka tamoata ngae itaguraki be Iesus aro tuku-nao irokazokuria be Iesus irakeaki. ");
INSERT INTO mva_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Makara nge Iesus bokai ipile, “Nge ono tamoata moarunga giriki nedi lilitadi dapura kana ka kateka ngaenao upura. Bokai masa tamoata dikaua matadi leuadi nge kaba daita. Be tamoata ilodi dipile matadi uia nge kaba daita di moangi be matadi leuadi!” ");
INSERT INTO mva_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parasi alu makara saringa disoaki dilongo nge bokai ditegi, “Nge baituka? Ilom ipile keka matama leuadi ki?” ");
INSERT INTO mva_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Be Iesus ikatu be bokai iradi, “Mata-ming daleua bokana nge ambe giriki neming tago. Ata nge bokai kapile, ‘Keka mata-ma uia.’ Bokaibe giriki omingo dieno.” ");
INSERT INTO mva_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Moimoi ka ura-kaming! Tamoata nangata tago babaduadua-lo isili, zala-ba takaia itagai be ‘sipisipi’ ari nedia-lo isili nge anako be sumoara kata. ");
INSERT INTO mva_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tamoata babaduadua-lo isili nge ‘sipisipi’ akolakola. ");
INSERT INTO mva_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bokaibe tamoata babaduadua inarinaringi masa ngataguraki be tamoata ‘sipisipi’ akolakola babaduadua ngauasarani, be ‘sipisipi’ ne masa malonga dalongo. Kodeka ‘sipisipi’ ne masa aradia-lo be ngakiladi be ngaromuandi be ngapasikidi. ");
INSERT INTO mva_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ngapasikidia-doi nge arodi ngamua be datagai, bakara, malonga dikauataki. ");
INSERT INTO mva_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ata tamoata akerenga nge tagona-tina iboadu datagai, bakara, tamoata akerenga nge malonga tago dikilalangi. Bokaibe ‘sipisipi’ nge dairatu-la be kana.” ");
INSERT INTO mva_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesus pile ono tonanga ngae ane be iradi, ata di labu tago dikauataki. ");
INSERT INTO mva_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bokai ka Iesus kaba bokai ipile, “Moimoi ka ura-kaming. Ngau ka ‘sipisipi’ babaduadua nedi. ");
INSERT INTO mva_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tamoata takadi moarunga arogu dilako be ‘sipisipi’ dinanaringdi nge anako be sumoara kaoa. Nge bokai ka ‘sipisipi’ tago dilongoridi. ");
INSERT INTO mva_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngau ka babaduadua. Tamoata naita ngau-lo imai be isili masa uketa ngapura. Be masa ngasilisili be ngapusikasika be kaba ono ramomonga uia ngaita. ");
INSERT INTO mva_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Anako nge ‘sipisipi’ nganakuaki be ngaumoatedi be ngagamangdi kana ka isili. Ata ngau upura be ono moauriuri-la soaki ipurapura nge didoki. Be moauriuri-la soaki ngae nge masa kania ere-moarunga zaiza be dadoki. ");
INSERT INTO mva_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ngau nge ‘sipisipi’ akolakola iauia. ‘Sipisipi’ akolakola iauia iboadu ‘sipisipi’ ne kanabe ngamate. ");
INSERT INTO mva_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tamoata zazanga ngadoki kana ka ‘sipisipi’ iakokolangdi nge tago ‘sipisipi’ akolakola-tina kata, be ngai nge tago ‘sipisipi’ marau. Bong keu kabukabu teke ngapura masa ‘sipisipi’ ngaperekidi be ngairatu. Be keu kabukabu masa ‘sipisipi’ ngagamangdi be ngaramoakidia-ramo. ");
INSERT INTO mva_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tamoata zazaia kana ka ‘sipisipi’ iakolakola nge ngairatu kana, bakara, ngai nge zazaia ngapura kana. Bokaibe tagona-tina iboadu ‘sipisipi’ ngailo-bukutakidi. ");
INSERT INTO mva_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ngau nge ‘sipisipi’ akolakola iauia. ‘Sipisipi’ negu ukauatakidi be ‘sipisipi’ negu dikauataka, ");
INSERT INTO mva_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tamagu-la ngau ikauataka be ngau Tama-gu ukauataki bokana. Be masa ‘sipisipi’ negu kana be mate. ");
INSERT INTO mva_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","‘Sipisipi’ negu takadi tago ari ngaedia-lo disukoaki nge kaba takadia-lo disoaki. Bokaibe mpi be mbagadi kana. Di masa malonga-gu dalongo be. Bokai masa ‘sipisipi’ ulunga tekena-la, be ‘sipisipi’ akolakola tekena-la. ");
INSERT INTO mva_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Tama-gu ireretakau-tina, bakara ngau rerengagu-lo be moarunga kanabe mate kana. Be rerengagu-lo be iboadu negu-la muleaka be moauriuri msoaki. ");
INSERT INTO mva_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tago teke iboadu ngaumoatea. Tago-la. Negu rerengagu-lo ka mate kana. Ngau uboadu-tina rerengagu-lo be mate ki negu iauaia msoaki. Malipi ngaedi nge Tamagu-lo ka udoki.” ");
INSERT INTO mva_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iesus bokai ipile nge Iuda kaba pilenga ngaedi kanabe nedia-la dienegei-ramo. Labu ono dienegei-ramo nge bokai: ");
INSERT INTO mva_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Kokoko-tina bokai dipile, “Mariaba goalaka ka ibagabagai! Be ambe ingao! Bakara ka kalongolongri?” ");
INSERT INTO mva_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ata alu bokai dipile, “Tamoata mariaba goalaka ibagabagai tago iboadu bokai ngapilepile! Mariaba goalaka masa bakara be mata-leua matadi ngadoraki?” ");
INSERT INTO mva_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Iuda bong nedi biabia teke ara Anuka Ierusalem anua-lo ipura. Bong biabia ngaenao barasi moarunga ilodia-lo nge Iuda mata nedi teke ditagatagai be Nanaranga pera ne diasasaki be ono ditamatamali. Nge madidi bong-lo be kana ngae diememaki. ");
INSERT INTO mva_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesus nge Nanaranga pera nena-lo ialalale. Ege ono ialalale kana nge “Solomon Sumasuma” ne kana ditugani. ");
INSERT INTO mva_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kodeka Iuda dipura be Iesus diboalingi be bokai dipile, “Masa uanana salagatikadi bakaraituka kaiko-ba gailo-bukubukutakiko be garapurapu? Kaiko moimoi be Kristus nge adoado ma mangata gora-kama!” ");
INSERT INTO mva_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Be Iesus ikatu be bokai iradi, “Ngau ambe urakaming-doi, ata kam lama tago kaunana. Tama-gu ara-nao be malipi kaiboangdi uememaki nge mangata dirangarangaka! ");
INSERT INTO mva_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ata lama tago kaunana. Maka ma kam tago ngau ‘sipisipi’ negu! ");
INSERT INTO mva_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","‘Sipisipi’ negu ukauatakidi, be malonga-gu dilongolongo, be ditagatagaia. ");
INSERT INTO mva_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Be moauriuri-la nem-kusoaki soaki ipurapura nge miandi kana. Tagona-tina iboadu daleua. Masa lumagu-lanao dasukoaki be tago teke iboadu lumagu-lo be ngadoki-repekidialea. ");
INSERT INTO mva_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Tama-gu ka idokidi be iana. Ngai ka biabiatuka be kana moarunga iuasadi. Bokaibe ‘sipisipi’ ngau iana nge tago teke iboadu ngadoki-repekidiale. ");
INSERT INTO mva_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Maka ma keru Tama-gu keru nge teke-mairu.” ");
INSERT INTO mva_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Makara nge Iuda kaba patu didoki be Iesus dauni kana, ");
INSERT INTO mva_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ata Iesus bokai iradi, “Ngau kana kokoko-tina Tama-gu iana be mata-mingo uemaki be kaita. Nge nangata lili-nao ka patu oti kamauna kana?” ");
INSERT INTO mva_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Be di dikatu be bokai dipile, “Tago malipi kaiboangdi kuememaki teke lili-nao ka gaumoateiko kana! Tago. Nanaranga ono kumanai ka patu oti gaumoateiko kana. Kaiko tamoata-ramo, ata nem-la kupile kaiko nge Nanaranga.” ");
INSERT INTO mva_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Kodeka Iesus bokai iradi, “Moses Mata nena-lo nge Nanaranga bokai ipile, ‘Ngau upile kam nanaranga.’ ");
INSERT INTO mva_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Kita takaua rakana Nanaranga ‘Buku’ ne irangaki nge moimoi be kalingo. Tago iboli. Be tamoata be aine maka pile ne iandi nge nanaranga kana irangakidi. ");
INSERT INTO mva_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ngau nge Tama-gu ka inangaia be inepia be makare kateka-o upura. Bokaibe ngau bokai upile, ‘Ngau Nanaranga Natu’ ngena bakara ka kapile Nanaranga ono umanai? ");
INSERT INTO mva_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Malipi uememaki tago Tama-gu ne kana kapile nge moaki lama kaunana. ");
INSERT INTO mva_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ata moimoi be Tama-gu malipi ne ka uememaki be kam lama tago kauni nge kilala-ba kaiboangdi uememaki nge ka lama kamaungdi. Bokai masa kamakauatakau-uia Tama-gu ngau-lo isoaki be ngau Tamagu-lo usoaki!” ");
INSERT INTO mva_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Makara nge dauauri kana, ata lumadia-lo ka ipusika. ");
INSERT INTO mva_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kodeka Iesus ialale be Zodan zagura itotoki be kaba odio Zon norane be ruku ono tamalinga ane be tamoata be aine irukurukudia-lo makara isoaki. ");
INSERT INTO mva_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tamoata be aine kokoko-tina dipura be bokai dipile, “Zon moimoi kilala kaiboangdi tago teke iemaki, ata pile moarunga ono tamoata ngae irangaki nge moimoi.” ");
INSERT INTO mva_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Bokaibe tamoata be aine kokoko-tina makara kaba ngaradia-lo nge lama diuni. ");
INSERT INTO mva_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betani tamoata teke ara Lasarus nge imore. Betani nge Maria taritoka Marta diaru anua nediaru. ");
INSERT INTO mva_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria ngae ka bureng boau otioti idoki be Tanepoa ae babadi-o isuburakaria be donga ane iutu. Be nge ngai marau Lasarus ka imore be ieno. ");
INSERT INTO mva_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Bokaibe Maria be Marta ditagurakiru be Iesus pile bokai dinanganiaru, “Tanepoa, ruangam uarika kurereretaki imore.” ");
INSERT INTO mva_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesus ilongo nge bokai ipile, “More ngae nge tago ono Lasarus ngamate kana ka ipurani. Tago. Nge ono Nanaranga kaiboang be malama ne mangata teadi dapura kana ka Lasarus imore. Be bokai masa kana ngaena-lo be Tamoata Natu ara atabala-tina nangaia ngapura.” ");
INSERT INTO mva_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Moimoi Iesus Maria taritoka Marta diaru be Lasarus irereretakidiato. ");
INSERT INTO mva_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ata bong Iesus bokai ilongo Lasarus imore nge kababe amaridi rua makara kaba odio isoaki-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kodeka Iesus tagataga ne bokai iradi, “Zudea kaba-lo talako!” ");
INSERT INTO mva_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ata tagataga ne bokai dipile, “‘Tisa,’ norane ka Iuda patu oti daumoateiko kana! Nge ambe ene golako kana ki?” ");
INSERT INTO mva_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Be Iesus ikatu be bokai iradi, “Ariata tekena-lo nge amari siriki ne kulemoa-be-rua dieno. Tamoata ariata ialalale nge kateka ngae malama nena-lo kaba itaita be ialalale. Bokaibe tago iboadu ngatamong. ");
INSERT INTO mva_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ata tamoata oabubu-lo ialalale nge malama ne tago. Bokaibe masa ngatamong-la be kana!” ");
INSERT INTO mva_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesus pile ngaedi ipile-doi, kodeka kaba bokai ipile, “Ruangada Lasarus ambe ieno-soa. Ata masa mialale be mianguni!” ");
INSERT INTO mva_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Be tagataga ne bokai dipile, “Tanepoa! Ngaeno-ma ka masa ngauia!” ");
INSERT INTO mva_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ata Lasarus ambe moimoi be imate ka Iesus bokai irangaki. Iesus bokai ipile nge tagataga ne ilodi dipile Lasarus ne ieneno bokana ka ieno. ");
INSERT INTO mva_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Makara nge Iesus itaguraki be mangata bokai iradi, “Lasarus moimoi ambe imate. ");
INSERT INTO mva_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nge iuia tago saringa usoaki be imate. Aria, talale be kana kalingo kamate, be lama kamauni!” ");
INSERT INTO mva_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Makara nge Tomas, ara takaia Didimas nge itaguraki be tagataga takadi bokai iradi, “Talale-budu be Iesus zaiza be tamate-budu.” ");
INSERT INTO mva_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesus Betani-lo ilakopura nge kaba bokai ita Lasarus ambe kumraka ipura be amaridi oati dilako. ");
INSERT INTO mva_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani anua nge Ierusalem saringa ka ieno, kaleti pile-lo nge masauakadi ‘kilomita’ toli bokana. ");
INSERT INTO mva_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bokaibe Iuda tamoata be aine kokoko-tina Ierusalem-lo nge dipura. Maria be Marta marau-diaru imate ka lili dandiaru kana be dipura. ");
INSERT INTO mva_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta bokai ilongo Iesus ambe ipurapura nge ialale be ngazala-doki kana. Ata Maria nge pera-lanalo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ilako be Iesus ipurakani nge bokai irai, “Tanepoa, makare gosoaki bokana nge marau-gu ambe tago ngamate. ");
INSERT INTO mva_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ata ngau ukaua rakana kaituka-tina kureretaki be Nanaranga kusinaui nge ngangko-la be kana.” ");
INSERT INTO mva_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Be Iesus bokai ipile, “Maraum masa ngamarang be moauriuri ngasoaki.” ");
INSERT INTO mva_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Be Marta itaguraki be Iesus bokai irai, “Ngau ukaua masa bong alalaurituka-o ka kaba ngamarang be moauriuri-la ngasoaki kana.” ");
INSERT INTO mva_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Makara nge Iesus bokai ipile, “Ngau ka mate-lo be marang, be moauriuri-la soaki labudi. Tamoata naita lama iunana masa moauriuri ngasoaki. Kana-ra imate-ma, ata masa moauriuri ngasoaki. ");
INSERT INTO mva_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Be tamoata moauriuri isoaki be lama iunana nge tagona-tina iboadu ngamate. Pile ngaedi lama kungdi ki tago?” ");
INSERT INTO mva_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Be Marta ikatu be bokai ipile, “E, Tanepoa! Ngau lama uni kaiko ka Kristus, Nanaranga Natu toira rangakam ipura masa kateka ngaena-lo gobala.” ");
INSERT INTO mva_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta bokai ipile, kodeka ialale pera-lo be taritoka Maria laua-o ilakuaki be bokai irai, “‘Tisa’ ambe maka. Itegitegiakiko.” ");
INSERT INTO mva_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria bokai ilongo nge oaikiki-tina itui be ilako Iesus ngate kana. ");
INSERT INTO mva_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ata Iesus isi tago anua-lo ipusikalako. Isi kaba odio Marta ipurakania-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Iuda maka Maria zaiza pera-lo disoaki be lili dianiani kaba bokai dita Maria itui be imaraka be ipusika nge ditui be ditagai. Ilodi dipile poda-lo ngatang kana ka ilakolako. ");
INSERT INTO mva_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria ilako Iesus isoaki kanana-lo be Iesus ite nge ilako be ae-nalo itapuloria be bokai irai, “Tanepoa, makare gosoaki bokana nge ambe maraugu tago ngamate!” ");
INSERT INTO mva_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesus kaba bokai ita Maria be Iuda ditagai be dipura ditangtang nge ilo inodo-tina be ilo tangtang isili. ");
INSERT INTO mva_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kodeka Iesus bokai itegidi, “Inanga kakumraki?” Be di dikatu be dipile, “Tanepoa, gomai be kaba goita.” ");
INSERT INTO mva_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Makara nge Iesus itang. ");
INSERT INTO mva_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iuda kaba bokai dita nge bokai dipile, “Kamate, ngai moimoi Lasarus irereretakia-tina!” ");
INSERT INTO mva_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ata alu bokai dipile, “Tamoata ngae tamoata mata-leuadi iadoraki. Bakara be Lasarus tago idumai be ambe imate?” ");
INSERT INTO mva_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Makara nge Iesus kaba ilo tangtang isili. Kodeka itui be Lasarus poda-nalo ilako. Poda ngae nge patu boazinga-lo ka diemaki. Be aoa nge patu kanabiabia teke oti dionoti. ");
INSERT INTO mva_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kodeka Iesus bokai ipile, “Patu ono poda onota ipura kamarokaki!” Ata tamoata mate marau Marta nge bokai ipile, “Tanepoa! Ambe amaridi oati gimoa-lo ieno! Masa ambe imoapuru!” ");
INSERT INTO mva_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ata Iesus bokai irai, “Uraiko ki tago lama kuni masa Nanaranga kaiboang be malama ne goita?” ");
INSERT INTO mva_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Makara be patu ono poda onota ipura nge digegeaki be poda aoa itakaka. Kodeka Iesus atabala-lo itadarake be bokai ipile, “Mamo! Uperuiko-tina ambe kulongora! ");
INSERT INTO mva_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngau ukaua izamaizama kulongolongora, ata nge ono tamoata be aine makare disoaki kana ka bokai upile. Bokai masa lama dauni kaiko ka kunepia be makare kateka-o upura.” ");
INSERT INTO mva_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesus bokai ipile, kodeka ipi-tina be bokai ikilau, “Lasarus! Gopusika!” ");
INSERT INTO mva_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Makara nge tamoata mate nge ipusika. Ae be luma nge kusi manipidi ono matedi kumrakadi dipurapura ane dipipisi. Be lili nge kusi takaia oti disukum. Kodeka Iesus bokai ipile, “Kusi ono kumraka kamarubeni be ngapusika.” ");
INSERT INTO mva_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iuda kokoko-tina Maria lili dani kana be dipura Iesus kana ngae iemaki dite nge lama diuni. ");
INSERT INTO mva_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ata alu dialale be Iesus kana iemaki nge Parasi dirangakadi. ");
INSERT INTO mva_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Makara nge tamoata Nanaranga ditabatabai dimuamuadi be Parasi ditaguraki be tamoata bibia takadi Iuda ‘Kansolo’ nedi-o disoaki nge dikeliakidi be bokai diradi, “Masa rakana taemaki? Tamoata ngae kilala kaiboangdi kokoko-tina iememaki! ");
INSERT INTO mva_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Talikitaki be bokai ngamuzimuzi-la masa moarunga-tina ngai lama daunani. Be ungguma Rom masa dataguraki be Nanaranga pera ne dagamani, be kita ungguma Iuda nge dara-leua-kita.” ");
INSERT INTO mva_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ata teke maradi ara Kaiapas ituirake be ngapile kana. Barasi ngaranao nge ngai ka tamoata Nanaranga ditabatabai biabiatuka nedi. Kaiapas bokai ipile, “Kana tagona-tina teke kakauataki! ");
INSERT INTO mva_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ilo-ming kalelenaki ki tago? Tamoata tekena-la kita Iuda moarunga lilida-o be imate nge iuia. Ata Iuda moarunga ara-leuaiada dipura nge tago iuia.” ");
INSERT INTO mva_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pile ngaedi nge tago ne ilona-lo ka dipusika. Maka ma barasi ngaranao nge ngai ka tamoata Nanaranga ditabatabai biabiatuka nedi. Bokai ka nge ambe Iesus matenga ono ungguma Iuda ngadumadi kana ka irangaki-ba mua. Alauri ka pilenga dikalingo. ");
INSERT INTO mva_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nge tago ungguma-la Iuda ka ngadumadi kana ka ngamate kana. Tago. Iesus ngamate be ono Nanaranga natu ege-ege disoaki nge ngatekenanadi be ungguma teke bokana dasoaki kana ka ngamate kana. ");
INSERT INTO mva_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bokaibe bong ngaranao be ilako nge Iuda tamoata nedi bibia nge diraba be Iesus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nge bokai ka Iesus tago sesu Iuda lilidi-be-matadio ialalale. Kaba ngaradi ipereki be ilako kaba tekedi lulu kaba zagedi-o dieno-lo ilako, be makara anua ara Epraim-lo tagataga ne zaiza disukoaki. ");
INSERT INTO mva_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Iuda moanako nedi biabia ara ‘Pasoba’ nge ambe isaringa. Bokaibe Iuda moarunga anua sisiki-lonalona nge Ierusalem dilako be mata nedia-lo daruku be ono datamalidi kana, be alauri masa ‘Pasoba’ darakeaki. ");
INSERT INTO mva_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Makara nge Iesus dilelelei. Be Nanaranga pera nena-lo dikabuni be disoaki nge nedia-la bokai dietegi, “Bakara ilo-ming dipile? Moanako biabia ngaena-lo ngapura ki tago?” ");
INSERT INTO mva_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tamoata Nanaranga ditabatabai dimuamuadi be Parasi nge ambe pile bokai diemaki tamoata naita Iesus soakinga ikauataki nge ngaradi be masa dauauri. ");
INSERT INTO mva_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Amaridi lima-teke isi dieno be ‘Pasoba’ moanako bong ne dapura kana nge Iesus itui be Betani anua-lo ilako. Betani nge Lasarus anua ne. Be nge Lasarus ngae ka imate be Iesus kaba imarangaki. ");
INSERT INTO mva_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Makara nge rairai moanako teke Iesus aranao be diemaki. Lasarus marau Marta nge kangkang ipasipasi be ianiandi. Be Lasarus nge Iesus diaru bagi ono moanakonga-lo disoakiru be tamoata takadi zaiza dimoanakonako. ");
INSERT INTO mva_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kodeka Maria itaguraki be bureng boau rongorongo zazaia atabalabala-tina kai ara ‘nad’ oti emaka ipura bulo tekena-lo ieno nge idoki be Iesus ae babadi-o isuburakaria be donga ane iutu. Bureng ngae boau nge pera ilo ilolomi. ");
INSERT INTO mva_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ata tagataga ne teke alauri Iesus erekei luma-dio inangai ara Iudas Iskariot nge bokai ipile, ");
INSERT INTO mva_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bakara ka bureng ngae tago ono ‘mone’ biabia tadoki be tamoata kana nedi tagotago tandi?” ");
INSERT INTO mva_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nge tago tamoata kana nedi tagotago ilo ibukutakidi ka bokai ipile. Tago. Ngai nge anako kata, be raba ono ‘mone’ dokinga nge ngai ka idokidoki. Bokaibe nge ono ‘mone’ ngaedi alu ne rerengana-lo ngadoki kana ka bokai ipile. ");
INSERT INTO mva_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ata Iesus bokai ipile, “Kamalikitaki be kana rerengana-lo iememaki nge ngaemaki. Bureng ngae nge idokimatei be bong ono kumrakagu ngapura kana nge irapurapungi. ");
INSERT INTO mva_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tamoata kana nedi tagotago masa sakeming-lanao dasukoaki, ata ngau masa tago sakeming-lanao msukoaki.” ");
INSERT INTO mva_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Iuda kokoko-tina dilongo Iesus Betani anua-lo isoaki nge makara dipura. Tago Iesus-la makara isoaki ka dipura. Tago. Lasarus be date kana ka dipura! Maka ma ngai ka imate be Iesus imarangaki. ");
INSERT INTO mva_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Bokaibe tamoata Nanaranga ditabatabai dimuamuadi nge diraba be Lasarus daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Lasarus lili-nao ka Iuda kokoko-tina ditaguraki be tamoata Nanaranga ditabatabai dimuamuadi nge diperekidi be Iesus lama diunani. ");
INSERT INTO mva_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Izama nge tamoata be aine dum kanabiabia teke ‘Pasoba’ moanako-lo dipura nge bokai dilongo Iesus ambe Ierusalem-lo ipurapura. ");
INSERT INTO mva_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Makara nge poatore saparadi dikoto be dibazidi be dialale be Iesus dazala-doki kana. Zala-lo dialalale nge bokai dimeremere be dipilepile, “Nanaranga tarakeaki! Tamoata naita Tanepoa ara-nao be ipura masa Nanaranga marou ne ngadoki. Nanaranga iboadu Israel Anuatanepoa nedi ngamaroui!” (Sam 118:25-26) ");
INSERT INTO mva_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesus nge ambe ‘dongki’ teke ite be ono isoaki, Nanaranga-la ‘Buku’ ne dipile bokana. Nanaranga ‘Buku’ ne bokai dipile, ");
INSERT INTO mva_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Zaion anua, taburim moaki ira. Kamate, anuatanepoa ne maka imaimai. ‘Dongki’ natu-o isoaki be ipura.” (Zek 9:9) ");
INSERT INTO mva_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bong ngaranao nge Iesus tagataga ne isi ilodi tago dizama uia. Ata alauri Iesus mate-lo be marangaka ipura be ara atabala-tina nangaia ipura ngeka ilodi dikaua Nanaranga ‘Buku’ ne nge Iesus bokai dirangaki. Be kana ngaedi Nanaranga ‘Buku’ ne dipile daemakini kana nge diemakini. ");
INSERT INTO mva_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bong Lasarus imate be gimoa-lo ieno nge tamoata be aine kokoko-tina Iesus zaiza disoaki be Iesus Lasarus ikilai be mate-lo be imarang be dite. Bokaibe tamoata be aine ngaedi dialale be Iesus kana ngae iemaki nge ege-ege tamoata be aine takadi diraradi. ");
INSERT INTO mva_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tamoata be aine kokoko-tina bokai dilongo Iesus kilala kaiboangi ngae iemaki nge dialale be dazala-doki kana. ");
INSERT INTO mva_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Makara nge Parasi nedia-la bokai dipile, “Kaba kamaita! Ambe tago taboadu tabalaki! Kamate! Tamoata be aine moarunga kateka-o ambe ngai ditagatagai!” ");
INSERT INTO mva_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tamoata be aine kokoko-tina Ierusalem dilako be moanako biabia ‘Pasoba’ nge darakeaki kana. Be ungguma aradi Gris nge alu maradi dilako be dialale-budu. ");
INSERT INTO mva_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gris tamoata ngaedi nge dilako be Betsaida tamoata ara Pilip bokai dirai, “Biabiadi, keka Iesus gate kana kirere.” Pilip nge Betsaida anua, ege Galili kaba-lo tamoata kata. ");
INSERT INTO mva_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kodeka Pilip ilako be Endru irai be dilakoru be Iesus diraiaru. ");
INSERT INTO mva_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Be Iesus ikatu be bokai ira-diaru, “Bong ono Tamoata Natu ara bibia-tina ania ngapura kana ambe dipura. ");
INSERT INTO mva_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Moimoi ka ura-kaming! Kangkang patu tekena-la kata be tago kateka-o isapasiria nge masa ngarana-la bokai ngaeneno. Tago kaba taka ngadula. Ata kateka-o isapasiria be imate masa ngadula be kangkang kokoko-tina ngapuraki. ");
INSERT INTO mva_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ata tamoata naita moauriuri soakinga kateka ngaenao ireretaki masa ngaleua. Tamoata naita moauriuri soakinga kateka ngaenao isegeaki masa nem-kusoaki ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tamoata naita ngamalipi-na kana nge ngatagaia. Be inanga usoaki kana masa malipilipi kanagu bokana ngasoaki. Be tamoata naita malipi negu iememaki masa Tama-gu ngataguraki be tamoata bokainaina muaka bibia ngani. ");
INSERT INTO mva_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Moatubu ilogu-lo dilaba be masa bakara mpile? Bokai mpile ki? ‘Mamo, kana ngae ambe ngapurana kana nge godokalea!’ Moaki bokai upile. Moatubu ngaedi mdoki kana ka kateka ngaenao upura. ");
INSERT INTO mva_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mamo, kaiboang nem malamakadi otioti ane be aram atabala-tina gonangai.” Makara nge malonga teke lang-lo bokai ipile, “Ngau ambe kaiboang be malama negu mangata unanga be dita, be kaba mangata mnangananga-la kana.” ");
INSERT INTO mva_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tamoata be aine makara disoaki malonga ngae dilongori nge bokai dipile, “Lamalama ipakira!” Alu bokai dipile, “‘Enzel’ ka Iesus irai.” ");
INSERT INTO mva_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ata Iesus bokai iradi, “Kam kana ka malonga ngae ipura, tago ngau. ");
INSERT INTO mva_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Bong ono Nanaranga tamoata be aine kateka-o giriki nedi ngaliliti be moatubu ngandi kana ambe dipura. Kaituka masa kateka ngae anuatanepoa ne nge rokaka ngapura. ");
INSERT INTO mva_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ata bong ngau dokatetekagu ngapura masa tamoata be aine moarunga ngau-lo mrepekidiamai.” ");
INSERT INTO mva_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Bokai ipile nge ono itikingdi alauri masa mate bakarairai ngamate. ");
INSERT INTO mva_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Kodeka tamoata be aine bokai dipile, “Moses Mata nena-lo bokai dieno Kristus masa bokaina-la ngasukoaki. Nge bakara be bokai kupile Tamoata Natu masa dokiteteka ngapura? Be naita ka Tamoata Natu?” ");
INSERT INTO mva_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Be Iesus ikatu be bokai iradi, “Uanana mukudia-tina isi dieno be masa malama mara-ming ngaeno. Malama isi mara-ming ieno be kamalalale. Oabubu ngadoki-kaming takana! Tamoata oabubu-balo ialalale masa tago ngakaua inanga ilakolako. ");
INSERT INTO mva_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Malama isi ieno-kaming be lama kamaunani. Bokai masa malama ngae natu kamapura!” Bokai ipile-doi kodeka iperekidi be ikomadi. ");
INSERT INTO mva_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Moimoi matadia-tinalo be Iesus kilala kaiboangdi iememaki, ata Iuda moarunga-tina lama tago diuni. ");
INSERT INTO mva_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bokaibe ‘propet’ ara Aisaia nge pilenga dikalingo. Aisaia bokai ipile, “Tanepoa! Pilenga-ma kipile nge naita lama iundi? Rangguma-lo ka Tanepoa kaiboang ne itikingdi be dita?” (Ais 53:1) ");
INSERT INTO mva_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Labu ngaenao ka lama tago diuni, bakara Aisaia pilenga takadi bokai dieno, ");
INSERT INTO mva_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nanaranga ambe matadi iono be matadi dileua, be ilodi ambe iemeki be dikaiboang. Bokaibe matadi ane tago iboadu kaba daita, be ilodi ambe tago iboadu dazama. Be tago iboadu ilodi dabuiri be ngau-lo damai be miaka-uiakidi.” (Ais 6:10) ");
INSERT INTO mva_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia nge toira be Iesus kaiboang ne malamakadi otioti nge ita. Nge bokai ka bokai irangaki. ");
INSERT INTO mva_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Moimoi Iuda tamoata bibia kokoko-tina lama diuni, ata Parasi dimatakuridi be tago mangata dipilepile. Mangata dapile masa pera ono serereinga nedia-lo dataodi be kaba tago dasilisili takana. ");
INSERT INTO mva_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Maka ma Iuda tamoata bibia direrere rakeaka bibia nge kateka tamoata-lo dadokidoki, tago Nanaranga-lo. ");
INSERT INTO mva_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kodeka Iesus ipi-tina be bokai ipile, “Tamoata naita ngau lama iunana nge tago ngau-la ka lama iunana. Nge nepinepi negu ka lama iunani be. ");
INSERT INTO mva_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Be ngau itea nge nepinepi negu ka ite be. ");
INSERT INTO mva_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngau malama bokana ka kateka ngaenao upura. Bokaibe tamoata naita lama iunana nge tago iboadu kababe oabubu-balo ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Tamoata naita pilengagu ilongo, ata tago itagatagadi nge tago iboadu giriki ne mliliti. Tago-la. Maka ma ngau tago tamoata be aine kateka ngaena-o giriki nedi mliliti kana ka upura. Tago. Muketidi be muleakidi kana ka upura. ");
INSERT INTO mva_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tamoata isegeaka be pilengagu tago idoki be itagatagadi nge giriki adoadoraki ne isoaki-doi. Pile ngau upile-ma ka dataguraki be bong alalaurituka-o saranga aoa-nalo darokakalako be moatubu ono danangalako kana. ");
INSERT INTO mva_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pile maka upilepile nge tago negu aoa-gulo ka dipurapura. Tago-tina. Nge Tama-gu inepia be makare upura ka rakana mrangaki be baituka mpile kana nge ianana be upilepile. ");
INSERT INTO mva_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Be ngau ukaua pilenga moarunga nge iboadu tamoata moarunga daromuandi be moauriuri-la nem-kusoaki soaki ipurapura-lo dalakuakidi. Bokai ka pile moarunga upilepile nge Tamagu-la iana bokana ka upilepile.” ");
INSERT INTO mva_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ngazama nge ‘Pasoba’ moanako bong ne kana. Iesus ikaua bong ne ambe dipura be kateka ngae ngapereki be Tamana-lo ngalako kana. Tamoata be aine ne kateka-o disoaki nge irereretakidia-la nibe ilako imate-ba. Be matenga ngaedi nge ono tamoata be aine ne itikingdi ngai moimoi be irereretakidia-tina. ");
INSERT INTO mva_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Rairai nge Iesus tagataga ne zaiza disoakiria be dimoanakonako. Satang nge ambe Saimon natu Iudas Iskariot ilona-lo isili be Iesus ngadoki be erekei luma-dio nganangai kana. ");
INSERT INTO mva_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesus nena-la ikaua ngai Nanaranga-lo ka ipura be ambe Nanaranga-lo ngamulelako kana. Be ngai ikaua Tama ambe kaiboang moarunga luma-nao isalangaki. ");
INSERT INTO mva_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Bokaibe dimoanakonako nge Iesus ituirake be kusi-sili ne atabala inangananga nge ipasi be kusi ono utua teke soa-nao iuauri. ");
INSERT INTO mva_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kodeka tabira ono rukunga-lo dang isuburakalako be tagataga ne aedi iasasaki be kusi ono utua ane iututu. ");
INSERT INTO mva_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ae-di iasasaki be ilako Saimon Pita-lo nge Saimon Pita bokai ipile, “Tanepoa, ae-gu goasaki kana ki?” ");
INSERT INTO mva_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Be Iesus ikatu be bokai irai, “Kaituka-tina tago kukaua rakana ka uememaki, ata alauri masa gokaua!” ");
INSERT INTO mva_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Be Pita bokai ipile, “Tago iboadu! Tagona-tina iboadu kaiko ngau ae-gu goasaki!” Kodeka Iesus itaguraki be Pita bokai irai, “Aem tago uasaki nge kaiko tago ruangagu!” ");
INSERT INTO mva_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ata Saimon Pita bokai ipile, “Tanepoa, bokai nge moaki aegu-la kuasaki. Luma-gu be pangana-gu goasaki be!” ");
INSERT INTO mva_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Makara nge Iesus bokai ipile, “Tamoata ambe iruku nge aena-la ka asakadi dapura kana. Kania moarunga ambe digoaza-doi ka isoaki. Bokaibe kam nge kagoaza-doi ka kasoaki. Ata tago moarunga-doi. Tekena-la neming ka tago igoaza uia!” ");
INSERT INTO mva_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Iesus ikaua naita ka erekei luma-dio nganangai kana. Bokai ka ipile tago moarunga-doi be digoaza. ");
INSERT INTO mva_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesus tagataga ne aedi iasaki-doi nge kusi ne ipasi be dieno nge kaba inanga be ilako be kabana-lo isoakiria. Kodeka bokai itegidi, “Kana uemaka-kaming nge labu kakauataki ki tago? ");
INSERT INTO mva_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Kam ‘Tisa’ be ‘Tanepoa’ kana kakilakilaia. Nge iuia. Negu aragu oti ka kakilakilaia. ");
INSERT INTO mva_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ata ngau Tanepoa be ‘Tisa’ neming ambe ae-ming uasaki. Be kam bokainatuka-la kamamuzimuzi be neming mara-ming tarito-kaming aedi kamasasaki. ");
INSERT INTO mva_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngau ambe negu-la be muzi ngae utongaki be kate. Bokaibe kaituka-la ubasaki-kaming bokana, bokai kamuzimuzi. ");
INSERT INTO mva_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Malipilipi tago teke biabiadi kana iuasai. Tago-la! Be nge bokaina-la, tamoata nepia ipura nge nepinepi ne tago iuasai. ");
INSERT INTO mva_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kana ngaedi ambe kakauataki, be alauri kaememaki masa marou bibia kamadokidoki.” ");
INSERT INTO mva_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Tago kam moarunga ka urara-kaming. Tamoata ngau ambe unangadi be negu bokana udokidi nge ukauatakidi. Ata nge ono pile ngaedi Nanaranga ‘Buku’ nena-lo dieno nge dakalingo, ‘Tamoata maka kangkang kanagu kikania-budurua-ma ka kaba imulenaki be ierekeia.’ ");
INSERT INTO mva_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Kana ngaedi isi tagona-la dipura be urakamingba-mua. Bokaibe bong kana ngaedi dapura masa kamakauataka ‘Ngau Nge Ngai.’ ");
INSERT INTO mva_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Moimoi ka ura-kaming! Tamoata naita itaguraki be ngau tamoata unepi idoki be iadoraki nge ngau ka idoka be iadoraka. Be tamoata naita ngau idoka be iadoraka nge ngau nepinepi negu ka idoki be iadoraki.” ");
INSERT INTO mva_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesus bokai ipile-doi nge ilona-lo be ilo-buku tagona-tina iuia, be mangata bokai ipile, “Moimoi ka ura-kaming! Tekem masa erekei luma-dio gonangaia!” ");
INSERT INTO mva_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bokai ipile nge tagataga ne nedia-la diededei. Tago dikaua naita ka irangarangaki. Diboangramo-ba. ");
INSERT INTO mva_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tagataga ne teke Iesus irereretakia-tina nge Iesus sakena-tinao isoaki. ");
INSERT INTO mva_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Bokaibe Saimon Pita itaguraki be tagataga ngae aboabo-la mata irape be bokai irai, “Gotegi naita ka irangarangaki?” ");
INSERT INTO mva_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Bokaibe tagataga ngae Iesus saringa isadi-lako be bokai itegi, “Tanepoa, naita ka kurangarangaki?” ");
INSERT INTO mva_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Be Iesus ikatu be bokai ipile, “‘Bereti’ mapala ngae udoki be suru-lo unangalako be tamoata nangata uiani nge ngai.” Kodeka ‘bereti’ mapala nge idoki be suru-lo inangalako be Saimon natu, Iudas Iskariot nge iani. ");
INSERT INTO mva_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iudas ‘bereti’ mapala ngae idoki nge oaikiki-tina Satang ilona-lo isili. Be Iesus itaguraki be bokai irai, “Kana goemaki kana nge goalale be oaikiki-tina goemaki!” ");
INSERT INTO mva_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ata tamoata makara moanako-lo disoaki-budu nge tagona-tina teke ikaua Iesus bakara ka Iudas bokai irai. ");
INSERT INTO mva_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Iudas ka raba ono ‘mone’ dieneno idokidoki. Bokaibe ilodi dipile kangkang ono ‘Pasoba’ dakani kana nge ngazaza kana ka bokai irai. Be ilodi takadi nge bokai dinanga, “Masa ‘mone’ ngadoki be tamoata kana nedi tagotago ngandi kanana-ua?” ");
INSERT INTO mva_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iudas ‘bereti’ mapala ngae idoki nge oaikiki-tina ipusika be ialale. Makara nge ambe irodo. ");
INSERT INTO mva_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Iudas ambe ialale nge Iesus bokai ipile, “Kodeka masa Tamoata Natu kaiboang be malama ngadoki. Be nge ngai ka Nanaranga kaiboang be malama ne mangata ngananga kana. ");
INSERT INTO mva_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Be Nanaranga ka kaiboang be malama ne Natu-nalo mangata inanga masa nena-la be Natu-nalo mangata nganangai. Be kana ngae masa oaikiki-tina ngaemaki. ");
INSERT INTO mva_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Be Iesus pilenga ibatadi be bokai iradi, “Natu-gu! Tago masa uanana sasalaga sake-mingo msoaki. Be masa kamaleleleia, ata ambe Iuda tamoata-la uradi bokana bokai mra-kaming kana, ‘Kaba odio ngau mlako kanana-lo nge tago kaboadu kamalako.’ ");
INSERT INTO mva_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mata oauoau ngau uiang-kaming nge bokai: Neming-la kamaerereretaki. Ngau-la urereretaki-kaming bokana neming kamaerereretaki. ");
INSERT INTO mva_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Neming-la kaerereretaki masa tamoata moarunga dakaua kam ngau tagataga negu.” ");
INSERT INTO mva_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Kodeka Saimon Pita bokai itegi, “Tanepoa, inanga kulakolako?” Be Iesus ikatu be bokai irai, “Kaba odio ngau mlako kana nge kaituka-tina tago kuboadu golako. Ata alauri masa gotagaia.” ");
INSERT INTO mva_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Be Pita itaguraki be bokai irai, “Tanepoa, bakara ka tago iboadu kaituka-tina mtagaiko? Ngau uboadu kaiko kanabe mate!” ");
INSERT INTO mva_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Kodeka Iesus ikatu be bokai irai, “Kaiko kuboadu ngau kanabe gomate ki? Moimoina-tina ka uraiko! Mang tagona-la ngakatararaua be masa bong toli gopile tago kukauataka!” ");
INSERT INTO mva_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Be Iesus kaba bokai ipile, “Ilo-ming moaki dibuku! Nanaranga lama kamauniunia-lani, be ngau lama kamauniunia-lana! ");
INSERT INTO mva_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Tama-gu pera kana nge ilo bibia kokoko-tina dieno. Tago nge ambe tago mra-kaming. Bokaibe mialale be kaba-ming tekedi miadoraki kana. ");
INSERT INTO mva_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ualale be kaba-ming uiadoraki-doi masa kaba mule be mbaga-kaming be sakeguo kamasukoaki. Bokai masa kaba odio ngau usoaki kanana-lo nge kam kamasoaki. ");
INSERT INTO mva_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kaba odio ngau mlako kanana-lo nge zalaka ambe kakauatakia-doi.” ");
INSERT INTO mva_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Iesus bokai ipile nge Tomas itaguraki be bokai irai, “Tanepoa, keka tago kikaua inanga kulakolako. Masa bakara be zala gakauataki?” ");
INSERT INTO mva_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Be Iesus ikatu be bokai iradi, “Ngau ka zala, ngau ka pile kalingodi labudi, be ngau ka moauriuri-la soaki labu. Tamoata tago teke iboadu zala takaia ngatagai be Tamagu-lo ngalako. Tago-la. Ngau-la ka zala. ");
INSERT INTO mva_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Kam ambe ngau kakauataka. Bokaibe Tama-gu masa kamakauataki. Bokaibe kaituka be ilako nge ambe Tama-gu kakauataki be ambe kate!” ");
INSERT INTO mva_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kodeka Pilip bokai ipile, “Tanepoa! Tamam goitiking-kama! Kuitiking-kama nge iboadu-doi!” ");
INSERT INTO mva_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Be Iesus ikatu be bokai irai, “Pilip, tago isi kukauataka ki? Uanana sasalaga-tina mara-ming usoaki, ata isi tago kukauataka ki? Tamoata naita ngau itea nge Tama-gu ka ite. Bakara ka bokai kupile, ‘Tamam goitiking-kama?’ ");
INSERT INTO mva_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Lama tago kuni ngau Tamagu-lo usoaki be Tama-gu ngau-lo isoaki ki? Pile urara-kaming nge tago negu ilogu-lo ka dipurapura be urara-kaming. Tago-tina. Nge Tama-gu ngau-lo isoaki ka nena-la be malipi ne iememaki. ");
INSERT INTO mva_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pile ngaedi lama kamaungdi: Ngau Tamagu-lo usoaki be Tama-gu ngau-lo isoaki. Pile ngaedi lama tago kaungdi nge malipi ma kaiboangdi uememaki nge lama kamaungdi. ");
INSERT INTO mva_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Moimoi ka ura-kaming. Tamoata naita lama iunana masa malipi kaiboangdi ngau uememaki bokana nge ngaememaki. Be kaba malipi ngau uemaki ngaedi nge ngauasadia-tina, bakara ngau ambe Tamagu-lo mlako kana. ");
INSERT INTO mva_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Bokaibe rakana aragu-o be kasinau masa memaki. Bokai masa Natu malipinga-nao be Tama ara bibia-tina ngadoki. ");
INSERT INTO mva_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nge bokai ka rakana teke kareretaki be ara-guo be kasinau nge memakia-la be kana! ");
INSERT INTO mva_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Karereretakau-tina nge mata negu moarunga uiang-kaming nge kamatagatagadi be kamaememaki. ");
INSERT INTO mva_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Masa Tama-gu mtegi be Dumaduma teke ngang-kaming be ono kamakaiboang, be masa bokaina-la sakeming-o ngasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Oli Spirit ka kamadoki kana, be ngai ka pile kalingodi moarunga labudi. Tamoata be aine moarunga kateka-o tago diboadu Dumaduma ngae dadoki. Maka ma di tago dikauataki be tago dite. Ata kam kakauataki, bakara ngai masa sakeming-lanao ngasukoaki kana. Be masa iloming-lo anua ngadoki. ");
INSERT INTO mva_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ata tago masa natu gadagadadi bokana mpereki-kaming be kamasoaki. Masa kaba mule. ");
INSERT INTO mva_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Uanana tago sasalaga isi dieno be masa tamoata be aine moarunga kateka-o nge tago datea, ata kam masa kamatea. Maka ma ngau moauriuri-la usukoaki. Bokaibe kam masa moauriuri-la kamasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Bong ngaranao masa kamakaua ngau Tamagu-lo usoaki, be kam ngau-lo kasoaki ngau-la kam-lo usoaki bokana. ");
INSERT INTO mva_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Tamoata naita pilengagu idoki be itagatagadi nge ngau irereretaka. Be Tama-gu masa tamoata ngau irereretaka nge ngarereretaki. Be ngau masa tamoata ngae mreretaki be negu-la mangata mnangaia be ngatea.” ");
INSERT INTO mva_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kodeka Iudas (tago Iudas Iskariot) bokai ipile, “Tanepoa, bakara ka keka matamaio nem-la mangata gonangaiko kana, be tamoata be aine moarunga kateka-o nge tago?” ");
INSERT INTO mva_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Be Iesus ikatu be bokai ipile, “Tamoata naita irereretaka masa sulengagu ngadoki be ngatagatagadi. Be Tama-gu masa tamoata bokainaina ngarereretaki, be gapuraru be sakenao anua gadokiaru. ");
INSERT INTO mva_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tamoata tago irereretaka masa sulengagu tago ngadoki be ngatagatagadi. Pile ngaedi upilepile nge tago ngau negu. Nge Tama-gu ne. Ngai ka inepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Pile ngaedi nge isi sake-mingo usoaki ka urara-kaming. ");
INSERT INTO mva_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ata Dumaduma, Oli Spirit ngau araguo be Tama-gu nganepi kana masa kana ngaedi ngasule-kaming be kana moarunga urangaki nge ngailo-kauataki be pilengagu ilo-ming dandi. ");
INSERT INTO mva_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ngau ambe mpereki-kaming kana. Bokaibe ilo-uia upereka-kaming. Nge ilo-uia negu ka upereka-kaming. Ilo-uia ngau uiang-kaming nge tago ilo-uia kateka tamoata dianiang-kaming bokana. Tago. Bokaibe ilo-ming moaki dibuku, be taburi-ming moaki dira. ");
INSERT INTO mva_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ambe bokai ura-kaming be kalongo, ‘Ambe mialale kana, ata masa kaba kam-lo mule.’ Kam moangi be karereretaka nge iboadu suri-ming dauia ngau ambe Tamagu-lo ulakolako. Maka ma Tama-gu ka ara biabia be ngau iuasaia. ");
INSERT INTO mva_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kana ngaedi isi tagona-la dipura be ngau urakamingba-mua. Bokaibe alauri dipura masa lama kamauni. ");
INSERT INTO mva_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tago iboadu kaba masa pile takadi mra-kaming, bakara kateka ngae anuatanepoa ne ambe ipurapura. Tago iboadu bakara ngabasaka, ");
INSERT INTO mva_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ata ngau urere tamoata be aine moarunga kateka-o nge dakaua ngau Tama-gu urereretakia-tina, be Tama-gu pilenga moarunga nge ulolongori be ipilepile-la bokana kana moarunga uememaki. “Aria, kamatui be kaba ngaedi tapereki be talale!” ");
INSERT INTO mva_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ngau ka ‘uain’ kaimana-tina, be Tama-gu nge uma-marau. ");
INSERT INTO mva_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","‘Uain’ saparadi kalingodi tago dipupuraki nge Tama-gu itototo be irorokaki. Saparadi nangatadi kalingodi dipupuraki nge imoadamoadadi be kaba didaladala be kalingodi kokoko dipupuraki. ");
INSERT INTO mva_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kam ambe moada-ming dipura be kagoaza. Pile ngau uiang-kaming ane be moada-ming dipura be ilo-ming digoaza. ");
INSERT INTO mva_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Bokaibe ngau-lanalo kasoaki. Bokai masa ngau kam-lo msoaki. Kai-sapara tago teke iboadu nena-ba kalingo ngapuraki. Tago-la. Kaima-nao ieno masa kalingo ngapuraki. Bokaibe kam nge bokainatuka-la: Ngau-lo tago kasoaki nge tagona-tina kaboadu kalingo-ming kamapuraki. ");
INSERT INTO mva_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ngau nge ‘uain’ kaima, be kam nge ‘uain’ sapara. Tamoata naita ngau-lanalo isoaki be ngau ngaia-lo usoaki masa kalingo kokoko ngapuraki. Ngau tagotago nge tago iboadu kana teke kamaemaki. ");
INSERT INTO mva_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tamoata naita tago ngau-lo isoaki nge suri kai-sapara rokakadi dipurapura be dimarangorango bokana. Kai-sapara bokainaina nge dokiadi be eoa-lo rokakadialako dipurapura be dikarakara be dileualeua. ");
INSERT INTO mva_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ngau-lo kasoaki be pilengagu kam-lo dieno nge masa rerenga-minglo kana teke kamasinautaki be masa ania-ming ngapura. ");
INSERT INTO mva_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Kalingo-ming kokoko kapupuraki nge ono Tama-gu ara bibia ngadokidoki kana ka kalingo-ming kokoko kapupuraki. Bokai masa neming-la mangata kamananga-kaming kam nge ngau tagataga negu. ");
INSERT INTO mva_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Tamagu-la irereretaka bokana, ngau ambe kam urereretaki-kaming. Bokaibe ngau-la reretaka negu-lo kamasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pilengagu kalongo be katagatagadi masa mrereretaki-kaming-la, ngau-la Tamagu pilenga ulongolongo be utagatagadi be irereretaka bokana. ");
INSERT INTO mva_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ngau urere suri-uia negu kam-lo daeno be suri-uia ngaedi nge iloming-lo dakauri. Bokai masa suri-uia neming ngaedi nge ere-moarunga be iloming-lo daeneno. Nge bokai ka pile ngaedi ura-kaming. ");
INSERT INTO mva_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Mata negu biabiatuka uiang-kaming nge bokai: Neming-la kamaerereretaki, ngau-la urereretaki-kaming bokana. ");
INSERT INTO mva_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bokai kamakaua: Tamoata naita ruanga irereretakidia-tina, be ono reretaka ne ngaedi mangata ngananga kana nge masa ruanga ngaedi kanabe ngamate. ");
INSERT INTO mva_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pilengagu kadoki be katagatagadi nge kam ngau ruangagu. ");
INSERT INTO mva_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ambe tago malipilipi negu kana mkilakila-kaming kana. Rakana teke malipilipi kata bibiadi ne iememaki nge malipilipi tago ikauataki. Nge bokai ka ruangagu kana mkilakila-kaming kana, bakara, pile moarunga Tamagu-lo udoki nge urakaming-doi be ono rakana ngaemaki kana be ilo ilelenaki nge kakauataki. ");
INSERT INTO mva_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ngau nge tago kam ka kadoka be kanangaia. Tago. Ngau ka udoki-kaming be unanga-kaming be kamalale be kalingo-ming kamapuraki kana. Be kalingo-ming kapupuraki ngaedi masa nem-kueno daeneno. Bokai masa ara-guo be kana teke kareretaki be Tama-gu kasinaui nge ngang-kaming kana. ");
INSERT INTO mva_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mata negu uiang-kaming nge bokai: Neming-la kamaerereretaki. ");
INSERT INTO mva_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tamoata be aine moarunga kateka-o disegeaki-kaming nge ilo-ming bokai dakaua: ngau disegeakau-mua. ");
INSERT INTO mva_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kam kateka-tamoata bokana nge ambe tamoata be aine kateka-o nge nedi bokana darereretaki-kaming. Ata kam tago kateka ngae tamoata ne. Tago-la. Kam nge kateka ngaena-lo ka ngau udoki-kaming be unaguraki-kaming be ngau bokana kapura. Nge bokai ka tamoata be aine moarunga kateka-o disegeaki-kaming. ");
INSERT INTO mva_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pile ngaedi ambe ura-kaming nge ilo-ming dandi, ‘Malipilipi tago biabiadi ne iuasai.’ Ngau sururu bibia dana masa kam bokainatuka-la sururu bibia dang-kaming. Sulengagu dalongo be datagadi masa kam sulenga-ming dalongo be datagadi. Tago be tago! ");
INSERT INTO mva_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Masa ngau ara-guo be bokai dabasaki-kaming, bakara, naita ka nepinepi negu nge tago dikauataki. ");
INSERT INTO mva_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tago mpura be mradi ngau Tamagu-lo ka upura nge ambe muzigoala nedi tago. Ata nge ambe upura be uradi. Bokaibe tago iboadu zala dalelei be ono muzigoala nedi ngaedi dasibongaki. Tago-la. ");
INSERT INTO mva_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bokaibe, tamoata naita isegeaka nge Tama-gu ka isegeaki. ");
INSERT INTO mva_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Malipi kaiboangdi ngau uememaki ngaedi nge tamoata tago teke iemaki. Bokaibe malipi kaiboangdi ngaedi tamoata be aine kateka-o maradi tago memaki bokana nge ambe tago iboadu muzigoala daemaki. Ata nge ambe kilala kaiboangdi uememaki nge dita. Moimoi kana ngaedi dita, ata Tama-gu keru disegeaki-kamairu! Bokaibe zalakadi ono dasibo kana nge tago. ");
INSERT INTO mva_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ata bokai dimuzi be ono pile tekedi Moses Mata nena-lo dieno nge dikalingo. Pile ngaedi nge bokai, ‘Labu tagonganaba-lo disegeaka.’ ");
INSERT INTO mva_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Dumaduma neming masa mnepi be ngapura. Be nge ngai ka ngau mangata ngarangaka kana. Dumaduma ngae nge Tamagu-lo isoaki ka mnepi be ngapura kana. Ngai ka pile kalingodi labudi, be Tamagu-lo ka ipusika. ");
INSERT INTO mva_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Be kam nge bokaina-doi kamabasaka: mangata kamarangaka. Maka ma kam ka matamatanatina-la be sakeguo kasukoaki.” ");
INSERT INTO mva_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Pile moarunga ngaedi nge ambe urakaming-doi. Bokai masa tago iboadu kamatamong be lama unianga-ming kamarokaki. ");
INSERT INTO mva_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Masa pera ono serereinga nedia-lo datao-kaming be tago kamalakolako. Moimoina-tina masa bong teke ngapura, be bong ngaranao masa ilodi dapile Nanaranga malipi ne ka diememaki be daumoate-kaming. ");
INSERT INTO mva_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kana ngaedi nge daemaki-la be kana! Maka ma Tama-gu tago dikauataki, be ngau tago dikauataka. ");
INSERT INTO mva_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ata ngau ambe urakamingba-mua. Alauri kana ngaedi dipura masa kamakaua ngau ambe ilo-kaua uiangkaming-doi. Ata nge isi makare sakemingo usoaki. Nge bokai ka tago norane be ura-kaming. ");
INSERT INTO mva_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ngau ambe nepinepi negu inepia be makare upura-lo ulakolako. Ata tago teke bokai kutegia, ‘Inanga kulakolako?’ ");
INSERT INTO mva_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Upile mpereki-kaming kana ngena ilo-ming dibuku! ");
INSERT INTO mva_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ata moimoi ka ura-kaming. Kam kana ka mialale kana. Tago ualale nge Dumaduma neming tago iboadu ngapura. Mialale masa mnepi be ngapura. ");
INSERT INTO mva_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bong Dumaduma ngapura masa muzigoala labu, Nanaranga matanao ado labu, be giriki lilita be adoraka labu tamoata be aine moarunga kateka ngaena-o ngaitikingdi be dakaua. Tamoata be aine kateka-o ilodi dipile kana ngaedi labudi dikauataki, ata tago dikauataki. ");
INSERT INTO mva_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ilodi dipile muzigoala labu dikauatakia-uia, ata tago. Maka ma lama tago diunana. ");
INSERT INTO mva_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Be ilodi dipile Nanaranga mata-nao ado dikauataki, ata tago. Maka ma ngau Tamagu-lo mlako kana, be makara nge tago iboadu kamatea. ");
INSERT INTO mva_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ilodi dipile giriki lilitadi be adorakadi labu dikauataki, ata tago. Maka ma kateka ngae anuatanepoa kana ambe giriki ne lilitadi dipura be ileua ka isoaki. ");
INSERT INTO mva_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kana kokoko-tina mrangaki-kaming kana, ata kaituka-tina masa tago kaboadu pile mra-kaming kana nge labudi moarunga kamadoki be kamakauataki. ");
INSERT INTO mva_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ata bong Oli Spirit ngapura masa ngasingara-kaming be pile kalingodi nge labudi kamakauataki. Oli Spirit ka pile kalingodi moarunga labudi. Tago masa ne pile ne ka ngapile kana. Tago. Pile ilongo-ma nge ka ngapile kana! Be kana alauri dapura kana nge masa ngarangaki-kaming. ");
INSERT INTO mva_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pile negu ka ngadoki be ngarangaki be kamakauataki kana. Bokai masa ara-gu atabala-tina nganangai. ");
INSERT INTO mva_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Maka ma Tama-gu kana ne moarunga nge ngau-doi negu. Nge bokai ka ngau bokai upile Oli Spirit masa pile negu ngadoki be ngarangaki be kamakauataki. ");
INSERT INTO mva_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Uanana tago sasalaga isi dieno be masa tago kamatea. Ata alauri masa uanana tago sasalaga be kaba kamatea.” ");
INSERT INTO mva_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iesus bokai ipile nge tagataga ne alu nedia-la bokai diepilei, “Pile ira-kita nge labudi baituka? Pile-ma ngaediare, ‘Uanana tago sasalaga be masa tago kamatea be alauri masa uanana tago sasalaga be kababe kamatea.’ Be pile ne takadi bokai ipile, ‘Tamagu-lo mlako kana.’ ");
INSERT INTO mva_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pile ‘bong tago sasalaga’ nge labudi baituka? Pile ipilepile ngaedi nge kita labudi tago takaua!” ");
INSERT INTO mva_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ata Iesus ikaua ambe dategi kana nge bokai iradi, “Masa bokai upile, ‘Uanana tago sasalaga isi dieno be masa tago kamatea, be uanana tago sasalaga be kaba kamatea,’ ka neming-la kaetegitegi ki? ");
INSERT INTO mva_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Moimoi ka ura-kaming! Kam masa kamanodo be kamatang, ata tamoata be aine kateka-o masa suridi dauia. Ilo-ming masa danodo-tina, ata ilo-nodo neming masa ngatabuli be suri-uia ngapura. ");
INSERT INTO mva_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Bokai mtonanga: Aine tinetine bong ono nekinga ne dapura masa sururu ngadoki. Ata ambe ineki-doi nge suri dauiani, bakara, natu teke ambe kateka ngaenao inekiaki. Be sururu ne idoki nge ilo daleuataki. ");
INSERT INTO mva_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Be kam nge masa bokainatuka-la kana. Bong ngaedia-lo masa kamanodo-tina, ata alauri mte-kaming masa suri-ming dauia-tina kana. Be suri-uia neming ngaedi nge tagona-tina iboadu tamoata teke ngadokile-kaming. ");
INSERT INTO mva_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Be ramani bong ngae ipura masa tago kana teke kanabe ngau kamasinauia. Moimoi ka ura-kaming! Rakana teke ara-guo be Tama-gu kasinaui nge ngangkaming-la be kana! ");
INSERT INTO mva_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Toira be imai nge tago sesu katoi be ara-guo be kasinau. Ata nge kodeka aragu-o be kamasinau masa kana kasinautaki nge kamadoki. Bokai masa suri-ming dauia-tina, be bokaina-la dauiauia. ");
INSERT INTO mva_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ngau pile karamuamuakadi ane be urara-kaming. Ata alauri masa bong tekedi dapura, be bong ngaradia-lo masa tago pile bokainaina ane be mra-kaming. Tago. Masa pile mangatangata ane be Tama-gu mrangaka-kaming. ");
INSERT INTO mva_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Be bong ngae ipura masa ara-guo be Tama-gu kamasinaui. Nge tago upile masa ara-mingo be Tama-gu msinaui. ");
INSERT INTO mva_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Tago-la! Maka ma Tama-gu nena-la be irereretaki-kaming. Ngau karereretaka ka Tama-gu irereretaki-kaming, be lama kauni ngau Tamagu-lo ka upura. ");
INSERT INTO mva_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngau Tamagu-lo be makare kateka-o upura, be ambe kateka ngae mpereki be Tamagu-lo mlako kana.” ");
INSERT INTO mva_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kodeka tagataga ne bokai dipile, “Gote, kodeka pile adoado kupilepile. Tago pile karamumuaki ane be kupilepile. ");
INSERT INTO mva_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kodeka kikaua kaiko kana moarunga kukauataki. Bokaibe, nge bakara ka gategiko be ono kana moarunga gakauataki? Maka ma keka ambe kikaua kaiko kana moarunga kukauataki! Be nge kodeka lama kiuni kaiko Nanaranga-lo ka kupura.” ");
INSERT INTO mva_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Be Iesus ikatu be bokai iradi, “Kodeka lama kauni ki? ");
INSERT INTO mva_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ata bong teke masa ngapura, be ambe ipura. Bong ngaranao masa kamairatu-ramo be anua nem-nem kamalako be rubegu-ba kamapereka be msoaki. Ata masa tago rubegu-ba msoaki. Tago! Tama-gu masa sakeguo ngasoaki. ");
INSERT INTO mva_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Kana ngaedi nge urakaming-ba mua. Bokai masa ngau-lo be masa ilo-uia kamate be tamoata teke bokana kamasukoaki. Moimoi kateka ngaenao masa moatubu bibia kamaitaita, ata kam kamakaiboang-tina! Maka ma ngau ambe kateka ngae kaiboang ne moarunga uduaposa be ubalaki!” ");
INSERT INTO mva_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesus pile ngaedi ipile-doi kodeka lang-lo itadalako be bokai irabo, “Mamo! Bong negu ambe dipura! Natum kaiboang be malama ne mangata gonanga. Bokai masa Natum ngataguraki be kaiboang be malama nem mangata ngananga. ");
INSERT INTO mva_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Maka ma kaiboang moarunga ambe Natum luma-nao kusalangaki, be tamoata be aine moarunga kateka-o nge Natum eruma disoaki. Bokai masa tamoata be aine moarunga ne bokana kuiani nge ngaia-lo be moauriuri-la nem-kusoaki dasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kaiko kukaua moauriuri-la nem-kusoaki soaki ipurapura nge labu bokai: Masa dakaua kaiko nge moimoi be Nanaranga be rubem-la ka Nanaranga. Be masa bokai dakaua Iesus Kristus nge kaiko ka kunepi be makare ipura. ");
INSERT INTO mva_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Malipi nem kuiana be kateka ngaenao memaki be ono kaiboang be malama nem mangata mnanga kana nge ambe umambuaki-doi. ");
INSERT INTO mva_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mamo! Matamata isi kateka ngae tago emaka ipura be kaiboang malamakadi otioti dieno-kitaru ane be matam-o be kaiboang be malama negu mangata gonanga. ");
INSERT INTO mva_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tamoata be aine kudokidi kateka ngaenao be ngau kuiana ambe mangata unangaiko be diteko. Tamoata be aine ngaedi nge kaiko-ma nem-re! Be ambe kudokidi be ngau kuiana be pilengam didoki be ditagatagadi. ");
INSERT INTO mva_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Kodeka dikaua kana moarunga kuiana nge kaiko-lo ka dipura. ");
INSERT INTO mva_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Maka ma pile kuiana nge ambe uiandi be didoki. Di moimoi be dikaua ngau kaiko-lo ka upura, be lama diuni kaiko ka kunepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Be nge di kana ka uraborabo. Di ka tamoata nem be kudokidi be lumagu-o kusalangakidi. Nge tago tamoata be aine moarunga kateka ngaenao kana ka uraborabo! Tago! ");
INSERT INTO mva_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Maka ma kana negu moarunga nge kaiko nem, be kana nem moarunga nge ngau negu. Be dia-lo ka kaiboang be malama negu mangata dipusika. ");
INSERT INTO mva_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ambe tago makare kateka-o msoaki kana, ata di isi makare kateka-o dasoaki be ngau kaiko-lo mpura kana. Mamo! Kaiko Kusim Rata! Aram kaiboang ne ane be goioiakidi be aurukam-lo dasukoaki. Aram ngae ka ngau kuiana. Bokai masa di tamoata teke bokana dasukoaki, kitarua-la tekedaru tasukoakiru bokana. ");
INSERT INTO mva_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sakedi-o usoaki nge aram kaiboang ne kuiana ane be uoioiakidi be tago sesu ba diuai. Be aurukagu-lo disoaki be tago teke ileua. Tamoata-la matamata be rangaka ipura ngaleua kana nge ka ileua. Takadi tago. Tamoata ngae ngaleua be masa pilengam ‘Buku’ nem-lo geretadi dipura nge ngaemaki be dakalingo. ");
INSERT INTO mva_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Mamo! Ambe kaiko-lo mpura kana. Kana ngaedi nge isi makare kateka-o usoaki be urangaki. Bokai masa suri-uia negu ere-moarunga be dia-lo ngaeno. ");
INSERT INTO mva_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Pilengam ambe uiandi, ata tamoata be aine kateka ngaenao nge disegeakidi. Di nge ngau bokana, tago kateka ngaena-onaona kaoa. ");
INSERT INTO mva_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tago godokidi be kateka ngae dapereki kana ka usinauiko. Tago. Nge goioiakidi be aurukam-lo dasukoaki kana ka usinauiko! Satang ngarepekidi takana! ");
INSERT INTO mva_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Di nge tago kateka ngae tamoata kaoa. Be ngau bokai, tago kateka ngae tamoata kata. ");
INSERT INTO mva_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pilengam moarunga nge moimoi be kalingodi. Bokaibe pilengam kalingodi ngaedi ane be kusidi goaka-rati be gozageakidi be malipi nem daememaki. ");
INSERT INTO mva_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ngau-la kateka ngaenao kunepiauria bokana, ngau ambe kateka ngaena-lo unepidialako. ");
INSERT INTO mva_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Be nge di kana ka negu-la uzageaka be ono malipi nem ratadi uemaki. Bokai masa di moimoi be nedia-la dazageakidi, be ono malipi nem ratadi daemaki. ");
INSERT INTO mva_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nge tago dia-la kana ka urabo. Tago. Tamoata alauri pilengagu dandi be dadoki be lama dauni kana nge urabodi be. ");
INSERT INTO mva_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ngau urere tamoata teke bokana dasoaki. Mamo, kaiko-la ngau-lo kusoaki be ngau kaiko-lo usoaki bokana, bokainatuka-la, ngau urere di kitarua-lo dasoaki. Bokai masa tamoata be aine moarunga kateka-o lama dauni kaiko ka kunepia be kateka-o upura. ");
INSERT INTO mva_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngau ambe kaiboang be malama kuiana nge uiandi, be ono tekedi bokana dasukoaki, kitarua-la tekedaru tasoakiru bokana. ");
INSERT INTO mva_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Di zaiza bokainatuka taetekenanai: Ngau dia-lo usoaki, be kaiko ngau-lo kusoaki. Ngau urere tekedia-tina dapura. Bokai masa tamoata be aine moarunga kateka-o dakaua kaiko ka kunepia be makare upura, be kaiko di kurereretakidi, ngau-la kurereretaka bokana. ");
INSERT INTO mva_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mamo! Ngau urere tamoata be aine ngau kuiana nge sakegu-o kaba odi-o usukoaki-lo dasukoaki. Bokai masa kaiboang be malama negu mangata daeno be daita. Kaiboang be malama ngaedi nge kaiko ka kuiana, bakara, kateka ngae isi tago emaka ipura be kaiko kurereretakau-tina. ");
INSERT INTO mva_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mamo! Kaiko adoadom-tina! Moimoi tamoata be aine moarunga kateka-o nge tago dikauatakiko, ata ngau ukauatakiko. Be tamoata ngaedi ngau kuiana nge dikaua kaiko ka kunepia be makare upura. ");
INSERT INTO mva_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ngau ambe dia-lo mangata unangaiko, be masa bokai muzimuzi-la. Bokai masa reretaka nem ngau-lo dieno nge dia-lo daeno, be ngau negu-la masa dia-lo msoaki.” ");
INSERT INTO mva_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesus irabo-doi kodeka tagataga ne zaiza Kidron dugua ditotoki be ege takaianao dilako. Ege ngaranao nge ‘olib’ uma teke ieno be makara dilako. ");
INSERT INTO mva_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iesus tagataga ne zaiza bong kokoko makara diepurapurari. Bokaibe Iudas maka Iesus ngadoki be erekei luma-dio nganangai kana nge kaba ngaradi ikauataki. ");
INSERT INTO mva_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Bokai ka Iudas nena-la be makara ipura. Rom koai-bagi tamoata kokoko be tamoata Nanaranga pera ne dinarinaringi nge alu Iudas ibagadi be dipura-budu. Parasi be tamoata Nanaranga ditabatabai dimuamuadi dinepidi ka Iudas zaiza be dipura. Baratui be koalea be kana ono eunga didokidoki be dipura. ");
INSERT INTO mva_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ata Iesus ikaua rakana ngapurani kana. Bokaibe arodi itui-lako be bokai itegidi, “Naita kalelelei?” ");
INSERT INTO mva_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Be di dikatu be bokai dipile, “Nasaret tamoata ara Iesus!” Be Iesus bokai iradi, “Ngau maka!” Iudas, maka Iesus idoki be erekei luma-dio inangai nge makara tamoata ngaedi zaiza dituitui-budu. ");
INSERT INTO mva_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Bong Iesus bokai ipile, “Ngau maka,” nge moarunga disoro be kateka-o ditapuloria. ");
INSERT INTO mva_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Makara nge Iesus kaba itegidi, “Naita ka kalelelei?” Be di bokai dipile, “Nasaret tamoata ara Iesus!” ");
INSERT INTO mva_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kodeka Iesus bokai iradi, “Ambe urakaming-doi ngau ka ngai. Ngau ka kalelelea nge tamoata ngaedi kamalikitakidi be dalale.” ");
INSERT INTO mva_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nge ono pilenga tekedi matamata be ipile nge dakalingo kana ka bokai ipile. Matamata be Iesus bokai ipile, “Tamoata kuiana nge tago teke urokaki be ileua.” ");
INSERT INTO mva_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pita nge asi ono eunga teke ibagabagai. Makara nge ipasiki be tamoata Nanaranga ditabatabai biabiatuka nedi nge malipilipi kana itarapoaki. Itarapoaki nge kungi uana itaratotoki be itakoro. Malipilipi ngae ara Malkus. ");
INSERT INTO mva_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Makara nge Iesus itaguraki be Pita bokai iebuloi, “Asi nem kabana-lo gomuleaki. Ilom ipile ngau tago uboadu sururu bibia Tama-gu ngana kana nge mdoki ki?” ");
INSERT INTO mva_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kodeka Rom koai-bagi tamoata nge pangana nedi zaiza be Iuda tamoata nedi bibia ditaguraki be Iesus didokimatei be diuauri. ");
INSERT INTO mva_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Be dibagai be Ananias-lo dilakuaki. Ananias natu aineka nge Kaiapas iuati. Be barasi ngaranao nge Kaiapas ka tamoata Nanaranga ditabatabai biabiatuka nedi. ");
INSERT INTO mva_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas ka norane be Iuda bokai isingaradi, “Tamoata teke moarunga lilidi-o be imate nge iuia.” ");
INSERT INTO mva_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita be tagataga takaia nge Iesus muri ditagaiaru. Tamoata Nanaranga ditabatabai biabiatuka nedi nge tagataga takaia ikauatakia-uia. Bokaibe Iesus diaru be tamoata biabia ngae pera kana ari-dialo disili-buduru. ");
INSERT INTO mva_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ata Pita eluku babaduadua-lo isoaki. Kodeka tagataga takaia ipusika be aine pera babaduadua inarinaringi nge irai be Pita ibagai be isiliaki. ");
INSERT INTO mva_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Makara nge aine babaduadua inarinaringi Pita bokai itegi, “Moimoi kaiko tamoata ngae tagataga ne kata?” Be Pita ikatu be bokai ipile, “Ngau tago!” ");
INSERT INTO mva_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Madidi nge ilaba-tina. Bokaibe tamoata Nanaranga ditabatabai biabiatuka nedi malipilipi kana be tamoata Nanaranga pera ne dinarinaringi nge eoa tekedi ditau be diboaling be diboatoboato. Be Pita ilako be ditui-budu be eoa iboatoboato. ");
INSERT INTO mva_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kodeka tamoata Nanaranga ditabatabai biabiatuka nedi nge itaguraki be Iesus tagataga ne be sulenga itegiaki. ");
INSERT INTO mva_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Be Iesus ikatu be bokai ipile, “Ngau mangata ka tamoata be aine moarunga usulesuledi. Sulengagu moarunga nge pera ono serereinga-lo be Nanaranga pera nena-lo be uememaki. Makara ka Iuda moarunga dipurapura be dikabukabuni. Tago sesu zuguma-lo be pile negu usuletaki. Tago-la! ");
INSERT INTO mva_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nge bakara ka ngau kutegia? Tamoata dilongolongora ka gotegidi. Pile bakarairai upilepile nge di dikaua.” ");
INSERT INTO mva_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesus bokai ipile nge tamoata Nanaranga pera ne dinarinaringi teke itaguraki be izamposani be bokai irai, “Kaiko naita kata ka pile bokainaina ane be tamoata Nanaranga ditabatabai biabiatuka nedi bokai kurai?” ");
INSERT INTO mva_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Be Iesus ikatu be bokai irai, “Pile tago uia kaoa ka upile nge mangata gopile be tamoata makare disoaki dalongo. Ata nge pile kalingodi ka upile, bakara ka kuzamposana?” ");
INSERT INTO mva_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iesus isi uauauri-la isoaki be Ananias itaguraki be tamoata Nanaranga ditabatabai biabiatuka nedi ara Kaiapas-lo inepalako. ");
INSERT INTO mva_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita nge isi makarana-la eoa iboatoboato be isoaki. Kodeka tamoata takadi disoaki-budu nge bokai ditegi, “Kaiko tamoata ngae tagataga ne kata ki?” Be Pita iaoli be bokai ipile, “Ngau tago!” ");
INSERT INTO mva_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kodeka tamoata Nanaranga ditabatabai biabiatuka nedi malipilipi kana teke Pita bokai irai, “Kaiko-tina bokana ‘olib’ uma-lo tamoata ngae zaiza be uteko?” Tamoata ipile nge Malkus dara ne kata. Malkus kungi takaia ka Pita itaratotoki. ");
INSERT INTO mva_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Makara nge Pita kababe iaoli be bokai ipile, “Ngau tago!” Bokai ipile nge oaikiki-tina mang ikatararaua. ");
INSERT INTO mva_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Anua nge ambe ngazama kana. Kodeka Iesus nge Kaiapas pera kanana-lo ka dibagai be Rom tamoata nedi biabia ara Pailot pera kanana-lo dilakuaki. Iuda tamoata nge ‘Pasoba’ moanako dakani kana, be direre mata nedia-lo goagoaza-la dasoaki. Bokaibe Pailot pera kanana-lo tago disili. Maka ma tago direre dabolo. ");
INSERT INTO mva_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kodeka Pailot ipusika be bokai itegidi, “Giriki nangatadi ka tamoata ngaenao kanangalako?” ");
INSERT INTO mva_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Be di dikatu be bokai dirai, “Giriki tago ngaemaki nge tago iboadu kaiko-lo gaeluaki! Nge giriki iemaki!” ");
INSERT INTO mva_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ata Pailot bokai ipile, “Kam neming-la be kamabagai be mata neming kamatagadi be giriki ne kamaliliti!” Makara nge Iuda dikatu be bokai dirai, “Iei! Mata nema dibabari-kama keka tago kiboadu tamoata teke gaumoatei!” ");
INSERT INTO mva_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kana ngaedi bokai dipura be ono Iesus pilenga tekedi norane be ipile nge dikalingo. Norane be Iesus mate bakarairai ngamate kana nge irangaki-doi. ");
INSERT INTO mva_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Makara nge Pailot kaba pera kanana-lo isili be Iesus ikilai be bokai itegi, “Kaiko Iuda anuatanepoa kandi ki?” ");
INSERT INTO mva_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ata Iesus bokai itegi, “Tegi ngae nge nem ilom-lo ka ipura ki tamoata takaia ka iraiko?” ");
INSERT INTO mva_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Be Pailot ikatu be bokai irai, “Ngau Iuda kata ka masa tegi ngae ilogu-lo ngapura? Iuda ruangam be tamoata Nanaranga neming ditabatabai dimuamuadi ka didokiko be ngau-lo dieluakiko. Rakana giriki kuemaki?” ");
INSERT INTO mva_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Be Iesus ikatu be bokai ipile, “Anua ono mtanepoa kana nge tago kateka ngaenao ieno. Anua negu ono mtanepoa kana makare kateka ngaenao ngaeno bokana nge ambe malipilipi kanagu daoiaka be Iuda tago iboadu dauaura. Ata nge anua negu ono mtanepoa kana nge kaba takadia-lo ieno.” ");
INSERT INTO mva_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kodeka Pailot bokai itegi, “Kaiko anuatanepoa kata ki?” Be Iesus ikatu be bokai ipile, “Moimoi ka kupile ngau anuatanepoa kata! Nge labu ngaenao ka kateka ngaenao nekiakagu ipura. Malipi negu kateka ngaenao nge pile moimoi be kalingo mangata mrangaki kana. Tamoata moarunga pile moimoi be kalingo ilona-lo disoaki nge ngau dilongolongora.” ");
INSERT INTO mva_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Be Pailot itaguraki be Iesus bokai itegi, “Pile moimoi be kalingo nge rakana?” Pailot bokai itegi, kodeka ipusika be Iuda bokai iradi, “Giriki labu tago teke uteani! ");
INSERT INTO mva_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ata mata neming tekedi bokai dieno: ‘Pasoba’ bong-lo nge tamoata uaura-lo disoaki maradi teke mrubetaki be miang-kaming. Karere Iuda anuatanepoa kana-ming mlikitaki be ngalale ki?” ");
INSERT INTO mva_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Be di dimere be bokai dipile, “Ngai moaki! Barabas gorubetaki be goang-kama!” Barabas nge koai biabia teke ungguma Rom iemakadi ka uaura-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Makara be Pailot ipile be Iesus rautotoka ipura. ");
INSERT INTO mva_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Kodeka koai-bagi tamoata ditaguraki be anuatanepoa kusi-sili nedi sasalaga dadara nge teke Iesus disiliakani be kauta teke oarige ragaragadi oti diraulemoang nge didoki be pangana-nao dinangai. ");
INSERT INTO mva_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kodeka ono disamanaganaga be bokai dirarai, “Iuda anuatanepoa kandi, iboadu soakingam dasalaga-tina!” Be dilakolako be lili-nao dizamposaposani. ");
INSERT INTO mva_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Kodeka Pailot kaba ipusika be Iuda bokai iradi, “Kamate, ambe mdokamai be ono kamakaua ngau giriki ne labu tago teke ute.” ");
INSERT INTO mva_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Bong Iesus ipusika nge kauta oarige ragaragadi oti ememaki be kusi-sili daradara inangananga be ipusika. Ipusika-mai nge Pailot bokai ipile, “Kamate! Tamoata ngae maka!” ");
INSERT INTO mva_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bong tamoata Nanaranga ditabatabai dimuamuadi be Iuda tamoata nedi bibia Iesus dite nge dimere be bokai dipile, “Kai kapalapala uauau-o rokatagaka ngapura! Kai kapalapala uauau-o rokatagaka ngapura!” Makara nge Pailot bokai iradi, “Kam kamabagai be neming-la be kai kapalapala uauau-o kamarokatagaki. Ngau giriki labu tago teke ono utealako!” ");
INSERT INTO mva_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ata Iuda dikai be bokai dipile, “Keka mata nema teke ieno. Be mata nema ngae ipile tamoata ngae ngamate, bakara, ngai ipile ngai Nanaranga Natu, be Nanaranga diaru iriringa-diaru tekedi!” ");
INSERT INTO mva_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailot pile ngaedi ilongo nge kodeka taburi ira-tina. ");
INSERT INTO mva_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Be pera kanana-lo isili be Iesus bokai itegi, “Kaiko inanga kata?” Ata Iesus tago sesu pile ikatu. ");
INSERT INTO mva_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Makara nge Pailot bokai ipile, “Ngau raia-gu kusege ki? Tago kukaua ngau kaiboang dienona be uboadu mpile be rubetakam ngapura ki mpile be kai-o rokatagakam ngapura?” ");
INSERT INTO mva_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kodeka Iesus bokai ipile, “Nanaranga kaiboang iangko ka atabalagu kulako. Tago ngangko bokana nge tago kuboadu gobalaka. Bokaibe tamoata maka idoka be lumam-o inangaia nge muzigoala ne kaiko muzigoala nem diuasadi be dilako-tina.” ");
INSERT INTO mva_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailot bokai ilongo nge zala ilelei be ono Iesus ngarubetaki kana, ata Iuda isi bokai dimeremere be dipilepile-la, “Tamoata ngae kulikitaki be ialale nge kaiko tago ‘Sisa’ ruanga. Tamoata naita nena-la ipile ngai anuatanepoa kata nge ‘Sisa’ ka iduai.” ");
INSERT INTO mva_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailot bokai ilongo nge Iesus eluku ilakuaki be ilako be bagi ne ono giriki adorakao isoakiria. Bagi ono giriki adoraka nge pera ege ara “Patu Zala”-lo ka ieno. Ibru pile-lo nge “Gabata” kana dipile. ");
INSERT INTO mva_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ambe saringatuka amari malala ngaeno kana. Ngazama nge ‘Pasoba’ bong kana. Be nge amari ngaena-lo ka Iuda ngado nedi ono ‘Pasoba’ rakeaka dimoatautaungaki. Bokaibe Pailot itaguraki be Iuda bokai iradi, “Naka! Anuatanepoa neming maka!” ");
INSERT INTO mva_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ata di dikatu be bokai dipile, “Rokaka ngapura! Rokaka ngapura! Kai kapalapala uauau-o rokatagaka ngapura!” Ata Pailot kababe itegidi, “Kam karere anuatanepoa neming kai-o rokatagaka ngapura ki?” Ata tamoata Nanaranga ditabatabai dimuamuadi nge bokai dipile, “Keka anuatanepoa nema tagotago! ‘Sisa’ nema nge otioti!” ");
INSERT INTO mva_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kodeka Pailot itaguraki be Iesus idoki be iandi be kai-o rokatagaka ngapura kana. Kodeka Rom koai-bagi tamoata nge Iesus didoki be dibagai. ");
INSERT INTO mva_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Be nena-la be kai kapalapala uauau ne ibazi be kaba aradi “Tamoata Pangana Pakina-ba Kaba Ne”-nalo ilako. Ibru pile-lo nge Golgota kana ditugani. ");
INSERT INTO mva_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Makara nge kai kapalapala uauau-o dirokatagaki. Be tamoata rua nge Iesus zagenao kai kapalapala uauau-o dirokatagaki-diaru. Takaia oanana-o be takaia ngasina-o. ");
INSERT INTO mva_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailot ipile be pile tekedi digere be kai ono Iesus dirokatagaki-o diuauri. Bokainatuka digere, “Iesus Nasaret Tamoata, Iuda Anuatanepoa Nedi.” ");
INSERT INTO mva_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ierusalem-lo be golako kaba ono Iesus rokatagaka ipura kanana-lo nge tago kasau. Bokaibe Iuda kokoko-tina dipura be gere ngaedi dileze. Pile ngaedi nge pile bibia toli-lo digere: Ibru pile, Rom pile be Grik pile. ");
INSERT INTO mva_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Iuda tamoata nedi Nanaranga ditabatabai dimuamuadi pile ngaedi dita nge diebulo be Pailot bokai dirai, “Moaki Iuda Anuatanepoa nedi kana kugere. Bokai gogere, ‘Nena-la ipile ngai Iuda Anuatanepoa nedi.’” ");
INSERT INTO mva_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ata Pailot ikatu be bokai iradi, “Pile ngau ugere nge ambe ugere ka dieno. Bokaina-la daeno.” ");
INSERT INTO mva_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Rom koai-bagi tamoata Iesus dirokatagakia-doi, kodeka kusi ne inangananga nge didoki be subuka oati dinanga be teke-teke nedi didoki. Kusi-sili ne salagalaga eruma inanganangaia-la ka ieno. Kusi-sili ngae nge kusi-doi teke mapala ane ka emaka ipura, be atabala be ibala eruma nge kalaura tago. ");
INSERT INTO mva_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bokai ka Rom koai-bagi tamoata nge bokai dipile, “Kusi-sili ngae moaki tasereki. Guzui teke taemaki, be ono takaua masa naita ngadoki.” Tamoata ngaedi bokai dimuzi be pile tekedi Nanaranga ‘Buku’ nena-lo dieno nge dikalingo. Pile ngaedi nge bokai dieno: “Kusi negu unangananga dinege be nedi didoki. Be kusi-sili negu nge guzui teke diemaki be diuasai be didoki.” (Sam 22:18) Bokaibe koai-bagi tamoata ngaedi nge pile-la ngaedi ka ditagadi be bokai dimuzi. ");
INSERT INTO mva_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Makara kai kapalapala uauau Iesus ono dirokatagaki saringa nge tina Maria, tina taritoka, Maria Klopas roa, be Magdala aine ara Maria nge dituituito. ");
INSERT INTO mva_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesus tina be tagataga ne irereretaki dituitui-buduru be ite-diaru nge tina bokai irai, “Nge natum!” ");
INSERT INTO mva_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kodeka tagataga ne bokai irai, “Nge tinam.” Bokaibe bong ngaranao be ilako nge tagataga ngae Maria ibagai be pera kanana-lo isukoaki. ");
INSERT INTO mva_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Iesus ikaua kana moarunga ambe emakadi dipura be dimanubu, be ono Nanaranga ‘Buku’ ne pilengadi iemaki be dikalingo. Kodeka bokai ipile, “Madole umate.” ");
INSERT INTO mva_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","‘Uain’ kapisa nge makara tabira tekena-lo ieno. Bokaibe kusi mapala matoli teke didoki be ‘uain’ kapisa ngaena-lo dinangalako be kai ara ‘isop’ sapara tekenao dinangai be didokiteteki be Iesus uasi-nao dinangai. ");
INSERT INTO mva_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesus ‘uain’ kapisa ngae ising nge bokai ipile, “Ambe imanubu!” Kodeka pangana itobilaki be imate. ");
INSERT INTO mva_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Amari ono Iesus imate nge Iuda moarunga ngado nedi dimoatautaungaki be ono ‘Pasoba’ moanako dirakerakeaki. Ngazama nge ‘Sabat’ bong biabia teke kana. Bokaibe Iuda tago direre ‘Sabat’-o tamoata matedi bokai kai-o datobitobi. Makara nge dilako be Pailot ditegi be ae-di dakingkoto be daoridi kana. ");
INSERT INTO mva_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kodeka Rom koai-bagi tamoata nge dilako be tamoata rua Iesus zagenao dirokatagakidi nge ae-diaru dikingkoto. Takaia dikingkotoni be alauri nge dilako be takaia dikingkotoni. ");
INSERT INTO mva_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dilako be Iesus ae dakingkoto kana nge dite ambe imate ngena ae tago dikingkoto. ");
INSERT INTO mva_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ata Rom koai-tamoata teke itaguraki be io ne idoki be Iesus garangana-lo inagutobai be dara be dang dimumuraki. ");
INSERT INTO mva_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Tamoata kana ngaedi ita nge ambe mangata irangaki. Kana ngaedi mangata irangaki nge moimoi be kalingodi. Ngai nena-la ikaua pile ngaedi nge kalingodi. Bokai masa kam lama kamauni be.) ");
INSERT INTO mva_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kana ngaedi Iesus bokai dipurani be ono pile ngaedi Nanaranga ‘Buku’ nena-lo dieno nge dikalingo, “Tapou masa tago teke ngamakoto.” ");
INSERT INTO mva_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pile takadi Nanaranga ‘Buku’ nena-lo dieno nge bokai, “Tamoata io ane nagutobaia ipura masa tadala ngapura.” (Zek 12:10) ");
INSERT INTO mva_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Alauri nge Arimatea tamoata ara Iosep ilako be Pailot itegi be Iesus mate nge ngabagai kana. (Iosep nge Iesus tagataga ne kata, ata komangaba-lo. Ngai Iuda imatatakuridi.) Pailot isumoala be Iosep ialale be Iesus mate nge ibagai. ");
INSERT INTO mva_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tamoata teke norane be oabubu-lo Iesus ipurakani ara Nikodimas nge Iosep diaru dialale-buduru. Nikodimas nge ngesi boaudi otioti ono matedi dikirikiridi be ono tago oaikiki-la be dimoapurupuru nge idokidoki be dialaleru. Ngesi ngaedi nge kai ‘mir’ be ‘alo’ patudi oti ka diemaki be moatubungadi nge kaleti pile-lo ‘30 kilogrem’ bokana. ");
INSERT INTO mva_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dialaleru be Iesus mate dioriaru be ngesi ono matedi dikirikiridi ane dikiriaru, kodeka kusi ono matedi disukusukumdi ane disukumiaru. Ungguma Iuda nge tamoata matedi bokai dibabasakidi noko dikumkumrakidi. ");
INSERT INTO mva_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kaba ono Iesus rokatagaka ipura saringadi nge uma teke ieno. Uma ngae ilona-lo nge patu-boazinga ono tamoata kumraka teke ieno. Boazinga ngae isi oauoau-tina be tamoata tago teke isi ono kumraka ipura. ");
INSERT INTO mva_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bong ngaranao ka Iuda ngado nedi dimoataungaki be ngazama be ‘Pasoba’ darakeaki kana. Be patu boazinga ono tamoata matedi kumrakadi dipurapura nge ngarana-la ka makara saringa ieno. Bokaibe Iesus didoki be makara dilakuaki be dikumraki. ");
INSERT INTO mva_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Iesus kumraka ipura be izama be kaba irodo be izama nge Magdala aine Maria oabuna-tina isi tago izama-uia be boazinga ono Iesus kumraka ipura-lo ilako. Makara ipura nge patu ono poda aoa onota ipura nge ambe gegeaka ipura. ");
INSERT INTO mva_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Makara nge ipapanana-la be ialale be Saimon Pita be tagataga takaia Iesus irereretaki nge bokai ira-diaru, “Tanepoa ambe poda-nalo dipasiki be tago kikaua inanga dinangai!” ");
INSERT INTO mva_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kodeka Pita be tagataga takaia nge dialaleru be poda datearu kana. ");
INSERT INTO mva_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Dipapanana-lanaru be dialaleru, ata tagataga takaia Pita aro imua be poda-lo ilako mua. ");
INSERT INTO mva_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ilako-pura nge iboadukulako poda ilona-lo nge kusi ita, ata tago isililako. ");
INSERT INTO mva_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Pita alauri imai nge ilako-soasoa poda ilona-lo. Be kusi ono Iesus sukuma ipura ");
INSERT INTO mva_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","be kusi ono pangana disukumi nge bokai dieno be ita. Kusi ono pangana disukumi nge nena-la ilokumia-uia be muku laua-o ieno, tago kusi takadi zaiza dieno-budu. ");
INSERT INTO mva_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kodeka tagataga takaia ipura-mua nge isili. Isili be kana bokai ita nge lama iuni Iesus mate-lo be imarang. ");
INSERT INTO mva_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Maka ma imai be bong ngaradia-lo nge Nanaranga ‘Buku’ ne labudi isi tago dikauataki Iesus masa mate-lo be ngamarang.) ");
INSERT INTO mva_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Makara be tagataga ne ruoti nge anua-lo dimuleru. ");
INSERT INTO mva_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ata Maria isi makarana-la poda sakenao itui be itangtang. Itangtang-la be iboaduku be poda ilona-lo iela-lako ");
INSERT INTO mva_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","nge ‘enzel’ rua kusi oaoaoa dinanganangaru makara sakeka ono Iesus dinangai kanana-lo disoakiru be ite-diaru. Takaia pangana ieno kana isoaki, be takaia ae dieno kana isoaki. ");
INSERT INTO mva_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Makara nge tamoata ngae-diaru Maria bokai ditegiaru, “Aine, bakara ka kutangtang?” Be Maria ikatu be bokai ira-diaru, “Tanepoa negu dibagai be tago ukaua inanga dinangai!” ");
INSERT INTO mva_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria bokai ipile be ibuiri nge Iesus makara ituitui be ite, ata tago ikaua nge Iesus ka ituitui. ");
INSERT INTO mva_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Kodeka Iesus bokai itegi, “Aine, bakara ka kutangtang? Naita kulelelei?” Maria ilo ipileni tamoata uma makara iadoadoraki ka itegi. Be bokai irai, “Biabiadi, kaiko ka kubagai nge goraia inanga kunangai!” ");
INSERT INTO mva_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kodeka Iesus itaguraki be bokai ikilai, “Maria!” Makara nge Maria ibuiri be Iesus italari be Ibru pile-lo bokai ipile, “Raboni!” (Raboni nge “‘Tisa.’”) ");
INSERT INTO mva_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kodeka Iesus Maria bokai irai, “Moaki oguo kudauraki! Isi tago Tamagu-lo ulako. Goalale be taritokagu bokai goradi, ‘Ngau ambe Tama-gu be kam Tama-ming, be ngau Nanaranga negu be kam Nanaranga neming-lo mulelako kana.’” ");
INSERT INTO mva_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kodeka Magdala aine Maria nge ialale be tagataga ne iradi ngai ambe Tanepoa ite. Be pile Iesus irai nge tagataga ne iradi. ");
INSERT INTO mva_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nge ambe rairaituka bong ono Iesus imarango. Iesus tagataga ne nge Iuda dimatakuridi be pera ono disoaki nge babaduadua dionoti-matei be disoaki. Kodeka Iesus ipura be maradi itui be bokai iradi, “Ilo-uia kam-lo ngaeno!” ");
INSERT INTO mva_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bokai ipile, kodeka luma be ae itikingdi. Bong Tanepoa dite nge suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kodeka Iesus kaba bokai iradi, “Ilo-uia kam-lo ngaeno! Tama-gu inepia bokana, ngau mnepi-kaming kana!” ");
INSERT INTO mva_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Bokai ipile kodeka auka odio ieuri-lako be bokai iradi, “Oli Spirit kamadoki! ");
INSERT INTO mva_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Tamoata naita kateka-o muzigoala ne karokakile masa Nanaranga muzigoala ne ngaedi ngarokakile. Muzigoala ne tago karokakile masa Nanaranga tago iboadu ngarokakile!” ");
INSERT INTO mva_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Bong Iesus tagataga ne ipurakadi nge teke ara Tomas (ara takaia Didimas) nge tago disoaki-budu. Tomas nge Iesus tagataga ne kulemoa-be-rua kata. ");
INSERT INTO mva_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tagataga takadi Tomas dite be dirai di Tanepoa dite nge Tomas bokai ipile, “Luma ditobadi kana tago uita be kabogu tago unangalako, be garanga-nalo io oti dinagutobai kana luma-gu tago unangalako nge tagona-tina iboadu lama muni!” ");
INSERT INTO mva_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Amaridi lima-rua muridi nge Iesus tagataga ne kaba pera ilona-lo dikabuni be disoaki. Bong ngaranao nge Tomas zaiza disoaki-budu. Babaduadua nge dionoti-matei, ata Iesus ipura be maradi itui be bokai ipile, “Ilo-uia kam-lo ngaeno!” ");
INSERT INTO mva_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kodeka itaguraki be Tomas bokai irai, “Kabom makare gonangai. Luma-gu goita! Lumam gonanaraki be garangagu-lo gonangalako. Ilo-rua ilom-lo ieno nge gorokakia-tina, be lama-ba gouni!” ");
INSERT INTO mva_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Be Tomas ikatu be bokai ipile, “Tanepoa negu be Nanaranga negu!” ");
INSERT INTO mva_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kodeka Iesus bokai irai, “Kaiko kutea ka lama kuni! Ata tamoata tago itea, be lama-ba iuni nge suri dauiani!” ");
INSERT INTO mva_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesus kilala kaiboangdi kokoko-tina takadi tagataga ne matadio iemaki, ata ‘Buku’ ngaedia-lo tago geretadi dipura. ");
INSERT INTO mva_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Makare geretadi dipura nge kamaita be ono lama kamauni Iesus ka Kristus, Nanaranga Natu. Be lama kaunani masa ara-nao be moauriuri-la kamasukoaki. ");
INSERT INTO mva_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Alauri nge Iesus kaba tagataga ne dang biabia ara Taibirias zagenao ipurakadi. Iesus bokainatuka be ipurakadi: ");
INSERT INTO mva_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (ara taka Didimas), Kena anua ege Galili kaba-lo tamoata Nataniel, Zebidi natu ruoti be tagataga rua takadi nge makara Taibirias zagenao disoaki. ");
INSERT INTO mva_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Makara disoaki nge Saimon Pita bokai ipile, “Mlako be raka mrokaki be ika mdoki kana.” Makara nge tagataga takadi bokai dipile, “Talale-budu.” Be kati-o dibuli be dialale, ata oabubu ngarana-lo nge ika tago teke didoki. ");
INSERT INTO mva_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ambe anua izama-sereki nge tamoata teke kabu-lo ituitui, ata tagataga ne tago dikilalangi nge Iesus. ");
INSERT INTO mva_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Kodeka Iesus bokai itegidi, “Ruanga, ika teke kadoki ki tago?” Be di dikatu be dipile, “Tago-tina!” ");
INSERT INTO mva_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Makara nge Iesus bokai iradi, “Raka kana-ming kati ege oanana-o kamarokakalako masa ika alu kamadoki!” Kodeka raka kandi kaba dang-lo dirokakalako. Dirokakalako nge ika kokoko-tina dilako be tago diboadu darepeka-rake. ");
INSERT INTO mva_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Makara nge tagataga Iesus irereretaki nge Pita bokai irai, “Nge Tanepoa!” Saimon Pita bokai ilongo nge kusi-sili ne atabala inanganangai ipasiki be ieno nge kaba iokoria-ba be dang-lo inoku-lako be ingara be itoka. ");
INSERT INTO mva_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Be tagataga takadi nge kati-o be ika raka-lo dikauri nge dirape be Pita ditagai. Tago kasau-tina ka dipoatipoati. Masa kaleti ngaua-lo nge ‘90 mita’ bokana ka dipoatipoati. ");
INSERT INTO mva_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ditoka nge manggeta tekedi dikarakara be dita. Manggeta ngaedia-lo nge ika be ‘bereti’ dieno. ");
INSERT INTO mva_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kodeka Iesus bokai iradi, “Ika kaituka-tina kadoki alu kamadokimai.” ");
INSERT INTO mva_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Iesus bokai ipile nge Saimon Pita dang-lo itaolako be raka kabu-lo irepekaoro. Ika nge biabia-biabia rube ka didoki, moarunga. Moimoi ika kokoko-tina didoki, ata raka tago imasare. ");
INSERT INTO mva_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Kodeka Iesus bokai iradi, “Kamamai be kamamoanako!” Ata tagataga tago teke itegi, “Kaiko naita?” Di dikaua nge Tanepoa ka makara isoaki. ");
INSERT INTO mva_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kodeka Iesus ilako be ‘bereti’ be ika idoki be iandi. ");
INSERT INTO mva_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Mate-lo be imarang muri nge, nge bong tolia ka tagataga ne ipurakadi. ");
INSERT INTO mva_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Dimoanako-doi nge Iesus itaguraki be Saimon Pita bokai itegi, “Saimon, Zon natu, kaiko moimoi be kurereretaka be reretaka nem ngaedi nge tamoata ngaedi reretaka nedi diuasadi ki tago?” Be Pita ikatu be bokai pile, “E, Tanepoa! Kaiko kukaua ngau urereretakiko!” Kodeka Iesus bokai ipile, “‘Sipisipi’ natu negu goakokolangdi!” ");
INSERT INTO mva_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Be Iesus kaba bong ruaia itegi, “Saimon, Zon natu, kaiko moimoi be kurereretaka?” Be Pita ikatu be bokai ipile, “E, Tanepoa! Kaiko kukaua ngau urereretakiko!” Be Iesus bokai irai, “‘Sipisipi’ negu goarogurogudi!” ");
INSERT INTO mva_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kodeka Iesus kaba bong tolia itegi, “Saimon, Zon natu, kurereretaka ki tago?” Makara nge Pita ilo ibuku-tina, bakara, nge ambe bong tolia ka itegi, “Kurereretaka ki tago?” Bokaibe Pita bokai irai, “Tanepoa, kaiko kana moarunga kukauataki. Kaiko kukaua ngau urereretakiko!” Be Iesus bokai irai, “‘Sipisipi’ negu goakokolangdi! ");
INSERT INTO mva_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Moimoi ka uraiko. Isi amunangam-lo nge nem-la be kusi nem kuokoko be rerengam-lo inanga golako kana nge golako-ba. Ata ambe kukamoangbia masa lumam gonanaraki be tamoata takaia lumam ngauau be tago rerengam-lo ngabagaikolako.” ");
INSERT INTO mva_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesus bokai ipile nge Pita mate bakarairai ngamate be ono Nanaranga ara atabala-tina nganangai kana ka bokai ipile. Kodeka Iesus Pita bokai irai, “Gotagaia!” ");
INSERT INTO mva_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita ibuiri nge tagataga Iesus irereretaki nge muri itagatagai be ite. (Tagataga ngae ka Iesus moanako nena-lo Iesus saringanatuka isoaki be bokai itegi, “Tanepoa, naita ka erekei luma-dio nganangaiko kana?”) ");
INSERT INTO mva_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita tagataga ngae bokai ite nge Iesus itegi, “Tanepoa! Be tamoata ngae?” ");
INSERT INTO mva_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Be Iesus ikatu be bokai irai, “Ngau urere be moauriuri-la ngasoaki be kaba mule kana nge iboadu-tina! Bakara ka ilom ibuku? Ata kaiko gotagaia!” ");
INSERT INTO mva_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iesus pile ngaedi ipile nge pile tekedi bokainatuka ege-ege dilako tagataga ngae masa tago ngamate. Ata Iesus tago ipile tagataga ngae masa tago ngamate. Tago. Ngai bokai ipile, “Ngau urere be moauriuri-la ngasoaki be kaba mule kana nge iboadu-tina! Bakara ka ilom ibuku?” ");
INSERT INTO mva_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tagataga ngae ka kana ngaedi mangata irangaki be ambe ‘buku’-lo igere. Be kita takaua kana ngaedi nge moimoi be kalingodi. ");
INSERT INTO mva_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesus kana kokoko-tina takadi iemaki, ata tago geretadia-doi dipura. Ngau ilogu ipile geretadia-doi dapura nge ambe kateka ngaenao kaba tago daboadu ono ‘buku’ ngaedi daeno. Maka ma dikoko-tina! ");
INSERT INTO mva_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Biabiadi Teopilus, ‘Buku’ negu matamata ugere-lo nge kana moarunga Iesus iemaki be isuletaki nge ugere. Kana iemaki be isuletaki nge matamatanatuka imarangaki-lo ");
INSERT INTO mva_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nibe ilako bong etatabala lang anua-lo lakuaka ipura-lo daga. Ambe etatabala lang anua-lo lakuaka ngapura kana nge Oli Spirit kaiboang nena-lo be ‘apostel’ ne sikeng iandi. ‘Apostel’ ne ngaedi nge nena-la be idoki be inangadi. ");
INSERT INTO mva_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Imate be imarang nge bong kokoko-tina nena-la be muzi kolo-kolona-lo be nena-la mangata itikingdi be ono kaua ipura ngai moimoi be moauriuri isoaki. Kana ngaedi nge amaridi kulemoadi-oati ilodia-lo be iemaki. ‘Apostel’ ne moarunga nge dite be bong ono Nanaranga ngatanepoa kana nge irangakadi. ");
INSERT INTO mva_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Be bong teke diepurari be disoaki-budu be dimoanakonako nge bokai iradi, “Ierusalem anua moaki kapereki noko. Lumaluma maka Tamagu moimoi be irangaki be ngau ambe urangaki nge kamarapungi. ");
INSERT INTO mva_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Maka ma Zon dang-ba ane ka ruku ono tamalinga ane be tamoata be aine irukudi, ata kam masa saringatuka Oli Spirit kulubobi ane rukua-ming dapura.” ");
INSERT INTO mva_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bong ‘apostel’ Iesus zaiza diepurari be disoaki nge ‘apostel’ ditaguraki be Iesus bokai ditegi, “Tanepoa, masa bong ngaedia-lo be Israel anuatanepoa kandi kababe gomuleakadi be nedia-la dapapananuakidi ki?” ");
INSERT INTO mva_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Be Iesus ikatu be bokai iradi, “Bong nangata ki amari nangata kana ngaedi dapura kana nge Tamagu-la ka kana ne, be ngaia-la ka kaiboang nena-lo be iememaki. Be nge bokai ka kam tago kaboadu kamakaua bong nangatanao masa dapura. ");
INSERT INTO mva_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ata bong Oli Spirit oming-o ngabala masa kaiboang iloming-lo dakauri, be masa mata-ita negu bokana be Ierusalem anua-lo, ege moarunga Zudea kaba-lo be Samaria kaba-lo, be ngalako ege-ege kateka-o nge kamarangaka.” ");
INSERT INTO mva_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Pile ngaedi ipile-doi nge matadia-lo ka diteate be lang-lo ikautaki, be oaru teke isukumi be tago dite. ");
INSERT INTO mva_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Isi makara ditui be etatabala lang-lo ditadatadalako nge oaikiki-tina tamoata rua kusi oaoaoadi dinanganangaru nge dipuraru be bokai sakedi-o dituitui. ");
INSERT INTO mva_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Be bokai dipileru, “Galili tamoata, bakara ka bokai katui be etatabala lang-lo katadatadalako? Tamoata ngae Iesus maka mata-ming-lo be lang-lo bagalako ipura masa bokainatuka-la kateate be lang anua-lo bagalako ipura bokana be kababe ngamule.” ");
INSERT INTO mva_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Kana ngaedi muridi nge ‘apostel’ Olib buku dipereki be Ierusalem dilako. Kaba ngaradia-lo be ilako Ierusalem anua-lo nge kaleti ngaua-lo ‘kilomita’ teke. ");
INSERT INTO mva_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ierusalem-lo dilako nge pera ono disukoaki-lo disili. Pera ngae nge ilo atabalabala-lo ka disukoaki. ‘Apostel’ makara dipura nge: Pita, Zon, Zems, Endru, Pilip, Tomas, Batolomiu, Matiu, Alpeas natu Zems, Zilot kata ara Saimon, be Zems natu Iudas. ");
INSERT INTO mva_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Be bong kokoko nge diepurapurari be aine disukoaki-budu zaiza diraborabo. Iesus tina Maria be taritoka nge rabo ngaradia-lo dipurapura be. ");
INSERT INTO mva_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Be nge bong teke tamoata be aine maka Iesus lama diunani diepurari be disoaki ka Pita itui-rake be ngaradi kana. Tamoata be aine dipura nge kokotangadi ‘120’ bokana. Kodeka Pita bokai ipile, ");
INSERT INTO mva_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Taritokagu, Nanaranga ‘Buku’ ne bokainatuka be dikalingo: Toira be Debiti ipileba-mua Iudas masa tamoata maka Iesus dauauri kana nge ngamuadi be datagai be Iesus-lo ngalakuakidi. Pile ngaedi nge Oli Spirit ka ipilepile be Debiti aoa-nalo dipusika. ");
INSERT INTO mva_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Iudas nge kita kata, bakara nangaia ipura be malipi neda muku ngaemaki kana. ");
INSERT INTO mva_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","‘Mone’ maka Iudas idoki be ono mata ne goalakadi iemaki nge idoki be kateka teke ono izazai. Be nge makara ka nena-la itapai, be dabuliki idodoraki, be isapasi be izampoaki, be boura be tinae dimumuraki. ");
INSERT INTO mva_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tamoata be aine moarunga Ierusalem anua-lo nge kana ngae dilongoraki. Bokaibe kateka ngara nge pile nedia-lo bokai ditugani: Akeledama. Pile ngae labu nge bokai, ‘Dara Kateka.’ ");
INSERT INTO mva_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Maka ma ‘Buku’ ara ‘Sam’-lo nge Iudas rangaka bokai digere, ‘Pera kana iboadu pereka ngapura be ubana-ba ngaeno. Tamoata tago teke iboadu ono ngasoaki.’ (Sam 69:25) Be takadia-lo nge bokai dieno, ‘Tamoata takaia iboadu kaba ngadoki be malipi ne ngaemaki.’ (Sam 109:8) ");
INSERT INTO mva_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Bokaibe tamoata teke tanangai be Iudas kaba ngadoki. Tamoata ngae nge bong moarunga Tanepoa Iesus marada isoaki nge ngai zaiza talalale-budu. ");
INSERT INTO mva_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bong matamatanatuka Zon tamoata be aine irukurukudi be isulesuledi nibe imai Iesus bagaia ipura be ikautaki nge tamoata bokainaina nge marada-la isukoaki. Tamoata bokainaina ka tanangai kana. Bokai masa ngai mata-ita bokana be masa kita zaiza be Iesus mate-lo be maranga tarangaki.” ");
INSERT INTO mva_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bokaibe tamoata rua dirangakidi be takaia danangai kana. Tamoata ngae-diaru nge Iosep be Matias. Iosep ara takaia Barsabas. Bong alu nge Zastius kana kilaia ipurapura. ");
INSERT INTO mva_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kodeka bokai dirabo, “Tanepoa, kaiko ka tamoata be aine moarunga ilodi kukauataki. Tanepoa, bokaibe goitiking-kama tamoata ngae-diaru nge nangata ka kunangai ");
INSERT INTO mva_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","be malipi maka ‘apostel’ bokana Iudas ipereki be kabanatina-lo ilako nge ngadoki.” ");
INSERT INTO mva_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Dirabo-doi, kodeka ara ngae-diaru nge digere be dizumkaki be takaia direpeki. Ara maka direpeki nge Matias. Bokaibe Matias dokia ipura be ‘apostel’ kulemoa-be-teke zaiza dinangaia-budu. ");
INSERT INTO mva_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Bong biabia ara ‘Pentekos’ ipura nge tamoata be aine moarunga Iesus lama diunani nge kaba tekedia-lo diepurari be disoaki. ");
INSERT INTO mva_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Makara nge oaikiki-tina garurui kanabibia tekedi lang-lo dipurapura be dilongori. Garurui ngaedi nge suri oasa kanabiabia garuruinga bokana. Garurui ngaedi dipura nge pera ono disoaki nge disukumia-doi. ");
INSERT INTO mva_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kodeka kana teadi eoa pururuingadi bokana dita. Kana ngaedi nge ege-ege pera-lo dilako. Kodeka kana ngaedi nedia-la dienegei be dilako tamoata be aine moarunga makara disoaki nge teke-teke odio dibala. ");
INSERT INTO mva_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Be bong odio dibala nge teke-teke Oli Spirit kaiboang ne ilodia-lo ikauri. Makara nge ambe pile takadia-lo dipilepile. Oli Spirit ka kaiboang iandi be pile takadia-lo dipilepile. ");
INSERT INTO mva_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Makara Ierusalem-lo nge Iuda alu ege-ege kateka-o ka dipura nge disoaki. Tamoata ngaedi nge Moses Mata ne be Iuda mata nedi ditagatagadia-tina uia. ");
INSERT INTO mva_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Be bong garurui ngaedi dilongo nge dipura be makara tamoata be aine Iesus lama diunani disoaki kana dikabuni. Tamoata ngaedi nge dipitilaki-tina be ieboangi-ramo, bakara di teke-teke nge tamoata maka Iesus lama diunani pile-tina nedia-lo dipilepile be dilongoridi. ");
INSERT INTO mva_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iuda tamoata ngaedi nge dipitilaki-tina be panganadi ditatai be bokai dikabakidi, “Nge rakana ipura? Tamoata ngaedi maka dipilepile nge Galili tamoata kaoa! ");
INSERT INTO mva_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ata nge baituka be pile-tina neda-lo dipilepile be talongolongo? ");
INSERT INTO mva_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Kita nge ungguma ngaedi kaoa: Patia, Midia, Ilam, Mesopotemia kaba-lonalona, Zudea kaba-lonalona, Kapadosia, Pontus, Esia, ");
INSERT INTO mva_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia be Pampilia, Izip be kaba maka Sairini saringa dieno ege Libia kaba-lo. Be kita alu nge Rom kaoa! ");
INSERT INTO mva_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kita Rom alu nge Iuda kaoa be alu nge Ungguma Takadi ka Iuda mata nedi tatagatagadi kaoa. Be kita alu nge Krit be Arebia kaoa! Ata kita moarunga nge pilengadi pile-tina neda-lo dipilepile be talongolongo! Pile dipilepile nge kana kanabibia Nanaranga iemaki ka dirarangaki!” ");
INSERT INTO mva_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Makara nge dipitilaki-tina be aoa-diaba disanganga. Bokaibe nedia-la bokai dietegitegi, “Kana ngaedi nge labudi baituka?” ");
INSERT INTO mva_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ata alu ditaguraki be tamoata be aine lama diuni nge dingengeridi be bokai dipile, “Tamoata ngaedi nge ‘uain’ dising be diboang.” ");
INSERT INTO mva_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kodeka Pita ‘apostel’ kulemoa-be-teke zaiza ituirake be ipi-tina be tamoata be aine moarunga bokai iradi, “Iuda ruangagu be tamoata be aine makare Ierusalem anua-lo kasukoaki. Kamalongora! Kana ngaedi labudi mpasi be kamalongo. Be pile mpile kana nge kamalongo-tina uia. ");
INSERT INTO mva_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Keka tago ‘uian’ kising be kiboang, kam ilo-ming dipile bokana. Tago. Maka ma nge isi ‘9 kiloki’ oabunabiabia! ");
INSERT INTO mva_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bokainatuka kamakaua. Kana kaituka dipurapura nge toira-la ‘Propet’ Zoel igere bokana, ");
INSERT INTO mva_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Nanaranga bokai ipile, ‘Bong alalaurituka-lo masa Oli Spirit negu tamoata moarunga odio msuburakaria. Natu-ming moanekadi be ainekadi masa ‘propet’ bokana pile mumuakadi dapilepile. Tamoata amuna neming masa rai-kaba kalingodi daitaita, be kamoangbibia neming masa negu-la be raio kaba ita mianiandi. ");
INSERT INTO mva_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","E! Moimoi. Be bong ngaradia-lo masa Oli Spirit negu dududu kanagu moane be aine odio msuburakaria be. Be masa pile mumuakadi dapilepile. ");
INSERT INTO mva_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Be makatabala lang-lo masa kilala kaiboangdi memaki, be makeruma kateka-o masa kilala negu memaki. Be dara, eoa be kasu matolidi masa dapura. ");
INSERT INTO mva_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tanepoa Bong ne biabia malamaka otioti ngapura kana masa amari ngaoabubu be kalea masa dara bokana ngadaradara. ");
INSERT INTO mva_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Be bong ngaranao masa tamoata rangguma Tanepoa ara-nao be disinaunau uketadi be muleakadi dapura.’” (Zoel 2:28-32) ");
INSERT INTO mva_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Kam Israel tamoata kungi-ming kamananga be pilengagu ngaedi kamalongo! Nasaret tamoata Iesus ka mrangaki kana. Ngai moimoi Nanaranga ka idoki be iang-kaming. Be malipi ne nge mangata-tina iememaki be kaita. Ngai luma-nao ka Nanaranga itaguraki be kilala kaiboangdi, kilala Nanaranga-la iboadu ngaemaki be kilala takadiaba nge iememaki. Kam neming-la nge kana ngaedi kakauataki. ");
INSERT INTO mva_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nanaranga ne rerenga be kauangana-lo be toira be ilo itekenanai be ipile Iesus masa kam luma-mingo nangaia ngapura. Be ambe kadoki be tamoata muzigoala ememaki luma-dio kanangai be kai kapalapala uauau-o dirokatagaki. Nge kam ma ka kaumoatei! ");
INSERT INTO mva_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ata Nanaranga itaguraki be mate-lo be imarangaki. Nge ono mate sururu ne ngairatudi kana ka bokai ibasaki, bakara mate tagona-tina iboadu Iesus ngadokimatei. ");
INSERT INTO mva_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Maka ma Debiti bokainatuka Iesus irangaki, ‘Bong moarunga nge Tanepoa arogu isukoaki be uteate. Ngai oanagu-lanao ka isukoaki. Bokaibe tago iboadu ilogu ngabukuna. ");
INSERT INTO mva_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Labu ngaenao ka ilogu iuia-tina be pile moarunga upilepile nge suri-uia pile ka upilepile. Be kaniagu moarunga nge Nanaranga ono unangalako be urapurapu. ");
INSERT INTO mva_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bokai ka tago iboadu mariabakagu mate kaba-lo gopereki be ngasoaki. Be malipilipi kanam kusi-rata tago iboadu golikitaki be ngamoapuru. ");
INSERT INTO mva_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kaiko ambe zala ono moauringa-lo ilako nge kuitikina, be sakeguo kusukoaki nge kuememaka be surigu diuiauia.’ (Sam 16:8-11) ");
INSERT INTO mva_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Taritokagu, nge bokai nge bokai kamakaua. Bong Debiti pile ambe upile ngaedi ipile nge tago nena-la ka irangaki! Tago. Maka ma ngai ambe imate be kumraka ipura be poda isi kaituka makare sakedao ieno. ");
INSERT INTO mva_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Moimoi ngai ‘propet’ kata. Be pile moimoi be Nanaranga irai nge ikauataki. Nanaranga pile tago tototo ane be Debiti irai masa tubu teke alauri ngaia-la bokana anuatanepoa biabia ngapura. ");
INSERT INTO mva_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nanaranga rakana ngaemaki kana nge Debiti ita-doi. Bokaibe Kristus mate-lo be maranga nge bokainatuka irangaki, ‘Tago mate kaba-lo pereka ipura. Be kusi tago imoapuru.’ ");
INSERT INTO mva_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nanaranga ambe Iesus-tina ngae ka mate-lo be imarangaki. Be keka nge mata-ita ne bokana. ");
INSERT INTO mva_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nanaranga ambe Iesus idokiteteki eta-tina be kaba aradi bibiatuka oana-nao inangai, be itaguraki be Oli Spirit idoki be iani. Oli Spirit ngae nge Tama toira be moimoi be irangakani. Bokaibe kana kaituka-tina kaita be kalongo nge Iesus lumaluma ne omaio isuburakiria ka kate be kalongoraki. ");
INSERT INTO mva_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Moimoi Debiti nena-la lang anua-lo tago ilako, ata bokai ipile, ‘Nanaranga Tanepoa itaguraki be Tanepoa negu bokai irai: Makare kaba aradi bibiatuka oana-guo gosoaki, ");
INSERT INTO mva_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nibe erekei nem mduaposakidi be ae salangaka nem bokana aem babadi erumadi mnangadi.’ (Sam 110:1) ");
INSERT INTO mva_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Bokaibe Israel tamoata be aine moarunga bokai kamakaua: Iesus ma maka kam kai kapalapala uauau-o karokatagaki nge ka Nanaranga iemaki be Tanepoa be Kristus ipura!” ");
INSERT INTO mva_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Bokaibe bong tamoata be aine pile ngaedi dilongo nge ilodi dibuku-tina be Pita be ‘apostel’ takadi bokai diradi, “Tarito, masa rakana gaemaki?” ");
INSERT INTO mva_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Be Pita itaguraki be bokai iradi, “Kam teke-teke moarunga nge muzigoala neming kamarokaki be Iesus Kristus ara-nao be ruku ono tamalinga ane rukua-ming dapura. Bokai masa Nanaranga muzigoala neming ngarokaki, be Nanaranga lumaluma ne Oli Spirit nge kamadoki. ");
INSERT INTO mva_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maka ma Nanaranga pile moimoi be iemaki nge kam be natu-ming be tamoata kasau kaba-lo disoaki ka iemaka-kaming. Nge kam-ma maka Nanaranga neda Tanepoa ikilakaming-re!” ");
INSERT INTO mva_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita mangmang bokai iungdi kodeka pile kokoko takadi ane be bokai iakorodi, “Neming-la kamauketi-kaming be masa sururu bibia tamoata muzingadi goalakadi ngaedi kaituka disoaki dadoki kana nge kamairatudi.” ");
INSERT INTO mva_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bokaibe tamoata kokoko-tina pile ngaedi lama diungdi be Iesus ara-nao be rukuadi dipura. Be amari ngarana-lo nge ‘3,000’ tamoata be aine ditaguraki be Kristus ungguma ne disilidi. ");
INSERT INTO mva_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Be tamoata be aine ngaedi nge bong kokoko ‘apostel’ zaiza disukoaki-budu be sulengadi dilongolongo, be soaki-uia muzi be moanako ono Iesus ilodi dianiani kana be rabo ono soaki-uia dokinga nge diememaki. ");
INSERT INTO mva_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kilala kaiboangdi be kilala takadia-ba nge kokoko-tina ‘apostel’ diemaki. Bokaibe tamoata be aine moarunga nge dipitilaki-tina be dikabakidi. ");
INSERT INTO mva_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tamoata be aine lama diuni moarunga nge disukoaki-budu be kana nedi moarunga nge dinegenege-budu. ");
INSERT INTO mva_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kateka nedi be kana nedi takadi kaoa ka ‘mone’ odio didoki nge ‘mone’ ngaedi nge danege. Be ‘mone’ ngaedi nge tamoata naita rakana tekena-lo itukura nge dani, ira ireretaki datagadi be dani. ");
INSERT INTO mva_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Izamaizama nge Nanaranga pera nena-lo uko teke bokana diepurapurari. Be pera kandia-lo nge dimoanakonako-budu. Moanako nedi nge suri-uia be ilo-uia-lo be diememaki. ");
INSERT INTO mva_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nanaranga dirakerakeaki, be tamoata be aine takadi ditetedi nge dimakarakaradia-tina. Be bong moarunga nge Tanepoa idumadumadi be tamoata be aine ambe uketadi dipurapura nge isilisiliakidi. ");
INSERT INTO mva_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bong teke rairai, amari ambe siriki tolia-nao bokana nge Pita be Zon dilakoru Nanaranga pera nena-lo be daraboru kana. Nge rabo bong ka makara dilakoru. ");
INSERT INTO mva_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Makara Nanaranga pera nena-lo nge babaduadua biabia teke ieno ara “Kulanglang,” be tamoata teke tapou matedi nge makara isoaki. Tamoata ngae nge natumuku-tina be tapou matedi. Bokaibe izamaizama makara dieleluaki be tamoata Nanaranga pera nena-lo dilakolako nge ‘mone’ isinaunaudi. ");
INSERT INTO mva_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Bong Pita be Zon ite-diaru ambe dasiliru kana nge ‘mone’ isinau-diaru. ");
INSERT INTO mva_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Isinau-diaru nge diaru adoado-la didedeiaru be Pita bokai ipile, “Godede-kamairu!” ");
INSERT INTO mva_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pita bokai ipile bokana tamoata ngae nge idede-diaru. Ilo ipileni masa kana teke daniaru. ");
INSERT INTO mva_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ata Pita bokai irai, “Ngau ‘mone’ negu tago, ata kana ienona masa miangko. Nasaret tamoata Iesus Kristus ara-nao be uraiko gotui be goalalale!” ");
INSERT INTO mva_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kodeka luma oana-nao idauraki be idumai be ituirakarake. Tamoata ngae ituirake nge oaikiki-tina ae be kuzubu dikai. ");
INSERT INTO mva_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Be inaulaki be ae-nao itui, kodeka makara be ialalale. Kodeka Pita be Zon itaga-diaru be Nanaranga pera nena-lo disilito. Bong disilisilito nge tamoata ngae itaguraki be ialalale, inokunoku be Nanaranga irakerakeaki be disilito. ");
INSERT INTO mva_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Be tamoata be aine kokoko-tina makara disoaki nge dite ialalale be Nanaranga irakerakeaki. ");
INSERT INTO mva_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Be bong dikilalangi ngai ka “Babaduadua Kulanglang”-lo isukoaki be isinaunau nge dipitilaki-tina kana ngae bokai ipurani. ");
INSERT INTO mva_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kodeka tamoata sinaunau adoraka ipura nge itaguraki be Pita be Zon idokimate-diaru be makara Nanaranga pera ne ege “Solomon Sumasuma” ne kana ditugani kana-lo dituituito. Makara nge tamoata be aine makara disoaki nge dipitilaki-tina be dipanana be dipura makara “Solomon Sumasuma” nena-lo. ");
INSERT INTO mva_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bong Pita tamoata be aine itedi nge bokai ipile, “Israel tamoata, bakara ka kana ngae kate be kapitilaki? Bakara ka bokai kadededekamairu? Ilo-ming dipile nge kaiboang nemairua-lo, ki Nanaranga mata-nao kiadoru ka tamoata ngae kiemakiaru be ialalale? Tago-la! ");
INSERT INTO mva_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ngena Abaram, Aisak be Zekop Nanaranga nediato be tamada be tubuda Nanaranga nedi ka malipilipi ne Iesus ara biabiatuka iani, be ono tamoata ngae iuia. Iesus ma maka kadoki be erekei luma-dio kanangai be umoatea ngapura kanana-re! Be bong Pailot aro tuiraka ipura nge Pailot ilo itekenanai be ngarubetaki kana, ata kam kataguraki be lili-be-matanao kaolitaki be kasegeaki. ");
INSERT INTO mva_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tamoata maka Kusi Rata be Adoadona-tina nge ka kasegeaki be kasumoala be tamoata maka tamoata takadi iumoatemoatedi nge Pailot irubetaki be iang-kaming. ");
INSERT INTO mva_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Bokaibe tamoata maka tamoata moarunga moauriuri soaki-lo ilakulakuakidi nge kaumoatei. Ata Nanaranga itaguraki be mate-lo be imarangaki. Be keka nge kana ngae mata-ita ne. ");
INSERT INTO mva_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Be nge lama uninga-lo be Iesus ara-nao ka tamoata ngae kam kakauataki be makare kateate nge Nanaranga kania iaka-kaidi. Nge Iesus ara kaiboang nena-lo be lama uninga maka Iesus-lo ieno ane ka Nanaranga tamoata tapou matedi nge iaka-uiaki be ambe iuia-doi, neming-la mata-ming-lo kate bokana. ");
INSERT INTO mva_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Taritokagu, kodeka bokai kamakaua. Ngau ukaua kana maka tamoata neming bibia zaiza be Iesus kabasakini nge ilo-ming tago kalelenaki noko kaemaki. Ramoramo-ba ka kamuzi. ");
INSERT INTO mva_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Maka ma toira-tina be Nanaranga itaguraki be ‘propet’ ne aoa-dialo be ipile Kristus ne masa sururu bibia ngadoki be ngamate. Be Nanaranga ambe bokainatuka-la ka imuzi be ono pilenga ngaedi dikalingo. ");
INSERT INTO mva_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bokaibe muzigoala neming kamarokaki be Nanaranga kamatalari. Bokai masa Nanaranga muzigoala neming ngarokakile-ming be ilo-ming ngaka-goazadi. ");
INSERT INTO mva_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bokai kamuzi masa Tanepoa-lo kaiboang oauoau kamadoki be ono kamasiombe be ilo-ming dakarai. Bokai masa Nanaranga ngataguraki be Iesus nganepi be iloming-lo ngasukoaki. Maka ma Iesus ka toira be kam kanabe nangaia ipura ngai ka Kristus. ");
INSERT INTO mva_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ata kaituka-tina masa lang anua-lo ngasukoaki nibe Nanaranga kaba kana moarunga ngaemaki be oauoau dapura, toira-la ‘propet’ ne kusidi-ratadi aoa-dialo ipile bokana. ");
INSERT INTO mva_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Maka ma Moses bokai ipile, ‘Nanaranga neming Tanepoa masa mara-ming ka tamoata-tina neming teke nganaguraki be ‘propet’ ngau bokana ngapura. Pile moarunga ira-kaming nge kamalongori. ");
INSERT INTO mva_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tamoata naita pilenga tago ilongo masa rokaka ngapura be Nanaranga tamoata ne ngaperekidi be tago maradi ngasukoaki.’ ");
INSERT INTO mva_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Be moimoina-tina ‘propet’ moarunga Samuel-lo be imai pile nedi dieno nge bong kaitukatuka nge dirangaki-doi. ");
INSERT INTO mva_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nanaranga pile moimoibe ‘propet’ ne irangakidi nge kam Iuda ka iemaki-kaming, be taoa ne toira tubu-ming zaiza iemaki nge kam zaiza be neming-budu. Abaram-la irai bokana, ‘Natum be tubum-lo ka tamoata be aine moarunga kateka-o maroudi kana.’ ");
INSERT INTO mva_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bokaibe bong Nanaranga itaguraki be Malipilipi ne inangai be inepi nge kam Iuda-lo ipura mua. Ono ngamarou-kaming be muzi neming goalakadi kamarokaki kana ka inepi be kam-lo ipura mua.” ");
INSERT INTO mva_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita be Zon nge isi dipilepile-lanaru be tamoata Nanaranga ditabatabai, tamoata Nanaranga pera ne dinarinaringi pangana nedi be Sadiusi dipura. ");
INSERT INTO mva_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Di nge namadi dira-tina, bakara ‘apostel’ nge tamoata be aine moarunga disulesuledi Iesus ambe mate-lo be imarang. Bokai disulesuledi nge ono dipilepile matemate moimoi iboadu mate-lo be damarang. ");
INSERT INTO mva_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bokaibe ditaguraki be Pita be Zon diuauri-diaru be uaura pera-lo dinanga-diaru. Ambe rairaituka ka diuauri-diaru bokana makara uaura pera-lo disoakiru be izama. ");
INSERT INTO mva_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ata tamoata be aine maka pile ngaedi dilongo nge kokoko-tina Iesus lama diunani. Bokaibe kokotangadi irake-tina ‘5,000’ moarunga. ");
INSERT INTO mva_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Izama nge Iuda tamoata nedi dimuamua, tamoata nedi bibia be tamoata Moses Mata ne disulesuletaki nge Ierusalem-lo diepurari be dikabuni be disoaki. ");
INSERT INTO mva_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Tamoata Nanaranga ditabatabai biabiatuka nedi ara Ananias be Kaiapas, Zon, Aleksanda, be Ananias dara ne takadi Nanaranga ditabatabai nge makara maradi disoaki. ");
INSERT INTO mva_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Kodeka Pita be Zon nge dikeliaki-diaru be tamoata bibia ngaedi arodi dituiraki-diaru be bokai ditegi-diaru, “Kaiboang nangatadi ki naita ara-nao ka kana ngae kaemakiaru?” ");
INSERT INTO mva_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Makara nge Oli Spirit kaiboang ne Pita ilona-lo dikauri be Pita itaguraki be bokai iradi, “Iuda tamoata nedi kamuamua be tamoata bibia! ");
INSERT INTO mva_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tamoata tapou matedi muzi iauia emakani ipura be baituka be aka-uiaka ipura kana ka kaituka kakila-kamairu nge ");
INSERT INTO mva_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","bokai kamakaua Israel tamoata be aine moarunga zaiza: Tamoata ngae makare aro-ming ituitui nge Nasaret tamoata ara Iesus Kristus ara-nao ka aka-uiaka ipura be ambe iuia-doidoi. Iesus-ma maka kam kai kapalapala uauau-o karokatagaki, be ngai ka Nanaranga mate-lo be imarangakia-re! ");
INSERT INTO mva_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iesus ka Nanaranga ‘Buku’ ne bokai dirangaki, ‘Ariri maka kam pera kelikeli kasegeaki ka pera kaiboang ne.’ (Sam 118:22) ");
INSERT INTO mva_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Nanaranga tago masa tamoata takaia ara-nao be tamoata moarunga ngauketidi. Tago-la. Iesus-la ara-nao ka masa ngauketidi. Bokai kamakaua: Lang eruma nge ara maka tamoata buleakidi dipurapura nge tago takaia ieno be ono masa Nanaranga ngauketi-kita. Tago-la!” ");
INSERT INTO mva_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bong tamoata bibia ngaedi kaba bokai dita Pita be Zon nge tamoata-ramoba kaoa be sule bibia-lo tago dilakoru, ata tago taburi-diaru dira be pile dikaturu nge dipitilaki-tina. Makara nge ilodia-lo dikaua tamoata ngae-diaru nge Iesus zaiza dialalale-budu. ");
INSERT INTO mva_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bokaibe masa ba sesu dapile! Maka ma tamoata tapou matedi adoraka ipura nge makara maradi ituitui! ");
INSERT INTO mva_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kodeka dinepi-diaru be eluku dilakoru be rubedia-ba disoaki be bokai dietegi, ");
INSERT INTO mva_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Tamoata ngaedi masa bakara tabasakidi? Tamoata moarunga makare Ierusalem anua-lo nge dikaua tamoata ngae-diaru kilala kaiboangi biabia-tina kata ka diemakiaru. Be kita neda-la tago taboadu tapile-ra kana ngae tago diemakiaru! ");
INSERT INTO mva_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ata ono pile ngaedi tababaridi be tago iboadu tamoata be aine maradi kaba dalaba kana nge tapile-kaidi be moaki sesu kaba Iesus ara-nao be tamoata teke pile diraiaru.” ");
INSERT INTO mva_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kodeka Pita be Zon dikeliaki-diaru be disiliru be pile kakai ane be bokai dira-diaru, “Moakina-tina sesu Iesus ara-nao be kapileru ki kasuleru.” ");
INSERT INTO mva_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ata Pita be Zon dikaturu be bokai dipileru, “Neming-la be kamaliliti be kamakaua mata nangata ka Nanaranga mata-nao iado. Pilenga-ming gatagatagadi ki Nanaranga pilenga gatagatagadi? ");
INSERT INTO mva_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Maka ma keka nemai-la be kana kita be kilongoraki! Bokaibe gararangaki-la kana. Tago iboadu gamanaua.” ");
INSERT INTO mva_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Makara be tamoata bibia ngaedi ditaguraki be pile kaiboangdia-tina ane dibabari-diaru be dirubetaki-diaru be dialaleru. Tamoata bibia ngaedi tago dikaua masa baituka be sururu dandiaru, bakara tamoata be aine moarunga nge kana ipura ngae dite be ambe Nanaranga dirakerakeaki. ");
INSERT INTO mva_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Tamoata maka kilala kaiboangi ono emaka ipura nge barasi ne ambe kulemoadi-oati iuasadi. ");
INSERT INTO mva_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita be Zon rubetaka-diaru dipura nge oaikiki-tina dialaleru be tamoata be aine nediarua-lo dilakoru be tamoata Nanaranga ditabatabai dimuamuadi be Iuda bibia nedi baituka dira-diaru nge diradi. ");
INSERT INTO mva_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Be bong tamoata be aine ngaedi pile ngaedi dilongo nge ilodi dietekenanai be malonga teke bokana be Nanaranga bokai dirabo, “Tanepoa, kaiko ka lang be kateka be makasi kuemaki. Be kaiko ka kana moarunga lang-lo, kateka-lo be makasi-lo dieno nge kuemaki. ");
INSERT INTO mva_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Oli Spirit nem kaiboang nena-lo be malipilipi kanam, tubuma Debiti kurai be bokai ipile, ‘Bakara ka Ungguma Takadi ilodi didududui-tina? Bakara ka tamoata takadi dirabaraba, ata rabangadi tago dikalingolingo? ");
INSERT INTO mva_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Anuatanepoa moarunga kateka-o koai kana be dikatiuanauana, be tamoata bibia moarunga nge diekapokapotaki be Tanepoa diduaduai, be Kristus ne diduaduai.’ (Sam 2:1-2) ");
INSERT INTO mva_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Moimoina-tina Erot be Ponsius Pailot ditagurakiru be Ungguma Takadi be Israel tamoata zaiza anua ngaena-lo diepurari be pile dipali be malipilipi nem kusi rata Iesus nge diumoatei. Malipilipi nem ngae ka kuburengi be Kristus kunangani. ");
INSERT INTO mva_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Diepurari be nem rerengam be kaiboang nem-lo kana moarunga matamata be kurangaki dapura kana nge diemaki. ");
INSERT INTO mva_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tanepoa, kodeka pile nedi ono diakataburi-ra-kama nge ilom ngandi be malipilipi kanam goakakai-kama be pilengam ramoramo mangata gapilepile. Moaki taburima dirara be kipilepile. ");
INSERT INTO mva_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Kodeka lumam gonanaraki be moremore odio gonangaria be dauia. Be kilala kaiboangdi be kilala kaiko-la kuboadu goemaki nge malipilipi nem kusi-rata Iesus ara-nao be goememaki.” ");
INSERT INTO mva_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dirabo-doi nge kaba odio diepurari be disoaki nge kaikai-la dimoakusu. Be Oli Spirit ilodia-lo ikauri be kaiboang didoki be ono Nanaranga pilenga tago taburi-ra-lo be mangata dirarangaki. ");
INSERT INTO mva_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tamoata be aine Kristus lama diunani nge ilodi tekedia-doi be kana tekedia-doi ilodi dianiandi. Kana nedi moarunga nge dinegenege-budu. Tago teke ipile kana ne nge nena-la rube. Tamoata teke kana ne nge di moarunga nedia-budu. ");
INSERT INTO mva_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Be kaiboang bibia-tina ane be mata-ita bokana be ‘apostel’ ditagutaguraki be Tanepoa Iesus matenga be mate-lo be maranga nge mangata dirarangaki. Bokaibe Nanaranga itaguraki be marou bibia-tina iandi be kana moarunga-lo nge diboadu-tina. ");
INSERT INTO mva_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tamoata moarunga lama diuni nge kana moarunga-lo diboaduboadu-tina. Tago teke kana tekena-lo itukurakura. Tamoata be aine maka pera ki uma nedi otioti nge dataguraki be kana nedi ngaedi ane ‘mone’ dadoki, be ‘mone’ ngaedi dadoki be dalako ");
INSERT INTO mva_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","be ‘apostel’ dandi. Be ‘apostel’ ‘mone’ ngaedi dadoki be tamoata maka kana tekena-lo itukura nge dani. Tago ramoramo-ba dinegenege. Ira-lo itukura-la ka datagadi be dani. ");
INSERT INTO mva_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Bong teke nge Libai kata Saiprus-lo nekiaka ipura ara Iosep, ata ‘apostel’ nge Barnabas kana dikilakilai (ara Barnabas nge labu Grik pile-lo bokai “Tamoata maka tamoata takadi iaka-kaikaidi.”) ");
INSERT INTO mva_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","itaguraki be uma ne teke ane ‘mone’ idoki, be ‘apostel’ luma-dio isalangaki. ");
INSERT INTO mva_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tamoata teke isoaki ara Ananias. Roa ara Sapira. Bong teke Ananias itaguraki be uma ne teke ono ‘mone’ idoki. ");
INSERT INTO mva_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Be ‘mone’ idoki ngaedi nge alu idokimatedi be aluna-ba ‘apostel’ iandi. Ata iaoli be ipile-ra nge ‘mone’ surikadi. Bokai imuzi nge roa Sapira ikaua! ");
INSERT INTO mva_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bokaibe Pita itaguraki be Ananias bokai irai, “Ananias, bakara ka Satang kulikitaki be ilom-lo isili be Oli Spirit kubolesi be ‘mone’ uma nem-lo kudoki nge alu kudokimatedi? ");
INSERT INTO mva_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Matamata uma ngara tago isi ono ‘mone’ kudoki nge nem! Be alauri ono ‘mone’ kudoki nge ‘mone’ nem! Tago tamoata takaia ne. Nge bakara ka ilom-lo be boli mata ngaedi kuemaki be kana bokainaina kuemaki? Nge tago tamoata ka kubolesidi. Nge Nanaranga ka kubolesi!” ");
INSERT INTO mva_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias pile ngaedi ilongo nge oaikiki-tina itapuloria be imate. Tamoata be aine moarunga kana ngae ruku dilongo nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kodeka tamoata amuna alu disili be Ananias mate disukumi be eluku dibagalako be dikumraki. ");
INSERT INTO mva_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Uanana muku disalaga nge roa Sapira isili, ata tago ikaua rakana ipura. ");
INSERT INTO mva_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Makara nge Pita itaguraki be bokai irai, “Goraia, ‘mone’ ngaedi nge moarunga-doi roam kamru uma nemingru katunga bokana ki alu isi dieno?” Be Sapira ikatu be bokai ipile, “E! Nge surikadia-re!” ");
INSERT INTO mva_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kodeka Pita itaguraki be bokai irai, “Bakara ka kasumoalaru be Tanepoa Oli Spirit ne katoiaru? Tamoata roam dikumraki kaituka-tina makara babaduadua-lo dituitui. Kaiko masa dabaziko be eluku dalakuakiko!” ");
INSERT INTO mva_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita bokai ipile nge aine ngae oaikiki-tina Pita ae-nalo itapuloria be imate. Tamoata amuna disili be dite imate nge eluku dibazialako be roa Ananias zagenao dikumraki. ");
INSERT INTO mva_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Moarunga ‘sios’-lo be tamoata be aine takadi kana ngae dilongoraki nge taburidi dira-tina. ");
INSERT INTO mva_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Makara be ilako nge ‘apostel’ kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki nge kokoko-tina tamoata be aine maradi diememaki. Ata tamoata be aine Kristus lama diunani nge bong kokoko makara Nanaranga pera ne ege ara Solomon Sumasuma nena-lo diepurapurari. ");
INSERT INTO mva_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Moimoi tamoata be aine takadi nge tamoata be aine maka lama diuni nge atabala-tina dinanganangadi, ata ‘apostel’ kaiboang nedi dimatakuri be tago teke idainakidi. ");
INSERT INTO mva_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bokaibe moimoi tamoata be aine ngaedi ‘apostel’ dimatatakuridi, ata kokoko-la be Tanepoa lama diununani, be dilakolako be tamoata be aine maka lama diuni nge disilisilidi be kodeka ono uareadia-lo dikokoko-tina. ");
INSERT INTO mva_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Makara nge moarunga-tina ‘apostel’ kana diememaki nge dilongoraki. Bokaibe moremore dieleluakidi be zala bibia-lo bagi ono enonga-o be zirapu-o dinanganangadi be ono Pita luma odio ngananganangaria be ngaka-uiauiakidi kana. Aludi luma tago odio inangaria nge ilodi bokai dinangananga: zala-lo ialalale be anunuka mukuna-ba odio idum-ra dauia. ");
INSERT INTO mva_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Bokaibe tamoata be aine dum bibia-tina anua Ierusalem saringa dieno-lo nge dipurapura. Be moremore nedi be tamoata mariaba goalakadi dibagabagadi nge dieleluakidi, be moarunga dipurapura nge aka-uiakadia-doi dipura. ");
INSERT INTO mva_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","‘Apostel’ nge ambe aradi dilabalaba-tina. Bokaibe tamoata Nanaranga ditabatabai biabiatuka nedi ruanga moarunga zaiza nge ‘apostel’ diuanamdi. Tamoata biabia ngae ruanga ngaedi nge Sadiusi kaoa. ");
INSERT INTO mva_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kodeka ditaguraki be dipile be ‘apostel’ uauradi dipura be uaura pera tamoata giriki ememaki moarunga nedia-lo dinangadialako. ");
INSERT INTO mva_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ata oabubu ngarana-lo nge Tanepoa ‘enzel’ ne teke ipura be uaura pera babaduadua ne iuasari be ipasikidi. ");
INSERT INTO mva_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Be bokai iradi, “Kamalako Nanaranga pera ne aro kamatui be soaki oauoau ngae nge ere-moarunga be kamarangaki.” ");
INSERT INTO mva_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Bokaibe anua izama nge pile ngaedi ditagadi be dilako be Nanaranga pera ne aro be tamoata be aine disulesuledi. Ata tamoata Nanaranga ditabatabai biabiatuka nedi ruanga zaiza nge tago dikaua. Ditaguraki be Iuda tamoata nedi bibia moarunga Iuda ‘Kansolo’ nedia-o disoaki nge dikeliakidi be dipura. Dipura-doi, kodeka dipile be ‘apostel’ uaura pera-lo disoaki nge dabagadi kana. ");
INSERT INTO mva_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ata bong katonga-oaoa dilako uaura pera-lo nge ‘apostel’ tago makara disoaki be ditedi. Bokaibe dimule be Iuda ‘Kansolo’ nedia-lo bokai dipile, ");
INSERT INTO mva_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kai, kilako uaura pera-lo nge onotana-tina uia ipura be ieno, be tamoata narinari nge babaduadua moarunga-lo dinari-tina uia be disoaki be kitedi. Ata bong babaduadua kiuasari be kisili nge tamoata tago teke kite.” ");
INSERT INTO mva_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tamoata Nanaranga pera ne dinarinaringi pangana nedi be tamoata Nanaranga ditabatabai dimuamuadi pile bokai dilongo nge diboang-tina be bokai dipile, “Nge masa baituka?” ");
INSERT INTO mva_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kodeka tamoata teke isili be bokai iradi, “Kamalongo! Tamoata-ma maka uaura-lo kanangadi ka eluku Nanaranga pera ne aro ditui be tamoata be aine disulesuledi!” ");
INSERT INTO mva_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pile bokai dilongo nge tamoata Nanaranga pera ne dinarinaringi pangana nedi nge tamoata ne bibia zaiza be dilako be ‘apostel’ dibagadi be disiliakidi. Ata malielie-ba be dibagadi, bakara taburidi dira tamoata be aine masa patu oti daungdi takana. ");
INSERT INTO mva_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","‘Apostel’ dibagadi kodeka didokidi be Iuda ‘Kansolo’ nedi arodi dituirakidi be tamoata Nanaranga ditabatabai biabiatuka nedi nge bokai itegidi, ");
INSERT INTO mva_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Keka kaikai-tina kira-kaming moakina-tina kababe ara ngaenao be kasulesule! Ata kaba kamaita! Sulenga-ming ambe ege-ege Ierusalem anua-lo dilako, be ambe kapipi be matenga ngaedi nge moatubu nedi keka gabazidi kana!” ");
INSERT INTO mva_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Makara nge Pita be ‘apostel’ takadi dikatu be bokai dipile, “Keka Nanaranga-la ka pilenga gatagatagadi kana. Tago tamoata-ramo pilengadi! ");
INSERT INTO mva_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tamada be tubuda Nanaranga nedi ka Iesus mate-lo be imarangaki. Kam ka Iesus kai-o karokatagaki be imate. ");
INSERT INTO mva_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Be Nanaranga itaguraki be tanepoa-natu be Uketiketi bokana atabala-tina oana-nao inangai, be Israel ngadumadi be ilodi dabuiri be masa Nanaranga muzigoala nedi ngarokakiledi. ");
INSERT INTO mva_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Keka nge mata-ita ne bokana. Tago kekai-la ka mata-ita ne. Oli Spirit be! Oli Spirit ngae ka Nanaranga lumaluma ne, be tamoata maka Nanaranga pilenga dilongolongo be ditagatagadi nge ianiandi.” ");
INSERT INTO mva_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tamoata bibia Iuda ‘Kansolo’ nedia-lo disoaki pile ngaedi dilongo nge namadi dira-tina. Bokaibe direre ‘apostel’ umoateadi dapura. ");
INSERT INTO mva_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ata teke nedi ara Gamaliel nge ituirake be ipile be ‘apostel’ didokidi be eluku dilakuakidi. Gamaliel nge Parasi kata, be ngai nge tamoata Moses Mata ne disulesuletaki kata. Bokaibe tamoata moarunga nge dimuamuakia-tina. ");
INSERT INTO mva_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","‘Apostel’ eluku dilako nge Gamaliel itaguraki be bokai ipile, “Israel tamoata! Eke! Tamoata ngaedi bakara kamabasakidi kana nge ilo-ming kamalelenaki-tina uia noko! ");
INSERT INTO mva_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Noranetuka-ba nge tamoata teke ara Teudas ipusika be nena-la irangaki ngai ara otioti kata. Be tamoata be aine ‘400’ moarunga ditaguraki be ditagai. Ata umoatea ipura nge tagataga ne digalalai-ramo. Bokaibe kana imarangaki ngae nge ileua-ramoba. ");
INSERT INTO mva_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Alauri nge Galili tamoata ara Iudas itaguraki be bong tamoata be aine moarunga uareadi dipurapura nge tamoata alu imuadi be eung biabia teke dimarangaki. Ngai bokai, umoatea ipura nge tagataga ne moarunga diratu-ramo. ");
INSERT INTO mva_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Bokaibe kana ngae kaituka-tina ipurapura nge ngau bokai mangmang mung-kaming kana: tamoata ngaedi kamalikitakidia-ba. Moaki sesu ba kabasakidi. Labu nedi ono kana ngae diememaki be dimalipilipi tamoata-ramolo ka ipura nge masa ngaleua-ramoba. ");
INSERT INTO mva_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ata kana ngae Nanaranga-lo ka ipura nge tagona-tina iboadu kamamambuaki. Masa neming-la kamate-kaming nge Nanaranga ka kaduaduai.” ");
INSERT INTO mva_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel bokai ipile nge Iuda ‘Kansolo’ nedi ilodi ibagabuiri be pilenga dilongo. Kodeka ‘apostel’ dikeliakidi disili be dirautotokidi be bokai diradi, “Moakina-tina kaba Iesus ara-nao be kapilepile.” Makara be dilikitakidi be dialale. ");
INSERT INTO mva_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Bong ‘apostel’ Iuda ‘Kansolo’ nedi diperekidi be dialalale nge suridi diuia-tina, bakara Nanaranga ambe irangakidi di diboadu-tina Iesus ara-nao be maia dadoki. ");
INSERT INTO mva_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Be izamaizama Nanaranga pera ne aro be pera-pera-lo nge Pile Uia ngae bokai disulesuletaki be mangata dirangarangaki Iesus ka Kristus. ");
INSERT INTO mva_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Bong ngaradia-lo nge tamoata be aine kokoko-tina dipurapura be ‘apostel’ tagataga nedi dipura. Bokaibe Iuda maka Grik pile dipilepile nge ditaguraki be Iuda anua-marau zaiza diebulo. Iuda maka Grik pile dipilepile nge dipile-ra narenare nedi tago adorakadia-uia dipurapura be kangkang izamaizama dinegenege nge tago sesu dianiandi. ");
INSERT INTO mva_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Bokaibe ‘apostel’ kulemoa-be-rua ditaguraki be tagataga moarunga dikeliakidi be bokai dipile, “Nge tago iuia kangkang nege muzi nge Nanaranga pilenga mangata rangakadi dazalonadi. ");
INSERT INTO mva_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tarito, bokaibe tamoata lima-rua maraming kamanangadi be kangkang danegenege. Tamoata bokainaina nge kauatakadi dapura Oli Spirit ilodia-lo ikauri be kaua bibia dienodi. Be keka masa malipi ngaedi gadoki be lumadi-o gananga. ");
INSERT INTO mva_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bokai masa keka malipi-la ngaedi iloma daniandi: rabo be Nanaranga pilenga mangata rangakadi.” ");
INSERT INTO mva_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","‘Apostel’ pile bokai ditongaki nge moarunga pile ngaedi ilodi diuiataki. Bokaibe tamoata teke lama iunia-tina be Oli Spirit ilona-lo ikauri ara Stepan nge dinangai. Be takadi Stepan zaiza dinangadia-budu nge Pilip, Prokorus, Nikanor, Timon, Parmenas be Nikolaus. Nikolaus nge Antiok tamoata kata, be ngai nge Ungguma Takadi kata ka ilo buira ipura be Iuda mata nedi itagatagadi. ");
INSERT INTO mva_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kodeka tamoata lima-rua ngaedi nge didokidi be ‘apostel’-lo dilakuakidi. Be ‘apostel’ ditaguraki be Nanaranga diraboi be lumadi odio dinangaria be ono Kristus malipi ne daememaki kana. ");
INSERT INTO mva_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bokaibe Nanaranga pilenga nge ege-ege dilako be dilako-la be dieno. Be ‘apostel’ tagataga nedi Ierusalem-lo nge ikoko-la be ieno, be oaikiki-la be dikoko-tina. Makara nge tamoata Nanaranga ditabatabai nge kokoko-tina lama diuni be lama uninga ngae nge ditagatagai. ");
INSERT INTO mva_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nanaranga marou ne tadokidoki-ba be kaiboang ne nge Stepan-lo dikauri. Bokaibe kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki nge tamoata be aine moarunga maradi iememaki. ");
INSERT INTO mva_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ata tamoata alu ditaguraki be diduai. Tamoata ngaedi nge alu pera ono serereinga ara “Tamoata Ruberubetaki”-lo ka dipura, alu nge Iuda kaoa Sairini be Aleksandria anua-lo disukoaki, be alu nge Silisia anua be Esia kaba-lonalona kaoa. Makara nge Stepan zaiza diegore, ");
INSERT INTO mva_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ata Oli Spirit itaguraki be Stepan kaua bibia-tina iani be bong ipilepile nge tago iboadu dare-balaki. ");
INSERT INTO mva_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Makara nge tamoata ngaedi ditaguraki be komangaba-lo be tamoata alu ‘mone’ ane dizazadi be pile kaiboangdi Stepan ono bokai diunglako, “Keka Stepan kilongori Moses be Nanaranga odioruo imanai!” ");
INSERT INTO mva_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Bokai dimuzi be ono tamoata be aine moarunga, be Iuda tamoata nedi bibia, be tamoata Moses Mata ne disulesuletaki nge diemakidi be ilodi dikauborua-ramo. Bokaibe dipura be Stepan didokimatei be Iuda ‘Kansolo’ nedia-lo dilakuaki. ");
INSERT INTO mva_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Be ditaguraki be tamoata alu dinangadi be mata-ita bokana be boli-pile bokainatuka Stepan ono diunglako, “Tamoata ngae nge izamaizama edua pile Nanaranga pera ne rata ngae be Moses Mata ne odio iununglako. ");
INSERT INTO mva_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Keka kilongori bokai ipile Nasaret tamoata ara Iesus masa pera ngae ngagamani, be kita Iuda mata neda Moses iang-kita be dimai nge ngabuiri.” ");
INSERT INTO mva_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ata tamoata bibia moarunga Iuda ‘Kansolo’ nedi-o disoaki Stepan didedematei nge lili ‘enzel’-ba bokana dita. ");
INSERT INTO mva_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Kodeka tamoata Nanaranga ditabatabai biabiatuka nedi itaguraki be Stepan bokai itegi, “Pile ngaedi omo diunglako nge moimoi ki tago?” ");
INSERT INTO mva_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Be Stepan ikatu be bokai ipile, “Taritokagu be tamagu, kamalongora! Tubuda toiraira Abaram isi Mesopotemia kaba-lo isoaki be Nanaranga kaiboang ne malamakadi otioti nge ipurakani. Bong ngaradia-lo nge tago isi Aran kaba-lo ilako. ");
INSERT INTO mva_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Makara nge Nanaranga bokai irai, ‘Kaba nem be dara nem goperekidi be kateka ngau mitikiniko kanana-lo golako.’ ");
INSERT INTO mva_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Bokaibe Abaram Kaldea kaba ipereki be Aran-lo anua idoki. Alauri Abaram tama imate nge Nanaranga itaguraki be Abaram inepi be kateka kaituka ono kasoaki-lo ipura. ");
INSERT INTO mva_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Be bong makare ipura nge kana tago teke iani be ne bokana inemi. Tago-la. Kateka muku labatinga ae-baba bokana ngani be nganemi nge tago-soasoa! Ata Nanaranga moimoibe irai ngai be tubu ne alalauri masa kateka ngae danemi. Moimoi bong ngaradia-lo nge Abaram isi natu tago be. ");
INSERT INTO mva_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nanaranga Abaram bokainatuka irai, ‘Tubu nem alauri masa dalako kateka takana-lo be akerengadi bokana kateka tago nedi-o dasoaki. Be masa dududu bokana dasukoaki be mata goalakadi oti dababasakidi nibe ‘400’ barasi damanubu. ");
INSERT INTO mva_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ata ngau masa ungguma nangata dududu kana bokana disoaki nge sururu miani. Be alauri masa kaba ngaradi dapereki be makare be darakeaka.’ ");
INSERT INTO mva_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Makara be sumoala ono taoa emaka nge teke diemakiaru. Sumoala ngae kilala ne nge kusi korototoka mata. Be alauri nge Nanaranga itaguraki be natu moane teke Abaram iani ara Aisak. Bong natu ngae nekiaka ipura be amaridi lima-toli dilako nge Abaram itaguraki be natu kusi ikorototokani. Alauri nge Aisak natu teke ipura ara Zekop, be Zekop ineki be natu kulemoa-be-rua dipura. Natu ngaedi ka kita ungguma Israel tamada aradi bibia. ");
INSERT INTO mva_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Alauri nge tama-da aradi bibia kulemoa-be-teke nge taridi alalaurituka Iosep dimangazi, be didoki be dududu bokana Izip tamoata diandi be dizazai. Ata Nanaranga Iosep sakenao isoaki. ");
INSERT INTO mva_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bokaibe bong giriki itaita nge Nanaranga ka idumadumai. Nanaranga ka kaua bibia iani be ono Izip ‘Pero’ kandi nge Iosep ilo iuiauiatakia-tina. Be ‘Pero’ itaguraki be Iosep inangai be Izip kaba moarunga be ‘Pero’ pera kana biabia nge ipapananuaki. ");
INSERT INTO mva_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kodeka alauri nge tole biabia teke Izip kaba be Kenan kaba-lo ipura be tamoata be aine moarunga moatubu bibia-tina dita. Be tubuda ngaedi nge kangkang kandi inanga date. ");
INSERT INTO mva_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Bong Zekop bokai ilongo Izip kaba-lo kangkang ara ‘uit’ ieno nge tubuda inepidi be dilako. Alale nedi ngae nge matamatanatuka diemaki. ");
INSERT INTO mva_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Be alauri alale nedi ruaia-nao nge Iosep itaguraki be nena-la tokana-lo irangaki be dikauataki. Makara be ‘Pero’ nge Iosep toka be tama ikauatakidi. ");
INSERT INTO mva_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kodeka alauri nge Iosep itaguraki be tama Zekop ikeliaki be dara ne moarunga zaiza be Izip kaba-lo dilako. Iosep dara ne bong ngaradia-lo nge kulemoadi kulemoadi-lima-rua-be-lima moarunga. ");
INSERT INTO mva_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kodeka Zekop ilako Izip kaba-lo, be makara disukoaki nibe tubuda moarunga zaiza be dimate. ");
INSERT INTO mva_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Be alauri nge tapoudi bagadi dipura be Sekem anua-lo poda tekena-lo kumrakadi dipura. Poda ngae nge Abaram ka izazai. Amo natu moanekadi kaoana-lo ka ‘mone’ alu ane izazai. ");
INSERT INTO mva_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Bong ono Nanaranga pilenga moimoi be Abaram iemakini ngaemaki be dakalingo kana disaringa nge tamoata be aine neda Izip kaba-lo nge dikoko-tina. ");
INSERT INTO mva_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kodeka ‘Pero’ teke Iosep tago ikauataki nge kaba idoki be Izip kaba itanepoadi. ");
INSERT INTO mva_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","‘Pero’ ngae itaguraki be tamoata neda boli mata-lo ramoramo-ba ibabasakidi, be tubuda nge bokai igoalangakidi: iakangaodi be natudi mukumukudi dirokakidi, be ono damate kana. ");
INSERT INTO mva_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Be nge bong ngaedia-lo ka Moses nekiaka ipura. Moses nge natu kulanglang-tina. Nekiaka ipura nge kalea toli bokana tama pera kanana-lo komangaba-lo akolanga ipura. ");
INSERT INTO mva_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Be ono tago kaua ngapura natu-muku Moses komangaba-lo akolanga ipurapura nge eluku nangaia ipura. Be nge ramani ngaenao ka Pero natu aineka ite be idoki be ne natu bokana iaka-labati. ");
INSERT INTO mva_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Alauri ilaba nge Izip kaua nedi moarunga nge Moses suleni ipura be idoki, be pile-lo be muzi moarunga-lo nge ara ilaba-tina. ");
INSERT INTO mva_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Bong Moses barasi ne kulemoadi-oati nge ilo itekenanai be Israel ruanga ngatedi kana. ");
INSERT INTO mva_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ilako nge Izip tamoata teke ite Israel teke mata pakapaka ane ibasabasaki. Makara nge Moses itaguraki be Israel-ruanga nge ioiaki be Izip tamoata iumoatei. ");
INSERT INTO mva_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses bokai imuzi nge ilo ipileni Israel-ruanga masa kaba bokai daita Nanaranga ka ngai idumadumai be ono Israel-ruanga ngadumadi be rubetakadi dapura kana. Ata di tago dikaua. ");
INSERT INTO mva_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Izama nge Israel tamoata rua dieunungru be ipuraka-diaru. Be ono ilodiaru ngaka-uiadi kana nge bokai ira-diaru, ‘Tamoata kamru, kamru nge taritokatoka-ma! Bakara ka neming-lanaru kaeunungru?’ ");
INSERT INTO mva_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ata tamoata maka giriki labu be tamoata takaia iununi nge itaguraki be Moses irokateteki be bokai irai, ‘Naita inangaiko be kaiko biabiadi nema be giriki nema golililiti kana? ");
INSERT INTO mva_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ambe goumoateia kana nora-la Izip tamoata kumoatei bokana ki?’ ");
INSERT INTO mva_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses bokai ilongo nge taburi irani be iratu be Izip kaba ipereki be ilako Midian kaba-lo isukoaki. Makara be aine teke iuati be natu moane rua inekiakidiani. ");
INSERT INTO mva_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Barasi kulemoadi-oati dimanubu nge ‘enzel’ teke singaba muku teke ipurupururui-lo be Moses ipurakani lulu kaba-lo, buku ara Sainai saringa. ");
INSERT INTO mva_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses singaba ipurupururui ite nge ipitilaki-tina be ilako saringa be ngatea-uia kana. Ata Tanepoa malonga bokai ilongori, ");
INSERT INTO mva_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ngau tubum Nanaranga nedi. Ngau ka Abaram, Aisak be Zekop Nanaranga nedi.’ Makara nge Moses taburi ira-tina be reresabu tagona-tina iuia, be tago iboadu ngatada be kaba ngaita. ");
INSERT INTO mva_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Kodeka Tanepoa kaba bokai ipile, ‘Ae-sukuma nem gopasi, bakara kaba odio kutuitui nge kaba-rata kaoa. Maka ma ngau kaba ngaedia-lo usoaki. ");
INSERT INTO mva_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ngau moimoina-tina ambe tamoata be aine negu sururu bibia Izip-lo didokidoki nge uita-doi. Naboakingadi ambe ulongo be ambe ubala be muketidi kana. Aria, gokatiuana be mnepiko be kaba Izip-lo gomule kana.’ ");
INSERT INTO mva_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Bokai kamakaua: Moses-ma ngae ka Israel tamoata disegeaki. Be bokainatuka ditegi, ‘Naita inangaiko be kaiko biabiadi nema be giriki nema golililiti kana?’ Be nge Moses-ma ngae ka ‘enzel’ maka singaba muku ipurupururui-lo ipurakani duma nena-lo be biabiadi be uketiketi bokana be Nanaranga inepi be ialale. ");
INSERT INTO mva_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ngai ka bong Israel Izip kaba-lo disoaki be imuadi be Izip kaba dipereki. Be kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki nge Izip-lo be makasi ara Daradara-lo iemaki, be barasi kulemoadi-oati lulu kaba-lo dilepolepo nge kilala kaiboangdi iememaki be dialalale. ");
INSERT INTO mva_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Be nge Moses ngae ka Israel tamoata be aine bokai iradi, ‘Nanaranga masa kam neming maraming ka ‘propet’ teke ngau bokana nganepi be ngapura-kaming.’ ");
INSERT INTO mva_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Be bong Israel tamoata be aine lulu kaba-lo dikabuni be disoaki nge Moses ngae ka maradi isoaki. Ngai ka tubuda be ‘enzel’ maka buku ara Sainai-lo ipurakani zaiza disoaki-budu. Be nge ngai ka pile ono moauriuri-la soaki idoki be tubuda iandi, be di dibatadi be kita tadoki. ");
INSERT INTO mva_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ata tubuda Moses pilenga tagadi disege. Ditaguraki be disegeaki be ilodia-lo nge direre-tina kababe Izip kaba-lo damule. ");
INSERT INTO mva_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bokaibe ditaguraki be Aron bokai dirai, ‘Aem-kai alu goemaki-kama be damua be zala daitiking-kama. Moses-ma maka Izip-lo be ibaga-kama nge tago kikauataki ambe bakara iuai.’ ");
INSERT INTO mva_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Be nge bong ngaradia-lo ka aem-kai teke ‘bulumakau’ natu ditoaki be diemaki. Be ditaguraki be kana ngae nedi luma-di ane diemaki ono darakeaki kana nge tabataba dieluakini be moanako be oagu bibia diemakini. ");
INSERT INTO mva_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bokai ka Nanaranga itaguraki be imurinadi be iemakidi be kana makatabala lang-lo dieno nge dirakerakeaki. Bokaibe kana ngae nge pile tekedi ‘propet’ ‘buku’ nedia-lo geretadi dipura zaiza dilako-budu, ‘Israel tamoata be aine! Nge tago ngau ka barasi kulemoadi-oati lulu kaba-lo ngado kaumoatediana be katabangakina. Tago-la. ");
INSERT INTO mva_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nge nanaranga ara Molok ka bazarua ne ono rakeaka ipurapura nge kabazi, be nanaranga neming ara Ripan ka goai ne anunuka kabazi. Aem-kai ngaedi ka kaemaki be karakeaki. Bokai ka ngau masa mnepi-kaming be kasau-tina Babilon kaba-lo kamalako be akerenga-ming bokana makara kamasukoaki.’ (Aim 5:25-27) ");
INSERT INTO mva_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Bong tubuda lulu kaba-lo dialalale nge bazarua ono Nanaranga isoaki nge sakedio ieno. Bazarua ngae nge Nanaranga-la Moses irai bokana ka emaka ipura be baituka emaka ngapura kana nge Nanaranga ka nena-la be Moses itikini. ");
INSERT INTO mva_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Be tubuda ka bazarua ngae aniadi ipura. Be alauri nge Zosua zaiza be dibazi be Nanaranga imua be ungguma makara disoaki nge itaodi be tubuda dimai be kateka nedi didokiledi. Be bazarua ngae nge makara ieno nibe imai-ba Debiti-lo daga. ");
INSERT INTO mva_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Debiti nge Nanaranga rerengana-lo ilako. Bokaibe Debiti itaguraki be Nanaranga itegi be pera ono soakinga teke Zekop Nanaranga ne ngaemakani kana. ");
INSERT INTO mva_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ata tago ngai ka pera ngae ikeli. Nge Solomon ka pera ngae Nanaranga ikeliani. ");
INSERT INTO mva_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ata Nanaranga Atabalabala-tina nge tago pera tamoata dikelikeli-lo isukoaki ‘propet’-la teke ipile bokana, ‘Tanepoa bokai ipile, ");
INSERT INTO mva_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Lang anua nge bagi ono tanepoanga negu, be kateka ngae nge ngau ae salangaka negu. Masa pera bakarairai gokeliana? Tago iboadu! Kaba ono manauanga negu inanga dieno? Tago-la! ");
INSERT INTO mva_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Maka ma kana moarunga ngaedi nge ngau ka uemaki!”’ (Ais 66:1-2) ");
INSERT INTO mva_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Pangana-ming patu bokana! Nanaranga pilenga tagona-tina iloming-lo kananga be kungi-ming tagona-tina pilenga dilongo! Kam nge tubuming-la bokana! Oli Spirit pilenga dokiadi kasegesege-tina! ");
INSERT INTO mva_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ak, ‘propet’ moarunga makare kateka-o dipura nge tubu-ming tago teke ditea-ba be ilako. Moarunga-biabia nge sururu bibia-tina diandi! Be tamoata maka matamata be Tamoata Adoado puranga dirangaki nge diumoatedi be! Be nge kodeka nge kam ka tamoata ngae erekei luma-dio kanangai be umoatea ipura. ");
INSERT INTO mva_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kam-tina ma ka Nanaranga pilenga ‘enzel’ dinege be diemaki be dikalingo nge kadoki, ata pile ngaedi tago katagadi!” ");
INSERT INTO mva_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Bong tamoata bibia Iuda ‘Kansolo’ nedia-lo disoaki Stepan pilenga ngaedi dilongo nge ilodi disururutakia-tina be iledi dikaraposa. ");
INSERT INTO mva_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ata Stepan nge Oli Spirit ilona-lo ikauri be lang anua-lo itadalako nge Nanaranga kaiboang be malama ne ita, be Iesus nge Nanaranga oana-nao ituitui be ite. ");
INSERT INTO mva_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kodeka bokai ipile, “Kamate! Ngau lang anua ute itakaka, be Tamoata Natu nge Nanaranga oana-nao ituitui!” ");
INSERT INTO mva_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tamoata bibia Iuda ‘Kansolo’ nedia-lo disoaki bokai dilongo nge luma-di ane kungidi diono. Kodeka dituirake be bong-doi teke Stepan ono dipananalako, ");
INSERT INTO mva_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","be didoki be eluku direpeka-lako. Kodeka ditaguraki be patu ane diuni. Be bong diuniuni nge tamoata ngaedi ditaguraki be kusi-sili nedi bibia dinangananga nge dipasi be tamoata amuna teke ara Sol sakenao dinanga. ");
INSERT INTO mva_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Makara patu oti diuniuni nge Stepan bokai irabo, “Tanepoa Iesus, mariabakagu godoki!” ");
INSERT INTO mva_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kodeka tuku-nao irokazokuria be bokai ipile, “Tanepoa, muzigoala ngae nge moaki odio kunangalako!” Bokai ipile-doi kodeka imate. ");
INSERT INTO mva_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Be tamoata ara Sol nge makara isoaki be Stepan matenga nge isumoalataki. Be amari-nala ngarana-lo nge tamoata be aine moarunga Ierusalem ‘sios’-lo nge sururu goalakadia-tina didoki. Bokaibe tamoata be aine moarunga Kristus lama diunani nge dimarama be ege-ege Zudea kaba be Samaria kaba-lo dilako be disoaki, ata ‘apostel’ nge tago dimarama. Ierusalem-lanalo disoaki. ");
INSERT INTO mva_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Makara be tamoata alu Nanaranga ditagatagai nge Stepan dikumraki be nodo be tang biabia-tina diemakani. ");
INSERT INTO mva_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ata Sol nge ambe ‘sios’ iara-leualeuai. Bokaibe pera pera-lo ilakolako be tamoata Kristus lama diunani nge moane be aine idokireperepekidi be uaura pera-lo irorokakidialako. ");
INSERT INTO mva_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tamoata be aine lama diuni dimarama be ege-ege dilako nge Nanaranga pilenga mangata dirarangaki be dialalale. ");
INSERT INTO mva_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip ilako anua bibia teke Samaria kaba-lo be makara Kristus mangata irangaki. ");
INSERT INTO mva_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bong tamoata be aine dum bibia Pilip pilenga dilongo nge kungidi dibabaki be dilongoria-tina uia, bakara kilala kaiboangdi Pilip iemaki nge dita. ");
INSERT INTO mva_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Be mariaba goalakadi tamoata kokoko-tina ilodia-lo disoaki nge itaotaodi be kaikai-la dimeremere be diraturatu. Be tamoata tapoudi matedi, be aedi be luma-di daidi nge kokoko-tina adorakadi dipura. ");
INSERT INTO mva_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Bokaibe anua biabia ngarana-lo nge suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Anua ngarana-lo nge tamoata teke isoaki ara Saimon. Ngai ambe uanana sasalaga muku makara simago ne ane be kolo-kolo iememaki be ono Samaria tamoata be aine iaua-sasangangadi. Nena-la irangarangaki ngai nge ara bibia-tina. ");
INSERT INTO mva_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Be moarunga-doi anua ngarana-lo aradi otioti be aradi tagotago nge ngaia-la ka pilenga ditagatagadi. Be bokai dirangaki, “Tamoata ngaeni nge Nanaranga kaiboang ne aradi ‘Kaiboang Bibia’ nge dienoni.” ");
INSERT INTO mva_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tamoata be aine Saimon ditagatagai, bakara ambe uanana sasalaga-tina simago ne ane be iaua-sangangadi. ");
INSERT INTO mva_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ata bong Pilip Pile Uia ono Nanaranga anua ne itanepoa kana be Iesus Kristus irangakidi nge lama diuni be moane be aine nge Iesus ara-nao be rukuadi dipura. ");
INSERT INTO mva_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Be Saimon nge lama iuni be. Alauri Iesus ara-nao be rukuia ipura nge Saimon itaguraki be Pilip-la ka itagatagai be ege-ege dialalaleru. Be bong kilala kaiboangdi be kilala kaiboangdi Nanaranga-la iboadu ngaemaki emakadi dipurapura be itaita nge ikakabaki-tina. ");
INSERT INTO mva_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bong ‘apostel’ enera Ierusalem-lo pile bokai dilongo Samaria tamoata be aine Nanaranga pilenga didoki be ilodia-lo dinanga nge ditaguraki be Pita be Zon dinepidi be Samaria dilakoru. ");
INSERT INTO mva_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Be bong dilakoru nge diraboru be ono tamoata be aine lama diuni nge Oli Spirit dadoki kana. ");
INSERT INTO mva_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bakara, Oli Spirit isi tago odio ibala. Moimoi di moarunga nge Tanepoa Iesus ara-nao ka rukudi dipura, ata Oli Spirit tago odio ibala. ");
INSERT INTO mva_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Makara be Pita be Zon ditagurakiru be luma-diaru odio dinangaria be Oli Spirit didoki. ");
INSERT INTO mva_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon kaba bokai ita bong ‘apostel’ Samaria tamoata be aine luma-diaru odio dinangariaru nge Oli Spirit didoki. Bokaibe itaguraki be Pita be Zon ‘mone’ itoringaki-diaru be bokai ipile, ");
INSERT INTO mva_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Kaiboang ngaedi kamanauru. Bokai masa tamoata naita luma-gu ono unangaria nge Oli Spirit ngadoki.” ");
INSERT INTO mva_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ata Pita ikatu be bokai ipile, “Iboadu ‘mone’ nem zaiza be ara-be-leuanga godoki, bakara kaiko ilom ipile Nanaranga lumaluma ne iboadu ‘mone’ ane gozazai! ");
INSERT INTO mva_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Kaiko ilom eara nge Nanaranga mata-nao tago iado. Bokaibe tago iboadu malipi nema ngaena-lo nge malipi ege teke goemaki ki malipi teke gangko be goemaki. Tago-la! ");
INSERT INTO mva_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mata goala ngae ilom iani nge gorokaki be ilom gobuiri be Tanepoa goraboi. Baraoa giriki goalaka ngae ilom-lo be ilom iani nge ngarokakaleko. ");
INSERT INTO mva_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Maka ma ngau ilom ute nge mangazi kaiboangi ilom-lo ikauri be muzigoala diuaukotoiko be kusoaki.” ");
INSERT INTO mva_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kodeka Saimon bokai ipile, “Ngau kanabe Tanepoa kamaraboiaru. Bokai masa kana karangakiru nge tago dapurana.” ");
INSERT INTO mva_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Alauri Tanepoa pilenga mangata dirangakiru be rakana Nanaranga iemaka-diaru dirangaki-doiru nge Pita be Zon kaba Ierusalem-lo dimulelakoru. Dimulemule-ru nge Samaria anua moarunga zala-lo dieno-lo nge Pile Uia mangata dirangarangakiaru be dialalaleru. ");
INSERT INTO mva_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Makara nge Tanepoa ‘enzel’ ne teke Pilip bokai irai, “Gotui be zala Ierusalem-lo be ilako Gaza-lo nge ege atanga gotagai.” Zala ngae nge lulu kaba-lo ka ieno. ");
INSERT INTO mva_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bokaibe Pilip itui be ialale. Zala-lo nge Itiopia tamoata biabia teke ipurakani. Tamoata ngae ka Itiopia ‘Kandensi’ nedi, ki kita tapile moaede kandi nge ‘mone’ be kana moarunga ne ipapananuaki. Tamoata ngae nge ilako Ierusalem-lo Nanaranga irakeaki ");
INSERT INTO mva_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ka ambe imulemule. Bagi ‘osi’ diraperape nenao isoaki be ‘buku’ ‘propet’ Aisaia igere nge ilezeleze. ");
INSERT INTO mva_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kodeka Oli Spirit Pilip bokai irai, “Golako ene bagi ‘osi’ diraperape ngara saringa be sakenao goalalale.” ");
INSERT INTO mva_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pilip ipananalako be ilongori ‘buku’ ‘propet’ Aisaia igeretia-lo ka ilezeleze bokana itegi, “Kana kulezeleze ngaradi nge kukauataki ki tago?” ");
INSERT INTO mva_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Be tamoata biabia ngae bokai ikatu, “Masa bakara be mkaua? Tamoata-ma teke labudi nganagupasina ka masa mkaua!” Bokaibe tamoata ngae itaguraki be Pilip ikilarake be sakenao isoaki. ");
INSERT INTO mva_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Itiopia tamoata ngae nge Nanaranga ‘Buku’ ne egedi ngaedi ka ilezeleze, “Suri nge ‘sipisipi’ umoatea ngapura kana be bagaia ipura bokana, be tea nge ‘sipisipi’ natu moaneka donga korota ipurapura be imoadubulae-ba bokana. Bokaibe aoa tago sesu ikakati. ");
INSERT INTO mva_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dibalaki be digoalangakia-tina, be ‘koto’ ne nge tago diadoraki uia, be didoki be diumoatei. Tamoata zugu ngarana-lo nge muzingadi digoala-tina. Bokaibe tago ambe kateka ngaeno isoaki.” (Ais 53:7-8) ");
INSERT INTO mva_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kodeka Itiopia tamoata biabia ngae nge Pilip bokai itegi, “Goraia! Naita ka makare ‘propet’ ngae irangarangaki? Nena-la ka irangarangaki ki tamoata takaia?” ");
INSERT INTO mva_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kodeka Pilip itaguraki be pile labudi inagupasini. Nanaranga ‘Buku’ ne egedi ilezeleze kanana-lo be Iesus rangaka Pile Uia-lo dieno nge irangakini. ");
INSERT INTO mva_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Zala ngara disauaniaru be dilakoru be dang mukudi aluna-lo dipuraru nge Itiopia tamoata bokai ipile, “Gote! Dang alu makare dieno! Bakara ka tago iboadu Iesus ara-nao be rukuiagu ngapura?”  ");
INSERT INTO mva_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Be Pilip bokai ipile, “Iboadu rukuiam ngapura. Ilom ere-moarunga be lama kuni masa rukuiam ngapura. Tago be tago!” Be tamoata biabia ngae ikatu be bokai ipile, “Moimoi lama uni. Ngau lama uni Iesus Kristus nge Nanaranga Natu.” ");
INSERT INTO mva_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Kodeka tamoata biabia ngae ipile be ‘osi’ ne makara itui. Be diposiru be dang-lo dilakoru be Pilip itaguraki be tamoata biabia ngae Iesus ara-nao be irukui. ");
INSERT INTO mva_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Dang-lo be dipusikarake-ru nge Tanepoa Oli Spirit ne ipura be oaikiki-tina Pilip ibagai. Moimoi Itiopia tamoata biabia ngae nge Pilip tago sesu kaba ite, ata suri uia-lo be ialale. ");
INSERT INTO mva_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ata Pilip nena-la ite nge ambe Asdod anua-lo ka isoaki. Bokaibe itaguraki be anua moarunga-lo ilakolako be Pile Uia mangata irangarangaki be ialalale nibe Sisaria anua-lo ipura. ");
INSERT INTO mva_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Bong ngaradia-lo nge Sol isi Tanepoa tagataga ne ngaumoatedi kana be ikara-ngitingitiakidi. Bokaibe ilako tamoata Nanaranga ditabatabai bibiatuka nedia-lo ");
INSERT INTO mva_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","be irai be pera ono serereinga moarunga Damaskus anua-lo dieno nge ‘pasi’ teke ngageretadi be dakaua Sol nge ngai ka inepi. Bokai masa tamoata naita Tanepoa Zala ne itagatagai makara Damaskus-lo ite, aine ki moane, masa ngauauri be ngabagai be Ierusalem-lo ngalakuaki. ");
INSERT INTO mva_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Makara be Sol itui be Damaskus ilako. Anua isaringaringai noko oaikiki-tina malama teke lang-lo ka ipitikaoai be ibala be iboalingi. ");
INSERT INTO mva_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Makara nge Sol kateka-o itapuloria be malonga teke bokai irarai be ilongori, “Sol! Sol! Bakara ka sururu bibia kuianana?” ");
INSERT INTO mva_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Be Sol ikatu be bokai itegi, “Tanepoa, kaiko naita kata?” Be malonga ngae bokai ipile, “Ngau Iesus! Ngau ka sururu bibia kuianana! ");
INSERT INTO mva_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gomarang be Damaskus anua-lo golako. Makara masa rakana goemaki kana nge daraiko.” ");
INSERT INTO mva_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Tamoata maka Sol zaiza dialalale-budu nge bokaina-ba pile tagotago dituitui. Malonga ra dilongori, ata rakana ka irangarangaki nge tago dikaua. ");
INSERT INTO mva_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Makara be Sol ea kateka-lo ieno ka imarangrake. Be bong imarangrake be mata ipoarakaki nge kana tago teke ite. Mata dileuani. Bokaibe tamoata dialalale-budu nge luma-nao didoki be diaromuani be Damaskus anua-lo dilakuaki. ");
INSERT INTO mva_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Be makara amaridi toli mata dileuani be isoaki. Be ramani ngaranao nge kangkang tago teke ikani be dang tago sesu ising. ");
INSERT INTO mva_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Makara Damaskus anua-lo nge tagataga teke isoaki ara Ananias. Bong teke isoaki nge raio bokana ilako, be Tanepoa bokai ikilai, “Ananias.” Be Ananias ikatu be bokai ipile, “O! Tanepoa. Maka usoaki.” ");
INSERT INTO mva_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Be Tanepoa bokai ipile, “Gotui be golako zala biabia ara Adoado-lo be tamoata ara Iudas pera kanana-lo golako. Makara kupura nge Tarsus tamoata ara Sol gotegiaki. Makara isoaki be iraborabo. ");
INSERT INTO mva_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Raio bokana ilako be kaba bokai ita: tamoata teke ara Ananias ipura be luma ono inangaria be mata diuia be kababe kaba ita.” ");
INSERT INTO mva_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ata Ananias ikatu be bokai ipile, “Tanepoa, tamoata ngae ruku kokoko-tina ulongo. Kana goalakadia-tina ka tamoata be aine nem Ierusalem-lo iememikidi. ");
INSERT INTO mva_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Be nge tamoata Nanaranga ditabatabai dimuamuadi kaiboang nedi-o ka makare Damaskus-lo ipura be tamoata be aine aram dikilakilai nge ngauauridi kana.” ");
INSERT INTO mva_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Be Tanepoa bokai ipile, “Gotui be golako! Tamoata ngae nge ambe kati negu bokana uauri be lung-o unangai. Ngai ka aragu ngabazi be Ungguma Takadia-lo, anuatanepoa moarunga-lo be Israel tamoata be aine moarunga-lo ngalakuaki kana. ");
INSERT INTO mva_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Be ngau negu-la masa mitikini aragu-o masa sururu bibia-tina ngadoki!” ");
INSERT INTO mva_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Bokaibe Ananias itui be Iudas pera kanana-lo ilako. Ilako nge pera-lo isili be luma Sol-o inangaria be Nanaranga iraboi. Be bokai ipile, “Tarito Sol, Tanepoa ka inepia be upura. Iesus-ma maka makare kupurapura be zala-lo ipurakaniko-re nge ka inepia be makare upura be ono kaiko masa kababe kaba goitaita, be Oli Spirit aniam ngapura.” ");
INSERT INTO mva_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananias bokai ipile nge oaikiki-tina kana tekedi teadi ika inakadi bokana nge Sol matana-lo ka digalalai, be makara be kaba kaba itaita. Kodeka ituirake be Iesus ara-nao be rukuia ipura. ");
INSERT INTO mva_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Rukuia ipura, kodeka imoanako be kaiboang ne dimule. Alauri nge Sol makara Damaskus anua-lo Kristus tagataga ne zaiza amaridi alu isoaki nge ");
INSERT INTO mva_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","oaikiki-tina ilako pera ono serereinga-lo be Iesus mangata bokai irangarangaki, “Iesus ka Nanaranga Natu!” ");
INSERT INTO mva_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Moarunga dilongori nge dipitilaki-tina be bokai dipile, “Tamoata ngae ki naita ka tamoata be aine maka ara ngaenao be dikilaulau Ierusalem anua-lo iumoatemoatedi? Be nge makare ipura nge suri ngauauridi be tamoata Nanaranga ditabatabai dimuamuadi luma-dio nganangadi kana ka ipura ki tago?” ");
INSERT INTO mva_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ata Sol pilenga nge kodeka dikaiboang-tina. Be pile moarunga labudi inagupasipasi be itikitikingdi Iesus ka moimoi be Kristus. Bokaibe Iuda Damaskus anua-lo disukoaki nge ilodi iung-tina be tago sesu pilenga dikatu. ");
INSERT INTO mva_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ambe amaridi kokoko-tina dilako nge Iuda moarunga diepurari be diraba be Sol daumoatei kana, ");
INSERT INTO mva_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ata Sol rabangadi nge ilongoraki. Ariata be oabubu-lo nge anua babaduadua ne bibia dinarinaring uia be Sol daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ata oabubu tekena-lo nge Sol tagataga ne ditaguraki be Sol didoki be raba kanabiabia tekena-lo dinangalako, be dilakuaki ari bibia anua diboalingia-lo be kalalang-boazinga tekena-lo be eluku diurumalako be iratu. ");
INSERT INTO mva_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Bong Sol Ierusalem-lo ipura nge ilako be Kristus tagataga ne ngasilidi kana, ata di moarunga nge dimatakuri. Maka ma ilodi bokai dinanga, “Sol moimoibe Iesus tagataga ne kata ki ibobolesikita-ba?” ");
INSERT INTO mva_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ata Barnabas ilako be ibagai be ‘apostel’-lo ilakuaki. Kodeka iradi baituka be zala-lo be Tanepoa ite, be Tanepoa nena-la be baituka Sol irai. Be bong Damaskus anua-lo isoaki nge taburi tago irani be ramoramo-la Iesus ara-nao be mangata isulesule. ");
INSERT INTO mva_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Bokaibe Sol makara sakedi-o isoaki be ramoramo-la Ierusalem anua-lo ialalale be Tanepoa ara-nao be ramoramo kaikai-la mangata isulesule be ialalale. ");
INSERT INTO mva_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Be ilako Iuda maka Grik pile-la diamang zaiza pile diserereitaki be diegoretaki, ata tamoata ngaedi ditaguraki be daumoatei kana. ");
INSERT INTO mva_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bokaibe bong taritoka-da Iesus lama diunnani dilongo nge dibagalako Sisaria anua-lo be Tarsus dinepialako. ");
INSERT INTO mva_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kodeka makara nge ‘sios’ ege-ege Zudea kaba-lo, Galili kaba-lo be Samaria kaba-lo nge soaki uia-lo eno. Oli Spirit kaiboang nena-lo be ‘sios’ kaiboang idoki be tamoata be aine kokoko-tina disilisilini be dikoko-tina. Be izamaizama nge Tanepoa dimatakutakuri be disukoaki. ");
INSERT INTO mva_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita nge ege-ege ialalale be kaba itaita. Be bokai ialalale nge ilako Lida anua-lo be Nanaranga tamoata be aine ne itedi. ");
INSERT INTO mva_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Makara nge tamoata tapou matedi teke ara Ainias ite. Tamoata ngae nge ambe barasi lima-toli bokaina-la zirapu-lo ieneno. ");
INSERT INTO mva_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Kodeka Pita bokai ipile, “Ainias, Iesus Kristus ka iadorakiko. Gomarang be zirapu nem goloku.” Makara nge Ainias oaikiki-tina ituirake. ");
INSERT INTO mva_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tamoata be aine moarunga makara Lida be Saron anua-lo disukoaki dite nge ilodi dibuiri be Tanepoa ditalari. ");
INSERT INTO mva_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Zopa anua-lo nge aine teke Kristus tagataga ne isoaki ara Tabita. (Ara Tabita tabuiri nge Grik pile-lo Dorkas kana tapile.) Ngai muzi uia-la ka iememaki be tamoata kana nedi tagotago nge izamaizama idumadumadi. ");
INSERT INTO mva_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Bong ngaradia-lo nge imore be imate. Be dirukui be pera ilo atabalabala tekena-lo dinangai. ");
INSERT INTO mva_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida anua nge Zopa anua saringa ka ieno. Bokaibe bong tagataga Zopa-lonalona dilongo Pita Lida anua-lo isoaki nge oaikiki-tina tamoata rua Pita-lo dinepidialako be bokai diakoroiaru, “Oaikiki-tina gomai kana kirere.” ");
INSERT INTO mva_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bokaibe Pita itui be dialale-buduto. Be bong makara dipura nge pera ilo atabalabala-lo dilakuaki. Makara nge narenare moarunga Pita diboalingi be kusi-sili bibia be kusi nangananga takadi Dorkas isi ne iauia be iemaki nge ditikitikini be ditangtang. ");
INSERT INTO mva_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Makara be Pita itaguraki be inepidi be dipusika-doi, kodeka tuku-nao irokazokuria be Nanaranga iraboi. Irabo-doi, nge ibuiri be aine mate italari be bokai ipile, “Tabita, gomarang!” Bokai ipile nge aine ngae mata ipoarakaki. Mata ipoarakaki be Pita ite ngena imarang-rake. ");
INSERT INTO mva_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Kodeka Pita itaguraki be luma-nao idauraki be idumai be itui-rake. Makara be narenare moarunga be tamoata be aine takadi Kristus lama diunani nge ikiladi be moauriuri ka lumadi-o isalangaki. ");
INSERT INTO mva_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kana ngae bokai ipura nge rangaka ege-ege Zopa anua-lo ilako. Bokaibe kokoko-tina Tanepoa lama diunani. ");
INSERT INTO mva_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Be Pita nge makara Zopa-lo amaridi alu tamoata ngado kusidi isisisi ara Saimon sakenao isoaki. ");
INSERT INTO mva_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sisaria anua-lo nge tamoata teke Rom koai-bagi nedi teke imuamuadi ara Kornilius isoaki. Tamoata ngae nge koai-bagi tamoata ‘100’ moarunga imuamuadi, be koai-bagi ngae nge Itali koai-bagi kana ditugani. ");
INSERT INTO mva_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius roa be natu zaiza nge Nanaranga dirakerakeaki be ditagatagaia-tina uia. Iuda tamoata kana nedi tagotago nge kana kokoko-la be ianiandi, be bong kokoko Nanaranga iraboraboi. ");
INSERT INTO mva_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bong teke rairai, amari ambe ibala siriki tolianao nge rai kaba-lo bokana ilako. Isoaki nge mangata-tina matana-lo Nanaranga ‘enzel’ ne teke ipura be ikilai, “Kornilius.” ");
INSERT INTO mva_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kornilius nge taburi ira-tina be ‘enzel’ idedepoatoki be bokai itegi, “Tanepoa. Rakana?” Be ‘enzel’ ngae ikatu be bokai irai, “Nanaranga ambe rabo nem ilongo be tamoata kana nedi tagotago kudumadumadi nge ita be idoki, be ambe ilo iangko. ");
INSERT INTO mva_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gotui be tamoata alu gonepidi be dalale Zopa anua-lo be tamoata kata ara Saimon, Pita kana dikilakilai nge dabagai be makare dapuraki. ");
INSERT INTO mva_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Tamoata ngado kusidi isisisi ara Saimon pera kanana-lo isoaki. Tamoata ngae pera kana nge makasi zagenao ka ieno.” ");
INSERT INTO mva_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Bong ‘enzel’ ialale nge Kornilius itaguraki be malipilipi kana rua be tamoata koai-lo dumaduma ne teke Nanaranga mata ne itagatagadia-tina uia nge ikiladiato. ");
INSERT INTO mva_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Kodeka kana moarunga dipurani nge irangakidiato be inepidiato be Zopa dilakoto. ");
INSERT INTO mva_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Izama be ambe saringatuka amari malala ngaeno kana nge tamoata toli Kornilius inepidiato nge ambe Zopa anua disaringaiato, be Pita ikautaki pera nokunao be ngarabo kana. ");
INSERT INTO mva_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Tole nge imate be ngamoanako-tina kana irere. Be bong kangkang diememaki nge ngai rai-o bokana ilako. ");
INSERT INTO mva_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Bokai isoaki nge lang itakaka be kana teke kusi mapala kanabiabia bokana zage oati-lo dokia ipura be kateka-o urumaria ipurapura be ite. ");
INSERT INTO mva_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kusi mapala ngae ilona-lo nge ngado putudi oati-oati moarunga, moata be oakei moarunga be mang moarunga nge dieno. ");
INSERT INTO mva_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Kodeka malonga teke Pita bokai irai, “Pita, gotuirake. Ngado goumoatedi be gomoanako.” ");
INSERT INTO mva_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ata Pita ikatu be bokai ipile, “Tanepoa, tagona-tina iboadu! Maka ma kana bolobolo ki sangalangala nge tagona-tina teke aoagu-o idum.” ");
INSERT INTO mva_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pita bokai ipile nge malonga ngae kababe bokai irai, “Kana moarunga Nanaranga ambe iaka-goazadi nge tagona-tina iboadu dibolo kana gorangaki.” ");
INSERT INTO mva_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pile ngaedi nge bong toli emakadiani ipura, kodeka kusi mapala ngae nge kababe lang-lo repekalako ipura. ");
INSERT INTO mva_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita nge isi rai kaba ngaedi labudi ilelelenaki-la be tamoata toli Kornilius inepidi be dipura nge Saimon pera kana disikengtakadiato be dipura be babaduaduana-lo dituituito. ");
INSERT INTO mva_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Kodeka dikilau be bokai ditegi, “Saimon ara takaia Pita makara isoaki ki tago?” ");
INSERT INTO mva_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita nge isi rai kaba ngaedi labudi ngakauataki kana be imuzimuzi be Oli Spirit bokai ipile, “Kaba goita! Tamoata toli dileleleikoto. ");
INSERT INTO mva_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gotui be gotaoio. Gotagadi be kamalale-budu kana nge moaki ilom irua. Ngau ka unepidi be dipura.” ");
INSERT INTO mva_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Makara nge Pita itaoio be tamoata toli ngaedi bokai iradi, “Nge ngau ka kaleleleiauto. Bakara ka kapurato?” ");
INSERT INTO mva_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Be tamoata ngaediato dikatuto be bokai dipileto, “Koai-bagi pangana nedi Kornilius inepi-kama ka kipura. Ngai tamoata iauia be Nanaranga imatakutakuri, be Iuda moarunga nge dimuamuaki. Nanaranga ‘enzel’ ne teke irai be pera kanana-lo golako be pilengam ngalongo kana.” ");
INSERT INTO mva_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kodeka Pita itaguraki be tamoata toli ngaediato nge pera-lo ibagadilakoto be oabubu ngarana-lo nge makara disoakito. Izama nge Pita itui be tamoata toli ngaedi itagadi. Be tamoata alu Kristus lama diunani Zopa anua-lonalona nge ditagadi be dialale-budu. ");
INSERT INTO mva_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kaba izama kodeka Sisaria anua-lo dipusikalako. Kornilius nge irarapungdi be isoaki. Dara ne moarunga be ruanga uia moarunga nge ikeliakidi be dirapurapu-budu be disoaki. ");
INSERT INTO mva_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita ambe Kornilius pera kanana-lo isilisili nge Kornilius imai be Pita ae babadia-lo iboadukuria be irakeaki bokana. ");
INSERT INTO mva_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ata Pita itaguraki be Kornilius ituirakarake be bokai irai, “Gotuirake. Ngau negu-la nge tamoata-ramo kata.” ");
INSERT INTO mva_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Makara be dipilepileru be pera-lo disiliru. Disiliru nge Pita tamoata be aine kokoko-tina pera ilona-lo itedi. ");
INSERT INTO mva_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Be bokai iradi, “Kam neming-la be kakaua Iuda mata nema dipile Iuda tamoata tagona-tina iboadu Ungguma Takadi ngasilidi ki ngalako be ngatedi. Ata Nanaranga ambe nena-la be itikina tamoata tago teke iboadu bolobolo ki sangalangala kana mrangaki. Tago-tina. ");
INSERT INTO mva_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Bokaibe bong kakeliaka nge tago usege. Utui-ba be makare upura. Iboadu bokai mtegi: Bakara ka kakeliaka?” ");
INSERT INTO mva_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Be Kornilius ikatu be bokai ipile, “Norane, ambe amaridi oati dilako nge pera kanagu-lo uraborabo. Ambe irairai kaituka-tina bokana, amari ambe siriki tolianao ieno ka uraborabo. Uraborabo nge oaikiki-tina tamoata teke kusi ne oaoa-sepukadi arogu ituitui. ");
INSERT INTO mva_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Be bokai iraia, ‘Kornilius, Nanaranga ambe rabo nem ilongori, be lumaluma nem tamoata kana nedi tagotago kuianiandi nge ilo iandi. ");
INSERT INTO mva_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tamoata alu Zopa gonepidialako be Saimon ara takaia Pita nge dabagai. Makara tamoata ngado kusidi isisisi ara Saimon pera kanana-lo lou ne bokana isukoaki. Pera kana nge makasi zagenao ka ieno.’ ");
INSERT INTO mva_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Bokai ka oaikiki-tina unepi be dibagaiko. Makare kupura nge muzi iauia-tina ka kuemaki. Keka moarunga kaituka makare kisoaki nge Nanaranga mata-nao ka kiepurari, be Tanepoa baituka iraiko be gora-kama kana nge pilenga moarunga galongo kana ka kipura.” ");
INSERT INTO mva_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kodeka Pita itaguraki be bokai ipile, “Kodeka ukaua moimoina-tina Nanaranga tamoata moarunga suridi tekedi bokana ibabasakidi. ");
INSERT INTO mva_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ungguma moarunga-lo nge bokai imuzimuzi: Tamoata rangguma dimatakutakuri be mata adoadodi ditagatagadi nge ne bokana idokidokidi. ");
INSERT INTO mva_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Be nge pile ngaedi ka Nanaranga idoki be Israel tamoata be aine inangadi. Pile Uia ono anua-uia dokinga ngae ka Iesus Kristus iani, be Iesus itaguraki be mangata irangaki. Iesus ka tamoata moarunga Tanepoa nedi. ");
INSERT INTO mva_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Be kana ege-ege Zudea kaba-lo dipura nge kam kakauataki, bong matamata Galili kaba-lo be Zon ruku ono tamalinga mangata irangaki muridi be imai-ma! ");
INSERT INTO mva_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Be Nasaret tamoata ara Iesus nge rangaka kam kakauataki. Be baituka be Nanaranga itaguraki be Oli Spirit ane be Iesus kaiboang iani nge kam kaua. Be ege-ege ilakolako be muzi uia iememaki be tamoata Satang kaiboang ne eruma disoaki nge iaka-uiauiakidi. Maka ma Nanaranga Iesus sakenao isoaki. ");
INSERT INTO mva_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Be keka nge mata-ita ne bokana. Kana moarunga ungguma Iuda kaba nedia-lo be Ierusalem anua-lo be Iesus iemaki nge keka kita-doi. Kai-o dirokatagaki be imate, ");
INSERT INTO mva_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ata amari tolianao be Nanaranga mate-lo be imarangaki be mangata inangai be tea ipura. ");
INSERT INTO mva_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tago tamoata moarunga ka dite. Tago. Kekai-la mata-ita Nanaranga ambe inanga-kama ka kite. Mate-lo be imarang nge kimoanako-budu be dang kising-budu. ");
INSERT INTO mva_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Be irakama be Pile Uia tamoata be aine mangata garangakadi kana, be mangata bokai gapile, ‘Tamoata ngae ka Nanaranga inangai be tamoata moauriuri disoaki be tamoata matedi giriki nedi ngaliliti kana.’ ");
INSERT INTO mva_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","‘Propet’ moarunga nge ngai ka dirangaki. Bokai dirangaki, ‘Tamoata moarunga lama diunani masa ara kaiboang nena-lo be muzigoala nedi rokakadialedi dapura.’” ");
INSERT INTO mva_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita isi ipilepile-la be tamoata be aine pile dilongolongo nge Oli Spirit odio ibala. ");
INSERT INTO mva_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iuda tamoata kusidi korotototo Kristus lama diunani Pita zaiza be Zopa-lo be dipura kaba bokai dita Nanaranga ambe Ungguma Takadi Oli Spirit odio isuburakaria nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Maka ma Iuda tamoata ngaedi nge kaba bokai dita Ungguma Takadi ngaedi nge pile takadia-lo dipilepile. Bokaibe Nanaranga kaiboang ne dirakerakeaki. Kodeka Pita bokai ipile, ");
INSERT INTO mva_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tamoata ngaedi ambe kita-la Oli Spirit tadoki bokana be ambe didoki. Bokaibe dang oti be ruku ono tamalinga ane rukuadi dapura. Tamoata tago teke iboadu ngababaridi!” ");
INSERT INTO mva_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Bokaibe iradi be Iesus Kristus ara-nao be rukudi dipura. Kodeka ditaguraki be Pita diakoroi be amaridi alu makara sakedio ngasoaki kana. ");
INSERT INTO mva_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","‘Apostel’ moarunga be taritoka-da moarunga Kristus lama diunani ege-ege Zudea kaba-lo disoaki nge ambe dilongo Ungguma Takadi ambe Nanaranga pilenga didoki. ");
INSERT INTO mva_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bokaibe bong Pita Ierusalem ilako nge Iuda tamoata kusi korototo mata ditagatagadia-uia nge bokai dingongoi, ");
INSERT INTO mva_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Kaiko kulako tamoata kusidi tago korotototo-lo be pera kandia-lo kumoanako!” ");
INSERT INTO mva_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kodeka Pita itaguraki be kana moarunga dipuralani bokana bokai irangakidi, ");
INSERT INTO mva_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Bong teke Zopa anua-lo usoaki be uraborabo nge rai-o bokana ulako be kaba bokai uita: Kusi mapala kanabiabia teke zage oati-o dokia ipura be lang-lo be urumaria ipura be sakegu-o ibala. ");
INSERT INTO mva_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Kana ngae ilona-lo utudulako nge ngado putudi oati-oati moarunga, ngado kabukabu moarunga, moata be oakei moarunga be mang moarunga makatabala lang-lo diroro nge uita. ");
INSERT INTO mva_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Makara be malonga teke ulongori bokai ipile, ‘Pita, gotui! Ngado goumoatedi be gokang.’ ");
INSERT INTO mva_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ata ngau bokai ukatu be upile, ‘Tagona-tina iboadu. Kana bolobolo ki sangalangala nge tagona-tina teke aoagu-o idum.’ ");
INSERT INTO mva_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Makara nge malonga ngae kaba bong ruaia lang-lo bokai ibala, ‘Kana moarunga Nanaranga ambe iaka-goazadi nge tagona-tina iboadu dibolo kana gorangaki.’ ");
INSERT INTO mva_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Kana ngae nge bong toli ipurana, be alauri nge kaba lang-lo kautakingakadi dipura. ");
INSERT INTO mva_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Makara nge oaikiki-tina tamoata toli Sisaria anua-lo be nepiadi dipura be dabagaia kana nge makara pera ono usoaki-lo dipura. ");
INSERT INTO mva_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Be Oli Spirit bokai iraia, ‘Gotagadi. Moaki ilom irua.’ Be taritokada lima-teke Zopa anua-lo nge ditagaia be Kornilius pera kanana-lo kilako. ");
INSERT INTO mva_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Makara nge Kornilius bokai ipile ‘enzel’ teke pera kanana-lo ipura be bokai irai, ‘Tamoata teke gonepi be Zopa ngalako be Saimon ara takaia Pita ngabagai. ");
INSERT INTO mva_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pile ono baituka be kaiko dara nem moarunga zaiza uketa-ming dapura kana nge Pita ka ngaeluaki kana.’ ");
INSERT INTO mva_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Makara Kornilius pera kanana-lo ambe upilepile nge Oli Spirit odio ibala, kita-la matamata odao ibala bokana. ");
INSERT INTO mva_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Makara nge Tanepoa pilenga ngaedi ilogu iandi, ‘Zon dang oti ka ruku ono tamalinga ane iruku-kaming, ata kam masa Oli Spirit kulubobi ane mruku-kaming.’ ");
INSERT INTO mva_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bokaibe moimoi di Ungguma Takadi kaoa, ata Nanaranga ambe lumaluma suri tekena-doi di be kita iang-kita bong Tanepoa Iesus Kristus lama taunani nge. Bokai nge ngau naita kata be masa Nanaranga malipi ne zalakadi mono? Tagona-tina iboadu zalakadi mono!” ");
INSERT INTO mva_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pile ngaedi dilongo nge tago sesu kaba Pita diare-sabari, be ditaguraki be Nanaranga ara dirakeaki be bokai dipile, “E! Moimoi! Nanaranga ambe Ungguma Takadi idumadi be iboadu ilodi dabuiri be muzigoala nedi dasegeaki be moauriuri-la dasukoaki.” ");
INSERT INTO mva_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bong Stepan umoatea ipura nge tamoata be aine Kristus lama diunani nge dieramoaki-ramo be ege-ege dilako. Alu dialale be dilako Pinisia kaba-lo daga, alu Saiprus motu-nao daga be alu Antiok anua-lo daga. Be bokai dialalale nge Iesus rangaka Iuda-la tamoata be aine ka diraradi. ");
INSERT INTO mva_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ata aludi Saiprus motu-onaona be Sairini kaba-lonalona lama diuni nge dilako Antiok anua-lo be Ungguma Takadi Pile Uia maka Tanepoa Iesus rangaka nge mangata dirangakadi. ");
INSERT INTO mva_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tanepoa kaiboang ne nge tamoata ngaedi-o dieno. Bokaibe tamoata be aine kokoko-tina lama diuni, be ilodi dibuiri be Tanepoa ditalari. ");
INSERT INTO mva_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Be kana ngaedi rangakadi nge ‘sios’ Ierusalem-lo dilongoraki. Bokaibe Barnabas dinepi be Antiok ilako. ");
INSERT INTO mva_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Be bong Barnabas Antiok anua-lo ipura nge kaba bokai ita Nanaranga moimoi be marou bibia-tina tamoata be aine Antiok anua-lo iandi. Bokaibe suri diuia-tina, be bokai iaka-kaidi, “Ilo-ming ere-moarungadi ane be Tanepoa-la ka moimoi be kamatagatagai.” ");
INSERT INTO mva_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas nena-la nge tamoata iauia, be Oli Spirit nge ilona-lo isoaki be lama unianga nge dikai-tina. Bokaibe tamoata be aine kokoko-tina ilodi dibuiri be Tanepoa-la ditalari. ");
INSERT INTO mva_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kodeka makara be Barnabas itui Sol ngalelei kana be Tarsus ilako. ");
INSERT INTO mva_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Be bong ite nge ibagai be Antiok dilakoru. Be barasi teke makara tamoata be aine Antiok ‘sios’-lo zaiza diepurapurari. Bokai dimuzimuziru be ono tamoata kokoko-tina disuledi. Be nge makara ka Kristus tagataga ne moarunga matamatanatuka Kristen kana rangakadi dipura. ");
INSERT INTO mva_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Bong ngaradia-lo nge ‘propet’ alu Ierusalem-lo ka ditui be makara Antiok-lo dipura. ");
INSERT INTO mva_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Be teke nedi ara Agabus ituirake be Oli Spirit kaiboang nena-lo be bokai ipile, “Alauri masa tole kanabiabia teke ege-ege kateka-o ngapura.” (Kana ngae nge bong Klodius ungguma Rom ‘Sisa’ nedi bokana isoaki be ipura.) ");
INSERT INTO mva_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bokaibe Kristus tagataga ne moarunga nge diepilei be Kristen taritokadi Zudea kaba-lo dadumadi kana. Tamoata teke-teke nge rakana ki ‘mone’ ira-lo diboadu nge dipasi kodeka dikabung. ");
INSERT INTO mva_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bokai dimuzi be kana dikabung nge Sol be Barnabas diandiaru, be diaru dadokiru be dalaleru be tamoata nedi bibia Zudea ‘sios’-lo dimuamua nge dandi kana. ");
INSERT INTO mva_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Be nge bong ngaedia-lo ka anuatanepoa ara Erot itaguraki be ambe ‘sios’ tamoata ne alu sururu be moatubu bibia ianiandi. ");
INSERT INTO mva_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Be ipile be Zems, Zon taritoka nge asi ono eunga ane umoatea ipura. ");
INSERT INTO mva_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erot kaba bokai ita bong Zems iumoatei be Iuda suridi diuia nge ipile be Pita diuauri. Kana ngae nge bong ono moanako biabia ara ‘Bereti’ Bababa kania ipurapura-lo be iemaki. ");
INSERT INTO mva_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Erot Pita iuauri be uaura pera-lo inangai, kodeka ipile be tamoata kulemoa-be-lima-teke nge dinarinaringi. Bokainatuka dinarinaringi: oati oati dinarinaringi. Oati danaringi damanubu be kaba oati damai. Erot irere moanako biabia ara ‘Pasoba’ muri noko Pita ngadoki be lili-be-matao be giriki ne ngaliliti. ");
INSERT INTO mva_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bokaibe Pita nge uaura pera-lo isoaki, ata tamoata be aine ‘sios’-lo nge ngai kanabe kaikai-tina Nanaranga diraboraboi. ");
INSERT INTO mva_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ngazama nge Erot Pita ngadoki be lili-be-matao ngatuiraki be giriki ne lilitadi dapura kana. Be oabubu ngarana-lo nge Pita tamoata narinari rua mara-diaru ieno. Be narinari alu nge babaduadua-lo eluku dinari be disoaki. Pita nge kaleti oarige ‘seng’ ane diuauri be tamoata dinaringiaru nge mara-diaru ieno. ");
INSERT INTO mva_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Makara nge oaikiki-tina Tanepoa ‘enzel’ ne teke ipura be makara ituitui, be uaura pera ilo ono Pita isoaki nge imalama-tina. Kodeka ‘enzel’ ngae itaguraki be Pita bage-nao be irurukaki be imarang. Be bokai irai, “Oaikiki gotuirake!” Bokai ipile nge oaikiki-tina kaleti oarige ‘seng’ ono luma diuauri nge ditarube be disapasi. ");
INSERT INTO mva_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kodeka ‘enzel’ kababe Pita bokai irai, “Kusi nem gonanga uia be ae-sukuma nem gonanga.” Be Pita itaguraki be bokai imuzi. Pita nena-la iadorakia-doi nge ‘enzel’ kaba bokai ipile, “Kusi-sili nem biabia ono gosukumiko be gotagaia.” ");
INSERT INTO mva_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Be Pita itaguraki be ‘enzel’ itagai be uaura pera diperekiaru. Tago ikaua kana ngae ‘enzel’ iememakani nge moimoi be kalingo. Pita ilo ipile rai-o ka kaba itaita. ");
INSERT INTO mva_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Dilakoru be narinari tekedi dipereki-diaru, be dilakoru takadi dipereki-diaru be dilakoru babaduadua biabia ene anua zalaka bibia-lo ipusikalako-lo dilakoru. Babaduadua ngaena-lo dilakoru nge nena-la be itakaka be dipusikaru. Babaduadua ngae nge ‘aen’ oti ka diemaki be anua biabia Ierusalem zalakana-lo ka ipusikalako. Zala ngara disauaniaru be dilakoru nge ‘enzel’ Pita ipereki. ");
INSERT INTO mva_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Makara nge kodeka Pita ilo ikaua kana ngaedi nge moimoi be dipurani. Kodeka bokai ipile, “Kodeka ukaua kana ngae nge moimoi be kalingo! Tanepoa ka ‘enzel’ ne inepi be Erot kaiboang ne erumadi usoaki be iuketa. Iuketa be Iuda tamoata be aine bakara dabasaka kana be ilodi dipile nge tago iboadu ba dabasaka.” ");
INSERT INTO mva_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Bong Pita ilo izamani nge Zon Markus tina ara Maria kaba kana ilako. Tamoata be aine nge kokoko makara dikabuni be diraborabo. ");
INSERT INTO mva_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Makara ipura nge ilako be babaduadua elukuluku nge ipaliti. Be bong ipaliti nge aine malipilipi teke ara Roda imai be babaduadua ngauasari kana. ");
INSERT INTO mva_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ilako nge Pita malonga ikilalangi. Be bong Pita malonga ikilalangi nge suri nge diuia-tina ngena babaduadua tago iuasarani. Ipananalako pera ilona-lo be bokai ipile, “Pita eluku ituitui.” ");
INSERT INTO mva_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Roda bokai ipile nge tamoata be aine pera ilona-lo disoaki bokai dirai, “Masa kungao!” Ata Roda ikai-la be ieno moimoi Pita ka eluku ituitui bokana bokai dipile, “Masa ‘enzel’ ne.” ");
INSERT INTO mva_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pita nge isi babaduadua ipalipalitia-la. Be bong babaduadua diuasari be Pita dite nge dipitilaki-tina. ");
INSERT INTO mva_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ata Pita luma ane be isosodi. Kodeka itaguraki be baituka be Tanepoa idumai be uaura pera-lo be ipusika nge irangakidi. Irangaki-doi, kodeka bokai ipile, “Kana ngae nge Zems be taritokada moarunga kamarangakadi.” Kodeka kaba ngaradi ipereki be kaba takadia-lo ilako. ");
INSERT INTO mva_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Izama nge tamoata narinari nge diboang-ramo Pita masa ba iuai. ");
INSERT INTO mva_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bokaibe Erot ipile be Pita dileleia-tina uia, ata tago dite. Makara nge pile inanga be tamoata narinari nge dinaguridia-uia, be kodeka ipile be umoateadi dipura. Alauri nge Erot itui be Zudea kaba ipereki be ilako Sisaria-lo muku makara isoaki. ");
INSERT INTO mva_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erot nge norane be Taia be Saidon tamoata zaiza diegoregore. Bokaibe Taia be Saidon tamoata nge diekapotaki be dilako be Erot date kana. Dalako be date kana nge matamata bokai dimuzi: Tamoata maka Erot pera kanana-lo malipi moarunga-lo imuamua ara Blastus nge ilona-lo disili be ilo dibuiri be di muridi itui be ngadumadi kana. Kodeka ditui be dilako Erot-lo be dirai be anua-uia dadoki kana, bakara ungguma ngaedi nge kangkang kandi moarunga Erot kaba nena-lo ka didokidoki. ");
INSERT INTO mva_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Bong ono Erot date kana ipura nge Erot itaguraki be anuatanepoa ngazing ne inanga be bagi ne ono tanepoanga-o isoaki be tamoata be aine moarunga iraradi. ");
INSERT INTO mva_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Iradia-doi nge tamoata be aine kaikai-tina dimere be bokai dipile, “Nge tago tamoata kata ka malonga! Nge nanaranga kata malonga!” ");
INSERT INTO mva_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Makara nge oaikiki-tina Tanepoa ‘enzel’ ne teke itaguraki be Erot iuni be itapuloria, be moatamoata mukumukudi dikani be imate. Maka ma bong Erot tamoata be aine pilengadi bokai ilongo nge nena-la irakeaki, tago Nanaranga ara irakeaki! ");
INSERT INTO mva_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ata Nanaranga pilenga nge ege-ege dilakolako be rangakadi nge dilaba-la be dieno. ");
INSERT INTO mva_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Alauri Barnabas be Sol malipi nediaru Antiok ‘sios’ diandiaru dimambuakiru nge kaba Antiok-lo dimuleru. Malipi nediaru ngae nge bokai: Antiok ‘sios’-lo ‘mone’ dikabung be ono Zudea ‘sios’ didumai nge Ierusalem-lo dilakuakiru. Be bong dimulemuleru nge Zon ara takaia Markus nge dibagaiaru be dimule-buduto. ");
INSERT INTO mva_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Makara Antiok ‘sios’-lo nge ‘propet’ be tamoata maka tamoata be aine lama diuni disulesuledi nge alu disoaki. Aradi nge: Barnabas, Simion (Zimzim kana kilaia ipurapura), Sairini tamoata ara Lusius, Manian (tamoata ngae nge anuatanepoa ara Erot diaru dilaba-buduru), be Sol. ");
INSERT INTO mva_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Bong teke tamoata ngaedi Tanepoa dirakerakeaki be kangkang dizirau be disoaki nge Oli Spirit bokai iradi, “Barnabas be Sol kamazageakidiana, be malipi daemakiru kana be ukila-diaru nge daemakiru.” ");
INSERT INTO mva_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bokaibe bong kangkang zirau be rabo nedi dimambuaki nge luma-di Barnabas be Sol odiaruo dinangaria be dirabo-diaru be ono kaiboang diandiaru be dinepi-diaru be dialaleru. ");
INSERT INTO mva_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Makara be Oli Spirit Barnabas be Sol inepi-diaru be dituiru be dialaleru. Dialaleru be dilakoru Selusia anua-lo be kati rebareba tekenao dibuliru be Saiprus motu-nao dilakoru. ");
INSERT INTO mva_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saiprus motu-nao ditokaru nge dilakoru Salamis anua-lo be Iuda pera nedi ono serereinga-lo be Nanaranga pilenga mangata dirangakiru. Be Zon Markus nge dumaduma nediaru bokana be dialale-buduto. ");
INSERT INTO mva_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Makara be motu diboalingiato be dilakoto anua ara Papos-lo dipurato. Makara nge Iuda kata zerenga ratadi ara Ba-Iesus dipurakani. Tamoata ngae nge ‘propet’ bolingadi ratadi kata. ");
INSERT INTO mva_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ba-Iesus nge ungguma Rom biabiadi nedi ara Sergius Paulus malipilipi kana. Rom bibiadi nedi ngae nge kauanga bibia be Nanaranga pilenga ngalongo kana irere. Bokaibe Barnabas be Sol pile inanga-diaru be dapuraru kana. ");
INSERT INTO mva_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ata tamoata zerezere ara Elimas (ara Elimas Grik pile-lo nge zerezere) nge Barnabas be Sol idua-diaru be itaguraki be Rom biabiadi nedi ngae nge ilona-lo isili be lama uninga ngae ngamurinai kana. ");
INSERT INTO mva_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ata Oli Spirit nge Sol (ara takaia Pol) ilona-lo ikauri. Bokaibe Sol itaguraki be tamoata zerezere ngae adoado matana-lo idedealako ");
INSERT INTO mva_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","be bokai irai, “Kaiko nge Satang natu kata, be kana moarunga adoadodi erekei nedi! Boli mata be pile ono bolesa moarunga nge ilom-lo dikauri! Tanepoa pilenga moarunga moimoi be kalingodi nge kubagabubuiri be kalingodi tagotago kana kupilepile! ");
INSERT INTO mva_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Bokaibe Tanepoa luma masa omo dabala. Matam masa daleua, be uanana muku sasalaga masa amari malamaka tago sesu goita.” Sol bokai ipile nge oaikiki-tina oaru zimzim bokana Elimas mata diononi, be izabu be tamoata ileledi be zala daitikini kana. ");
INSERT INTO mva_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Rom bibiadi nedi kana ngae bokai ite nge lama iuni. Maka ma Tanepoa suletaka ilongolongo nge ikakabaki-tina. ");
INSERT INTO mva_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Makara Papos-lo be Pol ruanga zaiza kati rebareba tekenao dibuli be Perga anua ege Pampilia-lo dilako. Makara be Zon iperekidi be Ierusalem ilako. ");
INSERT INTO mva_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga anua-lo be kodeka Antiok anua ege Pisidia-lo dipura. Be bong ono manauanga ‘Sabat’-o nge pera nedi ono serereinga-lo dilako. ");
INSERT INTO mva_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Makara pera ono serereinga-lo nge Nanaranga ‘Buku’ ne Moses be ‘Propet’ digere nge dileze. Dileze-doi nge tamoata bibia pera ono serereinga-lo dimuamua nge ditaguraki be bokai diradi, “Tarito, pile neming ono tamoata be aine kamaka-kaidi kana tekedi dieno nge kamapile.” ");
INSERT INTO mva_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kodeka Pol ituirake be luma idokiteteki be bokai ipile, “Kamalongo-ra! Kam Israel tamoata be kam Ungguma Takadi Nanaranga karakerakeaki! ");
INSERT INTO mva_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel Nanaranga nedi ka itaguraki be tubuda ne bokana idokidi be inangadi, be bong Izip kaba-lo disoaki nge iemakidi be dikoko-tina be ungguma biabia teke dipura. Be alauri nge kaiboang ne bibia-tina ane be ibagadi be kaba ngaradi dipereki. ");
INSERT INTO mva_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Be barasi kulemoadi-oati nge lulu kaba-lo tukungkura dilakulakuaki, ata ngongongadi be muzingadi goalakingadi nge tago ilo iakataki. ");
INSERT INTO mva_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kodeka alauri nge ungguma lima-rua Kenan kaba-lo irokakidi be kateka nedi idoki be Israel nedi iandi. ");
INSERT INTO mva_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kana ngaedi nge ‘450’ barasi ilodia-lo iemaki. “Alauri nge Nanaranga itaguraki be tamoata bibia iandi be bagi nedi dipapananuakidi nibe ilako ‘propet’ ara Samuel-lo daga. ");
INSERT INTO mva_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ata alauri nge Israel ditaguraki be Nanaranga dirai be anuatanepoa teke ngandi kana. Bokaibe Nanaranga itaguraki be Sol anuatanepoa kandi bokana inangai. Sol nge Kis natu, be bagi ne ara Benzamin. Ngai barasi kulemoadi-oati Israel anuatanepoa kandi bokana isoaki. ");
INSERT INTO mva_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Alauri nge Nanaranga itaguraki be Sol irokaki be Debiti anuatanepoa kandi bokana inangai. Nanaranga Debiti bokainatuka mangata irangaki, ‘Zesi natu Debiti ute nge ngai aburogutina-lo ka isukoaki. Ngai ka masa kana moarunga rerengagu-lo ngaemaki.’ ");
INSERT INTO mva_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Be nge tamoata ngae labunao ka Uketiketi Iesus ipura, nena-la be moimoi be ipile bokana. ");
INSERT INTO mva_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Iesus isi tago ipura nge Zon Baptais itaguraki be Israel moarunga-lo bokainatuka mangata ipile, ‘Ilo-ming kamabuiri be muzigoala neming kamasegeaki be ruku ono tamalinga ane rukua-ming dapura.’ ");
INSERT INTO mva_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Be alauri Zon malipi ne ambe imamambuaki nge bokai ipile, ‘Ngau naita kana ilo-ming dipile? Ngau tago tamoata maka ngapura kana be karapurapungi! Tago. Ngai murigu ngatagaia kana. Ngau aragu tagotago-tina. Bokaibe tago uboadu ae-sukuma ne oarigedi mrube.’ ");
INSERT INTO mva_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tarito, kam Abaram tubu, be kam Ungguma Takadi Nanaranga kamatakutakuri! Nge kita kana ka pile ono uketinga ngaedi nangadi dipura. ");
INSERT INTO mva_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ierusalem tamoata be aine be tamoata nedi bibia nge kaba tago bokai dikauataki Iesus ka kateka ngae Uketiketi ne. Ata bong dipile be umoatea ipura nge ono pile moarunga ‘propet’ digere nge diemaki be dikalingo. Be pile-tina ma ngaedi ka ‘Sabat’ moarunga-o leze ipurapura. ");
INSERT INTO mva_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Moimoi labu iauia teke ono ngamate kana nge tago teke dite, ata Pailot dirai be umoatea ipura. ");
INSERT INTO mva_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Bakara basaka ngapura kana be gere ipura nge diemakini be dikalingo, kodeka kai-o ka dibalaki be gimoa-lo dinangalako. ");
INSERT INTO mva_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ata Nanaranga itaguraki be mate-lo be imarangaki. ");
INSERT INTO mva_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Be alauri nge bong kokoko-tina tamoata maka dialalale-budu Galili kaba-lo be dilakolako Ierusalem-lo nge dite. Be nge di ka kaituka mata-ita ne bokana be tamoata be aine neda diraradi. ");
INSERT INTO mva_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Be keka nge makare kipura be Pile Uia ngae kieluaka-kaming. Pile Uia ngae nge bokai: Pile moimoibe Nanaranga tubuda iandi ");
INSERT INTO mva_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nge tubudi kaitukatuka, kita, nge matada-o iemaki be dikalingo. Bokainatuka iemaki be dikalingo: Iesus mate-lo be imarangaki. ‘Buku’ ara ‘Sam’-lo nge ‘Sam’ ruaia bokai ipile, ‘Kaiko nge ngau natugu. Kaituka ambe Tamam upura.’ (Sam 2:7) ");
INSERT INTO mva_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Pile moimoibe kalingodi tekedi bokai dieno: Nanaranga masa mate-lo be ngamarangaki be tago iboadu ngamoapuru. Bokaibe pile ngaedi labudi nge pile ngaedia-lo dieno, ‘Ngau masa marou ratadi be kalingodi Debiti moimoi be rangakadiani ipura nge miangko.’ (Ais 55:3) ");
INSERT INTO mva_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Be Nanaranga ‘Buku’ ne egedi takadia-lo nge bokai dieno, ‘Tamoata nem Kusi Rata nge tago masa golikitaki be ngamoapuru.’ (Sam 16:10) ");
INSERT INTO mva_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Nanaranga nge Debiti tago ramoramo-ba ka inangai be anuatanepoa biabia ipura. Nge ono ne labu ne ngaemaki be ngakalingo kana ka inangai. Bokaibe bong Debiti Nanaranga labu ne ngae imambuaki nge imate. Imate be tubu be tama zaiza kumraka ipura be imoapuru. ");
INSERT INTO mva_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ata tamoata maka Nanaranga mate-lo be imarangaki nge tago iboadu ngamoapuru. ");
INSERT INTO mva_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Bokaibe taritokagu, ngau urere bokai kamakaua: nge Iesus-lo ka mata ono Nanaranga muzigoala neda irokaki nge mangata kirangaka-kaming be kalongo. ");
INSERT INTO mva_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iesus ara-nao ka tamoata moarunga maka lama diuni nge giriki nedi moarunga rokakadi dipura be Nanaranga mata-nao diado. Bakara, Moses Mata ne tago iboadu daemakiko be Nanaranga mata-nao goado! Tago-la. ");
INSERT INTO mva_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kaba kamaitaita uia. ‘Propet’ ambe dipile kana alu masa dapura. Be pilengadi ngaedi nge kam-lo dapura takana, ");
INSERT INTO mva_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Eke! Kam maka pilengagu kakanababadi, kaba kamaita uia! Ilo-ming kamalelelenaki-la be kamaleua-ramo kana! Bakara, bong neming-lo masa kana teke ilo-ming tago dipile tago iboadu memaki nge memaki. Moimoi tamoata teke masa ngara-kaming, ata tago iboadu lama kamauni.’” (Aba 1:5) ");
INSERT INTO mva_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol pile ngaedi ipile-doi be Barnabas diaru ambe pera ono serereinga dipereperekiaru nge tamoata be aine ditaguraki be bokai dira-diaru, “‘Sabat’ takaianao kaba makare kamapuraru be kana ngaedi kaba kamarangaki-kama.” ");
INSERT INTO mva_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Tamoata be aine moarunga pera ono serereinga ngarana-lo diepurapurari dialale nge Iuda kokoko be tamoata takadi Iuda mata nedi ditagatagadi nge Pol be Barnabas ditaga-diaru. Be diaru ditagurakiru be bokai diradi, “Nanaranga-la marou ne tadokidoki-ba ilodia-lo kamasukoaki.” ");
INSERT INTO mva_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Bong ono manauanga ‘Sabat’ takaianao nge tamoata be aine anua biabia ngarana-lo disukoaki nge moarungana-tina dikabuni be Tanepoa pilenga dalongo kana. ");
INSERT INTO mva_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Iuda kaba bokai dita nge dinama-ratakidi. Be pile goalakadi ane be dipile Pol pile ipilepile nge iboliboli. ");
INSERT INTO mva_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kodeka Pol be Barnabas ditagurakiru be kaikai-la bokai diradi, “Kam Iuda ka Nanaranga pilenga garangaki-kaming mua kana. Ata ambe Nanaranga pilenga kasegeaki. Bokaibe neminga-la mangata kananga-kaming kam kana iauia tago teke kaemaki be ono kamaboadu moauriurila nem-kusoaki soaki ipurapura nge kamadoki. Tago-la! Nge bokai ka Ungguma Takadi ambe kitalaridi. ");
INSERT INTO mva_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Maka ma Tanepoa bokai ira-kama, ‘Ngau ambe uemakiko be kaiko ambe Ungguma Takadi malama nedi. Bokai masa zala ono tamoata be aine moarunga uketadi be muleakadi dapura kana nge ege-ege kateka-o golakuaki.’” (Ais 49:6) ");
INSERT INTO mva_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ungguma Takadi bokai dilongo nge suridi diuia-tina, be Tanepoa pilenga dirakeaki. Be tamoata be aine kokoko-tina maka moauriuri-la nem-kusoaki soaki ipurapura dadoki kana be Nanaranga inangadi nge lama diuni. ");
INSERT INTO mva_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Makara be Tanepoa pilenga nge ege-ege kaba ngaradia-lo dilako. ");
INSERT INTO mva_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ata Iuda ditaguraki be aine aradi otioti anua ngarana-lo Nanaranga dimatakutakuri be tamoata bibia aradi otioti nge ilodia-lo disili be ono Pol be Barnabas moatubu diandiaru. Be ditao-diaru be anua ngara diperekiaru. ");
INSERT INTO mva_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Bokaibe ono anua-marau diduadi bokana nge Pol be Barnabas ditagurakiru be ae-diaru babadi anua ngaenao ditatairiaru. Kodeka anua ara Aikoniam-lo dilako-ru. ");
INSERT INTO mva_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Be tagataga moarunga nge Oli Spirit ilodia-lo ikauri, be suridi nge diuia-tina. ");
INSERT INTO mva_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Aikoniam anua-lo nge Pol be Barnabas bong moarunga dimuzimuziru bokana dimuziru be dilakoru Iuda pera nedi ono serereinga-lo. Makara nge pile kakai-tina ane be tamoata be aine ilodi diung. Bokaibe Iuda kokoko-tina be Ungguma Takadi kokoko-tina nge lama diuni. ");
INSERT INTO mva_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ata Iuda alu tago Kristus lama diunani. Bokaibe ditaguraki be Ungguma Takadi ilodia-lo disili be ono diemakidi be tamoata be aine lama diuni nge ilodi diratakidi. ");
INSERT INTO mva_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ata Tanepoa kaiboang ne nge Pol be Barnabas-lo dieno. Be nge bokai ka makara uanana sasalaga disoakiru be tago taburi-ralo be kaikai-la be Tanepoa pilenga mangata dirarangakiru. Makara nge Tanepoa itaguraki be ne marou ne tadokidoki-ba muridi itui be ono ne pilenga mangata itikingdi pilenga nge moimoi. Be ono itikingdi pilenga moimoi nge Pol be Barnabas kaiboang iandiaru be kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki nge diememakiru. ");
INSERT INTO mva_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Makara nge tamoata be aine anua ngarana-lo nge dienegei. Alu Iuda lama tago diuni-o didai be alu ‘apostel’-o didai. ");
INSERT INTO mva_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bokaibe Ungguma Takadi be Iuda nge mumua nedi zaiza ditaguraki be Pol be Barnabas dirabataki-diaru be patu ane daumoate-diaru kana. ");
INSERT INTO mva_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ata diaru dilongoru be diratu be Listra be Derbi anua, ege Laikonian kaba-lo dilakoru. ");
INSERT INTO mva_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Makara nge Pile Uia mangata dirangakiaru. ");
INSERT INTO mva_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Makara Listra anua-lo nge tamoata teke ae-babadi matedi isoaki. Ae-babadi nge matedi be tina inekiaki be tago ialalale. ");
INSERT INTO mva_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tamoata ngae bokai isoaki be Pol ipilepile nge ilongolongori. Makara nge Pol adoado-la tamoata ngae idedei be kilalanga inanga tamoata ae-babadi matedi nge lama iunia-tina be iboadu aka-uiaka ngapura. ");
INSERT INTO mva_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kodeka Pol itaguraki be bokai ikilau, “Gotuirake!” Pol bokai ipile nge tamoata ngae ituirake be ialalale. ");
INSERT INTO mva_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tamoata be aine makara disoaki Pol kana iemaki dite nge pile nedi Laikonian pile-lo bokai dimere, “Ambe nanaranga tamoata bokana be marada dibala.” ");
INSERT INTO mva_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Makara nge nanaranga nedi nge aradi Pol be Barnabas dibuleakidi. Barnabas Zius dibuleakini, be Pol Emis dibuleakini, bakara Pol ka pilepile nedi. ");
INSERT INTO mva_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Makara nge tamoata Zius tabataba ianiani nge ‘bulumakau’ moane be moare ieluaki be anua aoa ono silinga-lo inanga. Maka ma Zius keda ne nge eluku ka ieno. Bokai ka tabataba ieluaki be tamoata be aine makara disoaki zaiza be databangaki be ono Pol be Barnabas darakeaki-diaru kana. ");
INSERT INTO mva_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ata bong ‘apostel’ ruoti Pol be Barnabas bokai dilongoru nge kusi dinanganangaru didokisareru be dipananaru dilakoru tamoata be aine maradi be bokai dimereru, ");
INSERT INTO mva_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bakara ka bokai kamuzimuzi? Keka nge kakaming-la ka bokana, tamoata-ramo kaoa! Keka Pile Uia ka kieluaka-kaming be bokai kirara-kaming, ‘Kana kalingodi tagotago bokainaina kamamurinadi be Nanaranga kalingo moauriuri isukoaki nge kamatalari.’ Ngai ka lang be kateka be makasi be kana moarunga ilodia-lo dieno nge iemaki. ");
INSERT INTO mva_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Toira nge ungguma moarunga ilikitakidi be rerengadia-lo disukoaki. ");
INSERT INTO mva_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ata nge ambe nena-la be bokainatuka mangata inangai: Kana uia-la ka iememaki-kaming. Ura ianiang-kaming be lang-lo be ibalabala, be ono kangkang kana-ming uma-lo nge bong-tina nedi-o be ipupuraki. Kangkang kokoko-tina ianiang-kaming, be iloming-lo nge suri-uia bibia-tina inangananga.” ");
INSERT INTO mva_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pol be Barnabas pile-ra bokaina-ma diradia-re, ata tago ma! Tamoata be aine ngaedi nge ambe saringatuka ‘bulumakau’ databangaki be ono darakeaki-diaru kana. ");
INSERT INTO mva_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ata Iuda alu Antiok be Aikoniam anua-lo ka dipura be tamoata be aine makara nge ilodi diung be ono kaba ditaguraki be Pol be Barnabas didua-diaru. Kodeka Pol patu oti diuni be direpeki be eluku dilakuaki. Ilodi dipile imate. ");
INSERT INTO mva_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ata tagataga dipura be Pol diboalingi be kaba imarang be anua-lo isili. Izama nge Barnabas diaru Derbi anua-lo dilakoru. ");
INSERT INTO mva_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kodeka makara Derbi anua-lo Pile Uia mangata dirangakiaru, be tamoata be aine kokoko-tina ilodi dibuiri be tagataga dipura. Alauri nge dituiru be Listra anua-lo dilakoru, kodeka dilakoru Aikoniam anua-lo, be alauri nge dialaleru be Antiok anua, ege Pisidia kaba-lo dipuraru. ");
INSERT INTO mva_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Makara anua ngaradia-lo nge tagataga diaka-kaidi be didumadi be ono lama uniangadi nge kakai-la daeno kana. Be bokai diradi, “Nanaranga anua ne ono itanepoa kanana-lo talako kana nge moatubu bibia-tina tadoki noko talako!” ");
INSERT INTO mva_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Alauri nge tamoata malaidi alu ‘sios’ teke-teke-lo damuamua kana nge dinangadi. Kodeka kangkang dizirau be dirabo be ono tamoata bibia dinangadi nge Tanepoa luma-nao dinangadi. Bakara, Tanepoa-lo ka ilodi moarunga dinangalako be bokai dibasakidi. ");
INSERT INTO mva_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kodeka Antiok-lo be dituiru be Pisidia kaba dialaleakiru be Pampilia kaba-lo dipuraru. ");
INSERT INTO mva_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pampilia kaba-lo dipuraru nge dilakoru Perga anua-lo Pile Uia mangata dirangakiaru, kodeka dilakoru Atalia anua-lo. ");
INSERT INTO mva_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Atalia anua-lo be kati rebareba tekenao dibuliru be Antiok anua, ege Siria kaba-lo dimulelakoru. Nge Antiok anua ngaena-lo ka norane be makara dipuraru be tamoata be aine lama diuni nge ditaguraki be Nanaranga luma-nao dinanga-diaru be ono malipi ambe kaituka-tina dimambuaki-ru ngaedi nge daemakiru kana. ");
INSERT INTO mva_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Anua ngarana-lo dipuraru nge ditagurakiru be tamoata be aine moarunga ‘sios’ ngarana-lo nge dikeliakidi be kabu teke dipura, kodeka kana moarunga Nanaranga diarua-lo iemaki nge dirangakiru. Be baituka be Nanaranga ambe zala iuasari be ono Ungguma Takadi lama diuni nge dirangakiru. ");
INSERT INTO mva_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Kodeka makara uanana sasalaga-tina tagataga zaiza disoaki-budu. ");
INSERT INTO mva_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kodeka tamoata alu Zudea kaba-lo ka dimai Antiok anua-lo be taritoka-da bokai disulesuledi, “Tago iboadu Nanaranga ngauketi-kaming be ngamuleaki-kamingba. Moses Mata ne kamatagadi be kusi-ming korototokadi dapura masa Nanaranga ngauketi-kaming be ngamuleaki-kaming. Tago be tago!” ");
INSERT INTO mva_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ata Pol be Barnabas nge sule ngaedi tago direretakiru. Bokaibe tamoata ngaedi zaiza egore kanabiabia teke diemaki. Makara be tamoata be aine Enitok ‘sios’-lo ditaguraki be Pol be Barnabas dinanga-diaru be Ierusalem dinepidialakoru be Iesus ‘apostel’ ne be tamoata ‘sios’-lo dimuamua zaiza sule ngae daegoretaki kana. Kodeka tamoata alu ‘sios’-lo nge dinangadi be Pol be Barnabas zaiza dalale-budu kana. ");
INSERT INTO mva_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kodeka dinepidi be dialale. Dialale nge Pinisia kaba be Samaria kaba dialaleaki, be bakara be Ungguma Takadi Nanaranga moimoi be kalingona-lo dilako nge dirangaki. Bokaibe taritokada moarunga makara nge suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bong Pol be Barnabas be tamoata dialale-budu Ierusalem-lo dipura nge ‘sios’ Ierusalem-lo be ‘apostel’ be tamoata ‘sios’-lo dimuamua nge disuri-uiatakidi be dimolatakidi. Be kodeka kana moarunga maka bong dimalipilipi be Nanaranga iemaki nge dirangaki. ");
INSERT INTO mva_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kodeka tamoata alu Kristus lama diunani Parasi kaoa nge dituirake be bokai dipile, “Ungguma Takadi kusidi korototokadi dapura be radi dapura be Moses Mata ne datagatagadi.” ");
INSERT INTO mva_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Makara nge ‘apostel’ be tamoata ‘sios’-lo dimuamua nge dikabuni be moatubu ngae daegoretaki kana. ");
INSERT INTO mva_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Diegoresalaga-tina, kodeka Pita ituirake be bokai ipile, “Taritokagu, kam kakaua norane be rakana ipura. Mara-ming ka Nanaranga inangaia be ualale be Pile Uia mangata mrangaki be ono Ungguma Takadi iboadu dalongo be lama dauni. ");
INSERT INTO mva_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nanaranga maka tamoata moarunga ilodi ikauataki nge itaguraki be Ungguma Takadi nge idokidi. Bokainatuka be itiking-kita moimoi be idokidi: Oli Spirit idoki be iandi, kita-la iang-kita bokana. ");
INSERT INTO mva_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nanaranga mata-nao nge di tago takadia-ba be kita takada-ba. Tago. Bokaibe bong lama diuni nge Nanaranga ilodi iaka-goazadi be ilodia-lo giriki tago teke ieno. ");
INSERT INTO mva_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ak, nge bakara ka Nanaranga katoi be ambe taritokada Ungguma Takadi dududia-lo moatubu bibia kananganangalako? Moatubu bibia ngaedi nge kita be tamada be tubuda tagona-tina tabazidi ka di dududia-lo kananganangalako! ");
INSERT INTO mva_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tagona-tina iboadu bokai kamamuzi! Maka ma kita lama bokai tauni: Tanepoa neda Iesus marou ne tadokidoki-ba itagai ka Nanaranga iuketi-kita be imuleaki-kita, dia-la ibasakidi bokana.” ");
INSERT INTO mva_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kodeka Pol be Barnabas dituiru be kilala kaiboangdi be kilala Nanaranga-la iboadu ngaemaki diarua-lo be Ungguma Takadi iemakidi nge dirangakiru. Dipilepileru nge moarunga makara disoaki nge dimoadubulae-ba be dilongolongo. ");
INSERT INTO mva_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pol be Barnabas dipile-doiru, kodeka Zems bokai ipile, “Taritokagu, kamalongora! ");
INSERT INTO mva_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon ambe mangata ira-kita be talongo Nanaranga ambe mangata itiking-kita ngai moimoi be Ungguma Takadi ilo ibukubukutakidi. Nanaranga bokainatuka be mangata itiking-kita ngai moimoi be Ungguma Takadi ilo ibukubukutakidi: maradi ka tamoata be aine ne idokidi. ");
INSERT INTO mva_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Bokai imuzi be ono ‘propet’ pilengadi ngaedi iemaki be dikalingo, ");
INSERT INTO mva_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kana ngaedi muridi masa kaba mumule be Debiti pera ne itamong be ieno nge mnaguraki. Pera igalalai be ieno masa mnaguraki be masa kaba ne bokana ngapura. ");
INSERT INTO mva_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Bokai masa tamoata moarunga Tanepoa dalelei, be Ungguma Takadi araguo be negu bokana ukiladi masa daleleia. ");
INSERT INTO mva_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tanepoa ka bokai ipile, bakara ngai ka toira be kana ngae mangata inangai, be toira be imai nge kauataka ipura.’ (Amos 9:11-12) ");
INSERT INTO mva_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Bokaibe ngau ilogu bokai unangai: Ungguma Takadi ambe Nanaranga-lo dilakolako nge moaki sesu ba tabasakidi be ono zalakadi taono. ");
INSERT INTO mva_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Moaki-tina. Tageredi be bokai taradi: Kangkang moarupu ara-dio be emakadi dipura be ambe disangala nge moaki dikangkang, pogiza-ramo mata moaki ditagatagadi, ngado tapadi dipura nge moaki dikangkang, be ngado moarunga darakadi nge moaki dikangkang. ");
INSERT INTO mva_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bakara, Moses Mata ne nge toira-tina be ege-ege anua moarunga-lo mangata rangaka ipurapura, be bong ono manauanga ‘Sabat’ moarunga-lo nge leze ipurapura.” ");
INSERT INTO mva_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kodeka ‘apostel’ be tamoata bibia ‘sios’-lo dimuamua nge ditaguraki be tamoata nedi alu dinangadi be Pol be Barnabas dataga-diaru be Antiok anua-lo dalako-budu kana. Makara be Iudas (ara takaia Basabas) be Sailas dinanga-diaru. Diaru nge ‘sios’-lo muaka bibia-tina odiaruo ieno. ");
INSERT INTO mva_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Dalale kana nge ‘pasi’ bokai digereti be diandi, “Keka tarito-kaming ‘apostel’ be tamoata bibia ‘sios’-lo kimuamua ka kigere. “Be nge kam Ungguma Takadi Kristus lama kaunani Antiok anua-lo, Siria kaba-lo be Silisia kaba-lo kasoaki ka kigere-kaming. Suri-uia kinanga-kaming. ");
INSERT INTO mva_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Keka ambe bokai kilongo tamoata nema alu kam-lo dimai be pile alu dira-kaming be ono ilo-buku diang-kaming be ilo-ming disururu. Keka tago kisumoaladi be makara kam-lo dimai. ");
INSERT INTO mva_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Bokai ka iloma kitekenanadi be tamoata nema alu kinangadi be ruangama uarikadi Barnabas be Pol zaiza kam-lo ganepidiamai kana. ");
INSERT INTO mva_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Tamoata ngae-diaru nge Tanepoa neda Iesus Kristus ara-nao be malipi ne diememakiru, be malipi-ba ngaedi lilidi-o be saringatuka damateru kana. ");
INSERT INTO mva_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Be nge bokai ka Iudas be Sailas dinepi-diaru be nediaru aoa-diarualo be pile ngaedi kigere nge daka-kaidi kana. ");
INSERT INTO mva_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Iloma bokai kinanga: Nge tago iuia Oli Spirit mata-nao be keka matamaio ilo-buku bibia tago kaboadu kamabazidi nge gang-kaming. Ata nge iuia mata ngaedi kamatagatagadi: ");
INSERT INTO mva_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kangkang ambe moarupu tabangakadiadi dipura moaki kangkang, dara moaki kangkang, ngado ambe tapadi dipura moaki kangkang, be pogiza-ramo mata nge moaki katagatagadi. Mata ngaedi nge kamasibongaki-tina. Pile nema suridi. Rabuaki nema kiang-kaming.” ");
INSERT INTO mva_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Makara be tamoata ngaedi dinepidi be dilako Antiok anua-lo. Antiok anua-lo dipura nge tamoata be aine moarunga ‘sios’ ngarana-lo nge dikeliakidi be dipura-doi kabu teke, kodeka ‘pasi’ ngae diandi. ");
INSERT INTO mva_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tamoata be aine makara pile ono aka-kainga ngaedi dileze nge suridi diuia-tina. ");
INSERT INTO mva_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Be Iudas be Sailas ditagurakiru be pile ono aka-kainga diradi, be ono dikaiboang uia. Maka ma diaru nge ‘propet’ kaoa. ");
INSERT INTO mva_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Be kodeka makara muku disoaki. Be alauri nge taritokada Antiok-lo nge kababe dinepidi Ierusalem dilako, be tamoata dinepidia-lo dimule. Damule kana nge marou ono ilo-uianga ane dimaroudi be dinepidi be dialale.  ");
INSERT INTO mva_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ata Sailas ilo itekenanai be makarana-la Antiok-lo isoaki. ");
INSERT INTO mva_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol be Barnabas nge Antiok anua-lanalo disoakiru. Bokaibe tamoata alu zaiza be Tanepoa pilenga disulesuletaki be mangata dirarangaki. ");
INSERT INTO mva_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Muku alauri nge Pol itaguraki be Barnabas bokai irai, “Tamuleru be talakoru anua moarunga Tanepoa pilenga mangata tarangakiru kanana-lo be taritokada tatedi be takauatakidi ambe baituka disukoaki.” ");
INSERT INTO mva_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bokaibe Barnabas irere Zon, ara takaia Markus nge dalale-budu, ");
INSERT INTO mva_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ata Pol ipile nge tago iuia dabagaiaru, maka ma Markus nge Pampilia an