﻿USE sofia;
DROP TABLE IF EXISTS sofia.muy_vpl;
CREATE TABLE muy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES muy_vpl WRITE;
INSERT INTO muy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yezu *Krist ti naŋ wur huɗ ge Devit, wur huɗ ga Abraham daya. Slimi ga ata bəŋ ga bəŋani ti nday hi : ");
INSERT INTO muy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham èwi Izak, Izak èwi Zekʉp, Zekʉp èwi Zʉda akaba bəza ga məŋani ndahaŋ, ");
INSERT INTO muy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zʉda èwifiŋa ata Ferez nday ata Zara kà Tamar a, Ferez èwi Esroŋ, Esroŋ èwi Aram, ");
INSERT INTO muy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram èwi Aminadap, Aminadap èwi Nasoŋ, Nasoŋ èwi Salmoŋ, ");
INSERT INTO muy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoŋ èwifiŋa Boz kà Rahap a, Boz èwifiŋa Zobet kà Rut a, Zobet èwi Zese, ");
INSERT INTO muy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zese èwi Devit. Devit ti àzum bay. Bay Devit èwifiŋa Salomoŋ kà wal ge Yʉri a, ");
INSERT INTO muy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoŋ èwi Robowam, Robowam èwi Abiya, Abiya èwi Asaf, ");
INSERT INTO muy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf èwi Zusafat, Zusafat èwi Zuram, Zuram èwi Oziyas, ");
INSERT INTO muy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Oziyas èwi Zowatam, Zowatam èwi Asaz, Asaz èwi Ezesiyas, ");
INSERT INTO muy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezesiyas èwi Manase, Manase èwi Amoŋ, Amoŋ èwi Zuziyas, ");
INSERT INTO muy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zuziyas èwi Zesʉniyas akaba bəza ga məŋani. Ka sarta gani nani ti tə̀həloru ndam *Zʉde ka haɗ Babiloŋ. ");
INSERT INTO muy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tàra tə̀həloya ndam Zʉde ka haɗ Babiloŋ a ti Zesʉniyas èwi Salatiyel, Salatiyel èwi Zorobabel, ");
INSERT INTO muy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel èwi Abiyut, Abiyut èwi Eliyakim, Eliyakim èwi Azor, ");
INSERT INTO muy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor èwi Sadok, Sadok èwi Akim, Akim èwi Eliyʉt, ");
INSERT INTO muy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyʉt èwi Eleyazar, Eleyazar èwi Mataŋ, Mataŋ èwi Zekʉp, ");
INSERT INTO muy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zekʉp èwi Zʉzef. Zʉzef ti zal ga Mari ya èwi Yezu ni. Yezu ti təzalay naŋ Krist. ");
INSERT INTO muy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nahkay e kiɗiŋ ga sarta ga Abraham akaba sarta ge Devit bu ni ti bəza huɗ bəza huɗ ga Abraham kru mahar faɗ ; e kiɗiŋ ga sarta ge Devit akaba sarta ya ti tə̀həloru ndam Zʉde ka haɗ Babiloŋ ni bu ni ti bəza huɗ bəza huɗ ga Abraham kru mahar faɗ ; e kiɗiŋ ga sarta ya ti tə̀həloru ndam Zʉde ka haɗ Babiloŋ ni akaba sarta ge Krist bu ni ti bəza huɗ bəza huɗ ga Abraham kru mahar faɗ. ");
INSERT INTO muy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tìwi Yezu *Krist ti àgravu nahkay hi : məŋani Mari məva ge Zʉzef. Zʉzef àzay naŋ faŋ ndo, ay tìpi ti naŋ a huɗ. Naŋ a huɗ ti àna njəɗa ga *Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zal gani Zʉzef ti naŋ mis jireni, nahkay àra èpia naŋ a, naŋ a huɗ ti àwayay maɗafani do. Àɗəm ambrəŋ naŋ akal-akal. ");
INSERT INTO muy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Naŋ àbu ajalay ahàr nahkay ti *məslər ge Melefit àŋgazlivu e kisim miziɗeni bu, àhi ahkado : « Zʉzef wur huɗ ge Devit, kàgray aŋgwaz ga mazay Mari ga wal ba, aɗaba wur ya a huɗ gayaŋ bu ni ti àzay huɗ gani àna njəɗa ga Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ara ewi wur zalani. Emiweya ti akədi slimi Yezu, aɗaba naŋ ti amahəŋgay ndam gayaŋ, aməhəlaba tay a magudar zlam gatay ba. » ");
INSERT INTO muy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Zlam gani nani àgravu ɗek ti, ti pakama ga Bay Melefit ya àhi ana bay mahəŋgaray *pakama gayaŋ ni mâgravu. Pakama gani nani ti nihi : ");
INSERT INTO muy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","« Wur dahalay ya àsər zal faŋ ndo ni ara azay huɗ, emiwi wur zalani, atəzalay naŋ Emenʉwel. » Emenʉwel ti awayay aɗəmvaba « Melefit naŋ àbu akaba leli. » ");
INSERT INTO muy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zʉzef nakəŋ àra èpiɗekva ti àgray ere ye ti məslər ga Bay Melefit àhi gray ni. Àzay Mari nakəŋ ga wal, ");
INSERT INTO muy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ay tàndəhaɗkabu ndo, duk àbivoru ana sarta ya Mari èweya wur na ni. Nahkay Mari nakəŋ èwi wur zalani, mək Zʉzef àdi slimi gani Yezu. ");
INSERT INTO muy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tìwi Yezu ti e Betlehem ka haɗ *Zʉde. Ka sarta gani nani ti Erot naŋ bay ga ndam *Zʉde. Tàra tìwia Yezu a ti ndam ndahaŋ tàra a Zerʉzalem a ; nday ndam məsər zlam, tàsləkabiya gwar egezi a. ");
INSERT INTO muy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tàra tìnjia ti tìhindi, tə̀ɗəm : « Bay ga ndam Zʉde ya tìwi ni ti naŋ eley ? Màra ti aɗaba boŋgur àcəlaya, aɗafaki tìweya bay gəɗakana. Mìpia boŋgur na ti màra ga mabəhaɗi mirdim a. » ");
INSERT INTO muy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bay *Erot àra ècia ma gana ti ma gani àhəlia ahàr a dal-dal ; ma gani àhəlia ahàr ana ndam Zerʉzalem a ɗek daya. ");
INSERT INTO muy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eslini Erot nakəŋ àzalakabu gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam Zʉde ya *tə̀səra Wakita ge Melefit a ni. Àzalakabu gəɗákani ga ndam Zʉde ni nahkay ti ge mihindifiŋa kà tay a : « *Krist Bay gəɗakani ya amara ni ti, etiwi naŋ ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Naŋ nakəŋ àra àhia ana tay a nahkay ti nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Etiwi naŋ ti e Betlehem ka haɗ Zʉde, aɗaba bay mahəŋgaray *pakama ge Melefit nahaŋ àbəki a wakita gayaŋ bu nahkay hi : ");
INSERT INTO muy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Bay Melefit àɗəm : Lekʉlʉm ndam Betlehem ka haɗ Zʉde ni ti kəsa gekʉli gəɗakani àtam kəsa ndahaŋ ga haɗ Zʉde ni, aɗaba etiwi bay a kəsa gekʉli bu. Bay gani nani ti amədi kama ana ndam goro ndam *Izireyel.” » ");
INSERT INTO muy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bay Erot àra ècia ma na nahkay ti àzalakabu ndam məsər zlam ni akal-akal, èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Boŋgur ni ti àcəlaya ananaw ? » ");
INSERT INTO muy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tàra tə̀hia sarta gana ti àsləroru tay e Betlehem, àhi ana tay : « Dəgum, kəɗəbum məlaŋ ga wur ya tìwi ni lala. Akəsəruma məlaŋ gana ti, ŋguma ti kə̂həŋgrumu ma gani. Aɗaba nu day nara nakoru ga mabəhaɗi mirdim. » ");
INSERT INTO muy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nday nakəŋ tàra tìcia ma ga bay na ti tàsləka. Nday tə̀bu takoru e divi bu ni ti tìpi boŋgur ya àcəlaya gwar egezi a ni, naŋ àbu akoru kama gatay. Boŋgur ni naŋ àbu akoru nahkay ti òru ècikki ka məlaŋ ga wur ya naŋ àvu ni. ");
INSERT INTO muy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tàra tìpia boŋgur na ti tə̀mərva dal-dal, ");
INSERT INTO muy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","tə̀huriyu a ahay ya ti boŋgur ècikki ni vu, tə̀di ahàr ana wur ni nday ata məŋani Mari. Tàra tìpia wur na ti tàbəhaɗi mirdim grik meleher ndiɓa ndiɓa ana haɗ, mək tə̀zləkaba sahar gatay a, tə̀həlaya zlam a, tə̀bi ana wur ni. Zlam gani nday hi : gru, haf ya tamal tazəbay ezi ti àɓəlay ni, akaba haf nahaŋ təzalay mir, ezi akaɗa ge tersel ni. ");
INSERT INTO muy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kələŋ gani Melefit àhi ma ana tay e kisim miziɗeni bu, àhi ana tay ahkado : « Kə̀ŋgumoru gwar afa ga Erot ba. » Nahkay nday nakəŋ tàsləka, tàŋgoru a magam gatay àna divi nahaŋ zlam gatay. ");
INSERT INTO muy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ndam məsər zlam ni tàra tàsləka ti *məslər ge Melefit àŋgazlivu ana Zʉzef e kisim miziɗeni bu, àhi ahkado : « Sləka, za wur na nday ata məŋana, cuhworu àna tay gwar ka haɗ Ezip. Ekinjʉmiya ti njəhaɗuma eslina. Anəhuk “Sləka” day kwa ti akəsləkumbiya. Aɗaba *Erot naŋ àbu aɗəbay divi ge mijiŋ wur ni. » ");
INSERT INTO muy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Zʉzef àra ècia ma na nahkay nahəma, ga məlavaɗ gani nani ècikaba, àzay wur ni nday ata məŋ ga wur ni, òru ka haɗ Ezip. ");
INSERT INTO muy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tòru tìnjʉa eslina ti tànjəhaɗiyu duk àbiviyu ana kisim ga bay Erot. Ata bəŋ ga Yezu tòru àna Yezu ka haɗ Ezip ti, ti pakama ga bay mahəŋgaray *pakama ga Bay Melefit mâgravu. Pakama ya àɗəm ni ti nahkay hi : « Nə̀zalabiyu wur goro ti kwa ka haɗ Ezip.  » ");
INSERT INTO muy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erot àra ècia ndam məsər zlam ni tàgosa naŋ a ti àzuma ɓəruv a dal-dal. Nahkay àsləroru mis, àhi ana tay tôru tâbazl bəza ga kəsa Betlehem akaba bəza ge mis ya tanjəhaɗ kà gəvay gani ni. Àhi ana tay tâbazl bəza ya ti tə̀zuma vi a cʉ cʉena akaba ya tìsli vi cʉ cʉeni ndo ni ɗek. Àɗəm tâbazl bəza ge vi cʉ cʉeni ni ti aɗaba ndam məsər zlam ni tə̀hi « Mìpi boŋgur enjenjeni ti àgray vi cʉ nihi. » ");
INSERT INTO muy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nahkay pakama ge Zeremi bay mahəŋgaray *pakama ge Melefit ni àgravu. Pakama gani nahkay hi : ");
INSERT INTO muy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","« Tìci zlahay a Rama : tuway ahənday dal-dal, tagray delʉlʉ. Nani Resel, etʉwi bəza gayaŋ, àwayay ti mis tədabakay naŋ do, aɗaba bəza gayaŋ tə̀bi va bi.  » ");
INSERT INTO muy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kələŋ gani bay *Erot nakəŋ àməta. Àra àməta ti məslər ga Bay Melefit àŋgazlivu ana Zʉzef ka haɗ Ezip e kisim miziɗeni bu keti, ");
INSERT INTO muy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","àhi ahkado : « Cikaba, za wur na nday ata məŋana, kəŋgoru àna tay ka haɗ Izireyel. Aɗaba ndam ya ti tàwayay makaɗ wur ni ti tə̀məta. » ");
INSERT INTO muy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Zʉzef nakəŋ àra ècia ma na ti ècik, àzay wur ni nday ata məŋ ga wur ni, tàsləka tàŋgoru ka haɗ Izireyel. ");
INSERT INTO muy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ay Erseleyʉs wur ga Erot àhuriya a bay ga bəŋana va ka haɗ *Zʉde a. Zʉzef nakəŋ àra ècia ma gana ti aŋgwaz awər naŋ, àwayay məhuriyani ka haɗ Zʉde do. Eslini *məslər ge Melefit àhi ma e kisim miziɗeni bu, nahkay Zʉzef nakəŋ òru ka haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Òru ènjʉa eslina ti ànjəhaɗ a kəsa nahaŋ bu ; təzalay kəsa gani Nazaret. Nahkay ere ye ti ndam mahəŋgaray *pakama ge Melefit ya tə̀ɗəmbiyu ni àgrava. Ma gani nahkay hi : « *Bay gəɗakani ya amara ni ti atəzalay naŋ zal Nazaret. » ");
INSERT INTO muy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A vaɗ nahaŋ àbu nahəma, Zeŋ bay məbaray mis ni àhərkiaya ke mis a huɗ gili ba ka haɗ *Zʉde ga məhi ma ana mis. ");
INSERT INTO muy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Àhi ana mis ahkado : « Mbatumkaba majalay ahàr gekʉli a, aɗaba *Məgur ge Melefit ènjia wuɗak.  » ");
INSERT INTO muy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zeŋ ti Izayi bay mahəŋgaray *pakama ge Melefit àɗəmkibiya ma, àɗəm : « Maslaŋa azlah a huɗ gili bu, dəŋgu gayaŋ ahəndabiyu. Àɗəm : “Slamatumikabu divi ana Bay gəɗakani, ahàr àɗəm divi gayaŋ mâla ndəlaɓa.”  » ");
INSERT INTO muy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zeŋ ti naŋ àbu àna azana mələmani àna eŋgʉc ge ezligwemi, awəlvù àna maslpara ga ambəl a zuh bu. Zlam məzum gayaŋ ti eyew akaba amu. ");
INSERT INTO muy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Eslini ti ndam Zerʉzalem, ndam ga haɗ Zʉde ɗek akaba ndam ya ti tanjəhaɗ kà gəvay ga zalaka *Zʉrdeŋ ni ɗek tə̀rəkia ke Zeŋ nakəŋ a, ");
INSERT INTO muy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","tə̀ɗafaya zlam gatay ya tàgudar na, mək Zeŋ nakəŋ àbaray tay a zalaka Zʉrdeŋ ni bu hʉya. ");
INSERT INTO muy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ndam *Feriziyeŋ akaba ndam *Sedʉseyeŋ kay tə̀rəkia ke Zeŋ a ti mə̂baray tay. Zeŋ nakəŋ àra èpia tay a ti àhi ana tay ahkado : « Lekʉlʉm ti medékw ! Way àhi ana kʉli dəguma afa goro a ti kâtamumfəŋa kà məzum ɓəruv ge Melefit ya ara azumki ke mis wuɗak na way ? ");
INSERT INTO muy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tamal ti kàmbatumkaba majalay ahàr gekʉli a eɗeɗiŋ eɗeɗiŋena ti, grum tʉwi ya ti aɗafaki lekʉlʉm kàmbatumva ni. ");
INSERT INTO muy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ŋgay bəŋ ga bəŋ gekʉli Abraham, nahkay akatamum ti kə̀humi ana ahàr ba, aɗaba nəhi ana kʉli nahəma, Melefit esliki məhiani ana akur nday ndani tîgi bəza huɗ ga Abraham day, agravu. ");
INSERT INTO muy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Si kəgrum tʉwi sulumani kwa. Do ni ti Melefit naŋ ànjəkia ka matraɓ kʉli a àndava, agri ana kʉli akaɗa ge mis ya məŋ ga zlam gayaŋ tìwi bəza sulumani do ni ti azay zlaba gayaŋ ekeleba tay a, abiyu tay a aku vu ni. ");
INSERT INTO muy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nu ti nabaray kʉli àna yam ti mis tə̂sər lekʉlʉm kàmbatumkaba majalay ahàr gekʉli a, ay maslaŋa nahaŋ naŋ àbu ara e divi ba kələŋ goro a : naŋ ti aməbaray kʉli àna *Məsuf Njəlatani akaba àna aku. Naŋ gani nani ti njəɗa gayaŋ àtama goro a ; nu ti way ga məziaba kimaka gayaŋ a di way ? ");
INSERT INTO muy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Emedekaba mis a akaɗa ge mis ya àza hijiɗ gayaŋ a ahar va, ahar hay àna naŋ ni. Àharaba ti abiyu yam ga hay ni a guvur vu. Ay kisfit gani ni ti ajiaba aku a. Aku gani nani ti àmət ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Eslini Yezu àsləka ka haɗ *Gelili a, àrəkioru ke Zeŋ kà gəvay ga zalaka *Zʉrdeŋ ti Zeŋ *mə̂baray naŋ. ");
INSERT INTO muy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ay ti Zeŋ àwayay məbaray naŋ do, àhi ahkado : « Amal nu nərəkukoru ti kâbaray nu. Nihi ti nak kə̀rəkua ti nâbaray kur sawaŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ay Yezu àhəŋgrifəŋ, àhi : « Nihi ti gəskabá, gray nahkay hayaŋ. Tamal màgra nahkay ti màgra ere ye ti Melefit awayay na ɗek. Àgəski ti magray nahkay. » Zeŋ àra ècia ma ga Yezu na ti àgəskabu, àbaray naŋ. ");
INSERT INTO muy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Zeŋ àra àbara Yezu a ti Yezu àcəlaya a yam ni ba. Eslini huɗ melefit àzləkvaba, mək Yezu nakəŋ èpi *Məsuf ge Melefit àhərkiaya akaɗa ga kurkoduk ya ahər na. ");
INSERT INTO muy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eslini dəŋgu àhəndabiyu a huɗ melefit bu akaɗa dəŋgu ge mis, àɗəm : « Maslaŋa hini ti wur goro, nawayay naŋ dal-dal ; aməru məɓəruv dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kələŋ gani *Məsuf ge Melefit àzoru Yezu a huɗ gili vu ti *Seteni mə̂həlfəŋa eyʉ a. ");
INSERT INTO muy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eslini Yezu nakəŋ àgəs ndəra, àzum zlam ndo vaɗ kru kru faɗ məlafat akaba məlavaɗ gani do ɗek. Kələŋ gani lʉwir àwərkaba naŋ a. ");
INSERT INTO muy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nahkay bay məhəlfəŋa eyʉ kè mis a ni àrəkioru, àhi ; « Tamal ti nak Wur ge Melefit eɗeɗiŋ ti hi ana akur nday hini tə̂mbukvu *dipeŋ zla aw. » ");
INSERT INTO muy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ay Yezu àhəŋgrifəŋ, àhi : « Àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm : “Mis anjəhaɗ ti àna zlam məzumani ciliŋ do ; anjəhaɗ ti àna pakama ya Melefit àɗəm ni ɗek.”  » ");
INSERT INTO muy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Eslini Seteni àzoru naŋ a kəsa *njəlatani ni vu, àfəkaɗ naŋ jik ka ahàr ga *ahay gəɗakani ge Melefit ni, ");
INSERT INTO muy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","mək àhi : « Tamal nak Wur ge Melefit eɗeɗiŋ ti diyu a haɗ, aɗaba àbu məbəkiani a Wakita ge Melefit ni bu nahkay hi : “Melefit aməhi ma ana məslər gayaŋ, atakəcaw kur, ti asak gayak ènjifiŋ kà akur ba.”  » ");
INSERT INTO muy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ay Yezu àhi : « Àbu məbəkiani a Wakita ge Melefit ni bu keti : “Kə̀həlfəŋa eyʉ kà Bay Melefit gayak a ba.”  » ");
INSERT INTO muy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Eslini Seteni nakəŋ àzoru Yezu ka ahàr ga həma zəbalani, àɗəfiki haɗ ga duniya gərgərani ɗek, àɗəfiki njəɗa akaba elimeni gatay, ");
INSERT INTO muy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","mək àhi : « Kə̀bu kipioru zlam ni ɗek do waw ? Tamal ti kàbəhaɗua mirdim a meleher ndiɓ ana haɗ ti anəbuk tay ɗek. » ");
INSERT INTO muy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eslini Yezu àhi : « Həɗakfua, Seteni. Àbu məbəkiani a Wakita ge Melefit ni bu nahkay hi : “Akabəhaɗi mirdim ti ana Bay Melefit gayak ; akazləbay naŋ naŋ bəlaŋ ciliŋ.”  » ");
INSERT INTO muy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yezu àra àɗəma ma na nahkay ti Seteni nakəŋ àsləkafəŋa. Àra àsləkafəŋa ti *məslər ge Melefit tə̀rəkia ka Yezu a, tə̀fi ahàr. ");
INSERT INTO muy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kələŋ gani mis tə̀hi ana Yezu tə̀fiya Zeŋ a daŋgay va. Yezu àra ècia ma gana ti àsləka òru ka haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Òru ènjʉa eslina ti ànjəhaɗ a Nazaret ndo, òru ànjəhaɗ a Kafarnahum. Kafarnahum ti kà gəvay ga *dəluv gəɗakani ga haɗ Gelili, ka haɗ ga Zabuloŋ akaba ga Naftali. ");
INSERT INTO muy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Àgray nahkay ti pakama ge Izayi bay mahəŋgaray *pakama ge Melefit ya àɗəmbiyu ni ti mâgravu. Àɗəm nahkay hi : ");
INSERT INTO muy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","« Lekʉlʉm ndam ga haɗ ga Zabuloŋ akaba ga Naftali, gwar ka dəluv, ke ledi ga zalaka *Zʉrdeŋ ni ! Ka haɗ Gelili gekʉli ti ndam ya nday ndam *Zʉde do ni tə̀bu kay, ");
INSERT INTO muy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ay mis ya ti tanjəhaɗ a məlaŋ ziŋ-ziŋeni bu ni tìpia məlaŋ maslaɗana dal-dal ; mis ya ti tanjəhaɗ akaɗa nday mis məmətani ni, məlaŋ àslaɗia ana tay a. » ");
INSERT INTO muy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka sarta gani nani Yezu ànjəki ka məhi ma ana mis, àɗəm : « Mbatumkaba majalay ahàr gekʉli a, aɗaba *Məgur ge Melefit ènjia. » ");
INSERT INTO muy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A vaɗ nahaŋ Yezu naŋ àbu asawaɗay kà gəvay ga dəluv Gelili ti èpi mis ndahaŋ cʉ nday kà məŋ gatay. Bəlaŋ gani slimi gayaŋ Simu naŋ ya təzalay Piyer ni, nahaŋ ni ti ni slimi gayaŋ Andre. Nday tə̀bu tətəliyu zəva gatay a dəluv vu, aɗaba nday ndam məgəs kilif. ");
INSERT INTO muy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eslini Yezu àhi ana tay : « Ɗəbumbiyu nu ; anagray ti kîgʉm ndam məhəlibiyu mis ana Melefit akaɗa ya ti kəgəsum kilif ni. » ");
INSERT INTO muy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tàra tìcia pakama ga Yezu na ti tə̀mbərbu zəva gatay ni ndəɓak, tàɗəbay naŋ hʉya. ");
INSERT INTO muy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nday tə̀bu takoru ti Yezu èpi mis ndahaŋ cʉ, nday kà məŋ gatay keti ; nday bəza ge Zebede, bəlaŋ gani slimi gayaŋ Zek, nahaŋ ni ti ni slimi gayaŋ Zeŋ. Nday a *slalah ga yam bu akaba bəŋ gatay Zebede, tə̀bu təslamalay zəva gatay. Yezu àra èpia tay a ti àzalay tay. ");
INSERT INTO muy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nday nakəŋ tàra tìcia zalay ga Yezu na ti tə̀mbərbu slalah ga yam gatay ni akaba bəŋ gatay ni, tàɗəbay naŋ. ");
INSERT INTO muy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kələŋ gani Yezu àsawaɗay ka kəsa ka kəsa ga haɗ *Gelili ni ɗek, àcahi zlam ana mis a ahay ga *mahəŋgalavù Melefit ye eslini ni bu. Àhi *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit ana tay, àhəŋgaraba ndam gatay dərani akaba ndam gatay ya arməwər gərgərani awər tay na ɗek. ");
INSERT INTO muy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nahkay ndam ga haɗ Siri ɗek tìcia zlam ga Yezu ya àgray na. Eslini tə̀həlibiyu ndam gatay ya tèɓesey do ni ɗek : ndam ga arməwər, ndam ya ti təcakay daliya ni, ndam ya ti seteni tə̀niviyu ana tay ni, ndam ya ti araŋa agəs tay ɓəruk ɓəruk ni, akaba ndam dəra. Tə̀həlibiya tay ana Yezu a ti Yezu àhəŋgaraba tay a. ");
INSERT INTO muy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mis dal-dal tàsləkabiya e Gelili a, ka haɗ ga *Kəsa Kru a, a Zerʉzalem a, ka haɗ *Zʉde akaba ke ledi ga zalaka *Zʉrdeŋ a, tàɗəbay Yezu. ");
INSERT INTO muy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yezu àra èpia mis dal-dalani na ti àcəloru a həma vu, ànjəhaɗ digʉs. Nahkay ndam maɗəbay naŋ ni tə̀rəkioru, ");
INSERT INTO muy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mək Yezu ànjəki ka macahi zlam ana tay. Àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","« Ndam ya ti tə̀səra nday ndam talaga kè eri ge Melefit ni ti tə̂mərvu, aɗaba *Məgur ge Melefit ti gatay. ");
INSERT INTO muy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ndam ya ti titʉwi ni ti tə̂mərvu, aɗaba Melefit aməhəŋgrivu ɓəruv ana tay. ");
INSERT INTO muy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ndam ya ti nday kuɗufani ni ti tə̂mərvu, aɗaba Melefit aməvi haɗ ya ti àɗəm aməvi ana ndam gayaŋ ni ana tay. ");
INSERT INTO muy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ndam ya ti tawayay jiri ge Melefit akaɗa ya tawayay zlam məzumani akaba zlam miseni ni ti tə̂mərvu, aɗaba etipi jiri gani nani, atərəh àna naŋ akaɗa ya tərəh àna zlam məzumani ni. ");
INSERT INTO muy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ndam ya ti mis təsi cicihi ana tay ni ti tə̂mərvu, aɗaba nday day atəsi cicihi ana Melefit. ");
INSERT INTO muy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ndam ya ti məɓəruv gatay *njəlatani ni ti tə̂mərvu, aɗaba etipi Melefit. ");
INSERT INTO muy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ndam ya ti taŋgalabakabu mis ni ti tə̂mərvu, aɗaba Melefit amazalay tay bəza gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ndam ya ti mis təgri daliya ana tay aɗaba nday ndam jireni ni ti tə̂mərvu, aɗaba Məgur ge Melefit ti gatay. ");
INSERT INTO muy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","« Lekʉlʉm ti ka ya ti mis tindivi kʉli, təgri daliya ana kʉli ahkay do ni təɗəmki ma magədavani gərgəri àki ke kʉli aɗaba lekʉlʉm ndam goro ni ti, mərumvu. ");
INSERT INTO muy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yʉm, mərumvu dal-dal, aɗaba Melefit aməvi zlam sulumani ana kʉli kay a kəla gani vu a huɗ melefit bu. Daliya ya təgri ana kʉli nihi ni ti, ku ndam mahəŋgaray *pakama ge Melefit ahaslani day tə̀gri ana tay nahkay. » ");
INSERT INTO muy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","« Lekʉlʉm e kiɗiŋ ga ndam ga *duniya ni bu ni ti akaɗa estena ya tabafəŋ kà zlam məzumani ni. Ay tamal estena ni àcər va do ni ti, təgri ahəmamam ti mə̂cər keti ni mam ? Àbi ! Ègia zlam masakana, tizligoru mis təcəlki ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","« Aslaɗay məlaŋ a duniya bu ni ti lekʉlʉm gani. Kəsa gəɗakani ka ahàr ga həma ti aŋgahvu waw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Maslaŋa ya ti ebeftey ceŋgel mək ahəmbaki dagəla ni ti àbi ; afəkaɗ ka məlaŋ zaŋani sawaŋ, nahkay ti aslaɗi məlaŋ ana mis ya ti a huɗ ahay bu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nahkay zla nahəma grum ti mis ɗek tîpi maslaɗani gekʉli àna tʉwi gekʉli sulumani ya kəgrum ni. Etipia ti atazləbay Bəŋ gekʉli ya a huɗ melefit bu ni. » ");
INSERT INTO muy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","« Ŋgay nu nàra ga məmbatkaba *Divi ge Melefit ya Mʉwiz àbəki na akaba pakama ga ndam ndahaŋ ya tàhəŋgaray *pakama ge Melefit na ti kə̀ɗəmum ba. Nàra ga məmbatkaba tay a do, nàra ti ge mendeveriŋ tʉwi gani sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nəhi ana kʉli nahəma, ku asak ma gʉzit ge Divi ge Melefit ya Mʉwiz àbəki ni emiji do. Tamal huɗ melefit akaba haɗ ni ɗek tìjiji ndo ni ti asak ma ga wakita ni day emiji do. Si ere ye ti Melefit awayay magray ni ɗek amagrava day kwa. ");
INSERT INTO muy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nahkay zla nahəma, tamal mis àgəskabu ku Divi bəlaŋ e kiɗiŋ ge Divi ge Melefit bu ndo, akaba acahi ana mis ndahaŋ ti tâgray akaɗa gayaŋ ni ti, àɓəlay do. Ku tamal àgəskabá Divi ndahaŋ a ɗek, Divi ya àgəskabu ndo ni ti gʉziteni àtam nday ndahaŋ ɗek nəŋgu ni, Melefit aməɗəm maslaŋa nani gʉziteni àtam mis ndahaŋ ɗek a Məgur gayaŋ ni bu. Ay maslaŋa ya ti àgəskabá Divi ge Melefit a ɗek, acahi ana mis ndahaŋ ni ti, Melefit aməɗəm naŋ gəɗakani a Məgur gayaŋ ni bu. ");
INSERT INTO muy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nəhi ana kʉli nahəma, ahàr àɗəm kâtamum ndam *Feriziyeŋ akaba ndam *məsər Wakita ge Melefit àna jiri. Tamal kàtamum tay ndo ni ti akəhurumiyu a *Məgur ge Melefit ni vu koksah. » ");
INSERT INTO muy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","« Kə̀səruma tə̀hi ana ata bəŋ gekʉli ahkado : “Kə̀kaɗ mis ba. Maslaŋa ya ti àkaɗa mis a ni ti tagrafəŋa seriya.” ");
INSERT INTO muy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ay nu ti nəhi ana kʉli : ku way way do tamal àzumkia ɓəruv ka wur ga məŋana ti tagrafəŋa seriya ; ku way way do tamal èndivia wur ga məŋana cʉɗ ti ndam ge seriya təwəl naŋ ; tamal àhi ana wur ga məŋani “Nak muru” ti tizligiyu naŋ a *dəluv ga aku vu. ");
INSERT INTO muy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nahkay tamal kìnjʉa àna sədaga gayak ka məlaŋ ya tabəhaɗ na, mək kə̀sərkia kàgudaria zlam ana wur ga muk a ti, ");
INSERT INTO muy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","mbərbu sədaga gayak ni eslini, ru kâŋgalumbabiya. Akəŋgalumbabiya ti ŋga ti kâfəkaɗi sədaga gayak ni ana Melefit ɗəma mba. ");
INSERT INTO muy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","« Tamal maslaŋa akoru abəhaɗkuk mirdim nahəma, ŋgalumbu ka ahàr divi ; do ni ti bi maslaŋa nani aməzikaboru kur ana bay magray seriya, mək bay ni aməvi kur ana zal slewja ga məfiyu kur a daŋgay vu. ");
INSERT INTO muy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nəhuk nahəma, mənjəɗ məpəlaba ere ye ti tə̀fəkuk na ɗek ti akahəraya a daŋgay ni ba do. Ku tamal ti agəjənifuk sisi bəlaŋ nəŋgu ni, si kəpəlaba kwa. » ");
INSERT INTO muy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","« Kə̀səruma tə̀hi ana ata bəŋ gekʉli ahkado : “Kàgray hala ba.” ");
INSERT INTO muy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ay nu ti nəhi ana kʉli : ku way way do tamal àmənjaləŋa ana wal a àna eri ciliŋ, awayay ti tândəhaɗkabu ti, àgra hala àndava. ");
INSERT INTO muy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","« Nahkay tamal eri ga ahar ga ɗaf gayak ezligiyu kur a magudar zlam vu nahəma, zaba zligoru ; àgəski hojo zlam ga vu gayak bəlaŋ ejiji ere gani tizligiyu vu gayak ɗek a dəluv ga aku vu ni. ");
INSERT INTO muy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tamal ahar ga ɗaf gayak ezligiyu kur a magudar zlam vu nahəma, kelkaba zligoru ; àgəski hojo zlam ga vu gayak bəlaŋ ejiji ere gani vu gayak ɗek ahuriyu a dəluv ga aku vu ni. » ");
INSERT INTO muy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","« Tə̀hi ana ata bəŋ gekʉli : “Tamal maslaŋa agaray wal gayaŋ ti ahàr àɗəm abəki wakita gani, avi.” ");
INSERT INTO muy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ay nu ti nəhi ana kʉli : ku way way do àgara wal gayaŋ a, wal ni day àgray mesʉwehvu ndo ni ti, wal ni àda zal nahaŋ a ti maslaŋa ya àgara wal na ti àfiyu wal ni a magray hala vu. Nahkay maslaŋa ya ti àza wal ya ti zal gani àgara na day àgra hala. » ");
INSERT INTO muy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","« Kə̀səruma tə̀hi ana ata bəŋ gekʉli ahkado : “Tamal kàmbaɗa, kə̀ɗəm akəgri zlam ana Melefit ti ahàr àɗəm kə̀mbrəŋ ba, gray ere gani nani.” ");
INSERT INTO muy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ay nu ti nəhi ana kʉli : kàmbaɗum ɗay-ɗay ba. Ku àna huɗ melefit kàmbaɗum ba, aɗaba huɗ melefit ti kʉrsi ga Bay Melefit. ");
INSERT INTO muy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ku àna haɗ ɗay kàmbaɗum ba, aɗaba haɗ ti məlaŋ məbəki asak ge Melefit. Ku àna Zerʉzalem day kàmbaɗum ba, aɗaba nani kəsa ga Bay gəɗakani. ");
INSERT INTO muy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ku àna ahàr gayak day kàmbaɗa ba, aɗaba ku məhər ga ahàr gayak bəlaŋ day kàmbatkaba ti mîgi bəɗ-bəɗani ahkay do ni didiliŋeni koksah. ");
INSERT INTO muy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ere ye ti kəɗəmum ni ti “Iy !” ahkay do ni “Aha !” Tamal kə̀ɗəmumkiva ma nahaŋ a ti nani tʉwi ge *Seteni. » ");
INSERT INTO muy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","« Kə̀səruma, tə̀hi ana ata bəŋ gekʉli : “Tamal maslaŋa àzukaba eri a ti ziaba eri a bilegeni. Tamal maslaŋa àdəvukaba aslər a ti dəviaba aslər a bilegeni.” ");
INSERT INTO muy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ay nu ti nəhi ana kʉli : tamal mis cuɗayani àgruka araŋa ti kàhəŋgarfəŋ ba. Tamal maslaŋa àduka barva ka tuwər ga ahar ga ɗaf a nahəma, mbatikabiyu ga ahar ga gəjar ni ti mə̂dukkivu keti. ");
INSERT INTO muy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tamal mis àbəhaɗkuka mirdim a, awayay azafuka endʉwi gayak a nahəma, mbrəŋ naŋ mâzafuka, mâzafuka mugudi gayak a daya. ");
INSERT INTO muy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tamal mis àfəkuka ŋgasa ga məzioru zlam ezeweɗ kru nahəma, zioru ezeweɗ kru kru cʉ. ");
INSERT INTO muy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tamal mis èhindilʉka zlam a ti vi. Tamal mis àra ga makəlay duwa ti kèkeli ba. » ");
INSERT INTO muy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","« Kə̀səruma tə̀hi ana ata bəŋ gekʉli : “Ahàr àɗəm wayay ndam ya ti nak kə̀bu akaba tay ni, zirey ndam ezir gayak.” ");
INSERT INTO muy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ay nu ti nəhi ana kʉli : wayum ndam ezir gekʉli ; həŋgalumi Melefit ana ndam ya təgri daliya ana kʉli ni. ");
INSERT INTO muy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tamal kəgrum nahkay ti ekigʉm bəza ga Bəŋ gekʉli ya e melefit bu ni eɗeɗiŋ eɗeɗiŋeni, aɗaba naŋ ti agray ti fat mâslaɗi məlaŋ ana ndam cuɗay akaba ana ndam sulumani, agray ti avər mə̂təɗiaya ana ndam jireni akaba ana ndam jireni do na daya. ");
INSERT INTO muy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tamal lekʉlʉm kawayum ndam ya ti tawayay kʉli ni ciliŋ ti, kə̀humi ana ahàr Melefit aməvi zlam ana kʉli ka duwa gani aw ? Aha ! Aɗaba ku ndam *məhəl hadam day tə̀bu tagray nahkay. ");
INSERT INTO muy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tamal kəgrumi sa ana bəza ga məŋ gekʉli ciliŋ ti, kə̀humi ana ahàr kəgrum zlam sulumani aw ? Aha ! Ku nday ya ti tə̀fəki ahàr ke Melefit do ni day tə̀bu tagray nahkay. ");
INSERT INTO muy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ahàr àɗəm kàgudarum zlam do simiteni, akaɗa ga Bəŋ gekʉli ya e melefit bu àgudar zlam do simiteni ni. » ");
INSERT INTO muy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yezu àhi ana tay keti : « Ka ya ti kəgrum zlam sulumani ni ti, kə̀grum kè meleher ge mis ndahaŋ ti tîpi ere ye ti kəgrum ni ba. Tamal kəgrum kè meleher ge mis ti, Bəŋ gekʉli ya e melefit bu ni aməvi zlam ana kʉli azuhva tʉwi gekʉli ni do. ");
INSERT INTO muy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Nahkay zla nahəma, ka ya ti kəvumi zlam ana ndam talaga ni ti, kàzlahum àna naŋ ti mis tîci ba. Ndam ya ti tawayay ti mis tə̂ɗəm nday ndam jireni ni tə̀bu tagray nahkay a ahay ga *mahəŋgalavù Melefit bu akaba a kəsa bu. Tagray nahkay ti aɗaba tawayay ti mis tâzləbay tay. Nəhi ana kʉli nahəma, nday ti tə̀ŋgəta zlam ka duwa gana àndava, atəŋgət nahaŋ va do. ");
INSERT INTO muy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ay nak ti ka ya ti kəvi zlam ana zal talaga nahəma, gray ti ku ahar ga gəjar gayak day àsər ere ye ti ahar ga ɗaf gayak agray ni ba. ");
INSERT INTO muy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ahàr àɗəm kəvi zlam ana mis ti maslaŋa nahaŋ èci ma gani ba. Buk ti epi zlam ya mis tìpi do ni, nahkay aməvuk zlam sulumani azuhva tʉwi gayak ya kàgray ni. » ");
INSERT INTO muy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","« Ka ya ti kahəŋgalum Melefit nahəma, kə̀grum akaɗa ga ndam ya tawayay ti mis ndahaŋ tə̂ɗəm nday ndam jireni ni ba. Nday ti tahəŋgalay Melefit tawayay micikeni jik a ahay ga *mahəŋgalavù Melefit bu ahkay do ni kà gəvay ge divi, ti mis tîpi tay. Nəhi ana kʉli nahəma, nday ti tə̀ŋgəta zlam ka duwa gana àndava, atəŋgət nahaŋ va do. ");
INSERT INTO muy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ay nak ti ka ya ti kahəŋgalay Melefit nahəma, huriyu a ahay gayak vu, zləkkabu mahay ti mis tìpi kur ka ya ti kahəŋgalay Melefit ni ba. Buk ti epi zlam ya mis tìpi do ni, nahkay aməvuk zlam sulumani azuhva tʉwi gayak ya kàgray ni. ");
INSERT INTO muy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ka ya ti kahəŋgalum Melefit ni ti kə̀həŋgrumi zuh ana zlam bəlaŋani sak kay akaɗa nday ya ti tə̀fəki ahàr ke Melefit do tagray ni ba. Nday ti tə̀hi ana ahàr tamal tahəŋgalay dal-dal ti Melefit aməgri ere ye ti tawayay ni ana tay. ");
INSERT INTO muy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ay lekʉlʉm ti kə̀grum akaɗa gatay ni ba. Aɗaba wuɗaka kahəŋgalum ti Bəŋ gekʉli àsəra ere ye ti àhəcikivu ana kʉli na àndava. ");
INSERT INTO muy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ka ya ti kahəŋgalum Melefit nahəma, ɗəmum nahkay hi : “Bəŋ geli nak a huɗ melefit bu, mis ɗek tə̂gəskabu nak njəlata ti ; ");
INSERT INTO muy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","kâra kə̂zum bay gayak e kiɗiŋ geli bu ti ; ere ye ti kawayay ni mâgravu ka haɗ akaɗa ya agravu a huɗ melefit bu ni ti. ");
INSERT INTO muy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Zlam məzumani ga məgəsi sifa ana leli ni ti vi ana leli kani daya ti. ");
INSERT INTO muy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mbərfəŋa zlam ya màgudaruk ni kè leli a, akaɗa geli ya mə̀mbərfəŋa zlam ge mis ya tàgudari ana leli na kà tay a ni ti. ");
INSERT INTO muy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kə̀vi divi ana *Seteni ge mesipet leli ba, həŋgafəŋa leli kà naŋ a sawaŋ ti. Aɗaba Bay ya ti agur zlam ɗek akaba esliki ka magray zlam ɗek ni ti nak. Bay ya ti mis ɗek atazləbay ni ti nak, ga kaŋgay-kaŋgayani. Aya nahkay.” ");
INSERT INTO muy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","« Nə̀ɗəm nahəma, tamal kəmbrəŋumfəŋa zlam ge mis ya tagudari ana kʉli na kà tay a ti, Bəŋ gekʉli ya e melefit bu ni aməmbərfəŋa zlam gekʉli ya kagudarum ni kè kʉli a bilegeni. ");
INSERT INTO muy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ay tamal lekʉlʉm kə̀mbrəŋumfəŋa zlam ya mis tagudari ana kʉli ni kà tay a do ni ti, Bəŋ gekʉli day aməmbərfəŋa zlam gekʉli ya kagudarum ni kè kʉli a do bilegeni. » ");
INSERT INTO muy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","« Ka ya ti kəgəsum ndəra nahəma, kə̀grum akaɗa ge mis ya tawayay ti mis ndahaŋ tə̂ɗəm nday ndam jireni ni ba. Nday ti ka ya ti təgəs ndəra ni ti tamənjavu akaɗa tə̀bu təcakay daliya, akaɗa tàmətaɓkaba ; tawayay ti mis tə̂sər nday tə̀bu təgəs ndəra. Nəhi ana kʉli nahəma, nday ti tə̀ŋgəta zlam ka duwa gana àndava, atəŋgət nahaŋ va do. ");
INSERT INTO muy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ay nak ti ka ya ti kəgəs ndəra nahəma, baray eri gayak, bakabu tersel ka ahàr. ");
INSERT INTO muy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nahkay ti ŋgay kə̀gəsa ndəra ti mis tə̀sər do, si Buk ya ti naŋ àbu akaba kur ni. Nahkay Buk aməvuk zlam sulumani azuhva tʉwi gayak ya kàgray ni ; naŋ ti epi zlam ya mis tìpi do ni. » ");
INSERT INTO muy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","« Kə̀ŋgumkabu elimeni a duniya bu ba. A duniya bu ni ti gaŋgu akaba vi təzumaba, ndam akal day tindef ahay təhəlaba elimeni na. ");
INSERT INTO muy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ŋgumkabu elimeni gekʉli ti a huɗ melefit bu sawaŋ, aɗaba eslini ti gaŋgu akaba vi tə̀zum do, ndam akal day tìndef ahay koksah, tə̀həl elimeni ni koksah. ");
INSERT INTO muy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Aɗaba məlaŋ ya ti elimeni gayak àvu ni ti, kajalaki ahàr ti ka məlaŋ gani nani. » ");
INSERT INTO muy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","« Eri ge mis ti aslaɗay vu gayaŋ akaɗa ge ceŋgel ya aslaɗay məlaŋ ni. Tamal eri gayak lala nahəma, vu gayak ɗek àbu a maslaɗani bu. ");
INSERT INTO muy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ay tamal eri gayak lala do ni ti, vu gayak ɗek emigi e ziŋ-ziŋeni bu. Nahkay tamal ti maslaɗani gayak ni àslaɗay va do ègia ziŋ-ziŋena ti, nak e ziŋ-ziŋeni bu dal-dal timey ! » ");
INSERT INTO muy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","« Maslaŋa àbi esliki məgri tʉwi ana bay ahay cʉ bi. Emizirey bəlaŋ gani, amawayay naŋ nahaŋ ni ; ahkay do ni aməgəsiki ma ana nahaŋ ni do, ana naŋ nahaŋ ni ti ni aməgəsiki ma. Lekʉlʉm day tamal kəɗəbum siŋgu hi hi ti kìslʉmki məgri tʉwi ana Melefit koksah. » ");
INSERT INTO muy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","« Nahkay zla nahəma, nəhi ana kʉli a manjəhaɗ gekʉli bu ni ti ŋgay akəzumum mam, ekisʉm mam akaba akəbumkabu mam ti kàjalum ba, àhəli ahàr ana kʉli ba daya. Sifa ti àtam zlam məzumani do waw ? Vu ti àtam zlam məbakabani do waw ? ");
INSERT INTO muy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kipʉm eɗiɗiŋ do waw ; tìzligi zlam do, tàbaz zlam do, tàŋgakabu zlam a guvur bu do. Ay ti Bəŋ gekʉli ya e melefit bu ni naŋ àbi avi zlam məzumani ana tay bi aw ? Lekʉlʉm ti kàtamum tay ferek-ferek do waw ? ");
INSERT INTO muy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Way e kiɗiŋ gekʉli bu esliki mədəkiviyu vaɗ àkivu ke vi gayaŋ ku gʉzit àna majalay ahàr gayaŋ way ? Àbi ! ");
INSERT INTO muy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","« Kajalumki ahàr ka zlam məbakabani ti kamam ? Ŋga pʉm vay-vay ga zlam ya təfət a vədaŋ bu ni ; tàgray tʉwi do, tə̀ləmkabu azana do daya. ");
INSERT INTO muy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ay nəhi ana kʉli nahəma, ku Salomoŋ àna elimeni gayaŋ ni ɗek tekeɗi àbakabu azana ya ti àɓəlay akaɗa vay-vay bəlaŋ ni ndo. ");
INSERT INTO muy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Zlam ya təfət a vədaŋ bu kani, hajəŋ təbiyu tay a aku vu ni tekeɗi Melefit abəki vay-vay ka tay. Tamal naŋ àbu agray nahkay ti aməbəki zlam ke kʉli amatam gatay ni do waw ? Lekʉlʉm ti kə̀fumki ahàr ke Melefit lala do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nahkay ti ŋgay aməzumum mam, emisʉm mam akaba aməbumkabu mam ti kàjalum ba. ");
INSERT INTO muy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ndam ya taɗəbay zlam nday nani ɗek kəlavaɗ ni ti nday ya ti tə̀fəki ahàr ke Melefit do ni. Ay lekʉlʉm ti Bəŋ gekʉli ya e melefit bu ni àsəra ere ya àhəcikivu ana kʉli na. ");
INSERT INTO muy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Enjenjeni ti ɗəbum *Məgur ge Melefit akaba jiri gayaŋ ; nahkay zlam ndahaŋ ni ɗek day Melefit aməvikivu ana kʉli. ");
INSERT INTO muy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kàjalumki ahàr ka vaɗ ya hajəŋ ba, aɗaba vaɗ ya hajəŋ day naŋ àbu àna majalay ahàr gayaŋ zlam gayaŋ. Ku vaɗ weley weley do ɗek zlam zləzlaɗani gayaŋ àbu. » ");
INSERT INTO muy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","« Ŋgay mis ndahaŋ tàgudara zlam a ti kə̀ɗəmum ba ; tamal kəgrum nahkay ti lekʉlʉm day ŋgay kàgudaruma zlam a ti Melefit aməɗəm do. ");
INSERT INTO muy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aɗaba mam, gekʉli ya kəɗəmum tə̂wəl mis ndahaŋ àna seriya, tâtraɓ tay ni ti Melefit day aməwəl kʉli àna seriya, amatraɓ kʉli. Darama ya lekʉlʉm kəgurumi zlam ana mis ndahaŋ àna naŋ ni ti Melefit day aməguri zlam ana kʉli àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kamənjaləŋ ka cakwasl ya àniki ke eri ga wur ga muk ni, kə̀sərki ka damkoluk ya ànukki ke eri ni do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tamal kəhi ana wur ga muk ni : “Wur ga mmawa, mbrəŋ nəzukkia cakwasl ya ànukki ke eri na” ti, nak nakani kìpi damkoluk ya ànukki ke eri ni do ni ti, kəzikia ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nak bay ya aŋgah zlam magudarani gayaŋ ni ! Zəkia damkoluk ke eri gayak gayakana day. Akəzəkia ti ekipi divi lala mək akəzikia cakwasl ya àniki ke eri ana wur ga muk na. ");
INSERT INTO muy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kə̀vumi zlam *njəlatani ge Melefit ana kərá ba, do ni ti tambatkibiyu ma ke kʉli tahəpəɗkaba kʉli a. Kàfəkaɗumivu ebirsli gekʉli e divi bu ana mədrə́s ba, do ni ti təcəlki, tagudar masakani. » ");
INSERT INTO muy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","« Hindʉm zlam. Kìhindʉma ti Melefit aməvi ana kʉli. Ɗəbum zlam. Kə̀ɗəbuma ti akəŋgətum. Zalum Melefit. Kàzaluma naŋ a ti aməwəli ana kʉli, aməzləkiaba mahay ana kʉli a. ");
INSERT INTO muy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aɗaba mam, ku way way do ehindi zlam, Melefit avi. Ku way way do aɗəbay zlam, aŋgət. Ku way way do azalay, Melefit awəli, azləkiaba mahay a. ");
INSERT INTO muy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Bi wur ara afa gayak, nak bəŋana, èhindilʉka *dipeŋ a ti, kəvi akur aw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ahkay do ni bi ehindilʉka kilif a ti kəvi gavaŋ aw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Lekʉlʉm ti ndam magudar zlam. Ku tamal lekʉlʉm ndam magudar zlam nəŋgu ni, kə̀səruma məvi zlam sulumani ana bəza gekʉli a. Ay ti Bəŋ gekʉli Melefit naŋ e melefit bu, naŋ sulumani ti magray gayaŋ ahəmamam ? Naŋ ti tamal maslaŋa èhindiliŋa zlam a nahəma, aməvi zlam sulumani eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nahkay ere ye ti kawayum mis tə̂gri ana kʉli ni ti grumi ere gani nani ana tay bilegeni. Melefit àna Divi gayaŋ ya Mʉwiz àbəki ni àɗəm nahkay ; ndam mahəŋgaray *pakama ge Melefit ni day tə̀ɗəm nahkay. » ");
INSERT INTO muy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","« Zum njəɗa, kaɗumvu ga məhuriyani gwar a mahay misliceni ni. Aɗaba mahay botutani ti divi gani azoru mis e mijeni vu àwərvu do. Nahkay mis kay tə̀bu təhuriyu gwar a mahay botutani ni. ");
INSERT INTO muy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ay azoru mis ka məlaŋ ga sifa ti mahay misliceni akaba divi kʉseɗeni. Ndam ya takoru àna divi nani ni ti kay do. » ");
INSERT INTO muy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","« Bumvu slimi àna ndam ya tə̀ɗəm nday ndam mahəŋgaray *pakama ge Melefit ni. Tara afa gekʉli a ti tafəkaɗ ahàr gatay akaɗa nday təmbəmbak, ambatakani do a məɓəruv gatay bu ni ti nday akaɗa təmbəmbak eɗeɗiŋ do, nday akaɗa kərá gili cuɗayani sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Akəsərum tay ti àna tʉwi gatay ya tagray ni. Way àdifəŋ ahàr ana bəza ga enderendera kà məŋgəhaf ya akaba adak ni way ? Nahkay day tə̀difəŋ ahàr ana bəza ga *wəruv kè mezlirgendʉ do. ");
INSERT INTO muy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Məŋgəhaf sulumani lu ti ewi bəza sulumani, məŋgəhaf magədavani ti ni ewi bəza magədavani. ");
INSERT INTO muy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Məŋgəhaf sulumani, ewi bəza magədavani ti àbi. Məŋgəhaf magədavani ewi bəza sulumani ti àbi daya. ");
INSERT INTO muy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Məŋgəhaf ya èwi bəza sulumani do ni lu tekeleba, tizligiyu a aku vu. ");
INSERT INTO muy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nahkay akəsərum ndam ya ti tə̀ɗəm nday ndam mahəŋgaray pakama ge Melefit ni ti àna tʉwi gatay ya tagray ni. » ");
INSERT INTO muy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","« Sə̂ruma lala : Ndam ya təzalay nu : “Bay geli, Bay geli” ni, atəhuriyu a Məgur ge Melefit vu ti nday ɗek do. Atəhuriyu ti si ndam ya ti tagray ere ye ti Bəŋ goro naŋ a huɗ melefit bu àwayay ni kwa. ");
INSERT INTO muy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ka fat gani nani ti mis kay atəhu : “Bay geli, bay geli ! Mə̀həŋgria pakama ge Melefit ana mis àna slimi gayak a, màgariaba seteni ana mis àna slimi gayak a akaba màgra zlam ya ti agri ejep ana mis na gərgəri kay àna slimi gayak a.” ");
INSERT INTO muy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Anəhi ana tay vay-vay : “Ɗay-ɗay nə̀sər kʉli ndo. Sləkumfua, lekʉlʉm ɗek ndam ya ti kə̀grum zlam ge jiri do ni !” » ");
INSERT INTO muy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","« Tamal mis àra afa goro a ècia ma goro a mək agray ere ye ti nə̀hi ni ti, àzavu ata mis mənjəhani ya àləm ahay gayaŋ ni. Wuɗaka àləm ti àsaba asak gana, èli zileŋ mək àfəkaɗkibiyu asak ga ahay ni ka akur. ");
INSERT INTO muy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","A vaɗ nahaŋ avər àtəɗa dal-dal, aməɗ àkəzlay ga njəɗa dal-dal, yam àtamkia ka zalaka ; tawayay tembeɗ ahay ni. Ay ti tə̀gri araŋa ana ahay ni ndo, aɗaba asak ga ahay ni mafəkaɗkibiyani ka akur palam. ");
INSERT INTO muy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ay tamal mis ècia ma goro a mək àgray ere ye ti nə̀hi ni do nahəma, àzavu ata mis murani ya àləm ahay gayaŋ ka wiyaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka ya ti avər àtəɗa dal-dal, aməɗ àkəzlay ga njəɗa dal-dal, yam àtamkia ka zalaka, tawayay tembeɗ ahay ni ti ahay ni àmbəɗa hʉya. Àmbəɗkaba besek-besek. » ");
INSERT INTO muy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yezu èndeveriŋa macahi zlam ana mis macakalavani na. Zlam gayaŋ ya àcahi ana tay ni, àgria ejep ana tay a ɗek, ");
INSERT INTO muy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","aɗaba àhi ma ana tay akaɗa ga bay ni, do ni ti akaɗa ga ndam *məsər Wakita ge Melefit ni do. ");
INSERT INTO muy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yezu àra àndaya ahàr a həma ni ba nahəma, mis dal-dal tàɗəbay naŋ. ");
INSERT INTO muy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Eslini zal ambələk nahaŋ àrəkia ka Yezu nakəŋ a, àbəhaɗi mirdim, àhi ahkado : « Kam-kam, bay goro ; tamal kawayay ti kisliki mahəŋgaraba nu a ti nîgia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yezu nakəŋ àzoru ahar, ènjifiŋ, àhi ahkado : « Nawayay, gia mis njəlatana. » Nahkay zal ambələk nakəŋ àŋgaba, ègia mis njəlatana hʉya. ");
INSERT INTO muy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mək Yezu àhi : « Nihi kə̀ŋgaba nahəma, kə̀hi ma gani ana maslaŋa ba. Ru kə̂ŋgazli vu gayak ni ana bay *maŋgalabakabu mis akaba Melefit sawaŋ ; kə̂vi zlam ana Melefit akaɗa ge Mʉwiz ya àɗəm a wakita gayaŋ bu ni, aɗaba kìgia mis njəlatana. Nahkay mis etipi. Etipia ti atəsər nak kə̀ŋgaba, kìgia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka ya ti Yezu naŋ àbu ahuriyu a Kafarnahum nahəma, zal nahaŋ àrəkia, naŋ bay ga ndam slewja ga ndam *Rom, àhəŋgalay naŋ ga məjənaki naŋ, ");
INSERT INTO muy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","àhi : « Bay goro, bay məgru tʉwi àbiyu a magam mandəhaɗani èɓesey do, ègia dərana, naŋ àbu acakay daliya dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eslini Yezu àhi : « Nakoru nahəŋgaraba naŋ a. » ");
INSERT INTO muy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bay ga ndam slewja nakəŋ àhəŋgrifəŋ, àhi : « Bay goro, nu mis ga marona afa goro a di do. Ay ti ɗəm ma bəlaŋ ciliŋ ; nahkay ti bay məgru tʉwi ni aŋgaba. ");
INSERT INTO muy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nu gani day tə̀bu təgur nu, nu day nə̀bu nəgur ndam slewja goro. Tamal nəhi ana bəlaŋ gatayani “Ru !” ti, akoru. Tamal nəhi ana nahaŋ “Ra !” ti ni, ara. Tamal nəhi ana bay məgru tʉwi “Gray ere hini” ti, agray ere gani. » ");
INSERT INTO muy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yezu àra ècia ma gayaŋ na ti, àgria ejep a dal-dal, mək àhi ana ndam ya taɗəbay naŋ ni ahkado : « Nəhi ana kʉli nahəma, ku e kiɗiŋ ga ndam *Izireyel bu day, ɗay-ɗay nə̀di ahàr ana mis ya ti afəku ahàr akaɗa naŋ hini ni ndo. ");
INSERT INTO muy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nəhi ana kʉli nahəma, mis dal-dal atasləkabiya kwa kè sliri ga məlaŋ a ɗek, atəzumkabu zlam ka ahar bəlaŋ akaba Abraham, Izak, Zekʉp a *Məgur ge Melefit bu. ");
INSERT INTO muy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ay ndam ya ti giri-giri Məgur ge Melefit ni gatay ni ti atəhuriyu a Məgur ge Melefit ni vu do, atabəhaɗ tay e mite bu a məlaŋ ziŋ-ziŋeni bu. Eslini ti etitʉwi, atəcakay daliya dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yezu àhi ana bay ga ndam slewja ni ahkado : « Ru a magam, Melefit aməgruk ere ye ti kihindi ni aɗaba kə̀fukua ahàr a. » Ka sarta gani nani bay məgri tʉwi ana bay ga ndam slewja ni àŋgaba hʉya. ");
INSERT INTO muy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yezu òru a magam afa ge Piyer. Òru ènjʉa ti àdi ahàr ana mireŋ ge Piyer ni mandəhaɗani, aku àbəkia. ");
INSERT INTO muy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Eslini Yezu nakəŋ ènjifiŋ kà ahar gani ; àra ènjifiŋa ti aku ni àhəlkia hʉya. Nahkay wal ni ècikaba, àfi ahàr. ");
INSERT INTO muy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Məlakarawa àra ègia ti tə̀həlibiyu mis dal-dal ya ti seteni agray tay ni. Yezu nakəŋ àhi ma ana seteni ni ciliŋ, mək seteni ni tə̀sləkiaba ana mis na. Àhəŋgaraba ndam ga arməwər na ɗek daya. ");
INSERT INTO muy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Àgray nahkay ti, ti pakama ge Izayi bay mahəŋgaray *pakama ge Melefit ya àɗəmbiyu ni mâgravu. Pakama gani nani ti nahkay hi : « Naŋ ti àhəlkabá gedebi geli na akaba arməwər geli na ɗek.  » ");
INSERT INTO muy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yezu àra èpia mis a dal-dal tèveliŋia ahàr a ti àhi ana ndam maɗəbay naŋ ni : « Mədəgum gwar ke ledi ga dəluv ni. » ");
INSERT INTO muy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eslini zal nahaŋ naŋ bay *məsər Wakita ge Melefit àhi ana Yezu ahkado : « Mʉsi, ka məlaŋ ya akoru ni ɗek ti anaɗəboru kur. » ");
INSERT INTO muy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yezu àhəŋgrifəŋ, àhi ahkado : « Mbiki tə̀bu àna eviɗ gatay, eɗiɗiŋ day tə̀bu àna lala gatay, ay ti nu *Wur ge Mis ti nə̀bi àna məlaŋ mandəhaɗani bi. » ");
INSERT INTO muy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Maslaŋa nahaŋ e kiɗiŋ ga ndam maɗəbay naŋ ni bu àhi : « Bay goro, vu divi nakoru nìlibiya baba goro a day. » ");
INSERT INTO muy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Eslini Yezu àhi : « Ɗəbabiyu nu. Ndam ya tàwayay maɗəbay nu do ni ti nday akaɗa kisim. Nahkay mbrəŋ tay ti tîli vu gatay. » ");
INSERT INTO muy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yezu àhuriyu a *slalah ga yam vu akaba ndam maɗəbay naŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nday tə̀bu takoru ti aməɗ gəɗakani àkəzlabiyu ka ahàr ga yam ni, mək yam ni awayay arəhvù slalah ga yam ni wuɗak. Ay ka sarta gani nani ti Yezu naŋ àvu e ɗʉwir bu. ");
INSERT INTO muy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eslini ndam maɗəbay naŋ ni tàhəɗakfəŋiyu, tèpiɗek naŋ tə̀hi : « Bay geli, həŋgay leli, mə̀bu miji timey ! » ");
INSERT INTO muy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yezu nakəŋ àhi ana tay : « Aŋgwaz awər kʉli ti kamam ? Lekʉlʉm ti kə̀fumku ahàr lala faŋ ndo ! » Eslini ècikaba, àzlacaki ka aməɗ nday ata yam ni. Àra àzlaca nahkay ti yam ni ègia ɗegika. ");
INSERT INTO muy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ere ye ti Yezu àgray ni àgria ejep ana tay a dal-dal, nahkay tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Naŋ hini ti way ? Aməɗ akaba yam day ticiiki slimi ni ! » ");
INSERT INTO muy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nday nakəŋ tìnjʉa ke ledi ga dəluv na. Ledi nani ti ka haɗ ga ndam Gadara. Eslini mis cʉ seteni agray tay, tàhəraya e kiɗiŋ ge mindiviŋ ba, tə̀ŋgwivabiyu a ma vu hʉya. Nday gani tagray cuɗay dal-dal, mis tekeɗi tìsliki moroni gwar eslini do. ");
INSERT INTO muy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tə̀dəgiki ana zlahay, tə̀hi ahkado : « Nak Wur ge Melefit ti kaɗəbafəŋa mam kè leli a mam ? Sarta ga məgri daliya ana leli mba ti kàra kway-kway ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eslini ti mədrə́s ndahaŋ kay tə̀bu cak təzum zlam ka ahar bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nahkay seteni ni tə̀hi ana Yezu : « Kam-kam, tamal kawayay magaray leli ti garoru leli ti makoru məhuriviyu ana mədrə́s tegʉni ti. » ");
INSERT INTO muy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yezu nakəŋ àhi ana tay : « Dəgum ! » Eslini seteni nakəŋ tə̀sləkiaba ana mis cʉeni na, tòru tə̀huriviyu ana mədrə́s ni. Nahkay mədrə́s ni ɗek tə̀ndaya ahàr a kirim-kirim, tàra tə̀dəguyu a dəluv ni vu cizliv cizliv, mək yam ni àbazla tay a. ");
INSERT INTO muy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndam majəgay mədrə́s ni tàra tìpia ere ye ti àgravu na ti tə̀dəgiki ana hwa tiɗizl, tàcuhworu a kəsa vu. Tàra tìjʉa eslina ti tàŋgəhaɗioru ere ti àgravu ni akaba ere ye ti àgrakivu ke mis cʉeni ya seteni tə̀niviyu ana tay ni ana ndam ga kəsa ni. ");
INSERT INTO muy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nahkay ndam ga kəsa ni ɗek tə̀ŋgwivoru ana Yezu a ma vu. Tàra tìpia naŋ a ti tàhəŋgalay naŋ, tə̀hi mâsləka ka haɗ gatay a. ");
INSERT INTO muy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yezu àcəliyu a *slalah ga yam vu òru ke ledi ga dəluv ni, mək àŋgoru a kəsa gayaŋ vu. ");
INSERT INTO muy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naŋ àbu eslini ti mis ndahaŋ tə̀zibiyu zal dəra nahaŋ àki ka slalah, tawayay ti Yezu mâhəŋgaraba naŋ a. Yezu nakəŋ àra àsəra məfəki ahàr gatay na ti àhi ana zal dəra ni ahkado : « Wur goro ni, zay njəɗa, zlam magudarani gayak ni məmbərfukana. » ");
INSERT INTO muy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ndam ndahaŋ ya *təsər Wakita ge Melefit ni tə̀bu eslini ; tàra tìcia ma ga Yezu na ti tə̀jalay a ahàr gatay bu tə̀ɗəm : « Maslaŋa hini ti azay ahàr gayaŋ akaɗa naŋ Melefit timey ! » ");
INSERT INTO muy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nday tə̀bu təjalay ahàr nahkay ti Yezu àsəra ere ye ti tə̀jalaki ahàr na àndava, mək àhi ana tay : « Majalay ahàr gekʉli ti àɓəlay do ! Kajalum ahàr nahkay ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Zləzlaɗa gani ti nəhi : “Zlam magudarani gayak ni məmbərfukana” tək day ti nəhi : “Cicikaba, sawaɗay” ni aw ? ");
INSERT INTO muy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ay nawayay ti kə̂sərum, nu *Wur ge Mis ti nisliki məmbərfəŋa zlam magudarani kè mis ka haɗ a. » Mək àhi ana zal dəra nakəŋ : « Nəhuk : Cicikaba, za slalah gayak na, ru a magam. » ");
INSERT INTO muy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eslini naŋ nakəŋ ècikaba cəkwaɗ, òru a magam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nahkay mis macakalavani ni tàra tìpia ere ye ti àgravu na ti tàgra aŋgwaz a. Eslini tàzləbay Melefit aɗaba àvia njəɗa gayaŋ ana mis ga mahəŋgaraba mis a. ");
INSERT INTO muy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yezu àra àsləka eslina, naŋ àbu akoru zlam gayaŋ ti èpi zal nahaŋ, tə̀zalay naŋ Meciyʉ, naŋ àbu manjəhaɗani digʉsa ka məlaŋ məhəl hadam. Eslini Yezu nakəŋ àhi ahkado : « Ɗəbabiyu nu. » Nahkay naŋ nakəŋ ècikaba àɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kələŋ gani Yezu akaba ndam maɗəbay naŋ ni tòru afa ge Meciyʉ nakəŋ. Tòru tìnjʉa eslina ti tə̀zum zlam. Ndam *məhəl hadam akaba ndam magudar zlam kay tə̀zum zlam akaba tay daya. ");
INSERT INTO muy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eslini ndam *Feriziyeŋ tàra tìpia tay a nahkay ti tə̀hi ana ndam *maɗəbay Yezu ni ahkado : « Mʉsi gekʉli ni azum zlam ka ahar bəlaŋ akaba ndam məhəl hadam akaba ndam magudar zlam ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yezu nakəŋ àra ècia pakama gatay na ti àɗəm : « Ndam ya ti nday tə̀bu njalaŋ-njalaŋ ni ti tòru afa ga zal doktar do, si ndam ga arməwər day kwa ti takoru afa gani. ");
INSERT INTO muy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Melefit àɗəm a Wakita gayaŋ bu : “Ere ye ti nu nawayay ni ti, tə̂gri sulum ana ndam ya təcakay daliya ni ; do ni ti nàwayay zlam ya ti tìsliŋʉ ni do.” Dəgum sərumaba ma gani nana lala. Aɗaba nu nàra ti ga mazalay ndam jireni do, nàra ti ga mazalay ndam magudar zlam sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","A vaɗ nahaŋ ndam maɗəbay Zeŋ bay məbaray mis ni tə̀rəkia ka Yezu a, tə̀hi : « Leli mə̀bu məgəs *ndəra, ndam *Feriziyeŋ ni day tə̀bu təgəs, ay ti ndam maɗəbay kur ni tə̀gəs do ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Ka ya ti bay ya ti aday wal ni nday tə̀bu akaba zləbəba gayaŋ ni ti, araŋa ahəli ahàr ana zləbəba ni tata waw ? Aha ! Ay sarta nahaŋ amara, atəgəskia bay ga wal ni kà tay a. Ka sarta gani nani day kwa ti atəgəs ndəra. ");
INSERT INTO muy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","« Yaw mis àbi azay azana mʉweni asiviyu ana azana gayaŋ midigweni bi. Tamal àgra nahkay ti, azana mʉweni ni ara asəkivu azana midigweni ni, mək məlaŋ megʉzlehvani ni ara asagakivu. ");
INSERT INTO muy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nahkay day mis abəviyu zum new-neweni e kene-kene midigweni vu ti àbi. Tamal àgra nahkay ti, zum new-neweni ni àra àwəsa ti ara etezkaba kene-kene na. Nahkay ti zum ni amadəgaba, maslaŋa nani emizikiba ke kene-kene na daya. Təbəviyu zum new-neweni ti e kene-kene mʉweni vu. Nahkay nday cʉeni tàgədavu do. » ");
INSERT INTO muy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti gəɗakani ga ndam *Zʉde nahaŋ àrəkia, àbəhaɗi mirdim, àhi : « Wur goro dahalayani àməta, àmət nihi hʉya, ay ti ra, kâra kə̂bəki *ahar ti aŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nahkay Yezu nakəŋ ècikaba, tàɗəboru naŋ akaba ndam maɗəbay naŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Eslini wal nahaŋ àbu, mimiz asləkafəŋa agray vi kru mahar cʉ. Naŋ nakəŋ àhəɗakfəŋbiyu kà Yezu gwar kələŋ mək ènjifiŋ kà ma ga azana ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aɗaba àhi ana ahàr : « Ku tamal ti nìnjifiŋa kà azana gayaŋ na nəŋgu ni, naŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yezu àmbatvu, àra èpia naŋ a ti àhi : « Wur goro ni, zay njəɗa ; Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. » Àra àhia ma na ti mimiz ya asləkafəŋa ni àmbrəŋ naŋ, àŋgaba hʉya. ");
INSERT INTO muy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yezu òru ènjʉa afa ga gəɗakani nakəŋ a ti àdi ahàr ana mis dal-dal tə̀bu tabah, tə̀bu tivi cicek. Eslini àhi ana tay : ");
INSERT INTO muy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","« Sləkumaba ahalay a, aɗaba wur ni àmət ndo ; naŋ àbu enji ɗʉwir timey. » Àra àhia pakama ana tay a nahkay ti tèyefiŋ. ");
INSERT INTO muy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yezu nakəŋ àra àgaraba mis na ti àhuriyu a ahay vu, àzay ahar ga wur ni, mək wur ni ècikaba. ");
INSERT INTO muy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nahkay tə̀ɗəmoru ma gani a kəsa vu, ka haɗ nani ɗek. ");
INSERT INTO muy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yezu ara asləka eslina ti ndam wuluf cʉ taɗəboru naŋ, təzlah, təɗəm : « *Wur ge Devit, mə̂suk cicihi ti ! » ");
INSERT INTO muy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka ya ti Yezu òru ènjʉa a magam a ti ndam wuluf cʉeni ni tàhəɗakfəŋiyu mək Yezu nakəŋ àhi ana tay ahkado : « Kə̀fumkua ahàr a, nìsliki magray ere ye ti kihindʉmfua ni aw ? » Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Iy Bay geli, kisliki. » ");
INSERT INTO muy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nahkay Yezu nakəŋ ènjifiŋ kè eri gatay ni, àɗəm : « Kə̀fumku ahàr : nahkay Melefit mə̂gri ere gani ana kʉli akaɗa ya kawayum ni. » ");
INSERT INTO muy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eslini nday nakəŋ tìpi divi hʉya. Yezu àləgi ana tay, àhi ana tay ahkado : « Bumvu slimi, maslaŋa èci ma gani ba. » ");
INSERT INTO muy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ay nday nakəŋ tàra tàhəraya a dala va ti tə̀njəki məɗəmoru ma gani ka haɗ nani ɗek. ");
INSERT INTO muy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ka ya ti ndam wuluf ni tasləka ni ti mis ndahaŋ tə̀zibiyu zal nahaŋ ana Yezu. Zal nani ti seteni àniviyu, acafəŋa naŋ ga mazlapana. ");
INSERT INTO muy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eslini Yezu àgariaba seteni na ana zal nakəŋ a, mək naŋ nakəŋ àzlapay hʉya. Mis dal-dalani ye eslini ni ɗek tàgra ejep gana dal-dal, tə̀ɗəm : « Ɗay-ɗay mis tìpi zlam akaɗa hini àgravu e Izireyel ndo. » ");
INSERT INTO muy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ay ti ndam *Feriziyeŋ tə̀ɗəm : « Agariaba seteni ana mis a ni ti àna njəɗa ga bay ge seteni. » ");
INSERT INTO muy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yezu àsawaɗay a kəsa gəɗákani bu akaba a kəsa ciɓ-ciɓeni bu. A kəsa ya ti ènjʉa ni va lu ti àcahi zlam ana mis a ahay ga *mahəŋgalavù Melefit gatay ni bu. Àhi *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit ana tay, ahəŋgaraba ndam ya tèɓesey do na ɗek akaba ndam dəra gərgərana ɗek. ");
INSERT INTO muy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Naŋ nakəŋ àra èpia mis dal-dalani na ti tə̀sia cicihi a. Aɗaba nday akaɗa ga təmbəmbak ya ti bay majəgay tay àbi ; tàmətaɓkaba, njəɗa àfəŋ ka tay va bi ni. ");
INSERT INTO muy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nahkay àhi ana ndam maɗəbay naŋ ni ahkado : « Mis ya ti tìci pakama goro faŋ ndo ni ti nday kay, nday akaɗa ga zlam ya ti tabaz a vədaŋ bu ni, ay ti ndam mabaz zlam ni tə̀bi kay bi. ");
INSERT INTO muy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nahkay si kahəŋgalum Melefit Bay ga vədaŋ ni ti mə̂slərbiyu ndam mabaz zlam a vədaŋ gayaŋ bu. » ");
INSERT INTO muy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yezu àzalakabu ndam maɗəbay naŋ kru mahar cʉeni ni. Àra àzalakabá tay a ti àvi njəɗa ana tay ga magariaba seteni ana mis a, ga mahəŋgaraba mis a arməwər gərgərani ba ɗek akaba ga mahəŋgaraba ndam dəra gərgərana ɗek. ");
INSERT INTO muy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Slimi ga ndam *asak gayaŋ kru mahar cʉeni ni nday hi : Simu àdi slimi Piyer, wur ga məŋani Andre, bəza ge Zebede ata Zek nday ata wur ga məŋani Zeŋ, ");
INSERT INTO muy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartelemi, Tumas, Meciyʉ bay ya àhəl hadam ni, Zek wur ga Alfe, Tade, ");
INSERT INTO muy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simu naŋ bəlaŋ ga ndam ya takaɗvakivu ka haɗ gatay ni, nahaŋ ni ti ni Zʉdas Iskariyot naŋ ya ègi bay məsəkumoru Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nday kru mahar cʉeni hini ti Yezu àsləroru tay, àhi ana tay ahkado : « Kə̀dəgum afa ga ndam jiba ndahaŋ ba, kə̀dəgum a kəsa ga haɗ *Samari vu ba daya. ");
INSERT INTO muy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ay dəgum ti afa ga ndam *Izireyel nday ya ti akaɗa təmbəmbak mijeni ni. ");
INSERT INTO muy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka ahàr divi nahəma, humi ana mis ahkado : “*Məgur ge Melefit ènjia wuɗak.” ");
INSERT INTO muy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Həŋgarumaba ndam ya tèɓesey do na, həŋgarumaba mis e kisim ba, həŋgarumaba ndam ambələk a, garumiaba seteni ana mis a daya. Melefit àvi zlam ana kʉli ga sulum, lekʉlʉm day vumi ana mis ga sulum bilegeni. » ");
INSERT INTO muy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Àhi ana tay ahkado : « Kədəgum nihi nahəma, kə̀zum zlam a ahar vu ba ; ku gru, ku evirzegena, ku siŋgu day kə̀həlum e zlembi vu ba. ");
INSERT INTO muy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ku mbolu, ku endʉwi cʉ cʉ, ku kimaka, ku aday day kə̀həlum ba. Aɗaba bay magray tʉwi ti agəski təvi zlam məzumani. ");
INSERT INTO muy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","« Ka ya ti ekinjʉmiya a kəsa gəɗakani va ahkay do ni a kəsa gʉziteni va nahəma, ɗəbum maslaŋa ya ti agəskabu kʉli di ni. Tamal kə̀dumia ahàr a ti njəhaɗuma eslina ; kàmbatum ahay nahaŋ ba duk abivoru ana vaɗ gekʉli ya akəsləkuma ni. ");
INSERT INTO muy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka sarta ya akəhurumiyu a ahay vu afa ge mis nahəma, grumi sa, humi : “*Sulum ge Melefit mə̂ləbu akaba kʉli.” ");
INSERT INTO muy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tamal ti ndam ga huɗ ahay nani tə̀gəskabá kʉli a, tìslia məŋgət sulum a ti sulum gekʉli ni amələbu akaba tay. Ay tamal ndam ga huɗ ahay nani tìsli məŋgət sulum do ni ti sulum gekʉli ni aməŋgəkia ke kʉli zlam gekʉli a. ");
INSERT INTO muy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tamal ndam ga huɗ ahay ni ahkay do ni ga kəsa ni tə̀gəskabu kʉli do, tàwayay miciki pakama gekʉli ni ana kʉli do nahəma, sləkuma eslina. Ka ya ti kəsləkuma ni ti təkumkaba haɗ ga kəsa gatay na kà asak gekʉli a. ");
INSERT INTO muy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nəhi ana kʉli nahəma, ka fat ya ti Melefit agray seriya ni ti ku ndam *Sodom akaba ndam *Gomor nəŋgu ni seriya ge Melefit ya amagrafəŋa kà tay a ni ti ŋgulum emisli ga ndam ga kəsa gani nani ya tə̀gəskabu kʉli do ni do. » ");
INSERT INTO muy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yezu àhi ana tay keti : « Dəgum. Nihi ti nəsləroru kʉli e kiɗiŋ ge mis vu akaɗa ga bəza təmbak e kiɗiŋ ga kərá gili bu ni. Nahkay njəhuma akaɗa ga gavaŋ na, njəhaɗuma kuɗufa akaɗa ga kurkoduk na. ");
INSERT INTO muy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bumvu slimi, aɗaba mis atəgəs kʉli, atoru àna kʉli ka məlaŋ ge seriya. Atəzləɓ kʉli àna kurupu a ahay gatay ya *tahəŋgalavù Melefit ni bu. ");
INSERT INTO muy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Atagrafəŋa seriya kè kʉli kè meleher ga gəɗákani ga ngumna akaba bəbay a, aɗaba lekʉlʉm ndam goro. Nahkay ti nday gani etici ma gekʉli ya akazlapumku ni, mis ndahaŋ ya ti nday ndam *Zʉde do ni etici daya. ");
INSERT INTO muy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ka ya ti atəgəs kʉli, atoru àna kʉli ka məlaŋ ge seriya nahəma, ere ye ti akəɗəmum ni akaba slala ga ma ya akəɗəmum ni àhəli ahàr ana kʉli ba. Ka sarta nani Melefit aməhi ere ye ti akəɗəmum ni ana kʉli. ");
INSERT INTO muy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Akəɗəmum ma nani ti lekʉlʉm lekʉlʉmeni do ; amazlapay ti Məsuf ga Bəŋ gekʉli ya e kʉli bu ni. ");
INSERT INTO muy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ka sarta gani nani ti mis atəsəkumoru bəza ga məŋ gatay ti tâbazl tay, ata bəŋ ga bəza day atəsəkumoru bəza gatay. Bəza ti ni etizirey ata bəŋ gatayani akaba ata məŋ gatayani, atəsəkumoru tay ti tâbazl tay. ");
INSERT INTO muy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mis ɗek etizirey kʉli aɗaba lekʉlʉm ndam goro. Ay ti maslaŋa ya ti aməmbrəŋ nu do duk abivoru ana vaɗ ga mandav ga sifa gayaŋ ni ti Melefit amahəŋgay naŋ. ");
INSERT INTO muy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka ya ti atəgri daliya ana kʉli a kəsa bu nahəma, cuhwumoru a kəsa nahaŋ vu. Nəhi ana kʉli nahəma, wuɗaka kendeveriŋʉm masawaɗabana kəsa ga haɗ Izireyel a ti nu *Wur ge Mis nìnjia àndava. ");
INSERT INTO muy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","« Maslaŋa ya acahay zlam ni ti àtam bay ya ti acahi zlam ni do. Eviɗi day àtam bay ya ti agur naŋ ni do. ");
INSERT INTO muy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Maslaŋa ya ti acahay zlam ni, tamal àsəra zlam akaɗa ga maslaŋa ya ti acahi na ti tìgia kala-kala. Eviɗi day tamal ègia kala-kala ata bay ya ti agur naŋ na ti èslia gayaŋ a. Tamal Bay ahay ni tekeɗi tə̀hi “Nak *Belzebʉl” ti, ndam gayaŋ ni ti atəhi mam ana tay do mam ? » ");
INSERT INTO muy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yezu àɗəm keti : « Kə̀grumfəŋa aŋgwaz kè mis nday nana ba. Aɗaba zlam maŋgahani ni ɗek emipivu ; ma maŋgahani ni ɗek emicivu. ");
INSERT INTO muy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nahkay ma ya ti nəhi ana kʉli a məlaŋ ziŋ-ziŋeni bu ni ɗek, ɗəmumaya vay-vay a məlaŋ maslaɗani ba. Ma ya ti təhiviyu ana kʉli e slimi vu ni ti zlahum àna naŋ kay-kay ka ahàr ga həma. ");
INSERT INTO muy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kə̀grumfəŋa aŋgwaz kà ndam ya takaɗ mis na ba, aɗaba sifa ge mis ya àndav ɗay-ɗay do ni ti tìjiŋ koksah. Grumfəŋa aŋgwaz a ti kà Bay ya ti esliki mizligiyu mis a *dəluv ga aku vu ni. Aku gani nani ti azum mis, ejiŋ sifa gayaŋ ga kaŋgay-kaŋgayani daya. ");
INSERT INTO muy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tə̀bu təsəkum eɗiɗiŋ ciɓ-ciɓeni cʉ àna siŋgu bəlaŋ bi aw ? Ay səruma, eɗiɗiŋ nday nani ti, tamal Bəŋ gekʉli àvay divi gani ndo ni ti ku bəlaŋ day àmət do. ");
INSERT INTO muy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lekʉlʉm day ku məhər ga ahàr gekʉli nəŋgu ni Melefit àcalaba ɗek. ");
INSERT INTO muy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nahkay kə̀grum aŋgwaz ba, ku eɗiɗiŋ kay day kàtamuma tay kè eri ge Melefit a. ");
INSERT INTO muy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","« Nəhi ana kʉli nahəma, ku way way do tamal aɗəm vay-vay naŋ mis goro kè meleher ge mis ti, nu *Wur ge Mis day anəɗəm vay-vay naŋ mis goro kè meleher ga Baba, naŋ ya a huɗ melefit bu ni. ");
INSERT INTO muy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ay maslaŋa ya ti aɗəm naŋ mis goro do nahəma, nu day anəɗəm naŋ mis goro do kè meleher ga Baba naŋ ya e melefit bu ni. » ");
INSERT INTO muy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yezu àɗəm keti : « Lekʉlʉm kə̀ɗəmum nu nàra a duniya va ti, ti mis tânjəhaɗ e kiɗiŋ gatay bu àna sulumani aw ? Aha ! Nu nàra ti, ti mis tîzirevu sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nu nàra ti ga medekaba wur ata bəŋana, wur dahalay ata məŋana, wal ga wur day nday ata məŋ ga zal gana. ");
INSERT INTO muy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ku way way do ndam ga huɗ ahay gayaŋ etigi ndam ezir gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Maslaŋa ya ti awayay bəŋani ahkay do ni məŋani àtam nu nahəma, èsliki migi mis goro do. Maslaŋa ya ti awayay wur gayaŋ zalani ahkay do ni wur gayaŋ walani àtam nu nahəma, èsliki migi mis goro do. ");
INSERT INTO muy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Maslaŋa ya ti àgəskabu daliya do ni ti èsliki migi mis goro do. Ku tamal tawayay *madarfəŋ naŋ kà təndal nəŋgu ni, ahàr àɗəm mâɗəbay nu. Tamal àgray nahkay do ni ti èsliki migi mis goro koksah. ");
INSERT INTO muy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Maslaŋa ya ti àɗəm ajəgur sifa gayaŋ ti àmət ba ni ti emijiŋ. Ay maslaŋa ya ti emijiŋ sifa gayaŋ azuhva nu ti aməjəgur sawaŋ, àmət ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","« Maslaŋa ya ti àgəskabá kʉli a ni ti àgəskabá nu a daya ; maslaŋa ya ti àgəskabá nu a ni ti àgəskabu nu ciliŋ do, àgəskabá Bay ya ti àslərbiyu nu na daya. ");
INSERT INTO muy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Maslaŋa ya ti àgəskabá bay mahəŋgaray *pakama ge Melefit a aɗaba àsəra maslaŋa nani bay mahəŋgaray pakama ge Melefit ti, naŋ day Melefit aməvi zlam ya ti təvi ana ndam mahəŋgaray *pakama ge Melefit ni. Maslaŋa ya ti àgəskabá mis ge Melefit jirena aɗaba àsəra maslaŋa nani mis jireni ti, Melefit aməvi zlam ya ti təvi ana ndam jireni ge Melefit ni. ");
INSERT INTO muy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nəhi ana kʉli nahəma, ku way way do tamal àcəhiaya yam liŋ-liŋena e hijiyem va ana bay maɗəbay nu gʉzitena ku bəlaŋ na aɗaba àsəra maslaŋa nani bay maɗəbay nu ti, Melefit aməvi zlam azuhva zlam gayaŋ ya àgray ni, amagəjazlki ahàr do. » ");
INSERT INTO muy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yezu àra èndeveriŋa məhi ma ana ndam maɗəbay naŋ kru mahar cʉeni na ti àsləka òru ga macahi zlam ana mis ka haɗ nani akaba ga məhi ma ge Melefit ana tay. ");
INSERT INTO muy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zeŋ bay məbaray mis ni naŋ àvu a daŋgay bu. Àra ècia tʉwi ge *Krist ya agray na ti àsləroru ndam maɗəbay naŋ ndahaŋ, ");
INSERT INTO muy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","awayay ti tə̂hi : « Nak ti *Bay gəɗakani ya amara ni tək, day ti mâhətay maslaŋa nahaŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nday nakəŋ tòru tìnjʉa afa ga Yezu a ti tə̀hi ma gani, mək Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Dəgum kâŋgahaɗumi ana Zeŋ zlam ya ti kicʉm akaba ya kipʉm ni. ");
INSERT INTO muy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Humi : “Ndam wuluf tə̀bu tipi divi, ndam dəra təsawaɗay lala, ndam ambələk tìgia mis njəlatana, ndam makwaya tici slimi, mis ya tə̀mət ni tàŋgaba, ndam talaga day tìcia Ma Mʉweni Sulumana.” ");
INSERT INTO muy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Humi keti : “Maslaŋa ya ti èjikia ke divi azuhva nu a do nahəma, mə̂mərvu.” » ");
INSERT INTO muy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ndam ya ti Zeŋ àslərkibiyu tay ka Yezu ni tàra tàsləka ti Yezu àzlapaki ke Zeŋ, àhi ana mis dal-dalani ni ahkado : « Kə̀dəgum a huɗ gili vu ti ga mipibiyu mam ? Kìpʉmbiyu ti mavram ya aməɗ adaɗay ni tək ? ");
INSERT INTO muy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Do ni ti kə̀dəgum kìpʉmbiyu ti mam ? Mis məbakabu azana sulumani akaɗa ga bay ni tək ? Aha, ndam ya tabakabu azana ga siŋgu kayani ni ti nday a ahay ga bəbay bu timey. ");
INSERT INTO muy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ay ti kə̀dəgum kìpʉmbiyu ti mam ? Kìpʉmbiyu bay mahəŋgaray *pakama ge Melefit aw ? Iy, naŋ gani. Nəhi ana kʉli nahəma, naŋ ti àtama bay mahəŋgaray pakama ge Melefit a. ");
INSERT INTO muy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kə̀səruma, àbu məbəkiani a Wakita ge Melefit bu, Melefit àhi ana Bay gəɗakani ya amara ni nahkay hi : “Nihi ti nu nə̀bu nəsləroru bay məslər goro nahaŋ kama gayak ti mâslamatukkabu divi.” « Maslaŋa ya ti Melefit àslərbiyu ni ti Zeŋ. ");
INSERT INTO muy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nəhi ana kʉli nahəma, Zeŋ bay məbaray mis ni ti àtama mis ya tìwi tay na ɗek àna gəɗakana. Ku tamal nahkay nəŋgu ni, bay ya ti naŋ gʉziteni ge mis ɗek a *Məgur ge Melefit bu ni ti àtama naŋ a. ");
INSERT INTO muy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kwa ka sarta ya ti Zeŋ bay məbaray mis ni àɗəmki ma ka Məgur ge Melefit àbivaya ana kana, Məgur ge Melefit gani akoru kama kama àna njəɗa ; ndam njəɗa-njəɗani təhuriyu. ");
INSERT INTO muy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","E *Divi ge Melefit ya Mʉwiz àbəki ni bu akaba a wakita ga ndam ndahaŋ ya tàhəŋgaray *pakama ge Melefit ni bu ɗek ti tə̀bu təɗəmki ma ka Məgur gani nani, duk àbivu ana sarta ge Zeŋ bay məbaray mis ni. ");
INSERT INTO muy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ahàr àɗəm gəsumkabu ma goro ni : Zeŋ ti nani Eli ya ti Wakita ge Melefit àɗəm amaŋga ni. ");
INSERT INTO muy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Maslaŋa ya ti slimi àfəŋ nahəma, mîci lala ! » ");
INSERT INTO muy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yezu àhi ana tay keti : « Mis ye e hini vu ni ti nəgurfəŋ tay kà way ? Nday akaɗa way ? Nəhi ana kʉli nahəma, nday akaɗa ga bəza manjəhaɗani e mite bu ni. Nday ndahaŋ təhi ana ndahaŋ ni ahkado : ");
INSERT INTO muy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mìvia slelim ana kʉli a, day kə̀həɓumfəŋ ndo ; mìdia limis ge kisim ana kʉli a, day kìtʉwʉm ndo.” ");
INSERT INTO muy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nə̀ɗəm nahkay ti aɗaba Zeŋ àra ti àzum *dipeŋ do, èsi zum do. Nahkay tə̀ɗəm seteni àniviyu. ");
INSERT INTO muy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nu *Wur ge Mis ti ni nàra. Nàra ti nu nə̀bu nəzum dipeŋ, nə̀bu nisi zum. Nahkay mis tə̀ɗəm nu zal huɗ, nəvi vu goro ana zum. Tə̀ɗəm nu zləba ga ndam *məhəl hadam akaba ga ndam magudar zlam ndahaŋ. Ay ti Melefit aɗafaki məsər zlam gayaŋ ni jireni ti àna tʉwi gayaŋ ya agray ni. » ");
INSERT INTO muy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Eslini Yezu nakəŋ àləgi ana ndam ga kəsa gərgərani ya ti àgray zlam magray ejep ahar gəɗakani eslini ni ; àləgi ana tay ti aɗaba tàmbatkaba majalay ahàr gatay a ndo. ");
INSERT INTO muy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Àɗəm : « Akəsum cicihi, ndam Koraziŋ ! Akəsum cicihi, ndam Beceyda ! Aɗaba mam, nàgra zlam a kay ya mis tìpi ɗay-ɗay ndo na a kəsa gekʉli ba. Tamal nàgray zlam nday nani e Tir ahkay do ni a Sidoŋ nahəma, amal ndam ga kəsa nday nani tə̀mbrəŋa zlam magudarani gatay na kwa ahaslana àndava. Amal tàmbatkaba majalay ahàr gatay a, tàbakabá mbolu ka vu a akaɗa ga azana na, tàbakabiyu viti ka ahàr a. ");
INSERT INTO muy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ay nəhi ana kʉli nahəma, ka fat ya ti Melefit amagray seriya ni ti seriya ya ti amagrafəŋa kà ndam Tir akaba ndam Sidoŋ a ni ti ŋgulum, emisli gekʉli ni do. ");
INSERT INTO muy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lekʉlʉm ndam Kafarnahum, kə̀humi ana ahàr akədəgum e melefit vu aw ? Aha ! Akədəgum ti ka məlaŋ ge *kisim sawaŋ. Aɗaba mam, nàgra zlam kay ya mis tìpi ɗay-ɗay ndo na a kəsa gekʉli ba. Tamal nàgray zlam nday nani a *Sodom nahəma, ku kani day amal kəsa nani naŋ àbu kekileŋa zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nəhi ana kʉli ka fat ya ti Melefit agray seriya zla nahəma, seriya ya ti amagrafəŋa kà ndam Sodom a ni ti ŋgulum, emisli gekʉli ni do. » ");
INSERT INTO muy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ka sarta gani nani Yezu àzlapay, àɗəm : « Nazləbay kur, Bəba goro ni, nak Bay məgur məlaŋ ya e melefit bu akaba məlaŋ ya a ga haɗ ni ɗek. Nazləbay kur ti aɗaba kə̀ŋgahkia zlam nday nana ka ndam məsər zlam a akaba ka ndam ya tìjeŋga tə̀səra zlam a ni, kə̀ɗəfikia ana ndam ya tə̀sər zlam do akaɗa ga bəza ciɓ-ciɓeni na sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iy Bəba goro ni, kàgray ka mawayay gayak nahkay ti kə̀məra àna naŋ a palam. » ");
INSERT INTO muy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Àɗəm keti : « Baba àvua zlam na ɗek a ahar va. Nahkay maslaŋa ya àsər Wur ge Melefit naŋ way ni ti maslaŋa gani àbi ; si Bəŋani ciliŋ. Yaw maslaŋa ya àsər Bəŋ goro naŋ way ni ti maslaŋa gani àbi, si nu Wur gayaŋ akaba ndam ya ti nu Wur gayaŋ ni nawayay nəɗəfiki naŋ ana tay ni ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","« Lekʉlʉm ya ti kàmətaɓuma ga mazay zlam məɗəsani ni ti dəguma ɗek afa goro a. Nahkay ti nu anəvi məpəsabana ana kʉli a. ");
INSERT INTO muy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gəsumkabá ma goro ya nə̀hi ana kʉli grum na akaɗa slasla ya təgəskabu təbəki zuk ka tay ni ; cahum zlam afa goro. Aɗaba nu kuɗufa, nə̀gri daliya ana kʉli do ; akəpəsumaba afa goro zlam gekʉli a. ");
INSERT INTO muy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aɗaba zlam ya ti nəfəki ke kʉli ni ti kəzum tata. Zlam ya nəzəkiyu ke kʉli ni day àɗəski ke kʉli do. » ");
INSERT INTO muy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","A vaɗ *məpəsabana nahaŋ ba ti Yezu akaba ndam maɗəbay naŋ ni tə̀bu tasləkaba a vədaŋ ga *alkama ba. Ay ti lʉwir àbu awər ndam maɗəbay naŋ ni. Eslini tə̀njəki ka meheɓoru alkama ni, tahəpəɗoru bəza gani. ");
INSERT INTO muy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ndam *Feriziyeŋ ni tàra tìpia tay a nahkay ti tə̀hi ana Yezu ahkado : « Bay Melefit àɗəm e *Divi gayaŋ ni bu : “Kə̀grum tʉwi a vaɗ məpəsabana ba ba” ti, nihi ti ndam maɗəbay kur ni tagray timey ! » ");
INSERT INTO muy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yezu àra ècia ma gatay na ti àhi ana tay : « Kèjeŋgʉm ere ye ti Devit àgray ni ndo aw ? Ahaslani Devit akaba ndam gayaŋ lʉwir àwəra tay a, ");
INSERT INTO muy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nahkay àhuriyu a ahay ge Melefit vu, àzay *dipeŋ ya tàfəkaɗi ana Melefit ni. Devit nakəŋ àzum, mək àvi ana ndam gayaŋ ni tə̀zum bilegeni. Ay ti Melefit àɗəm e Divi gayaŋ ni bu, mis ndahaŋ tə̀zum dipeŋ nani do ; si ndam *maŋgalabakabu mis akaba Melefit ni day kwa ti təzum. ");
INSERT INTO muy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Magray tʉwi a vaɗ məpəsabana ba ti Melefit àcafəŋa mis e Divi gayaŋ ya Mʉwiz àbəki ni ba. Ay ti àbu məbəkiani a wakita nani bu ku a vaɗ məpəsabana ba ndam maŋgalabakabu mis akaba Melefit ni tâgray tʉwi a *ahay gəɗakani ge Melefit ni bu, tàcalki tay ka zlam magudarani do ni ti, kèjeŋgʉm ma gani ndo waw ? ");
INSERT INTO muy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nəhi ana kʉli nahəma, maslaŋa ya ti àtam ahay ge Melefit ni, naŋ àbu ahalay. ");
INSERT INTO muy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pakama àbu məbəkiani a Wakita ge Melefit bu nahkay hi : “Ere ye ti nu nawayay ni ti, tə̂gri sulum ana ndam ya təcakay daliya ni ; do ni ti nàwayay zlam ya ti tìsliŋʉ ni do.” Tamal kə̀sərumaba huɗ ga ma hina ti, ŋgay ndam ya tàgudar araŋa ndo ni tàgudara zlam a ti akal kə̀ɗəmum do. ");
INSERT INTO muy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aɗaba Bay ya ti aɗəm tâgray zlam hini a vaɗ məpəsabana ba ni ti nu *Wur ge Mis. » ");
INSERT INTO muy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yezu àsləka eslina ti àra àhuriyu a ahay gatay ya *tahəŋgalavù Melefit ni vu. ");
INSERT INTO muy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Eslini zal nahaŋ naŋ àvu ahar mikʉlfiŋana. Mis ya tə̀bu eslini ni tawayay tacalki Yezu ka zlam magudarani, nahkay tə̀hi : « E *Divi ge Melefit ya Mʉwiz àbəki ni bu ni ti Melefit àva divi a ti tâhəŋgaraba mis a vaɗ *məpəsabana ba waw ? » ");
INSERT INTO muy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eslini Yezu àhi ana tay ahkado : « Way e kiɗiŋ gekʉli bu naŋ àbu àna təmbak gayaŋ bəlaŋ mək təmbak ni àdiya e eviɗ va a vaɗ məpəsabana ba ti àzaya do ni way ? ");
INSERT INTO muy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ay ti mis hihirikeni ti àtam təmbak do waw ? Nahkay ti e Divi ge Melefit ya Mʉwiz àbəki ni bu ni ti Melefit àvia divi ana mis ga magray sulum a vaɗ məpəsabana ba. » ");
INSERT INTO muy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mək Yezu nakəŋ àhi ana zal ya ti ahar mikʉlfiŋana ni ahkado : « Təlbiyu ahar gayak ni. » Àra àtəlikabiya ti ahar gayaŋ ni àslamalava ègia sənduɓ-sənduɓana akaɗa nahaŋ na. ");
INSERT INTO muy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Nahkay ndam *Feriziyeŋ ni tàhəraya a ahay ni ba ni ti tàŋgasvu, tàgray sawari ahəmamam ti tijiŋ Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yezu àra ècia sawari gatay na ti àsləka eslina, òru ka məlaŋ nahaŋ. Nahkay mis dal-dal tàɗəboru naŋ mək naŋ nakəŋ àhəŋgaraba ndam ga arməwər na ɗek. ");
INSERT INTO muy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ay ti àləgi ana tay àɗəm : « Kə̀ɗəfum nu ba. » ");
INSERT INTO muy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zlam gani nani àgravu ɗek ti, ti pakama ga Bay Melefit ya àhi ana bay mahəŋgaray *pakama gayaŋ Izayi ni mâgravu. Pakama gani nani ti nihi : ");
INSERT INTO muy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","« Bay məgru tʉwi ya nə̀dəkiba ni ti naŋ hi, nawayay naŋ dal-dal ; məɓəruv goro amərvu àna naŋ dal-dal. Anəvi Məsuf goro mək aməhi ma ge jiri goro ana mis ga haɗ ni ɗek ; ");
INSERT INTO muy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","amaləgavu akaba mis do, aməvalahay do, maslaŋa emici ma gayaŋ kwaŋa kwaŋa a dala bu do. ");
INSERT INTO muy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Emeheɓkaba mavram ya awayay ahuɓ wuɗak na do. Emimetiŋ aku ge ceŋgel ya awayay amət wuɗak ni do. Amagray nahkay, duk abivoru ana vaɗ ya ti mis ga duniya ɗek tə̀gəskabá jiri ge Melefit a ni. ");
INSERT INTO muy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mək mis ga haɗ ni ɗek atəfəki ahàr ka naŋ, atəɗəm amahəŋgay tay.  » ");
INSERT INTO muy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Eslini tə̀zibiyu zal seteni nahaŋ ana Yezu. Maslaŋa gani nani ti seteni ni àwulufa naŋ a, acafəŋa naŋ ga mazlapana daya. Yezu nakəŋ àhəŋgaraba maslaŋa nana ; maslaŋa nani àzlapay, èpi divi. ");
INSERT INTO muy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mis dal-dalani ye eslini ni ɗek tàra tìpia ti àgria ejep ana tay a dal-dal, tə̀ɗəm : « Maslaŋa hini ya àhəŋgaraba mis a ni ti wur ge Devit do waw ? » ");
INSERT INTO muy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ndam *Feriziyeŋ ni tàra tìcia ma na ti tə̀ɗəm : « Maslaŋa hini agariaba seteni ana mis a ti si àna njəɗa ge *Belzebʉl bay ge seteni ni kwa. » ");
INSERT INTO muy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yezu àra àsəra ere ye ti təjalaki ahàr na ti àhi ana tay ahkado : « Tamal ndam ga haɗ nahaŋ nday ndayani takaɗvu e kiɗiŋ gatay bu ni ti mis akaba zlam ga haɗ gani etigi ahàr. Nahkay day tamal ndam ga kəsa ahkay do ni ga huɗ ahay takaɗvu e kiɗiŋ gatay bu ni ti kəsa gani ahkay do ni huɗ ahay gani àŋgoru kama do. ");
INSERT INTO muy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Nahkay day tamal *Seteni agariaba seteni ana mis a ti njəɗa gayaŋ èdeva ; ègia nahkay ti aŋgoru kama ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ay tamal nu nagariaba seteni ana mis àna njəɗa ge Belzebʉl a ti ndam gekʉli ni tagariaba seteni ana mis a ti àna njəɗa ga way ? Nahkay zlam ga ndam gekʉli gekʉleni ya tagray ni ti aɗafaki ere ye ti kə̀ɗəmum ni ti ma ga malfaɗa. ");
INSERT INTO muy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nagariaba seteni ana mis a ti àna njəɗa ga *Məsuf ge Melefit a sawaŋ. Goro ya nagray nahkay ni ti aɗafaki *Məgur ge Melefit ènjikia ke kʉli a àndava. » ");
INSERT INTO muy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yezu àɗəm keti : « Mis ahuriyu a ahay ge mis njəɗa-njəɗani vu ti mək ahəlfəŋa zlam gayaŋ a mənjəɗ mə̂wəl naŋ ti àgravu koksah. Si tamal àwəla naŋ a day kwa ti ahəlfəŋa zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Maslaŋa ya ti naŋ àbi akaba nu bi nahəma, naŋ zal ezir goro. Nahkay maslaŋa ya ti àjənaki nu ga mazalubiyu mis do nahəma, agarafua tay a sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","« Nəhi ana kʉli nahəma, zlam magudarani ge mis ya ti tagudar ni ɗek akaba ndivey ya ti tindivi Melefit ni ɗek ti Melefit ambərfəŋa kà tay a. Ay maslaŋa ya ti endivi Məsuf gayaŋ ni ti magudar zlam gayaŋ nani ti Melefit aməmbərfəŋa do simiteni. ");
INSERT INTO muy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Maslaŋa ya ti aɗəmku ma magədavani ka nu, nu *Wur ge Mis ni ti Melefit aməmbərfəŋa zlam magudarani gayaŋ nana. Ay maslaŋa ya ti aɗəmki ma magədavani ka *Məsuf Njəlatani ni ti ku ka sarta hini Melefit àmbərfəŋa do, ku ka məlaŋ mʉweni ya Melefit amagraya ni day aməmbərfəŋa do. » ");
INSERT INTO muy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yezu àɗəm keti : « Nəɗəm nahəma, tamal məŋgəhaf sulumani ti bəza gani day sulumani. Ay tamal məŋgəhaf magədavani ti bəza gani day magədavani. Nahkay məŋgəhaf ti təsərkaba tay àna bəza gatayana. ");
INSERT INTO muy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Lekʉlʉm ti medékw ! Lekʉlʉm ndam magədavani, kəɗəmum ma sulumani tata waw ? Aɗaba pakama ya ti ahəraya a ma ge mis ba ni ti àsaɓikia ka məɓəruv a palam. ");
INSERT INTO muy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nahkay mis sulumani azaya zlam sulumana a zlam maŋgahani sulumani ya àniviyu a məɓəruv bu ni, mis magədavani ti ni azaya zlam magədavana a zlam maŋgahani magədavani gayaŋ ba. ");
INSERT INTO muy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nəhi ana kʉli nahəma, ka fat ya ti Melefit amagrafəŋa seriya kè mis a ni ti ku way way do amahəŋgarfəŋ kà pakama gayaŋ magədavani ya àɗəm ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Aɗaba ka fat ge seriya nani emizli kur ti pakama gayak ya kə̀ɗəm ni ; aməwəl kur ti pakama gayak ya kə̀ɗəm ni daya. » ");
INSERT INTO muy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Eslini ndam *məsər Wakita ge Melefit akaba ndam *Feriziyeŋ ndahaŋ tə̀hi ana Yezu ahkado : « Mʉsi, mawayay ti griaya ere ye ti mìpi ɗay-ɗay ndo na ana leli a. » ");
INSERT INTO muy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yezu àhi ana tay ahkado : « Ndam ye e hini vu ni ti ndam magudar zlam, tə̀fəki ahàr ke Melefit do, tawayay tə̂griaya ere ye ti mis tìpi ɗay-ɗay ndo na ana tay a. Ay ere ye ti tihindi ni ti Melefit aməgri ana tay do simiteni. Melefit aməɗəfiki ere ye ti àɗafaki àna Zonas bay mahəŋgaray *pakama gayaŋ ni ana tay ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Akaɗa ga Zonas ya ànjəhaɗviyu a huɗ ge kilif vu vaɗ mahkər ni ti, nu *Wur ge Mis day anagraviyu vaɗ mahkər a haɗ vu. ");
INSERT INTO muy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ka fat ya ti Melefit amagrafəŋa seriya kè mis a ɗek nahəma, ndam Niniv eticikaba akaba mis ye e hini vu na, atəhi ana mis ye e hini vu ni “Lekʉlʉm ndam magudar zlam.” Aɗaba mam, ndam Niniv tàra tìcia pakama ga Zonas ya àhi ana tay na ti tàmbatkaba majalay ahàr gatay na. Ay ahalay ti mis àbu àtama Zonas àna gəɗakana ti kəsərum do aw ? ");
INSERT INTO muy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ka fat ge seriya nani ti bay walani ya àgur haɗ Seba ni emicikaba akaba ndam ye e hini vu na, aməhi ana tay : “Lekʉlʉm ndam magudar zlam.” Aɗaba mam, bay gani nani ècikbiyu kwa kè sliri ga məlaŋ ga mara məbi slimi ana pakama ga Salomoŋ bay məsər zlam ni. Ay ahalay ti mis àbu àtama Salomoŋ àna gəɗakana ti kəsərum do aw ? » ");
INSERT INTO muy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yezu àɗəm keti : « Tamal ti seteni àsləkiaba ana mis a ti, akoru a huɗ gili vu ka məlaŋ ya ti yam àbi ni, aɗəbay məlaŋ manjəhaɗani. Ay àŋgət məlaŋ manjəhaɗani do ; ");
INSERT INTO muy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nahkay ti aɗəm : “Ŋgulum nəŋguvoru a arəŋ goro ni vu zlam goro.” Àra ènjia ti àhuriyu àdi ahàr ana arəŋ ni məsləɗabana, maslamalabana lala. ");
INSERT INTO muy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Eslini naŋ nakəŋ asləka akoru azalakivabiyu seteni ndahaŋ adəskəla, nday nani ɗek tə̀tam naŋ àna cuɗay. Mək nday nakəŋ ɗek tara təhuriyu, tanjəhaɗ a arəŋ ni bu. Nahkay maslaŋa nani ti manjəhaɗ gayaŋ ni egi ŋgulum gayaŋ ya ahaslani ni keti. Mis magədavani ye e hini vu ni day atəgri ana tay ti nahkay. » ");
INSERT INTO muy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ka ya ti Yezu naŋ àbu azlapi ana mis dal-dalani ni ti məŋ ga Yezu akaba bəza ga məŋ ga Yezu tàra, nday tə̀bu e mite bu tawayay təhi ma.  ");
INSERT INTO muy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nahkay maslaŋa nahaŋ àhi : « Ata muk akaba bəza ga muk tə̀bu e mite bu, tihindi kur. » ");
INSERT INTO muy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yezu àhəŋgrifəŋ, àhi ahkado : « Məŋ goro ti way ? Bəza ga mmawa ti ndamam ? » ");
INSERT INTO muy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mək Yezu nakəŋ èɗʉki ahar ka ndam maɗəbay naŋ ni, àɗəm : « Məŋ goro akaba bəza ga mmawa nahəma, nday hini. ");
INSERT INTO muy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aɗaba maslaŋa ya ti agray ere ye ti Bəŋ goro naŋ a huɗ melefit bu awayay ni ti, naŋ nani ti wur ga mmawa zalani, bi walani, mmawa daya. » ");
INSERT INTO muy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ka fat nani Yezu àhəraya a ahay ba, òru ànjəhaɗ kà gəvay ga dəluv ni. ");
INSERT INTO muy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Eslini mis kay tòru kà gəvay gayaŋ. Nahkay naŋ nakəŋ káy àcəliyu a *slalah ga yam vu ànjəhaɗviyu digʉs. Mis dal-dalani ni ti ni nday ka dəŋ-dəŋ. ");
INSERT INTO muy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yezu nakəŋ àhi ma ana tay gərgəri kay àna ma *gozogul, àɗəm : « Maslaŋa nahaŋ àhəraya òru e gili ga mabəhaɗ hilfi ga zlam. ");
INSERT INTO muy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Naŋ àbu abəhaɗoru hilfi ga zlam ni ti ɓal gani àdəgoru e divi bu. Nahkay eɗiɗiŋ tàra tə̀ndaba. ");
INSERT INTO muy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ɓal gani keti àdəgoru ka pəlaɗ ya haɗ àhəcaki ni. Àfətaya hʉya, aɗaba haɗ àki ka pəlaɗ ni kay bi. ");
INSERT INTO muy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Àra àfətaya, fat àra àvəɗia ti èhiriŋaba aɗaba àbiyu sliri a haɗ vu kay ndo. ");
INSERT INTO muy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ɓal gani keti àdəgiyu a adak vu. Ka ya ti àfətaya tə̀bu təɗəkkabu nahəma, adak ni tèŋgecekabá. ");
INSERT INTO muy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ɓal gani keti àdəgoru ka haɗ sulumani. Àra àfətaya ti àbi bəza. Bəlaŋ gani àbi bəza diŋ, bəlaŋ gani keti bəza kru kru muku, nahaŋ ni ti ni kru kru mahkər. » ");
INSERT INTO muy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yezu àɗəm keti : « Maslaŋa ya ti slimi àfəŋ ni ti mîci lala. » ");
INSERT INTO muy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ndam maɗəbay Yezu ni tàhəɗakfəŋbiyu kà Yezu, tə̀hi ahkado : « Kəhi ma ana tay àna ma *gozogul kwa ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Lekʉlʉm ti Melefit àɗəfikiaba zlam maŋgahani àki ka Məgur gayaŋ na ana kʉli a, ti kə̂sərum. Ay nday ti àɗəfikiaba ana tay a vay-vay ndo. ");
INSERT INTO muy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aɗaba maslaŋa ya ti zlam gayaŋ àbu ni ti atəvikivu, amələbu àna zlam dal-dal àsaɓay. Ay maslaŋa ya ti zlam gayaŋ àbi nahəma, ku ere ye ti àfəŋ ni day atəzafəŋa. ");
INSERT INTO muy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nəhi ma ana tay àna ma gozogul nahkay ti aɗaba ku tamal tamənjaləŋ ka zlam lala nəŋgu ni tìpi do ; ku tamal təbi slimi ana pakama lala nəŋgu ni tìci do. ");
INSERT INTO muy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","« Gatay ya tə̀bu tagray nahkay ni ti pakama ge Izayi bay mahəŋgaray *pakama ge Melefit ya àɗəmbiyu ni àgravu. Àɗəm : “Ku tamal kəbumi slimi ana zlam lala nəŋgu ni ekicʉm do. Ku tamal kəmənjumləŋ ana zlam lala nəŋgu ni ekipʉm do. ");
INSERT INTO muy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aɗaba mis nday ndani ti ma ya nəhi ana tay ni ètiri ana tay do simiteni, aɗaba tìrika slimi gatay a, tàbakabá eri gatay a. Tàgray nahkay ti, ti tîci zlam ba, tìpi divi ba, tə̀sər zlam ba ; tawayay ti tàmbatkaba majalay ahàr gatay a ba daya. Tamal tàmbatkaba ti akal nàhəŋga tay a.” ");
INSERT INTO muy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","« Ay lekʉlʉm ti mərumvu aɗaba eri àfəŋ kè kʉli, kipʉm divi ; slimi day tə̀fəŋ kè kʉli, kicʉm zlam. ");
INSERT INTO muy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nəhi ana kʉli nahəma, ndam mahəŋgaray *pakama ge Melefit kay akaba ndam jireni kay ya ahaslani ni tàwaya mipia ere ye ti kipʉm na, ay ti tìpi ndo. Tàwaya micia ere ye ti kicʉm na, ay ti tìci ndo. » ");
INSERT INTO muy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","« Ay lekʉlʉm ti bumi slimi ana ma ya ti ma *gozogul àki ka bay mabəhaɗ hilfi ga zlam ni awayay aɗəmki ni. ");
INSERT INTO muy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tamal mis təbi slimi ana pakama ya təɗəmki ka *Məgur ge Melefit ni, tìci do ni ti, nday akaɗa divi ya hilfi ga zlam àdəgaki ni. *Seteni ara ahəliaba pakama ya ti tə̀gəskabu na ana tay a. ");
INSERT INTO muy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mis ndahaŋ day tə̀bu, nday akaɗa pəlaɗ ya hilfi ga zlam àdəgaki ni : tìcia pakama ge Melefit na ti təgəskabu àna məmərani hʉya. ");
INSERT INTO muy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ay pakama nani àhuriviyu ana tay a məɓəruv vu do, akaɗa ge sliri ya ti tòru a haɗ vu do ni ; təgəskabu ti ga hayaŋani. Tamal zlam zləzlaɗani àdia ahàr ana tay a, ahkay do ni mis təgri daliya ana tay azuhva pakama ge Melefit ni ti təmbrəŋ hʉya, tə̀gəskabu va do. ");
INSERT INTO muy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mis ndahaŋ tə̀bu, nday akaɗa hilfi ga zlam ya ti àdiyu a huɗ ga adak vu ni : tìcia pakama ge Melefit a ti təgəskabu. Ay majalay ahàr ga duniya ariva ana tay a, elimeni agosay tay ; zlam nday nani teŋgecekabu zlam akaɗa ga adak ni. Nahkay ti pakama ya ndam nday nani tìci ni àzaya araŋa do. ");
INSERT INTO muy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mis ndahaŋ ti ni tici pakama ge Melefit. Tìci ti təgəskabu. Nday akaɗa haɗ sulumani ya hilfi ga zlam àdəgaki ni, nahkay təbi bəza. Bəlaŋ gani abi bəza diŋ, bəlaŋ gani keti bəza kru kru muku, nahaŋ ni ti ni bəza kru kru mahkər ni. » ");
INSERT INTO muy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yezu nakəŋ àŋgəhaɗi ma *gozogul nahaŋ ana tay keti, àɗəm : « *Məgur ge Melefit ti tə̀zavu ata mis ya ti èzligi hay gayaŋ sulumani a vədaŋ gayaŋ bu ni. ");
INSERT INTO muy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ay məlavaɗ àra ègia, mis tìnjikaba ɗʉwir a ti zal ezir gayaŋ òru èzligikiviyu ayum mək àsləka zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka ya ti tàra tə̀fətaya, tə̀bu tabay ahàr nahəma, ayum ni day àsərvu. ");
INSERT INTO muy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ndam məgri tʉwi ana bay ga vədaŋ ni tàra tìpia ti tə̀rəkia ka bay ga vədaŋ na. Tə̀hi : “Bay geli, kìzligi a vədaŋ bu ni ti hay sulumani timey ! Ay ti ayum ni àhəraya ti eley ?” ");
INSERT INTO muy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Àhi ana tay : “Àgray ere nani ti zal ezir goro.” Eslini ndam məgri tʉwi ni tə̀hi : “Kawayay ti môru mîjeba waw ?” ");
INSERT INTO muy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naŋ nakəŋ àhi ana tay : “Aha ! Kìjʉmaba ba, aɗaba tamal kijʉmaba ti bi ekijʉmaba akaba hay na. ");
INSERT INTO muy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Brəŋum tay nahkay hayaŋ. Eminjʉa ka sarta ga mabazana day kwa ti anəhi ana ndam mabazani ni ahkado : Bazumaba ayum na, wəlumaba ti kə̂jumiaba aku a, hay ni ti ni kə̂həlumubiya kə̂bumiyu a guvur goro vu.” » ");
INSERT INTO muy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yezu àhi ma *gozogul nahaŋ ana tay keti, àɗəm : « *Məgur ge Melefit ti àzavu akaba wur ge hilfi ga zlam gʉziteni. Mis àzay, èzligi a vədaŋ gayaŋ bu. ");
INSERT INTO muy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Hilfi gani ti gʉziteni e kiɗiŋ ga bəza ge hilfi ndahaŋ ya a duniya bu ni ɗek. Ay ka ya ti àfətaya ni ti àɗəka àtam zlam ndahaŋ ya e dini bu ni ɗek, ègi məŋgəhaf. Aɓal ahar, eɗiɗiŋ tara tagraviyu lala gatay a huɗ gani vu. » ");
INSERT INTO muy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yezu nakəŋ àhi ma gozogul nahaŋ ana tay keti, àɗəm : « *Məgur ge Melefit ti àzavu akaba *miwisiŋ. Wal azay, abəkivu ka humbu kay, akuɗatay àna naŋ. Nahkay miwisiŋ ni ewisiŋaba humbu na ɗek. » ");
INSERT INTO muy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yezu àhi ma ana mis dal-dalani ni ti ɗek ana ma *gozogul. Ma gayaŋ ya àhi ana tay àna ma *gozogul do ni ti àbi. ");
INSERT INTO muy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Àhi ana tay nahkay ti, ti ma ga bay mahəŋgaray pakama ge Melefit ni mâgravu. Ma gani nihi : « Anəhi ma ana tay ti àna ma *gozogul ; ma goro ya anəhi ana tay ni ti ma maŋgahani kwa ka mənjəki ga məlaŋ. » ");
INSERT INTO muy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Eslini Yezu àmbərbu mis dal-dalani ni, òru a magam. Eslini ti ndam maɗəbay naŋ ni tàhəɗakfəŋiyu tə̀hi : « Ɗəfiaba ma *gozogul ya kə̀ɗəmki ka ayum ya àfət a vədaŋ bu na ana leli a zla aw. » ");
INSERT INTO muy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Àhi ana tay ahkado : « Maslaŋa ya ti ezligi hilfi sulumani ni ti nu *Wur ge Mis. ");
INSERT INTO muy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Vədaŋ ni ti duniya ; hilfi sulumani ni ti ni ndam ya nday a *Məgur ge Melefit bu ni. Ayum ni ti ndam ya taɗəbay *Seteni ni, ");
INSERT INTO muy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","zal ezir ya ezligi ayum ni ti Seteni. Sarta ga mabaz zlam ni ti mandav ga duniya. Ndam ya tabaz zlam ni ti ni *məslər ge Melefit. ");
INSERT INTO muy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yaw akaɗa ya tijeba ayum a, təjiaba aku a ni ti, ka mandav ga duniya day atagray ti nahkay : ");
INSERT INTO muy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","nu Wur ge Mis anəslərbiyu məslər goro, atəhəlaba ndam magudar zlam na ɗek akaba ndam ya ti tijiŋkia mis ke divi a na ɗek a Məgur goro ba. ");
INSERT INTO muy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mək atəbiyu tay a *dəluv ga aku vu. Eslini ti etitʉwi, atahəpəɗkabu aslər aɗaba daliya ya atəcakay ni. ");
INSERT INTO muy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ay ti ndam jireni ni atəslaɗay akaɗa ga fat ni a Məgur ga Bəŋ gatay bu. Maslaŋa ya ti slimi àfəŋ nahəma, mîci lala. » ");
INSERT INTO muy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","« *Məgur ge Melefit ti àzavu akaba elimeni maŋgahani a vədaŋ bu ni. Maslaŋa nahaŋ àbu, òru àdi ahàr, àzaba àmbati məlaŋ àŋgahkivu, àmərva dal-dal. Nahkay àsləka àsəkumoru zlam gayaŋ ɗek mək àsəkum vədaŋ nani. ");
INSERT INTO muy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","« Nahkay day Məgur ge Melefit ni àzavu ata bay ga cakala ya ti aɗəbay ebirsli sulumani ni. ");
INSERT INTO muy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Òru àdia ahàr ana sulumana bəlaŋ àtam ndahaŋ ni ti òru àsəkumoru zlam gayaŋ ɗek mək àsəkum ebirsli nani. » ");
INSERT INTO muy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","« Nahkay keti, *Məgur ge Melefit ti àzavu ata zəva ya ti tə̀təliya a dəluv va, təgəsaya kilif gərgərana kay àna naŋ a ni. ");
INSERT INTO muy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tamal kilif ni tə̀hurviya a zəva ni va, zəva ni àrəha ti tagəjahaya ka dəŋ-dəŋ a, tanjəhaɗ, tapalakaba kilif na. Kilif sulumani ni təbiyu a hətək vu, ya ti àɓəlay do ni ti ni, taboru tay. ");
INSERT INTO muy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka mandav ga duniya day amagravu nahkay. Məslər ge Melefit atara təhəlkiba ndam cuɗay àkiba ka ndam jirena ");
INSERT INTO muy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ga məbiyu tay a *dəluv ga aku vu. Eslini etitʉwi, atahəpəɗkabu aslər aɗaba daliya ya atəcakay ni. » ");
INSERT INTO muy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yezu nakəŋ àhi ana tay : « Kìcʉma ma goro ya nə̀hi ana kʉli na ɗek aw ? » Nday nakəŋ tə̀həŋgrifəŋ tə̀hi : « Iy, mìcia. » ");
INSERT INTO muy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mək naŋ nakəŋ àhi ana tay ahkado : « Nahkay ti bay *məsər Wakita ge Melefit lu, tamal àsəra zlam a àki ka Məgur ge Melefit a lala ti tə̀zavu ata bay ahay ya ti aŋgazlaya zlam mʉwena akaba midigwena e elimeni gayaŋ ya àŋgah ni ba ni. » ");
INSERT INTO muy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yezu àra èndeveriŋa ma *gozogul nday nana ti àsləka eslina, ");
INSERT INTO muy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","òru a kəsa gayaŋ vu ka məlaŋ ya àɗək ni. Òru ènjʉa ti àcahi ma ge Melefit ana mis a ahay ga *mahəŋgalavù Melefit ye eslini ni bu. Tàra tìcia ma gayaŋ ya àcahi ana tay na ti àgria ejep ana tay a dal-dal. Tə̀ɗəm ahkado : « Məsər zlam hini ti àcahay eley ? Àŋgət njəɗa ga magray ere ye ti ɗay-ɗay mis tìpi ndo ni ti eley ? ");
INSERT INTO muy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naŋ wur ga bay madar zlam ni do waw ? Məŋani ti Mari do waw ? Bəza ga məŋani ata Zek, Zʉzef, Zʉd, Simu do waw ? ");
INSERT INTO muy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Bəza ga məŋani walani nday tə̀bu akaba leli ahalay ni do waw ? Àŋgət njəɗa ga magray zlam nani ɗek ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Azuhva nani ti mis nday nani tàwayay məfəki ahàr ka Yezu ndo. Ay Yezu nakəŋ àhi ana tay : « Bay məhəŋgri *pakama ge Melefit ana mis ni ti, tàwayay naŋ a kəsa gayaŋ bu do. Ata bəŋani akaba ndam ga huɗ ahay gayaŋ day tàwayay naŋ do, si a kəsa ndahaŋ bu kwa ti mis tawayay naŋ. » ");
INSERT INTO muy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eslini Yezu àgray zlam ndahaŋ ya ti mis tìpi ɗay-ɗay ndo ni kay ndo hʉya aɗaba tàwayay məfəki ahàr do. ");
INSERT INTO muy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka sarta gani nani ti mis tə̀bu təzlapaki ka Yezu. Tə̀bu təzlapaki nahəma, *Erot bay Gelili ni ècia pakama gatay ya ti tə̀ɗəm na. ");
INSERT INTO muy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Naŋ nakəŋ àhi ana ndam ya tə̀gri tʉwi ni ahkado : « Naŋ nani ti Zeŋ bay məbaray mis ni, àməta mək àŋgaba e kisim ba. Agray zlam magray ejep tata ti aɗaba àŋgaba e kisim ba palam. » ");
INSERT INTO muy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Bay Erot àɗəm nahkay ti azuhva zlam ya àgravu ni. Zlam gani nihi : Erot àzafəŋa Erodiyat wal ge Filip a ; Filip ti wur ga məŋ ga Erot. Àra àza wal na ti Zeŋ bay məbaray mis ni àhi ahkado : « Kàzay Erodiyat ti àwəsl. » Zeŋ àra àhia ma nahkay ti bay Erot nakəŋ àhi ana ndam gayaŋ tə̂gəs naŋ, tə̂wəl, tə̂fiyu a daŋgay vu, mək tàgray nahkay. ");
INSERT INTO muy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erot àwaya makaɗa Zeŋ a, ay ti aŋgwaz àwərfəŋa naŋ kà ndam *Zʉde a, aɗaba nday ɗek tə̀ɗəm Zeŋ ti naŋ bay mahəŋgaray *pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ay a vaɗ nahaŋ, Erot àgra wuməri ge miwivu gayaŋ a, àzalakabá mis a. Eslini wur ga Erodiyat dahalayani àhurkiviyu ka tay, mək àhəɓay kè meleher gatay. Àra àhəɓa nahkay ti həɓay gayaŋ ni ègia eri ana bay Erot a dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nahkay Erot nakəŋ àmbaɗi ana wur ni dək, àhi ahkado : « Ere ye ti kihindifua ni ɗek nəvuk. » ");
INSERT INTO muy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wur ni məŋani àra àbikia ma ti àhi ana Erot ahkado : « Nawayay ti kə̂vu ahàr ge Zeŋ bay məbaray mis ni ahalay, tə̂fukibiya ka paranti a ! » ");
INSERT INTO muy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Bay ni àra ècia pakama ga wur na ti àhəlia ahàr a. Aɗaba àmbaɗia ana wur na kè meleher ge mis na ti èkeli ere ye èhindi ni koksah. Nahkay àhi ana ndam gayaŋ tə̂gri ana wur ni akaɗa ya àwayay ni, ");
INSERT INTO muy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","àsləroru mis a ahay ga daŋgay ni vu ge mekelkibiya ahàr ke Zeŋ a. ");
INSERT INTO muy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tàra tə̀zibiya ahàr ge Zeŋ nakəŋ a ana wur dahalay na ka paranti a ti naŋ nakəŋ àzikaboru ana məŋani. ");
INSERT INTO muy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ndam maɗəbay Zeŋ ni tàra tìcia ti tòru tàzay kisim gani, tìli. Tàra tìlia ti tòru tə̀hi ma gani ana Yezu. ");
INSERT INTO muy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yezu àra ècia tàkaɗa Zeŋ a ti àcəliyu a *slalah ga yam vu, àsləka eslina, òru gwar ka məlaŋ nahaŋ. Məlaŋ gani nani ti driŋ a huɗ gili bu. Ay mis dal-dalani ni tàra tìcifiŋa daɗay a ti tàɗəboru naŋ àna asak. ");
INSERT INTO muy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yezu àra àhəraya a slalah ga yam ni ba, èpia mis dal-dalani na ti tə̀sia cicihi a dal-dal. Nahkay àhəŋgaraba ndam ya tèɓesey do na e kiɗiŋ gatay ba. ");
INSERT INTO muy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Məlakarawa àra ègia ti ndam *maɗəbay Yezu ni tə̀rəkia, tə̀hi ahkado : « Leli nihi ti a huɗ gili bu, sarta day àbi va bi. Hi ana mis ni tâsləka, tôru a kəsa gərgərani ni vu tâɗəboru zlam məzumani. » ");
INSERT INTO muy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Eslini Yezu àhəŋgrifəŋ ana tay, àɗəm : « Tâsləka day ti kamam ? Lekʉlʉm lekʉlʉmeni vumi zlam məzumani ana tay. » ");
INSERT INTO muy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Araŋa àfəŋ kè leli ahalay bi ; si *dipeŋ zlam, tàkivu kilif cʉ ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Naŋ nakəŋ àhi ana tay : « Həlumubiya ahalay a. » ");
INSERT INTO muy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eslini àhi ana mis dal-dalani ni tânjəhaɗa a ga haɗ ke kʉzir a, mək naŋ nakəŋ àhəl dipeŋ zlamani ni tàkivu kilif cʉeni ni, àmənjoru e melefit vu, àgri sʉsi ana Melefit. Àra àgria sʉsi a ti èsekaba dipeŋ na, mək àbi ana ndam maɗəbay naŋ ni ge midieni ana mis dal-dalani ni. ");
INSERT INTO muy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mis nakəŋ ɗek tə̀zum tə̀zum, tə̀rəhkaba. Kələŋ gani tə̀cakalakabu məgəjəni gani, tə̀rəhvù hətək kru mahar cʉ àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mis zawalani ya ti tə̀zum zlam eslini ni ti agray dəbu zlam ; wál akaba bəza ti tàcalkivu tay ndo. ");
INSERT INTO muy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ka gani nani ti Yezu nakəŋ àhi ana ndam maɗəbay naŋ ni tə̂cəliyu a *slalah ga yam vu, tôru kama gayaŋ hayaŋ ke ledi ga dəluv ni, day kwa ti naŋ naŋani aməhi ana mis ni ti têdevu, tâsləka. ");
INSERT INTO muy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tàra tèdeva akaba mis na ti Yezu nakəŋ àcəloru a həma vu driŋ driŋ akaba mis ga mahəŋgalay Melefit. Məlakarawa àra ègikia, naŋ ka ahàr gayaŋ eslini. ");
INSERT INTO muy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndam maɗəbay naŋ ni ti ni tàsləka àna slalah ga yam gatay na, tìgia driŋ driŋ akaba dəŋ-dəŋ a. Aməɗ naŋ àbu adaɗay slalah ga yam gatay ni agrioru daliya ana tay, ahəŋgarbiyu tay kələŋ. ");
INSERT INTO muy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dʉ gwendeli-gwendeli ti Yezu nakəŋ àrəkioru ka tay, asawaɗakioru ka ahàr ga yam ni njuwaŋ-njuwaŋ. ");
INSERT INTO muy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ndam maɗəbay naŋ ni tàra tìpia naŋ a, naŋ àbu asawaɗaki ka ahàr ga yam nahkay ti ɓəruv àtikaba ana tay a, tə̀ɗəm : « Maslaŋa àmbavakiva ke leli a ! » Nahkay nday nakəŋ tàgra aŋgwaz a, tə̀zlah. ");
INSERT INTO muy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ay Yezu nakəŋ àhi ma ana tay hʉya, àɗəm : « Zum njəɗa, nu timey. Aŋgwaz àwər kʉli ba. » ");
INSERT INTO muy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eslini Piyer àhi : « Bay goro, tamal nak eɗeɗiŋ ti vu divi nə̂sawaɗkioru ka ahàr ga yam ni bilegeni ti nôru afa gayak. » ");
INSERT INTO muy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yezu àhi : « Ra. » Nahkay naŋ nakəŋ àhəraya a slalah ga yam ni ba, àsawaɗakioru ka ahàr ga yam ni àrəkioru ka Yezu nakəŋ. ");
INSERT INTO muy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ay àra èpia aməɗ na àbu akəzlay dal-dal ti àgra aŋgwaz a ; nahkay yam ni awayay anday naŋ. Naŋ nakəŋ àzlah, àɗəm : « Bay goro, həŋgay nu ti ! » ");
INSERT INTO muy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eslini Yezu àtəloru ahar hʉya, àgəs naŋ, mək àhi : « Məfəku ahàr gayak àhəca ; kajalay ahàr cʉ cʉ ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nday nakəŋ tàra tə̀cəliya a slalah ga yam ni va ti aməɗ ni day àmbrəŋ makəzlani hʉya. ");
INSERT INTO muy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eslini nday ya tə̀vu a slalah ga yam bu ni ɗek tàbəhaɗi mirdim ana Yezu nakəŋ, tə̀hi : « Nak ti Wur ge Melefit eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ka ya ti tàsləka, tə̀həra dəluv na àndava ni ti nday ka dəŋ-dəŋ ka haɗ Zenizaret. ");
INSERT INTO muy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yezu akaba ndam maɗəbay naŋ ni tàra tàhəraya a *slalah ga yam ni ba ni ti mis ga haɗ nani tə̀səra Yezu a hʉya. Tàra tə̀səra naŋ a ti tòru tə̀hi ma gani ana mis ga kəsa ga haɗ nani, nahkay tə̀həlibiyu ndam ya tèɓesey do ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tə̀gri kam-kam ti mis nday nani ya tèɓesey do ni tînjifiŋ kà ma ga azana gayaŋ ni ciliŋ. Nday ya ti tìnjifiŋa ni ɗek tàŋgaba. ");
INSERT INTO muy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ka sarta gani nani ndam *Feriziyeŋ ndahaŋ akaba ndam ndahaŋ ya *tə̀səra Wakita ge Melefit a ni tàsləkabiya a Zerʉzalem a, tə̀rəkia ka Yezu a, tə̀hi ahkado : ");
INSERT INTO muy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","« Ndam maɗəbay kur ni tə̀gəskabu magray zlam akaɗa ga ata bəŋ geli ya ahaslani tə̀ɗəfiki ana leli ni do ni ti kamam ? Tə̀zum zlam day tàbarakaba ahar àna divi gana do ni. » ");
INSERT INTO muy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Lekʉlʉm day kagudarum *Divi ge Melefit àna manjəhaɗ ga ndam gekʉli ya ahaslani ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Melefit àɗəm ahkado : “Ŋgwioru a haɗ ana ata buk ata muk.” Àɗəm keti : “Bay ya ti endivi bəŋani ahkay do ni məŋani nahəma, tâkaɗa naŋ a.” ");
INSERT INTO muy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ay lekʉlʉm zla ti kəɗəmum ahkado : “Maslaŋa nahaŋ esliki məhiani ana bəŋani ahkay do ni ana məŋani : Ere ye ti akal nu nəjənaki kur àna naŋ ni, sədaga ge Melefit.” ");
INSERT INTO muy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Maslaŋa nani àɗəma ma nahkay nahəma, kəɗəmum tamal àjənaki ata bəŋani ata məŋani va do ni ti àgray araŋa do. Lekʉlʉm kəgrum nahkay ti, kə̀mbrəŋuma pakama ge Melefit nana pəsak. Kə̀mbrəŋuma ti kəfumviyu pakama gekʉli ya kacahum ni a məlaŋ gani vu huk. ");
INSERT INTO muy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Lekʉlʉm kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni, ay ti lekʉlʉm ndam jireni do ! Melefit àɗəma ma sulumana a wakita ga bay mahəŋgaray *pakama gayaŋ Izayi ni ba. Pakama gayaŋ ya ti àɗəm ni, àɗəmki ti ke kʉli. ");
INSERT INTO muy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Àɗəm ahkado : “Mis hini tazləbay nu àna ma ciliŋ, tə̀jalaku ahàr do simiteni. ");
INSERT INTO muy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tazləbay nu ti masakani, aɗaba zlam gatay ya təcahay ni ti ka mawayay ge mis ciliŋ, do ni ti ka mawayay goro do.”  » ");
INSERT INTO muy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yezu àzalakabu mis kayani ni, àhi ana tay : « Lekʉlʉm ɗek bumi slimi ana pakama goro ya nəɗəm ni, ti kîcʉm lala. ");
INSERT INTO muy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ere ye ti a dala bu, mis azum àna ma gayaŋ, agray naŋ “*njəlatani do” ni ti àbi. Si ere ye ti maslaŋa gani aɗəm àna ma gayaŋ ni day kwa ti agray naŋ “njəlatani do.” » ");
INSERT INTO muy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Eslini ndam maɗəbay naŋ ni tə̀rəkia, tə̀hi ahkado : « Ma gayak ya kə̀ɗəm ni àzumia ɓəruv ana ndam *Feriziyeŋ na ti kə̀sərkia waw ? » ");
INSERT INTO muy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm ahkado : « Məŋgəhaf ya ti Baba naŋ ya e melefit bu àjav ndo ni lu ataraɗaba. ");
INSERT INTO muy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nə̀ɗəm nahəma, brəŋum tay ; nday ti ndam wuluf ya tədafəŋa ahar kà ndam wuluf ndahaŋ a ni. Tamal zal wuluf adafəŋa ahar kà zal wuluf nahaŋ a ti nday cecʉeni atədəgiyu e eviɗ vu. » ");
INSERT INTO muy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eslini Piyer àhəŋgarfəŋ, àhi : « Ɗəfiaba ma *gozogul ya kə̀ɗəm ni ana leli a zla aw. » ");
INSERT INTO muy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yezu àhi ana tay ahkado : « Lekʉlʉm day kekileŋa kə̀sərum zlam do waw ? ");
INSERT INTO muy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aɗaba ere ye ti mis afiyu a ma vu ni ɗek ti ahuriyu a huɗ vu ciliŋ, mək atəhiyu azay gani e dʉgzey vu ti kə̀sərum do waw ? ");
INSERT INTO muy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ay ere ye ti mis azlapay ni ahəraya ti a məɓəruv gayaŋ ba, ma gani nani day kwa ti agudar naŋ, agray naŋ “njəlatani do.” ");
INSERT INTO muy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aɗaba zlam magudarani ɗek ahəraya ti a məɓəruv ge mis ba. Nahkay ti ajalaki ahàr ka zlam magudarani gərgəri ɗek : ka makaɗ ahàr, ka magray hala, ka magray mesʉwehvu, ke migi akal, ka masəkaɗ malfaɗa akaba ka məsivani ana mis. ");
INSERT INTO muy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ere ye ti agray ti mis egi “njəlatani do” ni ti zlam nday nani. Ay ti məzum zlam mənjəɗ məbaray ahar akaɗa ge divi ga ata bəŋ gekʉli ni ti àgray ti mis egi “njəlatani do” do. » ");
INSERT INTO muy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yezu àsləkaba eslina, òru ka haɗ ga kəsa Tir akaba ga kəsa Sidoŋ. ");
INSERT INTO muy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wal Kanaŋ nahaŋ naŋ àbu eslini. Wal ni àra èpia Yezu a ti àrəkia àna zlahay a, àɗəm : « Bay goro, *Wur ge Devit, nə̂suk cicihi ti ! Wur goro dahalayani àbiyu èɓesey do, seteni àbu agri daliya dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ay ti Yezu àhəlkaba ma ndo. Eslini ndam maɗəbay naŋ ni tə̀hi ana Yezu ahkado : « Garay wal hini, aɗaba naŋ àbu azlahləŋbiyu kè leli, àmbrəŋ do ni. » ");
INSERT INTO muy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yezu nakəŋ àhi ana tay : « Tə̀slərbiyu nu ahalay ndo. Tə̀sləribiyu nu ti ana ndam *Izireyel ciliŋ, aɗaba nday akaɗa təmbəmbak ya ti tìjia ni. » ");
INSERT INTO muy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ay ti wal ni àra àbəhaɗi mirdim grik ana Yezu meleher nɗiɓ ana haɗ, àhi : « Bay goro, jənaki nu ti ! » ");
INSERT INTO muy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eslini Yezu àhəŋgrifəŋ ana wal nakəŋ, àhi ahkado : « Təzafəŋa zlam məzumani ga bəza, tizligioru ana kərá ti àɓəlay do. » ");
INSERT INTO muy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mək wal nakəŋ àɗəm : « Nahkay, bay goro. Ay ti pis-pis ga zlam məzumani ge mis ya tadəgoru a huɗ ga məlaŋ məzumki zlam vu ni, ku kərá gatay day tapalaba təzum timey. » ");
INSERT INTO muy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eslini Yezu àhi ana wal nakəŋ : « Wal ni, kə̀bu kəfəku ahàr lala ; ere ye ti kihindi ni mâgravu akaɗa gayak ya kawayay ni. » Ka sarta gani nani wur gayaŋ ni àŋgaba hʉya. ");
INSERT INTO muy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yezu àsləka eslina, òru kà gəvay ga dəluv Gelili. Òru ènjʉa ti àcəloru a həma vu. Àra àcəloya ti ànjəhaɗ digʉs. ");
INSERT INTO muy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Eslini mis dal-dal tə̀rəkia, tə̀həlibiyu ndam jʉgwer, ndam wuluf, ndam dəra, makwayá akaba ndam ga arməwər ndahaŋ gərgərani, tàbəhaɗ tay kà gəvay gayaŋ mək naŋ nakəŋ àhəŋgaraba tay a. ");
INSERT INTO muy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mis dal-dalani ni tàra tìpia ndam makwaya ya tə̀zlapay koksah ni tə̀bu təzlapay, ndam dəra tàŋgaba tìgia sənduɓ-sənduɓana, ndam jʉgwer təsawaɗay lala akaba ndam wuluf tə̀bu tipi divi nahəma, tə̀mərvá dal-dal, nahkay tazləbay Melefit ga ndam *Izireyel ni. ");
INSERT INTO muy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yezu àzalay ndam maɗəbay naŋ ni, àhi ana tay ahkado : « Mis nday hini təsu cicihi dal-dal, aɗaba vaɗ mahkər hi leli mə̀bu akaba tay, zlam məzumani day àfəŋ kà tay va bi. Ay ti nàwayay məmbrəŋ tay ti tasləka àna lʉwir a do. Tamal nəhi ana tay “Sləkuma” mənjəɗ məvi zlam məzumani ana tay nahəma, njəɗa amələfəŋ kà tay ka ahàr divi ga masləkana bi. » ");
INSERT INTO muy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ndam maɗəbay naŋ ni tə̀həŋgrifəŋ, tə̀hi ahkado : « Leli ɗek ahalay a huɗ gili hini bu ni ti məhəlibiyu *dipeŋ ana tay tərəh àna naŋ ɗek ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yezu nakəŋ àhi ana tay ahkado : « Dipeŋ àfəŋ kè kʉli ehimey ? » Tə̀həŋgrifəŋ, tə̀hi : « Dipeŋ àfəŋ kè leli adəskəla akaba kilif ciɓ-ciɓeni ɓal. » ");
INSERT INTO muy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eslini àhi ana mis dal-dalani ni tânjəhaɗa a ga haɗ a. ");
INSERT INTO muy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tàra tànjəhaɗa ti àhəl dipeŋ adəskəlani ni akaba kilif ni, àgri sʉsi ana Melefit. Àra àgria sʉsi a ti èsekaba, àvi ana ndam maɗəbay naŋ ni, ndam maɗəbay naŋ ni ti ni tìdi ana mis dal-dalani ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mis nakəŋ ɗek tə̀zum, tə̀rəha àna naŋ a. Tə̀cakalaviyu məgəjəni ga zlam məzumani ni a hətək vu, tə̀rəhvù hətək adəskəla àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mis ya tə̀zum zlam eslini ni agray mis dəbu faɗ, tàcalkivu wál akaba bəza ndo. ");
INSERT INTO muy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kələŋ gani Yezu nakəŋ àhi ana mis ni « Sləkuma, » mək tàsləka. Eslini Yezu nakəŋ àcəliyu a *slalah ga yam vu àsləka, òru ka haɗ Magadaŋ. ");
INSERT INTO muy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ndam *Feriziyeŋ ndahaŋ akaba ndam *Sedʉseyeŋ ndahaŋ tə̀rəkia ka Yezu a, tawayay tatəkar naŋ ti mâgudar zlam ; nahkay ti tə̀hi : « Griaya ere ye ti mìpi ɗay-ɗay ndo na ana leli a, ti mə̂sər ere ye ti kagray ni ti kagray àna njəɗa ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Məlakarawa, fat àbu adiyu, tamal kìpʉma huɗ melefit a ndize ti kəɗəmum : “Hajəŋ ti məlaŋ amanja njəlata.” ");
INSERT INTO muy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ge miledʉ tamal kìpʉma huɗ melefit a diliŋ-diliŋ ti kəɗəmum : “Kani ti avər ara atəɗ.” Nahkay kə̀səruma ere ye ti agravu na àna zlam ya kipʉm a huɗ melefit bu na ti, kə̀sərum zlam ya ti agravu ka sarta hini do ni ti ahəmamam ! ");
INSERT INTO muy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ndam ye e hini vu ni ti ndam magudar zlam, tə̀fəki ahàr ke Melefit do, tawayay tə̂griaya ere ye ti mis tìpi ɗay-ɗay ndo na ana tay a. Ay ere ye ti tihindi ni ti Melefit aməgri ana tay do simiteni. Ere ye ti Melefit aməɗəfiki ana tay ni ti ere ye ti àɗafaki àna Zonas ni ciliŋ. » Eslini naŋ nakəŋ àsləka, àmbərbu tay. ");
INSERT INTO muy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yezu akaba ndam maɗəbay naŋ ni tə̀bu takoru tatuwaɗ dəluv ni ; nday tə̀bu takoru ti ndam maɗəbay naŋ ni tə̀həl *dipeŋ ndo, àgəjazlkia ahàr ka tay a. ");
INSERT INTO muy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eslini ti Yezu àhi ana tay : « Bumvu slimi ana *miwisiŋ ga ndam *Feriziyeŋ ni akaba ga ndam *Sedʉseyeŋ ni. » ");
INSERT INTO muy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nahkay ndam maɗəbay naŋ ni tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm : « Àɗəm nahkay ti aɗaba mə̀həlbiyu dipeŋ ndo palam. » ");
INSERT INTO muy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yezu nakəŋ àra ècia pakama gatay na ti àhi ana tay : « Məfəku ahàr gekʉli ti àhəca ; kazlapum kəɗəmum kə̀həlumbiyu dipeŋ ndo ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kìcʉm ma goro do, kə̀sərum do kekileŋa waw ? Goro ya ti nìdi dipeŋ zlamani ana mis dəbu zlamani ni, akaba məgəjəni gani ya kə̀həlumaba hətək mərəhvani ehimeya ni ti kəsərumki va do waw ? ");
INSERT INTO muy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Goro ya ti nìdi dipeŋ adəskəlani ana mis dəbu faɗani ni, akaba məgəjəni gani ya kə̀həlumaba hətək mərəhvani ehimeya ni ti kəsərumki va do waw ? ");
INSERT INTO muy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ŋgay nu nàcalfəŋ ti ke dipeŋ dipeŋani do ni ti kə̀sərum do ni ti kamam ? Nu ti nəhi ana kʉli ti bumvu slimi àna miwisiŋ ga ndam Feriziyeŋ ni akaba ga ndam Sedʉseyeŋ ni. » ");
INSERT INTO muy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nahkay zla ti ndam maɗəbay naŋ ni tàra tə̀səra Yezu àhi ana tay « Bumvu slimi àna miwisiŋ » ti, àzlapiki ana tay ti ke miwisiŋ ya ti tiwisiŋ dipeŋ àna naŋ ni do ; àzlapiki ana tay ti ka zlam ga ndam Feriziyeŋ akaba ga ndam Sedʉseyeŋ ya təcahi ana mis ni. ");
INSERT INTO muy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","A vaɗ nahaŋ, Yezu akaba ndam maɗəbay naŋ ni tòru ka haɗ Sezare ge Filip. Eslini Yezu èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Mis ti tə̀ɗəm nu *Wur ge Mis ti nu way ? » ");
INSERT INTO muy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tə̀həŋgrifəŋ, tə̀hi ahkado : « Tə̀ɗəm nak Zeŋ bay məbaray mis ni, mis ndahaŋ tə̀ɗəm nak Eli, mis ndahaŋ ti ni tə̀ɗəm nak Zeremi ahkay do ni nak biliŋ ga ndam ya tàhəŋgaray pakama ge Melefit ahaslani ni. » ");
INSERT INTO muy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eslini naŋ nakəŋ àhi ana tay ahkado : « Lekʉlʉm ti kəɗəmum nu ti nu way ? » ");
INSERT INTO muy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simu Piyer àhəŋgrifəŋ, àhi ahkado : « Nak *Krist *Bay gəɗakani ya Melefit àslərbiyu ni, nak Wur ge Melefit Bay ga sifa ni. » ");
INSERT INTO muy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yezu àhi : « Simu wur ge Zeŋ, mərvu aɗaba ma ge jiri hini ya kə̀ɗəm ni ti mis hihirikeni àhuk do. Àhukaya ma na ti Baba, naŋ ti naŋ a huɗ melefit bu. ");
INSERT INTO muy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nəhuk nahəma nak Piyer ; anazay kur ga məvi njəɗa ana ndam məfəku ahàr ni akaɗa ya tazay akur, tafəkaɗ asak ga ahay àna naŋ ni. Nahkay ti kisim tekeɗi aməgri araŋa ana tay do. ");
INSERT INTO muy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Anəvuk lekili ga mahay ga *Məgur ge Melefit : ere ye ti kə̀gəskabu ka haɗ ndo ni ti e melefit bu day atəgəskabu do ; ay ere ye ti kə̀gəskabá ka haɗ a ni ti e melefit bu day atəgəskabu. » ");
INSERT INTO muy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Eslini Yezu nakəŋ àləgi ana ndam maɗəbay naŋ ni, àhi ana tay ahkado : « Ŋgay nu Krist *Bay gəɗakani ya Melefit àslərbiyu ni ti kə̀humi ana maslaŋa ba simiteni. » ");
INSERT INTO muy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kwa ka sarta gani nani Yezu àzlapi ana ndam maɗəbay naŋ ni vay-vay, àhi ana tay ahkado : « Ahàr àɗəm nakoru a Zerʉzalem kwa. Ahàr àɗəm nə̂cakay daliya dal-dal. Nday gəɗákani ni, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni atawayay nu do, atakaɗ nu. Mək a huɗ ga vaɗ mahkərani bu anaŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piyer àra ècia ma gayaŋ na ti àzaba naŋ e kiɗiŋ gatay ba cak. Àləgi, àhi : « Bay goro, Melefit mâjəgay kur ti ere nani àgrakukvu ba ti ! » ");
INSERT INTO muy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ay Yezu àmbatkibiyu ma ke Piyer, àləgi bilegeni, àɗəm : « *Seteni, sləkafua, ru driŋ ! Nak ti kacafəŋa nu ga magray tʉwi goro a, aɗaba majalay ahàr gayak ti akaɗa ge Melefit ni do, kajalay ahàr ti akaɗa ge mis hihirikeni ni. » ");
INSERT INTO muy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Eslini Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Tamal mis awayay aɗəbay nu nahəma, ahàr àɗəm mə̂mbrəŋ ere ye ti awayay ni ; ku tamal təgri daliya, *tadarfəŋ naŋ kà təndal nəŋgu ni mîɓesey. Tamal mis awayay maɗəbay nu ti mâgray nahkay. ");
INSERT INTO muy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Maslaŋa ya ti àɗəm ajəgur sifa gayaŋ, awayay àmət ba ni ti emijiŋ. Maslaŋa ya ti emijiŋ sifa gayaŋ azuhva nu ti aməjəgur sawaŋ, aməmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamal mis àŋgəta elimeni ga duniya na ɗek mək èjiŋa sifa gayaŋ a ti elimeni gani aziaya mam ? Emijiŋa sifa gayaŋ na ti aməŋgət mam ga məmbani àna naŋ mam ? ");
INSERT INTO muy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aɗaba nu *Wur ge Mis anara àna njəɗa ga Baba akaba məslər goro a kay, anəvi zlam ana ku way way do akaɗa ge tʉwi gayaŋ ya ti àgray ni. ");
INSERT INTO muy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nəhi ana kʉli nahəma, e kiɗiŋ ge mis ya tə̀bu ahalay ni bu ni ti, wuɗaka ndahaŋ atəmət ti etipi nu Wur ge Mis anaŋga, anəhuriyu a bay goro vu. » ");
INSERT INTO muy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Vaɗ muku ka ahàr gani zla ti Yezu àzay Piyer, Zek akaba Zeŋ wur ga məŋ ge Zek ni, àhəloru tay ka ahàr ga həma zəbalani. Nday ka ahàr gatay akaba Yezu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tòru tìnjʉa ti vu ga Yezu ni àmbativa e eri va ana tay nahaŋ a. Eri gayaŋ ni àmbatvu, aslaɗay akaɗa fat, azana ka vu gayaŋ day tìgia bəɗ-bəɗ talla təslaɗay məlaŋ. ");
INSERT INTO muy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eslini tìpioru Eli nday ata Mʉwiz hʉya, nday tə̀bu təzlapay akaba Yezu. ");
INSERT INTO muy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyer àra èpia tay a ti àhi ana Yezu ahkado : « Bay goro, leli mə̀bu ahalay ti àɓəlay. Tamal kawayay ti nara nivicey ahay mahkər, bəlaŋ gayak, bəlaŋ ge Mʉwiz, bəlaŋ ti ni ge Eli. » ");
INSERT INTO muy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piyer naŋ àbu azlapay nahkay ti məguduŋguduŋ maslaɗani àhərkiaya ka tay a, àŋgah tay. Dəŋgu ga maslaŋa àhənday a məguduŋguduŋ ni bu, àɗəm : « Naŋ hini ti wur goro, nawayay naŋ dal-dal, nəmərvu àna naŋ dal-dal. Gəsumiki pakama gayaŋ ! » ");
INSERT INTO muy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ndam *maɗəbay Yezu ni tàra tìcia nahkay ti aŋgwaz àdəgakia ka tay a dal-dal, tabəhaɗ mirdim meleher ndiɓa ndiɓa ana haɗ. ");
INSERT INTO muy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ay Yezu nakəŋ àhəɗakfəŋiyu ka tay, ènjifiŋ ka tay mək àhi ana tay : « Cikʉmaba, kə̀grum aŋgwaz ba. » ");
INSERT INTO muy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nday nakəŋ tèheliŋ eri, tìpi maslaŋa nahaŋ ndo, si Yezu naŋ bəlaŋ ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nday tə̀bu təndaya ahàr a həma ni ba ni ti Yezu àhi ana tay : « Kə̀humi ere ye ti kìpʉm ni ana maslaŋa ba, si nu *Wur ge Mis anaŋgaya e kiɗiŋ ga ndam eviɗ ba kwa. » ");
INSERT INTO muy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ndam maɗəbay naŋ ni tə̀hi ahkado : « Ndam *məsər Wakita ge Melefit ni tə̀ɗəm wuɗaka *Krist *Bay gəɗakani ya amara ni eminjia ti, ahàr àɗəm Eli amara day ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yezu nakəŋ àhəŋgrifəŋ ana tay àɗəm ahkado : « Eɗeɗiŋ Eli ara, aslamalakabu zlam ɗek day. ");
INSERT INTO muy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ay nəhi ana kʉli nahəma, Eli ti àra àndava, ay ti mis tə̀sər naŋ ndo. Tə̀gria ere ye ti nday tàwayay na ɗek. Nu Wur ge Mis day anəcakay daliya, atəgru nahkay. » ");
INSERT INTO muy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eslini ndam maɗəbay naŋ ni tə̀səra àzlapaki ti ke Zeŋ bay məbaray mis ni. ");
INSERT INTO muy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ka ya ti tìnjikia ke mis dal-dalani na ti maslaŋa nahaŋ àhəɗakfəŋbiyu ka Yezu, àbəhaɗ mirdim ");
INSERT INTO muy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","àhi : « Bay goro, wur goro àbu seteni àniviyu agray daliya dal-dal ; a vaɗ ndahaŋ adiyu a aku vu ahkay do ni a yam vu. Mə̂suk cicihi ti kam-kam ! ");
INSERT INTO muy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nə̀zibiya naŋ ana ndam maɗəbay kur na ti tâgariaba, ay ti tìsliki ndo. » ");
INSERT INTO muy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eslini Yezu àɗəm : « Lekʉlʉm ye e hini vu ni ti kə̀fumki ahàr ke Melefit do, lekʉlʉm ndam magudar zlam ! Nu ananjəhaɗ kaŋgaya akaba kʉli aw ? Nu eneɓesi ana kʉli kaŋgaya waw ? » Mək àhi ana tay : « Zumubiya wur na ahalay a nimi. » ");
INSERT INTO muy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tàra tə̀zibiya wur na ti Yezu àzlacaki ke seteni ni, mək seteni ni àsləkiaba ana wur na. Nahkay wur ni ègia naŋ lala hʉya. ");
INSERT INTO muy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Eslini ndam *maɗəbay Yezu ni tàzalay Yezu ka ahàr gatay, tìhindi naŋ, tə̀hi : « Leli mìsliki magaray seteni nani ndo ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Kìslʉmki ndo ni ti aɗaba məfəki ahàr gekʉli ke Melefit àhəca. Nəhi ana kʉli nahəma, tamal ti məfəki ahàr gekʉli ke Melefit kay do, àbu gʉzit akaɗa hilfi ga zlam gʉziteni ciliŋ nəŋgu ni, kislʉmki məhiani ana həma hini : “Sləkaba, ru tegi” nəŋgu ni, agravu. Nahkay ti akal ere ye ti kìslʉmki magrani do ni ti àbi.  ");
INSERT INTO muy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ay ti seteni akaɗa nday nani nahəma, tamal ti kàhəŋgalay Melefit ndo akaba kə̀gəs ndəra ndo ni ti tə̀sləkiaba ana mis a koksah. » ");
INSERT INTO muy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","A vaɗ nahaŋ, ka ya ti Yezu akaba ndam maɗəbay naŋ ni ɗek tə̀bu ka ahar bəlaŋ e Gelili ni ti, Yezu nakəŋ àhi ana tay : « Atəɗəfiki nu *Wur ge Mis ana mis ti tara təgəs nu, ");
INSERT INTO muy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","tara takaɗ nu. Atakaɗa nu a ti a vaɗ ya mahkər ti anaŋgaba. » Nday nakəŋ tàra tìcia ma gayaŋ na ti àhəlia ahàr ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka ya ti Yezu akaba ndam maɗəbay naŋ ni tìnjʉa a Kafarnahum a ni ti ndam ya təhəl hadam ga *ahay gəɗakani ge Melefit ni tàhəɗakfəŋiyu ke Piyer, tə̀hi : « Mʉsi gekʉli ni ti àpəl hadam ga ahay gəɗakani ge Melefit ni do waw ? » ");
INSERT INTO muy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyer àhəŋgrifəŋ ana tay : « Àbəhaɗ do kamam ? » Ka ya ti Piyer nakəŋ àhuriya a ahay va nahəma, Yezu àhi ma enji, àhi : « Simu, kə̀ɗəm ahəmamam ? Ndamam tabəhaɗi hadam akaba jaŋgal ana bəbay ka haɗ ni mam ? Tabəhaɗi ana tay ti bəza ga haɗ gatay gatayani tək, ndam mirkwi aw ? » ");
INSERT INTO muy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyer àhi : « Tabəhaɗ ti ndam mirkwi. » Eslini Yezu nakəŋ àhi « Bəza ga haɗ gatay gatayani ti giri-giri ti tə̀pəl do do waw ? ");
INSERT INTO muy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ay ku tamal nahkay nəŋgu ni, mə̀zumi ɓəruv ana tay ba. Nak ru ka dəluv ti kə̂təliyu gʉya kə̂gəsaya kilif a. Kilif ya akəgəsaya enjenjeni na ti kə̂zləkikaba pakama, akədiviyu ahàr ana siŋgu akur-akurani, siŋgu nani emisli məpəl hadam goro akaba gayak. Zəbiya, kə̂vi ana tay. » ");
INSERT INTO muy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka sarta gani nani ti ndam *maɗəbay Yezu ni tàhəɗakfəŋiyu kà Yezu, tə̀hi : « A *Məgur ge Melefit bu ni ti way naŋ gəɗakani àtam mis ndahaŋ way ? » ");
INSERT INTO muy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nahkay Yezu nakəŋ àzalabiyu wur gʉziteni e kiɗiŋ gatay vu ");
INSERT INTO muy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","mək àɗəm : « Nəhi ana kʉli nahəma, tamal kàmbatumkaba majalay ahàr gekʉli a ndo, kìgʉm akaɗa ga bəza ciɓ-ciɓeni ni ndo ni ti akəhurumiyu a Məgur ge Melefit vu do. ");
INSERT INTO muy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aɗaba maslaŋa ya ti ahəŋgaroru ahàr gayaŋ a haɗ, anjəhaɗ kuɗufa akaɗa ga wur hini ni ti naŋ nani gəɗakani àtam mis ndahaŋ a Məgur ge Melefit bu. ");
INSERT INTO muy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Tamal ti maslaŋa àgəskabá wur gʉzitena akaɗa hini na azuhva nu a nahəma, àgəskabá nu a. » ");
INSERT INTO muy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yezu àɗəm keti « Ndam ya təfəku ahàr ni ti mis tə̀ɗəm tìsli araŋa do akaɗa ga bəza ciɓ-ciɓeni ni. Ay tamal maslaŋa agray ti ku way way do e kiɗiŋ gatay bu mîjikia ke divi a nahəma, hojo təwəliviyu avar gəɗakani ana maslaŋa ya èjiŋkia naŋ a ni a dəŋgu vu dondul mək tizligiyu naŋ a *dəluv gəɗakani vu dəzləz. ");
INSERT INTO muy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aw ! Cicihi àki ka ndam ga duniya ! Cicihi àki ka tay ti aɗaba zlam ya tagray ti mis tîjikia ke divi a ni ti tə̀bu kay. Zlam nday nani ti si tâgravu kwa. Ay tamal maslaŋa agray ti mis ejikia ke divi a nahəma, maslaŋa nani cicihi amələki. ");
INSERT INTO muy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","« Tamal ahar gayak ahkay do ni asak gayak ejiŋkia kur ke divi a nahəma, kelkaba tay a, boru tay. Àgəski hojo kəhuriyu ka məlaŋ ga sifa àna ahar bəlaŋ ahkay do ni àna asak bəlaŋ ere gani ya tizligiyu kur a *dəluv ga aku vu àna ahar gayak cʉeni ni ahkay do ni àna asak gayak cʉeni ni. Aku nani ti àmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tamal eri gayak ejiŋkia kur ke divi a nahəma, zaba, zligoru. Àgəski hojo kəhuriyu ka məlaŋ ga sifa àna eri bəlaŋ ere gani ya tizligiyu kur a dəluv ga aku vu àna eri gayak cʉeni ni. » ");
INSERT INTO muy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yezu àɗəm keti : « Bumvu slimi lala ! E kiɗiŋ ga bəza nday nani bu ni ti ŋgay bəlaŋ gatayani èsli araŋa do ni ti kə̀ɗəmum ba. Aɗaba məslər gatay tə̀bu micikeni a sarta bu ɗek kè meleher ga Baba naŋ ya e melefit bu ni.  ");
INSERT INTO muy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nu *Wur ge Mis nàra ti ga mahəŋgay ndam ya ti tìjiji ni. ");
INSERT INTO muy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","« Bi maslaŋa nahaŋ təmbəmbak gayaŋ tə̀bu diŋ mək bəlaŋ gani èjia. Àra èpia ti bəlaŋ gani naŋ àkibu ka ndahaŋ ni bi nahəma, ambərbu kru kru ambəlmbu mahar ambəlmbani ni a həma bu, akoru aɗəboru bəlaŋani ni, do waw ? Lekʉlʉm ti kə̀ɗəmum mam ? ");
INSERT INTO muy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nəhi ana kʉli nahəma, ka ya ti àdia ahàr a ni ti amərvu àna naŋ dal-dal àtama ya amərvu àna kru kru ambəlmbu mahar ambəlmbani ya ti tìji ndo na do waw ? ");
INSERT INTO muy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nahkay day Bəŋ gekʉli naŋ ya e melefit bu ni awayay ti ku bəlaŋ e kiɗiŋ ga bəza nday nani bu day èji ba. » ");
INSERT INTO muy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yezu àɗəm keti : « Tamal wur ga muk àgudaruka zlam a ti rəkioru hiki lala lekʉlʉm cecʉ cʉa. Tamal ècʉkkia ma gayak na ti kàslamala wur ga muk na. ");
INSERT INTO muy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ay tamal ècʉkki ma do ni ti zalakivu mis bəlaŋ ahkay do ni cʉ ti kədəgumkioru. Aɗaba pakama gekʉli ya ekicikʉmki ni ahàr àɗəm mis cʉ ahkay do ni mis mahkər tâgray sedi gani. ");
INSERT INTO muy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ay tamal ti èciiki ma ana tay do ni ti hi ma gani ana ndam ya *təcakalavu, təfəku ahàr ni. Tamal èciiki ma ana tay do daya ti mənjaləŋ akaɗa naŋ zal ya àfəki ahàr ke Melefit do ni, ahkay do ni akaɗa naŋ bay *məhəl hadam. ");
INSERT INTO muy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","« Nəhi ana kʉli nahəma, ere ye ti kə̀gəsumkabu ka haɗ ndo ni ti e melefit bu day atəgəskabu do. Ay ere ya kə̀gəsumkabá ka haɗ a ni ti e melefit bu day atəgəskabu. ");
INSERT INTO muy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","« Nəhi ana kʉli keti : tamal ti mis cʉ e kiɗiŋ gekʉli bu ka haɗ ma gatay àrakabaya ku àki ka mam nəŋgu ni, tàhəŋgalaləŋa zlam gani kà Bəŋ goro ya e melefit bu na ti aməvi ana tay. ");
INSERT INTO muy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Aɗaba ka məlaŋ ya mis cʉ mahkər tàŋgasva àna slimi goro a ni ti nu nə̀bu eslini e kiɗiŋ gatay bu. » ");
INSERT INTO muy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Eslini Piyer àhəɗakfəŋiyu ka Yezu, àhi ahkado : « Bay goro, tamal wur ga mma naŋ àbu agudaru zlam ti nə̂mbərfəŋa sak ehimey ? Sak adəskəla waw ? » ");
INSERT INTO muy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yezu nakəŋ àhi : « Mbərfəŋa sak adəskəla ti nə̀huk do. Mbərfəŋa ti sak kru kru adəskəla sak adəskəla. ");
INSERT INTO muy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","*Məgur ge Melefit day nahkay : tə̀zavu ata bay nahaŋ awayay asər duwa gayaŋ ya àfəŋ kà ku way way do e kiɗiŋ ga ndam məgri tʉwi gayaŋ bu ni, ti tə̂pəli. ");
INSERT INTO muy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ka ya ti naŋ àbu acalfəŋ kà ma gani nahkay ti tə̀zibiyu bay məgri tʉwi nahaŋ duwa gayaŋ àfəŋ àgra miliyem ehimeya. ");
INSERT INTO muy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ay ti èsliki məpəlani koksah, nahkay bay ga duwa ni àɗəm tə̂səkumoru naŋ naŋani, wal gayaŋ, bəza gayaŋ akaba zlam gayaŋ ni ɗek ga məpəli duwa ni àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Eslini bay məgri tʉwi nakəŋ àbəhaɗi mirdim meleher ndiɓ ana haɗ ana bay ga duwa ni, àhi : “Kam-kam ɓesʉa hayaŋ, nara nəpəluk duwa gayak ni ɗek.” ");
INSERT INTO muy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eslini naŋ nakəŋ àsia cicihi ana bay ga duwa na. Nahkay bay ga duwa ni àmbərfəŋ duwa ni ɗek mək àhi “Sləka zlam gayak a.” ");
INSERT INTO muy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","« Ka ya ti bay magray tʉwi nakəŋ naŋ àbu asləka ni ti tàbakabu ahàr ata maslaŋa nahaŋ. Maslaŋa gani nani ti tə̀bu tagrakabu tʉwi, ay ti duwa gayaŋ àfəŋ àgray jik diŋ. Naŋ nakəŋ àdəki cip ka dəŋgu, àhi : “Si kəpəlu duwa goro ni kwa.” ");
INSERT INTO muy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Eslini naŋ ya tagrakabu tʉwi nakəŋ àbəhaɗi mirdim, àhi : “Kam-kam ɓesʉa hayaŋ, nara nəpəluk duwa gayak ni ɗek.” ");
INSERT INTO muy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ay naŋ nakəŋ òru àfiyu naŋ a daŋgay vu, awayay mə̂pəliaba duwa gayaŋ na ɗek day ti atafaya naŋ a. ");
INSERT INTO muy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ndam ya tagrakabu tʉwi akaba tay ka ahar bəlaŋani ni tàra tìpia ere ye ti àgri ana naŋ nahaŋ na ni ti àwəria ɓəruv ana tay a dal-dal. Nahkay nday nakəŋ tòru tàŋgəhaɗi ma gani ana bay ya ti təgri tʉwi ni. ");
INSERT INTO muy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Naŋ nakəŋ àra ècia ma na ti àɗəm tə̂zalibiya naŋ a. Àra ènjia ti àhi : “Nak bay məgru tʉwi hini ti nak cuɗayani. Nə̀mbərfuka duwa goro na ɗek aɗaba kə̀grua kam-kam a, kə̀ɗəm nə̂mbərfuk ti ");
INSERT INTO muy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ay nak ti maslaŋa ya ti kəgrumkabu tʉwi ni àsuk cicihi akaɗa gayak ya kə̀su cicihi ni ndo ni ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nahkay bay ga duwa ni àzuma ɓəruv a dal-dal, àɗəm tə̂zoru naŋ a daŋgay vu ti tə̂gri daliya, si tamal aməpəlaba duwa gayaŋ na ɗek day kwa ti atafaya naŋ a. » ");
INSERT INTO muy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yezu àɗəm keti : « Tamal lekʉlʉm kə̀mbrəŋumfəŋa zlam ya ti mis tàgudari ana kʉli na kà tay àna huɗ bəlaŋ a do ni ti, Baba naŋ ya e melefit bu ni aməgri ana kʉli day akaɗa ga bay ga duwa ya àgri ana bay məgri tʉwi ni. » ");
INSERT INTO muy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yezu àra èndeveriŋa pakama gayaŋ na ti àsləka e Gelili a, òru ka haɗ *Zʉde, ke ledi nahaŋ ga zalaka *Zʉrdeŋ. ");
INSERT INTO muy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mis dal-dal tàɗəboru naŋ, mək naŋ nakəŋ àhəŋgaraba ndam ya tèɓesey do na. ");
INSERT INTO muy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eslini ndam *Feriziyeŋ ndahaŋ tə̀rəkia. Tìhindifiŋa ma, tə̀hi ahkado : « Àgəski ti mis agaray wal gayaŋ ka mawayay gayaŋ aw ? » Tə̀hi nahkay ti aɗaba tawayay tatəkar Yezu ti mə̂ɗəm ma magudarani. ");
INSERT INTO muy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Kwa ka mənjəki ga məlaŋ, ka ya ti Melefit àgraya mis a ni ti àgraya ata zal ata wal a. Kèjeŋgʉm ma gani a Wakita ge Melefit ni bu ndo waw ? ");
INSERT INTO muy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Melefit àɗəm : “Nahkay ti mis zalani amahəraya a ahay ga bəŋani ata məŋani ba, mək atanjəhaɗkabu ata wal gayaŋ. Nday cʉeni ti vu gatay emigi bəlaŋ.” ");
INSERT INTO muy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nahkay ti nday cʉeni medeveni va do. Tìgia vu gatay bəlaŋ. Ere ye ti Melefit èbeɗekabá ni ti mis hihirikeni èdekaba ba. » ");
INSERT INTO muy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mək nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Mʉwiz àɗəm tamal mis tedevu ata wal gayaŋ ti ahàr àɗəm abəki wakita gani, avi day kwa ti agaray ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yezu nakəŋ àɗəm : « Mʉwiz àvi divi ana kʉli ga magaray wál gekʉli ti aɗaba lekʉlʉm kàwayum məgəsumkabu ma ge Melefit do palam. Ay ka mənjəki ga məlaŋ ti àgravu nahkay ndo. ");
INSERT INTO muy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nəhi ana kʉli nahəma, maslaŋa ya ti àgara wal gayaŋ a, day wal ni àgray mesʉwehvu ndo, mək àda wal nahaŋ a nahəma, maslaŋa nani àgra hala. » ");
INSERT INTO muy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Eslini ndam maɗəbay naŋ ni tə̀hi : « Tamal ègia nahkay e kiɗiŋ ga zal ata wal ba ti ŋgulum mis tàday wal va ba simiteni. » ");
INSERT INTO muy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yezu àhi ana tay ahkado : « Təgəskabu ma gani hini ti mis ɗek do ; təgəskabu ti si ndam ya ti Melefit àvia njəɗa gana ana tay a ni kwa. ");
INSERT INTO muy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zlam ndahaŋ tə̀bu gərgəri təcafəŋa mis ka maday wal a : mis ndahaŋ kwa tìweya tay a vu gatay àwayay wal do. Mis ndahaŋ ti ni mis tàcaɗ tay. Mis ndahaŋ keti ti ni tàwayay maday wal do azuhva *Məgur ge Melefit. Maslaŋa ya esliki məgəskabu pakama hini nahəma, mə̂gəskabá. » ");
INSERT INTO muy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kələŋ gani mis ndahaŋ tə̀həlibiyu bəza ciɓ-ciɓeni ana Yezu ti mâhəŋgali Melefit ana tay àna məbəki *ahar gayaŋ ka tay. Nday tə̀bu təhəlibiyu bəza ni nahkay ti ndam maɗəbay naŋ ni tə̀ləgi ana tay. ");
INSERT INTO muy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ay Yezu àhi ana tay ahkado : « Mbrəŋum bəza târa afa goro a, kə̀cumfəŋa tay a ba. Aɗaba mam, *Məgur ge Melefit ti ga ndam ya tə̀bu akaɗa ga bəza ni. » ");
INSERT INTO muy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Àra àɗəma ma nahkay ti àbəki ahar ka bəza ni. Kələŋ gani àsləka eslina. ");
INSERT INTO muy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wur dagwa nahaŋ àbu ti àrəkia ka Yezu a, àhi : « Mʉsi, ti nə̂ŋgət *sifa ya àndav ɗay-ɗay do ni ti nâgray zlam sulumani weley ? » ");
INSERT INTO muy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yezu àhi ahkado : « Kihindi nu àki ka zlam sulumani ti kamam ? Mis sulumani ti naŋ bəlaŋ. Tamal kawayay məŋgət sifa ya àndav ɗay-ɗay do ni ti gəskabá *Divi ge Melefit a. » ");
INSERT INTO muy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naŋ nakəŋ àhi : « Divi weley ? » Yezu nakəŋ àhəŋgrifəŋ, àhi : « Kə̀kaɗ mis ba ; kàgray hala ba ; kìgi akal ba ; kagray sedi ti kàsəkaɗ malfaɗa ba ; ");
INSERT INTO muy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","həŋgrioru ahàr a haɗ ana ata buk ata muk ; wayay ndam ya ti nak kə̀bu akaba tay ni akaɗa ya kawayay ahàr gayak gayakani ni. » ");
INSERT INTO muy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eslini wur dagwa ni àhəŋgrifəŋ, àhi ahkado : « Divi nani ti nə̀gəskabá ɗek, ay ti mam àhəcukivu keti mam ? » ");
INSERT INTO muy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yezu àra ècia pakama gayaŋ na ti àhi ahkado : « Tamal kawayay migi mis sulumani lala nahəma, ru kə̂səkumoru zlam gayak ɗek ti kîdi siŋgu gani ana ndam talaga. Nahkay ti akəŋgət elimeni e melefit bu. Akagra zlam nana ɗek nahəma, kâra, kâɗəbay nu. » ");
INSERT INTO muy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wur dagwa nakəŋ àra ècia ma ga Yezu ya àhi na ti àhəlia ahàr a. Nahkay àsləka sasuhwa, aɗaba zlam gayaŋ àbu dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eslini Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Nəhi ana kʉli nahəma, bay ge elimeni mə̂huriyu a *Məgur ge Melefit vu ti zləzlaɗa dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nəhi ana kʉli keti : ezligwemi ahuriyu e eviɗ ge lipri vu kwalac ti agravu aw ? Ay ti bay ge elimeni mə̂huriyu a Məgur ge Melefit vu ni ti zləzlaɗa dal-dal, àtama ge ezligwemi ya ahuriyu e eviɗ ge lipri vu na. » ");
INSERT INTO muy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ma ga Yezu ya àɗəm ni àgria ejep ana ndam maɗəbay naŋ na dal-dal. Nday nakəŋ tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Ay tamal nahkay ti way ti Melefit amahəŋgay naŋ way ? » ");
INSERT INTO muy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eslini Yezu àmənjaləŋ kà tay, àhi ana tay ahkado : « Mis ti tàgray koksah ; ay Melefit ti esliki magray zlam ɗek tata. » ");
INSERT INTO muy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eslini Piyer àhi ana Yezu nakəŋ ahkado : « Iy zla, leli mə̀mbrəŋa zlam a ɗek, maɗəbay kur ti mam amagrakivu ke leli mam ? » ");
INSERT INTO muy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yezu àhi ana tay : « Nəhi ana kʉli nahəma, a duniya ya atagraya mʉweni ni ba ni ti nu *Wur ge Mis anəhuriyu a məlaŋ maslaɗani goro vu, ananjəhaɗviyu e kʉrsi ga bay goro vu. Ka sarta gani nani ti lekʉlʉm ya kə̀ɗəbum nu ni day akanjəhaɗumviyu e kʉrsi kru mahar cʉ vu ga magrafəŋa seriya kè dini kru mahar cʉeni ge Izireyel na. ");
INSERT INTO muy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ku way way do àmbərba zlam gayaŋ azuhva nu a, bi àmbərbu ahay gayaŋ, bəza ga məŋani, ata bəŋani, bəza gayaŋ ahkay do ni vədaŋ gayaŋ nahəma, aməŋgətvù zlam nday nani kay àtam ndahaŋ ni sak diŋ. Aməŋgət sifa ya àndav ɗay-ɗay do ni daya. ");
INSERT INTO muy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ay ti nday gəɗákani ya kama ge mis ni ti, mis kay e kiɗiŋ gatay bu ataŋgoru kələŋ ge mis. Nday ya kələŋ ge mis ni day etigi gəɗákani kama ge mis. » ");
INSERT INTO muy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yezu àɗəm keti : « *Məgur ge Melefit ti àzavu akaɗa ga maslaŋa nahaŋ àhəraya dʉ ge miledʉ a, awayay ahəloru mis ga məgri tʉwi a vədaŋ gayaŋ vu ni. ");
INSERT INTO muy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nahkay tàgraki cakala àki ke tʉwi ga rukani, mək naŋ nakəŋ àhəloru tay a vədaŋ gayaŋ ni vu. ");
INSERT INTO muy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Àhəraya àna njemdi ambəlmbu a keti, èpi mis ndahaŋ tə̀bu a kəsa bu tʉwi gatay àbi, ");
INSERT INTO muy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","mək àhi ana tay : “Lekʉlʉm day dəgum a vədaŋ goro vu kə̂grum tʉwi ti anəpəl kʉli kala-kala akaɗa ge tʉwi gekʉli ya akəgrum ni.” ");
INSERT INTO muy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nday nakəŋ mək tàsləka tòru. Naŋ nakəŋ àhəraya fat wis a keti, àgray nahkay ; àna njemdi mahkər day àgray nahkay. ");
INSERT INTO muy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Agray njemdi zlam nahəma, naŋ nakəŋ àhəraya keti, àdi ahàr ana mis ndahaŋ tə̀bu eslini mək àhi ana tay ahkado : “Kànjəhaɗum ahalay ruk kə̀grum tʉwi do ni ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nday nakəŋ tə̀həŋgrifəŋ tə̀hi : “Aɗaba maslaŋa èhindiki leli ke tʉwi gayaŋ ndo.” Naŋ nakəŋ àhi ana tay : “Lekʉlʉm day dəgum kə̂grum tʉwi a vədaŋ goro vu.” ");
INSERT INTO muy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","« Məlakarawa àra ègia ti bay ga vədaŋ ni àhi ana gəɗakani ga ndam ge tʉwi gayaŋ ni ahkado : “Zalabiya ndam magray tʉwi na, peli siŋgu ge tʉwi ni ana ku way way do. Njəki məpəl ndam ya tàra kələŋ a ceceni ni, ndeveriŋ àna nday ya tàra enjia ni.” ");
INSERT INTO muy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nahkay nday ya tòru a vədaŋ vu àna njemdi zlamani ni tàra, mək tə̀vi ana ku way way do siŋgu ge tʉwi ga rukani. ");
INSERT INTO muy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nahkay sarta ga məpəl nday ya tòru e tʉwi vu enji ni àra ènjia ti tə̀hi ana ahàr tara təvi ana tay àtam gatay ndahaŋ ni. Ay ti tə̀vi ana ku way way do gatay day siŋgu ge tʉwi ga rukani ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tàra tə̀via siŋgu na ana tay a nahkay ti nday nakəŋ tə̀zərɗi ma ana bay ga vədaŋ ni, ");
INSERT INTO muy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tə̀hi : “Nday hini ya tàra kələŋ a ni, tàgray tʉwi njemdi biliŋ hʉya ti kə̀pəl tay kala-kala akaba leli ya màgray tʉwi rukani a fat bu, màmətakaba dal-dal ni ti ahəmamam ?” ");
INSERT INTO muy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Eslini bay ga vədaŋ ni àhi ana bəlaŋ gatay ni ahkado : “Zləba goro ni, ere ye ti nə̀vuk ni ti kigeni : màgray cakala ti àki ka siŋgu ge tʉwi ga rukani do waw ? ");
INSERT INTO muy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Za siŋgu ge tʉwi gayak a ti kâsləka nimi. Nawayay nəvi siŋgu ana bay ya ti àra kələŋ a ni kala-kala akaɗa ya nəvuk ana nak ni. ");
INSERT INTO muy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Maslaŋa àbu agurki nu ka zlam ya ti nagray àna siŋgu goro ni aw ? Tək day ti nəgri sulum ana mis ti awəruk ɓəruv aw ?” ");
INSERT INTO muy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nahkay nday ya tə̀bu kələŋ ge mis ni ti, mis ndahaŋ e kiɗiŋ gatay bu etigi gəɗákani kama ge mis. Nday gəɗákani ya kama ge mis ni ti ni, mis ndahaŋ e kiɗiŋ gatay bu ataŋgoru kələŋ ge mis. » ");
INSERT INTO muy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yezu naŋ àbu akoru, àzay divi ya ti acəloru a Zerʉzalem ni ti àzalakabu ndam maɗəbay naŋ kru mahar cʉeni ni. Nday tə̀bu takoru ti àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","« Cʉm day, nihi ti leli mə̀bu məcəloru a Zerʉzalem. Eminjʉa eslina ti atəgəsi nu *Wur ge Mis ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit akaba ana ndam *məsər Wakita ge Melefit ni. Eslini atəɗəm si takaɗ nu kwa, ");
INSERT INTO muy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","atəgəsi nu ana ndam ya tə̀fəki ahàr ke Melefit do ni ; nday nani ti eteyefʉ, atəzləɓ nu àna kurupu cʉk cʉk, atakaɗfəŋiyu nu kà təndal, mək a vaɗ ya mahkər ti anaŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Eslini wal ge Zebede tə̀rəkia ka Yezu a akaba bəza gayaŋ ata Zek nday ata Zeŋ a. Tàra tìnjikia ti məŋ gatay ni àbəhaɗi mirdim ana Yezu meleher nɗiɓ ana haɗ, awayay ehindifiŋa zlam a. ");
INSERT INTO muy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yezu àhi ahkado : « Kawayay ti nə̂gruk mam ? » Wal nakəŋ àhi : « Ka ya ti akəzuma bay gayak gəɗakani na ti kə̂vi divi ana bəza goro hini cʉeni ni tânjəhaɗfuk kà gəvay, bəlaŋ ka ahar ga ɗaf, bəlaŋ ka ahar ga gəjar gayak ti. » ");
INSERT INTO muy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ay ti Yezu àhi ana tay ahkado : « Ere ye ti kihindʉm ni ti kə̀sərum do. Ekislʉmki misi zum ge hijiyem ya enisi ni tata waw ? » Nday nakəŋ tə̀hi : « Misliki. » ");
INSERT INTO muy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Eslini Yezu àhi ana tay ahkado : « Ekisʉm zum ge hijiyem ye enisi ni ti amagravu eɗeɗiŋ. Ay ti maslaŋa ya ti aməɗəm way amanjəhaɗfu kà ahar ga ɗaf akaba kà ahar ga gəjar goro way ni ti nu do. Nani Bay Melefit àna ahàr gayaŋ day ti aməvi məlaŋ nani ana mis ya naŋ àdaba tay a ni. » ");
INSERT INTO muy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka ya ti ndam *maɗəbay Yezu kruani ndahaŋ ni tìcia ma na ti tə̀zumkia ɓəruv ka tay cʉeni na. ");
INSERT INTO muy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Eslini Yezu àzalakabu ndam maɗəbay naŋ ni ɗek, àhi ana tay ahkado : « Kə̀səruma, bəbay ga haɗ ni ti təgur mis ga njəɗa. Gəɗákani ga məlaŋ day tə̀ɗəm ahàr àɗəm mis təgri tʉwi ana tay kay, tə̀mbrəŋ mis do. ");
INSERT INTO muy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ay e kiɗiŋ gekʉli bu ni ti àgravu nahkay ba. Tamal ti maslaŋa e kiɗiŋ gekʉli bu awayay migi gəɗakani ti mîgi bay məgri tʉwi ana kʉli kwa sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tamal ti maslaŋa e kiɗiŋ gekʉli bu awayay migi kama gekʉli ti mîgi eviɗi gekʉli kwa. ");
INSERT INTO muy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nu *Wur ge Mis nàra ti, nàwayay ti mis tə̂gru tʉwi do. Nàra ti ga məgri tʉwi ana mis sawaŋ, navay sifa goro ga mambay mis kay àna naŋ. » ");
INSERT INTO muy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka ya ti Yezu naŋ àbu asləka a Zeriko akaba ndam maɗəbay naŋ na ti mis kay tàɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Eslini tə̀di ahàr ana ndam wuluf ndahaŋ cʉ, nday tə̀bu manjəhaɗani kà gəvay ge divi. Nday nakəŋ tàra tìcia Yezu naŋ àbu akoru ti tə̀dəgiki ka zlahay, tə̀ɗəm : « Bay geli, *Wur ge Devit, mə̂suk cicihi ti ! » ");
INSERT INTO muy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mis kayani ni tə̀ləgi ana tay, tə̀hi ana tay : « Lakumkaba. » Ay nday ti ni tə̀zlahkivu kay kay sawaŋ, tə̀ɗəm : « Bay geli, wur ge Devit, mə̂suk cicihi ti ! » ");
INSERT INTO muy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yezu àra ècia zlahay gatay na ti ècik, àzalay tay mək àhi ana tay ahkado : « Kawayum ti nə̂gri mam ana kʉli mam ? » ");
INSERT INTO muy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eslini tə̀hi ahkado : « Bay geli, mawayay ti mîpi divi ti ! » ");
INSERT INTO muy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nday nakəŋ tə̀sia ciciha ana Yezu a, mək Yezu ènjifiŋ kè eri gatay ni. Ka ma geli hini tìpi divi hʉya, mək tàɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tòru tìnjʉa cifa kà gəvay ga Zerʉzalem a, nday gwar ka həma *Oliviye, kama ga kəsa Betfazi ti Yezu àslər ndam maɗəbay naŋ ni cʉ, ");
INSERT INTO muy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","àhi ana tay ahkado : « Dəgum a kəsa tegʉni kama gekʉli ni vu. Ekinjʉmiya nahəma, akədumi ahàr ana azoŋgu məwəlani wur gani àfəŋ kà gəvay. Picehʉmubiya, dəguma àna tay a. ");
INSERT INTO muy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ay tamal maslaŋa ahi ma ana kʉli ti humi ahkado : “Bay geli awayay.” Nahkay ti atəmbərfəŋ tay kè kʉli hʉya. » ");
INSERT INTO muy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Zlam gani nani àgravu ɗek nahkay ti, ti pakama ga bay mahəŋgaray *pakama ge Melefit ni mâgravu. Pakama gani nihi : ");
INSERT INTO muy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","« Humi ana ndam *Siyoŋ : “Bay gekʉli naŋ tegi ara, naŋ kuɗufa. Naŋ àki ka məŋ ga azoŋgu, àki ka wur ga azoŋgu ya mis təhəl zlam àna naŋ ni.”  » ");
INSERT INTO muy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mək ndam *maɗəbay Yezu ni tòru tàgray ere ye ti Yezu àhi ana tay tâgray ni. ");
INSERT INTO muy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nday nakəŋ tə̀zəbiyu məŋ ga azoŋgu ni akaba wur ga azoŋgu ni. Tàra tìnjia àna tay a ti tə̀bəki azana ka tay mək Yezu ànjəhaɗkiyu. ");
INSERT INTO muy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mis dal-dal eslini tàpaɓivoru azana gatay e divi vu, mis ndahaŋ ti ni tàkwahabiyu slimberi a vədaŋ bu, tàbəhaɗivoru bilegeni. ");
INSERT INTO muy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yezu naŋ àbu akoru ti mis dal-dalani ya kama gayaŋ akaba ya kələŋ gayaŋ ni tàgray salalay, tàzləbay naŋ, tə̀ɗəm : « *Hozana ana *Wur ge Devit ! Bay Melefit mə̂gri sulum gayaŋ ana maslaŋa ya ti ara àna slimi gayaŋ a ni ! Tâzləbay Melefit driŋ agavəla !  » ");
INSERT INTO muy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ka ya ti Yezu àhuriya a Zerʉzalem a ni ti mis ga kəsa ni ɗek ahàr àhəlia ana tay a dal-dal. Mis ndahaŋ tə̀ɗəm : « Naŋ hini ti way ? » ");
INSERT INTO muy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mək mis kayani ni tə̀ɗəm : « Naŋ hini ti Yezu bay mahəŋgaray pakama ge Melefit, naŋ zal Nazaret ka haɗ *Gelili. » ");
INSERT INTO muy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu, àdi ahàr ana mis təsəkumvoru zlam akaba ndam məsəkum zlam, mək ànjəki ka magaraya tay e mite va. Àmbəhaɗaba tabəl ga ndam mambay siŋgu na akaba məlaŋ manjəhaɗani ga ndam məsəkumoru kurkoduk na. ");
INSERT INTO muy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Àhi ana tay ahkado : « Àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm : “Ahay goro zla ti atəɗəm ahay ga *mahəŋgalavù Melefit.” Ay lekʉlʉm ti kàmbatumkaba, ègia ahuzl ga ndam akal a. » ");
INSERT INTO muy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Eslini a dalaka ga ahay gəɗakani ge Melefit ni bu ni ti ndam wuluf akaba ndam dəra tə̀rəkia ka Yezu a, mək àhəŋgaraba tay a. ");
INSERT INTO muy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ka sarta gani nani ti bəza təzlah a ahay gəɗakani ge Melefit ni bu, təɗəm : « *Hozana ana *Wur ge Devit. » Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni tàra tìpia zlam magray ejep ga Yezu ya agray na akaba tìcia zlahay ga bəza na ti nday nakəŋ tə̀zuma ɓəruv a. ");
INSERT INTO muy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eslini nday nakəŋ tə̀hi ana Yezu : « Kə̀bu kici ere ga bəza ya təɗəm ni aw ? Tagray nahkay ti àɓəlay aw ? » Yezu àhi ana tay : « Iy, nə̀bu nici ere ye ti təɗəm ni. Ay a Wakita ge Melefit bu Devit àhi ana Melefit nahkay hi : “Kàgray ti ku bəza dac-dacani akaba bəza ya ka ahar ni tekeɗi tâzləbay kur.” Ma gani nani ti kèjeŋgʉm ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eslini àmbərbu tay, àsləkaba a kəsa ni ba, òru a Betani mək àndəhaɗbu eslini hundum. ");
INSERT INTO muy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dʉ ge miledʉ gani, Yezu nakəŋ naŋ àbu aŋgoru a kəsa ni vu ti lʉwir àwərkaba naŋ a. ");
INSERT INTO muy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lʉwir ni naŋ àbu awər naŋ nahkay ti èpi məŋ ga *wəruv kà gəvay ge divi. Naŋ nakəŋ òru kà gəvay gani. Òru ènjʉa ti àdifəŋ ahàr ana bəza gani ndo, si slimberi ciliŋ, mək àhi ana məŋ ga wəruv ni ahkado : « Nak ti ɗay-ɗay ekiwi bəza va do. » Eslini məŋ ga wəruv ni èkʉli hʉya. ");
INSERT INTO muy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ndam maɗəbay naŋ ni tàra tìpia ti àgria ejep ana tay a, tə̀ɗəm ahkado : « Ka ma geli hini ti məŋ ga wəruv ni èkʉlia hʉya ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eslini Yezu àhi ana tay : « Nəhi ana kʉli nahəma, tamal kə̀fumkia ahàr ke Melefit a, kàjalum ahàr cʉ cʉ do ni ti ekislʉmki magray ere ye ti nə̀gri ana məŋ ga wəruv ni ciliŋ do, ku kəhumi ana həma hini : “Raɗvaba, ru kə̂diyu a *dəluv gəɗakani vu” nəŋgu ni, agravu. ");
INSERT INTO muy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamal ti kə̀fumkia ahàr ke Melefit a ti Melefit aməvi ere ye ti kahəŋgalumfəŋa ni ɗek ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Ka ya ti naŋ àbu acahi zlam ana mis ni ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ tə̀rəkia, tə̀hi : « Kagray tʉwi hini nahkay ti kə̀ŋgət divi gani eley ? Way àvuk divi gani way ? » ");
INSERT INTO muy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yezu àhəŋgrifəŋ ana tay, àɗəm : « Nu day nihindifiŋa zlam bəlaŋ kè kʉli a. Kə̀həŋgrumufəŋa nahəma, nu day nəhəŋgrifəŋ ana kʉli, nəɗəfi bay ya ti àvu divi ge tʉwi ya ti nagray ni ana kʉli. ");
INSERT INTO muy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nəhi ana kʉli nahəma, *baray ge Zeŋ ya ti àbaray mis ni ti njəɗa gani Melefit àvi tək, tək day ti mis tə̀vi aw ? » Tàra tìcia ma na nahkay ti tàgray gejewi e kiɗiŋ gatay bu, tə̀ɗəm : « Tamal məhi : “Melefit àslərbiyu naŋ” hi nahəma, ara ahi ana leli : “Kə̀gəsumkabu pakama gayaŋ ni ndo ni ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ay tamal məɗəm keti : “Mis tə̀vi njəɗa gani” ti àrakaboru do ; aŋgwaz awərfəŋa leli kè mis tezl-tezleni na, aɗaba nday ɗek tə̀ɗəm Zeŋ ti naŋ bay mahəŋgaray *pakama ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nahkay ti tə̀həŋgrifəŋ ana Yezu, tə̀hi : « Leli mə̀sər do. » Eslini Yezu àhi ana tay : « Nu day nə̀ɗəfi bay ya ti àvu divi ge tʉwi ya ti nagray ni ana kʉli do bilegeni. » ");
INSERT INTO muy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yezu àhi ana tay keti : « Cʉm day, ma goro àbu nəhi ana kʉli ti, akajalumki ahàr ti ahəmamam ? Maslaŋa nahaŋ àbu bəza gayaŋ tə̀bu cʉ. Àhi ana bəlaŋ gani : “Wur goro ni, ru kâgray tʉwi a vədaŋ bu kani.” ");
INSERT INTO muy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wur ni àhəŋgrifəŋ, àhi : “Nòru do.” Ay àpəsa gʉzit ti ajalay ahàr nahaŋ mək òru a vədaŋ ni vu. ");
INSERT INTO muy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bəŋ gatay ni àhi ana wur nahaŋ ni day nahkay. Wur ni àhəŋgrifəŋ, àhi : “Bəba nìcia, nakoru.” Ay ti àcuhway moroni ndo. ");
INSERT INTO muy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E kiɗiŋ ga bəza cʉeni ni bu ni ti way àgra ere ye ti bəŋani awayay na way ? » Tə̀həŋgrifəŋ tə̀hi : « Naŋ ye enjenjeni ni. » Mək Yezu àhi ana tay : « Nəhi ana kʉli nahəma, ndam *məhəl hadam akaba wál mesʉwehvu atəhuriyu a *Məgur ge Melefit vu enji gekʉli. ");
INSERT INTO muy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aɗaba Zeŋ bay məbaray mis ni àra afa gekʉli a, àɗəfikia divi ge jiri ana kʉli a, ay ti kə̀gəsumkabu ma gayaŋ ni ndo. Ay ndam məhəl hadam akaba wál mesʉwehvu tə̀gəskabá sawaŋ. Ku kàra kìpʉma nahkay nəŋgu ni, kàmbatumkaba majalay ahàr gekʉli a ga məgəskabu ma ge Zeŋ na ndo. » ");
INSERT INTO muy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yezu àhi ana tay keti : « Bumi slimi ana ma *gozogul nahaŋ keti : Bay ga vədaŋ nahaŋ àbu nahəma, àjavù məŋ ga zlam a vədaŋ gayaŋ ni vu, àcafəŋ azlaw tekesl, àgraya məlaŋ ga məɗucaya yam ga bəza ga məŋ ga zlam na, àkay ləli zəbalani, mis acəlkiyu ka ahàr gani ga majəgay vədaŋ ni. Kələŋ gani àfivù vədaŋ ni a ahar vu ana mis ti tə̂wəs, mək àsləka, òru e mirkwi zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Sarta ga məpalay bəza ga zlam ni àra ènjia ti bay ga vədaŋ ni àslərbiyu ndam məgri tʉwi afa ga ndam məwəs vədaŋ ni ti tə̂həlikaboru ja gani gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ay nday ya tə̀slərbiyu tay ni tàra tìnjia ti ndam məwəs vədaŋ ni tə̀gəs tay yaw yaw. Tàra tə̀gəsa tay a ti tə̀zləɓ bəlaŋ gani, tàkaɗ bəlaŋ gani, bəlaŋ gani ti ni tìzligi àna akur simiteni. ");
INSERT INTO muy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Eslini bay ga vədaŋ ni àslərbiyu mis ndahaŋ kay tə̀tam nday ye enjenjeni ni. Tàra tìnjia ti ndam məwəs vədaŋ ni tə̀gri ana tay akaɗa ya tə̀gri ana nday ye enjenjeni ni. ");
INSERT INTO muy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kələŋ gani nahəma, bay ga vədaŋ ni àslərbiyu wur gayaŋ gayaŋani, àhi ana ahàr : “Wur goro ni ti atəgəsiki ma.” ");
INSERT INTO muy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ay ndam məwəs vədaŋ ni tìpia wur na naŋ àbu ara ti tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : “Naŋ tegʉni ti mekeji gayaŋ ; mə̀mbrəŋ naŋ ba, makaɗum naŋ ; nahkay ti vədaŋ ni emigi geli.” ");
INSERT INTO muy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Àra ènjikia ka tay a ti tə̀gəs naŋ yaw, tə̀zaba naŋ a vədaŋ ni ba, tòru tàkaɗ. ");
INSERT INTO muy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","« Nə̀ɗəm nahəma, bay ga vədaŋ ni amasləkabiya ti aməgri mam ana ndam məwəs vədaŋ ni mam ? » ");
INSERT INTO muy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Amabazl ndam məwəs vədaŋ cuɗayani ni, mək aməvi vədaŋ ni ana mis ndahaŋ. Nahkay nday nani atəhəlibiyu ja gani gayaŋ ka mawayay gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eslini Yezu nakəŋ àhi ana tay : « A Wakita ge Melefit bu, àbu məbəkiani nahkay hi : “Akur nahaŋ àbu ti ndam mələm ahay tàwayay magray tʉwi àna naŋ ndo. Ay ti akur gani nani ègia akur ya akay ahay na ɗek sawaŋ. Ere nani ti tʉwi ga Bay Melefit, agri ejep ana leli.” « Lekʉlʉm kèjeŋgʉm ma gani nani ɗay-ɗay ndo waw ? ");
INSERT INTO muy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nəhi ana kʉli nahəma, lekʉlʉm ndam ya ti giri-giri Məgur ge Melefit ni gekʉli ni ti akəhurumiyu do ; Melefit aməvi ti ana ndam ya ti təgəsiki ma, təgri tʉwi ni.  ");
INSERT INTO muy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Akur gani nani nahəma, tamal maslaŋa àdəɗkiya ti maslaŋa nani aməhuɓkaba ŋguc ŋguc. Ay tamal akur ni àdəkia ti ni, amaŋgəlaɗkaba naŋ a. » ");
INSERT INTO muy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *Feriziyeŋ ni tàra tìci ma *gozogul ga Yezu ya àɗəm na ti tə̀səra àɗəmki ti ka tay. ");
INSERT INTO muy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nahkay tawayay təgəs naŋ. Ay mis tə̀bu eslini kay ti tə̀gəs naŋ ndo, aɗaba aŋgwaz àwərfəŋa tay kè mis dal-dalani na. Aɗaba mis ni tə̀ɗəm naŋ ti naŋ bay mahəŋgaray *pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Eslini Yezu àhi ma *gozogul nahaŋ ana tay keti. Àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","« *Məgur ge Melefit ti tə̀zavu akaba bay nahaŋ gəɗakani àgray wuməri ga mədi wal ana wur gayaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nahkay àsləroru ndam məgri tʉwi gayaŋ ni ti tə̂zalabiya mis ya ti àzalay tay na ti târa ka wuməri na ; ay ti mis nday nani tàcuhway moroni ndo. ");
INSERT INTO muy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Eslini bay nakəŋ àsləroru ndam məgri tʉwi ndahaŋ keti, àhi ana tay : “Dəgum kə̂humi ana mis ya nàzalay tay ni ahkado : Nə̀slamalakabá zlam ga wuməri na, nàbazla kokúr akaba zlam ga gənaw goro ndahaŋ miɗiseni a ; zlam ɗek maslamalakabani, dəguma ka wuməri na.” ");
INSERT INTO muy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ay ndam ya ti àzalay tay ni tàcuhway moroni ndo ; tàsləka tòru e tʉwi gatay vu. Maslaŋa nahaŋ òru a vədaŋ gayaŋ vu, maslaŋa nahaŋ òru ka cakalay gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mis ndahaŋ ni ti ni tə̀gəs ndam məgri tʉwi ana bay ni, tə̀gri daliya ana tay mək tàbazl tay. ");
INSERT INTO muy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nahkay bay ni àzuma ɓəruv a, àsləroru ndam slewja gayaŋ tâbazl ndam ya ti tàbazl ndam məgri tʉwi ni, têviyekaba kəsa gatay na. ");
INSERT INTO muy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Eslini bay ni àhi ana ndam məgri tʉwi ni ahkado : “Zlam məzumani ga wuməri ni maslamalakabani, ay ti ndam ya nə̀zalay tay enji ni ti nàwayay tay va do. ");
INSERT INTO muy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nihi nahəma, dəgum ka mazlalamba ge divi, zalumbiya mis ya kədumi ahàr ana tay eslini na ɗek târa ka wuməri na.” ");
INSERT INTO muy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eslini ndam məgri tʉwi nakəŋ tòru ka mazlalamba ge divi ni, tə̀zalakabu ndam ya tə̀di ahàr ana tay eslini ni ɗek ; ndam cuɗay akaba mis sulumani ɗek tàra ka wuməri na. Mis ni tàra tìnjikaba ti tə̀rəhva a ahay ni va ndəŋ. ");
INSERT INTO muy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","« Kələŋ gani bay ni àhurkiviyu ka ndam ya ti àzalakabu tay ni a ahay vu ga məmənjiyu tay. Eslini naŋ nakəŋ èpi zal nahaŋ azana ga wuməri ni àfəŋ bi ; ");
INSERT INTO muy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","èhindifiŋa, àhi ahkado : “Zləba goro ni, azana ga wuməri ni àfuk bi ti kàhəraya ahalay a ti ahəmamam ?” Ay ti maslaŋa gani nani èsliki məhəŋgrifəŋani ndo. ");
INSERT INTO muy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nahkay bay ni àhi ana ndam məgri tʉwi ni ahkado : “Wəlumikaba asak akaba ahar a ti kîzligʉmiyu naŋ e mite vu a məlaŋ ziŋ-ziŋeni vu. Eslini emitʉwi, amacakay daliya dal-dal.” » ");
INSERT INTO muy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yezu àɗəm keti : « Ndam ya ti Melefit àzalay tay ni ti nday kay, ay ndam ya ti àdəkiba tay a ni ti nday kay do. » ");
INSERT INTO muy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eslini ndam *Feriziyeŋ ni tə̀zlapay e kiɗiŋ gatay bu tə̀ɗəm : « Magray ahəmamam ti Yezu mə̂ɗəm ma magədavani ti mə̂gəski naŋ ni mam ? » ");
INSERT INTO muy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nahkay nday nakəŋ tə̀slərkioru ndam maɗəbay tay ndahaŋ akaba ndam ndahaŋ ya taɗəbay bay *Erot ni ti tə̂hi ana Yezu ahkado : « Mʉsi, mə̀səra nak ti kəɗəm ma ge jiri, kacahi zlam ya ti Melefit awayay ni ana mis àna jiri gani. Aŋgwaz àwərfəŋa kur kà pakama ge mis ya təɗəmkuk na do ; ku kè meleher ga way way do day kàgray aŋgwaz do. ");
INSERT INTO muy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ay ti hi ana leli nimi, a majalay ahàr gayak bu ni ti Melefit àvia divi ana leli a ga mabəhaɗi hadam ana *bay gəɗakani ga ndam Rom a tək, àvi ana leli ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nday nakəŋ tàra tə̀hia ma na nahkay ti Yezu àsəra tə̀ɗəmaya ma ge jiri ga huɗ gatay a ndo. Nahkay àhi ana tay ahkado : « Lekʉlʉm ti kawayum mis tə̂ɗəm lekʉlʉm ndam jireni, ay ti lekʉlʉm ndam jireni do ! Kəhəlumfua eyʉ a ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ŋga ŋgazlumubiya siŋgu akur-akurana ya ti mis təpəl hadam àna naŋ na day nimi. » Mək nday nakəŋ tə̀vi siŋgu akur-akurani bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eslini naŋ nakəŋ àhi ana tay ahkado : « Àki ka siŋgu hini ti mazavu ga ahàr ga way ? Slimi məbəkiani ni ti ga way ? » ");
INSERT INTO muy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tə̀həŋgrifəŋ, tə̀hi ahkado : « Ga bay *Sezar.  » Nahkay naŋ nakəŋ àhi ana tay ahkado : « Həŋgrumi zlam ga bay Sezar ni zlam gayaŋ, ge Melefit ti ni həŋgrumi ana Melefit zlam gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tàra tìcia ma ga Yezu ya àhi ana tay na ti àgria ejep ana tay a dal-dal. Nahkay tə̀mbərbu naŋ, tàsləka. ");
INSERT INTO muy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ka fat gani nani nahəma, ndam *Sedʉseyeŋ ndahaŋ tə̀rəkia ka Yezu a. Ndam Sedʉseyeŋ ti tə̀ɗəm mis àməta ti àŋgaba e kisim ba koksah. Nahkay nday nakəŋ tə̀hi ana Yezu ahkado : ");
INSERT INTO muy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","« Mʉsi, Mʉwiz àɗəm ahkado : “Tamal mis àməta, wal gayaŋ èwii wur ndo nahəma, ahàr àɗəm wur ga məŋ ga zal ni azay wal ni, ti tîwia mekeji ana wur ga məŋani ya àmət na.” ");
INSERT INTO muy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yaw mis ndahaŋ tə̀bu afa geli nday adəskəla kà məŋ gatay, gəɗakani gatay ni àda wal a. Àra àza wal na ti èwifiŋa wur a ndo, mək zal ni àməta. Àra àməta àmbərba wal gayaŋ na ti mimbiki ga zal ni àzay. ");
INSERT INTO muy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Àra àza wal na ti naŋ day èwifiŋa wur a ndo, mək àməta. Mimbiki gayaŋ ye cʉ ni day àgray nahkay, mək àməta. Nahkay nday adəskəlani ni ɗek tàza wal na day tìwifiŋa wur a ndo mək nday ɗek tə̀məta. ");
INSERT INTO muy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kələŋ gani wal ni day àra àməta. ");
INSERT INTO muy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ay ka fat ya ti mis ɗek ataŋgaba e kisim ba nahəma, wal ni ti way bəlaŋ e kiɗiŋ gatay adəskəlani ni bu amazay way ? Nday ɗek tàza naŋ a ni. » ");
INSERT INTO muy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ay Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm ahkado : « Majalay ahàr gekʉli ti kigeni do, aɗaba kìcʉmaba ma ga Wakita ge Melefit ya Mʉwiz àbəki na ndo, kə̀sərum njəɗa ge Melefit do palam. ");
INSERT INTO muy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nəɗəm nahəma, ka ya ti mis atəməta mək ataŋgaba e kisim ba ni ti zawal ataday wál va do, wəwal day ataday zawal va do. Atanjəhaɗ ɗek akaɗa ga *məslər ge Melefit ya tə̀bu a huɗ melefit bu ni sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ay tamal ti mazlapaki ka ma ge mis ya taŋgaba e kisim ba nahəma, kèjeŋgʉm ma ge Melefit ya àhi ana kʉli ni ndo waw ? Melefit àɗəm : ");
INSERT INTO muy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nu Melefit ga Abraham, nu Melefit ga Izak, nu Melefit ge Zekʉp.” Melefit ti naŋ Melefit ga ndam ya àna sifa ni, do ni ti ga nday ya tə̀məta ni do. » ");
INSERT INTO muy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mis dal-dalani ni tə̀bu tici zlam gayaŋ ya acahi ana tay ni ti ma gayaŋ ni àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ndam *Feriziyeŋ ni tə̀səra Yezu àwəlkia ndam *Sedʉseyeŋ na ka pakama. Tàra tə̀səra nahkay nahəma, tə̀cakalavu ");
INSERT INTO muy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","mək bay *məsər Wakita ge Melefit bəlaŋ e kiɗiŋ gatay bu awayay ahəlfəŋa eyʉ kà Yezu a, nahkay àhi : ");
INSERT INTO muy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","« Mʉsi, *Divi ge Melefit ya ti ahàr àɗəm mis tə̂gəskabu enji ni ti weley ? » ");
INSERT INTO muy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yezu àhəŋgrifəŋ, àhi : « “Wayay Bay Melefit gayak àna huɗ bəlaŋ, àna sifa gayak ɗek akaba àna majalay ahàr gayak ɗek.” ");
INSERT INTO muy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hini gani ti Divi ye enjenjeni, Divi ya ti ahàr àɗəm mis tə̂gəskabu enji ni. ");
INSERT INTO muy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Divi ye cʉ ya ahàr àɗəm mis tə̂gəskabu ni ti nihi : “Wayay ndam ya ti nak kə̀bu akaba tay ni akaɗa ya kawayay ahàr gayak gayakani ni.” ");
INSERT INTO muy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Divi ge Melefit ya àɗəfiki ana Mʉwiz ni akaba pakama ga ndam ndahaŋ ya tàhəŋgaray *pakama ge Melefit ni ɗek ti tə̀vu e Divi cʉeni hini bu. » ");
INSERT INTO muy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ndam *Feriziyeŋ ni nday tə̀bu macakalavani nahkay ti Yezu àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","« Lekʉlʉm ti kə̀humi ana ahàr *Krist *Bay gəɗakani ya amara ni ti naŋ way ? Naŋ wur ga way ? » Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Naŋ ti *Wur ge Devit. » ");
INSERT INTO muy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yezu àhi ana tay ahkado : « Tamal nahkay ti ahəmamam Devit naŋ naŋani àna ahàr gayaŋ àɗəm Bay gəɗakani ya amara ni ti bay gayaŋ ni mam ? Àɗəm ma gani àna njəɗa ga *Məsuf ge Melefit, ma gani nani ti nihi : ");
INSERT INTO muy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Bay Melefit àhi ana bay goro : Njəhaɗa gwar kà ahar ga ɗaf goro a, a məlaŋ ga gəɗakani va. Ndam ezir gayak ti anabəhaɗ tay kè meleher gayak akaɗa ga zlam ga bay ya abəki asak ni, ti kə̂cəlki ka tay.” ");
INSERT INTO muy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","« Nəɗəm nahəma, Krist nani ti Devit azalay naŋ bay gayaŋ ti, təzalay naŋ *Wur ge Devit keti ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yezu àra àɗəma ma nahkay ti maslaŋa ya ti esliki məhəŋgrifəŋani ni ti àbi. Kwa ka fat nani maslaŋa ya ti azay njəɗa gayaŋ ge mihindifiŋa ma nahaŋ a ni ti àbi va bi. ");
INSERT INTO muy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nahkay ka ya ti mis ɗek tə̀bu təbi slimi ana ma ga Yezu nahəma, Yezu nakəŋ àhi ana mis dal-dalani ni akaba ana ndam maɗəbay naŋ ni ahkado : ");
INSERT INTO muy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","« Ndam *məsər Wakita ge Melefit ni akaba ndam *Feriziyeŋ ni ti Melefit àdaba tay ga məɗəfiaba *Divi ge Melefit ya Mʉwiz àbəki na ana mis a. ");
INSERT INTO muy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Gəsumiki pakama gatay ni ana tay, grum ere ye ti tə̀hi ana kʉli ni ɗek, ay ti kə̀grum zlam gatay ya tagray ni ba, aɗaba tàgray zlam ya təɗəmaya ni do. ");
INSERT INTO muy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pakama gatay ya tə̀hi ana mis grum ni ti akaɗa zlam məɗəsani dal-dal ya təwəlkabu, təhəlkiyu ke mis ni, ay ti nday ndayani ku àna weleher tekeɗi tàwayay məjənaki tay do. ");
INSERT INTO muy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tʉwi gatay ya tagray ni ɗek ti tawayay ti mis tə̂ɗəm àɓəlay. Nahkay zlam gatay ya ti təwəlkabu ni ti gəɗakani àtam ge mis ndahaŋ ni. Zlam ya ti təɗəməkkiyu ka mugudi gatay ni day zəbalani àtam ge mis ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tawayay manjəhaɗvani e kʉrsi ga gəɗákani vu ka məlaŋ məzum zlam ga wuməri akaba a ahay ga *mahəŋgalavù Melefit bu. ");
INSERT INTO muy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Tawayay ti mis tə̂gri sa ana tay a gosku bu kè meleher ge mis ɗek. Tawayay ti mis tə̂zalay tay “Mʉsi.” ");
INSERT INTO muy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ay lekʉlʉm zla ti kàwayum ti mis tə̂zalay kʉli “Mʉsi” ba, aɗaba lekʉlʉm ɗek ti kà məŋ gekʉli, Mʉsi gekʉli day naŋ bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mis ya ka haɗ ni ti kàzalum tay “baba” ba. Aɗaba Bəŋ gekʉli ti naŋ bəlaŋ, naŋ e melefit bu. ");
INSERT INTO muy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kàwayum ti mis tə̂zalay kʉli “gəɗákani” ba, aɗaba Gəɗakani gekʉli ti naŋ bəlaŋ, nani *Krist. ");
INSERT INTO muy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maslaŋa ya ti naŋ gəɗakani e kiɗiŋ gekʉli bu ni ti bay ya ti aməgri tʉwi ana kʉli ni. ");
INSERT INTO muy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nahkay day maslaŋa ya ti awayay gəɗakani ni lu, Melefit amafəkaɗ naŋ kələŋ ge mis ɗek. Ay maslaŋa ya ti àɗəm naŋ kələŋ ge mis ɗek ni day, Melefit aməvi məlaŋ gəɗakani. » ");
INSERT INTO muy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","« Lekʉlʉm ndam *məsər Wakita ge Melefit akaba ndam *Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni ti akəsum cicihi, aɗaba kə̀bum kəcumfəŋa mis ndahaŋ ga məhuriyani a *Məgur ge Melefit va. Lekʉlʉm lekʉlʉmeni day kə̀hurumiyu do, kəcumfəŋa ndam ya tawayay məhuriyani na daya.  ");
INSERT INTO muy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Aɗaba kə̀bum kəhəlumfəŋa zlam ga wál madakway a ɗek, kə̀bum kəpəsumki ka mahəŋgalay Melefit, kawayum ti mis tə̂ɗəm lekʉlʉm mis sulumani. Azuhva nani seriya ya ti Melefit amagrafəŋa kè kʉli a ni amatam ge mis ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Lekʉlʉm kə̀bum kədəgum ka haɗ ndahaŋ gərgəri kay ku àna asak, ku àna *slalah ga yam, ti kə̂ŋgətum ku mis bəlaŋ ga maɗəbay kʉli. Ay tamal ti kə̀ŋgətuma maslaŋa bəlaŋ nahəma, kəgrum ti mâgudar zlam atam gekʉli ni sak cʉ ; nahkay egi maslaŋa ya ti Melefit ezligiyu naŋ a *dəluv ga aku vu di ni akaɗa ya ti aməbiyu kʉli ni. ");
INSERT INTO muy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","« Lekʉlʉm ndam wuluf ya kədumfəŋa ahar ka ndam wuluf ndahaŋ a ni, akəsum cicihi. Aɗaba kə̀bum kəɗəmum : “Maslaŋa ya ti àmbaɗa àna *ahay gəɗakani ge Melefit na ti mbaɗay ni àzum naŋ do, ay tamal àmbaɗa àna gru ya taŋgah a ahay gəɗakani ge Melefit ni ba ni ti mbaɗay ni azum naŋ.” ");
INSERT INTO muy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lekʉlʉm ti ndam wuluf murani eɗeɗiŋ. E kiɗiŋ ga ata ahay gəɗakani ge Melefit ni nday ata gru ni bu ni ti gəɗakani ti weley ? Gəɗakani ti gru ni tək day ti ahay gəɗakani ge Melefit ya agray ti gru ni mîgi *njəlatani ni aw ? ");
INSERT INTO muy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kə̀bum kəɗəmum keti : “Maslaŋa ya ti àmbaɗa àna məlaŋ ya ti *teviyekiki zlam ana Melefit na ti mbaɗay ni àzum naŋ do, ay tamal àmbaɗa àna zlam ya ti teviyekki na ti mbaɗay ni azum naŋ.” ");
INSERT INTO muy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lekʉlʉm ti wulufani eɗeɗiŋ. E kiɗiŋ ga məlaŋ ya ti teviyekiki zlam ana Melefit ni nday ata zlam ya teviyekki ni bu ni ti gəɗakani ti weley ? Gəɗakani ti zlam ya teviyekki ni tək day ti məlaŋ ya agray ti zlam ni mîgi njəlatani ni aw ? ");
INSERT INTO muy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maslaŋa ya ti ambaɗay àna məlaŋ meviyekiki zlam ana Melefit ni ti àmbaɗay àna naŋ ciliŋ do, àmbaɗay ti àna zlam ya ti teviyekki ni daya. ");
INSERT INTO muy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Maslaŋa ya ti ambaɗay àna ahay gəɗakani ge Melefit ni ti àmbaɗay àna ahay ni ciliŋ do, àmbaɗay ti àna Melefit ya naŋ àvu ni daya. ");
INSERT INTO muy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Maslaŋa ya ti ambaɗay àna huɗ melefit ni ti àmbaɗay àna huɗ melefit ti ciliŋ do ; àmbaɗay ti àna kʉrsi ge Melefit, àna Melefit naŋ ya naŋ àvu gappa manjəhaɗviyani ni daya. ");
INSERT INTO muy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Aɗaba azagat, matakavay akaba slimberi ndahaŋ ya tidi eli àna tay ni tekeɗi, kə̀bum kəzumiaba biliŋ a huɗ ga kruani ba ana Melefit a. Ay *Divi ge Melefit tə̀bu, tə̀tam nday ya ti kəgəsumkabu ni : magray jiri, məgri zlam sulumani ana mis akaba mawayay Melefit. Divi nday nani ti kə̀gəsumkabu do. Giri-giri ti ere ye ti amal kəgrum enji ni ti nday gani, day kwa ti kəgrum zlam ndahaŋ ya Mʉwiz àɗəm grum ni. ");
INSERT INTO muy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lekʉlʉm ndam wuluf ya kədumfəŋa ahar kà ndam wuluf ndahaŋ a ni, kə̀bum kaŋgazumaba zlam gekʉli ya kisʉm na, kə̀humi ana ahàr bi ezʉwi àdəkiviya, ay ti kìpʉmkivu ezligwemi ya àkibu ni do kəndum akaba naŋ. ");
INSERT INTO muy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Aɗaba lekʉlʉm kə̀bum kabarumfəŋa aləŋ ge hijiyem akaba aləŋ ga halaf a, ambatakani do a huɗ gekʉli bu ni ti akal akaba cuɗay cisl cisl. ");
INSERT INTO muy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lekʉlʉm ndam Feriziyeŋ ti ndam wuluf ! Barumfəŋa huɗ ge hijiyem na enji a day, nahkay ti aləŋ gani day emigi njəlata. ");
INSERT INTO muy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Aɗaba lekʉlʉm kə̀bum akaɗa mindiviŋ ya tàgrakia yam ga zlam bəɗ-bəɗana amənjavu gwar ka dala ti àɓəlay, ambatakani do a huɗ gani bu ni ti aslat ge mis akaba zlam magədavani gərgəri tə̀vu cisl cisl ni. ");
INSERT INTO muy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Lekʉlʉm day nahkay, mis tamənjaləŋ kè kʉli ti akaɗa lekʉlʉm ndam jireni, ambatakani do cuɗay akaba masəkaɗ malfaɗa tə̀niki ka məɓəruv ana kʉli dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","« Lekʉlʉm ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ, lekʉlʉm ya ti kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni ni, akəsum cicihi. Aɗaba lekʉlʉm kə̀bum keɗezlʉmkiyu mindiviŋ ga ndam mahəŋgaray *pakama ge Melefit ya ahaslani ni lala, kə̀bum keŋgʉleɗʉm mindiviŋ ga ndam jireni, ");
INSERT INTO muy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mək kəɗəmum ahkado : “Tamal ka ya ti ata bəŋ geli tàbazl ndam mahəŋgaray pakama ge Melefit ni leli day mə̂ləbu ti akal leli mə̀gəsiki ana tay ga mabazl ndam mahəŋgaray pakama ge Melefit ni ndo.” ");
INSERT INTO muy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nahkay lekʉlʉm lekʉlʉmani kəgrumkia sedi ka ahàr gekʉli a, kə̀ɗəmum lekʉlʉm bəza ga ndam ya tàbazl ndam mahəŋgaray pakama ge Melefit ni. ");
INSERT INTO muy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nahkay ti ndeveriŋʉm tʉwi ga ata bəŋ gekʉli ya tə̀njəki ni, kə̀mbrəŋum ba ! ");
INSERT INTO muy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lekʉlʉm ti zlam a haɗ, lekʉlʉm medékw ! Akatamumfəŋa kà dəluv ga aku ya Melefit amatraɓ kʉli àna naŋ na ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nahkay ti nara nəsləribiyu ndam mahəŋgaray pakama ge Melefit ana kʉli, ndam məsər zlam akaba ndam məsər Wakita ge Melefit ana kʉli ; akabazlum ndahaŋ, akadarumfəŋ ndahaŋ kà təndal, akəzləɓum ndahaŋ àna kurupu a ahay gekʉli ya *kahəŋgalumvù Melefit ni bu, ndahaŋ ti ni akəɗəbumoru tay ka kəsa ka kəsa ga məgri daliya ana tay. ");
INSERT INTO muy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nahkay ti ndam jireni ya mis tàbazl tay ni ɗek ti seriya gani amədəɗki ke kʉli, aɗaba kala kàbazlum tay ti lekʉlʉm lekʉlʉmeni. Ànjəkibiyu kwa ka ga Abel àbivaya ana ga Zakari wur ge Berisi na. Kə̀kaɗum Zakari ti e kiɗiŋ ga məlaŋ meviyekiki zlam ana Melefit ata məlaŋ *njəlatani ga ahay gəɗakani ge Melefit ni bu. ");
INSERT INTO muy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nəhi ana kʉli nahəma, zlam ya mis tàgudarbiyu ni ɗek ti seriya gani amədəɗki ka ndam ye e hini vu ni. » ");
INSERT INTO muy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","« Ndam Zerʉzalem, ndam Zerʉzalem, kə̀bum kabazlum ndam mahəŋgaray *pakama ge Melefit, kə̀bum kabazlum ndam ya ti Melefit asləribiyu tay ana kʉli ni àna mizligi tay àna akur daya. Sak ehimeya nàwaya macakalakabá kʉli a akaɗa ga məŋ ge mickʉr ya acakalakabu bəza gayaŋ, abəki kərpasla gayaŋ ka tay ni. Ay ti lekʉlʉm kə̀cuhwum ndo. ");
INSERT INTO muy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nahkay ti Melefit aməmbrəŋ ahay gekʉli ni amanjəhaɗ gweŋa. ");
INSERT INTO muy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nəhi ana kʉli nahəma, ekipʉm nu e eri vu va do. Ekipʉm nu wuɗaka ti si kə̀ɗəmuma “Bay Melefit mə̂gri sulum gayaŋ ana maslaŋa ya ti amara àna slimi gayaŋ a ni” day kwa. » ");
INSERT INTO muy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ka ya ti Yezu àhəraya a *ahay gəɗakani ge Melefit ni ba, naŋ àbu asləka ni ti ndam maɗəbay naŋ ni tàhəɗakfəŋiyu tə̀hi ahkado : « Mənjaki ahəmamam tə̀ləm ahay gəɗakani ge Melefit ni day ti ! » ");
INSERT INTO muy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eslini Yezu àhi ana tay ahkado : « Kìpʉma ahay hini meɗezleni na do waw ? Nəhi ana kʉli nahəma, etembeɗkaba besek-besek, ku akur bəlaŋ day amanjəhaɗki ka akur nahaŋ va do. » ");
INSERT INTO muy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yezu naŋ àbu manjəhaɗani digʉsa ka ahàr gayaŋ ka həma *Oliviye nahəma, ndam maɗəbay naŋ ni tàhəɗakfəŋiyu mək tìhindifiŋa ma, tə̀hi ahkado : « Hiaba ana leli a, ere gani amagravu ti ananaw ? Aməsərkaba sarta ya akəŋga akaba sarta ga mandav ga duniya ni ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eslini Yezu nakəŋ àhi ana tay ahkado : « Bumvu slimi maslaŋa àgosay kʉli ba. ");
INSERT INTO muy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aɗaba mis kay atara, ku way way do aməɗəm naŋ ti nu, aməɗəm naŋ ti *Krist *Bay gəɗakani ya amara ni. Nahkay atagosay mis kay. ");
INSERT INTO muy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mis atagray silik kè cifeni akaba kè driŋeni, ekicʉm ma gani. Kìcʉma ti kə̀grum aŋgwaz ba. Ahàr àɗəm zlam nday nani tâgravu kwa. Ku tamal tàgrava nahkay nəŋgu ni, mandav ga duniya faŋ do. ");
INSERT INTO muy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ndam ga haɗ ndahaŋ atakaɗvu akaba ndam ga haɗ ndahaŋ, bəbay ndahaŋ akaba bəbay ndahaŋ. Haɗ amadaɗay a kəsa gərgərani ndahaŋ bu, lʉwir day amələbu a kəsa gərgərani ndahaŋ bu. ");
INSERT INTO muy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Zlam nday nani ɗek ti mənjəki ga daliya ciliŋ, tə̀zavu akaɗa ga wur ya ajibiyu aslər ana wal a huɗ bu ni. ");
INSERT INTO muy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","« Eslini atəgəsi kʉli ana mis ndahaŋ ga məgri daliya ana kʉli, atabazl kʉli daya. Mis ga duniya ɗek etizirey kʉli aɗaba lekʉlʉm ndam goro. ");
INSERT INTO muy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ka sarta gani nani ti mis dal-dal atəmbrəŋ məfəku ahàr, etizirevu, atəsəkumoru mis gatay ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndam ya tə̀ɗəm nday ndam mahəŋgaray *pakama ge Melefit ambatakani do tasəkaɗ malfaɗa ni atələbu dal-dal, atagosay mis kay dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nahkay ti atagudarkivu zlam, mis dal-dal atawayavu akaɗa ya ahaslani va do. ");
INSERT INTO muy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ay ti maslaŋa ya ti aməmbrəŋ nu do duk abivoru ana vaɗ ga mandav ga sifa gayaŋ ni ti Melefit amahəŋgay naŋ. ");
INSERT INTO muy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wuɗaka duniya andav nahəma, ahàr àɗəm mis tə̀hia *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit na ana mis ga haɗ gərgərani na ɗek, ti nday ya ti nday ndam *Zʉde do ni ɗek tîci ma gani day kwa. Kələŋ gani duniya amandav hʉya. » ");
INSERT INTO muy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yezu àɗəm keti : « Kə̀səruma, ahaslani bay mahəŋgaray *pakama ge Melefit Deniyel àɗəmki ma ka zlam magədavani ya ti àɓəlay do ferereni, eziŋ zlam ɗek ni. Zlam gani amagravu ; amagrava ti ekipʉm naŋ ka məlaŋ *njəlatani. » (Bay ya ti ejeŋgey ma hini ti ahàr àɗəm mîci lala). ");
INSERT INTO muy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","« Ekipʉma naŋ a ti ahàr àɗəm ndam ya ka haɗ *Zʉde ni tâcuhworu a həma vu kwa. ");
INSERT INTO muy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maslaŋa ya ti naŋ ka *dalahar ga ahay gayaŋ ni àhəraya, àhuriyu a ahay vu ga məhəlaya zlam gayaŋ a day ba. Mâhəraya mâcuhway sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Maslaŋa ya ti naŋ a vədaŋ bu ni ti ni, àŋga a magam a ga mara mazay azana gayaŋ ba. Mâcuhway sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ka sarta gani nani ti wál a huɗ akaba nday ya ti bəza tə̀fəŋ kà tay ka ahar ni atasay cicihi ! ");
INSERT INTO muy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nahkay ti həŋgalum Melefit ti ere gani nani àgravu ge milevi ahkay do ni a vaɗ *məpəsabana va ba, ");
INSERT INTO muy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","aɗaba ka sarta gani nani ti mis atəcakay daliya kay àtam daliya ndahaŋ ya mis tə̀cakabiyu kwa ahaslani ka mənjəki ga məlaŋ ni duk àbivaya ana kana ni. Kələŋ ga daliya nani ti daliya ndahaŋ atələbi akaɗa nani ɗay-ɗay va bi. ");
INSERT INTO muy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Melefit àɗəm sarta gani nani aməpəs do, do ni ti maslaŋa àbi amatamfəŋa kà daliya nana bi. Melefit àɗəm aməpəs do ni ti azuhva ndam gayaŋ ya àdaba tay a ni palam. ");
INSERT INTO muy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","« Ka sarta gani nani ti tamal maslaŋa ahi ana kʉli ahkado : “Pʉm *Krist naŋ àbu ahalay !” ahkay do ni : “Naŋ àbiyu tegi !” nahəma, kə̀gəsumiki ma gayaŋ ni ba. ");
INSERT INTO muy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aɗaba mam ? Ndam ndahaŋ atara tasəkaɗ malfaɗa, ku way way do aməɗəm naŋ Krist ahkay do ni naŋ bay məhəŋgri ma ge Melefit ana mis. Atagray zlam ya ti mis tàgray koksah, mis tìpi ɗay-ɗay ndo ni akaba zlam ya ti aməgri ejep ana mis ni. Tamal agravu tata ni, tawayay mesipet ndam ya ti Melefit àdaba tay a ni. ");
INSERT INTO muy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lekʉlʉm zla nahəma, bumvu slimi, aɗaba nə̀hiva ana kʉli àndava. ");
INSERT INTO muy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","« Tamal ti tə̀hi ana kʉli ahkado : “Naŋ àbiyu a huɗ gili bu !” ti kə̀dəgum ba ; tamal tə̀hi ana kʉli ahkado : “Naŋ àbu məɓuani ahalay hi !” ti kə̀gəsumiki ma gatay ni ana tay ba. ");
INSERT INTO muy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nu *Wur ge Mis anaŋga ti mis etipi nu akaɗa ga avər ya abay aku kwa gwar egezi akoru àna naŋ cekw agavəla ni. ");
INSERT INTO muy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nəhi ana kʉli nahəma, ka məlaŋ ya zlam məmətani àvu ni ti mambá təcakalavu eslini. » ");
INSERT INTO muy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yezu àɗəm keti : « Ay ka sarta gani nani, kələŋ ga daliya ni zla nahəma, fat amacaɗay məlaŋ va do hʉya, kiyi day amaslaɗay məlaŋ va do. Boŋgur atətəɗbiyu e melefit bu, atadəgaya a ga haɗ a, zlam njəɗa-njəɗani a huɗ melefit bu atədaɗay a məlaŋ gatay bu daya. ");
INSERT INTO muy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Eslini zlam nahaŋ amaŋgazlavu a huɗ melefit bu ; àna zlam gani nani ti mis atəsər nu *Wur ge Mis nə̀bu naŋga. Ka sarta gani nani ti mis ga duniya ɗek etitʉwi, etipi nu Wur ge Mis anara ka maklaɓasl àna njəɗa kay akaba maslaɗay goro a dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ka sarta gani nani ti anəslərbiyu *məslər ge Melefit, etivibiyu mezlelim gəɗakani, atəcakalakabu ndam ya Melefit àdaba tay a ni kè sliri ga məlaŋ faɗani ni ɗek ; ku ka məlaŋ driŋeni weley weley do ɗek atəcakalakabu mis ka ahar bəlaŋ. » ");
INSERT INTO muy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","« Nazay mazavu gani akaɗa ga məŋ ga *wəruv ni, ahàr àɗəm kicʉm kwa : ka ya ti àbakaba slimberi a mək eɗi nahəma, kə̀səruma mədərdər ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nahkay day tamal kìpʉma zlam ya nə̀hi ana kʉli ni naŋ àbu agravu nahəma, sərumki nu *Wur ge Mis nə̀bu cifa, nìnjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nəhi ana kʉli nahəma, wuɗaka mis ya tə̀bu ka dala nihi ni təmət ɗek ti zlam nday nani ɗek amagrava day kwa. ");
INSERT INTO muy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Məlaŋ ya agavəla akaba məlaŋ ya a ga haɗ ni amandav, ay ti ma goro ya nə̀ɗəm ni amandav ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yezu àɗəm keti : « Ay ti ma ga vaɗ gani akaba njemdi gani zla nahəma, maslaŋa àbi àsər bi. *Məslər ge Melefit ya a huɗ melefit bu ni day tə̀sər do, nu Wur ge Melefit tekeɗi nə̀sər do, si Baba Melefit day kwa ti àsəra ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ere ye ti àgravu ke zemeni ge Nʉwi ni amagravu ka fat ya ti nu *Wur ge Mis anaŋga ni. ");
INSERT INTO muy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ke zemeni gani nani wuɗaka yam eziŋ məlaŋ ɗek ni ti mis tə̀bu təzum zlam, tisi zlam, taday wál, wál day taday zawal. Nday tə̀bu tagray zlam nday nani nahkay duk àbiviyu ana vaɗ ya ti Nʉwi àhuriyu a *slalah ga yam gəɗakani vu ni. ");
INSERT INTO muy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Eslini yam ni àra èziŋ tay kəɗap ka məsər gatay do. Nu Wur ge Mis day anara ka sarta ya ti mis tə̀jalaki ahàr do ni. ");
INSERT INTO muy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nəhi ana kʉli nahəma, ka ya ti anaŋga ni ti ku tamal mis cʉ nday a vədaŋ bu nəŋgu ni atazay bəlaŋ gani, atəmbərbu bəlaŋ gani ti amagravu tata. ");
INSERT INTO muy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ku tamal wál cʉ tihikabu humbu ka ahar bəlaŋ nəŋgu ni, atazay bəlaŋ gani, atəmbərbu bəlaŋ gani ti amagravu tata. ");
INSERT INTO muy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nahkay ti njəhaɗum eri, aɗaba kə̀sərum vaɗ ya ti nu Bay gekʉli anara ni do. ");
INSERT INTO muy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cʉm day, tamal bay ahay àsəra sarta ga ndam akal ya atara ga məlavaɗ ga məzləl naŋ na ti anjəhaɗ eri, àmbrəŋ tay ga mara məhuriyani a ahay gayaŋ vu do. ");
INSERT INTO muy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nahkay lekʉlʉm day slamatumvu lala, aɗaba nu Wur ge Mis anara ti ka sarta ya ti lekʉlʉm kàjalumki ahàr do ni. » ");
INSERT INTO muy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yezu àɗəm keti : « Bay magray tʉwi lala, andikabu ana bay ya agri tʉwi ni, àsəra zlam a ni ti way ? Bay nani ti bay ya ti naŋ agri tʉwi ni ambərfəŋ tʉwi ga huɗ ahay gayaŋ ɗek a ahar vu. Ambərfəŋ tʉwi ga məvi zlam məzumani ana ndam məgri tʉwi ndahaŋ àna sarta gani daya. ");
INSERT INTO muy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bay magray tʉwi nani ti tamal bay ya naŋ agri tʉwi ni àsləkabiya àdi ahàr, naŋ àbu agray tʉwi lala nahəma, bay məgri tʉwi nani aməmərvu. ");
INSERT INTO muy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nəhi ana kʉli nahəma, bay ya təgri tʉwi ni aməmbrivu elimeni gayaŋ ɗek a ahar vu. ");
INSERT INTO muy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ay bi bay magray tʉwi ni àhi ana ahàr ahkado : “Bay ya ti nəgri tʉwi ni àsləkabiya weceweci do.” ");
INSERT INTO muy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nahkay anjəki ka məzləɓ ndam ya tagrakabu tʉwi ni. Azum zlam zlam gayaŋ, esi zum akaba ndam ya tisi zum dal-dal, eviyi ahàr ana tay ni. ");
INSERT INTO muy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Naŋ àbu agray nahkay ti bay ya təgri tʉwi ni amasləkabiya ka fat ya bay məgri tʉwi ni àjalaki ahàr do ni, àna njemdi ya ti àsər do ni. ");
INSERT INTO muy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Eminjia ti amatraɓ naŋ dal-dal, aməgri daliya akaɗa ya agri ana nday ndahaŋ ya ti tə̀hi ana ahàr nday ndam jireni ni. Eslini ti emitʉwi, amacakay daliya dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yezu àɗəm keti : « Ere ye ti amagravu ka fat gani nani a *Məgur ge Melefit ni bu ni ti àzavu akaba bəza dahalay kru, tə̀həla ceŋgel gatay a ahar va, takoru tabakabu ahàr akaba bay maday wal ni. ");
INSERT INTO muy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E kiɗiŋ ga bəza dahalay kruani ni bu ni ti zlam gani murani, ndahaŋ zlamani ni ti ni wir-wireni. ");
INSERT INTO muy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nday zlamani murani ni tə̀cahvu amal e ceŋgel gatay vu ciliŋ, tə̀cah amal nahaŋ a ahar vu ndo. ");
INSERT INTO muy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ay ti nday wir-wireni ni tə̀cahva amal e ceŋgel gatay va mək tə̀caha amal nahaŋ a ahar va ju. ");
INSERT INTO muy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bay maday wal ni àra weceweci ndo ni ti bəza dahalay kruani ni ɗek ere ge ɗʉwir àgəsa tay a, tə̀dəguya e ɗʉwir va. ");
INSERT INTO muy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","« Huɗ ya vaɗ àra ègia ti tìci zlahay ahəndabiyu : “Bay maday wal ni ènjia, hərumaya, ŋgumivoru a ma vu.” ");
INSERT INTO muy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nahkay bəza dahalay ni ɗek tèpiɗekvu. Tàra tèpiɗekva ti tə̀slamalakabu ceŋgel gatay. ");
INSERT INTO muy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eslini bəza dahalay murani ni tə̀hi ana nday wir-wireni ni ahkado : “Cəhumifəŋa amal gekʉli na ana leli a ti, aɗaba ceŋgel geli ni aku awayay amətkia.” ");
INSERT INTO muy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ay nday wir-wireni ni tə̀həŋgrifəŋ ana tay, tə̀hi ana tay ahkado : “Àgravu do, aɗaba emisli ana leli akaba kʉli do. Hojo dəgum afa ga ndam ya təsəkumoru ni ti kə̂səkumumbiya.” ");
INSERT INTO muy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ka ya ti nday nakəŋ tàdəgoru takoru təsəkumbiyu amal ni ti bay maday wal ni ti ni ènjia. Nahkay bəza dahalay zlamani wir-wireni ya tə̀slamalava ni tə̀huriyu akaba bay maday wal ni a ahay ga wuməri ni vu, mək ndam ga wuməri ni tə̀zləkvù mahay. ");
INSERT INTO muy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kələŋ gani bəza dahalay ndahaŋ zlamani ni tìnjia, tə̀ɗəm ahkado : “Bay geli, bay geli, zləkiaba mahay na ana leli a ti !” ");
INSERT INTO muy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naŋ nakəŋ àhi ana tay : “Nəhi ana kʉli nahəma, nə̀sər kʉli do.” » ");
INSERT INTO muy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nahkay Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Njəhaɗum eri, aɗaba kə̀sərum vaɗ akaba sarta goro ya anara ni do. » ");
INSERT INTO muy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yezu àhi ana tay keti : « Nu *Wur ge Mis anaŋga ti akaɗa ga maslaŋa ya naŋ àbu akoru e mirkwi gayaŋ ni. Ara asləka wuɗak nahəma, àzalakabu ndam məgri tʉwi gayaŋ mək ambribu elimeni gayaŋ ana tay a ahar vu. ");
INSERT INTO muy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Naŋ nakəŋ èdi siŋgu ana tay : àvi ana ku way way do akaɗa gayaŋ ya esliki magray tʉwi àna naŋ di ni ; àvi ana bəlaŋ gani siŋgu ga gru miliyem zlam, ana nahaŋ ni miliyem cʉ, ana nahaŋ ni ti ni miliyem. Kələŋ gani, naŋ nakəŋ àsləka. ");
INSERT INTO muy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nahkay naŋ ya ti tə̀bi siŋgu ga gru miliyem zlamani ni àmbatvu àna naŋ mək àŋgətki siŋgu ga gru miliyem zlam. ");
INSERT INTO muy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Naŋ ya ti tə̀bi siŋgu ga gru miliyem cʉeni ni day àmbatvu àna naŋ mək àŋgətki siŋgu ga gru miliyem cʉ. ");
INSERT INTO muy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ay maslaŋa ya tə̀bi siŋgu ga gru miliyem ni òru àŋgah, èliyu siŋgu ya bay gayaŋ àvi ni dək a haɗ vu. ");
INSERT INTO muy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","« Bay ya ti təgri tʉwi ni àra àpəsia e mirkwi gayaŋ na ti àsləkabiya. Àra àsləkabiya ti àɗəm tə̂həlibiya zlam gayaŋ na, acalaba. ");
INSERT INTO muy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nahkay maslaŋa ya tə̀bi siŋgu ga gru miliyem zlamani ni àrəkia, àhəlkivabiya siŋgu ndahaŋ miliyem a zlam, àhi ahkado : “Bay goro, àna siŋgu miliyem zlamani ya kə̀bu ni, nàmbatva àna naŋ a, nə̀ŋgətkia ndahaŋ a miliyem zlam.” ");
INSERT INTO muy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Eslini bay ni àhi : “Àɓəlay, nak jireni, nak bay magray tʉwi sulumani. Nihi ti nəfiyu kur kəgur zlam kay, aɗaba kə̀grua tʉwi sulumana àna zlam gʉziteni hini ya nə̀vuk na. Mərvu akaba nu.” ");
INSERT INTO muy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Naŋ ye cʉ ni day àrəkia àhi ahkado : “Bay goro, àna siŋgu miliyem cʉeni ya kə̀bu ni, nàmbatva àna naŋ a, nə̀ŋgətkia ndahaŋ a miliyem cʉ.” ");
INSERT INTO muy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eslini bay ni àhi : “Àɓəlay, nak jireni, nak bay magray tʉwi sulumani. Nihi ti nəfiyu kur kəgur zlam kay, aɗaba kə̀grua tʉwi sulumana àna zlam gʉziteni hini ya nə̀vuk na. Mərvu akaba nu.” ");
INSERT INTO muy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","« Kələŋ gani maslaŋa ya tə̀bi siŋgu ga gru miliyemeni ni àrəkia bilegena, àhi ahkado : “Bay goro, nə̀səra manjəhaɗ gayak a, nak mis zləzlaɗani, kə̀mbrəŋ mis do. Zlam ya ti nak kìzligi ndo ni day kabaz, zlam ya ti kàbəhaɗ hilfi gani ndo ni day kacakalakabu. ");
INSERT INTO muy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nàgrafuka aŋgwaz a. Nahkay nòru nìliyu siŋgu gayak ni a haɗ vu. Nihi za zlam gayak a.” ");
INSERT INTO muy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Eslini bay ni àhi ahkado : “Nak ti kàgray tʉwi sulumani do, nak masəfani. Kə̀səra manjəhaɗ goro a, kə̀ɗəm zlam ya ti nìzligi ndo ni day nabaz, zlam ya ti nàbəhaɗ hilfi gani ndo ni day nəcakalakabu. ");
INSERT INTO muy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tamal kə̀səra nahkay ti hojo amal kə̀via siŋgu goro na ana ndam macakalana, nihi nàsləkabiya ti amal nə̀dia ahàr a èwikia.” ");
INSERT INTO muy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mək àhi ana nday ye eslini ni ahkado : “Zumfəŋa siŋgu na, kəvumikivu ana maslaŋa ya ti siŋgu ga gru gayaŋ miliyem kruani ni.” ");
INSERT INTO muy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eslini àhi ana tay : “Nəhi ana kʉli nahəma, maslaŋa ya ti zlam gayaŋ àbu ni ti atəvikivu, zlam gayaŋ emigi kay dal-dal. Ay maslaŋa ya ti zlam gayaŋ àbi ni ti ku ere ye ti àfəŋ ni day atəzafəŋa. ");
INSERT INTO muy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ay maslaŋa ya ti àgray tʉwi sulumani ndo ni zligumiyu naŋ e mite vu a məlaŋ ziŋ-ziŋeni vu, emitʉwi, amacakay daliya dal-dal.” » ");
INSERT INTO muy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yezu àɗəm keti : « Ka fat ya ti nu Wur ge Mis anaŋga a məlaŋ maslaɗani goro ba akaba *məslər ge Melefit a ɗek ni ti ananjəhaɗ e kʉrsi ga bay goro bu. ");
INSERT INTO muy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eslini mis ga haɗ gərgərani ɗek atəcakalavu kè meleher goro. Mək enedekaba mis a akaɗa ga bay majəgay zlam edekaba təmbəmbak akaba awəwak a ni. ");
INSERT INTO muy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Anabəhaɗ təmbəmbak ni gwar ka ahar ga ɗaf goro, awəwak ni ti ni gwar ka ahar ga gəjar. ");
INSERT INTO muy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nahkay anəhi ana ndam ya ti ka ahar ga ɗaf goro ni ahkado : “Lekʉlʉm ya ti Baba àgria sulum gayaŋ ana kʉli a ni ti dəguma, hərumiyu a *Məgur ge Melefit vu. Məlaŋ gani nani ti Melefit aslamalikabu ana kʉli kwa ka mənjəki ga duniya. ");
INSERT INTO muy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aɗaba ka ya ti lʉwir awər nu ni kə̀vumua zlam məzumana ; ka ya ti yam akaɗ nu ni kə̀vumua yam a ; ka ya ti nara, nu mirkwi afa gekʉli ni kə̀gəsumkabá nu a ; ");
INSERT INTO muy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ka ya ti azana àfu bi ni kə̀vumua azana ; ka ya ti nèɓesey do ni kə̀mənjumiya nu a ; ka ya ti nu a daŋgay bu ni day kə̀mənjumiya nu a.” ");
INSERT INTO muy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Eslini ndam jireni ni atəhəŋgrufəŋ, atəhu : “Bay geli, mìpi kur lʉwir awər kur mək mə̀vuk zlam məzumani ti ananaw ? Mìpi kur yam akaɗ kur mək mə̀vuk yam ti ananaw ? ");
INSERT INTO muy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mìpi kur nak zal mirkwi mək mə̀gəskabu kur ti ananaw ? Mìpi kur azana àfuk bi mək mə̀vuk azana ti ananaw ? ");
INSERT INTO muy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mìpi kur kèɓesey do ahkay do ni nak a daŋgay bu mək mòru məmənjiyu kur ti ananaw ?” ");
INSERT INTO muy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eslini anəhəŋgrifəŋ ana tay anəhi ana tay ahkado : “Nəhi ana kʉli nahəma, zlam ya ti kə̀grumi ana ku bəlaŋ ga bəza ga mma ya ti tìsli araŋa do ni ti kala kə̀grumu ti ana nu.” ");
INSERT INTO muy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","« Kələŋ gani anəhi ana ndam ya ti ka ahar ga gəjar goro ni ahkado : “Sləkumfua, lekʉlʉm ti metikwesleni, dəgum a aku ya àmət ɗay-ɗay do ni vu. Aku nani ti Melefit àgriaya ana seteni a akaba ana ndam məslər ge seteni a. ");
INSERT INTO muy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aɗaba ka ya ti lʉwir awər nu ni kə̀vumu zlam məzumani ndo ; ka ya ti yam akaɗ nu ni kə̀vumu yam ndo ; ");
INSERT INTO muy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ka ya ti nara, nu mirkwi afa gekʉli ni kə̀gəsumkabu nu ndo ; ka ya ti azana àfu bi ni kə̀vumu azana ndo ; ka ya ti nèɓesey do ahkay do ni nu a daŋgay bu ni day kə̀mənjumiyu nu ndo.” ");
INSERT INTO muy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Eslini nday nakəŋ atəhəŋgrufəŋ, atəhu : “Bay geli, mìpi kur lʉwir awər kur, yam akaɗ kur, nak zal mirkwi, azana àfuk bi, kèɓesey do, ahkay do ni nak a daŋgay bu mək mə̀vuk ere gani ndo ahkay do ni mə̀mənjiyu kur ndo ni ti ananaw ?” ");
INSERT INTO muy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Eslini anəhəŋgrifəŋ ana tay anəhi ana tay ahkado : “Nəhi ana kʉli nahəma, zlam ya ti kə̀grumi ana ku bəlaŋ ga bəza ga mma ya ti tìsli araŋa do ni ndo ni ti kala kə̀grumu ana nu ndo.” ");
INSERT INTO muy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nahkay nday gani nani atoru ka məlaŋ ya ti atəcakay daliya ga kaŋgay-kaŋgayani ni. Ndam jireni ni ti ni atoru ka məlaŋ ga *sifa ya àndav ɗay-ɗay do ni. » ");
INSERT INTO muy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yezu àra èndeveriŋa ma gayaŋ ya àɗəm na ɗek ti àhi ana ndam maɗəbay naŋ ni ahkado : ");
INSERT INTO muy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","« Kə̀səruma, vaɗ àvu cʉ tara tagray wuməri ga *Pak. Ka fat gani nani ti atəgəsi nu *Wur ge Mis ana mis mək *atadarfəŋiyu nu kà təndal. » ");
INSERT INTO muy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ tə̀cakalavu a magam afa ga Kayif gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni. ");
INSERT INTO muy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tə̀zlapakabá, tawayay təgəs Yezu àna wir-wir ti tâkaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nday nakəŋ tə̀ɗəm : « Mə̀gəs naŋ a wuməri ni vu ba, aɗaba tamal magray nahkay ti mis dal-dalani ni atəmbrəŋ leli do, etizligeya silik a kəsa va. » ");
INSERT INTO muy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka ya ti Yezu naŋ a Betani naŋ a ahay bu afa ga Simu zal ambələk ni ti ");
INSERT INTO muy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wal nahaŋ àrəkia. Wal nani ti tersel ge siŋgu kayani àfəŋ a kolombu sulumani bu. Ka ya ti Yezu naŋ àbu azum zlam nahəma, wal nakəŋ àbəki tersel ni ka ahàr. ");
INSERT INTO muy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndam *maɗəbay Yezu ni tàra tìpia ti àwəria ɓəruv ana tay a, tə̀ɗəm ahkado : « Àgudar tersel hini ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tersel ni siŋgu gani kay ti, hojo amal tə̀səkumoya ti tìdi siŋgu gani ana ndam talaga do aw ? » ");
INSERT INTO muy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yezu àra ècia ma gatay na ti àhi ana tay ahkado : « Kəhəlumi muru ana wal hini ti kamam ? Zlam gayaŋ ya àgru ni ti àɓəlay. ");
INSERT INTO muy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ndam talaga zla nahəma, nday tə̀bu akaba kʉli kəlavaɗ. Ay nu zla ti ananjəhaɗ akaba kʉli kəlavaɗ do. ");
INSERT INTO muy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wal hini àbəkua tersel ka vu a ti, àslamatakabá nu ga məfiyu nu e eviɗ va. ");
INSERT INTO muy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nəhi ana kʉli nahəma, a məlaŋ bu ɗek, ku eley eley do atəɗəmoru *Ma Mʉweni Sulumani ni zla nahəma, ataŋgəhaɗ ere ye ti wal hini àgray ni daya. Nahkay ti wal ni amagəjazlki ahàr ke mis do. » ");
INSERT INTO muy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kələŋ gani Zʉdas Iskariyot biliŋ a huɗ ga ndam *maɗəbay Yezu kru mahar cʉeni ni bu òru afa ga gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, ");
INSERT INTO muy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","àhi ana tay ahkado : « Nara nəɗəfiki Yezu ana kʉli ti kə̂gəsum naŋ ti kəvumu mam ? » Nday nakəŋ tàra tìcia ma gayaŋ na ti tə̀bi siŋgu akur-akurani kru kru mahkər. ");
INSERT INTO muy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nahkay kwa ka sarta gani nani Zʉdas nakəŋ àɗəbay divi ahəmamam ti ara aɗəfiki Yezu ana tay ti tə̂gəs naŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Vaɗ ye enjenjeni ga wuməri ga *Pak ga məzumvù *dipeŋ miwisiŋeni do ni ènjia. Eslini ti ndam *maɗəbay Yezu ni tə̀rəkia ka Yezu a, tìhindifiŋa ma, tə̀hi ahkado : « Kawayay ti môru mâslamatukkabu zlam məzumani ga wuməri ga Pak ni ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nahkay naŋ nakəŋ àhi ana tay : « Dəgum a kəsa gəɗakani ni vu. Kìnjʉmiya nahəma, akədumi ahàr ana meni ; humi ahkado : “Mʉsi geli àɗəm : Sarta goro ènjia wuɗak. Nara ga məzum zlam ga wuməri ga Pak ni akaba ndam maɗəbay nu ni ti afa gayak.” » ");
INSERT INTO muy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nahkay ndam maɗəbay Yezu ni tòru tàgray ere ye ti Yezu àhi ana tay ni, mək tə̀slamalakabu zlam ga wuməri ga Pak ni. ");
INSERT INTO muy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ga məlakarawa ti Yezu òru àzum zlam akaba ndam maɗəbay naŋ kru mahar cʉeni ni. ");
INSERT INTO muy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka ya ti nday tə̀bu təzum zlam ni ti Yezu àhi ana tay : « Nəhi ana kʉli nahəma, biliŋ gekʉli aməsəkumoru nu. » ");
INSERT INTO muy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ma ga Yezu ya àɗəm ni ti àhəlia ahàr ana ndam maɗəbay naŋ na dal-dal. Way way do biliŋ àna biliŋeni naŋ àbu àɗəm : « Nu do, do waw, Bay goro ? » ");
INSERT INTO muy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eslini Yezu àhi ana tay ahkado : « Maslaŋa ya ti aməsəkumoru nu ni ti, naŋ ya ti mə̀təlkabiyu ahar a halaf vu ni. ");
INSERT INTO muy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nu *Wur ge Mis nara nəmət akaɗa ga pakama ge Melefit ya àɗəm a Wakita gayaŋ bu ni. Ay ti zləzlaɗa afa ga maslaŋa nani ya ti asəkumoru Wur ge Mis ni ! Hojo akal tìwieya naŋ a ndo. » ");
INSERT INTO muy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zʉdas naŋ ya ti ara asəkumoru naŋ ni àhi ahkado : « Nu do, do waw, Mʉsi ? » Yezu àhəŋgrifəŋ, àhi : « Nak nakani kə̀ɗəmaya zlam gayak a. » ");
INSERT INTO muy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ka ya ti təzum zlam nahəma, Yezu àzay *dipeŋ, àgri sʉsi ana Melefit, èsekaba, àvi ana ndam maɗəbay naŋ ni. Àhi ana tay : « Zuma, zumum : hini ti aslu ga vu goro. » ");
INSERT INTO muy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kələŋ gani àzay hijiyem akaba zum, àgri sʉsi ana Melefit keti, àvi ana tay mək àhi ana tay : « Lekʉlʉm ɗek sʉm. ");
INSERT INTO muy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hini hi ti mimiz ga vu goro. Àna mimiz hini ti Melefit awəlkabu pakama gayaŋ akaba ge mis. Aməŋgəzaya a vu goro ba ti ga mahəŋgay mis kay, ti Melefit mə̂mbərfəŋa zlam magudarani ge mis na kà tay a. ");
INSERT INTO muy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nəhi ana kʉli nahəma, enisi zum ge wur ge *viŋ va do, si a vaɗ ya ti enisi zum mʉweni akaba kʉli a Məgur ga Baba bu ni kwa. » ");
INSERT INTO muy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tàra tə̀zuma zlam na ti nday nakəŋ tàzləbay Melefit àna limis, tàhəraya e mite va, tə̀cəloru a həma *Oliviye vu. ");
INSERT INTO muy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nday tə̀bu takoru ti Yezu àhi ana tay : « A huɗ ga məlavaɗ hini bu ni ti lekʉlʉm ɗek ekijʉmkia ke divi a azuhva ere ye ti amagrakuvu ni ; aɗaba àbu məbəkiani a Wakita ge Melefit ni bu, Melefit àɗəm amakaɗkia bay majəgay təmbəmbak na ka tay a, nahkay təmbəmbak ni etedevu kway-kwayay. ");
INSERT INTO muy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Anəmət, ay ka ya ti anaŋgaba e kisim ba nahəma, akədumu ahàr e Gelili. » ");
INSERT INTO muy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piyer àra ècia ma gayaŋ na ti àhi : « Ku mis ɗek tijikia ke divi a, təmbrəŋ kur nəŋgu ni, nu ti nìjikia ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ay Yezu àhəŋgrifəŋ, àhi : « Nəhuk nahəma : nak ti kani kani a a huɗ ga məlavaɗ bu, wuɗaka agwazl azlah nahəma, akəɗəm sak mahkər kə̀sər nu do timey. » ");
INSERT INTO muy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Eslini Piyer nakəŋ àɗəm : « Aha, nahkay do. Nu ti ku tamal ti məmətkabu nəŋgu nahəma, ŋgay nə̀sər kur do ni ti nə̀ɗəm do simiteni. » Ndam *maɗəbay Yezu ndahaŋ ni ɗek day tə̀ɗəm akaɗa ge Piyer ni. ");
INSERT INTO muy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yezu akaba ndam maɗəbay naŋ ni tòru ka məlaŋ nahaŋ, məlaŋ gani nani ti təzalay Gecimeni. Tòru tìnjʉa eslina ti Yezu àhi ana tay : « Njəhaɗuma ahalay a hayaŋ, nakoru tegi nahəŋgalay Melefit. » ");
INSERT INTO muy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Àzalay Piyer akaba bəza ge Zebede cʉeni, tòru cak. Eslini ti Yezu nakəŋ àjalay ahàr dal-dal, məɓəruv àtikaba kwir kwir. ");
INSERT INTO muy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Àhi ana tay : « Məɓəruv atukaba, akaɗa nara nəmət. Njəhaɗuma ahalay a, njəhaɗum eri ga məvu njəɗa. » ");
INSERT INTO muy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nahkay Yezu nakəŋ àhəɗakfəŋa ka tay a òru cak, àndəhaɗ a huɗ a huɗ, àhəŋgalay Melefit, àɗəm ahkado : « Bəba, zlam ɗek kisliki magrani ; həɗakfua daliya hina, nə̀cakay ba ti. Ku nə̀ɗəm nahkay nəŋgu ni, nawayay ti ere ya nak kawayay ni kwa do ni, goro ya nu nawayay ni do. » ");
INSERT INTO muy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Àra àhəŋgala Melefit a nahkay ti àŋgəkia ka ndam maɗəbay naŋ mahkərani na, àdi ahàr ana tay nday e ɗʉwir bu. Èpiɗek tay, àhi ana Piyer : « Kèɓesʉm manjəhaɗani eri ga majəgaki nu njemdi biliŋ koksah aw ? ");
INSERT INTO muy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Njəhaɗum eri, həŋgalum Melefit ti ka ya ti *Seteni esipet kʉli ni ti kìjʉmkia ke divi a ba. Məɓəruv ge mis awayay magray zlam sulumani, ay ti èsliki do, aɗaba aslu ga vu gayaŋ gedebeni. » ");
INSERT INTO muy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yezu àŋgəvù, òru àhəŋgalay Melefit keti, àɗəm : « Bəba, tamal ahàr àɗəm nə̂cakay daliya hini kwa ti, gray akaɗa gayak ya ti kawayay ni. » ");
INSERT INTO muy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Àra àhəŋgala nahkay ti àŋgəkia ka ndam maɗəbay naŋ na keti. Àdi ahàr ana tay, nday e ɗʉwir bu, tàmətaɓkaba ga manjəhaɗana eri a. ");
INSERT INTO muy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Àŋgəvù keti ya mahkər, òru àhəŋgalay Melefit akaɗa gayaŋ nahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Àra àsləkabiya ti àhi ana ndam maɗəbay naŋ ni keti : « Kekileŋa kinjʉm ɗʉwir aw ? Kekileŋa kəpəsumaba waw ? Sarta ènjia. Ŋga pʉm, tara təgəsi nu, nu *Wur ge Mis, ana ndam magudar zlam ni. ");
INSERT INTO muy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cikʉmaba, mədəgumkioru ka tay. Ŋga pʉm, maslaŋa ya ti ara agəsi nu ana tay ni ènjia, do ni ti ahəmamam. » ");
INSERT INTO muy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti Zʉdas biliŋ ga ndam ga Yezu kru mahar cʉeni ni ènjia akaba mis a dal-dal, maslalam akaba aday tə̀fəŋ kà tay. Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ tə̀slərbiyu tay. ");
INSERT INTO muy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wuɗaka nday tara ti Zʉdas bay məsəkumoru Yezu ni àhivabiya ma ana mis dal-dalani na. Àhi ana tay : « Bay ya ti anəgri sa àna məfəki ma kà tuwər nahəma, naŋ gani hʉya. Gəsuma naŋ a. » ");
INSERT INTO muy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Zʉdas nakəŋ àra ènjia ti àrəkia ka Yezu nakəŋ a hʉya. Àhi : « Wʉsi Mʉsi, » mək àgri sa àna məfəki ma kà tuwər. ");
INSERT INTO muy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eslini Yezu àhi : « Zləba goro ni, ere ye ti kə̀rəkia kawayay kagray ni ti gray zlam gayak. » Nahkay mis nakəŋ tàdəgaki ka Yezu cip, tə̀gəs naŋ. ");
INSERT INTO muy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eslini mis biliŋ e kiɗiŋ gatay ya tə̀bu akaba Yezu ni bu àraɗ maslalam fətah, àsifəŋa slimi ana bay məgri tʉwi ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit na həndaɗ. ");
INSERT INTO muy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ay Yezu àhi ahkado : « Həŋguriyu maslalam gayak ni a ahay gani vu. Aɗaba ndam ya ti takaɗvu àna maslalam ni ɗek ti atabazl tay day àna maslalam. ");
INSERT INTO muy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kə̀hi ana ahàr nìsliki mahəŋgalay Baba, mək aslərubiyu məslər gayaŋ dəbu dəbu ehimeya do aw ? ");
INSERT INTO muy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ay tamal nagray nahkay ti pakama ya ti àbu məbəkiani a Wakita ge Melefit bu ni agravu ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eslini Yezu àhi ana mis dal-dalani ya tə̀rəkia ni ahkado : « Kədəgumkua àna maslalam a akaba aday a, kəgəsum nu akaɗa nu zal akal, ambatakani do nə̀bu manjəhaɗani nəcahi zlam ana kʉli a dalaka ga *ahay gəɗakani ge Melefit ni bu kəlavaɗ. Ka gani nani ti kə̀gəsum nu ndo timey. ");
INSERT INTO muy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ay zlam nani ɗek agravu ti ere ye ti ndam mahəŋgaray *pakama ge melefit tə̀ɗəm, àbu məbəkiani a Wakita ge Melefit ni bu ni mâgravu. » Eslini ndam maɗəbay naŋ nakəŋ ɗek tə̀mbərbu naŋ, tə̀dəgiki ana hwa tiɗizl. ");
INSERT INTO muy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tàra tə̀gəsa Yezu a ti tə̀zoru naŋ afa ga Kayif gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni. Ɓa-ɓa ti ndam *məsər Wakita ge Melefit ni akaba gəɗákani ndahaŋ tə̀cakalava eslina. ");
INSERT INTO muy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ka ya ti tə̀bu takoru àna Yezu ni ti Piyer ti ni aɗəboru naŋ kələŋ driŋ duk a dalaka ga ahay ga gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni vu, mək ànjəhaɗ digʉs akaba ndam magray tʉwi ye eslini ni. Awayay epi ere ye ti atəgri ana Yezu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ge seriya ni ɗek tə̀bu taɗəbay zlam magudarani ga məwəlki Yezu ka seriya àna malfaɗa, aɗaba tawayay takaɗ naŋ, ay ti tə̀ŋgət ndo. ");
INSERT INTO muy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eslini mis kay tàsəkaɗki malfaɗa, ay ku tamal nahkay nəŋgu ni tə̀ŋgətfəŋa zlam magudarana ndo. Kələŋ gani mis ndahaŋ cʉ tìcikaba, tàsəkaɗki malfaɗa nahaŋ keti, ");
INSERT INTO muy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tə̀ɗəm : « Leli mìcifiŋa, àɗəm ahkado : “*Ahay gəɗakani ge Melefit ni ti nisliki membeɗkabana. Enembeɗkaba ti a huɗ ga vaɗ mahkərani bu nisliki mələmvana nahaŋ a.” » ");
INSERT INTO muy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Eslini gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni ècikaba cəkwaɗ, àhi ana Yezu : « Nak kàhəŋgarfəŋ do aw ? Zlapay ge mis hini ya ti təzlapakuk ni ti zlapay ga mam ? » ");
INSERT INTO muy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ay Yezu nakəŋ te-te, àhəŋgrifəŋ ndo. Mək gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni àhi keti : « Nəhuk mbaɗay dək ana slimi ge Melefit Bay ga sifa ni : tamal nak *Krist *Bay gəɗakani ya amara ni, nak Wur ge Melefit ti hi ana leli. » ");
INSERT INTO muy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yezu àhəŋgrifəŋ, àhi ahkado : « Nak nakani kə̀ɗəmaya zlam gayak a. Ay nəhi ana kʉli keti : Kama kama ti ekipʉm nu *Wur ge Mis manjəhaɗani a məlaŋ ga gəɗakani bu, kà ahar ga ɗaf ge Melefit Bay njəɗa-njəɗani ni. Ekipʉm anara ka maklaɓasl a huɗ melefit ba.  » ");
INSERT INTO muy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gəɗakani nakəŋ àra ècia ma ga Yezu na ti àzumkia ɓəruv a, ègʉzlehkaba azana ka vu gayaŋ a kwar, àhi ana mis ni ahkado : « Azay ahàr gayaŋ akaɗa naŋ Melefit ; maɗəbay sedi nahaŋ kamam mba mam ? Kìcʉma, endivi Melefit timey ! ");
INSERT INTO muy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ay ti kawayum ti mə̂grumi mam ? » Mək mis ni ɗek tə̀ɗəm : « Àgudara, si tâkaɗ naŋ kwa. » ");
INSERT INTO muy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eslini mis ndahaŋ tìtifiviyu esliɓ e eri vu, tə̀si məɗukɗuk ga ahar, tə̀bi bəbarva, ");
INSERT INTO muy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tə̀hi : « Nak Bay gəɗakani ya amara ni, ɗəfiaya maslaŋa ya ti àzləɓ kur na ana leli a zla ! » ");
INSERT INTO muy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ka sarta gani nani ti Piyer naŋ àbu manjəhaɗani digʉsa a dalaka ni bu. Naŋ àbu eslini ti wal nahaŋ àrəkia : wal nani naŋ àbu agray tʉwi eslini. Àhi ana Piyer nakəŋ ahkado : « Nak day kàsawaɗumkabá akaba Yezu zal Gelili na. » ");
INSERT INTO muy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ay ti Piyer àhi kè meleher ge mis ɗek ahkado : « Aha. Nìcikaba ere ye ti kawayay kəɗəm na do. » ");
INSERT INTO muy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Àra àɗəma nahkay ti òru gwar ka mahay. Naŋ àbu akoru nahəma, wal nahaŋ èpi naŋ keti. Wal nani day agray tʉwi eslini. Àra èpia naŋ a ti àhi ana mis ya ti eslini ni : « Naŋ hini tə̀sawaɗakaba akaba Yezu zal Nazaret na. » ");
INSERT INTO muy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eslini Piyer nakəŋ àmbaɗay, àɗəm keti : « Aha, nu nə̀sər maslaŋa gani nani do timey. » ");
INSERT INTO muy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Àra àpəsa ɓal ti mis ya tə̀bu a dalaka bu ni tàhəɗakfəŋiyu ke Piyer, tə̀hi keti : « Eɗeɗiŋ nak ndam gatay gani, aɗaba mis təsər àna dəŋgu gayak ya kazlapay àna naŋ ni. » ");
INSERT INTO muy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Naŋ nakəŋ àmbaɗay, àɗəm : « Tamal nasəkaɗ malfaɗa nahəma, Melefit mâkaɗa nu a. Nə̀sər maslaŋa gani nani ya ti kacalumfəŋ ni do. » Eslini agwazl àzlah hʉya. ");
INSERT INTO muy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piyer nakəŋ ma ga Yezu ya àhi « Wuɗaka agwazl azlah ti akəɗəm sak mahkər kə̀sər nu do » ni àŋgiaya a ahàr ba. Nahkay Piyer nakəŋ àhəraya e mite va, ètʉwi dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dʉ àna zʉzʉeni nahəma, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀cakalava akaba gəɗákani ndahaŋ na, tàgraki sawari ka Yezu ga makaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Eslini tə̀gəs Yezu nakəŋ, tə̀wəl mək tòru àna naŋ afa ge Pilet. Pilet ti bay ga ndam *Rom ya agur haɗ *Zʉde ni. ");
INSERT INTO muy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zʉdas naŋ ya ti àsəkumoru Yezu ni àra àsəra tə̀gəsa Yezu a tə̀wəla ti, àhəŋgarvu maravu mək àhəŋgribiyu siŋgu akur-akurani kru kru mahkərani ni ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ga ndam *Zʉde ni, ");
INSERT INTO muy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","mək àhi ana tay ahkado : « Nàgudara zlam a, aɗaba nə̀səkumoya sifa ga maslaŋa ya ti àgudar araŋa ndo na. » Ay nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Ma gani geli mam ? Məsər gayak. » ");
INSERT INTO muy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eslini Zʉdas nakəŋ àboru siŋgu ni bəɗak a *ahay gəɗakani ge Melefit ni vu, mək òru àwəliyu ezeweɗ agavəla, àfiviyu ahàr gayaŋ tandal ga makaɗ ahàr gayaŋ, mək àmət. ");
INSERT INTO muy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Eslini bəbay gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni tə̀həlaba siŋgu na, tə̀ɗəm : « E divi geli bu ni ti mìsliki məbəkiviyu siŋgu hini àkivu ka siŋgu ya taŋgahi ana Melefit ni vu do, aɗaba siŋgu hini ti tə̀səkum sifa ge mis àna naŋ. » ");
INSERT INTO muy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nahkay nday nakəŋ tàgray sawari, mək tə̀səkumfəŋa vədaŋ kà bay mələm zlam a. Məlaŋ gani ègi mindiviŋ ga ndam madurlaŋ. ");
INSERT INTO muy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ku kani vədaŋ gani nani ti təzalay vədaŋ ge mimiz. ");
INSERT INTO muy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nahkay ti pakama ge Zeremi bay mahəŋgaray *pakama ge Melefit ni àgrava. Pakama gani nani ti nihi : « Tə̀həla siŋgu akur-akurani kru kru mahkərani na, siŋgu ya ti ndam *Izireyel tàgraki sawari tə̀ɗəm təsəkum naŋ àna naŋ ni, ");
INSERT INTO muy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tə̀səkum vədaŋ ga bay mələm zlam àna naŋ, akaɗa ga Bay geli ya àhu ni.  » ");
INSERT INTO muy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tòru tìnjʉa àna Yezu afa ge Pilet a ti Pilet nakəŋ èhindifiŋa ma, àhi : « Nak ti bay ga ndam *Zʉde eɗeɗiŋ aw ? » Àhəŋgrifəŋ, àhi : « Nak kə̀ɗəm. » ");
INSERT INTO muy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ ni tacalki naŋ ka zlam magudarani. Ay ti naŋ nakəŋ àhəŋgarfəŋ ndo. ");
INSERT INTO muy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilet èhindifiŋa ma keti, àhi ahkado : « Tacalki kur ka zlam magudarani kay ti kici do waw ? » ");
INSERT INTO muy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yezu naŋ te-te, àhəŋgrifəŋ ndo. Gayaŋ ya àhəŋgarfəŋ ndo ni ti àgria ejep ana bay na dal-dal. ");
INSERT INTO muy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kəla wuməri ga *Pak zla ti ndam *Zʉde tə̀bu tihindifiŋa kè Pilet a ti mə̂faya zal daŋgay a bəlaŋ. Tìhindifiŋa ti naŋ àbu afiaya maslaŋa ya tawayay na ana tay a. ");
INSERT INTO muy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ay ka sarta gani nani ti zal nahaŋ àvu a daŋgay bu slimi gayaŋ Yezu Barabas. Maslaŋa nani ti mis ɗek tə̀səra naŋ a. ");
INSERT INTO muy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nahkay ka ya ti mis ni tə̀cakalava nahəma, Pilet nakəŋ èhindifiŋa kà tay a, àhi ana tay ahkado : « Kawayum hi ti nə̂fiaya way ana kʉli a way ? Nə̂fiaya Yezu Barabas ana kʉli a tək, day ti Yezu naŋ ya ti təzalay *Krist ni aw ? » ");
INSERT INTO muy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Àɗəm nahkay ti aɗaba àsəra tə̀gəsibiyu Yezu ti aɗaba tagraləŋ solu palam. ");
INSERT INTO muy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka ya ti Pilet naŋ àbu manjəhaɗani agray seriya ni ti wal gani àslərkibiyu mis àhi mâra mə̂hi ahkado : « Maslaŋa nani ti mis jireni, kə̀gri araŋa ba. Aɗaba kani ga məlavaɗ nàgra daliya dal-dal, kisim èziɗekuva àna maslaŋa nana. » ");
INSERT INTO muy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ ni tə̀hi ana mis macakalavani ni : « Humi : “Mawayay si kâfaya Barabas a, Yezu ti ni kə̂kaɗa naŋ a.” » ");
INSERT INTO muy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bay ni àhi ana tay keti : « E kiɗiŋ gatay cʉeni ni bu ni ti kawayum ti nə̂fiaya way ana kʉli a way ? » Nday nakəŋ tə̀hi : « Barabas. » ");
INSERT INTO muy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilet nakəŋ àra ècia ma gatay na ti àhi ana tay : « Nahkay ti kawayum ti nə̂gri mam ana Yezu naŋ ya ti təzalay naŋ Krist ni mam ? » Nday ɗek tə̀hi : « *Darfəŋ naŋ kà təndal. » ");
INSERT INTO muy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilet àhi ana tay keti : « Àgudar mam emiteni mam ? » Nday nakəŋ ba təzlah kay kay, tə̀ɗəm : « Darfəŋ naŋ kà təndal, darfəŋ naŋ kà təndal. » ");
INSERT INTO muy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilet nakəŋ àra àsəra mis ni eticiiki ma do, tawayay tizligaya ŋguwa ti, àcah yam àbarakaba ahar gayaŋ a kè eri ge mis na ɗek mək àɗəm : « Kəkaɗum maslaŋa hini ti ahar goro àkibu bi, məsər gekʉli. » ");
INSERT INTO muy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eslini mis ni ɗek tə̀ɗəm ahkado : « Mə̀gəskabá ka ahàr geli akaba bəza geli a, tâkaɗ naŋ. » ");
INSERT INTO muy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilet àra ècia ma gatay na ti àfiaya Barabas nakəŋ ana tay a, àhi ana ndam slewja gayaŋ ni tə̂zləɓ Yezu àna kurupu. Tàra tə̀zləɓa ti àhi ana tay tâzay naŋ, tôru tâdarfəŋ naŋ kà təndal. ");
INSERT INTO muy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ndam slewja ni tə̀zoru Yezu nakəŋ a huɗ ahay ga bay *Pilet ni vu. Eslini tə̀zalakivabiyu ndam slewja ndahaŋ ni ɗek, tə̀rəkiva ka tay a tàra tèveliŋi ahàr ana Yezu. ");
INSERT INTO muy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tàmbatki azana ndizeni, ");
INSERT INTO muy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","tèkeleya adak a, tàslap hindigil-hindigil, tə̀fiviyu a ahàr vu akaɗa ga jaku ni, tàzay eziŋgwi tə̀fivù a ahar ga ɗaf vu. Tàra tə̀bəkia zlam a zla nahəma, tàbəhaɗ mirdim kè meleher gayaŋ tə̀gri sa, teyefiŋ, tə̀hi ahkado : « Məgruk sa, bay ga ndam *Zʉde ! » ");
INSERT INTO muy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eslini nday nakəŋ tìtifiviyu esliɓ e eri vu, tə̀zafəŋa eziŋgwi na mək tə̀si a ahàr vu. ");
INSERT INTO muy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tàra tə̀bia seki a nahkay ti tə̀cakwakia azana ya tə̀fəki na, tə̀bikabu azana gayaŋ gayaŋani ya tə̀cakwakia ni. Kələŋ gani tàzay naŋ ga moru *madarfəŋ naŋ kà təndal. ");
INSERT INTO muy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ka ya ti ndam slewja ni tə̀bu tasləkaba a kəsa ni ba ni ti tàbakabu ahàr akaba zal Sireŋ nahaŋ, slimi gayaŋ Simu. Eslini nday nakəŋ tə̀fəki ŋgasa ga mazay təndal ga *madarfəŋ Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nday nakəŋ tòru tìnjʉa ka məlaŋ nahaŋ ; məlaŋ gani nani ti təzalay Golgota, aɗəmvaba « məlaŋ ga aslat ga ahàr. » ");
INSERT INTO muy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tə̀vi zum mebeɗeni akaba haf ɓilek-ɓilekeni ana Yezu nakəŋ. Àra àcaka ti àwayay miseni ndo. ");
INSERT INTO muy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eslini nday nakəŋ tàdarfəŋ naŋ kà təndal ni. Tàra tàdarfəŋa naŋ a ti tàgraki ca-ca àki ka azana gayaŋ ni bəlaŋ àna bəlaŋ ti tə̂sər way azum way. ");
INSERT INTO muy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kələŋ gani tànjəhaɗ tajəgaki naŋ. ");
INSERT INTO muy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Eslini tàdarfəŋ pələŋgaf kà təndal agavəla ga ahàr gayaŋ. Ka pələŋgaf nani ti təbəki zlam magudarani ge mis ni ti mis ɗek tə̂sər ; tə̀bəki ti nahkay hi : « Hini ti Yezu bay ga ndam *Zʉde. » ");
INSERT INTO muy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Eslini keti tàdarfəŋ ndam akal bebem cʉ kà təndal ndahaŋ kà gəvay ga Yezu, bəlaŋ gani ka ahar ga ɗaf, bəlaŋ gani ti ni ka ahar ga gəjar gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nday ya ti takoru gwar eslini ni tàra tìpia naŋ a ti tìndivi naŋ, tə̀daɗay ahàr, ");
INSERT INTO muy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","tə̀hikaboru : « Hini, nak ya ti kə̀ɗəm ahkado : “Nembeɗvù *ahay gəɗakani ge Melefit ni ti anələmaba a huɗ ga vaɗ mahkərani ba” ni do aw ? Tamal nak Wur ge Melefit ti həŋgay ahàr gayak, həraya kà təndal na zla aw ! » ");
INSERT INTO muy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, ndam *məsər Wakita ge Melefit akaba gəɗákani ndahaŋ ni tèyefiŋ daya. Tə̀ɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","« Naŋ nakəŋ àhəŋgaraba mis ndahaŋ a keti ti àhəŋgaraba ahàr gayaŋ a koksah timey ! Naŋ bay ga ndam *Izireyel ! Tamal nahkay ti mâhəraya kà təndal na ! Tamal ti àhəraya nahəma, leli tekeɗi aməfəki ahàr bilegeni. ");
INSERT INTO muy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Àfəkia ahàr ke Melefit a, àɗəm naŋ Wur ge Melefit ti, tamal Melefit awayay naŋ ti mâhəŋgay naŋ nihi zla aw ! » ");
INSERT INTO muy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mis ya tə̀bu madarfəŋani kà gəvay ga Yezu nakəŋ, nday day tìndivi naŋ nahkay. ");
INSERT INTO muy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Fat àra ècika tirkeɗ-keɗ ka ahàr melefit a ti ləvəŋ àgray ka haɗ ni ɗek tekɗefiŋ duk àbivoru àna njemdi mahkər ya ga məlakarawa. ");
INSERT INTO muy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Àra àgra njemdi mahkər ti Yezu àdi ana zlahay kay kay, àɗəm : « Eloyi, Eloyi, lama sabahtani ? » Awayay aɗəmvaba ti « Bay Melefit goro ni, Bay Melefit goro ni, kə̀mbrəŋ nu ti kamam ?  » ");
INSERT INTO muy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mis ya tə̀bu eslini ni ndahaŋ tàra tìcia gayaŋ ya ti àzlah na ti tə̀ɗəm : « Azalay Eli ni. » ");
INSERT INTO muy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eslini biliŋ gatay àcuhworu, àzay zlam ya esikabu yam akaɗa ga matala ni, àtəliyu a zum cecʉwekeni vu juɓ, àɓahki ka aday àtəlikabiyu ana Yezu a ma vu ti mîsi. ");
INSERT INTO muy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ay mis ndahaŋ tə̀hi : « Ɓesa day, tamal ti Eli ara ahəŋgay naŋ ti mara mipi. » ");
INSERT INTO muy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ay Yezu nakəŋ àzlahkivu kay kay, àmət. ");
INSERT INTO muy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ka ya ti àmət ni ti azana ga mahay ga məlaŋ *njəlatani ya ti a huɗ ga *ahay gəɗakani ge Melefit ni bu ni ègʉzlehvabiyu kwarra, agavəla cekw a haɗ. Haɗ àdaɗay, huɗəkum tàdahvu, ");
INSERT INTO muy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","mahay ge mindiviŋ tə̀zləkvaba mək ndam ge Melefit ya tə̀mət ni, mis dal-dal e kiɗiŋ gatay bu tàŋgaba. ");
INSERT INTO muy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka ya ti Yezu àŋgaba e kisim ba ni ti mis ya tàŋgaba ni tàhəraya e mindiviŋ ba, tə̀huriyu a kəsa njəlatani vu. Eslini mis kay tìpia tay a. ");
INSERT INTO muy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bay ga ndam slewja ni akaba ndam slewja ndahaŋ ya tajəgaki Yezu ni tàra tìpia ga haɗ ya àdaɗay na akaba zlam ndahaŋ ya àgravu na ɗek ti aŋgwaz àdəgakia ka tay a, nahkay tə̀ɗəm : « Maslaŋa hini ti Wur ge Melefit eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wál ndahaŋ dal-dal tə̀bu eslini cak, tamənjoru. Wál nday nani tàɗəbabiyu Yezu kwa e Gelili ga məgri tʉwi. ");
INSERT INTO muy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","E kiɗiŋ ga wál nday nani bu ni ti Mari ga kəsa Magədala, Mari məŋ ga ata Zek nday ata Zʉzef, nahaŋ ni ti ni məŋ ga bəza ge Zebede tə̀kibu ka tay. ");
INSERT INTO muy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Məlakarawa àra ègia ti bay ge elimeni nahaŋ àra ; slimi gayaŋ Zʉzef, naŋ ga kəsa Erimete. Naŋ day bay maɗəbay Yezu. ");
INSERT INTO muy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Naŋ nakəŋ òru afa ge Pilet, òru èhindi kisim ga Yezu ni. Nahkay Pilet nakəŋ àhi ana ndam slewja tôru tə̂vi. ");
INSERT INTO muy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zʉzef àra àza kisim ga Yezu na ti àkambah àna dawra mʉweni. ");
INSERT INTO muy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Àra àkambaha ti àfiyu e mindiviŋ mʉweni vu. Mindiviŋ nani ti gayaŋ gayaŋani, èliyu a pəlaɗ vu. Àra àfiya kisim ga Yezu na e mindiviŋ ni va ti àbəlaɗiviyu belim gəɗakani ana mahay ge mindiviŋ ni mək àsləka òru a magam. ");
INSERT INTO muy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ata Mari ga kəsa Magədala ni nday ata Mari nahaŋ ni nday tə̀bu manjəhaɗani kà gəvay ge mindiviŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hajəŋ gani vaɗ *məpəsabana ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *Feriziyeŋ ni tòru ka ahar bəlaŋ afa ge Pilet. ");
INSERT INTO muy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tòru tìnjʉa ti tə̀hi : « Bay, ka ya ti bay masəkaɗ malfaɗa nani naŋ àbu àna sifa ni àɗəm : “A vaɗ ya mahkər anaŋgaba e kisim ba.” Ma gayaŋ ya àɗəm ni àŋgiaya a ahàr ba ana leli a. ");
INSERT INTO muy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nahkay ti hi ana mis tâjəgay mindiviŋ ni, do ni ti ndam maɗəbay naŋ ni atara təzaba kisim gayaŋ na akal-akal a, atəhi ana mis àŋgaya e eviɗ ba. Atara təɗəma ti malfaɗa gatay ni amatam gayaŋ ya àsəkaɗ ni. » ");
INSERT INTO muy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eslini Pilet nakəŋ àhi ana tay : « Ndam slewja nday hi, dəgum akaba tay ti tâjəgaki mindiviŋ ni akaɗa gekʉli ya kawayum ni. » ");
INSERT INTO muy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nahkay gəɗákani nakəŋ tòru ke mindiviŋ ni ga majəgani lala : tə̀həndi lemerʉ gatay mək tàbəhaɗ ndam slewja ga majəgakiani. ");
INSERT INTO muy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Vaɗ *məpəsabana àra àsləkaba, ge miledʉ fat azlərəvaya a vaɗ ga gosku ye enjenjeni zla nahəma, ata Mari ga kəsa Magədala ni nday ata Mari nahaŋ ni tòru tə̀mənjiyu mindiviŋ ni. ");
INSERT INTO muy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tòru tìnjʉa ti haɗ àdaɗay kay kay, hʉya məslər ga Bay geli àsləkabiya e melefit ba, àbəlaɗləŋa belim na mək ànjəhaɗki digʉs. ");
INSERT INTO muy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Vu gani aslaɗay akaɗa ga avər ya abay aku ni ; azana gayaŋ day bəɗ-bəɗ akaɗa ga koskosay ni. ");
INSERT INTO muy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndam ya tajəgaki mindiviŋ ni tàra tìpia ti aŋgwaz àdəgakia ka tay a dal-dal, təgəgər, tìgia akaɗa sifa àniviyu ana tay va bi. ");
INSERT INTO muy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Eslini məslər ni àhi ana wál ni ahkado : « Aŋgwaz àwər kʉli ba. Nə̀səra, kəɗəbum ti Yezu naŋ ya ti *tàdarfəŋ kà təndal ni ; ");
INSERT INTO muy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","àŋgaba e kisim ba, naŋ àbi ahalay va bi. Dəguma mənjumki, məlaŋ ya tàfəkaɗ kisim gayaŋ ni nihi. ");
INSERT INTO muy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nihi ti dəgum weceweci, kə̂humi ana ndam maɗəbay naŋ ni ahkado : “Àŋgaya e kisim ba ; àdoru ka haɗ *Gelili kama gekʉli, akədumi ahàr ti eslini, akaɗa gayaŋ ya ti àhi ana kʉli ni.” Ma goro ti nahkay. » ");
INSERT INTO muy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wəwal nakəŋ tàsləka ke mindiviŋ na ke wecewecena ; aŋgwaz awər tay, ay tə̀bu təmərvu dal-dal. Tàcuhworu, tawayay moru məhi ma gani ana ndam *maɗəbay Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ka ma geli hini ti Yezu àŋgazlivu ana tay, àhi ana tay ahkado : « Nəgri sa ana kʉli. » Eslini wál ni tə̀rəkioru tàbəhaɗi mirdim, tə̀bəki ahar ka asak gayaŋ ni, tàzləbay naŋ. ");
INSERT INTO muy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Eslini Yezu àhi ana tay ahkado : « Aŋgwaz àwər kʉli ba, dəgum kə̂humi ana bəza ga mmawa ni tôru e Gelili. Eslini ti atoru tipi nu. » ");
INSERT INTO muy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka ya ti wál ni nday tə̀bu e divi bu mba ni ti ndam slewja ndahaŋ e kiɗiŋ ga nday ya tajəgaki mindiviŋ ni bu tòru a kəsa vu. Tòru tìnjʉa ti tàŋgəhaɗi ere ye ti àgravu ni ɗek ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni. ");
INSERT INTO muy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nahkay gəɗákani nani tàŋgasvu akaba gəɗákani ndahaŋ, tàgray sawari e kiɗiŋ gatay bu. Tàra tə̀zlapakaba ti tə̀bi siŋgu ana ndam slewja ni dal-dal, ");
INSERT INTO muy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tə̀hi ana tay ahkado : « Ɗəmum : “Ga məlavaɗ ka ya ti leli e ɗʉwir bu ni ti ndam maɗəbay naŋ ni tàra tə̀zaba kisim gana akal a.” ");
INSERT INTO muy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tamal bay ni ècia ma gana ti mə̀səra ere ye ti aməhi na, emiciiki ana leli ; nahkay ti aməgri araŋa ana kʉli do. » ");
INSERT INTO muy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ndam slewja nakəŋ tə̀həl siŋgu ni mək tàgray ere ye ti tə̀hi ana tay ni. Nahkay kwa ka sarta gani nani duk àbivaya kana ndam *Zʉde ndahaŋ kay tə̀gəskabá ma gani nana. ");
INSERT INTO muy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ndam *maɗəbay Yezu kru mahar bəlaŋani ni tòru e Gelili, ka həma ya ti Yezu àhi ana tay tôru ni. ");
INSERT INTO muy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tòru tìnjʉa, tìpi naŋ a ti tàbəhaɗi mirdim, tàzləbay naŋ, ay ti mis ndahaŋ e kiɗiŋ gatay bu tə̀hi ana ahàr bi naŋ do. ");
INSERT INTO muy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eslini Yezu àhəɗakfəŋbiyu kà tay, àhi ana tay : « Melefit àvua njəɗa gayaŋ a ɗek ga məgur məlaŋ ya agavəla akaba məlaŋ ya ka haɗ na. ");
INSERT INTO muy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nahkay ti dəgum, humioru ma ana mis ga haɗ ga məlaŋ ni ɗek ti tîgi ndam maɗəbay nu. Barum tay àna slimi ga Baba, ga Wur gayaŋ akaba ga *Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ere ye ti nə̀hi ana kʉli ni ɗek ti cahumi ana tay ti tə̂gəskabá. Səruma, nu nə̀bu akaba kʉli kəlavaɗ, duk abivoru ana mandav ga duniya. »");
INSERT INTO muy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","*Ma Mʉweni Sulumani àki ka Yezu *Krist, Wur ge Melefit, ànjəki ");
INSERT INTO muy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","akaɗa ga Bay Melefit ya ti àɗəm ni. Ma gayaŋ ya àhi ana Yezu ni àbu məbəkiani a wakita ga bay *mahəŋgaray pakama gayaŋ Izayi ni bu. Àhi : « Nihi ti nu nə̀bu nəsləroru bay məslər goro nahaŋ kama gayak ti mâslamatukkabu divi. ");
INSERT INTO muy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dəŋgu gayaŋ ahəndabiyu a huɗ gili bu. Àɗəm ahkado : “Slamatumikabu divi ana Bay gəɗakani. Ahàr àɗəm divi gayaŋ mâla ndəlaɓa.”  » ");
INSERT INTO muy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nahkay ti zal nakəŋ, təzalay naŋ Zeŋ, òru a huɗ gili vu ga *məbaray mis. Àra ènjia eslina ti àɗəm ahkado : « Mbatumkaba majalay ahàr gekʉli a. Tamal kàmbatumkaba majalay ahàr gekʉli a ti, nabaray kʉli. Nahkay ti Bay Melefit ambərfəŋa zlam magudarani gekʉli ni kè kʉli a. » ");
INSERT INTO muy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zeŋ àra àɗəma nahkay ti ndam ga haɗ *Zʉde akaba ndam Zerʉzalem ni ɗek tə̀rəkia. Tàra tìnjia ti tə̀ɗafaya zlam gatay ya tàgudar na, mək Zeŋ nakəŋ àbaray tay a zalaka *Zʉrdeŋ bu hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zeŋ ti naŋ àbu àna azana mələmani àna eŋgʉc ge ezligwemi, awəlvù àna maslpara ga ambəl a zuh bu. Zlam məzum gayaŋ ti eyew akaba amu. ");
INSERT INTO muy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Naŋ àbu azlah, àhi ana tay : « Maslaŋa nahaŋ naŋ àbu ara e divi ba kələŋ goro a. Naŋ nani ti mis gəɗakani, njəɗa gayaŋ àtama goro a. Nu ti way ga mandəhaɗ ahàr ti nêpicehiaba ezeweɗ ga kimaka gayaŋ a di way ? ");
INSERT INTO muy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nu ti nàbaray kʉli àna yam, naŋ ti ni amara məbaray kʉli àna *Məsuf Njəlatani. » ");
INSERT INTO muy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ka ya ti Zeŋ naŋ àbu *abaray mis nahəma, Yezu ècikbiyu a Nazaret ka haɗ *Gelili, àrəkia mək Zeŋ nakəŋ àbaray naŋ a zalaka *Zʉrdeŋ bu. ");
INSERT INTO muy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yezu naŋ àbu acəlaya a yam ni ba ni ti èpi huɗ melefit adahvu, èpi *Məsuf ge Melefit ahərkiaya akaɗa ga kurkoduk ya ahər na, àhuriviyu a vu vu. ");
INSERT INTO muy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Eslini dəŋgu àhəndabiyu a huɗ melefit bu akaɗa dəŋgu ge mis, àhi : « Nak ti wur goro, nawayay kur dal-dal, kəməru məɓəruv dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eslini *Məsuf ge Melefit nakəŋ àzoru Yezu a huɗ gili vu hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yezu òru ènjʉa a huɗ gili ni va ti anjəhaɗ eslini vaɗ kru kru faɗ. Naŋ àbu eslini ti *Seteni àhəlfəŋa eyʉ a. Ka sarta gani nani ti Yezu naŋ àbu e kiɗiŋ ga zlam ge gili bu ; *məslər ge Melefit tə̀bu təfi ahàr. ");
INSERT INTO muy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A vaɗ nahaŋ tàra tə̀wəla Zeŋ a. Tàra tə̀wəla naŋ a nahəma, Yezu òru ka haɗ *Gelili. Òru ènjʉa eslina ti àhi *Ma Mʉweni Sulumani ge Melefit ana mis. Ahivù ana tay, àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","« Sarta ènjia. Melefit ara azum bay gayaŋ e kiɗiŋ gekʉli bu, Məgur gayaŋ ènjia. Mbatumkaba majalay ahàr gekʉli a, gəsumkabá Ma Mʉweni Sulumani na. » ");
INSERT INTO muy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A vaɗ nahaŋ Yezu naŋ àbu akoru kà gəvay ga dəluv Gelili ti èpi mis bebem cʉ ; biliŋ gani slimi gayaŋ Simu, nahaŋ ni ti ni wur ga məŋani Andre. Nday tə̀bu tətəliyu zəva gatay a dəluv vu, aɗaba nday ndam məgəs kilif. ");
INSERT INTO muy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eslini Yezu àhi ana tay : « Ɗəbumbiyu nu ; anagray ti kîgʉm ndam məhəlibiyu mis ana Melefit akaɗa ya ti kəgəsum kilif ni. » ");
INSERT INTO muy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tàra tìcia pakama ga Yezu na ti tə̀mbərbu zəva gatay ni ndəɓak, tàɗəbay naŋ hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nday tə̀bu takoru kama gʉzit ti Yezu èpi mis ndahaŋ cʉ keti ; nday bəza ge Zebede, bəlaŋ gani slimi gayaŋ Zek, nahaŋ ni ti ni slimi gayaŋ Zeŋ. Nday a *slalah ga yam bu, tə̀bu təslamalay zəva gatay. ");
INSERT INTO muy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Àra èpia tay a ti àzalay tay. Nday nakəŋ tàra tìcia zalay gayaŋ na ti tə̀mbərbu bəŋ gatay Zebede akaba mis ya təgriki tʉwi ana tay ni a slalah ga yam ni bu, tàɗəbay naŋ. ");
INSERT INTO muy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","A vaɗ nahaŋ Yezu akaba ndam maɗəbay naŋ ni tòru a Kafarnahum. Vaɗ *məpəsabana àra ènjia ti tə̀huriyu a ahay ga *mahəŋgalavù Melefit vu, mək Yezu nakəŋ ànjəki ka macahi zlam ana mis. ");
INSERT INTO muy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Zlam gayaŋ ya àcahi ana tay ni ti àgria ejep ana tay a, aɗaba tìci macahay zlam akaɗa gayaŋ ni ɗay-ɗay ndo. Àhi ma ana tay akaɗa ga bay ni, do ni ti akaɗa ga ndam *məsər Wakita ge Melefit ya təcahi zlam ana mis ni do. ");
INSERT INTO muy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nday tə̀bu a ahay ga mahəŋgalavù Melefit ni bu nahəma, zal nahaŋ seteni àniviyu a ahàr bu naŋ àkibu ka tay eslini. Àzlah, ");
INSERT INTO muy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","àɗəm : « Yezu zal Nazaret ! Nak ti kaɗəbafəŋa mam kè leli a mam ? Kàra ge mijiŋ leli a waw ? Nak dəgiya, nə̀səra kur a lala ; nak Bay *njəlatani ge Melefit ya àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Eslini Yezu nakəŋ àzlacaki ke seteni ni ɓəra, àhi : « Lakakaba, sləkiaba ana maslaŋa hina. » ");
INSERT INTO muy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Seteni nakəŋ àra ècia zlacay gayaŋ na ti àdaɗay maslaŋa nani kay kay, àzlah kay kay, àsləkiaba. ");
INSERT INTO muy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mis ya ti eslini ni ɗek tàra tìpia ere ye ti àgravu na ti àgria ejep ana tay a dal-dal ; tə̀zlapaki e kiɗiŋ gatay bu, tə̀ɗəm : « Məŋ ga mam hini mam ? Zlam gayaŋ ya àcahi ana leli ni ti zlam mʉweni ; azlapay akaɗa ga bay ni. Ku seteni day àhi ma ana tay, mək təgəsikabu. » ");
INSERT INTO muy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nahkay ti slimi ga Yezu àhəndoru ke weceweceni ka haɗ *Gelili ɗek. ");
INSERT INTO muy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yezu akaba Simu, Andre, Zek, Zeŋ tàra tàhəraya a ahay ga *mahəŋgalavù Melefit ni ba ni ti tòru suwwa a magam ga ata Simu nday ata Andre hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eslini ti mireŋ ga Simu naŋ àvu mandəhaɗani, aku àbəkia. Yezu òru ènjʉa ti tə̀hi ma gani hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yezu àra ècia ma gana ti àhəɗakfəŋiyu, àgəs ahar gani, èzefteba naŋ a. Aku nakəŋ àhəlkia hʉya, mək wal ni afi ahàr ana tay. ");
INSERT INTO muy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Məlakarawa àra ègia fat àdiya a ahay va, məlaŋ èɗiza ti tə̀həlibiyu mis ya ti tèɓesey do ni ɗek akaba nday ya ti seteni agray tay ni ɗek ana Yezu. ");
INSERT INTO muy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mis ga kəsa ni ɗek tàŋgasfəŋvu kà mahay ya ti Yezu naŋ àvu ni ; ");
INSERT INTO muy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","eslini Yezu nakəŋ àhəŋgaraba mis ya ti arməwər gərgərani awər tay na kay ; mis ya ti seteni àniviyu ana tay ni day àgariaba ana tay a. Àcafəŋa seteni na kà zlapay a, aɗaba tə̀səra naŋ a. ");
INSERT INTO muy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Dʉ àna zʉzʉeni ti Yezu ècikaba, àhəraya òru a huɗ gili vu. Òru ènjʉa ti ahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Eslini Simu akaba zləbəba gayaŋ ni tàɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tàra tə̀dia ahàr a ti tə̀hi ahkado : « Mis ɗek taɗəbay kur. » ");
INSERT INTO muy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Eslini Yezu nakəŋ àhi ana tay : « Tokumum mədəgum a kəsa ndahaŋ vu, ti nə̂hivù pakama ge Melefit ana mis nday ye eslini ni bilegeni. Nu nàra ti ga magray tʉwi gani nani. » ");
INSERT INTO muy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Naŋ nakəŋ mək àsawaɗay ka haɗ *Gelili ɗek ; a kəsa gərgərani bu ɗek àhi pakama ge Melefit ana mis a ahay ga *mahəŋgalavù Melefit ye eslini ni bu, àgariaba seteni ana mis ndahaŋ a daya. ");
INSERT INTO muy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A vaɗ nahaŋ zal ambələk nahaŋ àrəkia ka Yezu a àbəhaɗi mirdim, àhi ahkado : « Kam-kam, tamal kawayay ti kisliki mahəŋgaraba nu a ti nîgia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eslini àsia cicihi ana Yezu a ; Yezu nakəŋ àzoru ahar, ènjifiŋ, àhi ahkado : « Nawayay, gia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yezu àra ènjifiŋa ti maslaŋa nani àŋgaba, ègia mis njəlatana hʉya. ");
INSERT INTO muy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Eslini Yezu àləgi, àhi ahkado : « Nihi kə̀ŋgaba nahəma, kə̀hi ma gani ana maslaŋa ba. Ru kə̂ŋgazli vu gayak ni ana bay *maŋgalabakabu mis akaba Melefit sawaŋ ; kə̂vi zlam ana Melefit akaɗa ge Mʉwiz ya àɗəm a wakita gayaŋ bu ni, aɗaba kìgia mis njəlatana. Nahkay mis etipi. Etipia ti atəsər nak kə̀ŋgaba, kìgia mis njəlatana. » Àra àhia ma nahkay ti àhi : « Sləka. » ");
INSERT INTO muy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ay zal nakəŋ àra àsləka ti anjəki ka məɗəm pakama ni dal-dal sawaŋ. Maslaŋa ya ti àdi ahàr ni lu ba àhi ma gani. Àɗəmva pakama na nahkay ti Yezu èsliki məhuriyani a kəsa vu vay-vay va do, aɗaba mis tə̀saɓaki. Nahkay ànjəhaɗ e gili cak àfəŋ kà kəsa, mis gwar eley gwar eley do ɗek tə̀rəkioru. ");
INSERT INTO muy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Àra àgra vaɗ a ɓal zla ti Yezu àŋga a Kafarnahum a. Naŋ àbu a magam eslini ti mis tìcifiŋa daɗay a. ");
INSERT INTO muy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tə̀rəkia tàra tàŋgasvu dal-dal a ahay ya ti naŋ àvu ni bu. Məlaŋ manjəhaɗani kà gəvay gayaŋ àbi, kà mahay tekeɗi məlaŋ àbi, aɗaba mis ni tə̀saɓay. Naŋ nakəŋ naŋ àbu acahi ma ge Melefit ana tay. ");
INSERT INTO muy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Naŋ àbu acahi zlam ana tay nahkay ti mis ndahaŋ faɗ tə̀zibiyu zal dəra nahaŋ àki ka slalah. ");
INSERT INTO muy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ay tìsliki məzikabiyu naŋ ana Yezu do, aɗaba mis tìsliva eslina. Nahkay ti tə̀cəliyu ka *dalahar ga ahay ni, tə̀həlkia gwar ka palahar ya ti Yezu naŋ àvu na ɓal, mək tə̀fiyu naŋ mandəhaɗkiani ka slalah gayaŋ ni gwar ka məlaŋ məhəlkiana ni. ");
INSERT INTO muy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yezu nakəŋ àra èpia ere ye ti tàgray na ti àsəra tə̀fəkia ahàr a. Nahkay àhi ana zal dəra ni : « Wur goro, zlam magudarani gayak ni məmbərfukana ɗek. » ");
INSERT INTO muy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eslini zla ti ndam *məsər Wakita ge Melefit tə̀vu manjəhaɗani bilegeni. Nday nakəŋ tə̀bu təjalay a ahàr gatay bu, tə̀hi ana ahàr ahkado : ");
INSERT INTO muy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","« Àɗəm ma hini ti kamam ? Azay ahàr gayaŋ akaɗa naŋ Melefit timey ! Way esliki məmbərfəŋa zlam magudarani kè mis a tata way ? Tigi Melefit kwa do ni ! » ");
INSERT INTO muy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nday tə̀bu təjalay ahàr nahkay ti Yezu àsəra ere ye ti tə̀jalaki ahàr na àndava, mək àhi ana tay : « Kajalum ahàr nahkay ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Zləzlaɗa gani ti nəhi : “Zlam magudarani gayak ni məmbərfukana,” tək day ti nəhi : “Cicikaba, za slalah gayak na, sawaɗay” ni aw ? ");
INSERT INTO muy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ay nawayay ti kə̂sərum nu *Wur ge Mis ti nisliki məmbərfəŋa zlam magudarani kè mis ka haɗ a. » Mək àhi ana zal dəra nakəŋ : ");
INSERT INTO muy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","« Nəhuk nahəma : cicikaba, za slalah gayak na, ru a magam. » ");
INSERT INTO muy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eslini naŋ nakəŋ ècikaba cəkwaɗ hʉya, àzay slalah gayaŋ ni, àhəraya e mite va kè eri ge mis na ɗek. Ere ye ti àgravu ni ti àgria ejep ana tay a ɗek, tə̀dəgi ana mazləbay Melefit. Tə̀ɗəm : « Ere hini bik-bik, mìpi kè eri geli ndo. » ");
INSERT INTO muy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yezu nakəŋ òru gwar kà gəvay ga dəluv ni keti. Mis ɗek tə̀rəkioru, mək àcahi zlam ana tay. ");
INSERT INTO muy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ka gayaŋ ya naŋ àbu akoru ni ti èpi Levi wur ga Alfe, naŋ àbu manjəhaɗani digʉsa ka məlaŋ *məhəl hadam. Eslini Yezu nakəŋ àhi ahkado : « Ɗəbabiyu nu. » Nahkay Levi nakəŋ ècikaba cəkwaɗ, àɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kələŋ gani Yezu akaba ndam maɗəbay naŋ ni tòru afa ge Levi nakəŋ. Tòru tìnjʉa eslina ti tə̀zum zlam akaba ndam məhəl hadam akaba ndam magudar zlam ndahaŋ kay, aɗaba mis nday nani ti nday dal-dal, tə̀bu taɗəbay naŋ. ");
INSERT INTO muy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yezu naŋ àbu azum zlam akaba tay nahkay ti ndam *məsər Wakita ge Melefit tìpia ; nday nani ti ndam *Feriziyeŋ. Tàra tìpi naŋ a ti tə̀hi ana ndam maɗəbay naŋ ni ahkado : « Ahəmamam ti Yezu azum zlam ka ahar bəlaŋ akaba ndam məhəl hadam akaba ndam magudar zlam ni mam ? » ");
INSERT INTO muy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naŋ nakəŋ àra ècia pakama gatay na ti àhi ana tay ahkado : « Ndam ya ti nday njalaŋ-njalaŋ ni ti tòru afa ga zal doktar do ; si ndam ga arməwər day kwa ti takoru afa gani. Nu nàra ti ga mazalay ndam jireni do, nàra ti ga mazalay ndam magudar zlam sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A vaɗ nahaŋ ndam maɗəbay Zeŋ bay məbaray mis ni tə̀bu təgəs ndəra akaba ndam Feriziyeŋ. Eslini mis tə̀rəkia ka Yezu a tə̀hi ahkado : « Ndam maɗəbay Zeŋ ni akaba ndam Feriziyeŋ ni tə̀bu təgəs ndəra ti ndam maɗəbay kur ni tə̀gəs do ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Ka ya ti bay ya ti aday wal ni nday tə̀bu akaba zləbəba gayaŋ ni ti zləbəba ni təgəs ndəra tata waw ? Tə̀gəs ndəra ka ya ti naŋ àbu akaba tay ni do. ");
INSERT INTO muy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ay sarta nahaŋ amara, atəgəskia bay ga wal ni kà tay a. Ka sarta gani nani day kwa ti atəgəs ndəra. ");
INSERT INTO muy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yaw mis àbi azay azana mʉweni asiviyu ana azana gayaŋ midigweni bi. Tamal àgra nahkay ti azana mʉweni ni ara asəkivu azana midigweni ni, mək məlaŋ megʉzlehvani ni ara asagakivu. ");
INSERT INTO muy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nahkay day mis abəviyu zum new-neweni e kene-kene midigweni vu ti àbi. Tamal àgra nahkay ti, zum new-neweni ni àra àwəsa ti ara etezkaba kene-kene na, nahkay ti emizikiba ka tay a cicʉena. Təbəviyu zum new-neweni ti e kene-kene mʉweni vu. » ");
INSERT INTO muy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A vaɗ *məpəsabana nahaŋ ba ti Yezu akaba ndam maɗəbay naŋ ni tə̀bu tasləkaba a vədaŋ ga *alkama ba. Eslini ndam maɗəbay naŋ ni tə̀bu teheɓoru alkama ni ga mahəpəɗani ka ahàr divi. ");
INSERT INTO muy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tə̀bu teheɓoru nahkay ti ndam *Feriziyeŋ ndahaŋ tə̀hi ana Yezu : « Melefit àɗəm e *Divi gayaŋ ni bu : “Kə̀grum tʉwi a vaɗ məpəsabana ba ba” ti, nihi ti ndam maɗəbay kur ni tagray ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Eslini Yezu àhəŋgarfəŋ, àhi ana tay ahkado : « Kèjeŋgʉm ere ye ti Devit àgray ni ndo aw ? Ka ya ti Abiyatar naŋ bay gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni ti Devit zlaɗa àdəkiva, lʉwir àwər tay akaba ndam gayaŋ. Nahkay àhuriyu a ahay ge Melefit ni vu, àzum *dipeŋ ya tàfəkaɗi ana Melefit ni. Ay ti Melefit àɗəm e Divi gayaŋ ni bu, mis ndahaŋ tə̀zum dipeŋ nani do ; si ndam *maŋgalabakabu mis akaba Melefit ni day kwa ti təzum. Ay Devit nakəŋ òru àzum, mək àvi ana ndam gayaŋ ni, tə̀zum bilegeni. » ");
INSERT INTO muy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yezu àhi ana tay keti : « Vaɗ məpəsabana ti Bay Melefit àgriaya ana mis a, do ni ti àgri mis ana vaɗ məpəsabana ndo. ");
INSERT INTO muy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nahkay ti ku a vaɗ məpəsabana ba day Bay ya ti aɗəm tâgray zlam hini ni ti nu *Wur ge Mis. » ");
INSERT INTO muy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yezu àŋgoru a ahay ga *mahəŋgalavù Melefit ni vu keti. Eslini zal nahaŋ naŋ àvu ahar mikʉlfiŋana. ");
INSERT INTO muy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mis ye eslini ni tə̀bu tamənjaləŋ ana Yezu. Tə̀hi ana ahàr ahkado « Kani vaɗ *məpəsabana ti, akal ti ara ahəŋgaraba naŋ a waw ? » Tawayay tacalki Yezu ka zlam magudarani. ");
INSERT INTO muy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yezu nakəŋ àhi ana zal ya ti ahar mikʉlfiŋana ni : « Cikaba, ra e kiɗiŋ ge mis ni va. » ");
INSERT INTO muy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mək àhi ana mis ya ti eslini ni : « Ŋgakaday, Melefit àɗəm mam a wakita ya Mʉwiz àbəki ni bu mam ? Àvia divi ana mis ga magray zlam sulumana a vaɗ məpəsabana tək, ga magray zlam magudarana waw ? Ga mahəŋgay mis tək, ga makaɗ mis aw ? » Nday nakəŋ tə̀lakakabá te-te. ");
INSERT INTO muy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Àmənjaləŋ kà tay àna məzum ɓəruv dal-dal, aɗaba tìciiki slimi do. Àhi ana zal ya ti ahar mikʉlfiŋana ni : « Təlbiyu ahar gayak ni. » Àra àtəlikabiya ti ahar gayaŋ ni àslamalava, ègia sənduɓ-sənduɓana. ");
INSERT INTO muy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ndam *Feriziyeŋ ni tàra tìpia ere ye ti àgravu na ti tàhəraya a ahay ni ba, tàŋgasvu akaba ndam maɗəbay bay *Erot ni hʉya ; tàgray sawari ahəmamam ti tîjiŋ Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yezu akaba ndam maɗəbay naŋ ni tàsləka tòru kà dəluv ni. Mis dal-dal tàɗəboru naŋ : tàɗəboru naŋ ti ndam Gelili, ndam *Zʉde ");
INSERT INTO muy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","akaba ndam ga kəsa gatay Zerʉzalem, ndam Idʉme, mis ya ti tàsləkabiya ke ledi ga zalaka *Zʉrdeŋ a ni, ndam ga haɗ ga kəsa Tir akaba ga kəsa Sidoŋ. Tə̀rəkia dal-dal aɗaba tìcia ere ye ti àgray na ɗek. ");
INSERT INTO muy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eslini àhi ana ndam maɗəbay naŋ ni ahkado : « Slamalumukabá *slalah ga yam a, do ni ti mis ni ataŋgəlaɗ nu. » ");
INSERT INTO muy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Àhi ana tay nahkay ti aɗaba naŋ àbu ahəŋgaraba mis a dal-dal. Nahkay ndam ga arməwər ɗek tə̀dəɗkiyu ; way way do awayay ti mîjifiŋ lu. ");
INSERT INTO muy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Seteni ni tàra tìpia naŋ a ti tàbəhaɗi mirdim, meleher ndiɓa ndiɓa ana haɗ, tə̀dəgiki ana zlahay, tə̀hi ahkado : « Nak Wur ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eslini Yezu àzlacaki ka tay ŋgak-ŋgak, àhi ana tay : « Kə̀ɗəfum nu ba. » ");
INSERT INTO muy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yezu àcəloru a həma vu. Eslini àzalay ndam ya ti àdaba tay a ni ; nday nakəŋ tə̀rəkivoru. ");
INSERT INTO muy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ndam ya tìgi ndam gayaŋ ni ti nday kru mahar cʉ : awayay ti tânjəhaɗkabu, mə̂slər tay ga məhioru pakama gayaŋ ana mis ; ");
INSERT INTO muy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","àvi njəɗa ana tay ti tâgariaba seteni ana mis a daya. ");
INSERT INTO muy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nday kru mahar cʉeni ni ti slimi gatay nday hi : Simu àdi slimi Piyer, ");
INSERT INTO muy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","bəza ge Zebede ata Zek nday ata wur ga məŋani Zeŋ ; nday ti Yezu àdi slimi ana tay Bowanerges, awayay aɗəmvaba nday akaɗa ga aday ga avər ya aməcay ni ; ");
INSERT INTO muy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Filip, Bartelemi, Meciyʉ, Tumas, Zek wur ga Alfe, Tade, Simu naŋ bəlaŋ ga ndam ya takaɗvakivu ka haɗ gatay ni, ");
INSERT INTO muy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nahaŋ ni ti ni Zʉdas Iskariyot, bay ya ti amara məsəkumoru Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yezu akaba ndam maɗəbay naŋ ni tàŋga a magam a. Eslini mis dal-dal tàŋgasfəŋvu kà tay keti. Mis ni tə̀bu kay nahkay ti Yezu akaba ndam maɗəbay naŋ ni ahar tekeɗi tə̀ŋgətfəŋ ga məzum zlam do. ");
INSERT INTO muy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndam gayaŋ ni tàra tìcia ti tàra. Tawayay tazay naŋ, tə̀ɗəm ahkado : « Endisl àniviyu va bi. » ");
INSERT INTO muy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ndam *məsər Wakita ge Melefit tə̀bu eslini, tìcikbiyu kwa a Zerʉzalem. Tə̀ɗəm ahkado : « Yezu nahəma, seteni *Belzebʉl àniviyu. Agariaba seteni ana mis a ni ti àna njəɗa ga bay ge seteni nani. » ");
INSERT INTO muy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eslini Yezu àzalay tay, àhi ma ana tay àna ma *gozogul : « Ahəmamam *Seteni esliki magaray ahàr gayaŋ gayaŋani ni mam ? ");
INSERT INTO muy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tamal ndam ga haɗ nahaŋ nday ndayani takaɗvu e kiɗiŋ gatay bu ni ti haɗ gani àŋgoru kama do. ");
INSERT INTO muy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tamal ndam ga huɗ ahay takaɗvu e kiɗiŋ gatay bu ni ti huɗ ahay gani àŋgoru kama do. ");
INSERT INTO muy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Nahkay day tamal Seteni ezirey ahàr gayaŋ ti njəɗa gayaŋ èdeva, àŋgoru kama koksah ; gayaŋ àndava hʉya. » ");
INSERT INTO muy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yezu àɗəm keti : « Mis ahuriyu a ahay ge mis njəɗa-njəɗani vu, mək ahəlfəŋa zlam gayaŋ a mənjəɗ mə̂wəl naŋ ti àgravu koksah. Si tamal àwəla naŋ a day kwa ti ahəlfəŋa zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nəhi ana kʉli nahəma, zlam magudarani ge mis ya tagudar ni ɗek akaba ndivey ya tindivi Melefit ni ɗek ti Melefit ambərfəŋa kà tay a. ");
INSERT INTO muy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ay maslaŋa ya ti endivi Məsuf gayaŋ ni ti, magudar zlam gayaŋ nani ti Melefit àmbərfəŋa ɗay-ɗay do. Maslaŋa nani amanjəhaɗ akaba zlam magudarani gayaŋ ni kaŋgay-kaŋgay hʉya. » ");
INSERT INTO muy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yezu àhəŋgarfəŋ kà pakama gatay ni nahkay ti aɗaba tə̀ɗəm « Seteni àniviyu. » ");
INSERT INTO muy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eslini məŋ ga Yezu akaba bəza ga məŋ ga Yezu tàra tìnjia. Nday e mite bu, tə̀slərkiyu mis ti mâzaliyu naŋ. ");
INSERT INTO muy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ay ti mis tə̀vu dal-dal manjəhaɗani, tèveliŋia ahàr ana Yezu a. Tə̀hi ahkado : « Ata muk akaba bəza ga muk tə̀bu e mite bu, təzalay kur. » ");
INSERT INTO muy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Àhəŋgrifəŋ ana tay, àɗəm ahkado : « Məŋ goro ti way ? Bəza ga mmawa ti ndamam ? » ");
INSERT INTO muy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Eslini Yezu nakəŋ àmənjaləŋ kè mis ya ti tèveliŋi ahàr ni ɗek, àhi ana tay ahkado : « Məŋ goro akaba bəza ga mmawa nahəma, nday hini. ");
INSERT INTO muy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Maslaŋa ya ti agray ere ye ti Melefit awayay ni ti, naŋ nani ti wur ga mmawa zalani, bi walani, mmawa daya. » ");
INSERT INTO muy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yezu òru gwar kà gəvay ga dəluv ni ga macahi zlam ana mis keti. Eslini mis dal-dal tə̀cakalafəŋvu, nahkay naŋ nakəŋ káy àcəliyu a *slalah ga yam vu ka ahàr ga dəluv ni, ànjəhaɗviyu digʉs, àcahi zlam ana tay ; mis macakalavani ni nday tə̀bu kà gəvay ga dəluv ni, təbi slimi. ");
INSERT INTO muy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Àcahi zlam gərgəri kay ana tay àna ma *gozogul. A pakama gayaŋ ya àhi ana tay ni bu ni ti àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","« Cʉm day, maslaŋa nahaŋ àhəraya òru e gili ga mabəhaɗ hilfi ga zlam. ");
INSERT INTO muy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Naŋ àbu abəhaɗoru hilfi ga zlam ni ti ɓal gani àdəgoru e divi vu. Nahkay eɗiɗiŋ tàra tə̀ndaba. ");
INSERT INTO muy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ɓal gani keti àdəgoru ka pəlaɗ ya haɗ àhəcaki ni. Àfətaya hʉya, aɗaba haɗ àki ka pəlaɗ ni kay bi. ");
INSERT INTO muy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Àra àfətaya, fat àra àvəɗia ti èhiriŋaba aɗaba àbiyu sliri a haɗ vu kay ndo. ");
INSERT INTO muy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ɓal gani keti àdəgiyu a adak vu. Àra àfətaya ti adak ni tə̀ɗəkkabu akaba naŋ, tèŋgecekabá naŋ a, nahkay ti àbi bəza ndo. ");
INSERT INTO muy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ɓal gani keti àdəgoru ka haɗ sulumani. Àra àfətaya ti àɗək, àbi bəza. Bəlaŋ gani àbi bəza kru kru mahkər, bəlaŋ gani keti bəza kru kru muku, nahaŋ ni bəza diŋ. » ");
INSERT INTO muy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yezu àɗəm keti : « Maslaŋa ya ti slimi àfəŋ ge mici zlam nahəma, mîci lala ! » ");
INSERT INTO muy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ka ya ti Yezu naŋ àbu cak nahəma, ndam maɗəbay naŋ kru mahar cʉeni ni akaba mis ndahaŋ ya taɗəbay naŋ ni tìhindifiŋa pakama àki ka ma *gozogul gayaŋ ya àɗəm na. ");
INSERT INTO muy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Àhi ana tay ahkado : « Lekʉlʉm ti Melefit àɗəfikiaba zlam maŋgahani àki ka Məgur gayaŋ na ana kʉli a. Ana mis ndahaŋ ga dala ni ti ma gayaŋ ya ahi ana tay ni ɗek ti ma gozogul. ");
INSERT INTO muy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Agray nahkay ti “Ku tamal tamənjaləŋ ka zlam lala nəŋgu ni tìpi ba ; ku tamal təbi slimi ana pakama lala nəŋgu ni tìci ba. Do ni ti atambatkaba məɓəruv gatay a, Melefit ambərfəŋa zlam magudarani gatay ni kà tay a.”  » ");
INSERT INTO muy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yezu àhi ana tay keti : « Kìcʉm ma *gozogul hini do ! Akara kicʉm ndahaŋ ni ɗek ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bay ya ti abəhaɗ hilfi ga zlam ni, naŋ akaɗa bay ya ti àhi pakama ge Melefit ana mis ni. ");
INSERT INTO muy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mis ndahaŋ tə̀bu, nday akaɗa divi ya ti hilfi ga zlam àdəgaki ni : tìcia pakama ge Melefit a, mək *Seteni ara ahəliaba pakama nana ana tay a hʉya. ");
INSERT INTO muy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mis ndahaŋ day tə̀bu, nday akaɗa pəlaɗ ya ti hilfi ga zlam àdəgaki ni : tìcia pakama ge Melefit na ti təgəskabu àna məmərani hʉya. ");
INSERT INTO muy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ay pakama nani àhuriviyu ana tay a məɓəruv vu do, akaɗa ge sliri ya ti tòru a haɗ vu do ni ; təgəskabu ti ga hayaŋani. Tamal zlam zləzlaɗani àdia ahàr ana tay a, ahkay do ni mis təgri daliya ana tay azuhva pakama ge Melefit ni ti təmbrəŋ hʉya, tə̀gəskabu va do. ");
INSERT INTO muy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mis ndahaŋ tə̀bu, nday akaɗa hilfi ga zlam ya ti àdiyu a huɗ ga adak vu ni : tìcia pakama ge Melefit a ti təgəskabu. ");
INSERT INTO muy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ay majalay ahàr ga duniya ariva ana tay a, elimeni agosay tay, zlam gərgərani ndahaŋ egi eri ana tay daya. Zlam nday nani ɗek teŋgecekabu zlam akaɗa ga adak ni. Nahkay ti pakama ya ndam nday nani tìci ni àzaya araŋa do. ");
INSERT INTO muy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mis ndahaŋ ti ni tici pakama ge Melefit ; tìci ti təgəskabu. Nday akaɗa haɗ sulumani ya hilfi ga zlam àdəgaki ni, nahkay təbi bəza. Bəlaŋ gani abi bəza kru kru mahkər, bəlaŋ gani keti bəza kru kru muku, nahaŋ ni bəza diŋ ni. » ");
INSERT INTO muy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yezu nakəŋ àhi ana tay keti : « Maslaŋa àbu ahəmbaki dagəla ke ceŋgel mibefteni, ahkay do ni afiyu ceŋgel ni a zuh slalah vu aw ? Aha ! Afəkaɗ ka məlaŋ zaŋani do aw ! ");
INSERT INTO muy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nəɗəm nahkay ti aɗaba zlam ya ti maŋgahani ni ɗek emipivu, zlam ya ti maɗafani faŋ do ni ɗek emicivu daya. ");
INSERT INTO muy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tamal slimi tə̀fəŋ kè kʉli ge mici zlam nahəma, cʉm ! » ");
INSERT INTO muy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Àhi ana tay keti : « Bumi slimi ana pakama ya ti kicʉm ni. Darama ya lekʉlʉm kəgurumi zlam ana mis ndahaŋ àna naŋ ni ti Melefit day aməguri zlam ana kʉli àna naŋ, mək aməgurikiviyu ana kʉli àkivu. ");
INSERT INTO muy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aɗaba maslaŋa ya ti zlam gayaŋ àbu ni ti atəvikivu. Ay maslaŋa ya ti zlam gayaŋ àbi nahəma, ku ere ye ti àfəŋ ni day atəzafəŋa. » ");
INSERT INTO muy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yezu àhi ana tay keti : « *Məgur ge Melefit ti azavu akaɗa ga bay ya ti abəhaɗ hilfi ga zlam ni. ");
INSERT INTO muy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ku tamal bay nani enji ɗʉwir, ku tamal èpiɗekva, məlavaɗ akaba məlafat gani nəŋgu ni, hilfi ga zlam ni afət, aɗək : ahəmamam afət, aɗək ni ti naŋ àsər do. ");
INSERT INTO muy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Haɗ ni agray zlam zlam gayaŋ : zlam ni afətkiaya, mək abay ahàr. Àra àba ahàr a ti abi bəza kay. ");
INSERT INTO muy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ka ya ti zlam ni àndəha nahəma, bay nani azay məvəɗ gayaŋ, aɗaba sarta ga mabazani ènjia. » ");
INSERT INTO muy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Àɗəm keti : « Məzum *Məgur ge Melefit ti àzavu akaba mam ? Mara maɗafaba àna ma *gozogul weley ? ");
INSERT INTO muy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cʉm day, Məgur ge Melefit ni ti àzavu akaba wur ge hilfi ga zlam gʉziteni, gʉziteni e kiɗiŋ ga bəza ge hilfi ndahaŋ ya a duniya bu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tìzligia ti aɗək, àtam zlam ya ti tizligi e dini bu ni ɗek àna gəɗakani. Aɓal ahar gəɗákani, eɗiɗiŋ tagraviyu lala gatay a huɗ gani vu tata ; tanjəhaɗ e zʉhweri gani bu. » ");
INSERT INTO muy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yezu àcahi ma ge Melefit ana mis àna ma *gozogul kay akaɗa nday hini. Àhi ma ana tay ti ya tisliki miceni tata ni. ");
INSERT INTO muy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma gayaŋ ya àhi ana tay àna ma *gozogul do ni ti àbi, ay ka ya ti naŋ àbu akaba ndam maɗəbay naŋ ni ka ahàr gatay ni ti àɗəfiaba ana tay a ɗek lala. ");
INSERT INTO muy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Məlakarawa gani ti Yezu àhi ana ndam maɗəbay naŋ ni : « Tokumum mədəgum gwar ke ledi ga dəluv ni. » ");
INSERT INTO muy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nahkay nday nakəŋ tàsləkaba e kiɗiŋ ge mis dal-dalani ni ba, tə̀hurkiviyu ka Yezu a *slalah ga yam vu, tàzay naŋ àna naŋ. *Slalah ga yam ndahaŋ tə̀bu kà gəvay gani gayaŋ ya tàzay naŋ àna naŋ ni. ");
INSERT INTO muy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nday tə̀bu təzoru naŋ ti aməɗ gəɗakani àkəzlabiyu ka ahàr ga yam ni, mək yam ni àjaɓasliyu a slalah ga yam ni vu, awayay arəhvù wuɗak. ");
INSERT INTO muy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ka ya ti aməɗ ni naŋ àbu akəzlay nahəma, Yezu naŋ àvu e ɗʉwir bu gwar ke meteliŋ ga slalah ga yam ni, àfəki ahàr ka zlam kuɗ-kuɗani. Naŋ e ɗʉwir bu ni ti nday nakəŋ tèpiɗek naŋ, tə̀hi : « Mʉsi ! Leli ɗek miji ti ahəluk ahàr do aw ? » ");
INSERT INTO muy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Naŋ nakəŋ àra èpiɗekva ti àzlacaki ka aməɗ ni ɓəra, àhi ana yam ni : « Lakakaba ! Kàdaɗay va ba ! » Eslini aməɗ ni àmbrəŋ makəzlani hʉya, yam ni ègia ɗegika. ");
INSERT INTO muy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aməɗ ni àra àmbrəŋa makəzlana ti Yezu àhi ana ndam maɗəbay naŋ ni : « Aŋgwaz awər kʉli ti kamam ? Kekileŋa kə̀fumku ahàr ndo aw ? » ");
INSERT INTO muy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ere ye ti Yezu àgray ni àsia aŋgwaz ana tay a dal-dal, nahkay tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Naŋ hini ti way ? Aməɗ akaba yam day ticiiki slimi ni ! » ");
INSERT INTO muy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yezu akaba ndam maɗəbay naŋ ni tòru ke ledi ga dəluv ka haɗ ga ndam Zerasa. ");
INSERT INTO muy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Àra àhəraya a *slalah ga yam ni ba ni ti zal nahaŋ seteni agray naŋ àhəraya e kiɗiŋ ge mindiviŋ ba, àŋgwivabiyu a ma vu hʉya. ");
INSERT INTO muy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Zal nani ti anjəhaɗ kè mindiviŋ, mis tàmətaɓfəŋa, ku àna jejirɓi day tìsliki məwəl naŋ va do. ");
INSERT INTO muy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ahaslani tə̀wəla naŋ àna jejirɓi a akaba tə̀biviya sisel a asak va sak kay nəŋgu ni, èheɓkaba ɗek. Njəɗa gayaŋ àtama ge mis ya ti təgəs naŋ na. ");
INSERT INTO muy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nahkay ti məlavaɗ akaba məlafat naŋ àbu anjəhaɗ kà məlaŋ ge mindiviŋ, a həma bu ; azlah, esliŋkaba vu gayaŋ àna akur a. ");
INSERT INTO muy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Àra èpibiya Yezu a driŋ ti àzəbiyu asak ; àra ènjia ti àbəhaɗi mirdim grik, meleher ndiɓ ana haɗ. ");
INSERT INTO muy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Àdiki ana zlahay, àhi ahkado : « Nak Yezu Wur ge Melefit naŋ agavəla driŋ ti kaɗəbafua mam ? Nahəŋgalay kur kam-kam àna slimi ge Melefit, kə̀gru daliya ba ti ! » ");
INSERT INTO muy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Àɗəm nahkay ti aɗaba Yezu àhi : « Nak seteni, həraya a maslaŋa hini ba » palam. ");
INSERT INTO muy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yezu èhindifiŋa ma, àhi : « Slimi gayak way ? » Àhəŋgrifəŋ : « Slimi goro Gaslka, aɗaba leli kay dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Àhəŋgalay Yezu dal-dal, àhi : « Kam-kam, kə̀garaba leli ka haɗ hina ba ti ! » ");
INSERT INTO muy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eslini ti mədrə́s tə̀bu kay ka ahar bəlaŋ, təzum zlam kà gəvay ga həma. ");
INSERT INTO muy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nahkay seteni ni tìhindifiŋa ma kà Yezu a, tə̀hi ahkado : « Vi divi gani ana leli, ti mə̂rəkivoru ka mədrə́s nday tegʉni, ga moru məhuriviyani ana tay ti. » ");
INSERT INTO muy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yezu nakəŋ àvi divi gani ana tay. Nahkay seteni ni tə̀mbrəŋ zal nakəŋ, tòru tə̀cəlivù a ahàr vu ana mədrə́s ni, mək mədrə́s ni tə̀dəgiki ana hwa gʉdik. Tàcuhworu, tòru tə̀dəguyu a dəluv ni vu cizliv cizliv. Tagray dəbu cʉ, ɗek tìzia kəɗap. ");
INSERT INTO muy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eslini nday ya ti tajəgay mədrə́s ni day tə̀dəgiki ana hwa tiɗizl bilegeni. Tòru a huɗ ga kəsa vu akaba gili gani, tàra tə̀hibiyu ma gani ana mis. Mis ga kəsa ni tàra ga mamənjaya ere ye ti àgravu na. ");
INSERT INTO muy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tàra tə̀rəkia ka Yezu a ti tìpi bay ya ti seteni Gaslka àsləkiaba a ahàr ba ni naŋ lala, manjəhaɗani digʉsa akaba azana məbakabani, ègia sulumana. Tàra tìpia naŋ a ti aŋgwaz àdəgakia ka tay a silim. ");
INSERT INTO muy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eslini nday ya ti tìpia ere gani nana ni ti tàŋgəhaɗi ma gani ana ndam ga kəsa ni. Tàŋgəhaɗ ere ye ti àgrakivu ke seteni ni akaba ere ye ti àgrakivu ka mədrə́s ni. ");
INSERT INTO muy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tàra tàŋgəhaɗa ti mis ye eslini ni tə̀njəki ka mahəŋgalay Yezu, tə̀hi : « Sləkaba ka haɗ geli a. » ");
INSERT INTO muy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ka ya ti Yezu acəliyu a slalah ga yam ni vu nahəma, zal ya ti seteni àsləkiaba ni àhəŋgalay naŋ, àhi ahkado : « Naɗəbay kur bilegeni ti. » ");
INSERT INTO muy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ay Yezu àhəŋgrifəŋ, àhi : « Aha, ru a magam, kâŋgəhaɗi ere ye ti àgrakukvu ni ɗek ana ndam gayak. Hi ana tay kə̀sia cicihi ana Bay gayak gəɗakana, hi ere ye ti àgruk ni ɗek ana tay. » ");
INSERT INTO muy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nahkay ti zal nakəŋ àsləka, òru a kəsa ga haɗ ni vu ɗek ; təzalay haɗ gani nani *Kəsa Kru. Eslini àŋgəhaɗoru ere ye ti Yezu àgri ni ɗek. Mis ni tàra tìcia ma gana ti àgria ejep ana tay a ɗek. ");
INSERT INTO muy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yezu akaba ndam maɗəbay naŋ ni tàsləka àna slalah ga yam na. Tòru tìnjʉa gwar ke ledi ga dəluv na ti tàhəraya a slalah ga yam ni ba. Ka ya ti Yezu naŋ àbu ka dəŋ-dəŋ ga dəluv ni ti mis dal-dal tàra tèveliŋi ahàr. ");
INSERT INTO muy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eslini maslaŋa nahaŋ təzalay naŋ Zayros àra ; naŋ gəɗakani ga ahay ga *mahəŋgalavù Melefit. Àra èpia Yezu nakəŋ a ti àrəkioru, àbəhaɗ mirdim kè meleher gayaŋ, ahàr ndiɓa ana haɗ. ");
INSERT INTO muy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Àhəŋgalay naŋ kay, àhi ahkado : « Kam-kam, wur goro dahalayani naŋ àbiyu amət ti, nihindi kur ti kâra kə̂bəki *ahar, ti mâŋgaba, àmət ba ti. » ");
INSERT INTO muy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nahkay Yezu nakəŋ òru. Mis dal-dalani ni tèveliŋia ahàr a, tə̀bu taɗəboru naŋ dəɓəsia. ");
INSERT INTO muy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Eslini wal nahaŋ àbu, mimiz asləkafəŋa agray vi kru mahar cʉ. ");
INSERT INTO muy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naŋ àbu acakay daliya àna naŋ dal-dal, àɗəbakaba ndam doktar a ɗek, ègwejelekaba zlam gayaŋ a ɗek, ŋgulum gani day àbi, asagaki asagaki do sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wal nakəŋ àra ècia pakama ya ti tə̀bu təzlapaki ka Yezu na ti òru gwar kələŋ e kiɗiŋ ge mis dal-dalani ni vu, ènjifiŋ kà azana ga Yezu nakəŋ. ");
INSERT INTO muy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Àgray nahkay ti aɗaba àhi ana ahàr : « Tamal ti nìnjifiŋa kà azana gayaŋ na day, naŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eslini mimiz gayaŋ ya ti asləkafəŋa ni àmbrəŋa naŋ a hʉya. Wal nakəŋ àsər araŋa àbi awər naŋ va bi, ègia njalaŋ-njalaŋana. ");
INSERT INTO muy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ka ya ti wal ni àŋgaba nahəma, Yezu àsər hʉya njəɗa gayaŋ àhəŋgaraba maslaŋa. Àra àsərkia nahəma, àmbatvakivu ke mis dal-dalani ni, àhi ana tay ahkado : « Way ènjifiŋ kà azana goro ni way ? » ");
INSERT INTO muy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ndam maɗəbay naŋ ni tə̀hi ahkado : « Ŋgakaday akaba mis damkulkulani ni ti kəsərkaba ahəmamam ti way ènjifʉk way ni ? » ");
INSERT INTO muy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ay Yezu nakəŋ naŋ àbu eheliŋ eri gwar kà gəvay gayaŋ, awayay epi maslaŋa ya ti ènjifiŋ ni. ");
INSERT INTO muy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eslini wal nakəŋ aŋgwaz awər naŋ, naŋ àbu agəgər slaɓ-slaɓ. Naŋ àbu agəgər nahkay ti àrəkia ka Yezu nakəŋ a, àbəhaɗi mirdim meleher ndiɓ ana haɗ, aɗaba àsərkia ke ere ye ti àgrakivu na ; àhiaba jiri gana ɗek. ");
INSERT INTO muy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eslini Yezu nakəŋ àhi ahkado : « Wur goro ni, Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. Sləka, ru àna sulumani ; arməwər gayak ni àŋgukukvu ɗay-ɗay va ba. » ");
INSERT INTO muy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka ya ti Yezu naŋ àbu azlapay nahkay nahəma, mis ndahaŋ tìnjia, tàsləkabiya afa ga gəɗakani ga ahay ga mahəŋgalavù Melefit na, tàra tə̀hi ahkado : « Wur gayak nakəŋ èndeverva. Kekileŋa kiwisiri ahàr ana mʉsi ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ay Yezu àbi slimi ana ma gatay ni ndo, àhi ana gəɗakani ga ahay ga mahəŋgalavù Melefit ni ahkado : « Aŋgwaz àwər kur ba, fəku ahàr ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eslini Yezu àcafəŋa mis ndahaŋ na ɗek ga maɗəboru naŋ a ; àɗəm si ata Piyer, Zek, Zeŋ wur ga məŋ ge Zek ni tâɗəboru naŋ ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tòru a magam afa ga bay ga ahay ga mahəŋgalavù Melefit ni. Tòru tìnjʉa ti tə̀di ahàr ana mis kay titʉwi, təzlah, tagray delʉlʉ. Yezu àra èpia tay a ti ");
INSERT INTO muy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","àhuriyu, àhi ana tay ahkado : « Kazlahum mam ? Kitʉwʉm mam ? Wur ni àmət ndo, naŋ àbu enji ɗʉwir timey. » ");
INSERT INTO muy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Àra àhia pakama ana tay a nahkay ti tèyefiŋ. Eslini Yezu nakəŋ àgaraya mis ya titʉwi na ɗek e mite va, àzay bəŋ ga wur ni, məŋ ga wur ni akaba ndam ya ti tàɗəbabiyu naŋ ni ciliŋ, mək tə̀huriyu ka məlaŋ ya ti tàfəkaɗ wur ni. ");
INSERT INTO muy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tàra tə̀huriya ti Yezu nakəŋ àzay ahar ga wur ni, àhi ahkado : « Talita kumi. » Awayay aɗəmvaba « Wur dahalay, nəhuk, cikaba. » ");
INSERT INTO muy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nahkay ti wur nakəŋ ècikaba hʉya, naŋ àbu asawaɗay. Wur nani ti vi gayaŋ kru mahar cʉ. Àra àŋgaba ti nday ya a ahay bu ni àgria ejep ana tay a kay. ");
INSERT INTO muy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eslini Yezu àləgi ana tay kay, àɗəm : « Ere ye ti nàgray ni ti maslaŋa èci ba. » Mək àhi ana ata bəŋani : « Vumi zlam məzumani. » ");
INSERT INTO muy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yezu àra àsləka kà məlaŋ nana, òru a kəsa gayaŋ vu, ka məlaŋ ya ti àɗək ni. Tòru akaba ndam maɗəbay naŋ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eslini vaɗ *məpəsabana ènjia nahəma, òru a ahay ga *mahəŋgalavù Melefit ni vu, àcahi ma ge Melefit ana mis. Mis ya təbi slimi ni vir-vir. Tàra tìcia ma gayaŋ ya àcahi ana tay na ti àgria ejep ana tay a dal-dal. Tə̀ɗəm ahkado : « Àŋgət ma gani hini eley ? Məsər zlam weley hini weley ? Way àvi njəɗa ga magray ere ye ti ɗay-ɗay mis tìpi ndo ni way ? ");
INSERT INTO muy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naŋ bay madar zlam, wur ga Mari ni do waw ? Bəza ga məŋani ata Zek, Zoze, Zʉd, Simu ni do waw ? Bəza ga məŋani walani nday tə̀bu akaba leli ahalay ni do waw ? » Azuhva nani ti mis nday nani tàwayay məfəki ahàr ka Yezu ndo. ");
INSERT INTO muy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eslini Yezu àɗəm : « Bay məhəŋgri *pakama ge Melefit ana mis ni ti tàwayay naŋ a kəsa gayaŋ bu do. Ata bəŋani akaba ndam ga huɗ ahay gayaŋ day tàwayay naŋ do, si a kəsa ndahaŋ bu kwa ti mis ndahaŋ tawayay naŋ. » ");
INSERT INTO muy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ka məlaŋ gani nani ti Yezu èsliki magray zlam ndahaŋ ya ti mis tìpi ɗay-ɗay ndo ni ndo hʉya, si àbəki *ahar ke mis ndahaŋ ɓal, àhəŋgaraba tay a ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nahkay ndam ga kəsa gayaŋ ni tə̀fəki ahàr ndo. Gatay ya ti tə̀fəki ahàr ndo ni ti àgria ejep a, mək naŋ nakəŋ àsləka, àsawaɗoru a kəsa ndahaŋ vu kà gəvay ga kəsa gayaŋ ni, àcahi zlam ana mis. ");
INSERT INTO muy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eslini Yezu nakəŋ àzalay ndam gayaŋ kru mahar cʉeni ni, ànjəki ka məsləroru tay cʉ cʉ. Wuɗaka tàsləka ti àvia njəɗa ana tay a ga magariaba seteni ana mis a, ");
INSERT INTO muy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","àhi ana tay ahkado : « Kədəgum nihi nahəma, kə̀zum zlam a ahar vu ba, ku zlam məzumani, ku mbolu, ku siŋgu day kə̀həlum e zlembi vu ba. Zum aday a ahar vu, ");
INSERT INTO muy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","bumvu kimaka a asak vu ciliŋ. Kə̀bumkabu endʉwi cʉ cʉ ba daya. » ");
INSERT INTO muy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Àhi ana tay keti : « Ka ya ti akəhurumiya a ahay va afa ge mis a nahəma, njəhaɗuma eslina ; kàmbatum ahay nahaŋ ba duk abivoru ana vaɗ gekʉli ya akəsləkuma ni. ");
INSERT INTO muy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ay ka məlaŋ ya ti kədəgum ni, tamal ti tə̀gəskabu kʉli do, tàwayay miciki pakama gekʉli ni ana kʉli do nahəma, sləkuma eslina. Ka ya ti kəsləkuma ni ti təkumkaba haɗ ga kəsa gatay na kà asak gekʉli a. Nahkay ti atəsərki ka magudar zlam gatay ni. » ");
INSERT INTO muy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Eslini nday nakəŋ tə̀həlvu hurum, tòru, tə̀hioru ma ge Melefit ana mis, tə̀ɗəm ahkado : « Ahàr àɗəm kâmbatumkaba majalay ahàr gekʉli a kwa. » ");
INSERT INTO muy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tàgariaba seteni ana mis a kay daya ; tàgrakia amal ka ndam ga arməwər a kay, tàhəŋgaraba tay a. ");
INSERT INTO muy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nahkay mis tə̀bu təzlapaki ka Yezu gwar eley gwar eley do ɗek. Tə̀bu təzlapaki nahəma, bay *Erot ècia pakama gatay ya ti tə̀ɗəm na. Aɗaba mis ndahaŋ tə̀ɗəm Yezu ti naŋ Zeŋ bay məbaray mis ni, àməta mək àŋgaba e kisim ba. Tə̀ɗəm agray zlam magray ejep tata ti aɗaba àŋgaba e kisim ba. ");
INSERT INTO muy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mis ndahaŋ ti ni tə̀ɗəm naŋ Eli bay mahəŋgaray *pakama ge Melefit ni. Mis ndahaŋ keti tə̀ɗəm naŋ bay mahəŋgaray *pakama ge Melefit akaɗa ga nday ya ti ahaslani ni. ");
INSERT INTO muy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Erot àra ècia pakama nana zla nahəma, àɗəm ahkado : « Naŋ ti Zeŋ bay məbaray mis ni. Nèkelkia ahàr a, nihi ti àŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Bay Erot àɗəm nahkay ti azuhva zlam ya àgravu ni. Zlam gani nihi : Erot àzafəŋa Erodiyat wal ge Filip a ; Filip ti wur ga məŋ ga Erot. Àra àza wal na ti Zeŋ bay məbaray mis ni àhi ahkado : « Kàzafəŋa wal kà wur ga muk a ti àwəsl. » Zeŋ àra àhia ma nahkay ti bay Erot nakəŋ àhi ana ndam gayaŋ tə̂gəs naŋ, tə̂wəl, tə̂fiyu a daŋgay vu, mək tàgray nahkay. ");
INSERT INTO muy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiyat nakəŋ àra ècia ma ge Zeŋ na ti àwayay ti epi Zeŋ kè eri do simiteni, awayay akaɗ naŋ. Ay ti èsliki do, ");
INSERT INTO muy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","aɗaba bay Erot agrafəŋa aŋgwaz kè Zeŋ a, àsəra Zeŋ ti mis jireni, àgudar zlam do. Nahkay Erot awayay ti maslaŋa àgri araŋa ba. Awayay məbi slimi ana pakama ge Zeŋ ya ti àɗəm ni ; àra ècia ti ahəli ahàr sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","A vaɗ nahaŋ Erodiyat nakəŋ àŋgətfəŋa eviɗ a. Ka fat nani Erot àgray wuməri ge miwivu gayaŋ ; àzalakabu ndam ga ŋgumna gəɗákani, gəɗákani ga ndam slewja gayaŋ akaba ndam ge elimeni ga haɗ *Gelili ni. ");
INSERT INTO muy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ka ya ti nday tə̀bu təzum zlam nahəma, wur ga Erodiyat dahalayani àhurkiviyu ka tay, mək àhəɓay kè meleher gatay. Àhəɓay nahkay ti, həɓay gayaŋ ni ègia eri ana bay Erot a, ègia eri ana mis ya ti àzalakabu tay na daya. Ègia eri ana tay a nahkay ti bay ni àhi ana wur dahalay ni : « Hindifua ere ye ti nak kawayay na ti nəvuk. » ");
INSERT INTO muy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Àmbaɗi dək, àhi ahkado : « Ere ye ti kihindifua ni, ku tamal kawayay telma ga haɗ ya nəgur ni day nəŋgu ni, nəvuk. » ");
INSERT INTO muy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Eslini wur dahalay ni àhəraya, àrəkioru ka məŋani Erodiyat, àhi ahkado : « Nihindifiŋa mam ? » Məŋani nakəŋ àhəŋgrifəŋ, àhi ahkado : « Ru kə̂hi nahəma : “Nawayay ahàr ge Zeŋ bay məbaray mis ni.” » ");
INSERT INTO muy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nahkay wur dahalay ni àcuhwakibiyu ka bay nakəŋ, àhi ahkado : « Nawayay ti kə̂vu ahàr ge Zeŋ bay məbaray mis ni nihi hʉya, tə̂fukibiya ka paranti a ! » ");
INSERT INTO muy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bay ni àra ècia pakama ga wur na ti àhəlia ahàr a. Akaba nani ɗek, àwayay mekeli ere ye ti èhindiliŋ ni do, aɗaba àmbaɗia ana wur na kè meleher ge mis na. ");
INSERT INTO muy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nahkay àslər bəlaŋ ga ndam slewja gayaŋ ni hʉya ti môru mêkelkibiya ahàr ge Zeŋ nakəŋ a. Eslini zal slewja ni òru a ahay ga daŋgay ni vu, èkelkibiya ahàr na, ");
INSERT INTO muy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","àzibiyu ka paranti, àvi ana wur dahalay ni. Wur dahalay ni mək àzikaboru ana məŋani. ");
INSERT INTO muy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ndam maɗəbay Zeŋ ni tàra tìcia ma gana ti tòru tàzay kisim gani, tə̀fiyu e mindiviŋ vu. ");
INSERT INTO muy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A vaɗ nahaŋ ndam *asak ga Yezu ni tàsləkabiya ka məlaŋ ya ti Yezu àsləroru tay na. Tàra tàsləkabiya ti tàŋgəhaɗiaba ere ye ti tàgrabiyu na, akaba ere ye ti tə̀cahibiyu ana mis na ɗek. ");
INSERT INTO muy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ka ya ti nday tə̀bu eslini ni ti mis ya ti tərəkia ka tay a ni akaba ya ti tasləka ni dal-dal àsaɓay ; nahkay Yezu akaba ndam maɗəbay naŋ ni zlam məzumani tekeɗi tə̀ŋgətfəŋ ahar ndo. Eslini Yezu àhi ana ndam maɗəbay naŋ ni : « Dəguma mədəgum a huɗ gili vu, ti kə̂pəsumaba gʉzit, do ni ti ahəmamam. » ");
INSERT INTO muy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nahkay tə̀cəliyu a *slalah ga yam vu, tə̀bu tasləka takoru a huɗ gili ni vu ti ");
INSERT INTO muy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","mis dal-dalani ni tìpia tay a, tə̀sərikia zuh ana tay a, mək mis ga kəsa ga haɗ ni ɗek tàcuhworu àna asak ka məlaŋ ya ti nday takoru ni. Wuɗaka Yezu akaba ndam maɗəbay naŋ ni tìnjiyu ti mis ni tàŋgasva eslina àndava. ");
INSERT INTO muy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ka ya ti Yezu àhəraya a slalah ga yam ni ba nahəma, èpi ti mis ni eslini vir-vir. Naŋ nakəŋ mis ni tə̀sia cicihi a, aɗaba èpi tay ti àhi ana ahàr nday akaɗa ga təmbəmbak ya ti bay majəgay tay àbi ni. Nahkay ti èzliri ana macahi zlam ana tay kay. ");
INSERT INTO muy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Àra àpəskia kay ti ndam maɗəbay naŋ ni tə̀rəkia, tə̀hi ahkado : « Leli hi ti a huɗ gili bu, sarta day àbi va bi. ");
INSERT INTO muy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Hi ana mis ni tâsləka, tôru a kəsa gərgərani ni vu ahkay do ni tôru a ahay ge mis ye e gili ni vu, tâɗəboru zlam məzumani. » ");
INSERT INTO muy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ay Yezu àhəŋgrifəŋ ana tay, àɗəm : « Lekʉlʉm lekʉlʉmeni vumi zlam məzumani ana tay. » Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi ahkado : « Kawayay ti môru mə̂səkumibiyu *dipeŋ ana mis dambas-dambasani ni ti tə̂zum aw ? Siŋgu gani agray jik diŋ diŋ cʉ emiteni ti àsaɓay do waw ? » ");
INSERT INTO muy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eslini Yezu àhi ana tay : « Ŋgakaday, dipeŋ àfəŋ kè kʉli ti ehimey ? Dəgum, kəmənjumiyu day. » Nday nakəŋ tə̀mənjiyu. Tàra tə̀mənjiya ti tə̀hi ahkado : « Dipeŋ àbu nday zlam tàkivu kilif cʉ ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yezu àhi ana tay : « Humi ana mis ni ti têdevu tânjəhaɗa njəlukluk ke kʉzir míɗeni hina. » ");
INSERT INTO muy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nahkay ti tànjəhaɗkabá njəlukluk : mis diŋ diŋ, ndahaŋ ti ni kru kru zlam kru kru zlam. ");
INSERT INTO muy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eslini Yezu nakəŋ àhəl dipeŋ zlamani ni tàkivu kilif cʉeni ni, àmənjoru e melefit vu, àgri sʉsi ana Melefit. Àra àgria sʉsi a ti èsekaba dipeŋ na, mək àbi ana ndam maɗəbay naŋ ni ti tîdi ana mis ni ɗek. Èdikivu kilif cʉeni ni ana tay ɗek daya. ");
INSERT INTO muy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mis nakəŋ ɗek tə̀zum, tə̀zum, tə̀rəhkaba. ");
INSERT INTO muy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kələŋ gani tə̀cakalakabu məgəjəni ge dipeŋ ni akaba ge kilif ni, tə̀rəhvù hətək kru mahar cʉ àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mis zawalani ya ti tə̀zum zlam eslini ni ti agray dəbu zlam. ");
INSERT INTO muy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ka gani nani ti Yezu àhi ana ndam maɗəbay naŋ ni tə̂cəliyu a *slalah ga yam vu, tôru kama gayaŋ hayaŋ ke ledi ga dəluv ni gwar a Beceyda, day kwa ti naŋ naŋani aməhi ana mis ni ti têdevu, tâsləka. ");
INSERT INTO muy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tàra tèdeva akaba mis na ti Yezu nakəŋ àcəloru a həma vu ga mahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Məlaŋ àra èɗiza ti ndam *maɗəbay Yezu ni nday tə̀bu ka ahàr gatay a slalah ga yam ni bu e kiɗiŋ ga dəluv ni bu. Yezu ti ni naŋ ka dəŋ-dəŋ naŋ bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Àmənjoru ti ndam maɗəbay naŋ ni tə̀bu tagaroru slalah ga yam ni ga njəɗa, təcakoru daliya àsaɓay aɗaba aməɗ àbu ahəŋgarbiyu tay kələŋ. Dʉ gwendeli-gwendeli ti naŋ nakəŋ àrəkioru ka tay, asawaɗakioru ka ahàr ga yam ni njuwaŋ-njuwaŋ. Awayay asafəŋa divi kà tay a wuɗak. ");
INSERT INTO muy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nday nakəŋ tàra tìpia naŋ a, naŋ àbu asawaɗaki ka ahàr ga yam nahkay ti, tə̀ɗəm maslaŋa àmbavakiva ka tay a, tə̀dəgi ana zlahay. ");
INSERT INTO muy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nday ɗek tìpia naŋ a ti tàgra aŋgwaz a àsaɓay. Ay naŋ nakəŋ àhi ma ana tay hʉya, àɗəm : « Zum njəɗa, nu timey. Aŋgwaz àwər kʉli ba. » ");
INSERT INTO muy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eslini àhurkiviyu ka tay a slalah ga yam ni vu. Àra àhurkiviya ka tay a ti aməɗ ni day àmbrəŋ makəzlani hʉya. Ere ye ti àgravu ni ɗek ti àgria ejep ana ndam maɗəbay naŋ na dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Zlam ga Yezu ya àgray àna *dipeŋ ni aɗafaki njəɗa gayaŋ gəɗakani, ay ndam maɗəbay naŋ ni tə̀sər do ; majalay ahàr gatay àhəciyu. ");
INSERT INTO muy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ka ya ti tàsləka tə̀həra dəluv na àndava ni ti, nday ka dəŋ-dəŋ ka haɗ Zenizaret. ");
INSERT INTO muy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eslini tàhəraya a *slalah ga yam ni ba. Tàra tàhəraya ti mis ga haɗ nani tə̀səra Yezu a hʉya. ");
INSERT INTO muy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tàra tə̀səra naŋ a ti tàcuhworu a kəsa ga haɗ ni vu ɗek, tə̀həlibiyu ndam ga arməwər ka slalah ka məlaŋ ya tə̀ɗəm naŋ naŋ àvu ni. ");
INSERT INTO muy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ka məlaŋ ya ti Yezu ènjʉa ni lu, ku e gili, ku a kəsa ciɓ-ciɓeni bu, ku a kəsa gəɗákani bu ni ti mis təhəlibiyu ndam ga arməwər, tabəhaɗi e mite bu. Təgri kam-kam ti mis nday nani ya tèɓesey do ni tînjifiŋ kà ma ga azana gayaŋ ni ciliŋ. Nday ya ti tìnjifiŋa ni ɗek tàŋgaba. ");
INSERT INTO muy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A vaɗ nahaŋ mis ndahaŋ e kiɗiŋ ga ndam *məsər Wakita ge Melefit ni bu tìcikbiyu a Zerʉzalem. Tàra tìnjia ti tə̀cakalafəŋvu kà Yezu akaba ndam *Feriziyeŋ. ");
INSERT INTO muy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Eslini tìpi ndam *maɗəbay Yezu ndahaŋ ni ɓal, təzum zlam ti tàbarakaba ahar àna divi gana day do. Tàra tìpia nahkay ti tə̀ɗəm : « Tə̀zum zlam ahar gatay ni *njəlata do. » ");
INSERT INTO muy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tə̀ɗəm nahkay ti aɗaba ndam *Zʉde ɗek, ahar gəɗakani nday Feriziyeŋ ni, təzum zlam wuɗaka nahəma, tabarakaba ahar àna divi gana day. Tagray nahkay ti aɗaba tə̀gəskabá divi ga ndam gəɗákani gatay ya ahaslani na. ");
INSERT INTO muy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ku tamal tàsləkabiya a gosku ba nəŋgu ni, tìnjia a magam a ti wuɗaka təzum zlam ti tabaray àna divi gani day. Zlam ndahaŋ kay ya təgəskabu ni tə̀bu tagray gərgəri : ku hijiyem gatay day tabarafəŋa lala, ku mandaray nəŋgu ni, ku misek ga ara gatay day tabarafəŋa àna divi gana akaɗa ga ndam gəɗákani gatay ya tàgray ahaslani ni. ");
INSERT INTO muy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nahkay ndam Feriziyeŋ akaba ndam məsər Wakita ge Melefit nakəŋ tìhindi Yezu, tə̀hi ahkado : « Ndam maɗəbay kur ni tə̀gəskabu magray zlam akaɗa ga ata bəŋ geli ya ahaslani tə̀ɗəfiki ana leli ni do, tə̀zum zlam àna ahar njəlatani do ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yezu àhəŋgrifəŋ ana tay : « Lekʉlʉm kawayum ti mis tə̂ɗəm lekʉlʉm ndam jireni, ay ti lekʉlʉm ndam jireni do ! Melefit àɗəma ma sulumana a wakita ga bay mahəŋgaray pakama gayaŋ Izayi ni ba. Pakama gayaŋ ya ti àɗəm ni, àɗəmki ti ke kʉli. Àɗəm ahkado : “Mis hini tazləbay nu àna ma ciliŋ, tə̀jalaku ahàr do simiteni. ");
INSERT INTO muy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tazləbay nu ti masakani, aɗaba zlam gatay ya təcahay ni ti ka mawayay ge mis ciliŋ, do ni ti ka mawayay goro do.”  » ");
INSERT INTO muy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yezu àhi ana tay keti : « Lekʉlʉm ti kəmbrəŋum Divi ge Melefit ya àbu məbəkiani a Wakita gayaŋ bu ni, kəgəsumkabu ma ge mis ya ahaslani ya tə̀cahi ana kʉli ni sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Àhi ana tay keti : « Àɓəlay ! Kə̀mbrəŋuma *Divi ge Melefit na, aɗaba kawayum məbi slimi ana manjəhaɗ ga ndam gekʉli ya ahaslani ni zla do waw ! ");
INSERT INTO muy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bay Melefit àɗəm a wakita ge Mʉwiz ya àbəki ni bu : “Ŋgwioru a haɗ ana ata buk ata muk.” Àɗəm keti : “Bay ya ti endivi bəŋani ahkay do ni məŋani nahəma, tâkaɗa naŋ a.” ");
INSERT INTO muy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ay lekʉlʉm zla ti kəɗəmum ahkado : “Maslaŋa nahaŋ esliki məhiani ana bəŋani ahkay do ni ana məŋani : Ere ye ti akal nu nəjənaki kur àna naŋ ni ti korbaŋ : korbaŋ ti sədaga ge Melefit.” ");
INSERT INTO muy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Maslaŋa nani tamal àɗəma ma nahkay, mək àjənaki ata bəŋani ata məŋani va do ni ti, kə̀ɗəmum àɓəlay. ");
INSERT INTO muy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lekʉlʉm kəgrum nahkay ni ti kə̀mbrəŋuma pakama ge Melefit nana pəsak. Kə̀mbrəŋuma ti kəfumviyu pakama gekʉli ya kacahum ni a məlaŋ gani vu huk. Kə̀bum kəgrum zlam ndahaŋ kay akaɗa nani daya. » ");
INSERT INTO muy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yezu àra àhia pakama ana tay a nahkay nahəma, àzalakabu mis kayani ni keti, àhi ana tay : « Lekʉlʉm ɗek bumi slimi ana pakama goro ya nəɗəm ni, ti kîcʉm lala. ");
INSERT INTO muy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ere ye ti a dala bu, ahuriyu a huɗ ge mis vu ni ti agray naŋ “*njəlatani do” ni ti àbi. Si ere ye ti maslaŋa gani aɗəm àna ma gayaŋ ni day kwa ti agray naŋ “njəlatani do.”  ");
INSERT INTO muy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tamal slimi àfəŋ kè kʉli ge mici zlam nahəma, cʉm ! » ");
INSERT INTO muy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kələŋ gani Yezu àhəɗakfəŋa kè mis dal-dalani na, cak òru àhuriyu a ahay vu. Eslini ndam maɗəbay naŋ ni tìhindifiŋa ma *gozogul gayaŋ ya àhi ana mis na. ");
INSERT INTO muy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yezu àhəŋgrifəŋ ana tay, àɗəm ahkado : « Lekʉlʉm day kə̀sərum zlam do waw ? Nəɗəm nahəma, ŋgay ere ye ti a dala bu, ahuriyu a huɗ ge mis vu, agudar naŋ akaba agray naŋ “njəlatani do” ni àbi ti kicʉm do waw ? ");
INSERT INTO muy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aɗaba àhuriyu a məɓəruv gayaŋ vu do, ahuriyu ti a huɗ vu ciliŋ, mək tətəhiyu azay gani e dʉgzey vu. » Yezu àɗəm nahkay ti àɗəm zlam məzumani ɗek njəlata. ");
INSERT INTO muy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Àɗəm keti : « Ere ye ti ahəraya a məɓəruv ge mis ba ni ti, nani day kwa ti agudar naŋ, agray naŋ “njəlatani do.” ");
INSERT INTO muy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aɗaba zlam magudarani ɗek ahəraya ti a məɓəruv ge mis ba : təjalaki ahàr ka zlam magudarani, tagray mesʉwehvu, tigi akal, tabazl mis, ");
INSERT INTO muy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tagray hala, zlam ge mis egi eri ana tay, tagray cuɗay, tagosay mis, tìci slimi do, tagray solu, təsivu ana mis, tiji zlabay, endisl àniviyu ana tay bi. ");
INSERT INTO muy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Zlam nday nani ɗek ti zlam magudarani, tahəraya a məɓəruv ge mis ba. Tàhəraya ti tagudar naŋ, tagray naŋ “njəlatani do.” » ");
INSERT INTO muy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yezu àsləkaba eslina, òru ka haɗ ga kəsa Tir. Òru ènjʉa ti àhuriyu a ahay vu afa ga maslaŋa nahaŋ, mək ànjəhaɗ eslini. Awayay ti mis tə̀sər məlaŋ gayaŋ ya naŋ naŋ àvu ni ba. Akaba nani ɗek mis tàra tə̀səra məlaŋ gana sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Nahkay ti wal nahaŋ àbu, naŋ wur Zʉde do, naŋ wur Fenisi ga haɗ Siri. Wur gayaŋ dahalayani àbu, seteni àniviyu. Wal nakəŋ àra ècia tə̀bu təzlapaki ka Yezu nahəma, àrəkia hʉya. Àra ènjia ti àbəhaɗi mirdim grik, meleher ndiɓ ana haɗ, àhi ana Yezu : « Kam-kam, gariaba seteni ana wur goro na ti. » ");
INSERT INTO muy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ay Yezu àhəŋgrifəŋ ana wal ni, àhi ahkado : « Mbrəŋ bəza tə̂zum zlam tə̂rəh, do ni ti təzafəŋa zlam məzumani ga bəza, tizligioru ana kərá ti àɓəlay do. » ");
INSERT INTO muy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mək wal nakəŋ àɗəm : « Nahkay, bay goro. Ay ti pis-pis ga zlam məzumani ga bəza ya tadəgoru a huɗ ga məlaŋ məzumki zlam vu ni ti ku kərá day tapalaba, təzum timey. » ");
INSERT INTO muy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yezu àra ècia ma ga wal na ti àhi : « Kə̀həŋgrufəŋ nahkay nahəma, seteni ni àsləkiaba ana wur gayak na àndava. Ru a magam. » ");
INSERT INTO muy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nahkay wal nakəŋ àsləka. Òru ènjʉa a magam a ti àdi ahàr ana wur gayaŋ dahalayani ni mandəhaɗani ɓəlaha ka slalah. Seteni ni àsləkiaba eɗeɗiŋ a. ");
INSERT INTO muy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yezu nakəŋ ka haɗ ga kəsa Tir na, òru a kəsa Sidoŋ vu. Àsləka eslina ti òru ka haɗ *Kəsa Kru, mək àŋga gwar ka dəluv Gelili a. ");
INSERT INTO muy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Àra ènjia eslina ti mis tə̀zibiyu zal makwaya nahaŋ, àsər mazlapani lala koksah. Tàra tìnjia àna naŋ a ti tàhəŋgalay Yezu, tə̀hi : « Kam-kam, fəki ahar gayak ka naŋ hini ti mâŋgaba, mîci slimi, mâzlapay lala ti. » ");
INSERT INTO muy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nahkay ti Yezu nakəŋ àzaba naŋ a cak e kiɗiŋ ge mis dal-dalani ni ba. Ka ya ti nday tə̀bu ka ahàr gatay ni ti àbiviyu weleher e slimi vu cecʉeni. Àhəliaba weleher na ti ètifa esliɓ a, ènjiifiŋ kà arəɗ ; ");
INSERT INTO muy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mək àmənjoru e melefit vu, àsuf yah, àhi ana zal nakəŋ : « Efata. » Awayay aɗəmvaba : « Zləkvaba. » ");
INSERT INTO muy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eslini slimi ga zal nakəŋ àzləkvaba, èci slimi lala hʉya. Arəɗ gayaŋ ni day ègigiri va do, azlapay lala. ");
INSERT INTO muy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yezu àra àhəŋgaraba maslaŋa nana ti àhi ana tay : « Kə̀humi ere ye ti nàgray ni ana maslaŋa ba. » Ay ba Yezu àhi ana tay « Kə̀ɗəmum ba, » nday ti ni tìciiki do, ba tə̀ɗəmoru sək sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nahkay ere ye ti àgray ni àgria ejep ana mis a dal-dal. Tə̀ɗəm ahkado : « Ere ye ti agray ni ɗek àɓəlay àsaɓay. Ahəŋgaraba ndam makwaya, tici slimi. Ahəŋgaraba ndam ya ti tə̀zlapay koksah na daya, təzlapay lala. » ");
INSERT INTO muy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ka gani nani nahəma, mis kay tə̀rəkia ka Yezu a keti. Nday tə̀bu eslini akaba naŋ ti zlam məzumani day àfəŋ kà tay bi. Eslini Yezu àzalay ndam maɗəbay naŋ ni, àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","« Mis nday hini təsu cicihi dal-dal, aɗaba vaɗ mahkər hi leli mə̀bu akaba tay, zlam məzumani day àfəŋ kà tay va bi. ");
INSERT INTO muy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tamal nəhi ana tay “Sləkuma” mənjəɗ məvi zlam məzumani ana tay nahəma, njəɗa amələfəŋ kà tay ka ahàr divi ga masləkana bi, aɗaba mis ndahaŋ e kiɗiŋ gatay bu tàsləkabiya ka məlaŋ driŋena. » ");
INSERT INTO muy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndam maɗəbay naŋ ni tə̀həŋgrifəŋ, tə̀hi ahkado : « Leli ɗek ahalay a huɗ gili hini bu ni ti, təhəlibiyu *dipeŋ ana tay tərəh àna naŋ ɗek ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eslini Yezu nakəŋ èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Dipeŋ àfəŋ kè kʉli ehimey ? » Tə̀həŋgrifəŋ : « Àfəŋ kè leli adəskəla. » ");
INSERT INTO muy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eslini àhi ana mis dal-dalani ni tânjəhaɗa a ga haɗ a. Tàra tànjəhaɗa ti àhəl dipeŋ adəskəlani ni, àgri sʉsi ana Melefit. Àra àgria sʉsi a ti èsekaba dipeŋ na, àbi ana ndam maɗəbay naŋ ni, àhi ana tay : « Dʉmi ana mis ni ɗek. » Nahkay ndam maɗəbay naŋ nakəŋ tìdi ana mis dal-dalani ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kilif ciɓ-ciɓeni tə̀fəŋ kà tay gʉzit daya. Yezu àgraki sʉsi ke kilif ni, mək àhi ana ndam maɗəbay naŋ ni : « Dʉmikivu ana tay. » ");
INSERT INTO muy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mis nakəŋ ɗek tə̀zum, tə̀rəha àna naŋ a. Tə̀cakalaviyu məgəjəni ga zlam məzumani ni a hətək vu, tə̀rəhvù hətək adəskəla àna naŋ. ");
INSERT INTO muy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mis ya tə̀zum zlam eslini ni ti agray mis dəbu faɗ. Kələŋ gani Yezu nakəŋ àhi ana mis ni tâsləka. ");
INSERT INTO muy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mis ni tàra tàsləka ti Yezu akaba ndam maɗəbay naŋ ni tə̀cəliyu a *slalah ga yam vu hʉya, tòru ka haɗ Dalmanuta. ");
INSERT INTO muy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yezu naŋ àbu eslini ti ndam *Feriziyeŋ ndahaŋ tə̀rəkia, tə̀bu tagray gejewi akaba naŋ. Tagrakabá gejewi a nahkay ti tawayay tatəkar naŋ ti mâgudar zlam, tə̀hi : « Griaya ere ye ti mìpi ɗay-ɗay ndo na ana leli a, ti mə̂sər ere ye ti kagray ni kagray ti àna njəɗa ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yezu nakəŋ àra ècia ma gatay na ti àdi ana njiɗey a gugum vu. Àhi ana tay : « Ndam ye e hini vu ni ti tihindi ere ye ti tìpi ɗay-ɗay ndo ni ti kamam ? Nəhi ana kʉli nahəma, ere ye ti tihindi ni ti Melefit aməgri ana ndam ye e hini vu ni do simiteni. » ");
INSERT INTO muy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eslini àmbərbu tay ndəɓak, àcəliyu a *slalah ga yam ni vu, tàsləka akaba ndam maɗəbay naŋ na, tòru gwar ke ledi ga dəluv ni. ");
INSERT INTO muy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nday tə̀bu takoru àna *slalah ga yam ni ti ndam *maɗəbay Yezu nakəŋ tə̀həl *dipeŋ ndo, àgəjazlkia ahàr ka tay a. ");
INSERT INTO muy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eslini ti Yezu àhi ana tay : « Bumvu slimi ana *miwisiŋ ga ndam *Feriziyeŋ ni akaba ga ndam ga bay *Erot ni. » ");
INSERT INTO muy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nahkay tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm : « Àɗəm nahkay ti aɗaba dipeŋ àfəŋ kè leli bi palam. » ");
INSERT INTO muy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yezu nakəŋ àra ècia pakama gatay na ti àhi ana tay : « Dipeŋ àfəŋ kè kʉli bi ni ti kəɗəmum kamam ? Kìcʉm ma goro ni do, kə̀sərum do kekileŋa waw ? Kàwayum micʉmeni do zla tək ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Eri gekʉli ni ti kìpʉm divi àna naŋ do waw ? Slimi gekʉli ni day kìcʉm slimi àna naŋ do waw ? Ere ya nàgray ni ti kə̀sərumki va do waw ? ");
INSERT INTO muy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ka ya ti nìsikaba dipeŋ zlamani ana mis dəbu zlamani na ti, məgəjəni gani ya kə̀həlumaba ni ti hətək mərəhvani ehimey ? » Tə̀həŋgrifəŋ : « Hətək mərəhvani kru mahar cʉ. » ");
INSERT INTO muy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Àɗəm keti : « Ka ya ti nìsikaba dipeŋ adəskəlani ana mis dəbu faɗani na ti, məgəjəni gani ya kə̀həlumaba ni ti hətək mərəhvani ehimey ? » Tə̀həŋgrifəŋ : « Hətək mərəhvani adəskəla. » ");
INSERT INTO muy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Àhi ana tay keti : « Kekileŋa kìcʉm do waw ? » ");
INSERT INTO muy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yezu akaba ndam maɗəbay naŋ ni tòru a Beceyda. Tòru tìnjʉa ti mis ndahaŋ tə̀zibiyu zal wuluf, mək tə̀gri kam-kam ana Yezu ti mînjifiŋ, ti zal nani mâŋgaba. ");
INSERT INTO muy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nahkay Yezu nakəŋ àdafəŋa ahar kà zal nakəŋ a, tata àzoru naŋ cak àfəŋ kà kəsa. Tòru tìnjʉa eslina ti ètifikiyu esliɓ ke eri, mək àbiki ahar ke eri, èhindifiŋa ma, àhi : « Kə̀bu kipi divi aw ? » ");
INSERT INTO muy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zal wuluf nakəŋ èzefteba ahàr a, àɗəm : « Nə̀bu nipi mis zʉ-zʉ kə̀ɗəm məŋgəhaf, ay ti nday tə̀bu təsawaɗay. » ");
INSERT INTO muy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eslini Yezu nakəŋ àbiki ahar ke eri keti. Àra àbikia ahar na ti zal wuluf ni àhəlkaba eri a, àŋgaba, epi divi lala. ");
INSERT INTO muy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yezu àhi : « Sləka, ru a magam. Kasləka nihi nahəma, kòru gwar a kəsa vu ba. » ");
INSERT INTO muy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A vaɗ nahaŋ, Yezu akaba ndam maɗəbay naŋ ni tə̀bu tasləkaba a kəsa ciɓ-ciɓeni ya tə̀bu kà gəvay ga Sezare ge Filip na. Ka ahàr divi zla ti èhindifiŋa kà tay a, àhi ana tay : « Mis ti tə̀ɗəm nu ti nu way ? » ");
INSERT INTO muy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tə̀həŋgrifəŋ, tə̀hi ahkado : « Tə̀ɗəm nak Zeŋ bay məbaray mis ni, mis ndahaŋ tə̀ɗəm nak Eli, mis ndahaŋ ti ni tə̀ɗəm nak biliŋ ga ndam ya tàhəŋgaray *pakama ge Melefit ahaslani ni. » ");
INSERT INTO muy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eslini naŋ nakəŋ èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Lekʉlʉm ti, kəɗəmum nu ti nu way ? » Piyer àhəŋgrifəŋ, àhi ahkado : « Nak *Krist *Bay gəɗakani ya Melefit àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yezu nakəŋ àra ècia ma ge Piyer na ti àləgi ana tay, àɗəm ahkado : « Iy nahkay. Ay ti kə̀ɗəfumi nu ana maslaŋa ba simiteni. » ");
INSERT INTO muy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Eslini Yezu ànjəki ka macahi zlam ana ndam maɗəbay naŋ ni. Àhi ana tay : « Ahàr àɗəm nu *Wur ge Mis nə̂cakay daliya dal-dal. Nday gəɗákani ni, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni atawayay nu do, atakaɗ nu. Mək a huɗ ga vaɗ mahkərani bu anaŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Àhi ana tay vay-vay, do ni ti èmbrifiŋ ana tay ndo. Piyer àra ècia ma gayaŋ na ti àzaba naŋ e kiɗiŋ gatay ba cak, àləgiki ka pakama gayaŋ ni. ");
INSERT INTO muy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ay Yezu àmbatkibiyu ma ka ndam maɗəbay naŋ ni tuwəli, àləgi ana Piyer bilegeni, àɗəm : « *Seteni, sləkafua, ru driŋ ! Majalay ahàr gayak ti akaɗa ge Melefit ni do, kajalay ahàr ti akaɗa ge mis hihirikeni ni. » ");
INSERT INTO muy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eslini ti mis tə̀bu kay macakalavani. Nahkay Yezu àzalay tay akaba ndam maɗəbay naŋ ni. Tàra tìnjikia ti àhi ana tay ahkado : « Tamal mis awayay maɗəbay nu nahəma, ahàr àɗəm mə̂mbrəŋ ere ye ti awayay ni, ku tamal təgri daliya, *tadarfəŋ naŋ kà təndal nəŋgu ni mîɓesey. Tamal mis awayay maɗəbay nu ti mâgray nahkay. ");
INSERT INTO muy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Maslaŋa ya ti àɗəm ajəgur sifa gayaŋ, awayay àmət ba ni ti emijiŋ. Maslaŋa ya ti emijiŋ sifa gayaŋ azuhva nu akaba *Ma Mʉweni Sulumani ni ti aməjəgur sawaŋ, aməmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamal mis àŋgəta elimeni ga duniya na ɗek mək èjiŋa sifa gayaŋ a ti, elimeni gani aziaya mam ? ");
INSERT INTO muy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Emijiŋa sifa gayaŋ na ti, aməŋgət mam ga məmbani àna naŋ mam ? ");
INSERT INTO muy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mis ye e hini vu ni tàwayay Melefit va do, tagudar zlam ɗek. Nu Wur ge Mis ti anara àna njəɗa ga Baba goro akaba məslər gayaŋ *njəlatani ni. Tamal maslaŋa aŋgwaz awər naŋ kè meleher ge mis, aɗəm naŋ mis goro do, àsər pakama goro do nahəma, nu Wur ge Mis day ka fat ya ti anara ni anəɗəm naŋ mis goro do. » ");
INSERT INTO muy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Àhi ana tay keti : « Nəhi ana kʉli nahəma ; e kiɗiŋ ge mis ya tə̀bu ahalay ni bu ni ti, wuɗaka ndahaŋ atəmət ti etipia *Məgur ge Melefit a day ; ka sarta gani nani ti Melefit aməgur zlam ɗek àna njəɗa gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Vaɗ muku ka ahàr gani zla ti Yezu àzay Piyer, Zek akaba Zeŋ, àhəloru tay ka ahàr ga həma zəbalani. Nday ka ahàr gatay akaba Yezu ciliŋ. Tòru tìnjʉa ti vu ga Yezu ni àmbativa e eri va ana tay nahaŋ a, ");
INSERT INTO muy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","azana gayaŋ ka vu ɗek ègia bəɗ-bəɗ talla. Ahəlaba eri a vərut ; bəɗ-bəɗ gani àtama bəɗ-bəɗ ga azana ge mis na ɗek àna tallana. ");
INSERT INTO muy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eslini tìpioru Eli nday ata Mʉwiz, nday tə̀bu təzlapay akaba Yezu. ");
INSERT INTO muy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piyer àra èpia tay a ti àhi ana Yezu ahkado : « Mʉsi, leli mə̀bu ahalay ti àɓəlay. Mara mivicey ahay mahkər, bəlaŋ gayak, bəlaŋ ge Mʉwiz, bəlaŋ ti ni ge Eli. » ");
INSERT INTO muy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Àsər ere ye ti aɗəm ni do, aɗaba aŋgwaz àwər tay dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eslini məguduŋguduŋ àhərkiaya ka tay a, àŋgah tay. Dəŋgu ga maslaŋa àhənday a məguduŋguduŋ ni bu, àɗəm : « Naŋ hini ti wur goro, nawayay naŋ dal-dal. Gəsumiki pakama gayaŋ ! » ");
INSERT INTO muy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eslini hʉya ndam *maɗəbay Yezu ni tèheliŋ eri, tìpi maslaŋa nahaŋ ndo, si Yezu naŋ bəlaŋ akaba tay ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nday tə̀bu təndaya ahàr a həma ni ba ni ti Yezu nakəŋ àhi ana tay : « Kə̀ŋgəhaɗumi ere ye ti kìpʉm ni ana maslaŋa ba, si nu *Wur ge Mis anaŋgaya e kiɗiŋ ga ndam eviɗ ba kwa. » ");
INSERT INTO muy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nday nakəŋ tə̀gəskabá pakama gayaŋ ya ti àhi ana tay na. Ay ti tàgray gejewi e kiɗiŋ gatay bu, tə̀ɗəm : « Pakama gayaŋ ya ti àɗəm amaŋgaya e kiɗiŋ ga ndam eviɗ ba ni ti, awayay aɗəm ti mam ? » ");
INSERT INTO muy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nahkay tìhindifiŋa ma kà Yezu a, tə̀hi ahkado : « Ndam *məsər Wakita ge Melefit ni tə̀ɗəm wuɗaka *Krist *Bay gəɗakani ya amara ni eminjia ti, ahàr àɗəm Eli amara day ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Eɗeɗiŋ Eli ara, aslamalakabu zlam ɗek day. Ay ti àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm Wur ge Mis amacakay daliya kay, mis atəɗəm naŋ mis masakani àsər araŋa do. Melefit àɗəm nahkay ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ay nəhi ana kʉli nahəma, Eli ti àra àndava. Àra ti, mis tə̀gria ere ye ti nday tàwayay na ɗek, akaɗa ga pakama ge Melefit ya àɗəmki na. » ");
INSERT INTO muy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tara tinjikiva ka ndam *maɗəbay Yezu ndahaŋ na wuɗak ti tìpi mis dal-dalani kay tèveliŋa tay a. Eslini ndam *məsər Wakita ge Melefit tə̀bu bilegeni, tagray gejewi akaba tay. ");
INSERT INTO muy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mis dal-dalani ni tàra tìpeya Yezu a nahəma, nday ɗek tə̀ɗəm : « A ! Yezu ènjia, » mək nday ɗek tàcuhwakioru, tə̀gri sa. ");
INSERT INTO muy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tàra tə̀gria sa àndava ti Yezu nakəŋ èhindifiŋa ma kà ndam maɗəbay naŋ na, àhi ana tay : « Lekʉlʉm kə̀bum kəgrumkivu gejewi akaba tay ti ka mam ? » ");
INSERT INTO muy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eslini maslaŋa nahaŋ e kiɗiŋ ge mis dal-dalani ni bu àra ècia ma ga Yezu na ti àhəŋgrifəŋ, àhi ahkado : « Mʉsi, nə̀zukbiya wur goro a. Seteni àniviyu, àzlapay koksah. ");
INSERT INTO muy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Seteni ni agəs naŋ ku eley eley do ɗek, azəgaɗ naŋ ka haɗ. Nahkay wur ni guzləbuc krup-krup a ma bu, ahəpəɗkabu aslər krəɗ-krəɗ, vu gani ɗek ekʉli kʉc. Nə̀hi ana ndam maɗəbay kur ni ti tâgariaba, ay ti tìsliki ndo. » ");
INSERT INTO muy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eslini Yezu àhi ana tay : « Lekʉlʉm ye e hini vu ni ti kə̀fumki ahàr ke Melefit do. Nu ananjəhaɗ kaŋgaya akaba kʉli aw ? Nu eneɓesi ana kʉli kaŋgaya waw ? » Mək àhi ana tay : « Zumubiya wur nana nimi. » ");
INSERT INTO muy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nahkay tə̀zibiyu. Seteni ni àra èpia Yezu a ti àdaɗay wur ni kay kay, mək wur ni àdəɗ, èji daɓay ka haɗ, guzləbuc krup-krup a ma bu. ");
INSERT INTO muy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eslini Yezu èhindifiŋa ma kà bəŋ ga wur na, àhi ahkado : « Ere gani àgəs naŋ ti ku ananaw ? » Àhəŋgrifəŋ àhi : « Agray naŋ kwa e gʉziteni vu. ");
INSERT INTO muy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sak kay seteni ni èzligia naŋ a aku va, èzligia naŋ a yam va, awayay mijiŋ naŋ. Ay ti tamal kisliki nahəma, jənaki leli, mə̂suk ciciha ti. » ");
INSERT INTO muy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yezu àhəŋgrifəŋ, àhi ahkado : « Kə̀ɗəm “Tamal kisliki” ti kə̀ɗəm kamam ? Bay ya ti àfəkia ahàr ke Melefit a ni ti Melefit esliki məgri zlam weley weley do ɗek tata. » ");
INSERT INTO muy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eslini bəŋ ga wur ni àzlah hʉya, àɗəm : « Nə̀fəkia ahàr a. Ay ti məfəki ahàr goro ni àhəca, jənaki nu ti nə̂fəki ahàr àkivu. » ");
INSERT INTO muy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nday tə̀bu eslini ti mis ndahaŋ kay tə̀rəkia ka tay a. Yezu àra èpia tay a ti àzlacaki ke seteni ni, àhi : « Seteni ya agray mis ti bay gani àzlapay koksah akaba èci slimi koksah ni, nəhuk nahəma : Həraya a wur hini ba. Kàhəraya ti kə̀ŋgwiviyu va ba. » ");
INSERT INTO muy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Seteni ni àra ècia ma ga Yezu ya àhi na ti àdi àna zlahay, àdaɗay wur ni kay kay, mək àsləkiaba. Àra àsləkiaba ti wur ni ègia kə̀ɗəm kisimeni. Nahkay ti mis kay tə̀ɗəm ahkado : « Àməta. » ");
INSERT INTO muy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ambatakani do àmət ndo ; Yezu àzay ahar gani èzefteba naŋ a, mək wur ni ècik jik. ");
INSERT INTO muy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kələŋ gani Yezu òru ènjʉa a magam a ti, ndam maɗəbay naŋ ni nday ka ahàr gatay tìhindifiŋa ma, tə̀hi : « Leli mìsliki magaray seteni nani ndo ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Seteni akaɗa nday nani nahəma, tamal ti kàhəŋgalay Melefit ndo ni ti tə̀sləkiaba ana mis a koksah. » ");
INSERT INTO muy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yezu akaba ndam maɗəbay naŋ ni tàsləka ka məlaŋ nana, tə̀bu tasləkaba ka haɗ *Gelili a. Yezu àwayay ti mis tə̀sər məlaŋ gatay ya takoru ni ba, ");
INSERT INTO muy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","aɗaba naŋ àbu acahi zlam ana ndam maɗəbay naŋ ni. Àhi ana tay : « Atəɗəfiki nu *Wur ge Mis ana mis ti tara təgəs nu, tara takaɗ nu. Atakaɗa nu a ti, vaɗ mahkər amagra ti anaŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pakama ga Yezu ya àɗəm ni ti ndam maɗəbay naŋ ni tìciaba ndo. Ay aŋgwaz àgrafəŋa tay ge mihindifiŋa ma. ");
INSERT INTO muy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tòru tìnjʉa a Kafarnahum a ti tə̀huriyu a ahay vu. Eslini Yezu àhi ana tay : « Kə̀grumbiyu gejewi e divi bu kwa enekwiŋ ti àki ka mam ? » ");
INSERT INTO muy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nday nakəŋ te-te, aɗaba e divi bu ni ti tə̀ɗəm ahkado : « Məsərkaba, gəɗakani e kiɗiŋ geli bu ya àtam leli ni ti way ? » ");
INSERT INTO muy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eslini Yezu nakəŋ ànjəhaɗ digʉs, mək àzalakabu ndam maɗəbay naŋ kru mahar cʉeni ni, àhi ana tay : « Tamal mis awayay migi gəɗakani ti ahàr àɗəm mîgi gʉziteni èsli mis ndahaŋ do ɗek kwa, mə̂gri tʉwi ana mis ɗek kwa. » ");
INSERT INTO muy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mək àzəbiyu wur gʉziteni e kiɗiŋ gatay bu, àgəskabu naŋ gum. Àhi ana ndam maɗəbay naŋ ni : ");
INSERT INTO muy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","« Tamal ti maslaŋa àgəskabá wur gʉzitena akaɗa hini na azuhva nu a nahəma, àgəskabá nu a. Tamal ti maslaŋa àgəskabá nu a ti àgəskabu nu ciliŋ do, àgəskabá Bay ya ti àslərbiyu nu na daya. » ");
INSERT INTO muy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Eslini Zeŋ àhi ana Yezu : « Mʉsi, mìpia maslaŋa nahaŋ a àgariaba seteni ana mis àna slimi gayak a, nahkay mə̀ɗəm macafəŋa naŋ a aɗaba naŋ mis geli do. » ");
INSERT INTO muy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ay Yezu nakəŋ àhəŋgrifəŋ, àhi ahkado : « Kə̀cumfəŋa naŋ a ba, aɗaba tamal ti maslaŋa agray ere ye ti tìpi ɗay-ɗay ndo ni àna slimi goro ni ti mək awayay məɗəmku ma magədavani hʉya ti àɗəm koksah. ");
INSERT INTO muy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maslaŋa ya ti àwayay magudar tʉwi geli do nahəma, agriki tʉwi ana leli. ");
INSERT INTO muy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nəhi ana kʉli nahəma, ku way way do tamal àcəhiaya yam ana kʉli e hijiyem va aɗaba lekʉlʉm ndam ge *Krist ti Melefit aməvi zlam azuhva zlam gayaŋ ya àgray ni, amagəjazlki ahàr do. » ");
INSERT INTO muy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yezu àɗəm keti : « Ndam ya təfəku ahàr, mis tə̀ɗəm tìsli araŋa do akaɗa ga bəza ciɓ-ciɓeni ni ti, tamal ti maslaŋa agray ti ku way way do e kiɗiŋ gatay bu mîjikia ke divi a nahəma, hojo təwəliviyu avar gəɗakani ana maslaŋa ya èjiŋkia naŋ a ni a dəŋgu vu dondul mək tizligiyu naŋ a *dəluv gəɗakani vu dəzləz. ");
INSERT INTO muy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tamal ahar gayak ejiŋkia kur ke divi a nahəma, kelkaba. Àgəski hojo kəhuriyu ka məlaŋ ga sifa àna ahar bəlaŋ ere gani ya kəhuriyu a *dəluv ga aku vu àna ahar gayak cʉeni ni. Aku nani ti àmət do.  ");
INSERT INTO muy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A məlaŋ ga aku nani vu ni ti mekcehʉɗ tə̀mət do, aku gani day àmət do. ");
INSERT INTO muy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tamal asak gayak ejiŋkia kur ke divi a nahəma, kelkaba. Àgəski hojo kəhuriyu ka məlaŋ ga sifa àna asak bəlaŋ ere gani ya tizligiyu kur a dəluv ga aku vu àna asak gayak cʉeni ni.  ");
INSERT INTO muy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A məlaŋ ga aku nani vu ni ti mekcehʉɗ tə̀mət do, aku gani day àmət do. ");
INSERT INTO muy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tamal eri gayak ejiŋkia kur ke divi a nahəma, zaba zligoru. Àgəski hojo kəhuriyu a *Məgur ge Melefit vu àna eri bəlaŋ ere gani ya tizligiyu kur a dəluv ga aku vu àna eri gayak cʉeni ni. ");
INSERT INTO muy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A məlaŋ ga aku nani vu ni ti mekcehʉɗ tə̀mət do, aku gani day àmət do. ");
INSERT INTO muy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nahkay ti Melefit aməbəkiviyu aku ke mis ɗek akaɗa ya ti təbəkiviyu estena ka zlam məzumani ni. ");
INSERT INTO muy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","« Estena ti zlam sulumani. Ay tamal àcər va do ni ti, mâra mə̂cər keti ti kəgrumi ahəmamam ? Ahàr àɗəm manjəhaɗ gekʉli mə̂ləbu sulumani akaɗa ga zlam məzumani ya tə̀bəkiviya estena ni ; nahkay araŋa embeɗekabu kʉli do. » ");
INSERT INTO muy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","A vaɗ nahaŋ Yezu àsləka eslina, àŋgoru ka haɗ *Zʉde. Òru ke ledi nahaŋ ga zalaka *Zʉrdeŋ. Eslini mis dal-dal tə̀rəkia. Àcahi zlam ana tay keti akaɗa gayaŋ ya agray kəlavaɗ ni. ");
INSERT INTO muy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Naŋ àbu acahi zlam ana mis eslini ti ndam *Feriziyeŋ ndahaŋ tə̀rəkia. Tìhindifiŋa ma, tə̀hi ahkado : « Àgəski ti mis agaray wal gayaŋ aw ? » Tə̀hi nahkay ti aɗaba tawayay tatəkar Yezu ti mə̂ɗəm ma magudarani. ");
INSERT INTO muy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Mʉwiz àhi mam ana kʉli a wakita gayaŋ ni bu mam ? Àwayay ti kəgrum mam ? » ");
INSERT INTO muy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eslini nday nakəŋ tə̀hi ahkado : « Mʉwiz àvia divi ana mis a, àɗəm tedevu ata wal gayaŋ ti si abiki wakita gani avi day kwa ti agaray. » ");
INSERT INTO muy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ay ti Yezu àhəŋgrifəŋ ana tay keti, àɗəm : « Mʉwiz àbəki ma gani nahkay a wakita gayaŋ ni bu ni ti àbəki aɗaba lekʉlʉm kàwayum məgəsumkabu ma ge Melefit do palam. ");
INSERT INTO muy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ay kwa ka mənjəki ga məlaŋ, ka ya ti Melefit àgraya zlam ɗek na nahəma, “Melefit àgraya mis a ti àgraya ata zal ata wal a. ");
INSERT INTO muy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nahkay ti mis zalani amahəraya a ahay ga bəŋani ata məŋani ba, mək atanjəhaɗkabu ata wal gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nday cʉeni ti vu gatay emigi bəlaŋ.” Nahkay ti nday cʉeni medeveni va do. Tìgia vu gatay bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nahkay ere ye ti Melefit èbeɗekabá ni ti mis hihirikeni èdekaba ba. » ");
INSERT INTO muy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tàra tìnjia a magam a ti ndam *maɗəbay Yezu ni tìhindifiŋa ma àki ka pakama ya ti àhi ana ndam *Feriziyeŋ na. ");
INSERT INTO muy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Àhi ana tay ahkado : « Maslaŋa ya ti àgara wal gayaŋ a mək àda wal nahaŋ a nahəma, àgra hala, àgudaria zlam ana wal gayaŋ ye enjenjeni na. ");
INSERT INTO muy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wal day tamal àsləka afa ga zal gayaŋ a mək àda zal nahaŋ a nahəma, àgra hala. » ");
INSERT INTO muy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mis tə̀həlibiyu bəza ana Yezu ti mə̂gri *sulum ge Melefit àna məbəki *ahar gayaŋ ka tay. Nday tə̀bu təhəlibiyu bəza ni nahkay ti ndam maɗəbay naŋ ni tə̀ləgi ana tay. ");
INSERT INTO muy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yezu àra èpia ere ye ti ndam maɗəbay naŋ ni tàgray na ti àzuma ɓəruv a, àhi ana tay ahkado : « Mbrəŋum bəza târa afa goro a, kə̀cumfəŋa tay a ba. Aɗaba mam, *Məgur ge Melefit ti ga ndam ya tə̀bu akaɗa ga bəza ni. ");
INSERT INTO muy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nəhi ana kʉli nahəma, ahàr àɗəm ku way way do mə̂gəskabu Məgur ge Melefit akaɗa ga wur ya eciiki slimi ana bəŋani ni. Tamal àgəskabu nahkay do nahəma, èsliki məhuriyani a Məgur ge Melefit vu koksah. » ");
INSERT INTO muy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eslini àgəskabu bəza nakəŋ gum, mək àbəki ahar ka tay ga məgri sulum ge Melefit ana tay. ");
INSERT INTO muy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yezu àsləka eslina. Naŋ àbu akoru e divi bu ni ti maslaŋa nahaŋ àcuhwakioru, àbəhaɗi mirdim grik, àhi : « Mʉsi sulumani, ti nə̂ŋgət *sifa ya àndav ɗay-ɗay do ni ti nâgray ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yezu àhəŋgrifəŋ, àhi : « Kàzalay nu mis sulumani ti kamam ? Mis sulumani ti àbi, si Melefit ciliŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ere ye ti kìhindi ni ti, *Divi ge Melefit ya àvi ana mis ni ti kə̀səra tay a do aw ? Kə̀kaɗ mis ba, kàgray hala ba, kìgi akal ba, kagray sedi ti kàsəkaɗ malfaɗa ba, kə̀zumki zlam ge mis ba, həŋgrioru ahàr a haɗ ana ata buk ata muk.  » ");
INSERT INTO muy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Zal nakəŋ àhəŋgrifəŋ, àhi ahkado : « Mʉsi, nə̀gəskabá Divi nana ɗek kwa nu a wur wurani. » ");
INSERT INTO muy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eslini Yezu àwaya naŋ a, àmənjaləŋ e eri vu, àhi : « Zlam àhəcukivu bəlaŋ kekileŋa. Ru kə̂səkumoru zlam gayak ɗek ti kîdi siŋgu gani ana ndam talaga. Nahkay ti akəŋgət elimeni e melefit bu. Akagra zlam nana ɗek nahəma, kâra, kâɗəbay nu. » ");
INSERT INTO muy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Maslaŋa nani àra ècia ma ga Yezu ya àhi na ti ma gani àhəlia ahàr a, məɓəruv àtikaba kwir. Nahkay àsləka sasuhwa, aɗaba zlam gayaŋ àbu dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eslini Yezu àmbatvu ga mamənjaləŋani ana ndam maɗəbay naŋ ni, àhi ana tay ahkado : « Ndam ge elimeni tə̂huriyu a *Məgur ge Melefit vu ti zləzlaɗa dal-dal. » ");
INSERT INTO muy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pakama ga Yezu ya ti àɗəm ni èwisiria ahàr ana ndam maɗəbay naŋ na. Ay ti Yezu àhəŋgri zuh ana ma ni, àhi ana tay : « Ndam goro ni, məhuriyani a Məgur ge Melefit vu ti zləzlaɗa dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ezligwemi ahuriyu e eviɗ ge lipri vu kwalac ti agravu aw ? Ay ti bay ge elimeni mə̂huriyu a Məgur ge Melefit vu ni ti zləzlaɗa dal-dal, àtama ge ezligwemi ya ahuriyu e eviɗ ge lipri vu na. » ");
INSERT INTO muy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma ga Yezu ya àhi ana tay ni àgria ejep ana tay a dal-dal. Nday nakəŋ tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Ay tamal nahkay ti way ti Melefit amahəŋgay naŋ way ? » ");
INSERT INTO muy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ay Yezu àmənjaləŋ kà tay, àhi ana tay ahkado : « Mis ti tàgray koksah, ay Melefit kwa ti esliki magrani, aɗaba Melefit ti esliki magray zlam ɗek tata. » ");
INSERT INTO muy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Eslini Piyer àhi ana Yezu ahkado : « Iy zla, leli mə̀mbrəŋa zlam a ɗek, maɗəbay kur ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yezu àhəŋgarfəŋ, àɗəm : « Nəhi ana kʉli nahəma, tamal mis àmbərbu zlam gayaŋ azuhva nu ga məhi *Ma Mʉweni Sulumani ana mis, bi àmbərbu ahay gayaŋ, bəza ga məŋani, bəŋani, məŋani, bəza gayaŋ ahkay do ni vədaŋ gayaŋ nahəma, ");
INSERT INTO muy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aməŋgətvù zlam nday nani kay àtam ndahaŋ ni sak diŋ nihi ka sarta hini. Aməŋgət ahay, bəza ga məŋani, ata məŋani, bəza, vədaŋ ; akaba nani ɗek mis atəgri daliya. Ka məlaŋ mʉweni ya Melefit amagraya ni day aməŋgət sifa ya àndav ɗay-ɗay do ni. ");
INSERT INTO muy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ay ti nday gəɗákani ya kama ge mis ni ti, mis kay e kiɗiŋ gatay bu ataŋgoru kələŋ ge mis. Nday ya kələŋ ge mis ni day etigi gəɗákani kama ge mis. » ");
INSERT INTO muy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yezu akaba ndam maɗəbay naŋ ni tə̀bu takoru, tàzay divi ya ti acəloru a Zerʉzalem ni. Yezu àdi kama ana tay. Ndam maɗəbay naŋ ni ahàr àhəlia ana tay a, mis ndahaŋ ya tə̀bu takoru akaba tay ni day aŋgwaz àwəra tay a. Eslini Yezu àzalakabu ndam maɗəbay naŋ kru mahar cʉeni ni keti, ànjəki ka mazlapi ma ana tay àki ke ere ye ti amagrakivu ni. ");
INSERT INTO muy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Àhi ana tay ahkado : « Cʉm day, nihi ti leli mə̀bu məcəloru a Zerʉzalem. Eminjʉa eslina ti nu *Wur ge Mis atəgəsi nu ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ana ndam *məsər Wakita ge Melefit ni. Eslini atəɗəm si takaɗ nu kwa, atəgəsi nu ana ndam ya tə̀fəki ahàr ke Melefit do ni. ");
INSERT INTO muy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nday nani ti eteyefʉ, etitifʉviyu esliɓ e eri vu, atəzləɓ nu àna kurupu cʉk cʉk, atakaɗ nu, mək a vaɗ ya mahkər ti anaŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Eslini Zek nday ata Zeŋ bəza ge Zebede tə̀rəkia kà Yezu a, tə̀hi ahkado : « Mʉsi, mawayay mihindifʉka zlam a, mawayay ti kə̂gri ana leli. » ");
INSERT INTO muy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Kawayum ti nə̂gri mam ana kʉli mam ? » ");
INSERT INTO muy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tə̀hi : « Ka ya ti akəzuma bay gayak gəɗakani na nahəma, kə̂vi divi ana leli ti mânjəhaɗfuk kà gəvay, bəlaŋ ka ahar ga ɗaf, bəlaŋ ka ahar ga gəjar gayak ti. » ");
INSERT INTO muy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ay ti Yezu àhi ana tay ahkado : « Ere ye ti kihindʉm ni ti kə̀sərum do. Ekislʉmki misi zum ge hijiyem ye enisi ni tata waw ? Ekislʉmki miɓeseni *tabaray kʉli akaɗa goro ya atabaray nu ni tata waw ?  » ");
INSERT INTO muy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nday cʉeni tə̀hi : « Misliki. » Eslini Yezu àhəŋgrifəŋ ana tay, àɗəm ahkado : « Ekisʉm zum ge hijiyem ya enisi ni akaba atabaray kʉli akaɗa goro ya atabaray nu ni ti amagravu eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ay ti maslaŋa ya ti aməɗəm way amanjəhaɗfu kà ahar ga ɗaf akaba kà ahar ga gəjar goro way ni ti nu do. Nani Bay Melefit àna ahàr gayaŋ day ti aməvi məlaŋ nani ana mis ya naŋ àdaba tay a ni. » ");
INSERT INTO muy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ndam *maɗəbay Yezu kruani ndahaŋ ni tàra tìcia pakama ge Zeŋ ata Zek ya tə̀hi ana Yezu na ti tə̀zumkia ɓəruv ka tay a. ");
INSERT INTO muy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eslini Yezu àzalakabu ndam maɗəbay naŋ ni ɗek, àhi ana tay ahkado : « Kə̀səruma, ndam ya ti təzalay tay bəbay ga haɗ ni ti təgur mis ga njəɗa. Gəɗákani ga məlaŋ day tə̀ɗəm ahàr àɗəm mis təgri tʉwi ana tay kay, tə̀mbrəŋ mis do. ");
INSERT INTO muy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ay e kiɗiŋ gekʉli bu ni ti àgravu nahkay do. Tamal ti maslaŋa e kiɗiŋ gekʉli bu awayay migi gəɗakani ti, mîgi bay məgri tʉwi ana kʉli kwa sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tamal ti maslaŋa e kiɗiŋ gekʉli bu awayay migi kama ge mis ti, mîgi eviɗi ge mis ɗek kwa. ");
INSERT INTO muy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aɗaba nu *Wur ge Mis nàra ti, nàwayay ti mis tə̂gru tʉwi do. Nàra ti ga məgri tʉwi ana mis sawaŋ, navay sifa goro ga mambay mis kay àna naŋ. » ");
INSERT INTO muy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Eslini Yezu akaba ndam maɗəbay naŋ ni akaba mis ndahaŋ kay ɓal tìnjʉa a Zeriko a. Nday tə̀bu tasləka a kəsa nani ba ti tə̀di ahàr ana zal nahaŋ wulufani. Slimi gayaŋ Bartime, naŋ wur ge Time ; naŋ manjəhaɗani digʉsa kà gəvay ge divi, ahəŋgalay zlam. ");
INSERT INTO muy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Àra ècia mis tə̀ɗəm « Yezu zal Nazaret ènjia » ti àdiki ana zlahay, àɗəm ahkado : « Yezu *Wur ge Devit, nə̂suk cicihi ti. » ");
INSERT INTO muy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eslini mis kay tə̀ləgi, tə̀hi : « Lakakaba. » Naŋ ti ni àzlahkivu kay kay sawaŋ, àɗəm : « Wur ge Devit, nə̂suk cicihi ti. » ");
INSERT INTO muy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yezu àra ècia zalay na ti ècik àɗəm : « Zalumubiya naŋ a. » Nahkay tə̀zalibiyu zal wuluf nakəŋ, tə̀hi : « Zay njəɗa, cikaba. Naŋ àbu azalay kur. » ");
INSERT INTO muy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eslini zal nakəŋ àzakaba azana ya ti àhəmbakabu na, èzligoru, ècikaba cəkwaɗ àrəkioru kà Yezu nakəŋ. ");
INSERT INTO muy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yezu èhindifiŋa ma, àhi : « Kawayay ti nə̂gruk mam ? » Zal wuluf ni àhəŋgrifəŋ, àhi ahkado : « Mʉsi, nawayay ti nîpi divi akaɗa ge mis ni bilegeni ti. » ");
INSERT INTO muy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mək Yezu àhi : « Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. » Ka ma geli hini èpi divi hʉya. Àra èpia divi a ti àɗəboru Yezu e divi bu. ");
INSERT INTO muy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tòru tìnjʉa cifa kà gəvay ga Zerʉzalem a, nday gwar ka həma *Oliviye, kama ga kəsa ndahaŋ Betfazi akaba Betani ni ti Yezu nakəŋ àslər ndam maɗəbay naŋ ni cʉ, ");
INSERT INTO muy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","àhi ana tay ahkado : « Dəgum a kəsa tegʉni ya kama gekʉli ni vu. Ekinjʉmiya nahəma, akədumi ahàr ana wur ga azoŋgu məwəlani. Wur ga azoŋgu nani ti maslaŋa àcəlkiyu ɗay-ɗay faŋ ndo. Picehʉmbiya, zumubiya. ");
INSERT INTO muy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ay tamal maslaŋa èhindifiŋa ma kè kʉli a, àhi ana kʉli “Kepicehʉm ti kamam ?” nahəma, humi ahkado : “Bay geli awayay, ara ahəŋgarbiyu nihi hʉya.” » ");
INSERT INTO muy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nahkay nday nakəŋ tòru. Tòru tìnjʉa ti tə̀di ahàr ana wur ga azoŋgu məwəlani kà mahay e mite bu. Tə̀bu tepiceh ti ");
INSERT INTO muy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mis ndahaŋ e kiɗiŋ ge mis ya ti tə̀bu eslini ni bu tə̀hi ana tay ahkado : « Kepicehʉm wur ga azoŋgu ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eslini tə̀həŋgri ma ga Yezu ya àhi ana tay ni ana tay ; nahkay tə̀mbrəŋ tay, tàsləkabiya àna naŋ a. ");
INSERT INTO muy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tàra tìnjikia àna wur ga azoŋgu na ka Yezu a ti tə̀bəki azana, mək Yezu àcəlkiyu katapəla. ");
INSERT INTO muy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mis dal-dal eslini tàpaɓivoru azana gatay e divi bu, mis ndahaŋ ti ni tàkwahabiyu slimberi a vədaŋ bu, tàbəhaɗivoru bilegeni. ");
INSERT INTO muy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yezu naŋ àbu akoru ti mis ya kama gayaŋ akaba ya kələŋ gayaŋ ni tàgray salalay, tàzləbay naŋ, tə̀ɗəm : « *Hozana ! Bay Melefit mə̂gri sulum gayaŋ ana maslaŋa ya ti ara àna slimi gayaŋ a ni ! ");
INSERT INTO muy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Melefit mə̂gri sulum ana maslaŋa ya ti ara azum bay ge Devit bəŋ geli ni ! Tâzləbay Melefit driŋ agavəla !  » ");
INSERT INTO muy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tòru tìnjʉa a Zerʉzalem a ti Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Eslini èheliŋ eri, àmənjaləŋ kà zlam ɗek. Àmənjaləŋaba ɗek ti fat àbi va bi, məlakarawa ègia. Nahkay tàhəraya, tàsləka akaba ndam maɗəbay naŋ kru mahar cʉeni na, tàŋgoru gwar a Betani. ");
INSERT INTO muy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tòru tìnjʉa a Betani a ti tàndəhaɗ eslini hundum. Ge miledʉ gani, tàsləka tàŋgoru a Zerʉzalem. Nday tə̀bu takoru e divi bu ni ti lʉwir àwərkaba Yezu a. ");
INSERT INTO muy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lʉwir àbu awər naŋ nahkay ti èpi məŋ ga *wəruv miɗeni. Àra èpia ti àhəɗakfəŋoru, àmənjafəŋ bəza gani, ay àŋgətfəŋ ndo, aɗaba sarta ge miwi bəza gani do. ");
INSERT INTO muy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eslini Yezu àhi ana məŋ ga zlam ni : « Ɗay-ɗay maslaŋa aməzum bəza gayak va do. » Gayaŋ ya àɗəm nahkay ni ti ndam maɗəbay naŋ ni tìcia. ");
INSERT INTO muy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tòru tìnjʉa a Zerʉzalem a ti Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Eslini àdi ahàr ana mis təsəkumvoru zlam akaba ndam məsəkum zlam, mək ànjəki ka magaraya tay e mite va. Àhəmbəhaɗaba tabəl ga ndam mambay siŋgu na akaba məlaŋ manjəhaɗani ga ndam məsəkumoru kurkoduk na. ");
INSERT INTO muy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mis ndahaŋ tə̀bu təhuriyu àna zlam a ahay ge Melefit ni vu, mək tasləkaba àna naŋ a kwalac. Tə̀bu tagray nahkay ti Yezu nakəŋ àcafəŋa tay a. ");
INSERT INTO muy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mək àcahi zlam ana mis ya tə̀bu eslini ni, àɗəm : « Àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm : “Ahay goro zla ti atəɗəm məlaŋ ga jiba ɗek ga mahəŋgalavù Melefit.” Ay lekʉlʉm ti kàmbatumkaba, ègia ahuzl ga ndam akal a. » ");
INSERT INTO muy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Àra àɗəma nahkay ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni tìcia ; tàra tìcia ti tàɗəbafəŋ divi ge mijiŋ naŋ. Ay ti aŋgwaz àwərfəŋa tay kà naŋ a, aɗaba mis ndahaŋ ni ɗek ti pakama ya àcahi ana tay ni àgria ejep ana tay a. ");
INSERT INTO muy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Məlakarawa àra ègia ti Yezu akaba ndam maɗəbay naŋ ni tàsləkaba a kəsa ni ba. ");
INSERT INTO muy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ge miledʉ gani tə̀bu taŋgoru a Zerʉzalem. Tə̀bu tasləkafəŋa kà gəvay ga məŋ ga *wəruv ya ti Yezu àhi ma na nahəma, tìpi ti mikʉleni kʉc akaba sliri gani ɗek. ");
INSERT INTO muy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Eslini Piyer àra àsərkia ka ma ga Yezu ya àhi ana məŋ ga wəruv na ti àhi ana Yezu ahkado : « Mʉsi, mənjoru, məŋ ga wəruv ya kètikwesl ni èkʉlia. » ");
INSERT INTO muy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eslini Yezu àhi ana tay ahkado : « Fumki ahàr ke Melefit. ");
INSERT INTO muy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nəhi ana kʉli nahəma, tamal ti maslaŋa ahi ana həma hini : “Raɗvaba, ru kə̂diyu a *dəluv gəɗakani vu” nahəma, amagravu. Tamal ti àjalay ahàr cʉ cʉ do, àfəkia ahàr ke Melefit a, àsəra aməgri ere ye ti ehindi ni ti, zlam gani agravu. ");
INSERT INTO muy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nahkay nəhi ana kʉli : Tamal ti kihindʉm zlam, kahəŋgalum Melefit ti, fumki ahàr ke Melefit, səruma kə̀ŋgətuma àndava. Tamal kəgrum nahkay ti Melefit aməgri zlam ya ti kihindʉmfiŋa ni ɗek ana kʉli. ");
INSERT INTO muy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tamal ti kìcikʉmaba, kə̀bum kahəŋgalum Melefit ti, mbrəŋumfəŋa zlam ge mis ya ti tagudari ana kʉli ni kà tay a, tamal àbu ni. Nahkay ti Bəŋ gekʉli ya a huɗ melefit bu ni aməmbərfəŋa zlam gekʉli ya kagudarum ni kè kʉli a bilegeni.  ");
INSERT INTO muy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ay tamal kə̀mbrəŋumfəŋa zlam ge mis ya ti tàgudari ana kʉli na ka tay a do ni ti Bəŋ gekʉli ya a huɗ melefit bu ni day aməmbərfəŋa zlam magudarani gekʉli ni kè kʉli a do. » ");
INSERT INTO muy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yezu akaba ndam maɗəbay naŋ ni tə̀huriyu a Zerʉzalem keti. Yezu àra àhuriya a kəsa ni va ti àsawaɗavù a dalaka ga *ahay gəɗakani ge Melefit ni bu. Naŋ àbu eslini ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, ndam *məsər Wakita ge Melefit ni akaba gəɗákani ndahaŋ tə̀rəkia, ");
INSERT INTO muy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","tə̀hi : « Kagray tʉwi hini nahkay ti kə̀ŋgət divi gani eley ? Way àvuk divi gani way ? » ");
INSERT INTO muy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yezu àhəŋgrifəŋ ana tay, àɗəm : « Nu day nihindifiŋa zlam bəlaŋ kè kʉli a. Kə̀həŋgrumufəŋa nahəma, nu day nəhəŋgrifəŋ ana kʉli, nəɗəfi bay ya ti àvu divi ge tʉwi ya ti nagray ni ana kʉli. ");
INSERT INTO muy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nəhi ana kʉli nahəma, *baray ge Zeŋ ya ti àbaray mis ni ti njəɗa gani Melefit àvi tək, tək day ti mis tə̀vi aw ? Həŋgrumufəŋ nimi ! » ");
INSERT INTO muy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tàra tìcia ma na nahkay ti tàgray gejewi e kiɗiŋ gatay bu, tə̀ɗəm : « Tamal məhi : “Melefit àslərbiyu naŋ” hi, ara ahi ana leli : “Kə̀gəsumkabu pakama gayaŋ ni ndo ni ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ay tamal məɗəm keti : “Mis tə̀vi njəɗa gani” ti àrakaboru do. » Tə̀ɗəm nahkay ti aɗaba mis tezl-tezleni eslini ni ɗek tə̀ɗəm Zeŋ ti naŋ bay mahəŋgaray *pakama ge Melefit eɗeɗiŋ eɗeɗiŋeni. Tàgrafəŋa aŋgwaz kè mis tezl-tezleni nana, ");
INSERT INTO muy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","nahkay tə̀həŋgrifəŋ ana Yezu, tə̀hi : « Leli mə̀sər do. » Eslini Yezu àhi ana tay : « Nu day nə̀ɗəfi bay ya ti àvu divi ge tʉwi ya ti nagray ni ana kʉli do bilegeni. » ");
INSERT INTO muy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yezu àhi ma ana mis ni keti àna ma *gozogul. Àɗəm ahkado : « Zal nahaŋ àbu nahəma, àjavù məŋ ga zlam a vədaŋ gayaŋ vu, àcafəŋ azlaw tekesl, àgraya məlaŋ ga məɗucaya yam ga bəza ga məŋ ga zlam na, àkay ləli zəbalani, mis acəlkiyu ka ahàr gani ga majəgay vədaŋ ni. Kələŋ gani àfivù vədaŋ ni ana mis a ahar vu ti tə̂wəs, mək àsləka, òru e mirkwi zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sarta ga məpalay bəza ga zlam ni àra ènjia ti bay ga vədaŋ ni àslərbiyu bay məgri tʉwi afa ga ndam məwəs vədaŋ ni ti tə̂həlikaboru ja gani gayaŋ. ");
INSERT INTO muy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ay bay məgri tʉwi ni àra ènjia ti ndam məwəs vədaŋ ni tə̀gəs naŋ, tə̀zləɓ mək tàgaray naŋ, araŋa day àzay a ahar vu ndo. ");
INSERT INTO muy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eslini bay ga vədaŋ ni àslərbiyu bay məgri tʉwi nahaŋ keti. Àra ènjia ti nday nakəŋ tə̀si aday a ahàr vu, tìndivikaba cʉɗ cʉɗ. ");
INSERT INTO muy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nahkay bay ga vədaŋ ni àslərbiyu mis nahaŋ keti. Naŋ nani ti tàkaɗ naŋ gweha. Àslərbiyu mis ndahaŋ kay keti. Tàra tìnjia ti ndam məwəs vədaŋ ni tə̀zləɓ ndahaŋ, ndahaŋ ni ti ni tàbazl tay. ");
INSERT INTO muy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kələŋ gani nahəma, bay ga vədaŋ ni mis àgəjənifəŋ bəlaŋ ciliŋ. Maslaŋa nani ti wur gayaŋ, awayay naŋ dal-dal. Àɗəm : “Wur goro ni ti atəgəsiki ma.” Nahkay zla ti àslərbiyu naŋ afa gatay. ");
INSERT INTO muy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ay ndam məwəs vədaŋ ni tàra tìpia wur na naŋ àbu ara ti tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : “Naŋ tegʉni ti mekeji gayaŋ ; mə̀mbrəŋ naŋ ba, makaɗum naŋ ; nahkay ti vədaŋ ni emigi geli.” ");
INSERT INTO muy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Àra ènjikia ka tay a ti tə̀gəs naŋ yaw, tàkaɗ, tə̀zaba kisim gayaŋ na a vədaŋ ni ba, tìzligoru. ");
INSERT INTO muy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","« Nəɗəm nahəma, bay ga vədaŋ ni amasləkabiya ti aməgri mam ana ndam məwəs vədaŋ ni mam ? Amabazl ndam məwəs vədaŋ ni, mək aməvi vədaŋ ni ana mis ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","A Wakita ge Melefit bu àbu məbəkiani nahkay hi : “Akur nahaŋ àbu ti ndam mələm ahay tàwayay magray tʉwi àna naŋ ndo. Ay ti akur gani nani ègia akur ya akay ahay na ɗek sawaŋ. Ere nani ti tʉwi ga Bay Melefit, agri ejep ana leli.” « Lekʉlʉm kèjeŋgʉm ma nani ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gəɗákani nakəŋ tə̀səra Yezu àɗəmki ma *gozogul ni ti ka tay. Tàra tə̀səra ti tawayay təgəs naŋ. Ay mis tə̀bu eslini kay ti tə̀gəs naŋ ndo, aɗaba aŋgwaz àwəra tay a. Nahkay tə̀mbrəŋ naŋ, tàsləka. ");
INSERT INTO muy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yezu naŋ àbu eslini nahkay ti tə̀slərkibiyu ndam *Feriziyeŋ akaba ndam ndahaŋ ya taɗəbay bay *Erot ni. Tawayay ti mə̂ɗəm ma magədavani ti tə̂gəski naŋ. ");
INSERT INTO muy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tàra tìnjikia ti tə̀hi ahkado : « Mʉsi, mə̀səra nak ti kə̀ɗəm ma ge jiri. Aŋgwaz àwərfəŋa kur kà pakama ge mis ya təɗəmkuk na do ; ku kè meleher ga way ga way do day kàgray aŋgwaz do, kacahi zlam ya Melefit awayay ni ana mis àna jiri gani sawaŋ. Ay ti Melefit àvia divi ana leli ga mabəhaɗi hadam ana *bay gəɗakani ga ndam Rom a tək, àvi ana leli ndo waw ? Mabəhaɗi tək, màbəhaɗi ba waw ? » ");
INSERT INTO muy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eslini Yezu àsəra tawayay ti mis ndahaŋ tə̂ɗəm nday ndam jireni, ay ti nday ndam jireni do. Nahkay àhi ana tay ahkado : « Kəhəlumfua eyʉ a ti kamam ? Ŋga zumubiya siŋgu akur-akurana ti namənjaki day nimi. » ");
INSERT INTO muy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nahkay tə̀dibiyu bəlaŋ. Tàra tə̀via ti èhindifiŋa ma kà tay a, àɗəm ahkado : « Àki ka siŋgu hini ti mazavu ga ahàr ga way ? Slimi məbəkiani ni ti ga way ? » Tə̀həŋgrifəŋ, tə̀hi ahkado : « Ga bay *Sezar.  » ");
INSERT INTO muy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nahkay naŋ nakəŋ àhi ana tay ahkado : « Həŋgrumi zlam ga bay Sezar ni zlam gayaŋ, ge Melefit ti ni həŋgrumi ana Melefit zlam gayaŋ. » Eslini ma gayaŋ ya ti àhi ana tay ni àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eslini ndam *Sedʉseyeŋ ndahaŋ tə̀rəkia ka Yezu a. Ndam Sedʉseyeŋ tə̀ɗəm mis àməta ti àŋgaba e kisim ba koksah. Nahkay nday nakəŋ tə̀hi ana Yezu ahkado : ");
INSERT INTO muy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","« Mʉsi, Mʉwiz àbiki ana leli a wakita gayaŋ ni bu, àɗəm ahkado : “Tamal mis nday kà məŋ gatay, mək bəlaŋ gani àməta, àmbərba wal gayaŋ a, wal ni èwii wur ndo nahəma, ahàr àɗəm wur ga məŋani ni azay wal ni, ti tîwieya mekeji ana wur ga məŋani ya àmət na.” ");
INSERT INTO muy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yaw mis ndahaŋ tə̀bu adəskəla kà məŋ gatay, gəɗakani gatay ni àda wal a. Àra àza wal na ti èwifiŋa wur a ndo, mək zal ni àməta. ");
INSERT INTO muy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Àra àməta ti mimbiki gayaŋ ni àzay wal ni. Àra àza wal na ti naŋ day èwifiŋa wur a ndo, mək àməta. Naŋ ya mahkər ni day àgray nahkay, mək àməta. ");
INSERT INTO muy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nahkay nday adəskəlani ni ɗek tàza wal na day tìwifiŋa wur a ndo, mək nday ɗek tə̀məta. Kələŋ gani wal ni day àməta. ");
INSERT INTO muy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ay ka fat ya ti mis ataŋgaba e kisim ba nahəma, wal ni ti way bəlaŋ e kiɗiŋ gatay bu amazay way ? Nday adəskəlani ni ɗek tàza naŋ a ni. » ");
INSERT INTO muy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ay Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm ahkado : « Majalay ahàr gekʉli ti kigeni do. Aɗaba mam ? Aɗaba kìcʉmaba ma ga Wakita ge Melefit ya Mʉwiz àbəki na ndo, kə̀sərum njəɗa ge Melefit do palam. ");
INSERT INTO muy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nəɗəm nahəma, ka ya ti mis atəməta mək ataŋgaba e kisim ba ni ti zawal ataday wál va do, wəwal day ataday zawal va do. Atanjəhaɗ ɗek akaɗa ga *məslər ge Melefit ya tə̀bu a huɗ melefit bu ni. ");
INSERT INTO muy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ay tamal ti mazlapaki ka ma ge mis ya taŋgaba e kisim ba nahəma, kèjeŋgʉm wakita ge Mʉwiz ni ɗay-ɗay ndo aw ? Kèjeŋgʉm ma àki ka məŋgəhaf ya ti aku àgəs ni ndo aw ? Eslini Bay Melefit àhi ana Mʉwiz ahkado : “Nu Melefit ga Abraham, nu Melefit ga Izak, nu Melefit ge Zekʉp.” ");
INSERT INTO muy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Melefit ti naŋ Melefit ga ndam ya àna sifa ni, do ni ti ga nday ya tə̀məta ni do. Lekʉlʉm ti majalay ahàr gekʉli ti kigeni do simiteni. » ");
INSERT INTO muy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eslini zal nahaŋ naŋ àvu, naŋ bay *məsər Wakita ge Melefit, ècia ma gatay na, àsəra Yezu àhia ma sulumana ana ndam *Sedʉseyeŋ na. Nahkay ti àrəkioru, èhindifiŋa ma, àhi ahkado : « *Divi ge Melefit ya ti ahàr àɗəm mis tə̂gəskabu enji ni ti weley ? » ");
INSERT INTO muy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yezu àhəŋgrifəŋ, àhi : « Divi ge Melefit ya ti ahàr àɗəm mis tə̂gəskabu enji ni ti nihi : “Ci zal Izireyel : Bay Melefit geli nahəma, naŋ Bay naŋ bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wayay Bay Melefit gayak àna huɗ bəlaŋ, àna sifa gayak ɗek, àna majalay ahàr gayak ɗek akaba àna njəɗa gayak ɗek.” ");
INSERT INTO muy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Divi ye cʉ ni day nihi : “Wayay ndam ya nak kə̀bu akaba tay ni akaɗa ya kawayay ahàr gayak gayakani ni.” Divi nday ndani cʉeni ni ti ahàr àɗəm mis tə̂gəskabu tay àtam divi ndahaŋ ni ɗek kwa. » ");
INSERT INTO muy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mək bay məsər Wakita ge Melefit nakəŋ àhəŋgrifəŋ, àhi ahkado : « Yawa Mʉsi ! Ere ye ti kə̀ɗəm ni ti jiri eɗeɗiŋ. Bay Melefit ti naŋ bəlaŋ hʉya, bay nahaŋ àbi. ");
INSERT INTO muy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tamal ti kawayay naŋ àna huɗ bəlaŋ, àna majalay ahàr gayak ɗek akaba àna njəɗa gayak ɗek zla nahəma, àtama sədaga ya təbi na akaba zlam ya tisliŋi na ɗek àna sulumana. Tamal ti kawayay mis ya nak kə̀bu akaba tay ni akaɗa ya kawayay ahàr gayak gayakani ni nahəma, nani day àtama sədaga ɗek àna sulumana. » ");
INSERT INTO muy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Zal nakəŋ àra àhəŋgrifəŋa kigeni a ti Yezu àsəra naŋ bay məsər zlam. Nahkay àhi ahkado : « Nak kə̀bi driŋ driŋ akaba *Məgur ge Melefit bi. » Kələŋ gani maslaŋa ya ti azay njəɗa gayaŋ ge mihindifiŋa ma nahaŋ a ni ti àbi va bi. ");
INSERT INTO muy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yezu naŋ àbu acahi zlam ana mis a dalaka ga *ahay gəɗakani ge Melefit ni bu. Àhi ana tay : « Ndam *məsər Wakita ge Melefit ni tə̀ɗəm *Krist *Bay gəɗakani ya amara ni naŋ *Wur ge Devit ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ambatakani do, Devit naŋ naŋani àna ahàr gayaŋ àɗəm àna njəɗa ga *Məsuf Njəlatani ahkado : “Bay Melefit àhi ana bay goro : Njəhaɗa gwar kà ahar ga ɗaf goro a, a məlaŋ ga gəɗakani va. Ndam ezir gayak ti anabəhaɗ tay kè meleher gayak akaɗa ga zlam ga bay ya abəki asak ni, ti kə̂cəlki ka tay.” ");
INSERT INTO muy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","« Nəɗəm nahəma, Krist nani ti Devit àna ahàr gayaŋ tekeɗi azalay naŋ bay gayaŋ. Ay tamal nahkay ti təzalay naŋ wur ge Devit keti ti kamam ? » Eslini mis dal-dal tə̀bi slimi ana pakama gayaŋ ya ti àhi ana tay ni. Pakama nani àɓəlafəŋa kà tay a. ");
INSERT INTO muy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yezu naŋ àbu acahi zlam ana tay nahkay ti àɗəm ahkado : « Bumvu slimi, do ni ti ndam *məsər Wakita ge Melefit ni atagosay kʉli. Nday ti tawayay məbakabu məgudi, təsawaɗay àna naŋ riya ; tawayay ti mis tə̂gri sa ana tay a gosku bu kè meleher ge mis ɗek ; ");
INSERT INTO muy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","tawayay manjəhaɗvani e kʉrsi ga gəɗákani vu a ahay ga *mahəŋgalavù Melefit bu akaba ka məlaŋ məzum zlam ga wuməri. ");
INSERT INTO muy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nday gani tə̀bu təhəlfəŋa zlam kà wál madakway a, tə̀bu təpəski ka mahəŋgalay Melefit aɗaba tawayay ti mis tâmənjaləŋ ana tay. Nahkay ti Melefit amagrafəŋa seriya kà tay a, amatraɓ tay kay amatam ge mis ndahaŋ ni ɗek. » ");
INSERT INTO muy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Eslini Yezu naŋ àbu manjəhaɗani digʉsa kà gəvay ga zlam məbəviyu siŋgu ga sədaga ni. Mis tə̀bu eslini kay təbiyu siŋgu ; naŋ nakəŋ amənjaləŋ kà tay ahəmamam təbiyu siŋgu ni : ndam ge elimeni kay tə̀bu təbiyu siŋgu dal-dal. ");
INSERT INTO muy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nday tə̀bu təbiyu nahkay ti wal madakway nahaŋ araŋa gayaŋ àbi àra àbiyu siŋgu akur-akurani ciɓ-ciɓeni cʉ ; siŋgu ciɓ-ciɓeni cʉeni ni agray siŋgu faɗ. ");
INSERT INTO muy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yezu àra èpia ti àzalay ndam maɗəbay naŋ ni, àhi ana tay ahkado : « Nəhi ana kʉli nahəma, wal madakway hini ti araŋa gayaŋ àbi, ay siŋgu ya àbiyu a zlam ga sədaga ni vu ni ti àtama ge mis ndahaŋ ya tə̀biyu na ɗek, ");
INSERT INTO muy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","aɗaba mis ndahaŋ ni ɗek tə̀biyu siŋgu ya tə̀gəjənifəŋ kà tay tə̀sər ere ye ti tagray àna naŋ ni va do ni ; wal hini ti ni araŋa gayaŋ àbi, ay ti àbiya siŋgu ya àfəŋ na ɗek. Siŋgu gayaŋ nahaŋ ga məsəkum zlam məzumani àgəjənifəŋ ndo. » ");
INSERT INTO muy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kələŋ gani Yezu akaba ndam maɗəbay naŋ ni tàhəraya a *ahay gəɗakani ge Melefit ni ba. Nday tə̀bu tahəraya nahəma, bəlaŋ e kiɗiŋ ga ndam maɗəbay naŋ ni bu àhi ahkado : « Mʉsi, ŋga mənjaləŋ ka akur gəɗákani ya tèɗezl ahay ni àna naŋ ni day ti, tigi eri ni ! » ");
INSERT INTO muy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ay Yezu àhəŋgrifəŋ, àhi ahkado : « Àbi kìpia ahay hini meɗezleni àna akur gəɗákani na do aw ? Etembeɗkaba besek-besek, ku akur bəlaŋ day amanjəhaɗki ka akur nahaŋ va do. » ");
INSERT INTO muy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tòru tìnjʉa ka ahàr ga həma *Oliviye a nahəma, Yezu ànjəhaɗa digʉsa, amənjoru *ahay gəɗakani ge Melefit ni. Eslini Piyer, Zek, Zeŋ akaba Andre tə̀bu kà gəvay gayaŋ ciliŋ. Nday nakəŋ tìhindifiŋa ma, tə̀hi ahkado : ");
INSERT INTO muy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","« Hiaba ana leli a, ere gani amagravu ti ananaw ? Aməsərkaba sarta ya zlam nani ɗek amagravu wuɗak na ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eslini Yezu nakəŋ àhi ana tay : « Bumvu slimi, maslaŋa àgosay kʉli ba. ");
INSERT INTO muy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aɗaba mis kay atara, ku way way do aməɗəm naŋ ti nu, aməɗəm naŋ ti *Bay gəɗakani ya amara ni. Nahkay atagosay mis kay. ");
INSERT INTO muy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mis atagray silik kè cifeni akaba kè driŋeni, ekicʉm ma gani. Kìcʉma ti kə̀grum aŋgwaz ba. Ahàr àɗəm zlam nday nani tâgravu kwa. Ku tamal tàgrava nahkay nəŋgu ni, mandav ga duniya faŋ do. ");
INSERT INTO muy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ndam ga haɗ ndahaŋ atakaɗvu akaba ndam ga haɗ ndahaŋ, bəbay ndahaŋ akaba bəbay ndahaŋ. Haɗ amadaɗay a kəsa gərgərani ndahaŋ bu, lʉwir day amələbu a kəsa gərgərani ndahaŋ bu. Zlam nday nani ɗek ti mənjəki ga daliya ciliŋ : zlam nday nani ti akaɗa ga wur ya ajibiyu aslər ana wal a huɗ bu ni. ");
INSERT INTO muy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ay lekʉlʉm ti bumvu slimi. Mis atəgəs kʉli, atoru àna kʉli ka məlaŋ ge seriya. Atəzləɓ kʉli a ahay ga *mahəŋgalavù Melefit bu. Atagrafəŋa seriya kè kʉli kè meleher ga gəɗákani ga ngumna akaba bəbay a, aɗaba lekʉlʉm ndam goro. Nahkay ti nday gani etici ma gekʉli ya akazlapumku ni. ");
INSERT INTO muy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wuɗaka məlaŋ andav nahəma, ahàr àɗəm mis tə̂hi *Ma Mʉweni Sulumani ana mis ga haɗ gərgərani ni ɗek day kwa. ");
INSERT INTO muy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","« Yaw ka ya ti atəgəs kʉli, atoru àna kʉli ka məlaŋ ge seriya nahəma, ere ye ti akəɗəmum ni àhəli ahàr ana kʉli ba. Ka fat nani Melefit aməhi ere ye ti akəɗəmum ni ana kʉli ; ɗəmum ma gani nani. Nahkay akəɗəmum ma nani ti lekʉlʉm lekʉlʉmeni do, aməɗəm ma nani ti *Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ka sarta gani nani ti mis atəsəkumoru bəza ga məŋ gatay ti tâbazl tay, ata bəŋ ga bəza day atəsəkumoru bəza gatay. Bəza ti ni etizirey ata bəŋ gatayani akaba ata məŋ gatayani, atəsəkumoru tay ti tâbazl tay. ");
INSERT INTO muy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mis ɗek etizirey kʉli aɗaba lekʉlʉm ndam goro. Ay ti maslaŋa ya ti aməmbrəŋ nu do duk abivoru ana vaɗ ga mandav ga sifa gayaŋ ni ti, Melefit amahəŋgay naŋ. » ");
INSERT INTO muy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","« Zlam magədavani ya àɓəlay do ferereni, eziŋ zlam ɗek ni, amagravu. Amagrava ti ekipʉm naŋ ka məlaŋ ya àgəski do ni. » (Bay ya ti ejeŋgey ma hini ni ti ahàr àɗəm mîci lala). « Ekipʉma naŋ a ti ahàr àɗəm ndam ya ka haɗ *Zʉde ni tâcuhworu a həma vu kwa. ");
INSERT INTO muy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Maslaŋa ya ti naŋ ka *dalahar ga ahay gayaŋ ni àhəraya, àhuriyu a ahay vu ga məhəlaya zlam gayaŋ a day ba. Mâhəraya mâcuhway sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Maslaŋa ya ti naŋ a vədaŋ bu ni ti ni, àŋga a magam ga mara mazay azana gayaŋ a ba. Mâcuhway sawaŋ. ");
INSERT INTO muy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka sarta gani nani ti wál a huɗ akaba nday ya ti bəza tə̀fəŋ kà tay ka ahar ni atasay cicihi ! ");
INSERT INTO muy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nahkay ti həŋgalum Melefit ti ere gani nani àgravu ge milevi ba, ");
INSERT INTO muy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","aɗaba ka sarta gani nani ti mis atəcakay daliya kay àtam daliya ndahaŋ ya mis tə̀cakabiyu kwa ahaslani ka ya ti Melefit àgraya məlaŋ a duk àbivaya ana kana ni. Kələŋ ga daliya nani ti daliya ndahaŋ atələbi akaɗa nani ɗay-ɗay va bi. ");
INSERT INTO muy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Bay geli àɗəm sarta gani nani aməpəs do, do ni ti maslaŋa àbi amatamfəŋa kà daliya nana bi. Melefit àɗəm aməpəs do ni ti azuhva ndam gayaŋ ya àdaba tay a ni palam. ");
INSERT INTO muy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ka sarta gani nani ti tamal maslaŋa ahi ana kʉli ahkado : “Pʉm *Krist naŋ àbu ahalay !” ahkay do ni : “Pʉm naŋ àbiyu tegi !” nahəma, kə̀gəsumiki ma gayaŋ ni ba. ");
INSERT INTO muy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aɗaba mam, ndam ndahaŋ atara tasəkaɗ malfaɗa, ku way way do aməɗəm naŋ Krist ahkay do ni naŋ bay məhəŋgri *pakama ge Melefit ana mis. Atagray zlam ya ti mis tìpi ɗay-ɗay ndo ni akaba zlam ya ti aməgri ejep ana mis ni. Tamal agravu tata ni, tawayay mesipet ndam ya ti Melefit àdaba tay a ni. ");
INSERT INTO muy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lekʉlʉm zla nahəma, bumvu slimi, aɗaba nə̀hiva ana kʉli a àndava. » ");
INSERT INTO muy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","« Ay ka sarta gani nani, kələŋ ga daliya ni zla nahəma, fat amacaɗay məlaŋ va do, kiyi day amaslaɗay məlaŋ va do. ");
INSERT INTO muy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Boŋgur atətəɗbiyu e melefit bu, atadəgaya a ga haɗ a ; zlam njəɗa-njəɗani a huɗ melefit bu atədaɗay a məlaŋ gatay bu. ");
INSERT INTO muy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ka sarta gani nani ti mis etipi nu *Wur ge Mis anara a maklaɓasl ba àna njəɗa kay akaba maslaɗay goro a. ");
INSERT INTO muy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka sarta gani nani ti anəslərbiyu *məslər ge Melefit ga macakalakabu ndam ya Melefit àdaba tay a ni kè sliri ga məlaŋ faɗani ni ɗek ; ku ka məlaŋ driŋeni weley weley do ɗek anəcakalakabu mis ka ahar bəlaŋ. » ");
INSERT INTO muy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","« Nazay mazavu gani akaɗa ga məŋ ga *wəruv ni, ahàr àɗəm kicʉm kwa : ka ya ti àbakaba slimberi a mək eɗi nahəma, kə̀səruma mədərdər ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nahkay day tamal kìpʉma zlam ya nə̀hi ana kʉli ni naŋ àbu agravu nahəma, sərumki nu *Wur ge Mis nə̀bu cifa, nìnjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nəhi ana kʉli nahəma, wuɗaka mis ya tə̀bu ka dala nihi ni təmət ɗek ti zlam nday nani ɗek amagrava day kwa. ");
INSERT INTO muy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Məlaŋ ya agavəla akaba məlaŋ ya a ga haɗ ni amandav, ay ti ma goro ya nə̀ɗəm ni amandav ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","« Ay ti ma ga vaɗ gani akaba njemdi gani zla nahəma, maslaŋa àbi àsər bi. *Məslər ge Melefit ya a huɗ melefit bu ni day tə̀sər do, nu Wur ge Melefit tekeɗi nə̀sər do, si Baba Melefit day kwa ti àsəra. ");
INSERT INTO muy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nahkay ti bumvu slimi, njəhaɗum eri, aɗaba kə̀sərum sarta gani nani do. ");
INSERT INTO muy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Amagravu akaɗa ga maslaŋa ya naŋ àbu akoru e mirkwi gayaŋ ni. Wuɗaka ara asləka ti àmbərfəŋ ahay gayaŋ kà ndam ya təgri tʉwi ni, èdikaba tʉwi na ana tay a. Àhi ana bay ya ahətay mahay ni “Njəhaɗ eri” mək àsləka. ");
INSERT INTO muy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nahkay ti lekʉlʉm day njəhaɗum eri, aɗaba kə̀sərum sarta ga bay ahay gekʉli ya amasləkabiya na do. Cʉ amasləkabiya ga məlakarawa, cʉ ga huɗ ya vaɗ, cʉ ka ga ya ti agwazl təzlah ni, cʉ ahkay do ni ge miledʉ ti kə̀sərum do. ");
INSERT INTO muy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nahkay ka sarta ya ti aməzlərəvkiaya ke kʉli a bəslaŋ nahəma, àdi ahàr ana kʉli lekʉlʉm e ɗʉwir bu ba. ");
INSERT INTO muy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ere ye ti nə̀hi ana kʉli ni ti nəhi ana mis ɗek : Njəhaɗum eri. » ");
INSERT INTO muy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Vaɗ àvu cʉ, tara tagray wuməri ga *Pak ; wuməri gani nani ti tidivù dipeŋ *miwisiŋeni do. Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni tàgray sawari ti tə̂gəs Yezu àna wir-wir, tawayay takaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Nday nakəŋ tə̀ɗəm : « Mə̀gəs naŋ a wuməri ni vu ba, aɗaba tamal magray nahkay ti mis dal-dalani ni atəmbrəŋ leli do, etizligeya silik a kəsa va. » ");
INSERT INTO muy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yezu naŋ àbu a Betani, a ahay bu afa ga Simu zal ambələk ni. Naŋ àbu manjəhaɗani azum ɗaf. Eslini wal nahaŋ àhurkiviyu ka tay àna tersel njəlatani ge siŋgu kayani a kolombu sulumani bu. Tersel gani nani ti təzalay nardu. Èheɓkia ma ga kolombu na, àbəki tersel ni ka ahàr ga Yezu. ");
INSERT INTO muy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gayaŋ ya àbəki ni ti àwəria ɓəruv ana mis nday ndahaŋ e kiɗiŋ ge mis ya tə̀vu eslini ni ba ; tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Àgudar tersel hini ti kamam ? ");
INSERT INTO muy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hojo amal tə̀səkumoya, tə̀ŋgəta àtam sulay jik diŋ diŋ mahkər, tìdi siŋgu gani ana ndam talaga do aw ? » Nahkay tə̀ləgi ana wal nakəŋ ŋgak-ŋgak. ");
INSERT INTO muy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eslini Yezu nakəŋ àhi ana tay : « Mbrəŋum naŋ ! Kəhəlumi muru ti kamam ? Zlam gayaŋ ya àgru ni ti àɓəlay. ");
INSERT INTO muy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ndam talaga zla nahəma, nday tə̀bu akaba kʉli kəlavaɗ ; kəgrumi sulum ana tay akaɗa ya kawayum ni tata. Ay nu zla ti ananjəhaɗ akaba kʉli kəlavaɗ do. ");
INSERT INTO muy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wal hini àgra zlam ya ti agray tata na : àbəkua tersel ka vu a ti àslamatakabá nu ga məfiyu nu e eviɗ va. ");
INSERT INTO muy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nəhi ana kʉli nahəma, a məlaŋ bu ɗek, ku eley eley do atəɗəmoru *Ma Mʉweni Sulumani ni zla nahəma, ataŋgəhaɗ ere ye ti wal hini àgray ni daya. Nahkay ti wal ni amagəjazlki ahàr ke mis do. » ");
INSERT INTO muy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Zʉdas Iskariyot biliŋ a huɗ ga ndam *maɗəbay Yezu kru mahar cʉeni ni bu òru afa ga gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni ga məɗəfiki Yezu ana tay ti tə̂gəsa naŋ a. ");
INSERT INTO muy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nday nakəŋ tàra tìcia ma gayaŋ na ti tə̀mərva dal-dal, tə̀hi : « Tamal kə̀ɗəfikia Yezu ana leli a ti aməvuk siŋgu. » Kələŋ gani Zʉdas nakəŋ àɗəbay divi ga məɗəfiki Yezu ana tay. ");
INSERT INTO muy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Vaɗ ye enjenjeni ga wuməri ge dipeŋ *miwisiŋeni do ni ènjia. A vaɗ ga wuməri ga *Pak nani ti tisliŋi bəza təmbak ana Melefit. Eslini ti ndam *maɗəbay Yezu ni tìhindifiŋa ma kà Yezu a, tə̀hi ahkado : « Kawayay ti môru mâslamatukkabu zlam məzumani ga wuməri ga Pak ni ti eley ? » ");
INSERT INTO muy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eslini Yezu àslər ndam maɗəbay naŋ bebem cʉ, àhi ana tay : « Dəgum a kəsa gəɗakani ni vu. Ekinjʉmiya nahəma, akəbumkabu ahàr akaba zal nahaŋ àcahbiya yam a mandaray va. Ekipʉma naŋ a ti ɗəbumiyu naŋ ka məlaŋ gayaŋ ya ti ahuriyu ni. ");
INSERT INTO muy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Akəhurumiya ti hindʉmfiŋa ma kà bay ahay na, humi ahkado : “Mʉsi geli àɗəm : Ahay goro ya ti anara nəzumviyu zlam ga wuməri ga Pak ni akaba ndam maɗəbay nu ni ti neley ?” ");
INSERT INTO muy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eslini bay ahay ni aməɗəfiki ahay nahaŋ gəɗakani ka ahàr ga ahay nahaŋ ana kʉli, zlam ɗek àvu maslamatakavani àndava. Slamatumikabu zlam məzumani ni ana leli ti eslini. » ");
INSERT INTO muy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ndam maɗəbay Yezu cʉeni ni tàsləka, tòru a kəsa ni vu. Tòru tìnjʉa ti tə̀di ahàr ana zlam ni ɗek akaɗa ga pakama ga Yezu ya àhi ana tay ni, mək tə̀slamalakabu zlam ga wuməri ga Pak ni. ");
INSERT INTO muy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Məlakarawa àra ègia ti Yezu akaba ndam maɗəbay naŋ kru mahar cʉeni ni tìnjʉa a ahay ni va. ");
INSERT INTO muy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eslini tə̀huriya tànjəhaɗkabá birra, tə̀bu təzum zlam ti Yezu àhi ana tay : « Nəhi ana kʉli nahəma, biliŋ gekʉli ya məzumkabu zlam ni aməsəkumoru nu. » ");
INSERT INTO muy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma ga Yezu ya àɗəm ni ti àhəlia ahàr ana ndam maɗəbay naŋ na ɗek. Ku way way do e kiɗiŋ gatay bu biliŋ àna biliŋeni naŋ àbu àɗəm : « Nu do, do waw ? » ");
INSERT INTO muy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yezu àhi ana tay : « Mis biliŋ e kiɗiŋ gekʉli kru mahar cʉeni ni bu, maslaŋa ya ti mətəlkabiyu ahar a halaf vu ni. » ");
INSERT INTO muy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Àɗəm keti : « Nu *Wur ge Mis nara nəmət akaɗa ga pakama ge Melefit ya àɗəm a Wakita gayaŋ bu ni. Ay ti zləzlaɗa afa ga maslaŋa nani ya ti asəkumoru Wur ge Mis ni ! Hojo akal tìwieya naŋ a ndo. » ");
INSERT INTO muy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ka ya ti təzum zlam nahəma, Yezu àzay *dipeŋ, àgri sʉsi ana Melefit, èsekaba, àbi ana ndam maɗəbay naŋ ni. Àhi ana tay : « Zuma, hini ti aslu ga vu goro. » ");
INSERT INTO muy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kələŋ gani àzay hijiyem akaba zum, àgri sʉsi ana Melefit keti, àvi ana tay, nday ɗek tìsi. ");
INSERT INTO muy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Àhi ana tay : « Hini ti mimiz ga vu goro. Àna mimiz hini ti Melefit awəlkabu pakama gayaŋ akaba ge mis. Aməŋgəzaya a vu goro ba ti ga mahəŋgay mis kay. ");
INSERT INTO muy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nəhi ana kʉli nahəma, enisi zum ge wur ge *viŋ va do, si a vaɗ ya ti enisi zum mʉweni a *Məgur ge Melefit bu ni kwa. » ");
INSERT INTO muy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tàra tə̀zuma zlam na ti nday nakəŋ tàzləbay Melefit àna limis, tàhəraya e mite va, tə̀cəloru a həma *Oliviye vu. ");
INSERT INTO muy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nday tə̀bu takoru ti Yezu àhi ana tay : « Lekʉlʉm ɗek ekijʉmkia ke divi a, aɗaba àbu məbəkiani a Wakita ge Melefit ni bu, Melefit àɗəm amakaɗkia bay majəgay təmbəmbak na ka tay a, nahkay təmbəmbak ni etedevu kway-kwayay. ");
INSERT INTO muy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Anəmət, ay ka ya ti anaŋgaba e kisim ba nahəma, akədumu ahàr e Gelili. » ");
INSERT INTO muy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eslini Piyer àhi : « Ku mis ɗek tijikia ke divi a nəŋgu ni, nu ti nìjikia do. » ");
INSERT INTO muy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ay Yezu àhəŋgrifəŋ, àhi : « Nəhuk nahəma, nak ti kani kani a, a huɗ ga məlavaɗ bu wuɗaka agwazl azlah sak cʉ ti akəɗəm sak mahkər kə̀sər nu do timey. » ");
INSERT INTO muy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eslini Piyer nakəŋ àɗəm : « Aha, nahkay do. Nu ti ku tamal ti məmətkabu nəŋgu nahəma, ŋgay nə̀sər kur do ni ti nə̀ɗəm do simiteni. » Ndam *maɗəbay Yezu ndahaŋ ni ɗek day tə̀ɗəm akaɗa ge Piyer ni. ");
INSERT INTO muy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yezu akaba ndam maɗəbay naŋ ni tòru ka məlaŋ nahaŋ, məlaŋ gani nani ti təzalay Gecimeni. Tòru tìnjʉa eslina ti Yezu àhi ana tay : « Njəhaɗuma ahalay a hayaŋ, nakoru nahəŋgalay Melefit. » ");
INSERT INTO muy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Àzalay Piyer, Zek, akaba Zeŋ, tòru cak. Eslini ti aŋgwaz àdəgaki ka Yezu nakəŋ dal-dal, məɓəruv àtikaba kwir kwir. ");
INSERT INTO muy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Àhi ana tay : « Məɓəruv atukaba, akaɗa nara nəmət. Njəhaɗuma ahalay a, njəhaɗum eri. » ");
INSERT INTO muy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Naŋ nakəŋ àhəɗakfəŋa kà tay a òru cak, àndəhaɗ a huɗ a huɗ, àhəŋgalay Melefit ti àcakay daliya ka sarta nani ba. ");
INSERT INTO muy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Àɗəm : « Aba, Bəba, zlam ɗek kisliki magrani ; həɗakfua daliya hina, nə̀cakay ba ti. Ku nə̀ɗəm nahkay nəŋgu ni, nawayay ti ere ya nak kawayay ni kwa do ni, goro ya nu nawayay ni do. » ");
INSERT INTO muy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Àra àhəŋgala Melefit a nahkay ti àŋgəkia ka ndam maɗəbay naŋ mahkərani na, àdi ahàr ana tay nday e ɗʉwir bu. Èpiɗek tay, àhi ana Piyer : « Simu, kway-kway kinji ɗʉwir aw ? Kèɓesey manjəhaɗani eri njemdi biliŋ koksah aw ? ");
INSERT INTO muy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Njəhaɗum eri, həŋgalum Melefit ti ka ya ti *Seteni esipet kʉli ni ti kìjʉmkia ke divi a ba. Məɓəruv ge mis awayay magray zlam sulumani, ay ti èsliki do, aɗaba aslu ga vu gayaŋ gedebeni. » ");
INSERT INTO muy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yezu àŋgəvù, òru àhəŋgalay Melefit keti, akaɗa gayaŋ ya ti àhəŋgalay piŋani ni. ");
INSERT INTO muy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Àra àhəŋgala nahkay ti àŋgəkia ka ndam maɗəbay naŋ na keti. Àdi ahàr ana tay nday e ɗʉwir bu, tàmətaɓkaba ga manjəhaɗana eri a. Tàra tèpiɗekva ti tə̀sər ere ye ti tə̂hi ni do. ");
INSERT INTO muy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Àŋgəvù keti ya mahkər. Àra àsləkabiya ti àhi ana tay keti : « Kekileŋa kinjʉm ɗʉwir aw ? Kekileŋa kəpəsumaba waw ? Sarta ènjia. Ŋga pʉm, tara təgəsi nu, nu *Wur ge Mis, ana ndam magudar zlam ni. ");
INSERT INTO muy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cikʉmaba, mədəgumkioru ka tay. Ŋga pʉm, maslaŋa ya ti ara agəsi nu ana tay ni ènjia, do ni ti ahəmamam. » ");
INSERT INTO muy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti Zʉdas biliŋ ga ndam *asak ga Yezu kru mahar cʉeni ni ènjia akaba mis a dal-dal, maslalam akaba aday tə̀fəŋ kà tay. Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, ndam *məsər Wakita ge Melefit ni akaba gəɗákani ndahaŋ tə̀slərbiyu tay. ");
INSERT INTO muy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wuɗaka nday tara ti Zʉdas bay məsəkumoru Yezu ni àhivabiya ma ana mis dal-dalani na. Àhi ana tay : « Bay ya ti anəgri sa àna məfəki ma kà tuwər nahəma, naŋ gani hʉya. Gəsuma naŋ a, dəgum àna naŋ, jəgum naŋ lala. » ");
INSERT INTO muy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zʉdas nakəŋ àra ènjia ti àrəkia ka Yezu nakəŋ a hʉya. Àhi : « Mʉsi, » mək àgri sa àna məfəki ma kà tuwər. ");
INSERT INTO muy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nahkay mis ni tàdəgaki ka Yezu cip, tə̀gəs naŋ. ");
INSERT INTO muy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eslini mis biliŋ e kiɗiŋ gatay ya tə̀bu eslini ni bu àraɗ maslalam fətah, àsifəŋa slimi ana bay məgri tʉwi ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit na həndaɗ. ");
INSERT INTO muy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yezu àhi ana mis ni ahkado : « Kədəgumkua àna maslalam akaba aday a, kəgəsum nu akaɗa nu zal akal, ");
INSERT INTO muy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ambatakani do nə̀bu nəcahi zlam ana kʉli a dalaka ga *ahay gəɗakani ge Melefit ni bu kəlavaɗ. Ka gani nani ti kə̀gəsum nu ndo. Ay zlam nani agravu ti ere ya àbu məbəkiani a Wakita ge Melefit ni bu ni mâgravu. » ");
INSERT INTO muy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Eslini ndam maɗəbay naŋ ni ɗek tə̀mbərbu naŋ, tə̀dəgiki ana hwa tiɗizl. ");
INSERT INTO muy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wur dagwa nahaŋ naŋ àbu eslini, məfakabu azana biliŋ ka vu ciliŋ, aɗəboru Yezu bilegeni. Mis ni tàra tìpia naŋ a ti tə̀ɗəm təgəs naŋ. Tara təgəs naŋ ti ");
INSERT INTO muy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","àmbərfəŋ azana gayaŋ ni kà tay, àdiki ana hwa ɗeɗel a mahayma. ");
INSERT INTO muy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tàra tə̀gəsa Yezu a ti tə̀zoru naŋ afa ga gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni. Ɓa-ɓa ti gəɗákani ndahaŋ ga ndam *maŋgalabakabu mis akaba Melefit ni, ndam *məsər Wakita ge Melefit ni akaba gəɗákani ɗek tə̀cakalava eslina. ");
INSERT INTO muy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ka ya ti tə̀bu takoru àna Yezu ni ti Piyer ti ni aɗəboru naŋ kələŋ driŋ. Òru ènjʉa a ahay ga gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni va ti ànjəhaɗ digʉs a dalaka bu, anjafəŋ kà aku akaba ndam magray tʉwi ye eslini ni. ");
INSERT INTO muy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ge seriya ni ɗek tə̀bu taɗəbay zlam magudarani ga məwəlki Yezu ka seriya, aɗaba tawayay takaɗ naŋ, ay ti tə̀ŋgət ndo. ");
INSERT INTO muy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Eslini mis kay tàsəkaɗki malfaɗa, ay ma gatay ni tə̀sava divi a. ");
INSERT INTO muy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kələŋ gani mis ndahaŋ tìcikaba, tàsəkaɗki malfaɗa nahaŋ keti, ");
INSERT INTO muy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","tə̀ɗəm : « Leli mìcifiŋa, àɗəm ahkado : “*Ahay gəɗakani ge Melefit hini ya mis tə̀ləm àna ahar ni ti nara nembeɗkaba. Enembeɗkaba ti a huɗ ga vaɗ mahkərani bu nələmvaya nahaŋ ya mis tə̀ləm àna ahar do na.” » ");
INSERT INTO muy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ay kekileŋa ma gatay ni tə̀sava divi a. ");
INSERT INTO muy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eslini gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni ècikaba cəkwaɗ e kiɗiŋ ge mis ni ba, èhindifiŋa ma kà Yezu a, àhi : « Nak kàhəŋgarfəŋ do aw ? Zlapay ge mis hini ya ti təzlapakuk ni ti zlapay ga mam ? » ");
INSERT INTO muy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ay Yezu nakəŋ te-te, àhəŋgrifəŋ ndo. Eslini gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni èhindifiŋa ma keti, àhi : « Nak ti *Krist *Bay gəɗakani ya amara ni aw ? Nak wur ga Bay Melefit ya ti mazləbay ni aw ? » ");
INSERT INTO muy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eslini Yezu nakəŋ àɗəm : « Iy, nu gani. Ekipʉm nu *Wur ge Mis manjəhaɗani a məlaŋ ga gəɗakani bu, kà ahar ga ɗaf ge Melefit Bay njəɗa-njəɗani ni. Ekipʉm anara a huɗ melefit ba a maklaɓasl ba. » ");
INSERT INTO muy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Gəɗakani nakəŋ àra ècia ma ga Yezu na ti àzumkia ɓəruv a, ègʉzlehkaba azana ka vu gayaŋ a kwar, àhi ana mis ni ahkado : « Maɗəbay sedi nahaŋ kamam mba mam ? ");
INSERT INTO muy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kìcʉma, endivi Melefit timey ! Ay ti kawayum ti mə̂grumi mam ? » Mək mis ni ɗek tə̀ɗəm : « Àgudara, si tâkaɗ naŋ kwa. » ");
INSERT INTO muy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eslini mis ndahaŋ tə̀dəgiki ana mitifiviyu esliɓ ana Yezu e eri vu, tàkambahi eri, tə̀si məɗukɗuk ga ahar, tə̀hi : « Tamal nak bay mahəŋgaray *pakama ge Melefit nahəma, ɗəfiaya maslaŋa ya ti àzləɓ kur na ana leli a zla ! » Mək mis ya tə̀bu tagray tʉwi eslini afa ga bay gəɗakani nani ni tàzay naŋ, tə̀bi bəbarva. ");
INSERT INTO muy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ka ya ti Piyer naŋ àbu a dalaka mbeheni ni bu nahəma, wal nahaŋ àra : wal nani agri tʉwi ana bay gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni. ");
INSERT INTO muy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Àra ènjia ti èpi Piyer naŋ àbu anjafəŋ kà aku, àmənjaləŋ lala mək àhi : « Nak day kàsawaɗumkabá akaba Yezu zal Nazaret na. » ");
INSERT INTO muy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eslini Piyer àhi : « Aha. Nə̀sər ma gani do, nìcikaba ere ye ti kawayay kəɗəm na do. » Àra àɗəma nahkay ti ècikaba, àsləkaba a dalaka ni ba, òru e gejiŋ vu. Mək agwazl àzlah. ");
INSERT INTO muy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wal ni àra èpia naŋ a keti ti àhi ana mis ya ti eslini ni : « Naŋ hini ti naŋ ndam gatay gani. » ");
INSERT INTO muy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eslini Piyer àɗəm keti : « Aha, nu nə̀sər ma gani do. » Àra àpəsa ɓal ti mis ya ti eslini ni tə̀hi ana Piyer keti : « Eɗeɗiŋ nak day ndam gatay gani, aɗaba nak zal Gelili. » ");
INSERT INTO muy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Naŋ nakəŋ àmbaɗay dək, àɗəm : « Nə̀sər maslaŋa nani ya ti kacalumfəŋ ni do. Tamal nasəkaɗ malfaɗa nahəma, Melefit mâkaɗa nu a. » ");
INSERT INTO muy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eslini agwazl àzlah ye cʉ hʉya. Agwazl ni àra àzlaha ti Piyer nakəŋ ma ga Yezu ya àhi : « Wuɗaka ti agwazl azlah sak cʉ nahəma, akəɗəm sak mahkər kə̀sər nu do timey » ni àŋgiaya a ahàr ba. Nahkay Piyer àdiki ana tuway. ");
INSERT INTO muy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dʉ àna zʉzʉeni nahəma gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, ndam *məsər Wakita ge Melefit ni akaba nday gəɗákani ge seriya ni ɗek tə̀cakalava, tàgray sawari. Eslini tə̀gəs Yezu, tə̀wəl mək tòru àna naŋ afa ga bay *Pilet. ");
INSERT INTO muy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tòru tìnjʉa àna Yezu a ti Pilet nakəŋ èhindifiŋa ma, àhi : « Nak ti bay ga ndam *Zʉde eɗeɗiŋ aw ? » Àhəŋgrifəŋ, àhi : « Nak kə̀ɗəm. » ");
INSERT INTO muy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eslini gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni tacalki naŋ ka zlam magudarani kay. ");
INSERT INTO muy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilet èhindifiŋa ma keti, àhi ahkado : « Tacalki kur ka zlam magudarani kay ti kici do aw ? Kàhəŋgarfəŋ do aw ? » ");
INSERT INTO muy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ay Yezu naŋ te-te, àhəŋgrifəŋ va do. Gayaŋ ya àhəŋgarfəŋ ndo ni ti àgria ejep ana Pilet a. ");
INSERT INTO muy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kəla wuməri ga *Pak zla ti ndam *Zʉde tə̀bu tihindifiŋa kè Pilet a ti mə̂faya zal daŋgay a bəlaŋ. Tìhindifiŋa ti naŋ àbu afiaya maslaŋa ya tawayay na ana tay a. ");
INSERT INTO muy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Zal nahaŋ àbu, slimi gayaŋ Barabas ; tə̀fiya naŋ a daŋgay va akaba mis ndahaŋ ya ti tàkaɗfəŋva kà ŋgumna ni. Ka sarta ya ti tàkaɗfəŋva kà ŋgumna ni ti naŋ àkaɗa mis a. ");
INSERT INTO muy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eslini mis dal-dalani ni tàra afa ge Pilet a, tìhindifiŋa ti mə̂gri ana tay akaɗa gayaŋ ya ti agri ana tay kilevi ni. ");
INSERT INTO muy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tàra tìhindifiŋa nahkay ti Pilet nakəŋ àhi ana tay ahkado : « Nihi ti kawayum nə̂fiaya bay ga ndam Zʉde na ana kʉli a waw ? » ");
INSERT INTO muy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Àɗəm nahkay ti, àsəra gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀gəsibiyu Yezu ti aɗaba tagraləŋ solu palam. ");
INSERT INTO muy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ay gəɗákani ni tàwayay ndo, tə̀hi ana mis dal-dalani ni : « Humi : “Mawayay ti kàfaya naŋ a ba, si Barabas kwa.” » Mək tə̀hi nahkay. ");
INSERT INTO muy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilet nakəŋ àra ècia ma gatay na zla nahəma, àhi ana tay keti : « Kawayum ti nə̂gri mam ana maslaŋa ya ti kazalum naŋ Bay ga ndam Zʉde ni mam ? » ");
INSERT INTO muy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tə̀həŋgrifəŋ àna zlahay : « *Darfəŋ naŋ kà təndal ! » ");
INSERT INTO muy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nahkay naŋ nakəŋ èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Àgudar mam emiteni mam ? » Nday nakəŋ ba təzlah kay kay : « Darfəŋ naŋ kà təndal ! » ");
INSERT INTO muy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nahkay ti Pilet awayay aməri ɓəruv ana mis dal-dalani ni, àfiaya Barabas nakəŋ ana tay a, àhi ana ndam slewja gayaŋ ti tə̂zləɓ Yezu àna kurupu. Tàra tə̀zləɓa naŋ a ti àhi ana tay ti tâzay naŋ, tôru tâdarfəŋ naŋ kà təndal. ");
INSERT INTO muy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ndam slewja ni tə̀gəs Yezu nakəŋ, tə̀zoru naŋ a huɗ ahay ga bay *Pilet ni vu. Ahay gani nani, təzalay Pretwer. Eslini tə̀zalakabu ndam slewja ndahaŋ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ndam slewja ni tàmbatki azana ndizeni ka Yezu, mək tèkeleya adak a, tàslap hindigil-hindigil, tə̀fiviyu a ahàr vu akaɗa ga jaku ni. ");
INSERT INTO muy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tàra tə̀bəkia zlam a zla nahəma, tə̀gri sa, tə̀hi ahkado : « Məgruk sa, bay ga ndam *Zʉde ! » ");
INSERT INTO muy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tàzay eziŋgwi, tə̀si a ahàr vu, tìtifiviyu esliɓ e eri vu, tàbəhaɗi mirdim meleher ndiɓa ndiɓa ana haɗ. ");
INSERT INTO muy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tàra tə̀bia seki a nahkay ti tə̀cakwakia azana ndizeni ya tə̀fəki na, tə̀bikabu azana gayaŋ gayaŋani ya tə̀cakwakia ni. Eslini tə̀zaya naŋ e mite va, ga moru *madarfəŋ naŋ kà təndal a. ");
INSERT INTO muy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ndam slewja ni tàbakabu ahàr akaba zal nahaŋ naŋ àbu asləkabiya e gili a. Slimi gayaŋ Simu, naŋ bəŋ ge Eleksender nday ata Rufus, naŋ ga kəsa Sireŋ. Eslini nday nakəŋ tə̀fəki ŋgasa ga mazay təndal ga *madarfəŋ Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nahkay tə̀zoru Yezu a məlaŋ nahaŋ vu ; məlaŋ gani nani ti təzalay Golgota, aɗəmvaba « Məlaŋ ga aslat ga ahàr. » ");
INSERT INTO muy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tòru tìnjʉa àna Yezu nakəŋ a zla ti tawayay təvi zum mebeɗekabani akaba haf ya ti təzalay mir ni. Ay ti Yezu àwayay ndo. ");
INSERT INTO muy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eslini tàdarfəŋ naŋ kà təndal ni. Tàra tàdarfəŋa naŋ a ti tàgraki ca-ca àki ka azana gayaŋ ni bəlaŋ àna bəlaŋ ti tə̂sər way azum way. ");
INSERT INTO muy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sarta ya tàdarfəŋ naŋ kà təndal ni ti agray njemdi ambəlmbu ya ge miledʉ. ");
INSERT INTO muy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pakama àbu məbəkiani ka təndal, ka məlaŋ ya təbəki zlam magudarani ge mis ni ti mis ɗek tə̂sər, tə̀bəki ti nahkay hi : « Bay ga ndam *Zʉde. » ");
INSERT INTO muy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tàdarfəŋ ndam akal bebem cʉ kà təndal ndahaŋ kà gəvay ga Yezu, bəlaŋ gani ka ahar ga ɗaf, bəlaŋ gani ti ni ka ahar ga gəjar.  ");
INSERT INTO muy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nahkay ti pakama ya àbu məbəkiani a Wakita ge Melefit bu ni àgrava. Pakama gani nani ti nihi : « Tara tacalkivu naŋ àkivu ka ndam magudar zlam.  » ");
INSERT INTO muy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nday ya ti takoru gwar eslini ni tàra tìpia naŋ a ti tìndivi naŋ, tə̀daɗay ahàr, tə̀hikaboru : « Hey, nak ya ti kə̀ɗəm ahkado : “Nembeɗvù *ahay gəɗakani ge Melefit ni ti anələmaba a huɗ ga vaɗ mahkərani ba” ni do aw ? ");
INSERT INTO muy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Həŋgay ahàr gayak, həraya kà təndal na zla ! » ");
INSERT INTO muy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ga ndam *məsər Wakita ge Melefit ni tə̀bu təzlapay e kiɗiŋ gatay bu, teyefiŋ daya. Tə̀ɗəm ahkado : « Naŋ nakəŋ àhəŋgaraba mis ndahaŋ a keti ni ti, àhəŋgaraba ahàr gayaŋ a koksah timey ! ");
INSERT INTO muy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Àɗəm naŋ *Krist *Bay gəɗakani ya amara ni, naŋ bay ga ndam *Izireyel ti, mâhəraya kà təndal na ! Tamal ti àhəraya kà təndal na nahəma, leli tekeɗi aməfəki ahàr bilegeni. » Mis ya tə̀bu madarfəŋani kà gəvay ga Yezu ni day tìndivi naŋ. ");
INSERT INTO muy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Fat àra ècika tirkeɗ-keɗ ka ahàr melefit a ti ləvəŋ àgray ka haɗ ni ɗek, tekɗefiŋ duk àbivoru àna njemdi mahkər ya ga məlakarawa. ");
INSERT INTO muy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Àra àgra njemdi mahkər ti Yezu àdi ana zlahay kay kay, àɗəm : « Eloyi, Eloyi, lama sabahtani ? » Awayay aɗəmvaba ti « Bay Melefit, Bay Melefit goro ni, kə̀mbrəŋ nu ti kamam ?  » ");
INSERT INTO muy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mis ya tə̀bu eslini ni ndahaŋ tàra tìcia gayaŋ ya ti àzlah na ti tə̀ɗəm : « Cʉm day ti azalay Eli ni. » ");
INSERT INTO muy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eslini biliŋ gatay àcuhworu àzay zlam ya esikabu yam akaɗa ga matala ni, àtəliyu a zum cecʉwekeni vu juɓ, àɓahki ka aday, àtəlikabiyu ana Yezu a ma vu ti mîsi. Àɗəm : « Ɓesʉma day, tamal ti Eli ara azaya naŋ kà təndal na ti mara mipi. » ");
INSERT INTO muy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ay Yezu nakəŋ àzlahkivu kay kay, àmət. ");
INSERT INTO muy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka ya ti àmət ni ti azana ga mahay ga məlaŋ *njəlatani ya ti a huɗ ga *ahay gəɗakani ge Melefit ni bu ni ègʉzlehvabiyu kwarra, agavəla cekw a haɗ. ");
INSERT INTO muy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eslini bay ga ndam slewja ni naŋ àbu micikeni kama ga Yezu. Àra èpia gayaŋ ya àmət na ti àɗəm ahkado : « Maslaŋa hini ti Wur ge Melefit eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wál ndahaŋ tə̀bu eslini cak, tamənjoru. Wál nday hini tə̀kibu ka tay : Mari ga kəsa Magədala, Salomi akaba Mari məŋ ga ata Zek gʉziteni nday ata Zoze ni. ");
INSERT INTO muy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ka ya ti Yezu naŋ àbu ka haɗ *Gelili ni ti nday gani tàɗəba naŋ a, tə̀gria tʉwi a. Wál ndahaŋ kay tə̀bu tamənjaləŋoru bilegeni, wál nday nani tə̀cəloya akaba Yezu a Zerʉzalem a. ");
INSERT INTO muy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Məlakarawa àra ègia mis tə̀bu təslamatavu ga vaɗ *məpəsabana ga hajəŋ a ti ");
INSERT INTO muy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","zal nahaŋ e kiɗiŋ ge mis gəɗákani ya ti tagray seriya ni bu àra. Təzalay naŋ Zʉzef, naŋ ga kəsa Erimete. Naŋ day ajəgay *Məgur ge Melefit. Àzay njəɗa gayaŋ, òru afa ge Pilet, èhindi kisim ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Gayaŋ ya ti èhindi kisim ni ti àgria ejep ana Pilet a. Pilet àhi ana ahàr : « Yezu ti àməta àndava eɗeɗiŋ a waw ? » mək àzalay bay ga ndam slewja ni. Naŋ nakəŋ àra ènjia ti Pilet èhindifiŋa ma, àhi : « Àməta àpəsa eɗeɗiŋ a waw ? » ");
INSERT INTO muy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Bay ga ndam slewja ni àra àhia « Àməta » ti Pilet àvi divi ana Zʉzef ti môru mâzay kisim ga Yezu na. ");
INSERT INTO muy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nahkay Zʉzef òru àsəkumbiyu dawra, àzaya kisim ga Yezu kà təndal na, àkambah. Àra àkambaha ti àfiyu e mindiviŋ vu. Mindiviŋ nani ti miliyeni a pəlaɗ vu. Àra àfiya kisim ga Yezu na e mindiviŋ ni va ti àbəlaɗiviyu belim gəɗakani ana mahay ge mindiviŋ ni. ");
INSERT INTO muy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ata Mari ga kəsa Magədala ni akaba Mari məŋ ga Zoze ni nday tə̀bu tamənjaləŋ ka məlaŋ ya tə̀fiyu kisim ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Vaɗ *məpəsabana àra àsləkaba zla nahəma, Mari ga kəsa Magədala ni, Mari məŋ ge Zek, akaba Salomi tòru tə̀səkumbiyu tersel, ti târa tâgraki ka vu ga Yezu. ");
INSERT INTO muy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ge miledʉ fat azlərəvaya a vaɗ enjenjeni ga gosku a zla nahəma, nday nakəŋ tòru ke mindiviŋ ni. ");
INSERT INTO muy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tə̀bu təzlaporu ka ahàr divi, tə̀ɗəm ahkado : « Way amoru mabəlaɗiləŋa belim na ana leli kè mindiviŋ na way ? » ");
INSERT INTO muy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Belim gani nani ti gəɗakani gəɗak. Tàra tàmənjoru ti tìpi ti mindiviŋ nakəŋ bəŋa, belim ni mabəlaɗləŋana. ");
INSERT INTO muy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tòru tìnjʉa ti tə̀huriyu e mindiviŋ ni vu. Tàra tə̀huriya ti tìpi wur dagwa nahaŋ naŋ àbu manjəhaɗani digʉsa ka ahar ga ɗaf, məbakabu azana bəɗ-bəɗani, àsia aŋgwaz ana tay a kay. ");
INSERT INTO muy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Àhi ana tay ahkado : « Aŋgwaz àwər kʉli ba. Kəɗəbum ti Yezu zal Nazaret, ya ti tàkaɗfəŋ naŋ kà təndal ni. Àŋgaba e kisim ba, naŋ àbi ahalay va bi. Mənjumki, məlaŋ ya tàfəkaɗ kisim gayaŋ ni nihi. ");
INSERT INTO muy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nihi ti dəgum, kə̂humi ma gani ana ata Piyer ndam maɗəbay naŋ ni, humi ana tay ahkado : “Àdoru ka haɗ *Gelili kama gekʉli, akədumi ahàr ti eslini, akaɗa gayaŋ ya ti àhi ana kʉli ni.” » ");
INSERT INTO muy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nday nakəŋ tàhəraya e mindiviŋ ni ba tə̀dəgikibiyu ana hwa ; aŋgwaz àwər tay a, tə̀gəgəra. Tàra tàsləkabiya zla ti tə̀hi ma gani ana maslaŋa ndo, aɗaba aŋgwaz àwəra tay a kay.  ");
INSERT INTO muy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yezu àŋgaba e kisim ba ge miledʉ a vaɗ enjenjeni ga gosku a. Àra àŋgaya ti àŋgazlivu enji ana Mari ga kəsa Magədala, naŋ ya ti ahaslani Yezu àgariaba seteni a adəskəla ni. ");
INSERT INTO muy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naŋ nakəŋ àra èpia Yezu a ti òru ga məhi ma gani ana ndam ya tə̀bu akaba Yezu ahaslani ni. Òru àdi ahàr ana tay ti nday tə̀bu titʉwi, ɓəruv awər tay. ");
INSERT INTO muy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mari nakəŋ àhi ana tay ahkado : « Yezu naŋ àbu, nìpia naŋ a. » Ay ma gayaŋ ya àhi ana tay ni ti tə̀gəsiki ndo. ");
INSERT INTO muy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kələŋ gani ndam *maɗəbay Yezu cʉ tə̀bu takoru a kəsa ciɓ-ciɓeni vu ti, Yezu àŋgazlivu ana tay. Àŋgazlivu ana tay ti vu gayaŋ ni akaɗa ya àŋgazlivu ana Mari ni do. ");
INSERT INTO muy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nday nakəŋ day tàsləkabiya ga maŋgəhaɗi ma gani ana ndam maɗəbay Yezu ndahaŋ na. Tàra tàŋgəhaɗia ana tay a nahkay ti nday nani tə̀gəsiki ma gatay ya tàŋgəhaɗi ana tay ni ndo keti. ");
INSERT INTO muy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kələŋ gani ka ya ti ndam maɗəbay naŋ kru mahar bəlaŋani ni tə̀bu təzum zlam nahəma, Yezu nakəŋ àŋgazlivu ana tay. Àra àŋgazliva ana tay a ti àləgi ana tay aɗaba tə̀fəki ahàr ke Melefit ndo, tàwayay məgəsiki pakama ga ndam ya ti tə̀ɗəm : « Mìpia Yezu a, àŋgaba e kisim ba » ni ndo palam. ");
INSERT INTO muy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mək àhi ana tay ahkado : « Dəgum ka haɗ ga məlaŋ ni ɗek, humioru *Ma Mʉweni Sulumani ana mis ya Melefit àgra tay a ni ɗek. ");
INSERT INTO muy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Maslaŋa ya ti àfəkua ahàr a akaba àbara ni ti Melefit amahəŋgay naŋ. Ay maslaŋa ya ti àfəku ahàr ndo ni ti Melefit aməgəs naŋ àna seriya. ");
INSERT INTO muy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nday ya ti tə̀fəkua ahàr a nahəma, məfəku ahàr gatay ni ara asərvu nahkay hi : atagariaba seteni ana mis àna slimi goro a ; atəzlapay àna ma həma ndahaŋ ya nday tə̀sər do ni ; ");
INSERT INTO muy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tamal ti təgəs gavaŋ àna ahar ahkay do ni tisi zlam makaɗ mis day, zlam nday nani atəgri araŋa ana tay do ferera ; tamal ti təbəki *ahar ka ndam ya tèɓesey do ni, ndam nday nani ataŋgaba. » ");
INSERT INTO muy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bay geli Yezu àra àhia pakama na ana tay a nahkay ti Melefit àzoru naŋ agavəla a huɗ melefit vu, mək ànjəhaɗ kà ahar ga ɗaf ge Melefit, a məlaŋ ga gəɗakani vu. ");
INSERT INTO muy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kələŋ gani ndam *asak ga Yezu ni ti ni tàsləka, tə̀hioru *Ma Mʉweni Sulumani ana mis ga haɗ ga məlaŋ ni ɗek. Bay geli àvi njəɗa ana tʉwi gatay ya tàgray ni àna məgrikivu zlam ndahaŋ ya ti mis tìpi ɗay-ɗay ndo ni ana tay. ");
INSERT INTO muy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nəbukki wakita hini ana nak, Teyʉfil goro ni. Nəhuk nahəma, mis kay tàkaɗva, tə̀bəkia zlam ya ti tàgravu e kiɗiŋ geli bu na ka wakita. ");
INSERT INTO muy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wuɗaka tə̀bəki zlam gani nani ti mis ndahaŋ tə̀hibiya ana leli a àndava. Nday ya ti tə̀hi ana leli ni tìpibiya ere ye ti àgravabiya kwa ka mənjəki gani àna eri gatay gatayana. Nahkay zla ti tʉwi gatay ègia ga məhi pakama ge Melefit ana mis a. ");
INSERT INTO muy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ègia mis ndahaŋ ni tə̀bəkia wakita gatay na nahəma, nu day àɓəlafua nawayay nəbukki pakama gani ka wakita, Teyʉfil gəɗakani goro ni. Nawayay nəslamalakabu pakama gani lala, aɗaba nə̀cahakabá ere ye ti àgravu na ɗek, kwa ka mənjəki gani. ");
INSERT INTO muy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nagray nahkay aɗaba nawayay ti kə̂sər pakama ya kìci ni ti pakama ge jiri eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ka sarta ya *Erot naŋ bay gəɗakani ga haɗ ga ndam *Zʉde nahəma, zal nahaŋ àbu, naŋ bay *maŋgalabakabu mis akaba Melefit, slimi gayaŋ Zakari. Naŋ ge dini ga Abiya. Wal gayaŋ day wur huɗ ga *Aroŋ, slimi gani Elizebet. ");
INSERT INTO muy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nday cecʉeni ndam jireni kè eri ge Melefit, təgəskabu *Divi ga Bay Melefit ya tə̀bu məbəkiani a wakita ge Mʉwiz ni bu ni, tagray ere ye ti Melefit awayay ti mis tâgray ni ɗek. Nday gani mis tə̀ŋgətfəŋa zlam magudarani kà tay a do. ");
INSERT INTO muy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ay ti tìwi bəza ndo, aɗaba Elizebet naŋ dəgəlani mək nday cecʉeni tìgia medewel a àndava. ");
INSERT INTO muy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A vaɗ nahaŋ Zakari naŋ àbu agri tʉwi ana Melefit a *ahay gəɗakani ge Melefit ni bu, aɗaba ahar ge tʉwi ga ndam ge dini gayaŋ ènjʉa. ");
INSERT INTO muy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kəlavaɗ ndam maŋgalabakabu mis akaba Melefit ni tihindi Melefit ti mâdaba mis a bəlaŋ e kiɗiŋ gatay ba, ti maslaŋa nani ahuriyu kà mahay ga məlaŋ *njəlatani ni ga mazəbay haf ya ezi akaɗa ge tersel ni : ka fat nani ti Melefit àdaba Zakari a. ");
INSERT INTO muy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sarta ga mazəbay haf ni àra ènjia ti àhuriyu a ahay ni vu. Mis ndahaŋ dal-dalani ni ti ni nday a dalaka bu, tə̀bu tahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eslini *məslər ge Melefit àŋgazlivu : məslər ni jika gwar kà ahar ga ɗaf ga zlam ya ti tazəbaki haf ya ezi àcər ni. ");
INSERT INTO muy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakari nakəŋ àra èpia məslər ge Melefit na ti àbivaya aŋgwaz a, àtia ɓəruv a. ");
INSERT INTO muy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naŋ àbu agray aŋgwaz nahkay nahəma, məslər ge Melefit ni àhi : « Kàgray aŋgwaz ba, Zakari, aɗaba Melefit ècia gayak ya kàhəŋgalay naŋ na. Nahkay wal gayak Elizebet emiwʉkaya wur zalana, akədi slimi gani Zeŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Etiweya wur na ti akəmərvu dal-dal àsaɓay, mis kay day atəmərvu ka ya ti etiweya naŋ a ni. ");
INSERT INTO muy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Aɗaba mam, naŋ gani emigi mis gəɗakani kè eri ge Melefit. Emisi zum akaba zlam mawəsani ɗay-ɗay do ; kwa naŋ a huɗ ga məŋani bu *Məsuf Njəlatani àniviyu a məɓəruv bu dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Amahəŋgarbiyu bəza ge Izireyel kay afa ga Bay Melefit gatay ti tə̂fəki ahàr keti. ");
INSERT INTO muy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Amara kama ge Melefit ga məhi ma ge Melefit ana mis a. Melefit aməvi Məsuf akaba njəɗa akaɗa ya àvi ahaslani ana bay mahəŋgaray pakama gayaŋ Eli ni. Amagray tʉwi ga maŋgalabakabu ata bəŋ ga bəza akaba bəza gatay ; mis ya tìciiki slimi ana Melefit do ni amahəŋgarbiyu tay ti tə̂jalay ahàr akaɗa ga ndam ya ticiiki slimi ana Melefit ni. Nahkay amaslamalikabu mis ana Bay geli ga məgri tʉwi. » ");
INSERT INTO muy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eslini Zakari nakəŋ àhəŋgrifəŋ, àhi : « Anəsər ma gayak ya kə̀ɗəm ni ti jiri ti ahəmamam ? Aɗaba nihi leli cʉeni ata wal goro mìgia medewel a ni. » ");
INSERT INTO muy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eslini məslər ge Melefit nakəŋ àhəŋgrifəŋ, àhi : « Nu Gabriyel, nu nə̀bu kè meleher ge Melefit kəlavaɗ. Àslərkukbiyu nu ti nə̂huk ma sulumani ya kìci ni. ");
INSERT INTO muy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nihi ti akazlapay koksah, akəɗəm ma va do, si ere ye ti nə̀huk ni amagrava day, aɗaba kə̀gəskabu pakama goro ndo. Nəhuk nahəma, ere ye ti nə̀ɗəm ni ti amagravu àna vaɗ gani. » ");
INSERT INTO muy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ka sarta ya Zakari naŋ a ahay bu ni ti mis ya a dalaka bu ni tə̀bu tajəgay naŋ. Àra àpəsviya a məlaŋ *njəlatani ni va ti àhəlia ahàr ana tay a. ");
INSERT INTO muy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka ya ti àhəraya ni ti èsliki məɗəm ma va do. Nahkay mis ni tə̀səra èpibiya araŋa a məlaŋ njəlatani ni ba. Naŋ nakəŋ àzlapay koksah, adaɗi ahar ana tay ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nahkay naŋ àbu agri tʉwi ana Melefit. Sarta ge tʉwi gayaŋ ni àra àndava ti àsləka òru a magam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kələŋ gani wal gayaŋ Elizebet àzay huɗ. Àra àza huɗ na ti ànjəhaɗ a ahay bu kiyi zlam, àhəraya e mite va ndo. Àɗəm : ");
INSERT INTO muy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","« Ere ye ti àgrakuvu ni ti tʉwi ga Bay Melefit goro. Nihi ti àjənakia nu a, àzəkua mimili kè eri ge mis a. » ");
INSERT INTO muy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ka ya ti Elizebet naŋ a huɗ kiyi muku nahəma, Melefit àslərbiyu məslər gayaŋ Gabriyel a kəsa nahaŋ vu. Kəsa nani ti təzalay Nazaret, ka haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Àslərkibiyu ka wur dahalay nahaŋ, slimi gayaŋ Mari. Wur dahalay nani ti tə̀via ana zal nahaŋ a ; slimi gani Zʉzef, naŋ wur huɗ ge Devit. Ay ti àzay naŋ faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","*Məslər ge Melefit nakəŋ àrəkioru ka wur dahalay ni, àhi : « Nəgruk sa. Nak ti Melefit awayay kur, agruk sulum gayaŋ. Bay Melefit naŋ àbu akaba kur. » ");
INSERT INTO muy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wur dahalay ni àra ècia sa ga məslər ge Melefit na ti àhəlia ahàr a. Àhi ana ahàr ahkado : « Sa ga mam nahkay mam ? » ");
INSERT INTO muy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eslini məslər ge Melefit nakəŋ àhi : « Kàgray aŋgwaz ba, Mari, aɗaba kə̀ŋgəta zlam sulumana afa ge Melefit a. ");
INSERT INTO muy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kara kazay huɗ wuɗak. Nahkay kara kiwi wur zalani, akədi slimi gani Yezu. ");
INSERT INTO muy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wur nani emigi mis gəɗakani. Melefit naŋ agavəla driŋ aməɗəm wur nani ti Wur gayaŋ. Bay Melefit aməfiyu naŋ a bay ge Devit bəŋ ga bəŋani ya àzum ahaslani ni vu, ");
INSERT INTO muy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","aməgur bəza huɗ ge Zekʉp ga kaŋgay-kaŋgayani, bay gayaŋ amandav ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eslini Mari àhi : « Nu nə̀sər zal do ni ti, anazay huɗ gani ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Məslər ge Melefit ni àhəŋgrifəŋ, àhi : « *Məsuf Njəlatani amərəkuka, Melefit naŋ agavəla driŋ amagray ti kânjəhaɗ a njəɗa gayaŋ bu akaɗa ya kanjəhaɗ e zʉhweri ga məŋgəhaf bu ni. Nahkay wur ya ekiweya ni naŋ njəlata, Melefit amazalay naŋ Wur gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nihi Elizebet wur ga ndam gekʉli ni, naŋ ya ti mis tə̀ɗəm naŋ dəgəlani ni, ku ègia medewel a nəŋgu ni àza huɗ a kiyi muku, wur zalani àniviyu. ");
INSERT INTO muy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aɗaba mam, ere ye ti Melefit èsliki magrani do ni ti àbi. » ");
INSERT INTO muy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari nakəŋ àra ècia ma gayaŋ na ti àhi : « Nu ti nu wal məgri tʉwi ana Bay Melefit. Ere ye ti kə̀hu ni mâgrakuvu ti ! » Eslini məslər ge Melefit ni àsləka, àmbərbu naŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ka sarta gani nani Mari àsləka, àcəloru ke weceweceni gwar a həma vu, a kəsa nahaŋ vu ka haɗ *Zʉde. ");
INSERT INTO muy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Òru ènjʉa ti àhuriyu a ahay vu afa ga Zakari, àgri sa ana Elizebet wal ga Zakari ni. ");
INSERT INTO muy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizebet àra ècia sa ga Mari na ti wur ya ti a huɗ gayaŋ bu ni àdaɗay. Eslini *Məsuf Njəlatani èsliva a vu vu ana Elizebet a, ");
INSERT INTO muy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","mək naŋ nakəŋ àdiki ana zlahay kay kay, àɗəm : « Nak ti Melefit àgruka zlam sulumana àtama ga wál ndahaŋ na ɗek. Àgria sulum ana wur gayak ya a huɗ bu na daya. ");
INSERT INTO muy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nu way ti məŋ ga Bay goro mâra afa goro a way ? ");
INSERT INTO muy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ka ya ti nìci sa gayak ni ti wur ya a huɗ goro bu ni àdaɗa àna məmərana. ");
INSERT INTO muy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nak kə̀bu àna məmərani aɗaba kə̀fəkia ahàr ka Bay Melefit a, kə̀səra amagray ere ye ti àhuk aməgruk ni. » ");
INSERT INTO muy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eslini Mari nakəŋ àɗəm ahkado : « Àna məɓəruv goro ɗek nəɗəm Bay Melefit goro naŋ gəɗakani dal-dal, ");
INSERT INTO muy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nu nə̀bu àna məmərani kay aɗaba Melefit naŋ àbu ahəŋgay nu ; ");
INSERT INTO muy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","aɗaba mam, nu nìsli araŋa do, nəgri tʉwi ana naŋ, ay ti àjalakua ahàr a. Nahkay kwa kani mis ya tə̀bu ni ɗek atəɗəm nu nə̀bu àna məmərani dal-dal ga kaŋgayani. Mis ya etiwi tay kama ni ɗek day atəɗəm nahkay. ");
INSERT INTO muy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Atəɗəm nahkay aɗaba Melefit esliki magray zlam ɗek, àgrua zlam gəɗákana. Melefit ti naŋ njəlata ! ");
INSERT INTO muy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndam ya tabəhaɗi mirdim ni ti awayay tay, agri sulum gayaŋ ana tay akaba ana bəza huɗ bəza huɗ gatayani. ");
INSERT INTO muy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Àgra tʉwi ga njəɗa àna ahar gayaŋ a ; ndam ya ti zlabay àniviyu ana tay ni ti àgrikaba ahàr ana tay a kway-kwayay. ");
INSERT INTO muy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bəbay day àhəlaba tay a bay gatay ba ; ndam ya ti tìsliviyu a mis vu do ni ti àhəlaya tay agavəla. ");
INSERT INTO muy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndam ya ti lʉwir àwər tay ni ti àvia zlam sulumana ana tay a, tə̀rəha àna naŋ a ; ndam ge elimeni ti ni àgara tay a, tàsləka ahar gatay zlam zlam. ");
INSERT INTO muy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndam *Izireyel ti nday ndam məgri tʉwi ana Melefit, nahkay àjənakia tay a ; sulum gayaŋ ya àɗəmbiyu aməgri ana tay ni àgəjazlki ahàr ndo. ");
INSERT INTO muy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sulum gani nani ti àhibiya ma gana ana ata bəŋ geli ahaslana, àɗəm aməgri ana Abraham akaba ana bəza huɗ gayaŋ ga kaŋgay-kaŋgayani. » ");
INSERT INTO muy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari àra àzləba Melefit a nahkay ti àpəsiyu afa ge Elizebet agray kiyi mahkər ; kələŋ gani àsləkabiya, àra a magam a. ");
INSERT INTO muy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiyi ge Elizebet àra ènjia ti èweya wur zalana. ");
INSERT INTO muy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Àra èweya wur na ti àmərva : ndam mahay gayaŋ akaba ndam gayaŋ tàra tìcia Melefit àgria sulum gayaŋ a ti nday day tə̀mərva. ");
INSERT INTO muy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wur ni àra àgra vaɗ azlalahkər a nahəma, mis tàra ge *mekeli kʉɗi a. Tàra tèkelia kʉɗi na ti tawayay tədi slimi ga bəŋani Zakari. ");
INSERT INTO muy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ay ti məŋani àɗəm : « Aha, kàzalum naŋ nahkay ba, slimi gayaŋ Zeŋ. » ");
INSERT INTO muy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tàra tìcia ma ga wal na ti tə̀hi : « Maslaŋa àbi e dini gayak bu təzalay naŋ Zeŋ bi timey. » ");
INSERT INTO muy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nahkay tə̀daɗi ahar ana bəŋ ga wur ni, ti mə̂ɗəfiaya slimi ya naŋ awayay mədiani ana wur ni ana tay a. ");
INSERT INTO muy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mək Zakari nakəŋ èhindifiŋa pələŋgaf kà tay a. Tàra tə̀zibiya ti àbəki : « Slimi gayaŋ Zeŋ. » Gayaŋ ya àra àbəkia nahkay ni ti àgria ejep ana mis na ɗek. ");
INSERT INTO muy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka gani nani Melefit àhəlikaba ma ana Zakari nakəŋ a, àzlapay hʉya, àdi ana mazləbay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ere ye ti àgravu ni ti àsia aŋgwaz ana ndam mahay gayaŋ na ɗek. Ma gani nani àhəndoru ka haɗ *Zʉde a kəsa ya ka həma ni vu ɗek. ");
INSERT INTO muy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndam ya tìcia pakama nana ni ɗek ti tə̀bu təjalaki ahàr, tə̀ɗəm ahkado : « Wur nani ti emigi mam ? » Wur ni ti njəɗa ge Melefit àbu akaba naŋ eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eslini *Məsuf Njəlatani èsliva ana Zakari bəŋ ga wur na a vu va. Nahkay àhəŋgaraya pakama ge Melefit a, àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","« Mazləbay Bay geli, Melefit ga ndam *Izireyel ni, aɗaba àra àmənjaya ndam gayaŋ a, àmba tay a. ");
INSERT INTO muy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Melefit àslərbiya bay njəɗa-njəɗani ga mahəŋgay leli a. Bay njəɗa-njəɗani nani ti wur huɗ ge Devit bay məgri tʉwi ana Melefit ni. ");
INSERT INTO muy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pakama gani nani ti àhibiya ana ndam njəlatani ya tahəŋgaray *pakama gayaŋ ahaslani na, mək nday day tə̀həŋgria ana mis a. ");
INSERT INTO muy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Àɗəm amahəŋgafəŋa leli kà ndam ezir geli a, ti ndam ya tàwayay leli do ni tìsliki ke leli va ba. ");
INSERT INTO muy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Àgria sulum gayaŋ ana ata bəŋ geli a, àjalakia ahàr ka pakama gayaŋ ya àwəlkabu akaba tay na. Pakama gayaŋ ya àwəlkabu akaba gatay ni ti njəlata. ");
INSERT INTO muy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Àjalakia ahàr ka mbaɗay gayaŋ ya àmbaɗi ana Abraham bəŋ geli na. A mbaɗay gayaŋ ni bu àhi ");
INSERT INTO muy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","amahəŋgafəŋa leli kà ndam ezir geli a ti aŋgwaz àwərfəŋa leli kà tay a va ba, ti mə̂fəki ahàr ke Melefit, mâzləbay naŋ, ");
INSERT INTO muy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ti mîgi ndam jireni, ndam njəlatani kè eri gayaŋ duk abiviyu ana mandav ga vaɗ ga sifa geli. » ");
INSERT INTO muy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zakari nakəŋ àɗəm keti : « Nak zla nahəma, wur goro, atəzalay kur bay mahəŋgaray *pakama ge Melefit. Naŋ agavəla driŋ ! Atəzalay kur nahkay aɗaba akədi kama ana Bay gəɗakani geli ga maslamalikabu divi, ");
INSERT INTO muy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ga məhiani ana ndam gayaŋ ni ti tə̂sər Melefit aməmbərfəŋa zlam magudarani gatay na kà tay a, amahəŋgay tay. ");
INSERT INTO muy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Melefit geli ni ti awayay leli, agri sulum gayaŋ ana leli dal-dal. Nahkay amara maslaɗi məlaŋ ana leli kwa agavəla akaɗa ga fat ya azlərəvaya, aslaɗay məlaŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Amaslaɗi məlaŋ ti ana ndam ya ti nday a ləvəŋ bu ni akaba nday ya ti tagrafəŋa aŋgwaz kè kisim a ni, ti mə̂ɗəfiki ana leli ahəmamam manjəhaɗkabu àna sulumani akaba Melefit ni. » ");
INSERT INTO muy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakari nakəŋ àra èndeveriŋa pakama gayaŋ na ti ànjəhaɗ akaba ndam gayaŋ zlam gayaŋ. Nday tə̀bu nahkay ti Zeŋ wur gayaŋ ni naŋ àbu aɗək, məsər zlam gayaŋ asagakivu aɗaba Melefit naŋ àbu akaba naŋ. Ànjəhaɗ e gili duk abiviyu ana vaɗ ya ti àŋgazlivu ana ndam Izireyel vay-vay ni. ");
INSERT INTO muy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ka sarta gani nani ti Egʉst *bay gəɗakani ga ndam Rom àɗəmva. Àɗəm tâcal mis ga haɗ ya naŋ agur ni ɗek, tə̂bəki slimi gatay ka wakita. ");
INSERT INTO muy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Macal mis nani ti ye enjenjeni. Àgravu ka ya ti Kiriniyʉs agur haɗ Siri ni. ");
INSERT INTO muy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nahkay ku way way do ɗek akoru ka haɗ gayaŋ ti tâcal naŋ, tə̂bəki slimi gayaŋ eslini. ");
INSERT INTO muy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ka sarta gani nani ti Zʉzef zal ga Mari ni naŋ àbu ka haɗ *Gelili a kəsa Nazaret bu. Àra ècia ma ga macal mis na ti àsləka òru ka haɗ *Zʉde, a kəsa Betlehem vu. Òru eslini ti aɗaba tìwi bay Devit bəŋ ga bəŋani ahaslani a kəsa gani nani bu. ");
INSERT INTO muy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ka ya ti akoru ni ti àzəkivu wal gayaŋ Mari ju, ti tə̂bəki slimi gatay a kəsa ga ata bəŋ gatayani bu. Ka gani nani ti wal ni huɗ èsliliŋa. ");
INSERT INTO muy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tòru tìnjʉa e Betlehem a nday tə̀bu eslini ti vaɗ ge miwi wur ni ènjʉa. ");
INSERT INTO muy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nahkay naŋ nakəŋ èweya meykweya gayaŋ wur zalana. Àra èweya wur na ti àfiyu naŋ a azana vu mək àfəkaɗ naŋ a kulum vu. Tàfəkaɗ wur ni eslini ti aɗaba mis tìsliva a ahay ga ndam mirkwi ni va, məlaŋ àbi va bi palam. ");
INSERT INTO muy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ka haɗ nani nahəma, ndam majəgay zlam tə̀bu a huɗ gili bu, tanjəhaɗ eri ga majəgay zlam gatay ga məlavaɗ. ");
INSERT INTO muy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nday tə̀bu eslini ti məslər ga Bay geli Melefit àŋgazlivu ana tay, maslaɗani ga Bay geli Melefit àhərkia ka tay a ka məlaŋ nana, àbəvù tay e kiɗiŋ vu. Tàra tìpia nahkay ti àbiva aŋgwaz ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eslini *məslər ge Melefit ni àhi ana tay ahkado : « Kə̀grum aŋgwaz ba. Nihi nahəma, nə̀zibiya ma mʉweni sulumana ana kʉli a. Ndam *Izireyel ɗek eticia ma gana ti atəmərvu àna naŋ dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma ya ti nə̀zibiyu ana kʉli ni ti nihi : Tìwieya bay mahəŋgay mis ana kʉli kana a kəsa ge Devit ba. Naŋ gani *Krist *Bay gəɗakani ya amara ni, naŋ Bay geli gəɗakani. ");
INSERT INTO muy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ere ye ti akəsərum naŋ àna naŋ ni ti nihi : akədumi ahàr ana wur ndeɓ-ndeɓeni a azana bu a kulum bu. » ");
INSERT INTO muy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Àra àɗəma nahkay ti ndam ga slaku ge Melefit dal-dal tə̀zlərəvaya a huɗ melefit va dekik hʉya, nday tə̀bu akaba naŋ, tazləbay Melefit, tə̀ɗəm : ");
INSERT INTO muy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","« Tâzləbay Melefit driŋ agavəla ! Ka haɗ day ndam ya ti Melefit awayay tay ni tânjəhaɗkabu àna sulumani, araŋa àhəli ahàr ana tay ba ! » ");
INSERT INTO muy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","*Məslər ge Melefit ni tàra tàzləba Melefit a nahkay ti tàsləkafəŋa kà ndam majəgay zlam na, tàŋgoru a huɗ melefit vu. Tàra tàsləkafəŋa kà tay a ti nday ti ni tə̀ɗəm e kiɗiŋ gatay bu : « Mədəgum bəɗak e Betlehem, makoru mipʉmbiyu ere ye ti àgravu, Bay Melefit àhi ana leli ni kwa. » ");
INSERT INTO muy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nday nakəŋ tə̀zoru asak kirim-kirim, tòru tə̀di ahàr ana Mari nday ata Zʉzef akaba wur ndeɓ-ndeɓeni ni, naŋ mandəhaɗani a kulum bu. ");
INSERT INTO muy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tàra tìpia wur na ti tàŋgəhaɗ pakama ga məslər ge Melefit ya àhiki ana tay ka wur ni. ");
INSERT INTO muy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mis ya tìcia ma ga ndam majəgay zlam ya tàŋgəhaɗi ana tay na ti àgria ejep ana tay a ɗek. ");
INSERT INTO muy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mari ti ni àgəskabá ma na ɗek a ahàr gayaŋ va, naŋ àbu aɗəgəzlki ahàr dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kələŋ gani ndam majəgay zlam ni tàsləka. Nday àna məmərani, tàzləbay Melefit azuhva zlam ya tìci akaba tìpi ni ɗek. Zlam gani nani ɗek àgrava akaɗa ga məslər ge Melefit ya àhi ana tay na. ");
INSERT INTO muy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wur ni àra àzuma vaɗ a azlalahkər nahəma, *tèkeli kʉɗi, tə̀di slimi Yezu. Slimi nani ti slimi ya ti *məslər ge Melefit àdi mənjəɗ mazay huɗ gayaŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wal ni àra àsaya ɗaf e mite va ti si ndam *maŋgalabakabu mis akaba Melefit ni tə̂ɗəm naŋ ègia njəlatana keti kwa akaɗa ge *Divi ge Melefit ya Mʉwiz àbəki a wakita gayaŋ ni bu ni. Nahkay tòru nday ata zal gayaŋ Zʉzef a Zerʉzalem ga maŋgazli wur ni ana Bay geli Melefit, ");
INSERT INTO muy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","aɗaba àbu məbəkiani e Divi ga Bay geli Melefit bu, Melefit àɗəm ahkado : « Meykweya zalani lu emigi njəlata, naŋ ga Bay geli Melefit. » ");
INSERT INTO muy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Nahkay si təbi kurkoduk cʉ ahkay do ni bəza ga guɗuk-guɗuk cʉ ana Bay Melefit akaɗa ya àbu məbəkiani e Divi ga Bay Melefit bu ni kwa. ");
INSERT INTO muy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Eslini zal nahaŋ naŋ àbu a Zerʉzalem, slimi gayaŋ Simeyoŋ, naŋ gani mis jireni, ahəŋgrioru ahàr a haɗ ana Melefit, naŋ àbu ajəgay bay ya ti Melefit aməslərbiyu ga mahəŋgay ndam *Izireyel ni. Simeyoŋ gani *Məsuf Njəlatani naŋ àbu akaba naŋ. ");
INSERT INTO muy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A vaɗ nahaŋ Məsuf Njəlatani àhiaba, àhi : « Wuɗaka kəmət nahəma, ekipia *Krist *Bay gəɗakani ya Bay Melefit aməslərbiyu ni day kwa. » ");
INSERT INTO muy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nahkay ka fat ya ti ata bəŋ ga Yezu nday ata məŋ ga Yezu tə̀zoru Yezu wur gatay ni a dalaka ga *ahay gəɗakani ge Melefit ni vu ga maɗəbay *Divi ge Melefit ya Mʉwiz àbəki a wakita gayaŋ ni bu ni ti, tə̀di ahàr ana Simeyoŋ nakəŋ. Naŋ eslini àndava, aɗaba Məsuf ge Melefit àzoya naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyoŋ nakəŋ àra èpia wur na ti àzay naŋ a ahar vu, àgri sʉsi ana Melefit, àɗəm : ");
INSERT INTO muy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","« Nihi nahəma, Bay goro ni, ere ye ti kə̀hu ni ti kàgra àndava. Nu eviɗi gayak, keɓesey məvu divi ti nə̂mət àna sulumani. ");
INSERT INTO muy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Aɗaba nìpia bay ya ti kə̀slərbiyu ga mahəŋgay mis na àna eri goro a, ");
INSERT INTO muy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","maslaŋa ya ti kàzaba naŋ kè meleher ge mis ga məlaŋ na ɗek ni. ");
INSERT INTO muy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Naŋ gani amaslaɗi məlaŋ ana mis, ti mis ya ti nday ndam *Zʉde do ni ɗek day tə̂sər kur. Nahkay mis ɗek atazləbay ndam Izireyel, ndam gayak ni, azuhva naŋ. » ");
INSERT INTO muy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ata bəŋ ga Yezu nday ata məŋ ga Yezu tàra tìcia ma ga Simeyoŋ ya àɗəmki ka wur na ti àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Eslini Simeyoŋ nakəŋ àhəŋgalay Melefit ti mə̂gri sulum gayaŋ ana tay, mək àhi ana Mari məŋ ga wur ni : « Azuhva wur hini nahəma, ndam Izireyel ndahaŋ kay ataŋgoru kələŋ, nday ndahaŋ kay ti ni atoru kama. Melefit amaŋgazlay naŋ, ay ti mis atəgəskabu naŋ do ; ");
INSERT INTO muy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nahkay amaŋgazlaya zlam ya mis kay təjalay a ahàr gatay bu na vay-vay. Nak Mari ti ni, akacakay daliya, ekitʉwi akaɗa ge mis ya tàtəhaɗa àna maslalam a gək ni. » ");
INSERT INTO muy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Wal nahaŋ naŋ àbu, naŋ wal mahəŋgaray pakama ge Melefit, slimi gayaŋ Ana. Naŋ wur ge Fenʉwel zal Eser. Vi gayaŋ ɗekeni kru kru azlalahkər mahar faɗ, ègia medewel a dal-dal. A dahalay gani nahəma, àda zal a, tìvikabu vi adəskəla, mək zal ni àmətkia. Zal gayaŋ ni àra àməta ti ànjəhaɗ ka ahàr gayaŋ, naŋ wal madakway. Ka sarta gani nani ti naŋ àbu akoru a dalaka ga ahay gəɗakani ge Melefit ni vu kəlavaɗ. Məlafat akaba məlavaɗ gani do ɗek azləbay Melefit eslini àna məgəs *ndəra akaba àna mahəŋgalay naŋ. ");
INSERT INTO muy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka ya ti Simeyoŋ naŋ àbu azlapaki ka Yezu nahəma, wal madakway ni ènjia bilegeni. Àra ènjia ti àgri sʉsi ana Melefit. Mis ndahaŋ tə̀bu eslini tajəgay vaɗ ya ti Melefit amahəŋgay Zerʉzalem ni. Eslini wal nakəŋ àhəŋgri pakama ge Melefit ya àɗəmki ka wur ni ana tay ɗek. ");
INSERT INTO muy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ka ya ti ata Zʉzef nday ata Mari tàɗəba *Divi ga Bay Melefit ya àbu məbəkiani a wakita ge Mʉwiz ni bu na ɗek ti tàsləka àna wur na, tàŋgoru a kəsa gatay vu a Nazaret ka haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nday tə̀bu eslini ti wur ni naŋ àbu aɗək, njəɗa gayaŋ day asagay. Zlam day àsəra kay ; Melefit awayay naŋ, naŋ àbu agri sulum gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ata Zʉzef nday ata Mari takoru a Zerʉzalem tagrabiyu wuməri ga *Pak kilevi. ");
INSERT INTO muy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yezu àra àzuma vi a kru mahar cʉ ti tòru akaba ata bəŋani ata məŋani a Zerʉzalem akaɗa gatay ya tagray kilevi ni. ");
INSERT INTO muy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tàra tàgraba wuməri na àndava ti mis ɗek tàsləka tàŋgoru a magam gatay. Ka ya ti mis ni tàsləka ni ti Yezu àsləka ndo. Ànjəhaɗ a Zerʉzalem ka məsər ga ata bəŋani nday ata məŋani do. ");
INSERT INTO muy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nday tə̀ɗəm bi naŋ àbu asləka akaba ndam gatay ya təsawaɗay akaba tay na. Nahkay tə̀sawaɗay ruk, day kwa ti tàɗəbay naŋ àkibu ka ndam gatay ni, ");
INSERT INTO muy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ay tə̀di ahàr ndo. Tàra tə̀di ahàr ndo ni ti tàŋgoru a Zerʉzalem, tàɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","A vaɗ ya mahkər gani day kwa ti tə̀di ahàr a dalaka ga *ahay gəɗakani ge Melefit ni bu. Naŋ àbu manjəhaɗani digʉsa e kiɗiŋ ge mʉsisi gəɗákani gatay ni bu, abi slimi ana ma gatay ya təɗəm ni, ehindifiŋa ma kà tay a daya. ");
INSERT INTO muy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eslini mis ya tə̀bi slimi ana ma gayaŋ ni ɗek tàgra ejep a, aɗaba àsəra zlam a kay, àhəŋgarfəŋ kà pakama lala. ");
INSERT INTO muy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ata bəŋani nday ata məŋani tàra tə̀dia ahàr a ti tàgra ejep a dal-dal àsaɓay. Eslini məŋani àhi ahkado : « Kə̀gri ere hini ana leli ti kamam, wur goro ? Nihi ahàr àhəliaba ana leli ata buk a dal-dal ga maɗəbay kur a. » ");
INSERT INTO muy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Àra ècia ma ga məŋani na ti àhi ana tay ahkado : « Kə̀ɗəbum nu ti kamam ? Ŋgay ananjəhaɗ a dalaka ga ahay ga Baba bu ni ti kəsərumki do aw ? » ");
INSERT INTO muy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ay ti ata bəŋani ata məŋani tìciaba ma gayaŋ ya àhi ana tay na ndo ferera. ");
INSERT INTO muy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kələŋ gani tàsləka akaba Yezu a, tòru a Nazaret. Naŋ àbu agəsiki ma ga ata bəŋani ata məŋani. Məŋani zla nahəma ajalakioru ahàr ka zlam gani nani ya àgravu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yezu nakəŋ ka ya ti aɗək ni asərkivu zlam àkivu. Àɓəlafəŋa kè Melefit a àkiva, mis day àɓəlafəŋa kà tay a àkiva. ");
INSERT INTO muy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Àra àpəsa vi a ɓal ti Melefit àhi ma gayaŋ ana Zeŋ wur ga Zakari a huɗ gili bu. Ka sarta gani nani ti Tiber *bay gəɗakani ga ndam Rom àzumva a bay gayaŋ va vi kru mahar zlam ; àfiya Pons Pilet a bay ga haɗ ga ndam *Zʉde va ; *Erot agur haɗ *Gelili ; Filip wur ga məŋani agur haɗ Itʉri akaba haɗ Tresenitit ; Lisaniyas agur haɗ Ebileŋ. Anna nday ata Kayif nday gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit. ");
INSERT INTO muy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Melefit àra àhia ma ana Zeŋ a nahkay ti Zeŋ nakəŋ asawaɗay kà gəvay ga zalaka *Zʉrdeŋ, eveliŋ tekesl. Naŋ àbu ahi ana mis : « Mbatumkaba majalay ahàr gekʉli a. Tamal kàmbatumkaba majalay ahàr gekʉli a ti *nabaray kʉli. Nahkay ti Bay Melefit ambərfəŋa zlam magudarani gekʉli ni kè kʉli a. » ");
INSERT INTO muy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nahkay ma ya ti Izayi bay mahəŋgaray *pakama ge Melefit àbəki a wakita gayaŋ ni bu ni àgrava. Àɗəm ahkado : « Maslaŋa azlah a huɗ gili bu, dəŋgu gayaŋ ahəndabiyu. Àɗəm ahkado : “Slamatumikabu divi ana Bay gəɗakani. Ahàr àɗəm divi gayaŋ mâla ndəlaɓa. ");
INSERT INTO muy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Haɗ atərəhvu a zlur-zlur vu ɗek, həma akaba məlaŋ ɗarani ɗek etebesvu, divi maɗaŋgwani etigi ndəlaɓa, divi magədavani atəslamalavu. ");
INSERT INTO muy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nahkay mis ɗek etipi ge Melefit ya ahəŋgay ndam gayaŋ ni.” » ");
INSERT INTO muy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eslini mis kay tə̀rəkia ke Zeŋ a, ti mə̂baray tay. Zeŋ nakəŋ naŋ àbu ahi ana tay : « Lekʉlʉm ti medékw ! Way àhi ana kʉli dəguma afa goro a ti kâtamumfəŋa kà məzum ɓəruv ge Melefit ya ara azumki ke mis wuɗak na way ? ");
INSERT INTO muy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tamal ti kàmbatumkaba majalay ahàr gekʉli a eɗeɗiŋ eɗeɗiŋena ti grum tʉwi ya ti aɗafaki lekʉlʉm kàmbatumva ni. Ŋgay bəŋ ga bəŋ gekʉli Abraham, nahkay akatamum ti kə̀humi ana ahàr ba, aɗaba nəhi ana kʉli nahəma, Melefit esliki məhiani ana akur nday ndani tîgi bəza huɗ ga Abraham day, agravu. ");
INSERT INTO muy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Si kəgrum tʉwi sulumani kwa. Do ni ti Melefit ànjəkia ka matraɓ kʉli a àndava, agri ana kʉli akaɗa ge mis ya məŋ ga zlam gayaŋ tìwi bəza sulumani do ni ti, azay zlaba gayaŋ ekeleba tay a, abiyu tay a aku vu ni. » ");
INSERT INTO muy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eslini mis kayani ni tə̀bu tihindifiŋa ma, tə̀hi : « Nahkay ti leli hi ti mâgray ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zeŋ nakəŋ àhəŋgrifəŋ ana tay, àɗəm ahkado : « Maslaŋa ya ti endʉwi gayaŋ cʉ ni ti mə̂difəŋa bəlaŋ ana maslaŋa ya ti gayaŋ àbi fererani na. Nahkay day maslaŋa ya ti zlam məzumani àfəŋ ni ti mə̂vi ana maslaŋa ya àfəŋ bi ni. » ");
INSERT INTO muy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Eslini ndam *məhəl hadam tə̀rəkia ti mə̂baray tay bilegeni. Nday nakəŋ tìhindifiŋa ma, tə̀hi : « Mʉsi ! Leli ti mâgray ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naŋ nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Lekʉlʉm nahəma, kìhindʉmfiŋa hadam kè mis a àtamkia ka ga ŋgumna ya àhi ana kʉli ni ba. » ");
INSERT INTO muy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ndam slewja tìhindifiŋa ma daya. Tə̀hi : « Leli timey, mâgray ahəmamam ? » Àhi ana tay : « Lekʉlʉm ti kə̀həlumfəŋa siŋgu kè mis ga njəɗa ba, ahkay do ni àna məsəki malfaɗa ka tay a ba. Həlum siŋgu ya ŋgumna apəli ana kʉli ni ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mis macakalavani ye eslini ni tə̀bu tajəgay ere ya amagravu ni. Tə̀hi ana ahàr : « Zeŋ ti bi naŋ *Bay gəɗakani ya amara ni aw ? » ");
INSERT INTO muy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eslini Zeŋ àhi ana tay ɗek : « Nu ti nabaray kʉli àna yam. Ay ti maslaŋa nahaŋ naŋ àbu ara. Naŋ gani nani ti njəɗa gayaŋ àtama goro a. Nu ti way ga mepicehiaba ezeweɗ ga kimaka gayaŋ a di way ? Naŋ zla nahəma amara məbaray kʉli àna *Məsuf Njəlatani akaba àna aku. ");
INSERT INTO muy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Emedekaba mis a akaɗa ge mis ya àza hijiɗ gayaŋ a ahar va, ahar hay àna naŋ ni. Àharaba ti abiyu yam ga hay ni a guvur vu. Ay kisfit gani ni ti ajiaba aku a. Aku gani nani ti àmət ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nahkay Zeŋ nakəŋ naŋ àbu ahi *Ma Mʉweni Sulumani ana mis. Àhi ma ndahaŋ gərgəri kay ana tay, awayay ti tə̂gəskabá. ");
INSERT INTO muy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ka sarta gani nani ti Erot bay ga haɗ Gelili ni àgudara zlam a. Wur ga məŋ ga Erot àbu, wal gayaŋ slimi gani Erodiyat. Erot àzafəŋa wal ga wur ga məŋani na. Erot àgudara zlam ndahaŋ a kay, nahkay ti Zeŋ àləgi azuhva zlam gayaŋ ya àgudar ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Àra àləgia ti Erot nakəŋ àgudarkivu zlam keti : àfiyu naŋ a daŋgay vu. ");
INSERT INTO muy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ka ya ti mis ɗek *tàbaray ni ti Yezu day àbara. Àra àbara, naŋ àbu ahəŋgalay Melefit ti huɗ melefit àzləkvaba, ");
INSERT INTO muy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","*Məsuf Njəlatani àhərkiaya. Àhərkiaya ti akaɗa ga kurkoduk ya ahər ni ; mis tìpia. Eslini dəŋgu àhəndabiyu a huɗ melefit bu akaɗa dəŋgu ge mis, àhi : « Nak ti wur goro, nawayay kur dal-dal, kəməru məɓəruv dal-dal. » ");
INSERT INTO muy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ka ya ti Yezu ànjəki ke tʉwi gayaŋ nahəma, vi gayaŋ agray kru kru mahkər. A majalay ahàr ge mis bu ni ti Yezu naŋ wur ge Zʉzef. Zʉzef ti ni naŋ wur ge Heli, ");
INSERT INTO muy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli wur ga Matat, Matat wur ge Levi, Levi wur ge Melsi, Melsi wur ga Janay, Janay wur ge Zʉzef, ");
INSERT INTO muy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zʉzef wur ga Matatiyas, Matatiyas wur ga Amos, Amos wur ga Nahum, Nahum wur ge Esili, Esili wur ga Nagay, ");
INSERT INTO muy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay wur ga Mat, Mat wur ga Matatiyas, Matatiyas wur ge Semiŋ, Semiŋ wur ga Zosek, Zosek wur ga Zʉda, ");
INSERT INTO muy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zʉda wur ga Yohanaŋ, Yohanaŋ wur ga Resa, Resa wur ga Zorobabel, Zorobabel wur ga Salatiyel, Salatiyel wur ge Neri, ");
INSERT INTO muy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri wur ge Melsi, Melsi wur ga Adi, Adi wur ga Kosam, Kosam wur ge Elimadam, Elimadam wur ge Er, ");
INSERT INTO muy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wur ga Yezu, Yezu wur ge Eliyezer, Eliyezer wur ga Zorim, Zorim wur ga Matat, Matat wur ge Levi, ");
INSERT INTO muy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi wur ga Simeyoŋ, Simeyoŋ wur ga Zʉda, Zʉda wur ge Zʉzef, Zʉzef wur ga Yonam, Yonam wur ge Eliyakim, ");
INSERT INTO muy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim wur ge Meleya, Meleya wur ga Mena, Mena wur ga Matata, Matata wur ga Nataŋ, Nataŋ wur ge Devit, ");
INSERT INTO muy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit wur ge Zese, Zese wur ga Zobet, Zobet wur ga Boz, Boz wur ga Sala, Sala wur ga Nasoŋ, ");
INSERT INTO muy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasoŋ wur ga Aminadap, Aminadap wur ga Adimiŋ, Adimiŋ wur ge Erni, Erni wur ga Esroŋ, Esroŋ wur ge Ferez, Ferez wur ga Zʉda, ");
INSERT INTO muy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zʉda wur ge Zekʉp, Zekʉp wur ga Izak, Izak wur ga Abraham, Abraham wur ga Tara, Tara wur ga Nakor, ");
INSERT INTO muy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakor wur ge Serʉs, Serʉs wur ga Ragaw, Ragaw wur ge Felek, Felek wur ge Eber, Eber wur ga Sala, ");
INSERT INTO muy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala wur ga Kaynam, Kaynam wur ga Arfazat, Arfazat wur ge Sem, Sem wur ge Nʉwi, Nʉwi wur ge Lemes, ");
INSERT INTO muy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemes wur ga Matusala, Matusala wur ge Enok, Enok wur ge Zeret, Zeret wur ge Meleleyel, Meleleyel wur ga Kaynam, ");
INSERT INTO muy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam wur ge Enos, Enos wur ge Set, Set wur ga Adam ; Adam ti ni, naŋ wur ge Melefit. ");
INSERT INTO muy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yezu àra àbara àndava nahəma, *Məsuf Njəlatani èsliva a vu va. Eslini Yezu nakəŋ àsləkabiya gwar kà zalaka *Zʉrdeŋ a, Məsuf Njəlatani àzoru naŋ a huɗ gili vu. ");
INSERT INTO muy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Eslini *Seteni àhəlfəŋa eyʉ a vaɗ kru kru faɗ. A huɗ ga vaɗ nday nani bu ni ti Yezu àzum araŋa ndo ferera. Kələŋ gani lʉwir àwərkaba naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Lʉwir ni àra àwərkaba naŋ a ti Seteni àhi : « Tamal ti nak Wur ge Melefit eɗeɗiŋ ti, hi ana akur nday nini tə̂mbukvu *dipeŋ zla aw ? » ");
INSERT INTO muy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ay Yezu àhəŋgrifəŋ, àhi : « Àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm : “Mis anjəhaɗ ti àna zlam məzumani ciliŋ do.”  » ");
INSERT INTO muy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Eslini Seteni nakəŋ àzoru naŋ ka məlaŋ zaŋani, àɗəfiki haɗ ga duniya ni ɗek ke weceweceni. ");
INSERT INTO muy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Àhi ana Yezu keti : « Tamal ti kàbəhaɗua mirdim a meleher ndiɓ ana haɗ ti, zlam ya kipioru ni ɗek nəvuk, egi gayak, kəgur tay akaba elimeni gatayani ɗek. Aɗaba zlam nday nani ɗek ti Melefit àbuva tay a ahar va, nisliki məviani ana maslaŋa ya ti nu nawayay nəvi ni tata. » ");
INSERT INTO muy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yezu àhəŋgrifəŋ, àhi : « Àbu məbəkiani a Wakita ge Melefit ni bu : “Akabəhaɗi mirdim ti ana Bay Melefit gayak ; akazləbay naŋ naŋ bəlaŋ ciliŋ.” » ");
INSERT INTO muy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Eslini Seteni nakəŋ àzoru naŋ a Zerʉzalem, àfəkaɗ naŋ jik ka ahàr ga *ahay gəɗakani ge Melefit ni, àhi ahkado : « Tamal nak Wur ge Melefit eɗeɗiŋ ti, diyu a haɗ. ");
INSERT INTO muy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Aɗaba àbu məbəkiani a Wakita ge Melefit ni bu : “Melefit aməhi ana məslər gayaŋ ti tə̂buk slimi.” ");
INSERT INTO muy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Àbu məbəkiani keti : “Atakəcaw kur a ahar vu, ti asak gayak ènjifiŋ kà akur ba.”  » ");
INSERT INTO muy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yezu àhəŋgri zuh keti : « Àbu məbəkiani a Wakita ge Melefit ni bu keti : “Kə̀həlfəŋa eyʉ kà Bay Melefit gayak a ba.”  » ");
INSERT INTO muy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kələŋ gani Seteni àmətaɓfəŋa ga məhəlfəŋa eyʉ kà Yezu àna wir-wir gayaŋ a ɗek ti àsləkafəŋa ga hayaŋana. ");
INSERT INTO muy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yezu àŋgoru ka haɗ *Gelili àna njəɗa ga *Məsuf Njəlatani. Òru ènjʉa eslina ti mis ye eslini ni akaba ga haɗ ndahaŋ ya kà gəvay gani ni ɗek tə̀bu tacalfəŋ. ");
INSERT INTO muy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yezu nakəŋ àcahi zlam ana mis a ahay gatay ya tahəŋgalavù Melefit ni bu. Naŋ àbu acahi zlam ana tay nahkay ti mis ya tə̀bu eslini ni ɗek tazləbay naŋ. ");
INSERT INTO muy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yezu òru a Nazaret ka məlaŋ ya ti àɗək ni. Vaɗ *məpəsabana àra ènjia ti àhuriyu a ahay ga *mahəŋgalavù Melefit vu a kəsa nani bu, akaɗa gayaŋ ya àgray kəla vaɗ məpəsabana ni. Naŋ nakəŋ naŋ àbu eslini ti ècikaba cəkwaɗ ga mejeŋgi Wakita ge Melefit ana mis a. ");
INSERT INTO muy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eslini tə̀vi Wakita ge Melefit ya ti Izayi bay mahəŋgaray *pakama ge Melefit àbəki ni mifeɗekabani, mək àzay, èpelkaba. Naŋ àbu epelkaba nahkay ti àdi ahàr ana məlaŋ ya ti naŋ awayay ni. Àbu məbəkiani ka məlaŋ nani : ");
INSERT INTO muy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","« Məsuf ga Bay Melefit àku ka nu, àdaba nu ga məhi *Ma Mʉweni Sulumani ana ndam talaga, àslərbiyu nu ga məhiani ana ndam daŋgay Melefit amambay tay, ana ndam wuluf day etipi divi, àslərbiyu nu ga məhəlaba ndam ya təcakay daliya ni a daliya gatay ni ba daya, ");
INSERT INTO muy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","akaba ga məhi ana mis vi ya ti Bay geli agri sulum gayaŋ ana tay ni ènjia. » ");
INSERT INTO muy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yezu nakəŋ àra èjeŋga pakama gani nana zla nahəma, èfeɗekabu wakita ni, àhəŋgri ana bay ya ti agray tʉwi a ahay ga mahəŋgalavù Melefit ni bu mək ànjəhaɗ digʉs eslini ga macahi zlam ana mis. Àra ànjəhaɗa zla nahəma, mis ya ti a ahay ga mahəŋgalavù Melefit ni bu ni ɗek tə̀bəkioru eri, tamənjaləŋoru. ");
INSERT INTO muy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Eslini naŋ nakəŋ ànjəki ka macahi zlam ana tay, àhi ana tay ahkado : « Ma ya ti nìjeŋgey a Wakita ge Melefit bu ni ti ma gani nani àgrava kana àndava. Àgravu ka ya ti kìcʉm nu nə̀bu nijeŋgeya ma na ni. » ");
INSERT INTO muy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mis ni ɗek tàra tìcia zlam ya ti àcahi ana tay na ti tə̀ɗəm : « Àsəra zlapay a àsaɓay. » Pakama sulumani ya ti àhəraya a ma gayaŋ ba ni àgria ejep ana tay a dal-dal. Tə̀ɗəm : « Naŋ hini ti wur ge Zʉzef ni timey ? » ");
INSERT INTO muy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eslini Yezu àhi ana tay : « Nə̀səra akəhumu ma gozogul hini : “Nak bay mahəŋgaraba mis àna haf a ni, həŋgaraba ahàr gayak gayakana zla aw ?” Akəhumu keti : “Mìcia ere ye ti kàgray a Kafarnahum na ɗek, ay ti graya akaɗa nana a kəsa gayak gayakani ba bilegeni a zla aw ?” » ");
INSERT INTO muy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Àhi ana tay keti : « Nəhi ana kʉli nahəma, bay mahəŋgaray pakama ge Melefit lu, ndam ga kəsa gayaŋ gayaŋani tàwayay məgəskabu pakama gayaŋ ya àhi ana tay ni do. ");
INSERT INTO muy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sərumki ke ere ye ti àgravu ke zemeni ge Eli ni day. Nəhi ana kʉli nahəma, ka gani nani ti avər àtəɗ ndo vi mahkər àna kiyi muku, lʉwir àdaya ka haɗ nana ɗek. Ka sarta gani nani ti wál madakway day tə̀bu dal-dal ka haɗ Izireyel, ");
INSERT INTO muy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ay ti Melefit àsləroru Eli afa ga wal madakway bəlaŋ gatayani ndo. Àsləroru naŋ ti afa ga wal madakway ga kəsa Serepta ga haɗ Sidoŋ ni ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ke zemeni ge Elize bay mahəŋgaray pakama ge Melefit day ndam ambələk tə̀bu dal-dal ka haɗ Izireyel, ay ti maslaŋa bəlaŋ gatayani Elize àhəŋgaraba naŋ a ègi njəlatani ndo, si àhəŋgaraba ègi njəlatani ti Namaŋ zal ambələk ga haɗ Siri ni ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mis ya ti a ahay ga mahəŋgalavù Melefit ni bu ni tàra tìcia pakama gayaŋ ya àhi ana tay na ti nday ɗek tə̀zuma ɓəruv a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eslini mis ni tìcikaba, tàgaraba naŋ a kəsa gatay ni ba. Kəsa gani nani ti ka ahàr ga həma ; nahkay tə̀zoru naŋ gwar ka məzəgədal, tawayay təbikabiyu ahar ka haɗ. ");
INSERT INTO muy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ay ti Yezu àhuriyu e kiɗiŋ gatay vu, àsləka zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yezu òru a Kafarnahum ka haɗ *Gelili. Vaɗ *məpəsabana àra ènjia ti àhuriyu a ahay gatay ya tahəŋgalavù Melefit ni vu, àcahi zlam ana mis. ");
INSERT INTO muy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Zlam gayaŋ ya àcahi ana tay ni ti àgria ejep ana tay a, aɗaba àhi ma ana tay akaɗa ga bay ni. ");
INSERT INTO muy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nday tə̀bu a ahay ga *mahəŋgalavù Melefit ni bu nahəma, zal nahaŋ seteni àniviyu a ahàr bu naŋ àkibu ka tay eslini. Àra èpia Yezu a ti àzlah kay kay, àɗəm : ");
INSERT INTO muy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","« Hey, Yezu, zal Nazaret, nak ti kaɗəbafəŋa mam kè leli a mam ? Kàra ge mijiŋ leli a waw ? Nak dəgiya nə̀səra kur a lala ; nak mis *njəlatani ge Melefit ya àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eslini Yezu nakəŋ àzlacaki ke seteni ni ɓəra, àhi : « Lakakaba, sləkiaba ana maslaŋa hina. » Seteni ni àra ècia zlacay gayaŋ na ti àdi maslaŋa nani ana məlaŋ e kiɗiŋ ge mis ni bu ɗek. Ay ti àsləkiaba day àgri araŋa ndo ferera. ");
INSERT INTO muy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mis ni tàra tìpia ere ye ti àgravu na ti àgria ejep ana tay a dal-dal, tə̀zlapaki e kiɗiŋ gatay bu, tə̀ɗəm : « Pakama mam hini mam ? Ahi ma ana seteni àna njəɗa akaɗa ga bay ni, mək seteni ni təsləkiaba ana mis a. » ");
INSERT INTO muy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nahkay ti slimi ga Yezu àhəndoru ka haɗ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yezu àhəraya a ahay ga mahəŋgalavù Melefit ni ba, òru suwwa a magam afa ga Simu hʉya. Eslini ti ènjiki mireŋ ga Simu, aku àbəkia dal-dal. Nahkay ti tə̀hi : « Kam-kam, jənaki naŋ ti ! » ");
INSERT INTO muy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yezu nakəŋ àndəhaɗkiyu ahàr, àzlacaki kay kay ka arməwər ni, mək aku ni àhəlkia ka wal na. Eslini wal ni ècikaba cəkwaɗ, àfi ahàr ana tay. ");
INSERT INTO muy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Məlakarawa àra ègia, fat àdiya a ahay va ti mis ya ti ndam gatay arməwər gərgərani awər tay ni ɗek tə̀həlibiyu tay ana Yezu. Àhəŋgaraba tay àna məbəki *ahar ka tay a biliŋ àna biliŋ. ");
INSERT INTO muy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Naŋ àbu ahəŋgaraba mis a ti seteni day tə̀sləkiaba ana mis a kay àna zlahay a. Seteni ni tə̀hi : « Nak ti Wur ge Melefit ! » Ay ti Yezu àləgi ana tay, àcafəŋa tay ga məɗəmana, aɗaba nday tə̀səra naŋ *Krist *Bay gəɗakani ya amara ni. ");
INSERT INTO muy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ge miledʉ dʉ məlaŋ àbu asləbiyu nahəma, Yezu ècikaba, àhəraya òru a huɗ gili vu. Eslini mis dal-dalani taɗəbay naŋ ; tàra tə̀dia ahàr a ti tawayay ti Yezu àsləkafəŋa kà tay a ba, tə̀cafəŋa naŋ ga masləkana. ");
INSERT INTO muy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ay ti Yezu àhəŋgrifəŋ ana tay, àɗəm : « Ahàr àɗəm nə̂hivù *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit ni ana ndam ga kəsa ndahaŋ ni bilegeni kwa ; aɗaba Melefit àslərbiyu nu ti ga magray tʉwi gani nani. » ");
INSERT INTO muy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eslini naŋ nakəŋ òru ka haɗ ga ndam *Zʉde, àhioru ma ge Melefit ana mis a ahay ga *mahəŋgalavù Melefit ye eslini ni bu. ");
INSERT INTO muy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A vaɗ nahaŋ Yezu naŋ àbu micikeni kà gəvay ga dəluv Zenizaret ga macahi zlam ana mis. Eslini ti mis dal-dal tàhəɗakfəŋoru ga məbi slimi ana pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Naŋ nakəŋ naŋ àbu eslini ti èpi *slalah ga yam bebem cʉ ka dəŋ-dəŋ : ndam məgəs kilif tàhəraya a slalah ga yam ni ba, tə̀bu tabarafəŋa zəva gatay a. ");
INSERT INTO muy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nahkay ti Yezu àcəlviyu a slalah ga yam nahaŋ ni vu, slalah ga yam nani ga Simu. Yezu àhi ahkado : « Həɗakfəŋa slalah ga yam na kà gəvay ga dəŋ-dəŋ na. » Àra àhəɗakfəŋa ti Yezu ànjəhaɗ digʉs, ànjəki ka macahi zlam ana mis dal-dalani ni. ");
INSERT INTO muy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Àra èndeveriŋa zlapay gayaŋ na ti àhi ana Simu ahkado : « Həɗakoru slalah ga yam ni kà məlaŋ zileŋeni, ti kə̂təlumiyu zəva gekʉli ni, kə̂gəsumaya kilif àna naŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simu àra ècia pakama gayaŋ na ti àhəŋgrifəŋ, àhi ahkado : « Gəɗakani, màgra tʉwi a hundum, ere ye ti mə̀gəs ni day àbi. Ay tamal nak kə̀ɗəm faŋ ti nətəliyu zəva ni a yam ni vu. » ");
INSERT INTO muy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Simu akaba ndam gayaŋ ni tàra tə̀təliya zəva gatay na ti àgəsa kilif a kay dal-dal, gʉzit amal kilif ni èteɗkaba zəva gatay na. ");
INSERT INTO muy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nahkay tə̀grikaboru ahar ana ndam məgəs kilif ndahaŋ ya ti a slalah ga yam nahaŋ ni bu ni ti târa tə̂jənaki tay ga magəjahana a dala va. Tàra tìnjia ti tàgəjahaya zəva na akaba kilif na. Tə̀bəviyu kilif ni a slalah ga yam ni vu tə̀rəhvù cecʉeni, gʉzit akal slalah ga yam ni takoru a huɗ ga yam ni vu. ");
INSERT INTO muy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simu Piyer àra èpia ere ye ti àgravu na ti àbəhaɗi mirdim ana Yezu, àhi : « Bay goro, həɗakfua, aɗaba nu bay magudar zlam. » ");
INSERT INTO muy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Àɗəm nahkay ti aɗaba nday akaba mis ya ti təgəskabu kilif ni ɗek aŋgwaz àwəra tay a. Aŋgwaz àwər tay ti aɗaba kilif ya tə̀gəsaya kayana ni palam. ");
INSERT INTO muy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nday ya ti tagrakabu tʉwi akaba Simu ni ti bəza ge Zebede, ata Zek nday ata Zeŋ. Nday day aŋgwaz àwəra tay a. Ay ti Yezu àhi ana Simu ahkado : « Aŋgwaz àwər kur ba : kwa kani kìgia bay məhəlibiyu mis ana Melefit a, akaɗa gayak ya kəgəs kilif ni. » ");
INSERT INTO muy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eslini tàsləkabiya a huɗ ga yam ni ba. Tàra tàsləkababiya ti tàgəjahbiyu slalah ga yam gatay ni ka sawiyaka mək tə̀mbərbu zlam gatay ni ɗek, tàɗəbay Yezu. ");
INSERT INTO muy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ka ya ti Yezu naŋ àbu a kəsa nahaŋ bu ni ti zal nahaŋ àra, ambələk èsekaba naŋ a dal-dal. Àra èpia Yezu a ti àrəkia, àbəhaɗi mirdim, meleher ndiɓ ana haɗ, àhi : « Kam-kam, bay goro ni ! Tamal kawayay ti kisliki mahəŋgaraba nu a ti nîgia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eslini Yezu nakəŋ àzoru ahar, ènjifiŋ, àhi ahkado : « Nawayay, gia mis njəlatana. » Nahkay zal ambələk ni àŋgaba, ègia mis njəlatana hʉya. ");
INSERT INTO muy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ay Yezu àhi : « Nihi kə̀ŋgaba nahəma, kə̀hi ma gani ana maslaŋa ba. Ru kəŋgazli vu gayak ni ana bay *maŋgalabakabu mis akaba Melefit sawaŋ ; kə̂vi zlam ana Melefit akaɗa ge Mʉwiz ya àɗəm a wakita gayaŋ bu ni, aɗaba kìgia mis njəlatana. Nahkay mis etipi. Etipia ti atəsər nak kə̀ŋgaba, kìgia mis njəlatana. » ");
INSERT INTO muy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ay slimi ga Yezu àhəndakivoru kama kama sawaŋ. Nahkay mis dal-dal tə̀bu tərəkia ga məbi slimi ana ma gayaŋ na ; tawayay ti mâhəŋgaraba ndam gatay ya tèɓesey do na daya. ");
INSERT INTO muy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A vaɗ ndahaŋ ti Yezu nakəŋ naŋ àbu asləkafəŋa kè mis na, akoru a huɗ gili vu ga mahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A vaɗ nahaŋ Yezu naŋ àbu a ahay bu, acahi zlam ana mis ti ndam *Feriziyeŋ akaba ndam *məsər Wakita ge Melefit ni tàra, tànjəhaɗfəŋ kà gəvay. Tàsləkabiya a kəsa ciɓ-ciɓeni ga haɗ *Gelili akaba ga haɗ *Zʉde ni ba ɗek, tàsləkabiya a Zerʉzalem a daya. Njəɗa ga Bay geli Melefit àbu akaba Yezu, àhəŋgaraba mis àna naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Naŋ àbu eslini ti mis ndahaŋ tə̀zəbiyu zal dəra nahaŋ àki ka slalah. Tàra tìnjia àna naŋ a ti tàɗəbay divi ga məzikabiyu naŋ ana Yezu a ahay vu. Tawayay ti tafəkaɗ naŋ kè meleher gayaŋ, ");
INSERT INTO muy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ay ti tə̀ŋgət divi ga məzikabiyu naŋ ndo aɗaba mis tìsliva eslina. Nahkay ti nday ya ti tə̀zəbiyu zal dəra ni tə̀cəliyu àna naŋ ka *dalahar ga ahay ni, tə̀diaba zlam ya ti tàpaɓ ahay àna naŋ na ɓal. Tàra tə̀diaba ti tə̀fiyu naŋ mandəhaɗkiani ka slalah gayaŋ ni gwar eslini àna ezeweɗ e kiɗiŋ ge mis ni bu, kè meleher ga Yezu. ");
INSERT INTO muy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yezu nakəŋ àra èpia ere ye ti tàgray na ti àsəra tə̀fəkia ahàr a. Nahkay àhi ana zal dəra nakəŋ : « Zləba goro, zlam magudarani gayak ni məmbərfukana. » ");
INSERT INTO muy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ndam məsər Wakita ge Melefit ni akaba ndam Feriziyeŋ ni tàra tìcia ma ga Yezu na ti tə̀jalay a ahàr gatay bu tə̀ɗəm : « Way hini azay ahàr gayaŋ akaɗa naŋ Melefit ni way ? Way esliki məmbərfəŋa zlam magudarani kè mis a tata way ? Tigi Melefit kwa do ni ! » ");
INSERT INTO muy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nday tə̀bu təjalay ahàr nahkay ti Yezu àsəra ere ye ti tə̀jalaki ahàr na àndava, mək àhi ana tay : « Kajalum ahàr nahkay ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Zləzlaɗa gani ti nəhi : “Zlam magudarani gayak ni məmbərfukana,” tək day ti nəhi : “Cicikaba, sawaɗay” ni aw ? ");
INSERT INTO muy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ay nawayay ti kə̂sərum, nu *Wur ge Mis ti nisliki məmbərfəŋa zlam magudarani kè mis ka haɗ a. » Mək àhi ana zal dəra ni : « Nəhuk nahəma : cicikaba, za slalah gayak na, ru a magam. » ");
INSERT INTO muy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eslini naŋ nakəŋ ècikaba cəkwaɗ kè eri ge mis na ɗek hʉya, àzay slalah gayaŋ ya àndəhaɗki ni. Naŋ àbu akoru a magam ti azləboru Melefit hihi. ");
INSERT INTO muy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ga Yezu ya àgray nahkay ni ti àgria ejep ana mis a ɗek ; tàzləbay Melefit. Tàgra aŋgwaz a daya, tə̀ɗəm : « Mìpia ere ye ti mìpi ɗay-ɗay ndo na kana. » ");
INSERT INTO muy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yezu àhəraya a ahay ni ba. Àra àhəraya ti èpi zal nahaŋ, naŋ bay *məhəl hadam, tə̀zalay naŋ Levi, naŋ àbu manjəhaɗani digʉsa ka məlaŋ məhəl hadam. Eslini Yezu àhi ahkado : « Ɗəbabiyu nu. » ");
INSERT INTO muy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nahkay Levi nakəŋ ècikaba cəkwaɗ, àmbrəŋ zlam gayaŋ ni ɗek, àɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kələŋ gani Levi àgray wuməri gəɗakani afa gayaŋ, èdii zlam məzumani dal-dal ana Yezu akaba ndam *maɗəbay naŋ ni. Ndam məhəl hadam akaba mis gatay ndahaŋ tə̀bu təzum zlam ka ahar bəlaŋ akaba tay daya. ");
INSERT INTO muy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ndam *Feriziyeŋ akaba ndam gatay ya *tə̀səra Wakita ge Melefit a ni tàra tìpia ndam maɗəbay Yezu na tə̀bu təzum zlam ni ti tə̀ləgi ana tay, tə̀hi ana tay ahkado : « Kəzumum zlam, kisʉm zlam ka ahar bəlaŋ akaba ndam məhəl hadam akaba ndam magudar zlam ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yezu àra ècia pakama gatay na ti àhi ana tay ahkado : « Ndam ya ti nday tə̀bu njalaŋ-njalaŋ ni ti tòru afa ga zal doktar do, si ndam ga arməwər day kwa ti takoru afa gani. ");
INSERT INTO muy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nu nàra ti ga mazalay ndam jireni do ; nàra ti ga mazalay ndam magudar zlam, ti tâmbatkaba majalay ahàr gatay na sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eslini ndam *Feriziyeŋ ni tə̀hi ana Yezu ahkado : « Ndam maɗəbay Zeŋ ni təgəs *ndəra akaba tahəŋgalay Melefit kəlavaɗ. Ndam maɗəbay leli ni nday day tagray nahkay. Ay ti ndam maɗəbay kur ni nday tə̀bu təzum zlam, tisi zlam zlam gatay ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ay Yezu àhəŋgrifəŋ ana tay, àɗəm : « Kislʉmki məcumfəŋa zləbəba ga bay maday wal na kà məzum zlam ka ya ti nday tə̀bu akaba bay maday wal na tata waw ? Kìslʉmki do. ");
INSERT INTO muy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ay sarta nahaŋ amara, atəgəskia bay ga wal ni kà tay a. Ka sarta gani nani day kwa ti atəgəs ndəra. » ");
INSERT INTO muy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Eslini Yezu àhi ma *gozogul hini ana tay : « Mis egʉzleheya azana gayaŋ mʉwena, aslamalay azana gayaŋ midigweni àna naŋ ti àbi. Tamal àgra nahkay ti azana gayaŋ mʉweni ni day àgədava, mək gayaŋ ya ti àsaya ni day tàrakaboru akaba midigweni ni do. ");
INSERT INTO muy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nahkay day mis abəviyu zum new-neweni e kene-kene midigweni vu ti àbi. Tamal àgra nahkay ti zum new-neweni ni àra àwəsa ti etezkaba kene-kene na. Nahkay ti zum ni amadəgaba, maslaŋa nani emizikiba ke kene-kene na daya. ");
INSERT INTO muy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Àgravu nahkay do ; ahàr àɗəm təbəviyu zum new-neweni e kene-kene mʉweni vu kwa. ");
INSERT INTO muy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tamal mis àsərva àna misi zum mawəsana ti àwayay misi zum new-neweni va do. Aɗəm ahkado : “Zum mawəsani ni àcər àtama new-neweni na.” » ");
INSERT INTO muy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A vaɗ *məpəsabana nahaŋ ba ti Yezu akaba ndam maɗəbay naŋ ni tə̀bu tasləkaba a vədaŋ ga *alkama ba. Eslini ndam maɗəbay naŋ ni tə̀bu teheɓoru alkama ni, tahwal, tahəpəɗoru bəza gani. ");
INSERT INTO muy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nday tə̀bu tagray nahkay ti ndam *Feriziyeŋ ndahaŋ tə̀hi ana tay : « Bay Melefit àɗəm e *Divi gayaŋ ni bu : “Kə̀grum tʉwi a vaɗ məpəsabana ba ba” ti, lekʉlʉm kəgrum ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yezu àra ècia ma gatay na ti àhi ana tay : « Kèjeŋgʉm ere ye ti Devit àgray ni ndo aw ? Ahaslani Devit akaba ndam gayaŋ lʉwir àwəra tay a, ");
INSERT INTO muy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","nahkay àhuriyu a ahay ge Melefit vu, àzay *dipeŋ ya tàfəkaɗi ana Melefit ni. Devit nakəŋ àzum, mək àvi ana ndam gayaŋ ni tə̀zum bilegeni. Ay ti Melefit àɗəm e Divi gayaŋ ni bu, mis ndahaŋ tə̀zum dipeŋ nani do ; si ndam *maŋgalabakabu mis akaba Melefit ni day kwa ti təzum. Kèjeŋgʉm ma gani ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Eslini Yezu àhi ana tay keti : « Bay ya ti aɗəm tâgray zlam hini a vaɗ məpəsabana ba ni ti nu *Wur ge Mis. » ");
INSERT INTO muy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","A vaɗ *məpəsabana nahaŋ ba ti Yezu àhuriyu a ahay ga *mahəŋgalavù Melefit vu. Àra àhuriya ti ànjəki ka macahi zlam ana mis. Eslini zal nahaŋ naŋ àvu ahar ga ɗaf mikʉlfiŋana. ");
INSERT INTO muy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndam *məsər Wakita ge Melefit ni akaba ndam *Feriziyeŋ ni tə̀bu tamənjaləŋ ana Yezu nakəŋ ; tə̀hi ana ahàr ahkado : « Kani vaɗ məpəsabana ti akal ti ara ahəŋgaraba naŋ a waw ? » Tawayay ti təgəski naŋ ka zlam magudarani. ");
INSERT INTO muy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ay ti Yezu àsəra majalay ahàr gatay na. Nahkay àhi ana zal ya ti ahar mikʉlfiŋana ni : « Cikaba, ra e kiɗiŋ ge mis ni va, cik jik. » Nahkay ècikaba, naŋ jika. ");
INSERT INTO muy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Eslini Yezu nakəŋ àhi ana tay : « Nihindifiŋa zlam kè kʉli a day. Melefit àɗəm mam a wakita ya Mʉwiz àbəki ni bu mam ? Àvia divi ana mis ga magray zlam sulumana a vaɗ məpəsabana ba tək, ga magray zlam magudarana waw ? Ga mahəŋgay mis tək, ga makaɗ mis aw ? » ");
INSERT INTO muy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Àmənjaləŋ kè mis ni ɗek bəlaŋ àna bəlaŋ, mək àhi ana zal ya ahar mikʉlfiŋana ni : « Təlbiyu ahar gayak ni. » Àra àtəlikabiya ti ahar gayaŋ ni àslamalava, ègia sənduɓ-sənduɓana. ");
INSERT INTO muy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nahkay ti ndam məsər Wakita ge Melefit ni akaba ndam Feriziyeŋ ni tə̀zuma ɓəruv a dal-dal. Tə̀zlapay e kiɗiŋ gatay bu àki ke ere ye ti tara təgri ana Yezu ni. ");
INSERT INTO muy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A vaɗ nahaŋ Yezu àcəloru a həma vu ga moru mahəŋgalay Melefit. Òru ènjʉa ti àndəhaɗki hundum àki ka mahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Məlaŋ àra àsla ti naŋ nakəŋ àzalakabu ndam maɗəbay naŋ ni, mək àdaba mis a kru mahar cʉ e kiɗiŋ gatay ba. Nday ya ti àdaba tay a ni ti àzalay tay ndam *asak gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Slimi gatay kru mahar cʉeni ni nday hi : Simu àdi slimi Piyer, wur ga məŋani Andre, Zek, Zeŋ, Filip, Bartelemi, ");
INSERT INTO muy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Meciyʉ, Tumas, Zek wur ga Alfe, Simu naŋ bəlaŋ ga ndam ya takaɗvakivu ka haɗ gatay ni, ");
INSERT INTO muy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zʉd wur ge Zek, nahaŋ ni ti ni Zʉdas Iskariyot naŋ ya ègi bay məsəkumoru Yezu ni. ");
INSERT INTO muy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yezu àndaya ahàr a həma ni ba akaba ndam asak gayaŋ na, ècik ka məlaŋ tazl-tazlani. Eslini ti ndam maɗəbay naŋ tə̀bu kay ; mis ndahaŋ day tə̀bu dal-dal, ndahaŋ tìcikbiyu ka haɗ *Zʉde akaba a Zerʉzalem, ndahaŋ ti ni tìcikbiyu kà gəvay ga *dəluv gəɗakani ka haɗ Tir akaba Sidoŋ. ");
INSERT INTO muy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mis nday nani tə̀rəkia ka Yezu a ti ga məbi slimi ana ma gayaŋ ya àɗəm ni, tawayay ti mâhəŋgaraba tay a arməwər gatay ni ba daya. Nahkay Yezu àhəŋgaraba tay a, àhəŋgaraba nday ya ti seteni àniviyu ana tay na daya. ");
INSERT INTO muy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mis ɗek tawayay ti tînjifiŋ, aɗaba njəɗa àvu a vu gayaŋ bu ; ku way way do ya ènjifiŋa ni ti àŋgaba a arməwər gayaŋ ni ba. Nahkay Yezu àhəŋgaraba tay a ɗek. ");
INSERT INTO muy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Eslini Yezu àmənjaləŋ ana ndam maɗəbay naŋ ni, àɗəm : « Lekʉlʉm ndam talaga ni ti mərumvu, aɗaba *Məgur ge Melefit ti gekʉli. ");
INSERT INTO muy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Lekʉlʉm ya lʉwir awər kʉli nihi ni ti mərumvu, aɗaba akərəhum. Lekʉlʉm ya kitʉwʉm nihi ni ti mərumvu, aɗaba ekiyʉm. ");
INSERT INTO muy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","« Ka ya ti mis tipi kʉli kə̀bum kəfumku ahàr ka nu *Wur ge Mis, mək tizirey kʉli, tàwayay kʉli va do, tindivi kʉli akaba təɗəmki ma magədavani àki ke kʉli azuhva nani ni ti mərumvu. ");
INSERT INTO muy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ka ya ti təgri zlam nday nani ana kʉli nahəma, mərumvu dal-dal, həɓum àna məmərani. Aɗaba mam, Melefit aməvi zlam sulumani ana kʉli kay a kəla gani vu a huɗ melefit bu. Sərumki ata bəŋ gatayani day tə̀gribiya zlam gani nana ana ndam mahəŋgaray *pakama ge Melefit ahaslana na. ");
INSERT INTO muy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","« Ay lekʉlʉm ndam ge elimeni ni ti akəsum cicihi, aɗaba lekʉlʉm kə̀zumuma gəɗa gekʉli a àndava. ");
INSERT INTO muy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Lekʉlʉm ya mərəhani nihi ni ti akəsum cicihi, aɗaba lʉwir aməwər kʉli. Lekʉlʉm ya kiyʉm nihi ni ti akəsum cicihi, aɗaba akandavum kuɗa, ekitʉwʉm. ");
INSERT INTO muy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","« Ka ya ti mis ɗek təɗəm lekʉlʉm mis sulumani ni ti akəsum cicihi, aɗaba ahaslani ata bəŋ gatayani tə̀hibiya ma gani nana ana ndam ya ti tàsəkaɗi malfaɗa ana mis, tə̀ɗəm pakama gani ge Melefit na ; tə̀hia ana tay a nday sulumana daya. » ");
INSERT INTO muy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","« Ay nəhi ana kʉli, lekʉlʉm ya kəbumu slimi ni : Wayum ndam ezir gekʉli, grumi sulum ana ndam ya ti tizirey kʉli ni. ");
INSERT INTO muy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tamal mis tetikwesl kʉli nahəma, hindʉm Melefit ti mə̂gri sulum ana tay. Tamal mis təgri daliya ana kʉli ti həŋgalumi Melefit ana tay. ");
INSERT INTO muy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamal mis àsuka barva ka tuwər bəlaŋ gana ti kambatikabiyu tuwər nahaŋ ni daya. Tamal mis àzafuka mugudi gayak a ti kàcafəŋa naŋ ga mazafuka endʉwi gayak a ba daya. ");
INSERT INTO muy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ku way way do èhindilʉka zlam a ti vi. Tamal mis àzafuka zlam gayak a ti kìhindifiŋa ba. ");
INSERT INTO muy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nahkay ere ye ti kawayum mis tə̂gri ana kʉli ni ti, grumi ere gani nani ana tay bilegeni. ");
INSERT INTO muy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","« Ay tamal kawayum ndam ya tawayay kʉli ni ciliŋ ti Melefit aməɗəm lekʉlʉm ndam sulumani aw ? Aha, aɗaba ndam magudar zlam day tawayay ndam ya tawayay tay ni, nahkay do aw ? ");
INSERT INTO muy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tamal kəgrumi sulum ana ndam ya təgri sulum ana kʉli ni ciliŋ ti Melefit aməɗəm lekʉlʉm ndam sulumani aw ? Aha, aɗaba ku ndam magudar zlam day tagray nahkay. ");
INSERT INTO muy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tamal kəkəlumi zlam ana ndam ya ti kə̀səruma atəhəŋgrivu ana kʉli ni ciliŋ ti Melefit aməɗəm lekʉlʉm ndam sulumani aw ? Aha, aɗaba ndam magudar zlam day təkəli zlam ana ndam magudar zlam ndahaŋ, ti tə̂həŋgrivu akaɗa gatay ni ana tay zlam gatay. ");
INSERT INTO muy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Lekʉlʉm ti kə̀grum nahkay ba. Wayum ndam ezir gekʉli, grumi sulum ana tay, kəlumi zlam ana ndam ya kə̀səruma atəhəŋgrivu ana kʉli do ni sawaŋ. Tamal kəgrum nahkay nahəma, Melefit aməvivù zlam ana kʉli kay bilegeni. Nahkay ti ekigʉm bəza ge Melefit. Aɗaba mam, naŋ gani naŋ agavəla driŋ, naŋ àbu agri sulum dal-dal ana ndam cuɗay, ana ndam ya tə̀gri sʉsi do ni daya. ");
INSERT INTO muy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ɓesʉmi ana mis, grumi sulum ana tay akaɗa ga Bəŋ gekʉli ya eɓesey, agri sulum ana kʉli ni. » ");
INSERT INTO muy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","« Ŋgay mis ndahaŋ tàgudara zlam a ti kə̀ɗəmum ba ; tamal kəgrum nahkay ti lekʉlʉm day ŋgay kàgudaruma zlam a ti Melefit aməɗəm do. Ŋgay tə̂wəl mis ndahaŋ ti kə̀ɗəmum ba. Nahkay tə̂wəl kʉli ti Melefit day aməɗəm do bilegeni. Mbrəŋumfəŋa zlam ya mis ndahaŋ tàgudari ana kʉli ni kà tay a. Nahkay Melefit day aməmbərfəŋa zlam magudarani gekʉli ni kè kʉli a bilegeni. ");
INSERT INTO muy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vumi zlam ana mis ndahaŋ. Nahkay Melefit day aməvi zlam ana kʉli. Amazay darama, aməbəviyu zlam, aməjuk ti mə̂rəhvù zat adəgakia adəgakia, mək aməbiviyu ana kʉli a mbolu gekʉli vu. Aɗaba mam, darama ya ti lekʉlʉm kəgurumi zlam ana mis ndahaŋ àna naŋ ni ti Melefit day aməguri zlam àna naŋ ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kələŋ gani Yezu àhi ma ana tay keti àna ma *gozogul. Àɗəm : « Zal wuluf ti adafəŋa ahar kà zal wuluf nahaŋ a tata waw ? Tamal agray nahkay ti nday cecʉeni atədəgiyu e eviɗ vu do waw ? ");
INSERT INTO muy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Maslaŋa ya acahay zlam ni ti àtam bay ya ti acahi zlam ni do. Ay ku tamal maslaŋa ya acahay zlam ni àsər zlam kay faŋ do nəŋgu ni, ka ya ti àcaha zlam ya təɗəfiki na ɗek nahəma, tigi nday kala-kala ata bay ya acahi zlam ni. ");
INSERT INTO muy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","« Kamənjaləŋ ka cakwasl ya àniki ke eri ga wur ga muk ni, kə̀sərki ka damkoluk ya ànukki ke eri ni do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tamal kəhi ana wur ga muk ni : “Wur ga mmawa, mbrəŋ nəzukkia cakwasl ya ànukki ke eri na” ti, nak nakani kìpi damkoluk ya ànukki ke eri ni do ni ti kəzikia ahəmamam ? Nak bay ya aŋgah zlam magudarani gayaŋ ni ! Zəkia damkoluk ke eri gayak gayakana day. Akəzəkia ti ekipi divi lala mək akəzikia cakwasl ya àniki ke eri ga wur ga muk na. » ");
INSERT INTO muy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yezu àɗəm keti : « Məŋgəhaf sulumani, ewi bəza magədavani ti àbi. Məŋgəhaf magədavani ewi bəza sulumani ti àbi daya. ");
INSERT INTO muy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nahkay mis təsərkaba məŋgəhaf àna bəza gatayana. Tə̀difəŋ ahàr ana bəza ga *wəruv kà məŋgəhaf ya akaba adak ni do. Nahkay day tə̀difəŋ ahàr ana bəza ge enderendera kè mezlirgendʉ do. ");
INSERT INTO muy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mis sulumani azaya zlam sulumana a zlam maŋgahani sulumani ya àniviyu a məɓəruv bu ni, mis magədavani ti ni azaya zlam magədavana a zlam maŋgahani magədavani gayaŋ ba. Aɗaba pakama ya ti ahəraya a ma ge mis ba ni ti àsaɓikia ka məɓəruv a palam. » ");
INSERT INTO muy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yezu àɗəm keti : « Lekʉlʉm kəhumu : “Bay geli, Bay geli,” mək kə̀grum ere ye ti nə̀hi ana kʉli ni do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tamal mis àra afa goro a, ècia ma goro a mək agray ere ye ti nə̀hi ni ti, àzavu ata way ? ");
INSERT INTO muy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Àzavu ti ata mis ya àləm ahay gayaŋ lala ni. Wuɗaka àləm ti àsaba asak gana, èli zileŋ mək àfəkaɗkibiyu asak ga ahay ni ka akur. Nahkay ka ya ti yam àtamkibiya ka zalaka, àzlal ahay ni ti àgri araŋa ndo. Aɗaba mam, maslaŋa nani àləma ahay gayaŋ na lala. ");
INSERT INTO muy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ay tamal mis ècia ma goro a mək àgray ere ye ti nə̀hi ni do nahəma, àzavu ata mis ya àləm ahay gayaŋ, àsaba asak gana ndo ni. Nahkay ka ya ti yam àtamkibiya ka zalaka, àzlal ahay ni ti èmbeɗkaba hʉya. Ahay gani nani àmbəɗkaba besek-besek. » ");
INSERT INTO muy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ka sarta ya ti Yezu àhia ma na ɗek ana mis a àndava nahəma, àsləka òru a Kafarnahum. ");
INSERT INTO muy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eslini ti zal nahaŋ àbu, naŋ bay ga ndam slewja ga ndam *Rom. Eviɗi gayaŋ àbu, ay ti bay ga ndam slewja ni awayay naŋ dal-dal. A vaɗ nahaŋ eviɗi ni àra èɓesey do, awayay amət. ");
INSERT INTO muy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bay məgur ndam slewja ni àra ècia ma ya təɗəmki ka Yezu na ti àslərkibiyu gəɗákani ga ndam *Zʉde ndahaŋ ti tə̂gri kam-kam, mâra mâhəŋgariaba eviɗi gayaŋ na. ");
INSERT INTO muy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nday nakəŋ tàra tìnjikia ka Yezu a ti tàhəŋgalay naŋ dal-dal, tə̀ɗəm ahkado : « Àgəski kə̂gri ere ye ti èhindifʉka ni kwa, ");
INSERT INTO muy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","aɗaba awayay leli ndam Zʉde ni ; àləmi ahay geli ya mahəŋgalavù Melefit ni ana leli ti naŋ. » ");
INSERT INTO muy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yezu nakəŋ àra ècia pakama gatay na ti tàsləka akaba tay a. Tòru tìnjʉa a magam ga bay ga ndam slewja na wuɗak ti bay ga ndam slewja ni àslərkibiyu zləbəba gayaŋ ndahaŋ ga məhiani : « Bay goro, kə̀gribiyu daliya ana ahàr gayak ga marana ba, aɗaba nu mis ga marona afa goro a di do. ");
INSERT INTO muy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nu nuani day nə̀rəkukoru ndo ni ti aɗaba nə̀hi ana ahàr goro nìsli mərəkukani do. Ɗəmbiyu ma bəlaŋ ciliŋ, nahkay ti bay məgru tʉwi ni aŋgaba. ");
INSERT INTO muy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nu gani day tə̀bu təgur nu, nu day nə̀bu nəgur ndam slewja goro. Tamal nəhi ana bəlaŋ gatayani : “Ru !” ti, akoru. Tamal nəhi ana nahaŋ : “Ra !” ti ni, ara. Tamal nəhi ana bay məgru tʉwi : “Gray ere hini” ti, agray ere gani. » ");
INSERT INTO muy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yezu àra ècia ma ga bay ga ndam slewja ya tə̀həŋgribiyu na ti àgria ejep a dal-dal. Naŋ nakəŋ àmbatkibiyu ma ke mis dal-dalani ya taɗəbay naŋ ni tuwəli, àhi ana tay ahkado : « Nəhi ana kʉli nahəma, ɗay-ɗay nə̀di ahàr ana mis ya ti afəku ahàr akaɗa naŋ hini ni ndo. Ku e kiɗiŋ ga ndam *Izireyel bu day nə̀di ahàr ndo. » ");
INSERT INTO muy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nday ya tə̀slərkioru tay ka Yezu ni tàra tàsləkabiya nahəma, tə̀di ahàr ana eviɗi ga bay ni àŋgaba lala. ");
INSERT INTO muy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eslini Yezu òru a kəsa nahaŋ vu təzalay Nayiŋ. Naŋ àbu akoru ti ndam maɗəbay naŋ ni akaba mis dal-dal taɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ka ya ti ènjʉa ka ma ga kəsa na ti èpi tə̀bu təzoru mis e eviɗ vu ka slalah hʉya. Maslaŋa ya àmət ni ti wur mendʉlik ga wal madakway. Məŋ ga wur ni naŋ àbu akoru ke mindiviŋ, mis a kəsa bu kay taɗəboru naŋ. ");
INSERT INTO muy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bay geli àra èpia naŋ a ti àsia cicihi a àsaɓay, àhi ahkado : « Kìtʉwi ba. » ");
INSERT INTO muy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Eslini àhəɗakfəŋiyu kà tay, ènjifiŋ kà slalah ge kisim ni. Nahkay nday ya ti tàzay kisim ni tìcik, mək Yezu àhi ana kisim ni : « Wur dagwa, nəhuk nahəma, piɗekvu. » ");
INSERT INTO muy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yezu àra àhia nahkay ti mis ni èpiɗekvu, ànjəhaɗ digʉs, àdi ana mazlapani. Eslini Yezu àhi ana məŋ ga wur ni : « Ehi, za wur gayak a. » ");
INSERT INTO muy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mis ye eslini ni tàra tìpia ti tàgra aŋgwaz a àsaɓay, nahkay tàzləbay Melefit, tə̀ɗəm : « Bay mahəŋgaray *pakama ge Melefit gəɗakani àŋgazlava e kiɗiŋ geli ba. » Tə̀ɗəm keti : « Melefit àra ga mahəŋgay ndam gayaŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nahkay ti mis ya ka haɗ ga ndam *Zʉde ni ɗek akaba mis ya kà gəvay gatay ni ɗek tìcia ere ye ti Yezu àgray na. ");
INSERT INTO muy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ndam maɗəbay Zeŋ bay məbaray mis ni tàra tìcia ma na ti tə̀həŋgri ana Zeŋ, mək Zeŋ nakəŋ àzalay mis cʉ e kiɗiŋ ga ndam maɗəbay naŋ ni bu, ");
INSERT INTO muy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","àsləroru tay afa ga Bay geli. Àhi ana tay ahkado : « Humi ahkado : “Nak ti *Bay gəɗakani ya amara ni tək, day ti mâhətay maslaŋa nahaŋ aw ?” » ");
INSERT INTO muy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nahkay nday nakəŋ tàra tìnjikia ka Yezu a ti tə̀hi : « Zeŋ bay məbaray mis ni àslərbiyu leli afa gayak ti mə̂huk : “Nak ti Bay gəɗakani ya amara ni tək, day ti mâhətay maslaŋa nahaŋ aw ?” » ");
INSERT INTO muy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka sarta gani nani ti Yezu naŋ àbu ahəŋgaraba mis a kay ya tèɓesey do na akaba mis kay ya seteni tə̀niviyu ana tay na. Àhəlikaba eri ana ndam wuluf a kay daya. ");
INSERT INTO muy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kələŋ gani àhəŋgrifəŋ ana ndam ya Zeŋ àslərkibiyu tay ni. Àhi ana tay ahkado : « Dəgum kâŋgahaɗumi ana Zeŋ ere ye ti kìpʉm ni akaba ya kìcʉm ni. Humi ndam wuluf tə̀bu tipi divi, ndam dəra təsawaɗay lala, ndam ambələk tìgia mis njəlatana, ndam makwaya tici slimi, mis məmətani tàŋgaba ; ndam talaga day tìcia Ma Mʉweni Sulumana. ");
INSERT INTO muy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Humi keti : “Maslaŋa ya ti èjikia ke divi azuhva nu a do nahəma, mə̂mərvu.” » ");
INSERT INTO muy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndam ya ti Zeŋ àslərkibiyu tay ka Yezu ni tàra tàsləka ti Yezu àzlapaki ke Zeŋ, àhi ana mis dal-dalani ni ahkado : « Kə̀dəgum a huɗ gili vu ti ga mipibiyu mam ? Kìpʉmbiyu ti mavram ya aməɗ adaɗay ni tək ? ");
INSERT INTO muy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Do ni ti kə̀dəgum kìpʉmbiyu ti mam ? Mis məbakabu azana sulumani akaɗa ga bay ni tək ? Aha, ndam ya tabakabu azana ga siŋgu kayani akaba zlam gatay àbu kayani ni ti nday a ahay ga bəbay bu timey. ");
INSERT INTO muy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ay ti kə̀dəgum kìpʉmbiyu ti mam ? Kìpʉmbiyu bay mahəŋgaray *pakama ge Melefit aw ? Iy, naŋ gani. Nəhi ana kʉli nahəma, naŋ ti àtama bay mahəŋgaray pakama ge Melefit a. ");
INSERT INTO muy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kə̀səruma, àbu məbəkiani a Wakita ge Melefit bu, Melefit àhi ana Bay gəɗakani ya amara ni nahkay hi : “Nihi ti nu nə̀bu nəsləroru bay məslər goro nahaŋ kama gayak ti mâslamatukkabu divi.” « Maslaŋa ya ti Melefit àslərbiyu ni ti Zeŋ. ");
INSERT INTO muy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nəhi ana kʉli keti : Zeŋ ti àtama mis ya tìwi tay na ɗek àna gəɗakana. Ku tamal nahkay nəŋgu ni, bay ya ti naŋ gʉziteni ge mis ɗek a *Məgur ge Melefit bu ni ti àtama naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mis dal-dalani ni akaba ndam *məhəl hadam ni tə̀gəskabá ma ge Zeŋ na. Tə̀səra Melefit ti naŋ jireni, nahkay nday gani tàwaya ti Zeŋ *mə̂baray tay. ");
INSERT INTO muy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ay ti ndam *Feriziyeŋ akaba ndam *məsər Wakita ge Melefit ni tə̀gəskabu ere ya Melefit awayay avi ana tay ni ndo, nahkay tàwayay ti Zeŋ mə̂baray tay ndo. » ");
INSERT INTO muy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yezu àhi ana tay keti : « Mis ye e hini vu ni ti nəgurfəŋ tay kà way ? Nday akaɗa way ? ");
INSERT INTO muy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nəhi ana kʉli nahəma, nday akaɗa ga bəza manjəhaɗani e mite bu ni. Nday ndahaŋ təhi ana ndahaŋ ni ahkado : “Mìvia slelim ana kʉli a, day kə̀həɓumfəŋ ndo ; mìdia limis ge kisim ana kʉli a, day kìtʉwʉm ndo.” ");
INSERT INTO muy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nə̀ɗəm nahkay ti aɗaba Zeŋ bay məbaray mis ni àra. Àra ti àzum *dipeŋ do, èsi zum do. Nahkay lekʉlʉm kə̀ɗəmum seteni àniviyu. ");
INSERT INTO muy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nu *Wur ge Mis ti ni nàra. Nàra ti nu nə̀bu nəzum dipeŋ, nə̀bu nisi zum. Nahkay lekʉlʉm kə̀ɗəmum nu zal huɗ, nəvi vu goro ana zum. Kə̀ɗəmum nu zləba ga ndam *məhəl hadam akaba ga ndam magudar zlam ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ay ti ndam ya tə̀gəskabu məsər zlam ge Melefit ni ɗek tə̀səra Melefit àsəra zlam eɗeɗiŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Eslini zal *Feriziyeŋ nahaŋ slimi gayaŋ Simu àzaloru Yezu afa gani a magam ga məzumkabu zlam. Yezu òru ènjʉa ti àhuriyu a ahay vu, tə̀njəki ka məzum zlam. ");
INSERT INTO muy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wal hala nahaŋ àbu a kəsa gani nani bu. Àra ècia ti Yezu naŋ àvu azum zlam a ahay bu afa ga zal Feriziyeŋ ni ti àrəkioru àna tersel a kolombu sulumani bu. ");
INSERT INTO muy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Àra àhuriya a ahay ni va ti ècik kələŋ ga Yezu, kà gəvay ga asak gayaŋ, naŋ àbu etʉwi. Naŋ àbu etʉwi ti yam tuway gayaŋ ni àbara asak ga Yezu a cəraɗ, mək wal ni àtəmaɗkia yam tuway na àna məhər ga ahàr gayaŋ a ; kələŋ gani àfəki ma ka asak ga Yezu, mək àbəki tersel ni ka asak ni. ");
INSERT INTO muy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Zal Feriziyeŋ ya àzaloru Yezu afa gani ni àra èpia nahəma, àhi ana ahàr : « Naŋ hini ti bay mahəŋgaray *pakama ge Melefit do. Tamal naŋ bay mahəŋgaray pakama ge Melefit ti akal àsəra wal hini ya enjifiŋ ni ti naŋ wal hala. » ");
INSERT INTO muy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yezu àra àsəra ere ye ti naŋ ajalay a ahàr gayaŋ bu na ti àhi ahkado : « Simu, ma goro àbu nawayay nəhuk. » Simu nakəŋ àhi : « Ɗəm, mʉsi. » ");
INSERT INTO muy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Mək Yezu àhi : « Mis ndahaŋ cʉ tàkəla duwa afa ga zal nahaŋ a ; bəlaŋ gani àkəlay jik diŋ diŋ zlam, naŋ nahaŋ ni ti ni jik kru kru zlam. ");
INSERT INTO muy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nday cecʉeni siŋgu àfəŋ kà tay ga məpəliani bi nahəma, bay ga duwa ni àhi ana tay cʉeni : “Kə̀pəlumu duwa goro ni va ba.” » Yezu àhi ana Simu nakəŋ keti : « E kiɗiŋ gatay cʉeni ni bu ni ti way aməgri sʉsi kay ana bay ga duwa ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eslini Simu àhəŋgrifəŋ, àhi ahkado : « Nətamahay maslaŋa ya ti tə̀mbərfəŋ siŋgu kayani ni. » Yezu àhi : « Ma gayak ti jiri. » ");
INSERT INTO muy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Eslini Yezu àmbatkibiyu ma ka wal ni mək àhi ana Simu ahkado : « Kipi wal hini do aw ? Ka ya ti nàhəraya a ahay va afa gayak a ni ti kə̀cəhubiyu yam ga *məbaray asak ndo. Ay wal hini ti àbarua asak àna yam tuway a mək àtəmaɗkua àna məhər ga ahàr gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nak kə̀gru sa àna məfəku ma ka tuwər ndo. Ay ti wal ni kwa nàhəraya àmbrəŋ məfəku ma ka asak ndo. ");
INSERT INTO muy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nak kə̀gəskabu nu àna magraku amal ka ahàr ndo. Ay ti wal ni àbəkua tersel ka asak a. ");
INSERT INTO muy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nahkay nəhuk nahəma, àgrua sʉsi a kay, àwaya nu a kay, nani ɗek ti aɗafaki zlam magudarani gayaŋ kayani ni məmbərfəŋana. Ay ti maslaŋa ya ti zlam magudarani gayaŋ gʉzit mək tə̀mbərfəŋa ni ti àwayay bay ya àmbərfəŋa ni kay do. » ");
INSERT INTO muy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mək Yezu àhi ana wal ni : « Zlam magudarani gayak ni məmbərfukana. » ");
INSERT INTO muy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nday ya təzumkabu zlam akaba Yezu ni tàra tìcia ma gayaŋ na ti tə̀hi ana ahàr : « Way hini ku zlam magudarani ge mis nəŋgu ambərfəŋa ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Eslini Yezu àhi ana wal ni ahkado : « Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. Sləka àna sulumani gayaŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Yezu òru a kəsa gəɗákani akaba a kəsa ciɓ-ciɓeni vu, àcahi zlam ana mis, àhi *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit ana tay. Ndam maɗəbay naŋ kru mahar cʉeni ni tòru akaba naŋ, ");
INSERT INTO muy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","wál ndahaŋ day tòru akaba naŋ. Wál nday nani ti Yezu àgariaba seteni ana ndahaŋ e kiɗiŋ gatay ba, ndahaŋ ti ni àhəŋgaraba tay a arməwər ba. Slimi ga wál nday nani nday hi : bəlaŋani Mari ya təzalay Mari ga kəsa Magədala ni. Naŋ ti Yezu àgariaba seteni adəskəla. ");
INSERT INTO muy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nahaŋ ni Zeni wal ga Sʉza ; Sʉza gani nani zal asak ga bay *Erot. Nahaŋ ni ti ni Sʉzeŋ akaba wál nday ndahaŋ kay. Ka gani nani wál nday nani tə̀bu təjənaki ata Yezu akaba ndam gayaŋ kru mahar cʉeni ni àna elimeni gatay gatayani. ");
INSERT INTO muy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Eslini mis tàsləkabiya a kəsa gərgərani ba ɗek, tə̀rəkia ka Yezu a. Tàra tə̀cakalava ti Yezu àhi ma ana tay àna ma *gozogul. ");
INSERT INTO muy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Àhi ana tay ahkado : « Maslaŋa nahaŋ àhəraya òru e gili ga mabəhaɗ hilfi ga zlam. Naŋ àbu abəhaɗoru hilfi ga zlam ni ti ɓal gani àdəgoru e divi bu. Nahkay mis tə̀cəlki, eɗiɗiŋ day tə̀ndaba. ");
INSERT INTO muy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ɓal gani keti àdəgoru ka pəlaɗ ya haɗ àhəcaki ni, nahkay ka ya ti àfətaya nahəma, àhəraba aɗaba yam àhəci. ");
INSERT INTO muy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ɓal gani keti àdəgiyu a adak vu. Ka ya ti àfətaya, àbu aɗək nahəma, adak ni tèŋgecekabá. ");
INSERT INTO muy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɓal gani keti àdəgoru ka haɗ sulumani. Àra àfətaya ti àbi bəza. Ku ahàr gani bəlaŋ tekeɗi bəza agray diŋ. » Yezu àra àhia ma na ana tay a nahkay ti àzlacay, àɗəm : « Maslaŋa ya ti slimi àfəŋ ge mici zlam nahəma, mîci lala ! » ");
INSERT INTO muy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ndam maɗəbay Yezu ni tə̀hi ahkado : « Ɗəfiaba ma *gozogul na ana leli a. Awayay aɗəmvaba mam ? » ");
INSERT INTO muy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Lekʉlʉm ti Melefit àɗəfikiaba zlam maŋgahani àki ka Məgur gayaŋ na ana kʉli a, ti kə̂sərum. Ana mis ndahaŋ ti àɗəfikiaba ana tay a vay-vay ndo. Àhi ana tay àna ma gozogul ciliŋ. Melefit àgray nahkay ti “Ku tamal tamənjaləŋ ka zlam nəŋgu ni, tìpi ba ; ku tamal təbi slimi ana pakama nəŋgu ni tìci ba.”  » ");
INSERT INTO muy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yezu àhi ana tay keti : « Ma *gozogul ni awayay aɗəmvaba ti nahkay hi : hilfi ga zlam ya tàbəhaɗ ni, àzavu akaba pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mis ndahaŋ tə̀bu, nday akaɗa divi ya ti hilfi ga zlam àdəgaki ni : tìcia pakama ge Melefit a, ay *Seteni ara ahəliaba pakama nana ana tay a ahàr ba. Awayay ti tə̀fəki ahàr ke Melefit ba. Aɗaba tamal təfəki ahàr ke Melefit ti Melefit ahəŋgay tay. ");
INSERT INTO muy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mis ndahaŋ day tə̀bu, nday akaɗa pəlaɗ ya ti hilfi ga zlam àdəgaki ni : tìcia pakama ge Melefit na ti təgəskabu àna məmərani. Ay pakama nani àhuriviyu ana tay a məɓəruv vu do, akaɗa ge sliri ya ti tòru a haɗ vu do ni. Nahkay ti təfəki ahàr ke Melefit ga hayaŋani ciliŋ. Ka ya ti tìcia zləzlaɗana ti təmbrəŋ, tə̀fəki ahàr va do hʉya. ");
INSERT INTO muy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mis ndahaŋ tə̀bu, nday akaɗa hilfi ga zlam ya ti àdiyu a huɗ ga adak vu ni : tìcia pakama ge Melefit a ti təgəskabu. Ay ku tamal tə̀gəskabá nəŋgu ni, majalay ahàr kay ariva ana tay a, təjalaki ahàr ke elimeni akaba zlam ndahaŋ ya tigi eri ni. Zlam nday nani teŋgecekabu zlam akaɗa ga adak ni ; ndam nday nani tə̀bu akaɗa ga zlam ya àbia bəza ti bəza gani tə̀ndəh ndo ni. ");
INSERT INTO muy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hilfi ga zlam ya àdəgoru ka haɗ sulumani ni tə̀zavu akaba mis ya məɓəruv gatay sulumani, tawayay Melefit ni. Nday gani tìcia ma ge Melefit na ti àgəjazlki ahàr ka tay do. Nahkay takoru àna naŋ kama kama, tə̀mbrəŋ do, tagray zlam sulumani akaɗa ga zlam ya ti abi bəza ni. » ");
INSERT INTO muy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yezu àhi ana tay keti : « Maslaŋa ya ti ebeftey ceŋgel ti ahəmbaki mandaray, ahkay do ni afiyu a zuh slalah vu ni ti àbi. Afəkaɗ ka məlaŋ zaŋani sawaŋ, aɗaba awayay ti ndam ya təhuriyu a ahay vu ni tipi maslaɗay ge ceŋgel ni. ");
INSERT INTO muy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nə̀ɗəm nahkay ti aɗaba zlam ya ti maŋgahani ni ɗek amaŋgazlavu, zlam ya ti maɗafani faŋ do ni ɗek emicivu vay-vay daya. ");
INSERT INTO muy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nahkay bumi slimi lala ahəmamam ti kicʉm pakama ni. Aɗaba maslaŋa ya ti zlam gayaŋ àbu ni ti atəvikivu. Ay maslaŋa ya ti zlam gayaŋ àbi nahəma, ku zlam gʉziteni ya ti àɗəm àŋgəta ni day atəzafəŋa. » ");
INSERT INTO muy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Eslini ata məŋ ga Yezu akaba bəza ga məŋ ga Yezu tə̀rəkia ka Yezu a. Tàra tìnjia ti tìsliki mərəkiani disl koksah aɗaba mis tə̀vu ka məlaŋ gani nani dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nahkay mis tə̀hikabiyu ma, tə̀hi : « Ata muk akaba bəza ga muk tə̀bu e mite bu, tihindi kur. » ");
INSERT INTO muy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yezu nakəŋ àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Mmawa akaba bəza ga mmawa nahəma, nday ya ti təbi slimi ana pakama ge Melefit, mək tagray tʉwi àna naŋ ni. » ");
INSERT INTO muy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","A vaɗ nahaŋ Yezu àcəliyu a *slalah ga yam vu akaba ndam maɗəbay naŋ ni, àhi ana tay : « Tokumum, mədəgum gwar ke ledi ga dəluv ni. » Nahkay nday nakəŋ tàsləka. ");
INSERT INTO muy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nday tə̀bu takoru ti Yezu àdiya e ɗʉwir va ɗaŋ. Ka ya ti naŋ àvu e ɗʉwir bu ni ti aməɗ gəɗakani àkəzlabiyu ka ahàr ga yam ni, mək yam ni àjaɓasliyu a slalah ga yam ni vu, awayay arəhvù wuɗak, nahkay gʉzit akal tizi kəɗap. ");
INSERT INTO muy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eslini ndam maɗəbay naŋ ni tàhəɗakfəŋiyu, tèpiɗek naŋ, tə̀hi : « Gəɗakani, gəɗakani, mə̀bu miji timey ! » Yezu nakəŋ àra èpiɗekva ti àzlacaki ka aməɗ ni akaba ka yam ya ti acəloru agavəla ni ɓəra. Àra azlaca nahkay ti aməɗ ni àmbrəŋ makəzlani, yam ni day àmbrəŋ madaɗani, yam ni ègia ɗegika. ");
INSERT INTO muy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yam ni àra ègia ɗegika ti Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Kə̀fumku ahàr do ni ti ahəmamam ? » Ndam maɗəbay naŋ ni aŋgwaz àwəra tay a dal-dal, aɗaba ere ye ti tìpi ni àgria ejep ana tay a àsaɓay. Tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Naŋ hini ti way ? Aməɗ akaba yam day àhi ma ana tay, ticiiki slimi ni ! » ");
INSERT INTO muy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nday nakəŋ tìnjiyu ke ledi ga dəluv ni. Ledi nani ka haɗ Zerasa, ndeva ndeva akaba haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","28","Zal nahaŋ àbu ga kəsa nani ; seteni tə̀niviyu a ahàr vu, àpəsa àbakabu zlam ndo, àndəhaɗ a ahay bu ndo daya. Məlaŋ gayaŋ ti e kiɗiŋ ge mindiviŋ bu. Àra èpia Yezu naŋ àbu ahəraya a *slalah ga yam ni ba ni ti àzlah kay kay, àrəkia. Àra ènjikia ti àbəhaɗi mirdim, àdəɗ kè meleher gayaŋ. Àhi àna zlahay ahkado : « Nak Yezu Wur ge Melefit naŋ agavəla driŋ ti kaɗəbafua mam ? Nəgruk kam-kam, kə̀gru daliya ba ti. » ");
INSERT INTO muy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Àɗəm nahkay ti aɗaba Yezu àhi ana seteni ni : « Həraya a maslaŋa hini ba. » Zal nani ti kwa ahaslani seteni ni àgray naŋ sak kay. Ka ya ti naŋ àbu agray naŋ ni ti mis tə̀wəla àna jejirɓi a, tə̀biviya sisel a asak va akaba tàjəga naŋ a. Akaba nani ɗek ètiri ndo, èheɓkaba zlam ya tə̀wəl naŋ àna naŋ na, mək seteni ni àzoru naŋ a huɗ gili vu. ");
INSERT INTO muy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zal seteni ni àra àhia ana Yezu a « Kə̀gru daliya ba » ti Yezu àhi : « Slimi gayak way ? » Àhi : « Slimi goro Gaslka. » Àɗəm nahkay ti aɗaba seteni tə̀niviyu kay. ");
INSERT INTO muy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eslini seteni nday nani tə̀bu təgri kam-kam ana Yezu, tə̀hi : « Kə̀garoru leli e *eviɗ gəɗakani vu ba ti. » ");
INSERT INTO muy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mədrə́s tə̀bu kay təzum zlam ka ahar bəlaŋ a həma bu. Nahkay seteni ni tə̀hi ana Yezu : « Kam-kam, mə̂huriviyu ana mədrə́s tegʉni ti. » Mək Yezu nakəŋ àvi divi gani ana tay. ");
INSERT INTO muy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yezu àra àvia divi gana ana tay a ti seteni ni tə̀sləkiaba ana zal nakəŋ a, tə̀cəlivù a ahàr vu ana mədrə́s ni. Nahkay mədrə́s ni ɗek tə̀ndaya ahàr a kirim-kirim, tàra tə̀dəguyu a dəluv ni vu cizliv cizliv, mək yam ni àbazla tay a. ");
INSERT INTO muy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ndam majəgay mədrə́s ni tàra tìpia ere ye ti àgravu na ti tə̀dəgiki ana hwa tiɗizl, tàŋgəhaɗioru ma gani ana ndam ya a kəsa bu ni akaba nday ya ti e gili ni. ");
INSERT INTO muy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mis tàra tìcia ma na ti tàhəraya ge mipi ere ye ti àgravu na, tə̀rəkia ka Yezu a. Tàra tìnjia ti tìpi zal ya ti seteni tə̀sləkiaba ni, àŋgaba ègia sulumana, naŋ manjəhaɗani digʉsa kà gəvay ga asak ga Yezu, məbakabu azana gayaŋ ka vu. Tàra tìpia naŋ a ti aŋgwaz àdəgakia ka tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Eslini mis tə̀bu, tìpia ga Yezu ya àhəŋgaraba zal ya seteni tə̀niviyu na, tàŋgəhaɗi ma gani ana mis ya tàra ni. ");
INSERT INTO muy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndam ga haɗ Zerasa ɗek tàra tìcia ma gani nana ti tə̀hi ana Yezu mâsləka ka haɗ gatay a, aɗaba aŋgwaz àdəgakia ka tay a àsaɓay. Nahkay Yezu àhuriyu a slalah ga yam ni vu, awayay asləka. ");
INSERT INTO muy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Eslini zal ya ti seteni tə̀sləkiaba ni àhi ahkado : « Naɗəboru kur ti. » Yezu àhi : « Aha ! Sləka, ");
INSERT INTO muy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ŋgoru a magam gayak, kâru kâŋgəhaɗi ere ye ti Melefit àgruk ni ɗek ana mis. » Nahkay zal nakəŋ àsləka, òru àŋgəhaɗi ere ye ti Yezu àgri ni ɗek ana ndam ga kəsa ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yezu àŋgoru gwar ke ledi ga dəluv ni akaba ndam maɗəbay naŋ ni. Tòru tìnjʉa ti mis dal-dal tə̀gəskabá Yezu àna məmərana, aɗaba nday ɗek tə̀bu tajəgay naŋ. ");
INSERT INTO muy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Eslini zal nahaŋ naŋ àbu, slimi gayaŋ Zayros, naŋ gəɗakani ga ahay ga *mahəŋgalavù Melefit, àrəkia ka Yezu a, àbəhaɗi mirdim grik meleher ndiɓ ana haɗ kà asak ga Yezu. Àhəŋgalay naŋ, àhi môru a magam afa gani, ");
INSERT INTO muy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","aɗaba wur gayaŋ awayay amət. Wur nani ti wur dahalay, vi gayaŋ agray kru mahar cʉ. Zal nani ti wur gayaŋ nahaŋ àbi. Yezu naŋ àbu akoru afa gani ti mis dal-dalani ni tèveliŋia ahàr a, məsufani tekeɗi àsuf koksah. ");
INSERT INTO muy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Eslini wal nahaŋ àbu, mimiz asləkafəŋa agray vi kru mahar cʉ. Ègwejelekaba zlam gayaŋ a ɗek afa ga ndam məsər haf a ay ti maslaŋa bəlaŋ èsliki mahəŋgaraba naŋ a ndo. ");
INSERT INTO muy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nahkay wal ni àhəɗakfəŋbiyu kà Yezu gwar kələŋ, ènjifiŋ kà ma ga azana gayaŋ. Àra ènjifiŋa ti mimiz ya asləkafəŋa ni àmbrəŋ naŋ, wal ni àŋgaba hʉya. ");
INSERT INTO muy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eslini Yezu àɗəm : « Way ènjifu way ? » Ku way way do àɗəm : « Nu do, » mək Piyer àhəŋgrifəŋ, àhi ahkado : « Gəɗakani, mis ni damkulkul timey ! » ");
INSERT INTO muy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yezu àɗəm : « Aha ! Mis ènjifua, aɗaba nə̀səra njəɗa goro àhəŋgaraba maslaŋa. » ");
INSERT INTO muy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wal ni àra àsərkia àɓu koksah nahəma, àrəkia ka Yezu a àna məgəgərani slaɓ slaɓ, àbəhaɗi mirdim meleher ndiɓ ana haɗ, àŋgəhaɗaya ere ye ti àzəkiyu naŋ ti mînjifiŋ kà azana ga Yezu ni kè meleher ge mis na ɗek. Àŋgəhaɗiaya gayaŋ ya àŋgaba hʉya ni ana tay a daya. ");
INSERT INTO muy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Eslini Yezu àhi ahkado : « Wur goro ni, Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. Sləka, ru àna sulumani. » ");
INSERT INTO muy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti maslaŋa nahaŋ ènjia. Maslaŋa gani nani àsləkabiya afa ga gəɗakani ga ahay ga mahəŋgalavù Melefit na, àhi : « Wur gayak nakəŋ èndeverva. Kìwisiri ahàr ana mʉsi va ba. » ");
INSERT INTO muy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yezu àra ècia ma nana ti àhi ana Zayros ahkado : « Aŋgwaz àwər kur ba, fəku ahàr ciliŋ, Melefit amahəŋgaraba naŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nahkay tòru afa ga Zayros nakəŋ. Yezu òru ènjʉa ti àcafəŋa mis a ɗek ga məhuriyani a ahay vu akaba naŋ a. Àvi divi ana ata Piyer, Zeŋ, Zek akaba bəŋ ga wur ni ata məŋ ga wur ni ga məhuriyani akaba naŋ ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mis ya tə̀bu eslini ni ɗek tə̀bu tagray delʉlʉ, titʉwi wur ni. Ay ti Yezu àhi ana tay ahkado : « Kìtʉwʉm ba. Wur ni àmət ndo, naŋ àbu enji ɗʉwir timey. » ");
INSERT INTO muy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Àra àhia pakama ana tay a nahkay ti tèyefiŋ, aɗaba tə̀səra wur na àməta àndava. ");
INSERT INTO muy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eslini Yezu àzay ahar ga wur ni, àzalay naŋ, àhi : « Wur goro ni, piɗekvu. » ");
INSERT INTO muy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Àra àzala wur na nahkay ti sifa àŋgiva ana wur na mək ècik cəkwaɗ hʉya. Eslini Yezu àhi ana tay tə̂vi zlam məzumani. ");
INSERT INTO muy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ere ye ti àgravu ni àgria ejep ana ata bəŋ ga wur nday ata məŋ ga wur na àsaɓay. Ay Yezu àhi ana tay : « Kə̀humi ma gani ana maslaŋa ba. » ");
INSERT INTO muy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A vaɗ nahaŋ Yezu àzalakabu ndam gayaŋ kru mahar cʉeni ni, àvi njəɗa ana tay ga misliki magariaba seteni weley weley do ɗek ana mis a akaba ga mahəŋgaraba mis a. ");
INSERT INTO muy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Awayay asləroru tay ga məhi pakama ana mis àki ka *Məgur ge Melefit akaba ga mahəŋgaraba ndam ga arməwər a. ");
INSERT INTO muy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Àhi ana tay ahkado : « Kədəgum nihi nahəma, kə̀zum zlam a ahar vu ba ; ku aday, ku mbolu, ku zlam məzumani, ku siŋgu. Kə̀həlum endʉwi cʉ cʉ ba daya. ");
INSERT INTO muy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ay tamal maslaŋa àhəliya kʉli a ahay va afa gana nahəma, njəhaɗuma eslina ; kàmbatum ahay nahaŋ ba duk abivoru ana vaɗ gekʉli ya akəsləkuma ni. ");
INSERT INTO muy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka məlaŋ ya ti akəhurumiyu, tə̀gəskabu kʉli do nahəma, sləkumaba a kəsa nani ba. Ka ya ti kəsləkuma ni ti təkumkaba haɗ kà asak gekʉli a. Nahkay ti atəsərki ka magudar zlam gatay ni. » ");
INSERT INTO muy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nday nakəŋ tə̀həlvu, tàsləka tə̀hioru *Ma Mʉweni Sulumani ana mis a kəsa gərgərani bu ɗek ; tàhəŋgaraba ndam ga arməwər a ka məlaŋ ya ti tòru na ɗek. ");
INSERT INTO muy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erot bay Gelili ni àra ècia pakama ge mis ya ti tə̀ɗəmki ka Yezu na ɗek ti àhəlia ahàr a, aɗaba mis ndahaŋ tə̀ɗəm Yezu ti naŋ Zeŋ bay məbaray mis ni, àŋgaba e kisim ba. ");
INSERT INTO muy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mis ndahaŋ ti ni tə̀ɗəm Eli bay mahəŋgaray *pakama ge Melefit ni àŋgazlavu. Mis ndahaŋ keti tə̀ɗəm naŋ biliŋ ga ndam ya tàhəŋgaray pakama ge Melefit ahaslani ni, àŋgaba e kisim ba. ");
INSERT INTO muy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eslini Erot zla ti àɗəm ahkado : « Nèkelkia ahàr ke Zeŋ a, ay ti maslaŋa ya ti nici təzlapaki ni ti nani way ? » Nahkay ti awayay mîpi Yezu. ");
INSERT INTO muy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A vaɗ nahaŋ ndam *asak ga Yezu ni tàsləkabiya ka məlaŋ ya Yezu àsləroru tay na. Tàra tàsləkabiya ti tàŋgəhaɗiaba ere ye ti tàgrabiyu na ɗek. Eslini Yezu nakəŋ àhəl tay ka ahàr gatay ciliŋ, tòru gwar a kəsa nahaŋ vu ; slimi ga kəsa ni Beceyda. ");
INSERT INTO muy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mis dal-dalani ni tàra tìcia Yezu àdoru a Beceyda ti tàɗəboru naŋ a asak vu. Tàra tìnjikia ka Yezu a ti Yezu nakəŋ àgəskabu tay, àzlapiki ka Məgur ge Melefit ana tay, àhəŋgaraba ndam ya tèɓesey do na daya. ");
INSERT INTO muy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Fat àra àndəhaɗa ahàr a zla nahəma, ndam maɗəbay naŋ kru mahar cʉeni ni tàhəɗakfəŋiyu, tə̀hi ahkado : « Hi ana mis ni ɗek tâsləka, tôru a kəsa gərgərani ni vu ahkay do ni tôru a ahay ge mis ye e gili ni vu, tâɗəboru zlam məzumani akaba məlaŋ mandəhaɗani, aɗaba ahalay ti leli a huɗ gili bu. » ");
INSERT INTO muy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eslini Yezu àhəŋgrifəŋ ana tay, àɗəm : « Lekʉlʉm lekʉlʉmeni vumi zlam məzumani ana tay. » Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « *Dipeŋ àfəŋ kè leli zlam tàkivu kilif cʉ ciliŋ. Kawayay ti môru mə̂sukumibiyu zlam məzumani ana mis ɗekeni hini aw ? » ");
INSERT INTO muy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Mis zawalani ye eslini ni agray dəbu zlam. Yezu nakəŋ àhi ana ndam maɗəbay naŋ ni : « Humi ana mis ni ti tânjəhaɗa njəlukluk kru kru zlam, kru kru zlam. » ");
INSERT INTO muy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ndam maɗəbay naŋ ni tàgray ere ye ti naŋ àhi ana tay ni. Nahkay mis ni tànjəhaɗkabu njəlukluk. ");
INSERT INTO muy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Eslini Yezu nakəŋ àhəl dipeŋ zlamani tàkivu kilif cʉeni ni, àmənjoru e melefit vu, àgri sʉsi ana Melefit àki ka zlam məzumani nday nani. Àra àgria sʉsi a ti èsekaba, àbi ana ndam maɗəbay naŋ ni ti tîdi ana mis dal-dalani ni. ");
INSERT INTO muy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mis ni ɗek tə̀zum tə̀zum, tə̀rəhkaba. Kələŋ gani tə̀cakalakabu məgəjəni gani, tə̀rəhvù hətək kru mahar cʉ àna naŋ. ");
INSERT INTO muy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A vaɗ nahaŋ Yezu naŋ àbu cak, ahəŋgalay Melefit. Ndam maɗəbay naŋ ni day tə̀bu eslini. Yezu èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Mis dal-dalani ya taɗəbay nu ni ti tə̀ɗəm nu ti nu way ? » ");
INSERT INTO muy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Mis ndahaŋ tə̀ɗəm nak Zeŋ bay məbaray mis ni, mis ndahaŋ tə̀ɗəm nak Eli, mis ndahaŋ ti ni tə̀ɗəm nak biliŋ ga ndam ya tàhəŋgaray pakama ge Melefit ahaslani ni, àŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eslini naŋ nakəŋ àhi ana tay keti : « Lekʉlʉm ti kəɗəmum nu ti nu way ? » Piyer àhəŋgrifəŋ, àhi ahkado : « Nak *Krist *Bay gəɗakani ya Melefit àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yezu àra ècia ma ge Piyer na ti àhi ma ana tay àna ləgay, àɗəm ahkado : « Iy nahkay. Ay ti kə̀ɗəfumi nu ana maslaŋa ba simiteni. » ");
INSERT INTO muy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Àhi ana tay keti : « Ahàr àɗəm nu *Wur ge Mis ti nə̂cakay daliya dal-dal. Nday gəɗákani ni, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni atawayay nu do, atakaɗ nu. Mək a huɗ ga vaɗ mahkərani bu anaŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Eslini àhi ana tay ɗek ahkado : « Tamal mis awayay maɗəbay nu nahəma, ahàr àɗəm mə̂mbrəŋ ere ye ti awayay ni, ku tamal təgri daliya kəlavaɗ, *tadarfəŋ naŋ kà təndal nəŋgu ni mîɓesey. Tamal mis awayay maɗəbay nu ti mâgray nahkay. ");
INSERT INTO muy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maslaŋa ya ti àɗəm ajəgur sifa gayaŋ, awayay àmət ba ni ti emijiŋ. Maslaŋa ya ti emijiŋ sifa gayaŋ azuhva nu ti aməjəgur sawaŋ, aməmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tamal mis àŋgəta elimeni ga duniya na ɗek mək èjiŋa ahàr gayaŋ a ti elimeni gani aziaya mam ? ");
INSERT INTO muy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nu Wur ge Mis ti anara àna njəɗa goro a, ga Baba goro a, akaba ga *məslər gayaŋ *njəlatani na. Tamal maslaŋa aŋgwaz awər naŋ, aɗəm naŋ mis goro do, àsər pakama goro do nahəma, nu Wur ge Mis day ka ya ti anara ni anəɗəm naŋ mis goro do. » ");
INSERT INTO muy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Àhi ana tay keti : « Nəhi ana kʉli nahəma, e kiɗiŋ ge mis ya tə̀bu ahalay ni bu ni ti, wuɗaka ndahaŋ atəmət ti etipia *Məgur ge Melefit a day kwa. » ");
INSERT INTO muy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Agray gosku sekw ka ahàr ga pakama gayaŋ ya àɗəm ni zla ti Yezu àzay Piyer, Zek akaba Zeŋ, tə̀cəloru a həma vu ga mahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ka ya ti naŋ àbu ahəŋgalay Melefit nahəma, eri gayaŋ ni àmbatvu nahaŋ, azana ka vu gayaŋ day tìgia bəɗ-bəɗ talla, ahəlaba eri a vərut. ");
INSERT INTO muy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Eslini hʉya mis ndahaŋ cʉ tə̀bu təzlapay akaba Yezu, nday nani ata Mʉwiz nday ata Eli. ");
INSERT INTO muy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nday tə̀bu tipivu a maslaɗani ge Melefit bu. Təzlapaki ka məmət ga Yezu ya amoru məmət a Zerʉzalem ge mendeveriŋ tʉwi ya Melefit àvi ni. ");
INSERT INTO muy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nday tə̀bu təzlapay nahkay ti ata Piyer ti ni ɗʉwir àza tay a. Tàra tèpiɗekva ti tìpi maslaɗani ga Yezu akaba mis cʉeni micikeni akaba naŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka ya ti ata Mʉwiz nday ata Eli tə̀bu tasləkafəŋa kà Yezu a nahəma, Piyer àhi ana Yezu : « Gəɗakani, leli mə̀bu ahalay ti àɓəlay. Mara mivicey ahay mahkər : bəlaŋ gayak, bəlaŋ ge Mʉwiz, bəlaŋ ti ni ge Eli. » Àɗəm nahkay ti aɗaba àsər ere ye ti àɗəm ni do. ");
INSERT INTO muy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piyer naŋ àbu azlapay nahkay ti məguduŋguduŋ àhərkiaya ka tay a, àŋgah tay. Ka ya ti məguduŋguduŋ ni àhərkiaya ka tay a ni ti ndam *maɗəbay Yezu mahkərani ni aŋgwaz àdəgakia ka tay a. ");
INSERT INTO muy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dəŋgu ga maslaŋa àhənday a məguduŋguduŋ ni bu, àɗəm : « Naŋ hini ti wur goro, nə̀daba naŋ ga məgru tʉwi a. Gəsumiki pakama. » ");
INSERT INTO muy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Dəŋgu ni àra àhənday va do ni ti tìpi Yezu naŋ bəlaŋ ka ahàr gayaŋ. Ka gani nani nahəma, ndam maɗəbay Yezu mahkərani ni tànjəhaɗa àna ma gana te-te a, tə̀hi ana maslaŋa ndo. ");
INSERT INTO muy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hajəŋ gani Yezu akaba ndam maɗəbay naŋ mahkərani ni tə̀ndaya ahàr a həma ni ba. Tàra tàhəraya ti mis dal-dal tə̀rəkia ka Yezu a. ");
INSERT INTO muy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E kiɗiŋ ge mis dal-dalani ni bu ni ti zal nahaŋ naŋ àvu, àzlah, àɗəm : « Mʉsi, kam-kam nahəŋgalay kur, mənjuki ka wur goro ni ti aɗaba wur goro nahaŋ àbi. ");
INSERT INTO muy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Seteni àniviyu a ahàr bu, agəs naŋ, azlah hʉya, adaɗay naŋ kay kay, guzləbuc krup-krup a ma bu. Àgəsa naŋ a ti agri daliya dal-dal, àmbrəŋ naŋ weceweci do. ");
INSERT INTO muy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nàhəŋgala ndam maɗəbay kur na ti tâgariaba, ay ti tìsliki ndo. » ");
INSERT INTO muy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eslini Yezu àɗəm : « Lekʉlʉm ye e hini vu ni ti kə̀fumki ahàr ke Melefit do, lekʉlʉm ndam magudar zlam ! Nu ananjəhaɗ akaba kʉli kaŋgaya waw ? Nu eneɓesi ana kʉli kaŋgaya waw ? » Mək àhi ana bəŋ ga wur ni : « Zəbiya wur na ahalay a. » ");
INSERT INTO muy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wur ni naŋ àbu arəkia ka Yezu a ti seteni ni àdi naŋ ana məlaŋ, àdaɗay naŋ kay kay. Eslini Yezu àzlacaki ke seteni ni, àgariaba ana wur na, mək àvi wur ni ana bəŋani ni. ");
INSERT INTO muy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mis ye eslini ni tàra tìpia ti njəɗa ge Melefit àgria ejep ana tay a dal-dal, aɗaba njəɗa gani nani àtama zlam ndahaŋ a ɗek. Ere ye ti àgray ni ɗek àra àgria ejep ana mis na ɗek, nday tə̀bu təzlapaki kekileŋa ti Yezu àhi ana ndam maɗəbay naŋ ni : ");
INSERT INTO muy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","« Nawayay nəziaba azay slimi ana kʉli a, cʉm lala, àgəjazlki ahàr ke kʉli ba. Atəɗəfiki nu *Wur ge Mis ana mis ti tara təgəs nu. » ");
INSERT INTO muy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pakama ga Yezu ya àɗəm ni ti ndam maɗəbay naŋ ni tìciaba ndo. Huɗ ga ma gani nani ti maŋgahkiani ka tay, ti tìciaba ba. Ay aŋgwaz àgrafəŋa tay ge mihindifiŋa ma na. ");
INSERT INTO muy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A vaɗ nahaŋ ndam *maɗəbay Yezu ni tə̀bu tagray gejewi. Tə̀ɗəm ahkado : « E kiɗiŋ geli bu ni ti way gəɗakani àtam mis ndahaŋ ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yezu àra àsəra majalay ahàr gatay na ti àzay wur gʉziteni, àfəkaɗ kà gəvay gayaŋ, ");
INSERT INTO muy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","mək àhi ana tay : « Tamal ti maslaŋa àgəskabá wur hina azuhva nu a nahəma, àgəskabá nu a daya. Tamal ti maslaŋa àgəskabá nu a nahəma, àgəskabá Bay ya ti àslərbiyu nu na daya. Nahkay bay ya ti naŋ gʉziteni e kiɗiŋ gekʉli bu ɗek, èsli mis ndahaŋ ni do ni ti naŋ nani gəɗakani sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eslini Zeŋ àzlapay, àhi ana Yezu ahkado : « Gəɗakani, mìpia maslaŋa nahaŋ a, àgariaba seteni ana mis àna slimi gayak a, nahkay mə̀ɗəm macafəŋa naŋ a, aɗaba naŋ mis geli do. » ");
INSERT INTO muy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ay ti Yezu àɗəm : « Kə̀cumfəŋa naŋ a ba, aɗaba maslaŋa ya ti àwayay magudar tʉwi gekʉli do nahəma, agriki tʉwi ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Sarta ga Yezu ènjia ga morona e melefit vu wuɗak nahəma, àzay divi ga moroni a Zerʉzalem, àɗəm ere ye ti acafəŋa naŋ ga morona ni ti àbi. ");
INSERT INTO muy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nahkay àsləroru mis kama gayaŋ gwar ka haɗ Samari. Nday tə̀bu ka ahàr divi ti tə̀huriyu a kəsa nahaŋ vu ga maslamalikabu məlaŋ. ");
INSERT INTO muy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ay ndam ga kəsa nani tàwayay məgəskabu naŋ do, aɗaba tìcia naŋ àbu akoru a Zerʉzalem palam. ");
INSERT INTO muy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ndam maɗəbay naŋ ata Zek, Zeŋ tàra tìcia pakama nana ti tə̀hi ana Yezu : « Bay geli, kawayay ti mə̂hi ana aku ti mâdaya e melefit ba, mə̂zumaba tay a waw ? » ");
INSERT INTO muy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yezu àra ècia pakama gatay na ti àmbatkibiyu ma ka tay, àləgi ana tay. ");
INSERT INTO muy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mək tàzay divi ga moroni a kəsa nahaŋ vu. ");
INSERT INTO muy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yezu akaba ndam maɗəbay naŋ ni tə̀bu takoru e divi bu nahəma, zal nahaŋ àrəkia ka Yezu a, àhi ahkado : « Ka məlaŋ ya akoru ni ɗek ti anaɗəboru kur. » ");
INSERT INTO muy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yezu àhəŋgrifəŋ, àhi ahkado : « Mbiki tə̀bu àna eviɗ gatay, eɗiɗiŋ day tə̀bu àna lala gatay, ay nu *Wur ge Mis ti nə̀bi àna məlaŋ mandəhaɗani bi. » ");
INSERT INTO muy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yezu àhi ana maslaŋa nahaŋ : « Ɗəbabiyu nu. » Maslaŋa nani àhəŋgrifəŋ, àhi : « Bay goro, vu divi nakoru nilibiya baba goro a day. » ");
INSERT INTO muy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eslini Yezu àhi : « Ndam ya tàwayay maɗəbay nu do ni ti nday akaɗa kisim. Nahkay mbrəŋ tay ti tîli vu gatay. Nak ti ru kə̀hi ma ga *Məgur ge Melefit ana mis sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Maslaŋa nahaŋ keti àhi ana Yezu : « Naɗəbay kur, Bay goro ni. Ay ti vu divi nakoru nəgria sa ana ndam ga huɗ ahay goro a day. » ");
INSERT INTO muy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yezu àɗəm : « Maslaŋa ya ti awayay agray tʉwi ga Məgur ge Melefit mək ajalaki ahàr ka zlam ndahaŋ ni ti naŋ akaɗa bay ya ti atəhaɗ vədaŋ àna sla mək amənjoru kələŋ ni. Maslaŋa nani ti àgray tʉwi ga Məgur ge Melefit koksah. » ");
INSERT INTO muy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Bay geli àday mis ndahaŋ kru kru adəskəla mahar cʉ, awayay asləroru tay cʉ cʉ ti tôru enji gayaŋ a kəsa vu ka məlaŋ ya naŋ amoru ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Àhi ana tay : « Mis ya ti tìci pakama goro faŋ ndo ni nday kay, nday akaɗa ga zlam ya ti tabaz zlam a vədaŋ bu ni, ay ti ndam mabaz zlam ni tə̀bi kay bi. Nahkay si kahəŋgalum Melefit Bay ga vədaŋ ni ti mə̂slərbiyu ndam mabaz zlam a vədaŋ gayaŋ ni bu. ");
INSERT INTO muy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dəgum. Nihi ti nəsləroru kʉli e kiɗiŋ ge mis vu akaɗa ga bəza təmbak e kiɗiŋ ga kərá gili bu ni. ");
INSERT INTO muy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kə̀həlum zlam ba, ku mbici, ku mbolu, ku kimaka. Kìcikʉm e divi bu ga məgri sa ana mis ba daya. ");
INSERT INTO muy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wuɗaka kəhurumiyu a ahay vu afa ge mis lu nahəma, ɗəmum : “Melefit mə̂gri sulum gayaŋ ana huɗ ahay hini.” ");
INSERT INTO muy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamal mis sulumani àvu a ahay gani nani bu ni ti sulum ge Melefit ya kə̀ɗəmum ni anjəhaɗki. Tamal mis sulumani àvu bi nahəma, sulum ge Melefit ya kə̀ɗəmum ni aŋgəkia ke kʉli a. ");
INSERT INTO muy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ka ya ti kə̀hurumiya a ahay va afa ge mis a nahəma, njəhaɗuma eslina hʉya. Kàmbatum ahay nahaŋ ba. Zlam məzumani akaba zlam miseni ya ti təvi ana kʉli ɗek ni ti zumum, sʉm : aɗaba bay magray tʉwi ti agəski təvi endif gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka ya ti kìnjʉmiya a kəsa va mək tə̀gəskabá kʉli a nahəma, zumum zlam ya təvi ana kʉli ni, ");
INSERT INTO muy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","həŋgarumaba ndam gatay ya tèɓesey do na, humi ana ndam ga kəsa gani : “*Məgur ge Melefit ènjikia ke kʉli a.” ");
INSERT INTO muy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ay tamal ti kìnjʉmiya a kəsa va mək tə̀gəskabu kʉli do nahəma, cikʉma a dalaka ba. Humi ana tay : ");
INSERT INTO muy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ku haɗ ga kəsa gekʉli nəŋgu ni məsləɗikaba ana kʉli ka asak geli a. Nahkay ti kəsərum Melefit day àmbrəŋa kʉli a. Ku tamal nahkay nəŋgu ni, sərumki Məgur ge Melefit ti ènjia.” » ");
INSERT INTO muy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yezu àhi ana tay keti : « Nəhi ana kʉli nahəma, ka fat ya ti Melefit agray seriya ni ti ku ndam *Sodom nəŋgu ni seriya ge Melefit ya amagrafəŋa kà tay a ni ŋgulum emisli ga ndam ga kəsa gani nani ya tə̀gəskabu kʉli do ni do. » ");
INSERT INTO muy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Yezu àɗəm keti : « Akəsum cicihi, ndam Koraziŋ ! Akəsum cicihi, ndam Beceyda ! Aɗaba mam, nàgra zlam a kay ya mis tìpi ɗay-ɗay ndo na a kəsa gekʉli ba. Tamal nàgray zlam nday nani e Tir ahkay do ni a Sidoŋ nahəma, amal ndam ga kəsa nday nani tə̀mbrəŋa zlam magudarani gatay na kwa ahaslana àndava. Amal tàmbatkaba majalay ahàr gatay a, tàbakabá mbolu ka vu a akaɗa ga azana na, tànjəhaɗa e viti ba. ");
INSERT INTO muy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ay ka fat ya ti Melefit amagray seriya ni ti seriya ya ti amagrafəŋa kà ndam Tir akaba ndam Sidoŋ a ni ti ŋgulum emisli gekʉli ni do. ");
INSERT INTO muy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lekʉlʉm ndam Kafarnahum, kə̀humi ana ahàr akədəgum e melefit vu aw ? Aha ! Akədəgum ti ka məlaŋ ge *kisim sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Àhi ana ndam maɗəbay naŋ ni : « Maslaŋa ya ti èciikia ma ana kʉli a nahəma, ècʉkia ma ana nu a daya. Maslaŋa ya ti àgəskabu kʉli ndo nahəma, àgəskabu nu ndo daya. Maslaŋa ya ti àgəskabu nu ndo ni ti àgəskabu Bay ya ti àslərbiyu nu ni ndo daya. » ");
INSERT INTO muy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ka ya ti nday kru kru adəskəla mahar cʉeni ni tàsləkabiya ni ti nday àna məmərani. Tə̀hi ana Yezu ahkado : « Bay geli, ku seteni tekeɗi tìciikia slimi ana leli a ka ya ti mə̀hi ma ana tay àna slimi gayak ni. » ");
INSERT INTO muy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eslini Yezu àhəŋgarfəŋ, àhi ana tay ahkado : « Nu nìpia *Seteni a ka ya ti àdəbiyu e melefit bu akaɗa ga avər ya abay aku na. ");
INSERT INTO muy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Cʉm day : nə̀via njəɗa ana kʉli ga masawaɗakiani ka zlam ya a haɗ akaba ka andra məɓal mis a ; nə̀via njəɗa ana kʉli a àtama njəɗa ga Seteni zal ezir na ɗek. Nahkay araŋa àbi amagrakivu ke kʉli bi simiteni. ");
INSERT INTO muy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ku tamal nə̀via njəɗa nana ɗek ana kʉli a, seteni tìciikia slimi ana kʉli a nəŋgu ni, kə̀mərumvu azuhva nani ba. Mərumvu ti aɗaba Melefit àbəkia slimi gekʉli ka wakita gayaŋ e melefit ba ni sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka sarta gani nani Yezu naŋ àbu amərvu dal-dal àna njəɗa ga *Məsuf Njəlatani, àɗəm : « Nazləbay kur, Bəba goro ni, nak Bay məgur məlaŋ ya e melefit bu akaba məlaŋ ya a ga haɗ ni ɗek. Nazləbay kur ti aɗaba kə̀ŋgahkia zlam nday nana ka ndam məsər zlam akaba ka ndam ya tìjeŋga tə̀səra zlam a ni, kə̀ɗəfikia ana ndam ya tə̀sər zlam do akaɗa ga bəza ciɓ-ciɓeni na sawaŋ. Iy Bəba goro ni, kàgray ka mawayay gayak nahkay ti kə̀məra àna naŋ a palam. » ");
INSERT INTO muy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Àɗəm keti : « Baba àvua zlam na ɗek a ahar va. Nahkay maslaŋa ya àsər Wur ge Melefit naŋ way ni ti maslaŋa gani àbi ; si Bəŋani ciliŋ. Yaw maslaŋa ya àsər Bəŋ goro naŋ way ni ti maslaŋa gani àbi, si nu Wur gayaŋ akaba ndam ya ti nu Wur gayaŋ ni nawayay nəɗəfiki naŋ ana tay ni ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Eslini Yezu nakəŋ àmbatkibiyu ma ka ndam maɗəbay naŋ ni, àhi ma ana tay, nday ka ahàr gatay ciliŋ. Àhi ana tay ahkado : « Ay lekʉlʉm ti mərumvu, aɗaba kə̀bum kipʉm zlam hini àna eri gekʉli ! ");
INSERT INTO muy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nəhi ana kʉli : Ndam mahəŋgaray *pakama ge Melefit akaba bəbay kay ya ahaslani ni tàwaya mipia ere ye ti kipʉm na, ay ti tìpi ndo. Tàwaya micia ere ye ti kicʉm na, ay ti tìci ndo. » ");
INSERT INTO muy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Eslini zal nahaŋ àbu, naŋ bay *məsər Wakita ge Melefit, awayay ahəlfəŋa eyʉ kà Yezu a. Nahkay ècikaba, àhi ana Yezu ahkado : « Mʉsi, ti nə̂ŋgət *sifa ya àndav ɗay-ɗay do ni ti nâgray mam day mam ? » ");
INSERT INTO muy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yezu nakəŋ àhəŋgrifəŋ, àhi : « Mʉwiz àbəki mam e *Divi ge Melefit bu mam ? Kìci mam a huɗ gani bu mam ? » ");
INSERT INTO muy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Zal nakəŋ àhəŋgrifəŋ, àhi : « Àbu məbəkiani : “Wayay Bay Melefit gayak àna huɗ bəlaŋ, àna sifa gayak ɗek, àna njəɗa gayak ɗek akaba àna majalay ahàr gayak ɗek. Wayay ndam ya ti nak kə̀bu akaba tay ni daya akaɗa ya kawayay ahàr gayak gayakani ni.”  » ");
INSERT INTO muy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yezu àhi ahkado : « Kàhəŋgarfəŋa kigena. Tamal kagray nahkay ti sifa gayak amandav ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eslini bay məsər Wakita ge Melefit ni awayay ti Yezu àgəski naŋ ka pakama ba, nahkay àhi ana Yezu : « Ndam ya ti nu nə̀bu akaba tay ni ti ndamam ? » ");
INSERT INTO muy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yezu àhi keti : « Zal nahaŋ àsləka a Zerʉzalem a, naŋ àbu akoru a Zeriko. Ka ahàr divi nahəma, ndam abra tə̀hərkiaya, tə̀həlfəŋa zlam a ɗek, tə̀zləɓkivu naŋ, tə̀mbərbu naŋ ɓəlah àniviyu a məɓəruv hiɓek hiɓek ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Zal nahaŋ ti ni naŋ àbu akoru àna divi gani nani ka məsər gayaŋ do. Naŋ nani ti bay *maŋgalabakabu mis akaba Melefit. Àra èpia zal nana ɓəlaha ti àsivù ŋgʉ, àsləka zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Zal nahaŋ day àra gwar eslina, naŋ ge dini ge *Levi. Àra ènjia, èpia zal nana ɓəlaha ti àsivù ŋgʉ daya, àsləka zlam gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ay ti zal nahaŋ naŋ àbu akoru gwar e divi gani nani bilegeni. Naŋ zal Samari, akoru àna azoŋgu. Àra ènjia ka məlaŋ nana ti àdi ahàr ana zal nakəŋ naŋ ɓəlaha. Àra èpia naŋ a ti àsia cicihi a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nahkay naŋ nakəŋ àhəɗakfəŋiyu, àzaya amal akaba zum a, àbiki ka ambələk ni mək àwəliki àna azana. Kələŋ gani àzəkiyu naŋ ka azoŋgu gayaŋ ni, àzoru naŋ a ahay ya ndam mirkwi tanjəhaɗvù ni vu, àfi ahàr eslini. ");
INSERT INTO muy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hajəŋ gani ti àhəliaya jik a cʉ ana bay ga ahay ga ndam mirkwi nakəŋ a, àhi ahkado : “Fi ahàr ana zal hini. Tamal kìjiŋkiva siŋgu ka ahàr gani hina nahəma, anasləkabiya ti nara nəpəluk.” » ");
INSERT INTO muy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Eslini Yezu nakəŋ àhi ana bay məsər Wakita ge Melefit ni ahkado : « Kìhindifua ma, kə̀ɗəm ndam ya ti nak kə̀bu akaba tay ni ti ndamam. Yaw, e kiɗiŋ ge mis mahkərani ni bu ni ti hu, way naŋ àbu akaba zal ya ti ndam abra tə̀zləɓ ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Naŋ nakəŋ àhəŋgrifəŋ, àhi : « Maslaŋa ya naŋ àbu akaba naŋ ni ti bay ya ti àjənaki naŋ ni. » Yezu àhi : « Nak day ru kagray akaɗa gayaŋ ni. » ");
INSERT INTO muy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka ya ti Yezu akaba ndam maɗəbay naŋ ni tə̀bu takoru e divi bu ni ti tə̀huriyu a kəsa nahaŋ vu. Eslini wal nahaŋ slimi gani Marta àzaloru Yezu a magam afa gani, mək Yezu nakəŋ òru àhuriyu afa gani. ");
INSERT INTO muy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta gani wur ga məŋani walani àbu, slimi gani Mari. Yezu naŋ àbu azlapay ti Mari nakəŋ naŋ àbu manjəhaɗani digʉsa a ga haɗ kà gəvay ga asak gayaŋ, abi slimi ana ma gayaŋ ya ti aɗəm ni. ");
INSERT INTO muy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ka gani nani ti tʉwi ga huɗ ahay gərgəri kay tə̀bu tiviyikaba ahàr ana Marta. Nahkay zla nahəma naŋ nakəŋ àrəkia ka Yezu a, àhi : « Bay goro, wur ga mma ni ambərki nu ke tʉwi ni ɗek ti àɓəlafuk aw ? Hi ma ti mə̂jənaki nu zla aw ! » ");
INSERT INTO muy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ay Bay geli nakəŋ àhəŋgrifəŋ, àhi : « Marta, Marta, zlam kay təhəluk ahàr, tiviyʉkaba ahàr a daya. ");
INSERT INTO muy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ay zlam ya ti àgəski magrani ni ti bəlaŋ ciliŋ. Mari àdəkiba zlam ya àɓəlay magrani na. Nahkay maslaŋa amazafəŋa do simiteni. » ");
INSERT INTO muy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A vaɗ nahaŋ Yezu ahəŋgalay Melefit ka məlaŋ nahaŋ. Àra èndeveriŋa ti biliŋ e kiɗiŋ ga ndam maɗəbay naŋ ni bu àhi : « Bay geli, Zeŋ àcahia mahəŋgalay Melefit ana ndam maɗəbay naŋ na. Nak day cahi mahəŋgalay Melefit ana leli ti. » ");
INSERT INTO muy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yezu àhi ana tay : « Ka ya ti kahəŋgalum Melefit ni ti ɗəmum : “Baba, mis ɗek tə̂gəskabu nak njəlata ti ; kâra kə̂zum bay gayak e kiɗiŋ geli bu ti. ");
INSERT INTO muy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Zlam məzumani ga məgəsi sifa ana leli ni ti vi ana leli kəlavaɗ ti. ");
INSERT INTO muy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mbərfəŋa zlam magudarani geli ni kè leli a, akaɗa geli ya məmbərfəŋa zlam ge mis ya tàgudari ana leli ni ɗek kà tay a ni ti. Kə̀vi divi ana *Seteni ge mesipet leli ba ti.” » ");
INSERT INTO muy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yezu àhi ana tay keti : « Mazay mazavu gani, bi maslaŋa e kiɗiŋ gekʉli bu naŋ àbu àna zləba gayaŋ, akoru afa ga zləba gayaŋ ni a huɗ ya vaɗ, ahi ahkado : “Zləba goro ni, kəlu *dipeŋ mahkər ti ");
INSERT INTO muy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","aɗaba zləba goro nahaŋ àsləkabiya e mirkwi a àdua ahàr a, ay ti zlam àfu ga məviani bi.” ");
INSERT INTO muy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bi zləba gayaŋ ni ahəŋgrifəŋbiyu, àhibiyu : “Kìviyu ahàr ba ! Nə̀zləkva mahay a àndava, màndəhaɗa akaba bəza. Nìsliki micikabana ga mədukaya zlam a do.” ");
INSERT INTO muy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ay nəhi ana kʉli nahəma, ara ecikaba avi ere ye ti ehindiliŋ ni ɗek. Ecikaba avi ti aɗaba naŋ zləba gayaŋ ciliŋ do, avi ti aɗaba àmbrəŋ mihindiliŋeni ndo palam. ");
INSERT INTO muy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nahkay nəhi ana kʉli : Hindʉm zlam. Kìhindʉma ti Melefit aməvi ana kʉli. Ɗəbum zlam. Kə̀ɗəbuma ti akəŋgətum. Zalum Melefit. Kàzaluma naŋ a ti aməwəli ana kʉli, aməzləkiaba mahay ana kʉli a. ");
INSERT INTO muy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Aɗaba mam, ku way way do ehindi zlam, Melefit avi. Ku way way do aɗəbay zlam, aŋgət. Ku way way do azalay, Melefit awəli, azləkiaba mahay a. ");
INSERT INTO muy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Bi wur ara afa gayak, nak bəŋana, èhindilʉka kilif a ti kə̀vi kilif do, kəvi gavaŋ sawaŋ aw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ahkay do ni bi ara ehindilʉk eysli ti kəvi andra məɓal mis aw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Lekʉlʉm ti ndam magudar zlam. Ku tamal lekʉlʉm ndam magudar zlam nəŋgu ni, kə̀səruma məvi zlam sulumani ana bəza gekʉli a. Ay ti Bəŋ gekʉli Melefit naŋ e melefit bu, naŋ sulumani ti magray gayaŋ ahəmamam ? Naŋ ti tamal maslaŋa èhindiliŋa Məsuf Njəlatana nahəma, aməvi eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A vaɗ nahaŋ Yezu àgariaba seteni ana zal nahaŋ a. Seteni nani acafəŋa maslaŋa nana ga mazlapana. Seteni ni àra àsləkiaba nahəma, zal nakəŋ àzlapay hʉya. Mis dal-dalani ye eslini ni tàgra ejep gana dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ay mis ndahaŋ e kiɗiŋ gatay nani bu tə̀ɗəm : « Yezu agariaba seteni ana mis a ni ti àna njəɗa ge *Belzebʉl bay ge seteni ni. » ");
INSERT INTO muy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mis ndahaŋ ti ni tawayay təhəlfəŋa eyʉ a ti mâgudar zlam, tə̀hi ahkado : « Griaya ere ye ti mìpi ɗay-ɗay ndo na ana leli a, ti mə̂sər ere ye ti kagray ni ti kagray àna njəɗa ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ay ti Yezu àsəra majalay ahàr gatay a àndava. Nahkay àhi ana tay : « Tamal ndam ga haɗ nahaŋ nday ndayani takaɗvu e kiɗiŋ gatay bu ni ti mis akaba zlam ga haɗ gani etigi ahàr. Nahkay ahay ga ndam ga haɗ gani nani atəmbəɗ ; ndahaŋ atəmbəɗkiyu ka ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Lekʉlʉm kə̀ɗəmum nu nagariaba seteni ana mis a ni àna njəɗa ge Belzebʉl a ; tamal nahkay ti njəɗa ge *Seteni èdeva ; ègia nahkay ti aŋgoru kama ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ay tamal nu nagariaba seteni ana mis àna njəɗa ge Belzebʉl a ti ndam gekʉli ni tagariaba seteni ana mis a ti àna njəɗa ga way ? Nahkay zlam ga ndam gekʉli gekʉleni ya tagray ni ti aɗafaki ere ye ti kə̀ɗəmum ni ti ma ga malfaɗa. ");
INSERT INTO muy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nagariaba seteni ana mis a ti àna njəɗa ge Melefit sawaŋ. Goro ya nagray nahkay ni ti aɗafaki *Məgur ge Melefit ènjikia ke kʉli a àndava. » ");
INSERT INTO muy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Yezu àɗəm keti : « Tamal ti mis njəɗa-njəɗani naŋ àbu àna zlam ahar gayaŋ, ajəgay ahay gayaŋ ti, tə̀həlfəŋa zlam gayaŋ a koksah. ");
INSERT INTO muy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ay tamal maslaŋa nahaŋ àtama naŋ àna njəɗa àrəkia, azləɓ naŋ nahəma, ahəlfəŋa zlam ahar gayaŋ gani ya àɗəm ajəgay ahay gayaŋ àna naŋ na ɗek. Àhəlfəŋa zlam ahar na ti, ahəlfəŋa zlam ga ahay gayaŋ ndahaŋ na ɗek daya, edi ana mis. ");
INSERT INTO muy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Maslaŋa ya ti naŋ àbi akaba nu bi nahəma, naŋ zal ezir goro. Maslaŋa ya ti àjənaki nu ga mazalubiyu mis do nahəma, agarafua tay a sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","« Ka sarta ya ti seteni àsləkiaba ana mis a ni ti, akoru a huɗ gili vu ka məlaŋ ya ti yam àbi ni, aɗəbay məlaŋ manjəhaɗani. Tamal àŋgət məlaŋ manjəhaɗani do ni ti aɗəm : “Ŋgulum nəŋguvoru a arəŋ goro ni vu zlam goro.” ");
INSERT INTO muy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Àra ènjia ti àhuriyu àdi ahàr ana arəŋ ni məsləɗabana, maslamalabana lala. ");
INSERT INTO muy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Eslini naŋ nakəŋ asləka, akoru azalakivabiyu seteni ndahaŋ adəskəla, nday nani ɗek tə̀tam naŋ àna cuɗay. Mək nday ɗek tara təhuriyu, tanjəhaɗ a arəŋ ni bu. Nahkay maslaŋa nani ti manjəhaɗ gayaŋ ni egi ŋgulum gayaŋ ya ahaslani ni keti. » ");
INSERT INTO muy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti wal nahaŋ e kiɗiŋ ge mis macakalavani ni bu àdi ana zlahay, àhi : « Wal ya ti èwi kur, kìsi ɗuwa gayaŋ ni ti mə̂mərvu. » ");
INSERT INTO muy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ay Yezu àhəŋgrifəŋ, àhi : « Aha ! Tə̂mərvu ti ndam ya ti tici pakama ge Melefit mək təgəskabu, tagray tʉwi àna naŋ lala ni sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eslini mis tə̀bu təcakalavabiyu kà gəvay ga Yezu àkivu. Nday tə̀bu təcakalavu nahkay ti Yezu àɗəm : « Ndam ye e hini vu ni ti ndam magudar zlam. Tihindi ere ye ti mis tìpi ɗay-ɗay ndo ni, ay ere ye ti tihindi ni ti Melefit aməgri ana tay do simiteni. Melefit aməɗəfiki ana tay ere ye ti àɗafaki àna Zonas ni ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Zonas nahəma, Melefit àɗəfikia zlam ana ndam Niniv àna naŋ a. Nu *Wur ge Mis day Melefit aməɗəfiki zlam ana nday ye e hini vu ni àna nu. ");
INSERT INTO muy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ka fat ya ti Melefit amagrafəŋa seriya kè mis a ɗek nahəma, bay walani ya àgur haɗ Seba ni emicikaba akaba ndam ye e hini vu na, aməhi ana tay : “Lekʉlʉm ndam magudar zlam.” Aɗaba mam, bay gani nani ècikbiyu kwa kè sliri ga məlaŋ ga mara məbi slimi ana pakama ga Salomoŋ bay məsər zlam ni. Ay ahalay ti mis àbu àtama Salomoŋ àna gəɗakana ti kəsərum do aw ? ");
INSERT INTO muy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka fat ge seriya nani ti ndam Niniv day eticikaba akaba mis ye e hini vu na, atəhi ana mis ye e hini vu ni : “Lekʉlʉm ndam magudar zlam.” Aɗaba mam, ndam Niniv tàra tìcia pakama ga Zonas ya àhi ana tay na ti tàmbatkaba majalay ahàr gatay na. Ay ahalay ti mis àbu àtama Zonas àna gəɗakana ti kəsərum do aw ? » ");
INSERT INTO muy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yezu àɗəm keti : « Maslaŋa ya ti ebeftey ceŋgel mək aŋgah, ahəmbaki zlam ni ti àbi. Afəkaɗ ka məlaŋ zaŋani sawaŋ, aɗaba awayay ti ndam ya təhuriyu a ahay vu ni tipi maslaɗay ge ceŋgel ni. ");
INSERT INTO muy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Eri gayak aslaɗay vu gayak akaɗa ge ceŋgel ya aslaɗay məlaŋ ni. Tamal eri gayak lala nahəma, vu gayak ɗek àbu a maslaɗani bu. Ay tamal eri gayak lala do nahəma, vu gayak ɗek e ziŋ-ziŋeni bu. ");
INSERT INTO muy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tamal kə̀ɗəm nak kə̀bu a maslaɗani bu ni ti jalay lala ; bi nak kə̀bu e ziŋ-ziŋeni bu sawaŋ. ");
INSERT INTO muy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tamal ti vu gayak ɗek a maslaɗani bu, palahar gani nahaŋ àvu e ziŋ-ziŋeni bu bi nahəma, vu gayak ɗek amələbu a maslaɗani bu, akaɗa ka ya ti ceŋgel aslaɗuk məlaŋ ni. » ");
INSERT INTO muy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka ya ti Yezu èndeveriŋa mazlapana ni ti zal *Feriziyeŋ nahaŋ àzaloru naŋ afa gani ga məzum zlam. Yezu nakəŋ àra àhuriya ti ànjəki ka məzum zlam ");
INSERT INTO muy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","mənjəɗ məbaray ahar àna divi gani. Zal Feriziyeŋ ni àra èpia nahkay ti àgria ejep a. ");
INSERT INTO muy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eslini Bay geli àhi ahkado : « Lekʉlʉm ndam Feriziyeŋ nahəma, kabarumfəŋa aləŋ ge hijiyem akaba aləŋ ga halaf a, ambatakani do a huɗ gekʉli bu ni ti akal akaba cuɗay cisl cisl. ");
INSERT INTO muy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Muru gekʉli ni ! Melefit Bay ya ti àgraya aləŋ ga zlam a ni ti àgraya huɗ gana daya. Nahkay do aw ? ");
INSERT INTO muy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Vumi zlam ya a huɗ ge hijiyem gekʉli bu akaba a halaf gekʉli bu ni ana ndam talaga. Tamal kəgrum nahkay ti zlam gekʉli ɗek amələbu njəlata. ");
INSERT INTO muy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","« Ay lekʉlʉm ndam Feriziyeŋ ni ti akəsum cicihi, aɗaba ata azagat, matakavay akaba slimberi ndahaŋ ya tidi eli àna tay ni tekeɗi, kə̀bum kəzumiaba biliŋ a huɗ ga kruani ba ana Melefit a. Ay ti lekʉlʉm kə̀grum jiri do, kàwayum Melefit do. Giri-giri ti ere ye ti amal kəgrum enji ni ti magray jiri akaba mawayay Melefit, day kwa ti kəgrum zlam ndahaŋ ya Mʉwiz àɗəm grum ni. ");
INSERT INTO muy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Lekʉlʉm ndam Feriziyeŋ ni ti akəsum cicihi, aɗaba kawayum manjəhaɗvani e kʉrsi ga gəɗákani vu a ahay ga *mahəŋgalavù Melefit bu, kawayum ti mis təgri sa ana kʉli a gosku bu kè meleher ge mis ɗek daya. ");
INSERT INTO muy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Akəsum cicihi, aɗaba lekʉlʉm akaɗa mindiviŋ mebesveni ya mis tə̀sər məlaŋ gani do, təcəlki ni. » ");
INSERT INTO muy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Zal nahaŋ, bay *məsər Wakita ge Melefit, àra ècia pakama ga Yezu na ti àhi ahkado : « Mʉsi, kə̀ɗəm nahkay ti kìndivia leli a daya timey. » ");
INSERT INTO muy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yezu àhi : « Lekʉlʉm ndam *məsər Wakita ge Melefit day akəsum cicihi, aɗaba kəfumkiyu zlam məɗəsani ke mis, ku weleher tekeɗi kə̀fumfəŋiyu ga məjənaki tay do. ");
INSERT INTO muy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Akəsum cicihi, aɗaba keɗezlʉmkiyu mindiviŋ ga ndam mahəŋgaray *pakama ge Melefit ya ahaslani ni lala. Ambatakani do tàbazl tay ti ata bəŋ gekʉli. ");
INSERT INTO muy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nahkay kəɗəfumki kə̀gəsumkabá tʉwi ga ata bəŋ gekʉli ya tàgray na : nday tàbazla ndam mahəŋgaray pakama ge Melefit na, lekʉlʉm ti ni keɗezlʉmkiyu mindiviŋ gatayani. ");
INSERT INTO muy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Azuhva nani ti Melefit àna məsər zlam gayaŋ ni àɗəm : “Anəslərikaboru ndam mahəŋgaray pakama goro akaba ndam asak goro ana tay. Ay atəgəskabu ndam ya ti anəslərikaboru ana tay ni do ; atabazl ndahaŋ, ndahaŋ ti ni atəgri daliya ana tay.” ");
INSERT INTO muy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Seriya gani amədəɗki ka ndam ye e hini vu ni, aɗaba ndam mahəŋgaray pakama ge Melefit ya tàbazl tay kwa ka mənjəki ga məlaŋ ni kala nday tàbazl tay, ");
INSERT INTO muy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tə̀njəki ka Abel, tàbazlbiyu duk àniva ana Zakari a. Tàkaɗ Zakari ti e kiɗiŋ ga məlaŋ *meviyekiki zlam ana Melefit ata məlaŋ *njəlatani ga *ahay gəɗakani ge Melefit ni bu. Nəhi ana kʉli nahəma, seriya amədəɗki ka ndam ye e hini vu ni azuhva mis nday nani ya tàbazl tay ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Lekʉlʉm ndam məsər Wakita ge Melefit ni ti akəsum cicihi, aɗaba kə̀zləkumiva mahay ana mis a, kawayum ti tə̀sər Melefit ba. Lekʉlʉm lekʉlʉmeni day kə̀hurumiyu do, kəcumfəŋa ndam ya tawayay məhuriyani na daya. » ");
INSERT INTO muy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yezu nakəŋ àra àhəraya a ahay ya naŋ àvu ni ba ni ti ndam məsər Wakita ge Melefit akaba ndam Feriziyeŋ ni tàɗəbay naŋ àna pakama, tə̀zumkia ɓəruv a dal-dal. Tə̀njəki ke mihindifiŋa zlam a gərgəri kay, ");
INSERT INTO muy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","tə̀bu təhəlfəŋa eyʉ a, tawayay ti təgəski naŋ ka ma magudarani. ");
INSERT INTO muy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ka sarta gani nani nahəma, mis tə̀cakalava agray dəbu ehimeya. Nday kay nahkay ti mis ndahaŋ təcəlki ka asak ge mis ndahaŋ aɗaba məlaŋ mafəkaɗ asak àbi. Eslini Yezu àhi ma ana ndam maɗəbay naŋ ni enji. Àhi ana tay ahkado : « Bumvu slimi ana *miwisiŋ ga ndam *Feriziyeŋ ni : gatay ya taŋgah majalay ahàr gatay magədavani ni ti ègia akaɗa miwisiŋ a. ");
INSERT INTO muy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ay zlam maŋgahani ni ɗek emipivu ; ma maŋgahani ni ɗek emicivu. ");
INSERT INTO muy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nahkay ma ya ti kə̀ɗəmum a məlaŋ ziŋ-ziŋeni bu ni ɗek ti emicivu vay-vay a məlaŋ maslaɗani bu. Ma ya ti kə̀humiviyu ana mis e slimi vu lekʉlʉm məzləkumkabu ahay ni ti atəzlah àna ma gani nani ka ahàr ga həma. » ");
INSERT INTO muy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yezu àɗəm keti : « Nəhi ana kʉli ndam goro ni, kə̀grumfəŋa aŋgwaz kà ndam ya takaɗ mis na ba, aɗaba tamal tàkaɗa mis a ti tə̀grikivu araŋa nahaŋ koksah. ");
INSERT INTO muy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nəɗəfiki bay ya ti kəgrumfəŋa aŋgwaz a ni ana kʉli : bay nani ti bay ya ti tamal àkaɗa mis a ti esliki mizligiyu naŋ a *dəluv ga aku vu ni. Bay nani ti Melefit. Iy nahkay, nəhi ana kʉli, grumfəŋa aŋgwaz a ti kà naŋ. ");
INSERT INTO muy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","« Tə̀bu təsəkum eɗiɗiŋ ciɓ-ciɓeni zlam àna siŋgu cʉ bi aw ? Ay səruma eɗiɗiŋ nday nani ti ku biliŋ day àgəjazlki ahàr ke Melefit do. ");
INSERT INTO muy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Lekʉlʉm day ku məhər ga ahàr gekʉli nəŋgu ni Melefit àcalaba ɗek. Nahkay kə̀grum aŋgwaz ba, ku eɗiɗiŋ kay day kàtamuma tay kè eri ge Melefit a. » ");
INSERT INTO muy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yezu àɗəm keti : « Nəhi ana kʉli nahəma, ku way way do tamal aɗəm vay-vay naŋ mis goro kè meleher ge mis ti, nu *Wur ge Mis day anəɗəm vay-vay naŋ mis goro kè meleher ga *məslər ge Melefit. ");
INSERT INTO muy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ay maslaŋa ya ti aɗəm naŋ mis goro do nahəma, nu day anəɗəm naŋ mis goro do kè meleher ga məslər ge Melefit. ");
INSERT INTO muy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Maslaŋa ya ti aɗəmku ma magədavani ka nu, nu Wur ge Mis ni ti, Melefit aməmbərfəŋa zlam magudarani gayaŋ nana. Ay maslaŋa ya endivi *Məsuf Njəlatani ni ti, Melefit aməmbərfəŋa zlam magudarani gayaŋ na do simiteni. ");
INSERT INTO muy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Atagrafəŋa seriya kè kʉli a ahay ga *mahəŋgalavù Melefit ba, akaba kè meleher ga bəbay ahkay do ni kè meleher ga ndam ga ŋgumna. Ka ya ti tagrafəŋa seriya kè kʉli a nahkay ni ti pakama ya ti akəɗəmum ga mahəŋgay ahàr gekʉli ni ti àhəli ahàr ana kʉli ba ; ");
INSERT INTO muy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","aɗaba mam, ka sarta gani nani ti Məsuf Njəlatani aməɗəfiki ere ye ti akəɗəmum ni ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eslini zal nahaŋ e kiɗiŋ ge mis dal-dalani ni bu àhi ana Yezu ahkado : « Mʉsi, wur ga mmawa àhəla elimeni ga bəŋ geli ya àmbribu ana leli na ɗek. Hi ti mə̂dufəŋa ere gani goro a ti. » ");
INSERT INTO muy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yezu àhəŋgrifəŋ, àhi ahkado : « Way àfiyu nu bay magray seriya ga midikaba zlam ana kʉli a way, wura ? » ");
INSERT INTO muy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Eslini Yezu nakəŋ àhi ana mis ni ɗek ahkado : « Bumvu slimi ana ma ge elimeni, kàwayum ba. Aɗaba mis naŋ àbu àna sifa ti azuhva zlam ya àfəŋ ni do. Ku elimeni gayaŋ kay nəŋgu ni àvi sifa do. » ");
INSERT INTO muy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Àhi ma ana tay àna ma *gozogul, àɗəm ahkado : « Bay ge elimeni nahaŋ àbu nahəma, vədaŋ gayaŋ tə̀bu, zlam ànjəkia dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Àhi ana ahàr : “Nihi guvur goro tàhəca ti anəbəviyu zlam ni ti a mam vu mam ? Nagray hi ti ahəmamam ?” ");
INSERT INTO muy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mək àɗəm : “Ere ye ti nagray ni ti nihi : nembeɗkaba guvur goro na ɗek, nələmvaya gəɗákana ndahaŋ a. Nahkay anəbəviyu hay goro ni akaba zlam ndahaŋ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mək anəhi ana ahàr : Maslaŋa goro ni, zlam gayak àvu kay maŋgahani ge vi ehimeyeni. Nihi ti pəsaba, zum zlam, si zlam, gray wuməri zlam gayak.” ");
INSERT INTO muy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ay ti Melefit àhi : “Nak kə̀sər araŋa do, kani kani a ga məlavaɗ kara kəmət. Nahkay zlam gayak ya kə̀ŋgahkabu ɗek ni ti way aməzum way ?” » ");
INSERT INTO muy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yezu àhi ana tay ahkado : « Maslaŋa ya ti aŋgahikabu elimeni ana ahàr gayaŋ gayaŋani ni ti naŋ day ere ye ti agrakivu ni ti nahkay, aɗaba kè eri ge Melefit ti naŋ bay ge elimeni do. » ");
INSERT INTO muy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Eslini Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Nahkay zla nahəma, nəhi ana kʉli a manjəhaɗ gekʉli bu ni ti ŋgay akəzumum mam akaba akəbumkabu mam ti kàjalum ba, àhəli ahàr ana kʉli ba daya. ");
INSERT INTO muy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sifa ti àtam zlam məzumani do waw ? Vu ti àtam zlam məbakabani do waw ? ");
INSERT INTO muy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ŋga pʉm ŋgarama day nimi : tìzligi zlam do, tàbaz zlam do. Guvur gatay àbi, məlaŋ məbiyu zlam gatay ndahaŋ day àbi. Ku nday tə̀bu nahkay nəŋgu ni, Melefit naŋ àbi avi zlam məzumani ana tay bi aw ? Lekʉlʉm ti kàtamum eɗiɗiŋ ferek-ferek do waw ? ");
INSERT INTO muy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Way e kiɗiŋ gekʉli bu esliki mədəkiviyu vaɗ àkivu ke vi gayaŋ ku gʉzit àna majalay ahàr gayaŋ way ? Àbi ! ");
INSERT INTO muy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ay tamal kìslʉmki magray ere hini gʉziteni ni do nahəma, kajalumki ahàr ka zlam ga manjəhaɗ gekʉli nday ndahaŋ ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Jalum ahàr day ! Vay-vay ga zlam ya təfət a vədaŋ bu ni ti tàgray tʉwi do, tə̀ləmkabu azana do daya. Ay nəhi ana kʉli nahəma, ku Salomoŋ àna elimeni gayaŋ ni ɗek tekeɗi àbakabu azana ya ti àɓəlay akaɗa vay-vay bəlaŋ ni ndo. ");
INSERT INTO muy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Zlam ya təfət a vədaŋ bu kani, hajəŋ təbiyu tay a aku vu ni tekeɗi Melefit abəki vay-vay ka tay. Tamal naŋ àbu agray nahkay ti aməbəki zlam ke kʉli amatam gatay ni do waw ? Lekʉlʉm ti kə̀fumki ahàr ke Melefit lala do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Lekʉlʉm ti kə̀ɗəbum zlam məzumani akaba zlam miseni ba ; zlam nday nani àhəli ahàr ana kʉli ba. ");
INSERT INTO muy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nday ya ti taɗəbay zlam nday nani ɗek kəlavaɗ ni ti ndam ga *duniya ya tə̀fəki ahàr ke Melefit do ni. Ay lekʉlʉm ti Bəŋ gekʉli Melefit àsəra ere ya àhəcikivu ana kʉli na. ");
INSERT INTO muy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ɗəbum ti *Məgur ge Melefit sawaŋ. Nahkay zlam ndahaŋ ni ɗek day Melefit aməvikivu ana kʉli. ");
INSERT INTO muy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Aŋgwaz àwər kʉli ba, bəza təmbak goro ni, aɗaba àɓəlafəŋa kà Bəŋ gekʉli Melefit ga məvi Məgur gayaŋ ana kʉli a. » ");
INSERT INTO muy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","« Səkumumoru zlam gekʉli ti kə̂bumi siŋgu gani ana ndam talaga. Nahkay ti akələbum àna elimeni e melefit bu. Elimeni nani àndav ɗay-ɗay do, mbolu gani àgədavu ɗay-ɗay do daya. Eslini e melefit bu ni ti ndam akal tòru koksah, gaŋgu day tə̀bi ga magudar zlam bi. ");
INSERT INTO muy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Aɗaba məlaŋ ya ti elimeni gekʉli àvu ni ti kajalumki ahàr ti ka məlaŋ gani nani. » ");
INSERT INTO muy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yezu àhi ana tay keti : « Ahàr àɗəm kəbumkabu azana ge tʉwi, kəbumi slimi ana ceŋgel gekʉli ti aku àmətkia ka tay a ba. ");
INSERT INTO muy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Njəhaɗum akaɗa ga ndam majəgay ahay ka ya ti bay ya təgri tʉwi ni àdoru ka wuməri ga maday wal ni. Tə̀bu tajəgay naŋ ; tamal àsləkabiya, àzala tay a nahəma, təzləkiaba mahay a. ");
INSERT INTO muy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tamal bay ya təgri tʉwi ni àsləkabiya, àdi ahàr ana ndam gayaŋ ni nday eri, nday tə̀bu tajəgay naŋ nahəma, ndam nday nani tə̂mərvu. Nəhi ana kʉli nahəma, bay ahay ni aməbakabu azana ge tʉwi gayaŋ, aməhi ana tay tânjəhaɗa ga məzum zlam a, amara məvi zlam məzumani ana tay. ");
INSERT INTO muy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ku tamal àsləkabiya àna huɗ ya vaɗ ahkay do ni ge dʉena, àdi ahàr ana tay nday eri, tə̀bu tajəgay naŋ ti tə̂mərvu. ");
INSERT INTO muy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","« Cʉm day, tamal bay ahay àsəra sarta ga ndam akal ya atara ga məzləl naŋ na ti àmbrəŋ tay ga mara məhuriyani a ahay gayaŋ vu do. ");
INSERT INTO muy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nahkay lekʉlʉm day slamatumvu lala, aɗaba nu *Wur ge Mis anara ti ka sarta ya ti lekʉlʉm kàjalumki ahàr do ni. » ");
INSERT INTO muy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eslini Piyer àhi ana Yezu ahkado : « Bay geli, ma *gozogul ya kə̀ɗəm ni ti kə̀hi ana leli tək, kə̀hi ana mis ɗek aw ? » ");
INSERT INTO muy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bay geli àhəŋgrifəŋ, àhi ahkado : « Bay magray tʉwi lala, andikabu ana bay ya agri tʉwi ni, àsəra zlam a ni ti way ? Maslaŋa nani ti bay ya ti naŋ agri tʉwi ni ambərfəŋ tʉwi ga huɗ ahay gayaŋ ɗek a ahar vu. Ambərfəŋ tʉwi ga məvi zlam məzumani ana ndam məgri tʉwi ndahaŋ àna sarta gani daya. ");
INSERT INTO muy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bay magray tʉwi nani ti tamal bay ya naŋ agri tʉwi ni àsləkabiya, àdi ahàr, naŋ àbu agray tʉwi lala nahəma, bay məgri tʉwi nani aməmərvu. ");
INSERT INTO muy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nəhi ana kʉli nahəma, bay ya təgri tʉwi ni aməmbrivu elimeni gayaŋ ɗek a ahar vu. ");
INSERT INTO muy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ay bi bay magray tʉwi ni àhi ana ahàr ahkado : “Bay ya ti nəgri tʉwi ni àsləkabiya weceweci do.” Nahkay anjəki ka məzləɓ ndam ya tagrakabu tʉwi ni ; ku zal ku wal day azləɓ. Azum zlam zlam gayaŋ, esi zum dal-dal, eviyi ahàr. ");
INSERT INTO muy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Naŋ àbu agray nahkay ti bay ya təgri tʉwi ni amasləkabiya ka fat ya bay məgri tʉwi ni àjalaki ahàr ndo ni, àna njemdi ya ti àsər do ni. Eminjia ti amatraɓ naŋ dal-dal, aməgri daliya akaɗa ya agri ana nday ndahaŋ ya ti tə̀fəki ahàr ndo ni. » ");
INSERT INTO muy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Yezu àɗəm keti : « Tamal bay magray tʉwi àsəra ere ye ti bay ya agri tʉwi ni awayay na, àslamalavu ga məgri tʉwi nani do nahəma, bay ahay ni aməzləɓ naŋ dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ay tamal ti bay magray tʉwi ni àsər ere ye ti bay ahay ni awayay ni do, agray ere ye ti bay ahay ni àwayay do ni ti, bay ahay ni aməzləɓ naŋ kay do. Maslaŋa ya ti tə̀via zlam a kay ni ti etihindifiŋa kay daya. Maslaŋa ya ti tə̀mbriva zlam kay a ahar va nahəma, etihindifiŋa kay àtama ge mis ndahaŋ na. » ");
INSERT INTO muy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yezu àɗəm keti : « Ere ye ti nəzəbiyu a duniya vu ni ti aku. Nawayay nihi ti aku ni mêbeftevu hʉya. ");
INSERT INTO muy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mis atəgru daliya kay, daliya nani ti emigi *baray goro nahaŋ. Nìsliki majəgani do, nawayay ti baray nani mâgravu hʉya. ");
INSERT INTO muy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Lekʉlʉm kə̀ɗəmum nu nàra a duniya va ti, ti mis tânjəhaɗ e kiɗiŋ gatay bu àna sulumani aw ? Aha ! Nəhi ana kʉli, nàra ti ga məzəbiyu hirvu sawaŋ. ");
INSERT INTO muy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nahkay mis zlam a huɗ ahay bu etihirvu. Mis mahkərani ni etici ma ge mis cʉeni ni do, mis cʉeni ni day etici ma ge mis mahkərani ni do. Anjəki ti nihi hʉya. ");
INSERT INTO muy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bəŋ ga wur emici ma ga wur gayaŋ zalani do, wur ni day emici ma ga bəŋani do. Məŋ ga wur emici ma ga wur gayaŋ dahalayani do, wur ni day emici ma ga məŋani do. Məŋ ga zal emici ma ga wal ga wur gani do, wal ni day emici ma ga məŋ ga zal gayaŋ ni do. » ");
INSERT INTO muy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yezu àhi pakama nahaŋ ana mis dal-dalani ni, àɗəm ahkado : « Tamal ti kìpʉma maklaɓasl gwar ka dəluv gəɗakana ti kəɗəmum avər ara atəɗ hʉya, mək agravu eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tamal ti kìcʉma aməɗ akəzlabiyu gwar egezi ti kəɗəmum endif ara agray, mək agravu eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Lekʉlʉm ndam jireni do, aɗaba kəmənjumoru agavəla ahkay do ni ka haɗ ti kə̀səruma ere ye ti amagravu na. Ay ere ye ti Melefit agray nihi ni ti kə̀sərum do ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Yezu àɗəm keti : « Ere ye ti àɓəlay magrani ni ti lekʉlʉm lekʉlʉmeni kə̀sərumkaba do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tamal ti maslaŋa akoru abəhaɗkuk mirdim, kə̀bum kədəgumkaboru afa ga bay nahəma, ŋgalumbu ka ahàr divi. Tamal ti kàŋgalumbu ndo nahəma, maslaŋa nani aməzikaboru kur ana bay magray seriya. Bay ni aməvi kur ana zal slewja, mək zal slewja ni aməfiyu kur a daŋgay vu. ");
INSERT INTO muy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nəhuk nahəma, mənjəɗ məpəlaba ere ye ti tə̀fəkuk na ɗek ti akahəraya a daŋgay ni ba do. Ku tamal ti agəjənifuk sisi bəlaŋ nəŋgu ni, si kəpəlaba kwa. » ");
INSERT INTO muy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ka sarta gani nani mis ndahaŋ tə̀rəkia ka Yezu a. Tàra tìnjia ti tə̀hi ma àki ka ndam Gelili ndahaŋ. Nday nani ti Pilet àbazl tay ka ya ti tisliŋi zlam ana Melefit ni. ");
INSERT INTO muy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yezu àhi ana mis ni : « Ndam Gelili nday nani ya Pilet àbazl tay ni ti, lekʉlʉm kə̀ɗəmum nday ndam magudar zlam tə̀tam ndam Gelili nday ndahaŋ ni ɗek aw ? ");
INSERT INTO muy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aha, nahkay do. Ay nəhi ana kʉli, tamal lekʉlʉm kàmbatumkaba manjəhaɗ gekʉli a do nahəma, akəmətum ɗek akaɗa ga ndam nday nani. ");
INSERT INTO muy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","« Yaw nazay mazavu ga zlam nahaŋ keti : mis kru mahar azlalahkərani ya ahay zəbalani a Silʉwe àmbəɗkia ka tay a, àŋgəlaɗkaba tay a ni ti kìcʉm do aw ? Lekʉlʉm kə̀ɗəmum nday ndam magudar zlam tə̀tam ndam Zerʉzalem nday ndahaŋ ni ɗek aw ? ");
INSERT INTO muy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aha, nahkay do. Ay nəhi ana kʉli, tamal lekʉlʉm kàmbatumkaba manjəhaɗ gekʉli a do nahəma, akəmətum ɗek akaɗa ga ndam nday nani. » ");
INSERT INTO muy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Eslini Yezu àhi ma ana tay àna ma *gozogul, àhi ana tay ahkado : « Zal nahaŋ àjav məŋ ga *wəruv a vədaŋ gayaŋ bu. Ay ka ya ti àra ga məpalay bəza gana ni ti bəza tə̀fəŋ bi. ");
INSERT INTO muy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eslini àhi ana bay məgri tʉwi ga vədaŋ ni ahkado : “Tegi agray vi mahkər, nə̀ɗəm nara napalay bəza ga wəruv hini, ay ti bəza tə̀fəŋ bi. Keleba, agudaru vədaŋ masakani ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ay bay magray tʉwi ga vədaŋ ni àhəŋgrifəŋ, àhi ahkado : “Bay goro, mbrəŋ e vi hini hayaŋ. Nara nilifiŋa haɗ a tekesl, mək nabafəŋ argwa. ");
INSERT INTO muy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nahkay ti bi emiwi bəza kama ; tamal èwi bəza do kekileŋa ti ekikeleba.” » ");
INSERT INTO muy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A vaɗ *məpəsabana nahaŋ ba ni ti Yezu naŋ àbu acahi zlam ana mis a ahay ga *mahəŋgalavù Melefit bu. ");
INSERT INTO muy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wal nahaŋ naŋ àbu eslini, èɓesey do agray vi kru mahar azlalahkər. Seteni nahaŋ àgudara naŋ a, èheɓkia aləŋ a, nahkay wal ni èsliki micikabana koksah. ");
INSERT INTO muy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yezu àra èpia naŋ a ti àzalay naŋ, mək wal nakəŋ àrəkioru. Òru ènjʉa ti Yezu àhi ahkado : « Wal hini, nàhəŋgaraba kur a arməwər gayak ni ba, » ");
INSERT INTO muy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","mək àbəki *ahar. Nahkay wal nakəŋ ècikaba jik hʉya, tata ànjəki ka mazləbay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Gəɗakani ga ahay ga mahəŋgalavù Melefit ni àra èpia ga Yezu ya ti àhəŋgaraba wal na a vaɗ məpəsabana ba ni ti àzumkia ɓəruv a. Nahkay àhi ma ana mis ya tə̀bu eslini ni, àɗəm ahkado : « Kə̀səruma vaɗ àbu muku ga magray tʉwi gekʉli. Nahkay dəguma ti tâhəŋgaraba kʉli a vaɗ nday nana ba. Kə̀dəguma a vaɗ məpəsabana ba ba. » ");
INSERT INTO muy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bay geli àhəŋgrifəŋ, àhi ahkado : « Lekʉlʉm ti ndam jireni do. Way e kiɗiŋ gekʉli bu a vaɗ məpəsabana ba ti èpiceheya sla gayaŋ a ahkay do ni azoŋgu gayaŋ a dəksla ba, àzoru àvibiyu yam do ni way ? ");
INSERT INTO muy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ay wal hini ti naŋ wur huɗ ga Abraham, *Seteni àwəlkabá naŋ a vi kru mahar azlalahkər àmbrəŋ naŋ ndo. Nahkay ti tèpiceheba naŋ a vaɗ məpəsabana ba ba waw ? » ");
INSERT INTO muy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yezu àra àɗəma pakama na nahkay ti mimili àdəgakia ka ndam ezir gayaŋ na ɗek. Ay mis dal-dalani ya tə̀bu eslini ni ɗek tə̀bu təmərvu azuhva zlam gayaŋ ya agray ni ɗek, aɗaba zlam gani nani ti mis tìpi ɗay-ɗay ndo. ");
INSERT INTO muy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yezu àɗəm keti : « Məgur ge Melefit ti àzavu akaba mam ? Nəgurfəŋ ti kà mam ? ");
INSERT INTO muy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Àzavu akaba hilfi ga zlam gʉziteni ya mis azay, ezligi e dini gayaŋ bu ni. Àfətaya ti aɗək gəɗakani akaɗa ga məŋ ga zlam ni : eɗiɗiŋ tagraviyu lala gatay a ahar gani vu. » ");
INSERT INTO muy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yezu àɗəm pakama nahaŋ keti, àɗəm : « Nəgurfəŋ *Məgur ge Melefit ti kà mam ? ");
INSERT INTO muy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Àzavu akaba *miwisiŋ : wal azay, abəkivu ka humbu kay, akuɗatay àna naŋ ni. Nahkay miwisiŋ ni ewisiŋaba humbu na ɗek. » ");
INSERT INTO muy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yezu naŋ àbu akoru a Zerʉzalem. Ka ya ti ènjʉa a kəsa gəɗákani va ahkay do ni a kəsa ciɓ-ciɓeni va ni ti acahi zlam ana mis. ");
INSERT INTO muy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Eslini maslaŋa nahaŋ èhindifiŋa ma, àhi ahkado : « Bay goro, mis ya ti Melefit amahəŋgay tay ni ti nday kay do eɗeɗiŋ aw ? » Nahkay Yezu àhi ma ana mis ya tə̀bu eslini ni, àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","« Zum njəɗa, kaɗumvu ga məhuriyani gwar a mahay misliceni ni. Nə̀hi ana kʉli nahkay nahəma, aɗaba mis kay atəɗəm təhuriyu, ay ti etisliki do. ");
INSERT INTO muy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","« A vaɗ nahaŋ bay ahay emicikaba, aməzləkvù mahay gayaŋ. Ka gani nani ti lekʉlʉm akələbum e mite bu. Akazalum bay ahay ni, akəhumi : “Bay geli ! Zləkiaba mahay ana leli a ti.” Ay ti aməhəŋgrifəŋ ana kʉli : “Lekʉlʉm ndamam ? Nə̀sər kʉli do.” ");
INSERT INTO muy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Eslini akəhumi ahkado : “Leli ya mə̀zumkabu zlam akaba mìsikabu zlam akaba nak ni. Nak ya kàcahi zlam ana mis a kəsa geli bu ni timey.” ");
INSERT INTO muy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ay aməhəŋgrifəŋ ana kʉli keti : “Lekʉlʉm ndamam ? Nə̀sər kʉli do. Sləkumfua, lekʉlʉm ɗek ndam ya ti kə̀grum zlam ge jiri do ni !” ");
INSERT INTO muy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Eslini ekipʉm Abraham, Izak, Zekʉp akaba ndam mahəŋgaray *pakama ge Melefit ni ɗek a *Məgur ge Melefit bu, lekʉlʉm ti ni atəmbrəŋ kʉli e mite bu. Eslini ti ekitʉwʉm, akacakum daliya dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mis atara kwa kè sliri ga məlaŋ a gwar eley gwar eley do ɗek, atəzum zlam ga wuməri a Məgur ge Melefit bu. ");
INSERT INTO muy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nahkay ti nday gəɗákani ya kama ge mis ni ti mis ndahaŋ e kiɗiŋ gatay bu ataŋgoru kələŋ ge mis. Nday ya tə̀bu kələŋ ge mis ni ti ni, mis ndahaŋ e kiɗiŋ gatay bu etigi gəɗákani kama ge mis. » ");
INSERT INTO muy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ka sarta gani nani ndam *Feriziyeŋ ndahaŋ tə̀rəkia ka Yezu a, tə̀hi ahkado : « Sləkaba ahalay a, ru ka məlaŋ nahaŋ, aɗaba Erot awayay akaɗ kur. » ");
INSERT INTO muy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yezu àhi ana tay ahkado : « Maslaŋa nani ti ànjəha akaɗa ge eyeŋ na. Dəgum kəhumi ahkado : “Kani nə̀bu nagariaba seteni ana mis a akaba nahəŋgaraba mis ya tèɓesey do na. Hajəŋ day anagray nahkay. A vaɗ ya mahkər zla nahəma, enindeveriŋ tʉwi goro.” » ");
INSERT INTO muy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Yezu àɗəm keti : « Kani, hajəŋ akaba hajəŋ nahaŋ ti ahàr àɗəm nəsawaɗoru nakoru a Zerʉzalem. Aɗaba mam, ndam mahəŋgaray *pakama ge Melefit nahəma, tabazl tay ti a Zerʉzalem kwa. ");
INSERT INTO muy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ndam Zerʉzalem, ndam Zerʉzalem, kə̀bum kabazlum ndam mahəŋgaray pakama ge Melefit, kə̀bum kabazlum ndam ya ti Melefit asləribiyu tay ana kʉli ni àna mizligi tay àna akur daya. Sak ehimeya nàwaya macakalakabá kʉli a akaɗa ga məŋ ge mickʉr ya acakalakabu bəza gayaŋ, abəki kərpasla gayaŋ ka tay ni. Ay ti lekʉlʉm kə̀cuhwum ndo. ");
INSERT INTO muy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nahkay ti Melefit aməmbrəŋ ahay gekʉli ni. Nəhi ana kʉli nahəma, ekipʉm nu e eri vu va do. Ekipʉm nu wuɗaka ti si kə̀ɗəmuma : “Bay Melefit mə̂gri sulum gayaŋ ana maslaŋa ya ti amara àna slimi gayaŋ a ni” day kwa. » ");
INSERT INTO muy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A vaɗ *məpəsabana nahaŋ ba nahəma, gəɗakani ga ndam *Feriziyeŋ nahaŋ àzalabiyu Yezu a magam afa gani ga məzum zlam. Yezu àra àhuriya a ahay va ti ndam ya tə̀bu eslini ni tə̀bu təbi slimi lala, tə̀hi ana ahàr bi agudar araŋa ti təgəski naŋ aw. ");
INSERT INTO muy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eslini zal nahaŋ naŋ àbu èɓesey do àrəkia ka Yezu a. Maslaŋa nani asak akaba ahar ɗek məgəslfəŋana. ");
INSERT INTO muy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yezu àhi ana ndam *məsər Wakita ge Melefit akaba ndam Feriziyeŋ ni ahkado : « E *Divi ge Melefit ni bu ni ti tàva divi ga mahəŋgaraba mis a vaɗ məpəsabana ba tək, tàvay ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eslini nday te-te, tə̀həŋgrifəŋ ndo. Nahkay Yezu àgəs ahar ga maslaŋa ya èɓesey do ni, àhəŋgaraba naŋ a, mək àhi : « Sləka. » ");
INSERT INTO muy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yezu àhi ana mis ye eslini ni ahkado : « Way e kiɗiŋ gekʉli bu, bi wur gayaŋ bi sla gayaŋ àdiya a suwa va ti ku a vaɗ məpəsabana ba azaya weceweci hʉya do ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yezu àra àhia ma nana ana tay a nahkay ti nday nakəŋ tìsliki məhəŋgrifəŋani koksah. ");
INSERT INTO muy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yezu àra èpia ndam ya tə̀zalay tay ga məzum zlam na, tə̀bu tədəkiba məlaŋ manjəhaɗani ga gəɗákana nahəma, àhi ma nahaŋ ana tay àna ma *gozogul, àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","« Tamal ti maslaŋa àgra wuməri ga maday wal a, àzala kur ga məzum zlam a nahəma, kə̀dəkiba məlaŋ manjəhaɗani ga gəɗákana ba. Aɗaba mam, bi àzala maslaŋa nahaŋ gəɗakana àtama kur a. ");
INSERT INTO muy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eslini maslaŋa ya ti àzalabiyu kʉli ni ara ahuk ahkado : “Sləkiaba ana naŋ hina.” Nahkay mimili amadəgakuk, ekicikiaba, akoru kanjəhaɗ ka məlaŋ ge mis ya kələŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tamal tàzala kur ga məzum zlam a nahəma, ru kanjəhaɗ ka məlaŋ ge mis ya kələŋ ni. Eslini day kwa ti maslaŋa ya àzalay kur ni ara ahuk ahkado : “Zləba goro ni, ra kanjəhaɗa ka məlaŋ ga gəɗákana.” Nahkay mis ya tə̀bu eslini ni ɗek atəɗəm nak gəɗakani. ");
INSERT INTO muy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nahkay maslaŋa ya ti awayay gəɗakani ni lu, Melefit amafəkaɗ naŋ kələŋ ge mis ɗek. Ay maslaŋa ya ti àɗəm naŋ kələŋ ge mis ɗek ni day, Melefit aməvi məlaŋ ga gəɗakani. » ");
INSERT INTO muy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yezu àhi ma ana zal *Feriziyeŋ ya àzalabiyu naŋ ni. Àhi ahkado : « Tamal kazalay mis ga məzum zlam ga məlafat ahkay do ni ga məlakarawa nahəma, kàzalay zləbəba gayak ba. Ku bəza ga muk, ku ata muk ata buk, ku ndam mahay gayak ya tə̀bu àna elimeni ni kàzalay tay ba. Aɗaba tamal kàzala nday nana ti nday day atəzalavù kur, atəpəlukvù zlam gayak ya kə̀vi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ay tamal kagray wuməri nahəma, zalay ndam talaga, ndam dəra, ndam jigwer akaba ndam wuluf. ");
INSERT INTO muy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tamal kàgra nahkay ti akəmərvu, aɗaba nday gani tìsliki məhəŋgrukvani koksah. Ka fat ya ti Melefit amahəŋgaraba ndam jireni e kisim ba ni ti Melefit Melefiteni aməhəŋgruk zlam gayak zlam gayak. » ");
INSERT INTO muy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Maslaŋa nahaŋ e kiɗiŋ ga ndam ya təzumkabu zlam akaba Yezu ni bu ni àra ècia pakama ga Yezu ya àɗəm na ti àhi : « Maslaŋa ya ti aməzum zlam a *Məgur ge Melefit bu ni ti mə̂mərvu. » ");
INSERT INTO muy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eslini Yezu àhəŋgrifəŋ, àhi : « Zal nahaŋ àgray wuməri gəɗakani, àzalay mis dal-dal ti tôru afa gani ga məzum zlam. ");
INSERT INTO muy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ka sarta ga məzum zlam ni ti àslərkioru bay məgri tʉwi ka ndam ya ti àzalay tay ni ga məhiani ana tay : “Zlam èdiva àndava. Dəguma zla aw.” ");
INSERT INTO muy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tàra tìcia zalay na ti nday ɗek ku way way do àɗəm : “Kam-kam, nu eninjoru do.” Maslaŋa nahaŋ ni àhi : “Nə̀səkuma vədaŋ goro a ti nakoru namənjakibiyu kwa. Kam-kam, ɓesʉa.” ");
INSERT INTO muy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Maslaŋa nahaŋ day àhi : “Nə̀səkuma slasla ga məwəs vədaŋ a kru ti nakoru natəkar tay. Kam-kam, ɓesʉa.” ");
INSERT INTO muy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Maslaŋa nahaŋ keti day àhi : “Nə̀dəbiya wal a ti nahkay nìsliki maroni do.” ");
INSERT INTO muy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bay məgri tʉwi ni àra àsləkabiya ti àŋgəhaɗi ma ni ɗek ana bay ga ahay ni. Naŋ nakəŋ àra ècia ma na nahkay ti àzuma ɓəruv a, àhi ana bay məgri tʉwi ni ahkado : “Ru piŋ a kəsa vu, kəhəlbiya ndam ya kədi ahàr ana tay e mite bu na ɗek. Ku ndam talaga, ku ndam dəra, ku ndam wuluf akaba ndam jigwer ɗek, həliyu tay a ahay goro vu.” ");
INSERT INTO muy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bay məgri tʉwi nakəŋ àra àgra tʉwi nana ti àra àhi ana bay məgur naŋ ni ahkado : “Bay goro, tʉwi gayak ni àgrava, ay ti məlaŋ manjəhaɗani àgəjənia kekileŋa.” ");
INSERT INTO muy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Eslini bay nakəŋ àhi ana bay məgri tʉwi ni ahkado : “Ru a huɗ gili vu akaba a vədaŋ vu. Ndam ya ti akədi ahàr ana tay ni ti garubiya tay a, nahkay day kwa ti ahay goro ni amara mərəhvu. ");
INSERT INTO muy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nəhi ana kʉli nahəma, ndam ya ti nə̀zalay tay, tàcuhway marana ndo ni ti ku bəlaŋ gatay tekeɗi amacakay zlam ga wuməri goro ni do simiteni.” » ");
INSERT INTO muy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yezu àra àsləka eslina ti mis dal-dal tàɗəboru naŋ e divi vu. Nahkay naŋ nakəŋ àmbatkibiyu ma ka tay, àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","« Tamal ti maslaŋa ara, awayay maɗəbay nu nahəma, maslaŋa nani si awayay nu kay àtama bəŋana ata məŋana kwa. Si maslaŋa nani awayay nu kay àtama wal gayaŋ a, àtama bəza gayaŋ akaba bəza ga məŋani zawalani akaba walani daya kwa. Si maslaŋa gani nani awayay nu kay àtama ahàr gayaŋ gayaŋana daya kwa. Tamal àgray nahkay ndo nahəma, èsliki maɗəbay nu koksah. ");
INSERT INTO muy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Maslaŋa ya ti àgəskabu daliya do ni ti èsliki maɗəbay nu do. Ku tamal tawayay *madarfəŋ naŋ kà təndal nəŋgu ni, ahàr àɗəm mâɗəbay nu. Tamal àgray nahkay do ni ti èsliki maɗəbay nu koksah. ");
INSERT INTO muy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","« Bi maslaŋa e kiɗiŋ gekʉli bu awayay aləm ahay zəbalani. Maslaŋa nani anjəhaɗ digʉs aslaslay ahàr, asərkaba siŋgu ya àfəŋ ga mendeveriŋaba tʉwi ga ahay gayaŋ na day. Agray nahkay day tək, àgray do aw ? ");
INSERT INTO muy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tamal àslaslay ahàr gayaŋ day ndo ni ti bi afəkaɗ asak ga ahay ni ciliŋ, èsliki mendeveriŋ tʉwi gayaŋ ni koksah. Mis etipia èndeveriŋ ahay ni ndo ni ti atəbi seki, ");
INSERT INTO muy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","atəɗəm ahkado : “Aw ! Maslaŋa hini àfəkaɗa asak ga ahay gayaŋ a, èsliki məlumabana ndo timey !” ");
INSERT INTO muy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","« Nahkay day, bi bay ga kəsa nahaŋ awayay akoru akaɗvafəŋva kà bay ga kəsa nahaŋ a. Bay nani anjəhaɗ digʉs ga məgri sawari ana ahàr gayaŋ day, ahi ana ahàr : “Mis goro dəbu kru, bay nahaŋ ni ndam gayaŋ dəbu kru kru cʉ ni ti nisliki moru makaɗvani ata naŋ tata aw ?” Ahi ana ahàr nahkay day tək, àɗəm do aw ? ");
INSERT INTO muy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tamal ti àsəra emisliki do nahəma, aslərkioru mis ka bay nahaŋ ni ka ya ti naŋ àbu driŋ mba ni, ge mihindifiŋa ere ya naŋ awayay ti tâŋgalabu na. ");
INSERT INTO muy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","« Nahkay zla nahəma, tamal maslaŋa e kiɗiŋ gekʉli bu awayay aɗəbay nu ti si ambrəŋ zlam gayaŋ ɗek day kwa, do ni ti èsliki maɗəbay nu koksah. » ");
INSERT INTO muy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yezu àhi ana tay keti : « Estena ti zlam sulumani. Ay tamal àcər va do ni ti təgri mam ti mə̂cər keti ni mam ? Àbi. ");
INSERT INTO muy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nahkay egi àɓəlay va do. Ku ga magray argwa ga məbəkiani ka vədaŋ day àɓəlay va do. Mis taboru ke jigʉri ciliŋ. Tamal maslaŋa slimi àfəŋ ge mici zlam nahəma, mîci lala. » ");
INSERT INTO muy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ndam *məhəl hadam akaba ndam magudar zlam ndahaŋ tə̀rəkia ka Yezu a ga məbi slimi ana pakama gayaŋ ya àhi ana mis na. ");
INSERT INTO muy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ndam *Feriziyeŋ akaba ndam *məsər Wakita ge Melefit tàra tìpia tay a nahəma, təŋguzay ma e kiɗiŋ gatay bu, tə̀ɗəm : « Naŋ hini ti agəskabu ndam magudar zlam, təzumkabu zlam ka ahar bəlaŋ akaba tay timey ! » ");
INSERT INTO muy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Eslini Yezu àhi ma ana tay àna ma *gozogul, àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","« Bi maslaŋa e kiɗiŋ gekʉli bu təmbəmbak gayaŋ tə̀bu diŋ mək bəlaŋ gani èjia. Àra èpia ti bəlaŋ gani àkibu ka ndahaŋ ni bi nahəma, ambərbu kru kru ambəlmbu mahar ambəlmbani ni a huɗ gili bu. Akoru aɗəboru bəlaŋani ni, àdia ahàr a day kwa ti ambrəŋ maɗəbani. Way àgray nahkay do ni way ? ");
INSERT INTO muy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ka ya ti àdia ahàr a nahəma, amərvu, azakababiyu ke mejeŋgel. ");
INSERT INTO muy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Àra ènjia a magam a ti azalakabu zləbəba gayaŋ akaba ndam mahay gayaŋ. Tàra tìnjia ti ahi ana tay ahkado : “Nə̀dia ahàr ana təmbak goro ya ti èji na, nihi ti məmərumvu, do ni ti ahəmamam.” ");
INSERT INTO muy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nəhi ana kʉli nahəma, nahkay day ku bay magudar zlam naŋ bəlaŋ tamal àmbatkaba majalay ahàr gayaŋ a ti Melefit akaba məslər gayaŋ atəmərvu e melefit bu. Atəmərvu àna naŋ kay àtama məmərvani ya təmərvu àna ndam jireni kru kru ambəlmbu mahar ambəlmbani ya wudəra gatay àbi ga mambatkaba majalay ahàr gatay a bi ni. » ");
INSERT INTO muy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yezu àhi ana tay keti : « Nahkay day, bi wal nahaŋ naŋ àbu àna grusu kru, èjifiŋa bəlaŋ. Àra èpia ti siŋgu ni èjia nahəma, àdəki aku ke ceŋgel, àsləɗ ahay gayaŋ ɗek. Aɗəbay siŋgu ni lala, àdia ahàr a day kwa ti ambrəŋ maɗəbani. ");
INSERT INTO muy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Àra àdia ahàr a ti azalakabu zləbəba gayaŋ akaba wál mahay gayaŋ. Tàra tìnjia ti ahi ana tay ahkado : “Nə̀dia ahàr ana grusu goro ya èji na, nihi ti məmərumvu, do ni ti ahəmamam.” ");
INSERT INTO muy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nəhi ana kʉli nahəma, nahkay day ku bay magudar zlam bəlaŋ tamal àmbatkaba majalay ahàr gayaŋ a ti *məslər ge Melefit atəmərvu. » ");
INSERT INTO muy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yezu àhi ana tay keti : « Zal nahaŋ àbu, bəza gayaŋ zawalani bebem cʉ. ");
INSERT INTO muy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A vaɗ nahaŋ zla nahəma, naŋ gʉziteni ni àhi ana bəŋani ahkado : “Bəba, dikaba elimeni gayak na ana leli a ti nəhəl ere gani goro.” Nahkay bəŋ gatay ni èdikaba elimeni gayaŋ na ana tay a. ");
INSERT INTO muy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Àra àgra vaɗ a ɓal ka ahàr gana zla ti naŋ gʉziteni nakəŋ àhəl ere ga zlam gayaŋ ni, àsəkumoru ɗek, àsləka àna siŋgu gana, òru ka haɗ driŋeni zlam gayaŋ. Òru ènjʉa ka haɗ nana ti ègwejelekaba siŋgu gayaŋ na ɗek a magray paraw ba. ");
INSERT INTO muy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","« Siŋgu ni àra àndavfəŋa ɗek nahəma, lʉwir ti ni àdaya ka haɗ nana kay. Lʉwir ni àra àdaya ti naŋ nakəŋ àŋgət zlam va do. ");
INSERT INTO muy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nahkay òru ga məgri tʉwi ana mis ka haɗ nani. Maslaŋa nani àhi môru mə̂jəgi mədrə́s e gili. ");
INSERT INTO muy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Awayay məzum zlam məzumani ga mədrə́s ni ti mə̂rəh àna naŋ, ay ti maslaŋa àbi avi bi. ");
INSERT INTO muy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Eslini naŋ nakəŋ àjalaki ahàr ka manjəhaɗ gayaŋ, àhi ana ahàr : “Mis ya tə̀bu təgri tʉwi ana baba goro ni ɗek tə̀bu təzum zlam pazaza, àgəjənifəŋa kà tay a. Nu zla ti nəmət ahalay àna lʉwir ti ahəmamam. ");
INSERT INTO muy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nihi ti nasləka naŋgoru a magam afa ga baba goro. Eninjʉa ti anəhi ahkado : Bəba goro ni, nàgudaria zlam ana Melefit a, nak day nàgudaruka zlam a. ");
INSERT INTO muy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Àgəski ti kàzalay nu wur gayak va ba, mənjalu akaɗa nu bay məgruk tʉwi ciliŋ.” ");
INSERT INTO muy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nahkay àsləka, naŋ àbu aŋgoru a magam afa ga bəŋani nakəŋ. « Naŋ àbu ara e divi ba driŋ mba nahəma, bəŋani àsəraya naŋ a, àsia cicihi a dal-dal. Bəŋani ni àcuhwakioru, àgəskabu naŋ gum, àgri sa àna məmərani. ");
INSERT INTO muy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Wur ni àhi ahkado : “Bəba goro ni, nàgudaria zlam ana Melefit a, nak day nàgudaruka zlam a. Àgəski ti kàzalay nu wur gayak va ba.” ");
INSERT INTO muy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Eslini bəŋani àhi ana ndam məgri tʉwi ni ahkado : “Dəgum piŋ kəzumbiya azana sulumani ya àtam ndahaŋ na ni, ti kə̂fumki. Fumiviyu mili a ahar vu, kə̂bumiviyu kimaka a asak vu daya. ");
INSERT INTO muy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Dəgum kêpicehʉmbiya wur sla magalani na, ti kîsliŋʉmi. Məgrum wuməri, məzum zlam àna məmərani, do ni ti ahəmamam. ");
INSERT INTO muy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aɗaba wur goro hini ti àməta, ay ti àŋgaba ; èjija, ay ti nə̀dia ahàr a.” Bəŋani ni àra àɗəma nahkay ti tə̀njəki ka magray wuməri àna məmərani. ");
INSERT INTO muy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","« Nday tə̀bu tagray wuməri nahkay ti wur gəɗakani ni naŋ àbiyu e gili. Naŋ àbu asləkabiya ènjia cifa a magam a nahəma, èci zlam ya mis tivi ni akaba həɓay gatay ya tahəɓay ni. ");
INSERT INTO muy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naŋ nakəŋ àzalay maslaŋa nahaŋ naŋ àbu agri tʉwi ana bəŋani, èhindifiŋa ma, àhi ahkado : “Mam àgravu a magam mam ?” ");
INSERT INTO muy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Maslaŋa nani àhəŋgrifəŋ, àhi ahkado : “Wur ga muk ni àsləkabiya, mək buk èsliŋa wur sla ya màgal na, aɗaba àdia ahàr ana wur na naŋ àbu njənjalaŋ.” ");
INSERT INTO muy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wur gəɗakani ni àra ècia ma na nahkay ti àzuma ɓəruv a, àcuhway məhuriyani a ahay vu do. Bəŋani àra ècia wur gayaŋ ni àcuhway məhuriyani a ahay vu do nahəma, àhərkiaya e mite va àdabakay naŋ ti mə̂huriyu a ahay ni vu. ");
INSERT INTO muy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nahkay wur ni àhəŋgrifəŋ ana bəŋani ni, àhi ahkado : “Ci day ! Agray vi ehimeya nu nə̀bu nəgruk tʉwi, ɗay-ɗay nə̀dukia asak ka ma gayak a ndo. Akaba nani ɗek ɗay-ɗay kə̀vu ku wur ga awak ga magray wuməri akaba zləbəba goro ndo. ");
INSERT INTO muy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ay nihi ti wur gayak ni ègwejelekababiya elimeni gayak na a wál ba. Akaba nani ɗek ti kìsliŋia wur sla ya màgal na !” ");
INSERT INTO muy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ay bəŋani àhi ahkado : “Wur goro, leli makakabu kəlavaɗ ata nak timey. Elimeni goro ni ɗek ti gayak, do ni ti ga way ? ");
INSERT INTO muy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ay ahàr àɗəm magray wuməri àna məmərani, aɗaba wur ga muk ti àməta, ay ti àŋgaba ; èjija, ay ti mə̀dia ahàr a.” » ");
INSERT INTO muy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","A vaɗ nahaŋ Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Zal nahaŋ àbu nahəma, naŋ bay ge elimeni. Naŋ àbu àna bay məgri tʉwi ; tʉwi gayaŋ ti ga maŋgahi siŋgu. A vaɗ nahaŋ maslaŋa nahaŋ àrəkia ka bay ge elimeni na, àhi ahkado : “Bay maŋgahuk siŋgu ni ti naŋ àbu ejiŋ elimeni gayak ni.” ");
INSERT INTO muy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bay ge elimeni ni àra ècia nahkay ti àzalay bay məgri tʉwi ni, àhi ahkado : “Pakama ya nìci, mis tə̀ɗəmkuk ni ti àsu bi. Nihi ti slaslukabu siŋgu goro ni ka wakita ti kə̂vu wakita gani, aɗaba nara nizligaba kur e tʉwi ni ba.” ");
INSERT INTO muy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Bay magray tʉwi nakəŋ àra ècia tə̀hia ma na nahkay ti àɗəm : “Bay ya nəgri tʉwi ni ara ezligaba nu e tʉwi ni ba ni ti anagray ahəmamam ? Njəɗa goro day àbi ga məwəs vədaŋ bi, mahəŋgalay zlam day mimili awərki nu ni. ");
INSERT INTO muy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ere ye ti nagray ni ti nihi : wuɗaka tara tizligaba nu e tʉwi ni ba nahəma, nagray zlam ti mis atəgəskabu nu afa gatay ka ya ti tìzligaba nu e tʉwi ba ni.” ");
INSERT INTO muy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nahkay naŋ nakəŋ àzalabiyu ndam ya ti àkəli duwa ana tay ni ɗek bəlaŋ àna bəlaŋ. Duwa nani ya àkəli ana tay ni ti ga bay ge elimeni ni. Tàra tìnjikaba ti àhi ana maslaŋa nahaŋ e kiɗiŋ gatay bu ahkado : “Duwa ga bay ya nəgri tʉwi ni, àfuk ti ehimey ?” ");
INSERT INTO muy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Naŋ nani àhəŋgrifəŋ, àhi : “Àfu amal gurda diŋ.” Eslini bay magray tʉwi ni àhi : “Zay wakita ga duwa gayak ni, njəhaɗa digʉs bəki weceweci gurda kru kru zlam.” ");
INSERT INTO muy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mək àhi ana maslaŋa nahaŋ keti : “Nak ti àfuk ehimey ?” Maslaŋa nani àhəŋgrifəŋ, àhi : “Buhu ga *alkama àfu diŋ.” Àhi : “Zay wakita gayak, bəki kru kru azlalahkər.” ");
INSERT INTO muy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Bay ge elimeni ni àra ècia ti bay məgri tʉwi ni àgosa naŋ a nahəma, àzləbay naŋ, aɗaba ànjəhkia ka vu gayaŋ a. Nəɗəm nahəma, mis ga duniya ti tə̀njəha e kiɗiŋ gatay ba tə̀tama ga ndam ge Melefit na. ");
INSERT INTO muy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","« Nu ti ere ye ti nəhi ana kʉli nahəma nihi : Siŋgu ti agosay mis. Lekʉlʉm ti vumi ana mis ndahaŋ ti tîgi zləbəba gekʉli. Tamal kə̀gruma nahkay nahəma, ka ya ti siŋgu ni amandavfəŋa kè kʉli a ti atəgəskabu kʉli a ahay bu ; ahay gani nani ti àmbəɗ ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tamal ti mis agray tʉwi ku gʉziteni àna jiri nahəma, agray tʉwi gəɗakani àna jiri daya. Tamal agosay mis e tʉwi ku gʉziteni bu nahəma, agosay mis e tʉwi gəɗakani bu daya. ");
INSERT INTO muy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Siŋgu ti agosay mis. Nahkay tamal ti lekʉlʉm kə̀grum tʉwi ge jiri àna naŋ ndo nahəma, Melefit aməvi zlam ya sulumani eɗeɗiŋeni ni ana kʉli aw ? Aha, amavay do ! ");
INSERT INTO muy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nahkay day, tamal kə̀grum tʉwi ge jiri àna zlam ge mis ndahaŋ ndo nahəma, Melefit aməvi zlam gekʉli gekʉleni ana kʉli aw ? Aha, amavay do ! ");
INSERT INTO muy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","« Maslaŋa àbi esliki məgri tʉwi ana bay ahay cʉ bi. Emizirey bəlaŋ gani, amawayay naŋ nahaŋ ni, ahkay do ni aməgəsiki ma ana nahaŋ ni do, ana naŋ nahaŋ ni ti ni aməgəsiki ma. Lekʉlʉm day tamal kəɗəbum siŋgu hi hi ti kìslʉmki məgri tʉwi ana Melefit koksah. » ");
INSERT INTO muy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ndam *Feriziyeŋ ndahaŋ tàra tìcia ma ga Yezu ya àɗəm na ɗek ti tèyefiŋ, aɗaba nday tawayay siŋgu gəɗak. ");
INSERT INTO muy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eslini Yezu àhi ana tay ahkado : « Lekʉlʉm nahəma, kè eri ge mis ti kəɗəmum lekʉlʉm ndam jireni. Ay ti Melefit àsəra ere ye ti a huɗ gekʉli bu na. Zlam ya ti mis tə̀ɗəm zlam gəɗakani ni, kè eri ge Melefit ti zlam nani zlam magədavani àɓəlay do simiteni. » ");
INSERT INTO muy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yezu àɗəm keti : « *Divi ge Melefit ya Mʉwiz àbəki ni akaba pakama ga ndam ndahaŋ ya tàhəŋgaray *pakama Melefit ni ti mis tə̀bu tagray tʉwi àna naŋ duk àbivu ana sarta ge Zeŋ bay məbaray mis ni. Kwa ka sarta gani nani tə̀bu təhi *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit ana mis. Məgur ge Melefit ti ku way way do day akaɗvu àna njəɗa gayaŋ ɗek ga məhuriyani. ");
INSERT INTO muy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ku tamal nahkay nəŋgu ni, huɗ melefit akaba haɗ ni ɗek atəndav, ay asak ma ge Divi ge Melefit ya Mʉwiz àbəki ni ku gʉziteni nəŋgu ni mandav gani zləzlaɗa. ");
INSERT INTO muy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","« Ku way way do àgara wal gayaŋ a, mək àda wal nahaŋ a nahəma, maslaŋa nani àgra hala. Tamal maslaŋa nahaŋ àza wal ya ti zal gani àgara naŋ na ti maslaŋa nani day àgra hala. » ");
INSERT INTO muy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yezu àɗəm keti : « Zal nahaŋ àbu naŋ bay ge elimeni. Abakabu azana sulumani ga siŋgu kayani, kəlavaɗ agray wuməri àna zlam məzumani məcərani kayani ni. ");
INSERT INTO muy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Zal nahaŋ àbu, slimi gani Lazar. Naŋ zal talaga, andəhaɗ kəlavaɗ kà mahay ga bay ge elimeni ni. Vu gayaŋ ni ɗek ambələk. ");
INSERT INTO muy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Awayay ti azum zlam ya adəgaya adəgafəŋa kà məlaŋ məzumki zlam ga bay ge elimeni na, ay ti tə̀vi do. Kərá tara tindigiɗ ambələk gayaŋ ni sawaŋ. ");
INSERT INTO muy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","A vaɗ nahaŋ zal talaga nakəŋ àməta. Àra àməta zla nahəma, *məslər ge Melefit tə̀zoru naŋ afa ge Melefit ti tânjəhaɗkabu akaba Abraham. Bay ge elimeni nakəŋ àməta daya, nahkay tìleba naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tàra tìleba naŋ a ti òru a məlaŋ ge *kisim vu, eslini naŋ àbu acakay daliya dal-dal. Naŋ àbu eslini ti àmənjoru agavəla, èpioru Abraham nday ata Lazar manjəhaɗkabani. ");
INSERT INTO muy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Àra èpia tay a ti àzlah, àhi ana Abraham ahkado : “Abraham baba goro ni, nə̂suk cicihi ti ! Kam-kam slərbiyu Lazar ti mə̂təlviyu weleher gayaŋ a yam vu ti mə̂fuki ka arəɗ ga məvu liŋ-liŋeni, aɗaba nu nə̀bu ahalay a aku bu, nagray daliya dal-dal.” ");
INSERT INTO muy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ay Abraham àhəŋgrifəŋoru, àhi : “Wur goro ni, sərki ti a manjəhaɗ gayak bu ka dala ahaslani ti kə̀ŋgəta zlam sulumana dal-dal, ay Lazar ti ni àgra daliya dal-dal. Nihi nahəma, naŋ àbu aŋgət zlam sulumani ga məhəŋgrivu ɓəruv, nak ti ni kacakay daliya. ");
INSERT INTO muy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Akaba nani ɗek nəŋgu ni, *eviɗ gəɗakani àbu e kiɗiŋ geli bu akaba kʉli. Nahkay maslaŋa ya ti ecik ahalay akoru afa gekʉli ni ti èsliki do. Maslaŋa ya ti ecikbiyu afa gekʉli ara afa geli a ni day èsliki do.” ");
INSERT INTO muy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bay ge elimeni nakəŋ àhəŋgrifəŋ, àhi ahkado : “Tamal nahkay ti nahəŋgalay kur kam-kam baba goro ni, sləroru Lazar a magam afa ga bəŋ goro, ");
INSERT INTO muy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","aɗaba bəza ga mmawa tə̀biyu eslini nday zlam. Hi ana Lazar ti môru mə̂hivu ana tay ti tàra ka məlaŋ ga daliya hini va ba daya.” ");
INSERT INTO muy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham àhi ahkado : “Nday tə̀bu àna wakita ge Mʉwiz akaba wakita ga ndam ndahaŋ ya tàhəŋgaray *pakama ge Melefit ni. Ahàr àɗəm təbi slimi ana pakama ya a wakita nday nani bu ni lala.” ");
INSERT INTO muy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bay ge elimeni nakəŋ àhəŋgrifəŋ, àhi : “Aha, Abraham baba goro ni, nahkay do. Ay tamal maslaŋa àŋgaba e kisim ba, arəkioru ka tay, ahivù ma gani ana tay nahəma, atambatkaba majalay ahàr gatay na.” ");
INSERT INTO muy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ay Abraham àhi ahkado : “Tamal tə̀bi slimi ana pakama ge Mʉwiz akaba ga ndam ndahaŋ ya tàhəŋgaray pakama ge Melefit ni do nahəma, ku tamal maslaŋa mâŋgaba e kisim ba, mə̂hi pakama ana tay nəŋgu ni, tìciiki do simiteni.” » ");
INSERT INTO muy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yezu àhi ma ana ndam maɗəbay naŋ ni keti, àhi ana tay ahkado : « Zlam ya ejiŋkia mis ke divi a ni ti tə̀bu. Ŋgay tə̀bi ti àɗəmvu koksah. Ay tamal maslaŋa agray zlam ya ti ejiŋkia mis ke divi a nahəma, maslaŋa nani cicihi amələki, ");
INSERT INTO muy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","hojo təwəliviyu avar gəɗakani a dəŋgu vu dondul mək tizligiyu naŋ a *dəluv gəɗakani vu dəzləz. Ndam ya təfəku ahàr, mis tə̀ɗəm tìsli araŋa do akaɗa ga bəza ciɓ-ciɓeni ni ti, tamal ti maslaŋa agray ti ku way way do e kiɗiŋ gatay bu mîjikia ke divi a nahəma, hojo tə̂gri nahkay. ");
INSERT INTO muy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nahkay ti bumi slimi ana ahàr gekʉli ! « Tamal wur ga muk àgudaruka zlam a ti hiki lala. Tamal àsərkia ka zlam magudarani gayaŋ na, àɗəm “Nàgray va do” nahəma, mbərfəŋa. ");
INSERT INTO muy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ku tamal àgudaruka zlam a sak adəskəla a vaɗ ba mək ara afa gayak a sak adəskəla ahuk : “Nə̀sərkia ka zlam ya nàgudaruk na, nàgray va do” nahəma, mbərfəŋa. » ");
INSERT INTO muy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ndam *asak ga Bay geli Yezu tə̀hi ana Yezu ahkado : « Mawayay kâgray ti mə̂fəki ahàr ke Melefit àkivu ti. » ");
INSERT INTO muy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bay geli àhəŋgrifəŋ ana tay, àɗəm ahkado : « Ku tamal məfəki ahàr gekʉli ke Melefit kay do, àbu gʉzit akaɗa hilfi ga zlam gʉziteni ciliŋ nəŋgu ni, kislʉmki məhiani ana məŋ ga zlam hini : “Raɗvaba, kâru kânjəhaɗ a *dəluv gəɗakani vu” nəŋgu ni, amagravu. » ");
INSERT INTO muy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yezu àɗəm keti : « Bi mis e kiɗiŋ gekʉli bu bay məgri tʉwi gayaŋ naŋ àbu awəs vədaŋ ahkay do ni ahətay zlam. Tamal àsləkabiya e gili na ti bay ahay ni ahi ahkado : “Ra kânjəhaɗa weceweci, kə̂zum zlam” aw ? ");
INSERT INTO muy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aha ! Ahi ahkado : “Dʉaya zlam məzumana. Kìdia ti kâmbatkabu azana, kə̂həlubiya zlam məzumani na. Kə̀həlubiya ti cika kà gəvay goro a ga məhəlubiyu zlam ndahaŋ ya nawayay na. Ka ya ti anəzuma akaba enisia goro a nahəma, nak akəzum akaba ekisi gayak.” Bay ahay ni aməhi nahkay sawaŋ do aw ? ");
INSERT INTO muy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bay magray tʉwi ni tamal àgra tʉwi ya tə̀hi na ti bay ahay ni agri sʉsi aw ? Àgri do. ");
INSERT INTO muy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nahkay lekʉlʉm day tamal kə̀gruma tʉwi ya Melefit àhi ana kʉli grum na ti ɗəmum : “Leli ndam məgri tʉwi ana Melefit ciliŋ. Ere ye ti àhi ana leli grum ni, màgra àndava.” » ");
INSERT INTO muy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ka ya ti Yezu akoru a Zerʉzalem nahəma, asləkaba gwar ke ekwi ga haɗ *Samari nday ata haɗ *Gelili a. ");
INSERT INTO muy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Naŋ àbu ahuriyu a kəsa nahaŋ vu ni ti ndam ambələk kru tə̀rəkia, tìcik cak. ");
INSERT INTO muy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Tə̀zlah, tə̀ɗəm : « Yezu gəɗakani geli, mə̂suk cicihi ti. » ");
INSERT INTO muy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yezu nakəŋ àra èpia tay a ti àhi ana tay ahkado : « Dəgum afa ga ndam *maŋgalabakabu mis akaba Melefit ni, ti tamənjaki ke kʉli. » Ka ya ti nday tə̀bu takoru nahəma, tàŋgaba, tìgia mis njəlatana. ");
INSERT INTO muy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Bəlaŋ gatay àra èpia àŋgaba ti àŋgəkibiyu ka Yezu, àzləbabiyu Melefit àna zlahay. ");
INSERT INTO muy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Àra ènjikia ka Yezu a ti àbəhaɗi mirdim, meleher ndiɓ ana haɗ, àgri sʉsi dal-dal. Zal nani ti zal Samari. ");
INSERT INTO muy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yezu àɗəm : « Mis tìgi njəlata ti nday kru do aw ? Ay nday ambəlmbani ni nday eley ? ");
INSERT INTO muy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","E kiɗiŋ gatay ambəlmbani ni bu ni ti mis àbi aŋga agri sʉsi ana Melefit bi aw ? Si zal madurlaŋ hini ciliŋ ni ! » ");
INSERT INTO muy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eslini Yezu àhi ana maslaŋa ya àŋgəkia ni : « Cikaba, ru a magam. Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. » ");
INSERT INTO muy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ndam *Feriziyeŋ ndahaŋ tə̀rəkia ka Yezu a, tə̀hi ahkado : « *Məgur ge Melefit ti amənjəki ananaw ? » Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Məgur ge Melefit anjəki nahəma, èpivu do. ");
INSERT INTO muy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nahkay atəɗəm : “Naŋ hi !” ahkay do ni : “Naŋ tegi !” do. Nəɗəm nahəma, Məgur ge Melefit ti ànjəkia e kiɗiŋ gekʉli ba àndava. » ");
INSERT INTO muy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Sarta nahaŋ amara ti akawayum mipi nu *Wur ge Mis ku vaɗ bəlaŋ, ay ti ekipʉm nu do. ");
INSERT INTO muy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka sarta gani nani atəhi ana kʉli : “Naŋ tegi !” ahkay do ni “Naŋ hi !” Ay tamal tə̀hia ana kʉli a nahkay ti kə̀dəgum ba, kə̀ɗəbum tay ba. ");
INSERT INTO muy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aɗaba mam, ka fat ya ti nu Wur ge Mis anaŋga nahəma, mis etipi nu akaɗa ga avər ya abay aku, aslaɗay huɗ melefit ɗek ni. ");
INSERT INTO muy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ay wuɗaka anaŋga ti ahàr àɗəm mis ye e hini vu ni tə̀gəskabu nu do, tə̂gru daliya dal-dal day kwa. ");
INSERT INTO muy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ere ye ti àgravu ke zemeni ge Nʉwi ni amagravu ka fat ya ti nu Wur ge Mis anaŋga ni. ");
INSERT INTO muy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ke zemeni gani nani ti mis tə̀bu təzum zlam, tisi zlam, taday wál, wál day taday zawal. Nday tə̀bu tagray zlam nday nani nahkay duk àbiviyu ana vaɗ ya ti Nʉwi àhuriyu a *slalah ga yam gəɗakani vu ni. A vaɗ gani nani ti yam àrəhvù məlaŋ ɗek, èziŋeba mis na ɗek kəɗap. ");
INSERT INTO muy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amagravu akaɗa ya àgravu ke zemeni ga *Lot ni daya. Ke zemeni gani nani ti mis tə̀bu təzum zlam, tisi zlam, təsəkum zlam, təsəkumoru zlam, tajav zlam, tələm ahay. ");
INSERT INTO muy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ay ka fat ya ti Lot àsləka a *Sodom a ni ti aku akaba zlam nahaŋ ya aku agəs akaɗa ga asas ya aku agəs ni dal-dal àdəgakia ka ndam ga kəsa nana kwa e melefit ba akaɗa ga avər ya atəɗ na, èviyekaba tay a ɗek. ");
INSERT INTO muy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nahkay ka fat ya ti Melefit amaŋgazli nu Wur ge Mis ana mis ɗek nahəma, zlam gani amagravu ka məsərki gatay do. ");
INSERT INTO muy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","« Ka fat gani nani ti tamal mis nahaŋ naŋ àbu ka *dalahar ga ahay gayaŋ, zlam gayaŋ tə̀vu a ahay bu nahəma, àhəraya, àhuriyu a ahay vu ga məhəlaya zlam gayaŋ a day ba. Nahkay day maslaŋa ya ti naŋ e gili ni àŋga a magam a ba, mâcuhway hʉya. ");
INSERT INTO muy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nəɗəm nahəma, ere ye ti àgrakivu ka wal ga Lot ni ti àgəjazlki ahàr ke kʉli ba ! ");
INSERT INTO muy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Maslaŋa ya ti awayay ajəgur sifa gayaŋ ti àmət ba ni ti emijiŋ, ay maslaŋa ya ti emijiŋ sifa gayaŋ nahəma aməjəgur sawaŋ, aməmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nəhi ana kʉli nahəma, ka ya ti anaŋga ni ti ku tamal mis cʉ nday ka slalah bəlaŋ ga məlavaɗ nəŋgu ni atazay bəlaŋ gani, atəmbərbu nahaŋ ni ti amagravu tata. ");
INSERT INTO muy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ku tamal wál cʉ tihikabu humbu ka ahar bəlaŋ nəŋgu ni, atazay bəlaŋ gani, atəmbərbu nahaŋ ni ti amagravu tata.  ");
INSERT INTO muy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ku tamal zawal tə̀bu e gili ka ahar bəlaŋ nəŋgu ni, atazay bəlaŋ gani, atəmbərbu nahaŋ ni ti amagravu tata. » ");
INSERT INTO muy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yezu àra àɗəma pakama nana ti ndam maɗəbay naŋ ni tə̀hi ahkado : « Bay geli, ere gani nani amagravu ti eley ? » Yezu nakəŋ àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Nəhi ana kʉli nahəma, ka məlaŋ ya zlam məmətani àvu ni ti mambá təcakalavu eslini. » ");
INSERT INTO muy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yezu àhi ma *gozogul ana ndam maɗəbay naŋ ni, ti tâhəŋgalay Melefit a sarta bu ɗek kəlavaɗ, tə̀mbrəŋ ba simiteni. ");
INSERT INTO muy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Àɗəm ahkado : « Bay magray seriya nahaŋ àbu a kəsa nahaŋ bu. Bay gani nani ti àdi slimi ana mis do ; ku Melefit day aŋgwaz àwərfəŋa naŋ a do. ");
INSERT INTO muy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A kəsa gani nani bu nahəma, wal madakway nahaŋ àbu. Wal nani àra sak ehimeya afa ga bay magray seriya na, àhi ahkado : “Maslaŋa nahaŋ àgudarua zlam a, ay ti nawayay ti kəgru seriya gani.” ");
INSERT INTO muy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naŋ gani sak ehimeya àcuhway məgri seriya ni ndo. Ay a vaɗ nahaŋ zla nahəma, bay magray seriya nakəŋ àɗəm ahkado : “Ku tamal nàgrafəŋa aŋgwaz kè Melefit a do, nə̀di slimi ana mis do nəŋgu ni, ");
INSERT INTO muy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","wal madakway hini ti ahəlu muru, hojo nəgri seriya gayaŋ ni. Do ni ti wal ni naŋ àbu ara nahkay ti anəŋgətfəŋa ahàr a do.” » ");
INSERT INTO muy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Eslini Bay geli àɗəm ahkado : « Bay magray seriya nani ti mis jireni do. Ay cʉm pakama gayaŋ ya àɗəm ni ! ");
INSERT INTO muy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Naŋ tekeɗi àgray nahkay ti Melefit naŋ jireni ni ti aməgri jiri gayaŋ ana ndam ya àdaba tay a ni do aw ? Aməgri ana tay, aɗaba tə̀bu tahəŋgalay naŋ məlafat akaba məlavaɗ gani do ɗek. Amamənjaləŋ ana tay àna eri ahkay ciliŋ aw ? Aha ! ");
INSERT INTO muy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nəhi ana kʉli nahəma, aməgri jiri gayaŋ ana tay ke weceweceni hʉya. Ay ka ya ti nu *Wur ge Mis anaŋga a məlaŋ va ni ti anədi ahàr ana mis ya təfəki ahàr ke Melefit ni aw ? » ");
INSERT INTO muy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yezu àɗəm ma *gozogul nahaŋ keti. Àhi ana ndam ya ti tə̀ɗəm nday ndam jireni, tamənjaləŋ kè mis ndahaŋ akaɗa tə̀sər zlam do ni. Àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","« A vaɗ nahaŋ ndam ndahaŋ nday cʉ tə̀huriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu ga mahəŋgalay Melefit. Bəlaŋ gani zal *Feriziyeŋ, naŋ nahaŋ ni ti ni bay *məhəl hadam. ");
INSERT INTO muy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Eslini ti zal Feriziyeŋ ni ècik jik, àhəŋgalay Melefit a məɓəruv gayaŋ bu, àɗəm ahkado : “Bay Melefit goro ni, nəgruk sʉsi aɗaba nu ti akaɗa ge mis ndahaŋ ni do. Mis ndahaŋ ni ti ndam akal, ndam jireni do, ndam magray hala. Nday ti akaɗa ga bay məhəl hadam nini. ");
INSERT INTO muy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nu zla nahəma nəgəs ndəra sak cʉ a huɗ ga gosku bu ; a huɗ ga zlam goro kurani ya nəŋgət ni bu lu, nəzaba bəlaŋ, nəvuk.” ");
INSERT INTO muy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bay məhəl hadam ni ti ni ècik cak, eri tekeɗi àwayay mazoroni e melefit vu ndo, àbəki ahar duc ka məɓəruv, àɗəm ahkado : “Bay Melefit goro ni, nu bay magudar zlam, nəsuk cicihi ti.” » ");
INSERT INTO muy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Eslini Yezu àhi ana tay : « Nəhi ana kʉli nahəma, ka ya ti tàhəraya, tə̀bu takoru a magam ni ti maslaŋa ya Melefit àmbərfəŋa zlam magudarani gayaŋ na àndava ni ti nani bay məhəl hadam ni. Zal Feriziyeŋ ni ti Melefit àmbərfəŋa zlam magudarani gayaŋ na ndo. Aɗaba mam, maslaŋa ya ti àɗəm naŋ gəɗakani ni ti Melefit aməhi : “Nak gʉziteni” sawaŋ. Ay maslaŋa ya ti àɗəm naŋ gʉziteni nahəma, Melefit aməhi : “Nak gəɗakani” sək sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mis ndahaŋ tə̀həlibiyu bəza ciɓ-ciɓeni ana Yezu ti mə̂gri *sulum ge Melefit ana tay àna məbəki *ahar gayaŋ ka tay. Ndam maɗəbay naŋ ni tìpia tay a ti tə̀ləgi ana tay. ");
INSERT INTO muy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yezu àra ècia ndam maɗəbay naŋ ni tə̀bu tələgi ana mis ni ti àzalay tay, àhi ana tay ahkado : « Mbrəŋum bəza târa afa goro a, kə̀cumfəŋa tay a ba. Aɗaba mam, *Məgur ge Melefit ti ga ndam ya tə̀bu akaɗa ga bəza ni. ");
INSERT INTO muy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nəhi ana kʉli nahəma, ahàr àɗəm ku way way do mə̂gəskabu Məgur ge Melefit akaɗa ga wur gʉziteni ya eciiki slimi ana bəŋani ni. Tamal àgəskabu nahkay do nahəma, èsliki məhuriyani a *Məgur ge Melefit vu koksah. » ");
INSERT INTO muy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bay ga ndam *Zʉde nahaŋ àrəkia ka Yezu a, àhi : « Mʉsi sulumani, ti nə̂ŋgət *sifa ya àndav ɗay-ɗay do ni ti nâgray ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yezu àhəŋgrifəŋ, àhi ahkado : « Kazalay nu mis sulumani ti kamam ? Mis sulumani ti àbi, si Melefit ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ere ye ti kìhindi ni ti, *Divi ge Melefit ya àvi ana mis ni ti kə̀səra tay a do aw ? Kàgray hala ba ; kə̀kaɗ mis ba ; kìgi akal ba ; kagray sedi ti kàsəkaɗ malfaɗa ba ; həŋgrioru ahàr a haɗ ana ata buk ata muk.  » ");
INSERT INTO muy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eslini zal nakəŋ àhəŋgrifəŋ, àhi ahkado : « Divi nani ti nə̀gəskabá ɗek kwa nu a wur wurani. » ");
INSERT INTO muy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yezu àra ècia pakama gayaŋ na ti àhi ahkado : « Kekileŋa zlam àhəcukivu bəlaŋ. Səkumoru zlam gayak ɗek ti kîdi siŋgu gani ana ndam talaga. Nahkay ti akəŋgət elimeni e melefit bu. Akagra zlam nana ɗek nahəma, kâra, kâɗəbay nu. » ");
INSERT INTO muy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naŋ nakəŋ àra ècia ma ga Yezu ya àhi na ti ma gani àhəlia ahàr a, aɗaba elimeni gayaŋ àbu dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yezu àra èpia naŋ a, ahàr àbu ahəli ti àɗəm ahkado : « Ndam ge elimeni tə̂huriyu a Məgur ge Melefit vu ni ti zləzlaɗa dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ezligwemi ahuriyu e eviɗ ge lipri vu kwalac ti agravu aw ? Ay ti bay ge elimeni mə̂huriyu a Məgur ge Melefit vu ni ti zləzlaɗa dal-dal, àtama ge ezligwemi ya ahuriyu e eviɗ ge lipri vu na. » ");
INSERT INTO muy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndam ya ti tìci ma gayaŋ ya àɗəm ni tə̀ɗəm : « Ay tamal nahkay ti way ti Melefit amahəŋgay naŋ way ? » ");
INSERT INTO muy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ay Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Ere ye ti mis tàgray koksah ni, Melefit agray tata. » ");
INSERT INTO muy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyer àra ècia ma ga Yezu na ti àhi ahkado : « Iy zla, leli mə̀mbrəŋa zlam geli a, maɗəbay kur ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yezu àhi ana tay : « Nəhi ana kʉli nahəma, tamal mis àmbərba zlam gayaŋ azuhva Məgur ge Melefit a, bi àmbərbu ahay gayaŋ, wal gayaŋ, bəza ga məŋani, ata bəŋani ahkay do ni bəza gayaŋ nahəma, ");
INSERT INTO muy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","aməŋgətvù zlam nday nani kay nihi ka sarta hini. Ka məlaŋ mʉweni ya Melefit amagraya ni day aməŋgət sifa ya àndav ɗay-ɗay do ni. » ");
INSERT INTO muy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yezu àzalakabu ndam *asak gayaŋ kru mahar cʉeni ni, àhi ana tay ahkado : « Cʉm day, nihi ti leli mə̀bu məcəloru a Zerʉzalem, aɗaba zlam ya ti ndam mahəŋgaray *pakama ge Melefit tə̀ɗəmku ka nu, nu *Wur ge Mis ni ɗek amagravu ti eslini. ");
INSERT INTO muy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mis atəgəsi nu ana ndam ya tə̀fəki ahàr ke Melefit do ni. Nday gani nani eteyefʉ, etindivi nu, etitifʉviyu esliɓ e eri vu, ");
INSERT INTO muy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","atəzləɓ nu àna kurupu, atakaɗ nu, mək a vaɗ ya mahkər ti anaŋgaba. » ");
INSERT INTO muy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yezu àra àɗəma ma nahkay ti ndam asak gayaŋ ni tìciaba ndo. Ma gani nani maŋgahkiani ka tay, ma ga Yezu ya awayay aɗəm ni ti tə̀səraba ndo. ");
INSERT INTO muy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yezu nday akaba mis kay tə̀bu takoru a Zeriko, tìnjʉa wuɗak. Eslini ti zal wuluf nahaŋ naŋ àbu manjəhaɗani digʉsa kà gəvay ge divi, ahəŋgalay zlam. ");
INSERT INTO muy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Zal wuluf ni àra ècia daɗay ge mis kayani ya ti tasləkafəŋa ni ti àɗəm ahkado : « Mam agravu mam ? » ");
INSERT INTO muy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tə̀həŋgrifəŋ, tə̀hi : « Yezu zal Nazaret naŋ àbu akoru àna divi hini, do ni ti ahəmamam. » ");
INSERT INTO muy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Naŋ nakəŋ àra ècia ti àdi ana zlahay, àɗəm : « Yezu *Wur ge Devit, nə̂suk cicihi ti ! » ");
INSERT INTO muy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nday ya ti tə̀bu takoru kama ga Yezu ni tə̀ləgi ana zal wuluf ni, ti mâlakakaba. Naŋ nakəŋ àzlahkivu kay kay sawaŋ, àɗəm : « Wur ge Devit, nə̂suk cicihi ti ! » ");
INSERT INTO muy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yezu àra ècia zlahay na ti ècik, àɗəm tə̂zibiya naŋ a. Zal wuluf ni àra ènjia ti Yezu èhindifiŋa ma, àhi ahkado : ");
INSERT INTO muy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","« Kawayay ti nə̂gruk mam ? » Zal wuluf ni àhəŋgrifəŋ, àhi ahkado : « Bay goro, nawayay ti nîpi divi akaɗa ge mis ni bilegeni ti. » ");
INSERT INTO muy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yezu àhi : « Pi divi akaɗa ge mis ni. Melefit àhəŋga kur a aɗaba kə̀fəkua ahàr a palam. » ");
INSERT INTO muy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ka ma geli hini èpi divi hʉya. Naŋ àbu epi divi nahkay ti àɗəboru Yezu àna mazləbay Melefit. Mis ya tə̀bu eslini ni ɗek tàra tìpia naŋ a ti nday day tàzləbay Melefit. ");
INSERT INTO muy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yezu ènjʉa a Zeriko a. Naŋ àbu asawaɗay a huɗ ga kəsa bu. ");
INSERT INTO muy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A kəsa gani nani bu ni ti zal nahaŋ àbu, slimi gayaŋ Zese, naŋ gəɗakani ga ndam *məhəl hadam, elimeni gayaŋ àbu dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Àra ècia ti Yezu naŋ àbu ara nahəma, awayay ti mîpi naŋ. Ay ti èsliki mipi naŋ do, aɗaba àhəca àna zəbal a, mis dal-dal tìmbiva e eri va. ");
INSERT INTO muy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nahkay naŋ nakəŋ àcuhworu gwar kama ka məlaŋ ga Yezu ya akoru ni, àcəliyu a məŋ ga akram vu ti mîpi Yezu. ");
INSERT INTO muy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yezu àra ènjia ka məlaŋ nana ti àmənjoru agavəla, àhi ana Zese nakəŋ ahkado : « Zese, həraya weceweci, aɗaba kani ti si nakoru nanjəhaɗ afa gayak kwa. » ");
INSERT INTO muy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nahkay Zese nakəŋ àhəraya weceweci, tòru a magam afa gayaŋ. Tòru tìnjʉa ti àgəskabu Yezu àna məmərani. ");
INSERT INTO muy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mis tàra tìpia Yezu àdoru afa ge Zese ti tə̀ŋguzay ma, tə̀ɗəm ahkado : « Maslaŋa ya ti àdoru anjəhaɗ afa gani ni ti bay magudar zlam timey ! » ");
INSERT INTO muy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ay Zese nakəŋ ècik jik, àhi ana Bay geli ahkado : « Ci day Bay goro, nihi ti nidi telma ga zlam goro ana ndam talaga. Tamal nə̀həlfəŋa siŋgu kà maslaŋa, àtamkia ka ya akal apəl na ti anəpəlivù huɗ faɗ. » ");
INSERT INTO muy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yezu àra ècia pakama nana ti àhi ana Zese ahkado : « Kani ti nàra a huɗ ahay gayak va ti ga mahəŋgay mis. Aɗaba mam, nak day wur huɗ ga Abraham : ");
INSERT INTO muy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","nu *Wur ge Mis nàra ti ga maɗəbay ndam ya tə̀sər Melefit do ni, ti nâhəŋgay tay. » ");
INSERT INTO muy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka ya ti mis tə̀bu təbi slimi ana ma ga Yezu ya àɗəm ni ti àhi ma nahaŋ ana tay àna ma *gozogul. Àhi ma gani nani ana tay ti aɗaba ènjʉa a Zerʉzalem a wuɗak, mis day tə̀hi ana ahàr hi ti Melefit ara anjəki ka Məgur gayaŋ hʉya. ");
INSERT INTO muy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Àhi ana tay nahəma : « Mis nahaŋ àbu gəɗakani a kəsa nahaŋ bu. Awayay akoru ka haɗ driŋeni ti tə̂vibiyu bay ga mara məgur kəsa gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ara asləka wuɗak nahəma, àzalakabu mis kru e kiɗiŋ ga ndam məgri tʉwi gayaŋ ni bu, èdeki siŋgu ga gru bəlaŋ bəlaŋ ka tay, àhi ana tay ahkado : “Nu nə̀bi ti mbatumvu àna naŋ hayaŋ.” Mək naŋ nakəŋ àsləka, òru e mirkwi gayaŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Zal nani ti ndam ga kəsa gayaŋ tàwayay naŋ do. Naŋ nakəŋ àra àsləka ti tə̀sləroru mis ndahaŋ kələŋ gayaŋ ga məhi ana maslaŋa ya akoru afiyu naŋ a bay vu ni ahkado : “Naŋ hini egi bay geli ti leli màwayay do.” « ");
INSERT INTO muy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Akaba nani ɗek tə̀fiya naŋ a bay ni va sawaŋ. Kələŋ gani àsləkabiya. Àra ènjia ti àzalakabu ndam məgri tʉwi gayaŋ ya èdi siŋgu ana tay ni keti. Awayay asərkaba tàmbatva àna siŋgu na akaɗa gayaŋ ya àhi ana tay na waw. ");
INSERT INTO muy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nahkay maslaŋa ya ti enjenjeni ni àrəkia àhi ahkado : “Bay goro, àna siŋgu ya kə̀vu bəlaŋani ni ti nàmbatva àna naŋ a, nə̀ŋgətkia ndahaŋ a kru.” ");
INSERT INTO muy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Eslini bay ni àhi : “Àɓəlay, nak bay magray tʉwi sulumani. Nihi ti nəfiyu kur a bay vu, kəgur kəsa kru, aɗaba kə̀grua tʉwi sulumana àna zlam gʉziteni hini ya nə̀vuk na.” ");
INSERT INTO muy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Naŋ ye cʉ ni day àrəkia àhi ahkado : “Bay goro, àna siŋgu ya kə̀vu bəlaŋani ni ti nàmbatva àna naŋ a, nə̀ŋgətkia ndahaŋ a zlam.” ");
INSERT INTO muy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nahkay bay ni àhi ahkado : “Nak ti ni kəgur kəsa zlam.” ");
INSERT INTO muy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mək bay məgri tʉwi nahaŋ àrəkia, àhi ahkado : “Bay goro, siŋgu ya kə̀vu ni ti nihi. Nə̀wəlki ke kece-kece, nàŋgahukkaba. ");
INSERT INTO muy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nàgray nahkay ti aɗaba nàgrafuka aŋgwaz a. Nə̀səra manjəhaɗ gayak a, nak mis zləzlaɗani, kə̀mbrəŋ mis do. Zlam ya ti nak kàfəkaɗ ndo ni day kazay, zlam ya ti kìzligi ndo ni day kabaz.” ");
INSERT INTO muy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eslini bay ni àhi ahkado : “Nak ti kàgray tʉwi sulumani do. Nihi ti nagrafuka seriya akaɗa ga pakama gayak ya kə̀ɗəmaya na. Kə̀səra manjəhaɗ goro a, nu mis zləzlaɗani, nə̀mbrəŋ mis do, zlam ya ti nàfəkaɗ ndo ni day nazay, zlam ya ti nìzligi ndo ni day nabaz zla do aw ? ");
INSERT INTO muy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tamal kə̀səra nahkay ti kə̀vi siŋgu goro ni ana ndam macakalani ndo ni ti kamam ? Nihi nàsləkabiya ti amal nə̀dia ahàr a èwikia.” ");
INSERT INTO muy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mək àhi ana nday ye eslini ni ahkado : “Zumfəŋa siŋgu na, kə̂vumikivu ana maslaŋa ya ti gayaŋ kruani ni.” ");
INSERT INTO muy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi ahkado : “Siŋgu tə̀fəŋ kru àndava timey, bay geli !” ");
INSERT INTO muy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eslini àhi ana tay : “Nəhi ana kʉli nahəma, maslaŋa ya ti zlam gayaŋ àbu ni ti atəvikivu. Ay maslaŋa ya ti zlam gayaŋ àbi ni ti ku ere ye ti àfəŋ ni day atəzafəŋa. ");
INSERT INTO muy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yaw ndam ya tizirey nu, tawayay ti nə̀gur tay do ni ti gəsumubiya tay a, sliŋʉm tay kè eri goro pat pat.” » ");
INSERT INTO muy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yezu àra àɗəm ma *gozogul na nahkay ti òru kama, tə̀cəloru a Zerʉzalem akaba mis ya ti taɗəbay naŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ka ya ti tòru tìnjʉa a kəsa Betfazi ata Betani a gwar ka həma *Oliviye ni va wuɗak nahəma, Yezu àslər ndam maɗəbay naŋ ni cʉ, ");
INSERT INTO muy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","àhi ana tay ahkado : « Dəgum a kəsa tegʉni ya kama gekʉli ni vu. Ekinjʉmiya nahəma, akədumi ahàr ana wur ga azoŋgu məwəlani. Wur ga azoŋgu nani ti maslaŋa àcəlkiyu ɗay-ɗay faŋ ndo. Picehʉmbiya, zumubiya. ");
INSERT INTO muy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ay tamal maslaŋa èhindifiŋa ma kè kʉli a, àhi ana kʉli : “Kepicehʉm ti kamam ?” ti humi ahkado : “Bay geli awayay.” » ");
INSERT INTO muy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nahkay nday ya ti Yezu àslər tay ni tàsləka, tòru. Tòru tìnjʉa ti tə̀di ahàr ana zlam ni ɗek akaɗa ga pakama gayaŋ ya àhi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka ya ti nday tə̀bu tepiceh wur ga azoŋgu ni ti ndam ga azoŋgu ni tə̀hi ana tay : « Kepicehʉm wur ga azoŋgu ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eslini tə̀hi ana tay ahkado : « Bay geli awayay. » ");
INSERT INTO muy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nahkay tə̀zibiyu wur ga azoŋgu ni ana Yezu, tə̀bəki azana ti Yezu mə̂cəlkiyu, mək àcəlkiyu. ");
INSERT INTO muy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka ya ti Yezu naŋ àbu akoru ni ti mis tàpaɓivoru azana gatay e divi vu. ");
INSERT INTO muy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tòru tìnjʉa ka məlaŋ ya təndəkia ahàr ka həma Oliviye ga moroni a Zerʉzalem a nahəma, mis ya ti taɗəboru naŋ ni ɗek tə̀dəgiki ka mazləbay Melefit àna məmərani azuhva zlam ya nday tìpi, mis ndahaŋ tìpi ɗay-ɗay ndo ni. Tə̀zlah, ");
INSERT INTO muy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","tə̀ɗəm : « Bay Melefit mə̂gri sulum gayaŋ ana *bay gəɗakani ya ara àna slimi gayaŋ a ni ! Melefit naŋ agavəla àvia manjəhaɗ sulumana ana mis a. Tâzləbay naŋ a huɗ melefit bu ! » ");
INSERT INTO muy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ndam *Feriziyeŋ ndahaŋ tə̀bu eslini e kiɗiŋ ge mis dal-dalani ni bu. Tə̀hi ana Yezu ahkado : « Mʉsi, hi ma ana ndam maɗəbay kur ni ti tə̂lakakaba, tə̀zlah ba. » ");
INSERT INTO muy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yezu àra ècia pakama gatay na ti àhi ana tay ahkado : « Nəhi ana kʉli nahəma, tamal nday tə̀lakakabá ti akur atəzlah. » ");
INSERT INTO muy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka ya ti Yezu ènjʉa a Zerʉzalem a wuɗak, èpia kəsa na ti ètʉwi ndam ga kəsa nani. ");
INSERT INTO muy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Àɗəm ahkado : « Tamal ti lekʉlʉm day kə̀səruma ahəmamam kəŋgətum manjəhaɗ sulumani akaba Melefit kana nahəma, akal kə̀ŋgətuma àndava. Ay nihi ti maŋgahkiani ke kʉli, kìpʉm do. ");
INSERT INTO muy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nahkay nihi ti vaɗ gani amara, ndam ezir gekʉli atara teveliŋ kəsa gekʉli ni tekesl, atəbivu zlam ana kʉli e divi bu ɗek ga macafəŋa kʉli ga mahərana, atəhurkiyu ke kʉli àna silik. ");
INSERT INTO muy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Atabazl kʉli ɗek, etembeɗkaba ahay gekʉli a ɗek besek-besek, atəmbərki akur ka ahàr ga akur nahaŋ do. Aɗaba mam, kə̀sərum sarta ya Melefit àra àmənjaya kʉli a ni ndo. » ");
INSERT INTO muy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tòru tìnjʉa a Zerʉzalem a ti Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Eslini àdi ahàr ana ndam məsəkumoru zlam, mək ànjəki ka magaraya tay e mite va. ");
INSERT INTO muy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Àhi ana tay ahkado : « Àbu məbəkiani a Wakita ge Melefit bu, Melefit àɗəm : “Ahay goro nahəma, emigi ahay ga *mahəŋgalavù Melefit.” Ay lekʉlʉm ti kàmbatumkaba, ègia ahuzl ga ndam akal a. » ");
INSERT INTO muy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kələŋ gani naŋ àbu a dalaka ga ahay ge Melefit ni bu, acahi zlam ana mis kəlavaɗ. Eslini gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni tàɗəbafəŋ divi ge mijiŋ naŋ. Gəɗákani ga ndam *Zʉde ni day tawayay mijiŋ naŋ. ");
INSERT INTO muy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ay ti tə̀ŋgətfəŋa divi gana ndo, aɗaba ndam Zʉde ɗek tawayay ma ga Yezu, tə̀bu təbi slimi ana ma gayaŋ ya aɗəm ni lala. ");
INSERT INTO muy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yezu naŋ àbu eslini a Zerʉzalem ti a vaɗ nahaŋ àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Naŋ àbu acahi zlam ana mis, ahi *Ma Mʉweni Sulumani ana tay nahəma, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit akaba ndam *məsər Wakita ge Melefit akaba gəɗákani ndahaŋ tə̀rəkia, ");
INSERT INTO muy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","tə̀hi : « Hi ana leli, kagray tʉwi hini nahkay ti kə̀ŋgət divi gani ti eley ? Way àvuk divi gani way ? » ");
INSERT INTO muy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yezu àhəŋgrifəŋ ana tay, àɗəm : « Nu day nihindifiŋa zlam bəlaŋ kè kʉli a. Həŋgrumufəŋ : ");
INSERT INTO muy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","*baray ge Zeŋ ya àbaray mis ni ti njəɗa gani Melefit àvi tək, tək day ti mis tə̀vi aw ? » ");
INSERT INTO muy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tàra tìcia ma na nahkay ti tàgray gejewi e kiɗiŋ gatay bu, tə̀ɗəm : « Tamal məhi : “Melefit àslərbiyu naŋ” hi nahəma, ara ahi ana leli : “Kə̀gəsumkabu pakama gayaŋ ni ndo ni ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ay tamal məɗəm : “Mis tə̀vi njəɗa gani” ti ndam geli ni ɗek etizligi leli àna akur, aɗaba tə̀ɗəm Zeŋ ti bay mahəŋgaray *pakama ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nahkay tə̀həŋgrifəŋ, tə̀hi : « Maslaŋa ya ti àvi divi gani ni ti leli mə̀sər do. » ");
INSERT INTO muy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eslini Yezu àhi ana tay : « Nu day nə̀ɗəfi bay ya ti àvu divi ge tʉwi ya ti nagray ni ana kʉli do bilegeni. » ");
INSERT INTO muy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Eslini Yezu àhi ma *gozogul hini ana mis ni. Àɗəm ahkado : « Zal nahaŋ àbu nahəma, àjavù məŋ ga zlam a vədaŋ gayaŋ vu. Kələŋ gani àfivù vədaŋ ni a ahar vu ana mis ti tə̂wəs, mək àsləka, òru e mirkwi ga məpəsiyani zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sarta ga məpalay bəza ga zlam ni àra ènjia ti bay ga vədaŋ ni àslərbiyu bay məgri tʉwi afa ga ndam məwəs vədaŋ ni ti tə̂həlikaboru ja gani gayaŋ. Ay bay məgri tʉwi ni àra ènjia ti ndam məwəs vədaŋ ni tə̀gəs naŋ, tə̀zləɓ, mək tàgaray naŋ, araŋa day àzay a ahar vu ndo. ");
INSERT INTO muy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Eslini bay ga vədaŋ ni àslərbiyu bay məgri tʉwi nahaŋ keti. Àra ènjia ti ndam məwəs vədaŋ ni tìndivi naŋ cʉɗ cʉɗ, tə̀zləɓ naŋ, mək tàgaray naŋ, araŋa day àzay a ahar vu ndo daya. ");
INSERT INTO muy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bay ga vədaŋ ni àslərbiyu bay məgri tʉwi nahaŋ keti. Àra ènjia ti ndam məwəs vədaŋ ni tə̀si ambələk mək tə̀zaba naŋ a vədaŋ ni ba, tə̀təloru. ");
INSERT INTO muy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bay ga vədaŋ ni àra ècia ere ye ti àgravu na ti àhi ana ahàr : “Nihi ti nagray ni mam ? Nihi nahəma wur goro àbu, nawayay naŋ dal-dal, nəsləroru naŋ afa gatay. Eminjʉa ti atəgəsiki ma.” Nahkay àslərbiyu naŋ. ");
INSERT INTO muy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ay ndam məwəs vədaŋ ni tàra tìpia wur na naŋ àbu ara ti tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : “Naŋ tegʉni ti mekeji gayaŋ. Makaɗum naŋ ; nahkay ti vədaŋ ni emigi geli.” ");
INSERT INTO muy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Àra ènjikia ka tay a ti tə̀gəs naŋ yaw, tə̀zaba naŋ a vədaŋ ni ba, tòru tàkaɗ. » Eslini Yezu èhindifiŋa ma kà tay a, àhi ana tay ahkado : « Bay ga vədaŋ ni amasləkabiya ti aməgri mam ana ndam məwəs vədaŋ ni mam ? ");
INSERT INTO muy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Amara mabazl ndam məwəs vədaŋ ni, mək aməvi vədaŋ ni ana mis ndahaŋ. » Mis ya tə̀bu eslini ni tàra tìcia ma gayaŋ ya àɗəm na ti tə̀ɗəm : « Ere nani ti àgravu ɗay-ɗay ba ! » ");
INSERT INTO muy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Eslini Yezu àmənjaləŋ ana tay lala, àhi ana tay ahkado : « A Wakita ge Melefit bu ni ti àbu məbəkiani : “Akur nahaŋ àbu ti ndam mələm ahay tàwayay magray tʉwi àna naŋ ndo. Ay ti akur gani nani ègia akur ya akay ahay na ɗek sawaŋ.” « Ma gani nani ti lekʉlʉm kəɗəmum awayay aɗəmvaba ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Àhi ana tay keti : « Akur gani nani nahəma, tamal maslaŋa àdəɗkiya ti maslaŋa nani aməhuɓkaba ŋguc ŋguc. Ay tamal akur ni àdəkia ti ni amaŋgəlaɗkaba naŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndam *məsər Wakita ge Melefit akaba gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀səra Yezu àɗəmki ma gozogul ni ti ka tay. Tàra tə̀səra ti tàɗəbay divi ga məgəs naŋ ke weceweceni hʉya. Ay ti tìsliki məgəs naŋ ndo, aɗaba aŋgwaz àwərfəŋa tay kè mis ya tə̀bu eslini dal-dalani na. ");
INSERT INTO muy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eslini gəɗákani nday nani tə̀bu təbi slimi ana Yezu, tə̀slərkibiyu ndam gatay ndahaŋ : ndam nday nani tawayay ti Yezu mâmənjaləŋ kà tay akaɗa nday ndam jireni, tawayay ti mə̂ɗəm ma magədavani ti tə̂gəski naŋ. Gəɗákani nday nani tàgray nahkay ti aɗaba tawayay təgəsi naŋ ana bay ga ndam *Rom ya agur haɗ *Zʉde ni, ti mâgrafəŋa seriya. ");
INSERT INTO muy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nday nakəŋ tàra tìnjikia ti tə̀hi ahkado : « Mʉsi, mə̀səra nak ti ere ye ti kəɗəm akaba ya kacahi ana mis ni ti ɗek jiri. Nak ti kìcirkaba mis a do, kamənjaləŋ ana tay kala-kala, kacahi zlam ya ti Melefit awayay ni ana tay àna jiri gani ciliŋ. ");
INSERT INTO muy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nahkay ti Melefit àvia divi ana leli a ga mabəhaɗi hadam ana *bay gəɗakani ga ndam Rom a tək, àvi ana leli ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yezu àra àsərikia zuh ana tay a nahəma, àhi ana tay : ");
INSERT INTO muy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","« Ŋga ŋgazlumubiya siŋgu akur-akurana nimi. » Tàra tàŋgazlia ti àhi ana tay ahkado : « Àki ka siŋgu hini ti mazavu ga ahàr ga way ? Slimi məbəkiani ni ti ga way ? » Tə̀həŋgrifəŋ, tə̀hi : « Ga bay *Sezar. » ");
INSERT INTO muy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eslini naŋ nakəŋ àhi ana tay ahkado : « Tamal nahkay ti həŋgrumi zlam ga bay Sezar zlam gayaŋ, ge Melefit ti ni həŋgrumi ana Melefit zlam gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nahkay tìsliki məgəski Yezu ka ma magudarana kè meleher ge mis ni ndo. Ma gayaŋ ya àhi ana tay ni àgria ejep ana tay a, nahkay tə̀lakakabá te-te. ");
INSERT INTO muy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ndam *Sedʉseyeŋ ndahaŋ tə̀rəkia ka Yezu a. Ndam Sedʉseyeŋ ti tə̀ɗəm mis àməta ti àŋgaba e kisim ba koksah. Nahkay nday nakəŋ tìhindifiŋa ma, ");
INSERT INTO muy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","tə̀hi : « Mʉsi, Mʉwiz àbiki ana leli a wakita gayaŋ ni bu, àɗəm ahkado : “Tamal mis nday kà məŋ gatay, bəlaŋ gani àda wal a, mək àməta, wal gayaŋ ni èwii wur ndo nahəma, ahàr àɗəm wur ga məŋani azay wal ni, ti tîwia mekeji ana wur ga məŋani ya àmət na.” ");
INSERT INTO muy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yaw mis ndahaŋ tə̀bu adəskəla kà məŋ gatay. Gəɗakani gatay ni àda wal a, èwifiŋa wur a ndo, mək àmətkia. ");
INSERT INTO muy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Àra àməta ti mimbiki gayaŋ ni àzay wal ni àmətkia, naŋ ya mahkər ni day àgray nahkay. Nday adəskəlani ni ɗek tàza wal na, tìwifiŋa wur a ndo mək tə̀məta. ");
INSERT INTO muy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kələŋ gani wal ni day àməta. ");
INSERT INTO muy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ay ka fat ya ti mis ataŋgaba e kisim ba nahəma, wal ni ti way e kiɗiŋ gatay bu amazay way ? Nday adəskəlani ni ɗek tàza naŋ a ni. » ");
INSERT INTO muy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yezu nakəŋ àhəŋgrifəŋ ana tay, àɗəm ahkado : « Ka sarta hini ti zawal akaba wál təhəlvu. ");
INSERT INTO muy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ay nday ya ti Melefit àgəskabá tay a, atəməta mək ataŋgaba e kisim ba, atanjəhaɗ ka məlaŋ mʉweni ya Melefit amagraya ni ti zawal ataday wál va do, wəwal day ataday zawal va do. ");
INSERT INTO muy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nday gani tə̀mət ɗay-ɗay va do, tigi akaɗa ga *məslər ge Melefit ni. Nday bəza ge Melefit, aɗaba tàŋgaba e kisim ba. ");
INSERT INTO muy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ge mis ya ataŋgaba e kisim ba ni ti Mʉwiz day àbəkia ma gana a wakita gayaŋ ni ba lala. Ka sarta ya èpi məŋgəhaf ya aku àgəs ni ti àɗəm Bay geli ti naŋ Melefit ga Abraham, Melefit ga Izak, Melefit ge Zekʉp. ");
INSERT INTO muy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Melefit ti naŋ Melefit ga ndam ya àna sifa ni, do ni ti ga nday ya tə̀məta ni do. Aɗaba kè eri ge Melefit ti nday ɗek tə̀bu àna sifa. » ");
INSERT INTO muy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yezu àra àɗəma ma na nahkay ti ndam ndahaŋ ya *tə̀səra Wakita ge Melefit a ni tə̀hi : « Mʉsi, pakama gayak ya kə̀ɗəm ni ti àɓəlay. » ");
INSERT INTO muy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tə̀ɗəm nahkay ti aɗaba aŋgwaz àwərfəŋa tay ge mihindifiŋa ma ndahaŋ a. ");
INSERT INTO muy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yezu àhi ma ana tay keti. Àɗəm ahkado : « Mis tə̀ɗəm *Krist *Bay gəɗakani ya amara ni naŋ *Wur ge Devit ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aɗaba Devit àna ahàr gayaŋ àɗəm a wakita ge Limis bu : “Bay Melefit àhi ana bay goro : Njəhaɗa gwar kà ahar ga ɗaf goro a, a məlaŋ ga gəɗakani va. ");
INSERT INTO muy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ndam ezir gayak ti anabəhaɗ tay kè meleher gayak akaɗa ga zlam ga bay ya abəki asak ni, ti kə̂cəlki ka tay.”  » ");
INSERT INTO muy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","« Nəɗəm nahəma, Krist nani ti Devit azalay naŋ bay gayaŋ ti, təzalay naŋ wur ge Devit keti ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ka ya ti mis ɗek tə̀bu təbi slimi ana Yezu nahəma, Yezu nakəŋ àhi ana ndam maɗəbay naŋ ni ahkado : ");
INSERT INTO muy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","« Bumvu slimi, do ni ti ndam *məsər Wakita ge Melefit ni atagosay kʉli. Nday ti tawayay məbakabu məgudi, təsawaɗay àna naŋ riya ; tawayay ti mis təgri sa ana tay kè meleher ge mis ɗek ; tawayay manjəhaɗvani e kʉrsi ga gəɗákani vu a ahay ga *mahəŋgalavù Melefit bu akaba ka məlaŋ məzum zlam ga wuməri. ");
INSERT INTO muy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nday gani nani ti təzum ahay ga wál madakway mək təpəski ka mahəŋgalay Melefit, tawayay ti mis tə̂ɗəm nday ndam jireni. Tagray nahkay ti Melefit amagrafəŋa seriya kà tay a, amatraɓ tay àtama ga ndam magudar zlam ndahaŋ na. » ");
INSERT INTO muy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yezu èheliŋ eri, èpi ndam ge elimeni tə̀bu təbiyu siŋgu a məlaŋ məbiyu siŋgu ga sədaga ni vu. Naŋ àbu amənjaləŋ ana tay nahkay ti ");
INSERT INTO muy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","èpi wal madakway nahaŋ araŋa gayaŋ àbi, àbiyu siŋgu akur-akurani ciɓ-ciɓeni cʉ. ");
INSERT INTO muy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yezu nakəŋ àra èpia ti àɗəm ahkado : « Nəhi ana kʉli nahəma, wal madakway hini ti araŋa gayaŋ àbi, ay siŋgu ya ti àbiyu ni àtama ge mis ndahaŋ ya tə̀biyu na ɗek. ");
INSERT INTO muy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aɗaba mis ndahaŋ ni ɗek tàgray sədaga nahəma, tə̀biyu siŋgu ya tə̀gəjənifəŋ kà tay, tə̀sər ere ye ti tagray àna naŋ ni va do ni, wal hini ti ni araŋa gayaŋ àbi, ay ti àbiya siŋgu ya àfəŋ na ɗek. Siŋgu gayaŋ nahaŋ ga məsəkum zlam məzumani àgəjənifəŋ ndo. » ");
INSERT INTO muy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mis ndahaŋ tə̀bu təzlapaki ka *ahay gəɗakani ge Melefit ni. Təɗəmki ma ka akur gəɗákani ya tèɗezl ahay ni àna naŋ ni akaba zlam maɓəlani ya tə̀həlibiyu ana Melefit a ahay ni bu ni. Yezu àra ècia ma gatay na ti àɗəm : ");
INSERT INTO muy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","« Zlam hini ya kəmənjumləŋ ni ɗek ti, vaɗ nahaŋ amara nahəma, etembeɗkaba ahay na besek-besek, ku akur bəlaŋ day amanjəhaɗki ka akur nahaŋ va do. » ");
INSERT INTO muy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tàra tìcia ma ga Yezu na ti tə̀hi : « Mʉsi, ere gani amagravu ti ananaw ? Aməsərkaba sarta ya ere nani amagravu wuɗak na ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yezu àhəŋgrifəŋ ana tay, àɗəm ahkado : « Bumvu slimi, maslaŋa àgosay kʉli ba. Aɗaba mis kay atara, ku way way do aməɗəm naŋ ti nu, aməɗəm naŋ ti *Bay gəɗakani ya amara ni ; aməɗəm sarta gayaŋ ènjia. Ku təɗəm nahkay nəŋgu ni, kə̀ɗəbum tay ba. ");
INSERT INTO muy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mis atagray silik, atakaɗfəŋva kà ŋgumna daya, ekicʉm ma gani. Kìcʉma ti kə̀grum aŋgwaz ba. Ahàr àɗəm zlam nday nani tâgravu kwa. Ku tamal tàgrava nahkay nəŋgu ni, mandav ga duniya hʉya do. » ");
INSERT INTO muy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yezu àhi ana tay keti : « Ndam ga haɗ ndahaŋ atakaɗvu akaba ndam ga haɗ ndahaŋ, bəbay ndahaŋ akaba bəbay ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Haɗ amadaɗay dal-dal a kəsa ndahaŋ bu, a kəsa ndahaŋ bu lʉwir amagray, a kəsa ndahaŋ bu ni ti ni arməwər aməgəs mis kay. Zlam ndahaŋ ya tasay aŋgwaz dal-dal ni atagravu ka haɗ akaba a huɗ melefit bu, nahkay mis atəsər araŋa ara agravu wuɗak. ");
INSERT INTO muy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","« Ay wuɗaka zlam gani nday nani ɗek atagravu nahəma, mis atəgəs kʉli, atəgri daliya ana kʉli, atəhəloru kʉli a ahay ga *mahəŋgalavù Melefit vu ga magrafəŋa seriya kè kʉli a, atəbiyu kʉli a daŋgay vu. Atəhəloru kʉli kè meleher ga bəbay, kè meleher ga gəɗákani ga ŋgumna daya, aɗaba lekʉlʉm ndam goro : ");
INSERT INTO muy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","nahkay akəŋgətum divi ti etici ma gekʉli ya akazlapumku ni. ");
INSERT INTO muy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ay ere ye ti amagravu ni ti àhəli ahàr ana kʉli ba simiteni : ka ya ti atəhəloru kʉli kè meleher gatay ga magrafəŋa seriya kè kʉli a, tihindifiŋa ma kè kʉli a nahəma, ma ya ti akəhumi ana tay ni ti aŋgwaz aməwərki kʉli do. ");
INSERT INTO muy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Aɗaba ere ye ti akəɗəmum ni akaba məsər zlam gani ɗek ti nu nuani anəɗəfiki ana kʉli. Nahkay ti maslaŋa amələbi e kiɗiŋ ga ndam ezir gekʉli ni bu aməwəlki kʉli ka pakama bi. ");
INSERT INTO muy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ka sarta gani nani ndam ya atəgəs kʉli ti tâgrafəŋa seriya kè kʉli a ti ata bəŋ gekʉli, ata məŋ gekʉli, bəza ga məŋ gekʉli, ndam gekʉli akaba zləbəba gekʉli. Atabazl mis ndahaŋ e kiɗiŋ gekʉli bu ni ti azuhva tay. ");
INSERT INTO muy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mis ɗek etizirey kʉli aɗaba lekʉlʉm ndam goro. ");
INSERT INTO muy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ku tamal nahkay nəŋgu ni, ku məhər ga ahàr gekʉli bəlaŋ tekeɗi amadoru a haɗ do. ");
INSERT INTO muy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tamal a huɗ ga daliya nani bu kə̀mbrəŋum nu do nahəma, akəŋgətum sifa ya ti Melefit aməvi ana kʉli ni. » ");
INSERT INTO muy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yezu àɗəm keti : « Ka ya ti ekipʉma ndam silik tèveliŋia ahàr ana Zerʉzalem a tekesl nahəma, sərumki sarta ènjia, atəzum kəsa ni, etembeɗkaba ahay a ɗek. ");
INSERT INTO muy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka sarta gani nani ti ndam ya ka haɗ *Zʉde ni ahàr àɗəm tâcuhworu a həma vu ; ndam ya ti a Zerʉzalem ni ahàr àɗəm tâhəraya tâsləka ; ndam ya ti a kəsa ciɓ-ciɓeni bu ni ti ni tòru tə̀huriyu a Zerʉzalem ba. ");
INSERT INTO muy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aɗaba a vaɗ nday nani bu ni ti Melefit amatraɓvù ndam ga kəsa nani ; ere ye ti àɗəm a Wakita gayaŋ bu ni ɗek amagravu. ");
INSERT INTO muy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ka sarta gani nani ti wál a huɗ akaba nday ya ti bəza tə̀fəŋ ka tay ka ahar ni atasay cicihi ! Ndam ga haɗ nani atəcakay daliya dal-dal, aɗaba Melefit aməzumki ɓəruv ka tay. ");
INSERT INTO muy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Atara tabazl mis ndahaŋ e kiɗiŋ gatay bu kay àna maslalam, ndahaŋ ni ti ni atəgəs tay, atəhəloru tay ka haɗ gərgərani ɗek, tigi eviɗi. Eslini ndam ya ti tə̀fəki ahàr ke Melefit do ni atəzum Zerʉzalem ga njəɗa. Atəguroru duk abivoru ana mandav ga sarta ya Melefit àvi ana tay ga məgurani ni. » ");
INSERT INTO muy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yezu àɗəm keti : « Zlam ndahaŋ amagrakivu ka fat, ke kiyi akaba ka ata boŋgur. Mis etipia ti atəsər araŋa àbu ara agravu. Zlam ndahaŋ amagravu ka haɗ : aməɗ amadaɗay *dəluv gəɗakani, dəluv ni amahənday. Zlam nday nani atəsi aŋgwaz ana mis ga məlaŋ ni ɗek : ɓəruv amətikaba ana tay a. ");
INSERT INTO muy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ka sarta gani nani ti zlam ya ti amagravu ka haɗ ni aməhəli ahàr ana mis, atədəɗ àna aŋgwaz tazlazl-zlazl, aɗaba zlam njəɗa-njəɗani a huɗ melefit bu atədaɗay a məlaŋ gatay bu. ");
INSERT INTO muy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ka sarta gani nani ti mis etipi nu *Wur ge Mis anara a maklaɓasl ba àna njəɗa kay akaba maslaɗay goro a. ");
INSERT INTO muy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ay lekʉlʉm ti ka ya ti zlam nday nani tə̀bu tagravu nahəma, cikʉma lala, zum njəɗa ti kə̂mənjumoru kama, aɗaba sarta ge Melefit ya ahəŋgay kʉli ni ènjia wuɗak. » ");
INSERT INTO muy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yezu àhi ma ana tay àna ma *gozogul, àɗəm ahkado : « Mənjumki məŋ ga *wəruv akaba məŋ ga zlam ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kipʉm ti nday tə̀bu tiɗi nahəma, kə̀səruma mədərdər ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nahkay day tamal kìpʉma zlam ya nə̀hi ana kʉli ni naŋ àbu agravu nahəma, sərumki *Məgur ge Melefit ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nəhi ana kʉli nahəma, wuɗaka mis ya tə̀bu ka dala nihi ni təmət ɗek ti zlam nday nani ɗek amagrava day kwa. ");
INSERT INTO muy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Məlaŋ ya agavəla akaba məlaŋ ya a ga haɗ ni amandav, ay ti ma goro ya nə̀ɗəm ni amandav ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yezu àɗəm keti : « Bumi slimi ana ahàr gekʉli, kə̀vumi vu gekʉli ana zum ga makaɗ kʉli ba. Zlam ga duniya ègi eri ana kʉli ba daya, do ni ti vaɗ gani nani amərəkia ke kʉli a ka məsərki gekʉli do. ");
INSERT INTO muy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vaɗ gani nani amərəkia ke kʉli a akaɗa ga kəmbazl ya agəs zlam ndacani ni. Aɗaba vaɗ gani nani eminjikia ti ka ndam ga duniya ɗek, maslaŋa bəlaŋ tekeɗi amatam do. ");
INSERT INTO muy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nahkay njəhaɗum eri, həŋgalum Melefit a sarta bu ɗek ti mə̂vi njəɗa ana kʉli ga matamfəŋana kà zlam ya ti ara agravu na ɗek, ti aŋgwaz àwər kʉli ge micikeni kè meleher ga *Wur ge Mis ba. » ");
INSERT INTO muy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kəlavaɗ Yezu acahi zlam ana mis a dalaka ga *ahay gəɗakani ge Melefit ni bu ga məlafat ; ga məlavaɗ ti ni ahəraya, akoru andəhaɗ a həma ya təzalay *Oliviye ni bu. ");
INSERT INTO muy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kəla miledʉ dʉ mis ɗek takoru a dalaka ga ahay gəɗakani ge Melefit ni vu ga məbi slimi ana pakama gayaŋ ya aɗəm ni. ");
INSERT INTO muy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wuməri ga ndam *Zʉde ya təzumvù dipeŋ *miwisiŋeni do ni ènjia wuɗak : təzalay wuməri gani nani *Pak. ");
INSERT INTO muy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ka sarta gani nani ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni tàgray sawari ge mijiŋ Yezu akal-akal. Tàgray akal-akal ti aɗaba aŋgwaz àwərfəŋa tay kè mis dal-dalani na. ");
INSERT INTO muy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eslini *Seteni àhuriviyu ana Zʉdas. Zʉdas gani, slimi gayaŋ nahaŋ ni Iskariyot, naŋ bəlaŋ ga ndam *asak ga Yezu kru mahar cʉeni ni. ");
INSERT INTO muy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Seteni ni àra àhuriviya ti Zʉdas nakəŋ àrəkioru ka gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni akaba ka bəbay ga ndam slewja ya tajəgay *ahay gəɗakani ge Melefit ni. Òru ti ga magray sawari akaba tay ga məɗəfiki Yezu ana tay ti tə̂gəsa naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nday nakəŋ tàra tìcia ma gayaŋ na ti tə̀məra dal-dal, tə̀hi : « Məvuk siŋgu. » ");
INSERT INTO muy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zʉdas nakəŋ àgəskabá ma gatay na. Nahkay àɗəbay divi ahəmamam ti ara aɗəfiki Yezu ana tay ti tə̂gəs naŋ ka məsər ge mis do ni. ");
INSERT INTO muy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Vaɗ ga wuməri ge dipeŋ *miwisiŋeni do ni ènjia. A vaɗ ga wuməri ga *Pak nani ti tisliŋi bəza təmbak ana Melefit. ");
INSERT INTO muy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nahkay Yezu àslər ata Piyer nday ata Zeŋ, àhi ana tay ahkado : « Dəgum kâslamalumikabu zlam məzumani ga Pak ana leli. » ");
INSERT INTO muy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nday nakəŋ tìhindifiŋa ma, tə̀hi ahkado : « Kawayay ti môru mâslamalakabu eley ? » ");
INSERT INTO muy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Àhi ana tay : « Ekinjʉmiya a kəsa gəɗakani va nahəma, akəbumkabu ahàr akaba zal nahaŋ àcahbiya yam a mandaray va. Ekipʉma naŋ a ti ɗəbumiyu naŋ a ahay ya naŋ ahuriyu ni vu. ");
INSERT INTO muy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Akəhurumiya ti humi ana bay ahay ni ahkado : “Mʉsi geli àɗəm : Ahay goro ya ti anara nəzumviyu zlam ga wuməri ga Pak ni akaba ndam maɗəbay nu ni ti neley ?” ");
INSERT INTO muy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eslini bay ahay ni aməɗəfiki ahay nahaŋ gəɗakani ka ahàr ga ahay nahaŋ ana kʉli, zlam ɗek àvu àndava. Slamatumkabu zlam məzumani ni ti eslini. » ");
INSERT INTO muy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nahkay nday nakəŋ tàsləka, tòru tə̀di ahàr ana zlam ni ɗek akaɗa ga pakama ga Yezu ya àhi ana tay ni, mək tə̀slamalakabu zlam ga wuməri ga Pak ni. ");
INSERT INTO muy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sarta ga zlam məzumani àra ènjia ti Yezu akaba ndam *asak gayaŋ ni tòru tànjəhaɗ ka məlaŋ ga məzum zlam ni. ");
INSERT INTO muy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Eslini Yezu àhi ana tay : « Sarta goro ga macakay daliya ènjia wuɗak. Wuɗaka nəcakay daliya ni ti nàwaya məzum zlam ga wuməri ga *Pak hini akaba kʉli a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nəhi ana kʉli nahəma, anəzumkivu zlam ga wuməri ga Pak ni va do, si ka ya ti Melefit emendeveriŋaba tʉwi gana a Məgur gayaŋ ba ni kwa. » ");
INSERT INTO muy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Àra àɗəm ma nahkay ti àzay hijiyem akaba zum, àgri sʉsi ana Melefit, àhi ana tay : « Zuma, sʉm lekʉlʉm ɗekeni. ");
INSERT INTO muy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nəhi ana kʉli nahəma, kwa kani nìsi zum ga wur ge *viŋ va do, si a vaɗ ya *Məgur ge Melefit eminjia ni day kwa ti enisi. » ");
INSERT INTO muy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kələŋ gani àzay *dipeŋ, àgri sʉsi ana Melefit, èsekaba, àvi ana tay, àhi ana tay : « Hini hi ti aslu ga vu goro : navay ti ga mahəŋgay kʉli. Grumoru nahkay, ti kâjalumku ahàr. » ");
INSERT INTO muy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kələŋ ga məzum zlam ni ti àzay hijiyem akaba zum ni keti, àvi ana tay akaɗa ya àvi dipeŋ ana tay ni, àhi ana tay : « Àna zum ge hijiyem hini ti Melefit awəlkabu pakama gayaŋ akaba ge mis ; məwəlvani nani ti mʉweni. Awəlkabu ti àna mimiz ga vu goro ; mimiz goro ni aməŋgəzaya a vu goro ba ti ga mahəŋgay kʉli. » ");
INSERT INTO muy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Àhi ana tay keti : « Nəɗəm nahəma, maslaŋa ya ti aməsəkumoru nu ni ti naŋ àbu məzumkabu zlam. ");
INSERT INTO muy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nu *Wur ge Mis nara nəmət akaɗa ge Melefit ya àɗəm ni, ay maslaŋa ya ti asəkumoru nu ni ti amasay cicihi ! » ");
INSERT INTO muy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndam asak gayaŋ ni tàra tìcia ma gayaŋ na ti tìhindivu, tə̀ɗəm way e kiɗiŋ gatay bu amagray ere gani nani way. ");
INSERT INTO muy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ndam *asak ga Yezu ni tàgray gejewi e kiɗiŋ gatay bu, tə̀ɗəm : « Way gəɗakani e kiɗiŋ geli bu àtam leli ndahaŋ ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yezu àhi ana tay : « Bəbay ga haɗ ndahaŋ təgur haɗ gatay : gəɗákani ndahaŋ e kiɗiŋ gatay bu tawayay ti mis təzalay tay ndam məgri zlam sulumani ana mis. ");
INSERT INTO muy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Lekʉlʉm zla nahəma, àgravu akaɗa nani e kiɗiŋ gekʉli bu ba simiteni. Ay e kiɗiŋ gekʉli bu ti maslaŋa ya ti naŋ gəɗakani àtama kʉli ndahaŋ na ti mânjəhaɗ akaɗa ga wur gʉziteni kwa sawaŋ. Nahkay day maslaŋa ya agur kʉli ni mânjəhaɗ akaɗa ga bay məgri tʉwi ana mis ni. ");
INSERT INTO muy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nəɗəm nahəma, e kiɗiŋ ga bay ya təzibiyu zlam məzumani nday ata maslaŋa ya azibiyu ni bu ni ti way gəɗakani ni way ? Gəɗakani ti bay ya təzibiyu zlam ni do aw ? Ay nu nəŋgu ni nə̀bu e kiɗiŋ gekʉli bu akaɗa ga maslaŋa ya ti azibiyu zlam məzumani ana mis ni. ");
INSERT INTO muy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Lekʉlʉm ti kə̀bum akaba nu ; ku ka ya ti mis tàwayay nu ndo nəŋgu ni kə̀mbrəŋum nu ndo. ");
INSERT INTO muy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nahkay nu ti nagray ahəmamam ? Baba àvua bay a, nu day nəvi bay ana kʉli bilegeni a Məgur goro bu akaɗa gayaŋ ya àvu ni. ");
INSERT INTO muy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nahkay zla ti akəzumum zlam akaba ekisʉm zlam akaba nu a Məgur goro bu. Akanjəhaɗumviyu e kʉrsi vu ga magrafəŋa seriya kè dini kru mahar cʉeni ge Izireyel na daya. » ");
INSERT INTO muy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yezu àhi ma ana Piyer, àɗəm : « Simu, Simu, ci day : lekʉlʉm ti *Seteni èhindifiŋa kʉli kè Melefit a, awayay agri ana kʉli akaɗa ge mis ya ti ataɓalakia hilfi ga zlam gayaŋ a ni. ");
INSERT INTO muy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ay nu zla ti nàhəŋgala Melefit a ti kə̀mbrəŋ məfəku ahàr ba. Ekijikia ke divi a, ay ti akəŋgəkiya. Àkəŋgəkiya ti vi njəɗa ana bəza ga muk ni. » ");
INSERT INTO muy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyer àhəŋgrifəŋ, àhi : « Bay goro, nəgəskabu ga morakabani ata nak a daŋgay vu, ku ga məmətkabani ata nak day nəgəskabu. » ");
INSERT INTO muy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ay ti Yezu àhi ahkado : « Piyer, nə̀huk nahəma, kani kani a a huɗ ga məlavaɗ bu, wuɗaka agwazl azlah ti akəɗəm sak mahkər kə̀sər nu do timey. » ");
INSERT INTO muy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yezu àhi ana tay ahkado : « Ka sarta ya ti nə̀slər kʉli, ku mbici, ku mbolu, ku kimaka day kə̀həlum ndo ni ti, mam àhəcikiva ana kʉli a mam ? » Tə̀həŋgrifəŋ, tə̀hi : « Àbi. » ");
INSERT INTO muy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Àhi ana tay : « Ay nihi ti maslaŋa ya ti siŋgu àvu e mbici gayaŋ bu nahəma, mâza, ku zlam gayaŋ a mbolu bu day mâza akaba naŋ a. Maslaŋa ya ti maslalam gayaŋ àbi ni day mə̂səkumoru azana gayaŋ ti mə̂səkum maslalam àna siŋgu gani. ");
INSERT INTO muy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nəhi ana kʉli nahəma, maslaŋa ya ti Melefit àɗəm a Wakita gayaŋ ni bu : “Atacalkivu naŋ àkivu ka ndam magudar zlam” ni ti, maslaŋa gani nani ti nu. Pakama gani nani si agrakuvu kwa. » ");
INSERT INTO muy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eslini tə̀hi ahkado : « Bay geli, maslalam nday hi cʉ. » Naŋ nakəŋ àhi ana tay : « Èslia ahkay. » ");
INSERT INTO muy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yezu àhəraya, òru ka həma *Oliviye akaɗa gayaŋ ya agray kəlavaɗ ni. Àra àhəraya ti ndam maɗəbay naŋ ni tàɗəboru naŋ kələŋ. ");
INSERT INTO muy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tòru tìnjʉa eslina ti Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Həŋgalum Melefit ti kìjʉmkia ke divi a ka ya ti *Seteni esipet kʉli ni ba. » ");
INSERT INTO muy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Eslini Yezu nakəŋ àsləkafəŋa kà tay a, òru cak. Òru ènjʉa nahəma, àbəhaɗ mirdim grik, àhəŋgalay Melefit, ");
INSERT INTO muy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","àɗəm ahkado : « Bəba, tamal kawayay ti həɗakfua daliya hina, nə̀cakay ba ti. Ku nə̀ɗəm nahkay nəŋgu ni, kàgray ere ya nu nawayay ni ba, gray ere ye ti nak kawayay ni sawaŋ. »  ");
INSERT INTO muy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Eslini *məslər ge Melefit àhərkiaya e melefit ba, àvi njəɗa. ");
INSERT INTO muy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ɓəruv àtikaba dal-dal, nahkay naŋ nakəŋ àkaɗvu àna mahəŋgalakivu Melefit ; endif gayaŋ àndalaya akaɗa ge mimiz na ndal ndal a ga haɗ a. ");
INSERT INTO muy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Àra àhəŋgala Melefit a nahkay ti ècikaba cəkwaɗ, àŋgəkia ka ndam maɗəbay naŋ na. Àdi ahàr ana tay nday e ɗʉwir bu, aɗaba tàmətaɓkaba àna majalay ahàr a. ");
INSERT INTO muy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naŋ nakəŋ àhi ana tay : « Kinjʉm ɗʉwir ti kamam ? Cikʉmaba, həŋgalum Melefit ti kìjʉmkia ke divi a ka ya ti Seteni esipet kʉli ni ba. » ");
INSERT INTO muy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka ya ti Yezu naŋ àbu azlapay nahkay ni ti mis kay tə̀bu tərəkia. Naŋ ya təzalay naŋ Zʉdas, naŋ biliŋ ga ndam *asak ga Yezu kru mahar cʉeni ni, àdibiyu kama ana tay. Tàra tìnjia ti Zʉdas nakəŋ àrəkia ndoroŋa ka Yezu a ga məgri sa àna məfəki ma ka tuwər a. ");
INSERT INTO muy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Eslini Yezu àhi : « Zʉdas, kəsəkumoru nu *Wur ge Mis ti àna məgru sa nahkay hi zla do aw ? » ");
INSERT INTO muy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nday ya tə̀bu akaba Yezu ni tàra tìpia ere ye ti àgravu na ti tə̀hi ana Yezu : « Bay geli, mâkaɗvu akaba tay àna maslalam geli ni aw ? » ");
INSERT INTO muy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eslini mis biliŋ e kiɗiŋ gatay bu àsi maslalam ana bay məgri tʉwi ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni, àsifəŋa slimi ga ahar ga ɗaf a həndaɗ. ");
INSERT INTO muy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ay Yezu àɗəm : « Mbrəŋum, èslia nahkay. » Mək ènjifiŋ kà məlaŋ ge slimi ga maslaŋa nani, àhəŋgaraba naŋ a. ");
INSERT INTO muy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kələŋ gani Yezu àhi ma ana gəɗákani ya tàra ga məgəs naŋ a ni. Nday nani ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit akaba gəɗákani ga ndam majəgay *ahay gəɗakani ge Melefit akaba gəɗákani ndahaŋ. Àhi ana tay ahkado : « Kədəgumkua àna maslalam akaba aday a, kəgəsum nu akaɗa nu zal akal, ");
INSERT INTO muy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ambatakani do nə̀bu akaba kʉli a dalaka ga *ahay gəɗakani ge Melefit ni bu kəlavaɗ. Ay ti kìnjʉmfu ndo timey ! Ay nihi ti sarta ge tʉwi gekʉli akaba ge *Seteni bay məgur məlaŋ ziŋ-ziŋeni ni ènjia. » ");
INSERT INTO muy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Eslini mis ni tə̀gəs Yezu. Tàra tə̀gəsa naŋ a ti tə̀zoru naŋ, tə̀fiyu naŋ a ahay ga gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni vu. Piyer ti ni naŋ driŋ àɗəbabiyu Yezu. ");
INSERT INTO muy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tòru tìnjʉa ti mis tèbefta aku a dalaka ba, nday tə̀bu tənjafəŋ. Piyer day ànjəhaɗkivu ka tay. ");
INSERT INTO muy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nday tə̀bu tənjafəŋ kà aku ni nahkay ti wal nahaŋ àbu, agray tʉwi eslini. Àra èpia Piyer a manjəhaɗani kè eri ga aku na ti àmənjaləŋ lala, àɗəm : « Maslaŋa hini day mis ga Yezu. » ");
INSERT INTO muy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eslini Piyer àhi : « Aha, nə̀sər naŋ do timey, wal hini. » ");
INSERT INTO muy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Àra àpəsa ɓal ti zal nahaŋ èpia Piyer a keti, àhi : « Nak day ndam gatay gani. » Piyer nakəŋ àhi : « Nu mis gatay do timey, maslaŋa goro. » ");
INSERT INTO muy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Àra àpəsa keti ka ahàr gana agray njemdi bəlaŋ nahəma, maslaŋa nahaŋ àmbrəŋ ma gani ndo, àɗəm : « Eɗeɗiŋ naŋ mis ga Yezu, aɗaba naŋ zal Gelili. » ");
INSERT INTO muy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyer àhi : « Maslaŋa goro ni, nə̀sər ere ye ti kə̀ɗəmku ni do. » Piyer naŋ àbu azlapay nahkay ti agwazl àzlah hʉya. ");
INSERT INTO muy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eslini Bay geli àmbatkibiyu ma ke Piyer, àmənjaləŋbiyu ndekwa. Nahkay Piyer nakəŋ ma ga Bay geli ya àhi : « Kani kani a wuɗaka agwazl àzlah ti akəɗəm sak mahkər kə̀sər nu do timey » ni àŋgiaya a ahàr ba. ");
INSERT INTO muy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eslini àhəraya e mite va, ètʉwi dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nday ya tàjəgay Yezu ni tèyefiŋ, tə̀zləɓ naŋ. ");
INSERT INTO muy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tàkambahi eri, tìhindifiŋa ma, tə̀hi : « Tamal nak bay mahəŋgaray *pakama ge Melefit ti sərkaba, way àzləɓ kur ni way ? » ");
INSERT INTO muy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tìndivkivu naŋ àna ndivey ndahaŋ kay. ");
INSERT INTO muy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Məlaŋ àra àsla nahəma, gəɗákani ga ndam *Zʉde, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit akaba ndam *məsər Wakita ge Melefit ni tàŋgasvu. Nahkay tə̀zəbiyu Yezu kè meleher gatay ga magrafəŋa seriya. ");
INSERT INTO muy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tìhindifiŋa ma, tə̀hi : « Tamal nak *Krist *Bay gəɗakani ya amara ni ti hi ana leli. » Naŋ nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Tamal nə̀hia ana kʉli nihi day nə̀səra akəgəsumukabu do. ");
INSERT INTO muy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tamal nihindifiŋa ma kè kʉli a day akəhəŋgrumufəŋ do. ");
INSERT INTO muy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ay nəhi ana kʉli nahəma, ku kani səruma nu *Wur ge Mis ananjəhaɗ a məlaŋ ga gəɗakani bu kà ahar ga ɗaf ge Melefit Bay njəɗa-njəɗani ni. » ");
INSERT INTO muy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tàra tìcia ma ya àɗəm na ti nday ɗek tə̀hi : « Nahkay ti nak Wur ge Melefit aw ? » Yezu àhəŋgrifəŋ ana tay : « Nu gani : kə̀ɗəmum ti lekʉlʉm lekʉlʉmeni àna ahàr gekʉli. » ");
INSERT INTO muy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eslini nday nakəŋ tə̀ɗəm : « Maɗəbay ndam sedi ndahaŋ kamam mba mam ? Leli leleni àna ahàr geli mìcifiŋa a ma gayaŋ ba ni. » ");
INSERT INTO muy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mis ni ɗek tìcikaba hurum, tə̀zoru Yezu kè meleher ga bay *Pilet. ");
INSERT INTO muy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tòru tìnjʉa ti nday nakəŋ tàcalki naŋ ka zlam magudarani, tə̀hi ana bay ni ahkado : « Mə̀di ahàr ana maslaŋa hini naŋ àbu ewisiŋkabu ndam ga haɗ geli. Àɗəm tə̀pəli hadam ana *Sezar ba, àɗəm naŋ *Krist, naŋ bay. » ");
INSERT INTO muy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilet nakəŋ àra ècia ma na ti èhindifiŋa ma kà Yezu a, àhi : « Nak ti bay ga ndam *Zʉde eɗeɗiŋ aw ? » Àhəŋgrifəŋ, àhi : « Nak kə̀ɗəm. » ");
INSERT INTO muy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eslini Pilet àhi ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba mis macakalavani ni ahkado : « Maslaŋa hini ti nə̀di ahàr ana zlam magudarani gayaŋ ga məwəl naŋ àna seriya ndo timey. » ");
INSERT INTO muy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ay nday nani tə̀mbrəŋ ma gani ndo, tə̀ɗəm : « Àɗəm mis tə̀gəsiki ma ana ŋgumna ba, àcahia ma gana ana mis ga haɗ *Zʉde na ɗek. Ànjəkibiya kwa e Gelili bəɗak, àbaya ahalay a. » ");
INSERT INTO muy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilet àra ècia ma nana ti àɗəm : « Naŋ hini ti zal Gelili aw ? » ");
INSERT INTO muy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tàra tə̀hia Yezu naŋ ga haɗ ga Erot ya agur na ti Pilet nakəŋ àɗəm tôru àna naŋ afa ga Erot, aɗaba ka sarta gani nani ti Erot naŋ àbu a Zerʉzalem daya. ");
INSERT INTO muy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erot àra èpia tìnjia àna Yezu a ti àmərva dal-dal, aɗaba ècia pakama ya tə̀zlapaki na. Àpəsa àwaya ti mîpi Yezu ; awayay ti Yezu mâgraya ere ye ti mis tìpi ɗay-ɗay ndo na. ");
INSERT INTO muy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nahkay èhindifiŋa ma kà Yezu a gərgəri kay, ay ti Yezu àhəŋgrifəŋ ndo. ");
INSERT INTO muy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni akaba ndam *məsər Wakita ge Melefit ni day tə̀bu eslini, tacalki Yezu ka zlam magudarani kay dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kələŋ gani Erot akaba ndam slewja gayaŋ tèyefiŋ kà Yezu, tàmənjaləŋ akaɗa èsli mis e eri gatay bu ndo. Tə̀fəki mugudi sulumani ge meyefiŋeni ; tàra tèyefiŋa ti Erot nakəŋ àɗəm tâhəŋgororu Yezu afa ge Pilet, mək tàhəŋgoru naŋ. ");
INSERT INTO muy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ahaslani nahəma Erot nday ata Pilet ti nday ke ezir, ay kà fat nani ti tìgi ka zləba hʉya. ");
INSERT INTO muy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tàra tìnjia àna Yezu a ti Pilet àzalakabu gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, gəɗákani ndahaŋ akaba ndam *Zʉde ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Àhi ana tay ahkado : « Kə̀zumubiyu maslaŋa hini, kə̀humu èwisiŋ ndam ga haɗ *Zʉde. Nahkay nìhindifiŋa ma kè meleher gekʉli a, ay ti zlam ya kàcalumki naŋ, kə̀ɗəmum àgudara ni ti nu nə̀di ahàr ku bəlaŋ ndo. ");
INSERT INTO muy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erot day àdi ahàr ana magudar gayaŋ ndo, nahkay àhəŋgribiyu naŋ ana leli ni. Nihi ti maslaŋa hini magudar gayaŋ àbi ga makaɗki naŋ di bi. ");
INSERT INTO muy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nihi nahəma nəhi ana ndam slewja goro ni tə̂zləɓ naŋ, kələŋ gani anafəkaɗ naŋ. »  ");
INSERT INTO muy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kəla wuməri ga *Pak lu, Pilet si àfiaya zal daŋgay a bəlaŋ ana ndam Zʉde a kwa. ");
INSERT INTO muy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilet àra àɗəm ma nahkay ti nday ye eslini ni ɗek tə̀zlah, tə̀ɗəm : « Jiŋa maslaŋa hina, fiaya Barabas ana leli a. » ");
INSERT INTO muy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas ti tə̀fiyu naŋ a daŋgay vu aɗaba naŋ e kiɗiŋ ge mis ya tàkaɗvu akaba ŋgumna a Zerʉzalem ni bu, azuhva gayaŋ ya àkaɗ mis ni daya. ");
INSERT INTO muy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilet àwayay mafəkaɗ Yezu, nahkay àhəŋgri zuh ana ma gayaŋ ya àhi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ay nday nakəŋ tə̀zlah, tə̀ɗəm : « *Darfəŋ naŋ kà təndal ! Darfəŋ naŋ kà təndal ! » ");
INSERT INTO muy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilet àhəŋgri zuh ana ma ni ya mahkər, àhi ana tay ahkado : « Ay ti àgudar mam ? Magudar gayaŋ ya tâkaɗki naŋ ti nə̀di ahàr ndo. Nahkay nəhi ana ndam slewja goro ni tə̂zləɓ naŋ, kələŋ gani anafəkaɗ naŋ. » ");
INSERT INTO muy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ay nday nakəŋ tə̀zlah kay kay, tə̀ɗəm : « Darfəŋ naŋ kà təndal ! » Tə̀zlahkivu kay kay. ");
INSERT INTO muy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tàra tə̀zlaha nahkay ti Pilet nakəŋ àgəskabu ga məgri ere ye ti tìhindifiŋa ni ana tay. ");
INSERT INTO muy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Àfiaya maslaŋa ya ti tìhindifiŋa ni ana tay a. Naŋ ti maslaŋa ya ti tə̀fiyu a daŋgay vu aɗaba tàkaɗva akaba ŋgumna, àkaɗa mis a ni. Yezu ti ni, Pilet àhi ana ndam slewja gayaŋ ni tə̂gri ere ye ti ndam Zʉde tawayay ni. ");
INSERT INTO muy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ka ya ti ndam slewja ni təzoru Yezu ga makaɗ naŋ nahəma, tə̀di ahàr ana zal Sireŋ nahaŋ, slimi gayaŋ Simu, naŋ àbu asləkabiya e gili a. Eslini nday nakəŋ tə̀fəki ŋgasa ga mazay təndal ga *madarfəŋ Yezu ni ti mâɗəboru Yezu àna naŋ kələŋ. ");
INSERT INTO muy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndam *Zʉde dal-dal tə̀bu taɗəboru Yezu, wál day tə̀kibu ka tay titʉwioru naŋ, tagroru delʉlʉ. ");
INSERT INTO muy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eslini Yezu nakəŋ àmbatkibiyu ma ka wál ni, àhi ana tay ahkado : « Wál Zerʉzalem, kìtʉwʉm nu ba. Tʉwʉm ti vu gekʉli, tʉwʉm bəza gekʉli daya. ");
INSERT INTO muy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aɗaba sarta amara, mis atəcakay daliya dal-dal. Ka sarta gani nani ti atəɗəm : “Wál dəgəl tə̂mərvu, wál ya tìwi bəza ndo, bəza tìsi ɗuwa gatay ndo ni, tə̂mərvu.” ");
INSERT INTO muy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mis atənjəki ka məɗəmani həma gəɗákani tə̀mbəɗkiaya ka tay a, bəza həma tâŋgaha tay a. ");
INSERT INTO muy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nu nəcakay daliya nihi ti agravu akaɗa ga aku ya azum ɓiyem míɗeni ni, lekʉlʉm ti ni akacakum daliya ti amagravu akaɗa ga aku ya azum ɓiyem mikʉleni ni. » ");
INSERT INTO muy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ndam magudar zlam ndahaŋ tə̀bu nday cʉ ; ndam slewja ni tə̀həloru tay akaba Yezu ga moru *madarfəŋ tay kà təndal. ");
INSERT INTO muy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tòru ka məlaŋ nahaŋ ; məlaŋ gani nani ti təzalay « Aslat ga Ahàr. » Tòru tìnjʉa eslina ti tàdarfəŋ Yezu kà təndal ; tàdarfəŋ ndam magudar zlam cʉeni ni kà təndal ndahaŋ daya, bəlaŋ gani ka ahar ga ɗaf ga Yezu, naŋ nahaŋ ni ka ahar ga gəjar gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eslini Yezu àɗəm : « Bəba goro ni, tə̀sər ere ya tagray ni do, nahkay mbərfəŋa kà tay a. » Ndam slewja ni tàra tàdarfəŋa naŋ kà təndal na nahkay ti tàgraki ca-ca àki ka azana gayaŋ ni bəlaŋ àna bəlaŋ ti tə̂sər way azum way. ");
INSERT INTO muy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mis dal-dalani ya tàɗəboru naŋ ni tə̀bu tamənjaləŋoru. Eslini gəɗákani gatay ni tèyefiŋ kà Yezu, tə̀ɗəm : « Àhəŋga mis ndahaŋ a. Tamal ti naŋ *Bay gəɗakani ya ti Melefit àdaba, àslərbiyu ni nahəma, mâhəŋgay ahàr gayaŋ gayaŋani zla aw. » ");
INSERT INTO muy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ndam slewja ni day tèyefiŋ, tàhəɗakfəŋoru ga məvi zum cecʉwekeni. ");
INSERT INTO muy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Tə̀hi : « Tamal nak bay ga ndam Zʉde eɗeɗiŋ ti həŋgay ahàr gayak gayakani zla aw. » ");
INSERT INTO muy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Àbu məbəkiani ka təndal ni, agavəla ga ahàr ga Yezu ni : « Hini ti bay ga ndam Zʉde. » ");
INSERT INTO muy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Eslini bəlaŋ ga ndam magudar zlam cʉeni ya tàdarfəŋ tay kà təndal ni èndivi Yezu, àhi ahkado : « Nak ti Bay gəɗakani ya tə̀ɗəm amara ni do aw ? Tamal nak gani ti həŋgay ahàr gayak gayakani ti kâhəŋgay leli bilegeni zla aw. » ");
INSERT INTO muy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ay maslaŋa nahaŋ ni àra ècia ma gayaŋ na ti àləgi, àhi : « Nak ti kàgrafəŋa aŋgwaz kè Melefit a do ni ti kamam ? Tə̀bu tabazl leli akaɗa ya takaɗ naŋ ni, ");
INSERT INTO muy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ay tabazl leli ti kigeni, aɗaba màgudara zlam ya àgəski tabazlki leli na. Naŋ ti àgudar araŋa ndo simiteni. » ");
INSERT INTO muy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mək àhi ana Yezu : « Yezu, ka ya ti akara kəzum bay gayak nahəma, jalaku ahàr, nàgəjazlkuk ahàr ba ti. » ");
INSERT INTO muy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yezu àhəŋgrifəŋ, àhi : « Nəhuk nahəma, kani kani a akara kanjəhaɗ akaba nu a məlaŋ sulumani ge Melefit bu. » ");
INSERT INTO muy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ka gani nani, fat àra ècika tirkeɗ-keɗ ka ahàr melefit a ti àmbrəŋ maslaɗani, àslaɗay va do. Nahkay məlaŋ ɗek ègia ziŋ-ziŋena duk àbivoru àna njemdi mahkər ya ga məlakarawa. Eslini azana ga mahay gəɗakani ga məlaŋ *njəlatani ya ti a huɗ ga *ahay gəɗakani ge Melefit bu ni ègʉzlehvu kwar kala-kala. ");
INSERT INTO muy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ka sarta gani nani ti Yezu àzlah kay kay, àɗəm : « Bəba goro ni, nəfukvù sifa goro ni a ahar vu. » Àra àɗəma nahkay ti àmət hʉya. ");
INSERT INTO muy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bay ga ndam slewja ni àra èpia ere ye ti àgravu na ti àzləbay Melefit, àɗəm : « Maslaŋa hini ti mis jireni eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mis kay tə̀bu eslini : tàra ga mamənjaləŋ ka zlam ya təgri ana Yezu na. Ay tàra tìpia ere ye ti àgravu na ti àhəlia ahàr ana tay a, tàsləka àna tuway a. ");
INSERT INTO muy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndam ga Yezu ɗek akaba wál ya tàɗəbabiyu naŋ kwa e Gelili ni tə̀bu cak tamənjoru, tìpia ere ye ti àgravu na daya. ");
INSERT INTO muy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Zal nahaŋ àbu, slimi gayaŋ Zʉzef, naŋ ga kəsa Erimete, ka haɗ *Zʉde. Maslaŋa nani ti mis sulumani, jireni daya ; naŋ àbu ajəgay *Məgur ge Melefit. Naŋ biliŋ ga gəɗákani ge *seriya ga ndam *Zʉde, naŋ gani àgəsiki zlam ya nday tàgray ni ana tay ndo. ");
INSERT INTO muy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Naŋ nakəŋ òru afa ge Pilet, èhindi kisim ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilet àra àvia divi gana ti Zʉzef òru àzaya kisim na kà təndal na, àkambah, mək àfiyu e mindiviŋ vu. Mindiviŋ nani ti miliyeni a pəlaɗ vu : tə̀fiyu kisim ga maslaŋa nahaŋ ɗay-ɗay ndo. ");
INSERT INTO muy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Fat nani ti fat ga zləma ; vaɗ *məpəsabana anjəki wuɗak. ");
INSERT INTO muy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wál ya tàɗəbabiyu Yezu kwa e Gelili ni tàɗəboru Zʉzef ke mindiviŋ ni, tìpi ahəmamam tə̀fiyu kisim ni. ");
INSERT INTO muy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tàra tìpia ti tàsləkabiya ga maslamalakabu tersel akaba zlam ndahaŋ ya tizi àɓəlay ni. A vaɗ məpəsabana ba nahəma tə̀pəsaba tàgray tʉwi ndo, akaɗa ge *Divi ge Melefit ya àvay ni. ");
INSERT INTO muy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A vaɗ ye enjenjeni ga gosku nahəma, wál ni tòru dʉ ge miledʉ ke mindiviŋ ni. Tòru ti àna tersel gərgəri ya ti tàslamalakabu ni. ");
INSERT INTO muy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tòru tìnjʉa ti tìpi belim ge mindiviŋ ni maɓəlaɗkiana. ");
INSERT INTO muy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nahkay tə̀huriyu e mindiviŋ ni vu. Tàra tə̀huriyu nahəma, tə̀di ahàr ana kisim ga Bay geli Yezu ni ndo. ");
INSERT INTO muy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eslini tə̀sər ere ye ti tagray ni do. Nday tə̀bu nahkay ti mis cʉ tàŋgazlivu ana tay, məbakabu azana maslaɗani. ");
INSERT INTO muy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wál ni tàra tìpia tay a ti tàgra aŋgwaz a, tàhəŋgaroru eri gatay a haɗ. Eslini mis cʉeni ni tə̀hi ana wál ni : « Kə̀ɗəbum mis ya naŋ eri ni e kiɗiŋ ga nday məmətani ni bu ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Àŋgaba e kisim ba, naŋ àbi ahalay va bi. Lekʉlʉm kə̀sərumki ka pakama ya àhi ana kʉli ka ya ti naŋ e Gelili ni do aw ? ");
INSERT INTO muy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eslini àhi ana kʉli ahkado : “Ahàr àɗəm nu *Wur ge Mis ti tə̂gəsi nu ana ndam magudar zlam, ti tâkaɗ nu kà təndal, ti nâŋgaba a vaɗ ya mahkər a.” » ");
INSERT INTO muy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wál ni tàra tìcia nahkay ti tə̀sərki ka ma ga Yezu ya àhi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wál ni tàra tàsləkabiya ke mindiviŋ na ti tàŋgəhaɗi ma gani ɗek ana ndam *asak kru mahar bəlaŋani ni akaba ana ndam *maɗəbay Yezu ndahaŋ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wál ya tàŋgəhaɗ ma ni ti ata Mari ga kəsa Magədala ni, Zeni, Mari məŋ ge Zek akaba wál ndahaŋ. Ndam asak ni tàra tìci ma na ti ");
INSERT INTO muy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","tə̀jalay a ahàr gatay bu ma ga wál ni ma masakani, nahkay tə̀gəsiki ma gatay ni ana tay ndo. ");
INSERT INTO muy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ay zla ti Piyer àsləka, àcuhworu ke mindiviŋ ni. Òru ènjʉa ti àndəhaɗ ahàr, àmənjiyu e mindiviŋ ni vu, èpi gabaga duca ciliŋ. Eslini ti àsləkabiya, àra a magam a. Ere ye ti èpibiyu ni àgria ejep a dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ka fat gani nani ndam *maɗəbay Yezu ndahaŋ cʉ tə̀bu takoru a kəsa nahaŋ vu, slimi ga kəsa gani Emeyʉs. Kəsa gani driŋ akaba Zerʉzalem, mis asawaɗay njemdi cʉ e divi bu day kwa ti enjiyu. ");
INSERT INTO muy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nday nakəŋ tə̀bu təzlapakioru e kiɗiŋ gatay bu àki ka zlam ya àgravu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nday tə̀bu təzlapay e kiɗiŋ gatay bu, tagray gejewi nahkay ti Yezu nakəŋ àcay tay e divi bu mək tàrakaboru ka ahar bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ay ti tə̀sərkaba naŋ a ndo, aɗaba akaɗa araŋa àsikia ke eri ana tay a. ");
INSERT INTO muy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eslini Yezu àhi ana tay ahkado : « Kazlapumkibiyu ka mam e divi bu ni mam ? » Tàra tìcia ma gayaŋ na ti nday nakəŋ tìcika, ahàr àbu ahəli ana tay. ");
INSERT INTO muy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eslini biliŋ gatay, slimi gayaŋ Kleyʉpes, àhəŋgrifəŋ, àhi ahkado : « Nak ti nak zal mirkwi aw ? Ere ye ti àgravu a Zerʉzalem a vaɗ nday ndani bu ni ti nak ciliŋ kìci ndo zla do aw ? » ");
INSERT INTO muy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yezu nakəŋ àhi ana tay : « Mam àgravu mam ? » Tə̀hi : « Ere ye ti àgrakivu ka Yezu zal Nazaret ni. Naŋ gani nani ti bay mahəŋgaray *pakama ge Melefit ; pakama gayaŋ ya àɗəm ni ɗek akaba tʉwi gayaŋ ya àgray ni ɗek ti àgray àna njəɗa ge Melefit. Nahkay àɓəlafəŋa kè Melefit a, àɓəlafəŋa kè mis a ɗek daya. ");
INSERT INTO muy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ay ti ndam geli gəɗákani ya taŋgalabakabu mis akaba Melefit ni akaba gəɗákani geli ndahaŋ ni tə̀gəsi naŋ ana ndam *Rom ti tâgrafəŋa seriya ge kisim a, mək *tàdarfəŋ naŋ kà təndal. ");
INSERT INTO muy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Leli ti ni mə̀ɗəm amal naŋ àhəŋgay ndam *Izireyel. Akaba nani ɗek, nihi tegi vaɗ mahkər kani, zlam gani àgravu ni. ");
INSERT INTO muy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ay ti wál ya tə̀bu akaba leli ni ndahaŋ tə̀hia pakama ga məgri ejep ana leli a. Tòru kè mindiviŋ dʉ ge miledʉ ti ");
INSERT INTO muy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","tə̀diviyu ahàr ana kisim ga Yezu ni ndo, mək tàsləkabiya, tə̀hi ana leli tìpibiya *məslər ge Melefit a. Məslər ge Melefit ni tə̀hibiyu ana tay Yezu naŋ àbu àna sifa gayaŋ. ");
INSERT INTO muy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nahkay ndam geli ndahaŋ day tòra ke mindiviŋ na. Tìnjʉa ti tə̀di ahàr ana mindiviŋ ni akaɗa ga wál ya tàŋgəhaɗi ana leli ni. Ay ti tìpibiyu Yezu ndo. » ");
INSERT INTO muy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yezu àra ècia pakama gatay na ti àhi ana tay ahkado : « Lekʉlʉm ti endisl àniviyu ana kʉli bi aw ? Kìcʉmaba ma ga ndam mahəŋgaray *pakama ge Melefit àna weceweci do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ŋgay ahàr àɗəm si *Bay gəɗakani ya amara ni àcaka daliya nahkay day kwa, mək kwa ti Melefit amazləbay naŋ ti mîgi gəɗakani kè eri ge mis ɗek ti kìcʉm do waw ? » ");
INSERT INTO muy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eslini Yezu nakəŋ àɗəfiaba pakama ge Melefit ya àɗəmki ka naŋ a Wakita ge Melefit bu na ɗek ana tay a. Ànjiki ana tay ka ge Mʉwiz ni, àɗafaba ga ndam ndahaŋ ya tàhəŋgaray pakama ge Melefit na ɗek daya. ");
INSERT INTO muy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tòru tìnjʉa a kəsa ya takoru ni va wuɗak nahəma, Yezu akoru zlam gayaŋ akaɗa asafəŋa divi kà kəsa na. ");
INSERT INTO muy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Eslini nday nani tə̀hi : « Ɓesa day, kòru ba, njəhaɗa akaba leli a, aɗaba tegi fat àdiya, məlaŋ naŋ àbu eɗizi timey. » Nahkay tə̀huriyu tànjəhaɗ a kəsa ni vu akaba tay. ");
INSERT INTO muy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tàra tə̀həliaya zlam məzumani ana tay a ti Yezu àzay *dipeŋ ni, àgri sʉsi ana Melefit, èsekaba, àvi ana tay. ");
INSERT INTO muy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nday nakəŋ tàra tìpia gayaŋ ya àgray nahkay na ti eri gatay ni ègia kweleŋ-kweleŋ, tə̀sər naŋ. Ay tàra tə̀səra naŋ a ti tìpi naŋ va do, naŋ àbi. ");
INSERT INTO muy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eslini tə̀ɗəm e kiɗiŋ gatay bu ahkado : « Zlam ya ti àhi ana leli e divi bu, àɗəmki ka Wakita ge Melefit ni ti mîciaba ni ti àməria məɓəruv ana leli a do waw ? » ");
INSERT INTO muy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nday nakəŋ tìcikaba hʉya, tàŋgoru a Zerʉzalem. Tòru tìnjʉa ti tə̀di ahàr ana ndam asak ga Yezu kru mahar bəlaŋani ni macakalavani akaba mis ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eslini nday ndahaŋ ni tə̀hi ana mis cʉeni nakəŋ ahkado : « Bay geli àŋgaba e kisim ba eɗeɗiŋ eɗeɗiŋena ! Simu èpi naŋ a. » ");
INSERT INTO muy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nday cʉeni ni day tàŋgəhaɗ ere ya àgrakivu ka tay e divi bu ka ya ti takoru e Emeyʉs ni akaba gatay ya tə̀sər Yezu ka ya ti esekaba dipeŋ a ni. ");
INSERT INTO muy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nday cʉeni ni tə̀bu təzlapay nahkay ti mis ni ɗek tìpi Yezu nakəŋ naŋ jika e kiɗiŋ gatay bu. Àhi ana tay ahkado : « Melefit mə̂gri sulum gayaŋ ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nday ɗek məɓəruv àtikaba ana tay a, aŋgwaz àwəra tay a dal-dal, aɗaba tə̀ɗəm maslaŋa àmbavakiva ka tay a. ");
INSERT INTO muy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eslini Yezu àhi ana tay ahkado : « Kəgrum aŋgwaz ti kamam ? Ŋgay hini nu ti kə̀gəsumkabu do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mənjumki ahar goro ni akaba asak goro ni. Hini nu timey ! Njʉmfu, mənjumlu lala. Kìpʉma nu nə̀bu àna aslu akaba aslat ga vu goro. Mis məmbavani ti nahkay hi do. » ");
INSERT INTO muy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ka ya ti naŋ àbu ahi ma ana tay nahkay ni ti àŋgazli ahar gayaŋ ni akaba asak gayaŋ ni ana tay. ");
INSERT INTO muy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Tàra tìcia ma gayaŋ na ti àgria ejep ana tay a, tə̀mərva àsaɓay, ay kekileŋa tə̀gəskabu ŋgay naŋ eɗeɗiŋ faŋ ndo. Nahkay Yezu nakəŋ àhi ana tay : « Zlam məzumani àfəŋ kè kʉli ahalay bi aw ? » ");
INSERT INTO muy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nday nakəŋ tə̀ziaya telma ge kilif mətusana, ");
INSERT INTO muy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","mək àzay, àzum kè eri gatay. ");
INSERT INTO muy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eslini Yezu àhi ana tay ahkado : « Ere ye ti àgrakuvu ni ti nə̀hia ana kʉli a ahaslana ka ya ti nu nə̀bu akaba kʉli na. Nə̀hi ana kʉli ahkado tə̀ɗəmkua pakama, tə̀bəkia ma gana e *Divi ge Melefit ya àɗəfiki ana Mʉwiz ni ba akaba a wakita ga ndam mahəŋgaray *pakama ge Melefit ba akaba a wakita ge Limis ba. Pakama nani ya tə̀ɗəmku ni ɗek ti si agravu kwa. » ");
INSERT INTO muy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Eslini naŋ nakəŋ àvi məsər zlam ana tay ga miciaba zlam ya a Wakita ge Melefit bu na. ");
INSERT INTO muy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Àhi ana tay ahkado : « Àbu məbəkiani a Wakita ge Melefit bu nahkay hi : “*Bay gəɗakani ya amara ni ti si àcaka daliya kwa, tàkaɗa naŋ a, mək a vaɗ ya mahkər aŋgaba e kisim ba kwa.” ");
INSERT INTO muy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kələŋ gani zla nahəma, atəhi ma ana mis ga haɗ ga məlaŋ ni ɗek àna slimi gayaŋ, si tâmbatkaba majalay ahàr gatay a, day kwa ti Melefit ambərfəŋa zlam magudarani gatay ni kà tay a. Atənjəki ka məɗəm ma gani a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pakama gani nani tə̀ɗəmki ti ka nu. Ndam sedi gani ti lekʉlʉm. ");
INSERT INTO muy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nu ti anəsləribiyu Məsuf ya ti Baba goro àɗəm aməvibiyu ana kʉli ni ana kʉli. Ay lekʉlʉm ti ni njəhaɗuma a Zerʉzalem a duk abivoru ana vaɗ ya ti Məsuf gani nani amərəkia ke kʉli a, aməvi njəɗa ge Melefit ɗek ana kʉli ni. » ");
INSERT INTO muy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yezu àra àhia pakama nana ana tay a ti òru àna tay gwar a Betani. Òru ènjʉa eslina ti àhəlkioru ahar ka tay agavəla, àgri *sulum ge Melefit ana tay. ");
INSERT INTO muy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka ya ti naŋ àbu agri sulum ge Melefit ana tay ni ti àsləkafəŋa kà tay a, Melefit àzoru naŋ agavəla a huɗ melefit vu. ");
INSERT INTO muy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Naŋ àbu asləkafəŋa kà tay a ti nday nakəŋ tə̀həŋgrioru ahàr a haɗ, meleher ndiɓa ndiɓa ana haɗ. Kələŋ gani tàŋga a Zerʉzalem àna məmərana dal-dal. ");
INSERT INTO muy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kəlavaɗ təhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu, tanjəhaɗ eslini ruk, tazləbay Melefit.");
INSERT INTO muy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Wuɗaka Melefit ànjəki ka magraya zlam a ɗek ti Bay nahaŋ àbu àndava. Bay gani nani ti Pakama ge Melefit. Ka gani nani ti naŋ àbu akaba Melefit ka ahar bəlaŋ àndava. Naŋ gani ti Melefit daya. ");
INSERT INTO muy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wuɗaka Melefit ànjəki ka magraya zlam a ɗek ti Pakama nani naŋ àbu akaba Melefit ka ahar bəlaŋ àndava. ");
INSERT INTO muy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Melefit àgraya zlam a ɗek ti àna naŋ. Zlam ya ti Melefit àgraya àna naŋ do ni ti àbi. ");
INSERT INTO muy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Zlam ya ti Melefit àgraya tay a ni ɗek ti Pakama nani àvi sifa gani ana tay. Sifa gani nani ti aslaɗi məlaŋ ana mis. ");
INSERT INTO muy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Maslaɗani gani nani aslaɗay a məlaŋ ziŋ-ziŋeni bu, ay ti nday ya a məlaŋ ziŋ-ziŋeni bu ni tə̀gəskabu naŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Zal nahaŋ àra, slimi gayaŋ Zeŋ, Melefit àslərbiyu naŋ ga məhi pakama gayaŋ ana mis. ");
INSERT INTO muy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Naŋ zal sedi : àra ti ga magrakia sedi a ka maslaɗani na, ti mis ɗek tə̂fəki ahàr ka Bay ya ti avay sifa ni. ");
INSERT INTO muy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Aslaɗay ti naŋ naŋani do : àra ti ga magrakia sedi ka maslaɗani na ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bay ya ti aslaɗay ge jiri ni ti, Pakama ge Melefit ni. Àra a duniya va, naŋ àbu aslaɗi məlaŋ ana mis ɗek. ");
INSERT INTO muy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nahkay Bay nani ti naŋ àbu a duniya bu. Melefit àgraya duniya ti àna naŋ : ay ti ndam ga *duniya ni tə̀sərkaba naŋ a ndo. ");
INSERT INTO muy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Àra ka haɗ gayaŋ a, ay ti ndam gayaŋ tə̀gəskabu naŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ku tamal nahkay nəŋgu ni mis ndahaŋ tə̀gəskabá naŋ a, tə̀fəkia ahàr a. Nday ya ti tə̀fəkia ahàr a ni ti, àvi divi ana tay ti tîgi bəza ge Melefit. ");
INSERT INTO muy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tìgia bəza ge Melefit a ti akaɗa ge mis ya ti tiwi bəza ni do. Tìgi nahkay ti akaɗa ga zal ya awayay azi huɗ ana wal ni do. Tìgi nahkay ti Melefit àvi sifa mʉweni ana tay tîgi bəza gayaŋ. ");
INSERT INTO muy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nahkay Pakama ge Melefit ni ègia mis a, ànjəhaɗa e kiɗiŋ geli ba. Ere ye ti àgray ni ɗek ti àgray àna *sulum ge Melefit, àna jiri daya. Leli màra mìpia naŋ a ti mə̀səra naŋ gəɗakani, naŋ Wur bəlaŋ bəlaŋani ge Melefit. ");
INSERT INTO muy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Zeŋ àgrakia sedi a, àɗəm kay kay : « Nə̀ɗəm : “Nu ti nàra enji gayaŋ a, ay naŋ gəɗakani àtam nu, aɗaba wuɗaka tìwi nu ti naŋ àbu àndava.” Pakama gani nani nə̀ɗəmki ti ka naŋ. » ");
INSERT INTO muy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naŋ ti zlam sulumani ɗek afa gayaŋ : nahkay àgri sulum gayaŋ ana leli sak ehimeya. ");
INSERT INTO muy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Melefit àvi *Divi gayaŋ ana leli ti àna wakita ge Mʉwiz ya àbəki ni. Ay àgri sulum gayaŋ akaba jiri gayaŋ ana leli ti Yezu *Krist. ");
INSERT INTO muy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Maslaŋa ya èpia Melefit a ti àbi. Ay Wur gayaŋ bəlaŋ bəlaŋani naŋ Melefit, anjəhaɗ afa ga Bəŋani ni, naŋ day kwa ti àɗəfiki Melefit ana leli ti mə̂sər naŋ. ");
INSERT INTO muy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nahkay Zeŋ nakəŋ àgray sedi gayaŋ. A vaɗ nahaŋ gəɗákani ga ndam *Zʉde ya a Zerʉzalem ni tə̀slərbiyu mis ge mihindifiŋa ma ke Zeŋ a. Tə̀slərbiyu ti mis ndahaŋ e kiɗiŋ ga ndam *maŋgalabakabu mis akaba Melefit ni bu akaba ndam *Levi ndahaŋ. Mis ni tàra tìnjia ti tə̀hi : « Nak ti way ? » ");
INSERT INTO muy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tàra tìhindifiŋa ma na nahkay ti, Zeŋ nakəŋ èmbirfiŋ ndo, àɗəm vay-vay kè meleher ge mis ɗek : « Nu ti Krist *Bay gəɗakani ya amara ni do. » ");
INSERT INTO muy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Eslini tìhindifiŋa ma keti, tə̀hi : « Tamal nahkay ti, nak way ? Nak Eli aw ? » Zeŋ nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Aha, nu Eli do. » Tə̀hi keti : « Ay nak ti bay mahəŋgaray pakama ge Melefit ya Mʉwiz àɗəm amara ni aw ? » Àɗəm : « Aha, nu do. » ");
INSERT INTO muy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Eslini tə̀hi : « Tamal nahkay ti, nak way zla aw ? Ahàr àɗəm məhəŋgrikaboru ma gani ana ndam ya tə̀slərbiyu leli ni kwa. Kə̀ɗəmki mam ka ahàr gayak mam ? » ");
INSERT INTO muy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Zeŋ àhəŋgrifəŋ ana tay, àɗəm : « Ahaslani Izayi bay mahəŋgaray pakama ge Melefit àɗəm : “Maslaŋa azlah a huɗ gili bu, dəŋgu gayaŋ ahəndabiyu. Àɗəm : Slamatumikabu divi ana Bay gəɗakani, ahàr àɗəm divi gayaŋ mâla ndəlaɓa.” « Maslaŋa ya ti dəŋgu gayaŋ ahəndabiyu ni ti nu. » ");
INSERT INTO muy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","E kiɗiŋ ga ndam ya ti tə̀slərbiyu tay a Zerʉzalem ni bu ni ti ndam *Feriziyeŋ ndahaŋ tə̀kibu ka tay. ");
INSERT INTO muy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Nday nakəŋ tìhindifiŋa ma nahaŋ a keti, tə̀hi ahkado : « Tamal nak Bay gəɗakani ya amara ni do, nak Eli do, nak bay mahəŋgaray pakama ge Melefit ya amara ni do nahəma, *kabaray mis ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Zeŋ nakəŋ àhəŋgrifəŋ ana tay, àɗəm : « Nu ti nabaray kʉli àna yam ; ay maslaŋa nahaŋ naŋ àbu e kiɗiŋ gekʉli bu, kə̀sərum naŋ do. ");
INSERT INTO muy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nu ti nàra enji gayaŋ a : ay nu ti way ga mepicehiaba ezeweɗ ga kimaka gayaŋ a di way ? » ");
INSERT INTO muy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Zlam nday nani ɗek tàgravu ti a Betani ke ledi ga zalaka *Zʉrdeŋ, ka məlaŋ ya ti Zeŋ abaray mis ni. ");
INSERT INTO muy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Hajəŋ gani ti Zeŋ nakəŋ èpi Yezu naŋ àbu arəkia. Àra èpia naŋ a ti àɗəm ahkado : « Maslaŋa hini ti *Wur Təmbak ge Melefit : agray ti zlam magudarani ge mis ga duniya ni ɗek mə̂ləbi va bi ti naŋ. ");
INSERT INTO muy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nə̀ɗəm : “Nu ti nàra enji gayaŋ a, ay naŋ gəɗakani àtam nu, aɗaba wuɗaka tìwi nu ti naŋ àbu àndava.” Pakama gani nani nə̀ɗəmki ti ka naŋ. ");
INSERT INTO muy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ŋgay naŋ gani ti nə̀sərkaba ndo. Ay nu nàra *nàbaray mis àna yam ti ga məɗəfiki naŋ ana ndam jiba ge Izireyel. » ");
INSERT INTO muy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Zeŋ nakəŋ àɗəm keti : « Nìpi *Məsuf ge Melefit àhərkiaya kwa a huɗ melefit ba akaɗa ga kurkoduk ya ahər na, àrəkia ànjəhaɗki. ");
INSERT INTO muy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ŋgay naŋ gani ti nə̀sərkaba ndo, ay ka ya ti Melefit àslərbiyu nu ga məbaray mis àna yam ni ti àhu ahkado : “Maslaŋa ya ekipi Məsuf goro aməhərkiaya amanjəhaɗki ni ti, naŋ gani Bay ya ti aməbaray mis àna *Məsuf Njəlatani ni.” ");
INSERT INTO muy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Zlam gani nani àgrava kè eri goro a. Nagrakia sedi a : naŋ ti Wur ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hajəŋ nahaŋ gani keti Zeŋ naŋ àbu eslini akaba ndam maɗəbay naŋ cʉ. ");
INSERT INTO muy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nday tə̀bu eslini nahkay ti Zeŋ nakəŋ èpi Yezu naŋ àbu asawaɗay. Àra èpia naŋ a nahəma, àɗəm : « Maslaŋa hini ti *Wur Təmbak ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ndam maɗəbay naŋ cʉeni ni tàra tìcia ma gayaŋ na ti tàɗəboru Yezu e meteliŋ vu. ");
INSERT INTO muy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yezu àmbatbiyu ma kələŋ, èpi ti nday tə̀bu taɗəboru naŋ, mək àhi ana tay : « Kəɗəbum mam ? » Nday nakəŋ tə̀hi ahkado : « Rabi, kanjəhaɗ ti eley ? » (Rabi ti awayay aɗəmvaba « Mʉsi »). ");
INSERT INTO muy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naŋ nakəŋ àhi ana tay ahkado : « Dəguma, akara kipʉm. » Nahkay tòru akaba naŋ, tòru tìpi məlaŋ gayaŋ ya anjəhaɗ ni. Ka sarta gani nani àgray njemdi faɗ ya ga məlakarawa : tə̀pəs akaba Yezu nakəŋ eslini, fat àdəkiviyu a ahay vu ka tay. ");
INSERT INTO muy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E kiɗiŋ ge mis cʉeni ya tìci ma ge Zeŋ, tàɗəbay Yezu ni bu ni ti, bəlaŋ gani slimi gayaŋ Andre naŋ wur ga məŋ ga Simu Piyer. ");
INSERT INTO muy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andre nakəŋ àɗəboru wur ga məŋani Simu hʉya. Àra àdia ahàr a ti àhi : « Mə̀dia ahàr ana Misi a. » (Misi ti awayay aɗəmvaba « *Krist *Bay gəɗakani ya amara ni »). ");
INSERT INTO muy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andre àra àhia ma ana Simu a nahkay ti àzoru naŋ suwwa afa ga Yezu. Yezu àra èpia naŋ a ti àhi : « Nak Simu wur ge Zeŋ : kama kama ti atəzalay kur ti Sifas. » (Sifas ahkay do ni Piyer ti awayay aɗəmvaba « akur. ») ");
INSERT INTO muy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hajəŋ tegʉni gani ti Yezu àɗəm asləka akoru ka haɗ *Gelili. Naŋ àbu akoru ti àdi ahàr ana Filip mək àhi : « Ɗəbabiyu nu. » ");
INSERT INTO muy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ti kəsa gayaŋ Beceyda. Kəsa nani ti kəsa ga ata Andre nday ata Piyer daya. ");
INSERT INTO muy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip day òru àdi ahàr ana Natanayel mək àhi : « Mə̀dia ahàr a ana Bay ya ti Mʉwiz àɗəmki ma e *Divi ge Melefit bu akaba ndam mahəŋgaray *pakama ge Melefit tə̀ɗəmki ma na. Bay gani nani ti Yezu, naŋ wur ge Zʉzef, kəsa gayaŋ Nazaret. » ");
INSERT INTO muy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Eslini ti Natanayel àhəŋgrifəŋ, àhi : « A Nazaret ti zlam sulumani aŋgətvu nahkay aw ? » Filip àhəŋgrifəŋ, àhi : « Ra kîpi àna eri gayak. » ");
INSERT INTO muy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanayel nakəŋ naŋ àbu arəkia ka Yezu a, Yezu àra èpia naŋ a nahəma, àɗəm : « Naŋ hini ti zal *Izireyel eɗeɗiŋ : àgosay mis do ferera. » ");
INSERT INTO muy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel àra ècia ma gayaŋ na ti àhi : « Kə̀sər nu ti ahəmamam ? » Yezu àhəŋgrifəŋ, àhi : « Wuɗaka Filip àzalabiyu kur ti, nìpia kur a ka ya ti nak kə̀bu e zʉhweri ga *wəruv bu na. » ");
INSERT INTO muy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Eslini Natanayel àhi : « Mʉsi, nak ti Wur ge Melefit, nak Bay ga ndam Izireyel ! » ");
INSERT INTO muy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yezu àhi ahkado : « Kəfəku ahàr ti aɗaba nə̀huk “Nìpia kur a nak kə̀bu e zʉhweri ga wəruv bu” ni aw ? Ekipi zlam gəɗákani ndahaŋ tə̀tam hini mba. » ");
INSERT INTO muy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Àɗəm keti : « Nəhi ana kʉli nahəma, ekipʉm huɗ melefit məzləkvabana, akaba *məslər ge Melefit təcəloru e melefit vu mək təŋgəkua ka nu, nu *Wur ge Mis a. » ");
INSERT INTO muy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A vaɗ ya mahkər ti tàgray wuməri ga maday wal a Kana ka haɗ *Gelili. Məŋ ga Yezu day naŋ àbu eslini. ");
INSERT INTO muy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tə̀zaloya Yezu akaba ndam maɗəbay naŋ na ka məlaŋ ga wuməri na daya. ");
INSERT INTO muy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nday tə̀bu tagray wuməri nahkay ti zum àra àndavkia ka tay a. Eslini məŋ ga Yezu àhi ana Yezu ahkado : « Zum ni àbi va bi, àndava. » ");
INSERT INTO muy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ay Yezu àhəŋgrifəŋ, àhi : « Mma, nak kəɗəfuki tʉwi goro aw ? Sarta gani goro ènjia faŋ ndo. » ");
INSERT INTO muy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eslini məŋ ga Yezu àhi ana nday ya ti tagray tʉwi ni ahkado : « Grum ere ye ti aməhi ana kʉli kə̂grum ni ɗek. » ");
INSERT INTO muy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wərzla ga akur gəɗákani muku tə̀bu eslini. Wərzla nday nani ti ndam *Zʉde təcahviyu yam a tay vu, *tabaray àna naŋ ka ya ti tawayay tigi *njəlatani akaɗa ge divi gatay ya taɗəbay ni. Wərzla ni bəlaŋ gani azum mandaray faɗ. ");
INSERT INTO muy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Eslini Yezu àhi ana ndam ya tagray tʉwi ni ahkado : « Cəhumviyu yam a wərzla nday hini vu, ti tə̂rəhvu. » Nahkay nday nakəŋ tə̀cahviyu yam a wərzla ni vu ɓerera ɓerera. ");
INSERT INTO muy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tàra tàgra nahkay ti, Yezu àhi ana tay : « Cəhumaya kə̂zumikaboru ana gəɗakani ga wuməri ni. » Mək tàgray ere ye ti àhi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Gəɗakani ga wuməri ni àra àcaka ti yam ni ègia zum a àndava. Naŋ àsər məlaŋ ya tə̀cahbiyu zum ni do, ay ndam magray tʉwi ni tə̀səra tə̀cahbiyu yam ga wərzla ni. Àra àcaka zum na ti, àzalay bay ya aday wal ni, ");
INSERT INTO muy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","mək àhi : « Ku way way do ka ya ti agray wuməri ti acəhibiyu zum məcərani ana mis enji. Mis ni etisikabá day kwa ti acəhibiyu ya àcər lala do ni ana tay. Ay nak ti kàgray nahkay ndo, kəvi zum ya acər lala ni ana mis nihi ɗəma mba. » ");
INSERT INTO muy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Zlam ga Yezu ya àgray enjenjeni agri ejep ana mis, aɗəfiki zlam ana tay ni ti àgray a Kana ka haɗ Gelili ti nahkay. Gayaŋ ya àgray nahkay ni ti àɗafaki naŋ gəɗakani : ndam maɗəbay naŋ ni tàra tə̀səra naŋ gəɗakani ti tə̀fəki ahàr hʉya. ");
INSERT INTO muy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kələŋ gani Yezu akaba məŋani, bəza ga məŋani akaba ndam maɗəbay naŋ ni tàsləka tòru a Kafarnahum. Tòru tìnjʉa eslina ti tànjəhaɗ vaɗ ɓal ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wuməri ga ndam *Zʉde ya təzalay *Pak ni àra ènjia wuɗak ti, Yezu akaba ndam maɗəbay naŋ ni tòru a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tòru tìnjʉa ti Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu. Eslini àdi ahàr ana ndam məsəkumoru slasla, təmbəmbak, kurkodúk, akaba ndam mambay siŋgu manjəhaɗani. ");
INSERT INTO muy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Àra àdia ahàr ana tay a nahkay ti àzay ezeweɗ, àslapaya kurupu gana, àgaraya tay a dalaka ga ahay ni ba ɗek : àgaraya təmbəmbak akaba slasla gatay na daya. Àboru siŋgu ga ndam mambay siŋgu ni ka haɗ, àhəmbahaɗaba tabəl gana daya. ");
INSERT INTO muy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mək àhi ana ndam məsəkumoru kurkodúk ni ahkado : « Həlumaba zlam ndana ahalay a ! Kə̀grum ti ahay ga Bəŋ goro ni egi gosku ba. » ");
INSERT INTO muy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ndam *maɗəbay Yezu ni tàra tìpia ere ye ti àgray na ti, tə̀sərki ka pakama ge Melefit ya àbu məbəkiani a Wakita gayaŋ ni bu ni. Pakama gani nihi : « Bay Melefit goro, nawayay ahay gayak dal-dal. Nawayay kwa, do ni nànjəhaɗ koksah. » ");
INSERT INTO muy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Eslini gəɗákani ga ndam Zʉde tìhindifiŋa ma kà Yezu a, tə̀hi ahkado : « Kisliki magray mam tata mam ? Graya zlam magray ejep a ti mə̂sər Melefit àvuka divi ga magray ere ye ti kàgray ahalay na. » ");
INSERT INTO muy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yezu àhi ana tay ahkado : « Mbeɗʉmkaba ahay gəɗakani ge Melefit hina. Kèmbeɗʉmkaba nahəma, a huɗ ga vaɗ mahkərani ni bu ni ti nələmaba. » ");
INSERT INTO muy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Wuɗaka tìndeveriŋ mələm ahay hini ti, tə̀zumkia vi a kru kru faɗ mahar muku a. Nak ti kə̀ɗəm kələmaba a huɗ ga vaɗ mahkərani ba ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ay ahay gəɗakani ya Yezu àɗəmki ma ni ti, àɗəmki ka vu gayaŋ gayaŋani. ");
INSERT INTO muy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Yezu àra àməta mək àŋgaba e kisim ba ni ti ndam maɗəbay naŋ ni tə̀sərki ka ma nani ya àɗəm ni. Nahkay nday nakəŋ tə̀gəskabu pakama ya àbu məbəkiani a Wakita ge Melefit bu ni akaba ma ga Yezu ya àɗəmbiyu ni. ");
INSERT INTO muy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka ya ti Yezu naŋ àbu a Zerʉzalem a wuməri ga *Pak bu ni ti àgra zlam ya agri ejep ana mis na dal-dal. Mis tàra tìpia ti mis kay e kiɗiŋ gatay bu tə̀fəkia ahàr ka Yezu a, tə̀ɗəm naŋ gəɗakani. ");
INSERT INTO muy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ay Yezu ti ni àfəki ahàr ka tay ndo, aɗaba àsəra tay a ɗek lala. ");
INSERT INTO muy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Àwayay ti mis təhiki ma àki ka ku way way do do, aɗaba naŋ àsəra majalay ahàr ge mis a ɗek. ");
INSERT INTO muy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Zal nahaŋ àbu slimi gani Nikodem ; naŋ zal Feriziyeŋ, naŋ gəɗakani ga ndam *Zʉde daya. ");
INSERT INTO muy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ga məlavaɗ a vaɗ nahaŋ nahəma àrəkia ka Yezu a, àhi ahkado : « Mʉsi, mə̀səra Melefit àslərbiyu kur ga macahi zlam ana leli, aɗaba maslaŋa àbi agray zlam magray ejep akaɗa gayak ni bi, si tamal ti Melefit àvia njəɗa gana ana maslaŋa gana kwa. » ");
INSERT INTO muy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yezu àhəŋgrifəŋ, àhi : « Nəhuk nahəma, maslaŋa àbi epi *Məgur ge Melefit bi, si tamal tìweya naŋ nahaŋ a keti kwa. » ");
INSERT INTO muy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodem nakəŋ èhindifiŋa ma, àhi : « Mis gəɗakani àndava ti tiweya naŋ nahaŋ a keti ti agravu waw ? Esliki məŋguyani a huɗ ga məŋani vu mək tiweya naŋ nahaŋ a keti aw ? » ");
INSERT INTO muy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yezu àhəŋgrifəŋ, àhi keti : « Nəhuk nahəma, maslaŋa àbi ahuriyu a Məgur ge Melefit vu bi, si tamal tìweya naŋ àna yam a akaba Məsuf Njəlatana kwa. ");
INSERT INTO muy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maslaŋa ya ti mis hihirikeni ewi ni ti naŋ mis ciliŋ. Maslaŋa ya *Məsuf Njəlatani ewi ni ti naŋ àbu àna Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ma goro ya nə̀huk : “Ahàr àɗəm lekʉlʉm ɗek si tîweya kʉli nahaŋ a keti kwa” ni ti àgruk ejep ba. ");
INSERT INTO muy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ere ye ti nəhukki ma ni ti akaɗa ga aməɗ ya akəzlay ka məlaŋ ya naŋ awayay ni. Kici mahənday gani ciliŋ ; kə̀sər məlaŋ ya ècikbiyu ni do, kə̀sər məlaŋ ya akoru ni do daya. Ku way way do *Məsuf ge Melefit èwia naŋ a ti naŋ day nahkay. » ");
INSERT INTO muy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Eslini Nikodem nakəŋ àhi : « Ere gani nani agravu ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yezu àhi keti : « Nak bay macahi zlam ana ndam *Izireyel ti kə̀sər zlam nday nani do aw ? ");
INSERT INTO muy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nəhuk nahəma, ere ye ti leli məɗəmki ma ni ti leli mə̀səra àndava. Ere ye ti leli magrakia sedi a ni ti, leli mìpia àndava. Ay lekʉlʉm ti ni kə̀gəsumkabu ma geli ya məhi ana kʉli ni do. ");
INSERT INTO muy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tamal lekʉlʉm kə̀gəsumkabu ma goro ya nəhi ana kʉli àki ka zlam ya agravu ka haɗ ni do ni ti, akəgəsumkabu ma goro ya anəhi ana kʉli àki ka zlam ya agravu e melefit bu ni ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maslaŋa ya ti àcəloya e melefit va ti àbi, si nu *Wur ge Mis, aɗaba nàsləkabiya eslina. ");
INSERT INTO muy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ahaslani a huɗ gili bu ni ti Mʉwiz àvəɗaya gavaŋ ga evirzegena, àfəki ka ahàr ga təndal, àzoru agavəla. Nu Wur ge Mis day si tə̂zoru nu agavəla nahkay kwa. ");
INSERT INTO muy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nahkay ti ku way way do àfəkua ahàr a ti Melefit avi *sifa ya àndav ɗay-ɗay do ni. ");
INSERT INTO muy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nə̀ɗəm nahkay ti aɗaba Melefit àwaya mis ga duniya dal-dal. Nahkay àslərbiyu Wur gayaŋ bəlaŋ bəlaŋani ni, àvi ana tay, ti ku way way do tamal àfəkia ahàr ka Wur na ti èji do, aŋgət sifa ya àndav ɗay-ɗay do ni sawaŋ. ");
INSERT INTO muy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Melefit àslərbiyu Wur gayaŋ a duniya vu ti ga məgəs mis ga duniya ni àna seriya do : àslərbiyu naŋ ti ga mahəŋgay mis ga duniya àna naŋ sawaŋ. ");
INSERT INTO muy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Maslaŋa ya ti afəki ahàr ka Wur ge Melefit ni ti, Melefit àgəs naŋ àna seriya do. Ay maslaŋa ya àfəki ahàr do ni ti, Melefit àgəsa naŋ àna seriya àndava, aɗaba àfəki ahàr ka Wur ge Melefit bəlaŋ bəlaŋani ni ndo. ");
INSERT INTO muy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","« Seriya ya Melefit agəs mis àna naŋ ni ti nihi : àslərbiyu Wur gayaŋ a duniya vu ga maslaɗi məlaŋ ana mis, ay mis tàwayay məlaŋ maslaɗani ni ndo, tàwayay manjəhaɗani a məlaŋ ziŋ-ziŋeni bu sawaŋ. Tagray nahkay ti aɗaba tə̀bu tagudar zlam. ");
INSERT INTO muy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ku way way do tamal agudar zlam ti àwayay məlaŋ maslaɗani do ; àwayay məhuriyani a huɗ gani vu do daya, aɗaba awayay ti zlam magədavani gayaŋ ni àŋgazlavu ba. ");
INSERT INTO muy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ay maslaŋa ya ti agray jiri ni awayay məhuriyani a məlaŋ maslaɗani ni vu, aɗaba àgray tʉwi gayaŋ àna njəɗa ge Melefit, nahkay awayay ti tʉwi ni mâŋgazlavu. » ");
INSERT INTO muy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yezu akaba ndam ya taɗəbay naŋ ni tàsləka, tòru ka məlaŋ nahaŋ ka haɗ *Zʉde. Tòru tìnjʉa eslina ti Yezu ànjəhaɗ akaba tay, naŋ àbu *abaray mis. ");
INSERT INTO muy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ka sarta gani nani ti Zeŋ day naŋ àbu abaray mis a Enoŋ kà gəvay ga kəsa Selim. Zeŋ abaray mis eslini ti aɗaba yam àbu dal-dal. Nahkay mis dal-dal tə̀bu tərəkia mək abaray tay. ");
INSERT INTO muy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ka gayaŋ nani abaray mis ni ti, tə̀fiyu naŋ a daŋgay vu faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Eslini mis ya taɗəbay Zeŋ ni ndahaŋ e kiɗiŋ gatay bu tə̀bu tagray gejewi akaba zal Zʉde nahaŋ àki ke divi ga ndam *Zʉde ya taɗəbay ti tîgi *njəlatani ni. ");
INSERT INTO muy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nahkay nday nakəŋ tə̀rəkioru ke Zeŋ, tə̀hi ahkado : « Mʉsi, bay ya a vaɗ nahaŋ àbu lekʉlʉm ata naŋ ke ledi ge Zʉrdeŋ kàgrakia sedia ni ti, nihi ti naŋ àbu abaray mis, mis ɗek tə̀bu tərəkioru. » ");
INSERT INTO muy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Eslini Zeŋ nakəŋ àhi ana tay ahkado : « Maslaŋa ya ti esliki magray tʉwi àna njəɗa gayaŋ gayaŋani ti àbi, si tamal Melefit àvia njəɗa gana kwa. ");
INSERT INTO muy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Lekʉlʉm lekʉlʉmeni day kəgrumkua sedi a tata, nə̀ɗəm : “Nu *Krist *Bay gəɗakani ya amara ni do ; Melefit àslərbiyu nu enji gayaŋ ciliŋ.” ");
INSERT INTO muy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nəɗəm nahəma, nu ti akaɗa zləba ga bay ya aday wal ni. Maslaŋa ya ti azay wal ni ti wal ni gayaŋ. Ay zləba gayaŋ ni kà gəvay gayaŋ, eci ma gayaŋ ; ècia dəŋgu ga bay ya aday wal na ti amər dal-dal. Nu day nəmər ti nahkay, məmərani gani èslʉva a vu va. ");
INSERT INTO muy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ahàr àɗəm njəɗa gayaŋ mâsagakivu, goro ti ni mə̂guloru. ");
INSERT INTO muy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","« Bay ya ti àsləkabiya agavəla nahəma, agur mis ɗek. Maslaŋa ya àsləkabiya agavəla do ni ti naŋ ka haɗ, azlapaki day ka zlam ya ka haɗ ni. Bay ya ti àsləkabiya a huɗ melefit ba ni ti agur mis ɗek, ");
INSERT INTO muy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","agray sedi ga zlam ya èpi akaba èci ni, ay maslaŋa àbi agəskabu pakama gayaŋ ni bi. ");
INSERT INTO muy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ay maslaŋa ya ti àgəskabá pakama gayaŋ a ti aɗəm pakama ge Melefit ti jiri eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Bay ya ti Melefit àslərbiyu naŋ ni ti aɗəm pakama ge Melefit, aɗaba Melefit àvia njəɗa ga Məsuf gayaŋ a ɗek. ");
INSERT INTO muy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Bəŋ ga Wur ni awayay Wur gayaŋ ni, àbi zlam ɗek a ahar vu ti mə̂gur. ");
INSERT INTO muy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Maslaŋa ya ti afəki ahàr ka Wur ni ti Melefit àvia *sifa ya àndav ɗay-ɗay do na àndava. Maslaŋa ya ti àfəki ahàr ka Wur ni do ni ti aməŋgət sifa gani do ; Melefit naŋ àbu azumki ɓəruv kekileŋa. » ");
INSERT INTO muy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Eslini mis tə̀bu təɗəm Yezu agray ti mis tâɗəbay naŋ akaba *abaray mis dal-dal àtama ge Zeŋ na. Yezu àsəra ndam *Feriziyeŋ day tìcia ma gana. ");
INSERT INTO muy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ge jiri ti abaray mis ti Yezu Yezuani do ; tabaray mis ti ndam ya taɗəbay naŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yezu àra àsəra ndam Feriziyeŋ ni tìcia ma gana nahkay ti, àsləka ka haɗ *Zʉde a, òru gwar ka haɗ *Gelili. ");
INSERT INTO muy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wuɗaka enjiyu e Gelili ti, si asləkaba gwar ka haɗ *Samari a kwa. ");
INSERT INTO muy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Naŋ àbu akoru ka haɗ Samari ti ènjʉa a kəsa nahaŋ va, təzalay kəsa nani Sikar. Kəsa gani nani ti kà gəvay ga vədaŋ ge Zekʉp ya àvi ana wur gani Zʉzef ni. ");
INSERT INTO muy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A vədaŋ nani bu ni ti suwa ge Zekʉp àvu mileni. Yezu àra àmətaɓkaba àna sawaɗay ge divi na, òru ènjʉa ti ànjəhaɗ digʉs kà suwa ni. Ka sarta gani nani ti fat wis. ");
INSERT INTO muy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Eslini wal Samari nahaŋ ara acah yam ti àdi ahàr ana Yezu nakəŋ. Naŋ àbu acahaya yam na ti Yezu àhi : « Vu nîsi ti ! » ");
INSERT INTO muy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ka sarta nani ti Yezu naŋ bəlaŋ, aɗaba ndam ya taɗəbay naŋ ni tàdəgoru a kəsa vu ga məsəkumbiyu zlam məzumani. ");
INSERT INTO muy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yezu àra àhia ma ana wal na nahkay ti, wal ni àhi ahkado : « Nak zal *Zʉde kìhindifua yam a kà nu wal Samari a ti ahəmamam ? » Wal ni àɗəm nahkay ti aɗaba ma ga ndam Zʉde àrakaboru akaba ndam Samari do. ");
INSERT INTO muy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yezu àhi : « Tamal ti kə̀səra ere ye ti Melefit avi ana mis na akaba maslaŋa ya ehindifʉka yam na ti, akal kìhindifiŋa yam kà naŋ a sawaŋ. Tamal kìhindia ti akal àvuka yam ya avay sifa na. » ");
INSERT INTO muy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Wal ni àhəŋgrifəŋ, àhi ahkado : « Maslaŋa goro ni, zlam macahaya yam a àfuk bi, suwa ni day zileŋ ti, kacahaya yam ya avay sifa na ti eley ? ");
INSERT INTO muy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Bəŋ ga bəŋ geli Zekʉp àmbribu suwa hini ana leli. Naŋ naŋani èsia yam ga suwa hina, bəza gayaŋ akaba zlam ga gənaw gayaŋ day tìsia. Nahkay ti kə̀hi ana ahàr kàtama Zekʉp àna gəɗakana waw ? » ");
INSERT INTO muy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yezu àhəŋgrifəŋ, àhi : « Ku way way do esi yam hini ti, yam amakaɗ naŋ kekileŋa. ");
INSERT INTO muy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ay maslaŋa ya ti esi yam goro ya anəvi ni ti yam amakaɗ naŋ ɗay-ɗay va do. Yam ya ti nu nəvi ni emigi akaɗa gəzəŋ ga yam a vu gayaŋ bu. Gəzəŋ ga yam nani ti aməvi *sifa ya àndav ɗay-ɗay do ni. » ");
INSERT INTO muy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nahkay wal nakəŋ àhi ahkado : « Maslaŋa goro ni, vu yam gani nani, ti yam àkaɗ nu va ba, nàra ahalay a ga macah yam va ba daya. » ");
INSERT INTO muy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yezu àhi : « Ru kâzalabiya zal gayak a, nak day kə̂ŋga. » ");
INSERT INTO muy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Wal ni àhi : « Zal goro àbi. » Yezu àhi : « Ma gayak ya kə̀ɗəm zal gayak àbi ni ti, ma ge jiri eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aɗaba kàda zawal a zlam, ay zal ya nak kə̀bu afa gani ni ti zal gayak do. Ma gayak ya kə̀ɗəm ni jiri eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wal ni àhi : « Maslaŋa goro ni, nihi ti nə̀səra nak bay mahəŋgaray *pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ata bəŋ geli ndam Samari tàzləbay Melefit ka həma hini. Ay lekʉlʉm ndam Zʉde kə̀ɗəmum tâzləbay Melefit ti si a Zerʉzalem kwa. » ");
INSERT INTO muy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yezu àhi : « Wal ni, gəskabá ma goro ya nəhuk na : sarta amara ti, akəzləbum Melefit ti ka həma hini do, a Zerʉzalem do daya. ");
INSERT INTO muy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Lekʉlʉm ndam Samari kəzləbum Melefit, ay ti kə̀sərum naŋ eɗeɗiŋ eɗeɗiŋeni do. Leli ndam Zʉde ti ni mazləbay Melefit, mə̀səra naŋ a, aɗaba Melefit àŋgazlivu ana leli ga mahəŋgay mis ɗek àna tʉwi ya àgri ana leli ni. ");
INSERT INTO muy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ay sarta àbu ara : nihi ti sarta gani nani ènjia àndava. Ka gani nani ti ndam ya ti tazləbay Melefit eɗeɗiŋ eɗeɗiŋeni ni ti atazləbay naŋ àna njəɗa ga Məsuf gayaŋ, àna jiri gayaŋ daya. Aɗaba Baba awayay ti mis tâzləbay naŋ ti nahkay. ");
INSERT INTO muy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Melefit ti naŋ Məsuf : nahkay ahàr àɗəm ndam ya tazləbay naŋ ni ti tâzləbay naŋ àna njəɗa ga Məsuf gayaŋ akaba àna jiri gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wal nakəŋ àhi : « Nə̀səra *Bay gəɗakani amara, naŋ ya ti təzalay naŋ *Krist ni. Eminjia ti, aməɗəfiaba zlam ana leli a ɗek. » ");
INSERT INTO muy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yezu àhəŋgrifəŋ, àhi : « Nu ya ti nəhuk ma nihi ti, nu Krist gani. » ");
INSERT INTO muy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ka ya ti Yezu àra àɗəma ma nana ti, nday ya ti taɗəbay naŋ ni tàsləkabiya a kəsa ni ba. Nday nakəŋ tàra tìpia Yezu a nday tə̀bu təzlapay nday ata wal ni ti àgri ejep ana tay a. Ay maslaŋa ya àhi ana Yezu « Kihindifiŋa mam ? » ahkay do ni « Kazlapumki ka mam ? » ni ti àbi. ");
INSERT INTO muy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eslini wal ni àmbərbu mandaray gayaŋ ni, àsləka òru a kəsa vu. Òru ènjʉa ti àhi ana mis ahkado : ");
INSERT INTO muy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","« Nə̀dia ahàr ana maslaŋa nahaŋ a, àhuaya ere ya nàgrabiya na ɗek. Bi naŋ Krist Bay gəɗakani ya amara ni. Dəguma makoru ti kîpʉmbiyu naŋ a. » ");
INSERT INTO muy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mis ga kəsa ni tàra tìcia ma ga wal na ti, tìcikbiyu tə̀rəkia ka Yezu a. ");
INSERT INTO muy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka sarta ya ti wal ni àdoru a kəsa vu ni ti, ndam ya taɗəbay Yezu ni tə̀bu təhi ana Yezu : « Mʉsi, caka zlam a day. » ");
INSERT INTO muy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ay Yezu àhi ana tay ahkado : « Nu nə̀bu àna zlam məzumani ya lekʉlʉm kə̀sərum do ni. » ");
INSERT INTO muy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ndam ya taɗəbay naŋ ni tàra tìcia ma gayaŋ na ti tə̀zlapay e kiɗiŋ gatay bu tə̀ɗəm ahkado : « Bi maslaŋa àzibiya zlam məzumana zla tək ? » ");
INSERT INTO muy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Eslini Yezu àhi ana tay : « Zlam məzumani goro ni ti, magray ere ye ti Bay ya àslərbiyu nu awayay ni akaba mendeveriŋ tʉwi gayaŋ ya ti àvu ni. ");
INSERT INTO muy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lekʉlʉm kəɗəmum : “Àvu kiyi faɗ day kwa ti atabaz zlam.” Ay nu ti nəhi ana kʉli : Mənjumoru zlam ya a vədaŋ bu ni lala. Zlam ni tə̀ndəhkabá, èslia mabazana. ");
INSERT INTO muy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maslaŋa ya abaz zlam ni tə̀via endif gayaŋ a àndava, naŋ àbu acakalakabu zlam ga vədaŋ ni. Zlam nday nani ti mis ya ti atəŋgət sifa ya àndav ɗay-ɗay do ni. Nahkay ti bay ya ezligi zlam ni nday ata bay ya ti abaz ni tə̂mərvu ka ahar bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma *gozogul ge mis ya təɗəm : “Maslaŋa nahaŋ ezligi, maslaŋa nahaŋ ara abaz” ni ti jiri eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nu ti nə̀sləroru kʉli ga mabaz zlam a vədaŋ bu. Vədaŋ gani nani ti lekʉlʉm kə̀grum tʉwi gani ndo. Lekʉlʉm kabazum ciliŋ, mis ndahaŋ tàmətaɓkiaya ke kʉli a. » ");
INSERT INTO muy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndam Samari tàra tìcia ma ga wal ya àhi ana tay : « Àhuaya ere ye ti nàgrabiya na ɗek » na ti, mis dal-dal e kiɗiŋ gatay bu tə̀fəki ahàr ka Yezu. ");
INSERT INTO muy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ndam Samari ni tàra tìnjikia ka Yezu a ti tàhəŋgalay naŋ, tə̀hi : « Kam-kam njəhaɗa afa geli a ti ! » Nahkay Yezu ànjəhaɗ afa gatay vaɗ cʉ. ");
INSERT INTO muy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eslini tàra tìcia ma ga Yezu Yezuani ya àhi ana tay na ti, mis dal-dal tə̀fəki ahàr àkivu, tə̀tama nday ya ti tə̀fəki ahàr ye enjenjeni na àna kayana. ");
INSERT INTO muy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mək tə̀hi ana wal ni ahkado : « Məfəki ahàr hi ti, azuhva pakama gayak ya kə̀hi ana leli ni ciliŋ do. Mə̀fəki ahàr ti aɗaba leli leleni mìcia pakama gayaŋ ya àɗəm na àna slimi geli gelena. Mə̀səra naŋ Bay ya ti ahəŋgay ndam ga *duniya ɗek eɗeɗiŋ ni. » ");
INSERT INTO muy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yezu àra àpəsa vaɗ cʉ eslina ti, àsləka òru e Gelili ; ");
INSERT INTO muy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","àɗəm : « Bay mahəŋgaray *pakama ge Melefit ti, mis ga haɗ gayaŋ gayaŋani tə̀həŋgrioru ahàr a haɗ do. » ");
INSERT INTO muy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ay òru ènjʉa e Gelili a ti, ndam Gelili tə̀gəskabá naŋ a, aɗaba nday day tòra ka wuməri a Zerʉzalem a, tìpibiya tʉwi ga Yezu ya àgrabiyu eslini na ɗek palam. ");
INSERT INTO muy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ka ya ti Yezu àbu eslini e Gelili ni ti àŋgoru a Kana. Kana ti kəsa ya ti Yezu àmbatkaba yam a àmbavu zum ni. Eslini maslaŋa nahaŋ àbu, maslaŋa nani ti kəsa gayaŋ Kafarnahum, agri tʉwi ana bay ga haɗ Gelili. Wur gayaŋ àbiyu a magam, èɓesey do. ");
INSERT INTO muy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Àra ècia Yezu àsləkabiya e Zʉde a, naŋ àbu e Gelili ti, àrəkia àhi : « Wur goro èɓesey do, awayay amət ; kam-kam tokumkaboru, kôru kâhəŋgaraba naŋ a ti ! » ");
INSERT INTO muy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yezu àhi : « Tamal lekʉlʉm kìpʉm zlam njəɗa-njəɗani ya təgri ejep ana mis ni ndo ni ti, kə̀fumku ahàr do simiteni. » ");
INSERT INTO muy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eslini bay məgri tʉwi ana bay ni àhi ana Yezu ahkado : « Bay goro, tamal kòru kàhəŋgaraba wur goro na do ni ti, aməmət. » ");
INSERT INTO muy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yezu àhi : « Sləka, wur gayak naŋ àbu lala, àmət do. » Bəŋ ga wur ni àgəskabá pakama ga Yezu na, mək àsləka. ");
INSERT INTO muy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Naŋ àbu e divi bu aŋgoru a magam nahəma, tàbakabu ahàr akaba ndam ya tə̀gri tʉwi ni, tə̀hi : « Wur gayak àŋgaba, naŋ àbu lala. » ");
INSERT INTO muy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Èhindifiŋa kà tay a, àhi ana tay ahkado : « Àgri ŋgulumani ti àna njemdi ehimey ? » Tə̀həŋgrifəŋ, tə̀hi : « Aku àhəlkia ewena àna njemdi biliŋ ya ga məlakarawa. » ");
INSERT INTO muy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Àra ècia ma gatay na ti àsər wur ni àŋgaba ti ka sarta ya Yezu àhi « Wur gayak ni àŋgaba, naŋ àbu lala » ni. Eslini naŋ nakəŋ àfəki ahàr ka Yezu ; ndam ga huɗ ahay gayaŋ ni tàra tìcia ma gana ti nday day tə̀fəki ahàr ka Yezu. ");
INSERT INTO muy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hini ti zlam magray ejep ga Yezu ya àgray ye cʉ ka haɗ Gelili ka ya ti àsləkabiya ka haɗ *Zʉde a ni. ");
INSERT INTO muy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Àgra vaɗ a ɓal ti ndam *Zʉde tàgray wuməri nahaŋ a Zerʉzalem, nahkay Yezu òru. ");
INSERT INTO muy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eslini a Zerʉzalem ti məlaŋ nahaŋ àvu, yam àvu dizliva. Məlaŋ nani ti slimi gani Becata àna ma *Hebri ; kà gəvay ga mahay ya təzalay ga təmbəmbak ni, tàgrafəŋaya ahay a zlam ga məvi zʉhweri ana mis ye eslini na. ");
INSERT INTO muy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A huɗ ga ahay nday nani bu ni ti ndam ga arməwər tə̀vu kay mandəhaɗani : ndam wuluf, ndam jigwer akaba ndam dəra. Tajəgay ti yam ni mâdaɗay, ");
INSERT INTO muy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","aɗaba ka sarta ndahaŋ ti *məslər ge Melefit ahuriyu a huɗ ga yam ni vu adaɗay yam ni. Eslini maslaŋa ya ahuriyu a yam ni vu enji ni ti ku mam awər naŋ mam nəŋgu ni aŋgaba. ");
INSERT INTO muy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Maslaŋa nahaŋ àbu eslini èɓesey do vi kru kru mahkər mahar azlalahkər. ");
INSERT INTO muy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yezu èpia naŋ a naŋ àbu mandəhaɗani, àra àsəra arməwər gayaŋ ni àpəskia ti, àhi : « Kawayay ti kəŋgaba waw ? » ");
INSERT INTO muy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Maslaŋa ya ti èɓesey do ni àhəŋgrifəŋ, àhi : « Bay goro, maslaŋa goro àbi ga məfiyu nu a yam ni vu ke weceweceni ka ya ti adaɗay ni bi. Ka ga yam ya adaɗay ni wuɗaka nəhuriyu ti maslaŋa nahaŋ embʉkia. » ");
INSERT INTO muy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ay Yezu àhi : « Cikaba, za hətav gayak na, sawaɗay. » ");
INSERT INTO muy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Eslini naŋ nakəŋ àŋgaba hʉya, àzay hətav gayaŋ ni, mək asawaɗay. Zlam nani àgravu ti ka fat məpəsabana. ");
INSERT INTO muy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nahkay gəɗákani ga ndam Zʉde tə̀hi ana zal ya ti àŋgaba ni ahkado : « Kani vaɗ *məpəsabana ti, kìsliki mazay hətav gayak ni do. » ");
INSERT INTO muy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naŋ nakəŋ àhi ana tay ahkado : « Maslaŋa ya ti àhəŋgaraba nu a ni àhu : “Zay hətav gayak ni, sawaɗay.” » ");
INSERT INTO muy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nday nakəŋ tìhindifiŋa, tə̀hi : « Maslaŋa ya àhuk : “Zay hətav gayak ni, sawaɗay” ni ti way ? » ");
INSERT INTO muy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ay maslaŋa ya ti àŋgaba ni àsər way ti àhəŋgaraba naŋ a ni way do, aɗaba Yezu àsləkaba e kiɗiŋ ge mis dal-dalani ni ba. ");
INSERT INTO muy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kələŋ gani Yezu òru àdi ahàr ana maslaŋa ya ti àŋgaba ni a dalaka ga *ahay gəɗakani ge Melefit ni bu, mək àhi : « Nihi kə̀ŋgaba nahəma, kàgudar zlam va ba. Nahkay do ni ti, araŋa nahaŋ amagrakukvu àtam nahaŋ ni. » ");
INSERT INTO muy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eslini maslaŋa nakəŋ àsləka, àrəkioru ka gəɗákani ga ndam Zʉde ni, àhi ana tay : « Maslaŋa ya ti àhəŋgaraba nu a ni ti Yezu. » ");
INSERT INTO muy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nahkay gəɗákani ga ndam Zʉde ni tàɗəbafəŋa ma kà Yezu a aɗaba àgray tʉwi nani ti a vaɗ məpəsabana ba. ");
INSERT INTO muy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ay ti Yezu àhi ana tay : « Bəŋ goro àpəsaba do, naŋ àbu agray tʉwi kəlavaɗ ; nu day nə̀pəsaba do nə̀bu nagray tʉwi kəlavaɗ. » ");
INSERT INTO muy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Naŋ nakəŋ àra àɗəma nahkay ti, gəɗákani ga ndam Zʉde ni àwərikiva ɓəruv ana tay a dal-dal, tawayay takaɗ naŋ. Tawayay takaɗ naŋ ti aɗaba naŋ àbu agray zlam ya təcafəŋa mis ga magrana a vaɗ məpəsabana ba na ciliŋ do, naŋ àbu aɗəm Melefit naŋ bəŋani daya. Àɗəm nahkay ti, àzay ahàr gayaŋ nday kala-kala ata Melefit. ");
INSERT INTO muy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yezu àhi ana tay keti : « Nəhi ana kʉli nahəma, Wur èsliki magray tʉwi ga ahàr gayaŋ gayaŋani do. Agray ti si tʉwi ya ti èpia Bəŋani naŋ àbu agray ni kwa. Tʉwi ga Bəŋ ga Wur ya agray ni ɗek ti Wur gayaŋ ni day agray. ");
INSERT INTO muy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aɗaba Bəŋ ga Wur ni ti awayay Wur gayaŋ, aɗəfiki tʉwi ya ti agray ni ɗek. Aməɗəfiki tʉwi ndahaŋ gəɗákani tə̀tam nday ndani, ti mə̂gri ejep ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Bəŋ ga Wur ni naŋ àbu ahəŋgaraba mis ya tə̀məta ni e kisim ba, avi sifa ana tay : Wur gayaŋ ni day avi sifa ana mis akaɗa gayaŋ ya awayay ni. ");
INSERT INTO muy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nahkay day Bəŋ ga Wur ni àgrafəŋa seriya kè mis a do : àvi njəɗa gani ana Wur gayaŋ ni ti mâgrafəŋa seriya kè mis a. ");
INSERT INTO muy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Àgray nahkay ti aɗaba awayay ti mis ɗek tə̂həŋgrioru ahàr a haɗ ana Wur gayaŋ ni akaɗa ya ti təhəŋgrioru ahàr ana haɗ ana Bəŋ ga Wur ni. Maslaŋa ya ti àhəŋgrioru ahàr a haɗ ana Wur ni do ni ti àhəŋgrioru ahàr a haɗ ana Bəŋ ga Wur ni do daya, aɗaba Wur ni ti Bəŋani àslərbiyu naŋ. ");
INSERT INTO muy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","« Nəhi ana kʉli nahəma, maslaŋa ya ti agəskabu pakama goro, afəki ahàr ka Bay ya ti àslərbiyu nu ni, naŋ àbu àna *sifa ya àndav ɗay-ɗay do ni. Melefit aməgəs naŋ àna seriya do : kisim aməgri araŋa va do aɗaba naŋ àbu àna sifa ya àndav ɗay-ɗay do ni àndava. ");
INSERT INTO muy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nəhi ana kʉli nahəma, sarta nahaŋ àbu ara wuɗak, ay nihi ti ènjia àndava. Ka gani nani ti ndam ya nday məmətani ni etici dəŋgu ga Wur ge Melefit. Nday ya ti tìcia dəŋgu gayaŋ na ti atəŋgət sifa ya àndav ɗay-ɗay do ni. ");
INSERT INTO muy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aɗaba mam, Bəŋ ga Wur ni avi sifa gayaŋ ana mis ; nahkay àvia njəɗa ana Wur gayaŋ na ga məvi sifa gayaŋ ana mis a daya. ");
INSERT INTO muy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Àvia njəɗa ana Wur gayaŋ ga magrafəŋa seriya kè mis a, aɗaba Wur gayaŋ ni ti naŋ *Wur ge Mis daya. ");
INSERT INTO muy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma hini ya nə̀ɗəm ni ti àgri ejep ana kʉli ba, aɗaba sarta àbu ara, sarta gani nani eminjia ti mis ya ti tə̀məta, tə̀vu e eviɗ bu ni ɗek etici dəŋgu ga Wur ni. ");
INSERT INTO muy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Eticia dəŋgu gayaŋ na ti, atahəraya e eviɗ ni ba. Nday ya ti tàgra zlam sulumana ni ataŋgaya ga məŋgət sifa ya àndav ɗay-ɗay do na, ay nday ya ti tàgudara zlam a ni ataŋgaya ti tə̂gəs tay àna seriya. ");
INSERT INTO muy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nu ti nìsliki məgri zlam àna ahàr goro goroani koksah. Nagrafəŋa seriya kè mis a ti akaɗa ge Melefit ya ahu ni. Seriya goro ya nagray ni seriya ge jiri, aɗaba nàwayay magray ere ye ti ahàr goro awayay ni do. Nagray ti ere ye ti Bay ya ti àslərbiyu nu ni awayay ni sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Yezu àhi ana tay keti : « Tamal nu nuani nagrakia sedi ka ahàr goro a ti, akal jiri do. ");
INSERT INTO muy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ay agrakua sedi a ti maslaŋa nahaŋ : nə̀səra sedi gayaŋ ya agrakua ni ti ge jiri. ");
INSERT INTO muy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Lekʉlʉm kə̀slərumkioya mis ke Zeŋ a ; tòru tìnjikiya ka naŋ a ti àgrakua sedi a. Sedi gayaŋ ya àgrakua ni ti ge jiri. ");
INSERT INTO muy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nu ti sedi ge mis ya tagrakua ni ti araŋa gani goro do. Nə̀hi ma ge Zeŋ ana kʉli ti aɗaba nawayay kə̂gəsumkabu. Kə̀gəsumkabá ti Melefit ahəŋgay kʉli. ");
INSERT INTO muy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Zeŋ ti akaɗa ge ceŋgel ya tèbefta, aslaɗi məlaŋ ana mis ni. Ka sarta nahaŋ ɓal ti kə̀mərumva àna maslaɗani gayaŋ na. ");
INSERT INTO muy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ay nu ti tʉwi goro ya nagray ni agrakua sedi a. Sedi gani nani ti àtam ge Zeŋ ya àgrakua ni. Tʉwi gani nani ti Bəŋ goro àvu ti nâgray ; agrakua sedi a, aɗafaki ti Bəŋ goro àslərbiyu nu eɗeɗiŋ ni ti zlam gani nani. ");
INSERT INTO muy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Bəŋ goro àslərbiyu nu, naŋ naŋani àna ahàr gayaŋ day agrakua sedi a. Ay lekʉlʉm ti kìcʉm dəŋgu gayaŋ ɗay-ɗay ndo, kìpʉm naŋ e eri vu ɗay-ɗay ndo daya. ");
INSERT INTO muy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Kàwayum məgəskabu pakama gayaŋ ti mânjəhaɗivu ana kʉli a ahàr bu do, aɗaba kə̀fumki ahàr ka Bay ya ti Bəŋani àslərbiyu naŋ ni do. ");
INSERT INTO muy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Lekʉlʉm kə̀mbrəŋum mejeŋgey Wakita ge Melefit do, aɗaba kə̀humi ana ahàr akəŋgətum *sifa ya àndav ɗay-ɗay do ni ti àna naŋ. Ma ga wakita gani nani ti aɗəmku ka nu, ");
INSERT INTO muy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ay kàwayum marana afa goro a ti nə̂vi sifa gani nani ana kʉli do. ");
INSERT INTO muy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","« Nàwayay ti mis hihirikeni âzləbay nu do. ");
INSERT INTO muy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ay nə̀səra kʉli a : nə̀səra lekʉlʉm ti kàwayum Melefit àna huɗ bəlaŋ do. ");
INSERT INTO muy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nu nàra ti Bəŋ goro àslərbiyu nu, ay lekʉlʉm kàwayum məgəskabu nu do. Tamal maslaŋa nahaŋ ara ga ahàr gayaŋ gayaŋana ti, kəgəsumkabu naŋ. ");
INSERT INTO muy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lekʉlʉm kəzləbumvu e kiɗiŋ gekʉli bu, ay Melefit naŋ bəlaŋ mâzləbay kʉli ti kàwayum do. Nahkay ti kislʉmki məfəku ahàr ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","« Ŋgay nu anacalki kʉli ka zlam magudarani kè meleher ga Bəŋ goro ti kə̀humi ana ahàr ba. Lekʉlʉm kəgəsumkabu pakama ge Mʉwiz ya àbəki ni, ay amacalki kʉli ka zlam magudarani ni ti naŋ gani. ");
INSERT INTO muy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tamal kə̀gəsumkabá pakama ge Mʉwiz na eɗeɗiŋ a ti akal kəfumku ahàr, aɗaba ma ge Mʉwiz ya àbəki a wakita gayaŋ ni bu ni ti àɗəmku ka nu. ");
INSERT INTO muy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ay tamal kə̀gəsumkabu ma ge Mʉwiz ya àbəki ni do ni ti, akəgəsumkabu pakama goro ya ti nəhi ana kʉli ni ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A vaɗ nahaŋ Yezu òru ke ledi ga dəluv Gelili. Təzalay dəluv gani nani dəluv Tiberiyat daya. ");
INSERT INTO muy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ka ya ti naŋ àbu akoru ni ti mis dal-dal taɗəboru naŋ kələŋ, aɗaba tìpia gayaŋ ya àhəŋgaraba mis ya tèɓesey do na ti àgri ejep ana tay dal-dal. ");
INSERT INTO muy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Eslini Yezu akaba ndam maɗəbay naŋ ni tə̀cəliyu a həma vu, tànjəhaɗ. ");
INSERT INTO muy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ka sarta gani nani wuməri ga ndam *Zʉde ya təzalay *Pak ni ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nday tə̀bu ka ahàr ga həma nahkay ti Yezu àmənjoru mis dal-dal tə̀bu tərəkia. Àra èpia tay a ti àhi ana Filip ahkado : « Mawayay məvi zlam məzumani ana mis nday hini ti, makoru məsəkumibiyu *dipeŋ ana tay nihi ti eley ? » ");
INSERT INTO muy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yezu àhi nahkay ti, awayay ahəlfəŋa eyʉ a, aɗaba naŋ àsəra ere ye ti ara agray na palam. ");
INSERT INTO muy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip àhəŋgrifəŋ, àhi : « Ku tamal məsəkumibiyu dipeŋ ana tay ge jik diŋ diŋ cʉ, misi ana tay gʉzit gʉzit nəŋgu ni èsliki ka tay do timey ! » ");
INSERT INTO muy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Bay maɗəbay naŋ nahaŋ slimi gani Andre, wur ga məŋ ga Simu Piyer, àhi : ");
INSERT INTO muy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","« Wur nahaŋ nihi dipeŋ ga manjaɓara tə̀fəŋ zlam akaba kilif cʉ, ay ti təvi ana way bəlaŋani way ? » ");
INSERT INTO muy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Eslini Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Humi ana mis ni tânjəhaɗa digʉs-gʉs. » Kʉzir àbu eslini dal-dal, nahkay mis ni tànjəhaɗki. Mis zawalani ye eslini ni agray dəbu zlam. ");
INSERT INTO muy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yezu nakəŋ àhəl dipeŋ ni, àgri sʉsi ana Melefit, èsekaba, mək tìdi ana mis ni. Àra àhəla kilif na day àgray nahkay : mis ni ɗek tə̀zuma zlam na, tə̀rəha. ");
INSERT INTO muy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mis nakəŋ tə̀rəhkaba nahkay ti, Yezu àhi ana ndam maɗəbay naŋ ni ahkado : « Həlum məgəjəni gani, kə̀mbrəŋumbu araŋa gani gʉzit ba. » ");
INSERT INTO muy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nahkay tə̀həlaba məgəjəni ge dipeŋ zlamani ya mis tə̀zum na, tə̀rəhvù hətək kru mahar cʉ àna naŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mis ni tàra tìpia zlam ga Yezu ya àgray na ti àgria ejep ana tay a, tə̀ɗəm : « Maslaŋa hini ti bay mahəŋgaray *pakama ge Melefit ya tə̀ɗəm amara a duniya va na eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eslini Yezu àsəra tara təgəs naŋ ga njəɗa ti mîgi bay gatay. Àra àsəra nahkay ti àsləkafəŋa kà tay a, àcəloru gwar ka məlaŋ nahaŋ naŋ bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Məlakarawa àra ègia, ndam *maɗəbay Yezu ni tàhəraya kà gəvay ga dəluv ka sagdala. ");
INSERT INTO muy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Eslini tə̀cəliyu a *slalah ga yam vu, tawayay takoru ke ledi ga dəluv ni a Kafarnahum. Ka sarta gani nani məlaŋ èɗiza, Yezu àdi ahàr ana tay faŋ ndo. Nday nakəŋ mək tàsləka. ");
INSERT INTO muy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nday tə̀bu takoru nahkay ni ti aməɗ àkəzlabiyu ga njəɗa, àdaɗay dəluv ni. ");
INSERT INTO muy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tàgaroru slalah ga yam gatay ni ezeweɗ kru kru zlam ahkay do ni agray kru kru muku. Eslini tìpioru Yezu naŋ àbu asawaɗakibiyu ka ahàr ga dəluv ni, ahəɗakfəŋbiyu kà gəvay ga slalah ga yam gatay ni. Tàra tìpia naŋ a ti tàgra aŋgwaz a dal-dal. ");
INSERT INTO muy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ay Yezu àhi ana tay : « Aŋgwaz àwər kʉli ba, nu timey. » ");
INSERT INTO muy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yezu nakəŋ àra àhia ana tay a nahkay ti, tə̀hi mə̂cəlaya a slalah ga yam ni va, ay tə̀sərki ti slalah ga yam gatay ni ènjʉa ka məlaŋ ya tawayay takoru na. ");
INSERT INTO muy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Hajəŋ gani mis dal-dalani ya ndam *maɗəbay Yezu tə̀mbərbu tay ke ledi ga dəluv ni tə̀sərki ti *slalah ga yam ya ndam maɗəbay Yezu tàsləka àna naŋ a ni ti bəlaŋ, ndahaŋ tə̀bi. Mis ni tə̀səra Yezu àcəliyu a slalah ga yam nani vu akaba ndam maɗəbay naŋ ni ndo ; tə̀səra ndam maɗəbay Yezu ni tàsləka ka ahàr gatay a ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Eslini slalah ga yam ndahaŋ tàsləkabiya a Tiberiyat a, tòru ka məlaŋ ya ti Bay geli àgri sʉsi ana Melefit, mis tə̀zum *dipeŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mis ni tàra tə̀səra Yezu naŋ àbi eslini bi, ndam maɗəbay naŋ ni day tàsləka nahəma, tə̀cəliyu a slalah ga yam ya ti tàsləkabiya a Tiberiyat a ni vu, mək tòru a Kafarnahum, tàɗəboru Yezu. ");
INSERT INTO muy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tòru tìnjʉa ke ledi ga dəluv na ti, tə̀di ahàr ana Yezu nakəŋ mək tə̀hi : « Mʉsi, kàra ahalay hi a ti ananaw ? » ");
INSERT INTO muy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yezu àhəŋgarfəŋ, àhi ana tay ahkado : « Nəhi ana kʉli nahəma, kìpʉma tʉwi goro ya nagray, agri ejep ana mis na, ay ti kəɗəbum nu ti aɗaba nani do ; kəɗəbum nu ti aɗaba nə̀via dipeŋ ana kʉli a, kə̀rəhuma àna naŋ a palam. ");
INSERT INTO muy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kə̀grum tʉwi ga məŋgət zlam məzumani ya ti ezi ni ba, grum tʉwi ti ga məŋgət zlam məzumani ya avi sifa ana mis, àndav ɗay-ɗay do ni sawaŋ. Zlam məzumani gani nani ti, anəvi ana kʉli ti nu *Wur ge Mis ciliŋ, aɗaba Bəŋ goro Melefit àvua divi gana, àɗafaki bay ya ti esliki magrani ti nu gani. » ");
INSERT INTO muy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tàra tìcia ma gayaŋ na ti tìhindifiŋa, tə̀hi : « Ti mâgray tʉwi ge Melefit ya awayay ni ti magray mam ? » ");
INSERT INTO muy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yezu àhi ana tay ahkado : « Tʉwi ya ti Melefit awayay kə̂grumi ni ti, awayay kə̂fumki ahàr ka Bay ya ti àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nday nakəŋ tə̀hi : « Tamal kawayay ti mə̂fəkuk ahàr ti, griaya zlam magray ejep ana leli a, ti mîpi. Kəgriaya mam ana leli a nihi a mam ? ");
INSERT INTO muy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ata bəŋ ga bəŋ geli tə̀zumbiya *man a huɗ ge gili ba, akaɗa ya ti àbu məbəkiani a Wakita ge Melefit bu ni : “Àvi dipeŋ ya ti àsləkabiya a huɗ melefit ba ni ana tay, tə̀zuma.”  » ");
INSERT INTO muy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yezu àhi ana tay : « Nəhi ana kʉli nahəma, bay ya ti àvi dipeŋ ya àsləkabiya a huɗ melefit ba ana kʉli ni ti Mʉwiz do. Avi dipeŋ eɗeɗiŋ eɗeɗiŋeni ya asləkabiya e melefit ba ana kʉli ti Baba. ");
INSERT INTO muy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aɗaba dipeŋ ya Melefit avay nahəma, Bay ya àsləkabiya a huɗ melefit ba, avi sifa ana mis ga duniya ni. » ");
INSERT INTO muy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tàra tìcia ma gayaŋ na ti tə̀hi : « Mʉsi, vi dipeŋ gani nani ana leli kəlavaɗ ti ! » ");
INSERT INTO muy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yezu àhi ana tay : « Dipeŋ ya ti avi sifa ana mis ni ti nu. Maslaŋa ya ti ara afa goro a ni ti lʉwir aməwər naŋ ɗay-ɗay do. Maslaŋa ya ti afəku ahàr ni ti yam amakaɗ naŋ ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ay nə̀hia ana kʉli a àndava : Kìpʉma nu a mək kə̀fumku ahàr do. ");
INSERT INTO muy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ndam ya ti Baba abu tay ni ɗek atara afa goro a. Maslaŋa ya ti ara afa goro a nahəma, anagarakaba naŋ a ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aɗaba nàsləkabiya e melefit ba ti ga magray ere ye ti nu nawayay ni do. Nàsləkabiya ti ga magray ere ye ti Bay ya ti àslərbiyu nu ni awayay ni. ");
INSERT INTO muy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ere ye ti Bay ya ti àslərbiyu nu ni awayay ni ti nihi : awayay ti ndam ya ti naŋ àbuvu tay a ahar vu ni ku bəlaŋ gatay èjifua ba. Awayay ti ka mandav ga duniya ti nâhəŋgaraba tay e kisim ba. ");
INSERT INTO muy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Iy nahkay, ere ye ti Baba awayay ni ti nihi : awayay ti ku way way do èpia Wur ge Melefit a, afəki ahàr ti mə̂ŋgət *sifa ya àndav ɗay-ɗay do ni. Ku tamal maslaŋa gani àməta nəŋgu ni, Baba awayay ti ka mandav ga duniya ti nâhəŋgaraba maslaŋa gani nana e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yezu àra àɗəma ma na nahkay ti, ndam *Zʉde tə̀zlapaki e kiɗiŋ gatay bu aɗaba àɗəm naŋ dipeŋ ya àsləkabiya a huɗ melefit ba ni. ");
INSERT INTO muy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tə̀ɗəm ahkado : « Naŋ Yezu wur ge Zʉzef ni do waw ? Mə̀səra ata bəŋana ata məŋana ti, àɗəm àsləkabiya a huɗ melefit ba ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Eslini Yezu àhi ana tay : « Kàzlapumku e kiɗiŋ gekʉli bu va ba. ");
INSERT INTO muy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maslaŋa àbi esliki marana afa goro a bi, si tamal Baba naŋ ya àslərbiyu nu ni àzəbiya naŋ a kwa. Nahkay ti ka mandav ga duniya ti anahəŋgaraba maslaŋa gani nana e kisim ba. ");
INSERT INTO muy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ndam mahəŋgaray *pakama ge Melefit tə̀bəki a wakita gatay bu nahkay hi : “Mis ɗek Melefit amacahi zlam ana tay.” Nahkay ku way way do èciikia ma ga Baba na, àgəskabá zlam ya ti àcahi na ti, ara afa goro a. ");
INSERT INTO muy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ku nə̀ɗəma nahkay nəŋgu ni, maslaŋa ya ti èpia Baba ni ti àbi. Maslaŋa ya èpia Baba Melefit a ni ti si Bay ya ti àsləkabiya afa gana ni kwa. ");
INSERT INTO muy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","« Nəhi ana kʉli nahəma, maslaŋa ya ti àfəkua ahàr a ni ti naŋ àbu àna sifa ya àndav ɗay-ɗay do ni. ");
INSERT INTO muy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Dipeŋ ya ti avi sifa ana mis ni ti nu. ");
INSERT INTO muy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ata bəŋ ga bəŋ gekʉli tə̀zuma *man a huɗ gili ba, nihi ti tə̀mət ndo waw ? ");
INSERT INTO muy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ay dipeŋ ya asləkabiya a huɗ melefit ba ni ti maslaŋa ya ti àzuma nahəma àmət ɗay-ɗay do. ");
INSERT INTO muy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Dipeŋ ya àsləkabiya a huɗ melefit ba, naŋ àbu àna sifa ni ti nu. Maslaŋa ya ti àzuma dipeŋ nana ti àmət ɗay-ɗay do. Dipeŋ ya ti anəvi ni ti aslu ga vu goro. Anavay ti mis ga duniya ɗek tə̂ŋgət sifa àna naŋ. » ");
INSERT INTO muy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndam Zʉde ni tàra tìcia ma ga Yezu na ti tàləgavakivu, tə̀ɗəm : « Maslaŋa hini àɗəm avi aslu ga vu gayaŋ ana leli mahəpəɗ ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yezu àhi ana tay ahkado : « Nəhi ana kʉli nahəma, tamal kàhəpəɗum aslu ga vu ga Wur ge Mis akaba kìsʉm mimiz ga vu gayaŋ ndo ni ti, sifa aməniviyu ana kʉli bi. ");
INSERT INTO muy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Maslaŋa ya ti ahəpəɗ aslu ga vu goro akaba esi mimiz ga vu goro ni ti, naŋ àbu àna sifa ya àndav ɗay-ɗay do ni ; ka mandav ga duniya anəhəŋgaraba naŋ e kisim ba. ");
INSERT INTO muy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Aɗaba zlam məzumani eɗeɗiŋeni ti aslu ga vu goro, zlam miseni eɗeɗiŋeni ti mimiz ga vu goro. ");
INSERT INTO muy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Maslaŋa ya ti ahəpəɗ aslu ga vu goro akaba esi mimiz ga vu goro nahəma, anjəhaɗ akaba nu akaɗa mis bəlaŋ, nu day nanjəhaɗ akaba naŋ akaɗa mis bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baba àslərbiya nu a ; naŋ ti naŋ àbu àna sifa. Nu day nə̀bu àna sifa azuhva naŋ. Nahkay maslaŋa ya ti ahəpəɗ nu ni ti naŋ àbu àna sifa azuhva nu. ");
INSERT INTO muy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dipeŋ ya ti àsləkabiya a huɗ melefit ba ni ti nu gani. Dipeŋ gani nani ti akaɗa ga ata bəŋ ga bəŋ gekʉli ya tə̀zum mək tə̀mət ni do. Dipeŋ gani nani ti maslaŋa ya ti àzuma ni ti, naŋ àbu àna sifa ga kaŋgay-kaŋgayani. » ");
INSERT INTO muy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yezu àɗəm ma hini ti ka ya ti naŋ a Kafarnahum, acahi zlam ana mis a ahay ga *mahəŋgalavù Melefit bu ni. ");
INSERT INTO muy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ndam ya taɗəbay Yezu ni tàra tìcia ma gayaŋ na ti, mis kay e kiɗiŋ gatay bu tə̀ɗəm ahkado : « Ma hini zləzlaɗa àsaɓay ; way esliki məgəskabani way ? » ");
INSERT INTO muy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yezu àra àsəra ndam ya taɗəbay naŋ ni tə̀bu təzlapaki nahkay ti, àhi ana tay ahkado : « Ma goro ya nə̀ɗəm ni awəri ɓəruv ana kʉli aw ? ");
INSERT INTO muy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ay tamal ekipʉm nu *Wur ge Mis nə̀bu nəcəloru ka məlaŋ ya ti nu nə̀biyu ahaslani ni ti akəɗəmum mam ? ");
INSERT INTO muy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Avi sifa ana mis ti *Məsuf ge Melefit. Aslu ga vu ge mis ni ti ni zlam masakani. Ma goro ya nə̀hi ana kʉli ɗek ni ti Məsuf ge Melefit avi sifa ana kʉli àna naŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ay mis ndahaŋ tə̀bu e kiɗiŋ gekʉli bu tə̀fəku ahàr do. » Yezu àɗəm nahkay ti aɗaba kwa ka mənjəki ge tʉwi gayaŋ àsəra ndam ya tə̀fəki ahàr do akaba maslaŋa ya ti aməsəkumoru naŋ na àndava. ");
INSERT INTO muy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Àhi ana tay keti : « Nə̀hi ana kʉli, maslaŋa àbi esliki marana afa goro a bi, si Baba àvia njəɗa gana kwa ti, nahkay. » ");
INSERT INTO muy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwa ka sarta gani nani ndam ya taɗəbay Yezu ni dal-dal tàsləkafəŋa, tə̀mbrəŋ maɗəbay naŋ. ");
INSERT INTO muy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nahkay Yezu àhi ana ndam maɗəbay naŋ kru mahar cʉeni ni ahkado : « Lekʉlʉm day kawayum məsləkumfuana waw ? » ");
INSERT INTO muy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simu Piyer àhəŋgrifəŋ, àhi : « Bay geli, masləkafuka ti makoru afa ga way, way geli nahaŋ àbu way ? Pakama gayak ya kəɗəm ni avi sifa ya àndav ɗay-ɗay do ni ana mis. ");
INSERT INTO muy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mə̀bu məfəkuk ahàr, mə̀səra nak ti Bay *njəlatani ya Melefit àslərbiyu ni. » ");
INSERT INTO muy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yezu àhi ana tay ahkado : « Lekʉlʉm kru mahar cʉeni ni ti, nu nə̀daba kʉli a do waw ? Ay bəlaŋ gekʉli ti araŋa jəbəɗani. » ");
INSERT INTO muy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Àɗəm nahkay ti, àɗəmki ka Zʉdas wur ga Simu Iskariyot, naŋ bəlaŋ e kiɗiŋ gatay nday kru mahar cʉeni ni bu ; aməsəkumoru naŋ ti naŋ. ");
INSERT INTO muy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yezu àra àɗəma nahkay ti àsawaɗay a kəsa ndahaŋ bu ka haɗ *Gelili. Àwayay moroni ka haɗ *Zʉde do, aɗaba gəɗákani ga ndam *Zʉde tawayay makaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ka sarta gani nani wuməri ge mivicey ahay ga ndam Zʉde ni ènjia wuɗak. ");
INSERT INTO muy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nahkay bəza ga məŋ ga Yezu tə̀hi ana Yezu ahkado : « Sləka ahalay a, ru ka haɗ Zʉde, ti ku eslini day ndam ya taɗəbay kur ni tôru tîpi tʉwi gayak ya kagray ni. ");
INSERT INTO muy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aɗaba tamal mis awayay mis tə̂sər naŋ ti, àgray zlam akal-akal do. Tamal kagray tʉwi ni nahkay ti, ŋgazlaya ahàr gayak kè meleher ge mis a ɗek, ti tîpi kur. » ");
INSERT INTO muy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bəza ga məŋani tə̀hi nahkay ti aɗaba nday day tə̀fəki ahàr ndo. ");
INSERT INTO muy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yezu àhi ana tay ahkado : « Sarta gani goro ènjia faŋ ndo. Lekʉlʉm ti sarta gani gekʉli àbi ; ku ananaw kədəgum tata. ");
INSERT INTO muy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Lekʉlʉm ti mis ga duniya tìzirey kʉli koksah ; nu ti tizirey nu aɗaba nə̀bu nəhi ana tay zlam ya ti tagray ni ti zlam magədavani. ");
INSERT INTO muy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Lekʉlʉm ti dəgum ka wuməri ni. Nu ti nìnjioru ka wuməri gani nani do, aɗaba sarta gani goro ènjia faŋ ndo. » ");
INSERT INTO muy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yezu nakəŋ àra àhia ma nana ana tay a nahkay ti, ànjəhaɗ ka haɗ Gelili zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bəza ga məŋani tàra tàdəgoru ka wuməri ni ti Yezu nakəŋ day òru. Òru ti àŋgazlivu ana mis ndo, awayay ti tìpi naŋ ba. ");
INSERT INTO muy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mis tə̀cakalava ga magray wuməri na ti, gəɗákani ga ndam *Zʉde ni tàɗəbay Yezu, tə̀ɗəm : « Naŋ neley ? » ");
INSERT INTO muy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Mis dal-dalani ni tə̀bu təzlapaki dal-dal ; mis ndahaŋ tə̀ɗəm : « Naŋ mis sulumani. » Mis ndahaŋ ti ni tə̀ɗəm : « Aha, naŋ mis sulumani do, agosay mis sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ay maslaŋa àbi azlapaki vay-vay bi, aɗaba tagrafəŋa aŋgwaz kà gəɗákani ga ndam Zʉde a. ");
INSERT INTO muy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tàra tècekaba vaɗ ga wuməri na kala-kala ti, Yezu àhuriyu a dalaka ga *ahay gəɗakani ge Melefit ni vu mək ànjəki ka macahi zlam ana mis. ");
INSERT INTO muy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pakama gayaŋ ya àɗəm ni àgri ejep ana ndam Zʉde, tə̀ɗəm : « Naŋ hini èjeŋgey ndo ni ti, àsəra zlam a ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Eslini Yezu àhi ana tay : « Zlam goro ya ti nəcahi ana kʉli ni ti goro goroani do ; ga Bay ya ti àslərbiyu nu ni. ");
INSERT INTO muy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pakama goro ya ti nəɗəm ni ge Melefit tək goro goroani aw ti, tamal maslaŋa awayay agray ere ye ti Melefit awayay ni ti aməsərkaba. ");
INSERT INTO muy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Maslaŋa ya ti ahi ma gayaŋ gayaŋani ana mis nahəma, awayay ti mis tâzləbay naŋ. Ay maslaŋa ya ti agray tʉwi ti mis tâzləbay Bay ya ti àslərbiyu naŋ ni ti aɗəm ma ge jiri, àsəkaɗ malfaɗa do simiteni. ");
INSERT INTO muy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mʉwiz àɗəfiki *Divi ge Melefit ana kʉli ndo waw ? Ay e kiɗiŋ gekʉli bu maslaŋa bəlaŋ àbi agəskabu ma gani bi timey ! Kawayum mijiŋ nu ti, nàgudar mam ? » ");
INSERT INTO muy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mis dal-dalani ni tə̀hi ahkado : « Araŋa agray kur aw ? Way awayay mijiŋ kur way ? » ");
INSERT INTO muy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Eslini Yezu àhi ana tay : « Nàgra tʉwi a bəlaŋ mək àgria ejep ana kʉli a ɗek. ");
INSERT INTO muy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ku ka fat məpəsabana *kikelʉmi kʉɗi ana bəza, aɗaba Mʉwiz àhi ana kʉli kîkelʉm. Ay ànjəki ke mekeli kʉɗi ana bəza ti Mʉwiz do ; tə̀njəki enji ti ata bəŋ ga bəŋ gekʉli. ");
INSERT INTO muy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kikelʉmi kʉɗi ana bəza ka fat məpəsabana, kəɗəmum àgudar Divi ge Melefit ya ti Mʉwiz àvi ana kʉli ni do. Nahkay ti nu nàhəŋgaraba mis a jigʉriŋa ka fat məpəsabana ti, kəzumumku ɓəruv ti kamam ? ");
INSERT INTO muy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kacalumki nu ka zlam magudarani ti mənjəɗ majalaki ahàr. Kə̀grum nahkay va ba ; wuɗaka kəɗəmum ma nahəma, jalumkia ahàr a lala day. » ");
INSERT INTO muy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ndam Zerʉzalem ndahaŋ tə̀ɗəm ahkado : « Hini hi maslaŋa ya ti taɗəbay naŋ, tawayay takaɗ naŋ ni do aw ? ");
INSERT INTO muy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mənjumki : naŋ àbu azlapay vay-vay kè meleher ge mis ɗek, day tə̀hi ma ga araŋa do ni. Gəɗákani geli tə̀səra naŋ *Krist *Bay gəɗakani ya amara ni eɗeɗiŋ a waw ? ");
INSERT INTO muy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ay Bay gəɗakani ya amara ni eminjia ti mis atəsər məlaŋ gayaŋ ya ti àsləkabiya ni do. Maslaŋa hini ti leli mə̀səra məlaŋ gayaŋ ya ti àsləkabiya na. » ");
INSERT INTO muy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yezu naŋ àbu acahi zlam ana mis a dalaka ga *ahay gəɗakani ge Melefit ni bu, àhi ana tay kay kay, àɗəm : « Kə̀səruma nu a waw ? Kə̀səruma məlaŋ ya ti nàsləkabiya na eɗeɗiŋ a waw ? Nu nuani nàra àna ahàr goro goroana do. Ay Bay ya ti àslərbiyu nu ni ti naŋ jireni. Lekʉlʉm ti kə̀sərum naŋ do. ");
INSERT INTO muy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nu ti nə̀səra naŋ a, aɗaba nàsləkabiya afa gana ; àslərbiyu nu ti naŋ. » ");
INSERT INTO muy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yezu àra àɗəma ma nahkay ti nday nakəŋ tawayay təgəs naŋ. Ay ti maslaŋa èsliki minjifiŋeni do, aɗaba sarta gani gayaŋ ènjia faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","E kiɗiŋ ge mis dal-dalani ni bu mis kay tə̀vu, tə̀fəkia ahàr a, tə̀ɗəm ahkado : « Ka ya ti Krist Bay gəɗakani ya amara ni eminjia ni ti, amagray zlam məgri ejep ana mis amatam ga maslaŋa hini ya ti agray ni aw ? » ");
INSERT INTO muy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ndam *Feriziyeŋ tàra tìcia ma ge mis dal-dalani ya təɗəmki ka Yezu e kiɗiŋ gatay bu na ti, tə̀hi ma gani ana gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni, mək nday nakəŋ tə̀slərbiyu ndam slewja ga məgəs Yezu. ");
INSERT INTO muy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Eslini Yezu àɗəm ahkado : « Ananjəhaɗ akaba kʉli vaɗ kay do ; kələŋ gani anaŋgoru afa ga Bay ya ti àslərbiyu nu ni. ");
INSERT INTO muy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Akəɗəbum nu, ay ti akədumu ahàr do, aɗaba ekislʉmki moroni ka məlaŋ goro ya ti anoru ni do. » ");
INSERT INTO muy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ndam *Zʉde tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm ahkado : « Àɗəm amədi ahàr do ni ti, amoru ti eley ? Bi amoru afa ga ndam geli ya tanjəhaɗkabu akaba ndam ya ti nday ndam Zʉde do ni, bi amacahi zlam ana ndam ya ti nday ndam Zʉde do ni tək ? ");
INSERT INTO muy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma gayaŋ ya àɗəm : “Akəɗəbum nu, ay ti akədumu ahàr do, aɗaba ekislʉmki moroni ka məlaŋ goro ya ti anoru ni do” ni ti, awayay aɗəm mam ? » ");
INSERT INTO muy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka fat ya ti tindeveriŋ wuməri ni tagray wuməri àtam ga vaɗ nday ndahaŋ ni. Ka fat nani Yezu ècik jik, àhi ana mis ni kay kay, àɗəm : « Tamal maslaŋa yam àkaɗa naŋ a ti, mâra afa goro a, mîsi. ");
INSERT INTO muy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Maslaŋa ya ti afəku ahàr ni ti, Melefit àɗəm a Wakita gayaŋ ni bu : “Yam ya avay sifa ni aməŋgəzaya a vu ga maslaŋa gani nani ba akaɗa ga yam ya ti akoru a zalaka vu ni.”  » ");
INSERT INTO muy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yezu àɗəm nahkay ti àɗəmki ma ka *Məsuf ge Melefit, aɗaba amara məvi ana ndam ya ti təfəki ahàr ni. Ka sarta gani nani ti àvi ana tay faŋ ndo, aɗaba àŋgoru a məlaŋ maslaɗani ge Melefit ni vu faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mis dal-dalani ni tàra tìcia ma ga Yezu ya àɗəm na ti, mis ndahaŋ e kiɗiŋ gatay bu tə̀ɗəm : « Maslaŋa hini ti bay mahəŋgaray *pakama ge Melefit ya ti Mʉwiz àɗəm amara ni eɗeɗiŋ.  » ");
INSERT INTO muy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mis ndahaŋ tə̀ɗəm : « Naŋ *Krist *Bay gəɗakani ya amara ni. » Mis ndahaŋ ti ni tə̀ɗəm : « Ay Krist Bay gəɗakani ya amara ni naŋ mis ga haɗ *Gelili aw ? ");
INSERT INTO muy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Aɗaba Melefit àɗəm a Wakita gayaŋ ni bu Bay gəɗakani ya amara ni ti naŋ wur huɗ ge Devit. Naŋ ti zal Betlehem, naŋ ga kəsa ge Devit. » ");
INSERT INTO muy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nahkay mis dal-dalani ni tìcirvu azuhva Yezu. ");
INSERT INTO muy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Eslini mis ndahaŋ e kiɗiŋ gatay bu tə̀ɗəm si tə̂gəs naŋ kwa. Ay ti maslaŋa àbi ènjifiŋ bi. ");
INSERT INTO muy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ndam slewja ni tàra tàsləkabiya ti, gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam *Feriziyeŋ ni tə̀hi ana tay ahkado : « Kə̀gəsumbiyu naŋ ndo ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ndam slewja ni tə̀həŋgrifəŋ ana tay, tə̀hi ana tay ahkado : « Maslaŋa ɗay-ɗay àbi aɗəm ma akaɗa gayaŋ ni bi. » ");
INSERT INTO muy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ndam Feriziyeŋ ni tə̀hi ana tay ahkado : « Lekʉlʉm day àgosa kʉli a zla do waw ? ");
INSERT INTO muy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","E kiɗiŋ ga gəɗákani geli bu ahkay do ni e kiɗiŋ ga ndam Feriziyeŋ bu ni ti, maslaŋa àbu àfəkia ahàr ka maslaŋa nana waw ? ");
INSERT INTO muy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ndam ya ti təfəki ahàr ka maslaŋa nani ti, nday ya ti tə̀sər *Divi ge Melefit ya ti Mʉwiz àbəki ni do ni. Ay nday nani ti Melefit ètikwesla tay a. » ");
INSERT INTO muy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ay Nikodem naŋ ya ti àrəkioru ka Yezu ga məlavaɗ a vaɗ nahaŋ ni, naŋ àkibu ka tay eslini, àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","« E Divi ge Melefit ya Mʉwiz àbiki ana leli ni bu ni ti, mìsliki magrafəŋa seriya kè mis a do, si tamal mìcifiŋa ma akaba mə̀səra ere ye ti àgray na kwa. » ");
INSERT INTO muy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nday nakəŋ tə̀hi ahkado : « Nak day, nak zal Gelili zla tək ? Jeŋgey Wakita ge Melefit ni nahəma, akəsər zal Gelili àbi ahəŋgaray pakama ge Melefit bi. »  ");
INSERT INTO muy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kələŋ gani ti, mis ya ti eslini ni ku way way do gatay àsləka, òru a magam gayaŋ, ");
INSERT INTO muy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yezu ti ni àcəloru ka həma *Oliviye ni. ");
INSERT INTO muy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hajəŋ gani ge dʉeni nahəma, Yezu nakəŋ àŋgoru a dalaka ga *ahay gəɗakani ge Melefit ni vu. Òru ènjʉa ti mis ya ti eslini ni ɗek tə̀rəkia. Nahkay naŋ nakəŋ ànjəhaɗ digʉs, acahi zlam ana tay. ");
INSERT INTO muy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Naŋ àbu acahi zlam ni ana tay nahkay ti, ndam *məsər Wakita ge Melefit akaba ndam *Feriziyeŋ tə̀zəbiyu wal nahaŋ, tàfəkaɗ naŋ kè meleher ge mis ni ɗek. Wal nani ti tə̀di ahàr naŋ àbu agray hala. ");
INSERT INTO muy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tàra tàfəkaɗa naŋ a ti tə̀hi ana Yezu ahkado : « Mʉsi, wal hini ti tə̀cəkia naŋ ka magray hala. ");
INSERT INTO muy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mʉwiz àbəki ma gani e *Divi ge Melefit bu, àhi ana leli mîzligi wal hala akaɗa hini àna akur, mâkaɗ. Ay nak ti, kəɗəm mam ? » ");
INSERT INTO muy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tə̀hi nahkay ti tawayay təhəlfəŋa eyʉ a, ti tâcalki naŋ ka zlam magudarani. Ay Yezu nakəŋ àzəgaɗ ahàr jer mək àbəki zlam ka haɗ àna weleher. ");
INSERT INTO muy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nday nakəŋ tə̀mbrəŋ mihindifiŋa ma na kà Yezu a ndo, nahkay Yezu èzefteba ahàr a mək àhi ana tay ahkado : « Maslaŋa ya ti e kiɗiŋ gekʉli bu àgudar zlam ɗay-ɗay ndo ni ti mîzligi wal ni enji. » ");
INSERT INTO muy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Àra àhia ma ana tay a nahkay ti, àzəgaɗ ahàr mək àbəki zlam ka haɗ keti. ");
INSERT INTO muy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tàra tìcia ma ga Yezu ya àhi ana tay na ti tàsləka bəlaŋ àna bəlaŋ. Medewél tàsləka enji a. Nahkay wal ni àgəjəni naŋ bəlaŋ kè meleher ga Yezu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yezu àra èzefteba ahàr a ti àhi ana wal ni ahkado : « Mis nakəŋ nday eley ? Maslaŋa ya ti àɗəm tâkaɗ kur ni ti àbu waw ? » ");
INSERT INTO muy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wal ni àhəŋgrifəŋ, àhi ahkado : « Maslaŋa àbi, Bay goro ni. » Mək Yezu àhi : « Nu day ŋgay tâkaɗ kur ti nə̀ɗəm do. Sləka, ay ti kàgudar zlam ɗay-ɗay va ba. » ");
INSERT INTO muy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yezu àhi ana mis ni keti : « Nu ti bay ya ti aslaɗi məlaŋ ana mis ni. Maslaŋa ya ti aɗəbay nu nahəma, anəslaɗi məlaŋ, nahkay Melefit aməvi sifa. Ay maslaŋa ya ti àɗəbay nu do ni ti amanjəhaɗ a məlaŋ ziŋ-ziŋeni bu. » ");
INSERT INTO muy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Eslini ndam *Feriziyeŋ ndahaŋ tə̀hi ahkado : « Kagrakia sedi a ka ahàr gayak gayakana ti, ma gayak ni ma masakani. » ");
INSERT INTO muy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yezu àhi ana tay ahkado : « Ku nə̀bu nagrakia sedi a ka ahàr goro goroana nəŋgu ni, ma goro ya nəɗəm ni ma ge jiri, ma masakani do. Aɗaba nə̀səra məlaŋ ya nàsləkabiya na akaba məlaŋ ya nakoru na. Ay lekʉlʉm ti kə̀sərum məlaŋ ya nàsləkabiya na akaba məlaŋ ya nakoru ni do. ");
INSERT INTO muy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Lekʉlʉm kəɗəmum mis àgudara zlam a ti kajalum ahàr akaɗa ge mis hihirikeni ni. Ay nu nəɗəm mis àgudara zlam a ti nə̀jalay nahkay do. ");
INSERT INTO muy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ku tamal nagrafəŋa seriya kè mis a nəŋgu ni seriya goro ni ge jiri, aɗaba nagray ti nu bəlaŋ do ; Baba goro naŋ ya àslərbiyu nu ni naŋ àbu akaba nu. ");
INSERT INTO muy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Àbu məbəkiani e *Divi ge Melefit ya Mʉwiz àbiki ana kʉli ni bu nahkay hi : “Tamal mis cʉ tagray sedi, tə̀ɗəm ere gani jiri ti, ma gatay ni jiri eɗeɗiŋ.” ");
INSERT INTO muy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nu nagrakia sedi a ka ahàr goro goroana. Baba naŋ ya àslərbiyu nu ni day agrakua sedi a. » ");
INSERT INTO muy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Eslini tə̀hi ana Yezu ahkado : « Buk gani naŋ eley ? » Yezu nakəŋ àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Nu tekeɗi kə̀sərum nu nu way do ni ti, kə̀sərum Baba do daya. Tamal kə̀səruma nu a ti amal kə̀səruma Baba daya. » ");
INSERT INTO muy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yezu àɗəm ma hini ti ka ya ti naŋ àbu acahi zlam ana mis a dalaka ga *ahay gəɗakani ge Melefit ni bu ni, naŋ kà gəvay ga zlam ya təbiviyu sədaga ana Melefit ni. Ay ti maslaŋa èsliki məgəs naŋ ndo aɗaba sarta gayaŋ ènjiyu faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yezu àhi ana tay keti : « Nu ti nasləka. Lekʉlʉm akəɗəbum nu, ay ti akəmbrəŋum zlam magudarani gekʉli ni do, nahkay akəmətum zlam gekʉli. Aɗaba kìslʉmki mədəgumani ka məlaŋ ya nakoru ni koksah. » ");
INSERT INTO muy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Eslini ndam *Zʉde tə̀ɗəm e kiɗiŋ gatay bu ahkado : « Àɗəm “Kìslʉmki mədəgumani ka məlaŋ ya nakoru ni koksah” ni ti, awayay akaɗ ahàr gayaŋ gayaŋani zla tək ? » ");
INSERT INTO muy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Eslini Yezu nakəŋ àhi ana tay ahkado : « Lekʉlʉm ti mis ya ka haɗ, nu ti mis ya àsləkabiya agavəla ni. Lekʉlʉm ti ndam ga *duniya, nu ti nu mis ga duniya do. ");
INSERT INTO muy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nə̀hi ana kʉli akəmbrəŋum zlam magudarani gekʉli do, akəmətum ti azuhva nani. Nahkay ti ahàr àɗəm kəfumku ahàr, kəsərum nu gani, nu nə̀bu. Do ni ti akəmbrəŋum zlam magudarani gekʉli ni do, akəmətum eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nahkay nday nakəŋ tə̀hi : « Nak way ? » Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Kwa ka mənjəki ga zlapay goro ni nə̀hia ana kʉli a, nə̀ɗəm nu gani. ");
INSERT INTO muy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu nə̀bu àna zlam kay ga məɗəmkiani ke kʉli ga məgəs kʉli àna seriya. Ay ma goro ya nəhi ana ndam ga duniya ni ti, ma ga Bay ya àslərbiyu nu àhu ni ciliŋ. Naŋ ti naŋ jireni. » ");
INSERT INTO muy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yezu àra àhia ma na ana tay a nahkay ti ŋgay àɗəmki ma ka Bəŋani ti, nday tə̀sər ndo. ");
INSERT INTO muy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nahkay Yezu àhi ana tay ahkado : « Ka fat ya ti akəzumoya *Wur ge Mis agavəla ti, akəsərum nu ti nu gani, nu nə̀bu. Eslini akəsərum zlam ya ti nagray ni ɗek ti nu nuani nagray ga ahàr goro do. Ma ya ti nəɗəm ni ti ma ga Baba ya àcahu ni ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Bay ya ti àslərbiyu nu ni naŋ àbu akaba nu, àmbrəŋ nu ga ahàr goro ndo ; aɗaba nu nə̀bu nagray zlam ya ti àɓəlafəŋ ni kəlavaɗ. » ");
INSERT INTO muy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ka ya ti Yezu naŋ àbu aɗəm ma ni nahkay ti, mis dal-dal tə̀fəki ahàr. ");
INSERT INTO muy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Eslini Yezu àhi ana ndam *Zʉde ya tə̀fəkia ahàr a ni ahkado : « Tamal kə̀gəsumkabá ma goro ya nə̀hi ana kʉli na lala, kə̀mbrəŋum do ni ti, kìgʉma ndam maɗəbay nu eɗeɗiŋ eɗeɗiŋena. ");
INSERT INTO muy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Akəsərum jiri, nahkay ti ekigʉm lekʉlʉm eviɗi va do. » ");
INSERT INTO muy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Leli bəza huɗ ga Abraham. Ɗay-ɗay leli mìgi eviɗi ga maslaŋa ndo ni ti, kə̀ɗəm mara migi leli eviɗi va do ni ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yezu àhi ana tay ahkado : « Nəhi ana kʉli nahəma, maslaŋa ya ti agudar zlam ti naŋ eviɗi ga zlam magudarani. ");
INSERT INTO muy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nə̀ɗəm nahəma, eviɗi ti ɗay-ɗay tacalkivu naŋ ke mis ga huɗ ahay do. Ay wur ga bay ahay ti ku ananaw naŋ wur ga huɗ ahay zlam gayaŋ. ");
INSERT INTO muy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tamal Wur ge Melefit àmbaya kʉli e eviɗi ba ti, kìgʉm lekʉlʉm eviɗi va do eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nə̀səra lekʉlʉm ti bəza huɗ ga Abraham. Ay ti kawayum kəkaɗum nu, aɗaba kàwayum məgəsumkabu pakama goro do. ");
INSERT INTO muy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nu ti nəɗəm ere ye ti Baba àɗəfuki ni ; lekʉli ti ni kəgrum ere ye ti bəŋ gekʉli àhi ana kʉli ni. » ");
INSERT INTO muy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Bəŋ geli ti Abraham timey. » Eslini Yezu àhi ana tay ahkado : « Tamal lekʉlʉm bəza ga Abraham ti akal kəgrum tʉwi akaɗa ga Abraham ya àgray ni. ");
INSERT INTO muy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nu nə̀bu nəhi ma ge jiri ya Melefit àhu ni ana kʉli, ay nihi ti kawayum kəkaɗum nu sawaŋ. Abraham àgray nahkay ndo timey ! ");
INSERT INTO muy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Lekʉlʉm ti kəgrum tʉwi akaɗa ga bəŋ gekʉli ya agray ni. » Nday nakəŋ tə̀hi : « Leli ti leli bəza məva do. Melefit naŋ bəlaŋ naŋ Bəŋ geli. Bəŋ geli nahaŋ àbi. » ");
INSERT INTO muy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yezu àhi ana tay ahkado : « Tamal ti Melefit naŋ bəŋ gekʉli eɗeɗiŋ ti amal kawayum nu, aɗaba nàsləkabiya afa gana nàra afa gekʉli a. Nu nàra ti àna ahàr goro goroani do ; naŋ àslərbiyu nu. ");
INSERT INTO muy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Kìcʉm ma goro ya nəhi ana kʉli ni do ni ti kamam ? Kìcʉm do ni ti aɗaba kìslʉmki məbi slimi ana ma goro ya nəhi ana kʉli ni do. ");
INSERT INTO muy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Lekʉlʉm bəŋ gekʉli ti *Seteni. Kawayum kəgrum ti tʉwi ga bəŋ gekʉli gani ya awayay ni. Kwa ahaslani naŋ àbu abazl mis zlam gayaŋ, ɗay-ɗay àɗəm ma ge jiri ndo, aɗaba jiri gayaŋ àbi. Masəkaɗ malfaɗa ti tʉwi gayaŋ, aɗaba naŋ bay masəkaɗ malfaɗa, naŋ bəŋ gani daya. ");
INSERT INTO muy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ay nu ti nəɗəm ma ge jiri, nahkay ti kàwayum məgəsumkabu ma goro ya nəhi ana kʉli ni do. ");
INSERT INTO muy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Way esliki maɗafaya zlam a ti, aɗəm nu nagudar ni way ? Ay tamal ma goro ya nəɗəm ni ɗek jiri ti, kàwayum məgəsumkabani do ni ti kamam ? ");
INSERT INTO muy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mis ge Melefit ti abi slimi ana ma ge Melefit, ay lekʉlʉm ti lekʉli ndam ge Melefit do. Kàwayum məbumi slimi ana ma gayaŋ do ni ti azuhva nani. » ");
INSERT INTO muy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ndam *Zʉde ni tə̀hi ana Yezu ahkado : « Mə̀ɗəm nak zal Samari, seteni ànukviyu a ahàr vu ti, ma geli ni jiri eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yezu àhi ana tay : « Seteni ànuviyu bi. Zlam goro ya nagray ni ti ga mazləbay Baba goro sawaŋ. Lekʉlʉm ti ni kanjakum nu, kəbumku mimili. ");
INSERT INTO muy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nu ti ŋgay mis tâzləbay nu kwa ti nə̀ɗəm do. Ay Maslaŋa àbu bəlaŋ awayay ti tâzləbay nu, naŋ gani agray seriya ge jiri daya. ");
INSERT INTO muy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nəhi ana kʉli nahəma, maslaŋa ya ti àgəskabá ma goro na ti aməmət ɗay-ɗay do. » ");
INSERT INTO muy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nahkay ndam Zʉde nakəŋ tə̀hi ahkado : « Nihi ti mə̀səra seteni ànukviyu a ahàr bu eɗeɗiŋ zla ! Abraham àməta, ndam məhəŋgri *pakama ge Melefit ana mis day tə̀məta, ay nak kə̀ɗəm tamal maslaŋa àgəskabá ma gayak na ti àmət ɗay-ɗay do ni ti ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bəŋ geli Abraham tekeɗi àməta ti, nak kàtam naŋ aw ? Ndam məhəŋgri pakama ge Melefit ana mis ni day tə̀məta, ay nak ti kə̀ɗəm nak way ? » ");
INSERT INTO muy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Tamal nu nuani nazləbay ahàr goro ti, mazləbavani nani egi zlam masakani. Bay ya ti azləbay nu ni ti Baba naŋ ya ti kə̀ɗəmum naŋ Melefit gekʉli ni. ");
INSERT INTO muy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lekʉlʉm kə̀sərum naŋ do, ay nu ti nə̀səra naŋ a. Tamal nə̀ɗəm nə̀sər naŋ do ni ti, nasəkaɗ malfaɗa akaɗa gekʉli ni. Nu nə̀səra naŋ a, nə̀bu nəgəskabu ma gayaŋ daya. ");
INSERT INTO muy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Bəŋ gekʉli Abraham àmərva aɗaba àsəra emipi sarta ga marana goro a. Èpia, mək àmərva àna naŋ a àkiva. » ");
INSERT INTO muy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Eslini ndam Zʉde ni tə̀hi ahkado : « Nak kə̀zum vi kru kru zlam ndo ni ti, kə̀ɗəm kìpia Abraham a ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yezu àhi ana tay ahkado : « Nəhi ana kʉli nahəma, kwa ka ya ti tìwi Abraham faŋ ndo nəŋgu ni, nu gani, nu nə̀bu àndava. » ");
INSERT INTO muy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yezu àra àɗəma nahkay ti nday nakəŋ tə̀həl akur ge mizligi naŋ àna naŋ. Ay ti Yezu àɓu e kiɗiŋ ge mis bu mək àsləka a məlaŋ ga *ahay gəɗakani ge Melefit ni ba, àhəraya e mite va. ");
INSERT INTO muy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ka ya ti Yezu naŋ àbu akoru e divi bu akaba ndam maɗəbay naŋ ni ti èpi zal wuluf nahaŋ. Maslaŋa gani nani ti tìweya naŋ wulufana. ");
INSERT INTO muy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Eslini ndam maɗəbay naŋ ni tə̀hi ahkado : « Mʉsi, maslaŋa hini tìweya naŋ wulufana ti, way àgudar zlam way ? Àgudar zlam ti naŋ tək, day ti ata bəbəŋani tàgudar aw ? » ");
INSERT INTO muy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Tìweya naŋ wulufana ti azuhva àgudara zlam a ahkay do ni ata bəŋani tàgudara zlam a palam do. Tìwi naŋ nahkay ti, Melefit awayay ti mis tîpi njəɗa gayaŋ àna maslaŋa hini. ");
INSERT INTO muy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nihi məlaŋ maslani ti ahàr àɗəm məgrum tʉwi ga Bay ya àslərbiyu nu ni. Məlavaɗ egi wuɗak, nahkay ti maslaŋa emisliki magray tʉwi ni koksah. ");
INSERT INTO muy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ka ya ti nu nə̀bu a duniya bu mba ni ti nəslaɗi məlaŋ ana mis. » ");
INSERT INTO muy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Àra àɗəma nahkay ti ètiferu esliɓ a haɗ, àgraya eliɓisl àna esliɓ gayaŋ na mək àgriki ke eri ana zal wuluf ni. ");
INSERT INTO muy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Àhi ana zal wuluf ni ahkado : « Ru kâbaray eri a dəluv Silʉwe ni bu. » Silʉwe ti awayay aɗəmvaba « Məslərani. » Zal wuluf nakəŋ òru àbaray eri ni. Àra àbara eri na ti epi divi, mək àsləka, òru a magam. ");
INSERT INTO muy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndam mahay gayaŋ akaba ndam ya tə̀bu tipi naŋ ahaslani naŋ àbu ahəŋgalay zlam ni tə̀ɗəm ahkado : « Maslaŋa hini ti naŋ ya ti kəlavaɗ anjəhaɗ digʉsa, ahəŋgalay zlam ni do aw ? » ");
INSERT INTO muy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mis ndahaŋ tə̀ɗəm : « Naŋ. » Mis ndahaŋ ti ni tə̀ɗəm : « Naŋ do, tə̀zavu ciliŋ. » Mək naŋ nakəŋ àɗəm : « Nu gani timey ! » ");
INSERT INTO muy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eslini nday nakəŋ tə̀hi ahkado : « Kipi divi nahkay ti, mam àgrakukvu mam ? » ");
INSERT INTO muy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Naŋ nakəŋ àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Maslaŋa ya ti təzalay naŋ Yezu ni àgraya eliɓisl a, àgruki ke eri mək àhu ahkado : “Ru kâbaray eri a dəluv Silʉwe ni bu.” Nu nakəŋ mək nòru. Nòru nàbara ti nìpi divi hʉya. » ");
INSERT INTO muy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nday nakəŋ tə̀hi : « Maslaŋa gani nani naŋ eley ? » Àhi ana tay : « Nə̀sər do. » ");
INSERT INTO muy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tə̀zoru maslaŋa ya ti ahaslani naŋ wulufani ni afa ga ndam *Feriziyeŋ. ");
INSERT INTO muy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yezu àgraya eliɓisl a, àgriki ana zal wuluf ni mək àhəlikaba eri na ti ka fat məpəsabana. ");
INSERT INTO muy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tòru tìnjʉa àna naŋ a ti, ndam Feriziyeŋ ni day tìhindifiŋa, tə̀hi : « Nihi kipi divi ti, mam àgrakukvu mam ? » Naŋ nakəŋ àhi ana tay ahkado : « Maslaŋa gani nani àgruki eliɓisl ke eri, nàbaray eri mək nìpi divi hʉya. » ");
INSERT INTO muy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","E kiɗiŋ ga ndam Feriziyeŋ ni bu mis ndahaŋ tə̀ɗəm : « Ku way mâgray ere hini way nəŋgu ni, maslaŋa gani àsləkabiya afa Melefit a do, aɗaba àgra zlam ya ti àɓəlay magrani do na a vaɗ *məpəsabana ba. » Mis ndahaŋ ti ni tə̀ɗəm : « Tamal naŋ bay magudar zlam ti, esliki magray zlam ya ti agri ejep ana mis akaɗa hini ni aw ? » Nahkay tìcirva e kiɗiŋ gatay ba. ");
INSERT INTO muy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Eslini ndam Feriziyeŋ nakəŋ tìhindifiŋa ma kà zal wuluf ya àŋgaba na keti, tə̀hi ahkado : « Nak ti maslaŋa ya ti àhəlukaba eri a ni ti kə̀ɗəm naŋ way ? » Naŋ nakəŋ àhi ana tay ahkado : « Naŋ bay *mahəŋgaray pakama ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ay ti gəɗákani ga ndam *Zʉde ni ti ŋgay ahaslani naŋ wulufani day ti nihi epi divi ti tàwayay məgəskabani ndo. Nahkay tə̀zalabiyu ata bəŋani ");
INSERT INTO muy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ge mihindifiŋa ma kà tay a. Tàra tìnjia ti tə̀hi ana tay ahkado : « Wur gekʉli ya kə̀ɗəmum kìwʉmaya naŋ a wulufana ti naŋ hini eɗeɗiŋ aw ? Ay ti mam àgravu nihi ti epi divi ni mam ? » ");
INSERT INTO muy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nday nakəŋ tə̀həŋgrifəŋ ana tay, tə̀hi ana tay ahkado : « Mə̀səra hini ti wur geli, ka ya ti mìweya ti naŋ wulufani eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ay ere ye ti àgravu, epi divi hi ti, mə̀sər do. Maslaŋa ya ti àhəlikaba eri a ni day mə̀sər do. Naŋ wur va do, hindʉmfiŋa kà naŋ naŋana ; esliki məhəŋgrifəŋani ana kʉli. » ");
INSERT INTO muy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tə̀ɗəm nahkay ti aɗaba aŋgwaz àwərfəŋa tay kà gəɗákani ga ndam Zʉde na. Aɗaba ndam Zʉde ni ɗek tə̀zlapakabá, tə̀ɗəm maslaŋa ya aɗəm Yezu naŋ *Krist ti təcafəŋa naŋ kà mahəŋgalay Melefit akaba tay a ahay ga *mahəŋgalavù Melefit ni ba. ");
INSERT INTO muy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ata bəŋani tə̀ɗəm naŋ wur va do, tîhindifiŋa kà naŋ naŋana ti azuhva nani. ");
INSERT INTO muy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ndam Feriziyeŋ ni tə̀zalay maslaŋa ya ti ahaslani naŋ wulufani ni keti. Àra ènjia ti tə̀hi : « Ɗum ma ge jiri kè meleher ge Melefit. Leli ti mə̀səra maslaŋa ya ti kə̀ɗəm àhəlukaba eri a ni ti naŋ bay magudar zlam. » ");
INSERT INTO muy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Naŋ nakəŋ àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Ŋgay naŋ bay magudar zlam ahkay do ni àgudar zlam do ni ti nə̀sər do. Ere ye ti nə̀sər ni ti zlam bəlaŋ : ahaslani ti nu wulufani, ay nihi ti nipi divi. » ");
INSERT INTO muy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nday nakəŋ tìhindifiŋa, tə̀hi : « Àgruk ti mam ? Àhəlukaba eri a ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Naŋ nakəŋ àhi ana tay ahkado : « Nə̀hia ana kʉli a àndava, kìcʉmuki ndo timey. Ay kawayum nəhi ana kʉli kîcʉm keti ti kamam ? Tək lekʉlʉm day kawayum migi ndam maɗəbay naŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Àra àɗəma nahkay ti, nday nakəŋ tìndivi naŋ, tə̀ɗəm : « Aɗəbay maslaŋa nani ti nak kwa. Leli ti leli ndam maɗəbay Mʉwiz. ");
INSERT INTO muy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Leli ndam maɗəbay Mʉwiz aɗaba mə̀səra Mʉwiz ti Melefit àhia ma gayaŋ ana naŋ a. Ay maslaŋa nani ti mə̀sər məlaŋ gayaŋ ya àsləkabiya na do simiteni. » ");
INSERT INTO muy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Naŋ nakəŋ àhi ana tay nahkay hi : « Lekʉlʉm kə̀sərum məlaŋ gayaŋ ya àsləkabiya na do ni ti ahəmamam ? Ay àhəlukaba eri a timey ! ");
INSERT INTO muy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Mə̀səra tamal bay magudar zlam ahəŋgalaləŋ zlam kè Melefit ti Melefit èciiki do. Ay ku way way do tamal ahəŋgalay Melefit àna mahəŋgaroru ahàr a haɗ akaba agray ere ye ti àhi mâgray ni ti, Melefit eciiki. ");
INSERT INTO muy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ɗay-ɗay maslaŋa èci ti maslaŋa nahaŋ àhəlikaba eri ana mis tìweya naŋ a wulufana ndo. ");
INSERT INTO muy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamal ti maslaŋa nani àsləkabiya afa ge Melefit a do ni ti, amal èsliki magray araŋa koksah. » ");
INSERT INTO muy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Kwa tìweya kur a nak bay magudar zlam ti kacahi zlam ana leli aw ! » Nahkay tàgaraya naŋ e mite va. ");
INSERT INTO muy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yezu àra ècia ndam Feriziyeŋ ni tàgaraya zal ya ahaslani wulufani na e mite va ti àɗəbay naŋ. Àra àdia ahar a ti àhi ahkado : « Kəfəki ahàr ka *Wur ge Mis aw ? » ");
INSERT INTO muy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Àhəŋgrifəŋ, àhi : « Naŋ way, Bay goro ni, ti nə̂fəki ahàr ni ? » ");
INSERT INTO muy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yezu àhi : « Bay ya ti kə̀bu kamənjaləŋ, naŋ àbu ahuk ma ni ti naŋ gani. » ");
INSERT INTO muy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Naŋ nakəŋ àhi : « Nə̀fukuka ahàr a, Bay goro ni. » Mək àbəhaɗi mirdim grik. ");
INSERT INTO muy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Eslini Yezu àɗəm : « Nàra a duniya va ti ga magrafəŋa seriya kè mis a ; ti ndam wuluf tîpi divi, nday ya tə̀ɗəm tìpia divi a ni tə̂wuluf. » ");
INSERT INTO muy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndam *Feriziyeŋ ya tə̀bu akaba naŋ eslini ni tàra tìcia ma gayaŋ na ti tə̀hi : « Leli day leli ndam wuluf aw ? » ");
INSERT INTO muy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Eslini Yezu àhi ana tay ahkado : « Tamal ti kə̀njum lekʉli ndam wuluf ti, amal zlam magudarani gekʉli àbi. Ay nihi ti kə̀ɗəmum kə̀bum kipʉm divi ti zlam magudarani gekʉli àbu. » ");
INSERT INTO muy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yezu àɗəm keti : « Nəhi ana kʉli nahəma, maslaŋa ya ti ahuriyu a gargara ga təmbəmbak vu gwar a mahay do, ahuriyu àna məlaŋ nahaŋ ti, naŋ zal akal, naŋ zal abra. ");
INSERT INTO muy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ay maslaŋa ya ti ahuriyu gwar a mahay ga gargara ni ti naŋ bay majəgay təmbəmbak. ");
INSERT INTO muy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Bay majəgay gargara ni azləkiaba mahay ana bay majəgay təmbəmbak na. Àzləkiaba ti bay majəgay təmbəmbak ni azalay təmbəmbak gayaŋ ɗek bəlaŋ bəlaŋ àna slimi gatay. Təmbəmbak ni tìcia dəŋgu gayaŋ a ti tə̀səra, abaya tay e mite va. ");
INSERT INTO muy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ka ya ti àbaya tay a nahəma, adi kama ana tay, mək təmbəmbak ni taɗəboru naŋ kələŋ, aɗaba tə̀səra dəŋgu gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ay ti ataɗəboru maslaŋa ya ti tə̀sər naŋ do ni do ; atacuhwafəŋa, aɗaba tə̀sər dəŋgu ge mis ndahaŋ do. » ");
INSERT INTO muy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yezu àhi ma *gozogul hini ana tay, ay ti tìciaba ere ye ti awayay ahiki ana tay na ndo. ");
INSERT INTO muy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yezu àhi ana tay keti : « Nəhi ana kʉli nahəma, mahay ga gargara ga təmbəmbak ni ti nu. ");
INSERT INTO muy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mis ndahaŋ ya tàra, tə̀ɗəm tajəgay təmbəmbak ni ti, nday ɗek ndam akal, ndam abra ; ay təmbəmbak ni tìciiki ma ana tay ndo. ");
INSERT INTO muy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Mahay ti nu, maslaŋa ya ti ahuriyu gwar a nu bu ni ti araŋa amacay naŋ do, Melefit amahəŋgay naŋ. Nahkay emisliki məhuriyu a gargara vu, mahərana e mite va akaba aməŋgət zlam məzum gayaŋ. ");
INSERT INTO muy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Zal akal ara ti ga məhəl zlam àna akal, ga mabazl zlam akaba ge mijiŋ zlam. Ay nu nàra ti, nawayay ti mis tə̂ŋgət sifa ya ti àndav ɗay-ɗay do ni. Sifa gani nani ti nəvi ana tay àtam ya ti tiwi mis àna naŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","« Bay ya ti ajəgay zlam lala ni ti nu. Bay ya ti ajəgay zlam lala ni ti, ku takaɗki naŋ ka təmbəmbak gayaŋ ya ti ajəgay tay ni nəŋgu ni agəskabu, àmbrəŋ tay do. ");
INSERT INTO muy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ay ti maslaŋa ya ajəgi zlam ana mis ti tə̂pəl naŋ ni ti àjəgay zlam lala do, aɗaba tamal èpia kəra gili naŋ àbu ara ti acuhway, ambərbu təmbəmbak ni. Aməmbərba tay a ti, kəra gili ni amabazl ndahaŋ, emidikaba ahàr a ana məgəjəni gana. ");
INSERT INTO muy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Maslaŋa ya ti acuhway, ambərbu təmbəmbak ni ti təmbəmbak ni tə̀həli ahàr do, aɗaba naŋ agray ni tʉwi ga siŋgu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Bay ya ti ajəgay zlam lala ni ti nu. Nu nə̀səra təmbəmbak goro a, təmbəmbak goro day tə̀səra nu a ");
INSERT INTO muy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","akaɗa ga Baba ya àsəra nu a, nu day nə̀səra Baba ni. Nahkay ti nəgəskabu ti tâkaɗki nu ka təmbəmbak goro ya najəgay ni. ");
INSERT INTO muy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Təmbəmbak goro ndahaŋ tə̀bu, ay ti tə̀kibu ka ndahaŋ ya a gargara hini bu ni bi. Nday gani nani ti ahàr àɗəm nəhəlbiyu tay daya. Etici dəŋgu goro, etigi ka ahar bəlaŋ akaba ndahaŋ ni, bay majəgay tay day bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baba awayay nu aɗaba nəgəskabu ti nə̂mət ka mawayay goro, do ni ti maslaŋa èsliki makaɗ nu do. Nə̀məta nəŋgu ni, nisliki maŋgabana tata. ");
INSERT INTO muy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Maslaŋa ya ti esliki makaɗ nu ni ti àbi, nəgəskabu nəmət ti ka mawayay goro. Nisliki məmətani ka mawayay goro ; nisliki maŋgabana daya. Bəŋ goro àhu gray ti nahkay. » ");
INSERT INTO muy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ndam *Zʉde ni tàra tìcia ma ga Yezu ya àɗəm na ti tìcirvu e kiɗiŋ gatay bu keti. ");
INSERT INTO muy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mis ndahaŋ kay e kiɗiŋ gatay bu tə̀bu təɗəm : « Seteni àniviyu a ahàr vu, naŋ zal seteni ti kəbumi slimi ana ma gayaŋ ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mis ndahaŋ ni ti ni tə̀ɗəm : « Zal seteni àɗəm ma gayaŋ hini ya aɗəm ni do. Zal seteni ti esliki məzləkikaba eri ana ndam wuluf a waw ? » ");
INSERT INTO muy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sarta ga wuməri ga məzləkaba *Ahay gəɗakani ge Melefit na ènjʉa, tàgray a Zerʉzalem, sarta gani nani ti ahar kusi. ");
INSERT INTO muy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nahkay Yezu asawaɗay a dalaka ga *ahay gəɗakani ge Melefit ni bu, ka məlaŋ ya təzalay Dalahay ga Salomoŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndam *Zʉde ni tə̀cakalakivu ka Yezu, tèveliŋi ahàr, tə̀hi ahkado : « Tamal nak *Krist eɗeɗiŋ ti, hi ana leli vay-vay kìmbirfəŋ ba, nahkay ti ahàr aməhəli ana leli va do. » ");
INSERT INTO muy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Eslini Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Nə̀hia ana kʉli a àndava, ay ti kàwayum məgəsumkabu ma gani ndo timey. Tʉwi ya nagray ni ti nagray àna njəɗa ga Baba, nahkay tʉwi gani nani aɗəfiki ana kʉli nu ti nu way. ");
INSERT INTO muy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ay ti kekileŋa lekʉlʉm kàwayum məfumku ahàr do, aɗaba lekʉlʉm kə̀kumkibu ka təmbəmbak goro bi. ");
INSERT INTO muy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Təmbəmbak goro ti tici dəŋgu goro, nu day nə̀səra tay a, nday day taɗəbay nu. ");
INSERT INTO muy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nəvi *sifa ya àndav ɗay-ɗay do ni ana tay, atəmət do, maslaŋa day emisliki məhəlfua tay a do. ");
INSERT INTO muy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baba Melefit naŋ ya àbu təmbəmbak ni ti naŋ gəɗakani àtam mis ɗek, àtam zlam ɗek. Maslaŋa àbi esliki məhəlfəŋa tay kà Baba bi. ");
INSERT INTO muy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Leli ata Baba ti leli bəlaŋani. » ");
INSERT INTO muy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yezu àra àɗəma nahkay ti ndam Zʉde ni tə̀həl akur keti, tawayay mizligi naŋ àna naŋ. ");
INSERT INTO muy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yezu àhi ana tay ahkado : « Nàgra tʉwi sulumana sulumana kay e kiɗiŋ gekʉli ba àna njəɗa ga Baba. Ay kawayum kizligʉm nu àna akur, kakaɗum nu ti àki ke tʉwi weley gani weley ? » ");
INSERT INTO muy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eslini ndam Zʉde ni tə̀həŋgrifəŋ, tə̀hi ahkado : « Mawayay mizligi kur àna akur, mawayay makaɗ kur ti, àki ke tʉwi sulumani do. Mizligi kur ti aɗaba kìndivia Melefit a palam ; nak mis, ay ti kawayay kazay ahàr gayak akaɗa nak Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Àbu məbəkiani a Wakita ge Melefit ni bu, Melefit àɗəm nahkay hi : “Lekʉlʉm ti melefifit.” Àbi məbəkiani nahkay hi bi aw ? ");
INSERT INTO muy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Maslaŋa àbi esliki məbəzkia zlam ya àbu məbəkiani a Wakita ge Melefit bu na bi. Nahkay nday ya ti Melefit àhi ma gayaŋ ana tay ni ti àzalay tay melefifit eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ay nu ti Baba àdaba nu a, àslərbiyu nu a duniya vu. Goro ya nə̀ɗəm “Nu Wur ge Melefit” ni ti, ahəmamam kislʉmki məɗəmani nindivi naŋ ni mam ? ");
INSERT INTO muy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tamal nagray tʉwi ni ga Baba do ni ti kə̀fumku ahàr ba. ");
INSERT INTO muy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ku nagray tʉwi ga Baba, kə̀fumku ahàr do nəŋgu ni, gəsumkabá tʉwi goro ya nagray na digepa. Nahkay ti akəsərum lala, nu nə̀bu àna njəɗa ga Baba, naŋ day naŋ àbu àna njəɗa goro, nahkay leli ata Baba ti bəlaŋani. » ");
INSERT INTO muy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yezu àra àɗəma ma na nahkay ti, tawayay məgəs naŋ keti, ay ti àtamfəŋa kà tay a. ");
INSERT INTO muy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kələŋ gani Yezu àsləka, àŋgoru ke ledi ge Zʉrdeŋ, ka məlaŋ ge Zeŋ ya *àbaray mis ahaslani ni. Naŋ nakəŋ ànjəhaɗ eslini gosku ɓal. ");
INSERT INTO muy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ka ya ti naŋ àbu eslini ni ti mis kay tə̀rəkia, tə̀bu təɗəm : « Zeŋ ti àgray zlam magray ejep ndo ; ay ma gayaŋ ya àɗəmki ka maslaŋa hini ni ɗek ti jiri eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Eslini mis kay tə̀fəkia ahàr ka Yezu a. ");
INSERT INTO muy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Zal nahaŋ àbu, slimi gani Lazar, arməwər àzəgaɗiya naŋ a. Kəsa gayaŋ Betani, nday akaba bəza ga məŋani walani ata Mari nday ata Marta. ");
INSERT INTO muy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari ti nani, Mari ya ti àbəki tersel ka asak ga Bay geli mək àtəmaɗkia àna məhər gayaŋ a ni. Lazar naŋ ya ti èɓesey do ni ti wur ga məŋani. ");
INSERT INTO muy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nahkay bəza ga məŋ ga Lazar nakəŋ tə̀slərkioru mis ka Yezu ti mə̂hi : « Bay geli, zləba gayak Lazar èɓesey do. » ");
INSERT INTO muy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yezu àra ècia ma na nahkay ti àɗəm : « Arməwər ga Lazar ni ti àkaɗ naŋ do. Ay ti mis atəsər njəɗa ge Melefit àna naŋ sawaŋ. Nahkay atazləbay Melefit, atazləbay nu Wur ge Melefit daya. » ");
INSERT INTO muy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Lazar akaba bəza ga məŋani ata Mari nday ata Marta ti Yezu awayay tay ; ");
INSERT INTO muy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ay àra ècia ga Lazar ya èɓesey do na ti òru weceweci ndo, àpəskivu ka ahàr gani vaɗ cʉ. ");
INSERT INTO muy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kələŋ gani àhi ana ndam maɗəbay naŋ ni ahkado : « Nihi ti sarta ènjʉa ga maŋgona e Zʉde a. » ");
INSERT INTO muy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ndam maɗəbay naŋ ni tə̀hi ahkado : « Mʉsi, nihi guhwa hʉya ndam *Zʉde ni tawayay tizligi kur àna akur, tawayay takaɗ kur ti, kəŋgoru eslini keti aw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yezu àhi ana tay : « Məlafat ti njemdi kru mahar cʉ do aw ? Tamal mis asawaɗay ga məlafat ti èji asak do, aɗaba naŋ a məlaŋ maslaɗani bu, epi divi lala. ");
INSERT INTO muy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ay tamal mis asawaɗay ga məlavaɗ ti eji asak, aɗaba naŋ àbi a məlaŋ maslaɗani bu bi, èpi divi lala do. » ");
INSERT INTO muy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yezu àra àhia ma ana tay a nahkay ti àhi ana tay : « Zləba geli Lazar àdiya e ɗʉwir va, ay nakoru nepiɗekababiya naŋ a. » ");
INSERT INTO muy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eslini ndam maɗəbay naŋ ni tə̀hi ahkado : « Bay geli, tamal àdiya e ɗʉwir va ti, amaŋgaba a arməwər gayaŋ ni ba do waw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ga Yezu ya àhi ana tay nahkay ti awayay ahi ana tay Lazar àməta. Ay ndam *maɗəbay Yezu ni tə̀hi ana ahàr hi ti Yezu àɗəmki ma ti ke ɗʉwir ɗʉwireni eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nahkay Yezu àhi ana tay vay-vay : « Lazar àməta. ");
INSERT INTO muy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nu nə̀bi ka məlaŋ gani bi ti nə̀bu nəmərvu azuhva kʉli, aɗaba akəfumku ahàr àkivu. Ay nihi ti takomum mədəgumkioru. » ");
INSERT INTO muy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eslini Tumas naŋ ya təzalay naŋ Didim ni àhi ana ndam maɗəbay Yezu ndahaŋ ni ahkado : « Leli day takomum maɗəboru naŋ, ti tôru tâbazla leli akaba naŋ a. » ");
INSERT INTO muy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yezu akaba ndam maɗəbay naŋ ni tìnjʉa a Betani a wuɗak ti, tə̀hi ana tay Lazar àgra vaɗ a faɗ e mindiviŋ ba. ");
INSERT INTO muy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ti driŋ driŋ akaba Zerʉzalem kay do, èsli ezeweɗ kru kru mahkər do. ");
INSERT INTO muy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nahkay ndam Zʉde kay tòra eslina ga məgrikabiyu ezekw ana Marta nday ata Mari ga wur ga məŋ gatay ya àməta na. ");
INSERT INTO muy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta àra ècia Yezu naŋ àbu ènjia wuɗak ti àŋgwivoru a ma vu. Mari ti ni naŋ a magam manjəhaɗani digʉsa. ");
INSERT INTO muy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ata Marta tàra tàbakabá ahàr ata Yezu a ti Marta nakəŋ àhi ahkado : « Tamal nak kə̀ləbu ahalay ti, akal wur ga mma ni àmət ndo. ");
INSERT INTO muy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ay nə̀səra ku nihi day ere ye ti kihindifiŋa kè Melefit a ɗek day Melefit aməvuk. » ");
INSERT INTO muy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yezu àhəŋgrifəŋ, àhi ahkado : « Wur ga muk ni amaŋgaba e kisim ba. » ");
INSERT INTO muy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta àhi : « Iy, nə̀səra ka fat ga mandav ga duniya mis ataŋgaba e kisim ba ni ti, naŋ day amaŋgaba. » ");
INSERT INTO muy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yezu àhi keti : « Mis taŋgaba e kisim ba, tə̀bu àna sifa ti azuhva nu, aɗaba nu nə̀bu palam. Maslaŋa ya ti àfəkua ahàr a ti ku tamal àməta nəŋgu ni amələbu àna sifa. ");
INSERT INTO muy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maslaŋa ya ti naŋ àbu àna sifa, àfəkua ahàr a ti, amanjəhaɗ ga kaŋgay-kaŋgayani, àmət do. Kə̀hi ana ahàr ma goro hini ya nə̀huk ni ma ge jiri do waw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eslini Marta nakəŋ àhi ahkado : « Ma ge jiri, Bay goro ni ; nə̀səra nak *Krist *Bay gəɗakani ya Melefit àslərbiyu a duniya vu ni, nak Wur ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta àra àhia ma na nahkay ti àsləka, àŋgoru a magam, mək àzalay wur ga məŋani Mari, àhi ma akal-akal, àhi ahkado : « Mʉsi geli àra, naŋ àbu ehindi kur. » ");
INSERT INTO muy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mari àra ècia ma ga wur ga məŋani ya àhi na ti ècikaba cəkwaɗ, àrəkioru ka Yezu. ");
INSERT INTO muy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ka sarta nani ti Yezu àhuriyu a kəsa ni vu faŋ ndo, kekileŋa naŋ àbu ka məlaŋ ya tàbakabu ahàr nday ata Marta ni mba. ");
INSERT INTO muy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndam Zʉde ya tə̂vu a ahay bu, tòru eslini ga məgri ezekw ana tay ni tàra tìpia Mari nakəŋ ècikaba cəkwaɗ àhəraya e mite va ti tàɗəbabiyu naŋ. Tàɗəboru naŋ ti, tə̀hi ana ahàr bi akoru kè mindiviŋ, akoru etʉwibiyu eslini. ");
INSERT INTO muy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari òru ènjʉa ka məlaŋ ga Yezu na, èpia naŋ a ti àbəhaɗi mirdim, àhi ahkado : « Bay goro ni, tamal nak kə̀ləbu ahalay ti, akal wur ga mma ni àmət ndo. » ");
INSERT INTO muy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yezu àra èpia Mari a naŋ àbu etʉwi, ndam Zʉde ya taɗəbabiyu Mari ni day tə̀bu titʉwi ti, àhəlia ahàr a dal-dal, ɓəruv àwəra naŋ a. ");
INSERT INTO muy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mək àhi ana tay ahkado : « Kə̀fumiyu naŋ e mindiviŋ vu eley ? » Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi : « Bay geli, ra kara kipibiya məlaŋ gana. » ");
INSERT INTO muy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Eslini Yezu ètʉwi. ");
INSERT INTO muy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndam Zʉde ni tàra tìpia naŋ a naŋ àbu etʉwi ti tə̀ɗəm : « Mənjumki day ti, àwaya naŋ a dal-dal ni. » ");
INSERT INTO muy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ay mis ndahaŋ e kiɗiŋ gatay bu tə̀ɗəm ahkado : « Àhəlikaba eri ana zal wuluf a ti, ti Lazar àmət ba ti èsliki magrani koksah aw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Eslini ɓəruv àwəra Yezu a keti, mək òru ke mindiviŋ ni. Mindiviŋ nani ti ahuzl, tə̀zləkləŋ ma gani àna belim gəɗakani. ");
INSERT INTO muy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tòru tìnjʉa ti Yezu nakəŋ àhi ana tay ahkado : « Zumləŋa belim na kà ma ge mindiviŋ na. » Eslini Marta wur ga məŋ ga maslaŋa ya ti àmət ni àhi ahkado : « Bay goro, àgra vaɗ a faɗ nihi e mindiviŋ ni ba ni ti èzia àndava timey. » ");
INSERT INTO muy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yezu àhi ahkado : « Nə̀huka àndava : tamal kə̀fəkua ahàr a nahəma ekipi zlam, akəsər Melefit ti naŋ njəɗa-njəɗani, akazləbay naŋ ti, kìci ndo waw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nahkay mis ni tə̀zələŋa belim na kà ma ge mindiviŋ na. Eslini Yezu nakəŋ àmənjoru agavəla, àɗəm : « Sʉsi gayak Bəba goro ni, aɗaba kə̀grua ere ye ti nìhindilʉk na. ");
INSERT INTO muy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nu ti nə̀səra nak kə̀bu kəgru ere ye ti nihindilʉk ni ɗek kəlavaɗ. Ay nə̀ɗəm ma hini ti, nawayay ti mis ya tə̀bu ahalay teveliŋ nu ni tîci, ti tə̂sər nak kə̀slərbiyu nu eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yezu àra àɗəma ma na nahkay ti àzlah kay kay, àɗəm : « Lazar, həraya e mindiviŋ ni ba. » ");
INSERT INTO muy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nahkay maslaŋa ya ti àmət ni àhəraya, asak mitʉwiɗeni, ahar day mitʉwiɗeni àna gabaga, ahàr gayaŋ makambahani àna azana. Eslini Yezu nakəŋ àhi ana mis ni ahkado : « Picehʉmaba naŋ a, ti mâsawaɗay. » ");
INSERT INTO muy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndam *Zʉde ya tàra afa ga Mari a, tìpi ere ye ti Yezu àgray ni ti, mis ndahaŋ kay e kiɗiŋ gatay bu tə̀fəkia ahàr ka Yezu a. ");
INSERT INTO muy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ay mis ndahaŋ e kiɗiŋ gatay bu tə̀rəkioru ka ndam *Feriziyeŋ, tàŋgəhaɗi ere ye ti Yezu àgray ni ana tay. ");
INSERT INTO muy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam Feriziyeŋ ni tàra tìcia ma na ti, tə̀zalakabu gəɗákani ga ndam Zʉde ni ɗek, tə̀ɗəm : « Nihi maslaŋa hini agray zlam magray ejep dal-dal ti, məgrum ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tamal mə̀mbrəŋa naŋ a, naŋ àbu agroru zlam gayaŋ ni nahkay ti, mis ɗek atəfəki ahàr. Nahkay ndam *Rom atəmbrəŋ leli do : etembeɗkaba *ahay gəɗakani *njəlatani geli na, etijiŋ jiba geli ɗek. » ");
INSERT INTO muy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Zal nahaŋ àbu, naŋ gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ke vi nani, slimi gayaŋ Kayif. Naŋ nakəŋ àhi ana tay ahkado : « Lekʉlʉm ti kə̀sərum araŋa do simiteni. ");
INSERT INTO muy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ahàr àɗəm mis bəlaŋ amət azuhva ndam jiba geli ɗek, ti ndam jiba geli ni tə̀mət ba. Amət nahkay ti aŋgivu ana kʉli ti kə̀sərum do waw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Àɗəm nahkay ti pakama gayaŋ gayaŋani do ; àhəŋgaraya pakama ge Melefit a, aɗaba Kayif ti gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ke vi nani palam. Pakama ge Melefit ya àhəŋgaraya ni ti nihi : ahàr àɗəm Yezu amət azuhva ndam jiba gayaŋ kwa. ");
INSERT INTO muy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yezu amət ti azuhva ndam jiba gayaŋ ciliŋ do, amət ti ga maŋgasikabu ahàr ana bəza ge Melefit ya medeveni ka haɗ gərgərani ni ɗek. ");
INSERT INTO muy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kwa ka fat nani nday nakəŋ tawayay makaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yezu àra ècia ma gana ti, àmbrəŋ masawaɗani e kiɗiŋ ga ndam Zʉde bu hʉya, àsləka òru a kəsa nahaŋ vu. Kəsa nani ti təzalay Efreyim, kà gəvay ge gili. Àra enjʉa ti ànjəhaɗ eslini akaba ndam maɗəbay naŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ka sarta gani nani ti *Pak, wuməri gəɗakani ga ndam Zʉde ni, ènjia wuɗak. Nahkay ndam Zʉde kay ya a kəsa ndahaŋ bu ni tàsləka, tòru a Zerʉzalem ga məbarani ti tîgi njəlatani day kwa ti tâgray wuməri ni. ");
INSERT INTO muy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mis ni tòru tìnjʉa a Zerʉzalem a ti teheliŋ eri ga Yezu, ay ti tə̀di ahàr ndo. Ka ya ti nday tə̀bu a dalaka ga *ahay gəɗakani ge Melefit ni bu nahəma, tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm : « Kə̀humi ana ahàr mam ? Kə̀humi ana ahàr ti amara ga magray wuməri na waw ? » ");
INSERT INTO muy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni akaba ndam Feriziyeŋ ni tawayay təgəs naŋ, nahkay tə̀hi ana mis ahkado : « Ku way way do tamal àsəra məlaŋ ga Yezu ya naŋ àbu na ti mə̂hi ana leli. » ");
INSERT INTO muy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaɗ àvu muku tara tagray wuməri ga *Pak ni ti Yezu òru a Betani a kəsa ga Lazar bu. Lazar ti naŋ ya ti àmət, mək Yezu àhəŋgaraba naŋ e kisim ba ni. ");
INSERT INTO muy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eslini tə̀zalaki Yezu nakəŋ ka zlam məzumani. Òru ènjʉa ti Marta ahəlibiyu zlam məzumani ana tay, Lazar ti ni naŋ àbu azum zlam akaba mis ya tə̀zalay tay ni. ");
INSERT INTO muy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ka ya ti tə̀bu təzum zlam ni ti Mari òru àna tersel ya təzalay nardu ni, njəlatani ge siŋgu kayani, telma ge litir. Àra ènjia àna naŋ a ti àbəki tersel ni ka asak ga Yezu cʉeni mək àtəmaɗkia àna məhər ga ahàr gayaŋ a. Nahkay ahay ni ɗek ezi tersel tersel a. ");
INSERT INTO muy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Eslini Zʉdas Iskariyot bəlaŋ ga ndam *maɗəbay Yezu, naŋ ya aməsəkumoru Yezu ni, àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","« Siŋgu ge tersel ni jik diŋ diŋ mahkər ti tə̀səkumoru, tìdi siŋgu gani ana ndam talaga ndo ni ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Zʉdas àɗəm nahkay ti aɗaba awayay ndam talaga palam do, àɗəm nahkay ti aɗaba naŋ zal akal. Naŋ bay maŋgah siŋgu, ay ti naŋ àbu adafəŋa siŋgu na akal-akal a. ");
INSERT INTO muy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ay Yezu àra ècia ma ga Zʉdas na ti àhi : « Mbrəŋ wal hini, kə̀həli muru ba. Àgray nahkay ti aɗaba naŋ àbu ajalakioru ahàr ka vaɗ ya ti anəməta, atəfiyu nu e eviɗ vu ni. ");
INSERT INTO muy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ndam talaga zla nahəma, nday tə̀bu akaba kʉli kəlavaɗ. Ay nu zla ti ananjəhaɗ akaba kʉli kəlavaɗ do. » ");
INSERT INTO muy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ndam *Zʉde kay tàra tìcia Yezu naŋ a Betani ti tòru eslini. Tòru ti azuhva Yezu ciliŋ do ; tòru ti ga moru mipi Lazar naŋ ya ti Yezu àhəŋgaraba naŋ e kisim ba ni daya. ");
INSERT INTO muy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nahkay gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀zlapakabá, tə̀ɗəm : « Si mijiŋ Lazar daya kwa. » ");
INSERT INTO muy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tə̀ɗəm nahkay ti aɗaba ndam Zʉde kay tə̀mbrəŋa tay a, tə̀gəskabu ma gatay ni va do, tə̀bu təfəki ahàr ka Yezu azuhva gayaŋ ya àhəŋgaraba Lazar a ni. ");
INSERT INTO muy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Hajəŋ gani mis kayani ya tòru a Zerʉzalem ga magray wuməri ga *Pak ni tìcia Yezu ènjia a Zerʉzalem a wuɗak. ");
INSERT INTO muy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nahkay nday nakəŋ tàkwahakabaya ahar ga təɓa a ahar va, mək tàhəraya a kəsa ni ba tə̀ŋgwivoru a ma vu. Nday tə̀bu takoru ti tàgray salalay, tàzləbay Yezu, tə̀ɗəm : « *Hozana ! Bay Melefit mə̂gri sulum gayaŋ ana maslaŋa ya ti ara àna slimi gayaŋ a, naŋ bay ga ndam *Izireyel ni ! » ");
INSERT INTO muy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Eslini Yezu àdi ahàr ana azoŋgu, mək àcəlkiyu katapla. Ere gani àgravu ti akaɗa ya ti àbu məbəkiani a Wakita ge Melefit bu nahkay hi ni : ");
INSERT INTO muy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","« Ndam *Siyoŋ, kə̀grum aŋgwaz ba. Mənjumoru, bay gekʉli naŋ tegi ara, àcəlkivabiya ka wur ga azoŋgu a. » ");
INSERT INTO muy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ka sarta gani nani ti ndam *maɗəbay Yezu ni tə̀sərkaba ere ya àgravu na ndo. Ka sarta ya ti Melefit àzoya Yezu a məlaŋ maslaɗani gayaŋ va day kwa ti ma ya ti Melefit àɗəmki a Wakita gayaŋ bu ni àŋgiaya a ahàr ba ana tay a. Nahkay tə̀sər zlam gani nani àgrakiva ka Yezu a akaɗa ya àbu məbəkiani na. ");
INSERT INTO muy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ka fat ya ti Yezu àzalay Lazar, àhi « Həraya e mindiviŋ ba, » àhəŋgaraba naŋ e kisim ba ni ti, mis ya tôru eslini ni ɗek tìpia ; nday nakəŋ tàŋgəhaɗi ma gani ana mis ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mis kay tə̀ŋgwivoru a ma vu ana Yezu ti azuhva tìcia gayaŋ ya àgray zlam magray ejep nani na. ");
INSERT INTO muy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Eslini ndam *Feriziyeŋ ni tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm : « Kìslʉmki ka araŋa do ni ti kipʉm do waw ? Nihi mis ni ɗek tə̀bu taɗəbay naŋ ci ni. » ");
INSERT INTO muy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","E kiɗiŋ ge mis ya tòru ga mazləbay Melefit ka sarta ga wuməri ni bu ni ti ndam *Gres ndahaŋ day tə̀kibu ka tay. ");
INSERT INTO muy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nday nakəŋ tə̀rəkioru ke Filip naŋ ga kəsa Beceyda ka haɗ *Gelili ni. Tə̀hi : « Bay geli, leli mawayay məbakabu ahàr akaba Yezu. » ");
INSERT INTO muy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip àra ècia ma gatay na ti àrəkioru ka Andre, mək nday cʉeni tə̀rəkioru ka Yezu, tə̀hi ma gani. ");
INSERT INTO muy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yezu àra ècia ma gana ti àhi ana tay ahkado : « Nihi sarta ya Melefit azoru nu *Wur ge Mis a məlaŋ maslaɗani gayaŋ bu ni ènjia. ");
INSERT INTO muy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nəhi ana kʉli nahəma, hilfi ga hay tamal àdiyu a haɗ vu ndo, èzi ndo ni ti, naŋ àbu nahkay zlam gayaŋ. Ay tamal èzia day kwa ti eri gani afətaya, aɗək, abay ahàr, ewi bəza kay. ");
INSERT INTO muy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Maslaŋa ya ti awayay ajəgur sifa gayaŋ ti àmət ba ni ti emijiŋ ; ay maslaŋa ya ti awayay sifa gayaŋ a duniya hini bu do ni ti aməjəgur, amələbu àna *sifa ya àndav ɗay-ɗay do ni sawaŋ. ");
INSERT INTO muy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tamal mis awayay məgru tʉwi nahəma, mâɗəbay nu. Ka məlaŋ ya nu nə̀vu ni ti bay məgru tʉwi ni day amələbu eslini. Tamal mis ègia bay məgru tʉwi a ti, Baba amazləbay naŋ. » ");
INSERT INTO muy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yezu àɗəm keti : « Nihi ti məɓəruv àbu atukaba. Nəɗəm hi ti mam ? Nə̂ɗəm : “Bəba, nə̀cakay daliya a sarta hini bu ba” zla tək ? Nə̀ɗəm nahkay do, aɗaba nàra ti ga macakay daliya a sarta hini bu. ");
INSERT INTO muy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bəba, gray zlam ti mis tâzləbay kur. » Eslini dəŋgu àhəndabiyu a huɗ melefit bu nahkay hi : « Nàgra zlam ya ti mis tâzləbaki nu na àndava, anagray zlam nahaŋ keti ti mis tâzləbaki nu. » ");
INSERT INTO muy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mis ye eslini ni tàra tìcia dəŋgu ya àhəndabiya na ti mis ndahaŋ e kiɗiŋ gatay bu tə̀ɗəm : « Avər àdi aday. » Mis ndahaŋ ti ni tə̀ɗəm : « *Məslər ge Melefit àhibiyu ma. » ");
INSERT INTO muy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ay Yezu àhi ana tay ahkado : « Dəŋgu hini ya àhəndabiyu ni ti, àhənday ti azuhva nu do, àhənday ti azuhva kʉli sawaŋ. ");
INSERT INTO muy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nihi ti sarta ga magrafəŋa seriya kè mis ga duniya ènjia, nihi ti tara tagaray bay magədavani ya agur duniya ni. ");
INSERT INTO muy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ay nu ti ka fat ya ti atəzoru nu agavəla nahəma, anazalakaboru mis ɗek afa goro. » ");
INSERT INTO muy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yezu àɗəm nahkay ti awayay aɗafaki ahəmamam amara məmət ni. ");
INSERT INTO muy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Eslini mis dal-dalani ni tə̀həŋgrifəŋ, tə̀hi : « Leli mèjeŋga a Wakita ge Melefit ni bu ni ti, *Krist *Bay gəɗakani ya amara ni ti amələbu ga kaŋgay-kaŋgayani. Ay nak kə̀ɗəm ahàr àɗəm tə̂zoru Wur ge Mis agavəla ti kamam ? Wur ge Mis nani ti way ? » ");
INSERT INTO muy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yezu àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Maslaɗani àbu aslaɗi ana kʉli ga hayaŋani. Ka ya ti maslaɗani àbu ti sawaɗumoru ; do ni ziŋ-ziŋeni ara adi ahàr ana kʉli. Aɗaba maslaŋa ya ti asawaɗay e ziŋ-ziŋeni bu ni ti àsər məlaŋ ya akoru ni do. ");
INSERT INTO muy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ka ya ti maslaɗani àbu e kiɗiŋ gekʉli bu ni ti, fumki ahàr ka Bay ya ti avi maslaɗani ana kʉli ni. Tamal kəgrum nahkay ti kigʉm ndam maslaɗani. » Yezu àra àɗəma ma nana ti, àsləka, àɓufəŋa kà tay a. ");
INSERT INTO muy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ku tamal Yezu àgra zlam magray ejep a dal-dal kè meleher ge mis dal-dalani na nəŋgu ni, mis ni tàwayay məfəki ahàr ndo. ");
INSERT INTO muy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nahkay pakama ge Melefit ya Izayi àhəŋgri ana mis ni àgrava àndava. Pakama gani nani ti nahkay hi : « Bay goro, ma geli ya ti mə̀ɗəm ni ti, way àgəskabá way ? Bay geli àɗəfiaba njəɗa gayaŋ a ti ana way ? » ");
INSERT INTO muy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ndam nday nani tə̀fəki ahàr ka Yezu do ni ti, Izayi àɗəmkia ma ka tay a daya. Àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","« Melefit àwulufa tay a, àgray ti tə̀jalay ahàr sulumani ba. Àgray nahkay ti, awayay ti tìpi divi ba, tə̀sər zlam ba, awayay ti tàmbatkaba majalay ahàr gatay a ba daya. Nahkay Melefit àɗəm : “Tamal tàmbatkaba ti, akal nàhəŋga tay a.”  » ");
INSERT INTO muy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izayi àɗəm nahkay ti aɗaba èpia Yezu naŋ àbu a maslaɗani ge Melefit ba àndava. Àra èpia naŋ a nahkay ti àɗəmki ma. ");
INSERT INTO muy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ku tamal nahkay nəŋgu ni mis ndahaŋ e kiɗiŋ ga gəɗákani ga ndam *Zʉde bu kay tə̀fəkia ahàr ka Yezu a. Ay ti tə̀hi ma gani ana mis vay-vay ndo, aɗaba aŋgwaz àwərfəŋa tay kà ndam *Feriziyeŋ a, tə̀ɗəm bi atəhi ana tay tə̀huriyu a ahay ga *mahəŋgalavù Melefit vu va ba. ");
INSERT INTO muy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nahkay nday gani tawayay magray zlam ya ti àɓəlafəŋ kè mis ni àtama ya ti àɓəlafəŋ kè Melefit na sawaŋ. ");
INSERT INTO muy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yezu àɗəm ma kay kay, àɗəm : « Maslaŋa ya ti afəku ahar nahəma, afəki ahàr ti ka nu do ; afəki ahàr ka Bay ya ti àslərbiyu nu ni. ");
INSERT INTO muy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Maslaŋa ya ti naŋ àbu epi nu ni ti, naŋ àbu epi Bay ya ti àslərbiyu nu ni. ");
INSERT INTO muy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nu nàra a duniya va ti ga maslaɗi məlaŋ ana mis. Nahkay ku way way do afəku ahàr ti ànjəhaɗ e ziŋ-ziŋeni bu va do. ");
INSERT INTO muy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tamal mis ècia ma goro na mək àgəskabu do nahəma, bay ya agrafəŋa seriya ni ti nu do. Aɗaba nu nàra a duniya va ti ga mahəŋgay mis, do ni ti ga magrafəŋa seriya kà tay a do. ");
INSERT INTO muy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Maslaŋa ya ti àwayay nu do, àgəskabu pakama goro do ni ti, seriya aməgəs naŋ : ka mandav ga duniya atəgəs naŋ àna seriya ti àna pakama goro ya nə̀ɗəm ni ɗek. ");
INSERT INTO muy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ay ma goro ya nə̀ɗəm ɗek ni ti nu nə̀ɗəm àna ahàr goro goroani do. Pakama goro ya nə̀hi ana mis akaba ya nə̀cahi ana mis ni ti Baba goro àslərbiyu nu ga məhiani ana tay. ");
INSERT INTO muy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iy nə̀səra, pakama ga Baba goro ya àhi ana mis ni ti, tamal tə̀gəskabá ti nday tə̀bu àna *sifa ya àndav ɗay-ɗay do ni àndava. Pakama goro ya nə̀ɗəm ni, nə̀ɗəm ti akaɗa ga Baba ya àhu nə̂hi ana mis ni. » ");
INSERT INTO muy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Àgəjəni vaɗ bəlaŋ ga mara magray wuməri ga *Pak ti, Yezu àsəra sarta gayaŋ ga masləkana a duniya ba ga moroni afa ga Bəŋani ènjia. Yezu àwaya ndam gayaŋ ya taɗəbay naŋ a duniya bu na dal-dal, nahkay ku ka ya ti ara amət ni àmbrəŋ mawayay tay do. ");
INSERT INTO muy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yezu akaba ndam maɗəbay naŋ ni tə̀bu təzum zlam ga məlakarawa. Ka sarta gani nani *Seteni àvia majalay ahàr ana Zʉdas wur ga Simu Iskariyot ga məsəkumoru Yezu a àndava. ");
INSERT INTO muy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yezu ti àsəra Melefit àvia njəɗa ga məgur zlam a ɗek. Àsəra naŋ àsləkabiya afa ge Melefit a, amaŋgoru afa gani daya. ");
INSERT INTO muy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Àsəra nahkay ti ècikfiŋa kà zlam məzumani na cəkwaɗ, àzakaba mugudi gayaŋ na mək àzay azana nahaŋ, àwəlvu àna naŋ dərkəɗ. ");
INSERT INTO muy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eslini àcahviyu yam e hijiɗ vu, ànjəki ka məbari asak ana ndam maɗəbay naŋ ni mək atəmaɗkia yam na ka asak gatay na àna azana ya àwəlvu àna naŋ na. ");
INSERT INTO muy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Àra ènjikia ka Simu Piyer a ga məbari asak na ti, Simu Piyer nakəŋ àhi ahkado : « Nak ti kabaru asak aw, Bay goro ! » ");
INSERT INTO muy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eslini Yezu àhəŋgrifəŋ, àhi : « Nihi ti ere ye ti nu nagray ni kə̀sərkaba faŋ do, akəsərkaba ti kama kwa. » ");
INSERT INTO muy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyer àhi : « Ɗay-ɗay nàwayay ti nak kâbaru asak do. » Yezu àhi : « Tamal nàbaruk ndo ni ti nak mis goro do. » ");
INSERT INTO muy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simu Piyer nakəŋ àhi : « Tamal nahkay ti kàbaru asak ciliŋ ba : baru ahar akaba ahàr daya, Bay goro ni. » ");
INSERT INTO muy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yezu àhi : « Maslaŋa ya àbara ni ti abaray asak ciliŋ do ni ti àbaray vu gayaŋ va do, aɗaba vu gayaŋ ni ɗek ègia njəlatana. Lekʉlʉm ti kìgʉma njəlatana, ay ti lekʉlʉm ɗekeni do. » ");
INSERT INTO muy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yezu àhi ana tay « Lekʉlʉm ɗek njəlata do » ni ti aɗaba àsəra maslaŋa ya ti ara asəkumoru naŋ na àndava. ");
INSERT INTO muy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yezu nakəŋ àra èndeveriŋa məbari asak ana tay a ti, àzay mugudi gayaŋ ni, àfakabu mək àŋga ka məlaŋ ga zlam məzumani na. Eslini àhi ana tay ahkado : « Ere ye ti nə̀gri ana kʉli ni ti kə̀səruma waw ? ");
INSERT INTO muy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Lekʉlʉm kə̀bum kazalum nu “Mʉsi, Bay geli” ti, nani ti jiri gekʉli, aɗaba nu Mʉsi gekʉli, nu Bay gekʉli eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ay nu Mʉsi gekʉli, Bay gekʉli ni tekeɗi nàbaria asak ana kʉli a ti, ahàr àɗəm e kiɗiŋ gekʉli bu ni ti maslaŋa nahaŋ mə̂bari asak ana maslaŋa nahaŋ. Njumki kwa kani, kəgrumoru kama kama. ");
INSERT INTO muy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ere ye ti nə̀gri ana kʉli kani ni ti nə̀ɗəfiki divi ana kʉli : grumi ana mis akaɗa goro ya nə̀gri ana kʉli ni. ");
INSERT INTO muy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nəhi ana kʉli nahəma, maslaŋa ya agri tʉwi ana mis ni ti àtam bay ya ti naŋ agri tʉwi ni do. Maslaŋa ya təslər naŋ ni ti àtam bay ya ti àslər naŋ ni do. ");
INSERT INTO muy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nihi kə̀səruma nahkay nahəma, grum tʉwi akaɗa ya nə̀ɗəfiki ana kʉli kani ni. Tamal kəgrum nahkay ti akəmərumvu. » ");
INSERT INTO muy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yezu àhi ana tay keti : « Ma goro ya nə̀ɗəm ni ti nə̀ɗəmki ke kʉli, lekʉlʉm ɗekeni do, aɗaba nə̀səra ndam goro ya nə̀daba tay a na. Àbu məbəkiani a Wakita ge Melefit ni bu nahkay hi : “Maslaŋa ya ti mə̀bu məzumkabu zlam kəlavaɗani ni àmbatuva ahàr va.” Ahàr àɗəm pakama nani agravu kwa. ");
INSERT INTO muy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Wuɗaka ere gani ara agravu ti nəhivù ana kʉli. Nə̀hiva ana kʉli a ti, ka ya ti ere gani amagravu ni ti akəsərumki nu gani, nu nə̀bu. ");
INSERT INTO muy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nəhi ana kʉli nahəma, maslaŋa ya ti àgəskabá maslaŋa ya ti nəslər naŋ na ti àgəskabá nu nuana daya. Maslaŋa ya ti àgəskabá nu a ni ti àgəskabá Bay ya ti àslərbiyu nu na daya. » ");
INSERT INTO muy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yezu àra àɗəma ma nahkay ti ɓəruv àtikaba. Àɗəm : « Nəhi ana kʉli nahəma, biliŋ gekʉli aməsəkumoru nu. » ");
INSERT INTO muy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ndam maɗəbay naŋ ni tàra tìcia ma gayaŋ na ti tàmənjavu e eri vu e eri vu, tə̀ɗəm : « Àɗəmki ma hini ti àki ka way ? » ");
INSERT INTO muy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Eslini bəlaŋ e kiɗiŋ ga ndam *maɗəbay Yezu ni bu, naŋ ya ti Yezu awayay naŋ kayani ni, naŋ àbu priɗ kà gəvay ga Yezu. ");
INSERT INTO muy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nahkay Simu Piyer àdaɗi ahàr, awayay ti mîhindifiŋa slimi ga maslaŋa nana kà Yezu a. ");
INSERT INTO muy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Naŋ ya ti Yezu awayay naŋ kayani ni àra àsəra ere ye ti Piyer awayay ahi na ti, àzoru ahàr gayaŋ gwar ka məɓəruv ga Yezu mək èhindifiŋa kà Yezu a, àhi : « Maslaŋa gani nani ti way, Bay goro ? » ");
INSERT INTO muy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yezu àhəŋgrifəŋ, àhi : « Maslaŋa ya ti anasaya vaŋgwala, anahəndakiaya eli a, anəvi ni ti, nani naŋ gani. » Àra àɗəma nahkay ti àhəndakiaya eli a ka vaŋgwala na mək àvi ana Zʉdas wur ga Simu Iskariyot. ");
INSERT INTO muy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Zʉdas nakəŋ àra àza vaŋgwala na ti *Seteni àhuriviyu hʉya. Nahkay Yezu àhi : « Tʉwi gayak ya kara kagray ni ti gray weceweci. » ");
INSERT INTO muy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","E kiɗiŋ gatay ya tə̀zum zlam ni bu ni maslaŋa ya ti àsər Yezu àhi ma gani ana Zʉdas kamam ni ti àbi, si Zʉdas Zʉdasani ciliŋ. ");
INSERT INTO muy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Zʉdas ti naŋ bay məgəsi siŋgu ana tay, nahkay ti mis ndahaŋ e kiɗiŋ ga ndam maɗəbay Yezu ni bu tə̀hi ana ahàr bi Yezu àhi ana Zʉdas môru mə̂səkumbiya zlam ga magray wuməri a, ahkay do ni bi àhi môru məvi zlam ana ndam talaga. ");
INSERT INTO muy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ay Zʉdas àra àza vaŋgwala na ti àhəraya e mite va hʉya. Sarta gani nani ti məlavaɗ. ");
INSERT INTO muy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Zʉdas nakəŋ àra àsləka ti Yezu àhi ana nday ndahaŋ ni ahkado : « Nu *Wur ge Mis nahəma, nihi ti sarta goro ènjia, mis atəsər nu gəɗakani, atazləbay nu. Nahkay azuhva nu ti mis atəsər Melefit day naŋ gəɗakani, atazləbay naŋ. ");
INSERT INTO muy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mis atəsər Melefit naŋ gəɗakani atazləbay naŋ nahkay ti, Melefit Melefiteni àna ahàr gayaŋ day ara agray ti mis tə̂sər nu Wur ge Mis ti nu gəɗakani, ara agray ti tâzləbay nu. Ara agray nahkay wuɗak. ");
INSERT INTO muy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","« Bəza goro ni, nara nəmbərbu kʉli wuɗak, sarta goro àvu kay va bi. Anasləka ti, akəɗəbum məlaŋ goro. Ay ma goro ya nə̀hi ana ndam *Zʉde ni ti nəhi ana kʉli daya : Məlaŋ goro ya anoru ni ti lekʉlʉm ekinjʉmiyu koksah. ");
INSERT INTO muy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nihi nahəma nəɗəfiki divi mʉweni ana kʉli, ahàr àɗəm kəgrum kwa. Divi gani nihi : wayumvu. Nawayay kʉli, nahkay ahàr àɗəm lekʉlʉm day wayumvu akaɗa goro ya nàwayay kʉli ni. ");
INSERT INTO muy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tamal kawayumvu nahkay ti, mis ɗek atəsər lekʉlʉm ndam maɗəbay nu. » ");
INSERT INTO muy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Eslini Simu Piyer àhi ahkado : « Kara kakoru eley, Bay goro ? » Yezu àhəŋgrifəŋ, àhi : « Məlaŋ goro ya nara nakoru ni ti, kìsliki maɗəboru nu nihi koksah. Ay kama kama ti akaɗəboru nu. » ");
INSERT INTO muy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyer àhi : « Bay goro, ku takaɗ nu azuhva nak nəŋgu ni nəgəskabu. Nahkay ti nìsliki maɗəboru kur nihi koksah ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yezu àhi : « Kə̀ɗəm ku takaɗ kur azuhva nu nəŋgu ni kəgəskabu ti eɗeɗiŋ aw ? Nəhuk nahəma : wuɗaka agwazl azlah ti akəɗəm sak mahkər kə̀sər nu do timey ! » ");
INSERT INTO muy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yezu àhi ma ana ndam maɗəbay naŋ ni keti, àhi ana tay ahkado : « Araŋa àhəli ahàr ana kʉli ba. Fumki ahàr ke Melefit ; fumku ahàr daya. ");
INSERT INTO muy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Afa ga Baba goro ti məlaŋ àbiyu kay. Nə̀hia ana kʉli a nakoru nəslamativù məlaŋ ana kʉli. Tamal məlaŋ ni aləbiyu bi ti, akal nə̀hi ana kʉli ndo waw ? ");
INSERT INTO muy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ka ya ti anəslamativabiya məlaŋ na ana kʉli a ni ti anaŋga afa gekʉli a, anəhəloru kʉli afa goro, ti lekʉlʉm kânjəhaɗum ka məlaŋ goro ya nanjəhaɗ ni bilegeni. ");
INSERT INTO muy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Məlaŋ goro ya nakoru ni ti, lekʉlʉm kə̀səruma divi gana àndava. » ");
INSERT INTO muy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tumas àhi : « Bay goro, məlaŋ ya kakoru ni tekeɗi mə̀sər do ni ti, məsər divi gani ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yezu àhi ahkado : « Divi, jiri, sifa ti nu gani. Maslaŋa àbi akoru afa ga Baba àna divi nahaŋ bi, si àna nu kwa. ");
INSERT INTO muy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tamal kə̀səruma nu a ti akal kəsərum Baba daya. Ay nihi nəŋgu kə̀səruma naŋ a, kìpʉma naŋ a àndava. » ");
INSERT INTO muy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Eslini Filip àhi : « Bay goro, ɗəfiki Bəbuk ana leli ti, nahkay èslia geli a hʉya. » ");
INSERT INTO muy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yezu àhi : « Nihi nə̀pəsa akaba kʉli a ti, kə̀sər nu do kekileŋa waw, Filip ? Maslaŋa ya èpia nu a ti èpia Baba. Kə̀hu nə̂ɗəfiki Baba ana kʉli ti kamam ? ");
INSERT INTO muy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nu nə̀bu akaba Baba akaɗa mis bəlaŋ, Baba day naŋ àbu akaba nu akaɗa mis bəlaŋ ti kə̀gəskabu do aw ? Ma goro ya nəhi ana kʉli ni ti nə̀hi ana kʉli àna ahàr goro goroani do. Agray tʉwi ti Baba naŋ ya àbu akaba nu akaɗa mis bəlaŋani ni sawaŋ. Naŋ àbu agray tʉwi ti akaɗa gayaŋ ya awayay ni. ");
INSERT INTO muy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gəsumuki ma goro ya nə̀hi ana kʉli : “Nu nə̀bu akaba Baba akaɗa mis bəlaŋ, Baba day naŋ àbu akaba nu akaɗa mis bəlaŋ” ni. Ay ku tamal kə̀gəsumkabu ma hini ya nə̀hi ana kʉli ni do nəŋgu ni, gəsumkabá ma gana azuhva tʉwi ya nə̀bu nagray na. ");
INSERT INTO muy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","« Nəhi ana kʉli nahəma, maslaŋa ya ti àfəkua ahàr a ti amagray tʉwi akaɗa goro ya nə̀bu nagray ni. Maslaŋa gani nani amagray tʉwi amatam goro ya nə̀bu nagray ni, aɗaba nə̀bu nasləka nakoru afa ga Baba. ");
INSERT INTO muy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tamal kə̀səruma lekʉlʉm ndam goro mək kihindʉm zlam azuhva nani nahəma, anagray. Anagray nahkay ti aɗaba nawayay ti mis ɗek tâzləbay Baba àna tʉwi goro ya nagray ni. ");
INSERT INTO muy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nahkay tamal kihindʉmfua zlam a aɗaba lekʉlʉm ndam goro ti anagray. » ");
INSERT INTO muy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","« Tamal kawayum nu ti akəgrum ere ye ti nə̀hi ana kʉli grum ni. ");
INSERT INTO muy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nahkay ti nu anahəŋgalay Baba mək aməsləribiyu Maslaŋa nahaŋ ana kʉli ga məjənaki kʉli, ti mânjəhaɗ akaba kʉli ga kaŋgay-kaŋgayani. ");
INSERT INTO muy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naŋ ti Məsuf Jireni. Ndam ga *duniya tìsliki məgəskabu naŋ koksah, aɗaba tìpi naŋ do, tə̀sər naŋ do daya. Ay lekʉlʉm ti kə̀səruma naŋ a àndava, aɗaba naŋ àbu akaba kʉli, aməhuriviyu ana kʉli a vu vu. ");
INSERT INTO muy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Anəmbrəŋ kʉli ti kîgʉm bəza kuɗa do : anəŋgəkia ke kʉli a. ");
INSERT INTO muy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sarta àvu gʉzit ti ndam ga *duniya etipi nu va do, lekʉlʉm ti ekipʉm nu aɗaba nu nə̀bu àna sifa, lekʉlʉm day akəlumbu àna sifa. ");
INSERT INTO muy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ka fat nani ti akəsərum nu nə̀bu akaba Baba akaɗa mis bəlaŋ, lekʉlʉm akaba nu, nu day akaba kʉli akaɗa mis bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Maslaŋa ya ti ècia ere ye ti nə̀hi ana kʉli grum na, àmbrəŋ do agray ni ti, maslaŋa nani ti awayay nu eɗeɗiŋ. Tamal mis awayay nu ti, Baba goro amawayay naŋ, nu day anawayay naŋ, anaŋgazlivu aməsər nu. » ");
INSERT INTO muy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Eslini Zʉd èhindifiŋa ma. (Zʉd ti naŋ nani Zʉdas Iskariyot do.) Àhi : « Bay goro, kə̀ɗəm akaŋgazlivu ana leli ciliŋ, kàŋgazlivu ana ndam ga duniya do ni ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yezu àhəŋgrifəŋ, àhi : « Tamal mis awayay nu nahəma, aməgəskabu ere ye ti nə̀hi ana mis tâgray ni. Nahkay ti Baba goro amawayay naŋ, mək leli ata Baba amara afa ga maslaŋa gani nana, amanjəhaɗkabu akaba naŋ. ");
INSERT INTO muy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ay maslaŋa ya ti àwayay nu do ni ti àgəskabu ere ye ti nə̀hi ana mis tâgray ni do. Ma ya ti nəhi ana kʉli, kə̀bum kicʉm ni ti ma ga ahàr goro goroani do : ma ga Baba, Bay ya àslərbiyu nu ni. ");
INSERT INTO muy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ma hini ti nə̀hia ana kʉli a ka ya ti nu nə̀bu akaba kʉli na. ");
INSERT INTO muy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ay Maslaŋa ya ti Baba aməsləribiyu ana kʉli ga məjənaki kʉli ni ti, aməslərbiyu naŋ ti azuhva nu. Maslaŋa nani ti *Məsuf Njəlatani : naŋ gani amacahi zlam ɗek ana kʉli, mək amagray ti kə̂sərumki ka zlam ya nə̀hi ana kʉli ni ɗek. ");
INSERT INTO muy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","« Ere ye ti nəmbribu ana kʉli ni ti manjəhaɗ sulumani. Anagray ti kânjəhaɗum àna sulumani goro ya nəgri ana kʉli ni. Nəgri sulum gani nani ana kʉli ti akaɗa ga ndam ga duniya ya tagray sulum ni do. Aŋgwaz àwər kʉli ba, araŋa àhəli ahàr ana kʉli ba. ");
INSERT INTO muy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kìcʉma, nə̀hi ana kʉli ahkado : “Nasləka, kələŋ gani anaŋga afa gekʉli a.” Tamal kawayum nu ti, nasləka ti akal kəmərumvu, aɗaba nakoru afa ga Baba. Baba ti àtam nu. ");
INSERT INTO muy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Zlam gani ti àgravu faŋ ndo, ay nə̀hi ma gani ana kʉli kwa nihi ti, aɗaba nawayay ti ka ya ti amagravu ni ti kə̂fumku ahàr. ");
INSERT INTO muy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nihi ti nindeveriŋ ma goro ya nəhi ana kʉli ni wuɗak, aɗaba bay magədavani ya agur duniya ni naŋ àbu ara. Maslaŋa gani nani ti èslikʉ do, ");
INSERT INTO muy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ay naŋ àbu ara ti, ti ndam ga duniya tə̂sər nu nawayay Baba akaba tə̂sər nagray ere ye ti Baba àhu nâgray ni. Cikʉmaba, məsləkuma ahalay a. » ");
INSERT INTO muy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","« Məŋ ga zlam eɗeɗiŋeni ti nu gani. Bay ya àjav ni ti Baba. ");
INSERT INTO muy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ndam goro ti akaɗa ahar ga məŋ ga zlam ni. Tamal ahar gani bəlaŋ èwi bəza do ni ti Baba ekelfiŋa. Ay tamal ahar gani ewi bəza ti Baba aslamalay àna məbafəŋana, awayay ti mîwikivu bəza. ");
INSERT INTO muy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma goro ya nə̀hi ana kʉli ni ti àslamala kʉli a, kìgʉma njəlatana. ");
INSERT INTO muy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Lekʉlʉm akaba nu ti mìgʉma akaɗa mis bəlaŋ a ; nahkay njəhaɗuma akaba nu a akaɗa goro ya nanjəhaɗ akaba kʉli na. Ahar ga məŋgəhaf ti tamal àfəŋ kà məŋgəhaf ni bi nahəma, ahar gani nani èwi bəza koksah. Lekʉlʉm day tamal kə̀fum kà nu bi nahəma, akəgrumu tʉwi koksah. ");
INSERT INTO muy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","« Məŋgəhaf ti nu ; lekʉlʉm ti ahar gani. Maslaŋa ya ti naŋ àbu akaba nu, nu day nu nə̀bu akaba naŋ nahəma, maslaŋa gani nani agru tʉwi sulumani, naŋ akaɗa ga ahar ga məŋgəhaf ya àfəŋ kà məŋ gani, ewi bəza kay ni. Nə̀ɗəm nahkay ti aɗaba tamal nu nə̀kibu ke kʉli bi ti kìslʉmki magray tʉwi koksah. ");
INSERT INTO muy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tamal mis naŋ àbi akaba nu va bi ti, naŋ akaɗa ahar ga məŋgəhaf ya tèkelfiŋa tìzligoya, ekʉli ni. Ahar ga məŋgəhaf nday nani ti taŋgaskabu təbiyu a aku vu, aku azumaba ni. ");
INSERT INTO muy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tamal lekʉlʉm kə̀bum akaba nu, kə̀bum kəgəsumkabu ma goro nahəma, hindʉm ere ye ti kawayum ni, nahkay Melefit aməvi ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ere ye ti agray ti mis tâzləbaki Baba goro ni ti nihi : grum tʉwi kay akaɗa ga ahar ga məŋgəhaf ya ewi bəza kayani ni, nahkay mis təsər lekʉlʉm ndam maɗəbay nu eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Baba awayay nu, nu day nawayay kʉli akaɗa gayaŋ ya awayay nu ni. Nawayay kʉli nahkay ti, njəhaɗuma akaba nu a. ");
INSERT INTO muy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu ti nə̀bu nagray ere ye ti Baba àhu gray ni ; nahkay awayay nu, nu nanjəhaɗ akaba naŋ. Nahkay day tamal lekʉlʉm kəgrum ere ye ti nə̀hi ana kʉli grum ni ti nawayay kʉli, kanjəhaɗum akaba nu. ");
INSERT INTO muy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","« Nə̀hi ana kʉli nahkay ti, nawayay ti kə̂mərumvu akaɗa goro ya nəmərvu ni. Nawayay ti kə̂mərumvu dal-dal, ti məmərani gani mîsliva ana kʉli a vu va. ");
INSERT INTO muy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ere ye ti nəhi ana kʉli grum ni ti nihi : Wayumvu akaɗa goro ya nawayay kʉli ni. ");
INSERT INTO muy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tamal mis awayay zləbəba gayaŋ, àgəskabá ti tâkaɗ naŋ azuhva tay a nahəma, maslaŋa nani ti maslaŋa àbi awayay mis àtam gayaŋ ni bi. ");
INSERT INTO muy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tamal lekʉlʉm kəgrum ere ye ti nə̀hi ana kʉli grum ni ti, lekʉlʉm zləbəba goro. ");
INSERT INTO muy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nə̀zalay kʉli ndam məgru tʉwi va do, aɗaba bay magray tʉwi ti àsər ere ye ti bay ya naŋ agri tʉwi agray ni do. Nəzalay kʉli ti zləbəba goro, aɗaba nə̀hia ere ye ti Baba goro àhu na ɗek ana kʉli a. ");
INSERT INTO muy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ŋgay lekʉlʉm kə̀dumaba nu a ti kə̀humi ana ahàr ba. Nu nə̀daba kʉli a sawaŋ. Nə̀daba kʉli a ti ga məgrumu tʉwi nday hini : mara məgru zlam sulumani akaɗa ga ahar ga məŋgəhaf ya ewi bəza sulumani ni. Zlam gani nday nani sulumani ni ti nawayay tìji ba. Nahkay tamal kə̀səruma lekʉlʉm ndam goro mək kihindʉmfiŋa zlam kà Baba azuhva nani nahəma, Baba aməgri ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ere ye ti nəhi ana kʉli grum ni ti nihi : Wayumvu. » ");
INSERT INTO muy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","« Tamal ndam ga *duniya tə̀bu tizirey kʉli ti, səruma tìzirey nu enji gekʉli. ");
INSERT INTO muy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tamal lekʉlʉm ndam ga duniya ti akal ndam ga duniya tawayay kʉli, aɗaba tawayay ndam gatay. Ay lekʉlʉm ti ndam ga duniya do. Nu nə̀daba kʉli a ti nèdekaba kʉli akaba ndam ga duniya ; nday gani tizirey kʉli ti azuhva nani. ");
INSERT INTO muy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sərumki ka ma goro ya nə̀hi ana kʉli : “Maslaŋa ya agri tʉwi ana mis ni ti àtam bay ya ti naŋ agri tʉwi ni do” ni. Tamal tə̀grua daliya ti atəgri daliya ana kʉli daya. Tamal tə̀gəsukia ma ti atəgəsiki ma ana kʉli daya. ");
INSERT INTO muy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Atəgri zlam nday nani ɗek ana kʉli ti azuhva lekʉlʉm ndam goro, aɗaba tə̀sər Bay ya ti àslərbiyu nu ni do. ");
INSERT INTO muy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tamal nàra ndo, nə̀hi ma ana tay ndo nahəma, akal nday ndam magudar zlam do. Ay ti nàra, nə̀hia ma ana tay a, nahkay nday ndam magudar zlam, atətamfəŋa kà seriya koksah. ");
INSERT INTO muy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","« Maslaŋa ya ti ezirey nu ni ti maslaŋa gani nani ezirey Baba daya. ");
INSERT INTO muy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tamal nàgray zlam ya mis tàgray ɗay-ɗay do ni e kiɗiŋ gatay bu ndo ni ti, akal nday ndam magudar zlam do. Nihi ti tìpia tʉwi goro ya nàgray na. Ay ku tìpia nəŋgu ni tə̀bu tizirey nu, tə̀bu tizirey Baba daya. ");
INSERT INTO muy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ay agravu nahkay ti, ti pakama ya àbu məbəkiani e *Divi gatay bu ni mâgravu. Pakama gani nani ti nihi : “Tìzirey nu masakani, day nə̀gri araŋa ana tay ndo.” ");
INSERT INTO muy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","« Ay Məsuf ge jiri naŋ ya anəsləribiyu ana kʉli kwa afa ga Baba ni, amara ga məjənaki kʉli a. Amasləkabiya kwa afa ga Baba eminjikia ke kʉli a ti amagrakua sedi a. ");
INSERT INTO muy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lekʉlʉm day akəgrumkua sedi a, aɗaba kwa ka mənjəki ge tʉwi goro lekʉlʉm kə̀bum akaba nu. » ");
INSERT INTO muy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","« Nə̀hi ma gani ana kʉli ti aɗaba nawayay ti kə̂fumku ahàr, kə̀mbrəŋum ba. ");
INSERT INTO muy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Atagaraya kʉli a ahay ga *mahəŋgalavù Melefit ba. Ay atəgri ana kʉli nahkay ciliŋ do : sarta nahaŋ amara ; ka sarta gani nani ti maslaŋa ya ti amabazl kʉli ni ti aməhi ana ahàr agray ere ye ti Melefit awayay ni. ");
INSERT INTO muy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Atagray nahkay ti aɗaba tə̀sər Baba do, tə̀sər nu do daya. ");
INSERT INTO muy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ay nə̀hi ma gani ana kʉli ti, aɗaba sarta gani eminjia ti akəsərumki ka ma gani, nə̀hia ana kʉli a àndava. Ma gani hini nə̀hi ana kʉli ka mənjəki ge tʉwi geli ndo, aɗaba nu nə̀bu akaba kʉli mba. » ");
INSERT INTO muy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yezu àɗəm keti : « Nihi ti nasləka, nakoru afa ga Bay ya ti àslərbiyu nu ni. Ay “Kəkoru eley” ti maslaŋa àbi ehindifua e kiɗiŋ gekʉli ba bi. ");
INSERT INTO muy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma hini ya nə̀hi ana kʉli ni ti àhəlia ahàr ana kʉli a. ");
INSERT INTO muy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ay ma hini ya nəhi ana kʉli ni ti ma ge jiri : hojo nasləka, aɗaba tamal nàsləka ndo ni ti, maslaŋa ya ti nə̀ɗəm anəsləribiyu ana kʉli ga məjənaki kʉli ni ti amara do. Nahkay anasləka ti akəŋgətum zlam sulumani, aɗaba tamal nasləka ti anəsləribiyu naŋ ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ka ya ti eminjia ni ti aməɗəfiaba zlam ana ndam ga *duniya ; zlam gani nani ti ndam ga duniya tə̀sərkaba lala do. Ere ye ti aməɗəfiaba ana tay a, awayay ti tə̂sərkaba lala ni ti nihi : zlam magudarani ge mis, jiri ge Melefit, seriya ge Melefit. ");
INSERT INTO muy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Àki ka zlam magudarani ti aməɗəfiaba ana tay a nday tə̀bu tagudar zlam, tə̀sər do. Zlam gatay ya tagudar ni ti nihi : tə̀fəku ahàr do. ");
INSERT INTO muy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Àki ke jiri ge Melefit ti aməɗəfiaba ana tay a tə̀sər ma gani do. Ere ye ti aɗafaki Melefit naŋ jireni ni ti nihi : nasləka nakoru afa ga Baba, ekipʉm nu e eri vu va do. ");
INSERT INTO muy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Àki ka seriya ge Melefit ti aməɗəfiaba ana tay a tə̀sər ma gani do. Ere ye ti aɗəfiki seriya ge Melefit ana tay ni ti nihi : bay magədavani ya agur duniya ni ti Melefit àgəsa naŋ àna seriya àndava. ");
INSERT INTO muy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","« Zlam àbu kay nawayay nəhikivu ana kʉli, ay ti nə̀hi ana kʉli do, aɗaba kìslʉmki məgəskabani faŋ do. ");
INSERT INTO muy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Məsuf ge jiri ni eminjia ti aməɗəfiki divi ge jiri ana kʉli, aməhiaba ma gana ɗek ana kʉli a. Ma ya ti aməhi ana kʉli ni ti ma ga ahàr gayaŋ gayaŋani do ; aməhi ana kʉli ti ma ya ti naŋ èci ni ciliŋ. Aməhi ere ye ti amagravu ni ɗek ana kʉli daya. ");
INSERT INTO muy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Amaɗafaki ahəmamam nu gəɗakani ni, aɗaba emici ma goro mək aməhi ma gani ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Zlam ga Baba ɗek ti goro. Nə̀ɗəm Məsuf ge jiri ni emici ma goro, aməhi ana kʉli ni ti azuhva nani. » ");
INSERT INTO muy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yezu àhi ana tay keti : « Kama gʉzit ti ekipʉm nu do, ay kama gani gʉzit ti ekipʉm nu keti. » ");
INSERT INTO muy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ndam maɗəbay naŋ ni tàra tìcia ma gayaŋ na ti ndahaŋ e kiɗiŋ gatay bu tə̀ɗəm : « Àɗəm : “Kama gʉzit ti ekipʉm nu do, ay kama gani gʉzit ti ekipʉm nu keti” akaba àɗəm : “Nasləka nakoru afa ga Baba” ti, àɗəm nahkay ti ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tə̀ɗəm : « Ma gayaŋ ya àɗəm “Kama gʉzit” ni ti awayay aɗəmvaba mam ? Leli mìciaba ma gana do. » ");
INSERT INTO muy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yezu àra àsəra tawayay tihindifiŋa ma na ti àhi ana tay ahkado : « Ma goro ya nə̀hi ana kʉli : “Kama gʉzit ti ekipʉm nu do, ay kama gani gʉzit ti ekipʉm nu keti” ni ti, kə̀bum kazlapumki e kiɗiŋ gekʉli bu. ");
INSERT INTO muy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nəhi ana kʉli nahəma, lekʉlʉm ti ekitʉwʉm, akandavum kuɗa, ay ndam ga *duniya ti ni atəmərvu. Akəgrum daliya, ay daliya gekʉli ni amandav, mək akəmərumvu. ");
INSERT INTO muy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","« Nazay mazavu gani : akəgrum daliya akaɗa ga wal a huɗ awayay ewi wur ni. Wal ni agray daliya aɗaba sarta gayaŋ ènjia. Emiweya wur na ti àjalaki ahàr ka daliya gayaŋ ya àgray ni va do ; amərvu aɗaba èweya mis a duniya va. ");
INSERT INTO muy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nihi ti lekʉlʉm day kə̀bum kəgrum daliya nahkay. Ay enipi kʉli keti : ka sarta gani nani ti akəmərumvu ; maslaŋa àbi amacafəŋa kʉli kà məmərvani nana bi. ");
INSERT INTO muy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","« Ka fat gani nani ti pakama àbi ekihindʉmfua bi. Nəhi ana kʉli nahəma, tamal kə̀səruma lekʉlʉm ndam goro a mək kihindʉmfiŋa zlam kà Baba azuhva nani nahəma, Baba aməvi ana kʉli. ");
INSERT INTO muy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kekileŋa ka ya ti kìhindʉmfiŋa zlam kà Baba ni ti ŋgay lekʉlʉm ndam goro ti kə̀humi faŋ ndo. Hindʉmfiŋa ; tamal kìhindʉmfiŋa nahkay ti akəŋgətum mək akəmərumvu dal-dal, araŋa amacafəŋa kʉli kà məmərvana do. » ");
INSERT INTO muy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","« Nə̀hi ma gani ɗek ana kʉli ti àna ma *gozogul. Ay sarta àbu ara ti anəhi ma ana kʉli nahkay va do. Ka sarta gani nani ti anəɗəmki ma ka Baba vay-vay. ");
INSERT INTO muy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ka fat nani ti ekihindʉmfiŋa zlam kà Baba aɗaba lekʉlʉm ndam goro. Ŋgay anahəŋgali naŋ ana kʉli ti nə̀ɗəm do, ");
INSERT INTO muy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","aɗaba naŋ naŋani àna ahàr gayaŋ awayay kʉli. Awayay kʉli ti aɗaba lekʉlʉm kə̀bum kawayayum nu, kə̀gəsumkabá nàsləkabiya afa gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eɗeɗiŋ nàsləkabiya afa ga Baba, nàra a duniya va, ay nihi ti nasləka a duniya ba, naŋgoru afa ga Baba. » ");
INSERT INTO muy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Eslini ndam maɗəbay naŋ ni tə̀hi ahkado : « Nihi kə̀bu kazlapi ana leli vay-vay, kə̀hi ma gozogul ana leli va do. ");
INSERT INTO muy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nihi ti mə̀səra nak kə̀səra zlam a ɗek, nahkay ahàr àɗəm mihindifʉka ma do, aɗaba kə̀səra ere ye ti mawayay məhuk na àndava. Ègia nahkay ti leli məfəkuk ahàr, mə̀gəskabá kàsləkabiya afa ge Melefit a. » ");
INSERT INTO muy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yezu àhi ana tay : « Nihi ti kəfumku ahàr eɗeɗiŋ aw ? ");
INSERT INTO muy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sarta amara, nihi ti ènjia àndava : ka sarta gani nani ti ekidʉmvu kway-kwayay, ku way way do amasləka zlam gayaŋ a ; lekʉlʉm ɗek akəmbrumbu nu, nu bəlaŋ ka ahàr goro. Ay ti nu bəlaŋ ka ahàr goro do, aɗaba Baba naŋ àbu akaba nu. ");
INSERT INTO muy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nə̀hi ma gani hini ana kʉli ti, nawayay ti araŋa àhəli ahàr ana kʉli ba, aɗaba lekʉlʉm kə̀bum akaba nu akaɗa mis bəlaŋ. Nihi a duniya bu ni ti atəgri daliya ana kʉli, ay zum njəɗa, aɗaba nu ti nèyefiŋa kà duniya àndava. » ");
INSERT INTO muy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yezu àra àɗəma ma nana nahkay ti àmənjoru e melefit vu, àɗəm : « Bəba goro ni, sarta ènjia. Gray ti mis ɗek tə̂sər Wur gayak ti naŋ gəɗakani ; nahkay ti atəsər nak gəɗakani azuhva Wur gayak ni. ");
INSERT INTO muy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kə̀via njəɗa ana Wur gayak ga məgur mis a ɗek, ti mə̂vi *sifa ya àndav ɗay-ɗay do ni ana nday ya ti kə̀bi tay a ahar vu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sifa ya àndav ɗay-ɗay do ni ti nihi : tə̀sər kur, nak bəlaŋ, nak Melefit eɗeɗiŋ eɗeɗiŋeni, tə̀sər Yezu *Krist naŋ ya kə̀slərbiyu ni daya. ");
INSERT INTO muy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nàgra tʉwi ya kə̀hu nâgray ka haɗ na ɗek àndava ; tʉwi goro gani nani àɗəfikia ana mis a nak gəɗakana. ");
INSERT INTO muy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ahaslani wuɗaka kàgraya məlaŋ a nahəma, nu nə̀bu akaba kur a məlaŋ gəɗakani maslaɗani bu : nihi day həŋguriyu nu a məlaŋ gani nani vu keti ti. ");
INSERT INTO muy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kàdaba mis a duniya ba, kə̀bua tay a ahàr va. Nihi ti nə̀ɗəfikia kur ana tay a, tə̀səra kur a àndava. Ahaslani ti nday a ahar bu afa gayak, ay nihi ti kə̀bua tay a ahar va, mək tə̀gəsukkia ma. ");
INSERT INTO muy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nihi ti tə̀səra zlam ya nu nə̀bu àna naŋ ni ɗek ti nak kə̀bu tay a ahar vu eɗeɗiŋ, ");
INSERT INTO muy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","aɗaba nə̀hia pakama gayak ya kə̀hu nə̂hi ana tay na ɗek ana tay a. Pakama gayak gani nani ti tə̀gəskabá : tə̀səra nàsləkabiya ti afa gayak, àslərbiyu nu ti nak eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","« Nahəŋgali kur ana tay. Nàhəŋgali kur ana mis ga *duniya do, nahəŋgali kur ana ndam ya ti kə̀bu tay a ahar vu ni ciliŋ, aɗaba nday ti ndam gayak. ");
INSERT INTO muy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Zlam goro ɗek ti gayak, zlam gayak ɗek day goro ; nahkay mis tə̀səra nu gəɗakani azuhva nday ya ti kə̀bu tay a ahar vu na. ");
INSERT INTO muy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kama kama ti nu anələbi a duniya bu bi, anasləka anoru afa gayak, ay nday ti atanjəhaɗ a duniya ni bu. Bəba goro ni, nak njəlata ; fi ahàr ana tay àna njəɗa gayak. Njəɗa gani nani ti nak kə̀vu. Fi ahàr ana tay ti tîgi akaɗa mis bəlaŋ akaɗa geli ata nak leli mə̀bu bəlaŋani ni. ");
INSERT INTO muy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kə̀vua njəɗa gayak a ; nahkay ka ya ti nə̀bu akaba tay ni ti, nə̀fia ahàr ana tay àna njəɗa gani nana. Nə̀bia slimi ana tay a, ku mis bəlaŋ gatay èji ndo, si maslaŋa ya ti ahàr àɗəm ejiji ni kwa. Gayaŋ ya èjiji ni ti, ti pakama ya àbu məbəkiani a Wakita gayak ni bu ni mâgravu. ");
INSERT INTO muy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","« Nihi ti nasləka nakoru afa gayak. Nu nə̀bu nəhuk ma hini a duniya bu ni ti, nawayay ti nday tə̂mərvu dal-dal azuhva nu, ti məmərani gani mîsliva ana tay a vu va. ");
INSERT INTO muy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nə̀hia pakama gayak a ɗek ana tay a mək tə̀gəskabá. Nahkay ndam ga duniya tə̀bu tizirey tay aɗaba nday ndam ga duniya do, akaɗa goro ya nu mis ga duniya do ni. ");
INSERT INTO muy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nahəŋgalay kur ti ga məhəlaba tay a duniya ba do. Nahəŋgalay kur ti, ti kâhəŋgafəŋa tay kè *Seteni a. ");
INSERT INTO muy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nday ti ndam ga duniya do, akaɗa goro ya nu mis ga duniya do ni. ");
INSERT INTO muy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gray ti tîgi ndam gayak *njəlatani àna jiri gayak. Jiri gayak ti ma ge jiri ya nə̀hi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nak kə̀slərbiyu nu a duniya vu, nahkay nu day nəsləroru tay a duniya vu. ");
INSERT INTO muy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nu mis gayak njəlatani, nahkay nday day etigi ndam gayak njəlatani. Tigi ndam gayak njəlatani ti àna pakama gayak jireni ya nə̀hi ana tay ni. ");
INSERT INTO muy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","« Nàhəŋgali kur ana tay ciliŋ do ; nahəŋgali kur ana nday ya ti atəgəskabu pakama gatay ya atəhi ana tay ni, mək atəfəku ahàr ni daya. ");
INSERT INTO muy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bəba goro ni, nawayay ti mis ya təfəku ahàr ni ɗek tîgi akaɗa mis bəlaŋ, akaɗa nak kə̀bu akaba nu, nu day nə̀bu akaba kur akaɗa mis bəlaŋ ni. Nawayay ti nday day tîgi akaba leli akaɗa mis bəlaŋ ; nahkay ti ndam ga duniya atəsər nak kə̀slərbiyu nu. ");
INSERT INTO muy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nak kàgray ti mis ɗek tə̂sər nu gəɗakani ; nahkay nu day nàgray ti mis tə̂sər ndam ya taɗəbay nu ni nday gəɗákani akaɗa goro ni. Nàgray nahkay ti, nawayay ti tîgi akaɗa mis bəlaŋ akaɗa geli ya leli mə̀bu bəlaŋani ni. ");
INSERT INTO muy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nu ti nə̀bu akaba tay akaɗa mis bəlaŋ ; nak day kə̀bu akaba nu akaɗa mis bəlaŋ. Azuhva nani nday day etigi bəlaŋani akaɗa geli ni. Etigia bəlaŋana ti ndam ga duniya atəsər nak kə̀slərbiyu nu, kawayay tay akaɗa gayak ya ti kawayay nu ni. ");
INSERT INTO muy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","« Bəba goro ni, nawayay ti ndam ya kə̀bu tay a ahar vu ni ti nday day tôru ka məlaŋ goro ya nə̀biyu ni. Nawayay ti tîpi nu, nu gəɗakani azuhva njəɗa gayak ya kə̀vu ni. Kə̀vu njəɗa gani nani ti aɗaba kwa kàgraya məlaŋ a faŋ ndo kàwaya nu a. ");
INSERT INTO muy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bəba goro ni, nak jireni. Ku tamal ndam ga duniya tə̀sər kur do nəŋgu ni, nu nə̀səra kur a ; ndam goro day tə̀səra nak kə̀slərbiyu nu. ");
INSERT INTO muy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nə̀ɗəfikia njəɗa gayak ana tay a, anəɗəfikioru ana tay anəmbrəŋ do. Nawayay ti tâwayavu akaɗa gayak ya kawayay nu ni ; nahkay ananjəhaɗ akaba tay akaɗa mis bəlaŋ. » ");
INSERT INTO muy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yezu àra àɗəma ma na nahkay ti tàsləka, tòru akaba ndam maɗəbay naŋ ni ke ledi ga zalaka ya təzalay Sedroŋ ni. Eslini ti dini nahaŋ àbu, tə̀huriyu. ");
INSERT INTO muy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ay ti Zʉdas naŋ ya ti ara asəkumoru naŋ ni àsəra məlaŋ gani nana, aɗaba kəlavaɗ ata Yezu tə̀bu təcakalavu akaba ndam maɗəbay naŋ ni eslini. ");
INSERT INTO muy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Zʉdas nakəŋ àdi kama ana ndam slewja akaba ana nday ya ti tajəgay *ahay gəɗakani ge Melefit ni. Ndam slewja gani nani ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀cakalavu akaba ndam *Feriziyeŋ mək tə̀sləroru tay. Tòru ti àna zlam ahar gatay, tə̀həla ceŋgel akaba vala-vala a ahar va daya. ");
INSERT INTO muy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yezu àsəra ere ye ti amagrakivu na, nahkay nday nakəŋ tòru tìnjʉa wuɗak ti, àŋgwivabiyu ana tay a ma vu mək àhi ana tay ahkado : « Kəɗəbum way ? » ");
INSERT INTO muy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tə̀hi ahkado : « Maɗəbay Yezu zal Nazaret ni. » Naŋ nakəŋ àhi ana tay : « Nu gani, nu hi. » Zʉdas naŋ ya ara asəkumoru Yezu ni naŋ àkibu ka tay. ");
INSERT INTO muy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yezu àra àɗəma « Nu gani, nu hi » ti tàŋgoru aləŋ-aləŋ, tə̀dəɗ ka haɗ. ");
INSERT INTO muy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yezu àhi ana tay keti : « Kəɗəbum way ? » Tə̀hi ahkado : « Maɗəbay Yezu zal Nazaret ni. » ");
INSERT INTO muy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eslini Yezu àhi ana tay : « Nə̀hia ana kʉli a “Nu gani, nu hi” a timey ! Tamal kəɗəbum ti nu nahəma, mbrəŋum ndam goro hini tâsləka. » ");
INSERT INTO muy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Àɗəm nahkay ti, ti ma ya ti àhi ana Bəŋani : « Bəba, ndam ya ti kə̀bu tay a ahar vu ni ku mis bəlaŋ gatay èjifua ndo » ni mâgravu. ");
INSERT INTO muy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Maslalam àfəŋ ka Simu Piyer ; Simu Piyer nakəŋ àraɗaya fətah mək àsi ana bay məgri tʉwi ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni, àsifəŋa slimi ga ahar ga ɗaf a həndaɗ. Bay magray tʉwi nani ti slimi gani Malkus. ");
INSERT INTO muy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ay ti Yezu àhi ana Piyer : « Həŋguriyu maslalam gayak ni a ahay gani vu. Baba àɗəm anəcakay daliya, ay ti kə̀hi ana ahàr nə̀cakay ba waw ? » ");
INSERT INTO muy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Eslini ndam slewja akaba gəɗakani gatay ni akaba ndam *Zʉde ya tajəgay *ahay gəɗakani ge Melefit ni tə̀gəs Yezu, tə̀wəlikabu ahar. ");
INSERT INTO muy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tàra tə̀wəlikabá ahar na ti tə̀zoru naŋ afa ga Anna. Anna ti medim ga Kayif. Ka sarta gani nani ti Kayif gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit. ");
INSERT INTO muy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Maslaŋa ya àhi ana ndam Zʉde : « Hojo mis bəlaŋ mə̂mət azuhva mis ɗek » ni ti, Kayif gani nani. ");
INSERT INTO muy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simu Piyer nday ata maslaŋa nahaŋ ya naŋ day aɗəbay Yezu ni tàɗəboru Yezu. Bay maɗəbay Yezu nani ti gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni àsəra naŋ a lala. Nahkay tə̀huriyu ka ahar bəlaŋ akaba Yezu a dalaka ga ahay ga gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni vu. ");
INSERT INTO muy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ay ti Piyer àhuriyu ndo, ècik kà mahay. Eslini bay maɗəbay Yezu ya ti gəɗakani ga ndam maŋgalabakabu mis akaba Melefit àsəra naŋ a lala ni àhərkiaya ka wal ya ajəgay mahay na, àhi ma mək àziyu Piyer a dalaka ga ahay ni vu. ");
INSERT INTO muy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wal ya ti ajəgay mahay ni àhi ana Piyer ahkado : « Nak day bəlaŋ ga ndam maɗəbay maslaŋa nani ni do waw ? » Eslini Piyer àhi : « Aha, nu bay maɗəbay naŋ do. » ");
INSERT INTO muy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndam ya tagray tʉwi eslini ni akaba nday ya ti tajəgay *ahay gəɗakani ge Melefit ni aməɗ awər tay, tèbefta aku a tə̀bu tənjafəŋ. Piyer day àrəkivoru ka tay ànjafəŋ bilegeni. ");
INSERT INTO muy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Eslini gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni èhindifiŋa ma kà Yezu a, àhi ahkado : « Ndam maɗəbay kur ti ndamam ? Kacahi mam ana mis ni mam ? » ");
INSERT INTO muy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yezu àhəŋgrifəŋ, àhi : « Nə̀hia ma ana mis a ɗek vay-vay. Kəlavaɗ nə̀bu nəcahi zlam ana tay a ahay ga *mahəŋgalavù Melefit bu akaba a dalaka ga *ahay gəɗakani ge Melefit ni bu, ka məlaŋ ya ndam *Zʉde ɗek təcakalavu ni. Ma ya ti nə̀ɗəm akal-akal ni ti àbi. ");
INSERT INTO muy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kihindifua ma ti kamam ? Hindi ma goro ti afa ga ndam ya ti nə̀hi ma ana tay ni. Nday ti tə̀səra ere ye ti nə̀ɗəm na. » ");
INSERT INTO muy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yezu àra àɗəma nahkay ti bəlaŋ ga ndam ya tajəgay ahay gəɗakani ge Melefit ni àdi barva kəɓa mək àhi : « Təhəŋgrifəŋ kà ma ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ti nahkay aw ? » ");
INSERT INTO muy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yezu àhəŋgrifəŋ, àhi : « Tamal nàgudara ma ti ɗafaya ma ya ti nàgudar na. Ay tamal ma goro ya nə̀ɗəm ni ma ge jiri ti kə̀du barva ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Kələŋ gani Anna àɗəm tə̂zoru naŋ afa ga Kayif gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni. Nahkay tə̀zoru naŋ ahar məwəlikabani afa ga Kayif nakəŋ. ");
INSERT INTO muy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ka ya ti Simu Piyer naŋ àbu anjafəŋ ka aku ni kekileŋa ni ti tə̀hi ahkado : « Nak day bəlaŋ ga ndam maɗəbay maslaŋa hini do waw ? » Ay ti Piyer àɗəm : « Aha, nə̀bi naɗəbay naŋ bi. » ");
INSERT INTO muy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Zal nahaŋ naŋ àbu eslini, naŋ bay məgri tʉwi ana gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni. Maslaŋa gani nani ti Piyer àsifəŋa slimi a ti ana mis ge dini gayaŋ. Maslaŋa nani àhi ana Piyer ahkado : « Nìpi kur kwa enekwiŋ e dini bu ata naŋ ti nak timey. » ");
INSERT INTO muy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ay ti Piyer àɗəm keti : « Aha, nu do. » Eslini agwazl àzlah hʉya. ");
INSERT INTO muy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Dʉ àna zʉzʉeni nahəma, ndam *Zʉde tàzay Yezu afa ga Kayif, tòru àna naŋ afa ge Pilet bay ga ndam *Rom ya agur haɗ *Zʉde ni. Ay tòru tìnjʉa àna naŋ a ti ndam Zʉde tàwayay məhuriyani a ahay vu afa ga bay ni ndo. Aɗaba tamal tə̀huriya ti tigi nday njəlata do, tìsliki məzum zlam ga wuməri ga *Pak ni do. ");
INSERT INTO muy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nahkay bay *Pilet nakəŋ àhərkiaya ka tay e mite va, àhi ana tay ahkado : « Kàbəhaɗumki mirdim ka maslaŋa hini ti àgudar mam ? » ");
INSERT INTO muy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tə̀həŋgrifəŋ, tə̀hi : « Tamal ti àgudar zlam ndo ni ti akal mə̀zəbiyu naŋ afa gayak ndo. » ");
INSERT INTO muy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nday nakəŋ tàra tə̀ɗəma nahkay ti Pilet àhi ana tay ahkado : « Zuma naŋ a, lekʉlʉm lekʉlʉmeni grumfəŋa seriya, akaɗa ge seriya gekʉli ya kəgrum na. » Ndam Zʉde ni tə̀həŋgrifəŋ, tə̀hi : « Leli nahəma, seriya ga makaɗ mis ti tə̀vi divi gani ana leli ga magrani ndo. » ");
INSERT INTO muy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tə̀ɗəm nahkay ti, ti ma ga Yezu ya àɗəm amara məmət nahkay ni ti mâgravu. ");
INSERT INTO muy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Eslini Pilet àŋgoru a ahay vu, àzalay Yezu, èhindifiŋa ma, àhi : « Nak ti bay ga ndam Zʉde eɗeɗiŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yezu àhəŋgrifəŋ, àhi : « Nak nakani kàjalay tək, day ti mis tə̀huk aw ? » ");
INSERT INTO muy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilet àhi : « Nu zal Zʉde aw ? Tə̀zəbiyu kur afa goro ti ndam jiba gayak gayakani akaba gəɗákani gekʉli ga ndam *maŋgalabakabu mis akaba Melefit ni do waw ? Kàgudar mam ? » ");
INSERT INTO muy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yezu àhəŋgrifəŋ, àhi : « Nu bay, ay bay goro ti ga duniya hini do. Tamal bay goro ni ga duniya hini ti, akal ndam goro tàkaɗva akaba ndam ya tə̀gəsi nu ana ndam Zʉde na. Ay ti tàgray nahkay ndo, aɗaba bay goro ni ga duniya hini do. » ");
INSERT INTO muy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilet àhəŋgrifəŋ, àhi : « Kə̀ɗəm nahkay ti nak bay eɗeɗiŋ aw ? » Yezu àhəŋgrifəŋ, àhi : « Nak kə̀ɗəm. Nu ti nàra a duniya va, tìwi nu ti, ti nə̂hi ma ge jiri ana mis. Ku way way do naŋ mis ge jiri ti abi slimi ana ma goro ya nəɗəm ni. » ");
INSERT INTO muy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Eslini Pilet àhi ahkado : « Jiri ti məŋ ga mam jikeŋ mam ? » Pilet nakəŋ àra àhia ma ana Yezu a nahkay ti àhərkiaya ka ndam Zʉde na e mite va keti. Àhi ana tay ahkado : « Nu ti nə̀di ahàr ana zlam magudarani gayaŋ ndo simiteni. ");
INSERT INTO muy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ay kə̀səruma kilevi a wuməri ga *Pak bu ni ti nə̀bu nəfiaya zal daŋgay ana kʉli a bəlaŋ. Nihi ti kawayum nə̂fiaya bay ga ndam *Zʉde na ana kʉli a waw ? » ");
INSERT INTO muy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nday nakəŋ tàra tìcia ma ge Pilet na ti tə̀zlah kay kay, tə̀ɗəm : « Kàfaya maslaŋa nana ba, faya Barabas a sawaŋ ! » Barabas gani nani ti zal abra, àbazla mis a. ");
INSERT INTO muy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Eslini Pilet àhi ana ndam slewja gayaŋ tâzay Yezu, tə̂zləɓ naŋ àna kurupu. ");
INSERT INTO muy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tàra tə̀zləɓa naŋ a ti ndam slewja ni tàslapaya adak a hindigil-hindigil mək tə̀fiviyu a ahàr vu akaɗa ga jaku ni. Tə̀fikabu mugudi ndizeni ga bay daya. ");
INSERT INTO muy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tàra tə̀bəkia zlam nday nana nahkay ti tàhəɗakfəŋbiyu, tə̀hi ahkado : « Məgruk sa, bay ga ndam *Zʉde ! » Nday nakəŋ tàra tə̀hia ma nahkay ti tə̀si barva kəɓa kəɓa. ");
INSERT INTO muy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Eslini Pilet àhərkiaya ka ndam Zʉde na e mite va keti, àhi ana tay : « Nihi nahəma, nara nəzibiyu naŋ ana kʉli e mite vu, ti kə̂sərum nə̀ŋgət zlam magudarani gayaŋ ga məwəlki naŋ di ndo. » ");
INSERT INTO muy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Mək Yezu nakəŋ àhəraya e mite va àna adak ya ka ahàr na akaba àna mugudi ndizeni ya tə̀fikabu na. Yezu àra àhəraya ti Pilet àhi ana tay : « Maslaŋa nakəŋ naŋ hi. » ");
INSERT INTO muy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam gatay ni tàra tìpia Yezu a ti tə̀zlah kay kay, tə̀ɗəm : « *Darfəŋ naŋ kà təndal ! Darfəŋ naŋ kà təndal ! » Pilet àhi ana tay ahkado : « Lekʉlʉm lekʉlʉmeni zuma naŋ a ti kâdarumfəŋ ka təndal gani. Nu ti nə̀ŋgət zlam magudarani gayaŋ ga məwəlki naŋ di ndo. » ");
INSERT INTO muy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ndam Zʉde ni tə̀həŋgrifəŋ, tə̀hi : « Melefit àvia divi ana leli ndam Zʉde a, ahàr àɗəm tâkaɗ naŋ, aɗaba azay ahàr gayaŋ àɗəm naŋ Wur ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilet àra ècia ma gatay na ti àgra aŋgwaz a dal-dal, ");
INSERT INTO muy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","àŋgwiyu a ahay vu keti, àhi ana Yezu : « Nak kàsləkabiya ti eley ? » Ay ti Yezu naŋ te-te, àhəŋgrifəŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilet àhi : « Kə̀hu ma do ? Nisliki məmbrəŋ kur, nisliki *madarfəŋ kur kà təndal ti kə̀sər do waw ? » ");
INSERT INTO muy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yezu àhəŋgrifəŋ, àhi : « Kìsliki məgru araŋa do, si tamal Melefit àvuka divi gana kwa. Nahkay ti maslaŋa ya ti àgəsukbiyu nu ni àgudara zlam a àtama gayak na. » ");
INSERT INTO muy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yezu àra àɗəma nahkay ti Pilet nakəŋ àɗəbay divi ga məmbrəŋ naŋ. Ay ndam Zʉde ni tə̀zlah, tə̀hi : « Tamal kə̀mbrəŋa maslaŋa hina ti kàɗafakia kàwayay *Sezar do, aɗaba ku way way do azay ahàr gayaŋ aɗəm naŋ bay ti maslaŋa gani nani ezirey Sezar. » ");
INSERT INTO muy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilet nakəŋ àra ècia ma ge mis na ti àzəbiyu Yezu e mite vu mək ànjəhaɗ ka məlaŋ magray seriya ni. Məlaŋ gani nani ti maslamalani lala àna akur, təzalay àna ma *Hebri ti « Gabata. » ");
INSERT INTO muy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Vaɗ gani nani ti vaɗ ga maslamalakabu zlam ga wuməri ga *Pak ; fat agray wis wuɗak. Pilet nakəŋ àhi ana ndam Zʉde ni ahkado : « Bay gekʉli nihi. » ");
INSERT INTO muy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Nday nakəŋ tàra tìcia nahkay ti tə̀zlah, tə̀ɗəm : « Kaɗa, kaɗa, darfəŋ naŋ kà təndal ! » Eslini Pilet àhi ana tay ahkado : « Nâdarfəŋ bay gekʉli ni kà təndal aw ? » Gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni tə̀həŋgrifəŋ, tə̀hi : « Bay geli nahaŋ àbi, si Sezar kwa. » ");
INSERT INTO muy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilet àra ècia ma na nahkay ti àvi divi ana ndam slewja gayaŋ ga madarfəŋ Yezu kà təndal. Nahkay nday nakəŋ tàzay Yezu, tàsləka àna naŋ a. ");
INSERT INTO muy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ka ya ti tə̀bu takoru ni ti Yezu azay təndal ya ti takoru *tadarfəŋ naŋ ni àna ahar gayaŋ gayaŋani. Tàhəraya a kəsa ni ba, tòru ka məlaŋ nahaŋ ; məlaŋ gani nani ti təzalay « Məlaŋ ga Aslat ga Ahàr » ; àna ma *Hebri ti təzalay « Golgota. » ");
INSERT INTO muy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tòru tìnjʉa eslina ti *tàdarfəŋ naŋ kà təndal ni. Tàdarfəŋa mis ndahaŋ a cʉ kà təndal ndahaŋ a daya : Yezu ti naŋ e kiɗiŋ gatay bu. ");
INSERT INTO muy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilet àɗəm tə̂bəki ma ka pələŋgaf, tâdarfəŋiyu kà təndal ga Yezu ni ti mis tîjeŋgey, tə̂sər. Ma gani ya ti tə̀bəki ni nahkay hi : « Yezu, zal Nazaret, Bay ga ndam *Zʉde. » ");
INSERT INTO muy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ma gani nani ti tə̀bəki àna ma Hebri, àna ma Rom akaba àna ma Gres. Ndam Zʉde kay tìjeŋga ma gana, aɗaba məlaŋ ya ti tàdarfəŋ Yezu kà təndal ni cifa akaba kəsa. ");
INSERT INTO muy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tàra tìcia ma gana ti tə̀hi ana Pilet ahkado : « “Naŋ Bay ga ndam Zʉde” ti kə̀bəki ba. Ŋgulum bəki : “Maslaŋa hini àɗəm naŋ Bay ga ndam Zʉde” sawaŋ. » ");
INSERT INTO muy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ay Pilet nakəŋ àhi ana tay ahkado : « Ere ye ti nə̀bəki ni ti mânjəhaɗ nahkay. » ");
INSERT INTO muy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ndam slewja ni tàra tàdarfəŋa Yezu kà təndal na ti, tə̀həl azana gayaŋ ni, tèdekaba məlaŋ faɗ, ku way way do e kiɗiŋ gatay bu àŋgəta bəlaŋ. Tàza endʉwi gayaŋ a daya ; endʉwi gani nani ti məɗəməkani àfəŋ bi, tə̀ləmaya zəbalana. ");
INSERT INTO muy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nahkay ndam slewja ni tə̀zlapay e kiɗiŋ gatay bu, tə̀ɗəm : « Mègʉzleh endʉwi hini ba ; ŋgulum məgrumki ca-ca ti mə̂sər way azum way. » Ndam slewja ni tàgray nahkay ti, zlam ya àbu məbəkiani a Wakita ge Melefit ni bu ni àgravu. Pakama gani nani ti nihi : « Tèdekaba azana goro na e kiɗiŋ gatay ba, mək tàgrakia ca-ca ke endʉwi goro a. » Ndam slewja ni tàgray akaɗa nani gani eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kà gəvay ga təndal ya ti tàdarfəŋ Yezu ni ti wál ndahaŋ tə̀bu micikeni. Wál nday nani ti nday hi : məŋ ga Yezu, wur ga məŋ ga məŋani, Mari wal ga Kəlopas akaba Mari ga kəsa Magədala. ");
INSERT INTO muy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Bay maɗəbay Yezu ya Yezu awayay naŋ kayani ni naŋ àbu kà gəvay ga məŋ ga Yezu daya. Yezu àra èpia tay a ti àhi ana məŋani ni ahkado : « Mma, wur gayak ti naŋ hini. » ");
INSERT INTO muy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Àra àhia ma ana məŋana nahkay ti àhi ana bay maɗəbay naŋ ni ahkado : « Muk ti naŋ hini. » Kwa ka fat nani bay maɗəbay Yezu ni àzoru məŋ ga Yezu ni afa gayaŋ ti mânjəhaɗa afa gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yezu àsəra àgra tʉwi gayaŋ na ɗek àndava. Àra àsəra nahkay ti àɗəm ahkado : « Yam àkaɗa nu a. » Àɗəm nahkay ti, ti zlam ya àbu məbəkiani a Wakita ge Melefit bu ni mâgravu. ");
INSERT INTO muy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mandaray nahaŋ àbu eslini mafəkaɗani akaba zum cecʉwekeni. Tàra tìci ma ga Yezu na ti tàzay zlam ya esikabu yam akaɗa ga matala ni, tə̀təliyu a zum ni vu, tàɓahki ka aday mək tə̀təlikabiyu kà pakama ana Yezu. ");
INSERT INTO muy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yezu àra àcaka zum cecʉwekeni na ti àɗəm ahkado : « Tʉwi goro ɗek àgrava àndava. » Àra àɗəma nahkay ti àzəgaɗ ahàr gəzak mək àmət. ");
INSERT INTO muy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Vaɗ gani nani ti hajəŋ gani vaɗ məpəsabana, nahkay mis tə̀bu təslamalavu. Vaɗ məpəsabana gani nani ti àtama vaɗ məpəsabana ndahaŋ na, nahkay ndam *Zʉde tawayay ti kisim ge mis ya ti *tàdarfəŋ tay kà təndal ni tànjəhaɗfəŋiyu kà təndal ni a vaɗ məpəsabana ba ba. Nahkay tòru afa ge Pilet, tə̀hi ahàr àɗəm têheɓi asak ana tay ti tə̂mət weceweci, tə̂həlfəŋa tay kà təndal na. ");
INSERT INTO muy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nahkay Pilet àsləroru ndam slewja gayaŋ. Tàra tìnjia ti tèheɓi asak ni ana mis bəlaŋ gani ya tàdarfəŋ naŋ kà təndal akaba Yezu ni, mək tèheɓi ana naŋ ye cʉ ni. ");
INSERT INTO muy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tàra tə̀rəkia ka Yezu a, tawayay teheɓi asak ti tə̀di ahàr naŋ məmətani àndava, nahkay ti tèheɓi asak ni ndo. ");
INSERT INTO muy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ay bəlaŋ e kiɗiŋ ga ndam slewja ni bu àtəhaɗ Yezu àna awasl a jamaŋgay vu gək. Àra àtəhaɗa naŋ a ti mimiz àŋgəzaya hʉya, yam day àŋgəzaya. ");
INSERT INTO muy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Àgrakia sedi ka zlam gani nana ti, maslaŋa ya èpia ni. Àgrakia sedi a, pakama gayaŋ ya ti àɗəm ni ti jiri eɗeɗiŋ. Naŋ day àsəra pakama gayaŋ ya àɗəm ni jiri eɗeɗiŋ. Àɗəm nahkay ti awayay ti lekʉlʉm day kə̂gəsumkabu pakama gani, kə̂fumki ahàr ka Yezu. ");
INSERT INTO muy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Zlam gani nani àgravu ti, ti zlam ya àbu məbəkiani a Wakita ge Melefit ni bu ni mâgravu. Pakama gani nani ti nihi : « Ku aslat ga vu gayaŋ tekeɗi eteheɓ do. » ");
INSERT INTO muy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Àbu məbəkiani a Wakita ge Melefit ni bu nahkay hi keti : « Ndam ya ti tàtəhaɗ mis ni atamənjaləŋ ka maslaŋa ya ti nday tàtəhaɗ ni. » Pakama gani nani day àgrava. ");
INSERT INTO muy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Zal nahaŋ àbu slimi gani Zʉzef, naŋ ga kəsa Erimete. Naŋ ti bay maɗəbay Yezu, ay aɗəbay naŋ akal-akal aɗaba aŋgwaz awərfəŋa naŋ kà ndam *Zʉde a. Yezu àra àməta ti Zʉzef nakəŋ òru afa ge Pilet, èhindifiŋa divi ga mazay kisim ga Yezu na, mək Pilet àvi divi gani. Nahkay òru àzay kisim ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodem day òra ka məlaŋ gana. Nikodem ti naŋ ya ti a vaɗ nahaŋ àrəkioru ka Yezu ga məlavaɗ ni. Òru ti, àzay haf mebeɗeni gərgəri cʉ, bəlaŋ gani təzalay mir, nahaŋ ti ni elʉwes, àgray kilʉ kru kru mahkər. Haf gani nani ti mizi gani àɓəlay. ");
INSERT INTO muy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tàra tə̀zaya kisim na ti ata Zʉzef nday ata Nikodem nakəŋ tìtʉɗey àna gabaga ; ka ya ti tə̀bu titʉɗey nahəma, təbəki haf ni ke kisim ni hi hi. Wuɗaka ndam Zʉde tili mis ti tagray nahkay day. ");
INSERT INTO muy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kà gəvay ga məlaŋ ya *tàdarfəŋ Yezu kà təndal ni ti dini nahaŋ àbu eslini. E dini gani nani bu ni ti mindiviŋ nahaŋ àvu, tìli nihi guhwa tə̀fiyu kisim ga maslaŋa faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ka fat nani ti ndam Zʉde tə̀bu təslamalavu ga vaɗ *məpəsabana, nahkay ata Zʉzef nday ata Nikodem nakəŋ tə̀fiyu Yezu e mindiviŋ nani vu, aɗaba mindiviŋ ni driŋ do. ");
INSERT INTO muy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dʉ ge miledʉ àna zʉzʉeni a vaɗ ye enjenjeni ga gosku nahəma, Mari ga kəsa Magədala òru ke mindiviŋ ni. Òru ènjʉa ti àdi ahàr ana mindiviŋ ni bəŋa, èpi belim ni àləŋ ana mindiviŋ ni bi. ");
INSERT INTO muy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Naŋ nakəŋ àra èpia belim ni àləŋ bi nahkay ti àcuhwakibiyu ka Simu Piyer nday ata bay maɗəbay Yezu ya Yezu awayay naŋ kay ni, àhi ana tay ahkado : « Ndamaŋa tə̀zaba Bay geli na e mindiviŋ ni ba, mə̀sər məlaŋ ya tàfəkaɗ ni do. » ");
INSERT INTO muy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ata Piyer nday ata bay maɗəbay Yezu nahaŋ ni tàra tìcia nahkay nahəma, tàsləka tàzay divi ga moroni ke mindiviŋ ni. ");
INSERT INTO muy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nday cʉeni tacuhworu, ay bay maɗəbay Yezu nahaŋ ni àcuhway àtam Piyer, ènjiyu ke mindiviŋ ni enji gayaŋ. ");
INSERT INTO muy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Òru ènjʉa ti àndəhaɗ ahàr, àmənjiyu e mindiviŋ ni vu, èpi gabaga ni mabəhaɗani ciliŋ, ay ti àhuriyu ndo. ");
INSERT INTO muy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kələŋ gani Simu Piyer ti ni òru ènjʉa ke mindiviŋ na ti àhuriyu hʉya, èpi gabaga ni mabəhaɗani duca, ");
INSERT INTO muy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","azana ya ti tìtʉɗi ahàr ana Yezu àna naŋ ni day mifeɗekabani ka məlaŋ nahaŋ, mabəhaɗani akaba gabaga ni do. ");
INSERT INTO muy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Eslini bay maɗəbay Yezu nahaŋ ya ènjiyu ke mindiviŋ enji ge Piyer ni àhuriyu bilegeni. Àra àhuriya ti èpi zlam ya ti àgravu ni, àsəra Yezu àŋgaba e kisim ba. ");
INSERT INTO muy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Àbu məbəkiani a Wakita ge Melefit bu, ahàr àɗəm Yezu amət mək aŋgaba e kisim ba, ay kekileŋa nday gani tìciaba pakama gana faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Kələŋ gani ndam *maɗəbay Yezu nakəŋ tàsləka, tòru a magam. ");
INSERT INTO muy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ka sarta gani nani Mari naŋ àbu kà gəvay ge mindiviŋ ni, etʉwi. Naŋ àbu etʉwi ti àndəhaɗ ahàr, àmənjiyu e mindiviŋ ni vu, ");
INSERT INTO muy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","èpi *məslər ge Melefit cʉ məbakabu azana bəɗ-bəɗani. Nday manjəhaɗani digʉs-gʉs ka məlaŋ ya tàfəkaɗ kisim ga Yezu ni ; bəlaŋ manjəhaɗani gwar ka məlaŋ ga ahàr, bəlaŋ gani ti ni gwar ka məlaŋ ga asak. ");
INSERT INTO muy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eslini məslər ni tìhindifiŋa ma, tə̀hi ahkado : « Wal hini, kitʉwi mam ? » Wal ni àhəŋgrifəŋ ana tay, àhi ana tay ahkado : « Ndamaŋa tə̀zaba Bay goro e mindiviŋ ba, nə̀sər məlaŋ ya tàfəkaɗ ni do. » ");
INSERT INTO muy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Àra àɗəma nahkay ti àmbatbiyu ma kələŋ, èpi Yezu naŋ jika, ay ti ŋgay Yezu ti àsər do. ");
INSERT INTO muy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eslini Yezu àhi : « Wal ni, kitʉwi mam ? Kaɗəbay way ? » Wal ni àhi ana ahàr maslaŋa ya àhi ma ni ti bay ya agray tʉwi e dini bu ni. Nahkay àhi : « Maslaŋa goro, tamal nak kàzaba naŋ a ti ɗəfuki məlaŋ gani, nakoru nazay. » ");
INSERT INTO muy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yezu àhi : « Mari. » Eslini Mari nakəŋ àmbatkioru ma, àhi àna ma *Hebri : « Rabuni. » Awayay aɗəmvaba : « Mʉsi. » ");
INSERT INTO muy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yezu àhi : « Kàcafəŋa nu kà masləkana ba, aɗaba nə̀cəloru afa ga Baba faŋ ndo. Nihi ti ru afa ga bəza ga mmawa ni, hi ana tay ahkado : “Nəcəloru afa ga Baba, naŋ Bəŋ gekʉli daya. Naŋ gani ti Melefit goro, Melefit gekʉli daya.” » ");
INSERT INTO muy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mari ga kəsa Magədala nakəŋ àra ècia ma ga Yezu na ti àrəkioru ka ndam maɗəbay Yezu ni, àhi ana tay ahkado : « Nìpia Bay geli na. » Mək àŋgəhaɗi ma ga Yezu ya àhi ni ana tay. ");
INSERT INTO muy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka fat ga ladi gani nani ga məlakarawa ti ndam *maɗəbay Yezu ni tàŋgasva a ahay ba mək tə̀zləkkabá mahay a, aɗaba aŋgwaz awərfəŋa tay kà ndam *Zʉde ndahaŋ na. Nday tə̀bu maŋgasvani nahkay ti Yezu àhurkiviyu ka tay, ècik jik e kiɗiŋ gatay bu, àhi ana tay : « Melefit mâgray ti araŋa àhəli ahàr ana kʉli ba. » ");
INSERT INTO muy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Àra àhia ma ana tay a nahkay ti àŋgazli ahar gayaŋ ni akaba jamaŋgay gayaŋ ni ana tay. Nday nakəŋ tàra tìpia Bay geli na ti tə̀mərva dal-dal. ");
INSERT INTO muy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Eslini Yezu àhi ana tay : « Melefit mâgray ti araŋa àhəli ahàr ana kʉli ba » keti. Mək àhi ana tay : « Melefit àslərbiyu nu, nahkay nu day nəslər kʉli akaɗa gayaŋ ya àslərbiyu nu ni. » ");
INSERT INTO muy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Àra àɗəma nahkay ti èviteki aməɗ gayaŋ ka tay mək àhi ana tay : « Nə̀via Məsuf Njəlatana ana kʉli a : gəsumkabá naŋ a. ");
INSERT INTO muy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ndam ya ti akəmbrəŋumfəŋa zlam magudarani gatay na kà tay a ni ti, Melefit day aməmbərfəŋa kà tay a. Ay ndam ya ti akəmbrəŋumfəŋa zlam magudarani gatay na kà tay a do ni ti, Melefit day aməmbərfəŋa kà tay a do. » ");
INSERT INTO muy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tumas ti naŋ bəlaŋ ga ndam *maɗəbay Yezu kru mahar cʉeni ni, təzalay naŋ Didim daya. Ka fat gani nani ya ti Yezu àŋgazlivu ana ndam maɗəbay naŋ ndahaŋ ni ti Tumas naŋ àkibu ka tay bi. ");
INSERT INTO muy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ndam maɗəbay Yezu ndahaŋ ni tə̀hi ahkado : « Mìpia Bay geli na. » Àra ècia ma gatay na ti àhi ana tay ahkado : « Nawayay nipi məlaŋ ga ahar ya tàdar àna masaŋsaŋ ni, nawayay nətəliyu weleher a məlaŋ gani vu. Nawayay nətəliyu ahar a məlaŋ ga jamaŋgay ya tàtəhaɗ àna awasl ni vu. Tamal nàgray nahkay ndo ni ti nə̀gəskabu ma gekʉli ni do. » ");
INSERT INTO muy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Gosku sekw ka ahàr gani ndam maɗəbay Yezu ni tə̀bu maŋgasvani a ahay bu keti, mahay məzləkkabani, Tumas day naŋ àkibu ka tay. Yezu àrəkia ka tay a, ècik jik e kiɗiŋ gatay bu, àhi ana tay ahkado : « Melefit mâgray ti araŋa àhəli ahàr ana kʉli ba. » ");
INSERT INTO muy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Eslini àhi ana Tumas nakəŋ : « Mənjaki ka ahar goro ni, ti kə̂təliyu weleher gayak ni. Təliyu ahar gayak a jamaŋgay goro ni vu. Mbrəŋ gejewi, fəku ahàr, gəskabá nàŋgaba e kisim ba eɗeɗiŋ a. » ");
INSERT INTO muy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Eslini Tumas nakəŋ àhi : « Nak Bay goro, nak Melefit goro. » ");
INSERT INTO muy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yezu àhi : « Nak ti kìpia nu a day kwa ti kəgəskabu nu nàŋgaba e kisim ni ba. Ndam ya ti təgəskabu nàŋgaba e kisim ba, tìpi nu ndo ni ti tə̂mərvu. » ");
INSERT INTO muy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yezu ti àgra zlam magray ejep ndahaŋ a gərgəri kay kè meleher ga ndam maɗəbay naŋ na. Ay ti tə̀bi məbəkiani a wakita hini bu bi. ");
INSERT INTO muy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Zlam ya ti nə̀bəki ni ti, nawayay ti kə̂gəsumkabu Yezu ti naŋ *Krist, naŋ Wur ge Melefit. Tamal kə̀gəsumkabá ti Melefit aməvi *sifa ya àndav ɗay-ɗay do ni ana kʉli aɗaba kə̀bum kəfumki ahàr ka Yezu palam. ");
INSERT INTO muy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Àra àgra vaɗ a ɓal ka ahàr gana ti Yezu àŋgazlivu ana ndam maɗəbay naŋ ni keti. Àŋgazlivu ana tay ti kà gəvay ga dəluv Tiberiyat. Zlam gani àgravu ti nahkay hi : ");
INSERT INTO muy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ka sarta gani nani ndam *maɗəbay Yezu ata Simu Piyer, Tumas naŋ ya təzalay naŋ Didim ni, Natanayel ga kəsa Kana ga haɗ *Gelili ni, bəza ge Zebede akaba ndam maɗəbay Yezu ndahaŋ cʉ tə̀bu ka ahar bəlaŋ eslini. ");
INSERT INTO muy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nday tə̀bu eslini ti Simu Piyer àhi ana nday ndahaŋ ni : « Nakoru nəgəsbiyu kilif. » Nday nakəŋ tə̀hi : « Leli day makoru. » Nahkay tòru tə̀cəliyu a *slalah ga yam vu, taɗəboru kilif. Tàndəhaɗki hundum ga məgəsani, ay ku kilif bəlaŋ tekeɗi tə̀gəs ndo. ");
INSERT INTO muy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Məlaŋ àra àsla ti ndam maɗəbay Yezu nakəŋ tìpi Yezu naŋ àbu jika ka dəŋ-dəŋ, ay ŋgay naŋ ti tə̀sər ndo. ");
INSERT INTO muy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Eslini Yezu àhi ana tay ahkado : « Ndam goro ni, zlam məzumani àfəŋ kè kʉli gʉzit aw ? » Tə̀hi : « Àbi. » ");
INSERT INTO muy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Mək Yezu nakəŋ àhi ana tay : « Təlumiyu zəva gekʉli ni gwar ka ahar ga ɗaf. Nahkay ti akəgəsumaya kilif a. » Nday nakəŋ tàra tə̀təliya ti zəva ni àgəsa kilif a dal-dal. Tawayay tagəjahaya a slalah ga yam ni va, ay ti tìsliki ndo. ");
INSERT INTO muy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Eslini bay maɗəbay Yezu ya ti Yezu awayay naŋ kay ni àhi ana Piyer : « Hini ti Bay geli ci ni. » Simu Piyer àra ècia ya tə̀hi « Hini Bay geli » ni ti àfakabiyu endʉwi gayaŋ ya àzakaba ni, mək àdiyu a yam ni vu cizliv. ");
INSERT INTO muy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Məlaŋ ya tə̀gəsaya kilif a ni ti driŋ driŋ akaba dəŋ-dəŋ ni do, àgray ezeweɗ bəlaŋ ciliŋ, nahkay ndam maɗəbay Yezu ndahaŋ ni tàra àna slalah ga yam na gwar kà dəŋ-dəŋ na, tagəjahbiyu zəva gatay ya akaba kilif dal-dalani ni. ");
INSERT INTO muy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nday nakəŋ tàra tìnjia ka dəŋ-dəŋ na, tàhəraya a slalah ga yam ni ba ni ti, tìpi aku ŋgulusa, kilif àki baca akaba *dipeŋ. ");
INSERT INTO muy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Eslini Yezu àhi ana tay : « Dəguma àna kilif ya kə̀gəsumaya na. » ");
INSERT INTO muy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nahkay Simu Piyer àcəliyu a slalah ga yam ni vu keti, àgəjahaya zəva na ka dəŋ-dəŋ a. Tàra tàgəjahaya ti tə̀diviyu ahàr ana kilif gəɗákani diŋ àna kru kru zlam mahar mahkər. Akaba nani ɗek zəva ni àtəɗkaba ndo. ");
INSERT INTO muy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yezu àhi ana tay : « Dəguma kə̂zumum zlam. » Ku maslaŋa bəlaŋ e kiɗiŋ ga ndam maɗəbay naŋ ni bu ŋgay « Nak way ? » ti tìsliki məhiani ndo, aɗaba tə̀səra naŋ Bay geli. ");
INSERT INTO muy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eslini Yezu àra àzay dipeŋ ni, àvi ana tay, mək àvikivu kilif ni ana tay. ");
INSERT INTO muy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kwa ga Yezu ya àŋgaba e kisim ba ni ti àŋgazlivu ana ndam maɗəbay naŋ ni sak mahkər àna hini. ");
INSERT INTO muy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tàra tə̀zuma zlam a ti Yezu àhi ana Simu Piyer ahkado : « Simu wur ge Zeŋ, kawayay nu kàtama nday hina waw ? » Piyer nakəŋ àhi : « Iy Bay goro, kə̀səra nawayay kur. » Mək Yezu àhi : « Jəgay bəza təmbak goro ni. » ");
INSERT INTO muy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yezu àhi ye cʉ : « Simu wur ge Zeŋ, kawayay nu aw ? » Piyer àhi : « Iy Bay goro, kə̀səra nawayay kur. » Mək Yezu àhi : « Hətay təmbəmbak goro ni. » ");
INSERT INTO muy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yezu àhi ya mahkər : « Simu wur ge Zeŋ, kawayay nu aw ? » Pakama ga Yezu ya àhi ana Piyer « Kawayay nu aw ? » ya mahkər ni ti àhəlia ahàr ana Piyer a, nahkay àhi ana Yezu : « Bay goro ni, kə̀səra zlam a ɗek ; kə̀səra nə̀bu nawayay kur. » Eslini Yezu àhi : « Jəgay təmbəmbak goro ni. ");
INSERT INTO muy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nəhuk nahəma, ka ya ti nak wur dagwa ni ti, nak nakani kə̀wəlvu àna maslpara, kòra ka məlaŋ ya ti kàwayay na ɗek. Ay ka ya ti ekigia medewel a ni ti akəhəloru ahar agavəla, maslaŋa nahaŋ aməwəlukvù maslpara gayak ni, mək amazoru kur ka məlaŋ ya nak akawayay moroni do ni. » ");
INSERT INTO muy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yezu àɗəm nahkay ti, awayay aɗafaki ahəmamam Piyer amara məmət, mis atazləbay Melefit azuhva məmət gayaŋ ni. Yezu àra àhia ma nahkay ti àhi : « Ɗəbabiyu nu. » ");
INSERT INTO muy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Eslini Piyer àmənjabiyu gwar kələŋ, mək èpi bay maɗəbay Yezu ya ti Yezu awayay naŋ kay ni. Naŋ ti naŋ ya ti a vaɗ ya ti tə̀zum zlam akaba Yezu ni ti àzoru ahàr gayaŋ gwar ka məɓəruv ga Yezu, àhi : « Bay geli, maslaŋa ya ara asəkumoru kur ni ti way ? » ni. ");
INSERT INTO muy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piyer àra èpia naŋ a nahkay ti àhi ana Yezu ahkado : « Ay naŋ hini timey, Bay geli ? » ");
INSERT INTO muy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yezu àhi : « Tamal nawayay ti mânjəhaɗ duk abivoru ana vaɗ goro ya anaŋga ni ti, ma gani gayak mam ? Nak ti ɗəbabiyu nu ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Bəza ga məŋ geli ndahaŋ tàra tìcia ma ga Yezu ya àɗəm na ti, tə̀bu təɗəm e kiɗiŋ gatay bu bay maɗəbay Yezu nani ti aməmət do. Ay ŋgay aməmət do ni ti Yezu àɗəm ndo. Ma gayaŋ ya àɗəm ni ti nahkay hi : « Tamal nawayay ti mânjəhaɗ duk abivoru ana vaɗ goro ya anaŋga ni ti, ma gani gayak mam ? Nak ti ɗəbabiyu nu ciliŋ. » ");
INSERT INTO muy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Àbəki zlam nday hini ka wakita ti bay maɗəbay Yezu nani ; naŋ àbu agray sedi gani daya. Leli day mə̀səra sedi gayaŋ ya agray ni ti sedi ge jiri. ");
INSERT INTO muy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yezu àgra zlam ndahaŋ a kay daya. Tamal təbəki ma gani bəlaŋ àna bəlaŋ ka wakita ti, amal wakita gani dal-dal àsaɓay. Nətamahay məlaŋ ga duniya ni ɗek àhəca ga mabəhaɗvana.");
INSERT INTO muy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teyʉfil goro ni, nəbukki wakita nahaŋ keti. A wakita goro ya ti nə̀bukki enjenjeni ni bu ni ti, nàŋgəhaɗuka tʉwi ga Yezu ya àgray na akaba zlam ya àcahi ana mis na ɗek. Nàŋgəhaɗukaba ɗek kwa ka mənjəki ge tʉwi gayaŋ ");
INSERT INTO muy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","duk àbivu ana vaɗ ya ti Melefit àzoru naŋ agavəla na. Wuɗaka Yezu àcəloru agavəla nahəma, àhia ma ana ndam ya àdaba tay a, tìgia ndam *asak gayaŋ a ni. Àhi ana tay ere ye ti naŋ àwayay tâgray ni, àhi ana tay àna njəɗa ga *Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Àra àcaka daliya, àməta ti àŋgazlivu ana tay, àgra zlam a gərgəri ti tə̂sər naŋ àna sifa eɗeɗiŋ. A huɗ ga vaɗ kru kru faɗani bu àrəkia ka tay a sak kay, àhi ma ana tay àki ka *Məgur ge Melefit. ");
INSERT INTO muy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A vaɗ nahaŋ Yezu naŋ àbu àzum zlam akaba tay nahəma, àhi ana tay ahkado : « Nə̀hia ana kʉli a, Baba goro aməvi zlam ana kʉli. Nahkay zla nahəma, kə̀sləkumaba a Zerʉzalem a ba, jəgum zlam gani ya ti aməvi ana kʉli ni. ");
INSERT INTO muy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Zeŋ ti àbara mis àna yam a. Lekʉlʉm ti ni vaɗ ɓal kama Melefit *aməbaray kʉli àna Məsuf Njəlatani. » ");
INSERT INTO muy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","A vaɗ nahaŋ nday tə̀bu akaba Yezu ti tìhindifiŋa ma, tə̀hi ahkado : « Bay geli, kara kagray ti ndam *Izireyel tə̂gur məlaŋ zlam gatay keti ti nihi hʉya aw ? » ");
INSERT INTO muy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Àhəŋgarfəŋ, àhi ana tay ahkado : « Bay ya ti àfəkaɗ vaɗ gani akaba sarta gani ti Baba goro. Lekʉlʉm zla ti Melefit àvi divi ana kʉli ga məsərani ndo. ");
INSERT INTO muy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ay zla ti Melefit aməbəkiaya Məsuf gayaŋ ke kʉli a, nahkay akəgrumkua sedi àna njəɗa gayaŋ a. Akəgrumkua a Zerʉzalem, ka haɗ *Zʉde, ka haɗ *Samari, ku kè sliri ga məlaŋ a ɗek. » ");
INSERT INTO muy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yezu àra àhia ma nana ana tay a nahkay ti, nday tə̀bu tamənjaləŋ ti, Melefit àzoru naŋ agavəla a huɗ melefit vu, mək məguduŋguduŋ àŋgah naŋ, tìpi naŋ va do. ");
INSERT INTO muy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yezu àra àsləka ti nday tə̀bu tamənjoru agavəla kekileŋa. Eslini mis cʉ məbakabu azana bəɗ-bəɗani tə̀rhərkia ka tay a, ");
INSERT INTO muy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","tə̀hi ana tay ahkado : « Ndam Gelili, kəmənjumoru agavəla ti kamam ? Yezu gani kìpʉma naŋ a àdoru e melefit vu ti, amaŋga day akaɗa gayaŋ ya ti kìpʉm naŋ òru e melefit vu ni. » ");
INSERT INTO muy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ka sarta gani nani ti nday ka həma ya təzalay *Oliviye ni. Həma gani nani driŋ driŋ kay akaba Zerʉzalem do, àgray ezeweɗ kru. Nahkay nday nakəŋ tàsləka eslina, tàŋga a Zerʉzalem a. ");
INSERT INTO muy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tòru tìnjʉa ti tə̀cəloru a ahay gatay ya tanjəhaɗviyu ni vu. Ahay gani nani ti ka ahàr ga ahay nahaŋ. Nday gani ti ata : Piyer, Zeŋ, Zek, Andre, Filip, Tumas, Bartelemi, Meciyʉ, Zek wur ga Alfe, Simu naŋ bəlaŋ ga ndam ya takaɗvakivu ka haɗ gatay ni, nahaŋ ni ti ni Zʉd wur ge Zek. ");
INSERT INTO muy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nday ɗek tə̀bu təcakalavu kəlavaɗ akaba wál ndahaŋ, akaba Mari məŋ ga Yezu akaba bəza ga məŋ ga Yezu. Təcakalavu ti ga mahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Àra àgra vaɗ a ɓal ti bəza ga məŋ geli tə̀cakalava, tàgray nday diŋ àna kru kru cʉ. Eslini Piyer ècikaba e kiɗiŋ gatay ba, àhi ana tay ahkado : ");
INSERT INTO muy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","« Bəza ga mmawa, ahaslani Zʉdas naŋ bəlaŋ geli Melefit àdaba naŋ a ga magrakabu tʉwi akaba leli a, ay ti naŋ gani àɗəfikia divi a ana ndam ya tə̀gəs Yezu na. Àgray nahkay nahəma, kwa ahaslani Devit àɗəmkia ma ka naŋ a. Ma gani nani ti àɗəm àna njəɗa ga *Məsuf Njəlatani, àbu məbəkiani a Wakita ge Melefit bu. Nahkay ahàr àɗəm ma gani nani si mâgravu kwa. » ");
INSERT INTO muy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ga Zʉdas ya àɗəfiki divi ana mis ni ti àgudara zlam a. Tə̀vi siŋgu azuhva nani, mək òru àsəkum vədaŋ àna naŋ. Eslini naŋ nakəŋ àdəɗ a ma ma, huɗ gayaŋ ni àtəzkaba tuh, dindey gayaŋ ɗek àhəraya a dala va. ");
INSERT INTO muy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndam Zerʉzalem ɗek tàra tìcia zlam gana ya àgravu na ti, tə̀zalay vədaŋ nani Hakeldama, awayay aɗəmvaba àna ma gatay a ti dala ge mimiz. ");
INSERT INTO muy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nahkay Piyer àhi ana tay : « Àbu məbəkiani a wakita ge Limis bu : “Ti tə̂mbrəŋ ahay gayaŋ, ti maslaŋa ànjəhaɗvù va ba.” « Àbu məbəkiani keti : “Ti maslaŋa nahaŋ mâzay məlaŋ gayaŋ ni, mâgray tʉwi gayaŋ ni.” ");
INSERT INTO muy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","« Nihi nahəma, ahàr àɗəm mədumaba maslaŋa nahaŋ a. Maslaŋa nani ti ahàr àɗəm si naŋ e kiɗiŋ ga ndam geli ya tàɗəbay Bay geli Yezu ka ya ti leli mə̀bu masawaɗay akaba naŋ ni, ");
INSERT INTO muy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ànjəki ka fat ya ti Zeŋ *àbaray Yezu ni duk ànivoru ana vaɗ ya ti Melefit àzaba Yezu e kiɗiŋ geli ba, àzoru naŋ agavəla ni. Leli ti magrakia sedi ka maŋgaba ga Yezu a, nahkay ahàr àɗəm bəlaŋ gatayani mə̂hərkivaya ke leli a. » ");
INSERT INTO muy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piyer àra àɗəma ma nana ti tə̀həl mis cʉ, bəlaŋ gani slimi gayaŋ Zʉzef, mis tə̀zalay naŋ Barsabas, slimi gayaŋ nahaŋ Zʉstʉs ; maslaŋa nahaŋ ni ti ni slimi gayaŋ Matiyas. ");
INSERT INTO muy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Eslini nday ɗek tàhəŋgalay Melefit, tə̀ɗəm : « Bay geli, nak kə̀səra ere ye ti àniviyu ana mis a məɓəruv bu na ɗek. Nahkay ɗəfiki maslaŋa ya kàdaba naŋ e kiɗiŋ gatay cʉeni hini ba ni ana leli. ");
INSERT INTO muy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Maslaŋa ya nak akadaba naŋ a ni ti, emigi zal asak a məlaŋ ga Zʉdas ni vu ga magray tʉwi gayaŋ. Zʉdas ti àsləkaba, àdoru ka məlaŋ gayaŋ nahaŋ zlam gayaŋ. » ");
INSERT INTO muy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tàra tàhəŋgala Melefit a nahkay ti tàgraki ca-ca ka tay ti təsərkaba maslaŋa ya ti Melefit àdəkiba ni, mək àdəɗki ka Matiyas. Nahkay Matiyas nakəŋ ahurkiviyu ka ndam *asak kru mahar bəlaŋani ni. ");
INSERT INTO muy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ka fat ga wuməri ge *Peŋtikwet ti ndam ya təfəki ahàr ka Yezu ni tàŋgasvu ɗek ka məlaŋ bəlaŋani. ");
INSERT INTO muy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Eslini hʉya tìci daɗay ga zlam àhəndabiyu gwar e melefit bu akaɗa ga aməɗ ya ti akəzlay kay kay ni. Mək daɗay ni àhəndiyu a ahay ya ti nday tə̀vu manjəhaɗani ni vu ɗek. ");
INSERT INTO muy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Nday nakəŋ tìpi zlam ndahaŋ, zlam gani nday nani tamənjavu akaɗa arəɗ ga aku ni, tèdevu, tànjəhaɗki bəlaŋ bəlaŋ ka tay ɗek. ");
INSERT INTO muy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","*Məsuf Njəlatani èsliva a vu vu ana tay a ɗek. Eslini tə̀njəki ka mazlapani àna ma həma ndahaŋ gərgərani, ku way way do azlapay àna pakama ya ti Məsuf Njəlatani àɗəfiki ni. ");
INSERT INTO muy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ka sarta gani nani ndam *Zʉde ndahaŋ tə̀bu a Zerʉzalem, tawayay magray ere ye ti àɓəlafəŋ kè Melefit ni. Nday nani tàsləkabiya a kəsa gərgərani ba ka haɗ ga məlaŋ na ɗek. ");
INSERT INTO muy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tàra tìcia daɗay na ti tàŋgasvu ka ahar bəlaŋ. Eslini ku way way do e kiɗiŋ gatay bu èci zlapay àna ma həma gayaŋ, maslaŋa nahaŋ e kiɗiŋ ga ndam ga Yezu ni bu azlapay àna naŋ ni. Ere ye ti àgravu ni ti àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tə̀ɗəm ahkado : « Ere ye ti mici ni agravu ahəmamam ? Nday hini ya ti təzlapay ni nday ɗek ndam Gelili do aw ! ");
INSERT INTO muy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ay ti ku way way do e kiɗiŋ geli bu naŋ àbu eci nday tə̀bu təzlapay àna ma həma gayaŋ ni ti àgravu ahəmamam ? ");
INSERT INTO muy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","E kiɗiŋ geli bu ahalay ti mis tàsləkabiya a kəsa gərgərani ba kay : mis ndahaŋ tàsləkabiya a Part a, ndahaŋ e Medi, ndahaŋ e Elam, ndahaŋ keti a Mezopotami, ka haɗ *Zʉde, a Kapados, a Poŋ, a Azi, ");
INSERT INTO muy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","e Firizi, e Pemfili, e Ezip a, mis ndahaŋ ti ni tàsləkabiya ka haɗ Libi gwar e Sireŋ, akaba a Rom a. ");
INSERT INTO muy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Mis ndahaŋ e kiɗiŋ geli bu ndam Zʉde, ndahaŋ ti ni tìgi ndam Zʉde migeni. Ndam Kret akaba ndam Arabi tə̀bu e kiɗiŋ geli bu daya. Ay ti ku way way do e kiɗiŋ geli bu eci ere ye ti ndam nday nani təzlapay ni àna ma həma gayaŋ. Nday tə̀bu təɗəmki ma ka zlam sulumani ya Melefit àgray ni. » ");
INSERT INTO muy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nahkay zlam gani àhəliaba ahàr ana tay a, tə̀sər ere ye ti tagray ni do. Nahkay tə̀ɗəm e kiɗiŋ gatay bu ahkado : « Ere hini ya agravu ni ti awayay aɗəmvaba mam ? » ");
INSERT INTO muy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mis ndahaŋ ti ni tèyefiŋ kà ma gani, tə̀ɗəm : « Nday ya ti təzlapay nahkay ni ti zum àkaɗkaba tay a. » ");
INSERT INTO muy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eslini Piyer ècikaba akaba ndam *asak ndahaŋ kru mahar bəlaŋani na, àhi ma ana mis ya ti tə̀bu eslini ni. Àzlapay kay kay, àɗəm : « Lekʉlʉm ndam *Zʉde akaba lekʉlʉm ya ti kanjəhaɗum a Zerʉzalem ni ɗek, bumi slimi ana ma goro ya nəhi ana kʉli ni : ahàr àɗəm kicʉm ere ye ti agravu ni lala. ");
INSERT INTO muy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Lekʉlʉm kə̀ɗəmum bi zum àbu akaɗ nday ndani zla tək, aha ! Nahkay do ; njemdi ambəlmbu ya ge miledʉ mba timey ! ");
INSERT INTO muy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nihi ti pakama ga bay mahəŋgaray pakama ge Melefit Zʉwel ya àɗəm ahaslani ni àbu agravu sawaŋ. Àɗəm ahkado : ");
INSERT INTO muy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Melefit àɗəm : Ka sarta ga mandav ga məlaŋ wuɗak nahəma, anəbəkiaya Məsuf goro àki ke mis a ɗek. Nahkay bəza gekʉli zawalani akaba walani atəhəŋgri ma goro ana mis ; dagwá gekʉli etipi zlam ya ti mis tìpi ɗay-ɗay ndo ni ; medewél gekʉli day kisim emiziɗekivu ka tay kay. ");
INSERT INTO muy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Iy nahkay, ka sarta gani nani anəbəkiaya Məsuf goro ka ndam məgru tʉwi zawalani akaba walana ɗek, mək atəhəŋgri pakama goro ana mis. ");
INSERT INTO muy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eslini anagray zlam ya ti mis tìpi ɗay-ɗay ndo ni kay agavəla akaba ka haɗ : mis etipi mimiz, aku akaba azək dʉl-dʉl. ");
INSERT INTO muy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Fat amaslaɗay va do, emigi ləvəŋ ; kiyi day emigi ndizeni akaɗa mimiz. Zlam gani nani amagrava nahəma, vaɗ ga Bay geli ara wuɗak. ");
INSERT INTO muy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eslini ti ku way way do àzala slimi ga Bay geli a ti Melefit amahəŋgay naŋ.”  » ");
INSERT INTO muy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyer àhi ana tay keti, àɗəm : « Ndam *Izireyel, bumi slimi ana ma goro ya ti nəhi ana kʉli ni. Lekʉlʉm ɗek kə̀səruma, Yezu zal Nazaret ni ti Melefit àɗəfiki ana kʉli ti àzaba naŋ ga məgri tʉwi gayaŋ a. Àɗafaki ti àna magray tʉwi gərgərani kay ya mis tìpi ɗay-ɗay ndo, àvi ana Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Maslaŋa gani nani ti zlam àgrakiva akaɗa ge Melefit ya ti àɗəm ahaslani na, aɗaba Melefit ti àsəra zlam ya amagravu na ɗek. Lekʉlʉm kìjiŋʉma naŋ a àna məgəsi naŋ ana ndam ya tə̀gəskabu ma ge Melefit do na, ti tâkaɗfəŋ naŋ kà təndal. ");
INSERT INTO muy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ay Yezu àra àməta nahkay ti Melefit àhəŋgaraba naŋ a, àzaba naŋ a daliya ge kisim ni ba. Melefit àgray nahkay ti mə̀səra njəɗa ge kisim ni àhəca ga məgəs Yezu a. ");
INSERT INTO muy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nahkay Devit àɗəmkia ma a wakita ba, àɗəm ahkado : “Nìpia Bay Melefit goro kəlavaɗ ka ma goro a, naŋ àbu ka ahar ga ɗaf kà gəvay goro ti nə̀gəgər ba. ");
INSERT INTO muy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nahkay məɓəruv goro amər dal-dal, nidi limis àna məmərani daya. A vu goro bu ɗek nə̀səra Melefit amara məgru sulum gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bay goro Melefit, nə̀səra akəmbrəŋ nu e kisim bu do ; ti mis gayak *njəlatani ezi ti, akavay divi gani do. ");
INSERT INTO muy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kə̀ɗəfukia divi ya ti nəŋgət sifa àna naŋ na ; anəmərvu dal-dal aɗaba nak kə̀bu akaba nu.”  » ");
INSERT INTO muy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyer naŋ àbu aɗəmoru ma gayaŋ ni nahkay ti àhi ana tay ahkado : « Bəza ga mmawa, ahàr àɗəm nəhi ma gani ana kʉli vay-vay : bəŋ ga bəŋ geli Devit ti àməta, tìleba naŋ a àndava. Ku kani nəŋgu ni mindiviŋ gayaŋ àbu a kəsa geli bu. ");
INSERT INTO muy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ay Devit ti naŋ bay məhəŋgri *pakama ge Melefit ana mis. Àsəra Melefit àmbaɗia, àhi ahkado : “Biliŋ e kiɗiŋ ga bəza huɗ gayak bu aməzum bay gayak.” ");
INSERT INTO muy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nahkay wuɗaka ere gani agravu ti àsəra : àsəra *Krist *Bay gəɗakani ya amara ni aməmət mək amaŋgaba e kisim ba. Àra àsəra ti àɗəmki ma ke Krist, àɗəm : “Melefit àmbrəŋ naŋ e kisim bu ndo, vu gayaŋ èzi ndo daya.” ");
INSERT INTO muy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","« Yaw Yezu gani ya ti nəzlapiki ana kʉli ni ti Melefit àhəŋgaraba naŋ e kisim ba. Leli ndahaŋ ni ɗek magray sedi gani tata. ");
INSERT INTO muy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bəŋani Melefit àzoru naŋ agavəla, àfəkaɗ naŋ kà ahar ga ɗaf gayaŋ, mək àvi Məsuf gayaŋ Njəlatani akaɗa gayaŋ ya ti àhi ahaslani ni. *Məsuf Njəlatani gani nani ti Yezu àbəkia ke leli a. Nahkay ere ye ti kipʉm akaba kicʉm ni ti tʉwi gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit ti Melefit àzoru naŋ e melefit vu ndo. Naŋ naŋani àna ahàr gayaŋ àɗəm : “Bay geli Melefit àhi ana bay goro : Njəhaɗa gwar kà ahar ga ɗaf goro a, a məlaŋ ga gəɗakani va. ");
INSERT INTO muy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ndam ezir gayak ti anabəhaɗ tay kè meleher gayak akaɗa ga zlam ga bay ya abəki asak ni, ti kə̂cəlki ka tay.” ");
INSERT INTO muy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","« Nahkay ahàr àɗəm lekʉlʉm ndam Izireyel ɗek kə̂sərum lala zlam gani ge jiri : Yezu gani ya kə̀kaɗum naŋ àna *madarfəŋ naŋ kà təndal nahəma, naŋ Bay gəɗakani ya Melefit àslərbiyu ni, Melefit àdaba naŋ a, ègia Krist a. » ");
INSERT INTO muy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nday nakəŋ tàra tìcia ma ge Piyer na ti ɓəruv àtikaba ana tay a. Eslini tìhindifiŋa kè Piyer a akaba ndam asak ndahaŋ na, tə̀ɗəm : « Bəza ga mmawa, nihi ti magray ahəmamam ? » ");
INSERT INTO muy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyer àhəŋgarfəŋ, àhi ana tay ahkado : « Mbatumkaba majalay ahàr gekʉli a, ku way way do *tâbaray naŋ àna *slimi ga Yezu Krist. Nahkay ti Melefit ambərfəŋa zlam magudarani gekʉli ni kè kʉli a. Aməvi Məsuf Njəlatani gayaŋ ana kʉli daya. ");
INSERT INTO muy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ere gani nani ti Melefit àɗəm aməvi ana kʉli akaba ana bəza gekʉli. Aməvi ana ndam ya tə̀biyu driŋ ni daya. Bay Melefit geli aməvi ana mis ya ti amazalakabu tay ni ɗek. » ");
INSERT INTO muy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Eslini Piyer àhi ma ndahaŋ gəgərani ana tay kay, awayay ti təgəsiki. Àhi ana tay : « Gəsumkabá ti Melefit mâhəŋgay kʉli, sləkumkiba ka ndam magudar zlam ye e hini vu na ! » ");
INSERT INTO muy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Eslini mis ndahaŋ kay e kiɗiŋ gatay bu tə̀gəskabá ma ge Piyer na. Tàra tə̀gəskabá ma gayaŋ na ti ndam asak ni tàbaray tay. Ka fat gani nani mis agray dəbu mahkər tə̀hurkiviya àkiva ka ndam məfəki ahàr ka Yezu na. ");
INSERT INTO muy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ndam məfəki ahàr ka Yezu ni ɗek tə̀bu tici ere ye ti ndam *asak təcahi ana tay ni kəlavaɗ ; tə̀bu təcakalavu ka ahar bəlaŋ, tə̀bu təzumkabu zlam ka ahar bəlaŋ, tə̀bu tahəŋgalay Melefit ka ahar bəlaŋ daya. ");
INSERT INTO muy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ndam asak ni tə̀bu tagray zlam gərgəri kay ya mis tìpi ɗay-ɗay ndo ni àna njəɗa ge Melefit. Nahkay mis ni ɗek aŋgwaz awər tay. ");
INSERT INTO muy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ndam məfəki ahàr ka Yezu ni ɗek tanjəhaɗ ka ahar bəlaŋ, zlam gatay day ɗek mebeɗekabani ka ahar bəlaŋ. ");
INSERT INTO muy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Təsəkumoru vədaŋ gatay akaba zlam gatay ndahaŋ gərgərani ; tedevu siŋgu gani, ku way way do tədi ka wudəra gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kəlavaɗ nday tə̀bu təcakalavu a dalaka ga *ahay gəɗakani ge Melefit ni bu ka ahar bəlaŋ. A magam day tə̀bu təzumkabu zlam ka ahar bəlaŋ. Nday tə̀bu təzumkabu zlam nahkay ti àna huɗ bəlaŋ àna məmərani. ");
INSERT INTO muy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tə̀bu tazləbay Melefit kəlavaɗ daya. Nahkay ere ye ti tagray ni ɗek àɓəlafəŋ kè mis ɗek. Eslini Bay geli ahəŋgakivu mis ndahaŋ kəlavaɗ, abəkiviyu tay ka ndam məfəki ahàr ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ga məlafat a vaɗ nahaŋ àna njemdi mahkər nahəma, ata Piyer nday ata Zeŋ tə̀bu takoru a *ahay gəɗakani ge Melefit ni vu ga mahəŋgalay Melefit, aɗaba sarta gani ènjia. ");
INSERT INTO muy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Zal nahaŋ àbu manjəhaɗani kà gəvay ga ahay gəɗakani ge Melefit ni, kà mahay ya ti təzalay Mahay Maɓəlani ni. Zal nani ti tìwieya naŋ dərana, àsawaɗay koksah. Kəlavaɗ mis təzoru naŋ, tafəkaɗ naŋ eslini ga mahəŋgalafəŋa zlam kè mis ya təhuriyu a ahay gəɗakani ge Melefit ni vu na. ");
INSERT INTO muy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Naŋ nakəŋ àra èpia ata Piyer nday ata Zeŋ a tawayay təhuriyu a ahay gəɗakani ni vu ti, àhəŋgalafəŋa zlam kà tay a. ");
INSERT INTO muy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ata Piyer nday ata Zeŋ tàra tìcia ma gayaŋ na ti tə̀bəki eri ndekwa ndekwa, mək Piyer àhi ahkado : « Mənjaləŋ kè leli ! » ");
INSERT INTO muy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nahkay zal nakəŋ àmənjaləŋ kà tay lala, aɗaba àhi ana ahàr ara aŋgətfəŋa zlam kà tay a. ");
INSERT INTO muy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ay ti Piyer àhi ahkado : « Siŋgu àfu bi, gru day àfu bi, ay ere ye ti àfu ni ti nəvuk : àna *slimi ga Yezu *Krist zal Nazaret ni ti cikaba, kâsawaɗay ! » ");
INSERT INTO muy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Àra àhia ma na nahkay ti àgəs ahar ga ɗaf ga zal dəra ni ga mezefteba naŋ a. Piyer àra àgəs ahar gayaŋ na ti asak ga zal dəra ni tìgia njaŋ-njaŋana hʉya. ");
INSERT INTO muy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nahkay zal dəra ni ècikaba cəkwaɗ mək àsawaɗay. Eslini naŋ nakəŋ àhuriyu a dalaka ga ahay gəɗakani ge Melefit ni vu nday akaba ata Piyer nday ata Zeŋ. Ka ya ti ahuriyu a dalaka ni vu ni ti ahəroru agavəla, azləboru Melefit hihi. ");
INSERT INTO muy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ka ya ti naŋ àbu asawaɗay, azləbay Melefit nahkay ni ti mis ye eslini ni ɗek tìpia naŋ a. ");
INSERT INTO muy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tàra tìpia naŋ a ti tə̀səra naŋ a lala : naŋ zal ya ti ànjəhaɗ kà gəvay ga ahay gəɗakani ge Melefit ni kà mahay ya təzalay Mahay Maɓəlani ni, naŋ ya àhəŋgalafəŋa zlam kè mis a ni. Tàra tə̀səra naŋ a, tìpia ere ye ti àgrakivu na ti, àgria ejep ana tay a, àsia aŋgwaz ana tay a dal-dal daya. ");
INSERT INTO muy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Eslini zal nakəŋ àsləkafəŋa kà ata Piyer nday ata Zeŋ a do. Nahkay mis ni ɗek tàcuhwakioru ka tay, tèveliŋ tay aɗaba ere ya tìpi ni àgria ejep ana tay a dal-dal. Nday a dalahay ya təzalay Dalahay ga Salomoŋ ni bu. ");
INSERT INTO muy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piyer àra èpia mis na nahkay ti àhi ma ana tay, àɗəm ahkado : « Ndam *Izireyel, ere ye ti àgravu ni ti kəgrum ejep gani ti kamam ? Kəmənjumləŋ ana leli nahkay ti kamam ? Kə̀humi ana ahàr leli màhəŋgaraba zal hina ti àna njəɗa geli geleni aw ? Tək day ti kə̀humi ana ahàr Melefit àhəŋgaraba naŋ a ti aɗaba leli màɓəlafəŋ kà naŋ palam aw ? ");
INSERT INTO muy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Melefit ti naŋ Melefit ga Abraham, Melefit ga Izak, Melefit ge Zekʉp, Melefit ga ata bəŋ geli ɗek. Naŋ gani àgray ti zal hini mâŋgaba aɗaba awayay ti mis tâzləbay Yezu bay məgri tʉwi ni. Ay lekʉlʉm ti kə̀gəsumi naŋ ana ndam ga ŋgumna, mək ka ya ti Pilet awayay afəkaɗ naŋ ni ti kə̀humi àfəkaɗ naŋ ba. ");
INSERT INTO muy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lekʉlʉm kàwayum ti tâfəkaɗi Bay *njəlatani jireni ni ana kʉli ndo ; kàwayuma ti tâfəkaɗi maslaŋa ya ti àbazl mis ni ana kʉli sawaŋ. ");
INSERT INTO muy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yezu ti naŋ Bay məvi sifa ana mis ni, ay tàkaɗ naŋ ti ka mawayay gekʉli. Tàra tàkaɗa naŋ a ti Melefit àhəŋgaraba naŋ e kisim ba. Àhəŋgaraba naŋ a ti leli mìpia, magray sedi gani. ");
INSERT INTO muy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Leli ti məfəki ahàr ka Yezu, magray tʉwi àna slimi gayaŋ, aɗaba naŋ ti njəɗa àfəŋ. Yezu awayay ti mis tâzləbay naŋ, nahkay àhəŋgaraba zal hina. Lekʉlʉm ɗek kə̀səruma zal hina, kìpʉma ere ye ti àgrakivu na. Iy, zal hini ègi njalaŋ-njalaŋani kè meleher gekʉli ti aɗaba leli mə̀fəkia ahàr ka Yezu a. ");
INSERT INTO muy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","« Bəza ga mmawa, nə̀səra ere ye ti kə̀grumi ana Yezu lekʉlʉm akaba gəɗákani gekʉli na kə̀grum ti aɗaba kə̀sərum Yezu naŋ way ndo palam. ");
INSERT INTO muy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ay kwa ahaslani Melefit àhibiya ana ndam mahəŋgaray *pakama gayaŋ na ɗek, ahàr àɗəm *Krist acakay daliya kwa, mək nday day tə̀hi pakama gani ana mis. Pakama ge Melefit nani ya àɗəmki ke Krist ni àgrava eɗeɗiŋ a. ");
INSERT INTO muy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ègia nahkay ti mbatumkaba majalay ahàr gekʉli a, dəguma afa ge Melefit a. Nahkay ti ambərfəŋa zlam magudarani gekʉli ni kè kʉli a. ");
INSERT INTO muy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Bay geli aməvi sarta ga məpəsabana ana kʉli, aməsləribiyu Yezu *Bay gəɗakani ya amara ni ana kʉli. Yezu ti Melefit àdiaba naŋ ana kʉli a kwa ahaslana. ");
INSERT INTO muy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ahàr àɗəm mânjəhaɗ a huɗ melefit bu hayaŋ duk abivoru ana sarta ya ti Melefit amagraya zlam a ɗek mʉwena ni kwa. Kwa ahaslani Melefit àhibiya pakama gana ana ndam njəlatani ya tàhəŋgaray pakama gayaŋ na, nday day tə̀hi pakama gani ana mis. ");
INSERT INTO muy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nahkay kwa ahaslani Mʉwiz àhi ana ndam Izireyel ahkado : “Bay Melefit aməsləribiyu bay mahəŋgaray *pakama gayaŋ nahaŋ ana kʉli akaɗa nu. Bay nani ti amələbu bəlaŋ e kiɗiŋ ga bəza ga məŋ gekʉli bu. Pakama gayaŋ ya aməhi ana kʉli ni ɗek ti akəbumi slimi lala. ");
INSERT INTO muy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Maslaŋa ya ti aməbi slimi do ni ti ahàr àɗəm tâgaraba naŋ e kiɗiŋ ga ndam ge Melefit ba, tâkaɗ naŋ.” ");
INSERT INTO muy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ndam mahəŋgaray pakama ge Melefit ni ɗek tə̀ɗəmkibiyu ma ka zlam ya àgravu ka sarta geli na. Ànjəki kwa ke Semiyel, àbivoru ana nday ndahaŋ ya tàhəŋgaray pakama ge Melefit ni ɗek. ");
INSERT INTO muy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pakama ge Melefit ya ndam mahəŋgaray pakama gayaŋ tə̀ɗəmbiya, Melefit àɗəm anagray zlam ni ti, àgria zlam gana ana kʉli eɗeɗiŋ a. Lekʉlʉm day ja gekʉli àkibu ka pakama ya ti Melefit *àwəlkabu akaba ga ata bəŋ ga bəŋ gekʉli ni. Melefit àhi ana Abraham ahkado : “Anəgri sulum goro ana jiba gərgərani ga haɗ ni ɗek. Anəgri ana tay ti àna bəza huɗ gayak.” ");
INSERT INTO muy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bay məgri tʉwi ana Melefit ya Mʉwiz àɗəmkibiyu ma ni ti, Melefit àŋgazliaya naŋ ana kʉli a enjia. Àsləribiyu naŋ ana kʉli ti mə̂gri sulum gayaŋ ana kʉli akaba ti mə̂mbatikaba majalay ahàr magədavani na ana kʉli a ɗek. » ");
INSERT INTO muy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ka ya ti ata Piyer ata Zeŋ tə̀bu təzlapi ana mis nahkay ni ti ndam *maŋgalabakabu mis akaba Melefit ni akaba bay ga ndam majəgay *ahay gəɗakani ge Melefit ni akaba ndam *Sedʉseyeŋ ni tə̀rəkia ka tay a. ");
INSERT INTO muy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nday nakəŋ tə̀zumkia ɓəruv ka ndam *asak ga Yezu cʉeni na aɗaba nday tə̀bu təcahi zlam ana mis, tə̀hi ana tay Yezu àŋgaba e kisim ba, mis taŋgaba e kisim ba tata daya. ");
INSERT INTO muy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eslini tə̀ɗəm tə̂gəs ndam asak cʉeni ni, tə̂biyu tay a daŋgay vu, aɗaba məlakarawa ègia, sarta àbi ga magrafəŋa seriya kà tay a bi. Nahkay tə̀gəs tay, tə̀biyu tay a daŋgay ni vu, tàndəhaɗviyu hundum. ");
INSERT INTO muy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ay ti mis dal-dal e kiɗiŋ ge mis ya tìci pakama ga ndam asak ni bu tə̀fəkia ahàr ka Yezu a. Nahkay ndam məfəki ahàr ka Yezu ni tə̀sagakivu, nday ɗekeni tàgray mis dəbu zlam. ");
INSERT INTO muy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hajəŋ gani zla nahəma, bəbay ga ndam *Zʉde akaba gəɗákani gatay akaba ndam *məsər Wakita ge Melefit ni tə̀cakalavu a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","E kiɗiŋ gatay nani bu nahəma, Anna naŋ gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni, Kayif, Zeŋ, Eleksender, akaba ndam ga huɗ ahay ga ndam gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni ɗek. ");
INSERT INTO muy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nday nakəŋ tàra tə̀cakalava nahkay nahəma, tə̀həlbiyu ata Piyer ata Zeŋ kè meleher gatay. Tàra tìnjia àna tay a ti nday nakəŋ tìhindifiŋa ma kà tay a, tə̀hi ana tay ahkado : « Kàhəŋgarumaba mis a ti àna njəɗa ga way ? Way àvi divi gani ana kʉli way ? » ");
INSERT INTO muy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Eslini njəɗa ga *Məsuf Njəlatani èsliva a vu vu ana Piyer a, mək àhəŋgrifəŋ ana tay, àɗəm : « Lekʉlʉm bəbay akaba lekʉlʉm gəɗákani ni, ");
INSERT INTO muy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","kìhindʉmfiŋa ma kè leli a àki ka zlam sulumani ya mə̀gri ana zal dəra ni, kə̀ɗəmum ahəmamam màhəŋgaraba naŋ a ni mam ? ");
INSERT INTO muy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tamal kìhindʉmfiŋa kè leli a nahkay nahəma, lekʉlʉm ɗek akaba ndam *Izireyel ɗek sərumki : maslaŋa ya àŋgaba, naŋ hi kè meleher gekʉli ni ti, màhəŋgaraba naŋ a ti àna *slimi ga Yezu *Krist zal Nazaret, aɗaba naŋ ti njəɗa àfəŋ. Naŋ gani ti lekʉlʉm kàdarumfəŋa kà təndal a àməta, ay ti Melefit àhəŋgaraba naŋ e kisim ba. ");
INSERT INTO muy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yezu ti Melefit àɗəmkia ma a Wakita gayaŋ ni ba. Ma ge Melefit ya àɗəmki ni ti nihi : “Akur nahaŋ àbu ti lekʉlʉm ndam mələm ahay kàwayum magray tʉwi àna naŋ ndo. Ay ti akur gani nani ègia akur ya akay ahay na ɗek sawaŋ.” ");
INSERT INTO muy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","« Melefit ahəŋgay mis ti si àna naŋ kwa ; do ni ti àdaba maslaŋa nahaŋ a duniya ba ga mahəŋgay mis àna naŋ a ndo. » ");
INSERT INTO muy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ndam magray seriya ni tàra tìcia pakama ga ata Piyer ata Zeŋ na ti, àgria ejep ana tay a, aɗaba tìpi ti nday mis nahkay, tə̀cahay zlam ndo daya. Tə̀səra tay a nday ndam ya tàɗəbay Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ay ti tìpi maslaŋa ya àŋgaba ni naŋ jika kà gəvay gatay nahəma, tə̀ŋgət ma ga məhəŋgrifəŋani ana tay ndo. ");
INSERT INTO muy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tə̀sər ere ye ti təhəŋgrifəŋ ana tay ni va do ni ti, tə̀ɗəm tə̂həliyu tay e mite vu. Tàra tə̀həlaya tay a ti ndam magray seriya ni tə̀zlapay e kiɗiŋ gatay bu, ");
INSERT INTO muy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","tə̀ɗəm ahkado : « Məgri mam ana tay mam ? Ndam Zerʉzalem ɗek tə̀səra nday tàgra ere ya mis tìpi ɗay-ɗay ndo ni kè eri ge mis a ɗek. Nahkay ŋgay tàgray ndo ni ti mə̀ɗəm koksah. ");
INSERT INTO muy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mawayay ti pakama gani òru kama va ba nahəma, məcumfəŋa tay kà macali slimi ana maslaŋa nana. Ku way way do tə̀hi ma gani ba ; tamal tə̀hia ana maslaŋa ti amatraɓ tay. » ");
INSERT INTO muy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tàra tìndeveriŋa zlapay gatay na ti tə̀zalay ata Piyer nday ata Zeŋ, tə̀ləgi ana tay, tə̀hi ana tay ahkado : « Kàcalumi slimi ana Yezu ba, kàcahumi zlam ana mis àna *slimi ga Yezu ba daya. » ");
INSERT INTO muy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Eslini ata Piyer ata Zeŋ tə̀həŋgrifəŋ ana tay, tə̀ɗəm : « Zlam jireni kè meleher ge Melefit ti, məgəsiki ma ana Melefit tək məgəsiki ma ana kʉli sawaŋ aw ? Lekʉlʉm lekʉlʉmeni dʉmkaba ma gana. ");
INSERT INTO muy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Leli ti mìsliki məmbrəŋ məhi ere ye ti mìpi akaba mìci ni ana mis koksah. » ");
INSERT INTO muy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ndam magray seriya nakəŋ tə̀ləgi ana tay keti, mək tə̀mbrəŋ tay. Nday gani tə̀ŋgət divi ga matraɓ tay ndo, aɗaba ndam ga kəsa ni ɗek tə̀bu tazləbay Melefit azuhva ere ye ti àgravu ni. ");
INSERT INTO muy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Maslaŋa ya ti tàhəŋgaraba naŋ a, àgri ejep ana mis ni ti vi gayaŋ àtama vi kru kru faɗana. ");
INSERT INTO muy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba gəɗákani ndahaŋ ni tàra tə̀mbrəŋa ata Piyer ata Zeŋ a ti, ata Piyer ata Zeŋ nakəŋ tə̀rəkioru ka ndam gatay, mək tàŋgəhaɗi ma ga ndam ge seriya ya tə̀hi ana tay ni ɗek ana tay. ");
INSERT INTO muy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tàra tìcia ma gatay na ti ndam məfəki ahàr ka Yezu ni ɗek ma gatay bəlaŋ, tàhəŋgalay Melefit, tə̀ɗəm ahkado : « Bay geli, bay ya ti àgraya huɗ melefit a, haɗ a, dəluv gəɗakana akaba zlam gatayana ɗek ni ti nak. ");
INSERT INTO muy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nak kàgray ti bəŋ geli Devit bay məgruk tʉwi ni mâzlapay àna njəɗa ga *Məsuf Njəlatani ni. Devit àɗəm : “Ndam ga haɗ gərgərani tagray zlabay ti kamam ? Jiba gərgərani təɗəgəzlki ahàr ka zlam masakani ti kamam ? ");
INSERT INTO muy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bəbay gəɗákani ga haɗ ni tə̀wəlva ga makaɗvana, bəbay ndahaŋ ni day tə̀cakalava ka ahar bəlaŋ, nday ɗekeni tawayay takaɗfəŋva kà Bay geli akaba *Krist Bay gayaŋ ya àdaba ni.” ");
INSERT INTO muy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","« Nahkay bay *Erot akaba Pons Pilet tə̀cakalava eɗeɗiŋ a kəsa hini ba akaba ndam ga haɗ ndahaŋ akaba ndam jiba Izireyel a. Tə̀cakalavu ti àkivu ka Yezu Bay njəlatani ya agruk tʉwi ni, naŋ Krist Bay ya kàdaba ni. ");
INSERT INTO muy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tàgray nahkay ti tàgra ere ye ti nak kawayay na ɗek. Kwa ahaslani kə̀ɗəmbiyu àna njəɗa gayak amagravu. ");
INSERT INTO muy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nihi ti tə̀ɗəm atatraɓ leli nahəma, nak Bay geli bi slimi ana pakama gatay ni lala. Vi njəɗa ana leli ndam məgruk tʉwi ni ga məhi pakama gayak ana mis, aŋgwaz àwər leli ba. ");
INSERT INTO muy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ŋgazli njəɗa gayak ana mis, həŋgaraba mis a, gray zlam gərgərani ya mis tìpi ɗay-ɗay ndo ni àna slimi ga Yezu Bay njəlatani ya agruk tʉwi ni ti. » ");
INSERT INTO muy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tàra tìndeveriŋa mahəŋgalay Melefit a ti məlaŋ gatay ya tə̀cakalavu eslini ni àdaɗay, Məsuf Njəlatani àvikivu njəɗa ana tay dal-dal, mək nday nakəŋ tə̀ɗəmoru ma ge Melefit vay-vay, aŋgwaz àwər tay ndo. ");
INSERT INTO muy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ndam məfəki ahàr ka Yezu ni nday ɗek akaɗa mis bəlaŋ, majalay ahàr gatay bəlaŋ, məɓəruv gatay day bəlaŋ. Nahkay maslaŋa ya ti aɗəm zlam gayaŋ ni gayaŋ gayaŋani ti àbi. Zlam gatay ni ɗek tèbeɗekabu ka ahar bəlaŋ sawaŋ. ");
INSERT INTO muy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Melefit àvi njəɗa dal-dal ana ndam *asak ga Yezu ga məɗəmoru pakama àki ka Bay geli Yezu, gayaŋ ya àmət mək àŋgaba e kisim ba ni. Melefit àgri sulum gayaŋ dal-dal ana tay daya. ");
INSERT INTO muy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","E kiɗiŋ ga ndam məfəki ahàr ka Yezu ni bu ni, maslaŋa ya ti araŋa àhəci naŋ ti àbi. Aɗaba ndam ya ti vədaŋ gatay tə̀bu ahkay do ni ahay gatay tə̀bu ni tə̀səkumoru tay, mək tə̀həlbiyu siŋgu gani, ");
INSERT INTO muy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tàbəhaɗ afa ga ndam asak ga Yezu ni. Tàbəhaɗa ti ku way way do ere ye ti àhəci naŋ ni ti tədi ga wudəra gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Zal nahaŋ àbu, slimi gani Zʉzef, zal *Levi, tìwi naŋ e Sipir. Ndam asak ga Yezu təzalay naŋ Barnabas, awayay aɗəmvaba « Maslaŋa ya avi njəɗa ana mis ni. » ");
INSERT INTO muy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Zal nani àsəkumoru vədaŋ gayaŋ, mək àhəlbiyu siŋgu gani, àbəhaɗ afa ga ndam asak ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Zal nahaŋ àbu slimi gani Ananiyas, slimi ga wal gani ti ni Safira. Àsəkumoru vədaŋ gayaŋ, wal gani ni day àwayikia. ");
INSERT INTO muy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Àra àsəkumoya ti àdafəŋa siŋgu gana wal gayaŋ ni day àgəsikia, mək àhəlbiyu məgəjəni gani, àbəhaɗ afa ga ndam *asak ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Àra àbəhaɗa siŋgu na ti Piyer àhi : « Ananiyas, *Seteni àhurukviyu a məɓəruv vu ti kamam ? Kàsəkaɗia malfaɗa ana Məsuf Njəlatana, kadafəŋa siŋgu ga vədaŋ ya kə̀səkumoru na. ");
INSERT INTO muy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Vədaŋ ya kə̀səkumoru ni ti gayak, siŋgu ya kə̀ŋgət àna naŋ ni gayak daya do aw ? Kàjalaki ahàr ka magray zlam nahkay hi ti kamam ? Malfaɗa ya kàsəkaɗ ni ti kàsəkaɗi ana mis hihirikeni do, kàsəkaɗi ti ana Melefit. » ");
INSERT INTO muy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiyas nakəŋ àra ècia ma ge Piyer na ti àzum mədəɗani məmətani kwiyah-kwiyah. Mis ɗek ya tìcia ere ye ti àgrakivu na ti aŋgwaz àwəra tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Eslini bəza dagwa tàzay kisim gani, tàkambah, mək tòru tìli. ");
INSERT INTO muy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Agray njemdi mahkər kələŋ gani nahəma, wal gani àra. Wal ni àsər ere ye ti àgrakivu ka zal gayaŋ ni do. ");
INSERT INTO muy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyer àhi ahkado : « Siŋgu ya kə̀ŋgətum àna vədaŋ ni ti nahkay hi eɗeɗiŋ aw ? » Wal ni àhəŋgrifəŋ, àhi : « Iy nahkay gani eɗeɗiŋ. » ");
INSERT INTO muy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piyer àhi : « Kə̀ɗəmum kəgosum Məsuf ga Bay geli ti ahəmamam ? Bay slimi, ndam ya ti tìli kisim ga zal gayak ni nday tə̀bu a mahay bu tahəraya. Tara tazay kisim gayak, takoru tili daya. » ");
INSERT INTO muy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Piyer àra àhia ma nahkay ti wal ni àzum mədəɗani məmətani kwiyah-kwiyah kè meleher ge Piyer hʉya. Eslini bəza dagwa ni tàhəraya, tə̀di ahàr ana kisim gani mək tàzay, tòru tìlifiŋiyu kà gəvay ga zal gani ni. ");
INSERT INTO muy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ndam məfəki ahàr ka Yezu ni akaba mis ndahaŋ ya tìcia ere ya àgravu na ti nday ɗek tàgra aŋgwaz a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ka sarta nani ti ndam *asak ga Yezu ni tàgray zlam ya ti mis tìpi ɗay-ɗay ndo ni kay kè meleher ge mis. Zlam nday nani àɗəfiki njəɗa ge Melefit ana mis. Ndam məfəki ahàr ka Yezu ni ɗek tə̀bu təcakalavu ka ahar bəlaŋ a dalaka ga *ahay gəɗakani ge Melefit ni bu kəlavaɗ. Təcakalavu ti a dalahay ya təzalay Dalahay ga Salomoŋ ni bu ni. ");
INSERT INTO muy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mis ndahaŋ ya tə̀fəki ahàr ka Yezu ndo ni tagray aŋgwaz ga məhurkiviyani ka tay. Akaba nani ɗek mis tə̀bu tacalfəŋ kà ndam məfəki ahàr ka Yezu ni, tə̀ɗəm nday ndam sulumani. ");
INSERT INTO muy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kəlavaɗ mis ndahaŋ təsagakivu dal-dal, zawal akaba wál, tə̀fəki ahàr ka Bay geli Yezu, tə̀hurkiviyu ka ndam məfəki ahàr ndahaŋ ni. ");
INSERT INTO muy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nahkay mis tə̀həlbiyu ndam gatay ya tèɓesey do ni e mite vu, tàbəhaɗ ndahaŋ ka slalah, ndahaŋ ka hətav. Tə̀ɗəm bi ka ya ti Piyer akoru gwar eslini ni ti diksi gayaŋ ni asləkakia ka ndam gatay ndahaŋ ya tèɓesey do na ga mahəŋgaraba tay a. ");
INSERT INTO muy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mis dal-dal ga kəsa ndahaŋ ya kà gəvay ga Zerʉzalem ni day tə̀həlbiyu ndam gatay ya tèɓesey do ni akaba ya ti seteni tə̀niviyu ana tay a ahàr vu, tə̀gri daliya ana tay ni. Ndam ya tə̀həlbiyu tay ni ɗek tàŋgaba. ");
INSERT INTO muy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nahkay gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni akaba ndam gayaŋ ndahaŋ ndam *Sedʉseyeŋ ni tìzirey ndam *asak ga Yezu ni, tə̀zumkia ɓəruv ka tay a dal-dal, tə̀ɗəm si tə̂gri zlam ana tay kwa. ");
INSERT INTO muy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eslini tə̀gəs ndam asak ga Yezu ni mək tə̀biyu tay a daŋgay vu kè eri ge mis ɗek. ");
INSERT INTO muy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Məlavaɗ àra ègikia ka tay a ahay ga daŋgay ni ba ti, *məslər ge Melefit àzləkaba mahay ga daŋgay na ɗek, àbaya ndam asak ga Yezu na, mək àhi ana tay : ");
INSERT INTO muy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","« Dəgum a dalaka ga *ahay gəɗakani ge Melefit ni vu, kəhumi pakama ga sifa mʉweni ni ɗek ana mis. » ");
INSERT INTO muy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nday nakəŋ tə̀gəsikia ma gayaŋ ya àhi ana tay na. Dʉ ge miledʉ tòru a dalaka ga ahay gəɗakani ni vu, tə̀njəki ka macahi zlam ana mis. Nday tə̀bu təcahi zlam ana mis ti gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni tìnjia ka məlaŋ magray seriya na akaba ndam gayaŋ a. Tàra tìnjia ti tə̀zalakabu gəɗákani ga ndam *Izireyel ga magray seriya. Nahkay tə̀sləroru mis ga moru məhəlbiyu ndam asak ga Yezu ya tə̀biyu tay a daŋgay vu ni. ");
INSERT INTO muy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nday nakəŋ tòru tìnjʉa a ahay ga daŋgay ni va ti tə̀diviyu ahàr ana tay ndo. Nahkay tàsləkabiya, tàŋgəhaɗi ma gani ana ndam ge seriya ni. ");
INSERT INTO muy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tə̀hi ana tay ahkado : « Mòru mìnjʉa ti mə̀di ahàr ana mahay ga daŋgay ni ɗek məzləkvani lala, ndam majəgay mahay ni ɗek nday jika jika kà mahay ni. Ay ka ya ti màra mə̀zləkaba mahay na ti mə̀diviyu ahàr ana maslaŋa ndo. » ");
INSERT INTO muy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Bay ga ndam majəgay ahay gəɗakani ge Melefit ni akaba gəɗákani ga ndam maŋgalabakabu mis akaba Melefit ni tàra tìcia ma na nahkay ti tə̀sər ere ye ti tagray ni do. Tə̀ɗəm ahkado : « Nihi ti məŋ ga mam àgravu ni mam ? » ");
INSERT INTO muy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nday tə̀bu təzlapay nahkay ti maslaŋa nahaŋ ènjiki tay, àhi ana tay ahkado : « Cʉm day ! Ndam ya ti kə̀bumiyu tay a daŋgay vu ni tə̀biyu təcahi zlam ana mis a dalaka ga ahay gəɗakani ge Melefit ni bu. » ");
INSERT INTO muy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bay ga ndam majəgay ahay ge Melefit ni àra ècia ma na nahkay ti tàsləka akaba ndam gayaŋ a ga məgəsbiyu ndam asak ni. Tòru tə̀gəs tay ti àna njəɗa do, aɗaba aŋgwaz àwərfəŋa tay kè mis na ; tə̀ɗəm : « Bi mis ni etizligi leli àna akur. » ");
INSERT INTO muy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tàra tə̀gəsbiya tay a ti tàbəhaɗ tay kè meleher ga ndam magray seriya ni, mək gəɗakani ga ndam maŋgalabakabu mis akaba Melefit ni àləgi ana tay, ");
INSERT INTO muy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","àhi ana tay ahkado : « Mə̀hia ana kʉli a kàcahumi zlam ana mis àna slimi ga zal nani ba simiteni ti, ay nihi ti lekʉlʉm kàcahumia ma na ana ndam Zerʉzalem a ɗek. Nahkay ti kawayum mis tə̂ɗəm màkaɗ naŋ ti leli zla do aw ! » ");
INSERT INTO muy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Eslini Piyer akaba ndam asak ndahaŋ ni tàhəŋgarfəŋ, tə̀ɗəm : « Ahàr àɗəm tîciiki ma ana Melefit mâtama ya ticiiki ma ana mis na. ");
INSERT INTO muy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Melefit ga ata bəŋ ga bəŋ geli ni àhəŋgaraba Yezu e kisim ba, naŋ ya ti lekʉlʉm kə̀kaɗum naŋ àna *madarfəŋ naŋ kà təndal ni. ");
INSERT INTO muy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Àra àhəŋgaraba naŋ a ti àzoru naŋ agavəla, àfəkaɗ naŋ kà ahar ga ɗaf gayaŋ ka məlaŋ ga gəɗakani ni. Melefit àgray ti Yezu nakəŋ mîgi Bay ge mis ɗek akaba Bay mahəŋgay mis ɗek. Awayay ti ndam Izireyel tâmbatkaba majalay ahàr gatay a ti mə̂mbərfəŋa zlam magudarani gatay na kà tay azuhva Yezu a. ");
INSERT INTO muy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Leli mə̀səra zlam gani nday nani àgrava eɗeɗiŋ a, magray sedi gani tata. *Məsuf Njəlatani agray sedi gani daya, Melefit àvia Məsuf gani nana ana ndam ya təgəsiki ma na. » ");
INSERT INTO muy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ndam magray seriya ni tàra tìcia ma ga ndam asak ga Yezu na ti, tə̀zumkia ɓəruv ka tay a dal-dal, tawayay mabazl tay. ");
INSERT INTO muy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ay ti zal Feriziyeŋ nahaŋ àvu e kiɗiŋ gatay bu slimi gani Gemeliyel, naŋ bay məsər Wakita ge Melefit. Mis ɗek təgəs ma gayaŋ. Eslini naŋ nakəŋ ècikaba jik e kiɗiŋ ga ndam magray seriya ni ba, àɗəm tə̂həliyu ndam asak ni e mite vu day. ");
INSERT INTO muy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tàra tə̀həliya tay a ti naŋ nakəŋ àhi ana ndam magray seriya ni ahkado : « Ndam Izireyel, ɗəgəzlumki ahàr lala ka zlam ya ti mara məgrumi ana ndam nday nani ni. ");
INSERT INTO muy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nə̀ɗəm nahkay ti aɗaba àpəsa vi a ɓal Tewdas àhəraya àɗəm naŋ gəɗakani. Nahkay mis àgray diŋ diŋ faɗ tàɗəba naŋ a. Ay tàra tàkaɗa naŋ a ti ndam gayaŋ ya tàɗəbay naŋ ni ɗek tèdeva, pakama gani àndav nahkay. ");
INSERT INTO muy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kələŋ gayaŋ ka sarta ga macal mis nahəma, Zʉdas zal Gelili ni àhəraya, àhəla mis a dal-dal tàɗəba naŋ a. Naŋ day tàra tàkaɗ naŋ a ti ndam ya tàɗəbay naŋ ni ɗek tèdeva. ");
INSERT INTO muy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nihi ti nəhi ana kʉli nahəma, kìdʉmi slimi ana ndam nday nani va ba, mbrəŋum tay tâsləka. Tigi ti ere ye ti tawayay ni akaba tagray ni tʉwi ge mis hihirikeni nahəma, emebesvu ka ahàr gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ay tigi ti tʉwi ni tʉwi ge Melefit nahəma, ekislʉmki mebeskabana koksah. Kàtəkarum mebeskabana ba, do ni ti bi akəkaɗumfəŋva ti kè Melefit. » Àra àhia ana tay a nahkay ti nday nakəŋ tə̀gəskabá pakama gayaŋ na. ");
INSERT INTO muy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Nahkay tə̀zaliyu ndam asak ni a ahay vu keti, tə̀zləɓ tay mək tə̀ləgi ana tay, tə̀hi ana tay ahkado : « Kàcalumi slimi ana Yezu va ba. » Kələŋ gani tə̀mbrəŋ tay, ti tâsləka. ");
INSERT INTO muy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nahkay ndam asak nakəŋ tàsləka àna məmərana. Tə̀ɗəm Melefit àvi divi gani ana tay ti tə̂cakay daliya azuhva slimi ga Yezu ti aɗafaki ti nday tàɓəlafəŋa kè Melefit a. ");
INSERT INTO muy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nahkay kəlavaɗ nday nakəŋ tə̀bu təcahi zlam ana mis a dalaka ga ahay gəɗakani ge Melefit ni bu akaba a ahay ge mis bu. Tə̀hi *Ma Mʉweni Sulumani ana mis, tə̀ɗəm Krist *Bay gəɗakani ya amara ni ti Yezu. ");
INSERT INTO muy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nahkay ndam maɗəbay divi ga Yezu təsagakivu. Ka sarta gani nani ti nday ya ti təɗəm ma Gres ni tìcivu akaba nday ya ti təɗəm ma *Hebri ni do. Ndam ya təɗəm ma Gres ni tə̀ɗəm ka ya ti kəlavaɗ tidi zlam ana wál madakway ni ti tàmənjaləŋ ka wál madakway gatay do. ");
INSERT INTO muy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ndam *asak ga Yezu kru mahar cʉeni ni tàra tìcia ma gatay na ti tə̀zalakabu ndam maɗəbay divi ga Yezu ni ɗek, mək tə̀hi ana tay ahkado : « Tamal leli ndam asak ni mə̀mbrəŋa məɗəm ma ge Melefit a, midi zlam ana mis ti, àɓəlay do. ");
INSERT INTO muy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nihi nahəma, bəza ga məŋ geli ni, dumaba zawal adəskəla e kiɗiŋ gekʉli ba. Ahàr àɗəm nday nani ti mis tə̀səra tay a nday mis sulumani, *Məsuf ge Melefit àniviyu ana tay dal-dal, tə̀səra majalay ahàr sulumana. Akədumaba tay a nahəma, aməvi tʉwi ge midi zlam ana mis ana tay. ");
INSERT INTO muy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nahkay leli ti ni amazay sarta geli ɗek ga mahəŋgalay Melefit akaba ga məhi ma gayaŋ ana mis. » ");
INSERT INTO muy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ndam məfəki ahàr ka Yezu ni tàra tìcia ma gatay na ti tə̀gəskabá. Nahkay tə̀daba Etiyeŋ a ; naŋ àfəkia ahàr ka Yezu a dal-dal akaba *Məsuf Njəlatani àniviyu dal-dal daya. Tə̀daba Filip, Prokwar, Nikanor, Timoŋ, Parmenas akaba Nikolas a. Nikolas ti tìwi naŋ a Antiyos ; ègi zal Zʉde migeni. ");
INSERT INTO muy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tə̀daba tay a nahəma, tə̀həlbiyu tay afa ga ndam asak ni. Ndam asak ni tàhəŋgali Melefit ana tay, mək tə̀bəki *ahar ka tay ti Melefit mə̂gri sulum gayaŋ ana tay. ");
INSERT INTO muy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ka sarta nani mis kay tə̀gəskabá pakama ge Melefit ya àɗəmki ka Yezu na, nahkay ndam Zerʉzalem ya taɗəbay divi ga Yezu ni tə̀sagakiva dal-dal. Ndam *maŋgalabakabu mis akaba Melefit ni dal-dal tə̀gəskabá ga məfəki ahàr ka Yezu a daya. ");
INSERT INTO muy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiyeŋ ti Melefit àgria sulum gayaŋ a, àvia njəɗa dal-dal. Nahkay agray ere ye ti mis tìpi ɗay-ɗay ndo ni àna njəɗa dal-dal, agri ejep ana mis. ");
INSERT INTO muy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Etiyeŋ naŋ àbu agray nahkay ti mis ndahaŋ tə̀cələŋ ma. Nday gani nani ti ndam ga ahay ga *mahəŋgalavù Melefit ya təzalay « Ahay ga ndam ya tə̀həlaya tay e eviɗi ba ni. » Nday gani ndam ga kəsa Sireŋ akaba ga kəsa Eleksendri akaba ndam ga haɗ Silisi akaba ga haɗ Azi : tə̀bu tagray gejewi akaba Etiyeŋ. ");
INSERT INTO muy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tə̀bu tagray gejewi ti Etiyeŋ àwəlkia tay ka ma aɗaba àtama tay àna majalay ahàr sulumani ya *Məsuf Njəlatani àvi na. ");
INSERT INTO muy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Àra àwəlkia tay ka ma ti nday nakəŋ tə̀səkum mis ndahaŋ ti tə̂ɗəm : « Leli mìcifiŋa naŋ àbu endivi Mʉwiz akaba endivi Melefit. » ");
INSERT INTO muy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nahkay ndam ezir ge Etiyeŋ nakəŋ tə̀bikivu estena ana ndam Zerʉzalem akaba gəɗákani gatay akaba ndam *məsər Wakita ge Melefit ni mək tàdəgaki ke Etiyeŋ nakəŋ cip, tə̀zoru naŋ kè meleher ga gəɗákani ya tagray seriya ni. ");
INSERT INTO muy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tə̀həl ndam ndahaŋ ga masəkaɗki malfaɗa daya. Ndam malfaɗa ni tə̀ɗəm ahkado : « Maslaŋa hini ti naŋ àbu aɗəmki ma magədavani ka *ahay njəlatani ge Melefit ni akaba ke *Divi gayaŋ ya Mʉwiz àbəki ni, àmbrəŋ do. ");
INSERT INTO muy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Leli mìcifiŋa àɗəm ahkado Yezu zal Nazaret ni ara embeɗkaba ahay gəɗakani ge Melefit na, ara ambatkaba Divi ya Mʉwiz àɗəfiki ana leli na daya. » ");
INSERT INTO muy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Eslini ndam ya tə̀vu manjəhaɗani a ahay ge seriya ni bu ni ɗek tamənjaləŋ ke Etiyeŋ nakəŋ ndekwa ndekwa. Tìpi ti meleher gayaŋ ni ègia akaɗa meleher ga *məslər ge Melefit a. ");
INSERT INTO muy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Eslini gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni èhindifiŋa ma kè Etiyeŋ a, àhi ahkado : « Ma ya ti mis tə̀ɗəmkuk ni ti jiri eɗeɗiŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiyeŋ nakəŋ àhəŋgarfəŋ, àɗəm : « Ata baba akaba bəza ga mmawa goro ni, bumu slimi day. Melefit naŋ ya ti leli ɗek mə̀bu mazləbay ni àŋgazlivu ana bəŋ ga bəŋ geli Abraham. Àŋgazlivu ti ka ya ti naŋ ka haɗ Mezopotami, òru ànjəhaɗ ka haɗ Haraŋ faŋ ndo ni. ");
INSERT INTO muy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Àhi : “Mbərbu haɗ gayak akaba ndam gayak, ru ka haɗ ya ti anəɗəfukki ni.” ");
INSERT INTO muy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nahkay Abraham nakəŋ àsləka ka haɗ ga ndam Selde a, òru ànjəhaɗ ka haɗ Haraŋ. Bəŋ ga Abraham àmət eslini. Bəŋani àra àməta ti Melefit àhi ana Abraham mâsləka a Haraŋ a, mâra mânjəhaɗ ka haɗ hini ya lekʉlʉm kə̀kumki ni. ");
INSERT INTO muy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Abraham àra ènjia ka haɗ hina ti Melefit àsi haɗ ndo. Ku məlaŋ gʉzit ga micikiani tekeɗi àsi ndo. Ku nahkay nəŋgu ni, àhi : “Anəvuk haɗ ni ɗek, kə̀məta day haɗ ni emigi ga bəza huɗ gayak.” Ay ka ya ti Melefit àhi ma nani ana Abraham ni ti, Abraham èwi wur faŋ ndo. ");
INSERT INTO muy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pakama ge Melefit ya àhi ni naŋ hi, àhi : “Bəza huɗ gayak atoru tanjəhaɗ ka haɗ ge mis ndahaŋ ; etinjʉa eslina ti etigi eviɗi, atəgri daliya ana tay vi diŋ diŋ faɗ. ");
INSERT INTO muy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ay ti anatraɓ ndam ya ti bəza huɗ gayak atəgri eviɗi ana tay ni. Kələŋ gani bəza huɗ gayak ni atasləka ka haɗ nana, mək atazləbay nu ka məlaŋ hini.” ");
INSERT INTO muy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Melefit àra àhia pakama na ana Abraham a nahkay nahəma, àwəlkabu pakama gayaŋ akaba ga Abraham àna *mekeley kʉɗi. Abraham àra èwia Izak a, wur ni àgra vaɗ a azlalahkər nahəma èkeli kʉɗi. Nahkay day Izak àra èweya Zekʉp a ti èkeli kʉɗi. Zekʉp day àra èweya ata bəŋ ga jiba geli kru mahar cʉeni na ti èkeli kʉɗi ana tay. ");
INSERT INTO muy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","« Kələŋ gani ata bəŋ ga jiba geli ni tàgrafəŋa solu kà wur ga məŋ gatay Zʉzef a. Nahkay tə̀səkumioru naŋ ana ndam ndahaŋ, mək ndam nday nani tòru àna naŋ ka haɗ Ezip. Ay ti Melefit naŋ àbu akaba naŋ ; ");
INSERT INTO muy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","àzaba naŋ a huɗ ga daliya gayaŋ ya àgray ni ba ɗek. Melefit àvia majalay ahàr sulumana daya, nahkay ti ègia awəlawa ga *Faroŋ bay ge Ezip na. Nahkay bay Faroŋ nakəŋ àfiyu naŋ bay məgur haɗ gayaŋ ni ɗek akaba huɗ ahay gayaŋ ni ɗek. ");
INSERT INTO muy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Eslini lʉwir àdaya ka haɗ Ezip a ɗek akaba ka haɗ Kanaŋ a. Lʉwir àra àdaya nahkay ti, mis tàgra daliya dal-dal ; ata bəŋ ga jiba geli ya ka haɗ Kanaŋ ni tə̀ŋgət zlam məzumani va do. ");
INSERT INTO muy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Zekʉp àra ècia *alkama àbu ka haɗ Ezip nahəma, àsləroru bəza gayaŋ ata bəŋ ga bəŋ geli ga məsəkumbiyu alkama. ");
INSERT INTO muy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka ya ti àsləroru tay ye cʉ nahəma, Zʉzef àɗəfi vu gayaŋ ana bəza ga məŋani ni. Nahkay Faroŋ àra àsəra jiba ge Zʉzef a. ");
INSERT INTO muy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Eslini Zʉzef àsləroru mis ti tə̂zibiya bəŋani Zekʉp akaba ndam gayaŋ a. Nday ɗekeni kru kru adəskəla mahar zlam. ");
INSERT INTO muy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nahkay Zekʉp nakəŋ òru ka haɗ Ezip mək àmət eslini. Ata bəŋ ga jiba geli day tə̀mət eslini. ");
INSERT INTO muy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tàra tə̀məta ti tə̀həlbiyu kisim gatay e Sihem mək tə̀biyu e mindiviŋ ga Abraham ni vu. Mindiviŋ nani ti Abraham asəkumfəŋa kà bəza ga Hamor e Sihem àna gru a. ");
INSERT INTO muy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","« Yaw sarta ya Melefit agray ere ye ti àhi ana Abraham amagray ni enjia wuɗak nahəma, ndam *Izireyel ni tə̀sagakiva, tìgia nday kay ka haɗ Ezip a. ");
INSERT INTO muy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ka sarta gani nani ti tə̀fiya bay nahaŋ ka haɗ Ezip a. Bay nani ti àsər Zʉzef ndo. ");
INSERT INTO muy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nahkay naŋ nakəŋ àgosay ata bəŋ ga bəŋ geli, àgria daliya ana tay a, àhi ana tay si tâboru bəza gatay ya ka ahar ni tə̂mət. ");
INSERT INTO muy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ka sarta gani nani tìweya Mʉwiz a, naŋ ti Melefit àwaya naŋ a dal-dal. Ànjəhaɗ kiyi mahkər a magam afa ga ata bəŋani. ");
INSERT INTO muy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kələŋ gani tìzligoru naŋ. Tàra tìzligoya naŋ a ti wur dahalay wur ga Faroŋ bay ga haɗ Ezip àdi ahàr mək àzay naŋ, àgal naŋ akaɗa wur ga huɗ gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nahkay ti tə̀cahi məsər zlam ga ndam Ezip ni ɗek. Pakama gayaŋ ya aɗəm ni ɗek mis təgəskabu, tʉwi gayaŋ ya agray ni day àɓəlafəŋ kè mis. ");
INSERT INTO muy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","« Àra àgra vi a kru kru faɗ nahəma, àɗəm : “Nakoru nəmənjiyu bəza ga mmawa goro ndam Izireyel kwa.” ");
INSERT INTO muy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Àra ènjia ti èpi zal Ezip nahaŋ agri daliya àna zal Izireyel. Eslini naŋ nakəŋ èmbikivu ka maslaŋa ya ti təgri daliya ni mək àkaɗ zal Ezip ni ka duwa gani. ");
INSERT INTO muy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Àgray nahkay ti awayay ti aɗəfiki ana bəza ga məŋani ni ti tə̂sər Melefit amahəŋgay tay ti àna naŋ, ay ti nday gani tə̀səriki ndo. ");
INSERT INTO muy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Hajəŋ gani nahəma, Mʉwiz nakəŋ àdi ahàr ana ndam Izireyel ndahaŋ cʉ, tə̀bu takaɗvu ; naŋ nakəŋ awayay aŋgalabakabu tay. Àhi ana tay : “Ndam goro ni, lekʉlʉm kà məŋ gekʉli ti, kihirʉmvu ti kamam ?” ");
INSERT INTO muy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ay naŋ ya ti agri daliya ana naŋ nahaŋ ni àhi ana Mʉwiz ahkado : “Way àfiyu kur bay magrafəŋa seriya kè leli a way ? ");
INSERT INTO muy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kawayay kəkaɗ nu akaɗa ya kə̀kaɗ zal Ezip nahaŋ eweni ni aw ?” ");
INSERT INTO muy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mʉwiz àra ècia ma nana nahəma, àcuhway ka haɗ Ezip, òru ka haɗ Madiyaŋ, ànjəhaɗ eslini. Naŋ àbu eslini, àra àda wal a ti, èwifiŋa bəza zawalana cʉ. ");
INSERT INTO muy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","« Àra àgra vi kru kru faɗ ka ahàr gana nahəma, òru a huɗ gili vu kà həma *Sinayi. Eslini ti *məslər ge Melefit àŋgazlivu a huɗ ga aku ya agəs məŋgəhaf ni bu. ");
INSERT INTO muy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mʉwiz nakəŋ àra èpia ti àgria ejep a, nahkay awayay ahəɗakfəŋoru ti mîpi lala. Naŋ àbu ahəɗakfəŋoru ti èci dəŋgu ga Bay geli, ahi ahkado ");
INSERT INTO muy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nu ti Melefit ga ata buk Abraham, Izak akaba Zekʉp.” Mʉwiz àra ècia ma na ti aŋgwaz àwəra naŋ a dal-dal, àgəgəra, mamənjaləŋani nakəŋ tekeɗi èsliki ndo hʉya. ");
INSERT INTO muy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Eslini Bay geli àhi ma keti, àhi ahkado : “Həlaba kimaka gayak a asak ba, aɗaba məlaŋ ya kìcikvù ni ti məlaŋ *njəlatani. ");
INSERT INTO muy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nìpia lala ahəmamam təgri daliya ana ndam goro ka haɗ Ezip na, nìcia tuway gatay a : nahkay nàra ti ga mahəŋgaya tay a. Nihi nak ti ru, nəsləroru kur ka haɗ Ezip.” ");
INSERT INTO muy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","« Mʉwiz ti naŋ ya ti ndam Izireyel tàwayay naŋ ndo, tə̀hi ahkado : “Way àfiyu kur bay magrafəŋa seriya kè leli a way ?” ni. Ay naŋ ti Melefit àslərikaboru naŋ ana tay ti mîgi bay gatay, mîgi bay məhəlaba tay e eviɗi ba daya. Melefit àslərikaboru Mʉwiz ana tay nahkay ti, àhi ma gani ti məslər ge Melefit ya àŋgazlivu a huɗ ga məŋgəhaf ni bu ni. ");
INSERT INTO muy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Bay ya ti àhəlaba ndam Izireyel ka haɗ Ezip a ni ti nani Mʉwiz. Àhəlaba tay a ti àna magray zlam magray ejep ya mis tìpi ɗay-ɗay ndo ni kay : àgray ka haɗ Ezip, kà Dəluv Ndizeni, akaba ka ya ti nday a huɗ gili bu vi kru kru faɗani ni. ");
INSERT INTO muy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Bay ya ti àhi ana ndam Izireyel : “Melefit aməsləribiyu wur ga məŋ gekʉli nahaŋ ana kʉli ga mahəŋgaray pakama ge Melefit akaɗa goro ni” ti Mʉwiz gani. ");
INSERT INTO muy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ka ya ti ndam Izireyel tə̀cakalavu a huɗ gili bu ni ti, bay ya ti èci ma ga məslər ge Melefit kà həma Sinayi mək àhəŋgri ana ata bəŋ geli ni ti Mʉwiz gani. Bay ya ti Melefit àhi pakama ya avi sifa ana mis ga məhəŋgriani ana leli ni ti naŋ gani. ");
INSERT INTO muy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ay ti ata bəŋ geli ni tìciiki ma ndo, tàwayay maɗəbay naŋ ndo. A majalay ahàr gatay bu ni ti tàwaya maŋgona e Ezip a. ");
INSERT INTO muy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tə̀hi ana *Aroŋ ahkado : “Griaya melefit ndahaŋ ana leli ga mədi kama ana leli a, aɗaba Mʉwiz naŋ ya àhəlababiya leli ka haɗ Ezip a ni ti, mə̀sər ere ye ti àgrakivu ni do.” ");
INSERT INTO muy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nahkay nday nakəŋ tə̀vəɗaya wur sla mək tìsliŋi zlam ana wur sla ni, ègia pəra gatay a. Tə̀gri wuməri àna məmərani ana zlam ya nday ndayani tə̀vəɗaya àna ahar gatay a ni. ");
INSERT INTO muy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tàgra nahkay ti Melefit day àmbrəŋ tay ti tə̂gri pəra ana zlam ya ti a huɗ melefit bu ni. Ma gani hini àbu məbəkiani a wakita ga ndam mahəŋgaray *pakama ge Melefit bu nahkay hi : “Ndam Izireyel, ka ya ti lekʉlʉm kə̀bum a huɗ gili bu vi kru kru faɗ ni ti, kìsliŋʉmi zlam akaba kə̀grumi sədaga ti, ana nu aw ? ");
INSERT INTO muy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aha, ana nu do ! Ahay miviceni ya kàsawaɗum àna naŋ ni ti ahay ga Molok, do ni ti goro do. Kàsawaɗuma àna pəra gekʉli Refeŋ ya tə̀zavu ata boŋgur na daya. Pəra nday nani ti kə̀grumaya ga məhəŋgrioru ahàr ana haɗ ana tay a. Gekʉli ya kə̀grum nahkay ni ti anagaroru kʉli driŋ kama ga Babiloŋ.” ");
INSERT INTO muy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","« Ka ya ti ata bəŋ ga bəŋ geli tə̀bu a huɗ gili bu ni ti tə̀sawaɗa àna zlam ge mivicey ahay ge Melefit àna naŋ a. Mazavu ga ahay gani nani ti Melefit àɗəfikia ana Mʉwiz a mək àhi mâgraya akaɗa gayaŋ ya èpi na. ");
INSERT INTO muy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ahay gani nani ti ata bəŋ ga bəŋ geli tə̀mbribu ana bəza gatay ; bəza gatay ni day tàra àna naŋ ka haɗ hina, Zezʉwi àdi kama ana tay. Tàra tìnjia ti Melefit àgariaba ndam ga haɗ hina ana tay a, mək nday nakəŋ tànjəhaɗ. Nahkay nday tə̀bu àna ahay ge Melefit *miviceni ni duk àbivoru ana sarta ge Devit. ");
INSERT INTO muy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devit ti Melefit àwaya naŋ a dal-dal, nahkay èhindifiŋa divi kè Melefit ga maslamali məlaŋ *njəlatani ana bəza huɗ ge Zekʉp a. ");
INSERT INTO muy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ay maslaŋa ya ti àra àləm ahay ge Melefit ni ti Salomoŋ. ");
INSERT INTO muy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ku tamal àləma nahkay nəŋgu ni, Bay Melefit agavəla driŋ, ànjəhaɗvù a ahay ya mis tə̀ləmi ni bu do. Nahkay zla nahəma maslaŋa nahaŋ àbu, àhəŋgaray pakama ge Melefit, àɗəm : ");
INSERT INTO muy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Bay Melefit àɗəm : Məlaŋ manjəhaɗ goro ti huɗ melefit, məlaŋ məbəki asak goro ti ni haɗ. Ahay weley lekʉlʉm kislʉmki mələmuana ana nu a ni weley ? Məlaŋ goro ya ananjəhaɗ, nə̀pəsaba ni ti weley ? ");
INSERT INTO muy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bay ya àgraya zlam nana ɗek ni ti nu nuani àna ahar goro do aw ?”  » ");
INSERT INTO muy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Etiyeŋ àhi ana tay keti : « Lekʉlʉm ti kìcʉm slimi do eɗeɗiŋ ! Lekʉlʉm ti məɓəruv gekʉli magədavani, slimi gekʉli məzləkvani ; lekʉlʉm akaɗa ndam ya tèkeli kʉɗi ana tay ndo ni ! Lekʉlʉm akaɗa ga ata bəŋ ga bəŋ gekʉli ni, kekileŋa kə̀gəsumkabu pakama ga *Məsuf Njəlatani ni do ! ");
INSERT INTO muy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bay mahəŋgaray *pakama ge Melefit ya ti ata bəŋ ga bəŋ gekʉli tə̀gri daliya ndo ni ti weley ? Nday gani tàbazla ndam mahəŋgaray pakama ge Melefit ya tə̀ɗəm Bay ge Jiri amara ni. Bay ge Jiri nakəŋ àra ènjia ti kə̀səkumoya naŋ a mək kə̀kaɗuma naŋ a. ");
INSERT INTO muy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Lekʉlʉm ti məslər ge Melefit tə̀ɗəfikia *Divi ge Melefit na ana kʉli a, ay ti kə̀bumi slimi ana Divi gani do. » ");
INSERT INTO muy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ndam magray seriya ni tàra tìcia ma ge Etiyeŋ na ti tə̀zumki ɓəruv dal-dal, tàhəpəɗ ahar tasl tasl. ");
INSERT INTO muy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ay Etiyeŋ ti *Məsuf Njəlatani èsliva a vu va dal-dal, àmənjoru e melefit vu, èpi məlaŋ maslaɗani ge Melefit akaba Yezu naŋ jika kà ahar ga ɗaf ge Melefit. ");
INSERT INTO muy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Àra èpia ti àɗəm ahkado : « Cʉm day, nə̀bu nipi huɗ melefit məzləkvabana, nipi *Wur ge Mis naŋ jika kà ahar ga ɗaf ge Melefit daya. » ");
INSERT INTO muy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ge Etiyeŋ ya naŋ àbu azlapay nahkay ni ti nday nakəŋ tə̀zlah kay kay, tə̀bəviyu ahar e slimi vu der der, mək nday ɗek tàdəgaki ka ahar bəlaŋ, ");
INSERT INTO muy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","tə̀gəs naŋ, tə̀zaba naŋ a kəsa ba cak. Tàra tàsləkafəŋa àna naŋ kà kəsa na nahkay ti tawayay tizligi naŋ àna akur ga makaɗ naŋ. Ndam sedi ya tìci pakama gayaŋ ni tə̀həlkaba məgudi gatay na, tàbəhaɗfəŋ kà wur dagwa nahaŋ slimi gani Sol ti mâjəgaki. Mək tìzligi Etiyeŋ nakəŋ. ");
INSERT INTO muy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ka ya ti tizligi Etiyeŋ ni ti Etiyeŋ àhəŋgalay Yezu, àɗəm : « Bay goro Yezu, za sifa goro a. » ");
INSERT INTO muy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kələŋ gani àbəhaɗ mirdim grik, àzlah kay kay, àɗəm : « Bay goro, kə̀wəl tay àna seriya àki ka zlam magudarani hini ya təgru ni ba. » Àra àɗəma ma na nahkay ti àmət hʉya. ");
INSERT INTO muy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tàkaɗ Etiyeŋ ti, Sol àwaya daya. Ka fat gani nani ti tə̀njəki ka məgri daliya dal-dal ana ndam məfəki ahàr ka Yezu ya a Zerʉzalem ni hʉya. Ndam məfəki ahàr ka Yezu ni ɗek tèdevu tòru a kəsa ciɓ-ciɓeni vu ka haɗ *Zʉde akaba ka haɗ Samari. Nday ya tàsləka ndo ni ti si ndam *asak ga Yezu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ndam ndahaŋ ya ti təhəŋgrioru ahàr a haɗ ana Melefit ni tìli Etiyeŋ, tìtʉwi naŋ dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sol ti àgria daliya dal-dal ana ndam məfəki ahàr ka Yezu a ; àsawaɗay kà mahay kà mahay, àgəs zawal akaba wál, àbiyu tay a daŋgay vu. ");
INSERT INTO muy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nday ya ti tèdevu ni tə̀ɗəmoru *Ma Mʉweni Sulumani kà kəsa kà kəsa. ");
INSERT INTO muy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ka sarta gani nani Filip òru a kəsa gəɗakani vu ka haɗ Samari, àhioru ma ge *Krist ana mis ye eslini ni. ");
INSERT INTO muy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nday nani ɗek ma gatay bəlaŋ, tə̀bi slimi lala ana ma ge Filip ya àhi ana tay ni, aɗaba tìcia pakama gayaŋ a, tìpia zlam ya ti àgray, mis tìpi ɗay-ɗay ndo na daya. ");
INSERT INTO muy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Àna zlam nday nani ya àgray ni ti seteni tə̀sləkiaba ana mis a dal-dal, tə̀zlah kay kay. Ndam dəra akaba ndam jʉgwer tìgia sənduɓ-sənduɓana daya. ");
INSERT INTO muy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eslini ndam ga kəsa nani tə̀mərva dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Maslaŋa nahaŋ àbu a kəsa nani bu, slimi gayaŋ Simu, naŋ zal maharam, agri ejep ana ndam ga haɗ *Samari ɗek. Àzay ahàr gayaŋ awayay mis ɗek tə̂ɗəm naŋ gəɗakani. ");
INSERT INTO muy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mis ni ɗek, ku bəza, ku mis gəɗákani tìciiki ma. Tə̀ɗəm : « Maslaŋa hini ti njəɗa ge Melefit àfəŋ. Njəɗa gani nani ti təɗəm “Gəɗakani.” » ");
INSERT INTO muy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Mis ni ticiiki ma dal-dal, aɗaba àpəsa naŋ àbu agri ejep ana tay àna maharam gayaŋ ni. ");
INSERT INTO muy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ay ka ya ti Filip àhia *Ma Mʉweni Sulumani àki ka *Məgur ge Melefit akaba ka Yezu Krist ana tay a nahəma, zawal akaba wál ni tə̀gəskabá ma ge Filip na, mək *tàbaray tay. ");
INSERT INTO muy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simu nakəŋ tekeɗi àgəskabá ma gana, tàbara naŋ a. Kələŋ gani ànjəhaɗ akaba Filip. Eslini Filip naŋ àbu agray zlam gəɗákani gəɗákani ya mis tìpi ɗay-ɗay ndo ni. Simu nakəŋ àra èpia ti àgria ejep a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ndam asak ga Yezu ya a Zerʉzalem ni tàra tìcia ndam *Samari tə̀gəskabá ma ge Melefit a ti, tə̀sləribiyu ata Piyer nday ata Zeŋ ana ndam Samari ni. ");
INSERT INTO muy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ata Piyer nday ata Zeŋ tàra tìnjia ti tàhəŋgalay Melefit ti mə̂vi *Məsuf Njəlatani ana ndam Samari ya tə̀gəskabá pakama ge Melefit a ni. ");
INSERT INTO muy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tàgray nahkay ti aɗaba ku mis bəlaŋ e kiɗiŋ gatay bu Məsuf Njəlatani àhərkiaya àhuriviyu faŋ ndo. *Tàbaray tay ti àna slimi ga Bay geli Yezu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nahkay ata Piyer nday ata Zeŋ tə̀bəki *ahar ka tay, mək Məsuf Njəlatani àhuriviyu ana tay. ");
INSERT INTO muy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simu nakəŋ àra èpia Məsuf Njəlatani ahuriviyu ana ndam məfəki ahàr ka Yezu ka ya ti ndam asak ga Yezu tə̀bəki ahar ka tay ni ti, awayay avi siŋgu ana ata Piyer nday ata Zeŋ. ");
INSERT INTO muy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Àhi ana tay ahkado : « Vumu njəɗa ti ka ya ti nəbəki *ahar ke mis ni ti Məsuf Njəlatani mə̂huriviyu ana tay. » ");
INSERT INTO muy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ay ti Piyer àhi ahkado : « Ahàr àɗəm siŋgu gayak ni mîjijia, nak nakani day kîjijia, aɗaba kə̀hi ana ahàr ere ye ti Melefit avi ana mis ni ti mis asəkum tata. ");
INSERT INTO muy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nak kə̀kibu ke tʉwi geli ya magray ni bi, ma gayak àkibu bi, aɗaba majalay ahàr gayak magədavani kè eri ge Melefit. ");
INSERT INTO muy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Mbatkaba majalay ahàr gayak magədavani na, həŋgalay Bay geli. Nahkay ti bi Melefit aməmbərfuka zlam ya kàgudar a majalay ahàr gayak bu na. ");
INSERT INTO muy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nə̀səra nihi ti məɓəruv gayak magədavani kè eri ge Melefit, nahkay kìgia eviɗi ga zlam magudarana. » ");
INSERT INTO muy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Eslini Simu nakəŋ àhəŋgrifəŋ, àhi ana tay ahkado : « Lekʉlʉm lekʉlʉmeni həŋgalumu Bay geli ti ere ye ti kə̀humu ni àgrakuvu ba simiteni ti ! » ");
INSERT INTO muy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ata Piyer ata Zeŋ tàra tàgrakia sedi ka Yezu a akaba tə̀hia pakama ga Bay geli ana mis a nahəma, tàŋgoru a Zerʉzalem. Ka ya ti nday tə̀bu takoru e divi bu ni ti tə̀hia Ma Mʉweni Sulumana ana mis a kəsa ndahaŋ ba kay ka haɗ *Samari a. ");
INSERT INTO muy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Məslər ga Bay geli àŋgazlivu ana Filip, àhi ahkado : « Ru gwar ka Mboku, ke divi ya ti asləkabiya a Zerʉzalem a, andoru ahàr a Gaza, mis tə̀ki tə̀sawaɗaki bi ni. » ");
INSERT INTO muy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filip nakəŋ ècik, àsləka hʉya. Naŋ ka ahàr divi nahəma, èpi zal nahaŋ manjəhaɗani digʉsa e seret bu, ejeŋgey wakita ge Izayi bay mahəŋgaray *pakama ge Melefit ni. Naŋ gani òru a Zerʉzalem ga mazləbay Melefit, nihi naŋ àbu asləkabiya ara a magam a. Zal nani ti zal Etiyʉpi, naŋ madaslani, naŋ mis gəɗakani agri tʉwi ana Kandas bay walani ge Etiyʉpi : naŋ gəɗakani ga ndam maŋgah elimeni ga bay ni. ");
INSERT INTO muy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","*Məsuf Njəlatani àhi ana Filip ahkado : « Ru kahəɗakfəŋiyu ke seret ni lala. » ");
INSERT INTO muy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eslini Filip nakəŋ àcuhworu. Òru ènjʉa nahəma, èci zal Etiyʉpi ni naŋ àbu ejeŋgey wakita ge Izayi bay mahəŋgaray pakama ge Melefit ni. Àhi ahkado : « Ere ye ti kejeŋgey ni ti nak kə̀bu kiciaba ma gana waw ? » ");
INSERT INTO muy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Naŋ nakəŋ àhəŋgrifəŋ, àhi ahkado : « Tamal maslaŋa àɗəfuaba ndo ni ti nîciaba ahəmamam ? » Mək àhi : « Cəlkuvaya ga manjəhaɗfu kà gəvay a. » ");
INSERT INTO muy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ka məlaŋ ya ejeŋgey ni Izayi àɗəm nahkay hi : « Naŋ ti àhəlkaba ma ndo, akaɗa ga təmbak ya təzoru ka məlaŋ misliŋ zlam ni, akaɗa ga wur təmbak ya tekelkia eŋgʉc a ti ètʉwi do ni. ");
INSERT INTO muy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Naŋ gani tàhəŋgoraya naŋ a haɗ a, tə̀gri seriya ge jiri ndo simiteni. Way amacali slimi mba way ? Aɗaba tàkaɗa naŋ a, naŋ àbi ka haɗ va bi ni. » ");
INSERT INTO muy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Gəɗakani nakəŋ àhi ana Filip ahkado : « Nahəŋgalay kur kam-kam, hu : bay mahəŋgaray pakama ge Melefit azlapaki ahalay ti ka way nani way ? Azlapaki ti àki ka naŋ naŋani tək, ka maslaŋa nahaŋ aw ? » ");
INSERT INTO muy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eslini Filip àhi ma, àɗəfiaba *Ma Mʉweni Sulumani àki ka Yezu a, ànjiki ka pakama ya naŋ àbu ejeŋgey ni. ");
INSERT INTO muy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Nday tə̀bu takoru nahkay ti tə̀di ahàr ana yam gweŋgʉr a. Eslini naŋ gəɗakani nakəŋ àhi ana Filip ahkado : « Yam nihi. Mam acafəŋa nu ga *məbaray nu a mam ? »  ");
INSERT INTO muy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip àhi ahkado : « Tamal kə̀fəkia ahàr gayak ɗek ka Yezu a ti tabaray kur tata. » Naŋ nakəŋ àhəŋgrifəŋ, àhi : « Nə̀fəkia ahàr ka Yezu *Krist a, naŋ Wur ge Melefit. » ");
INSERT INTO muy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Àhi ana bay ya agaray seret ni mîcika. Àra ècika àna seret na ti ata Filip nday ata naŋ gəɗakani nakəŋ tàhəraya tə̀huriyu a yam ni vu, mək Filip àbaray naŋ. ");
INSERT INTO muy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tàra tàhəraya a yam ni ba nahəma, Məsuf ga Bay geli àzafəŋa Filip a. Nahkay naŋ gəɗakani ni èpi naŋ va do, àsləka zlam gayaŋ àna məmərana. ");
INSERT INTO muy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip àsərki ti naŋ a Azot. Àru a Sezare ; naŋ àbu akoru ti àhioru Ma Mʉweni Sulumani ni ana mis kà kəsa kà kəsa ɗek duk a Sezare. ");
INSERT INTO muy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ka sarta gani nani nahəma, Sol naŋ àbu awayay agri daliya ana ndam maɗəbay divi ga Bay geli, awayay abazl tay. Nahkay òru afa ga gəɗakani ga ndam *maŋgalabakabu mis akaba Melefit ni, ");
INSERT INTO muy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","èhindifiŋa wakita ga medekiani ka gəɗákani ga ahay gərgərani a Damas ya tahəŋgalavù Melefit ni. Wakita nday nani ti tə̀via divi ga məgəs ndam maɗəbay divi ga Bay geli a. Ku adi ahàr ana zawal ahkay do ni ana wál, ba agəs tay, awəl tay, ahəlbiyu tay a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Naŋ nakəŋ àra àŋgəta wakita nday nana ti àdəvu e divi vu. Naŋ àbu enjiyu a Damas wuɗak nahəma, eslini maslaɗani àsləkabiya e melefit ba, àhərkiaya hʉya, àslaɗay məlaŋ gayaŋ nani. ");
INSERT INTO muy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Eslini naŋ nakəŋ àdəɗ a ga haɗ pəɗa mək èci dəŋgu ga maslaŋa nahaŋ àzalay naŋ, àhi : « Sol, Sol kəgru daliya ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Naŋ nakəŋ àhi : « Nak way, Bay goro ? » Mək àhəŋgrifəŋ, àhi : « Nu Yezu, nu ya kəgru daliya ni. ");
INSERT INTO muy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ay ti cicikaba, huriyu a kəsa vu. Ekinjʉa eslina ti atəhuk ere ye ti ahàr àɗəm kâgray kwa ni. » ");
INSERT INTO muy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndam ya tarakaboru akaba naŋ ni tìcik, ma tekeɗi tìsliki məɗəmani koksah. Tici dəŋgu ciliŋ, ay ti tìpi maslaŋa gani do. ");
INSERT INTO muy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol nakəŋ ècikaba, àhəlkaba eri a, ay ti èpi divi do. Ndam ya tarakaboru akaba naŋ ni tə̀dafəŋa ahar a, tə̀zoru naŋ a Damas. ");
INSERT INTO muy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Eslini àgray vaɗ mahkər, divi day èpi ndo, zlam day àzum ndo, yam day èsi ndo. ");
INSERT INTO muy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A Damas eslini ti zal nahaŋ àbu slimi gani Ananiyas, naŋ bay maɗəbay divi ga Yezu. Eslini Bay geli àzalay naŋ e kisim miziɗeni bu : « Ananiyas ! » Ananiyas nakəŋ àhəŋgrifəŋ, àhi : « Awi ! Nu hi, Bay goro ni. » ");
INSERT INTO muy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bay geli àhi ahkado : « Ru weceweci ke divi ya təzalay divi Ndəlaɓani ni, ru afa ga Zʉdas. Kìnjʉa ti kîhindi zal Tars ya təzalay naŋ Sol ni. Nihi ti naŋ àbiyu ahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Maslaŋa gani nani ti nə̀ɗəfikia maslaŋa nahaŋ a, slimi gani Ananiyas, ara afa gana mək abəki *ahar ti mîpi divi akaɗa ya ahaslani ni. » ");
INSERT INTO muy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas àhəŋgrifəŋ, àhi : « Bay goro ni, nìcia mis kay tə̀bu təzlapaki àki ka maslaŋa nani akaba ka zlam gayaŋ magədavani ya àgri ana ndam gayak *njəlatani ya tə̀bu a Zerʉzalem na. ");
INSERT INTO muy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Àra ahalay a ti gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni tə̀vibiya divi ga məgəs ndam ya ti tazləbay kur na ɗek. » ");
INSERT INTO muy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ay ti Bay geli Yezu àhəŋgrifəŋ, àhi ahkado : « Nak ru, aɗaba nə̀zaba maslaŋa gana nana, ti mə̂gru tʉwi : mə̂hioru slimi goro ana mis ga haɗ ndahaŋ akaba bəbay gatayani ni, mə̂hioru ana ndam *Izireyel daya. ");
INSERT INTO muy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Amacakay daliya kay azuhva slimi goro ; nu nuani anəɗəfiki daliya ya ara agray ni ɗek. » ");
INSERT INTO muy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nahkay Ananiyas nakəŋ òru. Òru ènjʉa ti àhuriyu a ahay ni vu, àbəki ahar ka Sol nakəŋ mək àhi ahkado : « Sol wur ga mmawa, Bay geli Yezu, naŋ ya àŋgazlukvu ka ahàr divi ka sarta ya kara ni, àslərbiyu nu. Awayay ti kîpi divi akaɗa ya ahaslani ni, awayay ti *Məsuf Njəlatani mîslʉkvu a vu vu daya. » ");
INSERT INTO muy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Naŋ àbu azlapi nahkay ti zlam ndahaŋ akaɗa aləŋ ge kilif tə̀sləkikia ke eri ana Sol nakəŋ a. Eslini èpi divi akaɗa ya ahaslani ni keti. Nahkay ècikaba, mək *tàbaray naŋ àna *slimi ga Yezu. ");
INSERT INTO muy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kələŋ gani àzum zlam, mək njəɗa gayaŋ àŋgiva. Sol ànjəhaɗiyu vaɗ ɓal a Damas afa ga ndam ya taɗəbay divi ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ka ya ti naŋ àbu eslini ni ti ànjəki ke tʉwi hʉya, àhuriya a ahay gərgərani ga ndam *Zʉde ya *tahəŋgalavù Melefit ni va, àhi ana mis Yezu ti naŋ Wur ge Melefit. ");
INSERT INTO muy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma gayaŋ ya àɗəm ni àgria ejep ana mis ya tə̀bi slimi na ɗek. Tə̀ɗəm ahkado : « Naŋ hini ti naŋ ya ti àgri daliya dal-dal ana ndam ya tazləbay Yezu a Zerʉzalem ni do aw ? Mara gayaŋ ahalay a Damas a ti ga məgəs ndam ya tazləbay Yezu ni akaba ga məhəloru tay afa ga gəɗákani ga ndam *maŋgalabakabu mis akaba Melefit ni do aw ? » ");
INSERT INTO muy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ay ti njəɗa ga Sol àsagakivoru, àhi ana ndam Zʉde ya a Damas ni Yezu ti naŋ *Krist *Bay gəɗakani ya amara ni. Eslini nday nakəŋ tə̀sər ere ye ti tə̂həŋgrifəŋ ni do. ");
INSERT INTO muy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Àra àgra vaɗ a ɓal ti ndam Zʉde nakəŋ tàgray sawari gatay, tə̀ɗəm si tijiŋ naŋ kwa. ");
INSERT INTO muy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Nahkay nday nakəŋ tàjəgay naŋ məlafat akaba məlavaɗ kà magudu ga kəsa ni ɗek, tawayay makaɗ naŋ. Ay ti Sol ècia sawari gatay ya tàgraki na. ");
INSERT INTO muy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ga məlavaɗ nahəma, ndam maɗəbay naŋ ni tə̀zoru naŋ ka ahàr ga gudu ya eveliŋ kəsa ni. Tòru tìnjʉa ti tə̀fiyu naŋ a aloŋgu vu mək tàfaya naŋ àna ezeweɗ gwar ka dala. Nahkay àsləka, òru a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Òru ènjʉa a Zerʉzalem a ti awayay ahurkiviyu ka ndam maɗəbay divi ga Yezu ni, ay ti nday ɗek tàgrafəŋa aŋgwaz a, tə̀hi ana ahàr naŋ bay maɗəbay divi ga Yezu eɗeɗiŋ do. ");
INSERT INTO muy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eslini Barnabas àzoru naŋ afa ga ndam *asak ga Yezu ni. Tòru tìnjʉa ti Barnabas nakəŋ àŋgəhaɗi ana tay ahəmamam Sol èpi Bay geli ka ahàr divi ka ya ti òru a Damas ni, ahəmamam Bay geli àhi ma ni daya. Àŋgəhaɗi ana tay keti ahəmamam Sol àhi ma ana mis vay-vay àna *slimi ga Yezu a Damas ni. ");
INSERT INTO muy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kwa ka sarta gani nani Sol nakəŋ naŋ àbu akaba tay, asawaɗay akaba tay a Zerʉzalem, àhi ma ge Melefit ana mis vay-vay àna slimi ga Bay geli. ");
INSERT INTO muy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Àhi ma gani ana ndam *Zʉde ya təɗəm ma Gres ni daya, tə̀bu tagravu gejewi akaba tay. Nahkay ti nday nani tàɗəbay divi ge mijiŋ naŋ. ");
INSERT INTO muy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ndam ya tə̀fəki ahàr ka Yezu ni tàra tìcia ma na ti tə̀zoru naŋ a Sezare ga moroni a Tars, mək tə̀sləroru naŋ eslini. ");
INSERT INTO muy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ka sarta gani nani ndam məfəki ahàr ka Yezu ya ka haɗ *Zʉde, ka haɗ *Gelili akaba ka haɗ *Samari ni ɗek ti mis tə̀bi tə̀gri daliya ana tay va bi. Njəɗa gatay asagakivu, tə̀bu taɗəboru divi ga Bay geli lala. Nahkay mis ndahaŋ tə̀bu təhurkiviyu ka tay àna njəɗa ga *Məsuf Njəlatani. ");
INSERT INTO muy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyer àsawaɗoru ka haɗ nday nani ɗek. Ka ya ti naŋ àbu asawaɗoru nahəma, òru e Lide afa ga ndam njəlatani ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Òru ènjʉa eslina ti àdi ahàr ana zal dəra nahaŋ slimi gani Ene, naŋ mandəhaɗani ka slalah, vi azlalahkər ècik koksah. ");
INSERT INTO muy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyer nakəŋ àzalay naŋ, àhi : « Ene, Yezu *Krist ahəŋgaraba kur a ; cikaba, slamalakabu slalah gayak ni. » Eslini naŋ nakəŋ ècikaba cəkwaɗ hʉya. ");
INSERT INTO muy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ndam ya e Lide ni ɗek akaba nday ya ka sagdala Saroŋ ni ɗek tìpi naŋ a ti, tàmbatkaba majalay ahàr gatay a tə̀fəki ahàr ka Bay geli Yezu. ");
INSERT INTO muy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Wal nahaŋ àbu e Zʉpe, aɗəbay divi ga Yezu, slimi gani Tabita, àna ma Gres ti « Dorkas, » awayay aɗəmvaba « miyek. » Wal nani ti agray tʉwi sulumani dal-dal, ajənaki ndam talaga dal-dal daya. ");
INSERT INTO muy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ka ya ti Piyer e Lide nahəma, wal ni arməwər àra àgəsa, mək àməta àna naŋ a. Àra àməta ti tàbaray naŋ mək tə̀fiyu naŋ a ahay vu ka ahàr ga ahay nahaŋ. ");
INSERT INTO muy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Zʉpe ti driŋ driŋ akaba Lide do, nahkay ndam maɗəbay divi ga Yezu ya e Zʉpe ni tàra tìcia Piyer naŋ àbu e Lide nahəma, tə̀slərkioru mis cʉ, tə̀hi ana tay : « Dəgum kəhumi ahkado kam-kam mâra afa geli a, àpəsbiyu ba. » ");
INSERT INTO muy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tàra tə̀həŋgria ma na ana Piyer a nahkay ti Piyer nakəŋ àɗəbabiyu tay hʉya. Tàra tìnjia ti tə̀ziyu Piyer a ahay ya ka ahàr ga ahay nahaŋ ni vu. Eslini wál madakway ɗek tàrafəŋa kà gəvay ge Piyer a titʉwi, təɗəfiki endʉwi akaba azana ga Dorkas ya àləmi ana tay ka sarta ya àmət faŋ ndo ni. ");
INSERT INTO muy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Eslini Piyer nakəŋ àgaraya mis na ɗek e mite va, mək àbəhaɗ mirdim, àhəŋgalay Melefit. Àra àhəŋgala Melefit a nahəma, àmbatkiyu ma ke kisim ni, àzalay naŋ àhi : « Tabita, cicikaba. » Nahkay Tabita nakəŋ àhəlkaba eri a. Àra èpia Piyer a ti ànjəhaɗ digʉs. ");
INSERT INTO muy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Eslini Piyer àdafəŋa ahar a, wal ni ècikaba. Wal ni àra ècikaba nahəma, Piyer nakəŋ àzalay wál madakway ni akaba ndam ga Yezu ndahaŋ ni. Tàra tìnjia ti àɗəfiki wal ni ana tay naŋ àna sifa. ");
INSERT INTO muy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ere ye ti àgravu ni ti, ndam ga kəsa Zʉpe ɗek tìcia, nahkay mis kay e kiɗiŋ gatay bu tə̀fəkia ahàr ka Bay geli a. ");
INSERT INTO muy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyer nakəŋ ànjəhaɗiyu, àpəsiyu e Zʉpe afa ga bay məwəs ambəl nahaŋ, slimi gani Simu. ");
INSERT INTO muy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Zal nahaŋ àbu a Sezare, slimi gani Korney, naŋ zal Rom agur ndam slewja kay, slimi gatay « Slewja Itali. » ");
INSERT INTO muy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Korney gani naŋ àbu ahəŋgrioru ahàr a haɗ ana Melefit, nday akaba ndam ga huɗ ahay gayaŋ ɗek tazləbay Melefit. Naŋ àbu avi zlam kay ana ndam *Zʉde ya talagani ni, ahəŋgalay Melefit kəlavaɗ. ");
INSERT INTO muy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A vaɗ nahaŋ agray njemdi mahkər ya ga məlakarawa nahəma, *məslər ge Melefit àhurkiviyu, àŋgazlivu. Àzalay naŋ, àhi : « Korney ! » ");
INSERT INTO muy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korney àra èpia naŋ a ti àgra aŋgwaz a, àhəŋgrifəŋ, àhi ahkado : « Kə̀hu mam, bay goro ni ? » Məslər ni àhi ahkado : « Melefit ècia ere ye ti kàhəŋgalaləŋ na, èpia ere ye ti kə̀vi ana ndam talaga na ; nahkay ti kàgəjazlki ahàr ndo. ");
INSERT INTO muy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nihi nahəma, sləroru mis e Zʉpe ga mazalabiyu Simu, naŋ ya təzalay naŋ Piyer ni. ");
INSERT INTO muy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Naŋ àbu anjəhaɗ afa ga Simu bay məwəs ambəl, ahay gani kà gəvay ga *dəluv gəɗakani ni. » ");
INSERT INTO muy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Məslər ge Melefit ya àhi ma ni àra àsləka ti Korney nakəŋ àzalay ndam məgri tʉwi cʉ akaba zal slewja gayaŋ nahaŋ : zal slewja nani ahəŋgrioru ahàr a haɗ ana Melefit. ");
INSERT INTO muy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nday nakəŋ tàra tìnjia ti àhi ma ga məslər ya àhi ni ɗek ana tay mək àsləroru tay e Zʉpe. ");
INSERT INTO muy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Hajəŋ gani tə̀bu takoru, tinjiyu e Zʉpe wuɗak nahəma, Piyer ti ni àcəliyu ka *dalahar ga ahay ni ga mahəŋgalay Melefit. Ka sarta gani nani ti faɗ tirkeɗ-keɗ, ");
INSERT INTO muy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","lʉwir àwərkaba naŋ a, èhindi zlam məzumani. Ka ya ti tə̀bu tidii zlam nahəma, Melefit àŋgazli zlam nahaŋ. ");
INSERT INTO muy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Èpi ti huɗ melefit məzləkvabana, araŋa nahaŋ asləkabiya, ara ka haɗ a. Ere gani nani ti akaɗa azana gəɗakani, akaɗa mis tə̀gəsa ma gani faɗana. ");
INSERT INTO muy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A huɗ ga azana gani nani gəɗakani ni bu nahəma, zlam gərgərani kay tə̀vu : zlam asak faɗani ɗek, zlam a haɗ ɗek, akaba eɗiɗiŋ ɗek tə̀vu. ");
INSERT INTO muy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Eslini dəŋgu ga maslaŋa àhəndabiyu, àhi : « Piyer, cikaba, bazl tay ti kâhəpəɗ tay. » ");
INSERT INTO muy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyer àhəŋgarfəŋ, àɗəm : « Aha ! Nàgray nahkay do, Bay goro ni. Zlam ya ti Melefit àcafəŋa leli kà mahəpəɗana ni akaba zlam ya ti *njəlatani do ni ti ɗay-ɗay nàhəpəɗ ndo. » ");
INSERT INTO muy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Dəŋgu ga maslaŋa nani àhəndabiyu keti, àhi : « Ere ye ti Melefit àɗəm ere gani njəlatani nahəma, nak ti ŋgay ere gani nani njəlatani do ni ti kə̀ɗəm ba. » ");
INSERT INTO muy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ere gani nani àgravu sak mahkər, mək kələŋ gani azana ni àsləka, òru e melefit vu. ");
INSERT INTO muy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eslini Piyer naŋ àbu ajalay ahàr, àsər ere ye ti Melefit awayay ahi àna zlam ya àŋgazlivu ni do. Naŋ àbu ajalay ahàr nahkay ti ndam ya ti Korney àslərbiyu tay ti tîhindi ahay ga Simu ni, nihi ti tìnjia kà mahay a. ");
INSERT INTO muy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tə̀zalay kay kay, tìhindi, tə̀ɗəm : « Simu ya təzalay naŋ Piyer ni ti anjəhaɗ ahalay aw ? » ");
INSERT INTO muy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyer ti ni naŋ àbu ajalay ahàr zlam gayaŋ, mək *Məsuf Njəlatani àhi ahkado : « Ci day, mis tə̀vu mahkər e mite bu, tihindi kur. ");
INSERT INTO muy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cikaba, huriyu a ga haɗ ti kəsləkuma akaba tay a. Araŋa àhəluk ahàr ba, aɗaba àslərbiyu tay ti nu nuani. » ");
INSERT INTO muy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nahkay Piyer nakəŋ àhərkiaya ka tay a, àhi ana tay ahkado : « Maslaŋa ya ti kihindʉm ni ti nu. Kə̀dəguma ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nday nakəŋ tə̀həŋgrifəŋ, tə̀hi ahkado : « Korney gəɗakani ga ndam slewja ni àslərkukbiyu leli. Naŋ ti mis jireni, ahəŋgrioru ahàr a haɗ ana Melefit ; ndam Zʉde ɗek tə̀ɗəm naŋ mis sulumani. Məslər ge Melefit àhi ahkado mâzalabiyu kur afa gani ti mîci pakama gayak ya akəhi ni. » ");
INSERT INTO muy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Eslini Piyer àhəliyu tay a ahay vu mək tàndəhaɗ hundum. Hajəŋ gani ti Piyer nakəŋ tàsləka e Zʉpe akaba tay a. Ndam məfəki ahàr ka Yezu ndahaŋ tàsləka akaba tay a daya. ");
INSERT INTO muy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Hajəŋ nahaŋ gani ti tìnjʉa a Sezare a. Korney ti ni naŋ àbu ajəgay tay, àzalakababiya ndam gayaŋ akaba zləbəba gayaŋ zʉɗʉk-zʉɗʉkana. ");
INSERT INTO muy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piyer naŋ àbu ahuriyu a ahay vu afa ga Korney wuɗak nahəma, Korney nakəŋ àhəraya e mite va, àŋgwivoru a ma vu. Àra ènjikiya ti àbəhaɗi mirdim grik meleher ndiɓ ana haɗ. ");
INSERT INTO muy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Eslini ti Piyer àhi : « Cikaba, nu day mis hihirikeni akaɗa nak. » Nahkay èzefteba naŋ a. ");
INSERT INTO muy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nday tə̀bu takoru a ahay vu tə̀zlaporu hi hi. Tòru tìnjʉa a ahay ni va nahəma, tìnjiki mis dal-dal macakalavani. ");
INSERT INTO muy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Mək Piyer àhi ana mis ni ahkado : « Kə̀səruma, leli ndam Zʉde ti tə̀cafəŋa leli kà mahəɗakfəŋiani kà ndam ya nday ndam Zʉde do na, ku a ahay gatay vu day mə̀huriyu do. Ku tamal nahkay nəŋgu ni, nihi ti Melefit àɗəfuki ku mis weley weley do ni ti naŋ njəlata, naŋ àɓəlay. Mis ti ŋgay naŋ njəlata do ahkay do ni naŋ àɓəlay do ni ti, nìsliki məɗəmani do simiteni. ");
INSERT INTO muy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Melefit àra àhua ma na nahkay ti, ka ya ti kàzalay nu ni ti nə̀jalay ahàr nahaŋ ndo, nìcikbiyu nàra hʉya. Ay nihi ti nawayay kə̂hu ere ye ti kàzalakibiyu nu ni. » ");
INSERT INTO muy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Eslini Korney nakəŋ àhəŋgrifəŋ, àhi ahkado : « Agray vaɗ mahkər nihi, nə̀bu nahəŋgalay Melefit a ahay goro bu. Sarta gani day akaɗa hini, njemdi mahkər ya ga məlakarawa. Ka sarta gani nani ti maslaŋa nahaŋ àŋgazluvu. Maslaŋa gani ti azana gani pərzləŋ-pərzləŋ, ahəlaba eri a vərut. ");
INSERT INTO muy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Àzalay nu : “Korney, Melefit ècia mahəŋgalay gayak ya kàhəŋgalay naŋ na : zlam ya kə̀vi ana ndam talaga ni day àgəjazlki ahàr ndo. ");
INSERT INTO muy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Nahkay ti sləroru mis e Zʉpe ga mazalabiyu Simu ya təzalay naŋ Piyer ni ; naŋ àbu anjəhaɗ afa ga Simu bay məwəs ambəl, ahay gani kà gəvay ga dəluv gəɗakani ni.” ");
INSERT INTO muy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Àra àhua nahkay ti nə̀slərkukoru mis ke weceweceni ti kâra. Sʉsi gayak, nak day kə̀pəsbiyu ndo, kàra hʉya. Ay nihi ti leli ɗek màcakalava kè meleher ge Melefit a, mawayay mici ere ye ti Bay Melefit àhuk ti kə̂hi ana leli ni. » ");
INSERT INTO muy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nahkay Piyer ànjəki ka mazlapani, àɗəm : « Nihi ti nə̀səra Melefit èdekaba mis a gərgəri do eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nahkay zla nahəma, ku mis ga haɗ weley weley do ɗek, tamal ti ahəŋgrioru ahàr a haɗ ana Melefit akaba agray zlam ge jiri ti, Melefit agəskabu naŋ. ");
INSERT INTO muy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Melefit àhibiya pakama gayaŋ ana ndam *Izireyel a. Pakama gayaŋ nani ti *Ma Mʉweni Sulumani, aɗafaki ti mis tisliki manjəhaɗkabu akaba Melefit àna sulumani azuhva Yezu *Krist. Yezu Krist ti naŋ Bay ge mis ɗek. ");
INSERT INTO muy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kə̀səruma ere ye ti àgravu kələŋ ge Zeŋ ya àhi ma ana mis, àhi ana tay si tâbaray kwa na. Ere gani nani ti ànjəki e Gelili, mək àgravu ka haɗ *Zʉde ni ɗek daya. ");
INSERT INTO muy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kə̀səruma ge Melefit ya àvi njəɗa ga *Məsuf Njəlatani kay ana Yezu zal Nazaret na. Kə̀səruma ga Yezu ya àsawaɗay a məlaŋ bu ɗek na : ka ya ti naŋ àbu asawaɗay ni ti àgria zlam sulumani ana mis a akaba àhəŋgaraba mis ya ti seteni àgri daliya ana tay na. Àgray tʉwi nday nani ɗek ti aɗaba Melefit naŋ àbu akaba naŋ palam. ");
INSERT INTO muy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Leli ndahaŋ ni ti magray sedi ga zlam gayaŋ ya àgray ka haɗ gərgərani ya ti ndam *Zʉde tanjəhaɗ ni akaba a Zerʉzalem ni ɗek. Kələŋ ga zlam gayaŋ ya àgray ni ti ndam Zʉde *tàdarfəŋ naŋ kà təndal, mək àmət. ");
INSERT INTO muy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Àra àməta ti a vaɗ ya mahkər Melefit àhəŋgriviyu sifa, àhəŋgaraba naŋ e kisim ba. Àra àhəŋgaraba naŋ a ti àvi njəɗa ti mâŋgazlivu ana mis. ");
INSERT INTO muy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Àŋgazlivu ti ana mis ɗek do ; àŋgazlivu ti ana leli ya Melefit àdaba leli a kwa ahaslana ti mîgi ndam sedi gayaŋ ni ciliŋ. Melefit àra àhəŋgriviya sifa ana Yezu a, àhəŋgaraba naŋ e kisim ba ni ti, leli mə̀zuma zlam akaba mìsia zlam akaba Yezu a. ");
INSERT INTO muy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Eslini Yezu gani àhi ana leli ahkado : “Humi ma goro ana ndam Zʉde, humi ana tay Melefit àfəkaɗ nu ga magrafəŋa seriya kè mis a ɗek, ku nday ya tə̀bu àna sifa ni, ku nday ya tə̀məta ni.” ");
INSERT INTO muy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ndam məhəŋgri *pakama ge Melefit ana mis ni ɗek tàgrakia sedi a, tə̀ɗəm ahkado ku way way do tamal àfəkia ahàr ka Yezu a ti Melefit aməmbərfəŋa zlam magudarani ga maslaŋa nana azuhva slimi ga Yezu a. » ");
INSERT INTO muy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ka ya ti Piyer naŋ àbu azlapi ana tay nahkay ni ti *Məsuf Njəlatani àhərkiaya ka ndam ya tə̀bu təbi slimi na ɗek. ");
INSERT INTO muy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ndam *Zʉde ya təfəki ahàr ka Yezu, tàra akaba Piyer a ni, tàra tə̀səra Melefit avi Məsuf Njəlatani ana ku nday ya ti nday ndam Zʉde do ni ti, àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Àgri ejep ana tay ti zlapay ga ndam ya nday ndam Zʉde do təzlapay àna ma həma ya nday ndayani tə̀sər do ni, akaba mazləbay Melefit gatay ya tazləbay, təɗəm naŋ gəɗakani ni. Piyer àɗəm : ");
INSERT INTO muy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","« Nihi ndam nday hini Melefit àvia Məsuf Njəlatani ana tay akaɗa ya àvi ana leli na ti, way esliki macafəŋa tay kà *məbaray tay àna yam a way ? Àbi ! » ");
INSERT INTO muy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Piyer àra àɗəma ma nana ti, àɗəm : « Məbaray tay àna *slimi ga Yezu *Krist. » Tàra tàbara tay a ti nday nakəŋ tə̀hi ana Piyer mânjəhaɗa akaba tay a vaɗ ɓal. ");
INSERT INTO muy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nahkay mis tə̀bu təɗəm ku ndam ya nday ndam *Zʉde do ni tə̀gəskabá ma ge Melefit ya tə̀hi ana tay na. Ndam *asak akaba ndam ndahaŋ ya təfəki ahàr ka Yezu ya ka haɗ *Zʉde ni tìcia ma gana. ");
INSERT INTO muy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ka ya ti Piyer àŋga a Zerʉzalem a ni ti ndam Zʉde ya təfəki ahàr ka Yezu ni tə̀ləgi, ");
INSERT INTO muy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","tə̀hi ahkado : « Nak kòru kə̀huriyu a ahay vu afa ga ndam ya nday ndam Zʉde do ni, kòru kə̀zumumkabu zlam akaba tay ti kamam ? » ");
INSERT INTO muy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eslini Piyer àŋgəhaɗiaba ere ye ti àgravu na ɗek ana tay a. ");
INSERT INTO muy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Àhi ana tay ahkado : « Ka ya ti nu e Zʉpe, nə̀bu nahəŋgalay Melefit nahəma, nìpi zlam ya Melefit àɗəfuki ni àna njəɗa ga *Məsuf Njəlatani. Nìpi ti araŋa nahaŋ àsləkabiya a huɗ melefit ba, àrəkua : ere gani nani ti akaɗa azana gəɗakani, akaɗa mis tə̀gəsa ma gani faɗana. ");
INSERT INTO muy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nə̀mənjiyu a huɗ gani vu lala, nìpi zlam gərgərani ya asak faɗ ni, zlam ge gili gərgərani, zlam a haɗ gərgərani akaba eɗiɗiŋ gərgərani. ");
INSERT INTO muy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nu nə̀bu nəmənjiyu zlam nday nani nahkay ti nìci dəŋgu ga maslaŋa àhubiyu ma a huɗ melefit bu, àhu ahkado : “Piyer cikaba, bazl tay ti kâhəpəɗ tay.” ");
INSERT INTO muy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ay ti nu nakəŋ nə̀həŋgrifəŋ, nə̀hi : “Aha ! Nàgray nahkay do, Bay goro ni. Zlam ya ti Melefit àcafəŋa leli kà mahəpəɗana ni akaba zlam ya ti njəlatani do ni ti nə̀təliyu a ma goro vu ɗay-ɗay ndo.” ");
INSERT INTO muy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Eslini nìci dəŋgu gayaŋ keti, àhu : “Ere ye ti Melefit àɗəm ere gani njəlatani nahəma, nak ti ŋgay ere gani nani njəlatani do ni ti kə̀ɗəm ba.” ");
INSERT INTO muy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ere gani nani àgrakuvu sak mahkər, kələŋ gani ere gani nani ɗek àsləka, òru e melefit vu. ");
INSERT INTO muy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","« Ere gani nani àra àsləka ti mis ndahaŋ mahkər tàra hʉya, nday tə̀bu kà mahay ga ahay ya leli mə̀vu ka sarta nani ni. Ndam nday nani tə̀slərkubiyu tay kwa a Sezare. ");
INSERT INTO muy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Nday tə̀bu kà mahay nahkay ti Məsuf Njəlatani àhu ahkado : “Ɗəboru tay, araŋa nahaŋ àhəluk ahàr ba.” Nahkay màsləka akaba bəza ga məŋ geli nday hini mukuani na, mòru a magam afa ga maslaŋa ya ti àzalay nu ni. ");
INSERT INTO muy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mòru mìnjʉa ti maslaŋa gani nani àŋgəhaɗi ma ana leli, àɗəm ahkado : “*Məslər ge Melefit àŋgazluvu a ahay bu, àhu ahkado : Sləroru mis e Zʉpe ga mazalabiyu Simu ya təzalay Piyer ni. ");
INSERT INTO muy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Eminjia ti aməhuk pakama. Pakama gani nani ti Melefit amahəŋgay kur akaba ndam ga huɗ ahay gayak ɗek àna naŋ.” ");
INSERT INTO muy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Maslaŋa nani àra àŋgəhaɗua ma na nahkay ti nə̀njəki ka məhi ma ge Melefit ana tay. Ka ya ti nə̀bu nəhi ma ana tay nahkay ni ti Məsuf Njəlatani àhərkiaya ka tay akaɗa ya àhərkiaya ke leli ahaslani na. ");
INSERT INTO muy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Eslini ti pakama ga Bay geli ya àɗəm ahaslani “Zeŋ *àbaray mis ti àna yam, lekʉlʉm ti ni atabaray kʉli àna Məsuf Njəlatani” ni àŋguaya a ahàr ba. ");
INSERT INTO muy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tamal Melefit àvia zlam ana tay a kala-kala akaɗa ya àvi ana leli ka ya ti mə̀fəki ahàr ka Bay geli Yezu *Krist na ti, nu nisliki məhiani ana Melefit “Kàgray nahkay ba” tata waw ? » ");
INSERT INTO muy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ndam məfəki ahàr ka Yezu ya a Zerʉzalem ni tàra tìcia ma ge Piyer ya àhi ana tay na ti tə̀mbrəŋ məzum ɓəruv gatay ni, tàzləbay Melefit, tə̀ɗəm : « Nahkay eɗeɗiŋ, Melefit àvia divi ana ndam ya nday ndam Zʉde do na daya ga mambatkaba majalay ahàr gatay a ti tə̂ŋgət *sifa ya àndav ɗay-ɗay do ni. » ");
INSERT INTO muy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ka ya ti tàkaɗ Etiyeŋ, tə̀gri daliya ana ndam ya təfəki ahàr ka Yezu ni ti, ndam ya təfəki ahar kà Yezu ni tèdevoru a kəsa ndahaŋ vu. Mis ndahaŋ e kiɗiŋ gatay bu tòru bəɗak e Fenisi, mis ndahaŋ tòru e Sipir, mis ndahaŋ ti ni tòru a Antiyos. Ay nday gani nani tə̀hi ma ge Melefit ana ndam *Zʉde ciliŋ. ");
INSERT INTO muy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ku tamal nahkay nəŋgu ni, ndam Zʉde ndahaŋ ya ga haɗ Sipir akaba ga haɗ Sireŋ ni tòru a Antiyos. Tòru tìnjʉa eslina ti tə̀hi *Ma Mʉweni Sulumani àki ka Bay geli Yezu ana ndam ya nday ndam Zʉde do ni daya. ");
INSERT INTO muy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Eslini Bay geli àvia njəɗa gayaŋ ana tay a, nahkay mis kay tə̀gəskabá ma gatay na, mək tə̀fəki ahàr ka Bay geli. ");
INSERT INTO muy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ndam ga Yezu ya a Zerʉzalem ni tàra tìcia ma gana ti tə̀sləroru Barnabas a Antiyos. ");
INSERT INTO muy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Òru ènjʉa, èpia *sulum ge Melefit ya àgray eslini na ti, àməria məɓəruv a. Àvi njəɗa ana tay, àhi ana tay tâɗəboru divi ga Bay geli àna huɗ bəlaŋ, tə̀mbrəŋ ba. ");
INSERT INTO muy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ti bay magray sulum, *Məsuf Njəlatani àniviyu dal-dal, àfəkia ahàr ka Yezu a dal-dal daya. Nahkay ti mis ndahaŋ kay tə̀fəki ahàr ka Bay geli Yezu, tə̀hurkiviyu ka ndam gayaŋ ni àkivu. ");
INSERT INTO muy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kələŋ gani Barnabas nakəŋ àsləka, òru a Tars ga mazalabiyu Sol. ");
INSERT INTO muy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Àra àdia ahàr a ti àzəbiyu naŋ a Antiyos. Tàra tìnjia ti tìvi dəz afa ga ndam ga Yezu ye eslini ni. Mis dal-dal tə̀bu eslini, nahkay nday nakəŋ tə̀cahi zlam ana tay. Mis tə̀zalay ndam maɗəbay divi ga Yezu ni « ndam ge *Krist » enjenjeni ti a Antiyos. ");
INSERT INTO muy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka sarta gani nani ti mis ndahaŋ tàsləka a Zerʉzalem a, tòru a Antiyos. Nday gani nani ti ndam mahəŋgaray *pakama ge Melefit. ");
INSERT INTO muy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Zal nahaŋ àbu e kiɗiŋ gatay bu, slimi gani Agabus. Eslini Məsuf Njəlatani àvi njəɗa, Agabus nakəŋ àhi ana mis ahkado lʉwir gəɗakani amadaya ka haɗ a ɗek. Lʉwir gani nani àdaya ti ka sarta ga Kəlot *bay gəɗakani ga ndam Rom eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ndam maɗəbay divi ga Yezu ya a Antiyos ni tàra tìcia ma ga Agabus na ti tə̀ɗəm ku way way do mâfəkaɗ siŋgu ya ahar gayaŋ àŋgət ni. Tàbəhaɗa nahkay ti atəslərikaboru ana ndam məfəki ahàr ka Yezu ya ka haɗ *Zʉde ni ga məjənaki tay. ");
INSERT INTO muy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Nday nakəŋ tàra tàbəhaɗa siŋgu na ti tə̀bi a ahar vu ana ata Barnabas nday ata Sol, ti tə̂həlikaboru ana gəɗákani ga ndam məfəki ahàr ka Yezu ya ka haɗ Zʉde ni. ");
INSERT INTO muy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ka sarta gani nani ti bay *Erot ànjəkia ka məgri daliya ana mis ndahaŋ e kiɗiŋ ga ndam məfəki ahàr ka Yezu ni ba. ");
INSERT INTO muy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Eslini àɗəm tâkaɗ Zek wur ga məŋ ge Zeŋ àna maslalam, mək tàkaɗ. ");
INSERT INTO muy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Erot nakəŋ àra àsəra ere ye ti àgray ni àɓəlafəŋa kà ndam *Zʉde a nahəma, àɗəm tə̂gəsia Piyer a. Àɗəm nahkay ti ka sarta ga wuməri ge *dipeŋ ya zlam *miwisiŋeni àkibu bi ni. ");
INSERT INTO muy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tàra tə̀gəsia naŋ a ti tə̀fiyu a ahay ga daŋgay vu. Eslini Erot nakəŋ àhi ana ndam slewja gayaŋ têdevu faɗ faɗ məlaŋ faɗ tâjəgay Piyer. Àgray nahkay ti, awayay ti agrafəŋa seriya kələŋ ga wuməri ga *Pak na kè meleher ga ndam Zʉde a. ");
INSERT INTO muy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ka ya ti Piyer naŋ àvu a ahay ga daŋgay ni bu ni ti ndam məfəki ahàr ka Yezu ni tə̀mbrəŋ mahəŋgali Melefit ndo. ");
INSERT INTO muy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ga məlavaɗ məlaŋ gani ara aslay, Erot ara agrafəŋa seriya ti, Piyer nakəŋ naŋ àvu e ɗʉwir bu. Naŋ àvu e ɗʉwir bu nahkay ti ndam slewja bebem cʉ tə̀fəvù naŋ e kiɗiŋ vu, tajəgay naŋ. Naŋ məwəlani àna jejirɓi cʉ. Ndam slewja ndahaŋ tajəgay mahay ga ahay ga daŋgay ni. ");
INSERT INTO muy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Eslini məslər ga Bay geli àŋgazlavu hʉya, nahkay məlaŋ ya tə̀fiyu Piyer ni àslaɗay dal-dal. Məslər nakəŋ ènjifiŋ kà jamaŋgay ge Piyer, èpiɗekaba naŋ a. Àra èpiɗekaba naŋ a ti àhi ahkado : « Cikaba weceweci. » Àra àhi nahkay ti jejirɓi ni tə̀sləkiaba a ahar ba ana Piyer a. ");
INSERT INTO muy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mək məslər ni àhi ana Piyer keti : « Wəlvu àna maslpara gayak, bəvu kimaka gayak. » Eslini Piyer nakəŋ àgray akaɗa ga məslər ya àhi ni. Àhi keti : « Fakabu məgudi gayak, ɗəbabiyu nu. » ");
INSERT INTO muy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Nahkay Piyer àɗəbabiyu məslər ni, tàhəraya a məlaŋ ya tə̀fiyu Piyer ni ba. Ŋgay ere ye ti məslər àgray ni jiri ti Piyer àsərkaba do. Àhi ana ahàr bi Melefit aŋgazli zlam akaɗa e kisim miziɗeni bu ciliŋ. ");
INSERT INTO muy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nday nakəŋ tàsləkafəŋa kà ndam slewja ye enjenjeni ya ti tajəgay ahay na, mək tàsləkafəŋa kà nday ye cʉ ya tajəgay ahay na, kələŋ gani tòru tìnjʉa kà mahay ge mite gəɗakani ga ara na ti, mahay ni àzləkvaba ka ahàr gayaŋ a. Nday nakəŋ tàhəraya e mite va, tə̀bu takoru e divi bu ni ti məslər ni àsləkafəŋa hʉya. ");
INSERT INTO muy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eslini Piyer àsərki ke ere ye ti àgravu ni ɗəma mba. Nahkay àɗəm : « Nihi ti nə̀səra Bay geli àslərkubiya məslər gayaŋ eɗeɗiŋa. Melefit àhəŋgafəŋa nu kà Erot akaba kè ere ye ti ndam Zʉde amal tara təgru na. » ");
INSERT INTO muy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Àra àjalakia ahàr ke ere ye ti àgrakivu na ti, òru a magam afa ga Mari məŋ ge Zeŋ ya təzalay Mark ni. Eslini afa ga Mari ti mis tə̀vu dal-dal macakalavani, tahəŋgalay Melefit. ");
INSERT INTO muy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piyer nakəŋ òru ènjʉa ti àsi ahar ana mahay. Wur dahalay nahaŋ slimi gani Ruda, agri tʉwi ana Mari, àra ècia ge Piyer ya àsi ahar ana mahay na ti àra ga mabay slimi a ti mə̀sər bay ya ti asi ahar ana mahay ni. ");
INSERT INTO muy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Àra àsəra dəŋgu ge Piyer a ti àdiki ana məmərani, àzləkiaba mahay a ndo, àcuhwakivoru ke mis ndahaŋ ni. Àra ènjikiva ka tay a ti àhi ana tay Piyer naŋ àbu kà mahay e mite bu. ");
INSERT INTO muy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nday nakəŋ tə̀həŋgrifəŋ tə̀hi : « Nak ti araŋa agray kur aw ? » Ruda nakəŋ àɗəm : « Piyer Piyereni eɗeɗiŋ. » Nday nakəŋ tə̀hi : « Tamal nahkay ti bi *məslər ge Melefit ya àvi ga majəgay naŋ ni. » ");
INSERT INTO muy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nday tə̀bu tagray gejewi nahkay ti Piyer naŋ àbu asi ahar ana mahay kekileŋa. Kələŋ gani tə̀zləkiaba mahay na ; tàra tìpia naŋ a ti àgria ejep ana tay a dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nday tə̀bu təzlapaki ti Piyer nakəŋ àgri ahar ana tay ti tə̂lakakabá, mək àŋgəhaɗi ere ye ti àgrakivu ni ana tay, ahəmamam Bay geli àzaya naŋ a ahay ga daŋgay ni ba ni. Kələŋ gani àhi ana tay : « Ŋgəhaɗumi ma gani ana ata Zek akaba bəza ga məŋ geli ndahaŋ ni. » Àra àhia ma na ana tay a nahkay ti àhəraya, àsləka òru ka məlaŋ nahaŋ. ");
INSERT INTO muy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Məlaŋ àra àsla ti ndam slewja ya tajəgay ahay ga daŋgay ni tə̀di ahàr ana Piyer ndo ni ti, ɓəruv àtikaba ana tay a kwir kwir. Tə̀ɗəm ahkado : « Àmbava àdoru eley ? » ");
INSERT INTO muy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Bay Erot àra ècia ma gana ti àɗəm tâɗəbay naŋ. Tàra tàɗəba naŋ a, tə̀di ahàr ndo ni ti, Bay Erot nakəŋ èhindifiŋa ma gana kà ndam slewja ya tajəgay ahay ga daŋgay na. Nday tə̀sər ere ye ti àgrakivu ka tay ni do ni ti, Erot nakəŋ àɗəm tâbazla tay a. Kələŋ gani Erot àsləka ka haɗ *Zʉde a, òru ànjəhaɗ a Sezare. ");
INSERT INTO muy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ka sarta gani nani bay *Erot àzumkia ɓəruv ka ndam Tir akaba ndam Sidoŋ a. Nahkay ti ndam ga kəsa nday nani tə̀zlapakabá ga məslərbiyu mis afa ga bay ni ti tə̂gri kam-kam, aɗaba tə̀bu təŋgət zlam məzumani gatay ka haɗ gayaŋ. Tàra tìnjia a Sezare a ti tə̀vi zlam ana Blastus gəɗakani ga ndam məgri tʉwi ana bay ni ti mə̂jənaki tay ga maŋgalabakabu tay akaba bay ni. Nahkay àfəkaɗ vaɗ gani. ");
INSERT INTO muy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Vaɗ gani àra ènjia nday tə̀bu eslini ti, Erot nakəŋ àbakabu azana ga bay gayaŋ mək ànjəhaɗ e kʉrsi ga bay gayaŋ bu. Naŋ àbu manjəhaɗani gappa nahkay ti àhi ma ana tay kè eri ge mis ɗek. ");
INSERT INTO muy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Mis ni tàra tìcia ma gayaŋ na ti tə̀zlah, tə̀ɗəm ahkado : « Bay hini ya azlapay ni ti melefit, do ni ti mis hihirikeni do ! » ");
INSERT INTO muy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Mis tə̀bu təzlah nahkay ti *məslər ge Melefit àra àfəki arməwər ka Erot nakəŋ, aɗaba àgəskabá ma ge mis ya tə̀hi na, àza ahàr gayaŋ akaɗa ge Melefit na. Nahkay ti mekcehʉɗ tə̀zumaba naŋ a, mək àmət. ");
INSERT INTO muy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kəlavaɗ mis ndahaŋ ya tə̀fəki ahàr ka Yezu faŋ ndo ni tə̀bu tici ma ge Melefit, mək təfəki ahàr ka Yezu. ");
INSERT INTO muy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ata Barnabas nday ata Sol tàra tìndeveriŋa tʉwi gatay a Zerʉzalem a ti tàsləka, tàŋgoru ka məlaŋ gatay ya tàsləkabiya ni. Ka ya ti tàsləka ni ti tə̀zəkiva Zeŋ ya təzalay Mark na ju. ");
INSERT INTO muy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","A Antiyos ti mis ndahaŋ tə̀bu təhəŋgri pakama ge Melefit ana ndam məfəki ahàr ka Yezu, mis ndahaŋ tə̀bu təcahi pakama ge Melefit ana tay. Nday gani nani ti ata : Barnabas, Simeyoŋ slimi gayaŋ nahaŋ Nizer, Lisiyʉs zal Sireŋ, Manayaŋ ya tə̀ɗəkkabu akaba bay *Erot ni, akaba Sol. ");
INSERT INTO muy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A vaɗ nahaŋ nday tə̀bu təgəs ndəra, tazləbay Bay geli ti, *Məsuf Njəlatani àhi ma ana tay. Àɗəm : « Dəmuaba ata Barnabas nday ata Sol a, aɗaba nə̀həlaba tay ga məgru tʉwi nahaŋ a. » ");
INSERT INTO muy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tàra tìcia ma na ti tə̀gəs ndəra keti, tàhəŋgalay Melefit mək tə̀bəki *ahar ka tay ga məgri *sulum ge Melefit ana tay. Tàra tə̀gria ana tay a nahkay ti tə̀vi divi ana tay ga moroni ka haɗ ndahaŋ. ");
INSERT INTO muy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Məsuf Njəlatani àra àsləra ata Barnabas nday ata Sol nakəŋ a ti tòru e Selewsi. Tòru tìnjʉa ti tə̀cəliyu a *slalah ga yam vu, tòru ka haɗ Sipir. ");
INSERT INTO muy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tòru tìnjʉa a Salamiŋ a ti tə̀di ahàr ana ahay gərgərani ga *mahəŋgalavù Melefit ga ndam *Zʉde, mək tə̀huriyu, tə̀hi ma ge Melefit ana tay. Eslini ti Zeŋ Mark naŋ àbu akaba tay, ajənaki tay. ");
INSERT INTO muy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tàra tə̀sawaɗaba kəsa Sipir na bəɗak a Pafos a ti, tə̀di ahàr ana zal Zʉde nahaŋ, slimi gani Bar-Yezu, naŋ zal maharam. Àɗəm naŋ bay mahəŋgaray pakama ge Melefit, ay ti àsəkaɗ malfaɗa. ");
INSERT INTO muy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Naŋ gani anjəhaɗ afa ga zal Rom ya ti agur haɗ Sipir ni. Slimi ga bay ni Serjʉs Polus, àsəra zlam a. Awayay mici ma ge Melefit dal-dal, nahkay àzaloru ata Barnabas nday ata Sol afa gani. ");
INSERT INTO muy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ay zal maharam ni ezirey tay, awayay ti zal Rom ni àfəki ahàr ka Yezu ba. Zal maharam nani təzalay naŋ àna ma Gres ti Elimes. ");
INSERT INTO muy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Eslini *Məsuf Njəlatani àhuriviyu ana Sol dal-dal. (Sol ti təzalay naŋ Pol daya). Məsuf Njəlatani ni àra àhuriviya ti Pol nakəŋ àmənjaləŋ ka zal maharam ni, ");
INSERT INTO muy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","mək àhi ahkado : « Nak ti wur ge *Seteni, nak zal cuɗay, nak bay magosay mis, zlam sulumani ɗek kàwayay do. Nak ti akəmbrəŋ magudar divi ga Bay geli ti ananaw ? ");
INSERT INTO muy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nihi nahəma, ci ma goro ya nəhuk ni lala : Melefit ara atraɓ kur àna ahar gayaŋ, kara kəwuluf. Ekipi fat va do duk abivoru ana vaɗ ya ti Melefit aməmbrəŋ matraɓ kur ni. » Pol àra àhia ma na nahkay ti zal maharam ni àwuluf hʉya tatuf, ègia akaɗa maslaŋa ya ti naŋ a ləvəŋ bu na. Nahkay ambatvu, aɗəbay mis ga madafəŋa ahar a. ");
INSERT INTO muy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Bay məgur haɗ ni àra èpia ere ye ti àgravu na ti àfəki ahàr ka Yezu, aɗaba ma ga Pol ya àɗəmki ka Bay geli Yezu ni àɓəlafəŋa dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol akaba ndam ya ti tagrakabu tʉwi ni tə̀cəliyu a *slalah ga yam vu, tàsləka a Pafos a, tòru e Perzi ka haɗ Pemfili. Eslini ti Zeŋ Mark àsləkafəŋa kà tay a, àŋgoru a Zerʉzalem. ");
INSERT INTO muy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nday nakəŋ tàsləka e Perzi a, tòru a Antiyos ka haɗ Pisidi. Vaɗ *məpəsabana àra ènjia ti tə̀huriyu a ahay ga *mahəŋgalavù Melefit vu, tànjəhaɗ digʉs-gʉs. ");
INSERT INTO muy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Eslini gəɗákani ga ahay ga mahəŋgalavù Melefit ni tìjeŋgey ma ya e *Divi ge Melefit ya Mʉwiz àbəki ni bu ni akaba ma ga ndam ndahaŋ ya tàhəŋgaray *pakama ge Melefit ni. Tàra tìjeŋga ti tə̀slərkiyu mis ka ata Pol ge məhiani ana tay ahkado : « Bəza ga məŋ geli ni, tamal pakama gekʉli àbu ga məhiani ana mis maŋgasvani ni ga məvi njəɗa ana tay ti, ɗəmum. » ");
INSERT INTO muy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Nahkay Pol ècikaba, àdaɗay ahar mək àɗəm : « Lekʉlʉm ndam *Izireyel ni akaba lekʉlʉm ndahaŋ ya ti kəzləbum Melefit ni, bumu slimi. ");
INSERT INTO muy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Melefit ga ndam jiba geli Izireyel ni àdaba ata bəŋ ga bəŋ geli a. Ka ya ti ndam jiba geli nday ka haɗ Ezip ni ti Melefit àgray ti tâwuɗay, nahkay tàwuɗa. Kələŋ gani àɗafaki njəɗa gayaŋ, àhəlaba tay ka haɗ nana àna ahar gayaŋ a. ");
INSERT INTO muy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kələŋ gani ka ya ti nday tə̀bu a huɗ gili bu agray vi kru kru faɗ ni ti èɓesia ana tay a. ");
INSERT INTO muy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tòru tìnjʉa ka haɗ Kanaŋ a nahəma, Melefit àbazliaba jiba adəskəla ya ka haɗ nani na ana tay a, mək àvi haɗ gani ana tay. ");
INSERT INTO muy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Zlam nday nani ɗek tàgravu ti agray vi diŋ diŋ faɗ àna kru kru zlam. Kələŋ gani àdiaba ndam magray seriya ana tay a duk àbivoru ana sarta ge Semiyel bay mahəŋgaray *pakama ge Melefit ni. ");
INSERT INTO muy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kələŋ gani tìhindifiŋa bay kè Melefit a, mək Melefit àdiaba Seyʉl ana tay a. Seyʉl ti naŋ wur ge Kis, ge dini ge Benjemeŋ. Naŋ gani àgur tay vi kru kru faɗ. ");
INSERT INTO muy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ay ka ya ti Melefit àwayay naŋ va do ni ti Melefit àdiaba Devit ana tay a ti mîgi bay gatay. Devit nakəŋ Melefit àgrakia sedi a, àɗəm : “Nə̀ŋgəta Devit wur ge Zese a. Bay ya ti nàɗəbay ni ti naŋ ; amagray ere ye ti nu nawayay ni ɗek.” ");
INSERT INTO muy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Nihi ti Melefit àdaba mis nahaŋ e kiɗiŋ ga bəza huɗ ge Devit ba, àfəkaɗ naŋ Bay mahəŋgay ndam Izireyel, àgray akaɗa ga pakama gayaŋ ya àɗəm ahaslani ni. Maslaŋa gani nani ti Yezu. ");
INSERT INTO muy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wuɗaka Yezu àra ànjəki ke tʉwi gayaŋ nahəma, Zeŋ àhi ana ndam Izireyel ɗek ahàr àɗəm tâmbatkaba majalay ahàr gatay a ti *tâbaray kwa. ");
INSERT INTO muy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Zeŋ àra èndeveriŋaba tʉwi gayaŋ a wuɗak ti àhi ana mis : “Lekʉlʉm kəhumi ana ahàr ti nu way ? Bay ya ti lekʉlʉm kə̀bum kəjəgum ni ti nu do. Nəɗəm nahəma, ka ya ti enindeveriŋaba tʉwi goro na ti bay gani amara. Naŋ ti nìsli ga mepicehiaba ezeweɗ ga kimaka gayaŋ a do.” ");
INSERT INTO muy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","« Bəza ga mmawa, lekʉlʉm bəza huɗ ga Abraham akaba lekʉlʉm ndahaŋ ya kəzləbum Melefit ni, pakama hini ya kìcʉm ni ti Melefit ahəŋgay mis àna naŋ. Melefit àhi pakama hini ti ana leli. ");
INSERT INTO muy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ndam Zerʉzalem akaba gəɗákani gatay tə̀sər Yezu ti naŋ *Bay gəɗakani ya amara ni ndo, tìci ma ga ndam mahəŋgaray pakama ge Melefit ya tijeŋgey kəla vaɗ məpəsabana ni ndo daya. Nahkay tə̀ɗəm tâkaɗ Yezu kwa. Tàgray nahkay ti, tàgra ere ye ti ndam mahəŋgaray pakama ge Melefit tə̀ɗəm amagravu na. ");
INSERT INTO muy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ku tamal ndam Zerʉzalem ni tə̀ŋgətfəŋa zlam magudarani ga makaɗki naŋ di ndo nəŋgu ni, tə̀hi ana Pilet tâkaɗ naŋ. ");
INSERT INTO muy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tə̀gria zlam na ɗek akaɗa ga pakama ya àbu məbəkiani a Wakita ge Melefit bu na. Yezu àra àməta ti tə̀zaya kisim gana kà təndal na, tə̀fiyu e mindiviŋ vu. ");
INSERT INTO muy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ay ti Melefit àhəŋgaraba naŋ e kisim ba, àhəŋgriviya sifa. ");
INSERT INTO muy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kələŋ gani Yezu nakəŋ àŋgazlivu ana ndam ya tàsləka akaba naŋ e Gelili a, tòru akaba naŋ a Zerʉzalem ni vaɗ ehimeya. Nihi ti nday gani nani tagrakia sedi kè meleher ga ndam *Zʉde a. ");
INSERT INTO muy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Leli gani hini day məhi *Ma Mʉweni Sulumani gani ana kʉli. Ere gani nani ti Melefit àhibiya pakama gana ana ata bəŋ geli a kwa ahaslana, ");
INSERT INTO muy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ay nihi ti àgria ere ye ti àhibiyu ana ata bəŋ geli na ana leli bəza gatay na. Àgray ti àna mahəŋgaraba Yezu e kisim ba, akaɗa ya àbu məbəkiani a wakita ge Limis bu ni. A limis ye cʉ ni bu Melefit àɗəm : “Nak ti wur goro ; kani ti nawayay ti mis tə̂sər nu buk.” ");
INSERT INTO muy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","« Melefit àɗəmbiya amahəŋgaraba naŋ e kisim ba ti èzi ba. Àɗəmki ma nahkay hi : “Anəgri sulum goro ana kʉli akaɗa ya nə̀ɗəm anəgri ana Devit ni. Zlam gani nani ti *njəlatani, amandav ɗay-ɗay do.” ");
INSERT INTO muy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","« Nahkay a məlaŋ nahaŋ bu a Wakita ge Melefit bu keti Devit àɗəm : “Akavay divi ti bay njəlatani gayak ni èzi e mindiviŋ vu ba.” ");
INSERT INTO muy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","« Devit ka sarta gayaŋ ti àgria tʉwi ana Melefit akaɗa ge Melefit ya àwayay na. Kələŋ gani Devit nakəŋ àməta, ènjikibiya ata bəŋana, kisim gayaŋ day èzia. ");
INSERT INTO muy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ay Bay ya ti Melefit àhəŋgaraba naŋ e kisim ba ni ti, kisim gayaŋ ni èzi ndo. ");
INSERT INTO muy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Bəza ga mmawa, sərum lala : leli məhi ana kʉli Melefit aməmbərfəŋa zlam magudarani gekʉli ni kè kʉli a ti azuhva Yezu. Melefit àmbərfəŋa zlam magudarani gekʉli kè kʉli àna *Divi gayaŋ ya àbu məbəkiani a wakita ge Mʉwiz ni bu na koksah. ");
INSERT INTO muy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ay azuhva tʉwi ge *Krist ya àgray ni ti Melefit ambərfəŋa zlam magudarani kà ndam ya təfəki ahàr ke Krist na ɗek. ");
INSERT INTO muy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Nahkay ti bumvu slimi, do ni ti zlam ya ti ndam mahəŋgaray pakama ge Melefit tə̀ɗəmkibiyu ma ni ara agrakivu ke kʉli. Ma gatay ya tə̀ɗəmbiyu ni ti nihi : ");
INSERT INTO muy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Lekʉlʉm ndam ya kə̀ɗəmum pakama ge Melefit zlam masakani ni ti mənjumki ere ye ti nara nagray ni. Ere gani nani mə̂gri ejep ana kʉli ti kîjijʉma ! Anagray ti ka ya ti lekʉlʉm kə̀bum àna sifa mba ni. Ere gani nani ti ku tamal maslaŋa àŋgəhaɗia ma gana ana kʉli a nəŋgu ni, kə̀gəsumkabu do.”  » ");
INSERT INTO muy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pol àra àhia ma gana ana tay a, ka ya ti nday ata Barnabas tàhəraya a ahay ni ba ni ti, mis ya tə̀bu eslini ni tə̀hi ana tay : « A vaɗ məpəsabana nahaŋ ya amara ni ti ŋguma ga məhikivu pakama àki ka ma hini ana leli keti. » ");
INSERT INTO muy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mis tə̀bu tedevu ti mis ndahaŋ kay tàɗəboru ata Pol nday ata Barnabas. Nday nani ti ndam Zʉde akaba mis ndahaŋ ya taɗəbay divi ga ndam Zʉde ga mazləbay Melefit ni. Nahkay ata Pol nday ata Barnabas nakəŋ tə̀zlapi ana tay, tə̀vi njəɗa ana tay ti tə̂gəskabu *sulum ge Melefit ya àgri ana tay ni, tə̀mbrəŋ ba. ");
INSERT INTO muy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Vaɗ məpəsabana àra ènjia nahəma, mis ga kəsa ni ahar gəɗakani tàra ɗek ga məbi slimi ana ma ya təɗəmki ka Bay geli ni. ");
INSERT INTO muy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ndam Zʉde ni tàra tìpia ndam ga kəsa na ɗek macakalavani ti tə̀zumki ɓəruv ka tay, tə̀njəki ke mindivi Pol akaba ka məhiani ana mis pakama gayaŋ ni ti ma ga malfaɗa. ");
INSERT INTO muy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ata Pol nday ata Barnabas tàra tìcia pakama ga ndam Zʉde na ti aŋgwaz àwər tay ndo, tə̀hi ana tay vay-vay ahkado : « Ahàr àɗəm mə̀hia ma ge Melefit na ana kʉli ndam Zʉde na enjia day. Ay nihi ti lekʉlʉm kə̀gəsumkabu pakama gani do ni ti, lekʉlʉm lekʉlʉmeni kə̀ɗəfumkia kìslʉm ga məŋgət *sifa ya àndav ɗay-ɗay do ni do. Ègia nahkay ti leli məhi ma gani ana ndam ya ti nday ndam Zʉde do ni. ");
INSERT INTO muy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Məhi ana tay nahkay ti aɗaba Bay geli àhi ana leli nahkay hi : “Nàfəkaɗ kur ti akaɗa ge ceŋgel ni ga maslaɗi məlaŋ ana ndam ga jiba gərgərani ɗek. Nawayay ti kə̂hioru pakama àku ka nu ya nahəŋgay mis ni ana mis ɗek, duk kè sliri ga məlaŋ.”  » ");
INSERT INTO muy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mis ya ti nday ndam Zʉde do ni tàra tìcia ma ga ata Pol nday ata Barnabas na ti tə̀mərvu, tàzləbay Melefit azuhva pakama gayaŋ ni. Eslini nday ya ti Melefit àdaba tay ga məŋgət sifa ya àndav ɗay-ɗay do ni na, nday ɗek tə̀fəki ahàr ka Yezu. ");
INSERT INTO muy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kələŋ gani mis tə̀ɗəmkioru pakama àki ka Bay geli, nahkay mis ga haɗ ni ɗek tìcia ma gana. ");
INSERT INTO muy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ay ndam Zʉde ni tə̀ɗəmki ma magədavani ka ata Pol nday ata Barnabas, ti wál ya elimeni gatay àbu, tazləbay Melefit ni akaba gəɗákani ga kəsa ni tîzirey ata Pol nday ata Barnabas. Nahkay ndam ga kəsa ni tə̀njəki ka məgri daliya ana ata Pol nakəŋ, mək tàgaraba tay ka haɗ gatay na. ");
INSERT INTO muy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ka ya ti ata Pol nday ata Barnabas tawayay tasləka ni ti tə̀tukaba haɗ ga kəsa na ka asak gatay a ga məɗəfiki ana tay araŋa gani gatay va do. Mək tàsləka, tòru a Ikoniyum. ");
INSERT INTO muy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ndam Antiyos ya taɗəbay divi ga Yezu ni tə̀bu təmərvu, *Məsuf Njəlatani èsliva a vu vu ana tay a. ");
INSERT INTO muy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ata Pol nday ata Barnabas tòru tìnjʉa a Ikoniyum a ti, tə̀huriyu a ahay ya ndam *Zʉde *tahəŋgalavù Melefit ni vu keti. Eslini tə̀hi ma ge Melefit ana tay : azuhva ma gatay ni mis kay tə̀fəkia ahàr ka Yezu a, ku ndam Zʉde ku ndam ya nday ndam Zʉde do ni daya. ");
INSERT INTO muy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ay ndam Zʉde ya tàwayay məfəki ahàr ka Yezu do ni tə̀hi ma magədavani ana ndam ya nday ndam Zʉde do ni ti tîzirey bəza ga məŋ geli ye eslini ni. ");
INSERT INTO muy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ku tamal nahkay nəŋgu ni, ata Pol nday ata Barnabas tə̀pəsa kay a Ikoniyum a. Ka ya ti nday tə̀bu eslini ni ti nday tə̀bu təfəki ahàr ka Bay geli lala, nahkay təhi ma ge Melefit ana mis vay-vay, aŋgwaz àwərki tay do. Nahkay Bay geli àvi njəɗa ana tay ga magray zlam gərgəri kay ya ti mis tìpi ɗay-ɗay ndo ni. Bay geli àgray nahkay ti, àɗafaki ti pakama gatay ya tə̀hi ana mis àki ka sulum gayaŋ ni ti jiri eɗeɗiŋ. ");
INSERT INTO muy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Nahkay ndam ga kəsa nani tèdevu məlaŋ cʉ : mis ndahaŋ ga ndam Zʉde ni, mis ndahaŋ ti ni ga ndam *asak ga Yezu ni. ");
INSERT INTO muy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Eslini ti ndam Zʉde akaba nday ya ndam Zʉde do ni akaba gəɗákani gatay tawayay təgri daliya ana ata Pol nday ata Barnabas, tawayay tabazl tay àna akur. ");
INSERT INTO muy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ndam asak nakəŋ tàra tìcia ma gana ti tàcuhway, tòru gwar a kəsa vu ka haɗ Likawuni. Kəsa nday nani ti Listir, Derbi akaba kəsa ndahaŋ ciɓ-ciɓeni ni. ");
INSERT INTO muy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Nday nakəŋ tòru tìnjʉa eslina ti tə̀hi *Ma Mʉweni Sulumani ana mis. ");
INSERT INTO muy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Zal dəra nahaŋ àbu e Listir, naŋ manjəhaɗani aɗaba ècikaba koksah, àsawaɗay ɗay-ɗay ndo kwa ke miwivu gayaŋ. ");
INSERT INTO muy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A vaɗ nahaŋ naŋ àbu abi slimi ana ma ga Pol ya aɗəm ni ti, Pol nakəŋ àmənjaləŋ, èpi ti zal dəra ni àfəkia ahàr ka Yezu a, Yezu ahəŋgaraba naŋ a tata. ");
INSERT INTO muy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Nahkay Pol àɗəm kay kay, àhi ahkado : « Cikaba, kîcik jik àna asak gayak ! » Zal dəra ni àra ècia ma ga Pol na ti ècikaba carakum, asawaɗay. ");
INSERT INTO muy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mis dal-dalani ga kəsa ni tàra tìpia ere ya Pol àgray na ti tə̀zlah àna ma həma ga haɗ Likawuni, tə̀ɗəm ahkado : « Melefifit geli tàsləkabiya e melefit ba, tàmbavu mis, tə̀hərkiaya ke leli a ! » ");
INSERT INTO muy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nahkay tə̀zalay Barnabas Zʉs, Pol ti ni tə̀zalay naŋ Hermes, aɗaba naŋ bay məhi ma ana mis. ");
INSERT INTO muy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ahay gəɗakani ge Zʉs ni ti ka ma ga kəsa. Bay misliŋi zlam ana Zʉs ni èŋgʉleɗbiyu kokur àna vay-vay ga zlam, àhəlbiyu àbəhaɗ tay kà mahay ga ahay ni ge misliŋieni ana ata Pol nday ata Barnabas nakəŋ. Mis macakalavani ni day tawayay ti mâgray nahkay. ");
INSERT INTO muy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ndam *asak ni tàra tìcia ere ye ti ndam ga kəsa ni tawayay təgri ana tay na ti tègʉzlehkaba azana ka vu gatay a kwar kwar ga məɗəfiki ana mis macakalavani ti tàwayay ere ye ti atəgri ana tay ni do, mək tàcuhwakivoru ka tay àna zlahay. ");
INSERT INTO muy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tə̀hi ana tay ahkado : « Ndam geli, kəgrum nahkay ti kamam ? Leli ti mis hihirikeni akaɗa kʉli ni timey ! Màra afa gekʉli a ti ga məhi *Ma Mʉweni Sulumani ana kʉli ti kə̂mbrəŋum tʉwi gekʉli masakani akaɗa ya kəgrum nihi ni. Mawayay ti kə̂həŋgrumioru ahàr a haɗ ana Melefit Bay ge sifa ni. Naŋ ti àgraya məlaŋ ya agavəla, haɗ, dəluv gəɗakana akaba zlam ya tə̀vu a huɗ gatay vu ni ɗek. ");
INSERT INTO muy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ahaslani ti àmbrəŋ mis ga haɗ gərgərani ɗek ti tâgray ere ye ti tàwayay ni zlam gatay. ");
INSERT INTO muy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ku tamal nahkay nəŋgu ni, aŋgazlivu ana tay àna zlam sulumani ya agri ana tay ni : asləribiyu avər ana mis e melefit bu ni ti tə̂ŋgətki zlam ka vədaŋ àna sarta gani. Avi zlam məzumani ana tay ti tə̂mərvu. » ");
INSERT INTO muy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ku tamal ndam asak ni tə̀hia ma ana tay a nahkay nəŋgu ni, wuɗaka tə̀cafəŋa mis dal-dalani na kè misliŋi zlam ana tay a ti, tàgraviya daliya dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kələŋ gani ndam *Zʉde ya a Antiyos ya ka haɗ Pisidi ni akaba nday ya a Ikoniyum ni tàra e Listir a. Tàra tìnjia ti tə̀ɗəmki ma magədavani àki ka ndam asak ni, mək mis dal-dalani ni tə̀gəskabá ma gatay na. Eslini mis nakəŋ tìzligi Pol àna akur ga makaɗ naŋ. Tàra tìzligia naŋ a nahkay ti tə̀ɗəm àməta, mək tàgəjahaba naŋ a kəsa ni ba, tə̀mbərbu naŋ ɓəlah. ");
INSERT INTO muy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ay ka ya ti ndam maɗəbay divi ga Yezu ni tə̀cakalakiva nahəma, Pol nakəŋ ècikaba, mək àŋgoru a kəsa ni vu. Hajəŋ gani tàsləka nday ata Barnabas a, tòru e Derbi. ");
INSERT INTO muy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Tòru tìnjʉa e Derbi a ti tə̀hi Ma Mʉweni Sulumani ana mis, nahkay mis kay tàɗəbay divi ga Yezu. Kələŋ gani tàsləka, tàŋga e Listir a. Tàsləka eslina ti tàŋga a Ikoniyum a, mək tàsləka a Ikoniyum a ti tàŋga a Antiyos ya ka haɗ Pisidi na. ");
INSERT INTO muy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A kəsa nday nani bu ni ti tə̀via njəɗa ana ndam maɗəbay divi ga Yezu a. Tə̀hi ana tay ahkado : « Fumki ahàr ka Yezu lala, kə̀mbrəŋum ba. » Tə̀hi ana tay keti : « Tamal mawayay məhuriyani a *Məgur ge Melefit vu ti ahàr àɗəm màcaka daliya dal-dal day kwa. » ");
INSERT INTO muy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tə̀daba gəɗákani e kiɗiŋ ga ndam ya tə̀fəki ahàr ka Yezu ni ba ka kəsa ka kəsa, mək ndam *asak nakəŋ tə̀gəs ndəra akaba tàhəŋgali Melefit ana tay. Eslini tə̀mbrivù tay a ahar vu ana Bay geli, aɗaba nday nani tə̀fəkia ahàr a palam. ");
INSERT INTO muy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kələŋ gani tàsləkaba ka haɗ Pisidi a, tòru ka haɗ Pemfili. ");
INSERT INTO muy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Tòru tìnjʉa e Perzi a ti tə̀hi ma ge Melefit ana mis, mək tàsləka, tòru a Atali. ");
INSERT INTO muy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Eslini ti tə̀cəliyu a *slalah ga yam vu, tàŋga a Antiyos a. A kəsa nani bu ka ya ti tə̀njəki ke tʉwi gatay ni ti, tə̀bivù tay a ahar vu ana Melefit ga magray tʉwi àna sulum gayaŋ. Tʉwi nani ti tìndeveriŋababiya. ");
INSERT INTO muy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Tàra tìnjia nahkay ti tə̀zalakabu ndam məfəki ahàr ka Yezu ni ɗek, tàŋgəhaɗi ere ye ti tàgray àna njəɗa ge Melefit ni ɗek ana tay, tàŋgəhaɗi ana tay ahəmamam Melefit àvi divi ana ndam ya ti nday ndam *Zʉde do ni ga məfəki ahàr ka Yezu ni daya. ");
INSERT INTO muy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Eslini tànjəhaɗ akaba ndam məfəki ahàr ka Yezu ni agray kiyi ɓal. ");
INSERT INTO muy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mis ndahaŋ tàsləka ka haɗ *Zʉde a, tàra a Antiyos a. Tàra tìnjia ti tə̀cahi zlam ana ndam məfəki ahàr ka Yezu ye eslini ni, tə̀hi ana tay ahkado : « Ahàr àɗəm *têkeli kʉɗi ana kʉli akaɗa ge Mʉwiz ya àɗəm a wakita gayaŋ ni bu ni kwa. Tamal kə̀grum akaɗa gayaŋ ya àɗəm ni do ni ti, Melefit àhəŋgay kʉli do simiteni. » ");
INSERT INTO muy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","3","Tàra tə̀ɗəma pakama na nahkay ti ata Pol nday ata Barnabas tə̀gəskabu pakama gani nani ndo simiteni. Nahkay gejewi gəɗakani àhəraya e kiɗiŋ gatay akaba ndam ya tàsləkabiya ka haɗ Zʉde ni ba. Eslini ndam məfəki ahàr ka Yezu ya a Antiyos ni tə̀vi siŋgu ge divi ana ata Pol nday ata Barnabas akaba mis gatay ndahaŋ mək tə̀sləroru tay a Zerʉzalem ga mihindifiŋbiya ma gana kà ndam *asak akaba gəɗákana ye eslini na. Nahkay tàsləka. Ka ya ti tə̀bu takoru ni ti tàsləkaba ka haɗ Fenisi akaba haɗ *Samari a, tàŋgəhaɗi zlam ya àgravu ni ana ndam ga Yezu ya nday tə̀bu ka haɗ nday nani ni ; tə̀hi ana tay ahəmamam ndam ya nday ndam *Zʉde do ni tə̀fəki ahàr ka Yezu ni. Nday nakəŋ tàra tìcia ma ga ata Pol nday ata Barnabas na ti tə̀mərvu dal-dal. ");
INSERT INTO muy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ata Pol nakəŋ tòru tìnjʉa a Zerʉzalem a ti, ndam asak ga Yezu akaba ndam ga Yezu ndahaŋ ni ɗek akaba gəɗákani gatay ni tə̀gəskabu tay. Eslini ata Pol nakəŋ tàŋgəhaɗi ere ye ti tàgray àna njəɗa ge Melefit ni ɗek ana tay. ");
INSERT INTO muy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ay ndam *Feriziyeŋ ndahaŋ ya təfəki ahàr ka Yezu ni tə̀bu eslini. 