﻿USE sofia;
DROP TABLE IF EXISTS sofia.mux_vpl;
CREATE TABLE mux_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mux_vpl WRITE;
INSERT INTO mux_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","⸤Isrel-yambumanga ui-pulu-pulu anda-kolepa⸥ Eprayam kene penga yandupa ⸤eninga yi nuim king auli⸥ Depit kene elsele-ni Yesos Krais kalku liiringli mele i-sipa: ");
INSERT INTO mux_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eprayam-ni Aisak mirim; Aisak-ni Jekop mirim; Jekop-ni Juda kene Juda-nga anginipilima kene mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda-ni Péres kene Sera kene mirim, yi kanuselenga anum Tema; Péres-ni Esron mirim; Esron-ni Ram mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram-ni Aminadap mirim; Aminadap-ni Nason mirim; Nason-ni Sallimon mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sallimon-ni Boas mirim, Boas yunga anum Reap; Boas-ni Opet mirim, Opet yunga anum Rut; Opet-ni Jesi mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi-ni Yi Nuim King Depit mirim. Depit-ni Sollomon mirim. Sollomon-nga anum ui Yuraya-nga ambu-mínele mulurum. Penga Depit-ni ambu kanili numanu monjupa Yuraya topa konjupa ambale yunu liirim. ");
INSERT INTO mux_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sollomon-ni Riapoam mirim; Riapoam-ni Apaya mirim; Apaya-ni Eta mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eta-ni Josipat mirim; Josipat-ni Joram mirim; Joram-ni Asaya mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaya-ni Jotam mirim; Jotam-ni Eyas mirim; Eyas-ni Esikaya mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esikaya-ni Manasa mirim; Manasa-ni Emos mirim; Emos-ni Josaya mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya-ni Jekonaya kene yunga anginipilima kene mirim. Josaya kulupili yunga malupili molangi ele-tu yambuma Isrel-yambuma-kene oku ele teku kene toku munduku, Isrel-yambu pulele ka siku eninga kolea-auli Bapillon meku puring. ");
INSERT INTO mux_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka siku meku puring kene penga Jekonaya-ni Sialtel mirim; Sialtel-ni Serapapel mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapapel-ni Apayat mirim; Apayat-ni Ellayakim mirim; Ellayakim-ni Eso mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso-ni Sedok mirim; Sedok-ni Ekim mirim; Ekim-ni Ellayat mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ellayat-ni Elliesa mirim; Elliesa-ni Matan mirim; Matan-ni Jekop mirim; ");
INSERT INTO mux_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop-ni Josep mirim. Josep Maria yi-min. Josep-ni Maria ui naa liipili Maria yunu kangambula oluna monjupa mulurum. Penga ambu-yisele muluringli kene Maria-ni Yesos mirim. ⸤Pulu Yili-ni “Enini nokupa konjumba yi-nuim te liipu mundumbu.” ui nimba makó turum yili penga Yesos yi akili omba mulurumeliinga⸥ yunga bi te wasie siku kene ‘Kraisele’ niringko. ");
INSERT INTO mux_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Eprayam kene Eprayam-ni yandupa-yandupa kalupa liipa Depit kalupa liipa tirim yima ⸤Yesos-nga⸥ anda-kolepa malapunga tale muluring. Penga Depit-ni yandupa-yandupa ui Bapillon yambuma-ni Juda-yambu mare ka siku kolea Bapillon anju naa meku pangi kalupa liirim anda-kolepa malapunga tale-ko muluring. Juda-yambu mare ka siku kolea Bapillon meku puring kene penga yandupa-yandupa yi-nuim Kraisele kalku liiring kene yi malapunga tale-ko muluring. ");
INSERT INTO mux_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesos, Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele, yunu miring temanele i-sipa mele: Yunga anum Maria-nga pulu lirim yambuma-ni “Maria Josep-ni liipili.” niku kórunga niringeliinga-pe ui Josep wasie tiluna naa piangli Mini Kake Tiliele-ni Maria yunga oluna kangambula te munjunjurumele Maria yunu piliirim. ");
INSERT INTO mux_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Kanu-kene yunga yi Josep yunu yi sumbi-niliele mulurumeliinga Maria kangambula munjurumele piliipa kene ‘Maria pipili naa kulupili.’ nimba ‘Yambu pulele molangi yunu tímu mele nimbu para naa sipu yu-yunu molumba kene kiyang nimbu we “Kamu pui.” niambu.’ nimba piliirim. ");
INSERT INTO mux_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep aku-sipa numanu liipa mundupa mulupili Auliele-nga angkella te-ni Josep uru-kumbu sipa kene nimba mele: “Josep, yi nuim king Depit-ni kalupa liirim yili, Mini Kake Tiliele-ni Maria ulu te tirimeliinga yu kangambula monjulemú akiliinga nu-ni yu liinindu pipili naa kolkunu, lii.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","“Yu kang te membá. Kang kanili-ni yunga yambuma ‘Eninga numanuna ulu-pulu-kis telemelema pípili molemeláliinga mindili nungí.’ nimba enini tepa liipa, mindili nolkemela kupulanum-na wendu liipa, yunu-kene wasie molku kunjingí kupulanum-na liipa monjumbaliinga yunga bi lekunu “Yesos” niani.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Aku-sipa wendu urum ulumanga pali kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te-ni ulu mare penga wendu ombá ui nirim mele kamu wendu urum. Akili i-sipa mele: ");
INSERT INTO mux_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Piliai. Ambu-wenipu te-ni kangambula monjupa kene kang te membá. Kanu-kene yunga bi leku “Imanuel” ningí.” nirim. Bi ilinga ung-pulele ‘Pulu Yili oliu-kene molemú’. ");
INSERT INTO mux_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep uru pepa makiliipa kene Auliele-nga angkellale-ni nirim mele piliipa liipa tepa kene ambale liirim. ");
INSERT INTO mux_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Akiliinga-pe yu kangambulale ui naa mipili tiluna naa piringli. Penga Maria-ni kangale mirim kene Josep-ni kangale bi lepa “Yesos” nirim. ");
INSERT INTO mux_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Erot yunu kolea Judia distrik yambumanga yi nuim kingele mulupili Maria-ni kolea Judia, Betelliem taon-na Yesos mirim. Ena kanumanga ena ola ulikundu piliipa kungnjuli pili yi mare taki-taki kombukantupuna ‘ulu-pulu mare wendu ombánje?’ niku mimi-siku kanuku muluring yima kolea-auli Jerusallem oku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Juda-yambumanga yi nuim king molumba kang miring akili tena molemúye? Oliu ena ola ulikundu molupu kene yi te yi nuim king molumba miringele liipa ora sili kombukantupale pulu-pulu wendu omba angiliirim-na kanupu kene, yu popu topu bi paka tonjumulundu okomulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yi nuim king Erot-ni ung ili piliipa kene ‘Yi te yu alko topa king molumba lam.’ nimba piliipa kene yu mini-wale mundurum, Jerusallem yambuma pali mini-waleko munduring. ");
INSERT INTO mux_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kanu-kene yu-ni Juda-yambumanga Pulu Yili popu tunjuring yi-aulima pali kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima pali kene “Sukundu wai.” nimba kene enini walsipa piliipa kene nimba mele: “Pulu Yili-ni ‘Enini nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele tena mingélendu niringiye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Enini yunundu niku mele: “Kolea Judia distrik sukundu Betelliem taon-na yu mingí. Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi ⸤Maika-ni⸥ penga aku-sipa wendu ombá mele ui buk turum akuna molemú kanili. Yu-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betelliem, Juda koleana lelemú kolea te, yu kolea Juda sukundu kolea-aulimanga yu kolea kepe auli te-ko. Yunga sukundu yi-nuim auli te wendu ombá, yi akili-ni nanga Isrel-yambumanga kung-sipsip tápu-yili molupa enini nokumba.” nirim kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kanu-kene we-yambuma naa kanuku piliiku molangi Erot-ni piliipa kungnjuli pili yima “Wai.” nimba kombukantupale pulu-pulu wendu omba angiliirim enale walsipa piliirim kene yunundu niku siring mele ");
INSERT INTO mux_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","piliipa kene eninindu nimba mele: “Eni Betelliem puku kangale mimi-siku koro-pai! Kanuku liiku kene na oku niku sai. Na kepe yu ombu popu topu bi paka tonjambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kingele-ni aku-sipa nirim piliiku kene enini kelku puku kano-puring. Kanu-kene ena ola ulikundu molku kene kombukantupu kanuringele enini puringna kumbi-lepa pumba pupa kene kangale mulurum lku-imuna pupa ola angiliirim. ");
INSERT INTO mux_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Enini kombukantupale kanuku kene numanu aima lakuku siring. ");
INSERT INTO mux_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lkuna lkundu puku kene kangale kene anum Maria kene muluringlina puku kanuku liiring. Kanuku kene kangalenga kumbi-kerina koporungu languku ma kanuku kene yu popu toku bi paka tunjuring. Bi paka tonjuku kene enini wale meku uringma apisiku méle kaíma wendu liiku yu siring. Ku-gollu talse kene, paura kalemele kene mura tuli paura akiliinga te kene, kopungu-wel aima mura tuli te kene, méle akuma yu siring. ");
INSERT INTO mux_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kanu-kene Pulu Yili-ni enini uru-kumbu sipa kene eninindu nimba mele: “Eni Erot molemúna kelku pu naa pai, mólu!” nirim piliiku kene enini kupulanum tenga-lupa oku lkundu puring. ");
INSERT INTO mux_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kanu-kene piliipa kungnjuli pili yima kelku puring kene Auliele-nga angkella te-ni Josep uru-kumbu sipa kene nimba mele: “Yi nuim king Erot-ni nondupa yunga ami-yimandu ‘Kangale koruku toku konju-pai!’ nimbá akiliinga nu ola molkunu kangale kene anum kene liikunu mekunu kolea Isip-ndu takara toku puku molu-pai. Ne anju molku kene, penga na-ni ‘Kelku yandu wai.’ nimbú kene wangi. Ui mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aku nirim-na piliipa kene Josep ola molupa sumbulsuli anum-málusele liipa memba Isip-ndu purum. ");
INSERT INTO mux_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","‘Erot kolumba kene kelepu lkundu pumulú.’ niku ui Isip anju muluring. Aku tiringeliinga Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi ⸤Osia⸥-ni ulu te penga wendu ombá ui nirim mele kamu wendu urum. Akili i-sipa mele: “Pulu Yili-ni nimba mele: ‘Nanga kangale “Kolea Isip munduku kelkunu wendu ui.” nirindu.’ nirim.” nimba yi ⸤Osia⸥ kanili-ni aku-sipa nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kanu-kene anum lapasele Yesos wasie Isip puku molangi, piliipa kungnjuli pili yima-ni Erot yunu liiku lu siring mele piliipa kene Erot yu-ni arerembi aima lakupa kulurum. Arerembi kolupa kene ami-yi marendu nimba mele: “Betelliem taonale kene Betelliem nondupa lelemú kolea kanumanga puku kang punie tale omba puli kangma kene punie tale naa pora nili kangma kene pali koruku toku konju-pai!” nirim. Kombukantupu kanuku piliipa kungnjuli pili yima-ni kombukantupale pulu monjupa wendu omba angiliirim enale yunundu niku siring mele piliipa kene punie aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aku-sipa tirimeliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Jeremaya-ni ulu te penga wendu ombá nimba ui nirim mele wendu urum. ");
INSERT INTO mux_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Yu-ni nimba mele: “Enini kolea Rama sukundu ung te piliiring; kola tiring piliiring akili, yambu kolemele kene kola telemele mele kola aku-siku tiring piliiring. Ambu Resel-ni yunga kangambulamanga kola tirim. Yu ‘Numanu waengu nipili.’ niku kene tiringeliinga-pe ‘Naa piliimbu.’ nimba yunga kangambulama kolku pora siring, te naa mulurum akiliinga yu kondu kolupa kola tepa mindi mulurum.” nimba Jeremaya-ni ui aku-sipa nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Penga Erot kulurum kene Auliele-nga angkella te-ni Josep kolea Isip mulupili uru-kumbu sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“‘Kangale toku konjangi koro-pai.’ nirim yili kulurumeliinga ola molkunu anum málu-sele liiku mekunu kolea Isrel-ndu kelkunu pui.” nirim kene-na ");
INSERT INTO mux_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","piliipa kene yu ola molupa anum málu-sele liipa memba Isrel-ndu purum. ");
INSERT INTO mux_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Akiliinga-pe Akelles yunga lapa Erot alko topa yi nuim kingele molupa kolea Judia distrik nukurum akili piliipa kene Josep yu kanuna alsupa pumbandu mundu-mong tirim. Kanu-kene Pulu Yili-ni uru-kumbu sipa kene nimba mele: “Marena tungí akiliinga akuna naa pui.” nimba yunundu lip-lipi turum kene yu kelepa kolea Gallalli distrik pupa ");
INSERT INTO mux_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","akuna lirim Nasaret taon-na pupa mulurum-na Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni ⸤Yesos-kene⸥ ulu te penga wendu ombá niku ui niring mele kamu wendu urum. Enini niku mele: “Yambuma-ni yu bi leku ‘Yu Nasaret taon yi te.’ ningí.” niring kanili. ");
INSERT INTO mux_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","⸤Yesos Nasaret taon-na we mulupili⸥ No-Liinjili Jon omba kolea Judia distrik sukundu kolea-wakana ele-ung nimba kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Pulu Yili yi nuim kingele molumba enale nondupa wendu ombá tekemaliinga eninga ulu-pulu-kis tiring numanuna pelemúma munduku kelku numanu topele tai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yi kanili ⸤ui naa mulupili aima kórunga-ui⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni Pulu Yili-nga ung te nimba sipa buk turum. Ung kanili i-sipa mele: “Kolea-wakana yambu tenga kerina ung te nimba mele: “Auliele ombá kupulanumele teku mimi tenjai. Yu ombá kupulanum kelúma toku sumbi sai.” nikem.” nirim. ⸤Jon-ni aima penga temba mele Asaya-ni ui aku-sipa nimba panjipa buk turum.⸥ ");
INSERT INTO mux_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon yu kung-kemel dili-ni tili wale-pakuli te pakupa, kung kiluele-ni tili kamirika te topa kene, kuli-kumba kene pillim-nóma kene langi akusele mindi nomba mulurum. ");
INSERT INTO mux_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kanu-kene kolea-auli Jerusallem yambuma kene Jerusallem lirim kolea Judia distrik pali yambuma kene kolea Jodan pali yambuma kene yi kanili mulurumna puku kene, ");
INSERT INTO mux_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","no Jodan sukundu puku kene ulu-pulu-kis tiringma niku para siring kene yu-ni enini no liinjirim. ");
INSERT INTO mux_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yu-ni ⸤Juda-yambumanga yi-auli⸥ Perisima kene Sadusima kene yi pulele no liingíndu uring kanupa kene, enini ung-mura sipa nimba mele: “Gólu topa yambuma tepa kis-sili wambiyelenga walúma, Pulu Yili arerembi kolumba enaliinga nae-ni “Eni takara toku pai.” nim-na enini ‘Pulu Yili-ni naa tepa kis-sipili.’ niku ‘No liimulú.’ niku okumeleye? ");
INSERT INTO mux_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Eni sumbi-siku molku, ulu kaíma mindi teku mulungí kene eni ulu-pulu-kis tiringma aima sika munduku kelku numanu topele tungí mele mokeringa lemba. ");
INSERT INTO mux_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Oliu anda-kolepa Eprayam-ni kalupa liirimuma molemuláliinga yambu kaíma molemulu.” niku aku-siku niku naa piliai. Na-ni eni nimbu siker: “Pulu Yili-ni ku-mulú imandu “Eprayam-ni kalupa liirim yambuma au talangi.” nilkanje ku-mulúma Eprayam-ni kalupa liirim yambuma molkemela.” niker. Eni Eprayam-ni kalupa liirim yambuma molemeláliinga ulu te naa telemú. ");
INSERT INTO mux_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Unji peki tomba luli Pulu Yili-ni kórunga unji-puluna ambulupa ola liipa molemú. Unji-mong kaí naa tombama yu-ni peki topa kene tepina kalomba. ");
INSERT INTO mux_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ulu-pulu-kísima kanuku kis piliiku numanu topele tolemele yambuma na-ni sika no liinjiliu. Akiliinga-pe yi te aelepa ombále yu-ni ⸤Pulu Yili-nga⸥ Mini Kake Tiliele kene tepéle kene eni liinjimba ⸤liingí⸥. Na kene aelepa ombá yi ili yunga tondulale aima olandupa, nanga tondulale aima mania-kilia. Na yunu-kene kapula mólu. Yambu-aulimanga kongun kis tili kendemande-yambuma-ni sika eninga aulimanga kongun kísima tinjingíndu kimbu-suma wendu liinjilimele akiliinga-pe na-kene aelepa ombáliinga kimbu-su wendu liinjimbu kongun kanili aima olandupa mele na-ni kapula naa tenjilka, ⸤na yi aima kisele⸥. ");
INSERT INTO mux_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Yu-ni yunga rais-wit apuruli apulu-pokale ambulupa kene yunga rais-wit monguma kene rais-wit kiluma kene apurumbandu molemú. Yunga rais-wit apuruli polale tepa mimi tembandu rais-witma pali apurupa wendu liipa kene monguma liipa rais-wit nosilimú lkuna ‘Lipili.’ nimba nosimbandu lku liipa nosupa, penga kiluma liipa máku topa tepi naa kumbulupa nomba pepa mindi pulimúna kalomba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","⸤Jon-ni yambuma no liinjipa mulurum⸥ kene Yesos kolea Gallalli distrik mundupa kelepa kene, ‘Jon-ni yu no liinjipili.’ nimba Jon no-Jodan kéluna mulurumna yu purum. ");
INSERT INTO mux_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Urum kene Jon-ni nimba mele: “Akili aima mólu. Na-ni nu nambi-sipu no liinjambu nikunu nikinuye? Nu-ni na no liinjilkenanje kapula.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Akiliinga-pe Yesos-ni pundu topa nimba mele: “Mólu. Ulu kake tili uluma pali kapula tipili akiliinga niker mele ti.” nirim. Kanu-kene Jon-ni “Kapula.” nimba yu no liinjirim. ");
INSERT INTO mux_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesos no liipa pora sipa kene nona sumbi-sipa wendu urum. Wendu ombá urum kene muléle takape nimba anju-yandu purum, Pulu Yili-nga Minéle, kera-waembonu mele, mania omba Yesos mulurumna pupa ⸤kangina⸥ ola mulurum kanurum. ");
INSERT INTO mux_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kanu-kene mulúna ola ung te wendu omba kene nimba mele: “Ili nanga numanu monjuliu kangale. Yunu-kene numanu siliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesos ⸤no liirim kene Pulu Yili-nga Minéle yu-kene omba molupa kene,⸥ Minéle yu-ni ‘⸤Kurumanga nuim⸥ depollale-ni yu kundi tupili.’ nimba Yesos kolea-wakana memba purum. ");
INSERT INTO mux_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Akuna Yesos kaliimbu te kóru tale mele langi naa nuli we molupa pirim kene yu engle-ni kolupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kanu-kene kundi tuli ⸤kuru Seten⸥ omba kene yundu nimba mele: “Nu Pulu Yili-nga Málale lem ku-mulú ima ‘Pllawa kaluli au talupili.’ ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Akiliinga-pe yu-ni pundu topa kene nimba mele: “Pulu Yili-nga bukele-ni nimba mele: ‘Langima-ni mindi yambuma kona mululi ulu-pulele naa silimú. Pulu Yili-ni ung nilimúma pali piliiku liiku teku mulungí kene kona mululi ulu-pulele liingí.’ nimba molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kanu-kene depollale-ni Yesos liipa kolea-auli Jerusallem, akilindu ‘kolea-auli kake tili’ niliele, akuna memba pupa, Pulu Yili popu toku kaluring lku-temboll imuna memba, aima ola pupa monjupa kene, ");
INSERT INTO mux_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yundu nimba mele: “Nu Pulu Yili-nga Málale lem nu tepa liimba akiliinga pu-nikunu mania pui.” ⸤nirim.⸥ “Pulu Yili-nga bukele-ni nimba mele: ‘Pulu Yili yunga angkellama-ni ‘Nu oku nokai.’ nimbá. Enini nu ‘Ku te-ni kepe naa tupili.’ niku nu eninga kima-ni oku kanglku liingí.’ nimba molemú kanili. Aku-sipa nirimeliinga piliiku kene aku-sikunu ti.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesos-ni yundu nimba mele: “Pulu Yili-nga yambumandu ung te wasie nimba molemúko. Akili i-sipa mele: ‘Pulu Yili eninga Auliele-ni “Tembu.” nilimú mele ‘Sika nilimúnje mola gólu tolemúnje kanamili.’ niku eni yu manda leku naa teai.’ nimba molemúko kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Alsupa depollale-ni yu liipa ma-pangí te aima ola-kilia lirimna memba ola pupa monjupa kene, yu ma-koleama pali kene koleamanga méle kaíma wasie liipa ora sipa kene ");
INSERT INTO mux_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","yundu nimba mele: “Nu nanga kumbi-kerina koporungu languku mania molkunu na popu tokunu nanga bili paka tunjúnu lem nu ma-koleana méle lelemú kanokunu ima pali nu simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kanu-kene Yesos-ni yundu nimba mele: “Seten, nu anju pa! Pulu Yili-nga bukele-ni nimba mele: ‘Pulu Yili eninga Auliele mindi niku popu toku bi paka tonjuku, yunga kongunuma mindi tenjiku molai.’ nimba molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kanu-kene depollale-ni Yesos yu mundupa kelepa yu purum. Purum kene ⸤mulú-koleana⸥ angkellama-ni oku Yesos nukuring. ");
INSERT INTO mux_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kanu-kene ⸤No-Liinjili⸥ Jon ka siku ka-lkuna panjiringele piliipa kene Yesos kelepa kolea Gallalli distrik-ndu yandu omba ");
INSERT INTO mux_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaret taon-na omba kene, penga taon akili mundupa kelepa Kapeniam taon, numú-Gallalli kéluna lirim, akuna pupa ‘Ekupu kolea ili nanga kamu molumbu koleale lipili.’ nimba akuna mulurum. Kapeniam yi Sepullan kene Naptallai-seleni kalku liiringli yambuma ui muluring koleana lirim. ");
INSERT INTO mux_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","⸤Kapeniam taon-na pupa mulurumeliinga⸥ kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni ulu te penga wendu ombá ui nirim mele kamu wendu urum. Asaya-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepullan-ni kalupa liirim yambuma pelemelé koleale kene, Naptallai-ni kalupa liirim yambuma pelemelé koleale kene, no-numúna lepa pulimú kupulanumele no-Jodan nekendu lelemú koleale kene, kolea Gallalli wikindu yambu-lupa pulele molemele koleale kene, kolea akumanga molemele yambuma ⸤aima sumbulú túlina molemele⸥. ");
INSERT INTO mux_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yambu aima sumbulú túlina molemele kanuma talang tondulu aima auli te kanuring. Kululi ulu-pulele-ni panda topa sumbulú tuli koleana pelemelé yambumanga koleana talang pukum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","⸤Kapeniam omba mulurum⸥ ena kaniliinga Yesos-ni yambuma pulu monjupa ungma nimba sipa kene nimba mele: “Pulu Yili yi nuim kingele molupa nokumba enale nondupa wendu ombá tekemaliinga ⸤‘Pulu Yili yu-ni nokumba yambumanga talapena sukundu molamili.’ niku⸥ ulu-pulu-kis telemelema munduku kelku numanu topele tai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesos Numú-Gallalli kéluna andupa kene anginingli tale kanurum, akusele Saimon kene angin Endru-sele oma liili wale te no-numúna toku suku munduku muluringli kanurum. Penga Saimon-nga bi te Pita niringko. Oma liiringli akili elsengla ku-moni kongunale tiringli. ");
INSERT INTO mux_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","⸤Aku-siku teku muluringli kanupa kene⸥ nimba mele: “Na lumbili wangli. Oma liinglíndu oma liili wale te liiku nona suku mundulimbili kene omama walena omba pelemú mele, penga ‘nanga kongunale tinglíndu nanga ungele piliikulu niku silsiliiku andunglí kene yambuma nanga talapena sukundu oku molangi.’ nimbu ‘Else na lumbili wale.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","⸤Aku nirim mele piliikululiinga⸥ lkisikulu elsengla oma liili walema munduku kelkulu kene Yesos lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kanu-kene yu laye-kolte anju pupa kene anginingli tale lupa kanurum, akusele Seperi málu Jemis kene Jemis angin Jon-sele, lapa Seperi kene eninga nona anduli sipna sukundu oma liili walema toku tambulku muluring kanupa kene elsele walsipa kene “Na lumbili wale.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aku nirim mele piliikulu kene elsengla lapa Seperi kene nona anduli sipele kene lkisikulu munduku kelkulu kene Yesos yu lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kanu-kene Yesos kolea Gallalli distrik sukundu koleamanga pali andupa, Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkumanga lkundu pupa yambuma ung-bo tonjupa, Pulu Yili nondupa yi nuim kingele molupa nokumba mele temani kaiéle topa sipa, yambu kuru lupa-lupa turum-ma kene kangina ulu pulele tirim-ma kene tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yu-ni tirim mele temanele kolea Siria propinj koleamanga pali anju-anju purum piliiku kene eninga yambu kuru lupa-lupa turum yambuma kene, mindili lupa-lupa noku muluring yambuma kene, yambumanga numanuna kuru molku ambuluring yambuma kene, kuru-kopari turum yambuma kene, kimbu-ki kukurum yambuma kene, yu mulurumna meku uring kene yu-ni yambu kanuma tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yambu aima pulele yu lumbili puring. Kolea Gallalli distrik yambuma kene, ‘Kolea-Auli Rurepunga Tale’ niring kolea yambuma kene, kolea Judia distrik lirim kolea-auli Jerusallem yambuma kene, kolea Judia sukundu lirim we-koleamanga muluring yambuma kene, no Jodan nekendu koleamanga yambuma kene, aima pulele yu lumbili puring. ");
INSERT INTO mux_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesos-ni yambu pulele liiku máku toku yu lumbili puringma kanupa kene ma-pangina ola pupa mania mulurum kene yu lumbili andúlima yu mulurumna uring. ");
INSERT INTO mux_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kanu-kene yu-ni enini ung-bo tonjupa ung-mani sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Yambu numanuna korupa pulimú piliilimili yambuma Pulu Yili eninga yi nuim kingele molupa enini nokulemáliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Yambu kola teku numanu kis pípili molemele yambuma Pulu Yili-ni “Enini numanu kaí pepa toembu tupili.” nimbáliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Yambu táka-niku molku yambu lupamanga ungma piliiku molemele yambuma ma-koleama pali Pulu Yili-ni enini simba liingéliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Pulu Yili-ni “Teai.” nilimú ulu sumbi nílima tingíndu waka kolku molemele yambuma kapula mulungéliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Yambu lupama kondu kolemele yambuma Pulu Yili-ni kondu kolumbaliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Yambu numanu kake tipili molemele yambuma-ni Pulu Yili kaningéliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“‘Yambuma numanu tiluna pupili molangi.’ nilimele yambuma Pulu Yili-ni ‘Enini nanga kangambulama.’ nimbáliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pulu Yili-ni “Teai.” nilimú ulu sumbi nílima teku molemeláliinga yambu lupama-ni enini mindili silimele ⸤akiliinga⸥ Pulu Yili eninga yi nuim kingele molumbáliinga enini “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Na piliiku molemele yambuma, eni nanga yambuma molemeláliinga we-yambuma-ni eni ung-taka tonjuku mindili siku, ung kis lupa-lupama eninga bulkundu gólu toku ninjingí kene eni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","⸤Yambuma-ni eni aku-siku mele telemeláliinga⸥ eni mulú-koleana pungí kene kanuna Pulu Yili-ni eni méle kalupa konjumbaliinga numanu aima lakuku siku numanu kaí pípili molai. Yambuma-ni ekupu eni mindili silimele mele aku-siku eni naa molangi kóru-ui Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku silsiliiku anduring yambuma we-yambuma-ni enini kepe mindili siringko kanili.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Eni ma-koleana yambumanga api-kusa mele molemele. ⸤Akili méle kaí⸥ akiliinga-pe yu sungu naa temba kene ‘Yu kelepa sungu tipili.’ nimbu ulu te kapula temulúye? Yu kongunale temba tondulu te alsupa naa pembaliinga we topu mundupu kelemulú kene yambuma-ni anduku kambiliingí kene kapula. ");
INSERT INTO mux_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Eni ma-koleana yambumanga talang pa tinjílima molemele. Kolea-auli te ma-pangina ola lembale kapula mo naa tomba. ");
INSERT INTO mux_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yambuma-ni tepi-llam kanduku kene mingina suku naa monjulemele. ‘Lkuna sukundu pa tipili, mélema kanangi.’ niku ⸤talang pa tinjili⸥ tepi-llam akili polu tenga ola monjulemele. ");
INSERT INTO mux_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aku-sipa mele ‘Oliu-ni ulu kaíma telemulu mele yambuma-ni kanuku kene oliunga Lapa, mulú-koleana molemále, kape niangi.’ niku, eni-enini eninga pa telemú talang akili yambuma-ni kanangi.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Na-ni ‘Pulu Yili-nga ung-manima ⸤Moses-ni⸥ bukna turum ungma kene Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni bukna turing ungma kene ‘mania pupili.’ nimbá okum.’ niku naa piliangi. Na-ni ‘ung kanuma kamu mania pupili.’ nimbú naa okur. ‘Ung akumanga ung-pulu pelemúma kamu wendu upili.’ nimbú okur. ");
INSERT INTO mux_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na-ni enindu aima sika niker: “Mulú-masele ui pora naa nipili Pulu Yili-nga ung-mani ⸤Moses-ni bukna tunjurum⸥-manga ung wallú-kolte kepe aima te mania naa pumba. Ung-manimanga pali ung auli kelúmanga pali kongunuma ui wendu ombá.” niker. ");
INSERT INTO mux_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Akiliinga, yambu te-ni Pulu Yili-nga ung-mani kanumanga ung-mani wallú te kepe “Naa tembu.” nimba mundupa kelepa, yambu lupama mani sipa kene “Munduku kelai.” nimbá yambale Pulu Yili yi nuim kingele molupa nokulemú koleana yunga bili aima mania pemba. Akiliinga-pe yambu te-ni ung-mani kanuma piliipa liipa tingí panjipa molupa, yambu lupama mani sipa ung-bo tonjumba yambale Pulu Yili yi nuim kingele molupa nokulemú koleana yunga bili aima lakupa molumba. ");
INSERT INTO mux_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na-ni enindu nimbu siker: “Perisi-yima kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjilimele yima kene enini ulu sumbi-nílima telemele ulumanga olandupa eni we-yambuma-ni naa tíngi lem, Pulu Yili yi nuim kingele molupa yambu nokulemú talapena sukundu eni aima naa puku mulungí.” niker. ⸤Yi kanuma-ni ung-manima piliiku kene telemele mele lupa. Pulu Yili-ni kanupa ulu sumbi-nílima nimba kanolemú mele lupa.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kóru-ui ⸤Moses-ni “Ulu mare i-siku teai! Mare i-siku naa teai!” nimba⸥ anda-kolepalimandu ung-manima sirim-manga te eni piliilimili. Ung-mani kanili i-sipa mele: “Eni yambuma toku naa konjai. Yambu topa konjumba yambale kot-na liiku angnjiku “Yu pundu tupili.” niku buni singí.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Akiliinga-pe ekupu na-ni eni ung-mani kaniliinga ung-pulele i nimbu simbu teker: “Yambu te-ni yunga angin kene arerembi kolumba yambale willis-kot-na liiku monjuku “Yu pundu tupili.” niku buni singí.” niker. Yambu te-ni yunga angin-ndu ung-taka tonjupa “Nu kamakaleye?” nimbá yambale propinjel-kot-na meku puku kot tinjingí. Yambu te-ni yambu te-ndu “Nu aima wilie kelepa tuliele!” nimbá yambale tepi-koleana pumba. ");
INSERT INTO mux_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Aku-siku tingí yambuma buni mingéliinga nu-ni ‘Pulu Yili-ni na kanupa kaí piliipili.’ niku yunga mélema tepina kaluli poluna Pulu Yili kung mola kera popu toku kalku sinindu meku okunu kene nunga angenele-ni nu-kene we arerembi te kolumba piliikunu kene, ");
INSERT INTO mux_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nu Pulu Yili kalku sini mélema Pulu Yili popu toku kaluli polu alse punduna we lipili nosukunu kene kelku anju pukunu angenandu “Tiluna kapula-kapula molambili.” nikunu puku nikunu mele, penga kelku okunu nu Pulu Yili kaluní mélema okunu yu kalku sani. ");
INSERT INTO mux_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu kot tenjimba temba yambale ‘Kapula-kapula molambili ulu te teambu.’ nikunu kene wela ti. Aku naa tinu lem nu kot tenjimba yambale-ni nunga kot piliili yili molumbana memba pupa simbanje. Pe kot piliili yili-ni nu ka-lku nukuli yili liipa simba, yu-ni nu ka-lkuna liipa mundumba. ");
INSERT INTO mux_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na-ni nundu aima sika nimbu siker: “Nu ka-lkuna wendu uníndu pundu aima pali tokunu kene mindi wendu uní. We kapula wendu naa uní.” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“⸤Ui Moses-ni⸥ ung-mani te sirimele eni piliilimili. Ung-mani kanili i-sipa mele: ‘Ambu yi púlima yi lupama kene waperanale naa teku, yi ambu líílima ambu lupama kene waperanale naa teai.’ nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Akiliinga-pe ekupu na-ni eni ⸤ung-mani kaniliinga ung-pulele⸥ i nimbu siker: “Yi te-ni ambu te kanupa kene ‘Yu kene wasie tapú-topu pelkumbulanje kapula.’ nimba numanuna piliilimú akili numanuna sukundu ambale kene kamu waperanale telemú.” niker. ");
INSERT INTO mux_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Nunga mongsele-ni méle te kanukunu kene numanale-ni ‘Liambuka.’ niku piliikunu ulu-pulu-kis te tinu lem mongsele ukuku wendu mundui. Nunga mongsele angiliipili nu tepi-koleana liiku mundungí kene kapula naa tembaliinga kangieliinga méle te wendu liiku munduku kelkunu kene molkunu kunjini kene kapula. ");
INSERT INTO mux_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nunga ki-sele-ni ulu-pulu-kis te tinu lem ki-akusele kari leku wendu mundani. Nunga ki-sele angiliipili nu tepi-koleana liiku mundungí kene kapula naa temba akiliinga kangieliinga méle te wendu liiku munduku kelkunu kene molkunu kunjini kene kapula.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“⸤Ui Moses-ni⸥ ung-mani te sipa kene nimba mele: “Yi te-ni yunga ambalendu ‘Kamu pupili.’ nimba makorombandu ambale “Kamu pui.” nimbá mele pepá te topa ambale sipa kene yundu “Kamu pui.” nimba aku tipili.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Akiliinga-pe na-ni ekupu eni nimbu siker: “Yi puli ambu te yi te kene waperanale naa tipili yunga yili-ni yu makurupa “Kamu pui.” nim lem ‘Waperanale tili ambale mulupili.’ nimba aku telemú. “Pui.” nimba topa makorolemú ambale pe yi te-ni yu liilimú kene yi kanili kepe waperanale telemú-ko.” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kóru-ui ⸤Moses-ni⸥ anda-kolepalimandu ung-mani te wasie sirimele eni piliilimili. Ung-mani kanili i-sipa mele: ‘ “Aima sika tembu.” niku, niku panjiku mi lingí ungele karaye naa teai. Auliele-ndu “Aima sika tembu.” niku, niku panjiku mi lingí mele aima sika aku-siku teai.’ nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Akiliinga-pe ekupu na-ni eni nimbu siker: “‘ ‘Aima sika nikem.’ niku piliangi.’ niku méle auli tenga bi leku aima mi naa leai. Mulú-koleale kepe bi leku mi naa leai. Kolea akili Pulu Yili molupa mélema nokulemú koleale, akiliinga aku naa teai.” niker. ");
INSERT INTO mux_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma-koleale kepe bi leku mi naa leangiko. Akili Pulu Yili yunga kimbele mundulimú polale kanili. Jerusallem kepe bi naa-ko leai. Akili Yi Nuim King Aima Auliele-nga kolea-auliele kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nunga pengale kepe. Akili nu-ni pengi-di te ‘Kake tipili.’ mola ‘Pombera tupili.’ niku ulu te kapula naa tinéliinga pengale walsiku bi leku mi naa leai. ");
INSERT INTO mux_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ulu te sika tiní lem sumbi-sikunu “Tembu.” ni. Naa tiní lem “Naa tembu.” ni. Ulu-kisimanga pali ulu-pulele pelemú ⸤kur⸥ale-ni ambululemú yambuma-ni mindi ung sulu teku nilsiliiku puku mi lelemele.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“⸤Ui Moses-ni⸥ ung-mani te sirimele eni piliilimili. Ung-mani kanili i-sipa mele: “Yambu te-ni yambu tenga mong te topa ukunjumba kene yunga mongale toku ukunjangiko. Yambu te-ni yambu tenga gu te topa langonjumba kene yunga gule toku langonjangiko.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Akiliinga-pe ekupu na-ni eni nimbu siker: “Eni tepa kis-simba yambale anju ulu te naa teku, ‘We tepa kis-sipili.’ niai. Yambu te-ni nunga kumbi-keri ekendunga lkarauwa-ni tomba kene topele toku ‘Ekendunga kamu lkarauwa-ni tupili.’ ni.” niker. ");
INSERT INTO mux_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Yambu te-ni ‘Nunga wale-pakuliele liambu.’ nimba kot tenjimba temba yambale nunga wale sulu kaiéle kepe ‘wasie we liipili.’ ni. ");
INSERT INTO mux_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","⸤Rom-ami-⸥yi te-ni nu ambulupa kene “Nu-ni na liiku tapunjukunu makó tenga ⸤nanga mélema menjani⸥ pambili.” nimbá kene makó tenga wasie yu we liiku tapunjukunu mélema menjikunu pui. ");
INSERT INTO mux_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Méle te si.” nimba mawa temba yambale mawa temba mélale we si. “Ku-moni te pundu monjukunu si.” nimbá yambale “Mólu.” naa ni.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“⸤Ui Moses-ni⸥ ung-mani te sirimele eni piliilimili. Ung-mani kanili i-sipa mele: “Ele-lkeramale numanu monjuku, ele-túli kanuku kis pilíí.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Akiliinga-pe ekupu na-ni eni nimbu siker: “Eni eninga ele-túma numanu monjuku, eni teku kis-silimele yambuma ‘Pulu Yili-ni nokupa kunjupili.’ niku Pulu Yili eninga niku mawa tenjai. ");
INSERT INTO mux_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‘Eninga Lapale mulú-koleana molemáliinga kangambulama molamili.’ niku aku-siku teai.” niker. Yu-ni yambu kis kaíma molemelena ‘Ena tupili.’ nilimú. Yambu ulu sumbi-nílima telemele yambuma kepe yambu ulu sumbi-nílima naa telemele yambuma kepe eninga wasie pali ‘Lo tupili.’ nilimú-ko. ");
INSERT INTO mux_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Eni numanu monjulemele yambuma mindi numanu monjulemele kene Pulu Yili-ni kanupa kaí piliimbaye? ⸤Rom-gapman⸥ ku-moni-takis liilimele yambu ⸤kis⸥ma kepe anju-yandu aku-ko telemeláliinga ⸤eni kanuku kis piliilimili yambuma wasie numanu munjingí kene kapula⸥. ");
INSERT INTO mux_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Eni eninga pulu lelemú yambumandu mindi “Eni kapula molemeleye?” nilimele kene we-yambuma-ni telemele mele mania-kilia, eni telemele mele olandupaye? Ulsukundu yambuma-ni aku-sikuko naa telemeleye? ");
INSERT INTO mux_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akiliinga ⸤Moses-ni sirim ung-manima we piliiku naa teku,⸥ eninga Lapale mulú-koleana molemú yi aima sumbi-niliele molemú mele eni aku-siku yambu sumbi-nílima molai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","⸤Yesos-ni ung mare nimba molupa kene ung mare wasie nimba mele:⸥ “‘Yambuma-ni ‘Oliu yambu aima kaíma. Uluma aima tepu konjulimulu.’ niku kanangi.’ niku yambuma kanuku molangi eninga ulu kaíma aima naa teai. Aku-siku tingí kene yambuma-ni eni kape ningí. Kape ningí ung kanuma eninga méle kaluliele liingéliinga eninga mulú-koleana molemú Lapale-ni eni méle naa kalomba. ");
INSERT INTO mux_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“⸤Eninga mulú-koleana molemú Lapale-ni aku-siku tingí yambuma méle naa kalomba⸥liinga eni yambu korupa púlima kondu kolku ‘Liipu tapunjamili.’ niku ku-moni te singíndu ‘Temulú mele yambuma-ni kanangi.’ niku, nangale toku niku méle te naa sai. Topele-mapele tuli yima-ni ‘Na yambuma-ni kape niangi.’ niku yambuma máku toku Pulu Yili-nga ungele piliili lkumanga kene kupulanumumanga kene we-yambu pulele-ni mongale-ni kanangi yambu-korupama liiku tapunjulemele. Yi akuma-ni telemele mele eni aku-siku naa teai. Na-ni enindu aima sika nimbu siker: “Aku telemeláliinga enini yambuma-ni kape nilimele ungma eninga méle kaluliele kórunga liilimele.” niker. ");
INSERT INTO mux_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Akiliinga-pe eni yambu-korupama kondu kolku méle te singíndu ‘Yambuma-ni aima naa kanangi. Yambu te wasie tapú-topulu andolembulále-ni kepe naa kanupili, mo topu kiyang nimbu liipu tapunjambu.’ niai. ");
INSERT INTO mux_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kanu-kene yambuma-ni naa kanangi, tingí mele yambu te naa niku siku kene korupa puli yambu te liiku tapunjungí kene eninga ⸤mulú-koleana molemú⸥ Lapale-ni mo toku telemele uluma kanolemále-ni eni méle kalomba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Eni Pulu Yili kene ung ningíndu topele-mapele tuli yima-ni Pulu Yili kene ung nilimele mele aku-siku naa teai. Topele-mapele tuli yi kanuma-ni ‘Na yi aima kaiéle moliu mele yambu pulele-ni eninga mongale-ni na kanuku kape niangi.’ niku yambuma máku toku Pulu Yili-nga ung piliili lkumanga kene kupulanumumanga kene yambuma kanuku molangi numanu siku angiliiku Pulu Yili-popu kene ung toku nilimele. Na-ni enindu aima sika nimbu siker: “Aku-siku telemeláliinga enini eninga méle kaluliele kórunga liilimele kanili.” niker. ");
INSERT INTO mux_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Akiliinga-pe eni Pulu Yili-kene popu toku ung ningíndu eninga suluminana sukundu puku kuna angnjiku mo toku kolea kanuna eninga ⸤mulú-koleana molemú⸥ Lapa naa kanolemele yili-kene ung niai. ⸤Yu akuna molemú.⸥ Aku tingí kene eninga ⸤mulú-koleana molemú⸥ Lapale mo toku telemele uluma kanolemále-ni eni penga méle kalomba. ");
INSERT INTO mux_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“‘Na Pulu Yili-kene popu topu ung niambu.’ nikunu kene Isrel-talapena ulsu molemele yambuma-ni eninga kuruma mola pulu yi gólu túlima-kene popu toku ung ningíndu we ung pulele nilimele mele aku-siku naa teai. Yambu kanuma-ni ‘Na ung pulele nimbú kene piliimba.’ niku aku-siku nilimele kanili. ");
INSERT INTO mux_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Eninga ⸤mulú-koleana molemú⸥ Lapale ui mawa naa teangi eni mólu tolemú mélema yu-ni piliipa kanolemú akiliinga yambu kanuma-ni telemele mele aku-siku naa teai. ");
INSERT INTO mux_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Eni Pulu Yili kene popu toku ung ningíndu i-siku mele niangi: “Oliunga Tata mulú-koleana mollale, yambuma-ni ‘Nunga bili ola pípili yi kake tili kaiéle mollu.’ niku molangi. ");
INSERT INTO mux_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu yi nuim kingele molkunu yambuma nukuni enale wendu upili. Nunga ungele mulú-koleana piliiku liiku telemele mele aku-siku ya ma-koleana piliiku liiku teangi. ");
INSERT INTO mux_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Oliu ekupu langi nomulú mele ekupu siyo. ");
INSERT INTO mux_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yambuma-ni oliu teku kis-síngi kene kanupu konde tenjipu ulu te naa tímulu mele aku-sikuko oliu-ni nu-kene tepu kis-símulu uluma kanuku konde tenjikunu oliu ulu te naa tiyo. ");
INSERT INTO mux_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Oliu ‘Ulu te-ni kundi tupili.’ naa nikunu ulu-kismanga pali ulu-pulele pelemú ⸤kur⸥ale-ni ‘oliu naa ambulupili.’ nikunu yunga kína wendu liiyo. (Nu koleama kene mélemanga pali yi nuim kingele molkunu, tondulu olandupale nu-kene pepa, nu bi aima olandupa molupa nu-kene talang tondulu-tepa pupili taki-taki molkunu mindi pullaliinga aku-sipa tipili.)” niku aku-siku Pulu Yili-kene popu toku ung niai. ");
INSERT INTO mux_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Yambuma-ni eni teku kis-singí uluma kanuku konde tenjiku ulu te naa tíng lem eninga mulú-koleana molemú Lapale-ni eninga ulu-pulu-kísima kanupa konde tenjipa ulu te naa tembako. ");
INSERT INTO mux_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Akiliinga-pe yambuma-ni eni teku kis-singí uluma ‘We mania naa pupili.’ niku kanuku konde naa tinjíng lem eninga ⸤mulú-koleana molemú⸥ Lapale-ni eninga ulu-pulu-kísima ‘Mania naa pupili.’ nimba kanupa naa tenjimbako.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Eni langi naa noku mi toku we mulungí ulu-pulele tingíndu topele-mapele tuli yima-ni ‘Na kumbi-keri tepu molambu.’ nilimele mele aku-siku naa niai. Yi kanuma-ni ‘Na langi naa nombúndu mi topu moliu mele yambuma-ni kanangi.’ niku enini kumbi-keri teku eninga kumbi-kerima kolku panjiku molemele. Na-ni enindu aima sika nimbu siker: “Yi kanuma-ni aku telemeláliinga yambuma-ni enini kape nilimele ungma eninga méle kaluliele kórunga liilimele.” niker. ");
INSERT INTO mux_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","“Akiliinga-pe eni langi naa noku mi toku we mulungíndu ‘We-yambuma-ni na aku teker mele naa kanangi. Tata-ni mindi kanupili.’ niku we-yambuma-ni kanungí uluma naa teangi. Aku tingí kene eninga ⸤mulú-koleana molemú⸥ Lapale mo toku telemele uluma kanolemále-ni eni méle kalomba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ya ma-koleana méle nosulimelema oralu topa koka mola lkurena mélema-ni oku noku, wa liili yima oku mélema wa liilimele akiliinga ⸤ya mana⸥ kamako molupu méle lupa-lupama liipu nosamili.’ ni naa niai. ");
INSERT INTO mux_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Aku naa teku kene mulú-koleana mélema oralu naa topa koka mola lkurena méle te-ni omba nomba tepa kis naa sipa, wa liili yima oku wa naa liilimeláliinga eni mulú-koleana ⸤penga pungéliinga⸥ ‘méle kande-kande penga liimulúma ui lipili.’ niku ya ma-koleana ulu kaíma teku molai. ");
INSERT INTO mux_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eninga nosulimele mélema lelemú kolea akuna eni numanale-ni piliiku numanu monjuku molemeláliinga ⸤‘mulú-koleana mindi mélema lipili.’ niku molai.” nirim⸥. ");
INSERT INTO mux_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nunga mongale nunga kangieliinga tepi-llam mélale. Akiliinga nunga mong kaí angiliimú kene nu kangi pali pa tipili molláliinga nu molkunu konjullu. ");
INSERT INTO mux_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akiliinga-pe nunga mongale kis lemba kene nunga kangiele pali sumbulú molombana anduni. Kanu-kene nunga kangina pa tili pembale alsupa sumbulú tomba kene akili aima kamu sumbulú tomba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Yambu te-ni yi-auli tálenga kongun liipa tere lepa kapula naa tenjimba. Yi-auli te numanu kis panjipa, te numanu monjumba. Mola aku naa tímu lem yi auli tenga ung nimbáma aima numanu sipa piliipa liipa kongun nimbáma tondulu mundupa tenjipa, te numanu kis panjipa yunga ung nimbáma pulie nimba naa temba. Yambuma-ni Pulu Yili-nga kongunale kene Ku-Monelenga kongunale kene liiku tere leku kapula naa tinjingí. ");
INSERT INTO mux_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Akiliinga na-ni eni ⸤tingí mele⸥ nimbu sambu. ‘Kangikundu molupu konjamili.’ niku numanu pulele liiku naa mundai. Langi nungéliinga kepe no nungéliinga kepe mulumbale pakungéliinga kepe akumanga numanu pulele liiku munduku naa molai. Eni kapula mulungí mele ulu-pulele langi kene mulumbale kene mindiye? ");
INSERT INTO mux_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kerama kanai. Langi te talku kene tepa tolemú kene liiku meku lkundu puku nosuku naa nolemele akiliinga-pe eni yambumanga mulú-koleana molemú Lapale-ni kerama langi silimú. Kerama we-mele, eni yambuma olandupaliinga yu-ni eni naa nokumbaye? ");
INSERT INTO mux_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eninga yambu te-ni numanu pulele liipa mundumbále-ni yu kolumba ena te kapula ‘We lipili.’ nimbáye? Kapula naa nimbá. ");
INSERT INTO mux_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","“Eni pakungí mélemanga numanu pulele nambimuna liiku mundulimeleye? Pllawa-kukuma mana olemú mele eni naa kanolemeleye? Pllawa-kukuma-ni kongun mindili siku naa teku, mulumbale te teku mimi naa telemele akiliinga-pe pllawa-kukuma molemele mele olandupa, ⸤yi nuim king⸥ Sollomon kongun pulele tepa kene wale-pakuli aima kaíma pakupa au nirim mele mandupa. ");
INSERT INTO mux_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Era-kuku tolemúma ekupu-mele molemú, ulsulam-ukundu ⸤lkunuku⸥ tepina kalemele akuma Pulu Yili-ni aku-sipa nokupa konjulimú lem eni ‘Pulu Yili-ni oliu kapula nokumbanje.’ niku laye-kolte mindi piliilimili yambuma pakungí mélemanga yu-ni kapula liipa naa tapunjumbaye? Eni aima sika liipa tapunjumba. ");
INSERT INTO mux_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“⸤Pulu Yili-ni kerama kene era-kukuma kene we-méle akuma aku-sipa nokulem⸥áliinga eni numanu pulele liiku munduku kene ‘Es, langi te tena liipu nomulúnje?’, mola ‘No tena kolupu nomulúnje?’, mola ‘Wale-pakuli tena liipu pakomulúnje?’ niku piliiku naa molai. ");
INSERT INTO mux_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pulu Yili-nga yambuma naa molku ulsukundu molemele yambuma-ni aku-siku telemele akiliinga-pe eninga mulú-koleana molemú Lapale-ni eni yunga yambumanga méle mólu tolemúma kanupa molemú. ");
INSERT INTO mux_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","⸤Eni langi nungímanga kene mulumbale pakungímanga kene numanu naa liiku munduku,⸥ Pulu Yili yi nuim kingele molupa yambuma nokulemú uluma kene yu kanupa kake telemú nimba kanolemú uluma kene mélema kene ‘Kumbi-lepu teambu.’ niku numanu liiku munduku piliiku molai. Aku tingí kene yu-ni we-mélema kepe eni simba. ");
INSERT INTO mux_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yu-ni aku tembaliinga ‘Opali nambi tembunje?’ niku ekupu numanu pulele liiku naa mundai. Opalinga langi mola mélema aku opalinga, ekupunga langi mola mélema kene, opalinga kene, liiku tere leku naa piliai! Enamanga lupa-lupa bunima pelemú pembama ena kanumanga mindi. Ekupu buni wendu ombáma kene, opali talú buni wendu ombámanga kene tere leku numanu liiku naa mundai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","⸤Yesos-ni ung mare nimba molupa kene ung mare wasie nimba mele:⸥ “Eni anju yambuma ⸤telemele uluma⸥ apurungí kene aku-sipa ⸤Pulu Yili-ni⸥ eni telemele mele anju apurumbako. Eni anju yambuma-ni telemele mele apuruku kanuku kene “Teku kis-sikimili. Tekemele mele Pulu Yili-ni kanupa kis piliipili.” ningí mele ⸤Pulu Yili-ni⸥ aku-sipa eni apurumba. Aku tembaliinga ‘⸤Pulu Yili-ni⸥ oliu ulu telemuluma naa apurupili.’ niku eni yambuma telemele uluma naa apurangiko. ");
INSERT INTO mux_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nu-ni angenanga monguna nurupalu te lelemále kanolláliinga-pe nunga monguna unji-kolomong auli te lelemále naa kanollu akili nambimuna telluye? ");
INSERT INTO mux_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nunga monguna unji-kolomong auli lelemále naa kanuku kene angenandu “Ang, nunga monguna nurupalu te lelemále wendu liinjambu.” nambi-siku nilluye? ");
INSERT INTO mux_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Topele-mapele tuli yambale, nu-ni nunga monguna lelemú unji-kolomong auliele ui wendu liikunu kene pe kanuku kongnjukunu angenanga monguna lelemú nurupalale kapula wendu liinjui.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“‘Pulu Yili-nga’ nilimele mélema liiku owa naa sai. Nomba kene pe topele topa eni nombánje akiliinga aku-siku naa teai. Eninga méle kaíma kung molumbana toku naa mundai. Kimbele-ni kambiliimba akiliinga aku naa teai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“⸤Eninga Lapa, mulú-koleana molemú yili,⸥ mélema mawa teku “Si.” niai. Aku tingí kene mélema sika simba liingí. ⸤Lapa molemúna⸥ mélema korai. Aku tingí kene mélema sika kanuku liingí. Lku-keri-puluna angiliiku “Lkundu wamiliye?” niai. Aku-siku ningí kene “Lkundu wai.” nimba kuna liimba. ");
INSERT INTO mux_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mawa tingí mélema sika simba liingí; kurungí mélema sika kanuku liingí; “Lkundu wamiliye?” ningí kene sika kuna liimba. Aku tembaliinga aku-siku teai. ");
INSERT INTO mux_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Eninga yi te yunga málale omba kene “Tata, pllawa kaluli te nambu si.” nimbá kene yunga lapale-ni yu ku-mulú te simbaye? ");
INSERT INTO mux_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mola kangale-ni “Tata, oma te nambu si.” nimbá kene yunga lapale-ni wambiye te simbaye? ");
INSERT INTO mux_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pe eni numanu kis pípili molemele yambuma-ni aku-siku eninga kangambulama méle kaíma silimele lem eninga Lapa mulú-koleana molemále-ni “Mélema si.” niku mawa tingí yambuma méle kaí aima olandupama naa simbaye? ⸤Aima simba.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Akiliinga, ‘Yambuma-ni nu-kene teangi.’ nikunu numanuna piliillu mele nu-ni anju yambuma aku-sikunu ti. ‘Aku teangi.’ nikinu ulu akili ung tálenga pulele. Ulu akili Moses-ni Pulu Yili-nga ung-mani sirim bukna turum-manga pulele kene, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni bukna turing ungmanga pulele kene, liipa tere lepa nilimáliinga aku-siku anju-yandu yambuma-kene teku kaí teai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Eni pala keri-pulu si nili wallúna aima pai. Kolea kísina pulimú pala keri-puléle aima auliele, akuna pulimú kupulanumele aima anju-yandu pupa aima parále lelemú akuna yambu pulele mindili naa siku we-we teku pulimelé. ");
INSERT INTO mux_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Akiliinga-pe taki-taki kona molupa konjupa mindi puli koleana pulimú keri-puléle aima wallú, yunga kupulanumele aima si nili kelále lelemú akiliinga yambuma akuna pungíndu mindili silimeláliinga yambu tilu-tilu niku mindi kupulanum akili kanuku kene pulimelé. Aku telemeláliinga eni pala keri-pulu wallú kanuna pai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pulu Yili-ni “Ninjai!” nimba, nimba sili ungma naa piliiku we gólu toku yandu niku singí yima ungí akiliinga piliiku kongnjuku molai. Kung-sipsipma aima táka-niku molemele mele aku-siku yambu kanuma oku mulungéliinga-pe owa-takarama aima engle-ni kolku kene ‘Méle te topu nomulú.’ niku anduku molemele mele aku-siku yambu kanuma-ni ‘Eni mindili nangi. Eni tepu kis-samili.’ niku molemele. ");
INSERT INTO mux_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gólu tuli yambu kanuma oku ulu tingíma kanuku kene, ‘Enini sika gólu túlima.’ niku kanungí. ‘Ámu namili.’ niku takemé kapula olku toku nolkemelaye? Mola ‘Me te namili.’ niku silipú kapula ukuku nolkemelaye? Aima mólu. ‘Ámu lupa, takemé lupako; me lupa, silipú lupako.’ niku kanolemele. ⸤Aku-siku mele Pulu Yili-ni sika “Ninjai!” nimba, nimba sili ungma piliiku yambuma sika niku silimele mele lupa, Pulu Yili-ni “Ninjai!” nimba, naa nimba sili ungma yambuma gólu toku niku silimele mele lupako niku kanungí.⸥ Unjima mong tolemú kene kanuku kene ‘Ima nomulú lem. Ima naa nomulú lem.’ niku kanuku bi silimele kanili. ");
INSERT INTO mux_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unji kaiéle-ni mong kaiéle tolemú; unji kisele-ni mong kisele tolemú. ");
INSERT INTO mux_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Unji kaiéle-ni mong kis te kapula naa tomba; unji kisele-ni mong kaí te kapula naa-ko tomba. ");
INSERT INTO mux_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unji mong kaíma naa tomba unjima pali peki toku kene tepina kalemele. ");
INSERT INTO mux_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Unjima mong tolemú kanuku kene, “Ili kaí, ili kis.” niku apurulimele mele, ungí yambu kanuma-ni tingí uluma eni kanuku kene yambuma molemele mele sika aku-siku kanungí. ");
INSERT INTO mux_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“‘Yambuma-ni nandu ‘Auliele. Auliele.’ nilimele yambuma pali Pulu Yili-ni yi nuim kingele molupa nokumba mulú-koleana sukundu pungí.’ niku naa piliai. Tata mulú-koleana molemáliinga ungma piliiku liiku tingí yambuma mindi akuna pungí. ");
INSERT INTO mux_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yambuma apurumba ena kanili wendu ombá kene yambu pulele-ni nandu niku mele: “Auliele, na-ni nunga bi lepu nunga ungma nimbu sirindu kanili; nunga bili lepu yambumanga numanuna kuru muluringma “Oku ulsu pai.” nirindu kanili; nunga bili lepu ulu tondulu pulele tirindu kanili.” ningí. ");
INSERT INTO mux_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Akiliinga-pe aku-siku ningí kene na-ni enindu nimbu mele: “Na eninga bima aima naa piliipu eni kanupu bi naa siliu. Eni Pulu Yili-nga ungele naa piliiku liiku tiringeliinga nanga kumbi-kerina naa oku anju pai.” nimbú. ");
INSERT INTO mux_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Akiliinga, nanga ung ima piliiku liiku tingí yambuma enini yi te molemú mele niambu: Yi piliipa kungnjuli pirim yi te yu-ni yunga lkuli ‘gi nimba angiliipili.’ nimba ku-poluna ola takurum. ");
INSERT INTO mux_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Penga lo topa no topa popuremi topa kene lkuli aima topa kalalu simba tirim akiliinga-pe lku paka-súmele ku-poluna angiliirimeliinga topa tekisi naa tekisipa gi nimba we angiliirim. Nanga ungma piliiku liiku telemele yambuma enini yi kanili mele molemele. ");
INSERT INTO mux_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Nanga ung ima piliiku liiku naa tingí yambuma enini yi te molemú mele niambu: Yi piliipa kungnjuli naa pirim yi te-ni yunga lkuli okeana ola takurum. ");
INSERT INTO mux_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Pe lo topa no topa popuremi topa kene lku kanili topa kalalu sipa aima bulu-bale sirim. Nanga ungma naa piliiku liiku tingí yambuma enini yi kanili mele molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesos-ni ung akuma nimba pora sirim kene yu-ni mani sirim piliiku muluring yambuma-ni yu-ni ung-mani sipa ung-bo tunjurum mele piliiku kene mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pulu Yili-nga ung-manimanga puluma piliiku enini ung-bo tunjuring yima-ni we ung-bo tunjuring mele Yesos-ni aku-sipa ung-bo naa tunjurum. Namba lirim yima-ni mundu-mong naa teku tondulu munduku ung-bo tunjuring aku-sipa mele mani sipa ung-bo tunjurumeliinga piliiku kene enini mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesos ma-pangina mandu ombá urum kene yambu pulele liiku máku toku yu lumbili uring. ");
INSERT INTO mux_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kanu-kene yi te kuru-kindí nomba pirimele Yesos urumna omba yunga kumbi-kerina koporungu langupa kene yunundu nimba mele: “Auliele, nunga numanale-ni ‘nanga kangiele kaí lipili.’ nikunu pilíínu lem nu-ni na kapula tekunu kaí tiní.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesos-ni yili kíli-ni ambulupa kene yunundu nimba mele: “‘Nunga kangiele kaí lipili.’ nimbu piliiker akiliinga kaí lipili.” nirim kene lkisipa kuru-kindéle pora nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kanu-kene Yesos-ni yunundu alsupa nimba mele: “Nu-ni ya ulu tekerale yambu tilurindu kepe aima naa ni. Sumbi-siku pukunu Pulu Yili popu tunjuli yili nunga kangiele liiku ora sikunu, ‘Nanga kangiele alsupa kaí lipili molkur akiliinga.’ nikunu Moses-ni “Ti.” nimba, nimba panjurum mele piliiku liikunu tinindu “Pulu Yili popu toku kalku sai.” nirim mélale liikunu Pulu Yili popu tunjuli yilindu “Kalonjui.” niku yu si. Penga yambuma-ni nu kanuku kene ‘Yu sika kangiele kaí lipili molemú.’ niku piliangi akiliinga niker mele isili-ui ti-pui.” nirim. ⸤“Aku-siku tiní kene yambuma-ni nu kanuku kis naa piliingí, nu alsuku we-yambuma molemelena kapula tiluna pukunu muluni.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesos Kapeniam taon-na sukundu purum kene Rom-yambumanga ami-yi wan-andret nukurum yi te yu urumna omba yunundu mawa tepa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Auliele, nanga kendemande-yili kimbu-kima kolupa pora sipa mindili nomba perepa lku-koleana lipili okur.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesos-ni yundu “Ombu tepu kaí timbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","⸤Aku nirim mele piliipa kene⸥ ami-yi wan-andret nukurum yili-ni yunundu pundu topa nimba mele: “Auliele, na yi kisele mele moliu, nu nanga lkuna unéle kapula naa temba. Na yi te-ni kepe nokupa molemú, yunga ungele piliipu liipu teliu. Na-ni kepe ami-yi mare nokupu moliu. Yi kanumanga te-ndu “Pui.” niliu kene yu pulimú. Mola te-ndu “Ui.” niliu kene yu olemú. Mola nanga kongun tinjili kendemande-yambu te-ndu “I-siku ti.” niliu mele yu aku-sipa telemú kanili. Aku-sipako, nu-ni ung te we niní kene nanga kendemande-yili kona pumba akiliinga ungele nu-ni we ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesos-ni yu nirim mele piliipa kene yu numanu pulele liipa mundupa kene yu lumbili uring yambumandu nimba mele: “Na-ni enindu aima sika nimbu siker: “Isrel-yambumanga talapena ulsukundu mululi yi ili-ni na ungele-ni mindi kapula tembu mele nimba lakupa tondulu mundupa piliilimú mele koleamanga pali, Isrel-koleana sukundu kepe, yambu tiluri-ni kepe aku-siku ‘Sika’ niku piliiring mele aima naa kanurundu.” niker. ");
INSERT INTO mux_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na-ni enindu aima sika nimbu siker: “Ena ola olemú koleamanga kene ena mania pulimú koleamanga kene yambu pulele wendu oku Pulu Yili yi nuim kingele molupa nokulemú mulú-koleana sukundu Eprayam kene Aisak kene Jekop kene wasie oku langi noku mulungí. ");
INSERT INTO mux_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Akiliinga-pe Pulu Yili-ni ‘yunga yambuma’ nimba makó turum ⸤Isrel-⸥yambuma yu nokupa molemú koleana puku molkemela yambuma yu-ni topa makurupa sumbulú túlina mundumba. Kanuna aima mindili noku kene kola teku mindili siku mulungí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aku nimba kene yu-ni ami-yi wan-andret nukurum yilindu nimba mele: “Na-ni nu ‘kapula tenjimbu’ nikunu pilíínu mele tinjindeliinga pui.” nirim. Kanu-kene yu-ni aku-sipa nirim enaliinga kendemande-yili yunga kurale pora nimba kona pupa we mulurum. ");
INSERT INTO mux_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","⸤Kanu-kene⸥ Yesos Pita-nga lkuna lkundu pupa kene Pita-nga kolepa-ambale kuru topa kangiele nurum-na yu anambu lirim kanupa kene, ");
INSERT INTO mux_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","yunga kili ambulurum kene kangiele nomba kilirim kene ambale ola angiliipa wendu omba kene Yesos langi sipa yu nukurum. ");
INSERT INTO mux_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Penga kolea kalá tomba tirim kene numanuna kuru mulurum yambu pulele Yesos mulurumna meku uring kene yu-ni kurumandu “Oku wendu pai.” nirim kene oku wendu puring. Kuru turum yambuma pali tepa kaí tirim-ko. ");
INSERT INTO mux_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aku-sipa tirimeliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni ulu te penga wendu ombá ui nirim mele kamu wendu urum. Asaya-ni nimba mele: “Yu-ni oliu kuru turum-ma tepa pora sipa, oliu anambu lirimulu kuruma liipa ulsu mundurum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","⸤Walse⸥ Yesos ⸤numú-Gallalli kéluna mulupili⸥ yambu pulele liiku máku toku yu liiku póku teku muluring kanupa kene, ⸤lumbili andúlimandu⸥ “No-numúna nekendu pamili wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","⸤Akiliinga-pe ui naa pupa we angiliipili⸥ Pulu Yili-nga ung-manimanga puluma piliipa ung-bo tunjurum yi te yu angiliirimna omba yunundu nimba mele: “Ung-Bo Tunjuliele, nu puni koleamanga pali nu lumbili ombú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","⸤Aku nirim kene⸥ Yesos-ni yundu nimba mele: “Piliiyo! Owa-takarama lku pelemelémanga pelemelé; kerama eninga mi takolemelemanga pelemelé, akiliinga-pe Mania Omba Mana-Yi Au Talurum Yili pelemú kolea te naa lelemú ⸤akiliinga, nu ‘Yu lumbili pupu kene kapula naa molumbu.’ niku piliikunu kene na lumbili ui. We naa ui.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kanu-kene yu lumbili andurum yi te-ni yunundu nimba mele: “Auliele, nu kamu lumbili wambu aramele-pe ui na pupu nanga lapale ⸤kene wasie molambu. Pe yu kolumba kene⸥ ónu tepu kene nu lumbili ombú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Akiliinga-pe Yesos-ni yundu ⸤ung-eku topa kene⸥ nimba mele: “Yambu kululi yambuma-ni enini yambu kulungíma ónu teangi. Akiliinga-pe nu na lumbili ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aku nimba kene ⸤numú-Gallalli nekendu pumbandu⸥ nona anduli sip tenga suku purum kene yu lumbili andúlima yu lumbili suku puringko. ");
INSERT INTO mux_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanu-kene ⸤no-numúna pungí puring kene⸥ popuremi aima auli te no-numúna turum. Aku tirimeliinga numéle apsipa ola omba kene sipele liipa panda tomba tirimeliinga-pe Yesos we uru pirim. ");
INSERT INTO mux_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanu-kene enini yu uru pirimna puku toku makinjiku kene niku mele: “Auliele, oliu tekunu lii. Oliu no wangkumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yu ⸤makiliipa kene⸥ eninindu nimba mele: “‘Pulu Yili-ni oliu nokumba.’ niku numanu tondulu naa pili yima, eni nambimuna mini-wale mundukumiliye?” nirim. Aku nimba kene ola molupa popuremale kene numéle kene ung-mura sirim. Kanu-kene popuremale topa kelepa numéle lope naa tepa aima we lirim. ");
INSERT INTO mux_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","⸤Yu-ni tirim mele kanuku kene⸥ yima-ni mini-wale munduku kene niku mele: “Apa! Yi ili nambulka yi te-nje? Popuremale-ni kepe no-numéle-ni kepe yunga ungele piliiku liiku kelkembele.” niring. ");
INSERT INTO mux_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kanu-kene yu ⸤lumbili andúlima kene wasie⸥ no-numú nekendu pupa kolea-Gadara puring kene kolea Gadara kanuna yi tale, numanuna kuru mulurum yisele, yambu ónu-koleana wendu okulu yu mulurumna uringli. Elsele aima tondulu mundukulu yambuma tunglí tiringleliinga we-yambuma elsele piringli koleana ‘Elsele-ni enini tunglí.’ niku kupulanum-na oku naa puring. ");
INSERT INTO mux_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yesos kanukulu kene tondulu mundukulu walsikulu kene nikulu mele: “Pulu Yili-nga Málale, oliu-kene ulu nambulka ulu te tinindu únuye? Oliu mindili liipa simba enale ui wendu naa upili nu-ni isili-ui oliu mindili liiku sini okunuye?” niringli. ");
INSERT INTO mux_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akuna anjupa kolea tenga bo-kung pulele im noku muluring ⸤kanuku kene⸥ ");
INSERT INTO mux_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","kuruma-ni Yesos mawa teku kene niku mele: “Oliu toku makuruku kene ‘ne kungmanga numanuna molu-pai.’ ni.” niring kene ");
INSERT INTO mux_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","yu-ni “Kapula, akuna pai.” nirim kanu-kene ⸤kuruma⸥ yi kanuselenga numanuna wendu oku kene kung akuna muluringmanga numanuna puku muluring kene kung kanuma pali kelep toku lkisiku puku kopuna puka toku no-numúna suku puku no wanguring. ");
INSERT INTO mux_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","⸤Ulu akuma wendu urum mele kanuku kene⸥ kung tápu-teku muluring yima takara toku puku kene, taon-na puku akuna muluring yambuma eninga kungma tiring mele kepe kuruma numanuna muluring yisele tiringli mele kepe temani toku siring. ");
INSERT INTO mux_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Niring mele piliiku kene taon-na muluring yambuma pali Yesos mulurumna oku kanuku yu mawa teku kene niku mele: “Oliunga koleana naa molkunu kelkunu pui.” niring. ");
INSERT INTO mux_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanu-kene Yesos alsupa nona anduli sip tenga suku pupa kene, Numú-⸤Gallalli⸥ yakundu omba yunga kolea ⸤Kapeniam taon⸥ urum. ");
INSERT INTO mux_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yesos yu ⸤Kapeniam kelepa⸥ omba mulurumna yi mare-ni kimbu-kima kolupa pora sirim yi te taropola teku meku uring. Enini ‘Yesos-ni yi ili kapula tepa kaí temba.’ niku piliiku kene yu meku uring mele kanupa piliipa kene Yesos-ni kimbu-kima kolupa pora sirim yilindu nimba mele: “Nanga kangale, nu numanu waengu nipili. Nunga numanuna ulu-pulu-kis tirinu pelemúma mania pupili, kanupu konde tenjikur.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Aku nirim-na piliiku kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare-ni eni-enini numanale-ni piliiku kene, ‘Yi ili-ni Pulu Yili marake tekem.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Enini numanale-ni piliiring mele Yesos-ni piliipa kene nimba mele: “Eni nambimuna numanuna ungma piliiku kis piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yi ilindu “Nunga ulu-pulu-kísima mania pupili, kanupu konde tenjikur.” nimbú kene eni ulu te naa kanuku kene ‘We-we tepa nikem.’ niku piliingíye? Mola “Ola angiliikunu nunga kunungele liiku mekunu kimbu kambiliikinu andui.” nimbú kene yu ola angiliimbane mola naa angiliimbanje mokeringa lemba kapula kanuku kene ‘Aku-sipa mindili sipa nikem-nje?’ niku piliingíye? ");
INSERT INTO mux_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Akiliinga-pe ‘ ‘Mania Omba Mana-Yi Au Talurum Yili tondulu pelemále-ni ya ma-koleana yambumanga ulu-pulu-kísima “Mania pupili, kanupu konde tenjikur.” kapula nimbá.’ niku piliangi.’ nimbu aku-sipu nindu.” nirim. Aku nimba kene kimbu-kima kolupa pora sili yilindu nimba mele: “Nu ola angiliikunu nunga kunungele liiku mekunu lkundu pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Aku nirim kene yili ola angiliipa lkundu purum. ");
INSERT INTO mux_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Yambu pulele akuna máku toku muluringma-ni yu aku tirim kanuku mini-wale munduku kene, mana-yambuma ulu-tondulu aku-mele tingí tondulale sirim Pulu Yili-nga bili paka tonjuku kape niring. ");
INSERT INTO mux_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kanu-kene Yesos pumba pupa kene, ku-moni-takis liipa mulurum yi te, yunga bili Matyu, kanupa kene yunundu “Na-kene wasie pambili lumbili ui.” nirim. Kanu-kene Matyu ola angiliipa yu lumbili purum. ");
INSERT INTO mux_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Penga Yesos Matyu-nga lkuna langi nomba mulurum kene ku-moni-takis liili yima kene, ⸤Juda-yi aulima-ni⸥ “ulu-pulu-kísima tili yi” ⸤niring⸥ yi we kanuma kene pulele oku Yesos kene yu lumbili anduli yima kene enini wasie mania molku langi nuring. ");
INSERT INTO mux_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","⸤Enini aku-siku tiluna langi noku muluringeliinga⸥ Perisi-yima-ni kanuku kene yunga lumbili anduli yimandu walsiku piliiku kene niku mele: “Eninga ung-bo tunjuli yili ku-takis liili yima kene ulu-pulu-kísima tili yi wema kene enini-kene yu nambimuna langi wasie nokomeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aku-siku niring mele piliipa kene Yesos-ni eninindu ⸤ung-eku topa kene⸥ nimba mele: “Kuru naa tolemú yambuma doktana naa pulimelé. Kuru tolemú yambuma mindi doktana pulimelé kanili. ");
INSERT INTO mux_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na-ni “Yambu sumbi-nílima na molombuna wangi.” nimbúndu naa urundu. “Ulu-pulu-kis tili yambuma na molombuna wangi.” nimbúndu urundu. Ulu-pulu-kis tili yambuma liipu tapunjupu tepu liimbundu urundeliinga eni puku Pulu Yili-nga bukna molemú ung tenga pulele puku pilii-pai. Pulu Yili-ni nimba mele: “‘Na mélema popu toku kalku sangi.’ nimbu piliipu naa moliu. ‘Eni yambu lupama numanu monjuku kondu kolangi.’ nimbu piliipu mindi moliu.” nirim kanili.” nimba Yesos-ni nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pe ⸤No-Liinjili⸥ Jon lumbili anduring yima Yesos mulurumna oku kene yunundu walsiku piliiku kene niku mele: “Oliu kene Perisi-yima kene oliu taki-taki langi mi topu naa nolemulu akiliinga-pe nu lumbili andúlima aku-siku naa telemele akili nambimuna naa telemeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","⸤Aku-siku niring-na piliipa kene⸥ Yesos-ni pundu topa eninindu ⸤ung-eku te topa yu toku kunjingí kolumbaliinga ung te nimba kene⸥ nimba mele: “Ambu liimba yi te yunga pulu lelemú yima kene molemú kene enini numanu siku kene “Kola tepu langi naa namili.” kapula ningíye? Kapula naa ningí. Penga mindi, ambu liimba yili enini mulungína oku wendu liingí kene ena kanumanga sika ⸤numanu kis panjiku⸥ langi naa nungíndu mi tungí. ⸤Isili-ui mólu.⸥ ");
INSERT INTO mux_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Mulumbale ui te sungu nilimú kene oliu-ni mulumbale aima kona tenga te kopsipu liipu, sungu nilimúna naa topu tambululimulu kanili. Yambu te-ni aku-sipa topa tambulkanje mulumbale kanili nona panjilka kene mulumbale kona kupsiliele wallú pupa tang tepa kene mulumbale-uiele alsupa kamu lakupa sungu nilka. ");
INSERT INTO mux_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Kung-memi kangiele-ni tili mingi-ukundu tenga no-waen kona naa-ko kolemulu kanili. Yambu te-ni mingi-ukundu tenga no-waen kona te kolkanje no-waen kanili mingina sukundu molupa kene penga akolka kene mingi-ukundu kanili naa akopa sungu nilka. Kanu-kene nole kepe mingele kepe kamu kis lelka. Akiliinga, no-waen kona kung-memi kangiele-ni tili mingi konána mindi kolemulu kanili. ⸤Pe nole akolemú kene kangiele-ni tili mingi konale anju-yandu pupa sungu naa nilimáliinga⸥ nole kene mingi konale wasie kapula lelemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesos-ni Jon-nga lumbili anduli yimandu ung nimba mulupili ⸤Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku te⸥ nukurum yi te Yesos mulurumna omba yunga kumbi-kerina koporungu langupa yunundu nimba mele: “Nanga ambulale ekupu isili kolupa pora sikem. Akiliinga-pe nu okunu yu kili-ni ambuluní kene yu kona pumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Aku nirim kene Yesos ola angiliipa yu lumbili purum. Yesos lumbili andúlima kene wasie puringko. ");
INSERT INTO mux_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Kanu-kene ambu te mulurum kaniliinga ku-puku turum enama pora naa nirim. Yu ku-puku mindi tupili punie engkaki-rurepu omba purum. Ambu kanili-ni ‘Yunga wale-pakuliele mindi ambulundu lem nanga kurale pora nimbá.’ nimba piliipa kene Yesos pumba purum kene bulkundu omba, yunga wale-pakulieliinga pundele ambulurum. ");
INSERT INTO mux_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","⸤Ambulurum kene⸥ Yesos topele topa yu kanupa kene nimba mele: “Nanga ambulale, nu numanu waengu nipili muluyo. ‘Nunga kurale kapula pora nimbá.’ nikunu pilíínu ulu kanili-ni nunga kurale pora nikem.” nirim. Ena-mong kaniliinga ambaliinga kurale pora nirim kene we mulurum. ");
INSERT INTO mux_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kanu-kene Yesos ⸤Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkuli⸥ nukuli yilinga lkuna lkundu omba kene yambu pulele molku kondu kolku, kulap-mingi languku, kola lakuku teku muluring kanupa kene yu-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“Eni anju pai! Ambulale kulú naa kulum. We uru mindi pelemú.” nirim. Aku nirim kene ⸤ambula kanili sika kolupa pora sirim piliiku kene yu-ni “We uru pelemú.” nirimaliinga⸥ yu ung-taka tonjuku tae tinjiring. ");
INSERT INTO mux_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kanu-kene yambu máku toku muluring kanuma pulú sipa pena-pena tepa kene ⸤ambula ónale lirim⸥ suluminana pupa ambulaliinga kili ambulurum kene ambulale ola mulurum. ");
INSERT INTO mux_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ulu-tondulu tirim ilinga temanele kolea kanuna sukundu lirim koleamanga pali anju-anju purum piliiring. ");
INSERT INTO mux_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesos kolea kanili mundupa kelepa pumba purum kene mong kis lirim yi tale yu lumbili oku walsikulu kene nikulu mele: “⸤Yi Nuim King⸥ Depit-ni Kalupa Liirim Yili, nu olsu kondu kului.” nikulu wale pulele nikulu walsiliiku uringli. ");
INSERT INTO mux_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yu lku tenga lkundu purum kene mong kis lili yisele yu mulurumna lumbili uringli kene yu-ni elsele walsipa kene nimba mele: “Else na mawa tekembele mele ‘Kapula tenjimba.’ nikulu piliikimbili mola móluye?” nirim kene elsele-ni nikulu mele: “Auliele, ‘Kapula tinjiní.’ nimbu piliikumbulu.” niringli. ");
INSERT INTO mux_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kanu-kene yu-ni elsengla mongselenga ambulupa kene nimba mele: “Na-ni ‘kapula tenjimba.’ nikulu piliikimbili mele aku-sipa wendu upili.” nirim ");
INSERT INTO mux_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","kene elsengla mongsele kaí lirim, mélema alsuku kanuringli. Yesos-ni elsele tondulu mundupa mani sipa kene nimba mele: “Else-ni ulu wendu okum ili yambu tiluri kepe aima naa piliangi, naa niku sale!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Akiliinga-pe elsele pena pukulu Yesos-ni tirim mele kolea akiliinga sukundu lirim koleamanga pali temani toku silsiliikulu anduringli. ");
INSERT INTO mux_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yi kanusele Yesos munduku kelkulu punglí puringli kene yi te numanuna kuru mulurumeliinga ung te naa nirim yi te Yesos mulurumna meku uring. ");
INSERT INTO mux_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesos-ni yilinga numanuna mulurum kuru kanili topa makururum kene ung naa nirim yi kanili-ni ung nirimeliinga yambu máku toku muluringma-ni kanuku kene numanu pulele liiku munduku kene niku mele: “Ui Isrel-koleana sukundu i-sipa ulu te wendu naa urum kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Akiliinga-pe Perisi-yima-ni niku mele: “Kurumanga nuimele-ni yu liipa tapunjilimú-na yu-ni kuruma topa makorolemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesos kolea-aulimanga kene, kolea-kelúmanga kene pelsiliipa andupa kene, Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkumanga lkundu pupa ung-bo tonjupa; Pulu Yili yi nuim king molupa yambuma nokulemú nokumba ung-pulumanga temani kaíma topa sipa; kuru lupa-lupama turum yambuma tepa kaí tirim-ko. ");
INSERT INTO mux_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yambu aima pulele yu mulurumna oku liiku máku toku muluringma kanupa kene enini numanu-bo naa pípili anduku, kangima tondulu naa pirimeliinga eni-enini kapula liiku naa tapunjuku molku kene enini kung-sipsipma eninga tápu-yi te naa mulurumeliinga we muluring mele enini aku-siku muluringeliinga kanupa kene enini aima kondu kulurum. ");
INSERT INTO mux_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kanu-kene ⸤yambu pulele ‘Yu-ni liipa tapunjupili.’ niku muluringeliinga kanupa kene⸥ lumbili anduli yimandu nimba mele: “Langi pulele puniena tepa tolemú akiliinga-pe kongun-yi pulele mólu. ");
INSERT INTO mux_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","⸤Na yi tiluele mindi kongun ili tekeraliinga⸥ langimanga Pulu Yili mawa teku kene yu-ni “Langi tepa-túlima liingí kongun tingí yambuma yunga puniena liipa mundupili.” niai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesos-ni yunga lumbili anduli yi engkaki-rurepundu “Yandu wai.” nimba kene enini yambumanga numanuna kuru molemúma “Oku wendu pai.” niku toku makurungí tondulale sipa kene, yambu kuru túlima kene kangiele pang-mangi tílima kene “Kaí molangi.” ningí tondulale sirim. ");
INSERT INTO mux_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yu-ni “Nanga kongunale tenji-pai.” nimba liipa mundurum yi engkaki-rurepunga bima i-sipa mele: Ui Saimon, yunga bi te ‘Pita’ niringko, yu kene yunga angin Endru kene, Jeperi-nga málu Jemis kene Jemis yunga angin Jon kene, ");
INSERT INTO mux_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pillip kene Batollomiu kene, Tomas kene ku-moni-takis liirim yi Matyu kene, Alpias-nga málu Jemis kene Tadias kene, ");
INSERT INTO mux_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","“Oliu Juda-yambuma oliuliu gapman molamili.” niring talape-yi Saimon kene, Yesos penga liipa ele-túma sirim yi Judas-Iskeriot kene, akuma. ");
INSERT INTO mux_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesos-ni yi engkaki-rurepu akuma liipa mundupa kene eninindu nimba mele: “Yambu-lupama molemelena naa pai. Sameria-yambumanga taon tenga kepe naa-ko pai. ");
INSERT INTO mux_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isrel-yambuma mindi eninga kung-sipsipma pena lu liiku pelemelé mele aku-siku molemele yambuma molemelena mindi pai. ");
INSERT INTO mux_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Enini molemelena pungí puku kene, eninindu “Pulu Yili yi nuim king molupa yambuma nokumba enale nondupa wendu ombá tekem.” nilsiliiku pai. ");
INSERT INTO mux_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","“Kuru tomba yambuma teku kaí teku, kolku lingí yambuma ‘Suru niku ola molai.’ niku, kuru laká nombá yambuma ‘Bo-kangi angiliipili.’ niku, kuru numanuna mulupili mulungí yambuma ‘Numanuna naa molangi, oku wendu pai.’ niku telsiliiku pai. Kongun ili tingéliinga tondulale ku-moni te mola méle te-ni taropu toku naa liikimele akiliinga anju yambuma aku-siku liiku tapunjuku kene, ‘Ku-moni te liamili.’ niku naa-ko teai. We teai. ");
INSERT INTO mux_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Pungíndu ku-gollu mare mola ku-sillipa mare mola ku-kopa mare kamirikana panjiku meku pu naa pai. ");
INSERT INTO mux_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Méle-wale kepe wale-pakuli tale kepe kimbu-su kepe apulu-mingi kepe naa meku we pai. Yambu kongun tenjilimále kongun tenjilimú yambale-ni langi simba kene kapula, akiliinga méle te mi naa miai. We pai. ");
INSERT INTO mux_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pe kolea-auli tenga mola kolea-kelú tenga sukundu puku kene, yambuma walsiku piliiku kene “Yi nae yi kaí te molemáliinga oliundu “Wasie piamili wai.” nimbáye?” niai. Kanu-kene te niku singí kene piliiku yu kanuku liiku kene yi kaniliinga lkuna puku yu-kene mindi wasie peku molku kene pe kolea akili munduku kelku pai. ⸤Lku tenga puku tenga puku naa teai. Tiluringa mindi langi noku peai.⸥ ");
INSERT INTO mux_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","⸤Kolea tenga puku yi kaí te liiku ora singí kene kanuku liiku⸥ yunga lkuna lkundu puku kene, lku pulu yambumandu “Eni numanu kaí pípili molai.” niai. ");
INSERT INTO mux_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kanu-kene yambu kanuma-ni “Wasie piamili lkundu wai.” níngi lem eninga ung kaí ningí kanili yambu kanuma-kene pípili. Akiliinga-pe yambu kanuma-ni numanu kaí naa panjiku, “Wasie piamili wai.” naa níngi lem ung kaí ui lkundu puku kene ningí kanili “Eni-kene naa pípili.” niku, kelku meku ⸤enini munduku kelku yandu wai⸥. ");
INSERT INTO mux_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Yambu te-ni enindu “Wasie piamili wai.” ni naa niku eni ung ningíma piliiku naa lííngi lem lku kanili mola taon kanuna yambu kísima munduku kelku pungíndu ⸤kolea kanuna yambuma ‘Kamu molku kis-sangi. Pulu Yili-ni enini liipa naa tapunjumba mele piliangi.’ niku⸥ kolea kanumanga ma eninga kimbuna angiliimbama tanda siku munduku pai. ");
INSERT INTO mux_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na-ni eni aima sika nimbu siker: “Kot enale wendu ombá kene kolea-auli Sodom kene Gomora-sele elsengla yambuma ⸤ui ulu-pulu-kis pulele sika tiring akiliinga-pe⸥ elsengla kot meliwe mele pemba. Akiliinga-pe yambu enindu “Sukundu wai.” ni naa niku eninga ungma piliiku naa liingí yambu ima kot enale wendu ombá kene eninga kot auliele pemba.” niker. ");
INSERT INTO mux_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Eni liipu mundukur yima eni kung-sipsip melema, yambu owa-takara auli kísima-ni sipsipma topa nolemú mele yambuma molemelena eni liipu mundukur. ⸤Nanga ungele anduku niku singí kene piliiku kis piliiku kene yambuma-ni eni mindili liiku singí.⸥ Yambuma owa-takara mele aku-siku molemeláliinga wambiyema piliipa kungnjuliele aima pelemú-na uluma tembandu mimi-sipa piliipa telemú mele eni wambiye akuma mele molku, kera-waembonu molemú mele molai. ⸤Kera akili-ni mélema mindili sipa tepa kis-simba ulu-pulu te naa pelemú.⸥ ");
INSERT INTO mux_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Yambuma mimi-siku kanai. Eni ⸤‘Na lumbili anduli yambuma mindili noku, kolangi.’ niku,⸥ eni ⸤mare ambolku liiku kene⸥ kanjollumanga mákumanga meku puku kot tenjiku, eni ⸤mare⸥ Juda-yambuma máku toku Pulu Yili-nga ungele piliilimili lkumanga kundu liiku meku puku kimbulú-ni tungíko. ");
INSERT INTO mux_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Eni nanga yambuma mulungéliinga eni ⸤mare ka siku⸥ yambu-lupamanga gapman yi aulima kene yi nuim kingima kene mulungína ⸤kot tinjingíndu⸥ meku pungíko. Aku-siku tingéliinga eni-enini piliiku kongnjuku molai. Akiliinga-pe kot tinjingí kene kot-na angiliiku kene yi kanuma kene yi kanuma nukungí yi-nuimima kene eni ‘Nanga ungele piliangi.’ niku enini niku singí. ");
INSERT INTO mux_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Akiliinga-pe eni ka siku kot tinjingí kene ‘Kotna nambulka ung te nimulúnje? Oliu ung te walsiku piliingí kene nambulka ung te pundu topu nimulúnje?’ niku mini-wale naa mundai. Aku tingí enaliinga eni ung ningí mele piliingí. ");
INSERT INTO mux_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eni ung ningíma eni-enini piliiku kene naa ningí. Eninga ⸤mulú-koleana molemú⸥ Lapanga Minéle eninga kerina molupa kene nimba simba ungma eni anju ningéliinga numanu liiku naa munduku, piliingí mele we niai. ");
INSERT INTO mux_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“⸤Wale akumanga⸥ angin-ni yunga anginele ‘Kulupili toku konjangi.’ nimba kot tenjimba. Lapale-ni yunga kangambulama akuko temba. Kangambulama-ni kepe eninga anupili lapalii-kene arerembi kolku kot-na meku puku “Toku konjangi.” ningíko. ");
INSERT INTO mux_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nanga yambuma mulungéliinga yambuma-ni pali eni-kene numanu kis panjingí, akiliinga-pe na munduku naa kelku enama pora naa nipili tondulu munduku mulungí yambuma ⸤Pulu Yili-ni⸥ tepa liipa ‘Mindili nungí koleana naa puku, wasie molupu konjupu mindi pamili.’ nimbá. ");
INSERT INTO mux_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kolea tenga yambuma-ni ‘eni mindili nangi.’ niku teku kis-singí kene kolea tenga-lupa takara toku pai. Na-ni enindu aima sika nikerele: “Eni kolea-Isrel sukundu koleamanga pali anduku nanga kongunale ui teku pora naa sinjangi Mania Omba Mana-Yi Au Talurum Yili ⸤kelepa yandu⸥ ombá.” niker. ");
INSERT INTO mux_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ung-bo tunjuli yi te lumbili puku ungma piliilimili yambuma ‘Eninga ung-bo tunjuliele mandupa, eni ola-kilia.’ kapula naa ningí. Kendemande-yambu te-ni ‘yunga nukuli yili mania-kilia, yu ola-kilia.’ kapula naa-ko nimbá. ");
INSERT INTO mux_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Lumbili pupa ungma piliilimú yambale kene yunga ung-bo tonjulemú yili kene kapula-kapula molembele akili kapula. Kendemande-yambale kene yunga nukuli yili kene kapula-kapula molembele akili kapulako. Lku pulu yilinga ung naa piliilimili yambuma-ni yu-kene arerembi kolku ung-mura singíndu ⸤kurumanga nuim Seten-nga bili manda leku⸥ “Yu Belsipull” niku bili lelemele kanili. Pe ekupu lku pulu yilindu aku-siku níngi lem yunga lkuna pelemelé yambumandu pali aima lakuku olandupa ung kísima ningíko. ");
INSERT INTO mux_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“⸤Nanga ele-tu yambuma-ni na teku kis-silimele mele eni na lumbili anduli yima sika teku kis-singíko⸥ akiliinga eni yambu kanuma mundu-mong naa teai. Panda tolemú ulumanga tilu kepe pe panda naa topa pali mokeringa lemba. Mo tolemú ulumanga tilu kepe penga mo naa tomba. Ulu kanuma kene ungma pali yambuma-ni pali piliingéliinga mundu-mong naa teai. ");
INSERT INTO mux_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Na-ni enindu sumbulsuli niliu ungma tangiliim niai. Ung ólu-wálu toku ningí eni-enini kumuna piliingí ungma lku-imuna ola angiliiku nangale toku niai. ");
INSERT INTO mux_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Kangiele mindi toku konjuku kene minéle kapula toku naa kunjingí yambuma mundu-mong naa teai. ⸤Pulu Yili mindi mundu-mong teai⸥. Yu-ni kangiele kene minéle kene wasie-nele tepi-koleana kapula topa konjumbaliinga yu-mindi mundu-mong teai. ");
INSERT INTO mux_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Kera-kalepandele aima kelále molemú, taropu toku liingíndu kera tale kene wasie ku-moni mong tilu mele mindi pulimú kanili. Akiliinga-pe te kolupa we mania naa pulimú. Kera kanuma na lumbili anduli yambumanga ⸤mulú-koleana molemú⸥ Lapale-ni kanolemú. ");
INSERT INTO mux_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Eni ⸤na lumbili andúlima⸥, eninga pengi-dima kepe yu-ni kórunga tilu-tilu nimba pali kambu turum. ");
INSERT INTO mux_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Eninga ⸤mulú-koleana molemú⸥ Lapale-ni aku-sipa eni molemele mele kanupa mololsiliipa pulimáliinga ⸤‘Yambuma-ni oliu teku kis-singí.’ niku⸥ mundu-mong naa teai. Kera-kalepandele yunga ku-moni aima koltale mele pulimáliinga-pe kera kanili Pulu Yili-ni kanupa molemú. Eni yambuma aima olandupa aulima piliipa kene eni aima nokupa konjupa molumba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Yambu te-ni yambumanga kumbi-kerina ola angiliipa “Na Yesos-nga yambale moliu.” nimbá kene na-ni Tata mulú-koleana molemáliinga kumbi-kerina ola angiliipu kene “Yambu kanili nanga yambale.” nimbúko. ");
INSERT INTO mux_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Akiliinga-pe yambumanga kumbi-kerina “Yesos yu naeye? Yu na naa piliiker.” aku-mele nimbá yambale yunu na-ni Tata mulú-koleana molemáliinga kumbi-kerina “Yambu akili yu naeye? Yu na naa piliiker.” nimbúko. ");
INSERT INTO mux_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“‘ ‘Ya mana-yambuma ele naa teku tiluna kapula-kapula molangi.’ nimbu urundu.’ niku naa piliai. Enini yambuma ‘Táka-niku molku kapula-kapula molangi.’ nimbúndu naa urundu. ‘Arerembi kolku ele teangi.’ nimbúndu urundu. ");
INSERT INTO mux_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","‘Yambuma-ni teangi.’ nimbúndu urundu akili i-sipa mele: “Yi te-ni yunga lapa kene ele tipili, limin te-ni yunga anum kene ele tipili, málu tenga mínu-ni yunga bamu kene ele tipili. Lku tiluna pelemelé yambuma ele-tu mulungí.” ‘Aku teangi.’ nimbúndu urundu. ");
INSERT INTO mux_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Yambu te-ni na ola-kilia numanu naa monjupa, yunga lapa mola anum lakupa numanu monjumba yambale ‘Nanga yambale mulupili.’ nimbále kapula naa temba. Yambu te-ni na olandupa numanu naa monjupa, yunga málale mola limin lakupa numanu monjumba yambale ‘Nanga yambale mulupili.’ nimbále kapula naa temba. ");
INSERT INTO mux_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yambu te-ni ‘Yu lumbili pambu.’ nimba kene yambuma unji-perana angiliiku mindili noku kolemele mele yu-ni unji-pera mele koma lembandu ‘Na yu lumbili pumbundu mindili nundu lem kapulako; kulundu lem kapulako.’ naa nim lem ‘Nanga yambale mulupili.’ nimbále kapula naa temba. ");
INSERT INTO mux_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yambu te ya ma-koleana ‘Na molupu konjupu, nondupa naa kolambu.’ nimba piliilimú yambale kolupa kene kolea kísina mindili nomba molupa mindi pumba. Akiliinga-pe yambu te na lumbili andupa nanga kongunale tenjimbandu ‘Ya ma-koleana mindili nombu molumbu kene kapulako, kolumbu kene kapulako.’ nimbá yambale kona molupa konjupa mindi pumba. ");
INSERT INTO mux_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Eni kolea tenga-lupa pungí kene yambu te-ni ‘Wasie molamili wai.’ nimba liipa tapunjilimú yambale-ni na wasie aku-sipa liipa tapunjilimúko. Na ‘Wasie molambili ui.’ nilimú yambale-ni na “Ma-koleana pui.” nimba liipa mundurum yili ‘Wasie molambili ui.’ nilimúko. ");
INSERT INTO mux_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yambu te-ni Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yambu te olemú kene ‘Yu Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yambu te akiliinga’ nimba piliipa kene “Wasie molambili ui.” nimba liipa tapunjilimú yambale Pulu Yili-ni yunga ungele nimba silimú yambale méle kalomba mele liipa tapunjilimú yambu kanili kepe tilu-sipa-mele kalombako. Yambu te-ni Pulu Yili-nga ungele piliipa liipa numanu sumbi nipili molemú yambu te olemú kene ‘Yu Pulu Yili-nga ungele piliipa liipa numanu sumbi nipili molemú yambu te akiliinga.’ nimba piliipa kene ‘Wasie molambili ui.’ nimba liipa tapunjilimú yambale ⸤Pulu Yili-ni⸥ yambu sumbi-nili kanili méle kalomba kene yu liipa tapunjilimú yambale kepe tilu-sipa-mele kalombako. ");
INSERT INTO mux_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yambu te-ni eni nanga lumbili anduli yambu bi naa mululi yambu te kanupa ‘yu nanga lumbili anduli yambu te akiliinga’ nimba piliipa kene yu liipa tapunjupa we no kepe kolupa símu lem na-ni eni aima sika nimbu siker: “Yambu kanili aima sika méle kaluliele liimba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesos-ni yunga lumbili anduli yi rurepundu yunga kongunale tinjingí mele mani sipa pora sipa kene, yu kolea kanili mundupa kelepa kolea Gallalli distrik taon-manga andupa ung-mani sipa, ung-bo tonjupa, ⸤Pulu Yili-nga⸥ ungele nimba sirim. ");
INSERT INTO mux_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","⸤Pulu Yili-ni “Nanga yambuma nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim⸥ Kraisele-ni ulu-tonduluma tirimeliinga Jon ka-lkuna pepa piliipa kene, “Yesos-ndu i-sipa i-sipa walsiku piliinjangi.” nimba yu lumbili anduli mare Yesos mulurumna liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yi kanuma Yesos mulurumna oku yu walsiku piliiku niku mele: “Pulu Yili-ni oliu nokupa konjumba yi te “Liipu mundumbu.” nimba, nimba panjurum yili ‘Ombá.’ nimbu nokupu molemulu kanili nu mola te-lupa ombáliinga nokupu molamiliye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesos-ni eninindu pundu topa nimba mele: “Eni ya kanokumele mele kepe piliikimili mele kepe puku Jon niku si-pai. ");
INSERT INTO mux_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mong kis lili yambuma mongale-ni kanuku, kimbu kis lili yambuma kapula anduku, kuru-laká núlima bo-kangi angiliipa, kum sílima kumele-ni ung piliiku, kolupa lílima lomburuku ola molemeleko, korupa púlima temani kaiéle topu siliu piliilimiliko kanili. Aku-siku Jon-ndu niku sai. ");
INSERT INTO mux_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na kanuku kene ‘Yu sika yi kanili molemú.’ niku tondulu munduku piliiku kene, alsuku numanu tale naa panjiku mulungí yambuma Pulu Yili-ni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon-nga lumbili andúlima pungí puring kene Yesos-ni alsupa yambu pulele máku toku muluringmandu Jon-ndu nimba mele: “⸤Kolea-wakana Jon-ni no liinjipa mulurum kene⸥ eni kolea-waka kanuna nambulkari kanungí puringiye? Lkepanie mele popuremi-ni topa lop-lope tenjipa mulurum te kanungí puringiye? ");
INSERT INTO mux_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","⸤Mólu kanili. Taki-taki kanolemele mele kanungí naa puring lem⸥ ulu nambulkari kanungíndu puringiye? Yi te mulumbale aima kaíma pakupa mulurum-na kanungí puringiye? Akili móluko. Yambu mulumbale aima kaíma pakolemelema yi nuim kingimanga lkuna mindi molemele kanili. ");
INSERT INTO mux_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","“⸤Aku-sili te kanungí naa puring lem⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba sili yi te kanungí puringiye? Akili sika akiliinga-pe na-ni enindu nimbu siker: “Jon yu sika Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba sili yi te akiliinga-pe yu Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa nimba sili yi we te mólu.” niker. ");
INSERT INTO mux_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yunu-ni Pulu Yili-ni ui “Liipu mundumbu.” nirim yilinga kupulanumele tepa mimi tímu kanili. Yi kanilindu Pulu Yili-nga bukna sukundu molemú ung te i-sipa mele: ‘⸤Pulu Yili-ni yunga Málalendu nimba mele:⸥ “Piliai. Nanga ung te ninjimba yili na-ni nu puni kupulanum-na yu kumbi-lepu liipu mundukur. Yunu-ni nunga kupulanumele akisinjimba.” nirim.’ ung kanili bukna molemú. ");
INSERT INTO mux_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na-ni enindu aima sika nimbu siker: “Ui ma-koleana muluring yambumanga te No-Liinjili Jon-kene kapula mólu. Jon ola-kilia mele. Akiliinga-pe ekupu ena konale wendu okum. Ena kanili Pulu Yili yi nuim kingele molupa nokulemú yambumanga te aima bi naa molupa aima korupa puli yambale ola-kilia; Jon yu mania-kilia.” niker. ⸤Ui muluring yambuma mania mele; ekupu na ‘Sika’ niku tondulu munduku piliingéliinga numanu kaí pemba yambuma olandupa mele.⸥ ");
INSERT INTO mux_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Jon ui naa mulupili ung-manima molemú buk Moses-ni turum-ma kene, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siku bukna turing bukma kene, buk akuma-ni Pulu Yili-nga ungma niku siku, Jon kene Pulu Yili-ni “Eni nokumba yi-nuim te liipu mundumbu.” nimba, nimba panjurum yili kene unglí mele ungma niring. Akiliinga-pe Jon urum kene yandupa Pulu Yili yi nuim kingele molupa yambuma nokulemú ulele aima tondulu mundupa wendu omba yunga ele-túma topa mania mundulimúko; yi tondulu púlima-ni ulu akili ambulungíndu tondulu munduku karaye teku liingí tekemeleko. ");
INSERT INTO mux_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ung te nimbú tekerale piliimulú niku piliiku liingí lem piliangi. Pulu Yili-nga bukna “⸤Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba simba yi⸥ Illaija ombá.” nirim yi kanili Jon-ndu nirim. ");
INSERT INTO mux_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ya niker mele kum angiliimú yambuma-ni aima mimi-siku piliai!” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ekupu mana molemele yambuma nambulka méle te kene enini manda lepu nimbúnje? ⸤Enini molemele mele i-sipu nimbu sambu:⸥ Enini yambuma máku tolemele koleana kangambulama pepi pereku molemele mele. Kangambula kanumanga mare-ni ne anju molemele kangambula mare ⸤wasie pepi pereku mulungí kupulanum te koruku kelku kene⸥ eninindu walsiku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Konana nímulu kene eni ‘Wasie konana niamili.’ naa niku “Mólu.” níngi. Pe kelepu kola tímulu kene eni ‘Wasie kola teamili.’ ni naa níngi. ⸤Wasie pepi perepu molomulú kupulanum te mólu lam.⸥” nilimele. ⸤Ekupu molemele yambuma enini kangambula kanuma mele molemele.⸥ ");
INSERT INTO mux_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","⸤Na kene No-Liinjili Jon kene olsu-ni nilimbulu ungma enini piliiku kis piliilimili; telembulu mele kanuku kis piliilimiliko⸥. Jon omba kene ga kene no-waen kene naa nomba mulurumeliinga ⸤kanuku kis piliiku kene⸥ niku mele: “Yunga numanuna kuru te molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe Mania Omba Mana-Yi Au Talurum Yili omba ga kene no-waen kene nurum kene ⸤kanuku kis-ko piliiku kene⸥ niku mele: “Yu ga pulele nomba kis piliipa, no-waen pulele nomba kelep topa telemú yili. Yu ku-moni-takis liili yima kene, ulu-pulu-kis telemele yambu-wema kene ‘Yu-kene pulu lipili wasie tapú-topu molamili.’ nimba telemú.” nilimeleko. ⸤Enini aku-siku Jon kanuku kis-ko piliilimili. Na kanuku kis-ko piliilimili.⸥ Akiliinga-pe piliipa kungnjuli ulu-pulele Pulu Yili-kene pelemú-na yu-ni telemú mele kanuku kene ‘Papu telemú.’ ningí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aku nimba kene Yesos kolea ui andupa ulu-tondulu pulele tirim koleamanga ⸤muluring yambuma⸥ yunu-ni tirim mele kanuku kene eninga ulu-pulu-kísima kanuku kis piliiku munduku kelku numanu topele naa turing kanupa kene yunu-ni enini ung-mura sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolea Korasin kene Besaida taon-selenga ⸤molemele yambuma⸥ mindili noku aima molku kis-singí! Kolea akuselenga sukundu ulu-tondulu pulele tirindu ⸤akiliinga-pe akuna molemele yambuma numanu topele naa tolemele⸥. Kolea-auli Taya kene Saidon-selenga sukundu ⸤ulu-tondulu te naa tirindu akiliinga-pe kolea kanuselenga sukundu⸥ na-ni ulu-tondulu aku-sipu telka kanolkemelanje kolea kanuselenga ⸤yambuma-ni⸥ enini ulu-pulu-kis telemelema kórunga munduku kelku, liiku bulu siku, numanu topele tolkemela. ");
INSERT INTO mux_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Akiliinga na-ni enindu nimbu siker: “Penga kot enale wendu ombá kene kolea Taya kene Saidon kanuselenga ⸤yambuma ulu-pulu-kis telemeláliinga⸥ eninga kot kelú mele pemba. Akiliinga-pe eni kolea Korasin kene Besaida-selenga ⸤yambuma na-ni ulu-tonduluma tirindu kene kanuku kene numanu topele naa turingeliinga⸥ kot enale wendu ombá kene eninga kot auli-mele pemba.” ");
INSERT INTO mux_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Kapeniam taon-na ⸤yambuma eni⸥ ‘Mulú-koleana pupu molamili.’ niku piliikimiliye? Akili kapula mólu. ⸤Eni nanga ungma taki-taki piliilimili akiliinga-pe numanu topele naa tolemeláliinga⸥ eni kolea kísina puku mulungí. Eninga koleana sukundu ulu-tondulu pulele tirindu ⸤akiliinga-pe eni numanu topele naa turing⸥ . Kolea-auli Sodom sukundu ⸤ulu-tondulu te naa tirindeliinga-pe kolea kanuna sukundu⸥ na-ni ulu-tondulu aku-sipu telka kanolkemelanje yambuma numanu topele tolkemela, pe ekupu kepe kolea kanili we lelka. ");
INSERT INTO mux_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Akiliinga na-ni eni ⸤Kapeniam yambumandu⸥ nimbu siker: “Kot enale wendu ombá kene kolea Sodom ⸤yambuma ui ulu-pulu-kis pulele sika tiringeliinga-pe⸥ eninga kot kelú mele pemba. Akiliinga-pe eni kolea Kapeniam ⸤yambuma na-ni ulu-tondulu tirinduma kanuku kene numanu topele naa turing yambuma,⸥ kot enale wendu ombá kene eninga kot auli-te mele pemba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ena akumanga Yesos-ni nimba mele: “Tata, Mulú-Ma-sele Nokukunu Mollu Yi-Nuimele, na-ni nu-kene ‘Angke’ niker. “Oliu piliipa kungnjuli pelemú. Oliu-oliuliu ungmanga puluma pali piliipu konjulimulu.” niku piliilimili yambuma enini na-ni ekupu teliu ulumanga pulele nu-ni ‘Naa piliangi.’ nikunu naa niku sirinu. Yambu kangambula-pame mele molku na-ni niliu ungma kum teku molemele yambuma mindi na-ni teliu ulumanga pulele ‘Piliangi.’ nikunu, enini niku sirinu kaniliinga nu kape nimbu ‘Papu tirinu.’ niker. ");
INSERT INTO mux_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Sika, Tata, nu-ni ‘aku-sipa wendu ombá kene numanu simbu.’ nikunu aku-sikunu tirineliinga ⸤aku-sipa wendu okum⸥.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","⸤Pulu Yili-ndu aku-sipa nimba kene kelepa yambu muluringmandu nimba mele:⸥ “Mélema pali Tata-ni na sirim. Yambu te-ni Málale aima sika molemú mele piliipa kanupa bi silimú yambu te mólu; Lapale-ni mindi yu kanupa bi silimú. Yambu te-ni Lapa aima sika molemú mele piliipa kanupa bi silimú yambu te mólu. Málale-ni mindi kanupa bi silimú; Málale-ni ‘Lapa liipu ora sambu.’ nimbá yambuma enini Lapa kanuku bi singíko. ");
INSERT INTO mux_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Eni kongun mindili siku telemele yambuma kene, numanuna buni telemú yambuma kene, na moliuna wai. Ungí kene na wasie numanu tiluna pumbaliinga na-ni ‘Numanu waengu nipili kóru molai.’ nimbú. ");
INSERT INTO mux_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nandu “Nunga kongun tellu mele wasie tenjambili. Nu nanga ung-bo tunjuliele molani. Nunga ung niníma piliipu liipu molambu.” niku teai. Na táka-nimbu molupu, yambuma-ni na teku kis-silimele kene piliipu mundupu kelepu moliáliinga ya niker mele eni na molumbuna oku tingí kene eninga numanuma waengu nimbá. ");
INSERT INTO mux_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nanga kongun teliále wasie teambili kene we-we sikunu tiní. Méle penta nílima mindi siliáliinga moliuna wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Walse, ⸤kóru muluring⸥ ena Sambat tenga, Yesos kene yu lumbili anduli yima kene rais-wit puniemanga oku puring kene yu lumbili anduli yima engle-ni kolku kene rais-wit mong mare lkeku nuring. ");
INSERT INTO mux_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aku tiring kene kanuku kene Perisi-yima-ni Yesos yunundu niku mele: “Kána! ⸤Kóru molemulu⸥ ena Sambateliinga ‘Kongun naa teangi.’ nimba pelemú ung-manele nu lumbili anduli yima-ni ung-manele toku pula toku kene aku-siku tekemele.” niring. ");
INSERT INTO mux_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesos-ni pundu topa nimba mele: “Eni Pulu Yili-nga bukna sukundu ⸤anda-kolepa yi nuim king⸥ Depit-ni tirim mele nimba molemú temanele kanuku kene temaneliinga pulele naa piliilimiliye? Depit kene yunu wasie puring yima kene enini engle-ni kolku kene, ");
INSERT INTO mux_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Depit Pulu Yili mulurum sell-lkuna sukundu pupa, Pulu Yili-nga kumbi-kerina lirim pllawa kalúlima liipa nomba, yunu wasie puring yima sirim nuringko kanili. Pllawa-kaluli kanumandu Pulu Yili-ni ung-mani te sipa kene nimba mele: “We-yambuma-ni aima naa nangi! Pulu Yili popu tunjuli yima mendepulu nangi!” aku-sipa mele nirim ⸤ung-mani kanili topa pula turum⸥ kanili. ⸤Eni numanu tale nambimuna piliilimiliye? Depit yunu-ni ui aku tirim mele eni piliiku kis naa piliilimiléliinga ekupu na lumbili anduli yima-ni tekemele mele kanuku kis naa piliai.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Ung-mani te pelemúko. “Pulu Yili popu tunjuli yima-ni ⸤kóru mululi⸥ ena Sambat-manga Pulu Yili-nga lkuna kongun telemele kene ena Sambat-manga ung-manele pula tolemelaliinga-pe kongun telemele akiliinga mong naa pemba.” nimba molemú akili naa-ko piliilimiliye? ");
INSERT INTO mux_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na-ni enindu nimbu siker: “Méle kona te ekupu pelemú akili Pulu Yili popu toku kalemele lku-tembollaliinga ola-kiliele.” niker. ");
INSERT INTO mux_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","⸤Pulu Yili-ni nirim ung te yunga bukna molemú mele i-sipa:⸥ “Eni yambuma kondu kolemele kene kanupu kaí piliiliu. Na popu toku kungma kalemele akili ulu te mólu.” nilimú, akiliinga ung-pulele eni Perisi-yima-ni piliilkimilánje yi ulu teku kis naa sikimili yi ima “Teku kis-sikimili.” naa nilkimela. ");
INSERT INTO mux_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mania Omba Mana-Yi Au Talurum Yili-ni ena Sambatma nokulemú yili molemú-na ⸤ena Sambatele-kene yambuma molku kunjingíndu tingí mele kapula nimbá kanili⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kanu-kene Yesos kolea akili mundupa kelepa pupa Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku tenga purum. ");
INSERT INTO mux_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lku kanuna yi te mulurum, yunga ki te kamu kolupa kukurum. Kanu-kene akuna muluring yi mare-ni ‘Yesos-ni ulu te tepa kis-simba kene kot tenjamili.’ niku yunu walsiku piliiku kene niku mele: “Kóru molemulu ena Sambat-kene yambu kuru tolemúma tepu kaí temulú kene kapula mola aku tímulu lem Pulu Yili-nga ung-manele pula tomulúye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesos-ni yimandu pundu topa nimba mele: “Ena Sambatele-kene yi tenga kung-sipsip te kusina topa mania mundumba kene sipsip ari telemú yili-ni kundupa ola liipa memba naa ombáye? ");
INSERT INTO mux_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Aku lem sipsip mania-kilia mele, yambuma aima ola-kilia, akiliinga, ena Sambat-kene ulu kaíma kapula naa temulúye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aku nimba kene ki kolupa kukurum yilindu nimba mele: “Nunga kili sunu si.” nirim kene yili-ni yunga kili sunu sirim kene yunga ki ekendu kaí lirim mele ki kis lirimele alsupa kamu kaí lirim. ");
INSERT INTO mux_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Akiliinga-pe ⸤Yesos-ni aku tirim kene kanuku kene⸥ Perisi-yima-ni pena puku máku toku “Yu nambi-sipu topu konjumulúye?” niku kupulanum te kururing. ");
INSERT INTO mux_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","⸤Perisi-yima-ni⸥ yu tungí tiring piliipaliinga Yesos kolea akili mundupa kelepa purum. Kanu-kene yambu pulele Yesos purum mele yunu lumbili puring kene yunu-ni yambu kuru turum-ma pali tepa kaí tepa kene ");
INSERT INTO mux_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nimba mele: “Na sika yili molupu kene ulu-tondulu ima teker mele eni yambu lupa marendu naa niku para sai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aku-sipa wendu urumeliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni ulu te penga wendu ombá ui nirim mele kamu wendu urum. Asaya-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yi ili nanga makó turundu kongunale tinjili yili; na-ni yi ili numanu monjupu, yunu kanupu aima kaí piliiliu yili. Nanga Minéle yunga numanuna panjinjimbu. Yunu-ni ma-koleana yambuma pali na-ni enini sumbi-sipu nokumbu mele nimba simba. ");
INSERT INTO mux_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yambuma-ni yunu ung-mura singí kene yu-ni pundu topa ung te naa nimba, ung te tondulu mundupa naa nimba, yambuma anduku molemele koleamanga yunu-ni ele-ung naa nimbá. ");
INSERT INTO mux_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kamaye tondulu naa pulimú te elki naa topa, tepi-llam mimi-sipa naa nolemú kene kamu topa naa kumunjumba. ‘Pulu Yili-ni yambuma kamu sumbi-sipa nokumba enale kamu wendu upili.’ nimba yunu aku-sipa naa tepa táka-nimba molumba. ");
INSERT INTO mux_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Kanu-kene mana-yambuma pali ‘Yunu-ni ‘oliu mindili naa namili.’ nimba tepa liimba.’ niku mulungí.” nirim ung akili wendu urum. ");
INSERT INTO mux_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kanu-kene yi te yunga numanuna kuru te mulurum-na mong kis lepa mélema naa kanupa ung naa nirim yi te Yesos mulurumna meku uring kene Yesos-ni yili tepa kaí tirim kene yi kanili ung nimba mélema kanurum. ");
INSERT INTO mux_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Aku tirim kanuku kene yambuma-ni pali mini-wale munduku kene niku mele: “Yi ili ⸤yi nuim king⸥ Depit-nga Málalenje?” niring. ");
INSERT INTO mux_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Akiliinga-pe niring ung akili piliiku kene Perisi-yima-ni niku mele: “Mólu. Kurumanga nuim Belsipull mindi i yi ⸤Yesos-⸥nga numanuna molupa kene yunu tondulu silimú-na yunu-ni kuruma topa makorolemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Enini aku-siku numanale-ni piliiring mele Yesos-ni piliipaliinga ⸤‘Yesos ‘Seten-kene ele-tu muluringeliinga Seten-ni yunu naa liipa tapunjulka.’ niku aima piliangi.’ nimba⸥ eninindu nimba mele: “Yambu-talape te numanu tiluna naa pupili molku suku-singina oe panjiku eni-enini ele teku lupa-lupa molemele kene talape kanili pora nilimú. ⸤Mola⸥ kolea tenga yambuma mola lku tiluna pelemelé yambuma numanu tiluna pupili naa molku eni-enini ele telemele kene yambu-talape kanili sungu siku lupa-lupa molemele. ");
INSERT INTO mux_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aku-sipako, Seten-ni yunga kuru te topa makurulkanje aku telkaliinga yunga talapele kene ele mele telka. Pe yunga talapele nambi-sipa kapula molkemelaye? ⸤Pora nilka.⸥ ");
INSERT INTO mux_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Ung te kamu piliai. Na-ni Belsipull-nga tondulale-ni kuruma topu makuruliu lem eninga yima-ni naenga tondulale-ni kuruma toku makurulemeleye? Akiliinga, ⸤eninga yi kuruma toku makorolemele yima-ni ‘Pulu Yili-ni oliu tondulu silimú-na oliu-ni kuruma topu makorolemulu.’ niku piliilimiléliinga⸥ eni nandu nikimili ung ima yi kanuma-ni piliiku apuruku kene “Eni gólu tokomele.” ningí. ");
INSERT INTO mux_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akiliinga-pe sika Pulu Yili-nga Minéle-ni na tondulu silimú-na na-ni kuruma topu makuruliu lem Pulu Yili yi nuim kingele molupa yambuma nokumba enale eni molemelena kórunga wendu um.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ung te wasie i-sipa mele: Yi tondulu puli te-ni yunga lkuli nokupa konjulimú kene yi te-ni we kapula sukundu omba mélema wa liipa memba pulimúye? Akili kapula mólu. Ui wa nuli yili-ni yi tondulu pulieliinga kimbu kima ka siku kene yunga lkuna kapula omba mélema wa liilimú kanili. ");
INSERT INTO mux_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na naa liipa tapunjilimú yambale-ni na-kene ele-tu molemú. Yambu te-ni na liipa tapunjupa ⸤kung-sipsipma⸥ sukundu naa liilimú yambale-ni ⸤kung-sipsipma⸥ topa bulu-bale silimú. ");
INSERT INTO mux_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Akiliinga, na-ni enindu niker: “Yambu te-ni ulu-pulu-kísima tepa, ung-taka tonjupa nimba kis-silimú uluma Pulu Yili-ni kapula ‘Mania pupili.’ nimba kanupa konde tenjimba. Akiliinga-pe yambu te-ni Pulu Yili-nga Minéle nimba kis-sipa ung-taka tonjupa yunga bili marake mele temba uluma Pulu Yili-ni ‘Mania naa pupili.’ nimba mundupa naa kelemba.” niker. ");
INSERT INTO mux_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mania Omba Mana-Yi Au Talurum Yili ung-taka tonjupa ung nimba kis-silimú yambale aku-sipa ulu-kis telemúma Pulu Yili-ni ‘Mania pupili.’ nimba kanupa konde temba. Akiliinga-pe Mini Kake Tiliele⸤-ni ulu te telemú kene⸥ yambu te-ni ung-taka tonjupa, ele tepa sipa ⸤“Yunu-ni naa tekem. Kurumanga nuim Seten-ni yunu liipa tapunjilimú-na telemú.⸥” nilimú yambu akili aku-sipa ulu-kis telemále ekupu kepe mulú ma pora nimbá ena kene kepe ‘Mania naa pupili.’ nimba aima kanupa konde naa tenjimba. ");
INSERT INTO mux_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Unji kaí te kanuku kene ‘Mong kaíma tomba nomulú.’ niku kanolemele. Unji kis te kanuku kene ‘Mong kísima tomba kapula naa nomulú.’ niku kanolemele. Unji te mong tolemú kene kanuku kene ‘Unji ili kaí, unji ili kis.’ niku i-siku apuruku kanolemele. ");
INSERT INTO mux_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Eni Perisi-yima, gólu topa yambuma tepa kis-sili wambiyelenga walúma, eni yi kis molemelema-ni nambi-siku ung kaíma kapula ningíye? Yambu te yunga numanuna pelemú ungma mindi kerina nilimú akiliinga eni yi kísima-ni nambi-siku ung kaíma kapula ningíye? ");
INSERT INTO mux_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Aku-sipa mele, yambu kaí te-ni yunga numanuna ulu kaí pelemúma telemú, akiliinga-pe yambu kis te-ni yunga numanuna ulu-kis pelemúma telemú. ");
INSERT INTO mux_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","37","“Akiliinga na-ni enindu nimbu siker: “Pulu Yili-ni yambuma kot tenjimba enaliinga eni-enini ung nilimelema apurupa piliipa kene “Nu yambu kaiéle, nu yambu kisele.” nimbá akiliinga yambuma-ni mana-we-ung nilimelema pali kepe apurupa piliipa kene “Ung akuma nambimuna niringiye?” nimbá.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kanu-kene Perisi-yi mare kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare kene enini Yesos-ndu niku mele: “Ung-Bo Tunjuliele, ‘Nu sika Pulu Yili-ni “Kongun tenjani.” nimba ma-koleana liipa mundurumnje oliu kanamili.’ niku Pulu Yili-ni mindi kapula ulu-tondulu telemú mele te ti.” niring. ");
INSERT INTO mux_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesos-ni pundu topa nimba mele: “Ekupu ma-koleana molemele yambuma kis mindi molemele. Enini teku kis-siku Pulu Yili liiku su silimele yambuma-ni “Pulu Yili-ni mindi ulu-tonduluma kapula telemú mele kanamili ti.” niku na mawa telemele. Akiliinga-pe ⸤Pulu Yili-ni na liipa mundurum-na ombu molkur. Yu-kene tapú-topu kongun telembulu mele liipa ora simba⸥ ulu-tondulu te wendu naa ombá. Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Jona-kene wendu urum ulu akili-ni mindi liipa ora silimále kapula kanungí. ");
INSERT INTO mux_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oma auli te-ni Jona topa pengí mundurum kene yunu omaliinga oluna sumbulsum tanguli ena yupuku molupa pirim ⸤kene omale-ni yunu no-numú kéluna miku topa wendu mundurum kene yunu alsupa we mulurum⸥ mele Mania Omba Mana-Yi Au Talurum Yili ⸤kolumba kene angnjiku panjingí kene⸥ aku-sipa sumbulsum tanguli ena yupuku mana sukundu pepa kene ⸤lomburupa ola molumba⸥. ");
INSERT INTO mux_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Ui kolea-auli Ninipa-yambuma ⸤sika molku kis-siringeliinga-pe Pulu Yili-ni wendu ombá mele “Nikunu si.” nimba yundu nimba sirim mele⸥ Jona-ni ⸤piliipa⸥ Ninipa-yambuma pupa nimba sirim kene piliiku kene teku kis-siring mele kanuku kis piliiku numanu topele toku molku kunjuring. Aku tiringeliinga ekupu molemele yambuma-ni Jona-nga olandupa yi te ya molemú yilinga ungele liiku su siku naa piliilimiléliinga kot-enale penga wendu ombá kene Ninipa-yambuma-ni kot-na angiliiku, ekupu molemele yambumandu “Teku kis-siring. Mindili nungí kene kapula.” ningí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Ui oliu Isrel-yambumanga yi nuim king Sollomon yunu yi aima tondulu te molupa, yunu ung lupa-lupama piliipa kungnjuliele pípili mulurum mele kolea Sipa nukurum ambu nuim kuinele piliipaliinga, Sollomon-ni ung kaíma mindi nirim mele piliimbandu yunu kolea suluna molupa kene ⸤Sollomon mulurumna⸥ ena pulele kupulanum-na pelsiliipa urum. Aku-sipa tirimeliinga, yi-nuim Sollomon-nga olandupa ya molemú yili-ni nilimú ungele ekupu mana molemele yambuma-ni naa piliiku, liiku su silimeláliinga kot-enale wendu ombá kene kolea Sipa ambu nuim kuinele-ni nimba mele: “Sollomon-ni ung kaí nirim akili na-ni piliimbundu kupulanum suluna urundu akiliinga-pe Sollomon-nga olandupa mulurum yili-ni nirim ungele eni naa piliiku, liiku su siring yambuma tiring akiliinga eni mindili nungí kene kapula.” nimbá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kuru te yi tenga numanuna wendu omba kene, no naa mululi koleamanga pupa kapula kóru molumba kolea te korolemú. Te naa kanupa lenjipa kene ");
INSERT INTO mux_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yunu-ni nimba mele: “Na ui molupu kene wendu úndu lkuna kelepu pambu.” nimba yunu omba yunu ui molupa purum lkuli kanolemú kene lku kulsupana memba tepa kaí tepa we lepa yambu te naa molemú kene kanupa kene, ");
INSERT INTO mux_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","yunu kelepa anju pupa kene kuru kara puli aima olandupa angere yupuku-guli liipa memba omba enini wasie lku kanuna sukundu puku molemele. Kanu-kene yi kanili ui molupa kis-silimú akiliinga-pe penga aima kamu olandupa mele molupa kis-silimú. Aku-sipa, ekupu ya teku kis-siku molemele yambuma penga kamu molku kis-singí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesos yambu máku toku muluringma ung-mani sipa mulupili yunga anum kene anginipili kene yu-kene ung ningíndu oku pena angiliiring. ");
INSERT INTO mux_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yambu te-ni yundu nimba mele: “Aminie kene angenali kene enini nu-kene ung ningíndu oku pena angiliimili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesos-ni yundu pundu topa ⸤ung-eku topa kene⸥ nimba mele: “Nanga anum naeye? Nanga anginipili nameléye?” nimba kene, ");
INSERT INTO mux_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","yunu lumbili anduli yambuma liipa ora sipa kene nimba mele: “Yambu ima nanga anum kene nanga anginipilima kene molemele. ");
INSERT INTO mux_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nanga Lapa, mulú-koleana molemále-ni “Teai.” nilimú mele piliiku liiku telemele yambuma nanga anum kene nanga anginipilima kene nanga kimulupilima kene molemeláliinga aku-sipu niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yambu máku toku muluringmandu aku-sipa nimba pora sipa kene, Yesos lkuna molupa pena pupa numú-⸤Gallalli⸥ kéluna pupa mania mulurum. ");
INSERT INTO mux_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yambu aima pulele yu mulurumna oku máku toku muluringeliinga nona anduli sip te nona ola lirim-na sukundu pupa mania mulurum, yambuma no-numú kéluna angiliiring. ");
INSERT INTO mux_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yu-ni eninindu ung-mani pulele nimba simbandu ung-eku talse turum. Ung-eku te i-sipa topa kene nimba mele: “Piliai! “Yi te-ni rais-wit boma puniena andupa tanda sirim. ");
INSERT INTO mux_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tanda silsiliipa andurum kene bo mare kupulanum-na mania purum, kanuma kerama-ni oku liiku nuring. ");
INSERT INTO mux_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bo mare ku pirimna mania pupa kene ma laye-sele mindi lirimeliinga nondupa mulie topa ola urum. ");
INSERT INTO mux_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Akiliinga-pe pulkanu naa mundurumeliinga ena tirim kene kanuma kulurum. ");
INSERT INTO mux_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bo mare kumbulu-sirkambu aku-sipa mele mulurumna mania purum, sirkambu melale ola omba wit-boma topa nurumeliinga omba kaí naa tepa ⸤mong te naa turum⸥. ");
INSERT INTO mux_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bo mare ma kaína mania purum-ma ola omba mong kaíma turum. Mare mong tokapu-angere mele topa, mare mong tokapu-yupuku mele topa, mare tokapu-tilu mele turum.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","⸤Aku nimba kene⸥ “Yambu kum-peú lelemúma-ni ung ili piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesos lumbili andúlima yu mulurumna oku kene yundu niku mele: “Nu yambumandu ung te niníndu ung-eku taki-taki nambimuna tolluye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yunu-ni eninindu pundu topa nimba mele: “Pulu Yili yi nuim kingele molupa yambuma kene mélema kene nokulemáliinga ulu-pulu yu-yunu piliirim ulu-pulu kanuma ‘Ekupu eni ⸤na lumbili olemele yambuma⸥ piliangi.’ nimba kene eni nimba sikem. Akiliinga-pe we-yambuma nimba naa sikem. ");
INSERT INTO mux_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pulu Yili-nga ungele piliiku molemele yambuma aima lakupa nimba simba piliingí. Penga aima pulele piliingí. Akiliinga-pe naa piliiku molemele yambuma enini layesele piliilimili ungele kepe wendu liimba. ");
INSERT INTO mux_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","‘Enini mongale-ni kanuku kene kanuku bi si naa silimele; kumele-ni piliiku kene piliiku bi naa silimele.’ akiliinga na-ni we-yambumandu ungma nimbu simbundu ung-eku mindi topu siliu. ");
INSERT INTO mux_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Aku-siku teku molemeláliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni “Aku-siku tingí.” ui nirim mele wendu olemú. Asaya-ni nimba mele: “Enini taki-taki kumele-ni piliingí akiliinga-pe numanale-ni piliiku kene aima naa liiku manjingí; mongale-ni kanungí akiliinga-pe méle te aima sika kanuku bi naa singí. ");
INSERT INTO mux_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yambu imanga numanuma aima pipi silimú; enini ung piliingíndu kum naa leku molemele; eninga monguma kumbulku molemele. Aku-siku teku molemeláliinga naa kanuku naa piliiku molemele. Ulu ima aku-sipa naa telkanje enini eninga mongale-ni kanuku kumele-ni piliiku numanale-ni piliiku kene topele tolkemela, kanu-kene na-ni ‘Enini kaí molangi.’ nilka.” nirim. ⸤Asaya-ni aku-sipa nirim mele⸥ ekupu we-yambuma aku-siku teku molemele. ");
INSERT INTO mux_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Akiliinga-pe ⸤na lumbili andúlima⸥ eni mongale-ni aima sika kanuku kumele-ni aima sika piliiku molemeláliinga eni Pulu Yili-ni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. Na-ni enindu aima sika nimbu siker: “Ui muluring yambuma, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima kene, Pulu Yili-nga ungma piliiku liiku sumbi-siku muluring yambuma kene, yambu pulele kanuma ekupu eni mongale-ni kanuku molemele mélema kene uluma kene kanungíndu “Kanámuluka!” niku muluringeliinga-pe naa kanuring. Eni ekupu kumele-ni piliiku molemele ungma piliingíndu “Piliámuluka!” niku muluringeliinga-pe naa piliiring, akiliinga ekupu sika kanuku sika piliilimiléliinga eni Pulu Yili-ni membu panjilimú kupulanum-na molemele.” niker. ");
INSERT INTO mux_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Akiliinga, yambu te-ni rais-wit bo tanda sirim ung-ekaliinga pulele ekupu niambu piliai. ");
INSERT INTO mux_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bo mare tanda sirim kene kupulanum-na mania purum kanumanga ⸤ung-pulele i-sipa mele:⸥ Yambu te-ni Pulu Yili yi nuim kingele molupa mélema nokulemáliinga ungele piliipa naa liilimú kene ulu-kísimanga pali ulu-pulele pelemú ⸤kur⸥ ale-ni omba langi-bo tanda sili numanuna pupa pelemúma walsekale torulupa wendu liilimú. ");
INSERT INTO mux_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Bo mare tanda sirim kene ku pirimna mania purum kanumanga ⸤ung-pulele i-sipa mele:⸥ Yambu mare aku-sílima molemele. Enini ungele piliiku walsekale sumbi-siku numanu siku piliiku liilimele. ");
INSERT INTO mux_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Akiliinga-pe enini pulkanu naa munduku kene ungele layesele mindi piliiku molemele. Penga enini numanuna buni telemú kene mola enini Pulu Yili-nga ungele piliiku liiku molemele mele yambu lupama-ni kanuku kis piliiku kene ung-taka tonjuku teku kis-siku mindili silimele kene eninga piliilimili ungma munduku kelelemele. ");
INSERT INTO mux_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Bo mare tanda sirim kene kumbulu-sirkambu mele mulurumna mania purum kanumanga ⸤ung-pulele i-sipa mele:⸥ Yambu mare kepe aku-sílima molemele. Enini ungele piliilimili kene numanuna buni telemú bunima kene, méle pulele nosuku kene ‘Méle akuma-ni oliu liipa tapunjilimú tapunjumba.’ niku piliiku molemele uluma kene, kanu sili ulu mare wendu omba ung kanili topa nolemú kene ungele-ni ulu te naa tepa langi mong naa tolemú. ");
INSERT INTO mux_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bo mare tanda sirim kene ma kaína mania purum ⸤kanumanga ung-pulele i-sipa mele:⸥ Yambu mare aku-sílima molemele. Enini ungele piliiku liiku kene ung-pulele piliiku konjulemele. Penga enini langi mong tolemele. Yambu mare kanumanga langi mong tokapu-angere mele topa, yambu marenga mong tokapu-yupuku mele topa, marenga mong tokapu-tilu mele topa, aku-sipa tolemú. ⸤Ung-ekaliinga ung-pulele aku-sipa.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesos-ni ung-eku te wasie yambuma topa sipa kene nimba mele: “Pulu Yili yi nuim kingele molupa mélema nokulemú akili i-sipa mele: Yi te-ni yunga puniena rais-wit bo kaíma tanda sirim. ");
INSERT INTO mux_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Akiliinga-pe yambuma uru piring kene yunga ele-tu yi te omba era-kis ⸤rais-wit mele era te⸥ akiliinga bo te wit-puniena tanda sipa kene kelepa purum. ");
INSERT INTO mux_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Kanu-kene bo kaíma ola omba wit-mong turum kene era-kisele kene wasie ola uringli mele mokeringa mulurum kanuring. ");
INSERT INTO mux_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kanu-kene punie pulu yilinga kongun tinjili yima oku yunundu niku mele: “Auliele, nunga puniena langi-bo kaí te tanda naa sirinuye? Pe ekupu era-kisele nambi-sipa ola okumuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yunu-ni eninindu nimba mele: “Tena. Ele-tu yi te-ni era-bo kis akuma omba tanda sirim lam.” nirim. Kongun tinjili yima-ni niku mele: “‘Era-kísima wasie waka-maka ola okumeleliinga pupu era-kísima ukupu liipu máku tamili.’ niku piliikunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Akiliinga-pe yunu-ni nimba mele: “Mólu. Era tíngi lem wit wasie pulu ukungínje. ");
INSERT INTO mux_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Penga kamu wit liipu máku tomuláliinga ui wasie okulu molangli. Penga wit kamu liimulú enale wendu ombá kene na-ni wit kari leku linjingí yambumandu nimbu mele: “Ui era kalangi liiku oru toku máku toku kene, penga wit liiku nanga wit nosiliu lkuna máku toku nosai.” nimbú.” nirim.” nimba, Yesos-ni “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili aku-sipa mele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ung-eku te wasie yambuma topa sipa kene nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: Yi te-ni unji-mastet bo te liipa ");
INSERT INTO mux_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","yunga puniena bo mundurum. Mastet-bo akili langi-bomanga pali yu aima wallú-mele-wele akiliinga-pe ola omba ai lelemú kene puniena molemú mélemanga pali yu aima auliele. Kamu ai lepa unji mele angiliimú kene kerama unji kanuna oku polamanga pelemelé. ⸤Pulu Yili yi nuim kingele molumba mele aku-sipa.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ung-eku te wasie yambuma topa sipa kene nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: Ambu te-ni yu langi-pllawa tepa auli mundulimú méle yis laye-sele pllawa puleliinga mundurum kene pllawa pali akurum. ⸤Pulu Yili yi nuim kingele molumba mele aku-sipa.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ung kanuma pali Yesos-ni yambumandu ung-eku mindi topa nirim. We-ung te eninindu sumbi-sipa naa nimba ung-eku mindi topa nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Aku-sipa tirimeliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te-ni ui nirim ung te kamu wendu urum. Akili i-sipa mele: “Na-ni ⸤ung nimbúndu⸥ ung-eku ⸤mendepulu⸥ topu nimbále. Pulu Yili-ni ui mulú-masele tirim kene kepe yandupa-yandupa kepe ⸤mokeringa naa niring⸥ mo topa pirim ungma ⸤nimbúndu ung-eku mendepolu topu⸥ nimbú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","⸤Yesos-ni ung-eku akuma topa pora sipa kene,⸥ yu máku toku muluring yambuma mundupa kelepa lkundu purum kene yu lumbili anduli yima-ni yu mulurumna oku kene niku mele: “Puniena era-kis urum ung-ekaliinga ung-pulele oliu niku para si.” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yunu-ni pundu topa nimba mele: “Langi-bo kaíma tanda sirim yili Mania Omba Mana-Yi Au Talurum Yili. ");
INSERT INTO mux_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Puniele ma-koleale pali. Langi-bo kaíma yambu ‘Pulu Yili nanga yi nuim kingele mulupili.’ nilimeláliinga eninga numanumanga Pulu Yili-ni tápu-tepa molupa nokulemú yambuma. Era-bo akuma ulu-kísimanga pali ulu-pulele pelemú ⸤kuru⸥ akiliinga yambuma. ");
INSERT INTO mux_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Era-bo kis tanda sirim ele-tu yi akili ⸤kurumanga nuim⸥ depollale. Wit lkundu liiku máku tungí ena akili ma-kolea pora nimbá enale. Wit-monguma lkundu liingí yambuma mulú-koleana angkellama. ");
INSERT INTO mux_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Era-kísima liiku máku toku kene tepina kalemele mele ma-kolea pora nimbá enaliinga aku-sipa. ");
INSERT INTO mux_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mania Omba Mana-Yi Au Talurum Yili-ni yunga angkellama liipa mundumba, enini ‘Yambuma Pulu Yili-nga ungma naa piliiku, teku kis-siku molangi.’ nilimele yambuma pali kene, ulu-pulu-kis telemele yambuma pali kene, Pulu Yili-ni tápu-tepa molupa nokulemú yambuma mulungína wendu liiku máku toku kene, ");
INSERT INTO mux_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tepi auli nomba pelemú koleana suku toku mundungí, kanuna yambuma aima mindili noku kola teku mindili noku mulungí. ");
INSERT INTO mux_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ena kanuna numanu sumbi nili yambuma eninga Lapa yi nuim kingele molupa nokulemú koleana ena talang pulimú mele enini aku-siku kanuna talang pupili mulungí. “Yambu kum-peú lelemúma-ni ung ili pilíí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","⸤Yesos-ni aku nimba kene kelepa nimba mele:⸥ “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: Ku-moni beng te laku teku punie tenga-lupa ui mo turing we pirim kanili yi te-ni penga walse kanupa liipa kene alsupa panda turum. Panda topa kene numanu sipa pupa yunga mélema pali liipa maket tepa ku-moni talse yandu liipa kene punie kanili pupa taropu topa yandu liirim. ⸤Pulu Yili yi nuim kingele molumba mele aku-sipa.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipako: Méle taropu tuli yi te-ni sisipalé-kaíma korupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kanu-kene sisipalé-kaí ku-moni aima pulele puli te kanupa kene, yu pupa yunga mélema pali taropu topa ku-moni yandu liipa kene sisipalé-kaí kanili taropu topa yandu liirim. ⸤Pulu Yili yi nuim kingele molumba mele aku-sipa.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa meleko: Oma liili wale te no-numúna toku munduring kanili-ni oma lupa-lupama liirim. ");
INSERT INTO mux_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Walale aima peka lirim kene kunduku liiku no-numú kéluna nosuku kene, mania molku apuruku kaíma liiku wale-basket marenga liiku munduring akiliinga-pe kísima toku munduku kiliring. ");
INSERT INTO mux_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ma-koleale pora nimbá enaliinga aku-sipako: Mulú-koleana angkellama oku kene, yambu teku kis-siku mulungíma kene yambu sumbi-siku molku kunjingíma kene liiku apuruku ");
INSERT INTO mux_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","yambu teku kis-siku mulungíma liiku tepi auli we nomba pelemú koleana toku suku mundungí, kanuna aima mindili noku kola teku mindili siku mulungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","⸤Ung-ekuma topa pora sipa kene Yesos-ni lumbili andúlima walsipa piliipa kene nimba mele:⸥ “Ung akuma pali ung-puluma eni pilííngiye?” nirim. Enini yundu niku mele: “Pilíímulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yunu-ni eninindu nimba mele: “Aku lem Pulu Yili-nga ung-manimanga puluma piliiku mani siku ung-bo tonjilimele yima-ni Pulu Yili yi nuim kingele molupa yambuma nokulemáliinga ungma mani sipu ung-bo tonjilimulu kene piliiku liiku molemele yima enini i-sipa mele: Lku pulu yi te-ni yunga méle kaí lupa-lupa nosilimáliinga méle konama kene méle uima kene wasie wendu liilimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesos-ni ung-eku akuma topa pora sipa kene kolea kanili mundupa kelepa yu purum. ");
INSERT INTO mux_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Mundupa kelepa pupa kene yunga pulu-kolea ⸤Nasaret⸥ taon-na omba kene Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkuna lkundu pupa yambuma ung-bo tonjupa mani sirim kene piliikuliinga enini suru niku mini-wale munduku kene niku mele: “Yi ili yunga piliipa kungnjuliele kene yunga ulu-tondulu telemúmanga tondulale kene yu tena liirimuye? ");
INSERT INTO mux_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yu lkuma takurum yilinga málale móluye? Maria yunga anum naa molemúye? Jemis mene, Josep mene, Saimon mene, Judas mene, yunga anginipili móluye? ");
INSERT INTO mux_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yunga kimulupili pali oliu kene wasie naa molemuluye? ⸤Yu aima sika yi akili molemále.⸥ Aku lem yunga piliipa kungnjuliele kene yunga ulu-tondulu telemúmanga tondulale kene yu tena liirimuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","⸤Aku-siku ungma niku⸥ yu ung nimba uluma tepa mulurum mele kanuku kis piliiku yunu-kene aima numanu kis piliiring. Kanu-kene ⸤enini yu-kene arerembi kuluringeliinga ulu-pulele piliipa kene⸥ Yesos-ni eninindu nimba mele: “Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi te koleamanga pali bi ola pulimú, yambuma-ni pali yunga ungma piliiku liilimele. Akiliinga-pe yunga pulu-koleana yu-kene wasie tapú-toku molemele yambuma mendepolu yu-ni nilimú ungele piliiku kene ‘Yu oliunga we-yi te. Yu bi mululi yi te mólu.’ niku yu-ni nilimú ungma naa piliiku, liiku su silimele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kanu-kene yu ⸤ung nimba uluma tepa yu-yunu mulurum mele ‘Sika’ niku⸥ tondulu munduku naa piliiringeliinga yu kolea kanuna ulu-tondulu pulele naa tirim, koltale mendepolu tirim. ");
INSERT INTO mux_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ena kanumanga kolea Gallalli distrik nukurum yi nuim king Erot-ni Yesos-ni tirim mele temani turing piliipa kene ");
INSERT INTO mux_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yu-kene tapú-toku molku yu liiku tapunjuring tapú-yimandu nimba mele: “Ulu ima telemú yili No-Liinjili Jon lam! Yu kolupa kene lomburupa ola molupa úmeliinga ulu-tonduluma temba tondulale yu-kene pelemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","⸤King Erot-ni aku-sipa nirim ungeliinga pulele i-sipa mele:⸥ Ui walse Erot-ni yunga angin Pillip-nga ambu-min Erodias mangupa liirim. ⸤No-Liinjili⸥ Jon-ni Erot aku-sipa tirim kanupa kene yunundu taki-taki nimba mele: “Nu-ni ⸤Pulu Yili-nga⸥ ung-mani te toku pula tokunu angenanga ambale mangukunu liirinu. Akili tekunu kis-sirinu.” nirim kene Erot-ni yu liipa ka sipa ka-lkuna panjurum. ");
INSERT INTO mux_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ka-lkuna panjipa kene ‘Yu topu konjumbu.’ nimba piliirimeliinga-pe we-yambuma-ni ‘Jon yu Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi te molemú.’ niku kanuringeliinga yu mundu-mong tenjipa kene Jon topa naa kunjurum. ");
INSERT INTO mux_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pe walse king Erot-nga miring enale wendu urum kene Erodias limin lkuna lkundu omba, yima máku toku kanuku molangi yu denis tirim. Erot-ni ambu-wenipale-ni aku tirim kene aima kanupa kaí piliipa kene ");
INSERT INTO mux_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yunundu nimba mele: “Na “Si.” niní mélale aima sika simbu.” nimba, nimba panjipa Pulu Yili-nga bi lepa mi lirim. ");
INSERT INTO mux_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erot-ni nirim mele piliipa kene ⸤ambu-wenipale-ni anum walsipa piliirim kene⸥ anumu-ni ung te nimba sirim piliipa kene yunu-ni Erot-ndu nimba mele: “No-Liinjili Jon-nga ⸤numiele kari lekunu yunga⸥ pengale dis tenga nosukunu yandu si.” nirim. ⸤Jon-ni ui taki-taki “Erot kene Erodias-seleni teku kis-siringli.” nirimaliinga arerembi kolupa kene Erodias-ni ‘Yu kulupili. Sika kulumnje na kanambu.’ nimba “Pengale meku okunu si.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Yu-ni aku-sipa mele mawa tirimeliinga piliipa kene Erot numanu buni lirimeliinga-pe yunu-ni “Aima sika simbu.” nimba, nimba panjipa Pulu Yili-nga bi lepa mi lirim mele kepe, yu numanu topele tomba kene yu-kene wasie langi noku muluring yima yu kanuku kis piliingí mele kepe, ulu akusele piliipa kene, ka-lkuna nukuring yimandu ung te nimba mundupa kene “Yunu-ni mawa tepa “Si.” nikem mele sangi akiliinga ⸤No-Liinjili⸥ Jon-nga ⸤numiele kari leku yunga⸥ pengale yandu meku wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aku nirim-na piliiku kene Jon toku konjuku, yunga pengale dis tenga nosuku, yandu meku oku ambu-wenipale siring kene yunu-ni liipa anum mulurumna memba pupa sirim. ");
INSERT INTO mux_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aku tiring piliiku kene Jon lumbili anduring yima oku yunga ónale liiku meku puku ónu teku kene Yesos mulurumna puku temani toku siring. ⸤King Erot-ni No-Liinjili Jon ui aku-sipa topa kunjurum kulurumeliinga penga Yesos-ni ulu-tonduluma tirim mele piliipa kene “Jon numi kari lirindu yili lomburupa ola molemú lem.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","⸤Yi nuim king⸥ Erot-ni No-Liinjili Jon topa kunjurum piliipa kene, Yesos yu mulurum koleale mundupa kelepa ‘Tenga yunu molumbu.’ nimba nona andolemú sip tenga suku pupa numú-⸤Gallalli⸥ nekendu pupa kolea-waka tenga yunu pumba purum. Akiliinga-pe yambu pulele yu tirim akili piliiku kene eninga koleama munduku kelku kimbu-kongun teku no-numú kéluna poku teku puku yu purumna lumbili aeleku puring. ");
INSERT INTO mux_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesos no-kéluna omba kene yambu aima pulele akuna máku toku muluring kanupa kene enini kondu kolupa eninga kuru turum-ma ‘Kaí molangi.’ nimba enini tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Penga ipinjali ena pumba tirim kene yunga lumbili anduli yima yu mulurumna oku yunundu niku mele: “Kolea ilinga yambu te naa pelemelé, enale kamu pukumeliinga ya máku toku molemele yambuma ‘Puku kolea marenga langi taropu toku lii-pangi.’ ni.” niring. ");
INSERT INTO mux_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Akiliinga-pe yunu-ni yunga lumbili anduli yimandu pundu topa nimba mele: “Nambimuna ‘yambu akuma ‘We pangi.’ niambu.’ niku nikimeleye? Eni-enini yambuma langi mare liiku sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Enini yunundu niku mele: “Ya langi mare au-sipa naa lelemú. Pllawa kaluli wallú angere te-guli kene oma kaluli tale kene langi aku-sele mendepolu lelemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yu-ni “Na moliuna yandu meku wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kanu-kene yambumandu “Erana mania molai.” nimba kene yu-ni pllawa kaluli angere te-guli kene oma tale kene liipa mulú-koleana olandu-sipa kanupa ⸤Pulu Yili-kene⸥ “Angke” nimba pllawa kalúlima ambulupa puku topa ⸤oma kene⸥ lumbili anduli yima moke tepa sipa kene “Anju yambuma sai.” nirim, enini yambuma moke teku siring. ");
INSERT INTO mux_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Enini pali langi kanuma nuring kene olu tirim. Pe lumbili anduli yima-ni langi kakena lirim-ma liiku máku toku wale-basket engkaki-rurepu toku peka siring. ");
INSERT INTO mux_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Langi nuring yima mindi paip-tausen mele. Ambu kangambula ⸤mare wasie langi nuring⸥ akuma wasie pulele. ");
INSERT INTO mux_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","⸤Yambuma langi sirim nuring⸥ kene Yesos-ni yu lumbili anduli yimandu sumbi-sipa nimba mele: “Máku toku molemele yambuma na-ni “Pangi.” niambu. Eni nona anduli sipna ola puku no-nekendu kumbi-leku pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yambumandu “Pai.” nimba kene yu-yunu Pulu Yili-kene popu topa ung nimbándu ma-pangina ola purum. Kanu-kene ena pupa kolea kala turum kene akuna yunu mulurum. ");
INSERT INTO mux_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sipele no-nekendu pumbandu no-numú ai-suku-singina koela pumba purum kene sip kumbikundu mendu-sipa popuremi topa, numéle lombeya lepa nole kolsapia topa ola omba mania pupa tirim, sipele topa ola-mundupa mania-mundupa tepa topele-mapele turum. ");
INSERT INTO mux_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kanu-kene sumbulsuli kolea muni naa lipili ⸤yunga lumbili andúlima sipna ola molku⸥ puringna Yesos nona ola kimbu kambiliipa ombá urum. ");
INSERT INTO mux_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eni yu nona ola kimbu kambiliipa urum kanuku kene, mundu-mong lakuku teku kene “Kuru te okumaa!” niku mini-wale munduring kene ");
INSERT INTO mux_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesos-ni lkisipa eninindu nimba mele: “Eni numanu tondulu pupili molai. Na mindi okur. Mundu-mong naa teai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","⸤Yunu-ni aku nirim mele piliiring kene⸥ Pita-ni pundu topa nimba mele: “Auliele, akili sika nu-nunu únu lem nu okununa na nona ola angiliipu wambu ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yu-ni “Ui.” nirim kene Pita sipna ulsu pupa puka topa nona mania pupa kene nona ola kimbu kambiliipa Yesos mulurumna pumba purum. ");
INSERT INTO mux_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Akiliinga-pe popuremi tondulu turum kene kanupa kene mundu-mong tepa yu no wangomba tepa kene, “Auliele, na tekunu lii!” nimba nangale turum. ");
INSERT INTO mux_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kanu-kene Yesos-ni ki sunu sipa mundupa Pita kundupa ola liipa kene yunundu nimba mele: “Na moliu mele kepe uluma kapula tembu mele kepe “Sika” nikunu laye-kolte mindi piliillu lem. Ui ‘Yunu-ni na tepa liimba, sika nona ola kapula pumbu.’ niku piliikunu kene alsuku numanu topele nambimuna tokunu ‘Na no wangombunje?’ niku pilíínuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sipna sukundu puringli kene popuremi topa kilirim. ");
INSERT INTO mux_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aku tirimeliinga kanuku kene sipna suku muluring yima-ni Yesos-nga bili paka tonjuku kape niku “Nu aima sika Pulu Yili-nga Málale lam.” niring. ");
INSERT INTO mux_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Kanu-kene ⸤Yesos kene yu lumbili andúlima kene⸥ numú ⸤Gallalli⸥ nekendu puku kene no-numú kélu nekendu kolea Geneseret lirimna wendu puring. ");
INSERT INTO mux_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","⸤Kolea kanuna sipna mania uring kene⸥ akuna muluring yima-ni Yesos kanuku bi siku kene akundu lirim koleamanga muluring yambuma pali niku munduring kene yambuma-ni kuru turum yambuma pali yu omba mulurumna meku oku kene, ");
INSERT INTO mux_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“‘Nunga wale-pakuli pundele kepe ambolangi.’ ni.” niku mawa tiring. Kanu-kene kuru turum yambuma-ni yunga wale-pakuliele ambuluring yambuma pali kuruma pora nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kanu-kene Perisi-yi mare kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare kene enini Jerusallem munduku kelku Yesos mulurumna oku yu walsiku piliiku niku mele: ");
INSERT INTO mux_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Oliunga anda-kolepalima-ni “Teai.” niring ung-manele nunga lumbili anduli yima-ni nambimuna liiku su silimeleye? ⸤Anda-kolepalima-ni “Teai.” niring mele mimi-sipu piliipu kene oliu-ni kíma lumaye tolemulu mele⸥ eninga kíma aku-siku lumaye naa toku langi we nolemele kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesos-ni pundu topa kene nimba mele: “Eni kepe eninga anda-kolepalima-ni “Teai.” niring mele mindi piliiku liiku tingíndu Pulu Yili-nga ung-manima nambimuna liiku su silimeleye? ");
INSERT INTO mux_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akiliinga Pulu Yili-ni nimba mele: “Aminiali lanialinga ungma piliiku liiku, liiku ai siku teai.” nimba “Yambu te-ni yunga anumundu mola lapandu ung te nimba kis-sipa ung-mura sim lem yambu kanili toku konjangi.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Akiliinga-pe eni yima-ni niku mele: “Yambu te-ni yunga anum lapaselendu nimba mele: “Na-ni else méle mare liipu tapunjupu silkama kórunga ‘Pulu Yili simbu.’ nimbu panjurundu kaniliinga else kapula naa liipu tapunjupu simbu.” nimbá kene ");
INSERT INTO mux_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","⸤aku-sipa nimbáliinga⸥ yunga lapa bi paka tonjumba ung te naa pemba.” nilimele. Aku-siku nilimele ungele-ni ‘Anda-kolepalima-ni mani siring ungma ola-kilia.’ niku ‘Pulu Yili-ni nirim ungele ulu te mólu. Mania pupili.’ nilimele. ");
INSERT INTO mux_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","“Eni ⸤ung-manima piliiku ung-bo tonjilimele yima kene Perisi-yima kene⸥ eni topele-mapele tuli yima molemele! Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni enindu nirim mele kapula nirim. ⸤Eni ekupu telemele mele yunu-ni ui nimba Pulu Yili-nga bukna turum molemú mele i-sipa:⸥ ");
INSERT INTO mux_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘⸤Pulu Yili-ni nimba mele:⸥ “Yambu kanuma eninga kerima-ni na kape niku ‘Yi auli ola-kiliele. Nu liipu ai silimulu.’ niku na bi paka tonjilimele akiliinga-pe eninga numanuma kene nanga numanale kene tiluna naa pulimú. Lupa-lupa pelemú. ");
INSERT INTO mux_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Enini ‘Nanga bili paka tunjamili.’ niku na we popu toku kape nilimele. Mana-yambuma-ni mani silimele ungma mindi mani siku kene ‘Ung-mani ima Pulu Yili-ni “Teai.” nilimú ung-manima.’ niku piliiku liiku telemele, akiliinga na sika popu tungí kene ulu te naa temba.” nirim.’ kanili.” nimba Yesos-ni nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aku nimba kene Yesos-ni máku toku muluring yambumandu “Na moliuna wai.” nimba kene eninindu nimba mele: “Na-ni ⸤aku nikereliinga ung te⸥ nimbú teker ungele kum leku ungeliinga pulele piliiku konjai. ");
INSERT INTO mux_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Yambumanga kangina ulsukundu lepa kene kerina pupa oluna sukundu pulimú méle te-ni ⸤Pulu Yili kapula popu tungí kupulanumele pipi silimú⸥ kalaru te kapula naa monjulemú. Yambumanga numanuna sukundu pepa kene wendu olemú uluma-ni mindi yambuma kalaru monjulemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aku nirim piliiku kene, yunga lumbili andúlima yu mulurumna oku kene niku mele: “Nu aku-siku nikinu mele piliiku kene Perisi-yima-ni aima piliiku kis pilííngi mele nu piliikunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Akiliinga-pe Yesos-ni pundu topa ⸤ung-eku topa Perisi-yima muluring mele nimba kene⸥ nimba mele: “Nanga mulú-koleana molemú Lapale-ni langi-bo naa panjurum-ma pali pulu ukumba. ");
INSERT INTO mux_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi ima-ni nilimele mele numanu kimbu-siku naa piliiku molangi. Enini mong kis lílima-ni ⸤mong kis lílima⸥ kupulanum liiku ora sili yima molemele. Mong kis lili yi te-ni mong kis lili yi te kupulanum te liipa ora sipa ki ambulupa memba pumba kene elsele wasie-nele kusina topa mania mundumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","⸤Kalaru molemáliinga ung-ekale aku-sipa turum piliipa kene⸥ Pita-ni yunundu nimba mele: “Ung-eku akiliinga pulele nambulkanje? Niku para si.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesos-ni eninindu nimba mele: “Ekupu kepe naa piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Yambu tenga kangina ulsu lepa kene kerina pulimú méle te oluna suku pupa mere wendu omba le-kusina kamu pulimú mele naa piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","⸤Kerina sukundu pulimú mélema-ni ulu te naa telemú kanili.⸥ Ulu-kísima ui numanale-ni piliiku kene penga kamu wendu olemáliinga numanuna pepa kene kerina wendu olemú méle kanuma-ni mindi ⸤Pulu Yili popu tomba kupulanumele pipi silimú⸥ kalaru te monjulemú. Méle kanuma i-sipa mele: Numanale-ni ulu-kísima piliilimili, yambuma toku konjulemele, ambu yi púlima mola yi ambu líílima yambu lupama kene waperanale telemele, waperanale lupa-lupama anduku telemele, wa nolemele, gólu toku yambuma kot tenjilimele, ‘Yambuma pipili kolku molku kis-sangi.’ niku ung-bulkundu ninjilimele, ulu-pulu akuma piliiku telemele. ");
INSERT INTO mux_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aku telemele ulu akuma-ni yambuma ⸤Pulu Yili-nga kumbi-kerina pungí kupulanumele pipi silimú⸥ kalaru te monjulemú. Akiliinga-pe kima ui naa lumaye toku langi we sumbi-siku nolemele ulu pulele-ni ⸤yambu tenga numanuna suku⸥ kalaru te naa monjulemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Kanu-kene Yesos mulurum kolea ⸤Geneseret⸥ mundupa kelepa ⸤Juda-yambuma muluring kolea Gallalli distrik ulsukundu⸥ kolea-auli Taya kene Saidon-sele lirim koleana suku purum. ");
INSERT INTO mux_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Akuna purum kene kolea Kenan ambu te mulurum, yu wendu omba tondulu nangale topa kene nimba mele: “Auliele, Yi Nuim King Depit-ni Kalupa Liirim Yili, nanga ambulale kuru te numanuna sukundu molupa yu tondulu ambululemáliinga nu-ni na kondu kului!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Akiliinga-pe Yesos-ni yunundu ung te pundu topa naa nirim. Kanu-kene yunga lumbili andúlima-ni oku yunundu niku mele: “Ambale-ni nu walsiliipa oliu lumbili okomale ⸤enembu tokum⸥aliinga ‘Anju pupili.’ ni.” niring. ");
INSERT INTO mux_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","⸤Ambale yu ambu-lupa, Juda-ambu te mólu, nimba kanupa kene⸥ Yesos-ni ⸤yunundu⸥ nimba mele: “Pulu Yili-ni na Isrel-yambu talapeliinga kung-sipsip takara talemele mele molemele yambuma molemelena mindi liipa mundurum kanili. Yambu talape lupama molemelena liipa naa mundurum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aku-sipa nirim-na piliipa kene ambale omba yunga kumbi-kerina koporungu langupa ma kanupa kene nimba mele: “Auliele, na liikunu tapunjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aku nirim kene Yesos-ni pundu topa ⸤ung-eku te topa kene⸥ nimba mele: “Kangambulamanga langima liipu owama simulú kene kapula naa temba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ambale-ni nimba mele: “Auliele, sika nikinu akiliinga-pe owama-ni kepe eninga pulu-yambumanga langi pundu mania pulimúma liiku nolemele kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kanu-kene Yesos-ni yunundu nimba mele: “Ambale, nu kapula tembu mele aima lakuku tondulu munduku piliillu akiliinga mawa tekenu mele aku-sipa wendu upili.” nirim kene yu-ni aku-sipa nirim mele ena akiliinga ambaliinga limin kaí lepa kapula mulurum. ");
INSERT INTO mux_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kanu-kene Yesos kolea kanili mundupa kelepa numú-Gallalli kéluna ⸤kupulanum te lirimna⸥ omba pupa ma-pangi tenga ola pupa mania mulurum. ");
INSERT INTO mux_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kanu-kene yu mulurumna yambu aima pulele uring. Kimbu kis lirim-na kupulanum mimi-siku naa anduring yambuma kene, mong kis lirim yambuma kene, kimbu-kima topele-mapele turum yambuma kene, ung kapula naa niring yambuma kene, aku-sipa kuru lupa-lupa turum yambu pulele meku oku yu mulurumna nondupa nusiring kene yu-ni enini tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ung naa niring yambuma ung niring; kimbu kima topele-mapele turum yambumanga kimbu kima alsupa sumbi-sipa angiliirim; kimbu kis lirim-na kupulanum mimi-siku naa anduring yambuma kapula anduring; mong kis lirim yambuma mongale-ni mélema kanuring; aku-sipa ulu-tonduluma wendu urum-na kanuku kene we máku toku muluring yambuma-ni aima numanu pulele liiku munduku, Pulu Yili enini Isrel-yambuma nukurum popu turing Pulu Yili kape niku bi paka tunjuring. ");
INSERT INTO mux_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Kanu-kene Yesos-ni yunga lumbili andúlimandu “Na moliuna wai.” nimba kene eninindu nimba mele: “Yambu máku toku molemele ima na kondu tekem. Ena yupuku na-kene mulúngi, pe ekupu langi nungí te naa lelemú. Enini langi naa noku we pungí kene kupulanum-na kimbu kima pang-mangi tepa, topa ne-munda ya-munda temba akiliinga ‘Eni engle topa pípili lkundu pai.’ naa nimbú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Aku nirim kene-na piliiku kene yunga lumbili anduli yima-ni niku mele: “⸤Sika nikinu akiliinga-pe⸥ kolea-waka ilinga molemulu. Yambu aima pulele ima kapula nungí mele pllawa kaluli tena lembana liipu simulúye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesos-ni eninindu “Pllawa kaluli nambi-sili nosuku molemeleye?” nimba walsurum kene enini “Pllawa kaluli angere yupuku-guli kene oma koltale kene nosupu molemulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kanu-kene yunu-ni máku toku muluring yambumandu “Mania molai.” nimba kene, ");
INSERT INTO mux_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","pllawa kaluli angere yupuku-guli kene omama kene liipa Pulu Yili-kene “Angke” nimba, langi akuma puka lepa yu lumbili anduli yima sirim kene enini yambuma moke teku siring. ");
INSERT INTO mux_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yambuma pali noku kis piliiring. Pe langi-kakena lirim-ma lumbili anduli yima-ni liiku wale-basket aulimanga laliiring, wale angere yupuku-guli peka lirim. ");
INSERT INTO mux_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Yi po-tausen-ni langi akuma nuring. Ambu kangambulama kene wasie langi nuring. ");
INSERT INTO mux_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kanu-kene Yesos-ni máku toku muluring yambumandu “Lkundu pai.” nimba kene, nona-anduli-sip tenga suku pupa, ⸤numú nekendu⸥ kolea Makatan purum. ");
INSERT INTO mux_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","⸤Kolea Makatan purum⸥ kene Yesos mulurumna Perisi-yima kene Sadusi-yima kene enini oku, ‘Yunu-ni nambi tembanje? Kanamili.’ niku yu manda leku mawa teku kene niku mele: “Ung-Bo Tunjuliele, ‘Nu sika Pulu Yili-ni ‘Kongun tenjani.’ nimba ya ma-koleana liipa mundurumnje kanamili.’ niku mulú-koleana molemú Pulu Yili-ni mindi kapula ulu-tondulu telemú mele te ti.” niring. ");
INSERT INTO mux_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesos-ni pundu topa kene nimba mele: “Ipinjali ena pumbandu muléle kunduli telemú kanuku kene “Ena kaiéle wendu ombá lem.” nilimele. ");
INSERT INTO mux_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ulsulam-ui kolea tangumbandu kolea kupa topa muléle sumbulú molemú kanuku kene “Lo ombá lem.” nilimele kanili. Muléle kanuku kene ‘koleale i-temba.’ niku kanolemeláliinga-pe ena imanga uluma wendu olemúma kanuku kene ulumanga pulele kapula naa piliilimili. ");
INSERT INTO mux_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ekupu ma-koleana molemele yambuma yambu kísima mindi molemele. Enini teku kis-siku Pulu Yili enembu kolku, méle lupama numanu monjulemele yambu kanuma-ni “Pulu Yili-ni mindi ulu-tonduluma kapula telemú mele kanamili ti.” niku na mawa telemele. Akiliinga-pe ⸤Pulu Yili-ni na liipa mundurum-na ya ombu molkur. Yu-kene tapú-topu kongun telembulu mele⸥ liipa ora simba ulu-tondulu te wendu naa ombá. ⸤Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi⸥ Jona-ni tirim ulele-ni mindi liipa ora silimú mele kapula kanungí. Te wasie wendu naa ombá.” nimba kene enini mundupa kelepa yunu purum. ");
INSERT INTO mux_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Enini ⸤Numú-Gallalli⸥ nekendu pungíndu ⸤Yesos⸥ lumbili anduli yima pllawa kaluli apera siku naa meku puring. ");
INSERT INTO mux_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kanu-kene Yesos-ni eninindu ⸤lip-lipi topa ung-eku topa kene⸥ nimba mele: “Aima mimi-siku kanai! Perisi-yima kene Sadusi-yima kene enini pllawa tepa auli mundulimú méle yis nosulimelale kanuku konjai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aku-sipa nirim kene piliiku yunga lumbili anduli yima-ni eni-enini tombulku kene niku mele: “Oliu pllawa kaluli ⸤nomulú⸥ mare naa liipu membu úmulaliinga nikem-nje.” niring. ");
INSERT INTO mux_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aku-siku niring mele piliipa kene Yesos-ni eninindu nimba mele: “Eni ‘na-ni kapula liipa tapunjumba.’ niku laye-kolte mindi piliilimili yima, “Pllawa kaluli naa mímulu.” niku nambimuna tombulku nikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ekupu kepe eni naa piliiku konjulemeleye? Ui pllawa kaluli angere te-guli yi paip-tausen moke teku siring mele apera silimeleye? ⸤Noku pora siring kene⸥ langi kakena lirim-ma liiku wale-basket pulele toku peka siring mele apera siku naa piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","“Mola ui pllawa kaluli angere yupuku-guli moke teku yi po-tausen siring mele naa piliiku, ⸤noku pora siring kene⸥ wale-basket auli mare langi kakena lirim-ma toku peka siring mele naa piliiku molemeleye? ");
INSERT INTO mux_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","‘Yunu-ni sika pllawa kalúlielendu naa nikem.’ niku nambimuna naa pilííngiye? ‘Perisi-yima kene Sadusi-yima kene pllawa tepa auli mundulimú méle yis nosulimelale mimi-siku kanangi.’ nimbu niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yunu-ni aku-sipa nirim-na piliiku kene enini ‘Pllawa kalungíndu yis mundulimele akilindu naa nikem. Perisi-yima kene Sadusi-yima kene enini ung-mani siring ungmandu nikem.’ niku piliiring. ⸤‘erisi-yima kene Sadusi-yima kene enini ung-mani mare lawa teku siringma yunga lumbili andúlima-ni aima naa piliangi!’ nimba nirim mele niku piliiring.⸥ ");
INSERT INTO mux_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesos kolea-auli Sisaria-Pillipai lirim koleana pupa kene, yunga lumbili andúlimandu walsipa kene nimba mele: “Mania Omba Mana-Yi Au Talurum Yilindu yambuma-ni yu bi leku nae nilimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Enini yundu niku mele: “Mare-ni “Nu No-Liinjili Jon ⸤kulurum, ekupu alsupa lomburupa ola molemú⸥.” nilimele; mare-ni “Nu ⸤Pulu Yili-ni ui kona mulupili olandu liirim yi⸥ Illaija alsupa omba molemú.” nilimele; mare-ni nu “Jeremaya mola Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi ⸤ui kulurum ekupu lomburupa ola molemú⸥ te-lupa.” nilimele.” niring. ");
INSERT INTO mux_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aku niring piliipaliinga Yesos-ni eninindu nimba mele: “⸤We-yambuma-ni aku-siku nilimele⸥ akiliinga-pe eni-enini na nae nilimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon-Pita-ni pundu topa nimba mele: “Nu Kona Molupa Mindi Puli Pulu Yili-nga Málale, ⸤Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ ui nimba makó turum yi-nuim⸥ Kraisele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yunu-ni aku nirim-na piliipa kene Yesos-ni yundu nimba mele: “Jona Málu Saimon, nu Pulu Yili-ni “Numanu kaí pípili molku konjani.” nilimú kupulanum-na mollu. Nikinu ili mana-yambu te-ni nu naa nimba símu. Tata mulú-koleana molemále-ni nimba símu. ");
INSERT INTO mux_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ung te kene wasie nundu nikerko: Nunga bili Pita, (bi kaniliinga ung-pulele ‘ku-mulú’ kanili). Ku-mulú kanuna ola nanga yambu-talapele liipu máku topu monjumbu. Kanu-kene kululi ulu-pulelenga tondulale-ni nanga talape ili topa mania kapula naa mundumba, mólu. ");
INSERT INTO mux_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pulu Yili yi nuim kingele molupa yambuma nokumba lku-kili nu simbu. Kanu-kene nu-ni mana-mélerindu “Mólu.” niní mélale mulú-koleana sukundu “Mólu.” nimbáko. Nu mana-mélerindu “Kapula.” niní mélale mulú-koleana sukundu “Kapula.” nimbáko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kanu-kene yunga lumbili anduli yima-ni Yesos-ndu “Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele nu oku mollu.” niring ung kanilindu yunu-ni eninindu tondulu mundupa nimba mele: “Eni anju-yambu tilurindu kepe na yi kanili moliu mele ⸤isili-ui⸥ aima naa niku sai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kanu-kene Yesos yunga lumbili andúlima-ni yunundu ⸤“Pulu Yili-ni oliu “Nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele nu.” niku, niku para siring-na piliipa kene⸥ yu-ni yunu-kene wendu ombá mele pulu monjupa enini sumbi-sipa nimba sipa kene nimba mele: “‘Na mindili pulele nombúndu kolea-auli Jerusallem aima pumbu.’ nimbu piliipu moliu. Juda-yambuma nokolemele tápu-yima kene, Pulu Yili popu tunjuli yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene, enini na aima toku mindili kunjingí. Na toku kunjingí kolumbu kene kongun tale omba pumba kene yupuku-sipaliinga Pulu Yili-ni nandu ‘Lomburuku ola mului.’ nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","⸤Aku nirim-na piliipa kene⸥ Pita-ni yu anju liipa memba pupa kene yu pulu monjupa ung-mura sipa kene nimba mele: “Auliele, aku-siku aima naa ni! Nu nikinu mele aku-sipa aima wendu naa ombá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Akiliinga-pe ⸤yu-ni kurumanga nuim Seten-ni “I-sikunu i-sikunu niku sinjui.” nimba sirim mele piliipa kene nirimeliinga piliipa kene⸥ Yesos-ni topele topa Pita-ndu nimba mele: “Seten, nu anju pa! Pulu Yili-ni nandu “Ti.” nirim kongunale tembu tekerale pipi sini tekenu akiliinga nu anju pui! Nu-ni na teku bemba sini tekenu. Nu Pulu Yili-ni numanuna piliilimú mele naa piliillu. Yambuma-ni numanuna piliilimili mele mindi piliillu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kanu-kene Yesos-ni yunga lumbili andúlimandu nimba mele: “Yambu te-ni ‘Yu lumbili pambu.’ nimba kene yunu-ni yunga numanale-ni piliilimú mélemanga ‘Topu mania mundambu.’ nimba yambuma unji-perana peku mindili noku kolemele mele yu-ni unji-pera mele koma lembandu ‘Na yu lumbili pupu kene mindili nundu lem kapulako; kulundu lem kapulako.’ nimba kene na lumbili upili. We naa upili. ");
INSERT INTO mux_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yambu te-ni ma-koleana yunga kona molupa naa kululi ulu-pulele ambulumba temba kene yu kolupa kene sika molupa kis-sipa mindi pumba. Akiliinga-pe yambu te-ni na numanu monjupa kene nanga kongunale “Tenjambu.” nimba temba kene yu kolupa kene yu kona molupa konjupa mindi puli ulu-pulele sika kanupa liimba. ");
INSERT INTO mux_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","⸤Akili nambimuna nikerye?⸥ Yambu te-ni ma-koleana mélema pali yu-yunu liipa nosulka kene yu mini pali Pulu Yili naa molumba koleana pupa mindili nomba molupa kis-silkanje méle kanuma-ni yambu kanili nambi-sipa tepa liilkanje? Manda tepa naa liilkale. Mola yambu te-ni ‘Na mini-kangi pali kona molupu konjupu mindi pambu.’ nimba kene yu nambulka méle te-ni mini-kangi pali kona molupa konjupa mindi puli ulu-pulele taropu topa liilkaye? Méle te-ni kapula taropu topa naa liimba. ");
INSERT INTO mux_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Mania Omba Mana-Yi Au Talurum Yili penga Lapanga tondulu pa tepa talang puliele kene yunga ⸤mulú-koleana⸥ angkellama kene wasie ombá. Omba kene yunu-ni oliu ya mana-yambuma lupa-lupa telemulu ulumanga oliu lupa-lupa pundu tombaliinga na-ni aku niker. ");
INSERT INTO mux_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Na-ni enindu aima sika nimbu siker: “Eni ya angiliikimilimanga mare ui kulú naa kolangi Mania Omba Mana-Yi Au Talurum Yili yi nuim kingele omba molupa mélema kene yambuma kene pali nokumbandu ombá kanungí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yesos-ni ⸤yu lumbili andúlimandu aku-sipa nimba sirim kene⸥ penga kóru te omba purum kene Pita kene Jemis kene Jemis angin Jon kene enini liipa memba pupa ma-pangi aima olandupa pulurum tenga ola purum. ‘Oliu oliuliu mindi molamili.’ nimba enini akuna liipa memba purum. ");
INSERT INTO mux_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Akuna puring kene enini kanuku molangi yunga kangiele te-lupa-mele tepa angiliirim, yunga kumbi-kerale ena tondulu topa yambumanga mongma takele telemú mele talang lakupa pupa, yu pakurum mulumbalema pa tepa talang pulimú mele aku-sipa kake tirim. ");
INSERT INTO mux_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yu aku-sipa mulupili, ⸤Juda-yambumanga kórunga-ui muluringli yi-auli tale,⸥ Moses kene Illaija-sele okulu Yesos-kene ung nikulu mokeringa angiliiringli kanuring. ");
INSERT INTO mux_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kanu-kene Pita-ni Yesos-ndu nimba mele: “Auliele, oliu yana molkumulale kapula lam. Nu-ni “Kapula.” ninu lem, lku-takaé yupuku takonjambu. Te nunga, te Moses-nga, te Illaija-nga takonjambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Yunu-ni aku-sipa nimba mulupili kupa tondulu talang puli te omba enini panda turum kene kupana suku ung te wendu omba kene nimba mele: “Yi ili nanga numanu monjuliu Málale. Yu kanupu aima kaí piliiliu. Yu-ni ung nimbáma piliiku liai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aku nirim piliiku kene yunga lumbili anduli yi ⸤yupuku⸥ aima mini-wale munduku kene mana-mania molku tamalu piring. ");
INSERT INTO mux_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Enini tamalu piringna Yesos omba enini ambulupa kene nimba mele: “Mini-wale naa munduku ola angiliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe olandu-siku kanuring kene yisele naa kanuring. Yesos yunu mulurum kanuring. ");
INSERT INTO mux_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma-pangina mania ungí uring kene Yesos-ni enini mani sipa kene nimba mele: “Eni ekupu kanúngi mele isili-ui yambu tiluri kepe niku naa sai. Penga, Mania Omba Mana-Yi Au Talurum Yili kolupa lomburupa ola molumba kene temanele toku anju sai. Ui mólu!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aku nirim-na piliiku kene yu lumbili andúlima-ni ⸤yu sika mulurum mele niku kanuku kene⸥ yunundu walsiku piliiku kene niku mele: “⸤Pulu Yili-ni ‘oliu nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele nu lem⸥ Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjilimele yima-ni “Illaija ⸤alsupa⸥ kumbi-lepa ombá. ⸤Yi-nuim Kraisele penga aelepa ombá.⸥” nilimele mele nambimuna nilimeleye? ⸤Illaija alsupa naa upili nu kórunga urunu mollu kanili.⸥” niring. ");
INSERT INTO mux_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesos-ni pundu topa nimba mele: “ “Illaija ⸤alsupa⸥ kumbi-lepa omba kene mélema pali tepa mimi temba.” nilimele kanili sika nilimele. ");
INSERT INTO mux_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Akiliinga-pe ⸤ung akiliinga te kene wasie nimbu sikerko.⸥ Piliai. Illaija kórunga urum. Yu urum kene ⸤yi kanuma-ni⸥ yu kanuku bi naa siku ‘Yu we-yi te.’ niku piliiku kene ‘Yunu-kene temulú.’ niku piliiring uluma pali tiring. Aku-siku mele Mania Omba Mana-Yi Au Talurum Yili mindili liiku singíko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aku-sipa nirimele piliiku kene lumbili andúlima-ni ‘No-Liinjili Jon-ndu nikem.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","⸤Yesos kene yunga lumbili anduli yi yupuku kene⸥ enini ⸤ma-pangina mania⸥ oku kene yambuma máku toku muluringna uring kene yi te Yesos urumna omba koporungu langupa ");
INSERT INTO mux_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","mawa tepa kene nimba mele: “Auliele, nanga kangale kondu kului. Yu kuru-kopari tolemú-na mindili lakupa nolemú. Taki-taki yu tepina pupa nomanga pulimú. ");
INSERT INTO mux_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu lumbili anduli yima mulúngina kangale membu úndu kene enini yu kapula teku kaí naa tíngi.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Aku nirim-na piliipa kene Yesos-ni ⸤yambuma ung-mura sipa kene⸥ nimba mele: “Ekupu molemele yambuma eni ⸤‘Pulu Yili-ni uluma sika kapula temba.’ niku⸥ tondulu munduku naa piliilimili. Eni numanu karaye tepa pili yambuma, na eni wale nambi-sipu mani sipu ulu mare liipu ora simbu kene mimi-siku piliingíye? ⸤Na eni-kene enembu tokum.⸥” nimba kene “Na moliuna kangale meku wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Meku uring kene Yesos-ni kuru kanili ung-mura sirim kene yu kángalenga ⸤numanuna⸥ omba wendu purum kene ena-mong kanuna kángale kapula mulurum. ");
INSERT INTO mux_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aku tirim-na kanuku kene Yesos lumbili anduli yima Yesos yunu mulurumna oku walsiku piliiku kene niku mele: “Kuru akili oliu-ni nambimuna kapula naa makurúmuluye?” niring kene ");
INSERT INTO mux_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesos-ni pundu topa nimba mele: “ ⸤‘ulu Yili-ni sika oliu liipa tapunjumba.’ niku⸥ aima laye-kolte mindi piliilimiléliinga ulu-tondulu i-silima kapula naa telemele. Na-ni eni aima sika nimbu siker: “Unji tenga mong akili méle aima wallú akiliinga-pe mong kanili mana mundulimele kene unji ola omba angiliimú mele, aku-sipa eni ‘Pulu Yili-ni oliunga ungma piliimba. Oliu liipa tapunjumba.’ niku laye-kolte mindi piliiku kene ma-pangi ilindu “Anju puku ne kolea tenga angilíí.” ningí kene sika aku-sipa pupa angiliimba. ‘Teamili.’ ningí uluma ulu kapula naa tingí ulu te naa pemba. ");
INSERT INTO mux_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Pulu Yili mawa teku langi mi toku naa noku kene kuru i-silima yambumanga numanumanga kapula makurungí. Ulu-tondulu i-silima we kapula naa tingí.)” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","⸤Pe walse,⸥ kolea Gallalli distrik puku muluring kene Yesos-ni yunga lumbili andúlimandu nimba mele: “Mania Omba Mana-Yi Au Talurum Yili ⸤ka siku kene yu toku kunjingí⸥ yima anju singí kene ");
INSERT INTO mux_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","enini yu toku kunjingí. Kolupa kene kongun yupuku-sipaliinga Pulu Yili-ni yunundu ‘Lomburuku ola mului.’ nimbá.” nirim. Aku nirim piliiku kene eninga numanuna sukundu memi kumu pirimeliinga piliiku kene aima kondu kuluring. ");
INSERT INTO mux_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Penga Yesos kene yu lumbili andúlima kene Kapeniam taon-na uring kene Pulu Yili popu turing lku-tembollaliinga ku-moni-takis liiring yima oku Pita walsiku kene niku mele: “‘Nunga ung-bo tunjuli yili-ni lku-tembollaliinga ku-takis tolemú.’ nimbu piliikumulale. Sikaye?” niring kene ");
INSERT INTO mux_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita-ni “Tolemú.” nirim. Kanu-kene Pita lkuna lkundu pupa kene ung te nimbá tirim kene Yesos-ni yu ui walsipa kene nimba mele: “Saimon, nu nambulka niku piliikunuye? Yi nuim kingima-ni ku-moni-takis lupa-lupama liingíndu namelé “Tai.” nilimeleye? “Eninga yambuma kene ku-takis tai.” nilimele mola “Yambu-lupama kene ku-takis tai.” nilimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita-ni pundu topa nimba mele: “Yambu-lupamandu ‘Ku-takis tai.’ nilimele.” nirim. Aku nirim-na piliipa kene Yesos-ni yunundu nimba mele: “Aku lem kingeliinga yambuma-ni ku-takis naa tungí. ");
INSERT INTO mux_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Akiliinga-pe ku-takis naa tombulú kene lku-temboll ku-takis liilimele yima-ni olsu kanuku kis piliingí kapula naa tembaliinga no-numúna pukunu uk mundu-pani. Uk mundukunu kene oma te tuni oma akiliinga kerina aká tinjiní kene ku-moni te pemba, ku-moni akili liikunu kene meku pukunu olsunga wasie liiku tere leku ku-takis tui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ena akiliinga Yesos lumbili anduli yima-ni yu mulurumna oku yu walsiku piliiku niku mele: “Pulu Yili yi nuim kingele molupa nokulemú yambumanga nae aima olandupa molemúye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Enini walsiring mele Yesos-ni piliipa kene yu kangambula kelú te “Na moliuna ui.” nimba enini muluringna monjupa kene ");
INSERT INTO mux_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","eninindu nimba mele: “Na-ni eni aima sika nimbu siker: “Eni numanu topele toku kangambula kelúma mele naa mulúngi lem Pulu Yili yi nuim kingele molupa yambuma nokulemú koleana suku aima kapula naa pungí.” niker. ");
INSERT INTO mux_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Akiliinga, yambu te-ni ‘Na we-yambale molumbu. Nanga bi te olandupa naa mulupili.’ nimba kangambula kelú ili mele molemú yambale yu Pulu Yili yi nuim kingele molupa nokulemú koleana yambu bi aima olandupa mululiele molemú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“⸤Kangambula ilindu ung te wasie niambu:⸥ Yambu te-ni ‘Na Auliele-nga yambale moliu.’ nimba kangambula ili mele liipa tapunjumba kene yambu kanili-ni aku tembaliinga na liipa tapunjumbako. ");
INSERT INTO mux_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Akiliinga-pe yambu te-ni ⸤kangambula⸥ kelú ili ⸤mele yambu⸥ te ⸤na ‘Sika’ nimba⸥ tondulu mundupa piliilimú ⸤kangambula⸥ kelále ‘Ulu-kísima tipili.’ nimba ung-kundi tombaliinga ⸤kangambula⸥ kelú kanili na tondulu mundupa piliilimú mele mundupa kelepa liipa bulu símu lem ⸤kangambula⸥ kelále ui ung-kundi naa tupili yambu kanili ku-mulú aima auli te moku toku numina lenjiku ‘Yu kamu kulupili.’ niku paka toku no-numúna aima mania mundulkemelanje aima kapula. ");
INSERT INTO mux_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“⸤Na⸥ ‘Sika’ niku tondulu munduku piliilimili yambuma kelku liiku bulu siku munduku kilingí uluma ya mana lelemáliinga na enini kondu tekem. Sika aku-sipa uluma wendu ombá akiliinga-pe yambu te-ni nanga yambu te ung-kundi tombaliinga yambu kanili na liipa bulu sipa anju pumu lem ung-kundi tomba yambu kanili mindili nomba aima molupa kis-simba. ");
INSERT INTO mux_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Nunga ki-seleni mola kimbu-seleni ulu-pulu-kis te tímu lem kima mola kimbu akusele kari leku wendu mundui. Nu kona mololsiliikunu mindi puni koleana ki-sele mola kimbu-sele naa angiliipili puni kene kapula. Nunga kimbu kima pali we angiliipili tepi naa kumbulupa nomba pepa mindi pumba koleana liiku toku mundungí kene kisele. ");
INSERT INTO mux_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mola nunga mongsele-ni méle te kanuku kene numanale-ni ‘Liambuka.’ niku piliikunu ulu-pulu-kis te tinu lem mong akusele ukuku wendu mundui. Nu kona mololsiliikunu mindi puni koleana mongsele naa angiliipili puni kene kapula. Mong tale we angiliipili nu tepi-koleana sukundu liiku toku mundungí kene kisele.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“⸤Kangambula⸥ kelú ima ⸤mele yambuma⸥ nga te kanuku kis piliiku ‘Yu korupale.’ niku aima naa teangi. Eninga nokolemele mulú-koleana angkellama taki-taki Tata mulú-koleana molemúna wasie molemele akiliinga ⸤aku naa teai⸥. ");
INSERT INTO mux_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Mania Omba Mana-Yi Au Talurum Yili-ni ‘Yambu kupulanum lu liiku molku kis-silimele yambuma korupu tepu liambu.’ nimba urum kanili.)” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Eni nambulka niku piliikimiliye? ‘Yi te-ni kung-sipsip paip paon monjulka kene, te takara tolkanje, yu-ni sipsip po paon ten kelepa nain we kanuma ma-pangina molangi mundupa kelepa pupa, takara tolka kung-sipsipele kanupa liimbandu korulsiliipa naa pulka.’ niku piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na-ni enindu aima sika nimbu siker: “Sipsip takara tolka kanili kanupa liipa kene sipsip kanili-kene aima lakupa numanu silka. Takara naa tolkemela kanuma we numanu silka.” niker. ");
INSERT INTO mux_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aku-sipako eninga Lapa mulú-koleana molemále-ni kangambula kelú ima ⸤mele molemele yambuma⸥ ‘kupulanum lu liiku molku kis-singí kene aima kisele.’ nimba molemúko.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“⸤Na lumbili andúlimanga⸥ angin te-ni nu tepa kis-sim lem nu pukunu tepa kis-simba yambale kene wasie else-elsele molangli ulu-pulu-kis kanili yu-ni nu temba mele nikunu si. Nu-ni niní ungele tepa kis-simba angena piliipa kene “Sika tepu kis-sindu.” nim lem angena kene else alsuku kapula-kapula mulunglí. ");
INSERT INTO mux_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Akiliinga-pe nu-ni niní ungele yu naa pilíímu lem penga nu-ni ‘Ung ili pora nipili akiliinga tembu mele yambu mare kanuku molangi alsupu niambu.’ niku kene, kanungí yambu tale mola yupuku liiku angena molumbana meku oku enini kanuku molangi angenandu ‘Tiluna molambili.’ alsuku ni. Kanu-kene nu-ni tiní kene angenale-ni temba mele yambu kanuma-ni kanuku kene yambu lupamandu kapula temani toku singí. ");
INSERT INTO mux_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kanu-kene yu-ni eninga ungele kepe naa pilíímu lem Krais-nga yambu-talapelendu puku nikunu si. Penga Krais-nga yambu-talapele kepe angenale-ni naa pilíímu lem ‘Yu oliunga angin te mólu. Yu ulsukundu molku numanu topele naa tuli yambuma mele molemú lem.’ niku kanai. ");
INSERT INTO mux_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na-ni enindu aima sika nimbu siker: “Ya ma-koleana eni ⸤uluma kene yambuma kene⸥ “Mólu.” ningí kene Pulu Yili-ni mulú-koleana sukundu “Mólu.” nimbáko; eni ma-koleana “Kapula.” ningíma Pulu Yili-ni mulú-koleana sukundu “Kapula.” nimbáko.” niker. ");
INSERT INTO mux_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“⸤Akiliinga⸥ na-ni enindu ung te wasie nimbu siker: “Eninga yambu tale-ni ya mana “I-sipu mawa teambili.” niku panjíngli lem else-ni mawa tinglí mele mulú-koleana molemú Tata-ni elsengla mawa tinglí mele aku-sipa tenjimba.” niker. ");
INSERT INTO mux_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yambu ⸤koltale,⸥ tale mola yupuku, na “eninga Auliele” niku bi leku walsiku, ‘Wasie tapú-topu molemulu.’ niku piliiku liiku máku toku molemelemanga na ⸤sika⸥ enini-kene molemulu-na ⸤mawa tingí mele Tata yu-ni aku-sipa tenjimbale⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","⸤Yesos-ni yambu ui teku kis-silimelemandu ung-mani aku-sipa sirim⸥ kene yu mulurumna Pita nondupa omba yu walsipa piliipa kene nimba mele: “Auliele, nanga angin te-ni na wale nambi-sipa tepa kis-simba kene na we ‘Mania pupili.’ nimbu kanupu konde tenjumbuye? Wale sepen yu-ni temba mele kanupu konde tenjipu we molupu kene engkaki-sipaliinga ‘Pundu tupili.’ nimbú kene kapulaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesos-ni pundu topa nimba mele: “Na-ni “Wale sepen ⸤mindi⸥ yu-ni nu tepa kis-simba kene yu-ni tembama kelku alsukunu piliiku naa mului.” ni naa niker. “Wale sepen andret sependi sepen yu-ni nu tepa kis-simba enama pali yu tipili, munduku kelkunu we mului.” niker. ");
INSERT INTO mux_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Akiliinga Pulu Yili yi nuim kingele molupa mélema nokulemú akili i-sipa mele: “Walse yi nuim king te-ni yunga kongun nukunjuring kendemande-yima kene pundu angiliirim-ma ‘Ekupu kanupu kaí tepu kene “Pundu tangi.” niambu.’ nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aku-sipa nirim kene kingele-ni ku-moni ten millien kina mele ui pundu angiliirim yi te kumbi-leku yu mulurumna meku uring. ");
INSERT INTO mux_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akiliinga-pe yu kapula ku-moni pundu akili tomba kupulanum te aima naa lirimeliinga auliele-ni nimba mele: “Kapula, yi ili kene yunga ambu kangambulama kene yunga mélema pali kene maket teku ku-moni liiku kene ku-monele oku pundu tunjai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aku nirimeliinga piliipa kene kendemande-yili-ni yi-nuimeliinga kumbi-kerina koporungu langupa tamalu pepa mawa tepa kene nimba mele: “Nu-ni na kondu kolkunu we nokuku muluyo. Na-ni pundu pali tombu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","⸤Kanu-kene⸥ yi-nuimele-ni yunga kendemande-yili aima kondu kolupa yu kendemande-yili kene pundu angiliirim-ma pali “Yu tipili. Alsukunu pundu naa tani.” nimba kamu kanupa konde tenjipa yili ka naa sipa “We pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Akiliinga-pe ⸤ka singí tiring⸥ kendemande-yi kanili yu pena pupa kendemande-yi te yunga ku wan andret kina mele sirimele kanupa kene, yu pupa yunga numina ambulupa ‘Yu kulupili.’ nimba ambulupa elkele lakurupa kene “Nanga ku-moni sirindele pundu tui!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Aku tirim kene yu-ni tomba tirim yili yunga kumbi-kerina koporungu langupa tamalu pepa mawa tepa kene nimba mele: “Nu-ni na kondu kolkunu we nokuku muluyo. Na-ni pundu pali tombu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Akiliinga-pe kendemande-yi lupale-ni “Mólu, aima isili pundu tui!” nimba kene “Nu ka-lkuna pekunu kene pundu toku pora siku wendu wani.” nimba yu ka sipa ka-lkuna panjurum. ");
INSERT INTO mux_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yu-ni aku tirim mele kendemande-yi wema-ni kanuku kene enini numanu kis panjiku puku eninga yi-nuimelendu kendemande-yisele tiringli kanuring mele kundi turing. ");
INSERT INTO mux_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kanu-kene yi-nuimele-ni aku niring mele piliipa kene kendemande-yi yunga pundu “Naa toku we pui.” nirim kendemande-yi kanili “Yandu ui.” nimba kene yunundu nimba mele: “Kendemande-yi kisele, nu-ni na tondulu munduku mawa tínu-na nu na-kene pundu aima auli-tepa angiliirimele “Yu tipili, pundu naa tui.” nimbu kene we kanupu konde tindu kanili. ");
INSERT INTO mux_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pe na-ni nu we kondu kulundu mele nu-ni aku-sikunu kendemande-yi te nambimuna kondu naa kulúnuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yi-nuimele-ni yu arerembi kolupa kene ka-lku nokuku ka-lkuna piring yambuma toku mindili kunjuring yima yu liipa sirim. Yu-ni nimba mele: “Nu mindili noku kene pundu tani. Ui pundu pali toku pora sikunu kene penga mindi wendu wani. Ui mólu.” nirim.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","⸤Yesos yu-ni aku nimba kene ung-ekaliinga pulele kamu nimba mele:⸥ “Aku-sipako, angenali-ni eni aku-siku teku kis-singí kene eni kerina mindi “Mania pupili. Mundupu kelker.” we niku, sika munduku naa kelku, we numanale-ni piliiku mulúngi lem, ⸤kendemande-yilinga yi-nuimele-ni kendemande-yili tepa kis-sirim mele⸥ mulú-koleana molemú Tata-ni kanuku konde naa tenjiku we numanale-ni piliiku mulungí yambu kanuma eninga ulu-pulu-kisma ‘Mania naa pupili.’ nimba, we kanupa konde naa tenjipa ulu-pulu-kis kanumanga “Mindili nangi.” nimba aku tembako.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesos-ni aku-sipa ungma nimba pora sipa kene, kolea Gallalli distrik mundupa kelepa kolea Judia distrik pupa no Jodan lumbiliipa nekendu purum. ");
INSERT INTO mux_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kanu-kene yambu pulele yu lumbili uring kene yunu-ni kuru turum yambuma tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Perisi-yi mare yu mulurumna oku ‘Yunu nambulka nimbánje? Nimba kis-simbanje manda lepu piliamili.’ niku yu walsiku piliiku kene niku mele: “Yi te-ni yu-yunu piliipa kene yunga ambale “Kamu pui.” nimbá kene kapula temba mola aku temba kene ung-mani te liipa su simbaye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yunu-ni anju pundu topa nimba mele: “Pulu Yili-ni ung nirim yunga bukna molemú mele kanuku kambu naa túngiye? Ui-pulu-pulu, Pulu Yili-ni mélema tepa kene, yu-ni yambu tembandu yili kene ambale kene tepa kene ");
INSERT INTO mux_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","nimba mele: “Aku-sipu tindeliinga yi te-ni ambu te liipa kene yunga anum lapasele mundupa kelepa yunga ambale kene elsele tiluna tapú-toku pekulu kangi tiluele mele ⸤molkulu elsengla numanu tiluna pupili⸥ mulunglí.” nirim kanili naa pilííngiye? ");
INSERT INTO mux_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pulu Yili-ni aku-sipa nirimeliinga yi te ambu te liilimú kene kangiele tiluele mele molembeláliinga elsele alsuku tale mele naa molembele, elsele yambu tiluele mele molembele. Yambu tiluele molembele akiliinga Pulu Yili-ni ambu yi tale ‘Tiluele molangli.’ nilimú ambu yisele yambu te-ni kelku liiku lupa-lupa naa mundangi. Aku tíngi lem kapula naa temba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aku-sipa nirim kene enini niku mele: “Aku lem Moses-ni ung-mani te sirim mele nambimuna sirimuye? Moses-ni nimba mele: “Yi te-ni yunga ambalendu ‘Kamu pupili.’ nimba makorombandu ambale “Kamu pui.” nimbá mele pepá te topa ambale sipa kene yunundu “Kamu pui.” nimba aku tipili.” nirim kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesos-ni nimba mele: “Moses-ni sika aku-sipa nirim akiliinga-pe eni kara puku Pulu Yili-ni ambu yisele kapula-kapula mulunglí mele ung-mani sirimele liiku su siku naa piliiku liiringeliinga yu-ni “Aku teangi.” nirim. Akiliinga-pe ui-pulu-pulu ⸤Pulu Yili-ni mélema koela tepa mimi tirim kene⸥, ung-mani aku-sipa te naa pirim akiliinga ");
INSERT INTO mux_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","na-ni eni i-sipu nimbu siker: “Yi te-ni yunga ui liilimú ambale makurupa “Kamu pui.” nimba kene kelepa ambu te liilimú kene yi akili-ni waperanale telemú. Yili-nga ambale-ni yi te kene waperanale tímu lem kapula topa makurumba. We mólu. (“Pui.” nimba makorolemú ambale penga yi te-ni yu liilimú kene yi kanili kepe waperanale telemúko.)” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","⸤Yu-ni aku nirim-na piliiku kene⸥ yu lumbili anduli yima-ni yunundu niku mele: “Yi te-ni ambu liilimú kene nu-ni nikinu mele aku-siku mulunglí mele ung-mani te molemú lem yi te ambu naa liilkanje kapula.” niring. ");
INSERT INTO mux_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Akiliinga-pe Yesos-ni pundu topa nimba mele: “Ung⸤-mani siker⸥ ili yambuma-ni pali kapula naa piliiku liingí. ⸤Pulu Yili-ni⸥ makó topa tonduluma simba yambuma mindi kapula ⸤ambuma yi naa puku yima ambu naa liiku⸥ tingí. ");
INSERT INTO mux_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yi mare anupili-ni melemele kene ambuma kene tiluna tapú-toku peku ulu-kísima tingí tondulu te naa pelemú. Yi mare ‘Ambuma kene tiluna naa peangi.’ niku eninga láka tonjilimele. Mare-ni eni-enini ‘Yi nuim king Pulu Yili-nga yima molupu yunga kongunuma mendepulu tenjamili.’ niku enini eni-enini mi leku ambu naa liilimele. Ung ili yambu piliiku liingí yambuma piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kanu-kene yambuma-ni eninga kangambulama ‘Yesos yunga kili-ni ambulupa Pulu Yili-kene eninga popu toku mawa tinjipili.’ niku yu mulurumna meku uring kanuku kene Yesos lumbili andúlima-ni ung-mura teku kene ⸤“Naa meku wai.”⸥ niring. ");
INSERT INTO mux_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","⸤“Mólu.” niring-na⸥ kanupa kene Yesos-ni nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú yambu-talape akili kangambula ima mele molemele akiliinga eni kangambula ima na moliuna wangi pipi siku “Mólu.” naa niai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aku nimba kene yu-ni kangambulama ⸤kondu kolupa⸥ yunga kili-ni enini tilu-tilu nimba ambulupa kene kolea kanuna mundupa kelepa purum. ");
INSERT INTO mux_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Walse yi te Yesos mulurumna omba yunundu walsipa piliipa kene nimba mele: “Ung-Bo Tunjuliele, na nambulka ulu kaiéle tembu kene kona molupa konjupa mindi puli ulu-pulele liimbuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesos-ni yunundu nimba mele: “Nu-ni na nambimuna ulu kaiélendu walsiku piliikunuye? Yambu tilu mindi kaí molemú. Nu-ni ‘kona molupu konjupu mindi puli ulu-pulele liimbu.’ nikunu pilíínu lem ⸤Pulu Yili-nga⸥ ung-mani ⸤Moses-ni yandu nimba sirim-ma⸥ teng panjiku teku mului.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yili-ni walsipa kene nimba mele: “Ung-mani akumanga témandu nikinuye?” nimba walsurum kene Yesos-ni pundu topa nimba mele: “ “Yambu toku naa konjai.” nimba, “Ambu yi púlima mola yi ambu líílima yambu lupama kene waperanale naa teai.” nimba, “Mélema wa naa liai.” nimba, “Yambumanga kot gólu toku naa tenjai.” nimba, ");
INSERT INTO mux_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Aminiali laniali kene teku konjuku, ung ningí mele piliiku liiku teku molai.” nimba, “eni-enini lupa-lupa numanu monjuku eninga kangiele eni-enini kondu kolku nokolemele mele aku-sikuko pulu lelemú yambuma numanu monjuku nokuku molai.” nimba, ung-mani akuma sirim pelemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Aku nirim-na piliipa kene yi-kanguwa kanili-ni nimba mele: “Na ung-mani kanuma pali piliipu liipu tepu moliu. Pe ekupu nambulka ulu te olandupa teambuye?” nimba walsurum. ");
INSERT INTO mux_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesos-ni yunundu pundu topa nimba mele: “Nu ‘kamu yi sumbi niliele molambu.’ nikunu pilíínu lem nu pukunu nunga méle nosulluma pali ku-moni liikunu kene, ku-moni liiníma yambu-korupama moke teku sikunu kene na lumbili ui.” nirim. “Nunga ⸤mana-⸥mélema aku tiní kene mulú-koleana nunga méle lupa-lupa kaí pulele lemba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yi-kanguwa kanili méle aima lupa-lupa kaí pulele nosurumeliinga Yesos-ni yunundu aku nirimeliinga piliipa kene yu numanu kis panjilsiliipa anju purum. ");
INSERT INTO mux_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","⸤Aku tirimeliinga kanupa kene⸥ Yesos-ni yu lumbili andúlimandu nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu yambu-kamakoma aima mindili siku sukundu pungí. ");
INSERT INTO mux_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Enindu alsupu niker: ‘Kung-kemel akili ⸤kung aima auli te akiliinga-pe⸥ kalé suruli kupulanum-na sukundu pumbandu mindili laye-kolse mele sipa kene pumba. Akiliinga-pe yambu-kamakoma Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu mindili aima lakuku mele siku pungí.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aku nirim-na piliiku kene yunga lumbili andúlima aima mini-wale munduku suru niku kene anju-yandu tombulku kene niku mele: “Aku lem mindili nolkemela kupulanum-na nae kapula wendu pupa, molupu konjumulú kupulanum-na pumbaye? Te mólunje.” niring. ");
INSERT INTO mux_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesos-ni enini nem-nemi nimba kanupa kene nimba mele: “Sika yambuma eni-enini kapula mólu akiliinga-pe Pulu Yili-ni kapula tenjimba. Pulu Yili yu-ni uluma pali kapula telemú. Ulu te yu-ni kapula naa temba te mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yu-ni aku nirim piliipa kene Pita-ni yunundu nimba mele: “⸤Pe oliu-kene nambulka ulu te wendu ombáye?⸥ Oliu oliunga mélema pali mundupu kelepu nu lumbili pulimulaliinga méle nambulka mélema liimulúye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesos-ni nimba mele: “Na-ni enindu aima sika nimbu siker: “Penga ⸤Pulu Yili-ni⸥ mélema pali ‘kona pupili.’ nimbá kene Mania Omba Mana-Yi Au Talurum Yili yunga yi nuim king polu talang tondulu púlina molupa yambuma nokumba kene, eni na lumbili andolemele yima wasie yi nuim king polu engkaki-rurepunga molku kene, Isrel-yambu talape rurepu nukungí.” niker. ");
INSERT INTO mux_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yambu na numanu monjuku nanga kongun tinjingíndu eninga lkuma, anginipili, kimulupili, anupili, lapalii, kangambulama, koleama, akuma munduku kelemele ⸤mele kelengí⸥ yambuma pali, ya ma-koleana aima méle pulele ola-kilia liiku kene, kona molku konjuku mindi puli ulu-pulele liingíko. ");
INSERT INTO mux_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Akiliinga-pe ekupu auli molemele yambumanga pulele penga ⸤Pulu Yili yi nuim kingele molupa nokumba koleana⸥ yambu-korupama mulungí; ekupu korupa pupili molemele yambuma penga yambu-aulima mulungí.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","⸤Yesos-ni yunga lumbili anduli yimandu ung te wasie nimba mele:⸥ “Niker ung akiliinga ⸤ung te niambu⸥: Pulu Yili-ni yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: “Walse punie pulu yi te-ni ‘Kongun tinjili yi mare yunga unji-waen puniena kongun tenjangi.’ nimba aima ipulam-ui pupa lii-purum. ");
INSERT INTO mux_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Kongun teangi.” nimba liirim yimandu nimba mele: “Ekupu tingí enaliinga eni ku-moni ten kina ten kina nimbu méle kalombu.” nirim kene enini “Kapula.” niring kene yu-ni enini yunga unji-waen puniena “Kongun teangi pai.” nimba enini liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Penga, ipulam-ui nain killok mele tirim kene, yunu kelepa yambuma máku turing koleana pupa yi mare akuna we angiliiring kanupa kene ");
INSERT INTO mux_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","eninindu nimba mele: “Eni kepe ⸤nanga⸥ unji-waen puniena kongun tenjangi pai. Penga na-ni eni ku-moni kapula-mele kalombu.” nirim ");
INSERT INTO mux_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","kene enini puring. Penga ai-tangili kene kepe, ipinjali ena tre-killok mele kene kepe, kelepa aku-sipa pupa yi mare wasie liirimko. ");
INSERT INTO mux_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ipinjali ena paip-killok mele kene ⸤alsupa⸥ pupa yi mare we angiliiring-na kanupa kene eninindu nimba mele: “Enaliinga pali kongun naa teku ya ilinga nambimuna we angiliimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Enini yunundu niku mele: “Yi te-ni oliu kongununa naa líímu-na we angiliimulu.” niring. Yu-ni eninindu nimba mele: “Eni kepe ⸤nanga⸥ unji-waen puniena kongun tenji-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ena pora nirim kene unji-waen punie pulu yili-ni yunga kongun nukuli yilindu nimba mele: “Kongun tekemele yima ‘sukundu wai.’ nikunu eni kongun tíngeliinga méle kalonindu aima aeleku úngi yima pulu monjuku méle kalulsiliiku puku, kumbi-leku úngi yima aima aeleku méle kalui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","⸤Aku nirim kene⸥ ipinjali ten killok mele tirim kene “Kongun tenjangi.” nimba liirim yima ⸤kumbi-leku⸥ oku ten-kina ten-kina nimba sirim liiring. ");
INSERT INTO mux_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aeleku oku kongun tinjiring yima ku-moni aku-siku liiring kanuku kene kumbi-leku oku kongun tinjiring yima oku kene ‘Oliu ku-moni olandupa mele liimulú.’ niku piliiring akiliinga-pe enini ten-kina ten-kina nimba sirim liiringko. ");
INSERT INTO mux_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Liiku kene enini punie pulu yilindu ung-mura teku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Aeleku úngi yima ena-mong tilu mindi kongun tíngi, oliu ipulam-ui ombu kongun auli-tepu tímulu, ena auli te-ni oliu aima num kanili, akiliinga-pe enini kene oliu kene ku-moni kapula-kapula teku sikenele, kapula naa tekem.” niring. ");
INSERT INTO mux_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yu-ni eninga yi te-ndu pundu topa nimba mele: “Kangale, na-ni nu tepu kis naa siker. “Ten-kina simbu.” nindu kene “Kapula.” ninu kanili. ");
INSERT INTO mux_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ku sikerale liiku mekunu pui. Nanga numanale-ni mindi piliipu kene aelepa um yili kepe nu siker mele yu aku-sipu sindu. ");
INSERT INTO mux_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nanga nosiliu mélemanga numanale-ni piliipu kene kapula naa tembuye? Mola penga úngi yima ku-moni auli-tepu síndeliinga nu numanu kis piliikunuye?” nirim.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","⸤Ung-eku akili topa pora sipa kene ung-ekaliinga pulele kamu nimba mele:⸥ “Aku-sipako, aeleku ungí yambuma ⸤Pulu Yili-ni nokulemú talapena sukundu⸥ kumbi-leku pungí; kumbi-leku ungí yambuma aeleku pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kanu-kene Yesos kolea-auli Jerusallem pumba purum kene yunga lumbili anduli yi engkaki-rurepu akuka ‘na kene enini kene oliuliu molamili.’ nimba enini liipa anju memba pupa kene eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Piliai. Oliu Jerusallem pumulú pukumulu. Akuna pumulú kene Mania Omba Mana-Yi Au Talurum Yili yi te-ni ‘Tangi.’ nimba Pulu Yili popu tunjuli yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku mani siku ung-bo tonjilimele yima kene, liipa simba. Kanu-kene enini yu kot tenjiku ‘Yu kulupili tangi.’ niku kene ");
INSERT INTO mux_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Juda-yi naa molemele yima liiku singí. Kanu-kene yi kanuma-ni yu ung-taka tonjuku, ka-pulsa-ni toku, ‘Yu kulupili.’ niku unji-perana ⸤toku⸥ ku toku panjingí. Kolupa kene sumbulu yupuku-sipaliinga Pulu Yili-ni yunundu ‘Lomburuku ola mului.’ nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Penga-mele, Seperi-málu Jemis kene Jon-selenga anum Yesos mulurumna omba koporungu langupa nimba mele: “‘Nu ulu te teani.’ nimbu mawa tembu okur.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesos-ni ambalendu nimba mele: “Nambulka ulu te ‘na-ni tenjambu.’ niku nikinuye?” nirim. Ambale-ni nimba mele: “Nu penga yi nuim kingele muluni kene nanga kang tale ⸤‘i-sele nu-kene wasie yi-nuimima molamili.’ nikunu⸥ ‘te nunga ki-bokundu monjukunu te nunga ki-tarukundu monjani.’ nimbu mawa teker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesos-ni eninindu nimba mele: “Mawa tekemele mele eni piliiku naa kongnjukumele. Na nondupa no-mingina no nombále else kapula nunglíye?” nirim kene elsele-ni “Kapula nombulú.” niringli. ");
INSERT INTO mux_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yu-ni elselendu nimba mele: “Na no-mingina no nombále penga else aima sika nunglí akiliinga-pe na-ni else “Nanga wangu-selenga oku molangli.” nimbále kapula naa temba. Tata-ni yunu akuna mulunglí-sele kórunga makó turum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Anginingli ⸤Jemis kene Jon-seleni ‘Yesos-nga wangu-selenga molambili.’⸥ niku mawa tiringli mele piliiku kene lumbili anduli yi rurepunga tale ⸤wema-ni⸥ elsele-kene numanu kis piliiring. ");
INSERT INTO mux_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanu-kene Yesos-ni enini “Wai.” nimba kene, eninindu nimba mele: “Oliu Juda-yambumanga ulsukundu molemele yambu-talapemanga yi-nuimima eninga yambuma tondulu munduku nokuku kongun tondulu púlima taki-taki silimele. Yi bi molemú yima eninga yambuma ‘Mindili nangi.’ niku nokolemele. Yambuma-ni eninga yi-nuimimanga ungma liiku su singí kupulanum te naa lelemú. Aku-siku telemele mele eni piliilimili kanili. ");
INSERT INTO mux_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Akiliinga-pe ⸤we-yambumanga yi-nuimima-ni eninga yambuma tondulu munduku nokolemele mele na lumbili anduli yima⸥ eni-enini aku-siku anju-yandu naa teangi. Eninga yi te ‘Na bi lakupa mulupili. Na yi-auliele molambu.’ nimbá yi kanili aima eninga kongun tinjili yili mulupili. ");
INSERT INTO mux_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","‘Na eninga yi-nuimele molupu eni nokambu.’ nimbá yili aima eninga kongun kendemande tinjili yili mulupili. ");
INSERT INTO mux_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aku-sipako, Mania Omba Mana-Yi Au Talurum Yili kepe ‘Yambumanga yi-auliele molupu enini nokambu. Enini nanga kongun tinjili kendemande-yambuma molangi.’ nimba naa urum. ‘Yambumanga kongun tinjili kendemande-yili molupu enini tepu liipu, ulu-pulu-kisma-ni enini ka sipa nokulemú mele naa tipili kapula molangi akiliinga na yambu puleliinga nimbu pundu tonjupu nanga kangiele sipu, eninga nimbu alko topu kolunjambu.’ nimba urum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesos kene yunga lumbili anduli yima kene enini kolea-auli Jeriko munduku kelku pungí puring kene we-yambu pulele yu lumbili puring. ");
INSERT INTO mux_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kanu-kene mong kis lirim yi tale kupulanum alsena molkulu Yesos omba purum mele piliikulu kene yunundu tondulu nangale tokulu walsikulu kene nikulu mele: “Auliele, ⸤Yi Nuim King⸥ Depit-ni Kalupa Liirim Yili, olsu kondu kului.” niringli. ");
INSERT INTO mux_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yambuma-ni elsele ung-mura teku “Ung naa nikulu táka-nikulu molale!” niring. Akiliinga-pe elsele-ni aima tondulu nangale toku walsikulu kene nikulu mele: “Auliele, Depit-ni Kalupa Liirim Yili, olsu kondu kului!” niringli. ");
INSERT INTO mux_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesos we angiliipa kene “Else wale.” nimba kene elselendu nimba mele: “Na-ni else nambulka tenjambu niku piliikimbiliye?” nirim kene ");
INSERT INTO mux_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","mong kis lirim yisele-ni nikulu mele: “Auliele, ‘olsunga mongsele ‘Alsupa mong kaí lipili.’ niani.’ nimbu piliikumbulu.” niringli. ");
INSERT INTO mux_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kanu-kene Yesos-ni elsele kondu kolupa mongselenga ambulurum kene lkisipa elsengla mongsele kaí lirim, mélema kanukulu kene, Yesos lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","⸤Yesos kene yunga lumbili anduli yima kene⸥ enini kolea-auli Jerusallem nondupa oku, ma-pangi te ‘Unji Ollip Punie Lili Ma-Pangiele’ nili akuna kolea-kelú Betepas uring. Kanu-kene Yesos-ni yunga lumbili anduli yi tale liipa mundupa, ");
INSERT INTO mux_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Elselendu nimba mele: “Ne kolea-kelú kanukumbele akuna pukulu kene kung-dongki te ka teku panjingéle kene yunga walále wasie ne sukundu mulunglí kanukulu, puku posukulu meku wangli pale. ");
INSERT INTO mux_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Pusinglí teku mulunglí kene yambu te-ni elsendu ung te nim lem else-ni i-siku niangli: “Auliele yu-ni ‘Kung-dongkele mipili.’ nimu-na ombu liikimbulu.” niangli. Aku ninglí kene yu-ni sumbi-sipa “Kapula, meku pale.” nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aku-sipa wendu urumeliinga kórunga-ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te-ni ulu te penga wendu ombá mele ui nirim mele kamu wendu urum. Akili i-sipa mele: ");
INSERT INTO mux_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Eni kolea-auli Sayon yambumandu i-siku niangi: “Kanai! Eni molemelena eninga yi nuim kingele okum. Yu yi bi naa mululi yili mele táka-nimba molemále kung-dongki bulu-mingina molupa okum. Kung-dongki tenga waláliinga bulu-mingina molupa okum.” niku, niku sai.” nirim kanili. ⸤Aku nirim mele Yesos-ni tirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kanu-kene lumbili andulisele pukulu Yesos-ni “Te-pale.” nirim mele ti-puringli. ");
INSERT INTO mux_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Elsele-ni kung-dongkele kene yunga walále kene meku okulu kene, elsengla mulumbalema posukulu, dongki-selenga bulu-mingina ola pauwa tunjuringli kene Yesos kanuna ola mulurum. ");
INSERT INTO mux_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yambu máku turingmanga pulele-ni eninga mulumbalema posuku yu ombá kupulanum-na pauwa tolsiliiku puku, mare-ni yala-gomú languku liiku yu ombá kupulanum-na pauwa tolsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kumbi-leku puring yambuma-ni kepe aeleku puring yambuma-ni kepe unji ambululiiku puku kene niku mele: “⸤Yi Nuim King⸥ Depit-ni Kalupa Liirim Yili ‘Bi ola mulupili.’ niamili. Pulu Yi Yawe-ni liipa mundurum-na yunga kongunale tenjimba okum yili molupa kunjupili. Mulú-koleana ola yunga bi ola pípili.” nilsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesos Jerusallem suku purum kene kolea-auli kanuna sukundu muluring yambuma pali numanu pulele liiku munduku kene “Ili yi naeye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Máku toku muluring yambuma-ni niku mele: “Ili Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi-Yesos, kolea Gallalli distrik Nasaret taon yi te.” niring. ");
INSERT INTO mux_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesos ⸤Jerusallem suku pupa kene,⸥ Pulu Yili popu toku kaluring lku-tembolluna ⸤“Juda-yambu naa molemele yambuma ‘Pulu Yili popu tamili.’ niku máku tolemele kolea” niring akuna⸥ suku pupa kanupa kene akuna mélema maket teku muluring yambuma kene, mélema taropu toku liiku muluring yambuma kene akuma kanupa kene enini pali topa makurupa, ku-moni lupa-lupama taropu toku anju siring yambumanga poluma kene, kera-waembonu maket tiring yambumanga mania muluring poluma kene, topa kongndupa, topa bulu-bale sipa kene, ");
INSERT INTO mux_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","eninindu nimba mele: “Pulu Yili-nga bukna ung te i-sipa mele nilimú: ‘Yambuma-ni nanga lkulindu “Pulu Yili-kene popu topu ung nilimulu lkuli.” ningí.’ kanili. Ung aku-sipa molemú akiliinga-pe eni lku ili ‘wa nolemele yambuma mo toku molemele lkuli’ mele niku piliiku kene aku-siku telemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kanu-kene Yesos lku-tembolluna mulupili yambu mong kis lili, kimbu-ki kis lirim yambu pulele yunu mulurumna uring kene yunu-ni enini tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Akiliinga-pe yunu-ni we-yambu te-ni kapula naa telka ulu-tondulu kaíma tirim mele kene, lku-tembolluna kangambulama-ni tondulu nangale toku kene niku mele: “Yi Nuim King Depit-ni Kalupa Liirim Yili ‘Bi ola mulupili.’ niamili.” niring mele kene, ulu kanusele wendu urum mele kanuku kene Pulu Yili popu tunjuring yi-aulima kene Pulu Yili-nga ungmanimanga puluma piliiku ung-bo tunjuring yi kanuma kene enini numanu kis panjiku kene ");
INSERT INTO mux_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yesos walsiku piliiku kene niku mele: “Andi kangambulama-ni ung nikimili mele nu ⸤naa⸥ piliikunuye?” niring. ⸤Akiliinga-pe⸥ Yesos-ni eninindu nimba mele: “Na piliiker. ⸤Andi kangambulama-ni tekemele mele⸥ ung te bukna molemú mele eni naa kanolemeleye? Kanili i-sipa mele molemú: ‘Kangambula-kelúma kene kangambula-pamema kene ⸤Pulu Yili⸥ nu aima kape ningí mele mani sirinu.’ ung akili bukna molemú mele eni naa kanolemeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aku-sipa nimba kene yunu yi kanuma mundupa kelepa kolea-auli ⸤Jerusallem⸥ ulsukundu pupa kolea-kelú Betani pupa akuna pirim. ");
INSERT INTO mux_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ipulam-ui ⸤Jerusallem nondupa lirim kolea Betani mundupa kelepa Yesos⸥ alsupa kolea-auli ⸤Jerusallem⸥ pumba purum kene yunu engle turum. ");
INSERT INTO mux_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kanu-kene yunu urum kupulanum kéluna unji-pik te angiliirim kanupa kene nondupa pupa kanurum kene unji-mong te topa naa pirim, gomú mindi tirim kanurum. ⸤Gomú mindi tirimu-na⸥ kanupa kene “Nu alsukunu mong te naa tani.” nirim kene unji-pik kanili walsekale kulurum. ");
INSERT INTO mux_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ulu akili wendu urum mele kanuku kene yunga lumbili anduli yima-ni aima mini-wale munduku kene niku mele: “Unji-pik ili nambi-tepa kene walsekale kulumuye?” niku walsiring. ");
INSERT INTO mux_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesos-ni pundu topa nimba mele: “Na-ni enindu aima sika nimbu siker: “Eni numanu tale tepa naa pípili ⸤Pulu Yili-ni nanga ungele sika piliimbaliinga nimbú mele ‘aima sika wendu ombá.’ niku⸥ tondulu munduku pilííngi lem na-ni unji-pik ili tindu mele kapula tingí. Unjima mindi móluko. Ne ma-pangielendu “Ungú toku numú-kusana sukundu pui.” ningí kene pumbako. ");
INSERT INTO mux_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","‘Oliu ⸤Pulu Yili-ni aima sika liipa tapunjumbaliinga ‘Teamili.’ nimulú mele sika kapula aku-sipu temulú.’ mola ‘Nimulú kene sika aku-sipa wendu ombá.’ niku⸥ tondulu munduku piliiku kene ⸤Pulu Yili-kene⸥ ung niku mawa tingí mele pali Pulu Yili-ni sika tenjimbaliinga ulu kanuma sika wendu ombá.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kanu-kene Yesos ⸤kamu Jerusallem omba⸥ lku-temboll keri-puluna omba, yambuma ung-bo tonjupa mani sipa mulurum kene yi mare, Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene enini oku yunu walsiku piliiku kene niku mele: “Nu namba nambulka nambale liikunu kene kongun ili telluye? Nae-ni kongun ili ‘Ti-pui.’ nimba nu nambale sipa liipa mundurumye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesos-ni eninindu pundu topa nimba mele: “Na-ni eni ung te walsipu piliimbuko. Pe na-ni eni walsimbu mele eni na sumbi-siku pundu toku níngi lem ‘Na kongun ili teambu.’ nimba namba sirimeliinga pulele eni nimbu simbuko. ");
INSERT INTO mux_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","⸤Na-ni i-sipu eni walsipu piliiker:⸥ Ui ⸤No-Liinjili⸥ Jon omba yambuma no liinjirim kene yunu mulú-koleana molemú yilinga kongunale tenjimbandu yambuma no liinjirim mola ya mana-yambumanga kongunale tenjimbandu yambuma no liinjirimuye? ⸤Nae-ni “Ti.” nirim-na tirimuye? Niku sai.⸥” nirim. ⸤Yu-ni aku-sipa walsurum mele piliiku kene⸥ eni-enini tombulku niku kene niku mele: “Yu-ni walsikem mele oliu-ni pundu topu, “⸤Jon⸥ yunga mulú-koleana ⸤molemú yilinga kongunale tenjimbandu yambuma no liinjirim⸥.” nímulu lem yu-ni oliundu nimba mele: “Aku lem eni Jon-ni nirim ungele nambimuna ‘Ung ili sika.’ niku naa piliiku liiringiye?” nimbá. ");
INSERT INTO mux_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mola oliu-ni nimbu mele: “Yu mana-yambumanga ⸤kongun tenjimbandu yambuma no liinjirim⸥.” nímulu lem we-yambuma-ni ‘oliu tungínje’ nimbu mundu-mong tenjikimulu. We-yambuma-ni ‘⸤No-Liinjili Jon⸥ yunga aima sika Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te mulurum.’ niku piliilimili akiliinga oliu nambi-temulúnje?” niku eni-enini aku-siku tombulku niring. ");
INSERT INTO mux_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","⸤Eni-enini aku-siku anju-yandu tombulku niku kene⸥, Yesos-ndu pundu toku niku mele: “⸤Nu-ni walsikenu mele⸥ oliu naa piliikumulu.” niring. Aku-siku niring kene piliipaliinga Yesos-ni eninindu nimba mele: “Kapula. ⸤Na-ni eni walsiker ungeliinga ung te pundu toku naa nikimilieliinga⸥ eni na walsikimili ungeliinga ung te pundu topu nandu kongunili ‘Ti-pui.’ nimba na liipa mundupa namba sirim yilinga bili eni naa nimbu simbuko.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","⸤Yesos-ni alsupa Juda-yambu kanumanga yi-aulimandu nimba mele:⸥ “Eni nambulka niku piliikimiliye? Yi te yunga kang tale muluringli. Yu pupa kang-komalendu nimba mele: “Kangale, ekupu nu unji-waen puniena pukunu kongun ti-pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Yu-ni pundu topa lapandu “Mólu, na naa pumbu.” nirim, akiliinga-pe penga yunga numanu topele topa kene purum. ");
INSERT INTO mux_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Lapa pupa kang-komalendu nirim mele aku-sipa kang-akelealendu nirim ⸤kene⸥ yunu-ni pundu topa “Te-pumbu.” nirim, akiliinga-pe naa purum. ");
INSERT INTO mux_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Kang kanuselenga nae-ni lapanga ungele piliipa liipa tirimuye?” nirim. Enini pundu toku “Kang-komale.” niring. Yesos-ni eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Eni ⸤Juda-yambumanga yi-aulima⸥ Pulu Yili yi nuim kingele molupa nokulemú talapena sukundu ⸤kumbi-leku naa pungí⸥. Ku-moni-takis liili yima kene wapera tuli ambuma kene ⸤yambu kanuma, eni Juda-yambumanga yi-aulima-ni kanuku kis piliilimilima⸥ kumbi-leku pungí.” niker. ");
INSERT INTO mux_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","⸤No-Liinjili⸥ Jon omba eni sumbi-siku mulungí kupulanumele liipa ora sirim kene enini yu nirimele ‘Gólu tokum.’ niku piliiku yunga ungele piliiku naa liiringeliinga-pe ku-moni-takis liili yima kene wapera tuli ambuma kene yunu-ni nirim ungele ‘Sika’ niku tondulu munduku piliiring. Akiliinga-pe ambu yi kis kanuma-ni aku tiring kene kepe kanuku kene ‘Numanu topele topu ‘Yunu-ni sika nikem.’ nimbu tondulu mundupu piliamili.’ naa niringko. Akiliinga, ⸤ambu yi “Tepu kis-silimulu.” niku numanu topele tolemele kanuma Pulu Yili molemúna kumbi-leku pungí⸥.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","⸤Aku nimba kene Yesos-ni yi-auli kanumandu alsupa nimba mele:⸥ “Ung-eku te wasie tambu piliai: “Kolea pulu yi te-ni unji-waen punie tepa kene pala tirim. Puniena sukundu luikolu ukupa no-waen kingí tepa monjumbandu tepa mimi tepa kene pe punie nukungí lku-takae te polu kulupa ola takurum. Yi mare kanupa liipa kene eninindu nimba mele: “Nanga puniele tápu tenjiku unji-monguma lkeku nokunjangi. Penga unji-waen-mong polu tomba kene unji-monguma moke tepu, kongun tinjingí méle mare eni liangi mare na liambu.” nimba punie kanili enini sipa kene yu kolea ⸤sulu⸥ tenga pupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kanu-kene penga unji-waen-mongma polu tomba tirim kene punie pulu yili-ni yunga kendemande-yi mare “Nanga unji-waen-mongma sangi puku liiku menjiku wangi pai.” nimba punie nukuring yima muluringna liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akiliinga-pe kendemande-yima ⸤uring kene⸥ punie nukuli yima-ni enini ambolku liiku kene te kimbulú-ni toku, te toku konjuku, te ku-mulú-ni turing. ");
INSERT INTO mux_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Alsupa punie pulu yili-ni kendemande-yi mare pulele mele liipa “Nanga unji-waen-mongma liinji-pai.” nimba liipa mundurum, ui kendemande-yi koltale mele liipa mundurum. Akiliinga-pe punie nukuli yima-ni ui-pulu-pulu uring kendemande-yima-kene tiring mele penga kendemande-yi uringma-kene akuko tiring. ");
INSERT INTO mux_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kanu-kene punie pulu yili yunu-ni ⸤numanale-ni piliipa kene⸥ ‘Nanga kangale ai siku mundu-mong tenjiku yunga ungma piliiku liiku, yunu unji-waen-monguma singí.’ nimba piliipa kene yunga málale liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Akiliinga-pe punie nukuli yima-ni punie pulu yilinga málale ombá urum kanuku kene eni-enini niku mele: “Andi okum yili penga lapanga moya-méle simbama liimba yili okum. Yunu topu konjupu punie ili oliu kamu liamili.” niku kene ");
INSERT INTO mux_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","enini yunu ambolku liiku puniena makuruku ulsu munduku kene yunu toku kunjuring.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","⸤Yesos-ni ung-eku akili topa pora simbandu Juda-yambumanga yi-auli kanumandu walsipa kene nimba mele:⸥ “Punie nukuli yima-ni aku tiringeliinga punie pulu yili omba kene punie nukuli yi kanuma-kene yunu-ni nambulka ulu te temba niku piliikimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Enini yundu pundu toku niku mele: “Yunu-ni yi-kis kanuma ‘kamu molku kis-sangi.’ nimba tepa kis-sipa kene punie nukungí yi lupa mare liipa unji-waen-mongma polu tomba kene unji-waen-monguma moke teku, mare punie pulu yili singí yima puniele simba.” niring. ");
INSERT INTO mux_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesos-ni ⸤Pulu Yili-nga Juda-yambuma nukuring yima-ni yunu toku kunjingí mele piliipaliinga⸥ eninindu nimba mele: “Pulu Yili-nga bukna sukundu molemú ung te kanuku naa piliilimiliye? ⸤Ung akili i-sipa mele:⸥ “Lku takuring yima-ni kanuku kis piliiku toku munduku kiliring ku-mulú kanili ekupu kelepa lku-paka-sum mele lku tepa tondulu munduli ku-mulú auli kaiéle. Auliele-ni ulu akili tirim oliu-ni kanupu aima kaí piliilimulu.” nimba molemú kanili. ");
INSERT INTO mux_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Aku ⸤nirim⸥ eliinga na-ni eni ⸤Pulu Yili-nga Juda-yambuma⸥ nimbu siker: “Pulu Yili eninga yi nuim kingele molupa eni nokulemú mele mundupa kelepa kene, yambu talape lupa te-ni yunga ungele piliiku liiku teku mulungíma liipa nokumba.” niker. ");
INSERT INTO mux_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Ku-mulú ⸤niker⸥ ilinga ola yambu te singa topa tomba kene ombele-mélema elki tomba. Akiliinga-pe yambu te molumbana ola ku-mulále omba yu topa kene yambu kanili topa nurupalu tomba.)” nirim. ");
INSERT INTO mux_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kanu-kene Pulu Yili popu tunjuring yi-aulima kene Perisi-yima kene Yesos-ni ung-eku turum-ma piliiku kene enini yunu toku kunjingí teku muluring mele yunu-ni nirim piliiku kene ");
INSERT INTO mux_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","enini yunu ka singí tiringeliinga-pe yambuma-ni ‘Yu Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yandu nimba silimú yi te.’ niku piliiringeliinga yambuma mundu-mong tenjikuliinga yunu isili-ui ambolku ka naa siring. ");
INSERT INTO mux_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesos-ni kelepa ung mare ⸤Juda yi-aulimandu nimbándu⸥ ung-eku te wasie topa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: “Yi nuim king te-ni yunga málale ambu liimbaliinga langi pulele kalunjurum. ");
INSERT INTO mux_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kórunga “Yi ambu liimba langi wasie namili sukundu wangi.” nirim yambuma yunga kendemande-yimandu “ “Ekupu langi namili wai.” ni-pai.” nimba liipa mundurum, akiliinga-pe puku aku-siku niring kene enini “Naa omulú.” niring. ");
INSERT INTO mux_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Alsupa kendemande-yi mare lupa liipa mundupa kene nimba mele: “ “Langi wasie namili wangi.” nirindu yambumandu puku niku mele: “Langi tepa mimi tepa pora símu. Yunga kung-kao pelama kene kung-kao walú wami tílima kene tum. Langi pali tepa mimi tepa nosilimáliinga yi ambu liimbaliinga langi wasie namili wai.” ni-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Akiliinga-pe puku niring kene naa piliiku munduku kelku, te yunga puniena purum, te yunga méle taropu túlina purum, ");
INSERT INTO mux_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","mare-ni kingeliinga kendemande-yima ambolku liiku teku kis-siku kene toku kunjuring. ");
INSERT INTO mux_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","⸤Aku tiringeliinga⸥ kingele arerembi kolupa kene yunga ami-yimandu nimba mele: “Yima molemelena puku toku konjuku eninga koleale tepi leku to-pai.” nimba enini liipa mundurum kene puku kene, nirim mele tiring. ");
INSERT INTO mux_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kanu-kene kingele-ni yunga kendemande-yimandu nimba mele: “Yi ambu liimbaliinga langi nosuliumulu akiliinga-pe “Wasie namili wangi.” nirindu yambuma nungí kapula naa temba akiliinga ");
INSERT INTO mux_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","eni puku kene kupulanum lupa-lupa lelemúmanga pali puku yambu kanungíma “Yi ambu liimbaliinga langi wasie namili wai.” ni-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Piliiku kene kendemande-yi kanuma kupulanumumanga pali puku yambu kanuringma pali liiku máku turing. Yambu kaíma kene yambu kísima kene wasie liiku máku turing. Kanu-kene yi ambu liimbaliinga koleana yambuma aima oku si siku muluring. ");
INSERT INTO mux_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Oku muluring kene kingele “Yambu máku toku molemelema kanu-pambu.” nimba enini muluringna omba kene, yambuma yi ambu liimba ⸤mákuna ungéliinga wale-pakuli kam-kamuma ‘pakuku sukundu wangi.’ niku siring⸥ wale-pakulimanga yi te wale-pakuli akumanga te naa pakupa mulurum kanupa kene ");
INSERT INTO mux_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","yunundu nimba mele: “Kangale, nu yi ambu liimba wale-pakuli kamu te naa pakukunu we únu kanokur akiliinga nu kupulanum téliinga sukundu únuye?” nirim kene yi kanili-ni ung te naa nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kanu-kene kingele-ni langi nukuring kendemande-yimandu nimba mele: “Yi ili kimbu-kima ka toku kene pena kolea súmbulu mulúlina toku pena mundai!” nirim. Akuna yambuma aima mindili noku kene kola teku mindili siku mulungí.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","⸤Aku nimba kene Yesos-ni ung-ekaliinga pulele kamu nimba mele:⸥ “Sika ⸤Pulu Yili-ni⸥ yambu pulelendu “Wai.” nilimú akiliinga-pe yambu koltale mindi makó topa “Sukundu wai.” nilimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","⸤Yesos-ni aku-sipa nirim⸥-na ⸤piliiku kene⸥ Perisi-yima ulsu puku eni-enini liiku máku toku kene niku mele: “‘Yesos-ni ung te nimba kis-sipili. Nimba kis-simba kene yunu tepu kis-samili.’ nimbu nambi teamiliye?” niku tombulku niku kene, ");
INSERT INTO mux_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","enini lumbili andúlima kene yi nuim king Erot-nga talapena-yi mare kene liiku Yesos mulurumna liiku munduring, enini puku Yesos-ndu niku mele: “Ung-Bo Tunjuliele, oliu piliilimulu, ‘Nu-ni ung-sikama mindi niku, Pulu Yili-ni “Teai.” nilimú uluma aima sika-ungma mani siku ung-bo tonjukunu, nu yambu tiluringa kepe numanu kimbu naa sikunu, yambuma-kene mundu-mong naa tenjiku eninindu pali ung tilu-siku kapula-kapula nikunu sillu.’ nimbu piliilimulu. ");
INSERT INTO mux_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Aku-siku nikunu molláliinga nu nambulka niku piliikunuye? Oliu-ni Rom-Gapman-Yi Aima Auli Kumbina Sisale ku-moni-takis túmulu lem kapula mola móluye? Pulu Yili-ni akilindu ung-mani sirim ung-manele nambulkale nimba pelemúye? Nikunu si.” niring. ");
INSERT INTO mux_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Akiliinga-pe Yesos-ni yu-kene numanu kis panjiku yu teku kis-singí tiring piliipa kene eninindu nimba mele: “Eni gólu toku topele-mapele tuli yima, ‘Yu-ni nimba kis-sipili.’ niku nambimuna na manda leku gólu toku walsikimiliye? ");
INSERT INTO mux_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ku-moni-takis tolemele ku-mong te na liiku ora sai.” nirim. Enini yu mulurumna ku-mong te meku oku yu siring. ");
INSERT INTO mux_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kanu-kene Yesos-ni eninindu nimba mele: “Ku-moni ilinga naenga kumbi-kerale kene bili kene molemúye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Enini yunundu niku mele: “Rom-Gapman-Yi Aima Auli Kumbina Sisale-nga kumbi-kerale kene bili kene molemú.” niring. Kanu-kene yu-ni eninindu nimba mele: “⸤Ku-monele Sisale-nga⸥ akiliinga Sisale-nga mélema Sisale yunu siku, Pulu Yili-nga mélema Pulu Yili yunu sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yu-ni aku-sipa ⸤aima sumbi-sipa⸥ nirim mele piliiku kene ⸤‘Yu aima piliipa kungnjuli pelemú yili lam.’ niku piliiku⸥ numanu pulele liiku munduku kene yu munduku kelku enini puring. ");
INSERT INTO mux_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","⸤Yi kanuma Yesos kene ku-moni-takis tuli ungele niku pora siring kene⸥ penga ena akiliinga Sadusi-yi mare Yesos mulurumna uring. Sadusi-yima enini ‘Pulu Yili-ni kolemele yambuma topa naa makinjimba, lomburuku ola naa mulungí.’ niku piliiku muluring talapele. Sadusi-yi akuma oku Yesos walsiku piliiku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ung-Bo Tunjuliele, ⸤Pulu Yili-nga ung-manima oliu sirim yi⸥ Moses-ni ung-mani sipa kene nimba mele: “Ambu liimba yi te kangambula naa memba kolumba kene yi kanili yunga angin molumbále-ni yunga ambu-wayele liipa angin liipa tapunjupa kangambula minjipili.” nirim aku-sipa bukna molemú kanili. ");
INSERT INTO mux_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","⸤Ung-mani kaniliinga ulu te oliunga yi mare-kene wendu urum mele nu walsipu piliamili.⸥ “Anginipili angere yupuku-guli muluring. Yi-komale ambu liipa kene kulurum. Kangambula te naa mulupili yunu kulurumeliinga yunga bulkundu anginele-ni ⸤yunga angin kulurumeliinga⸥ kangambula ‘menjambu.’ nimba ambu-wayele kelepa yunu liirim. ");
INSERT INTO mux_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Akiliinga-pe kangambula te naa-ko menjipa kene yunu we kulurumko. Yunga bulkundele-ni ambu kanili liirimko akiliinga-pe yunu kepe we kulurumko. Aku telsiliiku puku kene yi angere yupuku-guli pali kangambula tilu kepe naa meku kene kolku pora siring kene akeleale kamu we kulurumko. ");
INSERT INTO mux_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Penga ambale yunu kulurumko. ");
INSERT INTO mux_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akiliinga, kolemele yambuma penga lomburuku ola mulungí kene ambu kanili yi angere yupuku-guli pali ya mana liiringeliinga ambale yu yi naenga min molumbaye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesos-ni eninindu pundu topa nimba mele: “Eni Pulu Yili-nga bukna ung molemúma kene, Pulu Yili-kene tondulu pelemú mele kene, naa piliiku lu liilimeláliinga ⸤yambuma penga tengélendu nikimili mele piliiku sunduku gólu tokomele⸥ . ");
INSERT INTO mux_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lomburuku ola mulungí yambumanga yima ambu naa liiku, ambuma yi naa puku, aku aima naa tingí. Mulú-koleana angkellama molemele mele aku-siku mulungí. ⸤Angkellama-ni mana-yambuma telemele mele naa telemele kanili.⸥ Aku tingéliinga ⸤‘Eni Pulu Yili-nga ungele piliiku sunduku lawa telemele.’ niker.⸥ ");
INSERT INTO mux_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","“Akiliinga-pe ⸤eni Sadusima-ni⸥ ‘Kolemele yambuma lomburuku ola naa mulungí.’ niku piliilimeláliinga ung te Pulu Yili-ni enindu nirimele eni naa kanuku piliilimiliye? Yunu-ni i-sipa mele nimba mele: “Na Eprayam kene Aisak kene Jekop kene eninga Pulu Yili moliu.” nirim. Pulu Yili-nga bukna ung molemú akili naa kanuku piliilimiliye? ⸤‘Eninga Pulu Yili mulurundu.’ naa nirim. ‘Eninga Pulu Yili moliu.’ nirim kanili.⸥ Pulu Yili yu kululi yambumanga Pulu Yili mólu; yu kona mululi yambumanga Pulu Yili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yesos yu-ni aku nirim mele yambu máku toku muluringma-ni piliiku kene yunga ung-mani sipa ung-bo tunjurum ungma piliiku kene pung-pungu niku aima numanu pulele liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Akiliinga-pe Yesos-ni ung nirim akili-ni Sadusi-yimanga ungele pipi sinjirim, enini ung te naa pirim-na Perisi-yima-ni piliiku kene enini liiku máku toku ⸤Yesos mulurumna⸥ uring. ");
INSERT INTO mux_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","⸤Uring kene⸥ eninga yi te, yu Pulu Yili-nga ung-manimanga puluma piliipa kunjurum yili-ni ‘Yunu-ni nimba kis-simbanje manda lepu piliambu.’ nimba Yesos-ndu walsipa piliipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ung-Bo Tunjuliele, Pulu Yili-ni ung-mani sirim pelemúmanga nambulka ung-manele olandupaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesos-ni yunundu nimba mele: “Ung-mani olandupale i-sipa mele: ‘Eninga numanuma kene, eninga minima kene, eninga piliipa kungnjúlima kene, akuma-ni Auliele eninga Pulu Yili mendepulu tondulu munduku numanu monjai.’ aku nimba pelemú. ");
INSERT INTO mux_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ung-mani akili yunu aima tondulu, olandupale. ");
INSERT INTO mux_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tale-sipa ung-manele yu-kene tilu-sipa mele. Akili i-sipa: ‘Eni-enini lupa-lupa numanu monjuku eninga kangiele eni-enini kondu kolku nokolemele mele aku-sikuko pulu lelemú yambuma numanu monjuku nokuku molai.’ nimba pelemú. ");
INSERT INTO mux_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pulu Yili-nga ung-mani Moses-ni sirim-ma pali kene, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni bukna turing ungma pali kene, ung kanumanga pulele ung-mani akusele mindi.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Kanu-kene Perisi-yima aku-siku we máku toku molangi Yesos-ni eninindu i-sipa walsipa nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim Kraisele-ndu eni nambulka niku piliikimiliye? Yu nae? Yu nae-ni kalupa liimba niku piliilimiliye?” nirim kene enini niku mele: “⸤Yi-nuim Kraisele yu yi nuim king⸥ Depit-ni kalupa liimba yi te.” niring. ");
INSERT INTO mux_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yu-ni alsupa enini walsipa nimba mele: “Aku lem ⸤Pulu Yili-nga⸥ Minéle Depit-nga numanuna molupa kene ung te nirim kene Depit-ni piliipaliinga yi-nuim Kraisele-ndu “Auliele” nirim akili nambimuna nirim niku piliikimiliye? Depit yu-ni ⸤yi-nuim Kraisele molumba mele⸥ i-sipa nirim: ");
INSERT INTO mux_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Auli ⸤Pulu Yi Yawe-ni⸥ nanga Auliele-ndu nimba mele: “‘Nunga ele-túma nu-ni nokani.’ nimbu, penga enini topu mania mundunjumbu akiliinga isili-ui nu ⸤na-kene wasie tapú topulu yi-nuimsele molupulu mélema nokambili⸥ nanga ki-bokundu oku mului.” nirim.” nimba Depit-ni nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Depit-ni ⸤yi-nuim Kraisele⸥ yunundu “Nu nanga Auliele.” nirim lem yu penga nambi-sipa Depit-ni kalupa liimba yi te ⸤mindi⸥ molumbaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","⸤Yesos-ni aku-sipa walsurum mele piliiku kene⸥ yi akuna muluringmanga te-ni ung tilu kepe pundu toku kapula naa niring. ⸤Enini yu walsiku piliiring ungma pali yunu-ni pundu topa anju nimba kunjurum piliiku kene⸥ pe alsuku yu ung te walsiku piliingíndu pipili kolku mundu-mong tenjikuliinga naa walsiring. ");
INSERT INTO mux_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Kanu-kene Yesos-ni yambu máku turingima kene, yu lumbili anduli yima kene, ung nimba sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjilimele yima kene, Perisi-yima kene, enini Moses-ni ung-manimanga puluma ung-bo tonjupa mani sirim mele yandupa ung-bo tonjuku mani silimele. ");
INSERT INTO mux_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Akiliinga, yi kanuma-ni eni ung-bo tonjuku mani silimelema pali mimi-siku piliiku teangi, akiliinga-pe yi kanuma-ni mani silimele mele yi kanuma eni-enini piliiku liiku naa telemeláliinga yi kanuma enini ulu telemelema manda leku naa teai. ");
INSERT INTO mux_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yambu te-ni wale buni tili te tepa mimi tepa kene yambu te ‘mipili.’ nimba ola liipa bulu-mingina menjilimú mele ⸤aku-siku yi kanuma-ni yambumandu ung-mani siku “I-siku i-siku teai.” niku⸥ buni silimele akiliinga-pe laye-kolte kepe ‘Liipu tapunjupu meamili.’ naa nilimele. ");
INSERT INTO mux_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Yi kanuma-ni ulu telemelema ‘we teamili.’ niku naa telemele. ‘Yambuma-ni oliu kanuku kene ‘molku konjulemele.’ niku kanangi.’ niku uluma telemele. Pulu Yili-nga ung-manima molemú pepá te kumu toku mai-ombelena mola kína ka tungíndu ‘Yambuma aima kanangi.’ niku kumu aima lakuku toku, eninga wale-pakulimanga ka moku toku munjingíndu ka sulu kaí mare auli-teku moku toku monjulemele. ");
INSERT INTO mux_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yambuma-ni langi noku yambumandu “Wasie namili wai.” nilimele kene yi kanuma oku kene yi-aulimanga polu kumbina ‘oliu molamili.’ niku numanu siku molemeleko. Yambuma máku toku Pulu Yili-nga ungele piliilimili lkuna lkundu puku kene mania mulungíndu yi-aulima molemele polu kaí akuna ‘molamili.’ niku kumbina puku polu akuna numanu siku molemeleko. ");
INSERT INTO mux_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yambuma máku toku molemele koleana andungíndu mong-keng leku ‘We-yambuma-ni oliu kanuku kape niangi.’ niku piliiku kene numanu siku piliiku anduku molemeleko. Yambuma-ni eninindu ‘Rapai’ nilimele kene aima numanu silimeleko. ");
INSERT INTO mux_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“⸤Yi kanuma-ni aku telemele⸥ akiliinga-pe eninga nukuli yi auli tiluele mindi molemú, eni pali anginipili molemeláliinga yambuma-ni “eni oliunga Rapaima.” naa niangi. ");
INSERT INTO mux_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Eninga Lapa tiluele mindi molemú, akili mulú-koleana molemú, akiliinga mana-yambu te-ndu ⸤‘oliunga yi-auliele’ niku⸥ “Tata” naa niai. ");
INSERT INTO mux_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pulu Yili-ni “Eni nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele mindi eninga nukuli yi-auliele molemáliinga yambuma-ni enindu ⸤‘oliu nokulemú yili’⸥ niku “Yi-Auliele” naa-ko niangi. ");
INSERT INTO mux_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","12","Yambu te-ni yunga bili yunu paka tomba kene ⸤Pulu Yili-ni⸥ yunga bili topa mania mundumba; yambu te-ni yunga bili yunu liipa mania mundumba kene ⸤Pulu Yili-ni⸥ yunga bili paka tonjumba akiliinga eninga yi te eni nokumba yi-auli te molupa eninga kongun-kendemande-yili mulupili.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","⸤Yu lumbili andúlimandu ung nimba kelepa kene Yesos-ni Juda-yambumanga yi-auli muluringmandu nimba mele⸥: “Eni Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene, Perisi-yima kene, eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! Eni yambuma Pulu Yili yi nuim kingele molupa nokulemú mulú-koleana pungí pulimelé keri-puléle pipi silimele. Eni-enini lkundu naa pulimelé; yambu lupama pungí telemele kene kupulanumele pipi siku “Mólu.” nilimeleko. ");
INSERT INTO mux_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“(Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene Perisi-yima kene eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! Eni ambu-wayema liiku lu siku eninga lkuma wa liiku, eni ‘Yambuma kanangi.’ niku Pulu Yili-kene popu tungíndu ungma sulu teku we niku angiliimili, akiliinga kot enale wendu ombá kene eni-kene buni auli-tepa pemba.) ");
INSERT INTO mux_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene Perisi-yima kene eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! ‘Yambu tilu mindi kepe numanu topele topa oliu lumbili andumba kene kapula.’ niku ma-koleamanga kimbu kambiliiku kolea sulumanga puku, numú-kusa sipimanga andolemele akiliinga-pe penga yambu te sika eni nilimele ungma piliipa liipa numanu topele topa lumbili andolemú kene yambu kanili tepa kis-silimú mele aima ola-kilia, eni teku kis-silimele mele mania-kilia, akiliinga yu tepi-koleana aima sika pumba kupulanumele akisinjilimele. ");
INSERT INTO mux_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Eni mong kis lílima-ni “⸤Mong kis lili⸥ yambuma kupulanumele liipu ora samili.” nilimele yima eni mindili noku aima molku kis-singí! Eni yambuma mani siku kene niku mele: “Yambu te-ni mi lembandu ‘lku-tembollale’ bi lepa “Aima sika tembu.” nimba kene pe “Tembu.” nimba panjimba mele naa temba kene ulu te mólu. Akiliinga-pe yambu te-ni mi lembandu “lku-tembolluna kopungu kanjuring ku-gollale” bi lepa “Aima sika tembu.” nimba kene pe “Tembu.” nimba panjimba mele naa temba kene kapula naa temba. Yu sika kamu tipili.” nilimele. ");
INSERT INTO mux_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Eni sundupa sili-pili mong kis lili yima! Méle nambulka mélale olandupaye? Ku-gollu akili méle olandupale mola Pulu Yili molemú lku-tambollale-ni ku-gollu makó topa ‘Pulu Yili-nga’ nimba kake tenjilimú lkuli olandupaye? ");
INSERT INTO mux_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Eni ung te wasie yambuma mani siku kene niku mele: “Yambu te-ni mi lembandu ‘Pulu Yili popu toku mélema kalemele polale’ bi lepa “Aima sika tembu.” nimba kene penga “Tembu.” nimba panjimba mele naa temba kene ulu te mólu. Akiliinga-pe yambu te-ni mi lembandu “polu akuna ola méle te singéle” bi lepa “Aima sika tembu.” nimba kene penga “Tembu.” nimba panjimba mele naa temba kene kapula naa temba. Yu sika kamu tipili.” nilimele. ");
INSERT INTO mux_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eni mong kis lili yima! Méle nambulka mélale olandupaye? Poluna ola ‘Pulu Yili popu toku kalonjangi.’ niku silimele mélale olandupale mola polale-ni méle kanuma makó topa ‘Pulu Yili-nga’ nimba kake tenjilimú polale olandupaye? ");
INSERT INTO mux_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Akiliinga, yambu te-ni mi lembandu ‘Pulu Yili popu toku mélema kalemele polale’ bi lemba kene méle poluna ola lemba mélale kepe bi lepa mi lemba. ");
INSERT INTO mux_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aku-sipako yambu te-ni mi lembandu ‘lku-tembollale’ bi lemba kene lku-tembollale kene akuna sukundu molemú yili kene bi lepa mi lemba. ");
INSERT INTO mux_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yambu te-ni mi lembandu ‘mulú-koleale’ bi lemba kene Pulu Yili yi nuim kingele molupa kolea nokumbandu molemú polale kepe polu akuna ola molemú yili kepe bi lepa mi lembako. ");
INSERT INTO mux_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene, Perisi-yima kene, eni mindili noku aima molku kis-singí! Eni ‘sika ungma nikimulu.’ niku gólu toku topele-mapele tuli yima! Langi kalungíndu ‘sungu tipili.’ niku eninga puniena méle kelú lupa-lupa pelemúmanga mare liiku langina mundulimele akumanga mare meku kene ung-mani te pelemále piliiku kambu toku “rurepunga tale” niku nosulimelemanga “tilu tilu Pulu Yili-nga” niku wendu liiku yunu silimele. Aku telemele akiliinga-pe ung-mani tondulu ola-kilia mare munduku kelku naa piliiku telemele. ‘Yambuma apuruku yambu-aulima liiku tapunjuku yambu-kísima teku kis-siku naa teku, yambuma naa apuruku pali kondu kolku, Pulu Yili ‘Sika’ niku tondulu munduku piliiku “Temulú.” nilimele mele sumbi-siku teku molku, aku teangi.’ nimba pelemú ung-manimandu niker. Ung-mani wema piliiku telemelema munduku naa kelku ‘mare naa telemele’ niker akuma pali telkemelanje kapula. ");
INSERT INTO mux_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Eni mong kis lílima-ni “⸤Mong kis lili⸥ yambuma kupulanumele liipu ora samili.” nilimele yima, eni ⸤ung-mani wema tondulu munduku piliiku liiku teku, ung-mani tonduluma naa piliiku telemele, aku telemele mele ung-eku topu niambu:⸥ Langi nungíndu méle wallú lopalu mola lumú te langina pelemú kanuku kene ‘Naa namili.’ niku wendu liiku mundulimele, akiliinga-pe kung-kao te langina pelemú kene naa kanuku we liiku toku pengí mundulimele. ");
INSERT INTO mux_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene Perisi-yima kene, eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! Pllet kapmanga ulsukundu lumaye toku konjulemele akiliinga-pe akumanga sukundu langi pelemúma eni tondulu munduku wa liiku, eni-enini waka kolku eni-enini numanu kimbu-siku liilimele uluma. ");
INSERT INTO mux_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Eni mong kis lili Perisi-yima! Pllet kapmanga sukundu lumaye tungí kene ulsukundu kepe kake temba. ");
INSERT INTO mux_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene Perisi-yima kene, eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! ‘Yambu-ónu-koleale kanuku kaí piliangi.’ niku olakundu kopungu kake tiliele kanjilimele mele eni aku-sílima mele molemele. Yambu-ónu-koleama sika ulsukundu kaí lelemú kanolemele akiliinga-pe sukundu yambu kulúlimanga ombelema kene méle purúlima kene peka topa pelemú. ");
INSERT INTO mux_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Eni aku-siku mele molemele. Yambuma-ni eninga kalkundu kanuku kene ‘Eni yi sumbi-nílima’ niku piliilimili akiliinga-pe eninga numanuna sukundu gólu tuli uluma kene ulu-pulu-kísima kene mindi si nimba pelemú. ");
INSERT INTO mux_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Eni ung-manimanga puluma piliiku ung-bo tonjuku mani silimele yima kene Perisi-yima kene eni mindili noku aima molku kis-singí! Eni topele-mapele tuli yima! Pulu Yili-ni “Ninjai!” nimba ung nimba silimúma piliiku yandu yambuma niku sili yima kolemele kene eninga ónu telemele koleama teku mimi teku, sumbi-nili yambumanga ónu-koleama au silimele. ");
INSERT INTO mux_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aku teku kene eni niku mele: “Oliu oliunga anda-kolepalima-kene molkemelanje enini Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima toku kunjuring kene oliunga anda-kolepali naa liipu tapunjupu enini naa tolkemela.” nilimele. ");
INSERT INTO mux_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aku nilimeláliinga ‘Yi kanuma toku kunjuring yambuma-ni kalku liiring yima molemulu.’ niku eni-enini liiku ora silimele. ");
INSERT INTO mux_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aku lem kapula eninga anda-kolepalima-ni ui pulu monjuku teku kis-siring mele eni kamu teai. ");
INSERT INTO mux_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“⸤Yambu nomba kunjuli⸥ wambiyema! Eni gólu topa yambuma tepa kis-sili wambiyelenga walúma! Pulu Yili-ni enindu “Teku kis-siringeliinga tepi-koleana pai.” nimbá kene eni kapula takara toku pungí kupulanum te lembaye? ");
INSERT INTO mux_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Akiliinga, na-ni Pulu Yili-ni “Ninjai!” nimba ung nimba simbama piliiku yambuma niku singí yima kene, piliipa kungnjuli pemba yima kene, mani singí yima kene, eni molemelena liipu mundukur. Yi akumanga mare toku konjuku, mare ‘kolangi.’ niku unji-perana toku uk toku panjiku, mare eni máku toku Pulu Yili-nga ungele piliilimili lkumanga meku puku ka-pulsa-ni toku, koleamanga ‘tamili.’ niku pulú siku aeleku lumbili pungí. ");
INSERT INTO mux_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Aku tingéliinga ui-pulu-pulu ⸤Pulu Yili-ni mulú-masele tirim kene⸥ kepe yandupa ekupu kepe yambu sumbi-nílima toku kunjuringeliinga ulu bunima eni ⸤Juda-yambumanga yi-aulima⸥-kene pemba. ⸤Pulu Yili-nga bukna⸥ ui-pulu-pulu sumbi-nili yi Eboll kene, yandupa muluring yambu sumbi-nílima kene, yandupa ⸤Pulu Yili-nga bukele pora nilimú akuna⸥ Berekia-málu Sekaraya kene toku kunjuring akumanga pali ulu-bunima eni-kene pemba. Sekaraya akili Pulu Yili-nga lku-sulumina lirim lkuli kene Pulu Yili popu toku mélema kaluring polale kene ai-suku-singina toku kunjuring kanili. ");
INSERT INTO mux_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na-ni aima sika enindu niker: “Ui teku kis-siring ulumanga pali ulu-bunima yambu ekupu molkumele ima-kene pemba.” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","⸤Aku nimba kene Yesos-ni Jerusallem muluring yambuma kondu kolupa akilindu ung te nimba kene nimba mele:⸥ “O Jerusallem ⸤yambuma⸥, Jerusallem ⸤yambuma⸥, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima toku konjuku, yu-ni yambuma ‘liiku tapunjangi.’ nimba eni muluringna liipa mundurum yima ku-ni toku konjuku telemele yambuma, kera-kulla anumele-ni yunga walúma ⸤tepa liimbandu⸥ liipa yunga puna mo topa nokulemú akili mele na-ni wale pulele eni aku-sipu nokulka akiliinga-pe eni-enini “Mólu!” niring. ");
INSERT INTO mux_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Akiliinga piliai! ⸤Ele-túma-ni eni tungí ungí kene Pulu Yili-ni alsupa eni naa nokupa naa liipa tapunjupa tepa liimbaliinga⸥ ele-túma-ni oku sika toku munduku eninga koleale kene eninga lku-tembollale kene kamu toku kalungéliinga eni ku pingí. ");
INSERT INTO mux_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Akiliinga na-ni eni ung te wasie nimbu siker: “Eni ⸤Jerusallem-yambuma⸥, eni nandu “Pulu Yi Yawe-ni liipa mundurum-na okum yili bi ola molupa, molupa kunjupili.” ningí kene na alsuku kanungí. Ui mólu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kanu-kene Yesos ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna ulsu omba kupulanum-na pumba purum kene yu lumbili andúlima oku lku-tembollaliinga lku lupa-lupa ⸤aima kaí angiliiringma⸥ yu “Kanui.” niku liiku ora siring. ");
INSERT INTO mux_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","⸤Aku tiring kene⸥ yu-ni eninindu nimba mele: “Ya ⸤lku-temboll kaí angiliimú⸥ kanokumele mélema pali aima sika nimbu siker: “⸤Penga walse ya kolea-auli Jerusallem yambuma mindili nungí enale wendu ombá kene⸥ lku-temboll ili tekisiku kene ku-ma pali toku kalalu singí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kanu-kene yu Unji-Ollip Punie Lili Ma-Pangina ola pupa mania mulurumna we-yambuma naa molangi yunga lumbili anduli yima oku eni-enini molku kene yunundu walsiku piliiku kene niku mele: “Nu-ni nikinu mele te-kene wendu ombáye? Penga nu nondupa uní tiní enale kene kepe male pora nimbá enale kene kepe penga wendu ombáliinga ui nambulka ulu te temba kene oliu kanupu kene “Ekupu ombá tepam lam.” nimbu piliimulúye? Niku si.” niku walsiring. ");
INSERT INTO mux_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yunu-ni eninindu nimba mele: “⸤Ulu kanuma wendu ombáliinga ung mare⸥ yambuma-ni eni gólu toku singéliinga kanuku piliiku kongnjuku molai. ");
INSERT INTO mux_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Yi pulele oku na moliu mele lupa-lupa gólu toku niku mele: “⸤Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum⸥ yi-nuim Krais akili na.” niku kene aku-siku gólu toku singéliinga piliiku kongnjuku molai. Yambu pulele-ni yi kanumanga ungma piliiku liiku “Sika nikimili.” ningí. ");
INSERT INTO mux_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Kolea marenga ele lakuku tingí mele piliiku, ‘Opali talú ele auli i-sipa i-sipa wendu ombá.’ niku we ningí kene piliiku kene mini-wale naa mundai. Ele tingíma kene ulu akuma Pulu Yili-ni ‘Ui wendu upili. Laye penga mele ya ma-koleale pora nimbá.’ nimba, nimba panjurumeliinga ulu akuma sika wendu ombá akiliinga-pe aku-kene mulú-masele ui naa pora nimbá. ");
INSERT INTO mux_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","⸤Mulú-masele pora nimbá enale ui wendu naa upili buni auli mare wendu ombá.⸥ Yambu-talape auli te kene talape auli te kene ele tekulu, yi nuim king marenga talapema-kene marenga talapema-kene ele tingí. Ya ma-kolea lupa-lupamanga engle lepa, ma jim-jim tepa, aku-sipa temba. ");
INSERT INTO mux_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ambu te-ni kangambula koela membáliinga ui bulu mini topa mindili nolemú aku-sipa mele mulú-masele pora nimbá enale koela wendu ombáliinga buni lupa-lupa aku-sipama ui wendu ombá.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ulu kanuma wendu ombá enamanga ‘⸤Na lumbili anduli yambuma⸥ mindili noku, kolangi.’ niku ⸤eni mare⸥ kot tenjiku ka singí. Nanga yambuma molku nanga ungma anduku niku singéliinga koleamanga pali yambuma-ni eni-kene arerembi kolku numanu kis panjingí. ");
INSERT INTO mux_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","⸤Buni kanuma wendu ombá⸥ enamanga na ‘Sika’ niku tondulu munduku piliingí yambu pulele tondulu munduku piliingí mele munduku kelku anju-yandu eni-enini numanu kis panjiku, ‘Krais-nga yambuma molemeláliinga mindili nangi.’ niku eninga ele-túma liiku singí. ");
INSERT INTO mux_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","⸤Ena kanumanga⸥ Pulu Yili-ni “Ninjai!” nimba ung nimba silimúma naa piliiku we gólu toku yandu niku singí yambu pulele wendu ungíko. Aku tingí kene we-yambu pulele-ni ‘Sika nikimili.’ niku eninga ungma piliiku liingí. ");
INSERT INTO mux_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ulu aima kis pulele olandupa-olandupa wendu ombáliinga nanga yambuma-ni ⸤anju-yandu⸥ numanu munjingí mele ⸤kene, na numanu munjingí mele kene⸥ munduku kilingíko. ");
INSERT INTO mux_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Akiliinga-pe nanga ungele munduku naa kelku mulú-masele pora naa nipili tondulu munduku mulungí yambuma ⸤Pulu Yili-ni⸥ tepa liipa ‘Mindili nungí koleana naa puku wasie molupu konjupu mindi pamili.’ nimbá. ");
INSERT INTO mux_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pulu Yili-ni yi-nuim kingele molupa yambuma nokumbaliinga temani kaiéle ‘Yambuma pali piliangi.’ niku koleamanga pali anduku niku singí kene penga mulú-masele pora nimbá enale kamu wendu ombá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","(⸤Na buk ili tokur yili-ni⸥ eni buk kanokumele yambumandu ⸤ung te niambu:⸥ ⸤Yesos-ni nirim⸥ ungele ilinga molemú akili eni bi kanokumele yambuma-ni ung-pulele aima piliiku kaí teangi.’ nimbu niker: ⸤Yesos-ni nimba mele:⸥) “Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Deniel-ni bukna bi topa nimba sirim mele yambu tepa pipili kunjuli mele aima kisele ⸤lku-tembolluna sukundu⸥ Pulu Yili-nga lku-sulumina kake tílina angiliimbáliinga kolea akili aima kalaru molumba mele nirim, bukna molemú. Méle akili akuna wendu omba angiliimba kanuku kene ");
INSERT INTO mux_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","⸤‘uni aulima wendu ombá tekem.’ niku piliiku⸥ kolea Judia distrik koleamanga mulungí yambuma ⸤eninga koleama munduku kelku⸥ ma-pangi lembamanga takara toku pangi. ");
INSERT INTO mux_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yambu te lku-imuna ola mulupili ⸤aku-sipa wendu ombá kene kanupa kene⸥ takara topa pumbandu mania omba ‘Mélema liipu mepu pambu.’ nimba lkuna lkundu naa pupili. ");
INSERT INTO mux_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yambu te puniena molupa kene ⸤‘akara topu pambu.’ nimba⸥ kelepa lkundu pupa yunga alí-wale-pakuli suluele naa liipili. ⸤Sumbi-siku takara toku pangi.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Aku-sipa wendu ombá enaliinga ambu kangambula munjúlima kene, ambu kangambula ame sílima kene, ⸤enini kapula lkisiku takara toku naa pungéliinga⸥ enini-kene aima buni ombáliinga enini kondu tekem. ");
INSERT INTO mux_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Pulu Yili mawa teku kene, ‘Alí telemú kaliimbuma kene ⸤kóru molku kapula naa andolemele⸥ ena-Sambat-manga kene kapula takara toku naa pungéliinga ena kanumanga buni kanuma wendu naa upili.’ niai. ");
INSERT INTO mux_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ena kanumanga buni aima aulima wendu ombá, ui mulú-masele pulu monjupa tirim kene kepe, yandupa ekupu kepe buni aku-sipa te wendu naa urum. Penga kepe aku-sipa buni aulima wendu naa ombáko. ");
INSERT INTO mux_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","⸤Buni kanuma wendu ombá kene Pulu Yili-ni⸥ ‘Bunimanga enama nondupa pora nipili.’ nimba ui naa nimba panjilkanje yambuma pali kolkemela. Akiliinga-pe Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba makó turum yambuma ‘naa kolangi.’ nimba ‘Buni ena akuma nondupa pora nipili.’ nimba, nimba panjurum. ");
INSERT INTO mux_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Buni kanuma omba pemba enamanga yambu mare-ni niku mele: “Kanai! Pulu Yili-ni “Oliu nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele ya omba molemú.” ningí mola “Nena omba molemú.” ningí kene eninga ungma naa piliiku, ‘Sika nikimili.’ niku naa piliai. ");
INSERT INTO mux_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yi mare oku gólu toku kene niku mele: “Pulu Yili-ni makó turum yi-nuim Kraisele na.” ningí, mola gólu toku kene “Pulu Yili-ni “Ninjai!” nimba ung nimba simuma piliipu kene ombu nimbu sikemulu.” ningí. ‘Yambuma pali, Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba makó turum yambuma-ni kepe liipu lu sipu, nikimulu mele ‘Sika’ niku tondulu munduku piliangi.’ niku Pulu Yili-ni mindi ulu-tonduluma kapula telemúma mele manda leku ulu aima tondulu pulele tingí. Akiliinga-pe Pulu Yili-nga yambuma aku-siku kundi tungí kene eninga ungma naa piliiku, liiku su singí. ");
INSERT INTO mux_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Penga ulu akuma wendu ombá mele ‘Eni ui piliangi.’ nimbu ya nimbu siker mele piliai. ");
INSERT INTO mux_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“⸤Wendu ombá mele nimbu siker, piliikimili⸥ akiliinga penga yambu te-ni nimba mele: “⸤Yi-nuim Kraisele⸥ ne yambu naa pili kolea-wakana molemú.” nimbá kene ‘Kanamili.’ niku akuna naa pai. Mola “Lku ilinga suluminana molemú.” níngi lem enini ‘Sika nikimili.’ niku naa piliai. Mulúna kariyapa telemú kene ena ola olemú koleana kepe ena pulimú koleana kepe kariyapa telemú walsekale kanolemele, aku-sipa Mania Omba Mana-Yi Au Talurum Yili ⸤alsupa⸥ mania ombá kene koleamanga pali yambuma-ni yu walsekale kanungí aku-kene “Ya molemú oku kanai.” ningí kene, mola “Ne molemú puku kano-pai.” ningí kene, eninga ungma naa piliai. ");
INSERT INTO mux_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Méle kululi te lelemú koleana kera-ilsapima oku máku tolemele kanili. ");
INSERT INTO mux_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ena kanumanga mindili nungí niker ulu akuma wendu ombá kene pe sumbi-sipa ⸤ulu lupa-lupa mare wendu ombáko. Akuma i-sipa mele:⸥ ‘Kolea tangumbandu ena-mundi tolemú mele naa topa, sumbulú topa, kaliimbu sumbulsuli talang pupa pa tenjilimú mele naa tepa, kombukantupuma mulúna mania omba, mulúna angiliimú méle tonduluma lope-lope tepa anju-yandu pupa, aku-sipa ulu lupa-lupama wendu ombá.’ ");
INSERT INTO mux_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ulu kanuma wendu ombá kene Mania Omba Mana-Yi Au Talurum Yili kamu ombá temba mele liipa ora simba méle te mulúna angiliimbale ⸤kanuku kene⸥ koleamanga pali yambuma-ni aima kola auli-teku tingí. Pe kanuku molangi Mania Omba Mana-Yi Au Talurum Yili tondulu puliele kene, talang lakupa puliele kene kupámanga ola molupa kamu mania ombá ⸤kene⸥ yambuma-ni kanungí. ");
INSERT INTO mux_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kanu-kene bikull ung aima tondulu nipili yu-ni yunga angkellama liipa mundumba kene enini winju-mendu anju-yandu mulú ⸤ma-koleamanga⸥ pali puku Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba ui makó turum yambuma sukundu-sukundu liingí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Unji-píkele-ni telemú aku-sipa ung-eku mele pelemáliinga piliiku kene ung-pulele piliai. Unji-pik kuku topa gomú tolemú-na kanuku kene ‘Ekupu ena temba kaliimbuma wendu ombá tekem lem.’ niku piliilimili. ");
INSERT INTO mux_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aku-sipako, ulu “Wendu ombá.” niker ima sika wendu ombá kene kanuku kene ‘Yu aima sika nondupa ombá tekem. Yu aima kamu okum.’ niku piliingí. ");
INSERT INTO mux_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Na-ni enindu aima sika nimbu siker: “Ekupu molemele yambuma ui naa kolangi i “Wendu ombá.” niker ulu ima pali wendu ombá. ");
INSERT INTO mux_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mulú-masele pora nimbá akiliinga-pe nanga ung niliuma aima pora naa nimbá. ⸤Niliu mele pali aima sika wendu ombá.⸥” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“⸤Mania Omba Mana-Yi Au Talurum Yili aima sika ombá⸥ akiliinga-pe yunga ombá enale naa piliilimulu. Sumbulsuli ombáne, tanguli ombáne naa piliilimulu. Mulú-koleana angkellama kepe naa piliilimiliko. Pulu Yili-nga Málale kepe naa-ko piliilimú. Tata yunu mindi ⸤ena akili⸥ piliipa molemú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ui yi Noa mulupili yambuma-ni tiring mele Mania Omba Mana-Yi Au Talurum Yili ombá temba kene yambuma-ni aku-siku-ko tingí. ");
INSERT INTO mux_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","⸤Ma-koleamanga pali⸥ no ui naa tupili yambuma langi noku, yima ambu liiku, ambuma yi puku, ulu akuma mindi teku mololsiliiku puring. Noa nona anduli sip lkuliinga lkundu purum kene kepe enini ulu akuma mindi we teku muluring. ");
INSERT INTO mux_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Enini ⸤Noa-nga ungele⸥ naa piliiku aku-siku uluma teku mindi molangi no topa ⸤koleama pali no-ni topa panda topa⸥ yambuma pali topa kunjurum. Penga Mania Omba Mana-Yi Au Talurum Yili alsupa ombá enaliinga ui Noa mulupili teku muluring niker mele aku-siku teku mulungíko. ");
INSERT INTO mux_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yu ombá enaliinga yi tale taena unji toku angiliinglí kene ⸤Pulu Yili-nga angkella te-ni omba⸥ yi te we mulupili mundupa kelepa te liipa memba pumba. ");
INSERT INTO mux_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ambu tale langi kalunglí teku mulunglí kene ⸤angkella te omba⸥ ambu te we mulupili mundupa kelepa te liipa memba pumba. ");
INSERT INTO mux_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Akiliinga, eninga Auliele ombá enale aima piliiku bi naa silimelaliinga ‘Yu ombá.’ niku kanuku molai.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Eni ung ili numanu liiku munduku piliai: Lku pulu yi te-ni sumbulsuli wa nuli yi te-ni yunga lkuli omba kuna bulsupa mélema wa liimba mele piliilkanje ‘Wa nuli yili ombá.’ nimba nokupa molka kene wa nuli yili yu kapula suku naa olka. ");
INSERT INTO mux_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aku-siku eni nokuku molai. Mania Omba Mana-Yi Au Talurum Yili ombá enale naa piliilimiléliinga ‘Yu sika ombá.’ niku aku-siku nokuku molai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“⸤Akiliinga ung te niambu:⸥ “Kongun tinjili kendemande-yi nae-ni kongun tepa konjunjulimú kene kanupa kene yunga yi-auliele-ni ‘Yu-ni kongun siliuma sumbi-sipa telemáliinga yu kongun simbu kene tepa konjumbaliinga na alsupu numanu kimbu sipu naa molumbu.’ nilimúye? Kendemande-yi te aku-sipa mele tepa konjupa molemále kanupa kene yunga yi-auliele-ni yu makó topa kene yunundu nimba mele: “Kongun tinjili kendemande-yambuma pali nokunjuku eninga langi nungíma ena makó toliáliinga enini nangi moke teku sikunu, nokunjuku mului.” nimba ⸤yu tenga-lupa pulimú⸥. ");
INSERT INTO mux_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Penga yi-auliele-ni kongun símele kongun tinjili kendemande-yi kanili-ni mimi-sipa tenjipa mulupili auliele kelepa um lem kendemande-yili yu numanu sipili. ");
INSERT INTO mux_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na-ni enindu aima sika nimbu siker: “Yi-auli kanili-ni kendemande-yi kanilindu “Nanga méle nosiliuma pali nu-ni nukunjui.” nimbá.” niker. ");
INSERT INTO mux_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Akiliinga-pe ⸤yi-auliele-ni kendemande-yi kanilindu nimba mele: “Nanga kendemande-yambuma pali nukunjui.” nimba tenga-lupa pulimú kene⸥ kendemande-yi kanili-ni tepa kis-sipa “Nanga auliele wela naa ombá.” nimba piliipa kene yu-ni nokonjilimú kendemande-yambuma kimbulú-ni topa, no noku kelep tuli yima kene langi nomba no tonduluma nomba kene, aku-sipa tepa kis-sipa mulúm lem ");
INSERT INTO mux_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","walse kendemande-yi kanili ‘Yunga yi-auliele ombá.’ nimba naa piliipa ⸤kongun sirim mele naa tepa⸥ walu-sipu molumba kene ombá. ");
INSERT INTO mux_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Omba ⸤yi kanili tepa molumba mele kanupa kene⸥ yu aima kimbulú-ni topa konjupa kene, gólu tolemele yambu topele-mapele tuli yambuma ⸤kolea kis⸥ molemelena ‘Pupili.’ nimba liipa mundumba. Kolea kanuna yambuma aima mindili noku kola teku mindili siku mulungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","⸤Aku nimba kene, Yesos-ni yunu kelepa ombá mele ung mare wasie nimba kene nimba mele:⸥ “⸤Mania Omba Mana-Yi Au Talurum Yili alsupa wale tale-sipa mana mania ombá kene⸥ Pulu Yili yi nuim kingele molupa yambuma nokumba akili i-sipa mele: “Yi te ambu liimba uluma yambuma wasie tingíndu yambu kanuma máku toku muluringna yili ombá tirim kene piliiku kene ‘Sumbulsuli ombá.’ niku ambu-wenipu rurepunga tale eninga tepi-llamuma liiku “Yu kupulanum-na liimulú.” niku puring. ");
INSERT INTO mux_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ambu-wenipu kanumanga angere te-guli piliipa kungnjuli naa pílima sunduku muluring; angere te-guli piliipa kungnjuli pílima muluring. ");
INSERT INTO mux_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Piliipa kungnjuli naa pili sunduku muluring ambu-wenipuma-ni eninga tepi-llamuma meku puring akiliinga-pe llam karasin wasie naa meku puring. ");
INSERT INTO mux_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Akiliinga-pe piliipa kungnjuli pili muluringma-ni karasin kene eninga tepi-llamuma kene meku puring. ");
INSERT INTO mux_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ambu liimba yili wela naa urumeliinga ambu-wenipuma pali uru urum-na uru piring. ");
INSERT INTO mux_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Kanu-kene anjunga-yandunga mambu nangale te omba nimba mele: “Ambu liimba yili okum piliai! Kupulanum-na liangi wai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kanu-kene ambu-wenipuma suru niku ola molku tepi-llam ‘Lakupa nupili.’ niku kanduring. ");
INSERT INTO mux_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Piliipa kungnjuli naa pili muluring ambuma-ni piliipa kungnjuli pili muluring ambumandu niku mele: “Oliunga tepi-llamuma kumbulkumeliinga eninga karasin mare oliu liiku munduku sai.” niring kene ");
INSERT INTO mux_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","piliipa kungnjuli pili muluringma-ni pundu toku niku mele: “Karasin eni kene oliu kene kapula naa temba akiliinga eni stoana puku eninga taropu toku lii-pai.” niring. ");
INSERT INTO mux_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kanu-kene stoana taropu toku liingíndu puring kene ambu liimba yili urum. Kanu-kene yi ambu liimbaliinga langi akuna nungíndu máku turing yambuma, piliipa kungnjuli pili muluring ambu-wenipuma kene wasie lkuna sukundu puring. Kanu-kene lku-kuna toku gi siku langi noku muluring. ");
INSERT INTO mux_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Penga langi noku molangi ambu-wenipu stoana puringma oku kene niku mele: “Auliele, Auliele, oliu wamili kuna lii.” niring. ");
INSERT INTO mux_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Akiliinga-pe yu-ni eninindu pundu topa nimba mele: “Na-ni enindu aima sika nimbu siker: Na eninga bima naa piliiker. ⸤Ulsu molemelema kapula lkundu naa ungí.⸥” nirim.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","⸤Aku nimba kene yu-ni alsupa nimba mele:⸥ “Aku-sipa tembaliinga Mania Omba Mana-Yi Au Talurum Yili alsupa ombá enale kepe eni naa piliiku, ipulam-ui ombá mola tanguli ombá mola, sumbulsuli ombá mola, akili naa piliilimiléliinga ‘yu ombá.’ niku nokuku konjuku molai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","⸤Aku-sipa nimba kene Yesos-ni ung-eku te wasie topa kene nimba mele:⸥ “⸤Pulu Yili-ni yi nuim kingele molupa yambuma nokulemú akili⸥ i-sipa meleko: “Yi te kolea tenga-lupa pupa molumbandu yunga kendemande-yima “Wai.” nimba yunga mélema “Nokunjai.” nimba kene, ");
INSERT INTO mux_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","enini kongun telemele mele piliipa apurupa yunga mélema enini moke tepa kene yi te ku-moni paip-tausen kina mele sipa, te ku-moni tu-tausen kina mele sipa, te wan-tausen kina mele sirim. Aku tepa kene yu purum. ");
INSERT INTO mux_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yi paip-tausen kina liirimele sumbi-sipa pupa ku-moni kanili-ni méle taropu topa kene, ku-moni paip-tausen kina ola-buluna panjipa pupa liirim. ");
INSERT INTO mux_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Aku-sipako yi tu-tausen kina liirimele ola-buluna panjipa tu-tausen kina pupa liirim. ");
INSERT INTO mux_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Akiliinga-pe wan-tausen kina liirimele pupa ‘Mo tambu.’ nimba yu-ni mana mania kusi ukupa yunga nukuli yilinga kuli kusi turum. ");
INSERT INTO mux_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kanu-kene kaliimbu mare pulele omba purum kene kendemande-yi kanumanga nukuli yili omba eninindu nimba mele: “Ku-monima eni tiring mele kanambu liiku ora sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kanu-kene paip-tausen kina liirim yili-ni paip-tausen kina ola-buluna panjipa liirimele memba omba kene nimba mele: “Auliele, nu-ni na paip-tausen kina sirinu kanili. Na-ni paip-tausen kina ola-buluna panjipa pupu liirindele i ambulkur kanui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nukuli yili-ni yunundu nimba mele: “Kendemande-yi kaiéle, aima kapula tirinu. Kongun mele-wele mele sirindele nu-ni teku konjuruneliinga “Nu-ni nanga méle pulele nokunjani.” nimbáliinga nu okunu na-kene wasie tapú-topulu numanu sipu molambili ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yi tu-tausen kina liirim yili yu kepe omba kene nimba mele: “Auliele, nu-ni na tu-tausen kina sirinu kanili. Na-ni tu-tausen kina ola-buluna panjipu liirindele i ambulkur kanui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yunga nukuliele-ni yunundu nimba mele: “Kendemande-yi kaiéle, aima kapula tirinu. Kongun mele-wele mele sirindele nu-ni teku konjuruneliinga nanga méle pulele “Nu nokunjani.” nimbáliinga nu oku na-kene wasie tapú-topu numanu sipu molambili ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kanu-kene wan-tausen kina liirim yili kepe omba kene nimba mele: “Auliele, na-ni piliipu kene, ‘Nu méle taropu tondulu munduku tokunu ‘Ku-moni liipu nosumbaliinga yambuma mindili núngi lem kapulako.’ nikunu ⸤kendemande-yambuma ‘Kongun mindili siku teangi.’ niku sikunu, enini méle koltale sikunu mélema pali nu-nunu mindi liillu yili;⸥ punie yambuma-ni panjinjilimele kene nu-nunu langi mélema we ukuku liikunu; rais-witeliinga kilu kene mongsele yambu wema-ni kilu toku apurunjulimele kene nu-nunu rais-wit mongma we liillu mele.’ na piliirindu. ");
INSERT INTO mux_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","⸤Aku-sikunu telláliinga⸥ na-ni nu mundu-mong tenjipu na pupu nunga ku-moni na sirinele mana mania kusi turundu. Ku-moni kanili i ambulkur kanui. Nunga ku-moni ili nunu siker lii.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Aku nirim kene piliipa kene nukuli yili-ni yunundu pundu topa nimba mele: “Teku kis-sili kendemande-yi kisele, nu-ni piliikunu kene, ‘Punie yambuma-ni panjinjilimele kene akuna na-nanu langi mélema we ukupu liipu; rais-witeliinga kilu kene mongsele yambu lupama-ni apurunjulimele kene na-nanu rais-wit we liiliu.’ niku piliirinu lem. ");
INSERT INTO mux_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aku-siku piliikunu kene nanga ku-monele ku-beng lkuna nosilkinanje kapula. Aku telkenanje na ombu nanga kuli wendu liipu kene ku-moni laye-sele ola panjiku silkimela liilkáko.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","⸤Kendemande-yi kanilindu aku-sipa nimba pora sipa kene yu-ni we-kendemande-yimandu nimba mele:⸥ “Yi ili tepa kis-sirimeliinga yunga kuli wendu liiku kene ten-tausen kina ambulkum yili sai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Mélema nosilimú yambale na-ni mare wasie simbu, yu aima pulele nosimba. Akiliinga-pe mélema naa nosilimú yambale yu nosilimúma kepe wendu liimbáliinga aku-siku teku kene, ");
INSERT INTO mux_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","kendemande-yi kisele sumbulú túlina liiku paka toku pena mundai. Akuna yambuma aima mindili noku kene kola teku mindili siku mulungí.” nirim.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","⸤Aku nimba kene yu penga alsupa omba temba mele nimba kene nimba mele:⸥ “Mania Omba Mana-Yi Au Talurum Yili yunga tondulu talang puliele-kene omba kene, yunga mulú-koleana angkellama-kene pali ungí kene tondulu talang púlina sukundu yi nuim king polale lembana yu molumba. ");
INSERT INTO mux_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yunga kumbi-kerina ma-koleana yambuma pali liiku máku tunjingí. Kanu-kene kung tápu tili yi te-ni yunga kungma apurupa kene kung-sipsipma lupa liipa mundupa, kung-memima lupa liipa mundulimú mele aku-sipa Yi Nuim Kingele-ni yambu máku toku mulungíma apurupa kene, ");
INSERT INTO mux_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","yambu kung-sipsipma mele mulungíma yunga ki-bokundu liipa mundupa, kung-memima mele mulungíma yunga ki-tarukundu liipa mundumba. ");
INSERT INTO mux_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","36","Aku tepa kene, yu-ni yunga ki-bokundu mulungí yambumandu nimba mele: “Na engle-ni kulurundu kene eni na langi siring. Na no waka kulurundu kene eni no kolku siring. Na lku-poning urundu kene eni na “Wasie molamili ui.” niring. Na púla-bale naa panjipu giu-gau andurundu kene mulumbale te siring. Na kuru turum kene nukuring. Na ka-lkuna pirindu kene oku kanuring. Tata-ni ‘Eni molku konjangi.’ nirimeliinga numanu kaí pípili molemele yambuma, eni ulu akuma na-kene tiring akiliinga, ya oku, ui mulú-masele naa lipili Tata-ni yu nokumba koleana eni-kene wasie ‘Tapú-topu molomulú.’ nimba, nimba panjurum koleana sukundu wai.” nimbá. ");
INSERT INTO mux_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aku-sipa nimbá kene piliikuliinga sumbi-nili yambuma-ni pundu toku yunundu niku mele: “Auliele, te-kene nu engle-ni kulurunu-na kanupu kene nu langi sirimuluye? Te-kene nu no waka kulurunu-na kanupu kene nu no kolupu sirimuluye? ");
INSERT INTO mux_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nu yi-poningele tena mulurunu kene kanupu kene “Lkuna lkundu molamili ui.” nirimuluye? Mulumbale naa pakukunu giu-gau andurunu-na nu tena kanupu kene mulumbale sirimuluye? ");
INSERT INTO mux_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nu kuru turum kene kepe, ka-lkuna pirinu kene kepe, te-kene ombu kanurumuluye?” ningí. ");
INSERT INTO mux_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","⸤Aku-siku ningí kene⸥ Yi Nuim Kingele-ni eninindu pundu topa nimba mele: “Na-ni enindu aima sika nimbu siker: “I niker mele i nanga anginipili bi naa mululi te kepe liiku tapunjuring akili na liiku tapunjuring.” niker.” nimbá. ");
INSERT INTO mux_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","43","Kanu-kene yunga ki-tarukundu mulungí yambumandu nimba mele: “Pulu Yili-ni ‘Eni molku kis-sangi.’ nilimú yambuma, na engle-ni kulurundu kene eni na langi te naa siring. Na no waka kulurundu kene eni na ‘no nambu.’ niku kolku naa siring. Na lku-poningele urundu kene na “Wasie molamili ui.” naa niring. Na mulumbale te naa pakupu giu-gau andurundu kene na mulumbale te naa siring. Na kuru turum kene na naa nukuring. Na ka-lkuna pirindu kene na naa oku kanuring. ⸤Eni na aku-siku naa liiku tapunjuring⸥ akiliinga eni nanga kumbi-kerina naa oku anju puku, ⸤kurumanga nuim⸥ depollale kene yunga angkellama kene eninga tepi te nomba pepa mindi pulimú pumba tepi kalunjurundu akuna anju pai.” nimbá. ");
INSERT INTO mux_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aku-sipa nimbá kene piliiku kene yambu kanuma-ni kepe pundu toku niku mele: “Auliele, nu engle-ni kulurunu kene kepe, no waka kulurunu kene kepe, nu poning leku urunu kene kepe, giu-gau andurunu kene kepe, kuru turum kene kepe, ka-lkuna pirinu kene kepe, oliu-ni nu aku-siku mulurunu kene te-kene kanupu kene nu naa liipu tapunjurumuluye?” ningí. ");
INSERT INTO mux_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","⸤Aku-siku ningí kene⸥ yu-ni eninindu pundu topa nimba mele: “Na-ni enindu aima sika nimbu siker: Eni nanga anginipili yambu imanga bi naa mululi te naa liiku tapunjuring aku-kene na naa-ko liiku tapunjuring.” nimbá. ");
INSERT INTO mux_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Kanu-kene ⸤teku kis-silimele⸥ yambu kanuma puku kam-kamu molku kis-siku mindi puli koleana pungí, akiliinga-pe sumbi-nili yambuma puku kam-kamu molku konjuku mindi puli koleana pungí.” ⸤nimba Yesos-ni⸥ nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesos-ni ⸤yu penga yandu ombá mele⸥ ung akuma nimba pora sipa kene yunga lumbili andúlimandu nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Eni piliikimili, ena tale we omba pumba kene Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum Mele Piliilimulu Enale wendu ombá. Ena akili wendu ombá kene Mania Omba Mana-Yi Au Talurum Yili “Kulupili unji-perana ola ⸤toku⸥ ku toku panjangi.” niku liiku singí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesos-ni aku-sipa nirim enaliinga Pulu Yili popu tunjuring yi-aulima kene, Juda-yambuma nukuring tápu-yima kene, enini Pulu Yili popu tunjuring yi-auli-olandupa ‘Kayapas’ nili yi akiliinga lkuna puku liiku máku toku kene, ");
INSERT INTO mux_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesos kiyang niku ka siku tungíndu ele-langi niku muluring. ");
INSERT INTO mux_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Niku molku kene niku mele: “⸤Nondupa tamili,⸥ akiliinga-pe Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum Mele Piliilimulu Enamanga ⸤‘luma tepu molamili.’ niku⸥ yambu pulele ya Jerusallem oku máku toku mulungéliinga yu isili-ui topu konjumulú kene enini oliu-kene arerembi kolku ele tungí akiliinga isili-ui naa topu, kelamili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kolea-kelú Betani yi te ui kuru-laká nomba kene pe pora nirim yi te, bi leku “Yi Kuru-Laká Nuli Saimon” niring kaniliinga lkuna Yesos mulupili ");
INSERT INTO mux_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ambu te kopungu-wel mingi aima kaí te yu mulurumna memba urum. Wel akili aima mura túlieliinga ku-moni aima lakupa purum. Akili memba omba kene Yesos langi nuli polu mulurumna memba omba ⸤‘Yu kaí tenjambu.’ nimba⸥ pengína onde linjirim. ");
INSERT INTO mux_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ambale-ni aku tirim kanuku kene Yesos lumbili andúlima numanu kis piliiku kene niku mele: “Kopungu-wel akili nambimuna we teku kis-sikenuye? ");
INSERT INTO mux_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wel akili ku-moni liilkumulanje ku-moni pulele liipu kene yambu-korupama moke tepu silkimula.” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","⸤Enini ambalendu⸥ aku-siku ⸤niring⸥ piliipa kene Yesos-ni eninindu nimba mele: “Ambu ili-kene nambimuna ung pulele nikimeleye? Yu-ni na-kene ulu kaí te tímu. ");
INSERT INTO mux_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yambu-korupama eni-kene taki-taki mulungí akiliinga-pe na eni-kene taki-taki naa molumbu. ");
INSERT INTO mux_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Na ⸤kolumbu kene⸥ ónu tingéliinga yu-ni wel mura tuli ili nanga kangina onde linjímu. ");
INSERT INTO mux_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na-ni enindu aima sika nimbu siker: “Ma-koleamanga pali ⸤nanga⸥ temani kaí ili anduku toku singí kene ambu ili-ni ekupu tímu temanele kepe ‘Yambuma-ni piliiku kene ‘Yunu-ni tepa kunjurum.’ niku piliangi.’ niku kene temani akili toku singíko.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ena akiliinga Yesos yunu lumbili anduli yi rurepu akumanga yi te, yunga bili Judas-Iskeriot, Pulu Yili popu tunjuring yi-aulima muluringna pupa, ");
INSERT INTO mux_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","enini walsipa piliipa kene nimba mele: “Na-ni eni Yesos ambolku ka singí kupulanum te liipu ora sindu lem eni na ⸤ku-moni⸥ nambi-sili singíye?” nirim. ⸤Aku nirim-na piliiku kene⸥ enini ku-sillipa mong wan-paon-ten kambu toku yu siring. ");
INSERT INTO mux_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kanu-kene yu kelepa yandu omba kene Yesos liipa enini simba kupulanum te korupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pllawa Tepa Auli Mundulimú Méle Yisele Naa Munduku Pllawa We Kalku Nuring Kóraliinga pulu-pulu enale wendu urum kene ⸤Pulu Yili-ni ui Juda-yambuma eninga anda-kolepalima Naa Topa Ola We Omba Purum mele enini piliingíndu kung-sipsip walú te toku kalku nungí mele piliiku kene,⸥ Yesos lumbili anduli yima yu mulurumna oku walsiku piliiku kene niku mele: “Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum mele piliimuláliinga kung-sipsip walú ⸤kaluli⸥ te ekupu nunéle kolea tena pupu tepu mimi te-pamili niku piliikunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","⸤Aku-siku niku walsiring kene⸥ Yesos-ni ⸤yi te molumba mele enini liipa ora sipa kene⸥ nimba mele: “Ne kolea-auli ⸤Jerusallem⸥ sukundu puku kene, ne yi akili molumbana puku yunundu i-siku niangi: “Ung-Bo Tunjuliele-ni i-sipa mele nim: “Na-kene ulu te wendu ombá enale nondupa wendu ombá tekem. Nunga lkuna sukundu na kene nanga lumbili anduli yima kene oliu Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum mele piliimulú kung-sipsip walú ⸤kaluliele⸥ nomulú,” nim,” niangi,” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kanu-kene lumbili anduli yima puku Yesos-ni nirim mele puku teku kene, Pulu Yili-ni eninga anda-kolepalima Naa Topa We Omba Purum mele piliingí kung-sipsip walú nungéle teku mimi teku nusiring. ");
INSERT INTO mux_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kanu-kene, ipinjali enale pupa kolea kalá turum kene Yesos kene lumbili anduli yi rurepu kene ⸤oku⸥ langi nuli poluna muluring. ");
INSERT INTO mux_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Langi noku muluring kene Yesos-ni nimba mele: “Na-ni enindu aima sika nimbu siker: “Eninga yi te-ni na liipa nanga ele-túma simba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","⸤Aku nirim piliiku kene⸥ eninga numanuna buni auli-tepa tirim piliiku kene lupa-lupa walsiku niku mele: “Auliele, nandu nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesos-ni pundu topa nimba mele: “⸤Eni nanga yi rurepu-kenga⸥ yi te na-kene langima polu suku-singina ola lelemú te walsekale liipu nombulú yili-ni na liipa, ele-túma simba. ");
INSERT INTO mux_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ekupu Mania Omba Mana-Yi Au Talurum Yili-kene tingí mele kórunga-ui niku panjiring temanele ⸤Pulu Yili-nga⸥ bukna molemú akili sika ele-túma-ni tingí, akiliinga-pe yu liipa ele-túma simba yili mindili nomba aima molupa kis-simba. Yu molupa kis-simbaliinga yi akili anumu-ni naa melkanje kapula. Yu mindili naa nolka.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yesos-ni aku-sipa nirim piliipa kene Judas, yu liipa ele-túma simba tirim yili, yu-ni Yesos-ndu nimba mele: “Rapai, nikinu yili nandu nikinunje?” nimba walsurum kene Yesos-ni yunundu “Sika, nu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Enini langi noku molangi Yesos-ni bret te liipa Pulu Yili-kene “Angke” nimba ambulupa puku topa yu lumbili andúlima sipa kene nimba mele: “Ili nanga kangiele eni liiku nai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Penga no-waen-kap te liipa kene Pulu Yili-kene “Angke” nimba enini sipa kene nimba mele: “⸤No-waen ili⸥ eni pali liiku nai. ");
INSERT INTO mux_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","⸤No-waen⸥ siker ili nanga memale. Pulu Yili-ni ⸤yu kene yunga yambuma kene mulungí mele⸥ ung te nimba panjipa mi lirim ung kanili ‘Kamu wendu omba pípili.’ nimbu ‘Yambu puleliinga ulu-pulu-kisma kamu mania pupili. Pulu Yili-ni alsupa naa kanupa mundupa kilipili.’ nimbu nanga memale onde lenjipu kene ⸤kolumbu⸥ memi akili ili. Akili eni pali liiku nai. ");
INSERT INTO mux_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na-ni enindu i-sipu nimbu siker: “Isili-ui na no-waen alsupu aima naa nombú. Penga mindi, Pulu Yili yi nuim kingele molupa nokulemú koleana eni-kene no-waen konale kelepu nombú.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","⸤Langi noku pora siku kene⸥ enini Pulu Yili-nga konana te niku kene, pena puku Unji-Ollip Punie Lili Ma-Pangina ola puring. ");
INSERT INTO mux_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kanu-kene Yesos-ni yu lumbili andúlimandu nimba mele: “Aima ekupu sumbulsuli ⸤ele-túma-ni⸥ na-kene tingí ulele kanuku kene eni pali na munduku kilingí. ⸤Aku-siku tingí mele⸥ Pulu Yili-ni ui nirim yunga bukna molemú kanili. Pulu Yili-ni ⸤ung-eku te topa kene⸥ nimba mele: “ “Kung-sipsip tápu-yili tangi.” nimbú, yu tungí kene sipsipma bulu-bale ningí.” nirim, ⸤aku-mele ekupu wendu ombá⸥. ");
INSERT INTO mux_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","⸤Isili-ui na toku kunjingí kene eni sika bulu-bale ningí⸥ akiliinga-pe na lomburupu ola molupu kene, na kumbi-lepu kolea Gallallindu pumbu, ⸤eni penga aeleku akuna ungí kene alsupu wasie molomulú⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","⸤Yesos-ni aku-sipa nirim-na piliipa kene⸥ Pita-ni nimba mele: “Nu-kene ulu te wendu ombáliinga kanuku kene enini pali ‘Nu sika’ niku tondulu munduku piliilimili mele mania pumbaliinga nu aku-siku munduku kilíngi lem na-ni nu aima mundupu naa kelimbu, aima mólu!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesos-ni pundu topa nimba mele: “Na-ni nu aima sika nimbu siker: “Aima ekupu sumbulsuli, kera-kulla ui ko naa tupili nu-ni ⸤mundu-mong tenjikuliinga⸥ wale yupuku nandu gólu tokunu “Yu naeye. Na naa kanoliu.” niní.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Akiliinga-pe Pita-ni yunundu nimba mele: “Na nu-kene tapú tolembulaliinga olsu kene wasie “Topu konjumulú.” níngi lem kepe nu “Naa kanoliu.” aima naa nimbále.” nirim. Lumbili anduli yi wema-ni pali “ “Nu naa kanolemulu.” aima naa nimulú.” niringko. ");
INSERT INTO mux_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kanu-kene Yesos kene yu lumbili anduli yima kene kolea ‘Gesemani’ nílina puring. Akuna puring kene yu-ni eninindu nimba mele: “Na anju pupu Pulu Yili-kene popu topu ung ni-pukuraliinga eni ya molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aku nimba kene Pita kene Seperi-málu ⸤Jemis kene Jon-sele⸥ wasie liipa memba pupa kene ⸤‘Na teku kis-singí ulele aima nondupa wendu ombá tekem.’ nimba piliipa kene⸥ yu-yunu kondu kolupa numanu kis panjipa kamelena mindili tipili mulurum. ");
INSERT INTO mux_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yunu-ni eninindu nimba mele: “Nanga numanuna buni aima auli te tepam akiliinga na kolumbu mele tekem. Eni uru naa peku na-kene wasie tapú-topu nokupu konjupu molamili, eni ya we mimi-siku kanuku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","⸤Aku nimba kene⸥ yu-yunu laye-kolte anju pupaliinga koporungu langupa tamalu pepa kene Pulu Yili-kene ung nimba mawa tepa nimba mele: “Nanga Tata, na nondupa ⸤mindili nuli⸥ no-mingina no nombále ‘Naa nambu.’ niní kupulanum te lelemú lem aima kapula, akiliinga-pe ‘Na-ni tepu kene nanu numanu simbu.’ nimbu piliiker akili mele naa teambu. Nu-ni kanuku kaí piliiní ulele mindi teambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aku nimba kene kelepa yunga lumbili anduli yi yupuku muluringna yandu omba enini uru piring kanupa kene Pita-ndu nimba mele: “Eni uru naa peku na-kene ena-mong layesele kapula we kanuku nokunjuku naa molkemelaye? ");
INSERT INTO mux_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","‘⸤Kurumanga nuim Seten-ni⸥ oliu kundi tomba kene tepu kis-simulú akiliinga.’ niku kene ⸤uru naa peku⸥ Pulu Yili-kene popu toku ung niku kanuku kaí teku molai. Sika ‘tepu konjamili.’ nimbu numanale-ni piliilimulu akiliinga-pe temuláliinga kangiele enimbu molupa tondulu naa pulimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aku-sipa nimba kene yu alsupa anju pupa ui Pulu Yili-kene ung nimba mawa tirim mele alsupa nimba mele: “Nanga Tata, na ‘⸤Mindili nuli⸥ no-mingina nole nani.’ nirinu nole naa nombú kene we pemba lem nu-ni ‘Wendu upili.’ niku piliillu mele na-kene wendu upili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Alsupa yandu urum kene enini uru urumeliinga alsuku uru piring kanupa kene ");
INSERT INTO mux_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","yu alsupa anju pupa yupuku-tenjipa kene Pulu Yili-kene ung ui nimba mawa tirim mele alsupako nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kelepa yandu omba kene lumbili andúlimandu nimba mele: “Nambimuna we uru peku múlu liiku molemeleye? Kanai! Mania Omba Mana-Yi Au Talurum Yili ⸤toku kunjingí⸥ ulu-pulu-kis telemele yima liiku singí enale wendu ombá tekem. ");
INSERT INTO mux_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ola molku pamili wai! Na liipa ele-tu yima simba yili okum kanai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesos-ni ⸤kolea Gesemani yu lumbili andúlimandu⸥ aku nimba sipa mulupili yunga lumbili anduli rurepu akumanga yi Judas urum. Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene, yi kanuma-ni liiku munduring yi pulele, yambu tuli lu-koyama kene kimbulúma kene meku, Judas kene uring. ");
INSERT INTO mux_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ui Yesos mulurumna naa wangi Yesos Juda-yi-aulima liipa simba nimba panjurum yi ⸤Judas-ni⸥ enini Yesos yu sumbulsuli kapula kanungí mele nimba sipa kene nimba mele: “Na-ni yi te kanupu kene kanglumbu akili Yesos. Yu ambolku liiku ka sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","⸤Yi akuma⸥ uring kene ⸤Judas⸥ yu Yesos mulurumna sumbi-sipa omba kene “Rapai, nu akuna mulúnu.” nimba omba yu kanglurum. ");
INSERT INTO mux_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aku tirim kene Yesos-ni yunundu nimba mele: “Ang, nu-ni tiní okonu mele sumbi-siku ti.” nirim. ⸤Judas-ni Yesos-kene tirim mele⸥ kanuku kene ⸤uring yima-ni⸥ yu liiku ka siring. ");
INSERT INTO mux_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Aku tiring mele kanupa kene Yesos wasie tapú-toku angiliiring yi te-ni yunga lu-koyale kulu topa wendu liipa Pulu Yili popu tunjuring yi-auli-olandupaliinga kendemande-yi te topa yunga kum te topa laká linjirim, kum akili wendu urum. ");
INSERT INTO mux_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","⸤Yunu-ni aku tirim-na kanupa kene⸥ Yesos-ni yunundu nimba mele: “Nunga lu-koyale alsuku laliui! Lu-koya liiku yambu tungí yambuma lu-koya-ni toku kunjingíko, akiliinga ⸤‘Mólu.’ nimbu lu-koyama-ni ulu te naa teamili⸥. ");
INSERT INTO mux_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na-ni nanga Tata walsipu kene “Teku lii.” nilkanje yu-ni angkella-ami talape rurepu, mola olandupa malapunga tilu mola tale, enaliinga na “Teku liangi pai.” nimba liipa mundulka akili nu naa piliikunuye? ");
INSERT INTO mux_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Akiliinga-pe ⸤angkellama-ni oku ele-túma-ni na ‘naa tangi.’ niku teku liilkemelanje⸥ Pulu Yili-nga bukna na-kene wendu ombá nimba molemú mele nambi-sipa wendu olkaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","⸤Aku nimba kene⸥ Yesos-ni ⸤yu ka singí uring⸥ yi pulele oku muluringmandu nimba mele: “Na ‘yambu topu wa nuli yi te moliu.’ niku piliiku kene na ka singíndu yambu tuli lu-koyama kene kimbulúma kene meku okumeleye? Lku-temboll ⸤lku-kerina we-yambuma máku toku molemele⸥ koleana taki-taki eni wasie molemulu kene ung-bo tonjupu moliu kene na liiku ka naa silimele kanili. ");
INSERT INTO mux_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Akiliinga-pe i-sipa wendu okum uluma pali Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi mare-ni ulu mare ⸤na-kene⸥ penga wendu ombá mele ui niku bukna turing molemú mele kamu wendu okum.” nirim. Kanu-kene yu lumbili andúlima pali ⸤‘Oliu wasie ka singínje.’ niku piliiku kene⸥ yu munduku kelku enini takara toku puring. ");
INSERT INTO mux_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kanu-kene Yesos ka siku kene Pulu Yili popu tunjuring yi-auli-olandupa Kayapas mulurumna meku puring. Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambumanga tápu-yima kene, enini ⸤‘Yesos kot tenjipu piliamili.’ niku⸥ akuna ui oku máku toku muluring. ");
INSERT INTO mux_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Akiliinga-pe ⸤Yesos meku puring kene⸥ Pita lumbili aelepa táka-nimba pupa, Pulu Yili popu tunjuring yi-auli-olandupaliinga lkuna, lku angiliipa pala mele póku tirim, suku-singina yambu máku turing kolea we lirimna aima sukundu pupa, ‘Yesos nambulka tingínje piliambu.’ nimba ⸤Yesos nokuku muluring⸥ ele-yima-kene mulurum. ");
INSERT INTO mux_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga kanjoll-yima pali kene, akuma-ni Yesos yu toku kunjingíndu ulu te tepa kis-sirim ulu te ‘Yambu te-ni ‘yu i-sipa i-sipa tepa kis-sirim.’ nimba gólu topa nipili.’ niku yambu te koruku muluring kene ");
INSERT INTO mux_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yambu pulele oku ung mare gólu toku niring akiliinga-pe enini yu kapula toku kunjingí ung te naa niring. Laye-kolte penga mele yambu tale okulu ");
INSERT INTO mux_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","⸤gólu toku⸥ nikulu mele: “Yi ili i-sipa nirim ⸤piliirimbulu⸥: “Pulu Yili ⸤popu toku kaluli⸥ lku-temboll ili na-ni topu tekisipu kene ena yupuku omba pupili lku-temboll ⸤kona⸥ te kapula alko topu takumbu.” nirim. ⸤Yunu-ni aku nirimaliinga ‘Yu Pulu Yili mele moliu.’ nimba piliipa kene nirim akili nimba kis-sirimnje⸥.” niringli. ");
INSERT INTO mux_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aku niringli piliipa kene Pulu Yili popu tunjuring yi-auli-olandupale ola angiliipa Yesos walsipa kene nimba mele: “Ung te pundu toku naa nikinuye? Nu ⸤nikunu kis-sirinu mele⸥ nikimbiliele nambulka ulele nikunu kis-sirinelendu nikimbiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Akiliinga-pe Yesos ung te pundu topa naa nimba we angiliirim. Pulu Yili popu tunjuring yi-auli olandupale-ni yunundu alsupa nimba mele: “⸤Nu mollu mele aima sika niku si.⸥ Kona Molupa Mindi Puli Pulu Yili piliipa mulupili “Aima sika niker.” niku mi lekunu kene, Pulu Yili yunga Málale, yu-ni oliu “Nokupa konjumba yi te liipu mundumbu.” nimba makó turum yi-nuim Kraisele sika nu mola móluye? Oliu aima nikunu si!” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesos-ni nimba mele: “Akili na.” ⸤nirim⸥. “Ung te kene wasie enindu pali nikerko. Penga walse Mania Omba Mana-Yi Au Talurum Yili, Yi Tondulu Olandupa Púliele-⸤kene mélema nokumbandu⸥ yunga ki-bokundu molupa, kupámanga ola molupa mania ombá eni kanungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Aku-sipa nirimaliinga ⸤‘u Pulu Yili mele moliu.’ nimba nirimaliinga⸥ piliipa kene Pulu Yili popu tunjuring yi-auli olandupale-ni ⸤aima piliipa kis piliipa⸥ yunga wale-pakuliele yunu ambulupa sungu sipa kene nimba mele: “Ekupu yu-yunu aima sika Pulu Yili ung-taka tonjukumeliinga piliipu kene mong liirim mele nimba simba yambu te kene wasie nambimuna korumulúye? Yu-yunu aima sika Pulu Yili ung-taka tonjukum piliikumulu. ");
INSERT INTO mux_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nambulka niku piliikimiliye? ⸤Yunu-kene nambulka teamiliye?⸥” nirim kene enini niku mele: “Yu Pulu Yili ung-taka tonjupa marake tímeliinga topu kunjúmulu lem kapula.” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kanu-kene enini yunga kumbi-kerina lkambe toku munduku, ki-kumu-ni turing. Mare-ni yu lkarauwa-ni toku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Nu ‘Pulu Yili-ni oliu nokupa konjumba yi te “liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele moliu.’ nillu akiliinga ekupu nae-ni nu tokumnje nikunu si.” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kanu-kene Pita yu Yesos kot piliiring lku penakundu, yambuma liiku máku turing koleana mulurum kene kongun tinjili kendemande-ambu te Pita mulurumna omba yunundu nimba mele: “Nu kepe Gallalli distrik yi Yesos-kene wasie tapú-toku muluring kanumanga yi te lem.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Akiliinga-pe akuna muluring yambuma pali kanuku piliiku molangi Pita-ni gólu topa kene “Mólu.” nimba “Nu nikinu mele na naa piliiker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aku nimba kene Pita yu lku-keri-puluna pupa mulupili kongun tinjili kendemande-ambu te-ni yu kanupa kene akuna muluring yambumandu nimba mele: “Yi ili yu Nasaret-yi Yesos kene wasie tapú-toku muluring yi kanumanga yi kanili lem.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita-ni alsupa “Mólu. Nu-ni nikinu yili na naa kanoliu.” nimba kene Pulu Yili-nga bili lepa mi lirim. ");
INSERT INTO mux_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Laye-kolte penga mele, Pita angiliirimna nondupa angiliiring yima-ni ⸤yu ung laye lupa mele lirim-na piliiku kene⸥ yu angiliirimna oku kene yunundu niku mele: “Kolea Gallalli distrik yambuma-ni ung lelemele mele nu aku-sikunu ung nikinu piliikumulu. ⸤Yesos kene yu lumbili anduli yima kolea Gallalli distrik akuna yima,⸥ nu kepe wasie Gallalli-yi te-ko, akiliinga ‘Nu aima sika yunga lumbili anduli yi te lem.’ nimbu piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Aku niring kene Pita-ni Pulu Yili-nga bili lepa tondulu mundupa mi lepa kene nimba mele: “Aima sika niker. Eni nikimili yili aima naa kanoliu! Gólu tokur lem Pulu Yili-ni na topa kunjupili.” nirim. Aku nirim kene nondopa kera-kulla ko turum. ");
INSERT INTO mux_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aku tirim kene piliipa kene Yesos-ni yunundu “Kera-kulla ui ko naa tupili nu-ni wale yupuku gólu tokunu kene “Yu naa kanoliu.” niní.” nirim ung kanili Pita kelepa piliirim. Piliipa kene ⸤‘Ama, aima tepu kis-sindu lam. ‘Aima naa tembu.’ nimbu piliirindu kanili sika tindu.’ nimba piliipa kene⸥ pena pupa kola aima tondulu tirim. ");
INSERT INTO mux_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ulsulam-ui muni-pokuna kolea tangurum kene Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene pali ⸤Yesos-nga kotele piliiku pora siku kene⸥ ‘Yu topu konjamili.’ niku, niku panjiring. ");
INSERT INTO mux_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Aku niku panjiku kene yunu liiku, ka siku, meku puku, ⸤Rom-⸥gapman yi-nuim Paillet mulurumna meku puku kot tinjiring. ");
INSERT INTO mux_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kanu-kene Judas, yu Yesos liipa yunga ele-túma sirim yi kanili, Yesos-nga kotele piliiku kene “Kulupili, toku konjangi.” niring-na piliipa kene yu-ni Yesos liipa sirimeliinga piliipa kis piliipa kene kelepa numanu topele topa eninga ku-sillipa wan paon ten ui yunu siringma kelepa memba pupa Pulu Yili popu tunjuring yi-aulima kene Juda-yambumanga tápu-yima kene sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Na-ni yi eni liipu sindu yi kanili yunu ulu te tepa kis naa sili yili ‘Toku konjangi.’ nimbu liipu síndele aima ulu-pulu-kis te tindu.” nirim. Akiliinga-pe enini pundu toku niku mele: “Akili oliunga ung te mólu. ⸤Nu-nunu mindi oliu liiku sinu.⸥ Akili nunga kongunale.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanu-kene Judas yu-ni ku-sillipa kanuma memba pupa ⸤Pulu Yili popu turing⸥ lku-temboll palana topa anjukundu mundupa yunu enini mundupa kelepa anju purum. Anju pupa kene ‘Ka nombu kolambu.’ nimba ka te liipa memba pupa kene ka nomba kulurum. ");
INSERT INTO mux_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pulu Yili popu tunjuring yi-aulima-ni ku-moni kanuma ⸤mania-poluna⸥ lirim kanuku liiku kene niku mele: “Ku-moni ima yambu topu konjumulundu símuluma akiliinga lku-temboll ku-monima kene tere lepu nosimulú kene kapula naa temba. Akiliinga ung-mani te pelemú akiliinga naa nosamili.” niku kene ");
INSERT INTO mux_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ung te niku panjiku kene niku mele: “Ku-moni ima-ni mingi-sospen ma-ni tepa mimi telemú yilinga male taropu topu liamili. Yambu te ma te naa lemba eninga kolea suluna yambu lku-poning ya oku molemelemanga yambu kulungíma akuna ónu teangi.” niku kene aku-siku taropu toku liiring. ");
INSERT INTO mux_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","⸤Ku-moni kanuma-ni yi te toku kunjingí kupulanumele akisinjiring kúma-ni⸥ aku tiringeliinga ma kanili bi leku ‘Yambu Toku Memi Onde Liring Male’ niring akili ekupu kepe aku-sipu nilimulu. ");
INSERT INTO mux_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","⸤Juda yi aulima-ni⸥ aku-siku tiringeliinga Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Jeremaya-ni ulu te penga wendu ombá nimba ui nirim mele kamu wendu urum. Yu-ni nimba mele: “Auliele-ni nandu “Ti.” nirim mele enini aku-siku tingíndu Isrel-yambuma-ni “Yi akili ku-sillipa wan paon ten-ni taropu toku liangi.” niring kuma liiku kene, ku kanuma-ni mingi-sospen ma-ni mimi tirim yilinga male taropu toku liiring.” nirim kanili mele kamu wendu urum. ");
INSERT INTO mux_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Judas aku-sipa tepa mulupili Yesos Rom-gapman yi-nuim ⸤Paillet⸥ mulurum kumbi-kerina angiliirim kene yi-nuim kanili-ni ⸤yunga kotele piliipa kene⸥ yu walsipa piliipa kene nimba mele: “Nu Juda-yambumanga yi nuim kingele mola móluye?” nirim. Yesos-ni pundu topa nimba mele: “Sika nikinu. Akili na.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pulu Yili popu tunjuring yi-aulima kene, ⸤Juda-yambumanga⸥ tápu-yima kene, enini Yesos kot tenjiku Paillet-ndu ⸤gólu toku⸥ ung pulele ningindu niku mele: “Yesos yunu tepa kis-silimú.” niku yu kot tinjiring kene Yesos yunu ung te naa nimba we angiliirim. ");
INSERT INTO mux_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","⸤Yesos-ni ung te naa nirim kanupa kene⸥ Paillet-ni yunundu nimba mele: “Nu ulu-kis pulele tirinu nikimelale nu naa piliikunuye?” nirim kene ");
INSERT INTO mux_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesos ⸤yu tepa kis-sirim niring mele⸥ pundu topa ung tiluri kepe naa nimba ⸤we angiliirim-na kanupa kene Rom-⸥ gapman yi-nuim kanili-ni aima mini-wale mundupa numanu pulele liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","16","⸤Yesos kot tenjiku molangi,⸥ yi te, yunga bi Barapas, yu mong liirim mele yambuma-ni pali piliiku muluring yi kanili yu ka-lkuna pirim. ⸤Punie tilu-tilu niku, Juda-yambuma-ni kolea-auli Jerusallem oku akuna suku⸥ Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingíndu langi nuring enama wendu urum kanu-kene enini ka-lkuna pirim yi te bi leku “Wendu liiku mundui.” niku mawa tiring mele ⸤Rom-⸥gapman yi-nuimele-ni yi kanili wendu liipa yambuma sirim. ");
INSERT INTO mux_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","⸤Aku-siku ti-pui-upui tiring enale kamu wendu omba pípili Yesos kot tinjiring piliipa kene,⸥ Juda-yambuma liiku máku toku muluring kene Paillet-ni enini walsipa nimba mele: “Yi nae ka-lkuna wendu liipu eni sambu niku piliikimiliye? Yi Barapas wendu liipu sambu, mola “Pulu Yili-ni “Eni nokupa konjumba yi te liipu mundumbu.” nimba ui nimba makó turum yi-nuim Kraisele.” nilimele yi Yesos wendu liipu sambuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","⸤We-yambuma Juda-yambumanga yi-aulima munduku kelku eninga ungma liiku su siku Yesos-nga ungele piliiku yunu lumbili anduringeliinga Juda-yambumanga yi-aulima⸥ Yesos-kene numanu kis panjiku kene kot tinjiring-na piliipa kene Paillet-ni aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paillet kot piliirim poluna ⸤molupa kene ‘Juda-yi aulima-ni pundu toku ung te ningínje.’ nimba nokupa⸥ mulurum kene yunga ambu-mínele-ni ung te yunu mulurumna nimba mundupa kene nimba mele: “Nu-ni andi yi sumbi niliele ulu te naa ti. Ekupu yu uru-kumbu tepu kanundeliinga nanga numanuna buni pulele wendu úmeliinga yu ulu te aima naa ti.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","⸤Paillet-ni “Ka-yi nae wendu liipu sambuye?” nirim-na piliiku kene⸥ Pulu Yili popu tunjuring yi-aulima kene, ⸤Juda-yambumanga⸥ tápu-yima kene, enini we-yambuma kundi toku kene “ “Yesos topa kunjupili. Barapas wendu liipa sipili.” niai.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","⸤Aku-siku niring kene piliipa kene Rom-⸥gapman yi-nuimele-ni eninindu “Yiselenga ‘nae wendu liipu sambu.’ niku piliikimiliye?” nimba walsurum kene enini pundu toku niku mele: “Yi Barapas ⸤wendu liiku si⸥.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aku-siku niring-na piliipa kene Paillet-ni eninindu nimba mele: “Aku lem, enini “Pulu Yili-ni “Eni nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele.” nilimele yi Yesos, nambi teambuye?” nimba walsurum kene enini pali “Yunu kulupili, unji-perana ⸤toku⸥ ku tokunu panjui!” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aku-siku niringeliinga piliipa kene yu-ni eninindu nimba mele: “Akili nambimunaye? Yu nambulka mong te líímuye?” nirim. Akiliinga-pe enini ⸤alsuku⸥ aima tondulu munduku niku mele: “Mólu! Yu kulupili, unji-perana ⸤toku⸥ ku tokunu panjui!” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Yunga ungele naa piliiku, ele tingí tiring kanupa kene Paillet-ni no kolupa liipa, yambu liiku máku toku muluringma kanuku molangi yunga ki lumaye topa kene nimba mele: “Yi ili toku kunjingí kolumba kene eni-kene ung pemba; nanga ung te naa pemba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","⸤Aku-sipa nirim-na piliiku kene⸥ yambuma-ni pundu toku niku mele: “Yu tungí kolumbaliinga buni pembale oliu kene oliunga kangambulama kene pípili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kanu-kene yi Barapas ka-lkuna wendu liipa enini sirim. ⸤Aku tepa kene⸥ Yesos liipa ⸤yunga ami-yima⸥ sipa kene nimba mele: “Yu ka-pulsa-ni toku kene penga ‘Unji-perana kulupili.’ niku meku puku unji-perana ⸤toku⸥ ku toku panji-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kanu-kene ⸤Rom-⸥ gapman yi-nuimeliinga ami-yima-ni Yesos liiku yi-nuim kanili pirim lku auli akuna sukundu ⸤yambuma liiku máku toku muluring koleana⸥ puku kene, eninga ami-talapena-yima pali “⸤Yesos ya molemúna⸥ sukundu-sukundu wai.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Kanu-kene yunga mulumbalema posuku wendu liinjiku, ‘Yu yi nuim kingele mele mulupili.’ niku mulumbale kunduli kaí te pakunjuku, ");
INSERT INTO mux_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","unji-ka ko-ko mulurum te liiku mulkapiye teku kene ‘Yi nuim kingeliinga waniele.’ niku pengína pakunjuku, kingima-ni apulu te we ambululimele mele kolu-apulu te liiku yunga ki-bokundu ambulunjuku, yu angiliirimna koporungu languku ung-taka tonjuku bi we gólu toku paka tunjingindu “Juda-yambumanga yi nuim kingele, nu molkunuye?” niku ");
INSERT INTO mux_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","yunga kumbi-kerina lkambe toku kanjuku, kimbulú ambulurumele liiku yunga pengína kimbulú tu-pui-upui tiring. ");
INSERT INTO mux_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yunu aku-siku ung-taka tonjuku pora siku kene mulumbale kunduliele posuku wendu liinjiku, yunga ui panjurum mulumbalema alsuku panjinjiku kene “Yu kulupili, unji-perana panju-pamulu.” niku yunu liiku meku puring. ");
INSERT INTO mux_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","⸤Rom ami-yima-ni Yesos Jerusallem palana⸥ ulsukundu meku pungí puku kene, kolea Sairini yi te, yunga bili Saimon, ambolku liiku ka mele siku kene Yesos kolumba unji-perale “Alko toku minjí.” niku siring. ");
INSERT INTO mux_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Puku kene kolea Golkota puku akuna muluring. (Golkotanga ung-pulele ‘pengi-ombele lili koleale’.) ");
INSERT INTO mux_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","⸤Yesos akuna meku puku kene, ‘Yambuma mindili naa nangi.’ niku⸥ no-waen-na suku marasin kumbili tili te munduku nusiring no-waen akili ‘Yu nupili.’ niku, siringeliinga-pe no-waen akili nomba piliipa kene “Mólu.” nimba naa nurum. ");
INSERT INTO mux_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kanu-kene ⸤ami-yima-ni⸥ yu unji-perana ola panjiku kene unjele liiku ola angnjiring. ⸤Aku-siku teku kene, ui unji-perana ola ⸤toku⸥ ku toku naa panjiku kene⸥ yunga mulumbale ⸤posuku wendu liiku nusuringma⸥ moke tingindu enini lupa-lupa liingíndu ku-kas teku piliiku kene penga mulumbalema liiring. ");
INSERT INTO mux_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe yunu unji-perana ola pípili tápu-teku kanuku muluring. ");
INSERT INTO mux_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","‘Yu mong liirim mele yambuma kanangi.’ niku YI-YESOS ILI JUDA-YAMBUMANGA YI NUIM KINGELE niku bi toku yunga pengína olakundu unjina panjiring. ");
INSERT INTO mux_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ele tekulu mélema wa liiringli yi tale kene wasie unji-pera tálenga ⸤toku⸥ ku toku panjiringko. Te Yesos yunga ki-bokundu ⸤toku⸥ ku toku, te ki-tarukundu ⸤toku⸥ ku toku panjiring. ");
INSERT INTO mux_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Akuna oku puring yambuma-ni Yesos ⸤kanuku kene yunga⸥ ung-taka tonjuku ung-mura mele siku kene ");
INSERT INTO mux_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","niku mele: “Aa! “Lku-tembollale tekisipu kene alsupu ena yupuku omba pupili takupu liimbu.” nirinu yili, ‘Naa kolambu.’ niku nu-nunu tekunu lii. Nu sika Pulu Yili-nga Málale lem unji-perana mania ui.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aku-sikuko Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, ⸤Juda-yambumanga⸥ tápu-yima kene, enini kepe yu ung-taka tonjuku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yu yambu-wema ‘Naa kolangi.’ nimba tepa liirim akiliinga-pe yu-yunu ‘Naa kolambu.’ nimba kapula naa tepa liikimu. Yu ‘Isrel-yambumanga yi nuim kingele ⸤moliu.’ nilimú akili sika aku-sipa⸥ molemú lem yu-yunu unji-perana mania upili. Yu-yunu unji-perana mania ombá kene kanupu kene ‘Yu sika oliunga yi nuim kingele.’ nimbu tondulu mundupu piliimulú. ");
INSERT INTO mux_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yu-ni ‘Pulu Yili-ni na tepa liimba.’ nimba tondulu mundupa piliipa molemú kanili; yu “Pulu Yili-nga Málale moliu.” nilimú akiliinga Pulu Yili-ni yu kanupa kaí piliipa, ‘Yu mania we olkanje kapula.’ nimba pilíímu lem kapula, yunu omba yu tepa liipa ⸤unji-perana wendu liipili⸥. ⸤Aku-sipa tímu lem ‘Yu sika Pulu Yili-nga Málale.’ nimbu tondulu mundupu piliimulú⸥.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Wa-yi tale yu-kene unji-peraselenga ⸤toku⸥ ku toku panjiring yisele-ni yu aku-siku ung-taka tunjuringliko. ");
INSERT INTO mux_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","⸤Yesos unji-perana ola we pípili⸥ ai-tangili ena tuwallup killok tirim kene kolea pali sumbulú topa kene, penga ipinjali ena tre killok tirim kene kolea kelepa pa tirim. ");
INSERT INTO mux_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ipinjali ena tre killok mele tirim kene Yesos-ni nangale topa kene nimba mele: “Elloi, Elloi, llama sapaktani.” nirim. Akili Juda-yambumanga ungna te. Akiliinga pulele i-sipa mele: “Nanga Pulu Yili, nanga Pulu Yili, na nambimuna munduku kelkunuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Akuna nondupa yambu angiliiringmanga mare-ni yu-ni aku-sipa nirim mele piliiku ⸤sunduku kene⸥ niku mele: “Piliai. Yu-ni Illaija walsikim.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aku-sipa nirim kene piliiringmanga yi te enaliinga lkisipa pupa ulu-pinja mele te liipa no-waen kumbili tili mare kene akuna panjipa kene, ‘Yesos no-waen kanili nupili.’ nimba memba omba unji-mumú tenga ka topa monjupa sirim. ");
INSERT INTO mux_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","⸤Akiliinga-pe yunu no-waenele sirim mele kanuku kene⸥ we-yambuma-ni niku mele: “Mólu. Ekupu unji-perana we pípili. Illaija-ni sika yu ‘Naa kulupili.’ nimba tepa liipa mania liimbandu okumunje, kanupu kanamili.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesos-ni ung te tondulu nangale topa nimba kene, penga yunga mulungale-ndu ‘Pui.’ nimba yu kulurum. ");
INSERT INTO mux_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yu aku-sipa kulurum kene ⸤ulu-auli mare⸥ walsekale ⸤wendu urum.⸥ Pulu Yili popu toku kaluring lku-temboll ⸤Jerusallem sukundu angiliirim akuna sukundu Pulu Yili mulurum⸥ Sulumina Aima Kake Tilieliinga keri-puluna ⸤‘Yambuma sukundu naa pangi.’ niku ui taki-taki⸥ mulumbale auli te-ni pipi siku panjiring pirim. ⸤Yesos kolupa pora sirim kene⸥ mulumbale kanili ai-suku-singina olakundu mandu-sipa olá topa ulsu purum. ⸤Aku-sipa tepa,⸥ ma jim-jim te tepa, ku-mulú aulima topa ungku-mangku topa, ");
INSERT INTO mux_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","yambu ui ónu tiring koleama ungku-mangku topa anju-yandu pupa, Pulu Yili-nga yambu kake tili ui kuluringima ⸤Pulu Yili-ni⸥ topa makinjirim. ");
INSERT INTO mux_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Lomburuku ola molku ónu-koleana piringma wendu oku kene, Yesos penga lomburupa ola mulurum kene Pulu Yili-nga kolea-auli kake tílina sukundu puku yambu pulele ‘Kanangi.’ niku puring. ");
INSERT INTO mux_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","⸤Rom⸥ ami-yi wan-andret nukurum yili kene, yu-kene wasie Yesos tirim mele tápu-teku nokuku muluring ami-yima kene, enini pali ma jim-jim tepa ulu lupa-lupama wendu urum mele kanuku kene enini aima mini-wale munduku kene niku mele: “Yi ili yu aima sika Pulu Yili-nga Málale lam.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ambu pulele mele, ⸤Yesos unji-perana kulurum mele⸥ akuna sulu-tenjiku kanuku angiliiring. Ui ambu kanuma ⸤eninga pulu-⸥kolea Gallalli distrik munduku kelku Yesos lumbili anduku liiku tapunjuku nokuku ⸤Jerusallem wasie⸥ uring ambuma. ");
INSERT INTO mux_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eninga ambu te Makdalla-taon-na ambu Maria, te Jemis kene Joses-selenga anum Maria, te yi Seperi-nga málu-selenga anum. ");
INSERT INTO mux_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ipinjali, kolea kalá tomba tirim kene Arimatia taon-na yi, méle pulele nusurum yi-kamako te, yunga bili Josep, yunu kepe Yesos lumbili andurum yi te, yunu omba ");
INSERT INTO mux_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","⸤Rom-gapman yi-nuim⸥ Paillet mulurumna pupa, “Yesos-nga ónale na si.” nimba mawa tirim kene Paillet-ni yu “Ónale liipili.” nimba ⸤ami-yimandu nimba mundurum⸥. ");
INSERT INTO mux_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","⸤Paillet-ni “Kapula.” nirim kene⸥ Josep pupa ónale mania liipa, múlu kona te-ni liipa kumu turum. Kumu topa kene ");
INSERT INTO mux_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ku-muru kona te, Josep yunu ‘Kolumbu kene akuna ónu teangi.’ nimba ku-muru te ukupa nusurum ku-muru-lku kanuna sukundu memba pupa nusurum. Nosupa kene ku-muru keri-puluna ku-mulú auli te perele-marele memba omba pipi sipa kene yunu kelepa purum. ");
INSERT INTO mux_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdalla-taon-na ambu Maria kene Maria te kene elsele ku-murele lirim keri-puluna nondupa ⸤yunga ónale ku-muruna nusurum mele kanukulu⸥ muluringli. ");
INSERT INTO mux_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","⸤Kanu-kene,⸥ ‘Opali ⸤kóru mulúli ena-⸥ Sambatele.’ niku piliikulu kene, ekupu mele, mélema undu-undu siring ena kanili pora nirim-na opalikundu Pulu Yili popu tunjuring yi-aulima kene, Perisi-yima kene, enini ⸤Rom-gapman yi-nuim⸥ Paillet mulurumna puku liiku máku toku angiliiku kene ");
INSERT INTO mux_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","niku mele: “Yi-Auliele, yi kanili ui naa kolupa we molupa kene yambuma-ni ‘Sika’ niku piliingí ungma gólu topa nirim yi kanili yu “Kolupu kene ena yupuku omba pumba kene lomburupu ola molumbu.” nirim oliu piliirimuleliinga ");
INSERT INTO mux_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","⸤nu-ni ami-yimandu⸥ “Yi kanili ⸤bonongu⸥ ónu tíngi ku-murele ena yupuku aima mimi-siku nokai!” niani. Naa nukúngi lem yunga lumbili anduli yima-ni ónale oku wa liiku meku puku kene “Yu lomburupa ola molupa omba pumu.” ningí. Aku-siku gólu toku ningí yunu ui ‘ ‘Sika nikem.’ niangi.’ nimba gólu turum ungele mania-kilia, enini ‘Yambuma-ni ‘Yu-ni sika aku-sipa tímu.’ niangi.’ niku gólu tungí ungele aima ola pemba.” niring. ");
INSERT INTO mux_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paillet-ni ⸤Juda yi-aulimandu⸥ pundu topa nimba mele: “⸤Aku lem,⸥ ami-yi mare liiku meku puku, “Yili ónu tíngi koleale nokuku kaí teai.” niku monjuku, ‘Yambuma-ni ónu-koleale ulu te naa teangi.’ niku ‘Kupulanumele tondulu pipi samili.’ niku piliingí mele teai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","⸤Aku-sipa nirim-na⸥ piliiku kene ami-yi mare liiku meku puku, yambu-ónu-kolea ku-murele pipi siring kuli pala teku pelé leku eninga bili akuna toku monjuku kene, “Ami-yima akuna nokuku molai.” niku monjuku kene ⸤enini puring⸥. ");
INSERT INTO mux_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","⸤Kóru muluring⸥ ena-Sambatele pora nimba, eninga kumbi-lepa kongun enale wendu ombándu kolea tangumbandu muni lirim kene Makdalla-taon ambu Maria kene, Maria te kene, pukulu ⸤Yesos-nga⸥ ónale nusiring ku-muruna ⸤ónale⸥ kanunglí puringli. ");
INSERT INTO mux_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Auliele-nga mulú-koleana angkella te mana-mania urum kene male jim-jim aima tondulu lakupa tirim. Angkellale-ni omba ku-muruna pupa ku-muru keri-puléle pipi siring kuli wendu liipa perele-marele memba pupa nosupa akuna ola mulurum. ");
INSERT INTO mux_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angkella kaniliinga kumbi-kerale kariyapa tepa talang pulimú mele talang pupa, múlu pakurum-ma kalapera topa aima kake telemú mele kake tirim. ");
INSERT INTO mux_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Yesos-nga ónu-koleale nukuring ami-yima angkellale kanuku aima mini-wale munduku pung-pungu niku kene yambu kulúlima-ni ung naa niku ulu te naa telemele mele enini aku-siku ulu te naa teku we muluring. ");
INSERT INTO mux_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angkellale-ni ambuselendu nimba mele: “Mundu-mong naa teale. Yesos ‘Kulupili.’ niku talku unji-perana ⸤toku⸥ ku toku panjiring yi kanili kanunglí okumbele na piliiker. ");
INSERT INTO mux_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yu ya naa lelemú. ⸤“Kolupu kene ena yupuku-sipaliinga⸥ lomburupu ola molumbu.” ui nirim aku-mele tímu. Ónale ui lirim koleale okulu kanale. ");
INSERT INTO mux_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kanukulu kene wela lkisiku pukulu yunga lumbili andúlima i-siku nikulu sangli: “Yesos ónu-koleana lepa kene lomburupa ola molupa kolea Gallalli distrik-ndu kumbi-lepa pulimáliinga enini akuna yu kanungí.” niku sangli. ⸤Ung nimbu sinjimbúndu úndu⸥ ung kanili nimbu pora siker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","⸤Angkellale aku-sipa omba mokeringa molupa kene nirim mele⸥ kanuku piliikulu kene ambusele mundu-mong tenjikulu mundu-mong aima akukulu, aku-sipa numanu tale pípili ku-muruna ulsu pukulu munduku kelku lkisiku pukulu yunga lumbili andúlima niku singlí puringli. ");
INSERT INTO mux_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","⸤Lkisiku punglí puringli kene⸥ Yesos liipa sinjipa elsele kupulanum-na kanupa liipa kene “Okombeleye?” nirim. Kanu-kene elsele-ni yunga kimbukundu puku kanglkulu yu kape niku bi paka tunjuringli. ");
INSERT INTO mux_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kanu-kene Yesos-ni elselendu nimba mele: “Mundu-mong naa tekulu kene, else pukulu nanga anginipilimandu i-siku nikulu mele: “Kolea Gallallindu pai. Yu akuna kanungí.” ni-pale.” nirim. ");
INSERT INTO mux_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ambusele alsukulu yandu unglí uringli kene Yesos-nga ónu-koleale nukuring ami-yi mare kolea-auli ⸤Jerusallem⸥ suku puku Pulu Yili popu tunjuring yi-aulimandu uluma wendu urum mele pali temani toku si-puring. ");
INSERT INTO mux_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","⸤Piliiring kene⸥ popu tunjuring yi-aulima, Juda-yambumanga yi-aulima kene wasie máku toku kene enini-kene ⸤ung niku kene niku mele: “We-yambuma ulu ima wendu um mele piliiku kene “Yesos lomburupa ola mulumnje.” ningéliinga ‘Naa piliangi.’ nimbu nambulka teamilinje?” niku⸥ tombulku niku kene tingí mele niku panjiku kene, ami-yima ku-moni pulele siku kene ");
INSERT INTO mux_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","eninindu niku mele: “Yambuma-ni “Yesos nambulka tímuye?” niku walsingí kene enini i-siku mele niangi: “Sumbulsuli uru pímulu kene yunga lumbili andúlima-ni kiyang niku oku yu liiku meku púngi.” niai. ");
INSERT INTO mux_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","⸤Oliu Juda-yambuma nokulemú Rom-⸥gapman yi-nuimele-ni ⸤aku tíngi mele⸥ ung te pilíímu lem ‘ “Eni teku kis-sikimili akiliinga mindili nangi.” naa niangi!’ nimbu oliu-ni eninga tepu liipu yu-kene ung nimulú, kanu-kene ‘Eni ónu-koleale mimi-siku naa nokuku we uru ping.’ nimba piliipa kene mindili liipa naa simba.” niring. ");
INSERT INTO mux_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Aku niringeliinga piliiku kene ami-yima-ni ku-moni liiku enini “Niai.” niring mele yambumandu niring. Akiliinga yandupa ekupu ⸤buk tokur⸥ ena ili kepe Juda-yambumanga koleamanga pali ung ili anju-anju pulimú piliiku kene yambu pulele-ni temani kanili toku molemele. ");
INSERT INTO mux_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","⸤Ambusele pukulu kene kanukulu piliiringli mele temani toku siringli⸥ kene piliiku kene Yesos lumbili anduli yi rurepunga yupuku kolea Gallalli distrik puku, Yesos-ni ma-pangi te bi lepa ui “Akuna wangi.” nirim ma-pangina puring. ");
INSERT INTO mux_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akuna puku Yesos kanuku kene, yu kape niku yunga bili paka tunjuring akiliinga-pe mare-ni ‘Yesos kulurum. Ili Yesos mola naenje?’ niku numanu tale teku liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Kanu-kene Yesos yu nondupa omba eninindu nimba mele: “Tata-ni nandu “Nu-nunu mulú-koleana mélema kene yambuma kene, ma-koleana mélema kene yambuma kene nokani.” nimba tondulale na sirim, na-kene pelemú. ");
INSERT INTO mux_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","⸤Tondulu na sirim akili eni simbu eni-kene pemba⸥ akiliinga eni ma-koleamanga pali puku ‘Yambuma pali nanga ungele piliiku liiku, nanga lumbili andúlima molangi.’ niku, puku niku si-puku kene, ⸤piliiku liiku mulungí⸥ yambuma no liinjingíndu Lapale kene Málale kene Mini Kake Tiliele kene eninga bili walsiku enini no liinjiku, ");
INSERT INTO mux_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","eninindu “Na lumbili andúlima-ni teai.” nirindu mele pali ‘Yambu akuma teangi.’ niku enini ung-bo tonjuku mani sai. Aku-siku nilsiliiku anduku mulungí kene na eni-kene wasie taki-taki molambu mulú-masele pora nimbá.” nirim. ⸤Aku manda.⸥ ");
INSERT INTO mux_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesos, Pulu Yili-ni “Oliu nokupa konjumba yi te liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele, Pulu Yili-nga Málale, yunga temani-kaiéle pulu munjurum mele ⸤ya ilinga tombu tokur⸥. ");
INSERT INTO mux_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","⸤Yesos, Pulu Yili-ni makó turum yi-nuim Kraisele-nga temani-kaí ili wendu ombándu yi te ui omba temba mele⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni Pulu Yili-nga ung te nimba bukna turum akuna molemú mele i-sipa: ‘⸤Pulu Yili-ni nimba mele:⸥ “⸤Pília.⸥ Na-ni ‘ ‘Nanga ung “Ninjui!” nimbu, nimbu simbu ungma piliipa yandu nimba sipili.’ nimbu liipu mundumbu yili-ni nunga kupulanumele akisinjipili.’ nimbu yu “Kumbi-leku pui.” niker.’ ");
INSERT INTO mux_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Kolea-wakana ⸤kumbi-lepa pumba⸥ yi tenga kerina ung te nimba mele: “Auliele ombá kupulanumele teku mimi tenjai. Yu ombá kupulanum kelúma teku sumbi sai.” nimbá.” nikem.’ nimba ⸤Asaya-ni No-Liinjili Jon-ni aima penga temba mele ui aku-sipa nimba sipa bukna turum molemú.⸥ ");
INSERT INTO mux_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","5","Akiliinga, ⸤temani-kaiéle pulu monjumbandu No-Liinjili⸥ Jon kolea-wakana tenga-lupa wendu omba ⸤aku-sipa⸥ ung mare yambuma nimba sipa mulurum. Kolea Judia distrik yambuma pali kene kolea Judia-nga kolea-auli Jerusallem yambuma pali kene enini yu mulurumna puku yunga ungele piliingí puring. Yu-ni ung te eninindu nimba sipa kene nimba mele: “Eni ulu-pulu-kis telemelema kanuku kis piliiku numanu topele toku kene ‘Pulu Yili-ni oliunga ulu-pulu-kisma ‘We mania pupili.’ nimba kanupa konde tinjipili.’ niku ‘No liamili.’ niku wai.” nirim. Aku-sipa nirim kene eninga ulu-pulu-kis tiringma niku para siring kene yu-ni enini no-Jodan nona sukundu no liinjirim. ");
INSERT INTO mux_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon kung-kemelenga dili-ni tili wale-pakuli te pakupa, kung kiluele-ni tili kamirika te topa kene, kuli-kumba kene pillím-nóma kene ⸤langi⸥ akusele mindi nomba mulurum. ");
INSERT INTO mux_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","8","Yu-ni yambuma ung nimba sirim mele i-sipa: “Na-ni sika eni no liinjiliu akiliinga-pe yi te aelepa ombále-ni ⸤Pulu Yili-nga⸥ Mini Kake Tiliele eni liinjimba ⸤liingí⸥. Na-kene aelepa ombá yi ili yunga tondulale aima olandupa, nanga tondulale aima mania-kilia. Na yu-kene kapula mólu. Yambu aulimanga kongun kis tinjili kendemande-yambuma-ni sika eninga yambu aulimanga kongun kísma tinjingíndu mania molku eninga yambu aulimanga kimbu-suma ka silke tonjilimelaliinga-pe na yi aima kisele moliáliinga ombá niker yi kanili yunga kimbu-su ka silke tunjuli kongun kanili aima ola-kilia mele, na-ni kapula naa tenjilka. ⸤Na yi aima kisele, yu yi aima auliele.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","⸤Jon yambuma no liinjipa mulurum⸥ ena kaniliinga Yesos kolea Gallalli distrik Nasaret taon mundupa kelepa ⸤Jon mulurumna⸥ urum kene Jon-ni yu no Jodan nona sukundu no liinjirim. ");
INSERT INTO mux_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","⸤Yesos no liipa pora sipa kene⸥ nona wendu ombá urum kene enaliinga muléle takape nimba anju-yandu purum kanurum kene, Pulu Yili-nga Minéle, kera-waembonu mele, mania omba Yesos mulurumna pupa ⸤kangina⸥ ola mulurum kanurumko. ");
INSERT INTO mux_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kanu-kene mulúna ola ung te wendu omba kene nimba mele: “Nu nanga numanu monjuliu kangale. Nu-kene numanu siliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","⸤Yesos no liirim kene Pulu Yili-nga Minéle yu-kene omba molupa kene⸥ sumbi-sipa Minéle-ni Yesos kolea-wakana liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Akuna purum kene, kaliimbu te kóru tale Yesos kolea-waka akuna takara-mélema kene mulupili ⸤kurumanga nuim⸥ Seten omba yu kundi turum. Kanu-kene ⸤mulú-koleana⸥ angkellama oku Yesos nukuring. ");
INSERT INTO mux_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kanu-kene ⸤No-Liinjili⸥ Jon ka siku ka-lkuna panjiringele piliipa kene Yesos kelepa kolea Gallalli distrik omba Pulu Yili-nga temani-kaiéle topa silsiliipa andurum. ");
INSERT INTO mux_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","⸤Topa silsiliipa andupa kene⸥ nimba mele: “Ekupu enale kamu wendu okum, Pulu Yili yi nuim kingele molupa nokumba enale nondupa wendu okumaliinga ulu-pulu-kis telemelema munduku kelku numanu topele toku, ‘Temani-kaiéle sika-ungele.’ niku tondulu munduku piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","⸤Aku-sipa nilsiliipa andupa⸥ numú Gallalli kéluna andupa kene Yesos-ni Saimon kene Saimon angin Endru-sele oma liili wale te numúna toku suku mundukulu muluringli kanurum. Oma liiringli akili elsengla ku-moni kongun tiringli kanili. ");
INSERT INTO mux_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","⸤Aku-siku teku muluringli kanupa kene⸥ Yesos-ni elselendu nimba mele: “Na lumbili wale. Oma liinglíndu oma liili wale te liiku nona suku mundulimbili kene omama walena omba pelemú mele, penga ‘nanga kongunale tinglíndu nanga ungele piliikulu niku silsiliikulu andunglí kene yambuma nanga talapena sukundu oku molangi.’ nimbu ‘Else na lumbili wale.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","⸤Aku nirim-na piliikulu kene⸥ lkisikulu elsengla oma liili walema munduku kelkulu kene Yesos lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kanu-kene yu laye-kolte anju pupa kene, Seperi-nga málu Jemis kene angin Jon-sele elsengla nona anduli sipna sukundu molkulu oma liili walema toku tambulku muluringli kanupa kene ");
INSERT INTO mux_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","enaliinga elselendu “Wale.” nirim. Kanu-kene lapa Seperi kene kongun yima kene sipna sukundu molangi munduku kelkulu kene Yesos lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","⸤Yi kanuma Yesos lumbili puring kene⸥ yu-kene enini Kapeniam taon puring. Kanu-kene ⸤kóru muluring⸥ ena-Sambatele wendu urum kene Yesos Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkuna lkundu pupa yambuma ung-mani sipa ung-bo tunjurum. ");
INSERT INTO mux_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ung-mani sipa ung-bo tunjurum kene Pulu Yili-nga ung-manimanga puluma piliiku enini ung-bo tunjuring yima-ni we ung-bo tunjuring mele Yesos-ni aku-sipa ung-bo naa tunjurum. Namba lirim yima-ni mundu-mong naa teku tondulu munduku ung-bo tunjuring mele yu-ni aku-sipa mani sipa ung-bo tunjurumeliinga piliiku kene yambuma-ni mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kanu-kene lku kanuna suku kuru te yi tenga numanuna molupa yu ambulurum yi te mulurum, ⸤yilinga numanuna suku mulurum kuru kanili-ni yu “Ung ni.” nirim-na⸥ ");
INSERT INTO mux_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","yu-ni nangale topa kene nimba mele: “Nasaret taon yi Yesos, nu wasie oliu ⸤kuruma⸥-kene tiluna tapú-topu kapula naa molomulú. Nu oliu-kene nambimuna únuye? Nu oliu toku kunjini únuye? Na-ni nunga bili piliiliu. Nu Pulu Yili-nga Yi Kake Tiliele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","⸤Aku-sipa nirim-na piliipa kene⸥ Yesos-ni kuru kanili ung-mura sipa kene yunundu nimba mele: “Nu ung naa nikunu yilinga numanuna oku wendu pui.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","kurale-ni yili ambulupa tondulu mundupa kolkalu sipa kene ke nilsiliipa omba wendu purum. ");
INSERT INTO mux_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","⸤Yesos-ni akili tirim kanuku kene⸥ yambuma suru niku, mini-wale munduku eni-enini anju-yandu niku mele: “Ulu ili nambulka ulu te tekemunje? Ung kona te wendu okum lepam. Yi namba lili te-ni we-yambumandu “Teai.” nilimú mele yi ili-ni kurumandu kepe aku-sipa nilimú kene kuru kanuma yunga ungele piliiku liiku telemele.” niring. ");
INSERT INTO mux_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanu-kene kolea Gallalli distrik koleamanga pali yu-ni aku-sipa tirim mele temanele enaliinga anju-anju purum kene piliiku kapula tinjiring. ");
INSERT INTO mux_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kanu-kene ⸤Yesos kene yunga lumbili anduli yima kene⸥ enini máku toku Pulu Yili-nga ungele piliiring lku kanili munduku kelku wendu oku kene, Jemis Jon-sele kene wasie enini puku Saimon kene Enderu-selenga lkuna puring. ");
INSERT INTO mux_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lkuna lkundu puring kene Saimon-nga kolepa-ambale kuru topa kangi nurum-na lirimele Yesos niku siring. ");
INSERT INTO mux_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aku-siku niring piliipa kene ambale lirimna omba yunga kili ambulupa yu ola liirim kene kangi nurumele pora nirim, ambale-ni ⸤ola angiliipa wendu omba kene⸥ uring-yima langi sipa nukurum. ");
INSERT INTO mux_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Penga kolea ena pupa kalá turum kene, kuru turum yambuma kene, numanuna kuru mulurum yambuma kene, Yesos mulurumna meku uring. ");
INSERT INTO mux_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kolea kanuna muluring yambuma pali Saimon-nga lku-kirupuluna oku máku turing. ");
INSERT INTO mux_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Kanu-kene Yesos-ni yambu kuru lupa-lupa turum pulele tepa kaí tepa, yambumanga numanuna muluring kuru pulele topa makururumko. Kuruma-ni Yesos ⸤Pulu Yili-nga Málale, yu Pulu Yili-ni makó topa liipa mundurum yi-nuim Kraisele⸥ mulurum mele akili piliiringeliinga yu-ni eninindu “Moliu mele anju niku naa sai.” nimba eninga kerima pipi sirim. ");
INSERT INTO mux_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ulsulam-ui, kolea muni ui naa lipili sumbulú topa pípili Yesos ola molupa pena pupa kene, kolea-waka tenga pupa, akuna Pulu Yili-kene popu topa ung nimba mulurum. ");
INSERT INTO mux_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon kene wasie muluring yima kene enini yu korulsiliiku lumbili puku kene, ");
INSERT INTO mux_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","yu kanuku liiku kene yunundu niku mele: “Yambuma-ni pali nu koruku molemele.” niring. ");
INSERT INTO mux_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","⸤Aku-siku niring piliipa kene⸥ yu-ni eninindu nimba mele: “Na kolea marenga kepe ung nimbu sámbaliinga kolea ili mundupu kelepu kolea tenga-lupa pamili. Ne nondupa lelemú koleamanga pamili. Na koleamanga pali ung nimbu simbundu mana-mania urundu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Aku-sipa nimba kene yu kolea Gallalli distrik sukundu koleamanga pali andupa Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkumanga lkundu pupa ung nimba sipa, yambumanga numanuna kuru muluringma topa makururum. ");
INSERT INTO mux_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Walse yi te kuru-laká nomba pirimele Yesos mulurumna omba yunga kumbi-kerina koporungu langupa yu mawa tepa kene nimba mele: “Nunga numanale-ni ‘Nanga kangiele kaí lipili.’ nikunu pilíínu lem nu-ni na kapula tekunu kaí tiní.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kanu-kene Yesos-ni yunu aima kondu kolupa kene yunga kili-ni yili ambulupa kene yundu nimba mele: “‘Nunga kangiele kaí lipili.’ nimbu piliiker akiliinga kaí lipili.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","enaliinga kuru-lakále nomba kelepa, kangiele kaí lirim. ");
INSERT INTO mux_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Kanu-kene Yesos-ni yu ung te tondulu mundupa nimba mele: “Nu-ni ya ulu tekerale yambu tilurindu kepe aima naa ni! Sumbi-siku pukunu Pulu Yili popu tunjuli yili nunga kangiele liiku ora sikunu, ‘Nanga kangiele alsupa kaí lipili molkur akiliinga.’ nikunu Moses-ni “Ti.” nimba ung-mani sirimele piliiku liikunu tinindu “Pulu Yili popu toku kalku sai.” nirim mélale liikunu Pulu Yili popu tunjuli yilindu “Kalonjui.” nikunu yu sani. Pe yambuma-ni nu kanuku kene ‘Yu sika kangiele kaí lipili molemú.’ niku piliangi akiliinga niker mele isili-ui ti-pui.” nirim. ⸤“Aku-siku tiní kene yambuma-ni nu kanuku kis naa piliingí, nu alsuku we-yambuma molemelena kapula tiluna pukunu muluni.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Akiliinga-pe yili yunu anju pupa kene ung pulele yambu pulelendu anju-anju nimba silsiliipa andupa, Yesos-ni yu-kene tirim temanele topa sirim. Yili-ni aku tirimeliinga Yesos ⸤‘Yambu pulele na molumbuna nondupa-nondupa oku máku naa tangi.’ nimba⸥ alsupa taon-manga sukundu mokeringa kapula naa andumbaliinga kolea-wakana mulurum, akiliinga-pe kanuna yambu pulele kolea lupa-lupamanga molku sukundu-sukundu oku yu mulurumna máku turing. ");
INSERT INTO mux_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ena mare omba purum kene Yesos Kapeniam taon alsupa sukundu purum. Yu ui pirim lkuna alsupa omba mulurum akili yambuma-ni piliiku kene ");
INSERT INTO mux_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","yambu pulele oku lkuna lkundu-lkundu oku liiku máku toku muluring kene lku kanili si nirimeliinga yambu mare mulungí kolea te naa lirim-na pena muluringko. Yu-ni enini ⸤Pulu Yili-nga⸥ ungele nimba sipa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","⸤Yu-ni nirim mele aku-siku máku toku piliiku molangi⸥ yi angere-ni kimbu-kima kolupa pora sirim yi te taropola teku meku Yesos mulurumna meku ungí uring akiliinga-pe ");
INSERT INTO mux_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","yambu pulele lkuna si nimba peka topa mulurum akiliinga yu mulurumna nondupa meku pungí kupulanum te naa lirimeliinga lku imuna meku ola puku kene Yesos mulurumna kuni lkuli tekisiku kene yili taropola pali moku toku mania munduring. ");
INSERT INTO mux_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","‘Yesos-ni yi ili kapula tepa kaí temba.’ niku tondulu munduku piliiku kene yu meku uring mele kanupa piliipa kene Yesos-ni kimbu-ki kolupa pora sirim yilindu nimba mele: “Nanga kangale, nunga numanuna ulu-pulu-kis tirinu pelemúma mania pupili, we kanupu konde tenjikur.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","⸤Kanu-kene,⸥ Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare enini akuna molku ⸤Yesos-ni aku nirim-na piliiku kene piliiku kis piliiku⸥ numanu kimbú siku kene, “Nindi yili-ni ung aku-sipa nambimuna nikemye? Yu Pulu Yili marake tekem. Yambuma-ni ulu-pulu-kis telemelema nae-ni ‘Mania pupili, kanupu konde tenjikur.’ kapula nimbáye? Pulu Yili-ni mindi kapula telemú.” niku enini niku piliiku molku numanu kimbú siring. ");
INSERT INTO mux_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kanu-kene Yesos-ni enini aku-siku numanu kimbú siku muluring akili yunga numanale-ni sumbi-sipa piliipa kene eninindu nimba mele: “Eni ⸤na-ni nikereliinga⸥ aku-siku nambimuna numanu kimbú sikimiliye? ");
INSERT INTO mux_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yi ilindu “Nunga ulu-pulu-kisma mania pupili, we kanupu konde tenjikur.” nimbú kene eni ulu te naa kanuku kene ‘We-we tepa nikem.’ niku piliingíye? Mola “Ola angiliikunu nunga kunungele liiku mekunu kimbu kambiliikunu andui.” nimbú kene yu ola angiliimbanje mola naa angiliimbanje mokeringa lemba kapula kanuku kene ‘Aku-sipa mindili sipa nikem-nje?’ niku piliingíye? ");
INSERT INTO mux_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Akiliinga-pe ‘ ‘Mania Omba Mana-Yi Au Talurum Yili tondulu pelemále-ni ya ma-koleana yambumanga ulu-pulu-kisma “Mania pupili, we kanupu konde tenjikur.” kapula nimbá.’ niku piliangi.’ nimbu aku-sipu nindu.” nirim. Aku nimba kene kimbu-kima kolupa pora sili yilindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na-ni ‘Nu ola angiliikunu nunga kunungele liiku mekunu lkundu pui.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Aku nirim kene yili ola angiliipa enaliinga kunungele liipa memba, yambuma pali kanuku molangi omba pena purum. Yu aku tirim kanuku kene enini suru niku mini-wale munduku kene Pulu Yili-nga bi paka tonjuku yu kape niku kene niku mele: “Oliu ulu wendu okum kanokumulu mele ili ui walse kepe ulu te aku-sipu aima naa kanurumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesos ⸤lkuli mundupa kelepa⸥ pena pupa kene alsupa numú Gallalli kéluna omba andupa mulurum. Kanu-kene yu mulurumna yambu pulele oku liiku máku toku muluring akiliinga yu-ni enini mani sirim. ");
INSERT INTO mux_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kanu-kene yu pumba pupa kene, Allapias-málu LLipai ku-moni-takis liiring lkuna ⸤ku-takis liipa⸥ mulurum kanupa kene yunundu “Na-kene wasie pambili lumbili ui.” nirim. Kanu-kene LLipai yu ola angiliipa yu lumbili purum. ");
INSERT INTO mux_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pe Yesos LLipai-nga lkuna langi nomba mulurum kene ku-takis liili yima kene, ⸤Juda yi aulima-ni⸥ “ulu-pulu-kisma tili yi” ⸤niring⸥ yi wema kene pulele oku Yesos kene yunga lumbili anduli yima kene enini wasie mania molku langi nuring. Aku-sili yambu pulele taki-taki yu lumbili anduringeliinga enini pulele ⸤akuna lumbili puku⸥ wasie langi noku muluring. ");
INSERT INTO mux_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Yesos yu “ulu-pulu-kis tílima” niring yambu wema kene ku-takis liili yima kene wasie langi noku muluring kanuku kene Perisi-yi mare-ni, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma-ni, Yesos lumbili andúlimandu niku mele: “Ku-takis liili yima kene, ulu-pulu-kisma tili yima kene, enini-kene yu nambimuna langi wasie nokomeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aku-siku niring piliipa kene Yesos-ni eninindu ⸤ung-eku topa kene⸥ nimba mele: “Kuru naa tolemú yambuma doktana naa pulimelé. Kuru tolemú yambuma mindi doktana pulimelé kanili. Na-ni “Yambu sumbi nílima na molumbuna wangi.” nimbúndu naa urundu. “Ulu-pulu-kis tili yambuma na molumbuna wangi.” nimbúndu urundu. Ulu-pulu-kis tili yambuma liipu tapunjupu tepu liimbundu urundu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","⸤No-Liinjili⸥ Jon lumbili anduring yima kene, Perisi yima lumbili anduringima kene, enini ena marenga langi mi toku naa nuring mele walse aku-siku teku muluringko. ⸤Aku tiringeliinga⸥ yambu mare Yesos mulurumna oku yu walsiku piliiku kene niku mele: “Jon lumbili andúlima kene, Perisi-yima lumbili andúlima kene, taki-taki langi mi toku naa nolemele akiliinga-pe nu lumbili anduli yima aku-siku naa telemele akili nambimuna naa telemeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","⸤Aku-siku niring-na piliipa kene⸥ Yesos-ni pundu topa eninindu ⸤ung-eku te topa yu toku kunjingí kolumbaliinga ung te nimba kene⸥ nimba mele: “Ambu liimba yi te yunga pulu lelemú yima kene molemú kene enini numanu siku kene “Langi mi topu naa namili.” kapula ningíye? Kapula naa ningí. ");
INSERT INTO mux_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Penga ambu liimba yili enini mulungína oku wendu liingí kene ena kanumanga mindi sika ⸤numanu kis panjiku⸥ langi naa nungíndu mi tungí. ⸤Isili-ui mólu.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Mulumbale-ui te sungu nilimú kene oliu-ni mulumbale aima kona tenga te kopsipu liipu, sungu nilimúna naa topu tambululimulu kanili. Yambu te-ni aku-sipa topa tambulkanje mulumbale kanili nona panjilka kene mulumbale kona kupsiliele wallú pupa tang tepa kene mulumbale-uiele alsupa kamu lakupa sungu nilka. ");
INSERT INTO mux_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kung-memi kangiele-ni tili mingi-ukundu tenga no-waen kona naa-ko kolemulu kanili. Yambu te-ni mingi-ukundu tenga no-waen kona te kolkanje no-waen kanili mingina sukundu molupa kene penga akolka kene mingi-ukundu kanili naa akopa sungu nilka. Kanu-kene nole kepe mingele kepe kamu kis lelka. Akiliinga no-waen kona kung-memi kangiele-ni tili mingi kona-na mindi kolemulu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Walse, ⸤kóru muluring⸥ ena-Sambat tenga, Yesos kene yunga lumbili andúlima kene rais-wit puniemanga oku puring kene yunga lumbili anduli yima-ni rais-wit mong mare ⸤nungíndu⸥ lkering. ");
INSERT INTO mux_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aku-siku tiring kanuku kene Perisi yima-ni Yesos-ndu niku mele: “Kána! ⸤Kóru molemulu⸥ ena-Sambateliinga ‘Kongun naa teangi.’ nimba molemú ung-manele nambimuna nunga lumbili anduli yima-ni ung-manele toku pula toku kene aku-siku tekemeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesos-ni pundu topa nimba mele: “Eni Pulu Yili-nga bukna sukundu ⸤anda-kolepa yi nuim king⸥ Depit-ni tirim mele nimba molemú temanele kanuku kene ⸤temaneliinga pulele⸥ naa piliilimiliye? Depit kene yu wasie puring yima kene enini ⸤langi⸥ mólu turum ⸤akiliinga⸥ engle-ni kolku kene, ");
INSERT INTO mux_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pulu Yili popu tunjuring yi auli olandupa Apayata mulupili Depit Pulu Yili mulurum sell-lkuna lkundu pupa, Pulu Yili-nga kumbi-kerina lirim pllawa kalúlima liipa nomba, yu wasie puring yima sirim nuringko kanili. Pllawa kaluli kanumandu Pulu Yili-ni ung-mani sipa kene nimba mele: “We-yambuma-ni aima naa nangi! Pulu Yili popu tunjuli yima mindi nangi!” nirim ⸤ung-mani kanili topa pula turum⸥ kanili. ⸤Eni numanu tale nambimuna piliilimiliye? Depit yu-ni ui akili tirim mele enini piliiku kis naa piliilimiláliinga, pe ekupu na lumbili anduli yima-ni tekemele mele kanuku kis naa-ko piliai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Aku-sipa nimba kene ung te wasie nimba mele: “Pulu Yili-ni ‘Yambuma molku konjangi.’ nimba ⸤kóru mulungí⸥ ena-Sambatele liipa yambuma-enini sirim kanili. ‘Sambat-enale pepa kunjupili.’ nimba yambuma liipa Sambat-enale naa sirim. ");
INSERT INTO mux_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Akiliinga Sambat-enale kepe Mania Omba Mana-Yi Au Talurum Yili nokulemú yili molemú-na ⸤Sambat-enale kene yambuma molku kunjingíndu tingí mele kapula nimbá kanili⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pe walse Yesos pupa Juda-yambuma máku toku Pulu Yili-nga ung piliiring lku tenga purum. Lku kanuna yi te mulurum, yunga ki te kamu kolupa kukurum. ");
INSERT INTO mux_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kanu-kene akuna muluring yi mare-ni ‘Yesos-ni ulu te tepa kis-simba kene yu kot tenjimulú.’ niku ulu mare ⸤taki-taki koruku molku kene⸥ ‘⸤Kóru molemulu⸥ kongun-Sambat kene yu-ni yili tepa kaí tembanje kanamili.’ niku yu mimi-siku kanuku muluring. ");
INSERT INTO mux_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesos-ni kima kolupa kukurum yi kanilindu nimba mele: “Yambuma molemelena oku ola angiliui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kanu-kene yimandu nimba mele: “Kongun-Sambat kene ulu nambulka ulu te kapula temulúye? ‘Sambat enaliinga ung-manele-ni “Teai.” nilimú mele teamili.’ nimbu yambuma liipu tapunjumulú kene kapula mola tepu kis-simulú kene kapulaye? ‘Naa kolangi kona pangi.’ nimbu temulále kapula mola topu konjumulále kapulaye?” nimba walsurum kene piliikuliinga enini ung te pundu toku naa niku we muluring. ");
INSERT INTO mux_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yu-ni enini nem-nemi nimba kanupa kene arerembi kolupa enini yili kondu naa kuluring kanupa kene lakupa numanu buni liipa kene ki kolupa kukurum yilindu nimba mele: “Nunga kili sunu si.” nirim kanu-kene yili-ni yunga kili sunu sirim kene ki kolupa kukurumele alsupa kam-kamu kaí lirim. ");
INSERT INTO mux_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","⸤Yesos-ni aku tirim-na kanuku kene⸥ Perisi-yima pena puku, enini kene yi nuim king Erot-nga talapena yima kene máku toku “Yu nambi-sipu topu konjumulúye?” niku kupulanum te kururing. ");
INSERT INTO mux_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesos kene yu lumbili andúlima kene enini numú Gallalli puring kene yambu aima pulele lumbili puringko. Kolea Gallalli distrik yambuma kene, Judia distrik yambuma kene, kolea-auli Jerusallem yambuma kene, Idumia distrik yambuma kene, no Jodan nekendu lelemú koleamanga yambuma kene, kolea-auli Taya kene Saidon-sele lirim koleamanga yambuma kene, kolea akumanga muluring yambu aima pulele Yesos uluma tepa mulurum mele piliiku kene yu mulurumna uring. ");
INSERT INTO mux_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Yesos-ni yambu pulele tepa kaí tirim kilia yambu kuru lupa-lupa turumuma-ni ‘Yu ambolamili.’ niku yu angiliirimna nondupa pungíndu si-si siring kilia Yesos-ni yunga lumbili andúlimandu nimba mele: “Yambu aima pulele oku molemele. Yambuma na molumbuna nondupa oku si naa sangi akiliinga nona andolemú sip te nondupa meku oku nosangi. Na molumbuna yambuma nondupa oku si singí kene sipna sukundu pumbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","⸤Yambumanga numanuna⸥ kuru muluringma-ni yunu kanuku kene taki-taki koporungu languku tondulu nangale toku kene niku mele: “Nu Pulu Yili-nga Málale.” niring, ");
INSERT INTO mux_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","akiliinga-pe Yesos-ni eninindu nimba mele: “Yu ⸤sika⸥ molemú akili ⸤yambuma-ni naa piliangi akiliinga⸥ aima naa niku para sai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","⸤Penga walse⸥ Yesos yunu ma-pangi tenga ola pupa kene ‘yu-yunu kene wasie tapú-topu molamili.’ nimba piliirim yimandu “Wai.” nirim kanu-kene yu mulurumna uring. ");
INSERT INTO mux_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Uring yimanga yi engkaki-rurepu liipa, yu kene wasie tapú-toku molku, “Enini nanga kongunale tenji-pangi liipu mundumbu yima molangi.” nimba enini makó turum. ‘Enini koleamanga anduku Pulu Yili-nga temani kaiéle toku si-pukuliinga, yambumanga numanuna kuru molombama toku makurungí tondulale enini-kene pembaliinga anduku toku makurangi liipu mundumbu.’ nimba yi rurepu kanumandu aku-sipa makó turum. ");
INSERT INTO mux_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yi rurepu makó turum kanumanga bima i-sipa mele: Saimon (yunga bi te Pita) yunu kene, ");
INSERT INTO mux_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Seperi málu Jemis kene, Jemis angin Jon kene, (elsele bi te Boanakes sirimuko. Boanakes yunga ung-pulele Mulú Túlieliinga Málu-sele), elsele kene, ");
INSERT INTO mux_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","⸤Pita angin⸥ Endru kene, Pillip kene, Batollomiu kene, Matyu kene, Tomas kene, Alpias-nga málu Jemis kene, Tadias kene, “Oliu Juda-yambuma oliuliu gapman molamili.” niring talape-yi Saimon kene, ");
INSERT INTO mux_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas-Iskeriot, Yesos penga liipa ele-túma sirim yili kene, ⸤yi akuma ‘yunga kongunale tenji-pangi liipu mundumbu.’ nimba makó turum yima⸥. ");
INSERT INTO mux_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kanu-kene Yesos kene yunga lumbili andúlima kene enini lku tenga lkundu puring kene yambu pulele akuna oku liiku máku toku muluring akiliinga enini langi nungí ena-mong te kepe aima naa lirim. ");
INSERT INTO mux_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kanu-kene Yesos-nga memi-tilu yambuma ⸤Yesos-ni aku-sipa tirim mele⸥ piliiku kene “Kangale aima kelep tum.” niku yunu liingí uring. ");
INSERT INTO mux_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare Jerusallem molku uring yi kanuma-ni niku mele: “Kurumanga nuim Belsipull Yesos-nga numanuna molupa kene yunu tondulu silimú-na mindi yu-ni kuruma topa makorolemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aku-siku niring piliipa kene ⸤Yesos Seten-kene ele-tu yisele muluringlieliinga ‘Seten-ni yu naa liipa tapunjulka aima mólu!’ nimba⸥ Yesos-ni eninindu “Wai.” nimba kene eninindu ung-eku topa nimba mele: “Seten-ni Seten yunu nambi-sipa topa makurumbaye? ");
INSERT INTO mux_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yambu-talape te numanu tiluna naa pupili molku suku-singina oe panjiku eni-enini ele teku lupa-lupa molemele kene talape kanili pora nilimú. ");
INSERT INTO mux_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","⸤Mola⸥ lku tiluna pelemelé yambuma numanu tiluna pupili naa molku eni-enini ele telemele kene yambu-talape kanili sungu siku lupa-lupa molemele. ");
INSERT INTO mux_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aku-sipako, Seten-ni yunga kuru te makurulkanje aku-sipako telkaliinga yunga talapele kene ele akili telka. Pe yunga talapele kapula naa molkemela. Pora nilka. ");
INSERT INTO mux_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Yi tondulu puli te-ni yunga lkuli nokupa konjulimú kene yi te-ni we kapula lkundu omba mélema wa liipa memba pulimúye? Akili kapula mólu. Ui wa nuli yili-ni yi tondulu pulieliinga kimbu kima ka sipa nosupa kene penga yunga lkuna kapula omba mélema wa liilimú kanili. ");
INSERT INTO mux_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“⸤Akiliinga⸥ na-ni enindu aima sika nimbu siker: “Yambuma-ni ulu-pulu-kisma teku ⸤Pulu Yili⸥ ung-taka tonjuku niku kis-silimele uluma kene, eninga ulu-pulu-kis wema kene pali ⸤Pulu Yili-ni⸥ ‘Mania pupili.’ nimba kanupa konde tenjimba. ");
INSERT INTO mux_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Akiliinga-pe yambu te-ni Mini Kake Tiliele ung-taka tonjupa, nimba kis-sipa, marake telemú yambale yu Pulu Yili-ni aku-sipa ulu-pulu-kis telemúma ‘Mania naa pupili.’ nimba aima kanupa konde naa tenjimba. ‘Taki-taki pepa mindi pupili.’ nimbá.” niker.” ⸤nimba Yesos-ni⸥ nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Enini “Yu kuru te yunga numanuna molemú.” niringele ⸤aku-siku Mini Kake Tiliele niku kis-siringeliinga piliipa kene⸥ Yesos-ni eninindu aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kanu-kene yambu pulele mania ⸤molku⸥ Yesos-ni ⸤ung-bo tonjupa mani sirim ungma piliiku⸥ muluring kene yunga anum kene anginipili kene yu-kene ung ningíndu oku pena angiliiku “Yu-kene ung niamili upili.” niku, niku munduring kene yambuma-ni yunundu niku mele: “Aminie kene angenali kene nu-kene ung ningíndu oku pena angiliimili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesos-ni eninindu pundu topa ⸤ung-eku topa kene⸥ nimba mele: “Nanga anum naeye? Nanga anginipili nameléye?” nimba kene, ");
INSERT INTO mux_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","yunga ungele mania molku ung piliiku muluring yambuma nem-nemi nimba kanupa kene nimba mele: “Yambu ima nanga anum kene nanga anginipili kene molemele. ");
INSERT INTO mux_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pulu Yili-ni “Teai” nilimú mele akili piliiku liiku telemele yambuma nanga anum kene nanga anginipili kene nanga kimulupili kene molemeláliinga aku-sipu niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Walse Yesos alsupa no-numú ⸤Gallalli⸥ kéluna pupa yambuma ung-bo tonjupa mani sipa mulurum kene yambu aima pulele yu mulurumna oku máku toku muluringeliinga nona andolemú sip te nona ola lirim-na sukundu pupa mania mulurum, yambuma no-numú kéluna angiliiring. ");
INSERT INTO mux_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Yu-ni eninindu ung-mani pulele nimba simbandu ung-eku talse turum. ‘Enini ung-mani sambu.’ nimba kene Yesos-ni ung-eku te i-sipa topa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Piliai. “Yi te-ni rais-wit boma puniena andupa tanda sirim. ");
INSERT INTO mux_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tanda silsiliipa andurum kene bo mare kupulanum-na mania purum, kanuma kerama-ni oku liiku nuring. ");
INSERT INTO mux_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bo mare ku pirimna mania pupa kene ma laye-sele mindi lirimeliinga nondupa mulie topa ola urum. ");
INSERT INTO mux_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Akiliinga-pe pulkanu naa mundurumeliinga ena tirim kene kanuma kulurum. ");
INSERT INTO mux_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bo mare kumbulu-sirkambu mele mulurumna mania purum, kumbulu-sirkambu melale ola omba wit-boma topa nurumeliinga omba kaí naa tepa mong te naa turum. ");
INSERT INTO mux_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Bo mare ma kaína mania purum-ma ola lakupa omba okukú tepa kene mong kaíma turum. Mare mong tokapu-tilu mele topa, mare mong tokapu-yupuku mele topa, mare tokapu-angere mele turum.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aku-sipa nimba kene “Yambu kum-peú lelemúma-ni ung ili piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Penga we-yambuma pali puring kene yu lumbili anduli yi engkaki-rurepu kene yambu mare kene yu-wasie muluringma kene, enini yu walsiku kene niku mele: “Nu yambumandu ung te niníndu nambimuna ung-eku tolluye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Yu-ni eninindu pundu topa nimba mele: “Pulu Yili yi nuim kingele molupa yambuma kene mélema kene nokulemáliinga ulu-pulu ui yunu piliirim ulu-pulu kanuma ‘Ekupu eni ⸤na lumbili olemele yambuma⸥ piliangi.’ nimba kene eni nimba sikem. Akiliinga-pe ulsu molemele yambuma ungma nimbu simbundu ung-eku mindi topu siliu. ⸤Pulu Yili-ni Asayanga kerina nimba mele:⸥ ‘Enini mongale-ni kanuku kene kanuku bi naa silimele; kumele-ni piliiku kene piliiku bi naa silimele. Numanale-ni piliiku kene numanu topele tolkemelanje ⸤Pulu Yili-ni⸥ eninga ulu-pulu-kisma ‘Mania pupili.’ nimba kanupa konde tenjilka.’ ⸤nirim⸥ akiliinga we-yambumandu ung-ekuma mindi toliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aku-sipa nimba kene Yesos-ni eninindu kelepa nimba mele: “Ung-eku topu nindu kaniliinga ung-pulele naa piliilimiliye? Akili naa piliiku kene ung-eku wemanga pali ung-puluma nambi-siku piliingíye? ⸤Ung-ekaliinga pulele i-sipa:⸥ ");
INSERT INTO mux_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Langi-bo tanda sirim yili-ni tanda sirim langi-boma ⸤Pulu Yili-nga⸥ ungele. ");
INSERT INTO mux_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Langi-bo mare tanda sirim-ma kupulanum-na mania purum kanuma yambu mare aku-siku mele molemele. Enini ungele piliilimili kene penga ⸤kurumanga nuim⸥ Seten-ni sumbi-sipa omba ung tanda sili numanuna omba pelemúma wendu liilimú. ");
INSERT INTO mux_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aku-sipako, bo mare tanda sirim-ma ku pirimna mania purum kanuma yambu mare aku-siku mele molemele. Enini ungele piliiku kene walsekale sumbi-siku numanu siku piliiku liilimele. ");
INSERT INTO mux_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Akiliinga-pe enini pulkanu naa munduku kene ungele layesele mindi piliiku molemele. Pe enini numanuna buni telemú kene, mola enini ⸤Pulu Yili-nga⸥ ungele piliiku liiku molemele mele yambu lupama-ni kanuku kis piliiku kene ung-taka tonjuku teku kis-siku mindili silimele kene eninga piliilimili ungma munduku kelelemele. ");
INSERT INTO mux_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Langi-bo mare tanda sirim kene kumbulu-sirkambu mele pirimna mania purum kanuma, yambu mare kepe aku-sili mele molemele. Enini ungele piliilimiláliinga-pe numanuna buni telemú bunima kene, méle pulele nosuku kene ‘Méle akuma-ni oliu liipa tapunjilimú tapunjumba.’ niku piliiku molemele uluma kene, ‘Méle pulele nosulkumulánje kapula.’ niku waka kolku ‘liamili.’ niku piliiku ulu mare kene, aku-sili ulu mare wendu omba ung kanili topa nolemú kene ungele-ni ulu te naa tepa langi mong naa tolemú. ");
INSERT INTO mux_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Langi-bo mare tanda sirim-ma ma kaína mania purum kanuma, yambu mare aku-siku mele molemele. Enini ungele piliiku kene ung-pulele piliiku kongnjuku ungele kamu piliiku liilimele. Pe enini langi-mong mele tolemele. Yambu mare kanumanga langi-mong tokapu-tilu mele topa, yambu marenga mong tokapu-yupuku mele topa, marenga mong tokapu-angere mele topa, aku-sipa tolemú. ⸤Ung-ekaliinga ung-pulele aku-sipa.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","⸤Aku-sipa nimba kene ung-eku te kene wasie topa⸥ nimba mele: “Yambuma-ni tepi-llam kanduku kene mingina sukundu panjilimeleye? Mola polu maniakundu nosulimeleye? ⸤Mólu. ‘Kolea pa tipili, kolea kepe mélema kepe kanamili.’ niku⸥ polu tenga ola nosulimele kanili. ");
INSERT INTO mux_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aku-sipa mele, ekupu mo tolemú mélema penga walse mokeringa lemba yambuma kanungí; ekupu panda topa lelemú mélema penga walse ⸤pa temba kene⸥ yambuma-ni méle kanuma kanuku bi singí. ");
INSERT INTO mux_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yambu kum-peú lelemúma-ni ⸤ung niker ili⸥ piliai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Eni ung piliilimili akili mimi-siku piliai. Eni ⸤ung⸥ma yambuma niku silimele mele ⸤Pulu Yili-ni⸥ eni aku-sipa mele simba. Mare lakupa simbako. ");
INSERT INTO mux_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","⸤Ung⸥ ma piliipa liipa molemú yambale na-ni ⸤ung⸥ mare wasie simbu, yu aima piliipa liimba. Akiliinga-pe ⸤ung⸥ ma naa piliipa liilimú yambale yu piliilimú ⸤ung⸥ma kepe kamu wendu liimbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesos-ni ung te kene wasie nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili i-sipa mele: “Yi te-ni langi-bo mana tanda silimú. ");
INSERT INTO mux_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yi akili sumbulsuli uru pepa, tanguli ola molupa ⸤andupa kongun tepa⸥, telemú kene langi-bo tanda silimúma mulie topa omba ai lelemú akiliinga-pe aku-sipa telemáliinga pulele yili-ni naa kanupa piliilimú. ");
INSERT INTO mux_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Langi-bo tolemúma male-ni yunu ‘ola upili.’ nilimú. Ui kumbi-lepa mulie tolemú. Pe gomú tolemú. Penga langi-mong tolemú. ");
INSERT INTO mux_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Penga langi tepa tolemú kene ‘Langi lkepu sukundu-sukundu liimbu enale wendu okum.’ nimba kene langi-bo tolemú yili-ni langi lkelemú. ⸤Pulu Yili yi nuim kingele molupa yambuma nokulemále aku-sipa.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Pe Yesos-ni eninindu alsupa nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili nambulka méle te mele so liinjipu niambuye? ‘Yu kingele molupa yambuma nokulemú mele piliangi nimbu sambu.’ nimbu kene nambulka ung-ekale topu niambuye?” ⸤nimba kene, alsupa ung-eku te wasie topa kene nimba mele:⸥ ");
INSERT INTO mux_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","“⸤Pulu Yili yi nuim kingele molupa yambuma nokulemú⸥ akili unji-mastet bo mele. Yambuma langi-bo puniena mundulimelemanga pali unji-mastet bole aima kelú wallú mele. ");
INSERT INTO mux_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Akiliinga-pe puniena mundulimele kene ola omba ai lelemú kene puniena molemú mélemanga pali yunu aima auliele. Kamu ai lepa unji mele angiliimú kene kerama unji-pola kanumanga oku pelemelé. ⸤Pulu Yili yi nuim kingele molupa yambuma nokulemú mele aku-sipa⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesos-ni ungma yambuma nimba simbandu ung-eku pulele aku-sipama topa sirim. Enini kapula piliingí mele topa sirim. ");
INSERT INTO mux_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enini ung te nimba simbandu ung-eku mindi turum. ⸤Ung te sumbi-sipa naa nimba sirim.⸥ Akiliinga-pe yu kene yu lumbili andúlima kene eni-enini muluring kene yu-ni yunga ungmanga puluma pali enini sumbi-sipa nimba para sirim. ");
INSERT INTO mux_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ena kanuna kolea kalá turum kilia Yesos-ni yu lumbili anduli yimandu nimba mele: “No-numúna nekendu pamulu.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","nona anduli sip tenga Yesos ui sukundu molupa kene ungma nirim akuna suku yu we mulupili numú-kéluna máku toku muluring yambuma munduku kelku yunu meku puring. Sipna puring kene sip mare wasie puringko. ");
INSERT INTO mux_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Kanu-kene, ⸤no-numúna pungí puring kene⸥ popuremi aima auli te no-numúna turum. Aku tirim kilia numéle apsipa kolsapia topa ola omba kene no sipna sukundu-sukundu omba peka topa kene sipele memba nona mania pumba tirim, ");
INSERT INTO mux_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","akiliinga-pe Yesos sipeliinga bulkundu wale te kilianda topa we uru mindi pirim. Yu lumbili anduli yima-ni yu toku makinjiku kene niku mele: “Ung-Bo Tunjuliele, oliu no wangupu kolumuláliinga nu mini-wale naa pukumuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yu makiliipa kene popuremale ung-mura sipa numelendu nimba mele: “Táka-nikunu mului!” nirim kene popuremale topa kelepa numéle lope naa tepa aima we lirim. ");
INSERT INTO mux_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanu-kene yu-ni lumbili andúlimandu nimba mele: “Eni nambimuna mini-wale mundukumiliye? ⸤Teliu mele wale pulele kanolemele kaniliinga-pe⸥ yandupa ekupu kepe ‘Oliu nokumba.’ niku tondulu munduku naa piliilimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","⸤Yu-ni tirim mele kanuku kene⸥ yima-ni mini-wale munduku mundu-mong lakuku teku kene anju-yandu eni-enini tombulku kene niku mele: “Apa! Yi ili naenje? Popuremale-ni kepe no-numéle-ni kepe yunga ungele piliiku liiku kelkembele.” niring. ");
INSERT INTO mux_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kanu-kene, ⸤Yesos kene yu lumbili anduli yima kene⸥ enini ⸤nona anduli sipna⸥ no-numú nekendu puku kolea Gerasa puring. ");
INSERT INTO mux_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Akuna uring kene Yesos sipna wendu urum kene numanuna kuru mulurum yi te, yambu-ónu-koleana pelsiliipa andurumele enaliinga wendu omba yu mulurumna urum. ");
INSERT INTO mux_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Yi kanili, yambu-ónu-koleana pelsiliipa andurum. ⸤Kurale yunga numanuna mulurum kilia yu aima tondulu lakupa pirimeliinga⸥ yambuma-ni yu taki-taki unji-kama-ni kepe, ka-senuma-ni kepe yunga kimbu-kima ka turing ka-senuma topa sungu sipa, kimbusele ankap turingima topa elki-malki turum. Yi te-ni kepe ‘Yu táka-nimba mulupili.’ nimba kapula ambulumba yi tondulu te aima naa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Taki-taki, sumbulsuli kepe tanguli kepe, yambu-ónu-koleana kene ma-pangimanga kene ke nilsiliipa andurum kene, yunga kangiele ku-mulú ⸤nénga mululi⸥ mare-ni liipa kopsilsiliipa andupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Yi kanili-ni sulu tepa molupa Yesos kanupa kene yu mulurumna lkisipa urum. ⸤Urum kene⸥ Yesos-ni nimba mele: “Kurale, yi ilinga numanuna oku wendu pui!” nirim akili piliipa kene yili-ni yunga kumbi-kerina koporungu langupa tamalu pepa yunundu tondulu nangale topa nimba mele: “Yesos, Pulu Yi Aima Auli Olandupale-nga Málale, na-kene nambulka ulu te tinindu únuye? ‘Nu-ni Pulu Yili-nga bili lekunu mi lekunu “Aima sika niker. Na mindili aima liipu naa simbu.” ni!’ nimbu mawa teker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aku nirim kene Yesos-ni yilindu walsipa kene nimba mele: “Nunga bi naeye?” nirim kene yu-ni nimba mele: “Oliu aima pulele akiliinga nanga bi Aima-Puluma.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aku nimba kene wale pulele Yesos mawa tepa kene nimba mele: “Oliu ‘oku wendu pai.’ nikunu toku makurukunu kene “Kolea ili munduku kelku kolea luparenga pai.” ni naa ni.” niring. ");
INSERT INTO mux_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Akuna ma-pangi tenga bo-kung pulele im noku muluring kanuku kene ");
INSERT INTO mux_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","kuruma-ni Yesos mawa teku kene niku mele: “Oliu ⸤toku makurukunu kene⸥ “Ne kungmanga numanuna molu-pai.” ni.” niring kene ");
INSERT INTO mux_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","yu-ni “Kapula, akuna pai.” nirim kene kuruma yi kaniliinga numanuna wendu oku kene kung akuna muluringimanga numanuna puku muluring kene kung kanuma kelep toku lkisiku puku kopuna puka toku no-numúna suku puku no wanguring. Kung kanuma ⸤aima pulele,⸥ tausen tale mele. ");
INSERT INTO mux_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","⸤Ulu akuma wendu urum-na kanuku kene⸥ kung tápu-teku muluring yima takara toku puku kene, kolea-aulina muluring yambuma kene, kolea-kelúmanga muluring yambuma kene, ulu akuma wendu urum akili mele temani toku silsiliiku puring. Temani kanili piliiring yambuma ‘Ulu wendu um mele kanumulú.’ niku wendu puku ");
INSERT INTO mux_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Yesos mulurumna oku kene ui kuru aima pulele numanuna molku oku wendu puring yili mulumbale talupa, numanu-bo pirim-na mulurum kanuku kene enini mundu-mong tiring. ");
INSERT INTO mux_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Yesos-ni tirim mele mongale-ni kanuring yambuma-ni penga uring yambuma niku siring. Kuru pulele numanuna muluring yili kene, kungma-kene uluma wendu urum mele temanele toku siring. ");
INSERT INTO mux_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kanu-kene yambuma ⸤aima mini-wale munduku kene⸥ Yesos mawa teku kene niku mele: “Oliunga koleana naa molkunu kelkunu pui.” niring. ");
INSERT INTO mux_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aku-siku niring piliipa kene Yesos pumbandu nona andolemú sipna sukundu pumba purum kene kuru pulele numanuna ui molku wendu puring yili-ni yunundu nimba mele: “Wasie pambulu.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Akiliinga-pe Yesos-ni “Mólu.” nimba yunundu nimba mele: “Nu lkundu pukunu Auliele-ni nu kondu kolupa ‘Molku kis-sinu mele pora nipili.’ nimba, lakupa tepa kaí tímu mele nunga pulu lelemú yambuma nikunu si-pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yesos-ni aku-sipa nirim-na piliipa kene yi kanili pupa yunga kolea, ‘Kolea-Auli Engkaki Pambusele-Pipi’ niring koleana andupa Yesos-ni yu-kene lakupa tepa kaí tirim mele nimba sirim. Nimba sirimeliinga piliiku kene yambuma pali aima suru niku mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesos ⸤yu lumbili andúlima wasie⸥ nona andolemú sip tenga sukundu pupa no-numú yakundu alsupa omba kene numú-kéluna wendu urum kanuku kene yambu pulele yu mulurumna oku liiku máku toku liiku poku teku muluring. Yu no-numú-kélu akuna mulupili ");
INSERT INTO mux_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku te nukurum yi te, yunga bili Jairas, Yesos mulurumna urum. Kanu-kene yu Yesos kanupa kene Yesos yunga kimbuna nondupa omba mania molupa tamalu pepa ");
INSERT INTO mux_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","yunundu tondulu mundupa mawa tepa kene nimba mele: “Nanga ambula-kulu nondupa kolumba tekem akiliinga ‘Yu kona pupa kapula mulupili.’ nikunu okunu yu kili-ni ambului.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aku-sipa nirimeliinga piliipa kene Yesos yunu wasie puringli. Kanu-kene punglí puringli kene yambu pulele lumbili puku yu liiku poku teku si-si siku wasie puring. ");
INSERT INTO mux_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kanu-kene ambu te mulurum kaniliinga ku-puku turum enama pora naa nirim. Yu ku-puku mindi tupili punie engkaki-rurepu omba purum. ");
INSERT INTO mux_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yu dokta pulelemanga yunga kurale ‘Pora nipili.’ nimba andurum akiliinga-pe mindili mindi siring. Yunga ku-moni pali enini sirim akiliinga-pe yunga kurale pora naa nirim. We topa mindi pirim. ");
INSERT INTO mux_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ambu kanili Yesos ulu-tonduluma tirim mele temanima piliipa kene yambuma máku toku muluringina suku omba Yesos-nga bulkundu omba yunga wale-pakuliele ambulurum. ");
INSERT INTO mux_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‘Yunga wale-pakuliele mindi ambulundu lem nanga kurale pora nimbá.’ nimba piliipa kene aku-sipa tirim. ");
INSERT INTO mux_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","⸤Ambulurum kene⸥ enaliinga yunga kuru kanili pora nirim, yunga kangiele ui buni tirim akili pe waengu nirim piliirim. ");
INSERT INTO mux_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Akiliinga-pe ⸤yu Yesos-nga wale-pakuliele ambulurum kene⸥ Yesos yu-ni yambuma liipa tapunjuli tondulu mare yunga kangina omba ulsu purumele sumbi-sipa piliipaliinga topele topa kanupa yambumandu walsipa kene, “Nanga wale-pakuliele nae-ni ambulúmye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Akiliinga-pe ⸤yu-ni walsurum akili mele piliiku kene⸥ yu lumbili anduli yima-ni pundu toku niku mele: “Yambu pulele nu angiliikununa nondupa-nondupa oku liiku poku teku si-si siku angiliikimele akili. Pe nambimuna “Nae-ni na ambulúmye?” nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Akiliinga-pe Yesos mong male-male tepa korupa kene “Akili nae-ni tímuye?” nimba we angiliipa kondi tirim. ");
INSERT INTO mux_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kanu-kene tondulu te-ni yunga kangina kurale pora nirimele piliipa kene ambale aima mundu-mong tepa kimbu-kima pur-puru nipili Yesos mulurumna omba mania molupa tamalu pepa kene yu ulu tirim-ma pali nimba para sirim. ");
INSERT INTO mux_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesos-ni yunundu nimba mele: “Ambulale, ‘Nu kapula tepa kaí temba.’ niku tondulu mundukunu pilíínu ulu kanili-ni nu kona pukunu. Nunga kurale pora nimba, nunga numanale waengu nipili molani pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesos-ni ambalendu aku-sipa nimba mulurum kene, yi mare, yambuma máku toku Pulu Yili-nga ungele piliiring lku nukuli yi Jairas-nga lkuna molku kene oku ⸤Jairas-ndu⸥ niku mele: “Nunga ambulale kolupa pora símu. Nambimuna ‘Ung-Bo Tunjuliele mindili nupili.’ niku we mekunu uniye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Akiliinga-pe Yesos-ni enini niring ungele piliipa naa liipa kene lku nukuli yilindu nimba mele: “Mini-wale naa mundui. ⸤Nunga ambulale na-ni ‘Kapula liipa tapunjumba.’ nikunu⸥ tondulu mundukunu pilíí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kanu-kene yu-ni máku toku muluring yambumandu “Naa wai.” nimba kene Pita kene Jemis kene angin Jon kene akuma mindi liipa kene “Wasie pamulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lku nukuli yilinga lkuna uring kene yambu pulele molku kondu kolku kola lakuku teku muluring kanurum. ");
INSERT INTO mux_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yu lkuna lkundu pupa kene yambu muluringmandu nimba mele: “Eni nambimuna kola teku ke niku molemeleye? Ambulale kulú naa kulum. We uru mindi pelemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Akiliinga-pe aku-sipa nirim kene enini yu ung-taka tonjuku tae tinjiring. Yambuma pali makurupa pena-pena tepa kene, ambulaliinga anum lapasele kene, lumbili anduli yi talse kene liipa memba ambula-ónale lirim suluminana memba purum. ");
INSERT INTO mux_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pupa kene ambulaliinga kili ambulupa Juda-yambumanga ung lepa yunundu “Tallita kumi!” nirim. (Ung akiliinga pulele i-sipa mele: “ “Ambulale, nu ola mului.” niker.” nirim.) ");
INSERT INTO mux_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aku-sipa nirim kene ambulale enaliinga ola molupa kene andurum. (Ambula kanili punie rurepu mele omba pupili yu molupa kulurum kene Yesos-ni omba tepa kona liirim.) ⸤Akili kanuku kene⸥ yu-kene muluring yambuma suru niku mini-wale lakuku munduring. ");
INSERT INTO mux_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Kanu-kene Yesos yu-ni eninindu tondulu mundupa nimba mele: “Ulu teker ili yambu tilurindu kepe anju puku aima naa niku sai!” nimba kene ⸤anumundu⸥ nimba mele: “Ambulale langi mare liikunu si.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesos mulurum koleale mundupa kelepa yunga pulu-kolea ⸤Nasaret taon-na⸥ purum, yu lumbili anduli yima kene wasie puring. ");
INSERT INTO mux_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","⸤Kóru muluring⸥ kongun-Sambatele wendu urum kene enini máku toku Pulu Yili-nga ungele piliiring lkuna lkundu pupa kene yambuma ung-bo tonjupa mani sipa mulurum. Yunga ungele piliiku muluring yambu pulele-ni suru niku mini-wale munduku kene niku mele: “Ne yili ung akuma tena liirimunje? Yunga piliipa kungnjuliele kene yunga ulu-tondulu telemúmanga tondulale kene yu tena liirimuye? ");
INSERT INTO mux_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yu-ni lkuma takunjurum yili móluye? Yu Maria málu móluye? Jemis mene Josep mene, Judas mene Saimon mene, akuma yu eninga angin móluye? Yunga kimulupili oliu kene wasie naa molemuluye? ⸤Yu aima sika yi akili molemále⸥.” niring. ‘Yunu aima we-yili nambi-sipa tondulu ima yu-kene pelemúye?’ niku piliiku kene enini yu kanuku kis piliiku yu-kene aima numanu kis panjiring. ");
INSERT INTO mux_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Kanu-kene ⸤enini yu-kene arerembi kuluringeliinga ulu-pulele piliipa kene⸥ Yesos-ni eninindu nimba mele: “Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi te koleamanga pali bi ola pulimú, yambuma-ni pali yunga ungma piliiku liilimele. Akiliinga-pe yunga koleana yu-kene wasie tapú-toku molemele yambuma kene, yunga pulu lelemú yambuma kene, enini mendepolu yu-ni nilimú ungele piliiku kene ‘Yu oliunga we-yi te. Yu bi mululi yi te mólu.’ niku yu-ni nilimú ungma naa piliiku, liiku su silimele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","⸤Yunga ungele liiku su siringeliinga⸥ kolea akuna yu-ni ulu-tonduluma kapula naa tirim. Kuru turum yambu tilu-tilu nimba mendepolu kili-ni ambulupa kene tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yu ⸤ung nimba uluma tepa mulurum mele⸥ ‘Sika’ niku tondulu munduku naa piliiringeliinga yu aima numanu pulele kimbú sirim. 6:6—8:21 Yesos-ni Yunga Tondulale Liipa Ora Sirim Akiliinga-pe Yu Lumbili Andúlima-ni Yu Sika Mulurum Mele Piliiku Bi Naa Siring Ung Mare Kanu-kene Yesos kolea-kelú lupa-lupamanga andupa kene ⸤Pulu Yili-nga ungele⸥ mani sipa ung-bo tunjulsiliipa andurum. ");
INSERT INTO mux_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesos-ni yu lumbili anduli yi engkaki-rurepundu “Yandu wai.” nimba kene enini yambumanga numanuna kuru molemúma “Oku wendu pai.” niku toku makurungí tondulale sipa kene enini tale-tale nimba “Koleamanga ando-pai.” nimba liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","⸤Liipa mundupa kene⸥ enini tingí mele ung-mani sipa kene nimba mele: “Pungíndu mélema naa miai. Apulu-mingima mindi liiku ambolku pai. Kimbu-su munjingí kapula, akiliinga-pe wale-pakuli tale kepe langi kepe méle-wale kepe naa meku, ku-moni kamirikana kepe panjiku naa meku we pai. ");
INSERT INTO mux_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","“Pe kolea tenga sukundu puku kene akuna mulungí teku lku tiluringa lkundu puku kene akuna mindi peku molku kene penga kolea akili munduku kelku pai. ⸤Lku tenga puku tenga puku naa teai. Lku tiluringa mindi langi noku peai.⸥ ");
INSERT INTO mux_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kolea marenga suku pungí kene kolea pulu yambuma-ni “Wasie piamili wai.” ni naa niku eni ung ningíma piliiku naa lííngi lem kolea kanuna yambu kísima munduku kelku pungí teku kene ⸤yambu kanuma-ni aku-siku teku kis-singéliinga⸥ ‘Kamu molku kis-sangi. Pulu Yili-ni enini liipa naa tapunjumba mele akili piliangi.’ niku kolea kanumanga ma eninga kimbuna angiliimbama tanda siku munduku pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","⸤Yu lumbili andúlima yu-ni aku-sipa liipa mundurumele piliiku⸥ puku kene yambumandu niku mele: “Ulu-pulu-kis telemelema kanuku kis piliiku numanu topele tai.” niku ");
INSERT INTO mux_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","yambumanga numanuna kuru pulele muluringma ⸤‘Oku wendu pai.’ niku⸥ toku makuruku, kuru turum yambu pulele ‘Kaí molangi.’ niku eninga kangina ollip no-kopungu onde leku kanjunjuku teku kaí teku, telsiliiku anduring. ");
INSERT INTO mux_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kanu-kene Yesos yunga bili yambuma-ni piliiku liringeliinga yunu-ni tirim mele temani turing kene yi nuim king Erot-ni piliirimko. ⸤Yesos-ni tepa nirim mele piliiku kene⸥ yambu mare-ni niku mele: “Ulu ima telemú yili No-Liinjili Jon lam! Yu kolupa kene lomburupa ola molupa úmeliinga ulu-tonduluma temba tondulale yu-kene pelemú.” niku muluring. ");
INSERT INTO mux_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yambu mare-ni niku mele: “Yu ⸤ui kona mulupili Pulu Yili-ni olandu liirim yi⸥ Illaija alsupa omba molemú.” niring. Yambu mare-ni niku mele: “Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kóru-ui muluring yima mele yu aku-sipa Pulu Yili-nga ungma piliipa yandu nimba silimú yili molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","⸤Yambuma-ni aku-siku niku piliiring⸥ akiliinga-pe yi nuim king Erot-ni ⸤Yesos yu-ni tirim mele temani turing⸥ piliipa kene nimba mele: “Ulu ima telemú yili ⸤No-Liinjili⸥ Jon, ‘Yunga pengale wendu pupili.’ nimbu numi kari lirindu yi kanili. Yu kolupa kene lomburupa ola molupa um lam.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","⸤King Erot-ni aku-sipa nirim ungeliinga pulele i-sipa mele:⸥ Ui walse Erot-ni yunga angin Pillip-nga ambu min Erodias mangupa liirim. ⸤No-Liinjili⸥ Jon-ni Erot aku-sipa tirim kanupa kene yunundu taki-taki nimba mele: “Nu-ni ⸤Pulu Yili-nga⸥ ung-mani te pula tokunu angenanga ambale mangukunu liirinu. Akili tekunu kis-sirinu.” nirim kene Erot-ni yu liipa ka sipa ka-lkuna panjurum. ");
INSERT INTO mux_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Jon-ni aku nirimaliinga ambu Erodias-ni yu arerembi kolupa “Yu topu konjumbu.” nimba mulurum akiliinga-pe Erot-ni ‘Jon yu numanu sumbi-sipa pepa Pulu Yili-nga yi kake tiliele molemú.’ nimba kanupa yu mundu-mong tenjipa kene nokupa kunjurumeliinga ambu Erodias-ni Jon-kene ulu te kapula naa tirim. Jon-ni ung nirim-ma piliipa kene yi nuim king Erot yu aima numanu pulele liipa mundupa mini-wale mundurum akiliinga-pe ung akuma yu aima numanu sipa piliirim. ");
INSERT INTO mux_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Penga walse, ⸤ambu Erodias⸥ numanale-ni piliipa mulurum ulele temba enale wendu urum. Wendu urum akili i-sipa mele: King Erot miring enale wendu urum kene yunga kendemande-yi aulima kene, yunga ami-yimanga yi-nuimima kene, kolea Gallalli distrik yambumanga yi-nuim aulima kene, eninindu “Langi wasie namili wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","⸤Enini oku yu-kene wasie langi noku molangi⸥ Erodias limin lkuna lkundu omba enini muluringna denis tirim. Erot kene, yu-kene wasie langi noku muluring yima kene enini ambu-wenipale aku tirim kanuku aima kaí piliiring. Kingele-ni aima kanupa kaí piliipa kene ambu-wenipalendu nimba mele: “Nu-ni numanu monjukunu méle te na mawa ti. Mawa tiní mélale nu simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pulu Yili-nga bi lepa mi lepa kene yunundu kelepa nimba mele: “Aima sika niker. Nu-ni na mawa tiní méle te aima sika simbu. Na-ni yi nuim kingele molupu nokuliu kolealiinga ekendu kepe “Si.” ninu lem aima sika simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Erot-ni yunundu nirim mele akili piliipa kene ambu-wenipale pena pupa, anum mulurumna pupa walsipa kene nimba mele: “Méle nambulka mélale ‘Si.’ niambuye?” nirim kene anumu-ni nimba mele: “ “No-Liinjili Jon-nga ⸤numiele kari lekunu yunga⸥ pengale si.” ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Anumu-ni aku nirim piliipa kene yu kingele mulurumna lkisipa omba mawa tepa kene nimba mele: “Aima enaliinga No-Liinjili Jon⸤-nga numiele kari leku⸥ yunga pengale dis tenga nosuku yandu si.” nirim. ⸤Jon-ni ui taki-taki “Erot kene Erodias-seleni teku kis-siringli.” nirimaliinga arerembi kolupa kene Erodias-ni ‘Yu kulupili. Pe sika kulumnje na kanambu.’ nimba “Pengale oku si.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yu-ni aku-sipa mele mawa tirim-na piliipa kene Erot aima numanu buni lirim akiliinga-pe yu-ni “Aima sika simbu.” nimba, nimba panjipa Pulu Yili-nga bi lepa mi lirim mele kepe, yu numanu topele tomba kene yu-kene wasie langi noku muluring yima yu kanuku kis piliingí mele kepe, ulu akusele piliipa kene, “Yu-ni mawa tepa “Si.” nikem mele “Mólu.” kapula naa nimbú.” nimba piliipa kene ");
INSERT INTO mux_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","yunga nukuring ami-yimanga te liipa mundupa “⸤No-Liinjili⸥ Jon⸤-nga numiele kari leku⸥ yunga pengale yandu meku ui.” nirim kene ami-yi kanili-ni ka-lkuna pupa Jon-nga numiele kari lepa kene ");
INSERT INTO mux_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","yunga pengale dis tenga nosupa yandu memba omba ambu-wenipale sirim kene yu-ni anum sirim. ");
INSERT INTO mux_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aku tiring piliiku kene Jon lumbili anduring yima oku yunga ónale liiku meku puku ónu tiring. ⸤King Erot-ni No-Liinjili Jon ui aku-sipa topa kunjurum kulurumeliinga penga Yesos-ni ulu-tonduluma tirim mele piliipa kene “Jon numi kari lirindu yili lomburupa ola molemú lem.” nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesos-ni “Nanga kongunale tenji-pai.” nimba liipa mundurum yima yu mulurumna kelku yandu oku kene, ulu tiringma kene yambuma ung-bo tunjuringima kene yu temani toku siring. ");
INSERT INTO mux_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Akiliinga-pe yambu pulele oku puku oku puku tiringeliinga Yesos kene ⸤yu-ni liipa mundurum yi yandu uringma⸥ kene langi nungí ena-mong laye-kolte kepe naa lirimeliinga kanupa kene Yesos-ni yimandu nimba mele: “Eni-enini yambu naa mululi kolea-waka tenga laye-kolte múlu liangi akiliinga na-kene wasie pamili wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kanu-kene eni-enini mindi no-numúna anduli sip tenga suku puku yambu naa mululi kolea-waka tenga puring. ");
INSERT INTO mux_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Akiliinga-pe pungí puringele kanuku kene yambu pulele Yesos kene yu lumbili andúlima kene kanuku bi siringeliinga koleamanga yambuma pali kimbu kambiliikunu lkisiku numú-kélale poku teku puku enini no-numúna wendu pungí koleana kumbi-leku puku nokuku angiliiring. ");
INSERT INTO mux_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesos numú-kéluna wendu omba kanurum kene yambu aima pulele akuna oku máku toku muluring kanupa kene enini kung-sipsip tápu tili yi te naa mululi sipsipma mele ku peku muluringeliinga nimba kanupa kene enini kondu kolupa ung-mani pulele mani sipa ung-bo tonjumba tirim. ");
INSERT INTO mux_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kanu-kene ⸤mani sipa ung-bo tonjupa mulupili⸥ ena pumba tirimeliinga yunga lumbili anduli yima yu mulurumna oku yunundu niku mele: “Kolea ilinga yambu te naa pelemelé, enale kamu pukum akiliinga ");
INSERT INTO mux_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ya máku toku molemele yambuma “Puku kolea marenga langi taropu toku lii-pangi.” ni.” niring. ");
INSERT INTO mux_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aku niring-na piliipaliinga yu-ni ⸤yu lumbili anduli yimandu⸥ pundu topa nimba mele: “Eni-enini yambuma langi mare liiku sai.” nirim. Enini yu walsiku kene niku mele: “‘Ku-moni tu-tausen kina mele liipu kene oliu-ni langima taropu topu liipu yambuma samili.’ niku nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","⸤Aku-siku niring piliipa kene⸥ yu-ni eninindu walsipa piliipa kene nimba mele: “Pllawa kaluli nambi-sili nosuku molemeleye? Puku kano-pai.” nirim. Puku koruku kanuku liiku yu mulurumna kelku oku kene niku mele: “Langi mare au-sipa naa lelemú. Pllawa kaluli wallú angere te-guli kene oma kaluli tale kene ⸤aku-sele mindi lelemú⸥ .” niring. ");
INSERT INTO mux_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kanu-kene Yesos-ni nimba mele: “Yambumandu “Era pole kaína máku toku mania molangi.” niai.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","yambu tokapu tale niku tokapu angere niku máku toku muluring. ");
INSERT INTO mux_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kanu-kene Yesos-ni pllawa kaluli angere te-guli kene oma tale kene liipa kene mulú-koleana olandu-sipa kanupa ⸤Pulu Yili-kene⸥ “Angke” nimba pllawa kalúlima ambulupa puku topa lumbili andúlima moke tepa sipa kene “Anju yambuma sai.” nirim, ⸤enini⸥ yambuma ⸤moke teku siring⸥. Oma taleko liipa moke tepa yambuma pali sirimuko. ");
INSERT INTO mux_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Enini pali langi kanuma nuring kene olu tirim. ");
INSERT INTO mux_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kanu-kene lumbili anduli yima-ni pllawa kaluli kepe oma kepe kanumanga kakena lirim-ma liiku máku toku wale-basket engkaki-rurepu toku peka siring. ");
INSERT INTO mux_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Langi nuring yima mindi paip-tausen mele. ");
INSERT INTO mux_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","⸤Yambuma langi sirim nuring⸥ kene Yesos-ni yu lumbili anduli yimandu sumbi-sipa nimba mele: “Máku toku molemele yambuma na-ni “Pangi.” niambu. Enini nona anduli sipna ola puku no nekendu, Besaida taon-na, kumbi-leku pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kanu-kene yambuma mundupa kelepa yunu Pulu Yili-kene popu topa ung nimbándu ma-pangina ola purum. ");
INSERT INTO mux_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kanu-kene enale pupa kolea kala turum kene sipele no-numú ai-suku-singina purum, Yesos yunu ma-⸤pangi⸥na we mulurum. ");
INSERT INTO mux_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sip kumbikundu mendu sipa popuremi turumeliinga ⸤yu lumbili anduli yima sipna sukundu molku kene⸥ sipele numú-kéluna meku pungíndu piliiku sunduring kanupa kene sumbulsuli kolea muni naa lipili enini puringna yu nona ola kimbu kambiliipa ombándu omba kene enini sipna puku molangi yu-ni enini topa aele lenjipa yunu kumbi-lepa pumba urum. ");
INSERT INTO mux_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Akiliinga-pe ⸤yu lumbili andúlima⸥ enini pali yunu nona ola kimbu kambiliipa urum kanukuliinga, aima mundu-mong lakuku teku kene “Kuru te okumaa!” niku mini-wale munduring kene Yesos-ni lkisipa eninindu nimba mele: “Eni numanu tondulu pupili molai. Na mindi okur. Mundu-mong naa teai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Kanu-kene yu sipna sukundu purum kene popuremale topa kilirim. Aku-sipa tirimeliinga kanuku kene aima mini-wale munduring. Yu-ni ⸤ui tanguli⸥ pllawa kalúlima ⸤moke⸥ tirimeliinga pulele naa piliiku we numanu lu liiku muluring. Yu-kene tondulu te pirim-na pllawa kalulima-kene ulu-tondulu te tirim mele akili mimi-siku naa piliiku enini numanu lupa pirimu-na tondulu kanili-ni popuremale topa kunjurum mele akili kepe naa piliiku kungnjukuliinga popuremale topa kunjurum kene kanuku kene enini aima mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","⸤Yesos kene yu lumbili andúlima kene⸥ numú ⸤Gallalli⸥ nekendu puku kene no-numú kéluna kolea Geneseret lirim koleana wendu oku kene sipele ka toku panjiring. ");
INSERT INTO mux_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sipna mania uring kene akuna muluring yambuma-ni Yesos enaliinga kanuku bi siku kene ");
INSERT INTO mux_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","akuna lirim koleamanga pali lkisiku puku yu andurum koleama piliiku kene eninga kuru turum yambuma liiku taropola teku yu andurumna meku uring. ");
INSERT INTO mux_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yu andurum koleamanga pali, kolea-kelúmanga kene, kolea-aulimanga kene, kolea wemanga kene, kolea akumanga yambuma máku toku muluring koleamanga kuru turum yambuma meku oku nosuku kene, “‘Nunga wale-pakuli pundele kepe ambolangi.’ ni.” niku mawa tiring. Kanu-kene kuru turum yambuma-ni yunga wale-pakuliele ambuluring yambuma pali kamu kaí muluring. ");
INSERT INTO mux_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","⸤Walse⸥ Perisi-yi mare kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi mare kene enini Jerusallem munduku kelku Yesos mulurumna oku máku toku muluringma ");
INSERT INTO mux_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","yu lumbili andúlima-ni kima kalaru mulupili lumaye naa toku langi we ambolku nuring-na kanuku kene kanuku kis piliiring. ");
INSERT INTO mux_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(⸤Sika kalaru naa mulurum akiliinga-pe⸥ Perisi yima kene Juda-yambu wema pali kene eninga anda-kolepalima-ni “Teai.” niring mele ui kima pali nona munduku lumaye toku konjuku kene penga langi nuring. We naa nuring. ");
INSERT INTO mux_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maket-koleana puku lkundu oku kene kima ui lumaye toku kene ⸤maketna taropu toku liiring⸥ langima nuring. We naa nuring. Anda-kolepalimanga tiring ulu-pulu lupa-lupa pulele piliiku liiku teku muluringko. Kápma kepe, mingima kepe, langi nuring poluma kepe, aku-sipa mélema taki-taki we lumaye turing.) ");
INSERT INTO mux_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","⸤Juda-yambuma-ni aku-siku tiring⸥eliinga Perisi-yima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, enini ⸤Yesos lumbili andúlima-ni aku-siku kima lumaye naa toku langi we nuring kanuku kene⸥ Yesos-ndu walsiku piliiku kene niku mele: “Anda-kolepalima-ni “Teai.” niring mele nunga lumbili anduli yima-ni nambimuna naa piliiku liiku telemeleye? Eninga kima kalaru mulupili langi nolemele kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesos-ni eninindu pundu topa nimba mele: “Eni ⸤ung-manima piliiku ung-bo tonjilimele yima kene Perisi-yima kene⸥ eni topele-mapele tuli yima molemele! Pulu Yili-ni “Ninji!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni enindu nirim mele akili kapula nirim. ⸤Eni ekupu telemele mele yu-ni ui nimba Pulu Yili-nga⸥ bukna turum molemú akili i-sipa mele: ‘⸤Pulu Yili-ni nimba mele:⸥ “Yambu kanuma eninga kerale-ni na kape niku ‘Yi-auli-olandupale. Nu liipu ai silimulu.’ niku na bi paka tonjilimele akiliinga-pe eninga numanuma kene nanga numanale kene tiluna naa pulimú. Lupa-lupa pelemú. ");
INSERT INTO mux_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Enini ‘Nanga bili paka tunjamili.’ niku na we popu toku kape nilimele. Mana-yambuma-ni mani silimele ungma mindi mani siku kene ‘Ung-mani ima Pulu Yili-ni “Teai.” nilimú ung-manima.’ niku piliiku liiku telemele, akiliinga na popu tungí kene ulu te naa temba.” ⸤nirim⸥’ kanili. ");
INSERT INTO mux_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pulu Yili-ni “Teai.” nirim ung-manima munduku kelku kene anda-kolepalima-ni “Teai.” niring mele akili mindi ambolku molemele.” ⸤nimba Yesos-ni⸥ nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","⸤Yesos-ni⸥ ung mare wasie eninindu nimba mele: “Eninga anda-kolepalima-ni “Teai.” niring akili piliiku liiku tingíndu Pulu Yili-ni “Teai.” nirim ung-manima liiku bulu silimele akili kapula telemeleye? ⸤Lawa telemele.⸥ ");
INSERT INTO mux_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Akiliinga Moses-ni nimba mele: “Aminiali lanialinga ungma piliiku, liiku ai siku teai.” nimba “Yambu te-ni yunga anumundu mola lapandu ung te nimba kis-sipa ung-mura sim lem yambu kanili toku konjangi.” nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Akiliinga-pe eni ⸤Juda-yambumanga tápu-yima⸥ -ni niku mele: “Yi te-ni yunga anum lapaselendu nimba mele: “Na-ni else méle mare liipu tapunjupu silkama kórunga ‘Pulu Yili simbu.’ nimbu, nimbu panjurundu kaniliinga else kapula naa liipu tapunjupu simbu.” nimba kene ");
INSERT INTO mux_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","yunga anum lapasele naa liipa tapunjumbale kapula.” niku mani silimele. ");
INSERT INTO mux_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aku-siku mani silimele ungele-ni ‘Anda-kolepalima-ni mani siring ulu-puluma olandupa.’ niku ‘Pulu Yili-ni nirim ungele ulu te mólu. Mania pupili.’ nilimele. Eni ulu lupa-lupa pulele aku-siku teku molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aku nimba kene Yesos-ni máku toku muluring yambumandu “Na moliuna wai.” nimba kene eninindu nimba mele: “Na-ni ⸤aku-sipu nikereliinga ung te⸥ nimbú teker ungele eni pali kum leku ungeliinga pulele piliiku kongnjai. ");
INSERT INTO mux_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yambumanga kangina ulsukundu lepa kene kerina pupa oluna suku pulimú méle te-ni ⸤Pulu Yili-kene kapula-kapula mulungí kupulanumele pipi silimú⸥ kalaru te kapula naa monjulemú. Yambumanga numanuna sukundu pepa kene wendu olemú uluma-ni mindi yambuma tepa kalaru monjulimú. ");
INSERT INTO mux_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Yambu kum-peú lelemúma-ni ung ili mimi-siku piliai.” nirim.) ");
INSERT INTO mux_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kanuna máku toku muluring yambuma Yesos-ni mundupa kelepa lkuna lkundu purum kene yu lumbili andúlima-ni yu walsiku kene niku mele: “Ung-eku akiliinga pulele nambulkanje? Niku para si.” niring kene ");
INSERT INTO mux_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Yesos-ni eninindu nimba mele: “Ekupu kepe naa piliikimiliye? Yambu tenga kangina ulsu lepa kene sukundu pulimú mélale yunga numanuna naa pupa, oluna suku pupa mere wendu omba le-kusina kamu pulimáliinga yu yambuma tepa kalaru kapula naa monjulimú akili naa piliikimiliye?” nirim. (Yesos-ni aku-sipa nirimaliinga “Langima-ni pali yambuma tepa kalaru te naa monjulemú.” nimbándu nirim.) ");
INSERT INTO mux_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","⸤“Kerina sukundu pulimú mélema-ni aku-sipa ulu te naa telemú.” nimba kene⸥ yu-ni alsupa nimba mele: “Yambu tenga numanuna sukundu pepa kene wendu olemú méle kanuma-ni yambu te ⸤Pulu Yili-kene kapula molembele kupulanumele pipi silimú⸥ kalaru te yambuma tepa kalaru monjulemú. Ulu-pulu-kisma ui numanale-ni piliiku kene ⸤penga kamu telemeláliinga⸥ “Numanuna pepa kene wendu olemú mélema-ni yambuma tepa kalaru monjulemú. ⸤We naa telemele.⸥” ⸤niker.⸥ Méle kanuma i-sipa: Numanale-ni ulu-kísima piliilimili; waperanale lupa-lupama anduku telemele; wa nolemele; yambuma toku konjulemele; ambu yi púlima mola yi ambu líílima yambu lupama kene waperanale telemele; ");
INSERT INTO mux_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yambumanga méle nosulimelema ‘Liambu.’ nilimele; ulu-pulu-kis lupa-lupama telemele; gólu tolemele; yambuma-ni kanuku kene pipili kolemele uluma pipili naa kolku walu siku telemele; yambu lupama molemele mele kepe eninga mélema yama meku ‘Yu maluya.’ niku telemele; ‘Yambuma pipili kolku molku kis-sangi.’ niku ung-bulkundu ninjilimele; ‘Na bi molemú. Na piliipa kungnjuli lakupa pelemú. Yambu mare tondulu te naa pelemú.’ niku kara pulimelé; kelep tuli uluma telemele; ulu-pulu akuma telemele. ");
INSERT INTO mux_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ulu-pulu-kis akuma pali yambumanga numanuna sukundu pepa wendu olemúma-ni yambuma tepa kalaru monjulemú, yambuma ⸤Pulu Yili-nga kumbi-kerina pungí kupulanumele pipi silimú⸥ tepa kalaru monjulimú. ⸤Ulsu lepa oluna suku pulimú mélema-ni ulu te naa telemú.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Kanu-kene Yesos mulurum kolea ⸤Geneseret⸥ mundupa kelepa ⸤Juda-yambuma muluring kolea Gallalli distrik ulsukundu⸥ kolea-auli Taya kene Saidon-sele lirim koleana sukundu purum. Akuna purum kene yambuma-ni yunu ‘naa kanangi.’ nimba lku tenga ⸤kiang nimba⸥ lkundu pupa mulurum akiliinga-pe yunu omba mulurum mele yambuma-ni piliiring. ");
INSERT INTO mux_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yesos yunu omba mulurum akili piliipa kene ambu te yu mulurumna sumbi-sipa omba yunga kumbi-kerina mania molupa tamalu pirim. Ambu kanili yunu ⸤Pulu Yili-nga⸥ Juda-yambumanga talapena ulsukundu ambu te, kolea Siria propinj sukundu kolea Ponisia distrik ambale. Ambaliinga liminunga numanuna kuru te molupa ambulurum kilia Yesos mulurumna omba mania molupa tamalu pepa yunundu mawa tepa kene nimba mele: “Nanga ambulale kuru te numanuna sukundu molemáliinga yunu ⸤kondu kolkunu⸥ kurale toku makurui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","⸤Ambale yunu ambu lupa, Juda-ambu te mólu, nimba kanupa kene⸥ Yesos-ni ambalendu ⸤ung-eku te topa kene⸥ nimba mele: “Kangambulama langi ui noku olu konjangi. Eninga langima liipu owama simulú kene kapula naa temba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ambale-ni yunundu nimba mele: “Auliele, sika nikinu akiliinga-pe owama-ni kepe kangambulamanga langi pundu mania pulimúma liiku nolemele kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kanu-kene Yesos-ni yunundu nimba mele: “Ambale, nu aku-siku nikinele kapula nikinu. Aku-siku nikineliinga kuru kanili nunga ambulaliinga numanuna sukundu molupa omba wendu púmeliinga nu ⸤numanu waengu silsiliiku⸥ pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","⸤Yesos-ni aku-sipa nirim piliipa kene⸥ ambale alsupa lkundu pupa kanurum kene limin numanuna kuru te naa mulupili uru pili poluna ola we mulurum kanurum. ");
INSERT INTO mux_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesos kolea-auli Taya mundupa kelepa kolea-auli Saidon sukundu omba pupa, ‘Kolea-Auli Engkaki Pambusele-Pipi’ niring koleana sukundu omba, numú-Gallalli kéluna urum. ");
INSERT INTO mux_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Akuna muluring yambuma-ni yunu mulurumna yi kum sipa ung sumbi-sipa naa nirim yi te meku oku “⸤Yunga kumele kaí lipili⸥ nunga kili-ni ambului.” niku tondulu munduku mawa tiring. ");
INSERT INTO mux_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kanu-kene yambu pulele kakapu teku muluringma mundupa kelepa “Olsulu molambili ui.” nimba yi kanili tenga-lupa memba pupa kene, kúmselenga ki-sundele suku mundupa, lkambe topa yilinga anembelale kili-ni ambulupa kene, ");
INSERT INTO mux_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mulúna olandu-sipa kanupa, tondulu múlu liipa, Juda-yambumanga ung lepa yilindu nimba mele: “Epata!” nirim. (Ung kaniliinga pulele “Kum-peú lipili ung piliani!” nirim.) ");
INSERT INTO mux_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aku-sipa nirim kene enaliinga yilinga kumele peú lirim, yu ung kapula piliipa, anembelale tekele turum kanili penta nimba bo-anembele angiliirim kene yunu ung sumbi-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanu-kene Yesos-ni eninindu tondulu mundupa nimba mele: “Na-ni ulu teker mele ili anju yambu tilurindu kepe aima naa niku sai!” nirim. Akiliinga-pe yunu “Mólu.” nimba wale pulele tinjirim mele yambuma-ni liiku su siku anju-anju yambuma yu-ni tirim mele temani toku silsiliiku mindi anduring. ");
INSERT INTO mux_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","⸤Yunu tirim mele kanuring yambuma kene, anju temani toku siring piliiring yambuma kene wasie⸥ enini aima mini-wale munduku suru niku kene niku mele: “Apa! Yu-ni telemú uluma kaí mindi lelemú. “Kúmu silimúma ung piliiku, ung naa nilimelema ung niku, teai.” nilimú kene-ko ungma piliiku ungma niku telemele.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Walse ⸤Yesos mulurumna⸥ yambu pulele kelku oku liiku máku toku muluring. Muluring koleana nungí langi te naa lirim kilia Yesos-ni yu lumbili andúlimandu “Na moliuna wai.” nimba kene eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yambu máku toku molemele ima na kondu tekem. Ena yupuku na-kene mulúngi, pe ekupu langi nungí te naa lelemú. ");
INSERT INTO mux_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mare kupulanum suluna uringeliinga na-ni “Eni engle topa pípili lkundu pai.” nilkanje enini kupulanum-na kimbu kima pang-mangi tepa, topa ne-munda ya-munda telka.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Aku-sipa nirim-na piliiku kene yu lumbili anduli yima-ni yunundu pundu toku niku mele: “⸤Sika nikinu akiliinga-pe⸥ kolea-waka ilinga molemulu. Yambu ima kapula nungí mele pllawa kaluli tena lembana liipu simulúye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesos-ni eninindu “Pllawa kaluli nambi-sili nosuku molemeleye?” nimba walsurum kene enini “Angere yupuku-guli nosupu molemulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Kanu-kene yu-ni máku toku muluring yambumandu “Mania molai.” nimba kene, pllawa kaluli angere yupuku-guli liipa ⸤Pulu Yili-kene⸥ “Angke” nimba, akuma puku topa yu lumbili andúlimandu “Yambuma moke teku sai.” nimba enini sirim. Nirim aku-mele tiring. ");
INSERT INTO mux_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Enini oma kaluli laye-talse nosuku muluringko, akuma liipa ⸤Pulu Yili-kene⸥ “Angkeko.” nimba kene yu lumbili andúlimandu “Ima yambuma moke teku sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yambuma ⸤langi⸥ nuring kene olu tirim. Pe langi-kakena lirim-ma lumbili anduli yima-ni liiku wale-basketmanga laliiring, wale auli angere yupuku-guli toku peka siring. ");
INSERT INTO mux_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Yi po-tausen-ni langi akuma nuring. Kanu-kene Yesos-ni máku toku muluring yambumandu “Lkundu pai.” nimba kene, ");
INSERT INTO mux_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","yu lumbili andúlima kene yunu kene enini nona anduli sipna suku puku, ⸤no-numú nekendu⸥ kolea Dallamanuta puring. ");
INSERT INTO mux_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Akuna puring kene Perisi-yima Yesos mulurumna oku, ‘Yu-ni nambi tembanje? Kanamili.’ niku yu manda leku mawa teku kene niku mele: “⸤Ung-Bo Tunjuliele,⸥ ‘Nu sika Pulu Yili-ni ‘Kongun tenjani.’ nimba ya mana liipa mundurumnje kanamili.’ niku mulú-koleana molemú Pulu Yili-ni mindi kapula ulu-tondulu telemú mele te ti.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","⸤Aku-siku walsiringele piliipa kis piliipaliinga Yesos⸥ yunu aima numanu buni liipaliinga múlu lakupa liipa kene nimba mele: “Ekupu ma-koleana molemele yambuma-ni “Pulu Yili-ni mindi ulu-tonduluma kapula telemú mele kanamili ti.” niku na nambimuna mawa telemeleye? ⸤Na moliu mele nambimuna “Sika” we niku tondulu munduku naa piliilimiliye?⸥ Na-ni eni sika nimbu siker: “⸤Na Pulu Yili kene tapú-topulu kongun telembulu mele⸥ liipa ora simba kanuku bi singí ulu-tondulu te, ekupu mana molemele yambuma-kene wendu naa ombá.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aku-sipa nimba kene, enini mundupa kelepa sipna sukundu alsupa pupa kene no-numú nekendu purum. ");
INSERT INTO mux_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","⸤Kanu-kene enini no-numú nekendu pungíndu Yesos lumbili anduli yima⸥ pllawa kaluli apera siku naa meku puring. Pllawa kaluli tilu mindi sipna sukundu lirim, te wasie mólu. ");
INSERT INTO mux_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Kanu-kene Yesos-ni eninindu lip-lipi topa ⸤ung-eku topa kene⸥ nimba mele: “Aima mimi-siku kanai! Perisi-yima kene ⸤yi nuim king⸥ Erot yunga yima kene enini pllawa tepa auli mundulimú méle yis nosulimelale kanuku kongnjai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aku-sipa nirim-na piliiku kene yu lumbili anduli yima-ni eni-enini tombulku kene niku mele: “Oliu pllawa kaluli ⸤nomulú⸥ mare naa liipu membu úmulaliinga aku-sipa nikem-nje.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aku-siku niring mele piliipaliinga Yesos-ni eninindu nimba mele: “Eni “Pllawa kaluli naa mímulu.” niku nambimuna tombulku nikimiliye? Ekupu kepe eni naa kanuku, mimi-siku naa piliikimiliye? ⸤Nanga tondulu te pirim-na pllawa kalulima-kene ulu-tondulu te tirindu mele akili eni naa piliiringiye?⸥ Eni numanu naa pípili molemeláliinga na-ni niker mele ung-pulele naa piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Eni mong angiliimú akiliinga-pe mélema naa kanokumeleye? Kum angiliimú akiliinga-pe ungma naa piliikimiliye? Pllawa kaluli angere te-guli liipu puku topu yi paip-tausen moke tepu sirindu kanili eni apera sikimiliye? ⸤Noku pora siring kene⸥ langi-kakena lirim-ma liiku wale-basket nambi-sili toku peka siringye?” nirim kene ⸤yu lumbili andúlima-ni⸥ yundu pundu toku “Engkaki-rurepu kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","⸤Yu-ni eninindu alsupa nimba mele:⸥ “Pe pllawa kaluli angere yupuku-guli liipu puku topu ⸤yi⸥ po-tausen moke tepu sirindu kene ⸤noku pora siring kene⸥ wale-basket auli nambi-sili langi-kakena lirim-ma toku peka siringye?” nimba walsurum kene enini yunundu pundu toku “Angere yupuku-guli kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yu-ni eninindu ⸤alsupa⸥ nimba mele: “Ekupu kepe eni mimi-siku naa piliikimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesos kene, yu lumbili andúlima kene, enini Besaida taon-na puring kene mong kis lili yi te Yesos mulurumna meku oku mawa teku kene niku mele: “Nu-ni yi ili kíli-ni ambului.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aku-siku niring kene Yesos-ni mong kis lili yili ki ambulupa taon-na ulsukundu memba pupa kene yunga mongselenga lkambe topa kanjupa kili-ni ambulupa kene nimba mele: “Nu ekupu méle te kanokunu mola móluye?” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","yili-ni olandu-sipa kanupa kene nimba mele: “Na ekupu yambu mare, enini unji-melema oku pukumele kanokur.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesos-ni yunga mongselenga kelepa ambulurum kene yili yunga mongsele kaí lirim kilia mélema pali kanupa kene sumbi-sipa kanupa bi sirim. ");
INSERT INTO mux_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesos-ni yilindu “Lku-koleandu pui.” nimba kene nimba mele: “Nu kelkunu lku-koleandu puni teku ne kolea ⸤molupu wendu úmbulu⸥ akuna alsukunu anju naa pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesos kene yu lumbili andúlima kene puku kolea-auli Sisaria-Pillipai nondupa lirim kolea kelúmanga pungí puring. Akuna pungí puring kene Yesos-ni yunga lumbili andúlimandu walsipa kene nimba mele: “Yambuma-ni na bi leku nae nilimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Enini yunundu niku mele: “Mare-ni “Nu No-Liinjili Jon ⸤kulurum kanili alsupa lomburupa ola molemú⸥.” niku piliilimili; mare-ni “Nu ⸤Pulu Yili-ni ui kona mulupili olandu liirim yi⸥ Illaija alsupa omba molemú.” niku piliilimili; mare-ni “Nu Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te ⸤ui kulurum ekupu lomburupa ola molemú.⸥” niku piliilimili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aku-siku niring piliipa kene Yesos-ni eninindu walsipa kene nimba mele: “⸤We-yambuma-ni aku-siku nilimele⸥ akiliinga-pe eni-enini na nae nilimeleye?” nirim. Pita-ni pundu topa nimba mele: “Nu Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ ui nimba makó turum yi-nuim Kraisele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","⸤Pita-ni aku nirim-na piliipaliinga⸥ Yesos-ni eninindu tondulu mundupa nimba mele: “Na moliu mele ⸤Pita-ni ekupu nikemele⸥ eni anju yambu tilurindu kepe ⸤isili-ui⸥ aima naa niku sai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kanu-kene Yesos yunga lumbili andúlima-ni yunundu ⸤“Pulu Yili-ni oliu “Nokupa konjumba yi te liipu mundumbu.” nimba makó turum yi-nuim Kraisele nu.” niku, niku para siring-na piliipaliinga⸥ yu-ni yu-kene wendu ombá mele pulu monjupa enini ung-bo tonjupa kene nimba mele: “Mania Omba Mana-Yi Au Talurum Yili mindili pulele nombá. Juda-yambuma nokolemele tápu-yima kene, Pulu Yili popu tunjuli yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuli yima kene, enini ⸤niku mele: “Yunu Pulu Yili-ni naa liipa mundurum. Yunu Pulu Yili-nga Málale naa molemú.” niku⸥ yunu úngulu siku, liiku bulu siku yunu toku kunjingí. Yunu toku kunjingí kolumba kene kongun tale omba pumba kene yupuku-sipaliinga yunu lomburupa ola molumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesos yu-kene wendu ombá mele aku-sipa sumbi-sipa nimba para sirim-na piliipa kene Pita-ni yunu anju liipa memba pupa kene ⸤Yesos yu-ni “Na toku kunjingí.” nirimaliinga⸥ yunu pulu monjupa ung-mura sirim. ");
INSERT INTO mux_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Akiliinga-pe ⸤yu-ni kurumanga nuim Seten-ni “I-sikunu i-sikunu niku sinjui.” nimba sirim mele piliipa kene nirimeliinga piliipa kene⸥ Yesos-ni topele topa yunga lumbili andúlima kanupa kene Pita ung-mura sipa yunundu nimba mele: “Seten, nu anju pa! Nu Pulu Yili-ni numanuna piliilimú mele naa piliillu. Yambuma-ni numanuna piliilimili mele mindi piliilláliinga anju pui!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kanu-kene yambu akuna liiku máku toku muluringma pali kene yunga lumbili andúlima kene wasie “Na moliuna wai.” nimba kene eninindu nimba mele: “Yambu te-ni ‘Yu lumbili pambu.’ nimba kene yu-ni yunga numanale-ni piliilimú mélemanga ‘Topu mania mundambu.’ nimba yambuma unji-perana peku mindili noku kolemele mele yu-ni unji-pera mele koma lembandu ‘Na yu lumbili pupu kene mindili nundu lem kapulako; kulundu lem kapulako.’ nimba kene na lumbili upili. We naa upili. ");
INSERT INTO mux_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yambu te-ni ma-koleana yunga kona molupa naa kululi ulu-pulele ambulumba temba kene yu kolupa kene sika molupa kis-sipa mindi pumba. Akiliinga-pe yambu te na numanu monjupa nanga yambale molupa, ‘Yambuma temani kaiéle piliangi.’ nimba enini nimba sipa molumba kene yunu kolupa kene yu kona molupa konjupa mindi puli ulu-pulele sika kanupa liimba. ");
INSERT INTO mux_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","⸤Akili nambimuna nikerye?⸥ Yambu te-ni mana mélema pali yunu liipa nosulka kene yunu mini-kangi pali Pulu Yili naa molumba koleana pupa mindili nomba molupa kis-silkanje méle kanuma-ni yambu kanili nambi-sipa tepa liilkanje? Tepa naa liilkale. ");
INSERT INTO mux_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yambu te-ni ‘Na mini-kangi pali kona molupu konjupu mindi pambu.’ nimba kene yunga nambulka méle te-ni mini-kangi pali kona molupa konjupa mindi puli ulu-pulele taropu topa liilkaye? Méle te-ni kapula taropu topa naa liimba. ");
INSERT INTO mux_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Nanga yambu mare ulu-pulu-kis teku Pulu Yili munduku kelku méle lupama pali bi paka tonjuku molemele yambuma-kene molku kene pipili kolku niku mele: “Oliu Yesos-nga ungma piliipu liipu, yunu lumbili andupu molemulu mele akili we-yambuma-ni naa piliangi.” niku kene na kiyang niku lumbili andolemele yambuma, enini-kene ulu te penga wendu ombá mele akili nimbu sambu: Mania Omba Mana-Yi Au Talurum Yili penga Lapanga tondulu talang puliele kene ⸤mulú-koleana⸥ angkella kake tílima kene ⸤mania⸥ ombá temba kene, we-yambu kanuma mulungína yunga yambuma mokeringa mulungíndu we-yambu mulungíma kanuku kene, yunu ui naa upili ‘Oliu yunga yambuma molemulu mele akili we-yambuma-ni naa piliangi.’ niku pipili kolku mo toku mulungí yambuma yu-ni liipa wekundu kanupa, “Na moliuna naa wai.” nimbáko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesos yu-ni eninindu ung te wasie nimba mele: “Na-ni enindu aima sika nimbu siker: “Eni ya angiliikimilimanga mare ui kulú naa kolangi Pulu Yili yi nuim kingele omba, tondulu mundupa molupa, mélema kene yambuma kene pali nokumba ombá kanungí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yesos-ni ⸤yu lumbili andúlimandu aku-sipa nimba sirim kene⸥ penga kóru te omba purum kene Pita mene Jemis mene Jon mene enini liipa memba pupa mulú aima olandupa pulurum tenga ola purum. ‘Oliu-oliuliu mindi molamili.’ nimba enini akuna liipa memba purum. Akuna puring kene enini kanuku molangi yunga kangiele te-lupa-mele tepa angiliirim, ");
INSERT INTO mux_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yu pakurum mulumbalema ena tondulu topa mongma aima takele telemú mele aku-sipa aima kake tirim. Ya ma-koleana yambu te-ni wale-pakuli te sopele-ni lumaye topa kake tenjimba mele kapula mólu. ⸤Yunga méle panjurum-ma kake tirim mele akili aima lakupa tirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Yunu aku-sipa mulupili, ⸤Juda-yambumanga kórunga-ui muluringli yi auli tale,⸥ Illaija kene Moses-sele okulu Yesos-kene ung nikulu mokeringa angiliiringli kanuring. ");
INSERT INTO mux_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Kanu-kene Pita-ni Yesos-ndu nimba mele: “Rapai, oliu ya molkumulale kapula lam. Oliu-ni lku-takaé yupuku takunjamili. Te nunga, te Moses-nga, te Illaija-nga takunjamili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Akiliinga-pe nirim mele enini pipili lakuku kuluring kilia yu-ni nimbá mele naa piliipa ungele walu-sipa nirim.) ");
INSERT INTO mux_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kanu-kene kupa te omba enini panda turum kene kupana sukundu ung te wendu omba kene nimba mele: “Yi ili nanga numanu monjuliu Málale. Yu-ni ung nimbáma piliiku liangi.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe walsekale, enini mong male-male teku kanuku kene yisele alsuku naa kanuku, Yesos yu-mindi enini-kene mulurum kanuring. ");
INSERT INTO mux_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Komungana mania ungí uring kene Yesos-ni enini ung-mani sipa kene nimba mele: “Eni ekupu kanúngi mele akili isili-ui yambu tiluri kepe niku naa sai. Penga mindi, Mania Omba Mana-Yi Au Talurum Yili kolupa kene alsupa lomburupa ola molumba kene temanele toku anju sangi. Ui mólu!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aku-sipa nirim kene enini yunga ungele piliiku liikuliinga ui anju naa niring akiliinga-pe “yunu “kolupu kene alsupu lomburupu ola molumbu.” nikem ung kaniliinga pulele nambulka ulurindu nikem-nje?” niku eni-enini tombulku niring. ");
INSERT INTO mux_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kanu-kene yu lumbili andúlima-ni ⸤yunu sika mulurum mele kanuku kene⸥ yunundu walsiku niku mele: “⸤Pulu Yili-ni ‘oliu nokupa konjupa tepa liimba.’ nimba makó turum yi-nuim Kraisele nu lem⸥ Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjilimele yima-ni “Illaija ⸤alsupa⸥ kumbi-lepa ombá. ⸤Yi-nuim Kraisele pe aelepa ombá.⸥” nilimele akili nambimuna nilimeleye? ⸤Illaija alsupa naa upili nu kórunga urunu mollu kanili.⸥” niring. ");
INSERT INTO mux_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesos-ni pundu topa nimba mele: “ “Illaija ⸤alsupa⸥ kumbi-lepa omba kene mélema pali tepa mimi temba.” nilimele kanili sika nilimele. Aku lem Mania Omba Mana-Yi Au Talurum Yili kanuku kis piliiku mindili liiku singí mele ⸤Pulu Yili-nga⸥ bukna nambimuna bi turing molemúye? ");
INSERT INTO mux_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Akiliinga-pe ⸤ung akiliinga te kene wasie nimbu siker.⸥ Piliai! Illaija kórunga urum. Yunu urum kene ⸤yi kanuma-ni yu kanuku bi naa siku⸥ ‘yu we-yi te.’ niku piliiku kene ‘yu-kene temulú.’ niku piliiring uluma pali tiring. Yu-kene aku-siku tingí mele ui bukna bi turing molemúko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","⸤Yesos kene yu lumbili anduli yi yupuku kene⸥ enini yunga lumbili anduli yi wema muluringna yandu oku, yambu aima pulele akuna kakapu teku máku toku muluring kanuring. Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima-ni Yesos lumbili anduli yi wema kene ung niku, ung mare walsiku piliiku muluring kanuringko. ");
INSERT INTO mux_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yesos urum kene kanuku kene máku toku muluring yambu kanuma suru lakuku niku yu urumna lkisiku oku yunundu “⸤Auliele,⸥ nu okunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Kanu-kene yu-ni eninindu “Eni ung nambulka ungele tombulku nikimiliye?” nimba walsurum kene ");
INSERT INTO mux_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","máku toku muluring yambu kanumanga yi te-ni pundu topa yunundu nimba mele: “Ung-Bo Tunjuliele, nanga kangale kuru te yunga numanuna molemáliinga ung manda naa nilimú akiliinga nu mullu ⸤nimbu piliipu⸥ membu úndu. ");
INSERT INTO mux_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kurale-ni kangale wale marenga ambulupa kene yu topa mania mundulimú kene keri apapu memba, guma kenu-keru liipa aku telemú. Nu lumbili andúlimandu temani akili topu sipu enini kuru kanili ‘Toku makurangi.’ nimbu mawa tindu akiliinga-pe enini kapula naa tíngi.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aku-sipa nirim-na piliipa kene Yesos-ni yambuma ⸤ung-mura sipa kene⸥ nimba mele: “Ekupu molemele yambuma eni ⸤‘Pulu Yili-ni uluma sika kapula temba.’ niku⸥ tondulu munduku naa piliilimili yambuma, na eni-kene molupu, ena nambi-sili molupu ung-bo tonjupu mani sipu ulu mare liipu ora simbu kene mimi-siku piliingíye? ⸤Na eni-kene enembu tokum.⸥” nimba kene “Na moliuna kangale meku wai.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","kangale yunu mulurumna meku uring. Meku uring kene ⸤kangalenga numanuna mulurum⸥ kurale-ni Yesos kanupa kene kangale topa mania mundurum kene kangale kimbu kima miye mundupa keri apapu mirim. ");
INSERT INTO mux_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aku-sipa tirim-na kanupa kene Yesos-ni kangalenga lapa walsipa nimba mele: “Kangale kuru ili te-kene pulu monjurumuye?” nirim. Lapa-ni nimba mele: “Yunu koela anumu-ni mirim kene aku-sipa tirim. ");
INSERT INTO mux_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ena puleliinga yunu kopari topa tepina topa mundupa, nona topa mundupa telemáliinga nu-ni kapula liiku tapunjuni lem oliu kondu kolkunu liiku tapunjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesos-ni nimba mele: “Nu-ni nambimuna “Kapula liiku tapunjuni mola móluye?” nikinuye? ‘Na-ni nu kapula liipa tapunjumba.’ niku tondulu munduku pilíínu lem uluma pali sika wendu ombá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yesos-ni aku-sipa nirim piliipa kene kangalenga lapa-ni tondulu nangale topa nimba kene nimba mele: “Na-ni ‘sika nu-ni liiku tapunjuni.’ nimbu piliiker akiliinga-pe ‘Sika’ nimbu piliiker ungele tondulu mundupu ambulumbu mele manda naa tekemaliinga ‘Sika.’ nimbu piliiker mele ‘tondulu pupili.’ nikunu liiku tapunjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","⸤Kanu-kene⸥ yambuma kanungíndu lkisiku sukundu-sukundu ungí uring kanupa kene Yesos-ni kurale ung-mura sipa kene nimba mele: “Keri pipi sikunu, kum pipi sikunu tellu kurale, kangalenga numanuna oku wendu pukunu, alsuku aima naa okunu mului. Kamu pui!” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","kurale-ni kangale tondulu topa mania mundurum kene yunu kimbu kima miye mundurum kene kurale ke nimba yunga numanuna wendu urum. Kanu-kene kangale yunu kolupa lirim mele lirim-na kanuku kene yambu pulele-ni “Yu kulum lem.” niring. ");
INSERT INTO mux_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Akiliinga-pe Yesos-ni yunga kili ambulupa kene yunu ola liirim kene ola angiliirim. ");
INSERT INTO mux_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","⸤Kanu-kene Yesos-ni kurale topa makurupa pora sipa kene⸥ lkuna lkundu ⸤yu lumbili andúlima kene wasie⸥ purum kene yu lumbili andúlima enini Yesos kene wasie eni-enini molku kene yunu walsiku piliiku kene niku mele: “Kuru akili oliu-ni nambimuna kapula naa topu makurúmuluye?” niring kene ");
INSERT INTO mux_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesos-ni pundu topa nimba mele: “Ulu ili mele temulundu (langi mi panjupu naa nombu) Pulu Yili-kene popu topu mawa temuláli-ni mindi kapula temulú. We kapula naa temulále.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","⸤Yesos kene yu lumbili andúlima kene⸥ enini kolea akili munduku kelku ⸤yambuma muluring koleama naa puku⸥ kolea Gallalli distrik sumbi-siku oku pungí puring. Akuna pungí puring kene yu lumbili andúlima ung-bo tunjilsiliipa purumeliinga ‘Na lumbili andúlima ung-bo tunjiker mele we-yambuma-ni naa piliangi akiliinga oliu we-yambuma-ni naa kanangi, wasie naa pamili.’ nimba yunu kene yu lumbili andúlima kene eni-enini kiyang niku puring. ⸤Yu-kene penga wendu ombá mele⸥ yu-ni enini ung-bo tunjilsiliipa purum akili i-sipa mele: “Mania Omba Mana-Yi Au Talurum Yili ka siku kene ⸤yu toku kunjingí⸥ yima anju singí kene enini yu toku kunjingí. Kolupa kene kongun yupuku-sipaliinga yunu lomburupa ola molumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Akiliinga-pe yu-ni nirim ungele piliiku sunduku kene ‘Ung ilinga pulele nambulkanje, naa piliikumulu.’ niring akiliinga-pe “Nambulka niku nikinuye?” niku walsiku piliingíndu pipili kolku naa walsiring. ");
INSERT INTO mux_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","⸤Oku kene⸥ kamu Kapeniam taon-na suku uring. Mulungí lkuna lkundu puku muluring kene Yesos-ni yu lumbili andúlima walsipa piliipa kene nimba mele: “Eni kupulanum-na ung nambulka ung te tombulku nilsiliiku úngiye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Akiliinga-pe enini ‘Oliunga yi nae aima olandupa molemúye?’ niku tombulku niku kir-kiri liiringeliinga Yesos-ndu enini niring mele niku para singéliinga ⸤pipili kolku mundu-mong teku kene⸥ molku duma liiring. ");
INSERT INTO mux_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanu-kene Yesos yunu mania molupa kene yu lumbili anduli yi rurepukandu “Na moliuna wai.” nimba kene nimba mele: “Yambu te-ni ‘Yambumanga auliele molumbu.’ nimba kene yunu aima we-yambale molupa yambumanga kongun-kendemande-yambale mulupili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aku-sipa nimba kene kangambula kelú te liipa enini muluringna monjupa kene, kangambula akili yu-ni kanglupa kene eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Yambu te-ni ‘Na Auliele-nga yambale moliu.’ nimba kangambula ili mele liipa tapunjumba kene yambu kanili-ni aku tembaliinga na liipa tapunjumbako. Na liipa tapunjumba yambale-ni na mendepulu naa liipa tapunjumba. Kangambulale liipa tapunjumbaliinga yambu kanili yu-ni na liipa mundurum yili liipa tapunjumbako.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","⸤Yesos lumbili anduli yi⸥ Jon-ni Yesos-ndu nimba mele: “Ung-Bo Tunjuliele, oliu kanúmulu, yi te-ni nunga bili lepa walsipa kuru mare yambumanga numanuna mulúngima “Oku wendu pai!” nimba topa makurupa mulúm kanúmulu. Kanupu kene yunu oliu-kene wasie tapú-topu naa andolemuláliinga yundu “Nu aku-sikunu naa ti!” nímulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aku nirim-na piliipa kene Yesos-ni yundu ⸤yi kanili-ni tirim ulelendu⸥ nimba mele: “Yambu te-ni nanga bi lepa walsipa ulu-tondulu te tepa kene yu-ni alsupa nondupa nandu ung te kapula nimba kis naa simba akiliinga enini yunundu “Mólu!” naa niai. ");
INSERT INTO mux_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yambu te oliu-kene ele-tu naa molemú yambale oliunga ele-lkeramale molemú kanili.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Na-ni enindu aima sika nimbu siker: “Eni no waka lemba kene yambu te-ni ‘Eni yi-nuim Kraisele-nga yambuma molemeláliinga no te nangi kolupu sambu.’ nimba eni te kolupa símu lem, yi-nuim Kraisele-nga kongun tinjingí yambuma yu-ni méle kalomba kene yambu kanili kepe apera naa sipa, yu numanu liipa mundupa méle kalombako.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Yambu te-ni kangambula ilinga ⸤mele yambu⸥ te na ‘Sika’ nimba tondulu mundupa piliilimú kangambulale ‘Ulu-pulu-kisma tipili.’ nimba kundi tombaliinga kangambula kanili-ni tondulu mundupa piliilimú mele mundupa kelepa liipa bulu símu lem ⸤kangambula ui kundi naa tupili⸥ yi kanili ku-mulú aima auli te moku toku numina lenjiku ‘Yu kamu kulupili.’ niku paka toku no-numúna aima mania mundulkemelanje aima kapula. ⸤Aku-siku toku mundulkemela kene yunu kolupa kene penga Pulu Yili-nga kangambula te-ndu ‘Ulu-pulu-kisma tipili.’ nimba kundi kapula naa tolka. Akiliinga-pe yunu aku-siku no-numúna naa toku mundulkemela kene yu yambuma kundi tombaliinga yunu Pulu Yili-kene mong auli te pelkaliinga enini yu no-numúna kapula paka toku mundulkemela.⸥ ");
INSERT INTO mux_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","“Nunga ki-sele-ni ulu-pulu-kis te tímu lem ki akusele kari lekunu wendu mundui. Nu kona mololsiliikunu mindi puni koleana ki-sele naa angiliipili puni kene kapula. Nunga ki tale we angiliipili nu tepi-koleana, (‘akuna Pulu Yili teku kis-silimele yambumanga koruwama kulú naa kolupa nolsiliipa mindi pulimú, tepi toku kumunjui naa kumunjulimele kolea’) akuna suku toku mundungí kene kis. ");
INSERT INTO mux_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Mola nunga kimbu-seleni ulu-pulu-kis te tímu lem kimbu akusele kari leku wendu mundui. Nu kona mololsiliikunu mindi puni koleana kimbusele naa angiliipili puni kene kapula. Nunga kimbu tale we angiliipili nu tepi-koleana, (‘akuna Pulu Yili teku kis-silimele yambumanga koruwama kulú naa kolupa nolsiliipa mindi pulimú, tepi toku kumunjui naa kumunjulimele kolea’) akuna suku toku mundungí kene kis. ");
INSERT INTO mux_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","“Mola nunga mongsele-ni méle te kanukunu kene numanale-ni ‘liambuka.’ nikunu piliikunu ulu-pulu-kis te tinu lem mong akusele ukuku wendu mundui. Nu Pulu Yili yi nuim kingele molupa nokulemú koleana mongsele naa angiliipili puni kene kapula. Mong tale we angiliipili nu tepi-koleana, ‘akuna Pulu Yili teku kis-silimele yambumanga koruwama kulú naa kolupa nolsiliipa mindi pulimú, tepi toku kumunjui naa kumunjulimele kolea’ akuna suku toku mundungí kene kis. ");
INSERT INTO mux_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Yambuma-ni Pulu Yili popu toku kalemele mélema singíndu ‘Pulu Yili-ni kanupa kene ‘Langi kake tílima.’ nimba kanupili.’ niku api-kusa munduku kene silimele aku-siku mele yambuma mulungína tepéle, api-kusa mele, yambuma kene pali wendu ombá. ");
INSERT INTO mux_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Api-kusa méle kaiéle akiliinga-pe yu sungu naa temba kene ‘Yunu alsupa sungu tipili.’ niku ulu te kapula telemeleye? ⸤Api-kusa langimanga mundulimele kene sungu telemú aku-siku⸥ eni api-kusa mele molku yambuma kene anju-yandu numanu tiluna pupili táka-niku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kanu-kene Yesos mulurum koleale mundupa kelepa kolea Judia distrik pupa no Jodan lumbiliipa nekendu purum. Kanu-kene alsuku yambu pulele yu mulurumna oku máku turing kene, taki-taki aku tiring kene yu-ni yambuma ung-bo tonjupa mani sirim mele máku turingima alsupa ung-bo tunjurumko. ");
INSERT INTO mux_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Perisi-yi mare yu mulurumna oku ‘Yunu nambulka nimbánje? Nimba kis-simbanje manda lepu piliamili.’ niku yunu walsiku piliiku niku mele: “Yi te-ni yu-yunu piliipa kene yunga ambale “Kamu pui.” nimbá kene kapula temba mola aku temba kene ung-mani te topa pula tombaye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yu-ni anju pundu topa nimba mele: “Moses-ni ulu akilindu ung-mani sipa nambulka nirimye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Enini niku mele: “Moses-ni nimba mele: “Yi te-ni yunga ambalendu ‘Kamu pupili.’ nimba makorombandu ambale “Kamu pui.” nimbá akili pepá tenga topa ambale sipa kene yunundu “Kamu pui.” nimba aku tipili.” nirim.” niring. ");
INSERT INTO mux_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesos-ni nimba mele: “Moses-ni sika aku-sipa bukna turum akiliinga-pe eni kara puku Pulu Yili-ni ambu-yisele kapula-kapula mulunglí mele ung-mani sirimele liiku su siku naa piliiringeliinga yu-ni “Aku-siku teai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Akiliinga-pe ui-pulu-pulu Pulu Yili-ni mélema tepa kene yu-ni yambu tembandu yili kene ambale kene tirim. ");
INSERT INTO mux_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Aku-sipa tirimeliinga yi te-ni ambu te liipa kene yunga anum lapasele mundupa kelepa yunga ambale kene elsele tiluna tapú-toku pekulu, ");
INSERT INTO mux_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","kangi tiluele mele ⸤molkulu elsengla numanu tiluna pupili⸥ mulunglí.’ Yi te ambu te liilimú kene kangi tiluele mele molembeláliinga elsele alsuku tale mele naa molembele, elsele yambu tiluele mele molembele. ");
INSERT INTO mux_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yambu tiluele molembele akiliinga Pulu Yili-ni ambu-yi tale ‘Tiluele molangli.’ nilimú ambu-yisele yambu te-ni liiku lupa-lupa naa mundangi. Aku tíngi lem kapula naa temba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Alsuku lkuna lkundu puku muluring kene yu lumbili andúlima-ni Yesos yunundu ung akiliinga pulele walsiku piliiring kene ");
INSERT INTO mux_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","yu-ni eninindu pundu topa nimba mele: “Yi te-ni yunga ui liilimú ambale makurupa “Kamu pui.” nimba kene alsupa ambu te liilimú kene yi akili-ni waperanale tepa, ui liilimú ambale tepa kis-silimú. ");
INSERT INTO mux_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mola ambu te yunga ui pulimú yili mundupa kelepa wendu pupa yi te pulimú kene ambu akili-ni waperanale telemúko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kanu-kene yambuma-ni eninga kangambulama ‘Yesos yunga kili-ni ambulupili.’ niku yunu mulurumna meku uring kanuku kene Yesos lumbili andúlima-ni ung-mura siku ⸤“Naa meku wai!”⸥ niring. ");
INSERT INTO mux_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","⸤“Mólu.” niring-na⸥ kanupaliinga Yesos-ni numanu kis panjipa ⸤yu lumbili andúlima⸥ eninindu nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú yambu-talape akili kangambula ima mele molemele akiliinga enini kangambula ima na moliuna wangi pipi siku “Mólu.” naa niai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Na-ni enindu aima sika nimbu siker: “Kangambolama-ni ‘Pulu Yili oliunga yi nuim kingele mulupili.’ niku molemele mele aku-siku naa nilimele yambuma yunga koleana sukundu aima naa pungí, mólu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Akili nimba kene yu-ni kangambulama kanglupa yunga kili-ni enini tilu-tilu nimba pengimanga ambulupa enini membu panjipa “Pulu Yili-ni “Eni molku konjangi.” nipili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kanu-kene Yesos ola angiliipa kolea marenga pumba purum kene yi te yu pumba purumna lkisipa omba yunga kumbi-kerina koporungu langupa yunundu walsipa piliipa kene nimba mele: “Ung-Bo Tunjuliele Yi-Kaiéle, na nambulka ulu te tembu kene na kona molupa konjupa mindi puli ulu-pulele liimbuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesos-ni yunundu nimba mele: “Nu-ni na nambimuna “Kaiéle” nikinuye? Yambu kaí te naa molemú. Pulu Yili mindi kaiéle.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","⸤Aku-sipa nimba kene yili-ni walsurumeliinga pundu topa nimba mele:⸥ “Nu ⸤Pulu Yili-nga⸥ ung-manima ⸤Moses-ni piliipa yandu nimba sirim-ma⸥ piliillu. ⸤Ung-mani akuma i-sipa mele⸥: “Yambu toku naa konjai.” nimba, “Ambu yi púlima mola yi ambu líílima yambu lupama kene waperanale naa teai.” nimba, “Mélema wa naa liai.” nimba, “Yambuma kot gólu toku naa tenjai.” nimba, “Yambumanga mélema gólu toku we naa liai.” nimba, “Aminiali-laniali-kene liiku ai siku, ung ningí mele piliiku liiku teku molai.” nimba, ung-mani akuma sirim molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aku nirim-na piliipa kene yi kanili-ni nimba mele: “Ung-Bo Tunjuliele, na kang-kene molupuliinga ung-mani akuma pali piliipu liipu tepu mulurundu mele ekupu yandu-yandu tepu-ko moliále.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesos-ni yunu nem-nemi nimba kanupa numanu monjupa kene yunundu nimba mele: “Papu tellu akiliinga-pe ulu tilu mindi naa tellu. Nu pukunu nunga méle nosulluma pali ku-moni liikunu kene, ku-moni liiníma yambu-korupama moke teku sikunu kene na lumbili ui.” nirim. “Nunga ⸤mána-⸥mélema aku tiní kene mulú-koleana nunga méle lupa-lupa kaí pulele lemba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yi kanili méle aima lupa-lupa kaí pulele nusurumeliinga Yesos-ni yunundu aku nirim-na piliipa kene yunu kumbi-keri tepa numanu kis panjilsiliipa anju purum. ");
INSERT INTO mux_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","⸤Aku tirimeliinga kanupa kene⸥ Yesos topele topa yunga lumbili andúlimandu nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu yambu-kamakoma aima mindili siku sukundu pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ung akili nirin⸤-na piliiku kene⸥ yu lumbili andúlima-ni mini-wale munduring. Akiliinga-pe Yesos-ni alsupa eninindu nimba mele: “Kangma, Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu yambuma aima mindili siku pungí. ");
INSERT INTO mux_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kung-kemel akili ⸤kung aima auli te akiliinga-pe⸥ kalé suruli kupulanum-na sukundu pumbandu mindili laye-kolte mele sipa kene pumba. Akiliinga-pe yambu-kamakoma Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu mindili aima lakuku mele siku pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","⸤Aku nirim-na piliiku kene⸥ yu lumbili andúlima aima mini-wale munduku suru niku anju-yandu tombulku kene niku mele: “Aku lem penga kamu mindili nolkemela kupulanum-na nae kapula wendu pupa, molupu konjupu mindi pumulú kupulanum-na pumbaye? Te mólunje?” niring. ");
INSERT INTO mux_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesos-ni enini nem-nemi nimba kanupa kene nimba mele: “Sika yambuma eni-enini kapula mólu, akiliinga-pe Pulu Yili-ni kapula tenjimba. Pulu Yili yu-ni uluma pali kapula telemú. Ulu te yu-ni kapula naa temba te mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Yu-ni aku nirim-na piliipa kene Pita-ni yunundu nimba mele: “⸤Pe oliu-kene nambulka ulu te wendu ombáye?⸥ Oliu oliunga mélema pali mundupu kelepu nu lumbili purumulu mele pulimulu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesos-ni nimba mele: “Na-ni enindu aima sika nimbu siker: “Yambu na numanu monjuku nanga kongun tenjiku temani-kaiéle toku silsiliiku andungíndu eninga lkuma kene, anginipilima kene, kimulupili kene, anupili kene, lapaliima kene kangambulama kene, koleama kene, akuma munduku kelemele yambuma pali ");
INSERT INTO mux_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ya ma-koleana aima méle pulele ola-kilia liiku kene, penga pungí koleana kona molku konjuku mindi puli ulu-pulele liingíko. Ya ma-koleana lkuma kene, anginipili, kimulupili, anupili, kangambulama, koleama kene, akuma pali pulu-kilia ola munduku liingíko; ⸤na numanu naa munjingí yambuma-ni⸥ enini mindili singíko.” niker. ");
INSERT INTO mux_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akiliinga-pe ekupu auli molemele yambumanga pulele penga ⸤Pulu Yili yi nuim kingele molupa nokumba koleana⸥ yambu-korupama mulungí; ekupu korupa pupili molemele yambuma penga yambu-aulima mulungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Kanu-kene ⸤Yesos kene yu lumbili andúlima kene⸥ enini kolea-auli Jerusallem pungí puring. Yesos kumbi lirimna lumbili andúlima aima numanu pulele liiku mundulsiliiku yunu lumbili puring. We-yambu aeleku lumbili uringma kepe mini-wale munduku mundu-mong telsiliiku puring. Yesos-ni ⸤yu lumbili anduli⸥ yi engkaki-rurepukandu ‘na kene oliuliu molamili.’ nimba enini liipa anju memba pupa kene, yu-kene wendu ombá mele alsupa pulu monjupa nimba sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Piliai. Oliu Jerusallem pumulú pukumulu. Akuna pumulú kene Mania Omba Mana-Yi Au Talurum Yili yi te-ni ‘Tangi.’ nimba Pulu Yili popu tunjuli yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuli yima kene, liipa simba. Yi kanuma-ni yu kot tenjiku piliiku kene ‘Yu kulupili toku konjangi.’ niku Juda-yi naa molemele yi-lupama liiku singí. ");
INSERT INTO mux_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kanu-kene yi-lupa kanuma-ni yu ung-taka tonjuku yunga kumbi-kerina lkambe toku yu ka-pulsa-ni toku yu toku kunjingí. Yunu toku kunjingí kene kongun yupuku-sipaliinga lomburupa ola molumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kanu-kene Seperi-málu Jemis kene Jon-sele elsele Yesos mulurumna okulu kene nikulu mele: “Ung-Bo Tunjuliele, nu-ni ‘Olsu ulu te teani.’ nimbu mawa tembulú okumbulu.” niringli. ");
INSERT INTO mux_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yu-ni elselendu nimba mele: “Nambulka ulu te ‘na-ni else-kene tenjambu.’ niku nikimbiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Elsele-ni pundu toku nikulu mele: “Nu penga nunga kolea tondulu talang púlina ⸤yi nuim kingele molkunu kene, ‘olsu nu-kene wasie yi-nuimima molamili.’ nikunu⸥ ‘olsu te nunga ki-bokundu monjukunu te nunga ki-tarukundu monjani.’ nimbu mawa tekembulu.” niringli. ");
INSERT INTO mux_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesos-ni elselendu nimba mele: “Mawa tekembele mele else piliikulu naa kongnjukumbele. Na no-mingina no nombále else kapula nunglíye? Mola na no liimbále else kapula liingíye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Elsele-ni yunundu pundu toku nikulu mele: “Kapula tembulú.” niringli. Yu-ni elselendu nimba mele: “Na no-mingina no nombále penga else sika nunglíko. No liimbále penga sika liinglíko. ");
INSERT INTO mux_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Akiliinga-pe na-ni else “Nanga wangu-selenga oku molangli.” nimbále kapula naa temba. ⸤Pulu Yili-ni yunu⸥ akuna mulunglí-sele kórunga makó turum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jemis Jon-seleni ⸤‘Yesos-nga wangu-selenga molambili.’⸥ nikulu mawa tiringli akili piliiku kene lumbili anduli yi rurepunga tale wema-ni elsele-kene numanu kis piliiring. ");
INSERT INTO mux_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanu-kene Yesos-ni lombili andúlimandu “Wai.” nimba kene, eninindu nimba mele: “Oliu Juda-yambumanga ulsukundu molemele yambu-talapemanga yi-nuimima eninga yambuma tondulu munduku nokuku kongun tondulu púlima taki-taki liiku silimele. Yi bi molemú yima eninga yambuma ‘Mindili nangi.’ niku lakuku nokolemele. ⸤Yambuma-ni eninga yi-nuimimanga ungma liiku su singí kupulanum te naa lelemú akili⸥ eni piliilimili. ");
INSERT INTO mux_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Akiliinga-pe ⸤we-yambumanga yi-nuimima-ni eninga yambuma tondulu munduku nokolemele mele na lumbili anduli yima⸥ eni-enini aku-siku anju-yandu naa teangi. Eninga yi te ‘Na bi ola mulupili. Na yi-auliele molambu.’ nimbá yili eninga kongun tinjili yili mulupili. ");
INSERT INTO mux_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","‘Na eninga yi-nuimele molupu eni nokambu.’ nimbá yili eninga pali kongun kendemande tinjili yili mulupili. ");
INSERT INTO mux_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aku-sipako, Mania Omba Mana-Yi Au Talurum Yili kepe ‘Yambumanga yi-auliele molupu eni nokambu. Eni nanga kongun-kendemande-yambuma molangi.’ nimba naa urum. ‘Yambumanga kongun-kendemande-yili molupu, eni tepu liipu, ulu-pulu-kismani enini ka sipa nokulemú mele naa nokopili kapula molku konjangi akiliinga na yambu puleliinga nimbu pundu tonjupu nanga kangiele sipu, alko topu kolunjambu.’ nimba urum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kanu-kene Yesos kene yunga lumbili andúlima kene enini kolea-auli Jeriko uring. Oku kene enini kene we-yambu pulele kene Jeriko munduku kelku pungí puring kene mong kis lirim yi te, yunga bili Ba-Timias, (akiliinga pulele Timias-málu), kupulanum alsena molupa yambuma “Ku-moni sai.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kolea Nasaret yi Yesos omba purum akili piliipa kene mong kis lirim yili yu-ni pulu monjupa tondulu nangale topa walsipa kene nimba mele: “Yesos, ⸤yi nuim king⸥ Depit-ni kalupa liirim yili, na kondu kului!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yambu pulele-ni yunu ung-mura siku “Nu ung naa nikunu táka-niku mului!” niring. Akiliinga-pe yu-ni aima tondulu nangale topa walsipa kene nimba mele: “Depit-ni kalupa liirim yili, na kondu kului!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesos we angiliipa kene “Yunu upili niai.” nirim. Aku-sipa nirimeliinga enini mong kis lirim yili walsiku kene niku mele: “Yu-ni “Nu ui.” nikem-na numanu waengu sikunu ola angiliikunu oku pui.” niring. ");
INSERT INTO mux_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yunu lkisipa wale-pakuli olandu pakurumele posupa nosupa ola angiliipa Yesos mulurumna urum. ");
INSERT INTO mux_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesos-ni yunundu nimba mele: “Na-ni nu nambulka tenjambu niku piliikunuye?” nirim kene mong kis lirim yili-ni nimba mele: “Raponai, na mongale-ni mélema kanambu nanga mongsele teku kaí tenjani.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesos-ni nimba mele: “‘Na-ni nunga mongsele kapula tenjimbu.’ niku pilííneliinga nunga mongsele kaí lekemeliinga pui.” nirim. Yesos-ni aku nirim kene yunga mongsele enaliinga kaí lirim, mélema kanupa kene, Yesos purum kupulanum-na lumbili purum. ");
INSERT INTO mux_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","⸤Yesos kene yu lumbili andúlima kene⸥ enini kolea-auli Jerusallem nondupa oku, ma-pangi te ‘Ma-Pangi Unji-Ollip Punie’ nili akuna kolea-kelú tale, Betepas kene Betani kene akuselenga uring. Kanu-kene Yesos-ni yu lumbili anduli yi tale liipa mundupa, ");
INSERT INTO mux_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","elselendu nimba mele: “Ne kolea-kelú kanukumbele akuna pukulu kene kung-dongki walú te, yambu te yunga bulu-mingina ui wale te kepe naa molku anduringele ka teku panjingéle nena sukundu molumba kanunglí, akili puku posukulu yandu meku wangli pale. ");
INSERT INTO mux_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Pusinglí tekulu mulunglí kene yambu te-ni elsendu “Akili nambimuna tekembeleye?” nim lem else-ni i-siku niangli: “Auliele yunu-ni ‘Kung-dongkele mipili.’ nimu-na ombu liikimbulu. Yunu dongki-walále alsupa nondupa yandu liipa mundumba.” niale.” nimba elsele liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Liipa mundurum yisele pukulu, kung-dongki walú te, lku-keri-puluna ka teku panjiringele kanukulu kene kung kanili puku posiku liiringli. Aku-siku tinglí tiringli kanuku kene ");
INSERT INTO mux_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","akuna muluring yambu mare-ni elselendu “Kung-dongki walále nambimuna posukimbiliye?” niku walsiring kene ");
INSERT INTO mux_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","elsele-ni, Yesos-ni ‘i-siku i-siku niale.’ nirim mele niringli kene “Kapula, ⸤dongki-walále⸥ meku pale.” niring. ");
INSERT INTO mux_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kanu-kene elsele-ni kung-dongki walále Yesos mulurumna meku okulu kene, elsengla mulumbalema posukulu, dongkeliinga bulu-mingina ola pauwa tunjuringli kene Yesos kanuna ola mulurum. ");
INSERT INTO mux_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yambu pulele-ni eninga mulumbalema posuku yu ombá kupulanum-na pauwa tolsiliiku puku, mare-ni unji-yala puniena puku yala-gomú languku liiku yu ombá kupulanum-na pauwa tolsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kumbi-leku puring yambuma-ni kepe aeleku puring yambuma-ni kepe unji ambululiiku puku kene niku mele: “‘Yunga bili ola mulupili.’ niamili. ‘Pulu Yi Yawe-ni liipa mundurum-na yunga kongunale tenjimba okum yili molupa kunjupili!’ ");
INSERT INTO mux_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oliunga anda-kolepa yi nuim king Depit⸤-ni kalupa liirim yili⸥ yi nuim king molumba tekem yili Pulu Yili-ni tepa konjupa ‘Yunu tondulu pupili.’ nipili. Mulú-koleana ola yunga bili ola pípili!” nilsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Kanu-kene Yesos Jerusallem sukundu pupa kene Pulu Yili popu toku kaluring lku-tembolluna sukundu pupa akuna ⸤teku muluring uluma⸥ pali kanurum, akiliinga-pe kolea kalá turum kilia kanupa kene ⸤‘Isili-ui ulu te naa teambu.’ nimba⸥ yu lumbili anduli yi rurepu kene ⸤Jerusallem⸥ ulsukundu puku, kolea-kelú Betani ⸤pingí⸥ puring. ");
INSERT INTO mux_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ipulam-ui ⸤Jerusallem nondupa lirim⸥ kolea-kelú Betani munduku kelku kene ⸤kelku Jerusallem pungí puring kene⸥ Yesos yunu engle turum. ");
INSERT INTO mux_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kanu-kene unji-pik te gomú tepa angiliirimele sulu tepa kanupa kene ‘Mong te túmunje.’ nimba nondupa pupa kanurum akiliinga-pe, pik-mong tuli kaliimbele ui wendu naa urumeliinga unji-mong te topa naa pirim, gomú mindi tirim kanurum. ");
INSERT INTO mux_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","⸤Gomú mindi tirim-na⸥ kanupa kene “Nu alsukunu yambuma-ni nungí mong te naa tani!” nirim. Aku nirimele yu lumbili andúlima-ni piliiring. ");
INSERT INTO mux_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusallem kamu uring kene Yesos yunu Pulu Yili popu toku kaluring lku-tembolluna ⸤“Juda-yambu naa molemele yambuma ‘Pulu Yili popu tamili.’ niku máku tolemele kolea” niring akuna⸥ suku pupa kanupa kene akuna mélema maket teku muluring yambuma kene, mélema taropu toku liiku muluring yambuma kene, akuma kanupa kene enini pali topa makurupa, ku-moni lupa-lupama koki teku anju siring yambumanga poluma kene, kera-waembonu maket teku mania muluring poluma kene, topa kongndupa bulu-bale sipa kene, ");
INSERT INTO mux_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","yambumandu nimba mele: “Yambuma méle maket kolea tenga tingí pungíndu lku-temboll palana naa pai. ⸤Bulkundu anwali teku pai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Enini mani sipa kene nimba mele: “Pulu Yili-nga bukna ung te i-sipa nilimú: ‘Yambuma-ni nanga lkulindu “Koleamanga pali yambu-talapema-ni Pulu Yili-kene popu topu ung nilimulu lkuli.” ningí.’ ung kanili eni naa piliilimiliye? Ung aku-sipa molemú akiliinga-pe eni lku ili ‘wa nolemele yambuma mo toku molemele lkuli’ mele niku piliiku kene aku-siku telemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesos-ni akili nirim-na piliiku kene Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, enini yu toku kunjingí kupulanum te kururing. We-yambuma yu-ni mani sipa ung-bo tunjurum mele piliiku kene mini-wale munduring-na kanuku kene Juda-yambumanga yi-auli kanuma-ni yu-kene mundu-mong tenjiku yu toku kunjingí kupulanum te kururing. ");
INSERT INTO mux_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Penga ipinjali, kolea kalá tomba tirim kene kolea-auli ⸤Jerusallem⸥ ulsukundu pupa ⸤tenga-lupa pemba purum⸥. ");
INSERT INTO mux_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ipulele-ui, ⸤unji-pik angiliirim koleana⸥ oku puku kene unji-pik kanili kamu pulu pali kulurum kanuring. ");
INSERT INTO mux_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aku-sipa tirim mele Pita-ni kanupa kene ⸤Yesos-ni unjelendu bonongukundu nirim akili⸥ kelepa piliipa kene yunundu nimba mele: “Rapai, kána! Unji-pik ili nu-ni ⸤bonongu⸥ ung-mura sinu unji kanili ⸤walsekale⸥ kulum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesos-ni pundu topa nimba mele: “Pulu Yili-ni nanga ungele sika piliimba⸤liinga nimbú mele ‘Aima sika wendu ombá.’ niku⸥ tondulu munduku piliai. ");
INSERT INTO mux_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na-ni eni aima sika nimbu siker: “Yambu te-ni ‘na-ni nimbú mele aima sika wendu ombá.’ nimba numanu tale tepa naa pípili ne ma-pangielendu “Ungú tokunu numú-kusana sukundu pui!” nimbá kene yunu nimbá mele aima sika wendu ombá.” niker. ");
INSERT INTO mux_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Akiliinga eni i-sipu nimbu sambu: “‘Oliu ⸤Pulu Yili-ni aima sika liipa tapunjumbaliinga ‘Teamili.’ nimulú mele sika kapula aku-sipu temulú.’ mola ‘Nimulú kene sika aku-sipa wendu ombá.’ niku⸥ tondulu munduku piliiku kene Pulu Yili-kene popu toku ung niku mawa tingí mele pali Pulu Yili-ni sika tenjimbaliinga ulu kanuma sika wendu ombá.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“‘Ulu-pulu-kis tímuluma oliunga Lapa mulú-koleana molemále-ni ‘We mania pupili, kanupu konde tenjambu.’ nipili.’ niku, ⸤Pulu Yili⸥ yunu-kene popu toku ung niku angiliiku kene yambuma-ni eni teku kis-singéliinga numanu kis panjiku mulungí uluma ‘We mania pupili. Kanupu konde tenjamili.’ niangiko. ");
INSERT INTO mux_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(Akiliinga-pe yambuma-ni eni teku kis-singí uluma ‘We mania pupili.’ niku kanuku konde naa tinjíng lem eninga Lapa mulú-koleana molemále-ni kepe eni ulu-pulu-kis tingíma ‘Mania pupili.’ naa-ko nimba kanupa konde naa-ko tenjimba.)” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusallem alsuku uring kene Yesos yunu lku-temboll lku-suku andurum kene yi mare, Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambumanga tápu-yima kene, ");
INSERT INTO mux_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","enini oku yunu walsiku piliiku kene niku mele: “Nu namba nambulka nambale liikunu kene kongun ili telluye? Nae-ni kongun ili ‘Ti-pui.’ nimba nu nambale sipa liipa mundurumye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesos-ni eninindu pundu topa nimba mele: “Na-ni eni ung te walsipu piliambuko. Pe na-ni eni walsimbu mele eni na sumbi-siku pundu toku níngi lem ‘Na kongun ili teambu.’ nimba namba sirimeliinga pulele eni nimbu simbuko. ");
INSERT INTO mux_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","⸤Na-ni i-sipu eni walsiker:⸥ Ui ⸤No-Liinjili⸥ Jon omba yambuma no liinjirim kene yunu mulú-koleana ⸤molemú yilinga⸥ kongunale tenjimbandu yambuma no liinjirim mola ya mana-yambumanga kongunale tenjimbandu yambuma no liinjirimuye? ⸤Nae-ni “Ti.” nirim-na tirimuye?⸥ Niku sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","⸤Yu-ni aku-sipa walsurum mele piliiku kene⸥ eni-enini tombulku kene niku mele: “Yu-ni walsikim mele oliu-ni pundu topu, ‘⸤Jon⸥ yunu mulú-koleana ⸤molemú yilinga kongunale tenjimbandu yambuma no liinjirim⸥.’ nímulu lem yu-ni oliundu nimba mele: ‘Aku lem eni Jon-ni nirim ungele nambimuna ‘Ung ili sika.’ niku naa piliiku liiringiye?’ nimbá. ");
INSERT INTO mux_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mola oliu-ni nimbu mele: ‘Yu mana-yambumanga ⸤kongunale tenjimbandu yambuma no liinjirim⸥.’ nímulu lem “We-yambuma-ni oliu tungínje.” niku aku-siku ningíndu mundu-mong tiring. We-yambuma-ni ‘⸤No-Liinjili⸥ Jon yu aima sika Pulu Yili-ni “Ninjui!” nimba, nimba sirimu ungma piliipa yambuma nimba sirim yi te mulurum.’ niku piliilimili akiliinga oliu nambi-temulúnje?” niku enini aku-siku tombulku niring. ");
INSERT INTO mux_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","⸤Eni-enini aku-siku anju-yandu tombulku niku kene⸥ , Yesos-ndu pundu toku niku mele: “⸤Nu-ni walsikenu mele⸥ oliu naa piliikumulu.” niring. Aku-siku niring-na piliipa kene Yesos-ni eninindu nimba mele: “Kapula. ⸤Na-ni eni walsiker ungeliinga ung te pundu toku naa nikimilieliinga⸥ eni na walsikimili ungeliinga ung te pundu topu, nandu kongun ili ‘Ti-pui.’ nimba na liipa mundupa namba sirim yilinga bili eni naa nimbu simbuko.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Walse Yesos-ni ⸤Juda-yambumanga yi-aulimandu⸥ ung-ekuma enini topa simbandu ung-eku te i-sipa turum: “Yi te-ni unji-waen punie tepa kene pala tirim. Unji-waen-mong kambiliipa nami-nami sipa no-waen monjumbandu puniena sukundu luikolu te ukupa tepa mimi tepa kene, penga punie nukungí lku-takaé te polu kulupa ola takurum. Yi mare kanupa liipa kene eninindu nimba mele: “Nanga puniele tápu tenjiku unji-monguma lkeku nokunjangi. Penga waen-mong polu tomba kene monguma moke tepu, kongun tinjingí méle-mare eni liangi, méle-mare na liambu.” nimba punie kanili enini sipa kene yu kolea ⸤sulu⸥ tenga pupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kanu-kene penga waen-mong polu tomba tirim kene punie pulu yili-ni yunga kendemande-yi te liipa mundupa “Nanga waen-mongma sangi pukunu liiku menjiku wani pui.” nimba punie nukuring yima muluringna liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akiliinga-pe kendemande-yili ⸤urum kene⸥ punie nukuli yima-ni yunu ambolku liiku kimbulú-ni toku waen-mong mare naa siku “Anju we pui.” niku liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Alsupa punie pulu yili-ni kendemande-yi te liipa ⸤“Nanga waen-mongma liinji-pui.” nimba liipa⸥ mundurum. Akiliinga-pe yunu ⸤urum kene⸥ punie nukuli yima-ni yunu ambolku liiku kene toku pengale toku siku yunu teku kis-singíndu ‘Pipili kulupili.’ niku ulu kis mare tiring. ");
INSERT INTO mux_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Alsupa punie pulu yili-ni kendemande-yi te liipa mundurum kene enini yunu toku kunjuring. Alsupa kendemande-yi mare pulele wasie liipa mundurum, akumanga mare wale pulele kimbulú-ni lakuku toku, mare toku kunjuring. ");
INSERT INTO mux_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Kanu-kene punie pulu yili yunga yi tiluele mindi mulurum, yunga málale, yunu numanu munjurum kangale. Yu-ni ⸤numanale-ni piliipa kene⸥ ‘ ‘Nanga kangale’ niku pipili kolku liiku ai siku, yu waen-mong mare singí.’ nimba piliipaliinga yunga málale kamu liipa mundurumko. ");
INSERT INTO mux_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Akiliinga-pe punie nukuli yima-ni punie pulu yilinga málale ombá urum kanuku kene eni-enini niku mele: “Andi okum yili penga lapanga moya-méle simbama liimba yili okum. Yu topu konjupu punie ili oliu kamu liamili.” niku kene ");
INSERT INTO mux_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","enini yunu ambolku liiku toku konjuku ⸤yunga ónale⸥ puniena toku ulsukundu munduring.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","⸤Yesos-ni ung-eku akili topa pora simbandu Juda-yambumanga yi-auli kanumandu walsipa kene nimba mele:⸥ “Punie nukuli yima-ni aku-siku tiringeliinga penga punie pulu yili-ni enini-kene nambulka ulu te tembaye? Yu omba yi kis kanuma topa konjupa kene ‘Yi mare-ni lupa puniele nokunjangi.’ nimba liipa simba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","⸤Yesos-ni Pulu Yili-nga Juda-yambuma nukuring yima-ni yunu toku kunjingí mele piliipa kene eninindu nimba mele:⸥ “Pulu Yili-nga bukna sukundu ung-mani te kanuku naa piliilimiliye? ⸤Ung akili i-sipa mele:⸥ ‘Lku takuring yima-ni ku-mulú te kanuku kis piliiku toku munduku kiliring ku-mulú kanili ekupu alsupa lku-paka-sum mele lku tepa tondulu munduli ku-mulú auli kaiéle.’ ");
INSERT INTO mux_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","‘Auliele-ni ulu akili tirimele oliu-ni kanupu aima kaí piliilimulu.’ nimba molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","⸤Juda-yambumanga yi-auli kanuma⸥ Yesos ung-eku turum kanili piliiku kene enini yunu toku kunjingí teku muluring akili yu-ni nirim piliiku kene enini yu ka singí tiring akiliinga-pe yi-auli kanuma-ni we-yambuma mundu-mong tenjikuliinga yu liiku ka naa siring. Yunu munduku kelku puring. ");
INSERT INTO mux_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Penga walse ⸤Juda-yambumanga yi-aulima-ni⸥ Perisi-yi mare kene yi nuim king Erot-nga talapena yi mare kene liiku máku toku, “‘Yesos-ni ung te nimba kis-sipili. Nimba kis-simba kene yunu tepu kis-samili.’ niku i-siku yundu niangi.” niku Yesos mulurumna liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Liiku munduring yima-ni Yesos mulurumna oku yunundu niku mele: “Ung-Bo Tunjuliele, oliu piliilimulu, ‘Nu-ni ung-sikama mindi nikunu, nu yambu tiluringa kepe numanu kimbu naa sikunu, yambuma mundu-mong naa tenjiku eninindu pali ung tilu-siku nikunu sikunu, Pulu Yili-ni “Teai.” nilimú uluma aima sika-ungma mani siku ung-bo tonjukunu, aku-siku tellu.’ nimbu piliilimulu. ⸤Aku-siku tekunu molláliinga nu nambulka niku piliikunuye?⸥ Oliu-ni Rom-Gapman-Yi Aima Auli Kumbina Sisale ku-moni-takis túmulu lem kapula mola móluye? Yunu ⸤ku-takis⸥ simulú mola naa simulúye? Pulu Yili-ni akilindu ung-mani sirim ung-manele nambulka nimba pelemúye? Nikunu si.” niring. ");
INSERT INTO mux_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Akiliinga-pe Yesos-ni enini topele-mapele tuli yima molemele mele piliipa kene eninindu nimba mele: “‘Yu-ni nimba kis-sipili.’ niku nambimuna na manda leku gólu toku walsikimiliye? ⸤Ku-takis tolemele⸥ ku-mong te kanambu, meku oku sai.” nirim kene ");
INSERT INTO mux_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","enini yu mulurumna te meku oku yu siring. Kanu-kene Yesos-ni eninindu nimba mele: “Ku-moni ilinga naenga kumbi-kerale kene bili kene molemúye?” nirim. Enini yunundu niku mele: “Rom-Gapman-Yi Aima Auli Kumbina Sisale-nga kumbi-kerale kene bili kene molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kanu-kene yu-ni eninindu nimba mele: “⸤Ku-monele Sisale-nga⸥ akiliinga Sisale-nga mélema Sisale yunu siku, Pulu Yili-nga mélema Pulu Yili yunu sai.” nirim. Yu-ni aku-sipa ⸤aima sumbi-sipa⸥ nirim mele akili piliiku kene ⸤‘Yu aima piliipa kungnjuli pelemú yili lam.’ niku piliiku kene⸥ numanu pulele liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","⸤Yi kanuma Yesos kene ku-moni-takis tuli ungele niku pora siring kene⸥ penga Sadusi-yi mare Yesos mulurumna uring. Sadusi-yima enini ‘Pulu Yili-ni kolemele yambuma penga topa naa makinjimba, lomburuku ola naa mulungí.’ niku piliiku muluring talapele. Sadusi-yi akuma oku Yesos walsiku piliiku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ung-Bo Tunjuliele, ⸤Pulu Yili-nga ung-manima oliu sirim yi⸥ Moses-ni ⸤“Teai!” nimba⸥ ung-mani sipa kene nimba mele: “Ambu liimba yi te-ni kangambula naa memba kene ambale we mulupili yili kolumba kene yi kanili yunga angin molumbále-ni yunga ambu-wayele liipa angin liipa tapunjupa kangambula minjipili.” nirim aku-sipa nimba bukna turum molemú kanili. ");
INSERT INTO mux_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","⸤Ung-mani kaniliinga ulu te oliunga yi mare-kene wendu urum mele nu walsipu piliamili.⸥ “Anginipili-yi angere yupuku-guli muluring. Komale ambu liipa kangambula te naa memba kene we kulurum. ");
INSERT INTO mux_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","⸤Kangambula te naa mulupili we kulurum kene⸥ yunga anginu bulkundele-ni ⸤yunga angin kulurumeliinga kangambula ‘Menjambu.’ nimba⸥ ambu-wayele kelepa liirim. Yunu kangambula te naa-ko menjipa kene yunu we kulurumko. Yunga angin bulkundele-ni ambu kanili liirimko akiliinga-pe yunu kepe we kulurumko. ");
INSERT INTO mux_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aku telsiliiku puku kene yi angere yupuku-guli pali kangambula tilu kepe naa-ko meku kene kolku pora siring kene akeleale kamu we kulurumko. Penga ambale yunu kulurumko. ");
INSERT INTO mux_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akiliinga, kolemele yambuma penga lomburuku ola mulungí kene ambu kanili yi angere yupuku-guli-ni pali ya ma-koleana liiringeliinga ambale yu yi aima naenga min molumbaye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesos-ni eninindu pundu topa nimba mele: “Eni Pulu Yili-nga bukna ung molemúma kene, Pulu Yili-kene tondulu pelemú mele kene, naa piliiku lu liilimeláliinga ⸤yambuma penga tengélendu nikimili mele piliiku sunduku gólu tokomele⸥. ");
INSERT INTO mux_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lomburuku ola mulungí yambumanga yima-ni ambu naa liiku, ambuma yi naa puku, aku-siku aima naa tingí. Mulú-koleana angkellama molemele mele aku-siku mulungí. ⸤Angkellama-ni mana-yambuma telemele mele naa telemele kanili.⸥ Aku tingéliinga ⸤‘Eni Pulu Yili-nga ungele piliiku sunduku lawa telemele.’ niker⸥. ");
INSERT INTO mux_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Akiliinga-pe ⸤eni Sadusi-yima-ni⸥ ‘Kolemele yambuma lomburuku ola naa mulungí.’ niku piliilimeláliinga ung te niambuko. Moses unji walú tenga ⸤tepi nomba pirim tepéle-ni unjele naa nurum kanupa kene⸥ akuna Pulu Yili-nga ung te wendu omba Moses-ndu ung te nirim temanele eni naa kanuku piliilimiliye? Pulu Yili-ni Moses-ndu nimba mele: “Na Eprayam kene Aisak kene Jekop kene eninga Pulu Yili moliu.” nirim. Pulu Yili-nga bukna Moses-ni turum ung molemú akili naa kanuku piliilimiliye? ⸤‘Eninga Pulu Yili mulurundu.’ naa nirim. ‘Eninga Pulu Yili moliu.’ nirim kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pulu Yili yu kululi yambumanga Pulu Yili mólu; yu kona mululi yambumanga Pulu Yili. Aku-siku ung piliiku sunduku kene eni lu liilimele.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","⸤Sadusi-yima kene Yesos kene⸥ aku-siku tombulku niku molangi Pulu Yili-nga ung-manimanga puluma piliipa ung-bo tunjurum yi te omba enini anju-yandu tombulku niku muluringna omba piliirim. Enini ung mare Yesos-ndu walsiku piliiring ungeliinga yu-ni anju pundu topa nimba kunjurum mele piliipa kene ung-manimanga puluma piliirim yili-ni Yesos-ndu walsipa piliipa kene nimba mele: “Pulu Yili-ni ⸤“Teai!” nimba⸥ ung-mani sirim pelemúmanga pali nambulka ung-manele aima olandupaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesos-ni pundu topa nimba mele: “Ung-mani olandupale i-sipa: ‘Isrel-yambuma, piliai! Auli Yawe oliunga Pulu Yili yunu mindi Auli tiluele molemú, te lupa mólu. ");
INSERT INTO mux_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eninga numanuma kene, eninga minima kene, eninga piliipa kungnjúlima kene, eninga tonduluma kene, akuma-ni Auli Yawe eninga Pulu Yili mindi tondulu munduku numanu monjai.’ nimba, ung-mani aima olandupale aku-sipa ⸤nimba⸥ molemú. ");
INSERT INTO mux_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ung-mani tale-sipale i-sipa: ‘Eni-enini lupa-lupa numanu monjuku eninga kangiele eni-enini kondu kolku nokolemele mele aku-sikuko pulu lelemú yambuma numanu monjuku nokuku molangi.’ nimba molemú. Ung-mani akuselenga olakundu te aima naa molemú, mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","⸤Yesos-ni aku-sipa nirim piliipa kene⸥ yili-ni yunundu nimba mele: “Ung-Bo Tunjuliele, kapula nikinele. Nu-ni nikunu mele: “Pulu Yili tiluele mindi molemú. We te lupa naa molemú. Yu-yunu mindi molemú.” nikinele aima sika nikinu. ");
INSERT INTO mux_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘Yunu numanu munjingíndu eninga numanuma kene, eninga piliipa kungnjúlima kene, eninga tonduluma kene, akuma-ni ⸤Auliele eninga Pulu Yili⸥ mindi tondulu munduku numanu monjai.’ nimba molemú ung-manele kene ‘Eni-eninga kangima eni-enini kondu kolemele mele yambu pulu lelemúma aku-siku kondu kolangi.’ nimba molemú ung-manele kene, ung-mani akusele temulú kene olandupa; Pulu Yili kungma kene mélema popu topu kalupu “Ili nu siker.” nilimulu akili mania-kilia.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yu-ni pundu topa nimba kunjurum mele akili piliipa kene Yesos-ni yunundu nimba mele: “Nu numanu piliikunu molláliinga Pulu Yili-ni yi nuim king molupa nokulemú yambu-talapena sukundu nondupa puni tekenu lem.” nirim. Kanu-kene ⸤Yesos-ndu walsiku piliiring ungma pali yu-ni pundu topa anju nimba kunjurum piliiku kene⸥ alsuku yunu ung te walsiku piliingéliinga pipili kolku mundu-mong teku kene naa walsiring. ");
INSERT INTO mux_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesos ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna sukundu yambuma ung-bo tonjupa mani sipa mulurum. Mani sipa molupa kene ung te nimba mele: “Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuli yima-ni niku mele: “Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim Kraisele ⸤yi nuim king⸥ Depit-ni kalupa liimba yili molumba.” nilimele akili nambimuna “Yunu Depit-ni kalupa liimba yili molumba.” nilimeleye? ");
INSERT INTO mux_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","⸤Aku-siku nilimele yima-ni⸥ Depit yu-ni yunu ⸤yi kanilindu nirim mele naa piliilimilinje.⸥ Mini Kake Tiliele Depit-nga numanuna mulurum kene Depit yu-ni ⸤yi Kraisele molumba mele⸥ nimba mele: “Auli ⸤Pulu Yi Yawe-ni⸥ nanga Auliele-ndu nimba mele: “‘Nunga ele-túma nu-ni nokani.’ nimbu, pe enini topu mania mundunjumbu akiliinga isili-ui nu ⸤na kene wasie tapú topulu yi-nuimsele molupulu mélema nokambili⸥ nanga ki-bokundu oku molui.” nirim.” nimba Depit-ni nirim kanili. ");
INSERT INTO mux_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Depit-ni ⸤yi-nuim Kraisele⸥ yunundu “Nu nanga Auliele.” nirim. Pe eni “Yunu Depit-ni kalupa liimba yili ⸤mindi⸥ molumba.” nambi-siku piliiku kene nilimeleye?” nirim. We-yambu pulele máku toku muluringma Yesos-ni nirim ungma piliiku kene numanu lakuku siku piliiku muluring. ");
INSERT INTO mux_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesos-ni ung-bo tonjupa mani sipa molupa kene ⸤lip-lipi topa⸥ ung te nimba mele: “Eni Pulu Yili-ni ⸤“Teai!” nimba sirim⸥ ung-manimanga puluma piliiku ung-bo tunjuli yima mimi-siku kanuku ⸤enini telemele mele manda leku naa teku⸥ molai. ⸤‘Yambuma-ni oliu kanuku “Yi kaíma” niangi.’ niku⸥ yi kanuma-ni wale-pakuli aima sulu kaíma, ⸤yi-nuimima pakolemele mele,⸥ pakuku andolemele. Yambuma máku toku molemele koleamanga mong-keng leku andungí kene ‘We-yambuma-ni oliu kape niangi.’ niku piliiku kene numanu silsiliiku anduku molemeleko. ");
INSERT INTO mux_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yambuma máku toku Pulu Yili-nga ungele piliilimili lkumanga lkundu puku kene mania mulungíndu yi aulima molemele polu kaí akuna kumbina puku polu akuna numanu siku molemeleko. Yambuma-ni langi noku yambumandu “Wasie namili wai.” nilimele kene yi kanuma oku kene yi-aulimanga polu-kumbina ‘oliu molamili.’ niku numanu siku molemeleko. ");
INSERT INTO mux_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“Yima kolemele kene enini yi kanumanga ambu-wayema toku makuruku munduku kene lkuma ‘Oliunga’ niku we liilimele. Pulu Yili-kene popu toku ung ningíndu niku sulu munduku gólu toku nilimele. Pulu Yili-ni we-yambuma ulu-pulu-kis telemeláliinga enini sika “Mindili nangi.” nimbá akiliinga-pe ya yi nikeruma-ni ulu akuma telemeláliinga Pulu Yili-ni yi akuma “Mindili aima lakuku nangi.” nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesos ⸤Pulu Yili popu toku kaluring lku-temboll⸥ keri-puluna lku-tembolluna sukundu kongun tingí ku-monima munduring mingina nondupa mania molupa kene yambu pulele-ni mingi akuna ku-moni oku munduring mele akili kanupa mulurum. Kanupa mulurum kene yambu kamakoma-ni ku-moni pulele oku munduring kanurum. ");
INSERT INTO mux_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","⸤Aku-sipa kanupa mulurum kene⸥ ambu-waye aima korupa te omba yunga ku-kululi tale mindi mundurum. Ku-kululi kanusele liipa tere lepa ku-moni aima koltale mele mundurum. ");
INSERT INTO mux_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","⸤Ambu-wayele-ni aku-sipa tirim kanupa kene⸥ Yesos-ni yu lumbili andúlima walsipa “Wai.” nimba kene eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Andi ambu-waye korupale yu-ni ku-moni mundukumele aima ola-kilia mele mundukum, ku-moni we mundukumili yambuma mania-kilia mele.” niker. ");
INSERT INTO mux_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Enini ku-moni pulele nosulimelemanga koltale mindi oku mundukumele. Akiliinga-pe ambu-wayele ku-moni te aima naa nosilimú. Yunga ku koltale nusum-sele pali memba omba mundum. Langi nombá kepe te naa nosilimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kanu-kene Yesos ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna ulsu pumba purum kene yu lumbili andúlimanga te-ni yunundu nimba mele: “Ung-Bo Tunjuliele, tembollaliinga lku lupa-lupama kene, lkuma takuring ku auli kaí lupa-lupama kanui.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","⸤Aku-sipa nirim kene⸥ Yesos-ni yunundu nimba mele: “Ya ⸤tembollaliinga⸥ lku lupa-lupa kaí angiliimú kanokumelema, penga ⸤walse ya kolea-auli Jerusallem yambuma mindili nungí enale wendu ombá kene⸥ temboll ilinga lkuma pali tekisiku kene kuma pali toku kalalu singí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kanu-kene yunu Unji-Ollip Punie Lili Ma-Pangina olandu pupa ⸤Pulu Yili popu toku kaluring⸥ lku-temboll wilikundu pupa mania mulurumna we-yambu te naa molangi ⸤yu lumbili anduli yi mare⸥ Pita kene, Jemis kene, Jon kene, Endru kene enini oku, eni-enini molku kene yunundu walsiku piliiku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nu-ni nikinu akili te-kene wendu ombáye? Pe nu-ni nikinu ulu ima nondupa wendu ombáliinga ui nambulka ulu te temba kene oliu-ni kanupu kene ‘Uluma i wendu ombá tekem lam.’ nimbu piliimulúye? Oliu niku si.” niku walsiring kene ");
INSERT INTO mux_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","yu-ni eninindu nimba mele: “⸤Ulu kanuma wendu ombáliinga ung mare⸥ yambuma-ni eni gólu toku singéliinga kanuku piliiku kongnjuku molai. ");
INSERT INTO mux_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Yi pulele-ni oku na moliu mele lupa-lupa gólu toku niku mele: “⸤Pulu Yili-ni ‘Nanga yambuma nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Krais⸥ akili na.” niku aku-siku gólu toku singéliinga piliiku kongnjuku molai. Yambu pulele-ni yi kanumanga ungma piliiku liiku “Sika nikimili.” ningí. ");
INSERT INTO mux_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Kolea marenga ele auli-teku mare tingí mele piliiku, ‘Opali talú ele auli mare i-sipa i-sipa wendu ombá.’ niku we ningí-na piliiku kene mini-wale naa mundai. Ele tingíma kepe ulu akuma Pulu Yili-ni ‘Ui wendu upili. Laye-kolte penga mele ya ma-koleale pora nimbá.’ nimba, nimba panjurumeliinga ulu akuma sika wendu ombá akiliinga-pe aku-kene mulú-masele ui naa pora nimbá. ");
INSERT INTO mux_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","⸤Mulú-masele pora nimbá enale ui wendu naa upili buni auli mare wendu ombá.⸥ Yambu-talape auli te kene talape auli te kene ele tekulu, yi nuim king marenga talapema kene marenga talapema kene ele tingí. Ya ma-kolea lupa-lupamanga ma jim-jim tepa, engle lepa, aku-sipa temba. Ambu te-ni kangambula koela membáliinga ui bulu-mini topa mindili nolemú mele, mulú-masele pora nimbá enale koela wendu ombándu buni lupa-lupa aku-sipama ui wendu ombá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“⸤Ulu kanuma wendu ombá enama⸥ yambuma mimi-siku piliai. ⸤‘Na lumbili anduli yambuma mindili noku, kolangi.’ niku,⸥ eni ⸤mare ambolku liiku kene⸥ kanjollumanga mákumanga meku puku kot tinjingí, eni ⸤mare⸥ Juda-yambuma máku toku Pulu Yili-nga ungele piliilimili lkumanga liiku meku puku kimbulú-ni tungíko. Eni nanga yambuma mulungéliinga eni ⸤mare ka siku⸥ gapman-yi aulima kene yi nuim kingima kene mulungína ⸤kot tinjingíndu⸥ meku pungíko. Aku-siku tingéliinga eni-enini piliiku kongnjuku molai. ⸤Akiliinga-pe kot tinjingí kene kot-na angiliiku kene yi kanuma kene yi kanuma nukungí yi-nuimima kene⸥ eni ‘Nanga ungele piliangi.’ niku enini niku singí. ");
INSERT INTO mux_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Temani-kaiéle ‘Yambuma pali piliangi.’ niku koleamanga pali anduku ui niku singí ⸤kene, penga mulú-masele pora nimbá enale kamu wendu ombá⸥. ");
INSERT INTO mux_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eni ka siku kot tinjingí kene ui ‘Kotna nambulka ung te nimulúnje? Oliu ung te walsiku piliingí kene nambulka ung te pundu topu nimulúnje?’ niku mini-wale naa mundai. Eni ung ningíma eni-enini piliiku naa ningí. Mini Kake Tiliele-ni eninga kerina molupa kene nimba simba ungma eni anju ningéliinga aku tingí ena-mongaliinga eni ung ningí mele piliiku kene aku-siku ningí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“⸤Ena akumanga⸥ angin-ni yunga kandi-anginele ⸤nanga yambu molumbáliinga⸥ ‘Kulupili toku konjangi.’ nimba kot tenjimba. Lapa-ni yunga kandi-kangambulama akuko temba. Kangambulama-ni kepe eninga kandi anupili lapalii-kene arerembi kolku kot-na meku puku “Toku konjangi.” ningíko. ");
INSERT INTO mux_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nanga yambuma mulungéliinga yambuma-ni pali eni-kene numanu kis panjingí, akiliinga-pe na munduku naa kelku enama pora naa nipili tondulu munduku mulungí yambuma Pulu Yili-ni tepa liipa ‘Mindili nungí koleana naa puku wasie molupu konjupu mindi pamili.’ nimbá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(⸤Na buk ili tokur yili-ni⸥ eni bukele kanokumele yambumandu ung te niambu: ‘⸤Yesos-ni nirim⸥ ungele ilinga maniakundu molemú akili eni bi kanokumele yambuma-ni ung-pulele aima piliiku kaí teangi.’ ⸤niker. Yesos-ni nimba mele:⸥) “⸤Yambu⸥ tepa pipili kunjuli mele aima kisele ⸤lku-tembolluna suku Pulu Yili-nga lku-sulumina kake tílina Pulu Yili-ni⸥ “We-yambuma sukundu naa pangi!” nimba mi tolemú-na yunu kapula naa pupa angiliimba, akiliinga-pe walse akuna angiliipa kene kolea akili aima tepa kalaru monjumba. Méle akili akuna ⸤wendu omba⸥ angiliimba kanuku kene ⸤‘Buni aulima wendu ombá tekem.’ niku piliiku⸥ kolea Judia distrik koleamanga mulungí yambuma ⸤eninga koleama munduku kelku⸥ ma-pangi lembamanga takara toku pangi. ");
INSERT INTO mux_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yambu te lku-imuna ola mulupili ⸤aku-sipa ulu te wendu ombá kene kanupa kene takara topa pumbandu⸥ mania omba ‘Mélema liipu membu pambu.’ nimba lkuna lkundu naa pupili. ");
INSERT INTO mux_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yambu te puniena molupa kene ⸤‘Takara topu pambu.’ nimba⸥ alsupa lkundu pupa yunga alí-wale-pakuli suluele naa liipili. ⸤Sumbi siku takara toku pangi.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Aku-sipa wendu ombá enaliinga ambu kangambula munjúlima kene, ambu kangambula ame sílima kene, ⸤enini kapula lkisiku takara toku naa pungéliinga⸥ enini-kene aima buni wendu ombáliinga enini kondu tekem. ");
INSERT INTO mux_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","“Pulu Yili-kene popu toku mawa teku kene, ‘Alí telemú kaliimbumanga buni akuma wendu naa upili.’ niai. Ena kanumanga buni aima aulima wendu ombá, Pulu Yili-ni ui mulú-masele pulu monjupa tirim kene kepe, yandupa ekupu kepe buni aku-sipa te wendu naa urum. Penga kepe aku-sipa buni aulima naa wendu ombáko. Akiliinga aku-siku Pulu Yili-kene popu toku mawa teai. ");
INSERT INTO mux_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","⸤Buni akuma wendu ombá kene⸥ Auli ⸤Pulu Yili⸥ -ni ‘Bunimanga enama nondupa pora nipili.’ nimba ui naa nimba panjilkanje yambuma pali kolkemela. Akiliinga-pe Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba makó turum yambuma ‘naa kolangi.’ nimba ‘Buni wendu ombá ena akuma nondupa pora nipili.’ nimba, nimba panjurum. ");
INSERT INTO mux_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Buni kanuma omba pemba enamanga yambu mare-ni niku mele: “Kanai! Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ ui nimba makó turum yi-nuim Kraisele ya omba molemú.” ningí mola “Nena omba molemú.” ningí kene eninga ungma naa piliiku, ‘Sika nikimili.’ niku naa piliai. ");
INSERT INTO mux_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yi mare oku kene gólu toku niku mele: “Pulu Yili-ni makó turum yi-nuim Kraisele na.” ningí, mola gólu toku kene “Pulu Yili-ni “Ninjai.” nimba, ung nimba sirimuma piliipu kene ombu nimbu sikemulu.” ningí. ‘Yambuma pali, Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba makó turum yambuma-ni kepe liipu lu sipu, nikimulu mele ‘Sika’ niku tondulu munduku piliangi.’ niku Pulu Yili-ni mindi ulu-tonduluma kapula telemú mele manda leku ulu-tondulu lupa-lupama tingí. Akiliinga-pe Pulu Yili-nga yambuma aku-siku kundi tungí kene eninga ungma naa piliiku, liiku su singí. ");
INSERT INTO mux_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Akiliinga, penga ulu akuma wendu ombá mele akili ‘Eni ui piliangi.’ nimbu ya nimbu siker mele piliiku kene kanuku piliiku kongnjuku molai!” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ena kanumanga mindili nungí niker ulu akuma wendu ombá kene penga ⸤ulu lupa-lupa mare wendu ombáko. Ulu akuma i-sipa:⸥ ‘Kolea tangupa ena topa pa naa tepa, sumbulú topa, kaliimbu sumbulsuli talang pulimú mele naa pupa, ");
INSERT INTO mux_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kombukantupuma mulúna mania omba, mulúna angiliimú méle tonduluma lop-lope tepa anju-yandu pupa, aku-sipa ulu lupa-lupama wendu ombá.’ ");
INSERT INTO mux_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aku-sipa temba enaliinga Mania Omba Mana-Yi Au Talurum Yili tondulu puliele kene, talang auli-tepa púliele kene kupa tenga suku molupa kamu mania ombá ⸤kene⸥ yambuma-ni kanungí. ");
INSERT INTO mux_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Omba kene yu-ni yunga angkellama liipa mundumba kene enini wi-mere wili-ya mulú ma koleamanga pali puku Pulu Yili-ni ‘Nanga yambuma molangi.’ nimba ui makó turum yambuma sukundu-sukundu liinjingí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Unji-píkele-ni telemú aku-sipa ung-eku mele pelemú akiliinga piliiku kene ung-pulele piliai. Unji-pik kuku topa gomú tolemú-na kanuku kene ‘Ekupu ena temba kaliimbuma wendu ombá tekem lem.’ niku piliilimili. ");
INSERT INTO mux_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Aku-sipako, ulu “Wendu ombá.” niker ima sika wendu ombá kene kanuku kene ‘Yu aima sika nondupa ombá tekem. Yu aima kamu okum.’ niku piliingí. ");
INSERT INTO mux_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Na-ni enindu aima sika nimbu siker: “Ekupu molemele yambuma ui naa kolangi “Wendu ombá.” niker ulu ima pali wendu ombá.” niker. ");
INSERT INTO mux_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Muléle kene male kene pora nimbá akiliinga-pe nanga ung niliuma aima pora naa nimbá. ⸤Niliu mele pali aima sika wendu ombá.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“⸤Mania Omba Mana-Yi Au Talurum Yili aima sika ombá⸥ akiliinga-pe yunu ombá enale naa piliilimulu. Sumbulsuli ombáne mola tanguli ombánje akili oliu naa piliilimulu. Mulú-koleana angkellama kepe naa-ko piliilimili. Pulu Yili-nga Málale kepe naa-ko piliilimú. Tata yunu mindi ⸤ena akili⸥ piliipa molemú. ");
INSERT INTO mux_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kanuku kuni teku molai! Yunu kelepa ombá enale eni naa piliilimili akiliinga “Yunu ombá.” niku nokuku konjuku, uru naa peku, (Pulu Yili-kene popu toku ung niku) molai. ");
INSERT INTO mux_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yunu ombá enale i-sipa mele: Yi te kolea marenga ena mare molumba pumba telemú kene yunga koleale mundupa kelimbandu yunga kendemande-yimandu “Nanga koleale nokunjai.” nimba kene yunga kongunale tinjingí mele enini lupa-lupa moke tepa sipa kene lku-keripulu nokulemú yilindu “Na walse ombú kaniliinga nokuku mului.” nimba kene pulimú. ");
INSERT INTO mux_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Lku pulu yili sika ombá akiliinga-pe yu ombá enale naa piliilimiláliinga ‘Yunu ombá.’ niku nokunjuku molai. Ipinjali ombá, mola sumbulsuli anjunga-yandunga mambu ombá, mola kolea tangumba muni-poluna kera-kulla ko tolemú kene ombá, mola ipulam-ui ombánje, eni naa-ko piliilimili akiliinga ");
INSERT INTO mux_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“‘Eni uru peangi walsekale yu liipa sinjipa omba eni kanomba.’ niku, kanuku nokunjuku molai.” nimbu niker. ");
INSERT INTO mux_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","“Enindu i niker mele yambumandu pali nikerko, “⸤‘Ombá.’ niku⸥ kanuku nokunjuku molai.” nimbu niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","⸤Juda-yambuma-ni puniemanga taki-taki kolea-auli Jerusallem oku akuna sukundu⸥ Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum akili mele piliiku, Pllawa Tepa Auli Mundulimú Méle Yis Akili Naa Munduku Pllawa We Kalku Nuring Enale talú mele wendu ombándu, ekupu mele Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, enini Yesos kiyang niku ka siku toku kunjingí kupulanum te koruku muluring. ");
INSERT INTO mux_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akilindu tombulku niku mele: “⸤Nondupa tamili,⸥ aramele-pe Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum Mele ⸤Piliilimulu⸥ Enamanga ⸤‘uluma tepu molamili.’ niku⸥ yambu pulele ya Jerusallem oku máku toku mulungéliinga yu isili-ui túmulu lem enini oliu-kene arerembi kolku ele tungí akiliinga isili-ui naa topu, kelamili.” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kolea-kelú Betani yi te ⸤ui kuru-laká nomba kene pe pora nirim yi te,⸥ bi leku “Yi Kuru-Laká Nuli Saimon” niring kaniliinga lkuna Yesos pupa langi nomba mulupili ambu te kopungu-wel mingi aima kaí te Yesos yunu mulurumna memba urum. Wel aima mura lakupa tuli, kanili nat-ni teku mimi tiring, kaniliinga ku-moni aima lakupa purum. Akili memba omba kene Yesos langi nuli polu mulurumna memba omba ⸤‘Yunu tepu kaí tenjambu.’ nimba⸥ mingele topa kaku topa wellale pengína onde linjirim. ");
INSERT INTO mux_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ambale-ni aku tirim kanuku kene kanuna muluring yambumanga mare-ni numanu kis piliiku kene anju-yandu enini niku mele: “Kopungu-wel akili nambimuna we tepa kis-sikemuye? ");
INSERT INTO mux_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wel akili ku-moni liilkumulanje ku-moni pulele, ku-moni mong wan-tausen akili mele, liipu kene yambu-korupama moke tepu silkumula.” niku ambale tondulu munduku ung-mura siring. ");
INSERT INTO mux_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","⸤Yambuma-ni ambalendu aku-siku niring piliipa kene⸥ Yesos-ni eninindu nimba mele: “Ambu ili-kene nambimuna ung pulele nikimeleye? Yu-ni na-kene ulu kaí te tímeliinga yu-kene ung pulele naa niku munduku kelai. ");
INSERT INTO mux_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yambu-korupama eni-kene taki-taki mulungéliinga ‘Enini liipu tapunjamili.’ ningí enamanga pali enini manda liiku tapunjungí akiliinga-pe na eni-kene taki-taki naa molumbu. ");
INSERT INTO mux_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ambale-ni ‘Kapula tembu.’ nimba pilíímu akili mele tímu. Na ⸤kolumbu kene⸥ ónu tingéliinga yu-ni isili-ui wel mura tuli ili nanga kangina omba onde linjímu. ");
INSERT INTO mux_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na-ni enindu aima sika nimbu siker: “Ma-koleamanga pali ⸤nanga⸥ temani kaiéle anduku toku singí kene ambu ili-ni ekupu tímu temanele kepe ‘Yambuma-ni piliiku kene ‘Yu-ni tepa kunjurum lam.’ niku piliangi.’ niku kene temani akili toku singíko.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kanu-kene ⸤Yesos yu lumbili anduli⸥ yi rurepu akumanga yi te, Judas-Iskeriot, ‘Pulu Yili popu tunjuring yi-aulima-ni Yesos ka singí kupulanumele yu-ni liipu ora sambu.’ nimba enini muluringna pupa, temba mele nimba sirim. ");
INSERT INTO mux_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yu-ni temba mele nirim piliiku kene enini numanu lakuku siku “Nu ku-moni te simulú kene.” niku, niku panjiring. Kanu-kene yunu Yesos enini liipa simba mele kupulanumele korupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pllawa Tepa Auli Mundulimú Méle Yis Akili Naa Munduku Pllawa We Kalku Nuring Kóraliinga pulu-pulu enale wendu urum kene Juda-yambuma-ni Pulu Yili-ni ui eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingíndu kung-sipsip walú te toku kalku nungí mele piliiku kene, Yesos lumbili anduli yima yunu mulurumna oku walsiku niku mele: “Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum akili piliimuláliinga kung-sipsip walú ⸤kaluli⸥ te ekupu nunéle kolea tena pupu am-amu tenjamili niku piliikunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aku-siku niku walsiring kene yu-ni yu lumbili anduli yi tale liipa mundupa kene nimba mele: “Ne kolea-auli ⸤Jerusallem⸥ sukundu pukulu kene, yi te mingina no kolupa memba kupulanumuna ombá kanuku kumbi-nunu tekululiinga yunu lumbili pale. ");
INSERT INTO mux_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yunu sukundu pumba lkuna ⸤lkundu pukulu kene⸥, lku pulu yilindu nikulu mele: “Ung-Bo Tunjuliele-ni i-sipa walsipa kene nimba mele: “Na kene nanga lumbili anduli yima kene oliu-ni Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum mele piliimulúndu kung-sipsip walú ⸤kaluliele⸥ tena nomulúye? Yambu poningma mulungí sulumina oliu nombu molomulále tena lelemúye?” nim.” niale. ");
INSERT INTO mux_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aku-siku ninglí kene yu-ni else lkuliinga olakundu sulumina auli te, akuna langi nuli polu te kene, mania molomulú poluma kene, mélema pali ui teku mimi tili lembale, liipa ora simba. Sulumina akuna ⸤sipsip-walú nomulále⸥ am-amu teale.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kanu-kene yunga lumbili anduli yi akusele kolea-auli akuna sukundu pukulu, Yesos-ni nirim aku mele ulu akuma tili lirim kanukulu kene, akuna Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingí kung-sipsip walú nungéle kalkulu am-amu tekulu nusiringli. ");
INSERT INTO mux_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ipinjali ena pupa kolea kalá turum kene Yesos kene yu lumbili anduli yi rurepu kanuka kene uring. ");
INSERT INTO mux_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Langi noku muluring kene Yesos-ni nimba mele: “Na-ni enindu aima sika nimbu siker: “Eni kene wasie molupu langi nokumulumanga yi te-ni na liipa nanga ele-tu yima simba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","⸤Aku-sipa nirim piliiku kene⸥ enini numanu buni tirim piliiku kene lupa-lupa walsiku kene niku mele: “Auliele, nandu nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesos-ni pundu topa nimba mele: “Eni nanga yi rurepu-kenga yi te na-kene polu suku-singina ola langi lelemúmanga te walsekale liipulu nombulú yili-ni na liipa, ele-tu yima simba. ");
INSERT INTO mux_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ekupu Mania Omba Mana-Yi Au Talurum Yili-kene ulu tingí mele kórunga-ui niku panjiring temanele ⸤Pulu Yili-nga⸥ bukna sukundu molemú aku mele sika ele-tu yima-ni tingí, akiliinga-pe yu liipa ele-tu yima simba yili mindili nomba aima molupa kis-simba. Yunu molupa kis-simbaliinga yunu anumu-ni naa melkanje kapula. ⸤Yunu mindili naa nolka.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enini langi noku muluring kene Yesos-ni bret te liipa Pulu Yili-kene “Angke” nimba kene ambulupa puku topa ⸤yu lumbili anduli yima⸥ sipa kene nimba mele: “Ili nanga kangiele eni liiku ⸤nai⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Penga no-waen kap te liipa kene Pulu Yili-kene “Angke” nimba enini sirim kene enini pali ⸤no-waen kanili⸥ nuring. ");
INSERT INTO mux_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yu-ni nimba mele: “⸤No-waen⸥ siker ili nanga memale. Pulu Yili-ni ⸤yunu kene yunga yambuma kene mulungí akili mele⸥ ung te nimba panjipa mi lirim ung kanili ‘Kamu wendu omba pípili.’ nimbu yambu puleliinga ninjipu nanga memale onde lepuliinga ⸤kolumbu⸥ memi akili ili. ");
INSERT INTO mux_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na-ni enindu aima sika nimbu siker: “Isili-ui na no-waen alsupu aima naa nombú. Penga mindi, Pulu Yili yi nuim kingele molupa nokulemú koleana no-waen konale kelepu nombú.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","⸤Langi noku pora siku kene⸥ enini Pulu Yili-nga konana te ninjiku kene, pena puku Unji-Ollip Punie Lili Ma-Pangina ola puring. ");
INSERT INTO mux_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kanu-kene Yesos-ni yu lumbili andúlimandu nimba mele: “Penga ⸤ele-tu yima-ni na-kene tingí mele kanuku kene⸥ eni pali na munduku kilingí. Aku-siku tingí mele Pulu Yili-ni ui nirim yunga bukna molemú kanili. Pulu Yili-ni ⸤ung-eku te topa kene⸥ nimba mele: “ “Kung-sipsip tápu-yili tangi.” nimbú, yunu tungí kene sipsipma bulu-bale ningí.” nirim, ⸤aku-sipa mele ekupu wendu ombá⸥. ");
INSERT INTO mux_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","⸤Isili-ui na toku kunjingí kene eni sika bulu-bale ningí⸥ akiliinga-pe na lomburupu ola molupu kene, na kumbi lepu kolea Gallallindu pumbu, eni penga aeleku akuna ungí kene ⸤alsupu wasie molomulú⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","⸤Yesos-ni aku-sipa nirim piliipa kene⸥ Pita-ni nimba mele: “Enini pali ‘Nu sika’ niku tondulu munduku piliilimili akili mania pumba kene nu munduku kilíngi lem na-ni nu aku-sipu aima mundupu naa kelimbu, aima mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesos-ni pundu topa nimba mele: “Na-ni nu aima sika nimbu siker: “Aima ekupu sumbulsuli, kera kulla wale tale-sipale ui ko naa tupili nu-ni mundu-mong tenjikuliinga wale yupuku nandu gólu tokunu “Yu naeye? Na naa kanoliu.” niní.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Akiliinga-pe Pita-ni tondulu mundupa nimba mele: “Na nu-kene tapú tolembulaliinga olsu wasie “Topu konjumulú.” níngi lem kepe nu “Naa kanoliu.” aima naa nimbále.” nirim. Lumbili anduli yi wema-ni pali “ “Nu naa kanolemulu.” aima naa nimulú.” niringko. ");
INSERT INTO mux_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","⸤Kanu-kene⸥ Yesos kene yu lumbili anduli yima kene kolea “Gesemani” nílina puring. Akuna puring kene yu-ni eninindu nimba mele: “Na Pulu Yili kene popu topu ung nimbú pukuraliinga eni ya molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aku-sipa nimba kene Pita kene Jemis kene Jon kene liipa memba pupa kene ⸤‘Na teku kis-singí ulele aima nondupa wendu ombá tekem.’ nimba piliipa kene⸥ yu-yunu buni lakupa liipa numanu kis panjipa kamelena mindili tipili mulurum. ");
INSERT INTO mux_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yu-ni eninindu nimba mele: “Nanga numanuna buni aima auli te tepam akiliinga na kolumbu mele tekem ⸤kene⸥ eni uru naa peku, ya mimi-siku kanuku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aku-sipa nimba kene yunu laye-kolte anjupa pupaliinga koporungu langupa tamalu pepa kene yu-kene nondupa buni wendu ombá akili mele ‘Wendu naa um lem aima kapula.’ nimba Pulu Yili-kene popu tombandu ⸤ung-eku topa⸥ mawa tepa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Nanga Tata, nu-ni uluma pali kapula tellu akiliinga na mindili nuli no-mingina no nombále ‘Naa nambu.’ nilkena. Akiliinga-pe ‘Na-ni tepu kene nanu numanu simbu.’ nimbu piliiker mele naa teambu. Nu-ni kanuku kaí piliiní ulele mindi teambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aku-sipa nimba kene kelepa yunga lumbili anduli yi yupuku muluringna yandu omba kanurum kene enini uru piring kanupa kene Pita-ndu nimba mele: “Saimon, nu uru pinu lem. Nu uru naa pekunu ena-mong laye-kolte manda we kanukunu nokukunu naa molluye? ");
INSERT INTO mux_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","‘⸤Kurumanga nuim Seten-ni⸥ oliu kundi tomba kene tepu kis-simulú akiliinga.’ niku kene ⸤uru naa peku⸥ Pulu Yili-kene popu toku ung niku kanuku kaí teku molai. Sika ‘tepu konjamili.’ nimbu numanale-ni piliilimulu akiliinga-pe temuláliinga kangiele enimbu molupa tondulu naa pulimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aku-sipa nimba kene yu alsupa anju pupa ui Pulu Yili-kene popu topa ung nimba mawa tirim akili mele alsupa nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Alsupa yandu urum kene enini uru aima urum-na alsuku uru piring kanurum. Enini uru piringeliinga pipili kolku mundu-mong teku kene yunundu ung ningí te naa piliiring. ");
INSERT INTO mux_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","⸤Alsupa⸥ wale yupuku-sipaliinga ⸤anju pupa Pulu Yili-kene popu topa ung nimbándu pupa⸥ kelepa yandu omba kene yu-ni eninindu nimba mele: “Nambimuna we uru peku múlu liiku molemeleye? Kapula peayo! Mania Omba Mana-Yi Au Talurum Yili ⸤toku kunjingí⸥ ulu-pulu-kis telemele yima liiku singí ena-mongale wendu ombá tekem. ");
INSERT INTO mux_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ola angiliiku pamili wai! Na liipa ele-tu yima simba yili okum kanai!” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesos-ni ⸤kolea Gesemani yunga lumbili andúlimandu⸥ aku-sipa nimba mulupili yu lumbili anduli rurepu akumanga yi Judas urum. Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambumanga tápu-yima kene, yi kanuma-ni liiku munduring yi pulele, yambu tuli lu-koyama kene kimbulúma kene meku Judas kene uring. ");
INSERT INTO mux_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ui Yesos mulurumna naa wangi Yesos Juda-yi aulima liipa simba nimba panjurum yi ⸤Judas-ni⸥ enini Yesos yu sumbulsuli kapula kanuku bi singí mele nimba sipa kene nimba mele: “Na-ni yi te kanupu kene kanglumbu akili Yesos mindi. Yunu ambolku liiku ka siku meku pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","⸤Yi akuma⸥ uring kene ⸤Judas⸥ yunu Yesos mulurumna sumbi-sipa omba kene “Rapai, nu akuna mulúnu lem.” nimba omba yunu kanglurum. ");
INSERT INTO mux_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Aku-sipa tirim kanuku kene Yesos liiku ka siring. ");
INSERT INTO mux_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aku-siku tiring kene kanupa kene ⸤Yesos-kene⸥ nondupa angiliiring yi te-ni yunga lu-koyale kulu topa wendu liipa Pulu Yili popu tunjuring yi-auli olandupaliinga kendemande-yi te topa yunga kum te topa laká linjirim, kum akili wendu urum. ");
INSERT INTO mux_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kanu-kene Yesos-ni ⸤yu ka singí uring⸥ yimandu nimba mele: “Na ‘yambu topa wa nuli yi te moliu.’ niku piliiku kene na ka singíndu yambu tuli lu-koyama kene kimbulúma kene meku okumeleye? ");
INSERT INTO mux_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lku-temboll ⸤lku-kerina we-yambuma máku toku molemele⸥ koleana taki-taki eni-kene wasie molemulu kene ung-bo tonjupu mani sipu moliu kene na liiku ka naa silimele kanili. Akiliinga-pe ⸤Pulu Yili-nga⸥ bukna turing pelemú akili mele kamu wendu ombáliinga eni tingí tekemele uluma wendu okum.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kanu-kene yu lumbili anduli yima pali ⸤‘Oliu wasie ka singí.’ niku piliiku kene⸥ yu munduku kelku enini takara toku puring. ");
INSERT INTO mux_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kang-yi te múlu tiluele mindi pakupa Yesos lumbili andurum. Kang kanili ⸤Yesos liiku ka siring yima-ni⸥ ambuluring kene ");
INSERT INTO mux_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","yunga múlele ⸤mindi⸥ ambolku molangi, méle te naa panjipa giu-gau takara talupa purum. ");
INSERT INTO mux_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kanu-kene Yesos ⸤ka siku kene⸥ Pulu Yili popu tunjuring yi-auli olandupale mulurumna meku puring. Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene, ⸤Pulu Yili-nga⸥ ung-manimanga puluma piliiku ung-bo tunjuring yima kene, enini pali ⸤‘Yesos kot tenjipu piliamili.’ niku⸥ akuna oku máku turing. ");
INSERT INTO mux_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesos ⸤meku puring⸥ kene Pita lumbili aelepa táka-nimba pupa, Pulu Yili popu tunjuring yi-auli olandupaliinga lkuna, lku angiliipa póku tirim, suku-singina yambu máku turing kolea we lirimna aima sukundu pupa, ⸤Yesos nokuku muluring⸥ ele-yima kene tepi piliipa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga yi-kanjolluma pali, akuma-ni Yesos yu toku kunjingíndu ulu te tepa kis-sirim ulu te ‘Yambu te-ni ‘yu i-sipa i-sipa tepa kis-sirim.’ nipili.’ niku yambu te kururing akiliinga-pe yambu te naa kanuku liiring. ");
INSERT INTO mux_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yambu pulele-ni oku ung mare gólu toku “I-sipa i-sipa tepa kis-sirim.” niring akiliinga-pe eninga ungma kapula-kapula naa tirim. ");
INSERT INTO mux_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kanu-kene yi mare-ni yunu tepa kis-sirim mele ola angiliiku gólu toku niku mele: ");
INSERT INTO mux_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Yi ili i-sipa nirim piliirimulu: “⸤Pulu Yili popu toku kaluli⸥ lku-temboll ili, mana-yima-ni takuringele na-ni topu tekisipu kene mana-yima-ni kapula naa takungí lku te ena yupuku omba pumba kene alko topu takumbu.” nirim. ⸤Yu-ni aku nirimaliinga ‘Yunu Pulu Yili mele moliu.’ nimba piliipa kene aku-sipa nirimele nimba kis-sirimnje⸥.” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enini kepe laye-kolte lupa-lupa niring, eninga ungma kapula-kapula naa-ko tirim. ");
INSERT INTO mux_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aku niring piliipa kene Pulu Yili popu tunjuring yi-auli olandupale enini máku turingina ola angiliipa Yesos walsipa kene nimba mele: “Ung te pundu toku naa nikinuye? Nu nikunu kis-sirinu mele nikimiliele nambulka ulele nikunu kis-sirinelendu nikimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akiliinga-pe Yesos ung te pundu topa naa nimba we angiliirim. Pulu Yili popu tunjuring yi-auli olandupale-ni yunu alsupa walsipa piliipa nimba mele: “Pulu Yili-ni oliu ‘Nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele sika nu mola móluye? Kape Nimbu Bi Paka Tonjilimulaliinga Málale nu mola móluye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesos-ni nimba mele: “Akili na.” nirim. “Pe walse Mania Omba Mana-Yi Au Talurum Yili, Yi Tondulu Olandupa Púliele ⸤kene mélema nokumbandu⸥ yunga ki-bokundu molupa, kupámanga ola molupa mania ombá eni kanungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Aku-sipa nirimaliinga ⸤yunu ‘Pulu Yili mele moliu.’ nimba nirimaliinga⸥ piliipa kene Pulu Yili popu tunjuring yi-auli olandupale-ni ⸤aima piliipa kis piliipa⸥ yunga wale-pakuliele yunu ambulupa sungu sipa kene nimba mele: “Ekupu yu-ni mong liirim mele nimba simba yambu te kene wasie nambimuna korumulúye? ");
INSERT INTO mux_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yu-yunu aima sika Pulu Yili ung-taka tonjukum piliikumulu. Nambulka niku piliikimiliye? ⸤Yu-kene nambulka teamiliye?⸥” nirim kene enini niku mele: “Yunu Pulu Yili ung-taka tonjupa marake tímeliinga topu kunjúmulu lem kapula.” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kanu-kene eninga yi mare-ni yunga ⸤kumbi-kerina⸥ lkambe toku kanjuku, yunga kumbi-kerale múlu te-ni pipi sinjiku kene ki-kumu-ni toku ⸤“Nu ‘Pulu Yili-nga yi te moliu.’ niku piliillu akiliinga⸥ nae-ni nu tokumnje nikunu si!” niring. Ele-yima-ni yunu liiku lkarauwa-ni turing. ");
INSERT INTO mux_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Kanu-kene Pita lku maniakundu, yambuma liiku máku toku muluring koleana mulurum kene Pulu Yili popu tunjuring yi-auli olandupaliinga kendemande-ambu te Pita mulurumna omba kene ");
INSERT INTO mux_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","yunu tepi piliipa mulurum kanupa kene nem-nemi nimba kanupa kene nimba mele: “Nu wasie Nasaret yi Yesos-kene wasie tapú-toku muluring kanumanga yi te lem.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pita-ni gólu topa kene “Mólu!” nimba “Nu nikinu akili na naa piliiker!” nirim. Aku-sipa nimba kene lku-keri-puluna purum kene kera kulla ko turum. ");
INSERT INTO mux_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pita yunu lku-keri-puluna pupa mulupili kendemande-ambu kanili-ni yunu kanupa kene akuna angiliiring yambumandu alsupa nimba mele: “Yi ili Yesos-nga talapena yi te lem.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita-ni alsupa “Mólu!” nirim. Wallú-kolte penga mele Pita angiliirim kanuna nondupa angiliiring yima-ni ⸤yunu ung laye lupa mele lirim piliiku kene⸥ yunundu niku mele: “Kolea Gallalli distrik yambuma-ni ung lelemele akili mele nu aku-sikunu ung nikinu piliikumulu. ⸤Yesos kene yu lumbili anduli yima kolea Gallalli distrik yimako,⸥ nu kepe Gallalli yi te, akiliinga ‘Nu aima sika yunga lumbili anduli yi te.’ nimbu piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aku-siku niring kene Pita-ni Pulu Yili-nga bili lepa tondulu mundupa mi lepa kene nimba mele: “Aima sika niker. “Eni nikimili yili aima naa kanoliu! Gólu tokur lem Pulu Yili-ni na topa kunjupili.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aku nirim kene enaliinga kera-kulla wale tale-sipa ko turum. Aku-sipa tirim-na piliipa kene Yesos-ni yunundu “Kera-kulla wale tale-sipa ko naa tupili nu-ni wale yupuku gólu tokunu kene “Yu naa kanoliu.” niní.” nirim ung kanili Pita kelepa piliirim. Piliipa kene ⸤‘Ama, aima tepu kis-sindu lam. ‘Aima naa tembu.’ nimbu piliirindu akili mele sika tindu.’ nimba piliipa kene⸥ kola aima lakupa tirim. ");
INSERT INTO mux_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ulsulam-ui muni-poluna kolea tangurum kene Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, kanjoll-yi kanuma pali, ⸤Yesos-nga kotele piliiku pora siku kene⸥ enini pali ⸤yunu-kene tingí mele⸥ wai toku niku panjiring. Aku-siku niku panjiku kene yunu liiku, ka siku, meku puku, ⸤Rom-gapman yi-nuim⸥ Paillet mulurumna meku puku kot tinjiring. ");
INSERT INTO mux_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paillet-ni ⸤Yesos-nga kotele piliipa kene⸥ yunu walsipa kene nimba mele: “Nu Juda-yambumanga yi nuim kingele mola móluye?” nirim. Yesos-ni pundu topa kene nimba mele: “Sika nikinu. Akili na.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pulu Yili popu tunjuring yi-aulima-ni Yesos kot tenjiku Paillet-ndu ⸤gólu toku⸥ ung pulele Yesos-kene ningíndu “Yunu tepa kis-silimú.” niku yunu kot tinjiring. ");
INSERT INTO mux_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aku-siku niringeliinga Paillet-ni Yesos-ndu nimba mele: “Nu ulu kis pulele tirinu nikimili akili nunu piliikunu kene ung te pundu tokunu naa nikinuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Akiliinga-pe Yesos-ni ⸤yu tepa kis-sirim niring mele⸥ pundu topa ung te aima naa nimba ⸤we angiliirim-na kanupa kene⸥ Paillet mini-wale mundupa numanu pulele liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","⸤Yesos kot tenjiku molangi,⸥ yi te, yunga bili Barapas, yunu kene yi mare kene ‘Rom-gapmanale-ni oliu Juda-yambuma naa nukupili.’ niku ui Rom-gapmanale-kene ele teku kene yambu mare toku kunjuringeliinga ka-lkuna piring. ⸤Puniemanga taki-taki Juda-yambuma-ni kolea-auli Jerusallem oku akuna sukundu⸥ Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingíndu langi nuring enama wendu urum kene enini ka-lkuna pirim yi te bi leku ‘Wendu liiku mundui.’ niku mawa tiring kene ⸤Rom-gapman yi-nuimele-ni⸥ yi kanili wendu liipa yambuma sirim. ");
INSERT INTO mux_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","⸤Rom yi-nuimele-ni ena kanili wendu urum-na aku tirim akili piliiku kene⸥ yambuma oku yunundu mawa teku kene niku mele: “Ui puniemanga taki-taki ena ilinga tellu kanu-mele ekupu kepe aku-sikunu teyo.” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aku-siku niring piliipa kene Paillet-ni eninindu walsipa kene nimba mele: “‘Juda-yambumanga yi nuim kingele wendu liipu eni sambu.’ niku piliikimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","⸤We-yambuma-ni Juda-yambumanga yi-aulima munduku kelku eninga ungma liiku su siku Yesos-nga ungele mindi piliiku yunu lumbili anduringeliinga⸥ Pulu Yili popu tunjuring yi-aulima-ni Yesos-kene numanu kis panjiku kene kot tinjiringele piliipa kene Paillet-ni aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akiliinga-pe Pulu Yili popu tunjuring yi-aulima-ni we-yambuma kundi toku kene niku mele: “‘Yesos mólu. Barapas wendu liipa sipili.’ niai!” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Kanu-kene ⸤yambuma-ni⸥ aku-siku niring-na piliipa kene Paillet-ni eninindu nimba mele: “Aku lem ‘Judamanga yi nuim kingele’ nilimele akili nambi teambunje?” nimba walsurum kene ");
INSERT INTO mux_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","enini tondulu munduku niku mele: “Yunu kulupili, unji-perana ⸤toku⸥ ku toku panjui!” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aku-siku niring piliipa kene yu-ni eninindu nimba mele: “Akili nambimunaye? Yunu mong nambulka mong te líímuye?” nirim. Akiliinga-pe enini ⸤alsuku⸥ aima tondulu munduku niku mele: “Mólu! Yunu kulupili, unji-perana ⸤toku⸥ ku toku panjui!” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kanu-kene Paillet-ni ‘Yambuma tepu numanu kaí panjambu.’ nimba kene yi Barapas ka-lkuna wendu liipa enini sirim. ⸤Aku tepa kene⸥ Yesos liipa ⸤yunga ami-yima⸥ sipa kene nimba mele: “Yunu ka-pulsa-ni toku kene penga ‘Unji-perana kulupili.’ niku meku puku unji-perana ⸤toku⸥ ku toku panji-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kanu-kene ⸤Rom⸥ ami-yima-ni Yesos liiku gapman yi-nuimele pirim lku auli akuna sukundu yambuma liiku máku turing koleana puku kene, eninga ami-talape-yima pali “⸤Yesos ya molemúna⸥ sukundu-sukundu wai.” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Akuna oku kene ‘Yunu yi nuim king te mele mulupili.’ niku mulumbale kunduli kaí te pakunjuku unji-ka koko mulurum te liiku mulkapiye teku kene ‘Yi nuim kingeliinga wanie-kraonele.’ niku pengína panjuku, ");
INSERT INTO mux_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","penga yunu ⸤ung-taka tonjuku⸥ bili we gólu toku paka tonjiku “Juda-yambumanga yi nuim kingele, nu angiliikunuye?” niku ");
INSERT INTO mux_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","⸤kolu-kimbulú te liiku kene⸥ yunga pengí imuna kimbulú-ni tu-pui-upui teku kene kumbi-kerina lkambe toku kanjuku, yunu angiliirimna oku koporungu languku tamalu peku yunu we gólu toku kape niku bi paka tunjuring. ");
INSERT INTO mux_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yunu aku-siku ung-taka tonjuku pora siku kene mulumbale kunduliele posuku wendu liiku yunga ui panjurum mulumbalema alsuku panjinjiku kene “Yunu unji-perana kulupili unji-perana ⸤topu⸥ ku topu panju-pamulu.” niku yunu liiku ulsukundu meku puring. ");
INSERT INTO mux_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","⸤Rom ami-yima-ni Yesos Jerusallem pala ulsukundu meku pungí puku kene,⸥ kolea Sairini yi te, yu Alleksenda kene Rupas-selenga lapa Saimon, yunu Jerusallem pumba urum kene kanuku kene yunu ambolku liiku ka-mele siku kene Yesos-nga unji-perale “Liiku tapunjikunu liiku minjui!” niku siring. ");
INSERT INTO mux_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pukuliinga kolea Golkota Yesos meku puku akuna muluring. (Golkotanga ung-pulele ‘pengí-ombele lili koleale’.) ");
INSERT INTO mux_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","⸤Yesos akuna meku puku kene, ‘Yambuma mindili naa nangi.’ niku⸥ no-waen-na sukundu marasin ‘mo’ nili te munduku nusiring no-waen akili ‘Yunu nupili.’ niku, siring akiliinga-pe Yesos-ni naa liipa nurum. ");
INSERT INTO mux_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kanu-kene ⸤ami-yima-ni⸥ yunu unji-perana ola ⸤toku⸥ ku toku panjiku kene unjele liiku ola angnjiring. Aku-siku teku kene, yunga mulumbale ⸤ui posuku wendu liiku nusuringma⸥ moke tingíndu enini lupa-lupa liingíndu ku-kas teku piliiku kene penga mulumbalema liiring. ");
INSERT INTO mux_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ena topa ena nain killok tirim kene yunu unji-perana panjiring. ");
INSERT INTO mux_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","‘Yunu mong liirim mele yambuma kanangi.’ niku YI ILI JUDA-YAMBUMANGA YI NUIM KINGELE niku bi toku unjina olakundu munjuring. ");
INSERT INTO mux_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ele tokulu mélema wa liiringli yi tale kene wasie unji tálenga ⸤toku⸥ ku toku panjiringko. Te Yesos-nga ki-bokundu ⸤toku⸥ ku toku, te ki-tarukundu ⸤toku⸥ ku toku panjiring. ");
INSERT INTO mux_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(⸤Yesos kene wa-yi tale wasie unji-pera yupukunga ⸤toku⸥ ku toku panjiringeliinga⸥ ung te ui Asaya-ni nimba bukna turum molemú akili wendu urum. Ung akili i-sipa mele: “Yunu kepe gapman ung-manima pula toku teku kis-siku mong liili yambuma kene liiku tere linjiring.” nirim.) ");
INSERT INTO mux_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Akuna oku puring yambuma-ni Yesos ⸤kanuku kis piliiku kene yunu⸥ ung-taka tonjuku ung-mura siku niku mele: “Aa! “Lku-tembollale tekisipu kene alsupu kongun ki-mong yupuku omba pupili takupu liimbu.” nirinu yili, ");
INSERT INTO mux_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","‘Naa kolumbu.’ nikunu nu-nunu teku liikunu unji-perana mania ui.” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aku-sikuko Pulu Yili popu tunjuring yi-aulima kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene enini kepe yunu ung-taka tonjuku kene niku mele: “Yunu yambu wema ‘Naa kolangi.’ nimba tepa liirim akiliinga-pe yu-yunu ‘Naa kolumbu.’ nimba manda tepa naa liikimu. ");
INSERT INTO mux_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yunu sika Pulu Yili-ni oliu ‘Nokupa konjumba yi te liipu mundumbu.’ ui nimba makó turum yi-nuim Kraisele omba molupa, yunu sika oliu Isrel-yambumanga yi nuim kingele molemú lem yunu unji-perana mania upili. Yunu mania ombá kanupu kene ‘Yunu sika Pulu Yili-ni makó topa liipa mundurum yi-nuim Kraisele. Yunu sika oliunga yi nuim kingele.’ nimbu tondulu mundupu piliimulú.” niring. Yi tale yu-kene unji-perana ⸤toku⸥ ku toku panjiring yisele-ni yunu aku-siku ung-taka tunjuringliko. ");
INSERT INTO mux_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","⸤Yesos unji-perana ola we pipili⸥ enale omba ai-tangili ena tuwallup killok tirim kene kolea pali sumbulú topa kene, penga ipinjali ena tre killok tirim kene kelepa tangurum. ");
INSERT INTO mux_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ipinjali ena tre killok tirim kene Yesos-ni nangale topa kene nimba mele: “Elloi, Elloi, llama sapaktani.” nirim. Akili Juda-yambumanga ung te. Akiliinga ung-pulele i-sipa mele: “Nanga Pulu Yili, nanga Pulu Yili, na nambimuna munduku kelkunuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akuna nondupa angiliiring yambumanga mare-ni yu-ni aku nirim kene piliiku ⸤sunduku kene⸥ niku mele: “Piliai! Yunu Illaija walsikim.” niring. ");
INSERT INTO mux_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aku-sipa nirim kene yambu piliiringmanga yi te-ni lkisipa pupa ulú-pinja mele te liipa no-waen kumbili tili mare akuna panjipa kene, ‘Yesos no-waen kumbili tili akili nupili.’ nimba memba omba unji-mumú tenga ka topa ola sirim. Sipa kene yu-ni nimba mele: “Ekupu unjina we pipili. Illaija-ni sika yunu ⸤unji-perana⸥ mania liimba ombánje, kanupu kanamili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesos-ni ung te tondulu mundupa nimba kene pe yunu kulurum. ");
INSERT INTO mux_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","⸤Rom⸥ ami-yi wan-andret nukurum yi te Yesos turing ami-yima nokupa mulurum yi kanili-ni Yesos-ni ung te nimba kene pe yunu kulurum mele piliipa kanupa kene nimba mele: “Yi ili yunu aima sika Pulu Yili-nga málale lam.” nirim. ⸤Yesos-ni aku-sipa kulurum kene ulu auli te walsekale wendu urum.⸥ Pulu Yili popu toku kaluring lku-temboll ⸤Jerusallem sukundu angiliirim akuna sukundu Pulu Yili mulurum⸥ Sulumina Aima Kake Tilieliinga keri-puluna ⸤‘Yambuma sukundu naa pangi.’ niku ui taki-taki⸥ mulumbale auli te-ni pipi siku panjiring pirim. ⸤Yesos kolupa pora sirim kene⸥ mulumbale kanili ai-suku-singina olakundu mandu-sipa olá topa ulsu purum. ");
INSERT INTO mux_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ambu mare ⸤Yesos tiring mele⸥ sulu-teku kanuku angiliiring. Akumanga ambu te Makdalla taon-na ambu Maria, te Joses kene angin Jemis kene elsengla anum Maria, te ambu Sallomi. ");
INSERT INTO mux_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yesos kolea Gallalli distrik, ⸤ambu kanumanga pulu kolea,⸥ akuna ui we andurum kene ambu kanuma-ni yunu lumbili anduku liiku tapunjuku nukuring. Yunu kene, Jerusallem olandu uring ambu pulele wema kepe, ambu talse kanuku angiliiring akuna enini kepe ⸤Yesos-kene tiring mele⸥ kanuku angiliiring. ");
INSERT INTO mux_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ulsulam-uikundu ⸤kóru muluring⸥ ena-Sambatele nondupa ola ombá tirim. Sambat enale ola ombá kene kóru mulungéliinga ekupu-mele mélema liiku undu-undu siring enale wendu urum, ena akiliinga ⸤Yesos ui kulupili⸥ kolea kalá tomba tirim kene, ");
INSERT INTO mux_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatia taon-na yi Josep, yunu Juda-yambumanga kanjoll-yi auli te, yunu kepe ‘Pulu Yili yi nuim kingele molupa oliu nokumba enale wendu upili.’ nimba nokupa mulurum yili. Yunu omba mundu-mong naa tenjipa ⸤Rom-gapman yi-nuim⸥ Paillet mulurumna sumbi-sipa pupa “Yesos-nga ónale na si.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yesos walsekale kulurumele piliipaliinga Paillet yu-ni ⸤‘Yambuma unji-perana ⸤toku⸥ ku topu panjilimulu kene ena pulele omba pupili we pelemelé. Pe ekupu yunu sika walsekale kulumnje mola nambulka tímunje?’ nimba piliipa⸥ numanu liipa mundupa ami-yi wan-andret nukurum yili “Upili.” nimba kene yunundu walsipa kene “Yesos kórunga kulumuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ami-yima nukuli yili-ni “O.” nirim kene piliipaliinga yu-ni ami-yima nukulielendu nimba mele: “Kapula, ya yili-ni ⸤Yesos-nga⸥ ónale liipili.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","⸤Paillet-ni “Kapula.” nirim kene⸥ Josep pupa mulumbale te taropu topa liipa ónale mania liipa, múlele-ni kumu topa kene ku-muru te ui ukuku nusiring ku-muru akuna sukundu memba pupa nusurum. Nosupa kene ku-muru keri-puluna ku-mulú auli te perele-marele memba omba pipi sirim. ");
INSERT INTO mux_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makdalla taon-na ambu Maria kene Joses anum Maria-seleni yunga ónale ⸤ku-muruna⸥ nusurum mele kanuringli. ");
INSERT INTO mux_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ena pupa kalá turum kene ⸤kóru muluring⸥ ena-Sambatele omba purum kene Makdalla taon-na ambu Maria kene Jemis anum Maria kene ambu Sallomi kene enini ‘Yesos-nga ónuna kopungu-wel mura tuli mare kopungu kanjinjamili.’ niku kene mare taropu toku liiku ⸤nosuku piring⸥. ");
INSERT INTO mux_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Peku kene aima ipulam-ui, eninga kumbi-leku kongun tiring enale ola ombándu ena ola urum kene ambu kanuma puku ⸤Yesos-nga⸥ ónale nusiring ku-muruna pungí puku kene, ");
INSERT INTO mux_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","anju-yandu walsiku kene niku mele: “Ku-muru keri-puléle pipi siring kuli nae-ni wendu liipa perele-marele memba pupa nosunjumbanje?” niring. ");
INSERT INTO mux_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Akiliinga-pe oku olandu-siku kanuring mele ku kanili, aima ku auliele, ui wendu liiku perele-marele meku puku nusiring, ⸤keri-puléle we lirim⸥ kanuring. ");
INSERT INTO mux_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ku-muruna sukundu puku kene ki-bokundu kang-yi te mulumbale sulu aima kake te pakupa mulurumele kanuku kene mini-wale munduku numanu liiku munduring. ");
INSERT INTO mux_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kanu-kene yu-ni eninindu nimba mele: “Numanu liiku naa mundai. Kolea Nasaret yi Yesos ‘Kulupili.’ niku talku unji-perana ⸤toku⸥ ku toku panjiring yi kanili kanungí okomelale na piliiker. Yunu lomburupa ola molupa omba pumu. Ya naa pelemú. Ónale ui nusiring koleale oku kanai. ");
INSERT INTO mux_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kanuku kene anju puku Pita kene yunga lumbili andúlima kene pali i-siku niku sangi: “Yesos kolea Gallalli distrik kumbi-lepa pulimáliinga akuna “Eni na kanungí.” ui nirim mele sika eni akuna yunu kanungí.” niku si-pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","⸤Angkellale-ni aku-sipa omba mokeringa molupa kene nirim akili⸥ kanuku piliiku kene ambuma pung-pungu niku numanu pulele liiku munduku kene ku-muruna ulsu puku munduku kelku aima lkisiku puring. Mundu-mong tekuliinga yambu tilurindu kepe kanuku piliiring mele niku naa siring. ");
INSERT INTO mux_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pulu monjuku kongun tiring enaliinga, aima ipulele-ui, Yesos lomburupa ola molupa kene, Makdalla taon ambu Maria, ui walse kuru angere yupuku-guli numanuna muluringma Yesos-ni topa makururum ambu kanili mulurumna pupa ⸤‘Na lomburupu ola mulundu we moliu akili kanupili.’ nimba⸥ liipa ora sirimele. ");
INSERT INTO mux_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kanu-kene Yesos ⸤mokeringa angiliirim⸥ kanupa kene ambale yunu pupa, ui Yesos-kene muluring yambuma mundu-mong mindili kolku kola teku muluringna pupa kene kanurum mele enini nimba sirim. ");
INSERT INTO mux_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yu-ni enini Yesos kona mulurum akili kanupa kene nimba sirim mele piliiku kene ‘Yunu gólu tokum.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","⸤Makdalla ambu Maria Yesos yunu liipa ora sipa kene,⸥ penga ⸤yu lumbili anduringimanga⸥ yambu tale ⸤kolea-auli Jerusallem munduku kelkulu⸥ kupulanum tenga-lupa puringlina Yesos yunu kumbi-keri kangiele topele topa yunu ‘kanangli.’ nimba omba mokeringa angiliirim. ");
INSERT INTO mux_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Penga yu kanuku bi sikulu kene yambu kanusele kelku yandu okulu ⸤lumbili anduli⸥ yambu wemandu elsele-ni kanuringli mele niku siringli akiliinga-pe elsele-ni niku siringli akili kepe ‘Gólu tokombele.’ niku piliiringko. ");
INSERT INTO mux_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Penga walse lumbili anduli rurepunga yupuku enini langi noku muluringna Yesos omba mokeringa molupa kene, enini ung-mura tepa kene nimba mele: “Eni na ‘Lomburupa ola mulúm.’ niku tondulu munduku naa piliiku, na kona mulundu mele yambu mare-ni kanuku kene eni niku síngi mele ‘Gólu tokomele. Akili aima aku naa tímu, kapula naa temba.’ niku pilííngi, akili nambimuna aku-siku karaye teku niku pilííngiye?” nirim. ");
INSERT INTO mux_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","⸤Aku nimba kene⸥ yu-ni eninindu nimba mele: “Eni ma-koleamanga pali puku yambuma pali temani kaiéle toku silsiliiku andu-pai. ");
INSERT INTO mux_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ningí mele piliiku kene ‘Akili sika nikimili.’ niku tondulu munduku piliiku kene no liingí yambuma ⸤kot enale wendu ombá kene⸥ Pulu Yili-ni enini tepa liipa ‘Enini mindili nolkemela koleana naa puku, molku konjuku mindi pangi.’ nimbá. Akiliinga-pe ⸤eni lumbili andúlima-ni⸥ ningí mele piliiku kene ‘Akili gólu tokomele.’ niku piliiku kene liiku su singí yambuma ⸤kot enale wendu ombá kene⸥ Pulu Yili-ni ‘Enini mindili noku mindi pungí koleana pangi.’ nimbá. ");
INSERT INTO mux_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“‘Temani akili sika.’ niku tondulu munduku piliingí yambuma ‘Na enini-kene sika moliu mele akili we-yambuma-ni niku kanangi.’ nimbále kene ulu-tonduluma tingí kene yambuma kanungí mele akili i-sipa: Enini nanga tondulale-ni kuru mare yambumanga numanuna mulungíma toku makuruku; bo-ung lupa-lupa naa piliingíma niku; ");
INSERT INTO mux_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","yambu noku kunjuli wambiyema naa kanuku kili-ni ambulungí kene akuma-ni enini naa noku kunjingí; kupuná pelemú no te naa piliiku nungí kene ulu te aima naa temba; kuru tomba yambuma kili-ni ambulungí kene kona pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Auli Yesos-ni ⸤yunga lumbili andúlima⸥ndu aku-sipa nimba pora sirim kene ⸤Pulu Yili-ni⸥ yu mulú-koleana olandu liirim. Akuna ⸤bi ola mulupili Pulu Yili-kene mélema nokumbandu⸥ Pulu Yili-nga ki-bokundu pupa mulurum. ");
INSERT INTO mux_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesos yunu mulú-koleana olandu purum kene yunga lumbili andúlima koleamanga pali puku Yesos-nga temani kaiéle yambuma toku silsiliiku anduring kene ‘Enini nanga ungma yambuma niku singí kene yambu kanuma-ni ‘Ung sikale.’ niku ung piliiku liangi.’ nimba Auliele enini-kene wasie pupa liipa tapunjurum kene yu-ni liipa mundurum yambuma enini ‘Pulu Yili-ni mindi ulu-tonduluma kapula telka mele teangi.’ nimba liipa tapunjurum. ⸤Akili manda.⸥ ");
INSERT INTO mux_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Yi aima auli Tiopillas, oliu molemulu koleana Yesos-kene ulu wendu urum-ma pulu monjupa wendu urum kene kanuku, yandupa wendu urum-ma kanulsiliiku anduku muluring yambuma-ni penga oliu temani toku siring mele, temani akili ‘Sika’ nimbu tondulu mundupu piliilimulu kanili yambu pulele-ni ‘Temani akili bukna kamu mulupili tamili.’ niku buk turing. ");
INSERT INTO mux_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Akiliinga, na-ni kepe pe kelepu ‘ ‘Temaneliinga pulele aima piliipu konjambu.’ nimbu ui-pulu-pulu wendu urum mele kepe yandupa ulu lupa-lupama wendu urum mele kepe akuma pali walsipu piliipu konjupu mulurundu-na na-ni ‘Ulu akumandu yambu mare-ni Tiopillas nundu temani toku ung-bo tonjilimele mele aku-sipa wendu urum uluma nu piliani.’ nimbu, ‘Na-ni nundu ulumanga pali aima sika wendu urum mele temani topu nimbu sambu.’ nimbu, buk te topu nu simbu kene kapula.’ nimbu piliipu kene temani akili topu buk ili tokur. ");
INSERT INTO mux_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yi Nuim King Erot kolea Judia nokupa mulurum kene Pulu Yili popu tunjurum yi te mulurum, yunga bili Sekaraya. Pulu Yili popu tunjuring yambumanga talape tenga bi Apaya, Sekaraya yu talape kaniliinga yi te. Sekaraya min ambu Illisapet Pulu Yili popu tunjuring yimanga talape tenga ambu te. Elsengla wasie kumbi-lepa anda-kolepale Pulu Yili popu tunjuring yimanga kumbi-lepa yi nuim auli Eron. ");
INSERT INTO mux_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ambu-yi akusele muluringli mele Pulu Yili-ni kanupa ‘Yambu sumbi nili-sele.’ nimba kanurum. Elsele-ni yunga ung-manima kene “Yambuma teai.” nirim mele ungma pali piliiku liiku teku konjuku muluringli. ");
INSERT INTO mux_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Akiliinga-pe Illisapet we wangnu pirim, kangambula te naa miringli. Elsele we ambu-anda liringli. ");
INSERT INTO mux_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Walse Sekaraya-nga talapele-ni Pulu Yili popu toku kaluring kongunale tinjiring kene yunu kepe wasie Pulu Yili-nga kumbi-kerina kongun kanili tinjiring. Aku tenjiku molku kene, Pulu Yili popu tunjuring yima-ni tiring mele tingíndu eninga talapena yi te Pulu Yili popu toku kaluring lku-temboll akiliinga suluminana sukundu ‘Nae pupa mura tolemú paura-kikuele yambumanga ninjipa kalonjumbanje piliamili.’ niku ku-kas tiring. Aku-siku teku kene ‘Sekaraya yu kongun kanili tenjimba.’ niku piliiringeliinga yu lku-temboll suluminana sukundu pupa mura tuli paura-kikuele kalunju-purum. ");
INSERT INTO mux_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Akili tepa angiliirim kene lku-tembolluna we-yambuma máku toku Pulu Yili popu turing koleana yambu pulele Pulu Yili-kene popu toku ung niku muluring. ");
INSERT INTO mux_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","⸤Sekaraya mura tuli paura-kikuele kalunjupa angiliirim kene⸥ paura-kiku kanili kalunju-pui-upui tiring polaliinga ki-bokundu Auliele-nga angkella te omba mokeringa angiliirim kanurum. ");
INSERT INTO mux_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Akili kanupa kene pung-pungu nimba mundu-mong auli-tepa tirim. ");
INSERT INTO mux_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanu-kene angkellale-ni yundu nimba mele: “Sekaraya, mundu-mong naa ti.” nirim. “Nu Pulu Yili-kene popu tokunu mawa tellu mele kanili Pulu Yili yu-ni piliirim. Nunga ambale kang te membá. Yunga bili “Jon” niku niani. ");
INSERT INTO mux_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu molumbáliinga nu numanu lakuku sikunu kamele akuku muluni. Yu minglí kene yambu pulele-ni numanu singí. ");
INSERT INTO mux_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Auliele-ni yu kanupa yi-auli kaiéle nimba piliimba. No-waen kepe no-tonduluma kepe aima naa nupili. Anumunga oluna we sukundu mulupili Pulu Yili-nga Mini Kake Tiliele-ni omba yunga numanuna molupa kapula tenjimba. ");
INSERT INTO mux_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Jon-ni tembaliinga Isrel-yambuma-ni eninga Auli Pulu Yili liiku bulu siring yambumanga pulele-ni alsuku numanu topele toku Auli Pulu Yili kene wasie alsuku ung piliiku kapula-kapula mulungí. ");
INSERT INTO mux_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","⸤Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi⸥ Illaija tondulu pípili uluma tepa mulurum mele Jon yu aku-sipa tondulu pípili uluma tepa molumba. Aku-sipa tondulu pípili uluma tepa molumbáliinga lapalii-ni numanu topele toku kangambulama alsuku numanu munjungíko; Pulu Yili-nga ung-manima liiku su silimele yambuma-ni numanu topele toku, numanu sumbi-nili yambuma-ni telemele mele ‘Aku-sipu teamili.’ niku mulungíko; Jon yu-ni tembaliinga Auliele ombá kene Auliele yunga ungele sumbi-siku piliiku liingí yambu-talape te mulungíko.” nimba angkellale-ni Sekaraya-ndu nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aku-sipa nirim-na piliipa kene Sekaraya-ni angkellalendu walsipa kene nimba mele: “Nikinu akili nambi-sipu na-ni ‘Sika nikinu.’ nimbu piliimbuye?” nirim. “Na anda lepu nanga ambale ambú lirim kanili. Pe nikinu ili nambi-tepa wendu ombálendu nikinuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angkellale-ni pundu topa kene nimba mele: “Nanga bili Gepriel. Na Pulu Yili-nga kumbi-kerina angiliu. Ya ekupu nundu niker akili mele Pulu Yili-ni “Aku-sikunu ni-pui.” nimba liipa mundumu-na nundu ombu temani-kaí ili topu siker. ");
INSERT INTO mux_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Akiliinga-pe na-ni “Kang minglí.” nikerele ‘Gólu tokumnje?’ niku piliikunu akiliinga ulu ili ui wendu naa upili nu ung naa niku muluni. Penga “Wendu ombá.” niker akili mele ambuma kangambula oluna monjuku kene melemelemanga kaliimbuma omba pulimú mele aku-sipa kaliimbuma omba pumba kene niker ung ili aima sika wendu ombá.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aku-siku ung niku angiliangli Sekaraya lku-temboll suluminana sukundu sulu-tepa pupa molupa, wela wendu naa urum kilia yambuma-ni lku-tembolluna ulsukundu yu nokuku muluringima numanu pulele liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kanu-kene yu wendu omba kene ung te kerina manda naa nimba kili-ni mindi manda lepa angiliirim kanuku kene, ‘Sekaraya yu suluminana sukundu molupa kene kalkale kanúmu-na omba angiliili mele te kumbi-kerale liipa pinjim-na kanum.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Penga lku-tembolluna yunga kongun enama pora nirim kene yu lkundu purum. ");
INSERT INTO mux_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lkundu pupa ⸤ambu Illisapet-kene pekulu muluringli kene⸥ penga Illisapet kangambula munjurum. Monjupa kene kaliimbu angere te-guli ‘Yambuma-ni yu naa kanangi.’ nimba mo topa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yu-ni nimba mele: “Ekupu na-kene ulu tekemale Auliele-ni nanga nimba tenjikem. Nanga kangambula te naa mirindeliinga yambuma-ni na kanuku kis piliiring kene pipili kulurundeliinga Auliele yu-ni na kondu kulum lem.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","⸤Illisapet kangambula munjupili kaliimbu angere te-guli kolupa⸥ angere tale-guli sipale ke topa pirim kene Pulu Yili-ni mulú-koleana angkella Gepriel kolea Gallalli distrik Nasaret taon-na liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Kanuna ambu-wenipu te, yi te-kene ui naa pili we mulurum ambu-wenipale mulurumna liipa mundurum. Ambu-wenipu kanili yunga pulu lirim yambuma-ni ‘Yu yi te pupili.’ niku alá sinjiring yilinga bili Josep. Yi kanili yunga anda-kolepa yi te ⸤yi nuim king⸥ Depit. Ambu-wenipaliinga bili Maria. ");
INSERT INTO mux_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maria mulurumna angkella Gepriel omba kene yundu nimba mele: “Ambale, nu mulununa na okur. Pulu Yili-ni nu aima kanupa kaí piliipa tepa kaí monjukum. Auliele nu-kene wasie tapú-toku molembele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Akiliinga-pe ung kanili piliipa kene yu numanu pulele liipa mundupa kene, ‘Apa! Nikem ili nambulka ung te nimba nikem-nje?’ nimba piliirim. ");
INSERT INTO mux_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angkellale-ni yunundu nimba mele: “Maria, Pulu Yili-ni nu kanupa kaí piliikemeliinga mundu-mong naa ti. ");
INSERT INTO mux_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Piliiyo. Nu penga kang te monjukunu minéle. Mekunu kene yunga bili “Yesos” niku sani. ");
INSERT INTO mux_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yu yi-nuim molumba, yunga bi leku ‘Aima Olandupa Molemáliinga Málale.’ ningíko; Auli Pulu Yili-ni ‘Yunga anda-kolepa Depit Isrel-yambumanga yi nuim king tondulale mulurum mele yu aku-sipa mulupili.’ nimbáko. ");
INSERT INTO mux_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eninga anda-kolepa Jekop-ni kalupa liirim yambuma yu-ni kam-kamu nokumbako. Yu yi nuim king auliele molupa mindi pupili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria-ni angkellalendu nimba mele: “Nikinu ulu ili nambi-sipa tembalendu nikinuye? Na yi te naa purundu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angkellale-ni yundu nimba mele: “Nu mulunina Aima Olandupa Yili-nga Mini Kake Tiliele omba nunga oluna kang te monjunjumba. Aku temba akiliinga kang nu-ni minéle yu kang kake tiliele molumba; yunga bili leku kene ‘Pulu Yili-nga Málale’ ningíko. ");
INSERT INTO mux_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","⸤Pulu Yili-ni nu-kene “Tembu.” nikem akili mele sika temba. Ulu-tondulu te “Tembu.” nimba kene tirim mele niambu.⸥ Nunga pulu lelemú ambu Illisapet-ndu “Ambu wangnu píliele.” nilimele akiliinga-pe ekupu yu ámbu-ambú lipili kaliimbu angere te-guli kolupa angere tale-guli-sipale ke topa angiliipili yu kang monjukum kanili. ");
INSERT INTO mux_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pulu Yili-ni ulu kapula naa temba ulu te aima naa pelemú. Yu-ni uluma pali kapula telemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","⸤Angkellale-ni yundu aku-sipa nirim-na piliipa kene⸥ Maria-ni nimba mele: “Na Auliele-nga kongun kendemande ambale moliu. Nu-ni nikinu akili mele Pulu Yili yu-ni na-kene aku-sipa tipili.” nirim. Kanu-kene angkellale-ni Maria mundupa kelepa yu purum. ");
INSERT INTO mux_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","⸤Mulú-koleana angkellale-ni Maria-ndu ung nimba pora sipa kene kelepa purum kene⸥ penga Maria kolea Judia distrik pupa ma-pangi tenga olakundu taon te lirimna purum. ");
INSERT INTO mux_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pupa akuna yi Sekaraya-nga lkuna lkundu pupa kene ambu Illisapet kanupa “Na okur.” nirim kene kangulkulu ⸤numanu siringli⸥. ");
INSERT INTO mux_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Illisapet-ni Maria-nga ungele piliirim kene Illisapet yunga oluna kangambulale puka topa ola-mania tirim piliirim. Kanu-kene Pulu Yili-nga Mini Kake Tiliele Illisapet-nga numanuna omba molupa kapula tirim kene “I-sikunu i-sikunu ni.” nirim akili ");
INSERT INTO mux_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Illisapet-ni ung tondulu nimba kene nimba mele: “Ambu molemelemanga pali nu maluya. Ambumanga pali Pulu Yili-ni nu olandupa tepa kaí munjurum. Kangambula nu monjullale kepe yu-ni tepa kaíko monjumba. ");
INSERT INTO mux_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ambu kis te mulunduna nanga Auliele-nga anumele nu úneliinga na numanu pulele liipu mundukur. Tinu akiliinga na-kene teku kaí monjukunu. ");
INSERT INTO mux_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nu oku kene “Na okur.” níneliinga kumele-ni piliindu kene nanga oluna mulúm kangambulale aima numanu sipa puka topa ola-mania tímu. ");
INSERT INTO mux_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Auliele-ni nundu nirim mele ungele piliikunu kene ‘Sika nikem. Yu-ni “Tembu.” nikem akili mele sika aku temba.’ niku tondulu mundukunu piliirineliinga yu-ni nu tepa kaí monjukum akili mele akiliinga nu numanu sikunu molani.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Illisapet-ni nimba pora sirim kene Maria-ni nimba mele: “Pulu Yili na Tepa Liipa, Mindili Nombu Molupu Kis-Siliu Kupulanum-na Wendu Liipa, Kapula Molupu Konjumbu Kupulanum-na Liipa Monjumba Yili kene na numanu aima lakupu sikereliinga nanga numanale-ni Auliele kape nimba bi paka tonjukumu. ");
INSERT INTO mux_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pulu Yili yu-ni na yunga we-kendemande-ambu kisele mundupa naa kelepa numanu liipa mundurumeliinga nanga numanale-ni aku-sipa yu kape nikem. Yambuma-ni penga-penga kepe kalku liingí yambuma-ni nandu “Pulu Yili-ni nu tepa kaí monjukum. Nu maluya.” ningí. ");
INSERT INTO mux_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tondulu Pulieli-ni na ulu-tonduluma tinjirimeliinga nandu aku-siku ningí. Tondulu Puliele yu yi kake tiliele. ");
INSERT INTO mux_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yu-kene mundu-mong teku ung piliiku liilimele yambuma yu-ni kondu kolupa molemú. Enini penga-penga kepe kalku liingíma kepe kondu kolupa molupa mindi pumba. ");
INSERT INTO mux_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yu-ni yunu ulu-tonduluma tirim. Yambu kara puku eninga numanuna enini kape niku molemele yambuma yu-ni topa makurupa bulu-bale silimú. ");
INSERT INTO mux_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yambuma nuim molku koleama nokuku molemelema yu-ni topa mania mundupa, yambuma eninga bima eni-enini toku mania mundulimelema yu-ni eninga bima paka tonjulemú. ");
INSERT INTO mux_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Engle-ni kolemele yambuma yu-ni ‘Olu tipili.’ nimba langi kaíma sipa, yambu kamakoma mélema kepe naa sipa “We pai.” nimba makorolemú. ");
INSERT INTO mux_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yu-ni oliunga kumbi-lepa anda-kolepalimandu “Tembu.” nimba, nimba panjurum ungele apera naa sipa piliipa molupa kene, ⸤anda-kolepa⸥ Eprayam kene, Eprayam yu-ni yandupa-yandupa kalupa liirim yambuma kene, eninindu “Tembu.” nimba, nimba panjurum akili mele tembandu oliu Pulu Yili yunga kendemande Isrel-yambu molemulu akuma yu-ni kondu kolupa liipa tapunjumba tepa molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria yu Illisapet kene wasie molangli kaliimbu yupuku omba purum kanu-kene penga Maria yu yunga lku-koleandu kelepa purum. ");
INSERT INTO mux_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Illisapet kangambula membá enale wendu urum kene yu-ni kang te mirim. ");
INSERT INTO mux_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yunga lku-keri-kupu yambuma kene yunga pulu lirim yambuma kene Auliele-ni yu kondu lakupa kulurum mele piliiku kene enini yu-kene wasie numanu siku muluring. ");
INSERT INTO mux_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ena angere yupuku-guli kangale memba nosupa mulurum kene ena engkaki-sipaliinga yambuma sukundu-sukundu oku máku toku kene yunga kangi te kopsiku poku teku wendu liiku munduku kene, yunga bili yunga lapanga bili manda leku “‘Sekaraya’ niamili.” niring ");
INSERT INTO mux_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","akiliinga-pe kangalenga anumu-ni “Mólu.” nimba kene “Yunga bili ‘Jon’ nimulú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Enini yundu niku mele: “Elsengla pulu lelemú yambu tenga bili aku-sipa naa molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kanu-kene yambuma-ni niku mele: “lápale-ni nambulka nimba piliikemunje, yunga bili lepa nae nimbánje, walsipu piliamili.” niku lapandu kili-ni manda leku niring kene ");
INSERT INTO mux_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","yu-ni pundu topa kili-ni manda lepa kene “Buk te sai.” nimba kene, yu-ni bukna bi topa kene nimba mele: “Yunga bili Jon.” nirim. Akili kanuku kene yambuma-ni aima numanu pulele piliiring. ");
INSERT INTO mux_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kanu-kene walsekale Sekaraya yunga kerina kelepa ung nimba kene Pulu Yili kape nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Aku-sipa tirim-na kanuku kene yunga lku-keri-kupu yambuma-ni aima mini-wale munduring. Kolea Judia distrik sukundu ma-pangimanga kolea lirimumanga pali temani akili mindi tolsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ulu akili piliiring kene yambuma-ni pali numanu liiku munduku kene niku mele: “Ulu akili we naa telemú. Auliele kang ili-kene molumbáliinga ulu akili tekem lem.” niku piliiku kene “Kang ili penga nambi-sipa molumbanje?” niring. ");
INSERT INTO mux_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Mini Kake Tiliele Jon-lapa Sekaraya-nga numanuna omba molupa kapula tirim kene Pulu Yili-ni penga wendu ombá mele “Nikunu si.” nimba yundu nimba sirim ung te piliipa kene, Sekaraya yu-ni yambuma nimba sipa nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Auliele, Isrel-yambumanga Pulu Yili, yu kape nimbu bi paka tunjamili. Yu omba yunga yambuma tepa liipa buni te-ni enini ambulurumeliinga mindili noku muluring buni kanuna wendu líímeliinga piliipu kene yu kape nimbu bi paka tunjamili. ");
INSERT INTO mux_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pulu Yili-ni yunga kendemande ⸤yi nuim king⸥ Depit-ni kalupa liirim yambumanga yi tondulu pili te oliu ‘Tepa liipa mindili nombu molupu kis-silimulu kupulanum-na wendu liipa, kapula molupu konjumulú kupulanum-na liipa munjupili.’ nimba símu. ");
INSERT INTO mux_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(Yu-ni “Ninjai!” nimba ung nimba sirimuma piliiku yandu niku siring yima-ni penga tembalendu kórunga-ui niku mele:) ");
INSERT INTO mux_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Yu-ni oliu tepa liipa oliunga ele-túma topa makurunjupa, oliu kanuku kis piliiku mindili silimele yambuma ‘Aku-siku naa teangi. Wendu oku kapula molangi.’ nimba aku-siku telemele kupulanum-na wendu liimba.” niring mele ekupu aku temba tekem. ");
INSERT INTO mux_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Oliunga anda-kolepalima kondu kolupa, oliunga kumbi-lepa anda-kolepa Eprayam-kene “Tembu.” nimba, nimba panjipa mi lirim mele “apera naa sipu, nirindu mele teambu.” nimba kene aku temba tekem. ");
INSERT INTO mux_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","‘Mundu-mong naa teku, nanga kongunale tondulu munduku tenjiku, numanuna kake tipili molku na-ni kanupu kaí piliiliu uluma mindi ma-koleana teku mololsiliiku pangi.’ nimba kene oliunga ele-túma-ni oliu toku mindili liiku silimelema ‘Naa teangi. Oliu we molamili. Tepu liipu, tokomele kupulanum-na wendu liimbu.’ nimba, nimba panjipa mi lirim mele ‘Teambu.’ nimba kene aku tekem.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Nanga kang ⸤Jon⸥, nu kumbi-leku pukunu Auliele ombá kupulanumele akisinjenéliinga piliikunu kene, yambuma-ni penga nundu ‘Olandupa Molemáliinga ung “Ninjui.” nimba, nimba silimú ungma piliipa yandu nimba sili yili’ ningí. ");
INSERT INTO mux_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","‘Auliele yunga kupulanumele akisinjambu.’ nikunu kene nu-ni yunga yambumandu i-sikunu nikunu sini: “Auliele yunu-ni eninga ulu-pulu-kis telemelema ‘Mania pupili.’ nimba kanupa konde tenjipa kene enini tepa liipa mindili nolkemela kupulanum-na wendu liipa, yu-kene wasie molku kunjingí kupulanum-na liipa monjumba.” niku, ung akili eninindu nikunu sini. ");
INSERT INTO mux_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Pulu Yili-ni oliu kondu lakupa kolupa kene oliu sumbulú túlina molupu kululi kupulanum-na molomulúma numanu waengu nipili molomulú kupulanum-na ‘Kapula kanuku pangi.’ nimba ‘Pa tinjipili.’ nimba oliu molemuluna talangele liipa mundukum.” nimba Sekaraya-ni nirim. ");
INSERT INTO mux_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kang Jon yu ai lepa numanu tondulu pupa kapula mulurum. Yu penga Isrel-yambumanga kumbi-kerina kongun tepa molumbandu ui kolea-wakana pupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","⸤Jon kang-pamele mulupili⸥ Rom-Gapman-Yi Aima Auli Kumbina ‘Sisa-Okastas’ niliele-ni ung-mani te nimba panjipa kene “Rom-gapmanale-ni nokulemú koleamanga molemele yambuma pali bi liamili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kirinias kolea Siria propinj nukurum yili mulupili Rom-gapmanale-ni yambumanga bima kumbi-lepa liirim.) ");
INSERT INTO mux_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","⸤Ung-mani akili Okastas-ni nimba panjurum-na⸥ yambuma pali eninga anda-kolepalima-ni kalku liiring koleamanga lupa-lupa enini puring. ");
INSERT INTO mux_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yi Josep kolea Gallalli distrik Nasaret taon-na molupa, ⸤Rom-yi nuimele-ni ‘Yambuma bi liamili.’ nirimele⸥ piliipaliinga, Nasaret mundupa kelepa, yunga kalupa liirim anda-kolepa Depit ui pirim kolea Judia distrik pupa Betelliem taon-na purum. ");
INSERT INTO mux_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Akuna “Olsungla bisele tangi sambili pambili.” nikulu yunga alá sirim nondupa liimba ambu Maria kene akuna puringli. Maria kangambula lku piliele wasie puringli. ");
INSERT INTO mux_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Betelliem sukundu pukulu kene, yambu poningma oku pi-pui-upui tiring lkuli si nirim kilia ⸤elsele kung dongki kene kaoma kene panjiring lkuna puku piringli. Akuna piringli kene⸥ Maria kangambula bulu turum. Penga kang te mirim. Kang akili yunga komulayele. Memba kene mulumbale mare-ni liipa kangale okupa, kungmanga langi nuli unji, kera laima no-unji mele, tenga sukundu mundupa nusurum. ");
INSERT INTO mux_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","⸤Betelliem⸥ ulsukundu kung-sipsip tápu-yi mare era-puniemanga sumbulsuli eninga sipsipma tápu-teku muluring. ");
INSERT INTO mux_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kanu-kene enini muluringna Auliele-nga angkella te omba mokeringa angiliirim kanuku, Auliele-nga talang tondulu-tepa puliele omba enini muluring koleana mania talang tepa pa tondulu-tepa tirim kanuku kene, enini mini-wale lakuku munduring. ");
INSERT INTO mux_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Akiliinga-pe angkellale-ni nimba mele: “Na-ni eni temani kaí te topu simbu okur akiliinga mundu-mong naa teai. Temani ili yambuma pali numanu singí temanele. ");
INSERT INTO mux_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ekupu ⸤ui mulurum yi nuim king⸥ Depit-nga taon-na ambu te-ni kang te mimu. Yunu Yambuma Tepa Liipa Mindili Noku Molku Kis-Silimele Kupulanum-na Wendu Liipa, Kapula Molku Kunjingí Kupulanum-na Liipa Monjumba Kangale; yunu Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim Kraisele; yu Auliele. ");
INSERT INTO mux_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Sika niker mola gólu tokur-nje eni puku kanangi mele nimbu sambu. Kangambula-kiki te mulumbale-ni kumu toku, kungmanga langi nuli unji, kera-laima no-unji mele, tenga nusingí puku kanuku liingí. Aku-siku kanuku liiku kene na-ni ‘Sika nim lem.’ niku piliingí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aku-sipa nirim kene enaliinga mulú-koleana angkella aima pulele ui urum angkellale angiliirimna oku mokeringa angiliiku kene, Pulu Yili-nga bili paka tonjuku yunu kape niku kene niku mele: ");
INSERT INTO mux_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mulú-Koleana Aima Olandupa Pulu Yili-nga bili aima ola mulupili. Mana-yambu yu-ni kanupa kaí piliilimú yambuma, numanu waengu nipili molangi.” niring. ");
INSERT INTO mux_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aku niku kene enini kung-sipsip tápu-yima munduku kelku mulú-koleana kelku olandu puring. Angkellama kelku mulú-koleana olandu puring kene sipsip tápu-yima-ni anju-yandu niku mele: “Oliu Betelliem pupu ya ulu ekupu wendu okum mele Auliele-ni nimba símu ung kanili kanu-pamulu.” niring. ");
INSERT INTO mux_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aku-siku niku kene lkisiku puku kene, Maria Josep-sele muluringli kanuku, kangambula kikiele kungmanga langi nuli unji, kera-laime no-unji mele, tenga sukundu lirim kanuring. ");
INSERT INTO mux_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yunu kanuku kene, ui angkellale-ni enini kangambula akilindu nimba sirimele mele yambuma temani toku siring. ");
INSERT INTO mux_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kanu-kene sipsip tápu-yima-ni niku siring mele piliiku kene yambuma-ni numanu pulele liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Akiliinga-pe Maria ung ima kene ulu wendu urum-ma pali numanuna panjipaliinga, penga wasie numanu kimbu-sipa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sipsip tápu-yima kelku yandu oku kene, angkellale-ni nimba sirim mele pali piliiku kanuringeliinga Pulu Yili kape nilsiliiku yunga bili paka tonjulsiliiku yandu uring. ");
INSERT INTO mux_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kangale meku nosuku molangi ena angere yupuku-guli omba purum kene ena engkaki-sipaliinga yunga kangi te kopsiku poku teku wendu liiku kene, anumu-ni oluna naa munjupili angkellale-ni nirim mele piliiku kene yunga bili “Yesos” niku liring. ");
INSERT INTO mux_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Maria ⸤kang mirimeliinga⸥ “Yunu kalaru molemú.” niringeliinga enama pora nimba, yunu kamu kake tipili molumba enale wendu urum-na Moses-ni ⸤“I-siku uluma teai!” nimba⸥ ung-mani sirimele te piliiku liiku tinglíndu Josep kene elsele kolea-auli Jerusallem pukulu kene, kake tipili mulunglindu Pulu Yili popu toku kalu-puringli. Auliele-nga ung-mani te ui sirimele pirim akili i-sipa mele: ⸤‘Ambu te-ni kangambula memba kene ambale yunu ku-puku tuli mele molumba. Ku-puku tuli enama pora nimbá kene kake tipili molumbandu⸥ kera-waembonu mele tale mola kera-imili mele tale Pulu Yili popu topa kalupa sipili.’ nimba ung-mani aku-sipa nimba pirim kanili piliiku kene tinglíndu puringli. Auliele-nga ung-mani pirim te kene wasie piliiku liiku tinglíndu puringliko. Ung-mani akili i-sipa mele: ‘Kang-komulaye mingíma pali “Auliele-nga” niku yunu sangi.’ nimba pirim kanili. Ung-mani akili nimba pirim-na piliikulu kene ‘Olsungla kang-komale Pulu Yi Auliele sambili.’ nikululiinga Jerusallem punglindu Yesos meku puringliko. ");
INSERT INTO mux_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yi-anda te Jerusallem mulupili elsele akuna puringli, yunga bili Simion. Yu sumbi-nili yili; yu Pulu Yili-nga ungele piliipa taki-taki Pulu Yili kene ung nirim yili; yu Isrel-yambuma tepa numanu waengu simba yili “ombá.” nimba kanombandu nokupa mulurum; Mini Kake Tiliele yunga numanuna sukundu mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mini Kake Tiliele-ni yunundu ung te ui nimba mele: “Nu ui naa kuluni. Nu Auliele-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba makó turum yi-nuim Kraisele kanukunu kene penga kuluni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mini Kake Tiliele-ni Simion yunu liipa mundurum-na yunu Pulu Yili popu toku kaluring lku-tembolluna purum. Kanu-kene Yesos anum lapasele ung-manele-ni kangmandu “Teai.” nimba nirim mele tinglíndu kang Yesos mekulu lku-tembolluna sukundu puringli kene ");
INSERT INTO mux_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion-ni omba kangale kanglupa liipa Pulu Yili-nga bili paka tonjupa nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Yi Auli Tondulu Olandupale, yambuma tepa liipa, mindili nolkemela kupulanum-na wendu liipa nu-kene wasie molku kunjingí kupulanum-na liipa monjumba yi sikenele na ekupu nanga mongsele-ni kanokur kene ui nandu niku panjirinu mele wendu okum akiliinga ekupu na nunga kendemande-yili numanu waengu nipili kolumbu.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","“‘Tepa liipa wendu liili ulu kanili koleamanga pali yambuma-ni kanangi.’ niku tekenu. ");
INSERT INTO mux_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yunu Isrel-yambumanga ulsu molemele yambumanga pa tenjipa, nunga Isrel-yambumanga bili paka tonjumbandu talang mélale molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Anum lapasele Simion-ni kang Yesos-ndu nirim mele akili piliikulu kene numanu pulele liiku munduringli. ");
INSERT INTO mux_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion-ni “Pulu Yili-ni eni tepa kaí tipili.” nimba kene Yesos anum Maria-ndu nimba mele: “Piliiyo. Kang ili molumbáliinga Isrel-yambu pulele bi ui mulurumuma penga mania pungíko; pulele bi ui naa mulurumuma pe ekupu bi molumbako. Yunu molumba kene yambuma-ni kanuku kene liiku bulu siku ung-taka tunjingí. ");
INSERT INTO mux_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ambale, nu kepe ulu te wendu ombá. Nunga numanuna mindili auli-tepa temba kene yambu pulele numanu piliingí mele mokeringa lemba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim ambu te, yunga bili Ana, yunu Juda-yambumanga talape kelú Asa, yi Panuel-nga limin; yunu aima ambú lepa pora sirim; yunga min-yili kene wasie molangli punie angere yupuku-guli omba purum, penga yunga min kulurum kene yunu ambu-wayele mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Yunu mana mulupili yunga punie paon angere alsupa ki-mong yupuku omba pupa alsupa ki-mong angere-sipaliinga yu we mulurum. Yu lku-tembollale mundupa naa kelepa kene taki-taki kanuna mindi molupa sumbulsuli kepe tanguli kepe Pulu Yili popu topa bi paka tonjumbandu taki-taki langi naa nomba Pulu Yili-kene popu topa ung nimba mawa tepa mindi mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simion-ni Yesos-ndu ung nimba mulupili enini muluringna ambu kanili yunu omba kene ⸤Pulu Yili-ni kang kanili Juda-yambuma sirimeliinga⸥ Pulu Yili kene “Angke, kapula tekenu.” nirim. Kanu-kene pe Jerusallem yambuma tepa liipa, buni te-ni enini ambulurum-na mindili noku muluring buni kaniliinga wendu liimbandu ombá yili ‘Ombá.’ niku nokuku muluring yambumandu Ana yu-ni kang akili urum mele kene temba mele kene nimba sirim. ");
INSERT INTO mux_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep Maria-sele elsele-ni Auliele-nga ung-manisele nimba pirim mele pali piliiku liiku tekululiinga elsele Yesos-kene kelkulu kolea Gallalli distrik pukulu elsengla kolea-kelú Nasaret yandu uringli. ");
INSERT INTO mux_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kangale ai lepa tondulu pupa molupa yunga numanuna piliipa kungnjuli pulele pípili mulurum, Pulu Yili-ni yunu kanupa kaí piliipa yu nokupa kunjurum. ");
INSERT INTO mux_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juda-yambuma-ni puniemanga taki-taki kolea-auli Jerusallem oku akuna sukundu Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele akili piliiku ulu mare tiring ena kanuma Yesos anum lapasele kepe ‘Ena kanili piliambili.’ nikulu puniemanga taki-taki Jerusallem olandu puringli. ");
INSERT INTO mux_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kang Yesos mulupili yunga punie engkaki-rurepu omba purum kene ena kanili ‘Pulu Yili-nga enale.’ niku kóru muluring enale alsupa wendu urum kene taki-taki Juda-yambuma Jerusallem puring mele Yesos anum lapasele kene yunu kene wasie olandu puring. ");
INSERT INTO mux_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","⸤Jerusallem puku⸥ ulu kanili piliiring enama pali pora nirim kene anum lapasele lku-kolea punglí puringli kene kang Yesos anju mulurumele naa kanuringli. ");
INSERT INTO mux_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","‘Oliunga yambu mare kene okum.’ niku piliikulu ena tilueliinga we pukulu kene, penga ipinjali kolea kalá turum kene puku kupulanum-na síng-lku pingíndu elsengla pulu lirim yambuma kene we-yambuma kene pali puku muluringmandu walsiku piliilsiliiku anduku kururingli. ");
INSERT INTO mux_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yunu naa kanuku lekulu kene Jerusallem alsuku pukulu kuru-puringli. ");
INSERT INTO mux_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ena tale koruku kelkululiinga, penga ena yupuku-sipaliinga ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna puku kanuringli kene yunu akuna sukundu mulurum kanuku liringli. Yunu ung-manimanga puluma piliiku ung-bo tonjuku mani siring yima kene wasie muluring, yu-ni eninga ung niringma piliipa kene, anju eninindu ung mare walsipa piliirim-ko. ");
INSERT INTO mux_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Enini niringma yu-ni mimi-sipa piliirim akili mele kepe, pundu topa nimba kunjurum akili mele kepe, yambu muluringma-ni piliiku kene enini ‘Yunga piliipa kungnjuli aima pelemú.’ niku piliiku numanu liiku munduku mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Elsele-ni yunu lku kanuna mulurum puku kanukulu kene suru nikulu anumu-ni yunundu nimba mele: “Kangale, olsu kene wasie pamili ui naa okunu, nambimuna tinuye? Lanie olsu mini-wale mundupulu nu andupu korupu kilímbulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Aku nirim kene yu-ni anum lapaselendu nimba mele: “Else ⸤koleamanga pali⸥ nambimuna na anduku kurúngliye? ‘Na ya Tatanga lkuna molemú.’ niku naa pilííngliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Akiliinga-pe yu-ni nirim ung-pulele elsele-ni naa piliiringli. ");
INSERT INTO mux_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yu-ni elsele-kene Nasaret taon mandu pupa kene, elsengla ungma piliipa teng panjipa mulurum. Yunga anumu-ni ulu kanuma numanuna panjipa piliipa mindi mulurum. ");
INSERT INTO mux_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesos yunu ai lemba lirim kene yu piliipa kungnjuli olandupa-olandupa pemba pirim; Pulu Yili kene yambuma kene yunu kanuku aima kaí piliiku muluringko. ");
INSERT INTO mux_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Yi Tapirias-Sisa, Rom-gapmanale-ni nukurum koleamanga pali, Isrel-yambumanga kolea akumanga pali kepe, yunu yi aima auli kumbinale mulurum. Yunu kolea kanumanga pali Rom-yi aima auli kumbinale mulupili punie ten-po omba pupa punie ten-paip sipale wendu urum kene yunu aku-sipa we mulurum. Punie kaniliinga Pondias-Paillet kolea Judia distrik yambumanga yi-nuimele mulurum; Erot kolea Gallalli distrik yambumanga yi-nuimele mulurum; Erot angin Pillip kolea Ituria distrik kene Terekonaitis distrik-sele yambumanga yi-nuimele mulurum; LLaisenias kolea Apillini distrik yambumanga yi-nuimele mulurum. ");
INSERT INTO mux_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Enini kolea akuma nokuku molangi Anas kene Kayapas-sele Pulu Yili popu tunjuring yi-auli olandupasele molangli Sekaraya málu Jon kolea-wakana mulurum kene Pulu Yili-ni Jon yunu “I-sikunu i-sikunu niku sinjui.” nimba, nimba sirim. ");
INSERT INTO mux_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pulu Yili-ni “Niku sinjui.” nimba, nimba sirim kene piliipaliinga Jon yunu pupa no-Jodan nekendu-yakundumanga andupa yambuma ung-mani sipa kene nimba mele: “Eni ulu-pulu-kis telemelema kanuku kis piliiku numanu topele toku kene ‘Pulu Yili-ni oliunga ulu-pulu-kisma ‘We mania pupili.’ nimba kanupa konde tinjipili.’ niku ‘No liamili.’ niku wai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","⸤Kongun akili Jon-ni tirim mele yunu naa mulupili kórunga-ui yunu-ni yambuma Yesos-nga ungma sumbi-siku ung piliiku liingí kupulanumele liipa nosunjumba mele⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni nimba bukna turum akuna molemú akili i-sipa mele: “Kolea-wakana ⸤kumbi-lepa pumba⸥ yi tenga kerina ung te nimba mele: “Auliele ombá kupulanumele akisinjai. Yunu ombá kupulanum kelúma toku sumbi sai.” nikem. ");
INSERT INTO mux_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“Ma-pangima ukuku kalalu siku, kolu lelemúmanga ukuku pe toku, kupulanum kimbusilima toku sumbi-siku, kupulanum ola mania pulimúma kulsa lingí. ");
INSERT INTO mux_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aku-siku tingí kene Pulu Yili-ni oliu tepa liipa ‘Mindili nolkemela kupulanum-na wendu oku yu-kene wasie molku kunjingí kupulanum-na pai.’ nimba liipa mundumba yili yambuma-ni pali kanungí.” nikem.” nimba ⸤Jon-ni penga temba mele Asaya-ni ui aku-sipa nimba sipa bukna turum molemú.⸥ ");
INSERT INTO mux_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yambu pulele Jon mulurumna ‘Yunu-ni oliu no liinjipili.’ niku ungí uring kene yunu-ni kanupa kene, enini ung-mura sipa kene nimba mele: “Gólu topa yambuma tepa kis-sili wambiyelenga walúma, Pulu Yili arerembi kolumba enaliinga nae-ni “Eni takara toku pai.” nimu-na eni ‘Pulu Yili-ni naa tepa kis-sipili.’ niku ‘No liamili.’ niku okumeleye? ");
INSERT INTO mux_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Eni sumbi-siku molku, ulu kaíma mindi teku mulungí kene eni ulu-pulu-kis tiringma aima sika munduku kelku numanu topele tungí mele mokeringa lemba. “Oliu anda-kolepa Eprayam-ni kalupa liirimuma molemuláliinga yambu kaíma molemulu.” niku aku-siku niku naa piliai. Na-ni eni nimbu siker: ‘Pulu Yili-ni ku-mulú imandu “Eprayam-ni kalupa liirim yambuma au talangi.” nilkanje ku-mulúma Eprayam-ni kalupa liirim yambuma molkemela.’ niker. Eni Eprayam-ni kalupa liirim yambuma molemeláliinga ulu te naa telemú. ");
INSERT INTO mux_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Unji peki tomba luli Pulu Yili-ni kórunga unji-puluna ambulupa ola liipa molemú. Unji mong kaí naa tombama yu-ni peki topa kene tepina kalomba.” nimba Jon-ni aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","⸤Yambu Pulu Yili kanupa kaí piliilimú ulu-puluma naa telemelema Pulu Yili yunu-ni “Mindili nangi.” nimbá akili Jon-ni nimba sirim kene piliiku kene⸥ oku máku turing yambuma-ni niku mele: “Aku lem ⸤‘Yu-ni oliu “Mindili nai.” naa nipili.’ nimbu⸥ nambulka temulúye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yu-ni eninindu pundu topa nimba mele: “Wale-pakuli tale nosulimele yambuma eni yambu wale-pakuli te naa nusingíma moke teku sangi. Langima kepe aku-siku teangiko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ku-moni-takis liili yima kepe ‘No liamili.’ niku uring. Yu-ni ung nirim mele piliiku kene yundu walsiku piliiku kene niku mele: “Ung-Bo Tunjuliele, oliu nambulka temulú kene Pulu Yili yu-ni oliu kanupa kaí piliimbaye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yu-ni eninindu nimba mele: “Eni ku-moni-takis liiku kene gapmanale yu-ni “Ku i-siku liai.” nimba makó topa simba mele liai. Eni gólu toku mare ola panjiku liilimele akili mele naa liai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kanu-kene ami-yi mare-ni yu walsiku piliiku kene, “Oliu kepe nambulka teamiliye?” niring. Yu-ni pundu topa kene nimba mele: “Eni yambumanga ku-moni wa liingíndu gólu toku kimbulú-ni we naa tai. Gapmanale-ni méle kalomba kuli mindi liiku nosuku, táka-niku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jon-ni tirim mele kanuku kene yambuma-ni yu-kene numanu pulele liiku munduku, ‘Pulu Yili-ni oliunga anda-kolepalimandu “Enini nokupa konjumba yi te liipu mundumbu.” nirim yi-nuim Kraisele ya yi ilinje?’ niku piliiku muluring. ");
INSERT INTO mux_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Niku piliiring mele piliipaliinga Jon-ni pundu topa kene eninindu nimba mele: “Na-ni yambuma no mindi liinjiliu. Akiliinga-pe yi te ombále yu-ni ⸤Pulu Yili-nga⸥ Mini Kake Tiliele kene tepéle kene eni liinjimba ⸤liingí⸥. Ombá yi ili yunga tondulale aima olandupa, nanga tondulale aima mania-kilia. Na yunu-kene kapula mólu. ⸤Yambu-aulimanga kongun kis tili kendemande-yambuma-ni sika eninga aulimanga kongun kísma tinjingíndu kimbu-suma wendu liinjilimele akiliinga-pe⸥ ombá yilinga kimbu-su wendu liinjimbu kongun kanili aima olandupa mele na-ni kapula naa tenjilka, na yi aima kisele. ");
INSERT INTO mux_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yu-ni yunga rais-wit apuruli apulu-pokale ambulupa kene yunga rais-wit mongma kene rais-wit kiluma kene apurumbandu molemú. Yunga rais-wit apuruli polale tepa mimi tembandu rais-witma pali apurupa wendu liipa kene monguma liipa rais-wit nosilimú lkuna ‘Lipili.’ nimba nosimbandu lku liipa nosupa, penga kiluma liipa máku topa tepi naa kumbulupa nomba pepa mindi pulimúna kalomba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","‘Yambuma-ni “Oliu yambu molupu kis-silimulu yambuma. Oliu ulu-pulu-kisma mundupu kelepu numanu topele tamili.” niangi.’ nimba Jon-ni yambuma ung-mani pulele aku-sipa sipa, temani kaiéle topa sirim. ");
INSERT INTO mux_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Walse, penga mele, Jon-ni kolea Gallalli distrik yambumanga yi nuim king Erot ung-mura sirimko. Yunu anginunga ambu min Erodias ⸤mangupa liirim⸥ ulele kene ulu-pulu-kis lupa-lupa pulele tirim-ma kene nimba para sipa yunu ung-mura sirim. ");
INSERT INTO mux_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jon-ni yunu ung-mura sirimeliinga Erot-ni arerembi kolupa kene yunu ka sipa ka-lkuna panjurum. Yunu-ni aku tirimele tepa kis-sirimko. ");
INSERT INTO mux_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","⸤Erot-ni Jon ui ka naa sipili⸥ yambu pulele Jon no liinjipa mulurumna oku no liiring kene Yesos kepe omba no liirimko. No liipa kene Pulu Yili-kene popu topa ung nimba angiliirim kene mulále takape nimba anju-yandu purum. ");
INSERT INTO mux_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pulu Yili-nga Minéle, kera-waembonu mele, mania omba Yesos mulurumna pupa ⸤kangina⸥ ola mulurum. Mulúna ung te wendu omba kene nimba mele: “Nu nanga numanu monjuliu kangale. Nu-kene numanu siliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesos yunu mana mulupili punie wan paon ten mele omba purum kene yunga kongunale pulu monjupa tirim. Yambuma-ni Yesos-ndu ‘Josep málale.’ niku piliiring. Josep yunga lapa Illai. ");
INSERT INTO mux_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Illai lapa Matat. Matat lapa LLipai. LLipai lapa Melkai. Melkai lapa Janai. Janai lapa Josep. ");
INSERT INTO mux_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep lapa Matatayas. Matatayas lapa Emos. Emos lapa Neam. Neam lapa Esillai. Esillai lapa Nakai. ");
INSERT INTO mux_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai lapa Meat. Meat lapa Matatayas. Matatayas lapa Semein. Semein lapa Josek. Josek lapa Joda. ");
INSERT INTO mux_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda lapa Joanan. Joanan lapa Resa. Resa lapa Serapapel. Serapapel lapa Sialtel. Sialtel lapa Neri. ");
INSERT INTO mux_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri lapa Melkai. Melkai lapa Edai. Edai lapa Kosam. Kosam lapa Ellemadam. Ellemadam lapa Ere. ");
INSERT INTO mux_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere lapa Josua. Josua lapa Elliesa. Elliesa lapa Jorim. Jorim lapa Matat. Matat lapa LLipai. ");
INSERT INTO mux_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","LLipai lapa Simion. Simion lapa Juda. Juda lapa Josep. Josep lapa Jonam. Jonam lapa Ellayakim. ");
INSERT INTO mux_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ellayakim lapa Mellia. Mellia lapa Mana. Mana lapa Matata. Matata lapa Netan. Netan lapa ⸤Yi Nuim King⸥ Depit. ");
INSERT INTO mux_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Depit lapa Jesi. Jesi lapa Opet. Opet lapa Boas. Boas lapa Sallimon. Sallimon lapa Nason. ");
INSERT INTO mux_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason lapa Aminadap. Aminadap lapa Admin. Admin lapa Anai. Anai lapa Esron. Esron lapa Peres. Peres lapa Juda. ");
INSERT INTO mux_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda lapa Jekop. Jekop lapa Aisak. Aisak lapa Eprayam. Eprayam lapa Tera. Tera lapa Neyo. ");
INSERT INTO mux_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neyo lapa Serak. Serak lapa Reu. Reu lapa Pellek. Pellek lapa Epe. Epe lapa Silla. ");
INSERT INTO mux_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Silla lapa Kenan. Kenan lapa Apakisat. Apakisat lapa Sem. Sem lapa Noa. Noa lapa LLamek. ");
INSERT INTO mux_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","LLamek lapa Metusalla. Metusalla lapa Inok. Inok lapa Jaret. Jaret lapa Mallallell. Mallallell lapa Kenan. ");
INSERT INTO mux_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan lapa Inos. Inos lapa Set. Set lapa Adam. Adam lapa Pulu Yili. Adam yu Pulu Yili-nga málale. ");
INSERT INTO mux_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesos ⸤no liirim kene⸥ Mini Kake Tiliele-ni yu-kene omba molupa yunga numanuna molupa aima peka turum-na no Jodan mundupa kelepa kene, Mini Kake Tiliele-ni yunu kolea-wakana memba purum. ");
INSERT INTO mux_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Akuna Yesos ⸤Mini Kake Tiliele kene mulurum kene⸥ ⸤kurumanga nuim⸥ depollale omba yu kondi topa manda lepa mulupili kaliimbu te kóru tale omba purum. Wale kanumanga langi naa nomba we molupa pirim kene yu engle-ni kolupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kanu-kene ⸤kurumanga nuim⸥ depollale-ni yu ⸤kundi topa kene⸥ nimba mele: “Nu Pulu Yili-nga Málale lem ku-mulú ima ‘Pllawa kaluli au talupili.’ ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Akiliinga-pe yu-ni pundu topa nimba mele: “Pulu Yili-nga bukele-ni nimba mele: “Langima-ni mindi yambuma kona mululi ulu-pulele naa silimú.” nimba molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kanu-kene depollale-ni Yesos yunu liipa memba pupa ⸤ma-pangi⸥ aima ola-kilia tenga monjupa kene, yunu ma-koleama pali walsekale liipa ora sipa kene, ");
INSERT INTO mux_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","yunundu nimba mele: “Kolea imanga pali tondulale kene méle kaíma kene Pulu Yili-ni nandu “Nukui.” nimba kórunga sirimele. Ima na-ni ‘Yambu te simbu.’ nindu lem kapula simbu. Nu na popu tokunu nanga bili paka tunjúnu lem tondulu ili kene méle kaíma kene pali nu liani simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kanu-kene Yesos-ni depollalendu nimba mele: “Pulu Yili-nga bukele-ni nimba mele: “Pulu Yili eninga Auliele mindi niku popu toku bi paka tonjuku, yunga kongunale mindi tenjiku molai.” nimba molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Kanu-kene depollale-ni Yesos liipa memba kolea-auli Jerusallem pupa, ⸤Pulu Yili popu toku kaluring⸥ lku-temboll imuna memba, aima ola pupa monjupa kene, yundu nimba mele: “Nu Pulu Yili-nga Málale lem nu liipa tapunjupa tepa liimbáliinga pu-nikunu mania pui.” ⸤nirim.⸥ “Pulu Yili-nga bukele-ni nimba mele: ‘Pulu Yili-ni yunga angkellama-ni ‘Nu oku nokangi.’ nimbá. Enini nu ‘Ku te-ni kepe naa tupili.’ niku nu eninga kima-ni oku kanglku liingí.’ nimba molemú kanili. Aku-sipa nirimaliinga piliiku kene aku-sikunu ti.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesos-ni yundu pundu topa kene nimba mele: “Pulu Yili-nga yambumandu ung te wasie nimba molemúko. Akili i-sipa mele: ‘Pulu Yili eninga Auliele-ni “Tembu.” nilimú mele ‘Sika nilimúnje mola gólu tolemúnje kanamili.’ niku eni yu manda leku naa teai.’ nimba molemúko kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Depollale-ni Yesos kundi topa manda lepa pora sipa kene, ‘Penga yunu alsupu kundi tombu ena te nondupa piliipu kene kelepu ombú.’ nimba yu mundupa kelepa purum. ");
INSERT INTO mux_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanu-kene Minéle-nga tondulale-ni Yesos alsupa kolea Gallalli distrik-ndu yandu memba urum kene akuna andupa tirim mele temanele koleamanga pali anju-anju purum piliiring. ");
INSERT INTO mux_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yunu-ni Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkumanga pupa ung-bo tonjupa mani sirim kene yambuma-ni pali yunu kape niring. ");
INSERT INTO mux_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesos ⸤kolea Gallalli distrik yambuma ung-bo tonjupa mani silsiliipa andupa kene, yunu kolea Gallalli distrik lirim⸥ kolea Nasaret taon ui molupa ai lirim koleana alsupa yandu urum. Omba kene ⸤Juda-yambumanga kóru muluring⸥ ena-Sambateliinga koleamanga pali enini máku toku Pulu Yili-nga ungele piliiring lkumanga yunu taki-taki purum mele Nasaret ung piliiring lku akuna aku-sipa purum. ⸤Máku toku muluring kene⸥ yunu-ni “Na bukele kanupu niambu.” nimba ola angiliirim. ");
INSERT INTO mux_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","⸤Pulu Yili-nga bukma nukurum yili-ni⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa liipa yambuma nimba sirim yi Asaya-ni kórunga-ui turum bukele liipa sirim kene, Yesos-ni liipa sukundu ung mulurum te kanupa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“⸤Asaya-ni i-sipa nimba mele:⸥ “Auliele-nga Minéle na-kene molemále yunu-ni nandu nimba mele: “Yambu-korupama temani kaiéle toku siku, ka-lkuna pelemelé yambumandu ‘Wendu oku we molangi.’ niku, mong kis lili yambumandu ‘Mong kaí lipili kanangi.’ niku, mindili noku molemele yambuma ‘Mindili naa noku, molku konjangi.’ niku, ");
INSERT INTO mux_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Ekupu puniena Auliele-ni yambuma kanupa kondu kolumba puniele wendu okum.’ niku silsiliiku andui.” nimba Minéle-ni aku-sipa yi te makó topa kene nirim.” nimba Asaya-ni nirim.” nimba Yesos-ni aku-sipa bukna kambu topa nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ung akili kanupa nimba pora sipa kene bukele alsupa pipi sipa bukma nukurum yili sipa, ⸤“Ung te niambu.” nimba⸥ Yesos yunu mania mulurum. Yambuma pali yunu mindi nem-nemi niku kanuku muluring. ");
INSERT INTO mux_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kanu-kene yunu-ni eninindu nimba mele: “Ekupu Pulu Yili-nga bukna ungele kanupu nindu pilííngi akuna Asaya-ni “Wendu ombá.” nimba, ui nirim akili ekupu wendu okum. ⸤Ekupu na tembu okur ulu akumanga ui nirim.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Muluring yambuma-ni “Yunu yi kaiéle. Yunu aima telemú.” niku yunu nirim mele piliiku kene “Aima nimba konjukumu.” niku kene mini-wale munduring. ⸤Akiliinga-pe⸥ enini niku mele: “Yi ili ⸤yunu nae niku piliikimiliye?⸥ Yunu Josep málale mindi, ⸤oliunga we-yi te mindi lem⸥.’ niring. ");
INSERT INTO mux_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","⸤Akiliinga-pe⸥ Yesos-ni ⸤yunu mulurum mele nirim-na piliiku kene yunu numanu kis panjiring akili piliipaliinga⸥ eninindu nimba mele: “Ung-eku tolemelemanga te nandu toku ningí teku molemelenje nimbu piliiker. Eni nandu i-siku ningí tekemelenje: “Nu sika dokta mollu lem nu kuru tomba kene nunga upipi-marasinele nunu liikunu nui. Penga nu kona puni ⸤kanupu kene ‘Nu sika dokta mollu lem.’ nimbu piliimulú.” niku ung-eku akili na toku singí tekemelenje?⸥ Nandu niku mele: “Nu-ni Kapeniam taon ulu-tonduluma tirinu piliirimulu akili ya nunga kolea ⸤Nasaret⸥ akuna aku-sikunu ti. ⸤Kanupu kene nu “moliu.” nikinu mele ‘Sika nikinu lem.’ nimbu piliimulú.⸥” ningí tekemelenje? ");
INSERT INTO mux_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Na-ni enindu sika nimbu siker: “Yambuma-ni ulu-pulu te telemele mele i-sipa: Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa liipa yambuma nimba silimú yi te-ni yunga pulu kolealiinga yambuma ung nimba silimú kene piliiku kene enini ‘Yu oliunga we-yi te. Yu bi mululi yi te mólu.’ niku yu-ni nilimú ungma naa piliiku liiku su silimele. ⸤Kolea-lupa yambu mare-ni oku ung niku silimele kene ung akuma mindi piliiku liilimele. Yambuma-ni aku-siku telemele mele eni aku-sikuko telemele.⸥” niker. ");
INSERT INTO mux_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Na-ni aima sika nimbu siker akili eni piliangi.’ nimbu ⸤temani tale tambu.⸥ “Illaija Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa liipa ⸤yunga pulu lirim⸥ Isrel-yambuma nimba sipa mulurum kene ulu te wendu urumele niambu. Pulu Yili-ni “Lo naa upili.” nirim kene punie yupuku kelepa kaliimbu angere tale-guli lo naa omba aima engle lakupa lirim kene Isrel koleana sukundu ambu-waye pulele ⸤engle-ni kolku⸥ muluring. ");
INSERT INTO mux_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Akiliinga-pe Pulu Yili-ni “Isrel ambu-waye te liiku tapunjuku langi sani.” nimba Illaija akuna naa liipa mundurum. ⸤Isrel ulsukundu lirim⸥ kolea-auli Saidon nondupa lirim kolea-kelú Sarepat ambu-waye te ⸤‘Langi pora naa nipili.’ nimba Pulu Yili-ni ulsu kanukundu ambale⸥ mulurumna Illaija liipa mundurum kanili. ");
INSERT INTO mux_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Illaisa kepe ui Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa liipa ⸤yunga pulu lirim Isrel-yambuma⸥ nimba sipa mulurum kene Isrel koleana sukundu yambu pulele kuru-kindí nurum, akiliinga-pe enini pali te kepe kangi kaí naa lirim, kuru-kindí nomba we pirim. ⸤Kolea Isrel ulsukundu lirim⸥ kolea Siria yi Neman mindi kuru-kindí nurum kene Illaisa-ni yunu ⸤liipa tapunjupa⸥ tepa kaí tirim. ⸤Pulu Yili-ni Illaija kene Illaisa-sele liipa mundurum-na ulsukundu yambu tale aku-siku liiku tapunjuringli niker akili aima sika niker piliai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aku-sipa mele nirim-na piliiku kis piliiku kene Pulu Yili-nga ungele piliiring lkuna sukundu muluring yambuma pali aima lakuku arerembi kuluring. ");
INSERT INTO mux_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Arerembi kolku kene ola angiliiku yunu kolea kanuna toku pulu siku ulsu munduku, kolea kanuna nondupa kopú te lirimna toku mania mundungí tiring. ");
INSERT INTO mux_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Akiliinga-pe yunu enini máku toku angiliiringina sumbi-sipa pupa tenga-lupa pumba purum, yunu kapula naa ambuluring. ");
INSERT INTO mux_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kanu-kene Yesos yunu kolea Gallalli distrik lirim taon te Kapeniam akuna mandu purum. Akuna ⸤kóru muluring⸥ ena-Sambatele ola urum kene Yesos ⸤Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku kanuna lkundu pupa⸥ yambuma ung-bo tonjupa mani sirim. ");
INSERT INTO mux_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ung-bo tonjupa mani sirim kene namba lirim yima-ni pipili naa kolku mundu-mong naa teku tondulu munduku ung-bo tonjuku mani siring akili mele yunu-ni aku-sipa ung-bo tonjupa mani sirim-na piliiku kene yambuma-ni mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kanu-kene lku kanuna sukundu yi te mulurum kanili kuru te yunga numanuna sukundu molupa yunu ambulurum ⸤kuru kanili-ni yunu “Ung ni.” nimba, nimba sirim-na⸥ yili-ni nangale topa tondulu mundupa nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kolea Nasaret yi Yesos, nu wasie oliu ⸤kuruma⸥ kene tiluna tapú topu kapula naa molomulú. Nu oliu-kene nambimuna únuye? Nu oliu toku kunjini únuye? Na-ni nunga bili piliiliu. Nu Pulu Yili-nga Yi Kake Tiliele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","⸤Aku-sipa nirim-na piliipaliinga⸥ Yesos-ni kuru kanili ung-mura sipa kene yunundu nimba mele: “Nu ung naa nikunu yilinga numanuna oku wendu pui!” nirim kene kurale-ni yili topa mana mania panjipa kene omba wendu purum. Yili yunu ulu te naa tirim, we kapula mulurum. ");
INSERT INTO mux_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","⸤Yesos-ni aku-sipa tirim kanuku kene⸥ yambuma suru niku, mini-wale munduku, eni-enini anju-yandu niku mele: “Ulu ili nambulka ulu te tekemunje? Ung-mani kona te wendu okum lepam. Yi namba lili te-ni we-yambumandu “Teai.” nilimú mele yi ili-ni kurumandu kepe aku-sipa nilimú kene kuru kanuma yunga ungele piliiku liiku wendu pulimelé.” niring. ");
INSERT INTO mux_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kanu-kene yunu-ni aku-sipa tirim mele temanele kolea kanuna sukundu lirim koleamanga pali anju-anju purum piliiring. ");
INSERT INTO mux_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kanu-kene máku toku Pulu Yili-nga ungele piliiring lku kanili Yesos mundupa kelepa pupa kene, Yesos Saimon-⸤Pita⸥-nga lkuna sukundu purum. Akuna Saimon-nga kolepa-ambale kuru topa kangi nomba kunjurum-na lirimele Yesos-ndu “Liiku tapunjui.” niku mawa tiring. ");
INSERT INTO mux_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aku-siku yunu mawa tiring kene ambale lirimna pupa angiliipa kene nimba mele: “Kangiele manda nupili.” nirim kene kangi nurumele kilirim. Ambale-ni sumbi-sipa ola angiliipa wendu omba kene, uring yi kanuma langi sipa nokupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ena kaniliinga ipinjali, ena pumba tirim kene, kuru lupa-lupa turum yambuma Yesos mulurumna meku uring kene yambu kanuma enini lupa-lupa kíli-ni ambulupa kene enini pali tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","⸤Numanuna kuru mulurum⸥ yambu pulele ⸤uring.⸥ Kuru kanuma⸤ndu “Oku wendu pai.” nirim kene⸥ oku wendu puku nangale toku kene niku mele: “Nu Pulu Yili-nga Málale mollu.” niring. Kuruma-ni yunu aku-siku bi siku kene yunu ⸤Pulu Yili-ni makó topa liipa mundurum yi-nuim⸥ Kraisele mulurum akili piliiringeliinga yunu-ni enini ung-mura sipa “Moliu mele anju niku naa sai.” nimba eninga kerima pipi sirim. ");
INSERT INTO mux_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ipulele-ui Yesos ola molupa pena pupa kolea-waka tenga-lupa purum kene yambu pulele yu koruku yunu mulurumna oku yunundu niku mele: “Oliu-kene wasie kamu molamili. Tenga naa pui.” niku mawa tiring. ");
INSERT INTO mux_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yunu-ni eninindu pundu topa kene nimba mele: “⸤Wasie molamili aramele-pe⸥ kolea wemanga wasie pupu, Pulu Yili omba yi nuim king molumba temani-kaiéle topu silsiliipu andumbú. Akiliinga na yandu liipa mundurum kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aku-sipa nimba kene yunu pupa kolea Gallalli ⸤distrik⸥ sukundu andupa, kolea lupa-lupamanga Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkumanga lkundu pupa temani-kaí kanili topa silsiliipa andurum. ");
INSERT INTO mux_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Walse, Yesos numú Geneseret, ⸤akilindu ‘Numú Gallalli’ niringko kanili,⸥ numú-kéluna angiliipa yambuma Pulu Yili-nga ungele nimba sirim kene piliingíndu enini yunu angiliirim kanuna puku máku toku nondupa-nondupa puku si-si siku molku piliiring. ");
INSERT INTO mux_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Kanu-kene yunu-ni nona anduli sip tale no-numú-kéluna lirim-sele kanupaliinga, oma liili yi kanuma kórunga numú-kéluna wendu puku eninga oma liili walema lumaye toku muluring kanurum. ");
INSERT INTO mux_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sip te Saimon-Pita-nga, akuna sukundu pupa kene Saimon-Pita-ndu mawa tepa kene nimba mele: “Sipele laye-kolte paka tokunu nona sukundu mundui.” nirim. Paka topa nona sukundu mundurum kene sip akiliinga sukundu yu mania molupa kene, no-kéluna liiku máku toku muluring yambuma ung-bo tonjupa mani sirim. ");
INSERT INTO mux_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Enini ung-mani sipa pora sipa kene yu-ni Saimon-ndu nimba mele: “Sipele no-numú ai-suku-singina kundukunu meku pukunu kene oma liili walema nona mania mundui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon-ni pundu topa kene nimba mele: “Yi-Nuimele, ekupu sumbulsuli pali oma liili kongunale tondulu mundupu tepu molupu tangnjupuliinga oma te aima naa líímulu. Akiliinga-pe aku-sikunu nikinu akiliinga walema nona topu mania mundambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kanu-kene oma-walema nona toku mania munduring kene oma pulele walena sukundu puku piring kilia walema sipna sukundu liingí tiring kene sungu nimbá tirim. ");
INSERT INTO mux_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Walema sungu nimbá tirim kanuku kene enini eninga oma liili kongun wasie tapú-toku tiring yi kanuma, sip tenga-lupa muluringma walsiku kene “Oku liiku tapunjangi wai.” niring. Uring kene sip tale wasie peka topa buni tepa nona mania pumba tirim. ");
INSERT INTO mux_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ulu akili kanupa kene Saimon-Pita Yesos-nga kumbi-kerina omba mania molupa tamalu pepa kene nimba mele: “Yi-Auliele, na ulu-pulu-kis tili yili ⸤nu kake tili yili⸥. ⸤Tiluna molkumbulele kapula naa tekem⸥ aliinga anju pukunu nu lupa mului.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Saimon kene, yu-kene wasie muluring yima kene, enini oma pulele walsekale tanguli liiring kanuku kene enini suru niku mini-wale munduring kilia ⸤Saimon-ni aku-sipa mele nirim⸥. ");
INSERT INTO mux_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Seperi-nga málu Jemis kene Jon-sele elsele Saimon-Pita kene kongun tiluna tapú-tokulu tiringli yisele, elsele wasie mini-wale munduringliko. Kanu-kene Saimon-ni nirim mele piliipaliinga Yesos-ni yunundu nimba mele: “Nu mundu-mong naa ti. Ekupu oma liinindu oma liili walale liikunu toku nona mania mundullú kene omama walena oku pelemelé aku mele, penga nanga kongun tinjinindu nanga ungele piliikunu niku silsiliiku anduni kene yambuma nanga talapena sukundu oku mulungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kanu-kene eninga sip-sele numú-kéluna meku ulsu oku kene, sip-selenga mélema pali lipili munduku kelku Yesos lumbili puring. ");
INSERT INTO mux_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","⸤Kolea Gallalli distrik sukundu lirim⸥ koleamanga tenga Yesos mulurum kene yi te kuru-kindí lakupa nomba pirimele omba Yesos kanupa kene mania molupa tamalu pepa yunu mawa tepa kene nimba mele: “Auliele, nunga numanale-ni ‘Nanga kangiele kaí lipili.’ nikunu pilíínu lem nu-ni na kapula tekunu kaí teani.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesos-ni yili kili-ni ambulupa kene yunundu nimba mele: “‘Nunga kangiele kaí lipili.’ nimbu piliiker akiliinga kaí lipili.” nirim kene enaliinga kuru-kindéle nomba kelepa kangiele kaí lirim. ");
INSERT INTO mux_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kanu-kene Yesos-ni yunu ung te tondulu mundupa nimba mele: “Nu-ni ya ulu tekerale yambu tilurindu kepe aima naa ni! Sumbi-sikunu pukunu Pulu Yili popu tunjuli yili nunga kangiele liiku ora sikunu, ‘Nanga kangiele alsupu kaí lipili molkur akiliinga.’ nikunu Moses-ni “Ti.” nimba ung-mani sirimele piliikunu liikunu tinindu “Pulu Yili popu toku kalku sai.” nirim mélale liikunu Pulu Yili popu tunjuli yilindu “Kalonjui.” niku yunu si. Pe yambuma-ni nu kanuku kene ‘Yu sika kangiele kaí lipili molemú.’ niku piliangi akiliinga niker mele isili-ui ti-pui. ⸤Aku-siku tiní kene yambuma-ni nu kanuku kis naa piliingí, nu alsuku we-yambuma molemelena kapula tiluna pukunu muluni.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Akiliinga-pe yunu-ni tirim mele anju-anju yambu pulele-ni piliiku kene yunu mulurumna sukundu-sukundu oku yunu temani-kaí topa nirimele piliingíndu oku, kuru turum yambuma yunu-ni ‘Enini tepa kaí tipili.’ niku uring kanupaliinga ");
INSERT INTO mux_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","yunu enini uringina mundupa kelepa kolea-waka tenga-lupa pupa Pulu Yili-kene popu topa ung nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Walse Yesos yunu-ni yambuma ung-bo tonjupa mani sipa mulurum. Kuru tuli yambuma tepa kaí tili tondulale yu-kene pípili mulurum. Pulu Yili-ni tondulu kanili yunu sirim. Perisi-yi kanuma kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene, yunu ung-mani sirimuma piliiku muluringko. Yi kanuma, kolea Gallalli distrik sukundu lirim koleamanga muluringma kene, kolea Judia distrik sukundu lirim koleamanga muluringma kene, kolea-auli Jerusallem muluringma kene, Yesos mulurumna oku máku toku yunu ung-mani sirimuma piliiku muluring. ");
INSERT INTO mux_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Yunu mulurumna yi mare-ni kimbu-ki kolupa pora sirim yi te taropola teku meku ungí uring akiliinga-pe yambu pulele lku keri-puluna si-si siku angiliiring kilia lku suku Yesos mulurumna nondupa meku pungí kupulanum te naa kanuku kene, lku-imuna meku ola puku kene Yesos mulurumna ⸤kuni lkuli tekisiku kene⸥ yili taropola pali moku toku mania munduring. ");
INSERT INTO mux_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‘Yesos-ni yi ili kapula tepa kaí temba.’ niku tondulu munduku piliiku kene yunu meku uring mele kanupa piliipa kene Yesos-ni yi kanilindu nimba mele: “Kangale, nunga numanuna ulu-pulu-kis tirinu pelemúma mania pupili, we kanupu konde tenjikur.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Perisi-yima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene, Yesos-ni aku-sipa nirimele piliiku kene ⸤piliiku kis piliiku⸥ numanu kimbú siku kene, “Pulu Yili marake tekem yi ili yi naeye? Yambuma-ni ulu-pulu-kis telemelema nae-ni ‘Mania pupili, we kanupu konde tenjikur.’ kapula nimbáye? Pulu Yili-ni mindi kapula telemú.” niku enini piliiku numanu kimbú siring. ");
INSERT INTO mux_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kanu-kene Yesos-ni enini aku-siku numanu kimbú siku muluring mele piliipaliinga eninindu nimba mele: “Eni ⸤na-ni nikereliinga⸥ aku-siku nambimuna numanu kimbú sikimiliye? ");
INSERT INTO mux_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yi ilindu “Nunga ulu-pulu-kisma mania pupili, we kanupu konde tenjikur.” nimbú kene eni ulu te naa kanuku kene ‘We-we tepa nikem.’ niku piliingíye? Mola “Ola angiliikunu nunga kunungele liiku mekunu kimbu kambiliikunu andui.” nimbú kene yu ola angiliimbane mola naa angiliimbanje mokeringa lemba kapula kanuku kene ‘Aku-sipa mindili sipa nikem-nje?’ niku piliingíye? ");
INSERT INTO mux_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Akiliinga-pe ‘ ‘Mania Omba Mana-Yi Au Talurum Yili tondulu pelemále-ni ya ma-koleana yambumanga ulu-pulu-kisma “Mania pupili, kanupu konde tenjikur.” kapula nimbá.’ niku piliangi.’ nimbu ⸤aku-sipu nindu⸥.” nirim. Aku nimba kene kimbu-kima kolupa pora sili yilindu nimba mele: “Na-ni ‘Nu ola angiliikunu nunga kunungele liiku mekunu lkundu pui.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Aku nirim kene enini kanuku molangi yili sumbi-sipa ola angiliipa yunga kunungele liipa memba omba pena pupa kene Pulu Yili kape nilsiliipa lkundu purum. ");
INSERT INTO mux_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","⸤Yunu aku tirim kanuku kene⸥ enini suru niku mini-wale munduku Pulu Yili-kene aima mundu-mong teku yunga bili paka tonjuku yu kape niku kene niku mele: “Oliu ulu wendu okum kanokumulu ili ulu aima te lupa lam.” niring. ");
INSERT INTO mux_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kanu-kene Yesos ⸤lkuli mundupa kelepa⸥ pena pupa kene, ku-moni-takis liirim yi te, yunga bili LLipai, ku-takis liipa mulurum kanupa kene yunundu “Na-kene wasie pambili lumbili ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Kanu-kene LLipai yu ola angiliipa ku-takis mélema we lipili mundupa kelepa yu lumbili purum. ");
INSERT INTO mux_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Penga LLipai-ni yunga lkuna Yesos-nga langi pulele kalunjurum. Akuna ku-takis liili yi pulele kene, we-yi mare kene, enini Yesos LLipai-sele kene wasie mania molku langi kanuma nuring. ");
INSERT INTO mux_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aku-siku tiring kanuku kene Perisi-yima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene, enini Yesos yunga lumbili anduli yimandu niku mele: “Eni ku-takis liili yima kene ulu-pulu-kisma tili yi wema kene eni wasie nambimuna langi nokomeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Aku-siku niring piliipa kene Yesos-ni eninindu ⸤ung-eku topa kene⸥ nimba mele: “Kuru naa tolemú yambuma doktana naa pulimelé. Kuru tolemú yambuma mindi doktana pulimelé kanili. ");
INSERT INTO mux_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na-ni ‘Yambu sumbi-nílima na molumbuna wangi.’ nimbúndu naa urundu. Ulu-pulu-kis tili yambuma ⸤liipu tapunjupu⸥ eninindu ‘Eni ulu-pulu-kis telemelema kanuku kis piliiku numanu topele toku ⸤na molumbuna wangi⸥.’ nimbúndu urundu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","⸤Kanu-kene⸥ enini Yesos-ndu walsiku niku mele: “⸤No-Liinjili⸥ Jon lumbili andúlima kene, Perisi-yima lumbili andúlima kene, enini wale marenga langi mi toku naa noku Pulu Yili-kene popu toku mawa telemeláliinga-pe nu lumbili andúlima-ni aku-siku naa telemele, langi kene no kene we nolemele. ⸤Pe nu lumbili andúlima-ni telemele mele akili kapulaye⸥ ?” niring. ");
INSERT INTO mux_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Aku-siku niring piliipa kene Yesos-ni pundu topa eninindu ⸤ung-eku te topa yu toku kunjingí kolumbaliinga ung te nimba kene⸥ nimba mele: “Ambu liimba yi te yunga pulu lelemú yima kene molemú kene enini numanu siku kene “Langi mi topu naa namili.” kapula ningíye? ⸤Kapula naa ningí.⸥ ");
INSERT INTO mux_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pe mindi, ambu liimba yili enini mulungína oku wendu liingí kene ena kanumanga sika ⸤numanu kis panjiku⸥ langi naa nungíndu mi tungí. ⸤Isili-ui mólu.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesos-ni aku-sipa nimba kene, ⸤‘Ui Juda-yambuma-ni ulu tiring uluma kene penga ulu kona wendu okomale kene tiluna kapula naa pinglí mele akili aima piliangi.’ nimba⸥ ung-eku tale topa kene nimba mele: “Mulumbale ui te sungu nilimú kene oliu-ni mulumbale aima kona tenga te kopsupu liipu, sungu nilimáliinga naa topu tambululimulu kanili. Yambu te-ni aku-sipa topa tambulkanje mulumbale kanili nona panjilka kene mulumbale kona kupsiliele wallú pupa tang tepa kene mulumbale uiele alsupa kamu auli-tepa sungu nilka. Ulu te i-sipa meleko: Mulumbale uiele kene mulumbale kupsili konale tilu-sipa mólu, akiliinga kapula-kapula mólu. ");
INSERT INTO mux_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kung-memi kangiele-ni tili mingi ukundu tenga no-waen kona naa kolemulu kanili. Yambu te-ni mingi ukundu tenga no-waen kona te kolkanje no-waen kanili mingina sukundu molupa kene penga akolka kene mingi ukundu kanili naa akopa sungu nilka. Kanu-kene nole kepe mingele kepe kamu kis lelka. ");
INSERT INTO mux_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Akiliinga no-waen kona kung-memi kangiele-ni tili mingi kona-na mindi kolemulu kanili. ");
INSERT INTO mux_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yi te-ni no-waen ukundu te nomba kene waen ukundu kanili nomba kaí piliipaliinga no-waen konánga waka naa kolemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Walse, ⸤kóru muluring⸥ ena-Sambat tenga, Yesos kene yu lumbili andúlima kene rais-wit puniemanga oku puring kene yu lumbili anduli yima-ni rais-wit mong mare nungíndu lkeku liiku kilu turing. ");
INSERT INTO mux_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aku-siku tiring kanuku kene Perisi-yima-ni Yesos yunundu niku mele: “Kána! ⸤Kóru molemulu⸥ ena-Sambateliinga ‘Kongun naa teai.’ nimba pelemú ung-manele nambimuna nunga lumbili anduli yima-ni ung-manele toku pula toku kene aku-siku tekemeleye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesos-ni pundu topa kene nimba mele: “Eni Pulu Yili-nga bukna sukundu ⸤anda-kolepa yi nuim king⸥ Depit-ni tirim mele nimba molemú temanele kanuku kene temaneliinga pulele naa piliilimiliye? Depit kene yunu-kene wasie puring yima kene enini engle-ni kolku kene, ");
INSERT INTO mux_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Depit Pulu Yili mulurum sell-lkuna lkundu pupa, Pulu Yili-nga kumbi-kerina lirim pllawa kalúlima liipa nomba, yunu-kene wasie puring yima sirim nuringko kanili. Pllawa kaluli kanumandu Pulu Yili-ni ung-mani sipa kene nimba mele: “We-yambuma-ni aima naa nai. Pulu Yili popu tunjuli yima mindi nangi.” nirim ⸤ung-mani kanili topa pula turum⸥ kanili. ⸤Eni numanu tale nambimuna piliilimiliye? Depit yunu-ni ui aku-sipa tirim mele eni piliiku kis naa piliilimiláliinga, pe ekupu na lumbili anduli yima-ni tekemele mele akili kanuku kis naa-ko piliai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Mania Omba Mana-Yi Au Talurum Yili-ni Sambat enama nokulemáliinga ⸤Sambat ena kene yambuma molku kunjingíndu tingí mele kapula nimbá kanili⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Penga walse, kóru mululi ena-Sambat tenga, Yesos omba Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lkuna lkundu pupa kene ung-bo tonjupa mani sirim. Lku kanuna yi te mulurum, yunga ki-bokundu kamu kolupa kukurum. ");
INSERT INTO mux_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Kanu-kene akuna muluring Perisi-yima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani siring yima kene, enini ‘Yesos-ni ulu te tepa kis-simba kene yu kot tenjimulú.’ niku ulu te tepa kis-simba te ⸤taki-taki koruku molku kene⸥ ‘⸤Kóru molemulu⸥ ena-Sambatele kene yu-ni yili tepa kaí tembanje.’ niku yunu lakuku kanuku muluring. ");
INSERT INTO mux_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Enini numanale-ni piliiring akili piliipaliinga Yesos-ni ki kolupa kukurum yi kanilindu nimba mele: “Yambuma molemelena oku ola angiliui.” nirim kene yili yunu akuna omba ola angiliirim. ");
INSERT INTO mux_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanu-kene Yesos-ni yimandu nimba mele: “Eni i-sipu walsipu piliiker. ‘Sambat ena kene ulu nambulka ulu te kapula temulúye? ‘Sambat enaliinga ung-manele-ni “Teai.” nilimú mele teamili.’ nimbu yambuma liipu tapunjumulú kene kapula mola yambuma tepu kis-simulú kene kapulaye? ‘Naa kolangi. Kona pangi.’ nimbu temulále kapula mola topu konjumulále mandaye?’ nimbuliinga walsiker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aku-sipa enini walsipa kene yunu-ni enini pali nem-nemi nimba kanupa kene ki kukuli yi kanilindu nimba mele: “Nunga kili sunu si.” nirim kene yili-ni yunga kili sunu sirim kene ki kolupa kukurumele alsupa kamu kaí lirim. ");
INSERT INTO mux_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aku-sipa tirim kanuku kene arerembi lakuku kolku eni-enini anju-yandu tombulku niku mele: “Tepa kis-sikimeliinga yunu nambulka teamiliye?” niku muluring. ");
INSERT INTO mux_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Penga walse sumbulsuli Yesos yunu Pulu Yili-kene popu topa ung nimbándu ma-pangi tenga ola pupa Pulu Yili-kene popu topa ung nimba mulupili kolea tangurum. ");
INSERT INTO mux_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ipulam-ui yunu lumbili andúlimandu “Wai.” nimba kene ‘Eninga yi engkaki-rurepu nanga kongunale tenjangi liipu mundambu.’ nimba kene yi akuma makó topa kene eninindu nimba mele: “Eni ‘Nanga kongunale tenji-pangi.’ nimbuliinga liipu mundukur yima.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","⸤Yi rurepu makó turum kanumanga bima i-sipa mele:⸥ Saimon (yunga bi te Pita) yunu kene, Pita angin Endru kene, Jemis kene, Jon kene, Pillip kene, Batollomiu kene, ");
INSERT INTO mux_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu kene, Tomas kene, Alpias-nga málu Jemis kene, “Oliu Juda-yambuma oliuliu gapman molamili.” niring talape-yi Saimon kene, ");
INSERT INTO mux_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemis málu Judas kene, Judas-Iskeriot, Yesos penga liipa ele-túma sirim yili kene, ⸤yi akuma ‘nanga kongun tenji-pangi liipu mundukur.’ nimba makó turum yima⸥. ");
INSERT INTO mux_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kanu-kene yunu kene, yunu-ni “Nanga kongunale tenji-pangi.” nimba liipa mundurum yi kanuma kene, ma-pangina mania uring kene yunga lumbili anduring yambu pulele kene, kolea Judia distrik muluring yambu pulele kene, kolea-auli Jerusallem piring yambu pulele kene, numú-kusa kéluna lirim kolea-auli Taya kene Saidon-selenga piring yambu pulele, yambu akuma yunu mulurumna sukundu-sukundu oku liiku máku turing. ");
INSERT INTO mux_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yunu temani-kaí topa, ung-mani sipa tirimele piliingíndu uring kene, yunu-ni enini kuru turum yambuma ‘Tepa kaí tipili.’ niku uring. Eninga yambu mare numanuna kuru kis mulurumuma tepa kaí tirim-ko. ");
INSERT INTO mux_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kuru tuli yambuma tepa kaí tili tondulale yunu-kene pípili mulurumeliinga enini uringma pali ‘Yunu ambulumulú.’ niku yunu mulurumna nondupa-nondupa uring. Kanu-kene oku yunu ambuluring kene tondulu kanili-ni enini pali tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kanu-kene Yesos mania molupa yunga lumbili anduli yima olandu-sipa kanupa kene eninindu nimba mele: “Eni korupa pulimúma Pulu Yili eninga yi nuim kingele molupa eni nokulemáliinga eni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Eni ekupu engle tolemúma eni penga walse olu tembaliinga eni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. “Eni ekupu kola telemelema eni penga walse tae tingéliinga eni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Mania Omba Mana-Yi Au Talurum Yili piliiku molemele yambuma, eni nanga yambuma molemeláliinga we-yambuma-ni eni-kene numanu kis panjiku, “Oliu molemuluna anjupa pai.” niku, enindu “Eni yambu kísima.” niku, niku kis-siku, eninga bima piliiku kis piliiku tingí kene eni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“⸤Yambuma-ni eni aku-siku mele telemeláliinga⸥ eni mulú-koleana pungí kene kanuna ⸤Pulu Yili-ni⸥ eni méle kalupa konjumbaliinga ⸤yambu kanuma-ni eni aku-siku teku kis-singí⸥ kene numanu lakuku siku, numanu aima kaí pípili molai. Yambuma-ni ekupu eni mindili silimele mele akili, aku-siku eni naa molangi kóru-ui Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku silsiliiku anduring yambuma we-yambuma-ni enini kepe mindili siringko kanili. ");
INSERT INTO mux_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Akiliinga-pe eni kamako lelemelema, ekupu eni molku konjuku numanu kaí pípili molemele mélema kórunga nosulimele, pe aku-siku naa mulungéliinga mindili noku molku kis-singí. ");
INSERT INTO mux_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Eni ekupu olu telemú yambuma penga walse engle-ni kulungéliinga mindili noku molku kis-singí. Eni ekupu tae telemele yambuma penga walse eni kola tingéliinga mindili noku molku kis-singí. ");
INSERT INTO mux_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","We-yambuma-ni pali eni kape niku taki-taki enindu “Yambu kaíma.” ningí kene eni mindili noku molku kis-singí. Yambu kanuma-ni enindu ung kaíma niku kape ningí mele ui eni naa molangi kóru-ui Pulu Yili-ni “Ninjai!” nimba ung nimba sirim ung te naa piliiku we gólu toku yambu niku siring yambumandu yambu imanga anda-kolepalima-ni ung kaíma aku-siku niringko. ⸤Pulu Yili-nga ungma sumbi-siku niring yambumandu kape naa niku mindili siring kanili.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","⸤Aku-sipa nimba kene Yesos-ni we muluring yambumandu nimba mele:⸥ “⸤Akili na lumbili andúlimandu niker⸥ akiliinga-pe na-ni ung nikerele piliiku molemele yambuma, enindu ung te kene wasie niambu piliangiko. Eni eninga ele-tu yambuma numanu monjuku, eni-kene numanu kis panjilimele yambuma teku kaí teai. ");
INSERT INTO mux_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Enindu ‘Yambu kísima kene molku kis-sangi.’ nilimele yambumandu anju munduku ‘Yambu kaíma kene molku konjangi.’ niai. Eni teku kis-silimele yambuma ‘Pulu Yili-ni membu sipa liipa tapunjupili.’ niku eni eninga popu toku mawa tenjai. ");
INSERT INTO mux_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Yambu te-ni nunga kumbi-keri ekendunga lkarauwa-ni tomba kene topele toku ‘Ekendunga kamu lkarauwa-ni tupili.’ ni. ‘Nunga wale-pakuli sulu kaiéle liimbú.’ nimbá yambale nunga wale-pakuliele kepe ‘pali we liipili.’ ni. ");
INSERT INTO mux_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Mélema si.” niku mawa tingí yambuma pali mélema we si. Nunga mélema we liimba yambalendu “Alsukunu nanu si.” ni naa niani. ");
INSERT INTO mux_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","“‘Yambuma-ni nu-kene teangi.’ niku piliillu mele, nu-ni anju yambuma aku-sikunu ti. ");
INSERT INTO mux_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ulu-pulu-kis telemele yambuma kepe enini anju-yandu kondu kolemele kanili piliiku kene eni yandu kondu kolemele yambuma mindi kondu kulungéle kapula mólu. Eni kanuku kis piliilimili yambuma pali kondu kolai. ");
INSERT INTO mux_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ulu-pulu-kis telemele yambuma kepe enini anju-yandu kondu kolku teku konjulemele piliiku kene eni yandu kondu kolku teku konjulemele yambuma mindi teku kunjingéle kapula mólu. Eni teku kis-silimele yambuma pali teku konjai. ");
INSERT INTO mux_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ulu-pulu-kis telemele yambuma kepe enini anju-yandu pundu angnjiku, ‘Walse alsupu sukundu liimbu.’ niku pundu angnjilimele kanili piliiku kene, eni yandu pundu tolemele yambuma mindi pundu angnjingéle kapula mólu. Eni pundu naa tolemele yambuma pali pundu angnjangi. ");
INSERT INTO mux_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“⸤Ulu-pulu-kis telemele yambuma enini anju-yandu telemele akili eni ulu te ola-kilia teangiko.⸥ Eni eninga ele-tu yambuma kepe kondu kolku, teku konjuku, pundu angnjiku, teangi. ‘Enini penga walse alsuku aku-siku yandu teai.’ ni naa niku, we teai. Aku-siku tingí kene Pulu Yili-nga kangambulama molku kene, yunu-ni eni méle pulele kalomba liingí. Pulu Yili yunu-ni mana-yambuma-kene aku-sipa mele tepa molemúko. Yunu teku kis-silimele yambuma kene, yunundu ‘Angke’ naa niku we molemele yambuma kene kanuma tepa konjulimú. ");
INSERT INTO mux_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Eninga Lapa Pulu Yili teku kis-silimele yambuma kepe yunu aku-sipa kondu kolupa we tepa konjulimú mele eni teku kis-singí yambuma aku-siku kondu kolku teku konjai.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Eni yambuma telemele uluma naa apurungí kene ⸤Pulu Yili-ni⸥ eni ulu telemelema naa apurumbako. Eni anju yambuma-ni telemele mele apuruku kanuku kene “Teku kis-sikimili. Tekemele mele ⸤Pulu Yili-ni⸥ kanupa kis piliipili.” naa ningí kene ⸤Pulu Yili-ni⸥ eni telemele mele apurupa kanupa kene “Teku kis-sikenu. Tekenu mele kanupu kis piliiker.” naa nimbáko. Yambuma-ni eni-kene teku kis-singí uluma ‘Mania pupili.’ niku kanuku konde tinjingí kene ⸤Pulu Yili-ni⸥ eninga ulu-pulu-kisma ‘Mania pupili.’ nimba kanupa konde tenjimbako. ");
INSERT INTO mux_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Eni yambuma penga kepe ‘Pundu naa tupili.’ niku mélema we singí kene yunu-ni eni aku-sipa we simbako. Mélema simbandu koltale naa simba; lakupa pulele simba. Eni anju singí kanupa kene eni yandu aku-sipa simbako.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesos-ni eninindu ung-eku te topa sirimuko. Akili i-sipa mele: “Mong kis lili yi te-ni mong kis lili yi te kupulanum manda ki ambulupa memba pulkaye? Wasie-nele mai-angina kapula naa tolkaye? ");
INSERT INTO mux_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ung-bo tunjuliele-nga ungele piliiku mululi yambuma eninga ung-bo tunjuliele toku mania naa mundulimele. Ui ung-bo tonjupa mani simba ungma piliiku puku pora silimele kene penga mindi eninga ung-bo tunjuliele-kene wasie kapula-kapula mele molemele. ");
INSERT INTO mux_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nu-ni angenanga mongselenga nurupalu te lelemú kanollu akiliinga-pe nunga mongselenga unji auli te lelemále naa kanollu akili nambimuna telluye? ");
INSERT INTO mux_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nunga mongselenga unji auli lelemále naa kanuku kene angenandu “Ang, nunga mongselenga nurupalu te lelemále wendu liinjambu.” nambi-sikunu nilluye? Topele-mapele tuli yambale, nu-ni nunga mongselenga lelemú unji auliele ui wendu liikunu kene penga kanuku kongnjukunu angenanga mongselenga lelemú nurupalale kapula wendu liinjani.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","⸤Kanu-kene Yesos-ni ung te wasie nimba kene ung-eku talse topa kene nimba mele:⸥ “Unji-kaiéle-ni mong kis te kapula naa tomba; unji kisele-ni mong kaí te kapula naa tombako. ");
INSERT INTO mux_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Unji mong te kanuku kene mong turum unji kanili bi kapula silimele. ‘Ámu nambu.’ niku, takeme kapula olku toku naa nolkemela. Mola ‘Me te nambu.’ niku, silipú kapula meku naa nolkemela. Ámu lupako takeme lupako kanuku, me lupako silipú lupako kanolemele kanili. ");
INSERT INTO mux_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aku-sipa mele, yambu kaí te-ni yunga numanuna ulu kaí pelemúma telemú, akiliinga-pe yambu kis te-ni yunga numanuna ulu kis pelemúma telemú. Yambu te yunga numanuna pelemú ungma mindi kerina nilimú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Na-ni niliu ungma piliiku liiku naa teku kene eni nandu “Auliele” we nambimuna nilimeleye?” ⸤nimba kene penga yunu-ni ung-eku te wasie topa yambumandu nimba mele:⸥ ");
INSERT INTO mux_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Nanga ung ima piliiku liiku tingí yambuma eni yi te molemú mele niambu: ");
INSERT INTO mux_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yi te yunu-ni yunga lkuli ‘Gi nimba angiliipili.’ nimba we ma kene okea kene ukupa wendu mundupa kene, akuna mania ku-polu tepa ola takurum. Lkuli aku-sipa takupa kunjurumeliinga penga no topa lkuli aima topa kalalu sipa tirim kene topa tekisi naa tekisipa gi nimba we angiliirim. ");
INSERT INTO mux_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Akiliinga-pe nanga ung ima piliiku liiku naa tingí yambuma eni yi te molemú mele niambu: Yi te yunga lkuli we ma tondulu naa púlina ola walu-sipa takurum. Penga no topa lku kanili walsekale topa kalalu sirim.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yambuma piliangi ung kanuma nimba pora sipa kene Yesos Kapeniam taon-na sukundu purum. ");
INSERT INTO mux_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Akuna Rom-yambumanga ami-yi wan-andret nukurum yi tenga kendemande-yi te yunu aima numanu munjurumele kuru auli-tepa topa kene yunu kolumba lirim. ");
INSERT INTO mux_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ami-yi nuim kanili-ni Yesos urumele piliipaliinga yunu-ni Juda tápu-yi mare Yesos mulurumna liipa mundupa kene nimba mele: “Nanga kendemande-yili ⸤kuru auli-tepa túmeliinga⸥ oku tekunu kona li.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Juda tápu-yi kanuma-ni Yesos mulurumna oku aku-siku niku tondulu munduku mawa tenjiku kene niku mele: “Kendemande-yi kolkumu ilinga ami-yi nuimele yunu aima yi kaiéle. ⸤Yunu Juda-yi te mólu⸥ akiliinga-pe oliu Juda-yambuma numanu monjupa, oliu máku topu Pulu Yili-nga ungele piliilimulu lkuli yunu-ni takunjurum akiliinga nu-ni yunu liiku tapunjunu lem kapula.” niring. ");
INSERT INTO mux_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Aku-siku niring piliipaliinga Yesos enini kene yi kaniliinga lkuna pumba purum. Lku kanuna nondupa urum kene ami-yi nuim kanili-ni yunga pulu lelemú yambu mare Yesos urumna liipa mundurum oku kene yunundu niku mele: “Ami-yi nuimele-ni i-sipa mele nikem: “Auliele, na yi kisele mele moliu, nu nanga lkuna unéle kapula naa temba akiliinga nu mindili sikunu ya naa wani. ");
INSERT INTO mux_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Nu molluna na yi kisele kapula naa ombúko nimbu piliindu. Na yi te-ni kepe nokupa molemú, yunga ungele piliipu liipu teliu. Na-ni kepe ami-yi mare nokupu moliu. Yi kanumanga te-ndu “Pui.” niliu kene yunu pulimú. Mola te-ndu “Ui.” niliu kene yunu olemú. Mola nanga kongun tinjili kendemande-yambu te-ndu “I-sikunu ti.” niliu kene yunu aku-sipa telemú kanili. Aku-sipako, nu-ni ung te we niní kene nanga kendemande⸤-yi⸥li we kona pupili akiliinga nu-ni ungele we ni.” nikem.” niring. ");
INSERT INTO mux_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesos-ni Rom-ami yi-nuimele-ni nimba mundurum akili piliipaliinga yunu numanu pulele liipa mundupa kene yunu lumbili uringele yambumandu nimba mele: “Na-ni enindu aima sika nimbu siker: “Isrel-yambumanga talapena ulsukundu mululi yi ili-ni na ungele-ni mindi kapula temba mele “Sika” nimba tondulu mundupa piliilimú mele koleamanga pali, Isrel-koleana sukundu kepe, yambu tiluri-ni kepe aku-siku piliiring mele aima naa kanurundu. Yunu-ni ‘Sika’ nimba tondulu mundupa piliilimú mele aima ola-kilia.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aku-sipa nirim piliiku kene ami-yi nuimele-ni Yesos mulurumna liipa mundurum yi kanuma ami-yi kaniliinga lkuna yandu oku kene kendemande-yili kona purum kanuring. ");
INSERT INTO mux_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Yesos kolea Nen taon-ndu purum, yunga lumbili andúlima kene yambu pulele wasie puring. ");
INSERT INTO mux_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yunu kolea Nen pala keri-puluna nondupa purum kene yi te kulurumele ónu tingíndu taropola teku meku ulsu pungí uring. Kulurum yi kanili yunga anum lapaselenga miringli komulayele, pe te lupa naa meangli lapa kulurum. Penga yunga anum ambu-wayele we mulupili yunga kangale kulurumko. Kang kanili ónu tingíndu yambu pulele anum kene tapú toku puring. ");
INSERT INTO mux_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Auliele-ni ambale kanupa kene aima kondu kolupa yunundu “Kola naa ti.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanu-kene yunu yambu-taropolana nondupa omba taropolale ambulupaliinga, miring yi kanuma we meku angiliangi yunu-ni nimba mele: “Kang yili, ola mului.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kanu-kene yi kulurumele ola molupa yunu ung nirim. Kanu-kene Yesos-ni yi kulurumele liipa yili yunga anum yunu sirim. ");
INSERT INTO mux_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yesos-ni aku-sipa tirimeliinga yambuma-ni mundu-mong teku kene niku mele: “Pulu Yili-nga ung “Ninjui.” nimba, nimba silimú ungma piliipa yambuma nimba sili yi-auli te oliu molemuluna wendu um lam.” niku Pulu Yili yunga bili paka tonjuku kene niku mele: “Pulu Yili yunga yambuma molemelena omba liipa tapunjum.” niring. ");
INSERT INTO mux_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesos-ni tirim ilinga temanele kolea Judia distrik pali kene Judia ulsukundu kolea lupa-lupamanga pali anju-anju purum piliiring. ");
INSERT INTO mux_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yesos-ni tirim akili Jon yunu lumbili andúlima-ni yunundu niku siring kene yunu-ni yunga lumbili andúlimanga tale “Yandu wale.” nimba kene Yesos mulurumna elsele liipa mundupa nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“⸤Pulu Yili-ni oliu nokupa konjumba yi te⸥ “liipu mundumbu.” nimba, nimba panjurum yili ‘Ombá.’ nimbu nokupu molemulu kanili nu mola te lupa ombále nokupu molamiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yi kanusele-ni Yesos mulurumna okulu yunundu nikulu mele: “No-Liinjili Jon-ni olsu liipa mundupa kene nimba mele: “⸤Pulu Yili-ni oliu nokupa konjumba yi te⸥ “liipu mundumbu.” nimba, nimba panjurum yili ‘Ombá.’ nimbu nokupu molemulu kanili nu mola te-lupa ombá nokupu molamiliye?” nim.” niringli. ");
INSERT INTO mux_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aku-siku walsiku piliikulu kene ena-mong tenga ⸤we kanuku angiliangli⸥ Yesos-ni kuru lupa-lupa turum yambuma kene, numanuna kuru mulurum yambuma kene, mong kis lirim yambu pulele kene, tepa kaí tepa mulurum kanuringli. ");
INSERT INTO mux_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Penga Yesos-ni elselendu pundu topa kene nimba mele: “Else-ni ya kanokumbele mele kepe piliikimbili mele kepe Jon-ndu niku si-pale. Mong kis lili yambuma mongale-ni kanuku, kimbu kis lili yambuma kapula anduku, kuru-laká núlima bo-kangi angiliipa, kum sílima kumele-ni ung piliiku, kolupa lílima lomburuku ola molemeleko, korupa púlima temani-kaiéle topu siliu piliilimiliko kanili. Aku-siku Jon-ndu niku si-pale. ");
INSERT INTO mux_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na kanuku kene ‘Yunu sika yi kanili molemú.’ niku tondulu munduku piliiku kene, alsuku numanu tale naa panjiku mulungí yambuma Pulu Yili-ni “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon-ni liipa mundurum yisele kelku nendu puringli kene Yesos-ni alsupa yambu pulele máku toku muluringmandu Jon-ndu nimba mele: “⸤Kolea-wakana Jon no liinjipa mulurum kene⸥ eni kolea-waka kanuna nambulka kanungí puringiye? Lkepanie-sindí mele popuremi-ni topa lop-lope tenjipa mulurum te kanungí puringiye? ⸤Jon yunu aku-sipa mele te mólu kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","⸤Taki-taki kanolemele mele kanungí naa puring lem⸥ ulu nambulka te kanungíndu puringiye? Yi te mulumbale aima kaíma pakupa mulurum kanungí puringiye? Akili móluko. Yambu kamako molku, méle pulele nosuku, mulumbale aima kaíma pakolemelema yi nuim kingimanga lkuna mendepulu molemele kanili. ");
INSERT INTO mux_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“⸤Aku-sili yi te kanungí naa puring lem⸥ Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba sili yi te kanungí puringiye? Akili sika akiliinga-pe na-ni enindu nimbu siker: “Jon yunu sika Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa nimba sili yi te akiliinga-pe yunu aku-sili yi we te mólu.” niker. ");
INSERT INTO mux_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aku niker yi kanilindu Pulu Yili-nga bukna sukundu molemú ung te i-sipa mele: ‘⸤Pulu Yili-ni yunga Málalendu nimba mele:⸥ “Piliai! Nanga ung ninjimba yili na-ni nu puni kupulanum-na yunu kumbi-lepu liipu mundukur. Yunu-ni nunga kupulanumele akisinjimba.” nirim.’ ung kanili bukna molemú. ");
INSERT INTO mux_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na-ni enindu aima sika nimbu siker: “Ui mana mania muluring yambumanga te ⸤No-Liinjili⸥ Jon kene kapula mólu. Jon ola-kilia mele. Akiliinga-pe ekupu ena konale wendu okum. Ena kanili Pulu Yili yi nuim kingele molupa nokulemú yambumanga te aima bi naa molupa aima korupa puli yambale ola-kilia; Jon yunu mania-kilia. ⸤Ui muluring yambuma mania-kilia mele; ekupu na ‘Sika’ niku tondulu munduku piliingéliinga numanu kaí pemba yambuma ola-kilia.⸥” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yesos-ni aku-sipa nirim piliiku kene we-yambuma kene ku-moni-takis liiring yima kene Yesos-ni Jon-ndu nirim ungele piliiku kaí piliiku Pulu Yili kape niring. Yambu kanuma-ni ui ⸤No-Liinjili⸥ Jon-ni nirim ungele piliiku kaí piliiku kene enini ulu-pulu-kis tiringma liiku bulu siku, numanu topele toku ‘Oliu Jon-ni no liinjipili.’ niku no liiring. ");
INSERT INTO mux_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Akiliinga-pe Perisi-yi kanuma kene, Pulu Yili-nga ung-manimanga puluma piliiku kungnjuring yi kanuma kene, enini ‘Pulu Yili-ni Jon naa liipa mundurum.’ niku piliiku kene, Pulu Yili-ni “Yambumanga liipu tapunjupu tembu.” nirim ungele piliiku kis piliiku liiku bulu siku kene penga ‘Jon-ni oliu no naa liinjipili.’ niku no naa liiring. ");
INSERT INTO mux_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kanu-kene Yesos-ni ung te wasie nimba mele: “Ekupu ma-koleana molemele yambuma nambulka méle te kene enini manda lepu nimbúnje? ⸤Enini molemele mele i-sipu nimbu sambu:⸥ ");
INSERT INTO mux_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Enini yambuma máku tolemele koleana kangambulama pepi pereku molemele mele. Kangambula kanumanga mare-ni ne anju molemele kangambula mare ⸤kene wasie pepi pereku mulungí kupulanum te koruku kelku kene⸥ eninindu walsiku kene niku mele: “Konana nímulu kene eni ‘Wasie konana niamili.’ naa niku “Mólu.” níngi. Penga kelepu kola tímulu kene eni ‘Wasie kola teamili.’ ni naa níngi. ⸤Wasie pepi perepu molomulú kupulanum te mólu lam.⸥” nilimele. ⸤Ekupu molemele yambuma eni kangambula kanuma mele molemele.⸥ ");
INSERT INTO mux_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","⸤Na kene No-Liinjili Jon kene olsu-ni nilimbulu ungma eni piliiku kis piliilimili; telembulu mele kanuku kis piliilimiliko⸥. Jon omba kene langi kene no-waen kene naa nomba mulurum kene ⸤kanuku kis piliiku kene⸥ niku mele: “Yunga numanuna kuru te molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Penga Mania Omba Mana-Yi Au Talurum Yili omba langi kene no-waen kene nurum kene ⸤kanuku kis-ko piliiku kene⸥ niku mele: “Yunu langi pulele nomba kis piliipa, no-waen pulele nomba kelep topa telemú yili. Yunu ku-moni-takis liili yi kanuma kene, ulu-pulu-kis telemele yambu wema kene ‘Yunu kene pulu lipili kene wasie tapú topu molamili.’ nimba telemú.” nilimeleko. ⸤Eni aku-siku Jon kanuku kis-ko piliilimili. Na kanuku kis-ko piliilimili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Akiliinga-pe piliipa kungnjuli ulu-pulele Pulu Yili-kene pelemú-na yunga kangambulama-ni pali yunu-ni telemú melemandu ‘Papu telemú.’ ningí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Walse, Perisi-yi te-ni Yesos-ndu “Langi wasie nambili ui.” nirim kene yunga lkuna lkundu pupa akuna langi poluna nondupa polu tenga mania mulurum kene ");
INSERT INTO mux_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","kolea kanuna mulurum ambu ulu-pulu-kis tili te-ni Yesos yunu Perisi-yi kaniliinga lkuna lkundu langi nomba mulurumele piliipa kene, yunu kopungu-wel aima kaí te mingi pali liipa akuna memba pupa kene ");
INSERT INTO mux_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yesos mulurumna bulkundu kimbuna nondupa kola tepa angiliipa kene, penga Yesos yunga kimbusele kola-monguma-ni lumaye tonjupa, penga ambale yunga pengi-lapisale liipa kimbu kanusele kulu tonjupa, kimbusele kanglupa, kopungu-wel memba urum kanili-ni kimbuna kopungu kanjunjurum. ");
INSERT INTO mux_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lku pulu yi Perisi-yi ⸤Saimon⸥ kanili yunu-ni ambale-ni aku-sipa tirimele kanupa kene yunu numanale-ni piliipaliinga ‘Yi ili aima sika Pulu Yili-ni “Ninjui!” nimba ung nimba silimú ungma piliilimú yi te molkanje ambu yunu ambulkum ili molemú mele kene ulu-kis telemú mele kene kapula piliipaliinga “Na naa ambolkunu, oku wendu pui.” nilka.’ nimba piliirim. ");
INSERT INTO mux_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesos-ni ⸤Saimon⸥ numanale-ni piliirim mele piliipaliinga yunundu nimba mele: “Saimon, nu ung te niambu.” nirim kene Saimon-ni pundu topa kene nimba mele: “Ung-Bo Tunjuliele, kapula, ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","⸤Aku-sipa nirim kene Yesos-ni yunundu temani te topa nimba mele:⸥ “Yi te-ni yi tale ku-moni pundu angnjipa sirim. Yi te paip-tausen kina mele sipa, yi te paip-anderet kina mele sirim. ");
INSERT INTO mux_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Penga elsele wasie pundu kapula naa tunjuringli kene yi pundu sirim yi kanili-ni pundusele we mundupa kelepa “Ulu te mólu. Temba nomba tipili.” nirim. Aku-sipa nirimaliinga yiselenga nae-ni yunu numanu lakupa munjurum niku piliikunuye?” nimba Yesos-ni Perisi-yilindu aku-sipa nimba walsurum. ");
INSERT INTO mux_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","⸤Perisi-yi⸥ Saimon kanili-ni yunundu pundu topa nimba mele: “Pundu auli angnjirim yili, nimbu piliiker.” nirim kene Yesos-ni “Sumbi-siku nikinu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanu-kene Yesos-ni topele topa ambu kanili angiliirimna kanupaliinga Saimon-ndu nimba mele: “Ambu ili kána! Na nunga lkuna lkundu úndu kene ⸤oliu Isrel-yambuma-ni yi-poning koela olemú kene telemulu mele⸥ nu-ni nandu aku-sikunu naa tinu. Nu-ni “Kimbu lumaye tui.” niku no naa kulkunu sinu akiliinga-pe ambu ili-ni nanga kimbusele yunga kola-monguma-ni lumaye tonjupa, yunga pengi-lapisale liipa nanga kimbusele kulu tunjum. ");
INSERT INTO mux_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na úndu kene nu-ni na naa kanglunu akiliinga-pe ambu ili-ni na úndu kene kepe yandupa ekupu kepe nanga kimbusele kanglupa molemú. ");
INSERT INTO mux_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na úndu kene nu-ni nanga pengína kopungu-wel liiku kopungu naa kanjunjunu akiliinga-pe ambu ili-ni nanga kimbusele kopungu-wel kaí te-ni kopungu kanjunjumu. ");
INSERT INTO mux_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yunu-ni ulu-pulu-kis pulele tirim-ma ⸤Pulu Yili-ni⸥ “Mania pupili. Kanupu konde tenjikur.” nimu-na mania púmeliinga na numanu auli-tepa monjupa kene aku-sipa tímu. Akiliinga-pe ulu-pulu-kis koltale mindi telemú yambale yunga tirim mele ‘Mania pupili, kanupu konde tenjikur.’ nimbá yili kanu yambale-ni numanu layesele monjumbako.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yi Saimon-ndu aku-sipa nimba pora sipa kene ambalendu nimba mele: “Nunga numanuna ulu-pulu-kis tirinu pelemúma mania pupili, kanupu konde tenjikur.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aku-sipa nirim piliiku kene yu-kene langi noku muluring yambuma yunu-ni nirim mele piliiku kis piliiku kene enini anju-yandu tombulku niku mele: “Yambuma-ni ulu-pulu-kis telemelema yi ili-ni “Mania pupili, kanupu konde tenjikur.” nikem yili yunu yi naeye? ⸤‘Na Pulu Yili.’ nimba piliipaliinga nikem-nje?⸥” niring. ");
INSERT INTO mux_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanu-kene Yesos-ni ambalendu kamu nimba mele: “Na-ni nu ulu-pulu-kis tirinu mele ‘ ‘Omba wendu pupili.’ kapula nimbú.’ niku piliikunu úneliinga na-ni sika aku-sipu kapula liipu tapunjupu tepu liiker akiliinga nu numanu waengu nipili mololsiliikunu pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kanu-kene penga Yesos pupa, kolea-aulima kene kelúma kene akumanga andupa kene, Pulu Yili yi nuim kingele molupa yambuma nokumba temani-kaiéle topa silsiliipa, yambuma ung-mani silsiliipa andurum. Yu lumbili anduli yi rurepu kene ");
INSERT INTO mux_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ambu mare kene yunu wasie anduring. Ambu kanumanga mare ui kuru topa, mare ui kuru eninga numanuna pirim kene Yesos-ni enini pali tepa kaí tirim. Te, kolea Makdalla ambu Maria, ui yunga numanuna kuru angere yupuku-guli muluringmandu Yesos-ni “Oku wendu pai.” nirim kene oku wendu puring. ");
INSERT INTO mux_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Te, ambu Joana, Susa min. Susa yunu kolea Gallalli distrik yi nuim king Erot-nga lku tápu-yili. Te, ambu Susana. Enini kene we-ambu pulele kene Yesos nukuring. Ambu kanuma-ni eninga ku-moni nusuringma liikuliinga Yesos kene yu lumbili andúlima kene eninga langi kene mélema taropu toku liiku siku nukuring. ");
INSERT INTO mux_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kanu-kene Yesos mulurumna kolea lupa-lupamanga muluring yambu aima pulele sukundu-sukundu oku, liiku máku turing kene yunu-ni eninindu ung-eku te topa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yi te-ni rais-wit boma puniena andupa tanda sirim. Tanda silsiliipa andurum kene bo mare kupulanum-na mania purum, kanuma yambuma-ni kimbele-ni kambiliiring; mare kerama-ni oku liiku nuringko. ");
INSERT INTO mux_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bo mare ku-mulú pirimna mania pupa kene akuna no naa mulurum kilia mulie topa ola omba walsekale kulurum. ");
INSERT INTO mux_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bo mare kumbulu-sirkambu mele mulurumna mania purum, sirkambu melale ola omba wit-boma topa nurumeliinga omba kaí naa tepa ⸤mong te naa turum⸥. ");
INSERT INTO mux_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bo mare ma kaína mania purum-ma ola omba mong kaíma topa, mong tokapu angere mele turum.” ⸤nirim.⸥ ⸤Aku-sipa nimba kene⸥ “Yambu kum-peú lelemúma-ni ung ili piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","⸤Yesos-ni aku-sipa nirim kene⸥ yu lumbili andúlima-ni yunundu niku mele: “Ung-eku akiliinga pulele nikunu si.” niring. ");
INSERT INTO mux_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kanu-kene yunu-ni eninindu nimba mele: “Pulu Yili yi nuim kingele molupa yambuma kene mélema kene nokulemáliinga ulu-pulu ui yunu piliirim ulu-pulu kanuma ‘Eni ekupu ⸤na lumbili olemele yambuma⸥ piliangi.’ nimba kene eni ‘Ung-ekumanga puluma piliangi.’ nimbaliinga eni nimba sikem. Akiliinga-pe we-yambuma ungma nimbu simbundu ung-eku mindi topu siliu. ⸤Pulu Yili-ni Asayanga kerina nimba mele:⸥ ‘Enini mongale-ni kanuku kene kanuku bi naa silimele; kumele-ni piliiku kene piliiku bi naa silimele.’ nirim akiliinga we-yambumandu ung-eku mindi toliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Aku-sipa nimbaliinga yunu-ni nimba mele: “Ung-eku akiliinga pulele i-sipa mele: “Langi-bo tanda sirim kanuma Pulu Yili-nga ungele. ");
INSERT INTO mux_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Bo mare kupulanum-na mania purum-ma yambu mare aku-sílima molemele. Enini ungele piliilimili kene penga ⸤kurumanga nuim⸥ depollale omba ‘Ung akili kamu tondulu munduku pilííngi lem Pulu Yili-ni enini tepa liipa, kupulanum kísina wendu liimba kene kapula mólu.’ nimbaliinga ung tanda sílima numanuna omba pelemúma wendu liilimú. ");
INSERT INTO mux_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Bo mare tanda sirim-ma ku pirimna mania purum-ma yambu mare aku-sílima molemele. Enini ungele piliiku kene numanu siku piliiku liilimele. Akiliinga-pe enini pulkanu naa munduku kene ungele layesele mindi piliiku molemele. Penga enini numanuna buni temba kene mola ⸤Seten omba⸥ manda lepa kundi-ka temba kene, enini piliilimili ungele munduku kelelemele. ");
INSERT INTO mux_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Bo mare tanda sirim-ma kumbulu-sirkambu mele kanili mulurumna mania purum-ma yambu mare aku-sílima molemele. Enini ungele piliiku kene penga kupulanum-na pungí kene numanuna buni telemú bunima kene, méle pulele nosulimele mélema kene ya ma-koleana uluma teku numanu singí uluma kene, kanu-sili ulu mare wendu omba ung kanili topa nolemú kene ungele-ni ulu te naa tepa langi-mong kamu naa tolemú. ");
INSERT INTO mux_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bo mare tanda sirim-ma ma kaína mania purum-ma, yambu mare aku-sílima molemele. Enini eninga numanu kaí pípili molku ungele piliiku kene ung kanili kamu liiku tondulu munduku piliiku kene, tondulu pupili molemele kene bo kanuma-ni langi-mong ⸤pulele⸥ tolemú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","⸤Yesos-ni eninindu ung-eku te wasie topa nimba mele:⸥ “Yambuma-ni tepi-llam kanduku kene mingina sukundu naa monjuku polu maniakundu naa nosulimele. ‘Yambu lkuna ungíma lkuna sukundu pa tipili kolea kanangi.’ niku polu tenga ola nosulimele. ");
INSERT INTO mux_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Aku-sipa mele, ekupu mo tolemú mélema penga walse mokeringa lemba, yambuma-ni kanungí; ekupu panda topa lelemú mélema penga walse pa temba kene yambuma-ni méle kanuma kanuku bi singí. ");
INSERT INTO mux_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Aku-sipa temba akiliinga eni ung piliilimili akili mimi-siku piliai. Pulu Yili-nga ung-sikale piliiku liiku molemele yambuma aima lakupa ungma nimba simba piliingí. Penga aima pulele piliingí. Akiliinga-pe ung naa piliiku molemele yambuma enini layesele piliilimili ungele kepe wendu liimba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Walse Yesos lku tenga sukundu mulurum kene yunga anumele kene anginipili kene yunu kanungíndu uring. Akuna yambu pulele si-si siku muluringeliinga yunu mulurumna nondupa kapula ungí kupulanum te naa lirim kilia ");
INSERT INTO mux_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","⸤ung te niku munduring kene⸥ yambuma-ni yunundu niku mele: “Aminie kene angenali kene nu kanungíndu oku pena angiliimili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesos-ni eninindu pundu topa kene nimba mele: “Pulu Yili-nga ungele piliiku liiku kene telemele yambuma nanga anumele kene nanga anginipili molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Walse, Yesos kene yu lumbili andúlima kene enini nona anduli sip tenga sukundu puring kene yu-ni eninindu nimba mele: “No-numú nekendu pamulu.” nirim kene akuna pungí puring. ");
INSERT INTO mux_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sipna pungí puring kene Yesos yu uru pirim. Yu uru pípili popuremi auli te no-numúna turum. Aku tirim kene ⸤numéle apsipa ola omba kene⸥ no-sipna sukundu-sukundu omba peka topa kene sipele memba nona mania pumba tirim kene enini no wangingí tiring. ");
INSERT INTO mux_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kanu-kene yunu uru pirimna puku toku makinjiku kene niku mele: “Yi-Nuimele, Yi-Nuimele, oliu no wangkumulu.” niring kene yu makiliipa kene popuremale kene no apsipa ola urum numéle kene ung-mura sirim. Kanu-kene popuremale topa kelepa, numéle lope naa tepa we lirim. ");
INSERT INTO mux_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kanu-kene yu-ni yu lumbili anduli yimandu nimba mele: “‘⸤Pulu Yili-ni oliu nokumba.’ niku⸥ tondulu munduku naa piliikimiliye?” nirim. ⸤Yu-ni tirim mele kanuku kene⸥ yima-ni mundu-mong teku mini-wale munduku kene anju-yandu enini tombulku kene niku mele: “Apa! Yi ili naenje? Popuremale-ni kepe no-numéle-ni kepe yu-ni elselendu “Teale.” nikem ungele piliiku liikulu kelkembele.” niring. ");
INSERT INTO mux_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanu-kene no-numúna nekendu puku kolea Gerasa puring. No-numú yakundu kolea Gallalli, numú nekendu kolea Gerasa kanili. ");
INSERT INTO mux_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Akuna uring kene Yesos sipna wendu omba no-kéluna angiliirim kene kolea kanuna yi te yunu mulurumna urum. Yi kanili kuru pulele yunga numanuna muluringeliinga mulumbale te kepe naa talupa, giu-gau andupa, lku tenga naa pepa, yambu ónu-koleana pepa andupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kurale-ni yi kanili taki-taki liirim kilia yambuma-ni ka-sen-ni yunga kimbu-kima ka toku yunu nokuku muluring akiliinga-pe ka-senuma topa sungu-mangu sirim kene penga kurale-ni kolea-wakana yunu memba purum. Yi kanili-ni Yesos kanupa kene ke nimba yunu angiliirimna mania molupa tamalu pepa tondulu mundupa kene nimba mele: “Yesos, Pulu Yi Aima Auli Olandupaliinga Málale, na-kene nambulka ulu te tinindu únuye? “Na aima mindili liikunu naa si.” nimbu mawa teker.” nirim. ⸤Yu koela ombá urum kene⸥ Yesos-ni ui nimba mele: “Kurale, yi ilinga numanuna oku wendu pui.” nirim mele piliipaliinga yili-ni aku-sipa “Mindili liikunu naa si.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aku-sipa nirim kene Yesos-ni yi kanilindu walsipa kene nimba mele: “Nunga bili naeye?” nirim kene yili yunga numanuna kuru pulele muluringeliinga piliipa kene “Nanga bili Aima Pulele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kuru pulele kanuma-ni wale pulele Yesos mawa teku kene niku mele: “Oliu ‘oku wendu pai.’ nikunu toku makurukunu “⸤Ma-kolea ili munduku kelku⸥ Pulu Yili-ni takara toku wara-peú aima lepa mindi pupa pora naa nilimú wara-peúna ⸤oliunga yi-nuim Seten walse liipa mundumba⸥ wara-peú kanuna pai.” ni naa ni.” niku mawa tiring. ");
INSERT INTO mux_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akuna ma-pangi tenga bo-kung pulele im noku muluring kanuku kene Yesos mawa teku kene niku mele: “Oliu ⸤toku makuruku kene⸥ ‘Ne kungmanga sukundu molu-pai.’ ni.” niring kene yu-ni “Kapula, akuna pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aku-sipa nirim kene kuruma yi kaniliinga numanuna wendu oku kene kung akuna muluringmanga numanuna puku muluring kanu-kene kung kanuma kelep toku lkisiku puku kopuna puka toku no-numúna suku puku no wanguring. ");
INSERT INTO mux_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ulu akuma wendu urum-na kanuku kene kung tápu-teku muluring yi kanuma takara toku puku kene, kolea-aulina muluring yambuma kene, kolea-kelúmanga muluring yambuma kene, ulu akuma wendu urum akili temani toku silsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Temani kanili piliiring yambuma ‘Ulu wendu um mele kanumulú.’ niku wendu puku Yesos mulurumna oku kene ui kuru pulele numanuna molku oku wendu puring yili mulumbale talupa, numanu-bo pirim-na Yesos mulurumna nondupa mania mulurum kanuku kene enini mundu-mong tiring. ");
INSERT INTO mux_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yesos-ni tirim mele mongale-ni kanuring yambuma-ni penga uring yambuma niku siring. Kuru pulele numanuna muluring yilinga numanuna kuruma oku wendu puring kene yili yunu numanu-bo pirim-na mulurum akili mele niku siring. ");
INSERT INTO mux_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kanu-kene kolea Gerasa yambuma pali aima mini-wale munduku kene Yesos mawa teku kene niku mele: “Oliunga koleana naa molkunu kelkunu pui.” niring kene yunu kelepa pumbandu nona anduli sipna sukundu purum. ");
INSERT INTO mux_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","⸤Yu pumba tirim kanupaliinga⸥ kuru pulele numanuna ui molku wendu puring yili-ni yunundu nimba mele: “Wasie pambulu.” nimba mawa tirim. Akiliinga-pe Yesos-ni “Mólu.” nimba yundu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nu lkundu pukunu Pulu Yili-ni nu lakupa tepa kaí tímu mele nunga yambuma nikunu si-pui.” nirim. Yesos-ni aku-sipa nirim-na piliipa kene yi kanili pupa kolea-aulina sukundu muluring yambuma pali Yesos-ni yu-kene lakupa tepa kaí tirim mele nimba sirim. ");
INSERT INTO mux_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kanu-kene Yesos yunu ⸤lumbili andúlima kene⸥ no-numú yakundu urum kene yunu ‘Ombá.’ niku liiku máku toku nokuku muluring yambuma-ni “Nu papu okonu.” niku numanu siring. ");
INSERT INTO mux_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku te nukurum yi te, yunga bili Jairas, Yesos mulurumna urum. Kanu-kene yunu Yesos-nga kimbuna nondupa omba mania molupa tamalu pepa yunundu mawa tepa kene nimba mele: “Nanga lkuna wasie pambili ui.” nirim. Yili yunga ambulale, yunga limin tiluele mindi, yunu punie engkaki-rurepu mele omba purum ambula kanili, kuru aima lakupa turumeliinga yunu nondupa kolumba lirim-na ⸤yili-ni Yesos aku-sipa mawa tirim⸥. Kanu-kene Yesos lku kanuna pumba purum kene yambu pulele liiku máku toku yunu liiku poku teku si-si siku wasie puring. ");
INSERT INTO mux_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","⸤Yambu wasie puring kanumanga⸥ ambu te yunga ku-puku turum enama pora naa nirim. Yu ku-puku mindi tupili punie engkaki-rurepu omba purum. Yu doktamanga yunga kurale ‘Pora nipili.’ nimba andupa, yunga ku-moni pali enini sirim akiliinga-pe kuru kanili pora naa nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ambu kanili Yesos pumba purum kene bulkundu pupa, yunga wale-pakuleliinga pundele ambulurum kene enaliinga yunga kuru kanili pora nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Aku-sipa tirim kene Yesos-ni nimba mele: “Nae-ni na ambulúmuye?” nirim. Enini pali “Na mólu.” niring kene ⸤yu lumbili anduli yi⸥ Pita-ni yunundu nimba mele: “Yi-Nuimele, yambu pulele nu angiliikununa nondupa-nondupa oku liiku poku teku si-si siku angiliikimele akili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Akiliinga-pe Yesos-ni alsupa nimba mele: “Na yambu liipu tapunjuliu tondulu mare nanga kangina omba wendu pukumu-na piliipuliinga yambu te-ni na ambulúmelendu niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aku-sipa nirim piliipaliinga ambale yunu mo tomba mele naa lirim, yunu tirim mele Yesos piliipa mulurum piliipa kene yunga kimbu-kima pur-puru nipili Yesos mulurumna omba mania molupa tamalu pepa kene, yambuma piliiku angiliangi yunu-ni ‘Kuru pora nipili.’ nimba omba Yesos ambulurum kene walsekale kaí lirim akili mele nimba para sirim kene ");
INSERT INTO mux_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesos-ni yunundu nimba mele: “Nanga ambulale, ‘Nu kapula tepa kaí temba.’ nikunu tondulu mundukunu pilíínu ulu kanili-ni nu kaí lekenu. Numanu waengu nipili molani pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesos-ni ambalendu aku-sipa nimba mulurum kene, yi te, yambuma máku toku Pulu Yili-nga ungele piliiring lku nukuli yi ⸤Jairas⸥ nga lkuna molupa kene omba ⸤Jairas-ndu⸥ nimba mele: “Nunga ambulale kolupa pora símu. Ung-Bo Tunjuliele ‘Mindili nupili.’ niku we naa meku wani.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Akiliinga-pe yunu-ni nirim mele akili piliipaliinga Yesos-ni ⸤lku nukuli yi kanilindu⸥ nimba mele: “Mini-wale naa mundui. Nunga ambulale na-ni ‘Kapula liipa tapunjumba.’ nikunu tondulu mundukunu piliikunu muluni kene yunu kapula kona pumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Kanu-kene Yesos yilinga lkuna omba kene lkuna sukundu yambu pulele ambula kulurumele kondu niku kola teku muluring kanupaliinga eninindu nimba mele: “Ambulale kulú naa kulum. We uru mindi pelemú akiliinga eni kola naa teai.” nirim. Akiliinga-pe yunu sika kolupa pora sirimele piliiku kene yunu-ni “We uru pelemú.” nirimaliinga enini yunga ung-taka tonjuku tae tinjiring. Penga yunu ⸤ambulaliinga suluminana⸥ sukundu pumba purum kene ‘We-yambuma pali naa oku anju pai.’ nimbaliinga Pita kene, Jon kene, Jemis kene, ambula kaniliinga anum lapasele kene “Eni mindi wasie pamili wai.” nimba ⸤ambula ónale lirim⸥ suluminana enini memba purum. ");
INSERT INTO mux_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pupa kene ambulaliinga kili ambulupa yunundu walsipa kene nimba mele: “Ambulale, nu ola mului.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","yunga mulunga purum kanili alsupa sukundu urum kene ambula kanili walsekale ola mulurum. Kanu-kene Yesos-ni ⸤anumundu⸥ nimba mele: “Ambulale langi mare liikunu si.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yunu-ni tirim mele akili kanukulu kene ambulaliinga anum lapasele elsele aima mini-wale munduringlieliinga-pe yunu-ni elselendu tondulu mundupa nimba mele: “Ulu teker ili yambu tilurindu kepe anju pukulu aima naa niku sale.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Walse Yesos-ni yu lumbili anduli yi engkaki-rurepundu “Yandu wai.” nimba kene, enini yambumanga numanuna kuru molemúma “Oku wendu pai.” niku toku makurungí tondulale sipa kene, yambu kuru túlima ‘Kaí molangi.’ ningí tondulale sirim. ");
INSERT INTO mux_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aku-sipa tepa kene eninindu nimba mele: “Eni puku, Pulu Yili omba yi nuim kingele molumba temani-kaiéle yambuma toku silsiliiku anduku, kuru túlima teku kaí telsiliiku pai. ");
INSERT INTO mux_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Pungíndu, mélema naa meku we pai. Apulu-mingi kepe, méle-wale kepe, keri-langi kepe, ku-moni kepe, wale-pakuli tale kepe naa meku we pai. ");
INSERT INTO mux_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Penga kolea tenga sukundu puku kene akuna mulungí teku lku tiluringa lkundu puku kene akuna mindi peku molku kene penga kolea akili munduku kelku pai. ⸤Lku tenga puku tenga puku naa teai. Tiluringa mindi keri-langi noku peai.⸥ ");
INSERT INTO mux_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kolea marenga suku pungí kene kolea pulu yambuma-ni “Papu úngi. Wasie piamili wai.” ni naa niku enini ung ningíma piliiku naa lííngi lem kolea kanuna yambu kísima munduku kelku pungí teku kene eni liiku su singéliinga kolea kanuna yambuma ‘Kamu molku kis-sangi! Pulu Yili-ni enini liipa naa tapunjumba akili piliangi.’ niku kolea kanumanga ma eninga kimbuna angiliimbama tanda siku munduku pai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Aku-sipa nirim kene yi kanuma puku, koleamanga anduku, Pulu Yili-nga temani-kaiéle toku silsiliiku, kuru turum yambuma teku kaí telsiliiku, telsiliiku anduring. ");
INSERT INTO mux_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Kolea Gallalli distrik nukurum yi nuim king Erot-ni Yesos-ni tirim mele temani turing piliipaliinga, ‘Yi ili naenje?’ nimba piliipa sundurum. Yambu mare-ni niku mele: “Yi ili ⸤No-Liinjili⸥ Jon ⸤talku kulurum kanili⸥ lomburupa ola molupa um-nje.” niku muluring. Mare-ni niku mele: “⸤Pulu Yili-ni ui kona we mulupili olandu liirim yi⸥ Illaija alsupa omba molemú.” niku muluring. Mare-ni niku mele: “Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kóru-ui molku kuluringmanga yi te lomburupa ola molupa urum.” niku muluring. ");
INSERT INTO mux_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","⸤Yi nuim king⸥ Erot-ni ⸤Yesos-ni tirim mele temani turing⸥ piliipa kene nimba mele: “⸤No-Liinjili⸥ Jon ‘yunga pengale wendu pupili.’ nimbu numi kari lirindu-na yu kulurum akiliinga-pe ulu-tondulu lupa-lupa telemú piliiliu yi ili yunu naenje?” nirim. Aku-sipa nimba kene “Yi Yesos ili kanulkanje kapula!” nimba mulurum. ");
INSERT INTO mux_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesos-ni “Nanga kongunale tenji-pai.” nimba liipa mundurum yima yu mulurumna kelku yandu oku kene ulu tiringma yunu temani toku siring. Kanu-kene yi kanuma liipa memba pupa ‘Tenga oliuliu molamili.’ nimbaliinga enini Besaida taon-na memba purum. ");
INSERT INTO mux_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Akiliinga-pe enini akuna puring kene yambu aima pulele piliikuliinga yunu purumna lumbili aeleku puring. We-yambuma uring kanupaliinga Yesos-ni eninindu “Papu úngi.” nimba kene enini Pulu Yili omba yi nuim kingele molumba temani-kaiéle topa sipa, eninga yambu kuru turum-ma ‘Kaí molangi.’ nimba enini tepa kaí tirim. ");
INSERT INTO mux_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Penga ipinjali ena pumba tirim kene yu lumbili anduli yi rurepu yunu mulurumna oku yunundu niku mele: “Kolea ilinga yambu te naa pelemelé akiliinga ya máku toku molemele yambuma ‘Puku kolea marenga keri-langi taropu toku liiku noku pe-pangi.’ ni.” niring. ");
INSERT INTO mux_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aku-siku niring kene Yesos-ni lumbili anduli yimandu nimba mele: “Eni-enini yambuma langi mare liiku sai.” nirim. Enini yunundu niku mele: “Ya langi mare au-sipa naa lelemú. Pllawa kaluli wallú angere te-guli kene oma kaluli tale kene, langi talse aku-sele mindi lelemú. Mola nu-ni ‘Oliu kolea tenga puku yambu imanga langi taropu toku liinji-pamili.’ niku nikinuye?” niku walsiring. ");
INSERT INTO mux_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Yambu kanuma koltale mólu, yi paip-tausen mele akuna muluring.) Kanu-kene Yesos-ni eninindu nimba mele: “Yambumandu ‘eni tokapu tale-tale niku mania molangi.’ niai.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","enini aku-siku yambumandu niring kene yambuma ungele piliiku liiku aku-siku mania muluring. ");
INSERT INTO mux_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kanu-kene Yesos-ni pllawa kaluli angere te-guli kene oma tale kene liipa kene mulú-koleana olandu-sipa kanupa ⸤Pulu Yili-kene⸥ “Angke” nimbaliinga langi kanuka ambulupa puku topa yu lumbili andúlima moke tepa sipa kene “Anju yambuma sai.” nirim, ⸤enini yambuma moke teku siring⸥. ");
INSERT INTO mux_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Enini pali langi kanuma nuring kene olu tirim. Penga yu lumbili anduli yima-ni langi kakena lirim-ma liiku máku toku wale-basket engkaki-rurepu toku peka siring. ");
INSERT INTO mux_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Walse, Yesos yunu Pulu Yili-kene popu topa ung nimba mulurum kene yu lumbili anduli yi wasie muluringmandu walsipa kene nimba mele: “Yambuma-ni na bi leku nae nilimeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Enini yunundu pundu toku niku mele: “Mare-ni “Nu No-Liinjili Jon ⸤kulurum kanili alsupa lomburupa ola molemále⸥.” niku piliilimili; mare-ni “Nu ⸤Pulu Yili-ni ui kona mulupili olandu liirim yi⸥ Illaija alsupa omba molemú.” niku piliilimili; mare-ni “Nu Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi te ui kulurum kanili lomburupa ola molemú.” niku piliilimili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","⸤Aku-siku niring kene⸥ Yesos-ni eninindu walsipaliinga nimba mele: “⸤We-yambuma-ni aku-siku nilimele⸥ akiliinga-pe eni-enini na nae nilimeleye?” nimba walsurum. Pita-ni pundu topa nimba mele: “Nu Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ ui nimba makó turum yi-nuim Kraisele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pita-ni aku-sipa nirim piliipaliinga Yesos-ni eninindu tondulu mundupa nimba mele: “Na moliu mele ⸤Pita-ni ekupu nikemele⸥ eni anju yambu tilurindu kepe ⸤isili-ui⸥ aima naa niku sai!” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","⸤Nimbaliinga⸥ yu-ni ⸤yu-kene wendu ombá mele⸥ enini nimba sipa kene nimba mele: “Mania Omba Mana-Yi Au Talurum Yili sika mindili pulele nombá. Juda-yambuma nokolemele tápu-yima kene, Pulu Yili popu tunjuli yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuli yima kene, enini ⸤niku mele: “Yunu Pulu Yili-ni naa liipa mundurum. Yunu Pulu Yili-nga Málale naa molemú.” niku⸥ yunu úngulu siku, liiku bulu siku yunu toku kunjingí. Yunu toku kunjingí kolumba kene kongun tale omba pumba kene yupuku-sipaliinga Pulu Yili-ni yunundu ‘Lomburuku ola mului.’ nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanu-kene Yesos-ni akuna liiku máku toku muluring yambumandu pali nimba mele: “Yambu te-ni ‘Yu lumbili pumbú.’ nimba kene yunu-ni taki-taki yunga numanale-ni piliilimú melemanga ‘Topu mania mundambu.’ nimba, yambuma unji-perana peku mindili noku kolemele mele yu-ni unji-pera mele koma lembandu ‘Na yu lumbili pupu kene mindili nundu lem kapulako; kulundu lem kapulako.’ nimba kene na lumbili upili. We naa upili. ");
INSERT INTO mux_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yambu te-ni ma-koleana yunga kona molupa naa kululi ulu-pulele ambulumba temba kene yu kolupa kene sika molupa kis-sipa mindi pumba. Akiliinga-pe yambu te-ni na numanu monjupa kene nanga kongunale “Tenjambu.” nimba temba kene yunu kolupa kene yu kona molupa konjupa mindi puli ulu-pulele sika kanupa liimba. ");
INSERT INTO mux_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","⸤Akili nambimuna nikerye?⸥ Yambu te-ni ma-koleana mélema pali yunu liipa nosulka kene yunga minéle pali Pulu Yili naa molumba koleana pupa mindili nomba molupa kis-silkanje méle kanuma-ni yambu kanili nambi-sipa tepa liilkanje? Manda tepa naa liilkale. ");
INSERT INTO mux_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Nanga yambu mare we-yambuma kene molkuliinga niku mele: “Oliu Yesos-nga ungma piliipu liipu, yunu lumbili andupu molemulu mele akili we-yambuma-ni naa piliangi.” niku kene, na kiyang niku lumbili andolemele yambuma eni-kene ulu te penga wendu ombá akili nimbu sambu: Mania Omba Mana-Yi Au Talurum Yili penga Lapanga tondulu talang puliele kene ⸤mulú-koleana⸥ angkella kake tílima kene ⸤mania⸥ ombá temba kene, we-yambu kanuma mulungína yunga yambuma mokeringa mulungéliinga we-yambuma mulungína kanuku kene yunu ui naa upili ‘Oliu yunga yambuma molemulu akili we-yambuma-ni naa piliangi.’ niku pipili kolku mo toku mulungí yambuma yu-ni liipa wekundu kanupa, “Na moliuna naa wai.” nimbáko.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Na-ni enindu aima sika nimbu siker: “Eni ya angiliikimilimanga mare ui kulú naa kolangi Pulu Yili yi nuim kingele omba molupa kolea nokumbandu ombá kanungí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesos-ni ⸤yu lumbili anduli yimandu aku-sipa nimba sirim kene⸥ penga kóru te omba purum kene Pita kene, Jemis kene, Jon kene, enini liipa memba pupa “Pulu Yili-kene popu topu ung niambu wasie pamili wai.” nimbaliinga ma-pangina enini liipa memba ola purum. ");
INSERT INTO mux_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yunu-ni akuna Pulu Yili-kene popu topa ung nimba mulupili yunga kumbi-kerale te-lupa-mele tepa angiliirim, yu pakurum mulumbalema ena tondulu topa yambumanga mongma takele telemú mele aku-sipa kake tirim. ");
INSERT INTO mux_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Yunu aku-sipa mulupili, ⸤Juda-yambumanga kórunga-ui muluringli yi-auli tale,⸥ Moses kene Illaija-sele, okulu talang purum-na oku angiliirim elsele Yesos kene enini Yesos kolea-auli Jerusallem akuna Pulu Yili-ni yunundu ‘Ti.’ nirim mele kolumba akili niku muluring. ");
INSERT INTO mux_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","⸤Yesos uinga Pulu Yili-kene popu topa ung nimba mulurum kene⸥ Pita kene, wasie akuna muluring yisele kene, enini enimbu topa uru ombá tirim akiliinga-pe, penga enini suru niku numanu-bo pirim-na molkuliinga Yesos yunga kangiele te-lupa-mele tepa angiliirim-na mulurum mele akili kepe, yunga tondulale talang purum mele kepe, yunu kene angiliiringli yisele kene wasie kanuring. ");
INSERT INTO mux_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kanu-kene yi akusele punglí puringli kene Pita-ni Yesos-ndu nimba mele: “Yi Nuimele, oliu ya molkumulale kaí lam. Oliu-ni lku-takaé yupuku takunjamili. Te nunga, te Moses-nga, te Illaija-nga takunjamili.” nirim. (Akiliinga-pe nirim mele ⸤mundu-mong lakupa kolupa kene⸥ yunu-ni nimbá mele naa piliipa ungele walu-sipa nirim.) ");
INSERT INTO mux_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita-ni aku-sipa nimba mulupili kupa te omba enini panda turum. Kupana sukundu puring kene enini mini-wale munduring. ");
INSERT INTO mux_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kupa turumuna sukundu ung te wendu omba kene nimba mele: “Yi ili nanga Málale. Na-ni ⸤‘Eninga’ nimbu⸥ yunu makó topu liipu mundurundu. Yunu-ni ung nimbáma piliiku liai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ung akili nimba kilirim kene Yesos yunu mindi mulurum kanuring. Enini aku-siku kanuring mele anju yambu te-ndu naa niku siring, yambu te naa piliirim. ");
INSERT INTO mux_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ulsulam-uikundu, ⸤Yesos kene yu lumbili anduli yi yupuku kene⸥ enini ma-pangina mandu ungí uring kene yambu pulele-ni yunu liingí uring. ");
INSERT INTO mux_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yambu uringimanga yi te-ni Yesos-ndu nimba mele: “Ung-Bo Tunjuliele, ‘Nanga kangale, yu nanga kang tiluele mindi, kondu kolkunu liikunu tapunjui.’ nimbuliinga mawa teker. ");
INSERT INTO mux_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yunga numanuna kuru te pelemále-ni yunu liipa mindili sipa tolemú kene kangale-ni ke nimba, kuru-kopari topa kene apapu memba molemú. Yunu aku-sipa mele taki-taki telemú akiliinga kangale yunga kangima pang-mangi telemúko. ");
INSERT INTO mux_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nu lumbili anduli yimandu temani akili topu sipu enini kuru kanili ‘Toku makurangi.’ nimbu mawa tindeliinga-pe enini kapula naa tíngi.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","⸤Aku-sipa nirim-na⸥ piliipa kene Yesos-ni ⸤yambuma ung-mura sipa kene⸥ nimba mele: “Ekupu molemele yambuma eni ⸤‘Pulu Yili-ni uluma sika kapula temba.’ niku⸥ tondulu munduku naa piliilimili. Eni numanu karaye tepa pili yambuma, na eni-kene molupu, wale nambi-sili molupu mani sipu ulu mare liipu ora simbu kene mimi-siku piliingíye? ⸤Na eni-kene enembu tokum.⸥” nimbaliinga penga yi kanilindu nimba mele: “Nunga kangale na moliuna meku ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Memba ombá urum kene kuru kanili-ni kang kanili topa liipa kapá lepa mundurum yu turum kene Yesos-ni kurale ung-mura sipa kangale tepa kaí tepaliinga lapa sirim. ");
INSERT INTO mux_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aku-sipa tirim kanuku kene yambuma Pulu Yili-nga tondulale numanale-ni piliikuliinga mini-wale munduring. Yunu-ni tirim mele akili enini suru niku mini-wale munduku muluring kene Yesos-ni yunga lumbili anduli yimandu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ya niker akili piliiku kongnjai. Mania Omba Mana-Yi Au Talurum Yili ⸤ka siku kene toku kunjingí⸥ yima anju singí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Akiliinga-pe yunu-ni nirim ungele piliiku sunduku kene ‘Ung ilinga pulele nambulkanje, naa piliikumulu.’ niring akiliinga-pe “Nambulka niku nikinuye?” niku yunu walsiku piliingíndu pipili kolku naa walsiring. Pulu Yili-ni ‘Enini ung kaniliinga pulele isili-ui naa piliangi.’ nimbaliinga tirim kanili. ");
INSERT INTO mux_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","⸤Walse Yesos lumbili anduli yima-ni⸥ eni-enini anju-yandu tombulku nikuliinga niku mele: “Oliunga yi nae aima olandupa molemúye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Enini numanale-ni piliiring akili piliipa kene, Yesos-ni kangambula kelú te liipa ⸤Yesos-yu⸥ mulurumna nondupa monjupa kene ");
INSERT INTO mux_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","eninindu nimba mele: “Yambu te-ni ‘Na Auliele-nga yambale moliu.’ nimbaliinga kangambula ili liipa tapunjumba yambu kanili-ni temba kaniliinga na liipa tapunjumbako. Kanu-kene na liipa tapunjumba yambale-ni na liipa mundurum yili liipa tapunjumbako. Eninga yi te-ni ‘Nanga bili ola naa mulupili.’ nimba, ‘Yi tenga lupa bili ola mulupili.’ nilimú yili yu eninga aima olandupa molumbáliinga ⸤aku-sipa ulele pemba⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yesos lumbili anduli yi Jon-ni Yesos-ndu nimba mele: “Yi-Nuimele, oliu kanúmulu, yi te-ni nunga bili lepa kuru mare yambumanga numanuna mulúngima “Oku wendu pai.” nimba topa makurupa mulúm kanúmulu. Kanupu kene yunu oliu-kene wasie tapú-topu naa andolemulaliinga yundu “Nu aku-sikunu naa ti.” nímulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Aku-sipa nirim-na piliipa kene Yesos-ni yundu ⸤yi kanili-ni tirim ulelendu⸥ nimba mele: “Yambu te oliu-kene ele-tu naa molemú yambale oliunga ele-lkeramale molemú akiliinga eni yunundu “Mólu.” naa niai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kanu-kene Yesos kolea-auli Jerusallem yunu kolupaliinga penga mulú-koleana olandu pumba enale nondupa wendu urumele piliipaliinga numanu tondulu mundupa ‘Jerusallem pumbú.’ nimba kene pumba purum. ");
INSERT INTO mux_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yu lumbili anduli yi mare liipa mundupaliinga nimba mele: “Ekupu sumbulsuli kolea Sameria-nga taon nondupa lemba tenga piamilieliinga eni akuna puku oliu pemulu lku te koruku liangi pai.” nirim kene puku kururing. ");
INSERT INTO mux_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Akiliinga-pe Sameria-yambu kanuma ⸤enini kene Isrel-yambuma kene anju-yandu numanu kis panjiku muluringeliinga⸥ yunu Jerusallem pumba purum kanuku kene enini “Mólu, ya kapula naa pingí.” niring. ");
INSERT INTO mux_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Aku-siku niring kanuku kene yu lumbili anduli yi Jemis kene Jon-seleni yunundu nikulu mele: “Auliele, ‘olsu-ni ‘Mulú-koleana tepi wendu omba Sameria-yambu ima nomba kunjupili.’ niambili.’ niku piliikunuye?” niku walsiringli. ");
INSERT INTO mux_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Akiliinga-pe yunu topele topa elsele kanupa ung-mura sipa “Akili nikulu kis-sikimbili.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","enini kolea tenga puku pi-puring. ");
INSERT INTO mux_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Enini kupulanum-na pungí puring kene yi te omba Yesos-ndu nimba mele: “Nu puni koleamanga pali na lumbili ombú.” nirim kanu-kene ");
INSERT INTO mux_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesos-ni yunundu nimba mele: “Piliiyo! Owa-takarama lku pelemelémanga pelemelé; kerama eninga mi takolemelemanga pelemelé; akiliinga-pe Mania Omba Mana-Yi Au Talurum Yili-nga pelemú kolea te naa lelemú ⸤akiliinga, nu ‘Yunu lumbili pupu kene kapula naa molumbu.’ niku piliikuliinga lumbili ui. We naa ui.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kanu-kene yunu-ni yi te-ndu nimba mele: “Na-kene wasie pambili lumbili ui.” nirim kanu-kene yi kanili-ni yunundu pundu topa kene nimba mele: “Auliele, ⸤nu kamu lumbili wambu aramele-pe⸥ ui pupu nanga lápale-kene molambu. Penga yunu kolumba kene angnjipu panjipuliinga nu lumbili ombú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Akiliinga-pe Yesos-ni yunundu ⸤ung-eku topa⸥ alsupa nimba mele: “Yambu kulúlima enini yambu kulungíma ónu teangi. Nu ‘Pulu Yili yi nuim kingele molupa yambuma nokumba temani-kaiéle yambuma piliangi.’ niku toku silsiliikunu andui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kanu-kene yi te-ni yunundu nimba mele: “Auliele, nu lumbili ombáliinga-pe ui pupu nanga yambuma kondu kolupu ‘Molai.’ nimbu kene penga nu lumbili wambu.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesos-ni yunundu nimba mele: “Na ‘Lumbili ombú.’ nimba omba kene nondupa enimbu kolumba yambale Pulu Yili yi nuim kingele molupa nokumba kolealiinga kongunale kapula naa tenjimba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kanu-kene Yesos ⸤kolea-auli Jerusallem-ndu pumba pupaliinga,⸥ yu pumba purum kolea marenga yi mare kumbi-lepa liipa mundurum. Yunu-ni yi tokapu yupuku makó topa yi tale-tale nimba liipa mundupa kene ");
INSERT INTO mux_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","enini-kene ⸤ung-eku mele te topa⸥ nimba mele: “Puniena langi pulele tepa-topa pelemú akiliinga-pe langi kanuma puku liiku nusingí yambu koltale akiliinga Punie Pulu Yili-ni ‘Langi kanuma liiku nusingí kongunale puku tingí yambuma puniena liipa mundupili.’ niku yu-kene mawa teai. ");
INSERT INTO mux_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eni liipu mundukur yima eni sipsip melema, yambu owa-takara auli kísima-ni sipsip topa nolemú akili mele yambuma molemelena liipu mundukur. ⸤Nanga ungele anduku niku singí kene ungele piliiku kis piliikuliinga yambuma-ni eni mindili liiku singí.⸥ ");
INSERT INTO mux_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pungí tekuliinga, wale-tapima kepe, ku-moni kepe, méle-walema kepe, kimbu-su ⸤alowa teku munjingí⸥ ma kepe aima naa meku we pai. Kupulanum-na puku kene yambuma kanuku eninindu ung te naa nikuliinga we pai. ");
INSERT INTO mux_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Kolea tenga-lupa sukundu puku kene akuna mulungíndu lku tiluringa puku pekuliinga ui lku pulu yambu kanumandu niku mele: “Eni numanu kaí pípili molangi.” niai. ");
INSERT INTO mux_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aku-siku ningí kene lku kanuna ‘Numanu kaí pípili molambu.’ nimbá yambu te mulúm lem yunu numanu kaí pípili molumba. Mola aku-siku ningí kene lku kanuna ‘Numanu kaí pípili molambu.’ nimbá yambu te naa mulúm lem eni akuna ‘Pangi.’ nimbu liipu mundukur yi kanuma eni-enini numanu kaí pepa buni te naa pípili mulungí. ");
INSERT INTO mux_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kongun telemú yili yunu méle papu kalemele akiliinga pungí lkuna peku, lku pulu yili-ni keri-langi simbama nai. Lku tenga puku tenga puku naa teai. Lku tiluna mindi keri-langi noku peai. ");
INSERT INTO mux_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Kolea tenga-lupa sukundu puku kene kolea pulu yambu kanuma-ni enindu “Papu úngi. Oliu-kene wasie molamili wai.” níngi lem eni keri-langi singíma noku, ");
INSERT INTO mux_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","akuna kuru tomba yambuma teku kaí teku, eninindu niku mele: “Pulu Yili omba yi nuim kingele molupa oliu nokumba enale enini-kene nondupa ombá.” niai. ");
INSERT INTO mux_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Mola kolea tenga sukundu puku kene kolea pulu yambu kanuma-ni enindu “Eni nambimuna úngiye?” niku, “Wasie piamili wai.” ni naa níngi lem ⸤kolea kanili munduku kelku pungíndu⸥ kupulanum-na puku angiliiku kene yambumandu niku mele: ");
INSERT INTO mux_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Enini oliu liiku su síngeliinga kamu molku kis-sangi! ‘Pulu Yili-ni enini liipa naa tapunjumba akili lakuku piliangi!’ nimbu, oliunga kimbuna ya kolealiinga kingpana angiliikim-ma kepe tanda sipu mundupu pukumulu.” niai. ‘Akili piliangi.’ niku aku-siku niku kene penga ung te kene wasie eninindu kamu niku mele: “⸤Enini lip-lipi tamili piliai.⸥ Pulu Yili omba yi nuim kingele molupa yambuma nokumba enale nondupa ombá.” niai. ");
INSERT INTO mux_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Na-ni enindu aima sika nimbu siker: “Kot enale wendu ombá kene kolea-auli Sodom ⸤yambuma ui ulu-pulu-kis pulele sika tiring akiliinga-pe⸥ eninga kot laye-mele pemba. Akiliinga-pe yambu ili ⸤enindu “Wasie molamili wai.” ni naa niku, eninga ung piliiku naa liingí yambuma,⸥ kot enale wendu ombá kene eninga kot auli-mele te pemba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kolea Korasin kene Besaida taon ⸤akuselenga molemele yambuma⸥ mindili noku aima molku kis-singí. Kolea kanuselenga sukundu ulu-tondulu pulele tirindu ⸤akiliinga-pe akuna molemele yambuma numanu topele naa tolemele⸥. Kolea-auli Taya kene Saidon-selenga sukundu ulu-tondulu mare naa tirindu akiliinga-pe kolea kanuselenga sukundu na-ni ulu-tondulu mare aku-sipu telka kanolkemelanje kolea kanuselenga ⸤yambuma-ni⸥ enini ulu-pulu-kis telemelema kórunga munduku kelku, liiku bulu siku, numanu topele tolkemela. ");
INSERT INTO mux_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","⸤Akiliinga,⸥ kot enale wendu ombá kene kolea-auli Taya kene Saidon kanuselenga ⸤yambuma ulu-pulu-kis sika telemeláliinga⸥ eninga kot laye-mele pemba. Akiliinga-pe eni kolea Korasin kene Besaida-selenga ⸤yambuma na-ni ulu-tonduluma tirindu mele kanukuliinga numanu topele naa turingeliinga⸥ kot enale wendu ombá kene eninga kot auli te mele pemba. ");
INSERT INTO mux_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Kapeniam taon ⸤yambuma eni⸥ ‘Mulú-koleana pupu molomulú.’ niku piliikimiliye? Akili kapula mólu. ⸤Eni nanga ungma taki-taki piliilimili akiliinga-pe numanu topele naa tolemeláliinga⸥ eni kolea-kísina puku mulungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","⸤Aku-sipa nimba kene yunu-ni liipa mundumba tirim yimandu ung te wasie nimba mele:⸥ “Eni ung ningíma piliipa liimba yambale-ni na-ni ung niliu ungele piliipa liimbako. Eni ung ningíma naa piliipa ‘Oliu kene wasie molamili.’ naa nimbá temba yambale-ni na-kene ‘Wasie naa molambili.’ nimbáko. Nandu ‘Wasie naa molambili.’ nimbá yambale-ni na ma-koleana liipa mundurum yi kanilindu ‘Wasie naa molambili.’ nimbáko.” nirim. ⸤Yesos-ni aku nimba pora sipa kene ‘Yunga kongunale tenji-pai.’ nimba enini liipa mundurum.⸥ ");
INSERT INTO mux_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","⸤Walse⸥ Yesos-ni liipa mundurum yi tokapu yupuku yunu mulurumna aima numanu siku yandu oku kene enini yunundu niku mele: “Auliele, oliu-ni nunga bili lepuliinga kuruma kepe oliu-ni ung nirimuluma piliiku liiku tiring.” niring. ");
INSERT INTO mux_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesos-ni eninindu nimba mele: “Aku-siku telsiliiku anduring kene ⸤kurumanga nuim⸥ Seten kolea-kariyapa mele tepaliinga, topa ⸤mana⸥ mania mundurum na-ni kanurundu. ");
INSERT INTO mux_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Piliai! Eni tondulu te sirindu. Yambu nomba kunjuli wambiye-kalta mola karoma mele akuma eni naa kanuku kambiliingí kene méle akuma-ni eni nanga yambuma ‘Ulu te naa tipili.’ nimbu tondulu kanili eni sirindu. Oliu-kene ele-tu ⸤kuru Seten⸥ yunu sika tondulu pulimú akiliinga-pe eni tondulu sirindu kaniliinga yunu-ni eni ulu te kapula naa temba. ");
INSERT INTO mux_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Akiliinga-pe aku-sipu nikereliinga numanu naa siku, kuruma eninga ungele piliiku liiku telemeláliinga numanu naa siku; ⸤Pulu Yili-ni⸥ mulú-koleana ⸤molupa⸥ eninga bima topa munjurumeliinga numanu siku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yesos-ni Pulu Yili-nga Mini Kake Tiliele kene numanu lakupa sipaliinga Pulu Yili-ndu nimba mele: “Tata, Mulú-Masele Nokukunu Mollu Yi-Nuimele, na-ni nu-kene “Angke” niker. ‘Oliu piliipa kungnjuli pelemú. Oliu oliuliu ungmanga puluma pali piliipu kongnjulimulu.’ niku piliilimili yambuma enini na-ni teliu ulumanga pulele ‘Naa piliangi.’ nikunu naa niku sirinu. Yambu kangambula-pame ⸤mele⸥ molku, na-ni niliu ungma kum leku molemele yambuma mindi na-ni teliu ulumanga pulele ‘Piliangi.’ nikunu, enini niku sirinu kaniliinga nu kape nimbu “Papu tirinu.” niker. Sika Tata, nu-ni ‘aku-sipa wendu ombá kene numanu simbu.’ niku aku-sikunu tirineliinga ⸤aku-sipa wendu okum.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","⸤Pulu Yili-ndu aku-sipa nimbaliinga alsupa yambu muluring yambumandu nimba mele:⸥ “Mélema pali Tata-ni na sirim. Yambu te-ni Málale aima sika molemú akili piliipa kanupa bi silimú yambu te mólu; lápale-ni mindi yunu kanupa bi silimú. Yambu te-ni Lapa aima sika molemú mele piliipa kanupa bi silimú yambu te naa molemú. Málale-ni mindi kanupa bi silimú; Málale-ni ‘Lapa liipu ora sambu.’ nimbá yambuma enini Lapa kanuku bi singíko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kanu-kene yu lumbili anduli yi kanuma eni-enini muluringna pupa ‘Enini mindi piliangi.’ nimba eninindu nimba mele: “Eni mongale-ni kanolemele mélema kene uluma kanolemele yambuma eni Pulu Yili-ni “Numanu kaí pípili molku kaí teangi.” nilimú kupulanum-na molemele. ");
INSERT INTO mux_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na-ni enindu aima sika nimbu siker: “Ui muluring yambuma, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kanuma kene, yi nuim kingima kene, yambu pulele kanuma ekupu eni mongale-ni kanuku molemele mélema kene uluma kene kanungíndu “Kanámuluka!” niku muluring akiliinga-pe naa kanuring. Eni ekupu kumele-ni ung piliiku molemele mélema piliingíndu “Piliámuluka!” niku muluring akiliinga-pe naa piliiring.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pulu Yili-nga ung-manimanga puluma piliipa kunjurum yi te-ni ‘Yu-ni nimba kis-simbanje manda lepu piliambu.’ nimba Yesos-ndu walsipa piliipa kene nimba mele: “Ung-Bo Tunjuliele, na nambulka tembu kene kona molupu konjupu mindi puli ulu-pulele liimbuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesos-ni yunundu nimba mele: “Pulu Yili-nga ung-manima Moses-ni bukna turum molemúma kanukuliinga nambulka nimba molemú niku kanolluye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yili-ni pundu topa kene nimba mele: “Pulu Yili-nga ung-manima-ni nimba mele: ‘Eninga numanuma kene, eninga minima kene, eninga tonduluma kene, eninga piliipa kungnjúlima kene, akuma-ni eni Auli Yawe eninga Pulu Yili mindi tondulu munduku numanu monjai.’ nimba pepa, ‘Eni-enini lupa-lupa numanu monjuku eninga kangiele eni-enini kondu kolku nokolemele mele aku-sikuko pulu lelemú yambuma numanu monjuku nokuku molai.’ nimba molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesos-ni yunundu nimba mele: “Nu aima sika nikinele. Nu aku-sikunu tinu lem molupa mindi puli kupulanum-na puni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Akiliinga-pe Pulu Yili-nga ungmanga puluma piliipa yambuma ung-bo tunjuring yili-ni ‘Yambuma-ni ‘Na aima piliilimú yili’ niku piliangi.’ nimbaliinga alsupa nimba mele: “Nanga pulu lelemú yambuma nameléye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesos-ni ung te pundu topa kene nimba mele: “Juda-yi te kolea-auli Jerusallem mundupa kelepa kolea-auli Jeriko pumba purum kene wa-yi kanuma oku yunga mulumbale posuku torulku liiku yunu toku nosuku enini puring. ");
INSERT INTO mux_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kanu-kene Pulu Yili popu tunjuli yi te kupulanum kanuna mandu pumba ombaliinga yili kupulanum-na lirimele kanupa kene yunu lirim koleana mundupa kelepa kupulanum alse ekendunga omba purum. ");
INSERT INTO mux_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Penga aku-sipako Pulu Yili-nga kongun tinjili talape LLipai yi te yili toku nusiringina omba kanupa kene yunu lipili mundupa kelepa kupulanum alse ekendunga omba purumko. ");
INSERT INTO mux_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akiliinga-pe Sameria yi te kupulanum kanuna pumba omba kene yili lirim koleana omba kanupaliinga kondu kolupa, ");
INSERT INTO mux_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","lirimna nondupa pupa kangi turingmanga kopungu kene no-waen kene onde lepa kanjunjupaliinga ka-banisi-ni ka tonjupa kene, penga yunu-ni kanglupa ola liipa yunga kung-dongki bulu-mingina ola nosupa memba pupaliinga yambu poningma oku pi-pui-upui tiring lku tenga memba pupa nosupa nokupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Piringli kene ipulam-ui yunu pumba tepaliinga ku-moni paip-kina mele wendu liipa lku pulu yili sipaliinga nimba mele: “Yili nokukunu kunjui. Penga siker ku-moni ili kapula naa tepa nunga ku-moni mare wasie pumu lem penga kelepu yandu ombu kene nunga ku-moni pundu tombu.” nimba Sameria-yili-ni aku-sipa nirim.” ⸤nimba Yesos-ni aku-sipa nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","⸤Aku-sipa nimbaliinga alsupa nimba mele⸥ “Yi yupuku oku puring imanga wa-yima-ni toku nusiring yilinga pulu lirim yili naeye? ⸤Juda-yi ui-pulu-pulu oku kanukulu we oku puringli yiselenga te mola yunga ele-tu mele yi aelepa urum yiliye?”⸥ nimba walsipa piliirim. ");
INSERT INTO mux_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pulu Yili-nga ungmanga puluma piliipa yambuma ung-bo tunjuring yili yunu-ni nimba mele: “Yili-ni yunu we kondu kulurum yili lem.” nirim. Kanu-kene Yesos-ni yunundu nimba mele: “Nu pukunu aku-sikunu ti-pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kanu-kene Yesos kene yunga lumbili andúlima kene enini oku puku kene kolea tenga pupa ambu Mata yunga lkuna “Wasie molamili ui.” nirim-na yunu akuna purum. ");
INSERT INTO mux_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata yunga anginele Maria molupa kene yunu Yesos-ni ung kaí nilimú nimbáma ‘Piliambu.’ nimba Yesos mulurumna omba nondupa mania molupa kene Yesos ung nimba mulurum mele yunu piliipa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Akiliinga-pe Mata yunu keri-langi kalunjupa, kongun tepa mulurum-na yunu kongun wanwani lakupa lirim kilia Yesos mulurumna pupa nimba mele: “Auliele, nanga anginele na liipa naa tapunjukumu-na na-nanu mindi langi nomulú kongunale tepu molkur akili kondu naa tekemuye? Yunu-ni na ‘Omba liipa tapunjupili.’ ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Aku-sipa nirim-na piliipa kene Yesos-ni yunundu pundu topa nimba mele: “Ambu Mata, ulu pulele numanu lakuku liiku mundukunu numanu buni liikunu mollu ");
INSERT INTO mux_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","akiliinga-pe ulu tilu mindi nu naa piliikunu tellu. Ulu kaí akili Maria-ni ‘Teambu.’ nimba kene ⸤nanga ungele piliipa⸥ molemú. Ulu kaí akili yunu-ni temba kupulanumele yambu te-ni “Mólu!” nimba manda pipi naa simba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Walse, kolea tenga, Yesos yunu Pulu Yili-kene popu topa ung nimba molupa kene penga nimba pora sirim kene yunga lumbili anduring yi te-ni yunundu nimba mele: “Auliele, oliu Pulu Yili-kene popu topu ung nimulú mele mani si. ⸤No-Liinjili⸥ Jon yunu lumbili anduring yi kanuma mani sirim akili mele oliu aku-sikunu mani si.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","⸤Aku-sipa nirim kene piliipaliinga⸥ Yesos-ni eninindu nimba mele: “Eni Pulu Yili-kene popu toku ung ningíndu i-siku mele niai: “Tata, yambuma-ni ‘Nunga bi ola pípili, yi kake tili kaiéle mollu.’ niku molangi. Nu yi nuim kingele molkunu yambuma nukuni enale wendu upili. ");
INSERT INTO mux_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ekupu kepe penga taki-taki oliunga nomulú langima siyo. ");
INSERT INTO mux_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yambuma-ni oliu teku kis-silimele kene oliu-ni kanupu konde tenjipu ulu te naa telemulu akiliinga oliu-ni nu-kene tepu kis-silimulu kene nu-ni aku-sikunuko kanuku konde tenjikunu oliu ulu te naa tiyo. Oliu ‘Ulu te-ni kundi tupili.’ ni naa niani.” niku aku-siku niai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Aku-sipa nimbaliinga penga eninindu ung te wasie nimba mele: “Nu nunga pulu lelemú yambu te aima sumbulsuli ai-burum molumbana pukunu kene yunundu niku mele: “Ang, langi mare siyo. ");
INSERT INTO mux_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yi-poning te kolea tenga-lupa pumbandu nanga lkuna pemba okum akiliinga-pe na langi te naa lelemú akiliinga nu-ni na langi mare si.” nilkena kene ");
INSERT INTO mux_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yunu-ni nundu nimba mele: “Nu-ni na buni te aku-sikunu naa si.” nilka. “Kangambulama kene ui lku-kuna angnjipu uru pímulaliinga na ola molupu ombu méle te nu kapula naa simbu, mólu.” nilka. ");
INSERT INTO mux_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Na-ni enindu nimbu siker: “Yunga angenale nimbaliinga ola molupa langi naa silka akiliinga-pe nu-ni yunu taki-taki mawa telkenaliinga yunu enimbu kolupa wendu omba langi silka.” niker. ");
INSERT INTO mux_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Aku-sipa telkaliinga eni ⸤nanga lumbili andúlima⸥ ndu ung te wasie nikerko: “⸤lápale, Mulú-Koleana Molemú Yili,⸥ mélema mawa teku “Si.” niai. Aku-siku tingí kene mélema sika simba liingí. ⸤lápale molemúna⸥ mélema korai. Aku-siku tingí kene mélema sika kanuku liingí. Lku-keri-puluna angiliiku “Lkundu wamiliye.” niai. Aku-siku ningí kene “Lkundu wai.” nimba kuna liimba. ");
INSERT INTO mux_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mawa tingí mélema sika simba liingí, kurungí mélema sika kanuku liingí, “Lkundu wamiliye.” ningí kene sika kuna liimba. Aku-sipa tembaliinga aku-siku teai.” niker. ");
INSERT INTO mux_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Eninga yi te yunga málale omba kene “Tata, oma te nambu si.” nimbá kene yunga lápale-ni wambiye te simbaye? ");
INSERT INTO mux_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Mola kangale-ni “Tata, kera-múlu te nambu si.” nimbá kene yunga lápale-ni karoma mola koniwe-makena te liipa simbaye? ");
INSERT INTO mux_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe eni numanu kis pípili molemele yambuma-ni aku-siku eninga kangambulama méle kaíma silimele lem, eninga Lapa Mulú-Koleana Molemú Yili-ni ⸤méle aima pulele naa simbaye? Lakupa simbale.⸥ Yambuma-ni yunundu “Mini Kake Tiliele oliunga numanuna omba mulupili si.” niku mawa tingí yambuma yunu-ni enini simba liingí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Walse yi te yunga numanuna kuru te mulurum-na ung manda naa nirim kene Yesos-ni kuru kanili topa makururum. Kurale wendu omba ulsu purum kene yi kanili ung nirim. Aku tirim kanuku kene yambuma mini-wale munduku muluring. ");
INSERT INTO mux_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Akiliinga-pe yambu mare ⸤Yesos-kene numanu kis panjiring⸥ kanuma-ni niku mele: “Kurumanga nuim Belsipull Yesos-nga numanuna molupa kene yunu tondulu silimú-na yunu-ni kuruma topa makorolemú.” niring. ");
INSERT INTO mux_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yambu mare-ni Yesos manda leku “Nambulka nimbánje.” niku yunundu niku mele: “Nu sika Pulu Yili-ni ‘Kongun tenjani.’ nimba liipa mundurumnje kanamili, mulú-koleana ⸤Pulu Yili-ni mindi kapula temba⸥ ulu-tondulu te ti.” niring. ");
INSERT INTO mux_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Enini aku-siku numanale-ni piliiring akili Yesos-ni piliipaliinga ‘⸤Yesos Seten-kene ele-tu muluringlieliinga Seten-ni yunu naa liipa tapunjulka akili lakuku piliangi.’ nimba⸥ eninindu nimba mele: “Yambu-talape te numanu tiluna naa pupili molku suku-singina oe panjiku eni-enini ele teku lupa-lupa molemele kene talape kanili pora nilimú. ⸤Mola⸥ lku tiluna pelemelé yambuma numanu tiluna pupili naa molku eni-enini ele telemele kene yambu-talape kanili sungu siku lupa-lupa mulungí. ");
INSERT INTO mux_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aku-sipako, Seten-ni yunga kuru te topa makurulkanje aku telkaliinga yunga talapele kene ele mele telka. Penga yunga talapele nambi-sipa kapula molkemelaye? ⸤Pora nilka.⸥ Eni nandu “Belsipull-ni yunu liipa tapunjilimú-na yunu-ni kuruma topa makorolemú.” nikimili akili. Sika aku-sipa telkanje Belsipull yunga talapele pora nilka. ");
INSERT INTO mux_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Ung te kamu piliai. Na-ni Belsipull-nga tondulale-ni kuruma topu makuruliu lem eninga yima-ni naenga tondulale-ni kuruma toku makurulemeleye? Akiliinga, ⸤eninga yi kuruma toku makorolemele yima-ni ‘Pulu Yili-ni oliu tondulu silimú-na oliu-ni kuruma topu makorolemulu.’ niku piliilimiláliinga⸥ eni nandu nikimili ung ima yi kanuma-ni ung piliiku apuruku kene “Eni gólu tokomele.” ningí. ");
INSERT INTO mux_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Akiliinga-pe sika Pulu Yili-ni na tondulu silimú-na na-ni kuruma topu makurundu lem Pulu Yili yi nuim kingele molumba enale eni molemelena kórunga wendu um.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Yi tondulu puli te-ni ele mélema ambulupa yunga lkuli nokupa konjulimú kene yi te-ni we kapula sukundu omba mélema wa naa liilimú. Yunga lku lelemú mélema kapula lelemú. ");
INSERT INTO mux_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Lku nokulemú pulu yi kanili-ni ‘Nanga ele mélema ambulupu kene nanga mélema kapula nokupu konjumbu.’ nilimú akiliinga-pe yunga ele-tu yi te tondulu lakupa pulimále omba yunu tomba tepaliinga ele-tu yilinga lku nokulemú yili topa mundupa yunga ambululemú ele mélema anju liipa, lkuna lelemú mélema liipa memba pupa yunga pulu lelemú yambuma moke tepa silimú. ");
INSERT INTO mux_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na naa liipa tapunjilimú yambale-ni na-kene ele-tu molemú. Yambu te-ni na liipa tapunjupa ⸤kung-sipsipma⸥ sukundu naa liilimú yambale-ni ⸤kung-sipsipma⸥ topa bulu-bale silimú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","⸤Yesos-ni ung te kene wasie nimba mele:⸥ “Kuru te yi tenga numanuna wendu omba kene, no naa uli koleamanga pupa kóru molumba kolea-kolu korolemú. Tenga naa kanupa liipaliinga yunu-ni nimba mele: ‘Nanga ui molupu kene wendu undu lkuna kelepu pambu.’ nimbá. ");
INSERT INTO mux_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aku-sipa nimba kene yunu omba yunga ui molupa purum lkuli kanolemú kene, lku kulsupana memba tepa kaí tepa we lelemú kene kanupaliinga ");
INSERT INTO mux_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","yunu kelepa anju pupa kene, kuru kara puli aima ola-kilia angere yupuku-guli liipa memba omba enini wasie lku kanuna lkundu puku molemele. Kanu-kene yi kanili ui molupa kis-silimú akiliinga-pe penga aima kamu lakupa mele molupa kis-silimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesos-ni aku-sipa nimba mulupili máku toku muluringna ambu te-ni ung tondulu nimba mele: “Nu aima tekunu konjullaliinga ambu nu memba ame sirimele yunu Pulu Yili-ni “Numanu kaí pípili molku kaí teangi.” nilimú kupulanum-na molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesos-ni nimba mele: “Sika akiliinga-pe yambu Pulu Yili-nga ungele piliiku liiku teku molemele yambuma enini Pulu Yili-ni aima ola-kilia “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yesos mulurumna yambu pulele sukundu-sukundu oku liiku máku turing kene yunu-ni eninindu nimba mele: “Ekupu ma-koleana molemele yambuma yambu-kísma mindi molemele. Enini teku kis-siku Pulu Yili liiku su silimele yambuma-ni “Na molupu niliu mele akili sikanje, kanamili akiliinga Pulu Yili-ni mindi ulu-tonduluma manda telemú akili mele ti.” niku na mawa telemele. Akiliinga-pe ⸤na Pulu Yili-kene tapú-topulu kongun telembulu akili mele liipa ora simba ulu⸥ te wendu naa ombá. ⸤Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi⸥ Jona-kene wendu urum ulu akili-ni mindi liipa ora silimú kapula kanungí. ");
INSERT INTO mux_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona-kene ⸤oma auli te-kene⸥ ulu-tondulu te ola urum ulele-ni Ninipa yambuma-⸤kene ulu buni te wendu ombá mele⸥ liipa ora sirim aku-sipa mele Mania Omba Mana-Yi Au Talurum Yili-kene ulu-tondulu wendu ombá ulele-ni ekupu molemele yambuma-kene ulu penga wendu ombá mele liipa ora simba. ⸤Liipa ora simba ulu te-lupa naa ombá, naa kanungí.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","“Ui kolea-auli Ninipa yambuma ⸤sika molku kis-siring akiliinga-pe Pulu Yili-ni “Niku sinjui.” nimba, nimba sirim akili⸥ Jona-ni ⸤piliipa⸥ pupa Ninipa-yambuma nimba sirim kene piliikuliinga teku kis-siring mele akili kanuku kis piliiku numanu topele toku molku kunjuring. Aku-siku tiringeliinga ekupu molemele yambuma-ni Jona-nga olandupa yi te ya molemú yilinga ungele liiku su siku naa piliilimiláliinga kot enale penga wendu ombá kene Ninipa-yambuma-ni kot-na angiliiku, ekupu molemele yambumandu “Teku kis-siring. Mindili nungí kene kapula.” ningí. “Ui ⸤oliu Isrel-yambumanga yi nuim king⸥ Sollomon yunu yi aima tondulu te molupa, yunu ung lupa-lupama piliipa kungnjuliele pili mulurum akili kolea Sipa nukurum ambu nuim kuinele piliipaliinga, Sollomon-ni ung kaíma mindi nirim mele piliimbandu yunu kolea suluna molupa kene ⸤Sollomon mulurumna⸥ ena pulele kupulanum-na sing-lku pelsiliipa urum. Aku-sipa tirimeliinga, yi-nuim Sollomon-nga olakundu ya molemú yili-ni nilimú ungele ekupu mana molemele yambuma-ni naa piliiku, liiku su silimeláliinga kot enale wendu ombá kene kolea Sipa ambu nuim kuinele-ni nimba mele: “Sollomon-ni ung kaí nirim akili na piliimbundu kupulanum suluna urundu akiliinga-pe Sollomon-nga olakundu mulurum yili-ni nirim ungele enini naa piliiku, liiku su siring yambuma aku-siku tiringeliinga enini kapula mindili nungí.” nimbá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","⸤Aku-sipa nimbaliinga Yesos-ni ung te wasie nimba mele:⸥ “Yambuma-ni tepi-llam kanduku kene luikolu-na naa monjuku, mingina sukundu naa nosuku kene ‘Lkuna sukundu pa tipili. Yambu ungíma-ni kolea kanangi.’ niku poluna ola nosuku molemele.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Nunga mongsele nunga kangieliinga tepi-llam melale. Aku-sipaliinga nunga mongale kaí angiliimú kene nunga kangiele pali pa telemú-na molláliinga nu molkunu konjullu. Akiliinga-pe nunga mongsele kis lemba kene nunga kangiele pali sumbulú molombana anduni. ");
INSERT INTO mux_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Akiliinga, nunga kangina pa tili pembale ‘alsupa sumbulú naa tupili.’ niku ⸤kangiele pa tipili molemú mele molku kunjui⸥. ");
INSERT INTO mux_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nunga kangina pa tepa peka topa pípili molku sumbulú te kepe naa tupili muluni kene nunga kangi numanuma pali pa tembana muluni. Tepi-llam talang pulimú kanolemulu akili mele nunga kangi numanusele pa tembana muluni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesos-ni ungele nimba pora sirim kene Perisi-yi kanumanga te-ni Yesos-ndu nimba mele: “Langi wasie nambili ui.” nimbaliinga yu-kene pupa langi nombandu mania mulurum. ");
INSERT INTO mux_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Akiliinga-pe yunu ui ki lumaye naa topa kene langi we nurum kanupaliinga Perisi-yi kanili-ni numanu pulele liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yesos-ni ⸤yunu numanu liipa mundurum akili⸥ piliipaliinga ⸤ung-eku mele te topa⸥ yunundu ⸤ung-mura tepa kene⸥ nimba mele: “Eni Perisi-yi kanuma plletma kene kapma kene ulsukundu lumaye tolemele akiliinga-pe akiliinga sukundu, eninga numanuna sukundu mele, kalaru pulele molemú. Ulu-pulu-kísima kene, mélema wa liilimele ulu-pulele kene akuselenga pelemú. ");
INSERT INTO mux_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eni aima sundupa sili-pili yambuma. Kangiele tirim yili-ni numanale wasie naa tirimuye? ⸤Walse-nele tirimeliinga⸥ eni kangiele no leku kake tipili molemele mele aku-siku eninga numanukundu kake tipili mulúngi lem kapula. ");
INSERT INTO mux_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eni numanu topele toku kene yambu-korupama kondu kolku eninga méle nosulimelema singí kene eninga numanu kalaru molemále alko topa kake tipili mulungí mele yambuma-ni kanungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Perisi-yima, eni mindili noku aima molku kis-singí! Eni eninga puniena olemú langi aima kelúma kengipa kulá kimú aku-sipa mélema meku kambu toku rurepunga tale rurepunga tale niku liiku nosuku kene tilu tilu niku wendu liiku ‘Pulu Yili-nga kongunale tinjili yi kanuma samili.’ niku silimele. Pulu Yili-ni aku-siku ‘Teai.’ nirim mele eni kapula telemele akiliinga-pe ulu olandupama naa telemele. We-yambuma kondu naa kolku, Pulu Yili-ni yambuma numanu monjulemú mele eni manda leku yambuma numanu naa monjulemele. Aku-siku ulu auli mele mare telkemelanje kapula. Ekupu ulu kelú telemele akili munduku naa kelkuliinga ulu akuma kene ulu aulima kene wasie-nele telkemelanje kapula. Akiliinga-pe aku-siku naa telemeláliinga eni mindili noku aima molku kis-singí! ");
INSERT INTO mux_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Perisi-yima, eni Juda-yambuma máku toku Pulu Yili-nga ungele piliilimili lkuna lkundu puku kene mania mulungíndu yi-aulima molemele polu kaí akuna ‘molomulú.’ niku mendu puku polu akuna numanu siku molemele. Yambuma máku toku molemele koleamanga mong-keng teku andungí kene ‘We-yambuma-ni oliu kanuku kape niangi.’ niku piliikuliinga numanu siku piliiku molemeleko. Aku telemeláliinga eni mindili noku aima molku kis-singí! ");
INSERT INTO mux_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“⸤Perisi-yima,⸥ eni yambu-ónu-kolea tenga ‘Yambu ilinga ónu telemele.’ niku naa piliiku walu-siku kimbu kambiliilimele mele eni aku-siku molemeláliinga mindili noku aima molku kis-singí!” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesos-ni aku-sipa nirimele piliiku kene Pulu Yili-nga ung-manimanga puluma piliipa kungnjurum yi te-ni yunundu nimba mele: “Ung-Bo Tunjuliele, ‘Nu-ni Perisi-yi kanuma aku-siku ung-mura tekenaliinga oliu kepe ung-mura tekenu.’ nimbu piliikumulu.” nirim kene piliipaliinga ");
INSERT INTO mux_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesos-ni kelepa enini ⸤ung-mura tepa kene⸥ nimba mele: “Sika nikinu. Eni Pulu Yili-nga ung-manimanga puluma piliiku kungnjuli yi kanuma mindili noku aima molku kis-singíko! Eni ung-mani siku ‘Teai.’ nilimele mele we-yambuma piliiku kene tingíndu buni kolemele. Aku-siku buni pulele mindili siku mingí mele ‘Meangi.’ niku siku kene eni-enini layesele kepe ‘Liipu tapunjupu meamili.’ naa niku molemeláliinga eni ⸤kepe⸥ mindili noku aima molku kis-singíko! ");
INSERT INTO mux_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“⸤Eni Pulu Yili-nga ung-manimanga puluma piliiku kungnjuli yi kanuma,⸥ eninga anda-kolepalima-ni Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima toku kunjuring. Ekupu, yandupa, eni yi kanuma ónu tiring koleama au silimele. Anda-kolepalima enini yi kanuma toku kunjiringele piliiku kaí piliiku kene penga ekupu eni yi kanuma ‘Papu toku kunjuring.’ niku enini ónu tiring koleama au silimeláliinga eni mindili noku aima molku kis-singí! ");
INSERT INTO mux_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“⸤Ui eninga anda-kolepalima-ni aku-siku tiring, ekupu eni aku-siku telemelá⸥liinga Pulu Yili yunu ung pali piliipa kungnjuli yili-ni ui nimba mele: “Na-ni yi mare ung mare nimbu sipu ‘Enini yambuma niku sai.’ nimbu liipu mundupu, yi mare ‘Nanga kongunale tenji-pai.’ nimbu liipu mundumbu kene yambuma-ni liipu mundumbu yimanga mare mindili siku, mare toku kunjingí.” nimba Pulu Yili-ni nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","“Kóru-ui Pulu Yili-ni male koela tepa mím tirim kene enini Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kanuma toku konjuku, penga yandupa-yandupa aku-sili yima pali toku kunjuring. Kóru-ui Adam málu Eboll toku konjuku, penga yandupa-yandupa aku-sili yi lupa-lupama toku konjulsiliiku puku, penga kamu Pulu Yili-ni “Niku sinjui.” nimba, nimba sirim ungma piliipa yambuma nimba sirim yi Sekaraya Pulu Yili ⸤popu toku kaluli⸥ lku-tembolluna lku-suku toku kunjuring. Kanuna sukundu sulumina kake tiliele akuna anjukundu lirim, Pulu Yili popu toku mélema kaluring polale yakundu lirim, suku-singi kanuna yunu toku kunjuring. Ui muluring yambuma-ni yi kanuma toku kunjuringeliinga Pulu Yili-ni enini sika “Mong liiringeliinga mindili nangi.” nilka akiliinga-pe ekupu molemele yambuma enini Pulu Yili-ni kot piliipaliinga anda-kolepalima-ni aku-siku tiringeliinga enini “Mong liiring akiliinga mindili nangi.” nimbáko. ");
INSERT INTO mux_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Pulu Yili-nga ung-manimanga puluma piliiku kungnjuli yi kanuma, eni ung-manimanga puluma piliiku kongnjulimele akiliinga-pe “We-yambuma-ni naa piliangi.” niku enini piliingí kupulanumele pipi silimele. Eni Pulu Yili-nga bukna molemú ungele taki-taki kanolemele akiliinga-pe apuruku kene Pulu Yili-ni “‘Yi te enini nokupa konjupa tepa liipili.’ nimbu makó topu liipu mundumbu.” nirim yilindu nimba bukna molemú ungma kanuku kene piliiku sundulimele. Sumbi-siku piliingí kupulanumele eni naa pulimelé; bukna yi kanilindu nilimú ungma ‘Piliamili pamili.’ niku molemele yambu lupama piliingí kupulanumele “Mólu.” niku pipi silimeleko. Aku telemeláliinga eni mindili noku aima molku kis-singí!” nirim. ");
INSERT INTO mux_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Yesos-ni ⸤ung akili nimba pora sipaliinga⸥ lku akili mundupa kelepa pumba purum kene yunu-ni ung-mura sirim yi-Perisima kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene enini ‘Yu ung nambulka ung mare wasie nimba kene, yunu ung nimba kis-simba kene yunu kot tenjimulú.’ niku kene enini ung lupa-lupa pulele lkisiku walsiku piliiku kene “Pundu toku ni.” niku tondulu munduku niring. ");
INSERT INTO mux_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kanu-kene Yesos mulurumna yambu tausen pulele liiku máku toku angiliiringi, yambu aima si-si siku angiliiring kene yunu lumbili anduring yimandu ui kumbi-lepa nimba mele: “Eni lip-lipi topu, ‘Perisi-yi kanuma pllawa tepa auli mundulimú méle yis nosulimelale kanuku piliiku kongnjai.’ niker. Eninga yis nosulimele akili enini ⸤“Pulu Yili-nga ulu kaíma telemulu.” niku⸥ gólu toku topele-mapele tolemele ulele. ⸤‘Akili manda leku naa teangi.’⸥ nimbuliinga lip-lipi ili tokur. ⸤Perisi-yima-ni sika teku kis-siku molemele akili mele kamu mo kapula naa tungí.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mo tolemú ulumanga te kepe penga panda naa topa pali mokeringa lemba. Mo tolemú ulumanga te kepe penga mo naa tomba. Ulu kanuma kene ungma pali yambuma-ni pali piliingí. ");
INSERT INTO mux_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sumbulsuli ung niringma yambuma-ni tangiliim piliingí. Lku-suluminana ung ólu-wálu toku niring ungma lku-imuna olakundu angiliiku nangale toku ningí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nanga pulu lelemú yambuma, enindu ung te nimbu sambu: “Kangiele mindi toku konjukuliinga penga kelku minéle kene wasie ulu te kapula naa tingí yambuma-kene mundu-mong naa teai.” niker. ");
INSERT INTO mux_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Akiliinga-pe eni-kene aima mundu-mong tinjingí yili nimbu sambu: “Kangiele topa konjupa kene penga minéle pali tepi-koleana manda topa mundumba ⸤Pulu Yili⸥-kene mundu-mong tenjai. Aima sika nimbu siker. Yunga mundu-mong tenjai.” niker. ");
INSERT INTO mux_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Kera kalepandele aima kelále molemú, akiliinga taropu toku liingíndu kera angere te-guli ku-moni kululi tale mindi pulimú kanili. Akiliinga-pe Pulu Yili-ni kera kanuma nokumbaliinga apera naa silimú. ");
INSERT INTO mux_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Piliai! Eni ⸤na lumbili andúlima⸥, eninga pengi-dima kepe yunu-ni kórunga tilu-tilu nimba pali kambu topa pora sirim. Kera kalepandele yunga ku-moni aima koltale mele akiliinga-pe kera kanili Pulu Yili-ni kanupa piliilimú. Eni yambuma aima lakupa aulima nimba kanupaliinga eni aima nokupa konjumba⸤liinga mundu-mong naa teai.⸥” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na-ni enindu ung te nimbu sambu: “Yambu te-ni yambumanga kumbi-kerina ola angiliipa ‘Na Yesos-nga yambale moliu.’ nímu lem penga Pulu Yili-nga angkellamanga kumbi-kerina Mania Omba Mana-Yi Au Talurum Yili-ni ola angiliipa “Yambu kanili nanga yambale.” nimbáko. ");
INSERT INTO mux_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Akiliinga-pe yambumanga kumbi-kerina “Yesos yunu yi naeye? Yunu na naa piliiker.” aku-sipa nimbá yambale penga Pulu Yili-nga angkellamanga kumbi-kerina Mania Omba Mana-Yi Au Talurum Yili-ni “Yambu akili yunu naeye? Yunu na naa piliiker.” nimbáko. ");
INSERT INTO mux_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Mania Omba Mana-Yi Au Talurum Yili ung-taka tonjupa nimba kis-silimú yambale aku-sipa ulu-kis telemúma ⸤Pulu Yili-ni⸥ ‘Mania pupili.’ nimba kanupa konde tenjimba. Akiliinga-pe Mini Kake Tiliele ung-taka tonjupa, nimba kis-sipa, yunga bili marake telemú yambale aku-sipa ulu-kis telemále ‘Mania pupili.’ naa nimba, aima kanupa konde naa tenjimba.” niker. ");
INSERT INTO mux_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Kanu-kene penga eni ⸤nanga yambuma mulungí kanuku kene⸥ eni oku ka siku, enini liiku máku toku Pulu Yili-nga ungele piliilimili lkumanga yi-aulima kene, yi-nuimima kene, gapman yi-aulima kene enini mulungína eni meku puku kot tinjingí kene ‘Kotna nambulka ung te nimulúnje? Oliu ung te walsingí kene nambulka ung te pundu topu nimulúnje?’ niku mini-wale naa mundai. ");
INSERT INTO mux_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akuna Mini Kake Tiliele-ni eni anju ningí akili mele mani simba akiliinga mini-wale naa mundai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yesos mulurumna liiku máku turing yambumanga yi te-ni yunundu nimba mele: “Ung-Bo Tunjuliele, nanga anginele kene olsunga lápale-ni moya-méle sirim-ma yunu-ni ‘Na mare moke tepa sipili.’ ni.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Akiliinga-pe Yesos-ni yunundu pundu topa kene nimba mele: “Yili, ‘Na-ni eninga kot piliinjikunu eninga mélema moke tinjui.’ nimba nae-ni na makó turumuye? Yambu te-ni nandu aku-sipa naa nirim kanili. Nanga kongun te mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aku-sipa nimbaliinga yunu-ni eninindu alsupa nimba mele: “‘Méle pulele liipu nosupu kamako molambu.’ ni naa niku, ‘Méle languli ulu-pulele ulu-pulu-kisele akiliinga aku-sikunu naa teambu.’ niku piliiku molai. Yambu méle pulele liipa nosulimáliinga mini-kangi pali kona molupa konjumba kupulanum te naa lelemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","⸤Aku-sipa nimbaliinga Yesos-ni ‘Eninindu niker ungmanga puluma kamu piliangi.’ nimbaliinga⸥ yunu-ni ung-eku te topa kene nimba mele: “Walse yi kamako te molupa kene yunga puniena langi aima pulele pirim. ");
INSERT INTO mux_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Akiliinga yununú nimba mele: “Langi nosiliu lkuma pali si nikimeliinga, langi pulele kakena we lelemú akiliinga na-ni nambi teambuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Akiliinga alsupa yununú nimba mele: “Ekupu na piliiker. I-sipu mele teambu. Nanga langi nosiliu lkuma pali tekisipuliinga lku aima aulima kelepu takupuliinga akuna nanga rais-witma kene langi nanga puniena olemúma pali nosumbu. ");
INSERT INTO mux_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Akuna nosupuliinga na nanu piliipu kene nimbu mele: Na kapula. Nanga langi pulele, punie pulele omba pumba kene nombu molumbu mele lelemú akiliinga kóru molupu, langi nombu, no-waen nombu, numanu sipu molambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Akiliinga-pe Pulu Yili-ni yi kanilindu nimba mele: “Yi wiliele. Ekupu sumbulsuli na-ni nunga minéle ombu liimbu kene nunga méle nosulluma nae-ni liimbaye?” nirim.” ⸤nimba Yesos-ni aku-sipa nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","⸤Ung-ekale topa pora sipaliinga ung te wasie nimba mele:⸥ “Aku-sipa mele, ‘Na méle lupa-lupa pulele nosiliu.’ nilimele yambuma Pulu Yili-ni enini kanupaliinga enini yambu korupa púlima nimba kanolemú. Pulu Yili kanupa kaí piliilimú ulu-puluma naa telemele yambuma eninga minikundu korupa mele pupili molemele. Yambu kanuma enini ung-eku tokur yi akili mele molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","⸤We-yambumandu⸥ aku-sipa nimbaliinga Yesos-ni yu lumbili anduli yimandu alsupa nimba mele: “⸤Kulungí kene ma-koleana mélema-ni eni liipa naa tapundupa tepa naa liimba⸥ akiliinga na-ni enindu ung kamu nimbu sambu: ‘Kangikundu molupu konjamili.’ niku numanu pulele liiku naa mundai. Langi nungéliinga kepe no nungéliinga kepe mulumbale pakungéliinga kepe akumanga numanu pulele liiku naa mundai. Eni kapula mulungí mele ola-kilia, keri-langi nungí akili mania-kilia; eninga kangiele ola-kilia mele, mulumbale pakungí akili mania-kilia mele akiliinga keri-langi nungí mele kepe, mulumbale pakungí akili mele kepe, numanu pulele liiku naa mundai. ");
INSERT INTO mux_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kerama kanai. Langi te talku kene tepa tolemú kene liiku meku lkundu puku nosuku naa nolemele akiliinga-pe Pulu Yili-ni kerama keri-langi silimú. Kerama we-mele, eni yambuma ola-kilia akiliinga yunu-ni eni aima nokumba. ");
INSERT INTO mux_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Eninga yambu te-ni numanu pulele liipa mundumba ulu akili-ni yunga kolumba ena-mongale kapula ‘We lipili.’ nimbáye? Kapula naa nimbá. ");
INSERT INTO mux_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eni ulu laye-kolte aku-siku mele te kapula naa telemeláliinga ulu wema eni nambimuna numanu pulele liiku munduku molemeleye? ");
INSERT INTO mux_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pllawa-kukuma kanai. Pllawa kukuma-ni kongun mindili noku naa teku, mulumbale te teku mimi naa telemele akiliinga-pe pllawa-kukuma molemele mele ola-kilia, ⸤yi nuim king⸥ Sollomon kongun pulele tepaliinga wale-pakuli aima kaíma pakupa au nirim mele mania-kilia. ");
INSERT INTO mux_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Era-kuku tolemúma ekupu mele molemú, ulsulam-ukundu mele akili lkunuku tepina kalemelema Pulu Yili-ni aku-sipa mele nokupa konjulimú lem eni ‘Pulu Yili-ni oliu kapula nokumbanje?’ niku layesele mindi piliilimili yambuma mulumbale pakungí mélemanga yunu-ni kapula liipa naa tapunjumbaye? Eni liipa tapunjumba. ");
INSERT INTO mux_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“⸤Pulu Yili-ni kerama kene era-kukuma kene we-méle akuma aku-sipa nokulemú⸥ akiliinga eni numanu pulele liiku munduku kene ‘Es, keri-langi te tena liipu nomulúnje?’; mola ‘No tena kolupu nomulúnje?’ niku naa molai. ");
INSERT INTO mux_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pulu Yili-nga yambuma naa molku ulsukundu molemele yambuma-ni aku-siku telemele akiliinga-pe eninga Lapa ⸤Pulu Yili-ni⸥ eni yunga yambuma méle mólu tolemúma kanupa molemú ⸤akiliinga eni keri-langi nungímanga kepe méle pakungímanga kepe numanu pulele liiku naa mundai⸥. ");
INSERT INTO mux_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","⸤Pulu Yili⸥ yi nuim kingele molupa yambuma nokulemú uluma ‘Kumbi-lepu teambu.’ niku piliiku molai. Aku-siku tingí kene yunu-ni we-mélema kepe eni simba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Nanga kung-sipsip koltale, eninga lápale walse yi nuim kingele molupa yambuma nokumba kene ‘Eni kene wasie yi-nuimima molku yambuma nokangi.’ nimbá. Yunu aku-sipa tembandu numanu sipa molemáliinga mundu-mong teku naa molai. ");
INSERT INTO mux_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","Akiliinga eni méle nosulimelema ku-moni liiku, ku-moni liingí akuma yambu-korupama moke teku sai. Aku-siku teku kene penga ku-moni kamu mania naa puli kuli liiku nosuku, méle kaí lupa-lupama liiku mulú-koleana ⸤penga pungéliinga⸥ nosai. Akuna wa-yi kanuma oku wa naa liingí, koka mola lkurena mélema-ni oku teku kis-siku naa tingí. Eni akuna nusingí mélema kamu kapula lemba. Eninga méle kaíma lelemú kolea akuna eninga numanuma pali piliiku numanu monjuku molemele akiliinga ‘mulú-koleana mindi mélema lipili.’ niku molai.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“⸤Na lumbili andúlima,⸥ eni ‘Auliele ekupu ombánje.’ niku mulumbalema talku, kamirika toku, kamaye kanduku, molai. ");
INSERT INTO mux_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yi-auli te kolea tenga-lupa pupa, yi tenga ambu liimba keri-langi koyolemele yambuma kene anju langi nomba molupaliinga penga yunu kelepa lkundu ombáliinga yunga kendemande-yambuma-ni ‘Yunu ombá.’ niku lku-kunale liingí mele nokuku molemele akili mele eni aku-siku molai. ");
INSERT INTO mux_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kendemande-yambu kanumanga yi-auliele omba yunga kendemande-yambuma kanupaliinga, uru naa peku we mulungí kanomba kendemande-yambuma enini numanu siku mulungí. “Na-ni enindu aima sika nimbu siker: “⸤Taki-taki kendemande-yambuma-ni eninga yi-auliele nokuku keri-langi kalunjuku silimele akili mele yunu aku-siku nokulkemela akiliinga-pe kendemande-yambumanga⸥ yi-auliele-ni ⸤kendemande-yambu kaí kanuma numanu sipa⸥ yunu-ni kongun-mulumbale talupa eninindu “Langi nuli poluna molai.” nimba ‘Langi nangi.’ nimba eninga kongun tenjipa enini nokumba.” niker. ");
INSERT INTO mux_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sumbulsuli ai-burum ombáne mola kera-kulla ko tomba kene ombánje niku enini uru naa peku nokuku mulúngi kanum lem enini numanu siku mulungí. ");
INSERT INTO mux_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ung ili numanu liiku munduku piliai. Lku pulu yi te-ni wa-yi te yunga lkuli omba bulsupa mélema wa liimba ena-mongale piliilkanje ‘Wa-yili ombá.’ nimba nokupa molka kene wa-yili kapula sukundu naa olka. ");
INSERT INTO mux_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Aku-siku eni nokuku molai. Mania Omba Mana-Yi Au Talurum Yili ombá ena-mongale naa piliilimili akiliinga ‘Yunu sika ombá.’ niku aku-siku nokuku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita-ni yunundu nimba mele: “Auliele, ung-eku toku niku sikenu akili oliu ⸤nunga lumbili anduli yimandu mindi⸥ niku sikenu mola yambu wemandu pali niku sikenuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Auli ⸤Yesos-ni⸥ pundu topa kene nimba mele: “Kongun tinjili kendemande-yambu nae-ni kongun tepa konjunjulimú kene kanupaliinga yunga yi-auliele-ni ‘Kongun siliuma sumbi-sipa telemáliinga yunu kongun simbu kene tepa konjumbaliinga alsupu numanu liipu mundupu naa molumbu.’ nilimúye? Kendemande-yambu te aku-sipa mele tepa konjupa molemále kanupaliinga yunga yi-auliele-ni yunu makó topa kene yunundu nimba mele: “Nu-ni kongun tinjili kendemande-yambuma pali nokunjuku eninga keri-langi nungíma ena makó toliu-na enini nangi moke teku sikunu, nokunjuku mului.” nimba ⸤yunu tenga-lupa pulimú⸥. ");
INSERT INTO mux_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Penga yi-auliele-ni kongun sirimele kongun tinjili kendemande-yambu kanili-ni mimi-sipa tenjipa we mulupili auliele kelepa um lem kendemande-yambale yunu numanu sipili. ");
INSERT INTO mux_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na-ni enindu aima sika nimbu siker: “Yi-auli kanili-ni kendemande-yi kanilindu “Nanga méle nosiliuma pali nu-ni nukunjui.” nimbá.” niker. ");
INSERT INTO mux_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Akiliinga-pe ⸤yi-auliele-ni kendemande-yambu kanilindu nimba mele: “Nanga kendemande-yambuma pali nukunjui.” nimba tenga-lupa pulimú kene⸥ kendemande-yambu kanili-ni “Nanga auliele wela naa ombá.” nimba piliipa kene yunu-ni nokonjilimú kendemande-yambuma kimbulú-ni topa, keri-langi nomba no-tonduluma nomba kelep topa kene, aku-sipa tepa kis-sipa mulúm lem ");
INSERT INTO mux_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","walse kendemande-yambu kanili ‘Yunga yi-auliele ombá.’ nimba naa piliipa ⸤kongun sirim mele naa tepa⸥ walu-sipa tepa kis-sipa molumba kene ombá. Omba ⸤yambu kanili tepa molumba mele kanupaliinga⸥ yunu aima kimbulú-ni topa konjupa kene, yunga ungele liiku su siku kongunale teku kis silimele yambuma ⸤kolea-kis⸥ molemelena ‘Pupili.’ nimba liipa mundumba. ");
INSERT INTO mux_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Kongun tili yambu te yunga auliele-ni “I-sikunu i-sikunu ti.” nimbá ungele sumbi-sipa piliipaliinga ungele karaye temba, mola ‘Nikem mele naa tembu.’ nimba piliipa aku-sipa piliipa liipa naa temba yambu kanili yunga auliele-ni penga yunu ‘Mindili aima lakupa nupili.’ nimba wale aima pulele tomba. ");
INSERT INTO mux_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Akiliinga-pe “Ti.” nimbá mele mimi-sipa naa piliipaliinga walu-sipa tepa kis-simba yambale yunga auliele-ni ‘Mindili layesele mele nupili.’ nimbaliinga laye-sele mele tomba. Yambu méle pulele siring liipa nusurum yambale “Pundu toku méle pulele si.” ningí. Yambu “Méle pulele nokuku mului.” niring yambale “Kelku méle pulele si.” ningí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“⸤Na lumbili andúlima,⸥ na ya ma-koleana tepi mundumbu urundu. Tepi akili isili-ui lkisipa nolkanje kapula. Na numanu silka. ");
INSERT INTO mux_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","“Na no liimbu ulu akili na-kene ola ombá. Ulu akili ui wendu naa okum akiliinga nanga numanukundu buni tipili moliu.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“‘Ya mana-yambuma ele naa teku tiluna kapula-kapula molangi.’ nimbu urundu niku pillikimiliye? Aku-sipa mólu. ‘Yambuma numanu lupa-lupa pípili anju-yandu ele-tu mele molangi.’ nimbuliinga urundu. ");
INSERT INTO mux_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ekupu kepe penga kepe lku tiluna pelemelé yambumanga ⸤mare-ni nanga ungele piliiku mulungí kene mare-ni nanga ungele liiku su siku molkuliinga,⸥ eni-enini elenale teku yambu angere te-guli lku tiluna pengí kene, yupuku enini mulungí, tale elsele mulunglí, lupa-lupa mulungí. ");
INSERT INTO mux_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","lápale-ni málu-kene ele-tu molomba, málale-ni lapa-kene ele-tu molomba, tiluna kapula naa mulunglí. Anumele-ni limin-kene ele-tu molomba, liminele-ni anum-kene ele-tu molomba, tiluna kapula naa mulunglí. Bamele-ni yunga málunga min-kene ele-tu molomba, málunga mínele-ni bamu-kene ele-tu molomba, tiluna kapula naa mulunglí. ⸤Yambu kanuma kapula naa mulungí.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Aku-sipa nimba kene Yesos-ni liiku máku toku muluring yambumandu nimba mele: “Eni kolea kolupa kene kupa kululi andolemú kanukuliinga “Lo ombá lem.” nilimele kene lo sika olemú. ");
INSERT INTO mux_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Penga alsupa sumbulsuli popuremi auli te merekundu winju-sipa topa, kombukantupu angiliimú-na kanuku kene “Ena temba lem.” niku piliilimili kene ena sika telemú. ");
INSERT INTO mux_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“⸤Naa piliikumulu.” nilimele akiliinga-pe sika piliilimili⸥ yambu gólu toku topele-mapele túlima! Eni mulále kene ya male kene kanukuliinga ‘kolea i-sipa i-sipa mele temba.’ niku kanolemele akiliinga-pe ekupu ⸤na mana-mania urundu kene⸥ ulu wendu olemúma kanuku molkuliinga ulu kanumanga ulu-pulele naa piliilimili. Akili nambimuna ⸤liipa ora silimú mele⸥ naa kanuku naa piliilimiliye?” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Eni nambimuna uluma piliiku apuruku ulu-kaíma piliiku naa telemeleye? ");
INSERT INTO mux_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nu kot tenjimba temba yambale ‘Kapula-kapula molambili ulu te teambu.’ niku kene wela ti. Aku-sikunu naa tinu lem nu kot tenjimba yambale-ni nunga kot piliimba yili molumbana memba pupa simbanje? Penga kot piliimba yili-ni nu ka-lku nukuli yili liipa simba, yunu-ni nu ka-lkuna liipa mundumba. ");
INSERT INTO mux_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na-ni nundu aima sika nimbu siker: “Nu ka-lkuna wendu uníndu pundu aima pali tokunu kene mindi wendu uni. We kapula wendu naa uní.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kanu-kene Yesos-ni ung-mani sirimuna muluring yambu mare-ni yunundu temani toku siku kene niku mele: “Kolea Gallalli distrik yambu mare-ni Pulu Yili popu toku mélema kalku molangi ⸤Rom-gapman yi-auli⸥ Paillet-ni enini topa kunjurum.” niku temani turing. ");
INSERT INTO mux_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Temani akili turing kene piliipaliinga Yesos-ni eninindu nimba mele: “Kolea Gallalli yambu kanuma aku-siku mindili nuring kilia piliikuliinga ‘Gallalli-yambu muluring wema-ni ulu-pulu-kis tiring akili mania-kilia, mindili nuring yambu kanuma ulu-pulu-kis tiring akili aima ola-kilia.’ niku piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Aima sika na-ni enindu “Aku-sipa mólu.” niker. Ya molkumele yambuma, eni ulu-pulu-kis telemelema liiku bulu siku munduku kelku numanu topele naa túngi lem eni aku-siku toku kunjingíko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Penga alsupa Yesos-ni temani te topa kene nimba mele: “Kolea-auli Jerusallem sukundu kolea-kelú Silloam ku-ni takuli lku auli ola-kilia te topa kalalu sipa topa mania mundupaliinga yambu supunga tale topa kunjurum kuluring. Yambu kanuma ‘Kolea-auli Jerusallem yambu-lupa muluringma-ni pali ulu-pulu-kis tiring akili mania-kilia, kuluring yambuma-ni ulu-pulu-kis tiring akili aima ola-kilia.’ niku piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aima sika na-ni enindu ‘Aku-sipa mólu.’ niker. “Ya molkumele yambuma, eni ulu-pulu-kis telemelema liiku bulu siku munduku kelku numanu topele naa túngi lem eni aku-siku kulungíko.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Aku-sipa nimbaliinga alsupa ung-eku te topa kene eninindu nimba mele: “Yi te-ni unji-pik te yunga unji-waen puniena bo lirim. Penga ‘Unji-pikele mong tomba.’ nimba omba kanurum kene unji-mong te naa turum. ");
INSERT INTO mux_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Unji-pikele mong te naa turum kilia yunga unji-waen punie tápu tirim yi kanilindu nimba mele: “Piliiyo. Punie tale yupuku pali unji-pik angiliimú ilinga ombu kanurundu akiliinga-pe unji-pik mong tilu kepe aima naa turum akiliinga yunu-ni ma-kopungele we nolemú akiliinga peki tokunu wendu mundui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Punie pulu yili-ni aku-sipa nirim kene punie tápu tirim yili-ni yunundu pundu topa kene nimba mele: “Auliele, punie tilu ili mindi we angiliipili. ‘Unjele akopa mong tupili.’ nimbu unji-puluna era tepu, ma mundupu, kung-le liipu mundupu, teambu. ");
INSERT INTO mux_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Penga nekendu punieliinga mong tum lem kapula. Naa tum lem kamu peki tani.” nirim.” ⸤nimba Yesos-ni⸥ aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Walse, ⸤kóru muluring⸥ ena-Sambat tenga Juda-yambuma liiku máku toku Pulu Yili-nga ungele piliiring lku tenga Yesos lkundu pupa kene yambuma ung-mani sipa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Akuna ambu te mulurumele, yunu bulele puka turum-na ola angiliipa sunu sipa andumba piliipa sundurum. Yunu aku-sipa mindi mulupili punie supunga tale omba purum. ");
INSERT INTO mux_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesos-ni ambu kanili kanupaliinga yunundu “Ui.” nimba kene nimba mele: “Ambale, nunga kurale pora nipili.” nimbaliinga ");
INSERT INTO mux_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ambale kíli-ni ambulurum kene yunu lkisipa sumbi-sipa ola angiliipa kene Pulu Yili kape nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Akiliinga-pe lku kanili nukurum yili yunu-ni Yesos ⸤kóru mululi⸥ ena-Sambateliinga yambu tepa kaí tirim-na kanupa kis piliipa kene akuna liiku máku turing yambumandu nimba mele: “Kongun-ena angere tale-guli lelemúmanga ‘Kuru tomba yambuma kaí lingíndu.’ ungí lem kapula. ⸤Kóru mululi⸥ Sambat enaliinga kapula mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yili-ni aku-sipa nirim kene Yesos-ni nimba mele: “Eni topele-mapele tuli yima, taki-taki ⸤kóru mululi⸥ ena-Sambat ola olemú kene eni pali lupa-lupa eninga kung-kao mola kung-dongki langi nomba molemúna muki leku no olemú kolea tenga ‘No nupili.’ niku meku pulimelé kanili. ");
INSERT INTO mux_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Eni eninga kungma Sambat enaliinga kapula muki leku nokolemele akiliinga ambu ili Sambat enaliinga kapula liipu tapunjukurko. Kungma mania-kilia mele, yambuma ola-kilia mele kanili. Akiliinga ambu ili, yunu Eprayam-ni kalupa liirim ambale, ⸤kurumanga nuim⸥ Seten-ni yunu punie ten-et ka mele sirim ambale Sambat enaliinga muki lepu nokukurale tepu kis-sikerye?” nimba walsurum. ");
INSERT INTO mux_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yunu-ni aku-sipa nirim kene ung kanili-ni yunu tirim mele kanuku kis piliiring yima pipili kuluring akiliinga-pe we-yambuma-ni yunu ulu-tondulu kaíma tirim kanukuliinga numanu auli-teku siring. ");
INSERT INTO mux_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kanu-kene Yesos-ni ⸤yambumandu⸥ alsupa nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú, akili nambulka mele kanu-siliele lelemúye? ‘Pulu Yili yi nuim kingele molupa yambuma nokulemú akili piliangi.’ nimbu akili nambi-sipu nimbu sambuye? ");
INSERT INTO mux_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akili i-sipa mele: Yi te-ni unji-mastet bo te liipaliinga yunga puniena bo mundurum kene unji-bo kanili ola omba ai lepa unjele angiliirim kene unji akiliinga polamanga kerama oku piring. Pulu Yili yi nuim kingele molemú akili aku-sipa.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Aku-sipa nimba kene alsupa walsipaliinga nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokulemú akili piliingí nambi-sipu nimbu sambuye? ");
INSERT INTO mux_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Akili i-sipa mele: Ambu te-ni langi pllawa tepa auli mundulimú méle yis laye-kolte liipaliinga pllawa puleliinga mundurum kene pllawa pali akurum. Pulu Yili yi nuim kingele molemú mele aku-sipa.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aku-sipa nimbaliinga penga Yesos kolea-auli Jerusallem pulimú kupulanum-na pumba ombaliinga kolea-aulimanga kene kelúmanga kene, akumanga pali muluring yambuma ung-mani sirim. ");
INSERT INTO mux_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yambu kanumanga te-ni yunu walsipa kene nimba mele: “Auliele, mindili nomulú kupulanum molemuluna Pulu Yili-ni yambuma tepa liipa yu-kene molku kunjingí kupulanum-na liipa monjumba yambu koltale mindiye?” nimba walsurum. Piliipaliinga yunu-ni eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Lku keri-pulu aima kelú si nílina yambu pulele oku sukundu pungíndu piliiku sundungí. Akiliinga ‘Keri-pulu kanuna eni oku lkundu puku mulungéliinga mindili siku pangi.’ nimbuliinga niker. ");
INSERT INTO mux_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lku pulu yili-ni ola angiliipa kunale angnjimba kene eni pena molku kene kuna toku walsiku kene niku mele: “Auliele, oliu nu-kene wasie molamili wamili akiliinga oliunga kuna liinjui.” ningí kene yunu-ni eninindu nimba mele: “Eninga bima na naa piliipu eni kepe eninga koleama kepe na naa kanoliu.” nimbá. ");
INSERT INTO mux_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Yunu-ni aku-sipa nimbá kene enini yunundu niku mele: “Nu-kene wasie langi nurumulu. Oliunga koleamanga nu oku kene oliu ung-mani sirinu.” ningí. ");
INSERT INTO mux_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Akiliinga-pe yunu-ni eninindu nimba mele: “Eni niambu piliai. Eninga bima na naa piliiliu, eninga koleama na naa kanoliu. Eni ulu-pulu-kis teku molemele yambuma pali na moliuna anju pai.” nimbá. ");
INSERT INTO mux_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Akuna ulsukundu molku kene eni ⸤anda-kolepa⸥ Eprayam kene, Aisak kene, Jekop kene, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kanuma pali, enini Pulu Yili yi nuim kingele molupa nokumba koleana sukundu mulungí kanukuliinga eni-enini akuna ulsukundu mulungí kanukuliinga eni-enini arerembi kolku kola teku mini-wale mundungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","⸤Isrel-yambuma enini Pulu Yili yi nuim kingele molupa nokumba koleana sukundu enini mindi naa pungí akili ‘Piliangi.’ nimbaliinga⸥ yunu-ni alsupa nimba mele: “Ma-koleana pali yambu mare Pulu Yili yi nuim kingele molupa nokumba koleana sukundu puku Pulu Yili-kene wasie keri-langi nungí. ");
INSERT INTO mux_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Piliai. Aeleku olemele yambu mare Pulu Yili yi nuim kingele molupa nokumba koleana sukundu kumbi-leku pungí. Kumbi-leku uring yambu mare aeleku pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Walse, Yesos ui Jerusallem naa ombaliinga kolea tenga-lupa ung nimba mulurum kene Perisi-yi mare-ni oku yunundu niku mele: “⸤Yi nuim king⸥ Erot-ni ‘Nu topu konjumbu.’ nimba molemáliinga nu ya naa molkunu tenga-lupa takara toku pui.” niring. ");
INSERT INTO mux_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesos-ni eninindu nimba mele: “Na tomba tekem yili, yunu gólu topa numanu kis pili owa-takara poks mele akili molemúna ung ili puku niku si-pai.” nimba kene kelepa nimba mele: “Ekupu mele kepe opali talú mele kepe yambumanga numanuna pelemú kuruma topu makurupu, kuru tuli yambuma tepu kaí tepu, molupu kene laye-kolte penga mele na kongun tepu moliále pora simbu. ");
INSERT INTO mux_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Akiliinga-pe Jerusallem pumbale ekupu kepe opali talú kepe we-kongun telsiliipu pumbu. Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi te kolea-auli Jerusallem ulsukundu kapula naa kolumba akiliinga ⸤na Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipuliinga yambuma nimbu siliu yili moliu akiliinga⸥ na Jerusallem ulsukundu kapula naa kolumbu.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","⸤Aku-sipa nimbaliinga Yesos-ni Jerusallem muluring yambuma yunu kondu kolupa ung te nimba kene nimba mele:⸥ “O Jerusallem-⸤yambuma⸥, Jerusallem-⸤yambuma⸥, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yi kanuma toku konjuku, yunu-ni eni molemelena liipa mundulimú yi kanuma ku-ni toku konjuku telemele yambuma, kera-kulla anumele-ni yunga walúma liipa yunga puna mo topa nokulemú akili mele na-ni ena puleliinga eni aku-sipu nokulka akiliinga-pe eni “Mólu.” niring. ");
INSERT INTO mux_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Akiliinga piliayo. ⸤Ele-túma eni tungí ungí kene Pulu Yili-ni alsupa eni naa nokupa naa liipa tapunjupa tepa liimbaliinga⸥ ele-túma-ni oku sika toku munduku eninga koleale kene eninga lku-tembollale kene kamu toku kalungéliinga eni ku pingí. Na-ni eni ung te wasie nimbu siker: “Eni Jerusallem-yambuma, eni nandu “Pulu Yi Yawe-ni liipa mundurum-na okum yili bili ola molupa, molupa kunjupili.” ningí kene na alsuku kanungí. Ui mólu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","⸤Kóru muluring⸥ ena-Sambat tenga Perisi-yi auli tenga lkuna Yesos langi wasie nungéliinga Yesos purum. Omba mulurum kene wasie langi noku muluring yima-ni yunu nem-nemi niku kanuku muluring. ");
INSERT INTO mux_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yunga kumbi-kerina yi kangi akurum te mulurum. ");
INSERT INTO mux_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pulu Yili-nga ung-manimanga puluma piliiku kungnjuring yi kanuma kene, Perisi-yima kene, enini Yesos-ni walsipa kene nimba mele: “⸤Kóru mululi⸥ ena-Sambat kene kuru tuli yambu te teku kaí telkemelanje kapula mola móluye?” nirim. “Pulu Yili-nga ung-manimanga sukundu nambulka nimba molemúye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Akiliinga-pe yunundu ung te pundu toku naa nikuliinga we muluring. Kanu-kene yunu-ni yi kanili liipa tepa kaí tepa kene yunundu “Pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aku-sipa tepaliinga Yesos yunu-ni wasie muluring yambumandu nimba mele: “Eni molkumele yambumanga yi tenga kangale mola kung-kao te Sambat-ena tenga no-numú tenga no wangúmu lem yi kanili-ni yunga kangale mola kung-kaoele enaliinga ola naa liimbaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aku-sipa nirim piliikuliinga ⸤‘Oliu-ni “Sambat-ena tenga kangale mola kung-kao no-numúna wendu liimba akili kapula.” nímulu lem yunu-ni “Sambat-enale kene yili liipu tapunjukurele kapulako.” nimba.’ niku piliikuliinga⸥ ung te pundu toku ningí kupulanum te naa lirim. ");
INSERT INTO mux_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Perisi-yi aulieliinga lkuna langi nungíndu puring yambuma yi-aulimanga polu kumbikundu ‘oliu molomulú.’ niku numanu siku muluring kanupaliinga Yesos-ni enini ung-mani sipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Yi te-ni nu kene yambu mare kene wasie “Langi namili wai.” nimbá kene nu okunu kene yi-aulimanga polu kumbikundu tenga pukunu naa molui. Nu polu kanuna muluni kene penga yi-auli te yunga bi ola-kilia molumba yi te yunu kepe ‘Langi wasie namili ui.’ nimbá yi te ombá kene lku pulu yili-ni nundu nimba mele: “Yi-auli ili nu mollu polu akuna mulupili polale si.” nimbá kanu-kene nu pipili kolkunu kene polu te lupa, namba naa lili yambumanga polu tenga pukunu muluni. ");
INSERT INTO mux_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Akiliinga, yi te-ni nundu “Langi wasie namili ui.” nimbá kene yunga lkuna pukunu namba naa lili yambumanga polu tenga pukunu molui. Akuna muluni kene lku pulu yili-ni nu mulunina omba kene nundu nimba mele: “Ang, polu ilinga naa molkunu yi-aulimanga poluna okunu mului.” nimbá kene langi wasie noku mulungí yambuma-ni nu-kene temba akili kanukuliinga nu ‘Yi-auliele.’ niku kanungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Yambuma-ni enini bi paka tolemele yambuma ⸤Pulu Yili-ni⸥ bima topa mania mundumba, akiliinga-pe yambu enini bima toku mania mundulimele yambuma yunu-ni eninga bima paka tonjumba kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kanu-kene Yesos-ni lku pulu yi kanilindu nimba mele: “Nu yambumanga keri-langi kalunjukuliinga nunga pulu lelemú yambuma kene, nunga angenali kene, yi-kamakoma kene eninindu ‘Langi wasie namili wai.’ ni naa niani. ‘Enini walse alsuku pundu mele toku, nandu ‘Langi wasie namili ui.’ niangi.’ ni naa niani, mólu! ");
INSERT INTO mux_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nu yambumanga keri-langi kalunjukuliinga yambu-korupama kene, kimbu-ki lkenuwa tambulurum yambuma kene, kimbu kis lirim-na mimi-siku kupulanum naa anduring yambuma kene, mong kis lirim yambuma kene eninindu ‘Langi wasie namili wai.’ niani. ");
INSERT INTO mux_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Enini langi kanuma pundu aima kapula naa tungéliinga nu numanu sikunu molkunu kunjini. Walse numanu sumbi-nimba pípili molemele yambuma kolku lomburuku ola mulungí ena kaniliinga ya niker akili mele nu aku-siku tinéliinga méle kalomba liini.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Perisi-yilinga lkuna Yesos-kene wasie langi noku muluring yi te-ni Yesos-ndu nimba mele: “Pulu Yili yi nuim kingele molupa nokumba koleana langi nomulú yambuma “Numanu kaí pípili molku konjangi.” nilimú kupulanum-na molemulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Akiliinga-pe Pulu Yili-nga Isrel-yambuma Yesos yunga ungele naa piliiku liiku su siringeliinga mulú-koleana puku naa mulungí akili piliipaliinga yili-ni nirim ungele piliipa kene Yesos-ni ung te pundu topa kene ung-eku te topa kene nimba mele: “Yi te-ni ‘Yambu pulele kene wasie langi namili kalambu.’ nimbaliinga yambu pulelendu “‘Langi kalupu namili wai.’ nimbú kene wangi.” nimba, nimba mundurum. ");
INSERT INTO mux_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Langi nungí ena-mongale ola urum kene yunga kendemande-yili liipa mundupaliinga nimba mele: “Ui “Langi wasie namili wai.” nirindu yambuma “Ekupu ena-mongaliinga langi kalunjundu akiliinga namili wangi.” ni-pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Akiliinga-pe enini pali naa ungíndu lupa-lupa “Wan-wani lekem akiliinga naa omulú.” niring. Te-ni nimba mele: “Na ma kona te taropu topu liindele kanu-pumbaliinga na naa ombáliinga ninji.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Te-ni nimba mele: “Na-ni kongun tili kung-kao rurepunga tale taropu topu liinduma pupu kanu-pumbaliinga kapula naa ombú akiliinga ninji.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Te-ni nimba mele: “Ekupu mindi ambu liindeliinga na kapula naa ombú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","⸤Aku-siku niring kene piliipaliinga⸥ kendemande-yili kelepa yandu omba kene niring mele yunga yi-auliele nimba sirim. Kanu-kene lku pulu yili-ni arerembi kolupaliinga kendemande-yilindu nimba mele: “Nu wela lkisiku pukunu, kolea-auli ilinga kupulanum aulimanga kene kupulanum kelúmanga kene pukunu, yambu-korupama kene kimbu-ki lkenuwa tambululi yambuma kene, mong kis lili yambuma kene kimbu kis lelemú-na mimi-siku kupulanum naa andolemele yambuma kene, akuma liikunu mekunu ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kendemande-yili-ni aku-sipa tepaliinga kelepa omba nimba mele: “Auliele, ninu mele tindu akiliinga-pe langi nuli poluna kolea mare we lelemúko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kanu-kene auliele-ni yunga kendemande-yilindu nimba mele: “Aku tekem akiliinga nu alsukunu pukunu, kolea-aulina ulsukundu pukunu kupulanum aulimanga kepe kupulanum pakili-makilimanga pukunu, yambu kanuku liiníma pali mekunu wani. “Mólu.” ningí yambuma kepe karaye tekunu mekunu ui. Nanga lkuli si nipili akiliinga pulele wangi.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Aima mi ya kanui. Na aima sika eni nimbu siker: “Na-ni kumbi-lepu “Langi wasie namili wai.” nimbu, nimbu mundurundu yambumanga te kepe aima naa oku langi nungí. Aima mólu.” niker.” nirim.” nimba ⸤Yesos-ni aku-sipa ung-eku te turum.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yesos kupulanum-na omba purumna yambu pulele liiku máku toku yunu lumbili anduring kene yunu we angiliipa topele topa kanupaliinga eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yambu te-ni na lumbili ombándu na lakupa numanu naa munjum yambale na lumbili kapula naa ombá. Yunga lapa kene, anum kene, min kene, kangambulama kene, anginipilima kene, kimulupili kene, yu-ni yunu kepe, enini pali lakupa numanu monjupa, na mindi numanu naa monjupaliinga na lumbili kapula naa ombá. ");
INSERT INTO mux_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yambu te-ni ‘Yunu lumbili pumbú.’ nimba kene yambuma unji-perana peku mindili noku kolemele akili mele yunu-ni yunga unji-pera mele akili koma lemba⸤ndu ‘Na yunu lumbili pumbale mindili nundu lem kapulako; kulundu lem kapulako.’ naa nim lem⸥ na lumbili kapula naa ombáko. ");
INSERT INTO mux_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Eninga yi te-ni lku auli tondulu te takombandu yunu ui naa takupa kene lku kaniliinga numanu liipa mundupaliinga yunu nimba mele: ‘Lku takupu pora simbaliinga ku-moni kapula tembanje mola mólu tombanje?’ nimba piliipaliinga ‘Nanga ku-moni kapula nusundu lem kapula takumbu.’ nimba numanu kimbu-sipa naa molumbaye? ⸤Aku-sipa temba kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Yunu aku-sipa ui naa telkanje penga yunga lku kanili takombandu lku ponga mindi taropu topa liipa polupaliinga penga ku-moni mólu tomba kene kamu kapula naa takupa pelka. Akiliinga yambuma-ni yunga ung-taka tonjuku tae tenjilkemela. ");
INSERT INTO mux_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Enini tae tenjiku ung-taka toku niku mele: “Yi ili lku auli tondulu te takumba takurum akiliinga-pe yunga ku-moni mólu turum-na yunu kapula naa takupa pora sirim.” niku tae tenjilkemela. ");
INSERT INTO mux_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“⸤Te walsekerko.⸥ Eninga yi nuim king tenga talapele kene yi nuim king tenga-lupa talapele kene ele tinglí kene te tomba temba, te yunga koleana we molumba. Enini omba tomba yi nuim kingele yunu ele tili yi tuwendi-tausen memba ombá. Akiliinga-pe we molumba yi-nuimele yunga ele tili yi ten-tausen mindi mulungí. Koela tungí ungí kene we molumba yi-nuimele yunga yi kanuma walsipa piliipa kene nimba mele: “Oliu ele tili yi ten-tausen mindi molemuláliinga oliu oku tungí yambuma anju kapula tomulú mola móluye?” ni naa nimbáye? ⸤Aku-sipa manda lepa piliipa molumba kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kanu-kene yi nuim king kanili yunu-ni ‘Oliu-ni enini anju kapula naa tomulú.’ nimba pilíímu lem yunga yi mare liipaliinga, yi tuwendi-tausen memba ombá yi-nuimele kupulanum suluna ombáliinga “Pai.” nimba liipa mundupa kene nimba mele: “‘Ele naa tepu we táka-nimbu molamili akiliinga na-ni nambulka ulu te teambuye?’ niku walsiku pilii-pai.” nimbá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","⸤Ung-ekusele topa pora sipaliinga penga ung-ekuselenga yi tale-ni telkembela mele akiliinga ung-pulele enini nimba sipaliinga nimba mele:⸥ “⸤Yi kanusele-ni telkembela⸥ aku-sipa mele eninga yambu te yunu-ni ‘Na lumbili ombu.’ nimbaliinga yunga mélema pali kene, yunga yambuma kene, yunga ku-monima kene, yunga kangiele kene, méle akuma mindi numanu monjupa na lakupa numanu naa monjulemú yambale na lumbili kapula naa ombá.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","⸤Aku-sipa nimba kene kelepa nimba mele:⸥ “Api-kusa akili méle kaiéle akiliinga-pe yunu sungu naa temba kene ‘Yunu kelepa sungu tipili.’ niku ulu te kapula temulúye? ");
INSERT INTO mux_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Api-kusa sungu naa tili kanili nambulka temulúye? ‘Puniena liipu mundumulú kene langi kapula ola naa ombá; yunga kopungu te mólu.’ nimbu kanupu kene we topu mundupu kelemulú.” ⸤nimbaliinga⸥ “Yambu kum-peú lelemúma-ni ya niker mele akili piliai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ku-moni-takis liili yi kanuma kene ulu-pulu-kis tili yi wema kene enini pali Yesos-nga ungele piliingíndu yunu mulurumna nondupa uring. ");
INSERT INTO mux_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Perisi-yi kanuma kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene enini aku-siku tiring mele kanuku kene kon-konu nikuliinga niku mele: “Yi ili yunu tepa kis-sikem. Ulu-pulu-kis tili yambuma “Wasie molamili wai.” nimbaliinga, langi taki-taki enini kene wasie noku molemeleko.” niring. ");
INSERT INTO mux_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesos-ni enini aku-siku niring mele piliipaliinga ⸤ung-eku ima enini topa sirim.⸥ Ung-eku ili topaliinga nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Eninga yi te-ni kung-sipsip paip-paon monjulka kene te takara tolkanje yunu-ni sipsip po-paon ten kelepa nain wema kolea-wakana molangi mundupa kelepa pupa, takara tolka kung-sipsipele korulsiliipa naa pulkaye? ⸤Aima korulsiliipa pulka.⸥ ");
INSERT INTO mux_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Penga kanupa liipaliinga yunu-ni numanu sipa apu topa lkundu memba pulka. ");
INSERT INTO mux_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kanu-kene lkundu omba kene yili-ni yunga pulu lelemú yambuma kene yunga lku keri-kúpu yambuma walsipa kene nimba mele: “Nanga kung-sipsip takara tum kanili kanupu liindeliinga wasie numanu sipu molamili wai.” nilka.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","⸤Nimba kene ung-ekaliinga pulele nimba para sipa kene nimba mele:⸥ “Na-ni eni ung te nimbu siker: “Yambu numanu sumbi-nimba pípili molemele yambuma aku-siku molemeláliinga enini ulu-pulu-kisma munduku kelku numanu topele tungí kupulanum te naa lelemú kanili, yambu kanuma mulú-koleana angkellama-ni numanu we silimele. Akiliinga-pe sipsip nukuli yili-ni yunga sipsip takara tolemále kanupa liipaliinga aima lakupa numanu silka mele aku-sipa ulu-pulu-kis tili yambu te yunga ulu-pulu-kis telemúma piliipa kis piliipa mundupa kelepa numanu topele tombá kene angkellama-ni aima lakuku numanu singí.” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","⸤Aku-sipa nimbaliinga kelepa ung-eku te kene wasie topaliinga nimba mele:⸥ “Te ya walsekerko: Ambu te ku-moni suruli mele engkaki-rurepunga tale nosupa kene penga ku-suruli mele kanumanga mong tilu mania pulkanje yunu tepi-llam kandupa lku kulsupana memba naa korulkaye? ⸤Aima sika korulkale.⸥ ");
INSERT INTO mux_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kanu-kene ku-moni kanili kanupa liipaliinga yunga pulu lelemú yambuma kene yunga lku keri-kúpu yambuma walsipa kene nimba mele: “Nanga ku-moni suruli mania pumu kanili kanupu liindeliinga wasie numanu sipu molamili wai.” nilka. ");
INSERT INTO mux_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Na-ni eni nimbu siker: “Ambu kanili numanu silka akili mele aku-sipa ulu-pulu-kis tili yambu te yunga ulu-pulu-kis telemúma piliipa kis piliipa mundupa kelepa numanu topele tombá kene Pulu Yili-nga angkellama-ni numanu singí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","⸤Aku-sipa nimbaliinga⸥ Yesos-ni kelepa ⸤ung-eku yupuku-sipale wasie topa yi-aulima mani sipa kene⸥ nimba mele: “Yi te, yunga kang tale muluringli. ");
INSERT INTO mux_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Walse kang-akeleale-ni lapandu nimba mele: “Tata, nu kulunéliinga nunga moya-mélema isili-ui moke tekunu na sini mele si.” nirim kene yi kanili-ni yunga nusurum mélema moke tepaliinga yunga kangsele sirim liiringli. ");
INSERT INTO mux_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Méle kanuma elsele moke tepa sirim kene kang-akeleale kongun talse mindi molupa kene, penga méle sirim-ma pali liipa memba kupulanum sulu tenga purum. Kupulanum suluna pupa kene kolea tenga pupa molupa kene yunu langi kaíma mindi nomba, mulumbale kaíma mindi ku-moni auli-tepa pulimúma taropu topa liipa panjipaliinga, no-tonduluma taropu topa liipa nomba, ambu wapera tombandu ku-moni sipa, aku-sipa telsiliipa purum kene yunga ku-moni mélema pali pora nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yunga mélema kene ku-monima kene pora nirim kene yunu aima korupa purum. Kanu-kene yunu mulurum koleana engle auli te lirim kanu-kene yunu mélema pali mólu turum kene yunu aima engle-ni kulurum. ");
INSERT INTO mux_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yu engle turum kilia kolea pulu yi te mulurumna pupaliinga “Ku-moni kongun te lim lem teambu si.” nimba mawa tirim kanu-kene yunu-ni nimba mele: “Kapula, nanga kung tápu tenjikunu ‘Langi nangi.’ nikunu liiku si.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","⸤Engle-ni aima kolupaliinga⸥ ga-kilu kepe kanapa-buluma kepe kung sirim-ma ‘Nolka.’ nimba piliipa mulurum akiliinga-pe te naa siring. ");
INSERT INTO mux_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanu-kene penga yunu numanu liipa mundupa piliipaliinga yununu nimba mele: ‘Tatanga kongun tenjilimele yambuma langi pulele noku teku kis-silimele andiliinga-pe na ya engle-ni kolupu kene kamu kolumbu teker. ");
INSERT INTO mux_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akiliinga na anju pupu Tata molemúna pupu kene yunundu nimbu mele: “Tata, nu kene Mulú-Koleana Molemú Yili kene na-ni tepu kis-sirindu. ");
INSERT INTO mux_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na kang kisele akiliinga nunga málale molumbále kapula naa temba akiliinga nunga kongun-yi te molambu.” nimbú.’ nimba piliirim. ");
INSERT INTO mux_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aku-sipa nimba piliipaliinga yunga mulurum koleale mundupa kelepa, lapa mulurumna ⸤lku koleandu⸥ pumba purum. Yunu lku koleandu koela pumba purum kene yunga lapa-ni yunu sulu tepa urumele kanupaliinga yunu kondu kolupa lkisipa pupa yunu kanglurum. ");
INSERT INTO mux_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kanu-kene kangale-ni lapandu nimba mele: “Tata, nu-kene Mulú-Koleana Molemú Yili-kene na-ni tepu kis-sirindu. Na kang kis akiliinga nunga málale molumbále kapula naa temba akiliinga nunga kongun yi te molambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Aku-sipa nimba mulurum kene lapa-ni yunga kongun tinjiring kendemande-yi kanumandu nimba mele: “Wela puku nanga mulumbale kaiéle liiku meku oku yunu pakunjuku, ki-ung te liiku yunga kína monjunjuku, kimbu-su liiku yunga kimbuna monjunjai. ");
INSERT INTO mux_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Aku-siku teku kene kung-kao walú auliele toku kalunjuku, molumbulúna meku wai.” nirim. “Nanga kangale yunu kórunga-ui purum, ‘Yunu kulurum⸤-nje.’ nimbu piliirindu⸥ akiliinga-pe ekupu yunu alsupa kona molupa okum. Yunu ui pupaliinga tepa nema liirim akiliinga-pe ekupu alsupa okum kanupu líímulu kilia numanu sipu kung kao nombu molamili.” nirim kene enini aku-siku numanu siku kung noku muluring. ");
INSERT INTO mux_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Akiliinga-pe yunga kang-komale eninga puniena kongun tepa molupa kene penga ipinjali lkundu ombá urum kene enini numanu siku musik ung siku denis teku muluring ungele piliipaliinga ");
INSERT INTO mux_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","yunu-ni kongun kendemande-yi te-ndu “Ung te niambu ui.” nimba kene walsipa nimba mele: “Ulu tekemele ili nambimuna tekemeleye?” nimba walsurum. ");
INSERT INTO mux_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kongun kendemande-yi kanili-ni yunundu pundu topa kene nimba mele: “Angena um-na lanie-ni kanupa yunu kapula mele molupa um-na kanupa kene numanu sipa “Kung-kao walú auliele namili.” nimba topa kalum.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Aku-sipa nirim piliipaliinga kang-komale yunu arerembi kolupaliinga “Na lkuna lkundu aima naa pumbu!” nirim. Aku-sipa nirim piliipaliinga lapa-ni wendu omba yunundu nimba mele: “Oliu-kene wasie numanu sipu molamili ui.” nimba mawa tirim kene ");
INSERT INTO mux_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","lapandu pundu topa kene nimba mele: “Piliiyo! Na taki-taki, punie pulele, nunga kongunale tenjipu molupu kene nu-ni nillu ungma taki-taki piliipu liipu teng panjipu, walse kepe nunga ungele karaye naa tepu moliu akiliinga-pe nu-ni nandu walse kepe kung-memi walú te ‘Kánguma-kene wasie numanu siku noku molai.’ nikunu naa sillu. ");
INSERT INTO mux_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akiliinga-pe ekupu nunga kang te omba, yunu-ni ambu-waperama nunga ku-monima sipa tepa pora sirim, kang kanili um kene nu numanu sikunu ‘Kung-kao walú auliele namili.’ nikunu túnu lam.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Lapa-ni yunundu pundu topa kene nimba mele: “Kangale, nu kene na kene wasie taki-taki molembulu kene nanga mélema pali olsunga. ");
INSERT INTO mux_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Akiliinga-pe angena ui kulurum ⸤mele tirim⸥ kanili ekupu alsupa kona molupa um. Yunu ui pupa purum ⸤mele tirim⸥, ekupu kelepa um kanupu líímulu akiliinga oliu numanu sipu musik ung sipu langi nombu molkumulu akili kapula tekemulu.” nirim.” ⸤nimba Yesos-ni⸥ aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","⸤Aku-sipa nimbaliinga⸥ Yesos-ni yunga lumbili anduli yimandu nimba mele: “Walse yi-kamako te mulurum kene yunga méle nusurum-manga nukunjuli yi te mulurumko. Walse yambu mare-ni yi-kamakale mulurumna oku, yunga mélema nukunjuli yili-ni tirim akili mele okuliinga yunundu niku mele: “Nunga méle nosullumanga nukunjuli yili-ni nu tepa kis-sipa, nunga mélema ‘We mania pupili.’ nimba yunu akuma nokupa naa konjulimú.” niring. ");
INSERT INTO mux_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Aku-siku niring piliipaliinga yi-kamakale-ni yi kanilindu ‘Ui.’ nimbaliinga yunundu ung-mura sipa nimba mele: “Ung ili nambulka ung te nikimeleye? Nu-ni nanga mélema tekunu kis-sillu mele níngi-na piliipuliinga nu-ni nanga mélema tellu mele bukna tokunu, yandu sikuliinga penga pani. Nu nanga mélema alsukunu kapula naa nukuni. Nu makurumbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Méle kanuma nukunjuli yili yunu nimba mele: “Apa! Ekupu nambulka tembuye? Nanga auliele-ni nanga kongun teliále wendu liipa na topa makurumba tekemaliinga na nambulka tembuye? Na apulu-kongun tembaliinga tondulale naa pelemáliinga kongun akili kapula naa tembu. Yambuma keri-langi mawa tembaliinga pipili tekem. ");
INSERT INTO mux_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Akiliinga na tembu mele ekupu piliiker. ⸤Nanga auliele-ni pundu angnjirim yambuma liipu tapunjupuliinga eninindu ‘Pundu ekendu mindi tai, ekendu mania pupili.’ nimbú kene⸥ penga na topa makurumba kene yambu kanuma-ni na numanu siku liiku tapunjukuliinga nandu “Wasie piamili ui.” ningí.” nimbaliinga, ");
INSERT INTO mux_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yunga auliele-ni pundu angnjirim yambuma ‘Lupa-lupa wangi.’ nimbaliinga kumbi-lepa urum yi kanilindu nimba mele: “Nanga auliele-ni nu-kene méle nambi-sili pundu angnjirimuye?” nimba walsurum kene ");
INSERT INTO mux_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","yunu-ni pundu topa kene nimba mele: “Unji-ollip mong wel-mingi paip-paon pundu angnjirim.” nirim kene yi-kamakaliinga mélema nukunjuli yili-ni yunundu alsupa nimba mele: “Pundu angnjili bukele ya siker; ya mania molku, paip-paon toku panjiring buk-gomale ambolku ola toku munduku kelku kene alko toku buk-gomú kona tenga kopungu-wel mingi paon tale ten lkisiku tokunu munjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yunga bulkundu urum yi kanilindu nimba mele: “Nanga auliele-ni nu-kene méle nambi-sili pundu angnjirimuye?” nimba walsurum kene yunu-ni pundu topa kene nimba mele: “Rais-wit wale paip-paon pundu angnjirim.” nirim kene mélema nukunjuli yili-ni yunundu alsupa nimba mele: “Pundu angnjili bukele ya siker; ya mania molku, rais-wit wale paip-paon toku munjuring buk-gomale ambolku ola toku munduku kelku kene alko toku buk-gomú kona tenga rais-wit wale po-paon lkisiku tokunu munjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yunu aku-sipa tirimele piliipaliinga yi-kamako auliele-ni tepa kis-sili yi kanili yunu kape nirim. Yunga mélema sika wa-mele liipaliinga tepa kis-sirim akiliinga-pe yunga piliipa kungnjuliele aima lakupa pirim piliipaliinga yunu kape nirim. “Ya mana molku, Pulu Yili numanu naa monjulemele yambuma, eninga piliipa kungnjuliele aima ola-kilia; pa tílina molku Pulu Yili numanu monjulemele yambuma eninga piliipa kungnjuliele mania-kilia. We-yambuma-ni yambu te kene ku-moni kongun tinjingíndu, mola ulu te tinjingíndu kupulanumele sumbi-siku kanuku akisiku konjulemele; pa tílina molemele yambuma aku-sipa tondulale mania-kilia pelemú. We-yambuma aku-siku molemeláliinga ⸤yi-auliele-ni tepa kis-sili yili aku-sipa kape nirim.⸥” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Na-ni enindu nimbu sambu: “Ekupu ya mana-molkuliinga mana-mélema liiku ‘Yambuma nunga anginpili mele molangi.’ niku nunga méle nosullumanga enini liiku tapunjui. Penga mélema pora nimbá kene nu kolea-kaí kam-kamu lepa mindi púlina puni kene akuna mulungí yambuma-ni nundu “Ya kamu wasie molamili.” ningí.” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Yambu te-ni yambu tenga-lupa méle koltale nokupa konjunjulimú kene kanupaliinga ‘Méle pulele simbu kene nokupa konjunjumba lem.’ nilimú. Yambu te-ni yambu tenga méle koltale nokupa kis-sinjilimú kene kanupaliinga “Méle pulele simbu kene nokupa kis-sinjimba lem.” nilimú. ");
INSERT INTO mux_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nu-ni ya mana méle nosulimelema nokuku naa kunjunu lem nu aima sika méle kaí lupa-lupa Pulu Yili-ni silimúma ‘Nokunjui.’ kapula naa nimbá. ⸤Ya mana nosulimele mélema mania-kilia, Pulu Yili-ni silimú méle kaí lupa-lupama ola-kilia kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nu-ni ya mana mania méle nosulluma aima sika nunga mólu, méle kanuma Pulu Yili-nga. Akiliinga nu-ni yunga mélema nokuku naa kunjunjunu lem penga yunu-ni ‘nunga nosani.’ nimba simbandu molemú mélema kapula simbaye? ");
INSERT INTO mux_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Kendemande-yambu tiluele-ni yi-auli tálenga kongunsele liipa tere lepa kapula naa tenjimba. Yi-auli te numanu kis panjipa, te numanu monjumba. Mola aku naa tímu lem yi-auli tenga ung nimbáma aima numanu sipa piliipa liipa kongun nimbáma tondulu mundupa tenjipa, te numanu kis panjipa yunga ung nimbáma liipa su sipa naa temba. Yambuma-ni Pulu Yili-nga kongunale kene Ku-Monelenga kongunale kene liiku tere leku kapula naa tinjingí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesos-ni aku-sipa nirim piliikuliinga Perisi-yima enini ku-moni kepe mélema kepe numanu aima pulele munjuringeliinga yunu-ni ung nirimele ung-taka tonjuku tae tiring kene ");
INSERT INTO mux_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesos-ni eninindu nimba mele: “Eni-enini i-siku niku mele: ‘We-yambuma-ni oliu Perisi-yima numanu sumbi-sipa pepa, yi kaíma molemulu niku kanuku niangi.’ niku molemeláliinga-pe eninga numanuna aima sika pelemú mele Pulu Yili-ni kanupa molemú. Mana-yambuma-ni kanukuliinga ‘Méle aima kaí, méle aima ola-kilia.’ nilimele mélema Pulu Yili-ni kanupa kis piliilimú.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“⸤No-Liinjili⸥ Jon ui ma-koleana naa omba mulupili Pulu Yili-ni yambuma ‘Teai.’ nirim akili mele ⸤Pulu Yili-nga ung-manima yandu nimba sirim yi⸥ Moses-ni turum bukma kene, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni buk turingima kene, buk kanumanga mulurum, yandupa-yandupa mani siku yambuma niku siring. Akiliinga-pe, ekupu, Pulu Yili-ni omba yi nuim kingele molupa yambuma nokupa konjumba temani-kaiéle topu silsiliipu andolemulu. Pulu Yili yi nuim kingele molupa yambuma nokumba yambu-talapena sukundu puku mulungéliinga yambuma aima tondulu munduku aima mindilisele siku teku pulimelé. ");
INSERT INTO mux_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mulú-ma-sele walse kapula pora nimbá akiliinga-pe Pulu Yili-nga ung-manima Moses-ni yandu nimba sipa bukna turum molemú bimanga tilu aima laye-kolte kepe mania kapula naa pumba. Pulu Yili-nga ung-manima pali pepa mindi pumba.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Yi te-ni yunga ui liilimú ambale makurupa “Kamu pui.” nimbaliinga alsupa ambu te liilimú kene yi akili-ni waperanale telemú. “Pui.” nimba topa makorolemú ambale penga yi te-ni yunu liilimú kene yi kanili kepe waperanale telemúko.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","⸤Aku-sipa nimbaliinga Yesos-ni alsupa temani te topaliinga nimba mele:⸥ “Yi-kamako te mulurum. Yunga wale-pakuli aima kaí ku-moni aima pulele púlima pakupa, taki-taki yunga lkuna langi kaíma mindi nomba pirim. ");
INSERT INTO mux_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yi-korupa te mulurumko, kaniliinga bili LLasares. Yunu enamanga taki-taki ‘Yi-kamakale-ni yunu kondu kolupa ku-moni te mola keri-langi te simbanje.’ niku yunga lku keri-puluna ‘Mulupili.’ niku meku oku munjuring. Yunga kangima pali irili tirim. ");
INSERT INTO mux_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Irili kanuma owama-ni oku peni-mani le-pui-upui tiring. Yunu ‘Yi-kamakaliinga langi-pundu mana mania pumbama apurupu liipu nombú.’ nimba piliipa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Penga walse yi-korupale kulurum. Kulurum kanu-kene angkellama-ni yunga minéle liiku, ⸤Juda-yambumanga kumbi-lepa anda-kolepa⸥ Eprayam mulurumna meku puring. Yi-kamakale kulurumko. Yambuma-ni yunu ónu tiring. ");
INSERT INTO mux_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kanu-kene yunu tepi-koleana mindili nomba molupa kene, yunu-ni yunga mongsele-ni olandu-sipa sulu tenjipa Eprayam kanupa, LLasares kene wasie muluringli kanurum. ");
INSERT INTO mux_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanupa kene ung te tondulu mundupa nimba mele: “Totu Eprayam, na kondu kolkunuliinga ‘LLasares-ni nona yunga ki-sundele mindi mania mundupaliinga ‘Nanga keri-anembelale koma linjipili.’ nimba tinjipili.’ nikunu yunu yandu liiku mundui. Na tepi ilinga aima mindili nombu moliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akiliinga-pe Eprayam-ni yunundu nimba mele: “Totu, ui muluringli mele pília! Else ma-koleana muluringli kene nu méle kaí lupa-lupama nosuku kapula mulurunu; LLasares yunga méle kísima nosupa, molupa kis-sirim kanili. Pe ekupu yunu numanu kaí pípili molemú, nu mindili noku mollu. ");
INSERT INTO mux_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mola na-ni “O.” nilkanje yunu andi akuna kapula naa-ko olka. Oliu kene eni kene ai-suku-singina ⸤Pulu Yili-ni⸥ mai-angi auliele tirim pelemú akili. Pe ekupu ya molemulu yambuma ‘Eni molemelena anju pamili.’ ningéle kapula naa pungí; eninga yambuma ‘Yandu wamili.’ ningéle yandu kapula naa ungíko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kanu-kene yi-kamakale-ni nimba mele: “Aku-sipa lam akiliinga, Totu, yunu nanga pulu-koleana mania pupili liikunu mundani nimbu mawa teker. ");
INSERT INTO mux_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanga anginipili angere te-guli molemele kanili. Kolea mindili nuli kolea ilinga enini kepe naa wangi akiliinga yunu-ni enini lip-lipi ili topa ung nimba sipa kunjupili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Akiliinga-pe Eprayam-ni yunundu nimba mele: “Moses-ni bukna turum ungma kene Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni buk turing bukma wasie nosuku molemele kanili. Enini buk kanuma molemú ungma kanuku piliangi.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kanu-kene yi-kamakale-ni nimba mele: “Totu Eprayam, akili kapula mólu. Kululi yambu te lomburupa ola molupa enini molemelena pupaliinga nimba símu lem ulu-pulu-kis telemelema kanuku kis piliiku munduku kelku numanu topele tungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eprayam-ni yunundu nimba mele: “Moses-nga ungma kene Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yimanga ungma kene ⸤bukmanga turing molemú akuma⸥ pilíí naa pilííngi lem kululi yambu te lomburupa ola molupa pupaliinga nim lem yunga ungele naa-ko piliingí.” nirim.” nimba Yesos-ni temani te aku-sipa turum. ");
INSERT INTO mux_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesos-ni yu lumbili anduli yimandu nimba mele: “⸤Na⸥ ‘Sika’ niku tondulu munduku piliilimili yambuma kelku liiku bulu siku munduku kilingí uluma sika wendu ombá akiliinga-pe yambu te-ni nanga yambu te ung-kundi tombaliinga nanga yambu kanili na liipa bulu sipa anju pumu lem kundi tomba yambu kanili mindili nomba aima molupa kis-simba. ");
INSERT INTO mux_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nanga yambuma aku-sipa ung-kundi tomba yambale yunu ku- mulú aima auli te moku toku numina lenjiku ‘Yunu kamu kulúpili.’ niku paka toku no-numúna mania mundulkemelanje aima kapula. Aku-siku toku mundulkemela kene yunu kolupaliinga penga yunu Pulu Yili-nga kangambula te-ndu ‘Ulu-kísima tipili.’ nimba ung-kundi kapula naa tolka. Akiliinga-pe yunu aku-siku no-numúna toku naa mundulkemela kene yunu yambuma ung-kundi tolkaliinga Pulu Yili-ni yunu ‘Mong lakupa liikim.’ nimba “Mindili aima nupili.” nilka akiliinga enini yunu no-numúna kapula paka toku mundulkemela. ");
INSERT INTO mux_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Nanga yambuma, eni-enini telemele akili mele kanuku piliiku kongnjai. “Angena te-ni nu-kene ulu te tepa kis-simba kene yunu molumbana pukunu nikunu mele: “Ang, nu-ni na tekunu kis-sinu.” ni. Aku-siku niní kene yunu-ni piliipaliinga nimba mele: “Ang, sika tepu kis-sindeliinga kondu kolambu.” nimbá kene nu-kene ulu-kis temba ulu kanili ‘Mania pupili.’ nikunu kanuku konde tenjui. ");
INSERT INTO mux_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kanu-kene ena tilueliinga yunu wale angere yupuku-guli aku-sipa nu-kene tepa kis-sipa, penga alsupa wale angere yupuku-guli numanu topele topa nundu “Ang, kondu kolambu.” nimbá kene kapula, nu-ni wale angere yupuku-guli ulu-kis temba kanuma ‘Mania pupili.’ nikunu kanuku konde tenjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kanu-kene Yesos-ni ui “Nanga kongunale tenji-pai.” nimba liipa mundurum yima-ni yunundu niku mele: “Auliele, nu ung nillu mele oliu ‘Sika ungele.’ nimbu laye-kolte tepu piliipu liipu ambululimulu akiliinga nu-ni ‘auli-teku piliiku liiku tondulu munduku ambolangi.’ niku liikunu tapunjui.” niku mawa tiring kene ");
INSERT INTO mux_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","⸤Auliele-ni⸥ eninindu pundu topa kene nimba mele: “Unji tenga-lupa mong akili méle aima kelále akiliinga-pe mong kanili mana mania bo mundulimele kene unji akopa ai lepa angiliimú kanili. Aku-sipa mele, eni na-ni ung niliu mele unji-mong laye mele aima laye-sele mindi piliiku liiku ambulkumelanje, eni ‘Pulu Yili-ni nanga ungele kapula piliimba.’ niku ya angiliikim unji auli akilindu “Nu pulkanu pali pulu lkunuku pukunu, no-numúna kelku angiliui.” nilkimela kene unji kanili eninga ungele piliipa liipaliinga aku-sipa kapula telka.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","⸤Aku-sipa nimbaliinga ung te wasie nimba mele:⸥ “Eninga yi te yunga kendemande-yi te-ni punie tenjimba mola kung-sipsip tápu tenjimba kene penga ipinjali lkundu ombá kene yunga auliele-ni yunundu “Ya oku mania molkunu langi nui.” nimbáye? ⸤Aku-sipa kapula naa nimbá.⸥ ");
INSERT INTO mux_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kongun tinjili yi kanili yunga kongun tepa kelepa lkundu ombá kene yunga auliele-ni yunundu i-sipa mele nimbá: “Nanga langi kalunjuku burukunu sikuliinga penga na-nanu langi nombu pora simbu kene nu pukunu nunga langi kalku nani.” nimbá. ");
INSERT INTO mux_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yi-auliele-ni ‘Ti.’ nimbá mele yunga kendemande-yili-ni piliipa liipa temba akiliinga “Angke, kapula tinu.” nimbáye? Aku-sipa naa nimbá. ");
INSERT INTO mux_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“Aku-sipako, eni Pulu Yili-ni enindu “Kongun tenjai.” nilimú mele pali teku liikuliinga eni-enini niku mele: ‘Oliu kendemande-yambu kísima.’ niai. ‘Yunu-ni oliu “Teai.” nilimú mele mendepulu tepu, kongun ola-kilia te naa tepu kene oliu kendemande-yambu kísima molemulu.’ niai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesos kolea-auli Jerusallem pumba pupa kene, kolea Gallalli kolea Sameria distrik-selenga kupulanum ai-suku-singina pupa kene, ");
INSERT INTO mux_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","kolea kelú tenga-lupa sukundu purum. Sukundu purum kene kuru-kindí nuli yi rurepunga tale yunu kupulanum omba purumna oku anju-siku angiliiku ");
INSERT INTO mux_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","enini nangale toku kene niku mele: “Yesos, Yi-Nuimele, oliu kondu kului.” niring. ");
INSERT INTO mux_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yunu-ni enini kanupaliinga nimba mele: “Pulu Yili popu tunjuli yi kanuma molemelena puku, eninga kangima liiku ora si-pai.” nirim. Kanu-kene enini pungí puring kene eninga kuru pora nimba bo-kangi angiliirim. ");
INSERT INTO mux_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eninga kangiele kaí lirim kanuring kene yi akumanga te-ni yandu omba tondulu nangale topa nimba Pulu Yili-nga bili paka tonjiliipa omba ");
INSERT INTO mux_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yesos angiliirimna mana mania omba tamalu pepa yunundu “Aima angke.” nirim. Yi kanili yunu Sameria-yili. ");
INSERT INTO mux_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kanu-kene Yesos-ni nimba mele: “Na-ni yi rurepunga tale tepu kaí naa tinduye? Penga ekupu yi rurepunga tilu kanuka tena molemeleye? ");
INSERT INTO mux_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Te wasie yandu oku Pulu Yili-nga bili paka naa tonjukumiliye? Yi-lupa ili mindi okumuye? Isrel-yi kuru-kindí num tepu kaí tinduma tena molemeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kanu-kene yunu-ni Sameria-yi kanilindu nimba mele: “Ola angiliikunu pa. Na-ni nu kapula tenjimbu nikunu “Sika” niku tondulu mundukunu pilíínele-ni nu kaí linu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Perisi-yima-ni Yesos walsiku piliiku kene niku mele: “Pulu Yili yi nuim kingele molupa yambuma nokumba enale te-kene wendu ombáye?” niring. Yesos-ni eninindu pundu topa kene nimba mele: “Pulu Yili yi nuim kingele molupa yambuma nokumba enale wendu ombáliinga yambuma mongale-ni kanungí ulu te naa ola ombá. ");
INSERT INTO mux_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eni ekupu ya molemelena Pulu Yili kórunga yi nuim kingele molupa yambu mare nokulemáliinga yunu yi nuim kingele molupa yambuma kene mélema pali nokumba ulelendu yambu te-ni “Kanai. Ya wendu okum.” niku, “Andi wendu okum.” niku, aku-sipa mele kapula naa ningí. Ena kanili kórunga wendu okum.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aku-sipa nimba kene Yesos-ni yunga lumbili anduli yimandu nimba mele: “Eni “Mania Omba Mana-Yi Au Talurum Yili laye-kolte kanamili.” ningí enama wendu ombáliinga-pe naa kanungí. ");
INSERT INTO mux_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Yambuma-ni “Wi-na molemú.”, “Ya-na molemú.”, ningí. Akiliinga-pe aku-siku ningí kene gólu tungí akiliinga enini lumbili naa pai. ");
INSERT INTO mux_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kariyapa liipa sinjipa telemú kene koleama pali pa telemú-na yambuma-ni pali kanolemele. Mania Omba Mana-Yi Au Talurum Yili aku-sipa mele alsupa ombá. ");
INSERT INTO mux_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akiliinga-pe ui yunu mindili lakupa nombá, ekupu molemele yambuma-ni yunu úngulu siku, liiku bulu singí. ⸤Kanu-kene kolupa lomburupa ola molupa kene,⸥ penga “Ombá.” niker akili mele ombá. ");
INSERT INTO mux_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ui yi Noa mulupili yambuma-ni tiring akili mele Mania Omba Mana-Yi Au Talurum Yili ombá temba kene yambuma-ni aku-siku tingí. ");
INSERT INTO mux_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","⸤Ma-koleamanga pali⸥ no ui naa tupili yambuma langi noku, yi kanuma ambu liiku, ambuma yi puku, ulu akuma mindi teku mololsiliiku puring. Noa nona anduli sip-lkuna lkundu purum kene kepe enini aku-siku uluma teku mindi molangi no topa ⸤koleama pali no-ni panda topa⸥ yambuma pali topa kunjurum. ");
INSERT INTO mux_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“LLot kene wasie muluring yambuma-ni aku-siku tiringko. Enini langi noku, méle taropu toku, punie panjiku, lku takuku, we-ulu akuma teku muluring. ");
INSERT INTO mux_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Akiliinga-pe LLot kolea-auli Sodom mundupa kelepa takara topa purum ena kaniliinga tepi kene ku-mulú tepi-ni núlima kene lo mele mulúna mania omba Sodom muluring yambuma pali topa kunjurum. ");
INSERT INTO mux_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Mania Omba Mana-Yi Au Talurum Yili alsupa ombá enaliinga ui tiring niker akili mele penga aku-siku teku mulungíko. ");
INSERT INTO mux_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Yunu ombá ena kanili wendu ombá kene lku imuna ola mulungí yambuma alsuku lkundu puku eninga lku sukundu nusingí mélema puku naa lii-pangi. Aku-sikuko puniena mulungí yambuma mélema lipili nosuku puniena pungí kene ena kanili wendu ombá kene méle nusingíma alsuku puku naa lii-pangi. ");
INSERT INTO mux_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","LLot-min tirim akili mele piliai. ⸤LLot kene wasie Sodom munduku kelkulu takara tokulu puringleliinga-pe Sodom tepi mania urum kilia piliipaliinga Pulu Yili-nga angkella te-ni ui “Iki teku naa kanukulu we sumbi-sikulu takara tokulu pale.” nirim akili LLot-min naa piliipa liipa, iki tepa kanurum kene api-kusa au talupa ku-mulú mele we angiliirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“‘Na naa kolupu numanu simbu uluma mindi tepu molambu.’ niku Pulu Yili-nga ungele naa piliiku liingí yambuma sika kulungí. Akiliinga-pe ‘Na kulundu lem kapulako.’ niku Pulu Yili-nga ungele piliiku liiku teku mulungí yambuma naa kolku molku mindi pungí. ");
INSERT INTO mux_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Na-ni enindu aima sika nimbu siker: “Mania Omba Mana-Yi Au Talurum Yili alsupa ombá enaliinga sumbulsuli yambu tale sulumina tiluna pinglí kene ⸤Pulu Yili-nga angkella te-ni⸥ omba yambu te we pípili mundupa kelepa te liipa memba pumba. ");
INSERT INTO mux_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ambu tale langi kalunglí teku mulunglí kene ⸤angkella te omba⸥ ambu te we mulupili mundupa kelepa te liipa memba pumba. ");
INSERT INTO mux_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Yi tale taena unji toku angiliinglí kene ⸤Pulu Yili-nga angkella te-ni omba⸥ yi te we mulupili mundupa kelepa te liipa memba pumba.)” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","⸤Yunu-ni nirim mele piliikuliinga⸥ enini niku mele: “Auliele, ulu akili tena tembaye?” niring. Yesos-ni pundu topa kene ung-eku te topaliinga nimba mele: “Méle kolupa lelemú koleamanga méle kulúlima nolemele kerama-ni méle kolupa lelemúma kanukuliinga nungíndu mania oku liiku máku tolemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Walse, Yesos-ni ‘Enini taki-taki Pulu Yili-kene popu toku ung niku enembu naa kolku munduku naa kelangi.’ nimba yu lumbili anduli yimandu ung-eku te topaliinga nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Walse, kolea tenga kot piliirim yi te mulurum. Kot piliirim yi kanili yunu Pulu Yili kepe mana-yambumanga kepe, mundu-mong naa tinjirim. ");
INSERT INTO mux_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kolea kanuna ambu-waye te mulurumko. Ambu kanili yunu-ni kot piliimba yili mulurumna taki-taki omba yunundu nimba mele: “Na tepa kis-sirim yili kot tenjambu. Nu-ni na liiku tapunjukunu kot piliinjani.” nimba mawa ti-pui-upui tirim. ");
INSERT INTO mux_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ambale ui koela urum kene kotele piliimba yili-ni yunundu “Mólu, nunga kotele na naa piliinjimbu.” nirimeliinga-pe ambale yunu-kene taki-taki omba mawa tirim kilia kot piliimba yili piliipa kis piliipaliinga yununu nimba mele: ‘Na Pulu Yili-nga mundu-mong naa tenjipu, yambuma kondu naa kolupu moliu ");
INSERT INTO mux_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","akiliinga-pe ambu-waye ili taki-taki omba walsilimáliinga penga alsupa omba mawa temba kene na kamu piliipu kis piliimbu akiliinga yunga kotele ekupu kamu piliinjambu.’ nirim.” ⸤nimba kene Yesos-ni⸥ aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Auli ⸤Yesos-ni ung-eku akili topa pora sipaliinga⸥ ung te wasie nimba mele: “Kot piliirim yi-kisele-ni ambu-wayelendu tirim mele piliai. ");
INSERT INTO mux_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aku-sipa mele Pulu Yili-ni yunga yambuma buni silimele yambuma aku-siku telemeláliinga kot piliimba yili molupa kene kot naa tenjimbaye? Yunga ui makó turum yambuma-ni sumbulsuli kepe tanguli kepe taki-taki “Oliunga kot piliinjui.” niku mawa telemele kene yunu-ni eninga kotele naa piliinjimbaye? Yunu ui we molupa penga mele “Enini liipu tapunjambu.” nimba táka-nimba ombáye? ");
INSERT INTO mux_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yunu temba mele akili nimbu sambu: “Pulu Yili yunu wela omba yunga yambuma liipa tapunjumbandu enini buni silimele yambuma kot tenjipaliinga mindili simba.” niker. Akiliinga-pe Mania Omba Mana-Yi Au Talurum Yili alsupa wale tale-sipa mana mania ombá kene “Yambu mare-ni ‘Yunu-ni enini liipa tapunjumba.’ niku yunu mawa teku mulungí mola mólunje?” nimba omba kanomba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yambu mare eni-enini piliikuliinga ‘Na yi kaiéle. Na sumbi-sipu moliu, yambu-lupama molku kis-silimele. Enini yambu kísima. Enini-kene tapú-topu naa molumbu.’ niku piliiku anduku muluring yambumandu Yesos-ni ung-eku ili topaliinga nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Yi tale lupa-lupa ‘Pulu Yili-kene ung niambili.’ nikulu Pulu Yili popu toku kaluring lku-tembolluna puringli. Te Perisi-yi te, te ku-moni-takis liili yi te. ");
INSERT INTO mux_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Perisi-yili kakará nimba ola angiliipa kene yununu numanale-ni piliirim ungma nimba mele: “Pulu Yili, yambu-lupama pali molemele mele na aku-sipu naa moliáliinga nu-kene “Angke” niker. Enini wa noku, ulu-pulu-kisma teku, ambu yima waperanale teku, telemele. Ku-takis liili yi ili tepa molemú mele kepe na naa teliu. ");
INSERT INTO mux_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na kóru tenga taki-taki ena tale langi mi topu naa nombu, ku-monima kene mélema kene méle rurepunga tale nimbu taki-taki liiliumanga tilu-tilu nimbu nu moke tepu siliu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Akiliinga-pe ku-moni-takis liili yili nondupa naa omba anju tenga-lupa ma kanupa angiliipaliinga, ‘Na yi aima kis te.’ nimba piliipa pipili kolopa mundu-mong tenjipa ki-kumu-ni yunga pepeli-ombelena topa angiliipaliinga nimba mele: “Pulu Yili, na numanuna ulu-pulu-kis pili yili kondu kului.” nirim.” ⸤nimba Yesos-ni aku-sipa nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Na-ni enindu aima sika nimbu siker: “Yi i-selenga Pulu Yili-ni ku-takis liili yilinga ulu-pulu-kísima kanupa konde tenjipa, yunu ‘yi sumbi-niliele.’ nimba kanupa mulupili lkundu purum, akiliinga-pe Perisi-yili yunga ulu-pulu-kísima numanuna we pípili lkundu purum.” niker. Yambu eninga bi paka tolemele yambuma Pulu Yili-ni topa mania mundumba, akiliinga-pe yambu eninga bi toku mania mundulimele yambuma yunu-ni eninga bima paka tonjumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kanu-kene yambuma-ni eninga kangambula kelúma ‘Yesos yunga kili-ni ambulupili.’ niku yunu mulurumna meku uring. Meku ungí uring kanuku kene Yesos lumbili anduli yima-ni ung-mura siku ⸤“Naa meku wai.”⸥ niring. ");
INSERT INTO mux_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Akiliinga-pe Yesos-ni kangambulamandu “Wai.” nimbaliinga ⸤yu lumbili anduli yimandu⸥ nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú yambu-talape akili kangambula ima mele molemele akiliinga eni kangambula ima na moliuna wangi pipi siku “Mólu.” naa niai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Na-ni enindu aima sika nimbu siker: “Kangambolama-ni ‘Pulu Yili oliunga yi nuim kingele mulupili.’ niku molemele mele aku-siku naa nilimele yambuma yunga koleana sukundu aima naa pungí, mólu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","⸤Walse Juda-yambumanga⸥ yi-nuim te Yesos mulurumna omba yunundu walsipa piliipaliinga nimba mele: “Ung-Bo Tunjuli Yi Kaiéle, na nambulka ulu te tembu kene na kona molupa konjupa mindi puli ulu-pulele liimbuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesos-ni yunundu nimba mele: “Nu-ni na nambimuna “Kaiéle.” nikinuye? Yambu kaí te naa molemú. Pulu Yili mindi kaiéle.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","⸤Aku-sipa nimbaliinga yili-ni walsurumeliinga pundu topa kene nimba mele:⸥ “Nu ⸤Pulu Yili-nga⸥ ung-manima ⸤Moses-ni yandu nimba sirim-ma⸥ piliillu. ⸤Ung-mani akuma i-sipa mele⸥: “Ambu yi púlima mola yi ambu líílima yambu lupa-lupama-kene waperanale naa teai.” nimba, “Yambu toku naa konjai.” nimba, “Mélema wa naa liai.” nimba, “Yambumanga kot gólu toku naa tenjai.” nimba, “Aminiali laniali kene teku konjuku, ung ningí mele piliiku liiku teku molai.” nimba, ung-mani akuma sirim molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Aku nirim-na piliipa kene yi kanili-ni nimba mele: “Na kang-kene molupuliinga ung-mani akuma pali piliipu liipu tepu mulurundu mele yandupa ekupu kepe tepu moliuko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yunu aku-sipa nirim piliipa kene Yesos-ni yunundu nimba mele: “Papu tellu akiliinga-pe ulu tilu mindi naa tellu. Nu pukunu nunga méle nosulluma pali ku-moni liikunu kene, ku-moni liiníma yambu-korupama moke teku sikunu kene na lumbili ui.” nirim. “Nunga ⸤ma-koleana⸥ mélema aku tiní kene mulú-koleana nunga méle lupa-lupa kaí pulele lemba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yi-nuim kanili méle aima lupa-lupa kaí pulele nusurumeliinga Yesos-ni aku nirim kene piliipa kene yunu numanu kis panjipa numanu buni aima auli-tepa liipa anju purum. ");
INSERT INTO mux_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yunu aku-sipa purum kanupaliinga Yesos-ni yu lumbili anduli yimandu nimba mele: “Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu yambu-kamakoma aima mindili-siku sukundu pungí. ");
INSERT INTO mux_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kung-kemel akili ⸤kung aima auli te akiliinga-pe⸥ kalé suruli kupulanum-na sukundu pumbandu mindili laye-kolte mele sipa kene pumba. Akiliinga-pe yambu-kamakoma Pulu Yili yi nuim kingele molupa nokulemú koleana sukundu pungíndu mindili aima lakuku mele siku pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yu-ni aku nirim piliiring yambuma-ni niku mele: “Aku lem mindili nolkemela kupulanum-na nae kapula wendu pupa, molupu konjumulú kupulanum-na pumbaye? Te mólunje?” niring kene ");
INSERT INTO mux_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","yunu-ni eninindu nimba mele: “Yambuma-ni aima kapula naa telemele uluma Pulu Yili-ni kapula tenjimba. Pulu Yili yu-ni uluma pali kapula telemú. Ulu te yu-ni kapula naa temba te mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","⸤Yu-ni aku nirim piliipa kene⸥ Pita-ni yunundu nimba mele: “⸤Pe oliu-kene nambulka ulu te wendu ombáye?⸥ Oliu oliunga mélema pali mundupu kelepu nu lumbili purumulu mele pulimulu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesos-ni nimba mele: “Na-ni enindu aima sika nimbu siker: ‘Pulu Yili omba yi nuim kingele molupa nokumba enale wendu ombá mele “Yambuma piliangi.” niku silsiliiku andungíndu eninga lkuma kene, minupili-ambuma kene, anginipilima kene, anupili lapaliima kene, kangambulama kene, akuma munduku kelemele yambuma pali ");
INSERT INTO mux_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ya ma-koleana aima méle pulele ola-kilia liiku kene penga pungí koleana kona molku konjuku mindi puli ulu-pulele liingíko.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kanu-kene Yesos-ni ⸤yu lumbili anduli⸥ yi rurepu ‘na kene enini kene oliuliu molamili.’ nimba enini liipa anju memba pupa kene eninindu nimba mele: “Piliai. Oliu kolea-auli Jerusallem pumulú pukumulu. Akuna pumulú kene ui Pulu Yili-ni “Ninjai!” nimba ung nimba sirim-ma piliiku yambuma niku siring yima-ni wendu ombá mele niku bukna turing uluma pali Mania Omba Mana-Yi Au Talurum Yili-kene kamu wendu ombá. ");
INSERT INTO mux_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juda-yambumanga yi-aulima-ni Mania Omba Mana-Yi Au Talurum Yili liiku Juda-yi naa molemele yima singí. Enini yu ung-taka tonjuku yunu teku kis-siku yunga kumbi-kerina lkambe toku, ");
INSERT INTO mux_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","yunu ka-pulsa-ni toku yu toku kunjingí. Yunu toku kunjingí kene ena yupuku-sipaliinga lomburupa ola molumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Akiliinga-pe yunu-ni ung nirimele piliiku sunduring. Ung-pulele naa piliiku kene ung nirimele piliiku bi naa siring. ");
INSERT INTO mux_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kanu-kene Yesos Jeriko taon nondupa ombá urum kene mong kis lirim yi te kupulanum alsena molupa yambuma “Ku-moni sai.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yi kanili-ni yambu pulele oku pungí puring piliipa kene yunu-ni “Nambulka tekemeleye?” nimba walsurum kene ");
INSERT INTO mux_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","enini yunundu niku mele: “Nasaret-yi Yesos omba pukum.” niku, niku siring. ");
INSERT INTO mux_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Aku-siku niring piliipaliinga yunu-ni tondulu nangale topa walsipa kene nimba mele: “Yesos, ⸤yi nuim king⸥ Depit-ni kalupa liirim yili, na kondu kului.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kumbi-leku puring yambuma-ni yunu ung-mura siku “Nu ung naa niku táka-nikunu mului.” niring. Akiliinga-pe yunu-ni aima tondulu nangale topa walsipa kene nimba mele: “Depit-ni kalupa liirim yili, na kondu kului.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesos we angiliipa kene “Yunu yandu meku wai.” nirim. Yunu Yesos angiliirimna nondupa urum kene Yesos-ni yunundu walsipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na-ni nu nambulka tenjambu niku piliikunuye?” nirim. Yunu-ni pundu topa kene nimba mele: “Auliele, na mongale-ni mélema kanambu nanga mongsele teku kaí tenjani.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesos-ni yunundu nimba mele: “‘Na-ni nunga mongsele kapula tenjimbu.’ niku pilííneliinga nunga mongsele kaí lipili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesos-ni aku-sipa nirim kene enaliinga yunga mongsele kaí lirim, mélema kanupa kene Pulu Yili kape nimba yunga bili paka tonjiliipa Yesos lumbili purum. Yambuma-ni pali ulu⸤-tondulu te wendu urum⸥ akili kanuku kene enini kepe Pulu Yili kape niring. ");
INSERT INTO mux_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesos yunu Jeriko taon-na omba pumba purum. ");
INSERT INTO mux_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","⸤Jeriko akuna⸥ ku-moni-takis liipa ku-takis liiring yi wema nukurum yi te, yunga bili Sakias, yunu akuna mulurum. Yunu méle pulele nosupa yi-kamakale mulurum. ");
INSERT INTO mux_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yi kanili-ni Yesos urum kilia kanombandu tirim mele. Yesos urumna yambu pulele liiku máku turing kene Sakias yunu yi aima sumbu akiliinga molupa kene Yesos kapula naa kanurum. ");
INSERT INTO mux_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Akiliinga Yesos urumna kanombandu yunu lkisipa kumbi-lepa pupa kene unji sikamú-pik nili te Yesos ombá urum kupulanum-na nondupa angiliirim unji kaniliinga omba ola purum. ");
INSERT INTO mux_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesos akuna omba kene we angiliipa olandu-sipa kanupaliinga yunundu nimba mele: “Sakias, nunga lku-kolea ekupu na-kene wasie molambili pambili wela mania ui.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","yu lkisipa mania omba yunundu “Kapula.” nimbaliinga numanu sirim. ");
INSERT INTO mux_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yesos Sakias-nga lku-kolea wasie puringli kanuku kene ui akuna liiku máku turing yambuma-ni niku mele: “Yunu ulu-pulu-kis tili yili kene ‘Molu-pambili pambulu.’ nimba pukum.” nikuliinga yunu tirim mele kanuku kis piliiring. ");
INSERT INTO mux_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanu-kene Yesos kene Sakias elsele lkuna lku-suku molkulu kene Sakias ola angiliipa Auliele-ndu nimba mele: “Auliele, na-ni nundu ung te niambu pília. Nanga méle nosiliuma ekendu liipu yambu-korupama sipu kene, penga ku-moni te mola méle te gólu topu wa-mele liirindu méle kanuma alsupu wa liirindu mele pundu topu yupuku tepu ola panjipu anju simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yunu-ni aku-sipa nirim kene Yesos-ni yunundu nimba mele: “Ekupu lku ilinga pulu yambuma Pulu Yili-ni tepa liipa ‘mindili nolkemela kupulanum-na wendu oku, yu-kene wasie molku kunjingí kupulanum-na pangi.’ nilimú ulu-pulele liikimele. Ekupu lku pulu yi ili yunu kepe anda-kolepa Eprayam-ni kalupa liirim yi te. ");
INSERT INTO mux_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Mania Omba Mana-Yi Au Talurum Yili-ni ‘Yambu kupulanum lu liiku molku kis-silimele yambuma korupu, enini tepu liipu mindili nolkemela kupulanum-na wendu liipu na-kene molku kunjingí kupulanum-na liipu monjumbu.’ nimba urum.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aku-sipa nirim piliiku kene Yesos yunu kolea-auli Jerusallem nondupa ombá tirim-na kanukuliinga we-yambuma enini ‘Pulu Yili omba yi nuim kingele molumba enale aima nondupa ombá.’ niku piliiku muluring. Enini aku-siku piliiku muluringele piliipa kene ⸤Yesos⸥ yunu-ni eninindu ung-eku te topaliinga ");
INSERT INTO mux_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","nimba mele: “Yi-nuim tenga málale kolea tenga kupulanum sulu pupa kene yunu king molumba namba tondulale liimbandu ‘Penga yandu ombú.’ nimba kene yunu purum. ");
INSERT INTO mux_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ui naa pupa kene kumbi-lepa yunga kendemande-yi rurepunga tale-ndu “Wai.” nimbaliinga ku-moni kumu rurepunga tale nimba moke tepa enini lupa-lupa sipaliinga eninindu nimba mele: “Na wilí anju molumbu kene ku-moni siker liikimele ilinga ‘Ku te ola-buluna panjupu liinjimulú.’ niku numanu tondulu munduku kongun tenjiku molai. Penga na ombú.” nimbaliinga yunu purum. ");
INSERT INTO mux_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Yi kanili purum kene yunga talapena-yambuma yu-kene numanu kis piliiring kilia eninga yi te ‘Yunu aelepa pupili.’ niku liiku munduku kene niku mele: “‘ “Yi-nuim ili oliunga yi nuim kingele naa mulupili.” nimbu molemulu.’ ninjui.” niku yunu liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Penga yi kanili kingeliinga nambale sika liipa memba yandu urum kene ui ku-moni sipa purum kendemande-yimandu “Wai.” nimbaliinga “Eni ku-moni sirindumanga ola-buluna panjiku ku-moni nambi-sili liiku nusunjuring-nje?” nimba walsurum. ");
INSERT INTO mux_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ui kumbi-lepa sirim yili-ni omba yunundu nimba mele: “Auliele, nunga ku-moni kumu te sirinu kaniliinga ola-buluna panjipu kumu rurepunga tale liinjirindu.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","yi nuim kingele-ni yunundu nimba mele: “Kendemande-yi kaiéle. Papu tirinu. Méle laye sirindeliinga nu-ni tekunu kunjurunu akiliinga nu-ni kolea-auli rurepunga tale nukui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yi tale-sipale-ni omba yunundu nimba mele: “Auliele, nunga ku-moni kumu te sirinu kaniliinga ola-buluna panjipu kumu angere te-guli liinjirindu.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","yi nuim kingele-ni yunundu nimba mele: “Aku-siku tirineliinga nu-ni kolea-auli angere te-guli nukui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Penga kendemande-yi te omba yunundu nimba mele: “Auliele, na-ni piliipu kene ‘Nu méle taropu tondulu munduku tokunu, ‘Ku-moni liipu nosumbaliinga yambuma mindili núngi lem kapulako.’ nikunu ⸤kendemande-yambuma ‘Kongun mindili noku teai.’ niku sikunu, enini méle koltale sikunu mélema pali nu-nunu mindi liillu yili;⸥ yambuma-ni punie panjinjilimele kene nu-ni nunu langi mélema we ukuku liiku; punie naa telluna langima we liiku nosukunu, nu-ni aku-sikunu teku mollu yili.’ nimbu piliipuliinga mundu-mong tenjipu nu-ni na sirinu ku-monele kumu topu nusurundele ya siker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Aku-sipa nirim kene piliipaliinga yi-nuimele-ni ung-mura tepa kene yunundu nimba mele: “Nu kendemande-yi kisele. ⸤Na-ni nunga kot piliimbu kene⸥ nunga nikinu ungele-ni nu-nunu kot tenjimba. Nu-ni piliikunu kene ‘Yambuma-ni punie panjinjilimele kene na-nanu langi mélema we ukupu liipu; punie naa teliuna langima liipu nosupu, na aku-sipu tepu moliu.’ niku piliikunu molluye? ");
INSERT INTO mux_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aku-siku niku piliikunuliinga nanga ku-monele ku-beng lkuna nambimuna naa nusunjurunuye? Aku-siku telkenanje na ombu nanga ku-monele wendu liipu kene ku-moni laye-kolte ola-buluna panjiku silkimela liilkáko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","⸤Kendemande-yi kanilindu aku-sipa nimba pora sipaliinga⸥ yunu-ni nondupa angiliiring yambu kanumandu nimba mele: “Yi ili tepa kis-sirim akiliinga yunga kuli wendu liiku kene ku-kumu rurepunga tale ambulkum yili sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Enini yunundu niku mele: “Auliele, yunu kórunga ku-kumu rurepunga tale ambulúm kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Enini aku-siku niring kene yi nuim kingele-ni alsupa nimba mele: “Enindu nimbu sambu: “Mélema nosilimú yambale na-ni mare wasie simbu, yunu aima pulele nosimba. Akiliinga-pe mélema naa nosilimú yambale yunga méle nosulimúma kepe wendu liimbu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aku-sipa nimbaliinga yi nuim king kanili yunu-ni ung te wasie nimba mele: “Ekupu na teku kis-siring yambuma meku wai. Enini nandu niku mele: ‘Yi ili oliunga yi nuim kingele naa mulupili.’ niring yambu kanuma meku oku na kanupu molambu enini toku konjai.” nirim.” nimba ⸤Yesos-ni aku-sipa ung-eku kanili topa pora sirim⸥. ");
INSERT INTO mux_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ung-eku akili topa pora sipaliinga kolea-auli Jerusallem kelepa pumba purum. ");
INSERT INTO mux_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kanu-kene Yesos ⸤kene yu lumbili andúlima kene enini kolea-auli Jerusallem nondupa oku⸥, ma-pangi te ‘Unji-Ollip Punie Lili Ma-Pangiele’ nili akuna kolea kelú tale, Betepas kene Betani kene akuselenga nondupa uring. Kanu-kene Yesos-ni yunga lumbili anduli yi tale liipa mundupa, elselendu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ne kolea-kelú kanukumbele akuna pukulu kene kung-dongki walú te, yambu te yunga bulu-mingina ui naa molku anduringele ka teku panjingéle ne akuna sukundu molumba kanunglí akili pukulu posukulu meku wangli pale. ");
INSERT INTO mux_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Pusinglí tekulu mulunglí kene yambu te-ni elsendu “Kung-dongkele nambimuna posukimbiliye?” nimba walsum lem else-ni i-siku niale: “Auliele yunu kung-dongkele-kene kongun te pímu-na ombu liikimbulu.” niangli.” nimba kene elsele liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Liipa mundurum yi kanusele pukulu yunu-ni nirim akili mele kanuku liikulu kene ");
INSERT INTO mux_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","penga kung-dongki walú kanili posikulu muluringli kene kung-dongki pulu yima-ni elselendu niku mele: “Oliunga kung-dongkele nambimuna posukimbiliye?” niku walsiring kene ");
INSERT INTO mux_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","elsele-ni “Auliele yunu kung-dongkele-kene kongun te pímu-na ombu liikimbulu.” niringli. ");
INSERT INTO mux_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kanu-kene kung-dongki kanili liikulu Yesos mulurumna meku pukulu kene elsengla mulumbalema posukulu, dongkeliinga bulu-mingina ola pauwa tonjukulu Yesos kanuna ola munjuringli. ");
INSERT INTO mux_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yambu mare-ni eninga mulumbalema posuku yu ombá kupulanum-na pauwa tolsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Kanu-kene yunu Jerusallem aima nondupa omba, Unji-Ollip Punie Lili Ma-Pangina mania ombá urum kene yu lumbili puring yambu pulele numanu lakuku siku ⸤Yesos-ni⸥ ulu-tondulu pulele tirim kanuring akumanga Pulu Yili kape niku tondulu munduku niku mele: ");
INSERT INTO mux_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Pulu Yi Yawe-ni liipa mundurum-na yunga kongunale tenjimba okum yi nuim kingele molupa kunjupili. Mulú-koleana numanu waengu nipili molomulú enale wela upili. Mulú-koleana aima ola-kilia ⸤Pulu Yili-nga⸥ bili aima ola pípili lakupu kape niamili.” nilsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Aku-siku niring piliiku kene Perisi-yi wasie puring yi mare-ni ⸤we-yambuma-ni aku-siku niring akili piliiku kis piliikuliinga⸥ yunundu niku mele: “Ung-Bo Tunjuliele, nu lumbili anduli yima-ni nikimili mele akili ‘Naa niangi.’ nikunu enini ung-mura si.” niring kene ");
INSERT INTO mux_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesos-ni eninindu nimba mele: “Na-ni enindu i-sipu niker: “Yambu ima-ni i-siku naa niku we mulúngi lem ya ku-mulú lelemúma-ni nangale toku ningí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesos Jerusallem aima nondupa omba kolea-auli kanili kanupaliinga kola tepa kene ");
INSERT INTO mux_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","nimba mele: “⸤Jerusallem yambuma,⸥ ekupu eni kepe mindili naa noku kapula-kapula mulungí kupulanumele piliilkimilánje kapula. Akiliinga-pe ekupu naa piliilimili ⸤akiliinga⸥ naa liiku manjingí. ");
INSERT INTO mux_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Eni mulungína ena mare wendu ombá, ena kanuna eninga ele-tu yima oku ‘Eninga koleana kupulanum naa lipili.’ niku ma-pala teku ele-tu yima eni molku poku teku ‘Eni sukundu molangi.’ niku aku-siku tingí. ");
INSERT INTO mux_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Aku-siku teku kene, penga Jerusallem lkuma pali toku tekisiku bulu-bale siku kene lku-suku mulungí yambuma tungí, aku-siku tingí enama wendu ombá. Pulu Yili-ni ⸤eni tepa liimbandu⸥ um enale eni naa pilííngeliinga ena kanuma wendu ombá.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesos ⸤Jerusallem sukundu pupa kene,⸥ Pulu Yili popu toku kaluring lku-tembolluna ⸤“Juda-yambu naa molemele yambuma ‘Pulu Yili popu tamili.’ niku máku tolemele kolea” niring akuna⸥ suku pupa kanupa kene akuna mélema maket teku muluring yambuma pulu monjupa topa makurupaliinga ");
INSERT INTO mux_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","eninindu nimba mele: “Pulu Yili-nga bukna ung te i-sipa nilimú: ‘Yambuma-ni nanga lkulindu “Pulu Yili kene ung nilimulu lkuli.” ningí.’ kanili. Ung aku-sipa molemú akiliinga-pe eni lku ili ‘wa nolemele yambuma mo toku molemele lkuli’ mele niku piliiku kene aku-siku telemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yunu-ni enamanga taki-taki lku-tembolluna lku-suku ⸤“Juda-yambu naa molemele yambuma ‘Pulu Yili popu tomulú.’ niku liiku máku tolemele kolea” niring akuna⸥ yambuma ung-mani sirim. Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambuma nukuring yi-aulima kene, enini yunu toku kunjingí kupulanumele kururing ");
INSERT INTO mux_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","akiliinga-pe we-yambuma-ni yunga ungele kum leku piliiku muluring kilia enini yunu toku kunjingí kupulanum te naa kanuku liiring. ");
INSERT INTO mux_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Walse Yesos-ni ⸤Pulu Yili popu toku kaluring⸥ lku-temboll akuna liiku máku turing yambuma ung-bo tonjupa mani sipa, temani-kaiéle topa sipa mulurum kene yi mare, Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambumanga tápu-yima kene, enini oku ");
INSERT INTO mux_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","yunu walsiku piliiku kene niku mele: “Nu namba nambulka nambale liikunu kene kongun ili telluye? Nae-ni kongun ili “Ti-pui.” nimba nu nambale sipa liipa mundurumye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesos-ni eninindu pundu topa kene nimba mele: “Na-ni eni ung te walsipu piliimbuko. Eni walsimbu mele akili eni na pundu toku niai. ");
INSERT INTO mux_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ui ⸤No-Liinjili⸥ Jon omba yambuma no liinjirim kene yunu mulú-koleana ⸤molemú yilinga⸥ kongunale tenjimbandu yambuma no liinjirim mola ya mana-yambumanga kongunale tenjimbandu yambuma no liinjirimuye? ⸤Nae-ni “Ti.” nirim-na tirimuye? Niku sai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","⸤Yu-ni aku-sipa walsurum mele piliiku kene⸥ eni-enini tombulku niku kene niku mele: “Yu-ni walsikim mele oliu-ni pundu topu, “⸤Jon⸥ yunu mulú-koleana ⸤molemú yilinga kongun tenjimbandu yambuma no liinjirim⸥.” nímulu lem yu-ni oliundu nimba mele: “Aku lem eni Jon-ni nirim ungele nambimuna ‘Ung ili sika.’ niku naa piliiku liiringiye?” nimbá. ");
INSERT INTO mux_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mola oliu-ni nimbu mele: “Yu mana-yambumanga ⸤kongunale tenjimbandu yambuma no liinjirim⸥.” nímulu lem we-yambuma-ni oliu ku-ni toku kunjingí. We-yambuma-ni ‘Jon yunu aima sika Pulu Yili-ni “Ninjui!” nimba, nimba sirimu ungma piliipa yambuma nimba sirim yi te mulurum.’ niku piliilimili akiliinga enini oliu ku-ni toku kunjingí.” niku enini aku-siku tombulku niring. ");
INSERT INTO mux_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","⸤Eni-enini aku-siku anju-yandu tombulku niku kene⸥ Yesos-ndu pundu toku niku mele: “Yu-ni Pulu Yili-nga kongunale tenjipa kene yambuma no liinjirim, mola mana-yambumanga kongunale tenjipa kene yu-ni yambuma no liinjirim-nje. Oliu naa piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aku-siku niring kene piliipaliinga Yesos-ni eninindu nimba mele: “Kapula. ⸤Na-ni eni walsiker ungeliinga ung te pundu toku naa nikimilieliinga⸥ eni na walsikimili ungeliinga ung te pundu topu nandu kongun ili ‘Ti-pui.’ nimba na liipa mundupa namba sirim yilinga bili eni naa nimbu simbuko.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kanu-kene liiku máku toku muluring yambumandu Yesos-ni ung-eku ili topa kene nimba mele: “Yi te-ni unji-waen punie tirim. Yi mare kanupa liipa kene eninindu nimba mele: “Nanga puniele tápu tenjiku unji-monguma lkeku nokunjangi. Penga waen-mong polu tomba kene monguma moke tepu, kongun tinjingí mele mare eni liangi, mare na liimbú.” nimba punie kanili enini sipa kene yunu kolea ⸤sulu⸥ tenga pupa akuna wale pulele mulurum. ");
INSERT INTO mux_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kanu-kene penga unji-waen-mongma polu tomba tirim kene punie pulu yili-ni yunga kendemande-yi te liipa mundupaliinga “Nanga unji-waen-mongma sangi puku liiku menjikunu wani pui.” nimba punie nukuring yi kanuma muluringna liipa mundurum. Akiliinga-pe kendemande-yili ⸤urum kene⸥ punie nukuli yima-ni yunu ambolku liiku kimbulú-ni toku, unji-waen-mong mare naa siku, “Anju we pui!” niku liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Alsupa punie pulu yili-ni kendemande-yi te liipa ⸤“Nanga unji-waen-mongma liinji-pui.” nimba liipa⸥ mundurum. Akiliinga-pe kendemande-yili ⸤urum kene⸥ punie nukuli yima-ni yunu ambolku liiku kene kimbulú-ni toku, teku kis-siku, unji-waen-mong mare naa siku anju we liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Alsupa punie pulu yili-ni kendemande-yi te liipa mundurum kene enini yunu toku kene puniena makuruku liiku ulsu munduring. ");
INSERT INTO mux_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Aku-siku tiringeliinga punie pulu yili-ni ⸤numanale-ni piliipa kene⸥ ‘Ekupu na tembu mele piliiker. Nanga málale, na-ni numanu monjuliu kangale, enini yunu-kene pipili kolku liiku ai siku yunu unji-waen-mong mare singínje.’ nimba piliipa kene ⸤yunga málu liipa mundurum⸥. ");
INSERT INTO mux_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Akiliinga-pe punie nukuli yima-ni punie pulu yilinga málale ombá urum kanuku kene eni-enini niku mele: “Andi okum yili penga lapanga moya-méle simbama liimba yili okum. Yunu topu konjupu, punie ili oliu kamu liamili.” niku kene ");
INSERT INTO mux_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","enini yunu ambolku liiku puniena makuruku ulsu munduku kene yunu toku kunjuring.” ⸤nimba Yesos-ni nirim.⸥ ⸤Aku-sipa nimbaliinga ung-eku akili topa pora simbandu akuna liiku máku toku muluring yambumandu nimba mele:⸥ “Punie nukuli yima-ni aku-siku tiringeliinga penga punie pulu yili-ni enini-kene nambulka ulu te tembaye? ");
INSERT INTO mux_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yu omba yi kis kanuma topa konjupa kene ‘Yi mare-ni lupa puniele nokunjangi.’ nimba liipa simba.” nirim. Kanu-kene Yesos-ni aku-sipa nirim kene piliikuliinga enini niku mele: “Pulu Yili-ni ‘Aku-sipa wendu naa upili, aima mólu!’ nipili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesos-ni ⸤Pulu Yili-nga Juda-yambuma nukuring yima-ni yunu toku kunjingí akili piliipaliinga⸥ eninindu nimba mele: “Pulu Yili-nga ung te bukna molemáliinga ung-pulele nambulkanje niku piliilimiliye? Ung akili i-sipa mele: ‘Lku takuring yima-ni ku-mulú te kanuku kis piliiku toku munduku kiliring ku-mulú akili ekupu alsupa lku paka-sum mele lku tepa tondulu munduli ku-mulú auli kaiéle.’ nimba molemú kanili. ");
INSERT INTO mux_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ku-mulále ⸤niker⸥ ilinga ola yambu te singa-topa tomba kene ombele mélema elki tomba. Akiliinga-pe yambu te molumbana ola kúli-ni omba yunu topa kene yambu kanili topa nurupalu tomba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kanu-kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani siring yima kene, Pulu Yili popu tunjuring yi-aulima kene, enini Yesos-ni ung-eku turum kanili piliiku kene enini teku kis-siku yunu toku kunjingí teku muluring akili yu-ni nirim piliiku kene enini ena-mong kaniliinga yunu ka singí tiring akiliinga-pe yi-auli kanuma-ni we-yambumanga mundu-mong tenjiku kene yunu naa liiku ka siring. ");
INSERT INTO mux_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kanu-kene ⸤Juda-yambumanga yi-aulima-ni⸥ ‘Yesos ka sipu ⸤kot tenjimuláliinga⸥ gapman yili molumbana membu pumulú.’ niku molkuliinga yu kanuku muluring. ‘Yunu-ni ung te nimba kis-simba kene ka simulú.’ nikuliinga yi mare, ‘Numanu sumbi-nimba pílima molemulu. Yunga ungele numanu sipu piliipu molemulu.’ niku gólu toku mulungí yi mare, liiku yunu mulurumna liiku munduring. ");
INSERT INTO mux_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yi kanuma-ni oku yundu ⸤kundi toku kene⸥ niku mele: “Ung-Bo Tunjuliele, oliu piliipuliinga, ‘Nu-ni taki-taki ung-sikama mindi sumbi-siku nikunu, ung-mani sikama mindi sumbi-siku mani siku ung-bo tonjukunu tekunu kene, nu-ni yambu tiluringa kepe numanu kimbú naa sikunu, yambuma mundu-mong naa tenjikunu, eninindu pali ung tilu-siku kapula-kapula niku sikunu, Pulu Yili-ni “Teai.” nilimú uluma aima sika ungma mani siku ung-bo tonjukunu, aku-siku tellu.’ nimbu piliilimulu. ");
INSERT INTO mux_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","⸤Aku-sikunu teku molláliinga nu nambulka niku piliikunuye?⸥ Oliu-ni Rom-Gapman-Yi Aima Auli Kumbina Sisale ku-moni-takis túmulu lem kapula mola móluye? Pulu Yili-ni akiliinga ung-mani sirim ung-manele nambulka nimba pelemúye? Niku si.” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Akiliinga-pe Yesos-ni enini yunu teku kis-singíndu aku-siku liiku lu siku walsiringele piliipa kene eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“⸤Ku-takis tolemele⸥ ku-mong te na liiku ora sai.” ⸤nimba kene eninindu kelepa walsipa piliipa kene nimba mele:⸥ “Ku-moni ilinga naenga kumbi-kerale kene bili kene molemúye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Enini yunundu niku mele: “Rom-Gapman-Yi Aima Auli Kumbina Sisale-nga ⸤kumbi-kerale kene bili kene molemú⸥.” niring. Kanu-kene yu-ni eninindu nimba mele: “⸤Ku-moni akili Sisale-nga ku-monele⸥ akiliinga Sisale-nga mélema Sisale yunu siku, Pulu Yili-nga mélema Pulu Yili yunu sai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yu-ni aku-sipa ⸤aima sumbi-sipa⸥ nirim mele akili piliiku kene ‘Oliunga ungele aima pundu topa kene nimba konjukumu.’ niku piliiku numanu pulele liiku mundukuliinga ung te alsuku naa niring. Yambuma kanuku molangi yu liiku lu siku walsiring kene yu-ni ung te nimba kis naa sirimeliinga “Yunu ka samili.” ningí kupulanum te naa lirim. ");
INSERT INTO mux_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","⸤Yi kanuma Yesos-kene ku-moni-takis tuli ungele niku pora siring kene⸥ penga Sadusi-yi mare Yesos mulurumna uring. Sadusi-yi kanuma enini ‘Pulu Yili-ni kolemele yambuma topa naa makinjimba, lomburuku ola naa mulungí.’ niku piliiku muluring talapele. Sadusi-yi kanuma oku ");
INSERT INTO mux_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Yesos walsiku piliiku kene niku mele: “Ung-Bo Tunjuliele, ⸤Pulu Yili-nga ung-manima oliu sirim yi⸥ Moses-ni ung-mani sipa kene nimba mele: “Ambu liimba yi te kangambula naa memba kene ambale we mulupili yili kolumba kene yi kanili yunga angin molumbále-ni yunga ambu-wayele liipa angin liipa tapunjupa kangambula minjipili.” nirim aku-sipa nimba bukna turum molemú kanili. ");
INSERT INTO mux_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","⸤Ung-mani akiliinga ulu te oliunga yi mare-kene wendu urum mele nu walsipu piliamili.⸥ “Anginipili-yi angere yupuku-guli muluring. Komale ambu liipa kangambula te naa memba kene pe yunu kulurum. ");
INSERT INTO mux_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","⸤Kangambula te naa mulupili kulurum kilia⸥ yunga bulkundu anginele-ni ⸤yunga angin kulurumeliinga kangambula ‘Menjambu.’ nimba⸥ ambu-wayele kelepa liirim. Yunu kangambula te naa-ko menjipa kene yunu we kulurumko. Yunga angin bulkundele-ni ambu kanili liirimko akiliinga-pe yunu kepe we kulurumko. Aku telsiliiku puku kene yi angere yupuku-guli pali kangambula tilu kepe naa meku kene kolku pora siring kene akeleale kamu we kulurumko. ");
INSERT INTO mux_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Penga ambale yunu kulurumko. ");
INSERT INTO mux_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akiliinga, kolemele yambuma penga lomburuku ola mulungí kene ambu kanili yi angere yupuku-guli pali ya mana liiringeliinga ambale yunu yi aima naenga min molumbaye?” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesos-ni eninindu pundu topa nimba mele: “Ya ma-koleana molemele yambumanga yima ambu liiku, ambuma yi puku telemele ");
INSERT INTO mux_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","akiliinga-pe Pulu Yili-ni ‘Yambu kolku kene kapula lomburuku ola molku mulú-koleana puku molangi.’ nilimú yambumanga yima ambu naa liiku, ambuma yi naa puku, aku aima naa tingí. ");
INSERT INTO mux_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yambu kanuma lomburuku ola molkuliinga enini mulú-koleana angkellama molemele mele aku-siku molkuliinga, kelku kulú naa kolku kene Pulu Yili-nga kangambulama mulungí. ");
INSERT INTO mux_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Akiliinga-pe ⸤enini Sadusima-ni⸥ ‘Kolemele yambuma lomburuku ola naa mulungí.’ niku piliilimeláliinga ung te kamu niambuko. Moses-ni oliu liipa ora sirim mele niambu: Walse Moses unji walú tenga ⸤tepi nomba pirim tepéle-ni unjele naa nurum-na kanupa kene,⸥ akuna yu-ni ⸤Pulu Yi⸥ Yawe-ndu bi lepa kene nimba mele: “Eprayam kene, Aisak kene, Jekop kene eninga Pulu Yili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pulu Yili yunu kululi yambumanga Pulu Yili mólu. Yunu yambuma pali kona molemele kanupa kene yu kona mululi yambumanga Pulu Yili.” nimba Yesos-ni nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","40","Aku-sipa nirim piliiku kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani siring yi mare-ni alsuku yunu ung te walsiku piliingíndu pipili kolku mundu-mong teku kene yundu niku mele: “Ung-Bo Tunjuliele, nu-ni kapula nikinu.” niring. ");
INSERT INTO mux_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kanu-kene ⸤Juda-yambumanga yi-auli mare aku-siku we muluring kene⸥ Yesos-ni eninindu alsupa ung te nimba mele: “‘Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim Kraisele yunu ⸤yi nuim king⸥ Depit-nga kalupa liimba yi te molumba.’ niku piliilimili, ⸤akiliinga-pe yunu aku-sipa mindi mólu⸥. ");
INSERT INTO mux_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","⸤Aku-siku nilimele yima-ni⸥ Depit yu-ni yunu ⸤yi kanilindu nirim akili naa piliilimilinje.⸥ Depit-ni ⸤yi-nuim Kraisele molumba mele⸥ konana te numanale-ni piliipaliinga bukna turum akili i-sipa mele: “Auli ⸤Pulu Yi Yawe-ni⸥ nanga Auliele-ndu nimba mele: “‘Nunga ele-túma nu-ni nokani.’ nimbu, penga enini topu mania mundunjumbu akiliinga isili-ui nu ⸤na-kene wasie tapú topulu yi-nuimsele molupulu mélema nokambili⸥ nanga ki-bokundu okunu molui.” nirim.” nimba Depit-ni aku-sipa nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Depit-ni ⸤yi-nuim Kraisele⸥ yunundu “Nanga Auliele.” nirim. Penga eni “Yunu Depit-ni kalupa liimba yili molumba.” nambi-siku piliikuliinga nilimeleye?” nimba Yesos-ni nirim. ");
INSERT INTO mux_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yesos mulurumna yambu pulele liiku máku toku muluringma piliiku molangi Yesos-ni yu lumbili anduli yimandu ⸤lip-lipi topa⸥ ung te nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Eni Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuli yima mimi-siku kanuku ⸤enini telemele mele manda leku naa teku⸥ molai. ⸤‘Yambuma-ni oliu kanuku “Yi kaíma” niangi.’ niku⸥ yi kanuma-ni wale-pakuli aima sulu kaíma, ⸤yi-nuimima pakolemele mele,⸥ pakuku andolemele. Yambuma máku toku molemele koleamanga andungíndu mong-keng leku ‘We-yambuma-ni oliu kape niangi.’ niku piliiku kene numanu silsiliiku anduku molemeleko. Yambuma liiku máku toku Pulu Yili-nga ungele piliilimili lkuna lkundu puku kene mania mulungíndu yi-aulima molemele polu kaí akuna ‘molamili.’ niku kumbina puku polu akuna numanu siku molemeleko. Yambuma-ni langi noku yambumandu “Wasie namili wai.” nilimele kene yi kanuma oku kene yi-aulimanga polu kumbina ‘oliu molamili.’ niku numanu siku molemeleko. ");
INSERT INTO mux_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“Yima kolemele kene enini yi kanumanga ambu-wayema toku makuruku munduku kene lkuma ‘Oliunga’ niku we liilimele. Pulu Yili-kene popu toku ung ningíndu niku sulu munduku gólu toku nilimele. Pulu Yili-ni we-yambuma ulu-pulu-kis telemeláliinga enini sika “Mindili nai.” nimbá akiliinga-pe ya yi nikeruma-ni ulu akuma telemeláliinga Pulu Yili-ni yi akuma “Mindili aima lakuku nai.” nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesos ⸤Pulu Yili popu toku kaluring lku-temboll lku-kerina molupa⸥ lku-tembolluna sukundu kongun tingí ku-moni munduring unji-mingi tenga nondupa mulurum. Akuna molupa kene olandu-sipa kanupa kene yi-kamakoma-ni mingi kanuna ku-moni oku munduring mele kanurum. ");
INSERT INTO mux_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","⸤Aku-sipa kanupa mulurum kene⸥ ambu-waye aima korupa te omba yunga ku kululi tale mindi mundurum kanupaliinga ");
INSERT INTO mux_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","nimba mele: “Na-ni enindu aima sika nimbu siker: “Andi ambu-waye korupale yu-ni ku-moni mundukumele aima ola-kilia mele mundukum, we-yambu ku-moni mundukumelema mania-kilia mele.” niker. ");
INSERT INTO mux_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Enini ku-moni pulele nosulimelemanga koltale mindi oku mundukumele. Akiliinga-pe ambu-wayele ku-moni te aima naa nosilimú. Yunga koltale nusum-sele pali memba omba mundum. Langi nombá te kepe naa nosilimú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kanu-kene Yesos kene yu lumbili anduli yima kene enini ⸤Pulu Yili popu toku kaluring⸥ lku-temboll akuna molku kene lku-temboll aima kaí angiliirim mele kepe lku-tembollale takuring ku-mulú aima kaí lupa-lupa kepe ku akuma-ni au siring mele kepe kanuku, mare-ni ung anju-yandu niku muluring kene Yesos-ni eninindu nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ya ⸤lku-temboll kaí angiliimú⸥ kanokumele mélema ⸤penga walse ya kolea-auli Jerusallem yambuma mindili nungí enale wendu ombá kene⸥ lku-tembollale tekisiku kene kuma pali toku kalalu singí.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesos-ni aku-sipa nirim piliikuliinga enini yunundu walsiku piliiku kene niku mele: “Ung-Bo Tunjuliele, nu-ni nikinu mele te-kene wendu ombáye? Penga nu-ni nikinu ulu ima nondupa wendu ombáliinga ui nambulka ulu te temba kene oliu-ni kanupu kene ‘Sika wendu ombá tepam lam.’ nimbu piliimulúye?” niku walsiring kene ");
INSERT INTO mux_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","yunu-ni eninindu nimba mele: “⸤Ulu kanuma wendu ombáliinga ung mare⸥ yambuma-ni eni gólu toku singéliinga kanuku piliiku kongnjuku molangi. Yi pulele-ni oku na moliu mele lupa-lupa gólu toku niku mele: “⸤Pulu Yili-ni ‘Nanga yambuma nokupa kunjupili liipu mundumbu.’ ui nimba makó turum yi-nuim Krais⸥ akili na.” niku kene, “⸤Male pora nimbá⸥ ena nirimele wendu ombá tekem.” ningíko. Enini lumbili naa pai. ");
INSERT INTO mux_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kolea marenga ele lakuku tingí mele piliiku, yambuma-ni eninga yi-nuimima tungí akili piliikuliinga mini-wale naa mundai. Ele tingíma kene ulu akuma Pulu Yili-ni ‘Ui wendu upili. Laye penga mele ya ma-koleale pora nimbá.’ nimba, nimba panjurumeliinga ulu akuma sika wendu ombá akiliinga-pe aku-kene mulú-masele ui naa pora nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kanu-kene Yesos-ni yu lumbili anduli yimandu alsupa nimba mele: “⸤Mulú-masele pora nimbá enale ui wendu naa upili buni auli mare wendu ombá.⸥ Yambu-talape auli te kene talape auli te kene ele tekulu, yi nuim king marenga talapema kene marenga talapema kene ele tingíko. ");
INSERT INTO mux_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ya ma-kolea lupa-lupamanga ma jim-jim lakupa tepa, engle lepa, kuru auli mare wendu omba, aku-sipa temba. Yambuma lakupa tepa mundu-mong tenjimba ulu-tonduluma mulúna wendu ombá kanungíko. ");
INSERT INTO mux_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Aku-sipa mele ⸤penga wendu ombá akiliinga-pe⸥ ui naa wendu upili eni nanga yambuma mulungéliinga eni ⸤mare⸥ ambolku liiku, teku kis-singí. Eni ⸤mare⸥ Juda-yambuma máku toku Pulu Yili-nga ungele piliilimili lkumanga liiku meku puku ⸤akuna kot tenjiku⸥, eni ⸤mare⸥ ka-lkuna meku puku panjiku, eni ⸤mare ka siku⸥ yi nuim kingima kene gapman yi-aulima kene mulungína ⸤kot tinjingíndu⸥ meku pungíko. ");
INSERT INTO mux_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","⸤Ka siku kot tinjingí kene kot-na angiliiku kene yi kanuma kene yi kanuma nukungí yi-nuimima kene⸥ enini ‘Nanga ungele piliangi.’ niku, enini niku singí. ");
INSERT INTO mux_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Eni ka siku kot tinjingí kene ‘Eninga kerima kene numanuma kene tondulu pupili.’ nimbú kene eni ningí ungma eni teku kis-singí tingí yambuma-ni enindu ung ningí mele pundu tungíndu piliiku sundungí. Akiliinga eni ui oku ka naa sangi ‘Kotna nambulka ung te nimulúnje? Oliu ung te walsiku piliingí kene nambulka ung te pundu topu nimulúnje?’ niku mini-wale naa mundai. ");
INSERT INTO mux_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Eninga kandi aminiali laniali kepe angenali kepe, pulu lemba yambuma kepe, akuma-ni kepe eni mare liiku ka siku kot tenjiku kene eni mare toku kunjingíko. ");
INSERT INTO mux_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nanga yambuma mulungéliinga yambuma-ni pali eni-kene numanu kis panjingí. ");
INSERT INTO mux_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Akiliinga-pe eninga kangina ulu te naa tepa pengi-dima kepe te aima omba mania naa pumba. ");
INSERT INTO mux_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","⸤Nanga yambuma mulungéliinga enini eni aku-siku teku kis-singí kanu-kene⸥ na munduku naa kelku tondulu munduku mulungí yambuma kona molku konjuku mindi puli ulu-pulele liingí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Penga walse, ami-yima ya kolea-auli Jerusallem-yambuma tungíndu oku liiku poku teku mulungí kanukuliinga Jerusallem-yambu ima toku mundungí enale nondupa wendu ombá akili liiku manjingí. ");
INSERT INTO mux_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","⸤Aku-siku mele wendu ombá kanuku kene ‘Buni aulima wendu ombá tekem.’ niku piliiku⸥ kolea Judia distrik lirim koleamanga mulungí yambuma ⸤eninga koleama munduku kelku⸥ ma-pangi lembamanga takara toku puku, Jerusallem sukundu mulungí yambuma wendu oku takara toku puku, Jerusallem ulsukundu mulungí yambuma alsuku sukundu naa pangi. ");
INSERT INTO mux_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ena akuna Jerusallem-yambuma-ni ui taki-taki Pulu Yili teku kis-siringeliinga yunu-ni “Enini mindili nangi.” nimba. Kórunga-ui yunu-ni ‘Walse aku-sipu tembu.’ nimba, nimba panjurum ung kanili yunga yi mare-ni yunga bukna turing molemú kanili. ");
INSERT INTO mux_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","⸤Pulu Yili-ni⸥ Jerusallem-yambuma arerembi kolupaliinga ‘Ami-yima enini-kene arerembi kolku oku tangi.’ nimbá kene ulu buni tili pulele enini mulungína wendu ombá. “Aku-sipa wendu ombá kene ambu kangambula munjúlima kene, ambu kangambula ame sílima kene, ⸤enini kapula lkisiku takara toku naa pungéliinga⸥ enini-kene aima buni wendu ombáliinga enini kondu tekem. ");
INSERT INTO mux_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jerusallem-yambuma tungí enamanga yambu tuli lu-koyama-ni yambu mare toku kunjingí, mare ka siku kolea sulu lupa-lupamanga meku pungí. Juda-yambumanga talapena ulsukundu mululi yambuma ya Juda-yambumanga kolea-auli Jerusallem sukundu oku toku munduku kolea liiku alko toku mulungí. Kanu-kene penga Pulu Yili-ni ‘Eninga enama pora nipili.’ nimbá kanu-kene Juda-yambuma Jerusallem kelku oku mulungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“⸤Aku-sipa mindili nungí niker uluma wendu ombá kene⸥ enána kene kaliimbuna kene kombukantupumanga kene ⸤pali⸥ uluma temba yambuma-ni kanukuliinga piliingí. Ma-koleana numú-kusale ung aima auli-tepa nimba, aima auli-tepa topa lombeya-mambeya lepa no tomba kanungíko. Ulu aku-sipa wendu ombá kene yambu-talapema mini-wale mundungí. ");
INSERT INTO mux_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mulúna ola pelemú méle-tonduluma lop-lope tepa anju-yandu pumba kene yambuma mundu-mong aima lakuku teku ‘Ma-koleana nambulka ulu te wendu ombá tekemunje?’ niku piliiku numanu aima pulele liiku mundungí. ");
INSERT INTO mux_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ulu akuma wendu ombá kene Mania Omba Mana-Yi Au Talurum Yili tondulu puliele kene, tondulu talang lakupa puliele kene, kupa tenga suku molupa, kamu mania ombá ⸤kene⸥ yambuma-ni kanungí. ");
INSERT INTO mux_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Ulu akuma pulu monjupa temba kene Pulu Yili-ni eni ulu-pulu-kismani ka sipa nokulemáliinga mindili siku molemele koleana wendu liipa, yu-kene kamu tapú-toku kapula mulungí kolea kaína sukundu liimba enale nondupa wendu ombá akiliinga ulu akuma wendu ombá kene eni ola angiliiku olandu-siku kanai.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","⸤Yesos-ni aku-sipa nimbaliinga, yunu ombá enale ‘Piliangi.’ nimba⸥ ung-eku te topa kene nimba mele: “Unji-pikma kene we-unjima pali kuku topa gomú tolemú kene kanuku kene ‘Ekupu kaliimbu temba kaliimbele wendu ombá tekem lem.’ niku piliilimili. ");
INSERT INTO mux_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Aku-sipako ulu ima “Wendu ombá.” nikerele sika wendu ombá kene kanuku kene, “Pulu Yili yi nuim kingele molumba enale nondupa wendu ombá tekem.” niku piliingí. ");
INSERT INTO mux_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na-ni enindu aima sika nimbu siker: “Ekupu molemele yambuma ui naa kolangi ⸤“Wendu ombá.” niker⸥ ulu ima pali wendu ombá. ");
INSERT INTO mux_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mulú-masele pora nimbá akiliinga-pe nanga ung niliuma aima pora naa nimbá. ⸤Niliu mele pali aima sika wendu ombá.⸥” niker.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Akiliinga, naa kanuku mulungí kene ena kanili ombáliinga aima mimi-siku piliai! Lopa te yunga tápu andolemúna ‘Pumbú.’ nimba olemú kene milu leku panjilimelale naa kanupa ‘Yunu tomba.’ nimba naa piliipa walu-sipa olemú kene penga miluna walsekale tolemú, aku-siku ulu-pulu-kísima numanu siku teku, eni no-tonduluma noku kelep toku, ma-koleana mélema-ni buni sipili numanu kimbu-siku molku, numanuna puralé naa nipili mulúngi lem ⸤Mania Omba Mana-Yi Au Talurum Yili⸥ yunu ombá ena kanili eni naa liiku manjangi liipa sinjipa wendu ombá akiliinga kanuku piliiku kongnjuku molai. ");
INSERT INTO mux_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ena akili ma-koleana pali yambuma mulungína wendu ombá akiliinga ");
INSERT INTO mux_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","eni Pulu Yili-kene popu toku mawa tekuliinga niku mele: “‘Na penga Mania Omba Mana-Yi Au Talurum Yili-nga kumbi-kerina pupu ola angiliimbu akiliinga na tondulu pupili, ulu wendu ombá ima-ni na topa mania naa mundupili.’ ni.” niku taki-taki kanuku piliiku kongnjuku molai!” nirim. ");
INSERT INTO mux_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesos-ni enamanga taki-taki lku-tembolluna yambuma ung-mani sipa ung-bo tonju-pui-upui tepaliinga, sumbulsuli taki-taki Jerusallem ulsukundu pupaliinga ma-pangi te ‘Unji-Ollip Punie Lili Ma-Pangiele’ nili akuna ola pupa pi-pui-upui tirim. ");
INSERT INTO mux_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yambuma pali aima ipulam-ui ‘Yunu ung-bo tonjupa mani simbama piliamili.’ niku lku-tembolluna oku liiku máku tu-pui-upui tiring. ");
INSERT INTO mux_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","⸤Juda-yambuma-ni puniemanga taki-taki kolea-auli Jerusallem oku akuna sukundu⸥ Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum akili mele piliiring enama, akili bi leku ‘Pllawa Tepa Auli Mundulimú Méle Yis Akili Naa Munduku Pllawa We Kalku Nuring Enale’ niringko, ena akili nondupa wendu urum kene ");
INSERT INTO mux_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yi kanuma kene, enini Yesos toku kunjingí kupulanumele koruku muluring akiliinga-pe enini “Oliu yambuma-ni kanangi yunu ka simulú kene yambuma-ni oliu-kene arerembi kolku ung-mura singí.” nikuliinga mundu-mong tenjiku we muluring. ");
INSERT INTO mux_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanu-kene Yesos yu lumbili anduli yi rurepu akumanga yi Judas, yunga bi te ‘Iskeriot’ nili, kaniliinga numanuna ⸤kurumanga nuim⸥ Seten omba sukundu purum. ");
INSERT INTO mux_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","⸤Seten yunga numanuna sukundu purum⸥ kene yunu Pulu Yili popu tunjuring yi-aulima kene, lku-tembollale nukuli ele-yimanga ele-yi aulima kene, enini muluringna ombaliinga, enini Yesos ka singí kupulanumele yunu-ni akisinjimba mele enini-kene tombulku niring. ");
INSERT INTO mux_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yunu-ni temba mele nirim kene piliikuliinga enini numanu lakuku siku “Nu ku-moni te simulú.” niku, niku panjiringi. ");
INSERT INTO mux_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yunu-ni eninga ungma piliipaliinga “Kapula.” nimba, we-yambuma Yesos-kene wasie naa mulungí kene yu enini liipa simba mele kupulanumele korupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pllawa Tepa Auli Mundulimú Méle Yis Akili Naa Munduku Pllawa We Kalku Nuring Enale wendu urum kene Juda-yambuma-ni Pulu Yili-ni ui eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingíndu kung-sipsip walú te toku nungí mele piliipa kene, ");
INSERT INTO mux_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesos-ni Pita kene Jon-sele liipa mundupa kene nimba mele: “Else pukulu, Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum mele piliimuláliinga kung-sipsip walú ⸤kaluli⸥ te ekupu nomulále teku mimi te-pale.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Elsele-ni walsikulu kene nikulu mele: “Tena tepu mimi te-pambili niku piliiku nikinuye?” niringli. ");
INSERT INTO mux_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yunu-ni elselendu pundu topa kene nimba mele: “Piliale. Ne kolea-auli ⸤Jerusallem⸥ pukulu kene, yi te mingina no kolupa memba ombá kupulanum-na pukulu kanuku kumbi-nunu tekulu kene, yunu pumba mele lumbili pukulu yunu sukundu pumba lkuna lkundu pukulu kene ");
INSERT INTO mux_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","lku pulu yi kanilindu nikulu mele: “Ung-Bo Tunjuliele-ni i-sipa walsipa kene nimba mele: “Na kene nanga lumbili anduli yima kene oliu-ni Pulu Yili-ni oliunga anda-kolepalima Naa Topa Ola We Omba Purum mele piliimulúndu kung-sipsip walále tékundu nomulúye? Nomulú lku-suluminale tena lelemúye?” nim.” niale. ");
INSERT INTO mux_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aku-siku ninglí kene yu-ni else lkuliinga olakundu lku-sulumina auli te, akuna langi nuli polu te kene, mania molomulú poluma kene, mélema kene akuna ui lelemúma, liipa ora simba. Lku-sulumina akuna ⸤nomulú sipsip-walále⸥ teku mimi teale.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kanu-kene elsele pukulu kene, Yesos-ni nirim kanu mele ulu akuma tili lirim kanukululiinga, akuna Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingí kung-sipsip walú nungéle kene langi nungíma teku mimi tekulu nusiringli. ");
INSERT INTO mux_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Juda-yambuma-ni ipinjali kolea kalá turum kene Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum Enale piliingíndu kung-sipsip walú ⸤kaluliele⸥ nungí ena-mongale kamu ola urum kene, Yesos kene yunga kongunale ‘tenji-pai.’ nimba liipa mundurum yi kanuma kene enini keri-langi nuli poluna muluring. ");
INSERT INTO mux_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Langi noku muluring kene yunu-ni eninindu nimba mele: “‘Na mindili ui naa nambu. Pulu Yili-ni anda-kolepalima Naa Topa Ola We Omba Purum ena piliimulúndu langi ima nolemulu langima ui eni-kene wasie aima namili! Penga mindi mindili nambu.’ nimbu aima tondulu mundupu numanu kimbú sipu andupu mulurundu akili mele ekupu kepe aku-sipuko aima numanu kimbú sipu moliu. ");
INSERT INTO mux_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na-ni enindu i-sipu nimbu siker: ‘Ekupu langi nokomulu ima na alsupu naa nombú. Penga Pulu Yili yi nuim kingele kamu molumba enale wendu omba kene langi imanga sika ulu-pulele wendu ombá kene alsupu nombú.’ niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Yunu no-waen kapale liipa ambulupa kene Pulu Yili-ndu “Angke” nimba kene eninindu nimba mele: “Ili eni-enini moke teku nai. Na-ni enindu i-sipu nimbu siker: “Isili-ui na no-waen ili alsupu aima naa nombú. Penga mindi, Pulu Yili yi nuim kingele molupa nokulemú enale wendu ombá kene na no-waen konale kelepu nombú akiliinga ⸤eni-enini isili-ui nai⸥.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bret te liipa Pulu Yili-kene “Angke” nimba kene ambulupa puka topa ⸤yu lumbili anduli yima⸥ sipa kene nimba mele: “Ili nanga kangiele ⸤eni liiku nai⸥. Nanga kangiele ‘eninga’ ninjipu ⸤‘Na tangi.’ nimbu⸥ simbu teker ili. Penga-penga kepe, ‘eninga’ nimbu tenjimbu teker akili mele ‘Alsupu piliimulú.’ niku bret ili “Nanga kangiele.” nimbu siker mele eni aku-siku bret te noku kene liiku manjai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Penga enini langima noku pora siring kene yunu-ni ⸤bretele-kene tirim mele⸥ aku-sipako no-waen kapale liipa kene ⸤enini sipaliinga⸥ nimba mele: “No-waen ⸤eni siker⸥ ili nanga memale. ⸤Pulu Yili-ni ‘Enini-kene tembu.’ nimba,⸥ ung te nimba panjipa mi lirim ung kona kanili ‘Kamu wendu omba pípili.’ nimbu na-ni eninga ninjipu nanga memale onde lepu kene ⸤kolumbu⸥ memi akili no-waen ili. ");
INSERT INTO mux_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Akiliinga-pe na liipa nanga ele-tu yima simba yili na-kene wasie langi nokomulu polu ilinga molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","“Ekupu Mania Omba Mana-Yi Au Talurum Yili kene tingí mele Pulu Yili-ni kórunga-ui nimba panjurum akili sika ele-túma-ni tingí, akiliinga-pe yunu liipa ele-tu yima simba yili mindili nomba molupa kis-simba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aku-sipa nirim kene piliikuliinga ⸤yu lumbili anduli yima-ni⸥ anju-yandu tombulku walsiku kene niku mele: “Oliunga yi nae-ni ulu akili tembanje?” niring. ");
INSERT INTO mux_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ena akili kene ung te wasie wendu urumko. ⸤Yesos lumbili anduli yima-ni⸥ eni-enini anju-yandu tombulku nikuliinga niku mele: “Oliunga yi nae aima ola-kilia molemúye?” niku gelema-nele meku muluring. ");
INSERT INTO mux_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesos-ni eninindu nimba mele: “Oliu Juda-yambumanga wendukundu molemele yambu-talapemanga yi-nuimima eninga yambuma tondulu munduku nokuku kongun tondulu púlima taki-taki silimele. Yi bi ola molemú yi kanuma eninga yambuma ‘Mindili nangi.’ niku nokolemele yima-ni eni-enini bi paka toku, “Oliu yambuma nokupu konjupu liipu tapunjuli yima.” nilimele. ");
INSERT INTO mux_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Akiliinga-pe ⸤we-yambumanga yi-nuimima-ni eninga yambuma tondulu munduku nokolemele mele na lumbili anduli yima⸥ eni-enini aku-siku anju-yandu naa teai. Eninga yi tenga bili ola molumba kene yi akili yi-korupa akili mele mulupili. Yi-nuim molupa we-yima nokumba yili kendemande-yi akili mele molupa we-yimanga kongun tinjipili.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Yi nae aima yi olandupaleye? Langi nolemú yili yi olandupale mola langi peki topa kalupa pllet lumaye topa kendemande-kongun akuma tenjilimú yili yi olandupaleye? Langi nolemú yi akili yi-nuimele lem. Aku-sipa, akiliinga-pe na aku-sipa mólu. Na ⸤sika eninga yi-auliele⸥ akiliinga-pe eninga kongun tinjili kendemande-yili mele molupu eni liipu tapunjuli yili moliu.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","⸤Yesos-ni yu lumbili anduli ⸤yi⸥ rurepukandu kelepa nimba mele:⸥ “Na buni membu mindili nombu mulurundu kene eni na-kene wasie tapú-topu mindili nombu mulurumuluko. ");
INSERT INTO mux_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nanga Lapa yi nuim kingele omba molupa yambuma nokumba kene nandu ‘Akuna yambuma nukunjupiliko.’ nilimú nimbá mele akili na-ni enindu ‘Akuna yambuma nokunjangi.’ niliu nimbúko. ");
INSERT INTO mux_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Akuna na yi nuim kingele molupu yambuma nokumbu kene eni na-kene wasie langi-polu tiluna molupu langi nombu molomulú. Eni yi nuim kingismanga poluna molku kene Isrel-yambu talape rurepu nukungí.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","⸤Aku-sipa nimba kene, Yesos-ni yu lumbili anduli yi Pita-ndu nimba mele:⸥ “Saimon, pília! ⸤Kurumanga nuim⸥ Seten-ni Pulu Yili-ndu mawa tepa kene nimba mele: “Eni teku kis-singínje manda lepu kundi topu kanambu.” nirim kene Pulu Yili-ni “Kapula.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Akiliinga-pe Saimon, na-ni Pulu Yili-kene popu topu nunga mawa tenjipu kene nimbu mele: “Seten yunu-ni nu aku temba kene Pita yunu-ni na naa mundupa kelepa na piliipa mulupili.” nindu. Saimon, Seten laye-kolte piliikunu na munduku kelkunu kene, penga numanu topele tokunu na kelkunu tondulu munduku piliiku molkunu kene angenalima numanu tondulu mundunjui.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Akiliinga-pe Pita-ni nimba mele: “Auliele, na-ni nu penga mundupu kelepu takara topu pumbu nikunu nikinuye? Kapula mólale. Nu ka síngi lem na-kene wasie ka sangi. Mola nu toku kunjúngi lem na-kene wasie toku konjangiko. Olsu-kene wasie aku tíngi lem akili kapulako. ‘Mólu.’ naa nimbú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesos-ni Pita-ndu nimba mele: “Pita, na-ni nundu i-sipu nimbu siker: “Ekupu kera-kulla ui ko naa tupili nu-ni pipili kolkunu mundu-mong tenjikunu nandu gólu tokunu wale yupuku tenjikunuliinga “Yi ili yi naeye? Na naa kanoliu.” niní.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aku-sipa nimba kene Yesos-ni yu yi ⸤rurepukandu⸥ pali alsupa nimba mele: “Na-ni eni uinga ⸤‘Kongunele ti-pai.’ nimbu⸥ liipu mundurundu kene ‘Ku-moni naa meku, méle-wale naa meku, kimbu-su naa meku, we mindi pai.’ nimbu liipu mundurundu kene eni méle te mólu turum mola móluye?” nimba walsipa piliirim kene enini niku mele: “Méle tilu kepe mólu naa turum.” niring. ");
INSERT INTO mux_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yunu-ni eninindu alsupa nimba mele: “Akiliinga-pe ekupu na-kene ulu te wendu ombáliinga, ku-moni nosilimú yili ku-moni kanili liipa ambulupa, méle-wale nosilimú yili wale kanili liipa ambulupa, aku-siku teku molai. Ele tili lu-koya naa nosilimú yili yunga wale-pakuli te anju sipa lu-koya te yandu liipili. ");
INSERT INTO mux_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","⸤Na-ni aku-sipu nikereliinga pulele niambu:⸥ Ui yambuma-ni nandu niku Pulu Yili-nga bukna turing molemú mele ekupu wendu ombá tekem akili i-sipa mele: “Yunu kene, yambu mong liiku ulu-pulu-kísima tili yambuma kene, liiku tere leku makó turing.” niring bukna molemú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yunu-ni aku-sipa nirim akili piliiku sunduku kene enini yunundu niku mele: “Auliele, ya ele tili lu-koya tale nosupu molemulu kanui.” niring kene yunu-ni eninindu nimba mele: “Ung manda nikimulu, ⸤pamulu.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanu-kene Yesos ⸤lkuli mundupa kelepa kolea-auli Jerusallem⸥ ulsukundu ombaliinga yunu taki-taki Unji-Ollip-Punie Lili Ma-Pangina ola pu-pui-upui tirim aku mele akuna Yesos purum. Yu lumbili anduli yima yunu lumbili aeleku wasie puring. ");
INSERT INTO mux_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akuna purum kene yunu-ni yu lumbili anduli yimandu nimba mele: “⸤Kurumanga nuim⸥ Seten-ni ‘Oliu kundi tomba kene tepu kis-simuláliinga’ niku kene Pulu Yili-kene popu toku mawa teku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Aku-sipa nimbaliinga yununu laye-kolte anjupa pupaliinga koporungu langupa, Pulu Yili-kene popu topa mawa tepa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tata, na ⸤mindili nuli⸥ no-mingina no nombále ‘Naa nambu.’ nikunu pilíínu lem aku-sikunu teani akiliinga-pe ‘Na-ni tepu kene nanu numanu simbu.’ nimbu piliiker akili mele naa teambu. Nu-ni kanukunu kaí piliiní ulele mindi teambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aku-sipa nirim kene angkella te-ni mulú-koleale mundupa kelepa Yesos yunu mulurumna omba ‘Yunu numanu tondulu pupili.’ nimba tirim akili mele Yesos-ni yunu kanurum. ");
INSERT INTO mux_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kanu-kene yunu numanuna buni lakupa liipa, mundu-monguna mindili tipili molupaliinga yunu-ni Pulu Yili-kene tondulu mundupa popu topa mawa tirim-na yunga kangina kúru omba kúru kanili memi mele mana mania purum. ");
INSERT INTO mux_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yunu-ni Pulu Yili-kene aku-sipa popu topa ung nimba molupa kene ola angiliipa yu lumbili anduli yima muluringna yandu omba kanurum kene yunga kondale-ni eninga mundu-mongma mi lirim kilia uru piring kanupa kene ");
INSERT INTO mux_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","eninindu nimba mele: “Eni uru nambimuna pekemeleye? ‘⸤Kurumanga nuim Seten-ni⸥ oliu kundi tomba kene tepu kis-simulú akiliinga’ niku kene ola molku Pulu Yili-kene popu toku mawa teku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesos-ni aku-sipa nimba mulupili enini muluringna yi pulele uring. Yi uring kanumanga kumbi-lepa memba urum yili yu Judas, Yesos lumbili anduli yi rurepunga yi te. Judas yunu Yesos mulurumna nondupa omba yunu kanglurum. ");
INSERT INTO mux_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aku-sipa tirim kene Yesos-ni yunundu nimba mele: “Judas, ele-tu yima-ni Mania Omba Mana-Yi Au Talurum Yili ‘kanuku bi siku ka sangi.’ nikunu nu-ni na kanglkunuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kanu-kene Yesos-kene wasie tapú-toku angiliiring yima-ni yunu-kene ulu wendu ombá tirim akili kanukuliinga enini yunundu niku mele: “Auliele, ele tili lu-koyama-ni yi ima tamiliye?” niring kene ");
INSERT INTO mux_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","eninga yi te-ni ⸤yunga lu-koyale liipa ambulupa kene⸥ Pulu Yili popu tunjuring yi-auli olandupaliinga kendemande-yi tenga kumele topa laká lirim kene kumele omba mania purum. ");
INSERT INTO mux_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aku-sipa tirim kanupaliinga Yesos-ni yunundu nimba mele: “Ekupu kapula, kilíí!” nimba kene yi turumeliinga kumele liipa ambulupa tambu sinjirim. ");
INSERT INTO mux_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesos ka singí uring yi kanuma i-sipa: Pulu Yili popu tunjuring yi-auli mare kene, lku-tembollale nukuli ele-yimanga ele-yi aulima kene, Juda-yambumanga tápu-yi mare, enini Yesos ka singí uring kene kanupaliinga eninindu nimba mele: “Na ‘yambu topu wa nuli yi te molemú.’ niku piliiku kene lu-koyama kene kimbulúma kene meku okumeleye? ");
INSERT INTO mux_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lku-temboll lku-kerina taki-taki eni-kene wasie molemulu kene na ambolku liiku ka naa silimele kanili. Akiliinga-pe ekupu ena wendu okum ili Pulu Yili-ni ui ‘Eninga.’ nirim ena-mongale wendu okum. Sumbulu túlieliinga tondulale kene lakupa molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kanu-kene Yesos ka siku kene Pulu Yili popu tunjuring yi-auli olandupa akiliinga lkuna sukundu meku puring. Yesos meku puring kene Pita yunu lumbili aelepa táka-nimba purum. ");
INSERT INTO mux_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yesos meku puring lku akili lku angiliipa poku tirim, sukundu we lirim koleana tepi kalku piliiku muluringna Pita pupa enini-kene mulurum. ");
INSERT INTO mux_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yunu akuna mulupili ⸤Pulu Yili popu tunjuring yi-auli olandupa akiliinga⸥ kendemande-ambu te omba tepi pa tirimna Pita mulurum kanupa bi sipaliinga yunu nem-nemi nimba kanupa kene nimba mele: “Yi ili Yesos-kene wasie muluringli kanurundu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Akiliinga-pe Pita-ni gólu topa kene nimba mele: “Ambale, nikinu yi akili na naa kanoliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Laye penga mele yi te-ni Pita kanupa kene yunundu nimba mele: “Nu Yesos-nga talape-yi te lam.” nirim kene Pita-ni yunundu nimba mele: “Yili, na akili mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Penga ena-mong tilu mele omba purum kene yambu te-ni ⸤Pita yunga ungele laye-kolte lupa mele lirim akili piliipa kene⸥ yunu-ni tondulu mundupa kene nimba mele: “Kolea Gallalli distrik yambuma-ni ung lelemele akili mele yunu-ni aku-sipa ung lekem piliiker. ⸤Yesos kene yu lumbili anduli yima kolea Gallalli distrik yimako,⸥ yunu kepe Gallalli yi te, akiliinga ‘Yunu aima sika ⸤Yesos⸥ lumbili anduli yi te.’ nimbu piliiker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Aku-sipa nirim kene Pita-ni yunundu nimba mele: “Yili, nu nikinu akili mele na aima naa piliiker.” nirim. Aku-sipa nimba mulupili kera-kulla ko turum. ");
INSERT INTO mux_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kanu-kene Yesos-ni topele topa Pita kanurum kene Yesos-ni yundu “Kera-kulla ui ko naa tupili nu-ni wale yupuku gólu tokunu kene “Yu naa kanoliu.” niní.” nirim ung kanili Pita alsupa piliirim. ");
INSERT INTO mux_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piliipaliinga ⸤‘Ama, aima tepu kis-sindu lam. ‘Aima naa tembu.’ nimbu piliirindu akili mele sika tindu.’ nimba piliipa kene⸥ pena pupa kola aima lakupa tirim. ");
INSERT INTO mux_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kanu-kene Yesos akuna nokuku muluring ele-yima-ni yunu ung-taka tonjuku, yunu lkarauwa-ni toku, tiring. ");
INSERT INTO mux_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yunga kumbi-kerale múlu te-ni pipi sinjiku kene ki-kumu-ni toku ⸤“Nu ‘Pulu Yili-nga yi te moliu.’ niku piliillu kaniliinga⸥ nae-ni nu tokumnje nikunu si.” niring. ");
INSERT INTO mux_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ung-taka tunjingindu enini yunu aku-siku mele ulu pulele teku ung pulele niku yunu aku-siku teku kis-siring. ");
INSERT INTO mux_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kolea tangurum kene Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, Juda-yambu kanumanga tápu-yi kanjolluma pali ‘Yesos-nga kotele piliimulú.’ niring. ⸤Eninga ele-yima-ni⸥ yunu enini liiku máku toku muluringna meku puring kene enini yunundu niku mele: ");
INSERT INTO mux_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Pulu Yili-ni oliu “Nokupa konjumba yili liipu mundumbu.” ui nimba makó turum yi-nuim Kraisele sika nu mola móluye? Nikunu si.” niring. Yunu-ni eninindu nimba mele: “‘Na akili moliu.’ nilkanje eni naa piliiku “Gólu tokunu.” nilkimela. ");
INSERT INTO mux_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na-ni enindu ung te walsipu piliilkanje yandu ung te naa-ko nilkimela. ");
INSERT INTO mux_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Akiliinga-pe Mania Omba Mana-Yi Au Talurum Yili ekupu kepe penga kepe tonduluma pali pelemú Pulu Yilu⸤-kene mélema nokumbaliinga⸥ yunga ki-bokundu molumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Enini pali yunundu niku mele: “Nu ‘Pulu Yili-nga Málale moliu.’ niku nikinuye?” niring kene yunu-ni nimba mele: “Akili na moliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Enini niku mele: “Yunu-ni mong liirim akili mele nimba simba yambu te wasie nambimuna korumulúye? Yunu-ni yunu nimba kis-sikem piliikumulu ili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aku-siku nikuliinga Juda-yambumanga yi-aulima pali ola angiliiku Yesos liiku meku puku ⸤Rom-gapman yi-nuim⸥ Paillet mulurumna meku puku kot tinjiring. ");
INSERT INTO mux_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yu kot tenjiku kene Paillet-ndu niku mele: “Yi ili-ni nimba mele: “Rom-gapmanale-ni oliu Juda-yambuma naa nukupili.” nimba, “Rom-Gapman-Yi Aima Auli Kumbina Sisale ku-moni-takis naa tai.” nimba, “Yu-yunu “Pulu Yili-ni oliu nokupa konjumba yi te liipu mundumbu.” nimba ui makó turum yi-nuim Kraisele, yi nuim kingele moliu.” nimba molemále oliu piliipu kanolemulu.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yi-aulima-ni aku-siku niring-na piliipa kene Paillet-ni ⸤Yesos-nga kotele⸥ yu walsipa piliipa kene nimba mele: “Nu Juda-yambumanga yi nuim kingele mola móluye?” nirim. Yesos-ni pundu topa kene nimba mele: “Sika nikinu. Akili na.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aku nirim kene piliipaliinga Paillet-ni Pulu Yili popu tunjuring yi-aulima kene, we-yambu akuna liiku máku turingima kene, eninindu nimba mele: “Yi ili ulu te naa tepa kis-sim.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Akiliinga-pe enini karaye teku tondulu munduku niku mele: “Yu-ni ung-mani sipa kene “We-yambuma ulu teku kis-siku, mong liiku teangi.” nimba mani sirim. Yu-ni ui-pulu-pulu kolea Gallalli distrik ung akili mani sipa, penga yandupa kolea Judia distrik koleamanga pali ung-mani silsiliipa andupa kene, penga kamu ya kolea-auli Jerusallem omba ung akili mani sipa molemú.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","“Kolea Gallalli” niring kene piliipaliinga Paillet-ni eninindu walsipa piliipa kene nimba mele: “Yi ili yu Gallalli-yi ténje?” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","enini “O.” niring kene piliipaliinga Paillet-ni nimba mele: “⸤Yi nuim king⸥ Erot, Gallalli distrik nokulemú yili, Yesos-nga kotele yu-ni piliipili yu molemúna meku pai.” nirim. Ena kaniliinga ⸤yi nuim king⸥ Erot kanili yu Jerusallem omba mulurum kilia piliipaliinga, “Yu molemúna meku pai.” nirim. ⸤Paillet yu kolea Judia distrik, Jerusallem lirim, nukurum yili.⸥ ");
INSERT INTO mux_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erot ⸤mulurumna meku puring kene⸥ yu-ni Yesos kanupa kene numanu sirim. Yu Yesos-ni ulu-pulu tirim mele ung pulele piliipaliinga, ‘Yi akili na kanulkanje kapula!’ nimba piliipa molupa, ‘Yu-ni ulu-tondulu te tipili kanambuka!’ nimba piliipa mulurumeliinga yu urum kene kanupa numanu sirim. ");
INSERT INTO mux_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Akiliinga, Erot-ni Yesos ung pulele walsipa piliirim akiliinga-pe Yesos-ni ung te pundu topa naa nimba we mulurum. ");
INSERT INTO mux_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pulu Yili popu tunjuring yi-aulima kene, Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tunjuring yima kene, akuna angiliiku kene enini Erot-ndu niku mele: “Yesos-ni i-sipa mele ung nimba kis-sipa, i-sipa ulu pulele tepa kis-sipa molemú.” niku tondulu munduku niring. ");
INSERT INTO mux_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kanu-kene Erot kene yunga ami-yima kene enini ‘Yesos yu yi-nuim móluko, yu we-yi te.’ niku yi-nuimima-ni pakolemele mulumbale kaí te liiku pakunjuku, yunga ung-taka tonjuku tae tinjiring. Kanu-kene Paillet mulurumna Erot-ni Yesos liipa yandu mundurum. ");
INSERT INTO mux_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Paillet-ni Erot mulurumna Yesos ui naa liipa mundupili Paillet kene Erot-sele ui elsele ele-tu yisele muluringli. Akiliinga-pe Yesos-kene aku-siku tiringli enaliinga penga elsele anginingli mele-sele muluringli. ");
INSERT INTO mux_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yesos Paillet mulurumna yandu meku uring kene Paillet-ni Pulu Yili popu tunjuring yi-aulima kene, Juda-yambumanga tápu-yima kene, we-yambuma kene, “Enini wai.” nimba kene ");
INSERT INTO mux_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nimba mele: “Yi ili na moliuna meku oku kene “Yu-ni yambumandu ‘Rom-gapmanale-ni oliu naa nukupili.’ nimba ‘Enini mong liiku teangi.’ nimba molemú.” níngi. Kanu-kene eni kanuku molangi na-ni kotele piliipuliinga eni ‘Yu tepa kis-sirim.’ níngi akili na ulu te naa piliiker. ");
INSERT INTO mux_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","⸤Gallalli distrik yi nuim king⸥ Erot, yu-kene yi ili-ni ulu te tepa kis-sirim te naa-ko piliipa kene yu alsupa yandu liipa mundum. Piliikimiliye? Yu ulu te tepa kis naa sim. Yu we nambimuna topu konjumulúye? ");
INSERT INTO mux_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ulu te tepa kis naa símaliinga na-ni yu we kimbulú-ni topu kene “Kelku pui.” niambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","(Kolea-auli Jerusallem sukundu yi te, yunga bili Barapas, ⸤yu kene yi mare kene⸥ ‘Rom-gapmanale-ni oliu Juda-yambuma naa nukupili.’ niku ui Rom-gapmanale kene ele tekuliinga yambu mare toku kunjuringeliinga yu ka siring. ⸤Rom-gapmanaliinga ka-lkuna yi Barapas akili we pípili Juda yi-aulima-ni Yesos kot tinjiring⸥. Juda-yambuma-ni puniemanga taki-taki kolea-auli Jerusallem oku akuna sukundu Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum akili piliiring enama wendu urum kene Rom-gapman yi-auliele-ni ka-yi te ka-lkuna wendu liipa mundupa “Pui.” nirim.) ⸤Aku-sipa tirim mele piliiringeliinga Paillet-ni “Yesos-ndu “Pui.” niambu.” nirim kene piliikuliinga⸥ yambuma-ni pali yundu tondulu munduku kene niku mele: “Yi ili mólu. Yu ⸤kulupili⸥ meku pukunu kene, Barapas, ⸤ka-lkuna⸥ wendu liiku si.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paillet-ni ‘Yesos we pupili.’ nimbaliinga eninindu ung te wasie nirim ");
INSERT INTO mux_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","akiliinga-pe enini yundu wale pulele tondulu munduku niku mele: “Yesos kulupili unji-perana ⸤toku⸥ ku tokunu panjui!” niku muluring. ");
INSERT INTO mux_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aku-siku niring kene yu-ni eninindu alsupa wale yupuku-tenjipa walsipaliinga nimba mele: “Akili nambimunaye? Yu mong nambulka mong te líímuye? Yu ulu te tepa kis naa sim. Yu we nambimuna topu konjumulúye? Na-ni yu we kimbulú-ni topu kene “Kelku pui.” niambu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Akiliinga-pe enini karaye teku tondulu munduku kene niku mele: “Yi ili kulupili unji-perana ⸤toku⸥ ku tokunu panjui!” niring kene enini tondulu munduku niring mele piliipaliinga Paillet-ni enini niring akili mele temba tirim. ");
INSERT INTO mux_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kanu-kene Paillet-ni kotele piliipaliinga enini Yesos-kene “Aima ti.” niku karaye teku mawa tiring mele ‘Aku-sipa tipili.’ nirim kene ");
INSERT INTO mux_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","⸤yi Barapas,⸥ ‘Rom-gapmanale-ni oliu Juda-yambuma naa nukupili.’ nimba ui Rom-gapmanale kene ele tepaliinga yambu mare topa kunjurum akiliinga ka-lkuna pirim yi kanili, wendu liipa enini sipaliinga, penga enini ‘Yesos unji-perana kulupili.’ niring mele piliipaliinga “Yu-kene aku-sipa wendu upili.” nimba ami-yima sirim. ");
INSERT INTO mux_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","⸤Rom ami-yima-ni⸥ Yesos meku pungí puku kene, kolea Sairini yi te, yunga bili Saimon, yu Jerusallem pumba urum kene kanuku kene yunu ambolku liiku ka mele siku kene Yesos kolumba unji-perale liiku pendekuna ola nosunjukuliinga “Ili menjikunu yunu lumbili aelekunu pui.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yambu pulele yu lumbili puring. Ambu mare yu toku kunjingí akiliinga kola telsiliiku puring. ");
INSERT INTO mux_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanu-kene Yesos-ni topele topa ambu kanumandu nimba mele: “Jerusallem ambuma, eni na kolumbaliinga piliiku kene kola naa teai. Eni-enini kene eninga kangambulama kene ulu penga wendu ombáliinga piliiku kene kola teai. ");
INSERT INTO mux_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aku-sipu nikerele, nambimuna nikerye? Niambu: Walse eni Jerusallem yambuma ⸤teku kis-siku mong liilimeláliinga buni singí⸥ enale wendu ombá kene eni kene eninga kangambulama kene mindili nungí kene yambuma-ni niku mele: “Ambu kangambula te naa meku, kangambula ame naa siku, wangnu molemele ambuma, eninga kangambula te mindili nombá enini naa kanungí akiliinga enini maluya.” ningí. ");
INSERT INTO mux_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pe ‘yambuma-ni kelku mulú-komunga auli polemúmandu “Ma angke toku oliu tupili.” niku, ma-pangímandu “Ma angke toku oliu panda tupili.” ningí.’” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","⸤Aku-sipa nimbaliinga penga kamu ung-eku te topa kene eninindu nimba mele:⸥ “Unji kona angiliimále peki tokomele. Aku lem pe unji kululiele nambi tingíye? Akiliinga ⸤enini eni aku-siku buni singí, mindili nungí⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yi tale kene wasie ‘Yesos kene kolangi.’ niku unji-perana ola ⸤toku⸥ ku toku panjingíndu meku puring. Yi akusele mong liiringli yisele. ");
INSERT INTO mux_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kolea ‘Pengí Ombele’ nílina puring kene yu kene mong liiringli yisele kene unji-pera yupukunga ola ⸤toku⸥ ku toku panjiring. Mong liiringli yiselenga te Yesos yunga ki-bokundu ⸤toku⸥ ku toku, te Yesos yunga ki-tarukundu ⸤toku⸥ ku toku panjiring. ");
INSERT INTO mux_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Aku-siku tiring kene Yesos-ni nimba mele: “Tata, na-kene tekemele mele akili yambuma-ni naa piliiku tekemele akiliinga nu-ni tekemelaliinga “Mindili nangi.” naa nikunu kanokunu konde tenji.” nirim. ⸤Aku-siku tekuliinga, ui unji-perana ola ⸤toku⸥ ku toku naa panjiku kene⸥ ui kumbi-leku yunga mulumbale ⸤posuku wendu liiku nusuringma⸥ moke tingíndu enini lupa-lupa liingíndu ku-kas teku piliiku kene penga mulumbalema liiring. ");
INSERT INTO mux_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","We-yambuma enini yu-kene tiring akili mele kanuku we angiliiringeliinga-pe eninga yi-aulima-ni yundu ung-taka tonjuku niku mele: “Yu yambu wema ‘Naa kolku kona pai.’ nimba tepa liirim mele ekupu yu-ni ‘Naa kolupu unji-perana omba wendu pambu.’ nimba yu-yunu tepa liipa unji-perana omba wendu pupili. Yu sika Pulu Yili-ni makó topa oliu ‘Nokupa kunjupili.’ nimba liipa mundurum yi nuim Kraisele omba mulúm lem ekupu yu-ni yunu aku-sipa tepa liipili.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ami-yima kene wasie yunga ung-taka tonjuku molkuliinga no-waen kumbili tili te ‘Nupili samili.’ niku singí tekuliinga ");
INSERT INTO mux_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yunundu niku mele: “Nu Juda-yambumanga yi nuim kingele mollu lem ‘Naa kolupu unji-perana wendu wambu.’ nikunu nu-ni nunu tekunu lii.” niring. ");
INSERT INTO mux_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","‘Yu mong liirim mele yambuma-ni kanangi.’ niku YI ILI JUDA-YAMBUMANGA YI NUIM KINGELE niku bi toku unji-perana olakundu munjuring. ");
INSERT INTO mux_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mong liiringli yisele unji-perana ola ⸤toku⸥ ku toku panjiring yiselenga te-ni Yesos-ndu ung-taka tonjupa kene nimba mele: “Nu “Pulu Yili-ni makó topa oliu ‘Nokupa kunjupili.’ nimba liipa mundurum yi-nuim Kraisele ⸤moliu.” nillu akili sika mola móluye? Sika aku-sikunu⸥ mollu lem nu kene olsu kene pali ‘Naa kolamili.’ nikunu teku liikunu unji-perana wendu lii.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Akiliinga-pe mong liiringli yiselenga yi te-ni kumbi-lepa yi te-ni nirim mele piliipaliinga yu ung-mura sipa kene nimba mele: “Nu kene yu kene tilu-siku mele mindili noku kolangli niku tíngeliinga nu Pulu Yili-kene mundu-mong naa tenjikunuye? ");
INSERT INTO mux_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Olsu tepu kis-sirimbulaliinga mindili kapula sikimili. Akiliinga-pe yi ili yunu mong te naa liirim.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aku-sipa nimbaliinga yu-ni ⸤Yesos-ndu⸥ nimba mele: “Yesos, nu yi nuim kingele molkunu mélema nukuni kene na pilíí.” nirim kene ");
INSERT INTO mux_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesos-ni pundu topa kene yundu nimba mele: “Na-ni nundu aima sika nimbu siker: “Ekupu nu na-kene wasie Yambuma Molku Konjulemele Kolea Kaína pupu molumbulú.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yesos unji-perana ola we pípili ai-tangili ena tuwallup killok tirim kene kolea pali sumbulú topa kene penga ipinjali ena tre killok tirim kene ena alsupa topa kolea tangurum. ⸤Ulu auli te walsekale wendu urumko. Pulu Yili popu toku kaluring⸥ lku-temboll ⸤Jerusallem sukundu angiliirim akuna sukundu Pulu Yili mulurum⸥ Sulumina Aima Kake Tili akuna keri-puluna ⸤‘Yambuma sukundu naa pangi.’ nikuliinga ui taki-taki⸥ mulumbale auli te-ni pipi siku panjiring angiliirim. Mulumbale kanili ai-suku-singina olá topa ulsu purum. ");
INSERT INTO mux_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesos-ni ung te tondulu mundupa nimba mele: “Tata, nanga mulungale ‘Nu molluna upili.’ nimbu nu siker.” nirim. Aku-sipa nimba kene yu kulurum. ");
INSERT INTO mux_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","⸤Rom⸥ ami-yi wan-andret nukurum yi te Yesos turing ami-yima nokupa mulurum yi kanili-ni Yesos ung te nimba kulurum mele piliipa kanupa kene yu-ni Pulu Yili kape nimba kene nimba mele: “Yi ili yu aima sika yi numanu sumbi-nili te lam.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kanu-kene ‘Yunu unji-perana ⸤toku⸥ ku toku panjingí kanomulú.’ niku ui liiku máku turing yambuma yunu tirim mele kanuku bulu-bale niku ung pulele numanu liiku munduku kondu kolulsiliiku eninga mundu-mongma mi lirim kilia kondu nilsiliiku lkundu puring. ");
INSERT INTO mux_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yu-kene ui tapú-toku anduring yima kene, kolea Gallalli distrik munduku kelku yu lumbili anduku ⸤Jerusallem⸥ wasie uring ambuma kene enini ⸤yu-kene tiring kulurum mele⸥ sulu-teku kanuku angiliiring. ");
INSERT INTO mux_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yesos kulurum kene yi te, yunga bili Josep, yu Juda-yambumanga kanjoll yi-auli te molupa, ulu-kaíma mendepulu tepa mulurum. Yu numanu sumbi-nili yi te, kolea Judia distrik Arimatia taon yili. Yu ‘Pulu Yili yi nuim kingele molupa oliu nokumba enale wendu upili.’ nimba nokupa mulurum yili. Yu Juda-yambumanga kanjollale sika mulurum, akiliinga-pe kanjoll-yima-ni ⸤ui eni-enini kot piliikuliinga⸥ “Yesos kulupili.” niring kene yu-ni “O.” naa nimba we mulurum. ");
INSERT INTO mux_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yi kanili-ni ⸤Rom-gapman yi-nuim⸥ Paillet mulurumna pupa, “Yesos-nga ónale na si.” nimba mawa tirim. ");
INSERT INTO mux_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Paillet-ni “Kapula.” nirim kene Josep pupa ónale mania liipa, mulumbale kona te-ni liipa kumu topa kene, ku-muru te ukuku nusiringina memba pupa suku nusurum. Ku-muru kanuna yambu-ónu te ui naa nusiring, yu mindi pulu-pulu nusurum. ");
INSERT INTO mux_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yesos ónu tirim ena akili ekupu mele, ulsulam-ukundu mele ⸤kóru muluring⸥ ena Sambatele nondupa wendu ombá tirim. Sambat enale wendu ombá kene kóru mulungíndu ekupu mele, mélema liiku undu-undu siring enale wendu urum, ena kaniliinga Yesos ónu tiring. ");
INSERT INTO mux_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ui Yesos kene kolea Gallalli distrik munduku kelku yunu kene wasie ⸤Jerusallem⸥ uring ambuma Josep-ni Yesos ónu tirim ku-murele kanuku akuna sukundu ónale nusurum mele nem-nemi niku kanuku kene, ");
INSERT INTO mux_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","penga kanuku pora siku kene yandu oku, ‘Yunga ónuna kopungu-wel-ma kene méle lupa mura túlima kene kanjimulú.’ niku teku mimi tiring. Akiliinga-pe Sambat enale wendu urum kene Pulu Yili-nga ung-manele-ni ‘Sambat enale-kene kóru molai.’ Wendu Uring 20:10, Ung-Manima 5:14 nirim mele akili piliiku liikuliinga méle teku mimi tiring mélema liiku sumbi-siku ónu-koleana naa meku puku kene we nosuku kóru muluring. ");
INSERT INTO mux_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","⸤Eninga kóru muluring⸥ ena-Sambatele pora nimba, kumbi-lepa kongun enale wendu ombándu kolea tangumba muni lirim kene ambuma kopungu mura tuli ui teku nusuringma liiku meku puku, ⸤Yesos-nga⸥ ónale nusiring ku-muruna meku puring. ");
INSERT INTO mux_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Akuna puring kene ku-muru keri-puléle pipi siring kuli perele-marele pupa merekundu tenga lirim kanukuliinga, ");
INSERT INTO mux_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","suku puring kene akuna Yi-Auli Yesos-nga ónale ui lirim kolea akuna naa lirim kanuring. ");
INSERT INTO mux_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kanu-kene ‘Ónale nambulka tímunje?’ niku numanu liiku munduku muluring kene yi tale kariyapa tepaliinga talang pulimú akili mele tili wale-pakuli pakuringli yisele enini muluringna angiliiringli. ");
INSERT INTO mux_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kanuku kene ambuma mini-wale munduku tamalu piring kene yisele-ni eninindu nikulu mele: “Kona molemále, ya ónu-koleana nambimuna korokumeleye? ");
INSERT INTO mux_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yu ya naa lelemú. Lomburupa ola molupa wendu pumu.” ⸤niringli.⸥ “Yu-ni ⸤eni-kene⸥ kolea Gallalli molupa enindu nirim mele piliai. Yu-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“⸤Juda-yambumanga yi-aulima-ni⸥ Mania Omba Mana-Yi Au Talurum Yili liiku yambu-talape lupa ulu-pulu-kis tílima yu liiku singí, enini ‘yu unji-perana kulupili’ niku ⸤toku⸥ ku toku panjingí kene kolupaliinga ena yupuku-sipaliinga lomburupa ola molumba.” nirim kanili.” niringli. ");
INSERT INTO mux_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kanu-kene Yesos-ni ui aku-sipa nirim akili ambuma-ni alsuku piliiring. ");
INSERT INTO mux_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ku-murele munduku kelku, kelku yandu oku kene, lumbili anduli yi rurepunga yupuku kene kanuma wasie muluring yambuma kene eninindu piliiku kanuring akili mele temani toku siring. ");
INSERT INTO mux_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kolea Makdalla ambu Maria kene, ambu Joana kene, Jemis anum Maria kene, enini wasie puring ambuma kene, ambu kanuma-ni Yesos-ni ui “Nanga kongunale tenji-pai.” nimba liipa mundurum yi rurepunga yupuku temani akili toku siring. ");
INSERT INTO mux_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Akiliinga-pe ambuma-ni niring ungele piliiku kene ‘Enini gólu tokomele.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Aku niku piliiringeliinga-pe Pita ola angiliipa ónale nusiring ku-muruna kanombandu lkisipa pupa kene, wake tepa kanurum kene Yesos-nga ónale kumu turing mulumbalema mendepulu akuna we lirim kanupaliinga numanu pulele liipa mundupa ‘Ili nambulka ulu te tímunje?’ nimba piliipa yandu urum. ");
INSERT INTO mux_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yesos lomburupa ola mulurum ena akuna ⸤yu lumbili anduring yambumanga⸥ yambu tale kolea-kelú Emeas punglí puringli. Kolea-kelú akili kene kolea-auli Jerusallem kene kupulanumele laye-kolte sulu tenjipa mele, illepen killomita mele. ");
INSERT INTO mux_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Elsele-ni Yesos kulurumele anju-yandu tombulku nilsiliiku puringli. ");
INSERT INTO mux_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kupulanum-na ulu akumandu tombulku nilsiliiku puringli kene Yesos yunu elsele puringlina omba tapú-topa purum, ");
INSERT INTO mux_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","akiliinga-pe Yesos-ni ‘Yu we-yi te-lupa okum niku piliangli.’ nimbaliinga aku-sipa tirim, elsele-ni yu naa kanuku bi siringli. ");
INSERT INTO mux_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yu-ni elsele walsipa kene nimba mele: “Else nambulkalendu tombulku nilsiliikulu pukumbiliye?” nirim. Elsele Yesos turing kulurumeliinga kondu niku we angiliiringli. ");
INSERT INTO mux_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tenga bili Killopas, akili-ni yunundu walsipa kene nimba mele: “Jerusallem sukundu talku ulu wendu urum-ma nu naa kanuku piliirinuye? Yambu pulele akuna oku liiku máku toku kene kanuring akiliinga-pe nu wasie naa molku kanuring lam. Tenga lupa molkunu kene ekupunga okonu lam.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yi urumele-ni “Nambulka uleleye?” nirim. Elsele-ni nikulu mele: “Kolea Nasaret yi Yesos-nga ulu kanumandu nikimbulu.” niringli. “Yesos yu Pulu Yili-ni “Ninjui” nimba, nimba silimú ungma piliipa yandu nimba sili yi te molupaliinga Pulu Yili kene oliu mana-yambuma kene kanupu molamili ung tonduluma nimba ulu tonduluma tirim. ");
INSERT INTO mux_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanu-kene oliunga niku Pulu Yili popu tunjuli yi-aulima kene oliu nokolemele yi-aulima kene ‘Yunga kotele piliiku “Kulupili.” niku tangi.’ niku ⸤Rom-gapman yima⸥ anju siring enini ‘Yu kulupili.’ niku unji-perana ⸤toku⸥ ku toku panjiring. ");
INSERT INTO mux_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Akiliinga-pe oliu piliirimulu, ‘Yu Pulu Yili-ni liipa mundurum, ⸤Rom-gapman yambuma-ni oliu⸥ Isrel-yambuma ⸤tondulu munduku nokulemeláliinga⸥ mindili nombu buni membu molemuláliinga oliu tepa liipa ⸤eninga kína⸥ wendu liipa ‘Molku konjangi.’ nimba ⸤alko topa⸥ oliunga yi nuim kingele molupa oliu nokupa konjumba.’ nimbu piliipu numanu sipu mulurumuleliinga-pe yu toku kunjuring. Akiliinga ung te wasie i-sipa: Talku turing, ekupu ena yupuku-sipa mele omba pukum. ");
INSERT INTO mux_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","“Pe ekupu ulu te lupa wendu úmko. Yu lumbili andurumulumanga ambu talse-ni ekupu oku oliu níngi mele piliipuliinga mini-wale mundúmulu. Ekupu aima ipulam-ui ambu kanuma yunga ónu tiring ku-muruna puku kanúngeliinga-pe yunga ónale naa lim. Enini oku oliundu niku mele: “Mulú-koleana angkella tale kanúmulu, elsele-ni “Yu we molemú.” níngli.” níngi. ");
INSERT INTO mux_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kanu-kene oliu-kene wasie mulúmulu yi tale ónu ku-muruna pukulu kene ambuma-ni níngi mele kanúngli, akiliinga-pe yu sika naa kanúngli.” niringli. ");
INSERT INTO mux_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aku-siku niringli kene elsele lumbili aelepa urum yili-ni elselendu nimba mele: “Else sundupa sili-pili-sele. Else numanu naa pelemáliinga ui Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni yunundu niring bukna molemú akili mele, mongale-ni kanuku kumele-ni piliikulu kene numanuna liiku meku andulkimbilánje ⸤Yesos-kene talku tiring akili mele kene yunu-ni uinga tirim ekupunga tekem akili mele kene⸥ kam-kamu piliilkimbila. ");
INSERT INTO mux_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui nimba makó turum yi-nuim Kraisele mana-mania omba kene, ya yi nikimbiliele talkunga mindi mindili nurum akili mele mindili nomba mulú-koleana yi-nuim auliele pupa molumba mele ui niku naa siringye? Niku siring kanili. Pe ekupu ui niku siring akili mele yu aku-sipa tímu.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aku-sipa nimbaliinga Moses-ni Yesos yu-ni yunu temba mele ui buk marenga topa nirim akili pulu monjupa nimba sipa, yandupa-yandupa Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima-ni yu temba mele ui buk marenga toku niring mele akili nimba sipa, Pulu Yili-nga buk akili-ni nilimú mele pali nimba silsiliipa yambusele kene kupulanum-na purum. ");
INSERT INTO mux_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yambusele puringli koleale nondupa wendu uring-na Yesos we sumbi-sipa tenga-lupa pumba tirim. ");
INSERT INTO mux_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Akiliinga-pe elsele-ni karaye tekulu kene nikulu mele: “Mólu. Ena pupa sumbulu nondupa tomba tekem akiliinga wasie piamili ⸤pamili ui⸥.” niringli kilia yu elsele-kene pupa mulurum. ");
INSERT INTO mux_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kanu-kene elsele kene wasie keri-langi noku muluring kene yu-ni pllawa kaluli te liipa Pulu Yili-kene “Angke.” nimba, ambulupa puku topa elsele sirim. ");
INSERT INTO mux_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aku-sipa tirim kene elsele yu kanukulu elsengla Auli Yesos niku kanuringli kene yunu tepa nema liirim-na alsuku naa kanuringli. ");
INSERT INTO mux_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kanu-kene else-elsele anju-yandu tombulku nikulu mele: “Kupulanum-na olsu-kene omba ung nimba Pulu Yili-nga bukele-ni nilimú mele ung-pulele nimba silsiliipa um kene olsula numanale omba pípilina pimu kanili. Auli Yesos-kene úmbulu-na aku-sipa tímu lam.” niringli. ");
INSERT INTO mux_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanu-kene elsele ola angiliikulu kelkulu sumbi-siku Jerusallem yandu okulu, lumbili anduli yi rurepunga yupuku kene enini wasie liiku máku toku muluring yambu lupama kene muluringna puringli. ");
INSERT INTO mux_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sukundu puringli kene enini elselendu niku mele: “Auliele aima sika lomburupa ola mulúm. Yununu Saimon mulumna pupa mokeringa angiliim.” niring. ");
INSERT INTO mux_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kanu-kene yambusele-ni kupulanum-na puringli kene yi te omba nirim akili mele kepe yi kanili-ni pllawa kaluli te ambulupa puka turum-na kanukulu ‘Yu Yesos.’ niku kanuringli mele akili kepe eninindu temani toku siringli. ");
INSERT INTO mux_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","⸤Yesos lumbili anduli⸥ yambuma-ni ⸤Yesos yu lomburupa ola mulurum kanuringelendu⸥ tombulku niku muluring kene Yesos yunu omba enini muluringna sumbi-sipa angiliipaliinga “Eni numanu waengu nipili molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Enini ‘Yambu kululi tenga minéle kanokumulu.’ niku piliikuliinga pung-pungu niku mundu-mong tiring. ");
INSERT INTO mux_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yu-ni eninindu nimba mele: “Nambimuna mini-wale munduku numanu tale panjiku molemeleye?” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","“Nanga ki-sele kene kimbuma kanuku ‘Ili na-nanu.’ niku kanai. Ambolku piliai. Nanga kangiele kene ombele kene angiliikim mele minimanga aku-sipa angiliimúye? ⸤Aku-sipa naa angiliimú kanili.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aku-sipa nimba kene yunga kimbu-ki pirimú turingima enini liipa ora sirim. ");
INSERT INTO mux_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanu-kene enini yu kanukuliinga numanu siku aima numanu liiku munduring akiliinga-pe ‘Sikanje mola nambulka te kanokumulunje?’ niku numanu tale panjiku we muluring kilia yu-ni enini mawa tepa kene nimba mele: “Langi nombú te yana lelemúye? ⸤Sai.⸥” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Enini yu oma kaluli te liiku siring, ");
INSERT INTO mux_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","akili liipa enini kanuku molangi nurum. ⸤‘Na kuru te naa moliu, na yambale moliu niku kanangi.’ nimba aku-sipa tirim.⸥ ");
INSERT INTO mux_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yu-ni eninindu nimba mele: “Na ui naa kolupu eni-kene molupuliinga eni ulu wendu ombá mele nimbu sirindu ulu kanili ya wendu okum. “Moses kene Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima kene enini nandu niku buk marenga turing uluma kene, Pulu Yili-nga konana niring bukna molemú konanama-ni nandu nilimú uluma kene, ulu kanuma sika wendu ombá.” nirindu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","46","Aku-sipa nimba kene ‘Pulu Yili-nga bukele-ni nilimú mele piliiku kaí teangi.’ nimba yu-ni ungmanga pulele enini nimba sipa kene nimba mele: “Bukna turing molemú akili i-sipa mele: ‘Pulu Yili-ni “Enini nokupa konjumba yi te liipu mundumbu.” nimba ui nimba makó turum yi-nuim Kraisele mindili nomba kolupaliinga ena yupuku-sipaliinga ónu-koleana lomburupa ola molumba. ");
INSERT INTO mux_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aku-sipa temba kene yi Krais kanili yunga talape-yambuma-ni yunga tondulale-ni yambuma ulu-pulu-kis tingíma piliiku kis piliiku numanu topele tungí akili kene, ulu-pulu-kis tingíma Pulu Yili-ni kanupa konde tenjipa alsupa naa piliipa “Aku-siku teku kis-siringeliinga mindili nangi.” naa nimbá akili kene, niku singíndu Juda-yambumanga kolea-auli Jerusallem pulu monjuku niku siku koleamanga pali puku kene niku silsiliiku andungí.’, ");
INSERT INTO mux_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","aku-mele nandu ui niku bukna turing. “Penga ekupu na-ni tirindu uluma kene na-kene tiring uluma kene kanuring tiring kanokumeleliinga yambuma kapula niku singí. ");
INSERT INTO mux_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Akiliinga-pe we naa teai. Pulu Yili-ni “Simbu.” nimba, nimba panjurum ⸤Minéle⸥ na-ni olandu pupu kene liipu mundumbáliinga ⸤Mini Tondulu akili yu⸥ mulú-koleana mania omba ‘Eni tondulu pupili molangi.’ nimba eni-kene molumba akiliinga ui tenga lupa naa puku Jerusallem sukundu we nokuku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesos yu lumbili anduring yambuma kolea-kelú Betani lirimna nondupa akuna memba pupa kene, ‘Pulu Yili-ni enini membu panjipili.’ nimba yunga ki-sele ola mundupa, “Pulu Yili-ni eni nokupa konjupa ‘Eni numanu tondulu pupili molangi.’ nipili.” nirim. ");
INSERT INTO mux_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eninindu aku-sipa nimba mulupili ⸤Pulu Yili-ni⸥ yu mulú-koleana olandu liirim kene enini mundupa kelepa mulú-koleana olandu purum. ");
INSERT INTO mux_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kanu-kene enini ⸤Yesos⸥ yu kape niku bi paka tonjuku kene mundu-mong liiku pípili-na panjiliiku, Jerusallem-ndu kelku yandu uring. ");
INSERT INTO mux_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Akuna puku kene ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna taki-taki molku, Pulu Yili-ni tirimeliinga “Angke” niku yu kape niku yunga bili paka tunjuring. ⸤Yesos-nga temani kaí ekendu topu pora siker.⸥ ");
INSERT INTO mux_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aima kórunga-ui, ⸤mulú-masele kepe méle te naa lipili,⸥ Ungele mulurum. Ung akili Pulu Yili-kene muluringli. Ung akili yu Pulu Yili. ");
INSERT INTO mux_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aima kórunga-ui, méle te mana naa lipili, yu Pulu Yili-kene muluringli. ");
INSERT INTO mux_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ungele yu-ni yunu mélema pali tirim. Méle te we pora naa purum. Méle wendu urum-ma pali yu-ni tirim-na wendu urum. ");
INSERT INTO mux_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mululi ulu-pulele yu-kene mindi pirim. Mululi ulu-pulu kanili yambumanga pa tinjiliele. ");
INSERT INTO mux_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pa tili akili-ni sumbulú tolemále pa tenjilimú. Sumbulú tolemále-ni alsupa pa tiliele kapula pipi sipa sumbulú alsupa naa tomba. ");
INSERT INTO mux_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yi te urumele Pulu Yili-ni liipa mundurum-na urum, yunga bili Jon. ⸤Yu No-Liinjili Jon kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jon-ni pa tinjilieliinga pulele nimba simba urum. ‘Yambuma-ni “Nondupa ombá yili yu sika pa tinjili akili.” niku tondulu munduku piliangi.’ nimba, omba nimba sirim. ");
INSERT INTO mux_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon yu pa tinjili akili mólu. Yu pa tinjili akili ombá mele nimba simba urum. ");
INSERT INTO mux_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jon-ni yambuma ung nimba sipa mulupili aima sika pa tinjiliele-ni yambuma pali pa tenjilimú kanili ma-koleana ombá urum. ");
INSERT INTO mux_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yu ma-koleana omba mulurum. Yu-ni yunu ma-koleale tirim akiliinga-pe ma-koleana yambuma-ni yu kanuku kene ‘Yu ma-koleale tirim Pulu Yili.’ niku naa kanuku ‘Yu we mana-yi te.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yu yunga koleana omba mulurum akiliinga-pe yunga yambuma-ni “Nu oliunga Auliele okonu akiliinga oliu oku nokuku mului.” ni naa niring. ");
INSERT INTO mux_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Akiliinga-pe yundu “Nu sika ⸤Pulu Yili-ni liipa mundurum-na urunu yili akiliinga⸥ oliu nokani wasie molamili ui.” niku yunga ungma tondulu munduku piliiku liiring yambuma yu-ni “Pulu Yili-nga kangambulama molangi.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Akiliinga-pe yambu kanuma Pulu Yili-nga kangambula au taluring, ulu akili kangieliinga kongun te mólu. Anupili lapalii-ni “Pulu Yili-nga kangambulama meamili.” ni naa niringko. Pulu Yili-ni yunu mindi eninindu “Nanga kangambulama.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ungele ⸤Pulu Yili kene wasie muluringliele⸥ mania omba mana-yi au talupa oliu-kene wasie ena laye-kolte mulurum. Yu mana omba mulurum kene nem-nemi nimbu kanupu kene, yu yi aima kaí, bi molemú yi tondulale, kanupu piliirimulu. Yi aima kaí tondulu kanili Málu tiluele mulurum Lapa mulurumna yu-kene wasie molkulu kene mana-mania urumeliinga yu yi aima kaíele, bi aima ola mululi yi tondulale mindi kanupu piliirimulu. Yu we kondu kululi ulu-pulele kene ung-sika nili ulu-pulele kene yunga numanuna pepa peka turum yili. ");
INSERT INTO mux_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","⸤Jon yambuma no liinjipa mulupili Yesos Pulu Yili-nga Ungele urum kene⸥ Jon yu-ni yambuma yi kanili liipa ora sipa yu mulurum mele nimba sirim. Yu-ni nangale topa kene nimba mele: “Yi ili na-ni ui enindu “Nondupa ombá.” nimbu sirindu yi kanili ili. Na naa molambu yi ili yu kórunga-ui Pulu Yili-kene wasie mulurumeliinga “Yu yi-nuim auliele, na aima we korupale.” nirindu yi kanili ili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yu-ni oliu we kondu kolemú ulu-pulele yu-kene pelemáliinga yu-ni oliu taki-taki kondu kolupa mindi molupa oliu ‘Numanu waengu sangi.’ nimba taki-taki membu panjilimú. ");
INSERT INTO mux_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moses-ni oliu Pulu Yili-nga ung-mani sirimuma mindili sipu tepu mulurumulu. Akiliinga-pe oliu we kondu kululi ulu-pulele kene sika-ungma kene ulu akuma Yesos Krais yu-kene mindi pípili urum. ");
INSERT INTO mux_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mana-yambu te-ni ui kepe, ekupu kepe, Pulu Yili naa kanolemele. Pulu Yili-nga Málu tilu mindi molemú, akili Lapa-kene wasie tapú-toku molembele, akili-ni mindi ‘Pulu Yili molemú mele kanangi.’ nimba yu liipa ora sirim. ");
INSERT INTO mux_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda-yambuma⸤nga yi-auli⸥ kolea-auli Jerusallem muluring ⸤yi kanuma-ni⸥ Pulu Yili popu tunjuring yi talse kene, LLipai-yi talse kene Jon no liinjipa mulurumna liiku munduku kene, “Jon-ndu “Nu naeye?” niku walsiku piliangi pai.” niring. ");
INSERT INTO mux_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Enini oku yu walsiku piliiring kene yu-ni gólu naa topa sumbi-sipa nimba kene nimba mele: “Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele na mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Enini “Nu yi kanili mólu lem nu naeye? Nu Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Illaija, ⸤yu kona mulupili Pulu Yili-ni ui olandu liirim akili⸥ nu kelkunu únuye?” niku walsiku piliiring. Yu-ni “Na akili mólu.” nirim. Enini niku mele: “Aku lem ‘Pulu Yili-ni ye tendu “Ninjui!” nimba ung nimba simbama piliipa yambuma nimba simba yi te penga ombá.’ ⸤ui niring yili⸥ nuye?” niring. Yu-ni “Mólu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kanu-kene enini yundu niku mele: “Nu naeye? Oliu liiku mundúngi yima-ni ‘Oku niku singí.’ niku nokuku molemeláliinga nunga bili lekunu si. Nu-ni nunu nae niku piliikunuye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon-ni nimba mele: “Pulu Yili-ni “Ninjui!” nimba ung nimba sirimuma piliipa yambuma nimba sirim yi Asaya-ni kórunga-ui nimba mele: “Kolea-wakana yi te-ni “Auliele ombá kupulanumele sumbi sinji.” nikem piliiker.” nirim. Asaya-ni ui piliirim ung kanili na-ni ekupu niker.” nimba Jon-ni nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","⸤Kanjolloma-ni⸥ liiku munduring oku muluring yimanga Perisi-yi mare muluringko. ");
INSERT INTO mux_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Perisi-yi akuma-ni yundu walsiku piliiku kene niku mele: “Nu yi-nuim Kraisele móluko, Illaija móluko, ‘Pulu Yili-ni “Ninjui!” nimba ung nimba simbama piliipa yambuma nimba simba yi te penga ombá.’ ui niring yili móluko. Pe ekupu nu nambimuna yambuma no liinjilluye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon-ni eninindu pundu topa nimba mele: “Na sika no liinjiliu akiliinga-pe nanga kongunale mania. Yi te oliunga koleana sukundu molemú akili eni kanuku kene ‘we-yi te’ niku piliiku, kanuku bi naa silimele, ");
INSERT INTO mux_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","akili nanga bulkundu aelepa okum yili. ⸤Yambu-aulimanga kongun kis tili yambuma-ni sika eninga yambu-aulimanga kongun kis tinjingíndu eninga kimbu-su ka silke toku su wendu liinjilimele akiliinga-pe⸥ yi nanga bulkundu aelepa okum ilinga kimbu-su ka silke topu su wendu liinjimbu kongunale kepe aima ola-kilia mele, na-ni kapula naa tenjimbu. Na yi aima kis mele; yu yi aima nuim auliele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ulu wendu urum ima kolea-kelú Betani taon, no Jodan nekendu lelemú koleana, wendu urum. Jon-ni akuna yambuma no liinjirim. ");
INSERT INTO mux_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ulsulam-ukundu ⸤No-Liinjili⸥ Jon mulurumna Yesos ombá urum kanupa kene, yambumandu nimba mele: “Kanai! Pulu Yili-nga Kung-Sipsip Walále okum. Yu yambumanga pali ulu-pulu-kísima kulu tonjulemú tonjumba yili okum.” ⸤nirim⸥. ");
INSERT INTO mux_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Ui na-ni yi te nirindu kanili andi okum yi akilindu nirindu. Ui na-ni nimbu mele: “Yi nanga bulkundu ombá yi te na naa molambu yu kórunga-ui mulurumeliinga yu olandupa na mandupa.” nirindu kanili yi ili. ");
INSERT INTO mux_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na kepe yu naa kanurundu akiliinga-pe ‘Isrel-yambuma yu kanuku kene piliangi liipu ora sambu.’ nimbu na ombu yambuma no liinjiliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon-ni yundu ung te wasie nimba mele: “Yu no liinjipu molupu kanundu kene Mini ⸤Kake Tiliele⸥ kera waembonu mele te mulú-koleana mandu omba yu mulumna omba yu-kene mulúm kanundu. ");
INSERT INTO mux_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na-ni yunga bili naa piliipu yu kanupu kene ‘Yu we-yi te.’ nimbu piliilka akiliinga-pe nandu “Yambuma no liinji-pui.” nimba liipa mundurum yili-ni na nimba sipa kene nimba mele: “Mini ⸤Kake Tiliele⸥ mania omba yi tenga kangi tenga ola omba molumba kanuní kene yi akili-ni yambuma Mini ⸤Kake Tiliele⸥-kene no liinjimba yili.” nirimeliinga piliipu kene yu kanupu bi sipu kene ");
INSERT INTO mux_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","enindu “Yu Pulu Yili-nga Málale.” niliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ulsulam-ukundu ⸤No-Liinjili⸥ Jon no-Jodan kélu akuna alsupa angiliipa kene, yu lumbili andúlimanga yi tale wasie angiliiring. ");
INSERT INTO mux_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kanu-kene Yesos omba purum kene yu-ni kanupa kene nimba mele: “Kanale! Pulu Yili-nga Kung-Sipsip Walále omba pukum.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yu lumbili andulisele yu-ni nirim ungele piliikulu kene Yesos lumbili puringli. ");
INSERT INTO mux_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesos topele topa elsele yu lumbili uringli kanupa kene elselendu nimba mele: “Nambulka korokumbeleye?” nirim. Elsele-ni yundu “Rapai, nu tena pelluye?” niringli. (Rapainga ung-pulele ‘Ung-Bo Tunjuliele’.) ");
INSERT INTO mux_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yu-ni elselendu “Kanangli wale.” nirim. Elsele yu pirimna puku kanukulu kene ipinjali ena po-killok mele tirim kilia ena-mong kaniliinga yu-kene wasie piring. ");
INSERT INTO mux_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yi tale Jon-ni nirim ungele piliikulu kene Yesos lumbili puringli yiselenga te Endru, Saimon-Pita-nga angin. ");
INSERT INTO mux_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Yu sumbi-sipa pupa angin Saimon korupa kanupa liipa kene yundu nimba mele: “Pulu Yili-ni “oliu nokupa konjumba yi te liipu mundumbu.” nimba makó turum yi-nuim Mesayale kanupu líímulu.” nirim. (‘Mesaya’ akili Juda-yambumanga ung te. Mesayale-ndu Grik-ungna ‘Kraisele’ nilimele.) ");
INSERT INTO mux_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aku nimba kene Endru-ni angin Saimon Yesos mulurumna memba purum. Yesos-ni yu kanupa kene nimba mele: “Nu Saimon, ‘Jon’ nili yi tenga málale. Nunga bi te ‘Sipas’ niku lingí.” nirim. (Sipas-ndu ‘Pita’ niringko. Juda-yambumanga ungna ‘Sipas’ niku, Grik-ungna ‘Pita’ nilimele, ung akuselenga pulele ‘ku’.) ");
INSERT INTO mux_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ulsulam-ukundu Yesos ‘Kolea Gallalli distrik pambu.’ nimba piliipa pumbandu purum. Pupa kene Pillip kupulanum-na angiliirim kanupa kene, “Na lumbili ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pillip kepe kolea-kelú Besaida taon yili, Endru kene Pita-selenga koleale. ");
INSERT INTO mux_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pillip-ni Nataniel korupa kanupa liipa kene yu-ni yunundu nimba mele: “Moses-ni buk turum bukmanga ‘Yi te ombá.’ nimba temani turum yi kanili kepe, Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yandu niku siring yima-ni eninga bukmanga ‘Yi te ombá.’ niku temani turing yi kanili kepe, ekupu oliu kanupu líímulu. Yu Nasaret taon yi Yesos, Josep-nga málale.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","⸤Akiliinga-pe ‘Kolea kelú akuna yi-auli te manda wendu naa ombá.’ nimba piliipaliinga⸥ Nataniel-ni Pillip-ndu nimba mele: “Nasaret taon-na ulu-kaí te kapula wendu ombáye?” nirim. Pillip-ni Nataniel-ndu nimba mele: “Okunu kanui.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kanu-kene Nataniel ombá urum kene Yesos-ni kanupa kene, yundu nimba mele: “Yi okum ili aima sika Isrel-yili, yu gólu tuli ung te aima naa pelemú yili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel-ni Yesos-ndu nimba mele: “Nu-ni na nambi-sikunu kanuku bi sikunu kene aku-siku nikinuye?” nirim. Yesos-ni pundu topa nimba mele: “Mólu. Pillip-ni nu ui naa walsipili nu unji-pik puluna mulunu kene nu kanupu bi sindu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aku nirim kene Nataniel-ni tondulu mundupa nimba mele: “Rapai, nu Pulu Yili-nga Málale, oliu Isrel-yambumanga yi nuim kingele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesos-ni nimba mele: “Na-ni ‘Nu unji-pik puluna mulunu kene kanundu.’ nindu kaniliinga nu-ni na ‘Pulu Yili-nga Málale molemú.’ niku piliikunuye? Ekupu na-ni nundu nindu mele mandupa. Penga ulu-tondulu aima olandupama wendu ombá kanuní.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aku nimba kene Yesos-ni ung te wasie nimba mele: “Na-ni enindu aima sika nimbu siker: “Penga mulú-koleale anju-yandu pupa, Pulu Yili-nga angkellama Mania Omba Mana-Yi Au Talurum Yili molumbana olandu puku mandu oku tingí kanungí.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ena yupuku-sipaliinga kolea-kelú Kena taon, akili kolea Gallalli distrik sukundu lirim, akuna yi te ambu liimbandu langi koyopa yambuma simba tirim, akuna Yesos anum-kene wasie máku toku muluring. ");
INSERT INTO mux_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yesos kene yu lumbili anduli yima kene ambu liimba yi kanili-ni “Eni kepe langi wasie namili wai.” nirim-na enini oku langi wasie nuring. ");
INSERT INTO mux_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Langi noku molangi no-waen pora nirim kene Yesos anumu-ni Yesos yundu nimba mele: “Eninga no-waenele pora nimu-na mini-wale munduku molemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesos-ni yundu nimba mele: “Ambale, na-ni ulu tembuma nunga kongun te mólu. Na-ni ulu tembu enale ui wendu naa uli.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yunga anumu-ni ⸤lku-pulu-yilinga⸥ kendemande-yambumandu nimba mele: “Yu-ni enindu “Teai.” nimbá mele aku-siku teai.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Juda-yambuma-ni no lingindu no kolku munjuring ma-mingi auli angere tale-guli akuna angiliirim. Mingimanga tenga-tenga nimba no manda munjuli wan andret llita mola wan andret teti llita mele kapula mulurum. ");
INSERT INTO mux_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesos-ni ⸤lku-pulu-yilinga⸥ kendemande-yambumandu nimba mele: “Mingi kelú marenga no puku kolku kene, andi mingi auli lelemúmanga liiku munduku peka sai.” nirim. Kanu-kene enini no kolku aima peka siring. ");
INSERT INTO mux_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yu-ni eninindu kelepa nimba mele: “Olama liiku munduku kene langi nukuli yili meku puku sai.” nirim. Kanu-kene meku puku yu siring. ");
INSERT INTO mux_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Langi nukuli yi kanili-ni bo-nole no-waen au talurumele naa kanupa kene nole we nomba piliirim. Akiliinga-pe kendemande-yambu no kuluringima-ni nole kanuku bi siring. Langi nukuli yili-ni nomba piliipaliinga ambu liimba yilindu “Ui.” nimba kene ");
INSERT INTO mux_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yundu nimba mele: “Yima-ni pali taki-taki no-waen kaiéle ui siku kene, penga yambuma-ni no pulele noku pora siku alsuku we walu-siku noku ‘sungu tekemune mola naa tekemune’ niku apuruku naa piliilimili kene no kisma silimele. Akiliinga-pe nu-ni no-waen kaiéle ui we nosuku kene pe ekupu sikenu lam, ⸤aima papu sikenu⸥.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kolea Gallalli distrik sukundu lirim kolea-kelú Kena taon-na Yesos-ni tirim ulu akili penga yu molupa kongun tirim mele liipa ora sirim ulu-tonduluma tembandu ulu ili pulu-pulu tirim. Aku-sipa mele yu we-yi te mólu, yu Pulu Yili-nga tondulu pili yili ‘enini kanangi.’ nimba liipa ora sirim. Kanu-kene yu lumbili anduli yima-ni ‘Yu aima sika ⸤Pulu Yili-ni liipa mundurum yili⸥.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yi ambu liimbaliinga langi noku pora sikuliinga Yesos kene anum kene anginipili kene lumbili andúlima kene kolea-kelú Kapeniam taon-ndu puku kene, akuna ena talse muluring. ");
INSERT INTO mux_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda-yambuma-ni punie tenga-tenga niku kolea-auli Jerusallem oku akuna suku Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliiring enama nondupa wendu ombá tirim kene Yesos Kapeniam taon mundupa kelepa kolea-auli Jerusallem olandu purum. ");
INSERT INTO mux_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","⸤Pulu Yili popu toku kaluring⸥ lku-temboll akuna sukundu pupa kanurum kene kung pirimu-kao konama kene kung sipsip konama kene kera waembonu konama kene ku-moni liiku méle taropu turing yambuma kene, ku-moni alowa tiringi yambuma kepe pali akuna sukundu aku teku muluring kanurum. ");
INSERT INTO mux_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kanupa kis piliipa kene, ka mare liipa lakupa kene ka-pulsa kanili-ni kungma pali lku-tembolluna topa makurupa pena-pena tepa, ku-moni alowa tiringi yambumanga ku-moni walena pirim-ma liipa onde lepa eninga ku-moni nusiring poluma liipa onde lepa kene, ");
INSERT INTO mux_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","kera monjuku ku-moni taropu turing yambumandu nimba mele: “Tatanga lku ilinga méle taropu naa toku, méle ima wendu liiku meku pai! Tatanga lku ili langi taropu lkuliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yu-ni aku terimele yu lumbili andúlima-ni kanuku kene enini ung te Pulu Yili-nga bukna sukundu nimba molemále numanale-ni piliiring. Ung akili-ni nimba mele: “Na aima mindili sipu nunga lkuli ‘Angiliipa kaí tipili.’ nimbu nokupu moliu.” nimba molemú ung kanili numanale-ni piliiring. ");
INSERT INTO mux_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kanu-kene yu-ni tirimele Juda-⸤yi auli⸥ma-ni kanuku kene yundu niku mele: “Nu namba nambulka namba te liikuliinga aku-siku tekenuye? ‘Liipu ora sambu.’ nikunu Pulu Yili-ni “Ti.” nim lem Pulu Yili-ni telemú mele ulu-tondulu te oliu kanamili ti.” niring. ");
INSERT INTO mux_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesos-ni eninindu pundu topa nimba mele: “Eni lku-temboll ili tikisingí kene na-ni ena tale-nga takupu, yupuku-sipaliinga takupu liimbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nirim mele akili Juda-⸤yi auli⸥ma-ni piliiku kene niku mele: “Lku-temboll ili punie paon tale omba pupa kelepa punie angere tale-guli omba purum kene takuku liiring kanili. Pe nu-ni “Ena tale-nga takupu, yupuku-sipaliinga takupu liimbu.” nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Akiliinga-pe yu-ni “lku-tembollale” nirim akili yunga kangielendu nirim. ");
INSERT INTO mux_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanu-kene penga Yesos kolupa ena tale ónu-koleana pepa yupuku-sipaliinga lomburupa ola mulurum kene yu-ni ui lku-tembollalendu nirim mele akili yu lumbili andúlima-ni kelku piliiring. Piliiku kene Pulu Yili-nga bukna ⸤Yesos-ndu⸥ nimba mulurum ungele kene Yesos-ni nirim ungele kene ‘Sika’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pulu Yili-ni Juda-yambumanga anda-kolepalima Naa Topa Ola We Omba Purum mele piliiring enamanga Yesos Jerusallem molupa kene yu molupa kongun tirim mele liipa ora sirim ulu-tondulu tirim-ma yambuma-ni kanuku kene ‘Yu sika Pulu Yili-ni ‘Enini nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yili omba molemú.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Akiliinga-pe Yesos-ni yambuma pali teku muluring mele piliipa kelepa kene uluma pali yambu te-ni yu nimba naa sipili yu-yunu piliipa mulurum. Enini niku piliiring mele yu-ni numanale-ni piliipa kene, ⸤‘We niku piliilimili. Sika ekupu aku-siku niku piliilimili akiliinga-pe opali kepe talú kepe numanu topele toku kene na ‘Topu konjamili.’ niku piliingí.’ nimba piliipaliinga,⸥ ‘Enini-kene we walu-sipu molambu.’ ni naa nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","⸤Juda-yambumanga yi mare Perisi muluring.⸥ Yi-Perisi akumanga yi te, bi ‘Nikodimas’, yu Juda-yambuma nukurum kanjoll yi te, ");
INSERT INTO mux_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","yu Yesos mulurumna sumbulsuli omba kene, yundu nimba mele: “Rapai, ‘Nu Pulu Yili wasie molkulu kene ung-bo tunjunindu urunu.’ nimbu piliilimulu. Yi te ‘Pulu Yili-kene naa molkanje Pulu Yili-ni ulu-tonduluma telemú mele nu-ni tellu aku-sipa yu-ni kapula naa telka. Ulu telluma-ni Pulu Yili-kene wasie molembele mele liipa ora silimú.’ nimbu piliilimulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesos-ni pundu topa yundu nimba mele: “Na-ni nundu aima sika nimbu siker: “Yambu te alsuku naa míngi lem yambu kanili-ni Pulu Yili yi nuim kingele molupa yambuma nokulemú koleale manda naa kanupa yunga talapena manda naa molumba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas-ni yundu nimba mele: “Yambu te anda lepa molemú kene yu nambi-siku mingíye? Yu anumunga oluna alsupa manda suku pumba, anumu-ni yu kapula membaye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesos-ni pundu topa nimba mele: “Na-ni nu aima sika nimbu siker: ‘Yambu te nole-ni kepe Minéle-ni kepe mi naa míngli lem yambu kanili Pulu Yili-nga kangambula naa molupa Pulu Yili yi nuim kingele molupa nokulemú koleana suku kapula naa pumba, mólu. ");
INSERT INTO mux_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Méle kangiele-ni melemú méle akili kangiele, yu mana molumba mélale mindi. Méle Pulu Yili-nga Minéle-ni melemú méle akili minéle, méle akili mindi Pulu Yili molemúna manda pupa molumba.’ niker. ");
INSERT INTO mux_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Akiliinga na-ni nundu nimbu mele: “‘Pulu Yili yi nuim kingele molupa nokulemú koleana pamili.’ ningí yambuma pali ui alsuku meangi.” nikerelendu numanu pulele naa pilíí. ");
INSERT INTO mux_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Popuremale yunu piliipa kolea lupa-lupamanga popuremi tolemú kene eni yunga ungele piliiku, mélema lop-lopi telemú kanolemele, akiliinga-pe yu naa kanuku yu wendu olemúna kepe pulimúna kepe naa kanolemele. Pulu Yili-nga Minéle aku-sipako. Minéle-ni melemú yambuma mini kona pípili enini aima yambu lupa mele molemele yambuma-ni kanolemele, akiliinga-pe ⸤Pulu Yili-nga⸥ Minéle-ni yambu kanuma mini konama silimú Mini kanili naa kanolemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas-ni yundu nimba mele: “Ulu ima nambi-sipa wendu okumuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesos-ni yundu nimba mele: “Nu Isrel-yambumanga ung-bo tunjuliele yi te akiliinga-pe i niker mele naa piliikunu lam. ");
INSERT INTO mux_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na-ni nundu aima sika nimbu siker: Oliu piliilimulumandu nilimulu; kanolemulumandu nimbu silimulu. Akiliinga-pe ung nilimulu ung ima eni pali piliiku liilimele yambu te mólu. ");
INSERT INTO mux_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ya ma-koleana uluma eni nimbu siliu kene eni ‘Gólu tokumnje.’ niku piliilimiláliinga pe ekupu mulú-koleana uluma nimbu sindu lem ‘Sika nikem.’ niku nambi-siku manda tondulu munduku piliingíye? Manda naa piliingí. ");
INSERT INTO mux_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Yambu tilu kepe ola mulú-koleana suku naa puring. Yi tiluele mindi, mulú-koleana mania urum yili mindi ui mulú-koleana mulurum. Yu Mania Omba Mana-Yi Au Talurum Yili. ");
INSERT INTO mux_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ui Moses-ni yambu naa pili kolea-wakana wambiye-kimbulu mele ku-kapa-ni tiliele liipa ⸤unjina-⸥ola ⸤topa⸥ ku topa munjurum ili mele aku-siku yambuma-ni Mania Omba Mana-Yi Au Talurum Yili liiku ⸤unjina-⸥ ola ⸤toku⸥ ku toku panjingí. ");
INSERT INTO mux_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kanu-kene, ⸤ui yambu wambiyema-ni noku kunjuring kulungí tiring yambuma Moses-ni liipa ⸤unjina-⸥ola ⸤topa⸥ ku topa munjurum wambiye kapa-ni tiliele kanuku kene kona puring kanu-mele⸥ penga ekupu aku-siku ‘Yambuma-ni lupa-lupa ‘Mania Omba Mana-Yi Au Talurum Yili yu uluma tepa molemú mele sika.’ niku tondulu munduku piliingí yambuma pali molku konjuku mindi pangi.’ nimba Pulu Yili-ni ‘Yu unjina-ola ⸤toku⸥ ku toku panjangi.’ nimbá nirim.” ⸤nimba Yesos-ni nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Pulu Yili-ni mana-yambuma numanu aima lakupa monjupaliinga yunga Málu tiluele mindi mulurum akiliinga-pe yu ⸤mana-yambuma⸥ sirim. ‘Yambuma-ni lupa-lupa ‘Yu sika ⸤Pulu Yili-ni sipa mundurum, oliu tepa liipa nokupa kunjuli yili.⸥’ niku tondulu munduku piliiku mulungí yambuma mindili noku molku kis-singí koleana naa puku, taki-taki molku konjuku mindi pangi.’ nimba yunga Málale sirim. ");
INSERT INTO mux_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","“Pulu Yili-ni Málalendu “Nu-ni mana-yambuma kot piliikunu enini ka-lkuna liiku mundani pui.” ni naa nirim. ‘Nanga kangale enini tepa liipa mindili nolkemela kupulanum-na wendu liipa na-kene molku kunjingí kupulanum-na liipa munjupili.’ nimba yu-ni Málalendu “Ma-koleana mania pui.” nimba yu liipa mundurum. ");
INSERT INTO mux_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yambu ‘Yu sika ⸤Pulu Yili-nga Málale, oliunga nimba tinjirim yili⸥.’ nimba tondulu mundupa piliipa molumba yambaliinga kot naa pemba. Akiliinga-pe yambu te-ni ‘Yu aku-sipa naa molemú. Nanga nimba ulu te naa tinjirim.’ nimba piliimba yambale, yunga kotele kórunga wendu okum. Yambu kanili-ni Pulu Yili-nga Málu tiluele mendepolu molemú kanilindu ‘Yu sika Pulu Yili-nga Málale mólu.’ nimba piliirim yambu kanili kot piliilimú yili-ni liipa kot tenjipa “Yu kulupili.” nimba kórunga-ui tinjirim. ");
INSERT INTO mux_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Koteliinga ung-pulele i-sipa mele: Pa tíliele ma-koleana wendu urum akiliinga-pe mana-yambuma-ni ulu-pulu-kísima mindi teku kene pa tiliele numanu naa monjuku súmbulu tuliele mindi numanu monjulemele. ");
INSERT INTO mux_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yambu ulu-pulu-kísima telemelema-ni pa tiliele kanuku kis piliiku kene, ‘Pa tíliele-ni nanga uluma tepa mokeringa lenjemba.’ niku pa tílina wendu naa olemele. ");
INSERT INTO mux_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Akiliinga-pe yambu ulu-sikama telemú yambale-ni ‘Pulu Yili-ni na liipa tapunjilimú-na ulu-pulu sika ima teliáliinga teliu uluma yambuma-ni kanangi.’ nimba pa tílina yu wendu olemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Penga Yesos kene yunga lumbili anduli yima kene kolea Judia distrik lirim kolea tenga puku kene, akuna ena mare yu enini-kene molku, ⸤Yesos⸥ yu-ni yambuma no liinjirim. ");
INSERT INTO mux_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon yu yambuma no liinjipa mulurumko. Kolea Sellim nondupa kolea Inon no pulele omba purumeliinga Jon yu-ni akuna yambuma no liinjirim, yambu pulele yu mulurumna no liingí uring. ");
INSERT INTO mux_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Jon yu ⸤yi nuim king Erot-ni⸥ ka ui naa sipili aku tepa mulurum.) ");
INSERT INTO mux_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Walse ⸤No Liinjili⸥ Jon-nga lumbili anduli yima kene Juda-yi te kene anju-yandu tondulu tombulku niku kene, “Oliu nambi-sipu kimbu ki kangima lumaye tomulú kene Pulu Yili-ni oliu kake temba kanombaye?” niku tombulku niring. ");
INSERT INTO mux_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Penga Jon-nga lumbili anduli yima Jon yu mulurumna oku kene niku mele: “Rapai, yi te no Jodan nekendu nu wasie muluringli kene nu-ni yu molemú mele niku sirinu yi kanili-ni no liinjipa molemúna yambu pulele pukumele.” niring. ");
INSERT INTO mux_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Aku niring piliipa kene Jon-ni pundu topa nimba mele: “Mulú-koleana Pulu Yili-ni ‘Yi te ulu te tipili.’ ni naa nilkanje yi kanili-ni manda naa telka. ");
INSERT INTO mux_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Na-ni eni ui nimbu sirindu piliiring mele akili i-sipa: Na-ni nimbu mele: “Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele na mólu. Pulu Yili-ni ‘Yi-nuim Kraisele molumba yili yu ombá.’ nimba na ui kumbi-lepa liipa mundurum.” nirindu piliiring kanili. ");
INSERT INTO mux_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yi ambu liimba ambale yili yunga mendepolu. Yi ambu liimba yili-ni ung nimbá mele yili yunga pulu lemba yili-ni piliimbandu kum lepa molumba. Yunga ungele piliipa kene aima numanu simba. Akiliinga, yili kene pulu lemba yili numanu simba mele na aku-sipu kamu numanu siliu. Ambu liimba yili olandupa. Yunga pulu lelemú yili yu-kene wasie we tapú-topa molemú, yi kanili mandupa. ");
INSERT INTO mux_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Aku-sipa mele ne no liinjipa molemú yili yunga bili sika aima olandupa pumba. Nanga bili sika mania pumba.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yi wi-ola molupa kene mania urum yili yambumanga pali yu olandupale. Oliu mana-yambu molemuluma mana-mélemanga mindi molupu, mana-mélemanga mindi bima nimbu sipu temani tolemulu. Oliu mania-kilia, mulú-koleana molupa kene mana-mania urum yili yu yambumanga pali olandupale. ");
INSERT INTO mux_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yu-ni mulú-koleana kanupa piliirim mele nimba silimú akiliinga-pe yambuma-ni “Gólu tokum.” niku liiku su siku naa piliilimili. ");
INSERT INTO mux_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yambu te-ni yunga ungele piliipa liipa “Sika nikem.” nimbá yambale-ni aku-sipa “Pulu Yili-ni sika nilimú.” nimbáko. ");
INSERT INTO mux_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pulu Yili-ni liipa mundurum yi ili Pulu Yili yunga Minéle aima auli-tepa silimú numanuna pepa kapula telemáliinga yu-ni Pulu Yili-nga ungele sumbi-sipa nilimú. ");
INSERT INTO mux_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lapa-ni Málale numanu monjupaliinga ‘Mélema pali Málale nukupili.’ nimba sirim. ");
INSERT INTO mux_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yambu te ‘⸤Yu sika nikem.⸥ Yu sika Pulu Yili-nga Málale.’ nimba tondulu mundupa piliimba yambale taki-taki kona molupa mindi pumba, akiliinga-pe yambu te Málale liipa bulu sipa yunga ungele liipa su sipa naa piliimba yambale kona mululi ulu-pulele naa liimba. Yambu kanili ekupu kepe penga kam-kamu kepe Pulu Yili-ni mindili liipa simba ulu-pulele yu-kene wasie pelemú. ");
INSERT INTO mux_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Perisi-yima-ni ung te piliiring mele i-sipa: “Yesos molemúna yambu pulele ‘No liinjipili.’ niku pulimelé, Jon molemúna yambu koltale mele ‘No liinjipili.’ niku pulimelé.” niring ungele piliiring. ");
INSERT INTO mux_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Akiliinga-pe Yesos yu lumbili puring yambuma yu-ni no naa liinjirim, yu lumbili anduli yima-ni yambuma no liinjiring.) ");
INSERT INTO mux_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","⸤Yesos-ni yambu no liinjirim⸥ temani akili Perisi-yima-ni piliiring mele piliipaliinga Auliele-ni ena kaniliinga kolea Judia distrik mundupa kelepa kolea Gallalli distrik-ndu kelepa pumba purum. ");
INSERT INTO mux_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yu Gallalli purum kupulanum akili kolea Sameria ai-suku-singina lepa purum. ");
INSERT INTO mux_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kupulanumele aku-sipa lirim-na yu kolea Sameria taon tenga urum, taon akiliinga bili Saika. Taon akili Juda-yambumanga anda-kolepa Jekop-ni yunga málu Josep sirim ma akuna nondupa lirim. ");
INSERT INTO mux_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop-ni ‘No mulupili.’ nimba no ukupa munjurum monglu akili ma kaniliinga mulurum. Yesos kupulanum suluna urumeliinga enembu turum-na no akiliinga kéluna omba mania molupa múlu liirim. Ena ai-tangili mele tirim kene akuna omba mulurum. ");
INSERT INTO mux_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","(Yesos no-kéluna mulupili yu lumbili anduli yi wasie uringma keri-langi taropu toku liingíndu Saika taon-na puring.) Penga Sameria-ambu te no kolumbandu no-monglu akuna urum kene Yesos-ni yundu nimba mele: “No te nambu kolkunu si.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameria-ambale-ni yundu nimba mele: “Nu Juda-yili. Na Sameria-ambale. Pe nambimuna nandu “No kolkunu si.” nikinuye?” nirim. (Aku-sipa nirim akiliinga ung-pulele i-sipa mele: Juda-yambuma-ni Sameria-yambuma numanu kis panjiku keri-langi tiluele moke teku naa noku, enini-kene tiluna tapú-toku naa anduringeliinga aku-sipa nirim kanili.) ");
INSERT INTO mux_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesos-ni pundu topa kene ambalendu nimba mele: “Pulu Yili-ni méle we silimú mélale piliikunu, yi “No kolkunu si.” nikem yi ili kanukunu bi silkenanje yundu “No si.” nilkena kene yu-ni kona molupa mindi puli nole nu silka.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ambale-ni pundu topa nimba mele: “Auliele, nu no kuluni mingi te naa míneliinga, no-monglale aima mandupa lelemú. Pe no kona molupa mindi puli no nikinu ili nu tena kolkunu kene siniye? ");
INSERT INTO mux_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Oliunga anda-kolepa yi Jekop-ni no-monglu ili sirim yi kanili, yu kene yunga kangambulama kene kungma kene no ili nuring, ‘yi kanili mandupa nu olandupa.’ niku nikinuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesos-ni pundu topa nimba mele: “No-monglu ilinga no nungí yambuma alsupa no waka lemba, ");
INSERT INTO mux_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","akiliinga-pe na-ni no simbu nungí yambuma penga enini no aima waka naa lemba. Na-ni aima sika niker: “Na-ni no simbu akili nungí yambumanga numanuna no pikipa mindi molupa, kona molku mindi pungí ulu-pulele simba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","⸤Yesos-ni ung-eku turum mele naa piliipaliinga,⸥ ambale-ni yundu nimba mele: “Auliele, na no alsupa waka naa lipili, ya alsupu taki-taki ombu no naa kolambu akiliinga nu-ni no nikinele nambu si.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesos-ni ambalendu nimba mele: “Nunga yili kene wasie kelkulu wangli, pukunu walsi-pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ambale-ni pundu topa nimba mele: “Nanga yi te naa molemú.” nirim. Yesos-ni yundu nimba mele: “ “Nunga yi te naa molemú.” nikinele sika nikinu. ");
INSERT INTO mux_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ui nu yi angere te-guli purunu. Pe ekupu nu yi te wasie pelembelale nunga emena mólu. Nu-ni ekupu ung nikinele sika nikinu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ambale-ni yundu nimba mele: “Auliele, na piliiker nu Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliikunu yambuma niku sillu yi te lam. ");
INSERT INTO mux_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Oliunga anda-kolepalima-ni ma-pangi ilinga Pulu Yili popu toku kape niring akiliinga-pe eni Juda-yambuma-ni niku mele: “Pulu Yili popu toku kape ningí koleale aima Jerusallem mindi.” nilimele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesos-ni tondulu mundupa nimba mele: “Ambale, na-ni ya nikerele nu piliikunu liani. Ena te wendu ombá ena kaniliinga ma-pangi ilinga kepe Jerusallem kepe yambuma-ni Lapale popu toku kape naa ningí.” ⸤nirim. Ung akiliinga pulele i-sipa mele: “Koleamanga pali Pulu Yili popu toku kape ningí.” nimba nirim kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","“Eni Sameria-yambuma popu toku kape nilimele yili piliiku sunduku we nilimele. Oliu Juda-yambuma-ni popu topu kape nilimulu yili molemú mele piliipu kongnjulimulu. Nambimuna, mana-yambuma Pulu Yili-ni tepa liipa, mindili nolkemela kupulanum-na wendu liipa, yu-kene wasie molku kunjingí kupulanum-na liipa monjulemú ulu-pulele Juda-yambuma-kene wendu ombá, enini koleamanga pali yambuma liiku ora singéliinga aku-sipa. ");
INSERT INTO mux_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akiliinga-pe Pulu Yili sika popu toku kape ningí yambuma-ni Tatanga ungele ‘Sika ungele.’ niku piliiku yunga Minéle-ni tondulu silimáliinga Pulu Yili popu toku kape ningí ena wendu ombále kórunga wendu um. Pulu Yili aku-siku popu toku kape ningí yambuma Tata-ni korolemáliinga, ena kanili wendu um. ");
INSERT INTO mux_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pulu Yili yu minéle, akiliinga yu popu toku kape ningí yambuma-ni yunga Minéle-ni tondulu silimáliinga ‘Yunga ungele sika ungele.’ niku sumbi-siku aku tingí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ambale-ni nimba mele: “Yi-nuim Mesayale ombá. Yu omba kene ungmanga puluma pali oliu mimi-sipa nimba simba mele na piliipu moliu.” nirim. (Ipuru-ungna ‘Mesayale’ niring, Grik-ungna ‘Kraisele’ niring ung akuselenga pulele tilu-sipa. Ungselenga pulele i-sipa mele: Pulu Yili-ni “Oliu nokupa konjumba yi te liipu mundumbu.” nimba makó turum yi-nuim kanili.) ");
INSERT INTO mux_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kanu-kene Yesos-ni tondulu mundupa nimba mele: “Nu “Yi-nuim Mesayale ombá.” nikinu akili na. Na nu-kene ung nimbu molkumbulu yi akili nu-ni “Yi-nuim Mesayale” nikinu yi akili yi tiluele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yu aku nimba mulupili yu lumbili anduli yima kelku yandu oku kene, yu ambu te kene ung niku muluringli kanukuliinga mini-wale munduku numanu pulele liiku munduring. Akiliinga-pe eninga yi te-ni “Nu nambulka méle te liini tekenuye?”, mola “Yu-kene wasie nambimuna ung niku molembeleye?” niku te-ni kepe naa walsiring. ");
INSERT INTO mux_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kanu-kene ambu kanili yunga no-mingele mundupa kelepa yu alsupa taon akuna yandu pupa yambumandu nimba mele: ");
INSERT INTO mux_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Na ulu tirinduma pali yi te-ni na nimba símu yili eni oku kanai! Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ nirim yi-nuim Kraisele yununje.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aku nirim-na piliikuliinga yambuma taonale munduku kelku Yesos mulurumna ungí uring. ");
INSERT INTO mux_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Aku teku molangi Yesos lumbili anduli yima-ni yu aima karaye teku kene niku mele: “Rapai, langi te nui.” niring. ");
INSERT INTO mux_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Akiliinga-pe yu-ni eninindu nimba mele: “Na langi nombále lelemú, akiliinga-pe akili eni naa piliiku naa kanolemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aku nirim piliiku kene yu lumbili andúlima-ni anju-yandu tombulku kene niku mele: “Yambu te-ni langi ui memba omba simunje?” niring. ");
INSERT INTO mux_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesos-ni nimba mele: “Nanga langiele i-sipa mele: Na ‘kongun teani pui.’ nimba liipa mundurum yili-ni numanu silimú uluma tepu, yunga kongunale tepu pora simbu. Akili nanga langiele. ");
INSERT INTO mux_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Eni “Kaliimbu angere omba pumba kene rais-wit tepa tomba kene lkepu nosimulú.” nilimele kanili. Akiliinga-pe na-ni enindu nimbu mele: “Puniema kanai! Langi pali kórunga tepa tum.” niker. ");
INSERT INTO mux_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Langi lkenjilimú yili langi lkenjilimáliinga méle kaluli kórunga liipa, ‘Lepa mindi pupili.’ nimba langima lkenjepa molemú. Aku tenjilimáliinga punie tepa langi panjurum yili kene langi lkenjilimú yili kene wasie-nele numanu singlí. ");
INSERT INTO mux_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akiliinga ung te pelemále sika. ‘Yi te-ni langi-bo talonjilimú. Te-ni langi lkenjilimú.’ nilimele ungele sika. ");
INSERT INTO mux_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Langi eni bo naa taluringima na-ni “Eni lke-pai.” nimbu liipu mundurundu. Yambu lupama-ni punie mindili siku tiring, akiliinga-pe yambu kanuma-ni kongun tiring langima eni lkelemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ambale-ni “Na ulu tirinduma pali yu-ni na nimba símu.” nirimeliinga piliiku kene ⸤Saika⸥ taon kanuna muluring Sameria-yambu pulele ‘Yu sika ⸤Pulu Yili-ni ‘Eni nokupa konjumba yi te liipu mundumbu.’ nimba ui makó turum⸥ yi-nuim Kraisele.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Akiliinga, Sameria-yambuma yu mulurumna oku, “Nu aima ya wasie molamili.” niring, kanu-kene ena tale yu enini-kene mulurum. ");
INSERT INTO mux_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kanu-kene yambu pulele wasie yu-yunu ung nirimele piliiku kene ‘Yu sika ⸤yi-nuim Kraisele omba molemú. Yu-ni sika nikem.⸥’ niku tondulu munduku piliiringko. ");
INSERT INTO mux_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Enini ambalendu niku mele: “Nu-ni ui ung nínele piliipu ‘Yu sika yi-nuim Kraisele.’ nimbu tondulu mundupu pilíímulu akiliinga-pe ekupu oliu-oliuliu yunga ungele piliipuliinga ‘Sika yi ili oliu mana-yambuma Tepa Liipa, Mindili Nolkumula Kupulanum-na Wendu Liilimú Yili molemú.’ nimbu tondulu mundupu piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sameria-yambuma kene ena tale molupa kene Yesos enini mundupa kelepa kolea Gallalli distrik pumba purum. ");
INSERT INTO mux_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Gallalli akili Yesos yunga pulu-koleale. Ui walse Yesos yu-ni nimba mele: “Pulu Yili-ni “Ninjui!” nimba ung nimba silimúma piliipa yambuma nimba silimú yi te-ni yunga pulu-kolealiinga yambuma ung nimba silimú kene piliikuliinga, enini ‘Yu oliunga we-yi te. Yu bi mululi yi te mólu.’ niku yu nilimú ungma naa piliiku liilimele.” nirim kanili.) ⸤‘Kolea wemanga yambuma yi kaniliinga ungele piliiku liilimele akiliinga-pe yunga pulu lelemú yambuma-ni naa piliiku liilimele.’ nimba nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yu Gallalli suku purum kene Gallalli-yambuma yu urum kanuku kene “Papu okonu.” niku numanu siring. Ui Pulu Yili-ni Juda-yambumanga anda-kolepalima Naa Topa Ola We Omba Purum mele piliiring enama wendu urum kene enini Jerusallem puku molangi yu-ni akuna ulu mare tirim kanuringeliinga enini aku-siku tiring. ");
INSERT INTO mux_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesos kolea Gallalli distrik pupa kene alsupa kolea-kelú Kena taon-na sukundu urum. Taon kanuna ui yu-ni bo-no kuluringima no-waen tepa au talunjurum. Kolea-kelú Kapeniam taon yi nuim kingeliinga kongun tinjili yi-auli te kolea-kelú Kena kanuna mulurum, akiliinga málale kuru auli te turum. ");
INSERT INTO mux_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yesos kolea Judia distrik mundupa kelepa kolea Gallalli distrik sukundu urumele piliipaliinga, yi kanili Yesos mulurumna pupa kene, yundu mawa tepa nimba mele: “Nanga kangale nondupa kolumba tekemeliinga mandu okunu yu tekunu kona lii.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Aku nirim-na piliipa kene Yesos-ni yundu nimba mele: “‘Na sika ⸤Pulu Yili-kene molupa mana-mania urum⸥.’ niku we naa piliingí lem. Pulu Yili-ni ulu-tonduluma telemú mele ‘Yu-ni aku-sipa mele temba kene kanupuliinga ‘Yu sika ⸤Pulu Yili-kene molupa mana-mania urum⸥.’ nimbu tondulu mundupu piliimulú.’ niku nandu taki-taki “Ulu-tonduluma okunu ti.” niku mawa telemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingeliinga kongun tinjili yi-auliele-ni yundu nimba mele: “Auliele, nanga kangale ui kulu naa kulupili nu wela mandu ui.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesos-ni yundu nimba mele: “Marena kona pulimáliinga pui.” nirim. Yili-ni Yesos-ni nirim mele piliipa kene ‘Sika nikem.’ nimba tondulu mundupa piliipa yu purum. ");
INSERT INTO mux_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mandu pumba purum kene yunga kendemande-yima kupulanum-na oku yu mandu urum kanuku liiku kene enini yundu niku mele: “Marena kona pumu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kanu-kene yu-ni eninindu nimba mele: “Ena-mong nambulkana kuru topa kilímuye?” nimba walsipa piliirim. Enini yundu niku mele: “Bonongu ai-tangili wan-killok mele kangi nomba kilímu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lapale-ni piliipa kene Yesos-ni “Marena kona pumu.” nirim ena-mong kaniliinga ‘Kangi nomba kilímu lam.’ nimba piliipaliinga, yu kene yunga lkuna piring yambuma kene enini ‘Yesos yu sika ⸤Pulu Yili-kene wasie molupa mana-mania urum⸥.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kolea Judia distrik mundupa kelepa kolea Gallalli distrik omba molupa kene Yesos-ni kangale tepa kona liirim ulu kanili kolea akuna yu mulurum mele liipa ora sirim ulu-tondulu tale-sipale tirim. Te ui walse kolea akuna bo-no kuluringima no-waen tepa au talunjurum kanili. ");
INSERT INTO mux_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Penga walse, Juda-yambuma-ni punie tenga-tenga niku Jerusallem puku Pulu Yili-kene ulu te tiring ena te wendu urum kene Yesos Jerusallem olandu purum. ");
INSERT INTO mux_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusallem sukundu, kung-sipsipimanga pala-keripulu-sukundu-ólina nondupa, no-numú-wallú te mulurum, numú-wallú kanilindu Ipuru-ungna ‘Betesda’ niring, akuna lku-takae angere te-guli angiliipa poku tirim. ");
INSERT INTO mux_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Akuna kuru turum yambu pulele anambu liring. Mong kis lirim yambuma kene, kimbu tondulu naa pepa topele-mapele turum yambuma kene, kimbu kolupa kukurum yambuma kene, enini (‘Nole lop-lopi temba.’ niku nokuku muluring. ");
INSERT INTO mux_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Walse-walse nimba Auliele-nga angkella te mania omba nole lop-lopi tinjirim kene yambu te kumbi-lepa nona suku purum yambale kona purum.) ");
INSERT INTO mux_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yi te akuna mulurum punie tokapu tilu kelepa malapunga tale kuru turum yu anambu lirim. ");
INSERT INTO mux_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesos omba, yi anambu lirimele kanupa, yu kórunga-ui anambu lirimele piliipaliinga, yili walsipa nimba mele: “Nu ‘kuru waengu nipili.’ niku piliikunuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yi anambuli-ni pundu topa nimba mele: “Auliele, no lop-lopi telemú kene yambu te-ni na liipa tapunjupa nona memba pumba te naa molemú. Na-nanu pumbu teliu kene yambu mare ui kumbi-leku nona pulimelé.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aku nirim kene Yesos-ni yundu nimba mele: “Nu ola angiliikunu nunga uru pellu kunungele liiku mekunu oku pui.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aku nirim kene enaliinga yilinga kurale pora nirim-na yu ola angiliipa yunga kunungele liipa memba purum. Ulu ili wendu urum ena akili ⸤kóru muluring⸥ ena-Sambat te, ");
INSERT INTO mux_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","akiliinga Juda yi-⸤auli⸥ mare-ni kuru pora nirim yilindu niku mele: “Ekupu ⸤kóru mululi⸥ ena-Sambatele-nga nambimuna nunga kunungele mekunu oku pukunuye? ‘Sambat-ena kene mélema naa meku andai.’ nimba ung-manele pelemú kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akiliinga-pe yili-ni pundu topa kene nimba mele: “Na tepa kaí tímu yili-ni ‘Nunga kunungele liiku ambolkunu meku pui.’ nim.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aku nirimaliinga enini yu alsuku walsiku kene niku mele: “Yi nae-ni ‘Nunga kunungele liiku ambolkunu meku pui.’ nimuye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Akiliinga-pe yi kuru pora nirim yili ui anambu lirim koleana yambu pulele muluring kilia Yesos kiyang nimba purumeliinga yu-ni manda yunga bili walsipa naa piliirim. ");
INSERT INTO mux_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Penga Yesos yi kanili ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna kanupa kene yundu nimba mele: “Pília. Ekupu nunga kurale pora nimu-na nu alsukunu kaí molláliinga nu ulu-pulu-kísima manda teku ti, alsukunu naa ti. Alsukunu tinu lem nu ulu buni auli te wendu ombánje.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yi kanili-ni anju pupa Juda yi-aulimandu nimba mele: “Na tepa kaí tímu yi kanili Yesos.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesos-ni enini kóru muluring ena Sambatele-nga aku-sipa mele uluma tirim kilia Juda yi-aulima-ni Yesos yu pulu monjuku teku kis-siku buni siring. ");
INSERT INTO mux_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesos-ni eninindu nimba mele: “Tata-ni ui yambuma enamanga pali liipa tapunjurum mele ekupu kepe aku-sipa tepa molemú. Na aku-sipu Sambat-enamanga kongun teliuko.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yu-ni aku nirim kilia piliiku kene Juda yi-aulima-ni ‘Yesos yu aima kamu topu konjumulú.’ niku piliiku kupulanum te koruku muluring. Ui Sambat-enaliinga ung-manele topa pula turumeliinga piliiku yu arerembi kolku kene; penga “Pulu Yili yunga lapa.” nirimaliinga yu ‘Pulu Yili-kene kapula-kapula molembulu.’ nimba nirimaliinga yu kamu arerembi kolku yu toku kunjingí tiring. ");
INSERT INTO mux_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesos-ni eninindu pundu topa nimba mele: “Na-ni eni aima sika nimbu siker: “Málale-ni yu-yunu uluma kapula naa telemú temba. Yunga Lapale-ni telemú mele kanupa kene manda lepa telemú. Lapale-ni telemú uluma mindi Málale-ni telemú.” niker. ");
INSERT INTO mux_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nambimuna, Lapale-ni Málale numanu monjupaliinga yu-ni telemú mele pali Málale liipa ora silimú. Yi tepa kaí tímu akili mandupa. Aima sika penga eni aima kanuku numanu pulele liiku mundungí ulu-tondulu olandupama Lapale-ni Málale liipa ora simba. ");
INSERT INTO mux_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Akili nambi-sipa wendu ombáye? Lapale-ni yambu kulúlima topa makinjipa kene ‘Kona molangi.’ nilimú mele aku-sipa Málale-ni yambu kulúlima ‘Kona pangi.’ nimba piliilimú yambuma tepa kona liilimú. ");
INSERT INTO mux_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Ung te wasie i-sipa mele: ‘Yambuma-ni Lapale-nga bili paka tonjilimele mele Málenga bili aku-siku paka tonjangi.’ nimba Lapale-ni kot piliipa yambuma naa apurupa kot piliili kongun akili Málale sirim. Akiliinga, yambuma Málunga bili paka naa tonjilimele yambuma aku-siku Málu liipa yandu mundurum Lapanga bili kepe paka naa tonjilimeleko. ");
INSERT INTO mux_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na-ni enindu aima sika nimbu siker: “Nanga ungele piliiku, na liipa mundurum-na urundu yili ‘Yu sika Pulu Yili.’ niku tondulu munduku piliilimili yambuma kona molupa mindi puli ulu-pulele enini-kene pelemú. Penga kot enale wendu ombá kene enini kot-na naa angiliingíko. Yambu kanuma kululi ulu-pulele pelemú kupulanumele munduku kelku kona molupa mindi puli kupulanum-na pulimelé.” niker. ");
INSERT INTO mux_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na-ni enindu aima sika nimbu siker: “Ena wendu ombále ekupu kórunga wendu um. Ena kaniliinga Pulu Yili-nga Málunga ungele kululi yambuma piliingí. Kanu-kene yunga ungele ‘Sika’ niku piliiku liingí yambuma kona mulungí.” niker. ");
INSERT INTO mux_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","⸤Mélema⸥ kona mululi ulu-pulele Lapale-kene pelemú mele aku-sipa Lapale-ni ‘⸤Mélema⸥ kona mululi ulu-pulele Málale-kene pípili.’ nirimko. ");
INSERT INTO mux_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Málale yu Mania Omba Mana-Yi Au Talurum Yili molemáliinga Lapale-ni ‘Málale yambumanga kot piliipili.’ nimba nambale sirim. ");
INSERT INTO mux_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Akiliinga-pe akiliinga-mindi eni numanu pulele liiku naa mundangi. Nambimuna, ena te wendu ombá, ena kaniliinga yambu ónu-koleana pelemeléma-ni Málunga ungele piliiku kene, ");
INSERT INTO mux_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ónu-koleale munduku kelku wendu ungí. Kanu-kene lomburuku ola mulungí yambumanga ui ma-koleana kona molku kene teku konjuku muluring yambuma kona mulungí; ui ma-koleana teku kis-siku muluring yambuma penga kot-na angiliiku kene mindili nungí. ");
INSERT INTO mux_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na-nanu ulu te manda naa tembu. Tata-ni nilimú mele piliipuliinga yambumanga kot-ma apurupu piliiliu. ‘Na-nanu numanu sambu.’ nimbu uluma naa tepu, ‘Na liipa mundurum yili numanu sipili.’ nimbu uluma teliáliinga kot sumbi-sipu piliipu apurupu konjiliu.” ⸤nirim.⸥ ");
INSERT INTO mux_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Sika na moliu mele na-nanu nimbu sindu lem ‘Gólu tokumnje.’ niku pilííngi lem kapula. ");
INSERT INTO mux_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Yi te-ni lupa na moliu mele nimba silimú, akili na piliikerale nandu nilimále aima sika nilimú, ‘Gólu tokum.’ manda naa ningí. ");
INSERT INTO mux_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“⸤Yi-aulima,⸥ eni yi mare ⸤No-Liinjili⸥ Jon mulurumna “Pai.” niku liiku munduring kene yu-ni na sika moliu mele nimba sirim. ");
INSERT INTO mux_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mana-yambu te-ni na moliu mele yambuma nimba sipa “Sika nikem. Sika aku-sipa molemú.” nim lem na numanu pulele liipu naa mundupu, ‘Ulu te mólu.’ nimbu piliiliu, akiliinga-pe ‘Pulu Yili-ni enini tepa liipa mindili nolkemela kupulanum-na wendu liipili.’ nimbu Jon-ni nandu nirim mele eni nimbu siker. ");
INSERT INTO mux_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon-ni kongun tirimeliinga yu kamaye mele nomba yambuma pa tinjirim. Kanu-kene laye-kolo eni numanu siku pa tinjirim pa tili kanuna muluring. ");
INSERT INTO mux_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Akiliinga-pe Jon-ni na liipa tapunjupa na moliu mele eni nimba sirim mele mandupa. Ulu te na moliu mele liipa tapunjupa liipa ora silimú mele ola-kilia. Tata-ni “Ulu-tonduluma teku pora sani.” nimba na sirim ulu-tondulu teliu kanuma-ni na liipa tapunjupa, Tata-ni na “Pui.” nimba liipa mundurum mele eni liipa ora silimú. ");
INSERT INTO mux_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tata-ni na “Pui.” nimba liipa mundurum-na urundele-ni kepe nanga nimba para sinjiliele molupa na moliu mele nimba sirim. Eni yunga kerina ung nirim-ma walsekale kepe kumale-ni naa piliiku, yunga kumbi-kerale mongale-ni naa kanuring. ");
INSERT INTO mux_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ung te wasie kepe. Tata-ni liipa mundurum yilinga ungele “Gólu tokum.” niku piliilimiláliinga yu liipa mundurum Lapale-nga ungele eninga numanumanga naa pelemú. ");
INSERT INTO mux_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","‘Pulu Yili-nga bukna ung molemále-ni oliu taki-taki kona molupu mindi pumulú ulu-pulele simba.’ niku mimi-siku kanolemele. Mimi-siku kanolemele buk akili-ni na moliu mele nimba silimú ");
INSERT INTO mux_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","akiliinga-pe ‘Kona molupu mindi pumulú ulu-pulele liamili.’ naa niku, na moliuna ‘naa omulú.’ niku karaye telemele. ");
INSERT INTO mux_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“‘Yambuma-ni na kape niku nanga bili paka tunjingí kene na auliele molambu.’ nimbu aku naa teliu. ");
INSERT INTO mux_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eni molemele mele na-ni piliiliu. ‘Pulu Yili numanu munjuli ulu-pulele eni-kene naa pelemú’ nimbu piliiliu. ");
INSERT INTO mux_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nanga Tata-ni na namba sipa yunga kongunale ‘tenji-pui.’ nimba na liipa mundurum-na urundu akiliinga-pe nanga ungele eni naa piliiku liilimele. Akiliinga-pe yambu te-ni yu-yunu namba liipa omba kongun telkanje yambu akiliinga ungele piliiku liilkemela. ");
INSERT INTO mux_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Eni-enini anju-yandu ‘bi mulupili.’ niku, Pulu Yi tiluele mindi molemú akili-ni eninga bi ‘paka tunjupili.’ naa nilimele lem na moliu mele nimbu siliu ungele ‘Sika nikem.’ niku nambi-siku piliingíye? ");
INSERT INTO mux_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Akiliinga-pe ⸤na-kene⸥ teku kis-silimelaliinga ‘Pulu Yili-nga kot enale wendu ombá kene Tata-ni kot piliipa mulupili na-ni nanu kot tenjimba.’ niku naa piliai. ‘Moses-ni eni liipa tapunjupa tepa liimba.’ niku piliilimili yi kanili-ni eninga kot tenjimba. ");
INSERT INTO mux_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses-ni na ombu molumbu mele buk turum kilia eni ‘Moses-ni nirim ungma sika nirim.’ niku piliilkimilanje nanga ungele kepe ‘Sika nikem.’ niku piliilkimilá. ");
INSERT INTO mux_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Akiliinga-pe yu-ni nanga temani bukna turumele ‘Sika nikem.’ niku naa piliilimiláliinga nanga ung nikerale ‘Sika nikem.’ niku nambi-siku piliingíye?” nimba Yesos-ni nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Penga walse Yesos Numú-Gallalli nona anduli sipna molupa no-nekendu purum. (Numú akiliinga bi te ‘Numú-Tapirias’ niring.) ");
INSERT INTO mux_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Numú akuna nekendu purum kene kuru turum yambuma tepa kaí tirim kanukuliinga ‘Pulu Yili-ni mindi ulu-tonduluma telemú mele yu-ni aku-sipa tekem.’ niku kanuku kene yambu aima pulele yu purumna aeleku lumbili puring. ");
INSERT INTO mux_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesos ma-pangina ola purum kene lumbili anduli yima wasie puku mania muluring. ");
INSERT INTO mux_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juda-yambuma-ni ⸤punie tenga-tenga kolea-auli Jerusallem oku akuna suku⸥ Pulu Yili-ni eninga anda-kolepalima Naa Topa Ola We Omba Purum mele piliingíndu Pulu Yili-kene ulu te tiring enama nondupa wendu ombá tirim. ");
INSERT INTO mux_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesos ma-pangina ola molupa mandu-sipa kanurum kene yambu aima pulele yu urum kupulanum-na lumbili uring kanurum. Kanupa kene yu-ni yu lumbili anduli yi Pillip-ndu nimba mele: “Yambu ima nungí langima tena taropu topu liinjamili niku piliikunuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yunu-ni aku-sipa Pillip-ndu we walsipa piliirim. Yesos yu-ni temba mele akili yunu piliipa pora sipa mulurum akiliinga-pe ‘Pillip yu-ni nambulka nimbánje? ‘Na-ni ulu-tondulu te tepu kene kapula langi simbu.’ nimba piliimba, mola we mini-wale mundumbanje piliambu.’ nimba kene yu-ni aku-sipa Pillip-ndu walsipa piliirim. ");
INSERT INTO mux_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pillip-ni yundu nimba mele: “Ku-moni tu-tausen kina akuma-ni langi taropu topu liilkemelanje yambu mare mindi wallú-teku liiku nolkemela. Mare mólu tolka naa nolkemela.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lumbili anduli yimanga te, Saimon-Pita-nga angin Endru, yu-ni nimba mele: ");
INSERT INTO mux_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ya kang te rais-balli pllawa kaluli wallú angere te-guli kene oma kaluli tale kene nosupa molemú. Akiliinga-pe akili koltale, yambu aima pulele. Kapula naa temba lam.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesos-ni “Yambuma “Mania molangi.” niai.” nirim. Kolea akuna era pulele pirim-na mania muluring. Yi tausen angere te-guli mele akuna mania muluring. ");
INSERT INTO mux_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kanu-kene Yesos-ni rais-balli-pllawa kalúlima liipa ambulupa kene Pulu Yili-ndu “Angke” nimba yambu muluringma moke tepa enini manda nungí mele sirim. Omasele aku-sipako moke tirim. Noku ⸤aima⸥ kis piliiring. ");
INSERT INTO mux_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Langi kanili nuring olu tirim kene yu-ni yu lumbili anduli yimandu nimba mele: “Langi kakena lelemúma we mania pupa lembale kapula naa tembaliinga liiku máku tai.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kanu-kene noku pora siring kene kakena lirim-ma lumbili anduli yima-ni liiku máku toku wale-basket engkaki-rurepu laliiku toku peka siring. ");
INSERT INTO mux_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pulu Yili-ni mindi ulu-tondulu manda telka mele ulu akili Yesos-ni tirim kene kanukuliinga yambuma-ni pulu monjuku niku mele: “ “Pulu Yili-ni “Ninjui.” nimba, ung nimba simbama piliipa yandu nimba simba yi te ma-koleana omba oliu nokumba.” niku panjiringele aima sika yi ili.” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aku niku piliiku kene enini ‘Yu oliunga yi nuim kingele mulupili.’ niku yu tondulu munduku ambolku gi siku ‘eninga kingele mulupili.’ ningí tiring. Aku tingí tiring piliipaliinga yu-yunu molumbandu ma-pangina ola alsupa purum. ");
INSERT INTO mux_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ena pupa kolea kalá turum kene yu lumbili anduli yima ma-pangina mandu puku numú-kéluna puring. ");
INSERT INTO mux_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Akuna nona anduli sip tenga ola puku no-numúna yakundu oku Kapeniam taon pungí puring. No-numúna pungí puring kene súmbulu turum akiliinga-pe Yesos naa urumeliinga lumbili anduli yima eni-enini puring. ");
INSERT INTO mux_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","⸤Sipna ola molku pungí puring kene⸥ popuremi tondulu turum kene nole ombele tepa kulsapiye topa ola pupa mania omba tirim. ");
INSERT INTO mux_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sipele kongun ⸤mindili-siku⸥ teku meku no-numú ai-suku-singina mele puring kene Yesos no-numúna ola kimbu kambiliipa sipele purumna urum kanukuliinga ‘Kuru te okum.’ niku piliiku kene aima mini-wale lakuku munduring. ");
INSERT INTO mux_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Akiliinga-pe yu-ni eninindu nimba mele: “Na mindi okur, mini-wale naa mundai.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aku nirim-na piliikuliinga “⸤Auliele okum.⸥ Sipna wasie molamili.” niku enini numanu siku yu sipna sukundu liiring. Sukundu urum kene enini pungí puring numú-kéluna sipele enaliinga purum. ");
INSERT INTO mux_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ipulam-ui yambu numú-kélu nekendu sumbulsuli muluringma-ni numanu kimbú-siku kene, ‘Bonongu sumbulsuli numúna anduli sip tilu mindi ya lim, Yesos akuna suku naa pumu, yu lumbili anduli yima eni-enini akuna suku puku numú-kélu nekendu púngi.’ niku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kanu-kene bonongu Auliele-ni langi wallú-sele liipa ambulupa Pulu Yili-ndu “Angke” nimba yambuma sirim nuring koleana nondupa kolea-auli Tapirias yambumanga sip mare numú-kéluna uring. ");
INSERT INTO mux_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yesos-ni langi sirim nuring koleana yambuma-ni Yesos kene lumbili andúlima kene akuna naa muluring koruku kelku kene sip enini muluringna numú-kéluna nondupa oku liringimanga suku puku kolea-kelú Kapeniam taon-na Yesos kurungíndu puring. ");
INSERT INTO mux_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Numú-nekendu oku Yesos kanuku liiku kene enini yu walsiku piliiku niku mele: “Rapai, nu te-kene yandu únuye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Akiliinga-pe ⸤yu urum mele nimba para naa sipa kene⸥ pundu topa eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Na-ni ⸤Pulu Yili-ni na liipa tapunjilimú mele⸥ liipa ora silimú ulu-tonduluma teliáliinga eni na naa korokumele. Na-ni eni langi sindu noku olu tinjing kaniliinga mindi na korokumele lem.” niker. ");
INSERT INTO mux_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Eni langi nondupa purulimúma ‘Liipu nomulú.’ niku kongun naa teai. ⸤Langi kanuma noku kene, kulungí enama wendu olemú kene kolemeleko.⸥ Langi, Mania Omba Mana-Yi Au Talurum Yili-ni silimú langi, kanili naa purulimú, kanili nolemele kene kona molku konjuku mindi pulimelé langi kanili ‘Liipu namili.’ niku mindi kongun teai. ‘ ‘Yi akili-ni sika langi kanili yambuma simba.’ niku piliangi.’ nimba Pulu Yili-ni ulu-tonduluma telemú mele ‘Yi akili-ni ulu-tonduluma aku-sipa tipili.’ nimba Pulu Yili yu-ni yu sirim.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","⸤Yu-ni nirim ungele piliiku sundukuliinga,⸥ enini yundu walsiku piliiku niku mele: “⸤Kona molupu mindi pumulú langi liipu nomulundu⸥ oliu nambi tepu kene Pulu Yili-ni kanupa kaí piliimba kongunuma temulúye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yu-ni pundu topa nimba mele: “Pulu Yili-nga kongunale i-sipa mele: ‘Pulu Yili-ni ma-koleana liipa mundurum yili yu sika Pulu Yili-nga Málale, ⸤yu sika oliu molupu konjupu mindi pumulú ulu-pulele simba yili⸥.’ niku tondulu munduku piliiku molai.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aku nirim piliiku kene enini yundu walsiku kene niku mele: “Nu-ni ‘ “Na sika Pulu Yili-ni liipa mundurum. Na-ni niker ungma sika ungma.” niliu akili ‘Sika’ niku tondulu munduku piliangi.’ nikunu Pulu Yili-ni mindi ulu-tonduluma manda telemú mele nu-ni aku-sikunu nambulka ulu-tondulu te liiku ora siniye? Nambi tiní kene kanupuliinga ‘Nu-ni sika nikinu.’ nimbu piliimulúnje?” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","“Oliunga anda-kolepali ui muluringma kolea-wakana langi-maana nuring. Langi-maana urum mele Pulu Yili-nga bukna temanele molemú: ‘Yu-ni ‘Enini mulú-koleana yandu langi nangi.’ nimba kene sirim.’ ung akili molemú. ⸤Nu-ni oliunga aku-siku tinjiní mola nambulka tiniye?⸥” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesos-ni eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Ui muluring yambuma mulú-koleana yandu langi sirim yili Moses mólu. Tata-ni sirim. Molku konjuku mindi puli ulu-pulu pelemú ga niker ga-sika kanili mulú-koleana yandu silimú yili Tata mindiko.” niker. ");
INSERT INTO mux_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mulú-koleana mania omba mana-yambuma molku konjuku mindi pungí ulu-pulele silimále yu Pulu Yili-ni silimú gale.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yesos-ni nirim mele piliiku sunduku kene, “Auliele, ga akili ekupu kepe yandu-yandu kepe si.” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kanu-kene Yesos-ni eninindu nimba mele: “Molku konjuku mindi pungí gale na. ⸤Ga noku kene engle naa kolku kangi tondulu pupili molemele mele aku-sipa⸥ na molumbuna ungí yambuma eninga minéle engle naa kolumba, numanu tondulu pupili mulungí. Bo-no noku kene no waka naa kolku kapula molemele aku-mele na niliu ungma kepe moliu mele kepe manda tembu mele kepe ‘Sika’ niku tondulu munduku piliingí yambuma alsuku taki-taki minéle no waka naa lipili mulungí. ");
INSERT INTO mux_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aku tingí yambuma aku-siku mulungí akiliinga-pe “Eni na ⸤Pulu Yili-nga ulu-tonduluma teliu mele⸥ kanuku kene kanuku sunduku ‘We telemú. Yu Pulu Yili-ni naa liipa mundurum.’ niku piliilimili.” ui nimbu sirindu kanu-mele ekupu kepe aku-siku mele we teku molemele. ");
INSERT INTO mux_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tata-ni ‘Nanga yambuma molangi.’ nimba makó tolemú yambuma pali na molumbuna ungí. Kanu-kene na lumbili andungíndu na molumbuna ungí yambumanga tiluri kepe “Anju pui.” aima naa nimbú. ");
INSERT INTO mux_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“‘Na-nanu numanuna piliiker mele teambu.’ nimbu na mulú-koleale mundupu kelepu mana-mandu naa urundu, mólu. Na liipa mundurumele-ni numanale-ni piliilimú mele tembu urundu. ");
INSERT INTO mux_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na liipa mundurum yili-ni numanuna piliirim mele i-sipa: ‘Na-ni ⸤nanga Málale⸥ simbu yambuma pali ⸤Málale-ni⸥ nokupa konjupa, tilu kepe mundupa naa kelepa kene mindili nungí koleana aima naa pumba, ma-koleale pora nimbá enaliinga enini pali topa makinjipa olandu liipili.’ nimba numanale-ni piliilimú. ");
INSERT INTO mux_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na liipa mundurum yi Tata-ni numanale-ni piliirim mele te i-sipa: ‘Nanga Málale ‘oliu tepa liipa, mindili nolkemela kupulanumuna wendu liimba.’ niku tondulu munduku piliingí yambuma molku konjuku mindi pangi.’ nimba numanale-ni piliilimú. Kanu-kene aku tingí yambuma ma-koleale pora nimbá enaliinga na-ni topu makinjipu olandu liimbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesos-ni “Na mulú-koleana mandu urundu gale.” nirim piliiku kis piliikuliinga Juda yi-aulima-ni yu arerembi kolku eni-enini pulu monjuku kon-konu niku kene ");
INSERT INTO mux_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","niku mele: “Ung nikem yi akili Josep-nga málu Yesos mindi. Yunga anum lapasele kanolemulu kanili. Pe yu “Mulú-koleana molupu mana-mandu urundu.” nikemale nambi-sipa nikemye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesos-ni nimba mele: “Eni anju-yandu kon-konu manda-teku niai! ");
INSERT INTO mux_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yambu te na we kapula naa lumbili ungí. Na liipa mundurum Tata-ni numanuna kundulimú yambuma mindi na lumbili olemele. Na moliuna oku na tondulu munduku piliilimili yambuma mulú-ma-sele pora nimbá enaliinga na-ni topu makinjipu olandu liimbu. ");
INSERT INTO mux_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pulu Yili-ni “Ninjai.” nimba ung nimba sirimuma piliiku yambuma niku siring yimanga bukna molemú ung te i-sipa mele: “Pulu Yili-ni yambuma pali ung-bo tonjupa mani simba.” niku turing bukna aku-sipa molemú. Tata-ni nilimú mele piliiku kene ung kanumanga puluma piliiku liilimele yambuma pali na moliuna olemele. ");
INSERT INTO mux_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tatanga ungele piliilimili niker akili aima sika yunga ungele piliilimilalendu niker akiliinga-pe yu mongale-ni naa kanolemele. Ma-koleana-yambu tiluri-ni kepe Tata naa kanuring naa kanolemele. Yi tiluele-ni mindi yu kanurum. Tata-kene wasie molupa mania urumele-ni mendepolu yu kanurum. ");
INSERT INTO mux_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Na-ni enindu aima sika nimbu siker: “⸤Niliu ungma⸥ ‘Sika nilimú.’ niku tondulu munduku piliilimili yambuma molku konjuku mindi pungí ulu-pulele enini-kene pelemú.” niker. ");
INSERT INTO mux_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mini pali molku konjuku mindi pungí gale na. ");
INSERT INTO mux_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Eninga kórunga-ui muluring yambuma-ni kolea-wakana langi-maana nuring akiliinga-pe molku mindi naa puring. Eninga kulungí enama wendu urum kene kuluringko. ");
INSERT INTO mux_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“Akiliinga-pe ekupu niker ga ili mulú-koleana mandu okum gale. Akili nungí yambuma mini pali naa kulungí. ");
INSERT INTO mux_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pora naa nimba we lepa mindi puli gale, akuna suku molku konjuku mindi puli ulu-pulele pelemú gale, akili mulú-koleana mandu urum gale na. Ga akili nanga kangiele. ‘Ma-koleana-yambuma, minéle pali molku konjuku mindi pangi.’ nimbu na-ni nanga kangiele eninga gale simbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","⸤Yesos-ni aku nirim piliiku sunduku kene,⸥ yambuma tombulku niku kene, “Yi ili oliu yunga kangiele “Nangi.” nikemale nambi-sipa manda simbandu nikemye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesos-ni eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Eni Mania Omba Mana-Yi Au Talurum Yili-nga kangiele naa noku yunga memale naa núngi lem molku konjuku mindi puli ulu-pulele eni-kene kapula naa pemba.” niker. ");
INSERT INTO mux_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nanga kangiele kene memale-sele nungí yambuma taki-taki molku konjuku mindi pungí ulu-pulele enini-kene pelemú. Yambu kanuma ma-koleale pora nimbá enaliinga na-ni topu makinjipu olandu liimbu. ");
INSERT INTO mux_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","“Nanga kangiele ga-sikale; nanga memale no-sikale. Gale kene nole kene nokuliinga, kulungí enale wendu olemú kene kolemele. Akiliinga-pe nanga kangiele kene memale kene nolemele yambuma molku konjuku mindi pungí. ");
INSERT INTO mux_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nanga kangiele kene memale kene nolemele yambuma enini na-kene tapú-toku molemele, na enini-kene tapú-topu moliu. ");
INSERT INTO mux_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Molupa mindi pulimú Tata-ni na liipa mundurum, yu-ni na ‘Molkunu mindi pani.’ nirim-na molupu mindi puliu, aku-sikuko na nungí yambuma ‘Molku mindi pangi.’ nimbú, kanu-kene enini mini pali molku mindi pungí. ");
INSERT INTO mux_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ga akili mulú-koleana mandu urum gale. Eninga ui anda-kolepali muluringma-ni langi-maana akili noku kene ⸤kulungí enama wendu urum kene⸥ kuluring, akiliinga-pe penga ekupu urum gale kene ui urum langi-maanale kene tilu-sipa mólu. Penga ekupu urum ga ili nungí kene taki-taki molku konjuku mindi pungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Juda-yambuma máku toku Pulu Yili-nga ungele piliiring lku te, Kapeniam taon-na angiliirim, akuna suku Yesos-ni yambuma ung-bo tonjupa mani sipa ung akuma nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yesos-ni ⸤yunga kangiele kene memale kene akusele ga kene no kene nungéliinga⸥ nirim mele piliikuliinga Yesos lumbili anduring yambu pulele-ni niku mele: “Ung ili ung-buni tili te nikem. Nae-ni manda piliipa liimbaye? Oliu naa piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yu lumbili anduring yambuma yu-ni nirim ung akili piliiku kis piliiku kene anju-yandu kon-konu niku tombulku niring akili Yesos-ni piliipaliinga, yu-ni eninindu nimba mele: “Ung ili eni piliiku kis piliikimiliye? ");
INSERT INTO mux_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pe ekupu Mania Omba Mana-Yi Au Talurum Yili ui mulurumna alsupa olandu pumu kanúngi lem nambi tingíye? ⸤Kamu arerembi kulungínje?⸥ ");
INSERT INTO mux_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Minéle-ni kona molku puli ulu-pulele silimú; kangiele-ni kona molku pungí ulu te naa telemú. Na-ni enindu ung nindu akuma kona molku mindi puli ulu-pulele. Akuma eninga numanuna suku pemba kene eni mini pali kona molku mindi pungí. ");
INSERT INTO mux_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Akiliinga-pe eni molemele yambu mare-ni ‘yu gólu tokum.’ niku piliikimili.” nirim. Yu-ni piliipa ‘Yu gólu tuli yili.’ niku piliingí yambuma kene ‘Yu sika-ung nili yili.’ niku piliingí yambuma kórunga apurupa piliipa, Yesos yu yunga ele-túma liipa simba yili kórunga piliipa mulurumeliinga “Eni mare-ni na ‘Gólu tokum.’ niku piliikimili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yu-ni ung te wasie nimba mele: “Eni mare-ni na ‘Gólu tolemú.’ niku piliilimiláliinga ‘Tata-ni “Na moliuna pai.” ni naa nilimú yambuma na moliuna kapula naa oku, na “Sika” niku tondulu munduku kapula naa piliiku andungí.’ ui nimbu sindu kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ung nirim ena-mong akiliinga kepe penga enamanga kepe yu lumbili anduring yambu pulele yu-ni nirim mele piliiku kis piliikuliinga yu munduku kelku liiku bulu siku alsuku yu lumbili naa puring. ");
INSERT INTO mux_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yu munduku kiliring kene yu lumbili anduli yi rurepukandu yu-ni walsipa piliipa nimba mele: “Eni kepe na ‘Mundupu kelepu anju pumulú.’ niku piliikimiliye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon-Pita-ni pundu topa nimba mele: “Auliele, nae molemúna pumulúye? Kona molupu konjupu mindi pumulú ungma nu-kene pelemú. ");
INSERT INTO mux_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","‘Nu Pulu Yili-ni makó topa ‘Nanga Yi Kake Tiliele.’ nirim yili mollu.’ nimbu oliu-ni piliipu pora sipu tondulu mundupu piliilimulu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesos-ni pundu topa nimba mele: “Na-ni nanu eni yi rurepukandu pali ‘Nanga yima molangi.’ nimbu makó turundu akiliinga-pe eninga yi te ⸤kuru-⸥depollale mele molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Aku nirimele Saimon-Iskeriot málu Judas-ni tembalendu piliipaliinga nirim. Judas-Iskeriot yu enini yi rurepu akumanga yi te akiliinga-pe yu-ni penga Yesos liipa yunga ele-tu yima sirim-na turing.) ");
INSERT INTO mux_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kanu-kene penga Yesos kolea Gallalli distrik andupa mulurum. Juda yi-auli kolea Judia distrik muluringma-ni yu toku kunjingíndu nokuku muluringeliinga piliipaliinga yu kelepa ‘Judia naa pumbu.’ nimba anju mulurum. ");
INSERT INTO mux_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Akiliinga-pe Juda-yambuma-ni ui kolea-wakana sell-lku takuku piring enama piliiring ena kake tílima nondupa wendu ombá tirim kene ");
INSERT INTO mux_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesos yunga anginipilima-ni yundu niku mele: “‘Nu-ni ‘ulu-tonduluma tellu mele nu lumbili andolemele yambuma-ni kanangi.’ nikunu nu ya koleale munduku kelkunu kolea Judia distrik-ndu pani.’ nimbu piliikumulu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","“Yambu te-ni ‘yu kongun tepa molemú mele piliiku yu kanuku bi sangi.’ nimba uluma mo topa naa telemú. Akiliinga nu ulu akuma sika tellu lem yambuma-ni pali kanangi puku ti-pui.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesos-nga anginipilima-ni kepe ‘Yesos yu Pulu Yili-ni liipa mundurum-na urum yili.’ niku naa piliikuliinga aku-siku niring. ");
INSERT INTO mux_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aku niringeliinga Yesos-ni eninindu nimba mele: “Nanga enale ui wendu naa uli. Akiliinga-pe eni uluma taki-taki tingíndu enama naa piliiku apuruku, enama pali “Oliunga” niku uluma walu-siku telemele. ");
INSERT INTO mux_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma-kolea yambuma eni-kene numanu kis naa panjilimele akiliinga-pe na-ni yambumandu “Ulu telemelema teku kis-silimele.” niliáliinga na-kene numanu kis panjilimele. ");
INSERT INTO mux_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Eni ena kake tiliele wendu ombále pilii-pungí lem pangi. Akiliinga-pe nanga enale ui naa wendu okumaliinga na ⸤ui⸥ naa pumbu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aku nimba kene yu kolea Gallalli we mulurum. ");
INSERT INTO mux_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Akiliinga-pe Yesos yunga anginipilima ‘Ena kake tílima oliu wasie piliamili.’ niku ui puring kene Yesos kepe purum. Akiliinga-pe Yesos yu ‘naa kanuku bi sangi.’ nimba kiyang nimba ⸤kolea Gallalli distrik mundupa kelepa Jerusallem⸥ purum. ");
INSERT INTO mux_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Akuna Juda-yambumanga ena kake tílima piliiring Juda yi-aulima-ni ‘Yesos um-nje.’ niku koruku molku kene eni-enini niku mele: “Yi kanili tena molemúnje?” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","we-yambumanga pulele-ni yundu ólu-walu toku niku anduku muluring. Mare-ni niku mele: “Yu yi kaiéle.” niring. Akiliinga-pe mare-ni niku mele: “Yu yandupa yambuma gólu topa silimú.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Akiliinga-pe yambuma-ni Juda yi-aulimanga mundu-mong tenjiku kene ‘Oliu nikimulu mele enini piliiku kene oliu teku kis-singí.’ niku ung tondulu teku naa niring. ");
INSERT INTO mux_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kake tili enama ui wendu urum suku-singina ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna pupaliinga Yesos yambuma ung-mani sirim. ");
INSERT INTO mux_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ung-mani sirim mele piliiku kene Juda yi-aulima-ni mini-wale munduku kene niku mele: “Yi ili nambi-sipa piliipa kungnjuli pelemúye? Yu skull auli tenga naa purum kanili.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesos-ni pundu topa nimba mele: “Ung nimbu siliu ili nanga ung te mólu. Na liipa mundurum-na urundu yilinga ungele. ");
INSERT INTO mux_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","‘Pulu Yili-ni “Teai.” nilimú uluma piliipu liipu teambu.’ nimba piliipa molemú yambale-ni na-ni ung niliu ungeliinga pulele piliipa kene, ‘Na-ni Pulu Yili-nga ungele nilimú.’ mola ‘Yu-ni yunu numanale-ni piliipa nilimú.’ nimba piliimba. ");
INSERT INTO mux_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yambu te-ni yu-yunu numanale-ni piliipa kene ung nimba silimále-ni ‘Nanga bili ola pípili.’ nimba telemú, akiliinga-pe yambu te-ni ‘Liipa mundurum yilinga bili paka tonjambu.’ nimba kongun telemú yambale yu yambu sumbi-nili te molupa, tepa kis-sipa gólu tuli yambu te naa molemú. ");
INSERT INTO mux_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ui Moses-ni ⸤“I-siku teai.” nimba “I-siku naa teai.” nimba⸥ eni ⸤Pulu Yili-nga⸥ ung-manima naa sirimye? Sirim akiliinga-pe eni molemelemanga tiluri-ni kepe ung-mani kanuma piliiku teng panjiku naa telemele. Aku lem ‘Na ung-mani kanuma topa pula tolemú.’ niku nambimuna toku kunjingí tekemeleye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yu-ni aku-sipa nirim piliiku kene yambuma-ni pundu toku niku mele: “Nae-ni nu topa konjumba tekemuye? Nunga numanuna kuru te molemáliinga piliikunu kene aku-siku nikinu lam.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesos-ni eninindu pundu topa nimba mele: “Na-ni ulu-tondulu te tirindu kene eni numanu pulele liiku munduring. ");
INSERT INTO mux_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-ni ‘Kangmanga kangi te kopsiku poku teai.’ nimba ung-mani sipa panjurumeliinga eni kóru molemele ena-Sambatele kene kangmanga kangi te kopsiku poku telemele. (Sika Moses-ni ui-pulu-pulu ‘ulu akili teamili.’ ni naa nirim. Ui eninga anda-kolepalima-ni ulu akili tiring, akiliinga-pe penga Moses-ni ⸤yandupa⸥ ung-mani kanili sipa panjurumeliinga piliiku kene telemele.) ");
INSERT INTO mux_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eni Moses-ni ung-mani sirimele piliiku liiku kene kang tenga kangi te kupsingí enale eni kóru molemele ena-Sambatele wendu olemú kene kopsilimele lem kapula, na Sambat-enale kene yi te tepu kaí tirindeliinga na-kene nambimuna arerembi kolemeleye? ⸤Sambat-enale kene⸥ Sambat-enaliinga ung-manele pula toku ⸤kang tenga kangi te kopsiku wendu liiku kene ‘Papu tekemulu.’ níngi lem Sambat-enale kene na-ni yi tenga kangiele pali tepu kaí tirindu akili papuko tirindu.⸥ ");
INSERT INTO mux_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Eni mongale-ni kanolemele uluma kanuku kene lkisiku ‘Ili sika. Ili gólu.’ niku naa piliangi! Uluma mimi-siku kanuku numanale-ni piliiku kene sumbi-siku apuruku konjai.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yu aku-sipa nimba mulupili Jerusallem muluring yambu mare-ni eni-enini walsiku piliiku kene niku mele: “Yi ili ‘Topu konjamili.’ niku molemele yi akili yi ili móluye? ");
INSERT INTO mux_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Akiliinga-pe kanai. Yambu pulele molemelena yu mokeringa omba angiliipa ung-mani sikemu akiliinga-pe yi-aulima-ni yu ulu te naa tekemele. Enini ‘Yu sika Pulu Yili-ni ‘Oliu nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele.’ niku piliikimilinje? ");
INSERT INTO mux_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Akiliinga-pe oliu-ni yi ilinga pulu-koleale kanolemulu. Pulu Yili-ni liipa mundumba yi-nuim Kraisele ombá kene yambu te-ni yu molupa ombá koleale naa kanupa bi simba.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanu-kene Yesos lku-tembolluna ung-bo tonjupa mani sipa we molupa kene, nangale topa nimba mele: “Sika eni na kanuku bi siku, na molupu úndu koleale kanolemeleye? Na-nanu numanale-ni piliipu kene naa urundu. Na liipa mundurum-na urundu yili yu-kene sika ulu-pulele pelemú yili. Yi kanili eni naa piliilimili ");
INSERT INTO mux_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","akiliinga-pe na yu-kene wasie molupu kene, yu-ni na liipa mundurum-na urundu akiliinga na-ni yu kanupu bi siliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aku-sipa nirim kilia piliikuliinga yu ambolku liiku ka singí tiring akiliinga-pe yu toku kunjingí enale ui wendu naa urum kilia yambu te-ni yu naa ambulurum. ");
INSERT INTO mux_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Yambu pulele-ni aku tingí tiring akiliinga-pe yambu pulele-ni niku mele: “Pulu Yili-ni ‘Liipu mundumbu.’ nimba makó turum yi-nuim Kraisele omba kene, yi ili-ni yu molemú mele liipa ora silimú ulu-tonduluma telemú mele yi kanili-ni ulu-tondulu olandupama manda tembaye? ‘Yi-nuim Kraisele-ni temba.’ nimbu piliilimulu uluma yi ili-ni telemú.” niku kene ‘Yu sika yi kanili.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yambuma-ni Yesos aku-sipa mulurum mele aku-siku anju-yandu ólu-walu toku tombulku niring mele Juda yi-auli Perisima-ni piliikuliinga, enini kene Pulu Yili popu tunjuring yi-aulima kene enini lku-temboll ele-yi marendu “Yesos puku ka si-pai!” niku liiku munduring. ");
INSERT INTO mux_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kanu-kene Yesos-ni nimba mele: “Laye-sele mindi eni-kene wasie molupu kene, penga na liipa mundurum yili molemúna kelepu pumbu. ");
INSERT INTO mux_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Penga eni na kurungí akiliinga-pe naa kanuku liingí, molumbuna kapula naa ungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juda yi-aulima-ni enini anju-yandu tombulku kene niku mele: “Yu tena pumba-na oliu yu manda naa pupu kanupu liimulúye? Aku lem oliunga Juda-yambu mare ui kolea lupamanga puring molemele koleamanga pupa yambu-talape lupama ung-bo tonjupa mani sipa molumbáliinga naa kanumulúnje? ");
INSERT INTO mux_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yu-ni ui nimba mele: “Na kurungí akiliinga-pe eni na manda naa kanuku liingí. Na molumbuna eni manda naa ungí.” nim kanili ung-pulele nambulkanje?” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Penga, yambuma Jerusallem oku máku toku kake tili enamanga uluma tiring enama pora nimbándu ena auliele wendu urum kene Yesos ola angiliipa kene tondulu mundupa nimba mele: “Yambu te no waka kulum lem na moliuna omba no nupili. ");
INSERT INTO mux_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na moliu niliu mele “Sika” niku tondulu munduku piliingí yambuma eninga numanumanga kona molupa mindi puli noma pikipa wendu ombá. Pulu Yili-nga bukna ung te aku-sipa nimba molemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yu-ni ung nirimaliinga pulele i-sipa mele: “Yu Pulu Yili-ni sika liipa mundurum, oliu tepa liimba yili molemú.” niku tondulu munduku piliingí yambuma penga walse Pulu Yili-nga Minéle eninga numanumanga omba molumba liingélendu nirim. Yesos ui kolupa lomburupa ola molupa mulú-koleana kelepa olandu naa purumeliinga Mini ⸤Kake Tiliele⸥ ui naa urum. ");
INSERT INTO mux_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesos-ni ung nirim-ma yambuma-ni piliiku kene, mare-ni niku mele: “Moses-ni ui nimba mele: ‘Pulu Yili-ni “Ninjui!” nimba ung nimba simbama piliipa yambuma nimba simba yi te ombá.’ nirimele yi ili lam.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","42","Mare-ni niku mele: “Yu Pulu Yili-ni ‘oliu nokupa konjumba yi te liipu mundumbu.’ nimba makó turum yi-nuim Kraisele.” niring. Mare-ni niku mele: “Pulu Yili-ni liipa mundumba yi-nuim Kraisele kolea Gallalli distrik molupa kene ombáye? Yu Gallalli naa mingí. Pulu Yili-nga bukele-ni nimba mele: ‘Pulu Yili-ni liipa mundumba yi-nuim Kraisele yi nuim king Depit-ni kalupa liimba. Depit yu miring kolea-kelú Betelliem taon akuna yi-nuim Kraisele mingí.’ nilimú kaniliinga yu kolea Gallalli distrik kapula naa mingí.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aku-siku yambuma Yesos mulurum mele tombulku niku numanuna lupa-lupa piliiring. ");
INSERT INTO mux_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yambu mare-ni ‘Yesos ka samili.’ niku piliiku muluring akiliinga-pe te-ni yu pupa ambulupa naa liirim. ");
INSERT INTO mux_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lku-temboll ele-yima-ni Yesos kene yambuma kene niku muluring mele piliiku molku kene, penga we kelku yandu oku Pulu Yili popu tunjuring yi-aulima kene Perisi yima kene muluringna puring. Yesos ka siku naa meku uring kilia kanukuliinga enini ele-yimandu niku mele: “Yili nambimuna ⸤ka siku⸥ naa meku úngiye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ele-yima-ni niku mele: “Mólu. Yi te-ni ui ung-bo tonjuku mani silimele mele yu-ni aku-sipa ung-bo naa tunjúmu. Yu-ni ung-mani aima lakupa ung-bo tunjúmu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Perisima-ni piliiku kis piliiku kene niku mele: “Yunu-ni gólu topa ung nimuma ‘Sika nim.’ niku piliiku eni we kelku yandu úngiye? ");
INSERT INTO mux_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oliunga yi-aulima kene Perisi-yima kene oliunga yi te-ni “Yu molemú nilimú mele sika akili molemú.” nimba pilíímuye? ⸤Mólu, te-ni aku-sipa naa nimba pilíímu kanili.⸥ ");
INSERT INTO mux_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Akiliinga-pe we-yambu máku toku mulúngima Moses-ni ung-mani sirim pelemúma aima naa piliilimili. Pulu Yili-ni eninga kotele kórunga piliipa, kulungí kene ‘Mindili nangi.’ nimba panjurum.” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, yu ui walse Yesos mulurumna purum yi kanili, Perisi-yi kanumanga te yu, yu-ni enini walsipa kene nimba mele: ");
INSERT INTO mux_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Oliunga ung-manima-ni ‘Yambu te kot naa piliiku kene we “Mong liikimeliinga buni mipili.” niai.’ nilimúye? Yu ui kot-na omba kene nilimú mele piliipu kene penga ung nilimúmanga puluma apurupu piliimulú kanili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Perisi-yima-ni yundu pundu toku niku mele: “Aku lem nu kepe kolea Gallalli yi te-nje? Pulu Yili-nga bukna sukundu mimi-sikunu kanui. Mimi-siku kanukunu kene, ‘Pulu Yili-ni “Ninjui!” nimba ung nimba simbama piliipa yandu nimba simba yi te Gallalli wendu ombá.’ nimba pelemú kanuníye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yambuma pali lkundu bulu-bale niku puring ");
INSERT INTO mux_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","akiliinga-pe Yesos ‘Unji-Ollip Punie Lili Ma-Pangiele’ nili akuna olandu purum. ");
INSERT INTO mux_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kanu-kene ipulam-ui, kolea tangumba muni lirim kene yu kelepa ⸤Pulu Yili popu toku kaluring⸥ lku-tembolluna purum kene yambuma yu mulurumna oku máku toku muluring kene enini ung-bo tonjupa mani simbandu yu mania mulurum. ");
INSERT INTO mux_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Kanu-kene Pulu Yili-nga ung-manimanga puluma piliiku ung-bo tonjuku mani siring yima kene Perisi-yima kene enini ambu yi puli te yi te kene waperanale tiringliele liiku meku oku yambuma muluring kumbi-kerina oku ola angnjiku kene, ");
INSERT INTO mux_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesos-ndu niku mele: “Ung-Bo Tunjuliele, ambu yi puli ili yi te kene waperanale teku mulúngli yambuma-ni kanúngi-na membu okomulu. ");
INSERT INTO mux_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses-ni ung-mani te sipa panjipa kene nimba mele: “Ambu aku tembale ku-ni toku konjai.” nirim akiliinga nu-ni nambulka niniye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Akiliinga-pe enini sika piliingíndu naa niring. ‘Yu-ni nambulka nimbánje? Nimba kis-simba kene kot tenjimulú.’ niku aku-siku walsiring. Akiliinga-pe Yesos ma kanupa kili-ni mana bi topa mulurum. ");
INSERT INTO mux_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kanu-kene yu taki-taki walsi-pui-upui tiringeliinga olandu-sipa kanupa kene eninindu nimba mele: “Eninga yi te ulu-pulu-kis te naa pelemú yi te-ni ambu ili kumbi-lepa ku-ni tupili.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aku nimba kene yu kelepa ma kanupa mana bi topa mulurum. ");
INSERT INTO mux_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aku nirim-na piliikuliinga yi-aulima enini te tale niku pena-pena puku Yesos munduku kelku enini puring. Yi-aulimanga yi-nuimima ui kumbi-leku puring kanu-kene we yi-aulima aeleku puring kene Yesos yu-yunu mindi mulurum, ambale yu mulurumna we angiliirim. ");
INSERT INTO mux_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kanu-kene Yesos olandu-sipa kanupa kene ambale walsipa nimba mele: “Ambale, yima tena molemeleye? Yi te-ni nu ‘Teku kis-sínaliinga kot tenjambu.’ naa nimuye?” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ambale-ni nimba mele: “Auliele, yi te-ni na kot naa tenjimba tekem.” nirim. Yesos-ni nimba mele: “Na-ni kepe ‘Nu-ni teku kis-sínaliinga mindili nani.’ naa nikeraliinga nu pukunu kene ulu-pulu-kis tellu mele munduku kelkunu, alsuku naa ti!” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yambu muluringmandu Yesos-ni kelepa nimba mele: “Na ma-koleamanga pali yambumanga pa tinjiliele. Na andupu molumbuna lumbili anduku mulungí yambuma sumbulú túlina naa anduku mulungí. Kona mululi ulu-pulele silimú pa tiliele kene mulungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Aku nirim-na yi-auli Perisima-ni piliikuliinga yu-kene toku monjuku niku mele: “Nu mollu mele nu-nunu nikunu sillu akiliinga nu-ni ung nikinuma piliipu kene ‘Sika nikem.’ nimbu piliilkimilanje kapula naa telka.” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesos-ni pundu topa nimba mele: “Na ui molupu urundu koleale kepe kelepu pumbu teker koleale kepe piliipu moliáliinga na moliu mele sika na-nanu niliu akiliinga-pe na-ni ung niker ili ung-sikale. Akiliinga-pe na molupu urundu koleale kepe penga pumbu teker koleale kepe eni naa piliikimili. ");
INSERT INTO mux_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mana-yambuma-ni piliiku apuruku telemele mele eni Perisi-yima-ni aku-siku piliiku kene apurulimele, akiliinga-pe na-ni yambu te naa apuruliu. ");
INSERT INTO mux_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Akiliinga-pe na-ni sika ⸤yambu te mola ung te piliipu apuruliu lem na-nanu mendepulu naa apuruliáliinga sumbi-sipu apuruliu. Na liipa mundurum yi Tata-kene wasie tapú-topu ⸤kongun tepulu⸥ molembulu kanili. ");
INSERT INTO mux_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eninga ung-mani te bukna molemú kanili i-sipa mele: ‘Yambu tale-ni ung te niku síngli lem ‘Ung akili sika.’ niangi.’ aku-sipa nimba pelemú. ");
INSERT INTO mux_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Akiliinga na moliu mele na-nanu nimbu siliále kepe; na liipa mundurum yi Tata-ni na moliu mele nimba silimúko.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kanu-kene enini walsiku kene niku mele: “Lanie tena molemúye?” niring. Yesos-ni pundu topa nimba mele: “Eni na kepe nanga Lapale kepe naa kanuku bi silimele. Eni na kanuku bi silkimelanje Tata kepe kanuku bi silkimelako.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesos lku-tembolluna sukundu, Pulu Yili-nga niku yambuma-ni ku-moni munduring mingima lirim koleana Yesos molupa yambuma ung-bo tonjupa mani sipa molupa kene ung ima nirim. Akiliinga-pe yunga enale wendu naa urum-na yambu te-ni yu ambolku liiku ka naa siring. ");
INSERT INTO mux_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesos-ni alsupa Juda yi-aulimandu nimba mele: “Na ekupu pumbu teker, kanu-kene enini na koruku kelku kene eninga ulu-pulu-kis ⸤telemele⸥ma numanuna pípili kulungí. Na pumbu koleana eni manda naa ungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aku nirim-na piliiku kene Juda yi-aulima-ni eni-enini tombulku walsiku kene niku mele: “Aku nambimuna ‘Na pumbu koleana eni manda naa ungí.’ nikemye? Aku lem yu-yunu topa konjumbanje?” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesos-ni kelepa nimba mele: “Eni mania yambuma, na ola yili. Eni ma-kolea pulu yambuma, na ma-kolea pulu yi te mólu. ");
INSERT INTO mux_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na-ni enindu ui nimbu mele: “Ulu-pulu-kis ⸤telemele⸥ma numanuna we pípili kulungí.” nindu kanili. Akili “Na ekupu moliu, ui-pulu-pulu mulurundu, penga molupu mindi pumbu yili.” nimbu siliu mele eni ‘Sika akili molemú.’ niku tondulu munduku naa pilííngi lem penga eni kulungí kene sika eninga ulu-pulu-kísima numanuna we pípili kulungí.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Perisi-yima-ni yu walsiku kene niku mele: “Nu naeye?” niring. Yesos-ni pundu topa nimba mele: “Na moliu mele eni taki-taki nimbu siliu kanili na mindi. ");
INSERT INTO mux_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na-ni eni molku ulu telemele mele piliipu apurupu kene eni teku kis-silimele mele ung pulele nimbu silka akiliinga-pe na-nanu numanale-ni piliipu kene ungma naa niliu. Na liipa mundurum yili, yu ulu sikama mindi tepa ung sikama mindi nilimú yi, kanili-ni nilimú mele mindi piliipu kene mana-yambuma nimbu siliu.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yu-ni Lapandu nirim akiliinga-pe enini yu-ni nirim mele pulele naa piliiringeliinga ");
INSERT INTO mux_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesos-ni eninindu nimba mele: “Penga eni Mania Omba Mana-Yi Au Talurum Yili ola ku toku panjiku kene eni piliiku kene “Na ekupu moliu, ui-pulu-pulu mulurundu, penga molupu mindi pumbu yili.” nimbu siliu mele eni ‘Sika akili molemú.’ niku piliiku kene kepe, “Na-nanu numanale-ni piliipu kene naa teliu. Tata-ni na mani silimú mele mindi piliipu kene niliu.” taki-taki nimbu siliu ‘Akili sika.’ niku piliingí. ");
INSERT INTO mux_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na liipa mundurum-na urundu yili na-kene wasie tapú-topulu molembulu; taki-taki yu kanupa kaí piliilimú uluma mendepolu teliáliinga yu-ni walsekale kepe na mundupa naa kelelemú.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesos yu-ni aku-sipa nimba mulupili kepe yambu pulele ‘Yu Pulu Yili-ni sika liipa mundurum.’ niku tondulu munduku piliiring. ");
INSERT INTO mux_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‘Yu sika.’ niku piliiring Juda-yambumandu Yesos-ni nimba mele: “Na-ni ung-bo tonjupu mani siliuma sika piliiku liiku teng panjiku mulúngi lem eni sika nanga lumbili anduli yambuma mulungí. ");
INSERT INTO mux_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aku teku kene, eni ung-sikale piliingí kanu-kene eni ka silimú mélema ung-sikale-ni wendu liipa ‘eni we molku konjangi.’ nimbá.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Enini pundu toku yundu niku mele: “Oliu Eprayam-ni kalupa liirim yambuma molupu, yambu tenga ka-kongun te naa tenjipu mulurumulu. Aku lem nu-ni ‘Ka silimú mélema wendu pumba oliu molku kunjingí.’ nikinu akili nambi-siku piliikunu kene nikinuye?” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesos-ni pundu topa kene nimba mele: “Na-ni eni aima sika nimbu siker: “Yambu ulu-pulu-kis telemelema ulu-pulu-kismani ka silimú-na ulu-pulu-kis akumanga ka-kongun telemele. ");
INSERT INTO mux_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ka-kongun telemú kendemande-yambale lku pulu yambuma kene wasie kamu naa molemú, akiliinga-pe kangambula te yunga lku pulu yambuma kene taki-taki tiluna tapú-toku molemele. ");
INSERT INTO mux_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Akiliinga, ⸤Lku Pulu Yili-nga⸥ Málale-ni ‘Eni ka silimú mélema mundupa kilipili, eni we molku konjangi.’ nim lem méle te-ni sika ka naa simba, we aima sika molku kunjingí.” niker. ");
INSERT INTO mux_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","“‘Eni Eprayam-ni kalupa liirim yambuma molemele.’ nimbu piliipu moliu akiliinga-pe eninga numanuna nanga ungele naa pelemáliinga na toku kunjingí tekemele. ");
INSERT INTO mux_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na Tata-kene molupu kanurundu mele eni nimbu siliu. Eninga lapale-ni nilimále eni piliiku kene telemele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","⸤Yesos-ni yambumandu “Eninga lapalenga ungele eni piliiku kene telemele.” nirim mele akili piliikuliinga⸥ Juda-yambuma-ni pundu toku niku mele: “Oliunga lapa kalupa liirimele Eprayam.” niring. Yesos-ni nimba mele: “Mólu. Eni sika Eprayam-ni kalupa liirim yambuma molkemelanje Eprayam-ni tirim mele eni aku-siku telkemela. ");
INSERT INTO mux_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Akiliinga-pe aku naa telemele. Pulu Yili-ni na nimba sirim ungma na piliirindu ung-sikama eni nimbu siliu yili toku kunjingí tekemele. Eprayam-ni aku-sipa mele naa tirim. ");
INSERT INTO mux_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Eninga lapale-ni telemú mele eni manda leku telemele.” nirim. Enini tondulu karaye teku kene niku mele: “Oliunga anumele yi-te-lupa kene wapera topa kene oliu naa mirim. Oliunga lapa tilu kanili Pulu Yili mindi.” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesos-ni eninindu nimba mele: “Na Pulu Yili-kene molupu urundele ekupu ya moliáliinga, Pulu Yili yu sika eninga Lapale molkanje eni na numanu monjulkemela. Na-nanu numanale-ni piliipu kene naa urundu. Yu-ni na liipa mundurum-na urundu. ");
INSERT INTO mux_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na-ni ung niliumanga pulele nambimuna sumbi-siku naa piliilimiliye? ‘Ung-pulele naa piliimulú.’ niku piliiku naa liilimele akiliinga nanga ungele eni naa piliilimili. ");
INSERT INTO mux_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eni ⸤kurumanga nuim⸥ Depollale-nga kangambulama, Seten eninga lapale. Eninga lapale-ni kanupa kaí piliilimú mele ‘teamili.’ niku kene yu-ni “Eni teai.” nilimú mele ‘Aima teamili.’ nilimele. Ui-pulu-pulu mulú-masele koela wendu urum kene yu yambu topa kunjuli yili mulurum mele aku-siliele yandupa ekupu we molemú. Yu ung-pulu sika te naa pirim-na sika-ung te walsekale kepe aima naa nirim. Yu gólu tolemú yili; yu sika gólu tuli ungeliinga pulu-yili molemáliinga ui yu gólu turum mele yandupa ekupu kepe penga kepe gólu mindi tolemú tomba. ");
INSERT INTO mux_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Akiliinga-pe na-ni ung-sikama nimbu siliáliinga eni naa piliiku ‘Gólu tolemú.’ niku piliilimili. ");
INSERT INTO mux_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Nae-ni nanga numanuna ulu-pulu-kis tilu kepe pelemú nimba manda liipa ora simbaye? ⸤Te naa pelemú akiliinga-pe⸥ na-ni ung-sikale niliu lem ‘Sika nikem.’ niku eni nambimuna naa piliilimiliye? ");
INSERT INTO mux_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pulu Yili-nga kangambulama-ni Pulu Yili-ni nilimú ungele piliiku liilimele. Eni Pulu Yili-nga kangambulama naa molku kene yunga ungele na-ni nimbu siliuma “Naa piliimulú.” niku, piliiku naa liilimele.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda yi-aulima-ni yundu pundu toku niku mele: “ “Nu Sameria-yi te, nunga numanuna kuru te molemú.” nilimulu kanili sika nilimulu.” niring. ⸤Juda-yambuma-ni Sameria-yambuma kene numanu kis panjiring kaniliinga yu ung-mura siku ung-taka tonjuku “Yu yi kis te.” ningíndu “Nu Sameria-yi te.” niring.⸥ ");
INSERT INTO mux_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Niring mele piliipa kene Yesos-ni pundu topa eninindu nimba mele: “Nanga numanuna kuru te naa molemú. Na-ni Tatanga bili paka tonjuliu, akiliinga-pe eni nanga bili teku kis-sinjilimele. ");
INSERT INTO mux_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na-nanu ‘Bi ola mulupili.’ naa niliu, akiliinga-pe yi te molemú akili-ni ‘Na bi ola mulupili.’ nimba nanga bili paka tonjulemú. Yi kanili-ni na-ni niliu mele kepe eni nilimele mele kepe mimi-sipa piliipa apurupa te-ni ‘Sika nikem.’ nimba piliipa molemú. ");
INSERT INTO mux_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na-ni enindu aima sika nimbu siker: “Yambu te nanga ungele piliipa liipa tepa molumba yambale aima kamu naa kolupa, molupa mindi pumba.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juda yi-aulima-ni yundu niku mele: “Ekupu oliu piliikumulu, kuru te aima sika nunga numanuna molemú. Anda-kolepa Eprayam kulurum; Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yima kuluringko. Akiliinga-pe nu-ni nikunu mele: “Nanga ungele piliipa liipa molumba yambale kamu naa kolumba.” nikinu. ");
INSERT INTO mux_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Eprayam-nga bili mania mele molupa nunga bili ola molemúye? Yunga bili aima ola, akiliinga-pe yu kepe kulurumko. Pulu Yili-ni “Ninjai!” nimba ung nimba sirimuma piliiku yambuma niku siring yambuma kepe bi ola mulurum akiliinga-pe kuluringko. Nunga bili ola-kilia, eninga bima mania-kiliaye? Aima mólu! Nu yi-korupa-wele.” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesos-ni pundu topa nimba mele: “Na-ni nanga bili na-nanu paka tolkanje na bi aima sika ola naa molka, na we mindi nilka. Akiliinga-pe akili mólu. Tata, yundu eni “Oliunga Pulu Yili.” nilimele kanili-ni nanga bili paka tonjulemú. ");
INSERT INTO mux_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eni yu naa kanuku piliilimili akiliinga-pe na-ni yu kanupu piliiliu. Na-ni “Yu naa kanupu piliiliu.” nilkanje eni gólu túlima molemele mele na aku-sipu molka. Akiliinga-pe na-ni yu aima sika kanupu piliipu, yunga ungele piliipu liipu tepu moliu. ");
INSERT INTO mux_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Eninga anda-kolepa Eprayam-ni ‘Na mana-mania ombá enale kanombu.’ nimba piliipaliinga numanu sipa mulurum. Ena kanili kamu kanupa kene numanu sirim.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kanu-kene Juda yi-aulima-ni yundu niku mele: “Nunga punie tokapu tale ui naa pora nili. Nu kang-yili mindi. Pe nu “Eprayam kanurundu.” nikinuye? Nu-ni yu kapula naa kanurunele. Gólu tokunu.” niring. ");
INSERT INTO mux_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesos-ni eninindu nimba mele: “Na-ni enindu aima sika nimbu siker: “Eprayam sika aima kórunga-ui molupa kulurum akiliinga-pe yu ui naa mulupili na mulurundu.” niker.” nirim. ");
INSERT INTO mux_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aku nirim-na piliikuliinga ⸤Pulu Yili marake tepa ‘Pulu Yili moliu.’ nimba nirim-na piliikuliinga⸥ enini “Yu topu konjamili.” niku ku-mulú liiku yu tungí tiring. Akiliinga-pe Yesos mo topa kene, lku-tembollun