﻿USE sofia;
DROP TABLE IF EXISTS sofia.mur_vpl;
CREATE TABLE mur_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mur_vpl WRITE;
INSERT INTO mur_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Baale ɔɔwa e ɛɛnyca Jooi tammu taden ki looc. ");
INSERT INTO mur_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Maje baale laadun e kaal dook alaŋ azedi kiyo inoko o, ma adala maama looc dook, maje muuri adala maam kizi koli tɛr. Aje Vɔŋizi o Joowo awɔ maam tadena ka kutugu liŋliŋɔn onin. ");
INSERT INTO mur_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Izi ni Jooi nɛ, “Abon abil vooritin tɔ,” ma didi anai vooritin wak. ");
INSERT INTO mur_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ma acin Jooi vooritin nico abon ɔrɔɔt. Ɛŋɛr ni niini vooritin kibeen muur. ");
INSERT INTO mur_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ma awo vooritin azi nɛ waazin, ma awo muur azi nɛ baalin. Nica baale iiten o oowu nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Izi ni Jooi nɛ, “Abon anyak ŋinti aŋɛr maama lak ram.” ");
INSERT INTO mur_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ɛtɛɛnya ni niini tammu kɛŋ ka kɛŋɛr maam ci ɛɛl loota o kibeen maam ci ɛɛl tadena o. Ma agooni didi zɔɔz nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ma awo niini ŋinti aŋɛrɔn maama o azi nɛ tammu kɛŋ. Nica zin waanice iiten ween ram nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ma bodo azi Jooi nɛ, “Abon aromɛ maama ci ɛɛl loota o dook ŋaatodoi ka keyelizyai ŋinti adɔi akɔm maam.” Ma didi agooni nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ma awo Jooi ŋinti akɔm maam o azi nɛ tɔdɔ, ma awo vitɛn ci anyak maam o azi nɛ liilok. Ma acin niini gi nico abon ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Izi ni Jooi nɛ, “Anyek tɔdɔ kuduntai kaal ci abiir kanyayit kɛbɛrɛ ci aduŋna bodo kiyo niigi o.” Ma agooni didi gi nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Udunai didi tɔdɔwa kɛɛn kibeen artɛ ci abiirna gɔnɔgi ci ɛɛl kiyo niigi o. Ma acin Jooi kaal nicoko abon ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nica zin waanice iiten ween iiyu nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Izi ni Jooi nɛ, “Abon anyak kaal ci atokol looc tammu kɛŋa ka keŋerit waazin ki baalin, ma buk aŋɛr looloyok ki tagizok, ki iinya been irkitok, ka buk kanycek niigi looc vooritin.” Ma didi agooni gi nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ma ɛɛnyca niini ii kibeen nyelok, ka ii kizi ci waazinu, maje nyɛlɔyi ka kizi ci baalinu. Ma ɛɛnyca buk niini monyony. ");
INSERT INTO mur_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Ma arek niini nɔɔgɔ dook tammu kɛŋ ka kataraanit looc, ka kuzuuti niigi waazin ki baalin, ka buk keŋerit niigi vooritin kibeen muur. Ma acin Jooi kaal nicoko abon ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nica waanice iiten ween wec nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ma azi bodo Jooi nɛ, “Abon anyak liilowa kaal ci meel arogi. Abon buk anyak kibaali ci akul tammu kɛŋa.” ");
INSERT INTO mur_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ɛtɛɛnya ni Jooi kɛlɛk o adikir abaak liilowɛ, ki kaal o liilu arogi dook ka kitirit gɔnɔgi ci ɛɛl kiyo niigi o. Ma buk ɛɛnyca niini kibaali ci akul, ma arita gɔnɔgi ci anyak taba kiyo niigi o. Ma acin Jooi kaal nicoko abon ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Amayuk ni Jooi nɔɔgɔ enek nɛ, “Itirit iziti mɛɛlɛ ɔrɔɔt. Ibitizit maam ci liilu noko.” Ma anek buk kibaali nɛ, “Itirit iziti mɛɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nica waanice iiten ween tur nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ma azi Jooi nɛ, “Abon anyak lɔɔci kaal ci arogi ci arita gɔnɔgi ci ɛɛl kiyo niigi o, kaal o kabal, ki kaal o ababat keŋtinɛ, ka kɛlɛk o too, ka kitirta gɔnɔgi ci ɛɛl kiyo niigi o.” Ma didi agooni gi nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ma ɛɛnyca Jooi didi kɛlɛk o too, ki kaal o kabal, been kaal o ababat keŋtine. Ma acin Jooi kaal nicoko abon ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Izi ni Jooi nɛ, “Abon kɛɛnyca eet ci deer kizi riritɔn cinai ka kabal kuluk ci liilu o, ki kibaali, ki kaal o kabal, ki kɛlɛk o loocu dook kurum kaal o ababat keŋtinɛ.” ");
INSERT INTO mur_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ɛtɛɛnya ni Jooi eet ci deer kizi riritɔn cin. Ɛɛnyca eet ci mac kibeen ŋaa. ");
INSERT INTO mur_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ma amayuk Jooi nɔɔgɔ anek nɛ, “Itirit iziti mɛɛlɛ. Ibitizit looc dook kɔkɔm gi ci animnyuŋ. Abalit kuluk o liilu, ki kibaali dook, kibeen kɛlɛk kɛbɛrɛ dook.” ");
INSERT INTO mur_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ma anek bodo Jooi nɔɔgɔ nɛ, “Kanyuŋ igeet kɛbɛrɛ ci abiirna kɛɛna o kibeen ci abiirna artɛ o dook kizi dayiin cugooc. ");
INSERT INTO mur_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Maje kɛlɛk dook, kibeen kibaali, kibeen kaal o ababat keŋtinɛ kanyi nɔɔgɔ artɛ ki kɛɛn ci colai o kizi dayiin cigeec.” Ma didi agooni gi nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ma acin Jooi kaal ci ɛɛnyca o dook abon ɔrɔɔt. Nica waanice iiten ween tɔrkɔnɔm nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nici zin gɔl baal ɛɛnycanɛ Jooi tammu taden ki looc been kaal dook e nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ma iitene ween torgɛrɛm idica Jooi liŋliŋɔn onin. Uyubuz ni. ");
INSERT INTO mur_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ma amayuk niini iiten nico kizi iiten ci yubzento ci aŋɛryai kɔtɔɔ doon. Agɔɔn niini nɔkɔ o, eeci iitene ceen torgɛrɛm noko ayubuz niini liŋliŋonte onin ɛɛnycanɛ kaal. ");
INSERT INTO mur_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Nici zin gɔl o ɛɛnycanɛ Jooi tammu taden ki looc nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Ma ɛɛnyca Jooi looc e, akɔm waanice rak kɛɛn ki artɛ ci aduŋna tɔdɔwai, eeci ŋaan kanyaak niini tiilɛz looc, ma buk ŋaan akɔm eet ci deer ci ka kɛɛv tɔdɔ. ");
INSERT INTO mur_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bar olla waanice anyak lɔɔci ziizi ci anyamat looc dook. ");
INSERT INTO mur_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ɛtɛɛnya ni Jooi eet ci deer tɔdɔwaca. Ma avoŋek nɔɔnɔ vɔŋiz o rogeto. Makacin didi urugun ɛɛti nici. ");
INSERT INTO mur_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ma agɔɔna Jooi mana libire ci jenu e ŋaati kazi Idan, ma arek eet ci ona ɛɛnyca o ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ma anyek Jooi kudunta ŋinaante kɛɛna ci amedneket ŋaati kacini, ma abiirna kɛbɛrɛ ci abon ŋaati kadayi. Maje mana kɔrgɛna anyak kɛɛt ci rogeto kibeen kɛɛt ci kagawi gi ci abon been gi ci gɛr. ");
INSERT INTO mur_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Anyak zin liil ci ariiya Idana ka kanyamat mana, ma ŋinaante aŋeryi liili nici lak wec. ");
INSERT INTO mur_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Liil codoi kazi zaar nɛ Picon. Nicini liil o ariik looce o kazi Avila nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ma ŋinaante anyak warki ci abon, ki karkarɛt, kibeen buk biyɛn o alina kazi onik. ");
INSERT INTO mur_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ma liil ceen ram o kazi zaar nɛ Giyon ariik niini looce o kazi Kuc. ");
INSERT INTO mur_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ma liil ceen iiyu o kazi zaar nɛ Tigariz ariik niini looce o kazi Asiriya libire ci jenu e. Maje liil ween wec o kazi zaar nɛ Yuparatiz. ");
INSERT INTO mur_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Arek ni Jooi eet ci deer o mana ci kazi Idan noko ka kozooti kɛbɛk. ");
INSERT INTO mur_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ma anek nɔɔnɔ nɛ, “Olla niina dak kɛbɛrɛ ci arooŋ keene ci ɛɛl mana noko dook labak. ");
INSERT INTO mur_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Bar zin má adei kɛbɛrɛ ci kɛɛt ci kagawi gi ci abon been gi ci gɛr o. Mã adei, akunakin koca daayiz.” ");
INSERT INTO mur_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Izi ni Jooi nɛ, “Alaŋ abon ŋaati aavɛ ɛɛti ci deer niini doon. Abon kɛɛnyca laŋotin ci ka kitirit nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ɛtɛɛnya ni Jooi tɔdɔwai kɛlɛk dook ki kibaali dook, ma alotak nɔɔgɔ eet nico ka kiiya kakatek niini nɔɔgɔ zaar. Akatewun ni ɛɛti nɔɔgɔ zaar o kaga o. ");
INSERT INTO mur_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ma didi akanek niini zaar kaal o kabal, kibeen kɛlɛk dook, ki kibaali dook. Maje eet ɛlɛ waanice ŋaan akɔm laŋotin ci ka kitirit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Anyewun ni Jooi nɔɔnɔ kɛtɛɛda ooŋnya. Mazi ŋaan ɔɔŋ nɔkɔ, aara onyit cin codoi, ma arigzek ŋinito idiŋ. ");
INSERT INTO mur_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ɛtɛɛnya ni Jooi onyite nico ŋaa, ma anyaak eet. ");
INSERT INTO mur_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Mazi acin ɛɛti nɔɔnɔ, izi nɛ, “Inoko kanyawa eet ci deer ci katobona ki aneet. Amɛ ciginɛ o avu amene cigan o, ma idina ciginɛ o avu idine cigan o. Abon zin kakanei nɔɔnɔ zaar ci kazi ŋaa, eeci agɔɔnnyai niini eete ci mac.” ");
INSERT INTO mur_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Nici zin gi o gɔɔn ooŋni ɛɛti baatin ki yaatin, ma aromɛn kibeen ŋaa onin o nɛɛn, ka kiziti niigi ɛlɛ codoi. ");
INSERT INTO mur_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Waanice zin ɛɛti kibeen ŋaa cin o aavtiz ŋaḏinyiny, ma alaŋ aŋɔlɔ. ");
INSERT INTO mur_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mazi baale ɛɛnyca Jooi kɛlɛk dook e, agɛny kowat kelegene dook, ma een labjoi. Iiyak ni niini ŋaa mana, ma ajin nɔɔnɔ anek nɛ, “Ma dim didi eeyuŋ Jooi igeet kɛɛn kɛbɛrɛ ci mano o ŋaati adaku?” ");
INSERT INTO mur_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Akɔm! Kadaka kɛɛn kɛbɛrɛ dook labak. ");
INSERT INTO mur_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Olla bar kɛbɛrɛ ci kɛɛt ci abil mana kɔrgɛna o doon azi Jooi nɛ, Má adaku, ma buk azi nɛ, Má uumnyu. Eeci mã kadaka, karabɔŋ kuumnya, akunaket koca daayizi.” ");
INSERT INTO mur_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ma abɛdɛkɛ kowat ŋaa anek nɛ, “Akɔm! Alaŋ een nɛɛn. Alaŋ adaaknu been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Olla aduwa Jooi gi nico o, eeci aga niini mã adaku, akolinuŋ koca kɛbɛrɛ otobtɔ ki Jook, ma agayu gi ci abon kibeen gi ci gɛr.” ");
INSERT INTO mur_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mazi acin ŋaa kɛɛt nico alina ɔrɔɔt nɔkɔ, ma buk aganɔ kɛbɛrɛ ciginɛ o ŋaati kadayi, ma acin niini buk anyek koca kɛbɛrɛ ci kɛɛt nico o nɔɔgɔ kegeny, odoca kɛbɛrɛ oogi, ma adak. Ma anyaak koogi eet onin, ma adak buk niini. ");
INSERT INTO mur_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Taman nɔkɔ ɔkɔltɛ nɔɔgɔ kɛbɛrɛ ugeec, ma acin eleeti niigi aavtiyɔ ŋaḏinyiny. Utuluya ni bɔlɔk ci moneeco ka kubuŋti eleeti. ");
INSERT INTO mur_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ma yomana mazi azii niigi Jook ŋaati awɔyi mana kɛŋa, oroode kɛɛni eecitɔ. ");
INSERT INTO mur_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Otowo ni Jooi eet ci mac o, ma anek nɛ, “Aavɛ ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Kiziiknin uyen awɔ mana e. Kotoŋoliwin ni, ma karoodei ka calaŋ acinan, eeci kaavɛ ŋaḏinyiny.” ");
INSERT INTO mur_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ijin ni Jooi nɔɔnɔ enek nɛ, “Ŋɛnɛɛn ci anekin nɛ, Aavɛ ŋaḏinyiny o? Adawu tɛ kɛbɛrɛ ci kɛɛt baal karicanekin calaŋ adei e?” ");
INSERT INTO mur_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ma abɛdɛkɛ ɛɛti nɔɔnɔ anek nɛ, “Ŋaa baal anyaakan ka koromtewa e nɛɛn ci anyan kɛbɛrɛ ci keetu o, ma kadei.” ");
INSERT INTO mur_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ma ajin Jooi ŋaa anek nɛ, “Agɔɔn nɔkɔ naa?” Ma abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Kowat nɛɛn ci alabekan kadak o.” ");
INSERT INTO mur_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ɔtɔr ni Jooi kowat enek nɛ, “Giye o agɔɔnɛ gi nico katoryin ineet doon kelegene dook. Akatai zin inoko iitene nico ɛlɛ awɔ niina ŋaati ababatɛ kɛŋa, ma adei tɔdɔ iinya ci ŋaan arognɛ o dook. ");
INSERT INTO mur_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma kanyin ineeta amartɔ kibeen ŋaa nɔkɔ, ma buk amarnɔ dɔlya cugooc. Arukuŋ gɔɔn tiŋeere niigi igeet ooti, ma aŋedetu niiga nɔɔgɔ zɔɔ.” ");
INSERT INTO mur_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Enek ni Jooi ŋaa nɛ, “Kazaacekin ineet piryakzɛt nyayiinta, ma anyei balcɔn ci appe ɔrɔɔt ŋaati ookcanɛ. Arooŋ gɔɔn tiŋeere niina eet ɔrɔɔt, ma abalin ɛɛti ineet.” ");
INSERT INTO mur_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ma anek Jooi eet nɛ, “Giye o iziiyɛ niina zɔɔz ci ŋaa cun o, ma adayɛ kɛbɛrɛ ci kɛɛt baal kajurakin e, kator tɔdɔ. Akatai zin iitene nico ɛlɛ adɔi ŋaatun ŋaati ajowanɛ dayiin tɔdɔwai gaga nɔkɔ kiyo baale e. Apirna gɔɔn tiŋeere niina liŋliŋɔnta ɔrɔɔt ka jowa dayiin iinya ci ŋaan arognɛ o dook. ");
INSERT INTO mur_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Aduŋna tiŋeere kɛɛna ceen bila been ciirɛn tɔdɔwai. Adei gɔɔn tiŋeere niina kɛbɛrɛ ci kɛɛn ci too. ");
INSERT INTO mur_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Aliŋliŋ gɔɔn tiŋeere niina ɔrɔɔt zɛɛ ma amului ŋaati ɛɛvɛ tɔdɔ ka kudunai dayiin ci adei. Aliŋliŋ tiŋeere niina nɔkɔ zɛɛ ma amiironei tɔdɔ baal kɛɛnycanin e. Ma giye o ɛɛnɛ tɔdɔwa tiŋeere amiironei tɔdɔ.” ");
INSERT INTO mur_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Akanek Adam ŋaa cin o zaar ci kazi Eev, eeci een niini yaati ɔl dook nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ma agɔɔnak Manyi Jooi Adam ki ŋaa cin o rumanɛ ceen ruce ka kubuŋti eleeti. ");
INSERT INTO mur_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Izi ni Manyi Jooi nɛ, “Inoko ɛɛti ci deer o ibilun kiyo naaga o. Anyawun gɛnyiz ci agawi gi ci abon ki gi ci gɛr. Alaŋ zin abon bodo ŋaati kanyekɛ nɔɔnɔ kadak kɛbɛrɛ ci kɛɛt o rogeto, ka korok rogɛt o abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ɔtɔɔk ni Manyi Jooi nɔɔnɔ mane o looc o kazi Idan, ma anyek nɔɔnɔ kook kɛɛv tɔdɔ baal ɛɛnycanɛ niini nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Arek ni Jooi mana ci kazi Idan noko libire ci akɔ ki jen e toonnyai onin kazi Cɛrubim o anyak kabaz o wun amacuc looc, ma alanyit kalakalak ka kɛbɛk niini kɛɛt o rogɛt o abil kodot. ");
INSERT INTO mur_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Oromtɛ ni Adam ki ŋaa cin kazi Eev noko, makacin anyawɔ, ma ookca logo onin kazi Ken. Ma azi nɛ, “Inoko kanyawa dole can tiritente o Manyi Jook.” ");
INSERT INTO mur_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Bodo vurta otoyai niini logote o kazi Abel. Mazi avɔ adikir lɔgɔz, izi Abel eet ci abal ɛɛza, aje Ken izi niini eet ci keevinto. ");
INSERT INTO mur_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ma iinyaye ogɛn anyaak Ken Jook kɛbɛrɛ ci kaal ogin aḏowa mana ka kiiya kidiŋdiŋani nɔɔnɔ taabinta. ");
INSERT INTO mur_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Maje Abel anyaa niini morɛ ci nyɔɔn ceen abuu ɛɛzaye ogin, ma aku ataabi Jook. Atalɔ ni Jooi ŋaati Abel taabinte cin o. ");
INSERT INTO mur_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ma abor niini Ken ki taabinɛt cin o. Mazi acin Ken gi nico, onyooran ŋum, ma abor nɔŋ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Enek ni Jooi nɔɔnɔ nɛ, “Abor nɔŋ naa? Naa anyooran ŋum o? ");
INSERT INTO mur_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Waan tɛ tugu gi ci abona, kagama waan kaal cugun taabinto o labak. Mazi alaŋ agoon nɔkɔ, aaveekin oŋɛci ineet ceez tatoga, ma arɔɔŋ niini ka komogin ineet. Bar zin abon waan adoi ka mɔgɔ niina nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mazi azii Ken gi nico enek gɔtɔni nɛ, “Abel, kɔtɔɔz di kɔɔtɔ tuuwa.” Ɔtɔɔzɔ ni. Mazi avɔ arum niigi balal, uruk niini gɔtɔni kadaak. ");
INSERT INTO mur_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Iiya ni ijin Jooi nɔɔnɔ enek nɛ, “Gotonu ŋaaḏaŋ?” Ma abɛdɛkɛ niini Jook anek nɛ, “Alaŋ kaga. Matɛ ajinan o keen da naana bɛkcoi ci gɔtɔnɔna?” ");
INSERT INTO mur_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ma anek Jooi nɔɔnɔ nɛ, “Gitaz ci agoon noko? Kaga nɔkɔ uruwu gotonu kadaak. Inoko zin biyeta ci gotonon ona akana niina o aluwekan aneet arɔɔŋ cacinɛt. ");
INSERT INTO mur_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Inoko niina anyei toriin, ma atooke tɔdɔwaye ci ona aḏuutonek biyeta ci gotonon noko, eeci umunyu gotonu niina maany. ");
INSERT INTO mur_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Buk mã arooŋ ɛɛva mana, alaŋ abiir been nɛɛn, ka olla niina izi gi ci ayaŋyaŋ awɔ kɔkɔm yubzɛn loota.” ");
INSERT INTO mur_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ma anek Ken Jook nɛ, “Inoko niina apayeyan aneet payiin ci adɔi kak calaŋ kanim kanyak. ");
INSERT INTO mur_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Cin di inoko ɔtɔɔyan ŋaati gɔɔn kabaayɛ o. Alaŋaan bodo naana kaganona ŋaati kabilnɛ ineet ŋuma, ma olla kayaŋyaŋ kawɔ kɔkɔm ŋinti kayubzɛ. Zin tiŋeere mã ajowanan ɛɛti oman aneet, arukan kadaak.” ");
INSERT INTO mur_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bar abɛdɛkɛ Jooi nɔɔnɔ anek nɛ, “Akɔm. Mã arukin ɛɛti oman ineet daak, kacaca koca naana lak torgɛrɛm”. Arekɛ ni Jooi Ken bayen ka kɔkɔm eet ci aruk nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ɔtɔɔ ni Ken ŋaati aavɛ Jooi o, ma akɔ abaak looce o kazi Nad mana o Idan libire ci akɔ ki jen e. ");
INSERT INTO mur_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Oromtɛ ni Ken kibeen ŋaa onin, ma arita logo o kazi Inok. Ma ɛɛnyca Ken kutur ci adikir, ma akanek zaar ci ŋɛɛrin o. ");
INSERT INTO mur_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ma arita Inok logo ci kazi Irad. Iiya ni Irad izi baati Mejal. Mejal izi baati Mezujal. Mezujal izi baati Lamɛk. ");
INSERT INTO mur_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ɔrɔca ni Lamɛk ŋaai ram. Kazi ŋaa codoi zaar nɛ Ida, bodo codoi kazi nɛ Zila. ");
INSERT INTO mur_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Itira ni Ida Jabal o iiya izi jijiti ɔl o aluuk tiini. ");
INSERT INTO mur_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ma kazi gɔtɔni Jabal zaar nɛ Jubal o iiya izi niini jijiti ɔl o aruk kidorɛt, ma abo bɛɛlɛn. ");
INSERT INTO mur_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila itira Tubalkin o adɛdɛ ziik. Ma anyak niini ŋɔɔni ci kazi Naama. ");
INSERT INTO mur_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ma iitene oman enek Lamɛk ŋaai cigin o beniinta nɛ, “Igeeta Ida ki Zila, iziiyit gi ci kaduwakuŋ ce ŋaai ogan. Mã anyak eet ci arookan aneet, karui koca naana nɔɔnɔ kadaak taman nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Mã acacai ruwɛn o Ken lak torgɛrɛm, bar koca acaca ruwɛn cane o lak eet iiyu kamɔtɔ ki tiin torgɛrɛm (77).” ");
INSERT INTO mur_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Bodo irkitowe ogɛn anyayit Adam ki Eev logo oma, ma azi Eev nɛ, “Inoko anyan Jooi logo oma ci ka kirigiz zɔɔ o Abel baal aruk Ken e.” Akatek ni niini nɔɔnɔ zaar ci kazi Sez. ");
INSERT INTO mur_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Mazi akɔ adikir Sez, itira niini ŋɛɛrin, ma akanek nɔɔnɔ zaar ci kazi nɛ Inos. Akata ni ɔl waanice ween ci awoyi zaar o Joowo. ");
INSERT INTO mur_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Keebinɛt ci dɔl o Adam nɛɛn ce. Baale ma ɛɛnyca Jooi eet ci deer e, ɛɛnyca kotobtɔ ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ɛɛnyca niini eet ci mac ki ŋaa. Ma amayuk nɔɔgɔ, ma awo nɔɔgɔ kizi ɔl ci deer. ");
INSERT INTO mur_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Mazi akɔ een Adam irkitowa eet tɔrkɔnɔm kamɔtɔ (130), itira niini ŋɛɛrin ci atobɔ ki nɔɔnɔ ɛlɛ, ma akanek zaar ci kazi Sez. ");
INSERT INTO mur_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Vurte ci Sez abaak Adam irkitok eet tur lak turge (800). Itira ni bodo lɔgɔz oogi been dɔl ci ŋaai. ");
INSERT INTO mur_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ma arogi Adam irkitok eet tur lak tɔrkɔc ki eetoma kamɔtɔ (930). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Mazi akɔ abaak Sez irkitok eet tur ki tiin tur (105), itiryai ŋɛɛrin o kazi Inos. ");
INSERT INTO mur_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Vurte o tiryan o Inos, abaak Sez irkitok eet tur lak turge ki tiin torgɛrɛm (807). Itira ni bodo niini lɔgɔz oogi ki dɔl ci ŋaai. ");
INSERT INTO mur_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ma arogi Sez irkitok eet tur lak tɔrkɔc kamɔtɔ ki tiin ram (912). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Mazi akɔ een irkitowa o Inos eet tur lak tɔrkɔc (90), itiryai ŋɛɛrin o kazi Kenan. ");
INSERT INTO mur_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ma vurte o tiryan o Kenan, abaak Inos irkitok eet tur lak turge kamɔtɔ ki tiin tur (815). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ma arogi Inos irkitok eet tur lak tɔrkɔc ki tiin tur (905). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Mazi akɔ abaak Kenan irkitok eet iiyu kamɔtɔ (70), itiryai ŋɛɛrin o kazi Malalil. ");
INSERT INTO mur_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ma vurte o tiryan o Malalil, abaak Kenan irkitok eet tur lak turge ki eet ram (840), ma ariti bodo lɔgɔz been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ma arogi Kenan irkitok eet tur lak tɔrkɔc kamɔtɔ (910). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mazi akɔ abaak Malalil irkitok eet iiyu kamɔtɔ ki tiin tur (65), itiryai ŋɛɛrin o kazi Jaret. ");
INSERT INTO mur_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Vurte o tiryan o Jaret, abaak Malalil irkitok eet tur lak turge ki eetoma kamɔtɔ (830). Itira ni bodo lɔgɔz been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ma arogi Malalil irkitok eet tur lak turge ki eet wec kamɔtɔ ki tiin tur (895). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Mazi akɔ een irkitowa o Jaret eet turge ki tiin ram (162), itiryai ŋɛɛrin o kazi Inok. ");
INSERT INTO mur_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ma vurte o tiryan o Inok abaak Jaret irkitok eet tur lak turge (800). Itira ni bodo lɔgɔz been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ma arogi Jaret irkitok eet tur lak tɔrkɔc ki eet iiyu ki tiin ram (962). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Mazi akɔ een Inok irkitowa eet iiyu ki tiin tur (65), itiryai ŋɛɛrin o kazi Mezuzala. ");
INSERT INTO mur_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Vurte o tiryan o Mezuzala orkorit Inok ki Jook irkitok eet tur lak iiyu (300). Itira ni bodo lɔgɔz been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ma arogi Inok irkitok eet tur lak iiyu ki eet iiyu ki tiin tur (365). ");
INSERT INTO mur_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Tup nɔkɔ ɔrkɔr Inok ki Jook, ma iitene oman izi niini ḏim. Ooyi Jooi nɔɔnɔ tamma rogɛtɛt. ");
INSERT INTO mur_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mazi akɔ een Mezuzala irkitowa eet tɔrkɔc ki tiin torgɛrɛm (187), itiryai ŋɛɛrin o kazi Lamɛk. ");
INSERT INTO mur_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ma vurte o tiryan o Lamɛk abaak Mezuzala irkitok eet tur lak torgɛrɛm ki eet wec ki tiin ram (782). Itira ni bodo niini lɔgɔ been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ma arogi Mezuzala irkitok eet tur lak tɔrkɔc ki eet iiyu ki tiin tɔrkɔc (969). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Mazi akɔ een irkitowa o Lamɛk eet tɔrkɔc ki tiin ram (182), itira logoz. ");
INSERT INTO mur_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ma akanek nɔɔnɔ zaar ci kazi Nowa, ma azi nɛ, “Atiritet tiŋeere logoti nici liŋliŋɔnta kibeen piryakzete o akunaket ageet giye o ɔtɔri Jooi looc.” ");
INSERT INTO mur_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ma vurte o tiryan o Nowa abaak Lamɛk irkitok eet tur lak tur ki eet wec kamɔtɔ ki tiin tur (595). Itira ni bodo niini lɔgɔz been dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ma arogi Lamɛk irkitok eet tur lak torgɛrɛm ki eet iiyu kamɔtɔ ki tiin torgɛrɛm (777). Adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Mazi akɔ een irkitowa o Nowa eet tur lak tur (500), itiryai lɔgɔz ciginɛ een iiyu kazi zaar cigeec nɛ Cɛm, ki Am, kibeen Javaz. ");
INSERT INTO mur_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Baale akɔ mazi ɔɔt azaace ɔl loota kizi mɛɛlɛ, ma itiryai dɔlya ci ŋaaiye ŋaatineeŋ e, icinit lɔgɔz ci joowanɛ oogi kabarzɛ ci ɔl ci deer o alina ɔrɔɔt, ma arɔc niigi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Izi ni Jooi nɛ, “Alaŋ bodo vɔŋizi onane rogeto aavi eete ci deer kodot loota ŋina, eeci niini een gi ci adaai. Alaŋ niini arogi katayaŋ irkitok ceen eet tɔrkɔnɔm (120).” ");
INSERT INTO mur_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mazi waanice avɔ aromɛ lɔgɔz ci joowanɛ oogi o kibeen dɔl ci ɔl ci deer neke, itirta niigi ŋaatineeŋ baraknya ci appintik ɔrɔɔt loota ŋina. Baraknya nicigi iziti niigi olenya ci mootik ci agayi ɔrɔɔt iinyaye niceke. ");
INSERT INTO mur_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Mazi acin Jooi izi gerzitin appe ɔrɔɔt eete ci deer loota, ma akɔ baabani o zinzeeti ugeec ki gerzitin iinya dook nɔkɔ, abadun niini mony giye ci ɛɛnycanɛ eet ci deer loota o, ma awucnyek nɔɔnɔ zɔɔz nici ziniza ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Izi ni Jooi nɛ, “Abon kɛɛya loota ŋina eet ci deer baal kɛɛnyca noko, ki kɛlɛk, ki kibaali, kibeen kaal o awɔ keŋtinɛ. Inoko naana kabadi mony giye o kɛtɛɛnyayɛ nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bar zin waanice Nowa doon ci atalnɛ Manyi Jooi ŋaatin. ");
INSERT INTO mur_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ceeni zin zɔɔz o akati Nowa. Niini eet ci abona ɔrɔɔt ɛlɛ. Abona waanice niini doon ole niceke dook, ma ɔrkɔr niini ki Jook tup nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Anyak niini waanice ŋɛɛrigin ceen iiyu ci kazi Cɛm, ki Am, kibeen Javaz. ");
INSERT INTO mur_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Acin zin Jooi waanice ɔl ci deer o loota ŋina agɔɔn kaal ci gɛr ɔrɔɔt, ma anyawun lɔɔci yowonok ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Acin niini looc izi gɛrzɛ ɔrɔɔt ɛlɛ, eeci ɔl o loocu dook abaayit baayiz ci gɛr. ");
INSERT INTO mur_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Enek ni niini Nowa nɛ, “Inoko karooŋ kuulal ɔl ci deer o dook kibeen looc buk kizeectɔ, eeci adala gerzitin ci eet ci deer looc dook ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Inoko zin niina tɛɛnya kavool ci appe aleenonu ki ineet keene ci adɔi kak aganɔ ki tɛɛnyinɛt. Tuguwa keŋti ci meelik kavoola eecitɔ. Dilɔ eecitɔ ki bawuca buk zooyɛni. ");
INSERT INTO mur_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Yabiza corcoritin ci kavoolo o kizi mitirɛt eet tɔrkɔnɔm kamɔtɔ ki tiin iiyu (133). Yabiza kɛŋ eecitɔ kɔlɔɔlanɛ kizi mitirɛt eetoma ki tiin ram (22). Yabiza wunzɛt ci akɔ ki taden o kizi mitirɛt amɔnki iiyu (13). ");
INSERT INTO mur_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tɛɛny rukcok ci abuŋ kavool taden. Tɛɛnya buk kavool keŋti iiyu ci ataadizɔ. Arek kavool karogi kabanyca. ");
INSERT INTO mur_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kakɔ naana kitoona tawan ka kuruk kaal dook o arogi loota kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ŋaan zin katerkedekin ineet terkediin ci ka kɛɛlayin. Bitɔ kavoola niina ki ŋaa unun kibeen dɔl ugun been ŋaai ci lɔgɔz ugun. ");
INSERT INTO mur_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Biti buk kavoola eecitɔ gi ci mac ki gi ci ŋai kaale ci arogi noko dook ka oromtɛ ki ineet ka zooti nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Biti buk dayiin keŋti dook ka adayit niina kibeen kaal ci arogi o dook.” ");
INSERT INTO mur_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Utugu ni Nowa kaal dook eo aduwakɛ Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mazi akɔ adicai kavooli tɛɛnyinta, enek Jooi Nowa nɛ, “Ɔɔtɔ niina kibeen ɔl o kɔrɔk unun dook kavoola, eeci kacinin ineet doon een eet ci abona ole ci ɔɔ nico noko dook. ");
INSERT INTO mur_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kelegene o abal ɔl dook biti ŋaatineeŋ ci mac torgɛrɛm kibeen ci ŋai torgɛrɛm. Bodo kelegene calaŋ abal ɔl o biti ŋaatineeŋ ci mac codoi kibeen ci ŋai codoi. ");
INSERT INTO mur_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kibaalinɛ buk biti ci mac torgɛrɛm kibeen ci ŋai torgɛrɛm. Abon agoon nɔkɔ ka kitirit kaala nici kazaantozek looc dook. ");
INSERT INTO mur_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mã adicai iinya ceen torgɛrɛm, kitoona tammu kitiil waazin ki baalin iinya eet ram (40) ka kɛɛyai kaal o arogi dook loota.” ");
INSERT INTO mur_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Utugu ni Nowa kaal dook eo aduwakɛ Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Zin waanice ma akunak tawani looc e een Nowa irkitowa oginɛ tiryanto eet tur lak tɔrkɔnɔm (600). ");
INSERT INTO mur_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ma akɔ kavoola niini ki ŋɛɛrigin ki ŋaa onin kibeen ŋaai o lɔgɔz ogin ka kajaarit niigi tawan o akuuwa looc dook. ");
INSERT INTO mur_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ma avɔ buk kavoola kelegiti ci mac ki ci ŋai kelegene dook, ki kibaalic ci mac ki ci ŋai kibaaline dook ebaal aduwakɛ Jooi Nowa e. ");
INSERT INTO mur_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Mazi adicai iinya baal een torgɛrɛm e, iiya tawani. ");
INSERT INTO mur_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ma irkite o ɛɛnɛ Nowa irkitowa oginɛ tiryanto eet tur lak tɔrkɔnɔm (600), nyelowene ween ram, iinyaye ween amɔnki torgɛrɛm (17), ɔbɔryai maama ci meelik ɔrɔɔt ɛlɛ loota, ma atiilna tammu lɔmɛn ci appintik. ");
INSERT INTO mur_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ma atiil tammu waazin ki baalin iinya eet ram (40). ");
INSERT INTO mur_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Maje iitene nice ɛlɛ aavtiz Nowa ki ŋɛɛrigin Cɛm, ki Am, kibeen Javaz, ki ŋaa onin, kibeen ŋaai ci ŋɛɛrigin ceen iiyu noko kavoola. ");
INSERT INTO mur_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Ma buk anyak kavoola kɛlɛk ci mac ki ci ŋai kelegene dook. ");
INSERT INTO mur_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Agooni kaala nici dook ebaal aduwakɛ Jooi Nowa e. Onyoogek ni Jooi nɔɔgɔ kavool eecitɔ. ");
INSERT INTO mur_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ma atiil tammu iinya ceen eet ram (40) noko dook, ma azaaci maama, ma adɔŋ kavool kook ki taden. ");
INSERT INTO mur_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ma azaaci maama nɔkɔ zɛɛ ma adala looc dook. Maje kavooli ariit maam gilana. ");
INSERT INTO mur_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ma amɛna maama azaaci ɔrɔɔt nɔkɔ zɛɛ makacin ukuuwa biyɛn o wuntik dook loota. ");
INSERT INTO mur_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ma azaaci nɔkɔ zɛɛ ma ayaŋ biyɛn, ma een yabziin ci ayabzin maama ci ayaŋ biyɛn o doon mitirɛt torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","Ma adaai kaala o arogi loota dook lai, kibaali, ki kɛlɛk, ki ɔl o deer dook loota. ");
INSERT INTO mur_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ma ɛɛya Jooi kaal o ɛɛl loota dook, ɔl ci deer, ki kɛlɛk, kibeen kibaali. Ma arogi Nowa ki o aromɛ ki nɔɔnɔ kavoola doon. ");
INSERT INTO mur_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ma abitiz maama looc iinya eet tɔrkɔnɔm kamɔtɔ (150). ");
INSERT INTO mur_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mazi akɔ adala maama looc e, ŋaan Jook kereyek Nowa ki kɛlɛk o aromɛ ki nɔɔnɔ kavoola dook. Anyaa ni Jooi ŋɔɔt ka kivaan maam ka kimiirte maama ki looc. ");
INSERT INTO mur_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ma ativani diizwana tiilɛza, ma ativani buk maama baal abɔryai loota e. ");
INSERT INTO mur_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ma amiiri maama ki looc zɛɛ mazi een iinya eet torgɛrɛm kamɔtɔ (150), owodjai. ");
INSERT INTO mur_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ma iinyaye ween amɔnki torgɛrɛm (17) nyelowe ween torgɛrɛm, agamɛ kavooli biyene o kazi Ararat ootinɛ, ibil ni ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ma amiiri maama kidicilim nɔkɔ zɛɛ been nyelok ween amɔtɔ. Ma iitene o akanan nyɛlɔyi ween amɔtɔ eyelizyai biyɛn ooti kicinit. ");
INSERT INTO mur_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Mazi akɔ adicai iinya ceen eet ram (40) bodo, ɔkɔl Nowa nyapildiŋ o kavoolo. ");
INSERT INTO mur_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Ma itoon walaak kook kicin looc mã anyak ŋinti adɔi. Ma akul walaak, ma akɔ amalil tammu kɛŋa ka kɛrɛwɔ zɛɛ ma awodjai maama loota imin calaŋ abada. ");
INSERT INTO mur_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ma areyi Nowa zɛɛ makacin itoon yɛɛlac ka kook kicin maam mã owodjai, eeci alaŋaan walaak abada. ");
INSERT INTO mur_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bar acin yɛɛlac maam ŋaan akuuwa looc dook, makacin abadaak bodo kavool, eeci akɔm ŋinti ka kibili. Itoona ni Nowa aziit kavoola, ma agama yɛɛlac, ma anyaak kavool eecitɔ. ");
INSERT INTO mur_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ma aavi iinya torgɛrɛm. Itoon ni bodo yɛɛlac. ");
INSERT INTO mur_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Mazi abada yɛɛlac yomana, anyaa boloyitot ci kiŋiroco colai otoga. Agawun ni Nowa izi maama kidicɛ loota. ");
INSERT INTO mur_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ma amɔn bodo iinya torgɛrɛm, ma itoon yɛɛlac Enico alaŋaan yɛɛlac abada bodo. ");
INSERT INTO mur_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Mazi akɔ een Nowa irkitowa eet tur lak tɔrkɔnɔm ki irkit codoi (601), iitene o oowu nyelowe wodoi, owodjai maama. Ɔkɔl ni Nowa kavool, ma acin maam awodjai. ");
INSERT INTO mur_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ma iinyaye ween eetom ki tiin torgɛrɛm (27) nyelowe ween ram, ɛvɛɛc lɔɔci kɔdɔk kak. ");
INSERT INTO mur_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Enek ni Jooi Nowa nɛ, “Udunta kavoola labak ki ŋaa unun ki lɔgɔz kibeen ŋaai ugeec. ");
INSERT INTO mur_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dunai buk kɛlɛk ki kibaali dook bitaala ka kivita kitirit loota zɛɛ ma adala looc dook.” ");
INSERT INTO mur_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Uduna ni Nowa ki ŋaa onin kibeen lɔgɔz been ŋaa ugeec. ");
INSERT INTO mur_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ma aduŋna kɛlɛgɛ ki kibaali dook kavoola. Ono ni gɔɔn kelegiti ceeni gɔn onin atobɔ. ");
INSERT INTO mur_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ɛtɛɛnya ni Nowa ŋinti ka kidiŋdiŋani Jook. Ma anyaa kɛlɛk ci abon diŋdiŋanito ki kibaali ci abon. Ma akɔ avaat nɔɔgɔ ŋaati ona ɛɛnyca niini ka kidiŋdiŋani Jook o. ");
INSERT INTO mur_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mazi acɔɔk Jooi cɔɔlil nico, atalɔ niini, ma anek ɛlɛ maany nɛ, “Alaŋ bodo kator looc been nɛɛn giye ci akati gerzitin ci eet ci deer. Mayo nuun ɛɛti ci deer anyak baabani ci gɛr o, alaŋ bodo kadica kaalyan ci arogi loota noko dook been nɛɛn ebaal kagɔɔnɛ rak e. ");
INSERT INTO mur_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Akatai zin inoko ka kanyak ḏowɛn ki teedinɛt, ma anyak tagiz ki lɔɔlɔ, ma anyak waazin ki baalin.” ");
INSERT INTO mur_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Amayuk ni Jooi Nowa kibeen dɔl ogin anek nɛ, “Itirit. Azaace iziti mɛɛlɛ ɔrɔɔt ka ibitizit looc. ");
INSERT INTO mur_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Aŋolunuŋ gɔɔn tiŋeere igeet kɛlɛgɛ, ki kibaali, kibeen kuluk. Ma anyaku niiga dɔyiz ŋaatineeŋ looc dook. ");
INSERT INTO mur_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Inoko kanyuŋ naana igeet nɔɔgɔ dook ka kizi niigi dayiin cugooc kiyo rak baale kanyuŋ igeet kaal o aḏoyai colai dook e. ");
INSERT INTO mur_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bar zin gɔɔn abon rak aaranu biye idiŋa maŋaan adayit. Abon agoon nɔkɔ o, eeci rogɛti abil biyɛtɛ. ");
INSERT INTO mur_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mã aruk ɛɛti gɔn kadaak, avavonek buk niini gɔn nico. Mã aruk kelegiti eet ci deer kadaak, avavonek buk niini. ");
INSERT INTO mur_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ɛɛnycai ɛɛti ci deer kotobtɔ ki Jook. Mazi amony ɛɛti ci deer gɔn oma, aruwe buk niini kadaak giye ci agɔɔn niini o. ");
INSERT INTO mur_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Itirit zin iziti mɛɛlɛ. Azaace zɛɛ ma adalanu looc dook.” ");
INSERT INTO mur_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","9","Ma anek Jooi bodo Nowa kibeen dɔl ogin nɛ, “Inoko naana kaduwakuŋ terkediin onan igeet kibeen dɔl ci dɔl ci anowanuŋ igeet vurta e, ");
INSERT INTO mur_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kibeen buk kɛlɛk ki kibaali dook o aromenu ki igeet kavoola. ");
INSERT INTO mur_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Katerkedekuŋ igeet gi calaŋ bodo kaala o arogi dook adaakni tawana been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ceeni zin bayen ci terkediin onan abil kodot o katerkedekuŋ naana igeet kibeen kaal o arogi dook. ");
INSERT INTO mur_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Inoko kareya bɔrɔi onan kibil diizwani ka kizi bayen ci ayelza terkediin onan ki kaal o loocu dook. ");
INSERT INTO mur_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Mã kanyaa diizwa, ma yelzai bɔrɔyɛ diizwani, kaada naana terkediin onan akati aneet ki igeet been kaal o arogi dook ka calaŋ bodo aku tawani kiiya kidica kaal o arogi loota dook. ");
INSERT INTO mur_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ma ayelzai bɔrɔyɛ diizwani, ŋaan kacin naana nɔɔnɔ, ma kaada terkediin onan abil kodot kaale o arogi loota dook.” ");
INSERT INTO mur_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ma anek Jooi Nowa nɛ, “Nicini zin bayen o terkediin onan kibeen kaal o arogi loota dook nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Lɔgɔz zin o Nowa baal aduŋna kavoola e nɛɛn Cɛm, ki Am, been Javaz. Ma Am niini baati Kanan. ");
INSERT INTO mur_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Lɔgɔz zin ci Nowa een iiyu noko nɛɛn o arita ɔl o loocu dook. ");
INSERT INTO mur_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa waanice niini eet ci keviinto. Nɔɔnɔ nɛɛn o akana ḏowɛn o kɛɛn o anyak kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ma iitene oman owot niini nyaan ci acoryai keberene ci keenu noko zɛɛ makacin abaayɛ, ma ɔɔŋ ŋaḏinyiny kɔkɔm gi ci abuŋi ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mazi acin Am ween baati Kanan baatin ŋaati ɔɔŋɛ ŋaḏinyiny noko, uduna ceeza, ma akɔ aduwak gɔtɔnɔgi ween ram bitaala rarya. ");
INSERT INTO mur_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Odomta ni Cɛm kibeen Javaz rum, ma ataadek inyaati ugeec niigi dook ramantiya, ma awɔ eeci bawuco zɛɛ ma avɔ abuŋ baatineeŋ ci ɔɔŋ ŋaḏinyiny o calaŋ niigi acin nɔɔnɔ ŋaati ɔɔŋɛ ŋaḏinyiny o. ");
INSERT INTO mur_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Mazi akɔ iŋaaz Nowa baayiinta, agawun gi o agoonek ŋɛɛrin o kazi Am nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Izi ni niini nɛ, “Kator Kanan ween dole o Am ka kizi gabaren ci dɔl o yaatin.” ");
INSERT INTO mur_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ma azi bodo nɛ, “Abon bai Jooi amayuk Cɛm, ma abon anyek Kanan kizi gabaren ci Cɛm. ");
INSERT INTO mur_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ma abon azaac Jooi dɔl ci Javaz, ma abon abaak niigi kibeen dɔl o Cɛm. Maje Kanan abon buk een niini gabaren ci Javaz.” ");
INSERT INTO mur_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ma vurte o tawano abaak Nowa irkitok eet tur lak iiyu ki eet ram kamɔtɔ (350). ");
INSERT INTO mur_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ma arogi Nowa zɛɛ ma een irkitowa oginɛ tiryanto dook eet tur lak tɔrkɔc ki eet ram kamɔtɔ (950), adaak ni. ");
INSERT INTO mur_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ceegi zin dɔl ci lɔgɔz o Nowa kazi Cɛm ki Am kibeen Javaz. Anyayit niigi dɔl cigeec vurte o tawano. ");
INSERT INTO mur_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Dɔl ci Javaz nɛɛn Goma ki Magok ki Midai ki Javan ki Tubal ki Mecek been Tiraz. ");
INSERT INTO mur_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Dɔl ci Goma nɛɛn Akanaz ki Rivat been Togoma. ");
INSERT INTO mur_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Aje Javan dɔl cigin nɛɛn Elica ki Tarca ki Kitim been Roda. ");
INSERT INTO mur_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ma ɔl nicigi dook abaak waanice liilok utugetinɛ kibeen vitɛnanɛ o aliya maama. Ma azaani niigi kizi boryok ki modɛn ci aŋɔrɔwɔ loocowa kibeen zoozok. ");
INSERT INTO mur_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dɔl ci Am nɛɛn Kuc ki Masir ki Put kibeen Kanan. ");
INSERT INTO mur_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dɔl ci Kuc nɛɛn Ceba ki Avala ki Cabta ki Raama kibeen Zabtaca. Dɔl ci Raama nɛɛn Ceba been Dedan. ");
INSERT INTO mur_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Buk Kuc niini baati logo o kazi Nimad o iiya izi eet o adɔi ɔrɔɔt ɔrɔɔnta. ");
INSERT INTO mur_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ma buk amayuk Jooi nɔɔnɔ kizi eet ci ceeliinto agayi. Ma aruk ɔl olit ŋaati azɔɔzɔnɛ azi nɛ, “Amayukin Jooi ineet izi eet ci ceeliinto adikir agayɛ otobtɔ ki Nimad.” ");
INSERT INTO mur_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Vitɛn ci baale abal niini ɔɔwa nɛɛn kuturyowa o kazi Babilan ki Irec ki Akad been Kalnet. Kuturyowa nicigi dook ɛɛl looce o kazi Cinar. ");
INSERT INTO mur_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ma vurte nice ook niini looce o kazi Asiriya, ma akɔ abaak ŋinaante, ma ɛɛnyca kutur o kazi Ninava ki Rebot ki Calak ");
INSERT INTO mur_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","been Resan o aŋɛr Ninava ki Kala. ");
INSERT INTO mur_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Dɔl ci Masiro kazi zaar cigeec nɛ Ludim ki Anamin ki Labim ki Navutim ");
INSERT INTO mur_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ki Patrosa ki Kaslu been Karit ween baati modɛn o kazi Viliztiya. ");
INSERT INTO mur_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ma Kanan niini baati Sidon ki Ititaz ");
INSERT INTO mur_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ki Jebta ki Amorita ki Gagacatiz ");
INSERT INTO mur_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ki Aavata ki Arketa ki Cinata ");
INSERT INTO mur_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ki Arvadata ki Zemarata been Amata. ");
INSERT INTO mur_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ma vurta azaantɛ dɔl o dɔl o Kanan kɔɔt kurumit niigi baayiza loocok o kazi Kanan, ki Sidona, ki Gɛrar, ma avɔ kɔɔt kojoŋozit Gaza, ma avɔ ki jen zɛɛ ma avɔ ajɔŋɔz Sodom ki Gomora ki Adama been Zeboyim o ajɔŋɔz ŋino kazi Laaca. ");
INSERT INTO mur_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nicigi dook dɔl ci dɔl o Am. Dɔlya ci Am noko iziti buk niigi modɛn ci aŋɔrɔwɔ zoozowa, ma aŋɔrɔwɔ loocowa buk. ");
INSERT INTO mur_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Cɛm niini abuu nɛɛn. Aje Javaz tutur. Ma Cɛm niini baati ɔl o kazi Ibiro. ");
INSERT INTO mur_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Dɔl o Cɛm nɛɛn Ilam ki Acir ki Arpat ki Ludi been Arma. ");
INSERT INTO mur_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arma dɔl cigin nɛɛn Uziya ki Ulak ki Getar been Maacak. ");
INSERT INTO mur_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpat niini baati Cela. Maje Cela iiya izi niini baati Eber. ");
INSERT INTO mur_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber anyak lɔgɔz ram. Codoi kazi nɛ Pɛlɛk, eeci waanice aŋɛrɔ ɔl dook iitene nice. Gɔtɔni oma kazi zaar nɛ Joktan. ");
INSERT INTO mur_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Zin Joktan iiya izi niini baati Almoda ki Celap ki Azarmiya ki Jɛra ");
INSERT INTO mur_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ki Adoram ki Uzal ki Dikila ");
INSERT INTO mur_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ki Obal ki Abimal ki Ceba ");
INSERT INTO mur_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ki Opir ki Aavila been Jobab. ");
INSERT INTO mur_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Abaak niigi biyɛn libire ci jenu e akana ŋaao kazi Mesa zɛɛ been Cepar. ");
INSERT INTO mur_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nicigi dook dɔl ci dɔl o Cɛm. Dɔlya ci Cɛm noko iiya iziti niigi modɛn ci aŋɔrɔwɔ zoozowa, ma aŋɔrɔwɔ loocowa buk. ");
INSERT INTO mur_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dɔl nicigi dook dɔl o Nowa. Vurte o tawano itiryai modɛna dook dolene ogin. ");
INSERT INTO mur_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Baale laadun ɔɔwa e ɔl dook loocowɛ azɔɔz zɔɔz codoi ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ma aluugonek niigi libir ci akɔ ki jen e zɛɛ makacin ivitak ŋinti een ŋɛwɔn looce o kazi Cinar o kazi zaar oogi nɛ Babilan, ma abaak ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Izitɔ ni niigi ŋinaante nɛ, “Ivita kutuguza tɛgɛrɛm ka kotoozit kodoyit ka kɛtɛɛnyci kutur cinai ŋina kibeen ceez ci wun kurum tammu taden.” Utuguza ni niigi tɛgɛrɛm ki robrobo ci ka kɛtɛɛnycɔi. ");
INSERT INTO mur_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Izitɔ ni nɛ, “Inoko zin kitiŋgaz keteenyit ceez ci wun ɔrɔɔt kurum diizwa ka katanaaztɛ, ma kabaak naaga dook ŋaatodoi calaŋ kazaanonek looc.” ");
INSERT INTO mur_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Iiya ni Jooi looc ka kiiya kicin kutur kibeen ceez ci wun ɛɛnyɛt ɛɛti ci deer o. ");
INSERT INTO mur_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Izi ni niini nɛ, “Inoko mã adoye ɔl, ma azɔɔz niigi zɔɔz codoi, ma akana gi ci abil kiyo nici noko, bar tiŋeere vurta akɔm gi ci akɔmnek nɔɔgɔ ŋaati agɔɔni been nɛɛn. Abon zin inoko kalam nɔɔgɔ ka calaŋ agɔɔn nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kɔɔtɔ loota ka kuulalit zɔɔz cineeŋ azɔɔzi o ka calaŋ aziiŋnɔ.” ");
INSERT INTO mur_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Iiya ni azaanek Jooi nɔɔgɔ looc dook, makacin ibil ceez uneeŋ tɛɛnyinta. ");
INSERT INTO mur_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Akanonek zin kutur nice zaara ci kazi Babilan o, eeci waanice uulal Jooi ɔl ŋinaante calaŋ aziiŋnɔ zɔɔz. Ma azaanek niini nɔɔgɔ looc dook. ");
INSERT INTO mur_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ceegi zin dɔl ci dɔl o Cɛm. Mazi adicai irkitowa raman vurte o tawano, waanbaal izɔi Cɛm irkitowa eet tur (100), itira niini logo onin kazi Arpat. ");
INSERT INTO mur_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Vurte nice abaak bodo Cɛm irkitok eet tur lak tur (500). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Mazi een Arpat irkitowa eetoma kamɔtɔ ki tiin tur (35), itira ŋɛɛrin o kazi Cela. ");
INSERT INTO mur_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ma vurte nice abaak niini irkitok eet tur lak wec ki tiin iiyu (403), ma arita bodo lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Mazi een Cela irkitowa eetoma kamɔtɔ (30), itira niini ŋɛɛrin o kazi Eber. ");
INSERT INTO mur_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Vurte nice abaak bodo Cela irkitok eet tur lak wec ki tiin iiyu (403). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Mazi een Eber irkitowa ogine eetoma kamɔtɔ ki tiin wec (34), itira niini ŋɛɛrin o kazi Pɛlɛk. ");
INSERT INTO mur_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Vurte nice abaak bodo Eber irkitok eet tur lak wec ki eetoma kamɔtɔ (430). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Mazi een Pɛlɛk irkitowa eetoma kamɔtɔ (30), itira niini ŋɛɛrin o kazi Reyu. ");
INSERT INTO mur_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Vurte nice abaak bodo Pɛlɛk irkitok eet tur lak ram ki tiin tɔrkɔc (209). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Mazi een Reyu irkitowa eetoma kamɔtɔ ki tiin ram (32), itira niini ŋɛɛrin o kazi Seruk. ");
INSERT INTO mur_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Vurte nice abaak bodo Reyu irkitok eet tur lak ram ki tiin torgɛrɛm (207). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Mazi een irkitowa o Seruk eetoma kamɔtɔ (30), itira niini ŋɛɛrin o kazi Nayor. ");
INSERT INTO mur_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Vurte nice abaak bodo Seruk irkitok eet tur lak ram (200). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Mazi een irkitowa o Nayor eetoma ki tiin tɔrkɔc (29), itira niini ŋɛɛrin o kazi Tɛrɛ. ");
INSERT INTO mur_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Vurte nice abaak bodo Nayor irkitok eet tur kamɔtɔ ki tiin tɔrkɔc (119). Itira ni bodo niini lɔgɔz ki dɔl ci ŋaai oogi. ");
INSERT INTO mur_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Mazi een irkitowa o Tɛrɛ eet iiyu kamɔtɔ (70), itira niini lɔgɔz iiyu kazi zaar nɛ Abram ki Nayor been Eran. ");
INSERT INTO mur_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ceegi zin dɔl ci dɔl o Tɛrɛ. Anyak niini ŋɛɛrigin iiyu o kazi zaar nɛ Abram ki Nayor been Eran. Iiya ni Eran izi baati Lat. ");
INSERT INTO mur_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Mazi ŋaan arogi Tɛrɛ nɔkɔ, adaak Eran kuture onin aritan kazi Uur. ");
INSERT INTO mur_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ma arɔcɛ Nayor kibeen Abram buk. Kazi ŋaa ci Abram o zaar nɛ Sarai. Aje ŋaa ci Nayor o kazi zaar nɛ Milka. Niini tinati Eran ween buk baati Izka. ");
INSERT INTO mur_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Maje Sarai awɔ koliin kɔkɔm dɔl. ");
INSERT INTO mur_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Uluuk ni Tɛrɛ kuture o kazi Uur. Ɔrkɔr niini ki ŋɛɛrin o kazi Abram, ki Sarai ween ŋaa o Abram, ki Lat ween ŋɛɛrti logo onin kazi Eran arɔɔŋ kook looce o kazi Kanan, bar zin ŋaan kurumit. Arum niigi looc o kazi Giran, ma abaak ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Mazi akɔ een irkitowa o Tɛrɛ eet tur lak ram ki tiin tur (205), adaak niini looce ci kazi Giran noko ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ma iitene oman enek Jooi Abram nɛ, “Tiŋa! Toŋ looc cun noko ki atenok ugun been kɔrɔk o baatun. Bitɔ looce ci ŋaan kakɔ kayelekin ineet. ");
INSERT INTO mur_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kanyin tiŋeere ineet dɔl ci meelik ŋinaante, ma eegin tiŋeere niigi bor ci appe ɔrɔɔt. Kamayukin tiŋeere ineet, ma kanyi zaar ugun kagaye ɔrɔɔt. Amayuwi tiŋeere ɔl dook zaare cugun. ");
INSERT INTO mur_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kamayui tiŋeere ɔl o amayukin ineet, ma kator ɔl o atoryin ineet. Kamayui katin naana modɛn dook ŋaatun.” ");
INSERT INTO mur_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Itiŋawa ni Abram looce o kazi Giran ebaal aduwakɛ Jooi nɔɔnɔ e. Ɔrkɔr niini kibeen Lat. Maje iinyaye niceke izi Abram irkitowa oginɛ eet iiyu kamɔtɔ ki tiin tur (75). ");
INSERT INTO mur_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ma akɔyi niini ŋaa onin kazi Sarai been ŋɛɛrti gɔtɔnɔn ci kazi Lat o, ma avɔyi niigi kaal ugeecik dook, kibeen ɔl o aliŋliŋonek nɔɔgɔ buk. Ɔtɔɔzɔ ni zɛɛ ma avɔ arum looc ci kazi Kanan o. ");
INSERT INTO mur_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Mazi avɔ arum niigi ŋinite, ook otonowa Abram looc zɛɛ ma aku arum kɛɛt ci appe kazi Mora looce o kazi Cekam. Maje iinyaye niceke ŋaan abaak ɔl o kazi Kanan looce nice. ");
INSERT INTO mur_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eyelzak ni Jooi Abram ɛlɛ, ma anek nɔɔnɔ nɛ, “Nicini looc o ka kanyek dɔl ci dɔl ugun nɛɛn.” Ɛtɛɛnya ni Abram ŋinaante ŋinti ka kidiŋdiŋani Jook o ayelzak nɔɔnɔ ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Aluuk ni bodo, ma akɔ ŋaati kutul ajɔŋɔz kutur o kazi Bezal libire ci jenu e. Ma akɔ adɔdɔ kɛɛmanɛ ŋaati aŋɛr Bezal been Aya. Ŋinaante ɛtɛɛnya buk ŋinti taabinto, ma adiŋdiŋan Jook ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Uluuk ni bodo niini ook vitɛnane ogɛn libire ci akɔ ki tɛnɛt e. Iicak akɔ ki looc o kazi Negev. ");
INSERT INTO mur_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ma irkite oman anyawun lɔɔci ci kazi Kanan noko tarjo ci appe ɔrɔɔt ɛlɛ. Makacin ɔtɔɔ Abram ook Masire ka kook kabaak rak ŋintimiliny ŋinaante, eeci appe magiz ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Mazi akɔ ajɔŋɔz Masir, enek ŋaa cin kazi Sarai o nɛ, “Inoko niina een ŋaa ci alina ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Inoko tedec ma acinin ɔl ceen Masir noko ineet, ma agayin een niina ŋaa can, arukan koca tedec niigi aneet kadaak, ma uuŋnin ineet. Abon zin anei niina nɔɔgɔ nɛ, Alaŋ keen ŋaa ci Abram, gɛrzɛ ŋaan arukan kadaak, ka kootin ineet giye o alinanɛ niina ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Bar abon anei nɔɔgɔ nɛ, Keen ŋɔɔni Abram gi. Mã agoon nɔkɔ, akɔm koca gi ci gɛr akunakan.” ");
INSERT INTO mur_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Mazi akɔ arum Abram ki ŋaa Masir, icinit didi Masira ŋaa linat o alinan ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Mazi acin ɔl ween inyaati o alaan o adikir kazi Vɛɛro ŋaa linat nɔkɔ, ɔɔt uduktak niigi alaan anek nɛ, “Anyak ŋaa ci alina ɔrɔɔt ɛlɛ ŋaato.” Iiya ni ooti ɔl Sarai ole o alaano. ");
INSERT INTO mur_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ma atalna Vɛɛro Abram juruŋ giye ci akati Sarai, ma ajowa Abram ɛɛza ki tiin ki zigire ki nyakalɛt been gabara ci aliŋliŋonek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Itoonek ni Jooi Vɛɛro kibeen kɔrɔk onin mɔɔriz ci appe ɔrɔɔt ɛlɛ giye ci akɔyi niini Sarai ceen ŋaa ci Abram o. ");
INSERT INTO mur_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Mazi akɔ aga Vɛɛro labiin ci alabɛkɛ Abram nɔɔnɔ ŋaa cin o, otowa nɔɔnɔ, ma aku anek nɛ, “Gitaz ci agoonekan noko? Naa alaŋ aduwakan anekan nɛ, Nicini ŋaa can, naa? ");
INSERT INTO mur_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Naa alabanan azi nɛ, Nicini ŋɔɔna gi, makacin kooyɛ kizi ŋaa can o naa? Inoko zin ŋaa unun ce. Biti, tiŋa ŋina, tɔ.” ");
INSERT INTO mur_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ma aricanek Vɛɛro takirnya ogin zɔɔz ci ka kɔtɔɔkti Abram. Otooyit ni niigi nɔɔnɔ ki ŋaa cin o kooti kaal ugeec dook. ");
INSERT INTO mur_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Uluuga ni Abram Masirɛ ki ŋaa onin ki kaal ogin dook been Lat, ma avunak bodo looc o kazi Kanan. ");
INSERT INTO mur_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Zin inoko Abram izi kabaran ci anyak tiin ki ɛɛza, ma anyak buk warki. ");
INSERT INTO mur_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Akata ni luuge ŋaa o kazi Negev, ma azɔp vitɛn ci meelik zɛɛ ma akɔ arum ŋin o aŋɛr Bezal been Aya baal rak abaayi niini ɔɔwa e. ");
INSERT INTO mur_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Maje ŋinaante ɛtɛɛnya niini baale laadun ŋinti taabinto. Idiŋdiŋan ni niini Jook bodo ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Maje Lat o ɔrkɔr ki Abram anyak buk niini tiin ki ɛɛza ki atenok cigin been gabara ci aliŋliŋonek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Alaŋ zin kuturi nici anyak artɛ ci alɛɛnɔ ki tiin been ɛɛza ŋaati aromɛn niigi dook ŋaatodoi, eeci anyak niigi tiin ki ɛɛza ci meelik ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Zin giye nico ɔyɔktɔ ɔl ugeec towawiinto. Maje iinyaye niceke ŋaan ɔl o kazi Kanan been Periz abaak looce nice buk. ");
INSERT INTO mur_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Enek ni Abram Lat nɛ, “Keegin naaga aten. Ɔl cugunɛ o kibeen ɔl cigan o alaŋ abon ŋaati ayɔwɔn. ");
INSERT INTO mur_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Inoko ŋɛra libir ci olla arooŋ niina looce nico ka kɛŋɛrtɔ. Mã akɔ niina ki libir ci azo o, kakɔ naana ki libir ci kaŋeto o. Mã akɔ niina libire ci kaŋeto o, kakɔ naana ki libir ci azo o.” ");
INSERT INTO mur_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ataŋaamek ni Lat looc dook, ma acin Jordan een ŋɛwɔn ma anyak maam ci abona vitɛnane dook, ma atobɔ buk ki mana o Joowo kazi Idan, ma atobɔ ki looc o Masiro. Lɔɔci nicini akɔ zɛɛ been Zowar. Maje waanice iinyaye niceke ŋaan Jooi kilip kutur o kazi Sodom kibeen Gomora baal ɛɛl ŋinaante e. ");
INSERT INTO mur_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ɛŋɛrak ni Lat ɛlɛ onin ŋɛwɔn o kazi Jordan dook, ma aluugonek niini ŋinite. Ɛŋɛryɔ ni niigi. ");
INSERT INTO mur_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ma abaak Abram looce o kazi Kanan. Aje Lat abaak niini kuturyok o ɛɛl ŋɛwɔna kɔrgɛna ŋaati ajɔŋɔz kutur o kazi Sodom. ");
INSERT INTO mur_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Maje iinyaye niceke agɔɔn ɔl o Sodom kaal ci gɛr ɔrɔɔt, ma abaca niigi oŋɛ ci appe ɔrɔɔt ɛlɛ Joowa. ");
INSERT INTO mur_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ma vurte o uluugi Lat, enek Jooi Abram nɛ, “Dɔŋ di ɔɔ. Gɛlɛm looc nico dook. Cin baatikeri ki tɛnɛt ki jen been nyagi. ");
INSERT INTO mur_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Inoko zin kanyin looc ci acin noko dook ineet been dɔl ci dɔl cugun ka kizi looc ci boryok cugun ka kabaakti niigi nɔkɔ izi nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kanyi tiŋeere dɔl ci dɔl cugun kizi mɛɛlɛ ɔrɔɔt kotobtɔ ki kazac kɔkɔm eet ci akɛɛp nɔɔnɔ. Mã anim ɛɛti ci deer kɛkɛɛp kazac, ŋaan akɛɛp buk koca niini dɔl ci dɔl cugun. ");
INSERT INTO mur_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Inoko tiŋa. Bitɔ tonowa looc nico dook ka cin juruŋ, eeci kanyin ineet kizi cun.” ");
INSERT INTO mur_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Uluuk ni Abram, ma akɔ abaak ŋaao ajɔŋɔz kɛɛn o kazi Mamra o ajɔŋɔz ŋino kazi Ebiron. Ma ŋinaante ɛtɛɛnya ŋinti taabinto. ");
INSERT INTO mur_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Zin waanice anyak alaat ceen wec kazi zaar cigeec nɛ Kidolama alaan ci looc o kazi Ilam, ki Arik alaan ci looc o kazi Elazar, ki Amrava alaan ci looc o kazi Cinar, ki Tidal alaan ci looc o kazi Goyim. ");
INSERT INTO mur_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Agaŋonek alaata nicigi gɔnɔgi ceen tur ci kazi zaar cigeec nɛ Bira alaan ci looc o kazi Sodom, ki Bica alaan ci looc o kazi Gomora, ki Cena alaan ci looc o kazi Adama, ki Cimba alaan ci looc o kazi Zeboyim, been alaan ci looc o kazi Bela. ");
INSERT INTO mur_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","4","Alotɛ alaata ci awɛ zaara cigeec vurta noko dook nyarate o kazi Sidim o liil o amokcar maama, eeci waanice abal nɔɔgɔ alaani ci kazi Kidolama noko irkitok amɔtɔ ram, ma irkite ceen amɔnki iiyu o ujurta niigi ŋaati abali Kidolama nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ma irkite ween amɔnki wec Kidolama ki alaat o aromonek nɔɔnɔ been takirnya ugeec ɔɔt akatit ɔl o Rivam abaak looce o kazi Atirkinam, ki ɔl o Zuzim abaak ŋaao kazi Am, been ɔl o Imim abaak balale o Kirima, ma ɔɔrɔ zɛɛ ma amɔk nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Ma akat buk niigi ɔl o Orit abaak biyene o Edom, ma atɔɔk niigi nɔɔgɔ zɛɛ ma arumi Ilparan o ajɔŋɔz balal. ");
INSERT INTO mur_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Abada ni niigi, ma avɔ amiironek Kadec, ma akat ɔl o looc o Amalikait kibeen ɔl o Amorit abaak looce o kazi Azazo. ");
INSERT INTO mur_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mazi azii alaata o Sodom ki o Gomora ki o Adama ki o Zeboyim been o Bela zɔɔz nico, olotit niigi takirnya ugeec ka kɔɔt kooryɔ ki Kidolama nyarate o looc o kazi Cidam. ");
INSERT INTO mur_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ɔmɔk ni Kidolama been laŋotigin alaan o Sodom been ɔl ogin. ");
INSERT INTO mur_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Maje nyarati ci looc ci kazi Cidam noko anyak robrobo ci amardit. Mazi ka kivirit alaata o looc o kazi Sodom ki Gomora ɔrɔɔnta, iitazak niigi robrobo ci amardit noko, ma agam nɔɔgɔ robrobo nici zɛɛ makacin ivita uruktek ɔl ŋinito. Ma avir ŋaatineeŋ ogɛn avɔ biyɛnɛ. ");
INSERT INTO mur_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Agamit ni Kidolama ki ɔl ogin kaal o kuturyok o kazi Sodom been Gomora dook. ");
INSERT INTO mur_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ma agam buk niigi Lat ween ŋɛɛrti gɔtɔni Abram o abaak kuture o kazi Sodom ki kaal ogin dook. ");
INSERT INTO mur_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ma avira ɛɛti codoi ole ci ona atɔɔk modo nɔɔgɔ o, ma aku aduwak Abram zɔɔz nico. Maje waanice Abram abaak ŋaao ajɔŋɔz kɛɛn ci eet o kazi Mamra ween modɛn o kazi Amorit. Maje Mamra anyak gɔtɔnɔgi ci kazi zaar nɛ Ecika kibeen Ana ween niigi dook laŋoten kibeen Abram. ");
INSERT INTO mur_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Mazi azii Abram atenoi onin agamit modo, olota niini ɔl ci aganek ɔrɔɔn een eet tur lak iiyu kamɔtɔ ki tiin turge (318) ole o kɔrɔk onin, ma ɔrkɔr buk niini been laŋotigin ween modɛn abaawɔ ki nɔɔnɔ, ma avɔ ano modo niceke zooc zɛɛ been looc o kazi Dan. ");
INSERT INTO mur_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mazi avɔ arum niigi ŋinite, eŋerun Abram ɔl cigin noko, ma aliya modo nicoko baal, ma aŋozonek nɔɔgɔ, ma atɔɔk zɛɛ ma avɔ arumi ŋinti rɛɛn many kazi Iba libire ci baatikeri e kuture o kazi Damacik. ");
INSERT INTO mur_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ma abadaan Abram kaal o avɔyi modo e dook kibeen buk ŋɛɛrti gɔtɔnɔn o kazi Lat ki kaal ogin dook been ŋaai kibeen ɔl o agam modo e dook. ");
INSERT INTO mur_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Mazi akɔ abada Abram ɔrɔɔnte ci ona amɔgi niini alaan o kazi Kidolama kibeen alaat o ɔrkɔr ki nɔɔnɔ noko, iiyak nɔɔnɔ alaani o kutur o kazi Sodom ŋaati ajɔŋɔz kutur o kazi Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ma aku buk alaani o Jerusalɛm kazi Mɛlikizadɛk, ma anyaak niini Abram ḏɔkɛn ki nyaan. Maje Mɛlikizadɛk nici waanice niini alaan ci adiŋdiŋan Jook. ");
INSERT INTO mur_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Amayuk ni niini Abram enek nɛ, “Abon bai Jooi o adikir ɛɛnyca tammu taden ki looc amayukin ineet. ");
INSERT INTO mur_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kanaatit Jook o adikir o atiritin ineet mɔk modo.” Eŋerak ni Abram Mɛlikizadɛk kaal oogi kaale ci ona anyaa ɔrɔɔnta o. Agɔɔn niini nɔkɔ o, eeci arɔɔŋ kaada Jook kaale o ɔɔra. ");
INSERT INTO mur_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Enek ni alaani o Sodom Abram nɛ, “Biti kaal cugun ɔɔra o dook, olla nyan aneet ɔl cigan o doon.” ");
INSERT INTO mur_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Bar abɛdɛkɛ Abram nɔɔnɔ anek nɛ, “Kɛtɛrkɛda naana zaare o Jook o adikir o ɛɛnyca tammu taden ki looc ka calaŋ kakɔyɛ kaal cugun, yo nuun een laamoc ci caavito alaŋ kakɔyɛ been nɛɛn, eeci alaŋ karooŋnyin ineet bitɔ bolol izi nɛ, Kanyeya Abram kizi arɔi. ");
INSERT INTO mur_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Alaŋ zin naana kagama gi ci ka kooyi ŋaatun been nɛɛn. Olla kagama dayiin ona adak ɔl ogane e doon. Aje ɔl ci kazi Mamra ki Ecika been Ana baal atiritan aneet ɔrɔɔnta o, abon aŋɛrai nɔɔgɔ kaal cigeec.” ");
INSERT INTO mur_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ma vurte nice enek Jooi Abram wunozyai nɛ, “Má anyei ŋoliin. Ŋaan keen naana kilip cun, ma ŋaan kanyin ineet gi ci appe ɔrɔɔt kadizikin.” ");
INSERT INTO mur_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Bar abarzek Abram nɔɔnɔ anek nɛ, “Manyi Jook, gitaz ci ka dizikan aneet? Akɔmnan dɔl ci ka kavadawan. Bar kɔrɔk can o arigizi tiŋeere gabarɛnti onane kazi Ilizar een Damaciken.” ");
INSERT INTO mur_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ma azii bodo niini molok ci Joowo anek nɔɔnɔ nɛ, “Alaŋ Ilizar ceen gabarɛn o avadin ineet, bar avadin tiŋeere ineet ŋɛɛrun cunɛ maany.” ");
INSERT INTO mur_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ooyi ni Jooi Abram bitaala, ma akɔ anek nɛ, “Cin di tammu kɛŋ. Kɛɛp di monyony ci ɛɛl tammo kɛŋa neke mã anim. Anyei zin katin niina dɔl ci dɔl cugun ci meelik kotobtɔ ki monyony niceke.” ");
INSERT INTO mur_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Arek ni Abram ziniz Jook tuwɛnta ɔrɔɔt ɛlɛ. Ma atal Jooi nɔɔnɔ giye nico. ");
INSERT INTO mur_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ma anek Jooi bodo nɔɔnɔ nɛ, “Aneeta Jook o kanyaanin ineet looce o kazi Uur nɛɛn, ka kiiya kanyin ineet looc nico ka kizi looc cun.” ");
INSERT INTO mur_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bar ajin Abram nɔɔnɔ anek nɛ, “Manyi Jook o abal kaal dook, mayo zin ka kaga izi ŋiniti ŋintan o ku?” ");
INSERT INTO mur_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ma ɛbɛdɛkɛ Jooi nɔɔnɔ anek nɛ, “Ŋaan katerkedekin zɔɔz oma ce. Inoko rak nyayan mool ci ŋai een loŋorec, ki nyɔɔn ceen root, ki mirkic, been yɛɛla ram.” ");
INSERT INTO mur_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Anyaak ni Abram Jook kaal nicoko dook, ma aku atɔdɔŋ, ma apak nɔɔgɔ dook kɔrgɛna kotobtɔ. Ma azɛt nɔɔgɔ dook kɛlɛbɛztɔ, maje yɛɛla alaŋ nɔɔgɔ aŋɛr kɔrgɛna. ");
INSERT INTO mur_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ŋintimiliny nɔkɔ iitazɔ kuduvaana arɔɔŋ kadayit idi nicoko, ma aturan Abram kuduvaa nicoko. ");
INSERT INTO mur_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Mazi atoltol ii loota, ɛtɛɛda Abram ooŋnya ɔrɔɔt ɛlɛ, ma acin nɔŋ ci kɔl wunozyai, ma anyak ŋoliin ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Enek ni Jooi nɔɔnɔ nɛ, “Agamnyi katin dɔlya ci dɔl cugun kɔɔt kiziti mirɔk looce ci ɔl oogi. Ma avɔ agide niigi ŋinaante irkitok eet tur lak wec (400). ");
INSERT INTO mur_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bar zin ŋaan kapayei waanma ɔl ci anyek nɔɔgɔ kizi mirɔk o gerzitin. Ma vurta ŋaan abadaak dɔlya ci dɔl cugun o bodo ŋinito. Ma anyaa niigi looce nice kaal ci meelik ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","16","Bar zin abon rak aavtiz niigi ŋinaante irkitok eet tur lak wec (400), eeci ŋaan kizi iiten ci ka kapai gerzitin ci ɔl o Kanan. Aje zin niina alya ŋaan arugi ŋinti rɛɛn ɔrɔɔt zɛɛ ma adaai kanyatiz.” ");
INSERT INTO mur_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Mazi akɔ ii loota, eyelizai iju ci anyak burɛt kibeen goo ci alanyit, ma aku awɔ kɛlɛk ona apaki e kɔrgɛna. ");
INSERT INTO mur_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Zin iitene nice ɛlɛ eterkedek bodo Jooi Abram zɔɔz ci anek nɛ, “Kanyi dɔl ci dɔl cugun looc nico akanai ŋaao ajɔŋɔz looc o Masiru zɛɛ ma akɔ arum liil o adikir kazi Yuparatiz. ");
INSERT INTO mur_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ma nici looc ci ɔl o kazi Kenatiz ki Kenizatiz ki Kadamonatiz ");
INSERT INTO mur_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ki Ititaz ki Periz ki Rivam ");
INSERT INTO mur_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ki Amorit ki Kanan ki Gagacatiz been Jebta.” ");
INSERT INTO mur_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Waanice Sarai ween ŋaa o Abram ŋaan awɔ koliin. Ma anyak niini dole ceen Masiren kazi zaar nɛ Egar ci aliŋliŋonek nɔɔnɔ kizi gabaren cin. ");
INSERT INTO mur_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Enek ni niini Abram nɛ, “Inoko acaban Jooi aneet kɔtɔɔ koliin. Abona di aromenu ki dole can een gabaren noko ka coma kavadjai naana ŋaatin.” Agama ni Abram zɔɔz ci aduwak Sarai nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ma anyek Sarai nɔɔnɔ gabaren cin kazi Egar noko kizi ŋaa cin aavtiz. Maje Abram abaawun waanice Kananakti irkitok amɔtɔ. ");
INSERT INTO mur_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ataŋguzɔ ni Abram been Egar zɛɛ makacin anyawɔ. Bar mazi aga niini ɛlɛ anyawɔ nɔkɔ, ɔdɔŋi ɛlɛ Sarai, ma apɛz nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Enek ni Sarai Abram nɛ, “Inoko pezinɛt nici akunakan gole cun. Kanyin Egar ineet, bar mazi acin niini ɛlɛ anyawɔ nɔkɔ, abawan aneet. Ŋaan zin aga gi nico Jooi doon aneeta ki ineet ŋɛnɛɛn ŋaatina ci alɛɛm.” ");
INSERT INTO mur_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ma abɛdɛkɛ Abram nɔɔnɔ anek nɛ, “Didi zin niini gabaren cun. Aavi niini dɔyize cun. Tugu niina olla gi ci arooŋ tuguwek nɔɔnɔ.” Otoborek ni Sarai Egar nɔŋ, ma ayɔk nɔɔnɔ, makacin uruk tuu. ");
INSERT INTO mur_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ma akɔ ajowa toonnyaiti ci Joowo Egar lamurḏenti ci abil balala gole ci akɔ Masirɛ. ");
INSERT INTO mur_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ma anek nɔɔnɔ nɛ, “Egar ween gabarɛn o Sarai, agoon naa ŋina?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Karuwa tuu kavira ŋaati Sarai.” ");
INSERT INTO mur_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ma anek toonnyaiti nɔɔnɔ nɛ, “Miire bitɔ ŋaatin. Bitɔ liŋliŋozek nɔɔnɔ zinize ci alal.” ");
INSERT INTO mur_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ma anek bodo toonnyaiti nɔɔnɔ nɛ, “Kazaaci waanma dɔl ci dɔl cugun kizi mɛɛlɛ ɔrɔɔt kɔkɔm eet ci akɛɛp.” ");
INSERT INTO mur_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ma anek buk toonnyaiti ci Joowo noko nɔɔnɔ nɛ “Inoko niina anyake. Tiŋeere zin ookca logoz. Katek zin tiŋeere nɔɔnɔ zaar ci kazi Ismayil, eeci iziik Jooi luwa unun. ");
INSERT INTO mur_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Avaraciz zin katin niini kizi kelegit o too, ma amarnin niini ɔl dook, ma buk ɔl dook amarnin nɔɔnɔ. Ma abaak katin niini doon calaŋ aromɛ ki atenok ogin.” ");
INSERT INTO mur_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Izi ni Egar nɛ, “Inoko kicina didi naana Jook o. Buk acinan niini aneet, ma bar ŋaan karugi labak.” Akatek ni niini Jook o azɔɔzɔ ki nɔɔnɔ zaar ci kazi Jook o Acinan Aneet. ");
INSERT INTO mur_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Gi zin ci awɛ ɔl ṯuuk nice zaar ci kazi Acinan Jooi Aneet o nɛɛn. Ma ṯuuwi nicana ŋaan abil ŋaao aŋɛr Kadec been Bɛrɛd zɛɛ been inoko o. ");
INSERT INTO mur_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Mazi akɔ amiironek Egar kɔrɔk o Abram, ŋintimiliny nɔkɔ otowa niini ŋɛɛrin, ma akanek Abram dole zaar ci kazi Ismayil ebaal aduwan Jooi e. ");
INSERT INTO mur_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ma iinyaye ci aritan Ismayil neke izi irkitowa o Abram eet wec ki tiin tɔrkɔnɔm (86). ");
INSERT INTO mur_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Mazi een Abram irkitowa eet wec kamɔtɔ ki tiin tɔrkɔc (99), eyelizak Jooi nɔɔnɔ ɛlɛ bodo, ma anek nɛ, “Keen Jook o kanyei dɔyiz dook. Ziiyan aneet tugu kaal ci abon. ");
INSERT INTO mur_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ŋaan bodo kagoon naana terkediin onan been ineet, ma kanyin ineet dɔl ci dɔl cugun kiziti mɛɛlɛ gɛr.” ");
INSERT INTO mur_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Oloca ni Abram ɔɔ ŋaati adiŋdiŋani Jook, ma anek Jooi nɔɔnɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Inoko katerkedekin naana ineet gi ci ka izi niina jijiti boryok ci meelik. ");
INSERT INTO mur_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Inoko ineet alaŋ bodo kazi zaar cugun nɛ Abram, bar kazi zaar cugun nɛ Ibrayim, eeci niina katin een baati ɔl ci meel. ");
INSERT INTO mur_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kanyin katin ineet dɔl ci dolenu kizi mɛɛlɛ kadala loocok, ma eegin katin ogɛn ŋaatineeŋ alaat ci adiŋdiŋ loocowɛ. ");
INSERT INTO mur_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kanyi tiŋeere terkediin onan kibil nɔkɔ kodot ŋaatun kibeen dolene ci dɔl cugun. Ma keen naana Jook cun nɔkɔ, ma keen buk Jook ci dɔl ci dɔl cugun. ");
INSERT INTO mur_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanyin tiŋeere ineet been dɔl ci dolenu looc ci inoko ɛɛnɛ niina modɛn ci akɔm eet ci agayin noko. Ma lɔɔci ci kazi Kanan noko dook izi looc ci dɔl ci dɔl cugun izi nɛɛn, ma keen naana Jook cineeŋ nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ma anek Jooi Ibrayim bodo nɛ, “Zin niina libire cun abon azoonɛ gi o karicanekin naana ineet tugu. Ma abon buk agɔɔn dɔlya ci dɔl cugun nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Abona zin ɔl o macik ŋaatunooŋ dook ateedi. ");
INSERT INTO mur_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Abona niiga ateedinu ka kizi teedinɛt nici bayen ci terkediin onan aneet kibeen ineet. ");
INSERT INTO mur_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Utuguz gi nico nɔkɔ zɛɛ been bulok ci katin ŋaan aavu e. Ma aritai dole ci mac ŋaatunooŋ, mazi adica niini iinya turge, abon ateedu niiga nɔɔnɔ. Utuguzek buk gi nico gabara ci mac aritai ŋaatunooŋ been gabara ci ataalanu ole ogɛn. ");
INSERT INTO mur_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ɔl ci maci dook abon agɔɔn nɔkɔ ka keyelizai terkediin onane abil kodot teedinte cunooŋ o. ");
INSERT INTO mur_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ma ɛɛti calaŋ atɛɛdi, alaŋ akeebonek niini ɔl ogan, eeci alaŋ azooni niini terkediin onan.” ");
INSERT INTO mur_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ma anek bodo Jooi Ibrayim nɛ, “Inoko ŋaa cun kazi Sarai noko alaŋ bodo kazi zaar cigin nɛ Sarai, bar kizi zaar cigin nɛ Sara. ");
INSERT INTO mur_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ŋaan kamayui naana nɔɔnɔ ka kitirayin logoz. Ma buk kamayui naana nɔɔnɔ ka kizi yaati boryok ci meelik, ma aritai katin dolene ci dɔl cigin alaata ci adikir.” ");
INSERT INTO mur_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Akati ni Ibrayim kozoŋti looc ŋaati adiŋdiŋani Jook, ma ararni ɛlɛ maany ziniza azi nɛ, “Ku ka kitira dole ŋaati kizɔyɛ matuwoc ceen irkitowa eet tur (100) o? Ku buk ka kitira Sara dole ŋaati izɔi niini matuwoc ceen irkitowa eet wec kamɔtɔ (90) o?” ");
INSERT INTO mur_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Enek ni niini Jook nɛ, “Inoko mã amayui Ismayil, avadanan koca niini aneet labak.” ");
INSERT INTO mur_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bar anek Jooi nɔɔnɔ nɛ, “Akɔm! Ŋaan aritakin ŋaa cune kazi Sara noko logoz, ma akanei nɔɔnɔ zaar ci kazi Aizak. Ŋaan kazoonɛ naana terkediin onan baal kaduwa e nɔkɔ kodot ŋaatin kibeen dolene ci dɔl cigin. ");
INSERT INTO mur_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Maje giye ci akati Ismayil kazii zɔɔz cun o. Ŋaan zin kamayui nɔɔnɔ, ma kanyi nɔɔnɔ dɔl kibeen dɔl ci dolenu kizi mɛɛlɛ. Ma een niini katin jijiti alaat ceen amɔtɔ ram, ma kagoon katin naana dɔl cigin kizi bor ci appe. ");
INSERT INTO mur_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bar zin ŋaan kagoon gi o kaduwa naana terkediinte onan ŋaati ŋɛɛrun o kazi Aizak o ŋaan aritai niini ŋaati Sara irkite ci ŋaan aku e.” ");
INSERT INTO mur_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Mazi akɔ aṯornɛkɛ Jooi zooze onin ki Ibrayim, ɔtɔɔ niini. ");
INSERT INTO mur_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Taman nɔkɔ iitene nice ɛlɛ ozooti Ibrayim zɔɔz o Joowo, ma atɛɛt ŋɛɛrin o kazi Ismayil been buk gabara o aritai ole onin, ki o ataalyai, ma ateedi maczɛt dook ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ma ateedi buk Ibrayim niinilya ŋaati izitɔi irkitowa eet wec kamɔtɔ ki tiin tɔrkɔc (99). ");
INSERT INTO mur_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Aje Ismayil ceen ŋɛɛrin o izi irkitowa amɔnki iiyu waanci baal ateedinɛ niini neke. ");
INSERT INTO mur_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ma eteede niigi dook iiten codoi ṯɔr nɔkɔ, ");
INSERT INTO mur_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","kibeen gabara o kɔrɔk onin dook. ");
INSERT INTO mur_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ma iitene oman eyelezak Jooi Ibrayim ɛlɛ ŋaati ajɔŋɔz kɛɛn o Mamra. Iitene nice aavi niini loota ceez onin een rum rɛɛrna waaz iilya ŋaati aburni kɔr. ");
INSERT INTO mur_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Mazi adɔŋ ɔɔ, acin ɔl ceen iiyu ɛɛl. Bar tɛ codoi ŋaatineeŋ Jook gi, maje raman toonnyak. Maje Ibrayim alaŋ aga. Mazi acin niini nɔɔgɔ, odokonyozek ook urumek gɔl, ma akɔ azaa nɔɔgɔ ŋaati adiŋdiŋani. ");
INSERT INTO mur_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ma anek nɛ, “Manyi, mã areezaŋ niiga aneet, má adiceku. Ivita uyubuzit rak ole can o ŋaato. ");
INSERT INTO mur_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Anycaŋ kanyaayuŋ maam ci ka otoonyci zɔɔ ka uyubuzit rak raa ŋina. ");
INSERT INTO mur_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ka buk kanyaayuŋ dayiin ci atiritu eleeti ŋaan awoyu.” Ma abɛdɛkɛ niigi Ibrayim anek nɛ, “Abona. Tugu eci aduwa o.” ");
INSERT INTO mur_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Iyiik ni Ibrayim ook kɛɛmawa, ma akɔ anek Sara nɛ, “Doma tela ci vɔɔr taman. Ŋɔɔny ka aayek kernok ḏɔkɛn.” ");
INSERT INTO mur_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ma adokonyonek Ibrayim tiin, ma akɔ acina ariz ci ŋaan een mɔr ci adii ɔrɔɔt. Ma anyaa, ma aku anyek gabaren kotodoŋek nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Anyaa ni Ibrayim ŋoroc kibeen iira been idi, ma anyek nɔɔgɔ kadaktɔ. Ma arɛ niini nɔɔgɔ raa ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ma ajin niigi Ibrayim anek nɛ, “Aavi ŋaa ununɛ ŋaaḏaŋ?” Abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Aavi kɛɛmawa ŋaate.” ");
INSERT INTO mur_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ma anek kernoiti codoi Ibrayim nɛ, “Didilɛ tiŋeere irkite ci aku e nyelowe nico ma kabada, kamɔda anyak Sara ceen ŋaa cun noko logoz anyɔtɔi.” Maje Sara aziirar nɔɔgɔ kɛɛmawa eecitɔ. ");
INSERT INTO mur_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aje waanice Ibrayim been Sara iziti matuwo ɔrɔɔt ɛlɛ. Sara alaŋaan anyak maam ugeec ŋaanu. ");
INSERT INTO mur_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Atarari ni Sara ɛlɛ maany, ma azi ziniza nɛ, “Inoko naaga dook kizita matuwo. Ku oca ka kanyakta dole o?” ");
INSERT INTO mur_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ijin ni Manyi Ibrayim enek nɛ, “Naa arar Sara, ma azi nɛ, Didi dim ka kanyak dole ŋaati kizɔyɛ matuwoc o ku? ");
INSERT INTO mur_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Anyak gi ci akɔmnek Jook tɔ? Inoko zin abil eona kaduwakin ineet e. Tiŋeere irkite ci aku e nyelowe nico ma kabada, kajowa Sara anyawun logoz.” ");
INSERT INTO mur_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Zin giye o aŋolin Sara nɔɔnɔ, adaŋɔ niini izi nɛ, “Ŋaan katarar.” Ma anek Jooi nɔɔnɔ nɛ, “Atararu uyen. Má adaŋe gaga.” ");
INSERT INTO mur_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mazi awɔ kernowa nicigi, itoonek Ibrayim nɔɔgɔ gɔl. Mazi avɔ arum niigi ŋinti kutul, icinit Sodom. ");
INSERT INTO mur_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Izi ni Manyi Jooi nɛ, “Alaŋ abon ŋaati karɔɔdɛ Ibrayim gi ci karooŋ kutugu noko. ");
INSERT INTO mur_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Eeci dɔlya ci dɔl cigin katin niigi eegin bor ci appe adɔi kak, ma amayuwi katin modɛna dook zaare cigin. ");
INSERT INTO mur_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Eeci kɛŋɛra naana nɔɔnɔ ka kuduwak niini dɔl ci dolenu kiziiktan aneet ka kutuguzɔ kaal ci abon, ka kozooti naana terkediin onan ŋaatineeŋ.” ");
INSERT INTO mur_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Enek ni Jooi Ibrayim nɛ, “Kazii kaviyak ci ɔl ci Sodom ki Gomora agɔɔn niigi kaal ci gɛr ɔrɔɔt, ma anyayit niigi oŋɛ ci gɛr appe ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Karooŋ zin kook kicin naanalya mã didi agɔɔn niigi kaal ci gɛr kiyo aduyai o, ka kaga.” ");
INSERT INTO mur_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Idicek ni toonnyawa ɔɔt ki Sodom. Maje Manyi Jooi ŋaan ɛɛl niini ki Ibrayim. ");
INSERT INTO mur_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Iicayak ni Ibrayim nɔɔnɔ, ma ajin anek nɛ, “Anyak gi ci karooŋ kijinin. Didi dim niina akɔ uulal ɔl ci gɛr been ɔl o abon buk ŋinaante? ");
INSERT INTO mur_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mã ajowa ɔl ci abon een eet ram kamɔtɔ (50), uulal ni ŋinite, ma alaŋ uuŋ giye ci akati nɔɔgɔ? ");
INSERT INTO mur_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kagayin alaŋ agoon nɔkɔ. Alaŋ uulal ɔl o gɛr kibeen o abon buk, eeci alaŋ abon ŋaati apirnanɛ niina nɔɔgɔ dook gole codoi. Kagayin alaŋ agoon nɔkɔ, eeci een niina alaan o looc dook, ma apai niina kaal juruŋ keelit tɔp.” ");
INSERT INTO mur_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ma abɛdɛkɛ Jooi nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een eet ram kamɔtɔ (50), kooŋ koca kutur nice giye cineeŋ calaŋ kuulal.” ");
INSERT INTO mur_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ma abɛdɛkɛ Ibrayim nɔɔnɔ bodo anek nɛ, “Keen naana eet ci deer labak. Olla kalayin ineet bodo karooŋ kijinin. ");
INSERT INTO mur_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Mã ajowa niina ɔl ci abon een eet ram ki tiin tur (45), uulal koca kutur dook?” Ma abɛdɛkɛ Jooi nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een eet ram ki tiin tur (45), alaŋ kuulal kutur nice.” ");
INSERT INTO mur_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Bodo ajin Ibrayim nɔɔnɔ anek nɛ, “Mã ajowa ɔl ci abon een eet ram (40), uulal koca kutur dook?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een eet ram (40), alaŋ kuulal kutur dook.” ");
INSERT INTO mur_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ilalek ni bodo Ibrayim Jook enek nɛ, “Má da abornekan nɔŋ mã kijinin bodo. Mã ajowa ɔl ci abon een eetoma kamɔtɔ (30), uulal koca kutur dook?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een eetoma kamɔtɔ (30), alaŋ koca kuulal kutur.” ");
INSERT INTO mur_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ma anek Ibrayim Jook nɛ, “Nyan kɛmɛda kijinin bodo. Mã ajowa ɔl ci abon een eetom (20), uulal koca kutur dook?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een eetom (20), alaŋ koca kuulal kutur.” ");
INSERT INTO mur_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ma ilalek bodo Ibrayim nɔɔnɔ anek nɛ, “Manyi Jook, má abornekan nɔŋ. Karooŋ kijinin bodo lak codoi ṯɔr nɔkɔ. Mã ajowa ɔl ci abon een amɔtɔ (10), uulal koca kutur dook?” Ma abɛdɛkɛ Jooi nɔɔnɔ anek nɛ, “Mã kajowa ɔl ci abon een amɔtɔ (10), alaŋ koca kuulal kutur.” ");
INSERT INTO mur_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mazi akɔ odotiz niigi zɔɔza, idicek Jooi. Ma amiironek Ibrayim kɔrɔk onin. ");
INSERT INTO mur_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ma avunak toonnyawa ceen ram o Sodom yomana, maje Lat aavi kutur araana. Mazi acin niini nɔɔgɔ, itiŋa jena, ma akɔ arumek gɔl, ma azaa nɔɔgɔ ŋaati adiŋdiŋani. ");
INSERT INTO mur_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ma anek nɔɔgɔ nɛ, “Manyigi, ivita kɔrɔk can cɛlbɛz noko ŋaato ka otoonyit zɔɔ, ma ayubuzu baalin nico ole can o ŋina. Ŋaan aloku ŋeere ririwɔna.” Bar abarzek niigi nɔɔnɔ anek nɛ, “Akɔm! Ŋaan koogina kutur kɛŋa ŋina.” ");
INSERT INTO mur_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ma ilalek Lat nɔɔgɔ kivitak kɔrɔk. Makacin agamta niigi orkorit ki nɔɔnɔ. Ma akɔ agoonek niini nɔɔgɔ dayiin ceen ḏɔkɛn alaŋ amokcar. ");
INSERT INTO mur_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mazi ŋaan acinɛ niigi nɔkɔ, ivita ɔl o Sodom macik dook, lɔgɔzɛt been ɔl o adikir buk, ma avu aliya ceez. ");
INSERT INTO mur_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ma awo Lat, ma ajin anek nɛ, “Aavtiz ɔl ona avunak kɔrɔk cun o e ŋaa? Dunaket nɔɔgɔ bitaala ŋaato. Karooŋnya ka kɔŋɔzta.” ");
INSERT INTO mur_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Uduna ni Lat bitaalin, ma anyook karogi eci bawuco. ");
INSERT INTO mur_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ma anek nɔɔgɔ nɛ, “Ɔl ogan, kilalekuŋ igeet calaŋ agoonu gi ci gɛr abil nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Eelit di, kanyei dɔl ceen kabarzɛ ŋaan aavtiz baala. Anycaŋ kudunakuŋ nɔɔgɔ. Ŋaan agooneku nɔɔgɔ gi ci olla arooŋnyu niiga utuguzek. Alaŋ abon ŋaati agoonu gi ci abil nɔkɔ ole nicoko, eeci ivitayan niigi aneet ole can o.” ");
INSERT INTO mur_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bar anek niigi Lat nɛ, “Madayɛ ŋaatinaaŋ. Een niina modɛn ci rɛŋ. Niina ineet ŋɛnɛɛn ci ka duwayet gi ci kagoona o? Nyɛ ŋaatinaaŋ. Mã alaŋ anyeke, kagoonekin koca ineet gi ci gɛr bar kujuk ci ka kutuguzeya nɔɔgɔ o.” Ma ayɔɔt niigi Lat, ma uubunek karogi ka kooyoyit. ");
INSERT INTO mur_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Enico ɛlɛ udunta toonnyawa, ma agurak Lat ceez eecitɔ, ma anyook karogi. ");
INSERT INTO mur_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ma atooza niigi ɔl o aavtiz ceez tatoga e dook kɛbɛrɛ kiziti rubenɛ calaŋ aga ŋinti abilni karogi. Ma adun niigi. ");
INSERT INTO mur_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Enektek ni toonnyawa Lat nɛ, “Mã anyei ŋɛɛrugun ki bɛɛnyugun ki kavanɛ been atenok ci abaak kuture nico, viri nɔɔgɔ rɛɛna. ");
INSERT INTO mur_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Itoonanet Jooi ageeta ka kivita kilipta kutur nico, eeci gerzitin uneeŋ izi appe ɔrɔɔt zɛɛ makacin otobor Jooi.” ");
INSERT INTO mur_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ook ni Lat ole o arɔɔŋ kirikti bɛɛnyigin, ma akɔ anek nɛ, “Iyiikta ɛnyɛktɛ ŋina, eeci arɔɔŋ Jooi kuulal kutur nico.” Bar anyek niigi zɔɔz nico kizi bɔyɛn. ");
INSERT INTO mur_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Mazi ŋaan arire lɔɔci, omolmolanek toonnyawa Lat kiyiik. Anek niigi nɔɔnɔ nɛ, “Iyiik taman. Biti ŋaa unun been bɛɛnyugun ween ram e ɛnyɛktɛ ŋina, gɛrzɛ ŋaan adaaknu tedec ma alibe kuturi nici.” ");
INSERT INTO mur_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Mazi ŋaan miltiŋ Lat nɔkɔ, agamit toonnyawa nɔɔnɔ aziit ki ŋaa onin been bɛɛnyigin ween ram, ma avɔyi nɔɔgɔ zɛɛ ma aduŋni kutura, eeci awucnek niigi Jook. ");
INSERT INTO mur_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ma ŋinaante enek toonnyaiti codoi nɔɔgɔ nɛ, “Odokonyit! Má abuudenu gɔla. Odokonyit ɔɔtɔ biyɛnɛ ka calaŋ adaaŋnu.” ");
INSERT INTO mur_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bar abɛdɛkɛ Lat nɔɔgɔ anek nɛ, “Akɔm Manyigi. Má anyet kutuguza nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Inoko uyene itiritaŋu niiga aneeta laadun, ma ɛɛltawaŋu korok. Inoko zin biyɛn rɛɛnɛ ɔrɔɔt. Kaŋole karabɔŋ kadaai maŋaan kurum ŋinite. ");
INSERT INTO mur_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bar anycaŋ rak kook kuture ci miliny abil ŋaate neke ka kɛɛlyai daayiza. Ajɔn niini ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ma abɛdɛkɛ toonnyaiti nɔɔnɔ anek nɛ, “Abona. Kagama zɔɔz cun o. Alaŋ kuulal kutur nice. ");
INSERT INTO mur_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Vir zin taman. Kareyin rak zɛɛ ma akɔ arum ŋinite.” (Zin giye o awɛ Lat kutur nice kizi kidic, akatozek ŋinite zaara ci kazi Zowar.) ");
INSERT INTO mur_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Mazi akɔ aduŋna ii, urum Lat Zowar. ");
INSERT INTO mur_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ŋintimiliny nɔkɔ iitai Jooi tamma goo ci appe ɔrɔɔt, ma iinak Sodom been Gomora. ");
INSERT INTO mur_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ma adica goo nici ŋinite dook. Ma adaai ɔl o abaak ŋinaante dook kibeen kaal o ɛɛl ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bar gɔla mazi abuudi ŋaa o Lat, enico ɛlɛ otowɛ niini kizi kɔrtɔn ceen mɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ma iitene ci ano gɔn o ririwɔna itiŋa Ibrayim ook ŋaa baal azɔɔzɔnɛ ki Jook e. ");
INSERT INTO mur_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Mazi akɔ agɛlɛm Sodom kibeen Gomora been ŋɛwonok o libir nice dook, acin niini burɛt ci appe iŋaaz ŋinaante kizi dovol akɔ ki tammu kɛŋ. ");
INSERT INTO mur_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Zin iiteni ci baal uulali Jooi kuturyok nicoko o, aada niini Ibrayim, ma aara Lat o abaak ŋinaante bitaala calaŋ adaai niini gooye nico. ");
INSERT INTO mur_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Enico ɔtɔŋɔlɛ Lat looc ŋaati abaai kuture o kazi Zowar. Uluuk ni niini been bɛɛnyigin ween ram ɔɔtɔ biyɛnɛ, ma avɔ abaak bɔɔta ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ma iitene oman enek dole ceen abuu o ŋɔɔni ci miliny o nɛ, “Inoko baatina izi matuwoc. Maje ŋina akɔm eet ci ka kataŋguz ki naaga kibeen nɔɔnɔ kiyo ɔl loocowe dook o ka kanyayit dɔl. ");
INSERT INTO mur_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Inoko kanycek baatina nyaan ci abaayinɛ ka koromtɛ ki nɔɔnɔ ɛlɛ coma kanyak dɔl ci avadanet ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ma baaline nice anycek didi niigi baatineeŋ nyaan ci awot. Mazi akɔ abaaki niini, iiya bɛɛnyin ceen abuu o, ma oogin ki nɔɔnɔ. Maje Lat alaŋ niini aga aromɛ ki bɛɛnyin o, eeci abaaki ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ma iitene oman enek bodo dole ceen abuu o ŋɔɔni ci miliny o nɛ, “Kataŋguza ki baaba bilija. Inoko kanycek nɔɔnɔ kowot nyaan bodo baaline nico ka ataŋguz niina ki nɔɔnɔ ka kojokta naaga dook dɔl ci avadanet ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ma baaline nice anycek niigi baatin nyaan ci abaayinɛ bodo, ma aku oogin bɛɛnyin ci miliny o ki nɔɔnɔ calaŋ niini aga gi nico, eeci abaaki ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Anyaktɔ ni dɔlya ci Lat een ram noko ŋaatin ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ma arita dole ceen abuu o ŋɛɛrin, ma akanek zaar ci kazi Mowab. Iiya ni izi niini jijiti ɔl o kazi Mowab dook. ");
INSERT INTO mur_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Maje dole ci miliny o itira buk niini ŋɛɛrin, ma akanek nɔɔnɔ zaar ci kazi Bɛnaami. Iiya ni izi niini jijiti ɔl o inoko kazi nɛ Amonata. ");
INSERT INTO mur_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ŋintimiliny nɔkɔ uluuk Ibrayim ŋaa o kazi Mamra, ma iicak kidicilim akɔ ki ŋino kazi Negev, ma akɔ aal ŋaao aŋɛrɔn Kadec been Cur. Bodo ŋintimiliny nɔkɔ idicek ook abaak ŋaao kazi Gɛrar. ");
INSERT INTO mur_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ma ŋinaante enek niini ɔl nɛ, “Ŋaa ci kazi Sara noko ŋɔɔna gi.” Itoonek ni alaani o kazi Abimilek abal Gɛrar ɔl Sara kɔɔt kanyaaktak ɔl nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bar iitene oman baal eyelzak Jooi Abimilek ɛlɛ wunozyai, ma anek nɔɔnɔ nɛ, “Oowu niina ki daayiz, eeci ooyɛ ŋaa nico. Niini ŋaa ci eeto gi.” ");
INSERT INTO mur_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Maje Abimilek ŋaan koromtɛ ki Sara. Enek ni niini Jook nɛ, “Manyi Jook, akɔm gi ci gɛr kabaca. Má aruket aneet been ɔl cigan o kadaakta gaga. ");
INSERT INTO mur_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ibrayim niinilya azi nɛ, Ŋaa nici ŋɔɔni gi. Bodo buk ŋaa alya azi nɛ, Ibrayim gɔtɔni gi. Kagoon zin gi nico zinize ci abon giye o kazii naana ŋaatineeŋ.” ");
INSERT INTO mur_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Enek ni Jooi Abimilek nɛ, “Ŋɛdɛt kagayin agoon gi nico zinize ci abon o. Gi zin calaŋ kanyin ineet uumi ŋaa nico o nɛɛn, eeci alaŋ karooŋnyin ineet baca oŋec. ");
INSERT INTO mur_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Inoko zin miirɔi nɔɔnɔ kook eete onin, eeci ɛɛti cinɛ o nyakaŋan gi. Ŋaan aŋaryonekin niini ineet gɛrzɛ ŋaan adaai. Mazi alaŋ amiirɛnɛ, adaai koca niina been ɔl ugun dook.” ");
INSERT INTO mur_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ma ririwɔna ŋeertine co, otowa Abimilek ɔl ogin een inyaati dook. Mazi aku aduwak niini nɔɔgɔ zɔɔz nico, anyayit niigi ŋoliin ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Otowa ni Abimilek Ibrayim, ma aku ajin anek nɛ, “Gitaz ci agooneket noko? Gitaz ci gɛrzɛ kagoonekin naana ineet ka uulalan o? Agoonekan gi ci gɛr ci akɔm eet oma laadun ci utugu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Naa agoonekan gi nico naa?” ");
INSERT INTO mur_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ma abɛdɛkɛ Ibrayim Abimilek anek nɛ, “Kagoon nɔkɔ o, eeci kabaaban kizik akɔm ŋina ɔl ci aŋole Jook. Kaŋole zin karabɔŋ koca arukan niigi aneet kadaak ka kooti ŋaa can o. ");
INSERT INTO mur_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Maje zin didi niini ŋɔɔna ci baaba gi. Alaŋ een ŋɔɔna ci yaai. Kiriyɛ zin naana nɔɔnɔ kizi ŋaa can. ");
INSERT INTO mur_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mazi akɔ aaranan Jooi aneet ole o baaba olla kiiya kɔtɔɔ balala e, keneya naana nɔɔnɔ nɛ, Gi ci abon agoonekan ce. Loocowe ci karɛwɔn ki ɔl enek niina nɔɔgɔ nɛ, Keen ŋɔɔni gi.” ");
INSERT INTO mur_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Imiirɔi ni Abimilek Sara anyek Ibrayim, ma anyek buk niini nɔɔnɔ ɛɛza ki tiin been gabara. ");
INSERT INTO mur_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ma anek Abimilek Ibrayim nɛ, “Nici dook looc can. Inoko baak ŋaati olla arooŋ niina.” ");
INSERT INTO mur_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ma anek buk Abimilek Sara nɛ, “Kanyi gotonu ɛɛza ki tiin ci meelik ka kotoŋ niini gi o kagoonekin naana ineet, ka buk keyelizak ɔl o arumenu ki ineet dook akɔm niina gi ci gɛr agoon.” ");
INSERT INTO mur_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Aŋarowɔ ni Ibrayim ijin Jook ka kɛɛla Abimilek oŋece nico. Orogoz ni didi Jooi nɔɔnɔ. Ma buk anyek ŋaa onin ki ŋaai o gabara ogin een mirɔk kanyaktɔ labak. ");
INSERT INTO mur_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Eeci waanice onyook Jooi momɛt ci ŋaai o kɔrɔk o Abimilek dook giye ci akati Sara ceen ŋaa ci Ibrayim o. ");
INSERT INTO mur_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Amayuk ni Jooi Sara ebaal atɛrkɛdɛkɛ nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Anyawɔ ni niini, ma ookcak Ibrayim ŋɛɛrin iinyaye baal aduwak Jooi nɔɔnɔ e ɛlɛ. Mã aritai dole e, izi Ibrayim matuwoc ci anyata. ");
INSERT INTO mur_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ma akanek niini ŋɛɛrin nico zaar ci kazi Aizak. ");
INSERT INTO mur_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Mazi akɔ een Aizak iinya turge, ɛtɛɛt Ibrayim nɔɔnɔ kul ebaal aricanɛkɛ Jooi nɔɔnɔ kutugui e. ");
INSERT INTO mur_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Maje ma aritai Aizak e, izi Ibrayim waanice irkitowa eet tur. ");
INSERT INTO mur_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Atalɔ ni Sara ɔrɔɔt ɛlɛ, ma azi nɛ, “Inoko anyayan Jooi talniin ci kararnɛ. Buk ɔl o azii gi nico atalnɛ niigi kibeen aneet.” ");
INSERT INTO mur_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ma azi niini bodo nɛ, “Akɔm baale laadun eet ci abaaban gi ci azi nɛ, Anyak Sara dole katin ŋaati izɔi matuwoc. Bar inoko zin kanyawa naana dole matuwoczete can noko.” ");
INSERT INTO mur_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ma iroktai dole zɛɛ ma adikir. Mazi atɛɛt niigi nɔɔnɔ kezta, utugu Ibrayim kɔnyit ci doleco ci appe ɔrɔɔt iitene nice. ");
INSERT INTO mur_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ma iitene oman icinun Sara Ismayil o arita Ibrayim ŋaati Egar ween Masiren amomoz Aizak. ");
INSERT INTO mur_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Enek ni Sara Ibrayim nɛ, “Tɔɔk ŋaa ceen miroi noko kibeen ŋɛɛrin kɔtɔɔzɔ. Alaŋ ka kozolit ŋɛɛrti ŋaa nico kɔrɔk kibeen ŋɛɛran Aizak.” ");
INSERT INTO mur_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ma avir Ibrayim ziniz giye nico ɔrɔɔt ɛlɛ, eeci Ismayil buk ŋɛɛrin gi. ");
INSERT INTO mur_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bar anek Jooi Ibrayim nɛ, “Má anyi ziniz kitirany zooze ci Ismayil been Egar gaga. Tugu eci aduwakin Sara o, eeci katin niina anyei dɔl ci dolenu terkediinte onan ŋaaten Aizak. ");
INSERT INTO mur_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ŋaan buk katin kanyi Ismayil dɔl ci dolenu kiziti bor ci appe, eeci een niini dole cun buk.” ");
INSERT INTO mur_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ma iitene co ŋeere ririwɔna anyaa Ibrayim dayiin ki buru ci maamu. Ma aku anyek Egar, ma itoon nɔɔnɔ ki ŋɛɛrin kɔtɔɔzɔ. Ma awɔ Egar zɛɛ makacin ook elektu balale o kazi Biirsaba. ");
INSERT INTO mur_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mazi akɔ adicai maama burwa, uruk dole kɔr ɔrɔɔt ɛlɛ. Otoŋek ni niini dole gi ceen lugurgoc. ");
INSERT INTO mur_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ma akɔ adɛyai niini ŋaaman, eeci anek niini ɛlɛ maany nɛ, “Alaŋ karooŋ kicin dole can noko ŋaati adaaŋni.” Ma akɔ alu ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Iziik ni Jooi dole luwa, ma awo toonnyaiti ci Joowo tamma Egar, ma anek nɛ, “Alu naa? Má anyei ŋoliin gaga. Iziiwun Jooi luwa ci doleco o ŋaa ona ooŋne e. ");
INSERT INTO mur_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Inoko tiŋa jena. Bitɔ dɔŋa dole ka zoozek kajawɔ, eeci katin kamayuwi naana nɔɔnɔ, ma kanyi dɔl ci dɔl cigin kizi bor ci appe.” ");
INSERT INTO mur_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ɔkɔl ni Jooi Egar kɛbɛrɛ, ma acin niini ṯuuk ci anyak maam. Ook ni ibitiz buru, ma anyaak dole. ");
INSERT INTO mur_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ozooti ni Jooi dole, ma iroktai zɛɛ ma adikir. Ma abaak niini balale o kazi Paran. Ma ŋinaante izi niini eet ceen ceeloi ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ma ojowak yaatine nɔɔnɔ ŋinaante dole ceen Masiren, ma arɔcak nɔɔnɔ kizi ŋaa cin. ");
INSERT INTO mur_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Maje iinyaye niceke abal Abimilek looc nice, aje Vikol alaan ci takirnyawu. Ivitak ni niigi dook ramantiya Ibrayim, ma aku anek Abimilek Ibrayim nɛ, “Kacinin naana ineet amayukin Jooi kaale o agoon dook. ");
INSERT INTO mur_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Inoko terkedeyan zaare o Joowo baayiz ci kabaayi naana kibeen ineet yaak calaŋ alabanan aneet, karabɔŋ een dɔl cigan, karabɔŋ een dɔl ci dɔl cigan. Tuguweyet ineeta ki ɔl cigan o kaal ci abon, kiyo buk kagoonekin naana ineet kaal ci abon o.” ");
INSERT INTO mur_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ma anek Ibrayim nɔɔnɔ nɛ, “Abon ɔrɔɔt. Kagama zɔɔz nico.” ");
INSERT INTO mur_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Oobek ni Ibrayim Abimilek zɔɔz ci ṯuuk o aama gabara o Abimilek gabara ogin dɔyiza, ma anyek kizi cineeŋ doon. ");
INSERT INTO mur_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ma anek Abimilek Ibrayim nɛ, “Alaŋ kaga eet ci agɔɔn gi nico o. Ŋaan niina duwayan, ma ŋaan kiziik laadun zɛɛ been nɛɛn ci kaziiknɛ noko.” ");
INSERT INTO mur_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Anyaa ni Ibrayim ɛɛz been taŋ, ma aku anyek Abimilek. Utuguzɔ ni niigi dook ramantiya ganɔn ci ka kabaakti yaak. ");
INSERT INTO mur_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ma aŋɛra bodo Ibrayim nyɔɔ ci ŋai torgɛrɛm ɛɛzaye ogin. ");
INSERT INTO mur_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ma ajin Abimilek nɔɔnɔ anek nɛ, “Aŋɛra nyɔɔ nicoko naa?” ");
INSERT INTO mur_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ma abɛdɛkɛ Ibrayim nɔɔnɔ anek nɛ, “Biti nyɔɔ ceen torgɛrɛm noko kizi cugun ka gawan keen didi eet ci kadawa ṯuuk nico o nɛɛn naana.” ");
INSERT INTO mur_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Akatozek ni ŋinite zaara ci kazi Biirsaba. ");
INSERT INTO mur_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Mazi avɔ adica niigi zɔɔz o akati ganɔn ŋaati kazi Biirsaba neke, imiirtozek Abimilek ki Vikol looc uneeŋ kazi Viliztiya. ");
INSERT INTO mur_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Oḏowa ni Ibrayim kɛɛt ceen motoŋtoc Biirsaba, ma adiŋdiŋan Jook o abil kodot ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ma abaak niini looce ci kazi Viliztiya neke ŋinti wun ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ma iinyaye ogɛn icina Jooi tuwɛn o Ibrayim. Awo Jooi nɔɔnɔ, ma anek nɛ, “Aavɛ ŋaaḏaŋ Ibrayim?” Ma abɛdɛkɛ Ibrayim nɔɔnɔ anek nɛ, “Aneet ce.” ");
INSERT INTO mur_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ma anek Jooi nɔɔnɔ nɛ, “Biti ŋɛɛrun ci kazi Aizak areez ɔrɔɔt noko. Biti looce o kazi Moraya ka bitɔ ruweyan nɔɔnɔ kizi todoyoi biye ci ŋaan kakɔ kayelekin ineet ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ma ŋeere ririwɔna iitene oman uduula Ibrayim areema ka kook kutuguwi todoyoi, ma arek kaal zigir. Ma akɔyi Aizak kibeen gabara ceen ram, ma avɔ ŋaa baal aduwak Jooi nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ma awɔ niigi gɔla iinya iiyu. Mazi akɔ acin Ibrayim ŋinite rɛɛna kidicilim, ");
INSERT INTO mur_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","enek niini gabara ogin nɛ, “Aavtiz ŋina ebeyit zigir. Kavɔya naana ki dole ŋinaante ka koota kidiŋdiŋanta Jook. Ŋaan kabadana.” ");
INSERT INTO mur_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Anyek ni niini ŋɛɛrin kanyak areema o ka kook kutuguwi todoyoi. Aje niinilya anyak kabaz ki kɛɛt ci gooyo. Ma ɔrkɔr niini ki ŋɛɛrin avɔ biyɛnɛ. ");
INSERT INTO mur_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Ijin ni Aizak baatin enek nɛ, “Baaba, inoko kanyak areema ki goo ci ka kɔɔt kutuguzi todoyoi. Inoo zin ɛɛz ci ka kɔɔtɔ kutuguz kizi todoyoi o?” ");
INSERT INTO mur_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abɛdɛkɛ baatinɛ nɔɔnɔ anek nɛ, “Dole onan, ŋaan akɔ anyet Jooi niinilya azɛt codoi ŋinaante.” Ma awɔ niigi dook ramantiya adicek avɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Mazi avɔ arum niini ŋin baal aduwak Jooi Ibrayim e, utuguwa niini ŋinti taabinto, ma ataadek areema tadena. Ma acap ŋɛɛrin, ma akɔ ataadek buk areema taden. ");
INSERT INTO mur_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Odoma ni kabaz ka kɛtɛɛdi ŋɛɛrin alɛm. ");
INSERT INTO mur_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Taman nɔkɔ otowɛ Jooi tamma azi nɛ, “Bil di! Bil di! Má arui dole kadaak. ");
INSERT INTO mur_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Inoko kagawin aŋolinan didi niina aneet, eeci alaŋ ajurakan ŋɛɛrun.” ");
INSERT INTO mur_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Mazi adɔŋa Ibrayim ɔɔ, acin mirkic ci agam karada oto nɔɔnɔ bawuca. Ook ni adoma mirkic nico, ma aku atɛɛt alɛm, ma ataadek areema tadena, ma akanek goo ka kizi todoyoi ci arigiz ŋinti ŋɛɛrin o ka waan kuruk kadaak e. ");
INSERT INTO mur_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Akatek ni Ibrayim ŋinite zaar ci kazi nɛ Ŋaan Anyan Jooi. Been nuun inoko o ŋaan awo ɔl bɛ nice zaar ci kazi nɛ Ŋaan Anyan Jooi. ");
INSERT INTO mur_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Otowo ni Jooi Ibrayim bodo, ma anek nɛ, ");
INSERT INTO mur_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Inoko katerkedekin naana Manyi Jooi zɔɔz ci ka kamayukin ineet giye o alaŋ ajurakan ŋɛɛrun. ");
INSERT INTO mur_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ŋaan kamayukin ineet, ma ŋaan kazaaci dɔl ci dɔl cugun kizi mɛɛlɛ kotobtɔ ki monyony, karabɔŋ atobɔ ki kazac. Katin dɔlya ci dɔl cugun amɔk modɛn, ma ɔɔra kaalyan. ");
INSERT INTO mur_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Modɛna dook ajowa katin mayuwɛnɛt dolene ci dɔl cugun. Kagoon nɔkɔ o, eeci azii niina zɔɔz onan.” ");
INSERT INTO mur_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ivitak ni Ibrayim ki Aizak gabara ogin, ma amiiri niigi dook avɔ ɔlɔ Biirsaba. ");
INSERT INTO mur_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ma iitene oman iziik Ibrayim itira gɔtɔnnya o kazi Nayor lɔgɔz cigin ŋaawe onin kazi Milka. ");
INSERT INTO mur_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Aritai Uza ɔɔwa. Ma anowa nɔɔnɔ Buz ki Kemuwel o iiya izi baati Aram ");
INSERT INTO mur_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ki Kesed ki Aazo ki Pildac ki Jidav been Bezuwel. ");
INSERT INTO mur_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bezuwel iiya izi baati Rebeka. ");
INSERT INTO mur_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ma buk arita Nayor ŋaawe cin aavtiz kazi Reuma lɔgɔz wec kazi zaar cigeec nɛ Teba ki Gaam ki Taac been Maaka. ");
INSERT INTO mur_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Mazi akɔ een Sara irkitowa eet tɔrkɔnɔm ki tiin torgɛrɛm (127), adaak niini ŋaao kazi Ebiron looce o kazi Kanan. Ma iinon Ibrayim daayiz ci Sara o, ma aluwek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ma vurta itiŋa niini ŋaati ona aluwi noko, ma akɔ ole o kazi Ititaz raa, ma akɔ anek nɔɔgɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Inoko kabaai naana ŋinaanto keen modɛn ci rɛŋ. Akɔmnan tɔdɔ cigan ŋina. Karooŋnyuŋ zin ataaleyaŋ tɔdɔwaye cugooc noko ŋintimiliny ka kadawi ŋaa can adaai noko.” ");
INSERT INTO mur_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Abɛdɛkɛ ɔl ci Ititaz noko Ibrayim anek nɛ, ");
INSERT INTO mur_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Manygɔn, ziiyet di. Kacinin naaga ineet een eet ci adiŋdiŋ ɔrɔɔt ŋaatinaaŋ. Da ŋaa cun o boote ci olla ajowa niina abon bootwane cigaacak o. Akɔm ŋaatinaaŋ dook eet ci ajurakin ineet bɔɔt ŋaati adawɛ ŋaa cun o.” ");
INSERT INTO mur_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Itiŋa ni Ibrayim, ma aloca ɔɔ nɔɔgɔ kɔrgɛna, ");
INSERT INTO mur_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","9","ma anek nɛ, “Mã iziikteyaŋ niiga ka kada ŋaa can o ŋina o, ijinteyaŋ Evron ween ŋɛɛrti Zowar ka kataaleyan bɔɔt o abil mane onin ŋaao kazi Makvila. Ijinteyan nɔɔnɔ ka kataaleyan ŋinite guruce ci aganɔ, ka gɔɔn kizi ŋintan dawiinto.” ");
INSERT INTO mur_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","11","Aje Evron aavi buk tɔ ŋinaante. Ma abɛdɛkɛ niini Ibrayim ɔl dook kɔrgɛna anek nɛ, “Manygɔn, ziiyan di. Inoko kanyin ineet bɔɔt nice kibeen mana buk kɔkɔm guruc ci aruwekan. Kanyin ineet ɔl dook kɔrgɛna ŋina ka dawi ŋaa cun o.” ");
INSERT INTO mur_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Itiŋa ni Ibrayim ɔl kɔrgɛna, ma aloca ɔɔ. ");
INSERT INTO mur_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ma anek Evron nɛ, “Inoko karuwekin guruc ci mano. Gama ŋaatan guruc nicoko ka kada ŋaa can o ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Abɛdɛkɛ Evron nɔɔnɔ anek nɛ, ");
INSERT INTO mur_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Manygɔn, adak mana nici guruc ceen eet tur lak wec (400). Zin giye ci akanin ineet guruca nici ŋaatan kaal ci labak. Inoko bitɔ da ŋaa cuno ŋinaante labak.” ");
INSERT INTO mur_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Agama ni Ibrayim zɔɔz ci Evron o, ma akɛɛbak nɔɔnɔ guruc ci ona aduwa niini eet eet tur lak wec (400) o, ma anyek nɔɔnɔ ɔl dook kɔrgɛna ŋina. ");
INSERT INTO mur_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Gɔl zin ci ajowan Ibrayim mana ci Evron o nɛɛn. Abil mana nici ŋaao kazi Makvila ajɔŋɔz ŋin o kazi Mamra. Zin kaala o anyak mana nica dook izi ci Ibrayim. ");
INSERT INTO mur_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Agawozek zin ŋinita Ibrayim ole o kazi Ititaz dook. ");
INSERT INTO mur_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Adawun ni Ibrayim ŋaa onin kazi Sara boote o abil mane nice looce o kazi Kanan. ");
INSERT INTO mur_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Zin mana baal een mana ci ɔl o kazi Ititaz e, ki bɔɔt o abil mana izi ci Ibrayim ka gɔɔn kadayɔi ɔl oginɛ. ");
INSERT INTO mur_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Maje waanice Ibrayim izi matuwoc, ma amayun Jooi nɔɔnɔ laadun kaale o agɔɔn dook. ");
INSERT INTO mur_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mazi akɔ arɔɔŋ Aizak rociin, otowa Ibrayim gabaren onin adikir abal kaal ogin dook. Ma anek nɔɔnɔ nɛ, “Inoko karooŋnyin ineet tugu gi ci kaduwakin ce. ");
INSERT INTO mur_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","4","Abona amiire akɔ looce o baaba ka bitɔ jowak ŋɛɛran Aizak ŋaa cin atenowe ogan ŋinaante. Alaŋ karooŋ cinak nɔɔnɔ ŋaa cin dolene ci Kanan o ŋina. Didi karooŋnyin ineet tugu gi nico tammalya.” ");
INSERT INTO mur_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ma abɛdɛkɛ gabarɛnti nɔɔnɔ anek nɛ, “Mã kajowai ŋɛɛrun ŋaa ŋinaante, ma ajura ŋaati akunakɛ Kanan ŋina, kutugu ku? Kiiya kitoon ŋɛɛrun kook kabaak ŋinaante?” ");
INSERT INTO mur_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abɛdɛkɛ Ibrayim nɔɔnɔ anek nɛ, “Akɔm! Alaŋ karooŋnyin tugu nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Jook o tammu tadenu nɛɛn o aduŋnanan aneet bitaala ole o baaba been looce o atenok ogan. Ma aterkedekan niini aneet gi ci azi nɛ, Ŋaan kanyi dɔl ci dɔl cugun looc nico kizi cineeŋ. Zin zooze nico ŋaan itoonakin Jooi ineet toonnyai onin tamma ka kotonayin ineet nɔkɔ zɛɛ ma akɔ anyaai ŋɛɛran ŋaa cin ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mã ajura dole ci ajowa o, akɔmnin ineet gi cun. Maje naana alaŋ karooŋ toonek ŋɛɛran ŋinite.” ");
INSERT INTO mur_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Agama ni gabarɛnti zɔɔz ci aduwak Ibrayim nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ma akɔyi niini nyakalɛt ceen amɔtɔ, ma akɔyi buk niini kaal ci abon kaale o Ibrayim abon dook. Itiŋgazɔ ni niini kibeen gabara oogi ɔɔtɔ looce o kazi Mesopatamiya, ma avɔ zɛɛ been kutur o abaai Nayor. ");
INSERT INTO mur_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Mazi avɔ arum niigi kutur nice, itikte, ma anyek gabarɛnti nici nyakalɛt kataŋguzɔ loota ŋaati ajɔŋɔz ṯuuk ci anyak maamu ŋinaante. Aje lɔɔci izi yoman. Izi ŋino gɔɔn ka kivita kotogoci ŋaai maam ṯuuwa. ");
INSERT INTO mur_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Aŋarowɔ ni niini izi nɛ, “Jook o alaan onan Ibrayim, ɛɛlawan da. Nyan gi ci karooŋ o waanico. Yelizak bonat unun alaan onan Ibrayim. ");
INSERT INTO mur_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Cinan aneet ŋaati kaavɛ ṯuuwe nico o. Mã anyak tedec dɔl ci avu agɔc maam ŋina, ");
INSERT INTO mur_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kajin tedec codoi ŋaatineeŋ kanei nɛ, Nyan da maam ci kawudi. Mazi anekan nɛ, Orɛ maam kodɛ, ŋaan buk kagɔcai nyakalɛt cugun o maam, anyek koca nɔɔnɔ kizi dole ci aŋɛrai niina Aizak ka kizi ŋaa cin nɛɛn. Mã agooni gi nici kibil nɔkɔ, kagawin koca naana didi eyelizayu niina bonat unun alaan onan Ibrayim.” ");
INSERT INTO mur_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mazi ŋaan aŋaryɛ niini nɔkɔ, iiya dole ceen kabarzec kazi Rebeka iilaya iju ci maamu ɔɔwa. Niini tinati Bezuwel ween ŋɛɛrti Nayor ki ŋaa onin kazi Milka. Nayor niini gɔtɔni Ibrayim. ");
INSERT INTO mur_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Dole nici niini kabarzec ci alina ɔrɔɔt ɛlɛ, ma ŋaan aavi baala. Iiya ni ook niini ṯuuwa, ma abitiz iju. ");
INSERT INTO mur_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Odokonyozek ni gabarɛnti nici nɔɔnɔ, ma akɔ anek nɛ, “Nyan da maam ci kawudi.” ");
INSERT INTO mur_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ma anek dole nɔɔnɔ nɛ, “Ija, kodɛ.” Ma adɔŋa maam, ma agamek nɔɔnɔ kowodɛ. ");
INSERT INTO mur_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Mazi akɔ alal, enek dole nɔɔnɔ nɛ, “Nyan kanyaak buk nyakalɛt cugun o maam ka kuwude.” ");
INSERT INTO mur_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ma aḏuutek maam abala, ma adɔkɔny akɔ anyaa maam oogi bodo, ma awodɛ nyakalɛta dook zɛɛ ma alal. ");
INSERT INTO mur_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Maje gabarɛntɛ nici olla aŋaamnek niini nɔɔnɔ liŋliŋonte ci agɔɔn o arɔɔŋ ka kaga mã een dole ci aŋɛrak Jooi nɔɔnɔ o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Mazi akɔ odotiz Rebeka ŋaati awotzi nyakalɛt, aara gabarɛnti lawonyawoc ceen warki, ma arikɛ dole oŋec. Ma aborcɛkɛ bodo nɔɔnɔ warki ci appintik een ram azɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ma ajin niini nɔɔnɔ anek nɛ, “Een dole ci ŋɛnɛ? Karooŋ kook kataŋu baalin ole cunooŋ o. Anyak ŋinti kɔɔŋɛ ŋinaante tɔ?” ");
INSERT INTO mur_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Keen tinati Bezuwel ween ŋɛɛrti Nayor been Milka. ");
INSERT INTO mur_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kanyaka artɛ ci adɔi ka kataŋguzɛ nyakalɛta been buk ci colai adak niigi. Ma buk anyak ŋinti ka ataŋguzɛ niiga.” ");
INSERT INTO mur_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Oloca ni gabarɛnti ɔɔ, ma adiŋdiŋan Jook. ");
INSERT INTO mur_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Azi nɛ, “Kanaatin ineet Jook o alaan onan Ibrayim, eeci azoonɛ zɔɔz unun aterkedu niina kibeen alaan onan. Ma ayitanan buk aneet zɛɛ ma didi arumnyan atenok o Ibrayim.” ");
INSERT INTO mur_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ook ni odokonyozek Rebeka ceez o yaatin, ma akɔ aduwak nɔɔnɔ zoozok o arumonɛ niini ki gabaren e dook. ");
INSERT INTO mur_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Maje Rebeka anyak gɔtɔni ci kazi Leban. ");
INSERT INTO mur_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mazi acin Leban warki ci anyak ŋɔɔnnya oŋeca o been ci anyak azeene o, ma azii niini buk zɔɔz ci tɛ aduwak ɛɛti nici ŋɔɔni o ŋaati aduwakɛ ŋɔɔnnya yaatin o, itiŋa niini ook gabarente o Ibrayim ŋaa ona aali nyakalɛt ṯuuwa e. ");
INSERT INTO mur_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ma akɔ anek nɔɔnɔ nɛ, “Ija, kɔɔtɔ ɔlɔ. Kacinin ineet een inoko eet ci amayukin Jooi. Aavi bitaala ŋina naa? Kanyei ŋinti ka tikɔi ole can e, ma anyak buk ŋinti ka kaavtiyɛ nyakalɛta.” ");
INSERT INTO mur_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Anyaak ni Leban gabaren kɔrɔk onin, ma aku aara kaal dook nyakalɛtɛ, ma aavetek nyakalɛt artɛ ci adɔi ka kataŋguzei been artɛ ci colai ka kadayit, ma anyaa maam ci ka kotoonyci gabarɛnti been ɔl ogin ɔrkɔr zɔɔ. ");
INSERT INTO mur_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ma anyaak niigi nɔɔgɔ dayiin. Mazi avu dayiin, anek gabarɛnti nɔɔgɔ nɛ, “Alaŋ rak kadake zɛɛ ma kaduwakuŋ igeet gi ci kakunɛ o.” Enek ni Leban nɔɔnɔ nɛ, “Duwa labak.” ");
INSERT INTO mur_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ma anek gabarɛnti nɔɔgɔ nɛ, “Keen naana gabaren ci Ibrayim ween gɔtɔni Nayor. ");
INSERT INTO mur_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Amayuwun Jooi nɔɔnɔ ɔrɔɔt ɛlɛ, ma anyek nɔɔnɔ kabalɔ kanyak ɛɛza ki tiin ki zigire ki nyakalɛt ki warki been gabara ci mac ki ci ŋai. ");
INSERT INTO mur_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Itirak nɔɔnɔ Sara ween ŋaa onin ŋɛɛrin ŋaati izɔi matuwoc. Ma anyewun niini ŋɛɛrin nico kaal ogin anyak ɔlɔ dook. ");
INSERT INTO mur_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Aricanekan zin alaani onanɛ aneeta anekan nɛ, Má acinai ŋɛɛran ŋaa cin modene ci Kanan karomena o. ");
INSERT INTO mur_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Bitɔ ole o baaba een bor onan ka bitɔ cinak ŋɛɛran ŋaa cin ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ma kanei naana nɔɔnɔ nɛ, Mã ajura dole ŋaati kɔrkɔrana, kutugu ku? ");
INSERT INTO mur_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Abɛdɛkan niini aneet anekan nɛ, Jooi o kazoonɛ naana zɔɔz onin ŋaan itoonakin ineet toonnyai ci orkoryu ki ineet ka kitiritin zɛɛ ma akɔ ajowai ŋɛɛran ŋaa ole ogan een bor o baaba ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mã akɔ zɛɛ been bor onan, yo nuun ajurakin niigi ineet dole calaŋ anyaa, ɔkɔmawin koca ineet gi cun kina. ");
INSERT INTO mur_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Mazi ona kaku karum ṯuuk nico waanico ŋina o, kiiya kijina Jook kanei nɛ, Manyi ween Jook o Ibrayim, tiritan. Nyan gi o karooŋ keronnye nico. ");
INSERT INTO mur_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Inoko acinan niina aneet kabil ṯuuk nico otoga ŋina. Zin mã aku dole ceen kabarzec ka kiiya kɔtɔgɔcɔ ṯuuwa ŋina, kanei tedec naana nɔɔnɔ nɛ, Nyan maam ci kawudi. ");
INSERT INTO mur_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Mazi agama niini, ma anyan maam kowodɛ, ma anyek buk nyakalɛt cigan o maam kuwude, izi koca niini ŋaa ci acinai niina ŋɛɛrti Ibrayim nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mazi ŋaan kaŋaryɛ nɔkɔ, iiya Rebeka anyaa iju ɔɔwa, ma aku akɔ ṯuuwa ka kook kɔtɔgɔcɔ. Mazi kanei naana nɔɔnɔ nɛ, Nyan da maam ci kawudi, ");
INSERT INTO mur_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ɔdɔŋa didi niini maam, ma agamekan anekan nɛ, Orɛ, kodɛ. Ŋaan buk kanyaai nyakalɛt cugun o maam ka kuwude. Kowodɛ ni naana, ma awodoz niini nyakalɛt cigan o buk. ");
INSERT INTO mur_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kijina ni naana nɔɔnɔ keneya nɛ, Baatun ŋɛnɛ? Ma abɛdɛkan niini anekan nɛ, Keen tinati Bezuwel ween ŋɛɛrti Nayor ki Milka. Mazi kakɔ kazii gi nico, karikɛ nɔɔnɔ lawonyawoc ceen warki oŋec, ma kaborcɛkɛ ci appintik een ram azɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Koloca ni ɔɔ kidiŋdiŋana Jook o alaan onan Ibrayim giye o ayelzekan niini aneet gɔl zɛɛ ma kaku karum bor onin, ma kaku kajowai nɔɔnɔ tinati ŋɛɛrti gɔtɔnɔn ka kizi ŋaa ci ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Inoko zin mã agamanu zɔɔz nico, ma arooŋnyu utuguzek alaan onan Ibrayim gi ci abon, uduktayaŋ. Mã alaŋ agamanu, uduktayaŋ ka kaga naana gi ci kagoon.” ");
INSERT INTO mur_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ɛbɛdɛkɛ ni Leban been Bezuwel nɔɔnɔ enektek nɛ, “Zɔɔz nici aku Joowa. Akɔm naaga gi ci ka kuduktawa. ");
INSERT INTO mur_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka ceeni. Biti nɔɔnɔ ka kook kizi ŋaa ci ŋɛɛrti alaan cun o, eeci aduwan Jooi o.” ");
INSERT INTO mur_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Mazi azii gabarɛnti ci Ibrayim noko zɔɔz nico, oloca ɔɔ, ma adiŋdiŋan Jook. ");
INSERT INTO mur_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Aara ni niini rumanɛ ci alina ki nyaziya been marakcak ceen warki, ma anyek dook Rebeka. Ma anyek buk niini gɔtɔni Rebeka been yaatin kaal ci ataalyai guruce ci meelik ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Adaktɔ ni gabarɛnti ci Ibrayim noko been ɔl ogin ɔrkɔra. Ma oogin baalin ŋinaante. Mazi acinɛ niigi ŋeere, izi gabarɛnti nɛ, “Itoonteyaŋ gɔl kimiire kook alaane onan.” ");
INSERT INTO mur_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bar gɔtɔni Rebeka been yaatin azi nɛ, “Akɔm! Alaŋ awoyu. Karooŋnya rak koromtewa ki dole ɔlɔ ŋina iinya amɔtɔ. Enice ŋaan awoyu.” ");
INSERT INTO mur_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bar anek niini nɔɔgɔ nɛ, “Má alamnyetu gaga. Ma anyewun Jooi keroni can o kobona o, anycaŋ kimiire taman kook alaane onan.” ");
INSERT INTO mur_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Nyet kutuyawa dole ka kijinta nɔɔnɔ ɛlɛ kuduwa gi cin.” ");
INSERT INTO mur_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Utuya ni niigi Rebeka, ma avu ajin anek nɛ, “Arooŋ niina ɔtɔɔz been eet nico inoko?” Abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Ii, kawoya labak.” ");
INSERT INTO mur_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Anycek ni niigi Rebeka been ŋaa baal gɔɔn agam nɔɔnɔ kidikzɛta e ka korkorit ki nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ma amayuk niigi Rebeka anek nɛ, “Tɔ yaak. Bitɔ tira dɔl ci meelik gɛr. Ma abon amɔk katin dɔlya ci dɔl cugun modɛn.” ");
INSERT INTO mur_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Acabtɔ ni Rebeka ki laŋotin, ma atɔɔt nyakalɛt, ma awɔ. ");
INSERT INTO mur_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aje Aizak iinyaye niceke iiya abaak looce o kazi Kanan libire ci akɔ ki tɛnɛt e ajɔŋɔz ṯuuk o kazi Acinan Jooi Aneet. ");
INSERT INTO mur_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ma iitene oman yomana mazi akɔ awɔ olla niini tuuwa ŋaati vɔɔr, acin nyakalɛt ci avu, ma akɔ arumek niini nɔɔgɔ gɔl. ");
INSERT INTO mur_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Mazi akɔ acin Rebeka Aizak, uduna niini nyakala. ");
INSERT INTO mur_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ma ajin gabaren ci Ibrayim o anek nɛ, “Eet ci ŋɛnɛ ci awoya ŋaati vɔɔr aku arumeket gɔl o?” Anek niini nɔɔnɔ nɛ, “Eet cun o nɛɛn nica.” Odoma ni niini rum, ma abuŋi ɔɔ. ");
INSERT INTO mur_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Mazi aku Aizak, uduwak gabarɛnti nɔɔnɔ kaal o agooni dook. ");
INSERT INTO mur_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ooyi ni Aizak ŋaa cin o ceeze o yaatin Sara. Arɛɛz Aizak Rebeka ɔrɔɔt ɛlɛ. Ɛtɛɛdjai ni niini inoniinte o akoloni yaatin. ");
INSERT INTO mur_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ɔrɔca ni bodo Ibrayim ŋaa oma ci kazi zaar nɛ Ketura. ");
INSERT INTO mur_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ma aritak ŋaa nici nɔɔnɔ lɔgɔz ci kazi zaar cigeec nɛ Zimran ki Jokcan ki Medan ki Midiyan ki Acbak been Cuwa. ");
INSERT INTO mur_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iiya Jokcan izi baati Ceba been Dedan. Dɔl ci dɔl o Dedan nɛɛn o kazi Acurim kibeen Letucim been Leumim. ");
INSERT INTO mur_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ŋɛɛrigi Midiyan nɛɛn o kazi zaar nɛ Eva ki Ivar ki Aanok ki Abidi been Eldaa. Nicigi dook dɔl ci dɔl o Ketura. ");
INSERT INTO mur_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Anyek Ibrayim kaal ogin anyak dook Aizak. ");
INSERT INTO mur_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Maje waanice maŋaan arogi niini e anyek buk kaal oogi ŋɛɛrigin o arita ŋaane ogin aavtiz. Ma anyek niini ŋɛɛrigin ci arita ŋaane cigin aavtiz o kuluugit kɔɔt ki jen ka kedeyɔ ki ŋɛɛrin Aizak. ");
INSERT INTO mur_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Inoko Ibrayim izi matuwoc ɔrɔɔt ɛlɛ zɛɛ ma apirna niini ŋaati izɔi irkitowa eet turge kamɔtɔ ki tiin tur (175). ");
INSERT INTO mur_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ma ada nɔɔnɔ ŋɛɛriginɛ Aizak been Ismayil boote o ŋino kazi Makvila o abil mane o ajɔŋɔz Mamra libire ci jenu e. ");
INSERT INTO mur_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nici ŋin baal ataala Ibrayim ŋaati Evron ween ŋɛɛrti Zowar ween borit o ɔl o kazi Ititaz e nɛɛn. Zin Ibrayim ki Sara ween ŋaa onin adaye niigi dook ramantiya ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ma vurte o adaayi Ibrayim, amayuwun Jooi ŋɛɛrin Aizak. Maje iinyaye niceke abaak niini ṯuuwe o kazi Laroi. Kazi kɛŋ ci zaar nicoko nɛ Acinan Jooi Aneet. ");
INSERT INTO mur_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ceegi dɔl ci dɔl o Ismayil ween ŋɛɛrti Ibrayim o arita niini ŋaati Egar ween Masiren baal aliŋliŋonek Sara kizi gabaren e. ");
INSERT INTO mur_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Iiya itira Ismayil ŋɛɛrigin ci kazi zaar cigeec nɛ Nebat ween abuu, ma ano Kedar ki Adbel ki Mibsam ");
INSERT INTO mur_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ki Micma ki Duma ki Maza ");
INSERT INTO mur_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ki Adad ki Tema ki Jetur ki Navic been Kedema. ");
INSERT INTO mur_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nɔɔgɔ zin nɛɛn o ivita iziti modɛn ween amɔtɔ ram, ma akanonek zaara ugeec vitɛn ci abaai niigi o dook. ");
INSERT INTO mur_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Mazi akɔ een Ismayil irkitowa eet tɔrkɔnɔm kamɔtɔ ki tiin torgɛrɛm (137), adaawun niini. ");
INSERT INTO mur_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ma abaak dɔlya ci dɔl ci Ismayil o ŋaao aŋɛr Aavila been Cur. Ŋinti abaai niigi o akanai ŋaao ajɔŋɔz Masir, ma aku akɔ ki Asiriya. Adɛyai niigi vitɛnane o abaai dɔl o Aizak. ");
INSERT INTO mur_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ceeni zɔɔz ci akati ŋɛɛrti Ibrayim o kazi Aizak. ");
INSERT INTO mur_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Mazi akɔ een Aizak irkitowa eet ram (40), ɔrɔca niini ŋɔɔni Leban o kazi Rebeka ween tinati Bezuwel o looc o kazi Aram. ");
INSERT INTO mur_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bar ɔtɔɔ Rebeka koliin, ma giye nico aŋarowɔ Aizak ɔrɔɔt ɛlɛ ajin Jook ŋaaten Rebeka ceen ŋaa cin o. Iziik ni Jooi ŋaryiin cin o, makacin anyawɔ Rebeka. ");
INSERT INTO mur_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Anyak niini codɛ, ma amɔɔt codɛna nici nɔɔnɔ kɛŋa ɔrɔɔt ɛlɛ. Izi ni niini nɛ, “Gitaz ci agoononekan noko.” Ma akɔ ajin Jook giye ci amɔɔni dɔlya kɛŋa ɔrɔɔt noko. ");
INSERT INTO mur_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Enek ni Jooi nɔɔnɔ nɛ, “Anyei niina boryok ram kɛŋa. Tiŋeere ma ookca niina nɔɔgɔ, mazi avɔ adikir, aŋɛrɔ niigi, ma ayɔwɔ. Codoi ŋaatineeŋ adɔi ŋaati gɔnɔn, bar abuuwi een katin niini tutur.” ");
INSERT INTO mur_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Mazi akɔ ookcai Rebeka ookca codɛ ceen lɔgɔz een ram. ");
INSERT INTO mur_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Adoma ceen abuu o meerik ɔrɔɔt, ma alɔ ɛlɛ cinɛ o ɔrɔɔt. Ma akanek niigi nɔɔnɔ zaar ci kazi Esɔ. ");
INSERT INTO mur_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Aje ci anowa gɔn o, agam gɔtɔni ginyginyec kɔkɔrkɔrantɔ niigi dook ŋaati aritan o. Ma akanek ɔl nɔɔnɔ zaar ci kazi Jakob, eeci agam niini gɔn ginyginyec. Ma ookcai dɔlya e, een Aizak irkitowa eet iiyu (60). ");
INSERT INTO mur_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Mazi akɔ adikir lɔgɔz nici, izi Esɔ eet ci ceeliinto ci arɛɛz weet ci awɔyi tuuwa. Aje Jakob ajaki niini, ma arɛɛz aavuzit ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Arɛɛzɔ Aizak ki Esɔ, eeci anyaak niini nɔɔnɔ idi ci kelego. Aje Rebeka arɛɛzɔ niini ki Jakob. ");
INSERT INTO mur_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ma iitene oman aak Jakob dayiin cigin. Aje Esɔ aku ceela adaya nɔɔnɔ magiz ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ma aku anek niini Jakob nɛ, “Adakan magiz ɔrɔɔt. Tiritan taman. Nyan dayiine cugun meerik noko ci kadei.” (Gi zin ci ka kutuyi ɔl dɔl ci Esɔ kizi zaara cigeec nɛ Edom o nɛɛn nici. Kɛŋ ci zaar nicoko akati meeritin ci dayiin niceke.) ");
INSERT INTO mur_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ma abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Mã arooŋ kanyin naana ineet dayiin cigan o, anyan rak niina aneet abuuzɛt unun.” ");
INSERT INTO mur_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Anek Esɔ nɔɔnɔ nɛ, “Abona! Ŋaan kanyin labak. Inoko kɔjɔŋɔza daayiz. Zin yo mã kadaai, agoonekan abuuzɛt gitaz ci abon?” ");
INSERT INTO mur_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ma abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Kutuguz rak ɔɔwa terkediin ci anyan aneet abuuzɛt.” Utugu ni Esɔ terkediin ci anyekɛ nɔɔnɔ abuuzɛt onin. ");
INSERT INTO mur_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Anyek ni Jakob nɔɔnɔ ḏɔkɛn been wuci ci cominto. Adawɔ ni Esɔ, ma awodɛ, ma iŋaaz, ma awɔ. Zin giye nico ɛcɛlbɛzan Esɔ abuuzɛt onin. ");
INSERT INTO mur_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ma iinyaye niceke anyak waanice lɔɔci tarjo ci appe ɔrɔɔt kiyo baal rak aku baale maŋaan arogi Ibrayim e. Ook ni Aizak ŋaati Abimilek ween alaan o ɔl o kazi Viliztiya ŋaao kazi Gɛrar. ");
INSERT INTO mur_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Eyelizak ni Jooi Aizak ɛlɛ ma anek nɔɔnɔ nɛ, “Má akɔ Masirɛ. Bar baak looce nico ebaal kaduwakin e. ");
INSERT INTO mur_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Baak ŋina. Ŋaan karomɛ naana ki ineet, ma ŋaan kamayukin ineet. Ŋaan kanyin ineet kibeen dɔl ci dɔl cugun looc nico ka kɛlɛɛmnyai zɔɔz baal katerkedei naana baatun Ibrayim e. ");
INSERT INTO mur_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ŋaan kanyi dɔl ci dɔl cugun kiziti mɛɛlɛ kotobtɔ ki monyony, ma ŋaan kanyi nɔɔgɔ ŋinito dook kizi cineeŋ. Katin boryowa ci loocu noko dook amayuwi niigi ŋaaten dɔl ci dɔl cugun. ");
INSERT INTO mur_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kagoon nɔkɔ o, eeci baale baatune Ibrayim aziiŋnan aneet, ma azooni lotinok ogan.” ");
INSERT INTO mur_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Abaak ni Aizak looce o kazi Gɛrar. ");
INSERT INTO mur_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ma iitene oman mazi ajin ɔl o Gɛrar Aizak gɔl ci Rebeka ween ŋaa onin, enek niini nɔɔgɔ nɛ, “Niini ŋɔɔna gi.” Aŋole niini ŋaati anɛ nɛ, Niini ŋaa can, eeci abaaban niini karabɔŋ ɔl nicigi aruk nɔɔnɔ kadaak ka kooti ŋaa cin o, eeci alina niini ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mazi akɔ abaak Aizak ŋinaante ŋinti wun, iitene oman icinun alaani o kazi Abimilek bitaalin ceez onin wun nyapildiŋa, ma acin niini Aizak abulbulanɔ kibeen ŋaa onin amici. ");
INSERT INTO mur_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Otowa ni Abimilek Aizak, ma anek nɛ, “Nicini ŋaa cun gi. Alaŋ een ŋoonu. Naa azi nɛ, Niini ŋoonu o?” Abɛdɛkɛ Aizak nɔɔnɔ anek nɛ, “Kabaaban kazi nɛ, Karabɔŋ koca arukan ɔl kadaak giye ci akati nɔɔnɔ mã kazi nɛ, Niini ŋaa can gi.” ");
INSERT INTO mur_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abɛdɛkɛ Abimilek nɔɔnɔ bornɛt nɔŋa anek nɛ, “Agooneket gi nico nɔkɔ naa? Karabɔŋ bar ɛɛti codoi ole cigan o oogin kibeen ŋaa cun o. Mazi agooni gi ci abil nɔkɔ, akunaket koca ageeta gerzitin ŋaaten ineet.” ");
INSERT INTO mur_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Itilo ni Abimilek ɔl ogin dook anek nɛ, “Mã anyak eet codoi ŋaatunooŋ ci agoonek gi ci gɛr Aizak, karabɔŋ een ŋaa cin o, aruwe koca niini kadaak.” ");
INSERT INTO mur_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ma irkite nice ɛlɛ oḏok Aizak ḏowo cigin ŋinaante, ma abiir labina ciginɛ noko ɔrɔɔt ɛlɛ, eeci amayuwek Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ma azaaci kaala ciginɛ noko dook kizi mɛɛlɛ zɛɛ makacin izi niini aroi ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ma abal niini tiin kibeen ɛɛza, ma anyak gabara ci meelik gɛr. Mazi akɔ acin modɛna o kazi Viliztiya botorzɛt cin o, inyigitit niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ɛmɛrɛŋɛnit ni niigi ṯuuwanɛ o Aizak baal adawa gabara o baatin Ibrayim e. Ajukek niigi ṯuuwanɛ nicoko biyɛn konyooktɛ. ");
INSERT INTO mur_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Enek ni Abimilek Aizak nɛ, “Luuk kuture cinaaŋ o. Anyawu niina dɔyiz ci appe ɔrɔɔt juket ageeta.” ");
INSERT INTO mur_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Uluuk ni Aizak, ma akɔ aal ŋewone o ŋino kazi Gɛrar. Ma abaak ŋinaante ŋinti wun. ");
INSERT INTO mur_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Adaac ni bodo gabara o Aizak ṯuuwanɛ baal adayai baale irkitowe o baatin Ibrayim, ma ivita uulalit ɔl o kazi Viliztiya vurte o adaai Ibrayim e. Ma awo Aizak ṯuuwanɛ nicoko zaar baal akanek baatinɛ laadun e. ");
INSERT INTO mur_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ma iitene oman adaya gabara o Aizak ṯuuk oma bodo ci liilim maama ɔrɔɔt ŋɛwɔna ŋaao abaai niigi. ");
INSERT INTO mur_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Adaŋtɔi ni niigi kibeen ɔl o looc o kazi Gɛrar towawiinto ṯuuk nico, eeci atarkat niigi gi ci azi nɛ, “Nicigi maam cigaacak.” Akatek ni Aizak ṯuuk nico zaar ci kazi Daŋɔn. ");
INSERT INTO mur_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Adaya ni bodo gabara o Aizak ṯuuk oma, ma ayɔwɔn niigi buk ṯuuk nico. Ma akanek Aizak ṯuuk nico zaar ci kazi Yɔwɔn. ");
INSERT INTO mur_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Uluuk ni bodo Aizak, ma akɔ adawa ṯuuk oma ŋaaman. Ŋinaante akɔma kɛzɔn. Ma akanek niini ṯuuk nico zaar ci kazi Ganɔn. Izi ni Aizak nɛ, “Anyet Jooi inoko aavuzit yaak ci ka kabaakti looce nico ka kazaace kaala ogaac dook.” ");
INSERT INTO mur_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Bodo ŋinaante uluuk niini. Idicek ook looce o kazi Biirsaba. ");
INSERT INTO mur_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ma baaline nice ɛlɛ eyelizak Jooi nɔɔnɔ ɛlɛ, ma anek nɛ, “Aneeta Jook o baatun Ibrayim. Má aŋole looc, eeci karomɛ naana ki ineet. Ma ŋaan kamayukin, ma kanyi dɔl ci dɔl cugun kizi mɛɛlɛ giye ci akati Ibrayim ween gabaren onan.” ");
INSERT INTO mur_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ɛtɛɛnya ni Aizak ŋinti taabinto ŋinaante, ma adiŋdiŋan Jook. Ɔtɔdɔ ni niini kɛɛmanɛ ogin ŋinaante, ma adawa gabara oginɛ ṯuuk oma bodo ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ma iitene oman iiya Abimilek Gɛrara arɔɔŋ kiiya kicin Aizak. Ma ɔrkɔra niini ki Yuzat o gɔɔn ilot nɔɔnɔ been Vikol ween alaan o takirnyawu. ");
INSERT INTO mur_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ma ajin Aizak nɔɔgɔ anek nɛ, “Avunakaŋ bodo niiga aneet ŋinaanto naa? Baale ŋaan amartoyaŋ, ma atookaŋ looce unooŋ?” ");
INSERT INTO mur_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Inoko kagaya didi Jooi aromenu kibeen ineet. Kabaabanta zin kizita nɛ, Abon kanyak naaga dook ganɔn ci katɛrkɛt kibeen ineet. ");
INSERT INTO mur_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Inoko zin terkedeyet niina ageeta gi calaŋ agooneket gi ci gɛr, eeci baale buk naaga ŋaan kutuguzeyin ineet gi ci gɛr. Bar waanice kagoonin ineet juruŋ. Ma abaai yaak zɛɛ ma aluuga kɔkɔm gi ci gɛr kagoonekin naaga ineet.” ");
INSERT INTO mur_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Utuguwek ni Aizak nɔɔgɔ dayiin ci meelik ɔrɔɔt, ma adake niigi dook, ma awot nyaantanɛ. ");
INSERT INTO mur_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ma iitene co ŋeere ririwɔna utuguzɔ Aizak ki Abimilek terkediin ci ganonto. Mazi awɔ niigi, itoonek Aizak nɔɔgɔ gɔl. Idicek ni Abimilek ki ɔl ogin ɔtɔɔzɔ. ");
INSERT INTO mur_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ma iitene nice ɛlɛ ivita gabara o Aizak, ma avu aduwak niigi nɔɔnɔ ṯuuk oma ci bodo adawa niigi. Anek niigi nɔɔnɔ nɛ, “Kɔbɔrtawa maam.” ");
INSERT INTO mur_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Akatek ni Aizak ṯuuk nico zaar ci kazi Biirsaba, eeci agɔɔn niigi terkediin o ganonto ki Abimilek. Zin zɛɛ been noko o awo ɔl kutur o abilni ṯuuwi nici zaar ci kazi Biirsaba. ");
INSERT INTO mur_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Mazi akɔ een Esɔ irkitowa eet ram (40), ɔrɔca niini ŋaai ram ole o kazi Ititaz. Dole codoi kazi zaar nɛ Judiz. Niini tinati eet ci kazi Beeri. Bodo codoi kazi zaar nɛ Basmat. Niini tinati eet ci kazi Elon. ");
INSERT INTO mur_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Anyaaktak ni niigi Aizak ki Rebeka baabani ci gɛr appe ɔrɔɔt ɛlɛ, eeci eegin niigi modɛn ci rɛŋ. ");
INSERT INTO mur_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Mazi akɔ een Aizak matuwoc, otoozyai nɔɔnɔ kɛbɛrɛ kizi ruben. Otowa ni niini ŋɛɛrin ween abuu kazi Esɔ, ma anek nɛ, “Ŋɛɛran.” Adɛc ŋɛɛrin anek nɛ, “Woo. Aneeta nici.” ");
INSERT INTO mur_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ma anek Aizak nɔɔnɔ nɛ, “Inoko kanyata. Alaŋ zin kaga iiten ci kadaaknɛ. ");
INSERT INTO mur_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Inoko doma dilanya ugun, bitɔ ceel ka bitɔ ruweyan kelegit ci kaku kadei. ");
INSERT INTO mur_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ka ija aayeyan zɛɛ ma amoji juruŋ eo gɔɔn karɔɔŋɛ naana. Anyaayan ni ka kadak ka zin enice kamayuwin ineet maŋaan kadaak o.” ");
INSERT INTO mur_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Ma azɔɔzɔ Aizak been Esɔ o, maje Rebeka aziirar nɔɔgɔ. Mazi awɔ Esɔ akɔ ceel, iiya enek Rebeka Jakob nɛ, “Kazii uyene baatun anek gotonu Esɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Bitɔ nyaayan kelegit tuuwa ka ija aayeyan ka kadak. Vurta ka kamayuwin ineet ŋume o Joowo maŋaan kadaak o. ");
INSERT INTO mur_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Inoko zin ziik gi ci kaduwakin naana ce dole onan. ");
INSERT INTO mur_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tiŋa je. Bitɔ ɛɛzai ka bitɔ jai bawɔ ci ŋaan een nyɔɔ adii ram ka kiiya kaayek baatun naanalya, ma kagoon eo gɔɔn arɛɛzi niini. ");
INSERT INTO mur_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ka zin nyowozek niina nɔɔnɔ idiŋ nico kook kadak zɛɛ ka kamayuwin niini ineet maŋaan kadaak o.” ");
INSERT INTO mur_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bar anek Jakob yaatin nɛ, “Alaŋ niina aga Esɔ alɔ ɛlɛ, maje ɛlɛ cane o agirgir akɔm ima o? ");
INSERT INTO mur_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Mã tedec ma uumnyan baaba, ma agayan kalaba naana nɔɔnɔ, alaŋ koca kanyaai ɛlɛ toriin, ma alaŋ bar kajowa mayuwɛnɛt?” ");
INSERT INTO mur_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Abɛdɛkɛ yaatinɛ nɔɔnɔ anek nɛ, “Anyek toriin nico kiiyayan aneet. Bitɔ tugu eci ona kaduwakin naana ineet o. Tiŋa je. Bitɔ nyaayan bawɔ ci ŋaan een nyɔɔ.” ");
INSERT INTO mur_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ook ni niini, ma akɔ anyaak yaatin bawɔ ci ŋaan een nyɔɔ. Iiya ni aayek yaatinɛ baatin eo gɔɔn arɛɛzi niini. ");
INSERT INTO mur_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Icina ni yaatinɛ rumanɛ ci abon rumanene o Esɔ itaŋnyi ceeza, ma aku aborcɛkɛ Jakob. ");
INSERT INTO mur_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ma aborcɛkɛ buk niini nɔɔnɔ ruce ci bawonu anyak ima azɛɛn been inyaa. ");
INSERT INTO mur_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Anyewun ni niini nɔɔnɔ idi been ḏɔkɛn ona aak niini e kooyi ŋaati baatin. ");
INSERT INTO mur_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ooyi ni Jakob dayiin nicoko ŋaati baatin, ma akɔ anek nɔɔnɔ nɛ, “Baaba, dayiin ce.” Adɛc baatinɛ anek nɔɔnɔ nɛ, “Ineet ŋɛɛran jaŋ?” ");
INSERT INTO mur_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Abɛdɛkɛ Jakob baatin anek nɛ, “Aneeta ŋɛɛrun ween abuu kazi Esɔ. Kutuguwa eona aduwakan e. Tiŋa je, dak idiŋ ci kanyaakin o ka mayuwan.” ");
INSERT INTO mur_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ma anek Aizak ŋɛɛrin nɛ, “Ajowa kelegit taman nɔkɔ ku ŋɛɛran?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Jook unun nɛɛn o atiritan aneet kojowa taman.” ");
INSERT INTO mur_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Enek ni Aizak nɔɔnɔ nɛ, “Iicaya di ajonun ŋaato ka kuumin mã een didi nici ineeta Esɔ gi.” ");
INSERT INTO mur_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Iicayak ni Jakob baatin ajonun, ma uum baatinɛ nɔɔnɔ, ma anek nɛ, “Bar mɔlɔyi cune o kizik molok o Jakob. Maje azɛɛna azɛɛn o Esɔ ɛlɛ nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Alaŋ iiyez Aizak Jakob, eeci azɛɛna ciginɛ o alɔ kiyo o Esɔ o. Ɔrɔɔŋ ni kamayuk niini nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ma ajin bodo nɔɔnɔ anek nɛ, “Dim didi nici ineet ŋɛɛran Esɔ nɛɛn?” Ma abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Ii, aneeta Esɔ gi.” ");
INSERT INTO mur_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Enek ni Aizak ŋɛɛrin nɛ, “Abona. Nyan zin idiŋ kadawɔ ka kamayuwin.” Anyek ni Jakob nɔɔnɔ idiŋ been nyaan. ");
INSERT INTO mur_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Mazi akɔ odotiz Aizak dayiinta, enek ŋɛɛrin nɛ, “Iicaya ijonun ŋaato. Ija cocowan ŋalyamoc logo onan.” ");
INSERT INTO mur_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Iicayak ni Jakob nɔɔnɔ, ma acoco ŋalyamoc. Mazi acɔɔk Aizak rumanɛ ci Esɔ ona aborcek Jakob o, abaaban niini izi nɛ, “Coma didi nici een Esɔ gi.” Amayuk ni niini nɔɔnɔ anek nɛ, “Inoko didi niina aŋol kiyo tuu o amayuk Manyi Jooi o. ");
INSERT INTO mur_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Abon bai anyin Jooi ineet maam tammu tadena. Ma anyek manɛɛn cugun kibiiritɔ ɔrɔɔt kanyak labi kibeen kɛbɛrɛ ci keenu meelik ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Abon bai modɛna dook een gabara cugun. Ma akanekin ɔl dook ineet kozoŋtin. Abon bai abal niina gotonogu dook izi alaan cineeŋ. Abon bai akanekin ineet dɔl o yaatun dook kozoŋtin. Abon bai ɔl o atoryin ineet atorye buk niigi. Maje ɔl o amayukin ineet abon buk niigi amayuwi.” ");
INSERT INTO mur_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Mazi odotiz Aizak mayuwɛnta, ɔtɔɔ Jakob. Ŋintimiliny nɔkɔ iiya gɔtɔnnya Esɔ ceela. ");
INSERT INTO mur_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ma aku buk agoonek niini baatin dayiin ci amadi zɛɛ onyowozek ni nɔɔnɔ. Ma akɔ anek nɛ, “Baaba, tiŋa jena. Dak idiŋ ci kanyaakin ce ka mayuwan.” ");
INSERT INTO mur_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ma ajin Aizak nɔɔnɔ anek nɛ, “Ineet ŋɛnɛɛn?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Aneeta ŋɛɛrun ween abuu kazi Esɔ.” ");
INSERT INTO mur_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ma abarit Aizak ziniz ɔrɔɔt ɛlɛ, ma ajine azi nɛ, “Mayo tɛ zin ona aruk kelegit, ma anyaakan e ŋɛnɛɛn? Anyaayan ɛɛti oman idiŋ ŋina, ma kadei ona ka ija noko, ma bar kamayuwa nɔɔnɔ. Didilɛ ojowa niini mayuwɛnɛt ci abil kodot.” ");
INSERT INTO mur_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Mazi azii Esɔ gi nico, ɛgɛrɛny niini luwante ci appe ɔrɔɔt ɛlɛ, ma adak ɛlɛ ŋaati aborni nɔŋ. Ma anek baatin nɛ, “Ka zin yo naana kudun ku? Mayuwan buk aneet baaba.” ");
INSERT INTO mur_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bar abɛdɛkɛ Aizak nɔɔnɔ anek nɛ, “Akɔm gɔl ci ka kamayukin bodo naana ineet. Iiya gotonu alabawan aneet ŋina. Ooyi zin niini mayuwɛnɛt unun.” ");
INSERT INTO mur_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Izi ni Esɔ nɛ, “Inoko adakan Jakob aneet looc lak ram. Didi zin akanonek nɔɔnɔ zaara ci kazi Jakob o, eeci een niini labjoi. Rak baale akɔyi niini abuuzɛt onan. Bodo inoko iiya ooyi mayuwɛnɛt onan. Alaŋ nuun anyei mayuwɛnɛt ci miliny anyayekan aneet baaba?” ");
INSERT INTO mur_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Abɛdɛkɛ Aizak nɔɔnɔ anek nɛ, “Kanyeya nɔɔnɔ kizi alaan ci abalin ineet. Ma kanyeya buk nɔɔnɔ labi ki kɛbɛrɛ ci keenu. Ɔkɔma bodo gi oma ci ka kutuguweyin ineet ŋɛɛran.” ");
INSERT INTO mur_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ma ilalek Esɔ baatin anek nɛ, “Anyei niina mayuwɛnɛt ci eet codoi ṯɔr nɔkɔ? Abon ri buk amayukan aneet baaba.” Aduwa niini zɔɔz nico ŋaati aluwi. ");
INSERT INTO mur_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ma abɛdɛkɛ baatinɛ nɔɔnɔ anek nɛ, “Abaai katin niina looce ci gɛr alaŋ kaala abiirni. Ma buk akɔm tammu tiilɛz. ");
INSERT INTO mur_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Abaai katin niina baayiz ci oroonto. Een katin niina gabaren ci gotonon. Bar zin katin ma ipira niina gidente cin noko, ma oroonu ki nɔɔnɔ giye calaŋ aziiŋnɛ niina zɔɔz cin, ɛtɛɛda koca niina ɛlɛ ŋaatin calaŋ bodo abalin niini ineet.” ");
INSERT INTO mur_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Zin iinyaye niceke otoborek Esɔ Jakob nɔŋ ɔrɔɔt, eeci anyek baatinɛ nɔɔnɔ mayuwɛnɛt onin. Abaaban ni niini izi nɛ, “Inoko iinya o ka kipirai baaba iziti ajɔnɛ. Zin tiŋeere vurte ci adaai baaba e, karui Jakob kadaak.” ");
INSERT INTO mur_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Mazi akɔ azii Rebeka zɔɔz ci ŋɛɛrin ceen abuu kazi Esɔ o, otowa niini ŋɛɛrin ceen tutur kazi Jakob o, ma aku anek nɛ, “Ziik di gi ce. Arɔɔŋ gotonu Esɔ kuruyin ineet daak ka kacaca gi baal agoone niina nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ŋɛɛran, inoko karooŋnyin ineet tugu gi ci kaduwakin ce. Tiŋa, vir bitɔ ole o gɔtɔna o kazi Leban looce o kazi Mesopatamiya. ");
INSERT INTO mur_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ka bitɔ aavu rak niina ŋinaante zɛɛ ma akɔ abada gotonu ziniz bornɛt noŋe cin noko. ");
INSERT INTO mur_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Mazi katin ook ereyek nɔɔnɔ gi ci baal agoone niina nɔɔnɔ o, ŋaan kitoonekin naana ineet otok ka bada ŋinaante. Alaŋ karooŋ kukuluzuŋ igeet dook ramantiya iitene codoi, eeci mã arukin Esɔ ineet daak, aruk buk ɔl koca nɔɔnɔ kadaak.” ");
INSERT INTO mur_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ook ni Rebeka ŋaati Aizak, ma akɔ anek nɛ, “Kabor naana ŋaai ci Esɔ een modɛn noko. Mã arɔcɛ Jakob buk modene ci kazi Ititaz noko, alaŋ koca kaga ka kabaak ku, bar koca ŋaatan maya daayizi.” ");
INSERT INTO mur_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Otowa ni Aizak Jakob, ma aku amayuk nɔɔnɔ, ma anek nɛ, “Má arɔcɛ modene ci looc ci kazi Kanan o ŋina. ");
INSERT INTO mur_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Abon akɔ looce o kazi Mesopatamiya ole o jijitun o kazi Bezuwel ka bitɔ rɔca niina ŋaa cun ŋinaante. Bitɔ rɔcɔ ŋaati malotun o kazi Leban. ");
INSERT INTO mur_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ŋaan Jooi o anyak dɔyiz dook amayukin ineet ka nyak dɔl ci meelik, ma een baati boryok ci meelik. ");
INSERT INTO mur_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Abon bai amayukin Jooi ineet ki dɔl ci dɔl cugun kiyo baale amayuk niini jijitun Ibrayim e. Ma buk katin anyin Jooi ineet bal looc ci baal anyonek Ibrayim, ma inoko abaayɛ niina noko dook.” ");
INSERT INTO mur_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Itoonek ni Aizak Jakob looc o kazi Mesopatamiya kook ŋaati Leban ween gɔtɔni Rebeka ween yaati Esɔ been Jakob. ");
INSERT INTO mur_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Agawun ni Esɔ amayuwun Aizak Jakob bodo, ma itoonek niini nɔɔnɔ Mesopatamiya ka kook kojowa ŋaa cin ŋinaante. Ma buk aga ricaniin o anɛkɛ Aizak nɔɔnɔ nɛ, “Má arɔca dole ci looc ci kazi Kanan o.” ");
INSERT INTO mur_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ma aga iziiwun Jakob zɔɔz o baatin been yaatin, ma akɔ Mesopatamiya. ");
INSERT INTO mur_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ma aga buk Esɔ alaŋ baatinɛ Aizak arɛɛz dɔl ci Kanan o. ");
INSERT INTO mur_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ook ni Esɔ ŋaati Ismayil ween ŋɛɛrti Ibrayim, ma akɔ arɔca bɛɛnyin ci kazi Malat ceen ŋɔɔni Nebat, ma azaaci niini ŋaai ogin baal ɔrɔca laadun e. ");
INSERT INTO mur_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Itiŋa ni Jakob ŋaao kazi Biirsaba ɔtɔɔ ook looce o kazi Mesopatamiya. ");
INSERT INTO mur_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Mazi akɔ ii loota, ataŋu niini gɔla ŋaaman, ma aruk ɔɔ biya. ");
INSERT INTO mur_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Mazi akɔ atɛɛda nɔɔnɔ ooŋnya, uwunozɛ, ma acin wunozyai gɔl ci arumuz looc ki tammu taden. Ma awɔ toonnyawa ci Joowo gole nico. Abarcɔ niigi gole nico avɔ ceegi tamma, ma avunak ceegi looc. ");
INSERT INTO mur_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ma acin buk niini wunozyai Jook abilnek nɔɔnɔ, ma anek nɛ, “Aneeta Manyi Jook o Ibrayim been Aizak. Ŋaan kanyin ineet been dɔl ci dɔl cugun looc ci ɔɔŋɛ noko. ");
INSERT INTO mur_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ma ŋaan azaaci dɔlya ci dɔl cugun kotobtɔ ki kazac. Ma azaanonek katin niigi loocok dook. Ma kamayuwi katin naana ŋaaten ineet been dɔl ci dɔl cugun boryok dook. ");
INSERT INTO mur_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ga zin niina ŋaan kɔrkɔr naana ki ineet, ma kazuunin ineet ŋaati oola akɔyɛ zɛɛ ma kabadakin bodo naana ineet looc nico. Alaŋ kuuŋnin ineet doon, bar ŋaan kazuunin nɔkɔ zɛɛ ma kagoonekin kaal ci katerkedekin noko dook.” ");
INSERT INTO mur_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Mazi acinɛ Jakob ooŋnyai, abaabanun niini izi nɛ, “Aavi didi Manyi Jooi tɔ ŋina, ma bar ŋaan naana kaga.” ");
INSERT INTO mur_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Anyawun ni niini ŋoliin, ma azi nɛ, “Looc taz ci anyak ŋoliin noko? Inoko ŋiniti ŋinti Joowo gi. Inoko nici araan ci akɔ ki tammu taden.” ");
INSERT INTO mur_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ma ŋeere ririwɔna odoma Jakob bɛ ona arui ɔɔ e, ma arek looc kibil tɔp ka kizi bayen ci ŋinito, ma aḏuutek maal bɛ nico. ");
INSERT INTO mur_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ma akanek niini ŋinito zaar ci kazi Bezal. Maje baale laadun ŋinite kazi zaar nɛ Luz. ");
INSERT INTO mur_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Enek ni Jakob Jook nɛ, “Eterkedeyan baale niina gi ci ka koromtɔi niina ki aneet, ma azuunan aneet keronnye can noko, ma anyan dayiin ci kadei been rumanɛ ci kaborcei. ");
INSERT INTO mur_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Ma bodo katin kamiironei naana kɔrɔk o baaba yaak. Zin giye nico izɛ niina Jook onan kanuyin nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Zin bɛ nico kari ŋinito ka kizi ŋinti ka kidiŋdiŋantin ɔl ineet. Ma buk ŋaan gɔɔn kanyin lɛlɛn codoi lelenete ween amɔtɔ kaale o anyan niina aneet dook.” ");
INSERT INTO mur_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Idicek ni Jakob keronnye onin zɛɛ ma akɔ arum looc o kazi Mesopatamiya. ");
INSERT INTO mur_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ma ŋinaante ojowa niini ṯuuk ci abil balala abuŋe ɔtɔgi biye ci appe. Ma anyak ŋinaante ɛɛza ceen tenyit iiyu ci oogin aliya ṯuuk nico. Areyi niigi ka kuwudi. ");
INSERT INTO mur_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Gɔɔn tup nɔkɔ mã olotai ɛɛzana dook, apiya ɔl ci towawiinto o bɛ nico ṯuuk otoga, ma awodoz ɛɛza zɛɛ mazi odotiz, amiirɛnɛ niigi bɛ ŋaa onin. ");
INSERT INTO mur_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ijin ni Jakob ɔl ci towawiinto noko anek nɛ, “Gɔtɔnɔga, eeginu ɔl ci looc jaŋ?” Ma anek niigi nɔɔnɔ nɛ, “Keegina ɔl ci Eran.” ");
INSERT INTO mur_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ma anek niini nɔɔgɔ nɛ, “Agayu ka Leban ween dole o dole o Nayor?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ii. Kagaya.” ");
INSERT INTO mur_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ma ajin niini nɔɔgɔ anek nɛ, “Abona kini niini?” Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ii. Abona. Cin di bɛɛnyin Recal nɛɛn ci aku anowa ɛɛzana ŋaate neke.” ");
INSERT INTO mur_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ma anek Jakob nɔɔgɔ nɛ, “Icinit di ŋaan abil ii paŋ. Ŋaan kizi ŋinti ka kojowantɔi ɛɛzana. Naa alaŋ awuduzu ɛɛza ka uturanit kegeec o?” ");
INSERT INTO mur_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Karooŋnya rak ɛɛza kivita zɛɛ ma alotai niigi dook ŋina ka kipiktawa bɛ ṯuuk otoga ka kowodozta nɔɔgɔ dook.” ");
INSERT INTO mur_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Mazi ŋaan azɔɔzɔ Jakob ki nɔɔgɔ nɔkɔ, anyaa Recal ɛɛza ugeec. ");
INSERT INTO mur_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Mazi acin Jakob Recal ki ɛɛza o malotin Leban, ook niini ṯuuwa, ma apik bɛ kivurut, ma awodoz ɛɛza. ");
INSERT INTO mur_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","Mazi akɔ odotiz ɛɛzana kodɛnta, uduwak Jakob Recal ɛlɛ enek nɛ, “Keen naana atenoi cun libire ci baatun. Keen ŋɛɛrti Rebeka.” Ma acoco Jakob Recal ŋalyamoc ŋaati aluwi. Ɔdɔkɔny ni Recal, ma akɔ aduwak baatin kaviyak o Jakob ween ŋɛɛrti ŋɔɔnɔn. ");
INSERT INTO mur_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Mazi akɔ azii baatinɛ zɔɔz nico, ɔdɔkɔnya iiya urumek nɔɔnɔ gɔl. Ma aŋacu, ma acoco ŋalyamoc. Anyaak ni niini nɔɔnɔ kɔrɔk. Ma aku oobek Jakob Leban kaal o agooni dook. ");
INSERT INTO mur_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Mazi azii Leban kaal nicoko, enek niini nɔɔnɔ nɛ, “Didilɛ een niina atenoi. Keegin naaga biye codoi.” Aavu ni Jakob ŋinaante, ma aliŋliŋonek niini Leban nɔkɔ nyelok dook. ");
INSERT INTO mur_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ma iitene oman enek Leban nɔɔnɔ nɛ, “Yo nuun een niina atenoi can o, alaŋ aganɔ ŋaati kanyin ineet liŋliŋi nɔkɔ. Inoko duwayan gi ci arooŋnyan kuruweyin ineet liŋliŋonte ci aliŋliŋonekan aneet noko.” ");
INSERT INTO mur_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Maje Leban anyak bɛɛnyigin ceen ram. Ceen abuu o kazi zaar nɛ Leya. Aje ceen tutur o nɛɛn Recal. ");
INSERT INTO mur_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya anyak kɛbɛrɛ ci alal koc, aje Recal alina niini ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ɛrɛɛz ni Jakob Recal, ma anek niini Leban nɛ, “Ŋaan kaliŋliŋonekin ineet irkitok torgɛrɛm ka nyan bɛɛnyun ceen tutur kazi Recal o kiriyi.” ");
INSERT INTO mur_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Enek ni Leban nɔɔnɔ nɛ, “Abona ɔrɔɔt ɛlɛ ŋaati kanyin Recal ineet riyi. Alaŋ abon ŋaati kanyekɛ nɔɔnɔ eet oma. Inoko zin koromtɛ baak ŋina.” ");
INSERT INTO mur_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Aavu ni Jakob iliŋliŋ irkitok torgɛrɛm ka kɔrɔca Recal, ma acin niini irkitok nicoko bar kizik iinya ci kidic tɛr, eeci arɛɛz niini Recal. ");
INSERT INTO mur_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ma iitene oman enek Jakob Leban nɛ, “Inoko idicai irkitowa o liŋliŋɔn onan. Nyan dole kitivic.” ");
INSERT INTO mur_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Utugu ni Leban dayiin, ma awo ɔl dook ŋinaante kivitak tiŋkawiin ci bɛɛnyin o. ");
INSERT INTO mur_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bar baaline nice ɛlɛ, ooyi Leban bɛɛnyin o kazi Leya, ma akɔ anyek Jakob, ma ɔrkɔra buk Leya kibeen dole ween miroi aliŋliŋonek nɔɔgɔ kazi Zilpa ka kizi gabaren cin. Ma aromɛ Jakob ki Leya calaŋ aga nicini Leya o. ");
INSERT INTO mur_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","25","Mazi akɔ aaliz tammu, acin Jakob bar da ci oogin ki nɔɔnɔ o Leya gi. Ook ni niini ŋaati Leban bornɛt nɔŋa, ma akɔ anek nɛ, “Gitaz ci agoonekan noko? Kaliŋliŋ naana ŋaatun ka kɔrɔc Recal. Naa alabana naa?” ");
INSERT INTO mur_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ma abɛdɛkɛ Leban nɔɔnɔ anek nɛ, “Naaga ŋina keere cinaaŋ o alaŋ aganɔ ŋaati avici ɔl dole ceen tutur o maŋaan gɔn ceen abuu o aavi baala. ");
INSERT INTO mur_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Má anyi ziniz kitirany gaga. Rɛwɔ zɛɛ ma adicai iinya ween torgɛrɛm ci tiŋkawiin ci Leya o. Ŋaan kanyin bodo ineet Recal tivic ka bodo liŋliŋ irkitok oogi ceen torgɛrɛm.” ");
INSERT INTO mur_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Agama ni Jakob zɔɔz nico. Mazi akɔ adicai iinya o tiŋkawiinto, anyek Leban Jakob bɛɛnyin o kazi Recal kitivic kizi ŋaa cin bodo. ");
INSERT INTO mur_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ma anyek Leban Recal dole ceen gabaren kazi Bila ka kook kiliŋliŋozek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ataŋguzɔ ni Jakob ki Recal, ma arɛɛz niini Recal ɔrɔɔt ɛlɛ kujuk Leya. Iliŋliŋ ni bodo Jakob ŋaati Leban irkitok torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Mazi akɔ acin Jooi Leya alaŋ areezi niini kiyo Recal o, ɔkɔl nɔɔnɔ momu kitir, ma bar anyek Recal kɔtɔɔ koliin. ");
INSERT INTO mur_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Anyawɔ ni Leya, ma ookca ŋɛɛrin o kazi Robɛn. Ma azi nɛ, “Icinan Jooi aneet gidente onan. Inoko ma kanyawa naana ŋɛɛran o, ɛrɛɛzan tiŋeere ɛɛti cane o.” ");
INSERT INTO mur_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ma irkitowe ogɛn anyawɔ Leya bodo, ma ookca ŋɛɛrin oma. Ma azi nɛ, “Anyan Jooi ŋɛɛran oma bodo, eeci acinan niini aneet alaŋ kareeze.” Ma akanek Leya dole zaar ci kazi Simiyan. ");
INSERT INTO mur_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ma irkitowe ogɛn anyawɔ bodo niini, ma ookca ŋɛɛrin oma. Ma azi nɛ, “Didilɛ agaman tiŋeere ɛɛti cane o kɔdɔk giye ci karitakɛ naana nɔɔnɔ lɔgɔz iiyu o.” Akatek ni niini ŋɛɛrin nico zaar ci kazi Livai. ");
INSERT INTO mur_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Bodo irkitowe ogɛn anyawɔ bodo niini, ma ookca ŋɛɛrin oma, ma azi nɛ, “Abona kanaati Jook.” Akatek ni niini ŋɛɛrin nico zaar ci kazi Juda. Uŋuuk ni niini bodo. ");
INSERT INTO mur_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Mazi acin Recal ɛlɛ ɔtɔɔ niini koliin kɔkɔm dɔl nɔkɔ, onyoor ŋɔɔni. Ma anek Jakob nɛ, “Mã alaŋ aritakan dɔl, kadaai koca.” ");
INSERT INTO mur_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Otobor ni Jakob nɔŋ zooze nico, ma anek nɔɔnɔ nɛ, “Alaŋ naana keen Jook ci ateedin ineet tiri o.” ");
INSERT INTO mur_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Enek ni Recal Jakob nɛ, “Gabaren onan kazi Bila ce. Ataŋguz ki nɔɔnɔ ka kitirayan dɔl ci ka kavadawan.” ");
INSERT INTO mur_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Anyewun ni Recal Jakob gabaren onin kazi Bila kizi ŋaa cin. ");
INSERT INTO mur_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Anyawɔ ni Bila, ma aritak Jakob logoz. ");
INSERT INTO mur_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Izi ni Recal nɛ, “Utuguyeyan Jooi gi ci abon payiinte onin. Iziik niini ŋaryiin onan, ma inoko anyan ŋɛɛran.” Akatek ni niini dole zaar ci kazi Dan. ");
INSERT INTO mur_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ma irkitowe ogɛn anyawɔ Bila bodo, ma aritak Jakob ŋɛɛrin oma. ");
INSERT INTO mur_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ma azi Recal nɛ, “Kanyei rɔwɔn ci karowona ki ŋɔɔna, bar zin inoko kanyeya naana nɔɔnɔ ḏony.” Ma akanek Recal dole nico zaar ci kazi Navtali. ");
INSERT INTO mur_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Mazi akɔ aga Leya ɛlɛ alaŋaan arit bodo, anyek buk niini Jakob gabaren onin kazi Zilpa kizi ŋaa cin. ");
INSERT INTO mur_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Itirak ni Zilpa Jakob ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ma azi Leya nɛ, “Iiyayan bonati.” Ma akanek niini dole zaar ci kazi Gad. ");
INSERT INTO mur_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ma anyakɛ bodo Zilpa, ma aritak Jakob ŋɛɛrin oma. ");
INSERT INTO mur_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ma anek Leya ɛlɛ maany nɛ, “Inoko katalnɛ ɔrɔɔt. Ma buk agayan ŋaai dook katalnɛ naana ɔrɔɔt.” Ma akanek niini dole nico zaar ci kazi Acar. ");
INSERT INTO mur_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ma iinyaye o gɔɔn atɛɛdi ɔl labi, ook Robɛn ḏorta, ma akɔ ajowa agɛrɔ ci kɛɛt ci kazi mandarek, ma anyaak niini yaatin Leya. (Baale gɔɔn ŋaai mã adak agɛrɔ ci kɛɛt nico, atirit nɔɔgɔ nyayiinta.) Mazi acin Recal agɛrɔ nicoko, enek niini Leya nɛ, “Nyan da buk agɛrɔ ona anyaakin ŋɛɛrun e ci miliny.” ");
INSERT INTO mur_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ma abɛdɛkɛ Leya nɔɔnɔ anek nɛ, “Kodi! Ma baale ooyɛ eet, alaŋ aleenonu niina ki nɔɔnɔ. Arooŋ bodo biti agɛrɔ ci anyaakan ŋɛɛran o?” Ma anek Recal nɔɔnɔ nɛ, “Mã anyan agɛrɔ ci ona anyaakin ŋɛɛrun o, kanyin koca Jakob ka ataŋguz ki nɔɔnɔ baalin nico.” ");
INSERT INTO mur_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Mazi akɔ aku Jakob manɛɛni, ook Leya urumek nɔɔnɔ gɔl, ma anek nɛ, “Inoko baaline nico kavɔ koogin naana ki ineet, eeci kabaliwawin ineet agɛroye ci anyaakan ŋɛɛran uyene.” Ook ni ataŋguzɔ niini ki nɔɔnɔ baaline nice. ");
INSERT INTO mur_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Iziik ni Jooi ŋaryiin o Leya, ma anyake niini, ma ookcak Jakob ŋɛɛrin o ano gɔnɔgi ween wec. ");
INSERT INTO mur_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ma azi Leya nɛ, “Agoonekan Jooi gi ci kaganona ɔrɔɔt, eeci baale kanyeya gabaren onan eet onan.” Akatek ni niini ŋɛɛrin nico zaar ci kazi Isikar. ");
INSERT INTO mur_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ma iinyaye ogɛn anyawɔ bodo niini, ma ookcak Jakob ŋɛɛrin o anowa bawuci ween tur. ");
INSERT INTO mur_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ma azi niini nɛ, “Agoonekan Jooi gi ci abon ɔrɔɔt. Inoko ɛɛti onane ɛrɛɛzan tiŋeere ɔrɔɔt ɛlɛ, eeci kitiraya nɔɔnɔ ŋɛɛrigin ceen tɔrkɔnɔm.” Akatek ni niini dole zaar ci kazi Zibolon. ");
INSERT INTO mur_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ma vurte nice itira Leya bɛɛnyin, ma akanek nɔɔnɔ zaar ci kazi Dina. ");
INSERT INTO mur_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Aada ni bodo Jooi Recal, ma azii ŋaryiin onin, ma akɔl nɔɔnɔ momu. ");
INSERT INTO mur_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Anyawɔ ni Recal, ma ookca logoz, ma azi nɛ, “Aarawan Jooi alyaan onan kaŋuuwɛ. ");
INSERT INTO mur_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Abona bai bodo anyan Jooi aneet ŋɛɛran oma nɔkɔ.” Akatek ni niini dole nico zaar ci kazi Josev. ");
INSERT INTO mur_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Mazi akɔ aritai Josev, enek Jakob Leban nɛ, “Karooŋ kimiire kook ɔlɔ looce ona. ");
INSERT INTO mur_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Karooŋ kooyi ŋaai cigan o been dɔl cigan baal kaliŋliŋa ŋaatun noko. Aga ri niina kaliŋliŋonekin ineet juruŋ.” ");
INSERT INTO mur_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bar anek Leban nɔɔnɔ nɛ, “Inoko mã areezan niina aneet, abon aavɛ karomtɛ kibeen aneet ŋina, eeci kojowa ŋarizɛta amayukan Jooi aneet o, eeci karomɛ kibeen ineet. ");
INSERT INTO mur_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Inoko olla duwayan kaal ci arooŋ ka kuruweyin.” ");
INSERT INTO mur_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ma abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Agayan niina kaliŋliŋonekin ineet juruŋ. Ma azaaci ɛɛzana cugune o aziite can o. ");
INSERT INTO mur_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Baale anyei ɛɛza ci miliny. Mazi kakun naana, amayuwin Jooi ineet kazaace ɛɛzana ugune kizi mɛɛlɛ gɛr ŋaaten aneet. Inoko zin kɔrɔɔŋa naana kabal ɛlɛ can o maany.” ");
INSERT INTO mur_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ma ajin Leban nɔɔnɔ anek nɛ, “Inoko zin arooŋnyan kanyin naa?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Alaŋ karooŋ kaal ci anyan. Olla karooŋ kuduwayin baabani can ce. Mã agama, kazoonɛ koca bodo ɛɛza cugun o. ");
INSERT INTO mur_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nyan waanico kook kɔtɔɔ ɛɛzaye ugun ka kook katakala ɛɛza ci kolik ki ci labacik ki ci buzenik ka kizi kaal ci aruwekan niina aneet liŋliŋɔnta nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ka zin gɔɔn tiŋeere mã ajowa niina ɛɛzane cigan o calaŋ kolitɛ ki calaŋ labacɛ ki calaŋ buzɛnɛ, kizɛ koca naana agoryai.” ");
INSERT INTO mur_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ma abɛdɛkɛ Leban nɔɔnɔ anek nɛ, “Kagama. Ŋaan kagoon eci aduwanɛ niina o.” ");
INSERT INTO mur_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Atakala ni Leban iitene nico ɛlɛ ɛɛza ci labacik ki ci buzenik ki ci kolik, ma anyek ŋɛɛrigin kotowaac nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ma aŋɛrya niini ki ɛɛza ogin ŋaati Jakob, ma akɔ rɛɛna ŋaati kawɔyi zɔɔnɛ iinya iiyu. Maje Jakob abal ɛɛza o Leban oogi. ");
INSERT INTO mur_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Uduula ni Jakob kɛɛn oto, ma ayɛɛt kizi labacɛ. ");
INSERT INTO mur_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ma aku arek kilɔmɛt o gɔɔn awodɛn ɛɛzana, eeci gɔɔn ɛɛzana avu awoyɔ ŋinaanto. ");
INSERT INTO mur_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Mazi awoyɔ ɛɛzana keene o ɛɛl nɔɔgɔ ŋuma, itirta niigi dook nyɔɔ ci labacik ki ci buzen ki ci tulkik. ");
INSERT INTO mur_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ɛŋɛra ni Jakob ɛɛza ci ŋai o, ma anyek ɛɛza ci macik kolik o ki ci buzen o kotoozi gɔnɔgi ci ŋai o. Ma ɛɛnyca niini teny cin doon ka calaŋ acanɔ ɛɛzana ciginɛ o kibeen ci Leban o. ");
INSERT INTO mur_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Mazi arɔɔŋ ɛɛzana ŋaye adii o gɔnɔgi ci macik o wɔyɔnta, arek Jakob oto ci keetu noko ɛɛza ŋumti ŋaao wodento ka ma awoyɔ niigi ŋina, ka kanyayit nyɔɔ ci buzen. ");
INSERT INTO mur_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ma arɔɔŋ ɛɛzana ci ŋaye mɔdɔtik o gɔnɔgi wɔyɔnta, alaŋ arek niini oto ci keetu o nɔɔgɔ ŋuma. Taman nɔkɔ iziti ɛɛzana ci mɔdɔtik o dook ci Leban, aje ci adii o dook iziti ci Jakob. ");
INSERT INTO mur_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Zin gole nico izi Jakob arɔi ɔrɔɔt ɛlɛ. Anyawun niini ɛɛza ci meelik ki gabara ki nyakalɛt been zigire. ");
INSERT INTO mur_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ma iitene oman iziik Jakob lɔgɔz o Leban anɔ nɛ, “Ooyi Jakob kaal o baatinai dook. Arɔkzɛt cinɛ o dook akunak nɔɔnɔ ŋaati baatinai.” ");
INSERT INTO mur_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ma buk acin Jakob Leban alaŋaan arɛɛz nɔɔnɔ kiyo baale e. ");
INSERT INTO mur_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Enek ni Jooi Jakob nɛ, “Miire bitɔ looce o baatun been atenok ugun. Ŋaan kɔrkɔr naana ki ineet.” ");
INSERT INTO mur_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Itoonek ni Jakob otok Recal been Leya ka kɔɔt kurumtɔ ki nɔɔnɔ ḏorta ŋaao ɛɛlni ɛɛzana oginɛ. ");
INSERT INTO mur_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ma akɔ anek niini nɔɔgɔ nɛ, “Kaŋaamnɛ naana baatunooŋ alaŋaan areezan kiyo baale e. Bar zin Jooi o baaba ŋaan karomena kibeen aneet. ");
INSERT INTO mur_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Agayu niiga kaliŋliŋonei naana baatunooŋ dɔyize onan dook. ");
INSERT INTO mur_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Maje bar niini adakan aneet looc. Ma alabanan lak amɔtɔ kaale o ka waan kuruweyan niini aneet. Bar zin Jooi ŋaan kanyek nɔɔnɔ kutuguweyan aneet gi ci gɛr. ");
INSERT INTO mur_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Baale gɔɔn ma anekan Leban nɛ, Ɛɛzana ci buzen o dook kaal cugun aruwonekin ineet liŋliŋonte unun nɛɛn, bar ɛɛzana dook arita nyɔɔ ci buzen. Mazi acin niini gi nico, anekan bodo nɛ, Ɛɛzana ci labac o dook kaal cugun aruwonekin ineet liŋliŋonte unun nɛɛn. Ma azi nɔkɔ bar ɛɛzana dook arita nyɔɔ ci labacik. ");
INSERT INTO mur_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Gole nico ɛŋɛrayan Jooi aneet ɛɛza nicoko ŋaati baatunooŋ kizi cigan. ");
INSERT INTO mur_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ma iinyaye o gɔɔn awɔyɔn ɛɛzana, kacin naana wunozyai kizik ɛɛzana ci macik awɔyi gɔnɔgi o iziti buzɛnɛ, ceegi labacɛ, maje ogɛn tulkɛtɛ. ");
INSERT INTO mur_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ma anekan toonnyaiti ci Joowo wunozyai nɛ, Jakob. Ma kawɛ naana kazi nɛ, Woo. ");
INSERT INTO mur_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eneyan ni toonnyaiti ci Joowo noko nɛ, Cin di ɛɛza o macik awɔyi gɔnɔgi o dook iziti buzɛnɛ, ceegi labacɛ, maje ogɛn tulkɛtɛ. Kagoon naana gi nico o, eeci kacin kaal o gɛr agoonekin Leban ineet dook. ");
INSERT INTO mur_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Aneeta Jook baal kayelzakin ineet ɛlɛ ŋaao kazi Bezal e nɛɛn ŋaabaal adɔŋɛ bɛ kibil tɔp, ma aḏuute maal o kiŋiroco, ma kagɔɔni terkediin ki aneet e. Inoko zin lot kaal ugun ka miire bitɔ looce unun baal aritanɛ.” ");
INSERT INTO mur_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ma ɛbɛdɛkɛ Recal been Leya Jakob anek nɛ, “Akɔm gi ci ŋaan anyayeket baatinaaŋ ageeta. ");
INSERT INTO mur_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Inoko ataaloyet niini ageeta kiyo modɛna o, ma adawun kaal o aruyai ŋaatinaaŋ dook niini doon. ");
INSERT INTO mur_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bar zin arɔkzɛt ci aara Jooi ŋaati baatinaaŋ, ma anyin ineet o arɔkzɛt cinaaŋ kibeen dɔl cigaacak o. Olla zin tugu gi ci arooŋ niina tugu eo aduwakin Jooi ineet, maje naaga kɔrkɔr ki ineet.” ");
INSERT INTO mur_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ma taman nɔkɔ ulutun Jakob kaal ogin ajowa ole o Leban dook ka kuluuk kimiire kook ŋaati baatin Aizak looce o kazi Kanan. Ma arek niini ŋaai ogin ki dɔl nyakalɛt. Itiŋa ni uluugi kaal ogin dook. ");
INSERT INTO mur_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ma akɔyi buk Recal joowanɛ o kɔrɔk o baatin. Agɔrɔz niini joowanɛ nicoko ŋaati aduŋni baatinɛ Leban akɔ azɛɛci ɛɛza ogin ima ḏorta. ");
INSERT INTO mur_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma anik Jakob calaŋ aduwak Leban weet cin o. ");
INSERT INTO mur_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ma akɔyi niini kaal ogin dook, ma ayiik. Ma akɔ abaayiz liil o kazi Yuparatiz, ma akɔ biyene o Gilid. ");
INSERT INTO mur_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Mazi akɔ een iinya iiyu, uduktak ɔl Leban niyi ci Jakob o. ");
INSERT INTO mur_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ooyi ni niini ɔl o kɔrɔk onin, ma aviri Jakob zooc iinya torgɛrɛm zɛɛ ma akɔ amɔda nɔɔnɔ biyene o Gilid. ");
INSERT INTO mur_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ma baaline nice ɛlɛ iiyak Jooi Leban wunozyai, ma anek nɔɔnɔ nɛ, “Gɛny! Má agoone Jakob gi ci agoone been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Maje Jakob aal biyene o Gilid, ma aku Leban ki ɔl ogin, ma avu adɔdɔ buk niigi kɛɛmanɛ ugeec kɔjɔŋɔztɔ ki nɔɔnɔ ŋinaante nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Enek ni Leban Jakob nɛ, “Naa alabanan zɛɛ ma akɔyɛ bɛɛnyigan kiyo ŋaai ci agamnyi ɔrɔɔnta o naa? ");
INSERT INTO mur_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Naa alabanan, ma ani calaŋ aduwakan o naa? Inoko da waan duwayan kanyin waan ineet tɔ mayuwɛnta ŋaati abenin ɔl talniinta, ma aruwɛn kidoŋwana ki kidorɛt. ");
INSERT INTO mur_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Akɔ ma alaŋ buk bac anyan kamayuk dɔl ci dɔl cigan o been bɛɛnyigan ka kɔtɔɔzɔ yaak. Agoon niina gi ci kizik bar agɔɔn ɛɛti ci tarbal. ");
INSERT INTO mur_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kanyei dɔyiz ci waan kagoonekin ineet gi ci gɛr, bar zin bilija alaman Jooi o baatun aneet, ma anekan nɛ, Gɛny! Má agoone Jakob gi ci agoone. ");
INSERT INTO mur_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Inoko kagayin ŋɛdɛt ineet awɔ o, eeci arooŋ miirozek kɔrɔk unooŋ ɔrɔɔt ɛlɛ. Mazin akɔyɛ joowanɛ o kɔrɔk onan naa?” ");
INSERT INTO mur_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Kani o, eeci kaŋolinin naana ineet. Kabaaban kazi nɛ, Coma aamanan bɛɛnyugun. ");
INSERT INTO mur_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mazin giye ci akati joowanɛ ugun, ija rɔɔŋɔ zɛɛ mazi ajowa ŋaatinaaŋ eet ci anyak nɔɔgɔ, ruk nɔɔnɔ kadaak. Mã anyak gi cun ŋina, abona adoma ageeta dook kɛbɛrɛn ŋina.” Azi Jakob nɔkɔ o, eeci alaŋ aga niini ɔgɔrɔza tɛ Recal joowanɛ o baatin o. ");
INSERT INTO mur_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ook ni Leban ɔrɔɔŋɔ kɛɛmawe o Jakob, ma bodo akɔ arooŋnyi kɛɛmawe o Leya kibeen kɛɛmawete o ŋaai ween gabara een ram, ma ŋaan kojowa niini joowanɛ ogin. Ook ni bodo ɔrɔɔŋɔ kɛɛmawe o Recal. ");
INSERT INTO mur_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Maje Recal arɔɔt joowanɛ ci kɔrɔk ci baatin o doŋowe o nyakalo, ma aavɛ niini doŋok nico loota. Ma arooŋnyi Leban zɛɛ been tɛr calaŋ ajowa. ");
INSERT INTO mur_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ma anek Recal baatin nɛ, “Má abornekan nɔŋ baaba. Alaŋ kiŋaanekin je o, eeci kanyei maam ogaacak ŋaanu.” Ma arooŋnyi Leban, ma ŋaan kojowa joowanɛ ogin been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Otobor ni Jakob nɔŋ ɔrɔɔt ɛlɛ, ma anek Leban nɛ, “Gerzitin can o inoo? Gitaz ci gɛrzɛ kagoonekin ineet ka virayan zooc o? ");
INSERT INTO mur_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Inoko ɔrɔɔŋɔ kaale ogan dook. Mã anyak gi ci ajowa, arek looc bitaala ŋina ka kapaket ageet ɔl cugune o ki ɔl cigan o buk ŋɛnɛɛn ŋaatina ci alɛɛm. ");
INSERT INTO mur_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Karomɛ naana ki ineet irkitok eetom, ma arit ɛɛzana ugune ɔrɔɔt. Ma ŋaan kadak naana mirkic codoi ɛɛzaye ugun been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Baale gɔɔn mã adak kelegiti ɛɛz codoi ɛɛzaye ugun, karuwekin ŋabolo. Mã agɔrɔz agoryaiti ɛɛz codoi ɛɛzaye ugun, karuwekin ŋabolo. ");
INSERT INTO mur_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Iinyaye niceke dook avacan kɔr, ma awudan laju calaŋ kajez ooŋnyak ŋaati kowawɛ ɛɛza ugun. ");
INSERT INTO mur_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Karomɛ naana ki ineet irkitok eetom. Ma kaliŋliŋonekin ineet irkitok amɔnki wec gole ci ka kiryi bɛɛnyugun. Irkitok tɔrkɔnɔm kuwaye ɛɛzaye ugun. Ma alabanan lak amɔtɔ ŋaati abalyɛ kaal o ka waan ruweyan aneet. ");
INSERT INTO mur_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Baal da calaŋ karomena naana ki Jook o jijiya Ibrayim ki baaba Aizak, ɔtɔɔyan waan ole unun kɔkɔm gi ci kakɔyɛ kina. Bar zin Jooi icin piryakzɛt onan, ma acin liŋliŋɔn o kagoonekin naana ineet. Nɔɔnɔ zin nɛɛn baal agernyekin da ineet bilija ka calaŋ agoonekan gi ci gɛr e.” ");
INSERT INTO mur_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Abarizek ni Leban Jakob enek nɛ, “Ŋaai cugune noko bɛɛnyigan gi. Dɔlya cigeec o kibeen ɛɛza akanan aneet. Kaal dook ci acin niina ŋina noko kaal cigan. Alaŋ zin naana inoko kataman gɔl ci ka kooyi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Abon zin inoko naaga kagɔɔn ganɔn. Ija kataadizit biyɛn ci ka gɔɔn kaadai ganɔn cinai o.” ");
INSERT INTO mur_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Odoma ni Jakob bɛ, ma arek looc kibil tɔp. ");
INSERT INTO mur_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ma aduwak ɔl ogin kuluta biyɛn ka kataadizit, ma agɔɔn niigi nɔkɔ. Ivita ni niigi dook adaktɔ ŋaati ona ataadizɔn biyɛn o. ");
INSERT INTO mur_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Ma anek Leban Jakob nɛ, “Biyɛn nicigi ka kizi adaan ŋaatinai.” Akatek ni Leban ŋinite zooze uneeŋ zaar ci kazi Jegar Saaduta. Kɛŋ cin kazi nɛ biyɛn ci adaanto ataadizɔ. Ma akanek buk Jakob ŋinite zooze uneeŋ zaar ci kazi Galeed. Kɛŋ cin atobɔ kibeen we buk. ");
INSERT INTO mur_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ma azi bodo Leban nɛ, “Abon bai acinet Jooi, ma anyet ageet kuzuuti ganɔn cina o ŋaati kaŋɛrɔn noko.” Ma akanonek bodo ŋinite ɛlɛ zaara ci kazi Mizpa. Kɛŋ cin kazi nɛ vaaco ci cinento. ");
INSERT INTO mur_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ma anek Leban Jakob nɛ, “Mã agidi niina bɛɛnyigan, karabɔŋ bar bodo arɔca ŋaai oogi, mayo nuun alaŋ kacinin naana ineet, ga nɔkɔ Jooi acinin ineet. ");
INSERT INTO mur_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Cin di biyɛn ci ona kalot noko kibeen bɛ ona kanyi kibil tɔp e. ");
INSERT INTO mur_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Niigi dook kɛɛk ci ka keŋeret ageet. Alaŋ naana kavardaŋ biyɛn nicoko ka kook kutuguweyin ineet gi ci gɛr. Ma buk niina alaŋ avardaŋa ka ija tuguweyan aneet gi ci gɛr. ");
INSERT INTO mur_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abon bai Jooi o Ibrayim been Nayor apak zɔɔz cinai o.” Ma atɛɛt Jakob terkediin zaare o Jook o baatin Aizak ka kagantɔ niini kibeen Leban. ");
INSERT INTO mur_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Utugu ni niini todoyoi bɛ tadena. Ma awak ɔl ogin been ɔl o Leban dayiin, ma avu adake niigi dook, ma aavtiz ŋinaante zɛɛ ma aalnek tammu. ");
INSERT INTO mur_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ma ŋeere ococo Leban bɛɛnyigin ki dɔl ugeec ŋalyamɔ, ma amayuk nɔɔgɔ kɔtɔɔzɔ yaak kɔkɔm gi ci gɛr akunak. Ɔtɔɔ ni niini imiire ook ole onin. ");
INSERT INTO mur_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Mazi ŋaan awɔ Jakob gɔla nɔkɔ, urumtɔ ki toonnyak ci Joowo. ");
INSERT INTO mur_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Mazi acin niini nɔɔgɔ izi nɛ, “Nici ŋinti abaai Jooi.” Akatek ni ŋinito zaar ci kazi Maanaam. Kɛŋ cin kazi nɛ ŋinti aalyo. ");
INSERT INTO mur_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ma itoon Jakob ɔl karaktɛ kɔɔt ŋaati gɔtɔnɔn Esɔ ŋaao kazi Edom. ");
INSERT INTO mur_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ma aricanek niini nɔɔgɔ kɔɔt kenektek nɔɔnɔ nɛ, “Manygɔn, aneeta Jakob o keen gabaren unun nɛɛn ci kitoonekin otok o. Kook kabaawa ŋaati Leban ŋinti rɛɛn zɛɛ been nɛɛn ci kakunɛ noko. ");
INSERT INTO mur_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Inoko zin kanyawa tiin ki zigire ki ɛɛza been gabara. Manygɔn, kitoonekin zin ineet molok o kanɛ coma atalnanan.” ");
INSERT INTO mur_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ɔɔtɔ ni ɔl ci ona itoon Jakob o. Mazi avɔ abada, ivita enektek nɔɔnɔ nɛ, “Koota ŋaati gotonon Esɔ. Inoko zin aku ka ivita urumtɔ ki ineet. Ɔrkɔra niini ki ɔl cigin een eet tur lak wec (400). ");
INSERT INTO mur_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Mazi azii Jakob zɔɔz nico, anyawun ŋoliin ɔrɔɔt. Ma aŋɛr ɔl cigin o lak ram. Buk ɛɛza ki tiin been nyakalɛt aŋɛr lak ram. ");
INSERT INTO mur_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Abaaban niini azi nɛ, “Mã aku Esɔ, ma aŋozonek ɔl ci oowu e, ŋaan avir ɔl ci vurto o.” ");
INSERT INTO mur_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Aŋarowɔ ni Jakob izi nɛ, “Jook o jijiya Ibrayim been baaba Aizak, ineet nɛɛn baal anekan nɛ, Miire bitɔ looce unun aavtiyɛ atenowa ugune. Ŋaan kagoonekin ineet kaal dook kɔtɔɔzɔ juruŋ e. ");
INSERT INTO mur_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ma naana keen gi ci cɛlbɛz labak, bar zin ineet nɛɛn o anyan aneet bonat ci appe ɔrɔɔt iinya dook. Iiten baal kabaakzanɛ liil o kazi Jordan e akɔm kaal ci kanyei, bar waanice kanyei kɛɛt ci omtinto doon. Bar inoko zin kanyawa burɛn ceen ram noko. ");
INSERT INTO mur_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kajinin zin ineet ka ɛɛlawan niina aneet ŋaaten gɔtɔna Esɔ. Kanyei ŋoliin, karabɔŋ tedec aku niini, ma aŋozoneket ageeta dook, ŋaanɛ kibeen dɔl buk. ");
INSERT INTO mur_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Lam gi ci gɛr calaŋ akunaket. Aga niina baale eterkedeyan niina aneet gi ci ka tuguwi kaal dook kɔtɔɔzɔ juruŋ ŋaaten aneet, ma aterkedekan buk dɔl ci dɔl cigan meel atobɔ been kazac.” ");
INSERT INTO mur_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ɛŋɛra ni Jakob kaale ogin abal oogi ka kanyek Esɔ ceen gɔtɔni o. ");
INSERT INTO mur_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Aŋɛra niini bawɔ ci ŋai een eet tur lak ram (200), been kɔnyi ceen eetom (20), ki aza ci ŋai een eet tur lak ram (200), been mirkici ceen eetom (20), ");
INSERT INTO mur_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ki nyakalɛt ci ŋai eetom kamɔtɔ (30) been jɔrɔ cigeec, ki tiin ci ŋai eet ram (40), been olenya amɔtɔ (10), ki zigire ci ŋai een eetom (20), been ci macik amɔtɔ (10). ");
INSERT INTO mur_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ɛŋɛr ni niini nɔɔgɔ kizi burɛn, ma anyek gabara ogin kɛbɛk gɔɔn ceeni buri codoi. Ma anek niini nɔɔgɔ nɛ, “Araktɛ ŋaatan. Ɔtɔɔz edeyɔ ŋaati aluugju burɛn nicoko o.” ");
INSERT INTO mur_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ma aricanek Jakob gabaren ci oowu e zɔɔz ci anek nɛ, “Ma arumonu ki gɔtɔna Esɔ, ma ajinin azi nɛ, Alaan cun ŋɛnɛ? Akɔ ŋaaḏaŋ? Tiin ci ŋɛnɛ ci aluugɛ o?, ");
INSERT INTO mur_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","abona abɛdɛkɛ niina nɔɔnɔ anei nɛ, Kaala nici dook kaal cugun. Itoonakin gabarɛnti unune kazi Jakob. Ŋaan niinilya awoya ageeta vurta.” ");
INSERT INTO mur_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ma aricanek buk niini gabara o anowa gɔn nico vurta gi ci anek nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ma anek niini nɔɔgɔ nɛ, “Abona aziyu nɛ, Gabaren unun Jakob ŋaan awoya ageeta vurta.” Abaaban Jakob azi nɛ, “Abon kadiziyi nɔɔnɔ kaale nicoko ka katalɔ ŋaatan ka ma tedec karumona ki nɔɔnɔ ka calaŋ agoonekan gi ci gɛr.” ");
INSERT INTO mur_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Itoon ni niini kaal nicoko karaktɛ ŋaatin. Ma ɔɔŋ niini baalin vurta ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ma baaline nice ɛlɛ icinɛ Jakob, ma itoon ŋaai ogin arɔca een ram ki ŋaai ogin aavtiz been dɔl ogin een amɔtɔ codoi ka kɔɔt kabaayizit liil o kazi Jabok. ");
INSERT INTO mur_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ma bodo vurta itoonun buk niini kaal ogin dook kɔɔt baagita. ");
INSERT INTO mur_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Aavu ni ŋinaante niini doon. Ma aku ɛɛti oman baaline nice ŋinaante, ma acɔdɔ ki nɔɔnɔ zɛɛ ma arire lɔɔci. ");
INSERT INTO mur_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Mazi akɔ acin ɛɛti nici akɔmnek nɔɔnɔ Jakob ŋaati amɔgi, alaca niini Jakob wanoc kopocai. ");
INSERT INTO mur_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mazi ŋaan atorkot Jakob nɔɔnɔ nɔkɔ, enek niini Jakob nɛ, “Aalun tammu. Toŋawan kɔtɔɔ.” Bar abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Mã ŋaan rak mayuwan niina aneeta, alaŋ kooŋnanin.” ");
INSERT INTO mur_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ijin ni ɛɛti nici nɔɔnɔ enek nɛ, “Kazi ineet zaar cugun nɛ?” Ma abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Kazi zaar cigan nɛ Jakob.” ");
INSERT INTO mur_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Enek ni ɛɛti nici nɔɔnɔ nɛ, “Alaŋ bodo kazi zaar cugun nɛ Jakob. Bar akatozeyin ineet zaara ci kazi Israyil. Kɛŋ ci zaar nicoko kazi nɛ acɔdɔ ɛɛti ci deer ki Jook, eeci acodonu niina ki Jook been buk ɔl o deer, ma amogi niina nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Enek ni Jakob nɔɔnɔ nɛ, “Duwayan buk zaar cugun.” Bar anek niini Jakob nɛ, “Naa arooŋ gawan zaar o?” Amayuk ni niini Jakob. ");
INSERT INTO mur_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Enek ni Jakob ɛlɛ onin maany nɛ, “Kicina ŋum o Joowo naanalya, ma bar ŋaan karogi labak.” Ma akanek niini ŋinito zaar ci kazi Penal. Kazi kɛŋ cin nɛ ŋum o Joowo. ");
INSERT INTO mur_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Mazi adɔŋnyai ii, ɔtɔɔ Jakob ŋaati kazi Penal noko, ma ayɛt eeci alacai nɔɔnɔ wanoci. ");
INSERT INTO mur_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Zin giye nico alaŋ ɔl o Israyil adak korɔ o arom anyɔtɔn ki wanoc zɛɛ been inoko o, eeci korone nicoko opoca Jooi Jakob wanoc. ");
INSERT INTO mur_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ma awɔ Jakob zɛɛ mazi aara kɛbɛrɛ, acin Esɔ aku ɔrkɔra ki ɔl ceen eet tur lak wec (400). Eŋerek ni niini dɔl ogin yaatigeec. ");
INSERT INTO mur_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ma anyek ŋaai ogin aavtiz been dɔl ugeec karaktɛ ɔɔwa. Ma ano Leya been dɔl ogin. Aje Recal been Josev aṯornɛkɛ niigi vurta. ");
INSERT INTO mur_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Arayɛ ni Jakob niinilya nɔɔgɔ dook ɔɔwa. Mazi akɔ ajɔŋɔz gɔtɔni, oloca ɔɔ lak torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bar Esɔ adokonyonek nɔɔnɔ arumek gɔl, ma akɔ atorkot nɔɔnɔ azɛɛnɛ dook, ma acoco ŋalyamoc. Ma adɔta luwa niigi dook ramantiya. ");
INSERT INTO mur_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Mazi aara Esɔ kɛbɛrɛ, acin ŋaai ci avu kibeen dɔl. Ma ajin niini Jakob anek nɛ, “Ɔl ci ŋɛnɛ nici?” Abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Manyi, nici dɔl cigan anyan Jooi bonate onin.” ");
INSERT INTO mur_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ivita ni ŋaai oginɛ aavtiz been dɔl ugeec, ma avu aloca ooti. ");
INSERT INTO mur_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ma aku Leya been dɔl ogin, ma aku buk Recal been Josev, ma avu aloca niigi dook ooti ŋaati Esɔ. ");
INSERT INTO mur_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ma ajin Esɔ Jakob anek nɛ, “Ma burɛna o karumona gɔla o burɛn ci ŋɛnɛ?” Abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Manyi onan, burɛn cugun. Kanyin naana ineet ka talɔ ŋaatan.” ");
INSERT INTO mur_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Bar abɛdɛkɛ Esɔ nɔɔnɔ anek nɛ, “Dole o yaai, kanyei naana kaal ci kaleenona. Zooti nicoko nyak kizi cugun.” ");
INSERT INTO mur_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ma anek Jakob nɔɔnɔ nɛ, “Mã areezan niina aneet didi, abon agama kaal ci kanyin naana ineet o. Ma kacin naana ŋum cun noko bar kizik kacin Jook, eeci inoko niina atalnanan aneet. ");
INSERT INTO mur_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ɛɛlawan gama kaal ci kanyaakin ineet noko, eeci uzuutan Jooi aneet bonate onin, ma anyan kaal o karooŋ dook.” Ma adaŋek Jakob nɔɔnɔ kaal nicoko zɛɛ makacin agama. ");
INSERT INTO mur_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Enek ni Esɔ nɔɔnɔ nɛ, “Lot kaal ka kɔtɔɔz. Abon kɔrkɔr naaga dook.” ");
INSERT INTO mur_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","14","Bar abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Inoko rayɛ niina labak. Ŋaan kanuyin kidicilim ka kiito dɔl been tiin kidicilim zɛɛ ma kakɔ karumnyin ineet ŋinaante. Aga niina kaal ceen dɔl noko ŋaan anyɛlnyɛl. Ma buk maala ceen gɔla noko ki nyɔɔ ci miliny noko ipirta weeta. Mã kadaŋek nɔɔgɔ weet mayo nuun kawɔ iiten codoi, adaai koca.” ");
INSERT INTO mur_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ma anek Esɔ Jakob nɛ, “Nyan zin kotoŋeyin ineet ɔl cigan oogi ka kitiritin.” Bar abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Akɔm dole o yaai. Ɔɔtɔ ki ɔl cugun o labak. Olla uyen karooŋnyin naana ineet talɔ ŋaatan.” ");
INSERT INTO mur_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ma iitene nice ɛlɛ imiire Esɔ ook Edoma looce onin. ");
INSERT INTO mur_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ook ni Jakob ŋaao kazi Sɛkɛs, ma akɔ ɛɛnyca ceez ceen ḏoor been buk luwayanɛ ci tiinu. Ma kɛŋ ci zaar ci kazi Sɛkɛs o kazi nɛ luwayanɛ. ");
INSERT INTO mur_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Iiya ni Jakob looce o kazi Mesopatamiya yaak zɛɛ ma aku arum kutur o kazi Cekam aavi looce o kazi Kanan. Ma aal ŋaati ajɔŋɔz kutur nice. ");
INSERT INTO mur_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ma akɔ ataala niini ŋinti ka kabaayi ŋaati dɔl ci dɔl o Amor. Ataala niini ŋinite zurtenene ceen eet tur (100). ");
INSERT INTO mur_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ma ɛɛnyca ŋinti ka kidiŋdiŋani Jook ŋinaante, ma akanek ŋinito zaar ci kazi Ɛl Eloye Israyil. Kɛŋ ci zaar nicoko kazi nɛ Jook o Israyil anyak dɔyiz. ");
INSERT INTO mur_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ma iitene oman itiŋgazɔ Dina ween tinati Jakob been Leya arɔɔŋ niigi kɔɔt kicinit dɔl ci looc ci kazi Kanan o. ");
INSERT INTO mur_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Maje ŋinaante anyak alaan ci looc nice kazi zaar nɛ Amor ceen niini borit ci ɔl o kazi Avit. Anyak niini ŋɛɛrin ci kazi Cekam. Mazi akɔ acin Cekam Dina, oŋozozek nɔɔnɔ, ma anyek kizi ŋaa dɔyiza. ");
INSERT INTO mur_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Bar mazi acin niini dole alinak nɔɔnɔ nɔkɔ, ereezun ɔrɔɔt ɛlɛ, ma arɔɔŋ kimiciz. ");
INSERT INTO mur_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ma anek baatin nɛ, “Karooŋnyin bitɔ ole ci baati dole nico, ka jinɔ nɔɔgɔ kanycin ka kiriyi nɔɔnɔ kizi ŋaa can.” ");
INSERT INTO mur_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Mazi akɔ azii Jakob gi o agoononek bɛɛnyin, otobor niini nɔŋ ɔrɔɔt ɛlɛ, maje lɔgɔz oginɛ ŋaan aavtiz tiini tuuwa, ma akɔm niini gi ci agɔɔn zɛɛ ma abada niigi. ");
INSERT INTO mur_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Mazi abada lɔgɔz towawiinta, iziiyit buk niigi gi o anyekɛ Cekam ŋɔɔni kizi ŋaa dɔyiza, ma abor niigi nɔŋ ɔrɔɔt, eeci anyaak gi nici ɔl o Israyil alyaan ci appe ɔrɔɔt. Ma akunak Amor ceen baati Cekam o Jakob ka kiiya kɔzɔɔztɔ ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ma anek Amor Jakob nɛ, “Arɛɛz ŋɛɛran o kazi Cekam bɛɛnyun ɔrɔɔt. Inoko abon anyekan niina nɔɔnɔ dole kiriyi. ");
INSERT INTO mur_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Abon karɔcɔ naaga dɔl. Nyet niina ageeta kirikta bɛɛnyugun, ma buk ariyɛ niina dɔl cigaacak o. ");
INSERT INTO mur_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ka zin baak niina ŋaatinaaŋ ŋina ka tugu kaal ci olla arooŋ niina tugu.” ");
INSERT INTO mur_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ma anek buk Cekam baati Dina been gɔtɔnɔgi Dina nɛ, “Abona anyaŋ dole kiriyi. Ŋaan kanyuŋ kaal ci olla arooŋnyu niiga. ");
INSERT INTO mur_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Uduktayaŋ kaal ci olla arooŋnyu kuruwayuŋ, mayo nuun aŋabakaŋ kaal ci ka kuruwayuŋ, ŋaan kanyuŋ labak. Anycaŋ dole kiriyi.” ");
INSERT INTO mur_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Maje giye o anyekɛ Cekam dole alyaan, abarzek gɔtɔnɔgi dole Cekam been baatin Amor gole ci alaban. ");
INSERT INTO mur_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Anek niigi nɔɔgɔ nɛ, “Alaŋ kanimnya naaga kanyceya ŋɔɔna kiriyi ɛɛti calaŋ ateedi. Mã kagoona nɔkɔ, een oca gi nici alyaan ŋaatinaaŋ ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kagamana naaga zɔɔz nico ŋaati ateedinu niiga buk kiyo naaga o. ");
INSERT INTO mur_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Mã agoonu nɔkɔ, kagamana koca naaga kɔrɔcɔ ki igeet dɔl labak, ma kabaaka ŋaatunooŋ ŋina kiziti ɔl codoi. ");
INSERT INTO mur_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bar mazi alaŋ agoonu nɔkɔ, kavoya koca naaga dole cinaaŋ o.” ");
INSERT INTO mur_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Agamta ni Amor kibeen ŋɛɛrin Cekam zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ma alaŋ arɔɔŋ Cekam kaavu ŋinti rɛɛn, bar arɔɔŋ kiyiik kook kutugu gi nico kataman, eeci arɛɛz niini tinati Jakob ɔrɔɔt. Ma buk adiŋdiŋ niini ole ween atenok ogin ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ɔɔtɔ ni Amor been ŋɛɛrin Cekam ŋaao gɔɔn aminyi ɔl zoozok. Ma avɔ aduwak niigi ɔl ugeec kuturo dook gi nico. Anek niigi nɔɔgɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ɔl ci Israyil noko ɔl ci abon ɔrɔɔt. Inoko anycek nɔɔgɔ kabaayitɔ ŋina labak ka buk kutuguzɔ niigi kaal ci arɔɔŋ. Appe lɔɔci cinai o, ma aganɔ ki nɔɔgɔ buk ŋaati abaayi labak. Abon zin kavɔ karɔc naaga dɔl cigeec o, ma buk arɔc niigi dɔl cigaac o. ");
INSERT INTO mur_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Anyak olla gi codoi ṯɔr nɔkɔ. Mã kateedi naaga ɔl ci mac o dook kiyo niigi o, agama koca niigi baayiz ŋaatina kiziti ɔl codoi. ");
INSERT INTO mur_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mã kagɔɔn nɔkɔ, koca tiina cigeec o dook ki kaalyan ugeec oogi izi cigaac.” ");
INSERT INTO mur_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Agamta ni ɔl o kuturo dook zɔɔz ci aduwak Amor been Cekam nɔɔgɔ o, ma ateedi ɔl o mac dook. ");
INSERT INTO mur_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ma iinyaye ceen iiyu ma ŋaan amɔɔr niigi nɔkɔ, itiŋgazɔ lɔgɔz o Jakob een ram kazi Simiyan been Livai ween gɔtɔnɔgi Dina o yaatin, odomta niigi dilanya, ma anik avɔ kuture nice, ma avɔ aruk ɔl o mac dook kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ma aruk buk niigi Amor been ŋɛɛrin Cekam kadaayitɔ. Ma ajowa niigi Dina ole o Cekam, ma anyaak nɔɔnɔ kɔrɔk uneeŋ. ");
INSERT INTO mur_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ma vurte ci aruwɛn ɔl nici kadaayitɔ o, itiŋgazɔ bodo lɔgɔz o Jakob ogɛnɛ ɔɔtɔ kuture nice, ma avɔ anyaa kaal o kutur nice dook ka kizi cacinɛt ci alyaan o ŋɔɔni uneeŋ. ");
INSERT INTO mur_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Anyaa niigi ɛɛza ki tiin ki zigire kibeen kaal o kuturo dook kurum o ɛɛl manɛɛni buk. ");
INSERT INTO mur_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ma anyaa kaal o abona dook, ma agama ŋaai ki dɔl, ma anyaa kaal dook ceezinɛ. ");
INSERT INTO mur_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Enek ni Jakob Simiyan been Livai nɛ, “Anyaaktayaŋu niiga aneet gi ci gɛr. Inoko ɔl ci Kanan o ki ɔl o Periza ki ɔl ci loocok nicoko o dook amartɔyan tiŋeere niigi aneet. Maje naana alaŋ kanyei ɔl ci meelik. Mã arom niigi dook eleeti, ma agaŋnyakan aneet, adica koca niigi ɔl cigaac noko dook kezeectɔ.” ");
INSERT INTO mur_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bar abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Alaŋ zin buk abon ŋaati agɔɔni ɛɛti nici ŋɔɔna kiyo waaŋnyaiti o.” ");
INSERT INTO mur_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ma iitene oman enek Jooi Jakob nɛ, “Luuk ŋina taman bitɔ kuture o kazi Bezal ka bitɔ baak ŋinaante. Bitɔ tɛɛnyayan ŋinti taabinta ŋinaante. Aneet Jook baal kayelzakin ɛlɛ iitene baal avirɛ niina gotonu Esɔ e nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Enek ni Jakob ɔl o kɔrɔk onin been ɔl o aromɛ ki nɔɔgɔ dook nɛ, “Otoŋit joowanɛ o adilanu. Abon adaalu eleeti ugooc, ma areku rumanɛ ci colai, ka obonta ŋume o Joowo. ");
INSERT INTO mur_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Inoko zin kitiŋgaz kuluugit kɔɔtɔ Bezala. Mã kavɔ karum ŋinite, kakɔ kɛɛnyca naana ŋinti ka kidiŋdiŋanti naaga Jook baal atiritan aneet iitene o kapirnanɛ e. Nɔɔnɔ nɛɛn o korkorya ki aneet vitɛnanɛ o kakɔyɛ dook.” ");
INSERT INTO mur_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Anycek ni niigi Jakob joowanɛ o adilya dook been buk awac ugeec dook. Ma akɔ adawek niini kaal nicoko moloktoc o ajɔŋɔz ŋin o kazi Cekam loota. ");
INSERT INTO mur_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Mazi aluuk Jakob been lɔgɔz ogin, anyayit ɔl o ajɔŋɔz kutur nice ŋoliin ci appe, ma alaŋ niigi arɔɔŋ koorit nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ivitak ni Jakob been ɔl ogin dook ŋino kazi Luz abil looce o kazi Kanan. Inoko agayi kutur nice zaara ci kazi Bezal. ");
INSERT INTO mur_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ɛtɛɛnya ni niini ŋinti taabinto ŋinaante, ma akanek ŋinite zaar ci kazi Jook o Bezal, eeci baale ayelzak Jooi nɔɔnɔ ɛlɛ ŋinaante iitene baal aviri niini gɔtɔni e. ");
INSERT INTO mur_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ma ŋinaante adaak ŋaa o kazi Debora baal gɔɔn azooni Rebeka e. Ma ada niigi nɔɔnɔ moloktoc loota Bezala ŋinaante. Ma akanek ŋinito zaar ci kazi Moloktoc o Luwanto. ");
INSERT INTO mur_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Baale rak amayuwun Jooi Jakob Bezala ŋina waanbaal aviri niini gɔtɔni e. Mazi bodo abadaak niini Bezal vurta e, eyelizak Jooi nɔɔnɔ ɛlɛ, ma amayuk nɔɔnɔ bodo ŋina. ");
INSERT INTO mur_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ma anek Jooi nɔɔnɔ nɛ, “Kazi zaar ugun laadun nɛ Jakob. Bar zin inoko kakateyin ineet zaar ci kazi Israyil.” ");
INSERT INTO mur_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ma amayuk Jooi nɔɔnɔ anek nɛ, “Keen naana Jook o kanyei dɔyiz dook. Zaacɛ, nyak dɔl ci meelik ka izi borit ci aritan boryowa. Ma buk een baati alaatu. ");
INSERT INTO mur_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ŋaan kanyin ineet looc ci baal katerkedei Ibrayim been Aizak noko. Ma ŋaan kanyi buk ŋinito dɔl ki dɔl cugun vurte cun.” ");
INSERT INTO mur_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","14","Mazi awɔ Jooi ŋinaante, ipik Jakob bɛ kibil tɔp, ma adiŋdiŋan Jook ŋaati aḏuutɛkɛ bɛ nico nyaan been maal ci kiŋiroco. ");
INSERT INTO mur_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ma akatek ni niini waanice ŋinito zaar ci kazi Bezal. ");
INSERT INTO mur_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ma iitene oman uluugit Jakob been ɔl o kɔrɔk onin Bezala. Mazi ka kurumit niigi Evrat, izi ŋinti ka kotoyai Recal, ma aam nɔɔnɔ dole ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Mazi ŋaan atɔɔt nɔɔnɔ dole ɔrɔɔt nɔkɔ, enek ŋaa o gɔɔn agama gɔnɔgi dɔl Recal nɛ, “Má anyei ŋoliin. Inoko tedec ookca ŋɛɛrun oma.” ");
INSERT INTO mur_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Mazi akɔ ookcai niini, adavyai ɔrɔɔt ɛlɛ. Ma akanek ŋɛɛrin nico zaar ci kazi Benoni o kazi kɛŋ cin nɛ piryakzɛt onan. Bar baatinɛ akanek nɔɔnɔ zaar ci kazi Bɛnjimɛn o kazi kɛŋ cin nɛ aziit onan azo. ");
INSERT INTO mur_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Adaak ni Recal. Ma ada ɔl nɔɔnɔ gɔl o akɔ ki Evrat kabanyca. Inoko ŋinito waanico kazi zaar nɛ Bɛzilɛm. ");
INSERT INTO mur_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ma apik Jakob bɛ kibil tɔp ŋinaante ka kizi gi ci gɔɔn aadanɛ niini Recal. Ŋaan abil bɛ nici tɔ ŋinaante zɛɛ been inoko o. ");
INSERT INTO mur_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Uluuk ni Jakob ŋinaante bodo, ma akɔ aal vaaco o wun kazi Eder libire ci gɔl. ");
INSERT INTO mur_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Mazi akɔ abaak Jakob looce nice, iŋiliz Robɛn ŋaa o baatin aavtiz kazi Bila. Iziik ni baatinɛ zɔɔz nico, ma abor nɔŋ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Anyak Jakob lɔgɔz amɔtɔ ram. Lɔgɔz ci ŋaa onin kazi Leya nɛɛn Robɛn ki Simiyan ki Livai ki Juda ki Isikar been Zibolon. Zin Robɛn abuu gonogin dook. ");
INSERT INTO mur_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Lɔgɔz ci ŋaa onin kazi Recal nɛɛn Josev ki Bɛnjimɛn. ");
INSERT INTO mur_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Lɔgɔz ci ŋaa onin aavtiz kazi Bila een gabaren o Recal nɛɛn Dan been Navtali. ");
INSERT INTO mur_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lɔgɔz ci ŋaa onin aavtiz kazi Zilpa een gabaren o Leya nɛɛn Gad been Acar. Aritai lɔgɔz nici dook looce o kazi Mesopatamiya. ");
INSERT INTO mur_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Zin ook Jakob ole o baatin Aizak ŋaao kazi Mamra ajɔŋɔz Ebiron ŋaa baal abaai jijitinɛ Ibrayim been baatin Aizak e. ");
INSERT INTO mur_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Mazi akɔ een irkitowa o Aizak eet tɔrkɔc (180), adaak niini kanyatiz, ma ada nɔɔnɔ lɔgɔz oginɛ kazi Esɔ been Jakob. ");
INSERT INTO mur_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ceegi dɔl ci dɔl o Esɔ o akanonek nɔɔgɔ zaara o kazi Edom. ");
INSERT INTO mur_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Arɔca niini ŋaai ogin ole o kazi Kanan. Kazi ŋaa onin een abuu nɛ Ida. Niini tinati Elon o ɔl o kazi Ititaz. Bodo ŋaa oma kazi zaar nɛ Olibama niini tinati Anaa ween ŋɛɛrti Zibon o ɔl o kazi Ititaz. ");
INSERT INTO mur_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ŋaa oma kazi zaar nɛ Basmat niini tinati Ismayil, ma een ŋɔɔni Nebat. ");
INSERT INTO mur_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ida ookca Elivaz. Aje Basmat ookca Rul. ");
INSERT INTO mur_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama ookca Juc ki Jalam been Kora. Nicigi dook lɔgɔz o Esɔ aritai looce o kazi Kanan. ");
INSERT INTO mur_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ma akɔyi Esɔ ŋaai ogin ki lɔgɔz ogin ki bɛɛnyigin kibeen ɔl o kɔrɔk onin dook been tiin ki ɛɛza o abala looce nice dook, ma aluuk ŋaati gɔtɔnɔn Jakob, ma akɔ looce oman. ");
INSERT INTO mur_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Aluuk niini o, eeci lɔɔci ci abaai niini been Jakob o alaŋ alɛɛnɔ ki nɔɔgɔ dook, eeci abale niigi ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ook ni abaak Esɔ biyene o ŋino kazi Edom. ");
INSERT INTO mur_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ceegi zin dɔl ci dɔl o Esɔ ween jijiti ɔl o kazi Edom. Aritai niigi looce ween biyɛn kazi Siir. ");
INSERT INTO mur_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Zaar zin cigeec nɛɛn ceegi. Elivaz niini ŋɛɛrti Esɔ o arita ŋaawe onin kazi Ida. Maje Rul ŋɛɛrti Esɔ o arita ŋaawe onin kazi Basmat. ");
INSERT INTO mur_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iiya ni Elivaz itira lɔgɔz ogin een tur kazi Teman ki Omar ki Zivo ki Gatam been Kenaz. ");
INSERT INTO mur_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Bodo ŋaa o Elivaz aavtiz kazi Tima aritak nɔɔnɔ ŋɛɛrin ci kazi Amilek. Nicigi dɔl ci dɔl o ŋaa o Esɔ kazi Ida nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Maje Rul iiya anyawun niini lɔgɔz wec ci kazi Nakat ki Zera ki Cama been Miza. Nicigi dɔl ci dɔl o ŋaa o Esɔ kazi Basmat. ");
INSERT INTO mur_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Bodo ŋaa o Esɔ kazi Olibama een tinati Anaa ween ŋɛɛrti Zibon ookca niini lɔgɔz iiyu, Juc ki Jalam been Kora. ");
INSERT INTO mur_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ceegi baatigi boryok ci dɔl o dɔl o Esɔ. Ŋɛɛrti Esɔ ween abuu kazi Elivaz izi niini baati boryok o kazi Teman ki Omar ki Zivo ki Kenaz, ");
INSERT INTO mur_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ki Kora ki Gatam been Amilek. Nicigi dook dɔl ci dɔl o ŋaa o Esɔ kazi Ida. ");
INSERT INTO mur_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ŋɛɛrti Esɔ o kazi Rul iiya izi baati boryok o kazi Nakat ki Zera ki Cama been Miza. Nicigi dook dɔl ci dɔl o ŋaa o Esɔ kazi Basmat. ");
INSERT INTO mur_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Maje Olibama arita niini boryok o kazi Juc ki Jalam been Kora. ");
INSERT INTO mur_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Boryowa nicigi dook dɔl ci dɔl o Esɔ. ");
INSERT INTO mur_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ceegi zin dɔl ci dɔl o Siir ween borit o ɔl o kazi Orit baal laadun abaak niini baale looce nice e. Dɔl ci dɔl ogin nɛɛn Lotan ki Cobal ki Zibon ki Anaa ki Dicon ki Ezer been Dican. Niigi dook lɔgɔz ci Siir. Ivita ni niigi iziti ooti ci boryok o kazi Orit looce o kazi Edom. ");
INSERT INTO mur_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lɔgɔz ci Lotan nɛɛn Ori been Iman. Maje Timan niini ŋɔɔni Lotan. ");
INSERT INTO mur_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Dɔl ci dɔl o Cobal nɛɛn Alvan ki Manaat ki Ebal ki Cevo been Onam. ");
INSERT INTO mur_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibon niini anyak lɔgɔz ram ci kazi Olya been Anaa. (Anaa nɛɛn baal ajowa lɔtitoc o anyak maam o abur balala iitene baal owawi niini zigire o baatin e.) ");
INSERT INTO mur_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Anaa iiya izi niini baati Dicon ween jijiti boryok o kazi Imdan ki Ecban ki Tiran been Ceran. Anaa buk anyak ŋɔɔni ci kazi Olibama. ");
INSERT INTO mur_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer iiya izi niini jijiti boryok o kazi Bilaan ki Zavan been Okan. ");
INSERT INTO mur_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dican iiya izi jijiti boryok o kazi Uz been Oran. ");
INSERT INTO mur_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ceegi zin zaar o boryok o kazi Orit o looc o kazi Edom, Lotan ki Cobal ki Zibon ki Anaa ki Dicon ki Ezer been Dican. ");
INSERT INTO mur_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ceegi zaar ci alaat o abal looc o kazi Edom waanbaal ŋaan kanyayi Israyil alaat e. ");
INSERT INTO mur_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela ween ŋɛɛrti Bozor abal niini looc o kazi Edom, ma een kutur cin adikir nɛɛn ŋino kazi Dinaba. ");
INSERT INTO mur_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Mazi adaai Bela e, irigiz nɔɔnɔ Jobab ween ŋɛɛrti Zera o looc o kazi Bozra. ");
INSERT INTO mur_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Arigiz Jobab Acam o looc o kazi Teman. ");
INSERT INTO mur_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Arigiz Acam Adad ween ŋɛɛrti Bedad o looc o kazi Avit. (Nɔɔnɔ nɛɛn baal amɔk ɔl o kazi Midiyan oroonte o kutur o kazi Mowab e.) ");
INSERT INTO mur_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Arigiz Adad Samla o looc o kazi Masrika. ");
INSERT INTO mur_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Arigiz Samla Cul o looc o kazi Ribot. ");
INSERT INTO mur_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Arigiz Cul Balanan ween ŋɛɛrti Acbor. ");
INSERT INTO mur_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Arigiz Balanan Adad o looc o kazi Pawu. (Ŋaa cin nɛɛn o kazi Mitabel ween tinati Matrid ween tinati Mizab.) ");
INSERT INTO mur_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Zin Esɔ niini jijiti boryok o looc o Edom kazi Timan ki Alva ki Jetet ki Olibama ki Ɛlaa ki Pinon ki Kenaz ki Timan ki Mibzar ki Magdel been Iram. Ma loocok o abaai niigi dook akanonek zaara ugeecik. ");
INSERT INTO mur_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ma amɛna Jakob abaak looce o kazi Kanan ŋaabaal abaai baatinɛ baale e. ");
INSERT INTO mur_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ceeni zin zɔɔz ci akati dɔl o Jakob. Mazi akɔ een Josev irkitowa amɔnki torgɛrɛm, otowawɔ niini ɛɛzai been gɔtɔnɔgi o ŋaai o baatin aavtiz kazi Bila been Zilpa. Ma iitene oman iiya uduwak Josev baatin kaal o gɛr agɔɔn gɔtɔnɔgja. ");
INSERT INTO mur_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Maje Jakob arɛɛz Josev ɔrɔɔt kujuk lɔgɔz ogin oogi, eeci aritai niini waanu izɔi niini matuwoc. Ma arɔɔŋak niini nɔɔnɔ rum ci anyak golnya ci alina ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mazi acin gɔtɔnɔgja baatineeŋ arɛɛz Josev ɔrɔɔt kujuk nɔɔgɔ nɔkɔ, amartɔi niigi Josev ɔrɔɔt ɛlɛ calaŋ amici niigi ki nɔɔnɔ zinzeetine ci vɔɔr. ");
INSERT INTO mur_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ma baaline oman uwunozɛ Josev. Mazi akɔ aduwak niini gɔtɔnɔgi wunozyak nicoko, amartɔi niigi nɔɔnɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Anek niini nɔɔgɔ nɛ, “Iziiyit di wunozyak ci kawunozei ce. ");
INSERT INTO mur_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Bar kizik naaga dook katɛɛt labi mana. Ma iŋaaz kaŋaya ci labi ci kateedi naana o keelit jena tɔp. Ma avu aliya kaŋaya cugooc o cigan o, ma alocak nɔɔgɔ ooti.” ");
INSERT INTO mur_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Enektek ni gɔtɔnɔgja nɔɔnɔ nɛ, “Awaaŋ! Yo abaaban niina kizik katin een alaan cinaaŋ?” Amartɔi ni niigi nɔɔnɔ ɔrɔɔt ɛlɛ, eeci aduwak niini nɔɔgɔ wunozyak cigin o. ");
INSERT INTO mur_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ma iitene oman uwunozɛ Josev bodo, ma aku anek gɔtɔnɔgi nɛ, “Kuwunozɛ bodo. Kizik kacin ii ki nyelok been monyony ceen amɔnki codoi aloca ooti aneeta ŋuma.” ");
INSERT INTO mur_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ma aduwak buk niini wunozyak cigin noko baatin, bar agernyek baatinɛ nɔɔnɔ, ma anek nɛ, “Wunoza nici akati kɛŋ cinɛ naa? Yo abaaban kizik katin naana ki yaatun kibeen gotonogu kavunakin ineet, ma kalocana ooti ŋaatun?” ");
INSERT INTO mur_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Enico anyaktek Josev gɔtɔnɔgja tɛl ɔrɔɔt ɛlɛ, maje baatinɛ azooni zɔɔz nico ziniza. ");
INSERT INTO mur_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ma iitene oman ooti gɔtɔnɔgi Josev ɛɛza ŋaati ajɔŋɔz Cekam. ");
INSERT INTO mur_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Enek ni Jakob Josev nɛ, “Karooŋnyin bitɔ Cekama ŋaao owawi gotonogu ɛɛza.” Ma abɛdɛkɛ Josev nɔɔnɔ anek nɛ, “Abona. Ŋaan kakɔ.” ");
INSERT INTO mur_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ma anek baatinɛ nɔɔnɔ nɛ, “Bitɔ ka cin gotonogu mã aavtiz yaak, ka buk cin mã ɛɛl ɛɛzana dook tɔ. Mazi ook icinu nɔɔgɔ, bada ka ija duwayan.” Itiŋa ni niini ŋaao abaai niigi kazi Ebiron ka kook Cekama ŋaao owawi gɔtɔnɔgja ɛɛza. ");
INSERT INTO mur_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Mazi akɔ arum Josev Cekam, icinun ɛɛti oman nɔɔnɔ ŋaati olla awɔyi anoti ḏoritot kɛŋ, ma ajin ɛɛti nici nɔɔnɔ anek nɛ, “Arooŋ dim naa?” ");
INSERT INTO mur_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ɛbɛdɛkɛ ni niini nɔɔnɔ enek nɛ, “Karooŋ gɔtɔnɔga cigan owa ɛɛza ŋina. Duwayan da mã aga ŋinti aavtizɛ.” ");
INSERT INTO mur_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Anek ɛɛti nici nɔɔnɔ nɛ, “Ɔtɔɔzɔ inoko. Kazii uyene nɔɔgɔ anɔ nɛ, Kɔɔtɔ ŋaao kazi Dozan.” Iviri ni Josev gɔtɔnɔgi zooc zɛɛ ma akɔ ajowa nɔɔgɔ ŋaati kazi Dozan noko. ");
INSERT INTO mur_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Bar mazi acina niigi nɔɔnɔ rɛɛna, otoŋomit gi ci ka kurukti nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Anɔ nɛ, “Eet o wunozyawu nɛɛn ci aku neke. ");
INSERT INTO mur_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ivita kɔɔtɔ kuruyit nɔɔnɔ kadaak, ma kajukek ṯuuk ci akɔm maam. Ŋaan kavɔ kanek ɔl nɛ, Uruk nɔɔnɔ kelegiti ci mooti kadaak. Ka di kicinit gitaz ci aku wunozyaye cigin o.” ");
INSERT INTO mur_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mazi azii Robɛn gi nico, orooŋun niini gɔl ci ɛɛlanɛ Josev. Ma anek gɔtɔnɔgi nɛ, “Kotoŋit nɔɔnɔ calaŋ karuk kadaak. ");
INSERT INTO mur_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Bar olla kujuktek nɔɔnɔ ṯuuk korok nɔkɔ.” Aduwa niini zɔɔz nico o, eeci arɔɔŋ ka tedec kabada kiiya kaara nɔɔnɔ ṯuuwa ka kanyek nɔɔnɔ kimiire kook ŋaati baatineeŋ. ");
INSERT INTO mur_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Mazi akɔ arum Josev gɔtɔnɔgi, uburuca niigi nɔɔnɔ rum onin alina. ");
INSERT INTO mur_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ma avɔyi nɔɔnɔ ɛlɛ, ma avɔ ajukek ṯuuk ci akɔm maam. ");
INSERT INTO mur_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Mazi avɔ aavtiz loota ka kadaktɔ, icinit niigi tajɛr ci modɛn o kazi Ismayil ɛɛrɔna looce o kazi Gilid avu avɔ Masirɛ. Atik niigi nyakalɛtɛ zooye kibeen karkarɛt. ");
INSERT INTO mur_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Enek ni Juda gɔtɔnɔgi nɛ, “Inoko gitaz ci kajowa ŋaati kamonyi gɔtɔna cinai noko naaga maany kadaak, ma karɔɔt? ");
INSERT INTO mur_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kɔɔtɔ bar kataaltɔi nɔɔnɔ ole ci kazi Ismayil noko. Alaŋ aganɔ ŋaati karui naaga maany nɔɔnɔ kadaak, eeci niini gɔtɔna ona biyetu ɛlɛ.” Agamta ni gɔtɔnɔgja zɔɔz nico, maje Robɛn aziitɔ. ");
INSERT INTO mur_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Mazi avɔ arum tajɛra nicigi ŋinti ona aavtiyɛ niigi o, aarta gɔtɔnɔgja nɔɔnɔ ṯuuwa, ma ataalek nɔɔnɔ tajɛr nicoko zurtenene ceen eetom. Ooti tajɛra nicigi nɔɔnɔ Masirɛ. ");
INSERT INTO mur_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mazi akɔ abadaak Robɛn ṯuuk, ajowa Josev iziitɔ ṯuuwa. Ɛrɛɛc ni niini rumanɛ ogin ŋaati aluwi gɔtɔni. ");
INSERT INTO mur_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ma amiironek gɔtɔnɔgi, ma akɔ anek nɛ, “Izii dole ṯuuwa tɔ. Ka yo kutugu ku?” ");
INSERT INTO mur_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Otodoŋit ni niigi bawot, ma agoonek rum o Josev biye. ");
INSERT INTO mur_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ooti ni niigi rum ŋaati baatineeŋ, ma avɔ alaba nɔɔnɔ anek nɛ, “Kajowana rum nico ḏorta. Yo alaŋ een rum o ŋɛɛrun gi?” ");
INSERT INTO mur_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iiyez ni niini rum, ma azi nɛ, “Ii, nɔɔnɔ nɛɛn. Uruwun bai inoko kelegiti ŋɛɛran Josev, ma aŋodotan nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ɛrɛɛc ni Jakob rumanɛ ogin, ma aborcek rumanɛ ci zɔrzɔr luwanto, ma atik ciiroc ɔɔwa. Ma alu daayiz ci ŋɛɛrin o iinya ci meelik gɛr. ");
INSERT INTO mur_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ma azoozek nɔɔnɔ lɔgɔz oginɛ been bɛɛnyigin dook, bar alaŋ azii niini nɔɔgɔ. Azi niini nɛ, “Abon kalu ŋɛɛran nɔkɔ zɛɛ ma kadaai imin.” Ma alu didi niini ŋɛɛrin iinya dook nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Maje Masirɛ ŋinaante ɔɔt ataaltek tajɛra Josev eet ci kazi Potivar ceen alaan ci ɔl o abɛk ceez o alaan o adikir kazi Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ma iinyaye niceke otoŋ Juda gɔtɔnɔgi, ma akɔ aromɛ niini kibeen eet ci kazi Aira ci kutur o kazi Adulam. ");
INSERT INTO mur_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ŋinaante urumtɔ Juda ki dole ceen tinati eet ci kazi Cuwa ceen borit ci ɔl o kazi Kanan. Iriyi ni niini dole nico. ");
INSERT INTO mur_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Anyawɔ ni niini, ma ookca logoz, ma akanek Juda nɔɔnɔ zaar ci kazi Eer. ");
INSERT INTO mur_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ma irkitowe ogɛn anyawɔ bodo ŋaa, ma ookca logo oma, ma akanek zaar ci kazi Onaan. ");
INSERT INTO mur_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ma bodo irkitowe ogɛn anyake niini, ma ookca logoz, ma akanek zaar ci kazi Cela. Ma aritai logoti nici e, abaak Juda ŋaao kazi Akziba. ");
INSERT INTO mur_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Mazi akɔ adikir ŋɛɛrti Juda o kazi Eer, ɔrɔcak niini nɔɔnɔ dole ci kazi Temar. ");
INSERT INTO mur_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Maje Jooi abor baayiz ci Eer o, eeci agɔɔn niini kaal ci gɛr, ma aruk niini nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Enek ni Juda ŋɛɛrin o kazi Onaan anowa Eer nɛ, “Abon arigiz ŋaa ci gotonon bɔi noko. Oromtɛ ki nɔɔnɔ ka vada gotonu.” ");
INSERT INTO mur_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Maje Onaan aga dɔlya ci koca arita niini o alaŋ een dɔl cigin. Mazi gɔɔn oogin niini ki ŋaa ci gɔtɔnɔn o, alaŋ arɔɔŋ koromtɛ ki nɔɔnɔ gole ci ka kitirakɛ nɔɔnɔ dɔl, eeci alaŋ arɔɔŋ niini kavada gɔtɔni. ");
INSERT INTO mur_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Otobor ni Jooi gi ci agɔɔn niini noko, ma aruk Jooi nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Enek ni Juda alawan cin kazi Temar noko nɛ, “Miire, bitɔ ole o baatun, ka bitɔ aavu ŋinaante zɛɛ ma adikir ŋɛɛran ci kazi Cela o.” Aduwa niini zɔɔz nico o, eeci aŋole niini azi nɛ “Mã aromɛ Cela been nɔɔnɔ, adaai oca buk kiyo gɔtɔnɔgja o.” Imiire ni Temar ook ole uneeŋ. ");
INSERT INTO mur_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ma iinyaye ogɛn adaak Juda ŋaa oninɛ. Mazi odotiz niini luwante ci ŋaa cin noko, ɔtɔɔzɔ niini orkorit been laŋotin o kazi Aira ɔɔt looce o kazi Timana ŋaao azeeci ɔl aza ogin ima. ");
INSERT INTO mur_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ma akɔ anek ɛɛti oman Temar nɛ, “Baati eet unun akɔ Timana ka kook kɛzɛɛc aza ogin ima.” ");
INSERT INTO mur_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Aara ni niini rumanɛ ogin boyizetu, ma aborcek rumanɛ oogi, ma abuŋ ŋum ruma. Ma akɔ aavi loota araane o kutur o kazi Eniyam gole o akɔ Timana, eeci agawun niini inoko ŋɛɛrti Juda ween tutur kazi Cela idikira, ma ŋaan kanyozek niini nɔɔnɔ kizi eet cin. ");
INSERT INTO mur_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Mazi aku acin Juda nɔɔnɔ, abaaban izi nɛ, “Ŋaa nici inoko waaŋnyai gi, eeci abuŋ ŋum.” ");
INSERT INTO mur_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Bar alaŋ niini aga nicini alawan onin o. Ma anyaŋonek niini nɔɔnɔ gɔl kabanyca, ma akɔ anek nɛ, “Arooŋ kanyin naagin mã koca koogin ki ineet?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Arooŋ tɛ niina nyan naa mã koogin ki ineet?” ");
INSERT INTO mur_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ma anek Juda nɔɔnɔ nɛ, “Ŋaan kakɔ kitoonakin nyɔɔn ɛɛzaye ogan.” Ɛbɛdɛkɛ ni niini nɔɔnɔ enek nɛ, “Abona. Mã anyan gi ci kagam rak ka kɛrɛwɔi zɛɛ ma itoonakan nyɔɔn, kagama koca.” ");
INSERT INTO mur_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ijinun ni Juda nɔɔnɔ enek nɛ, “Gitaz ci arooŋnyan kanyin ineet ka rɛwɔi o?” Abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Nyan adoŋoc cun noko been kɛɛt cun omtinto noko.” Anyek ni niini nɔɔnɔ kaal nicoko dook, ma oogin ki nɔɔnɔ. Ma gole nico anyawɔ Temar. ");
INSERT INTO mur_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Mazi akɔ ɔlɔ, ook aara rum o abuŋi ŋum e, ma aborcek ɛlɛ rumanɛ ogin zɔrzɔr boyizetu. ");
INSERT INTO mur_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ma iitene oman itoona Juda laŋotin Aira ka kanyaak ŋaa baal agam kaal ogin e nyɔɔn. Bar ŋaan kojowa niini ŋaa nico. ");
INSERT INTO mur_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ma ajin niini ɔl ci mac oogi kuture ci kazi Eniyam noko anek nɛ, “Waaŋnyai o gɔɔn adete gɔla ŋina o ŋaaḏaŋ?” Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Akɔm waaŋnyai ŋina laadun.” ");
INSERT INTO mur_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Imiire ni niini, ma akɔ anek Juda nɛ, “Ŋaan kojowa nɔɔnɔ. Anekan ɔl ci mac ŋinite nɛ, Akɔm gɔɔn waaŋnyai ŋinaante laadun.” ");
INSERT INTO mur_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Enek ni Juda Aira nɛ, “Anyek zin nɔɔnɔ kooyi kaal niceke labak, eeci alaŋ karɔɔŋ naaga katarartet ɔl ageet. Karooŋ laadun kuruwek naana nɔɔnɔ nyɔɔn, Mazi akɔm ŋinti kajowan nɔɔnɔ o, anyek kook labak.” ");
INSERT INTO mur_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Mazi akɔ een nyɛlɔwɛ iiyu, enek ɛɛti oman Juda nɛ, “Alawani unune kazi Temar izi waaŋnyai, ma inoko o bar anyake.” Iricanek ni Juda ɔl gi ci anek nɛ, “Ooti nɔɔnɔ tuuwa ka ɔɔtɔ avaadit kadaak ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Mazi avɔyi ɔl nɔɔnɔ didi ka kɔɔt kavaadit, itoonek niini baati eeto molok ci anek nɛ, “Kanyake eete ci kaal coko. Orooŋit eet ci adoŋoc nico been kɛɛt nico.” ");
INSERT INTO mur_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Iiyezun ni Juda adoŋoc onin been kɛɛt, ma azi nɛ, “Alɛɛm niini. Kabaci gi nico naana ŋaaten nɔɔnɔ, eeci ŋaan kanyek nɔɔnɔ ŋɛɛran o kazi Cela kizi eet cin.” Enice ŋaan Juda kataŋguzɔ ki nɔɔnɔ bodo. ");
INSERT INTO mur_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Mazi ka kizi ŋinti ka kotoyai Temar, bar tɛ anyak niini codɛ kɛŋa. ");
INSERT INTO mur_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ɔɔwa rak acin ɔl aziit ci dole codoi, ma agam ŋaa o gɔɔn agama gɔnɔgi dɔl aziit, ma acap aziit boŋitote ci meeri. Ma azi nɛ, “Nicini dole ween abuu nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bar imiirɔi bodo niini aziit, ma ookcai gɔtɔnnya nɔɔnɔ ɔɔwa. Ma anek ŋaa ci gɔɔn agama gɔnɔgi dɔl o dole nɛ, “Nici gɔl ci ka aamai gotonu abuuzɛt?” Akatek ni niini nɔɔnɔ zaar ci kazi Paraz ween kɛŋ cin nɛɛn amiin. ");
INSERT INTO mur_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ma ŋintimiliny nɔkɔ otoyai gɔtɔnnya o anyak boŋitot o meeri aziita e, ma akanonek nɔɔnɔ zaara ci kazi Zera o kazi kɛŋ cin nɛ meerik. ");
INSERT INTO mur_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Inoko zin aavi Josev Masirɛ. Ataalozozek baale niini Potivar ween alaan o ɔl o abɛk ceez o Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Abaak niini, ma aliŋliŋ ceeze o alaan nico. Maje bar Jooi aromɛ ki nɔɔnɔ, ma anyek nɔɔnɔ kobona kazaacɛ bonati oninɛ kook ki taden. ");
INSERT INTO mur_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mazi acin Potivar Josev aromɛ ki Jook, ma atirit Jooi nɔɔnɔ kaale o agɔɔn dook nɔkɔ, ");
INSERT INTO mur_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ereezun niini nɔɔnɔ ɔrɔɔt, ma anyek nɔɔnɔ kizi gabaren cin doon ci ka kabal kaal o kɔrɔk onin dook. ");
INSERT INTO mur_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Zin ŋaaten Josev amayuk Jooi kɔrɔk o Potivar kibeen manɛɛn ogin buk. ");
INSERT INTO mur_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ma ooŋnek Potivar kaal ogin dook Josev kabal calaŋ aŋonyek niini ɛlɛ. Bar olla aavi, ma adake, ma akɔm gi oma ci ka kutugu. Maje Josev niini logo ceen molyai ci alina ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Mazi acin ŋaa o Potivar linat cin o, orooŋun nɔɔnɔ ka kɛlɛɛmtɔ. ");
INSERT INTO mur_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Maje bar Josev ajura, ma anek nɔɔnɔ nɛ, “Alaani cane kazi Potivar o arekan aneeta ziniz ɔrɔɔt, ma ooŋnekan niini aneeta kaal ogin dook kabal naana. ");
INSERT INTO mur_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ma kanyei alaazɛt ci atobɔ ki alaazɛt onin. Ma akɔm niini gi calaŋ anyan kabal bar ineet doon. Zin ku ka koca kutugu gi ci gɛr ŋume onin been Jook o?” ");
INSERT INTO mur_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gɔɔn tup nɔkɔ ilalek niini Josev, maje Josev ajura ŋaati ka kɛlɛɛmtɔi ki nɔɔnɔ, ma buk alaŋ niini arɔɔŋ kaavtiyɔ ki nɔɔnɔ ŋaatodoi. ");
INSERT INTO mur_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ma iitene oman ook Josev ceeza ka kook kiliŋliŋ liŋliŋɔn onin. Maje gabara ogɛn azeetɔ. ");
INSERT INTO mur_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Odoma ni ŋaa nici agamun Josev rum, ma anek nɔɔnɔ nɛ, “Ija koromtɛ.” Ivir ni Josev, ma akɔ bitaala kodotek rum onin ŋaa azɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Mazi acin ŋaa nɔɔnɔ odotek nɔɔnɔ rum ŋaati iviri nɔkɔ, otowa gabara ogin, ma aku anek nɛ, “Icinit di! Josev ween Ibiro baal anyaa ɛɛti onane e arɔɔŋ kiiya kiminaŋnyan. Akunakan ceeze onan, ma arɔɔŋ kotorowan kanyan kizi ŋaa cin. Ma kagereny molowe ci appe. ");
INSERT INTO mur_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Mazi aziiŋnan kagereny nɔkɔ, ɔdɔkɔny ook bitaala kodotek rum looc.” ");
INSERT INTO mur_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ma agam ŋaa rum nico zɛɛ ma akɔ aku ɛɛti kɔrɔk. ");
INSERT INTO mur_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Enek ni niini eet nɛ, “Josev ween Ibiro een miroi akunakan uyen aneet ceeze onan, ma arɔɔŋ komomozan kanyan kizi ŋaa cin. ");
INSERT INTO mur_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Bar mazi kagereny nɔkɔ, ɔdɔkɔny ook bitaala kodotek rum cin noko looc ŋina.” ");
INSERT INTO mur_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mazi azii Potivar zɔɔz nico, otobor nɔŋ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ma akɔ arek niini Josev ceez o cabiinto gɔɔn arek Vɛɛro ɔl o agɔɔn kaal o gɛr. Ma acabje Josev ŋinaante ŋinti wun kal. ");
INSERT INTO mur_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Maje Jooi aromɛ ki nɔɔnɔ ceeze o cabiinto ŋinaante, ma amayuk nɔɔnɔ. Ma atalnɛ buk alaani o ceez o cabiinto ŋaati Josev. ");
INSERT INTO mur_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Zin giye nico anyek niini Josev kɛbɛk kaal o ɛɛl ceeze o cabiinto dook. Ma anyek buk niini nɔɔnɔ kozooti ɔl o acabje. ");
INSERT INTO mur_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ma alaŋ alaani ci ceez ci cabiinto noko abut kaal o acin Josev, eeci Jooi aromɛ ki Josev, ma atirit niini nɔɔnɔ kaale o agɔɔn niini dook. ");
INSERT INTO mur_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Maje waanice anyak gabara ceen ram titiny ole o Vɛɛro. Codoi ŋaatineeŋ anyaak gɔɔn alaan dayiin ki nyaantanɛ. Maje codoi aak niini ḏɔkɛn. Ma iitene oman utuguzɔ gabara nici gi ci gɛr anyek Vɛɛro kotobor nɔŋ. ");
INSERT INTO mur_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","Ma akɔ arek niini nɔɔgɔ ceez o cabiinto o buk acabin Josev. ");
INSERT INTO mur_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ma acabje niigi ŋinaante ŋinti wun ɔrɔɔt, ma anyek alaani o ceez o cabiinto Josev kɛbɛk nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ma iitene oman baal uwunoztɛ gabara ceen ram noko ceeze o cabiinto ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Mazi akunak Josev nɔɔgɔ ŋeere, acin niini nɔɔgɔ alaca eleeti. ");
INSERT INTO mur_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ma ajin nɔɔgɔ anek nɛ, “Naa alacanu eleeti nɔkɔn?” ");
INSERT INTO mur_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kawunozina bilija. Bar zin inoko akɔm eet ci ka koobeyet keŋti ci wunozyak nicoko.” Ma anek Josev nɔɔgɔ nɛ, “Jook doon ci aga keŋti ci wunozyawu. Uduktayaŋ di nuun wunozyak cugoocok o.” ");
INSERT INTO mur_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Enek ni gabarɛnti baal gɔɔn anyaak alaan dayiin ki nyaantanɛ e nɔɔnɔ nɛ, “Kacin wunozeye cigan o kɛɛt ci anyak oto iiyu. Ma aduŋna bɔlɔwa ci colai otone nicoko, ma buk aduŋna kɛbɛrɛ, ma abiir. ");
INSERT INTO mur_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Maje naana kanyei kooz o alaano aziita. Kodoca ni kɛbɛrɛ nicoko, ma kamacowe maam cigeec o kooz nico, ma kakɔ kanyi alaan.” ");
INSERT INTO mur_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Enek ni Josev nɔɔnɔ nɛ, “Ziik kɛŋ ci wunozak cugun o ce. Oto ci keetu een iiyu o kɛŋ cinɛ akati iinya ceen iiyu. ");
INSERT INTO mur_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tiŋeere ma idica iinya iiyu cabiinta, aborcin alaani, ma uuŋnin ineet giye o agoon. Ma amiironekin niini ineet liŋliŋɔn unun bitɔ liŋliŋ labak. ");
INSERT INTO mur_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Zin tiŋeere mã eelit kaala nicigi dook tɔ, aadawan buk niina aneeta. Duwak alaan ka buk koborcan niini aneeta. ");
INSERT INTO mur_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Baale laadun naana kagamnyai looce o ɔl o kazi Ibiro, ma akɔm gi ci gɛr kagoon ka waan kacabɔi Masirɛ ŋina.” ");
INSERT INTO mur_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Iziik ni gabarɛnti ci baal gɔɔn aḏɔk ḏɔkɛn ci alaano o zɔɔz ci aduwa Josev o, ma amenek nɔɔnɔ kɛŋ ci wunozyawu o ɔrɔɔt ɛlɛ. Ma anek niini Josev nɛ, “Kawunoze buk bilija naana. Bar kizik kanyei ɔɔwa gilanya ci ḏokenu een iiyu. ");
INSERT INTO mur_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Maje gilawi ci ataadonek gɔnɔgi tadena o anyak ḏɔkɛn ci alaano kɛŋa. Ma avu kibaali, ma adak ḏɔkɛn nicoko.” ");
INSERT INTO mur_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Anek Josev nɔɔnɔ nɛ, “Ziik kɛŋ ci wunozak cugun o ce. Ma gilanya ceen iiyu o keŋti cigeec akati iinya ceen iiyu. ");
INSERT INTO mur_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tiŋeere ma idica niina iinya iiyu, aduŋnanin alaani cabiinta, ma akɔ ateedanin ɔɔ bitaala, ma arimiz ɛlɛ cun o kɛɛta ka kadayit kibaali.” ");
INSERT INTO mur_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Mazi akɔ adicai iinya iiyon, utugu Vɛɛro kɔnyit ci iinya ogin tiryanto. Ma awak niini ɔl o mayan anowɔ ki nɔɔnɔ dayiin. Ma aborca gabara baal acabje een ram e. ");
INSERT INTO mur_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ma amiirɛnɛ gabaren baal gɔɔn aliŋliŋ nyaantanɛ kibeen dayiin e liŋliŋonte onin. ");
INSERT INTO mur_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Maje gabaren baal gɔɔn aḏɔk ḏɔkɛn e ɛtɛɛda ɔɔ bitaala, ma arimiz ɛlɛ cin o kɛɛt tadena. Ma agooni kaala nicigi dook ebaal aduwan Josev e. ");
INSERT INTO mur_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Maje gabarɛnti o gɔɔn anyaak alaan nyaantanɛ kibeen dayiin alaŋaan niini aada Josev giye baal aduwak nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ma vurte ci ooti irkitowa raman uwunozi alaani o Masiro kazi Vɛɛro, kizik abil niini liile o kazi Nil otoga. ");
INSERT INTO mur_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ma acin tiin ci adii agirgir eleeti een torgɛrɛm aduŋna liila, ma avu agɛ dɔwɔna. ");
INSERT INTO mur_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ma bodo anowa tiin nicoko gɔnɔgja ogɛn ceen torgɛrɛm ci mɔdɔtik tuŋkar eleeti, ma avu ɛɛl liiltoga ŋaati ajɔŋɔz gɔnɔgi oke. ");
INSERT INTO mur_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ma akuu tiina ci mɔdɔtik noko gɔnɔgi o adii e. Enico icinɛ alaani ooŋnyai. ");
INSERT INTO mur_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mazi bodo ɔɔŋ, uwunozɛ bodo. Enico acin niini kaaza ci labinu een torgɛrɛm ci appintik abiir kaŋayace codoi. ");
INSERT INTO mur_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ma bodo acin kaŋayace nico ɛlɛ kaaza ceen torgɛrɛm ci amuduwez, ma alɔŋnyai ŋoote ci abur. ");
INSERT INTO mur_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ma akuu labina ci amuduwez noko gɔnɔgi ci appintik o. Icinɛ ni bodo alaani, ma abaaban wunozyak nicoko. ");
INSERT INTO mur_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ma ŋeere abarit alaan ziniz kapuk kapuk. Giye nico itoon ni niini otok kook ŋaritɛ been ole o agɛny een arinya o Masiro ka kivitak niigi nɔɔnɔ. Ivita ni ɔl nicigi, ma aduwak niini nɔɔgɔ wunozyak cigin o. Bar akɔm ŋaatineeŋ eet ci oobek nɔɔnɔ kɛŋ ci wunozyak nicoko. ");
INSERT INTO mur_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Mazi akɔ acin gabarɛnti o gɔɔn aliŋliŋek alaan dayiin zɔɔz nico, enek niini alaan nɛ, “Waanico kaada gi o gɛr baal kagoon e. ");
INSERT INTO mur_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Baale aborneket niina ageeta nɔŋ aneeta been gabaren baal gɔɔn aḏɔk ḏɔkɛn e. Ma areket ceez o cabiinto. ");
INSERT INTO mur_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ma baaline oman ceeze o cabiinto ŋinaante kuwunoztewa naaga dook. ");
INSERT INTO mur_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Maje logoti ween Ibiro een gabaren o Potivar acabje buk. Ma kaduwaka naaga nɔɔnɔ wunozyak cigaacak o. Oobeyet ni niini ageeta keŋti cigeec. ");
INSERT INTO mur_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ma vurta eelit didi kaala nicigi dook ebaal oobeket niini ageeta e. Ma iiya didi imiirozekan niina aneeta liŋliŋɔn onan ebaal aduwan niini e, ma arui eet o aḏɔk ḏɔkɛn kadaak ebaal aduwakɛ niini nɔɔnɔ e.” ");
INSERT INTO mur_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mazi azii Vɛɛro zɔɔz nico, itoonek Josev otok kiiya. Taman nɔkɔ anyaakta ɔl nɔɔnɔ ceeze o cabiinto. Akoca niini zɛɛr, ma aborcek rumanɛ ci colai. Iiyak ni alaan. ");
INSERT INTO mur_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ma anek alaani nɔɔnɔ nɛ, “Kawunoze bilija, bar zin akɔm eet ci aduwakan kɛŋ ci wunozyak nicoko. Ma aduwakan ɔl azi nɛ, Oobei gɔɔn niina ɔl keŋti ci wunozyawu.” ");
INSERT INTO mur_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Abɛdɛkɛ Josev nɔɔnɔ anek nɛ, “Alaŋ een aneeta nɛɛn ci kaga keŋti ci wunozyawu o, bar Jook nɛɛn o aduwakan aneet keŋti cigeec.” ");
INSERT INTO mur_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Oobek ni alaani nɔɔnɔ wunozak cigin o anek nɛ, “Kawunoze kizik kabil liil ci kazi Nil noko otoga. ");
INSERT INTO mur_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ma kacin tiin ci adii agirgir eleeti een torgɛrɛm aduŋna liila, ma avu agɛ liiltoga. ");
INSERT INTO mur_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ma bodo anowa tiin nicoko gɔnɔgja ogɛn ci mɔdɔtik tuŋkarik ci ŋaan laadun kicin Masirɛ ŋina. ");
INSERT INTO mur_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ma avu akuu tiina ci mɔdɔtik tuŋkarik noko gɔnɔgi ci adii agirgir eleeti o. ");
INSERT INTO mur_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ma bar ŋaan mɔdɔtɛ nɔkɔ. Enico kizɛ bɛk kicinɛ. ");
INSERT INTO mur_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Mazi bodo atɛɛdanan ooŋnya, kuwunozɛ bodo kizik kacin kaaza ci labinu een torgɛrɛm aduŋna kaŋayace codoi. ");
INSERT INTO mur_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bodo kaŋayace nico ɛlɛ aduŋna kaaza ceen torgɛrɛm ci amuduwez alɔŋa ŋooti ci abur. ");
INSERT INTO mur_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ma akuu kaaza nicigi gɔnɔgi ci appintik o. Mazi kaduwai wunozyak nicoko ŋarit kibeen ɔl ween arinya, bar akɔm ŋaatineeŋ ci oobekan keŋti cigeec kina.” ");
INSERT INTO mur_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Enek ni Josev alaan nɛ, “Wunozyawa nicigi dook ramana akati kɛŋ cineeŋ nɔɔgɔ dook gi codoi ṯɔr nɔkɔ. Ayelzakin Jooi ineet gi ci ka kutugu niini. ");
INSERT INTO mur_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ma tiina ceen torgɛrɛm adii o akati kɛŋ cineeŋ irkitok ceen torgɛrɛm. Buk kaaza ci labinu appintik abiir o akati irkitok ceen torgɛrɛm noko. Nɔɔgɔ dook adoye kɛŋ cineeŋ, ma akati bonat ci loocu. ");
INSERT INTO mur_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ma tiina ceen torgɛrɛm mɔdɔtik o been kaaza ci amudut o akati kɛŋ cineeŋ irkitok oogi bodo ceen torgɛrɛm ci anyayi lɔɔci tarjo ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Abil zin kiyo kaduwakin noko. Ayelzakin Jooi ineet gi ci ka kutugu niini katin. ");
INSERT INTO mur_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Anyak katin lɔɔci dayiin ci meelik irkitok torgɛrɛm Masirɛ ŋina. ");
INSERT INTO mur_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ma vurte nice aku bodo tarjo ci appe irkitok torgɛrɛm kiliita ɔl nyɛrizi ci irkitok baal een torgɛrɛm e. ");
INSERT INTO mur_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Eeci tarjo nica tarjo ci gɛr ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ayelzakin zin Jooi ineet kaal nicoko wunozyai lak ram o, eeci aga niini tiŋeere agɔɔn nɔkɔ didi. Ma anyek tiŋeere niini kaal nicoko kakatai kataman. ");
INSERT INTO mur_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Abon zin aŋɛra niina eet ceen arit agɛny ka kabal looc nico. ");
INSERT INTO mur_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Abona buk aŋɛra alaat ceen inyaati cugun ka kiyaŋtek ɔl lɛlɛn ci labinu codoi lelenete ween tur labine o abiirna lɔɔci nici dook. Tugu gi nico irkitowe ceen torgɛrɛm anyayi lɔɔci dayiin o. ");
INSERT INTO mur_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","36","Ricanek nɔɔgɔ niinalya kuluta labi nicoko irkitowe ci abon o dook. Ricanek buk nɔɔgɔ kiyaŋit dayiin nicoko kuturyowɛ dook, ma abɛk juruŋ ka labina nicigi kitiritit ɔl irkitowe ci ɛɛnɛ lɔɔci tarjo katin e. Mã agoon nɔkɔ, alaŋ koca ɔl katin akaran.” ");
INSERT INTO mur_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Agama ni Vɛɛro kibeen alaat o anowɔ ki nɔɔnɔ zɔɔz ci aduwak Josev nɔɔgɔ o. ");
INSERT INTO mur_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ma anek Vɛɛro ɔl nɛ, “Inoko kacin naana Josev anyak vɔŋiz o Joowo, ma akɔm eet oma ci abon kujuk nɔɔnɔ liŋliŋonte nico. ");
INSERT INTO mur_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Enek ni niini Josev nɛ, “Inoko eyelizayin Jooi ineet kaal nicoko dook. Akɔm zin ŋina eet ci agɛny kujukin ineet. ");
INSERT INTO mur_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Inoko karooŋ kanyin ineet bal looc can o, ka ɔl ci looc can noko dook kiziiktin ineet. Akɔm eet ci ajukin ineet dɔyiza, bar aneeta doon o kadikir ŋaatun alaazɛta. ");
INSERT INTO mur_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Inoko zin kanyin naana ineet izi alaan ci ɔl ci Masiro noko dook.” ");
INSERT INTO mur_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Aara ni alaani nyapokodec onin alaazetu, ma aborcɛkɛ Josev aziit. Ma aborcɛkɛ buk niini nɔɔnɔ rum ci alina, ma arikɛ kalbɛn ceen warki alɛm. ");
INSERT INTO mur_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ma anyek nɔɔnɔ kavool codoi kavoolete ogin agurut jɔmanɛ ka gɔɔn kɔtɔwi. Ma anyek buk nɔɔnɔ ɔl cigin abɛk ka gɔɔn kɔtɔɔzɔ nɔɔnɔ ɔɔwa kegerenycek ɔl, ma amadak ɔl gɔla ŋaati awɔyi niini. Izi ni Josev alaan ci abal Masir dook kizi niini inyaa ci Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ma anek Vɛɛro nɔɔnɔ nɛ, “Inoko keen naana ɔɔ. Een niina inyaa can. Akɔm zin eet calaŋ azii zɔɔz cun ole ci Masiro o dook.” ");
INSERT INTO mur_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Akatek ni niini Josev zaar ci Masiro kazi Zavinat Pania. Ma arɔcak nɔɔnɔ ŋaa ci kazi Asenat ceen tinati Potiviri o gɔɔn arogomek joowanɛ o Masiro kuture o kazi Ilipoliz. ");
INSERT INTO mur_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Akana Josev liŋliŋɔn ci alaazetu noko ŋaati ɛɛnɛ nɔɔnɔ irkitowa eetoma kamɔtɔ (30). Itiŋa ni niini ole o alaano, ma eerononek kuturyok o Masiro dook ka kook kicin liŋliŋonok ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ma irkitowe o abon een torgɛrɛm anyawun lɔɔci dayiin ci meelik ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ma alota Josev labi ci meelik irkitowe ceen torgɛrɛm abon noko, ma itaŋ piimanɛ kuturyowɛ dook. ");
INSERT INTO mur_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ma itaŋ niini labi ci meelik ɔrɔɔt kotobtɔ meelitina kibeen kazac o liilu alaŋ kanim kekeebit. ");
INSERT INTO mur_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Mazi ŋaan kivita irkitowa o ka kanyayi lɔɔci tarjo o appe, itira Josev lɔgɔz cigin een ram ŋaawe onin kazi Asenat een tinati Potiviri o gɔɔn arogomek joowanɛ. ");
INSERT INTO mur_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ma akanek niini ŋɛɛrin ceen abuu o zaar ci kazi Manasa. Kɛŋ cin kazi nɛ iliitayan, eeci iliitai Jooi nɔɔnɔ piryakzɛt onin kibeen baabani o abaabani niini kɔrɔk o baatin. ");
INSERT INTO mur_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ma akanek ŋɛɛrin ci anowa gɔn ceen abuu o zaar ci kazi Iviram. Kɛŋ cin kazi nɛ mɛɛlɛ dɔlya, eeci anyek Jooi nɔɔnɔ dɔl looce baal apirnanɛ e. ");
INSERT INTO mur_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Mazi aṯornɛkɛ irkitowa o abon een torgɛrɛm baal anyayi lɔɔci o Masiro nyɛriz e, ");
INSERT INTO mur_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","akatai bodo irkitowa ween torgɛrɛm ka kiiyai tarjo o appe baal aduwa Josev e. Anyayit ni loocowa dook tarjo ci appe ɔrɔɔt ɛlɛ. Ma anyak dayiin Masira doon. ");
INSERT INTO mur_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Mazi akɔ akanai magiz Masirɛ, ivita ɔl o Masiro dook utuluzek alaan uneeŋ ka kanyek niini nɔɔgɔ dayiin. Enek ni Vɛɛro nɔɔgɔ nɛ, “Ɔɔtɔ ŋaati Josev ka ɔɔtɔ utuguz gi ci olla aduwakuŋ niini igeet.” ");
INSERT INTO mur_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Maje magiz ɛbɛyɛ ɔrɔɔt ɛlɛ kadala looc o Masiro dook. Okolun ni Josev piimanɛ, ma ataalek ɔl o Masiro dook labi. ");
INSERT INTO mur_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ma buk avunak ɔl loocowɛ dook Masir ka kivita kataalit niigi labi ŋaati Josev, eeci izi magiz appe kizi gɛrzɛ ɔrɔɔt loocowɛ dook. ");
INSERT INTO mur_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mazi akɔ azii Jakob anyak Masira labi, enek niini ŋɛɛrigin nɛ, “Naa alaŋ atultulyu naa? ");
INSERT INTO mur_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kazii azi ɔl nɛ, Anyak labi Masirɛ. Ɔɔtɔ ataalta labi ci kavu karogzi eleeti.” ");
INSERT INTO mur_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Itiŋgazɔ ni gɔtɔnɔgi Josev o baatin een amɔtɔ ɔɔtɔ Masirɛ ka kɔɔt kataalta labi. ");
INSERT INTO mur_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ma alaŋ anyek Jakob gɔtɔni Josev o yaatin kazi Bɛnjimɛn korkorit ki nɔɔgɔ, eeci aŋole niini karabɔŋ anyak gi ci gɛr agoononek nɔɔnɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Orkorit ni lɔgɔz ci Jakob o kibeen ɔl oogi ci buk avɔ Masirɛ ka kɔɔt kataalta labi, eeci anyak Kanan tarjo ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Maje waanice Josev izi niini alaan ci looc o Masiro laadun, ma ataalek niini labi ɔl o avu loocowe dook. Ivita ni buk gɔtɔnɔgja, ma avu aloca ooti ŋaatin. ");
INSERT INTO mur_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Mazi acin Josev gɔtɔnɔgi, iiyez niini nɔɔgɔ, ma agɔɔn niini ɛlɛ kiyo alaŋ aga nɔɔgɔ o. Ma ajin nɔɔgɔ ŋaati aŋɔzyakɛ anek nɛ, “Avunu niiga ŋaaḏaŋ?” Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Keegina ɔl ci kavuna looce o kazi Kanan. Karooŋnya kivita kataalta dayiin.” ");
INSERT INTO mur_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Mayo nuun iiyezun Josev nɔɔgɔ o, alaŋ niigi iiyez nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Aada ni Josev wunozyak baal awunozinɛ akati nɔɔgɔ, ma aduwak nɔɔgɔ e. Ma anek nɔɔgɔ nɛ, “Eeginu roote ci avu arootu kutur cinaaŋ o ka ivita akatetu.” ");
INSERT INTO mur_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Akɔm, Manygɔn. Alaŋ een nɛɛn. Kavuna kiyo buk ɔl dook ci avu ataal dayiin ŋaatun o. ");
INSERT INTO mur_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Naaga dook keegina gɔtɔn ci adoye baatinaaŋ. Alaŋ keegina roote. Keegina ɔl ci kabonana.” ");
INSERT INTO mur_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Bar anek Josev nɔɔgɔ nɛ, “Akɔm! Avunu ka ivita orootit kutur cinaaŋ o ka ivita akatetu.” ");
INSERT INTO mur_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Anek niigi nɔɔnɔ nɛ, “Manygɔn, keegina baale laadun naaga dook amɔnki ram. Keegina lɔgɔz ci eet codoi ṯɔr nɔkɔ looce o kazi Kanan. Gɔtɔna codoi baale adaawa, maje ceen tutur o aromɛ inoko o kibeen baatinaaŋ.” ");
INSERT INTO mur_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Abɛdɛkɛ Josev nɔɔgɔ anek nɛ, “Abil kiyo kanekuŋ nɛ, Eeginu roote o. ");
INSERT INTO mur_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Inoko zin karooŋ ka kicinawuŋ. Inoko kazooz naana ŋaati kitoonɛ zaar o alaan o adikir abal looc nico. Alaŋ niiga awoyu been nɛɛn zɛɛ ma akɔ aku gotonu cunooŋ een tutur o ŋina. ");
INSERT INTO mur_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Abon aavtiyu niiga dook ceeze o cabiinto ŋina, bar itoonit ŋaatunooŋ eet codoi ka kook kanyaa gotonu nice ka zin kiiya kicin naana mã aleemnyu didi. Mã alaŋ aku gotonu cunooŋ een tutur o, kagawuŋ koca didi eeginu roote.” ");
INSERT INTO mur_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ma anyek niini nɔɔgɔ kaavtiyɔ ceeze o cabiinto iinya iiyu. ");
INSERT INTO mur_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Mazi akɔ adicai iinya ceen iiyu noko, anyaaktak ɔl nɔɔgɔ Josev ma aku anek niini nɔɔgɔ nɛ, “Giye o kaŋolinɛ naana Jook, alaŋ karukuŋ igeet adaayit mã agoonu gi co. ");
INSERT INTO mur_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Mã eeginu ɔl ci abonanu didi, anycek gotonu codoi ŋaatunooŋ kacabɛ ŋina ka ceegi kooti labi ɔlɔ ka kɔɔt kɛɛlta ɔl magiza. ");
INSERT INTO mur_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Abon zin anyaakaŋ gotonu ceen tutur o ka kagawuŋ aleemnyu didi niiga zooze ci aduwanu o, ka zin calaŋ karukuŋ naana igeet adaayit.” Agamta ni niigi zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ma anɔ niigi maany nɛ, “Icinit di! Akunaket piryakzɛt nici giye baal kagɔɔnɛkɛ naaga gɔtɔna onai Josev gi o gɛr e. Baale ma ilaleket niini ageet ka waan kotoŋit naaga nɔɔnɔ, bar alaŋ karɔɔŋ kiziiyit nɔɔnɔ been nɛɛn. Gi ci zin kapirnanɛ naaga inoko o nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ma anek Robɛn gɔtɔnɔgi nɛ, “Kuduwayuŋ waanice igeet kanekuŋ nɛ, Má agooneku dole gi ci gɛr. Bar alaŋ aziiŋnaŋ. Inoko zin kipirta giye o adaayi niini.” ");
INSERT INTO mur_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Aje Josev azii kaal ci azɔɔz niigi o nɔkɔ. Maje niigi alaŋ aga azii Josev nɔɔgɔ o, eeci azɔɔz niigi zooze uneeŋ. ");
INSERT INTO mur_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mazi akɔ azii Josev zoozok ci azɔɔzɔnɛ niigi o dook, ook bitaala, ma akɔ alu ŋinaante. Mazi akɔ abadaan niini ziniz, abada bodo, ma aku aŋɛra Simiyan, ma acap nɔɔnɔ azɛɛn nɔɔgɔ kɔrgɛna ŋina. ");
INSERT INTO mur_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ma aricanek Josev ɔl ogin kibitizit kaboot ci gotonogin o labinɛ. Ma amiirɔnɛkɛ nɔɔgɔ guruc ugeec kaboote ugeec eecitɔ calaŋ niigi aga. Ma anyek niini buk nɔɔgɔ dayiin ci alɛɛnɔ ki nɔɔgɔ keronnye cineeŋ o. ");
INSERT INTO mur_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Aryek ni gɔtɔnɔgja kaboot ci labinu noko zigire ugeec, ma awɔ. ");
INSERT INTO mur_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mazi avɔ oogin niigi baalin gɔla, ɔkɔl ɛɛti codoi ŋaatineeŋ kaboon arɔɔŋ ka kanyek zigir dayiin, ma bar ajowa guruc ogin kaboon otoga. ");
INSERT INTO mur_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ma awo niini gɔtɔnɔgi anek nɛ, “Abadayan guruca ogane. Kajowa kaboona eecitɔ.” Ivirit ni nɔɔgɔ zinzeeti ŋoliinta, ma ajinɔ anɔ nɛ, “Ma Jooi gitaz ci agooneket noko?” ");
INSERT INTO mur_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ɔtɔɔzɔ ni. Mazi avɔ arum baatineeŋ Jakob, oobtek niigi nɔɔnɔ kaal o agoononek nɔɔgɔ ŋinaante dook. ");
INSERT INTO mur_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ma anek buk niigi nɔɔnɔ nɛ, “Alaani ci Masiro o azoozeket ageeta ŋɔzyanta gɛrzɛ, ma aneket nɛ, Keegina roote. ");
INSERT INTO mur_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ma kabedeka naaga nɔɔnɔ kaneka nɛ, Alaŋ keegina roote. Keegina ɔl ci kabonana. ");
INSERT INTO mur_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Keegina baale naaga dook amɔtɔ ram. Keegina lɔgɔz ci eet codoi. Gɔtɔna codoi adaawa, maje ceen tutur o aromɛ ki baatinaaŋ Kananakti. ");
INSERT INTO mur_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Bar abedeket alaani nici ageeta aneket nɛ, Alaŋ kagayuŋ naana igeet eeginu ɔl ci abonanu. Anycek eet codoi ŋaatunooŋ koromtewa ki aneet ŋina ka ceegi kooti labi ɔlɔ ka kɔɔt keela ɔl ci ka kakaranit neke. ");
INSERT INTO mur_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ka zin ɔɔtɔ anyaaktayaŋ aneet gotonu ceen tutur o ka kiiya kicin. Mã agoonu nɔkɔ, kagawuŋ koca naana igeet alaŋ didi arootinu. Mazi didi tiŋeere kaku kacinuŋ naana igeet eeginu ɔl ci abonanu, kamiironekuŋ koca gotonu cunooŋ o, ma buk kanyuŋ koca igeet ivita gɔɔn ataalit kaal ŋina karabɔŋ ataalinu labak.” ");
INSERT INTO mur_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mazi avɔ aara niigi labi kabootɛ, ojokta niigi dook guruc ugeec kabootɛ. Anyayit ni Jakob kibeen lɔgɔz cigin o dook ŋoliin giye nico. ");
INSERT INTO mur_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ma anek baatineeŋ nɔɔgɔ nɛ, “Arooŋnyaŋ dim aneet kokoloz dɔl cigan o dook? Josev ki Simiyan ɔɔt many, ma bodo inoko arooŋnyu ooti Bɛnjimɛn. Anyaakaŋ piryakzɛt nico nɔkɔ naa?” ");
INSERT INTO mur_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Enek ni Robɛn baatin nɛ, “Mã alaŋ kabadanɛ Bɛnjimɛn, ŋaan arui lɔgɔz ogan een ram kadaayitɔ. Anyek nɔɔnɔ kaavu aziite can. Ŋaan kabadanɛ naana nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Bar anek Jakob nɔɔnɔ nɛ, “Alaŋ ŋɛɛran orkoryu ki ineet. Adaak baale gɔtɔnnya o yaatin. Izi logo ci anyigjai dook nɛɛn niini. Inoko naana kanyata. Mã orkoryu, ma akɔ akunak nɔɔnɔ gi ci gɛrzɛ gɔla, arukan koca aneet baabani kadaak.” ");
INSERT INTO mur_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Enice ɛbɛyɛ magiz Kananakti ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Mazi avɔ adica ɔl o kɔrɔk o Jakob labi ci baal ataalyai Masirɛ o dook, enek Jakob lɔgɔz ogin nɛ, “Imiirte bodo ɔɔtɔ ataalta labi oogi Masirɛ.” ");
INSERT INTO mur_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bar anek Juda nɔɔnɔ nɛ, “Aricaneket waanice alaani o Masiro gi ci azi nɛ, Abon avunu ŋaati anyaanu gotonu ween tutur. ");
INSERT INTO mur_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Inoko zin mã agama niina kɔrkɔrta ki ŋɛɛrun, kavoya koca, ma kataalana labi. ");
INSERT INTO mur_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mazi alaŋ agama, alaŋ naaga kavoya, eeci aneket alaani nica ageeta nɛ, Má avunu mã alaŋ anyaanu gotonu ween tutur.” ");
INSERT INTO mur_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Enek ni Jakob nɔɔgɔ nɛ, “Naa agoonekaŋ gi ci gɛr nɔkɔn? Aduwaku laadun nɔɔnɔ gotonu ci miliny o naa?” ");
INSERT INTO mur_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kaduwaka nɔɔnɔ o, eeci ajinet niini ageeta zoozok ci meelik. Ajinet aneket nɛ, Baatunooŋ ŋaan arogi? Anyaku niiga gotonu oma? Ma kabedeka naaga nɔɔnɔ jinenok cigin o. Alaŋ bar kagaya arooŋnyet niini ageeta ka kanyaaktaya nɔɔnɔ gɔtɔna o.” ");
INSERT INTO mur_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Enek ni Juda baatin nɛ, “Nyan dole aneet kɔrkɔrta. Nyet ka kotooza taman ka calaŋ akaran ɔl magiz. ");
INSERT INTO mur_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ŋaan kazoonɛ naana Bɛnjimɛn. Mã anyak daayiz, ŋaan kadaaŋna naana ki nɔɔnɔ. Mã alaŋ kabadakin naana nɔɔnɔ yaak, anyek toriin kaavu ŋaatan. ");
INSERT INTO mur_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Inoko da toŋawet kotooza, kabadawa waan inoko lak ram.” ");
INSERT INTO mur_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ma anek baatineeŋ nɔɔgɔ nɛ, “Mã izi gɔl dook nɛɛn nici, ɔɔtɔ. Idiziyit zin buk niiga alaan nico ŋaati avoyeku nɔɔnɔ kaal o abon ɛɛl looce nico. Ootɛkɛi nɔɔnɔ mutul ki lɛtɛ ki karkarɛt ki agɛrɔ been manac. ");
INSERT INTO mur_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ooti buk guruc lɛlɛn ram ka ɔɔtɔ imiirtɔzɛkɛi nɔɔnɔ guruc baal ajowanu kaboote ugoocok e. Karabɔŋ bar da abac niigi. ");
INSERT INTO mur_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Iyiitit gotonu ooti alaane nice taman. ");
INSERT INTO mur_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Abon bai Jooi o anyak dɔyiz dook anyek ziniz ci alaan nice uwucek niiga ka coma bac abadakuŋ niini igeet Bɛnjimɛn kibeen Simiyan ci acabje ŋinaante neke. Maje naana mã kakuluz dɔl cigan noko, abon labak. Anyek kɔɔtɔ, eeci akɔm gi ci ka kutugu.” ");
INSERT INTO mur_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ooti ni lɔgɔz o Jakob dizkenok been guruc ci meelik, ma avɔyi buk niigi Bɛnjimɛn Masirɛ. Mazi avɔ arum looc, ɔɔt eyeltek eleeti Josev. ");
INSERT INTO mur_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Mazi acin Josev Bɛnjimɛn, enek gabara ogin abɛk ceez nɛ, “Ooti ɔl nicoko ɔlɔ. Ɔɔtɔ otodoŋit taŋ ka kook kadaktowa buk naana kibeen nɔɔgɔ tedec waaz.” ");
INSERT INTO mur_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Utugu ni gabarɛnti eci ona aduwakɛ Josev nɔɔnɔ o, ma akɔyi gɔtɔnɔgi Josev ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Mazi akɔyi gabarɛnti nɔɔgɔ ɔlɔ, anyayit niigi ŋoliin, ma abaaban anɔ nɛ, “Anyaanet inoko ɔl ageet ŋina zooze ci guruc ci baal kajowa kabootɛ o. Arɔɔŋ ka kivita koŋoztozeyet ŋina ka kaamtawet zigire, ka kanycet ageet ɛlɛ kiziti mirɔk cigeec.” ");
INSERT INTO mur_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Zin giye nico ivitak niigi gabaren o abɛk ceez tatok, ma anek nɔɔnɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Manygɔn, kivitawa naaga ŋina rak baale lak codoi kavu kataala dayiin. ");
INSERT INTO mur_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mazi kamiirena waanice, kɔɔt kojoktowa kabootɛ guruc ogaacak baal kataalina e. Inoko zin kabadaya guruc niceke dook. ");
INSERT INTO mur_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ma kanyaana buk guruc oogi ci ka kataaltaya dayiin bodo. Alaŋ kagaya naaga ŋɛnɛɛn ci da amiironeket guruc kabootɛ o.” ");
INSERT INTO mur_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Enek ni gabarɛnti nɔɔgɔ nɛ, “Má aŋolinu looc gaga. Anycaŋu baale guruc ugooc baal ataalinu e aneet ɛlɛ. Jook unooŋ een Jook o baatunooŋ nɛɛn ci amiironekuŋ igeet guruc kabootɛ o ka kizi guruc cugoocok.” Udunai ni niini Simiyan ceeze o cabiinto, ma aku anyek nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ma akɔyi gabarɛnti nici gɔtɔnɔgi Josev ceeza, ma akɔ anyek nɔɔgɔ maam ci oonyi zɔɔ, ma adayiz niini zigire ugeec. ");
INSERT INTO mur_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Aarta ni niigi kaal o ka kidizikti Josev kaboote ugeec. Ma arɛwi nɔɔnɔ, eeci agaac niigi Josev aku tedec ka kiiya kadaktɔ ki nɔɔgɔ ole cin o. ");
INSERT INTO mur_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Mazi akɔ aku Josev kɔrɔk, anycek niigi nɔɔnɔ dizkenok cigin o, ma aloca ooti ŋaatin. ");
INSERT INTO mur_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ma azaa niini nɔɔgɔ, ma anek nɛ, “Baale aduwakaŋ baatunooŋ ci izi matuwoc. Inoko abil niini ku? Ŋaan ɔɔŋ?” ");
INSERT INTO mur_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ii, ŋaan baatinaaŋ ɔɔŋ.” Ma bodo aloca niigi ooti ŋaatin. ");
INSERT INTO mur_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Mazi acin Josev dole o yaatin een tutur kazi Bɛnjimɛn, enek nɔɔgɔ nɛ, “Gotonu baal aduwakaŋ een tutur e nɛɛn nici?” Ma anek niini Bɛnjimɛn nɛ, “Amayukin Jooi ineet ŋɛɛran.” ");
INSERT INTO mur_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ma ooŋ Josev nɔɔgɔ taman nɔkɔ, eeci ateedi nɔɔnɔ ziniz ŋaaten gɔtɔni, ma arɔɔŋ kook kutulu. Ook ni niini ceeze oman, ma akɔ alu ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Mazi akɔ adotiz luwanta, ɛɛk kɛbɛrɛ, ma aduŋnak bitaalin, ma agam ɛlɛ calaŋ alu. Ma aduwak niini gabara kanyaakta dayiin. ");
INSERT INTO mur_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ma adake Josev tarabeze cin doon. Bodo gɔtɔnɔgja adake niigi tarabeze oman. Aje Masira o adake ŋinaante aŋɛra niigi eleeti kaavtiyɔ doon, eeci adiŋdiŋan niigi eleeti, ma alaŋ arɔɔŋ niigi kɔzɔltɔ ki ɔl ci Ibiro o, eeci apɛz niigi nɔɔgɔ kizi kaal ci labak. ");
INSERT INTO mur_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ma anyek Josev gɔtɔnɔgi kaavtiyɔ zedinta akana abuuwa zɛɛ been tir tutura. Mazi acin niigi eleeti azedi nɔkɔ, ibiirit nɔɔgɔ ooti giye ci anyekɛ Josev nɔɔgɔ kaavtiyɛ nɔkɔ o. ");
INSERT INTO mur_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma aŋerek ɔl nɔɔgɔ dayiin tarabeze ci Josev o, ma anyaak ɔl Bɛnjimɛn dayiin lak tur kujuk gɔnɔgi. Ma adake niigi dook, ma awodɛ ki Josev, ma atalnɛ niigi dook. ");
INSERT INTO mur_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Otoŋomek ni Josev gabaren ween alaan o abɛk ceez onin gi ci anek nɛ, “Bitizek ɔl nicoko kaboot ugeec dayiine ci meel alɛɛnɔ ki nɔɔgɔ ŋaati atiki. Buk miirozɛkɛ nɔɔgɔ guruc ugeecik e dook, arikɛ gɔɔn giten guruc cigin o kaboon onin otok. ");
INSERT INTO mur_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Doma buk kooz onan een warki, arek kaboon ci gɔtɔni uneeŋ een tutur been guruc ogin labinu e.” Ma agɔɔn niini eci aduwakɛ Josev nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ma ŋeere ririwɔna anyek Josev nɔɔgɔ been zigire ugeec kɔtɔɔzɔ. ");
INSERT INTO mur_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mazi ŋaan awɔ niigi ŋaati ajɔŋɔz kutur nɔkɔ, enek Josev gabaren nɛ, “Iyiik viri ɔl oke zooc. Mazi akɔ amɔda nɔɔgɔ, jin enek nɛ, Uwuyu bonat gerzitina naa? ");
INSERT INTO mur_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Agorozu kooz o alaan onan een warki naa? Nici kooz ci gɔɔn awodɛn niini, ma acin niini kooze nico kaal ci ka kivita katin. Agoonu niiga gi ci gɛr ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mazi akɔ arɔba gabarɛnti nici nɔɔgɔ, uduwak didi niini nɔɔgɔ zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Naa Manygɔn? Aduwaket zɔɔz ci gɛr nɔkɔn? Ŋaan naaga kutuguza gi ci abil nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Iiten baale aga niina kabadaya naaga guruc baal kajowana kabootɛ e, ma kavu kanyin ineet. Mayo zin ku bodo ka kɔgɔrɔztɔ kaal ci ceez ci alaano o? ");
INSERT INTO mur_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Manygɔn, mã ajowa eet codoi ŋaatinaaŋ ci anyak kooz nico, abon arui nɔɔnɔ kadaak, ma agam koogi ŋaatinaaŋ kizi mirɔk cugun.” ");
INSERT INTO mur_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Izi ni niini nɛ, “Abona. Kagama zɔɔz nico. Zin tedec eet ci agɔrɔz kooz o doon ci kanyi nɔɔnɔ kizi gamnyai can. Maje ceegi awɔ tedec niigi yaak.” ");
INSERT INTO mur_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Taman nɔkɔ aryek niigi kaboot looc, ma akɔl gɔɔn giten kaboon onin. ");
INSERT INTO mur_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ma arooŋnyi gabarɛnti ci Josev noko kidicilim, akana abuuwa, ma akɔyi been tir tutura. Ma ajoyai koozi kaboone o Bɛnjimɛn eecitɔ. ");
INSERT INTO mur_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Mazi avɔ acin niigi gi nico, ereecit niigi rumanɛ ugeec ŋaati aluwi, ma arek kaal zigire, ma amiiri kibeen gabaren ci Josev o. ");
INSERT INTO mur_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Mazi abadaak Juda been gɔtɔnɔgi kɔrɔk o Josev bodo, ajowa niigi Josev ŋaan aavi ceeza. Ma avaci niigi eleeti looc nɔɔnɔ ŋuma. ");
INSERT INTO mur_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ma anek Josev nɔɔgɔ nɛ, “Gitaz ci agoonu noko? Alaŋ niiga agayu ɛɛti ci abil ki naana ajowa gi ci abil nɔkɔ ŋarizɛta o?” ");
INSERT INTO mur_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ma abɛdɛkɛ Juda nɔɔnɔ anek nɛ, “Kayo kenekteyin nɛ? Kayo kadaŋta gi nico ku? Ɔbɔra Jooi gerzitin cinaaŋ o laadun. Inoko zin naaga dook kizita gamnyak cugun. Alaŋ een gamnyai ɛɛti ci ona ajoyai koozi ŋaatin o doon.” ");
INSERT INTO mur_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Bar anek Josev nɔɔnɔ nɛ, “Akɔm! Alaŋ naana kagoon nɔkɔ been nɛɛn. Karooŋ naana eet ci ona ajoyai koozi ŋaatin o doon kizi gamnyai can. Aje niiga amiironeku baatunooŋ labak.” ");
INSERT INTO mur_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ook ni Juda ŋaati Josev, ma akɔ anek nɛ, “Manygɔn, Kozoozɔ da ki ineet zinize ci vɔɔr. Má abornekan nɔŋ, eeci een niina alaan ci atobonu ki Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Manygɔn, iiten baale ajinet aneket nɛ, Anyaku baatunooŋ karabɔŋ een gotonu oma? ");
INSERT INTO mur_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ma kabedekin naaga ineet kanekin nɛ, Ii, Kanyaka baatinaaŋ ci izi matuwoc, ma kanyaka gɔtɔna ci baatinaaŋ een tutur ci aritai niini ŋaati izɔi baatinaaŋ matuwoc. Maje dole ci yaatin een abuu adaak baale. Ɔdɔwɛ niini ŋaati yaatin ṯɔr nɔkɔ. Ma arɛɛz baatinaaŋ nɔɔnɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Eneyet ni waanice niina ageeta nɛ, Anyaaktayaŋ nɔɔnɔ kiiya kicin. ");
INSERT INTO mur_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ma kabedekin naaga ineet kanekin nɛ, Alaŋ logoti nici ooŋ baatinaaŋ. Mã koca agɔɔn niini nɔkɔ, adaai koca baatinaaŋ. ");
INSERT INTO mur_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma aneket niina ageeta waanice nɛ, Alaŋ koca bodo kacinuŋ igeet ŋina mã alaŋ anyaanu gotonu nice. ");
INSERT INTO mur_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Mazi waanice kamiironeka baatinaaŋ e, kɔɔt kuduktaya naaga nɔɔnɔ zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ma bodo aduwaket niini ageeta kabadawa ŋina ka kivita kataalta dayiin. ");
INSERT INTO mur_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ma kabedeka naaga nɔɔnɔ kaneka nɛ, Alaŋ kavoya, eeci alaani o Masiro alaŋ arɔɔŋ kicinet ageeta ŋinaante bodo dooke coma kɔrkɔrana kibeen gɔtɔna ceen tutur o. Mazi anyet ageeta kɔrkɔrta ki gɔtɔna ceen tutur o, kavoya labak. ");
INSERT INTO mur_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ma aneket baatinaaŋ ageeta nɛ, Agayu niiga Recal ween ŋaa onan aritakan niini aneet lɔgɔz ram nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Codoi okolozɛ ook many, karabɔŋ da inoko uruyit nɔɔnɔ kɛlɛgɛ. ");
INSERT INTO mur_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Mazi koca avoyu niiga Bɛnjimɛn, ma akunak nɔɔnɔ gi ci gɛrzɛ gɔla, arukan koca luwa kadaak, eeci kizɛ matuwoc. ");
INSERT INTO mur_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Manygɔn, inoko zin mã alaŋ kamiironɛkɛ dole nico baaba, adaai koca niini, eeci arɛɛz niini dole ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Iiten baal kavuna e kanei naana nɔɔnɔ nɛ, Toŋa dole kaavu azeene cigan. Mã alam gi ci gɛr akunak nɔɔnɔ, ŋaan iinakan aneet. ");
INSERT INTO mur_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Manygɔn, inoko zin abon karigiz naana dole nico kizi gamnyai cun. Anyek nɔɔnɔ kimiirye kibeen gɔtɔnɔgi. ");
INSERT INTO mur_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Kayo kimiirozek baaba ku mã alaŋ korkorya been dole? Alaŋ karooŋ kicin baaba ŋaati akunakɛ nɔɔnɔ gi ci gɛrzɛ.” ");
INSERT INTO mur_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ɛtɛɛdɛ ni Josev ziniz ɔrɔɔt, bar alaŋ arɔɔŋ niini kutulu ŋaati acini gabara oginɛ nɔɔnɔ, ma anyek niini nɔɔgɔ kudunit bitaala, ka kaavtiyɔ niigi doon kɔkɔm eet oma ci aromɛ ki nɔɔgɔ, eeci arɔɔŋ niini kɔbɔrak gɔtɔnɔgi ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Utulu ni Josev molowe ci alɛlɛ, makacin iziiyit ɔl o Masiro nɔɔnɔ, ma avɔ kaviyawa been Vɛɛro ole onin. ");
INSERT INTO mur_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ma anek Josev gɔtɔnɔgi nɛ, “Aneeta Josev nɛɛn nici. Ŋaan baaba arogi?” Bar mazi azii gɔtɔnɔgja zɔɔz nico, abaritit niigi ɔrɔɔt ɛlɛ, ma adali kɔkɔm gi ci abariz. ");
INSERT INTO mur_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Enek ni Josev nɔɔgɔ nɛ, “Izaktayaŋ ijonun ŋaato.” Mazi izaya, enek niini nɔɔgɔ nɛ, “Aneeta gotonu unooŋ Josev baal ataaleku Masir e nɛɛn nici. ");
INSERT INTO mur_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Má zin aŋolinu looc giye baal ataalinaŋ aneet e gaga, eeci bar da Jook nɛɛn ci agɔɔn gi nico o ka kitoonawan niini aneet igeet ɔɔwa ka kiiya kitirit ɔl magiza ŋina. ");
INSERT INTO mur_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Izi inoko irkitowa ci magizo idicai ram. Ŋaan zin ɛɛl irkitowa ci magizo een tur ɔɔwa. ");
INSERT INTO mur_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Itoonanan Jooi aneet igeet ɔɔwa ka kiiya kɛɛlawuŋ, ka korogit dɔlya ci dɔl ugooc. ");
INSERT INTO mur_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Alaŋ een igeet nɛɛn ci itoonanaŋ aneet ŋina o, bar Jook nɛɛn o anyaanan aneet ŋina. Ma anyan kizi inyaa ci Vɛɛro, ka kabal loocok o Masiro dook ŋina. ");
INSERT INTO mur_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Inoko iyiiyit imiirte ɔɔtɔ ŋaati baaba ka ɔɔtɔ enektek nɔɔnɔ nɛ, Azi ŋɛɛrun o kazi Josev nɛ, Anyan Jooi aneet kabal looc o Masiro dook. Ijak zin Masir ŋaato kataman. ");
INSERT INTO mur_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ija ka baak looce o kazi Gocen ka jɔŋɔzan. Luuga korge unun dook. ");
INSERT INTO mur_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ŋaan kaku kazuunin naana ineet ŋaato. Inoko ŋaan ɛɛl irkitowa ci magizo een tur ɔɔwa. Alaŋ zin karooŋnyuŋ igeet akaranit ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ma anek bodo Josev gɔtɔnɔgi nɛ, “Inoko niiga dook been Bɛnjimɛn buk iiyeztaŋ aneet keen Josev nɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ɔɔtɔ zin uduktak baaba alaazɛt ci kanyei naana Masirɛ ŋina o. Oobtek nɔɔnɔ kaal ci acinu noko dook. Iyiiyit zin ka ɔɔtɔ uluuktai nɔɔnɔ kiiya ŋina.” ");
INSERT INTO mur_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Enico otorkot niini gɔtɔni o kazi Bɛnjimɛn, ma alu. Ma alu buk Bɛnjimɛn ŋaati atorkodɔn. ");
INSERT INTO mur_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ma atorkot buk niini gɔtɔnɔgi dook, ma acoco nɔɔgɔ ŋalyamɔ ŋaati aluwi. Ma vurta ozooztek gɔtɔnɔgja nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Mazi akɔ arum mɔlɔyi o avuni gɔtɔnɔgi Josev Vɛɛro, atalɔ niini been alaat o miliny buk giye nico. ");
INSERT INTO mur_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ma anek Vɛɛro Josev nɛ, “Duwak gotonogu karyek kaal zigire ka kimiirtozek Kanan. ");
INSERT INTO mur_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Anyek nɔɔgɔ kɔɔt kanyaakta baatunooŋ ki kɔrɔk dook kurtɛnta kivita ŋina. Ŋaan kaku kanyi naana nɔɔgɔ ŋinti abon abaai Masirɛ ŋina. Ma kanyi buk nɔɔgɔ dayiin ci alɛɛnɔ. ");
INSERT INTO mur_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Duwak buk nɔɔgɔ kooti kavoolɛt o agurut jɔmanɛ ka kɔɔt kanyaaktai niigi baatunooŋ ki ŋaai kibeen dɔl o miliny. ");
INSERT INTO mur_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Má anyi nɔɔgɔ kiinonit kaal ugeec ooŋnek looc liga, eeci kaal ci tiŋeere kanyi naana nɔɔgɔ Masirɛ ŋina o abon ɔrɔɔt kujukit kaal ci ooŋnek niigi looc ŋinaante o.” ");
INSERT INTO mur_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ɔɔtɔ ni utuguzɔ lɔgɔz o Jakob eci adawakɛ Vɛɛro nɔɔgɔ o. Anyek Josev nɔɔgɔ kavoolɛt o agurut jɔmanɛ been dayiin ci ka kadayit gɔla. ");
INSERT INTO mur_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ma anyek buk nɔɔgɔ dook rumanɛ ci colai. Maje Bɛnjimɛn anyek nɔɔnɔ zurtɛnɛn ceen eet tur lak iiyu (300) been rumanɛ ci colai een tur. ");
INSERT INTO mur_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ma itoonek niini baatin zigire amɔtɔ ci akɔyɛkɛ nɔɔnɔ kaalyan o abona dook ci ataala niini mɛlɛgɛnyaye o Masiro. Bodo zigire ceen amɔtɔ atik niigi gora been ḏɔkɛn kibeen dayiin ci keronnyo. ");
INSERT INTO mur_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Anyek ni niini gɔtɔnɔgi kɔtɔɔzɔ, ma ilot niini nɔɔgɔ calaŋ ayɔwɔ gɔla. ");
INSERT INTO mur_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ɔtɔɔzɔ ni niigi ɔɔtɔ ŋaati baatineeŋ Kananakti. ");
INSERT INTO mur_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ma avɔ anek niigi baatineeŋ nɛ, “Ŋaan Josev arogi. Nɔɔnɔ nɛɛn ci abal Masir o.” Bar aŋɛja Jakob, ma alaŋ arɔɔŋ kiziik zɔɔz cineeŋ o. ");
INSERT INTO mur_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mazi avɔ oobek niigi nɔɔnɔ kaal o aduwak Josev nɔɔgɔ, ma acin buk niini kavoolɛt ci itoonak Josev nɔɔnɔ Masirɛ o, abada nɔɔnɔ ziniz, ma agama zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ma azi nɛ, “Ŋaan bar arogi ŋɛɛran Josev. Inoko zin koroga naana, ma katalnɛ. Abona zin kakɔ kacin naana nɔɔnɔ maŋaan kadaak o.” ");
INSERT INTO mur_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Acap ni Jakob kaal ogin dook, ma iŋaaz akɔ ŋaao kazi Biirsaba. Ma akɔ ataap Jook o baatin Aizak todoyoita ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ma baal otowo Jooi nɔɔnɔ wunozyai enek nɛ, “Jakob, Jakob.” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Woo. Aneeta ce.” ");
INSERT INTO mur_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Enek ni Jooi nɔɔnɔ nɛ, “Aneeta Jook o baatun gi. Má aŋoli ŋaati akɔyɛ Masirɛ gaga. Bitɔ labak. Ŋaan katin kanyi dɔl ci dɔl cugun kizi boryok ci meelik ŋinaante. ");
INSERT INTO mur_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ŋaan kazuunin naana ineet ŋaati akɔyɛ looce nice o. Má aŋoli looc gaga, eeci ma akɔ adaai ŋinaante, ŋɛɛrun Josev tɔ. Ma ŋaan kabadanɛ naana dɔl ci dɔl cugun looc nico.” ");
INSERT INTO mur_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Uluugit ni Jakob ki ɔl ogin ŋaati kazi Biirsaba noko. Ma arek lɔgɔz oginɛ nɔɔnɔ kibeen ŋaai kibeen dɔl o miliny kavoolɛt o agurut jɔmanɛ baal itoonak Vɛɛro nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ma aluugi niigi buk tiin ki ɛɛza been kaal ugeec anyak looce o kazi Kanan dook, ma avɔyi Masirɛ. ");
INSERT INTO mur_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ma aloŋan Jakob ɔl ogin dook, ŋɛɛrigin ki dɔl o ŋɛɛrigin, bɛɛnyigin ki dɔl o bɛɛnyigin. ");
INSERT INTO mur_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ɔl zin o kɔrɔk o Jakob ɔrkɔr ki nɔɔnɔ avɔ Masirɛ nɛɛn ce. ");
INSERT INTO mur_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Robɛn ween abuu ki dɔl ogin kazi Anoc ki Palu ki Ezron been Karmi. ");
INSERT INTO mur_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyan ki dɔl ogin kazi Jimul ki Jamin ki Oda ki Jakin ki Zowar been Cawel ween logo o ŋaa o looc o Kanan. ");
INSERT INTO mur_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Livai ki dɔl ogin kazi Gircon ki Kotat been Mirari. ");
INSERT INTO mur_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda ki dɔl ogin kazi Cela ki Paraz been Zera. Aje ŋɛɛriginɛ o kazi Eer been Ona adaayitɔ waanice niigi Kananakti. Zin Paraz anyak dɔl ram ci kazi Ezron been Amul. ");
INSERT INTO mur_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isikar ki dɔl ogin kazi Tola ki Pua ki Jacub been Cimron. ");
INSERT INTO mur_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulon ki dɔl ogin kazi Sered ki Elon been Jaleel. ");
INSERT INTO mur_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nicigi dook lɔgɔz o arita ŋaa o Jakob kazi Leya een abuu looce o kazi Mesopatamiya. Itira buk niini waanice bɛɛnyin ci kazi Dina. Zin dɔlya o Leya been dɔl o dɔl ogin dook een eetoma kamɔtɔ ki tiin iiyu (33). ");
INSERT INTO mur_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Anyak buk Jakob lɔgɔz oogi ci kazi Gad ki dɔl ogin kazi Zevon ki Aagi ki Cuni ki Ezbon ki Eri ki Arod been Areli. ");
INSERT INTO mur_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Acar ki dɔl ogin kazi Imona ki Icva ki Icvi ki Berya been ŋɔɔni lɔgɔz nicoko ci kazi Sera. Ma Berya anyak dɔl ram ci kazi Ibar been Malkil. ");
INSERT INTO mur_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zin dɔlya nicigi dook dɔl ci Zilpa ween ŋaa o Jakob aavtiz been dɔl ci dɔl ogin. Eegin niigi dook amɔnki tɔrkɔnɔm (16). ");
INSERT INTO mur_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Aje ŋaa o Jakob kazi Recal arita niini dɔl ram o kazi Josev been Bɛnjimɛn. ");
INSERT INTO mur_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ma Josev ci abaak Masirɛ o anyak niini lɔgɔz ram ci kazi Manasa been Iviram o arita niini ŋaawe onin kazi Asenat een tinati Potiviri. ");
INSERT INTO mur_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Maje dɔlya o Bɛnjimɛn kazi zaar cigeecik nɛ Bela ki Bekar ki Acbel ki Gera ki Naaman ki Eyi ki Rooco ki Mupim ki Upim been Arid. ");
INSERT INTO mur_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dɔlya ci Recal o been dɔl ci dɔl ogin dook een amɔnki wec (14). ");
INSERT INTO mur_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Anyak buk Jakob lɔgɔz oogi ci kazi Dan been ŋɛɛrin Ucim. ");
INSERT INTO mur_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Navtali ki dɔl ogin kazi Jazeel ki Guni ki Jezar been Cilem. ");
INSERT INTO mur_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Zin dɔlya nicigi dook dɔl ci Bila ween ŋaa o Jakob aavtiz been dɔl ci dɔl ogin. Eegin niigi dook torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dɔlya ci Jakob aluugi o dook een eet iiyu ki tiin tɔrkɔnɔm (66), bar ŋaai o ŋɛɛrigin alaŋ akeebonek. ");
INSERT INTO mur_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Mazi karom dɔl nicoko kibeen dɔl o Josev aritai Masirɛ, eegin niigi dook eet iiyu kamɔtɔ (70). ");
INSERT INTO mur_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Itoon ni rak Jakob ŋɛɛrin o kazi Juda karayɛ kook kuduwak Josev ka kiiyak Josev nɔɔnɔ ŋaao akɔ aali niini kazi Gocen. ");
INSERT INTO mur_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Mazi akɔ arum ɔtɔgi nici Josev, otoodun niini kavool onin agurut jɔmanɛ, ma akɔ ŋaati kazi Gocen noko ka kɔɔt kurumtɔ ki baatin ŋinaante. Mazi akɔ acin Josev baatin, otorkot niini nɔɔnɔ azɛɛnɛ dook, ma aluwek nɔɔnɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ma anek Jakob ŋɛɛrin nɛ, “Inoko naana katalnɛ ɔrɔɔt ɛlɛ. Inoko mã kadaai ŋaati kicinin ineet o, alal ziniz ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Enek ni Josev ɔl o kɔrɔk o baatin nɛ, “Anycaŋ kook kuduwak Vɛɛro kenek nɛ, Ivita ɔl o kɔrɔk o baaba dook Kananakti. Ivitayan niigi aneet ŋina. ");
INSERT INTO mur_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Zin niigi laadun ɔl ci tiinu. Uluuktai niigi tiin ki kaal ugeec dook ŋina. ");
INSERT INTO mur_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Mazi awoyuŋ Vɛɛro igeet, ma ajinuŋ anekuŋ nɛ, Gɔɔn laadun niiga aliŋliŋnyu naa?, enektek niiga nɔɔnɔ nɛ, Keegina naaga ɔl ci tiinu. Mã aneku nɔkɔ, anyuŋ koca igeet abaayit Gocena ŋina.” Aduwak Josev ɔl o baatin gi nico o, eeci ɔl o Masiro alaŋ arɔɔŋ ɔl ci abal tiin koromtɛ ki nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Ooyi ni Josev gɔtɔnɔgi ceen tur ka kook keyelek Vɛɛro. Ma akɔ anek Josev Vɛɛro nɛ, “Baaba kibeen gɔtɔnɔga ivita niigi dook looce o kazi Kanan. Aluuganɛ niigi tiin ki ɛɛza kibeen kaal o abal dook. Inoko aal ŋaao o kazi Gocen.” ");
INSERT INTO mur_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ijin ni Vɛɛro gɔtɔnɔgi Josev enek nɛ, “Aliŋliŋnyu gɔɔn laadun niiga liŋliŋɔn jaŋ?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Keegina naaga ɔl ci kabala tiin kiyo jijitigaacak baale e. ");
INSERT INTO mur_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Karooŋnya rak naaga kivita kabaakta ŋina, eeci ɛbɛɛyɛ tagizi ɔrɔɔt looce ci kazi Kanan neke, ma buk ɔkɔma artɛ ci ka kegeec tiina ŋinaante. Inoko zin tiritet. Nyet kabaakta ŋaati kazi Gocen noko.” ");
INSERT INTO mur_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Enek ni Vɛɛro Josev nɛ, “Gi ci avunakin baatune ki gotonogu noko abon ɔrɔɔt ɛlɛ. Inoko zin Masira izi buk looc cineeŋ. ");
INSERT INTO mur_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Anyek nɔɔgɔ kabaayit ŋaati kazi Gocen noko labak, eeci een looc ci abon amadi. Inoko zin buk karooŋ mã anyak ŋaatineeŋ ɔl ci towawiinto abon azooni tiin juruŋ, anyek buk koca nɔɔgɔ kabalteyan tiin ogan.” ");
INSERT INTO mur_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Anyaa ni buk Josev baatin kiiyak Vɛɛro ka kiiya kicin niini nɔɔnɔ. Ma akɔ amayuk Jakob nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ma ajin Vɛɛro Jakob anek nɛ, “Anyei irkitok izɔk?” ");
INSERT INTO mur_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Abɛdɛkɛ Jakob nɔɔnɔ anek nɛ, “Kanyei irkitok eet tɔrkɔnɔm kamɔtɔ (130), ma irkitowe nicoko dook kaluugi gɔɔn nɔkɔ kɔkɔm irkit ci kabaayɛ rɛm. Kanyei irkitok ci miliny tɛr, ma gɛrzɛ ɔrɔɔt ɛlɛ. Ma irkitowa ci kabaayɛ noko dook alaŋ een irkitok ci meel kiyo baal abaai jijitigane e.” ");
INSERT INTO mur_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Amayuk ni bodo Jakob Vɛɛro zɛɛ ɔtɔɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ma anyek Josev baatin kibeen gɔtɔnɔgi kabaayitɔ ŋaati kazi Gocen o kojoŋozit niigi ŋino kazi Ramsis ebaal aduwakɛ Vɛɛro nɔɔnɔ e. Ŋinitana waanice ŋinti abon ɔrɔɔt ɛlɛ looce o Masiro dook. ");
INSERT INTO mur_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ma anyek Josev gɔtɔnɔgi kibeen ɔl o kɔrɔk o baatin dook dayiin ci alɛɛnɔ ki nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ma ŋintimiliny nɔkɔ iiya tarjo ci appe ɔrɔɔt ɛlɛ ci akɔmni dayiin loocowe dook. Ma apirna ɔl o Masiro been ɔl o Kanan buk. ");
INSERT INTO mur_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ataalek ni Josev ɔl dook labi. Ma gole nico olota niini guruc dook ole o Kanan kibeen Masirɛ buk, ma akɔ arek ceez o Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mazi akɔ adicai guruca ɔla dook, ivitak ɔl ween Masir Josev, ma avu anek nɔɔnɔ nɛ, “Idicai guruca ogaacak dayiino. Nyet dayiin. Má anyet kakaranta.” ");
INSERT INTO mur_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Enek ni Josev nɔɔgɔ nɛ, “Mã idicai guruca, anyaakta tiin. Ŋaan kaku kabalyekuŋ labinɛ.” ");
INSERT INTO mur_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Anyaakta ni ɔl didi tiin ki ɛɛza ki jɔmanɛ ki zigire ka kivita kabaliyai niigi labi irkite nice. ");
INSERT INTO mur_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ma irkite co ivita ɔl bodo, ma avu anek Josev nɛ, “Inoko akɔm gi ci karoodin ineet. Idicai guruca ogaacak dook. Buk tiin ogaacak dook ooyɛ niina, ma ɔkɔma bodo gi ci kanyaka ka kabaliyaya labi. Izi eleeti cigaacak o doon ki manɛɛn. ");
INSERT INTO mur_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Má anyet zin kadaakta karanɔn. Taalet ageeta ɛlɛ kibeen manɛɛn ogaacak ka kizita naaga gabara ci Vɛɛro ka buk manɛɛna ogaacak kizi cigin. Abon anyet labi ci ka korogta ka buk koḏokta oogi manɛɛni.” ");
INSERT INTO mur_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Zin tarjowe nico ataalak Josev Vɛɛro manɛɛn o Masiro dook, eeci ɛbɛɛyɛ magiz Masirɛ ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ma buk iziti ɔl dook gabara ci Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Maje ŋino abaai ɔl o ŋaryiinto ŋaan Josev kataala, eeci anyek Vɛɛro nɔɔgɔ dayiin tup nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Enek ni Josev ɔl nɛ, “Inoko zin naana kataalawuŋ igeet dook ki manɛɛn ugooc ka iziti kaal ci Vɛɛro. Ooti zin ḏowo coko ka oḏoyit manɛɛni. ");
INSERT INTO mur_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Zin tiŋeere iitene o teedinto, eŋerit labi ci ateedanu o lak tur. Odomta lɛlɛn codoi lelenete ceen tur noko anycek Vɛɛro. Maje lɛlɛn ceen wec o itaŋtek eleeti ugooc ka adayit oogi ka ogɛn kizi ḏowo.” ");
INSERT INTO mur_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Enektek ni niigi nɔɔnɔ nɛ, “Inoko zin niina orogozet ageeta. Ŋaan zin keegina gabara ci Vɛɛro labak.” ");
INSERT INTO mur_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Iricanek ni Josev ɔl o Masiro dook ɔrɔɔt ɛlɛ ka gɔɔn kɛŋɛrtak niigi Vɛɛro labi cigin o irkitok dook, ma agɔɔn niigi nɔkɔ. Ɛmɛda ni bar zɔɔz nici ibil kodot zɛɛ been inoko o. Maje ɔl o ŋaryiinto alaŋ niigi agɔɔn nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Abaayitɔ ni ɔl o Israyil looce o Masiro ŋaao kazi Gocen zɛɛ makacin iziti niigi botoro ɔrɔɔt ɛlɛ, ma arit buk niigi zɛɛ makacin azaace kizi mɛɛlɛ gɛr. ");
INSERT INTO mur_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ma abaak Jakob Masirɛ irkitok amɔnki torgɛrɛm zɛɛ ma een irkitowa oginɛ tiryanto eet torgɛrɛm ki tiin torgɛrɛm (147). ");
INSERT INTO mur_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Mazi ka kizi ŋinti ka kanyati niini, otowa ŋɛɛrin Josev, ma aku anek nɛ, “Mã areezan niina aneeta didi, zuuti gi ci tiŋeere alaŋ adayan aneet looce ci Masiro o ŋina. ");
INSERT INTO mur_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mã kadaai ŋina, bitan zɛɛ ma akɔ adayan ŋaao adawin jijitigane.” Ma abɛdɛkɛ Josev nɔɔnɔ anek nɛ, “Ŋaan kagoon eci aduwanɛ o.” ");
INSERT INTO mur_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ma azi Jakob bodo nɛ, “Agoon dim tiŋeere didi nɔkɔ?” Anek Josev nɔɔnɔ nɛ, “Ii, baaba. Kagoon didi tiŋeere nɔkɔ.” Anyek ni Jakob Jook zany ŋaati ɔɔŋɛ kɛrca. ");
INSERT INTO mur_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ma vurta iitene oman enektek ɔl Josev nɛ, “Amɔɔr baatune.” Ooyi ni niini lɔgɔz ogin kazi Manasa been Iviram ka kɔɔt kicinit niigi jijitineeŋ. ");
INSERT INTO mur_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Mazi azii Jakob iiya ŋɛɛrin Josev, agamun ɛlɛ, ma iŋaaz kaavu jena kerce onin. ");
INSERT INTO mur_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ma anek niini ŋɛɛrin Josev nɛ, “Baale ayelzakan Jooi o anyak dɔyiz dook ɛlɛ ŋaao kazi Luz looce o Kanan, ma amayukan. ");
INSERT INTO mur_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Ma anekan nɛ, Kanyin katin dɔl ci meelik ka dɔlya ci dɔl cugun kiziti boryok ci meelik. Ma kanyi nɔɔgɔ katin looc nico kizi cineeŋ kabaakti niigi kodot.” ");
INSERT INTO mur_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ma anek Jakob bodo Josev nɛ, “Ma Iviram kibeen Manasa ceen lɔgɔz cugun aritai Masirɛ waan o ŋaan naana kiiyakɛ Masir e, ɛɛl niigi kiyo dɔlya ogane o. Atobɔ niigi kibeen lɔgɔz ogan kazi Robɛn kibeen Simiyan. ");
INSERT INTO mur_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Matɛ katin arita niina lɔgɔz oogi bodo, alaŋaan nicaga een cigan. Izi niigi cugun doon. Ŋaan zin akunak nɔɔgɔ mayuwɛnɛt cineeŋ ŋaati Iviram kibeen Manasa. ");
INSERT INTO mur_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kagoon kaal nicoko ka kaadai yaatun Recal baal adaai Kananakti ŋaao ajɔŋɔz Evrat iinyaye baal kabadanɛ keronnye o kakunɛ looce o kazi Mesopatamiya e. Zin baale daayizi oninɛ awucnekan aneet ɔrɔɔt.” (Ŋinti kazi Evrat neke utuye inoko bodo zaara ci kazi Bɛzilɛm.) ");
INSERT INTO mur_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Maje waanice Jakob alaŋaan kɛbɛrɛ acinɛ juruŋ, eeci anyat niini ɔrɔɔt. Ma icayan Josev lɔgɔz ogin een ram kojoŋozit Jakob. Ma ajin Jakob Josev anek nɛ, “Lɔgɔz ci ŋɛnɛ nici?” Ma abɛdɛkɛ Josev nɔɔnɔ anek nɛ, “Lɔgɔz ogan baal anyan Jooi Masirɛ ŋina e nɛɛn.” Enek ni Jakob nɔɔnɔ nɛ, “Iicayai zin nɔɔgɔ ŋaato kamayuk.” Anyek ni Josev nɔɔnɔ dɔl, ma atorkot niini nɔɔgɔ, ma acoco ŋalyamɔ. ");
INSERT INTO mur_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ma anek Jakob Josev nɛ, “Alaŋ baale kaga kacinin bodo, bar inoko Jooi anyan korok zɛɛ makacin kicinin ineet ki dɔl cugun buk.” ");
INSERT INTO mur_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Aara ni Josev dɔl baatin anyɔtɔi, ma akat kozoŋtin, ma aloca ɔɔ baatin ŋuma. ");
INSERT INTO mur_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","16","Amayuk ni Jakob ŋɛɛrin Josev anek nɛ, “Abon bai Jooi o jiji Ibrayim kibeen baaba Aizak amayuk lɔgɔz cugun noko. Abon bai Jooi o azuunan aneet, ma ayelekan golok zɛɛ been iiten nico noko amayuk nɔɔgɔ. Abon bai toonnyaiti o Joowo baal ɛɛlanan aneet kaale o gɛr dook amayuk nɔɔgɔ. Abon bai agayi zaara ogane been zaar o jiji Ibrayim kibeen o baaba Aizak ŋaaten lɔgɔz nicoko. Abon bai abitiz niigi looc nico dolene cigeec arita.” Arek ni Josev ŋɛɛrin o kazi Iviram baatin aziit ci kaŋeto. Aje ŋɛɛrin ceen abuu kazi Manasa o arekɛ baatin aziit ci azo. Bar Jakob abaric azɛɛn, ma arek aziit ci azo o ɔɔ ci Iviram ceen tutur o, ma ataadek aziit ci kaŋeto o ɔɔ ci Manasa ceen abuu o. ");
INSERT INTO mur_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mazi acin Josev baatin arek aziit ci azo o ɔɔ ci Iviram ceen tutur o, inyigit niini gi nico. Ma aara niini aziit ci baatin o oowe ci Iviram o, ma arek ɔɔ ci Manasa o. ");
INSERT INTO mur_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ma anek niini baatin nɛ, “Alaŋ een nɛɛn baaba. Logo ween abuu nɛɛn ce. Arek aziit cun azo o ɔɔ cin o.” ");
INSERT INTO mur_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bar ujura baatinɛ, ma anek nɔɔnɔ nɛ, “Kaga gi ci kagoon o nɔkɔ. Ŋɛdɛt katin Manasa niini baati bor ci meel. Bar zin katin tuturi niini adiŋdiŋ ɔrɔɔt kujuk gɔtɔni. Katin dɔlya ciginɛ een bor ci meel gɛr.” ");
INSERT INTO mur_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Amayuk ni niini nɔɔgɔ iiten nice anek nɛ, “Ɔl ci Israyil noko katin awo zaar cugooc ŋaati amayuwi niigi ɔl oogi. Azi katin niigi nɛ, Abon bai Jooi anyuŋ otobtɔ kibeen Iviram been Manasa.” Zin giye nico anyewun Jakob Iviram karayɛ kizi ɔɔ ŋaati Manasa. ");
INSERT INTO mur_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ma anek Jakob Josev nɛ, “Inoko acinan aneet kadadjai. Ŋaan zin aromenu niina ki Jook, ma ŋaan katin amiirenin niini ineet looce o jijitugun. ");
INSERT INTO mur_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Kanyin zin ineet looc o abon kazi Cekam baal kɔɔra naana ole o kazi Amorit dilanyaye ogan e. Kanyin ŋinite ineet, alaŋ een gotonogu.” ");
INSERT INTO mur_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Ma vurta iitene oman otowa Jakob lɔgɔz ogin dook anek nɛ, “Olotai niiga dook lɔgɔz ogane ka kiiya kuduwayuŋ gi ci katin akunakuŋ igeet ce. Iziiktaŋ aneet o karitanuŋ kazi zaar cigan nɛ Israyil.” ");
INSERT INTO mur_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ma amayuk Jakob Robɛn anek nɛ, “Niina Robɛn ween abuu dolene ogan een niina logo onan karitanin ɔɔwa waan baal ŋaan kiŋaanɛ e nɛɛn. Zin giye o ɛɛnɛ niina abuu, anyei niina dɔyiz logoze cigan o dook. ");
INSERT INTO mur_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Atobonu niina ki tawan ci ariik maama ɔrɔɔt. Alaŋ zin bar niina tiŋeere een titiny ɔrɔɔt juk gotonogu, eeci baale alaŋ aŋole kuwen onan aneet baatun, ma ataŋguzu kibeen ŋaa onan kaavtiya. Makacin anyaayan alyaan ɔla.” ");
INSERT INTO mur_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Amayuk bodo Jakob Simiyan been Livai anek nɛ, “Niiga ramantiya Simiyan been Livai eeginu gɔtɔn, ma atobɔ igeet zinzeeti cugooc o teny. Uruktu baale niiga ɔl dilanyai kadaayitɔ gaga nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Alaŋ naana kareez baabaninok cugooc gɔɔn abaabanu oroonok o, ki minaŋɔn cunooŋ gɔɔn aruku ɔl kadaayitɔ gaga o. Alaŋ buk kagama gi o gɔɔn ateedu niiga tiin culu rɔkɔlit. ");
INSERT INTO mur_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Otoruŋ zin Jooi igeet giye ci gɔɔn aminaŋnyu, ma anyaku bolŋac ci aruku ɔl kadaayitɔ gaga o. Ma buk katoryuŋ naanalya igeet azaantozek loocok ci Israyil noko dook.” ");
INSERT INTO mur_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Amayuk bodo Jakob Juda anek nɛ, “Niina Juda anaatin katin gotonogu dook ineet, ma atitinyin ɔrɔɔt. Amogi katin niina modɛn ci amarninin ineet, ma buk katin gotonogu aŋolinin ineet. ");
INSERT INTO mur_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Abil katin niina Juda kiyo taŋaryai o gɔɔn aruk kelegit kadaak, ma amiironek ŋin onin ɔɔŋɛ, ma oodi, ma ɔɔŋ loota, ma akɔm eet ci anim kɔjɔŋɔz nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Anyei katin niina kɛɛt ci alaazetu nɔkɔ, ma agam katin dɔlya ci dɔl cugun alaazɛt nɔkɔ zɛɛ ma aku ɛɛti ween alaan adiŋdiŋ ɔrɔɔt, ma anyak alaazɛt dook. Katin modɛna o loocok dook atitiny nɔɔnɔ, ma azɔɔz gi cin doon. ");
INSERT INTO mur_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Acabi katin niina zigir cun keene o abon gɔɔn agɔɔnanɛ ɔl nyaantanɛ. Buk katin uuny niina rumanɛ cugun nyaana giye o ɛɛnɛ niina botoroc ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Een katin niina molyai ci rɛgɛ kɛbɛrɛ, eeci anyei niina dayiin ki nyaantanɛ ci meelik. Nyigita cugune noko katin vɔɔrɛ pɛr giye ci aamɛ iira ci meel.” ");
INSERT INTO mur_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Amayuk bodo Jakob Zebulon anek nɛ, “Niina Zebulon abaai katin liiltoga. Ma liil ɔtɔgi nici een katin ŋinti ɛɛlni kavoolɛta o liilo. Maje lɔɔci cune noko akɔ katin zɛɛ ma arum Sidon.” ");
INSERT INTO mur_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ma amayuk bodo Jakob Isikar anek nɛ, “Niina Isikar abil katin niina kiyo zigiri o adɔi gɔɔn ma arɔɔŋ karyekɛ ɔl ijo ka kitik, bar ɔɔŋ loota o. ");
INSERT INTO mur_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bar mazi acin kɔrɔk kibeen looc ci aavɛ noko abona, atik bodo kaal labak. Een katin niina gabaren ci atultul tup nɔkɔ calaŋ ayubuz.” ");
INSERT INTO mur_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ma amayuk bodo Jakob Dan anek nɛ, “Niina Dan katin abal ɔl cugun, ma katin ɔl cugune noko atobɔ niigi ki bor ci Israyil abal buk gotonogu ogɛn o. ");
INSERT INTO mur_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Atoroban gɔɔn katin niina ɔl kiyo kowat o gɔɔn adete gɔla ka kɛtɛŋɛt jɔm zooc ka ɛɛti o atɔɔt jɔm nico kuruk looc kɔbɔrbɔr o.” ");
INSERT INTO mur_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ɛgɛrɛny ni Jakob, ma ilalek Jook gɛrɛnya azi nɛ, “Jook o adiŋdiŋ, inoko kareyin naana ineet ka ɛɛlawan.” ");
INSERT INTO mur_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ma amayuk Jakob bodo Gad anek nɛ, “Niina Gad aŋozonekin katin ineet agoryawa, bar zin katin atooi niina nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Amayuk bodo Jakob Acar anek nɛ, “Niina Acar katin lɔɔci cune abaayɛ o abiirna kaal ci meel abon. Dayiin cugune o katin aganɔ ŋaati anyonekɛ alaat.” ");
INSERT INTO mur_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ma amayuk bodo Jakob Navtali anek nɛ, “Niina Navtali katin abil kiyo alyaz o gɔɔn olla awɔ tuuwa labak, ma anyak jɔrɔ ci alina o.” ");
INSERT INTO mur_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ma amayuk bodo Jakob Josev anek nɛ, “Niina Josev abil katin niina kiyo kɛɛt o gɔɔn aduŋna liiltoga appintik oto, ma abiirna kɛbɛrɛ ci meel o. ");
INSERT INTO mur_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Zin katin modɛna ci amarninin ineet agaŋnyakin, ma ooryin ineet pareni. ");
INSERT INTO mur_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bar zin katin parena cugune amɔk cigeecik o. Katin Jooi onane aneeta Jakob dɔyize onin amɔk doyizok dook anyek azɛɛn cugun o kodoyit ŋaati agamɛ paren. Nɔɔnɔ nɛɛn ween bɛ o aroodinɛ ɔl o Israyil kɔkɔm gi ci gɛr akunak nɔɔgɔ. Nɔɔnɔ nɛɛn ween bɛkcoi cineeŋ. ");
INSERT INTO mur_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Jook o baatun nɛɛn o ŋaan atiritin ineet. Anyak niini dɔyiz dook. Ŋaan zin amayukin niini ineet. Ŋaan amayukin niini ineet tiilɛza ki liilowɛ kibeen tiine ci meel. Arita katin ŋaai cugune o dɔl ci meel, ma irokta niina nɔɔgɔ juruŋ. ");
INSERT INTO mur_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Amayukin katin Jooi ineet ɛɛva kaal ci meel. Ayelekin katin niini ineet biyɛn baal ɛɛl tɔ ŋinaante laadun kina tamma e. Mayuwɛnɛt oninɛ ibil nɔkɔ izi nɛɛn kiyo biyɛn nici o. Abon bai anyin Jooi ineet mayuwɛnɛt cin noko, eeci ɛŋɛrawin niini ineet bil doon gotonogin dook.” ");
INSERT INTO mur_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ma amayuk bodo Jakob Bɛnjimɛn anek nɛ, “Niina Bɛnjimɛn abil katin niina kiyo kɛlaŋi o mooti gɔɔn olla aruk kɛlɛk tup nɔkɔ o.” ");
INSERT INTO mur_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nici zin gɔl o amayuwi Jakob lɔgɔz ogin nɛɛn. Iiya ni ɛɛti codoi gɔɔn logoze nicoko izi baati borit codoi boryowe o Israyil een amɔtɔ ram. Amayuk zin Jakob lɔgɔz ogin mayuwente ci gɔɔn aganɔ ki codoi ŋaatineeŋ dook. ");
INSERT INTO mur_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Mazi akɔ adadjai Jakob ka kadaak, itivatek niini dɔl ogin gi ci azi nɛ, “Inoko izi ŋinti ka kɛtɛɛdi. Ma kadaai, ɔɔtɔ adayaŋ boote o jijitigan, ");
INSERT INTO mur_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Bɔɔt nica abil mane o kazi Makvila libire ci akɔ ki jen e ŋaao kazi Mamra looce o kazi Kanan. Ataala baale laadun Ibrayim bɔɔt nice kibeen mana buk ŋaati Evron ween borit o ɔl o kazi Ititaz ka kizi bɔɔt cin dawiinto. ");
INSERT INTO mur_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nica zin ŋinbaal adawin Ibrayim kibeen ŋaa onin kazi Sara, kibeen buk Aizak ki ŋaa onin kazi Rebeka e nɛɛn. Ma buk vurta kiiya kadawɛ naana ŋaa onan kazi Leya. ");
INSERT INTO mur_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Karooŋnyuŋ zin buk igeet adayaŋ aneet boote nice.” ");
INSERT INTO mur_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Aduwa Jakob gi nico, ma ɛtɛɛt ecodoi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Mazi akɔ acin Josev ɛtɛɛt baatinɛ, iitak niini baatin, ma alu ŋaati acoci nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ma vurta uduwak niini ŋanbiyɛt kuḏuutek baatin agɛrɔ gole o kɛɛr uneeŋ ka calaŋ ame. Utuguzɔ ni niigi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ma aḏuutek niigi Jakob agɛrɔ iinya eet ram, eeci nici iinya o gɔɔn laadun aḏuutɛkɛ ɔl agɛrɔ ɔl ci adaai nɛɛn. Ma aluwek ɔl o Masiro Jakob iinya eet iiyu kamɔtɔ. ");
INSERT INTO mur_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Mazi akɔ adicai iinya ci luwanto o, enek Josev ɔl o Vɛɛro nɛ, “Itiritaŋ di. Ooti otok ci kitoonei Vɛɛro ce. ");
INSERT INTO mur_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Iitene baale aricanekan baaba gi ci ka kook kadawi naana nɔɔnɔ Kananakti. Uduktakaŋ zin Vɛɛro gi nico ka kanyan gɔl ci kakɔ kiyaŋɛ baaba ŋinaante. Ma kook kiyaŋa baaba, ŋaan kabada.” Ooti ni ɔl molok nico ŋaati Vɛɛro. ");
INSERT INTO mur_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ma itoona Vɛɛro otok ci anek Josev nɛ, “Bitɔ itaŋ baatun ŋinaante labak eci da aricanekin niini ineet o.” ");
INSERT INTO mur_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Itiŋa ni Josev ka kook kiyaŋ baatin Kananakti. ");
INSERT INTO mur_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ma ɔrkɔr niini kibeen gɔtɔnɔgi been ɔl o kɔrɔk o baatin dook. Ma ooŋnonek looc ɔlɔ ŋaao kazi Gocen dɔlya o miliny ki tiin been ɛɛza doon. ");
INSERT INTO mur_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ma ɔrkɔr buk niini kibeen ɔl ween alaat Masirɛ been ɔl o Vɛɛro mayan. Atɔɔt ɔl ogɛn kavoolɛt o agurut jɔmanɛ, maje ogɛn atɔɔt jɔmanɛ. Ma awɔ niigi dook kizi kolen ci appe. ");
INSERT INTO mur_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ɔɔtɔ ni zɛɛ ma avɔ arum ŋino gɔɔn uurtanɛ ɔl labi kazi Atat ajɔŋɔz liil o Jordan looce o Kanan. Omonit ni niigi ŋinaante, ma aluwek bodo Jakob iinya torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Mazi acin ɔl o looc o kazi Kanan nɔɔgɔ alu nɔkɔ, izitɔ nɛ, “Naa iboobi ɔl ci Masiro o ɔrɔɔt nɔkɔn?” Zin luwante nico akatek ɔl ci Kanan o ŋinite zaar ci kazi Abilmizram. Kɛŋ cin kazi nɛ luwa o Masiro. ");
INSERT INTO mur_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Utuguzɔ ni didi lɔgɔz o Jakob gi baal aricanek baatineeŋ nɔɔgɔ e. ");
INSERT INTO mur_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ooti niigi baatineeŋ, ma avɔ itaŋ boote baal ataala Ibrayim ŋaati Evron ka kizi ŋintineeŋ dawiinto e. ");
INSERT INTO mur_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Mazi akɔ iyaŋ Josev baatin, imiirte niini ki gɔtɔnɔgi been ɔl baal ɔrkɔra e dook ɔɔt Masirɛ. ");
INSERT INTO mur_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ma vurte o ipirai Jakob, anyayit gɔtɔnɔgi Josev ŋoliin, ma anɔ nɛ, “Bar bɔŋ katin Josev aborneket nɔŋ, ma acaca kaal baal kagoonek naaga nɔɔnɔ gɛr e?” ");
INSERT INTO mur_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Itoontek ni niigi Josev otok ci anek nɛ, “Baale ma ŋaan arogi baatinai e, aneket nɛ, Abona aduwaku Josev ka kotoŋ kaal baal gɛr agooneku niiga nɔɔnɔ e calaŋ aada. Ɛɛlawet zin da tooŋ kaal ci gɛr baal kabacana ŋaatun o, eeci keegina buk naaga gabara ci Jook o baatun.” Mazi akɔ arum Josev ɔtɔgi nici, utulu. ");
INSERT INTO mur_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ma iitene oman ivitak gɔtɔnɔgja nɔɔnɔ, ma avu akani kozoŋti looc nɔɔnɔ ŋuma, ma anek nɛ, “Keegina naaga gabara cugun.” ");
INSERT INTO mur_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Enek ni Josev nɔɔgɔ nɛ, “Má aŋolinaŋ gaga. Alaŋ keen naana Jook ka kapayeyuŋ igeet gerzitin. ");
INSERT INTO mur_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Agoonekaŋ didi waanice niiga gi ci gɛr, bar zin Jooi abali gi nice kizi gi ci abon ka korogoz ɔl ci meelik magiza. ");
INSERT INTO mur_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Akɔm zin niiga gi ci ka ɔtɔŋɔltɛ. Ŋaan kazuunuŋ naana igeet ki dɔl ugooc.” Zin gole nico itilo Josev gɔtɔnɔgi, ma oobek kaal nɔɔgɔ zɛɛ makacin alalit zinzeeti labak. ");
INSERT INTO mur_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Abaayit ni Josev been ɔl o kɔrɔk o baatin dook Masirɛ ŋinti wun kal. Ma arogi niini zɛɛ ma acin dɔl o ŋɛɛrin ween abuu kazi Iviram ki dɔl ci dɔl ogin. Ma buk icin niini dɔl ci Macir ween ŋɛɛrti ŋɛɛrin o kazi Manasa. ");
INSERT INTO mur_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Mazi akɔ adadjai Josev, ma agawun niini izi ŋinti ka kadaai, enek gɔtɔnɔgi nɛ, “Izi inoko ŋinti ka kadaai. Ŋaan zin azuunuŋ Jooi igeet. Ŋaan katin aaranuŋ niini igeet looce nico, ma akoyuŋ looce baal aterkedek niini Ibrayim ki Aizak been Jakob e.” ");
INSERT INTO mur_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Anyek ni Josev nɔɔgɔ kitoonit Jook giye ci ka kuzuuti zɔɔz o aduwak niini nɔɔgɔ baal anek nɛ, “Iitene ci katin akoyuŋ Jooi looce nice, abona buk avoyu amɛ ogan ka ɔɔt itaŋit ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Enico ɛlɛ ɛtɛɛt niini. Aje irkitowa oginɛ waanice izi eet tur kamɔtɔ (110). Ma aḏuutek ŋanbiyɛta nɔɔnɔ agɛrɔ ka calaŋ ame. Artek ni ɔl nɔɔnɔ loidoŋ o adikir gɔɔn itaŋi ɔl gɔnɔgi o adaai, ka kibil niini kɛrɛ iiten ci katin avɔyi niigi Kananakti.");
INSERT INTO mur_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Zaar ci ɔl ween jijitigi Yesu ween Kiristo ween dole ci dɔl o Devid ween ŋɛɛrti Ibrayim o karɛ naaga ɔl o Juz nɔɔnɔ ka kiiya nɛɛn ce. ");
INSERT INTO mur_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrayim baale baati Aizak. Aizak baati Jakob. Jakob baati Juda ki ŋɛɛrigin oogi. ");
INSERT INTO mur_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda baati Paraz kibeen Zera ween yaatineeŋ nɛɛn Tamar. Paraz baati Ezron. Ezron baati Raam. ");
INSERT INTO mur_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raam baati Aminadab. Aminadab baati Nacon. Nacon baati Salmon. ");
INSERT INTO mur_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon baati Bowaz baal kazi yaatin nɛ Reyab. Bowaz baati Obɛd baal kazi yaatin zaar nɛ Ruz. Obɛd baati Jesi. ");
INSERT INTO mur_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi baati alaan o kazi Devid. Devid baati Solomon. Yaatinɛ baale rak ŋaa ci eet o kazi Oraya. ");
INSERT INTO mur_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon baati Riyoboyam. Riyoboyam baati Abija. Abija baati Asa. ");
INSERT INTO mur_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa baati Jeyozivat. Jeyozivat baati Joram. Joram baati Uziiya. ");
INSERT INTO mur_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziiya baati Jotam. Jotam baati Eyaz. Eyaz baati Izakiya. ");
INSERT INTO mur_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Izakiya baati Manasa. Manasa baati Amoon. Amoon baati Josiya. ");
INSERT INTO mur_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya baati Jikoniya ki gɔtɔnɔgi baal aritai waan baal agamin ɔl o Israyil, ma avɔyi ɔl nɔɔgɔ looce o kazi Babilan e. ");
INSERT INTO mur_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Zin vurta mazi akɔ agamnyi ɔl o Israyil, ma avɔyi ɔl nɔɔgɔ Babilana, Jikoniya ook izi baati Sɛlitil. Sɛlitil baati Zarubabel. ");
INSERT INTO mur_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabel baati Abiyud. Abiyud baati Iliyakim. Iliyakim baati Azɔr. ");
INSERT INTO mur_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azɔr baati Zadok. Zadok baati Acim. Acim baati Eliyud. ");
INSERT INTO mur_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud baati Eliyezar. Eliyezar baati Maatan. Maatan baati Jakob. ");
INSERT INTO mur_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob baati Josev ween eet o Meri ween yaati Yesu ween Kiristo. ");
INSERT INTO mur_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Izi zin bulowa ci ɔɔtɔ dook amɔtɔ wec akanai ŋaati Ibrayim zɛɛ been Devid. Bodo akanai ŋaati Devid zɛɛ been iiten baal agamin ɔl, ma avɔyi ɔl nɔɔnɔ Babilana e bulok amɔtɔ wec. Bodo akanai iinyaye baal agamin ɔl e zɛɛ been iiten baal aritan Kiristo e bulok amɔtɔ wec. ");
INSERT INTO mur_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Zin Yesu Kiristo aritai gole ci abil kete. Baale yaatin Meri agam ɛɛti ci kazi Josev ka kiriyi. Mazi ŋaan kitivica niini nɔɔnɔ, bar ajowa Meri ɛlɛ anyake dolece ci anyononek Vɔŋize o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maje Josev baale niini eet ci abon, ma alaŋ arɔɔŋ kɔbɔrak ɔl nyayiin ci Meri o, bar abaaban olla arɔɔŋ kotoŋ nɔɔnɔ nɔkɔ yɔɔt calaŋ akɔlak alyaan. ");
INSERT INTO mur_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mazi ŋaan abaaban niini gi nico, iiyak nɔɔnɔ toonnyaiti ci Joowo wunozyai, ma aku anek nɛ, “Josev, borit o tatok o Devid, má abur Meri ŋaati avicanɛ kizi ŋaa cun gaga, eeci dole ci anyak niini kɛŋa noko anyek nɔɔnɔ Vɔŋizi o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Arita tiŋeere logoz, ma akanei zaar ci kazi Yesu, eeci aku niini ka kiiya kɛɛla ɔl ogin baciinowɛ.” ");
INSERT INTO mur_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Akatai ni didi kaal nicigi kɛzɛdjai dook kɛlɛɛmtɛ ebaal aduwakɛ Jooi nyakaŋan zooze o anɛ nɛ, ");
INSERT INTO mur_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Anyake katin kabarzɛci oman gole ci abiirni ɔl ooti, ma arita logoz, ma akanonek katin nɔɔnɔ zaara ci kazi Imanawil.” Kɛŋ ci zaar nicoko kazi nɛ Aavi Jooi Ŋaatinai. ");
INSERT INTO mur_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Mazi akɔ aŋaaz Josev ooŋnyai, iiya didi ook itivica Meri eona aduwaki toonnyaiti o Joowo nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mazin iinya ci baal anyayin Meri neke dook ŋaan koromtɛ Josev ki nɔɔnɔ kizi ŋaa ki eet zɛɛ ma akɔ ookcai. Mazi ookcai dole, akatek Josev nɔɔnɔ zaar ci kazi Yesu. ");
INSERT INTO mur_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aritai zin waanice Yesu kuture o kazi Bɛzilɛm looce o kazi Judiya irkite o ɛɛnɛ Erod alaan. Ŋintimiliny nɔkɔ ivita ɔl ogɛnɛ ole o gɔɔn iiyez kaal monyonyɛ libire ci jenu o ivitak Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma avu ajine azi nɛ, “Aavi logoti o aritai ka kizi alaan unooŋ Juz ŋaaḏaŋ? Ayelzai monyatot oninɛ kicinta libire ci jenu kabaaka naaga e. Zin kanowana ka kiiya kidiŋdiŋanta nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Mazi akɔ azii Erod ween alaan kibeen ɔl dook Jerusalɛma zɔɔz nico, ivirit nɔɔgɔ zinzeeti ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma awa Erod alaat o ceez o Joowo been alaat o demziinto ŋaatodoi, ma ajin nɔɔgɔ gɛnyiza anek nɛ, “Kiristo aritai dim katin ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Aritai katin niini kuture o kazi Bɛzilɛm looce o kazi Judiya. Anyak baale nyakaŋan ci ayɛɛt zɔɔz ci anɛ Jooi nɛ, ");
INSERT INTO mur_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ineeta kutur o kazi Bɛzilɛm o abil Judiya adiŋdiŋ niina ɔrɔɔt, eeci aritai katin ŋaatun alaani ci ka kiiya kabal ɔl ogan Israyil.” ");
INSERT INTO mur_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Otowa ni Erod ɔl o avu libire o jenu e ka kɔɔt kozoozɔ ki nɔɔgɔ ŋaatineeŋ doon, ma aku ajin niini nɔɔgɔ iiten ci da acini niigi monyatot ci tiryan ci dole ci ka kizi alaan ci Juz o. Ma aduwak niigi nɔɔnɔ iiten ci baal acini niigi monyatot o. ");
INSERT INTO mur_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma anek Erod nɔɔgɔ gɛnyiza nɛ, “Ɔɔtɔ zin orooŋit dole nico Bɛzilɛma juruŋ zɛɛ mazi ajowanu, ivita buk uduktayaŋ aneeta ka kook kidiŋdiŋan buk naana nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mazi adotiz zooze ci ona aduwak alaani nɔɔgɔ o, ɔtɔɔzɔ. Ma gɔla icinit niigi bodo monyatot baal rak acin e ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ma atalnɛ niigi ɔrɔɔt ɛlɛ. Ma oontanɛ monyatot nici nɔɔgɔ ŋuma nɔkɔ zɛɛ ma akɔ abil ŋaati ona aavɛ dole o ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ŋinaante mazi avɔ niigi ceeza eecitɔ, acin dole ki yaatin Meri, ma akani niigi kozoŋti looc adiŋdiŋan nɔɔnɔ. Okolit ni kaboot ugeec anyak e, ma anyek niigi nɔɔnɔ kaal ci titiny, warki ki karacɛnɛn been karkarɛt. ");
INSERT INTO mur_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Uduwak ni Jooi nɔɔgɔ wunozyai gi calaŋ amiirɔnɛkɛ Erod. Ma ŋeere imiirte didi niigi gole oman ɔɔt looce uneeŋ calaŋ adiir Erod. ");
INSERT INTO mur_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma vurte o imiirtɔi ɔl nica, iiyak toonnyaiti ci Joowo Josev wunozyai, ma aricanek gi ci anek nɛ, “Tiŋa je! Dɔkɔnyi dole ki yaatin biti Masirɛ. Bitɔ aavu ŋinaante zɛɛ ma kanekin nɛ, Bada bodo, eeci tiŋeere Erod arɔɔŋ dole ka kuruk kadaak.” ");
INSERT INTO mur_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Itiŋa ni Josev ecodoi nɔkɔ iyiit dole ki yaatin baaline nico ɛlɛ ooyi Masirɛ. ");
INSERT INTO mur_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma akɔ abaak ŋinaante zɛɛ ma adaai Erod. Zin gi nici agooni o ka kɛlɛɛmɛ zɔɔz baal azi Jooi nyakaŋane onin nɛ, “Kotowa ŋɛɛran Masirɛ ka kimiirozek looc baal aritan e.” ");
INSERT INTO mur_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mazi akɔ aga Erod ɔl baal avu libire o jenu e alaba da bar nɔɔnɔ, otobor nɔŋ ɔrɔɔt ɛlɛ. Ma aricanek takirnya kɔɔt kuruyit dɔl o miliny macik anyak irkitok ram been o miliny tɛr ŋaan aritai Bɛzilɛma been vitɛnane o ajɔŋzɔ dook. Agɔɔn Erod nɔkɔ o, eeci aduwak ɔl baal avu libire o jenu e nɔɔnɔ zɔɔz ci anek nɛ, “Izi irkitowa ci ɔɔtɔ iiten baal kacina monyatot e zɛɛ been inoko o ram.” Gi ci zin aruyi Erod dɔl ci miliny anyak irkitok ram been o ŋaan kurumit irkitok nicoko o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Zin giye o aruwɛn dɔlya kadaayitɔ Bɛzilɛma ɛlɛɛmnyai zɔɔz baal aduwa nyakaŋani o kazi Jirimaya e didi. ");
INSERT INTO mur_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Azi baale niini nɛ, “Iziiyɛ mɔlɔyi ci aluwɛki Recal dɔl ogin kuture o kazi Rama nunun. Aboobi niini nɔkɔ zɛɛ ma alaŋ ajaki been nɛɛn, eeci dɔlya oginɛ dook adaayitɔ.” ");
INSERT INTO mur_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mazi akɔ adaai Erod, iiyak toonnyaiti ci Joowo Josev wunozyai Masirɛ. ");
INSERT INTO mur_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ma aku anek nɔɔnɔ nɛ, “Tiŋa je. Miirɔi dole kibeen yaatin biti looce o Israyil. Eeci ɔl baal arɔɔŋ kuruyit dole kadaak e adaayitɔ.” ");
INSERT INTO mur_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Itiŋa ni Josev iyit dole ki yaatin abadakɛ looc o Israyil. ");
INSERT INTO mur_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bar mazi akɔ azii bodo niini Arkiloz irigiz alaazɛt o baatin Erod abalun Judiya, ɔtɔŋɔlɛ niini ŋaati akɔ abaai ŋinaante. Zin buk itilo Jooi nɔɔnɔ gɔla wunozyai laadun ka calaŋ akɔ Judiya. Ook ni niini abaak looce o kazi Galili. ");
INSERT INTO mur_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Aruwek niini kɔrɔk looc kuture onin kazi Nazarɛt. Itiroyai ni Yesu ŋinaante zɛɛ ma adikir, ka kɛlɛɛmɛ gi baal aduwa nyakaŋani azi nɛ, “Katin aga ɔl dook niini eet ci Nazarɛt.” ");
INSERT INTO mur_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma vurta irkitowe ogɛn iiya ɛɛti ci kazi Jɔn o oonyi, ma akana niini uuwayi balala looce o kazi Judiya. ");
INSERT INTO mur_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Agɛrɛny niini iinya dook anek ɔl nɛ, “Otoŋit baciinok ugooc gɛr agoonu, eeci baliin o Joowo izi ajɔn.” ");
INSERT INTO mur_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔn zin nɛɛn baal aduwa nyakaŋani o kazi Izaya e. Azi baale niini nɛ, “Agɛrɛny ɛɛti oman balala azi nɛ, Idimdimantek Manyi gɔl onin. Amadek nɔɔnɔ golok ogin keelit tɔp.” ");
INSERT INTO mur_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ma Jɔn nici waanice aborcek niini rumanɛ ci agɔɔnnyai imane ci nyakaletu. Ma anyak kavali ceen ruceen barkɔnya, ma adak niini giroc ki lɛtɛ kizi dayiin cigin nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma avunak ɔl dook nɔɔnɔ Jerusalɛma ki Judiya buk kibeen vitɛne o ajɔŋɔz liil o kazi Jordan dook. ");
INSERT INTO mur_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma avu abad niigi mony baciinowe ugeec, ma oony niini nɔɔgɔ liile nico. ");
INSERT INTO mur_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mazi acin Jɔn ɔl o kazi Parici kibeen ɔl o kazi Sajuzi avunak nɔɔnɔ ka kivita kicinit kaal ci agɔɔn niini o, enewun nɔɔgɔ nɛ, “Igeet dɔl ci kokonyawu coko! Ŋɛnɛɛn ci ilotuŋ ka odokonyit bornɛt noŋe o Joowo ka kiiya tiŋeere neke o? ");
INSERT INTO mur_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Abon zin agoonu kaal ci abon ci ayelza gi ci utuŋtu niiga kaal o gɛr didi. ");
INSERT INTO mur_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Má bar anonu nɛ, Keegina dɔl ci dɔl o Ibrayim. Didilɛ kaduwakuŋ igeet, Jooi anyak dɔyiz ci ookci biyɛn nico kiziti dɔl ci Ibrayim labak. ");
INSERT INTO mur_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Eelnu niiga kiyo kɛɛna. Olla zin inoko mɛlɛyi o payiin o Joowo ɛrɛwɔ ka kɛɛcawuŋ loota kiyo kɛɛca kɛɛt o. Gɔɔn zin laadun kɛɛt calaŋ arek kɛbɛrɛ ci abon, atɛɛdjak looc, ma akanonek goo. ");
INSERT INTO mur_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kuunyuŋ zin inoko naana igeet maami doon ka keyelizyai badi mony o baciinok ugooc. Bar anyak eet oma ci ŋaan aku ka kiiya kotoony ɔl oogi ŋaatunooŋ Vɔŋize o Joowo, ma apayek oogi goo. Adikir niini ɔrɔɔt kujukan aneet. Ma alaŋ kaganona kanyayek naana nɔɔnɔ caava ogin zoonu. ");
INSERT INTO mur_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anyaa niini luli ci arekɛ labi ŋɔɔt ka kɛŋɛr labi ki jululu. Ma arek labi kɛbɛrɛ karat, maje jululu avaat gooye o alaŋ adiiti been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ma iitene nice iiya Yesu looce o kazi Galili. Aku akɔ ŋaati Jɔn ka kook kotoony Jɔn nɔɔnɔ liile o kazi Jordan. ");
INSERT INTO mur_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Maje Jɔn arɔɔŋ kujura ŋaati oonyi nɔɔnɔ, eeci aga niini anyak Yesu dɔyiz ci appe kujuk nɔɔnɔ. Ma anek Jɔn nɔɔnɔ nɛ, “Alaŋ aganɔ ŋaati kuunyin naana ineet, bar karooŋnyin ineet toonyan aneet.” ");
INSERT INTO mur_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Anyek kibil kiyo kaduwakin noko. Abon kagɔɔn naaga nɔkɔ rak ka koolyai gi o arooŋekan Jooi aneet kutugu.” Agama ni Jɔn zɔɔz nico, ma oony nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Mazi akɔ adotiz toonyɛnta, ɔyɔyai Yesu maami, ma akole tammu kɛŋ, ma acin niini Vɔŋiz o Joowo ŋaati akunakɛ looc kiyo yɛɛlac o, ma aku abil ŋaatin. ");
INSERT INTO mur_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma azi mɔlɔyi ci aku Joowa tammu tadena nɛ, “Ŋɛɛran onan kareez nɛɛn nici. Katalnɛ naana ŋaatin ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iyit ni Vɔŋizi o Joowo Yesu ooyi balala ka kook kicina Loryenti nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Mazi akɔ aavi niini ŋinaante kɔkɔm dayiin iinya eet ram been baalinok eet ram, aburek nɔɔnɔ magiz ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iiyak ni Loryen nɔɔnɔ, ma aku anek nɛ, “Mã een didi ŋɛɛrti Joowo, towo di biyɛn nicoko kizi dayiin.” ");
INSERT INTO mur_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm! Azi waragɛwi o Joowo nɛ, Alaŋ ɛɛti ci deer arogni dayiin doon, bar buk arogni niini zoozok o aduŋna otoge o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Itiŋawi ni bodo Loryen Yesu ŋinaante ooyi Jerusalɛma, ma akɔ atɔɔdi ceez o Joowo taden. ");
INSERT INTO mur_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma anek nɔɔnɔ nɛ, “Mã een ŋɛɛrti Joowo didi, kul di ŋinaanto taak tɔdɔ, eeci azi waragɛwi o Joowo nɛ, Ŋaan itoona Jooi toonnyak ogin ka kivita katabuŋtawin niigi ineet calaŋ iinai looc kuruktin biyɛn zɔɔ.” ");
INSERT INTO mur_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm! Azi buk waragɛwi o Joowo nɛ, Má acina Jook ween Manyi unun.” ");
INSERT INTO mur_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Itiŋawi ni Loryen Yesu ŋinaante bodo ooyi biye ci wun kal, ma akɔ ayelek nɔɔnɔ diŋdiŋɔn o baliin o loocu dook. ");
INSERT INTO mur_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma anek niini Yesu nɛ, “Mã akanɛ kozoŋti looc, ma adiŋdiŋanan aneet, kanyin koca kaal ci acin noko dook kizi cugun.” ");
INSERT INTO mur_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Ineet Loryen, nyɛyɛ ŋaatan! Azi waragɛ o Joowo nɛ, Idiŋdiŋanit Jook ween Manyi unooŋ. Iliŋliŋtozek nɔɔnɔ doon.” ");
INSERT INTO mur_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ɔɔtɔ ni didi Loryen ŋaatin, ma avu toonnyawa o Joowo, ma avu atirit Yesu. ");
INSERT INTO mur_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Ma iitene oman mazi akɔ azii Yesu acabit ɔl Jɔn, itiŋa niini imiirozek kutur o kazi Nazarɛt abil Galiliya, ma ŋaan buk kook komon ŋinaante ŋinti wun, bar idicek ook abaak kuture o kazi Kapernam abil liil o Galili otoga ŋaati ajɔŋɔzɔ ki loocok o kazi Zebulon been Navtali. ");
INSERT INTO mur_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ma akɔ uuwak niini ŋinaante ka kɛlɛɛmɛ gi baal aduwa nyakaŋani o kazi Izaya baal anɛ nɛ, ");
INSERT INTO mur_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Loocok o kazi Zebulon kibeen Navtali noko ɛɛl liil o Jordan baagita looce o kazi Galili abaayi ɔl o Juz kibeen buk modɛn oogi. ");
INSERT INTO mur_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ma ɔl o abaak muure o anyak daayiz ŋinaante acin iima vooritin ci appe ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ma iitene nice akata Yesu uuwayi onin anek ɔl nɛ, “Otoŋit baciinok ugooc, eeci baliin o Joowo izi ajɔn.” ");
INSERT INTO mur_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ma iinyaye niceke mazi akɔ awɔ Yesu liil o Galili otoga, icin niini ɔl ceen ram adete cabaya, Saiman o kazi Pitɔr kibeen Andoru ween gɔtɔni. ");
INSERT INTO mur_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma anek Yesu nɔɔgɔ nɛ, “Ivita korkorit ki aneet. Ŋaan kakɔ kademezuŋ igeet ka edetit ɔl ci deer ka gɔɔn anyaaktak nɔɔgɔ Jook.” ");
INSERT INTO mur_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Enico ɛlɛ otoŋtek niigi cabayɛt ugeec e looc, oneec nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mazi ŋaan awɔ niigi ŋintimiliny nɔkɔ, acin Yesu bodo ɔl oogi ceen gɔtɔn een ram, Jemis ki Jɔn. Aromɛ niigi kibeen baatineeŋ ci kazi Zebedi kavoola. Acap cabayɛt juruŋ ka kedetit. Ma awa Yesu nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Enico ɛlɛ otoŋtek niigi kavool kibeen baatineeŋ looc, ma ɔrkɔr kibeen Yesu. ");
INSERT INTO mur_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ma azɔp Yesu Galili dook adɛmɛz ɔl ceezine o ɔl o Juz lotento, ma uuwak kaviyak o abon akati baliin o Joowo, ma arogoz niini ɔl ci olla ajowa moorizowe ci meelik keŋti gɛr. ");
INSERT INTO mur_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma avɔ kaviyawa ciginɛ o kɔɔt kiziiktɛ looce o kazi Siriya rɛɛna many. Ma anyaak ɔl nɔɔnɔ ŋinaante ɔl ci anyak moorizok kɛbɛrɛ dook ka kiiya korogoz niini nɔɔgɔ. Ma arogoz didi niini ɔl nicoko dook, mayo nuun een ɔl o anyak miniŋ ci Loryento ki ɔl ci abice ki ɔl ci rɛbrɛbik arogoz buk. ");
INSERT INTO mur_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma ano nɔɔnɔ ɔl ci meel Galiliya ki Dekapolisa ki Jerusalɛma ki Judiya been ɔl o abaak liil o Jordan baagita. ");
INSERT INTO mur_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mazi akɔ acin Yesu kɔlɛ ci meel avunak nɔɔnɔ nɔkɔ, ɔtɔɔt bɛ, ma akɔ aavi loota bɛ ɔɔwa. Ma avu aliya nuyawa oginɛ nɔɔnɔ kau. ");
INSERT INTO mur_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ma akana niini demziin ci adɛmzi nɔɔgɔ azi nɛ, ");
INSERT INTO mur_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Amayuwi ɔl o arɔɔŋ gɔl o Joowo, eeci baliin o Joowo izi cineeŋ. ");
INSERT INTO mur_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Amayuwi ɔl o abad mony zinzeetinɛ kaale ugeec agɔɔn, eeci tiŋeere azoozek Jooi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amayuwi ɔl o acɛlbɛzan eleeti, eeci tiŋeere ajowa niigi kaal o aterkedek Jooi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Amayuwi ɔl o arɔɔŋ kuzuuti zɔɔz o Joowo doon kujuk kaal dook loota, eeci ŋaan atirit Jooi nɔɔgɔ kutuguzɔ kaal ci abon. ");
INSERT INTO mur_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Amayuwi ɔl o awucnek gɔnɔgja ogɛn, ma alaŋ acaca kaal o gɛr agoonek ɔl nɔɔgɔ, eeci buk tiŋeere awucnek niigi Jook. ");
INSERT INTO mur_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Amayuwi ɔl o iimi zinzeeti ŋaaten Jook, eeci tiŋeere acin niigi Jook. ");
INSERT INTO mur_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Amayuwi ɔl o aliŋliŋ ganɔn ɔla, eeci tiŋeere anyek Jooi nɔɔgɔ kizi dɔl cigin een didi. ");
INSERT INTO mur_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Amayuwi ɔl o agide giye o agɔɔni kaal o aricanek Jooi nɔɔgɔ kutuguzɔ, eeci baliin o Joowo izi cineeŋ. ");
INSERT INTO mur_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Amayuwenu niiga, eeci gɔɔn amezu dominɛt ki gidɛn o akanuŋ ɔl igeet vɔlɔŋa giye o anuyaŋ niiga aneet. ");
INSERT INTO mur_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Amayuwenu niiga ɔrɔɔt ɛlɛ, eeci azoonekuŋ Jooi vɔyit ci appe ɔrɔɔt tammu tadena. Agaac zin buk baale nyakaŋanɛta o Joowo amɛz gidɛn kiyo niiga noko. ");
INSERT INTO mur_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Eelnu niiga kiyo mɛlɛ o ɔla dook loota ŋina. Bar zin gɔɔn mã idicai mɛlɛ mokcarɔnti, akɔm bodo gɔl oma ci ka kanycekɛ komokcar been nɛɛn. Izi gɛrzɛ nɔkɔ zɛɛ ma ajukonek tuu kizi gi ci labak, ma arɔc ɔl zɔɔnɛ. ");
INSERT INTO mur_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Eelnu niiga kiyo vooritin o modɛni dook loota ŋina. Gɔɔn kuturi ci ɛɛnycai bɛ ɔɔwa, alaŋ aroodi ŋaati acini ɔl been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Akɔm eet ci atokol lamba muura, ma abuŋ ija. Bar atokol, ma anyek kataraan ceez kɛŋ dook. ");
INSERT INTO mur_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Abon zin buk niiga ataranu ɔl dook loota ŋina kaale ugooc abon agoonu ka kanycek niigi baatinai o aavi tammu tadena zany bonate unooŋ. ");
INSERT INTO mur_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Má abaabanu aziyu nɛ, Kakun ka kiiya kuulal waragɛ o Joowo. Akɔm! Alaŋ kakun ka kiiya kutugu nɔkɔ, bar kakun ka kɛlɛɛmnyai keŋti ci zoozok o ayeedi waragewe o Joowo keelit tɔp. ");
INSERT INTO mur_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Didilɛ kaduwakuŋ igeet, akɔ zɛɛ ma aṯornɛkɛ tammu taden ki tɔdɔ, akɔm lotinowe nicoko ŋintimiliny tɛr aaryai been nɛɛn zɛɛ ma iina kaal o aduwa Jooi waragewe onin dook. ");
INSERT INTO mur_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ma ɛɛti ci acɛlbɛzan lotinɛt ci miliny lotinowe o Joowo, ma bar anyek kizi gi ci miliny labak, ma adɛmɛz gɔnɔgi oogi kutuguzɔ kiyo niini o, acɛlbɛzɛni buk katin niini baliinte o Joowo kizi gi ci labak. Maje ɛɛti ci azooni lotinok nicoko, ma adɛmɛz gɔnɔgi oogi kuzuuti kiyo buk niini o, adiŋdiŋani buk katin niini baliinte o Joowo nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kaduwakuŋ zin naana igeet, mã alaŋ abonanu ɔrɔɔt zinzeetine ugooc ujukit bonat ci ɔl o Parici kibeen alaat o ademzek ɔl lotinok, alaŋ avoyu baliinte o Joowo been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Aziiŋnu baale gɔɔn azi kɛɛrita ogaac nɛ, Má amuny eet ci deer. Mã alam eet ci amony eet ci deer, abon anyaayak rooni. ");
INSERT INTO mur_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bar zin naana kanekuŋ nɛ, Mã alam eet ci olla abornek gɔn nɔŋ, apawonek nɔɔnɔ gerzitin. Mã anek ɛɛti gɔn nɛ, Olla niina arogi gaga, akɔm gi ci ka doma, abon apawonek buk nɔɔnɔ gerzitin. Maje ɛɛti ci anek gɔn nɛ, Een niina aliyai ci ḏɔmḏɔm, ajukonek niini goo o Loryento. ");
INSERT INTO mur_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Zin gɔɔn mã anyak gi ci arooŋ ka taabi Jook ŋaao taabinto, ma anyak da eet oma ci abornekin nɔŋ, toŋek rak gi ci ona anyaai Jook noko looc ŋina, iyiik rak ɔɔtɔ idica ki gotonu gi ci abornekin niini ineet nɔŋ o zɛɛ abada ni ka ija taap Jook. ");
INSERT INTO mur_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mã anyak eet ci arɔɔŋ kooyin ineet rooni, abon aminyu niina ki nɔɔnɔ idica gi nico taman gɔla ŋina ɛlɛ ŋaati ŋaan urumti rooni. Mã alaŋ agoon nɔkɔ, akoyin koca niini ineet alaane o roonnyo, ma ŋinaante anyek alaani nici takirnya kɔɔt kacaptin ineet. ");
INSERT INTO mur_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Didilɛ kaduwakin ineet, mã ŋaan ruk karama, alaŋ koca oogjai been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aziiŋnu baale gɔɔn azi kɛɛrita ugooc nɛ, Má adoma zoocmaz. ");
INSERT INTO mur_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bar zin inoko kaduwakuŋ naana ineet kanekuŋ nɛ, Mã anyak eet ci olla acin ŋaa culu alina, ma arɔɔŋ ziniza kɛlɛɛmtɔ ki nɔɔnɔ, utuguzɔ bar niini zoocmaz ki nɔɔnɔ odota ŋume o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Zin mã abacakin kɛbɛrɛci cune azo o gi ci gɛr, kata bitaala kodowiwin kɛbɛrɛci. Abon bar ŋaati adowinin kɛbɛrɛci kujuk ŋaati anyayɛ kɛbɛrɛ dook, ma ajukonek ɛlɛ dook goo o Loryento eecitɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mã anyin aziiti cune azo o baca baciinok, tɛɛdak bitaalin jukek tuu. Abon bar ŋaati adowinin aziiti kujuk ŋaati anyayɛ azɛɛn dook, ma ajukonek ɛlɛ dook goo o Loryento. ");
INSERT INTO mur_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Aziiŋnyu baale gɔɔn azi kɛɛrita ugooc nɛ, Mã atɔɔk ɛɛti ŋaa cin, abon ayɛɛdak niini nɔɔnɔ waragɛ ci aryanto. ");
INSERT INTO mur_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bar zin inoko naana kanekuŋ nɛ, Mã atɔɔk ɛɛti ŋaa cin gaga nɔkɔ ŋaati alaŋ agami zoocmaza, ma akɔ ariyi ŋaa nico bodo ɛɛti oman, anyek niini ŋaa nico kodoma zoocmaz. Buk ɛɛti ci ariyi nɔɔnɔ o odoma zoocmaz. ");
INSERT INTO mur_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aziiŋnu baale gɔɔn zɔɔz ci azi nɛ, Má itoonu zaar o Joowo gaga. Bar mã itoontu Jook, abon didi agoonu gi nico. ");
INSERT INTO mur_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bar zin inoko naana kanekuŋ nɛ, Má itoonu Jook been nɛɛn. Buk má itoonu tammu taden, eeci tammu tadena ŋino abaai Jooi alya nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Buk má itoonu tɔdɔ, eeci tɔdɔwa een ŋino ataadek Jooi zɔɔ nɛɛn. Buk má itoonu Jerusalɛm, eeci een kutur o alaan o adikir nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Má bar buk itoonu eleeti ugooc maany, eeci alaŋ niiga aganeku otoweec imitat codoi ṯɔr ootine cugooc o kizi vɔɔr, karabɔŋ kizi koli. ");
INSERT INTO mur_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Olla gɔɔn iziti nɛ, Yɔŋ, karabɔŋ aziyu nɛ, Akɔm! Eeci zoozowa ogɛn ci arooŋnyu udukta neke avu Loryenta. ");
INSERT INTO mur_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iziiktu buk baale azi ɔl nɛ, Mã akana ɛɛti gɔn keberec, akata buk nɔɔnɔ keberec. Mã aliba ɛɛti gɔn nyigitat, ilibta buk nɔɔnɔ nyigitat. ");
INSERT INTO mur_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bar zin naana inoko kanekuŋ nɛ, Mã agoonekin ɛɛti gi ci gɛr, má acaca been nɛɛn. Mã arookin ɛɛti voret ci azo o, towek bodo ci kaŋeto o. ");
INSERT INTO mur_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mã akoyin ɛɛti oman rooni arɔɔŋ kaamawin rum unun zinzeetinu, anyek buk nɔɔnɔ rum unun malkinto. ");
INSERT INTO mur_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mã arooŋnyin takirɛnti oman nyayek nɔɔnɔ ijo cigin dɔyiza ŋintimiliny, nyayek nɔɔnɔ ŋinti wun kal. ");
INSERT INTO mur_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mã anyak eet ci alayin gi ci alayin, ma anyei niina gi nico, anyek nɔɔnɔ labak. Buk mã arɔɔŋ ɛɛti gi ci akɔ aliŋliŋi zɛɛ ŋaan abadakin tiŋeere, anyek nɔɔnɔ labak. ");
INSERT INTO mur_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Aziiŋnyu baale gɔɔn azi kɛɛrita ugooc nɛ, Ereezit laŋotugooc doon! Otoborit ɔl o amarninuŋ igeet! ");
INSERT INTO mur_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bar zin inoko naana kanekuŋ nɛ, Ereezit buk ɔl o amarninuŋ igeet. Ijintek buk Jook ɔl o agiduŋ. ");
INSERT INTO mur_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mã agoonu nɔkɔ, izitu koca niiga didi dɔl o baatunooŋ o aavi tammu tadena. Eeci anyek niini ii kuduna, ma ataran ɔl o abon kibeen ɔl o gɛr buk. Ma anyek buk niini tammu taden kitiilak maam ɔl o abon ki ɔl o gɛr dook. ");
INSERT INTO mur_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mã areezu ɔl o areezuŋ igeet doon, alaŋ koca atitinyuŋ Jooi igeet, eeci ɔl o gɛrzɛ agɔɔn gɔɔn buk niigi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mã azaayu laŋotugoocok doon, anyak gi ci utuguzu abon kujuk kaal o agɔɔn ɔl o alaŋ atuwe tɔ? Mayo nuun een ɔl o alaŋ atuwe gɔɔn buk agɔɔn niigi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Abon zin niiga areezu ɔl dook ɔrɔɔt kiyo buk baatunooŋ o aavi tammu tadena o. ");
INSERT INTO mur_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Egenyit! Má aliŋliŋnyu liŋliŋɔn o Joowo ɔl kɔrgɛna ka olla bar kicinit niigi kaal ci agoonu o. Mã agoonu kaal ci ɛɛl nɔkɔ ɔl kɔrgɛna, alaŋ ajowanu vɔyit ŋaati baatunooŋ o aavi tammu tadena been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Zin gɔɔn mã arooŋnyu itiritit eet ci amaat, má abɔraku ɔl dook kiyo gɔɔn agɔɔn ɔl o ayelza eleeti o. Agɔɔn gɔɔn niigi kaal ci abon ceezine o lotento kibeen golowɛ ka katanaazɔ ɔl nɔɔgɔ kaale nicoko. Zin giye nico abon agayu niiga uruktozek nɔɔgɔ vɔyita ugeec dook loota ŋina odota. ");
INSERT INTO mur_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bar zin gɔɔn niiga mã atiritu eet ci amaat, itiritit nɔɔnɔ gole ci laŋotugooc o orkoryu alya alaŋ aga been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Anycek gi nico kizi gi ci agaya niiga doon. Ŋaan aruwekuŋ igeet vɔyit o agoonu nɔkɔ baatunooŋ o acin kaal nicoko roodinta. ");
INSERT INTO mur_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Gɔɔn ma ajinu Jook, má eelnu kiyo ɔl o gɔɔn arɔɔŋ ka keyelizta eleeti ɔla o. Arɛɛz gɔɔn niigi ŋaati ɛɛlni jena ɔl kɔrgɛna ceezine o lotento been golowɛ, ma ajin Jook ka kicinit ɔl nɔɔgɔ. Abon zin agayu niiga uruktozek nɔɔgɔ vɔyita ugeec loota ŋina odota. ");
INSERT INTO mur_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bar zin niiga mã gɔɔn arooŋnyu ijinit Jook, ɔɔtɔ ceezine ugooc eecitɔ, onyoogit karogi. Ijintu ni baatunooŋ o aga kaal dook. Ŋaan anyuŋ niini igeet kaal o arooŋnyu ŋaaten nɔɔnɔ o acin kaal o agoonu niiga roodinta dook. ");
INSERT INTO mur_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Gɔɔn mã ajinu Jook, má aduwanu zoozok ci wuntik akɔm keŋti kiyo ɔl o alaŋ atuwe gɔɔn abaaban niigi anɔ nɛ, Coma azii Jooi ŋaryiin cineeŋ wun o. ");
INSERT INTO mur_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Má zin eelnu kiyo niigi o been nɛɛn. Eeci baatunooŋ aga kaal o arooŋnyu niiga rogete unooŋ laadun iŋaan buk ijinit niiga nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Zin gɔɔn ma aŋaryinu, aŋaruyɔ gole ci atobɔ kibeen co. Baatinaaŋ o aavɛ tamma, anyek ɔl kidiŋdiŋanit zaar ugun. ");
INSERT INTO mur_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anyek baliin unun kiiya. Anyek rooŋinɛt unun kutuguwe loocowɛ kiyo tamma o. ");
INSERT INTO mur_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyet dayiin onaaŋ iiten codoi waanico. ");
INSERT INTO mur_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Toŋ baciinok ogaacak kiyo kuuŋna kaal o abaca ɔl ŋaatinaaŋ o. ");
INSERT INTO mur_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nyet dɔyiz ka calaŋ acinanet kaala o gɛrzɛ. ");
INSERT INTO mur_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mã ooŋneku niiga ɔl oogi kaal o abaca ŋaatunooŋ, ooŋnekuŋ buk baatunooŋ o aavi tammu tadena igeet kaal ugooc abacanu. ");
INSERT INTO mur_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mazi alaŋ ooŋneku niiga ɔl oogi kaal o gɛr agoonekuŋ niigi igeet, alaŋ buk koca baatunooŋ o aavi tammu tadena ooŋnekuŋ igeet kaal o abacanu been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Gɔɔn mã uuŋnu dayiin ka idiŋdiŋanit Jook, má anyoranu ŋumti kiyo ɔl o gɔɔn arɔɔŋ keyelizta eleeti ɔla o. Gɔɔn niigi ma ooŋ dayiin, alɔŋa eleeti, ma azɔp looc, ka kagaac ɔl nɔɔgɔ ooŋ dayiin ka kidiŋdiŋanit Jook. Abon zin agayu niiga uruktozek nɔɔgɔ vɔyita cigeec loota ŋina odota. ");
INSERT INTO mur_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Gɔɔn zin ma ooŋnu niiga dayiin ka idiŋdiŋanit Jook, otoonyit ŋumti, ma avilanu ooti juruŋ, ka calaŋ aga ɔl ogɛn uuŋnu niiga dayiin. Ŋaan agayuŋ igeet baatunooŋ o aga kaal dook. Ŋaan aruwekuŋ niini igeet vɔyit kaale o abon agoonu roodinta dook. ");
INSERT INTO mur_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Má itaŋeku eleeti arɔkzɛt loota ŋina, eeci arɔkzɛt ci loocu adak tɔdɔwa ki zizaac, ma agɔrɔz agoryawa. ");
INSERT INTO mur_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Abon zin iyaŋeku eleeti arɔkzɛt tammu tadena, eeci ŋinaante alaŋ adak zizaaca ki tɔdɔ, ma akɔm agoryak ci ka kogorozit. ");
INSERT INTO mur_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eeci ŋino iyaŋin arɔkzɛt unooŋ, ŋino buk aavtiyɛ zinzeeti ugooc nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ma kɛbɛrɛ tokolec ci alyo gi. Mã abon kɛbɛrɛ cugune o, aavi buk ɛlɛ cune o dook vooritina. ");
INSERT INTO mur_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bar mazi gɛrzɛ kɛbɛrɛ cugune o, aavi buk ɛlɛ cune o dook muura, ma muuri nici gɛrzɛ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Akɔm laadun eet ci aliŋliŋonek alaat ram. Mã agɔɔn niini nɔkɔ, arɛɛz koca codoi ŋaatineeŋ ɔrɔɔt, ma amarnin codoi. Karabɔŋ aŋole codoi, ma apɛz codoi. Zin gole nico alaŋ abon ŋaati kaliŋliŋonɛkɛ Jook, ma bodo kaliŋliŋ guruc. ");
INSERT INTO mur_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Inoko zin kanekuŋ nɛ, Má iinonu maam ki dayiin o arooŋnyu ka orogti, karabɔŋ een rumanɛ ci ka uburucek eleeti. Eeci rogɛti titiny ɔrɔɔt kujuk dayiin, maje ɛlɛ titiny ɔrɔɔt kujuk rumanɛ. ");
INSERT INTO mur_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Icinit di kibaali o too ŋaati akuli tammu kɛŋa labak. Alaŋ niigi aḏowɛ, ma akɔm nɔɔgɔ labi ci ateedek piimanɛ. Zin baatunooŋ o aavi tammu tadena nɛɛn o anyek nɔɔgɔ dayiin. Bar zin niiga adiŋdiŋnyu ɔrɔɔt ujukit nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ŋɛnɛɛn inoko ŋaatunooŋ ci azaac rogɛt cin kizi wun iitene codoi ṯɔr nɔkɔ inoninta? ");
INSERT INTO mur_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Iinonu zin rumanɛ gaga naa? Icinit di! Koroboli aduŋna ku? Alaŋ niigi aliŋliŋ, ma alaŋ alolak eleeti rumanɛ. ");
INSERT INTO mur_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kaduwakuŋ zin igeet kanekuŋ nɛ, Mayo nuun een Solomon baal een aroi ɔrɔɔt e alaŋ anyak rumanɛ ci alina kiyo gɔɔn koroboli o. ");
INSERT INTO mur_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mazi alinatan Jooi koroboli o gɔɔn alina waanico, ma bodo tiŋeere araaba kɔr o, alaŋ agayu Jooi anyuŋ buk igeet rumanɛ? Anyaku didi tɛ niiga tuwɛn ci miliny ɔrɔɔt giye ci iinonu kaal noko. ");
INSERT INTO mur_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Má iinonu zin gi ci aniyu nɛ, Kayo kojokta dayiin ŋaaḏaŋ? Karabɔŋ aniyu nɛ, Kayo kojokta kaal ci kawot ŋaaḏaŋ? Karabɔŋ aniyu nɛ, Kayo kojokta rumanɛ ci kanyak ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Eeci kaal nicoko abaaban gɔɔn ɔl o loocu tup nɔkɔ. Bar zin baatunooŋ o aavi tammu tadena aga nɔkɔ arooŋnyu niiga kaal nicoko dook o. ");
INSERT INTO mur_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bar zin rak ɔɔwa ooritnɔŋ orooŋit baliin o Joowo. Utuguz kaal o abon arooŋekuŋ niini igeet utuguz ŋaan vurta anyuŋ niini igeet kaal nicoko dook. ");
INSERT INTO mur_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Má iinonu kaal ci tiŋeertinu, eeci Jooi ŋaan aga niini niceke. Olla utuguz kaal ci tɛ agoonu waanico o doon. ");
INSERT INTO mur_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Má apayeku ɔl oogi gerzitin ka calaŋ buk apayekuŋ Jooi igeet gerzitin. ");
INSERT INTO mur_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Eeci mã apayeku ɔl oogi gerzitin, apayekuŋ buk Jooi igeet gerzitin nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naa zin rican gi ci abil keberece ci gonon o, ma bar alaŋ abaaban rak gi ci appe abil keberece cuno o? ");
INSERT INTO mur_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ku anei gon oma nɛ, Jai kaarawin gi ci anyei kebereca o, ma gi ci appe abil keberece cun o alaŋ rak aara naa? ");
INSERT INTO mur_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Zin niina ci adiŋdiŋan ɛlɛ vɔlɔŋa o aara rak gi ci appe abil keberece cun o ɔɔwa zɛɛ mazi icinɔ juruŋ, bitɔ zin aara gi ci abil keberece ci gotonon e. ");
INSERT INTO mur_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Má anyeku kaal o abon titiny orze, eeci alaŋ agayu karabɔŋ iiten oma ookconekuŋ igeet ɛlɛ, ma adakuŋ. Má ajukeku ziira ugooc alina kɔcɔcɔbanɛn kɔrgɛn, eeci arocek koca tɔdɔ zɔɔnɛ. ");
INSERT INTO mur_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ijintɔ, ŋaan anyononekuŋ. Ɔrɔɔŋtɔ, ŋaan ajowanu. Ɛtɛrɛnit karogi, ŋaan akolonekuŋ. ");
INSERT INTO mur_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eeci ɛɛti ci ajine, anyononek nɔɔnɔ gi o ajin Joowa. Ɛɛti ci arooŋnyi, ajowa gi o arɔɔŋ Joowa. Maje ɛɛti ci atɛrɛn karogi, akolonek nɔɔnɔ karogi o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Inoko ŋaatunooŋ ŋɛnɛɛn ci gɔɔn mã ajin ŋɛɛrin ḏokoc, anyek bar niini nɔɔnɔ bɛ? ");
INSERT INTO mur_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Karabɔŋ mã ajin niini nɔɔnɔ kulugit, anyek bar kowat? ");
INSERT INTO mur_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mayo nuun eeginu gɛrzɛ noko, agayu kaal ci abon anyeku dɔl ugooc nɔkɔ. Zin bar baatunooŋ o aavi tammu tadena anyek ɔl o ajin nɔɔnɔ kaal ci abon ɔrɔɔt kujukuŋ igeet. ");
INSERT INTO mur_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Utuguzek ɔl oogi buk kaal o arooŋnyu niiga nɔɔgɔ kutuguzeyuŋ igeet. Nici kɛŋ o lotinok o Mosis been zoozok o nyakaŋanetu nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Oneec zin gɔl o lodoci akɔ araane o lodoci. Ma gɔl nici gɔl o akɔ tammu tadena nɛɛn. Ano zin gɔl nico ɔl ci miliny tɛr, eeci adɔi ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Maje gɔl o akɔ gooye o Loryento alɔɔlɔ niini ɔrɔɔt. Ma ano gɔl nico ɔl ci meelik gɛr, eeci aboke ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Egenyit nyakaŋanete o voloŋo. Gɔɔn ma kacin nɔɔgɔ eci bitaalu gononɛ kiyo ɛɛzana ween aza o. Maje bar zinzeeti ugeec eecitɔ ɛɛl kiyo guzule o. ");
INSERT INTO mur_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ŋaan zin agayu nɔɔgɔ kaale o agɔɔn. Kaga zin gɔɔn laadun kɛɛna ceen tirɔ alaŋ abiirna kɛbɛrɛ ci kiŋirowu. Buk larbɔɔ alaŋ abiirna kɛbɛrɛ ci gemenyowu. ");
INSERT INTO mur_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma kɛɛt ci abon abiirna buk kɛbɛrɛ ci abon. Maje kɛɛt ci gɛrzɛ abiirna kɛbɛrɛ ci gɛr amadowez. ");
INSERT INTO mur_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ma kɛɛt ci abon alaŋ abiirna kɛbɛrɛ ci gɛr. Maje buk kɛɛt ci gɛrzɛ alaŋ abiirna kɛbɛrɛ ci abon. ");
INSERT INTO mur_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ma kɛɛn o alaŋ anyak kɛbɛrɛ ci abon keene o gɔɔn aḏok ɔl atɛɛdjak looc, ma ajukonek goo. ");
INSERT INTO mur_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ŋaan zin agayu nyakaŋanɛt o voloŋo kaale ugeec agɔɔn. ");
INSERT INTO mur_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Alaŋ ɔl dook o awuyan aneet azi nɛ, Manyi, Manyi, aridonek katin baliin o Joowo. Avɔ ŋinaante ɔl o gɔɔn agɔɔn kaal o arooŋek baaba o aavi tammu tadena nɔɔgɔ kutuguzɔ doon. ");
INSERT INTO mur_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mazi iitene ci aku katin e ɔl ci meel avu anekan nɛ, Manyi, Manyi, baale gɔɔn kaduwaka ɔl kaviyak o Joowo zaare ugun. Buk baale gɔɔn kaarana miniŋ o Loryento ɔla zaare ugun. Ma kagoona kaal ci meel atɛɛt ɔl biye zaare ugun.” ");
INSERT INTO mur_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kanei zin katin naana nɔɔgɔ nɛ, Alaŋ kagayuŋ igeet been nɛɛn. Ɛnyɛktɛ ŋaatan ŋina lorye ci oŋenu coko. ");
INSERT INTO mur_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ma ɛɛti ci azii zoozok cigan noko, ma azooni zinize onin dook, atobɔ niini kibeen eet ci agɛny ɛɛnyɛt ceez cin kutur ɔɔwa. ");
INSERT INTO mur_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mazi atiil tammu ɔrɔɔt, ma ariya tawani, ma ivaan ŋɔɔti ɔrɔɔt, alaŋ ceez nici aruk looc been nɛɛn, eeci ɛɛnyci kutur ɔɔwa. ");
INSERT INTO mur_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Maje ɛɛti ci azii zoozok cigan noko, ma alaŋ azooni, abil niini kiyo ɛɛti ci tarbal ɛɛnyɛt ceez nyarata o. ");
INSERT INTO mur_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mazi atiil tammu ɔrɔɔt, ma ariya tawani, ma ivaan ŋɔɔti ɔrɔɔt, aruk ceez nici looc kɔɔyɔyɛ lai, eeci ɛɛnyci nyarat kɛŋa.” ");
INSERT INTO mur_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Mazi akɔ adica Yesu demziin nico, ibiirit ɔl dook ooti tɛt gole cin ademzin noko. ");
INSERT INTO mur_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Eeci alaŋ demziin cinɛ o atobɔ ki demziin o alaat ugeec gɔɔn ademzek nɔɔgɔ lotinok, bar adɛmzɛ niini kizi eet o didi anyak alaazɛt. ");
INSERT INTO mur_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Mazi alocai Yesu bɛ tadena, unuya nɔɔnɔ ɔl ci meel gɛr. ");
INSERT INTO mur_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma akunak ɛɛti ci anyak mɔɔriz o gidaŋ nɔɔnɔ, ma aku akani kozoŋti looc nɔɔnɔ ŋuma, ma azi nɛ, “Manyi, mã arooŋ rogozan kizi maya, rogozan.” ");
INSERT INTO mur_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ma anek Yesu nɔɔnɔ nɛ, “Karooŋ kuruguzin.” Ma itoon Yesu aziit, ma uum nɔɔnɔ azi nɛ, “Izi zin maya.” Enico ɛlɛ izi mɔɔrizi oninɛ e ḏim. Orok didi niini kobona kigirgir ɛlɛ kiyo da alaŋ amɔɔr o. ");
INSERT INTO mur_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ma anek Yesu nɔɔnɔ nɛ, “Ziiyan di. Má akɔ aduwai zɔɔz nico eet oma, bar bitɔ yelek ɛlɛ alaan o ceez o Joowo ka kook kicinin niini ineet. Buk bitɔ taap Jook ebaal aduwan lotinowa o Mosis, ka kagayin ɔl dook didi urugu niina mɔɔrize baal amɔɔrni e. ");
INSERT INTO mur_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Mazi akunak Yesu kutur o kazi Kapernam, iiya urumtɔ ki alaan ci takirnya o Rom. Ma ilalek alaani nici Yesu arɔɔŋ tirtɛn. ");
INSERT INTO mur_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Azi nɛ, “Manyi, amɔɔr gabarɛnti cane ɔlɔ ɔrɔɔt ɛlɛ. Ɔɔŋ niini onyite codoi ṯɔr nɔkɔ, ma alaŋ anim kitiŋa jena. Apirnanɛ nɔɔnɔ balcɔnti ci amɔɔrni noko ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Ŋaan kakɔ kanyi nɔɔnɔ kizi maya.” ");
INSERT INTO mur_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma anek alaani nici Yesu nɛ, “Akɔm Manyi. Alaŋ aganɔ ŋaati akunakɛ niina kɔrɔk can o. Kaga nɔkɔ olla mɔlɔyi ci aduwa niina ŋina arogoz tedec gabaren can noko. ");
INSERT INTO mur_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kanyei buk naana alaat oogi ci adikir ŋaatan alaazɛta, ma kazii naana zoozok cigeec. Ma bodo buk naana keen alaan ci adikir takirnyai, ma aziiŋnan niigi aneet. Mã kanei co nɛ, Bitɔ kete, akɔ. Mã kanei ce nɛ, Ija, aku. Buk mã kanei gabara ogan nɛ, Utuguz gi co, agɔɔn.” ");
INSERT INTO mur_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Mazi azii Yesu gi nico, ibiir nɔɔnɔ ɔɔ ɔrɔɔt ɛlɛ, ma anek ɔl ona ano nɔɔnɔ e nɛ, “Didilɛ kaduwakuŋ igeet, ŋaan baal rɛɛn ŋaan kicin ole o Israyil dook eet ci atuyan ɔrɔɔt kiyo ɛɛti nici noko! ");
INSERT INTO mur_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Abon aadanu gi ce. Avu katin ɔl ci meel atuyan aneet libire ci jenu o, ma avu ogɛnɛ libire ci nyagjo o. Ma avu aavtiz niigi dook loota kibeen Ibrayim ki Aizak been Jakob baliinte o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Maje bar ɔl o Israyil ogɛn o waan aganɔ ŋaati avɔyi baliinte o Joowo, ma bar alaŋ arɔɔŋ kutuyan aneet, atoowonek katin niigi muur bitaala rɛɛna many, ma alu niigi ŋinaante zɛɛ ma adak nyigit kirkic kirkic balcɔnta kibeen badi mony.” ");
INSERT INTO mur_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Enek ni Yesu alaan nico nɛ, “Bitɔ ɔlɔ. Ma gi o atu niina ŋaan agoononekin ineet.” Ma ziite ci azɔɔzɔnɛ niigi neke ɛlɛ urugun gabarɛnti o alaano nico. ");
INSERT INTO mur_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Mazi akɔ Yesu ole o Pitɔr, amɔda inyik o Pitɔr amɔɔr. Anyak tadiwɔn ci ɔɔŋɛ onyite codoi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mazi uum Yesu nɔɔnɔ aziit, izi maya enico ɛlɛ, ma iŋaaz, ma akɔ agoonek nɔɔnɔ dayiin. ");
INSERT INTO mur_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma yomana anyaaktak ɔl Yesu ɔl ci meel gɛr ci anyak miniŋ o Loryento eleetinɛ. Mazi aduwa Yesu olla zɔɔz ci aduwa, aduŋna miniŋa ci Loryento noko ŋaatineeŋ ecodoi nɔkɔ. Ma arogoz niini ɔl ci amɔɔr noko dook. ");
INSERT INTO mur_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Zin giye o agɔɔni niini gi nico, ɛlɛɛmɛ zɔɔz baal aduwa nyakaŋani o kazi Izaya zooze o anɛ nɛ, “Nɔɔnɔ nɛɛn o aarawet ageet moorizok ogaac.” ");
INSERT INTO mur_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mazi acin Yesu kɔlɛ ci meel aliya nɔɔnɔ noko, enewun nuyak ogin nɛ, “Kabaayizit liil kɔɔtɔ baagita.” ");
INSERT INTO mur_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ma akunak alaani ci gɔɔn ademzek ɔl lotinok o Juz nɔɔnɔ, ma anek nɛ, “Gayoi, inoko kɔrɔɔŋa naana kunuwin ineet. Olla ŋinti akɔyɛ o kɔrkɔr.” ");
INSERT INTO mur_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Anyak kireerwana looknya, ma anyak kibaali ceezi, maje bar naana Ŋɛɛrti Eeto alaŋ kanyei ŋinti ka kaavɛ loota ka kuyubuzi.” ");
INSERT INTO mur_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bodo azi ɛɛti oman ole o gɔɔn ano nɔɔnɔ nɛ, “Gayoi, karooŋ kunuwin ineet. Nyan zin rak kimiirozek kɔrɔk ka kook kiyaŋ baaba iitene ci adaaŋni.” ");
INSERT INTO mur_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm! Nowawan aneet inoko o. Anyek ɔl o alaŋ atuwi kiyaŋit gɔnɔgi o adaai.” ");
INSERT INTO mur_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma vurta otoodit Yesu ki nuyak ogin kavool o liilu. ");
INSERT INTO mur_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ŋintimiliny nɔkɔ ɔmɔdak nɔɔgɔ ŋɔɔti ci appe ɔrɔɔt liil kɛŋ. Ma ayɛlyɛlanak ŋɔɔti nici maam kavool ɔrɔɔt ɛlɛ. Maje Yesu ɔɔŋ daa. ");
INSERT INTO mur_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ma iiŋka nuyawa oginɛ nɔɔnɔ anek nɛ, “Manyi, Manyi, Tiŋa je! Ɛɛlawet! Kizita toronyɛ ka kadaakta.” ");
INSERT INTO mur_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ma anek Yesu nɔɔgɔ nɛ, “Naa? Abarinu naa? Anyaku dim tuwɛn ci miliny tɛr nɔkɔn?” Itiŋa ni niini jena, ma agernyek ŋɔɔt ki maam kajaŋantɛ. Ma ajaŋani didi tiv enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma abiir nɔɔgɔ dook ooti tɛt, ma anɔ nɛ, “Ma laadun eet ci abil ku nici? Ma nuun een ŋɔɔt kibeen maam azii nɔɔnɔ!” ");
INSERT INTO mur_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Mazi abaawonek Yesu looc o ɔl o kazi Gadariin liil baagita, ɔɔt urumtɔ niini kibeen ɔl ceen ram ci avu bɔɔtwane o gɔɔn iyaŋi ɔl gɔnɔgi o adaai. Ɔl nicigi anyak miniŋ ci gɛr ɔrɔɔt ootinɛ. Aam nɔɔgɔ maŋɔnnya kiziti kɛlɛk o too ɛlɛ, ma akɔm eet ci anim kono gɔl ci aavtiyɛ niigi o. ");
INSERT INTO mur_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ma agɛrɛny niigi enico ɛlɛ azi nɛ, “Ŋɛɛrti Joowo, arooŋ ŋaatinaaŋ naa? Akun ka ija uulalet ageeta iŋaan iiteni o payiinto ɔɔwa?” ");
INSERT INTO mur_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Maje ŋinaante anyak kɔcɔcɔbanɛn ci agɛ vorora liil otoga. ");
INSERT INTO mur_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma ilalek miniŋa ci ɔl nicoko o Yesu anek nɛ, “Inoko zin mã arɔɔŋ aarawet ageeta bitaala, nyet koota kɔcɔcɔbanene niceke.” ");
INSERT INTO mur_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma anek Yesu nɔɔgɔ nɛ, “Udunta zin. Ɔɔtɔ.” Ma aduŋna niigi ole ceen ram noko, ma avɔ kɔcɔcɔbanɛnɛ. Enico ɛlɛ ɔdɔkɔnyca kɔcɔcɔbanɛna vorora, ma iinak liil kutudude niigi dook lai. ");
INSERT INTO mur_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Odokonyit ni ɔl o oowa kɔcɔcɔbanɛn e odokonyit ɔɔtɔ korogjowɛ, ma avɔ aduwak ɔl zoozok nicoko kutur kɛŋa dook. ");
INSERT INTO mur_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma avu ɔl dook kutura ka kivita kicinit Yesu. Mazi avu acin nɔɔnɔ, ilaltek niigi nɔɔnɔ kɔtɔɔ looce cineeŋ o.” ");
INSERT INTO mur_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ma atɔɔt Yesu kavool, ma abaayiz liil amiironek kutur onin kazi Kapernam. ");
INSERT INTO mur_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ma ŋinaante ɔdɔŋtak ɔl ogɛn nɔɔnɔ eet ci rɛbrɛbi ɔɔŋ kuwena nɔkɔ. Mazi acin Yesu tuwɛn cineeŋ o, enek eet ci rɛbrɛbi noko nɛ, “Ŋɛɛran, talɔ! Aaryai baciinowa ugune.” ");
INSERT INTO mur_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Enico abaabanit alaata o ademzek ɔl lotinok zinzeetine ci aborni nɔŋ zɔɔz ci azi nɛ, “Ma dim ɛɛti nici anyek ɛlɛ kizi Jook?” ");
INSERT INTO mur_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Maje Yesu aga kaal ci abaaban niigi o nɔkɔ, ma anek nɔɔgɔ nɛ, “Abaabanu dim kaal ci gɛr zinzeetinɛ naa? ");
INSERT INTO mur_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mayo aboke jaŋ? Kizi nɛ, Aaryai baciinowa ugune, yo da kizi nɛ, Tiŋa jena, tɔ? ");
INSERT INTO mur_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Inoko zin karooŋ keyeleyuŋ igeet naana Ŋɛɛrti Eeto kanyei dɔyiz ci kaaranɛ baciinok ɔla.” Enico enek niini eet ci rɛbrɛbi noko nɛ, “Tiŋa je! Doma kuwen cun o. Tɔ, bitɔ ɔlɔ.” ");
INSERT INTO mur_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ma iŋaaz didi ɛɛti nici, ma awɔ akɔ ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Mazi acin ɔl gi nico, anyayit ŋoliin ɔrɔɔt ɛlɛ, ma anaat Jook giye ci anyekɛ eet ci deer alaazɛt ci abil kiyo ci anyek eet nico noko. ");
INSERT INTO mur_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma vurta otoŋ Yesu ŋinito ɔɔtɔ. Mazi ŋaan awɔ gɔla nɔkɔ, icin Matiyu o gɔɔn alota guruc ole o ataalinɛ kaal mɛlɛgɛnyai aavi loota maktabe onin. Ma anek Yesu nɔɔnɔ nɛ, “Nowawan.” Enico ɛlɛ itiŋa Matiyu, ma ano nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mazi akɔ adake Yesu ole o Matiyu, anyak buk ɔl ci meelik ŋinaante ole o gɔɔn alota guruc kibeen ɔl oogi ole o gɔɔn alaŋ azooni lotinok o Juz. Ma avu azɔlɔ niigi kibeen Yesu ki nuyak ogin ŋaatodoi. ");
INSERT INTO mur_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mazi acin ɔl ogɛn ole o kazi Parici gi nico, enektek nuyak o Yesu nɛ, “Ma dim alaani cunooŋ o azɔlɔ ki ɔl ci gɔɔn alot guruc ki ɔl ci gɛr o naa?” ");
INSERT INTO mur_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Mazi azii Yesu gi nico, ɛbɛdɛkɛ niini nɔɔgɔ enek nɛ, “Gɔɔn ɔl calaŋ amɔɔr alaŋ arɔɔŋ niigi akim. Bar arɔɔŋ akim ɔl ci amɔɔr doon. ");
INSERT INTO mur_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ɔɔtɔ ojokta kɛŋ ci zɔɔz o aduyai waragewe o Joowo azi nɛ, Alaŋ karooŋ kɛlɛk ceen todoyok o doon, bar karooŋ zinzeeti bonat ka kagama todoyok cugoocok o. Mazin naana alaŋ kakun ka kiiya kotowo ɔl o agɔɔn kaal o abon, bar kakun ka kiiya kotowo ɔl o agɔɔn kaal o gɛr.” ");
INSERT INTO mur_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ivitak ni ivitak Yesu nuyawa o Jɔn o oonyi, ma avu ajin niigi nɔɔnɔ anek nɛ, “Gɔɔn naaga kibeen ɔl o Parici kuuŋna dayiin iiten oma ka kidiŋdiŋanta Jook. Ma bar nuyawa cugune o adake niigi iinya dook labak o naa?” ");
INSERT INTO mur_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma ŋaan karomena naana kibeen nuyak cigan o alaŋ rak niigi akat culum. Mazi tiŋeere iiya iiteni o ka kaaryai naana ŋaatineeŋ, ŋaan zin akat niigi culum, ma abor dayiin. ");
INSERT INTO mur_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Akɔm laadun eet ci abutanek rum ci rɛɛn gɔn ci colai, eeci mã agɔɔn nɔkɔ, arɛɛcai koca kujuk we. ");
INSERT INTO mur_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Akɔm buk eet ci arek iira buru ci rɛɛn. Mã agɔɔn niini nɔkɔ, adɛ koca iirana, ma alip buru. Abon zin arek niini iira buru ci colai ka calaŋ alibe. ");
INSERT INTO mur_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mazi ŋaan aduwak Yesu nɔɔgɔ gi nico nɔkɔ, iiyak nɔɔnɔ alaani codoi alaate o ceez o Juz lotento, ma aku akani kozoŋti looc Yesu ŋuma, ma ilalek nɔɔnɔ anek nɛ, “Adaak bɛɛnyan! Bar zin kaga mã akun, ma ataadei nɔɔnɔ aziit, arogi koca.” ");
INSERT INTO mur_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Itiŋgazɔ ni Yesu kibeen nuyak ogin dook oneec eet nico. ");
INSERT INTO mur_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mazi ŋaan awɔ niigi gɔla nɔkɔ, iiya ŋaa ci anyak mɔɔriz ci maam o ŋaanu irkitok amɔtɔ ram calaŋ gɔɔn rak ɛɛl. Ma aku uum niini Yesu rum eci bawuco. ");
INSERT INTO mur_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eeci anek niini ɛlɛ maany nɛ, “Mã olla inoko kuum rum cin malkinto noko karugi koca.” ");
INSERT INTO mur_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Mazi abuudi Yesu, acin ŋaa nico, ma anek nɔɔnɔ nɛ, “Bɛɛnyan, má anyei ŋoliin gaga. Uruguzin ineet tuwɛn unune.” Enico ɛlɛ urugun didi ŋaa nici. ");
INSERT INTO mur_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Idicek ni niigi ɔɔtɔ korge o alaano e, Mazi avɔ arum kɔrɔk, ajowa dole ona amɔɔr e adaawa. Maje ɔl alu ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma anek Yesu nɔɔgɔ nɛ, “Udunit ɔɔtɔ bitaala. Alaŋ dole adaai, olla ɔɔŋ labak.” Mazi azii ɔl gi nico, atararti niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mazi avɔ aduŋna ɔl dook, ook niini ceeza, ma akɔ agam dole aziit, ma iŋaaz dole enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ma adiica awaŋi ci gi ci agɔɔn niini noko looc nice dook. ");
INSERT INTO mur_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Mazi akɔ iŋaaz Yesu ŋinaante, iziiyit ɔl ceen ram ruben Yesu aku adiir ŋintineeŋ o. Mazi aku Yesu, oneec niigi nɔɔnɔ. Ma agɛrɛny azi nɛ, “Ŋɛɛrti Devid, anyek da kuwuceyin rubenzɛt cinaaŋ noko. Kolet da kɛbɛrɛ kicintowa.” ");
INSERT INTO mur_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Mazi akɔ arum Yesu kɔrɔk oma, ivitak ɔl ci ruben noko nɔɔnɔ, ma ajin niini nɔɔgɔ anek nɛ, “Inoko atuyu kizik tedec naana karuguzuŋ igeet didi?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ii, kagaya anyei niina dɔyiz ci aruguzet ageeta.” ");
INSERT INTO mur_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Itiŋa ni Yesu, ma uum nɔɔgɔ kɛbɛrɛ azi nɛ, “Anyek zin kibil eci ona atuyu niiga o.” ");
INSERT INTO mur_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Enico ɛlɛ izi kɛbɛrɛ ugeec wak icintɔ. Ma aricanek Yesu nɔɔgɔ anek nɛ, “Má avɔ aduwaku eet oma gi nico.” ");
INSERT INTO mur_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bar mazi awɔ niigi, ɔɔt uduktak ɔl kutura dook zɔɔz ci ona agɔɔn Yesu o. ");
INSERT INTO mur_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mazi ka kɔtɔɔzɔ Yesu ki nuyak ogin, anyaaktak bodo ɔl nɔɔnɔ eet ci adiiti alemeti, eeci anyak miniŋit. ");
INSERT INTO mur_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mazi aara Yesu miniŋit eete nico, ozoozun niini enico ɛlɛ kibiirit ɔl dook ooti tɛt. Ma anɔ niigi nɛ, “Ŋaan baal rɛɛn laadun ŋaan kicinit Israyila ŋina gi ci abil nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Maje bar ɔl o Parici anɔ nɛ, “Anyek nɔɔnɔ dɔyiz ci aaranɛ miniŋ ɔla noko alaani o miniŋu.” ");
INSERT INTO mur_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma azɔp Yesu kuturyok o looc nice dook adɛmɛz ɔl ceezine o Juz lotento, ma uuwak kaviyak o baliin o Joowo abon. Ma arogoz ɔl moorizok keŋti dook. ");
INSERT INTO mur_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mazi acin niini ɔl ci meel avunak nɔɔnɔ noko, icirit nɔɔnɔ ziniz ɔrɔɔt ɛlɛ. Eeci avir nɔɔgɔ zinzeeti, ma anyak ŋoliin kaale o gɛr avunak nɔɔgɔ kiyo ɛɛzana o akɔm tuwayoi o. ");
INSERT INTO mur_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma anek Yesu nuyak ogin yabziinta nɛ, “Icinit di! Anyak mana labi ci meel gɛr, maje bar naaga ci ka keteedit mana o, keegin kidicɛ tɛr. ");
INSERT INTO mur_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kijinit zin eet o mano ka kitoonayet ɔl oogi bodo kiiya kitirititet ageet teedinta.” ");
INSERT INTO mur_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ma awa Yesu nuyak ogin een amɔtɔ ram dook ŋaatodoi, ma anyek nɔɔgɔ dook dɔyiz ci ka kaartai miniŋ ɔla, ma arogzi ɔl moorizok keŋti dook. ");
INSERT INTO mur_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Zaar zin o nuyak ween amɔtɔ ram nɛɛn ce. Saiman o kazi zaar oogi nɛ Pitɔr, ki gɔtɔni o kazi Andoru, ki Jemis, ki gɔtɔni o kazi Jɔn o eegin lɔgɔz o eet o kazi Zebedi, ");
INSERT INTO mur_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ki Pilip, ki Bartalamu, ki Tomaz, ki Matiyu baal gɔɔn alot guruc o meeryo e, ki Jemis ween ŋɛɛrti Alvayoz, ki Tadeyos, ");
INSERT INTO mur_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ki Saiman baal gɔɔn oorinɛ looc onin Israyil e, been Judaz Iskariyot baal ka kataalɔi Yesu e. ");
INSERT INTO mur_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mazi ka kitoon Yesu nuyak ceen amɔtɔ ram nicoko, itilo nɔɔgɔ rak anek nɛ, “Má avoyu loocowe o ɔl o alaŋ eegin Juz, karabɔŋ een kuturyowe ci ɔl o Samariya been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Bar ɔɔtɔ korogjowe ci ɔl o Israyil atobɔ ki ɛɛza ci akoloni. ");
INSERT INTO mur_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ɔɔtɔ uuwayit iziti nɛ, Izi baliin o Joowo ajɔn. ");
INSERT INTO mur_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Orogozit zin ɔl o amɔɔr, ɔdɔŋta ɔl o adaai daayiza, orogozit ɔl o anyak mɔɔriz o gidaŋ, aarta miniŋ ɔla. Kiyo anyuŋ Jooi igeet dɔyiz nico kɔkɔm gi ci aruweku nɔɔnɔ o, ɔɔtɔ buk niiga utuguz kaal nicoko nɔkɔ kɔkɔm gi ci aruwekuŋ ɔl igeet. ");
INSERT INTO mur_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Má ayiitu guruc been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Má buk ayiitu kaboot ci eeronu. Olla iyiitit rumanɛ ki caava ci anyaku eleetine o doon kibeen kɛɛn ci omtinto. Eeci eet ci aliŋliŋ ŋaan anyononek nɔɔnɔ kaal o arɔɔŋ dook ka kɛɛrɔni. ");
INSERT INTO mur_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mã avoyu kuture ci avoyu, orooŋit eet ci abon atalnanuŋ ka itiktɔi. Aavtiyu ni ole nico zɛɛ ma alam awoyu ŋina. ");
INSERT INTO mur_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mã avoyu ole ci avoyu, enektek rak ɔl ɔɔwa nɛ, Abonanu ɔl ci kɔrɔk nico? Ganɔn ŋaatunooŋ. ");
INSERT INTO mur_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mazi atalnanuŋ ɔl ci kɔrɔk nico igeet, amayuwit nɔɔgɔ. Mã alaŋ atalnanuŋ niigi ageet, abadai mayuwɛnɛt cunooŋ o. ");
INSERT INTO mur_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mã alam kɔrɔk, karabɔŋ een kutur calaŋ atalnanuŋ ɔl, karabɔŋ alaŋ aziiŋnuŋ niigi igeet, otoŋit ŋinito. Utuduŋta zin tɔdɔ zɔɔnɛ ka kizi tɛɛdzooc calaŋ abadaku ŋinite been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Abon aadanu gi ce. Katin iitene ci payiinto e apayek Jooi ɔl ci kutur calaŋ atalnanuŋ neke gerzitin ci appe ɔrɔɔt kujuk ci ɔl baal abaak loocowe o kazi Sodom been ɔl o Gomora e. ");
INSERT INTO mur_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iziiktɔ di! Olla kitoonuŋ naana igeet ɔɔtɔ ɔtɔɔz kiyo aza o gononik awɔ guzule kɔrgɛna o. Abon zin agenyu kiyo kireerwana o, ma abon anyaku ɛɛzɛt kiyo yɛɛla o. ");
INSERT INTO mur_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ebeyit zin eleeti juruŋ! Anyak tiŋeere gɔɔn ɔl ci avɔ agamnyuŋ igeet, ma avoyuŋ rooni, ma avɔ arukuŋ ceezine ugeec lotento. ");
INSERT INTO mur_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Anyaakuŋ gɔɔn tiŋeere niigi igeet rooni, eeci anuyaŋ niiga aneet. Ma ŋinaante ŋaan aduwaku niiga alaat o roonnyo ki ɔl o alaŋ een Juz zoozok ogan. ");
INSERT INTO mur_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mazi anyaanuŋ gɔɔn tiŋeere niigi igeet rooni, má abarinu aniyu nɛ, Kayo kɔɔt kudukta naa?, karabɔŋ bar aniyu nɛ, Kayo kɔɔt kozoozɔ ki nɔɔgɔ ku?, eeci iitene ci avoyuŋ niigi igeet rooni e ŋaan anyononekuŋ igeet zoozowa ci ka udukta. ");
INSERT INTO mur_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma zoozowa ci ka udukta o alaŋ een zoozok cugooc, bar zoozok ci avu Vɔŋize o Jook ween baatunooŋ o azɔɔz ŋaaten igeet. ");
INSERT INTO mur_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Iitene nice akɔyi gɔɔn katin ɛɛti dole o yaatin ɛlɛ daayiza kook kadaak didi. Maje buk baatizɛt ki yaatizɛt avɔyi dɔl ugeec ɛlɛ daayiza nɔkɔ. Dɔlya buk katin ookconek baatigeec ki yaatigeec, ma avɔyi nɔɔgɔ daayiza. ");
INSERT INTO mur_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amarninuŋ katin ɔl dook igeet, eeci anuyaŋ niiga aneet. Zin ɛɛti ci amɛz kaal nicoko dook zɛɛ ma aṯornɛkɛ niigi dook, arogzɛ waanma niini. ");
INSERT INTO mur_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mã agiduŋ ɔl kuture oman, ɔɔtɔ bodo kuture ce. Didilɛ kaduwakuŋ igeet, alaŋ azobju kuturyok ci ɔl ci Israyil noko dook zɛɛ ma adicanu ŋaati uuwayeku nɔɔgɔ zɔɔz o Joowo, maŋaan naana Ŋɛɛrti Eeto kiiya. ");
INSERT INTO mur_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Akɔm eet ci adɛmzɛ ci adiŋdiŋ kujuk eet o adɛmɛz nɔɔnɔ. Ma buk akɔm gabaren ci adiŋdiŋ kujuk manyi onin. ");
INSERT INTO mur_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Abon zin buk ɛɛti ci adɛmzɛ azɔl ki eet o adɛmɛz nɔɔnɔ piryakzɛt. Buk gabarɛnti abon azɔl ki manyi onin piryakzɛt. Gɔɔn mã awo ɔl eet ci korgu zaar ceen mazwa kizi Loryen, bar tiŋeere ɔl ci kɔrɔk cino akanek ɔl nɔɔgɔ mazwa ci gɛr ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Zin má aŋolinu niiga nɔɔgɔ, bar uuwayit moozɛta. Eeci gi ci aroodi inoko tiŋeere ayelzai. Buk kaala o aŋɔmtɛ inoko katin abɔryai. ");
INSERT INTO mur_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma zoozok ci kaduwakuŋ naana igeet ceeza tɔ noko, abon avɔ aduwaku niigi ɔl bitaala vitɛnanɛ dook. Buk zoozok o aziiŋnu niiga aŋɔmɔt ɔl, abon abɔraku ɔl dook kiziiyit. ");
INSERT INTO mur_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Má aŋolinu ɔl o aruk eleeti doon kadaayitɔ, ma bar alaŋ anim kuruyit voŋizok ugooc. Bar zin abon aŋolinu niiga Jook o anim niini kuruk eleeti ki voŋizok buk, ma ajukek nɔɔgɔ dook goo. ");
INSERT INTO mur_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Inoko anim ɛɛti oman ŋaatunooŋ kataala zoot ceen ram giricoca labak, ma bar akɔm zin zoote nicoko ŋaatineeŋ ci adaai calaŋ baatunooŋ tamma aga. ");
INSERT INTO mur_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Má anyak zin ŋoliin gaga, eeci adiŋdiŋnyu niiga Joowa ɔrɔɔt ujukit zoot ci meel gɛr. Agayuŋ Jooi igeet, ma azoonuŋ ɔrɔɔt ɛlɛ, mayo nuun een im cugooc ootinu noko ɛlɛ aga dook lai. ");
INSERT INTO mur_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mã abɔra ɛɛti ɔl dook kebereca gi ci azi nɛ, Katu naana Yesu, kabɔrai buk katin naana tuwɛn onin ŋume o baaba tammu tadena nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mã adaŋnyan ɛɛti aneet ɔl dook kebereca, kadaŋ buk katin naana nɔɔnɔ ŋume o baaba tammu tadena nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Má abaabanu gi ci aniyu nɛ, Kuni cane o anyaak looc ganɔn. Akɔm! Bar tiŋeere anyaa marnɔn. ");
INSERT INTO mur_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kuni cane o anyek tiŋeere lɔgɔz kamartɔi baatigeec. Maje dɔlya o ŋaaye amarnin yaatigeec. Alawanɛta amarnin inyigɔ. ");
INSERT INTO mur_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Maje eet ci atuyan aneet amarnin tiŋeere nɔɔnɔ ɔl o tatok onin ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ma ɛɛti ci arɛɛz baatin ki yaatin ɔrɔɔt kujukan aneet alaŋ aganɔ ŋaati ɛɛnɛ niini nuyai can kodot. Buk ɛɛti ci arɛɛz ŋɛɛrin karabɔŋ een bɛɛnyin ɔrɔɔt kujukan aneet alaŋ aganɔ ŋaati ɛɛnɛ niini nuyai can kodot. ");
INSERT INTO mur_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Maje ɛɛti calaŋ adoma kɛɛt onin een talakec, ma ataadek inyaa, ma anuyan aneet, niini alaŋ een nuyai can. ");
INSERT INTO mur_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma ɛɛti ci arɔɔŋ korogoz ɛlɛ onin, bar akoloz. Maje ɛɛti ci akoloz ɛlɛ onin ŋaaten aneet, bar ajowa niini rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mazin ɛɛti ci atalnanuŋ igeet ole cin, atalnanan bar niini aneet, ma atalna buk niini eet o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ɛɛti ci atalna nyakaŋan ci Joowo giye o ɛɛnɛ niini nyakaŋan ci Joowo, aruwek katin buk Jooi nɔɔnɔ vɔyit kiyo nyakaŋani nici noko. Ma ɛɛti ci atalna eet ci abon atu Jook, eeci een niini eet ci abon Joowo, aruwek katin buk Jooi nɔɔnɔ vɔyit kiyo ɛɛti nici noko. ");
INSERT INTO mur_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Abon zin agayu gi ce. Ma ɛɛti ci olla anyek nuyawe cigan noko codoi ŋaatineeŋ maam ci alal kowot giye o ɛɛnɛ niini nuyai can, didilɛ, aruwek katin buk Jooi nɔɔnɔ vɔyit cigin. ");
INSERT INTO mur_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mazi akɔ odotiz Yesu ŋaati aduwakɛ nuyak ogin een amɔtɔ ram lotinok nicoko, otoŋ niini ŋinite ɔɔtɔ ook ɛdɛmɛz ɔl kuturyowe o ajɔŋzɔ ki ŋinite. ");
INSERT INTO mur_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Maje Jɔn o oonyi waanice acabje. Mazi azii niini sijina ŋinaante kaal o agɔɔn Yesu, itoonek nuyak ogin oogi ka kɔɔt kijinit nɔɔnɔ kenektek nɛ, “Ma dim yo niina een Kiristo baal azi Jɔn nɛ, ka katin kiiya e nɛɛn, yo kereya da eet oma ci ŋaan aku?” ");
INSERT INTO mur_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Imiirte ɔɔtɔ uduktak Jɔn kaal ci acinu kibeen kaal ci aziiŋnu noko. ");
INSERT INTO mur_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Enektek nɔɔnɔ nɛ, Ɔl o ruben icintɔ. Ɔl o ŋɔɔlik ɔtɔɔzɔ tɔp. Ɔl o anyak moorizok o gidaŋ orogoztɛ. Ɔl o adiiti iina iziiktɔ. Ɔl o adaai itiŋgazɔ daayiza korogit bodo. Maje kaviyawa o Joowo abon uuwawonek ɔl o amaat. ");
INSERT INTO mur_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Amayuk zin Jooi eet calaŋ bakbai ziniz ŋaatan.” ");
INSERT INTO mur_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mazi amiiri nuyawa ci Jɔn o, uduwak Yesu ɔl o avu azii nɔɔnɔ e zɔɔz ci akati Jɔn. Anek nɛ, “Baale avoyu ŋaati Jɔn balala e, arooŋnyu da ɔɔt icinit naa? Arooŋnyu ɔɔtɔ icinit artɛ ci amɔɔni ŋɔɔti? ");
INSERT INTO mur_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Yo da arooŋnyu ɔɔtɔ icinit eet ci aborcek rumanɛ ci alina? Bar kanɛ alaŋ een nɛɛn, eeci ɔl ci anyak rumanɛ ci alina abaak gɔɔn niigi ceezine o adikir alaatu. ");
INSERT INTO mur_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yo da arooŋnyu ɔɔtɔ icinit nyakaŋan? Kanekuŋ zin nɛ, Icintu zin da didi niiga eet ci adiŋdiŋ kujuk bar nyakaŋan. ");
INSERT INTO mur_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Eeci Jɔn nica nyakaŋan baal azɔɔz Jooi waragewe onin e nɛɛn, baal azi nɛ, Kitoona katin toonnyai onan karayai ŋaatun, ka kiiya kidimdimaneyin gɔl unun. ");
INSERT INTO mur_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Abon zin agayu gi ce. Ma Jɔn nica adiŋdiŋ niini ɔrɔɔt kujuk ɔl o abaak loota baale e zɛɛ been inoko o buk. Mazin ɛɛti ci cɛlbɛz baliinte o Joowo, mayo nuun cɛlbɛz niini ɔrɔɔt, bar adiŋdiŋ niini kujuk Jɔn. ");
INSERT INTO mur_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ma iiten baal akanan Jɔn uuwayi o kaviyak o Joowo e zɛɛ been waanico o, ɔl ci meel amartɔi baliin o Joowo ɔrɔɔt ɛlɛ, ma arɔɔŋ kɛɛlti ɔl o gɛrzɛ nɔɔnɔ dɔyiza. ");
INSERT INTO mur_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maje nyakaŋanɛta dook kibeen buk Mosis azɔɔz waanice niigi zɔɔz ci akati baliin o Joowo. Mazi aku Jɔn e, iiya buk uduwa zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mã didi utuyu da waanice niiga kaviyak ugeec, agayu koca didi Jɔn nica Ilija baal aduwa nyakaŋanɛta kuni onin e nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mã anyaku iin ci aziiknenu, iziiktɔ juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kayo kotobozek ɔl ci ɔɔ nico alaŋ atuwi noko naa? Atobɔ niigi ki dɔl o gɔɔn amici kɔrɔk bawuca, ma agernyek ogɛnɛ gɔnɔgi anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Karuwekuŋ kidorɛt, bar niiga alaŋ arooŋnyu orogomit. Kabena beniin o daayizo, bar niiga alaŋ arooŋnyu utuluz. ");
INSERT INTO mur_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iziiyit di kɛŋ ci yabziin nico. Baale ma aku Jɔn e, alaŋ adak dayiin ci adak ɔl dook o, ma alaŋ awot nyaan. Ma bar azi ɔl nɛ, Anyak niini miniŋit ɔɔwa. ");
INSERT INTO mur_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mazi kakun Naana Ŋɛɛrti Eeto e, kadake, ma kawodɛ. Ma azi ɔl dook nɛ, Icinit di eet nico. Anyak alɛm, ma abaaki, ma eeginɔ laŋoten ki ɔl o gɔɔn alot guruc ki ɔl o alaŋ azooni lotinok o Juz dook. Zin bonati o gɛnyiz o Joowo ayelzai kɛlɛɛmɛ kaale o abon agooni.” ");
INSERT INTO mur_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Akata ni Yesu ɔzɔɔz zɔɔz ci abornɛki nɔŋ kuturyok baal gɔɔn agɔɔni niini kaal o atɛɛt ɔl biye e, eeci ɔl o kuturyok niceke alaŋ arɔɔŋ kabadit mony baciinowe ugeec. ");
INSERT INTO mur_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ma azi Yesu nɛ, “Izi nɔŋa cugoocok wole ɔl o kutur o kazi Korazin. Izi buk nɔŋa cugoocok wole ɔl o kutur o kazi Bezediya. Mã da kaal baal atɛɛt ɔl biye agooni ŋaatunooŋ e kutuguze kuturyowe o kazi Tayor ki Sidon baal uulali e, abadit waan ɔl ugeec mony baal rɛɛna many iŋaan kuulaltɛ e, ma uburuca waan niigi awac eleetinɛ ugeec, ma aborcek rumanɛ ci zɔrzɔr, ma anyak waan buk niigi ciiroc ka keyeleza gi o abadi niigi mony baciinowe ugeec. ");
INSERT INTO mur_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Abon zin agayu gi ce. Katin iitene ci payiinto e apayekuŋ Jooi igeet gerzitin ɔrɔɔt kujuk ɔl ci kuturyok ci kazi Tayor been Sidon noko. ");
INSERT INTO mur_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Buk niiga ɔl o kutur o kazi Kapernam arooŋnyu odoŋit eleeti? Ajukoneku zin buk katin niiga goo o Loryento ɔɔtɔ many. Eeci kaal baal atɛɛt ɔl biye baal agooni ŋaatunooŋ e waan da kutuguze kuture o kazi Sodom, ŋaan waan Sodom kuulalɛ zɛɛ been inoko. ");
INSERT INTO mur_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Abon zin agayu gi ce. Katin iitene ci payiinto e awucnek Jook ɔl o kutur o kazi Sodom bar kujukuŋ igeet.” ");
INSERT INTO mur_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma anyek Yesu Jook zany anek nɛ, “Baaba, Manyi o tammu tadenu ki tɔdɔ, katalnɛ naana ɔrɔɔt ŋaatun, eeci arɔɔdɛ zɔɔz unun een didi ɔl o gɔɔn abaaban niigi kizik bar agɛny, ma iiya eyeleyu ɔl o cɛlbɛz. ");
INSERT INTO mur_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nɔɔnɔ zin nɛɛn baaba. Agoon gi nico gole o arooŋ niina.” ");
INSERT INTO mur_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mazi aṯornɛkɛ Yesu zooze nico, enek ɔl nɛ, “Anyan baaba onane kaal dook aneet. Akɔm zin eet oma ci agayan aneet ŋɛɛrin, bar agayan aneet baaba doon. Akɔm buk eet oma ci aga baaba, bar kaga nɔɔnɔ naana ŋɛɛrin doon, kibeen ɔl o karooŋ ka keyelizak baaba nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ivitayaŋ zin aneet niiga dook o apirnanu kaale o loocu, ka kiiya kanyuŋ igeet uyubuzit. ");
INSERT INTO mur_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Agamta demziin onan zinzeetine ugooc dook. Ivita ɛdɛmɛztɔ ŋaatan, eeci aneet alalnan ziniz, ma kacɛlbɛzan ɛlɛ. Ka zin ivita ajokta niiga yubzɛn eleetine ugooc kizi zinzeeti tiv. ");
INSERT INTO mur_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Eeci demziin ci ka kanyuŋ naana igeet o alaŋ adɔi.” ");
INSERT INTO mur_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma iinyaye ogɛn iitene o gɔɔn yubzento ɔtɔɔzɔ Yesu ki nuyak ogin, ma avɔ abatak manɛɛn culu labinu. Maje nuyak adak magizeeti, ma acarkiz labi nicoko, ma adak. ");
INSERT INTO mur_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mazi acin ɔl o Parici gi ci agɔɔn nuyawa noko, enektek niigi Yesu nɛ, “Cin di! Apɛz nuyawa cugune noko lotinok ogaac giye ci agɔɔni niigi gi ci waan alaŋ aganɔ ŋaati agɔɔni iitene ci yubzento o.” ");
INSERT INTO mur_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋaan ekeebit gi baal agɔɔn alaani o kazi Devid waan baal adayi magiz nɔɔnɔ kibeen ɔl ogin e? ");
INSERT INTO mur_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Akɔ waanice niini ceeze o Joowo, ma akɔ anyek alaani o ceez nice nɔɔnɔ ki ɔl o ɔrkɔr ḏɔkɛn o gɔɔn ataabi ɔl Jook. Ma avu adak niini ki ɔl cigin noko. Yo nuun abac niigi waanice lotinok baal gɔɔn azi nɛ, Abon adak ḏɔkɛn niceke alaata o ceez o Joowo doon e, adayit waanice niigi labak. ");
INSERT INTO mur_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Buk ŋaan agaac niiga kɛɛranene ugooc zɔɔz o gɔɔn aliŋliŋi ɔl o ataap Jook ceeze o Joowo iitene o yubzento tup nɔkɔ, ma akɔm gi ci gɛr ŋaatineeŋ? ");
INSERT INTO mur_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kanekuŋ zin nɛ, Bar naana kadiŋdiŋ ɔrɔɔt kujuk ceez o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Azi waragɛwi o Joowo nɛ, Alaŋ karooŋ kɛlɛk ceen todoyok o doon, bar karooŋ buk zinzeeti bonat ɔla. Inoko tɛ didi agaac kɛŋ ci zɔɔz nico, alaŋ koca apayeku ɔl ci abon noko gerzitin. ");
INSERT INTO mur_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eeci naana Ŋɛɛrti Eeto keen Manyi o iiten o yubzento nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Enico otoŋ Yesu ŋinito ɔtɔɔ ook ceeze o lotento. ");
INSERT INTO mur_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Maje ŋinaante anyak eet ci dɔkɔm aziiti. Ma anyak buk ŋinaante ɔl ci Parici ci arɔɔŋ kedetit Yesu giye ci gɛr agɔɔn. Ma ajin niigi nɔɔnɔ anek nɛ, “Mayo dim lotinowa ogaac aziiŋnekin ineet rogoz ɔl iitene ci yubzento noko labak?” ");
INSERT INTO mur_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋɛnɛɛn inoko ŋaatunooŋ ci iinak ɛɛz cinɛ look iitene ci yubzento noko ma alaŋ ɛɛla? ");
INSERT INTO mur_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mazin bar ɛɛti ci deer adiŋdiŋ ɔrɔɔt kujuk ɛɛz! Ma aziiŋneket buk lotinowa ogaac kitiritit ɔl iitene ci yubzento o labak.” ");
INSERT INTO mur_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Zin enico ɛlɛ enek Yesu eet ci dɔkɔm aziiti noko nɛ, “Zɔlan aziit cun dɔkɔm noko.” Mazi azɔlan ɛɛti aziit, obona didi kotobtɔ ki gɔn ci ona abon o nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mazi acin ɔl ci Parici o gi nico, otoborit niigi nɔŋ ɔrɔɔt ɛlɛ. Ɔtɔɔzɔ ni ŋina ɔɔt abaabanit gɔl ci ka kurukti Yesu kadaak. ");
INSERT INTO mur_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Maje Yesu aga gi nico nɔkɔ, otoŋ ni niini ŋinite ɔtɔɔ, ma ano ɔl ci meel gɛr nɔɔnɔ. Ma arogoz niini ɔl o amɔɔr dook. ");
INSERT INTO mur_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma aricanek niini ɔl ci ona arogoz mɔɔrizɔi noko calaŋ avɔ aduwak ɔl oogi. ");
INSERT INTO mur_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Zin agooni gi nici o ka keyelizai bonati o Yesu baal aduwa Jooi nyakaŋane o kazi Izaya. ");
INSERT INTO mur_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Azi baale niini nɛ, “Icinit di gabaren onan kaŋɛra naana. Kareez naana nɔɔnɔ ɔrɔɔt ɛlɛ, ma katalnɛ ŋaatin. Karekɛ tiŋeere nɔɔnɔ Vɔŋiz onan, ma aduwak katin niini ɔl dook zɔɔz o payiin onan abil tɔp. ");
INSERT INTO mur_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Alaŋ tiŋeere niini adaŋɔ kibeen ɔl, ma alaŋ agɛrɛny, ma akɔm eet ci azii nɔɔnɔ molok ci abololi gɔla. ");
INSERT INTO mur_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Atirit gɔɔn tiŋeere niini ɔl o apirna, mã niigi arɔɔŋ tirtɛn ŋaatin. Ma iitene ci abadaan niini e, anyaa katin bonat, ma adica kaal ci gɛr ɛɛl loota ŋina noko dook. ");
INSERT INTO mur_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma atu katin modɛna ci loocok noko dook nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Anyaaktak ni ɔl ogɛn Yesu eet ci ruben, ma alaŋ azɔɔz, eeci anyak miniŋit alya. Ma arogoz niini eet nico, kicinɔ ma azɔɔz labak. ");
INSERT INTO mur_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ma abiir ɔl dook ooti giye nico, ma ajinɔ niigi maany anɔ nɛ, “Mayo nici ŋɛɛrti Devid didi?” ");
INSERT INTO mur_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mazi avɔ azii ɔl o Parici zɔɔz nico, izitɔ nɛ, “Aara niini miniŋ ɔla o, eeci anyek nɔɔnɔ dɔyiz Loryenti ween alaan o miniŋu kazi Baalzibol.” ");
INSERT INTO mur_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Maje Yesu aga gi ci abaaban niigi o nɔkɔ, ma anek nɔɔgɔ nɛ, “Gɔɔn mã aŋɛrɔ ɔl ci looc codoi, ma ɔɔrɔ niigi maany, lɔɔci nici uulali, ma alaŋ abil kɔdɔk ŋinti rɛɛn. Buk mã aŋɛrɔ ɔl ci kɔrɔk codoi, ma ayɔwɔ niigi maany, alaŋ kɔrɔgi nici abil kɔdɔwɛ ŋinti rɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Zin buk koca mã aŋɛr Loryenti baliin cin o, ma ɔɔrɔ niigi maany, adicai koca baliin cinɛ o taman. ");
INSERT INTO mur_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aniyu inoko niiga nɛ, Anyan Loryenti aneet dɔyiz ci kaaranɛ miniŋ ɔla. Zin mã abil nɔkɔ, ŋɛnɛɛn koca ci anyek ɔl o anuyuŋ igeet dɔyiz ci aaranɛ miniŋ o? Inoko zin ɔl ugooc anuyu igeet apakteyuŋ vɔlɔŋ. ");
INSERT INTO mur_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bar zin kaara naana miniŋ ɔla Vɔŋize o Jook o ayelzakuŋ gi o iiyakuŋ igeet baliin o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Akɔm laadun eet ci anim kook kɔgɔrɔz kaal ceeze ci eet ci mooti adɔi dooke coma rak acap nɔɔnɔ ɔɔwa, ma adɔɔn zɛɛ ook ni adoma kaal ogin dook ceeza. ");
INSERT INTO mur_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ma ɛɛti calaŋ korkorya been aneet, amarninan niini aneet. Maje ɛɛti calaŋ atiritan kolotak ɔl baliin o Joowo, atooyek niini ɔl tuu ŋaatan. ");
INSERT INTO mur_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Zin giye nico kanekuŋ nɛ, “Aara Jooi ɔl baciinok ugeec gɔɔn agɔɔn, kibeen zoozok ugeec gɛr gɔɔn aduwa dook labak. Maje bar eet ci aduwak zɔɔz ci gɛr Vɔŋiz o Joowo, alaŋ ŋaatin oŋɛci nici aariyai nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma ɛɛti ci aduwakan zɔɔz ci gɛr aneeta Ŋɛɛrti Eeto, aara Jooi nɔɔnɔ oŋec nico labak. Maje eete ci aduwak zɔɔz ci gɛr Vɔŋiz o Joowo alaŋ ŋaatin oŋɛci nici aaryai nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Gɔɔn kɛɛn ci abon abiirna buk kɛbɛrɛ ci abon. Maje kɛɛn ci gɛrzɛ, abiirna buk kɛbɛrɛ ci gɛr. Má anyeku zin kɛɛt o abon kizi gɛrzɛ. ");
INSERT INTO mur_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Igeet dɔl ci kokonyawu coko! Kayo udukta kaal ci abon ku mã gɛrzɛ zinzeeti o? Ma gɔɔn laadun ɔtɔgi aduwa kaal o anyak ziniz eecitɔ. ");
INSERT INTO mur_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma ɛɛti ci abon ziniz aduwa zoozok o abon ɛɛl zinize onin. Maje ɛɛti ci gɛrzɛ ziniz aduwa niini zoozok o gɛr ɛɛl zinize onin. ");
INSERT INTO mur_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Didilɛ kaduwakuŋ igeet, katin iitene ci payiinto e ajin Jooi ɔl dook zoozok ugeec gɛr baal gɔɔn aduwa loota ŋina e dook. ");
INSERT INTO mur_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Apakuŋ katin igeet zoozowa ugoocok maany, karabɔŋ apayekuŋ gerzitin, karabɔŋ een bonat. ");
INSERT INTO mur_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ma vurta ivitak ɔl o Parici ogɛn ki ɔl o gɔɔn ademzek ɔl lotinok o Joowo Yesu, ma avu anek nɛ, “Gayoi, tuguweyet di gi ci ateedek biye.” ");
INSERT INTO mur_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ma azi Yesu nɛ, “Mayo ɔl ci ɔɔ nico noko akɔm tuwɛn, ma gɛrzɛtɛ ɔrɔɔt nɔkɔn? Ajinaŋ niiga aneet kutugu gi ci ateeduŋ biye. Akɔm zin kina! Olla gi o atɛɛt ɔl biye baal agoononek nyakaŋan o kazi Jɔna e doon ci ka buk kutuguwozeyuŋ igeet. ");
INSERT INTO mur_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zin kiyo baale aavɛ niini kulugit kɛŋa waazinok iiyu ki baalinok iiyu e, buk tiŋeere naana Ŋɛɛrti Eeto ŋaan kaavɛ tɔdɔwai eecitɔ waazinok iiyu ki baalinok iiyu. ");
INSERT INTO mur_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Mazin katin iitene ci payiinto e ɔl baal kutur o kazi Ninava e iŋaaz jena, ma abɔrak Jook kaal ugooc gɛr agoonu, eeci baale niigi otoŋit baciinok ugeec iinya baal aziiŋni zɔɔz o Jɔna e. Mazin bar demziin cane o adiŋdiŋ ɔrɔɔt kujuk zɔɔz baal Jɔna e. ");
INSERT INTO mur_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Buk katin iitene ci payiinto e iŋaaz ŋaa ween alaan baal abal looc o kazi Ciba, ma abɔrak Jook kaal ugooc gɛr agoonu, eeci baale ɛɛrɔn niini ook looce o rɛɛn many arɔɔŋ ka kook kiziik demziin ci gɛnyiz baal alaan o kazi Solomon e. Zin bar naana kadiŋdiŋ ɔrɔɔt kujuk Solomon. ");
INSERT INTO mur_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Zin gɔɔn ma aduŋna miniŋit ci Loryento eete oman, awɔ akɔ balala ŋaati adɔyi akɔm maam ka kook kɔrɔɔŋ ŋinti ayubzi ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mazi alaŋ ajowa ŋinti ayubzi ŋinaante, anek ɛlɛ maany nɛ, Nyan kimiire kook eete baal kooŋnei looc e. Mazi abada, aku ajowa eet nico abil kiyo ceez o aviilyai kitiliza, ma akɔm ririny kɛŋa o. ");
INSERT INTO mur_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ma adun bodo niini akɔ bitaala, ma akɔ anyaa miniŋ ci Loryento oogi ceen torgɛrɛm ci gɛr ɔrɔɔt bar kujukit nɔɔnɔ, ma avu abaak eete nico. Ma uulali ɛɛti nici kizi gɛrzɛ ɔrɔɔt kujuk baale. Iinak zin buk katin ɔl ci ɔɔ nico gɛr noko gerzitin nici nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Mazi ŋaan azɔɔzɔ Yesu ki ɔl nicoko nɔkɔ, ivita yaatinɛ ki gɔtɔnɔgi. Ma avu ɛɛl bitaala arɔɔŋ ka kozoozɔ ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma anek ɛɛti oman Yesu nɛ, “Yaatun ki gotonogu nɔɔgɔ ci ɛɛl bitaala neke arooŋnyin niigi ozoozɔ ki ineet.” ");
INSERT INTO mur_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Yaai ŋɛnɛ? Gɔtɔnɔga ɔl jaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ma oov Yesu nuyak ogin, ma anek eet nico nɛ, “Cin di! Nicigi yaai, ma een gɔtɔnɔga. ");
INSERT INTO mur_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ma ɛɛti ci agɔɔn kaal o arooŋek baaba o aavi tammu tadena nɔɔnɔ kutugu, niini gɔtɔna, ma een ŋɔɔna, ma een yaai.” ");
INSERT INTO mur_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ma iitene nice ɛlɛ itiŋa Yesu ɔlɔ ook liil otoga, ma akɔ aavi loota ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma ŋinaante ivitak nɔɔnɔ ɔl ci meel gɛr zɛɛ makacin ook niini kavoola liil kɛŋa. Maje ɔl dook aavtiz liil otoga dɔwɔna. ");
INSERT INTO mur_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ma oobek niini nɔɔgɔ kaal ci meel gɛr yabziinta. Anek niini nɔɔgɔ nɛ, “Anyak baale eet ci akɔ ḏowɛn mana. ");
INSERT INTO mur_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Mazi akɔ aḏowɛ, iitazak ḏowo ogɛn gɔl kɛŋ, ma avu avɛra kibaali, ma adak dook lai. ");
INSERT INTO mur_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Maje ḏowo ogɛn iinak vitɛn ceen biyɛn, ma aduŋna ḏowo nici kataman. ");
INSERT INTO mur_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mazi aranɛ kɔr, araabjai bodo kataman, eeci akɔm tɔdɔ ci abon ka kuruktɛkɛ agɛrɔ looc juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Maje ḏowo ogɛn iinak bila kɔrgɛn, ma aduŋna bila zɛɛ makacin eedit nɔɔgɔ calaŋ abiir. ");
INSERT INTO mur_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bar ḏowo ogɛn iinak tɔdɔ ci abon, ma abiir juruŋ, ma anyaa gɔɔn vokonti codoi kɛbɛrɛ ci miliny. Ma anyaa ogɛn kɛbɛrɛ ci meel kidicilim. Maje ogɛn anyaa kɛbɛrɛ ci meelik ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mazi aṯornɛkɛ Yesu yabziinte nico, enek nɔɔgɔ nɛ, “Mã anyaku iin ci aziiknenu, iziiktɔ juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ivitak ni Yesu nuyawa oginɛ, ma avu anek nɛ, “Ma dim gɔɔn niina aduwai ɔl kaal yabziinta o naa?” ");
INSERT INTO mur_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Inoko anyozozeyuŋ igeet gɛnyizi ci ka agayi zoozok o baliin o Joowo aroodi. Maje nɔɔgɔ ŋaan kanyozozek gɛnyizi nici. ");
INSERT INTO mur_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma ɛɛti ci agɛny laadun azaaconek bodo nɔɔnɔ bar kɛgɛny ɔrɔɔt. Maje bar ɛɛti ci akɔm nɔɔnɔ gɛnyiz laadun, mayo nuun anyak da niini ci miliny tɛr, aamnyai bar ŋaatin nici kaavu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Zin kaduwai nɔɔgɔ zoozok yabziinta o, eeci niigi mã agɛlɛm kaal, alaŋ acin juruŋ. Mã azii, alaŋ aga keŋti cigeec juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɛlɛɛmnyai zin zɔɔz baal aduwa nyakaŋani o kazi Izaya. Azi baale niini nɛ, “Aziizar gɔɔn niigi kaal been tɛr, bar alaŋ aga keŋti cigeec. Agɛlɛm gɔɔn niigi kaal been tɛr, bar alaŋ acin juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Eeci ɔl ci ɔɔ nico noko akɔm nɔɔgɔ baabani. Ma adiit iin ugeec, eeci alaŋ arɔɔŋ kiziiktɔ, ma amot kɛbɛrɛ, eeci alaŋ arɔɔŋ kicintɔ. Matɛ calaŋ agɔɔn niigi nɔkɔ, acinɛ waan kɛbɛrɛn labak, ma aziiknɛ iini ugeec. Matɛ waan buk kabadayan niigi aneet, akoli koca nɔɔgɔ ooti kagaac kaal juruŋ, ma waan kuruguz naana nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bar zin niiga amayuwenu ɔrɔɔt, eeci kɛbɛrɛ cugooc o acinɛ juruŋ, ma buk iina cugooc o aziiŋnɛ. ");
INSERT INTO mur_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Didilɛ kaduwakuŋ igeet, baale nyakaŋanɛta ci meel kibeen ɔl ci meel ole o Joowo arɔɔŋ kicinit kaal ci acinu niiga noko ɔrɔɔt ɛlɛ, ma bar ŋaan niigi kicinit nɔkɔ been nɛɛn. Ma buk arɔɔŋ niigi kiziiyit kaal ci aziiŋnu niiga noko, bar ŋaan kiziiyit. ");
INSERT INTO mur_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Iziirartɔ zin juruŋ ka agaac kɛŋ ci yabziin ci eet ci aḏowɛ o. ");
INSERT INTO mur_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ma ɔl o azii kaviyak o akati baliin o Joowo, ma bar alaŋ aga kɛŋ cin, atobɔ niigi ki gɔl kɛŋ o iinak ḏowo. Ma aku Loryen, ma avɛra zɔɔz o aḏowɛ zinzeetine ugeec. ");
INSERT INTO mur_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma vitɛna ceen biyɛn iinak ḏowo o atobɔ niigi ki ɔl o gɔɔn olla azii zɔɔz o Joowo talniinta, ma agama kataman talniinta. ");
INSERT INTO mur_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bar alaŋ akɔ zɔɔz nici zinzeetinɛ juruŋ, ma atuwe ŋintimiliny tɛr, mazi akunak nɔɔgɔ piryakzɛt giye o tuwɛn uneeŋ, amiiri bodo niigi ki vurut. ");
INSERT INTO mur_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma tɔdɔwa ci ɛɛl bila kɔrgɛna, ma iinak ḏowo o, atobɔ niigi ki ɔl o gɔɔn azii zɔɔz o Joowo, maje bar baabani ci kaal o loocu ki baabani ci arokzetu ɛɛt zɔɔz o Joowo kamaduk ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mazin tɔdɔwa ci abon, ma iinak ḏowo o, atobɔ niigi ki ɔl o gɔɔn azii zɔɔz o Joowo juruŋ, ma azooni zinzeetine ugeec didi. Ma amɛna niigi gole o Joowo juruŋ, ma atobɔ niigi baayize uneeŋ ki labi ci abiirna kɛbɛrɛ ci miliny, maje ogɛn abiirna kɛbɛrɛ ci meel kidicilim, maje ogɛn abiirna kɛbɛrɛ ci meelik ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ma bodo aduwak Yesu ɔl yabziin oma anek nɛ, “Ma baliin o Joowo atobɔ ki mana ci aḏok ɛɛti. ");
INSERT INTO mur_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma iitene oman baalin kɛŋa ŋaati ataŋguzi ɔl dook iiya ɛɛti ceen miroi, ma aku aḏok imac kacantɔ ki labi mana eecitɔ zɛɛ ɔɔtɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mazi akɔ arɛc labina, eyeliztai imac nicigi buk. ");
INSERT INTO mur_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ma avu gabara ci eet o mana nico, ma anek nɔɔnɔ nɛ, “Manyi, iiten baale kizik aḏui ḏowo ci abon ɔrɔɔt. Mazin yo imac nici avu ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Anyak miroi ci iiya oḏok nɔɔgɔ.” Ma ajin niigi nɔɔnɔ anek nɛ, “Mayo zin inoko arooŋnyet ageeta koota keteedawa imac nicoko?” ");
INSERT INTO mur_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Akɔm! Alaŋ karooŋ, eeci kabaaban karabɔŋ koca ateedanu labi buk. ");
INSERT INTO mur_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Anycek rak labi kibeen imac buk kɔɔt niigi dook zɛɛ ma iitene ci teedinto e, ŋaan kaduwai ɔl o teedinto ka kɔɔt keteeda rak imac ɔɔwa, ma acap zɛɛ ka kujuktek goo. Maje labi ka keteeda zɛɛ ka karyekan piim onan.” ");
INSERT INTO mur_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ma bodo aduwak Yesu nɔɔgɔ yabziin oma anek nɛ, “Ma baliin o Joowo atobɔ ki keberec o motoŋtoco aduŋna mana o. ");
INSERT INTO mur_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Bar mazi akɔ aduŋna, iroktai zɛɛ makacin izi kɛɛt ci adikir ɔrɔɔt. Ma ɛɛnyɛt kibaali ceezi kɛɛt nico otonɛ.” ");
INSERT INTO mur_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ma bodo aduwak Yesu nɔɔgɔ yabziin oma anek nɛ, “Ma baliin o Joowo atobɔ ki nyigit o telawu gɔɔn adɔŋca ŋaa jayitota, ma arurek tela zɛɛ makacin ɛtɛdɛwi tela we dook komokcar o.” ");
INSERT INTO mur_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Aduwak Yesu ɔl kaal dook yabziinta zɛɛ ma akɔm gi codoi ṯɔr nɔkɔ calaŋ aduwak niini nɔɔgɔ yabziinta. ");
INSERT INTO mur_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Agooni kaala nici o ka kɛlɛɛmɛ zɔɔz baal aduwa nyakaŋani. Baale azi niini nɛ, “Katin gɔɔn mã kazoozona kibeen nɔɔgɔ, kaduwai zoozok yabziinta. Kaduwai katin nɔɔgɔ kaal ci baale kinatamma laadun e ŋaan kagaac.” ");
INSERT INTO mur_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Otoŋek ni Yesu kɔlɛ looc ɔɔtɔ ook ceeza. Ma avunak nuyawa oginɛ nɔɔnɔ, ma avu anek nɛ, “Duwayet di kɛŋ ci yabziin ci labinu kibeen imac o.” ");
INSERT INTO mur_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Ma ɛɛti ci aḏok ḏowo ci abon o aneeta Ŋɛɛrti Eeto nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Maje mana looc nɛɛn. Ma labina ci abon o ɔl o avunak baliin o Joowo nɛɛn. Maje imac ɔl o avɔ niigi ki Loryen. ");
INSERT INTO mur_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma miroiti ci aku aḏok imac o Loryen nɛɛn. Ma ɔl ci aliŋliŋ atɛɛt labi o toonnyak o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Zin kiyo buk alotai imac, ma ajukonek goo o, abil buk tiŋeere iitene ci aṯornɛkɛ lɔɔci e nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Waanci kagamɛ baliin onan loota ŋina kitoon tiŋeere naana Ŋɛɛrti Eeto toonnyak ogan kɔɔt kuluta ɔl dook o gɔɔn ademzek gɔnɔgi oogi gɔl ci ka kabacai baciinok, kibeen ɔl o gɔɔn agɔɔn kaal o gɛr dook. ");
INSERT INTO mur_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma avu ajukek nɔɔgɔ goo, ma alu niigi ŋinaante zɛɛ ma adak nyigit. ");
INSERT INTO mur_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Maje dɔlya o Joowo anyak katin niigi vooritin ci vɔɔr pɛr kataraanet kiyo ii o baliinte o baatineeŋ tammu tadena. Zin mã anyaku iin, iziiktɔ juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ma baliin o Joowo abil kiyo warkina o arɔɔt da ɛɛti oman mana kɛŋa o. Mazi awɔ aku ɛɛti oman bodo mana nico, ma ajowa warki nicoko, ma alaŋ arɔɔŋ rak kadawa. Bar atalnɛ ɔrɔɔt, ma abuŋ, ma akɔ ataalinɛ kaal ogin anyak dook zɛɛ iiya ni ataala mana nico ɛlɛ dook kizi cin. ");
INSERT INTO mur_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Buk baliin o Joowo abil kiyo ɛɛti ween tajɛr arɔɔŋ kataala kalbɛ ceen ziira o. ");
INSERT INTO mur_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mazi akɔ ajowa niini codoi ŋaatineeŋ ci adoŋnyi ɔrɔɔt ɛlɛ, amiironek kɔrɔk, ma akɔ ataalinɛ kaal ogin anyak dook zɛɛ iiya ni ataala ziira nicoko. ");
INSERT INTO mur_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Bodo buk baliin o Joowo abil kiyo cabai o ajukonek liil, ma agama kuluk kɛbɛrɛ dook o. ");
INSERT INTO mur_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mazi akɔ abiz cabai nici, agurak ɔl dɔwɔn, ma aku aavtiz loota, ma atakal kuluk. Adoma kuluk ci abon adikir o arek tori, maje ci miliny gɛr o ajukek tuu. ");
INSERT INTO mur_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mazin buk katin iitene ci adican lɔɔci e abil nɔkɔ. Avɔ katin toonnyawa o Joowo, ma avɔ alota ɔl o gɛr dook, ma aŋɛra nɔɔgɔ doon ole o abon dook lai. ");
INSERT INTO mur_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma avu ajukek nɔɔgɔ goo o Loryento. Ma alu niigi ŋinaante zɛɛ ma adak nyigit kirkic kirkic.” ");
INSERT INTO mur_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ma ajin Yesu nɔɔgɔ anek nɛ, “Inoko kaal ci kaduwakuŋ noko dook aziiŋnu juruŋ?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ii, kaziiŋna.” ");
INSERT INTO mur_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma anek Yesu nɔɔgɔ nɛ, “Ma ɔl o aga waragɛ o Joowo rɛɛn, ma ademzek gɔnɔgi oogi, ma inoko ivita iziti nuyak cigan, atobɔ niigi kibeen eet ci korgu anyak ceeze cin kaal o abon rɛɛn been buk o colai o.” ");
INSERT INTO mur_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Mazi adica Yesu yabziinok nicoko, ɔtɔɔ ŋinaante imiirozek kutur onin. ");
INSERT INTO mur_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma akɔ adɛmɛz ɔl ceeze o lotento. Ma abiir ɔl o azii nɔɔnɔ ŋinaante ooti tɛt, ma anɔ niigi nɛ, “Ma dim logoti nici ajowa gɛnyiz kibeen dɔyiz ci agɔɔni kaal ci atɛɛt ɔl biye noko ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mayo niini alaŋ een ŋɛɛrti eet o gɔɔn abaac kɛɛn ŋina o nɛɛn? Alaŋ een yaatin nɛɛn Meri? Alaŋ een gɔtɔnɔgi nɛɛn awoyi Jemis ki Josev ki Saiman been Judaz? ");
INSERT INTO mur_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Alaŋ een ŋɔɔnɔgi dook nɛɛn o abaak ŋina o? Ajowa zin niini kaal nicoko dook ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Zin enico otoborit niigi nɔɔnɔ. Ma anek Yesu nɔɔgɔ nɛ, “Gɔɔn laadun nyakaŋan atitiny nɔɔnɔ ɔl ci kuturyok oogi, maje bar ɔl o kutur onin kibeen ɔl o tatok onin ɛlɛ alaŋ atitiny nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma akɔm waanice Yesu kaal ci meelik atɛɛt ɔl biye agɔɔn ŋinaante, eeci alaŋ anyak niigi tuwɛn. ");
INSERT INTO mur_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma iinyaye niceke iziik alaani o kazi Erod baal abal looc o kazi Galili e kaal ci agɔɔn Yesu o. ");
INSERT INTO mur_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ma anek niini alaat o miliny aliŋliŋ ki nɔɔnɔ nɛ, “Inoko nicini Jɔn o oony ɔl nɛɛn abada bodo daayiza. Gi zin inoko ci agɔɔni niini kaal ci atɛɛt ɔl biye noko nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Azi Erod nɔkɔ o, eeci baale agam niini Jɔn, ma acap sijina giye ci akati Erodiyas ween ŋaa o gɔtɔni o kazi Pilip. ");
INSERT INTO mur_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eeci baale anek Jɔn Erod nɛ, “Alaŋ abon ŋaati bodo ariyɛ ŋaa ci gotonon o niina maany.” ");
INSERT INTO mur_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Waanice arɔɔŋ Erod kuruk Jɔn kadaak, bar olla waanice aŋole niini ɔl o Juz, eeci waanice Jɔn ŋaatineeŋ abil kiyo nyakaŋani o. ");
INSERT INTO mur_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mazi akɔ aada Erod iiten onin baal aritan e, otowa ɔl ci meelik ka kivita kimicit ole cin o. Orogom ni tinati Erodiyas ɔl ŋuma zɛɛ makacin ɛtɛɛdɛ Erod ziniz ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma aterkedek dole gi ci anek nɛ, “Mã anyak gi ci olla arooŋ, duwayan ka kanyin.” ");
INSERT INTO mur_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Imiire ni dole ook ijin yaatin gi ci abon ka kanyek Erod nɔɔnɔ. Mazi abada, iiya enek Erod nɛ, “Karooŋ ɔɔ o Jɔn. Nyaayan kodooca inoko ɛlɛ ŋina.” ");
INSERT INTO mur_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma awuci Erod ziniz ɔrɔɔt ɛlɛ zooze nico. Bar giye o ɛtɛrkɛdi niini dole zɔɔz ɔl dook ŋuma, ɔkɔma bodo gɔl ci ka kabadai zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma aduwak ɔl kɔɔt keteeda Jɔn ɔɔ sijina. ");
INSERT INTO mur_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma anyaak ɔl dole ɔɔ kodooca, ma akɔ anyek niini yaatin. ");
INSERT INTO mur_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mazi azii nuyawa o Jɔn daayiz onin, ivita adomta nɔɔnɔ, ma avɔ ada zɛɛ iiya ni ɔɔt uduktak Yesu daayiz. ");
INSERT INTO mur_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mazi azii Yesu zɔɔz nico, ɔtɔɔzɔ niini ki nuyak ogin ŋinaante oneec liil kavoola ɔɔtɔ ŋaatineeŋ doon tuuwa. Mazi avɔ aziiknek ɔl Yesu ŋinite, ɔɔtɔ buk niigi odotek korogjok looc oneec Yesu zɔɔnɛ liil otoga. ");
INSERT INTO mur_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ŋinaante mazi atɔɔdak Yesu dɔwɔn, icinun ɔl ci meelik anowa nɔɔnɔ noko. Ma uwucnek nɔɔnɔ kɔlɛ nici, ma arogoz o amɔɔr ŋaatineeŋ dook moorizowɛ. ");
INSERT INTO mur_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma iitene nice ɛlɛ yoman, ivitak Yesu nuyawa oginɛ, ma avu anek nɛ, “Izi lɔɔci yoman, ma buk een ŋina lɔɔci balal. Anyek ɔl kɔɔtɔ kuturyowe ci miliny neke ka kɔɔt kataalta kaal ci adak.” ");
INSERT INTO mur_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ aganɔ ŋaati awɔyi. Ŋaan anyeku nɔɔgɔ kaal ci adak niiga alya.” ");
INSERT INTO mur_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma abɛdɛkɛ nuyawa nɔɔnɔ anek nɛ, “Akɔm dayiin ci kanyaka meel kina. Kanyaka ŋina ḏɔkɛn tur ki kuluk ram nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Enek ni Yesu nɔɔgɔ nɛ, “Anyaaktayaŋ di kaal nicoko ŋaato.” ");
INSERT INTO mur_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma aduwak ɔl kaavtiyɔ loota artɛnɛ. Ma adoma ḏɔkɛn ceen tur noko ki kuluk ceen ram noko, ma agɛlɛm tammu taden, ma anyek Jook zany. Ɛtɛɛt ni ḏɔkɛn, ma anyek ḏɔkɛn nicoko kibeen kuluk nuyak ogin ka keŋeryek ɔl. ");
INSERT INTO mur_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ma adake ɔl dook zɛɛ makacin ipiiyantɛ. Ma alota nuyawa dayiin ci anyigjai o zɛɛ ma abitiz gilanya amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma ɔl ci baal adake neke een maczɛt doon lak tur lak eet ram kamɔtɔ (5000) calaŋ akɛɛp ɔl ŋaai ki dɔl. ");
INSERT INTO mur_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mazi avɔ adotiz ɔl dayiinta, anyek Yesu nuyak ogin kɔtɔɔzɔ enico ɛlɛ kabaaktɛ kavoola karaktɛ kɔɔt liil baagita. Maje niini aavi rak ka kazaan ɔl kɔɔt korogjowɛ. ");
INSERT INTO mur_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mazi avɔ azaani ɔl, ɔtɔɔ niini doon ook ɔtɔɔt bɛ taden ka kook kijin Jook. Ma akɔ aavi ŋinaante niini doon zɛɛ ma yoman. ");
INSERT INTO mur_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Maje kavooli o avɔyi nuyawa e ŋaan awɔ liil kɛŋa nɔkɔ, eeci atirginyɔ ki ŋɔɔt ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mazi akɔ amaman tammu, iiyak Yesu nuyak ŋaati awoyanɛ maam tadena. ");
INSERT INTO mur_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mazi acin nuyawa nɔɔnɔ awɔ maam tadena nɔkɔ, otoŋole looc ɔrɔɔt ɛlɛ. Abaaban bar azi nɛ, Coma een miniŋit. Makacin egerenyit niigi ŋoliinta. ");
INSERT INTO mur_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma azoozek Yesu nɔɔgɔ anek nɛ, “Aneeta gi! Má aŋolinu looc gaga. Anycek zinzeeti kodoyit. ");
INSERT INTO mur_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma abɛdɛkɛ Pitɔr Yesu anek nɛ, “Manyi, mã een didi nicini ineet nɛɛn, nyan buk aneet kɔtɔɔ maam tadena kook ŋaatun.” ");
INSERT INTO mur_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ma anek Yesu nɔɔnɔ nɛ, “Ija.” Ma aduŋna Pitɔr kavoola, ma awɔ maam tadena akɔ ŋaati Yesu. ");
INSERT INTO mur_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bar bodo mazi acin ŋɔɔt ivaan ɔrɔɔt nɔkɔ, anyawun ŋoliin, ma arɔɔŋ akɔ maami tɔ ka waan kotododɛ. Makacin ɛgɛrɛny izi nɛ, “Manyi, Manyi, ɛɛlawan.” ");
INSERT INTO mur_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma itoonek Yesu nɔɔnɔ aziit, ma ɛɛla nɔɔnɔ enico ɛlɛ. Ma anek Yesu nɔɔnɔ nɛ, “Anyei niina tuwɛn ci miliny tɛr. Bodo anyi ziniz kizi ḏakḏak naa?” ");
INSERT INTO mur_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma avɔ niigi dook kavoola, ma azi ŋɔɔti tiv. ");
INSERT INTO mur_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ma adiŋdiŋan nuyawa dook Yesu azi nɛ, “Een didi tɛ niina Ŋɛɛrti Joowo.” ");
INSERT INTO mur_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Abaayizit ni niigi liil, ma avunak looc o kazi Genezaret. ");
INSERT INTO mur_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mazi avɔ acin ɔl Yesu ŋinaante, iiyezit niigi nɔɔnɔ, ma itoonek niigi utugeti ɔl dook kutura ka kulutak ɔl Yesu ɔl o amɔɔr. ");
INSERT INTO mur_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma ilalek niigi nɔɔnɔ ka kanyek ɔl ci amɔɔr noko olla nuun kuumit rum cin o. Mazi olla uum ɔl o amɔɔr rum cin o, orogit didi niigi moorizowe ugeec. ");
INSERT INTO mur_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ivitak ni Yesu ɔl o Parici ki ɔl oogi ole o gɔɔn ademzek ɔl lotinok Jerusalɛma, ma avu anek nɔɔnɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ma dim nuyawa cugune o alaŋ azooni lotinok o jijitigaac rɛɛn o naa? Alaŋ rak gɔɔn niigi oony azɛɛn juruŋ iŋaan kadaktɔ eo aduwan kɛɛranɛ ogaac naa?” ");
INSERT INTO mur_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma niiga buk alaŋ azoonu lotinok o Joowo, ma bar anuyu demziinok cugooc doon o naa? ");
INSERT INTO mur_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Azi gɔɔn Jooi nɛ, Tɔŋɔlɛ baatun ki yaatun. Mã alam eet ci aduwak yaatin ki baatin gi ci gɛr, abon aruwe niini kadaak. ");
INSERT INTO mur_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Maje bar niiga ademzonu anonu nɛ, Mã anyewun ɛɛti kaal ogin anyak dook Jook, alaŋ bodo niini aganɔ ŋaati atiriti baatin karabɔŋ een yaatin. ");
INSERT INTO mur_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Gole nico ɛɛti nici alaŋ aŋole baatin ki yaatin. Buk gole nico epeztu niiga zɔɔz o Joowo, ma bar unuyu zoozok cugooc doon. ");
INSERT INTO mur_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Igeet ɔl ci abuuku eleeti o! Alɛɛma didi Jooi zɔɔz o akanuŋ igeet baal aduwa nyakaŋane o kazi Izaya anɛ nɛ, ");
INSERT INTO mur_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Gɔɔn ɔl nicigi adiŋdiŋanan aneet utugetinɛ doon, maje bar zinzeeti cigeec o adɛyai ŋaatan many. ");
INSERT INTO mur_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Alaŋ zin niigi aganɔ ŋaati adiŋdiŋanan aneet, eeci arican niigi demziin ci kɛɛranɛ ugeecik ɔrɔɔt kujuk demziin ci zɔɔz onan.” ");
INSERT INTO mur_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Otowa ni Yesu kɔlɛ dook, ma aku anek nɛ, “Iziiktɔ di! Aryek kɛŋ ci zɔɔz co zinzeeti juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Akɔm gi ci adak ɛɛti otoga ci anyek eet kizi ririny ŋume o Joowo, bar zin kaal o gɔɔn aduwa ɛɛti otoge onin nɛɛn o anyek nɔɔnɔ kizi ririny.” ");
INSERT INTO mur_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ma vurta ivitak Yesu nuyawa oginɛ, ma avu anek nɛ, “Zoozok ona aduwa e anyigit ɔl o Parici ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Mã anyak gi ci ŋaan laadun baaba tammu tadena koḏok, ma bar aduŋna niini doon, adaacak koca bitaalin. ");
INSERT INTO mur_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Má areku zin niiga nɔɔgɔ zinzeeti gaga. Niigi olla alaat ci ruben. Gɔɔn laadun mã ayit ɛɛti ci ruben gɔn ci buk ruben, iinak koca niigi dook look.” ");
INSERT INTO mur_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma ajin Pitɔr Yesu anek nɛ, “Duwayet di kɛŋ ci yabziin nico.” ");
INSERT INTO mur_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ma anek Yesu nɔɔgɔ nɛ, “Ma een buk igeet nuyak ogan ɛlɛ, ŋaan aleekuŋ kɛŋ ci zɔɔz nico nɔkɔ? ");
INSERT INTO mur_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Alaŋ agayu dayiin ci adak ɛɛti ci deer otoga avɔ kɛŋa, ma bodo avɔ aduŋna o? ");
INSERT INTO mur_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bar zin kaal o anyek eet ci deer kizi ririny ŋume o Joowo nɛɛn o aduŋna zinize onin. ");
INSERT INTO mur_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Eeci ziniz anyaa baabaninok ci meel gɛr kiyo monyɛnɛt ci kamonyi ɔl ci deer, ki zoocmazit, ki rɛɛcanzɛt, ki gorziin, ki vɔlɔŋ, been ŋomtiin. ");
INSERT INTO mur_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Avu kaal nicigi dook eet ziniza, ma anyek nɔɔnɔ kizi ririny ŋume o Joowo. Maje bar gi ci kadayin iŋaan kotoonyit azɛɛn o alaŋ anyek eet kizi ririny ŋume o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɔtɔɔ ni Yesu looce ci kazi Genezaret noko ook looce ci ajɔŋzɔ ki looc o kazi Tayor been Sidon. ");
INSERT INTO mur_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Maje ŋinaante anyak ŋaa ceen borit ci ɔl o kazi Kanan abaak ŋinaante, ma akunak niini Yesu, ma agɛrɛny ŋaati aluwi ɔrɔɔt ɛlɛ, ma ilalek nɔɔnɔ anek nɛ, “Manyi ween ŋɛɛrti Devid, ɛɛlawan da! Tiritan! Kanyei bɛɛnyan ɔlɔ ci anyak miniŋit ci Loryento alya, ma apirnanɛ nɔɔnɔ ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Maje Yesu ajaki niini labak. Akɔm gi ci aduwak nɔɔnɔ kina. Ivitak ni Yesu nuyawa oginɛ, ma avu anek nɔɔnɔ nɛ, “Anyek ŋaa nico kɔtɔɔ, eeci anuyet, ma awudeket luwanta.” ");
INSERT INTO mur_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ma abɛdɛkɛ Yesu, azi nɛ, “Kitoonnyai laadun o ka kiiya kɛɛla ɔl o Juz doon, eeci niigi atobɔ ki ɛɛza ci akoloni.” ");
INSERT INTO mur_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mazi azii ŋaa nici zɔɔz nico, iiya, ma aku akani kozoŋti looc Yesu ŋuma, ma alu azi nɛ, “Manyi, tiritan!” ");
INSERT INTO mur_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Alaŋ abon ŋaati kaamanɛ dɔl dayiin, ma kanyek orze.” ");
INSERT INTO mur_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ma ilalek niini Yesu anek nɛ, “Manyi, alɛɛma didi zɔɔz nico. Zin mayo nuun een orze o ɛlɛ avɛr zurzuryak o gɔɔn iinanɛ ɔl dayiinta o labak.” ");
INSERT INTO mur_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ɛbɛdɛkɛ ni Yesu nɔɔnɔ enek nɛ, “Een ŋaa ci anyei tuwɛn ci appe ɔrɔɔt. Ŋaan zin agoononekin ineet gi ci ona arooŋ o.” Enico ɛlɛ orok didi dole oninɛ. ");
INSERT INTO mur_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɔtɔɔ ni Yesu ŋinaante, ma akɔ ano liil o kazi Galili otok. Ma bodo ooŋ liil otok, ma atɔɔt akɔ taden, ma akɔ aavi loota biyɛnɛ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma avunak ɔl ci meel gɛr nɔɔnɔ ŋinaante. Anyaak niigi nɔɔnɔ ɔl ci ŋɔɔlik, ki ɔl ci ruben, ki ɔl ci dɔkɔm azɛɛna, ki ɔl ci adiiti iina ki alemeti, been ɔl oogi ci amɔɔr meelik gɛr. Ma avu arekɛ niigi Yesu looc, ma arogoz niini ɔl nicoko dook lai. ");
INSERT INTO mur_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mazi avɔ acin kɔlɛ dook ŋinaante, ɔl o adiiti iina ki alemeti e iziiktɔ ma azɔɔz labak, ki ɔl o dɔkɔm azɛɛna e ɔzɔlantɛ azɛɛna ugeec, ki ɔl o ŋɔɔlik e ɔtɔɔzɔ bɛrbɛr, ki ɔl o rubenik icintɔ, ibiirit nɔɔgɔ ooti giye nico, ma adiŋdiŋan niigi Jook ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Otowa ni Yesu nuyak ogin, ma aku anek nɛ, “Awucnekan ɔl nici ɔrɔɔt ɛlɛ, eeci karomena ki nɔɔgɔ iinya ceen iiyu noko dook, ma ɔkɔm niigi gi ci adak. Alaŋ zin karooŋ kanyek nɔɔgɔ kazaantɛ kɔtɔɔzɔ nɔkɔ kɔkɔm gi ci adak, gɛrzɛ ŋaan avɔ aval magizeeti gɔla.” ");
INSERT INTO mur_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ma abɛdɛkɛ nuyawa nɔɔnɔ anek nɛ, “Ka zin yo kojokta balale nico dayiin ci alɛɛnɔ ki kɔlɛ nicoko dook ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma ajin Yesu nɔɔgɔ anek nɛ, “Anyaku inoko ḏɔkɛn izɔk?” Ma anek niigi nɔɔnɔ nɛ, “Kanyaka ḏɔkɛn torgɛrɛm ki kuluk ci miliny tɛr.” ");
INSERT INTO mur_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Uduwak ni Yesu ɔl dook kaavtiyɔ loota. ");
INSERT INTO mur_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ma adoma ḏɔkɛn ceen torgɛrɛm noko ki kuluk nicoko, ma anyek Jook zany, ma atɛɛt ḏɔkɛn nicoko, ma anyek nuyak keŋeryek ɔl. ");
INSERT INTO mur_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma adake ɔl oke dook zɛɛ been paŋ. Ma alota nuyawa ḏɔkɛn ci anyigjai o zɛɛ ma abitiz gilanya torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Maje ɔl ci baal adake neke een maczɛt doon eet tur lak eet ram (4000) calaŋ kakeebek ŋaai ki dɔl. ");
INSERT INTO mur_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mazi adotiz ɔl dayiinta, anyek Yesu ɔl kɔtɔɔzɔ. Ma atɔɔt niini kavool, ma abaayiz liil akɔ looce o ajɔŋzɔ ki kutur o kazi Magadan. ");
INSERT INTO mur_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ma avunak ɔl o Parici ki ɔl o Sajuzi Yesu. Arɔɔŋ kicinta nɔɔnɔ, ma avu anek nɛ, “Tuguweyet di gi ci ateedet biye ci aku tammu tadena.” ");
INSERT INTO mur_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Gɔɔn mã akɔla ŋɔɔti ci jenu o, anonu nɛ, Uluz tiŋeere tammu alaŋaan bodo atiil. ");
INSERT INTO mur_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Mã acinu anewek tɔ ŋeere ririwɔna, anonu nɛ, Atiil tedec tammu. Anyaku gɔɔn niiga arizɛt ci agayu kaal o ka kivita looc tiŋeere ŋɔɔta. Bar zin alaŋ eeginu arinya ci kaal o agooni inoko o arooŋekuŋ Jooi igeet ka agaac. ");
INSERT INTO mur_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mazin ɔl ci arɔɔŋ kicinit gi ci atɛɛt ɔl biye kiyo niiga noko gɛrzɛ ɔrɔɔt, ma akɔm nɔɔgɔ Jook. Alaŋ zin bodo kagoonekuŋ naana igeet gi oma ci ateeduŋ biye. Olla gi baal agoononek Jɔna e doon ci ka buk keyelozeyuŋ igeet.” Enico odotek Yesu nɔɔgɔ looc, ɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mazi abaaki nuyawa kibeen Yesu avɔ liil baagita, erektek nuyak ḏɔkɛna ŋaati anyaani. ");
INSERT INTO mur_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma anek Yesu nɔɔgɔ nɛ, “Egenyit ɔrɔɔt! Ebeyit eleeti ole o Parici been ɔl o Sajuzi. Edeya eleeti nyigite ugeec gɔɔn arek ḏɔkɛn ka ketedeec o.” ");
INSERT INTO mur_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma aŋɔmtɔ nuyawa anɔ nɛ, “Aduwa bɔŋ gi nico o, eeci ŋaan kanyaakta ḏɔkɛn.” ");
INSERT INTO mur_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Maje Yesu aga gi ci azɔɔz niigi o nɔkɔ, ma ajin nɔɔgɔ anek nɛ, “Naa akɔ ma azoozu gi ci akɔmnuŋ ḏɔkɛn o? Anyaku niiga tuwɛn ci miliny ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ŋaan dim iziiktɔ nɔkɔ? Alaŋ aadanu iiten baal kaŋɛrɛkɛ ɔl ween 5000 ḏɔkɛn ween tur nɔkɔ e? Waanice alotanu dayiin o anyigjai zɛɛ ma abitiz kodoocɛ izɔk? ");
INSERT INTO mur_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Inoko buk alaŋ aadanu iiten baal kaŋɛrɛkɛ ɔl ween 4000 ḏɔkɛn ween torgɛrɛm nɔkɔ e? Waanice alotanu dayiin o anyigjai zɛɛ ma abitiz kodoocɛ izɔk? ");
INSERT INTO mur_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Alaŋ zin aziiŋnenu naa? Alaŋ kazooz naana zɔɔz ci akati ḏɔkɛn ci ka ketedeec o. Bar kilotuŋ egenyit ole o Parici been ɔl o Sajuzi. Edeya eleeti demziinte uneeŋ gɛr atobɔ ki nyigit o gɔɔn arek ɔl ḏɔkɛn.” ");
INSERT INTO mur_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Enico agaac nuyawa alaŋ arɔɔŋ Yesu nɔɔgɔ kedeya eleeti nyigite o gɔɔn arek ɔl ḏɔkɛn ka ketedeec. Bar arɔɔŋ nɔɔgɔ kedeya eleeti demziinte o ɔl o Parici ki ɔl o Sajuzi. ");
INSERT INTO mur_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mazi akunak Yesu looc ci ajɔŋzɔ ki kutur o kazi Sisiriya Vilipiya, ŋinaante ijin niini nuyak ogin anek nɛ, “Mayo dim gɔɔn azi ɔl nɛ, Naana Ŋɛɛrti Eeto keen ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Azi ɔl ogɛn nɛ, Een Jɔn o oony ɔl. Azi ɔl ogɛn nɛ, Een Ilija. Azi ogɛn nɛ, Een Jirimaya. Azi ɔl ogɛn nɛ, Een nyakaŋan oma nyakaŋanete o Joowo baal adaayitɔ e.” ");
INSERT INTO mur_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ma anek niini nuyak nɛ, “Ma niiga aziyu nɛ, Keen naana ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma abɛdɛkɛ Saiman Pitɔr nɔɔnɔ anek nɛ, “Een niina Kiristo ween ŋɛɛrti Jook o arogi been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma anek Yesu nɔɔnɔ nɛ, “Amayuwin Jooi ineet Saiman ŋɛɛrti Jɔna. Eeci alaŋ aduwakin zɔɔz nico ɛɛti ci deer, bar baaba o aavi tammu tadenu nɛɛn o ayelzakin ineet zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Inoko zin kakateyin ineet zaar ci kazi Pitɔr, ma kɛŋ ci zaar nicoko kazi nɛ bɛ, eeci adoi niina kiyo bɛ o. Mazin biye nico ŋaan keenyeti ceez onan een ɔl o atuyan aneet, ma alaŋ anim daayizi kuulal nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kanyin tiŋeere alaazɛt o baliin o Joowo. Zin gi o abur niina loota ŋina, abornɛ buk tammu tadena. Maje gi o agama niina loota ŋina, agamnyai buk tammu tadena.” ");
INSERT INTO mur_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ma bodo aricanek Yesu nuyak ka calaŋ aduwak ɔl oogi gi o ɛɛnɛ niini Kiristo. ");
INSERT INTO mur_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ma iitene nice ɛlɛ akata Yesu gi ci abɔraki nuyak ogin labak nɔkɔ zɔɔz ci anek nɛ, “Abon kakɔ Jerusalɛma ka kɔɔt kigidan alaata o ceez o Joowo been ɔl o ademzek ɔl lotinok. Arukan tiŋeere niigi aneet kadaak. Mazi kadica iinya iiyu, ŋaan kaŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma alakada Pitɔr Yesu doon kidicilim, ma anek nɛ, “Uloi, Manyi! Lam gi nico calaŋ akunakin ineet been nɛɛn. Abon bai ŋaati alaŋ akunakin gi nici nɔkɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Enico ɛlɛ ookci Yesu, ma anek Pitɔr nɛ, “Nyɛyɛ ŋaatan Loryen co. Inoko arooŋ niina ka nyook gɔl o liŋliŋɔn onan, eeci baabani cune o alaŋ aku Joowa, bar baabani ci eet ci deer.” ");
INSERT INTO mur_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Enek ni Yesu nuyak ogin dook nɛ, “Mã arɔɔŋ ɛɛti konowan aneet, abon areyek nɔɔnɔ ɛlɛ oninɛ, ma abon agama gidɛn ki piryakzɛt ŋaati anuyan niini aneet. ");
INSERT INTO mur_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Eeci ɛɛti ci arɔɔŋ korogoz ɛlɛ onin, bar akoloz. Maje ɛɛti ci akoloz ɛlɛ onin ŋaatan, bar arogoz. ");
INSERT INTO mur_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mayo zin inoko mã anyak ɛɛti kaal o loocu dook, ma bar akoloz rogɛt ci ɛlɛ onin, bonat inoo? Mã adaak ɛɛti, akɔm bodo gi ci ka kabadakɛ nɔɔnɔ rogɛt onin. ");
INSERT INTO mur_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kakun zin tiŋeere naana Ŋɛɛrti Eeto ŋaati kɔrkɔrana ki toonnyak o Joowo diŋdiŋonte o baaba. Ma kaku kacacai gɔɔn eet co kaal ogin abon baal gɔɔn agɔɔn e. ");
INSERT INTO mur_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Abon zin agayu gi ce. Anyak ŋaatunooŋ ŋina ɔl oogi calaŋ adaai zɛɛ ma acinan aneeta Ŋɛɛrti Eeto waanci kakunɛ baliinte onan.” ");
INSERT INTO mur_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mazi adicai iinya ceen tɔrkɔnɔm, iyit Yesu Pitɔr ki Jemis been gɔtɔni Jemis o kazi Jɔn, ma avɔ atɔɔt bɛ ci wun, ma aavtiz niigi doon biya ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mazi ŋaan aavtiz nɔkɔ, bar acin niigi Yesu otowɛ nɔɔgɔ kɛbɛrɛn nɔkɔ. Otowɛ ŋum oninɛ kizi vɔɔr pɛr kataraanet kiyo ii o. Ma ookci rumanɛ oginɛ aborcek e buk kizi vɔɔrɛ pɛr ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma ŋintimiliny icinit niigi Mosis ki Ilija azɔɔzɔ ki Yesu. ");
INSERT INTO mur_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Enek ni Pitɔr Yesu nɛ, “Manyi, kavu tɛ ŋina juruŋ. Inoko matɛ arooŋ, nyet kɛtɛɛnycawa kaal ceen ceezi kabili kɔr iiyu ka codoi kizi cun, codoi ci Mosis, codoi ci Ilija.” ");
INSERT INTO mur_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mazi ŋaan azɔɔz niini nɔkɔ, acin diizoc ci vɔɔr pɛr aku, ma aduulɛkɛ nɔɔgɔ diiz. Ma azii niigi molok ci azɔɔz diizoce nico eecitɔ azi nɛ, “Nicini ŋɛɛran onan een didi o kareez ɔrɔɔt. Katalnɛ naana ŋaatin ɔrɔɔt. Abon zin niiga dook aziiŋnu nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mazi azii nuyawa molok nico, iiyak nɔɔgɔ kulurkulur ɔrɔɔt ɛlɛ zɛɛ makacin iitazɔ ŋoliinta kakati ŋumti looc. ");
INSERT INTO mur_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iiya ni Yesu, ma uum nɔɔgɔ anek nɛ, “Itiŋgaz jena. Má aŋolinu looc gaga.” ");
INSERT INTO mur_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mazi aara niigi kɛbɛrɛ, ɔkɔma eet oma ci acin kina. Izi Yesu doon. ");
INSERT INTO mur_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mazi alocai niigi bɛ tadena, iricanek Yesu nɔɔgɔ enek nɛ, “Má avɔ rak aduwaku gi ci ona acinu noko ɔl oogi zɛɛ been iiten ci katin kaŋaanɛ naana Ŋɛɛrti Eeto daayiza e.” ");
INSERT INTO mur_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ijinit ni nuyawa nɔɔnɔ enektek nɛ, “Dim gɔɔn alaata o ademzek ɔl lotinok azi nɛ, Arayai katin Ilija rak ɔɔwa ŋaatun o naa?” ");
INSERT INTO mur_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ii, alɛɛm didi. Ŋɛdɛt Ilija arayai ɔɔwa rak ŋaatan ka kiiya kidimdimaneyan aneet kaal dook keelit juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Inoko zin kanekuŋ nɛ, Iiya Ilija iiten baale, ma akɔm eet ci aga nɔɔnɔ. Ma bar agoonek niigi nɔɔnɔ kaal ci gɛr eo arɔɔŋi niigi. Zin kiyo waanice agit niigi nɔɔnɔ e, agidan buk tiŋeere niigi aneeta Ŋɛɛrti Eeto nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Enico agaac nuyawa zɔɔz ci aduwak Yesu nɔɔgɔ o akati Jɔn o oony ɔl. ");
INSERT INTO mur_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mazi alocai niigi bɛ tadena, ivita amada ɔl ci mɛɛlɛ bɛ loota. Ma akunak ɛɛti oman Yesu, ma aku akani kozoŋti looc nɔɔnɔ ŋuma. ");
INSERT INTO mur_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ma anek nɛ, “Manyi, ɛɛlawan da! Tirit ŋɛɛran ci anyak mɔɔriz ci avalni ce. Gɔɔn ma agam nɔɔnɔ mɔɔrizi nici, iinak goo karabɔŋ een maam. ");
INSERT INTO mur_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kanyaai uyene nɔɔnɔ nuyak cugun noko, bar akɔm ŋaatineeŋ ci anim kitirit nɔɔnɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Igeet ɔl ci akɔmnuŋ tuwɛn coko. Kayo koromtɛ naana kibeen igeet zɛɛ been inin ka utuyɔ? Ka kɛmɛz zɔɔz cunooŋ zɛɛ been inin? Anyaaktayaŋ zin di logo nico ŋaato.” ");
INSERT INTO mur_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma agerenyek Yesu miniŋit ci Loryento noko kuduna. Ma arogi logoti enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ivitak ni Yesu nuyawa oginɛ ŋaati aavɛ niini doon, ma avu ajin nɔɔnɔ anek nɛ, “Matɛ uyene ageeta akɔmneket miniŋit nici ŋaati kaarana naa?” ");
INSERT INTO mur_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ niiga animnyu aarta moorizok ki miniŋ ɔla o, eeci alaŋ anyaku tuwɛn. Didilɛ kaduwakuŋ igeet, inoko tɛ nuun anyayit olla tuwɛn ci miliny tɛr ceen ki keberec ci laŋiracoco, koca ma aneku bɛ nico nɛ, Piya ɛlɛ ŋina! Bitɔ bil bodo ŋaate! Aziiŋnuŋ koca, ma apiya ɛlɛ ŋina, ma akɔ ŋaati ona aduwaku niiga nɔɔnɔ o. Ma akɔm waan gi ci akɔmnekuŋ igeet been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mazi avu alotɛ Yesu ki nuyak ogin iitene oman looce o kazi Galili, enek niini nɔɔgɔ nɛ, “Inoko izi ajɔn ŋinti ka kuruktan ɔl aneeta Ŋɛɛrti Eeto kadaak. ");
INSERT INTO mur_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ma iinyaye ceen iiyu ŋaan kiŋaaz bodo daayiza.” Mazi azii vuyawa zɔɔz nico, akatit culum ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mazi avunak Yesu ki nuyak ogin Kapernam, ivitak ɔl o gɔɔn alot guruc o ceez o Joowo Pitɔr, ma ajin nɔɔnɔ anek nɛ, “Mayo dim gɔɔn alaani cunooŋ noko buk aruk guruc o ceez o Joowo?” ");
INSERT INTO mur_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma abɛdɛkɛ Pitɔr nɔɔgɔ anek nɛ, “Ii ri. Aruk gɔɔn buk.” Maje Yesu aga gi nico nɔkɔ. Mazi akɔ Pitɔr ŋaatin ceeza, enek Yesu nɔɔnɔ nɛ, “Saiman, mayo inoko niina azi nɛ zooze nico? Inoko gɔɔn aruwek alaat o loocu guruc ɔl jaŋ? Ɔl o tatok onin ɛlɛ, yo da aruwek nɔɔgɔ guruc ɔl o bitaalu?” ");
INSERT INTO mur_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ma anek Pitɔr nɔɔnɔ nɛ, “Aruwek nɔɔgɔ guruc ɔl o bitaalu.” Ma azi Yesu nɛ, “Abon! Mazi abil nɔkɔ, alaŋ waan aganɔ ŋaati karuyi naaga guruc ci ceez ci Joowo o. ");
INSERT INTO mur_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bar zin alaŋ karɔɔŋ naaga kanycek nɔɔgɔ kotoborteyet nɔŋ kiziti nɛ, Coma alaŋ karɛɛz naaga ceez o Joowo. Inoko zin bitɔ liila. Yiitɔ abic ka bitɔ dɛtɔi. Zin tedec kulugiti ci akɔ agama oowa neke ajowa anyak otoga guruc ci kalɛɛnɔ ki ageet dook ka kuruktek ɔl nicoko. Doma zin, tedec anyek nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma iitene nice ɛlɛ ivitak Yesu nuyawa oginɛ, ma ajin nɔɔnɔ anek nɛ, “Ŋɛnɛɛn dim inoko ci adikir ŋaatinaaŋ baliinte o Joowo?” ");
INSERT INTO mur_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ma awa Yesu dole ci miliny, ma aku anyek kibil nɔɔgɔ ŋuma. ");
INSERT INTO mur_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma azi nɛ, “Didilɛ kaduwakuŋ igeet, mã alaŋ abadanu eleeti eelit kiyo dɔlya o miliny o, alaŋ avoyu baliinte o Joowo been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma ɛɛti ci anyek ɛlɛ kizi cɛlbɛz kiyo dole ci miliny abil igeet ŋuma noko, eet o adiŋdiŋ baliinte o Joowo nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ma ɛɛti ci atalna dole ci miliny kiyo dole nici noko zaare ogan atalnanan niini aneet. ");
INSERT INTO mur_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bar mazi anyak eet ci anyek dɔl ci miliny noko codoi ŋaatineeŋ kimiire kivurut calaŋ atuyan aneet, aganɔ koca niini ŋaati acabonɛkɛ golu nɔɔnɔ inyaa, ma ajukonek liil kotododɛ kook many. ");
INSERT INTO mur_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Izi nɔŋa wole zin ole o anyek ɔl kabaca oŋɛ. Ŋɛdɛt kaal ci gɛrzɛ acinanuŋ igeet noko avunak looc nico tup. Bar zin izi nɔŋa wole eete ci laadun anyaa kaal nicoko o. ");
INSERT INTO mur_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mã anyin aziiti karabɔŋ een zɔɔci baca baciinok, abon atɛɛda, ma ajukei tuu. Abon bar akɔ rogete o abil been nɛɛn ŋaati ɛɛnɛ ŋɔɔl karabɔŋ adowinin aziiti kujuk ŋaati ajukonɛkɛ goo o Loryento abil been nɛɛn ŋaati anyayɛ zɔɔ ki azɛɛn dook. ");
INSERT INTO mur_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mã anyin kɛbɛrɛci baca baciinok, abon akana, ma ajukei tuu. Abon ŋaati akɔyɛ rogɛta keberece codoi kujuk ŋaati ajukonɛkɛ goo Loryento abil been nɛɛn ŋaati anyayɛ kɛbɛrɛ dook. ");
INSERT INTO mur_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Egenyit zin juruŋ ka calaŋ apezu dolene ci miliny noko codoi ŋaatineeŋ. Didilɛ kaduwakuŋ igeet, ma toonnyawa ugeec abɛk nɔɔgɔ gɔɔn avɔ Joowa tup, ma aduwak nɔɔnɔ kaal o agooneku niiga dɔl ci miliny noko.” ");
INSERT INTO mur_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ma ajin Yesu nɔɔgɔ anek nɛ, “Inoko mã anyak ɛɛti ɛɛza ceen eet tur, ma akoloni codoi ŋaatineeŋ, abaabanu agɔɔn koca niini naa? Bar kanɛ ooŋnek rak koca ɛɛza ceen eet wec kamɔtɔ ki tiin tɔrkɔc o looc, ma akɔ arɔɔŋ ɛɛz codoi ona akoloni o zɛɛ ma ajowa. ");
INSERT INTO mur_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Didilɛ kaduwakuŋ igeet, akɔ zɛɛ mazi ajowa niini ɛɛz nico, atalnɛ ŋaatin ɔrɔɔt ɛlɛ kujuk talniin o anyak ɛɛzaye o ŋaan kukuluze e. ");
INSERT INTO mur_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mazin buk gole nico baatunooŋ o aavi tammu tadena alaŋ arɔɔŋ dole codoi dolene ci miliny noko kokolozɛ. ");
INSERT INTO mur_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mã agoonekin gotonu gi ci gɛr, bitɔ ŋaatin ka bitɔ bɔrak nɔɔnɔ gi nico. Abon zin aminyu niiga doon. Mã aziiŋnin niini ineet, idicai gi nici, izi niini gotonu bodo. ");
INSERT INTO mur_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bar mã alaŋ aziiŋnin niini ineet, biti eet codoi karabɔŋ een ɔl ram orkorit ki ineet, ka kɔɔt kiziiyit zoozok ci abornekin niini ineet o eo aduwan waragɛ o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bar mã alaŋ buk azii niini nɔɔgɔ, bitɔ duwak ɔl o ceez o Joowo zɔɔz nico. Mazi alaŋ azii niini ɔl o Joowo buk, abon adɛyanu niiga dook ŋaatin. ");
INSERT INTO mur_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Didilɛ kaduwakuŋ igeet dook, ma gi ci azoozu, ma abornu niiga loota ŋina, abornɛ buk tammu tadena. Maje gi ci azoozu, ma agamanu niiga loota ŋina, agamnyai buk tammu tadena. ");
INSERT INTO mur_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mã arom ɔl raman ŋaatunooŋ eleeti, ma ajin Jook gi ci arɔɔŋ niigi nɔɔnɔ kutuguwek, agoonek koca baaba tammu tadena nɔɔgɔ gi nico. ");
INSERT INTO mur_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Eeci mã alotɛ ɔl raman karabɔŋ een iiyon zaare ogan, karomɛna buk naana ki nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iiyak ni Pitɔr Yesu, ma aku ajin nɔɔnɔ anek nɛ, “Manyi, inoko mã agoonekan gɔtɔna gi ci gɛr, kotoŋ nɔɔnɔ lak izɔk? Kotoŋ lak torgɛrɛm?” ");
INSERT INTO mur_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm! Alaŋ een lak torgɛrɛm nɔkɔ, bar toŋ nɔɔnɔ lak eet iiyu kamɔtɔ lak torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Eeci baliin o Joowo abil kete. Anyak baale alaan ci arɔɔŋ kɛkɛɛp ŋabolɛt baal gɔɔn da anyek niini ɔl ogin aliŋliŋonek nɔɔnɔ e iziti izɔk. ");
INSERT INTO mur_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mazi akana ka kɛkɛɛp, anyaaktak ɔl nɔɔnɔ eet ci anyak ŋabolo ci guruc ci meel gɛr ci atobɔ ki guruc ci kataalanɛ tiin eet tur lak amɔtɔ. ");
INSERT INTO mur_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Maje ɛɛti nici alaŋ anyak guruc ci meel ka kurui ŋabolo nico. Ma aricanek alaani ɔl ka kɔɔt kataalɔi nɔɔnɔ ki ŋaa onin ki dɔl ogin ki kaal ogin anyak dook ka kurui ŋabolo nico. ");
INSERT INTO mur_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Mazi akɔ azii ɛɛti nici zɔɔz nico, iiya akati kozoŋti looc alaan onin ŋuma, ma azi nɛ, “Anyek da kalalin ziniz ŋaatan zɛɛ ma karuwekin kaal cugun o dook kidicilim labak.” ");
INSERT INTO mur_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Uwucek ni alaan zɔɔz nici, makacin otoŋek didi niini nɔɔnɔ ŋabolo nico, ma anyek nɔɔnɔ kɔɔtɔ. ");
INSERT INTO mur_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mazi adun ɛɛti nici, ook urumtɔ ki gɔn oma ci anyayek nɔɔnɔ ŋabolo ci miliny tɛr. Ma agam nɔɔnɔ, ma adaal alɛm anek nɛ, “Nyan guruc ogan baal anyei e.” ");
INSERT INTO mur_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ma akani ɛɛti nici kozoŋti looc nɔɔnɔ ŋuma, ma anek nɛ, “Anyek da kalalin ziniz ŋaatan zɛɛ ma karuwekin guruc cugun o labak.” ");
INSERT INTO mur_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bar niini alaŋ arɔɔŋ kiziik zɔɔz nico been nɛɛn. Ma bar anyek nɔɔnɔ kook sijina ka kook kacabɛ zɛɛ ma aruk ŋabolo nico. ");
INSERT INTO mur_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mazi akɔ acin ɔl ogɛnɛ ci aliŋliŋ ki nɔɔnɔ ŋaatodoi gi nico, otoborit niigi nɔŋ ɔrɔɔt, ma avɔ aduwak alaan gi ci agɔɔn niini noko. ");
INSERT INTO mur_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ma awa alaani nɔɔnɔ ma aku anek nɛ, “Een eet ci gɛr ɔrɔɔt. Iiten baale kuuŋnekin naana ineet ŋabolo baal appe e, eeci arooŋnyan aneet kutuŋeyin. ");
INSERT INTO mur_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Abon waan zin buk awunekin gotonu nici kiyo baale awucnekan niina aneet e.” ");
INSERT INTO mur_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Enico otobor alaani nɔŋ arɔɔt, ma itoonek nɔɔnɔ sijin ka kook kipirtai ɔl nɔɔnɔ sijina zɛɛ ma aruk guruc baalke dook.” ");
INSERT INTO mur_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma anek Yesu nɔɔgɔ nɛ, “Mã alaŋ ooŋneku gotonogu kaal o abaca niigi ŋaatunooŋ zinzeetine ugooc dook, koca buk baaba o aavi tammu tadena alaŋ ooŋnekuŋ igeet kaal o abacanu.” ");
INSERT INTO mur_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Mazi adica Yesu zoozok nicoko, itiŋa Galiliya ook abaawozek looc o kazi Judiya liil o kazi Jordan baagita. ");
INSERT INTO mur_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma ano ɔl ci meel gɛr nɔɔnɔ, ma akɔ arogoz niini nɔɔgɔ moorizowɛ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma avunak ɔl o Parici nɔɔnɔ arɔɔŋ kicinta nɔɔnɔ ŋaati ajini aneki nɛ, “Mayo gɔɔn lotinowa ogaac aziiŋnek eet kɔtɔɔk ŋaa cin giye ci ɔɔ cin doon labak? ");
INSERT INTO mur_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋaan da niiga ekeebit waragɛ o Joowo rɛɛn o azi nɛ, Baale kinatamma laadun e ɛɛnyca Jooi eet ci mac ki ŋaa. ");
INSERT INTO mur_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma azi Jooi nɛ, Gi o zin gɔɔn ooŋni ɛɛti baatin ki yaatin, ma akɔ aromɛn niini ki ŋaa cin o nɛɛn nici ka kiziti niigi dook ramantiya ɛlɛ codoi. ");
INSERT INTO mur_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Alaŋaan zin bodo niigi eegin ram, bar iziti ɛlɛ codoi. Akɔm zin bodo eet ci ka kɛŋɛr gi ci orom Jooi o.” ");
INSERT INTO mur_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma ajin ɔl o Parici nɔɔnɔ anek nɛ, “Mazin da baale Mosis azi nɛ, Mã arɔɔŋ kɔtɔɔk ɛɛti ŋaa cin, abon labak, olla anycek kɛtɛyɛɛdak niini nɔɔnɔ waragɛ ci ŋeronto o naa?” ");
INSERT INTO mur_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Anyuŋ lotinowa o Mosis gɔl ci atooku ŋaai labak o, eeci igeet adɔi zinzeeti kak. Maje baale laadun kinatamma e laadun alaŋ abil nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Inoko zin kanekuŋ nɛ, Mã ɛɛti ci atɔɔk ŋaa cin ŋaati alaŋ agami zoocmaza, ma akɔ arɔca niini ŋaa oma bodo, odoma niini zoocmaz.” ");
INSERT INTO mur_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ma vurta ivitak nuyawa Yesu, ma avu anek nɛ, “Mã een gɔl ci akati ŋaa kibeen eet nɛɛn nici, maya bar alaŋ karɔcɛ dook.” ");
INSERT INTO mur_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma gɔl calaŋ karocin o alaŋ akati ɔl dook, bar akati ɔl o anyek Jooi nɔɔgɔ dɔyiz ci aavtiyɛ calaŋ arocin doon. ");
INSERT INTO mur_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eeci anyak kaal oogi ci anyek ɔl calaŋ arɔcɛ. Ɔl ogɛn alaŋ arɔcɛ o, eeci aritai gole nico nɔkɔ laadun. Ɔl ogɛn alaŋ arɔcɛ o, eeci anyek ɔl ogɛnɛ nɔɔgɔ calaŋ arɔcɛ. Ɔl ogɛn alaŋ arɔcɛ, eeci arɔɔŋ kiliŋliŋit gɔl ci akati baliin o Joowo. Ma ɛɛti ci agama gɔl calaŋ karocin o, anycek nɔɔnɔ kagama didi.” ");
INSERT INTO mur_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma anyaak ɔl oginɛ Yesu dɔl ci miliny ka kiiya kataadek niini nɔɔgɔ azɛɛn kamayuk ma ajinek nɔɔgɔ Jook. Maje bar nuyawa oginɛ agernyek ɔl nicoko ka calaŋ anyaak dɔl Yesu. ");
INSERT INTO mur_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma anek Yesu nɔɔgɔ nɛ, “Anycek dɔl kivitayan aneet. Má alamnyu nɔɔgɔ, eeci baliin o Joowo abilnek ɔl o anyek eleeti keelit kiyo dɔlya ci miliny noko.” ");
INSERT INTO mur_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Amayuk ni niini nɔɔgɔ zɛɛ ɔtɔɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma akunak ɛɛti ci ŋaan een mɔldɔŋ Yesu, ma aku ajin nɔɔnɔ anek nɛ, “Alaan o demziinto, mayo gitaz ci abon kagoon ka kojowa rogɛt o abil been nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔ ma ajinan gi ci abon ka tugu o naa? Akɔm zin gi oma ci abon, bar abon Jooi doon. Mazi arooŋ rogɛt o abil been nɛɛn, zooti lotinok.” ");
INSERT INTO mur_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma abɛdɛkɛ ɛɛti nici Yesu anek nɛ, “Lotinok jaŋ?” Abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Má amuny eet ci deer. Má adoma zoocmaz. Má agɔrzɛ. Má avoloŋ. ");
INSERT INTO mur_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tɔŋɔlɛ baatun ki yaatun. Zin ricik ɔrɔɔt rɛɛz ɔl o abaawonu kiyo areez ɛlɛ unun o.” ");
INSERT INTO mur_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ma abɛdɛkɛ ɛɛti nici Yesu anek nɛ, “Lotinok nicoko dook kazoonɛ baale laadun. Gi jaŋ zin inoko ci arooŋnyan bodo kutugu?” ");
INSERT INTO mur_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma anek Yesu nɔɔnɔ nɛ, “Mã arooŋ ka bona ŋume o Joowo, bitɔ taalɔi kaal ugun dook zɛɛ ŋerek guruc ɔl o amaat. Mazi odot, ija niina alya nowan aneet. Ŋaan akɔ ajowa arɔkzɛt tammu tadena.” ");
INSERT INTO mur_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Mazi azii ɛɛti nici zɔɔz nico, alaca ɛlɛ, ma awɔ bornɛt nɔŋa, eeci een niini aroi ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Enek ni Yesu nuyak ogin nɛ, “Didilɛ kaduwakuŋ igeet, adɔi ɔrɔɔt ɛlɛ eete ceen aroi ŋaati akɔyi baliinte o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Inoko bodo kabɛdɛkɛ zɔɔz nico kanekuŋ nɛ, “Adɔi ɔrɔɔt ɛlɛ eete ceen aroi ŋaati akɔyi baliinte o Joowo kiyo alaŋ ayizonek nyakale nyibira ŋino vɔlɔŋ o.” ");
INSERT INTO mur_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mazi azii nuyawa zɔɔz nico, ibiirit nɔɔgɔ dook ooti tɛt giye nico, ma anɔ nɛ, “Ka dim zin katin korogozɛ ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ɛgɛlɛm ni Yesu nɔɔgɔ, ma anek nɛ, “Ma zɔɔz nici adɔi eete ci deer doon, maje Joowa akɔm gi ci adɔi.” ");
INSERT INTO mur_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Inoko kotoŋteya naaga kaal ogaacak dook looc, ma kivita kunuyin ineet o, mayo katin kajowana naa?” ");
INSERT INTO mur_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, katin waanci kagamɛ naana Ŋɛɛrti Eeto alaazɛt onan tammu tadena, niiga ci anuyaŋ aneet eeginu amɔtɔ ram noko avɔ buk niiga aavtiyu lecerene cugooc een amɔtɔ ram ka apayit boryok o Israyil een amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma ɛɛti ci ooŋ kɔrɔk onin, ki gɔtɔnɔgi, ki ŋɔɔnɔgi, karabɔŋ een yaatin, ki baatin, ki dɔl cigin, ki mana cin ŋaaten aneet, azaaconek bodo katin nɔɔnɔ kaal ci meel, ma ajowa buk niini rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Zin ɔl ci meel ole o inoko abaaban bar kizik oontanɛ niigi gole o Joowo, katin eegin vurut. Maje ɔl ci meel ole o inoko abaaban kizik niigi eegin vurut gole o Joowo bar, katin oontanɛ niigi.” ");
INSERT INTO mur_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ma anek Yesu bodo nɔɔgɔ nɛ, “Ma baliin o tammu tadenu abil kete. Anyak baale eet ci mano alɔk ririwɔna ka kook kataala ɔl ci avu atɛɛt mana. ");
INSERT INTO mur_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mazi akɔ ajowa nɔɔgɔ, ɔzɔɔztɔ ki nɔɔgɔ zɛɛ ma agama ka kanyek niini nɔɔgɔ eet codoi gɔɔn ŋaatineeŋ gurucoc codoi liŋliŋone ci iiten dook. Itoonek ni niini nɔɔgɔ mana kɔɔt kiliŋliŋit. ");
INSERT INTO mur_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ma ziiye ween tɔrkɔc ɔtɔɔ bodo ook ɔrɔɔŋ ɔl oogi mɛlɛgɛnyai. Ma akɔ ajowa ŋinaante ɔl ci olla ɛɛl aŋaam, akɔm gi ci aliŋliŋ kina. ");
INSERT INTO mur_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Enek ni niini nɔɔgɔ nɛ, “Karooŋnyuŋ ɔtɔɔ iliŋliŋteyaŋ mana. Ŋaan tedec karuwekuŋ igeet dook guruc ci aganɔ ki liŋliŋɔn.” ");
INSERT INTO mur_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Agamta ni niigi gi nico, ma avɔ mana, ma waaz ziiye ween amɔtɔ ram been ziik ween iiyu yomana ook anyaa niini ɔl oogi ka kivita kiliŋliŋit mana. ");
INSERT INTO mur_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma ziiye ween tur yomana ook mɛlɛgɛnya bodo, ma akɔ ajowa ɔl oogi ɛɛl ŋinaante olla aŋaam, akɔm gi ci aliŋliŋ kina. Ma anek nɔɔgɔ nɛ, “Ma dim aavtiyu ŋina adicanu iiten dook o agoonu naa?” ");
INSERT INTO mur_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kaavtiya ŋina o, eeci akɔm eet ci aku akɔyet ka koota kiliŋliŋtozeya.” Enek ni niini nɔɔgɔ nɛ, “Ivita ɔɔtɔ iliŋliŋit mane onan.” ");
INSERT INTO mur_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ma yomana enek ɛɛti o mano eet o gɔɔn abɛk ɔl keevinta nɛ, “Izi yoman. Odot liŋliŋɔni. Towa ɔl ka kivita kagamit guruc. Kata ole ona akana liŋliŋɔn vurta e zɛɛ been tir ole ona arayai e.” ");
INSERT INTO mur_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ivita ni ɔl ona akana liŋliŋɔn ziiye ween tur yomana e, ma anyek ɔl nɔɔgɔ dook eet codoi gɔɔn ŋaatineeŋ gurucoc codoi. ");
INSERT INTO mur_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Mazi avu ɔl ona akana liŋliŋɔn ɔɔwa e ka kagamit guruc, anycek buk ɔl nɔɔgɔ gɔɔn eet codoi ŋaatineeŋ gurucoc codoi. Maje bar uyen niigi abaaban kizik tedec anyonek nɔɔgɔ guruca ci meel kujuk ɔl ona avu liŋliŋɔn vurta e. ");
INSERT INTO mur_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma vurta mazi agamit guruc odot, ɔɔt oyoyit eet o mano e. ");
INSERT INTO mur_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Anek niigi nɔɔnɔ nɛ, “Ɔl ci ona avu akana liŋliŋɔn vurta o aliŋliŋ niigi ziit codoi ṯɔr nɔkɔ. Maje naaga kaliŋliŋnya uyene iiten dook kore ci abur pɛr. Alaŋ abon zin ŋaati waan katobona naaga kibeen nɔɔgɔ guruci.” ");
INSERT INTO mur_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ma abarzek ɛɛti ci mano noko eet codoi ŋaatineeŋ anek nɛ, “Ziik di, gɔtɔn. Alaŋ kadakuŋ looc nɔkɔ been nɛɛn. Uyene agamtawu liŋliŋɔn ka iliŋliŋit gurucoc codoi iiten dook. ");
INSERT INTO mur_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Inoko odomta guruc cugooc o, ɔɔtɔ ɔlɔ. Ma naana kanyi ɔl ci ona avunak liŋliŋɔn vurta o guruc ci atobɔ ki ci ona kanyuŋ igeet o labak. ");
INSERT INTO mur_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mã anyak gi ci karooŋ kutugu guruce cigan o, kagoon labak. Yo da amadiku ɔl ci ona avu vurta o, eeci kiirkei nɔɔgɔ guruc?” ");
INSERT INTO mur_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Izi ni Yesu nɛ, “Tiŋeere ɔl o inoko een vurut, oontanɛ niigi ɔɔwa. Maje bar ɔl o inoko een ɔɔ, amiiri kizi vurut.” ");
INSERT INTO mur_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mazi avɔ Yesu ki nuyak ogin Jerusalɛma, ook uduwak niini nɔɔgɔ doon gɔla gi ci anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Inoko kavɔ Jerusalɛma ŋaao ka kook kanyozozɛkɛ naana Ŋɛɛrti Eeto alaat o ceez o Joowo kibeen ɔl o demziinto. Ma avɔ apayekan tiŋeere niigi aneet daayiz. ");
INSERT INTO mur_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Avoyan zin tiŋeere niigi alaate o Rom ka kɔɔt komomoztan niigi aneet, ma arukan, ma avɔ adodoyan keete ween talakec. Zin iinyaye ceen iiyu, kiŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Iiyak ni ŋaa ci eet ci kazi Zebedi kibeen lɔgɔz cigin een ram kazi zaar cigeec nɛ Jemis ki Jɔn Yesu, ma aku akani kozoŋti looc Yesu ŋuma, ma anek nɛ, “Anyak da gi ci karooŋ tuguweyan.” ");
INSERT INTO mur_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Arooŋ gitaz?” Ma anek niini Yesu nɛ, “Karooŋ katin waanci ɛɛnɛ alaan, anyek lɔgɔz cigan noko keŋerteyin ineet kɔrgɛn kiziti buk niigi alaat.” ");
INSERT INTO mur_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ niiga gi ci ajinaŋu noko agayu juruŋ. Inoko tiŋeere piryakzɛt ci kakɔ kapirnanɛ neke niiga animnyu?” Ma agama niigi dook azi nɛ, “Ii, kanimnya labak.” ");
INSERT INTO mur_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋɛdɛt didi tiŋeere apirnanu kiyo naana o. Bar zin inoko o akɔmnan aneet alaazɛt ci ka kanyuŋ igeet eŋerteyaŋ katin gɔɔn kɔrgɛn. Aŋɛra ɔl ci ka kaavtiyɔ vitɛnane nicoko o baaba doon.” ");
INSERT INTO mur_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Mazi avɔ azii nuyawa ween amɔtɔ e gi nico, otobortek niigi lɔgɔz ceen gɔtɔn een ram noko nɔŋ. ");
INSERT INTO mur_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ma awa Yesu nɔɔgɔ dook ŋaatodoi, ma aku anek nɛ, “Agayu niiga gɔɔn alaata o loocu ŋina anyak dɔyiz ole ugeec ci abali nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bar zin niiga alaŋ abon ŋaati eelnu kiyo niigi o. Mã anyak ŋaatunooŋ eet ci arɔɔŋ dikirzɛt, abon rak bar aliŋliŋonek niini gɔnɔgi kiyo gabarɛnti o. ");
INSERT INTO mur_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Buk mã arɔɔŋ ɛɛti ŋaatunooŋ kootonai kizi ɔɔ, abon rak anyek ɛlɛ kizi gabarɛn. ");
INSERT INTO mur_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Utuguz niiga kiyo buk naana Ŋɛɛrti Eeto o. Alaŋ kakun ka kiiya kiliŋliŋtozeyan ɔl aneet, bar kakun ka kiiya kiliŋliŋozek naana ɔl, ma kadaai ka korogoz ɔl ci meel.” ");
INSERT INTO mur_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Mazi iŋaaz Yesu kibeen nuyak ogin Jerikowa, oneec nɔɔgɔ kɔlɛ ci meelik gɛr. ");
INSERT INTO mur_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maje ɔl ci ruben een ram aavtiz gɔla, iziiyit Yesu aku anowa gɔl nico. Egerenyit ni niigi dook ramantiya azi nɛ, “Ŋɛɛrti Devid, tiritet da!” ");
INSERT INTO mur_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Maje ɔl ceen kɔlɛ ɔrkɔr ki Yesu noko agernyek nɔɔgɔ kajaktɔ. Bar enico egerenyit niigi ɔrɔɔt ɛlɛ kujuk we azi nɛ, “Ŋɛɛrti Devid, tiritet da!” ");
INSERT INTO mur_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Enico ibil Yesu, ma awa nɔɔgɔ, ma aku anek nɛ, “Arooŋnyaŋ kutuguweyuŋ naa?” ");
INSERT INTO mur_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Manyi, karooŋnyin kolet kɛbɛrɛ kicintowa.” ");
INSERT INTO mur_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Uwucek ni Yesu gi nici, ma uum nɔɔgɔ kɛbɛrɛ. Enico ɛlɛ ɔkɔltɛ kɛbɛrɛ ugeec icintɔ labak, ma ano Yesu. ");
INSERT INTO mur_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mazi avunak niigi ŋino kazi Bezpeja ajɔŋzɔ ki Jerusalɛm biye o kazi Kiŋiroc, ŋinaante itoonun Yesu nuyawe ogin ram karaktɛ. ");
INSERT INTO mur_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Anek nɔɔgɔ nɛ, “Ɔɔtɔ korogjowe ci ɛɛl igeet ɔɔwa neke. Avɔ tedec ajowanu zigir ci acabje kibeen jɔrɔn ŋinaante. Ɔɔkta zin nɔɔgɔ dook ramantiya ka anyaaktayaŋ ŋina. ");
INSERT INTO mur_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mã anyak eet ci ajinuŋ, enektek nɛ, Arɔɔŋ Manyi nɔɔgɔ. Anyuŋ tedec niini igeet anyaakta labak.” ");
INSERT INTO mur_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Agooni gi nici nɔkɔ o ka kɛlɛɛmnyai zɔɔz baal aduwa nyakaŋani azi nɛ, ");
INSERT INTO mur_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Enektek ɔl o Jerusalɛm nɛ, Icinit di, iiyayuŋ alaani unooŋ. Acɛlbɛzɛn niini ɛlɛ, ma awɔ joronte ci zigiro.” ");
INSERT INTO mur_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ɔɔt ni nuyawa ceen ram noko, ma avɔ agɔɔn eona aduwakɛ Yesu e ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Anyaakta zigir been jɔrɔn, ma avu ataadek niigi rumanɛ ugeec zigir bawuc, ma anyek Yesu kɔtɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Maje kɔlɛ ci meelik gɛr avetek rumane gɔl kɛŋ. Maje ogɛn acarkiza bɔlɔk, ci keenu, ma avu avetek gɔl buk. ");
INSERT INTO mur_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Maje kɔlɛ ci araki Yesu ɔɔwa o kibeen ci awɔ nɔɔnɔ vurta o agɛrɛny azi nɛ, “Kidiŋdiŋanit Ŋɛɛrti Devid! Amayuk Jooi nɔɔnɔ o aku zaare o Jook ona! Abil diŋdiŋɔnti ŋaaten Jook!” ");
INSERT INTO mur_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mazi akɔ arum Yesu Jerusalɛm, adɔŋnyai ɔl dook kutura dɔŋ. Ma ajinɔ anɔ nɛ, “Eet jaŋ tɛ nici?” ");
INSERT INTO mur_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma anek kɔlɛ ci ano Yesu o nɔɔgɔ nɛ, “Nicini Yesu ween nyakaŋan o aku kuture o kazi Nazarɛt abil Galiliya.” ");
INSERT INTO mur_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ook ni Yesu kaluwawe o ceeze o Joowo eecitɔ, ma akɔ atɔɔwa ɔl o gɔɔn ataalinɛ kaal been ɔl o ataali dook bitaala lai. Ma uup tarabɛzɛt ci ɔl o abali guruc ŋinaante kibeen lɛcɛrɛ ci ɔl o ataalinɛ yɛɛla. ");
INSERT INTO mur_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma anek niini nɔɔgɔ nɛ, “Ayeedi waragewe o Joowo zɔɔz ci anɛ Jooi nɛ, Ceez cane o ceez ci ŋaryiinto. Maje bar niiga avu anyeku kizi ŋinti aroodinɛ agoryawa.” ");
INSERT INTO mur_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ma ŋinaante ivitak nɔɔnɔ ɔl ci ŋɔɔlik ki ci ruben, ma arogoz niini nɔɔgɔ dook lai. ");
INSERT INTO mur_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mazi akɔ acin alaata o ceez o Joowo kibeen ɔl o gɔɔn ademzek ɔl lotinok kaal ci atɛɛt ɔl biye agɔɔn Yesu noko, otoborit niigi nɔŋ ɔrɔɔt. Ma abor buk niigi nɔŋ, eeci dɔl o miliny aavtiz ceeze o Joowo agɛrɛny atal Yesu azi nɛ, “Kidiŋdiŋanit ŋɛɛrti Devid.” ");
INSERT INTO mur_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma anek ɔl ci abor nɔŋ noko Yesu nɛ, “Inoko azii gi ci aduwa niigi o?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ii, kazii. Ma niiga ŋaan ekeebit zɔɔz nico waragɛwa? Azi waragɛ o Joowo nɛ, Niina Jooi ademez gɔɔn dɔl o miliny ka katanaazin ineet juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Enico ɔtɔɔ Yesu otoŋek nɔɔgɔ looc ook kuture o kazi Bezani, ma akɔ ɔɔŋ baalin codoi ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ma ŋeere ririwɔna iitene ci ano gɔn o ɔlɔwa Yesu Bezaniya ŋaabaal ɔɔŋɛ e abadaak Jerusalɛm. Ma gɔla adawun nɔɔnɔ magiz. ");
INSERT INTO mur_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma acin kɛɛt ceen moneec gɔl kabanyca, ma anyaaŋonek azi nɛ, Coma abiir. Mazi akɔ acin, bar akɔm kɛbɛrɛ kina, olla anyak bɔlɔk doon. Enek ni niini kɛɛt nico nɛ, “Alaŋ bai bodo katin niina abiir nɔkɔ been nɛɛn.” Enico ɛlɛ araabjai kɛɛt nici kɔdɔk kak. ");
INSERT INTO mur_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mazi acin nuyawa gi nico, ibiirit nɔɔgɔ ooti, ma anɔ nɛ, “Araabjai yo kɛɛt nici taman nɔkɔ ku?” ");
INSERT INTO mur_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma abɛdɛkɛ Yesu nɔɔgɔ enek nɛ, “Didilɛ kaduwakuŋ igeet, mã atuwenu niiga kɔkɔm gi oma ci abakbayanuŋ zinzeeti, animnyu koca buk utuguz gi ci abil kiyo ci kagoonei naana kɛɛt nico noko. Alaŋ zin buk bar een gi nico doon, bar animnyu buk koca enektek bɛ nico nɛ, Piya ɛlɛ ŋina. Bitɔ jukozek liil, ma aziiŋnu koca niini igeet. ");
INSERT INTO mur_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mã atuwenu, anyuŋ koca gɔɔn Jooi kaal o ajinu ŋaatin dook.” ");
INSERT INTO mur_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Abadaak ni Yesu ceez o Joowo, ma aku adɛmɛz ɔl. Mazi ŋaan adɛmzɛ nɔkɔ, ivitak nɔɔnɔ alaata o ceez o Joowo ki ɔl o Juz adikir, ma avu ajin niigi nɔɔnɔ anek nɛ, “Ma dim alaazɛt ci agɔɔnɛ kaal nicoko o anyin ineet ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Karooŋ buk kijinuŋ naana igeet gi codoi ṯɔr nɔkɔ ce. Mã aduwakaŋ, kaduwakuŋ buk koca naana igeet alaazɛt can kagɔɔnɛ kaal nicoko o. ");
INSERT INTO mur_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Baale Jɔn o oony ɔl ajowa alaazɛt baal oonyi ɔl e ɔla yo Joowa da?” Mazi ajin Yesu nɔɔgɔ nɔkɔ, adaŋtɔ niigi maany izitɔ nɛ, “Kayo kenektek nɛ? Mã inoko kanek nɛ, Ajowa Joowa, aneket koca nɛ, Alaŋ zin da baale atuyu Jɔn naa? ");
INSERT INTO mur_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bar mã kanek nɛ, Ajowa eete ci deer, aborneket koca ɔl nici dook nɔŋ, eeci baale atu niigi Jɔn anyek kizi nyakaŋan.” ");
INSERT INTO mur_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛbɛdɛkɛ ni niigi Yesu enektek nɛ, “Alaŋ kagaya.” Ma anek Yesu nɔɔgɔ nɛ, “Alaŋ zin buk kaduwakuŋ igeet eet ci anyan alaazɛt ci kagɔɔnɛ kaal nicoko o.” ");
INSERT INTO mur_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Abaabanit di gi ce. Anyak baale eet ci anyak lɔgɔz ram. Ook ni ɛɛti logote cin een abuu o, ma akɔ anek nɛ, “Bitɔ liŋliŋ mana waanico.” ");
INSERT INTO mur_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Abɛdɛkɛ niini baatin anek nɛ, “Kajura,” bar bodo ŋintimiliny nɔkɔ itiŋa ook mana eona aduwaki baatinɛ nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ook ni bodo baatinɛ logote ween tutur, ma akɔ anek buk nɔɔnɔ nɛ, “Bitɔ liŋliŋ waanico mana.” Ma agama azi nɛ, “Yɔŋ, ŋaan kakɔ,” bar vurta aavu alaŋaan akɔ mana been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ma anek Yesu nɔɔgɔ nɛ, “Inoko logoze ceen ram noko jaŋ ci iziik gi o aduwak baatinɛ nɔɔnɔ?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Iziik baatin logoti ween abuu e.” Enek ni Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, avɔ tiŋeere ɔl o gɔɔn alot meeri kibeen ŋaai ween waaŋnyak baliinte o Joowo, maje bar niiga alaŋ avoyu. ");
INSERT INTO mur_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Eeci baale iiyayuŋ Jɔn o oonyi igeet ka kiiya keyeleyuŋ gɔl o abon ka waan oneec, ma bar alaŋ aziiŋnu niiga nɔɔnɔ. Maje bar waanice ɔl o gɔɔn alot meeri ki ŋaai ween waaŋnyak iziiyit niigi zɔɔz onin. Mayo nuun icintu niiga gi nice e, alaŋ arooŋnyu otoweec ooti ugooc ka utuweec nɔɔnɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ma anek Yesu nɔɔgɔ nɛ, “Iziiyit di bodo yabziin oma ce. Anyak baale eet oma ci aḏok mana ci keenu, ma alok juruŋ, ma agɔɔna ŋinti ka gɔɔn kocoortek ɔl nyaantanɛ, ma ɛɛnyca vaaco ci beyiinto. Mazi akɔ adotiz, ook anyaa ɔl ci ka gɔɔn kiliŋliŋit mana. Ɔtɔɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mazi akɔ ajɔn iiteni o teedinto, itoona niini gabara ogin kɔɔt ole o aliŋliŋ mana ka kɔɔt kanyaaktak nɔɔnɔ kɛɛn kɛbɛrɛ cigin. ");
INSERT INTO mur_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mazi avɔ arum gabara nici ɔl o aliŋliŋ mana, agamit niigi gabara nicoko, ma arɔɔk codoi, ma aruk codoi kadaak, ma avac codoi biyɛnɛ. ");
INSERT INTO mur_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ma iitene oman itoona bodo ɛɛti ci mano o gabara oogi ci meel kujuk baal oowu e. Mazi avɔ arum niigi mana, utuguzek bodo ɔl ci aliŋliŋ mana o nɔɔgɔ gi baal rak agoonek gabara baal oowu e ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma vurta itoonek niini nɔɔgɔ ŋɛɛrin onin ɛlɛ azi nɛ, “Kaga naana aŋole tiŋeere niigi ŋɛɛran.” ");
INSERT INTO mur_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mazi bar avɔ acin ɔl ci aliŋliŋ mana noko ŋɛɛrti eet ci mano o, izitɔ nɛ, “Ŋɛɛrti eet o mano nɛɛn nici. Ivita kuruyit kadaak ka kula kaalyan cigin o dook kizi cigaac.” ");
INSERT INTO mur_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Agamit ni niigi nɔɔnɔ ooti mana bawuca, ma avɔ aruk kadaak.” ");
INSERT INTO mur_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ijin ni Yesu ɔl o aziirar nɔɔnɔ e enek nɛ, “Mazi yo inoko ma akɔ aku ɛɛti ci mano o, agoonek ɔl nicoko naa?” ");
INSERT INTO mur_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma abɛdɛkɛ niigi Yesu anek nɛ, “Aku koca aruk ɔl ci gɛr noko kadaayitɔ, ma anyek mana ɔl ci abon kiliŋliŋit ka gɔɔn keŋerit ki nɔɔnɔ kaal ci abiirna mana o juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma ajin Yesu nɔɔgɔ anek nɛ, “Ŋaan ekeebit zɔɔz o waragɛ o Joowo azi nɛ, Ma bɛ o abor ɔl o gɔɔn ɛɛnyɛt ceezi biyɛnɛ, ma apɛz kizi gi ci labak, bar bɛ o titiny ɔrɔɔt kujuk biyɛn o enyciinto dook nɛɛn. Ma gi nico agɔɔn Jooi niini alya kizi titiny ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Zin kaduwakuŋ igeet, abuluzu katin niiga baliin o Joowo, ma bar akɔ anyonek ɔl oogi ci atuwe, ma aliŋliŋ juruŋ eeci abornaŋ niiga aneet. ");
INSERT INTO mur_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma ɛɛti ci adir bɛ nici, aduuli yivyiv. Ma ɛɛti ci iinak bɛ nici nɔɔnɔ, uurti kututut.” ");
INSERT INTO mur_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mazi azii alaata o ceez o Joowo kibeen ɔl o Parici zoozok ci aduwa Yesu yabziinta noko, agaac niigi ariik niini nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Orooŋit ni niigi gɔl ci ka kagamti nɔɔnɔ, bar olla bodo otoŋole kɔlɛ ci aromɛ kibeen Yesu o, eeci anyek niigi Yesu kizi nyakaŋan. ");
INSERT INTO mur_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ma uduwak Yesu ɔl zoozok yabziinta bodo anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Abil baliin o Joowo kete. Anyak baale alaan ci agɔɔn dayiin ci ka kiiya kadayit ɔl iitene ci arocin ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma iitene nice itoon gabara ogin kɔɔt kutuya ɔl baal aduwak ka kivitak tiŋkawiin e. Mazi avɔ aduwak gabara nɔɔgɔ molok, bar ujurta niigi, alaŋaan arɔɔŋ kivita. ");
INSERT INTO mur_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bodo aku itoon gabara oogi anek nɛ, “Ɔɔtɔ utuya ɔl baal kawai tiŋkawiin e enektek nɛ, Odotit kaal dook. Kɔtɔdɔŋɔ, ma aaktɛ kaal dook odota. Ivitak zin tiŋkawiin.” ");
INSERT INTO mur_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bar ɔl nica alaŋ arek zinzeeti zɔɔz nico. Bar codoi ŋaatineeŋ akɔ keevin mane cin. Maje oman akɔ ataalinɛ kaal cigin mɛlɛgɛnyai. ");
INSERT INTO mur_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Maje ogɛn agam gabara ci ona itoonnyai o, ma aruk kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Otobor ni alaani nɔŋ giye nico ɔrɔɔt ɛlɛ. Ma itoon takirnya ogin kɔɔt kuruyit ɔl ci ona aruk gabara nicoko o kadaayitɔ, ma atooz kutur dook lai. ");
INSERT INTO mur_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ma vurta otowa gabara ogin bodo, ma aku anek nɛ, “Inoko kaal o tiŋkawiinto dook odotita, bar zin ɔl baal kawa e alaŋaan aganɔ ka kivita ka kadaktɔ. ");
INSERT INTO mur_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Inoko zin ɔɔtɔ utuya ɔl ci olla ajowanu awɔ golowɛ kivita kadaktɔ.” ");
INSERT INTO mur_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Itiŋgazɔ ni gabara ɔɔtɔ uluta ɔl o gɛr kibeen ɔl o abon buk zɛɛ ma abitiz ceez tɔc. ");
INSERT INTO mur_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mazi aku alaani ka kiiya kicin kernok, bar acin eet codoi ŋaatineeŋ calaŋ anyak rumanɛ ci tiŋkawiinto. ");
INSERT INTO mur_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma ajin niini nɔɔnɔ anek nɛ, “Laŋo, mã alaŋ anyei rumanɛ o tiŋkawiinto o, akun zin tɛ ŋina ku?” Bar akɔm ɛɛti nici gi ci abarzek nɔɔnɔ kina. ");
INSERT INTO mur_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Enek ni alaani gabara ogin nɛ, “Agamit eet nico acabit zɔɔ ki azɛɛn ɔɔtɔ ujuktek bitaalin. Alu tedec ŋinaante zɛɛ ma adak nyigit.” ");
INSERT INTO mur_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Izi ni Yesu nɛ, “Abil zin buk baliin o Joowo nɔkɔ. Inoko otoyai ɔl ci meel gɛr, bar zin avu ŋaatineeŋ ci miliny tɛr.” ");
INSERT INTO mur_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ɔtɔɔzɔ ni ɔl o Parici, ma avɔ abaabanit gɔl ci ka kicintai Yesu jinɛnta. ");
INSERT INTO mur_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma avɔ itoonak niigi nɔɔnɔ nuyak ugeec kibeen ɔl o alaan o kazi Erod. Ivita ni ijinit niigi nɔɔnɔ anek nɛ, “Alaan o demziinto, kagaya aduwa gɔɔn niina zoozok ceen didi. Ma ademzei ɔl zɔɔz ween didi o arɔɔŋ Jooi eet ci deer kutugu juruŋ kɔkɔm gi ci aŋole niina ɔla. ");
INSERT INTO mur_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Duwayet zin di. Inoko ŋaatun aganɔ ŋaati karuwɛkɛ meeri alaan o Rom, yo akɔm da?” ");
INSERT INTO mur_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Maje Yesu aga kɛŋ ci jinɛn cineeŋ gɛr o nɔkɔ, ma anek niini nɔɔgɔ nɛ, “Igeet labjok coko! Arooŋnyu icintawaŋ naa? ");
INSERT INTO mur_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Eyeleyaŋ di gurucoc ci ka ɔɔt urukti meeri o.” Anyaaktak ni niigi gurucoc. ");
INSERT INTO mur_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma ajin niini nɔɔgɔ anek nɛ, “Ma zaara ci ayeedi gurucoca ce ki riritɔn co ci ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma abɛdɛkɛ niigi Yesu anek nɛ, “Ŋum o alaan o kazi Sizar ki zaar ogin.” Ma anek Yesu nɔɔgɔ nɛ, “Uruktek zin Sizar kaal o akati nɔɔnɔ, maje Jook uruktek kaal ogin.” ");
INSERT INTO mur_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mazi azii niigi gi ci aduwa Yesu noko, olla apaŋantɛ paŋ, ma ooŋnek nɔɔnɔ looc, ma awɔ. ");
INSERT INTO mur_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma iitene nice ɛlɛ ivitak ɔl o kazi Sajuzi Yesu. Maje gɔɔn niigi alaŋ agama zɔɔz o bodo katin iŋaani ɔl daayiza. ");
INSERT INTO mur_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ivita ni enektek niigi Yesu nɛ, “Alaan o demziinto, azi baale Mosis nɛ, Mã adaai ɛɛti iŋaan kitira dɔl ŋaawe cin, abon arigiz gɔtɔnnya ŋaa ka kitirak nɔɔnɔ dɔl. ");
INSERT INTO mur_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anyak zin baale lɔgɔz ceen gɔtɔn een torgɛrɛm abaak ŋina. Ɔrɔcɔ ni logoti ceen abuu o, ma adaai iŋaan kanyak ŋaa dɔl. Iiya ni gɔtɔnnya o anowa nɔɔnɔ anyawun ŋaa. ");
INSERT INTO mur_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma bodo ŋintimiliny nɔkɔ adaawun buk logoti nici iŋaan kitirak ŋaa nico dɔl. Ma azɔbɔn niigi ŋaa nɔkɔ zɛɛ makacin adaayitɔ niigi dook iŋaan kitirtak ŋaa dɔl. ");
INSERT INTO mur_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ma vurta adaak buk ŋaa. ");
INSERT INTO mur_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Inoko zin tiŋeere mã iŋaaz ɔl daayiza, ŋaa nicini akati ŋɛnɛɛn giye baal anyakti niigi dook ŋaa nico?” ");
INSERT INTO mur_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Abacu niiga zɔɔz nico ɔrɔɔt, eeci alaŋ areku niiga zinzeeti waragɛ o Joowo ki dɔyiz onin. ");
INSERT INTO mur_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Katin ma iŋaaz ɔl daayiza, ɛɛl niigi kiyo toonnyawa o Joowo o. Ma alaŋ bodo eeta ki ŋaai arɔcɔ. ");
INSERT INTO mur_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mazin giye ci akati ŋaazi daayiza, ŋaan niiga ekeebit zɔɔz baal aduwakuŋ Jooi e? ");
INSERT INTO mur_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Azi baale niini nɛ, Keen Jook o Ibrayim ki Aizak been Jakob. Ma zɔɔz nici ayelza gi o inoko arogni Ibrayim ki Aizak been Jakob. Zin Jooi niini Jook ci ɔl ci arogi, alaŋ een Jook ci ɔl ci adaai.” ");
INSERT INTO mur_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mazi azii kɔlɛ gi nico, ibiirit nɔɔgɔ ooti ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Mazi avɔ azii ɔl o Parici ɛtɛza Yesu ɔl o Sajuzi, ivitak niigi dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Icina ni ɛɛti codoi ole o gɔɔn ademzek ɔl lotinok Yesu jinɛnta. ");
INSERT INTO mur_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ma aku ajin niini Yesu anek nɛ, “Alaan o demziinto, mayo lotinɛt jaŋ ci titiny ɔrɔɔt kujuk gɔnɔgi dook.” ");
INSERT INTO mur_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Lotinɛt o azi nɛ, Abon areez Jook ween Manyi unun zinize unun dook, ki rogete unun dook, been baabaninte unun dook. ");
INSERT INTO mur_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lotinɛt zin ci titiny ɔrɔɔt nɛɛn nici. ");
INSERT INTO mur_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bodo lotinɛt oma ci titiny nɛɛn o azi nɛ, Reez ɔl o abaawonu kiyo areez ɛlɛ unun maany o. ");
INSERT INTO mur_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma lotinowa o Mosis been demziin o nyakaŋanetu ano niigi dook lotinok ceen ram noko doon.” ");
INSERT INTO mur_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mazi ŋaan alotɛ ɔl o Parici nɔkɔ, ijin Yesu nɔɔgɔ anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Abaabanu dim inoko niiga aziyu nɛ, Kiristo ŋɛnɛ? Niini ŋɛɛrti ŋɛnɛ?” Ma abɛdɛkɛ niigi Yesu anek nɛ, “Kiristo niini dole ci dɔl o Devid.” ");
INSERT INTO mur_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ma anek niini nɔɔgɔ nɛ, “Mazi een Kiristo dole ci dɔl ci Devid, anyek zin baale Vɔŋizi o Joowo Devid kotowo nɔɔnɔ kizi Manyi cin naa? ");
INSERT INTO mur_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Azi baale Devid nɛ, Anek Jooi Manyi onan Kiristo nɛ, Aavu libire can azo o zɛɛ ma kanyin rocek modo ugun amarninin ineet looc zɔɔnɛ. ");
INSERT INTO mur_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mazi awo Devid Kiristo kizi Manyi o, alaŋ aganɔ ŋaati ɛɛnɛ dole ci dɔl ci Devid doon, bar aku niini Joowa.” ");
INSERT INTO mur_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mazi azi Yesu nɔkɔ, ajaktɔ niigi dook tiv, kɔkɔm gi ci abariz. Zin iitene nice ɔkɔma bodo eet ci anim kijin nɔɔnɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Enek ni Yesu kɔlɛ ki nuyak ogin nɛ, ");
INSERT INTO mur_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ɔl o demziinto kibeen ɔl o Parici irigizit niigi zɔɔ o Mosis ka koobtek ɔl lotinok. ");
INSERT INTO mur_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Abon zin aziiŋnu niiga nɔɔgɔ, ma anuyu kaal o aduwakuŋ niigi igeet dook. Bar zin má agoonu kaal ci agɔɔn niigi o, eeci kaal ci agɔɔn niigi o aŋɔrɔwɔ kibeen kaal o ademzek niigi ɔl. ");
INSERT INTO mur_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Adaŋekuŋ gɔɔn niigi igeet utuguz kaal ci adɔi kak, maje bar niigi alya alaŋ buk ataman kuzuuti. ");
INSERT INTO mur_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Agɔɔn niigi kaal dook gole ci ka keyeliztai eleeti ɔla. Aborcek gɔɔn niigi kaal ci ayeedonek zoozowa o Joowo ŋumti kibeen azɛɛn ka kicinit ɔl. Ma buk aborcek rumanɛ ci wuntik alina ka kiziti ɔl nɛ, Niigi ɔl ci Joowo. ");
INSERT INTO mur_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Arɛɛz gɔɔn niigi aavuzit ci aavtiye lecerene ci abon ŋaati alotɛn ɔl. Ma arɛɛz buk lɛcɛrɛ o abon ceezine o lotento. ");
INSERT INTO mur_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Arɛɛz niigi buk ŋaati azaawi ɔl nɔɔgɔ diŋdiŋaninta ɔl kɔrgɛna. Ma arɔɔŋ niigi kotoweec ɔl nɔɔgɔ kiziti alaat ci demziinto. ");
INSERT INTO mur_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Alaŋ zin aganɔ ŋaati awuyuŋ ɔl igeet iziti alaat ci demziinto, eeci niiga dook eeginu gɔtɔn. Ma anyaku niiga dook alaan unooŋ demziinto adɔi ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Alaŋ zin buk abon ŋaati awoyu niiga eet ci deer loota ŋina kizi baatunooŋ, eeci anyaku niiga dook baatunooŋ o adoi ṯɔr nɔkɔ tammu tadena. ");
INSERT INTO mur_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Má anyeku buk kutuyuŋ ɔl igeet iziti alaat, eeci alaan unooŋ igeet dook nɛɛn Kiristo doon. ");
INSERT INTO mur_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma ɛɛti ci titiny ŋaatunooŋ abon aliŋliŋonekuŋ niini igeet kizi gabaren. ");
INSERT INTO mur_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ɛɛti ci gɔɔn adɔŋ ɛlɛ, tiŋeere acɛlbɛzɛni. Maje ɛɛti ci acɛlbɛzɛn ɛlɛ, adoŋnyi katin niini kidiŋdiŋ.” ");
INSERT INTO mur_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ma anek Yesu ɔl o Parici nɛ, “Izi nɔŋa wole ŋaatunooŋ igeet alaat o demziinto kibeen ɔl o Parici! Abuuku gɔɔn niiga eleeti. Unyuuktu niiga gɔl o baliin o Joowo ɔl ŋuma. Ma alaŋ anyeku ɔl o arɔɔŋ kɔɔt baliinte o Joowo kɔɔt eecitɔ. Zin buk tiŋeere niiga alya alaŋ avoyu baliinte o Joowo eecitɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Izi nɔŋa wole ŋaatunooŋ igeet alaat o demziinto kibeen ɔl o Parici! Abuuku gɔɔn niiga eleeti! Abaayizu gɔɔn liilok, ma azobju loocok ka ɔɔtɔ anycek eet codoi ṯɔr nɔkɔ kono lotinok ugooc. Ma vurta bar bodo uwuyu eet nico ɛlɛ kagantɔ ki goo o Loryento kiyo buk niiga o. ");
INSERT INTO mur_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Izi nɔŋa wole ŋaatunooŋ igeet alaat ci ruben noko! Ademezu gɔɔn niiga ɔl aneku nɛ, Mã itoon ɛɛti zaar o ceez o Joowo, zɔɔz cinɛ o gi ci labak. Mazi bar itoon niini zaar o warki o ɛɛl ceeze o Joowo, zɔɔz cinɛ o een didi. ");
INSERT INTO mur_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Igeet aliyak ci ruben coko! Adiŋdiŋ yo ɔrɔɔt gi jaŋ? Warkina yo ceez da o Joowo o anyek warki nicoko kililec? ");
INSERT INTO mur_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ademezu buk gɔɔn niiga ɔl aneku nɛ, Mã itoon ɛɛti zaar ci ŋino taabinto, alaŋ zɔɔz cinɛ o een didi. Bar mazi itoon ɛɛti zaar ci kaal o ataabi ɔl Jook, anyeku zɔɔz cino kizi didi. ");
INSERT INTO mur_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Eeginu zin niiga rubenɛ ɔrɔɔt! Mayo adiŋdiŋ ɔrɔɔt gi jaŋ? Adiŋdiŋ kaal o kataabi Jook, yo da ŋino taabinto o anyek kaal nico kililec? ");
INSERT INTO mur_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Zin mã itoon ɛɛti ŋino taabinto, itoon niini nɔɔnɔ ki kaal o taabinto ɛɛl ŋinaante dook. ");
INSERT INTO mur_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mã itoon ɛɛti ceez o Joowo, itoon niini nɔɔnɔ ki Jook o abaak ŋinaante buk. ");
INSERT INTO mur_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mã itoon ɛɛti tammu tadena, itoon niini lɛcɛr o Joowo kibeen Jook ɛlɛ o aavɛ lecere nico. ");
INSERT INTO mur_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Izi nɔŋa wole ŋaatunooŋ alaat o demziinto kibeen ɔl o Parici! Abuuku gɔɔn niiga eleeti! Anyeku gɔɔn niiga Jook lɛlɛn codoi lelene ween amɔtɔ, mayo nuun een tambu karabɔŋ een barabarac. Ma bar aburnu ŋaati azuunu lotinok o titiny kiyo payiin ci waan apaku zoozok keelit tɔp, ki ziniz bonat ɔla, been ziniz laliz. Abon waan zin niiga aliŋliŋnyu kaal ci titiny noko dook kibeen buk kaal oogi. ");
INSERT INTO mur_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Igeet alaat ci ruben coko! Aaranu gɔɔn niiga kiroŋit iiranɛ, maje bar nyakale akuuyu labak. ");
INSERT INTO mur_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Izi nɔŋa wole ŋaatunooŋ igeet alaat o demziinto kibeen ɔl o Parici! Abuuku gɔɔn niiga eleeti! Aricanu gɔɔn niiga gi ci uunyu kodoocɛ ugooc bawuci juruŋ. Maje bar keŋti eecitɔ abiz kaala o aamanu ɔl dɔyiza been zinzeeti appinzete unooŋ areezu eleeti. ");
INSERT INTO mur_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Igeet ɔl ci Parici rubenik coko! Otoonyca rak ririny ci ɛɛl kodooc kɛŋa o dook lai, ka zin buk kitiliza kodooc bawuc. ");
INSERT INTO mur_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Izi nɔŋa wole ŋaatunooŋ igeet alaat o demziinto ki ɔl o Parici! Abuuku gɔɔn niiga eleeti! Eelnu niiga kiyo looknya o adawi ɔl miniŋ gɔɔn alina eci bitaalu doon, maje bar eecitɔ abiz amɛ ci ame tɔc o. ");
INSERT INTO mur_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Zin buk gole nico niiga abuuku eleeti. Alinanu bitaala doon, maje zinzeetinɛ eecitɔ arooŋnyu utuguz kaal ci gɛr. ");
INSERT INTO mur_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Izi nɔŋa wole ŋaatunooŋ igeet alaat o demziinto ki ɔl o Parici! Abuuku gɔɔn niiga eleeti! Agoonu gɔɔn niiga looknya baal adawin nyakaŋanɛta e kitiliza, eeci atitinyu nɔɔgɔ. Ma adimanu buk looknya o adawin ɔl baal abaak baayiz o abon e kitiliza. ");
INSERT INTO mur_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma aniyu niiga vɔlɔŋa nɛ, Mã da kaavtiya naaga tɔ oowe baal jijitigaacak e, alaŋ waan karuka nyakaŋanɛt kadaayitɔ kiyo baale niigi e. ");
INSERT INTO mur_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Zin giye nico agayu gi o eeginu niiga didi dɔl ci dɔl ci ɔl baal amony nyakaŋanɛt e. ");
INSERT INTO mur_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Inoko zin ɔɔtɔ uruktaŋ kadaak gole ci baal akata jijitugooc laadun o. ");
INSERT INTO mur_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Igeet dɔl ci kokonyawu coko! Ka dim yo tiŋeere orogit gooye o abil been nɛɛn ku? ");
INSERT INTO mur_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Inoko tiŋeere kitoonakuŋ naana igeet nyakaŋanɛt, ki ɔl ci gɛnyizo, been alaat ci demziinto. Bar zin tiŋeere aruku niiga oogi ŋaatineeŋ kadaayitɔ. Ma adodoyu oogi keete ween talakec. Ma arooku oogi ceezine o lotento. Ma atooku oogi kuturyowe dook. ");
INSERT INTO mur_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Zin giye nico iinakuŋ tiŋeere igeet biyeta ci ɔl abon baal amony ɔl gaga nɔkɔ e dook igeet. Akanai biyete o Abel zɛɛ been biye o Zakeriya ween ŋɛɛrti Biraca baal amonyu ŋaao aŋɛrɔn ceez o Joowo been ŋino taabinto e. ");
INSERT INTO mur_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Didilɛ kaduwakuŋ igeet, payiin ci kaal ci baal gɛr agooni neke dook iinakuŋ katin igeet, eeci buk niiga agoonu kaal niceke ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma azi Yesu nɛ, “Jerusalɛm, Jerusalɛm, uruwu niina nyakaŋanɛt kadaayitɔ, ma avacu buk ɔl o itoonakin Jooi ineet biyɛnɛ kadaayitɔ. Lak ci mɛɛlɛ gɛr ci karɔɔŋɛ gɔɔn kanyabotai ɔl ugun kiyo gɔɔn alotek toloci jɔrɔ ogin kɛŋ o, bar zin niina ŋaan nyan kutugu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Inoko zin tiŋeere ceez cune noko ooŋnonek looc kizi lik. ");
INSERT INTO mur_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Inoko zin kaduwakuŋ igeet, akatai waanico alaŋ bai bodo acinaŋ aneet zɛɛ been iiten ci kabadanɛ e. Enice ŋaan aziyu nɛ, Amayuk Jooi nɔɔnɔ o aku zaare ogin.” ");
INSERT INTO mur_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Mazi aduŋna Yesu ceeze o Joowo, ivitak nɔɔnɔ nuyawa oginɛ arɔɔŋ ka keyeltek nɔɔnɔ linat o ceez o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ma anek niini nɔɔgɔ nɛ, “Acinu yo kaal nicoko dook juruŋ? Kaduwakuŋ didilɛ, akɔm tiŋeere tegereme ci ceez nico noko codoi ataadonek gɔɔn taden. Alibi tiŋeere niigi dook lai.” ");
INSERT INTO mur_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Mazi akɔ aavi Yesu loota biye o kazi Kiŋiroc, ivitak nuyawa nɔɔnɔ doon ŋinaante. Ma avu ajin anek nɛ, “Duwayet di. Ma kaala nici dook akanai tiŋa? Tiŋeere ma ka ija, akanai gitaz ci ka kagaya badaan unun kibeen dican o loocu?” ");
INSERT INTO mur_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Egenyit juruŋ ka kɔkɔm eet ci alabanuŋ. ");
INSERT INTO mur_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Eeci tiŋeere avu ɔl ci meelik zaare ogan, ma avu azi nɛ, Aneeta Kiristo nɛɛn. Ma alaba tiŋeere niigi ɔl ci meelik. ");
INSERT INTO mur_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aziiŋnu tiŋeere oroonok ci ajɔn, ma aziiŋnu kaviyak ci oroonok ci rɛɛn. Bar zin má rak anyeku zinzeeti kotoŋole looc kaale nicoko, eeci kaal nicigi ŋɛdɛt iina. Alaŋ zin bar ayelza iiten ci aṯornɛkɛ e ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Katin gɔɔn lɔɔci ce ɔɔrɔ ki looc co. Ma anyak katin tarjo ki looc mɔɔtiz vitɛnane ci meelik gɛr. ");
INSERT INTO mur_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma kaal nicigi dook olla ɛɛl kiyo wucezi o gɔɔn rak aami ŋaa dole o. ");
INSERT INTO mur_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Zin tiŋeere iinyaye niceke acabjuŋ ɔl igeet, ma agiduŋ, ma apayekuŋ daayiz. Ma amarninuŋ tiŋeere ɔl dook igeet, eeci atuyaŋ niiga aneet. ");
INSERT INTO mur_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Tiŋeere iinyaye niceke ɔl ci meelik amiiri ki vurut tuwente uneeŋ. Akat tiŋeere ɔl ci amiiri ki vurut o gɔnɔgi o ŋaan atuwe vɔlɔŋa, ma amarnin niigi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Zin tiŋeere iinyaye niceke avu nyakaŋanɛta ci voloŋo meelik, ma avu alaba ɔl ci meel. ");
INSERT INTO mur_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma giye o tiŋeere appeni gerzitin ɔrɔɔt, alaŋ tiŋeere ɔl ci meel arɛɛzɔ. ");
INSERT INTO mur_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bar zin ɛɛti ci amɛna amɛz kaal nicoko dook zɛɛ ma aṯornɛkɛ, arogzɛ tiŋeere niini. ");
INSERT INTO mur_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Maje zin tiŋeere kaviyawa o abon akati baliin o Joowo uuwawonek rak loocok dook zɛɛ ma azii modɛna dook. Mazi odot, kiiya ni. ");
INSERT INTO mur_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Acinu katin gi o gɛr ɔrɔɔt baal aduwa nyakaŋani o kazi Danyel e. Acinu tiŋeere nɔɔnɔ abil ŋaao Joowo taabinto. (Abon zin aziiŋnu gi nico juruŋ.) ");
INSERT INTO mur_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Zin ɔl o abaak Judiya iinya niceke abon avir avɔ biyɛnɛ. ");
INSERT INTO mur_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mã aavi ɛɛti raa, abon avir enice. Akɔm bodo nɔɔnɔ waŋi ci ka kooyi ceeza tɔ ka kook kaara kaal ogin. ");
INSERT INTO mur_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mã aavi ɛɛti mana, abon avir enice. Akɔm bodo waŋi ci ka kimiirozɛkɛ niini kɔrɔk ka kook kodoma rum onin. ");
INSERT INTO mur_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nɔŋ ci kol tiŋeere ŋaane o anyake kibeen o arɔkti. ");
INSERT INTO mur_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ijinit zin Jook ka calaŋ aviryu lɔɔlɔ, karabɔŋ een iitene o yubzento. ");
INSERT INTO mur_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Eeci kinatamma laadun e zɛɛ been waanico noko akɔm piryakzɛt ci atobɔ kibeen ci katin aku neke. Ma akɔm bodo ci atobɔ ki nice katin been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Bar zin anyewun Jooi iinya niceke kizi kidicɛ. Ma da calaŋ agɔɔn nɔkɔ, akɔm koca eet ci arogi been nɛɛn. Anyek zin niini iinya niceke kizi kidicɛ giye ci akati ɔl o ɛŋɛra niini. ");
INSERT INTO mur_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Zin iinyaye niceke mã anyak eet ci anekuŋ nɛ, Icinit di Kiristo ceeni ŋaato, karabɔŋ azi nɛ, Kiristo caana ŋaate, má aziiŋnu nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eeci avu tiŋeere ɔl ci azi nɛ, Keegina Kiristo, kibeen nyakaŋanɛt ci voloŋo meelik. Agɔɔn katin niigi kaal ci atɛɛt ɔl biye, ka katamanti gɔl ci alaban ɔl o ɛŋɛra Jooi. ");
INSERT INTO mur_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iziiktɔ zin! Inoko kuduwayuŋ naana igeet gi nico iŋaan kaal nici kakatai o. ");
INSERT INTO mur_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mã anekuŋ katin ɔl nɛ, Aavi Kiristo baza, má avoyu ŋinaante been nɛɛn. Mã azi nɛ, Aroodi Kiristo ŋaato, má aziiŋnu nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Eeci naana Ŋɛɛrti Eeto kakun tiŋeere keyelizai kiyo bɔrɔyɛ o gɔɔn abadi tammu kɛŋa kicinit ɔl dook eci jenu been eci nyagjo o. ");
INSERT INTO mur_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Zin gɔɔn laadun mã alotɛ kuduvaana ŋaaman, anyak gi ci adaai tɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Bodo ŋintimiliny nɔkɔ mazi odotit kaal ci gɛrzɛ iina noko, ookci ii kizi koli, maje nyɛlɔyi alaŋ bodo ataran looc, maje monyonya iina tammu tadena. Buk kaala o ɛɛl tammu bɔbɔra amɔɔt, ma ookci. ");
INSERT INTO mur_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Zin enice ŋaan ayelzai kuni onane aneet Ŋɛɛrti Eeto tammu tadena. Ma aboobi tiŋeere modɛna dook loota ŋina, ma acinan aneeta Ŋɛɛrti Eeto kawoya diizwani dɔyize ci appe been diŋdiŋɔnta. ");
INSERT INTO mur_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Abɛɛ tiŋeere toromba ci agɛrɛny, ma kitoonai naana Ŋɛɛrti Eeto toonnyak ogan looc, ka kivita kuluta ɔl o aŋɛryai loocowe dook.” ");
INSERT INTO mur_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ma azi Yesu bodo nɛ, “Agaac zɔɔz nico keete ween moneec. Gɔɔn mã acinu itilizit oto artek bɔlɔk, agayu nɔkɔ izi lɔlɔŋumi ajɔn. ");
INSERT INTO mur_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Zin buk gole ci atobɔ ki nico, mã icintu kaal nicoko dook, agaac izi iiten o ka kiiyai ajɔn. ");
INSERT INTO mur_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Didilɛ kaduwakuŋ igeet, ma ɔl o gɔɔn amɛz piryakzɛt acin tiŋeere niigi kaal nicoko dook. ");
INSERT INTO mur_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Katin tammu taden ki tɔdɔ aṯornɛkɛ. Maje bar zɔɔz onane abil nɔkɔ kodot.” ");
INSERT INTO mur_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma azi Yesu bodo nɛ, “Akɔm eet ci agawa iiten ci kakunɛ naana e kina. Alaŋ toonnyawa o tammo aga, ma alaŋ buk naana alya Ŋɛɛrti Eeto kaga, bar aga baaba doon. ");
INSERT INTO mur_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Katin kuni onane aneet Ŋɛɛrti Eeto akanai kibiirit ɔl ooti kiyo gi baal iina irkite o jijitinai o kazi Nowa e. ");
INSERT INTO mur_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Waanice iŋaan kiiya tawani e, adake ɔl, ma awodɛ, ma aroce ɔl labak zɛɛ been iiten baal akɔyi Nowa kavoola e. ");
INSERT INTO mur_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Alaŋ waanice aga niigi nɔŋ ci kɔl ka baale kiiyak nɔɔgɔ neke zɛɛ makacin iiya otodot tawani nɔɔgɔ dook lai. Zin iiteni ci kakunɛ naana Ŋɛɛrti Eeto e abil nɔkɔ ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Iitene nice mã eevyi ɔl ceen ram mana, aŋɛryai codoi, ma ooŋnonek codoi looc. ");
INSERT INTO mur_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mã areke ŋaai ceen ram golwa, aŋɛryai codoi, ma ooŋnonek codoi looc. ");
INSERT INTO mur_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Egenyit zin! Otomta eleeti juruŋ, eeci alaŋ agawanu iiten ci kakunɛ naana Manyi. ");
INSERT INTO mur_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Abon agayu gi ce. Inoko gɔɔn kizi gi ci agawa ɛɛti iiten ci ka kiiyakɛ agoryaiti ceez onin, acinɛ koca calaŋ ɔɔŋ ka calaŋ anyek agoryai waŋi ci aku agorzin. ");
INSERT INTO mur_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Abon zin buk niiga eelnu nɔkɔ. Iziti vililɛ tup, eeci kakun naana tiŋeere Ŋɛɛrti Eeto iitene calaŋ agawanu.” ");
INSERT INTO mur_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma azi Yesu bodo nɛ, “Gabaren jaŋ yo ci abon aliŋliŋonek alaan onin juruŋ? Gabaren ci abon nɛɛn o anyek alaani oninɛ nɔɔnɔ kabal gabara o miliny dook ka gɔɔn keŋerek niini nɔɔgɔ dayiin ugeec juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ajowa zin tiŋeere gabarɛnti nici vɔyit ci liŋliŋɔn onin iitene ci abadaan alaani oninɛ, ma ajowa nɔɔnɔ agɔɔn liŋliŋɔn juruŋ kibil ebaal aduwakɛ niini nɔɔnɔ e. ");
INSERT INTO mur_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Didilɛ kaduwakuŋ igeet, mã agɔɔn nɔkɔ, anyek koca alaani nici kaal ogin dook kagam gabarɛnti nici. ");
INSERT INTO mur_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bar mazi een gabarɛnti nici eet ci gɛr, anek koca ɛlɛ maany nɛ, Alaŋ tiŋeere alaani cane o abada kataman. ");
INSERT INTO mur_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma arɔɔk gɔnɔgi ci miliny o, ma adake niini labak, ma awot nyaantanɛ kibeen ɔl o abaaki. ");
INSERT INTO mur_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mazi abada tiŋeere alaani ci gabaren nico o iitene calaŋ niini agawan. ");
INSERT INTO mur_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aku aruk niini gabaren nico ɔrɔɔt ɛlɛ, ma apayek nɔɔnɔ gerzitin, eeci alaŋ agɔɔn liŋliŋɔn o anyonek nɔɔnɔ juruŋ. Akɔ zin tiŋeere niini ŋaati akɔ aluwi zɛɛ ma adak nyigit.” ");
INSERT INTO mur_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma azi Yesu bodo nɛ, “Abil baliin o Joowa kete. Anyak baale dɔl ceen amɔtɔ adoma lambɛt cigeec, ma aduŋna avɔ bitaala ka kɔɔt kurumtek eet ci rociinto gɔl. ");
INSERT INTO mur_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma dolene nicoko ceen tur ŋaatineeŋ tarbalɛ, maje bodo ceen tur agɛny ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Adoma dɔlya ceen tur tarbalik o avɔyi lambɛt kɔkɔm maal oma ci anyayek. ");
INSERT INTO mur_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Maje dɔlya ci agɛny o avɔyi lambɛt ugeec kibeen bodo maaltanɛ oogi burwɛtɛ. ");
INSERT INTO mur_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Bar ɛɛti ci rociinto o alaŋaan aku taman, ma arɛ dɔlya nɔɔnɔ ŋinti rɛɛn zɛɛ makacin ataŋguzɔ. ");
INSERT INTO mur_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ma baalin kɛŋa ɛgɛrɛny ɛɛti oman azi nɛ, “Eet o rociinto e ce. Ivita urumtek gɔl.” ");
INSERT INTO mur_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ma iŋaaz dɔlya dook amɔta, ma apɛrpɛran lambɛt ugeecik e juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma anek dɔlya ci tarbal o gɔnɔgi ci agɛny o nɛ, “Anycetu da maaltanɛ ci miliny. Idicai maaltanɛ lambete cigaacak o.” ");
INSERT INTO mur_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ma abɛdɛkɛ dɔlya ci agɛny o nɔɔgɔ anek nɛ, “Izi buk maaltanɛ ci kanyaka o kidicɛ tɛr. Alaŋ kalɛɛnɔ ki ageet dook. Odokonyit ɔɔtɔ ataalta mɛlɛgɛnyai kataman.” ");
INSERT INTO mur_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Odokonyit ni didi dɔlya ci ona tarbal noko ka kɔɔt kataala maaltanɛ. Mazi avɔ niigi mɛlɛgɛnyai, urum ɛɛti o rociinto e looc. Iiya ni orkorit niini kibeen dɔl ween tur agɛny e ɔɔtɔ ceeze o tiŋkawiinto, ma anyook karogi. ");
INSERT INTO mur_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma vurta ivita dɔlya o tarbal e. Ma avu aruk karogi azi nɛ, “Manyi, manyi, koleyet da ceez koota eecitɔ.” ");
INSERT INTO mur_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bar abɛdɛkɛ ɛɛti ci rociinto o nɔɔgɔ anek nɛ, “Aavtiz bitaala ŋinaante. Alaŋ kagayuŋ naana igeet.” ");
INSERT INTO mur_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Izi ni Yesu nɛ, “Egenyit zin, eeci alaŋ agayu iiten karabɔŋ een ziit ci kakunɛ.” ");
INSERT INTO mur_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ma azi Yesu bodo nɛ, “Ma baliin o Joowo abil kete. Anyak baale eet ci arɔɔŋ kɛɛrɔn. Mazi ka kɔɔtɔ, otowa gabara ogin, ma aku aduwak nɔɔgɔ kuzuuti kaal ogin dook juruŋ. ");
INSERT INTO mur_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma anyek gɔɔn co ŋaatineeŋ liŋliŋɔn ci aganɔ ki nɔɔnɔ. Anyek eet co guruc ceen 5000. Ma anyek bodo eet co guruc ceen 2000. Ma anyek bodo eet co guruc ceen 1000. Ɔtɔɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Odoma gabarɛnti o anyonek nɔɔnɔ guruca ween 5000 e, ook iliŋliŋi guruc nicoko zɛɛ makacin bodo anyaa guruc ceen 5000 oogi bodo. ");
INSERT INTO mur_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bodo buk gabarɛnti o anyonek nɔɔnɔ guruca ween 2000 e, ook iliŋliŋi guruc nicoko zɛɛ makacin bodo anyaa guruc ceen 2000 oogi. ");
INSERT INTO mur_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Maje gabarɛnti o anyonek nɔɔnɔ guruca ween 1000 e, ook adawek guruc nicoko looc itaŋa. ");
INSERT INTO mur_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ma irkitowe ogɛn abada alaani uneeŋ ka kiiya kigiilit ki nɔɔgɔ guruc ogin baal anyek nɔɔgɔ e. ");
INSERT INTO mur_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mazi avɔ agiil guruc, anyaak gabarɛnti baal anyonek guruca ween 5000 e alaan guruc oogi ceen bodo ni 5000, ma aku anek nɔɔnɔ nɛ, “Anyan baale guruc ceen 5000. Inoko zin kiliŋliŋa guruc oogi ceen 5000 bodo.” ");
INSERT INTO mur_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ma anek alaani nɔɔnɔ nɛ, “Abon ɔrɔɔt ɛlɛ. Een niina gabaren ci abonanin ziniz. Aliŋliŋ juruŋ. Zin giye o aliŋliŋɛ guruc baal miliny e juruŋ, ŋaan kanyin ineet guruc ci meel bodo ka liŋliŋi. Inoko ija ka kozolit ki ineet talniin can o.” ");
INSERT INTO mur_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ma aku bodo gabarɛnti baal anyonek nɔɔnɔ guruca ween 2000 e, ma aku anek alaan nɛ, “Anyan baale guruc ceen 2000. Inoko zin guruc oogi ceen 2000 kiliŋliŋa ce.” ");
INSERT INTO mur_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ma anek alaani nɔɔnɔ nɛ, “Abon ɔrɔɔt ɛlɛ. Een gabaren ci abonanin ziniz. Aliŋliŋ juruŋ. Zin giye o aliŋliŋɛ guruc baal miliny e juruŋ, ŋaan kanyin ineet guruc ci meel bodo ka liŋliŋi. Inoko ija ka kozolit kibeen ineet talniin can o.” ");
INSERT INTO mur_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Iiya ni bodo gabarɛnti baal anyonek guruca ween 1000 e. Ma aku anek alaan nɛ, “Manygɔn, Kagayin naana ineet een eet ci gɔɔn adoknin aziiti, ma ateedi niina kaal ci ɛɛva ɔl ogɛn. ");
INSERT INTO mur_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kotoŋolewin zin, ma kakɔ karoodi guruc baal anyan e kadawei looc. Orɛ zin nɔɔgɔ ce.” ");
INSERT INTO mur_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Ma abɛdɛkɛ alaani nɔɔnɔ anek nɛ, “Een niina gabaren ci gɛr ɔrɔɔt, ma adaaŋnin buk ɛlɛ ɔrɔɔt. Mã da agayan niina aneet kateedi gɔɔn kaal ci ɛɛva ɔl ogɛn, abon waan zin aliŋliŋɛ guruc cigan o labak ka kojowa bodo azaace.” ");
INSERT INTO mur_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ma anek alaani gabara ogin nɛ, “Aamta guruc nicoko ŋaatin, ɔɔtɔ anycek gabaren ona anyak guruc ween 5000 e. ");
INSERT INTO mur_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eeci mã anyak ɛɛti kaal ci meel gɛr, anyonek bar bodo nɔɔnɔ ci meelik ɔrɔɔt. Maje ɛɛti ci anyak kaal ci miliny tɛr, aamnyai bar ŋaatin nici kavɔ nɔkɔ dook. ");
INSERT INTO mur_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Inoko zin gabaren ci gɛr noko ujuktek nɔɔnɔ bitaalin muur ŋinaante, ka kook kutulu ŋinaante zɛɛ ma adak nyigit.” ");
INSERT INTO mur_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ma azi Yesu bodo nɛ, “Iiten ci kabadanɛ naana Ŋɛɛrti Eeto ki toonnyak ogan titinyonte onan, kaku kaavi lecere onan alaazetu. ");
INSERT INTO mur_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma alotakan katin ɔl o loocu dook aneeta. Ma kaku kaŋer nɔɔgɔ dook lɛlɛn ram kiyo gɔɔn aŋɛra ɛɛti o ɛɛzawu aza bawɔnɛ o. ");
INSERT INTO mur_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kari zin tiŋeere ɔl o atuyan aneet libir onan azo. Ma kari ɔl o alaŋ atuyan aneet kaŋeta. ");
INSERT INTO mur_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ma tiŋeere kanei naana alaani ɔl ci ona aavtiz aneet libire ci azo o nɛ, “Ivitak niiga o amayukuŋ baaba baliin onin baal agɔɔnakuŋ niini igeet laadun kinatamma e. ");
INSERT INTO mur_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Baale adakan magiz, ma anyaŋ dayiin. Baale arukan kɔr, ma anyaŋ maam kowodɛ. Baale keen kernoi, ma atalnanaŋ korogjowe ugooc. ");
INSERT INTO mur_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Baale kawɔ ŋaḏinyiny, ma anyaŋ rumanɛ. Baale kamoor, ma atiritaŋ. Baale kacabje, ma avu gɔɔn acinaŋ.” ");
INSERT INTO mur_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Zin katin ɔl ci ona abon noko abɛdɛkan niigi aneet azi nɛ, “Manyi, ma da kacinin adakin magiz, ma kanyin dayiin waŋa? Ma da kacinin arukin kɔr, ma kanyin maam waŋa? ");
INSERT INTO mur_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma da kacinin eeron, ma katalnanin korogjowɛ waŋa? Ma da kacinin awɔ ŋaḏinyiny, ma kanyin rumanɛ waŋa? ");
INSERT INTO mur_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma da buk kacinin amoor karabɔŋ acabje, ma kavɔ kacinin waŋa?” ");
INSERT INTO mur_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kabɛdɛkɛ zin tiŋeere naana alaani nɔɔgɔ kanei nɛ, “Didilɛ kaduwakuŋ igeet, ma kaal o gɔɔn abon agooneku niiga gɔtɔnɔga cigan cɛlbɛz noko, bar agoonekaŋ niiga aneeta.” ");
INSERT INTO mur_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kookconei zin katin naana alaani ɔl o ɛɛl aneeta kaŋeta e, ma kanei nɛ, “Ɛnyɛktɛ ɔtɔɔz ŋaatan ŋina niiga ci apayekuŋ Jooi gerzitin o. Ɔɔtɔ gooye o abil been nɛɛn baal agɔɔnnyak Loryen kibeen toonnyak ogin e. ");
INSERT INTO mur_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Baale adakan magiz, ma alaŋ anyaŋ dayiin. Baale arukan kɔr, ma alaŋ anyaŋ maam kowodɛ. ");
INSERT INTO mur_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Baale keen kernoi, ma bar alaŋ atalnanaŋ korogjowe ugooc. Baale kawɔ ŋaḏinyiny, ma alaŋ anyaŋ rumanɛ. Baale kamoor, ma kacabje, ma alaŋ avu atiritaŋ.” ");
INSERT INTO mur_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Abɛdɛkan zin tiŋeere niigi aneet azi nɛ, “Manyi, ma da kacinin adakin magiz, karabɔŋ arukin kɔr, karabɔŋ een kernoi, karabɔŋ awɔ ŋaḏinyiny, karabɔŋ amoor, karabɔŋ acabje sijina, ma alaŋ katiritin waŋa?” ");
INSERT INTO mur_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kabɛdɛkɛ zin tiŋeere naana alaani nɔɔgɔ kanei nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti o gɔɔn alaŋ atirit eet codoi ole ci cɛlbɛz noko, alaŋ atiritan niini aneet.” ");
INSERT INTO mur_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Zin tiŋeere ɔl nicoko apawonek nɔɔgɔ goo o abil been nɛɛn. Maje ɔl o abon avɔ niigi rogete o abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mazi adica Yesu demziin ci kaal nicoko dook, enek nuyak ogin nɛ, ");
INSERT INTO mur_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Agayu niiga tiŋeere ece iiten o Juz gɔɔn aadanɛ vardaŋinɛt. Zin iitene nice naana Ŋɛɛrti Eeto kakɔ kanyononei ɔl o ka kɔɔt kotodoyan aneet keete ween talakec.” ");
INSERT INTO mur_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ivitak ni alaata o ceez o Joowo kibeen alaat o Juz kɔrɔk o Kayavas ween alaan o adikir ceeze o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma avu abaaban niigi gɔl ci ka kagamti Yesu gɛnyiza, kɔkɔm eet ci aga, ka kɔɔt kuruyit nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma anɔ nɛ, “Alaŋ abon ŋaati kagɔɔni gi nico iinyaye ci vardaŋinto o, gɛrzɛ ŋaan ayoket ɔl ageet.” ");
INSERT INTO mur_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma iitene oman aavi Yesu ole o eet o kazi Saiman baal amɔɔr mɔɔriz o gidaŋ e Bezaniya. ");
INSERT INTO mur_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mazi ŋaan adake nɔkɔ, iiyak nɔɔnɔ ŋaa ci anyaa ketezewoc ci abiz karacoc ci ataala guruce ci meelik ɔrɔɔt. Ma aku atitiny niini Yesu ŋaati aḏuutɛkɛ nɔɔnɔ karacoc nico nɔɔnɔ ɔɔ. ");
INSERT INTO mur_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Mazi acin nuyawa gi ci agɔɔn ŋaa nici noko, otoborit niigi nɔŋ. Ma aŋɔmtɔ anɔ nɛ, “Ma laadun ŋaa nici aminaŋi karacoc nico gaga naa? ");
INSERT INTO mur_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Alaŋ abon waan bar ataalanɛ karacoc nico guruc ci meelik ka kanyozek guruca ɔl o amaat?” ");
INSERT INTO mur_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Maje Yesu aga gi ci azɔɔz niigi noko nɔkɔ, ma anek nɔɔgɔ nɛ, “Aŋomotu dim ŋaa nico naa? Ma gi ci agoonekan niini aneet noko gi ci abon ɔrɔɔt ɛlɛ ŋaatan. ");
INSERT INTO mur_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma ɔl ci amaat o ŋaan aromenu tiŋeere niiga ki nɔɔgɔ ŋina iinya dook. Maje naana alaŋ bodo karomɛ ki igeet tiŋeere tup. ");
INSERT INTO mur_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aḏuutekan niini karacoc o adimanan niini aneet ka kɛrɛwa dawiin. ");
INSERT INTO mur_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Inoko zin anycaŋ kuduwayuŋ gi ce. Tiŋeere gɔɔn ma akɔ uuwaki kaviyawa o Joowo loocowɛ dook, aadjai buk gi ci ona agɔɔn ŋaa nicini noko.” ");
INSERT INTO mur_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ɔɔtɔ ni Judaz Iskariyot ween nuyai codoi nuyawe ween amɔtɔ ram ook alaate o ceez o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma akɔ anek nɔɔgɔ nɛ, “Mã kayelekuŋ gɔl ci agamnyu Yesu, anyaŋ koca naa?” Anycek ni niigi nɔɔnɔ guruc ceen eetom kamɔtɔ. ");
INSERT INTO mur_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Akata ni Judaz iinyaye niceke orooŋun gɔl ci ka kɛyɛlɛkɛ nɔɔgɔ Yesu. ");
INSERT INTO mur_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma iitene o akanan lotɛn o vardaŋinto gɔɔn adayi ɔl ḏɔkɛn o alaŋ amokcar, ivitak nuyawa Yesu, ma avu anek nɛ, “Mayo arooŋnyet koota kutuguzeyin dayiin ci vardaŋinto ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Anyak eet oma kutura ŋinaante. Ɔɔtɔ enektek nɔɔnɔ nɛ, Azi alaani o demziinto nɛ, Izi iiten ci ka kadakta naana ki nuyak ogan dayiin o vardaŋinto ole cun e.” ");
INSERT INTO mur_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ɔɔtɔ ni didi nuyawa utuguzɔ kiyo ona aduwak Yesu nɔɔgɔ o, ma avɔ agɔɔn dayiin o vardaŋinto ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma yomana ivita Yesu ki nuyak ogin een amɔtɔ ram, ma aavtiz loota ka kadaktɔ. ");
INSERT INTO mur_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma dayiinɛ ŋina enek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, ataalinan tiŋeere ɛɛti codoi ŋaatunooŋ aneet.” ");
INSERT INTO mur_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mazi azii nuyawa gi nico, ivirit nɔɔgɔ dook zinzeeti. Ma ajin ceeni gɔɔn ŋaatineeŋ Yesu anek nɛ, “Aneeta gi? Manyi, aneeta gi?” ");
INSERT INTO mur_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Akɔ tiŋeere ataalinan ɛɛti ci kazola ki nɔɔnɔ dayiin ŋina noko ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Zin naana Ŋɛɛrti Eeto ŋaan kadaai ebaal aduwan waragɛ o Joowo laadun e. Bar zin nɔŋ ci kol eete ci akɔ ataalinan aneet o. Abon da bar niini alaŋ aritai dook.” ");
INSERT INTO mur_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Buk Judaz o ka kook kataalɔi Yesu e ijin buk nɔɔnɔ anek nɛ, “Manyi, aneet gi?” Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nɛɛn ci aduwa o.” ");
INSERT INTO mur_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mazi ŋaan adake niigi nɔkɔ, odoma Yesu ḏokoc, ma anyek Jook zany, ma atɛɛt ḏokoc nico, ma aŋerek nuyak, ma azi nɛ, “Adayit. Nicini ɛlɛ onan nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bodo adoma diic ci nyaanu, ma anyek Jook zany, ma anyek nɔɔgɔ anek nɛ, “Owodit niiga dook. ");
INSERT INTO mur_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nicigi biye ogan ayelza terkediin o Joowo aḏuutonek looc ka kutuyɔ ɔl ci meel, ma aaryai baciinowa ugeec. ");
INSERT INTO mur_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Didilɛ kaduwakuŋ igeet, alaŋ bodo naana kawodɛ ŋaatodoi ki igeet zɛɛ ma kavɔ kawudɛ baliinte o baaba.” ");
INSERT INTO mur_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Artek ni niigi beniin codoi, ma iŋaaz avɔ biye o kazi Kiŋiroc. ");
INSERT INTO mur_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Enek ni Yesu nɔɔgɔ nɛ, “Adotekaŋ tija looc, ma aviryu niiga dook, eeci azi waragɛwi o Joowo nɛ, Karui tiŋeere eet o towawiinto kazaantɛ ɛɛzana. ");
INSERT INTO mur_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Zin tiŋeere ma kitiŋa naana daayiza, karake ŋaatunooŋ kakɔ Galiliya.” ");
INSERT INTO mur_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Enico itiŋa Pitɔr, ma anek Yesu nɛ, “Alaŋ bai naana kooŋnekin looc been nɛɛn! Yo nuun avir nuyawa dook, alaŋ naana kavir.” ");
INSERT INTO mur_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Didilɛ kaduwakin ineet, adaŋnyan tija lak iiyu zɛɛ ma arɔk toloci o oowu.” ");
INSERT INTO mur_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Alaŋ bai naana kadaŋnyin been nɛɛn, mayo nuun mã ka kadaayit ki ineet.” Ma buk aduwa nuyawa dook gi ci aduwa Pitɔr o. ");
INSERT INTO mur_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ivita ni Yesu ki nuyak ogin. Mazi avu arum ŋinti kazi Gezemani biye o kazi Kiŋiroc, enek niini nɔɔgɔ nɛ, “Aavtiz ŋina rak ŋinti ŋaan kakɔ kaŋaryinɛ o.” ");
INSERT INTO mur_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma akɔyi niini Pitɔr ki lɔgɔz o Zebedi kazi Jemis been Jɔn. Maje nɔɔnɔ avir ziniz ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma anek niini nɔɔgɔ nɛ, “Kanyei naana ziniza inoni ci appe ɔrɔɔt ci ajonini daayizi. Aavtiz zin niiga ŋina ebeyit eleeti ŋaryiinta.” ");
INSERT INTO mur_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ma akɔ niini ŋintimiliny, ma akani ŋum looc, ma aŋaryɛ azi nɛ, “Baaba, mã anyak gɔl oma, aara piryakzɛt ci ka kiiyayan noko ŋaatan. Alaŋ een zin bar eo karɔɔŋɛ naana, bar tugu eo arɔɔŋɛ niina.” ");
INSERT INTO mur_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mazi abadaak nuyak ween iiyu e, amada nɔɔgɔ ataŋguzɔ. Ma anek niini Pitɔr nɛ, “Ma niiga dook iyontiya alaŋ atamanu kicintɛ ki aneet ziit codoi ṯɔr o naa? ");
INSERT INTO mur_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Iziti vililɛ. Aŋaruyɔ ka calaŋ acinanuŋ Loryen zinzeeti zɛɛ ma agoonu oŋɛ. Eeci zinzeeti ugooc arɔɔŋ kutuguzɔ kaal ci abon, maje bar eleeti cugooc o alaŋ anyak dɔyiz.” ");
INSERT INTO mur_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bodo ŋintimiliny nɔkɔ imiirozek Yesu ŋaryiin. Ma akɔ ajin Jook anek nɛ, “Baaba, mã alaŋ piryakzɛt ci ka kiiyayan noko aaryai, tugu eo arooŋ niina labak.” ");
INSERT INTO mur_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Mazi abada ŋaryiinta, amada bodo nuyak ataŋguzɔ, eeci adoŋ niigi ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bodo amiiri niini, ma akɔ aŋaryɛ aduwa zɔɔz we ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma abadaak nuyak, ma aku anek nɛ, “Ŋaan dim ooginu nɔkɔ? Izi zin ziiti o ka kanyozekɛ naana Ŋɛɛrti Eeto ɔl o oŋenu ajɔn. ");
INSERT INTO mur_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Itiŋgaz, kɔtɔɔz. Icinit di, iiya ɛɛti o ka kook kataaloyan.” ");
INSERT INTO mur_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mazi ŋaan azɔɔz Yesu nɔkɔ, urum Judaz looc ɔrkɔra kibeen ɔl ci meel gɛr ci itoona alaata o ceez o Joowo been ɔl o Juz baayizo. Awoya niigi dilanyai ki kɛɛni. ");
INSERT INTO mur_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Maje uyen Judaz enek nɔɔgɔ nɛ, “Tedec mã acinu eet ci kacoco ŋalyamoc o, nɔɔnɔ nɛɛn agamit.” ");
INSERT INTO mur_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mazi aku arum Judaz looc, ook ŋaati Yesu ecodoi nɔkɔ, ma anek nɔɔnɔ nɛ, “Abona, alaan o demziinto.” Ma acoco nɔɔnɔ ŋalyamoc. ");
INSERT INTO mur_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Enek ni Yesu nɔɔnɔ anek nɛ, “Laŋo, tugu gi ci arooŋ tugu o labak.” Ivita ni ɔl, ma agam Yesu. ");
INSERT INTO mur_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma avoca nuyaiti codoi nuyawe o aromɛ ki Yesu o kabaz tibila, ma atɛɛda gabarɛn ci alaan o ceez o Joowo itat por. ");
INSERT INTO mur_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma anek Yesu nɔɔnɔ nɛ, “Bil di! Arek kabaz cun noko tibil. Eeci ɔl o gɔɔn akat ɔl dilanyai dook adaai buk katin niigi dilanyai. ");
INSERT INTO mur_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Alaŋ agayu mã inoko kawo baaba, itoonakan toonnyaye ogin ci meelik enico ɛlɛ kiiya kitiritan o? ");
INSERT INTO mur_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mazi koca avu atiritan toonnyawa aneet, ka zin zɔɔz o waragɛ o Joowo kɛlɛɛmnyai ku?” ");
INSERT INTO mur_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Enek ni Yesu kɔlɛ dook nɛ, “Naa avunakaŋ kɛɛni ki dilanyai ka ivita agamtaŋ kiyo keen agoryai o naa? Karomɛ gɔɔn naana ki igeet tup kadɛmzɛ ceeze o Joowo, ma ŋaan agamtaŋ. ");
INSERT INTO mur_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bar zin kaala nicigi dook iina o ka kɛlɛɛmnyai zoozowa baal ayɛɛt nyakaŋanɛta e.” Enico odokonyit nuyawa dook ŋina lai, otoŋtek Yesu doon looc. ");
INSERT INTO mur_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ooti ni ɔl ci ona agam Yesu o nɔɔnɔ ole o alaan o ceez o Joowo kazi Kayavas ŋaa ona alotɛn alaata o gɔɔn ademzek ɔl lotinok kibeen ɔl o Juz baayizo e. ");
INSERT INTO mur_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mazi avɔyi niigi Yesu, unuwun Pitɔr nɔɔgɔ vurta rɛɛna zɛɛ ma avɔ arum kɔrɔk ci Kayavas ona avɔyi ɔl Yesu o. Ook ni aavu niini loota oromtɛ ki ɔl o abɛk ceez o alaano kɔrɔk kɛŋa ka kicin gi ci arɔɔŋ kutuguzek ɔl Yesu o. ");
INSERT INTO mur_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Maje alaata o ceez o Joowo ki ɔl o roonnyo dook arɔɔŋ gɔl ci ajowan gi ci gɛr abaca Yesu ka kɔɔt kuruyit nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bar zin ɔkɔm gi ci gɛr ajowa niigi ŋaatin kina, yo nuun akat ɔl ci meelik gɛr nɔɔnɔ vɔlɔŋa o. Ma vurta itiŋgazɔ ɔl raman jena. ");
INSERT INTO mur_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ma anek ɔl o roonnyo vɔlɔŋa nɛ, “Kaziiŋna iiten baale azi ɛɛti nici nɛ, Kanim naana kɔɔyɔk ceez ci Joowo noko, ma bodo kenyeeti iinyaye ceen iiyu.” ");
INSERT INTO mur_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mazi azii Kayavas zɔɔz nico, itiŋa jena, ma anek Yesu nɛ, “Anyei gi ci arooŋ bariz zoozowe ci aduwa ɔl nici noko tɔ?” ");
INSERT INTO mur_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Maje Yesu ajaki niini labak cin. Ma bodo anek alaani Yesu nɛ, “Inoko didi zaare o Jook o arogi duwayet mã een niina Kiristo ween ŋɛɛrti Joowo ɛlɛ nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nɛɛn ci aduwa niina o. Inoko zin kaduwakuŋ igeet ci aavtiyu ŋina noko dook, acinaŋ tiŋeere niiga aneeta Ŋɛɛrti Eeto ŋaati kaavɛ aziite o Joowo azo, ma kabada tiŋeere ŋaati kawoyanɛ diizwani tamma.” ");
INSERT INTO mur_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mazi azii alaani zɔɔz nico, otobor nɔŋ, ma arɛɛc rumanɛ ogin maany, ma azi nɛ, “Ɛɛti nici amomoz Jook giye ci anyekɛ ɛlɛ kizi Jook noko. Inoko iziiktu niiga dook zɔɔz ci aduwa niini noko. Alaŋ bodo karɔɔŋ cudanɛ oogi. ");
INSERT INTO mur_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Inoko zin arooŋnyu niiga apaktek nɔɔnɔ naa zooze nico?” Ma azi niigi dook nɛ, “Abac niini gi nico ɔrɔɔt. Abon adaai.” ");
INSERT INTO mur_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Otortek ni niigi nɔɔnɔ amot, ma arɔɔk. ");
INSERT INTO mur_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ma adoma ɔl ci ona aruk nɔɔnɔ voret noko, ajin nɔɔnɔ anek nɛ, “Kiristo, aga ri niina kaal dook. Ŋɛnɛɛn ci arookin o?” ");
INSERT INTO mur_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Maje Pitɔr aavi bitaala kɔrɔk kɛŋa. Ma aku dole ceen gabaren ci alaan o ceez o Joowo, ma anek Pitɔr nɛ, “Orkoryu ri buk gɔɔn niina kibeen Yesu ci Galili noko.” ");
INSERT INTO mur_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ma bar adaŋnyi Pitɔr ɔl dook kɔrgɛna ŋina anek dole nico nɛ, “Alaŋ kaga gi ci aduwa o been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ma iŋaaz niini ŋina, ma akɔ araan otoga. Bodo icin dole ceen gabarɛn oman nɔɔnɔ, ma anek ɔl nɛ, “Ɔrkɔr gɔɔn buk ɛɛti nici ki Yesu o Nazarɛt.” ");
INSERT INTO mur_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bodo ni adaŋnyi Pitɔr azi nɛ, “Didilɛ kateedona zɔɔ, alaŋ kaga eet ci aduwa o been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Bodo ŋintimiliny nɔkɔ ivitak ɔl o ɛɛl ŋinaante e Pitɔr, ma avu anek nɛ, “Niina alya een eet codoi ole o Yesu, eeci azooz kiyo niigi o.” ");
INSERT INTO mur_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ma abarzek bodo Pitɔr nɔɔgɔ anek nɛ, “Didilɛ mã kaduwa vɔlɔŋ, adaakan koca tammu. Alaŋ kaga eet nico.” Enico ɛlɛ ɔrɔk toloci. ");
INSERT INTO mur_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma aada Pitɔr gi baal anek Yesu nɛ, “Adaŋnyan tiŋeere lak iiyu zɛɛ ma arɔk toloci e.” Udun ni niini ook bitaala, ma akɔ alu ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ma ŋeere ririwɔna ivita alaata o ceezi o Joowo dook kibeen alaat o Juz abaabanit gɔl ci ka kurukti Yesu kadaak. ");
INSERT INTO mur_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Acabit ni niigi nɔɔnɔ azɛɛn, ma avɔyi alaane ween Romen kazi Pailat. ");
INSERT INTO mur_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mazi akɔ acin Judaz apaktek ɔl Yesu daayiz, uwucek nɔɔnɔ gi nici ɔrɔɔt, ma abad mony. Ma amiironɛkɛ alaat guruc baal een eetom kamɔtɔ anyek niigi nɔɔnɔ ka kɛyɛlɛkɛ nɔɔgɔ Yesu e. ");
INSERT INTO mur_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ma anek niini nɔɔgɔ nɛ, “Kabaca oŋec giye ci kanyuŋ eet ci abon noko, eeci inoko arooŋnyu uruyit nɔɔnɔ kadaak.” Ma ɛbɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Akɔm ageeta zɔɔz cinaaŋ. Nicini zɔɔz cun doon.” ");
INSERT INTO mur_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ujukek ni Judaz guruc ceez o Joowo kɛŋ. Ma adun, ma akɔ acabek alɛm kɛɛt. ");
INSERT INTO mur_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ɛvɛrta ni alaata o ceez o Joowo guruc ci ona ajukek Judaz ceez kɛŋ noko, ma anɔ nɛ, “Nicigi guruc ci biyetu. Alaŋ zin abon keere ona ŋaati karomi ki guruc o ceez o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma agama niigi dook ka kataalai guruc nicoko mana ci eet o gɔɔn ɛɛnyɛt ijunya ka kizi ŋinti gɔɔn adawi niigi ɔl ceen modo, matɛ gɔɔn adaai niigi Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Gi zin ci awɛ ɔl mana nice kizi Mana ci Biyetu zɛɛ been inoko o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Zin gi baal aduwa nyakaŋani o kazi Jirimaya e ɛlɛɛmnyai didi. Azi baale niini nɛ, “Ooti ɔl o Israyil guruc baal een eetom kamɔtɔ baal arɔɔŋ niigi ka kataalai nɔɔnɔ e, ");
INSERT INTO mur_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma avɔ ataalanɛ mana ci eet ci ɛɛnyɛt ijunya kiyo baale aduwakan Jooi e.” ");
INSERT INTO mur_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iiya ni ijin Pailat Yesu enek nɛ, “Ineet alaan o Juz nɛɛn?” Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nɛɛn ci aduwa niina o.” ");
INSERT INTO mur_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Maje giye o akɔlaki alaata o ceez o Joowo kibeen ɔl o Juz mayan nɔɔnɔ rooni vɔlɔŋa akɔm niini gi ci abariz kina. ");
INSERT INTO mur_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ma anek Pailat nɔɔnɔ nɛ, “Alaŋ kaal ci akanin ɔl ineet noko azii?” ");
INSERT INTO mur_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bar Yesu akɔm gi ci abariz kina. Ma giye nico ibiir alaan ɔɔ ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maje gɔɔn baale laadun ma aku iiteni o aadanɛ ɔl o Juz vardaŋinɛt, ɔɔga alaani eet codoi ole o acabje ci tɛ olla arɔɔŋ ɔl nɔɔnɔ kɔɔgjai. ");
INSERT INTO mur_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Zin iitene nice anyak eet ci gɛr acabji giye ci amonyi niini ɔl, ma aga ɔl dook nɔɔnɔ kazi zaar cigin nɛ Barabas. ");
INSERT INTO mur_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Mazi avɔ alotai kɔlɛ dook, ijin Pailat nɔɔgɔ enek nɛ, “Arooŋnyaŋ kɔɔgayuŋ Barabas yo kɔɔgayuŋ da Yesu o kazi Kiristo?” ");
INSERT INTO mur_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Maje Pailat aga nɔkɔ anyaak alaata ci Juz nɔɔnɔ Yesu o, eeci amadik niigi nɔɔnɔ gaga nɔkɔ, kɔkɔm gi ci gɛr agɔɔn. ");
INSERT INTO mur_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mazi ŋaan aavi Pailat roonnya nɔkɔ, itoonak ŋaa oninɛ ɔlɔ nɔɔnɔ otok ci azi nɛ, “Má agoonei eet nico gi ci gɛr been nɛɛn, eeci kapirna bilija avunakan wunozya ci akati nɔɔnɔ, ma awucnekan niini ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Maje alaata o ceez o Joowo kibeen ɔl o Juz baayizo ayɔɔta ɔl ceen kɔlɛ o ka kuduktak Pailat kɔɔga Barabas. Maje Yesu abon apawonek nɔɔnɔ daayizi. ");
INSERT INTO mur_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma ajin Pailat kɔlɛ anek nɛ, “Mayo ole ceen ram noko arooŋnyaŋ kɔɔgayuŋ jaŋ?” Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Karooŋnyin ɔɔgayet Barabas.” ");
INSERT INTO mur_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ma bodo ajin Pailat nɔɔgɔ anek nɛ, “Ma Yesu ci kazi Kiristo o kutuguwek naa?” Ma abɛdɛkɛ niigi dook Pailat anek nɛ, “Tɔdɔ nɔɔnɔ talakeca kadaak.” ");
INSERT INTO mur_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Abɛdɛkɛ bodo Pailat nɔɔgɔ anek nɛ, “Abaca niini gitaz?” Bar enico egerenyit niigi ɔrɔɔt ɛlɛ azi nɛ, “Tɔdɔ nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Mazi akɔ acin Pailat ɔkɔma gɔl ci ɔɔganɛ Yesu, ma otoborit ɔl dook nɔŋ nɔkɔ, abaaban izi nɛ, karabɔŋ tedec agɔɔn ɔl gi ci gɛr, odoma ni maam otoony azɛɛn nɔɔgɔ ŋuma, ma anek nɔɔgɔ nɛ, “Akɔmnan aneet gi can daayize ci eet nico o. Gi cunooŋ doon nici. Alaŋ naana kawoyɛ tɔ.” ");
INSERT INTO mur_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Mazi aduwa Pailat gi nico, egerenyit niigi dook aziti nɛ, “Anyek biye cigin o kivitayet ageeta ki dɔl ci dɔl cigaacak labak.” ");
INSERT INTO mur_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ɔɔgak ni Pailat nɔɔgɔ Barabas. Ma aduwak ɔl rak korooyit Yesu zɛɛ anyek ni nɔɔnɔ kɔɔt kotodeec niigi nɔɔnɔ keete ween talakec. ");
INSERT INTO mur_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ooti ni takirnya Yesu ole o alaano, ma avɔ aliya niigi dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma aburuca nɔɔnɔ rumanɛ ogin, ma aborcɛkɛ rum ci meeri. ");
INSERT INTO mur_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ma agɔɔna nyigirgir ceen bila, ma avu aborcɛkɛ nɔɔnɔ ɔɔ. Ma anyek kɛɛt kanyak aziite ci azo o kiyo kɛɛt o gɔɔn anyak ɛɛti ween alaan o. Ma avu amomoz niigi nɔɔnɔ akanek kozoŋtin kiyo alaani o. Ma azi nɛ, “Rok bai nɔkɔ kodot, alaan o Juz.” ");
INSERT INTO mur_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma oortek niigi nɔɔnɔ amot, ma aama kɛɛt we bodo, ma arooi nɔɔnɔ ɔɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mazi ijezit kaal ci ona amomozi niigi nɔɔnɔ noko dook, uburuca rum ci meeri noko, ma arikɛ nɔɔnɔ rum onin laadun e. Ooti ni niigi nɔɔnɔ kutur bitaala ka kɔɔt kotodeec kadaak talakeca. ");
INSERT INTO mur_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mazi aduŋni niigi nɔɔnɔ, urumtɔ gɔla kibeen eet ci kazi Saiman ci looc ci kazi Sariin. Adaŋtek ni niigi nɔɔnɔ kitik kɛɛt ci Yesu een talakec o. ");
INSERT INTO mur_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ma avunak niigi ŋinti kazi Golgoza. Ma kɛŋ ci zaar ci kazi Golgoza noko kazi nɛ amɛn ci oowu. ");
INSERT INTO mur_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma ŋinaante anycek niigi Yesu nyaan ci acanɔ ki agɛrɔ ci akaka. Mazi atar niini, otobor alaŋaan awot. ");
INSERT INTO mur_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Otodooc ni niigi nɔɔnɔ ŋinaante. Ma aŋerek rumanɛ ogin eleeti ŋaati agɔɔni maadico. ");
INSERT INTO mur_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mazi akɔ odotiz, aavtiyɔ niigi ŋinaante ebeyit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Maje keete ci ona adodinɛ Yesu noko tadena ayeedi niigi gi ci ona aruyi ɔl nɔɔnɔ o azi nɛ, “Nicini Yesu ween alaan o Juz.” ");
INSERT INTO mur_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ma anyaa buk bodo niigi ɔl ceen agoryak een ram, ma avu adɔdɔ codoi nɔɔnɔ eci azo o, maje codoi adɔdɔ eci kaŋeto o. ");
INSERT INTO mur_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Maje ɔl ci olla awɔ gɔla ararni Yesu zɛɛ ma arurut ooti, ma amomoz nɔɔnɔ anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ma baale azi nɛ, Ka ɔyɔk ceez o Joowo, ma bodo ɛɛnyca iinyaye ceen iiyu. Rogoz zin di ɛlɛ. Mã een ŋɛɛrti Joowo didi, duna di keete ci adodinɛ noko looc.” ");
INSERT INTO mur_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Maje buk alaata o ceez o Joowo, ki alaat o ademzek ɔl lotinok, been ɔl o Juz baayizo amomoz buk niigi nɔɔnɔ nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ma anɔ nɛ, “Arogoz niini ɔl oogi doon, ma bar alaŋ anim korogoz ɛlɛ cin o maany. Alaŋ een niini alaan o Israyil nɛɛn? Mã aduŋnak looc keete ceen talakec adodinɛ noko, katu koca naaga dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Atu niini Jook, ma atarkat gi ci azi nɛ, Een niini ŋɛɛrti Joowo. Kicinit zin di mã ɛɛla Jooi inoko nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Mayo nuun een ɔl ween agoryak adɔdɔ ɔl ki nɔɔnɔ e amomoz buk nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mazi akɔ abil ii boloca, izi lɔɔci dook dildil kizi muur ziik iiyu. ");
INSERT INTO mur_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma ziiye ween iiyu yomana ɛgɛrɛny Yesu molowe ci appe azi nɛ, “Eli, Eli, Lema Sabaktani?” Ma kɛŋ ci zɔɔz nico azi nɛ, Jook onan, Jook onan. Ooŋnan naa? ");
INSERT INTO mur_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Mazi azii ɔl ogɛn ole ci ɛɛl ŋinaante gi nico, izitɔ nɛ, “Awo bɔŋ niini Ilija.” ");
INSERT INTO mur_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma adɔkɔny ɛɛti codoi ŋaatineeŋ, ma akɔ adoma kaviyoi, ma ajukek nyaan, ma akat moroka, ma itoonek nɔɔnɔ ka kococo. ");
INSERT INTO mur_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Maje bar ɔl ogɛnɛ azi nɛ, “Bil rak di, kicinit karabɔŋ aku arogoz Ilija nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ɛgɛrɛny ni Yesu bodo molowe ci appe, ma atɛɛt enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma areeci rum o gɔɔn aŋerin ceez o Joowo kɔrgɛna enico ɛlɛ, akanai tadena been tir loota. Maje lɔɔci amɔɔt kirakirak, ma alibe biyɛn taza. ");
INSERT INTO mur_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma akoli looknya o gabara o Joowo titiny baal gɔɔn adaai e. Ma aŋaaz ci meelik ŋaatineeŋ daayiza korogit. ");
INSERT INTO mur_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma aduŋna niigi looknyai. Mazi iŋaaz Yesu daayiza, ɔtɔɔzɔ niigi ɔɔt Jerusalɛma, ma avɔ acin ɔl ci meel gɛr nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mazi acin alaani o takirnyawu kibeen takirnya ogin abɛk Yesu e looc mɔɔtiz kibeen kaal nicoko dook, otoŋole niigi looc ɔrɔɔt ɛlɛ, ma anɔ nɛ, “Didilɛ ɛɛti nici tɛ ŋɛɛrti Joowo gi.” ");
INSERT INTO mur_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Maje ŋinaante anyak ŋaai ci meel gɛr baal anowa Yesu Galiliya, ma atirit nɔɔnɔ e. Agɛlɛm niigi Yesu rɛɛna. ");
INSERT INTO mur_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ma ŋaai nici awɔyi Meri o kutur o kazi Magdala, ki bodo Meri ween yaati Jemis been Josev, kibeen yaati Jemis ki Jɔn. ");
INSERT INTO mur_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ma yomana iiya ɛɛti ceen aroi kazi zaar nɛ Josev ci aluuga baale Arimatiya. Niini buk nuyai ci Yesu. ");
INSERT INTO mur_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma akɔ ajin Pailat ka kanyek nɔɔnɔ Yesu kook kada. Ma aricanek Pailat ɔl ka kanycek Yesu Josev. ");
INSERT INTO mur_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Odoma ni Josev ɛlɛ o Yesu atakucek rum ci vɔɔr colai. ");
INSERT INTO mur_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ma akɔ arek bɔɔt onin baal agoonak niini ɛlɛ maany biya e, zɛɛ anyaa ni bɛ ci appe ɔrɔɔt ɛlɛ, ma aku anyoogi bɔɔt otok. Zɛɛ ɔɔtɔ ni niini. ");
INSERT INTO mur_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maje Meri o Magdala ki Meri oma bodo aavtiz ŋinaante agɛlɛm bɔɔt rɛɛna. ");
INSERT INTO mur_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma ŋeertine co ɔɔtɔ alaata o ceez o Joowo ki ɔl o Parici ŋaati Pailat. ");
INSERT INTO mur_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma avɔ anek nɔɔnɔ nɛ, “Manygɔn, azi baale voloŋoiti nici iinyaye baal ŋaan arogni e nɛ, Kiŋaaz bodo iima daayiza iinyaye ceen iiyu. ");
INSERT INTO mur_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Inoko zin karooŋnyin anyek takirnya kɔɔt kebeyit bɔɔt juruŋ zɛɛ ma adicai iinya ceen iiyu baal aduwa niini o, ka calaŋ avɔ agɔrɔz nuyawa oginɛ, ma avɔ anek ɔl nɛ, Itiŋa niini daayiza. Mã agɔɔn niigi nɔkɔ, izi koca vɔlɔŋ cineeŋ o appe ɔrɔɔt bar kujuk baal aduwa niini e, ma uulalet.” ");
INSERT INTO mur_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma anek Pailat nɔɔgɔ nɛ, “Anycek zin takirnya kɔɔt kebeyit bɔɔt juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ɔtɔɔzɔ ni niigi ɔɔt boote o adawin Yesu e, ma avɔ agiir bɔɔt otok dook lai juruŋ ka kɔkɔm eet ci akɔl, ma ooŋnek takirnya ŋinite kebeyit. ");
INSERT INTO mur_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ma iitene o yubzento ŋeere ririwɔna ook Meri o Magdala been bodo Meri oma ka kɔɔt kicinit bɔɔt. ");
INSERT INTO mur_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ŋintimiliny nɔkɔ ɔtɔɔmɔ lɔɔci dook kirakirak. Ma akunak toonnyaiti ci Joowo looc tamma, ma aku aara bɛ baal anyoogi ɔl bɔɔt otok e, ma aavɛ. ");
INSERT INTO mur_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Maje ŋum ci toonnyai nico o alanyit kiyo abadi bɔrɔyɛ o, ma vɔɔrɛ rumanɛ ciginɛ o pɛr. ");
INSERT INTO mur_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma aruk takirnya o abɛk bɔɔt e kulurkuluri, kabaritit, ma iina kataŋguzɔ kiyo ɔl o adaai o. ");
INSERT INTO mur_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma azoozek toonnyaiti ŋaai anek nɛ, “Má aŋolinu looc gaga. Kaga nɔkɔ avu arooŋnyu Yesu baal adɔdi talakeca e. ");
INSERT INTO mur_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Azee zin niini tɔ ŋina. Itiŋa daayiza ebaal aduwan niini e ɛlɛ. Ivita di icinit ŋinbaal ɔɔŋɛ e ce. ");
INSERT INTO mur_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iyiiyit zin inoko taman ɔɔtɔ uduktak nuyak ogin enektek nɛ, Itiŋa niini daayiza. Ma inoko arayɛ ŋaatunooŋ ook Galiliya. Avɔ tedec acinu niiga nɔɔnɔ ŋinaante. Inoko zin gi ci kaduwakuŋ dook nɛɛn nici.” ");
INSERT INTO mur_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iyiit ni ŋaai nici ɔtɔɔzɔ bɔɔta ŋina ŋoliinta, maje ŋaato atalnɛ. Ma adɔkɔny ka kɔɔt kuduktak nuyak. ");
INSERT INTO mur_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ŋintimiliny nɔkɔ ɔbɔryak Yesu nɔɔgɔ boyoŋyoŋ, ma anek nɛ, “Abonanu. Abil ganɔn ŋaatunooŋ.” Ma avunak niigi nɔɔnɔ, ma avu atorkot zɔɔ, ma adiŋdiŋan. ");
INSERT INTO mur_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Enek ni Yesu nɔɔgɔ nɛ, “Má aŋolinu looc gaga. Ɔɔtɔ uduktak nuyak kivita kɔɔt Galiliya. Ŋaan avɔ acinan niigi aneet ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mazi ŋaan awɔ ŋaai gɔla nɔkɔ, odokonyit takirnya ogɛn takirnyaye ona abɛk bɔɔt e ɔɔtɔ Jerusalɛma, ma avɔ aduwak alaat o ceez o Joowo kaal ona acin niigi agooni e dook. ");
INSERT INTO mur_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mazi azii alaata gi nico, ulute niigi dook ki alaat o Juz ŋaatodoi, ma abaabana zɔɔz codoi. Ivita ni otoloyit takirnya anycek guruc ci meelik gɛr. ");
INSERT INTO mur_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ma anek nɔɔgɔ nɛ, “Mã ajinuŋ ɔl, enektek nɛ, Ivita nuyawa o Yesu ogorozit nɔɔnɔ bɔɔta baal ŋaati koogina. ");
INSERT INTO mur_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mã arum alaan zɔɔz nici, ŋaan kavɔ kazoozona ki ageeta. Má anyaku ŋoliin gaga zooze nico.” ");
INSERT INTO mur_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Agamta ni takirnya guruc nicoko, ma avɔ aduwa vɔlɔŋ eona aduwakɛ alaata e. Zin vɔlɔŋ cineeŋ noko uteec ɔl o Juz zɛɛ been waanico o. ");
INSERT INTO mur_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ma avɔ nuyawa ween amɔtɔ codoi biye o abil Galiliya ŋaabaal aduwak Yesu nɔɔgɔ ka kooti e. ");
INSERT INTO mur_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mazi avɔ acin niigi Yesu, ŋinaante idiŋdiŋanit nɔɔnɔ. Maje ɔl ogɛn ŋaatineeŋ ŋaan bakbayɛ nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma icayak Yesu nɔɔgɔ ajonun, ma anek nɛ, “Anyozozeyan alaazɛt dook tammu tadena been loota aneet. ");
INSERT INTO mur_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ɔɔtɔ zin ole o loocok dook ka anycek nɔɔgɔ kiziti nuyak cigan. Otoonyit nɔɔgɔ zaare o baaba ki zaare ogan aneet ŋɛɛrin been zaare o Vɔŋiz o Joowo. ");
INSERT INTO mur_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ɔɔtɔ edemezit nɔɔgɔ ka kuzuuti kaal ci karicanekuŋ naana igeet noko dook. Abon zin niiga agayu karomɛ tiŋeere naana ki igeet tup nɔkɔ zɛɛ ma aṯornɛkɛ lɔɔci.”");
INSERT INTO mur_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nici kanaan ci kaviyak o colai akati Yesu Kiristo ween ŋɛɛrti Joowo. ");
INSERT INTO mur_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Akanai zin ebaal ayɛɛdi nyakaŋani o kazi Izaya zɔɔz o aduwa Jooi waanbaal anɛ nɛ, “Ŋaan tiŋeere kitoon gabaren can rak karayɛ ineet ɔɔwa ka kook kidimdimɛn gɔl. ");
INSERT INTO mur_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ma aku agɛrɛny ɛɛti nici balala azi nɛ, Idimdimantek eleeti gɔl o Manyi. Amadek nɔɔnɔ golok ogin keelit tɔp.” ");
INSERT INTO mur_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Zin mazi aku Jɔn e, iiya abaak niini balala, ma uuwak gi ci ka kabadai ɔl oŋɛnɛ ka kotoonycɛ niigi ka kaara Jooi oŋɛ ugeec. ");
INSERT INTO mur_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Zin enice ivitak ɔl dook Jɔn looce o kazi Judiya ki kuture o kazi Jerusalɛm ka kiziiyit nɔɔnɔ, ma avu abɔra niigi oŋɛ ugeec, ma oony Jɔn nɔɔgɔ liile o kazi Jordan. ");
INSERT INTO mur_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Maje Jɔn waanice amalik rum ci agɔɔnnyai imane ci nyakalo been kavali ceen ruceen barkɔnya. Ma adak niini giroc been lɛtɛ ci ajowa tuuwa. ");
INSERT INTO mur_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma uuwak niini waanice zɔɔz ci azi nɛ, “Vurte can anyak tiŋeere eet ci aku ci adiŋdiŋ kujukan aneet. Ma alaŋ kaganona naana ŋaati kaborcanɛ nɔɔnɔ caava ogin zoonu, eeci adiŋdiŋ niini ɔrɔɔt ŋaatan. ");
INSERT INTO mur_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inoko kuunyuŋ naana igeet maami doon, aje bar niini ŋaan aku uunyuŋ igeet Vɔŋize o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma iinyaye niceke iiya Yesu kuture o kazi Nazarɛt abil looce o Galili, ma akɔ oony Jɔn nɔɔnɔ liile o kazi Jordan. ");
INSERT INTO mur_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Mazi akɔ aduŋna Yesu maami, enico ɛlɛ ɔkɔlɛ tammu kɛŋ, ma acin niini Vɔŋiz o Joowo akunak nɔɔnɔ kiyo yɛɛlac o. ");
INSERT INTO mur_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma azi mɔlɔyi ci aku tamma nɛ, “Een niina ŋɛɛran o kareezin nɛɛn. Katalnɛ naana ŋaatun ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Enico ɛlɛ itoonek Vɔŋizi o Joowo Yesu balal. ");
INSERT INTO mur_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma akɔ aavi niini balala ŋinaante iinya eet ram, ma acina Loryenti nɔɔnɔ. Maje ŋinaante anyak kɛlɛk ci too, bar zin ivita itiritit toonnyawa o Joowo nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mazi akɔ acap ɔl Jɔn, itiŋa Yesu ook Galiliya, ma akɔ uuwak kaviyak o Joowo ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ma anek niini ɔl nɛ, “Inoko iiya iiteni, ma izi buk baliin o Joowo ajɔn. Otoŋit zin oŋɛ ugoocok agoonu, bar ivita utuweec kaviyak o Joowo abon.” ");
INSERT INTO mur_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mazi akɔ awɔ Yesu liile o kazi Galili otoga, icinun niini ɔl ceen ram, Saiman kibeen gɔtɔni ci kazi Andoru. Adɛt niigi kuluk cabaya. ");
INSERT INTO mur_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma anek Yesu nɔɔgɔ nɛ, “Unuyawaŋ. Ŋaan kakɔ kademzekuŋ naana igeet gɔl ci ka edetakɛ ɔl Jook.” ");
INSERT INTO mur_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Enico ɛlɛ otoŋit niigi cabayɛt ugeec, ma ano nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mazi iicak niigi ŋintimiliny, icin bodo Yesu Jemis ween ŋɛɛrti Zebedi ki gɔtɔni o kazi Jɔn. Aavtiz niigi kavoole abutan cabayɛt ugeec. ");
INSERT INTO mur_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mazi acin Yesu nɔɔgɔ, otowa enico ɛlɛ. Ma ooŋnek niigi baatineeŋ Zebedi kavool ki ɔl o liŋliŋonto, ma ano niigi Yesu. ");
INSERT INTO mur_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ma avunak Yesu ki nuyak nicoko kutur o kazi Kapernam. Ma iitene o yubzento kazi Sabit, ook Yesu ceeze o lotento, ma akɔ adɛmɛz niini ɔl ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ma abiir ɔl o azii nɔɔnɔ ooti gole ci adɛmzi niini nɔɔgɔ o, eeci demziin cinɛ o alaŋ atobɔ ki demziin ci alaat o ademzek ɔl lotinok, bar adɛmzɛ niini kizi eet o didi anyak dɔyiz. ");
INSERT INTO mur_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma ŋintimiliny nɔkɔ, iiya ɛɛti ci anyak miniŋ ci Loryento ceez o lotento, ma agɛrɛny miniŋa nici eete nico molowe ci appe azi nɛ, ");
INSERT INTO mur_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu o kutur o Nazarɛt, arooŋ ŋaatinaaŋ naa? Akun o ka ija uulalet? Kagayin naaga ineeta nɔkɔ akun niina Joowa.” ");
INSERT INTO mur_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma agernyek Yesu nɔɔgɔ anek nɛ, “Ajaktɔ. Udunta bitaala eete nico.” ");
INSERT INTO mur_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma amɔɔni miniŋa nici eet nico kabarit kɛdɛkɛdɛk, ma agɛrɛny niini molowe ci appe, ma aduŋna miniŋa nici ŋaatin. ");
INSERT INTO mur_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma abiir ɔl ooti tɛt, ma ajinɔ niigi maany anɔ nɛ, “Mayo gitaz nici? Demziin ci colai? Ɛɛti nici anyak dɔyiz ci agɛrnyɛkɛ miniŋ o Loryento, ma azii niigi nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Taman nɔkɔ iziiyit ɔl gi ci agɔɔn Yesu noko looce o Galili dook. ");
INSERT INTO mur_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mazi aduŋna Yesu ki nuyak ceeze o lotento, ɔɔtɔ niigi ole o Saiman ki Andoru. Ma ɔrkɔr buk niigi ki Jemis been Jɔn. ");
INSERT INTO mur_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Maje inyik o Saiman amɔɔr anyak tadiwɔn ci ɔɔŋɛ kuwena nɔkɔ. Taman nɔkɔ mazi arum Yesu ŋinite, uduktak ɔl nɔɔnɔ mɔɔriz cin o. ");
INSERT INTO mur_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ook ni Yesu ŋaatin, ma akɔ agam nɔɔnɔ aziit, ma adɔŋa kaavu jena. Enico ɛlɛ izi maya, ma agoonek niini nɔɔgɔ dayiin. ");
INSERT INTO mur_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mazi akɔ ii loota yomana, anyaaktak ɔl Yesu ɔl ci meelik amɔɔr kibeen buk ɔl ci anyak miniŋ ci Loryento. ");
INSERT INTO mur_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma avu ɔl dook kuture nice, ma alotonek ceez ci ona aavɛ Yesu o reerun. ");
INSERT INTO mur_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma arogoz niini ɔl ci meelik anyak moorizok keŋti dook. Ma atɔɔk niini miniŋ ci Loryento ole ci meelik. Ma alaŋ anyek niini miniŋ o Loryento kozoozit, eeci aga niigi nɔɔnɔ niini ŋɛnɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma ŋeere ririwɔna icinɛ Yesu, ma adun akɔ ŋaati akɔm ɔl, ma akɔ aŋaryɛ niini doon ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma vurta itiŋgazɔ Saiman kibeen gɔnɔgi oogi, ma avɔ arɔɔŋ nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mazi avɔ ajowa niigi nɔɔnɔ enektek nɛ, “Ajal ɔl dook arooŋnyin ineeta.” ");
INSERT INTO mur_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Abon rak kavɔ naaga kuturyowe ogɛn ajonun ŋaato ka kook buk kuuwak ŋinaante, eeci nici gi o kakunai naana laadun nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɔɔtɔ ni niini, ma akɔ ɔzɔp looc o Galili dook. Uuwak ceezine o lotento, ma atɔɔk miniŋ o Loryento ole ci meelik ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ma akunak ɛɛti ci anyak mɔɔriz ci gidaŋ Yesu, ma aku aavek nɔɔnɔ loota kɔpɔkpɔk, ma ilalek anek nɛ, “Manyi, mã arooŋ rogozan kizi maya, rogozan.” ");
INSERT INTO mur_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma awucnek Yesu zɔɔz nici, ma ataadek nɔɔnɔ aziit, ma anek nɛ, “Nyan kitiritin. Inoko ɔkɔma mɔɔriz nico ŋaatun.” ");
INSERT INTO mur_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taman nɔkɔ izi didi ɛɛti nici maya mɔɔriza kigirgir ɛlɛ oninɛ. ");
INSERT INTO mur_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ma aricanek Yesu eet nico anek nɛ, “Má akɔ aduwai eet oma gɔla gi nico. Bar dicek bitɔ yelek ɛlɛ alaan o ceez o Joowo ka kagayin ɔl dook didi inoko izɛ niina maya. Buk bitɔ taap Jook eo aduwan lotinowa o Mosis.” Anyek ni Yesu nɔɔnɔ kɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bar mazi akɔ niini ɔlɔ, ook enek ɔl ci meelik nɛ, “Yesu nɛɛn o anyan aneet kizi maya.” Ma giye nico alaŋaan Yesu ayelzak ɔl ɛlɛ kuturyowɛ. Bar aavu niini balala ka kɔɔt ɔl o avu kuturyowɛ dook ŋaatin ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mazi amiironek Yesu Kapernam iinyaye ogɛn, iziiyit ɔl nɔɔnɔ iiyak kɔrɔk. ");
INSERT INTO mur_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ma alotai ɔl ci meelik ŋinaante, ma abitiz ceez eecitɔ kibeen bitaala buk kɔkɔm ŋinti karek zooc kina. Uuwayek ni Yesu nɔɔgɔ zɔɔz o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma avu ɔl ceen wec anyaak Yesu eet ci rɛbrɛbi. ");
INSERT INTO mur_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mazi avɔ acin niigi mɛɛlɛ ɔl, ma akɔm gɔl ci ka kurumti eet nico Yesu, otoodi niigi nɔɔnɔ ceez taden, ma avɔ akɔl ceez ɔɔ, ma abɔranɛ nɔɔnɔ ceez ɔɔ kuwena kolocak Yesu ŋaati ona aavɛ o. ");
INSERT INTO mur_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mazi acin Yesu nɔɔgɔ atuwe ɔrɔɔt nɔkɔ, enek eet ci rɛbrɛbi noko nɛ, “Ŋɛɛran, aaryai oŋɛ ugune.” ");
INSERT INTO mur_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Maje ŋinaante anyak ɔl o gɔɔn ademzek gɔnɔgi lotinok, ma abaaban niigi zinzeetinɛ gi ci anɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Azɔɔz ɛɛti nici nɔkɔ naa? Amomoz niini Jook. Ŋɛnɛɛn ci anim kaara oŋɛ? Alaŋ een Jook doon?” ");
INSERT INTO mur_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Maje Yesu aga baabani cineeŋ o nɔkɔ, ma anek nɔɔgɔ nɛ, “Akɔ ma abaabanu gi nico nɔkɔ o naa? ");
INSERT INTO mur_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yo aboke ŋaatunooŋ ŋaati kanɛkɛ eet ci rɛbrɛbi noko nɛ, Aaryai oŋɛ ugune, yo da aboke ŋaati kanɛkɛ nɔɔnɔ nɛ, Tiŋa jena. Doma kuwen cun o, tɔ. ");
INSERT INTO mur_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Karooŋ zin inoko keyeleyuŋ igeet ka agaac niiga keen naana Ŋɛɛrti Eeto, ma kanyei dɔyiz loota ŋina ci kaaranɛ oŋɛ ɔla been ci karogozɛ ɔl mɔɔrizɔi.” ");
INSERT INTO mur_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Enico enek niini eet ci rɛbrɛbi noko nɛ, “Tiŋa jena. Doma kuwen cun o. Bitɔ ɔlɔ.” ");
INSERT INTO mur_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma iŋaaz didi niini jena ɔl kɛbɛrɛn nɔkɔ, ma adoma kuwen onin, ma awɔ. Mazi acin ɔl eet o rɛbrɛbi e awɔ didi, ibiirit nɔɔgɔ ooti, ma anaat Jook, ma anɔ nɛ, “Ŋaanbaal rɛɛn laadun ŋaan kicinit gi ci abil nɔkɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Zin imiirozek Yesu bodo liil o Galili. Ma avunak ɔl ci meelik nɔɔnɔ, ma adɛmɛz niini nɔɔgɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mazi odotiz niini demziinta, iicak bodo kidicilim, ma gɔla icin niini Livai ween ŋɛɛrti Alvayoz aavi ŋaao meeryo, eeci gɔɔn laadun niini eet ci alot meeri. Ma anek Yesu nɔɔnɔ nɛ, “Ija, nowawan aneet.” Ma iŋaaz Livai, ma ano nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ŋintimiliny ɔtɔɔzɔ Yesu kibeen nuyak ogin ɔɔtɔ ole o Livai ka kɔɔtɔ kadayit dayiin o baalinu ŋinaante. Ma avu buk ɔl ci meelik ole o gɔɔn alot meeri kibeen ɔl o oŋenu oogi, ma ano Yesu kibeen nuyak ogin, ma avɔ azɔlɔ kibeen nɔɔgɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mazi avɔ acin alaata o Parici demziinto Yesu azɔlɔ kibeen ɔl o meeryo been ɔl o oŋenu oogi, ijinit niigi nuyak ogin enektek nɛ, “Azɔlɔ Yesu ki ɔl nicoko naa?” ");
INSERT INTO mur_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Mazi azii Yesu zɔɔz nico, enek nɔɔgɔ nɛ, “Gɔɔn ɔl calaŋ amɔɔr alaŋ arɔɔŋ niigi akim. Maje ɔl o amɔɔr arɔɔŋ niigi akim. Alaŋ zin laadun kakun naana ka kiiya kotowa ɔl o agɔɔn kaal o abon, bar kakun ka kiiya kotowa ɔl o oŋenu.” ");
INSERT INTO mur_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma iitene oman otoŋit nuyawa o Jɔn kibeen ɔl o Parici dayiin ka kidiŋdiŋanit Jook. Ivita ni ɔl ogɛn, ma avu ajin Yesu anek nɛ, “Ma dim gɔɔn nuyawa o Jɔn kibeen ɔl o Parici ooŋ dayiin, maje bar nuyawa cugune o alaŋ ooŋ buk niigi dayiin o naa?” ");
INSERT INTO mur_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Inoko gɔɔn ma iiŋkayi ɔl, anyek niigi bacok kaavtiyɔ magizɛt? Bar kanɛ, Akɔm! Ŋinti ŋaan rak aromɛn niigi kibeen eet ci rociinto o dook, alaŋ rak niigi aavtiz magizɛt. ");
INSERT INTO mur_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bar zin ŋaan aku iiteni ci ka kaaryai ɛɛti ci rociinto o ŋaatineeŋ. Mazi aku iiteni nica, ŋaan zin aavtiz niigi magizɛt.” ");
INSERT INTO mur_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma bodo anek Yesu nɔɔgɔ nɛ, “Akɔm eet ci abutanek rum ci rɛɛn gɔn ci colai. Mã koca agɔɔn niini nɔkɔ, arɛɛcai koca rum ci rɛɛn o gone ci colai o kizi vɔlɔŋ ɔrɔɔt bar kujuk reecinɛt baal oowu e.” ");
INSERT INTO mur_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma anek Yesu bodo nɔɔgɔ nɛ, “Akɔm buk eet ci arek iira buru ci rɛɛn. Mã koca agɔɔn niini nɔkɔ, adɛ koca iirana, ma alip buru. Ma aḏuuti iirana, ma alibe burwɛ buk. Bar abon arek ɛɛti iira buru ci colai.” (Aduwak Yesu nɔɔgɔ zoozok nicoko o ka keyelizak niini nɔɔgɔ zɔɔz calaŋ abon ŋaati aromi niigi zoozok o Joowo colai kibeen kɛɛranɛ ugeec rɛɛn.) ");
INSERT INTO mur_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma iitene o kazi Sabit yubzento awɔ Yesu kibeen nuyak ogin, ma avɔ abatak manɛɛn ci labinu. Ma aduula nuyawa oginɛ labi ci miliny, ma arom. ");
INSERT INTO mur_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma anek ɔl ci Parici Yesu nɛ, “Cin di nuyak cugun o! Abacit niigi lotinɛt o azi nɛ, Má aliŋliŋnyu iitene o yubzento.” ");
INSERT INTO mur_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋaan ekeebit niiga zɔɔz baal agɔɔn Devid iitene baal adayi nɔɔgɔ magiz e? ");
INSERT INTO mur_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Waanice adak magiz nɔɔnɔ kibeen ɔl ogin ɔrkɔr. Ɔɔtɔ ni ceeze o Joowo, ma avɔ adak ḏɔkɛn baal gɔɔn ataabi ɔl Jook e. Ma gi nici agooni waanbaal ɛɛnɛ ɛɛti o kazi Abazar alaan ci adikir ceeze o Joowo. Ma kɛɛrite ogaac alaŋ ḏɔkɛn ci taabinto noko ɔl ci gaga adak, bar adak alaata o ceez o Joowo doon. Adak zin waanice Devid ḏɔkɛn niceke labak, ma buk anyek niini oogi ɔl ogin ɔrkɔr.” ");
INSERT INTO mur_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ma anek Yesu ɔl o Parici nɛ, “Agɔɔna zin laadun Jooi iiten ci yubzento o ka kitirit ɔl ci deer. Alaŋ bar agɔɔna Jooi ɔl ci deer ka kuzuuti iiten ci yubzento o. ");
INSERT INTO mur_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Zin naana Ŋɛɛrti Eeto keen Manyi ci kaal dook kurum buk iiten ci yubzento o.” ");
INSERT INTO mur_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ma iitene oman mazi akɔ Yesu ceeze o lotento, anyak buk eet ci dɔkɔm aziiti ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Maje ɔl ci Parici ogɛn aavtiz ŋinaante arɔɔŋ niigi gɔl ci ka kɔkɔltakɛ Yesu rooni mã anyak niini gi ci abac. Ivita ni ataŋaamtek niigi nɔɔnɔ ɔrɔɔt ɛlɛ ka kicinit mã didi atirit niini eet nico iitene ci yubzento o. ");
INSERT INTO mur_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Enek ni Yesu eet ci dɔkɔm aziiti noko nɛ, “Ija. Bil ɔl ŋuma ŋaato.” ");
INSERT INTO mur_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ma ajin Yesu ɔl anek nɛ, “Mayo gɔɔn lotinowa ogaac aziineket kutuguz gitaz iitene ci yubzento o? Kitiritit ɔl yo kɛgɛrɛzanit da? Korogozit ɔl yo kuulalit da?” Mazi azii niigi zɔɔz nico, olla azi paŋ, kɔkɔm gi ci abariz. ");
INSERT INTO mur_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ma agɛlɛm Yesu nɔɔgɔ bornɛt nɔŋa. Bar bodo iinon ziniza nɔɔgɔ, eeci adɔi nɔɔgɔ zinzeeti kak. Ma anek niini eet ci dɔkɔm aziiti noko nɛ, “Zɔlan aziit cun o.” Mazi ɔzɔlan ɛɛti nici aziit, obona aziiti oninɛ labak. ");
INSERT INTO mur_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Enico ɛlɛ udunitɔ ɔl o Parici ceeze o lotento, ma avɔ abaaban niigi kibeen ɔl o alaan o kazi Erod gɔl ci arui Yesu kadaak. ");
INSERT INTO mur_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ma avɔ Yesu kibeen nuyak ogin liile o kazi Galili. Ma ano kɔlɛ ci appe nɔɔnɔ. Maje ɔl nicigi avu looce o kazi Galili ki Judiya ki Jerusalɛm ki Idumiya ki Tayor ki Sidon kibeen baagite o liil o kazi Jordan. Avunak niigi dook Yesu o, eeci azii niigi kaal o agɔɔn niini. ");
INSERT INTO mur_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mazi acin Yesu kɔlɛ appe ɔrɔɔt, ma ɛɛt nɔɔnɔ nɔkɔ, uduwak niini nuyak ogin kanyaakta nɔɔnɔ kavool o liilu kizi ajɔn, ka mã ayɔɔt ɔl nɔɔnɔ ɔrɔɔt, ka kɛɛlai ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Agɔɔn nɔkɔ o, eeci uyene atirit niini ɔl ci meelik amɔɔr, ma giye nico ivita ɔl o amɔɔr dook, ma ayɔɔtɔ ɔrɔɔt ɛlɛ, eeci arɔɔŋ kuumit niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mazi olla acin ɔl o anyak miniŋ ci Loryento nɔɔnɔ, iina niigi nɔɔnɔ kɛŋa, ma agɛrɛny azi nɛ, “Een niina ŋɛɛrti Joowo nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma aricanek Yesu nɔɔgɔ anek nɛ, “Má ayelzanaŋ aneeta ŋaati awuyaŋ kizi ŋɛɛrti Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma vurta otoodozek Yesu biyɛn, ma ŋinaante otowa ɔl ci arɔɔŋ niini. Ma avunak niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma aŋɛra ŋaatineeŋ ɔl ceen amɔtɔ ram kizi toonnyak cigin ka gɔɔn korkorit ki nɔɔnɔ, ka buk gɔɔn kitoon kɔɔt kuuwayit zɔɔz o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma anyek niigi nɔɔgɔ dɔyiz ci ka kɔtɔɔkti miniŋ o Loryento ɔla. ");
INSERT INTO mur_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Zaar zin ci toonnyak ceen amɔtɔ ram baal aŋɛra niini o nɛɛn ce. Saiman o kazi zaar oogi nɛ Pitɔr, ");
INSERT INTO mur_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ki Jemis ki gɔtɔni o kazi Jɔn o eegin lɔgɔz o Zebedi (Akanek Yesu nɔɔgɔ dook ramantiya zaar ci kazi nɛ Ɔl o Aŋozonek Zɔɔz), ");
INSERT INTO mur_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ki Andoru, ki Pilip, ki Bartalamu, ki Matiyu, ki Tomaz, ki Jemis ween ŋɛɛrti Alvayoz, ki Tadiyaz, ki Saiman o gɔɔn ɔɔrinɛ looc onin ole o Rom, ");
INSERT INTO mur_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","been Judaz Iskariyot baal ka kiiya kataalɔi Yesu e. ");
INSERT INTO mur_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma vurte nice ook Yesu ɔlɔ. Ma bodo alotak ɔl ci meelik nɔɔnɔ ki nuyak ogin zɛɛ makacin ɔkɔma nɔɔgɔ waŋi ci adayin. ");
INSERT INTO mur_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mazi azii atenowa oginɛ kaal nicoko, ɔɔtɔ niigi ŋaatin ka kɔɔt kanyaaktak nɔɔnɔ kɔrɔk, eeci anɔ ɔl ogɛn nɛ, “Anyawun niini maŋɔn.” ");
INSERT INTO mur_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mazi buk avu alaata o gɔɔn ademzek ɔl lotinok Jerusalɛma, izitɔ nɛ, “Anyak niini alya Loryen. Anyewun nɔɔnɔ alaani o miniŋu kazi Baalzibol dɔyiz ci ka kɔtɔɔyi niini miniŋ o Loryento ɔla.” ");
INSERT INTO mur_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Otowa ni Yesu ɔl, ma aduwak nɔɔgɔ yabziinta gi ci anek nɛ, “Alaŋ Loryenti atɔɔk gɔn oma ci buk een Loryen kiyo niini o. ");
INSERT INTO mur_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Gɔɔn mã aŋɛrɔ ɔl ci looc codoi, ma ɔɔrɔ niigi maany, alibe lɔɔci nici lai. ");
INSERT INTO mur_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Buk mã aŋɛrɔ ɔl ci kɔrɔk codoi, ma ayɔwɔ niigi maany, kɔrɔgi nici alibe. ");
INSERT INTO mur_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Zin buk mã aŋɛr Loryenti miniŋ ogin, ma ayɔwɔ niigi maany, adicai koca dɔyizi cinɛ o. ");
INSERT INTO mur_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Akɔm laadun eet ci akɔ agɔrzɛ ceeze ci eet ci mooti adɔi, dooke coma koca rak adɔɔn niini nɔɔnɔ zɛɛ ka zin vurta kiiya kooyi niini kaal ci eet ci mooti adɔi noko. ");
INSERT INTO mur_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Didilɛ kaduwakuŋ igeet, anim Jooi kotoŋ oŋɛ o abaca ɔl ŋaatin dook kibeen buk zoozok ugeec gɛr gɔɔn amomozɛnɛ. ");
INSERT INTO mur_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Maje eete ci amomoz Vɔŋiz o Joowo, alaŋ Jooi ooŋ oŋec nico ŋaatin been nɛɛn, eeci abaca niini oŋec ci gɛr ɔrɔɔt ɛlɛ, ma ibil nɔkɔ izi nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aduwa Yesu zɔɔz nico o, eeci azi ɔl ogɛnɛ nɛ, “Anyak niini miniŋit ci Loryento alya.” ");
INSERT INTO mur_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Zin ivita gɔtɔnɔgi Yesu kibeen yaatin, ma avu ɛɛl bitaala, ma itoon niigi eet oma kutuwak nɔɔgɔ Yesu. ");
INSERT INTO mur_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Maje kɔlɛ ci appe aavtiz loota aliya Yesu, ma aku anek ɛɛti nici Yesu nɛ, “Yaatun kibeen gotonogu ci areyin bitaala neke. Arooŋnyin niigi ineet.” ");
INSERT INTO mur_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Yaai ŋɛnɛ? Ɔl cigaŋ ci een gɔtɔnɔga o?” ");
INSERT INTO mur_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ma acin niini ɔl ci aavtiz loota alya nɔɔnɔ o, ma azi nɛ, “Nicigi gɔtɔnɔga kibeen yaatigan. ");
INSERT INTO mur_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ma ɔl o gɔɔn agɔɔn kaal o arɔɔŋ Jooi, eegin niigi yaatigan ki dɔl ci yaai.” ");
INSERT INTO mur_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma iitene oman adɛmzɛ Yesu liil o Galili otoga. Ma avu ɔl ci meelik gɛr alotak nɔɔnɔ. Makacin ook niini kavoola liila tɔ, ma akɔ aavi loota ŋinaante. Maje ɔl dook aavtiz dɔwɔna. ");
INSERT INTO mur_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma adɛmɛz niini nɔɔgɔ ŋaati ayabzi zoozok yabziinowe ci meelik. Ma anek nɔɔgɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Iziiktɔ di! Anyak baale eet ci akɔ ḏowɛn. ");
INSERT INTO mur_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mazi akɔ aḏowɛ, iitazak ḏowo ogɛnɛ ŋinten gɔl, ma avu kibaali, ma avɛra ḏowɛn nicoko dook lai. ");
INSERT INTO mur_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Maje ḏowo ogɛnɛ iinak tɔdɔ ŋinten biyɛn, ma aduŋna kataman nɔkɔ, eeci akɔm tɔdɔ ci meel. ");
INSERT INTO mur_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mazi aaranɛ kɔr, araabjai lai, eeci akɔm tɔdɔ ci ka kuruktɛkɛ agɛrɔ looc juruŋ. ");
INSERT INTO mur_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bodo ḏowo ogɛnɛ iinak bila, bar mazi aduŋna, eedit bila nɔɔgɔ, makacin alaŋaan anyak kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Maje ḏowo ogɛnɛ iinak tɔdɔ ci abon, ma aduŋna juruŋ, ma adikir, ma abiirna kɛbɛrɛ. Ceegi anyaa kɛbɛrɛ ci miliny. Ceegi anyaa kɛbɛrɛ ci meelik kidicilim. Maje ogɛn anyaa kɛbɛrɛ ci meelik ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Zin enek Yesu nɔɔgɔ nɛ, “Mã anyaku iin, abon aziiŋnu zoozok nicoko juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mazi azaani ɔl, aavu Yesu niini doon. Ma avunak nuyawa oginɛ kibeen buk ɔl oogi nɔɔnɔ, ma avu ajin niigi nɔɔnɔ keŋti ci zoozok nicoko. ");
INSERT INTO mur_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma anek niini nɔɔgɔ nɛ, “Anyozozeyuŋ igeet gɛnyizi ci ka agayi baliin o Joowo. Maje ɔl ogɛn azii gɔɔn niigi zoozok yabziinta. ");
INSERT INTO mur_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Bar alaŋ aga niigi zoozok nicoko keŋti cigeec juruŋ. Waan tɛ kagaac, atu waan niigi Jook, ma aara Jooi oŋeeti ugeec.” ");
INSERT INTO mur_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ma anek Yesu nɔɔgɔ nɛ, “Alaŋ agayu kɛŋ ci yabziin nico? Mã alaŋ agayu kɛŋ ci yabziin nico, ka zin tiŋeere agaac yabziinok o ŋaan kuduwayuŋ dook ku? ");
INSERT INTO mur_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kɛŋ zin ci yabziin nico nɛɛn ce. Ma ḏowo ci aḏok ɛɛti o zɔɔz o Joowo nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma ɔl ogɛnɛ atobɔ niigi ki gɔl kɛŋ o iinak ḏowo e. Eeci ma azii niigi zɔɔz o Joowo, taman nɔkɔ aku Loryen, ma aara zɔɔz o Joowo zinzeetine ugeec. ");
INSERT INTO mur_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma ɔl ogɛnɛ atobɔ ki tɔdɔ ween biyɛn e. Eeci ma azii niigi zɔɔz o Joowo, agama niigi labak talniinta. ");
INSERT INTO mur_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bar alaŋ akɔ zɔɔz nici zinzeetine ugeec eecitɔ juruŋ, ma alaŋ atuwe ŋinti wun. Mazi avunak piryakzɛt nɔɔgɔ tuwente uneeŋ, ooŋ niigi tuwɛn enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma ɔl ogɛnɛ atobɔ ki tɔdɔ o anyak bila e, eeci nicigi azii zɔɔz o Joowo, ");
INSERT INTO mur_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Maje bar ŋaato iinon bodo niigi kaal o loocu, ma arɔɔŋ niigi kaal o arokzetu dook, ma kaal nicigi dook avɔ zinzeetine ugeec, ma adaal zɔɔz o Joowo zɛɛ makacin ɔkɔma nɔɔgɔ tuwɛn. ");
INSERT INTO mur_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma ɔl ogɛnɛ atobɔ ki tɔdɔ o abon e, eeci azii niigi zɔɔz o Joowo, ma atuwe juruŋ. Ma anyek tuwɛn cineeŋ noko nɔɔgɔ kiziti ɔl ci abon kiyo labina o anyaa kɛbɛrɛ o miliny, ki kɛbɛrɛ o meelik kidicilim, kibeen kɛbɛrɛ o meelik ɔrɔɔt e.” ");
INSERT INTO mur_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ma anek Yesu ɔl bodo yabziinte oman nɛ, “Gɔɔn mã avaat ɛɛti lamba, alaŋ abuŋ ija, karabɔŋ buk alaŋ arek kɛrca loota. Bar arek niini lamba tarabeza taden. ");
INSERT INTO mur_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Zin gi o aroodi inoko, katin abɔryai. Buk gi o abuŋe inoko, katin ayelzai. ");
INSERT INTO mur_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zin mã anyaku iin, iziiyit zoozok nicoko juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma anek Yesu nɔɔgɔ nɛ, “Aryek zinzeeti zoozok ci ona aziiknu noko juruŋ. Acaca tiŋeere Jooi kaal o gɔɔn agooneku niiga ɔl oogi gole ci atobɔ kibeen kaal o agooneku niiga nɔɔgɔ. Ma bar acaca niini ŋaatunooŋ ɔrɔɔt ɛlɛ kujuk niceke. ");
INSERT INTO mur_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Eeci ɛɛti ci anyak gi ci anyak anyonek bodo nɔɔnɔ ci appe. Maje ɛɛti ci akɔm gi ci anyak, mayo nuun anyak niini ci miliny, aamnyai koca bar nici ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ma bodo anek Yesu nɔɔgɔ yabziinte oman nɛ, “Ma baliin o Joowo atobɔ kibeen eet ci aḏowɛ mane cin. ");
INSERT INTO mur_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mazi adica ḏowɛn, ook niini aavu ɔlɔ labak. Ma aduŋna labina niigi doon, ma iŋaaz, bar alaŋ niini aga iŋaaz labina ku. ");
INSERT INTO mur_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ma tɔdɔwa alya anyek labi kudunta, ma abiir. Rak ɔɔwa anyek nɔɔgɔ kanyayit kaŋaya. Ma bodo anyek kobolbolanit, ma vurta aduŋna ooti, ma abiir kanyayit kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mazi avɔ adɔi, atɛɛda niini nɔɔgɔ ecodoi nɔkɔ, eeci izi iiten ci teedinto.” ");
INSERT INTO mur_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ma anek Yesu nɔɔgɔ nɛ, “Kayo kayabiztek baliin o Joowo gitaz? Atobɔ yo niini kibeen naa? ");
INSERT INTO mur_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Atobɔ zin baliin o Joowo kibeen keberec o motoŋtoco miliny tɛr gɔɔn aduŋna mana o. ");
INSERT INTO mur_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mazi akɔ aduŋna, iŋaaz ma adikir ɔrɔɔt kujuk kɛɛn dook, ma akanek oto ci appintik, ma ɛɛnyci kibaali ceezi.” ");
INSERT INTO mur_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ma aduwak Yesu ɔl zoozok yabziinowe ogɛn bodo. Aduwak niini nɔɔgɔ zoozok waakcaye ci meel ka kiziiyit juruŋ. ");
INSERT INTO mur_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aduwak niini nɔɔgɔ zoozok dook yabziinta, bar mazi aromɛ niini kibeen nuyak ogin doon, oobek nɔɔgɔ zoozok keŋti labak. ");
INSERT INTO mur_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma iitene nice ɛlɛ yomana enek Yesu nuyak ogin nɛ, “Abon di kavɔ liil baagita.” ");
INSERT INTO mur_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma adotek nuyawa kɔlɛ looc, ma atɔɔt kavool. Maje uyene Yesu arayɛ ook kavoola laadun. Ɔtɔɔzɔ ni niigi dook kibeen nɔɔnɔ. Buk anyak kavoolɛt oogi ci ɔrkɔr ki nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ŋintimiliny nɔkɔ iiya ŋɔɔti ci appe ɔrɔɔt ɛlɛ, ma ayɛlyɛlanek maam kavool zɛɛ ma arɔɔŋ abiz kavooli. ");
INSERT INTO mur_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Maje Yesu ɔɔŋ kavool vurta aruk ɔɔ ruma. Ma iiŋka niigi nɔɔnɔ anek nɛ, “Gayoi, alaŋ abaaban zɔɔz ci ka kadaakti naaga o?” ");
INSERT INTO mur_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma iŋaaz Yesu, ma agernyek ŋɔɔt anek nɛ, “Bil.” Bodo anek liil nɛ, “Tivanɛ.” Makacin didi ibil ŋɔɔti, ma azi maama jaŋ. ");
INSERT INTO mur_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma anek Yesu nuyak nɛ, “Aŋolinu naa? Ŋaan dim akɔmnuŋ igeet tuwɛn nɔkɔ?” ");
INSERT INTO mur_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Bar enico anyayit niigi ŋoliin ci appe ɔrɔɔt. Ma anɔ nɛ, “Mayo ɛɛti nici abil ku? Akɔ zɛɛ ma een nuun ŋɔɔt kibeen liil azii buk zɔɔz cin!” ");
INSERT INTO mur_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Abaayizit ni Yesu kibeen nuyak ogin liil o kazi Galili, ma avɔ baagite o looc o ɔl o kazi Garazin. ");
INSERT INTO mur_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Mazi aduŋna Yesu kavoola, taman nɔkɔ iiyak nɔɔnɔ ɛɛti ci anyak miniŋit ci Loryento. ");
INSERT INTO mur_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Anyak ɛɛti nici miniŋit nico alya, ma akɔ gɔɔn abaak niini bɔɔtwane o ɔl o adaai. Ma akɔm ɔl ci ka koolit nɔɔnɔ cabiinta been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Acap gɔɔn ɔl nɔɔnɔ azɛɛn kibeen zɔɔ ziiyi lak ci meel gɛr, bar enicoko dook aŋaak niini ziik nicoko. ");
INSERT INTO mur_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tup nɔkɔ agɛrɛny niini waazinok ki baalinok bɔɔtwani ki biyɛnɛ. Ma atatac ɛlɛ biyɛnɛ. ");
INSERT INTO mur_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mazi acina niini Yesu rɛɛna, adokonyonek nɔɔnɔ, ma akɔ akani kozoŋti looc nɔɔnɔ kɛŋa. ");
INSERT INTO mur_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ma anek Yesu miniŋit ci Loryento o nɛ, “Duna eete nico.” Ma agɛrɛny miniŋit molowe ci appe azi nɛ, “Yesu ŋɛɛrti Jook o adikir, arooŋ ŋaatan gitaz? Kalayin ineet zaare o Joowo ka calaŋ uulalan.” ");
INSERT INTO mur_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ma ajin Yesu miniŋit nico anek nɛ, “Kazi zaar cugun nɛ?” Abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Kazi zaar cigan nɛ Kɔlɛ, eeci keegina naaga mɛɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ilalek miniŋa Yesu ɔrɔɔt ka calaŋ atooyek niini nɔɔgɔ looc oma. ");
INSERT INTO mur_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Maje ŋinaante anyak kɔcɔcɔbanɛn ci meelik gɛr agɛ biya. ");
INSERT INTO mur_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma ilalek miniŋa ci Loryento noko Yesu anek nɛ, “Nyet koota kɔcɔcɔbanene niceke ka kɔɔt kabaakta eleetine ŋaatineeŋ.” ");
INSERT INTO mur_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Anyek ni didi Yesu nɔɔgɔ kudunta eete nico kɔɔtɔ kɔcɔcɔbanɛnɛ, ma avɔ didi niigi ŋaatineeŋ. Ma avira kɔcɔcɔbanɛna voroora, ma iinak liil kutudude dook lai. Maje kɔcɔcɔbanɛna nicigi dook een eet tur lak eetom (2000). ");
INSERT INTO mur_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Odokonyit ni ɔl ona oowa kɔcɔcɔbanɛn e, ma avɔ aduwak ɔl o eevyi manɛɛni kibeen ɔl dook kutura zɔɔz nico. Ma avu ɔl dook ka kivita kicinit gi ci akanai o. ");
INSERT INTO mur_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mazi avunak ɔl Yesu, bar amada niigi eet baal gɔɔn anyak miniŋ o Loryento meelik e aavi loota ŋinaante. Anyawun niini rum alya, ma buk obona nɔɔnɔ ɔɔ oninɛ labak. Anyayit ni niigi dook ŋoliin ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Maje ɔl ona icinit gi o agoononek eet nico kibeen kɔcɔcɔbanɛn ɔɔwa e, uduktak buk niigi gɔnɔgi gi nico. ");
INSERT INTO mur_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ilalek ni niigi Yesu kɔtɔɔ looce cineeŋ o. ");
INSERT INTO mur_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Mazi atɔɔt Yesu kavool, ilalek ɛɛti ci ona anyak miniŋ ci Loryento noko Yesu ka korkorit kibeen nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bar ujura Yesu ŋaati ɔrkɔri ki nɔɔnɔ, ma anek nɛ, “Bitɔ ɔlɔ atenowe ugun ka bitɔ duwak nɔɔgɔ gi ci abon atiritin Manyi ineet noko.” ");
INSERT INTO mur_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɔtɔɔ ni ɛɛti nici, ma akɔ azɔp kuturyok ween amɔtɔ aduwak ɔl gi ona agoonek Yesu nɔɔnɔ e. Ma abiir ɔl dook ooti zooze nico. ");
INSERT INTO mur_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mazi amiironek Yesu baagit, ivitak kɔlɛ ci appe nɔɔnɔ liiltoga. ");
INSERT INTO mur_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma ŋinaante iiya alaani ci ceez o lotento. Kazi alaan nico zaar nɛ Jairas. Mazi acin niini Yesu, iiya aavek nɔɔnɔ loota kɔpɔkpɔk. ");
INSERT INTO mur_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma ilalek nɔɔnɔ ɔrɔɔt ɛlɛ anek nɛ, “Bɛɛnyan o miliny amɔɔr ɔrɔɔt, ma arɔɔŋ kadaak. Ija da taadek nɔɔnɔ aziit ka korok.” ");
INSERT INTO mur_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Orkorit ni Yesu ki nɔɔnɔ. Maje kɔlɛ ci appe ɔrɔɔt ano buk nɔɔnɔ, ma iiciwɔ ɔl nɔɔnɔ kabanyɔi zɛɛ makacin oyootit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Maje ŋinaante anyak ŋaa ci amɔɔr maam o ŋaanu irkitok amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Amɔɔr niini ɔrɔɔt, ma azɔp akimanɛ ci meel gɛr irkitok dook, ma ŋaan kizi maya nɔkɔ, bar azaaci mɔɔrizi ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mazi azii niini zɔɔz o arogzi Yesu ɔl o amɔɔr, iiya buk niini, ma akɔ kɔla eecitɔ, ma icaya zɛɛ ma apadan Yesu eci bawuco, ma uum nɔɔnɔ rum. ");
INSERT INTO mur_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Agɔɔn nɔkɔ o, eeci abaaban niini azi nɛ, “Mã nuun inoko kuum rum cin o ɛlɛ doon, keen koca maya.” ");
INSERT INTO mur_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mazi didi uum niini Yesu rum, eelit maama enico ɛlɛ, alaŋaan aduŋna. Makacin agawun niini ɛlɛ onin izi didi maya. ");
INSERT INTO mur_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Maje Yesu aga nɔkɔ uduna ŋaatin dɔyizi ci miliny, ma ookconek kɔlɛ enico ɛlɛ, ma azi nɛ, “Ŋɛnɛɛn ci uum rum can o?” ");
INSERT INTO mur_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma anek nuyawa nɔɔnɔ nɛ, “Aga niina iiciwonun ineet ɔl ci meelik gɛr noko. Ajinei zin ku azi nɛ, Ŋɛnɛɛn ci uum rum can o?” ");
INSERT INTO mur_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Maje Yesu agɛlɛm nɔɔgɔ dook arɔɔŋ kicin ŋɛnɛɛn ci uum nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Maje ŋaa nicini aga gi o agooni alye onin. Iiya ni niini ŋoliinta kabarit kɛdɛkɛdɛk, ma aku aavek Yesu loota kɔpɔkpɔk, ma aduwak nɔɔnɔ gi ci ona agɔɔn niini o. ");
INSERT INTO mur_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Enek ni Yesu nɔɔnɔ nɛ, “Bɛɛnyan, anyin tuwɛn unun ineet izi maya inoko. Zin tɔ talniinta. Alaŋ mɔɔrizi nici abadakin bodo.” ");
INSERT INTO mur_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mazi ŋaan azɔɔzɔ Yesu kibeen ŋaa nico nɔkɔ, ivita ɔl ogɛnɛ ole o Jairas, ma avu anek nɔɔnɔ nɛ, “Adaak dole unune. Má ŋaan amila gayoi gaga.” ");
INSERT INTO mur_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mazi azii Yesu zɔɔz ci aduwa ɔl nicigi o, enek niini Jairas nɛ, “Má anyei ŋoliin gaga. Tuwɔ labak.” ");
INSERT INTO mur_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mazi ka kook niini ole o Jairas, alamun ɔl o ano nɔɔnɔ e dook, ma ɔrkɔr niini ki Pitɔr ki Jemis kibeen Jɔn ween gɔtɔni Jemis doon. ");
INSERT INTO mur_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mazi avɔ ajɔŋɔz niigi kɔrɔk o Jairas, azii niini ɔl luwa. Iboobi niigi ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma akɔ niini kɔrga eecitɔ, ma anek nɔɔgɔ nɛ, “Naa? Aluyu naa? Dole alaŋ adaai, bar olla ɔɔŋ niini labak.” ");
INSERT INTO mur_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bar apɛz ɔl zɔɔz cin o. Otooyek ni niini nɔɔgɔ dook bitaalin. Ma akɔyi baati doleco been yaatin kibeen nuyak ogin een iiyu, ma avɔ ceeze ci ɔɔŋɛ dole o. ");
INSERT INTO mur_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma agam niini dole aziit, ma anek otoge uneeŋ nɛ, “Talita koom.” Ma kɛŋ ci zɔɔz nico kazi nɛ, Bɛɛnyan, tiŋa jena. ");
INSERT INTO mur_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Enico ɛlɛ itiŋa didi dole jena, ma awɔ. Maje irkitowa ci doleco tiryanto een amɔtɔ ram. Ma abiir ɔl ona ɔrkɔr ki nɔɔnɔ e dook ooti ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ma aricanek niini nɔɔgɔ ɔrɔɔt ka calaŋ aduwak ɔl oogi gi nico. Ma anek niini nɔɔgɔ nɛ, “Anycek dole gi ci adak.” ");
INSERT INTO mur_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma vurta ɔtɔɔ Yesu imiirozek kutur onin kazi Nazarɛt. Ɔrkɔr kibeen nuyak ogin. ");
INSERT INTO mur_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma iitene o yubzento kazi Sabit ook ɛdɛmɛz niini ɔl ceeze o lotento. Mazi azii ɔl ci meel demziin cin o, ibiirit nɔɔgɔ ooti tɛt. Ma ajinɔ anɔ nɛ, “Ma ɛɛti nicini ajowa kaal nicoko ŋaa? Gɛnyiz taz ci anyonek nɔɔnɔ o? Ma liŋliŋɔn ci atɛɛt ɔl biye noko ajowa niini ku? ");
INSERT INTO mur_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Alaŋ een eet o gɔɔn abaac kɛɛn o nɛɛn? Alaŋ een niini ŋɛɛrti Meri? Alaŋ een niini gɔtɔni Jemis ki Josev ki Judaz been Saiman? Alaŋ een ŋɔɔnɔgi nɛɛn o gɔɔn karomɛ ŋina o?” Zin giye o agawi niigi nɔɔnɔ, otoborit niigi demziin cin. ");
INSERT INTO mur_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma anek Yesu nɔɔgɔ nɛ, “Gɔɔn laadun nyakaŋan atitiny ɔl nɔɔnɔ loocowe dook, maje bar ɔl o kutur onin been atenok ogin ɛlɛ alaŋ atitiny nɔɔnɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Zin giye nico alaŋaan Yesu anim kutugu kaal ci atɛɛt ɔl biye ŋinaante, bar olla ataadek niini azɛɛn ɔl ci miliny amɔɔr, ma arogoz nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma abiir Yesu ɔɔ ɔrɔɔt, giye ci ɔl o kutur onin ɛlɛ alaŋ atuwi zɔɔz onin o. Ma azɔp Yesu korogjok adɛmɛz ɔl vitɛnane niceke. ");
INSERT INTO mur_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ma awa niini nuyak ween amɔtɔ ram, ma itoon nɔɔgɔ korkorit gɔɔn raman, raman. Ma anyek nɔɔgɔ dɔyiz ci atɔɔi miniŋ o Loryento ɔla. ");
INSERT INTO mur_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma aricanek niini nɔɔgɔ gi ci anek nɛ, “Má avoyu dayiin ki guruc been kaboot ci anyaku kaal. Bar olla anyayit kɛɛn ci omtinto doon. ");
INSERT INTO mur_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ooti caava kibeen rumanɛ ci anyaku eleetinɛ o doon kɔkɔm bodo oogi. ");
INSERT INTO mur_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mã atalnanuŋ ɔl ŋaaman, aavtiz ole nico zɛɛ ma awoyu looce nico. ");
INSERT INTO mur_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mã anyak ŋinti alaŋ atalnanuŋ ɔl igeet, ma alaŋ azii niigi zɔɔz cunooŋ o, otoŋit ŋinito. Utuduŋta tɔdɔ zɔɔnɛ ka keyeliza gi nici gi o aborni niigi zɔɔz onan.” ");
INSERT INTO mur_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mazi akɔ aṯornɛkɛ Yesu zɔɔza, ɔtɔɔzɔ ki nuyak, ma avɔ uuwayek ɔl gi ci anek nɛ, “Eteedɔi oŋɛ ugooc.” ");
INSERT INTO mur_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma atɔɔk niigi miniŋ o Loryento ole ci meelik, ma avuut ɔl ci meelik amɔɔr ooti maala, ma arogoz nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ma adala awaŋi ci kaal o agɔɔn Yesu ɔl dook, makacin iziik buk alaani o kazi Erod kaal nicoko dook, eeci azi ɔl ogɛnɛ nɛ, “Bar bɔŋ nicini Jɔn o oonyi nɛɛn urugun bodo daayiza. Gi ci inoko agooninɛ kaala ci atɛɛt ɔl biye noko nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma bodo azi ɔl ogɛnɛ nɛ, “Bar bɔŋ Ilija gi.” Maje ɔl ogɛnɛ azi nɛ, “Coma een nyakaŋan ci Joowo atobɔ kibeen nyakaŋanɛt o rɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mazi azii Erod gi nico, izi nɛ, “Inoko ɛɛti nici Jɔn baal oony ɔl baal kanyi takiren kɛtɛɛda ɔɔ e nɛɛn. Urugun inoko bodo niini daayiza.” ");
INSERT INTO mur_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Azi Erod nɔkɔ o, eeci baale anyek niini takirnya kagamit Jɔn, ma arek sijin. Agɔɔn niini gi nico o, eeci waanice aama niini Pilip ween gɔtɔni ŋaa onin kazi Erodiyas. ");
INSERT INTO mur_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Iiya ni Jɔn o oonyi, ma anek Erod nɛ, “Gɛrzɛ gi ci aamanɛ gotonu ŋaa cin noko.” ");
INSERT INTO mur_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Otoborek ni Erodiyas Jɔn nɔŋ, ma arɔɔŋ kuruk nɔɔnɔ kadaak, bar akɔm gɔl ci aruyi, eeci Erod alaŋ agama gi nico. ");
INSERT INTO mur_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aŋole niini Jɔn giye o ɛɛnɛ Jɔn eet ci Joowo abon. Ebewun ni Erod nɔɔnɔ, ma arɛɛz ŋaati aziikni kaal ci uuwak Jɔn, mayo nuun gɔɔn iima amadik niini nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma vurta ojowa Erodiyas gɔl ci ka kurui Jɔn, eeci iitene oman awa Erod alaat o akumawo, ki alaat o takirnyawu, been ɔl o Galili een arɔk ka kivita kadayit kɔnyit ci aadanɛ niini iiten onin baal aritan e. ");
INSERT INTO mur_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Iiya ni tinati Erodiyas, ma aku arogom ɔl kɔrgɛna zɛɛ makacin ataltɔ Erod kibeen kernok ogin ɔrɔɔt ɛlɛ. Ma anek niini dole nɛ, “Mã anyak gi ci arooŋ, duwayan ka kanyin.” ");
INSERT INTO mur_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma aterkedek niini nɔɔnɔ bodo gi ci anek nɛ, “Olla gi ci ajinan aneet, kanyin. Yo nuun arooŋ keŋereyin alaazɛt can o kɔrgɛna, kanyin labak.” ");
INSERT INTO mur_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Udun ni dole ook bitaala, ma akɔ ajin yaatin anek nɛ, “Kijin baaba naa?” Ma abɛdɛkɛ Erodiyas nɔɔnɔ anek nɛ, “Jin baatun kɛtɛɛdayin ɔɔ o Jɔn o oonyi.” ");
INSERT INTO mur_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Abada ni dole enico ɛlɛ, ma aku anek Erod nɛ, “Karooŋ ɔɔ o Jɔn o oonyi. Nyaayan kodooca ŋina inoko ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mazi azii Erod zɔɔz nico, iinon zɔɔz nico, ma avir ziniz ɔrɔɔt, bar akɔm gi ci ka kɛɛla, eeci uyen eterkedek niini dole zɔɔz ci adɔi kak kernok kɔrgɛna. ");
INSERT INTO mur_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kataman nɔkɔ itoon niini takiren ka kook kɛtɛɛda Jɔn ɔɔ ka kanyaa. Ook ni takirɛnti sijina, ma akɔ atɛɛda Jɔn ɔɔ didi. ");
INSERT INTO mur_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ma anyaa ɔɔ kodooca, ma aku anyek dole. Ook ni dole anyek yaatin. ");
INSERT INTO mur_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mazi azii nuyawa o Jɔn gi nico, ivita ooti niigi nɔɔnɔ ɔɔt adaaca. ");
INSERT INTO mur_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mazi abada nuyawa keronnya, ivita uduktak niigi Yesu kaal o avɔ agɔɔn niigi dook kibeen kaal o adɛmɛz. ");
INSERT INTO mur_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Maje iitene nice anyak ɔl ci meelik avunak Yesu zɛɛ ma alaŋ ajowa niini been nuyak ogin waŋi ci ka kadaktɔi. Enewun ni Yesu nuyak ogin nɛ, “Kɔtɔɔz kɔɔtɔ ŋaati akɔm ɔl ka ɔɔtɔ uyubuzit ŋintimiliny ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɔtɔɔzɔ ni niigi kavoola ka kɔɔtɔ ŋaati akɔm ɔl. ");
INSERT INTO mur_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mazi awɔ, icinit ɔl ci meelik nɔɔgɔ. Ma giye o agayi niigi Yesu kibeen nuyak ogin, ivirtozek niigi kuturyowɛ dook ŋinti avɔyi niigi o, ma avir niigi baagitok dook zɛɛ ma avɔ arak ŋinite iŋaan niigi kurumit. ");
INSERT INTO mur_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mazi aduŋna Yesu kavoola, acin niini kɔlɛ ci appe ɔrɔɔt, ma awuci nɔɔnɔ ziniz ŋaatineeŋ ɔrɔɔt, eeci acin nɔɔgɔ ɛɛl kiyo ɛɛzana o akɔm tuwayoi o. Ma ademzek niini nɔɔgɔ kaal ci meel gɛr. ");
INSERT INTO mur_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma yomana ivitak nuyawa oginɛ nɔɔnɔ, ma avu anek nɛ, “Izi lɔɔci baalin, ma buk een ŋiniti balal. ");
INSERT INTO mur_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Anyek ɔl kazaantɛ kɔɔt korogjowe ci kajɔŋzɔ noko ka kɔɔt kataala kaal ci adak.” ");
INSERT INTO mur_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Anycek nɔɔgɔ dayiin niiga alya.” Ma anek niigi Yesu nɛ, “Alaŋ kanyaka guruc ci alɛɛnɔ ki dayiin cigeec dook.” ");
INSERT INTO mur_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma anek Yesu nɔɔgɔ nɛ, “Anyaku inoko dayiin ceen ku? Ɔɔtɔ di icinit.” Mazi avɔ acin, ivita enektek niigi nɔɔnɔ nɛ, “Kanyaka ḏɔkɛn ceen tur kibeen kuluk ram nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ma anek Yesu nuyak nɛ, “Ɔɔtɔ eŋerit ɔl kiziti kotorɛ. Anycek nɔɔgɔ kaavtiyɔ loota artene ci colai noko.” ");
INSERT INTO mur_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mazi aavtiz niigi loota, een gɔɔn kotoritin ceeni eet ram kamɔtɔ (50), maje ceegi een eet tur (100). ");
INSERT INTO mur_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Odoma ni Yesu ḏɔkɛn ceen tur o kibeen kuluk ceen ram o, ma acin tammu taden, ma anyek Jook zany. Ɛtɛɛt ni ḏɔkɛn, ma anyek nuyak ka keŋertek ɔl. Ma buk aŋerek kuluk nuyak ka keŋertek ɔl. ");
INSERT INTO mur_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma adake kɔlɛ oke dook zɛɛ ma apiiyani. ");
INSERT INTO mur_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma abitiz nuyawa gilanya ceen amɔnki ram tɔc dayiine ci anyigzai kulugɛ kibeen ḏɔkɛni. ");
INSERT INTO mur_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma ɔl ci adak dayiin noko o een ɔl ci mac doon eet tur lak eet ram kamɔtɔ (5000). ");
INSERT INTO mur_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kataman nɔkɔ enek Yesu nuyak ogin nɛ, “Ɔtɔɔz kavoola araktɛ ɔɔtɔ kuture o kazi Bezediya liil baagita.” Aavu ni Yesu niini doon ka rak kazaan kɔlɛ. ");
INSERT INTO mur_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mazi azaani kɔlɛ, ɔtɔɔ ni niini ook biya ka kook kaŋarowɔ. ");
INSERT INTO mur_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mazi akɔ arara lɔɔci yomana, urum kavoolɛ liil kɛŋ. Maje Yesu ŋaan aavi dɔwɔna niini doon. ");
INSERT INTO mur_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma acin niini nɔɔgɔ apirna ɔrɔɔt ɛlɛ wolinta, eeci atirginyɔ ŋɔɔt. Mazi agɔr tammu, iiyak Yesu nɔɔgɔ ŋaati awoyanɛ maam tadena. Arɔɔŋ niini ka kiiya kidicek. ");
INSERT INTO mur_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mazi acin niigi nɔɔnɔ awɔ maam tadena nɔkɔ, abaabanit izitɔ nɛ, “Coma bar een miniŋit.” ");
INSERT INTO mur_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ma acin niigi dook nɔɔnɔ ŋoliinta, ma agɛrɛny ɔrɔɔt ɛlɛ. Kataman nɔkɔ ozoozek Yesu nɔɔgɔ enek nɛ, “Agamit zinzeeti kodoyit. Aneeta Yesu gi. Má aŋolinu looc gaga.” ");
INSERT INTO mur_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iiya ni niini ɔtɔɔt kavool ki nɔɔgɔ. Taman nɔkɔ itivanɛ ŋɔɔti. Ma abiir nɔɔgɔ dook ooti ɔrɔɔt ɛlɛ, eeci ŋaan bakbayɛ nɔɔgɔ zinzeeti nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mayo nuun icinit niigi gi baal anyekɛ niigi dayiin o miliny kizi mɛɛlɛ e, ŋaan kagaac niigi dɔyiz o Yesu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mazi avɔ arum baagit o looc o kazi Genezaret, acabit kavool gɔgɔla ŋinaante. ");
INSERT INTO mur_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mazi aduŋna kavoola, kataman nɔkɔ agaac ɔl Yesu. ");
INSERT INTO mur_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma avironek ɔl korogjok ugeec. Ma avɔ adɔŋak niigi ɔl o amɔɔr kuwanɛ ŋinti aavɛ Yesu o. ");
INSERT INTO mur_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma ŋinti olla akɔyi Yesu kuturyowe o miliny, karabɔŋ een kuturyowe o adikir, anyaa ɔl gɔnɔgi o amɔɔr, ma avu arek looc mɛlɛgɛnyai. Ma ilalek ɔl ci amɔɔr o Yesu ka olla nuun kuumit niigi nɔɔnɔ rum. Zin didi ɔl o uumit rum onin orogit moorizoye ugeec. ");
INSERT INTO mur_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ma alotak ɔl o Parici kibeen ɔl o demziinto avu Jerusalɛma Yesu. ");
INSERT INTO mur_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma acin niigi nuyak o Yesu adake iŋaan kotoonyit azɛɛn keere uneeŋ. ");
INSERT INTO mur_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Eeci gɔɔn ɔl o Parici kibeen ɔl o Juz oogi alaŋ adake iŋaan kotoonyit azɛɛn giye o agami niigi kɛɛranɛ o jijitigeec. ");
INSERT INTO mur_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gɔɔn ma anyaa dayiin mɛlɛgɛnyai, alaŋ adak iŋaan rak kotoonyit. Ma azooni buk niigi kɛɛranɛ ci meelik oogi kiyo onyɛn ci diicitu ki ijunya been alawɛt e. ");
INSERT INTO mur_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ivita ni ijinit ɔl o Parici kibeen ɔl o demziinto Yesu enektek nɛ, “Dim nuyawa cugune o gɔɔn alaŋ azooni kɛɛranɛ o jijitigaac o naa? Adake gɔɔn niigi calaŋ oony azɛɛn o naa?” ");
INSERT INTO mur_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Igeet ɔl ci abuuku eleeti coko, aduwa da baale nyakaŋani o kazi Izaya zɔɔz ceen didi giye ci akanuŋ igeet. Ayɛɛt baale niini zɔɔz ci aduwa Jooi azi nɛ, Gɔɔn ɔl nicigi adiŋdiŋanan aneet utugetinɛ doon. Maje zinzeeti cigeec o adɛyai ŋaatan many. ");
INSERT INTO mur_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Alaŋ zin niigi aganɔ ŋaati adiŋdiŋanan aneet, eeci arican niigi demziin ci kɛɛranɛ ugeecik ɔrɔɔt kujuk demziin ci zɔɔz onan.” ");
INSERT INTO mur_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ma anek Yesu bodo nɔɔgɔ nɛ, “Alɛɛm zin da Izaya didi. Alaŋ niiga azoonu lotinok o Joowo, bar azoonu kɛɛranɛ ci ɔl ci deer. ");
INSERT INTO mur_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Abaabanu niiga kiziik bar agenyu giye ci aburnu lotinok o Joowo, ma bar azoonu kɛɛranɛ cugooc o. ");
INSERT INTO mur_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ayɛɛt Mosis baale zɔɔz baal aricanek Jooi nɔɔnɔ azi nɛ, Tɔŋɔlɛ baatun ki yaatun. Mã adɔm ɛɛti baatin ki yaatin, abon aruk ɔl nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Maje bar niiga ademzonu anonu nɛ, Ma alam gi ci ka kitirti ɛɛti baatin karabɔŋ een yaatin, abon anek nɔɔgɔ nɛ, Alaŋ katirituŋ igeet, eeci kanyeya gi nico Jook. ");
INSERT INTO mur_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Zin gole nico imilmilantu niiga nɔɔnɔ calaŋ atirit baatin ki yaatin. ");
INSERT INTO mur_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma buk gole nico epeztu niiga zɔɔz o Joowo kizi gi ci labak kaale cugooc ademzeku ɔl noko. Ma anyak buk kaal oogi ci meel gɛr atobɔ kibeen nicoko gɔɔn agoonu niiga.” ");
INSERT INTO mur_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Zin bodo otowa Yesu ɔl, ma aku anek nɛ, “Iziiktɔ di niiga dook ka agaac zɔɔz ci ka karooŋ kuduwayuŋ ce. ");
INSERT INTO mur_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Akɔm laadun gi ci adak ɛɛti ci deer otoga, ma anyek eet kizi gɛrzɛ ŋume o Joowo kina. Bar zin gi o gɛr gɔɔn aduŋna zinize ci eet ci deer nɛɛn o agɛrɛzan nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mã anyaku iin, iziiyit zɔɔz nico juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma vurta ook Yesu ceeza otoŋek kɔlɛ looc, ma avunak nuyawa nɔɔnɔ, ma avu ajin kɛŋ ci demziin nico. ");
INSERT INTO mur_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma anek niini nɔɔgɔ nɛ, “Alaŋ agayu kɛŋ ci demziin nico niiga buk? Abon waan agayu niiga dayiin o avɔ eet ci deer kɛŋa alaŋ anyek eet kizi gɛrzɛ ŋume o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eeci dayiin alaŋ avɔ ziniza, bar avɔ kɛŋa ma aduŋnak bitaalin.” Aduwa Yesu gi nico o arɔɔŋ ka keyelek ɔl gi o abonan dayiin dook ŋaati kadayi. ");
INSERT INTO mur_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma anek bodo Yesu nɔɔgɔ nɛ, “Bar zin gi o gɔɔn aduŋna eet ziniza nɛɛn o anyek nɔɔnɔ kizi gɛrzɛ ŋume o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Eeci zinize ci eet ci deer o aduŋnan baabani ci gɛrzɛ, ma anyek nɔɔnɔ kutugu kaal ci gɛr kiyo waaŋ, ki agɔr, ki monyɛnɛt, ki zoocmazit, ki ziniz appinzɛt, ki labaan, ki madkɛn, ki ŋomtiin, ki eleeti doŋi, kibeen tarbalzɛt. ");
INSERT INTO mur_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aduŋna kaal nici dook zinize ci eet ci deer, ma anyek nɔɔnɔ kizi gɛrzɛ ŋume o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Zin itiŋa Yesu ook looce ci ajɔŋɔz kutur o kazi Tayor. Mazi akɔ arum ŋinite, ook ceeze oman eecitɔ, ma akɔ aavi ŋinaante, eeci alaŋ arɔɔŋ niini keyelizak ɔl ɛlɛ, bar zin ojokta niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma ŋinaante iziiwun buk nɔɔnɔ ŋaa oman ci anyak bɛɛnyin miniŋit ci Loryento. Iiyak ni niini nɔɔnɔ, ma aku aavek loota kɔpɔkpɔk. ");
INSERT INTO mur_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Maje ŋaa nici niini dole ci modo o kazi Garik, ma aritai niini kuture o kazi Venosiya o abil looce o kazi Siriya. Ilalek ni niini Yesu ka kɔtɔɔk miniŋit o Loryento dolece cin o. ");
INSERT INTO mur_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nyan rak aneet kitirit ɔl ogan, eeci alaŋ abon ŋaati kajukɛkɛ dayiin ci dolenu o orze.” ");
INSERT INTO mur_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Didi Manyi, ŋɛdɛt aleem zɔɔz nico, bar zin gɔɔn buk orze avɛr zurzuryak ci iina ŋaati adayin dɔlya labak.” ");
INSERT INTO mur_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Enek ni Yesu nɔɔnɔ nɛ, “Giye o uduwayɛ zɔɔz ci aleem, ɔtɔɔyɛ miniŋit o Loryento dolece unun. Bitɔ ɔlɔ labak.” ");
INSERT INTO mur_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mazi akɔ ŋaa ɔlɔ, amada dole ɔɔŋ kɛrca. Akɔma didi miniŋit o Loryento ŋaatin. ");
INSERT INTO mur_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ma iŋaaz Yesu kuture o kazi Tayor, ma akɔ adiir kutur o kazi Sidon been kuturyok ween amɔtɔ, ma akɔ alocak liil o kazi Galili. ");
INSERT INTO mur_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ŋinaante anyaaktak ɔl nɔɔnɔ eet ci adiiti iina, ma alagonyi aati calaŋ azɔɔz. Ma ilalek niigi nɔɔnɔ ka kataadek eet nico aziit ka kitirit kizi maya. ");
INSERT INTO mur_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Alakada ni Yesu eet nico doon ɔla. Ma akɔ azuwek azɛɛn iin ci eet nico o, ma oortek amot aziit, ma uum aat. ");
INSERT INTO mur_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma acin tammu tadena, ma akɔla ziniz, ma anek nɔɔnɔ otoge uneeŋ nɛ, “Avta.” Ma kɛŋ ci zɔɔz nico azi nɛ ziiwɔ. ");
INSERT INTO mur_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Makacin didi ɔkɔltɛ eet nico iina oginɛ, ma buk oogji aati kɔzɔɔz labak enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ma aricanek Yesu ɔl dook anek nɛ, “Má aboranu zɔɔz nico.” Bar ma aricanek niini nɔɔgɔ calaŋ abɔra zɔɔz ci abil nɔkɔ, bar avɔ aduwa niigi gi nico ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma ɔl o azii zɔɔz nico abiir nɔɔgɔ ooti ɔrɔɔt, ma anɔ nɛ, “Kaala ci agɔɔn Yesu noko dook abon ɔrɔɔt ɛlɛ. Ma een nuun ɔl ci adiiti iina anyek niini nɔɔgɔ kiziiktɔ. Buk ɔl o adiiti alemeti anyek nɔɔgɔ kozoozit labak.” ");
INSERT INTO mur_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma ŋintimiliny iinyaye ogɛn olotak bodo kɔlɛ ci appe Yesu. Mazi akɔ adicai dayiin ugeec, otowa Yesu nuyak ogin, ma anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Inoko awuci ziniz ole nicoko, eeci karomena ki nɔɔgɔ iinya iiyu, makacin idicai dayiin ugeec anyak. ");
INSERT INTO mur_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mã kitoonei nɔɔgɔ korogjok magizɛt nɔkɔ, avɔ koca aval gɔla, eeci ɔl ogɛn ŋaatineeŋ avu rɛɛna.” ");
INSERT INTO mur_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma anek nuyawa nɔɔnɔ nɛ, “Mazin yo balale nico ka kojokta dayiin ci alɛɛnɔ ki ɔl nicoko ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma ajin Yesu nɔɔgɔ anek nɛ, “Inoko anyaku ḏɔkɛn ceen izɔk?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kanyaka ḏɔkɛn ceen torgɛrɛm.” ");
INSERT INTO mur_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Uduwak ni niini kɔlɛ kaavtiyɔ loota. Ma adoma ḏɔkɛn ceen torgɛrɛm noko, ma anyek Jook zany, ma atɛɛt ḏɔkɛn, ma anyek nuyak ka keŋeryek ɔl. Ma aŋerek niigi ɔl. ");
INSERT INTO mur_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Anyak buk niigi kuluk ci miliny. Ma anyek bodo Yesu Jook zany kuluge nicoko, Ma anyek nuyak ka keŋertek ɔl buk. ");
INSERT INTO mur_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma adake ɔl nicigi dook zɛɛ makacin ipiiyantɛ. Ma alota nuyawa zurzuryak ci anyigzai o, ma abitiz gilanya torgɛrɛm. ");
INSERT INTO mur_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Maje ɔl ci ona adak dayiin noko o een eet tur lak eet ram (4000). Azaanun ni Yesu nɔɔgɔ kɔɔt korginɛ. ");
INSERT INTO mur_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma ŋintimiliny nɔkɔ otoodit niini ki nuyak ogin kavool, ma abaayiz liil avɔ looce o kazi Dalmanuta. ");
INSERT INTO mur_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Zin ivitak ɔl ci Parici ogɛn Yesu, ma avu adaŋɔ ki nɔɔnɔ. Arɔɔŋ niigi kicinta Yesu, ma ajin nɔɔnɔ ka kutugu nɔɔgɔ liŋliŋɔn ci atɛɛt biye ci aku Joowa. ");
INSERT INTO mur_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ma akɔla Yesu ziniz, ma azi nɛ, “Akɔ ma arooŋnyu icinit liŋliŋɔn ci ateeduŋ biye o naa? Didilɛ kaduwakuŋ igeet, alaŋ kayelekuŋ igeet liŋliŋɔn ci ateeduŋ biye been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma ooŋnek niini nɔɔgɔ looc, ma atɔɔt kavool, ma akɔ liil baagita. ");
INSERT INTO mur_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mazi awɔ niigi, erektek nuyak dayiin ŋinaante, ma bar ajowa ḏokoc codoi ṯɔr nɔkɔ kavoola. ");
INSERT INTO mur_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma anek Yesu nuyak nɛ, “Egenyit gerzitine o ɔl o Parici kibeen gerzitin o Erod o atobɔ ki nyigit o gɔɔn adɛni ḏɔkɛna o.” ");
INSERT INTO mur_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bar nuyawa alaŋ aga kɛŋ ci zɔɔz ci aduwak niini nɔɔgɔ o, ma aŋɔmtɔ anɔ nɛ, “Aduwa bɔŋ Yesu gi nico o, eeci akɔmnet ḏɔkɛn.” ");
INSERT INTO mur_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Maje Yesu aga ŋomtiin cineeŋ o nɔkɔ, ma ajin nɔɔgɔ anek nɛ, “Aŋomotu zɔɔz ci akɔmnuŋ ḏɔkɛn o naa? Ŋaan dim niiga agayaŋ aneet nɔkɔ? Ŋaan bakbayɛ igeet zinzeeti nɔkɔ? ");
INSERT INTO mur_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Anyaku kɛbɛrɛ, ma alaŋ acinenu. Anyaku iin, ma alaŋ aziiŋnenu. ");
INSERT INTO mur_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Alaŋ aadanu ḏɔkɛn baal kanyi ɔl ween eet tur lak eet ram kamɔtɔ (5000) e? Mazi baale ipiiyantɛ niigi e, alotanu waanice gilanya izɔk dayiine o anyigzai?” Ma anek niigi nɔɔnɔ nɛ, “Kalotana gilanya amɔtɔ ram.” ");
INSERT INTO mur_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma bodo anek Yesu nɔɔgɔ nɛ, “Abon buk aadanu ḏɔkɛn baal kanyi ɔl ween eet tur lak eet ram (4000) e. Mazi baale ipiiyantɛ niigi e, alotanu gilanya izɔk dayiine o anyigzai?” Ma anek niigi nɔɔnɔ nɛ, “Kalotana gilanya torgɛrɛm.” ");
INSERT INTO mur_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma anek niini nɔɔgɔ nɛ, “Ŋaan zin agayaŋ nɔkɔ o naa?” ");
INSERT INTO mur_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mazi avunak Yesu kibeen nuyak ogin kutur o kazi Bezediya, anyaaktak ɔl nɔɔnɔ eet ci ruben, ma ilalek niigi nɔɔnɔ ka kuum eet nico ka kɔkɔl nɔɔnɔ kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma agam niini eet ci ruben noko aziit, ma aduŋni akɔyi kutur bitaala. Ma ŋinaante otorek amot nɔɔnɔ kɛbɛrɛ, ma ataadek nɔɔnɔ azɛɛn, ma ajin anek nɛ, “Inoko anyak gi ci acin?” ");
INSERT INTO mur_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma adɔŋ ɛɛti ci ruben noko ɔɔ, ma anek nɔɔnɔ nɛ, “Ii, kacin ɔl awɔ, bar olla ɛɛl kiyo kɛɛna o.” ");
INSERT INTO mur_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ma bodo ataadek Yesu azɛɛn nɔɔnɔ kɛbɛrɛ. Enico ɛgɛlɛm bodo ɛɛti looc, ma acin kaal dook juruŋ, eeci ɔkɔltɛ nɔɔnɔ kɛbɛrɛ wak. ");
INSERT INTO mur_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma anek Yesu nɔɔnɔ nɛ, “Inoko bitɔ ɔlɔ. Má amiironei kutur.” ");
INSERT INTO mur_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zin ɔtɔɔzɔ Yesu kibeen nuyak ogin ɔɔtɔ korogjowe o ajɔŋɔz looc o kazi Sisiriya Vilipai. Mazi ŋaan awɔ gɔla nɔkɔ, ijin Yesu nɔɔgɔ enek nɛ, “Gɔɔn dim yo azi ɔl nɛ, Keen naana ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Azi gɔɔn ɔl nɛ, Een Jɔn o oony ɔl. Maje ɔl ogɛnɛ azi nɛ, Een Ilija. Ma bar ogɛnɛ azi nɛ, Een nyakaŋan codoi nyakaŋanete o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma ajin niini nɔɔgɔ anek nɛ, “Ma niiga gɔɔn aniyu nɛ, Keen ŋɛnɛɛn?” Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Een niina Kiristo.” ");
INSERT INTO mur_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iricanek ni Yesu nɔɔgɔ ka calaŋ aduwak ɔl oogi zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma adɛmɛz Yesu nuyak ogin anek nɛ, “Iiten oma naana Ŋɛɛrti Eeto kapirna ɔrɔɔt ɛlɛ kaale ci meelik. Ma abornan tiŋeere aneet alaata o miliny ki alaat o adikir ceeze o Joowo been ɔl o demziinto buk. Arukan tiŋeere niigi aneet kadaak. Bar zin iinyaye ceen iiyu kiŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Oobek ni niini nuyak dook zɔɔz nico kagaac niigi dook juruŋ. Mazi azii Pitɔr zɔɔz nico, akata Yesu doon, ma akɔ aricanek nɔɔnɔ gi ci anek nɛ, “Má azi nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bar ookci Yesu, ma agɛlɛm nuyak, ma agernyek Pitɔr anek nɛ, “Nyɛ ŋaatan Loryen co, eeci baabani cune o alaŋ aku Joowa, bar baabani ci eet ci deer.” ");
INSERT INTO mur_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Otowa ni Yesu kɔlɛ kibeen nuyak, ma aku anek nɛ, “Mã arɔɔŋ ɛɛti konowan aneet, abon areyek nɔɔnɔ ɛlɛ oninɛ, ma abon agama gidɛn ki piryakzɛt ŋaati anuyan niini aneet. ");
INSERT INTO mur_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Eeci ɛɛti ci arɔɔŋ korogoz ɛlɛ onin, bar akoloz. Maje ɛɛti ci akoloz ɛlɛ onin ŋaatan kibeen kaviyawe o Joowo, bar arogoz. ");
INSERT INTO mur_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mayo zin inoko mã anyak ɛɛti kaal o loocu dook, ma bar akoloz rogɛt ci ɛlɛ onin, bonat inoo? ");
INSERT INTO mur_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mã adaak ɛɛti, akɔm bodo gi ci ka kabadakɛ nɔɔnɔ rogɛt onin. ");
INSERT INTO mur_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Zin ma anyak ɛɛti alyaan ŋaatan ki zooze onan ole ci loocu gɛr noko, katin buk naana Ŋɛɛrti Eeto kanyei alyaan ŋaatin iitene ci kabadana naana been toonnyak o Joowo titinyonte o Joowo e.” ");
INSERT INTO mur_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ma anek bodo Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, anyak ɔl oogi ŋaatunooŋ ŋina ci katin alaŋ adaai iŋaan kicinit niigi dɔyiz o baliin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ma vurta iinyaye ceen tɔrkɔnɔm ooyi Yesu Pitɔr ki Jemis been Jɔn bɛ tadena, ma avɔ aavtiz niigi doon ŋinaante. Mazi ŋaan aavtiz nɔkɔ, otowo Yesu ɛlɛ nɔɔgɔ kɛbɛrɛn nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Makacin rumanɛ oginɛ iziti vɔɔrɛ pɛr kizi kiyir kiyir kujuk rum ci vɔɔr loota ŋina. ");
INSERT INTO mur_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma acin nuyawa Ilija ki Mosis baal adaayitɔ baale e azɔɔzɔ ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma anek Pitɔr Yesu nɛ, “Manyi, kavu tɛ ŋina juruŋ. Nyet kɛtɛɛnycawa kaal ceen ceezi kabili kɔr een iiyu, ka codoi kizi cun, codoi ci Mosis, codoi ci Ilija.” ");
INSERT INTO mur_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aduwa Pitɔr gi nico calaŋ aga, eeci niigi dook anyak ŋoliin ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma aku diizoc, ma aku abil nɔɔgɔ tadena, ma azi mɔlɔyi ci Joowo diizoce nico nɛ, “Nicini ŋɛɛran o kareez nɛɛn. Iziiyit nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Taman nɔkɔ icinit nuyawa izi nɔɔnɔ Yesu doon, ɔkɔma Ilija ki Mosis. ");
INSERT INTO mur_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mazi aduŋna niigi bɛ tadena, iricanek Yesu nɔɔgɔ anek nɛ, “Má avɔ aduwaku ɔl gi ci ona acinu noko zɛɛ ma kakɔ kiŋaaz naana Ŋɛɛrti Eeto daayiza.” ");
INSERT INTO mur_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oroodit ni didi nuyawa gi nico zinzeetinɛ, maje ŋaato ajinɔ niigi maany anɔ nɛ, “Ŋaazi daayiza akati kɛŋ cinɛ gitaz?” ");
INSERT INTO mur_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma ajin niigi Yesu anek nɛ, “Ma dim gɔɔn ɔl o demziinto azi nɛ, Arayai katin rak ɔɔwa Ilija ŋaati Kiristo o, naa?” ");
INSERT INTO mur_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma anek niini nɔɔgɔ nɛ, “Didi ŋɛdɛt arayai rak Ilija ka kiiya kidimdiman gɔl o Kiristo. Azi waragɛ o Joowo nɛ, Katin Ŋɛɛrti Eeto abor ɔl nɔɔnɔ, ma apirna niini ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bar zin kaduwakuŋ igeet, Ilija iiya odota, ma utuguzek ɔl nɔɔnɔ kaal ci gɛr eo arɔɔŋi niigi kiyo ayeedi waragewe o Joowo o.” ");
INSERT INTO mur_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mazi avɔ arum Yesu ki nuyak ceen iiyu o nuyak ogin oogi, acin kɔlɛ ci aliya nɔɔgɔ, ma adaŋɔ ɔl ci demziinto kibeen nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mazi acin ɔl nicigi dook Yesu, ibiirit nɔɔgɔ ooti ɔrɔɔt ɛlɛ, ma adokonyonek niigi nɔɔnɔ, ma avɔ azaa. ");
INSERT INTO mur_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma ajin Yesu nuyak anek nɛ, “Ma dim adaŋonu kibeen ɔl nicoko naa?” ");
INSERT INTO mur_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma azɔɔz ɛɛti codoi ole ceen kɔlɛ noko anek Yesu nɛ, “Manyi, kanyaakin ŋɛɛran ci anyak miniŋit ci Loryento, ma adiiti ɔtɔgi calaŋ azɔɔz. ");
INSERT INTO mur_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gɔɔn ma agam nɔɔnɔ miniŋit nici, arui looc, ma aduŋna kavucaci otoga, ma adak nyigit, ma aciizɛn ɛlɛ. Kajin uyene nuyak cugun noko ka kotooyit miniŋit nico ŋaatin, bar alaŋ anim niigi kotooyit.” ");
INSERT INTO mur_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma anek Yesu nɔɔgɔ nɛ, “Igeet ɔl ci akɔmnuŋ tuwɛn coko. Kayo koromtɛ naana kibeen igeet zɛɛ been inin ka utuyɔ? Ka kɛmɛz zɔɔz cunooŋ zɛɛ been inin? Anyaaktayaŋ zin di logo nico ŋaato.” ");
INSERT INTO mur_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma anyaak niigi nɔɔnɔ logo nico. Mazi acin miniŋit ci Loryento noko Yesu, taman nɔkɔ avic logoz, ma arui looc kɔbɔrbɔr kuduv ɔtɔgi. ");
INSERT INTO mur_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma ajin Yesu baatin anek nɛ, “Akanan gi nici baal waŋa?” Ma anek baati logoto nɔɔnɔ nɛ, “Anyaa gi nico kidiczɛta nɔkɔ laadun. ");
INSERT INTO mur_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lak ci meelik gɛr ci gɔɔn ajukɛkɛ miniŋit nici nɔɔnɔ goo karabɔŋ een liil arɔɔŋ ka kuruk kadaak. Inoko kilalekin anyek ziniz kobona ŋaatinaaŋ. Tiritet miniŋte nico mã anim.” ");
INSERT INTO mur_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Naa akɔba azi nɛ, Mã anim o? Ɛɛti ci atu Jook anim kutugu kaal dook.” ");
INSERT INTO mur_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Taman nɔkɔ enek baati logoto Yesu nɛ, “Ŋɛdɛt naana katuwe. Tiritan zin tuwente can miliny noko ka kutuwɔ juruŋ.” ");
INSERT INTO mur_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mazi acin Yesu kɔlɛ alotak nɔɔnɔ nɔkɔ, egerenyek miniŋit ci Loryento noko anek nɛ, “Niina miniŋit o adiiti logo nico otok, duna ŋaatin. Má abadai bodo nɔɔnɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma agɛrɛny miniŋit nici, ma avic logoz kataval ɔrɔɔt ɛlɛ, makacin uduna. Ma ɔɔŋ logoti kazacanɛ kiyo ɛɛti o adaak o. Ma anɔ ɔl ci meelik nɛ, “Adaak ri logoti.” ");
INSERT INTO mur_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Maje bar Yesu agam logoz aziit, ma adɔŋa kaavu jena. ");
INSERT INTO mur_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mazi akɔ Yesu ɔlɔ, ɔɔt ijinit nuyawa oginɛ nɔɔnɔ ŋaati ɛɛnɛ nɔɔgɔ doon anek nɛ, “Matɛ uyene akɔmneket ageeta ŋaati katooka miniŋit nico naa?” ");
INSERT INTO mur_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma anek Yesu nɔɔgɔ nɛ, “Miniŋit nici alaŋ aaryai gaga. Ool nɔɔnɔ ŋaryiin doon.” ");
INSERT INTO mur_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ma iŋaaz Yesu ki nuyak ogin ŋinaante, ma avɔ adiir looc o kazi Galili. Maje Yesu alaŋ arɔɔŋ kagaac ɔl ogɛnɛ nɔɔnɔ ŋinti aavɛ. ");
INSERT INTO mur_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Eeci arɔɔŋ niini waŋi ci ka kɛdɛmɛzi nuyak. Ma anek niini nɔɔgɔ nɛ, “Iiten oma agamnyan ɔl aneet Ŋɛɛrti Eeto, ma avɔ arukan kadaak. Bar iinyaye ceen iiyu kiŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Maje bar nuyawa alaŋ aga kɛŋ ci demziin ci aduwak Yesu nɔɔgɔ o. Bodo ŋaato aŋole ŋaati ajini niigi nɔɔnɔ kɛŋ ci demziin nico. ");
INSERT INTO mur_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mazi avu arum niigi Kapernam, ɔɔtɔ korge oman. Ŋinaante ijin Yesu nuyak enek nɛ, “Gitaz ona adaŋonu gɔla e?” ");
INSERT INTO mur_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma ajaki niigi jaŋ, eeci uyene ŋɛdɛt adaŋɔ gɔla arɔɔŋ kagaac ŋɛnɛɛn ci titiny ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aavu ni Yesu loota, ma awa nɔɔgɔ dook amɔtɔ ramana, ma anek nɛ, “Mã arɔɔŋ ɛɛti kizi titiny, abon anyek niini ɛlɛ onin kizi cɛlbɛz ɔla dook, ma een gabaren ci ɔl dook.” ");
INSERT INTO mur_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Enico odoma Yesu dole ci miliny, ma aku anyek kibil nɔɔgɔ ŋuma ŋaati ataadekɛ niini nɔɔnɔ azɛɛn, ma anek nuyak nɛ, ");
INSERT INTO mur_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ma ɛɛti ci atalna dole ci miliny kiyo nici noko zaare ogan, atalnanan buk niini aneet. Ma ɛɛti ci atalnanan aneet, alaŋ bar atalnanan aneeta doon, bar buk atalna niini Jook o itoonanan aneet.” ");
INSERT INTO mur_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ma anek Jɔn nɔɔnɔ nɛ, “Gayoi, iiten baale anyak eet ci kacina atɔɔk miniŋ o Loryento zaare ugun, ma kalamnya naaga nɔɔnɔ, eeci alaŋ een niini nuyai kiyo naaga o.” ");
INSERT INTO mur_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma anek Yesu nɔɔgɔ nɛ, “Má alamnyu nɔɔnɔ gaga, eeci ɛɛti ci agɔɔn kaal ci adɔi kiyo nici o zaare ogan, alaŋ amarninan niini aneeta. ");
INSERT INTO mur_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ma ɛɛti calaŋ amarninet ageet, niini laŋotinai. ");
INSERT INTO mur_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Didilɛ kaduwakuŋ igeet, ma ɛɛti ci anyuŋ maam owodit giye o eeginu niiga nuyak cigan, ajowa katin buk niini gi ci abon Joowa.” ");
INSERT INTO mur_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ma azi Yesu bodo nɛ, “Mã anyek ɛɛti dole ci miliny kiyo nici noko kabaca oŋec, aganɔ koca ɛɛti nici ŋaati acabonɛkɛ nɔɔnɔ golu alɛm, ma ajukonek liil kotododɛ kook many. ");
INSERT INTO mur_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Zin mã abacakin aziiti oŋec, tɛɛda. Mayɛ bar ŋaati akɔyɛ rogɛta aziite codoi kujuk ŋaati anyayɛ azɛɛn dook, ma ajukonei goo o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mã abacakin zɔɔci oŋec, tɛɛda. Mayɛ bar ŋaati akɔyɛ rogɛta zooce codoi kujuk ŋaati koca ajukonɛkɛ goo o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mã abacakin kɛbɛrɛci oŋec, kata bitaalin. Mayɛ bar ŋaati akɔyɛ baliinte o Joowo keberece codoi kujuk ŋaati koca ajukonɛkɛ goo o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma ŋin o gooyo anyak kuluut ci adak ɔl, ma alaŋ adaai nɔkɔ been nɛɛn. Buk goo ci avaat nɔɔgɔ o alaŋ adiiti nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Avaadi katin ɔl dook gooya zɛɛ ma amokcar kiyo mɛlɛ o. ");
INSERT INTO mur_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ma mɛlɛ abona, bar mã idicai mokcarɔni, akɔm bodo gɔl ci kanyekɛ komokcar. Anyayit zin bonat o atobɔ kibeen mɛlɛ. Abaayit niiga dook laŋotizɛta been ganɔnta.” ");
INSERT INTO mur_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma vurta itiŋa Yesu ook looce o kazi Judiya, ma akɔ abaayiz liil o kazi Jordan. Ma ŋinaante alotak kɔlɛ nɔɔnɔ bodo, ma adɛmɛz niini nɔɔgɔ eo gɔɔn adɛmzi ɔl laadun. ");
INSERT INTO mur_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma avunak nɔɔnɔ ɔl ogɛn ole o Parici arɔɔŋ ka kicinta nɔɔnɔ. Ma ajin niigi nɔɔnɔ anek nɛ, “Mayo gɔɔn lotinowa ogaac aziiknek eet kɔtɔɔk ŋaa cin labak?” ");
INSERT INTO mur_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma da baale Mosis zooze nico anekuŋ nɛ?” ");
INSERT INTO mur_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma azi niigi nɛ, “Aneket Mosis nɛ, Mã arɔɔŋ ɛɛti kɔtɔɔk ŋaa cin, abon labak, olla zin abon ayɛɛdak niini nɔɔnɔ waragɛ ci ŋeronto.” ");
INSERT INTO mur_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma anek Yesu nɔɔgɔ nɛ, “Ayeedekuŋ Mosis zɔɔz nico o, eeci adoknuŋ igeet zinzeeti kak, ma alaŋ arooŋnyu iziiktɔ. ");
INSERT INTO mur_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maje laadun waanbaal ɛɛnycanɛ Jooi looc e, ɛɛnyca niini eet ci mac ki ŋaa. ");
INSERT INTO mur_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Zin nici gi o gɔɔn ooŋni ɛɛti yaatin ki baatin, ma akɔ aromɛn ki ŋaa onin o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ma gole nico alaŋaan bodo niigi eegin ram, bar iziti ɛlɛ codoi ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Zin giye o oromi Jooi ɔl nicoko kodoye, akɔm bodo eet ci deer ci ka kɛŋɛr nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mazi avɔ aavtiz nuyawa ki Yesu niigi doon ceeza, ijinit niigi nɔɔnɔ kɛŋ ci zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma anek niini nɔɔgɔ nɛ, “Mã atɔɔk ɛɛti ŋaa cin, ma arɔca bodo ŋaa oma, adoma niini zoocmaz. ");
INSERT INTO mur_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Buk mã aaryai ŋaa eete cin, ma akɔ arik bodo eete oman, adoma niini zoocmaz.” ");
INSERT INTO mur_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ŋinaanto anyaaktak ɔl ogɛnɛ Yesu dɔl ci miliny ka kamayuk niini nɔɔgɔ. Maje nuyawa bar agernyek ɔl nicoko kɛdɛyai. ");
INSERT INTO mur_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mazi acin Yesu gi nico, otobor nɔŋ, ma anek nuyak nɛ, “Anycek dɔl kivitayan aneet. Má alamnyu nɔɔgɔ, eeci baliin o Joowo abilnek ɔl ci anyek eleeti kiyo dɔlya ci miliny noko. ");
INSERT INTO mur_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Didilɛ kaduwakuŋ igeet, ma ɛɛti calaŋ agama baliin o Joowo zinize onin kiyo dole o miliny o, alaŋ akɔ niini baliinte nico been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma alotek Yesu dɔl kɛŋ, ma ataadek nɔɔgɔ azɛɛn, ma amayuk. ");
INSERT INTO mur_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mazi iŋaaz Yesu keronnye onin, ivirak ɛɛti oman nɔɔnɔ, ma aku akani kozoŋti looc nɔɔnɔ kɛŋa. Ma ajin anek nɛ, “Gayoi o abona, mayo kutugu naa ka kojowa rogɛt o abil been nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma ajin Yesu nɔɔnɔ anek nɛ, “Akɔ ma awuyan kizi eet ci kabona o naa? Akɔm eet ci abon. Jook doon ci abon. ");
INSERT INTO mur_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aga niina lotinok o Joowo azi nɛ, Má amony eet ci deer. Má adoma zoocmaz. Má agɔrzɛ. Má avoloŋ. Má adayɛ ɔl looc. Tɔŋɔlɛ baatun ki yaatun.” ");
INSERT INTO mur_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma anek ɛɛti nici Yesu nɛ, “Gayoi, lotinok nicoko dook kazoonɛ baale kidiczɛta e laadun.” ");
INSERT INTO mur_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma agɛlɛm Yesu nɔɔnɔ talniinta, ma anek nɛ, “Anyak zin gi codoi ṯɔr nɔkɔ ci abon agoon. Bitɔ taalɔi kaal ugun anyei dook ka ŋerek guruc ɔl o amaat, ka ija nowawan niina aneet. Ŋaan akɔ katin jowa niina arɔkzɛt tamma.” ");
INSERT INTO mur_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mazi azii ɛɛti nici zɔɔz nico, alaca ɛlɛ, ma awɔ ŋaati inoni ziniza gi nico ɔrɔɔt ɛlɛ, eeci anyak niini kaal ci meelik. ");
INSERT INTO mur_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ma agɛlɛm Yesu nuyak ogin, ma anek nɛ, “Ɔl ceen arɔk adɔi kak ŋaati avɔyi niigi baliinte o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma abiir nuyak ooti zooze nico. Bodo anek Yesu nɔɔgɔ nɛ, “Dɔl ogan, adɔi kak ŋaati akɔyi ɛɛti baliinte o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɔl ceen arɔk adɔi ɔrɔɔt ŋaati avɔyi baliinte o Joowo kiyo alaŋ nyakale adunyonek nyibira ŋino vɔlɔŋ o.” ");
INSERT INTO mur_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Enico mazi azii nuyawa gi nico, ibiirit nɔɔgɔ ooti ɔrɔɔt ɛlɛ, ma ajinɔ niigi maany anɔ nɛ, “Mazi yo ŋɛnɛɛn ci ka kɛɛlyai korok?” ");
INSERT INTO mur_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma agɛlɛm Yesu nɔɔgɔ, ma anek nɛ, “Ma ɛɛti ci deer alaŋ anim korogoz ɛlɛ dɔyize cin doon, bar Jook nɛɛn o arogoz nɔɔnɔ, eeci kaala dook Joowa alaŋ adɔi.” ");
INSERT INTO mur_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Itiŋa ni Pitɔr, ma anek Yesu nɛ, “Mazin yo naaga ci kotoŋteya kaal ogaacak dook looc, ma kivita kunuyin ineet, kakana inin?” ");
INSERT INTO mur_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti ci ooŋ kɔrɔk cin, karabɔŋ een gɔtɔnɔgi ki ŋɔɔnɔgi, karabɔŋ een baatin ki yaatin, karabɔŋ een dɔl cigin, kibeen mana cin giye ci atuyan niini aneet, ki giye ci akati kaviyak o Joowo, ajowa niini loota ŋina kaal ci meelik kujuk kaal ci ooŋ niini o lak eet tur. Ajowa niini gɔtɔnɔgi, ŋɔɔnɔgi, yaatigin, dɔl been manɛɛn. Ma buk ajowa niini piryakzɛt liŋliŋonte nico, bar zin katin ŋaan ajowa niini rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ma ɔl o titiny inoko, eegin niigi katin kaal ci labak. Maje ɔl o cɛlbɛz inoko, katin niigi titinyɛ.” ");
INSERT INTO mur_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ma awɔ Yesu kibeen nuyak avɔ Jerusalɛma. Arayin niini nuyak ɔɔwa, maje nuyak baraŋɛ nɔɔgɔ zinzeeti nɔkɔ. Buk ɔl ci ano nɔɔnɔ o anyak ŋoliin. Ma awa bodo Yesu nuyak ogin amɔtɔ ramana ka kuduwak nɔɔgɔ doon kaal o ka kivitak nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma anek nɔɔgɔ nɛ, “Iziiktɔ di! Inoko kavɔ naaga Jerusalɛma. Zin tiŋeere ŋinaante kakɔ kanyonei naana Ŋɛɛrti Eeto alaat o ceez o Joowo kibeen ɔl o demziinto. Ma avɔ apayekan niigi aneeta daayiz. Ma avoyan ole ween modɛn. ");
INSERT INTO mur_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma avɔ ararnan ɔl nica aneet, ma oortekan amot, ma arukan nyaboyɛn, ma vurta ɔɔt ni uruktan kadaak. Bar zin iinyaye ceen iiyu, ŋaan kiŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ma avunak Jemis ki Jɔn ween lɔgɔz o Zebedi Yesu, ma avu ajin nɔɔnɔ anek nɛ, “Gayoi, karooŋnyin da tuguweyet gi ci karooŋnya ce.” ");
INSERT INTO mur_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma ajin Yesu nɔɔgɔ anek nɛ, “Arooŋnyaŋ kutuguweyuŋ naa?” ");
INSERT INTO mur_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma anek niigi nɔɔnɔ nɛ, “Katin waanci aavɛ niina lecere unun alaazetu baliinte o Joowo titiny tammu tadena, karooŋnya koromtɛ naaga kibeen ineet ŋaati anyekɛ gɔɔn eet codoi ŋaatinaaŋ kaavu ineet aza, maje codoi aavi ineet kaŋeta.” ");
INSERT INTO mur_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ agayu niiga gi ci ajinaŋ o. Animnyu kini niiga ipirta kiyo tiŋeere kakɔ kapirna naana o? Ma buk kini animnyu daayiz kiyo tiŋeere kakɔ kadaai naana o?” ");
INSERT INTO mur_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma anek niigi nɔɔnɔ nɛ, “Ii, kanimnya labak.” Ma anek Yesu nɔɔgɔ nɛ, “Ŋɛdɛt zin avɔ apirnanu kiyo tiŋeere kapirna naana o, ma avɔ adaaŋnu kiyo kakɔ kadaai naana o. ");
INSERT INTO mur_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bar zin gi ci ka kaavɛ ŋaatunooŋ ɛɛti codoi aneet aza, maje codoi aavi kaŋeta o, alaŋ een gi can ka kanyuŋ. Eeci ɛŋɛra Jooi ɔl ci ka kaavtiyɔ vitɛnane nicoko laadun.” ");
INSERT INTO mur_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mazi azii nuyawa ween amɔtɔ gi nico, otobortek niigi Jemis ki Jɔn nɔŋ. ");
INSERT INTO mur_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Otowa ni Yesu nɔɔgɔ dook ŋaatodoi, ma anek nɛ, “Agayu niiga alaata o ɔl o alaŋ atu Jook, abal niigi ɔl ugeec dɔyiza. ");
INSERT INTO mur_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma zin gi nici alaŋ ŋaatunooŋ abil nɔkɔ. Mã ɛɛti ci arɔɔŋ kizi titiny ŋaatunooŋ, abon niini een gabaren ci gonoginu. ");
INSERT INTO mur_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mã ɛɛti ci arɔɔŋ karayɛ ɔɔwa, abon niini een gabaren ci ɔl dook. ");
INSERT INTO mur_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Eeci yo nuun een aneet ɛlɛ Ŋɛɛrti Eeto, alaŋ kakun ka kiiya kiliŋliŋtozeyan ɔl aneet, bar kakun ka kiliŋliŋozek nɔɔgɔ, ma kadaai ka korogoz ɔl ci meel.” ");
INSERT INTO mur_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ma bodo avunak niigi kutur o kazi Jeriko. Mazi awɔ Yesu kibeen nuyak ki kɔlɛ kuture nico, anyak eet ci ruben aavi gɔl kabanyca ŋinaante alaye. Kazi eet nico zaar nɛ Bartimeyas. Niini ŋɛɛrti eet ci kazi Timayos. ");
INSERT INTO mur_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mazi azii niini nici Yesu ween eet o Nazarɛt, ɛgɛrɛny izi nɛ, “Yesu ween ŋɛɛrti Devid, tiritan da!” ");
INSERT INTO mur_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma agernyek ɔl ci meelik nɔɔnɔ ka kajawɔ. Bar enico agɛrɛny niini ɔrɔɔt ɛlɛ kujuk we azi nɛ, “Ŋɛɛrti Devid, tiritan da!” ");
INSERT INTO mur_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ibil ni Yesu, ma anek ɔl nɛ, “Utuyayaŋ di nɔɔnɔ kiiya.” Ma avɔ awa niigi nɔɔnɔ anek nɛ, “Talɔ! Tiŋa je. Awoyin Yesu.” ");
INSERT INTO mur_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ma ajukek niini rum onin malkinto looc, ma iŋaaz jena taman, ma akunak Yesu. ");
INSERT INTO mur_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma ajin Yesu nɔɔnɔ anek nɛ, “Arooŋ kutuguweyin naa?” Ma abɛdɛkɛ niini noko nɔɔnɔ anek nɛ, “Gayoi, karooŋ kɔlan kɛbɛrɛ kicinɔ bodo.” ");
INSERT INTO mur_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma anek Yesu nɔɔnɔ nɛ, “Bitɔ zin. Anyin tuwɛn unune ineet cinɔ.” Kataman nɔkɔ ɔkɔltɛ nɔɔnɔ kɛbɛrɛ oginɛ, ma ano niini Yesu gɔla. ");
INSERT INTO mur_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Mazi avɔ ajɔŋɔz niigi Jerusalɛm, ɔɔtɔ niigi rak biye o kazi Kiŋiroc ajɔŋɔz kuturyok o kazi Bezpeja ki Bezani. Ma itoon Yesu nuyak ram anek nɛ, “Ɔɔtɔ kuture ci kazi Bezpeja abil igeet ɔɔwa neke. Mazi avɔ arumnyu, ajowanu tedec jɔrɔn ci zigiro ci ŋaan laadun kotoodit ɔl acabje ŋinaante. Ɔɔkta ka anyaaktayaŋ ŋina. ");
INSERT INTO mur_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mã anyak eet ci ajinuŋ anekuŋ nɛ, Ɔɔganu naa? Enektek nɛ, Arɔɔŋ Manyi. Ŋintimiliny ŋaan abadakuŋ.” ");
INSERT INTO mur_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mazi avɔ niigi ŋinaante, amada didi jɔrɔn ci zigiro acabje ɔlɔ araan otoga gɔl kabanyca. ");
INSERT INTO mur_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mazi ɔɔga niigi zigir, enektek ɔl ogɛn ole ci ɛɛl ŋinaante nɔɔgɔ nɛ, “Gitaz ci agoonu noko? Ɔɔganu jɔrɔn ci zigiro noko naa?” ");
INSERT INTO mur_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma aduwak niigi nɔɔgɔ zɔɔz ona aduwa Yesu e. Otoŋit ni ɔl nici nɔɔgɔ kooti zigir. ");
INSERT INTO mur_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma anyaak niigi Yesu zigir. Ma avu ataadek nuyawa rumanɛ ugeec malkinto zigir bawuc, ma aavɛ Yesu tadena. ");
INSERT INTO mur_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Maje ɔl ci meelik ogɛn avetek rumanɛ ugeec malkinto gɔl. Maje ogɛnɛ atɛɛda bɔlɔk ci anyarnyar ḏorta, ma avu avetek gɔl kɛŋ. ");
INSERT INTO mur_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Maje ɔl o arayin Yesu ɔɔwa o kibeen ɔl ci anowa nɔɔnɔ vurta o agɛrɛny anɔ nɛ, “Katanaaz Jook! Abon bai amayuk Jooi nɔɔnɔ o aku zaare o Joowo. ");
INSERT INTO mur_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Abon bai amayuk Jooi nɔɔnɔ o ka kiiya kabal looc kiyo baale jijitinai Devid e.” ");
INSERT INTO mur_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ook ni Yesu Jerusalɛma, ma akɔ ceeze o Joowo, ma akɔ agɛlɛm niini kaal dook. Ma yomana imiirye niini ki nuyak ogin een amɔtɔ ram ɔɔt kuture o kazi Bezani. ");
INSERT INTO mur_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mazi abada niigi Bezaniya ŋeere, adawun Yesu magiz. ");
INSERT INTO mur_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma acin niini rɛɛna kɛɛt ceen moneec anyak bɔlɔk ci meel ɔrɔɔt. Ma akɔ niini ka kook kicin karabɔŋ abiir. Mazi akɔ arum, bar acin een bɔlɔk doon, eeci alaŋ een iinya o gɔɔn abiirni monɛna nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Enek Yesu moneec nico nɛ, “Alaŋ bodo niina abiir kadak ɛɛti oman kɛbɛrɛ cugun nɔkɔ been nɛɛn.” Maje nuyawa azii zɔɔz nico nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mazi avɔ arum niigi Jerusalɛm, ook Yesu kaluwawe o ceez o Joowo eecitɔ, ma akɔ atɔɔwa ɔl o gɔɔn ataalinɛ kaal kaluwawa eecitɔ kibeen ɔl o ataali. Ma uup tarabɛzɛt ci ɔl o gɔɔn abali guruc. Ma ajuk lɛcɛrɛ ci ɔl o gɔɔn ataalinɛ yɛɛla. ");
INSERT INTO mur_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma alaŋ anyek bodo niini eet oma kiiya kabatak kaluwa o ceez o Joowo ŋaati iloli kaal cigin. ");
INSERT INTO mur_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɛdɛmɛz ni niini ɔl enek nɛ, “Azi Jooi waragewe onin nɛ, Awɛ ceez cane o kizi ceez ci ŋaryiinto modɛni dook, bar niiga anyceyu kizi ŋinti avu aroodinɛ agoryawa.” ");
INSERT INTO mur_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Mazi azii alaata o adikir ceeze o Joowo kibeen ɔl o demziinto zɔɔz nico, orooŋit niigi gɔl ci ka kurukti Yesu kadaak. Amadik niigi nɔɔnɔ o, eeci abiir ɔl dook ooti demziinte onin. ");
INSERT INTO mur_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ma yomana itiŋgazɔ Yesu kibeen nuyak otoŋit Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ma iitene co ŋeere mazi avu awɔ gɔla, icinit niigi moneec baale araabjai dook agɛrɔi buk. ");
INSERT INTO mur_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma aada Pitɔr gi baal agɔɔn Yesu e, ma anek nɔɔnɔ nɛ, “Gayoi, cin di moneec baal ator e araabjai lai.” ");
INSERT INTO mur_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma anek Yesu nɔɔgɔ nɛ, “Abon anyaku tuwɛn Joowa. ");
INSERT INTO mur_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Didilɛ kaduwakuŋ igeet, mã anyak ɛɛti tuwɛn Joowa, ma anek niini bɛ nico nɛ, Piyai! Jukozek liil! Ma alaŋ anyak niini ziniza baabanok ram, gi nici agooni koca nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Zin giye nico kaduwakuŋ igeet, mã anyak gi ci ajinu Jook ŋaryiinta, agaac nɔkɔ gi nici ŋaan anyonekuŋ igeet. Zin ŋaan anyuŋ Jooi didi gi nico. ");
INSERT INTO mur_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ma aŋaryinu, abon uuŋnu kaal o gɛr anyayeku ɔl oogi zinzeetinɛ ka buk Jooi ween baatunooŋ o aavi tammu tadena kotoŋ oŋeeti ugooc.” ");
INSERT INTO mur_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mazi abadaak niigi bodo Jerusalɛm, ook Yesu kaluwawe o ceez o Joowo, ma avunak nɔɔnɔ alaata o ceez o Joowo ki ɔl o demziinto kibeen ɔl o adikir baayizo. ");
INSERT INTO mur_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma avu ajin nɔɔnɔ anek nɛ, “Ma dim ŋɛnɛɛn ci anyin ineet alaazɛt ci atɔɔyɛ ɔl balawaz ceeze o Joowo o?” ");
INSERT INTO mur_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Buk naana kajinuŋ igeet zɔɔz codoi ce. Mã abarzekaŋ jinɛn can o gole ci alɛɛmanu, kaduwakuŋ buk koca naana igeet alaazɛt can o aku ŋaaḏaŋ. ");
INSERT INTO mur_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Uduktayaŋ di, baale ŋɛnɛɛn baal anyek Jɔn dɔyiz ci aku oonyi ɔl e? Anyek Jooi yo ɛɛti ci deer da?” ");
INSERT INTO mur_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma adaŋɔ niigi maany anɔ nɛ, “Inoko mã kazi nɛ, Anyek baale Jɔn dɔyiz baal oonyɛnɛ Jooi, azi koca Yesu nɛ, Ma da alaŋ zin atuwenu naa? ");
INSERT INTO mur_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Buk mã kazi nɛ, Anyek Jɔn dɔyiz nice ɔl ci deer, aborneket koca ɔl ageet nɔŋ.” Aŋole niigi o, eeci ɔl ci meel aga niigi Jɔn baale nyakaŋan didi. ");
INSERT INTO mur_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛbɛdɛkɛ ni niigi Yesu enektek nɛ, “Alaŋ kagaya eet ci da anyek Jɔn dɔyiz o.” Ma anek Yesu nɔɔgɔ nɛ, “Alaŋ zin buk kaduwakuŋ naana igeet dɔyiz ci kagɔɔnɛ naana kaal nicoko o.” ");
INSERT INTO mur_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ma anek Yesu nɔɔgɔ yabziinta nɛ, “Anyak baale eet ci aḏok kɛɛn ci gɔɔn agɔɔnanɛ ɔl nyaantanɛ mana. Olok ni mana juruŋ. Ma adawa look ci ka gɔɔn kamacoyek ɔl kɛbɛrɛ ci keenu o. Ma ɛɛnyca vaaco ci appe ka kɛbɛkti ɔl mana. Anyek ni niini mana ɔl ci ka keevit ka mã abiir kɛɛna, ka keŋerit ki nɔɔgɔ. Ɛɛrɔn ni niini ook looce oman. ");
INSERT INTO mur_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mazi awɔ abiir kɛɛna, itoonek niini gabaren cin ɔl o aliŋliŋ mana ka kiiya kiyiitek nɔɔnɔ kɛɛn kɛbɛrɛ cigin. ");
INSERT INTO mur_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mazi aku arum gabarɛnti nici ɔl ci aliŋliŋ mana o, agamit niigi nɔɔnɔ, ma aruk, ma anyek kimiire nɔkɔ kɔkɔm kaal ci akɔyi kina. ");
INSERT INTO mur_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Bodo itoona ɛɛti o mano gabaren oma, ma avu aruk ɔl o aliŋliŋ mana gabaren nico ɔrɔɔt ɛlɛ kanyak tuben ɔɔwa, ma amomoz nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Bodo itoona niini gabaren oma. Enico uruyit niigi gabaren nico kadaak. Ma agoonek niigi kaal nicoko gabara ci mɛɛlɛ, oogi aruk korogit, oogi aruk kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Maje ɛɛti ci mano noko anyak ŋɛɛrin codoi ṯɔr nɔkɔ ci arɛɛz ɔrɔɔt. Ma azi niini nɛ, “Atitiny tiŋeere niigi ŋɛɛran.” Itoonek ni niini nɔɔgɔ ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mazi avɔ acin ɔl ci liŋliŋonto noko nɔɔnɔ, izitɔ nɛ, “Nicini ŋɛɛrti eet o mano nɛɛn. Ivita kuruyit nɔɔnɔ kadaak ka kuula kaal dook kizi cigaac.” ");
INSERT INTO mur_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Agamit ni niigi nɔɔnɔ, ma aruk kadaak, ma avɔ ajukek tuu mana bawuca.” ");
INSERT INTO mur_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma ajin Yesu nɔɔgɔ anek nɛ, “Mazi yo inoko ma akɔ abada ɛɛti ci mano o agoonek ɔl nicoko naa? Bar kanɛ aku koca niini ma aruk ɔl ci baal aliŋliŋ mana noko dook kadaayitɔ. Ma anyaa ɔl oogi ka kivita kiliŋliŋit mana. ");
INSERT INTO mur_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kaga nɔkɔ ekeebtu niiga waragewe o Joowo zɔɔz o azi nɛ, Ma bɛ o abor ɔl o gɔɔn ɛɛnyɛt ceezi biyɛnɛ, ma apɛz kizi gi ci labak, bar bɛ o titiny ɔrɔɔt kujuk biyɛn o enyciinto dook nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jook zin nɛɛn o agɔɔn gi nico, ma gi nici gi ci panypany keteedet biye ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mazi azii alaata o Juz yabziin nico, orooŋit kagamit Yesu, eeci aga niigi ariik niini nɔɔgɔ yabziinte nico. Bar bodo aŋole niigi kɔlɛ. Ɔtɔɔzɔ ni niigi otoŋit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma itoonek alaata o Juz Yesu ɔl oogi ole o Parici kibeen ole o Erod ka kɔɔt kijinit nɔɔnɔ zoozok ci ajin ka mã abarzek niini nɔɔgɔ gɛrzɛ, ka kagamit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ma avunak niigi nɔɔnɔ, ma avu anek nɛ, “Gayoi, kagayin naaga ineet gɔɔn azooz zoozok ci alɛɛma. Ma alaŋ aŋole baabani ci ɔl oogi, ma alaŋ buk ari niina ziniz titinyɔn ci eet ci deer. Duwayet di, mayo abon ŋaati karuweka meeri alaan o kazi Sizar, yo gɛrzɛ da?” ");
INSERT INTO mur_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Maje Yesu aga cinaan cineeŋ o nɔkɔ, ma anek nɔɔgɔ nɛ, “Arooŋnyu icintawaŋ naa? Anyaakta di zin gurucoc ceen ziit anycaŋ kicin.” ");
INSERT INTO mur_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma anyek didi ɔl nɔɔnɔ gurucoc, ma ajin Yesu nɔɔgɔ anek nɛ, “Ma ŋum ceeni kibeen zaar ci ayeedonek gurucoc nico ci ŋɛnɛ?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ŋum o alaan o kazi Sizar kibeen zaar ogin.” ");
INSERT INTO mur_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Anycek zin Sizar gi o akati nɔɔnɔ. Maje gi o akati Jook, anycek Jook” Mazi azii niigi Yesu azi nɔkɔ, olla apaŋantɛ paŋ. ");
INSERT INTO mur_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma bodo avunak Yesu ɔl ogɛn ole o kazi Sajuzi gɔɔn abaaban niigi azi nɛ, Ɔl o adaai alaŋ bodo iŋaaz daayiza. Ma avu ajin niigi Yesu anek nɛ, ");
INSERT INTO mur_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Gayoi, baale ayeedeket Mosis lotinok ci azi nɛ, Mã adaai ɛɛti, ma ooŋna ŋaa cin iŋaan kanyak dɔl, abon arigiz gɔtɔnnya ci arogi o ŋaa ka kitirak dɔl ka kavada nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Zin baale anyak gɔtɔn ceen torgɛrɛm. Ma arɔcɛ abuuwi, ma adaai iŋaan kitirak ŋaa dɔl. ");
INSERT INTO mur_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Irigizun ni gɔtɔnnya ci anowa nɔɔnɔ o ŋaa. Bodo buk adaak niini iŋaan kitirak ŋaa dɔl. Ma arigiz bodo gɔtɔnnya o anowa nɔɔnɔ ŋaa, ma adaai buk iŋaan akɔm ŋaa dɔl. ");
INSERT INTO mur_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma azɔp daayizi nici kibeen ŋaa nico lɔgɔz ceen gɔtɔn noko zɛɛ makacin idicai niigi dook torgɛrɛma kɔkɔma dɔl ci arita. Ma vurta adaawun buk ŋaa. ");
INSERT INTO mur_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Duwayet zin di, katin ma iŋaaz ɔl daayiza, ŋaa nici akati ŋaatineeŋ ŋɛnɛɛn? Ŋaabaal ɔzɔbtɔi niigi dook ŋaa nico.” ");
INSERT INTO mur_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Abacu niiga gi nico ɔrɔɔt, eeci alaŋ agayu waragɛnya o Joowo kibeen dɔyiz onin. ");
INSERT INTO mur_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Katin ma iŋaaz ɔl daayiza, alaŋ bodo arɔcɛ, bar eelit niigi kiyo toonnyawa o Joowo o. ");
INSERT INTO mur_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Zin giye ci akati ŋaazi daayiza, baale uduwak Jooi Mosis iitene baal abilni Mosis lugurgoce o alanyit e gi ci anek nɛ, Keen naana Jook o Ibrayim ki Aizak been Jakob. ");
INSERT INTO mur_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Alaŋ een zin niini Jook ci ɔl o adaai, bar Jook ci ɔl o arogi. Zin Ibrayim ki Aizak been Jakob yo nuun adaayitɔ o, ŋaan niigi arogi nɔkɔ. Abacu niiga zɔɔz nico.” ");
INSERT INTO mur_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma aku ɛɛti codoi ole o demziinto, ma aku azii ɔl ŋaati adaŋɔn kibeen Yesu. Mazi acin niini Yesu alɛɛma kaal o ajin ɔl nɔɔnɔ dook nɔkɔ, ijin buk niini nɔɔnɔ enek nɛ, “Mayo lotinowɛ dook lotinɛt jaŋ ci titiny ɔrɔɔt?” ");
INSERT INTO mur_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Lotinɛt ci titiny ɔrɔɔt nɛɛn o azi nɛ, Iziiktɔ ɔl o Israyil, Manyi onai nɛɛn Jooi doon, ma adoyi niini ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ereezit zin Jook ween Manyi unooŋ zinzeetine ugooc dook, ki rogete unooŋ dook, ki baabaninte unooŋ dook, kibeen dɔyize unooŋ dook. ");
INSERT INTO mur_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bodo lotinɛt ci titiny ano gɔɔn nico nɛɛn o azi nɛ, Ereezit ɔl o abaawonu kiyo areezu eleeti ugooc o. Akɔm zin bodo lotinɛt ci titiny ɔrɔɔt kujuk lotinok ceen ram noko.” ");
INSERT INTO mur_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma anek ɛɛti ci demziinto noko Yesu nɛ, “Gayoi, aleem didi niina gi ci azi nɛ, Adoyi Jooi ween Manyi ṯɔr nɔkɔ, ma akɔm bodo Jook oma o. ");
INSERT INTO mur_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Abon didi karɛɛz naaga Jook zinzeetine ogaac dook, kibeen baabaninowe ogaac dook, kibeen doyizowe ogaac dook. Abon buk karɛɛz ɔl o kabaawɔ kiyo karɛɛz naaga eleeti ogaac o. Lotinowa nicigi dook titinyɛ kujuk todoyok o kavaat gooya kibeen taabinɛt oogi o kagoonek Jook.” ");
INSERT INTO mur_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Mazi acin Yesu eet nico abarzek nɔɔnɔ zɔɔz aritun nɔkɔ, enek nɛ, “Alaŋ adɛyai niina baliinte o Joowo.” Enico akɔma eet ci anim bodo kijin Yesu. Otoŋole niigi nɔɔnɔ ŋaati ajini, eeci atɛɛza niini nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma vurta mazi adɛmzɛ Yesu ceeze o Joowo, enek niini niini ɔl nɛ, “Abac alaata o demziinto zɔɔz o azi nɛ, Kiristo niini Ŋɛɛrti Devid. ");
INSERT INTO mur_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Eeci baale anyek Vɔŋizi o Joowo Devid kizi nɛ, Anek Jooi Manyi onan nɛ, Aavu niina libire can azo o zɛɛ ma kanyin rocek modo ugun amarninin ineet looc zɔɔnɛ. ");
INSERT INTO mur_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mazi awo Devid alya Kiristo kizi Manyi cin. Zin bodo Kiristo een ŋɛɛrti Devid ku?” Ma atalnɛ ɔl ci meelik ɔrɔɔt ŋaati aziiŋni demziin o Yesu. ");
INSERT INTO mur_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma adɛmɛz niini nɔɔgɔ anek nɛ, “Egenyit ole o demziinto gɔɔn awɔ rumanene ci wuntik alina, ma arɛɛz zaawanɛt ci atitinyi ɔl nɔɔgɔ mɛlɛgɛnyai. ");
INSERT INTO mur_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma arɛɛz niigi ŋaati aavtiyɛ lecerene ci titiny ceezine o lotento. Ma arɛɛz vitɛn ci titiny aavtiyɛ ŋaati gɔɔn alotɛn ɔl azɔli dayiin. ");
INSERT INTO mur_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Adak gɔɔn niigi kaal ci ŋaai o bɔi, ma ayelza eleeti ŋaati aŋaryin ŋinti wun. Zin ɔl nicigi katin ajowa niigi Joowa payiin ci gɛr ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mazi aku aavi Yesu loota ŋaao ajɔŋɔz loidoŋ o gɔɔn arek ɔl muci o ceez o Joowo, icinun niini ɔl ŋaati aaranɛ guruc. Ma acin niini ɔl ci meelik ole ween arɔk aara guruc ci meelik. ");
INSERT INTO mur_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iiya ni ŋaa ci bɔyɛ amaat, ma aku aruk milinyɛt ceen ram. ");
INSERT INTO mur_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Otowa ni Yesu nuyak ogin, ma anek nɛ, “Didilɛ kaduwakuŋ igeet, ma ŋaa ci bɔyɛ amaat noko uruk niini guruc ci meelik kujuk ɔl dook. ");
INSERT INTO mur_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Eeci ɔl ogɛn aruk niigi guruc ci aŋɛra guruce ugeec meelik, maje ŋaa nici aara niini guruc ogin dayiino dook.” ");
INSERT INTO mur_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mazi aduŋna Yesu ceeze o Joowo, enek nuyaiti codoi nuyawe ogin nɛ, “Gayoi, cin di ceez ci Joowo noko kibeen biyɛn ci eenycinɛ noko alina ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma anek Yesu nɔɔnɔ nɛ, “Acin ceez ci Joowo appe noko. Oyoki katin kazaantozek biyɛn nici dook looc, kɔkɔm codoi ataadonek gɔn.” ");
INSERT INTO mur_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mazi akɔ aavi Yesu biye o kazi Kiŋiroc ŋaati acini ceez o Joowo, ivitak nɔɔnɔ Pitɔr ki Jemis ki Jɔn kibeen Andoru, ma avu ajin nɔɔnɔ ŋaati aavɛ doon. ");
INSERT INTO mur_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Anek nɛ, “Duwayet di ma kaala nici agooni tiŋa. Duwayet buk, tiŋeere ma ka kakatai kaala nici, kaga ku izi iiteni cineeŋ ajɔn o?” ");
INSERT INTO mur_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma anek Yesu nɔɔgɔ nɛ, “Egenyit! Má anyeku eet oma kalabawuŋ. ");
INSERT INTO mur_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anyak katin ɔl ci meelik azɔɔz zaare cigan avu katin azi nɛ, Aneeta Kiristo nɛɛn. Alabek zin katin niigi ɔl tuu. ");
INSERT INTO mur_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mazi katin aziiŋnu oroonok ci ajɔn kibeen awaŋ ci oroonok ci rɛɛn, má anyeku zinzeeti kivirit, eeci kaal nici ŋɛdɛt katin agooni, bar zin ŋaan rak koṯorɛi lɔɔci. ");
INSERT INTO mur_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Katin ɔl ci looc oma ɔɔr ɔl ci looc oma. Ma amɔɔt tɔdɔwa kirakirak loocowe ogɛn, ma anyak loocowa tarjo. Zin nicigi kanaan ci looc libento, ma abil olla kiyo wucezi o gɔɔn aami ŋaa dole o. ");
INSERT INTO mur_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Egenyit zin niiga alya. Agamnyuŋ katin ɔl igeet, ma avoyuŋ ceezine o roonnyo. Ma adookuŋ ceezine o lotento. Ma avoyuŋ alaate o abal ɔl. Zin giye o atuyaŋ niiga aneet, animnyu katin niiga uduktak nɔɔgɔ zɔɔz onan een didi. ");
INSERT INTO mur_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Zin rak ɔɔwa ma ŋaan koṯorɛi lɔɔci, uuwawonek rak kaviyawa o Joowo modɛn dook. ");
INSERT INTO mur_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Zin ma agamnyuŋ ɔl igeet, ma avoyuŋ roonnyi giye o atuyaŋ niiga aneet, má anyeku zinzeeti kivirit giye ci ka udukta. Ma iiya iiteni nica olla udukta zɔɔz ci anyuŋ Jooi igeet, eeci alaŋ azoozu niiga dɔyize cunooŋ doon, bar Vɔŋiz o Joowo nɛɛn o ŋaan anyuŋ igeet ozoozit. ");
INSERT INTO mur_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Buk katin gɔɔn ɛɛti ce akɔyi gɔtɔni daayiza. Maje ɛɛti ce akɔyi ŋɛɛrin daayiza. Maje buk dɔlya amarnin baatigeec ki yaatigeec, ma avɔyi nɔɔgɔ daayiza. ");
INSERT INTO mur_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɔl dook katin amarninuŋ igeet, eeci atuyaŋ niiga aneet. Zin ɛɛti ci agam ɛlɛ zɛɛ ma aṯornɛkɛ lɔɔci arogoz Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Abon agayu kɛŋ ci zɔɔz oma ce juruŋ. Ma acinu katin ceeze o Joowo manyilibe o gɛr ɔrɔɔt, abon ɔl o Judiya avironek biyɛn. ");
INSERT INTO mur_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mã aavi ɛɛti ceez tadena, abon aduŋna, ma adɔkɔny enice calaŋ akɔ ceeza tɔ ka kook kodoma kaal ogin. ");
INSERT INTO mur_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mã aavi ɛɛti mana, abon avir enice calaŋ abadaak kɔrɔk ka kodoma rum cin malkinto. ");
INSERT INTO mur_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nɔŋ ci gɛr katin ŋaane o anyake iinyaye niceke, kibeen ŋaane o arɔkti. ");
INSERT INTO mur_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ijinit Jook ŋaryiinta ka calaŋ iina kaal nica lɔɔla. ");
INSERT INTO mur_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eeci iinyaye niceke anyak lɔɔci libɛn ci ŋaan laadun kiita ŋaan baal ɛɛnycanɛ Jooi looc e zɛɛ been inoko o. Ma alaŋ buk katin bodo iina gi ci abil nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mã da calaŋ atɛɛt Jooi iinya niceke kizi kidicɛ, akɔm koca eet ci arogi. Bar zin giye o ka korogti ɔl oginɛ aŋɛra, anyewun niini iinya niceke kizi kidicɛ. ");
INSERT INTO mur_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Zin iitene nice mã anyak eet ci anekuŋ nɛ, Icinit di Kiristo ceeni, karabɔŋ anekuŋ nɛ, Nɔɔnɔ nɛɛn caana, má aziiŋnu nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Eeci katin anyak ɔl ci anyek eleeti kizi Kiristo kibeen ɔl ci anyek eleeti kizi nyakaŋanɛt. Ɔl nicigi katin agɔɔn kaal ci atɛɛt ɔl biye ka kalabtai ɔl o aŋɛra Jooi. ");
INSERT INTO mur_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Egenyit zin, eeci kuduwayuŋ kaal nicoko dook maŋaan kakati o. ");
INSERT INTO mur_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Bar zin iinyaye ci ano looc libɛn nice ookci ii kizi koli, ma alaŋ nyɛlɔyi alanyit. ");
INSERT INTO mur_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Maje monyonya iina tammu tadena, maje kaala o ɛɛl tammu bɔbɔra amɔɔt, ma ookci. ");
INSERT INTO mur_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Zin iitene nice ŋaan acinan katin ɔl aneeta Ŋɛɛrti Eeto ŋaati kakunɛ diizwani dɔyize ci appe kibeen titinyɔnta. ");
INSERT INTO mur_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma kitoon katin toonnyak o Joowo kɔɔt kuluta ɔl o ɛŋɛra Jooi looc libirɔ dook.” ");
INSERT INTO mur_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ma azi Yesu bodo nɛ, “Ojokta niiga zɔɔz nico keete ween moneec. Gɔɔn mã uvurutit oto oginɛ, ma aryek bɔlɔk ci colai, kaga izi ŋinti ka kiiyai lɔɔlɔ. ");
INSERT INTO mur_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Zin buk mã acinu libɛn nico, agaac niiga kizɛ naana ajɔn ɔrɔɔt ɛlɛ ka kiiya. ");
INSERT INTO mur_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Didilɛ kaduwakuŋ igeet, ɔl ogɛnɛ katin ole ci arogi inoko o alaŋ adaai zɛɛ ma acin libɛn nico ŋaati iinanɛ. ");
INSERT INTO mur_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tammu taden kibeen tɔdɔ katin adicai, maje zɔɔz onane abil kɛlɛɛmnyai nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Akɔm eet ci aga iiten ci katin iinanɛ kaala nici o. Buk toonnyawa o Joowo alaŋ aga. Naana alya Ŋɛɛrti Joowo alaŋ buk kaga. Bar aga baaba doon. ");
INSERT INTO mur_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ebeyit zin eleeti eeci alaŋ agayu iiten nice aku tiŋa. ");
INSERT INTO mur_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Atobɔ zɔɔz nici kibeen zɔɔz o eet o ɛɛrɔn o. Mazi ka kɛɛrɔn, aricanek niini gabara ogin zɔɔz ci ka kuzuuti kɔrɔk. Ma anyek gɔɔn gabaren co liŋliŋɔn cin doon. Ma aricanek buk niini eet o abɛk araan ka kɛbɛk araan juruŋ. ");
INSERT INTO mur_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Egenyit zin! Iziti vililɛ, eeci alaŋ agayaŋ niiga aneet kakun tiŋa. Karabɔŋ kakun yomana, karabɔŋ een baalin kɛŋa, karabɔŋ een ŋaati amamani tammu, karabɔŋ een ŋeere. ");
INSERT INTO mur_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Zin mã kakunakuŋ boyoŋyoŋ, abon kajowanuŋ eeginu vililɛ calaŋ ooginu. ");
INSERT INTO mur_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma gi ci kaduwakuŋ igeet noko, kaduwai buk ɔl dook. Kiziti vililɛ.” ");
INSERT INTO mur_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Inoko eelit iinya raman ci ka kulutɔi ɔl ka kadakti dayiin o aadanɛ vardaŋinɛt. Buk iiteni nici iiten o gɔɔn adayi niigi ḏɔkɛn calaŋ amokcar. Orooŋit ni alaata o ceez o Joowo kibeen ɔl o demziinto gɔl ci ka kagamti Yesu ka kuruyit nɔɔnɔ kadaak kɔkɔm eet ci aga. ");
INSERT INTO mur_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ma anɔ nɛ, “Alaŋ abon ŋaati kagɔɔni nɔkɔ iitene ci aadanɛ ɔl vardaŋinɛt o, eeci koca ayoket ɔl.” ");
INSERT INTO mur_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Maje Yesu aavi kuture o kazi Bezani adake ole o Saiman baal anyak mɔɔriz o gidaŋ e. Mazi ŋaan adake nɔkɔ, iiyak nɔɔnɔ ŋaa oman anyaa ketezewoc ci anyak karacoc o kazi narat ci ataalyai guruce ci meelik ɔrɔɔt. Ma alip ŋaa nici ketezewoc inyaa, ma aḏuutɛkɛ niini Yesu karacoc nico ɔɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bar ŋinaante otoborit ɔl ogɛn nɔŋ, ma anɔ nɛ, “Mayo aminaŋi laadun karacoc gaga naa? ");
INSERT INTO mur_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Abon waan ataalinɛ karacoc nico ka kojowa guruc ci meelik ka kanyek ɔl ci amaat.” Ozoozit ni niigi ŋaa nico ɔrɔɔt, ma arɔɔŋ kanyaaktak nɔɔnɔ alyaan. ");
INSERT INTO mur_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma bar anek Yesu nɔɔgɔ nɛ, “Amilanu ŋaa nico zɔɔza gaga naa? Otoŋit nɔɔnɔ. Agoonekan niini aneet gi ci abon. ");
INSERT INTO mur_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Aromenu niiga kibeen ɔl ci amaat o ŋina. Mã arooŋnyu itiritit nɔɔgɔ, ŋaan atiritu, maje naana alaŋaan bodo kaavɛ ŋaatunooŋ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ma ŋaa nici agɔɔn gi ci anim niini kutugu. Aḏuutekan niini aneet karacoc o ka kidimdiman dawiin onan ma ŋaan kadaak o. ");
INSERT INTO mur_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Didilɛ kaduwakuŋ igeet, tiŋeere loocowe o uuwayi ɔl kaviyak o Joowo dook, aduwa buk ɔl gi ci abon agɔɔn ŋaa nicini noko, ma aada ɔl nɔɔnɔ giye nico.” ");
INSERT INTO mur_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ɔtɔɔ ni Judaz Iskariyot ween nuyai codoi nuyawe ween amɔtɔ ram ook alaate o adikir ceeze o Joowo ka kook kuduwak nɔɔgɔ gɔl ci agami niigi Yesu. ");
INSERT INTO mur_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mazi avɔ azii niigi gi nico, ataltɔ ɔrɔɔt ɛlɛ, ma anek niigi nɔɔnɔ nɛ, “Mã aduwaket gɔl ci kagamnya Yesu, kanyin koca guruc.” Orooŋun ni Judaz gɔl ci ka kɛyɛlɛkɛ nɔɔgɔ Yesu. ");
INSERT INTO mur_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ma iitene o oowu iinyaye o gɔɔn adayi ɔl o Juz ḏɔkɛn o alaŋ amokcar, otodoŋit niigi nyɔɔ ci ka kaadai vardaŋinɛt. Ma ajin nuyawa Yesu anek nɛ, “Koota yo ŋaaḏaŋ ka koota kidimdimanta dayiin ci kaadanɛ vardaŋinɛt?” ");
INSERT INTO mur_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Otowa ni Yesu nuyak ram, ma anek nɔɔgɔ nɛ, “Ɔɔtɔ Jerusalɛma. Avɔ arumonu tedec ŋinaante kibeen eet ci anyak maam ija. Oneec zin nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mazi akɔ arum ɛɛti ci anuyu noko kɔrɔk, enektek eet ci korgu o nɛ, Anekin gayoiti nɛ, Abil ceez ci ka koota kadakta ki nuyak ogan dayiin o kaadanɛ vardaŋinɛt ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ŋinaante ŋaan ayelekuŋ niini ceez ci ɛɛnyci gɔn tadena ci anyak kaal dook o karɔɔŋ naaga kadakti dayiin. Ɔɔtɔ zin utuguz dayiin cigaac ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ma iŋaaz nuyawa avɔ Jerusalɛma, ma avɔ didi ajowa kaal dook e ona aduwakɛ Yesu nɔɔgɔ e. Ma adimdiman niigi dayiin o aadanɛ vardaŋinɛt. ");
INSERT INTO mur_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma yomana ivita Yesu kibeen nuyak ween amɔtɔ ram ɔɔtɔ ŋaa ona agooninɛ dayiin e. ");
INSERT INTO mur_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mazi avɔ adake, enek niini nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, ataalinan tiŋeere ɛɛti codoi ŋaatunooŋ igeet ɛlɛ ci kazɔlɔ noko.” ");
INSERT INTO mur_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma abaaban nuyawa gi nico zinzeetinɛ ɔrɔɔt ɛlɛ, ma anek gɔɔn ceeni Yesu nɛ, “Ci aduwa o aneeta gi? Aneeta gi?” ");
INSERT INTO mur_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma anek Yesu nɔɔgɔ nɛ, “Ɛɛti codoi ŋaatunooŋ igeet ci eeginu amɔtɔ ram kazɔlɔ kodooce codoi noko akɔ tiŋeere ataalinan aneet. ");
INSERT INTO mur_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mazin naana Ŋɛɛrti Eeto ŋaan kadaai eo aduwan waragɛ o Joowo laadun. Bar zin nɔŋ ci kol eete ci ataalinan aneeta Ŋɛɛrti Eeto alaatɛ o. Maya da bar niini ŋaati alaŋ aritan been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mazi ŋaan adake niigi nɔkɔ, odoma Yesu ḏokoc, ma anyek Jook zany, ma atɛɛt ḏokoc nico, ma aŋerek nɔɔgɔ anek nɛ, “Adayit. Nicini ɛlɛ onan nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bodo adoma diic ci anyak nyaan, ma anyek Jook zany, ma anyek nɔɔgɔ kowodit. ");
INSERT INTO mur_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma anek niini nɔɔgɔ nɛ, “Nicigi biye ogan aḏuuti ka kojokta ɔl ci meel bonat. Ma biyeta nici idica terkediin baal aterkedek Jooi ɔl ogin aŋɛra niini e. ");
INSERT INTO mur_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Didilɛ kaduwakuŋ igeet, alaŋ bodo kawudi nyaan nico nɔkɔ zɛɛ ma kakɔ kawudi nyaan ci colai baliinte o Joowo.” ");
INSERT INTO mur_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ebenit ni niigi enico beniin ci Joowo, ma awɔ avɔ biye o kazi Kiŋiroc. ");
INSERT INTO mur_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ma anek Yesu nɔɔgɔ nɛ, “Niiga dook aviryu tedec otoŋteyaŋ looc. Eeci azi Jooi waragewe onin nɛ, Karui tiŋeere eet o towawiinto kazaantɛ ɛɛzana. ");
INSERT INTO mur_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Zin tiŋeere mã kitiŋa naana daayiza, kakɔ Galiliya ɔɔwa ŋaatunooŋ. Ŋaan zin kavɔ karumɔ ki igeet ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma anek Pitɔr nɔɔnɔ nɛ, “Mayo nuun avir ɔl dook, alaŋ naana kavir ŋaatun kotoŋeyin looc been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma anek Yesu Pitɔr nɛ, “Didilɛ kaduwakin ineet, adaŋnye tija zɛɛ been lak iiyu iŋaan kɔrɔk toloci lak ram.” ");
INSERT INTO mur_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Maje bar Pitɔr aduv ɔrɔɔt azi nɛ, “Mayo nuun ka kadaayit ki ineet, alaŋ bai kadaŋnye nɔkɔ been nɛɛn.” Ma aduwa buk nuyawa dook zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mazi avunak niigi ŋino kazi Gezemani, enek Yesu nuyak nɛ, “Aavtiz ŋina. Kakɔ rak naana kaŋaryɛ ŋaate.” ");
INSERT INTO mur_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ma akɔyi niini Pitɔr ki Jemis ki Jɔn. Ma akunak nɔɔnɔ inoni ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma anek niini nɔɔgɔ nɛ, “Kanyei naana ziniza inoni ci appe ɔrɔɔt ci ajonini daayizi. Aavtiz zin niiga ŋina ebeyit eleeti ŋaryiinta.” ");
INSERT INTO mur_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma iicak niini kidicilim, ma abayek ɛlɛ looc, ma ajin Jook ka kozooti nɔɔnɔ calaŋ apirna daayiza. ");
INSERT INTO mur_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma ajin Jook azi nɛ, “Baaba, aboke kaala dook ŋaatun. Nyɛyi zin piryakzɛt ci ka kiiyayan noko ŋaatan. Bar zin tugu eo arɔɔŋɛ niina, alaŋ een eo karɔɔŋɛ naana.” ");
INSERT INTO mur_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mazi abada ŋaryiinta, amada nuyak ween iiyu e oogin. Ma anek niini Pitɔr nɛ, “Saiman, ooginu naa? Akɔmnekuŋ ŋaati abeyinu ŋaryiinta ziit codoi ṯɔr nɔkɔ? ");
INSERT INTO mur_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Iziti vililɛ. Aŋaruyɔ ka calaŋ acinanuŋ Loryen zinzeeti zɛɛ ma agoonu oŋɛ. Eeci zinzeeti ugooc arɔɔŋ kutuguzɔ kaal ci abon, maje bar eleeti cugooc o alaŋ anyak dɔyiz.” ");
INSERT INTO mur_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bodo amiiri niini, ma akɔ aŋaryɛ aduwa zɔɔz we ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mazi abadaak nuyak, amada nɔɔgɔ oogin bodo, eeci adoŋ niigi ɔrɔɔt. Mazi iiŋka niini nɔɔgɔ, alaŋ aga niigi gi ci ka kuduktak nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma akɔ bodo ŋaryiin zɛɛ mazi abada ŋaryiinta eceen lak iiyu o, amada nuyak bodo oogin. Ma anek nɔɔgɔ nɛ, “Ŋaan dim ooginu ayubuzu nɔkɔ? Odot zin. Iiya ziiti o ka kipirai. Inoko kanyozozeya naana Ŋɛɛrti Eeto ɔl o oŋenu. ");
INSERT INTO mur_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Itiŋgaz! Kɔtɔɔz! Icinit di, eet o ka kataaloyan nica izi ajɔn.” ");
INSERT INTO mur_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mazi ŋaan azɔɔz Yesu nɔkɔ, urum Judaz Iskariyot looc. Ɔrkɔra niini ki kɔlɛ ci anyak kabazwa ci wuntik kibeen kɛɛn ceen ŋolonɛt. Ma ɔl nicoko itoona alaata o adikir ceeze o Joowo ki ɔl o demziinto kibeen ɔl o baayizo titiny. ");
INSERT INTO mur_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Maje Judaz uyene uduwak ɔl nicoko gi ci anek nɛ, “Ɛɛti ci kakɔ ŋaatin, ma kacoco nɔɔnɔ ŋalyamoc zaawinta o, eet ci arooŋnyu o nɛɛn. Agamit nɔɔnɔ, ma abeku juruŋ ka calaŋ avir ŋaatunooŋ.” ");
INSERT INTO mur_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Iiya ni Judaz, ma akɔ ŋaati Yesu, ma azaa niini Yesu azi nɛ, “Gayoi.” Ma acoco nɔɔnɔ ŋalyamoc. ");
INSERT INTO mur_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma avu ɔl ci ona ɔrkɔra ki nɔɔnɔ o, ma agam Yesu. ");
INSERT INTO mur_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ovoca ni ɛɛti codoi ole o aavtiz ŋinaante kabaz tibila, ma aruk gabaren ci alaan o adikir ceeze o Joowo kɛtɛɛda itat, por. ");
INSERT INTO mur_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma anek Yesu nɔɔgɔ nɛ, “Akɔ ma avunakaŋ kabazwani ki ŋolonɛtɛ kiyo avunaku eet ceen agoryai o naa? ");
INSERT INTO mur_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tup nɔkɔ gɔɔn karomɛ ki igeet ceeze o Joowo adikir ŋaati kadɛmzinɛ, ma ŋaan agamtaŋ niiga aneet. Bar zin inoko gi o aduwa waragɛ o Joowo baale didi ibil tɔ.” ");
INSERT INTO mur_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Zin ivirit nuyawa dook otoŋtek Yesu doon looc. ");
INSERT INTO mur_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma ano logoti codoi Yesu. Maje logoti nici amalik rum codoi ṯɔr nɔkɔ. Mazi arɔɔŋ kagamit ɔl nɔɔnɔ, ");
INSERT INTO mur_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bar ibica niini nɔɔgɔ kodotek rum cin malkinto o looc, ma adɔkɔny ŋaḏinyiny nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma avɔyi ɔl Yesu korge o alaan o adikir ceeze o Joowo. Ma alotai alaata o ceez o Joowo kibeen ɔl o demziinto ki ɔl o baayizo titiny. ");
INSERT INTO mur_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Maje Pitɔr ano Yesu rɛɛna, ma akɔ kaluwawe o kɔrɔk o alaan o adikir. Ma akɔ aavɛ goo aromɛ niini kibeen ɔl o abɛk kɔrɔk o alaano. ");
INSERT INTO mur_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","56","Ma ŋinaante odomta alaata o adikir ceeze o Joowo kibeen ɔl o roonnyo dook orooŋit bacok ci aduwa zɔɔz ci gɛr akati Yesu ka kapaktɛkɛ nɔɔnɔ daayiz. Bar akɔm bacok ci ajowa niigi aduwa gi ci alɛɛma ci akati Yesu, eeci ɔl ci meelik aduwa vɔlɔŋ ci akani niini nɔɔnɔ, bar molokwana cigeec o alaŋ atobɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Gɔɔn iŋaaz ɔl ogɛnɛ jena, ma aduwa vɔlɔŋ ci akatni Yesu azi nɛ, “Kaziikna iiten baale nɔɔnɔ azi nɛ, Kooyoi iiten oma ceez ci Joowo baal ɛɛnyca ɔl ci deer noko. Ma bodo kɛɛnyca naana oma iinyaye ceen iiyu nɔkɔ calaŋ ɛɛti ci deer anim kɛtɛɛnya.” ");
INSERT INTO mur_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Buk bodo molokwana ci ɔl nicoko o alaŋ atobɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Itiŋa ni alaani o adikir ceeze o Joowo, ma ajin Yesu anek nɛ, “Akɔm dim niina gi ci abariz kaale ci aduwa ɔl nicigi noko?” ");
INSERT INTO mur_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Maje Yesu ajaki, kɔkɔm gi ci abariz. Bodo ajin alaani nɔɔnɔ anek nɛ, “Een niina Kiristo ween Ŋɛɛrti Joowo nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Aneet nɛɛn. Iiten oma acinaŋ aneet Ŋɛɛrti Eeto kaavɛ libire o azo o Jook o Adɔi, ma ŋaan acinaŋ katin niiga aneet ŋaati kakunɛ diizwani tammu tadena.” ");
INSERT INTO mur_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Enico ɛrɛɛc alaani nici rum onin maany bornɛt nɔŋa, ma azi nɛ, “Alaŋaan bodo karɔɔŋ bacok ci ka kuduktayet gi ci gɛr agɔɔn ɛɛti nici. ");
INSERT INTO mur_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Inoko iziiktu niiga momoz cin amomozi niini Jook o. Mayo zin inoko apayeku niiga nɔɔnɔ naa?” Ma azi niigi dook nɛ, “Aganɔ niini kibeen daayiz.” ");
INSERT INTO mur_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma oortek ɔl ogɛn ŋaatineeŋ nɔɔnɔ amot, maje ɔl ogɛnɛ abuŋ nɔɔnɔ kɛbɛrɛ ruma, ma aruk, ma bodo ajin anek nɛ, “Ɔl cigaŋ ci arukin o?” Ma anyek niigi nɔɔnɔ ɔl o beyiinto, ma aruk niigi buk nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Maje Pitɔr ŋaan aavi kaluwawa nɔkɔ. Iiya ni dole ci aliŋliŋonek alaan o adikir. ");
INSERT INTO mur_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mazi acin Pitɔr ŋaati aavɛ goo noko, ɛgɛlɛm niini nɔɔnɔ ɔrɔɔt, ma anek nɛ, “Orkoryu ri buk gɔɔn niina kibeen Yesu ci Nazarɛt noko.” ");
INSERT INTO mur_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bar adaŋnyi niini azi nɛ, “Alaŋ kazii zɔɔz ci aduwa o.” Ma adun niini akɔ abil araan tatoga. Taman nɔkɔ ɔrɔk toloci. ");
INSERT INTO mur_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mazi acin dole bodo Pitɔr, uduwak ɔl ci aavtiz ŋinaante enek nɛ, “Ɛɛti nici nuyai ci Yesu.” ");
INSERT INTO mur_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bar Pitɔr adaŋnyi bodo. Ŋintimiliny enektek ɔl ci aavtiz ŋinaante o Pitɔr nɛ, “Ŋɛdɛt niina een nuyai ci Yesu, eeci een buk niina eet ci Galili.” ");
INSERT INTO mur_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Enico uduwa Pitɔr ŋaati itooni Jook gi ci azi nɛ, “Kaduwa naana gi ci kaleem. Alaŋ kaga eet ci aduwanu o. Mã kalabanuŋ, adakan koca Jooi.” ");
INSERT INTO mur_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Taman nɔkɔ ɔrɔk toloci bodo, ma aada Pitɔr zɔɔz baal aduwak Yesu nɔɔnɔ baal anek nɛ, “Adaŋnyan tiŋeere niina aneet lak iiyu iŋaan kɔrɔk toloci lak ram e.” Mazi aada niini zɔɔz nico, utulu ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ma ŋeere olotai alaata o adikir ceeze o Joowo taman kibeen ɔl o demziinto kibeen ɔl o baayizo titiny, ma avu abaaban niigi dook gi ci ka kutuguzek Yesu. Acabit ni niigi nɔɔnɔ azɛɛn, ma avɔyi alaane o kazi Pailat. Niini eet ci ɔl o Rom, ma abal Judiya. ");
INSERT INTO mur_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma ajin Pailat Yesu anek nɛ, “Ineet alaan o ɔl o Juz nɛɛn?” Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nɛɛn ci aduwa niina o.” ");
INSERT INTO mur_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bodo alaata o ceez o Joowo aduwa kaal ci gɛr meelik akati Yesu. ");
INSERT INTO mur_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma ajin Pailat bodo Yesu anek nɛ, “Akɔm dim gi ci abariz? Alaŋ azii kaal ci gɛr akanin ineet aduwa ɔl noko dook?” ");
INSERT INTO mur_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Buk enico ɔkɔm Yesu gi ci abariz. Makacin abaraŋɛ Pailat ɔɔ ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Maje waanice gɔɔn ma een iiten o adayi ɔl o Juz dayiin o aadanɛ vardaŋinɛt, aboroc Pailat eet codoi ole o acabje ci tɛ arɔɔŋ ɔl nɔɔnɔ koborocai. ");
INSERT INTO mur_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma enice anyak eet ci kazi Barabas ci acabje kibeen gɔnɔgi oogi giye ci aborni niigi akuma, ma ayɔwɔ ki takirnya zɛɛ makacin uruyit niigi ɔl koogi kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Olotai ni kɔlɛ, ma avu ajin Pailat ka koborcak niini nɔɔgɔ eet oma eonin gɔɔn agɔɔni laadun iinyaye o gɔɔn aadanɛ ɔl vardaŋinɛt. ");
INSERT INTO mur_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma ajin niini nɔɔgɔ anek nɛ, “Arooŋnyaŋ kɔɔgayuŋ alaan o Juz?” ");
INSERT INTO mur_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Maje Pailat aga niini alaata o ceez o Joowo anyaa Yesu giye ci olla amadiyi niigi nɔɔnɔ gaga nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bar alaata o ceez o Joowo otoŋomtek kɔlɛ dook ka kijinit Pailat kotoŋ Yesu, ka koborocak nɔɔgɔ Barabas. ");
INSERT INTO mur_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma ajin bodo Pailat nɔɔgɔ anek nɛ, “Ma eet ci awuyu kizi alaan ci ɔl o Juz o arooŋnyaŋ kutuguwek nɔɔnɔ naa?” ");
INSERT INTO mur_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma ɛgɛrɛny niigi bodo anɔ nɛ, “Tɔdɔ nɔɔnɔ kadaak keete ween talakec.” ");
INSERT INTO mur_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma ajin Pailat nɔɔgɔ anek nɛ, “Naa? Agɔɔn niini gi ci gɛr jaŋ?” Bar enico agɛrɛny niigi ɔrɔɔt kujuk we azi nɛ, “Tɔdɔ nɔɔnɔ kadaak keete ween talakec.” ");
INSERT INTO mur_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mazin giye o arɔɔŋi Pailat kɔlɛ kataltɔi, ɔɔgak niini nɔɔgɔ Barabas. Ma anyek Yesu kuruyit takirnya nyaboyɛn zɛɛ ma vurta anyek nɔɔnɔ takirnya kɔɔt kotodeec kadaak keete ween talakec. ");
INSERT INTO mur_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ma ayit takirnya Yesu avɔyi ŋaa uneeŋ abaayi kaluwawe o kɔrɔk o Pailat. Ma alotai niigi dook. ");
INSERT INTO mur_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma avu aborcɛkɛ Yesu rum ci meeri, ma agɔɔna nyagirgir ceen bila, ma arekɛ nɔɔnɔ ɔɔ. ");
INSERT INTO mur_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ma azaa niigi nɔɔnɔ momozɛnta anek nɛ, “Abona alaan o ɔl o Juz. Rok bai nɔkɔ kodot.” ");
INSERT INTO mur_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ma anyɔnɛ niigi nɔɔnɔ ŋaati aruyi ɔɔ keete ci miliny, ma oortek amot, ma bodo akani kozoŋti looc adiŋdiŋan nɔɔnɔ momozɛnta. ");
INSERT INTO mur_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mazi odotiz niigi momozente nico, uburuca ŋaatin rum ona arikɛ nɔɔnɔ e, ma aborcɛkɛ rumanɛ ogin laadun. Ma avɔyi nɔɔnɔ kutur bitaala ka kɔɔt kotodeec keete ween talakec. ");
INSERT INTO mur_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma gɔla urumtɔ niigi kibeen eet ci kazi Saiman ci looc o kazi Sariin. Niini baati Alikzandar ki Ruvas. Mazi anowa niini gɔl akunak Jerusalɛm, agamit takirnya nɔɔnɔ, ma adaŋek kitik kɛɛt ween talakec o ka kɔɔt kotodoyi niigi Yesu. ");
INSERT INTO mur_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma anyaak niigi Yesu ŋinti kazi Golgoza o akati kɛŋ cinɛ amɛn ci oowu. ");
INSERT INTO mur_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma anyek niigi nɔɔnɔ nyaan ci acanɔ kibeen agɛrɔ o kazi mir, ma abor Yesu ŋaati awudi. ");
INSERT INTO mur_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Otodooc ni niigi nɔɔnɔ keete ween talakec. Ma aar niigi maadico ci ka kiitazakɛ gɔɔn eet co rum cinɛ rumanene o Yesu. ");
INSERT INTO mur_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Adɔdɔ niigi nɔɔnɔ ziiye ween tɔrkɔc ŋeere. ");
INSERT INTO mur_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma ayɛɛt niigi zɔɔz o apayek niigi Yesu azi nɛ, “Nici alaan o ɔl o Juz.” Ma amadanek zɔɔz nico waragɛwa talakec ci adodinɛ Yesu o tadena. ");
INSERT INTO mur_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma buk adɔdɔ niigi agoryak ceen aamnyok een ram keene ween talakɛn. Arek codoi Yesu aza, maje codoi arek kaŋeta. ");
INSERT INTO mur_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mazi acin ɔl ci olla awɔ gɔla Yesu, ararni niigi nɔɔnɔ zɛɛ ma arurut ooti, ma amomoz anek nɛ, “Aa. Een ri eet baal azi nɛ ka ɔyɔk ceez o Joowo, ma bodo ɛɛnyca iinyaye ceen iiyu e nɛɛn. ");
INSERT INTO mur_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Rogoz zin di ɛlɛ. Duna keete nico.” ");
INSERT INTO mur_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma ararni buk alaata o ceez o Joowo kibeen ɔl o demziinto Yesu anɔ nɛ, “Arogoz niini ɔl oogi doon, bar alaŋ anim korogoz ɛlɛ onin maany.” ");
INSERT INTO mur_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ma anek niigi Yesu nɛ, “Mã een didi niina Kiristo ween alaan o Israyil nɛɛn, duna keete nico. Mã agoon nɔkɔ, katuyin koca naaga ineet.” Bodo agoryawa o adɔdi ki nɔɔnɔ keene ween talakɛn e amomoz buk niigi Yesu. ");
INSERT INTO mur_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mazi akɔ abil ii boloca, otoozyai lɔɔci dook kizi muur zɛɛ been ziik iiyu yomana. ");
INSERT INTO mur_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Mazi akɔ een ziik iiyu, ɛgɛrɛny Yesu molowe ci appe otoge uneeŋ azi nɛ, “Eloi, eloi. Lama Sabaktani.” Ma kɛŋ ci zɔɔz nico azi nɛ, Jook onan, Jook onan, ooŋnan naa? ");
INSERT INTO mur_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mazi azii ɔl ogɛn ole o aavtiz ŋinaante zɔɔz nico, izitɔ nɛ, “Iziiyit di! Awo niini Ilija.” ");
INSERT INTO mur_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma adɔkɔny ɛɛti codoi ŋaatineeŋ, ma ajukek tovot nyaan ci amokcar, ma akat moroka, ma itoonek Yesu ka kococo. Ma anek ɛɛti oman gɔnɔgi nɛ, “Kereec di ka kicinit karabɔŋ aku Ilija ka kaarak nɔɔnɔ looc.” ");
INSERT INTO mur_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Enico ɛgɛrɛny Yesu bodo molowe ci appe, ma atɛɛt. ");
INSERT INTO mur_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma areeci rum o gɔɔn abilɛnɛ ɔl ceez o Joowo, akani reecinɛt tadena zɛɛ been tir loota. ");
INSERT INTO mur_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Maje alaani ci takirnyawu abil ajɔŋɔz ŋinti ona adodinɛ Yesu o. Mazi acin niini gɔl o adaakni Yesu been gernyi onin, izi nɛ, “Didilɛ ɛɛti nici tɛ Ŋɛɛrti Joowo gi.” ");
INSERT INTO mur_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Buk ŋinaante anyak ŋaai ci agɛlɛm Yesu rɛɛna. Ma ŋaane nicoko aavtiz tɔ Meri o looc o kazi Magdala, ki Salomi, kibeen Meri ween yaati Josev ki Jemis o miliny. ");
INSERT INTO mur_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ma ŋaai nici baale gɔɔn ano niigi Yesu Galiliya, ma atirit nɔɔnɔ. Ma buk anyak ŋaai ci meel oogi ci baal ɔrkɔra ki Yesu avunak Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma iiteni nica iiten o gɔɔn aṯornɛkɛ ɔl o Juz liŋliŋɔnta, ma apɛrpɛrani niigi eleeti, eeci tiŋeere een iiten o yubzento kazi Sabit. Mazi ka kizi lɔɔci yoman, iiya ɛɛti ci kazi Josev ci looc o kazi Arimatiya. Niini alya eet ci abon gɔɔn atitiny ɔl nɔɔnɔ ole o roonnyo, ma buk niini arɛ kuni o baliin o Joowo. Ook ni niini ŋaati Pailat moozɛta, ma akɔ ajin nɔɔnɔ ka kook kaara ɛlɛ o Yesu talakeca ka kook kada. ");
INSERT INTO mur_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma abiir Pailat ɔɔ giye ci adaayi Yesu kataman o, ma awa alaan o takirnyawu, ma ajin nɔɔnɔ ka kuduwak mã adaak Yesu. ");
INSERT INTO mur_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mazi akɔ azii Pailat adaak Yesu didi, anyewun Josev kook kaara ɛlɛ o Yesu talakeca. ");
INSERT INTO mur_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ma ataala Josev rum ci abon, ma akɔ aara niini ɛlɛ o Yesu keete ween talakec, ma aku atuuzek rum nico. Ma akɔ arek bɔɔt ci adayai biya, ma abɔrbɔrana bɛ ci appe, ma anyoogi bɔɔt otok. ");
INSERT INTO mur_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maje Meri o looc o kazi Magdala kibeen Meri yaati Josev agɛlɛm ŋinti aronek ɛlɛ ci Yesu o nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mazi akɔ aṯornɛkɛ iiteni o yubzento kazi Sabit, ɔɔtɔ Meri o looc o Magdala ki Salomi kibeen Meri ween yaati Jemis, ma avɔ ataala karkar ci aŋɔl madiz ka kɔɔt kuḏuutek ɛlɛ o Yesu bɔɔta. ");
INSERT INTO mur_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma iitene o yubzento ŋeere ririwɔna ɔtɔɔzɔ ɔɔta bɔɔta. ");
INSERT INTO mur_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mazi ŋaan awɔ gɔla nɔkɔ, izitɔ nɛ, “Mayo tedec apiyaket bɛ o appe o bɔɔt otoga ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bar mazi avɔ agɛlɛm bɔɔt, acin bɛ ipiyai kizi vɔlɔŋ bɔɔt ɔtɔgi nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mazi avɔ niigi bɔɔta eecitɔ, acin eet ci ŋaan een logoz ci aavi bɔɔt libire ci azo o anyak niini rum ci vɔɔr. Ma abiir nɔɔgɔ ooti ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma anek niini nɔɔgɔ nɛ, “Má anyeku kibiirtuŋ ooti gaga. Kagayuŋ nɔkɔ arooŋnyu Yesu o Nazarɛt baal adɔdi keete ween talakec e. Urugun zin niini bodo daayiza. Aziitɔ ŋina. Icinit di ŋin baal arek ɔl nɔɔnɔ e nici. ");
INSERT INTO mur_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bar ɔɔtɔ ka ɔɔt uduktak nuyak ogin kibeen Pitɔr buk. Ɔɔtɔ enektek nɔɔgɔ nɛ, Arayɛ Yesu ŋaatunooŋ ook Galiliya. Ŋaan avɔ acinu tedec niiga nɔɔnɔ ŋinaante kiyo baale aduwakuŋ niini igeet e.” ");
INSERT INTO mur_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Udunta ni niigi bɔɔta, ma adɔkɔny, eeci abiir nɔɔgɔ ooti, ma aŋole looc ɔrɔɔt. Ma ŋaan buk kuduktak niigi ɔl oogi zɔɔz nico, eeci anyak niigi ŋoliin ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mazi akɔ iŋaaz Yesu daayiza iitene o yubzento ŋeere, eyelizak niini ɛlɛ rak ɔɔwa Meri o looc o Magdala baal atɔɔk Yesu ŋaatin miniŋ o Loryento een torgɛrɛm e. ");
INSERT INTO mur_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ook ni niini uduwak nuyak o Yesu ŋaati aavtiyɛ aluwi daayiz onin. ");
INSERT INTO mur_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bar mazi akɔ azii niigi zɔɔz o orogi Yesu bodo, ma ayelzakɛ ɛlɛ ŋaa nico ŋaan niigi kutuweec zɔɔz nico nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma bodo vurta eyeliza Yesu ɛlɛ alye ci awɔ doon ole ceen nuyak een ram ci avu Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma amiiri ɔl nicigi, ma avɔ aduwak gɔnɔgi, bar ni buk ɔl nici alaŋ atu zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma vurta eyelizak ni niini ɛlɛ nuyak ween amɔtɔ codoi ŋaati adayin. Ma agernyek niini nɔɔgɔ giye ci bakbayini zinzeeti, ma akɔmni tuwɛn o, eeci alaŋ atu niigi zɔɔz ci ɔl o icinit nɔɔnɔ ŋaao orogi niini daayiza. ");
INSERT INTO mur_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Enek ni niini nɔɔgɔ nɛ, “Ɔɔtɔ ozobit loocok dook uuwaktek kaviyak o Joowo modɛn dook. ");
INSERT INTO mur_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mã ɛɛti ci atuwe, ma oonyi, arogi niini waanma. Maje ɛɛti calaŋ atuwe apawonek waanma nɔɔnɔ gerzitin. ");
INSERT INTO mur_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma ɔl o atuwe kanyi waanma naana nɔɔgɔ dɔyiz ci atɔɔyi miniŋ o Loryento ɔla zaare ogan. Ma kanyi buk nɔɔgɔ dɔyiz ci azɔɔzi utugetine ci ŋaan laadun niigi kagaac. ");
INSERT INTO mur_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mã adɔŋa niigi kowanya azɛɛnɛ, alaŋ adak kowanya nɔɔgɔ. Mã awot agɛrɔ o aruk ɔl kadaayitɔ, alaŋ adaai. Mã ataadek azɛɛn ɔl ci amɔɔr, arogi ɔl nici mɔɔrizɔi.” ");
INSERT INTO mur_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mazi akɔ odotiz Manyi Yesu zɔɔza, odoŋek Jooi nɔɔnɔ tammu tadena, ma akɔ aavi niini libire o Joowo azo. ");
INSERT INTO mur_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Itiŋgazɔ ni nuyawa, ma avɔ uuwak loocowe dook. Ma atirit Manyi nɔɔgɔ, ma ayelzai uuwayi uneeŋ kizi didi kaale o atɛɛt ɔl biye agɔɔn niigi.");
INSERT INTO mur_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tipoliz o kareezin, eteyeedit baale ɔl ci meelik kaal baal agooni ŋaatinai ŋina e. ");
INSERT INTO mur_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Eteyeedit niigi kaal baal aduwaket ageet ɔl baal icinit niigi alya keberene ugeec kaal nicoko ŋaati agooninɛ e. Arak kaal nicoko cinɛnta niigi, makacin waanice uuwayit niigi zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nyakaraŋatoi o adikir, kiiya zin buk naana kɛdɛmɛza kaal nicoko dook juruŋ ŋinti wun ɔrɔɔt. Inoko zin kayeedekin naana ineet waragɛ ci kazeden kaal nicoko. ");
INSERT INTO mur_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kagoon zin nɔkɔ o, ka ga niina gi ween didi baal edemezu laadun e juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Baale irkitowe baal ɛɛnɛ Erod alaan o looc o kazi Judiya e, anyak eet ci kazi Zakeriya ceen alaan ci miliny ceeze o Joowo. Niini borit ci ɔl o kazi Abija o gɔɔn aliŋliŋ ceeze o Joowo. Zakeriya anyak ŋaa ci kazi Ilizibɛz ceen buk niini borit ci ɔl o aliŋliŋ ceeze o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ma waanice abaak Zakeriya kibeen Ilizibɛz baayiz ci abon ŋume o Joowo, ma azooni niigi dook lotinok o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Maje nɔɔgɔ akɔm dɔl cigeec, eeci waanice Ilizibɛz awɔ koliin zɛɛ makacin iziti niigi dook matuwo. ");
INSERT INTO mur_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ma iitene oman izi waŋi ci Zakeriya ka kook kiliŋliŋi ceeze o Joowo eo gɔɔn anyɔnɛ niigi liŋliŋɔn laadun. ");
INSERT INTO mur_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aŋɛra ɔl nɔɔnɔ keere uneeŋ gɔɔn agɔɔni maadico ka kook kutururek karkar goo ŋaao taabinto. Ook ni niini ceeze o Joowo eecitɔ. ");
INSERT INTO mur_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Maje ɔl dook aŋaryɛ ceez bitaala ŋinti ona akɔ arurɛkɛ niini karkar goo o. ");
INSERT INTO mur_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mazi ŋaan akɔ arurek Zakeriya karkar goo nɔkɔ, iiyak toonnyaiti ci Joowo nɔɔnɔ, ma aku abil ŋino taabinto libire ci azo o. ");
INSERT INTO mur_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Mazi acin Zakeriya nɔɔnɔ nɔkɔ, ɔtɔŋɔlɛ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bar anek toonnyaiti nici nɔɔnɔ nɛ, “Zakeriya, má aŋolinan gaga, eeci kanyaakin kaviyak Joowa. Iziiwun Jooi ŋaryiin unun. Aritakin tiŋeere ŋaa cune kazi Ilizibɛz noko logoz. Zin mazi aritai, katek zaar ci kazi nɛ Jɔn. ");
INSERT INTO mur_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Atalnɛ katin niina tiryante cin o, ma buk atalnɛ ɔl ci meel. ");
INSERT INTO mur_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Eeci niini tiŋeere titiny ɔrɔɔt ŋume o Joowo. Ma alaŋ awot nyaan been nɛɛn. Akunak tiŋeere nɔɔnɔ Vɔŋizi o Joowo iŋaan aavi yaatin kɛŋa nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Alama katin niini ɔl ci meel ole o Israyil ka kivita kiziiyit Manyi ween Jook uneeŋ. ");
INSERT INTO mur_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Arayai katin niini ɔɔwa ŋaati Manyi, ma anyak dɔyiz ci abil kiyo baal anyak nyakaŋani o kazi Ilija e. Arom bodo katin niini dɔl ki baatigeec ŋaatodoi. Abadaan tiŋeere niini ɔl o alaŋ azooni zɔɔz o Joowo kivita kabaabanit baabaninok ci ɔl o abon. Aku tiŋeere atom niini ɔl ka kidimdimanit eleeti kereec kuni o Manyi.” ");
INSERT INTO mur_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma abɛdɛkɛ Zakeriya toonnyai nico anek nɛ, “Ka zin yo naana kaga zɔɔz nico een didi o ku? Inoko naana ki ŋaa onan kidikirta naaga dook kizita matuwo.” ");
INSERT INTO mur_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma abɛdɛkɛ toonnyaiti nɔɔnɔ anek nɛ, “Aneeta Gabriyal o gɔɔn kabil ŋume o Joowo nɛɛn nici. Nɔɔnɔ nɛɛn o itoonanan aneet ka kiiya kuduwayin ineet zɔɔz ci abon noko. ");
INSERT INTO mur_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Zɔɔz nici katin didi abil tɔ iitene o arek Jooi, bar zin giye o alaŋ atuwɛ zɔɔz ci kaduwakin o, alagunyin rak Jooi inoko ineet aat calaŋ azooz zɛɛ been iiten ci abilni zɔɔz nici tɔ.” ");
INSERT INTO mur_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Agooni gi nici ceeza eecitɔ, maje ɔl ona ɛɛl bitaala e ŋaan arɛ Zakeriya nɔkɔ. Bar alaŋ aga niigi gi ci alam nɔɔnɔ ŋinti rɛɛn ceeza eecitɔ o. ");
INSERT INTO mur_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mazi akɔ aduŋnak niini bitaalin, alaŋaan azoozek nɔɔgɔ, eeci alagonyɛ aati. Enico ɛlɛ agaac niigi icinun Zakeriya ceeza eecitɔ gi ci itoona Jooi. Ma azoozek niini nɔɔgɔ azɛɛnɛ doon. ");
INSERT INTO mur_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mazi akɔ aṯornɛkɛ iinya ci liŋliŋɔn onin ceeze o Joowo, imiire ook ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma iinyaye ci miliny nɔkɔ obona ŋaa oninɛ Ilizibɛz anyawɔ, ma aavi ceeza nɔkɔ nyɛlɔwɛ tur calaŋ aduŋnak bitaalin. ");
INSERT INTO mur_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ma aduwa Ilizibɛz gi ci azi nɛ, “Nicini dɛtɛn ci anyan Jooi. Aarawan niini aneet alyaan baal kawɔyɛ koliin e.” ");
INSERT INTO mur_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Mazi akɔ een Ilizibɛz nyɛlɔwɛ ci anyayin tɔrkɔnɔm, itoona Jooi bodo toonnyai o kazi Gabriyal kiiyak kutur o kazi Nazarɛt abil looce o kazi Galili. ");
INSERT INTO mur_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anyaak niini molok ci Joowo dole ci kazi Meri ci agam nɔɔnɔ ɛɛti ci kazi Josev ka kiriyi kizi ŋaa cin. Ma ɛɛti ci kazi Josev noko dole ci dɔl ci alaan o kazi Devid. ");
INSERT INTO mur_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ma akunak toonnyaiti Meri, ma aku azaa anek nɛ, “Abona? Amayuwin Jooi ineet.” ");
INSERT INTO mur_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mazi azii Meri zɔɔz nico, anyawun ŋoliin ɔrɔɔt. Ma abiir ɔɔ zooze ci azaawi toonnyaiti nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ma anek toonnyaiti nɔɔnɔ nɛ, “Meri. Má anyei ŋoliin gaga, eeci iiyayin dɛtɛni o Joowo ineet. ");
INSERT INTO mur_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Anyake tiŋeere, ma ookca logoz. Katek zin tiŋeere nɔɔnɔ zaar ci kazi Yesu. ");
INSERT INTO mur_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tiŋeere niini titiny ɔrɔɔt. Ma awɛ kizi ŋɛɛrti Jook o adikir. Anyek tiŋeere Jooi nɔɔnɔ kizi alaan ci adikir kiyo baale jijitinɛ Devid e. ");
INSERT INTO mur_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma een tiŋeere niini alaan ci ɔl o Israyil nɔkɔ kodot, ma alaŋ alaazɛt cinɛ o aṯornɛkɛ nɔkɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma anek Meri toonnyai nɛ, “Inoko naana ŋaan keen dole ci ŋaai. Ka zin yo kanyak dole ku?” ");
INSERT INTO mur_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma abɛdɛkɛ toonnyaiti nɔɔnɔ anek nɛ, “Ŋaan akunakin Vɔŋize o Joowo. Buk dɔyizi o Joowo ŋaan aavi ŋaatun. Zin giye nico awɛ tiŋeere dole nici kizi ŋɛɛrti Joowo. ");
INSERT INTO mur_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cin di atenoi unun kazi Ilizibɛz baal azi ɔl nɛ, Alaŋaan bodo tiŋeere niini arit e. Inoko anyawun niini nyɛlɔwɛ tɔrkɔnɔm ci anyayin kizi matuwoc nɔkɔ ");
INSERT INTO mur_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eeci akɔm gi ci akɔmnek Jook ŋaati agɔɔni.” ");
INSERT INTO mur_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛbɛdɛkɛ ni Meri nɔɔnɔ enek nɛ, “Keen naana gabaren ci Joowo. Anyek kutuguwozeyan gi nici kiyo ona aduwakan o labak.” Enico ɔtɔɔ toonnyaiti ci Joowo noko ḏim. ");
INSERT INTO mur_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma iinya ci miliny nɔkɔ itiŋa Meri, ma ayiik akɔ kuture o abil biyɛnɛ looce o kazi Judiya. ");
INSERT INTO mur_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mazi akɔ arum kɔrɔk o Zakeriya, azaawun Ilizibɛz. ");
INSERT INTO mur_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mazi azii Ilizibɛz zaawinɛt ci azaawi Meri nɔɔnɔ o, ɔtɔɔmɔ dole kɛŋa. Ma akunak Ilizibɛz Vɔŋizi o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ma agɛrɛny molowe ci appe azi nɛ, “Amayukin Jooi ineet kujuk ŋaai dook, ma buk amayuk Jooi dole ci anyei kɛŋa noko. ");
INSERT INTO mur_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma naana keen ŋɛnɛɛn ci akɔ ma akunakan niina yaati Manyi onan aneet ceeze can o? ");
INSERT INTO mur_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Uyene akɔ mazi olla kazii zaawinɛt unun e, ɔtɔɔmɔ dole kɛŋa talniinta enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Amayuwin zin Jooi ineet, eeci atu niina zɔɔz baal aduwakin niini ineet e abil didi tiŋeere tɔ.” ");
INSERT INTO mur_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma abɛn Meri beniin ci azi nɛ, “Kanaati Jook zinize onan dook. ");
INSERT INTO mur_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Atalnɛ ziniz cane o ŋaaten Jook ween ruguzoi onan, ");
INSERT INTO mur_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","eeci aadawan niini aneet gabaren onin o keen cɛlbɛz labak. Inoko zin waanico zɛɛ been iinyaye ci avu e utuyan bulowa ci ŋaan avu e dook aneet kizi ŋaa ci amayukan Jooi, ");
INSERT INTO mur_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","eeci agoonekan Jooi o anyak dɔyiz dook aneet kaal ci adiŋdiŋ ɔrɔɔt. Nɔɔnɔ nɛɛn o awɔ doon. ");
INSERT INTO mur_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ayelza niini gi o awucnɛkɛ ɔl o aŋole nɔɔnɔ bulok ki bulok. ");
INSERT INTO mur_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Eyeliza niini dɔyiz ci ibaati ogin, ma azaan ɔl o adɔŋ eleeti baabaninowe ugeec. ");
INSERT INTO mur_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ma iinanɛ alaat o loocu dak, ma adɔŋ ɔl o cɛlbɛzik kɔɔt ki taden. ");
INSERT INTO mur_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anyɛrizan niini ɔl o adak magizeeti kaale ci abon, ma anyek ɔl ween arɔk kɔɔt katamaatit. ");
INSERT INTO mur_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Atirit niini ɔl o Israyil een gabara ogin kiyo baale aterkedek niini jijitigaac e. ");
INSERT INTO mur_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Baale enek Jooi nɔɔgɔ nɛ, Awucnekan katin Ibrayim kibeen dɔl ci dɔl ogin dook nɔkɔ kodot.” ");
INSERT INTO mur_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ma aromɛ Meri ki Ilizibɛz ŋinaante nyɛlɔwɛ iiyu. Itiŋa ni imiire ook ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Mazi avɔ aṯornɛkɛ iinya o Ilizibɛz nyayiinto, otowa niini logoz. ");
INSERT INTO mur_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mazi azii atenowa kibeen ɔl o abaawɔ ki nɔɔgɔ tirtɛn o anyek Jooi nɔɔnɔ, ataltɔ buk niigi dook kibeen Ilizibɛz ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mazi akɔ een dole iinya turge, ivita niigi ka kivita keteedit nɔɔnɔ kul keere uneeŋ Juz. Ma arɔɔŋ kakatek atenowa dole zaar o baatin kazi Zakeriya. ");
INSERT INTO mur_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bar azi yaatinɛ nɛ, “Akɔm, kazi zaar cigin nɛ Jɔn.” ");
INSERT INTO mur_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma anek ɔl nɔɔnɔ nɛ, “Atenowe ugooc dook akɔm eet ci anyak zaar nicoko.” ");
INSERT INTO mur_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ijinit ni niigi baati doleco azɛɛnɛ doon ka kɛtɛyɛɛdak nɔɔgɔ zaar ci arɔɔŋ kakatek dole. ");
INSERT INTO mur_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma ajin Zakeriya ɔl kanycek nɔɔnɔ waragɛ ci ka kɛtɛyɛɛdi dole zaar, ma aku ayɛɛt azi nɛ “Kazi zaar cigin nɛ Jɔn.” Ma abiir nɔɔgɔ dook ooti ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Enico ɛlɛ ɔɔgɛ Zakeriya aati kɔzɔɔz labak, ma anaat Jook. ");
INSERT INTO mur_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma anyaak zɔɔz nici ɔl o abaawɔ ki nɔɔnɔ dook ŋoliin, ma adala kaviyawa nicaga looc o Judiya abil biyɛnɛ dook. ");
INSERT INTO mur_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma ɔl dook baal iziiyit kaviyak nicoko e, abaaban niigi zinzeetinɛ ɔrɔɔt, ma ajinɔ anɔ nɛ, “Ma dim tiŋeere dole nicini abil ku?” Azi nɔkɔ o, eeci aga niigi dɔyizi o Joowo didi aavi ŋaatin. ");
INSERT INTO mur_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iiyak ni Vɔŋizi o Joowo Zakeriya ceen baati Jɔn o, ma adiŋdiŋɛn niini Jook beniinta azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Abon kanaat Manyi ween Jook o Israyil. Iiyak niini ɔl ogin, ma ɔɔga nɔɔgɔ kabaayitɔ yaak. ");
INSERT INTO mur_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Anyaayet niini ageet ruguzoi ci adikir ceen dole ci dɔl o Devid ween gabaren onin. ");
INSERT INTO mur_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Uduwa niini zɔɔz nico baale laadun nyakaŋanete ogin azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ka kiiya korogozet niini ageet modɛni, kibeen dɔyize o ɔl o amarninet ageet dook. ");
INSERT INTO mur_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Zin giye nico eyeliza niini gi o awucnɛkɛ jijitigaac nɔɔnɔ, ma buk aada niini gi baal aterkedek niini nɔɔgɔ e. ");
INSERT INTO mur_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Baale eterkedek niini jijitinai Ibrayim zɔɔz ci ka kɛɛlayet modɛni, ma anyet niini ageet kiliŋliŋtozek nɔɔnɔ kɔkɔm ŋoliin. ");
INSERT INTO mur_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ma buk anyet ageet kobonta ŋume onin ŋinti ŋaan rak karogni noko dook. ");
INSERT INTO mur_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Maje niina Jɔn dole onane awɛ katin izi nyakaŋan ci Jook o anyak diŋdiŋɔn dook. Eeci arayinɛ rak katin niina Manyi ɔɔwa ka dimdimanek nɔɔnɔ gɔl onin ");
INSERT INTO mur_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aduwai tiŋeere niina ɔl ogin zɔɔz o ka korogozi Jooi nɔɔgɔ gole o ka kaarai niini nɔɔgɔ baciinok ugeec. ");
INSERT INTO mur_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Agɔɔn Jooi onai nɔkɔ o, eeci areezet niini ageet, ma iina nɔɔnɔ ziniz. Itoona tiŋeere niini ŋɛɛrin kiiya kuduna kiyo gɔɔn aduŋna ii ririwɔna o ");
INSERT INTO mur_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma anyaak tiŋeere niini vooritin ɔl dook o aavtiz muura daayiza. Ma amadet tiŋeere niini ageet kɔtɔɔz tɔp gole ci ganonto.” ");
INSERT INTO mur_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Maje dole iroktai juruŋ kɔdɔk kak Vɔŋize o Joowo. Mazi akɔ adikir, itiŋa ook balala, ma akɔ abaak ŋinaante zɛɛ been iiten baal aku akanan liŋliŋɔn onin ole o Israyil e. ");
INSERT INTO mur_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma iinyaye niceke itoon alaani o Rom adikir kazi Agostos molok kook ole o loocok ogin dook ka keteyeede ɔl o abaak loocowe o abal niini dook zaara. ");
INSERT INTO mur_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Akanai yeedinɛt ci zaaru noko iinyaye o ɛɛnɛ Kiriniyas alaan o abal looc o kazi Siriya. ");
INSERT INTO mur_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Imiirtozek ni ɔl dook kuturyok ugeec ka gɔɔn ɛɛti kook kɛtɛyɛɛt zaar kuture onin ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Itiŋa ni Josev kuture o kazi Nazarɛt abil looce o kazi Galili, ook kuture o kazi Bɛzilɛm looce o kazi Judiya ŋaabaal aritan alaani o kazi Devid e. Akɔ niini ŋinaante o, eeci een niini borit ci tatok o Devid. ");
INSERT INTO mur_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Orkorit ni niini kibeen Meri o agam ka kiriyi. Maje Meri anyake. Avɔ niigi dook ka kɔɔt keteyeedit zaar ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mazi avɔ arum Bɛzilɛm, amun Meri dole. ");
INSERT INTO mur_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Otowa ni niini logo onin een abuu, ma abuŋ rumanɛn, ma abayek looc luwawa giye ceen taava gɔɔn ɛɛlni artɛ ci maalawu, eeci akɔm ŋinti ka kɔɔt kataŋguzɛ ḏoorya. ");
INSERT INTO mur_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma iitene nice anyak ɔl ci tuwawinto ci gɔɔn abɛk ɛɛza baal looce nice tuuwa. ");
INSERT INTO mur_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma akunak toonnyaiti ci Joowo nɔɔgɔ. Ma ayelzak Jooi nɔɔgɔ diŋdiŋɔn onin ŋaati atarani nɔɔgɔ baal, makacin ɔtɔŋɔltɛ niigi looc ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bar anek toonnyaiti ci Joowo noko nɔɔgɔ nɛ, “Má aŋolinu looc gaga. Eeci kakunakuŋ ka kiiya kuduwayuŋ igeet zɔɔz ci abon ci ka katalɔi ɔl dook ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Itiryai waanico kuture o Devid ruguzoiti cunooŋ. Niini Kiristo ween Manyi onai. ");
INSERT INTO mur_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Gɔl zin ci ka agayi zɔɔz nico een didi nɛɛn ce. Ɔɔtɔ zɛɛ mazi ajowanu dole o abuŋe rumanɛn, ma abawonek taava o, nɔɔnɔ nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Taman nɔkɔ anai toonnyawa ci Joowo meelik boyoŋyoŋ, ma aromonek toonnyai ona oowu e. Ma abene niigi dook anaat Jook azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kanaatit Jook o aavi tammu tadena. Abil ganɔn loota ole o arɛɛz niini.” ");
INSERT INTO mur_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mazi avɔ amiiri toonnyawa avɔ tammu tadena, izitɔ ɔl ci tuwawinto o nɛ, “Kɔɔtɔ di Bɛzilɛma ka kɔɔt kicinit gi ci agooni aduwaket Jooi o.” ");
INSERT INTO mur_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iyiiyit ni niigi ɔɔt Bɛzilɛma, ma avɔ ajowa Meri kibeen Josev. Maje dole abawonek looc taava. ");
INSERT INTO mur_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mazi avɔ acin ɔl ci tuwawinto noko dole, uduktak niigi Meri kibeen Josev zoozok ona aduwak nɔɔgɔ toonnyaiti o Joowo akati dole e dook. ");
INSERT INTO mur_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Maje ɔl dook o azii kaal ci aduwa ɔl ci tuwawinto noko, abiir nɔɔgɔ ooti kaale nicoko ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maje bar Meri abaaban kaal nicoko dook, ma azooni ziniza. ");
INSERT INTO mur_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma amiiri ɔl o tuwawinto ŋaati abɛni beniinok ci anaati Jook kaale o azii kibeen kaale o acin niigi, eeci didi eelit tɔ ebaal aduwaki nɔɔgɔ toonnyaiti e. ");
INSERT INTO mur_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mazi adica dole iinya turge, eteedit ɔl nɔɔnɔ kul keere uneeŋ Juz. Ma akanek nɔɔnɔ zaar ci kazi Yesu ebaal aduwaki toonnyaiti o Joowo nɔɔgɔ iŋaan buk Meri kanyawɔ e. ");
INSERT INTO mur_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Mazi izi iiten o gɔɔn avɔ ataabi ɔl Jook ŋaati aritan dole eo aduwan lotinowa o Mosis, ɔɔt Josev been Meri ceeze o Joowo ka kɔɔt kataabit Jook yɛɛlaye ceen ram karabɔŋ een joroye ceen ram ci yɛɛla o korgu. Ma buk avɔyi niigi dole ka kɔɔt kanycek nɔɔnɔ Jook eo ayeedinɛ lotinowe o Joowo azi nɛ, “Anycek lɔgɔz ween abuunya Jook ka kiziti niigi dɔl cigin aliŋliŋonek nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Maje waanice iinyaye niceke anyak eet ci kazi zaar nɛ Simiyan ci abaak Jerusalɛma. Niini eet ci abon, ma adiŋdiŋan Jook ɔrɔɔt. Ma aavi Vɔŋizi o Joowo ŋaatin, ma anek nɔɔnɔ nɛ, “Alaŋ niina adaai rak iŋaan cin Kiristo ween ruguzoi o ka kitoona Jooi.” Ma giye nico areyi waanice niini ka kicin ruguzoi o ka kiiya korogoz ɔl o Israyil. ");
INSERT INTO mur_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma iitene nice ooyi Vɔŋizi o Joowo nɔɔnɔ ceeze o Joowo. Ma akɔ arumɔ niini ki Josev been Meri avɔyi niigi dole ceeze o Joowo ka kɔɔt kutuguzek nɔɔnɔ kaal o aduwa lotinowa o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ɔdɔŋ ni Simiyan dole azɛɛnɛ, ma anyek Jook zany azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Manyi, Inoko nyan kadaak labak. Katalnɛ ɔrɔɔt, eeci utugu gi baal aterkedekan e. ");
INSERT INTO mur_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kicina naana keberene ogan ɛlɛ ruguzoi o itoona niina ka kiiya korogoz ɔl loota. ");
INSERT INTO mur_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Utugu niina gi nico kicinit modɛna dook. ");
INSERT INTO mur_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ma ruguzoiti nici vooritin ci ka keyelek modɛn o alaŋ een Juz gɔl unun, ma anyaak ɔl o Israyil titinyɔn.” ");
INSERT INTO mur_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma abiir Meri kibeen Josev ooti kaale ci aduwak Simiyan dole noko. ");
INSERT INTO mur_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma amayuk Simiyan nɔɔgɔ, ma anek niini Meri nɛ, “Aŋɛra Jooi dole nico o ka kɔdɔŋ ɔl o agama nɔɔnɔ, ma iinanɛ ɔl o abor nɔɔnɔ ole o Juz. Ayelza tiŋeere niini Jook, ma bar abor nɔɔnɔ ɔl ci meel tiŋeere. ");
INSERT INTO mur_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Zin giye nico abɔryai tiŋeere baabani o gɛrzɛ aroodi zinzeetine ci ɔl ci meel. Maje niina Meri giye nico katin akati culum ɔrɔɔt ɛlɛ kiyo anyei tuben ziniza o.” ");
INSERT INTO mur_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Buk ŋinaante anyak ŋaa ceen matuwoc ceen nyakaŋan ci kazi zaar nɛ Ana. Niini tinati eet ci kazi Vanuwel ceen borit ci ɔl o kazi Acar. Ariyi ɔl nɔɔnɔ, ma anyak kibeen eet irkitok torgɛrɛm nɔkɔ adaak ɛɛti. ");
INSERT INTO mur_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma aavi niini kizi bɔyɛ nɔkɔ irkitok eet wec ki tiin wec (84). Ma ŋaan kotoŋ niini ceez o Joowo been nɛɛn. Adiŋdiŋan gɔɔn niini Jook baalinok ki waazinok ŋaryiinta ŋaati alaŋ adayin. ");
INSERT INTO mur_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma iitene ci baal anyaakɛ Josev ki Meri dole ceez o Joowo neke, iiya buk Ana oromozek nɔɔgɔ ŋinaante, ma anaat niini Jook Ma azɔɔz kaal ci akati dole. Aduwak niini kaal nicoko ɔl dook o arɛ Jook ka korogoz ɔl o Israyil. ");
INSERT INTO mur_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mazi avɔ adica Josev kibeen Meri kaal o aduwa lotinowa o Joowo dook, imiiriye niigi ɔɔt kuture uneeŋ kazi Nazarɛt abil looce o kazi Galili. ");
INSERT INTO mur_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Maje dole iroktai juruŋ kɔdɔk ma agɛny ɔrɔɔt, ma aavi mayuwɛnɛt o Joowo ŋaatin. ");
INSERT INTO mur_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gɔɔn irkitok dook avɔ Josev kibeen Meri Jerusalɛma iitene o gɔɔn alotɛn ɔl o Juz ka kaadai niigi iiten baal avardaŋi toonnyaiti o Joowo ceezi ugeec e. ");
INSERT INTO mur_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Mazi akɔ een Yesu irkitowa amɔtɔ ram, ooti Josev kibeen Meri nɔɔnɔ Jerusalɛma bodo eo gɔɔn avɔyi niigi laadun. ");
INSERT INTO mur_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mazi akɔ adicai iinya ci lotento noko, itiŋgaza niigi abada kɔrɔk. Maje bar tɛ Yesu otoŋozek looc Jerusalɛma calaŋ baatinɛ ki yaatin aga ŋaan aavi niini Jerusalɛma o. ");
INSERT INTO mur_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bar abaaban niigi anɔ nɛ, “Coma aavitɔ ole baal ɔrkɔra ki nɔɔgɔ noko.” Ma adica niigi iiten codoi calaŋ arumɔnɛ ki Yesu nɔkɔ zɛɛ makacin orooŋit niigi nɔɔnɔ ole ugeec een atenok kibeen ole ween laŋotigeec. ");
INSERT INTO mur_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma ŋaan kojokta niigi nɔɔnɔ, ma vurta imiirtozek niigi Jerusalɛm ka kɔɔt korooŋit nɔɔnɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mazi avɔ adica niigi iinya iiyu rooŋinta, ivita ojokta nɔɔnɔ aromɛ kibeen ɔl o gɔɔn ademzek ɔl lotinok ceeze o Joowo. Aziirar niini nɔɔgɔ, ma buk ajin niini nɔɔgɔ zoozok. ");
INSERT INTO mur_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Maje ɔl dook ci azii zoozok ci abarzek niini nɔɔgɔ gɛnyiza noko, abiir ooti ŋaatin ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mazi acin baatinɛ ki yaatin nɔɔnɔ aromɛ kibeen ɔl nicoko nɔkɔ, ibiirit buk nɔɔgɔ ooti ɔrɔɔt. Ma anek yaatinɛ nɔɔnɔ nɛ, “Dole onan, agooneket gi nico naa? Cin di, aneeta kibeen baatun aviryet zinzeeti ŋaatun ɔrɔɔt, ma kagenygenya karooŋnyin.” ");
INSERT INTO mur_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Kodi! Naa tɛ akɔ zɛɛ ma agenygenyu arooŋnyaŋ o? Alaŋ agawu kaavɛ naana ceeze o baaba ŋina o?” ");
INSERT INTO mur_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bar niigi alaŋ aga kɛŋ ci zɔɔz ci aduwa niini noko akati inin. ");
INSERT INTO mur_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Enico uduna Yesu iiya orkorit ki nɔɔgɔ ɔɔt Nazarɛta. Ma azii niini nɔɔgɔ kaale o aduwak niigi nɔɔnɔ kutugu dook. Maje yaatinɛ azooni kaal nicoko dook ziniza. ");
INSERT INTO mur_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma aroktai Yesu juruŋ, ma buk agɛny ɔrɔɔt. Ma atalnɛ Jooi kibeen ɔl buk ŋaatin. ");
INSERT INTO mur_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ma iinyaye niceke anyek Jooi Jɔn ween ŋɛɛrti Zakeriya kook kuduwak ɔl zɔɔz onin balala. Maje waanice irkitowa ci abali alaani o Rom kazi Tibiriyas looc nice dook izi amɔnki tur. Buk enice ɛlɛ Pantas Pailat alaan ci looc o kazi Judiya. Maje Erod alaan ci looc o kazi Galili. Maje gɔtɔnnya o kazi Pilip alaan ci ŋino kazi Itoriya kibeen ŋino kazi Tirakonitis. Maje Lisanas alaan ci abal ŋino kazi Ebilin. Maje Anas kibeen Kayavas niigi alaat ci adikir ceeze o Joowo Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma azɔp Jɔn waanice loocok o ajɔŋzɔ ki liil o kazi Jordan dook. Uuwawek niini ɔl zɔɔz ci azi nɛ, “Otoŋit oŋɛ ugooc. Abadaak gɔl o Joowo. Ivita abadit mony ka otoonycɛ, ka kaara Jooi oŋɛ ugooc.” ");
INSERT INTO mur_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ma uuwayi o Jɔn aku kibil ebaal ayɛɛdi nyakaŋani o kazi Izaya e, azi baale niini nɛ, “Anyak katin eet ci agɛrɛny balala azi nɛ, Idimdimantek Manyi gɔl onin. Amadek nɔɔnɔ golok ogin keelit tɔp. ");
INSERT INTO mur_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Golowa o lukudik dook abon aronek tɔdɔwa kiziti kiltoŋɛ kataadjai. Maje biyɛn dook abon alibe kiziti rabrabɛ. Maje golowa o ŋɔlŋɔlik abon agooni keelit tɔp. Maje golowa ween coorom abon agooni kigirgirit. ");
INSERT INTO mur_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ka zin kicinit tiŋeere ɔl dook rogzɛn o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mazi waanice uuwak Jɔn nɔkɔ, ivitak ɔl ci meel nɔɔnɔ ka kiiya kotoony niini nɔɔgɔ. Ma anek niini nɔɔgɔ nɛ, “Igeet dɔl ci kokonyawu coko! Ŋɛnɛɛn ci ilotuŋ igeet ka odokonyit bornɛt noŋe ci Joowo ka kiiya tiŋeere neke o? ");
INSERT INTO mur_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Abon zin agoonu kaal ci abon ci ayelza gi ci utuŋtu niiga kaal o gɛr didi. Má bar anonu nɛ, Keegina dɔl ci dɔl o Ibrayim. Didilɛ kaduwakuŋ igeet, Jooi anyak dɔyiz ci ookci biyɛn nicoko kiziti dɔl ci Ibrayim labak. ");
INSERT INTO mur_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Eelnu niiga kiyo kɛɛna o. Olla zin inoko mɛlɛyi o payiin o Joowo ɛrɛwɔ ka kɛɛcawuŋ loota kiyo kɛɛca kɛɛt o. Gɔɔn zin laadun kɛɛt calaŋ arek kɛbɛrɛ ci abon, atɛɛdjak looc, ma akanonek goo.” ");
INSERT INTO mur_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mazi azii ɔl zɔɔz nico, ijinit niigi nɔɔnɔ anek nɛ, “Abon zin yo inoko kagoona naa?” ");
INSERT INTO mur_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Ma anyak ɛɛti rumanɛ ram, abon anyek codoi gɔn ci amaat rum. Ma anyak ɛɛti dayiin, abon buk aada gɔnɔgi.” ");
INSERT INTO mur_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma avunak Jɔn ɔl o gɔɔn alot meeri ka kivita kotoonycɛ. Ma ajin niigi nɔɔnɔ anek nɛ, “Alaan o demziinto, duwayet di buk gi ci abon ka kutuguza naaga.” ");
INSERT INTO mur_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Má alotanu ɔla meeri ci appe kujuk o aduwakuŋ alaata o akumawo.” ");
INSERT INTO mur_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma buk ajin takirnya ogɛn nɔɔnɔ anek nɛ, “Mayo buk naaga kutuguza naa? Duwayet di buk gi ci ka kutuguza naaga.” Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Má aamanu ɔl guruc olezɛta. Buk má aŋanyu ɔl oogi gaga nɔkɔ vɔlɔŋa. Anycek zinzeeti kɛlɛɛntɔ ki guruc ci liŋliŋɔn cunooŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mazin giye baal waanice arɛwi ɔl kuni o Kiristo, akɔ mazi uuwak Jɔn kaal nicoko, abaabanit niigi zinzeetinɛ anɔ nɛ, “Bar bɔŋ nici Kiristo o karɛ naaga ɔl o Israyil nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Enek ni Jɔn nɔɔgɔ nɛ, “Inoko kuunyuŋ naana igeet maami doon, bar zin iima ŋaan aku ɛɛti ci adikir ɔrɔɔt kujukan aneet yo nuun een caava ogin zoonu alaŋ kaganona ki aneet ŋaati koborcanɛ. Oony zin tiŋeere niini ɔl oogi ŋaatunooŋ Vɔŋize o Joowo, maje oogi apayek goo. ");
INSERT INTO mur_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kɛɛl naaga ŋaatin kiyo labina o. Anyak zin niini aziita kɛɛt ci uurtanɛ labi, ma arek ŋɔɔt, ma arek labi kɛbɛrɛ piim. Ma avaat tinyonyu gooye calaŋ aditi been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma uuwayek Jɔn ɔl kaviyak o Joowo golowe ci meelik gɛr. ");
INSERT INTO mur_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Ma iinyaye niceke aama alaani o kazi Erod gɔtɔni ŋaa cin kazi Erodiyas. Ma buk waanice agɔɔn niini kaal ci gɛr meel. Ɔbɔrak ni Jɔn Erod kaal o gɛr agɔɔn niini dook kibeen buk gi ci aamanɛ niini gɔtɔni ŋaa o. Enico acabun Erod Jɔn, ma azaac bodo niini gerzitin onin giye ci acabi nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Mazi akɔ oony Jɔn ɔl dook, iiya buk Yesu. Ma buk oony Jɔn nɔɔnɔ. Mazi ŋaan aŋaryɛ nɔkɔ, ɔkɔlɛ tammu taden, ma akunak Vɔŋizi o Joowo nɔɔnɔ kiyo yɛɛlac o. Ma aku tammu tadena mɔlɔyi ci azi nɛ, “Een niina ŋɛɛran onan kareezin nɛɛn. Katalnɛ naana ŋaatun ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mazi akɔ een Yesu irkitowa eetoma kamɔtɔ, akata niini liŋliŋɔn onin. Ma anyek ɔl nɔɔnɔ kizi ŋɛɛrti Josev ween ŋɛɛrti Eli, ");
INSERT INTO mur_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","38","Eli ween ŋɛɛrti Mazat, Mazat ween ŋɛɛrti Livai, Livai ween ŋɛɛrti Mɛlci, Mɛlci ween ŋɛɛrti Janai, Janai ween ŋɛɛrti Josev, Josev ween ŋɛɛrti Mataziyas, Mataziyas ween ŋɛɛrti Amos, Amos ween ŋɛɛrti Nayum, Nayum ween ŋɛɛrti Isili, Isili ween ŋɛɛrti Nagai, Nagai ween ŋɛɛrti Maaz, Maaz ween ŋɛɛrti Mataziyas, Mataziyas ween ŋɛɛrti Simin, Simin ween ŋɛɛrti Josɛc, Josɛc ween ŋɛɛrti Joda, Joda ween ŋɛɛrti Joonana, Joonana ween ŋɛɛrti Rɛsa, Rɛsa ween ŋɛɛrti Zarubabel, Zarubabel ween ŋɛɛrti Sɛlitil, Sɛlitil ween ŋɛɛrti Nɛri, Nɛri ween ŋɛɛrti Mɛlci, Mɛlci ween ŋɛɛrti Adi, Adi ween ŋɛɛrti Kosam, Kosam ween ŋɛɛrti Elmadam, Elmadam ween ŋɛɛrti Eer, Eer ween ŋɛɛrti Jasuwa, Jasuwa ween ŋɛɛrti Eliyesar, Eliyesar ween ŋɛɛrti Jorim, Jorim ween ŋɛɛrti Mazat, Mazat ween ŋɛɛrti Livai, Livai ween ŋɛɛrti Simiyan, Simiyan ween ŋɛɛrti Juda, Juda ween ŋɛɛrti Josev, Josev ween ŋɛɛrti Jonam, Jonam ween ŋɛɛrti Iliyakim, Iliyakim ween ŋɛɛrti Melɛya, Melɛya ween ŋɛɛrti Mena, Mena ween ŋɛɛrti Mataza, Mataza ween ŋɛɛrti Nazan, Nazan ween ŋɛɛrti Devid, Devid ween ŋɛɛrti Jesi, Jesi ween ŋɛɛrti Obɛd, Obɛd ween ŋɛɛrti Bowaz, Bowaz ween ŋɛɛrti Salmon, Salmon ween ŋɛɛrti Nacon, Nacon ween ŋɛɛrti Aminadab, Aminadab ween ŋɛɛrti Adimin, Adimin ween ŋɛɛrti Arini, Arini ween ŋɛɛrti Ezron, Ezron ween ŋɛɛrti Periz, Periz ween ŋɛɛrti Juda, Juda ween ŋɛɛrti Jakob, Jakob ween ŋɛɛrti Aizak, Aizak ween ŋɛɛrti Ibrayim Ibrayim ween ŋɛɛrti Tera, Tera ween ŋɛɛrti Nayor, Nayor ween ŋɛɛrti Seruk, Seruk ween ŋɛɛrti Reyu, Reyu ween ŋɛɛrti Pɛlɛk, Pɛlɛk ween ŋɛɛrti Eber, Eber ween ŋɛɛrti Cela, Cela ween ŋɛɛrti Kenan, Kenan ween ŋɛɛrti Aravazad, Aravazad ween ŋɛɛrti Cɛm, Cɛm ween ŋɛɛrti Nowa, Nowa ween ŋɛɛrti Lamɛk, Lamɛk ween ŋɛɛrti Matasela, Matasela ween ŋɛɛrti Inok, Inok ween ŋɛɛrti Jaret, Jaret ween ŋɛɛrti Maayalil, Maayalil ween ŋɛɛrti Kanan, Kanan ween ŋɛɛrti Inos, Inos ween ŋɛɛrti Sez, Sez ween ŋɛɛrti Adam, Adam ween ŋɛɛrti Joowo. ");
INSERT INTO mur_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ma abada Yesu liile o Jordan ŋaati abizni tɔc ki Vɔŋizi o Joowo, ma akɔyi Vɔŋizi nɔɔnɔ balala. ");
INSERT INTO mur_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma akɔ anyak niini ŋinaante iinya eet ram ci acinan Loryen nɔɔnɔ. Iinyaye niceke dook akɔm niini gi ci adak been nɛɛn. Mazi akɔ adica niini iinya nicoko, adawun magiz. ");
INSERT INTO mur_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Iiyak ni Loryen nɔɔnɔ, ma aku anek nɛ, “Mã di een ŋɛɛrti Joowo didi, towo di bɛ nico kizi ḏokoc.” ");
INSERT INTO mur_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Azi waragɛwi o Joowo nɛ, Alaŋ ɛɛti ci deer arogni ḏokoc doon.” ");
INSERT INTO mur_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bodo akɔyi Loryen nɔɔnɔ bɛ tadena, ma akɔ ayelek nɔɔnɔ lak codoi ṯɔr nɔkɔ looc kibeen modɛn ci loocu noko dook. ");
INSERT INTO mur_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma anek Loryen nɔɔnɔ nɛ, “Cin di. Ŋaan kanyin alaazɛt ci abalɛ modɛn ci loocu nico noko dook, eeci kaala nicigi dook anycozeyan aneet. Olla tɛ mã karooŋ kanyek eet oma, kanyi labak. ");
INSERT INTO mur_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Inoko zin mã adiŋdiŋanan aneet, kanyin koca ineet bal kaal nicoko dook kizi cugun.” ");
INSERT INTO mur_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Azi waragɛwi o Joowo nɛ, Idiŋdiŋanit Manyi ween Jook unooŋ, ma buk abon aliŋliŋoneku nɔɔnɔ doon.” ");
INSERT INTO mur_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Enico ooyi Loryen Yesu Jerusalɛma, ma akɔ atɔɔdi ceez o Joowo, ma akɔyi zɛɛ been ŋinti aṯornɛkɛ e, ma akɔ anek nɛ, “Mã een ŋɛɛrti Joowo didi, kul di ŋina taak tɔdɔ. ");
INSERT INTO mur_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Eeci azi waragɛwi o Joowo nɛ, Ŋaan itoona Jooi toonnyak ogin ka kivita katabuŋtawin niigi ineet calaŋ iinai looc kurukin biyɛn zɔɔ.” ");
INSERT INTO mur_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Azi waragɛwi o Joowo nɛ, Má acina Jook ween Manyi unun.” ");
INSERT INTO mur_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Mazi akɔ odotiz Loryenti cinanowe ci acinan Yesu noko, otoŋek niini nɔɔnɔ looc ɔtɔɔ, ook bodo ɛrɛ gɔl oma ci ka kabadakɛ Yesu. ");
INSERT INTO mur_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Abadaak ni Yesu Galili dɔyize o Vɔŋiz o Joowo. Ma aziiknɛ kaviyawa oginɛ looc nice dook. ");
INSERT INTO mur_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma adɛmɛz niini ɔl ceezine o Juz lotento, ma atitiny ɔl dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zin iiyak Yesu Nazarɛt ŋinbaal aroktan niini. Ma aku akɔ ceeze o lotento iitene o yubzento kazi Sabit eonin gɔɔn akɔyi laadun. Ŋinaante itiŋa jena ka kekeebek ɔl waragɛ o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma anyek ɔl nɔɔnɔ waragɛ o nyakaŋan o kazi Izaya. Mazi akɔl waragɛ, ajowa ŋino ayeedi azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Aavi Vɔŋizi o Joowo ŋaatan, eeci ɛŋɛrawan niini aneet ka kuduwak ɔl o amaat zɔɔz o abon. Itoonanan niini aneet ka kiiya kuduwak ɔl o acabje gɔl o ka kɔɔgjai niigi, ka buk kɔkɔl ɔl o ruben kɛbɛrɛ, ka kiiya koboroc ɔl o agide kɔtɔɔzɔ labak, ka kiiya kuduwak ɔl irkit o ka korogozi Jooi ɔl ogin.” ");
INSERT INTO mur_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Onyook ni Yesu waragɛ, ma anyek eet o aliŋliŋ ceeze o lotento, ma aavi niini loota. Maje ɔl ci aavtiz ceeza o agɛlɛm niigi dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma anek Yesu nɔɔgɔ nɛ, “Eelit didi zoozowa ci aduwa waragɛwi ci Joowo noko waanico tɔ, kiyo aziiŋnu noko.” ");
INSERT INTO mur_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma anaat niigi dook nɔɔnɔ, ma abiir nɔɔgɔ; ooti zoozowe ci amadi aduwa niini noko. Ma ajinɔ niigi maany anɔ nɛ, “Mayo niini alaŋ een ŋɛɛrti Josev gi?” ");
INSERT INTO mur_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma anek Yesu nɔɔgɔ nɛ, “Kaga ŋɛdɛt arooŋnyu uduktayaŋ olit unooŋ gɔɔn aziyu nɛ, Mã een akim, rogoz niina ɛlɛ unun maany. Ma buk arooŋnyu enekteyaŋ nɛ, Tugu buk kaal baal kaziiŋna agoon Kapernama e kuture cina o ŋina. ");
INSERT INTO mur_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Didilɛ kaduwakuŋ igeet, akɔm laadun nyakaŋan ci adiŋdiŋan ɔl kuture onin ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iziiktaŋ di juruŋ! Baale irkite o nyakaŋan o kazi Ilija anyak ŋaai ci bɔi een Israyil meel gɛr. Ma waan o ɛɛnɛ lɔɔci kɔr irkitok iiyu kibeen nyɛlɔwɛ tɔrkɔnɔm e, adak ɔl tarjo ci appe looce nice dook. ");
INSERT INTO mur_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bar Jooi ŋaan kitoon Ilija kook ŋaawe codoi ŋaane nicoko, ma bar itoon niini nɔɔnɔ kook ŋaawe ci bɔi oman ci abaak kuture o kazi Zarɛpaz looce o kazi Sidon. ");
INSERT INTO mur_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Buk baale irkite o nyakaŋan o kazi Ilica, anyak ɔl ci meel gɛr een Israyil amɔɔr dɔbanɛ. Ma ŋaan korogoz Jooi codoi ŋaatineeŋ, ma bar waanice akɔ arogoz niini eet o kazi Naaman baal abaak looce o kazi Siriya e doon.” ");
INSERT INTO mur_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Mazi azii ɔl ci aavtiz ceeze ci lotento noko zoozok nicoko, otoborit nɔŋ. ");
INSERT INTO mur_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Enico itiŋgazɔ niigi jena, ma aduŋnan Yesu ceeza ŋina, ma avɔyi nɔɔnɔ zɛɛ been kutur uneeŋ abil bɛ tadena ka kɔɔt kujuktek nɔɔnɔ ŋolol ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bar Yesu aara ɛlɛ nɔɔgɔ kɔrgɛna nɔkɔ, ɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ook ni Yesu kuture o aavi Galiliya kazi Kapernam, ma akɔ adɛmɛz ɔl ceeze o lotento ŋinaante iitene o yubzento kazi Sabit. ");
INSERT INTO mur_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma abiir ɔl ooti demziinte cin o, eeci demziin cinɛ o anyak dɔyiz. ");
INSERT INTO mur_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Maje ceeze ci lotento noko anyak eet ci anyak miniŋit ci Loryento. Ma agɛrɛny miniŋit nici eete nico azi nɛ, “Yesu o Nazarɛt, arooŋ ŋaatinaaŋ naa? Akun ka ija uulalet? Kagayin naana ineet nɔkɔ akun Joowa.” ");
INSERT INTO mur_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ma agernyek Yesu miniŋit ci Loryento noko anek nɛ, “Jawɔ tiv! Duna bitaala eete nico!” Uruyi ni miniŋit nici eet nico looc ɔl kɔrgɛna ŋina, ma aduŋnak bitaalin kɔkɔm gi ci gɛr agoonek eet nico. ");
INSERT INTO mur_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mazi akɔ acin ɔl gi nico, ibiirit nɔɔgɔ ooti ɔrɔɔt ɛlɛ, ma anɔ nɛ, “Mayo dim zɔɔz taz nici ci azɔɔzɛkɛ niini miniŋ ci Loryento dɔyiza, ma aduŋnan o?” ");
INSERT INTO mur_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma aziiknɛ kaviyawa o akati Yesu looc nice dook. ");
INSERT INTO mur_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Enice udun Yesu ceeze o lotento ook ole o Saiman. Maje inyik o Saiman anyak ɛlɛ baritɔn ɔrɔɔt. Uduktak ni ɔl Yesu mɔɔriz ci inyigo noko. ");
INSERT INTO mur_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ŋinaanto ook Yesu, ma abil kuwen ci ɔɔŋɛ ŋaa noko libira, ma azoozek mɔɔriz nico kudunak bitaalin. Enico ɛlɛ uduna didi mɔɔrizi nici bitaala, ma iŋaaz inyik ci Saiman noko jena, ma aliŋliŋek nɔɔgɔ dayiin. ");
INSERT INTO mur_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma yomana mazi akɔ ii loota, anyaaktak ɔl Yesu ɔl dook o amɔɔr moorizok keŋti dook. Ma aku ataadek niini azɛɛn nɔɔgɔ dook, ma arogi niigi dook moorizowe ugeec pocok. ");
INSERT INTO mur_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma buk aara niini miniŋ ci Loryento ole ci meel, ma agɛrɛny miniŋa azi nɛ, “Een niina ŋɛɛrti Joowo didi.” Maje Yesu agernyek nɔɔgɔ kajaktɔ, ma didi ajaki niigi, eeci aga niigi nɔɔnɔ een Kiristo o arɛ ɔl o Juz nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ma ŋeere ririwɔna itiŋa Yesu ook tuuwa niini doon. Ma arɔɔŋ ɔl nɔɔnɔ zɛɛ mazi avɔ ajowa nɔkɔ, orooŋit kalamit nɔɔnɔ kaavu calaŋ awɔ ŋaatineeŋ o. ");
INSERT INTO mur_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bar anek Yesu nɔɔgɔ nɛ, “Abon kakɔ kuuwai kaviyak o abon akati baliin o Joowo kuturyowe ogɛn buk, eeci nici gi baal laadun itoonakan Jooi aneet e nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ook ni uuwak niini ceezine o lotento looce o kazi Judiya dook. ");
INSERT INTO mur_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ma iitene oman abil Yesu liil o kazi Genezaret otoga. Ma avunak nɔɔnɔ ɔl ci meel zɛɛ ma ajukɔ, eeci arɔɔŋ niigi kiziiyit zɔɔz o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma acin Yesu kavoolɛt ceen ram ɛɛl dɔwɔna. Maje ɔl ci detiinto o udunta ɔɔt otoonyit cabayɛt. ");
INSERT INTO mur_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma akɔ Yesu atɔɔt kavoolete nicoko o Saiman. Ma anek Yesu nɔɔnɔ nɛ, “Toyooteyan di liil kɛdɛyai dɔwɔna kidicilim.” Aavu ni niini kavoola ŋinaante, ma adɛmɛz ɔl. ");
INSERT INTO mur_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Mazi akɔ adotiz niini demziinta, enek Saiman nɛ, “Tɔyɔɔt kavool kook boloca ka ɔɔt ujuktek cabayɛt cugooc o liil ŋinaante ka agamit kuluk.” ");
INSERT INTO mur_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma abɛdɛkɛ Saiman nɔɔnɔ anek nɛ, “Manyi, ŋaan ona kadetina baalin dook e, akɔm gi ci kagamana kina. Bar zin giye o aduwaket niina, ŋaan kacinana bodo.” ");
INSERT INTO mur_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mazi avɔ ajuk niigi cabayɛt didi, agamit kuluk ci meel ɔrɔɔt kook zɛɛ ma arɔɔŋ atɛɛt cabayɛt. ");
INSERT INTO mur_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Makacin alakada niigi gɔnɔgi o aavtiz kavoole o abil dɔwɔna e ka kivita kitiritit nɔɔgɔ. Ma avu abitiz niigi kavoolɛt dook ramantiya tɔc ci arɔɔŋ adodɛ. ");
INSERT INTO mur_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Mazi acin Saiman gi nico, iiya akati kozoŋti looc Yesu ŋuma, ma anek nɔɔnɔ nɛ, “Manyi, dɛyai ŋaatan, eeci keen naana eet ci gɛr oŋenu.” ");
INSERT INTO mur_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ma abiir Saiman kibeen gɔnɔgi ci ɔrkɔr ki nɔɔnɔ o ooti tɛt kuluge ci meelik agama niigi noko. ");
INSERT INTO mur_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Buk Jemis kibeen Jɔn ween lɔgɔz o Zebedi o gɔɔn adete kibeen Saiman abiir ooti giye nico. Ma anek Yesu Saiman nɛ, “Má anyei ŋoliin. Inoko alaŋaan bodo adeti niina kuluk, bar akatai waanico ka detek ɔl Jook.” ");
INSERT INTO mur_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Utugurtak ni niigi kavoolɛt dɔwɔn, ma ŋinaante otoŋtek kaal ugeec dook looc, oneec Yesu. ");
INSERT INTO mur_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mazi akunak Yesu kutur oma, iiya ɛɛti ci amɔɔr mɔɔriz o gidaŋ ɔrɔɔt. Mazi acin niini Yesu, aavu loota kɔpɔkpɔk, ma ilalek nɔɔnɔ anek nɛ, “Manyi, Mã arooŋ rogozan kizi maya, rogozan.” ");
INSERT INTO mur_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ma adɔŋa Yesu aziit, ma uum nɔɔnɔ, ma anek nɛ, “Karooŋnyin rok. Inoko zin rogɔ.” Enico ɛlɛ urugun didi niini mɔɔrize onin. ");
INSERT INTO mur_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Iricanek ni Yesu nɔɔnɔ enek nɛ, “Má akɔ aduwai eet oma gi nico, bar iyiik kataman bitɔ yelek ɛlɛ alaan o gɔɔn anyek Jook kaal o ataabi ɔl ka kagawin niini ineet obona. Biti zin buk taabinɛt o gɔɔn orogi ɛɛti mɔɔriza kiyo aduwa lotinowa o Mosis o, ka kagayin ɔl urugu didi.” ");
INSERT INTO mur_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bar enico adala kaviyawa o Yesu ŋinite dook ɔrɔɔt, ma avunak ɔl ci meel nɔɔnɔ ka kivita kiziiyit zoozok ogin, ka buk korogoztɛ niigi moorizowe ugeec. ");
INSERT INTO mur_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Maje Yesu akɔ gɔɔn balala lak ci meelik gɛr, ka kook kaŋarowɔ ŋinaante niini doon. ");
INSERT INTO mur_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma iitene oman adɛmɛz Yesu ɔl. Maje ɔl o kazi Parici kibeen ɔl o gɔɔn ademzek ɔl lotinok aavtiz buk niigi tɔ ŋinaante. Avu niigi kuturyowe o Galili dook ki kuturyowe o Judiya dook been Jerusalɛma. Maje Yesu arogoz ɔl o amɔɔr dɔyize o Vɔŋiz o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ivitak ni nɔɔnɔ ɔl ci adɔŋa eet ci ŋanyŋany kuwena. Arɔɔŋ niigi kooti nɔɔnɔ ŋaati Yesu ceeza eecitɔ, maje ɔl ceeza eecitɔ mɛɛlɛ gɛr. ");
INSERT INTO mur_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mazi acin niigi gɔl kaŋkaŋ nɔkɔ giye o meelini ɔl ceeza, otoodi eet ci amɔɔr noko ceez taden, ma avɔ abɔr ceez kuwet, ma abɔranɛ nɔɔnɔ ceez tadena kolocak looc ɔl kɔrgɛna ŋaati ona aavɛ Yesu o. ");
INSERT INTO mur_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mazi acin Yesu tuwɛn cineeŋ o, enek niini eet ci ŋanyŋany noko nɛ, “Laŋo, aaryai baciinowa ugune.” ");
INSERT INTO mur_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Mazi azii ɔl o Parici e kibeen ɔl o demziinto zɔɔz nico, abaabanit niigi izitɔ nɛ, “Ma dim niini ŋɛnɛɛn ci aduwa zɔɔz ci ayayizi Jook noko? Ŋɛnɛɛn ci anim kaara baciinok? Aara ri baciinok Jooi doon. Amomoz ri ɛɛti nici Jook.” ");
INSERT INTO mur_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Maje Yesu aga baabani cineeŋ o nɔkɔ, ma anek nɔɔgɔ nɛ, “Akɔ ma abaabanu kaal nicoko nɔkɔ o naa? ");
INSERT INTO mur_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mayo aboke jaŋ kenek nɛ, Aaryai baciinok ugune, yo da kenek nɛ, Tiŋa jena, tɔ? ");
INSERT INTO mur_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Inoko zin abon kayelekuŋ naana Ŋɛɛrti Eeto kanyei dɔyiz ci kaaranɛ baciinok loota ŋina.” Enek ni niini eet ci ŋanyŋany noko nɛ, “Kanekin nɛ, Tiŋa jena. Doma kuwen cun o. Bitɔ ɔlɔ.” ");
INSERT INTO mur_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Enico ɛlɛ itiŋa ɛɛti o ŋanyŋany e jena nɔɔgɔ kɛbɛrɛn ŋina. Odoma kuwen onin ona ɔɔŋɛ e, ɔtɔɔ ŋaati anaati Jook, ook ɔlɔ. ");
INSERT INTO mur_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mazi acin niigi gi nico, ibiirit nɔɔgɔ dook ooti. Ma anaat Jook ŋoliinta, ma anɔ nɛ, “Kicinit zin kaal ci ateedet biye waanico.” ");
INSERT INTO mur_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma vurta udun Yesu ceeza ook bitaala. Ma acin eet ci kazi Livai ci gɔɔn alot meeri aavi ŋaa onin gɔɔn aliŋliŋi. Ma anek Yesu nɔɔnɔ nɛ, “Nowawan.” ");
INSERT INTO mur_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ma iŋaaz Livai kodotek kaal ogin dook ki liŋliŋɔn onin buk looc, ma ano Yesu. ");
INSERT INTO mur_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ma akɔ agoonek Livai Yesu dayiin ci meelik ole onin, ma awa buk niini gɔnɔgi oogi ci meelik ole o meeryo been buk ɔl oogi. Ma avɔ azɔlɔ niigi dook ki Yesu. ");
INSERT INTO mur_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Maje bar ɔl ogɛnɛ ole o Parici kibeen gɔnɔgi o gɔɔn ademzek ɔl lotinok o Mosis anyori giye nico, ma ajin niigi nuyak o Yesu anek nɛ, “Ma dim niiga azolonu ki ɔl ci alot meeri o been ɔl ci oŋenu o naa?” ");
INSERT INTO mur_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mazi azii Yesu gi nico, ɛbɛdɛkɛ niini nɔɔgɔ enek nɛ, “Gɔɔn ɔl ci akɔm mɔɔriz ŋaatineeŋ alaŋ arɔɔŋ akim. Bar zin gɔɔn arɔɔŋ akim ɔl o amɔɔr doon. ");
INSERT INTO mur_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Alaŋ zin naana kakun o ka kiiya kotowa ɔl ci abon, bar kakunai ɔl o anyak baciinok ka keteedɔi niigi baciinok ugeec.” ");
INSERT INTO mur_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ma anek ɔl ogɛn Yesu nɛ, “Gɔɔn nuyawa o Jɔn ooŋ dayiin, ma aŋaryɛ ka kidiŋdiŋanit Jook. Buk nuyawa o Parici agɔɔn nɔkɔ. Maje bar nuyawa cugune o alaŋ agɔɔn nɔkɔ. Adake gɔɔn niigi, ma awodɛ iinya dook labak o naa?” ");
INSERT INTO mur_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Mã ŋaan ɛɛti o rociinto aavitɔ o, alaŋ rak bacowa ooŋ dayiin. ");
INSERT INTO mur_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bar zin tiŋeere ma iiya iiteni o aaryanɛ niini ŋaatineeŋ, enice ŋaan ooŋ niigi dayiin kibeen wodɛn.” ");
INSERT INTO mur_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ma aduwak Yesu nɔɔgɔ yabziin oma anek nɛ, “Akɔm laadun eet ci arɛɛc rum ci colai ka kubutani gɔn ci rɛɛn. Mã agɔɔn niini nɔkɔ, uulali koca niini rum ci colai o gaga nɔkɔ, eeci rum ci colai o kibeen gɔn ci rɛɛn o alaŋ aganɔ. ");
INSERT INTO mur_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Akɔm buk eet ci arek iira buru ci rɛɛn. Mã agɔɔn niini nɔkɔ, adɛ koca iirana, ma alip buru kuḏuute iirana, ma akoloz niini iira kibeen buru buk. ");
INSERT INTO mur_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Abon zin aronek iirana buru ci colai. ");
INSERT INTO mur_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Inoko zin bar ɔl ogɛn arɛɛz demziin uneeŋ rɛɛn doon, ma alaŋ arɔɔŋ niigi demziin ci colai o. Anɔ niigi nɛ, Abon demziin onaaŋ rɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ma iitene o yubzento kazi Sabit ɔtɔɔ Yesu, ma akɔ abatak manɛɛn ci labinu. Ma aduula nuyawa oginɛ labi, ma aŋinya azɛɛnɛn, ma adak. ");
INSERT INTO mur_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mazi acin ɔl o Parici nɔɔgɔ agɔɔn nɔkɔ, ijinit enektek nɛ, “Agoonu gi calaŋ aziikneket lotinowa kutuguz iitene nico o naa?” ");
INSERT INTO mur_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋaan da niiga ekeebit waragewe o Joowo zɔɔz baal agɔɔn alaani o kazi Devid kibeen ɔl ogin ɔrkɔr waanbaal adayi nɔɔgɔ magiz e? ");
INSERT INTO mur_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Iitene nice akɔ niini ceeze o Joowo, ma akɔ adoma ḏɔkɛn o gɔɔn ataabi ɔl Jook, ma adak, ma anyek buk oogi ɔl ogin ɔrkɔr. Agayu niiga waanice ḏɔkɛn niceke alaŋ ɛɛti ci gaga adak, bar adak alaata o agam ceez nice doon. ");
INSERT INTO mur_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mazin naana Ŋɛɛrti Eeto keen Manyi ci iiten o yubzento nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Bodo iitene ceen Sabit oman ook Yesu ceeze ci lotento, ma akɔ adɛmɛz ɔl ŋinaante. Maje ɛɛti ci dɔkɔm aziiti ci azo o aavi buk ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma adɛt ɔl o Parici kibeen alaat o gɔɔn ademzek ɔl lotinok o Mosis Yesu ka kicinit karabɔŋ arogoz niini ɔl iitene ceen Sabit o, eeci arɔɔŋ niigi gɔl ci ka kagamti nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Maje Yesu aga baabanok cigeecik o nɔkɔ, ma anek niini eet ci dɔkɔm aziiti noko nɛ, “Tiŋa jena. Ija. Bil ɔl kɔrgɛna ŋaato.” Itiŋawa ni ɛɛti, ma aku abil ɔl kɔrgɛna. ");
INSERT INTO mur_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Enek ni Yesu nɔɔgɔ nɛ, “Kajinuŋ di igeet. Ma lotinowa ogaac aziikneket kutuguz naa iitene ceen Sabit o? Kutuguz kaal ci abon, yo da kutuguz kaal ci gɛr? Korogozit eet, yo kuruyit da kadaak?” ");
INSERT INTO mur_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ma agɛlɛm niini nɔɔgɔ dook. Ma anek eet ci dɔkɔm aziiti o nɛ, “Zɔlan aziit cun o.” Mazi azɔlan niini aziit, obona aziiti oninɛ labak. ");
INSERT INTO mur_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bar enico otoborit niigi nɔŋ ɔrɔɔt, ma abaaban niigi dook gi ci ka kutuguzek Yesu. ");
INSERT INTO mur_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ma iitene oman ook Yesu bɛ tadena ka kook kaŋarowɔ. Ma akɔ adica baalin dook ŋaryiinta ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Mazi akɔ aaliz tammu, otowa niini nuyak ogin, ma aŋɛra ŋaatineeŋ ɔl ceen amɔtɔ ram, ma akanek nɔɔgɔ zaar ci kazi toonnyak. ");
INSERT INTO mur_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Ma zin ɔl ci baal aŋɛra niini noko Saiman o akanek niini zaar o kazi Pitɔr, ki gɔtɔni Saiman Pitɔr o kazi Andoru, ki Jemis, ki Jɔn ween gɔtɔni Jemis, ki Pilip, ki Bartalamu, ki Matiyu, ki Tomaz, ki Jemis ween ŋɛɛrti Alvayoz, ki Saiman baal gɔɔn oorinɛ looc onin akumawe o Rom e, ki Judaz ween ŋɛɛrti Jemis, ki Judaz Iskariat baal ka kiiya kataalɔi Yesu e. ");
INSERT INTO mur_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mazi abada Yesu kibeen nuyak ogin bɛ tadena, iiya ibil niini ŋaaten raco. Ma avunak nɔɔnɔ nuyawa ci meel nuyawe ogin. Maje buk ŋinaante anyak ɔl ci meel avunak nɔɔnɔ looce o kazi Judiya, kibeen Jerusalɛma, kibeen kuture o kazi Tayor been Sidon o abil liiltoga. ");
INSERT INTO mur_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Avunak niigi Yesu ka kiiya kiziiyit zɔɔz onin. Ma buk arɔɔŋ ka korogoztɛ niigi moorizowe ugeec. Buk ɔl o agit voŋizowa o Loryento avunak nɔɔnɔ, ma arogoz niini nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ma arawɔnɛ ɔl dook nɔɔnɔ ŋaati uumi, eeci anyak dɔyiz ci aduŋna alye cin o ci arogni ɔl dook. ");
INSERT INTO mur_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ma agɛlɛm Yesu nuyak ogin, ma anek nɛ, “Amayuktewu niiga o amaanu, eeci baliin o Joowo izi cunooŋ. ");
INSERT INTO mur_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amayuktewu niiga o adakuŋ magizeeti inoko, eeci katin anyernu. Amayuktewu niiga o aluyu inoko, eeci katin ararnu. ");
INSERT INTO mur_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Amayuktewu niiga ŋaati amarninuŋ ɔl igeet, ma atookuŋ, ma adomnyuŋ, ma anekuŋ nɛ, Eeginu gɛrzɛtɛ giye o atuyaŋ niiga aneet Ŋɛɛrti Eeto. ");
INSERT INTO mur_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ataltɔ zin ma avunakuŋ kaal ci ɛɛl nɔkɔ. Iitene nice orogomit talniinta, eeci itaŋonekuŋ igeet vɔyita ci appe ɔrɔɔt tamma. Eeci buk baale jijitigeec agoonek nyakaŋanɛt kaal nicoko. ");
INSERT INTO mur_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bar zin izi nɔŋa wole ŋaatunooŋ igeet ɔl o eeginu botoro inoko, eeci uulawu niiga arɔkzɛt unooŋ loota ŋina. ");
INSERT INTO mur_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Izi nɔŋa wole ŋaatunooŋ igeet o anyernu inoko, eeci katin adakuŋ magizeeti. Izi nɔŋa wole ŋaatunooŋ igeet o ararnu inoko, eeci katin aluyu tildik tildik. ");
INSERT INTO mur_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Izi nɔŋa wole ŋaatunooŋ igeeta o gɔɔn adiŋdiŋanuŋ ɔl dook inoko, eeci baale buk jijitigeec adiŋdiŋan nyakaŋanɛt o voloŋo nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ma anek Yesu nɔɔgɔ nɛ, “Inoko zin kanekuŋ nɛ, Ereezit ɔl o amarninuŋ igeet. Utuguzek niiga nɔɔgɔ kaal ci abon. ");
INSERT INTO mur_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Abaricek niiga ɔl o gɔɔn atoryuŋ utugeti ci amadi. Buk ijintek Jook ɔl o gɔɔn agoonekuŋ kaal ci gɛr. ");
INSERT INTO mur_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mã arukin ɛɛti voret co, towek bodo voret co. Mã akɔyi ɛɛti rum cun malkinto, má abornei nɔŋ, bar anyek bodo rum oma labak. ");
INSERT INTO mur_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anyek ɔl dook kaal ci olla ala niigi ŋaatun. Mã akɔyi ɛɛti gi cun, má bodo ajin ka kabadakin. ");
INSERT INTO mur_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Utuguz ɔl juruŋ kiyo buk arooŋnyu niiga nɔɔgɔ kutuguzuŋ igeet juruŋ o. ");
INSERT INTO mur_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mã areezu niiga ɔl o gɔɔn areezuŋ igeet doon, utuguzu koca niiga gitaz ci abon o? Akɔm kina! Eeci ɔl o oŋenu arɛɛz buk niigi ɔl o gɔɔn arɛɛz nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mã agooneku kaal ci abon ɔl o gɔɔn agoonekuŋ igeet kaal ci abon doon, utuguzu niiga gitaz ci abon o? Akɔm kina! Eeci ɔl o baciinowu agɔɔn gɔɔn buk niigi nɔkɔ. Alaŋ zin niiga ka waan eelit kiyo niigi o. ");
INSERT INTO mur_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mã anyeku ŋabolo ɔl o ka tiŋeere bodo kabadakuŋ igeet kaal nicoko doon, utuguzu koca niiga gitaz ci abon o? Akɔm kina! Eeci ɔl o oŋenu anyek buk niigi gɔnɔgi o oŋenu ŋabolɛt ka bodo tiŋeere kabadakɛ nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bar zin naana karooŋnyuŋ igeet ereezit ɔl o amarninuŋ. Utuguzek nɔɔgɔ kaal ci abon. Anycek ɔl ŋabolɛt labak. Má zin bar bodo areyu nɔɔgɔ ka kabadakuŋ, eeci ŋaan tiŋeere aruwonekuŋ igeet vɔyita ci appe, ka buk iziti niiga dɔl ci Jook o tammo. Arɛɛz niini ɔl o alaŋ anyek nɔɔnɔ zany kibeen buk ɔl o agɔɔn kaal o gɛr. ");
INSERT INTO mur_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Abon awucnekuŋ ɔl igeet kiyo buk awucneku niiga Jook ween baatunooŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma amɛna Yesu demziinte onin azi nɛ, “Má apayeku ɔl gerzitin karabɔŋ akanu ɔl oogi zɔɔza, ka buk calaŋ apayekuŋ Jooi igeet gerzitin. Otoŋit ɔl o gɔɔn agoonekuŋ igeet kaal ci gɛr, ka buk kotoŋeyuŋ Jooi igeet kaal o gɛr agoonu. ");
INSERT INTO mur_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Anycek ɔl kaal labak, ka buk kanyuŋ Jooi igeet kaal o arooŋnyu. Ma kaala ci anyuŋ Jooi igeet o mɛɛlɛ ɔrɔɔt kujuk kaal o anyeku niiga ɔl oogi. Mã ayabzaku eet kaal kizi kidicɛ, ayabzakuŋ buk Jooi igeet kaal kizi kidicɛ. Mazi ayabzaku eet kaal kizi mɛɛlɛ, ayabzakuŋ buk Jooi igeet kaal kizi mɛɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ma aduwak Yesu nɔɔgɔ zɔɔz ci anek nɛ, “Akɔm laadun eet ci ruben buk ci ayit gɔɔn ci ruben kiyo niini o. Mã agɔɔn niini nɔkɔ, iinak koca niigi dook look. ");
INSERT INTO mur_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Akɔm gɔɔn laadun eet ci ŋaan adɛmzɛ ci adikir kujuk alaan o adɛmɛz nɔɔnɔ. Bar zin ma idica niini demziin onin, ŋaan aku atobɔ niini buk kibeen alaan o adɛmɛz nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Naa zin rican gi ci abil keberece ci gotonon o, ma bar alaŋ abaaban rak gi ci appe abil keberece cun o? ");
INSERT INTO mur_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ku anei gon oma nɛ, Jai kaarawin gi ci anyei kebereca o, ma gi ci appe abil keberece cun o alaŋ rak aara naa? Zin niina ci adiŋdiŋan ɛlɛ vɔlɔŋa o aara rak gi ci appe abil keberece cun o ɔɔwa, zɛɛ mazi icinɔ juruŋ, bitɔ zin aara gi ci abil keberece ci gotonon e.” ");
INSERT INTO mur_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ma azi bodo Yesu nɛ, “Akɔm gɔɔn laadun kɛɛt ci abon ci abiirna kɛbɛrɛ ci gɛr. Alaŋ buk kɛɛt ci gɛrzɛ abiirna kɛbɛrɛ ci abon. ");
INSERT INTO mur_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gɔɔn laadun kaga naaga kɛɛt keberene ogin abiirna. Alaŋ ɛɛti adoca keberec ci moneeco keete ceen karadac, ma alaŋ buk adoca ɛɛti gɛmɛnyɔ keene ceen bila. ");
INSERT INTO mur_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma ɛɛti ci abon aduwa kaal ci abon kaale o anyak niini zinize onin abon. Maje ɛɛti ci gɛrzɛ aduwa kaal ci gɛr kaale o anyak niini zinize onin gɛr. Eeci ɔtɔgi aduwa kaal o anyak ziniz eecitɔ.” ");
INSERT INTO mur_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma azi bodo Yesu nɛ, “Ma dim gɔɔn niiga awuyaŋ aneet aziyu nɛ, Manyi, Manyi, maje ŋaato alaŋ arooŋnyu utuguz kaal o kaduwakuŋ o naa? ");
INSERT INTO mur_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ma zin ɛɛti ci iiyayan aneet, ma iziik zɔɔz onan, ma ozooti, atobɔ niini kibeen eet ci ɛɛnyɛt ceez kutur ɔɔwa. Ada niini looknya kizi wuntɛ kal, ma aruwek zɔɔrɛn looc kodoyit kak, ma iitir ceez kitiirwani kɔdɔk. Mayo nuun aku tawani ci appe, alaŋ ceez cinɛ noko aruk looc, eeci ɛɛnyci niini kɔdɔk kak ŋaati kutul. ");
INSERT INTO mur_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Maje ɛɛti ci azii zɔɔz onan, ma alaŋ azooni, atobɔ niini kibeen eet ci ɛɛnyɛt ceez cin kɔkɔm zɔɔrɛn, ma alaŋ aruwek azanɛ looc kodoyit, ma alaŋ buk iitir ceez kitiirwani ka kɔdɔk. Mazi aku tawani, aruyi ceez nico looc enico ɛlɛ, ma oyoki kuulalɛ ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Mazi akɔ adotiz Yesu zoozowe nicoko, ɔtɔɔ ook kuture o kazi Kapernam. ");
INSERT INTO mur_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Maje ŋinaante anyak alaan ci takirnya o Rom. Alaani nici anyak gabaren cin arɛɛz ɔrɔɔt. Maje gabarɛnti nici amɔɔr ɔrɔɔt ɛlɛ kizi daayizoi. ");
INSERT INTO mur_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Mazi azii alaani nici kaal o agɔɔn Yesu, itoonun niini ɔl oogi ole o Juz mayan kɔɔt kutuya Yesu ka kiiya korogoz gabaren cin o. ");
INSERT INTO mur_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ivitak ni niigi Yesu, ma avu ilalek nɔɔnɔ ɔrɔɔt ka kitirit eet nico. Anek niigi nɔɔnɔ nɛ, “Ɛɛti nici eet ci abon ɔrɔɔt. Aganɔ ŋaati atirtɛ niina nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eeci areezet niini ageet Juz ɔrɔɔt ɛlɛ. Nɔɔnɔ nɛɛn o ɛɛnycaket ageeta ceez onaaŋ gɔɔn lotento ŋina o.” ");
INSERT INTO mur_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Itiŋa ni Yesu orkorit kibeen nɔɔgɔ. Mazi avɔ ajɔŋɔz kɔrɔk, itoona bodo alaani laŋotigin oogi kiiya kenektek Yesu nɛ, “Manyi, má bai amila ɛlɛ gaga, eeci alaŋ aganonu ŋaati akunakɛ kɔrɔk can o. ");
INSERT INTO mur_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma buk alaŋ naana alya kaganona ŋaati kakunakin ineet. Olla zin duwa zɔɔz ci aduwa ka korok gabarɛnti cane o. ");
INSERT INTO mur_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Buk ŋaatan ɛlɛ anyak alaat oogi ci adikir ŋaatan. Ma buk bodo naana kadikir takirnyaye ogan. Mã kanei co nɛ, Bitɔ kete, akɔ. Mã kawa oma kanei nɛ, Ija ŋaato, aku. Mã buk kaduwai gabaren gi ci kanei nɛ, Tugu gi nico, agɔɔn.” ");
INSERT INTO mur_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Mazi azii Yesu zɔɔz nico, ibiir nɔɔnɔ ɔɔ ɔrɔɔt. Ma abuut ɔl ona anowa nɔɔnɔ e, ma anek nɛ, “Didilɛ kaduwakuŋ igeet, ŋaan gɔɔn laadun kojowa eet ci anyak tuwɛn nɔkɔ. Yo nuun een ole o Israyil ɛlɛ ŋaan kojowa eet ci abil nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mazi amiiri ɔl ona itoona alaani e ɔlɔ, amada gabaren o amɔɔr e oroga. ");
INSERT INTO mur_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Taman nɔkɔ itiŋa Yesu ook kuture o kazi Nayin. Maje buk nuyawa oginɛ kibeen ɔl ci meel ano nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mazi awowonek niini kutur, urumtɔ ki ɔl ci atik eet ci adaai avɔyi dawiin. Maje logoti ci adaai noko adoye ŋaati yaatin ṯɔr nɔkɔ. Bodo buk yaatinɛ alya ŋaa ci bɔi. Ivitak ni ɔl ci meel ole o kuturo ŋaa nico ka kivita kozooztek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mazi acin Manyi Yesu ŋaa nico, uwucek niini nɔɔnɔ, ma anek nɛ, “Má alu gaga.” ");
INSERT INTO mur_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ook ni niini, ma akɔ uum kuwen ci ona atiki ɔl logo ci adaai noko, ma ɛɛl ɔl ci ona atik nɔɔnɔ o. Ma azi Yesu nɛ, “Logoz, kanekin nɛ, Tiŋa je.” ");
INSERT INTO mur_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Enico ɛlɛ, itiŋa logoti ona adaai e, ma azɔɔz. Anyek ni Yesu nɔɔnɔ yaatin. ");
INSERT INTO mur_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma akunak ɔl dook ŋoliin ɔrɔɔt. Ma anaat niigi dook Jook anɔ nɛ, “Eyelizyayet nyakaŋani ci anyak dɔyiz ci appe.” Maje bodo ɔl ogɛn anɔ nɛ, “Iiya Jooi ka kiiya korogoz ɔl ogin.” ");
INSERT INTO mur_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma adala zɔɔz nica looc o Judiya dook kibeen buk kuturyok o ajɔŋzɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ivita ni uduktak Jɔn nuyawa oginɛ kaal o agɔɔn Yesu dook, ma awa niini ɔl ram ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ma itoon nɔɔgɔ kɔɔt kijinit Yesu kenektek nɛ, “Ma dim een eet baal ka kitoonayet Jooi e nɛɛn, yo kereya da eet oma ci ŋaan aku?” ");
INSERT INTO mur_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ivitak ni nuyawa nicigi Yesu, ma avu anek nɛ, “Itoonanet Jɔn o oonyi ka kivita kijintin ineet kenekteyin nɛ, Ma dim een eet baal ka kitoonayet Jooi e nɛɛn, yo kereya da eet oma ci ŋaan aku?” ");
INSERT INTO mur_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Maje ŋaati ona azɔɔzɔnɛ niigi ki Yesu noko, arogoz Yesu ɔl ci meel amɔɔr moorizok keŋti dook, kibeen ɔl ci anyak miniŋ o Loryento, ma akɔl ɔl ci ruben meelik kɛbɛrɛ kicintɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɛbɛdɛkɛ ni Yesu nuyak ci Jɔn een ram noko enek nɛ, “Imiirtozek Jɔn. Ɔɔtɔ uduktak kaal ci ona acinu, ma aziiŋnu noko. Ɔl o ruben icintɔ. Ɔl o ŋɔɔlik ɔtɔɔzɔ tɔp labak. Ɔl o amɔɔr mɔɔriz o gidaŋ orogita. Ɔl o adiiti iina iziiktɔ. Ɔl o adaai itiŋgazɔ daayiza korogit bodo. Maje kaviyawa o abon uuwawonek ɔl o amaat. ");
INSERT INTO mur_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Amayuk zin Jooi eet ci atuyan aneet kaale o kagoon dook.” ");
INSERT INTO mur_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mazi amiiri toonnyawa ci Jɔn noko, ijin Yesu ɔl o aromɛ ki nɔɔnɔ zɔɔz ci akati Jɔn anek nɛ, “Baale avoyu ŋaati Jɔn balala e, arooŋnyu da ɔɔt icinit naa? ");
INSERT INTO mur_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Arooŋnyu ɔɔtɔ icinit artɛ ci amɔɔni ŋɔɔti? Yo da arooŋnyu ɔɔtɔ icinit eet ci aborcek rumanɛ ci alina? Bar kanɛ alaŋ een nɛɛn, eeci ɔl ci anyak rumanɛ ci alina abaak gɔɔn niigi ceezine o adikir alaatu. ");
INSERT INTO mur_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yo da arooŋnyu ɔɔtɔ icinit nyakaŋan? Kanekuŋ zin nɛ, Icintu zin da didi niiga eet ci adiŋdiŋ kujuk bar nyakaŋan. ");
INSERT INTO mur_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Eeci Jɔn nica nyakaŋan baal azɔɔz Jooi waragewe onin e nɛɛn, baal azi nɛ, Kitoon katin toonnyai onan karayai ŋaatun, ka kiiya kidimdimaneyin gɔl unun. ");
INSERT INTO mur_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kanekuŋ zin nɛ, Jɔn niini nyakaŋan ci titiny kujuk ɔl dook. Maje ɛɛti ci abaak baliinte o Joowo mayo nuun cɛlbɛz niini ɔrɔɔt, adiŋdiŋ niini ɔrɔɔt kujuk Jɔn.” ");
INSERT INTO mur_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mazi avɔ azii ɔl dook kurum buk ɔl o alot meeri zoozok ci aduwa Yesu o, agaac niigi bar da zɔɔz o Joowo baal oonyi Jɔn nɔɔgɔ e zɔɔz ceen didi. ");
INSERT INTO mur_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Maje bar ɔl o Parici kibeen ɔl o gɔɔn ademzek ɔl lotinok o Mosis otoborit niigi gɔl o Joowo akati nɔɔgɔ, ma abor toonyɛnɛt ŋaati Jɔn. ");
INSERT INTO mur_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Izi ni Yesu nɛ, “Kayo ɔl ci ɔɔ nico noko kotobozek gitaz? ");
INSERT INTO mur_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Atobɔ bɔŋ niigi kibeen dɔl o miliny gɔɔn amici kɔrɔk bawuca o, o gɔɔn ma anek ogɛnɛ gɔnɔgi nɛ, Karuwekuŋ kidorɛt, bar niiga alaŋ arooŋnyu orogomit. Kabena beniin o daayizo, bar niiga alaŋ arooŋnyu utuluz. ");
INSERT INTO mur_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Baale ma aku Jɔn e, alaŋ niini nyaan awot, ma buk alaŋ adak dayiin ci adak ɔl dook o. Ma aziyu niiga nɛ, Anyak Jɔn miniŋit alya. ");
INSERT INTO mur_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kiiya naana Ŋɛɛrti Eeto, ma kaku kadake, ma kawodɛ. Bodo aziyu nɛ, Icinit di eet nico. Anyak alɛm, ma abaaki, ma eeginɔ laŋoten kibeen ɔl o alot meeri ki ɔl o baciinowu. ");
INSERT INTO mur_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ayelzai zin gɛnyizi o Joowo kɛlɛɛmɛ ole o agama nɔɔnɔ dook.” ");
INSERT INTO mur_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Otowo ni ɛɛti ceen Pariciwen kazi Saiman Yesu ka kɔɔt kadaktɔ ki nɔɔnɔ ole onin. Ook ni Yesu ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Maje kuture nice anyak ŋaa ceen waaŋnyai. Mazi azii niini Yesu aavi ole o eet ween Pariciwen, iiya anyaa ketezewoc ci anyak karacoc. ");
INSERT INTO mur_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma aku abilnek niini Yesu eci bawuco. Ma alu olla murur nɔkɔ zɛɛ makacin aparantozek tilalɔ ciginɛ o Yesu zɔɔ. Ma ɛɛya tilalɔ Yesu zɔɔnɛ imanɛ, ma acoco nɔɔnɔ zɔɔ, ma aḏuutɛkɛ buk nɔɔnɔ karacoc zɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mazi acin ɛɛti ceen Pariciwen noko gi nico, abaaban niini doon ziniza izi nɛ, “Matɛ ɛɛti nici kizi nyakaŋan didi, aga waan ŋaa ci uum nɔɔnɔ noko ŋaa ci baciinowu.” ");
INSERT INTO mur_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Enek ni Yesu nɔɔnɔ nɛ, “Saiman, anyak gi ci karooŋ kuduwayin.” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Duwayan labak, alaan o demziinto.” ");
INSERT INTO mur_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ma anek Yesu nɔɔnɔ nɛ, “Anyak baale ɔl ceen ram ci adoma guruc eete oman ka katin kuruktek niigi nɔɔnɔ. Ɛɛti codoi ŋaatineeŋ adoma guruc ceen kaboot tur (500). Maje ɛɛti ceeni adoma guruc ceen eet ram kamɔtɔ (50). ");
INSERT INTO mur_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Alaŋaan ni ɔl nici anim kuruktek guruc nicoko eet baal adoman niigi guruc e. Makacin otoŋek niini nɔɔgɔ guruc calaŋ ajin bodo.” Ma ajin Yesu Saiman anek nɛ, “Mayo inoko ole ceen ram noko ŋɛnɛɛn ci arɛɛz nɔɔnɔ ɔrɔɔt?” ");
INSERT INTO mur_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma abɛdɛkɛ Saiman nɔɔnɔ anek nɛ, “Ecan kazi nɛ, Arɛɛz nɔɔnɔ ɔrɔɔt ɛɛti o ooŋnek guruc o meelik e.” Enek ni Yesu nɔɔnɔ nɛ, “Alɛɛma zin didi.” ");
INSERT INTO mur_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Enico ubuude Yesu, ma acin ŋaa, ma anek Saiman nɛ, “Acin yo ŋaa nico? Uyen ma kakunakin naana ineet ole unun e, akɔm maam ci anyan ka kotoonyi zɔɔ. Maje bar ŋaa nici inoko iiya otoonyan zɔɔ tilaloye ogin, ma ɛɛk bodo kodoyit kotire cin o. ");
INSERT INTO mur_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Buk uyene niina keere onai ŋaan talawan cocowan ŋalyamoc. Maje bar ŋaa nici inoko iiya ococowan zɔɔ ŋin ona kakunɛ e dook. ");
INSERT INTO mur_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ŋaan buk uyen niina vuudan ɔɔ maala. Maje bar niini inoko iiya uvuudan zɔɔ karacoca. ");
INSERT INTO mur_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kanekin zin nɛ, Ma reezinɛt cinɛ o ayelza gi o aaryai nɔɔnɔ baciinowa oginɛ meelik. Bar zin ɛɛti ci aaryai ŋaatin baciinowa ci miliny alaŋ anyak reezinɛt ci appe.” ");
INSERT INTO mur_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Enek ni Yesu ŋaa nɛ, “Aaryai baciinowa ugune.” ");
INSERT INTO mur_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mazi azii ɔl ci ona adake kibeen nɔɔnɔ o zɔɔz nico, ijintɔ izitɔ nɛ, “Ma dim niini ŋɛnɛɛn ci ka kaara baciinok o?” ");
INSERT INTO mur_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Maje Yesu anek ŋaa nɛ, “Uruguzin ineet tuwɛn unune. Tɔ yaak.” ");
INSERT INTO mur_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma bodo iinyaye ogɛn ook ɔzɔp Yesu kuturyok o adikir kibeen o miliny buk, uuwak kaviyak o baliin o Joowo. Ɔrkɔr niini kibeen nuyak ogin een amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Buk ŋaai baal aara niini miniŋ o Loryento ŋaatineeŋ e kibeen ŋaai baal arogoz niini mɔɔrizɔi e ɔrkɔr kibeen nɔɔnɔ. Ma ŋaai nicigi awɔyi Meri o looc o kazi Magdala baal aara Yesu ŋaatin miniŋ o Loryento een torgɛrɛm e. ");
INSERT INTO mur_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ki Jowana ween ŋaa o eet o kazi Cuza o aliŋliŋonek alaan o kazi Erod, ki Susana, been ŋaai oogi ci meel ci gɔɔn atirit niigi Yesu kibeen nuyak ogin guruce o ajowa niigi kaale ugeec. ");
INSERT INTO mur_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mazi avɔ alotak kɔlɛ ci meel Yesu kuturyowɛ dook, iiya uduwak niini nɔɔgɔ yabziin ci anek nɛ, ");
INSERT INTO mur_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Anyak baale eet ci akɔ ḏowɛn mana. Mazi akɔ aḏowɛ, iitazak ḏowo ogɛnɛ gɔl kɛŋ, ma arɔc ɔl zɔɔnɛ, ma avu avɛra kibaali. ");
INSERT INTO mur_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bodo ḏowo ogɛn iinak ŋinti een biyɛn. Mazi akɔ aduŋna, araabjai taman nɔkɔ, eeci akɔm tɔdɔ nicoko nyonac ci ka kuruktɛkɛ ḏowo agɛrɔ looc. ");
INSERT INTO mur_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bodo ḏowo ogɛn iinak bila kɔrgɛn, ma iŋaaz niigi dook kibeen bila zɛɛ makacin eedit bila nɔɔgɔ calaŋ abiir. ");
INSERT INTO mur_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Maje ḏowo ogɛn iinak tɔdɔ ci abon, ma iroktai zɛɛ makacin ibiiritɔ juruŋ, ma anyaa gɔɔn vokonti codoi kɛbɛrɛ ci meelik gɛr.” Mazi adica Yesu yabziin nico, enek nɔɔgɔ nɛ, “Mã anyaku iin, iziiyit zɔɔz nico juruŋ.” ");
INSERT INTO mur_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mazi ajin nuyawa Yesu kɛŋ ci yabziin nico, ");
INSERT INTO mur_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Anyozozeyuŋ igeet gɛnyizi ci ka agayi zoozok o baliin o Joowo aroodi. Maje bar ɔl oogi aduyak olla nɔɔgɔ zoozowa nici gole ci yabziinto, ka mã azii, alaŋ aga keŋti cigeec. ");
INSERT INTO mur_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kɛŋ zin ci yabziin nico nɛɛn ce. Ma ḏowo zɔɔz o Joowo nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma ḏowo ci iinak gɔl kɛŋ o, atobɔ ki ɔl o gɔɔn azii zɔɔz o Joowo. Ma bar taman nɔkɔ aku Loryen, ma aara zɔɔz nico zinzeetine ugeec ka calaŋ atuwe ka korogit. ");
INSERT INTO mur_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma ḏowo ci iinak tɔdɔ ceen biyɛn o, atobɔ niigi kibeen ɔl o gɔɔn azii zɔɔz o Joowo, ma agam talniinta, bar alaŋ akɔ zɔɔz nici zinzeetine ugeec juruŋ. Ma atuwe niigi ŋintimiliny nɔkɔ. Mazi aku gi ci acina nɔɔgɔ tuwente cineeŋ o, ooŋ niigi tuwɛn, ma amiiri bodo ki vurut. ");
INSERT INTO mur_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma ḏowo ci iinak bila kɔrgɛn o, atobɔ niigi kibeen ɔl o gɔɔn azii zɔɔz o Joowo, ma atuwe, maje bar bodo ŋaato iinon zinzeeti ugeec kaal o loocu, ki arɔkzɛt, been kaal o arɛɛz niigi kutuguzɔ loota ŋina zɛɛ makacin acabit kaala nici nɔɔgɔ calaŋ tuwɛn cineeŋ o akɔ ki taden. ");
INSERT INTO mur_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma ḏowo ci iinak tɔdɔ ci abon o, atobɔ niigi kibeen ɔl o gɔɔn azii zɔɔz o Joowo, ma azooni juruŋ zinzeetine ci abon. Ma amɛna niigi tuwente uneeŋ zɛɛ ma aliŋliŋonek Jook juruŋ gole ci abon. ");
INSERT INTO mur_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Akɔm zin laadun eet ci atokol lamba, ma bodo abuŋ kodooca, karabɔŋ arek kɛrca loota. Bar kanɛ atokol niini lamba, ma arek ceez kɔrgɛn ka kataraan ceez dook, ka mã avunak ɔl ceez, acin niigi looc juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Zin mã anyak gi ci inoko aroodi, katin ayelzai kiziiyɛ. Buk mã anyak gi ci abuŋe, katin ayelzai kicinɛ, ma adɛnyai juruŋ vooritina. ");
INSERT INTO mur_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Abon zin niiga aziiknu zɔɔz o Joowo juruŋ. Eeci ɛɛti ci aga zɔɔz o Joowo azaaconek nɔɔnɔ kizi appe. Maje bar ɛɛti calaŋ zɔɔz o Joowo aga, ma bar abaaban niini kizik aga ci miliny, aamnyai koca bar ŋaatin ci miliny noko kavu nɔkɔ dook.” ");
INSERT INTO mur_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Mazi avɔ avunak Yesu gɔtɔnɔgja kibeen yaatin, akɔma gɔl ci ka kurumtɔi niigi been nɔɔnɔ, eeci mɛɛlɛ ɔl ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iiya ni enek ɛɛti oman Yesu nɛ, “Yaatun kibeen gotonogu bitaala. Arɔɔŋ kicintin ineet.” ");
INSERT INTO mur_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ma abɛdɛkɛ Yesu nɔɔgɔ dook anek nɛ, “Yaai kibeen gɔtɔnɔga nɛɛn ɔl o azii zɔɔz o Joowo, ma azooni.” ");
INSERT INTO mur_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ma iitene oman enek Yesu nuyak ogin nɛ, “Kabaaktozek di liil baagit.” Otoodit ni niigi kavool ɔtɔɔzɔ. ");
INSERT INTO mur_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mazi ŋaan awɔ liil kɛŋa nɔkɔ, ɛtɛɛda Yesu ooŋnya. Ŋintimiliny nɔkɔ iiya ŋɔɔti ci appe ɔrɔɔt, ma apalpalanek maam kavool ci arɔɔŋ uup. Makacin iziti niigi tirinyɛ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɔɔtɔ ni nuyawa ŋaati Yesu, ma avɔ iiŋka anek nɛ, “Manyi, Manyi, tiŋa je! Iiyayet daayizi!” Ma iŋaaz Yesu jena, ma agernyek ŋɔɔt kibeen maam o apalpalani e kitivantɛ. Ma ajaŋani didi tiv. ");
INSERT INTO mur_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma anek niini nuyak nɛ, “Tuwɛn cunooŋ o inoo?” Ma abiir nɔɔgɔ ooti tɛt, maje ŋaato anyak ŋoliin. Ma ajinɔ niigi maany anɔ nɛ, “Mayo eet taz nici? Meen nuun ŋɔɔt kibeen maam agernyek, ma azii nɔɔnɔ kajaŋantɛ tiv!” ");
INSERT INTO mur_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Enice ɔɔtɔ Yesu kibeen nuyak ogin zɛɛ ma avɔ arum looc ci ajɔŋɔzɔ ki kutur o kazi Garazin o avɛnɔ ki Galili liil baagita. ");
INSERT INTO mur_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Mazi aduŋnak Yesu dɔwɔn ŋinaante, iiyak nɔɔnɔ ɛɛti ci anyak miniŋ ci Loryento. Ɛɛti nici awɔ ŋaḏinyiny nɔkɔ irkitok ci meel gɛr, ma buk alaŋ abaak ɔlɔ, bar abaak vitɛnane o gɔɔn adawi ɔl ɔl o adaai. ");
INSERT INTO mur_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Mazi acin niini Yesu, ɛgɛrɛny ɔrɔɔt ɛlɛ, ma avaci ɛlɛ looc nɔɔnɔ zɔɔnɛ. Ma azi molowe ci appe nɛ, “Yesu ween ŋɛɛrti Jook o adikir, arooŋ gitaz ŋaatan? Kilalekin ineet, má da apiranan.” ");
INSERT INTO mur_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Aduwa niini gi nico o, eeci egerenyek uyen Yesu miniŋ o Loryento kudunta ŋaatin. Lak ci meel gɛr ci gɔɔn agidi miniŋa nici nɔɔnɔ. Ma acap ɔl nɔɔnɔ azɛɛn been zɔɔ ziiyi, bar atɛɛt niini ziik nicoko, ma avɔyi nɔɔnɔ miniŋa nici balala. ");
INSERT INTO mur_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ma ajin Yesu nɔɔnɔ anek nɛ, “Kazi zaar cugun nɛ?” Abɛdɛkɛ niini Yesu anek nɛ, “Kazi zaar cigan nɛ Kɔlɛ.” Aduwa niini zɔɔz nico o, eeci anyak niini miniŋ ci Loryento meel alya. ");
INSERT INTO mur_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ma ilalek miniŋa nici Yesu ka calaŋ atooyek niini nɔɔgɔ ŋolol o miniŋu. ");
INSERT INTO mur_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Maje ŋinaante anyak kɔcɔcɔbanɛn ci meel gɛr agɛ bɛ tadena. Ma ilalek miniŋa nicigi Yesu ka kanyek nɔɔgɔ kɔɔt kɔcɔcɔbanene nicoko. Agama ni Yesu zɔɔz cineeŋ o. ");
INSERT INTO mur_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma aduŋna miniŋa ci Loryento noko eete nico, ma avɔ kɔcɔcɔbanɛnɛ. Ma avira kɔcɔcɔbanɛna nici tadena, ma avu iinak liil kutudude niigi dook lai. ");
INSERT INTO mur_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ma adɔkɔny ɔl ci ona owa kɔcɔcɔbanɛn o, ma avɔ aduwak ɔl o kuturo kibeen ɔl manɛɛni gi nico. ");
INSERT INTO mur_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ivita ni ɔl ka kivita kicinit gi ci agooni o. Mazi avunak niigi Yesu, amada eet ona aduŋna miniŋa o Loryento ŋaatin e aavi Yesu libira. Anyawun rum alya, maje buk ɔɔ oninɛ obona labak. Ma anyak ɔl dook ŋoliin zooze nico ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Oobtek ni ɔl ona aavtiz tɔ e ɔl ci ona avu vurta o zɔɔz ci arogzi Yesu eet nico o. ");
INSERT INTO mur_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Enektek ni ɔl dook o abaak looce ci kazi Garazin noko Yesu nɛ, “Tɔ looce cinaaŋ o”, eeci anyayit niigi ŋoliin ɔrɔɔt. Enico otoodun Yesu kavool, ɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ilalek ni ɛɛti ona aduŋna miniŋa ci Loryento ŋaatin noko Yesu enek nɛ, “Korkorit da.” ");
INSERT INTO mur_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Bar anek Yesu nɔɔnɔ nɛ, “Akɔm! Miire. Bitɔ ɔlɔ, ka bitɔ duwak ɔl gi ci ona agoonekin Jooi noko.” Ɔtɔɔ ni ɛɛti nici, ma akɔ azɔp kutur uneeŋ dook aduwak ɔl gi ci ona agoonek Yesu nɔɔnɔ o. ");
INSERT INTO mur_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Mazi akɔ abada Yesu liil baagita, atalta ɔl ci meel nɔɔnɔ, eeci uyen laadun arɛ niigi dook nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iiyak ni nɔɔnɔ ɛɛti ci kazi Jairas ceen alaan ci miliny ceeze o Juz lotento. Aku niini, ma akani kozoŋti looc Yesu ŋuma, ma ilalek nɔɔnɔ ka korkorit kɔɔtɔ ole onin. ");
INSERT INTO mur_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Eeci anyak niini bɛɛnyin ci adoye ṯɔr nɔkɔ ci een irkitowa ci aritan amɔnki ram. Amɔɔr niini ɔrɔɔt ɛlɛ, ma ɔdɔvyai ka kadaak. ");
INSERT INTO mur_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma awɔ Yesu o, adala ɔl nɔɔnɔ libirɔ dook. Maje ole nicoko eecitɔ anyak ŋaa ci amɔɔr ariik kɛŋ biye irkitok amɔtɔ ram. Ma adica niini kaal ogin anyak dook akimanɛn, ma ŋaan kojowa akim ci arogoz nɔɔnɔ nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Iiyak ni niini Yesu eci bawuco kɔlɛ kɔrgɛna ŋina, ma aku uum nɔɔnɔ rum onin malkinto. Enico ɛlɛ itivanɛ kɛŋ oninɛ ariike tiv. ");
INSERT INTO mur_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ma ajine Yesu azi nɛ, “Ŋɛnɛɛn ci uumnyan o?” Ma adaŋnye ɔl dook zɛɛ makacin izi Pitɔr nɛ, “Manyi, ajine o, ma aliyanin ɔl libirɔ dook zɛɛ ma ajukɔ noko alaŋ acin?” ");
INSERT INTO mur_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Maje bar Yesu azi nɛ, “Anyak eet ci uumnyan tɔ, eeci kaga anyak dɔyiz ci uduna ŋaatan.” ");
INSERT INTO mur_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mazi akɔ acin ŋaa Yesu agawun gi ci ona agɔɔn niini o, iiya ŋoliinta kabarit, ma aku akani kozoŋti looc Yesu kɛŋa. Ma aduwak nɔɔnɔ ɔl kɔrgɛna ŋina gi ci aku uumi niini nɔɔnɔ o, kibeen rogɛt ci orogi niini enico ɛlɛ o. ");
INSERT INTO mur_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Enek ni Yesu nɔɔnɔ nɛ, “Bɛɛnyan, uruguzin ineet tuwɛn unune. Tɔ yaak.” ");
INSERT INTO mur_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mazi ŋaan aduwa Yesu gi nico nɔkɔ, iiya ɛɛti ci itoonnyai ole o Jairas. Ma aku anek nɔɔnɔ nɛ, “Adaak bɛɛnyun. Má ŋaan amila alaan ci demziinto o gaga.” ");
INSERT INTO mur_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Maje buk Yesu azii gi nico nɔkɔ, ma anek Jairas nɛ, “Má anyei ŋoliin gaga, bar olla tuwɔ, eeci arogi tedec bɛɛnyun labak.” ");
INSERT INTO mur_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mazi akɔ arum Yesu kɔrɔk o Jairas, alamun niini ɔl dook ŋaati avɔyi ceeza. Ma akɔyi niini ceeza Pitɔr ki Jɔn ki Jemis ki baati doleco ki yaatin doon. ");
INSERT INTO mur_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Maje ɔl dook alu, ma iinon dole. Ma anek Yesu nɔɔgɔ nɛ, “Má aluyu gaga. Alaŋ dole adaai, olla ɔɔŋ labak.” ");
INSERT INTO mur_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bar ararni niigi nɔɔnɔ zooze nico, eeci aga niigi dole adaawa. ");
INSERT INTO mur_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ma agam Yesu dole aziit, ma awo anek nɛ, “Dole, tiŋa je.” ");
INSERT INTO mur_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma abadaak dole vɔŋizi oninɛ, ma iŋaaz enico ɛlɛ. Ma anek Yesu nɔɔgɔ nɛ, “Anycek dole gi ci adak.” ");
INSERT INTO mur_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma abiir baatin ki yaatin ooti ɔrɔɔt ɛlɛ giye nico, bar aricanek Yesu nɔɔgɔ calaŋ aduwak ɔl oogi gi nico. ");
INSERT INTO mur_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ma iitene oman otowa Yesu nuyak ween amɔtɔ ram ŋaatodoi, ma anyek nɔɔgɔ dɔyiz ci ka kɔtɔɔkti miniŋ o Loryento ɔla, ma arogozi ɔl mɔɔrizɔi. ");
INSERT INTO mur_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Itoonun ni nɔɔgɔ kɔɔt kuuwayit baliin o Joowo, ma arogoz ɔl mɔɔrizɔi. ");
INSERT INTO mur_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma anek nɔɔgɔ nɛ, “Ɔtɔɔz kɔkɔm gi ci anyaku. Kɔkɔm kɛɛn ci omtinto, ki kaboot ci anyaku kaal, ki dayiin, ki guruc, ki rumanɛ. ");
INSERT INTO mur_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mã ajowanu kɔrɔk ci atalnanuŋ ɔl, aavtiz ole nico zɛɛ been iiten ci awoyu kuture nico. ");
INSERT INTO mur_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mã ajowanu kutur calaŋ atalnanuŋ ɔl igeet, utuduŋta tɔdɔ zɔɔnɛ ka keyeliza gi nici gi o aborni niigi zɔɔz onan.” ");
INSERT INTO mur_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɔtɔɔzɔ ni nuyawa, ma avɔ azɔp kuturyok ci meelik aduwak ɔl kaviyak o Joowo abon, ma buk arogoz ɔl ci amɔɔr vitɛnane niceke dook. ");
INSERT INTO mur_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Mazi akɔ azii Erod ween alaan o Galili kaviyak o kaal o agɔɔn Yesu, abaraŋɛ nɔɔnɔ ɔɔ ɔrɔɔt ɛlɛ, eeci azi ɔl nɛ, “Nicini Jɔn baal oony ɔl e nɛɛn itiŋa bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Maje bodo ogɛnɛ azi nɛ, “Ilija gi abada tamma.” Maje ɔl ogɛn anɔ nɛ, “Nyakaŋan codoi nyakaŋanete baal adaayitɔ e itiŋa bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ma azi Erod nɛ, “Baale kanyeya takiren keteeda Jɔn ɔɔ. Mazin bodo eet jaŋ ci kazii ŋaan agɔɔn kaal nicoko o?” Orooŋun ni niini kicin Yesu ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mazi avɔ abada toonnyawa keronnya, ivita uduktak Yesu kaal baal avɔ agɔɔn niigi o dook. Ma akɔyi Yesu nɔɔgɔ doon ŋaati ajɔŋɔzɔ ki kutur o kazi Bezediya. ");
INSERT INTO mur_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mazi avɔ azii kɔlɛ Yesu ook ŋinaante, oneec buk niigi nɔɔnɔ. Ma akɔ atalna Yesu nɔɔgɔ dook. Edemzek ni niini nɔɔgɔ zɔɔz o akati baliin o Joowo, ma buk arogoz ɔl ci amɔɔr ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mazi akɔ atoltol ii loota yomana, ivitak nɔɔnɔ nuyawa oginɛ een amɔtɔ ram, ma avu anek nɛ, “Anyek ɔl kazaantozek korogjok ci ajɔn ŋina noko ka coma avɔ ajowa dayiin kibeen vitɛn ci ooginɛ ŋinaante, eeci ŋiniti een balal.” ");
INSERT INTO mur_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Anycek nɔɔgɔ dayiin ci adak niiga alya.” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kanyaka ḏɔkɛn tur nɔkɔ kibeen kuluk ram. Arooŋnyet tɛ koota kataaltawa dayiin ci ka kadayit kɔlɛ ci meel noko dook?” ");
INSERT INTO mur_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maje ɔl ci aavtiz ŋinaante o een maczɛt doon eet eetom lak ram ki eet amɔtɔ lak tur (5000). Ma anek niini nuyak nɛ, “Uduktak ɔl kaavtiyɔ loota. Anycek gɔɔn ɔl ceen eet ram kamɔtɔ (50) kaavtiyɔ ŋaatodoi.” ");
INSERT INTO mur_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Utuguzɔ ni toonnyawa eci ona aduwakɛ Yesu nɔɔgɔ o. ");
INSERT INTO mur_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Odoma ni Yesu ḏɔkɛn ceen tur noko kibeen kuluk ween ram e, ma agɛlɛm tammu taden, ma anyek Jook zany dayiine nicoko. Ma atɛɛt, ma anyek toonnyak ka keŋeryek niigi kɔlɛ dook. ");
INSERT INTO mur_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma adake ɔl dook zɛɛ makacin ipiiyantɛ, ma alota toonnyawa ŋodota ci anyigzai dayiinɛ o zɛɛ ma abitiz gilanya amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ma iitene oman mazi akɔ ajin Yesu Jook ŋaati aromɛn ki toonnyak ogin doon, ijin niini nɔɔgɔ enek nɛ, “Ma dim inoko gɔɔn ɔl azi nɛ, Keen naana ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Azi ɔl ogɛnɛ nɛ, Een niina Jɔn o oony ɔl. Maje ɔl ogɛn azi nɛ, Een niina Ilija. Maje ogɛnɛ anɔ nɛ, Een nyakaŋan codoi nyakaŋanete baal rɛɛn e ci itiŋa bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma ijin bodo niini nɔɔgɔ anek nɛ, “Ma niiga aniyu nɛ, Keen naana ŋɛnɛɛn?” Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Een niina Kiristo o itoonanin Jooi.” ");
INSERT INTO mur_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iricanek ni Yesu nɔɔgɔ gi ci anek nɛ, “Má avɔ zin aduwaku ɔl oogi zɔɔz nico been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma anek Yesu toonnyak ogin nɛ, “Tiŋeere naana Ŋɛɛrti Eeto kagide ɔrɔɔt, ma abornan ɔl o Juz adikir, ki alaat o ceez o Joowo, been ɔl o gɔɔn ademzek ɔl lotinok o Mosis. Arukan tiŋeere niigi aneeta kadaak, ma iinyaye ceen iiyu kiŋaaz daayiza korok bodo.” ");
INSERT INTO mur_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Enek ni niini ɔl dook nɛ, “Mã arɔɔŋ ɛɛti konowan aneet, abon areyek nɔɔnɔ ɛlɛ oninɛ, ma abon agama gidɛn ki piryakzɛt ŋaati anuyan niini aneet. ");
INSERT INTO mur_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Eeci ɛɛti ci arɔɔŋ korogoz ɛlɛ onin, bar akoloz. Maje ɛɛti ci akoloz ɛlɛ onin ŋaatan, bar arogoz. ");
INSERT INTO mur_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mayo zin inoko mã anyak ɛɛti kaal o loocu dook, ma bar akoloz rogɛt ci ɛlɛ onin, bonat inoo? ");
INSERT INTO mur_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mã anyak ɛɛti ci anyak alyaan ŋaatan kibeen demziinte onan, buk tiŋeere naana Ŋɛɛrti Eeto kanyei alyaan ŋaatin iitene ci kakunɛ diŋdiŋonte onan, ki diŋdiŋonte o baaba, been diŋdiŋonte o toonnyak o tammo. ");
INSERT INTO mur_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Didilɛ kaduwakuŋ igeet, anyak ɔl oogi ole ci aavtiyu ŋina noko calaŋ rak adaai zɛɛ ma alam acin niigi baliin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Mazi avɔ iinya ceen turge, ooyi niini Pitɔr ki Jɔn been Jemis bɛ tadena ka kɔɔt kaŋaruyɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Mazi ŋaan aŋaryɛ niini nɔkɔ, otowɛ ŋum oninɛ, ma ookci rumanɛ oginɛ buk kizi vɔɔrɛ pɛr kataraanet. ");
INSERT INTO mur_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Taman nɔkɔ ivita ɔl ceen ram, ma azɔɔzɔ kibeen nɔɔnɔ. Ma ɔl nicigi Mosis kibeen Ilija. ");
INSERT INTO mur_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ayelzai niigi diŋdiŋɔnta, ma avu azɔɔz kibeen Yesu gi baal laadun akuni niini ka kiiya kadaai Jerusalɛma e. ");
INSERT INTO mur_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Maje Pitɔr kibeen gɔnɔgi oogin. Mazi iŋaaz niigi ooŋnyai, bar acin Yesu otowɛ diŋdiŋonte onin kizi vɔɔr pɛr, ma acin buk niigi ɔl ceen ram aromɛ kibeen nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mazi avɔ aŋɛrɔ Yesu ki ɔl nicoko, enek Pitɔr nɔɔnɔ nɛ, “Manyi, kavu tɛ ŋina juruŋ inoko. Nyet kɛtɛɛnycawa kaal ceen ceezi kabili kɔr een iiyu, ka codoi kizi cun, codoi ci Mosis, codoi ci Ilija.” Aduwa buk Pitɔr zɔɔz nicoko kilek. ");
INSERT INTO mur_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Mazi ŋaan azi niini nɔkɔ, iiya diizoc ci appe, ma aku abuŋa nɔɔgɔ, ma anyak niigi ŋoliin diizoce nico ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma aku diizoce nico mɔlɔyi ci azi nɛ, “Nicini ŋɛɛran onan kaŋɛra nɛɛn. Iziiyit zin niiga dook nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Mazi ativani mɔlɔyi nici, acin nuyawa Yesu aavu niini doon. Ajaktɔ ni niigi ma ŋaan kuduktak eet oma iinyaye niceke kaal ci baal acin niigi o. ");
INSERT INTO mur_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mazi alocai niigi bɛ tadena iitene ci ano gɔn o, ivitak kɔlɛ ci appe Yesu. ");
INSERT INTO mur_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma agɛrɛny ɛɛti oman kole nico eecitɔ azi nɛ, “Alaan o demziinto, kilalekin da cineyan ŋɛɛran can adoi ṯɔr nɔkɔ ce. ");
INSERT INTO mur_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Anyak gɔɔn miniŋit ci agam nɔɔnɔ kɛgɛrɛny ɔrɔɔt tup nɔkɔ. Ma avaci looc kataval zɛɛ ma aduuv ɔtɔgi. Ma amɛna miniŋit nici agit nɔɔnɔ nɔkɔ, ma alaŋ arɔɔŋ kotoŋa been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kilalei iiten baale nuyak ugun ka kaarya miniŋit nico, bar akɔmnek nɔɔgɔ ŋaati aaranɛ.” ");
INSERT INTO mur_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ma anek Yesu nuyak nɛ, “Igeet ɔl ci akɔmnuŋ tuwɛn coko. Kayo koromtɛ naana kibeen igeet zɛɛ been inin ka utuyɔ? Ka kɛmɛz zɔɔz cunooŋ zɛɛ been inin?” Ma anek baati doleco nɛ, “Jai di ŋɛɛrun ŋaato.” ");
INSERT INTO mur_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Mazi ŋaan awoya dole nɔkɔ, avaci miniŋit nici nɔɔnɔ looc kir kataval, kabarit kɛdɛkɛdɛk. Ma agernyek Yesu miniŋit nico kuduna doleca. Orok ni dole, ma anyek Yesu nɔɔnɔ baatin. ");
INSERT INTO mur_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma abiir ɔl o aavtiz ŋinaante dook ooti dɔyize ci Joowo adikir noko. Mazi ŋaan abiir ɔl dook ooti kaale ci agɔɔn Yesu noko, enewun Yesu nuyak ogin nɛ, ");
INSERT INTO mur_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Iziiyit di zɔɔz ci karooŋ kuduwayuŋ ce juruŋ. Iima naana Ŋɛɛrti Eeto kanyononei azɛɛn ci ɔl o deer.” ");
INSERT INTO mur_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bar nuyawa alaŋ aga kɛŋ ci zɔɔz ci aduwak Yesu nɔɔgɔ noko, eeci waanice kɛŋ ci zɔɔz nico arɔɔdjai ka calaŋ niigi ajowa. Ma aŋole buk niigi ŋaati ajini nɔɔnɔ zɔɔz ci akati gi nico. ");
INSERT INTO mur_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma eco adaŋtɔi nuyawa niigi maany gi ci akati alaazɛt ŋaatineeŋ anɔ nɛ, “Mayo dim ŋaatinai adikir ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Maje Yesu aga kaal ci ɛɛl zinzeetine cigeec o nɔkɔ. Odoma ni dole ci miliny, ma anyek kibil nɔɔnɔ libira. ");
INSERT INTO mur_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ma anek nɔɔgɔ nɛ, “Ma ɛɛti ci arɛɛz dole ci miliny kiyo nici noko zaare ogan, areezan buk koca niini aneet. Ma ɛɛti ci areezan aneet, arɛɛz buk niini baaba o itoonanan aneet. Eeci ɛɛti ci cɛlbɛz ŋaatunooŋ, titiny bar niini ŋume o Joowo ɔrɔɔt kujukuŋ igeet dook.” ");
INSERT INTO mur_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ma anek Jɔn Yesu nɛ, “Manyi, kajowana iiten baale eet ci aara miniŋ o Loryento ɔla zaare ugun. Ma kalamnya nɔɔnɔ kibili gi nico, eeci niini alaŋ een eet cinai.” ");
INSERT INTO mur_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ma anek Yesu nɔɔnɔ nɛ, “Má alamnyu nɔɔnɔ gaga, eeci ɛɛti calaŋ amarninet ageet, niini eet cina.” ");
INSERT INTO mur_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mazi ka kizi ŋinti ka kooyi Yesu tamma, itiŋa niini, ma atɛɛda gɔl zinize codoi ṯɔr nɔkɔ ook Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma itoon niini toonnyak karaktɛ kɔɔt kuture ci abil looce o kazi Samariya ka kɔɔt korooŋtek niigi nɔɔnɔ ŋinti ɔɔŋɛ. ");
INSERT INTO mur_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Maje bar ɔl kuture nice alaŋ atalna nɔɔnɔ, eeci aga niigi nɔɔnɔ aku adicek akɔ Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mazi acin Jemis kibeen Jɔn gi nico, enektek niigi Yesu nɛ, “Manyi, alaŋ anyet kutuyawa goo tamma kiiya ka kotooz ɔl ci kutur nico noko naa?” ");
INSERT INTO mur_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bar ookci Yesu, ma agernyek nɔɔgɔ zooze nico. ");
INSERT INTO mur_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Idicek ni ɔɔtɔ kuture oman. ");
INSERT INTO mur_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mazi ŋaan awɔ Yesu ki nuyak gɔla nɔkɔ, iiya ɛɛti oman, ma aku anek Yesu nɛ, “Karooŋ buk kunuwin naana ineeta. Olla ŋinti akɔyɛ o, kɔrkɔr.” ");
INSERT INTO mur_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Anyak kireerwana looknya, ma anyak kibaali ceezi, maje bar naana Ŋɛɛrti Eeto alaŋ kanyei ŋinti ka kaavɛ loota ka kuyubuzi.” ");
INSERT INTO mur_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma anek niini eet oma nɛ, “Nowawan niina aneet.” Bar abɛdɛkɛ ɛɛti nici nɔɔnɔ anek nɛ, “Manyi, nyan rak kimiirozek kɔrɔk, eeci karooŋ kook kɛrɛ baaba zɛɛ ma kiyaŋ naana alya.” ");
INSERT INTO mur_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Anyek ɔl ci adaai o kiyaŋit gɔnɔgi o adaai niigi maany. Ija niina ka bitɔ uuwayek ɔl zɔɔz o baliin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma anek bodo ɛɛti oman nɔɔnɔ nɛ, “Manyi, Ŋaan ŋɛdɛt kaku kanuyin. Nyan zin rak kook ɔlɔ ka kook kuduwak ɔl weet.” ");
INSERT INTO mur_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm laadun eet ci akana keevin mana, ma bodo abuudi ki vurut ci anim kɛɛva mana. Zin buk niiga mã agoonu nɔkɔ, alaŋ koca aganonu ki baliin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma vurta ɛŋɛra Manyi Yesu ɔl ceen eet iiyu kamɔtɔ ki tiin ram (72). Ma itoon nɔɔgɔ karaktɛ nɔɔnɔ ɔɔwa korkorit gɔɔn raman, raman, ka kɔɔt kuturyowɛ kibeen vitɛnane o ka kooyi niini dook. ");
INSERT INTO mur_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma anek niini nɔɔgɔ nɛ, “Anyak ŋinaanto manɛɛn ci meel ka keteede, bar zin ɔl ci teedinto o kidicɛ tɛr. Ijinit zin eet o mano ka kitoona niini ɔl ci ka kivita keteedɔ. ");
INSERT INTO mur_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ɔɔtɔ zin. Olla naana kitoonuŋ igeet ɔtɔɔz kiyo aza o awɔ guzule kɔrgɛna o. ");
INSERT INTO mur_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Má avoyu guruc, karabɔŋ een dayiin. Má avoyu buk caava. Má amilmilanu eleeti ŋaati azaayu ɔl oogi gɔla. ");
INSERT INTO mur_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma avoyi korge ci avoyu, azaac rak ɔl ɔɔwa enektek nɛ, Abonanu ɔl ci korgu. Anyuŋ Jooi ganɔn igeet ɔl ci kɔrɔk nico. ");
INSERT INTO mur_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mã een ɛɛti ci korgu o o eet ci abon ganonto, ma arɛɛza zaawinɛt cunooŋ o, anyak niini mayuwɛnɛt zaawinte cunooŋ o. Mazi bar alaŋ atalna ɛɛti ci korgu o zaawinɛt cunooŋ ganonto o, abadakuŋ koca mayuwɛnɛt ci zaawinɛt cunooŋ o igeet ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aavtiz zin korge ci eet ci ona atalnanuŋ o doon. Má azobju korogjok ci meel. Ozolit ki nɔɔgɔ maam ki dayiin ci olla tɛ anyuŋ niigi igeet o. Eeci eet ci aliŋliŋ abon aruwonek buk nɔɔnɔ vɔyita ci liŋliŋɔn cin o. ");
INSERT INTO mur_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ma avoyu kuture ci atalnanuŋ ɔl, olla dayiin ci anyaakuŋ niigi igeet o adayit. ");
INSERT INTO mur_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Orogozit ɔl mɔɔrizɔi kuture nico. Buk enektek nɔɔgɔ nɛ, Izi baliin o Joowo ajɔn ŋaatunooŋ. ");
INSERT INTO mur_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mazi anyak kutur ci avoyu ma alaŋ atalnanuŋ ɔl, udunta bitaala ivitak gɔl, iziti zin nɛ, ");
INSERT INTO mur_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Mã een tuduwac ci looc cunooŋ agamnyet zɔɔ cigaacak o, ŋaan kajulakuŋ. Bar zin abon agayu gi o izɔi baliin o Joowo ajɔn ŋaatunooŋ.” ");
INSERT INTO mur_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, tiŋeere iitene ci roonnyo e apayek Jooi kutur ci abornuŋ ɔl igeet neke gerzitin. Ma payiin nica tiŋeere appe ɔrɔɔt kujuk payiin baal kutur o kazi Sodom e.” ");
INSERT INTO mur_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ma azi Yesu nɛ, “Izi nɔŋa cugune wole kutur o kazi Korazin. Izi nɔŋa cugune wole kutur o kazi Bezediya. Mã da baal kutuguze kaal ci atɛɛt ɔl biye kuturyowe o kazi Tayor kibeen Sidon kiyo agooni ŋaatunooŋ ŋina noko, abadit waan ɔl ugeec mony baal rɛɛna many zɛɛ ma aborcek daŋkɛt eleeti, ma amek eleeti burtanɛ ka keyelizta gi o otoŋti niigi oŋɛ ugeec. ");
INSERT INTO mur_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ma zin tiŋeere iitene ci payiinto e apayekuŋ Jooi igeet gerzitin ci appe ɔrɔɔt kujuk Tayor been Sidon. ");
INSERT INTO mur_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ma niina Kapernam arooŋ buk dɔŋ ɛlɛ bitɔ ki tammu taden. Bar zin tiŋeere ajukonei lɔtɔn o Loryento.” ");
INSERT INTO mur_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ma anek Yesu nuyak ogin nɛ, “Mã anyak eet ci aziiŋnuŋ igeet, aziiŋnan buk niini aneet. Mã anyak eet ci abornuŋ igeet, abornan buk niini aneet. Mazin ɛɛti ci abornan aneet, abor buk niini baaba o itoonanan aneet.” ");
INSERT INTO mur_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Zin abadaak toonnyawa ween eet iiyu kamɔtɔ ki tiin ram Yesu talniinta. Ma avu anek nɔɔnɔ nɛ, “Manyi, ma een nuun miniŋ o Loryento aziiŋnet ageeta ŋaati kagernyeka nɔɔgɔ kudunta zaare ugun.” ");
INSERT INTO mur_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ii, kicina didi Loryen iina tamma mɛlɛc kiyo gɔɔn abadi tammu o. ");
INSERT INTO mur_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ma naana kanyuŋ igeet dɔyiz ci ka oroci kowanya kibeen kitɛɛn. Ma amogju dɔyiz o Loryento kɔkɔm ci ci gɛr agoononekuŋ igeet been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bar zin má atalninu eeci aziiŋnuŋ miniŋa o Loryento igeet, bar ataltɔ, eeci eteyeede zaara ugoocok tamma.” ");
INSERT INTO mur_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma enice ɛlɛ anyawun Yesu talniin Vɔŋize o Joowo, ma azi nɛ, “Baaba, Manyi o tammu tadenu ki tɔdɔ, katalnɛ naana ɔrɔɔt ŋaatun, eeci arɔɔdɛ zɔɔz unun een didi ɔl o gɔɔn abaaban niigi kizik bar agɛny, ma iiya ayeleyu ɔl o cɛlbɛz. Nɔɔnɔ zin nɛɛn baaba. Agoon gi nico gole o arooŋ niina. ");
INSERT INTO mur_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Niina baaba anyan aneet kaal dook. Ma bar akɔm eet codoi ṯɔr nɔkɔ ci agayan aneet, bar agayan aneet niina baaba onane doon. Ma akɔm buk eet ci agayin ineet baaba, bar kagayin ineet naana ŋɛɛrun doon kibeen ɔl o kaŋɛra naana ka keyelezawin ineet ŋaatineeŋ.” ");
INSERT INTO mur_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ubuut Yesu nuyak ogin, ma anek nɔɔgɔ doon nɛ, “Amayuwuŋ Jooi igeet giye ci icintu niiga kaal ci acinu noko. ");
INSERT INTO mur_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Didilɛ kaduwakuŋ igeet, baale nyakaŋanɛta ki alaat ci meel arɔɔŋ kicinit kaal ci acinu niiga noko, ma bar ŋaan kicinit nɔkɔ been nɛɛn. Buk baale niini arɔɔŋ kiziiyit kaal ci aziiŋnu noko, bar ŋaan kiziiyit been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ma iitene oman iiya ɛɛti oman ole o gɔɔn ademzek ɔl lotinok o Joowo arɔɔŋ ka kiiya kicina Yesu zɔɔza. Ma aku ajin nɔɔnɔ anek nɛ, “Alaan o demziinto, mayo kutugu gitaz ka kojowa rogɛt o abil been nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Gɔɔn lotinowa o Joowo azi nɛ?” ");
INSERT INTO mur_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma abɛdɛkɛ niini Yesu anek nɛ, “Azi gɔɔn lotinowa nɛ, Rɛɛz Manyi ween Jook unun zinize unun dook, ki rogete unun dook, ki dɔyize unun dook, been baabaninte unun dook. Rɛɛz buk ɔl o abaawonu kiyo areez ɛlɛ unun o.” ");
INSERT INTO mur_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Alɛɛma zin didi. Bitɔ zin tugu nɔkɔ ka rok.” ");
INSERT INTO mur_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Maje bar ɛɛti nici arɔɔŋ kititiny ɛlɛ, ma bodo ajin niini Yesu anek nɛ, “Ŋɛnɛɛn dim ci kabaawona o?” ");
INSERT INTO mur_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Anyak baale eet ci aku Jerusalɛma aku akɔ kuture o kazi Jeriko. Ma akɔ zɛɛ ma gɔla urumtɔ kibeen ɔl ceen agoryak, ma aruk nɔɔnɔ, ma aama kaal ogin dook, ma adotek nɔɔnɔ ɛlɛ looc kazalkan ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Maje iitene nice anyak alaan ci miliny ceeze o Joowo anowa gɔl nico. Mazi aku acin niini eet ci azalkan noko, atayaŋun gɔl kabanyca, ma adicek. ");
INSERT INTO mur_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Bodo buk ŋintimiliny nɔkɔ onowa ɛɛti oman ceen Livayen ci gɔɔn aliŋliŋ ceeze o Joowo gɔl nico. Mazi aku akivek niini eet nico, atayaŋun buk niini gɔl kabanyca idiceya. ");
INSERT INTO mur_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ma vurte ci eet nico iiya ɛɛti oman ceen Samariyen ci ɛɛrɔn buk ano gɔl nico. Mazi aku akivek niini eet nico azalkan gɔla nɔkɔ, ɛtɛɛdɛ ziniz. ");
INSERT INTO mur_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iiyak ni niini nɔɔnɔ, ma aku amoor tobɛ ci ona aruwe noko, ma avuut maala. Ma acap juruŋ, ma adoŋek nɔɔnɔ zigir onin. Ma akɔyi zɛɛ been ceez o gɔɔn atikɛn kernowa, ma akɔ amɔɔriz nɔɔnɔ juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma iitene ci ano gɔn o odoma guruc ceen ram, ma aruwek eet ci abɛk ceez ci kernowu o, ma anek nɔɔnɔ nɛ, “Zooti eet nico juruŋ zɛɛ ma kabada tiŋeere. Mã anyak guruc cugun atirtɛ nɔɔnɔ, ŋaan kaku karuwekin.” ");
INSERT INTO mur_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ma anek Yesu nɔɔnɔ nɛ, “Inoko zin ŋaatun ole ceen iiyu noko, eet jaŋ ci abaawɔ kibeen eet ci baal aruk agoryawa noko?” ");
INSERT INTO mur_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma abɛdɛkɛ niini Yesu anek nɛ, “Eet ci abaawɔ ki nɔɔnɔ nɛɛn ci ateedi ziniz, ma atirit nɔɔnɔ o.” Enek ni Yesu nɔɔnɔ nɛ, “Bitɔ zin buk niina tugu nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mazi awɔ Yesu kibeen nuyak ogin, ɔɔtɔ zɛɛ ma gɔla idiirit kutur ci miliny abaayi ŋaa ci kazi Marta. Otowa ni Marta Yesu kiiyak kɔrɔk. ");
INSERT INTO mur_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maje Marta anyak ŋɔɔni ci kazi Meri. Iiya buk Meri, ma aku aavek Yesu loota nɔkɔ azii demziin onin. ");
INSERT INTO mur_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maje Marta aliŋliŋonek kernok ɔrɔɔt ɛlɛ. Makacin iiyak niini Yesu, ma aku anek nɛ, “Manyi, alaŋ ri aganɔ Meri ŋaati adotekan liŋliŋɔn dook aneet doon. Anyek nɔɔnɔ kiiya kitiritan.” ");
INSERT INTO mur_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Marta, Marta. Kacinin ineet abaaban kaal ci meelik ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bar zin anyak gi codoi ṯɔr nɔkɔ ci titiny. Ojowa zin bar Meri gi ci titiny noko, ma akɔm bodo eet oma ci ka kaama nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma iitene oman ook Yesu ŋaryiin ŋaaman. Mazi akɔ odotiz ŋaryiinta, enek ɛɛti codoi nuyawe ogin nɔɔnɔ nɛ, “Manyi, demezeyet di buk ageeta ŋaryiin ci ka gɔɔn kaŋaruyoya kiyo baale adɛmɛz Jɔn o oonyi nuyak ogin e.” ");
INSERT INTO mur_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ma anek Yesu nuyak nɛ, “Gɔɔn mã aŋaryinu, iziti nɛ, Baatinaaŋ o aavɛ tamma, anyek ɔl kidiŋdiŋanit zaar ugun. Anyek baliin unun kiiya. ");
INSERT INTO mur_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nyet gɔɔn iinya dook dayiin o karooŋnya. ");
INSERT INTO mur_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Toŋ baciinok ogaacak, kiyo kuuŋna kaal o abac ɔl ŋaatinaaŋ o. Má anyet ageet kicinawet Loryenti.” ");
INSERT INTO mur_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Enek ni bodo Yesu nɔɔgɔ nɛ, “Inoko mã akunak eet oma ŋaatunooŋ kernoiti, ma akɔm dayiin ɔlɔ, ma akɔ ole ci laŋotin baalin kɛŋa ka kook kijin nɔɔnɔ kenek nɔɔnɔ nɛ, Nyan di ḏɔkɛn ceen iiyu. ");
INSERT INTO mur_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kanyei eet ceen laŋo ci akunakan keronnya ona noko, ma akɔmnan dayiin ci kanyei ka kanyek. ");
INSERT INTO mur_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma abɛdɛkɛ laŋotinɛ ci ceeza o anek nɛ, Má amilanan. Onyoogɛ ceez, ma buk koota ki dɔl ooŋnyak. Alaŋaan bodo kanim kitiŋa ka kook kanyin gi ci arooŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Enek ni Yesu nuyak ogin nɛ, “Anycaŋ zin kuduwayuŋ. Yo nuun ma alaŋ iŋaaz niini ka kanyek nɔɔnɔ ḏɔkɛn giye o ɛɛnɛ laŋotin, akɔ nuun zɛɛ iŋaaz, ma anyek nɔɔnɔ ḏɔkɛn ci ona arɔɔŋ o giye o alaŋ anyayi niini alyaan, ma amɛna ilalɛkɛ nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Didilɛ kaduwakuŋ igeet, ijintɔ, ŋaan anyononekuŋ. Ɔrɔɔŋtɔ, ŋaan ajowanu. Ɛtɛrɛnit karogi, ŋaan akolonekuŋ. ");
INSERT INTO mur_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Eeci ɛɛti ci ajine, anyononek. Ma ɛɛti ci arooŋnyi, ajowa. Maje ɛɛti ci atɛrɛn karogi, akolonek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ŋɛnɛɛn inoko ŋaatunooŋ ci mã ajin ŋɛɛrin kulugit, bar anyek kowat? ");
INSERT INTO mur_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Karabɔŋ ajin niini nɔɔnɔ iira, ma bar anyek kitɔ? ");
INSERT INTO mur_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mayo nuun eeginu niiga gɛrzɛ o, agayu kaal o abon anyeku dɔl ugoocok nɔkɔ. Bar zin baatina o aavi tamma abon niini ɔrɔɔt kujukuŋ igeet, ma anyek niini Vɔŋiz onin ɔl o ajin nɔɔnɔ dook.” ");
INSERT INTO mur_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma iitene oman aara Yesu miniŋit ci Loryento alagony eet oma aat. Mazi aduŋna miniŋiti nici ɔzɔɔz ɛɛti nici bodo labak, ma abiir ɔl dook ooti tɛt. ");
INSERT INTO mur_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma bar anɔ ɔl ogɛnɛ ŋaatineeŋ nɛ, “Anyek nɔɔnɔ dɔyiz ci aaranɛ miniŋ noko alaani o loryenu kazi Baalzibol.” ");
INSERT INTO mur_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Maje ɔl ogɛnɛ arɔɔŋ kicinta Yesu. Ma ajin niigi nɔɔnɔ kutugu gi ci atɛɛt ɔl biye ci aku tammu tadena. ");
INSERT INTO mur_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Maje Yesu aga baabaninok cigeec o nɔkɔ, ma anek nɔɔgɔ nɛ, “Gɔɔn mã aŋɛrɔ ɔl ci looc codoi nɔkɔ kiziti boryok, ma ɔɔrɔ niigi maany, uulali lɔɔci nici. Buk mã aŋɛrɔ ɔl ci tatok codoi, ma ayɔwɔ niigi maany, danydany tatok nici. ");
INSERT INTO mur_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Zin buk koca mã aŋɛrɔ baliin o Loryento, abil koca ku? Aziyu inoko niiga nɛ, Kaara naana miniŋ ci Loryento o dɔyize ci anyan Loryenti. ");
INSERT INTO mur_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mazi abil nɔkɔ, ma ɔl ugooc gɔɔn buk aara miniŋ o Loryento o, ajowa niigi dɔyiz nico naa? Anycek di nɔɔgɔ ɛlɛ kabarizteyuŋ igeet zɔɔz nico. ");
INSERT INTO mur_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bar zin mã kaara naana miniŋ ci Loryento o dɔyize o Joowo, iiyayuŋ zin ri koca igeet baliin o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gɔɔn mã ooŋek ɛɛti ceen ole kɔrɔk cin dilanyai, ɛɛl kaala ci kɔrɔk cin o juruŋ kɔkɔm gi ci gɛr akunak. ");
INSERT INTO mur_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mazi akunak nɔɔnɔ ɛɛti oman ci adɔi kujuk nɔɔnɔ, ma iiya omogun nɔɔnɔ, aama nɔɔnɔ dilanya cigin gɔɔn abɛyi ɛlɛ o dook, ma akɔ aŋerek kaal ci ona aama nɔɔnɔ o dook ɔl ogin. ");
INSERT INTO mur_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mazin ɛɛti calaŋ aavi libire can, amarninan niini aneet. Buk ɛɛti calaŋ atiritan niini aneet kolota aza ogan, azaan niini nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zin gɔɔn ma aduŋna miniŋiti o Loryento eete oman, awɔ akɔ balala ŋaati adɔyi akɔm maam ka kook kɔrɔɔŋ ŋinti ayubzi ŋinaante. Mazi alaŋ ajowa ŋinti ayubzi ŋinaante, anek ɛlɛ maany nɛ, Nyan kimiire kook eete baal kooŋnei looc e. ");
INSERT INTO mur_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Mazi abada, aku ajowa eet nico abil kiyo ceez o aviilyai kitiliza, ma akɔm ririny kɛŋa o. ");
INSERT INTO mur_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ma adun bodo niini akɔ bitaala, ma akɔ anyaa miniŋ ci Loryento oogi ceen torgɛrɛm ci gɛr ɔrɔɔt bar kujukit nɔɔnɔ, ma avu abaak eete nico. Ma uulali ɛɛti nici kizi gɛrzɛ ɔrɔɔt kujuk baale.” ");
INSERT INTO mur_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mazi ŋaan aduwa Yesu kaal nicoko nɔkɔ, ɛgɛrɛny ŋaa oman kɔlɛ kɔrgɛna ŋina enek Yesu nɛ, “Amayuk bai Jooi momu o yaatun baal anyakin ineet e kibeen keezin ogin baal iroktanin ineet e.” ");
INSERT INTO mur_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bar abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Akɔm. Amayuk bar Jooi ɔl o azii zɔɔz onin, ma azooni.” ");
INSERT INTO mur_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mazi ŋaan aliya kɔlɛ Yesu nɔkɔ, enek niini nɔɔgɔ nɛ, “Gɛrzɛ ɔl ci ɔɔ nico noko ɔrɔɔt ɛlɛ. Arɔɔŋ niigi kutuguwek naana nɔɔgɔ gi ci atɛɛt biye ka kagayan kakun Joowa. Akɔm zin gi oma ci kagoonei nɔɔgɔ been nɛɛn. Dooke coma kagoonei nɔɔgɔ gi ci abil kiyo baal agoononek nyakaŋan o kazi Jona. ");
INSERT INTO mur_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Zin kiyo buk baale Jona een bayen ci ɔl o Ninava e, buk tiŋeere naana Ŋɛɛrti Eeto ŋaan keen bayen ci ayelzonek ɔl ci ɔɔ nico noko. ");
INSERT INTO mur_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tiŋeere iitene ci roonnyo e iŋaaz ŋaa ween alaan baal agam looc o akɔ ki tɛnɛt e, ma akɔlak ɔl ci ɔɔ nico noko rooni giye baal itiŋawi niini, ma awɔyi ŋinti wun ka kook kicin gɛnyiz o alaan o kazi Solomon e. Bar zin inoko ŋina aromenu niiga ki eet ci adiŋdiŋ kujuk Solomon. ");
INSERT INTO mur_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tiŋeere buk iitene ci roonnyo e iŋaaz ɔl o Ninava, ma akɔlak ɔl ci ɔɔ nico noko rooni Joowo, eeci baale niigi iziiyit uuwayi o Jona, ma abadit mony baciinowe ugeec. Bar zin inoko niiga ŋina aromenu ki eet ci adiŋdiŋ ɔrɔɔt kujuk Jona.” ");
INSERT INTO mur_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ma azi Yesu bodo nɛ, “Akɔm gɔɔn laadun eet ci atokol lamba, ma arek ŋinti abiilɛnɛ. Bar arek ceez kɔrgɛn ka kataraan looc ka kicintɔi ɔl ci avunak ceez o juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ma kɛbɛrɛ tokolec ci alyo gi. Mã abon kɛbɛrɛ cugune o, aavi buk ɛlɛ cune o dook vooritina. Mazi een ruben, buk ɛlɛ cune o dook aavi muur. ");
INSERT INTO mur_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Egenyit zin ɔrɔɔt. Gɛrzɛ ŋaan ookci vooritin ci aavi eleetine cugooc o kizi muur. ");
INSERT INTO mur_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mã adaala ɛlɛ cun o dook vooritin kɔkɔm ŋinti miliny aavi muura, atokoli koca ɛlɛ cune o dook juruŋ kiyo gɔɔn ataranet lamba vooritine onin o.” ");
INSERT INTO mur_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mazi odotiz Yesu zɔɔza, otowo ɛɛti ceen Pariciwen nɔɔnɔ ka kook kadaktɔ kibeen nɔɔnɔ ɔlɔ. Ook ni Yesu aavu loota ɔlɔ ɛrɛwa dayiin calaŋ oony azɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mazi akɔ acin ɛɛti ceen Pariciwen noko Yesu adaki iŋaan kotoony azɛɛn, ibiir nɔɔnɔ ɔɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Enek ni Manyi Yesu nɔɔnɔ nɛ, “Gɔɔn niiga ɔl ci Parici o uunyu diicit kibeen kodoocɛ ugooc bawuci doon, maje bar igeet ɛlɛ gɛrzɛtɛ zinzeeti cugoocok o eecitɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Eeginu niiga aliyak. Alaŋ agayu ɛlɛ bitaala kibeen ɛlɛ eecitɔ ɛɛnyca dook Jooi o? ");
INSERT INTO mur_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Anycek zin gɔɔn ɔl o amaat gi ci tɛ olla anyaku, ka kitiliza kaala ugooc dook. ");
INSERT INTO mur_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Izi nɔŋa cugoocok wole igeet ɔl o Parici. Gɔɔn niiga aruweku Jook lɛlɛn codoi lelene ween amɔtɔ yo nuun een kaale o cɛlbɛz labak kiyo abutɛna kibeen ŋooru o kibeen buk kaal o cɛlbɛz mana dook. Ma bar apezu ŋaati agoonu kaal keelit tɔp, ma buk apezu reezinɛt o Joowo. Abon zin waan buk agoonu kaal nicoko. ");
INSERT INTO mur_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Izi nɔŋa cugoocok wole igeet ɔl o Parici. Eeci gɔɔn areezu niiga ŋaati aavtiyu lecerene o titiny ceezine o lotento. Ma arooŋnyu buk kazaayuŋ ɔl igeet titinyɔnta golowɛ dook. ");
INSERT INTO mur_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Izi nɔŋa cugoocok wole, eeci eelnu niiga kiyo looknya o adawin ɔl o adaai, ma abuŋe loota calaŋ ɔl acin, ma avu arɔc niigi ŋaati awɔyi labak o.” ");
INSERT INTO mur_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ma anek ɛɛti codoi ole o gɔɔn ademzek ɔl lotinok nɔɔnɔ nɛ, “Alaan o demziinto, zoozowe ci aduwa noko adomnyet ri buk ageeta.” ");
INSERT INTO mur_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Ŋɛdɛt buk izi nɔŋa cugoocok wole igeet ɔl o ademzeku ɔl lotinok. Anyeku gɔɔn niiga ɔl kaal ci adiŋdiŋ kitikit, ma alaŋ buk niiga alya eleetine ugooc atiritu nɔɔgɔ kaale ci adiŋdiŋ anyak niigi o. ");
INSERT INTO mur_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Izi nɔŋa cugoocok wole igeet ɔl o ademzeku ɔl lotinok. Adimanu gɔɔn niiga looknya o nyakaŋanɛt baal adaayitɔ e kitiliza bodo. Maje nyakaŋanɛt nicoko ɛlɛ jijitugooc nɛɛn o aruk nɔɔgɔ kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mazin buk niiga alya eyelizawu gi o areezu kaal baal agɔɔn jijitugooc giye baal aruyi niigi nyakaŋanɛt kadaayitɔ e, maje bodo niiga inoko eenyceku nɔɔgɔ looknya. ");
INSERT INTO mur_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma zin giye nico azi Jooi gɛnyize onin nɛ, Kitoonei tiŋeere nɔɔgɔ nyakaŋanɛt ki toonnyak nɔkɔ, ma avɔ aruk niigi oogi ŋaatineeŋ kadaayitɔ, maje coko agit. ");
INSERT INTO mur_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Akeebonek zin tiŋeere ɔl ci ɔɔ nico noko biyeta o nyakaŋanetu baal aḏuuti ŋinbaal ɛɛnycan lɔɔci e zɛɛ been inoko o. ");
INSERT INTO mur_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Akanai biyete o Abel zɛɛ been biye o Zakeriya baal amony ɔl nɔɔnɔ ceeza tɔ ŋaao aŋɛrɔn ŋino taabinto been ŋino Joowo alile e. Didilɛ kaduwakuŋ igeet, akeebonek ɔl ci ɔɔ nico noko biyeta ci ɔl nicoko dook. ");
INSERT INTO mur_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Izi nɔŋa cugoocok wole igeet ɔl o ademzeku ɔl lotinok. Anyozeyuŋ gɛnyizi o Joowo igeet, ma bar alaŋ arooŋnyu niiga alya agamta, ma buk araŋraŋanu ɔl o arɔɔŋ kagaac gɔl o Joowo calaŋ avu.” ");
INSERT INTO mur_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Mazi odotiz Yesu kaale nicoko, odomta ɔl o Parici kibeen ɔl o gɔɔn ademzek ɔl lotinok o Joowo otoŋomit nɔɔnɔ gɛrzɛ. Ma ajin niigi nɔɔnɔ kaal ci meel gɛr, eeci arɔɔŋ niigi kalabta nɔɔnɔ ka mã aduwa zɔɔz ci gɛr ka kojokta gɔl ci agami. ");
INSERT INTO mur_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ma enice ɛlɛ olotak kɔlɛ ci meel gɛr Yesu kook zɛɛ ma ajukɔ. Ma arayek Yesu nuyak ogin gi ci anek nɛ, “Edeya eleeti ole o Parici, eeci gɔɔn niigi alaba ɔl giye o anyekɛ eleeti kizi ɔl ci abon, maje ŋaato gɛrzɛ. ");
INSERT INTO mur_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ma kaala o inoko abuŋe dook katin akɔlyai. Buk kaala o inoko aŋɔmtɛ dook katin ayelzai kiziiktɛ. ");
INSERT INTO mur_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma zin kaala o aduwanu niiga muura katin aziiŋnɛ vooritina. Buk kaala o aŋomteku niiga ɔl ceezinɛ eecitɔ katin abɔryai ɔl dook kebereca.” ");
INSERT INTO mur_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ma anek Yesu nuyak nɛ, “Laŋotigan, má aŋolinu ɔl o arukuŋ adaayit, ma bar vurte ci adaaktu, ɔkɔma bodo gi oma ci agɔɔn. ");
INSERT INTO mur_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bar zin kilotuŋ igeet. Otoŋole Jook o aruk ɔl kadaayitɔ, ma bodo vurta anyak dɔyiz ci ajukɛkɛ nɔɔgɔ goo o abil been nɛɛn. Kaduwakuŋ igeet, abon aŋolinu nɔɔnɔ doon. ");
INSERT INTO mur_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kaga naaga kibaali ceen zoot kaal ci labak, ma anim ɛɛti kataala ci een tur ŋaatineeŋ giricete ceen ram nɔkɔ. Ma akɔm zoote nicoko codoi ṯɔr ŋaatineeŋ ci areyek Jook. ");
INSERT INTO mur_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Má zin anyaku ŋoliin, eeci niiga adiŋdiŋnyu ŋume o Joowo ɔrɔɔt ujukit zoot ci meelik gɛr. Mayo nuun een im cugooc oowu noko ɛlɛ akɛɛp Jooi, ma aga dook.” ");
INSERT INTO mur_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ma anek Yesu nɔɔgɔ bodo nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti ci abɔra tuwɛn onin ɔl kebereca, tiŋeere buk naana Ŋɛɛrti Eeto kabɔra tuwɛn onin toonnyak o Joowo kebereca. ");
INSERT INTO mur_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Maje ɛɛti ci adaŋnyan aneet ɔl kebereca, buk tiŋeere naana Ŋɛɛrti Eeto kadaŋ nɔɔnɔ toonnyak o Joowo kebereca. ");
INSERT INTO mur_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mã anyak eet ci azoozan aneeta Ŋɛɛrti Eeto gɛrzɛ, aara Jooi ŋaatin oŋec nico labak. Mazi bar aduwak ɛɛti zɔɔz ci gɛr Vɔŋiz o Joowo, alaŋ Jooi aara ŋaatin oŋec nico been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ma anek Yesu nɔɔgɔ bodo nɛ, “Mã akɔlakuŋ ɔl rooni, ma avoyuŋ ole o ka kɔɔt kapaktuŋ igeet ceezine o lotento, karabɔŋ een alaate o adikir akumawo, má anyaki ŋoliin giye ci akati zoozok ci ka abarzek niiga nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Eeci Vɔŋizi o Joowo iiten nico ɛlɛ ayelzakuŋ igeet zoozok ci ka abarzek nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ma anek ɛɛti oman kɔla tɔ Yesu nɛ, “Alaan o demziinto, duwak da gɔtɔna ween abuu ka keŋereyan buk aneeta kaal o ooŋnaket baatinaaŋ.” ");
INSERT INTO mur_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Ineet logoz, ŋɛnɛɛn ci anyan aneet dɔyiz ci ka keŋerekuŋ ineet ki gotonu kaal o?” ");
INSERT INTO mur_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma anek niini nɔɔgɔ dook kɔla nɛ, “Egenyit zinzeeti appinzɛta, eeci rogɛti ween didi eete ci deer alaŋ abilna kaale ci meel arokzetu.” ");
INSERT INTO mur_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Uduwak ni Yesu nɔɔgɔ yabziin ci anek nɛ, “Anyak baale eet ceen aroi ɛɛva mana ŋaati abon akuvkuv, ma abiir juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Abaabanun ni niini doon gi ci azi nɛ, Mayo akɔmnan piimanɛ ci ka keteedek labi cigan noko o ka yo kutugu ku? ");
INSERT INTO mur_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ma vurta abaaban izi nɛ, Abon kooyoi piimanɛ ci miliny baal rɛɛn noko ka kɛtɛɛnya piimanɛ ci adikir ka keteedek labi, ma buk kiyaŋɛ kaal cigan noko dook. ");
INSERT INTO mur_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ka zin kenek ɛlɛ maany nɛ, Izɛ mɛr aroi. Anyawu kaalyan ci meel ɛɛl piimanɛn ci adicanɛ irkitok ci meel gɛr. Inoko zin yubuz, olla dawɔ, wodɛ. Anyek ziniz katalɔ. ");
INSERT INTO mur_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Enewun ni Jooi nɔɔnɔ nɛ, “Ineet aliyai nico. Inoko tedec baaline nico niina adaai. Mazin yo tedec kaala cugune ɛɛnɛ aroi noko akati ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma azi Yesu nɛ, “Zin yabziin nici akati ɔl o gɔɔn adɛz kaal ci ka kizitɔi arɔk, maje bar ŋume o Jooi alaŋ eegin arɔk.” ");
INSERT INTO mur_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ma anek Yesu nuyak ogin nɛ, “Inoko zin kanekuŋ nɛ, Má iinonu dayiin ci ka orogti, karabɔŋ een rumanɛ ci ka uburucek. ");
INSERT INTO mur_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Eeci rogɛti adiŋdiŋ ɔrɔɔt kujuk dayiin. Mã anyin Jooi ineet rogɛt, anyin buk dayiin. Buk ɛlɛ adiŋdiŋ kujuk rumanɛ. Mã anyin Jooi ɛlɛ, anyin buk rumanɛ. ");
INSERT INTO mur_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Icinit di walaaknya. Alaŋ gɔɔn niigi aḏowɛ, ma akɔm buk nɔɔgɔ labi ci ka keteedit. Alaŋ anyak niigi piimanɛ ci ka kiyaŋti labi. Bar olla adayiz nɔɔgɔ Jooi doon. Bar zin niiga eeginu titinyɛ ɔrɔɔt ujukit kibaali. ");
INSERT INTO mur_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ŋɛnɛɛn inoko ŋaatunooŋ ci anim kazaac rogɛt cin kizi wun kidicilim inonnya? ");
INSERT INTO mur_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mazin mã alaŋ animnyu utuguz gi ci miliny kiyo nici noko, anyeku zin zinzeeti kiinonit kaal oogi naa? ");
INSERT INTO mur_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Icinit di koroboli o too. Alaŋ niigi aliŋliŋ, ma alaŋ buk alolak eleeti rumanɛ. Kanekuŋ zin nɛ, Mayo nuun een alaan baal kazi Solomon e diŋdiŋonte onin, ŋaan kanyak rumanɛ ci alina kiyo gɔɔn koroboli o. ");
INSERT INTO mur_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jook zin nɛɛn o alinatan koroboli o too o aduŋna waanico, ma tiŋeere bar araabjai, ma atoozi gooya. Inoko zin ma alinatan Jooi nɔɔgɔ nɔkɔ o, ma zin bar koca igeet o eeginu titinyɛ ujukit koroboli, alaŋ amalikuŋ niini igeet rumanɛn buk? Kidic zin igeet tuwɛn ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Má zin gɔɔn iinonu kaal ci ka adayit, karabɔŋ een kaal ci ka owodit. ");
INSERT INTO mur_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Eeci nici dook kaal o gɔɔn iinon ɔl o loocu alaŋ atuwe nɛɛn. Mazin baatunooŋ o aavi tammu tadena aga kaal o arooŋnyu niiga dook. ");
INSERT INTO mur_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bar zin rak ɔɔwa aryek zinzeeti baliin o Joowo doon, ŋaan kaala nici dook anyononekuŋ igeet buk. ");
INSERT INTO mur_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nuyak ogan, má anyaku ŋoliin gaga, eeci baatunooŋ o aavi tamma anyuŋ igeet baliin onin talniinta. ");
INSERT INTO mur_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Inoko ɔɔtɔ ataaltɔi kaal ugooc anyaku dook, ka odomta guruc ci ataalanu o itiriti ɔl o amaat, ka ɔrɔɔŋtak niiga eleeti arɔkzɛt o abil kodot, iyaŋtek eleeti arɔkzɛt tammu tadena ŋaao ɛɛlni calaŋ akoloni. Eeci ŋinaante akɔm agoryai ci ka kɔgɔrɔz, ma akɔm buk zizaac ci ka kadayit. ");
INSERT INTO mur_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eeci ŋino iyaŋin arɔkzɛt unooŋ, ŋino buk aavtiyɛ zinzeeti ugooc nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iziti vililɛ tup giye ci tɛ olla akunakuŋ igeet. Uburucek rumanɛ. Acapta tɔɔlit akatek katalanyit. Eelit kiyo gabara o arɛ alaan uneeŋ ka kabada keronnya o, ka ma aku niini, ma atɛrɛn karogi, akolek niigi nɔɔnɔ karogi enico ɛlɛ o. ");
INSERT INTO mur_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Didilɛ kaduwakuŋ igeet, atalnɛ koca niigi ɔrɔɔt ɛlɛ ŋaati akuni alaani uneeŋ, ma amada nɔɔgɔ vililɛ areyi calaŋ oogin. Awa koca niini nɔɔgɔ, ma anyek kaavtiyɔ loota, ma anyek dayiin. ");
INSERT INTO mur_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Amayuwi zin niigi ŋaati amadan alaani uneeŋ nɔɔgɔ vililini, mayo nuun abada niini baalin kɛŋa karabɔŋ een ooŋtalizo. ");
INSERT INTO mur_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Abon aadanu gi ce. Gɔɔn kizi gi ci aga ɛɛti ci korgu iiten ci ka kiiyakɛ agoryaiti kɔrɔk cin o, alaŋ koca ooŋnek kɔrɔk looc ka kiiya kook agoryaiti ceeza gorziin. ");
INSERT INTO mur_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iziti zin buk niiga vililɛ nɔkɔ, eeci iima naana Ŋɛɛrti Eeto katorobanuŋ igeet calaŋ agawanu iiten ci kakunɛ.” ");
INSERT INTO mur_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ma anek Pitɔr Yesu nɛ, “Manyi, ma dim yabziin nici akanet ageeta doon, yo akati da buk ɔl dook?” ");
INSERT INTO mur_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ma abɛdɛkɛ Manyi Yesu nɔɔnɔ anek nɛ, “Inoko ŋaatun ŋɛnɛɛn ci een gabaren ci agɛny aliŋliŋ juruŋ o? Gabaren ci agɛny nɛɛn o aŋɛra alaani oninɛ nɔɔnɔ kizi gabaren ci adikir ceeze onin, ka keŋerek gabara o miliny dayiin ugeec juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amayuwi zin gabarɛnti nici ŋaati abadaan alaani oninɛ keronnya, ma amada nɔɔnɔ agɔɔn gi nico. ");
INSERT INTO mur_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Didilɛ kaduwakuŋ igeet, koca enico anyek alaani gabaren nico kagamek nɔɔnɔ kaal ogin dook ka kozooti. ");
INSERT INTO mur_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mazi bar abaaban niini gi ci azi nɛ, Amɔn rak tiŋeere alaani onane ŋinaante ŋinti rɛɛn calaŋ abada kataman, ma adoma agit gabara ci miliny ŋaatin o, ma adak dayiin dook niini doon, ma awodɛ ma abaaki. ");
INSERT INTO mur_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Abada koca alaani cinɛ o iitene calaŋ niini agawan kuni cin o, ma aku aruk nɔɔnɔ, ma atɔɔk liŋliŋonte onin, ma apayek nɔɔnɔ gerzitin ci ɔl o alaŋ atuwe. ");
INSERT INTO mur_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ma gabarɛnti ci aga gi o arooŋek alaani oninɛ nɔɔnɔ kutugu, ma bar alaŋ arɔɔŋ niini kizi vilil kutugu eo arɔɔŋ alaani oninɛ, arooki koca niini ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maje gabarɛnti calaŋ aga gi ci arooŋek alaani oninɛ nɔɔnɔ kutugu, ma bar buk agɔɔn gi ci aganɔn niini ki rooyinɛt, arooki buk niini kidicilim. Ma ɛɛti ci anyonek nɔɔnɔ kaal ci meel, arooŋnyi buk ŋaatin kaal ci meel. Maje ɛɛti ci anyonek nɔɔnɔ kaal ci meel ɔrɔɔt ɛlɛ, arooŋnyi buk ŋaatin kaal ci meel ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kakun zin naana o ka kiiya kakatek looc goo. Bar zin abon waan liŋliŋɔni nici inoko akatai odota. ");
INSERT INTO mur_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Anyak piryakzɛt ci appe ɔrɔɔt akunakan aneet. Kanyonei zin tiŋeere naaga piryakzɛt nico nɔkɔ zɛɛ ma kadica imin. ");
INSERT INTO mur_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Bar bɔŋ niiga abaabanu kizik kanyaai naana looc ganɔn? Alaŋ zin kanyaai looc ganɔn, bar kanyaai looc ŋeriin. ");
INSERT INTO mur_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akatai zin bar inoko o ɛlɛ, ma een ɔl ceeza tur, aŋɛrɔ ceen iiyu amarnin gɔnɔgi ceen ram o. Adoma ceen ram o amarnin gɔnɔgi ceen iiyu o. ");
INSERT INTO mur_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maje gɔɔn ɛɛti tiŋeere amarnin ŋɛɛrin. Buk logoti amarnin baatin. Maje ŋaa tiŋeere amarnin bɛɛnyin. Buk dole amarnin yaatin. Maje inyik tiŋeere amarnin alawan onin. Buk alawani amarnin inyik.” ");
INSERT INTO mur_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ma anek Yesu bodo ɔl nɛ, “Gɔɔn mã acinu diizoc libire ci jenu o anonu nɛ, Atiil tedec tammu. Ma didi atiil. ");
INSERT INTO mur_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Buk mã akɔla ŋɔɔti ci libir ci jenu o, anonu nɛ, Abur tiŋeere lɔɔci. Ma didi abur. ");
INSERT INTO mur_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Izitu mɛr niiga ɔl ci abuuku eleeti. Acinu gɔɔn niiga looc kibeen tammu taden, ma aganeku ŋaati aduwanu keŋti ci kaal cigeec. Mazin buk alaŋ agayu keŋti ci kaal ci agooni inoko o naa? ");
INSERT INTO mur_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Alaŋ zin aŋɛraku eleeti kaal ci abon ka utuguz naa? ");
INSERT INTO mur_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mã anyak eet ci akɔlakin rooni, abon akɔ ŋaatin ka ɔɔt idica ki nɔɔnɔ zɔɔz nico iŋaan urumit alaan o roonnyo. Gɛrzɛ ŋaan apayekin alaani ineet cabiin, ma avɔ ajukekin takirnya sijin. ");
INSERT INTO mur_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Didilɛ kaduwakuŋ igeet, alaŋ koca aduŋna niina ŋinaante kataman, ma aavɛ nɔkɔ zɛɛ ma arui guruc o apawonekin ineet dook.” ");
INSERT INTO mur_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma iitene nice ɛlɛ ivita uduktak ɔl ogɛn Yesu gi ci akati ɔl o Galili baal aruk alaani o kazi Pailat kadaayitɔ iitene baal ataabi niigi Jook e. ");
INSERT INTO mur_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Yo abaabanu niiga aniyu nɛ, Adaai ɔl ci Galili neke o giye ci da anyayi niigi oŋɛ ɔrɔɔt kujukit ɔl ci Galili ŋaan arogi noko dook? ");
INSERT INTO mur_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Akɔm kina! Didilɛ kaduwakuŋ igeet, mã alaŋ niiga ateedinu oŋɛ ugooc, adaaŋnu buk tiŋeere niiga dook kiyo baale adaai niigi e. ");
INSERT INTO mur_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Aada di buk zɔɔz ci ɔl ween amɔnki turge baal iinak nɔɔgɔ ceez ŋaao kazi Siloom, ma aruk nɔɔgɔ kadaayitɔ e. Abaabanu niigi kizik iinak baale nɔɔgɔ ceez kuruk kadaayitɔ o, eeci gɛrzɛ niigi doon kujukit ɔl o abaak Jerusalɛma dook? ");
INSERT INTO mur_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Akɔm kina! Bar zin kaduwakuŋ igeet, ma alaŋ ateedinu niiga oŋɛ ugooc, adaaŋnu buk koca tiŋeere niiga dook kiyo baale niigi e.” ");
INSERT INTO mur_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Enico uduwak Yesu nɔɔgɔ yabziin ci anek nɛ, “Baale anyak ɛɛti oman kɛɛt ceen moneec mane cin. Ma iitene oman ook niini arɔɔŋ ka kook kodoca, mã anyak monɛn ci abiirna. Mazi akɔ arum kɛɛt, bar ajowa akɔm kɛbɛrɛ ci abiirna kina. ");
INSERT INTO mur_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Enek ni niini eet o gɔɔn abeyek nɔɔnɔ mana nɛ, “Cin di! Kanyei irkitok iiyu ci gɔɔn kakunakɛ kɛɛt nico ka waan kiiya kodoca kɛbɛrɛ ci abiirna, ma bar akɔm ci kajowa kina. Inoko zin tɛɛdak looc, eeci olla ɛɛŋ mana gaga, ma buk uulal tɔdɔ ci ŋinti aavɛ niini o kizi gɛrzɛ.” ");
INSERT INTO mur_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ma abɛdɛkɛ ɛɛti o abeyek nɔɔnɔ mana anek nɛ, “Manygɔn, toŋɔ rak di labak kidica irkit nico doon, ka kɔwɔlɔny tɔdɔ kocodek cɔlɔ coma akuvkuv. ");
INSERT INTO mur_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mã zin tɛ abiir irikite ci aku noko, abon ɔrɔɔt. Bar má alaŋ abiir, ŋaan zin koca enice atɛɛdai looc.” ");
INSERT INTO mur_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma iitene oman ook Yesu ɛdɛmɛz ɔl ceeze o lotento iitene o yubzento een Sabit. ");
INSERT INTO mur_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Maje ŋinaante anyak ŋaa ci anyak miniŋit ci Loryento alya ci anyek nɔɔnɔ kɔmɔɔr irkitok amɔnki turge. Makacin uduulun ŋaa karatot kogomgom calaŋ azɔlani kɔtɔɔ tɔp. ");
INSERT INTO mur_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Mazi acin Yesu nɔɔnɔ, otowa, ma aku anek nɛ, “Ineeta ŋaa nico, urugu niina mɔɔrize cun noko.” ");
INSERT INTO mur_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma ataadek nɔɔnɔ azɛɛn. Enico ɛlɛ ɔzɔlanɛ ŋaa karatot oninɛ ibil tɔp, ma anaat niini Jook ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mazi acin alaani o ceez o lotento gi nico, otobor nɔŋ, eeci arogoz Yesu ŋaa nico iitene ci yubzento een Sabit o. Ma azɔɔz niini anek ɔl nɛ, “Kanyak gɔɔn laadun naaga iinya tɔrkɔnɔm ci aganɔ ki liŋliŋɔn. Abon zin gɔɔn anyaanu niiga moorizok cugooc o iinyaye nicoko ŋaan avu arogzenu. Alaŋ abon ŋaati avunu iitene ceen Sabit o.” ");
INSERT INTO mur_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma abɛdɛkɛ Manyi Yesu nɔɔnɔ anek nɛ, “Izitu mɛr niiga ɔl ci abuuku looc. Inoko gɔɔn ŋaatunooŋ ŋɛnɛɛn calaŋ aboroc taŋ cin karabɔŋ een zigir cin ka kook kowodoz iitene ceen Sabit o? ");
INSERT INTO mur_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Inoko ŋaa nici dole ci dɔl o Ibrayim buk, ma acap Loryenti nɔɔnɔ irkitok ceen amɔnki turge noko dook. Mayo zin gɛrzɛ ŋaati ɔɔgjanɛ niini iitene ceen Sabit noko?” ");
INSERT INTO mur_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mazi azi Yesu nɔkɔ, aamun ɔl o amarnin nɔɔnɔ dook alyaani. Maje ɔl ceegi dook atalnɛ kaale o abon agɔɔn niini ŋinaante dook. ");
INSERT INTO mur_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ma ajin Yesu nɔɔgɔ anek nɛ, “Mayo baliin o Joowo atobɔ ki gitaz? Kayo kotobozek gi jaŋ? ");
INSERT INTO mur_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Atobɔ zin kibeen keberec ci motoŋtoco aduŋna mana o. Ma iroktai zɛɛ makacin izi kɛɛt ci adikir ɔrɔɔt ɛlɛ, ma ɛɛnyɛt kibaali ceezi kɛɛt nico otonɛ.” ");
INSERT INTO mur_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bodo ajin Yesu nɔɔgɔ anek nɛ, “Mayo baliin o Joowo atobɔ ki gitaz? Kayo ka kotobozek gi jaŋ? ");
INSERT INTO mur_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Atobɔ zin niini kibeen nyigit o telawu gɔɔn adɔŋca ŋaa jayitote ci miliny tɛr, ma arurek tela, makacin ɛtɛdɛwi tela we dook komokcar o.” ");
INSERT INTO mur_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ɔtɔɔ ni Yesu, ma akɔ azɔp kuturyok o adikir ki o miliny, ma adɛmɛz rak ɔl ŋinaante ŋaati akɔyi ki Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma ajin ɛɛti oman nɔɔnɔ anek nɛ, “Manyi, mayo bɔŋ katin ɔl ci arogzɛ kidicɛ tɛr?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, ");
INSERT INTO mur_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ooritnɔŋ ɔrɔɔt ka coma avoyu tatoge ci lodoci noko eecitɔ. Didilɛ kaduwakuŋ igeet, tiŋeere ɔl ci meel gɛr ataman gɔl ci arɔɔŋ kooti tatoge nico eecitɔ, bar alaŋ anim kɔɔtɔ nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eeci tiŋeere iŋaaz ɛɛti o ceezu, ma anyook ceez. Mazi avu aruku niiga karogi, ma aneku nɔɔnɔ nɛ, Manyi, koleyet da ceez, bar abedekuŋ niini igeet anekuŋ nɛ, Alaŋ kagayuŋ. Ma niiga eeginu ɔl ci avunu ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Maje bodo niiga aneku katin nɔɔnɔ nɛ, Ageeta baal gɔɔn kadake, ma kawodɛ ki ineet e. Buk gɔɔn baale adɛmzɛ niina kuturyowe ogaacak. ");
INSERT INTO mur_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Abedekuŋ bodo katin niini igeet anekuŋ nɛ, Alaŋ kagayuŋ naana igeet. Avunu ŋaaḏaŋ? Ɛnyɛktɛ ŋaatan niiga dook o agoonu oŋɛ. ");
INSERT INTO mur_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Utuluzu ni katin niiga ɔrɔɔt ɛlɛ zɛɛ ma adaku nyigit ŋaati acinu niiga Ibrayim, ki Aizak, ki Jakob, been nyakaŋanɛt dook ŋaati aavtiz niigi baliinte o Joowo. Maje niiga atoowoneku bitaalin. ");
INSERT INTO mur_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Alotai katin ɔl libire ci jenu e, kibeen libire ci nyagjo o, ma libire ci baatikeri o, kibeen libire ci tɛnɛtu o, ma avu aavtiz niigi dook loota baliinte o Joowo. Ma azɔl ki nɔɔnɔ dayiin ŋaatodoi. ");
INSERT INTO mur_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Zin enice ɔl o inoko araki amiiri kiziti vurut. Maje ɔl o inoko eegin vurut, bar araki kiziti ɔɔ.” ");
INSERT INTO mur_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma iitene nice ɛlɛ ivitak ɔl ogɛnɛ ole o Parici Yesu, ma avu anek nɛ, “Tɔ ŋina. Bitɔ ŋaaman, eeci arɔɔŋ Erod kuruyin daak.” ");
INSERT INTO mur_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ɔɔtɔ enektek kireer nice nɛ, Kaara miniŋ o Loryento ɔla, ma buk karuguz ɔl moorizowɛ waanico kibeen tiŋeere. Ma iitene ceen iiyu e kidica naana liŋliŋɔn onan. ");
INSERT INTO mur_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Maje rak waanico ki tiŋeere kibeen tiŋeere ece kazobi looc kagoon liŋliŋɔn onan, eeci alaŋ aganɔ ŋaati aruwɛn nyakaŋani ŋaaman dooke coma aruwe Jerusalɛma.” ");
INSERT INTO mur_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Izi ni Yesu nɛ, “Jerusalɛm, Jerusalɛm, uruwu niina nyakaŋanɛt kadaayitɔ, ma avacu buk ɔl o itoonakin Jooi ineet biyɛnɛ kadaayitɔ. Lak ci meel gɛr ci karɔɔŋɛ gɔɔn kanyabotai ɔl ugun kiyo gɔɔn alotek toloci jɔrɔ ogin kɛŋ o, bar zin niina ŋaan nyan kutugu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Inoko zin tiŋeere ceez cune noko ooŋnonek looc kizi lik. Inoko zin kaduwakuŋ igeet, akatai waanico alaŋ bai bodo acinaŋ aneet zɛɛ been iiten ci kabadanɛ e. Enice ŋaan aziyu nɛ, amayuk Jooi nɔɔnɔ o aku zaare ogin.” ");
INSERT INTO mur_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ma iitene ceen Sabit oman, ook Yesu korge ci alaan oma ci ɔl o Parici ka kook kadawɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Maje ŋinaante anyak eet ci iivez zɔɔna kibeen azɛɛn aavi nɔɔnɔ kɛŋa nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma ajin Yesu alaat o gɔɔn ademzek ɔl lotinok o Joowo kibeen ɔl o Parici anek nɛ, “Mayo gɔɔn lotinowa ogaac aziikneket korogozit ɔl moorizowɛ iitene ceen Sabit o, yo akɔm da?” ");
INSERT INTO mur_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bar olla ajaki niigi tiv, kɔkɔm gi ci abariz. Orogoz ni Yesu eet ci amɔɔr noko, ma anyek nɔɔnɔ kɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ma anek Yesu nɔɔgɔ nɛ, “Inoko ŋaatunooŋ ŋɛnɛɛn ci iinak dole cinɛ look, karabɔŋ een taŋ cinɛ iitene ceen Sabit, ma alaŋ ɛɛla kataman?” ");
INSERT INTO mur_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bodo buk ajaki niigi, kɔkɔm gi ci abariz. ");
INSERT INTO mur_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mazi acin Yesu ɔl ci ona avunak dayiin o aŋɛrak gɔɔn ceeni ɛlɛ ŋinti abon aavuzito nɔkɔ, uduwak nɔɔgɔ dook zɔɔz ci anek nɛ, ");
INSERT INTO mur_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Gɔɔn mã awekuŋ ɛɛti oman igeet dayiin korge cin, má rak avɔ aavtiyu vitɛnane o titiny gɔɔn aavtiyɛ ɔl o adiŋdiŋ. Eeci alaŋ agayu karabɔŋ tedec buk akunak ɛɛti ci titiny ɔrɔɔt kujukin ineet ŋinito. ");
INSERT INTO mur_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma aku anekin ɛɛti ci ona awanin o ineet nɛ, “Tiŋa di anyek eet nico kiiya kaavu ŋina.” Itiŋa ni niina kaamin alyaani ɔrɔɔt, ma akɔ aavɛ ŋaati cɛlbɛz. ");
INSERT INTO mur_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bar zin gɔɔn mã awuyuŋ ɔl igeet korgine cigeec, abon avɔ aavtiyɔ vitɛnane ci cɛlbɛz, ka mã acinuŋ ɛɛti ci ona awuyuŋ o, ka kiiya keneyuŋ nɛ, Laŋo, tiŋa je. Ija aavu ŋaati abon ce. Ka zin jowa niina ɛɛzɛt ole ci ona avunak dayiin o dook. ");
INSERT INTO mur_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Eeci ɛɛti ci atitiny ɛlɛ, bar acɛlbɛzani. Maje ɛɛti ci acɛlbɛzɛn ɛlɛ onin, bar akunak nɔɔnɔ titinyɔnti.” ");
INSERT INTO mur_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Enek ni Yesu eet ci ona awa nɔɔnɔ o nɛ, “Gɔɔn mã arooŋ towek ɔl dayiin, má awa ɔl ween laŋotugun, karabɔŋ een gotonogu, karabɔŋ een ɔl ween atenok, karabɔŋ een ɔl o abaawonu een arɔk. Eeci mã awa niina ɔl nicoko doon, awekin buk koca iima bodo niigi ineet dayiin korgine ugeec. Zin gole nico urukteyin niigi ineet ŋabolo ci dayiin cugun baal adak niigi korge cun o. ");
INSERT INTO mur_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bar zin gɔɔn mã arooŋ towek ɔl dayiin, abon awa ɔl o amaat, kibeen ɔl o rɛbrɛbik, ki ɔl o ŋɔɔlik, been ɔl o ruben. ");
INSERT INTO mur_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ka zin jowa niina mayuwɛnɛt Joowa, eeci niigi alaŋ anyak dayiin ci ka kurukteyin ineet. Bar zin ŋaan aruwekin ineet Jooi iitene ci katin iŋaani ɔl o abon daayiza e.” ");
INSERT INTO mur_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mazi azii ɛɛti codoi ole ci aavtiz loota o zɔɔz nico, enewun Yesu nɛ, “Amayuwi katin ɔrɔɔt ɔl o azɔl dayiin ŋaatodoi baliinte o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma anek Yesu nɔɔnɔ yabziinta nɛ, “Anyak baale eet ci arɔɔŋ kotowak kɔlɛ ci meelik dayiin korge cin. ");
INSERT INTO mur_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mazi akɔ acin niini kaal dook utuguze odota, itoonun gabaren cin ka kook kenek ɔl nɛ, “Ivita. Utuguze kaal dook odotita.” ");
INSERT INTO mur_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mazi bar akɔ aduwak gabarɛnti nɔɔgɔ nɔkɔ, aduwa niigi dook ŋaatineeŋ gɔɔn ceeni zɔɔz ci alam nɔɔnɔ. Azi ɛɛti ci oowu o nɛ, “Alaŋ kanim kook ŋinaante, eeci kanyei mana ci jɔr kataala. Karooŋ zin ka kook kicin. Ɛɛlawan ziiyeyan zɔɔz ci kaduwakin noko.” ");
INSERT INTO mur_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Azi bodo ceeni nɛ, “Kanyei arzɛn ceen amɔtɔ ci jɔr kataala ka gɔɔn kɛɛvtɔ. Inoko zin karooŋ kook kicinai keviin. Ɛɛlawan ziiyeyan zɔɔz ci kaduwakin noko.” ");
INSERT INTO mur_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Maje ceeni azi nɛ, “Jɔr ŋaan karɔcɛ. Alaŋ zin kanim kook ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Abada ni gabarɛnti iiya uduwak Manyi onin itoon nɔɔnɔ e zoozok nicoko. Mazi azii Manyi oninɛ itoon e zoozok nicoko, otobor nɔŋ ɔrɔɔt ɛlɛ, ma anek gabaren nɛ, “Dɔkɔny! Bitɔ towa ɔl o amaat, ki ɔl o ruben, been ɔl o ŋɔɔlik kivita.” ");
INSERT INTO mur_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kataman nɔkɔ ook utugu gabarɛnti eci ona aduwaki Manyi oninɛ nɔɔnɔ o. Ma aku bodo anek niini Manyi onin nɛ, “Koowa kotowa nɔɔgɔ, bar zin ŋaan amaac ceez ɔl nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ma anek bodo Manyi gabaren nɛ, “Bitɔ golowɛ kutur bitaala. Anyek ɔl kivita ka coma abitiz ceez can noko. ");
INSERT INTO mur_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Didilɛ kaduwakuŋ igeet, akɔm bodo eet codoi ṯɔr ole baal laadun kawo ɔɔwa e ci atar dayiin nicoko been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Ma iitene oman ɔrkɔr kɔlɛ ci appe kibeen Yesu. Ma gɔla ubuude niini, ma anek nɔɔgɔ nɛ, “Mã alam eet ci arɔɔŋ konowan aneet, abon ooŋ niini baatin, ki yaatin, ki ŋaa onin, ki dɔl ogin, ki dɔl o yaatin dook. Ma abon buk areyek nɔɔnɔ ɛlɛ oninɛ maany. ");
INSERT INTO mur_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eeci ɛɛti calaŋ arɔɔŋ niini piryakzɛt ŋaati anuyan aneet, alaŋ een niini nuyai can. ");
INSERT INTO mur_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Gɔɔn mã arɔɔŋ ɛɛti kɛtɛɛnya ceez ci appe, aavi rak loota, ma akɛɛp guruc ci ka kɛtɛɛnyai ceez o, karabɔŋ alɛɛnɔ kidica ceez nico tɛɛnyinta. ");
INSERT INTO mur_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eeci mã aruwek niini ceez looc iŋaan kɛkɛɛp guruc ka kaga alɛɛnɔ kibeen enyciin, ma bar aruwek ceez looc, ma alaŋ anim kɛtɛɛny kidica, ararni koca ɔl dook nɔɔnɔ giye nico. ");
INSERT INTO mur_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Anɔ koca niigi nɛ, “Icinit di eet nico. Akana ceez tɛɛnyinta, ma bar ɔkɔmek alaŋaan adica.” ");
INSERT INTO mur_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Inoko mã anyak alaani takirnya ci meel (10,000), ma arɔɔŋ niini kooryɔ been alaan oma ci anyak takirnya ci meelik kujuk cigin o lak ram (20,000), aavi rak koca niini loota, ma abaaban zɛɛ ma aga gɔl ci ka kook kooryɔi kibeen alaan nice. ");
INSERT INTO mur_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mazi acin alaŋ anim kɔɔrtɔ kibeen alaan nice, itoonek koca niini nɔɔnɔ otok ŋinaante, ma ala nɔɔnɔ ganɔn iŋaan aavi niini rɛɛna o.” ");
INSERT INTO mur_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ma aṯornɛkɛ Yesu zooze ci azi nɛ, “Zin akɔm ŋaatunooŋ eet codoi ci anim kizi nuyai can, dooke coma ooŋ niini kaal ogin anyak dook giye can.” ");
INSERT INTO mur_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ma azi Yesu bodo nɛ, “Gɔɔn laadun mɛlɛ abon ŋaati ŋaan amokcarni, bar mazi idicai mokcarɔnti, izi gɛrzɛ, ma akɔm bodo gɔl ci kagɔɔni komokcar. ");
INSERT INTO mur_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma bodo alaŋ aganɔ ŋaati kagɔɔni kaal oogi been nɛɛn, bar agantɔ ŋaati kajukɛki tuu. Mã alam zin ŋaatunooŋ eet ci anyak iin, abon aziiŋnɛ juruŋ.” ");
INSERT INTO mur_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ma iitene oman ivitak Yesu ɔl o gɔɔn alot meeri kibeen ɔl o gɛr oŋenu ka kivita kiziiyit niigi kaal o aduwa niini. ");
INSERT INTO mur_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mazi avɔ acin ɔl o Parici kibeen ɔl o gɔɔn ademzek ɔl lotinok nɔɔgɔ ŋaati avunakɛ Yesu nɔkɔ, ɔtɔŋɔmtɔ izitɔ nɛ, “Icinit di eet nico ŋaati atalnan ɔl o oŋenu, ma buk azɔlɔ ki nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Uduwak ni Yesu nɔɔgɔ yabziin ci anek nɛ, ");
INSERT INTO mur_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ŋɛnɛɛn inoko ŋaatunooŋ ci anyak aza ceen eet tur, mazi akoloni codoi ŋaatineeŋ, alaŋ adotek ceen eet wec ki tiin tɔrkɔc o looc, ma akɔ arɔɔŋ ona akoloni e zɛɛ ma ajowa? ");
INSERT INTO mur_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Bar kanɛ akɔ arɔɔŋ nice zɛɛ mazi ajowa nɔkɔ, atalnɛ ɔrɔɔt ɛlɛ, ma adɔŋ inyaatinɛ akɔyi ɔlɔ. Mazi akɔ arum kɔrɔk nɔkɔ, awa laŋotigin kibeen ɔl o abaawɔ kivita ŋaatodoi, ma aku anek nɔɔgɔ nɛ, “Inoko katalnɛ ɔrɔɔt ɛlɛ, eeci kojowa azeet onan baal akoloni e.” ");
INSERT INTO mur_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, mã abad ɛɛti codoi mony oŋene ogin, ma abadaak Jook, appe buk koca talniin tammu tadena ɔrɔɔt ɛlɛ eete nico, kujuk ɔl ceen eet wec ki tiin tɔrkɔc ŋaan kabaca oŋɛ.” ");
INSERT INTO mur_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bodo anek Yesu nɔɔgɔ nɛ, “Inoko mã anyak ŋaa guruc ceen ziik een amɔtɔ, ma akoloz codoi ceez kɛŋa aje ceez muur, agɔɔn koca niini naagin? Bar kanɛ atokol koca goo, ma aviil ceez kidicilim, ma arooŋnyi juruŋ ceez kɛŋa dook zɛɛ ma ajowa. ");
INSERT INTO mur_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mazi ajowa nɔkɔ, awa laŋotigin kibeen ɔl o abaawɔ anek nɛ, “Katalnɛ ɔrɔɔt ɛlɛ, eeci kojowa gurucoc onan akoloni e.” ");
INSERT INTO mur_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Zin buk mã abad ɛɛti codoi mony oŋene ogin, atalnɛ koca toonnyawa tammu tadena nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma azi bodo Yesu nɛ, “Anyak baale eet ci anyak lɔgɔz ram. ");
INSERT INTO mur_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ma anek logoti ci miliny o baatin nɛ, “Baaba, karooŋnyin ŋɛrayan aneet kaal cigan inoko o.” Eŋerek ni baatineeŋ kaal nɔɔgɔ dook ramantiya. ");
INSERT INTO mur_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma iinyaye ci miliny nɔkɔ, ataalɔi logoti ci miliny o kaal cigin o dook zɛɛ adoma ni guruc ɔtɔɔwi, ooyi looce oman rɛɛna many. Ma ŋinaante ook iminaŋi guruc cigin noko rɛɛcanzɛta been kaale ogɛn. ");
INSERT INTO mur_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mazi adicai guruca dook, iiya tarjo ci appe looce nice, maje nɔɔnɔ ɔkɔma guruc ci anyak kina. ");
INSERT INTO mur_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Makacin ook iliŋliŋozek eet oma ole ci looc nice. Ma anyek ɛɛti nici nɔɔnɔ liŋliŋɔn ci oowawi kɔcɔcɔbanɛn. ");
INSERT INTO mur_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma giye o ɔkɔmai eet ci ka kanyek nɔɔnɔ dayiin ci abon, orooŋun niini ka nuun kook kozolit ki kɔcɔcɔbanɛn ayɛr. ");
INSERT INTO mur_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ma vurta abadaak niini ɛlɛ maany abaaban izi nɛ, Gɔɔn gabara o baaba anyak dayiin ci adak zɛɛ ma apiyani, maje bar naana ŋina ka kakaran ki magiz. ");
INSERT INTO mur_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Abon kiŋaaz kamiironei baaba ka kook kenek nɛ, “Baaba, kabaca oŋec Joowo kibeen ŋaatun buk. ");
INSERT INTO mur_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Alaŋ zin bodo kaganona ŋaati awuyan niina aneet kizi ŋɛɛrun, bar olla nyan kibil kiyo gabarɛnti o.” ");
INSERT INTO mur_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Itiŋa ni niini ɔtɔɔ imiirozek baatin. Mazi ŋaan awoya rɛɛna nɔkɔ, icinun baatinɛ nɔɔnɔ, ma ateedi baatin biyeta, ma iŋaaz adɔkɔny akɔ arumek nɔɔnɔ gɔl. Ma akɔ atorkot nɔɔnɔ azɛɛnɛ dook, ma acoco ŋalyamoc, eeci awucnek nɔɔnɔ ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bar anek logoti nɔɔnɔ nɛ, “Baaba, kabaca oŋec Joowa kibeen ŋaatun buk. Alaŋ zin bodo kaganona ŋaati awuyan niina aneet kizi ŋɛɛrun.” ");
INSERT INTO mur_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Maje bar baatinɛ awa gabara ogin, ma anek nɔɔgɔ nɛ, “Anyaakta rum ci abon ivita uburucɛkɛ ŋɛɛran. Buk artekɛ nyapokodec aziit. Uburucɛkɛ buk caava zɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mazi odot, ɔɔtɔ icinta ariz ceen mɔɔr adii ka kivita kotodoŋit kadayit kataltɔi. ");
INSERT INTO mur_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Eeci baale ŋɛɛran nici adaawa, bar zin inoko urugun bodo. Baale okolozɛ, ma inoko o, ojoyai bodo.” Ulute ni ɔl iitene nice ŋaatodoi, ma adake niigi dook talniinta. ");
INSERT INTO mur_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Maje logoti ween abuu iitene nice aavi mana. Mazi abadaak kɔrɔk, bar azii ɔl abene, ma arogom. ");
INSERT INTO mur_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Otowa ni niini gabaren codoi kɔrɔk bawuca, ma aku ajin anek nɛ, “Matɛ micit taz nici?” ");
INSERT INTO mur_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma abɛdɛkɛ gabarɛnti nɔɔnɔ anek nɛ, “Abada uyene gotonu kɔrɔk, ma atoŋdek baatune nɔɔnɔ ariz ci ŋaan een mɔɔr adii ɔrɔɔt, eeci abada niini kɔrɔk kɔkɔm gi ci gɛr.” ");
INSERT INTO mur_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mazi azii logoti ceen abuu o gi nico, otobor nɔŋ ɔrɔɔt calaŋ arɔɔŋ kiiyak kɔrɔk. Makacin iiyak baatinɛ nɔɔnɔ, ma ilalek ka kiiyak kɔrɔk. ");
INSERT INTO mur_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Enek ni niini baatin nɛ, “Cin di! Ŋaan baal kaliŋliŋonekin irkitok nicoko dook kiyo gabarɛnti o. Ma akɔm iiten codoi ci kajuranɛ been nɛɛn. Gitaz ci anyan niina aneet? Akɔ zɛɛ ma akɔmnekin ŋaati atoŋdekan bawot o colai ɔtɔgi ɛlɛ ka waan kadakta ki laŋotigan. ");
INSERT INTO mur_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mazi abada ŋɛɛrun ci baal akɔ adica kaal ugun waaŋnyai noko, otodoŋozeyu ni bar nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma anek baatinɛ nɔɔnɔ nɛ, “Dole onan, karomɛ naana been ineet ŋina iinya dook, ma kaala ci kanyei naana ŋina o dook kaal cugun. ");
INSERT INTO mur_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Maje gotonu nici baale adaawa, ma bar inoko urugun bodo. Baale okolozɛ, bar waanico ojoyai bodo. Abon zin bar katalnɛ naaga dook giye ci abadaket niini ageet o.” ");
INSERT INTO mur_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ma anek Yesu nuyak ogin nɛ, “Anyak baale eet ceen aroi ci anyak gɔn ci agamek nɔɔnɔ kaal cigin, ma bar aminaŋi ɛɛti nici kaal. Ma iitene oman uduyak nɔɔnɔ zɔɔz ci aminaŋi ɛɛti nici kaal cigin o. ");
INSERT INTO mur_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Otowa ni niini nɔɔnɔ, ma aku anek nɛ, “Gitaz ci kazii agoon noko? Inoko nyaayan waragɛ o gɔɔn ayɛɛdɛ kaal o agoon kibeen buk guruc ogan dook, eeci alaŋaan bodo aliŋliŋ ŋaatan.” ");
INSERT INTO mur_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Enek ni ɛɛti nici ɛlɛ maany baabaninta nɛ, “Inoko manyi cane kaliŋliŋonei noko orooŋun kɔtɔɔyan liŋliŋɔnta. Kayo zin kutugu gitaz? Akɔmnan dɔyiz ci ka kɛɛvɔi, ma bodo kanyei alyaan ŋaati kalawinɛ. ");
INSERT INTO mur_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Inoko kaga gi ci ka kutugu. Abon karɔɔŋa laŋotigan ci ka gɔɔn kataltawan korgine cigeec.” ");
INSERT INTO mur_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Enico ɛlɛ otowa niini ɔl baal gɔɔn anyayek manyi onin ŋabolɛt e. Ma aku ajin eet ci oowu o anek nɛ, “Anyayei manyi onan ŋabolɛt izɔk?” ");
INSERT INTO mur_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ma abɛdɛkɛ ɛɛti nici nɔɔnɔ anek nɛ, “Kanyayei topiyɛt ci zeetu een eet tur (100).” Ma anek niini nɔɔnɔ nɛ, “Orɛ zin waragɛ o ŋabolɛt ugun ce. Inoko tɛyɛɛt kizi eet ram kamɔtɔ (50) nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bodo ajin niini eet oma anek nɛ, “Anyei ŋabolɛt izɔk?” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Kanyei kaboot ci labinu een eet tur (100).” Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Orɛ tɛyɛɛt kizi eet wec (80) nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mazi acin manyi oninɛ nɔɔnɔ agɛny nɔkɔ, ataana niini nɔɔnɔ gɛnyize cin noko ɔrɔɔt ɛlɛ. Agɛny zin ɔl ci loocu noko ŋaati aromi zɔɔz cineeŋ kujuk ɔl o aavtiz vooritine o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Didilɛ kaduwakuŋ igeet, buk niiga o atuwenu abon anyaku gɛnyiz ci arɔɔŋaku eleeti laŋotizɛt Joowa kaale ugooc anyaku loota ŋina, ka mã adicai arɔkzɛt ŋina, atalnanuŋ niini igeet korge onin aavtiz kodot. ");
INSERT INTO mur_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mã ɛɛti ci atu ɔl nɔɔnɔ kaale ci miliny, atu buk ɔl nɔɔnɔ kaale ci meel. Maje ɛɛti calaŋ atu ɔl nɔɔnɔ kaale ci miliny, alaŋ buk atu ɔl nɔɔnɔ kaale ci meel. ");
INSERT INTO mur_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Zin mã alaŋ atu ɔl bonat cunooŋ kaale ci loocu cɛlbɛz noko, anyononekuŋ zin koca igeet katin arɔkzɛt ween didi Joowa ku? ");
INSERT INTO mur_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Buk mã alaŋ atuyuŋ ɔl igeet kaale ci eet oma, anyononekuŋ zin buk koca katin igeet kaal cugooc ku? ");
INSERT INTO mur_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Akɔm laadun eet ci aliŋliŋonek alaat ram. Mã agɔɔn nɔkɔ, arɛɛz koca codoi ŋaatineeŋ ɔrɔɔt, ma amarnin codoi. Karabɔŋ aŋole codoi, ma apɛz codoi. Zin gole nico alaŋ abon ŋaati kaliŋliŋonɛkɛ Jook, ma bodo kaliŋliŋ guruc.” ");
INSERT INTO mur_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mazi azii ɔl o Parici zɔɔz nico dook, atararti niigi Yesu, eeci arɛɛz niigi guruc ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ma anek Yesu nɔɔgɔ nɛ, “Anyeku gɔɔn niiga eleeti cugooc o kobonta ɔla, maje Jooi aga kaal o ɛɛl zinzeetine ugooc dook nɔkɔ. Mazin kaala o atitiny ɔl o deer, Joowa gɛrzɛ ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ma anek bodo Yesu nɔɔgɔ nɛ, “Aliŋliŋi baale ɔl lotinok o Mosis kibeen zoozok o ayɛɛt nyakaŋanɛta zɛɛ been iiten baal akuni Jɔn o oonyi e. Mazin iitene o iiyai niini e zɛɛ been inoko o kaviyawa o Joowo abon akati baliin onin uuwaktɛ, makacin ɔl ci meel ivita iyizek eleeti gɔl nico eecitɔ. ");
INSERT INTO mur_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bar zin katin aṯornɛkɛ tammu taden ki looc, maje lotinowa ɛɛl nɔkɔ kɔkɔm ŋintimiliny tɛr aarayi ŋaatineeŋ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mã atɔɔk ɛɛti ŋaa cin, ma bodo arɔca ŋaa oma, adoma koca niini zoocmaz. Buk mã arɔca ɛɛti ŋaa ci aaryai eete oman, adoma buk niini zoocmaz.” ");
INSERT INTO mur_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ma azi Yesu nɛ, “Anyak baale eet ceen aroi ci gɔɔn aborcek rumanɛ ci ataalyai guruce ci meelik ɔrɔɔt. Ma abaak niini baayiz ci amadi ɔrɔɔt iinya dook. ");
INSERT INTO mur_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Maje buk ŋinaante anyak eet ci amaat kazi zaar cigin nɛ Lazaros ci anyak dɔkizɛ alya. Anyaak gɔɔn ɔl nɔɔnɔ araan ci kɔrɔk ci eet ceen aroi noko, ka kiiya kɛvɛr zurzuryak ci iinak looc ŋaati adayin ɛɛti ceen aroi noko. Ma araana ŋina bodo gɔɔn aduk orze nɔɔnɔ dɔkizɛ cigin noko. ");
INSERT INTO mur_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ma iitene oman adaak ɛɛti ci amaat noko. Ivita ni toonnyawa o Joowo, ma avu avɔyi nɔɔnɔ ŋaao aavɛ Ibrayim tammu tadena. Bodo buk iitene oman adaawun ɛɛti ceen aroi noko, ma avɔ ada ɔl nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mazi akɔ aara niini kɛbɛrɛ, bar aavi gooye o ɔl o oŋenu, ma acin niini Ibrayim rɛɛna aromɛ kibeen Lazaros. ");
INSERT INTO mur_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Otowo ni niini Ibrayim anek nɛ, “Baaba Ibrayim, ɛɛlawan da. Anyekan Lazaros koconek komolit maam ka kiiya karekan aat, eeci kapirna ɔrɔɔt ɛlɛ gooye ci kaavɛ noko.” ");
INSERT INTO mur_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bar abɛdɛkɛ Ibrayim nɔɔnɔ anek nɛ, “Ŋɛɛran, baale irkitowe baal ŋaan arognɛ niina loota e, anyozeyin ineet kaala o abon dook. Maje Lazaros waanice ajowa kaal o gɛr dook. Inoko zin buk niini iiya ojowa looc madiz ŋina. Maje niina apirna piryakzɛt nico. ");
INSERT INTO mur_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Buk bodo ŋaati kaŋɛrɔn naaga been igeet noko anyak ŋolol ci wun kal ci aŋeryet ageet, ka mã arɔɔŋ ɛɛti ŋaatinaaŋ kavardaŋ kook ŋaatunooŋ, akɔm gɔl. Buk mã arɔɔŋ ɛɛti ŋaatunooŋ kavardaŋa kiiyayet ageeta ŋaato, akɔm gɔl.” ");
INSERT INTO mur_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ma abɛdɛkɛ niini Ibrayim anek nɛ, “Baaba Ibrayim, kilalekin zin da ka toon Lazaros kook korge o baaba loota. ");
INSERT INTO mur_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Eeci kanyei ŋinaante gɔtɔnɔga ceen tur. Anyek da nɔɔnɔ kook kitilo nɔɔgɔ keteedɔi oŋɛ ugeec ka calaŋ katin avunak niigi ŋinti nɔŋ ci kol kaavɛ naana noko.” ");
INSERT INTO mur_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma anek Ibrayim nɔɔnɔ nɛ, “Anyak gotonogu loota ŋinaante lotinok o Mosis been zoozok o nyakaŋanetu. Ŋaan ilot nɔɔgɔ. Ŋaan zin azii gotonogu zoozok niceke.” ");
INSERT INTO mur_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma abɛdɛkɛ niini Ibrayim anek nɛ, “Baaba Ibrayim, alaŋ niigi ooli been nɛɛn. Dooke coma iŋaaz ɛɛti daayiza, ma akɔ aduwak nɔɔgɔ zɔɔz can kapirnanɛ noko, o koca aziiknɛn niigi, ma ateedinɛ oŋɛ ugeec dook nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma anek Ibrayim nɔɔnɔ nɛ, “Mã alaŋ arɔɔŋ kiziiyit niigi lotinok o Mosis kibeen zoozok o nyakaŋanetu, mayo nuun iŋaaz ɛɛti daayiza korok bodo, ma akɔ ilot nɔɔgɔ, alaŋ koca buk azii niigi nɔɔnɔ been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ma anek Yesu nuyak ogin nɛ, “Ma kaala ci anyek ɔl kabaca oŋɛ noko ŋɛdɛt avu nɔkɔ laadun, bar zin izi nɔŋa wole eete ci laadun anyaa kaal nicoko o. ");
INSERT INTO mur_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aganɔ waan ŋaati acabonɛkɛ nɔɔnɔ golu inyaa, ma ajukonɛkɛ liil ka calaŋ anyek dɔl ci miliny noko kabaca oŋɛ. ");
INSERT INTO mur_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Egenyit zin niiga alya eleetine ugooc. Mã abacakin gotonu gi ci gɛr, gerenyek. Mazi ɛtɛɛdɔi niini gi nico, toŋ nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mã abacakin niini ineet kaal ci gɛr lak torgɛrɛm iitene codoi, ma bodo buk aku anekin ineet lak torgɛrɛm nɛ, “Inoko o kabaci naana gi we,” abon buk uuŋ niina nɔɔnɔ kɔkɔm gi ci gɛr agoonei.” ");
INSERT INTO mur_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ma anek toonnyawa Manyi Yesu nɛ, “Zaaceyet zin tuwɛn cinaaŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Inoko tɛ anyayit nuun tuwɛn ci miliny tɛr kiyo kɛbɛrɛci o laŋiracoco o, animnyu waan enektek kɛɛt ceen moneec noko nɛ, Piya ɛlɛ agɛrɔi buk ŋina, bitɔ bil liil kɛŋa ŋaate, ma aziiŋnuŋ waan niini igeet.” ");
INSERT INTO mur_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ma anek Yesu nɔɔgɔ nɛ, “Inoko mã anyak ɛɛti codoi ŋaatunooŋ gabaren ci eevonek, karabɔŋ oowawonek nɔɔnɔ, mazi akɔ abada niini towawiinta, karabɔŋ een keevinta, anei koca niina nɔɔnɔ ecodoi nɔkɔ nɛ, “Bitɔ dawɔ?” ");
INSERT INTO mur_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bar kanɛ anei rak koca nɔɔnɔ nɛ, “Bitɔ tuguweyan dayiin zɛɛ mazi odot, borocek rum ci abon, ka nyaayan dayiin, ka ija rɛwan kadawɔ rak, ma kawodɛ. Ŋaan akɔ adake niina tedec.” ");
INSERT INTO mur_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Alaŋ zin anyek ɛɛti gabaren zany giye o agɔɔni niini kaal o aduyak niini nɔɔnɔ kutugu. ");
INSERT INTO mur_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Abil zin buk ŋaatunooŋ nɔkɔ. Mã agoonu liŋliŋɔn o aduyakuŋ ka utuguz, iziti nɛ, “Keegina naaga gabara ci labak, olla kaliŋliŋnya naaga liŋliŋɔn onaaŋ aduyaket doon.” ");
INSERT INTO mur_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Mazi ŋaan awɔ Yesu gɔla akɔ Jerusalɛma nɔkɔ, ook ono niini vitɛn ci aŋɛr looc o kazi Samariya kibeen looc o kazi Galili. ");
INSERT INTO mur_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mazi akɔ awowonek kutur oma ŋinaante, urumtɔ kibeen ɔl ceen amɔtɔ ci amɔɔr mɔɔriz o gidaŋ. Avu niigi, ma ɛɛl rɛɛna kidicilim. ");
INSERT INTO mur_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ma agɛrɛny azii nɛ, “Yesu, Manyi, eelawet da!” ");
INSERT INTO mur_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ɔɔtɔ eyeltek eleeti alaat o ceez o Joowo ka kɔɔt kicintuŋ igeet maŋaan anyaku mɔɔriz.” Ɔtɔɔzɔ ni ɔl nici. Mazi ŋaan awɔ gɔla nɔkɔ, obonta nɔɔgɔ eleeti ugeecik orogita. ");
INSERT INTO mur_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mazi akɔ acin ɛɛti codoi ŋaatineeŋ ɛlɛ onin nɔkɔ, abada niini, ma aku anyek Jook zany molowe ci appe. ");
INSERT INTO mur_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aku niini, ma aavek Yesu loota kɔpɔkpɔk, ma anyek nɔɔnɔ zany talniinta. Maje niini laadun eet ci Samariya. ");
INSERT INTO mur_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma anek Yesu ɔl nɛ, “Ma uyen eegin ɔl ci orogit mɔɔriza amɔtɔ. Ɔl tɔrkɔc ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ole oke dook akɔm ci abada ŋaatineeŋ kiiya kanyek Jook zany zɛɛ ma bar abada ɛɛti ceen miroi noko doon?” ");
INSERT INTO mur_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Enek ni Yesu nɔɔnɔ nɛ, “Tiŋa je, tɔ. Tuwɛn unun nɛɛn ci uruguzin ineet o.” ");
INSERT INTO mur_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mazi ajin ɔl o Parici Yesu iiten ci ka kiiyai baliin o Joowo. Ɛbɛdɛkɛ niini nɔɔgɔ enek nɛ, “Baliin o Joowo alaŋ aku gole ci ka kicinti ɔl. ");
INSERT INTO mur_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Akɔm katin eet ci ka kizi nɛ, “Icinit di nɔɔnɔ ce,” karabɔŋ azi nɛ, “Nɔɔnɔ ca,” eeci baliin o Joowo aavi zinzeetine ugooc.” ");
INSERT INTO mur_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ma anek Yesu nuyak nɛ, “Avu katin iinya ci arooŋnyaŋ niiga icintaŋ aneet Ŋɛɛrti Eeto, ka olla koromtɛ been igeet nuun iiten codoi ṯɔr nɔkɔ, bar alaŋ acinaŋ nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anyak katin ɔl ci anekuŋ nɛ, “Icinit di ŋinte! Aavi niini ŋinaante,” karabɔŋ azi nɛ, “Icinit di ŋinto! Aavi ŋina.” Bar zin eteedɔ zɔɔ. Má avɔ anuyu nɔɔgɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Eeci tiŋeere badaan cane aneet Ŋɛɛrti Eeto abil kiyo bɔrɔyɛ o gɔɔn abadi kicinit ɔl looc dook o. ");
INSERT INTO mur_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bar zin rak ɔɔwa abon kapirna kaale ci meelik, ma abornan ɔl ci ɔɔ nico noko. ");
INSERT INTO mur_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Zin kiyo baale agooni kaala iinyaye o Nowa e, abil buk katin iinya cigan aneet Ŋɛɛrti Eeto o nɔkɔlɛ. ");
INSERT INTO mur_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baale iinyaye niceke ɔl dook adake, ma awot nyaantanɛ. Ma arɔcɔ labak zɛɛ been iiten baal akɔyi Nowa kavoola e. Iiya ni otodot waanice tawani nɔɔgɔ dook lai. ");
INSERT INTO mur_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Abil buk katin kiyo baale iinyaye o eet o kazi Lat e. Waanice adake ɔl, ma awot nyaantanɛ, ma ataali, ma ataalinɛ kaal, ma eevyi, ma ɛɛnyɛt ceezi labak. ");
INSERT INTO mur_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ma iitene o aduŋni Lat kuture o kazi Sodom e, iita goo tamma, ma adak waanice nɔɔgɔ dook lai. ");
INSERT INTO mur_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Abil zin buk katin iiteni ci kayelizyanɛ naana Ŋɛɛrti Eeto e nɔkɔlɛ. ");
INSERT INTO mur_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tiŋeere iitene nice ɛɛti ci aavi ceez rɛɛrna alaŋ anim kook kaara kaal ogin ceeza eecitɔ. Maje ɛɛti ci tɛ aavi mana alaŋ bodo anim kiiyak kɔrɔk ka kiiya kooyi kaal ogin. ");
INSERT INTO mur_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aada zɔɔz o ŋaa o Lat baal abuudi gɔla arɔɔŋ kimiirozek Sodom, ma waanice ook adaak e. ");
INSERT INTO mur_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ma ɛɛti ci arɔɔŋ korogoz ɛlɛ onin, bar akoloz. Maje ɛɛti ci akoloz ɛlɛ onin, bar arogoz. ");
INSERT INTO mur_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Didilɛ kaduwakuŋ igeet, katin baaline nice mã aromɛ ɔl raman kuwena, aŋɛryai codoi ŋaatineeŋ, ma ooŋni codoi. ");
INSERT INTO mur_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Buk mã areke ŋaai raman golwa ŋaatodoi, aŋɛryai ŋaatineeŋ codoi, maje codoi ooŋnonek looc.” ");
INSERT INTO mur_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma ajin nuyawa nɔɔnɔ anek nɛ, “Manyi, akanai dim katin gi nici ŋaaḏaŋ?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Zin gɔɔn laadun mã alotɛ kuduvaana ŋaaman, anyak gi ci adaai tɔ ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Uduwak ni Yesu nɔɔgɔ yabziin ci ka kɛdɛmɛz nɔɔgɔ ka kemedai kijinti Jook tup. ");
INSERT INTO mur_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Anek niini nɔɔgɔ nɛ, “Anyak baale kuture oman alaan ci roonnyo calaŋ aŋole Jook, ma buk apɛz niini ɔl dook. ");
INSERT INTO mur_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Maje buk kuture nice anyak ŋaa ci bɔi ci gɔɔn akunak nɔɔnɔ iinya dook, ma aku ilalek ka kiroon zɔɔz cin kibeen eet oma ci amarnin nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Maje alaani nici lak ci meel alaŋ arɔɔŋ kitirit nɔɔnɔ, ma vurta enek ɛlɛ maany nɛ, “Yo nuun alaŋ naana kaŋole Jook, ma kapez ɔl o, abon kagoonei ŋaa nico gi ci arɔɔŋ o, gɛrzɛ ŋaan aku aconanan tup zɛɛ ma arukan kadaak.” ");
INSERT INTO mur_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Izi nɛ Manyi Yesu nɛ, “Iziiyit zin di gi ci aduwa alaani ci gɛrzɛ noko. ");
INSERT INTO mur_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bar zin mã aluwek Jook ɔl oginɛ waazin ki baalin ole o amarnin nɔɔgɔ, apak koca niini zɔɔz nico. Alaŋ anyek nɔɔgɔ kereyɔ ŋinti wun. ");
INSERT INTO mur_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Didilɛ kaduwakuŋ igeet, apayakuŋ koca niini igeet gi o arooŋnyu kataman nɔkɔ. Mayo zin tiŋeere ma kabadai naana Ŋɛɛrti Eeto looc, kaku kajowa loota ŋina ɔl ci atuwe juruŋ tɔ?” ");
INSERT INTO mur_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ma bodo aduwak Yesu yabziin co ɔl o gɔɔn abaaban kizik niigi abona ŋume o Joowo, ma apɛz ɔl oogi. ");
INSERT INTO mur_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Anek niini nɔɔgɔ nɛ, “Anyak baale ɔl ceen ram avɔ ŋaryiin ceeze o Joowo. Ɛɛti codoi ŋaatineeŋ Pariciwen. Maje codoi eet ci gɔɔn alot meeri. ");
INSERT INTO mur_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ma akɔ abil ɛɛti ceen Pariciwen noko ceez ŋaatin doon, ma aŋaryɛ azi nɛ, “Jook, kanyin naana ineet zany, eeci aneet alaŋ appe ziniz, ma alaŋ kalaba ɔl, ma alaŋ karɛɛca kiyo ɔl dook o, ma buk alaŋ katobona ki eet ci gɔɔn alot meeri co. ");
INSERT INTO mur_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kuuŋ gɔɔn naana dayiin lak ram iinyaye ween torgɛrɛm ka kidiŋdiŋanin ineet, ma kanyin ineet lɛlɛn codoi lelenete ween amɔtɔ kaale ogan kajowa dook.” ");
INSERT INTO mur_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Maje ɛɛti ci gɔɔn alot meeri o, abil rɛɛna kidicilim, ma alaŋ buk adɔŋ ɔɔ ki taden, ma acɛlbɛzɛn ɛlɛ onin ajin Jook azi nɛ, “Jook, kilalekin ineet, eeci naana kabaca oŋɛ ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Izi ni Yesu nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti ci gɔɔn alot meeri noko imiire niini ook ɔlɔ ŋaati agaman Jooi nɔɔnɔ, ma anyek nɔɔnɔ kizi eet ci abona ŋume onin. Maje bar eet ci Parici noko akɔm gi ci agoonek Jooi nɔɔnɔ kina. Eeci ɛɛti ci adɔŋ ɛlɛ, acɛlbɛzɛn Jooi nɔɔnɔ. Maje bar ɛɛti ci acɛlbɛzɛn ɛlɛ onin, adɔŋ Jooi nɔɔnɔ kizi titiny.” ");
INSERT INTO mur_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Enice anyaaktak ɔl ogɛn Yesu dɔl ci miliny ka kiiya kataadek niini nɔɔgɔ azɛɛn kamayuk. Mazi bar acin nuyawa oginɛ ɔl nicoko, egerenycek niigi nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Otowa ni Yesu dɔl, ma anek nuyak nɛ, “Anycek dɔl kivitayan. Má alamnyu nɔɔgɔ, eeci baliin o Joowo abilnek ɔl ci anyek eleeti kiyo dɔlya ci miliny noko. ");
INSERT INTO mur_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Didilɛ kaduwakuŋ igeet, ma ɛɛti calaŋ agama baliin o Joowo kiyo dole ci miliny o, alaŋ akɔ niini baliinte o Joowo been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ma ajin alaani ci ɔl o Juz Yesu anek nɛ, “Gayoi o abon, mayo kutugu gitaz ka kojowa rogɛt o abil been nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma anek Yesu nɔɔnɔ nɛ, “Akɔ ma awuyan kizi eet ci kabona o naa? Akɔm eet ci abon, bar abona Jooi doon. ");
INSERT INTO mur_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Inoko aga niina lotinok o azi nɛ, Má adoma zoocmaz. Má amuny eet ci deer. Má agɔrzɛ. Má avoloŋ. Tɔŋɔlɛ baatun ki yaatun.” ");
INSERT INTO mur_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ma abɛdɛkɛ alaani nici Yesu anek nɛ, “Kazoonɛ lotinok nicoko dook nɔkɔ laadun iŋaan keen kidic e.” ");
INSERT INTO mur_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Mazi azii Yesu zɔɔz nico, enek nɔɔnɔ nɛ, “Anyak zin gi codoi ci ŋaan tugu. Bitɔ taalɔi kaal ugun dook zɛɛ anyek guruc ɛlɛ ɔl o amaat. Ŋaan akɔ jowa niina arɔkzɛt tammu tadena. Ija zin niina alya nowan aneet.” ");
INSERT INTO mur_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bar mazi azii alaani nici zɔɔz nico, alaca ɛlɛ calaŋ atalnɛ, eeci een niini aroi ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Mazi acin Yesu nɔɔnɔ alaŋaan atalnɛ nɔkɔ, izi nɛ, “Adɔi kak ole ceen arɔk ŋaati avɔyi baliinte o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Adɔi ɔrɔɔt ɛlɛ eete ceen aroi ŋaati akɔyi baliinte o Joowo, bar kizi mayɛ nyakale ŋaati adunyonɛkɛ nyibira ŋino vɔlɔŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ijinit ni ɔl o azii gi nico nɔɔnɔ enektek nɛ, “Ka dim zin katin korok ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma gi o alaŋ anim ɔl ci deer kutuguzɔ, aboke Joowa labak.” ");
INSERT INTO mur_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Enek ni Pitɔr Yesu nɛ, “Cin di, inoko naaga kotoŋta korogjok ogaacak, ma kivita kunuyin ineet. Mazin yo tiŋeere kajowana naa?” ");
INSERT INTO mur_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti ci ooŋ kɔrɔk onin, ki ŋaa onin, ki gɔtɔnɔgi ogin, ki baatin, ki yaatin, been dɔl ogin giye ci akati baliin o Joowo, ajowa tiŋeere niini kaal ci meelik loota ŋina kujuk kaal baal ooŋnek niini looc ole onin e. Ma bodo katin ajowa niini rogɛt o abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Otowa ni Yesu nuyak ogin een amɔtɔ ram, ma anek nɛ, “Iziiktɔ di, inoko kavɔ naaga Jerusalɛma. Avɔ zin tiŋeere ŋinaante agooni kaala baal ayɛɛt nyakaŋanɛta akanan aneet Ŋɛɛrti Eeto e dook. ");
INSERT INTO mur_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kakɔ tiŋeere kanyononei naana takirnya o ɔl ween modɛn, ma avɔ ararnan niigi aneet, ma adomnyan, ma oortekan amot. ");
INSERT INTO mur_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Avɔ tiŋeere arukan niigi aneet nyaboyɛn, ma vurta ɔɔt ni uruktan kadaak. Bar zin iinyaye ceen iiyu, ŋaan kiŋaaz bodo daayiza.” ");
INSERT INTO mur_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Maje nuyawa oginɛ akɔm gi codoi aga kaale nicoko. Eeci kɛŋ ci zɔɔz ci azɔɔz Yesu noko aroodi ŋaatineeŋ, ma alaŋ aga niigi zɔɔz ci aduwa niini o akati gitaz. ");
INSERT INTO mur_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mazi akɔ ajɔŋɔz Yesu kutur o kazi Jeriko, anyak eet ci ruben ci aavi gɔla alaye ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mazi azii niini kɔlɛ ci awɔ o, ijin nɔɔgɔ enek nɛ, “Ma dim tɛ anyak lɔɔci naa?” ");
INSERT INTO mur_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma abɛdɛkɛ ɔl nɔɔnɔ anek nɛ, “Awɔ Yesu o Nazarɛt ŋina.” ");
INSERT INTO mur_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɛgɛrɛny ni niini izi nɛ, “Yesu ŋɛɛrti Devid, tiritan da.” ");
INSERT INTO mur_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Maje ɔl ci araki o agernyek nɔɔnɔ kajawɔ. Bar enico ɛgɛrɛny niini ɔrɔɔt ɛlɛ azi nɛ, “Ŋɛɛrti Devid, tiritan da.” ");
INSERT INTO mur_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ibilun ni Yesu, ma aduwak ɔl kanyaaktak nɔɔnɔ eet ci ruben noko. Mazi aku, ijinun Yesu nɔɔnɔ anek nɛ, “Arooŋnyan kutuguweyin naa?” Ma abɛdɛkɛ niini Yesu anek nɛ, “Manyi, karooŋnyin nyan kicinɔ bodo.” ");
INSERT INTO mur_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Cinɔ zin. Tuwɛn unun nɛɛn ci aruguzin ineet o.” ");
INSERT INTO mur_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Enico ɛlɛ icinɔ niini didi, ma ano Yesu, ma adiŋdiŋan Jook ɔrɔɔt ɛlɛ giye nico. Mazi acin kɔlɛ gi nico, atanaazɔ niigi dook Jook ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Mazi akɔ arum Yesu kutur ci kazi Jeriko, anyak ŋinaante eet ceen aroi kazi Zakiyas. Niini alaan ci ɔl o gɔɔn alot meeri. ");
INSERT INTO mur_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma arɔɔŋ niini kicin eet ci kazi Yesu o ɔrɔɔt ɛlɛ, bar akɔm gɔl ci ka kicini nɔɔnɔ, eeci mɛɛlɛ ɔl ɔrɔɔt, maje niini alya eet ci kutur tɛr. ");
INSERT INTO mur_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɔdɔkɔny ni niini arayɛ ɔl ɔɔwa, ma akɔ atɔɔt kɛɛt ceen moneec ka kicin Yesu juruŋ ŋaati aku aduŋni ŋina. ");
INSERT INTO mur_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mazi aku arum Yesu ŋinito, ɔdɔŋ ɔɔ, ma anek nɔɔnɔ nɛ, “Zakiyas, duna taman. Kakɔ tedec katike ole cun e waanico.” ");
INSERT INTO mur_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ma aduŋna niini kataman, ma atalna Yesu ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Maje ɔl dook o acin gi nico, aŋɔmtɔ anɔ nɛ, “Ma dim ɛɛti nici akɔ ka kook kataŋu ole ci eet ci oŋenu o?” ");
INSERT INTO mur_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma iŋaaz Zakiyas jena, ma anek Manyi Yesu nɛ, “Manyi, ziiyan di. Kakɔ tiŋeere kaŋer kaal ogan kanyei dook kɔrgɛna, ma kanyi ɔl o amaat. Buk mã da gɔɔn anyak ɔl ci kadayɛ looc, karuwei tiŋeere nɔɔgɔ kaal ci arɔɔŋ niigi ŋaatan o lak wec.” ");
INSERT INTO mur_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma anek Yesu nɔɔnɔ nɛ, “Iiyak zin rogzɛn kɔrɔk nico waanico. Buk ɛɛti nici dole ci dɔl o Ibrayim. ");
INSERT INTO mur_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mazin naana Ŋɛɛrti Eeto kakun ka kiiya kɔrɔɔŋ ɔl o akoloni zɛɛ ma kajowa ka korogoz nɔɔgɔ.” ");
INSERT INTO mur_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mazi ŋaan azii ɔl zɔɔz nico nɔkɔ, uduwak niini nɔɔgɔ yabziin oma, eeci izi ajɔn Jerusalɛm. Abaabanit ni ɔl ci ɔrkɔr ki nɔɔnɔ o izitɔ nɛ, “Izi baliin o Joowo ajɔn ka kiiyak looc.” Ma aduwak Yesu nɔɔgɔ yabziin ci anek nɛ, ");
INSERT INTO mur_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Anyak baale eet ci titiny eerononek looc ci rɛɛn many, ka kook kɔrɔnyca ɔl nɔɔnɔ ŋinaante kizi alaan zɛɛ mazi odot, ka kabadaak niini looc onin. ");
INSERT INTO mur_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Mazi ka kɔɔtɔ, otowa gabara cigin een amɔtɔ, ma aku anyek codoi gɔɔn ŋaatineeŋ guruc ceen eet tur, ma anek nɔɔgɔ nɛ, “Ɔɔtɔ iliŋliŋti rak guruc nicoko ŋinti ŋaan kazɛɛnɛ tɔ o.” ");
INSERT INTO mur_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Maje ɔl ci looc cin o abor niigi nɔɔnɔ ɔrɔɔt ɛlɛ, ma itoon niigi otok kono nɔɔnɔ vurta azi nɛ, “Alaŋ karooŋnya eet nico kizi alaan cinaaŋ.” ");
INSERT INTO mur_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Maje bar ŋaati baal eerononek niini neke, anyozozek nɔɔnɔ alaazɛt odota. Mazi akɔ abadaak niini kɔrɔk, iiya otowa gabara ogin baal anyek guruc e ka kiiya kicin guruc ci anyaa niigi guruce baal anyek niini nɔɔgɔ ka kemelŋenyit e. ");
INSERT INTO mur_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ma aku gabarɛnti ci oowu o, ma anek nɔɔnɔ nɛ, “Manyi, kiliŋliŋa guruc eet tur lak amɔtɔ (1,000) guruce baal anyan e.” ");
INSERT INTO mur_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Abon ɔrɔɔt. Aliŋliŋ juruŋ. Een niina gabaren ci abonanin. Zin giye o iliŋliŋayɛ guruc oogi guruce baal miliny tɛr e, kanyin tiŋeere ineet kuturyok amɔtɔ ka bal niina izi alaan cineeŋ.” ");
INSERT INTO mur_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ma aku bodo gabarɛnti ci ano gɔn o, ma azi nɛ, “Manyi, kiliŋliŋa guruc ceen eet tur lak tur (500) guruce baal anyan e.” ");
INSERT INTO mur_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma anek niini gabaren nico nɛ, “Kanyin tiŋeere ineet kuturyok tur bal izi alaan cineeŋ.” ");
INSERT INTO mur_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ma aku bodo gabarɛnti ceeni, ma azi nɛ, “Manyi, guruc baal anyan e ce. Kacabi iiten baale ruma, ma kitaŋ karoodi. ");
INSERT INTO mur_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kaŋolinin ineet, eeci een niina eet ci adoŋnin aziiti. Adoma gɔɔn kaal culu, ma ateedi manɛɛn calaŋ ɛɛva niina.” ");
INSERT INTO mur_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Ma anek alaani nɔɔnɔ nɛ, “Een niina gabaren ci gɛr. Kacabjin tedec zoozowe cugun aduwa noko ɛlɛ. Mã da ma agayan keen eet ci adoŋnan aziiti, ma kadoma kaal culu, ma kateedi manɛɛn calaŋ een cigan, alaŋ zin da amelŋeny guruc cigan o ka ma kakun kajowa azaace naa?” ");
INSERT INTO mur_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Enek ni alaani ɔl o aromɛ kibeen nɔɔnɔ nɛ, “Aamta nɔɔnɔ guruc nicoko, anycek gabaren ona anyak guruc ween eet tur lak amɔtɔ e (1,000).” ");
INSERT INTO mur_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bar anek niigi nɔɔnɔ nɛ, “Manyi, anyawun uyen niini laadun eet tur lak amɔtɔ (1,000).” ");
INSERT INTO mur_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Kaduwakuŋ igeet, mã anyak ɛɛti kaal ci meelik, bar anyonek nɔɔnɔ ogɛn bodo kizi mɛɛlɛ ɔrɔɔt. Maje ɛɛti ci akɔm gi ci anyak, mayo nuun anyak ci miliny tɛr, aamnyai bar ŋaatin nici kavu nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Inoko zin anyaaktayaŋ ɔl baal amarninan aneet, ma alaŋ arooŋnyan kizi alaan cineeŋ e dook. Anyaakta ka ivita uruyit nɔɔgɔ kadaayitɔ aneet ŋuma ŋina.” ");
INSERT INTO mur_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Aduwa Yesu zɔɔz nico, ma vurta arawɔi ɔl ooyi Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mazi akɔ ajɔŋɔz ŋino kazi Bezpeja kibeen Bezani biye o kazi Kiŋiroc, itoonun niini nuyak ram karaktɛ. ");
INSERT INTO mur_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ma anek rak nɔɔgɔ nɛ, “Ɔɔtɔ korgine ci igeet ɔɔwa neke. Ajowanu tedec ŋinaante zigir ceen jɔrɔn ci ŋaan laadun kɔtɔɔt ɛɛti oman acabje ŋinaante. Ɔɔtɔ ɔɔkta ka anyaaktayaŋ aneet ŋina. ");
INSERT INTO mur_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mã anyak eet ci ajinuŋ anekuŋ nɛ, Ɔɔganu zigir nico naa? Enektek nɛ, Arɔɔŋ Manyi nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ɔɔtɔ ni niigi, ma avɔ ajowa kaal dook eona aduwakɛ Yesu nɔɔgɔ e. ");
INSERT INTO mur_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mazi avɔ ɔɔga zigir, ijinit ɔl ci zigiro o nɔɔgɔ enektek nɛ, “Ɔɔganu zigir cinaaŋ naa?” ");
INSERT INTO mur_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ma abɛdɛkɛ niigi nɔɔgɔ anek nɛ, “Arɔɔŋ Manyi nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ooti ni niigi zigir ŋaati Yesu. Ma avɔ arekɛ nɔɔnɔ rumanɛ bawuc, ma anyek Yesu kɔtɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Mazi akɔ awɔ Yesu zigira, etevetɛkɛ ɔl nɔɔnɔ rumanɛ ugeec gɔl. ");
INSERT INTO mur_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mazi akɔ ajɔŋɔz niini Jerusalɛm ŋaao alocanɛ gɔl biye o kazi Kiŋiroc, egerenyit nuyawa oginɛ dook kɔla ŋaati anyekɛ Jook zany, ma anaati nɔɔnɔ kaale o meel adiŋdiŋ acin niigi. ");
INSERT INTO mur_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma agɛrɛny niigi azi nɛ, “Amayuk Jooi alaan o aku zaare ogin. Abil ganɔni tamma, ma anyak titinyɔn Jooi o adiŋdiŋ.” ");
INSERT INTO mur_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma azɔɔz ɔl ogɛn ole o Parici kɔla tɔ anek Yesu nɛ, “Alaan o demziinto, gerenyek nuyak cuguno kajaktɔ.” ");
INSERT INTO mur_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Bar abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Kaduwakuŋ igeet, mayo nuun ajaki niigi, biyɛn alya agɛrɛny ni koca ɔrɔɔt nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Mazi awowonek Yesu Jerusalɛm, acin kutur, ma aluwek azi nɛ, “Matɛ nuun ga gɔl o ka jowai ganɔn iiten nico ɛlɛ doon, abon koca. Bar zin inoko o alaŋ aga. ");
INSERT INTO mur_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Aku zin tiŋeere iiteni ci aliyanin modɛna o amarninin ineet kabanyɔ dook, kɔkɔm ŋinti aduŋnɛ. ");
INSERT INTO mur_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oyokin tiŋeere niigi ineet kibeen ɔl cugun noko dook lai kɔkɔm tegeremoc codoi ṯɔr nɔkɔ ataadonek gɔn. Agooni gi nici o, eeci ŋaan ga niina iiten o iiyai Jooi niini alya ka kiiya kitiritin ineet.” ");
INSERT INTO mur_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Enico ook Yesu ceeze o Joowo, ma akɔ atɔɔwak ɔl dook o ataalinɛ kaal kaluwawa ŋinaante bitaalin. ");
INSERT INTO mur_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma anek niini nɔɔgɔ nɛ, “Ayeedi waragewe o Joowo zɔɔz ci anɛ Jooi nɛ, Ceez cane o agayi kizi ceez ci ŋaryiinto, maje bar niiga ivita utuguzu kizi ŋinti aroodinɛ agoryawa.” ");
INSERT INTO mur_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma iinyaye niceke akɔ gɔɔn adɛmɛz Yesu ɔl ceeze o Joowo iinya dook. Maje alaata o ceez o Joowo, ki ɔl o demziinto, been alaat o ɔl o Juz arɔɔŋ kuruyit nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bar akɔm gɔl ci ka kurukti niigi nɔɔnɔ, eeci ɔl dook gɔɔn alotak nɔɔnɔ, ma avu azii zoozok ogin. Ma alaŋ arɔɔŋ niigi kobolozit zɔɔz codoi ṯɔr zoozowe ci aduwa niini noko. ");
INSERT INTO mur_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ma iitene oman ademzek Yesu ɔl kaviyak o Joowo abon ceeze o Joowo. Ivitak ni nɔɔnɔ alaata o ceez o Joowo, ki ɔl o demziinto, been ɔl o adikir baayizo. ");
INSERT INTO mur_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma avu anek nɛ, “Duwayet di, ma dɔyiz ci agɔɔnɛ kaal nicoko dook noko ajowa ŋaa? Ŋɛnɛɛn ci anyin ineet dɔyiz nico o?” ");
INSERT INTO mur_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Anycaŋ zin di buk kijinuŋ naana igeet. Baale dɔyizi o Jɔn o oonyi aku Joowa, yo aku da eete ci deer?” ");
INSERT INTO mur_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ŋinaanto adaŋtɔ niigi maany izitɔ nɛ, “Kayo kiziti nɛ? Mã kazi nɛ, Aku Joowa, azi koca nɛ, Alaŋ zin da baale atuyu Jɔn naa? ");
INSERT INTO mur_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bodo mã kazi nɛ, Aku ole ci deer, avacet koca kɔlɛ nici dook ageet biyɛnɛ zɛɛ ma kadaai, eeci atu niigi Jɔn anyek kizi nyakaŋan.” ");
INSERT INTO mur_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛbɛdɛkɛ ni niigi Yesu enektek nɛ, “Alaŋ kagaya ŋinti da akuni dɔyizi ci Jɔn o.” ");
INSERT INTO mur_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma anek Yesu nɔɔgɔ nɛ, “Alaŋ zin buk naana kaduwakuŋ igeet dɔyizi can kagɔɔnɛ kaal nicoko dook o.” ");
INSERT INTO mur_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Uduwak ni Yesu ɔl yabziin ci anek nɛ, “Anyak baale eet ci aḏowa kɛɛn ci amadi kɛbɛrɛ ɔrɔɔt ɛlɛ. Ma anyek niini ɔl oogi keevit mana nico ka ma abiir, ka keŋerit niini been nɔɔgɔ. Ɛɛrɔn ni niini ook ŋaati rɛɛn many. ");
INSERT INTO mur_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ma iinyaye o teedinto, itoonak niini gabaren cin ɔl o keevinto ka kiiya kooyɛkɛ nɔɔnɔ kɛbɛrɛ cigin. Bar ɔl ci keevinto noko uruyit gabaren nico, ma anyek nɔɔnɔ kimiire nɔkɔ kɔkɔm gi ci akɔyi. ");
INSERT INTO mur_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bodo akɔ itoona niini gabaren oma, bar ɔl ci keevinto noko ŋaan amɛna bodo aruk buk gabaren nico. Ma amomoz nɔɔnɔ ɔrɔɔt, ma anyek kimiire nɔkɔ kɔkɔm gi ci akɔyi. ");
INSERT INTO mur_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Bodo aku itoonek niini nɔɔgɔ gabaren oma, ma avu aruk niigi nico ɔrɔɔt ɛlɛ zɛɛ ma atooyek bitaalin. ");
INSERT INTO mur_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Abaabanun ni ɛɛti ci mano noko izi nɛ, “Kayo kutugu ku? Abon kitoonei nɔɔgɔ ŋɛɛran onan kareez ɛlɛ. Kaga nɔkɔ aŋole tiŋeere niigi nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bar mazi avɔ acin ɔl ci keevinto noko nɔɔnɔ, izitɔ nɛ, “Nicini ŋɛɛrti eet o mano nɛɛn. Abon karuk nɔɔnɔ kadaak ka kaala ciginɛ o dook kizi cigaac.” ");
INSERT INTO mur_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Agamit ni niigi nɔɔnɔ, ma avɔ aruk kadaak mana bawuca.” Ma ajin Yesu nɔɔgɔ anek nɛ, “Inoko zin tiŋeere ɛɛti ci mano noko aku agoonek ɔl nicoko naa? ");
INSERT INTO mur_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Bar kanɛ aku tiŋeere niini, ma aku aruk ɔl ci keevinto noko kadaayitɔ, ma anyek mana ɔl oogi.” Mazi azii ɔl yabziin nico, izitɔ nɛ, “Alaŋ ri bai abil nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ɛgɛlɛm ni Yesu nɔɔgɔ, ma anek nɛ, “Mazi yo zɔɔz o ayeedi waragewe o Joowo akati naa? Azi niini nɛ, Ma bɛ o abor ɔl o gɔɔn ɛɛnyɛt ceezi biyɛnɛ, ma apɛz kizi gi ci labak, bar bɛ o titiny ɔrɔɔt kujuk biyɛn o eenycinto dook nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ma ɛɛti ci iinak bɛ nici aduuli yivyiv. Maje ɛɛti ci iinak bɛ nico nɔɔnɔ uurti kututut.” ");
INSERT INTO mur_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ma arɔɔŋ ɔl o ademzek ɔl lotinok kibeen alaat o ceez o Joowo kagamit Yesu ziite nice, eeci aga niigi ariik niini nɔɔgɔ zooze nico, bar olla eeci aŋole niigi ɔl. ");
INSERT INTO mur_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Orooŋit ni gɔl ci ka kagamti nɔɔnɔ. Ma avɔ atɔlɔk ɔl oogi guruci, ka kɔɔt kedetit Yesu ŋaati agɔɔni eleeti kizi ɔl ci abon, ka kalabta nɔɔnɔ kijinit kaal gɛnyiza zɛɛ mazi anyak gi ci gɛr aduwa, ka kooti nɔɔnɔ rooni alaane o Rom. ");
INSERT INTO mur_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ma avu anek roote nici Yesu nɛ, “Alaan o demziinto, kagayin naaga ineet kaala ci aduwa niini, ma ademez o dook kaal ci alɛɛmnyai. Ma akɔmnin ineet tɛl, bar ademez ɔl gɔl o Joowo een didi. ");
INSERT INTO mur_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Inoko zin di duwayet. Mayo aganɔ ŋaati karuwɛki alaan o Rom meeri, yo akɔm da?” ");
INSERT INTO mur_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Maje Yesu aga zɔɔz cineeŋ adɛti niigi nɔɔnɔ o nɔkɔ, ma anek nɔɔgɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Anycaŋ di gurucoc kicin. Ma riritɔni kibeen zaar ci anyak gurucoc nici o ci ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Ci Sizar.” Enek ni Yesu nɔɔgɔ nɛ, “Anycek zin Sizar kaal o akati nɔɔnɔ. Maje Jook anycek kaal o akati nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Buk enico ɔkɔm zɔɔz ci ka kagamti niigi nɔɔnɔ ɔl kɔrgɛna ŋina. Ma abiir nɔɔgɔ ooti zooze ci abarzek niini nɔɔgɔ o, olla kapaŋantɛ kɔkɔm gi ci aduwa. ");
INSERT INTO mur_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Ma avunak ɔl ogɛn ole o kazi Sajuzi Yesu. Niigi ɔl o gɔɔn adaŋnye azi nɛ, Alaŋ bodo ɔl iŋaaz daayiza. Ma avu ajin niigi Yesu anek nɛ, “Alaan o demziinto, ayeedeket baale Mosis lotinɛt ci azi nɛ, Mã adaai ɛɛti ci ɔrɔcɔ maŋaan akɔm ŋaa cin o dɔl, abon gɔtɔnnya ci ŋaan arogi o anyak ŋaa cin o ka kitirak nɔɔnɔ dɔl. ");
INSERT INTO mur_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","30","Anyak zin baale ɔl ceen gɔtɔn een torgɛrɛm. Ɔrɔcɔ ni ceen abuu o, ma adaai iŋaan kitira dole. Iiya ni anyawun gɔtɔnnya ci anowɔ ki nɔɔnɔ o ŋaa, ma adaai buk nici iŋaan kitirak ŋaa dole. ");
INSERT INTO mur_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ma bodo buk aku agɔɔn gɔtɔnnya ceen kɔrgɛn o nɔkɔ. Ma akɔrkɔranɔn niigi dook ŋaa nɔkɔ zɛɛ been tir logote ceen tutur o. Ma adaai niigi dook kɔkɔm dɔl ci arita. ");
INSERT INTO mur_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma vurta adaak buk ŋaa. ");
INSERT INTO mur_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mayo zin tiŋeere ma iŋaaz ɔl daayiza, ŋaa nici akati ŋɛnɛɛn giye o niigi dook torgɛrɛma anyakti ŋaa nico?” ");
INSERT INTO mur_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma abarzek Yesu nɔɔgɔ anek nɛ, “Arɔcɔ ɔl loota ŋina inoko o doon. ");
INSERT INTO mur_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Maje bar ɔl o tiŋeere iŋaaz daayiza, ma avɔ rogete o abil been nɛɛn, alaŋ bodo niigi arɔcɔ. ");
INSERT INTO mur_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma alaŋ buk bodo niigi adaai, eeci otobtɔ niigi ki toonnyak o Joowo. Iziti niigi dɔl ci Joowo giye o tiŋeere iŋaani niigi daayiza. ");
INSERT INTO mur_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma ɔl o adaai iŋaaz bodo tiŋeere niigi daayiza. Uduwa baale Mosis gi nico waragewe o Joowo ŋaabaal acini niini lugurgoc o alanyit e. Ma awo niini Jook azi nɛ, Jook o Ibrayim, ki Aizak, been Jakob. ");
INSERT INTO mur_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ma kɛŋ ci zɔɔz nico akati gi o alaŋ ɛɛnɛ Jooi Jook ci ɔl ci adaai, bar niini Jook ci ɔl ci arogi, eeci ɔl dook ŋaatin arogi.” ");
INSERT INTO mur_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma abɛkɛkɛ ɔl ogɛnɛ ole o ademzek ɔl lotinok nɔɔnɔ anek nɛ, “Alaan o demziinto, abarzeket gi ci abon.” ");
INSERT INTO mur_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Azi nɔkɔ o, eeci otoŋole niigi nɔɔnɔ, ma alaŋaan arɔɔŋ kijinit niigi bodo nɔɔnɔ gi oma. ");
INSERT INTO mur_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ma ajin Yesu nɔɔgɔ anek nɛ, “Ma dim gɔɔn niiga anonu nɛ, Kiristo niini katin dole ci dɔl o Devid o, ku? ");
INSERT INTO mur_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Kajine o, eeci azi Devid alya waragewe onin beniinowu nɛ, Anek Jooi Manyi onan nɛ, Aavu libire can azo o zɛɛ ma kanyin ineet rocek modo ugun amarninin ineet looc zɔɔnɛ. ");
INSERT INTO mur_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Mazi awo Devid niini alya Kiristo kizi Manyi cin o, ka zin bodo kizi dole ci dɔl cigin ku?” ");
INSERT INTO mur_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Mazi ŋaan azii ɔl dook zɔɔz nico nɔkɔ, enek Yesu nuyak ogin nɛ, “Egenyit ole o ademzek ɔl lotinok. Arɛɛz niigi gɔɔn ŋaati aborcɛki rumanɛ ci alina, ma arɛɛz ŋaati azaawi ɔl nɔɔgɔ titinyɔnta ŋaati awɔyi golowɛ, ma gɔɔn avɔ arayek niigi eleeti lɛcɛrɛ o abon ceezine o lotento been vitɛnane o gɔɔn azɔli ɔl dayiin. ");
INSERT INTO mur_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ma buk gɔɔn avɔ aavtiz niigi ki ŋaai o bɔi ka kadakti nɔɔgɔ looc. Ma arɔɔt gerzitin uneeŋ ŋaati ajini Jook ŋinti wun kal kɔlɛ kɔrgɛna. Bar zin katin payiin cineeŋ gɛrzɛ ɔrɔɔt kujuk ɔl dook.” ");
INSERT INTO mur_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mazi akɔ Yesu ceeze o Joowo, acin ɔl ween arɔk ŋaati avu ajukɛkɛ guruc loidoŋ o ceezu. ");
INSERT INTO mur_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma acin buk niini ŋaa ci bɔi amaat ajukek milinyanɛ ceen ram loidoŋ nico. ");
INSERT INTO mur_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Izi ni Yesu nɛ, “Kaduwakuŋ igeet, anyek ŋaa ci bɔyɛ noko Jook guruc ci meel kujuk ɔl oke dook. ");
INSERT INTO mur_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Eeci ɔl oke dook anyek Jook kaal ci anyigjai arokzete uneeŋ. Maje bar niini amaat ɔrɔɔt, ma anyek Jook guruc ogin ona anyak e dook.” ");
INSERT INTO mur_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maje nuyawa o Yesu ogɛn anaat linat o ceez o Joowo, eeci ɛɛnycai niini biyene ci alina, ma anyak kaal ci alina ɔrɔɔt ɛlɛ ci gɔɔn anyek ɔl Jook. ");
INSERT INTO mur_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Bar anek Yesu nɔɔgɔ nɛ, “Kaal ci acinu noko dook, anyak iiten oma ci alibɛn niigi dook lai kɔkɔm bɛ codoi ṯɔr ataadonek gɔɔn tadena.” ");
INSERT INTO mur_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ijinit ni nuyawa Yesu enektek nɛ, “Alaan o demziinto, ma dim kaala nicigi akanai tiŋa? Ma katin ma izi iiteni nica ajɔn, kagaya ku?” ");
INSERT INTO mur_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Iziti vililɛ! Má anyeku ɔl koogi kalabtawuŋ. Eeci iima avu ɔl ci meel zaare cigan, ma avu anekuŋ nɛ, Aneeta Kiristo nɛɛn ce. Inoko iiya iiteni. Bar zin niiga má aziiŋnu zɔɔz cineeŋ o been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mazi iziiktu oroonok kibeen looc yawyawitin, má rak aŋolinu looc gaga, eeci kaala nici ŋɛdɛt rak akanai ɔɔwa nɔkɔ, bar zin looc dican alaŋ ɔrkɔra ki kaal nicoko ecodoi nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ma azi Yesu bodo nɛ, “Ɔɔrɔ waanma modɛna olla yaka. Kuturi ce ki kutur co ɔɔrɔ. Alaani ce ki alaan co ɔɔrɔ. ");
INSERT INTO mur_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma amɔɔt waanma tɔdɔwa vitɛnane ogɛn kirakirak, ma anyak lɔɔci tarjo ki moorizok ci gɛr vitɛnane ci meelik, ma ayelzai tammu kɛŋa kaala ci anyek ɔl kanyayit ŋoliin ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Zin maŋaan rak kakatai kaala nicigi, agamnyuŋ tiŋeere ɔl igeet, ma agiduŋ, ma akɔlakuŋ rooni, ma arekuŋ sijin, ma avoyuŋ alaatɛ, eeci atuyaŋ niiga aneet. ");
INSERT INTO mur_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Bar zin nici waŋi cunooŋ ka uduktakɛ niigi nɔɔgɔ kaviyak o Joowo abon. ");
INSERT INTO mur_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Anycek zin niiga zinzeeti kalalit labak calaŋ abaabanu gi ci aniyu nɛ, Kayo kɔɔtɔ kuduktak nɔɔgɔ naa? ");
INSERT INTO mur_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eeci tiŋeere iitene nice ŋaan kanyuŋ naana igeet zɔɔz ganiin ki dɔyiz ci atɛɛzanu ɔl o amarninuŋ igeet dook kapaŋantɛ, kɔkɔm gi ci aduwa. ");
INSERT INTO mur_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma iinyaye niceke iirikuŋ tiŋeere baatugooc, ki yaatugooc ɛlɛ, ki gotonogu, ki atenok ugooc, been laŋotugooc, ma aruk niigi oogi ŋaatunooŋ kadaayitɔ. ");
INSERT INTO mur_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Amarninuŋ waanma ɔl dook igeet, eeci anuyaŋ aneet. ");
INSERT INTO mur_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bar zin akɔ ma akɔm ŋaatunooŋ imitat ci oowu adoi ṯɔr iina been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mã amezu piryakzɛt labak, ajowanu koca tiŋeere rogɛt o abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma bodo anek Yesu nɔɔgɔ nɛ, “Ma acinu takirnya ci modɛn oogi ivita ilikta Jerusalɛm, agaac niiga iiya libɛn oninɛ izi ajɔn. ");
INSERT INTO mur_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Abon zin ɔl o abaak Judiya adokonyonek biyɛn. Maje ɔl o abaak Jerusalɛma, abon aluuk ŋinaante. Ma ɔl o adɛyai Jerusalɛma, abon aavtiz calaŋ avunak. ");
INSERT INTO mur_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Eeci nicaga iinya o acacinɛ Jooi nɛɛn, ka kɛlɛɛmnyai zoozowa dook o aduyai waragewe o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nɔŋ ci kol zin tiŋeere iinyaye niceke ɔrɔɔt ŋaane o anyake been ŋaane o arokti. Eeci akunak tiŋeere libɛn ci appe ɔrɔɔt looc nice giye o abornɛkɛ Jooi ɔl niceke nɔŋ. ");
INSERT INTO mur_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Aruwe katin ogɛn dilanyai, ma agamnyi ogɛn kɔɔt kacabtɛ loocowe ogɛn. Ma abal Jerusalɛm ɛlɛ modɛna ogɛn zɛɛ ma akɔ adicai irkitowa ci baliin cineeŋ o.” ");
INSERT INTO mur_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ma azi Yesu bodo nɛ, “Iiten ci akuni Ŋɛɛrti Eeto e, anyak katin kaal ci ayelzai iiwa, ki nyelowa, been monyonyɛ. Maje loota ŋina apalpalani katin maama liilowɛ, ma amacucɔ ɔrɔɔt ɛlɛ keteede modɛn o loocu dook biyɛta, ma akunak nɔɔgɔ ŋoliin ci appe ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aruk tiŋeere ɔl kulurkuluri katavalitɔ ki ŋoliin ŋinti ŋaan rak arɛwi niigi kaal ci gɛr ka kakatai loota neke. Eeci tiŋeere kaala o ɛɛl tammu bɔbɔra amɔɔt, ma ookci. ");
INSERT INTO mur_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Keyelizai ni naana Ŋɛɛrti Eeto ŋaati kakuni diizoca dɔyiza been diŋdiŋonte ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Mazi akanai kaala nicigi, itiŋgaz jena odoŋit ooti ki taden, eeci ɛlyaan unooŋ izi ajɔn.” ");
INSERT INTO mur_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ma uduwak Yesu nɔɔgɔ yabziin ci anek nɛ, “Abaabanit di kɛɛt ween moneec kibeen buk kɛɛn oogi. ");
INSERT INTO mur_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gɔɔn mã acinu bɔlɔk ugeec itilizit, agayu izi lɔlɔŋumi ajɔn. ");
INSERT INTO mur_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Buk zin gole nico ma acinu kaal nicoko akatai, agaac izi baliin o Joowo ajɔn ka kiiya. ");
INSERT INTO mur_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Didilɛ kaduwakuŋ igeet, iina tiŋeere kaala nici dook iŋaan kidicai ɔl nicigi dook. ");
INSERT INTO mur_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Adicai katin tammu taden ki looc, maje zɔɔz cane o abil kɛlɛɛmnyai nɔkɔ zɛɛ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Egenyit eleetine ugooc ka calaŋ atalvanyanuŋ zinzeeti baayinɛt ci awudu nyaantanɛ gil, kibeen gi ci anyeku zinzeeti kivirit kaale ci akati rogɛt unooŋ looce nico zɛɛ makacin iiyayuŋ iiteni nica boyoŋyoŋ calaŋ agayu. ");
INSERT INTO mur_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Eeci atoroban tiŋeere iiteni nica ɔl loocok dook kɛrɛk nɔɔgɔ kiyo gɔɔn atoroban kelegit curi o. ");
INSERT INTO mur_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Egenyit zin ijinit Jook tup ka anyayit dɔyiz ci avardaŋnyu kaalyan ci avunak looc neke dook zɛɛ ma avɔ arumnyaŋ aneeta Ŋɛɛrti Eeto.” ");
INSERT INTO mur_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ma adica Yesu iinya niceke dook adɛmɛz ɔl waaz ceeze o Joowo. Ma yomana awɔ akɔ ooŋnyak biye o kazi Kiŋiroc. ");
INSERT INTO mur_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma avunak gɔɔn waanice ɔl dook ceez o Joowo ŋeere ririwɔna ka kivita kiziiyit niigi nɔɔnɔ ŋaati ademzin. ");
INSERT INTO mur_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Mazi akɔ ajɔn iiteni o gɔɔn adayi ɔl o Juz ḏɔkɛn o alaŋ amokcar o gɔɔn aadanɛ niigi iiten baal avardaŋi toonnyaiti o Joowo ceezi ugeec looce o Masiro e, ivita alaata o ceez o Joowo been ɔl o gɔɔn ademzek ɔl lotinok orooŋit gɔl ci ka komonyci Yesu calaŋ ɔl aga, eeci aŋole niigi ɔl. ");
INSERT INTO mur_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Enico ook Loryen zinize o Judaz o kazi Iskariyot ween nuyai codoi nuyawe o Yesu een amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ɔtɔɔ ni niini, ma akɔ azɔɔz ki alaat o ceez o Joowo been alaat o takirnya o abɛk ceez o Joowo gɔl ci ka kanyaakɛ niini nɔɔgɔ Yesu. ");
INSERT INTO mur_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ataltɔ ni niigi ɔrɔɔt ɛlɛ, ma aterkedek niigi nɔɔnɔ zɔɔz ci ka kanycekɛ guruc. ");
INSERT INTO mur_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Agama ni Judaz zɔɔz cineeŋ o, ma akɔ arɔɔŋ gɔl ci ka kakatakɛ nɔɔgɔ Yesu kɔkɔm eet ci aga. ");
INSERT INTO mur_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","8","Mazi akɔ een iiten o gɔɔn adayi ɔl ḏɔkɛn o alaŋ amokcar, ma atɔŋdi niigi mirkici o ŋaan miliny o aadanɛ iiten o vardaŋinto, itoon Yesu Pitɔr ki Jɔn anek nɛ, “Ɔɔtɔ orooŋit ŋinti ka utuguzi dayiin cigaac kaadanɛ iiten ci vardaŋinto o.” ");
INSERT INTO mur_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ma ajin niigi nɔɔnɔ anek nɛ, “Koota kutuguza ŋaaḏaŋ?” ");
INSERT INTO mur_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Ma anek niini nɔɔgɔ nɛ, “Iziiktɔ di juruŋ. Avoyu tedec zɛɛ ma kutura ŋinaante arumonu kibeen eet ci anyak iju ci maamu. Oneec zin nɔɔnɔ zɛɛ been kɔrɔk ci akɔyi o. Ɔɔt zin enektek eet ci ceez nico o nɛ, Anekin gayoiti nɛ, Abil ceez ci ka kiiya kadakta ki nuyak ogan dayiin o vardaŋinto ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ŋaan zin ayelekuŋ tedec niini ceez ci alɔlani ci ɛɛnyci gɔɔn tadena, ma anyak kaal o ceezu dook, ka zin ɔɔtɔ utuguzi dayiin.” ");
INSERT INTO mur_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mazi avɔ niigi, ɔɔt didi ojokta kaal dook eona aduwakɛ Yesu nɔɔgɔ e. Utuguzɔ ni dayiin. ");
INSERT INTO mur_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mazi izi ŋinti ka kadaktɔi, ivita Yesu kibeen toonnyak ogin oogi, ma avu aavtiz niigi dook loota ka kadaktɔ. ");
INSERT INTO mur_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma anek niini nɔɔgɔ nɛ, “Ii baale laadun karooŋ naana iiten nico kiiya ka kozolit ki igeet dayiin ci vardaŋinto noko iŋaan kiiyayan piryakzɛt o. ");
INSERT INTO mur_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Didilɛ kaduwakuŋ igeet, alaŋ bodo kazɔl ki igeet dayiin ci ɛɛl kiyo nici noko zɛɛ ma kavɔ kazɔl dayiin o vardaŋinto een didi baliinte o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Odoma ni Yesu jayitot ci nyaanu, ma anyek Jook zany, ma azi nɛ, “Odomta jayitot nico iribanit niiga dook. ");
INSERT INTO mur_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Eeci alaŋ bodo kazɔl naana ki igeet nyaan nɔkɔ zɛɛ ma aku baliin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bodo adoma ḏokoc, ma anyek Jook zany, ma atɛɛt, ma anyek nɔɔgɔ kadayit, ma anek nɛ, “Nicini ɛlɛ onan anyonekuŋ igeet nɛɛn. Utuguz zin gɔɔn nɔkɔ ŋaati aadanaŋ aneet.” ");
INSERT INTO mur_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mazi adotiz dayiinta, anyek bodo Yesu nɔɔgɔ jayitot ci nyaanu ewe anek nɛ, “Ma jayitot nicini terkediin o colai o ka kɛɛlayuŋ Jooi igeet biyete ogan aḏuuti ŋaatunooŋ. ");
INSERT INTO mur_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mazin ɛɛti o ka kook kiiriyan aneet, karomena ki aneet ŋina ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Maje naana Ŋɛɛrti Eeto abon kadaai ebaal arek Jooi laadun, bar zin nɔŋ ci kol eete ci iirikan aneet o.” ");
INSERT INTO mur_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mazi azii niigi gi nico, ijintɔ niigi maany iziktɔ nɛ, “Ma dim ŋɛnɛɛn ŋaatinai ci ka kook kutuguwek nɔɔnɔ gi nico o?” ");
INSERT INTO mur_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma akanai daŋɔn nuyawɛ maany giye ci akati ŋɛnɛɛn ci adikir ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma anek Yesu nɔɔgɔ nɛ, “Gɔɔn alaata o loocu anyak dɔyiz ole ugeec abal. Ma awɛ niigi kizi ɔl ci titiny. ");
INSERT INTO mur_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bar zin ŋaatunooŋ alaŋ abon ŋaati agoonu buk niiga nɔkɔ. Ma ɛɛti ci adikir ŋaatunooŋ, abon niini abadaan ɛlɛ kizi kidic. Maje ɛɛti ci arayinuŋ igeet, abon anyek ɛlɛ kibil kiyo gabarɛnti o. ");
INSERT INTO mur_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yo gɔɔn adikir ɛɛti jaŋ? Adikir ɛɛti ci aavi loota olla arɛ dayiin kanyaayai o, yo da adikir ɛɛti ci anyaak nɔɔnɔ dayiin o? Ma ɛɛti ci aavi loota arɛ dayiin o eet o adikir nɛɛn. Bar zin inoko naana ŋaatunooŋ ŋina kabil kiyo gabarɛnti o. ");
INSERT INTO mur_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Igeet nɛɛn o amɛnanu karomɛ ki aneet iinya dook gidente onan. ");
INSERT INTO mur_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kanyuŋ zin tiŋeere naana igeet alaazɛt kiyo buk anyan baaba aneet o. ");
INSERT INTO mur_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kadake tiŋeere naana ki igeet, ma kawodɛ ki igeet baliinte onan. Ma aavtiyu katin niiga lecerene o ka apakti boryok o Israyil een amɔtɔ ram.” ");
INSERT INTO mur_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ma azi Manyi Yesu nɛ, “Saiman, Saiman, ziik di. Ojowa Loryen gɔl ci ka kitivanyuŋ igeet kiyo gɔɔn ivanyit ŋaa labi o. ");
INSERT INTO mur_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bar zin kijineyin naana ineet Jook ka calaŋ iina niina tuwente unun. Ka zin iitene ci abadakan niina aneet e, ka itiir gotonogu o tuwento kodoyit.” ");
INSERT INTO mur_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Manyi, kagama buk naana cabiin ci kacabin ki ineet, ma kadaai been ineet labak.” ");
INSERT INTO mur_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Bar abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Kaduwakin ineet Pitɔr, akɔ tija adaŋnyan niina aneet lak iiyu iŋaan kɔrɔk toloci.” ");
INSERT INTO mur_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Enek ni Yesu nɔɔgɔ nɛ, “Iiten baale mã kitoonuŋ igeet kɔkɔm guruc, ki kaboot ci dayiino, been caava e, anyak gi ci ɔɔt atamaatu tɔ?” Abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Akɔm kina.” ");
INSERT INTO mur_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma anek Yesu nɔɔgɔ nɛ, “Inoko zin kaduwakuŋ igeet, mã anyak ɛɛti guruc karabɔŋ een kaboon ci dayiino, abon adoma kanyak. Mã akɔm eet kabaz ci wun, abon ataalinɛ rum ka kataala kabaz. ");
INSERT INTO mur_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kaduwakuŋ igeet gi nico o, eeci iiya iiteni o ka kɛlɛɛmnyai gi baal akanan aneet baal aduwa nyakaŋanɛta waragewe o Joowo azi nɛ, “Akeebek katin ɔl nɔɔnɔ ɔl ween libjok.” Mazin didi kaala dook o ayɛɛt nyakaŋanɛta akanan aneet avɔ zɛɛ iina.” ");
INSERT INTO mur_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma anek nuyawa nɔɔnɔ nɛ, “Manyi, cin di. Kanyaka ŋaato kabazwa ci wuntik ram.” Abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Mɛɛlɛ nicigi alya.” ");
INSERT INTO mur_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma iŋaaz Yesu kutura, ma akɔ biye o kazi Kiŋiroc eonin laadun. Ma ɔrkɔr buk nuyawa ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mazi avɔ arum ŋinite, enek Yesu nuyak nɛ, “Ijinit Jook ka calaŋ iinanu kaale o acinanuŋ.” ");
INSERT INTO mur_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ma ooŋnek niini nɔɔgɔ looc, ma icak kidicilim, ma akɔ akani kozoŋti looc ajin Jook azi nɛ, ");
INSERT INTO mur_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Baaba, nyɛyi da piryakzɛt nico ŋaatan. Matɛ arooŋ, nyɛyi. Bar zin alaŋ een giye ci karɔɔŋɛ naana, bar olla tugu eo arɔɔŋɛ niina.” ");
INSERT INTO mur_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Iiyak ni nɔɔnɔ toonnyaiti ci Joowo, ma aku anyek nɔɔnɔ dɔyiz. ");
INSERT INTO mur_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma acirit nɔɔnɔ ziniz ɔrɔɔt ɛlɛ, ma abedonek ŋaryiin lak ci meel gɛr. Ma amolok kakat molowot tɔdɔ kiyo biyeta o. ");
INSERT INTO mur_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mazi adotiz ŋaryiinta, itiŋa imiirozek toonnyak, ma akɔ amɔda nɔɔgɔ bar oogin. Apirna niigi, eeci acirit nɔɔgɔ zinzeeti ɔrɔɔt giye ci aduwak Yesu nɔɔgɔ o. ");
INSERT INTO mur_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma anek Yesu nɔɔgɔ nɛ, “Ooginu naa? Itiŋgaz ijinit Jook ka calaŋ iinanu kaale o acinanuŋ.” ");
INSERT INTO mur_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Mazi ŋaan azɔɔz Yesu nɔkɔ, ivita kɔlɛ ci meelik. Arayan nɔɔgɔ Judaz ween nuyai codoi nuyawe ween amɔtɔ ram. Ma akunak niini Yesu, ma aku acoco nɔɔnɔ ŋalyamoc zaawinta. ");
INSERT INTO mur_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma ajin Yesu nɔɔnɔ anek nɛ, “Judaz, aku iirikan niina aneet Ŋɛɛrti Eeto ŋaati acucuyan ŋalyamoc?” ");
INSERT INTO mur_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mazi acin nuyawa oginɛ gi ci ka kakatai noko, ijinit niigi nɔɔnɔ enektek nɛ, “Manyi, keteŋeda nɔɔgɔ kabazwani labak?” ");
INSERT INTO mur_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma iŋaaz codoi ŋaatineeŋ, ma aŋɛdɛt gabaren ci alaan o adikir ceeze o Joowo kɛtɛɛda itat ci azo o por. ");
INSERT INTO mur_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ma anek Yesu nɔɔnɔ nɛ, “Bil di! Má ŋaan bodo abɛdɛkɛ.” Ma uum niini eet nico itat, ma alal nɔɔnɔ itati enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ijin ni Yesu alaat o ceez o Joowo, ki alaat o takirnya o ceez o Joowo, been ɔl o adikir avu ka kivita kagamit nɔɔnɔ enek nɛ, “Akɔ ma avunakaŋ kabazwani kibeen kɛɛni kiyo avunaku libjoi o naa? ");
INSERT INTO mur_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Baalyo karomɛ naana ki igeet ceeze ci Joowo noko tup nɔkɔ, ma ŋaan agamtaŋ. Inoko zin nici waŋi cunooŋ ajowanu niiga baliinte o Loryento.” ");
INSERT INTO mur_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Agamit ni niigi Yesu, ma avɔyi ole o alaan o adikir ceeze o Joowo. Maje Pitɔr ano nɔɔgɔ vurta rɛɛna kidicilim. ");
INSERT INTO mur_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Maje kɔrɔk kɛŋa ŋinaante anyak ɔl ci aavtiyɛ goo. Iiya ni Pitɔr, ma aku aromonek nɔɔgɔ aavɛ buk goo. ");
INSERT INTO mur_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mazi acin dole ceen gabaren ole nice Pitɔr aavɛ goo nɔkɔ, ɛgɛlɛm niini nɔɔnɔ, ma azi nɛ, “Ɛɛti nici buk gɔɔn ɔrkɔr ki Yesu.” ");
INSERT INTO mur_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma adaŋnyi Pitɔr azi nɛ, “Dole, alaŋ kaga eet nico been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bodo ŋintimiliny nɔkɔ iiyezin ɛɛti oman nɔɔnɔ, ma anek nɛ, “Een ri buk niina nuyai codoi nuyawe o eet nico.” Abɛdɛkɛ bodo Pitɔr nɔɔnɔ anek nɛ, “Akɔm ŋɛr, alaŋ keen nuyai cin.” ");
INSERT INTO mur_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Bodo ŋintimiliny nɔkɔ ɛbɛɛyɛ ɛɛti oman ɔrɔɔt ɛlɛ azi nɛ, “Ɛɛti nici nuyai ci Yesu gi, eeci niini buk een eet ci Galili.” ");
INSERT INTO mur_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma abɛdɛkɛ Pitɔr nɔɔnɔ anek nɛ, “Eet onaaŋ, alaŋ naana kaga zɔɔz ci aduwa o.” Mazi ŋaan azɔɔz niini nɔkɔ, ɔrɔk toloci. ");
INSERT INTO mur_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma abuudi Manyi Yesu, ma agɛlɛm nɔɔnɔ. Aada ni Pitɔr zɔɔz o Manyi Yesu baal anɛki nɔɔnɔ nɛ, “Adaŋnyan tiŋeere lak iiyu iŋaan kɔrɔk toloci e.” ");
INSERT INTO mur_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma adun Pitɔr akɔ kɔrɔk bawuca, ma aku alu ŋinaante ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Maje ɔl ci baal abɛk Yesu o, amomoz nɔɔnɔ. Abuŋ niigi nɔɔnɔ kɛbɛrɛ, ma aruk, ma bodo ajin anek nɛ, “Duwayet di! Ŋɛnɛɛn ci arukin o?” ");
INSERT INTO mur_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma aduwak buk niigi nɔɔnɔ zoozok ci meelik ɔrɔɔt ci adɔmi niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma ŋeere olotai ɔl o mayan baayizo, ki alaat o adikir ceeze o Joowo, been ɔl o ademzek ɔl lotinok. Anyaaktak ni ɔl nɔɔgɔ Yesu. ");
INSERT INTO mur_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma ajin niigi nɔɔnɔ anek nɛ, “Duwayet di, ma dim niina een Kiristo nɛɛn?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Mayo nuun inoko kaduwakuŋ, alaŋ atuyaŋ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Buk inoko mã kajinuŋ naana igeet gi oma, alaŋ abarzekaŋ. ");
INSERT INTO mur_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bar zin akatai waanico naana Ŋɛɛrti Eeto ŋaan kakɔ kaavi aziite o Joowo azo.” ");
INSERT INTO mur_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma azi niigi dook nɛ, “Een zin bɔŋ niina Ŋɛɛrti Joowo?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Nɛɛn ci aduwanu niiga o.” ");
INSERT INTO mur_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mazi azii niigi zɔɔz nico, izitɔ nɛ, “Alaŋaan bodo karɔɔŋ bacok, eeci kiziiyit naaga alya zoozok ogin otoge onin ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma iŋaaz ɔl dook, ma avɔyi Yesu alaane o kazi Pailat. ");
INSERT INTO mur_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma avɔ akana niigi kaal ci aŋanyi nɔɔnɔ, azi nɛ, “Kajowana eet nico ademzek ɔl gɔl ci gɛr. Anek niini ɔl nɛ, Má aruweku alaan o Rom adikir meeri. Ma bodo buk azi nɛ, Niini alya Kiristo nɛɛn. Anyek niini ɛlɛ kizi alaan.” ");
INSERT INTO mur_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma ajin Pailat nɔɔnɔ anek nɛ, “Ma niina een alaan o Juz nɛɛn?” Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Nɛɛn ci aduwa niina o.” ");
INSERT INTO mur_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Enek ni Pailat alaat o ceez o Joowo been kɔlɛ dook nɛ, “Akɔm naana gi ci gɛr kajowa eete nico ka kapayek nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mazi azi Pailat nɔkɔ, egerenyit niigi, bar ɛbɛɛktɛ ɔrɔɔt ɛlɛ azi nɛ, “Eet nico gɔɔn arumuz ɔl dook Judiya ŋina kɔɔyɔktɔ demziinte onin. Akana iiten baale laadun Galiliya zɛɛ makacin inoko iiya urumet ageet ŋina.” ");
INSERT INTO mur_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Mazi azii Pailat gi nico, ijinun ɔl enek nɛ, “Ma dim ɛɛti nici eet ci Galili?” ");
INSERT INTO mur_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Mazi akɔ aga niini Yesu eet ci Galili, itoonek nɔɔnɔ Erod o abal looc nice. Maje buk waanice Erod alya aavi Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Mazi akɔ acin Erod Yesu, atalɔ ɔrɔɔt ɛlɛ, eeci gɔɔn da azii niini kaviyak o akati Yesu rɛɛna, ma arɔɔŋ gɔl ci acini nɔɔnɔ ɔrɔɔt ɛlɛ. Arɔɔŋ niini kicin Yesu ŋaati agɔɔni kaal ci atɛɛt ɔl biye keberene ogin ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ijin ni niini Yesu kaal ci meel ɔrɔɔt. Maje bar Yesu akɔm gi codoi ci abarzek nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma iŋaaz alaata o ceez o Joowo been ɔl o gɔɔn ademzek ɔl lotinok o Juz, ma aduwa kaal ci akani Yesu vɔlɔŋa. ");
INSERT INTO mur_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Omomozit ni Erod been takirnya ogin Yesu, ma aminaŋi nɔɔnɔ. Ma aborcɛkɛ nɔɔnɔ rum ci alina momozɛnta, ma avɔyi nɔɔnɔ bodo ŋaati Pailat. ");
INSERT INTO mur_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Maje rak baale Pailat ki Erod amarnɔ. Ma iitene ci baal agami ɔl Yesu neke, izitɔ bodo laŋoten. ");
INSERT INTO mur_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Otowa ni Pailat alaat o ceez o Joowo, ki ɔl o mayan baayizo, kibeen buk ɔl oogi ŋaatodoi. ");
INSERT INTO mur_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma aku anek nɔɔgɔ nɛ, “Iiten baale rak anyaakaŋ eet nico aniyu nɛ, Ademzek niini ɔl gɔl ci gɛr. Mazi ona kajin nɔɔnɔ igeet kɛbɛrɛn ŋina noko, akɔm gi ci gɛr kajowa ŋaatin ebaal aduwanu niiga e. ");
INSERT INTO mur_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma buk Erod akɔm gi ci gɛr ajowa ŋaatin giye ci abadaket niini nɔɔnɔ ageet ŋina o. Akɔm zin ɛɛti nici gi ci gɛr agɔɔn ka kurukti naaga nɔɔnɔ kadaak. ");
INSERT INTO mur_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ŋaan zin olla kanyi takirnya kuruyit nɔɔnɔ nyaboyɛn zɛɛ ka koboroc kɔɔtɔ.” ");
INSERT INTO mur_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Maje gɔɔn laadun iitene o vardaŋinto ɔɔgak Pailat nɔɔgɔ eet codoi ole o acabje. ");
INSERT INTO mur_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Mazi azii kɔlɛ zɔɔz ci Pailat noko, egerenyit niigi dook azi nɛ, “Ruwɔ eet nico kadaak, bar ɔɔgayet Barabas.” ");
INSERT INTO mur_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Maje ɛɛti ci kazi Barabas noko, acabji niini zooze ci da ayɔwɔn ɔl kutura, ma aruwɛn ɛɛti oman kadaak. ");
INSERT INTO mur_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Maje Pailat arɔɔŋ kɔɔk Yesu kɔtɔɔ. Ma ajin niini kɔlɛ bodo zɔɔz ci ka kɔɔgi Yesu. ");
INSERT INTO mur_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bar enico egerenyit niigi dook iziti nɛ, “Tɔdɔ nɔɔnɔ kadaak! Tɔdɔ nɔɔnɔ kadaak talakeca!” ");
INSERT INTO mur_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma ajin Pailat nɔɔgɔ eceen lak iiyu o anek nɛ, “Agɔɔn dim ɛɛti nici gitaz ci gɛrzɛ o? Akɔm naana gi ci gɛr kajowa ŋaatin ka kapayɛkɛ nɔɔnɔ daayiz. Olla zin karooŋ nɔɔnɔ kɔrɔɔyɛ nyabowa doon zɛɛ ka kɔɔgɛ kɔtɔɔ.” ");
INSERT INTO mur_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Bar enico egerenyit niigi ɔrɔɔt ɛlɛ kujuk we azi nɛ, “Tɔdɔ nɔɔnɔ talakeca!” Nɔkɔ zɛɛ makacin apawun Pailat Yesu eci arɔɔŋi niigi o. ");
INSERT INTO mur_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma ɔɔgak nɔɔgɔ eet o arɔɔŋ niigi baal acabje yowonte o ayɔwɔn ɔl kutura, ma aruwɛn ɛɛti oman kadaak e. Ma anyek niini nɔɔgɔ Yesu ka kɔɔt kutuguzek niigi nɔɔnɔ gi o arɔɔŋ kutuguzek. ");
INSERT INTO mur_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ooti ni niigi Yesu. Mazi ŋaan awɔ gɔla nɔkɔ, urumtɔ ki eet ci kazi Saiman ci aluuga looce o kazi Sariin. Iŋaana niini ɔlɔ arɔɔŋ kiiyak Jerusalɛm. Agamit ni niigi nɔɔnɔ dɔyiza, ma anyek kitik kɛɛt ceen talakec o konowi Yesu vurta. ");
INSERT INTO mur_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma ano kɔlɛ ci meel gɛr Yesu. Buk kole nico anyak ŋaai ci ɔrkɔr ki nɔɔgɔ ci aluwek Yesu. ");
INSERT INTO mur_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Mazi azii Yesu ŋaai nicoko alu nɔkɔ, ubuut niini nɔɔgɔ, ma anek nɛ, “Ŋaai o Jerusalɛm, má aluwekaŋ aneet, bar utuluzek eleeti cugooc o ki dɔl ugooc. ");
INSERT INTO mur_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Eeci avu waanma iinya ci anɛ ɔl nɛ, Amayuk bar da Jooi ŋaai o awɔ koliin o ŋaan laadun kanyayit dɔl. ");
INSERT INTO mur_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma buk azi tiŋeere niigi iitene nice nɛ, Alaŋ kini iinaket biyɛn nici bar komonycet kɔɔtɔ ḏim ni. ");
INSERT INTO mur_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Eeci mã agoononekan aneet kaal ci gɛrzɛ noko, bar tiŋeere igeet agoononekuŋ kaal ci gɛrzɛ ɔrɔɔt kujuk can o.” ");
INSERT INTO mur_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mazin waanice avɔyi niigi Yesu kibeen ɔl ceen agoryak een ram ka kɔɔt kurukte buk niigi kadaayitɔ been nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mazi avu arum ŋinti kazi Amɛn ci Oowu, otodeec niigi Yesu kibeen ɔl ceen ram noko ŋinaante. Adɔdi codoi Yesu libire ci azo o, maje codoi adɔdi nɔɔnɔ libire ci kaŋeto o. ");
INSERT INTO mur_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma aŋaryɛ Yesu azi nɛ, “Baaba, aara nɔɔgɔ oŋec nico labak, eeci alaŋ aga niigi gi ci agɔɔn o.” Ma aŋerek takirnya eleeti rumanɛ o Yesu ŋaati agɔɔni niigi maadico. ");
INSERT INTO mur_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maje kɔlɛ ɛɛl agɛlɛm kaal ci agooni noko dook. Maje bar ɔl o Juz adikir amomoz Yesu anɔ nɛ, “Arogoz ri gɔɔn niini ɔl oogi. Mã een didi niini Kiristo o aŋɛra Jooi nɛɛn, anyek zin di kɛɛla ɛlɛ cin o maany.” ");
INSERT INTO mur_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Buk takirnya amomoz nɔɔnɔ. Anyaak niigi nɔɔnɔ nyaan ci gɛr acaŋkai, ma avu arikɛ otok. ");
INSERT INTO mur_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma anek nɛ, “Mã een didi alaan o Juz nɛɛn, ɛɛla di ɛlɛ cun o.” ");
INSERT INTO mur_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Maje kɛɛt ceen talakec adodinɛ Yesu o ayeedonek zɔɔz ci azi nɛ, “Nicini alaan o Juz.” ");
INSERT INTO mur_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Maje ɛɛti codoi ole ween agoryak adɔdi ki Yesu e amomoz buk niini Yesu azi nɛ, “Alaŋ een niina Kiristo? Ɛɛla zin ri ɛlɛ cun o kibeen buk ageeta.” ");
INSERT INTO mur_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Egerenyek ni gɔɔn ceeni nɔɔnɔ enek nɛ, “Alaŋ aŋole Jook? Apawoneket ageet daayizi kiyo niini o. ");
INSERT INTO mur_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Bar zin payiin cinai o alɛɛmnyai kaale ogaac kagɔɔn, maje ɛɛti nici akɔm gi ci gɛr agɔɔn kina.” ");
INSERT INTO mur_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma abuut niini Yesu, ma anek nɛ, “Má anyi kibiirin ɔɔ. Aadawan buk tiŋeere aneet iitene ci abadanɛ aku ɛɛnɛ alaan e.” ");
INSERT INTO mur_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Didilɛ kaduwakin ineet, tedec waanico ɛlɛ karomɛ naana ki ineet ŋaao rogeto.” ");
INSERT INTO mur_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma waaz iilya idiitɛ ii kalimik kizi lɔɔci dook muur gilinyik zɛɛ been ziik ween iiyu yomana. ");
INSERT INTO mur_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma areeci rum o gɔɔn aŋerin ceez o Joowo kɔrgɛna cac. ");
INSERT INTO mur_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma agɛrɛny Yesu ɔrɔɔt ɛlɛ azi nɛ, “Baaba, karekin vɔŋiz onan aziit unun.” Aduwa zɔɔz nico, ma atɛɛt enico ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Maje alaani ci takirnyawu aavi ŋinaante acin kaal nicoko nɔkɔ, ma anaat niini Jook azi nɛ, “Didilɛ, ɛɛti nici bar da eet ci abona ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mazi acin kɔlɛ ci ona aavtiz ŋinaante o dook kaal nicoko, imiirtozek korogjok ugeec ŋaati agami ooti iinoni Yesu. ");
INSERT INTO mur_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Maje ɔl ween laŋoten o Yesu dook, been ŋaai baal anowa nɔɔnɔ Galiliya e, aŋaamnek niigi dook kaal nicoko rɛɛna nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Maje waanice ŋinaante anyak eet ci kazi Josev ci abaak kuture o kazi Arimatiya abaai ɔl o Juz. Niini eet ci abona ɔrɔɔt ɛlɛ, ma arɛ niini waanice kuni o baliin o Joowo. Buk niini alya alaan codoi ole o roonnyo. Bar zin waanice alaŋ arɔɔŋ niini kaal ci gɛr arɔɔŋ kutuguzek gɔnɔgja Yesu o. ");
INSERT INTO mur_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ook ni niini alaani o kazi Pailat, ma akɔ ajin nɔɔnɔ ka kanyek Yesu kook kada. ");
INSERT INTO mur_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mazi akɔ aziiknek Pailat nɔɔnɔ kooyi Yesu, ook aara nɔɔnɔ keete ween talakec, ma aku amanocek rum ci abon zɛɛ ook ni arek bɔɔt ci abil biya ci ŋaan laadun akɔm eet ci adaai arek ɔl been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Maje waanice iiteni nica iiten ween jima ka tiŋeere kizi iiten ci ɔl o Juz yubzento kazi Sabit. ");
INSERT INTO mur_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Odomta ni ŋaai baal ɔrkɔra kibeen Yesu Galiliya e, orkorit buk ki Josev ɔɔt bɔɔta, ma avɔ acin ŋinti aronek Yesu o. ");
INSERT INTO mur_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ma amiironek niigi korogjok, ma avɔ agɔɔna karacɛnɛn ki karkarɛt ci ka kɔɔt kuvuudi ɛlɛ o Yesu bɔɔta. Ma iitene ween Sabit ayubuz niigi eo aduwan lotinowa. ");
INSERT INTO mur_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma iitene o yubzento ririwɔna oloyit ŋaai ooti karacɛnɛn ki karkarɛt baal agɔɔna e bɔɔta. ");
INSERT INTO mur_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mazi avɔ arum niigi ŋinite, bar acin bɛ baal abuŋi ɔl bɔɔt otok e aaryai bɔɔt otoga. ");
INSERT INTO mur_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mazi avɔ bɔɔta eecitɔ, ajowa ɛlɛ o Manyi Yesu iziitɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma abiir nɔɔgɔ ooti giye nico ɔrɔɔt ɛlɛ. Mazi ŋaan ɛlɛ niigi apaŋani nɔkɔ, bar acin ɔl ceen ram ci anyak rumanɛ ci vɔɔr pɛr eelnek nɔɔgɔ libira. ");
INSERT INTO mur_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ma aloc ŋaai ooti, eeci aŋole ɔl nicoko ɔrɔɔt ɛlɛ. Ma anek ɔl nici nɔɔgɔ nɛ, “Avu arooŋnyu eet ci arogi ŋaati ɔl ci adaai o naa? ");
INSERT INTO mur_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Azee zin niini ŋina tɔ. Itiŋa daayiza. Aada zɔɔz baal aduwakuŋ niini igeet iitene baal aavɛ Galiliya e. ");
INSERT INTO mur_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Waanice azi niini nɛ, Tiŋeere Ŋɛɛrti Eeto anyononek azɛɛn ci ɔl o oŋenu, ma avɔ adɔdɔ niigi nɔɔnɔ talakeca, ma iŋaaz niini bodo daayiza iinyaye ceen iiyu.” ");
INSERT INTO mur_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aada ni ŋaai didi zɔɔz onin baal aduwa e. ");
INSERT INTO mur_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Imiirte ni niigi, ma avɔ aduwak kaal nicoko dook nuyak ween amɔtɔ codoi kibeen buk ɔl o aromɛ ki nɔɔgɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ma ŋaai nicigi waanice awoyi Meri o looc o kazi Magdala, ki Jowana, ki Meri ween yaati Jemis. Ma avu aduwak niigi been buk ŋaai oogi toonnyak kaal nicoko. ");
INSERT INTO mur_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Maje toonnyawa bar apɛz gi ci aduwa ŋaai noko kizi gi ci labak, ma alaŋ arek niigi zinzeeti juruŋ. ");
INSERT INTO mur_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Itiŋa ni Pitɔr, ma adɔkɔny akɔ bɔɔta. Ma ŋinaante mazi ululi ka kɛgɛlɛm bɔɔt eecitɔ, bar acin rumanɛ doon, akɔm bodo gi oma kina. Ma amiiri akɔ ɔlɔ kibiir ɔɔ giye nico tɛt. ");
INSERT INTO mur_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ma iitene nice ɛlɛ itiŋgazɔ nuyawa ceen ram ɔɔtɔ kuture o kazi Ɛmɛyaz. Maje kuturi nica adɛwɔ ki Jerusalɛm kidicilim. ");
INSERT INTO mur_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma gɔla imicit niigi ozoozit zɔɔz ci akati kaal ci baal agooni Jerusalɛma neke. ");
INSERT INTO mur_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mazi ŋaan azɔɔzɔ nɔkɔ, iiya Yesu alya, ma aku ɔrkɔr kibeen nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Acin ŋɛdɛt niigi nɔɔnɔ ŋaati ɔrkɔri o nɔkɔ, bar anyak gi ci agargarɛn nɔɔgɔ kɛbɛrɛ calaŋ iiyez nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma anek Yesu nɔɔgɔ nɛ, “Ma dim gitaz ci azoozu gɔla ŋaan oke zɛɛ o?” Ma ɛɛl niigi ŋaati anyorani ŋumti. ");
INSERT INTO mur_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma ajin ɛɛti codoi ŋaatineeŋ ci kazi Kiliyopas nɔɔnɔ anek nɛ, “Een eet ci aavɛ Jerusalɛma maŋaan da ga kaal ci baal agooni iinya nicoko noko niina doon nɔkɔ?” ");
INSERT INTO mur_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Kalakaz da ci utuguze o?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Kaal baal agoononek Yesu o Nazarɛt e. Niini waanice nyakaŋan ci anyak dɔyiz ci appe ɔrɔɔt zɔɔza kibeen kaale o agɔɔn buk, ma agayi niini Joowa kibeen ɔla buk. ");
INSERT INTO mur_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ma bar ivita agamit nɔɔnɔ alaata o ceez o Joowo been alaat ogaacak abal ɔl, ma avɔyi nɔɔnɔ rooni ka kapawozek nɔɔnɔ daayizi zɛɛ makacin didi ɔɔt otodowit niigi nɔɔnɔ keete ween talakec. ");
INSERT INTO mur_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Maje naaga laadun kabaabana kaniya nɛ, Nɔɔnɔ nɛɛn o ka kiiya kɛɛla ɔl o Israyil. Bar zin inoko ɔɔt iinya iiyon ci adaai. ");
INSERT INTO mur_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ma adoma ŋaai cigaacak ogɛn alowonek bɔɔt uyen ŋeere ririwɔna, ma avɔ ajowa ɛlɛ onin iziitɔ bɔɔta. Ma avu ateedet niigi ageeta biye giye ci azi nɛ, Acin niigi toonnyak ci Joowo, ma anek nɔɔgɔ nɛ, Yesu oroga. ");
INSERT INTO mur_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bodo buk ivita ɔɔtɔ ɔl cigaacak ogɛn bɔɔta. Mazi avɔ abada, avu azi nɛ, Abil didi eona aduwan ŋaai e. Ŋaan kicinit buk niigi ɛlɛ o Yesu bɔɔta.” ");
INSERT INTO mur_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Enewun ni Yesu nɔɔgɔ nɛ, “Ma niiga eeginu tarbalɛ, ma alaŋ atuyu kaal baal aduwa nyakaŋanɛta e taman nɔkɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Udukta niigi baale laadun iziti nɛ, Kiristo abon rak apirna kaale nicoko dook iŋaan kook diŋdiŋonte onin.” ");
INSERT INTO mur_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma oobek Yesu nɔɔgɔ zoozok o akati nɔɔnɔ aduyai waragenyaye o Joowo dook, akana waragewe o ayɛɛt Mosis zɛɛ ma aṯornɛkɛ waragenyaye o ayɛɛt nyakaŋanɛta dook. ");
INSERT INTO mur_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mazi avɔ ajɔŋɔz niigi kutur ona laadun avɔyi e, utugu Yesu ɛlɛ kiyo ɛɛti o arɔɔŋ kidicek o. ");
INSERT INTO mur_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma alam niigi nɔɔnɔ anek nɛ, “Má adicei! Taŋu ŋaatinaaŋ ŋina, eeci izi lɔɔci baalin.” Ook ni niini ka kataŋu ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mazi avɔ aavtiz loota ka kadaktɔ, odoma Yesu ḏokoc, ma anyek Jook zany, ma atɛɛt, ma anyek nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Enico ɛlɛ okole nɔɔgɔ kɛbɛrɛ ugeecik, makacin agaac bar tɛ nici Yesu nɛɛn. Ŋinaanto izi Yesu ḏim nɔɔgɔ kɛbɛrɛn nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma anɔ ɔl nicigi nɛ, “Uyen laadun ma kɔrkɔra ki nɔɔnɔ gɔla, ma oobeket niini zoozok o akati waragɛ o Joowo e, akanet zɔɔz nica zinzeeti ɔrɔɔt ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma iŋaaz niigi enico ɛlɛ, ma amiironek Jerusalɛm, ma avɔ amɔda nuyak ween amɔtɔ codoi been gɔnɔgi ci tuwento oogi alotɛ ŋaatodoi. ");
INSERT INTO mur_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma anek nuyawa nɔɔgɔ nɛ, “Itiŋa didi Manyi daayiza! Eyelewun ɛlɛ Saiman.” ");
INSERT INTO mur_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Uduktak ni buk ɔl ci ona een ram o gɔnɔgi kaal ona acin gɔla e, ki zɔɔz o agayi niigi Yesu ŋaa ona atɛɛdɛkɛ niini nɔɔgɔ ḏokoc e. ");
INSERT INTO mur_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mazi ŋaan oobek ɔl nici gɔnɔgi zɔɔz nɔkɔ, bar acin niigi Yesu ɛlɛ ibil nɔɔgɔ kɔrgɛna. Ma azi nɛ, “Abonanu.” ");
INSERT INTO mur_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma ateedi nɔɔgɔ biyeta kanyayit ŋoliin ci appe ɔrɔɔt ɛlɛ, bar abaaban niigi anyek nɔɔnɔ kizi miniŋit. ");
INSERT INTO mur_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma anek Yesu nɔɔgɔ nɛ, “Anyaku ŋoliin naa? Ma da niiga abaabanu kizik bar alaŋaan kiŋaaz daayiza korok bodo? ");
INSERT INTO mur_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Egelemit zin di tobɛ ci kanyei azɛɛnɛ ki zɔɔnɛ o ka agayaŋ niiga didi nici aneeta ɛlɛ nɛɛn. Uumtaŋ buk ka agayaŋ juruŋ, eeci miniŋiti alaŋ anyak ɛlɛ ki amɛ kiyo acinaŋ kanyei naana o.” ");
INSERT INTO mur_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Azi nɔkɔ, ma ayelek nɔɔgɔ azɛɛn ki zɔɔ. ");
INSERT INTO mur_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mazi ŋaan anyek niigi kizi lutɛt nɔkɔ giye o aromi niigi talniin been ooti biirɛz, enek niini nɔɔgɔ nɛ, “Anyaku yo gi ci kadei tɔ ŋina?” ");
INSERT INTO mur_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma anyek niigi nɔɔnɔ kulugit ci aaki. ");
INSERT INTO mur_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma adak nɔɔgɔ kɔrgɛna ŋina. ");
INSERT INTO mur_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Enek ni niini nɔɔgɔ nɛ, “Iiten baal ŋaan kɔrkɔri ki igeet e, kuduwayuŋ kaal ci inoko ka kivita kutuguzozeyan aneet noko dook, eeci ka kɛlɛɛmtɛ zoozowa o akanan aneet ayeedi lotinowe o Mosis, ki zoozowe o ayɛɛt nyakaŋanɛta, been waragenyaye o beniinowu.” ");
INSERT INTO mur_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɔkɔl ni niini nɔɔgɔ ooti ka kagaac zoozok o aduwa waragɛnya o Joowo. ");
INSERT INTO mur_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ma anek nɔɔgɔ nɛ, “Ayeedi zin baale gi ci azi nɛ, Kiristo abon rak agide zɛɛ ŋaan bodo iŋaaz daayiza iinyaye ceen iiyu. ");
INSERT INTO mur_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma abon uuwaki kaviyawa o ka kabadi ɔl mony oŋene ugeec, ka kaara Jooi nɔɔgɔ oŋɛ ugeec zaare ogin, ka kakatai Jerusalɛma zɛɛ ma akɔ adala modɛn dook. ");
INSERT INTO mur_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Eeginu zin niiga bacok kaale nicoko dook. ");
INSERT INTO mur_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ŋaan zin kakɔ kitoonakuŋ gi o atɛrkɛt baaba ka kitoonayuŋ igeet. Abon zin rak arewinu Jerusalɛma ŋina zɛɛ ma akunakuŋ dɔyizi o Joowo.” ");
INSERT INTO mur_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Itiŋa ni Yesu Jerusalɛma arawɔi nɔɔgɔ ooyi ŋaati kazi Bezani. Ma ŋinaante ook odoŋun niini azɛɛn, ma amayuk nɔɔgɔ dook. ");
INSERT INTO mur_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Mazi ŋaan amayuk niini nɔɔgɔ nɔkɔ, ɔdɔŋɛ niini ki tammu taden. Otoŋek nɔɔgɔ looc ook niini tamma. ");
INSERT INTO mur_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Idiŋdiŋanit ni niigi nɔɔnɔ, ma abadaak Jerusalɛm talniinte ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma aavtiz gɔɔn niigi waanice iinya dook ceeze o Joowo anyek Jook zany.");
INSERT INTO mur_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Baale da laadun kinatamma e zɔɔz tɔ, ma zɔɔz nici aromɛ kibeen Jook. Mazin da zɔɔz nici Jook nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aromɛ baale laadun kinatamma e niini kibeen Jook. ");
INSERT INTO mur_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma ɛɛnycai kaal dook ŋaatin, ma akɔm gi codoi ṯɔr nɔkɔ calaŋ ɛɛnycai ŋaatin. ");
INSERT INTO mur_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma waanice zɔɔz nici rogɛt nɛɛn, ma rogɛti nici anyaak ɔl vooritin. ");
INSERT INTO mur_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma vooritin nici iiya otokol muur, ma ŋaan muuri kidiit nɔɔnɔ been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Anyak baale eet ci itoona Jooi ci kazi zaar nɛ Jɔn. ");
INSERT INTO mur_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aku niini ka kiiya kizi bacoi ci vooritino ka kutuweec ɔl dook vooritin nico. ");
INSERT INTO mur_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mazin niini alya alaŋ een vooritin nɛɛn, olla niini bacoi ci vooritino. ");
INSERT INTO mur_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mazin nici vooritin ween didi baal akunak looc ka kiiya kotokol ɔl dook e nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aavi waanice zɔɔz nici tɔ loota laadun, ma ɛɛnycai lɔɔci ŋaatin, ma bar ŋaan lɔɔci kaga nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Akunak niini ɔl ogin maany, ma ŋaan ɔl oginɛ alya kagamta nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Maje ɔl o agama nɔɔnɔ, ma atu zaar ogin anyek niini nɔɔgɔ dook dɔyiz kiziti dɔl ci Joowo. ");
INSERT INTO mur_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Alaŋ eegin niigi dɔl ci Joowo gole o aritan ɛɛti ci deer, bar eegin niigi dɔl cigin tiryante o Joowo. ");
INSERT INTO mur_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma zɔɔz nici otowɛ izi eet ci deer, ma iiya abaak niini ŋaatinai. Anyak niini dɛtɛn ki bonat ci appe. Kicinta naaga alya diŋdiŋɔn onin baal anyonek nɔɔnɔ giye o ɛɛnɛ niini ŋɛɛrti Joowo o adoi ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Uuwak waanice Jɔn ween bacoi onin azi nɛ, “Eet baal kaduwakuŋ kanekuŋ nɛ, Anowanan tiŋeere ɛɛti ci adiŋdiŋ ŋaatan e nɛɛn nici. Eeci aavi niini tɔ baale laadun iŋaan naana kitiryai e.” ");
INSERT INTO mur_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Mazin dɛtɛne onin adikir kojokta naaga dook mayuwɛnɛt ci appe. ");
INSERT INTO mur_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anyaa baale Jooi lotinok ŋaaten Mosis, maje dɛtɛni kibeen zɔɔz ween didi ajoyai ŋaaten Yesu Kiristo. ");
INSERT INTO mur_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Akɔm laadun eet ci icinun Jook. Bar ŋɛɛrin o adoi ṯɔr nɔkɔ o atobɔ ki nɔɔnɔ nɛɛn o anyewun nɔɔnɔ kagawɛ. ");
INSERT INTO mur_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ceeni zin bacokzɛt o Jɔn iitene baal itoonakɛ ɔl o Juz Jerusalɛma nɔɔnɔ alaat o ceez o Joowo been ɔl o kazi Livai ka kɔɔt kijinit niigi nɔɔnɔ kenektek nɛ, “Ma dim ineet ŋɛnɛɛn?” ");
INSERT INTO mur_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mazin Jɔn ŋaan kadaŋɔ, bar waanice aduwak niini nɔɔgɔ zɔɔz ci abil tɔp anek nɛ, “Alaŋ keen naana Kiristo o ka kiiya nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma ajin bodo niigi nɔɔnɔ anek nɛ, “Ineet zin ŋɛnɛɛn? Ineet Ilija?” Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Akɔm.” Ma bodo ajin niigi nɔɔnɔ anek nɛ, “Een bɔŋ nyakaŋan gi?” Ma abɛdɛkɛ Jɔn nɔɔnɔ anek nɛ, “Akɔm.” ");
INSERT INTO mur_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma vurta enektek niigi nɔɔnɔ nɛ, “Ineet zin ŋɛnɛɛn? Duwayet ka kɔɔt kuduktaya naaga ɔl ci ona itoonanet o zɔɔz ci akanin ineet.” ");
INSERT INTO mur_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Keen naana molok ci kuuwai balala ebaal aduwan nyakaŋani o kazi Izaya anɛ nɛ, Anyak tiŋeere molok ci uuwak balala azi nɛ, Amadek Manyi gɔl onin kibil tɔp e.” ");
INSERT INTO mur_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma ajin bodo ɔl o Parici nɔɔnɔ anek nɛ, ");
INSERT INTO mur_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Zin mã alaŋ een niina Kiristo, ma alaŋ een Ilija, ma buk alaŋ een nyakaŋan, oony zin ɔl naa?” ");
INSERT INTO mur_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Koony naana ɔl maami doon, bar zin anyak eet oma ŋaatunooŋ ci ŋaan niiga agaac. ");
INSERT INTO mur_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aku anowanan tiŋeere niini aneet vurta, ma alaŋ kaganona naana ŋaati kaborcanɛ nɔɔnɔ caava ogin zɔɔnɛ.” ");
INSERT INTO mur_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma kaala nicigi dook agooni ŋaao kazi Bezani liil o kazi Jordan libire ci jenu e ŋaabaal oonyi Jɔn ɔl e. ");
INSERT INTO mur_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ma iitene co icinun Jɔn Yesu akunak nɔɔnɔ, ma azi nɛ, “Icinit di nyɔɔn o Joowo aku ka kiiya kaara baciinok o loocu nici. ");
INSERT INTO mur_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Eet zin baal kaduwakuŋ kanekuŋ nɛ, Anowanan tiŋeere ɛɛti ci adiŋdiŋ ŋaatan e nɛɛn nici, eeci aavi niini tɔ baale laadun iŋaan naana kitiryai e. ");
INSERT INTO mur_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mazi naana alya ŋaan nɔɔnɔ kaga, olla zin naana kakun, ma koonyɛ maami o ka kagaac ɔl o Israyil nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma buk aduwa Jɔn zɔɔz ci azi nɛ, “Kacin iiten baale Vɔŋiz o Joowo akunak looc tamma kiyo yɛɛlac o, ma aku aavi ŋaatin. ");
INSERT INTO mur_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma naana alya ŋaan nɔɔnɔ kaga, bar zin Jooi o itoonanan aneet ka kiiya kotoony ɔl maami anekan nɛ, Acin tiŋeere Vɔŋiz o Joowo akunak looc tamma, ma aku aavi eete oman. Mazin ɛɛti nici eet o ka kotoony ɔl Vɔŋize o Joowo nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma azi Jɔn nɛ, “Kicina naana alya kaal nicoko. Inoko zin kanekuŋ nɛ, Ɛɛti nici ŋɛɛrti Joowo nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma iitene co bodo aromɛ Jɔn kibeen nuyak ogin een ram. ");
INSERT INTO mur_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mazi acin niini Yesu ŋaati awɔyi, izi nɛ, “Nyɔɔn o Joowo nica.” ");
INSERT INTO mur_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mazi azii nuyawa ceen ram noko zɔɔz nico, oneec niigi Yesu. ");
INSERT INTO mur_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mazi abuudi Yesu, acin nɔɔgɔ anowa nɔɔnɔ, ma ajin niini nɔɔgɔ anek nɛ, “Arooŋnyu naa?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Rabai, aavɛ ŋaa?” (Ma kɛŋ ci zaar nico kazi nɛ alaan o demziinto.) ");
INSERT INTO mur_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ivita ka icinit ŋinti kaavɛ o.” Maje ziiti izi ziik wec yomana. Ma ɔrkɔr niigi kibeen nɔɔnɔ zɛɛ been ŋin o aavɛ niini. Ma aromɛ niigi kibeen nɔɔnɔ iiten nice dook. ");
INSERT INTO mur_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma nuyawe ceen ram azii zɔɔz ci aduwa Jɔn, ma ano Yesu noko codoi ŋaatineeŋ Andoru ween gɔtɔni Saiman Pitɔr. ");
INSERT INTO mur_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kataman nɔkɔ ojowa Andoru gɔtɔni o kazi Saiman, ma anek nɔɔnɔ nɛ, “Kujuktawa Masaya.” (Ma kɛŋ ci kazi Masaya o kazi nɛ Kiristo ween ruguzoi.) ");
INSERT INTO mur_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ooyi ni niini Saiman ŋaati Yesu. Ma agɛlɛm Yesu Saiman, ma anek nɛ, “Saiman ŋɛɛrti Jɔn, inoko akatozeyin ineet zaara ci kazi Sivas.” (Ma zaara ci kazi Sivas o kibeen zaar ci kazi Pitɔr o akati kɛŋ cinɛ bɛ.) ");
INSERT INTO mur_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Ma iitene co ook Yesu looce o kazi Galili. Ma gɔla urumtɔ kibeen eet ci kazi Pilip. Maje Pilip laadun eet ci kutur o kazi Bezediya. Buk Andoru kibeen Pitɔr abaak kuture nice. Ma anek Yesu nɔɔnɔ nɛ, “Nowawan.” ");
INSERT INTO mur_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ma akɔ Pilip ŋaati Natanyɛl, ma anek niini nɔɔnɔ nɛ, “Kojoktawa eet baal ayɛɛt Mosis waragewe o lotinowu, ma ayɛɛt buk nyakaŋanɛta e. Niini Yesu ween ŋɛɛrti Josev o kutur o kazi Nazarɛt.” ");
INSERT INTO mur_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma ajin Natanyɛl Pilip anek nɛ, “Ma dim anyak gi ci abon didi ka kiiya Nazarakti?” ");
INSERT INTO mur_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Mazi akɔ acin Yesu Natanyɛl akunak nɔɔnɔ nɔkɔ, izi nɛ, “Eet zin ween Israyilen didi akɔm ŋaatin vɔlɔŋ nɛɛn nici.” ");
INSERT INTO mur_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ma ajin Natanyɛl Yesu anek nɛ, “Agayan ku?” Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Kicinin uyene ŋaa ona aavɛ loota raa moneeca iŋaan Pilip kotowawin e.” ");
INSERT INTO mur_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma abɛdɛkɛ Natanyɛl nɔɔnɔ anek nɛ, “Alaan o demziinto, een niina ŋɛɛrti Joowo. Ma een alaan o Israyil.” ");
INSERT INTO mur_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ma anek Yesu nɔɔnɔ nɛ, “Utuwɔ, eeci kanekin nɛ, kacinin uyen ŋaa ona aavɛ raa moneeca e? Ŋaan zin bar tiŋeere acin kaal ci adiŋdiŋ kujuk nicoko.” ");
INSERT INTO mur_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ma anek Yesu nɔɔgɔ dook nɛ, “Didilɛ kaduwakuŋ igeet, acinu tiŋeere niiga tammu taden akoli, ma acinu toonnyak o tammo avɔ tammu tadena, ma avunak looc ŋaaten Ŋɛɛrti Eeto.” ");
INSERT INTO mur_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ma iinyaye ceen iiyu anyak tiŋkawiin kuture o kazi Kana abil looce o kazi Galili. Maje yaati Yesu aavi buk ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma awo buk ɔl Yesu kibeen nuyak ogin ŋaati tiŋkawiinto noko. ");
INSERT INTO mur_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mazi akɔ adicai nyaani, enek Yesu yaatinɛ nɛ, “Ɔkɔma ɔl nyaan.” ");
INSERT INTO mur_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Alaŋ een zɔɔz cun. Ŋaan rak aneet iiteni onanɛ kiiya ka keyelek ɔl diŋdiŋɔn onan.” ");
INSERT INTO mur_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma anek yaati Yesu ɔl ceen gabara o nɛ, “Olla gi ci aduwakuŋ niini igeet odomta utuguz.” ");
INSERT INTO mur_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Maje ŋinaante anyak ijunya ceen tɔrkɔnɔm ci ɛɛnycai biyene ci gɔɔn arek ɔl o Juz maam ci ka kutuguzi niigi kɛɛr uneeŋ toonyento. Akɔyi gɔɔn iju codoi burwɛt eetoma karabɔŋ een eetoma kamɔtɔ. ");
INSERT INTO mur_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma anek Yesu gabara nɛ, “Ibitizit ijunya nicoko maami.” Ibitizit ni niigi ijunya maami tɔc. ");
INSERT INTO mur_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Enek ni Yesu bodo nɔɔgɔ nɛ, “Otogoca zin inoko ci miliny anycek eet ween abuu o tiŋkawiinto.” Otogocak ni zin didi niigi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mazi akɔ atar ɛɛti ceen abuu ci tiŋkawiinto noko maam ci utuye kizi nyaan noko, alaŋ aga ŋinti akuni nyaani nici o. Maje gabara ona agɔca maam e aga niigi nɔkɔ. Otowa ni ɛɛti ceen abuu ci tiŋkawiinto o eet ci arɔcɛ o. ");
INSERT INTO mur_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ma aku anek nɛ, “Gɔɔn ɔl dook anyaak rak kernok nyaan ci abon o ɔɔwa zɛɛ mazi ook abaaktɛ ɔl, anyaaktak ni niigi nɔɔgɔ nyaan o acaŋkai. Maje bar niina itaŋ rak nyaan ci abon o kibil zɛɛ anyaa ni vurta.” ");
INSERT INTO mur_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nicini zin gi o atɛɛt ɔl biyɛ agɔɔn Yesu ɔɔwa kuture o kazi Kana looce o kazi Galili nɛɛn, ma ayelzai waanice titinyɔni oninɛ. Makacin utuweec nuyawa oginɛ nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mazi akɔ adicai tiŋkawiin nici, ɔtɔɔzɔ Yesu ki yaatin kibeen gɔtɔnɔgi been nuyak ogin ɔɔtɔ kuture o kazi Kapernam, ma avɔ amɔn ŋinaante iinya ci miliny. ");
INSERT INTO mur_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mazi ka kiiya iiteni o ɔl o Juz gɔɔn aadanɛ niigi iiten baal vardaŋinto e, itiŋa Yesu ook Jerusalɛma. ");
INSERT INTO mur_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mazi akɔ arum niini kaluwa o ceez o Joowo, amada bar ɔl ci ataalinɛ tiin kibeen ɛɛza ki yɛɛla ŋinaante. Maje buk ɔl o abali guruc aavtiz loota ŋinaante tarabɛzɛtɛ. ");
INSERT INTO mur_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mazi acin niini nɔɔgɔ agɔɔn kaal nicoko, ook utuguwa nyabok ceen loro, ma aku aruwa ɔl ki tiin ki ɛɛza, ma atɔɔwak nɔɔgɔ dook bitaalin. Ma uup tarabɛzɛt kazaantɛ guruca ci ɔl o abali guruc e dook lai. ");
INSERT INTO mur_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma agerenyek niini ɔl o ataalinɛ yɛɛla anek nɛ, “Udunti yɛɛla nicoko bitaala. Má anyeku ceez ci baaba o kizi ŋinti taalinto.” ");
INSERT INTO mur_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aada ni nuyawa oginɛ zɔɔz o ayeedi waragewe o Joowo azi nɛ, “Ma reezinɛt o ceez unun avaadan aneet ziniz kiyo goo o.” ");
INSERT INTO mur_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Abadaak ni alaata o ɔl o Juz nɔɔnɔ, ma avu ajin anek nɛ, “Gitaz ci ateedet biye agooneket ka kagayin naaga ineet anyei alaazɛt ci agɔɔnɛ gi ci abil nɔkɔ o.” ");
INSERT INTO mur_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Oyoyit ceez ci Joowo noko. Ŋaan bodo keenyeti iinyaye ceen iiyu.” ");
INSERT INTO mur_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma anek niigi nɔɔnɔ nɛ, “Eenyeti iinyaye ceen iiyu ku? Ceez baal adica irkitok eet ram ki tiin tɔrkɔnɔm eenycinta e.” ");
INSERT INTO mur_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Zin waanice ceez ci Joowo aduwa Yesu o bar akati ɛlɛ onin maany. ");
INSERT INTO mur_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Mazi akɔ iŋaaz Yesu daayiza e, aada nuyawa oginɛ uduwa baale niini gi nico. Utuweec ni niigi waragɛ o Joowo akati nɔɔnɔ kibeen zɔɔz o aduwa Yesu. ");
INSERT INTO mur_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma ŋaabaal aavɛ Yesu Jerusalɛma iitene o vardaŋinto e, utuweec nɔɔnɔ ɔl ci meelik gɛr kaale o atɛɛt ɔl biye baal icinit niigi agɔɔn niini e. ");
INSERT INTO mur_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Maje bar Yesu alaŋ arek nɔɔgɔ ziniz juruŋ, eeci aga niini ɔl dook nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ma alaŋ arɔɔŋ niini eet ci aku aduwak nɔɔnɔ zɔɔz ci akati eet oma, eeci niini alya aga kaal o ɛɛl zinzeetine ugeec nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anyak baale eet ceen Pariciwen ci kazi zaar nɛ Nikodimos. Niini alaan ci Juz. ");
INSERT INTO mur_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ma baaline oman iiya ook ŋaati Yesu, ma akɔ anek nɔɔnɔ nɛ, “Alaan o demziinto, kagayin naaga ineet nɔkɔ een niina alaan ci demziinto itoonnyai Joowa. Eeci akɔm eet ci agɔɔn kaal ci atɛɛt ɔl biye kiyo ci agoon niina noko, dooke coma aavi Jooi ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Didilɛ kaduwakin ineet, akɔm eet ci acin baliin o Joowo, dooke coma aritai bodo niini kizi colak.” ");
INSERT INTO mur_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma ajin Nikodimos nɔɔnɔ anek nɛ, “Ka kitiryai ɛɛti ci idikir kizi colak bodo ku? Ka kimiirozek yaatin kɛŋ, ma bodo aritai?” ");
INSERT INTO mur_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Didilɛ kaduwakin ineet, mã alaŋ aritai ɛɛti maami kibeen Vɔŋize o Joowo, alaŋ baliin o Joowo ajowa been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mã ɛɛti ci aritai alye ci eet o deer, anyak niini ɛlɛ ci eet o deer. Maje ɛɛti ci aritai Vɔŋize o Joowo anyak niini Vɔŋiz o Joowo. ");
INSERT INTO mur_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Má anyi zin bar kibiirin ɔɔ giye ci kanekin nɛ, Abon aritanu niiga dook iziti colaye bodo o. ");
INSERT INTO mur_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Gɔɔn ŋɔɔti akɔla, ma iim olla libir ci tɛ arɔɔŋ niini. Ŋɛdɛt zin kazii molok ci olla ivaani o. Bar alaŋ kaga aku libire jaŋ, ma aku akɔ ki inin. Abil zin buk ɛɛti ci aritai Vɔŋize o Joowo o nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ma ajin Nikodimos Yesu anek nɛ, “Ka dim kibil gi nici nɔkɔ o ku?” ");
INSERT INTO mur_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Een niina alaan ci demziinto ole o Israyil. Alaŋ zin gi nico aga ku? ");
INSERT INTO mur_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Didilɛ kaduwakin ineet, naaga kaduwana kaal o kagaya, ma koobja kaal o kicinta. Maje bar niiga alaŋ arooŋnyu agamta zɔɔz onayaŋ. ");
INSERT INTO mur_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mayo ma kaduwakuŋ kaal ci loocu, ma alaŋ agamanu o, ma tedec ma kuduwakuŋ kaal ci tammu tadenu ka agamta ku? ");
INSERT INTO mur_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Akɔm zin laadun eet ci ook tamma, bar Ŋɛɛrti Eeto o aavi tamma nɛɛn o iiya tamma. ");
INSERT INTO mur_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Zin kiyo baale adɔŋ Mosis kowat ween ziit kɛɛta balala e, adoŋnyi buk tiŋeere Ŋɛɛrti Eeto nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ka ɛɛti ci atu nɔɔnɔ calaŋ adaai, bar ka kojowa niini rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ma giye o arɛɛzi Jooi looc ɔrɔɔt, anyek ŋɛɛrin o adoi ṯɔr nɔkɔ, ka ɛɛti ci atu nɔɔnɔ calaŋ adaai, bar ka niini kojowa rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ma Jooi alaŋ itoonak ŋɛɛrin looc ka kiiya kapayek looc gerzitin, bar ka korogoz looc. ");
INSERT INTO mur_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ma zin ɛɛti ci atu ŋɛɛrti Joowo alaŋ bodo nɔɔnɔ apawonek gerzitin, maje eet calaŋ atu nɔɔnɔ apawozek nɔɔnɔ gerzitin odota, eeci alaŋ niini atu ŋɛɛrti Joowo o adoi ṯɔr nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Apayek zin Jooi looc gerzitin o, eeci iiyak vooritin looc, maje bar ɔl arɛɛz muur kujuk vooritin, eeci agɔɔn niigi kaal ci gɛr. ");
INSERT INTO mur_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ma ɔl o gɔɔn agɔɔn kaal o gɛr abor niigi vooritin, ma alaŋ avunak vooritin been nɛɛn, eeci alaŋ arɔɔŋ niigi kaal ugeec gɛr agɔɔn keyelizyai. ");
INSERT INTO mur_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Maje ɛɛti ci agɔɔn kaal o arɔɔŋ Jooi dook akunak niini vooritin ka kayelizyai kaala o abon agɔɔn niini, eeci agɔɔn niini kaal o arɔɔŋ Jooi.” ");
INSERT INTO mur_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma vurta itiŋgaza Yesu kibeen nuyak ogin, ɔɔtɔ looce o kazi Judiya. Ma avɔ amɔn ŋinaante, ma oony ɔl. ");
INSERT INTO mur_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Maje buk waanice Jɔn oony ɔl ŋaao kazi Anon o ajɔŋzɔ ki ŋin o kazi Salim, eeci mɛɛlɛ maama ŋinaante. Ma avunak ɔl nɔɔnɔ tup nɔkɔ ŋinaante, ma oony niini nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma kaala nici agooni iŋaan Jɔn kacabɛ e. ");
INSERT INTO mur_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma iitene oman adaŋtɔ nuyawa o Jɔn ogɛnɛ kibeen eet ceen Juz giye ci akati kɛɛranɛ ugeec gɔɔn oonyi eleeti ka kobontai Joowa. ");
INSERT INTO mur_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Makacin ivitak niigi Jɔn, ma avu anek nɛ, “Alaan o demziinto, eet baal arumonu liile o Jordan baagita baal azi nɛ, Niini Kiristo e, inoko oony ɔl, ma avunak ɔl dook nɔɔnɔ. Yo zin gi nici abon?” ");
INSERT INTO mur_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma abɛdɛkɛ Jɔn nɔɔgɔ anek nɛ, “Akɔm laadun eet ci anyak dɔyiz mã alaŋ anyek Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ma zin niiga alya iziiktu zɔɔz baal kuduwakuŋ kanekuŋ nɛ, Alaŋ keen naana Kiristo, bar olla kitoonnyai nɔɔnɔ ɔɔwa e. ");
INSERT INTO mur_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Iziiktɔ di! Gɔɔn laadun nyatarani akati eet o aviica nɔɔnɔ. Maje laŋoti eet o aviica nyataran atalnɛ niini ŋaati aziiŋni eet o aroce molok. Inoko zin naana katalɔ ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Abon zin adiŋdiŋ Yesu ɔrɔɔt, maje naana keen cɛlbɛz. ");
INSERT INTO mur_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ma ɛɛti o aku tamma adikir niini kujuk ɔl dook. Ma ɛɛti o loocu niini eet ci loocu, ma azɔɔz niini kaal o loocu doon. Maje bar ɛɛti o aku tamma adikir niini ole dook. ");
INSERT INTO mur_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eeci aduwa niini kaal o icinun kibeen kaal o iziiwun tamma, ma bar akɔm eet ci agama zɔɔz cin o. ");
INSERT INTO mur_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Maje zin ɛɛti ci agama zɔɔz cin o niini bacoi ci ayelza gi o Jooi alaŋ ɛɛnɛ voloŋnyoi. ");
INSERT INTO mur_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma ɛɛti o itoona Jooi nɔɔnɔ anyaa niini zɔɔz o Joowo, eeci abitiz Jooi nɔɔnɔ Vɔŋize onin. ");
INSERT INTO mur_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Arɛɛz Jooi ŋɛɛrin, ma anyek kaal dook nɔɔnɔ kanyak niini aziite onin. ");
INSERT INTO mur_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma ɛɛti ci atu ŋɛɛrin ajowa rogɛt o abil been nɛɛn. Maje bar ɛɛti calaŋ ŋɛɛrin agama, alaŋ rogɛt acin, bar bornɛt nɔŋ o Joowo aavi ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Iziiyit ni ɔl o Parici awaŋ ci azi nɛ, Oony Yesu nuyak ci meel kujuk Jɔn. ");
INSERT INTO mur_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mazin bar giye ween didi Yesu alye onin akɔm eet ci oony, bar oony ɔl nuyawa oginɛ. ");
INSERT INTO mur_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mazi akɔ azii Yesu zɔɔz nico, otoŋ Judiya, ma abadaak Galili. ");
INSERT INTO mur_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma gɔla iiya idiir niini looc o kazi Samariya. ");
INSERT INTO mur_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma ŋinaante ook niini kuture o kazi Sikar o ajɔŋzɔ ki mana baal anyek Jakob ŋɛɛrin o kazi Josev e. ");
INSERT INTO mur_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Maje ṯuuwi o Jakob aavi ŋinaante. Aavu ni Yesu loota ŋinaante uyubuz ṯuuk otoga, eeci apirna niini ki weet. Maje ii ibilun boloca. ");
INSERT INTO mur_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Maje nuyawa oginɛ araktɛ ɔɔtɔ kuture nico ka kɔɔt kataalta dayiin. ");
INSERT INTO mur_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Iiya ni ŋaa ceen Samariyen arɔɔŋ kiiya kɔtɔgɔc maam. Ma anek Yesu nɔɔnɔ nɛ, “Nyan da maam ci kawudi.” ");
INSERT INTO mur_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma abɛdɛkɛ ŋaa nici Yesu anek nɛ, “Ma niina alaŋ een eet ci Juz? Ma naana alaŋ keen ŋaa ci Samariya? Ajinan zin maam ku?” (Azi ŋaa nici nɔkɔ o, eeci gɔɔn laadun ɔl o Juz alaŋ azɔlɔn diicit ci maamu kibeen ɔl ci Samariya.) ");
INSERT INTO mur_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Mã aga niina gi o gɔɔn anyek Jooi ɔl, ma agayaŋ buk niina aneet ci kajinin maam o keen ŋɛnɛɛn, abon waan ajinan ka kanyin ineet maam ci rogeto.” ");
INSERT INTO mur_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Mazin yo ma alaŋ anyei abala ci ka tɔgɔcai maam, ma wun ṯuuwi o, ka zin jai maam ci rogeto o ŋaaḏaŋ? ");
INSERT INTO mur_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Anyet baale ageeta ṯuuk nico jijitinaaŋ Jakob. Awot baale ṯuuk nico niini alya ki dɔl ogin ki tiin ogin. Ma zin yo niina adiŋdiŋ juk Jakob?” ");
INSERT INTO mur_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Ma ɛɛti ci awot maam nicoko aruk nɔɔnɔ kɔr bodo. ");
INSERT INTO mur_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Maje ɛɛti ci awot maam o kanyi naana nɔɔnɔ, alaŋ aruk kɔr bodo been nɛɛn. Eeci maama ci kanyi naana nɔɔnɔ o ɛɛl alye cin o kizi zawanec ci anyek nɔɔnɔ rogɛt ci abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Enek ni ŋaa nici nɔɔnɔ nɛ, “Alaan, nyan da maam nicoko ka calaŋ bodo arukan kɔr ka buk calaŋ bodo kabada kiiya kɔtɔgɔc maam ŋina.” ");
INSERT INTO mur_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma anek Yesu nɔɔnɔ nɛ, “Bitɔ towa eet unun ivita ŋina.” ");
INSERT INTO mur_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Akɔmnan eet.” Ma anek Yesu nɔɔnɔ nɛ, “Didi zin aleema zɔɔz ci azi nɛ, Akɔmnin eet o. ");
INSERT INTO mur_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Eeci arii baale lak tur, ma zin ɛɛti ci aavtiyu ki ineet inoko o alaŋ een eet cun. Aduwa zin didi niina zɔɔz ci aleem.” ");
INSERT INTO mur_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma anek ŋaa Yesu nɛ, “Alaan, kacinin ineet een inoko nyakaŋan. ");
INSERT INTO mur_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Baale jijitigaacak adiŋdiŋan Jook biye nico, maje bar niiga Juza aniyu nɛ, Abon een Jerusalɛm ŋinti ka kidiŋdiŋanti Jook nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma anek Yesu nɔɔnɔ nɛ, “Ziiyan di aneet! Aku tiŋeere iiteni calaŋ bodo adiŋdiŋani ɔl baaba biye nico karabɔŋ een Jerusalɛma doon. ");
INSERT INTO mur_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Adiŋdiŋanu niiga ɔl ci Samariya o gi calaŋ agayu, maje naaga kadiŋdiŋana gi ci kagaya, eeci rogzɛn aku ŋaaten Juz. ");
INSERT INTO mur_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aku zin tiŋeere iiteni, bar zin buk iiteni nica iiya laadun, ka zin ɔl o adiŋdiŋan Jook didi kidiŋdiŋanit nɔɔnɔ ween baaba vɔŋize onin kibeen zooze ween didi. Eeci arɔɔŋ Jooi ɔl kidiŋdiŋanit nɔɔnɔ gole nico. ");
INSERT INTO mur_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jooi niini vɔŋiz, ma ɔl o adiŋdiŋan nɔɔnɔ abon adiŋdiŋan nɔɔnɔ vɔŋiza kibeen zooze ween didi.” ");
INSERT INTO mur_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma anek ŋaa nɔɔnɔ nɛ, “Kaga ŋɛdɛt tiŋeere aku Masaya ween Kiristo. Zin tiŋeere mã iiya niini, ŋaan aku aduwaket kaal dook.” ");
INSERT INTO mur_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Aneeta Kiristo ɛlɛ nɛɛn ci kazɔɔzɔ ki ineet noko.” ");
INSERT INTO mur_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Mazi ŋaan azɔɔzɔ Yesu ki ŋaa nɔkɔ, abada nuyawa oginɛ. Mazi acin niigi Yesu azɔɔzɔ ki ŋaa nico, ibiirit nɔɔgɔ ooti giye nico ɔrɔɔt ɛlɛ. Bar akɔm ŋaatineeŋ ci anek ŋaa nɛ, “Arooŋ ŋaatin naa?” Karabɔŋ ajin Yesu anek nɛ, “Azoozonu ki ŋaa nico naa?” ");
INSERT INTO mur_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Otoŋek ni ŋaa iju onin maamu e looc, ma amiironek kɔrɔk, ma akɔ anek ɔl dook kuture uneeŋ ŋinaante nɛ, ");
INSERT INTO mur_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ivita di icinit eet ci aduwakan kaal ogan baal kagoon e dook ce. Bar bɔŋ niini Kiristo nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Udunta ni niigi korogjowɛ ivita ɔɔt icinit Yesu. ");
INSERT INTO mur_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Maje nuyawa anek Yesu nɛ, “Alaan o demziinto, ija, dawɔ.” ");
INSERT INTO mur_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bar abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Kanyei naana dayiin cigan calaŋ niiga agayu.” ");
INSERT INTO mur_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma ajinɔ nuyawa niigi maany anɔ nɛ, “Anyak tɛ eet ci anyawun nɔɔnɔ dayiin?” ");
INSERT INTO mur_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Dayiin cigan nɛɛn ci kagɔɔnɛ gi o arɔɔŋ ɛɛti o itoonanan aneet ka kidica liŋliŋɔn onin. ");
INSERT INTO mur_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Gɔɔn niiga anonu nɛ, Adica labina nyɛlɔwɛ wec kani kɛtɛɛdjai. Bar zin naana kanekuŋ nɛ, Icinit di manɛɛn. Inoko ibiiritɔ labina ka kɛtɛɛdjai. ");
INSERT INTO mur_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mazin gɔɔn eet ci ateedi aruwonek nɔɔnɔ vɔyita ci liŋliŋɔn onin ka kanyaak niini ɔl rogɛt o abil been nɛɛn. Ma atalnɛ ɛɛti o eevyi kibeen eet o ateedi buk. ");
INSERT INTO mur_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Alɛɛm zin olit o azi nɛ, Gɔɔn ɛɛti codoi aḏowɛ, maje ɛɛti oman ateedi. ");
INSERT INTO mur_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kitoonuŋ zin naana igeet ka ɔɔtɔ eteedit manɛɛn calaŋ aḏowanu niiga. Ipirta baale ɔl ogɛn liŋliŋonte nico. Ɔɔtɔ zin niiga ka ɔɔt eteedit manɛɛn ci baal ɛɛva niigi o.” ");
INSERT INTO mur_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Utuweec ni ɔl ci meelik ole o Samariya kuture nice Yesu, eeci anek ŋaa nɔɔgɔ nɛ, “Aduwakan ɛɛti nici kaal ogan baal kagoon e dook.” ");
INSERT INTO mur_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mazi avu arum ɔl ci Samariya noko Yesu, ilaltek niigi nɔɔnɔ kɔmɔn rak ŋaatineeŋ. Ɔmɔn ni Yesu ŋinaante iinya ram. ");
INSERT INTO mur_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Mazi adɛmɛz Yesu nɔɔgɔ, utuweec ɔl ci meelik nɔɔnɔ demziinte onin. ");
INSERT INTO mur_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma anek niigi ŋaa nɛ, “Alaŋ katuwena naaga giye o kaziikna ŋaatun doon, bar katuwena o, eeci kiziikta naaga alya nɔɔnɔ, ma kagawuta buk naaga alya didi niini Kiristo ween ruguzoi o loocu nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mazi adica Yesu iinya ram ŋinaante, itiŋa ook Galiliya. ");
INSERT INTO mur_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Eeci azi niini nɛ, “Akɔm laadun nyakaŋan ci adiŋdiŋan ɔl looce onin ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mazi akɔ arum Galili, atalta ɔl nɔɔnɔ ŋinaante, eeci icinit niigi kaal baal agɔɔn niini e dook iitene baal alotɛn ɔl Jerusalɛma aadanɛ iiten baal vardaŋinto e, eeci buk waanice niigi aavtiz lotente nice tɔ. ");
INSERT INTO mur_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Bodo enice imiirozek Yesu kutur o kazi Kana looce o kazi Galili ŋaabaal ookci niini maam kizi nyaan e. Maje ŋinaante anyak alaan ci amɔɔr ŋɛɛrin ŋaao kazi Kapernam. ");
INSERT INTO mur_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mazi akɔ azii alaani nici Yesu, itiŋawa Judiya, iiyak Galili. Iiyak niini nɔɔnɔ, ma ilalek nɔɔnɔ kook Kapernama ka kook korogoz ŋɛɛrin o arɔɔŋ kadaak ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ma anek Yesu nɔɔnɔ nɛ, “Niiga mã ŋaan ikivtek kaal ci ateeduŋ biye, alaŋ atuwenu.” ");
INSERT INTO mur_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ma ilalek alaani nici nɔɔnɔ anek nɛ, “Alaan, ija kiyiiyit taman iŋaan kadaak ŋɛɛran.” ");
INSERT INTO mur_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ma anek Yesu nɔɔnɔ nɛ, “Bitɔ labak! Alaŋ ŋɛɛrun adaai.” Utu ni alaani zɔɔz ci aduwak Yesu nɔkɔ o, ma awɔ. ");
INSERT INTO mur_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma gɔla iiya urumtɔ kibeen gabara ci aliŋliŋ ŋaatin, ma anek niigi nɔɔnɔ nɛ, “Urugun ŋɛɛrun.” ");
INSERT INTO mur_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma ajin niini nɔɔgɔ ka kuduktak nɔɔnɔ ziit ci da mayini dole o. Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Abada nɔɔnɔ ɛlɛ baritɔni balawaz ziite o adoi waaz.” ");
INSERT INTO mur_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma aada baati doleco nici ziit baal anɛkɛ Yesu nɔɔnɔ nɛ, “Bitɔ, labak, alaŋ ŋɛɛrun adaai e nɛɛn.” Utuyɔ ni niini kibeen ɔl o kɔrɔk onin dook. ");
INSERT INTO mur_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mazin enico izi lak ram ci agɔɔni Yesu kaal ci atɛɛt ɔl biye eo abadaan niini Judiya akunakɛ Galili e. ");
INSERT INTO mur_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma iitene oman anyak ɔl o Juz micit cineeŋ alotɛn Jerusalɛma. Ook ni buk Yesu ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Maje Jerusalɛma ŋinaante anyak lamurḏen ci ajɔŋɔz araan o azawu. Kazi lamurḏen nico zooze o ɔl o Juz nɛ Bazaaz. Anyak lamurḏenti nici ceezi ceen riinya tur. ");
INSERT INTO mur_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Maje riinyaye nicoko oogin ɔl ci meelik gɛr ole o rubenik ki ole ci ŋɔɔlik been ole ci rɛbrɛbik. ");
INSERT INTO mur_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Eeci waanice gɔɔn toonnyaiti ci Joowo iinyaye ogɛn aku, ma iinak lamurḏen nico, ma amɔɔni maam. Mazi adɔkɔny ɛɛti, ma iinak maam ɔl ɔɔwa iŋaan amɔɔt maama, arogzɛ niini moorizowe ogin dook. ");
INSERT INTO mur_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma ole nicoko anyak eet ci amɔɔr irkitok eetoma kamɔtɔ ki tiin turge. ");
INSERT INTO mur_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mazi akɔ acin Yesu nɔɔnɔ ɔɔŋ loota nɔkɔ, agawun niini nɔɔnɔ anyak mɔɔriz ŋinti wun ɔrɔɔt. Ma ajin Yesu nɔɔnɔ anek nɛ, “Arooŋ rogɔ mɔɔrize cun noko?” ");
INSERT INTO mur_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma abɛdɛkɛ ɛɛti ci amɔɔr noko nɔɔnɔ anek nɛ, “Alaan, akɔm eet ci ka kooyan lamurḏenta ŋaati gɔɔn tɛ amɔɔni maama. Gɔɔn maŋaan kawɔ gɔla, arawun bar tɛ ɛɛti oman lamurḏen.” ");
INSERT INTO mur_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma anek Yesu nɔɔnɔ nɛ, “Tiŋa je. Doma kuwen cun o, tɔ.” ");
INSERT INTO mur_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kataman nɔkɔ urugun ɛɛti nici, ma adoma kuwen onin, ma awɔ. Maje waanice iiteni nica iiten o yubzento. ");
INSERT INTO mur_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ma anek ɔl o Juz eet ci ona arogzɛ o nɛ, “Nicini iiten o yubzento. Alaŋ zin aganɔ lotinowe ogaac ŋaati ilolɛ kuwen cun o noko.” ");
INSERT INTO mur_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ma abɛdɛkɛ ɛɛti nici nɔɔgɔ anek nɛ, “Anekan ɛɛti ci uyen aruguzan o nɛ, Doma kuwen cun o, tɔ.” ");
INSERT INTO mur_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma ajin niigi nɔɔnɔ anek nɛ, “Eet jaŋ ci anekin nɛ, Doma kuwen cun o, tɔ, o?” ");
INSERT INTO mur_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Maje ɛɛti nici alya ŋaan kaga ŋɛnɛɛn ci arogoz nɔɔnɔ o, eeci Yesu ɔɔtɔ ŋaao aavtiyɛ kɔlɛ e. ");
INSERT INTO mur_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma ŋintimiliny ook ojowa Yesu nɔɔnɔ kaluwawe o ceez o Joowo, ma anek niini nɔɔnɔ nɛ, “Inoko urugu mɔɔriza. Tɛɛdɔi zin baciinok ka calaŋ bodo akunakin gi ci gɛrzɛ ɔrɔɔt kujuk nice.” ");
INSERT INTO mur_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ook ni ɛɛti nici uduwak alaat o Juz gi ci anek nɛ, “Bar tɛ ci arogozan o Yesu gi.” ");
INSERT INTO mur_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Gi zin baal laadun amarnin alaata o Juz Yesu, ma arɔɔŋ kurukti niigi nɔɔnɔ kadaak e nɛɛn, eeci aliŋliŋ niini iitene o yubzento. ");
INSERT INTO mur_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma anek Yesu nɔɔgɔ nɛ, “Ma baaba gɔɔn laadun aliŋliŋ niini iinya dook nɔkɔ. Abon zin buk naana kaliŋliŋ kiyo niini o.” ");
INSERT INTO mur_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bar enico otobortek alaata o Juz Yesu nɔŋ ɔrɔɔt, ma arɔɔŋ gɔl ci ka kurukti niigi nɔɔnɔ kadaak. Alaŋ een giye ci baal aliŋliŋi iitene ceen Sabit o doon, bar eeci azi Yesu nɛ, Jooi baatin gi, ma atobzek buk niini ɛlɛ Jook. ");
INSERT INTO mur_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, akɔm ŋɛɛrti Joowo gi ci agɔɔn oowe cin doon, bar agɔɔn niini kaal o acin agɔɔn baatinɛ. Mazin kaal o agɔɔn baatinɛ nɛɛn o agɔɔn buk ŋɛɛrin. ");
INSERT INTO mur_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Eeci Jooi arɛɛz ŋɛɛrin, ma ayelek nɔɔnɔ kaal o gɔɔn agɔɔn niini dook. Bar zin bodo buk tiŋeere ayelek niini nɔɔnɔ kutugu kaal ci adiŋdiŋ ɔrɔɔt kujuk nicoko, ka kibiirtuŋ igeet dook ooti. ");
INSERT INTO mur_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Kiyo gɔɔn iŋaani Jooi ɔl daayiza, ma anyek bodo nɔɔgɔ korogit o, buk tiŋeere ŋɛɛrin agɔɔn nɔkɔ. Anyek rogɛt eet ci olla tɛ arɔɔŋ niini kanyek. ");
INSERT INTO mur_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Akɔm baatinɛ eet ci ka kapak, bar anyewun ŋɛɛrin dɔyiz ci ka kapayi ɔl dook niini. ");
INSERT INTO mur_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ka zin ɔl dook kidiŋdiŋanit ŋɛɛrin kiyo adiŋdiŋan niigi baatin o. Ma ɛɛti calaŋ adiŋdiŋan ŋɛɛrin, alaŋ buk adiŋdiŋan niini baatin o itoona nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Didilɛ kaduwakuŋ igeet, ma ɛɛti ci azii zɔɔz o kaduwa, ma atu Jook o itoonanan aneet, anyak niini rogɛt o abil been nɛɛn. Ma alaŋ tiŋeere nɔɔnɔ apawonek gerzitin, bar atayaŋun niini daayiz laadun ook rogɛta. ");
INSERT INTO mur_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Didilɛ kaduwakuŋ igeet, aku iima iiteni, bar zin buk iiteni nica iiya laadun. Ma iitene nice azii ɔl o adaayitɔ molok o ŋɛɛrti Joowo, ma ɔl o azii nɔɔnɔ dook arogi. ");
INSERT INTO mur_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Zin kiyo Jooi alye onin een gɔl ci rogeto o anyek buk niini ŋɛɛrin kizi gɔl ci rogeto. ");
INSERT INTO mur_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Anyewun zin niini nɔɔnɔ alaazɛt ci ka kapai ɔl giye o ɛɛnɛ niini Ŋɛɛrti Eeto. ");
INSERT INTO mur_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Anyak tiŋeere iiten ci aku ci aziikni ɔl o adaayitɔ dook looknyai molok onin. Má anyeku zin kibiirtuŋ ooti giye nico. ");
INSERT INTO mur_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mazin iitene nice aduŋna ɔl o da gɔɔn agɔɔn kaal o abon looknyai, ma arogi rogɛt o abil been nɛɛn. Maje ɔl o da gɔɔn agɔɔn kaal o gɛr apawonek nɔɔgɔ gerzitin. ");
INSERT INTO mur_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Akɔm zin gi ci kagoon naana oowe can doon, bar kapai naana kaal eo aduwakan Jooi aneet. Ma payiin cane o abil tɔp, eeci alaŋ kataman kutugu gi ci karooŋ naana, bar kagoon eo arɔɔŋi baaba o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Matɛ waan kizi bacoi ci kazɔɔzɛ ɛlɛ cano maany, alaŋ waan kaleem, ma kaala ci kaduwa o alaŋ waan aganɔ ŋaati agamnyan. ");
INSERT INTO mur_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bar zin anyak eet oma ceen bacoi can. Ma kaga naana zɔɔz o aduwa niini ŋaaten aneet zɔɔz ceen didi. ");
INSERT INTO mur_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Itoonteyu baale niiga ɔl Jɔn, ma aduwa waanice niini zɔɔz ween didi. ");
INSERT INTO mur_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Alaŋ zin karooŋ naana bacokzɛt ci eet ci deer, bar olla kaduwakuŋ zɔɔz nico o ka coma arognu. ");
INSERT INTO mur_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Baale Jɔn abil niini kiyo tokolɛci o gɔɔn ataran looc o, ma waanice ataltowu niiga vooritine onin ŋinbaal miliny e. ");
INSERT INTO mur_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Bar zin naana alya kanyei bacoi ci adikir kujuk Jɔn. Ma kaala ci kagoon naana o kaal ci anyan baaba aneet ka kutugu. Mazin kaala nicigi bacok cigan gi, ma ayelzakuŋ igeet gi o itoonanan baaba aneet. ");
INSERT INTO mur_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma baaba o itoonanan aneet niini alya bacoi can. Ŋaan niiga iziiyit molok onin, karabɔŋ acinu ŋum onin. ");
INSERT INTO mur_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Azee zin zɔɔz oninɛ zinzeetine ugooc tɔ, eeci alaŋ atuyaŋ niiga aneet o itoonan niini. ");
INSERT INTO mur_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ɔɔtɔ zin di ekeebit waragɛnya o Joowo, eeci gɔɔn abaabanu niiga aniyu nɛ, Ajowanu rogɛt o abil been nɛɛn ŋaatineeŋ. Ma waragɛnya nicigi alya azɔɔz zɔɔz ci akanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Maje bar niiga alaŋ arooŋnyu ivitayaŋ aneet ka ojokta rogɛt. ");
INSERT INTO mur_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Alaŋ naana karooŋ titinyɔn ɔla. ");
INSERT INTO mur_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ma buk kagayuŋ naana igeet alaŋ areezu Jook zinzeetine ugooc. ");
INSERT INTO mur_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naana kakun alaazete o baaba, ma ŋaan agamtawaŋ. Bar mã anyak eet oma ci aku alaazete cin doon, agamanu niiga nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ka zin yo utuyɔ ku, mã areezu niiga ŋaati anaatonu eleetine ugooc maany, maje bar naatinɛt o aku Joowe o adoi ṯɔr nɔkɔ alaŋ arooŋnyu o? ");
INSERT INTO mur_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Má abaabanu kizik bar tiŋeere kakɔ kakɔlakuŋ naana igeet rooni ŋaati baaba. Bar zin akɔ akɔlakuŋ tiŋeere igeet rooni Mosis o atuyu niiga nɔɔnɔ zinzeeti ugooc. ");
INSERT INTO mur_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mã da didi utuweec zɔɔz o Mosis, utuyaŋ waan buk aneet, eeci Mosis eteyeedun zɔɔz o akanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mazi yo ma ŋaan agamta zoozok o ayɛɛt niini o, ka zin agamta zoozok ci kaduwakuŋ naana o ku?” ");
INSERT INTO mur_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma vurte nice abaayiz Yesu liil o Galili ook baagita. (Kazi liil nico zaar nɛ Tiberas.) ");
INSERT INTO mur_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma ano kɔlɛ ci appe nɔɔnɔ, eeci icinit niigi kaal o atɛɛt ɔl biye baal agɔɔn niini arogzi ɔl o amɔɔr e. ");
INSERT INTO mur_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Otoodit ni Yesu been nuyak ogin bɛ taden, ma avɔ aavtiz loota ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Maje iiteni o gɔɔn anyayi ɔl o Juz lotɛn uneeŋ vardaŋinto izi ajɔn. ");
INSERT INTO mur_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Mazi adɔŋ Yesu ɔɔ, acin kɔlɛ ci meel avunak nɔɔnɔ. Ijinun ni Pilip enek nɛ, “Kayo kataalta dayiin ci alɛɛnɔ ki ɔl nicoko dook ŋaa?” ");
INSERT INTO mur_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Aduwa niini gi nico o arɔɔŋ kicina Pilip. Maje niini laadun aga gi ci ka kutugu nɔkɔ.) ");
INSERT INTO mur_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma abɛdɛkɛ Pilip nɔɔnɔ anek nɛ, “Arɔɔŋ guruc ceen kaboot ram ka nuun kojowa ɛɛti codoi ŋaatineeŋ dayiin ci miliny.” ");
INSERT INTO mur_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma anek Andoru ween nuyai onin een gɔtɔni Saiman Pitɔr nɛ, ");
INSERT INTO mur_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Anyak logo ci anyak ḏɔkɛn ceen tur kibeen kuluk ci miliny een ram ŋaato. Ka zin yo dayiin ci miliny tɛr noko kutuguwek ɔl ci meelik noko naa?” ");
INSERT INTO mur_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma anek Yesu nɔɔgɔ nɛ, “Anycek ɔl kaavtiyɔ loota.” Maje ŋinita ŋinti aliz anyak artɛ ci colai. Aavtiyɔ ni ɔl loota. Maje ɔl nici dook een eet amɔtɔ lak tur lɛlɛn tur (5000). ");
INSERT INTO mur_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Odoma ni Yesu ḏɔkɛn, ma anyek Jook zany, ma anyek nuyak ogin ka keŋeryek ɔl. Ma adoma bodo kuluk, ma anyek ɔl ewe. Ma adake ɔl dook zɛɛ ma anyɛr. ");
INSERT INTO mur_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mazi ook ipiiyantɛ ɔl dook, enek Yesu nuyak nɛ, “Uluta dayiin ci anyigjai o kɔkɔm ci ooŋneku looc.” ");
INSERT INTO mur_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma alota niigi ŋodota ci anyigjai o zɛɛ makacin ibitizit gilanya amɔtɔ ram ŋodotaye ci anyigjai ḏokene ween tur adak ɔl e. ");
INSERT INTO mur_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mazi avɔ acin ɔl gi ci abiirni nɔɔgɔ ooti agɔɔn Yesu noko, izitɔ nɛ, “Izi didi tɛ nicini nyakaŋan baal ka kiiyak looc e nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mazi akɔ aga Yesu arɔɔŋ niigi kagamit nɔɔnɔ ka kanycek kizi alaan dɔyiza, itiŋa ook biyɛnɛ niini doon. ");
INSERT INTO mur_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma yomana ɔɔt nuyawa oginɛ liila. ");
INSERT INTO mur_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma avɔ atɔɔt kavool, ma abaayiz liil ka kɔɔtɔ Kapernama. Mazi ŋaan awɔ liil kɛŋa nɔkɔ, izi lɔɔci baalin. Maje Yesu ŋaan kurum nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Maje ŋɔɔti ci appe ivaan, ma ayɛlyɛlan maam ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mazi ŋaan awɔ niigi liil kɛŋa nɔkɔ, icinit niigi Yesu awoya maam tadena iima nɔɔgɔ. Anyayit ni niigi ŋoliin ɔrɔɔt ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma anek Yesu nɔɔgɔ nɛ, “Má aŋolinu looc! Aneeta gi.” ");
INSERT INTO mur_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma atalnɛ niigi, ma atoodek nɔɔnɔ kavool. Ŋintimiliny nɔkɔ urum kavooli dɔwɔn ci ŋin ona avunak niigi laadun e. ");
INSERT INTO mur_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ma ŋeeretine co icinit kɔlɛ baal ooŋnonek looc liil baagita e ɔɔtɔ kavooli baal abil ŋinaante e. Maje niigi aga ŋaan Yesu korkorit been nuyak ogin kavoole nice, bar aga otoŋtek niigi nɔɔnɔ looc. ");
INSERT INTO mur_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Maje bodo kavoolɛta ogɛnɛ avu looce o kazi Tiberas zɛɛ ma avu ajɔŋɔz liiltok ŋinbaal adayi ɔl ḏɔkɛn baal anyek nɔɔgɔ Yesu ŋaabaal anyekɛ rak niini Jook zany e. ");
INSERT INTO mur_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mazi avɔ acin ɔl Yesu kibeen nuyak ogin azeetɔ ŋinaante, otoodit niigi kavoolɛt nicoko ɔɔt Kapernama ka kɔɔt korooŋit Yesu. ");
INSERT INTO mur_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Mazi avɔ ajowa niigi Yesu liil baagita, enektek nɔɔnɔ nɛ, “Alaan o demziinto, akunai ŋinito waŋa?” ");
INSERT INTO mur_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, alaŋ niiga arooŋnyaŋ aneet giye ci agayu kaal baal kagoon atɛɛt ɔl biye e, bar arooŋnyaŋ o giye ci ḏɔkɛn baal adaku zɛɛ ma anyernu e. ");
INSERT INTO mur_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Má aliŋliŋnyu zin dayiin o gɔɔn ame, bar iliŋliŋit dayiin o ɛɛl kodot ween rogɛt o abil been nɛɛn. Nici zin dayiin o ka tiŋeere kanyuŋ Ŋɛɛrti Eeto igeet nɛɛn, eeci agama Jooi ween baatinai liŋliŋɔn onin.” ");
INSERT INTO mur_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ma ajin niigi nɔɔnɔ anek nɛ, “Mayo zin kutuguza gitaz ci arooŋnyet Jooi ageeta kutuguza o?” ");
INSERT INTO mur_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Liŋliŋɔn o Joowo arɔɔŋ ŋaatunooŋ nɛɛn ci atuyu eet o itoona niini nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Inoko gitaz ci agoon atɛɛt ɔl biye kacina ka kanyet kutuyin ineet o? ");
INSERT INTO mur_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Baale adak jijitigaacak dayiin o kazi mana balala kiyo aduwa waragɛwi o Joowo azi nɛ, Anyek baale niini nɔɔgɔ ḏɔkɛn ci tammu tadenu kadayit.” ");
INSERT INTO mur_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, ma ḏokoc baal adaku aku tamma e, alaŋ een Mosis nɛɛn o anyuŋ igeet, bar baaba nɛɛn o anyuŋ igeet. Inoko zin bar anyuŋ niini igeet ḏokoc ween didi o aku tammu tadena. ");
INSERT INTO mur_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Eeci ḏokoc o anyuŋ Jooi nɛɛn o akunak looc tammu tadena ka kanyek looc rogɛt.” ");
INSERT INTO mur_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Alaan, nyet zin da gɔɔn ḏokoc nico tup nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ma anek Yesu nɔɔgɔ nɛ, “Aneeta nɛɛn o keen ḏokoc o rogeto. Ma ɛɛti ci akunakan aneet alaŋ bodo nɔɔnɔ adak magiz. Ma ɛɛti ci atuyan aneet alaŋ bodo nɔɔnɔ aruk kɔr been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Zin kiyo uyene kaduwakuŋ igeet ka icintaŋ aneet e, bar ŋaan utuyaŋ nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mazin ɛɛti o anyan baaba aneet ŋaan akunakan. Ma eet ci akunakan aneet alaŋ naana katooi. ");
INSERT INTO mur_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Eeci kakun naana tammu tadena looc o ka kiiya kutugu gi o arɔɔŋ ɛɛti o itoonanan aneet, alaŋ ka kiiya kutugu gi ci ɔɔ can doon. ");
INSERT INTO mur_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Gi zin o arɔɔŋ baaba o itoonanan aneet nɛɛn ce. Arooŋnyan niini aneet calaŋ kakuluz eet codoi ole o anyan niini aneet. Bar abon kaŋaanɛ naana nɔɔgɔ daayiza iitene ci aṯornɛkɛ lɔɔci e. ");
INSERT INTO mur_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Arɔɔŋ ɛɛti o itoonanan aneet ɔl dook o acin ŋɛɛrin, ma atu nɔɔnɔ, kojokta rogɛt o abil been nɛɛn. Ŋaan zin kaŋaanɛ naana nɔɔgɔ iitene ci aṯornɛkɛ lɔɔci e.” ");
INSERT INTO mur_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Enico otoŋomit ɔl o Juz Yesu, eeci azi nɛ, Niini ḏokoc ci akunak looc tammu tadena. ");
INSERT INTO mur_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma anɔ nɛ, “Ma dim nici alaŋ een Yesu ween ŋɛɛrti Josev nɛɛn o kaga naaga dook baatin kibeen yaatin o? Azi zin nɛ, Kakun tammu tadena kakunai looc o, ku?” ");
INSERT INTO mur_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma anek Yesu nɔɔgɔ nɛ, “Otoŋit ŋomtiin cunooŋ o. ");
INSERT INTO mur_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Akɔm eet ci akunakan aneet, dooke coma anyaakan nɔɔnɔ baaba o itoonanan aneet, ka zin kitiŋawi naana nɔɔnɔ iitene ci aṯornɛkɛ lɔɔci e. ");
INSERT INTO mur_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ayɛɛt baale nyakaŋanɛta zɔɔz ci azi nɛ, Adɛmɛz waanma Jooi ɔl dook. Ma ɛɛti ci azii baaba, ma ɛdɛmzɛ niini ŋaatin, akunakan aneet. ");
INSERT INTO mur_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Alaŋ zin bar zɔɔz nico akati kɛŋ cinɛ gi ci anyawun eet ci icinun baatinai, bar eet o aku Joowa nɛɛn o icinun nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Didilɛ kaduwakuŋ igeet, ma ɛɛti ci atuwe ajowa niini rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Zin aneeta nɛɛn o keen ḏokoc o rogeto. ");
INSERT INTO mur_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Baale jijitugooc adayit dayiin o kazi mana baal iina tammu tadena balala e, ma bar niigi waanice ŋaan adaai labak. ");
INSERT INTO mur_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mazin bar nicini ḏokoc o akunak looc tammu tadena ka kadak ɛɛti ci deer, ma alaŋ bodo adaai. ");
INSERT INTO mur_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Keen zin naana ḏokoc o rogeto o akunak looc tammu tadena nɛɛn. Ma ɛɛti ci adak ḏokoc nico, orok niini izi nɛɛn. Ma ḏokoc ci kanyi naana nɔɔnɔ o ɛlɛ onan kanyi looc ka kojoktai ɔl rogɛt nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Zin zooze nico adaŋtɔ ɔl o Juz niigi maany bornɛt nɔŋa anɔ nɛ, “Ma dim ɛɛti nici ka kanyet ɛlɛ cino kadayit ku?” ");
INSERT INTO mur_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, mã alaŋ adaku ɛlɛ ci Ŋɛɛrti Eeto o, ma alaŋ awudu biye ogin, alaŋ ajowanu rogɛt o abil been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma ɛɛti ci adak ɛlɛ can o, ma awot biye cigan o, ajowa niini rogɛt o abil been nɛɛn, ma kaŋaanɛ katin naana nɔɔnɔ korok iitene ci aṯornɛkɛ lɔɔci e. ");
INSERT INTO mur_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Eeci ɛlɛ cane o dayiin ween didi, maje biyeta cigane o kodɛn ween didi. ");
INSERT INTO mur_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma ɛɛti ci adak ɛlɛ can o, ma awot biye cigan o, aavi niini ŋaatan, ma kaavɛ naana ŋaatin buk. ");
INSERT INTO mur_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Zin baaba o itoonanan aneet nɛɛn o anyek rogɛt ɔl dook, ma anyan buk niini rogɛt aneet. Mazin buk gole nico kanyi naana rogɛt ɔl o adak ɛlɛ onan. ");
INSERT INTO mur_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nici zin ḏokoc o akunak looc tammu tadena nɛɛn. Alaŋ atobɔ niini kibeen ḏɔkɛn o kazi mana baal adak jijitugooc, ma bodo adaai labak e. Mazin ɛɛti ci adak ḏokoc nico ojowa niini rogɛt o abil been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ma kaal nicoko aduwa Yesu ŋaati adɛmzi ɔl ceeze o lotento kuture o kazi Kapernam e. ");
INSERT INTO mur_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Mazi avɔ azii nuyawa ci meel nuyawe ogin zɔɔz nico, izitɔ nɛ, “Demziin nici adɔi kak, ka zin yo tedec kiziik ŋɛnɛ?” ");
INSERT INTO mur_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Agawun ni Yesu zɔɔz ci aŋɔmtɔn niigi noko niini doon. Ma anek nɔɔgɔ nɛ, “Izi igeet zinzeeti gɛrzɛ giye nico? ");
INSERT INTO mur_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ma tiŋeere ma acinu Ŋɛɛrti Eeto amiironek tammu taden ŋinbaal aavɛ niini laadun e ka kibil ku? ");
INSERT INTO mur_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Anyaa zin rogɛt Vɔŋizi o Joowo. Maje dɔyizi ci eet ci deer gi ci labak. Mazin zoozowa ci kaduwakuŋ naana o anyaakuŋ igeet Vɔŋiz kibeen rogɛt. ");
INSERT INTO mur_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bar zin ɔl ogɛnɛ ŋaatunooŋ alaŋ atuwe.” (Ma Yesu niini laadun kinatamma e aga ɔl o tiŋeere alaŋ atuwe kibeen eet o ka kiiya kataalɔi nɔɔnɔ nɔkɔ.) ");
INSERT INTO mur_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma azi Yesu nɛ, “Gi zin nɛɛn o kanekuŋ nɛ, Akɔm eet ci akunakan aneet, dooke coma akɔlak nɔɔnɔ gɔl ci ka kiiyakan o baaba e.” ");
INSERT INTO mur_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma giye nico imiirye nuyawa ci meel nuyawe ogin ki vurut alaŋaan arɔɔŋ korkorit ki nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma ajin Yesu nuyak ogin een amɔtɔ ram anek nɛ, “Arooŋnyu buk niiga ɔtɔɔz?” ");
INSERT INTO mur_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma abɛdɛkɛ Saiman Pitɔr nɔɔnɔ anek nɛ, “Manyi, ka koota ŋaati ŋɛnɛ? Rogɛt o abil been nɛɛn anyei niina. ");
INSERT INTO mur_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Kutuyin naaga itoonnyai niina Joowa.” ");
INSERT INTO mur_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ een aneet nɛɛn ci kaŋeranuŋ igeet ci eeginu amɔtɔ ram noko? Bar anyak zin eet codoi ŋaatunooŋ ceen Loryen.” ");
INSERT INTO mur_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aduwa niini gi nico o ariik niini Judaz ween ŋɛɛrti Saiman Iskariat baal ka kook kataalɔi nɔɔnɔ e, ma niini waanice nuyai codoi nuyawe o Yesu een amɔtɔ ram. ");
INSERT INTO mur_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma vurte nice otono Yesu Galili doon. Alaŋaan arɔɔŋ kɛɛrɔn kook Judiya, eeci alaata o Juz arɔɔŋ kuruyit nɔɔnɔ ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Maje iiteni o gɔɔn aadanɛ ɔl o Juz ceezi baal abaai niigi balala e izi ajɔn. ");
INSERT INTO mur_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ma anek gɔtɔnɔgja nɔɔnɔ nɛ, “Toŋ ŋinito. Tɔ bitɔ Judiya ka kɔɔt kicinit nuyawa ugune kaal cugun agoon o. ");
INSERT INTO mur_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Akɔm eet ci arɔɔt liŋliŋɔn cin mã arɔɔŋ niini ka kagawɛ juruŋ. Zin giye o agɔɔnɛ kaal nicoko abon ayelei ɛlɛ ɔl dook loota ka kagayin niigi ineet.” ");
INSERT INTO mur_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aduwa niigi gi nico o, eeci ma een nuun nɔɔgɔ ɛlɛ ween gɔtɔnɔgi ŋaan buk kutuwit nɔɔnɔ nɔkɔ buk. ");
INSERT INTO mur_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ŋaan bai iiteni onane kiiya, olla ŋaatunooŋ iinya dook abon labak. ");
INSERT INTO mur_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ma ɔl o loocu alaŋ amarninuŋ igeet, bar amarninan niigi aneet, eeci kabɔrai naana nɔɔgɔ kaal o gɛr gɔɔn agɔɔn niigi. ");
INSERT INTO mur_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɔɔtɔ niiga lotɛnta labak. Alaŋ naana kakɔ, eeci ŋaan iiteni onane kiiya.” ");
INSERT INTO mur_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aduwa niini gi nico, ma aavi rak Galiliya. ");
INSERT INTO mur_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mazi akɔ avɔ gɔtɔnɔgja lotɛn Jerusalɛma, unuwun bodo buk niini nɔɔgɔ vurta calaŋ ayelzak ɛlɛ ɔl. ");
INSERT INTO mur_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Maje alaata o Juz arɔɔŋ nɔɔnɔ ole ci ona avunak lotɛn o. Ma ajinɔ anɔ nɛ, “Eet we inoo?” ");
INSERT INTO mur_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma aŋɔmtɔ ɔl ogɛn anɔ nɛ, “Niini eet ci abon.” Maje ceegi anɔ nɛ, “Ku? Alaŋ abon, eeci alabek niini ɔl tuu.” ");
INSERT INTO mur_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bar akɔm eet ci azɔɔz nɔɔnɔ kiziiyɛ, eeci aŋole niigi alaat o Juz. ");
INSERT INTO mur_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mazi ŋaan kidicai iinya o lotento nɔkɔ, ook Yesu kaluwawe o ceez o Joowo, ma akɔ adɛmɛz ɔl. ");
INSERT INTO mur_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mazi akɔ azɔɔz niini, ibiirit alaat o Juz ooti ɔrɔɔt ɛlɛ, ma anɔ nɛ, “Ma ɛɛti nici aga kaal nicoko dook ku maŋaan kɛdɛmɛzɔ o?” ");
INSERT INTO mur_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ma kaala ci kademzekuŋ naana igeet o alaŋ een cigan, bar kaal ci eet o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ma zin ɛɛti o arɔɔŋ kutugu gi o arɔɔŋ Jooi, ŋaan aga niini mã een kaala ci kademzekuŋ igeet o kaal ci avu Joowa, karabɔŋ bar kazooz naana oowe can doon. ");
INSERT INTO mur_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bar zin gɔɔn ɛɛti ci azɔɔz dɔyize ci ɛlɛ cin doon, arɔɔŋ niini kojowa titinyɔn ci ɛlɛ onin. Maje bar ɛɛti ci arooŋek titinyɔn eet o itoona nɔɔnɔ, azɔɔz niini gi ween didi, ma akɔm gi ci avɔlŋa. ");
INSERT INTO mur_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Baale ŋaan kanyuŋ Mosis igeet lotinok o Joowo, ma bar akɔm ŋaatunooŋ eet codoi ci agama. Arooŋnyan zin uruktaŋ aneet kadaak o naa?” ");
INSERT INTO mur_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma abɛdɛkɛ kɔlɛ nɔɔnɔ anek nɛ, “Anyei niina Loryen alya. Ŋɛnɛɛn ci tɛ arɔɔŋ kuruyin ineet o?” ");
INSERT INTO mur_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Iiten baale anyak gi codoi adikir kagoon, ma abiirnuŋ igeet dook ooti. ");
INSERT INTO mur_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Baale uduwayuŋ Mosis igeet zɔɔz o teedinto. Mazin bar buk nica alaŋ een zɔɔz ci Mosis, bar zɔɔz baal jijitugooc, ma waanice gɔɔn ateedu dɔl iitene ween Sabit. ");
INSERT INTO mur_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mazi da gɔɔn ma abon ŋaatunooŋ labak ŋaati ateedinɛ dɔlya iitene ween Sabit ka calaŋ abaci lotinok o Mosis, abornekaŋ zin aneet nɔŋ ŋaati karogzɛ eet iiten ceen Sabit o naa? ");
INSERT INTO mur_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Má apaku zin zoozok olla giye ci akat ɛlɛ eci bitaalu, bar apayit zɔɔz gole ci abil tɔp.” ");
INSERT INTO mur_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma azi ɔl ogɛnɛ ole o Jerusalɛm nɛ, “Ma dim nici alaŋ een eet o arɔɔŋ alaata nɔɔnɔ kuruyit kadaak e nɛɛn? ");
INSERT INTO mur_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Icinit di ŋaati azɔɔzi kɔla labak, ma akɔm eet ci aduwak nɔɔnɔ gi ci gɛr. Agaac bɔŋ alaata izi didi niini Kiristo o ka kiiya nɛɛn? ");
INSERT INTO mur_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ku zin yo koca? Ma kaga naaga dook ŋinti akuni ɛɛti nici o? Bar zin tiŋeere ma aku Kiristo, akɔm eet ci aga ŋinti katin akuni niini o.” ");
INSERT INTO mur_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Mazi akɔ adɛmɛz Yesu ɔl kaluwawe o ceez o Joowo, ɛgɛrɛny niini molowe ci appe izi nɛ, “Inoko dim niiga agayaŋ aneet ŋɛnɛɛn? Yo buk inoko ŋinti kakunɛ o agayu? Alaŋ zin naana kakun dɔyize can doon. Itoonanan aneet baaba ween Jook ween didi. Ma alaŋ niiga agayu nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bar zin naana kaga nɔɔnɔ, eeci kakun naana ŋaatin. Nɔɔnɔ nɛɛn o itoonanan aneet.” ");
INSERT INTO mur_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Zin giye nico orooŋit alaata ka kagamit nɔɔnɔ, bar akɔm eet ci anim kuum nɔɔnɔ, eeci ŋaan iiteni oninɛ kiiya. ");
INSERT INTO mur_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Maje ɔl ci meel utuweec nɔɔnɔ, ma anɔ nɛ, “Ma dim tiŋeere ma aku Kiristo, agɔɔn kaal ci atɛɛt ɔl biye kujuk ci agɔɔn ɛɛti nici o?” ");
INSERT INTO mur_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mazi avɔ azii ɔl o Parici kɔlɛ aŋɔmɔt Yesu nɔkɔ, itoonit niigi kibeen alaat o ceez o lotento takirnya kɔɔt kagamit nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma azi Yesu nɛ, “Ŋaan rak karomɛ ki igeet ŋintimiliny. Zin ŋaan kakɔ ŋaati baaba o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Arooŋnyaŋ waanma niiga aneet, ma bar alaŋ ajowanaŋ, eeci ŋinti tiŋeere kaavɛ naana e alaŋ niiga animnyu ɔɔtɔ.” ");
INSERT INTO mur_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma anɔ alaata o Juz niigi maany nɛ, “Ŋinḏaŋ ci dim arɔɔŋ niini ka kooyi zɛɛ ma alaŋ kanim naaga kojoktai nɔɔnɔ o? Arɔɔŋ bɔŋ kook loocowe o abaai ɔl ween Garik ka kook kɛdɛmɛz nɔɔgɔ? ");
INSERT INTO mur_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uyene rak azi nɛ, Katin karɔɔŋ naaga nɔɔnɔ, bar alaŋ kajowa. Ma bodo azi nɛ, Ma ŋinti ka kooyi niini o alaŋ kanim naaga kɔɔtɔ. Ma zɔɔz nici akati kɛŋ cinɛ gitaz?” ");
INSERT INTO mur_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mazi akɔ een iiten o aṯornɛkɛ lotɛn o adikir, itiŋa Yesu jena, ma azɔɔz molowe ci appe azi nɛ, “Mã alam eet ci aruk kɔr, anyek nɔɔnɔ kiiyayan ka kowodɛ. ");
INSERT INTO mur_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kiyo azi waragɛwi o Joowo nɛ, Mã anyak eet ci atuyan aneet, zinize cino ariik maama ci rogeto.” ");
INSERT INTO mur_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Zin Yesu ŋina azɔɔz zɔɔz o akati Vɔŋiz o ka kanyek Jooi ɔl o atu nɔɔnɔ. Maje waanice Vɔŋizi ŋaan kanyozozek ɔl, eeci Yesu ŋaan buk kitiŋa daayiza ka kanyozozek nɔɔnɔ diŋdiŋɔni. ");
INSERT INTO mur_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Mazi avɔ azii ɔl ogɛn zɔɔz o Yesu, izitɔ nɛ, “Didi ri ɛɛti nici nyakaŋan ci Joowo gi.” ");
INSERT INTO mur_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Maje ɔl ogɛn anɔ nɛ, “Niini ri Kiristo gi.” Bar bodo ogɛn azi nɛ, “Alaŋ Kiristo ka kiiya Galiliya. ");
INSERT INTO mur_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Azi waragɛwi o Joowo nɛ, Aku katin Kiristo dolene ci dɔl o Devid. Aritai zin katin niini kuture o kazi Bɛzilɛm baal abaai Devid e.” ");
INSERT INTO mur_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Zin giye nico ɛŋɛrtɔ ɔl kɔrgɛna giye ci akati Yesu. ");
INSERT INTO mur_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ɔl ogɛn arɔɔŋ kagamit nɔɔnɔ, bar akɔm eet ci ataadek nɔɔnɔ aziit kagam. ");
INSERT INTO mur_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mazi avɔ amiiri takirnya, ɔɔt ijinit alaata o ceez o Joowo kibeen ɔl o Parici nɔɔgɔ enektek nɛ, “Alaŋaan anyaanu naa?” ");
INSERT INTO mur_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma abɛdɛkɛ niigi nɔɔgɔ anek nɛ, “Ŋaan baal rɛɛn akɔm eet ci azɔɔz kiyo ɛɛti nici o.” ");
INSERT INTO mur_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma abɛdɛkɛ ɔl o Parici nɔɔgɔ anek nɛ, “Alabawuŋ niini igeet buk. ");
INSERT INTO mur_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Inoko alam eet codoi ŋaatinaaŋ karabɔŋ een alaate o Juz ci atu nɔɔnɔ tɔ? ");
INSERT INTO mur_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma ɔl ci azii zɔɔz cin o alaŋ aga niigi lotinok o Mosis. Inoko zin niigi anyak toriin o Joowo.” ");
INSERT INTO mur_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ma anek ɛɛti codoi ŋaatineeŋ ci kazi Nikodimos baal rak akɔ ŋaati Yesu e nɔɔgɔ nɛ, ");
INSERT INTO mur_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gɔɔn lotinowa ogaac alaŋ anyet kapaktek eet gerzitin maŋaan kiziiyit gi ci aduwa niini otoge onin ɛlɛ.” ");
INSERT INTO mur_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Awaaŋ! Een buk niina eet ci Galili? Kɛɛp zin di waragɛ o Joowo ka ga akɔm laadun nyakaŋan ci ka kiiya Galiliya.” ");
INSERT INTO mur_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Enico azaantozek ɔl dook korogjok ugeecik. ");
INSERT INTO mur_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ook ni Yesu biye o kazi Kiŋiroc. ");
INSERT INTO mur_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma ŋeere ririwɔna abadaak kaluwa o ceez o Joowo. Ma avunak kɔlɛ ci meel nɔɔnɔ, ma aavi niini loota, ma adɛmɛz nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma anyaak alaata o adɛmɛz ɔl lotinok kibeen ɔl o Parici ŋaa ci agamnyi zoocmaza. Ma avu anyek niigi ŋaa nico kibil nɔɔgɔ dook ŋuma. ");
INSERT INTO mur_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma anek Yesu nɛ, “Alaan o demziinto, nicini ŋaa ci agamnyi zoocmaza. ");
INSERT INTO mur_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma zin lotinowa o Mosis azi nɛ, Ŋaa ci agamnyi kiyo nici abon avac ɔl nɔɔnɔ biyɛnɛ zɛɛ ma adaai. Mayo zin inoko niina azi giye nico nɛ?” ");
INSERT INTO mur_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aduwa niigi gi nico o, eeci arɔɔŋ kedetit Yesu ka kojokta gɔl ci agami nɔɔnɔ ka kɔkɔltakɛ rooni. Bar Yesu ululi, ma ayɛɛt looc komolita. ");
INSERT INTO mur_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mazi ŋaan ajin niigi Yesu nɔkɔ, adɔŋ niini ɔɔ, ma anek nɔɔgɔ nɛ, “Mã anyak ŋaatunooŋ eet ci ŋaan kabaca baciinok, anycek rak nɔɔnɔ kodoma bɛ ɔɔwa ka kavac ŋaa nico.” ");
INSERT INTO mur_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Zin ulule bodo, ma ayɛɛt looc komolita. ");
INSERT INTO mur_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mazi avɔ azii niigi zɔɔz nico, iniyit ɔtɔɔzɔ niigi dook kidicilim codoi codoi, akana ole o adikir zɛɛ been o miliny buk. Makacin otoŋtek niigi looc Yesu ki ŋaa we doon. ");
INSERT INTO mur_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mazi akɔ adɔŋa Yesu ɔɔ, ɔkɔma eet ci acin. Ma anek niini ŋaa nico nɛ, “Ɔl oke ŋaa? Ɔkɔma ŋaatineeŋ eet codoi aavi ka kapayeyin gerzitin?” ");
INSERT INTO mur_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma abɛdɛkɛ ŋaa nɔɔnɔ anek nɛ, “Akɔm kina, alaan.” Enek ni Yesu nɔɔnɔ nɛ, “Alaŋ zin buk naana kapayekin ineet gerzitin. Bitɔ zin, ma ŋaan bodo abaca oŋɛ.” ");
INSERT INTO mur_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ma azoozek Yesu ɔl bodo anek nɛ, “Keen naana vooritin ci loocu. Mã anuyan ɛɛti aneet, anyak niini vooritin o rogeto, ma alaŋ bodo niini awɔ muura.” ");
INSERT INTO mur_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma anek ɔl o Parici nɔɔnɔ nɛ, “Inoko niina oobi kaal ci akati ɛlɛ unun maany, ma zin kaala ci ɔɔba o alaŋ een didi.” ");
INSERT INTO mur_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Mayo nuun koobi kaal ci akati ɛlɛ onan maany, kaala ci kɔɔba o kaal ceen didi. Eeci kaga naana ŋino kakunɛ been ŋinti kakɔyɛ. Maje bar niiga alaŋ agayu ŋino kakunɛ been ŋinti kakɔyɛ. ");
INSERT INTO mur_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Apaku niiga zoozok gole o eet o deer, maje naana akɔm eet ci kapaye gi ci gɛr. ");
INSERT INTO mur_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bar mã anyak gi ci kapai naana, payiin cane o payiin ceen didi, eeci alaŋ een aneet doon ci kapai zɔɔz nico o, bar kapaka naana ki baaba o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ayeedi lotinowe ugooc zɔɔz ci azi nɛ, Mã een bacowa ram, alɛɛmyai zɔɔz nici. ");
INSERT INTO mur_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Zin keen naana bacoi ci ɛlɛ onan maany, ma buk baaba o itoonanan aneet, niini bacoi can buk.” ");
INSERT INTO mur_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ma ajin niigi nɔɔnɔ anek nɛ, “Aavi baatune ŋaa?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Alaŋ niiga agayaŋ aneet, ma alaŋ buk agayu baaba. Inoko tɛ agayaŋ aneet, agayu waan baaba buk.” ");
INSERT INTO mur_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ma kaal nicoko aduwa Yesu ŋaati adɛmzi ɔl kaluwawe o ceez o Joowo ŋaao abilni loidoŋ o muco. Ma akɔm iiten nice eet ci agam nɔɔnɔ, eeci ŋaan iiteni oninɛ kiiya. ");
INSERT INTO mur_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ma bodo anek Yesu nɔɔgɔ nɛ, “Iima ŋaan kawɔ naana kooŋnekuŋ looc ŋina. Zin katin arooŋnyaŋ niiga aneet, bar alaŋ ajowanaŋ, ma adaaŋnu niiga waanma iŋaan anyaku oŋɛ nɔkɔ. Ma ŋinti kakɔyɛ naana, alaŋ niiga avoyu.” ");
INSERT INTO mur_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma anɔ alaata o Juz nɛ, “Ma dim azi nɛ, Alaŋ naaga kanim kɔɔtɔ ŋaati akɔyi niini o. Arɔɔŋ bɔŋ ka kuruk ɛlɛ kadaak?” ");
INSERT INTO mur_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ. “Eeginu niiga ɔl ci loocu ŋina, maje naana keen eet ci tammu tadenu. ");
INSERT INTO mur_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gi zin ci ona kanekuŋ nɛ, Adaaŋnu waanma niiga iŋaan anyaku oŋɛ o nɛɛn. Zin didi niiga waanma adaaŋnu iŋaan anyaku oŋɛ noko mã alaŋ atuyaŋ niiga aneet o keen aneet.” ");
INSERT INTO mur_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ma ajin niigi nɔɔnɔ anek nɛ, “Ma niina ineet ŋɛnɛɛn?” Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Gi nɛɛn ona kuduwayuŋ rak uyen ɔɔwa e. ");
INSERT INTO mur_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kanyei zoozok ci meel karooŋ kuduwayuŋ, ma kapayekuŋ igeet. Ma ɛɛti o itoonanan aneet alaŋ niini avɔlɔŋ. Zin olla naana kaduwai ɔl o loocu kaal o kaziiŋna ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma ŋaan niigi kagaac aduwak Yesu nɔɔgɔ zɔɔz ci akati baatin o. ");
INSERT INTO mur_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Enek ni Yesu nɔɔgɔ nɛ, “Tiŋeere ma odoŋtu niiga Ŋɛɛrti Eeto keete ween talakec, ŋaan agayaŋu keen naana aneet nɛɛn. Zin enice ŋaan agayu akɔm naana gi ci kagoon dɔyize can doon, bar kaduwa zɔɔz o ayelzakan aneet baaba. ");
INSERT INTO mur_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma niini o itoonanan aneet aavi ŋaatan. Ma alaŋ uuŋnan niini aneet kaavu doon, eeci gɔɔn kagoon naana gi o atal niini tup.” ");
INSERT INTO mur_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mazi akɔ aduwa niini kaal nicoko, utuweec ɔl ci meelik nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Enek ni Yesu ɔl ci atu nɔɔnɔ o nɛ, “Mã azuunu demziin can o, izitu didi koca niiga nuyak cigan. ");
INSERT INTO mur_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ŋaan zin agayu niiga zɔɔz ween didi, ma zɔɔz ween didi ŋaan ɔɔganuŋ igeet mirɔkzete o baciinowu.” ");
INSERT INTO mur_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ma abɛdɛkɛ niigi Yesu anek nɛ, “Keegina naaga dɔl ci dɔl o Ibrayim. Ŋaan baal rɛɛn ŋaan kizita mirɔk ci ɔl oogi. Mayo zin kɛŋ jaŋ ci anɛ nɛ, Ŋaan ɔɔgjanu mirɔkzɛta o?” ");
INSERT INTO mur_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti ci abaca baciinok niini miroi ci baciinowu. ");
INSERT INTO mur_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ma gɔɔn laadun miroiti alaŋ een eet ci korgu kodot, bar logo o aritak kɔrɔk nɛɛn o abaak niini ɔlɔ kodot. ");
INSERT INTO mur_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mã ɔɔgawuŋ ŋɛɛrti Joowo baciinowe, ooktewu koca niiga didi. ");
INSERT INTO mur_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ŋɛdɛt kagayuŋ naana igeet nɔkɔ eeginu dɔl ci dɔl o Ibrayim o. Ma bar arooŋnyu uruktaŋ kadaak, eeci alaŋ agamanu demziin onan. ");
INSERT INTO mur_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kazooz zin naana kaal o ayelekan aneet baaba, maje niiga agoonu kaal o aduwakuŋ igeet baatunooŋ.” ");
INSERT INTO mur_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Baatinaaŋ nɛɛn Ibrayim.” Ma anek Yesu nɔɔgɔ nɛ, “Matɛ didi iziti dɔl ci Ibrayim, agoonu waan kaal ci abon kiyo baale niini e. ");
INSERT INTO mur_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Bar zin naana kaduwakuŋ igeet zoozok ween didi baal kaziiŋna naana Joowa, ma bar arooŋnyu uruktaŋ kadaak. Mazin baale Ibrayim alaŋ agɔɔn kaal ci ɛɛl nɔkɔ. ");
INSERT INTO mur_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Bar zin niiga agoonu kaal o agɔɔn baatunooŋ.” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Alaŋ naana karitana tuuwa. Kanyaka baatinaaŋ codoi ṯɔr nɔkɔ ween Jook.” ");
INSERT INTO mur_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ma anek Yesu nɔɔgɔ nɛ, “Kizi da Jooi didi baatunooŋ, areezaŋ waan niiga aneet, eeci kakun naana ŋaatin, ma inoko kaavɛ ŋina. Alaŋ kakun dɔyize can doon, bar nɔɔnɔ nɛɛn o itoonanan aneet. ");
INSERT INTO mur_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Zin alaŋ aziiŋnu kaal ci kaduwakuŋ o naa? Agoonu nɔkɔ o, eeci alaŋ animnyu uzuuti zɔɔz can o. ");
INSERT INTO mur_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Eeginu zin niiga dɔl ceen baatunooŋ nɛɛn Loryen, ma arooŋnyu oneec kaal o arɔɔŋ niini. Niini laadun kinatamma e eet ci monyento. Atɛɛdɔ niini ki leeminɛt zɔɔ, eeci akɔm ŋaatin laadun leeminɛt. Aduwa gɔɔn niini vɔlɔŋ, eeci vɔlɔŋ kɛɛr cin laadun. Niini voloŋnyoi, ma een baati voloŋnyowu. ");
INSERT INTO mur_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Maje naana kaduwakuŋ zɔɔz ween didi. Gi zin calaŋ atuyaŋ niiga aneet o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ŋɛnɛɛn inoko ŋaatunooŋ ci agawekan aneet gi ci kabaci? Zin mã kaduwa gi ween didi, alaŋ atuyaŋ naa? ");
INSERT INTO mur_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ma ɛɛti o aku Joowa azii niini zoozok o Joowo. Ma zin niiga alaŋ aziiŋnenu o, eeci alaŋ eeginu dɔl ci Joowo.” ");
INSERT INTO mur_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ma anek ɔl o Juz Yesu bornɛt nɔŋa nɛ, “Een niina eet ceen Samariyen ci anyei Loryen alya.” ");
INSERT INTO mur_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Akɔmnan Loryen alya. Kadiŋdiŋan naana baaba, maje bar niiga alaŋ adiŋdiŋanaŋ aneet. ");
INSERT INTO mur_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Alaŋ karooŋei naana diŋdiŋɔn ɛlɛ maany, bar Jook nɛɛn o arooŋekan aneet diŋdiŋɔn, ma apayek niini gerzitin ɔl o abornan aneet. ");
INSERT INTO mur_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Didilɛ kaduwakuŋ igeet, mã azii ɛɛti zɔɔz can o, alaŋ niini adaai been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ma anek ɔl o Juz nɔɔnɔ nɛ, “Inoko zin kagayin didi anyei niina Loryen alya. Mayo nuun een jijitinaaŋ Ibrayim kibeen nyakaŋanɛt baale adaayitɔ. Maje niina azi nɛ, Mã anyak eet ci azooni zɔɔz can o, alaŋ adaai been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ma dim niina ineet ŋɛnɛɛn? Baale baatinaaŋ o kazi Ibrayim kibeen nyakaŋanɛt adaayitɔ labak. Mazi yo niina adiŋdiŋ juk nɔɔgɔ?” ");
INSERT INTO mur_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Matɛ waan kidiŋdiŋan ɛlɛ cano naana maany, alaŋ koca diŋdiŋɔnti cane o een didi. Bar zin adiŋdiŋanan aneet baaba o gɔɔn aniyu niiga nɛ, Jook cunooŋ. ");
INSERT INTO mur_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bar zin niiga ŋaan agaac nɔɔnɔ, maje naana kaga nɔɔnɔ. Matɛ kizi nɛ, Alaŋ kaga nɔɔnɔ, kavoloŋ waan naana kiyo buk niiga o. Bar zin kaga naana nɔɔnɔ, ma kazoonɛ zɔɔz onin. ");
INSERT INTO mur_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baale jijitunooŋ Ibrayim atalnɛ ŋaati ka kicini niini iiten onan kakunɛ. Icinun zin niini, ma atalɔ.” ");
INSERT INTO mur_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma anek niigi nɔɔnɔ nɛ, “Niina alya ŋaan rak rum irkitok eet ram kamɔtɔ. Icinu zin da Ibrayim waŋa?” ");
INSERT INTO mur_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Didilɛ kaduwakuŋ igeet, ma ŋaan kitiryai Ibrayim e aneeta tɔ.” ");
INSERT INTO mur_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ma zooze nico everya niigi biyɛn arɔɔŋ ka kavaci Yesu kadaak. Uduni ni niini nɔɔgɔ kɛbɛrɛn nɔkɔ ɔɔtɔ ook bitaala. ");
INSERT INTO mur_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ma iitene oman awɔ Yesu gɔla, ma acin eet ci da aritai kizi ruben nɔkɔ laadun. ");
INSERT INTO mur_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma ajin nuyawa oginɛ nɔɔnɔ anek nɛ, “Alaan o demziinto, ŋɛnɛɛn ci abaca oŋec ci anyek eet nico kitiryai kizi ruben o? Oŋec cin doon yo oŋec da ci baatin ki yaatin?” ");
INSERT INTO mur_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Rubenzɛt cin o alaŋ anyaa oŋɛci ci abaca niini karabɔŋ een oŋɛci ci baatin ki yaatin. Bar ruben o ka keyelizyai liŋliŋɔnti o dɔyiz o Joowo ŋaatin. ");
INSERT INTO mur_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Abon zin kaliŋliŋ naana liŋliŋɔn ci eet o itoonanan aneet iŋaan waazin lɔɔci o. Eeci gɔɔn ma izi lɔɔci baalin, akɔm bodo eet ci aliŋliŋ. ");
INSERT INTO mur_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ma ŋinti ŋaan rak kaavɛ naana loota o keen vooritin ci loocu.” ");
INSERT INTO mur_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aduwa niini zɔɔz nico, ma oortek amot looc, ma aŋɔnya tɔdɔ amotɛ, ma aŋɔnyɛkɛ eet ci ruben noko kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma anek nɔɔnɔ nɛ, “Bitɔ toony ŋum lamurḏente o kazi Siloom.” (Ma kɛŋ ci zaar nicoko kazi nɛ itoonɛ.) Ook ni ɛɛti ci ruben noko ŋinaante. Mazi akɔ oony ŋum, izi kɛbɛrɛ oginɛ wak icinɔ. ");
INSERT INTO mur_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mazi akɔ abada, icinit nɔɔnɔ ɔl o abaawɔ kibeen nɔɔnɔ, ma ajinɔ anɔ nɛ, “Mayo nici alaŋ een eet o gɔɔn aavi loota alaye o nɛɛn?” ");
INSERT INTO mur_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma azi ɔl ogɛnɛ nɛ, “Nɔɔnɔ ɛlɛ gi.” Maje ogɛnɛ azi nɛ, “Akɔm! Alaŋ een nɔɔnɔ, olla atobɔ.” Abarzek ni niini alya nɔɔgɔ enek nɛ, “Aneeta ɛlɛ nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma ajin niigi nɔɔnɔ anek nɛ, “Mã een ineet nɛɛn, okole zin kɛbɛrɛ ugune ku?” ");
INSERT INTO mur_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Anyak eet ci kazi Yesu aŋɔnya tɔdɔ, ma aŋonyekan kɛbɛrɛ, ma anekan nɛ, Bitɔ toony ŋum lamurḏente o kazi Siloom. Mazi kakɔ koony ŋum, kicinɔ.” ");
INSERT INTO mur_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma ajin niigi nɔɔnɔ anek nɛ, “Aavi inoko niini ŋaa?” Ma anek niini nɔɔgɔ nɛ, “Alaŋ kaga.” ");
INSERT INTO mur_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ooti ni niigi eet ci baal ruben noko ole o Parici. ");
INSERT INTO mur_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Maje iiteni ci baal akɔli Yesu eet ci ruben noko kɛbɛrɛ o iiten o yubzento. ");
INSERT INTO mur_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma avɔ bodo ajin ɔl o Parici eet ci baal ruben noko anek nɛ, “Okole kɛbɛrɛ ku?” Ma abarzek niini nɔɔgɔ anek nɛ, “Aŋonyekan ɛɛti oman tɔdɔ ci acɔkcɔi kɛbɛrɛ. Mazi kakɔ koony ŋum, bar kicinɔ.” ");
INSERT INTO mur_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma anɔ ɔl ogɛnɛ ole o Parici nɛ, “Ma ɛɛti ci agɔɔn gi nico noko alaŋ een eet ci aku Joowa, eeci alaŋ niini azooni iiten o yubzento een Sabit.” Maje ogɛnɛ azi nɛ, “Ma ɛɛti ci anyak oŋec agɔɔn kaal ci atɛɛt ɔl biye ci ɛɛl ki nici koca ku?” Ɛŋɛrtɔ ni niigi maany kɔrgɛna daŋɔnta. ");
INSERT INTO mur_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ma ajin bodo ɔl o Parici eet nico anek nɛ, “Ma dim zin niina ci ona akolin ɛɛti nici kɛbɛrɛ o inoko azi nɛ eete nico?” Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Bar naana kazi nɛ, Niini nyakaŋan gi.” ");
INSERT INTO mur_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Maje bar alaata o Juz alaŋ arɔɔŋ kiziiyit zɔɔz ci baal rubenini ɛɛti nici, ma bodo icinɔi o. Makacin ɔɔt utuya baatin ki yaatin. ");
INSERT INTO mur_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma avu ajin niigi nɔɔgɔ anek nɛ, “Nici logo cunooŋ gi? Aritai da niini kizi ruben noko laadun? Mazi bodo icinɔ ku?” ");
INSERT INTO mur_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma abɛdɛkɛ niigi nɔɔgɔ anek nɛ, “Kagaya naaga niini logo onaaŋ ɛlɛ nɛɛn. Aritai niini kizi ruben. ");
INSERT INTO mur_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bar zin alaŋ kagaya gɔl ci icinɔi inoko o. Alaŋ kagaya eet ci akɔl nɔɔnɔ kɛbɛrɛ o. Ijinit nɔɔnɔ ɛlɛ, eeci niini buk eet ci idikirun. Anycek kuduwayuŋ niini alya.” ");
INSERT INTO mur_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Aduwa baatinɛ kibeen yaatin zɔɔz nico o, eeci aŋole niigi alaat o Juz. Eeci aga niigi mã azi ɛɛti nɛ, Yesu niini Kiristo nɛɛn, atɔɔk koca alaata o Juz nɔɔnɔ ceeze o lotento. ");
INSERT INTO mur_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gi ci zin anɛ niigi nɛ, “Ijinit nɔɔnɔ,” o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ma bodo vurta ivita utuya alaata o Juz eet ci baal ruben noko, ma avu anek nɔɔnɔ nɛ, “Duwa gi ween didi ŋume o Joowo, eeci kagaya naaga ɛɛti ci akolin kɛbɛrɛ o eet ci oŋecu.” ");
INSERT INTO mur_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Alaŋ zin naana kaga mã een niini eet ci oŋecu karabɔŋ alaŋ anyak oŋec. Olla naana kaga gi codoi. Baale keen ruben, ma inoko kicinɔ.” ");
INSERT INTO mur_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma ajin niigi bodo nɔɔnɔ anek nɛ, “Agoonekin dim gitaz? Akolin kɛbɛrɛ ku?” ");
INSERT INTO mur_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Uyene rak naana kuduwayuŋ, bar alaŋ arooŋnyu niiga iziiyit. Mazin yo bodo arooŋnyu ka kuduwayuŋ naa? Arooŋnyu bɔŋ iziti nuyak cigin buk?” ");
INSERT INTO mur_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ma adɔm niigi nɔɔnɔ anek nɛ, “Ŋaan een nuyai cin niina. Keegina naaga nuyak o Mosis. ");
INSERT INTO mur_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kagaya baale naaga azɔɔzɔ Jooi kibeen Mosis. Maje eet nico alaŋ naaga ŋinti akuni o kagaya.” ");
INSERT INTO mur_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma abɛdɛkɛ niini nɔɔgɔ anek nɛ, “Abiirnan aneet ɔɔ zooze calaŋ agayu niiga eet nico ŋinti akuni o. Bar zin okolan niini aneeta kɛbɛrɛ. ");
INSERT INTO mur_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kaga ri naaga niini Jooi alaŋ azii ŋaryiin ci ɔl o oŋenu. Mazi adiŋdiŋan ɛɛti Jook, ma agɔɔn kaal o arɔɔŋ niini, azii Jooi nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ŋaan laadun kinatamma kiziiyit eet ci akɔl kɛbɛrɛ ci gɔn ci aritai kizi ruben. ");
INSERT INTO mur_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Matɛ ɛɛti nici calaŋ aku Joowa, alaŋ waan kaal nicoko dook agɔɔn.” ");
INSERT INTO mur_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Aritai niina oŋeca izi ruben nɔkɔ, ma bar arooŋ ija demezet ageeta.” Otooyit ni niigi nɔɔnɔ kudun ceeze ci lotento noko. ");
INSERT INTO mur_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mazi akɔ azii Yesu otooyit ɔl eet baal akɔl niini kɛbɛrɛ e ceeze o lotento, ook urumtɔ niini kibeen nɔɔnɔ, ma ajin anek nɛ, “Mayo inoko niina atu Ŋɛɛrti Eeto?” ");
INSERT INTO mur_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma abɛdɛkɛ niini nɔɔnɔ anek nɛ, “Alaan, duwayan da, niini ŋɛnɛɛn ka kutu.” ");
INSERT INTO mur_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma abɛdɛkɛ Yesu nɔɔnɔ anek nɛ, “Icinu niina nɔɔnɔ uyene laadun. Nɔɔnɔ nɛɛn zin ci azoozonu ki ineet noko.” ");
INSERT INTO mur_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma anek ɛɛti Yesu nɛ, “Manyi, inoko kutuwɔ.” Ma akani kozoŋti looc nɔɔnɔ ŋuma. ");
INSERT INTO mur_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ma azi Yesu nɛ, “Kakunai naana looc nico o ka kanyaa payiin ka kanyek ɔl o ruben kicintɔ, maje o acinɛ ka kiziti rubenɛ.” ");
INSERT INTO mur_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mazi azii ɔl ci Parici ona aromɛ ki nɔɔnɔ o gi ci aduwa niini noko, ijinit niigi nɔɔnɔ enektek nɛ, “Bɔŋ buk naaga keegina rubenɛ?” ");
INSERT INTO mur_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma anek Yesu nɔɔgɔ nɛ, “Waan tɛ iziti rubenɛ, akɔmnuŋ waan oŋɛ. Bar zin giye o aniyu niiga nɛ, acinenu, amɛnanu anyaku oŋɛ nɔkɔ.” ");
INSERT INTO mur_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ma anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, ma ɛɛti calaŋ akunak tɛɛny eecitɔ araana, ma bar atɔɔda dɔda ŋin oma, ma akɔ tɛɛnya eecitɔ, niini agoryai, ma een aamnyoi. ");
INSERT INTO mur_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Maje ɛɛti ci akunak tɛɛny araana, niini eet o towawiinto nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ma akolek ɛɛti o gɔɔn abɛk tɛɛny eet ci towawiinto noko araan. Ma azii aza oginɛ molok onin, ma awo niini aza ogin zaar, ma arayin nɔɔgɔ ŋaati aduŋni. ");
INSERT INTO mur_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Mazi aduŋnan aza ogin bitaala, ma oontanɛ nɔɔgɔ, anowa niigi nɔɔnɔ vurta, eeci aga niigi nɔɔnɔ molok onin. ");
INSERT INTO mur_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Alaŋ niigi ano eet ci gaga, bar mã een eet ci gaga, avir niigi nɔɔnɔ, eeci alaŋ aga niigi molok cin.” ");
INSERT INTO mur_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aduwak Yesu nɔɔgɔ yabziin nico, maje bar niigi alaŋ aga kɛŋ cin. ");
INSERT INTO mur_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ma bodo anek Yesu nɔɔgɔ nɛ, “Didilɛ kaduwakuŋ igeet, Keen naana araan o tɛɛny o azawu. ");
INSERT INTO mur_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ma ɔl dook baal avu iŋaan naana kiiya e niigi agoryak, ma een aamnyok. Bar zin aza ŋaan kiziiyit nɔɔgɔ. ");
INSERT INTO mur_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Keen zin naana araan, ma ɛɛti ci aku ŋaaten aneet ɛɛlyai. Ma aku niini tɛɛny, ma adun, ma ajowa ŋinti agɛwi. ");
INSERT INTO mur_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gɔɔn laadun agoryaiti akunak niini gorziin ki toŋdiin kibeen targanyitin. Zin bar naana kakun ka kiiya kanyek nɔɔgɔ rogɛt korogit juruŋ. ");
INSERT INTO mur_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Keen naana eet o towawiinto abon. Ma gɔɔn ɛɛti ci towawiinto alaŋ aŋoli daayiz ci aruwɛn azaye cigin. ");
INSERT INTO mur_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma ɛɛti ci gɔɔn uuwayi ka kuruktozek vɔyita alaŋ een niini eet o azawu nɛɛn. Mã acina niini kɛlaŋ ci aku, ooŋnek niini aza looc, ma avir, ma aku adak kɛlaŋi aza zɛɛ ma azaan. ");
INSERT INTO mur_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma ɛɛti ci aliŋliŋ ka kuruktozek vɔyita avir niini labak o, eeci alaŋ een aza nici cigin ɛlɛ. ");
INSERT INTO mur_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Keen zin naana eet o towawiinto abon. Kaga naana aza ogan, ma buk agayan niigi aneet. ");
INSERT INTO mur_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Kiyo agayan baaba aneet, ma kaga naana nɔɔnɔ o, buk zin naana kaga aza ogan. Ma kagama daayiz ŋaatineeŋ. ");
INSERT INTO mur_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kanyei buk aza oogi calaŋ ɛɛl tɛɛnye nico. Abon zin kanyaa naana nɔɔgɔ buk ka kivita kiziiktan niigi aneet molok onan ka koromtɛ aza dook tɛɛnye codoi, ma oowa nɔɔgɔ dook ɛɛti codoi. ");
INSERT INTO mur_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Areezan zin baaba aneet o, eeci kagama naana daayiz. Zin kaga naana ŋaan kaŋaaz daayiza bodo. ");
INSERT INTO mur_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Akɔm eet ci anyak dɔyiz ci ka kurukan aneet kadaak, bar kagama daayiz naana oowe onan doon. Kanyei dɔyiz ci kadaaknɛ been ci kiŋaanɛ bodo daayiza. Nici zɔɔz ci aricanekan baaba aneet ka kutugu.” ");
INSERT INTO mur_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Zin zooze nico ɛŋɛryɔ bodo ɔl o Juz kɔrgɛna. ");
INSERT INTO mur_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ma anɔ ɔl ci meel ŋaatineeŋ nɛ, “Anyak inoko ɛɛti nici Loryen alya, karabɔŋ bar anyak maŋɔn. Mayo laadun aziiŋnu zɔɔz cin o naa?” ");
INSERT INTO mur_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Maje ɔl ogɛn anɔ nɛ, “Akɔm eet ci anyak Loryen alya ci azɔɔz nɔkɔ. Anyak Loryenti dɔyiz ci anyekɛ eet ci ruben kicinɔ?” ");
INSERT INTO mur_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zin iiya iiteni o gɔɔn anyayi ɔl o Juz lotɛn o aadanɛ niigi iiten baal ɛtɛɛnyɔi bodo ceez o Joowo Jerusalɛma e. Maje waanice lɔɔci izi lɔmɔtin. ");
INSERT INTO mur_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma iitene nice awɔ Yesu riiwe baal ɛɛnyca Solomon e. Ma rii nici ajɔŋɔz ceez o Joowo. ");
INSERT INTO mur_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma avu aliya ɔl o Juz nɔɔnɔ, ma ajin anek nɛ, “Ma dim ka kereyowa been inin? Mã een didi niina Kiristo nɛɛn, duwayet juruŋ.” ");
INSERT INTO mur_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Uyene kuduwayuŋ, bar alaŋ arooŋnyu niiga utuyaŋ. Ma kaala ci kagoon naana zaare o baaba noko ayelza gi o kɛɛnɛ naana Kiristo. ");
INSERT INTO mur_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bar zin niiga alaŋ atuyaŋ o, eeci alaŋ eeginu aza cigan. ");
INSERT INTO mur_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Gɔɔn aza ogane aziiŋnan molok onan. Ma kaga naana nɔɔgɔ, ma anuyan niigi aneet. ");
INSERT INTO mur_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kanyi naana nɔɔgɔ rogɛt o abil been nɛɛn, ma alaŋ bodo niigi adaai. Ma akɔm eet ci iraananan nɔɔgɔ aziite onan. ");
INSERT INTO mur_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma baaba o anyan aneet nɔɔgɔ adikir niini ɔrɔɔt kujuk kaal dook, ma akɔm eet ci anim kiraana nɔɔgɔ aziite onin. ");
INSERT INTO mur_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Zin naana ki baaba kadowina.” ");
INSERT INTO mur_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma giye nico everya bodo ɔl o Juz biyɛn ka kavacit nɔɔnɔ kuruwit kadaak. ");
INSERT INTO mur_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Keyeleyuŋ naana kaal o abon meelik avu ŋaati baaba dook. Mazi yo kaale nicoko jaŋ ci arooŋnyu avacaŋ biyɛnɛ o?” ");
INSERT INTO mur_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma abɛdɛkɛ ɔl o Juz nɔɔnɔ anek nɛ, “Alaŋ karooŋnya kavacin giye ci abon agoon, bar karooŋnya kavacin o, eeci amomoz Jook. Een niina eet ci deer labak, ma bar anyi ɛlɛ izi Jook.” ");
INSERT INTO mur_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ma abɛdɛkɛ Yesu nɔɔgɔ anek nɛ, “Ayeedi waragewe o Joowo gi ci azi nɛ, Eeginu niiga dɔl ci Joowo. ");
INSERT INTO mur_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma kaga naaga laadun waragɛwi o Joowo alɛɛmnyai nɔkɔ kodot. Awo zin Jooi ɔl baal anyek niini zɔɔz onin kiziti dɔl cigin. ");
INSERT INTO mur_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma zin bar aneeta aŋɛranan Jooi, ma itoonanan kiiyak looc. Mazi kazi nɛ, Keen ŋɛɛrti Joowo, bodo aniyu nɛ, Kamomoz Jook o, ku? ");
INSERT INTO mur_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Matɛ waan calaŋ kaliŋliŋ naana liŋliŋɔn o baaba, alaŋ koca aganɔ ŋaati atuyaŋ niiga aneet. ");
INSERT INTO mur_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bar zin mã kaliŋliŋ naana liŋliŋɔn o baaba, mayo nuun alaŋ atuyaŋ niiga aneet zooze onan kaduwa, abon atuyu liŋliŋɔn onan kaliŋliŋ, ka agaac aavi baaba ŋaatan, ma kaavɛ naana ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Enico orooŋit bodo niigi kagamit nɔɔnɔ, bar iniwun niini nɔɔgɔ kɛbɛrɛn nɔkɔ ɔtɔɔ. ");
INSERT INTO mur_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Imiire ni Yesu bodo abaayiz liil o kazi Jordan, ma akɔ ŋaabaal oonyi Jɔn ɔl e, ma akɔ amɔn ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma ŋinaante ivitak ɔl ci meelik nɔɔnɔ, ma avu anɔ nɛ, “Baale Jɔn akɔm kaal ci atɛɛt ɔl biye agɔɔn, zin bar kaal baal aduwa niini akati eet nico e eelit didi dook tɔ.” ");
INSERT INTO mur_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Zin waanice ŋinaante utuweec ɔl ci meelik nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ma enice anyak eet ci amɔɔr kazi zaar nɛ Lazaros. Abaak niini kuture o kazi Bɛtani, ma aromɛ niini ki ŋɔɔnɔgi ci kazi Meri been ci kazi Marta ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma Meri nici nɔɔnɔ nɛɛn baal ka kiiya kuvuut Manyi karacoca, ma ɛɛk zɔɔ imanɛ e. ");
INSERT INTO mur_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma itoonek ŋɔɔnɔgi Lazaros Yesu otok ci anek nɛ, “Manyi, laŋotun unun gɔɔn areez amɔɔr ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Mazi akɔ azii Yesu zɔɔz nico, izi nɛ, “Mɔɔrizi nici alaŋ een daayiz, bar ka kanyaak Jook zany, ka zin buk kanyozozek ŋɛɛrti Joowo zanyi.” ");
INSERT INTO mur_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Maje waanice Yesu arɛɛz Marta kibeen Meri been Lazaros ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bar mazi akɔ azii niini mɔɔriz o Lazaros, omonun rak niini ŋaati baal aavɛ o iinya ram. ");
INSERT INTO mur_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma vurta enek nuyak ogin nɛ, “Kimiirte di bodo kɔɔtɔ Judiya ka kɔɔtɔ Bɛtaniya.” ");
INSERT INTO mur_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma abɛdɛkɛ nuyawa oginɛ nɔɔnɔ anek nɛ, “Alaan o demziinto, iiten baale arɔɔŋ ɔl o Juz kavacin biyɛnɛ ŋinaante. Ma bodo inoko arooŋ ka bitɔ ŋinaante?” ");
INSERT INTO mur_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma anek Yesu nɔɔgɔ nɛ, “Inoko gɔɔn alaŋ anyak waazini codoi ziik amɔtɔ ram? Mazin ɛɛti ci awɔ waaz alaŋ niini adiri, eeci vɔɔr lɔɔci. ");
INSERT INTO mur_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mazi awɔ niini baal, adiri, eeci alaŋ vɔɔr lɔɔci. ");
INSERT INTO mur_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Inoko zin laŋotinai Lazaros ɔɔŋ. Karooŋ zin kook kitiŋka kicinɛ.” ");
INSERT INTO mur_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma abɛdɛkɛ nuyawa oginɛ nɔɔnɔ anek nɛ, “Manyi, matɛ ɔɔŋ, ŋaan zin ri tedec acinɛ labak.” ");
INSERT INTO mur_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma ɔɔŋnya ci aduwa Yesu o daayiz o Lazaros nɛɛn. Maje bar nuyawa alaŋ aga. Bar abaaban niigi anɔ nɛ, “Coma ɔɔŋ labak.” ");
INSERT INTO mur_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ɔbɔrak ni Yesu nɔɔgɔ enek nɛ, “Adaawun Lazaros. ");
INSERT INTO mur_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Katalnɛ zin naana giye ci akanuŋ igeet, eeci alaŋ kaavɛ waanice naana ŋinaante ka korogoz nɔɔnɔ. Ma daayizi nica iina o ka atuyaŋ niiga aneet. Inoko zin kɔɔtɔ ŋaatin.” ");
INSERT INTO mur_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ma anek Tomaz ween codengɔn gɔnɔgi ween nuyak nɛ, “Korkorit buk naaga dook kibeen nɔɔnɔ, ka mã anyak gi ci aku, ka kadaayit naaga dook ki nɔɔnɔ.” ");
INSERT INTO mur_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mazi akɔ arum Yesu looc, amada Lazaros anyawun iinya wec bɔɔta. ");
INSERT INTO mur_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Maje kuturi ci kazi Bɛtani noko ajɔŋzɔ ki Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma avunak ɔl ci Juz meelik Marta been Meri ka kivita kozooztek nɔɔgɔ daayize nico. ");
INSERT INTO mur_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mazi akɔ azii Marta Yesu iiya, itiŋa ook urumek nɔɔnɔ gɔl. Maje Meri ŋaan aavi ceeza. ");
INSERT INTO mur_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ma anek Marta Yesu nɛ, “Manyi, waan da aavu ŋina alaŋ waan gɔtɔna adaai. ");
INSERT INTO mur_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bar zin kaga mã ajin inoko Jook olla gi ci arooŋ, anyin niini ineet.” ");
INSERT INTO mur_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma anek Yesu nɔɔnɔ nɛ, “Ŋaan iŋaaz tedec gotonu korok bodo.” ");
INSERT INTO mur_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma abɛdɛkɛ Marta nɔɔnɔ anek nɛ, “Ŋɛdɛt kaga nɔkɔ. Ŋaan iŋaaz waanma niini daayiza iitene ci aṯornɛkɛ lɔɔci e.” ");
INSERT INTO mur_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma anek Yesu nɔɔnɔ nɛ, “Aneeta nɛɛn o kanyi ɔl rogɛt, ma kaŋaanɛ nɔɔgɔ daayiza. Ma ɛɛti ci atuyan aneet mayo nuun adaai, arogi bodo. ");
INSERT INTO mur_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Maje ɛɛti ci ŋaan arogi, ma atuyan aneet, alaŋ bodo niini adaai been nɛɛn. Inoko atu zɔɔz nico?” ");
INSERT INTO mur_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma abɛdɛkɛ Marta Yesu anek nɛ, “Ii, Manyi. Kutuwin naana ineet. Een niina Kiristo ween ŋɛɛrti Joowo baal ka kiiyak looc e nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mazi akɔ adotiz Marta zooze nico, imiire ook otowa Meri ween ŋɔɔni, ma aku aŋomtek nɔɔnɔ doon gi ci anek nɛ, “Iiya alaani o demziinto. Awuyin zin niini ineet.” ");
INSERT INTO mur_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mazi azii Meri zɔɔz nico, itiŋa ecodoi noko iyiik ook ŋaatin. ");
INSERT INTO mur_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maje Yesu ŋaan korogjok kurum, bar ŋaan aavi ŋaa ona arumɛkɛ Marta nɔɔnɔ gɔl e. ");
INSERT INTO mur_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Maje ɔl o Juz ona avu ka kozoozek awɔyi Meri e ŋaan aavtiz ceeza. Mazi acin niigi Meri aŋaaz taman, ma adun akɔ bitaala, oneec niigi nɔɔnɔ, eeci abaaban niigi anɔ nɛ, “Akɔ inoko boote o gɔtɔnɔn e ka kook kutulu ŋinaante.” ");
INSERT INTO mur_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mazi akɔ arum Meri Yesu, acin niini nɔɔnɔ, ma akani kozoŋti looc nɔɔnɔ ŋuma, ma anek nɛ, “Manyi, inoko da aavutɔ ŋina, ŋaan waan gɔtɔna kadaak.” ");
INSERT INTO mur_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mazi acin Yesu Meri kibeen ɔl o Juz alu nɔkɔ, ɛtɛɛdɛ buk nɔɔnɔ ziniz ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma ajin niini nɔɔgɔ anek nɛ, “Adayu ŋaa?” Ma abɛdɛkɛ niigi nɔɔnɔ anek nɛ, “Manyi, ija ka cin ŋinti kadaya o.” ");
INSERT INTO mur_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Utulu ni Yesu. ");
INSERT INTO mur_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma anɔ ɔl o Juz nɛ, “Icinit di! Arɛɛz niini eet nico ɔrɔɔt.” ");
INSERT INTO mur_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Maje ɔl ogɛnɛ ŋaatineeŋ anɔ nɛ, “Alaŋ een eet baal akɔl eet o ruben kɛbɛrɛ e nɛɛn? Inoko tɛ kɔmɔda eet nico iŋaan kadaak, alaŋ waan adaai.” ");
INSERT INTO mur_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Zin bodo ɛtɛɛdɛ Yesu ziniz ɔrɔɔt ɛlɛ. Iiyak ni bɔɔt ci baal adawin Lazaros o. Maje bɔɔt nico anyoogi ɔtɔgi biye ci appe ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma anek Yesu ɔl nɛ, “Ipikta bɛ nico look otoga.” Bar abɛdɛkɛ Marta nɔɔnɔ anek nɛ, “Manyi, ame tedec ɔrɔɔt, eeci anyawun niini bɔɔta iinya wec.” ");
INSERT INTO mur_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma anek Yesu Marta nɛ, “Kuduwayin uyen keneyin nɛ, Mã atuyan aneet, acin tedec diŋdiŋɔn o Joowo.” ");
INSERT INTO mur_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Mazi akɔ apiya niigi bɛ, ɔdɔŋ Yesu kɛbɛrɛ, ma acin tammu taden, ma azi nɛ, “Baaba, kanyin zany, eeci gɔɔn aziiŋnan niina aneet. ");
INSERT INTO mur_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ŋɛdɛt kagayin nɔkɔ gɔɔn aziiŋnan niina aneet. Olla zin zoozok nicoko kaduwa o, eeci karooŋ ɔl ci ɛɛl ŋina noko ka kutuyɔ, ma agayan niigi itoonanan niina aneet.” ");
INSERT INTO mur_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Mazi akɔ odotiz niini ŋaryiinte nico, otowɛ molowe ci appe azi nɛ, “Lazaros, duna bitaala.” ");
INSERT INTO mur_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Makacin itiŋa Lazaros, ma aduŋnak bitaalin. Maje azɛɛna kibeen zɔɔ ŋaan acabje rumanɛn nɔkɔ. Maje bodo rum codoi atakuconek nɔɔnɔ ŋum. Ma anek Yesu ɔl nɛ, “Ɔɔkta rumanɛ nicoko ŋaatin ka kɔtɔɔ.” ");
INSERT INTO mur_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Mazi avɔ acin ɔl o Juz baal avu azoozek awɔyi Meri e Yesu agɔɔn gi nico, utuweec ci meelik ŋaatineeŋ nɔɔnɔ. ");
INSERT INTO mur_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Maje bar ɔl ogɛn ŋaatineeŋ imiirte ɔɔt uduktak ɔl o Parici gi ci agɔɔn Yesu o. ");
INSERT INTO mur_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mazi azii ɔl o Parici ki alaat o ceez o Joowo zɔɔz nico, ulute ŋaatodoi, ma anɔ nɛ, “kayo kutuguz gitaz? Eet nico utugu kaal ci meel atɛɛt ɔl biye ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Inoko mã kooŋ kiliŋliŋ kaal nicoko nɔkɔ, atu koca ɔl dook nɔɔnɔ. Ma koca avu alaata o Rom, ma ɔyɔk ceez cinai Joowo o, ma buk koca avu atargany looc cinai o dook.” ");
INSERT INTO mur_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Maje ŋinaante anyak eet cinaaŋ kazi Kayavas ceen alaan ci ceez o Joowo irkite nice. Itiŋa ni niini, ma anek nɔɔgɔ nɛ, “Akɔm niiga gi ci agayu been nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Alaŋ agayu abon adaai ɛɛti codoi ɔla ka calaŋ adaai ɔl dook o?” ");
INSERT INTO mur_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Alaŋ zin bar aduwa niini gi nico oowe cin doon, bar giye baal ɛɛnɛ niini alaan ci adikir ceeze o Joowo irkite nice anyewun Jooi nɔɔnɔ kuduwa gi o ka kiiya kadaai Yesu ka korogozi ɔl o Juz dook. ");
INSERT INTO mur_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Alaŋ zin bar ka kadaak ole o Juz doon, bar ka buk kiiya kolota niini dɔl ci Joowo azaanonek loocok o dook kodoyi. ");
INSERT INTO mur_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Zin akati iitene nice ɛlɛ orooŋit alaata o Juz gɔl ci ka kurukti Yesu kadaak. ");
INSERT INTO mur_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ma giye nico enice alaŋaan Yesu awɔ keyeleza ɛlɛ Judiya, bar itiŋa niini ook kuture o kazi Iviram ajɔŋɔz balal, ma akɔ amɔn niini kibeen nuyak ogin ŋinaante. ");
INSERT INTO mur_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mazi izi lotɛn o gɔɔn aadanɛ ɔl o Juz iiten o vardaŋinto ajɔn, ɔɔtɔ ɔl ci meelik ole o Juz Jerusalɛma ka kɔɔt kutuguzɔ niigi kaal ugeec gɔɔn toonyento. ");
INSERT INTO mur_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Maje ŋaato arɔɔŋ niigi Yesu. Mazi avɔ alotɛ kaluwawe o ceez o Joowo, ijintɔ izitɔ nɛ, “Mayo dim tedec ɛɛti we aku didi?” ");
INSERT INTO mur_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma buk aricanek alaata o ceez o Joowo kibeen ɔl o Parici ɔl zɔɔz ci anek nɛ, “Mã alam eet ci ajowa ŋinti aavɛ Yesu, abon aku aduwaket ka koota kagamta.” ");
INSERT INTO mur_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mazi ŋaan ɛɛl iinya ceen tɔrkɔnɔm ɔɔwa iŋaan kiiya iiteni o vardaŋinto, ook Yesu kuture o kazi Bezani ŋaabaal arogzi niini Lazaros daayiza e. ");
INSERT INTO mur_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ma avɔ agoonek ɔl nɔɔnɔ dayiin ŋinaante, zɛɛ anyaak ni Marta nɔɔgɔ dayiin. Maje Lazaros aromɛ kibeen ɔl ci ona arɛwa ki Yesu dayiin o dook. ");
INSERT INTO mur_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma anyaa Meri ketezewoc ci anyak karacoc ci kazi narat ci aŋɔl madiz ɔrɔɔt ci ataalyai guruce ci meelik gɛr. Ma aku aḏuutɛkɛ Yesu zɔɔ, ma apucpucanek imanɛ. Makacin ɔtɔŋɔl ceez dook madiz ɔrɔɔt. ");
INSERT INTO mur_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Izi ni azi nuyaiti o Yesu kazi Judaz Iskariat baal ka kiiya kataalɔi nɔɔnɔ e nɛ, ");
INSERT INTO mur_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Matɛ laadun alaŋ ataalinɛ karacoc nico guruce ci meelik ka kanycek ɔl o amaat naa?” ");
INSERT INTO mur_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Alaŋ zin bar aduwa gi nico o giye ci arɛɛzi niini ɔl o amaat, bar aduwa o, eeci een niini agoryai. Ma anyak gɔɔn kaboon o guruco niini. ");
INSERT INTO mur_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ma anek Yesu nɔɔnɔ nɛ, “Toŋɔ nɔɔnɔ. Agoonekan niini aneet gi nico o ka kidimdimaneyan aneet iiten o dawinto. ");
INSERT INTO mur_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma ɔl ci amaat o aromenu ki igeet ŋina iinya dook, maje naana alaŋaan bodo karomɛ ki igeet ŋina been nɛɛn.” ");
INSERT INTO mur_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Mazi avɔ azii ɔl ci meel Yesu aavi kuture o kazi Bɛtani, ɔɔtɔ niigi ŋinaante. Alaŋ avɔ niigi ŋinaante o ka kɔɔt kicinit Yesu doon, bar arɔɔŋ buk niigi kɔɔt kicinit Lazaros baal iŋaani Yesu nɔɔnɔ daayiza e. ");
INSERT INTO mur_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Makacin abaabanit alaata o ceez o Joowo gɔl ci ka kurukti Lazaros buk, ");
INSERT INTO mur_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","eeci ɔl ci meel ole o Juz utuweec Yesu giye o itiŋawi niini Lazaros daayiza. ");
INSERT INTO mur_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ma ŋeere iziiyit ɔl ci meel ole baal avunak lotɛn o vardaŋinto e Yesu akunak Jerusalɛm. ");
INSERT INTO mur_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Uduulta ni niigi oto ci kɛɛn ween kɛtɛlɛɛn, ma avɔ arumek nɔɔnɔ gɔl ŋaati agɛrnyi anɛ nɛ, “Atanaaz Jook. Amayuk Jooi eet o aku zaare o Manyi. Amayuk Jooi alaan o Israyil.” ");
INSERT INTO mur_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Anyaaktak ni ɔl Yesu jɔrɔn ci zigiro, ma atɔɔt kiyo ayeedi waragɛwi o Joowo azi nɛ, ");
INSERT INTO mur_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ɔl o Jerusalɛm, má anyaku ŋoliin. Icinit di alaan unooŋ ŋaati akunakuŋ igeet joronte ci zigiro.” ");
INSERT INTO mur_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Maje waanice rak ɔɔwa e alaŋ nuyawa oginɛ kaal nicoko dook aga. Bar akɔ mazi itiŋa Yesu ook tamma titinyonte onin e, aada nuyawa ayeedi kaala ci akati nɔɔnɔ noko waragewe o Joowo keelit tɔ laadun. Gi zin ci baal adiŋdiŋani ɔl nɔɔnɔ o nɛɛn. ");
INSERT INTO mur_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma ɔl baal aromɛ kibeen Yesu iitene baal iŋa