﻿USE sofia;
DROP TABLE IF EXISTS sofia.muh_vpl;
CREATE TABLE muh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES muh_vpl WRITE;
INSERT INTO muh_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ta gügü, te enga gina, Me o tö ake kpï me-ye. ");
INSERT INTO muh_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ta gbü sïkpï la, ngu ngbü ka-ye füh kotö ne bü faaa. Fü sü angbü ꞌduwa mbirrri. Fü *Nzïla Wazi Me akoro angbü endoro füh ngu la, da emere tima. ");
INSERT INTO muh_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Fü Me ayia amala ngü, gü ba dene, “Sü lofo elofo.” Fü sü ayia alofo ꞌduwa raaa! ");
INSERT INTO muh_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Fü Me aceka sü te elofo la. Fü ngü la areke gbü jijia na afa sü. Fü ah aye süka malofo sü ake mbiri sü. Fü ah agü ïrï sü malofo la, gü ba, “ra-sü”. Fü ah agü ïrï mbiri sü la, gü ba, “biti”. Dela tima ta te Me mere gbü gina sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Gbü eꞌbaꞌbasu sïkpï, fü Me ayia amala ngü, gü ba dene, “Kpï koro ekoro etü ngu la, de ah ye süsüka na, de gara ngbü kpa tikpi, de gara ngbü kötö.” ");
INSERT INTO muh_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Te di bala, fü kpï ayia akoro esüka ngu la, ae gara kpa tikpi, fü gara angbü nda-ye kötö, kpah baka te Me mala la. ");
INSERT INTO muh_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Fü Me ayia agü ïrï e la, gü ba, “kokpï”. Dela tima ta te Me mere gbü eꞌbaꞌbasu sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Gbü ebabata sïkpï, fü Me ayia amala ngü, gü ba, “Ah le de ngu, te ngbü faaa ne, biti te-ye ebiti, ꞌburu gbü sü biringbö, de ngu ngbü gbü sü ka-ye kpikpi ye, de tö ngbü nda-ye kpah gbü sü ka-ye kpah kpikpi ye.” Fü e la ayia amere te-ye kpah bala. ");
INSERT INTO muh_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Fü Me agü ïrï ngu, te biti te-ye la, gü ba, “*mere yï-ngu”. Fü ah agü ïrï sü, de te ngu ürü tete na, gü ba, “tö”. Fü Me aceka ngü de te engu mere ne. Fü ngü la areke gbü jijia na fa sü. ");
INSERT INTO muh_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","12","Fü Me ayia amala ngü, gü ba, “Wü jürü e, baka wü gü, wü rü de wü kpü, kö ekö füh kotö ne, de wüh ga, wüh rï, de nguwa ewü di ekö, da erï fï bala füh kotö sene.” Fü wü e la akpo kpah da ekö, da erï te nga ewü bala, baka te Me mala. Fü Me aceka ngü de te engu mere la. Fü ngü la areke gbü jijia na afa sü. ");
INSERT INTO muh_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Dela ꞌburu tima ta te Me mere gbü ebabata sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Gbü ebabala sïkpï, fü Me ayia amala ngü, gü ba dene, “Wü ra de wü fe, de wü küfara, wüh koro ekoro, angbü eküte kokpï, de wüh ye süka biti ake ra. Fü ewü adi kpah egü tamu wü sïkpï, de wü re, de wü lakï ka wü e ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","16","Fü ewü adi kpah elofo sü füh kotö ꞌburu.” Te di bala, fü Me ayia ao ra ake fe, de wü küfara. Fü ra angbü nda-ye miri ka ra-sü. Fü fe angbü nda-ye miri ka biti. ");
INSERT INTO muh_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Me o wü e la ꞌburu kpa tikpi, de wüh di elofo sü füh kotö kpakine, ");
INSERT INTO muh_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","adi eye süka biti ake ra. Fü Me aceka ngü de te engu mere la. Fü ngü la areke gbü jijia na afa sü. ");
INSERT INTO muh_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Dela tima ta te Me mere gbü ebabala sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","21","Gbü eꞌbuꞌburuve sïkpï, fü Me ayia amala ngü, gü ba dene, “Wü si, wü angbe cögbörö nü ngu, de wü gara jürü e, te ewü endoro gbü ngu ꞌburu, koro ekoro, de wüh sibi esibi gbü ngu la.” Fü ngü la amere te-ye kpah bala. Fü Me adu kpah amala ngü, gü ba dene, “Wü lu, de wü gara e, te ewü endoro tikpi ꞌburu, koro ekoro.” Fü ngü la amere te-ye kpah bala. Fü Me aceka wü ngü de te engu mere la. Fü ngü la areke gbü jijia na afa sü. ");
INSERT INTO muh_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Fü ah adu ato wazi fü wü si, gü ba dene, “Wü di ezu azu, de wü sibi asibi gbü wü ngu le ꞌburu.” Fü ah adu kpah amala ngü fü wü lu, gü ba, “Wü sibi kpah esibi füh kotö ne.” ");
INSERT INTO muh_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Dela ꞌburu tima ta te Me mere gbü eꞌbuꞌburuve sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Gbü sïkpï maꞌdiya, fü Me ayia amala ngü, gü ba dene, “Wü nü ka gü, de wü nü ka kötï, bete wü gara jürü wü e te ewü endoro andoro füh kotö ne, koro ekoro te nga nzö nguwa ewü ꞌburu.” Fü e la ayia amere te-ye kpah bala. Fü Me aceka ngü, de te engu mere la. Fü ngü la areke gbü jijia na afa sü. ");
INSERT INTO muh_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Fütanga ngü la, fü Me ayia amala ngü, gü ba dene, “Ani mere la kpara, de ah ngbü gegege baka ani. Fü ani ato wazi fefe, teka de ah ngbü miri gbü nzö wü gara wü e, de te ani mere, baka wü nü de wü lu, de wü si ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Fü ah adu amere wü kpara la kpah bala. Ah mere ewü komoko ake würüse. ");
INSERT INTO muh_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Fü ah ato wazi fü ewü, gü ba, “Yi ngbü da ebï wü ye, de wü nguwa yi sibi asibi füh kotö ne ꞌburu. Fü yi angbü gbü nzö gara wü e, de te ma mere ewü, baka wü nü, de wü lu, de wü si, füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Fü ah adu amala gara ngü fü ewü, gü ba dene, “E-mazü ka-wü ena adi de wü rï zü, bete wü rï-rü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Fü ah adu amala ngü fü wü nü, de wü lu, de wü gara wü e te ewü endoro andoro füh kotö ne ꞌburu, gü ba, “Nda-wü e-mazü ena adi de wü kpa gü, de wü gara kpa wü e ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Fü Me ayia aceka ngü de te engu mere la ꞌburu, gü ba, “Ah reke ꞌduwa ba-neh-ene-la.” Dela ꞌburu tima ta te Me mere gbü sïkpï maꞌdiya. ");
INSERT INTO muh_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Dela ngü te Me mere, te engu o tö ake kpï, de wü e gbü wü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Me nza tima la gbü wü sïkpï maꞌdiya. Fü ah adu afe te-ye gbü sïkpï lorozi. ");
INSERT INTO muh_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Fü ah ayia afe sïkpï la, ao ꞌduwa sïkpï ka-ye tete na. Fü ah amala ngü, gü ba, “Wü kpara te ni mere ewü ne, wüh ena angbü efe te-wü gbü sïkpï lorozi, kpah baka ni, te ni fe te-ni, fütanga mere bi tima, ta te ni mere ne, teka fü ewü amaka wazi gbü ngü la.” ");
INSERT INTO muh_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Dela wü ngü ta te Me mere te enga gina. Ta gügü, te Me o tö ake kpï tete na, ");
INSERT INTO muh_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","6","wü siti wü e, baka wü ti, de wü siti gü, kö ta nda-wü la de, angü Me o agö füh kotö sene, ta nda la de. Ndo kpah ma, angü kpara, te ena adi esö e, nda kpah ma. Amba ngu ngbü edü ka-ye bü esa tö. Fü wü e angbü ega di. ");
INSERT INTO muh_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Fü Me ayia acö tö, afa komoko gbügbü na. Fü ah ayia auru wazi ye gbü tö, de te engu fa la. Fü e la ayia awo wazi, akoro kpara tete. ");
INSERT INTO muh_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Fü Me amala ngü, gü ba dene, “Ni ena ao yï ka-ni to kpa fügö, agbü sü de ïrï ye Edene, teka fü komoko la anü angbü gbügbü na.” ");
INSERT INTO muh_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Fü ah adu amala ngü, teka de nguwa wü rü, de wü züka nguwa rïrü ka mazü, kö agbü yï la. Fü wü e la akö, aga, angbü erï agbü yï la. Fü gara wü rïrü ꞌbasu angbü kpa etü yï la. Gara biringbö la, Me gü ba, rïrï na ena aküwa wü kpara, de wüh kpi de. Fü gara la angbü nda-ye eto talara ngü fü wü kpara, de wüh wu da eye süka siti ngü ake züka ngü. ");
INSERT INTO muh_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Gara mere nzö ngu ta ladü gbü Edene sela, te wü e ngbü ega di. Fü ngu la anü aye süka ye, kpa ekere Edene kpala, akoro wü ngu bala. ");
INSERT INTO muh_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ïrï gina ngu la de Pïsona. Ah ngbü ego nda-ye ekere nga nzö kötï ka wü Avïla. ");
INSERT INTO muh_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Wüh ngbü emaka züka *diki-se gbü sü la, de wü züka wü teme te ngbü eci aci. ");
INSERT INTO muh_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ïrï eꞌbaꞌbasu ngu la de Giyona. Ah ngbü ego nda-ye ekere nga nzö kötï ka wü Kusi. ");
INSERT INTO muh_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ebabata ngu de Idekele, te ngbü ego nda-ye to kpa fügö, ekere nga nzö kötï ka wü Asura. Ebabala ngu de Efürata. ");
INSERT INTO muh_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Fü Me adu aza komoko, de te engu mere la, ao engu agbü yï ka-ye la, de ah di eceka kpï fütanganga na. ");
INSERT INTO muh_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Fü ah agü ïrï komoko la gü ba, Adama. Fü ah ato rïrï fefe na, gü ba dene, “Wü rï-rü de gbü yï ne, mü ena azü azü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Amba ꞌduwa mene engu de biringbö ka talara ngü ne, mü mere e azü de, angü mü ena akpi.” ");
INSERT INTO muh_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Fü Me adu afï nga ngü, gü ba dene, “Te komoko ne ngbü kpikpi ye bala, ah reke de. Ni ena amere gara kpara fü ewü angbü ꞌbasu ake di.” Fü Me ayia ato fïngangü gbü nzönzö. ");
INSERT INTO muh_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Fü Me ayia aza wü nü, de wü lu, ta te engu mere ne, anü di fü Adama, de engu gü ïrï ewü. Fü Adama agü ïrï gbü nzö wü nü la biri biri ꞌburu. Fü ïrï la angbü ꞌduwa bala. Fü Adama angbü egïrï kiri ye, kpara te ani ena angbü ake di. Ah gü ba dene, “Esüka wü nü ne ꞌburu, ni maka kiri ni nda-ni de.” ");
INSERT INTO muh_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","22","Fü Me ayia ato mere ra gbü jia Adama. Te Adama ngbü era tete na, fü Me akoro aü babaga na, aza gara biki sasajikara na biringbö, amere würüse gbügbü na. Fü ah adu ani sü, te engu ü la, alügü yere te nga ye. Fü ah ayia aza würüse la, ato fü Adama, amala ngü fefe, gü ba, “Wara mü dene.” ");
INSERT INTO muh_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Te Adama wu würüse la, fü würüse la areke gbü jijia na afa sü. Fü Adama akpo da ebï ci ka tadu, gü ba dene, “Züka ngü! Kiri ra koro eyi dene! Me to züka würüse eyi fere dene! Biki würüse ne, ah de biki ra. Ngüte würüse ne, ah de ngüte ra. Wüh ena adi eï engu, gü ba, würüse, Angü engu koro gbü komoko.” ");
INSERT INTO muh_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dela si-ngü te komoko ngbü eyia ece wö ye ake ni ye, aza wara ye, alala tete na. Fü ewü adu angbü ake di tïne ba kpara biringbö ne. ");
INSERT INTO muh_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Wü Adama ake wara ye, ta te ewü ngbü ka-wü agbü yï la, wüh ka-wü ꞌbasu mini ngïrïmu. Lümü mere ewü gbü ngü la nda kpah de. ");
INSERT INTO muh_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kpürü ta de mere siti mürü mani, te mani kaka fa nda wü gara nü ꞌburu. Gbü gara ra, fü kpürü ayia akoro amaka wara Adama. Fü ah amala ngü fü würüse la, gü ba dene, “Me gü fü yi neh fe? Me gü ba dene, mere bi wü rïrü de gbü yï ne ꞌburu, yi mere e azü rï ewü de? Ngü la fanü?” ");
INSERT INTO muh_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Würüse la gü ba dene, “Aꞌa! Ah bala de. Me gü ba dene, ‘Ani di ezü wü rï wü rü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Amba ꞌduwa mene rü de kpa etü yï de kpala, ani mere e azü rïrï na de. Ani to kpa ani tete na kpah de, angü ani ena akpi.’ ” ");
INSERT INTO muh_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kpürü gü ba dene, “Me fiti yi ka-ye nda afiti! Yi kpi nda-yi de. ");
INSERT INTO muh_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ah tïrï yi teka te yi ena azü rï-rü la, jia yi ena aü, fü yi awu da aye süka züka ngü ake siti ngü. Fü yi afü te-yi mürü talara, kpah baka ni, Me.” ");
INSERT INTO muh_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Würüse, fü mü ayia aceka kpï. Fü rï-rü la areke gbü jia mü. Fü mü afï, gü ba, “Te ah bala la, ah de züka rï-rü te türü atürü. Te ani zü la, ah ena afü ani baka mürü talara fanü.” Fü würüse la ayia akolo rï-rü la, azü, aza adu di, ato fü watï ye. Fü watï ye na adu kpah azü. ");
INSERT INTO muh_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Wüh kpah bü te ezü rï-rü la de, fü jia ewü ayia aü. Fü ewü awu te-wü, te ewü ngbü ka-wü tïne ngïrïmu. Fü ewü ayia akolo kpa rü, azï eküte wü. ");
INSERT INTO muh_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Etamurago la, fü Me ayia anü agbü yï ka-ye la. Fü wü Adama ake wara ye aje giri Me, te ngbü ekoro la. Fü cürü ayia arï te ewü. Fü ewü akpe awo te-wü gbü zukpa rü. ");
INSERT INTO muh_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","10","Fü Me aï ï, gü ba, “Adama! Adama! Mü neh kaye?” Adama gü ba, “Ani je bü giri ye te ye ngbü ekoro ne. Fü ani akpe awo te-ani teka vi-jia, angü ani akine ngïrïmu.” ");
INSERT INTO muh_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Me gü ba dene, “Mü wu neh baye, gü ba, ani ngbü ngïrïmu? E-mala ngü la fü mü neh da? Te di bala, mü zü rï-rü ka talara ngü, ta te ma mala nganga fü mü ne eyi? Ngü ta te ma mala fü mü teka rïrü la, mü je de, neh teka ne? Angü ma mala ta eyi fü yi, gü ba, yi mere e azü rï-rü la de.” ");
INSERT INTO muh_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adama gü ba dene, “Ngü ka-ni ma. Ah bü de würüse, de te ye to fü ni ne, ah to rï-rü la fü ni me-ye, fü ni azü.” ");
INSERT INTO muh_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Fü Me adu amala ngü fü würüse la, gü ba, “Ye mere ngü la bala, teka ne?” Würüse la gü ba dene, “Ngü ka-ni nda ma, angü kpürü fiti ni ka-ye nda me-ye. Fü ni ayia aza rï-rü la, azü.” ");
INSERT INTO muh_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Fü Me adu amala ngü fü kpürü, gü ba dene, “Kpürü deyï, ma ena ato mere kuru te mü, teka ngü te mü mere la, te ena afa nda wü bu mü ꞌburu. Tïtïne, mü ena adi egbeke te-mü füh bu mü gbü zu-tö. Fü butungu adi ego gbü nzö mü, fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ma ena ao gü esüka yi ake würüse ne, kpah esüka wü nguwa mü, de nguwa wü di enga würüse ne. Fü yi adi engbü de gü esüka yi. Te engu maka mü la, engu ena adi edütü nzö mü. Te mü maka engu la, fü mü adi kpah ede tambu lölö na.” ");
INSERT INTO muh_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Fü Me adu amala ngü fü würüse la, gü ba dene, “Ma ena ato mere kuru te mü, teka *siti ngü te mü mere la. Mü ena adi ebï ye gbü mere cïnga. Gbü ra te mü ena ayaka tete na, mü ena angbü ekeke akeke, fü mü adu ayaka gbü mere cïnga. Gümü watï mü ena adi eke mü. Fü mü angbü fï esakaka na, adi eje ngü kaka-na.” ");
INSERT INTO muh_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Fü Me adu amala ngü fü Adama, gü ba dene, “Baka te mü je ri wara mü, fü mü ayia azü rï-rü la, ta te ma mala nganga fü mü, gü ba, mü mere e azü de ne, te di bala, ma ena ato mere kuru te mü. Ma kïna tö eyi teka ngü ka-mü. Ma ena ao nguwa siti wü rü, baka wü ti, de wü siti gü, ꞌburu gbügbü. Fü ewü adi ekö faaa bala. Fü mü adi emere tima gbü tö la tïne de kpa mü, teka fü wü rï zü adi ekoro gbü tima ka-mü la. ");
INSERT INTO muh_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mü ena amere tima de mere siti wütüsü, te ena angbü ego te mü triii! Fü mü adi ezü kümü gbü wütüsü ka-mü la, zalü akoro di gbü ra te mü ena akpi tete na. Fü ewü ati mü agbü tö. Fü kö mü afere te-ye tö, angü ma fa mü ta gbü tö.” Dela ngü ta te Me mala fü wü kpürü, bete Adama ake wara ye, teka siti ngü ta te ewü mere. ");
INSERT INTO muh_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Fü Adama ayia agü ïrï wara ye la, gü ba, Awa, angü ah de ni ye wü kpara füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Fütanga ngü la, fü Me ayia amörö nü, aza konü nü la, areke, ato fü wü Adama ake wara ye, gü ba, “Wü za, wü to te-wü.” ");
INSERT INTO muh_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Fütanga ngü la, fü Me ayia afï nga ngü, gü ba dene, “Wü Adama koro eyi kpah baka ani. Wüh wu da aye süka siti ngü ake züka ngü eyi. Te ani ce ewü o fï kpa gbü yï kpala la, ah esiti. Angü rü ka *küküwa ne ladü kpa etü yï la. Te di bala, te wü Adama du za rï-rü ka küküwa la, fü ewü azü la, wüh ena angbü bala fï mere badi. Te ah bala la, ah reke de. ");
INSERT INTO muh_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Te di bala, ni ena aza ewü gbü yï la asidi. Fü ewü adi esö e, emaka e-mazü gbü tö, de ta te ni fa ewü gbügbü na ne.” ");
INSERT INTO muh_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Fü Me ayia aliki ewü agbü yï ka-ye la asidi. Fü ah atima gara wü mere *malayïka ka-ye, gü ba, “Wü nü, wü ngbü gbamari era yï ka Edene sela, to kpa fügö. Fü wü adi etïrï kaje ka yï la.” Fü Me aza mere maguruma, te ngbü embele sü ambele ba te-wa la, ato esaka wü malayïka ka-ye la, gü ba, “Wü di ecï sü ekere yï la, angü wü kpara ena anü kpala, aza rï-rü ka küküwa la, azü, fü ewü angbü fï mere badi.” Fü wü malayïka la angbü kpala, atïrï kaje la fï bala. ");
INSERT INTO muh_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Fütanga ngü la, fü wara Adama ayia abï gina enga ye, komoko. Fü ah agü ïïrï na gü ba, Kayïna, angü Me to ye komoko la fü ni me-ye. ");
INSERT INTO muh_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Fü ah adu abï kpah gara ye komoko, fütanga Kayïna, agü ïïrï na, gü ba, Abele. Fü wü jaji la ayia aga ꞌbasu mini. Kayïna, mü ta nda-mü de kpara, te mü ngbü esö yï. Abele, mü nda-mü ta de mürü wü kambiliki. ");
INSERT INTO muh_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Gbü gara ra, fü Kayïna ayia aza tari-e gbü yï ka-ye, ato fü Mere Me. ");
INSERT INTO muh_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","5","Fü Abele ayia aza kpah nda-ye züka enga kambiliki, te zege fa sü. Fü ah amörö, awete soso na, ato ꞌburu fü Mere Me. Nda Kayïna, tari-e, de te engu to ne, Me le nda de. Me le ka-ye ꞌduwa nda Abele. Fü ngü la ayia asiti te Kayïna afa ꞌduwa sü. Fü Kayïna angbü da endunduru gbüra ye teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Fü Me ayia amala ngü fü Kayïna, gü ba dene, “Kayïna deyï, ye ngbü endunduru gbüra ye, neh teka ne? Ngü te siti te-ye, ah de ne ngü ne? ");
INSERT INTO muh_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ah teka ngü, de te ni ce tari-e ka-ye ne? Te ye ena angbü ta emere züka ngü la, de bane, ni ena ale ngü ka-ye de? Amba, te ye ngbü emere *siti ngü la, siti ngü ena angbü kpah efa nga ye, fü ye angbü fï bü emere siti ngü. Te di bala, ah le de ye rü kpekpeke, fü ye aza esaka siti ngü.” Dela ngü te Me mala fü Kayïna. Amba Kayïna le ngü la nda de. ");
INSERT INTO muh_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Fü Kayïna adu akoro amaka enga ni ye. Fü ah ayia afiti enga ni ye, gü ba dene, “Abele deyï, ani nü ka-ani la, andoro agbü gü.” Fü ewü ayia anü andoro agbü gü. Te wüh koro kpala, fü Kayïna ayia atï te enga ni ye, azoro engu, amörö ka. Fü Abele ayia akpi. Fü Kayïna ayia alügü te-ye adu ka-ye kpa ekötï kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Fü Me akoro ayi-ta Kayïna, gü ba dene, “Kayïna deyï, enga ni mü neh kaye?” Kayïna gü ba dene, “Ho! Ma de kpara te ma ngbü eceka kpï fütanga enga wüna me-ra?” ");
INSERT INTO muh_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Me gü ba, “Ma wu ngü la eyi ꞌburu. Mü mere mere siti ngü la bala, neh teka ne? Mü ceka la ngüte Abele, de te mü tökö kötö faaa ne. Ah ba e te ngüte enga ni mü la ngbü eyi eku gba engagira ra, de wüh mörö na kö ni. ");
INSERT INTO muh_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","Teka ngü la, ma kïna mü eyi. Te mü ena adi eru wü e ka-mü gbü tö la, ah tï akö de. Mü ena aru e ma, e-mazü tï akoro fü mü gbü tö tïne kpo de, angü ah de tö de te nzörö ngüte enga ni mü, de te mü mörö ne. Mü tï ao kötï kpah de. Mü ena angbü fï bü endoro füh kotö ne tikpi tikpi.” ");
INSERT INTO muh_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","14","Kayïna gü ba dene, “Apa! Ye liki ni tïne agba ani kpah eyi! Kïna ka-ye ne, ah fa wazi ni tïne eyi ka. Te ni yia eküte ye asidi, fü ni adi ekpe ye fï badi la, ni ena aküwa? De te ni ena angbü endoro la, te kpara maka ni la, ah ena amörö ni de?” ");
INSERT INTO muh_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Fü Me amala ngü, gü ba dene, “Wüh tï amörö ye de. Ni ena aceka kpï fütanga ye me-ni. Kpara de te ena amörö ye la, ni ena ato mere kuru tete, du lorozi.” Fü Me aba tere, ao eküte Kayïna, angü wü kpara ena amörö engu. ");
INSERT INTO muh_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Fü Kayïna ayia engagira Me, akpe ka-ye, angbü ejiji fï bü tikpi tikpi, kpa ekere Edene, to kpa fügö. ");
INSERT INTO muh_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Fütanga ngü la, fü Kayïna ayia abï ye komoko, agü ïïrï na, Enoka. Fü Enoka ayia aga, ajï mere kötï. Fü ah agü ïrï ye te kötï la. ");
INSERT INTO muh_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ye Enoka de Irada. Ye Irada de Meyujayele. Ye Meyujayele de Metusayele. Ye Metusayele de Lemeke. ");
INSERT INTO muh_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Fü Lemeke aza wü würüse ꞌbasu. Ïrï ewü de Ada ake Zïla. ");
INSERT INTO muh_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Fü Ada abï ye, agü ïïrï na Yabala. Wü Yabala de wü kundu ye, ta de wü mürü nü. Wüh jogo ta mere bi wü nü ka kötï. Wüh ngbü endoro de wü nü ka-wü la, da era gbü wü gugu. ");
INSERT INTO muh_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Fü Ada adu abï gara ye de ïrï ye Yubala. Wü Yubala, de wü kundu ye, ta de wü kpara te ewü wu da emï kuꞌdu, da eu wü ga ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zïla bï kpah nda-ye ye komoko, agü ïïrï na Tubala-Kayïna. Engu de mürü boro, te ngbü emï nga nzö wü e zalü ꞌburu. Fü Zïla abï gara ye, würüse, agü ïïrï na Nama. ");
INSERT INTO muh_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Gbü gara ra, fü Lemeke ayia amala ngü fü wü wara ye, gü ba dene, “Ni le abï ci, teka acu ngü ni di gbü jia wü. Wü nga la anga, de wü je la ci ka-ni ne.” Fü ah angbü ebï ci ka-ye la bane, “Ma mörö komoko la teka te engu siya ka te ra, ba e te kpara mörö kpara gbü gü! Ma mörö jaji komoko la teka te engu mü ra, ba e te ma mörö kpara gbü gü!” ");
INSERT INTO muh_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Fü Lemeke ayia amala ngü, gü ba dene, “Ta gügü, Me gü ba, ‘Te kpara mï Kayïna la, ni ena ato mere kuru tete du lorozi.’ Tïtïne, ni emala nda-ni, gü ba, ‘Nda Me ka-ye mba cüküꞌdaye. Amba nda-ni, te kpara mï ni la, ni ena ato kuru tete me-ni, afa nda Me ka!’ ” ");
INSERT INTO muh_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Fütanga kpi ka Abele, fü Awa ayia abï gara ye, agü ïïrï na Sete. Fü ah ayia amala, gü ba dene, “Me to gara ye eyi fü ni da Abele, ta te Kayïna mörö engu ne.” ");
INSERT INTO muh_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Fü Sete ayia aga, abï ye, agü ïïrï na Enosa. Gbü re la, fü ewü akpo da eku gba fü Mere Me, da egbo nga ïïrï na. ");
INSERT INTO muh_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ta te Me mere wü kpara tete na, ah mere ewü gegege baka ye la. ");
INSERT INTO muh_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ah mere ewü ta ꞌbasu, komoko ake würüse. Fü Me ato wazi ye fü ewü, agü ïrï ewü “kpara”. ");
INSERT INTO muh_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Te Adama mere tete baka wü re kama biri teke ꞌbasu de füh ye nzükpa (130), fü ah ayia abï ye, ye komoko, gegege baka ye la. Fü ah agü ïïrï na Sete. ");
INSERT INTO muh_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Fü ah mere fütanga ngü la wü re kama ꞌbajena (800), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Te wü re kaka koro tete ꞌburu kama menewa teke biri de füh ye nzükpa (930), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Fü Sete ayia aga, amere wü re kama biri de füh ye ꞌburuve (105). Fü Sete ayia abï Enosa. ");
INSERT INTO muh_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Fü ah amere fütanga ngü la wü re kama ꞌbajena de füh ye lorozi (807), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Te wü re kaka koro tete ꞌburu baka kama menewa nzükpa de füh ye ꞌbasu (912), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Fü Enosa ayia aga, amere wü re teke bala de füh ye nzükpa (90). Fü Enosa ayia abï Kenana. ");
INSERT INTO muh_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Fü ah mere fütanga ngü la wü re kama ꞌbajena nzükpa de füh ye ꞌburuve (815), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Te wü re kaka koro tete ꞌburu kama menewa de füh ye ꞌburuve (905), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Fü Kenana ayia aga, amere wü re teke bata de füh ye nzükpa (70). Fü Kenana ayia abï Malalele. ");
INSERT INTO muh_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Fü ah mere fütanga ngü la wü re kama ꞌbajena de füh ye teke ꞌbasu (840), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Te wü re kaka koro tete ꞌburu kama menewa de füh ye nzükpa (910), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Fü Malalele ayia aga, amere wü re teke bata de füh ye ꞌburuve (65). Fü Malalele ayia abï Yerede. ");
INSERT INTO muh_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Fü ah mere fütanga ngü la wü re kama ꞌbajena teke biri de füh ye nzükpa (830), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Te wü re kaka koro tete ꞌburu kama ꞌbajena teke bala nzükpa de füh ye ꞌburuve (895), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Fü Yerede ayia aga, amere wü re kama biri teke bata de füh ye ꞌbasu (162). Fü Yerede ayia abï Enoka. ");
INSERT INTO muh_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Fü ah mere fütanga ngü la wü re kama ꞌbajena (800), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Te wü re kaka koro tete ꞌburu kama menewa teke bata de füh ye ꞌbasu (962), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoka ta de kpara te ngbü elala gbü nga Me. Fü Enoka ayia aga, amere wü re teke bata de füh ye ꞌburuve (65). Fü ah ayia abï Metusela. ");
INSERT INTO muh_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Fü ah mere fütanga ngü la wü re kama bata (300), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Fü ah angbü fï bü elala gbü nga Me. Te wü re kaka koro tete ꞌburu kama bata teke bata de füh ye ꞌburuve (365), fü Me ayia aza engu cu ezükü, anü sü di agbü kpï. ");
INSERT INTO muh_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Fü Metusela ayia aga, amere wü re kama biri teke bala de füh ye lorozi (187). Fü Metusela ayia abï Lemeke. ");
INSERT INTO muh_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Fü ah mere fütanga ngü la wü re kama lorozi teke bala de füh ye ꞌbasu (782), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Te wü re kaka koro tete ꞌburu kama menewa teke bata de füh ye menewa 969, fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Fü Lemeke ayia aga, amere wü re kama biri teke bala de füh ye ꞌbasu (182). Fü Lemeke ayia abï ye komoko. ");
INSERT INTO muh_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Fü ah agü ïrï ye ye la Nüwa. Ah gü ba, “Tïtïne dene, cïnga fa te ani sü, teka tö ta te Me kïna ne. Ngü ka mbarase de te ni bï ne, engu ena ale ta-ngü te ani gbü cïnga la.” ");
INSERT INTO muh_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Fü Lemeke amere fütanga ngü la re kama ꞌburuve teke bala nzükpa de füh ye ꞌburuve (595), fï da ebï bi wü gara jaji. ");
INSERT INTO muh_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Te wü re kaka koro tete ꞌburu kama lorozi teke bata nzükpa de füh ye lorozi (777), fü ah ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Fü Nüwa ayia aga, amere wü re kama ꞌburuve (500). Fü Nüwa akpo da ebï wü jaji. Wü di Nüwa te engu bï ewü, wüh de wü jaji komoko bata. Ïrï ewü de Seme, Ama, bete Yapete. ");
INSERT INTO muh_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","2","Ta gügü, o wü kpara kpo da esibi tete füh kotö ne, wü gara wü *di enga me ta ladü. Fü wü di enga me la ayia awu wü jaji würüse de füh kotö ne. Fü wü jaji würüse la areke gbü jia wü di enga me la afa sü. Fü ewü akpo adi eza wü jaji würüse la wara wü tete na. Fü ewü angbü ebï ye de ewü. ");
INSERT INTO muh_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Fü Mere Me ayia awu ngü la. Fü ngü la ayia asiti gbü jijia ꞌduwa ba-neh-ene-la. Fü ah amala ngü, gü ba, “Siti wü kpara de füh kotö ne ngbü efï nda-wü, gü ba, ‘Ani ena angbü fï mere badi?’ Ni le bala de. Angü küte ewü ka-ye de kungba so, te ena azi azi. Te di bala, re ka-ewü ena angbü ngbee kama biri de füh ye teke biri (120), fü ewü akpi.” ");
INSERT INTO muh_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Fü wü jaji würüse la angbü ebï wü ye fü wü di enga me la. Wü jaji de te ewü bï ewü la, ꞌburu wü angbe cögbörö wü kpara, te ewü ga aga, de mere wazi esaka ewü. Fü ewü angbü eï wü jaji la, gü ba, wü Nefilimi, te gü ba, wü di enga mürü wazi. Fü ïrï ewü angbü ewü gbü nga nzö wü sü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ta gbü wü re la, wü kpara ngbü emere *siti ngü, te nga wü sïkpï ꞌburu, efa sü le. Fü fïngangü ka-ewü la angbü esiti gbü jia Me ꞌduwa ba-neh-ene-la. Te Me wu ngü la bala, ");
INSERT INTO muh_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","fü ngü la ake tete ꞌduwa ba-neh-ene-la. Fü ah angbü de mere cïnga, teka wü kpara, ta te ni mere, o füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Fü ah adu afï, gü ba, “Te ah bala la, ni ena amörö ewü amörö ꞌburu asidi, de wü lu, de wü nü, de wü e ta te ni mere ne ꞌburu. Ni ena aürü nga ewü aürü ꞌburu ꞌburu asidi!” ");
INSERT INTO muh_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Amba kpara ta ladü biringbö, te ngü kaka reke gbü jia Me. Ah de Nüwa. ");
INSERT INTO muh_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Dene ngü ka Nüwa. Nüwa ta de kpara esüka wü bu ye füh kotö ne, te ngbü emere züka ngü gbü jia Me, de maguma ye biringbö. Fü Nüwa angbü elala gbü nga Me fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Wü di Nüwa, ïrï ewü de Seme, Ama, bete Yapete. ");
INSERT INTO muh_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Ta gbü wü re la, wü kpara füh kotö ne ngbü ta ememere *siti ngü fï bü efa sü. Wüh ce züka kaje ka Me ne ka. Fü ewü angbü ele ka-wü ꞌduwa siti kaje ka-wü ne engu. Fü ewü angbü fï bü de wü gü esüka wü, da emömörö te-wü. Fü Me awu ngü la. Fü ngü la ayia asiti tete na afa sü. ");
INSERT INTO muh_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Fü Me ayia amala ngü fü Nüwa, gü ba dene, “Ma wu eyi, gü ba, wü kpara füh kotö ne ngbü emere fï bü siti ngü. Wüh le ngü ka-ra de. Wüh ngbü emere ꞌduwa siti ngü ka-wü, de te ewü ngbü ele ne. Wüh siti sü eyi ꞌburu de siti ngü ka-wü la. Te di bala, ma ena atima mere siti ngu, te ena amörö ewü, anza tanguwa ewü, de wü e füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ꞌDuwa de-mü Nüwa, te ma ena aküwa mü aküwa, angü mü de züka kpara gbü jia ra. Te di bala, mü goro *zabu, teka fü mü aküwa gbügbü. Mü goro zabu la gbü züka rü, akolo wü guguvu na ba guvu kambü la. De mü gbo ze zabu la, mü ni de gara e baka biküꞌda la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Mü mere zabu la bane. Mamo na di baka süka lö kama biri teke ꞌbasu de füh ye nzükpa (150), de dedebu na di baka e teke biri de füh ye ꞌburuve (25), maga na to kpa tikpi di baka süka lö nzükpa de füh ye ꞌburuve (15). ");
INSERT INTO muh_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","De mü to nzö zabu la kpa tikpi, de mü ce zeze na mba ce. De mü o möngïtï guvu zabu la. Fü mü aye süka zabu la bata, gara kpa tikpi, gara etüngba, gara to kpa kötö. ");
INSERT INTO muh_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Angü ma ena atima mere siti ngu, fü ah akoro asi füh kotö ne le ꞌburu. Fü wü kpara akpi ꞌburu, kpah de wü nü, de wü gara wü e de te ewü endoro andoro füh kotö ne. Wüh ena akpi, anza tanguwa wü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Amba ꞌduwa de-mü, Nüwa, ma ena aküwa mü nda-ra aküwa, angü mü de kpara te nguwa yi ena asibi füh kotö ne ꞌburu, baka ngü ta te ma mala fü Adama ne. Wü bu mü la ena akpi ꞌburu. Te di bala, ah le de yi lï agbü zabu, de wü wara mü, de wü di mü, de wü wara wü di mü kpah ꞌburu, teka fü yi aküwa esaka mere ngu la. ");
INSERT INTO muh_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ma ena atima kpah nguwa wü nü de wü lu, de wü gara e te ewü endoro andoro füh kotö ne kpaka mü. Te di bala, ah le de mü za nga nzö nguwa ewü ꞌbasu ꞌbasu ꞌburu, momoko na bete caca na, teka fü yi aküwa de ewü agbü zabu kpala. ");
INSERT INTO muh_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Fü mü akö mere bi zü-e, te ewü ena adi ezü. Mü kö kpah nda-yi, ao ꞌburu agbü zabu, teka fü yi adi ezü.” ");
INSERT INTO muh_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Te Nüwa je ngü la bala, fü ah ayia akpo de tima la. Fü ah amere zabu la, akpo da ekö e-mazü, kpah baka e te Me mala fefe na ne. ");
INSERT INTO muh_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Te Nüwa mere tima la nza tete ꞌburu, fü Me adu amala ngü fefe na, gü ba dene, “Nüwa deyï, ni wu eyi, gü ba, ye de kpara te ye ngbü ele ngü ka-ni de maguma ye biringbö, esüka wü kpara, te ewü ngbü emere *siti ngü de füh kotö ne. Te di bala, ni ena aküwa ye, de wü kpara ka-ye ꞌburu aküwa. Ah le de wü reke te-wü, fü wü alï agbü *zabu, teka fü wü aküwa esaka mere ngu, te ena asi ne. ");
INSERT INTO muh_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ye ro wü züka nü, aza kpaka ye agbü zabu kpala. Ye ro ewü te nga nzö ewü biri biri ꞌburu, momoko na lorozi, ni ye na kpah lorozi. Amba, teka siti wü nü, te wü kpara zü de, ye ro ewü ngbee ꞌbasu ꞌbasu, momoko na bete ni ye na. ");
INSERT INTO muh_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","De ye ro kpah nga nzö nguwa wü lu ꞌburu, momoko na lorozi, de caca na kpah lorozi. Ye mere bala, teka fü ewü adu adi esibi füh kotö ne, sidi nga ngu te ena anzürü tete na, angü tanguwa ewü ena adürü. ");
INSERT INTO muh_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kükürü de, angü du sïkpï eyi ngbee lorozi, fü ni atima mere siti agö, te ena alï füh kotö ne ꞌburu. Ah ena alï biti de ra mini, teka wü sïkpï teke ꞌbasu (40). Te di bala, du wü e, de ta te ni o ewü, te ewü endoro andoro füh kotö ne, wüh ena akpi ꞌburu anza anza, fü nga ewü aürü aürü.” ");
INSERT INTO muh_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Dela wü ngü ta te Me mala fü Nüwa. Fü Nüwa ayia amere ngü la, kpah baka e te Me mala fü ye ne. ");
INSERT INTO muh_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Gbü re engu ta te mere ngu si tete na ne, re ka Nüwa koro ta eyi kama maꞌdiya (600). ");
INSERT INTO muh_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Fü Nüwa ayia ake wara ye, de wü di ye, de wü wara wü di ye, areke te-wü, teka alï agbü zabu, angü mere siti ngu ena asi füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Wü nü de wü lu, ta te Me mala nga ewü fü Nüwa ne, fü ewü ayia akoro kpah ꞌburu kpakaka na. Fü züka ewü bete siti ewü, cögbörö ewü bete jürü ewü, ayia alï ꞌburu agbü zabu. Wüh lï ta ꞌburu ꞌbasu ꞌbasu, momoko na bete caca na, kpah baka ngü ta te Me mala fü Nüwa ne. ");
INSERT INTO muh_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","11","Baka te wü Nüwa reke te-wü nza tete, fütanga sïkpï lorozi, fü ewü ayia alï agbü zabu. Ngü la mere te-ye gbü fe ka ꞌbasu, gbü sïkpï kaka nzükpa de füh-ye lorozi. Fü mere siti agö ayia akoro alï currru! baka e te wüh ü kpï aü. Fü wü angbe cögbörö yï-ngu akpo kpah da edü gbü tö kpulu! kpulu! Fü mere siti ngu akpo esi. ");
INSERT INTO muh_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Agö la lï ta biti de ra mini, teka wü sïkpï teke ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Te agö kpo ngbü elï tete na, o wü Nüwa di eyi agbü zabu, ake wara ye, de wü di ye bata ne, Seme, Ama, bete Yapete, bete wü wara ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wü nü ta te Me mala nga ewü fü Nüwa ne, wüh kpah eyi ꞌburu kpala, wü nü ka kötï, abe kpah te wü nü ka gü, de wü lu, bete wü e te ewü endoro andoro füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Wüh yia ta kpah te nga nguwa wü la ꞌbasu ꞌbasu, momoko na ake caca na, lï kpah ꞌburu agbü zabu la, kpah baka ngü ta te Me mala fü Nüwa ne. Baka te wü Nüwa di tïne eyi ꞌburu agbü zabu la, fü Me ayia ani mö nga zabu la gbü nga ewü, gbuuu! atümü gö gö gö! ");
INSERT INTO muh_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Fü agö la ayia alï teka sïkpï teke ꞌbasu. Dela agö nda tïne de! Fü ngu akpo da esi ki ki ki! anü maka te-ye yere! Fü ngu asi ꞌduwa asi ꞌba ꞌba ꞌba! Fü ah akpo ee zabu etikpi. Fü zabu ayia angbü füh ngu la. ");
INSERT INTO muh_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","20","Fü ngu la ayia asi, ata wü angbe cögbörö wü da, de wü rü ꞌburu kpa esa ye. ");
INSERT INTO muh_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Fü wü kpara ayia akpi, de wü nü, de wü lu ꞌburu gbü mere ngu la. ");
INSERT INTO muh_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","23","Fü wü e, de te ewü ndoro andoro füh kotö ne, baka wü angbe cögbörö wü nü, wü zaza, wü kpürü, de wü gara wü jürü wü e, ayia akpi kpah ꞌburu. Wü e kpi nza tanguwa wü ꞌburu ꞌburu. Angü Me le de tanguwa wü e füh kotö ne nza anza ꞌburu ꞌburu asidi. Fü wü Nüwa ayia aküwa ꞌduwa me-wü, de wü e te ewü di de ewü, kpa gbü zabu de kpala. ");
INSERT INTO muh_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Fü mere siti ngu la asi angbü fï bala, teka wü fe ꞌburuve. ");
INSERT INTO muh_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Te mere ngu la ngbü esi tete na teka mere bi sïkpï, fü Me angbü efï nga wü Nüwa, de wü kpara ka-ye, de wü gara wü e ꞌburu, te ewü di de ewü, agbü *zabu la. Fü Me ayia atima mere wege, de ah koro, ah fe füh kotö ne. Fü wege akpo angbü efe. ");
INSERT INTO muh_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Fü mere agö la ayia akolo. Fü ngu te ngbü edü esa tö ne, adu arü. ");
INSERT INTO muh_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Fü mere ngu la akpo da enzürü ce ce ce, teka mere bi wü fe. ");
INSERT INTO muh_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Gbü fe ka lorozi, ah te ekoro gbü sïkpï kaka-na nzükpa de füh ye lorozi, fü zabu la anü angbü enzö gara mere da, de ïrï ye Ararata, angü ngu la ngbü fï bü da enzürü ce ce ce. ");
INSERT INTO muh_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Fütanga ngü la, fü ngu la angbü fï bü da enzürü cüküꞌdaye cüküꞌdaye, teka mere bi wü sïkpï. Ah te ekoro gbü fe ka nzükpa, gbü gina sïkpï kaka-na, fü nzö wü da akpo angbü ekoro etanü mba cüküꞌdaye cüküꞌdaye. ");
INSERT INTO muh_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Fü wü Nüwa angbü fï gbü zabu enzö da sela teka wü sïkpï teke ꞌbasu. Fütanga sïkpï teke ꞌbasu, fü Nüwa ayia aü görö zabu la, ");
INSERT INTO muh_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ayia atima gara lu, te di baka elangba la, de ah nü, ah ceka ngu. Fü lu la anü angbü endoro ka-ye fï bü andoro, zalü te ngu nzürü tete na ꞌburu. Ah du koro kpaka Nüwa nda tïne de. ");
INSERT INTO muh_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Fü Nüwa acï nga lu la ma. Fü ah afï nga ngü, gü ba dene, “Ngu ne nzürü dene ꞌba eyi fanü fanü na?” Fü ah adu aza mö, atima kpah kpala. ");
INSERT INTO muh_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Fü mö anü akoro kpala, amaka ngu te si ka-ye la fï asi gbü wü sü ꞌburu. Fü mö la angbü endoro tikpi tikpi, angü e te engu ena atï fefeh na nda ma. Fü ah ayia alügü nga ye, adu kpaka wü Nüwa. Fü Nüwa, ayia aü görö zabu la, ato kpa ye, aza mö la di, alügü kpaka ye agbü zabu la. ");
INSERT INTO muh_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Fütanga sïkpï kpah lorozi, fü Nüwa adu kpah atima mö la, de engu du kpah aceka la ngu. Fü mö la ayia anü kpah andondoro kpala. ");
INSERT INTO muh_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ah te ekoro etamurago, fü mö la alügü nga ye, angbü edu kpaka wü Nüwa. Nüwa te eceka kpï bane de, gbo! te kpa rü te komö mö la. Fü Nüwa awu teke, gü ba, ngu te enzürü fanü. ");
INSERT INTO muh_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Fü Nüwa adu kpah angbü cüküꞌdaye. Fütanga sïkpï kpah lorozi, fü ah adu kpah atima mö la. Fü mö la adu anü ka-ye tïne kpala ꞌduwa fï. Ah du koro kpaka Nüwa nda tïne de. Te Nüwa wu ngü la bala, fü ah awu, gü ba, “Ngu la nzürü nza eyi.” ");
INSERT INTO muh_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Te ngu la nzürü nza tete na, dela o re ka Nüwa koro eyi kama maꞌdiya de füh ye biri (601). Gbü re la, gbü gina fe, gbü sïkpï kaka-na biri, fü Nüwa ayia asoko nzö zabu la asidi, teka de ni ceka ngü ka ngu la cu de jia ni. Fü ah ayia aceka kpï kpa kötö. Fü ah awu teke, gü ba, ngu nzürü nza eyi ꞌburu. Fü ah amala, gü ba, “Ah le acï nga tö te ena aürü feke.” Fü ah adu angbü teka fe ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ah te ekoro gbü fe ka ꞌbasu, gbü sïkpï kaka-na teke biri de füh-ye lorozi, tö ürü nza eyi kege. ");
INSERT INTO muh_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Te tö ürü nza tete na, fü Me ayia amala ngü fü Nüwa, ");
INSERT INTO muh_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","gü ba dene, “Mü kö ekö gbü zabu la kötö, de wü wara mü, de wü di mü, de wü wara wü di mü ꞌburu, ");
INSERT INTO muh_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","abe kpah te wü nü, de wü e de te mü za ewü kpaka mü la ꞌburu. Wü e la kö ekö ꞌburu kötö, de wüh baya, teka fü ewü adi ezu, da esibi füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Fü wü Nüwa ayia akö kötö, de wü wara ye, de wü di ye, kpah de wü wara wü di ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Fü wü nü, de wü lu, de wü jürü wü e, te ewü di agbü zabu la, akpo angbü ekoro te nga wü ꞌbasu ꞌbasu ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Fütanga ngü la, fü Nüwa ayia aza wü teme, areke gara sü baka *cangalï, teka adi egbo nga ïrï Me tete na. Fü ah aza züka nga nzö wü nü biri biri, kpah de wü züka wü lu, akoro di, awete. Fü ah aza so ewü, acuru baka takpa fü Mere Me. ");
INSERT INTO muh_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Te Nüwa curu so la tete, fü se e la adu afu akoro kpaka Me. Fü se so la areke gbü gü Me ꞌduwa ba-neh-ene-la. Fü Me adu afï nga ngü emaguma ye, gü ba dene, “Ma le tïne adu ato mere kuru te wü kpara füh kotö ne nda-ra de. Angü ma wu eyi, gü ba, wü kpara füh kotö ne ka-wü ꞌburu esiti. Fïngangü ka-ewü ka-ye kü esiti gügü gbü jaji te-wü. Ngü ma, te wüh di bü siti wü kpara la, ma du amörö ewü, anza tanguwa ewü, de wü nü, nda-ra tïne de. ");
INSERT INTO muh_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Te di bala, wü lakï ka wü e füh kotö ne, ena afüfü te-wü akoro ꞌburu, ba e te ni ngbü ele. Bïgü ena akoro anü anza, fü karanga akoro kpah, anü anza. Sü gagaga ena adi ladü, zü ena adi kpah ladü. Ra ena adi ladü, biti ena adi kpah ladü. Wü e la ꞌburu ena angbü efüfü te-wü, zalü akoro di gbü *adu sïkpï, te ni ena agara kotö ne tete na.” Dela ngü te Me mala. ");
INSERT INTO muh_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Fü Me ayia ato wazi fü wü Nüwa de wü di ye, gü ba dene, “Wü di mü ena abï ye, fü ewü asibi asibi füh kotö ne afa sü, teka fü ewü abaya te nga wü sü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ma o yi eyi baka mere miri gbü nzö wü nü, de wü lu, kpah de wü si agbü ngu ꞌburu. Yi ena angbü de mere wazi gbü nzö ewü, fü ewü adi ekpe yi akpe. ");
INSERT INTO muh_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Baka ta te ma to wü rï zü bete kpa wuru fü wü Adama, de wüh di ezü ne, tïtïne ma to kpah so wü nü la eyi ꞌburu fü yi, de yi di ezü. ");
INSERT INTO muh_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ꞌDuwa ngüte, yi mere e adi ezü de. Yi zü so de ngüte gbü ye kpah de. Te yi le amörö nü la, ah le de yi wa awa, fü ngüngüte ayuru feke, fü yi adu azü so la. ");
INSERT INTO muh_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","6","Te kpara mörö kiri ye la, ngü kaka ena adi esiti. Angü ah mörö dela kpara, ta te ma mere engu gegege ba ra ne. Teka ngü la, ma ena ato mere kuru te kpara la. Te ah di de nü te mörö kpara me-ye la, ah kpah esiti, wüh ena amörö engu kpah amörö. Anga te ah di de kpara te mörö kiri ye la, wü miri ena amörö engu kpah amörö, da kiri ye la. ");
INSERT INTO muh_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nüwa, ma ngbü emala ngü fü mü, de wü di mü, gü ba, yi di ebï ye, fü yi asibi gbe gbe gbe, teka de wüh baya, gbü wü sü füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Fü Me adu amala kpah gara ngü fü wü Nüwa de wü di ye la ꞌburu, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Tïtïne ma le de nih nzö ngüte de nih ma. Fü ra angbü mere *vüngüte ka-yi, kpah de wü kundu yi, te ewü ena akoro sidi nga yi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ma ena adi kpah vüngüte ka wü nü de wü gara wü e, ta te wü di de yi agbü *zabu ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ma le anzö ngüte de yi bala, angü ma le amörö wü kpara, anza tanguwa ewü de wü e ꞌburu, nda-ra tïne de. Ma du tïne, atima mere siti ngu, te ena asi füh kotö ne sene, ba e ta te ma mere ne, kpah de. ");
INSERT INTO muh_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Amba dene ngü te ma ena amere, teka asere kuru ngü ka vüngüte la fü yi. Angü, te agö yia eyi ekoro la, tere ena amü akoro, akolo tü kpï kpa tikpi. Te di bala, te yi wu tere la eyi kpa tikpi la, yi ena adi efï nga kïna ka-ra la. Angü ma mala ta, gü ba, ‘Ma tï adu amörö yi de ngu, baka ta te ma mere ne, tïne de.’ Ma kïna kïna la teka fü yi, de wü kundu yi sidi nga yi, kpah de wü gara wü e te ewü endoro andoro füh kotö ne ꞌburu. Kïna ka-ra la ena angbü bala fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Te agö te ebïrï la, tere ena angbü ekoro, da ekolo tü agö la. ");
INSERT INTO muh_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Te ma wu tere la eyi la, ma ena adu afï nga kïna ta te ma kïna fü yi, de wü kpara, de wü nü ꞌburu, gü ba dene, ‘Ma tï adu atima agö te ena asi füh kotö ne, amörö wü kpara ꞌburu ne tïne de,’ ne. ");
INSERT INTO muh_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Fanü te tere la koro eyi, ma ena angbü efï nga kïna, ta te ma kïna te-ra di fü yi, de wü gara e füh kotö ne ꞌburu. Angü kïna ka-ra la ena angbü bala, fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Dela ta ngü te Me mala fü wü Nüwa, gü ba dene, “Ni o tere eyi kpa tikpi, baka kuru ngü te ena angbü esere nga kïna ka-ni, te ni o esüka ani, de wü kpara, abe te wü gara e te ewü di füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Wü di Nüwa, de ta te ewü ngbü de ewü agbü zabu ne, ah de wü Seme, Yapete, bete Ama. Ye Ama ta de Kanana. ");
INSERT INTO muh_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wü di Nüwa ta ngbee bata. Mere bi nguwa wü kpara füh kotö ne, koro ꞌburu guvu wü di Nüwa de bata la. ");
INSERT INTO muh_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nüwa ta de kpara te ngbü esö yï. Ah kpah de gina kpara ta te mere fï. Angü ah ru ta gara rïrü agbü yï ka-ye, de ïrï ye *vinü. Ah ngbü ta emere fï gbü rï vinü la. ");
INSERT INTO muh_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ta gbü gara ra, fü Nüwa ayia anzö fï ne nda bü anzö ꞌduwa ba-neh-ene-la. Fü fï ayia agbo engu kpa esa gugu ka-ye. Te engu ngbü era tete, de fï gbü jia ye la, fü bongo kaka-na ayia agbi eküküte na asidi, ace engu ngïrïmu. ");
INSERT INTO muh_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Fü yeye na de ïrï ye Ama ne, ayia akoro, amaka wö ye, te ra ngbü ngïrïmu. Fü ah ayia anü amala nga wö ye fü wü di enga ni ye de ꞌbasu ne. ");
INSERT INTO muh_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Te wü Seme ake Yapete je ngü la bala, fü ewü ayia aza bongo, abu enzö-kpïrï wü, angbü enü di de kürüfe wü, teka angü ani ena awu ngïrïmu eküte wö ani la wu. Fü ewü ayia anü akoro kpaka wö wü la. Fü ewü aza bongo la, ayia abuka eküte wö wü eta kuru jia wü, areke bongo la eküküte na. ");
INSERT INTO muh_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nüwa, fü fï ayia alofo gbü jia mü. Fü mü adu azükü, aje ngü la, gü ba dene, “Angü ye ni, jaji, ngbü tïne emü ni.” ");
INSERT INTO muh_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Fü Nüwa ayia akïna nguwa wü Ama de wü di ye, gü ba dene, “Me to mere kuru te wü Ama de wü Kanana teka ngü la. Wüh ena angbü labï ka wü bu wü.” ");
INSERT INTO muh_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Fü Nüwa adu agbo nga ïrï Me teka Seme, gü ba, “Me di de Seme, da eto wazi ye fefe na. Fü wü Kanana angbü ba labï kaka-na.” ");
INSERT INTO muh_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Fü Nüwa adu kpah amala ngü teka Yapete, gü ba, “Me di kpah de Yapete, de ah di eto züka ngü fefe na ꞌduwa ba-neh-ene-la. Wüh ena angbü ka-wü ake Seme gbü sü biringbö. Fü Kanana angbü ba labï esaka ewü ꞌbasu mini.” Dela ta ngü ka Nüwa, fütanga mere ngu, te si füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Fü Nüwa adu amere fütanga mere yï-ngu la, baka wü re kama bata teke ꞌbasu de füh ye nzükpa (350). ");
INSERT INTO muh_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Fü re ka Nüwa akoro ꞌburu kama menewa teke ꞌbasu de füh ye nzükpa (950). Fü Nüwa ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Dene ïrï wü kundu ye Nüwa, te ewü di de wü di wü Seme, Ama, bete Yapete, te wüh bï ewü fütanga mere ngu te si ne. ");
INSERT INTO muh_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Dene ïrï wü di Yapete. Ah de wü Gomere, Magoga, Madayi, Yavana, Tubala, Meseke, bete Tïrasa. ");
INSERT INTO muh_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Dene ïrï wü di Gomere. Ah de wü Asekenaza, Rïfata, bete Togarama. ");
INSERT INTO muh_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Dene ïrï wü di Yavana. Ah de wü Elïsa, Tarasisi, Kiti, bete Dodana. ");
INSERT INTO muh_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wüh de wü kpara te ewü ngbü nda-wü era mere yï-ngu. Dela nguwa wü di Yapete. Nguwa ewü la ngbü gbü nga nzö kötï ka-wü kpikpi wü. Mö ka-ewü kpah ꞌdö kpikpi ye kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Dene ïrï wü di Ama. Ah de wü Kusi, Masïrï, Puta, bete Kanana. ");
INSERT INTO muh_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Dene ïrï wü di Kusi. Ah de wü Seba, Avïla, Sabete, Rama, bete Sabetaka. Dene ïrï wü di Rama. Ah de wü Seba ake Dedana. ");
INSERT INTO muh_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Fü Kusi abï kpah gara ye, de ïrï ye Nimeroda. Nimeroda ta de gina kpara, te di de mere miri, de mere wazi esaka ye fa sü. ");
INSERT INTO muh_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimeroda kpah de kpara te ngbü emere wü nü. Fü ah angbü emörö wü nü ꞌduwa ba-neh-ene-la. Teka ngü la, te mü de kpara te ngbü emörö wü nü efa sü la, wü bu mü ena agü ïrï Nimeroda te mü, gü ba dene, “Mü de kpeke kpara, te ngbü emörö wü nü kpah baka Nimeroda.” ");
INSERT INTO muh_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ta te enga gina, sü ka Nimeroda ka-ye agbü Sïnara. Ah ngbü ta kpala gbü nzö wü kpara ka wü kötï bata, *Babïlona, Ereke, bete Akada. ");
INSERT INTO muh_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Fü Nimeroda ayia agbü Sïnara, anü akoro, azoro sü ka wü Asura. Fü ah ajï wü mere kötï kpala, ba e bala. Gara de ïrï ye Nineve, gara de ïrï ye Robota-Ïra, gara de ïrï ye Kala, ");
INSERT INTO muh_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","gara de ïrï ye Resene, te di ezengba wü Nineve ake Kala. Wü kötï bata la ꞌburu ba mere kötï biringbö. ");
INSERT INTO muh_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Dene ïrï wü di Masïrï. Ah de wü Ludu, Animo, Labo, Nefetu, ");
INSERT INTO muh_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patarusu, Kasalu, bete Kafatoro. Kafatoro de mere kundu wü Feleseto. ");
INSERT INTO muh_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Dene ïrï wü di Kanana. Ïrï gina ye Kanana de Sïdona. Ïrï wü gara ewü de wü Ete, ");
INSERT INTO muh_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","wü Yebusa, wü Amora, wü Girigasa, ");
INSERT INTO muh_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","wü Ivo, wü Arako, wü Sino, ");
INSERT INTO muh_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","wü Aravado, wü Cemaro, de wü Amato. Fütanga ngü la, fü wü nguwa Kanana ayia asibi, abaya gbü mere bi wü sü. ");
INSERT INTO muh_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Fü nga nzö kötï ka wü Kanana akpo gbü Sïdona, anü to kpa gbü Gerara, akoro di zalü agbü Gaza. Fü ah anü to kpa gbü *Sodomo, Gomora, Adema, be kpah te Zeboyima, akoro di zalü agbü Lasa. ");
INSERT INTO muh_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Dela ꞌburu ïrï wü di Ama, de nguwa wü kundu ye, kpah de wü mö te ewü ngbü emala. ");
INSERT INTO muh_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Dene ïrï wü di Seme, te di de enga ni ye Yapete ne. Seme ta de mere kundu ye wü di enga *Ebere. ");
INSERT INTO muh_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Wü di Seme ta de wü Elama, Asura, Arafakasada, Ludu, bete Arama. ");
INSERT INTO muh_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Wü di Arama ta de wü Uca, Ula, Getere, bete Masa. ");
INSERT INTO muh_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Fü Arafakasada abï ye, de ïrï ye Sela. Fü Sela abï ye, de ïrï ye Ebere. ");
INSERT INTO muh_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Fü Ebere abï wü ye ꞌbasu. Ïrï gina ewü de Pelege. Wüh gü ïïrï na bala, angü ta gbü wü re kaka-na, Me baya wü kpara füh kotö ne ꞌburu. Ïrï eꞌbaꞌbasu mbarase la de Yoketana. ");
INSERT INTO muh_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Dene ïrï wü di Yoketana. Ah de wü Alemodada, Selefe, Acaramaveta, Yera, ");
INSERT INTO muh_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adorama, Uzala, Dikala, ");
INSERT INTO muh_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimayele, Seba, ");
INSERT INTO muh_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiri, Avïla, Yobaba. Dela ꞌburu de wü di Yoketana. ");
INSERT INTO muh_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Nga nzö kötï ka nguwa wü di Yoketana kpo agbü Masa, anü to kpa fügö enzö mere gümba, zalü akoro agbü Sefara. ");
INSERT INTO muh_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Dela ꞌburu ïrï wü di Seme, de nguwa wü kundu ye, de wü nga nzö kötï ka-ewü, kpah de wü mö ka-ewü, te ewü ngbü emala. ");
INSERT INTO muh_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Dela ꞌburu nguwa wü di Nüwa, de wü kundu ewü, de nga nzö kötï ka-ewü, te di de wü kpara, te ewü sibi füh kotö ne, fütanga mere ngu te si. Te di bala, nih kpah ꞌburu de wü kundu ye Nüwa. ");
INSERT INTO muh_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ta gügü, fütanga mere ngu te si ne, mö ka wü kpara ta ꞌburu biringbö, te wüh ngbü eje ngü gbügbü na esüka wü. ");
INSERT INTO muh_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Fü gara wü kpara angbü ejiji gbü sü la to kpa fügö, da egïrï sü ka kötï. Gbü gara ra, fü ewü anü akoro gbü gara züka sü de füh ye kpini baka kpara la. Fü ewü agü ïrï sü la, gü ba, Sïnara. Fü ewü ayia ao kötï ka-wü kpala. ");
INSERT INTO muh_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Fü ewü ayia afï ngü, gü ba dene, “Wayi, dene züka sü. Ani ngbü ka-ani sene. Te di bala, ah le de ani küꞌda tö, amere biriki di, azö azö kpo kpo kpo, de ah di kpekpeke baka da. Fü ani ajï züka kötï ka-ani sene.” Fü ewü ayia amere biriki ka-wü, teka afa kambü la di, angü rüvü gbü sü la, te wüh ena afa kambü di ne, nda ma. Fü ewü aza mü te di baka biküꞌda la, aꞌbüra füh biriki la, teka de biriki la zoro te-wü, fü ewü angbü kpekpeke. ");
INSERT INTO muh_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Fü ewü adu afï nga gara ngü, gü ba dene, “Ani jï mere kambü, te ena akoro kpa etongo kpï. Ah le de ani mere bala, teka fü ïrï ani awü gbü wü sü ꞌburu. Angü te ani baya faaa füh kotö ne la, ah esiti.” ");
INSERT INTO muh_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Fü Me ayia awu ngü te wü kpara la ngbü emere ne. Fü ah ayia akoro aceka kötï ka wü kpara la, bete mere siti kambü, te wüh ngbü ejï ne. ");
INSERT INTO muh_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Me gü ba, “Tïtïne wü kpara ne, nguwa ewü ngbee biringbö. Mö ka-ewü kpah biringbö. Te wüh kpo eyi emere gina ngü bane, te ni tata ewü de la, wüh ena anü de ngü ka-wü la kpa engagira nü. Ngü te ena afa ewü tïne ma. ");
INSERT INTO muh_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Amba ni le ngü la bala de. Te di bala, ani nü enü, abaya ewü, de ani o mö ka-ewü kpikpi ye kpikpi ye, teka de wüh mere e aje ngü ka wü bu wü tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Fü Me akoro, abaya ewü kpah bala. Fü ngü ka kötï ka-ewü, de mere kambü la asiti ꞌburu. Fü ewü abaya tïne faaa! ago angbü gbü nga nzö wü sü füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dela si-ngü te wüh gü ïrï sü la tete na, gü ba, *Babïlona ne. Angü gbü sü la, Me füfü mö ka wü kpara, te ewü ngbü ta emala biringbö ne. Fü ah ayia abaya ewü füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Dene ïrï wü kundu ye Seme. Sidi nga wü re ꞌbasu fütanga mere ngu te si ne, fü re ka Seme ayia akoro kama biri (100). Fü Seme ayia abï ye komoko, agü ïïrï na Arafakasada. ");
INSERT INTO muh_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Fü ah amere fütanga ngü la, wü re kama ꞌburuve (500), fï da ebï gara wü jaji. Fü Seme ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Fü Arafakasada ayia aga, amere wü re teke biri nzükpa de füh ye ꞌburuve (35). Fü ah ayia abï Sela. ");
INSERT INTO muh_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Fü ah amere fütanga ngü la wü re kama bala de füh ye bata (403), fï da ebï gara wü jaji. Fü Arafakasada ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Fü Sela ayia aga, amere wü re teke biri de füh ye nzükpa (30). Fü ah ayia abï *Ebere. ");
INSERT INTO muh_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Fü ah amere fütanga ngü la wü re kama bala de füh ye bata (403), fï da ebï gara wü jaji. Fü Sela ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Fü Ebere ayia aga, amere wü re teke biri nzükpa de füh ye bala (34). Fü ah ayia abï Pelege. ");
INSERT INTO muh_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Fü ah amere fütanga ngü la wü re kama bala teke biri de füh ye nzükpa (430), fï da ebï gara wü jaji. Fü Ebere ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Fü Pelege ayia aga, amere wü re teke biri de füh ye nzükpa (30). Fü ah ayia abï Ruu. ");
INSERT INTO muh_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Fü ah amere fütanga ngü la wü re kama ꞌbasu de füh ye menewa (209), fï da ebï gara wü jaji. Fü Pelege ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Fü Ruu ayia aga, amere wü re teke biri nzükpa de füh ye ꞌbasu (32). Fü ah ayia abï Seruga. ");
INSERT INTO muh_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Fü ah amere fütanga ngü la wü re kama ꞌbasu de füh ye lorozi (207), fï da ebï gara wü jaji. Fü Ruu ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Fü Seruga ayia aga, amere wü re teke biri de füh ye nzükpa (30). Fü ah ayia abï Nayora. ");
INSERT INTO muh_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Fü ah amere fütanga ngü la wü re kama ꞌbasu (200), fï da ebï gara wü jaji. Fü Seruga ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Fü Nayora ayia aga, amere wü re teke biri de füh ye menewa (29). Fü ah ayia abï Tera. ");
INSERT INTO muh_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Fü ah amere fütanga ngü la wü re kama biri nzükpa de füh ye menewa (119), fï da ebï gara wü jaji. Fü Nayora ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Fü Tera ayia aga, amere wü re teke bata de füh ye nzükpa (70). Fü ah akpo ebï ye. Ah bï wü jaji bata, de ïrï wü Abarama, bete Nayora, bete Arana. Dela ïrï wü kundu kundu ye Seme, te wüh bï ewü fütanga mere ngu ta te si ne. ");
INSERT INTO muh_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","28","Dene ngü ka wü di Tera. Wü di Tera ta bata, de ïrï wü Abarama, Nayora, bete Arana. Wü Tera ngbü ta de wü di ye la agbü gara sü de ïrï ye Ura. Fü Arana ayia abï ye, agü ïïrï na Loto. Fütanga ngü la, fü Arana ayia akpi, ciki gbü sü de te wüh bï engu gbügbü, agbü Ura la, o wö ye na di la ladü de jia ye. ");
INSERT INTO muh_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Fü wü Abarama ake Nayora aga, akoro cögbörö wü komoko. Fü ewü ayia aza wü würüse. Ïrï wara Abarama ta de Sarayï. Ïrï wara Nayora nda de Mïleka. ");
INSERT INTO muh_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Amba Sarayï bï ye ta nda de. ");
INSERT INTO muh_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Gbü gara ra, fü Tera ayia aza wü Abarama ake wara ye, bete Loto, te di de kundu ye ne, ace Ura, teka anü agbü tö ka wü *Kanana. Fü ewü anü, anü, akoro gbü gara sü etüngba, de ïrï ye Arana. Fü ewü angbü sela. ");
INSERT INTO muh_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Fü Tera ayia agbe, angü re kaka koro eyi wü re kama ꞌbasu de füh ye ꞌburuve (205). Fü ah ayia akpi sela. ");
INSERT INTO muh_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Gbü gara sïkpï, te re ka Abarama koro tete ꞌburu baka re teke bata nzükpa de füh ye ꞌburuve (75), fü Me ayia amala ngü fü Abarama, gü ba dene, “Abarama, mü yia eyia, de mü ce gba mü, de wü mürü mü, de mü go ngbü agbü gara ganzi sü, te ma ena agü tatamu fü mü. ");
INSERT INTO muh_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Te mü le ngü ka-ra la eyi la, ma ena ato wazi fü mü. Fü wü kundu mü abï ye, asibi, afa sü. Fü nguwa yi asibi, akoro ba mere bi nguwa wü kpara. Ma ena ato wazi fü mü, fü ïrï mü adi ewü awü gbü wü sü ꞌburu. Fü ra adu angbü eto züka ngü fü mere bi wü kpara teka ngü ka-mü. ");
INSERT INTO muh_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mene kpara te ena amere züka ngü fü mü, ma ena amere kpah züka ngü fefe na. Amba mene kpara te ena asiri mü, ma ena akïna engu. Ma ena aküwa nguwa wü kpara füh kotö ne ꞌburu teka ngü ka-mü.” ");
INSERT INTO muh_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Te Abarama je ngü la bala, fü engu amere wü ngü la kpah ce ꞌburu bala. Fü Abarama ayia agbü Arana sela, aza wara ye, ake Loto, te di de ye enga ni ye ne. Fü ewü akö kpah wü labï ka-wü, te ewü maka de sela ne, de wü nü ka-wü, de wü e ka-wü ꞌburu, anü di kpa gbü tö ka wü *Kanana. Te wü Abarama nü koro tete agbü tö ka wü Kanana, ");
INSERT INTO muh_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","fü ewü ayia aguru sü, anü akoro kpa gbü gara sü kpala de ïrï ye Sekeme, esa mere rü ka More. Ta gbü wü re la, wü Kanana ngbü ta la fï era kötï gbü sü la. ");
INSERT INTO muh_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Fü Me ayia agü tamu ye fü Abarama, gü ba dene, “Te gara, ni ena ato tö ne ꞌburu fü wü, de wü kundu ye, teka fü ewü angbü gbügbü fï mere badi.” Te Abarama je ngü la tete, fü engu adu areke sü baka *cangalï, teka agbo nga ïrï Me tete na, angü Me gü tamu ye fefe na gbü sü engu la. ");
INSERT INTO muh_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Fütanga ngü la, fü Abarama ayia anü to gbü kpa ye ka kokpa, anü akoro kpa enzö gümba, te di to kpa fügö ka Betele. Fü ah ayia ade mba gugu sela, ezengba Betele ake Ayï. Fü engu ayia areke sü teka adi egbo nga ïrï Mere Me, da ecu ngü Mere Me sela. ");
INSERT INTO muh_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Fü Abarama angbü fï bü eka te-ye ce ce ce bala, enü kpa edebu sü to gbü kokpa. Dela ngü ta te Abarama mere, te Me ï engu tete, fü ah ayia ace Arana ne. ");
INSERT INTO muh_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Fütanga wü ngü la, fü tala ayia atï gbü sü ka wü Kanana ꞌburu. Te di bala, fü wü Abarama ayia akpe anü angbü la takü agbü *Ezepeto, teka ngü ka mere siti tala la. ");
INSERT INTO muh_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Baka te ewü yia ngbü enü tete, fü ewü anü akoro gbamari ede Ezepeto. Fü Abarama ayia amala ngü fü wara ye, gü ba dene, “Sarayï deyï, ani koro eyi gbamari ede Ezepeto dene. Te ani ena akoro kpala la, wü kpara ka Ezepeto ena agü jia wü te ye, awu ye, de te ye su afa sü ne. Gümü ye ena ake ewü. Te di bala, te wüh ena awu, gü ba, ni de watï ye la, wüh ena amörö ni teka ngü ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Amba dene mba gara mani, te ani ena amere, teka fü wü kpara ka Ezepeto amere ni areke areke, angü wüh ena amörö ni. Te wüh yi-ta ye la, ye mere e amala fü ewü, gü ba, ‘Ni de watï ye,’ ne de. Ye mala fü ewü, gü ba, ‘Ni ka-ni de enga ni ye.’ ” Abarama mere ta mani la bala, angü Sarayï su fa sü. ");
INSERT INTO muh_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Fü ewü ayia anü akoro kpa gbü Ezepeto. Baka te wü kpara ka Ezepeto wu Sarayï, fü Sarayï ayia asu gbü jia ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Fü wü angbe cögbörö kpara ka miri ayia kpah awu Sarayï. Fü ewü anü de ngü la, amala fü miri, gü ba, “Ani maka gara ye würüse kpane, te su fa sü!” Fü ewü adu aza Sarayï, anü de engu kpa gba miri. Fü Sarayï ayia angbü kpala. ");
INSERT INTO muh_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Fü miri angbü emere ngü Abarama ereke ꞌduwa ba-neh-ene-la. Fü ah amala, gü ba, “Ni le ase Sarayï wara ni tete na.” Fü engu ato mere bi wü e fü Abarama, baka wü labï, wü kambiliki, wü yiti, kpah de wü nü, te wüh nü fefeh, ba wü dongï bete kamele, teka ngü ka Sarayï. ");
INSERT INTO muh_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Fü Me ayia atima mere siti keke agba miri la, de wü kpara ka-ye ꞌburu, teka ngü ka Sarayï, angü ah ka-ye de wara Abarama. ");
INSERT INTO muh_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Te miri wu bala, fü mamaguma ayia anzu. Fü engu adu aï Abarama, amala ngü fefe, gü ba dene, “Mene ngü de te ye mere de ni de bane, ah de ne ngü ne? Ye mala ta fü ni, gü ba dene, ‘Würüse ne de enga ni ni.’ Ye su wu fü ni bala teka ne? Te ye ena amala ta fü ni, gü ba, ‘Sarayï ka-ye de wara ni la,’ ah ena areke ta afa sü. ");
INSERT INTO muh_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ye fiti ni, gü ba, ‘Sarayï ka-ye nda de enga ni ni.’ Fü ye ayia ale, gü ba, ‘Ni za engu eza wara ni tete.’ Dela ꞌba züka ngü na? Te di bala, wara ye eyi dene! Ye za engu eza, de wü nü ka-wü!” ");
INSERT INTO muh_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Fü miri adu atima wü kpara ka-ye, de wüh gï nga Abarama, ce te kaje. Fü Abarama aza wara ye, de wü e ka-ye ꞌburu, ayia adu ka-wü agbü Kanana. ");
INSERT INTO muh_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Dela mene ngü ta te mere te-ye fü wü Abarama ake Sarayï agbü *Ezepeto. Wüh yia du ka-wü ta agbü *Kanana, kpah de wü Loto. ");
INSERT INTO muh_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Fütanga ngü la, fü wü e ka Abarama ayia asibi tïne afa sü, ah de wü se, kpah de wü nü, ba wü yiti, wü kambiliki, de wü meme. ");
INSERT INTO muh_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Baka te wü Abarama du koro tete agbü Kanana sela, fü ewü angbü endondoro te nga nzö wü sü sela, zalü anü akoro agbü Betele, gbü sü ta te ewü mere gugu ka-wü tete na te enga gina, ezengba Betele ake Ayï ne. ");
INSERT INTO muh_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Sü engu la, ah ta kpah de sü, te Abarama gbo nga ïrï Me tete na, te enga gina ne. Fü Abarama adu angbü egbo nga ïrï Me kpah sela. ");
INSERT INTO muh_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Wü Abarama ngbü ta ejiji te nga wü ndoro la kpah fï bü ake Loto, te di de ye enga ni ye ne. Loto ta kpah de mere bi wü kpara gbü nga ye, kpah de wü nü, ba wü yiti, wü kambiliki, de wü meme esaka ye. ");
INSERT INTO muh_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Baka ta te wü nü sibi esaka ewü, ake afudu ye fa sü ne, sü du be, fü ewü angbü tete ꞌburu gbü sü biringbö, ne nda tïne de. ");
INSERT INTO muh_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Angü wü kpara ta te ewü ngbü eceka kpï fütanga wü nü ka Abarama, bete nda Loto ne, du ngbü ewü nga esüka wü, teka ngü ka sü te be de ne. Da ewü ta te ewü ena anü to kpa ekati ne nda ma, angü wü kpara ka Kanana ngbü ta gbü sü la. Wü Pereze ngbü ta nda-wü kpah edebu sü gbü sü la. ");
INSERT INTO muh_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Te di bala, fü Abarama ayia amala ngü fü Loto, agü ba, “Ye ni deyï, ni le fü nga adi engbü esüka ani de. Ngü de te wü kpara ka-ani ngbü ewü nga di esüka wü la, ah de siti ngü. Angü ani ka-ani mürü. ");
INSERT INTO muh_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Te di bala ne, te sü de sene be nda de la, ye ceka la mere siti nga nzö sü, de to kpa fügö ne. Dela ꞌburu sü, te ani ena angbü gbügbü na. Te ah bala la, ani ye süka ani eye tïtïne. Ye ceka nda-ye sü eceka. Te ye ngbü ele nda-ye angbü ciki sene la, ni ena aza nda-ni tïne mene sü, te di to kpa fügö ne. Te ye le di mene sü, te di to kpa fügö ne la, ni ena angbü nda-ni tïne ciki sene. Angü ngü ka nga esüka wü kpara esiti.” ");
INSERT INTO muh_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Fü Loto ayia aceka kpï, awu sü ede ngu Yürüdene, te nü koro zalü kpa gbü Sügara ne. Fü sü engu la ayia atï te nga jijia ꞌduwa kpini, angü ah ta de züka sü, te ngu ngbü gbügbü na fï bü cakö. Ah ta kpah baka sü ka yï, te Me o agbü Edene ne. Ah ngbü kpah baka tö ka wü Ezepeto, te ngu fa gbügbü na sü ne. Angü ngü la mere te-ye ta gügü, o Me siti *Sodomo ake Gomora la de. ");
INSERT INTO muh_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Te Loto wu bala ne, fü ah ayia afe nda-ye mene sü, te di ede ngu Yürüdene to kpa fügö ne. Fü ewü ayia aye süka wü ake afudu ye. Fü Loto ago angbü nda-ye kpala. Dela ta ngü te wü Abarama ake Loto ye süka wü tete na. ");
INSERT INTO muh_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abarama ngbü nda-ye ta fï gbü sü ka wü Kanana sela. Fü Loto anü angbü nda-ye ede wü mere kötï te di era ngu. Fü ah ade gugu ka-ye gbamari ede gara mere kötï, de ïrï ye Sodomo. ");
INSERT INTO muh_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wü kpara ka Sodomo ka-wü ta siti wü kpara, te ewü ngbü ememere fï bü *siti ngü gbü jia Me. ");
INSERT INTO muh_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ta te Loto go tete gbü nda-ye sü, fü Me ayia akoro kpaka Abarama, amala ngü fefe na, gü ba, “Mü e la jia mü, de mü ceka nga nzö wü sü ne ꞌburu. Mü ceka la kpï to kpa fügö, to kpa ekati, kpah to gbü kokpa bete kamisü. ");
INSERT INTO muh_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Wü sü de te mü ngbü eceka la, te gara, ma ena ato ato ꞌburu fü yi, de wü kundu mü, teka fü ewü angbü gbügbü fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","De-ra Me, ma ena ato wazi fü wü kundu mü la, teka fü ewü angbü ebï wü ye, da esibi efa sü, ba zu-tö la. Angü kpara te ena atanga ewü anza ne nda ma. ");
INSERT INTO muh_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Te di bala, ah le de mü yia eyia, mü kpo, mü ndoro te nga nzö wü sü la ꞌburu. Mü ceka reke areke, angü dela eyi sü te ma ena ato fü yi.” ");
INSERT INTO muh_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Te Abarama je ngü de te Me mala fü ye de bala ne, fü ah ayia ago agbü Eberone, ade gugu ka-ye angbü kpala, esa mere rü ka kpara de ïrï ye Mamare. Fü Abarama adu areke sü baka *cangalï kpala, teka adi egbo nga ïrï Me tete na. ");
INSERT INTO muh_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","5","Ta gbü wü re la, gara mere miri ta ladü de ïrï ye Kedora-Lawomera. Ah ngbü ka-ye ta to kpa fügö, gbü tö ka wü Elama. Ah de mere kpeke miri, de mere bi wü kpara esa lö ye. Fü Kedora-Lawomera aza wü marajümïya ka-ye, anü de ewü, atï gü gbü nzö mere bi nguwa wü kpara, baka wü kpara ka *Sodomo, Gomora, Adema, Zeboyima, bete wü Bela. Fü Kedora-Lawomera ayia afa wü kpara la, adu angbü gbü nzö ewü ꞌburu de wazi. Fü ah ato rïrï fü ewü, de wüh di eto mere bi jiase fü ni, te nga wü re ꞌburu. Fü wü kpara la ale, akpo angbü eto jiase la, teka wü re nzükpa de füh-ye ꞌbasu. Fütanga re nzükpa de füh ye ꞌbasu, fü nguwa wü miri de ꞌburuve, te Kedora-Lawomera ngbü gbü nzö ewü ne, adu ace ka-wü kpo da eto jiase fü Kedora-Lawomera. Fü re afü biringbö. Fütanga re biringbö la, fü Kedora-Lawomera ayia amala ngü, agü ba, “Te di bala, ni ena ato kuru te wü kpara te ewü gü ba, ‘Ani le ngü ka-ni tïne de,’ ne.” Fü wü Kedora-Lawomera ayia abiti te-wü de wü gara wü miri bata, teka de wüh le ta-ngü te ni. Wü miri la ta miri ka wü Sïnara de nda wü Elasara, bete nda wü Goyi. Fü ewü adu amaka wazi, teka wü mene wü miri, de te ewü gü ba, “Ani le tïne aje rïrï ka Miri Kedora-Lawomera de,” ne. Fü ewü ayia de wü marajümïya ka-wü la, anü atï de gü gbü nzö nguwa wü Refe, de wü Zuza, de wü Eme, ayia aza esaka ewü. ");
INSERT INTO muh_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Fü ewü adu kpah, atï de gü gbü nzö wü Oro, kpa füh da. Fü ewü aliki wü Oro zalü akoro di kpa gbü ndu, agbü Eleparana. Fü ewü afa wü Oro. ");
INSERT INTO muh_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Fü ewü adu kpah anü agbü Ene-Misapata, afa wü Amaleke, de wü Amora kpah bala. ");
INSERT INTO muh_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Ta te miri ka Sodomo, de wü gara wü miri gbü nga nzö sü la, je ngü la bala, fü ewü ayia abiti wü marajümïya ka-wü, anü akoro gbü mere sü tele tele de ïrï ye Sidimi. Fü ewü areke te-wü sela, teka atï de gü gbü nzö wü Kedora-Lawomera. ");
INSERT INTO muh_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Fü wü Kedora-Lawomera ayia asö gü, afa wü miri ka Sodomo de wü bu ye la ꞌburu. Fü wü miri ka Sodomo ayia de wü bu ye, auru de woro. Fü miri ka Sodomo ake miri ka Gomora akpe atï gbü wü cudu, te ewü cu fa sü, angü angbe cögbörö wü cudu fa ta gbü sü la sü. Fü wü gara wü bu wü ayia akpe nda-wü to kpa enzö mere gümba, aküwa ka-wü. ");
INSERT INTO muh_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Fü wü marajümïya ka Kedora-Lawomera ayia arï gbü wü mere kötï ka Sodomo ake Gomora, akö wü e ka-ewü, de wü gara kpara gbü nga ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Fü ewü ayia azoro kpah Loto, te di de ye enga ni ye Abarama, de wü e ka-ye ꞌburu, angü engu ra kötï ta gbamari ede Sodomo. Fü ewü ayia anü sü de engu, de wü e kaka-na la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ta gbü wü lakï la, Abarama ngbü ta la fï esa mere rü ka Mamare ne. Wü Mamare ngbü ta kpah gbü sü la, de wü di enga ni ye ꞌbasu. Ah de wü Esokole ake Anera. Nguwa wü Mamare ta de Amora. Nguwa Abarama nda de *Ebere. Nguwa wü Mamare nzö ta ngüte de wü Abarama. Fü gara kpara ta te kpe küwa gbü gü la, ayia akoro amala ngü fü Abarama, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","“Wü Kedora-Lawomera koro de gü, siti wü sü ka-ani eyi ꞌburu. Wüh zoro Loto, nü sü di kpah eyi.” Te Abarama je ngü la, fü engu ayia ꞌduwa, abiti wü komoko ka-ye, te ewü wu ngü ka gü kpah kpo. Fü ah adu kpah abiti wü vüngüte ka-ye ꞌburu. Fü ewü ayia, baka wü kpara kama bata nzükpa de füh ye ꞌbajena la (318), anü afa nga wü Kedora-Lawomera, zalü akoro di kpa gbü Dana. ");
INSERT INTO muh_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Te wü Abarama nü koro tete kpala, fü ah ayia afï nga gara mani. Fü ah ayia aye süka wü kpara ka-ye la, gü ba, “Wü gara fü nda-wü bane, de wü gara fü nda-wü to bane.” Fü ewü ayia gbü biti, anü atï de gü gbü nzö wü Kedora-Lawomera, agüka ewü gbü ïrï-to. Fü wü Abarama ayia asö gü, afa ewü ka. Fü ewü ayia aliki ewü, anü akoro de ewü nengete kpa gbü Oba. ");
INSERT INTO muh_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Fü wü Abarama akö wü e de esaka wü Kedora-Lawomera, de ta te ewü kö gbü gü ne ꞌburu. Fü Abarama adu kpah aza Loto, de wü gara kpara, ta te wüh zoro ewü, de wü würüse ne ꞌburu, adu di. ");
INSERT INTO muh_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Te Abarama ngbü edu tete, fü miri ka Sodomo ayia anü amaka Abarama kpa te kaje, ede Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Miri ka Salema ta ladü de ïrï ye Meleke-Sadiki. Engu ta de *mürü gele ka Mere Me. Fü Meleke-Sadiki ayia aza e-mazü bete fï *vinü, akoro di, ato fü wü Abarama. Fü ewü ayia azü. ");
INSERT INTO muh_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Fü Meleke-Sadiki ayia asü ngüsü gbü nzö Abarama, amala ngü fefe, gü ba dene, “Ma ngbü eku gba fü Mere Me, te o tö ake kpï ne, de ah to wazi fü mü. ");
INSERT INTO muh_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ma gbo nga ïrï Me, angü ah to wazi eyi fü mü, fü mü afa wü vügü ka-mü di.” Fü Abarama ayia aza mere bi wü e, de te engu kö gbü nga wü Kedora-Lawomera ne, aye süsüka ba e nzükpa. Fü ah ayia aza bibiri na, esüka wü nzükpa la, ato fü Meleke-Sadiki te ïrï Me, baka tari-e, teka agbo nga ïrï Me di. ");
INSERT INTO muh_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Fü miri ka Sodomo ayia amala ngü fü Abarama, gü ba dene, “Ye za du wü e, ta te wü vügü ka-ani kö esaka ani la, eza fü ye. Ni ele nda-ni bü wü kpara ka-ni, de ye lügü ewü fü ni.” ");
INSERT INTO muh_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Fü Abarama alügü ngü fefe, gü ba dene, “Ye za wü kpara ka-ye eza, de wü e la ꞌburu. Ni le aza wü e la nda-ni de, angü ni kïna kïna eyi, de ïrï Mere Me, te o tö ake kpï ne, ");
INSERT INTO muh_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","gü ba, ni tï aza e ꞌduwa kpo de. Te ah ena adi kpah mene engu, te di mba cüküꞌdaye la, ni za nda-ni kpah de. Angü ye ena agü ba, ‘Ni to wazi fü ni, Abarama, me-ni.’ ");
INSERT INTO muh_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ni za nda-ni eyi bü wü e-mazü, de te wü kpara ka-ni la zü te kaje. Wü vüngüte ka-ni, de te ani di de ewü ne, wüh za nda-wü e eza.” Dela ngü ta te Abarama mere, te engu küwa Loto esaka wü Kedora-Lawomera, te wüh zoro engu tete gbü gü ne. ");
INSERT INTO muh_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Gbü gara sïkpï, fü Me ayia akoro kpaka Abarama gbü biti, amala ngü fefe, gü ba dene, “Abarama, mü kpe cürü de. Ma ena adi fü mü ba *vüngüte ka-mü. Fü ra angbü eceka kpï fütanga mü me-ra. Fü ra angbü fü mü baka mere ngisi ka-mü. Fü ra ato mere bi wü züka e fü mü, angü mü to maguma mü eyi fere.” ");
INSERT INTO muh_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Fü Abarama amala ngü, gü ba, “Wayi bala, Mere Miri ka-ra, amba e te mü ena ato fere ne, ah baka neh ene? Angü wü di ra kpah ma ne. Amba, te ma ena akpi la, kpara te ena afï nga ra, areke mbükü ra, neh da? Te wü di enga wüna di ꞌburu nengete agbü Arana kpala ne? Kpara te ena aza e-nga-kpa ra, te gara, ena adi kpah bü enga cörö ka-ra, te ma ga engu, de ïrï ye Eliyezere ne.” ");
INSERT INTO muh_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Me gü ba dene, “Fanü fanü, enga cörö ka-mü la, ah tï aza wü e-nga-kpa mü, fütanga kö mü me-ye nda de. Kpara ladü te ena aza wü e-nga-kpa mü la sidi nga kö mü. Ah ena adi zu ye mü, te mü ena abï engu cu me-mü.” ");
INSERT INTO muh_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Fü Me amala ngü fü Abarama, gü ba, “Mü koro la kpa etanü, de mü ceka wü küfara de kpa tikpi ne. Mü tï eyi atanga ewü? Ma ena ato wazi fü mü. Fü wü kundu mü asibi, akoro kpah coboro, baka wü küfara, de te mü eceka ewü etongo kpï ne.” ");
INSERT INTO muh_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Fü Abarama ato maguma ye fü Me. Fü Me adu aceka engu baka züka kpara ka-ye teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Fü Me amala ngü fü Abarama, gü ba dene, “Abarama, mü wu kpo, ga, ma de kpara te ma ï mü, te mü ngbü ta agbü Ura kpala. Fü ra amala ngü fü mü, de mü ce sü te wüh bï mü gbügbü na ne, teka fü mü akoro angbü gbü *Kanana sene. Fü ra aceka kpï fütanga yi te kaje la, akoro de yi sene, teka fü ra ato tö ne fü yi, fü yi angbü tïne gbügbü na.” ");
INSERT INTO muh_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abarama gü ba dene, “Wayi bala, Miri ka-ra, ma ena awu neh baye, ga, mü ena ato tö ne fere, fanü fanü?” ");
INSERT INTO muh_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Me gü ba, “Mü ena awu ngü la enatikine, angü nih ena anzö ngüte ake nih ma. Mü nü, mü za ca yiti, de re ka-ye bata. Fü mü aza kpah ca meme, de re ka-ye kpah bata. Fü mü aza kpah moko kambiliki, de re ka-ye kpah bata. Fü mü aza kpah mö ka kötï, bete nda gü. Fü mü akö ewü, akoro di, awa fere.” ");
INSERT INTO muh_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kpurutokokpï la, fü Abarama ayia anü aza wü e la ꞌburu, akoro de ewü, teka amere gele vüngüte ka-wü la di. Fü ah awete ewü, de wü lu ꞌburu. Fü ah awete so wü nü la ꞌburu, aye esüsüka ꞌbasu ꞌbasu, ace ꞌduwa so wü lu. Fü ah adu aza wü so la, ado ewü kpah ꞌbasu ꞌbasu de ze ye, angü gele ka manzö ngüte ka wü kpara la, ah ka-ye ta bala. Fü Abarama adu angbü kötö. ");
INSERT INTO muh_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Fü wü nügünü akpo angbü ekoro, teka adoro wü so la. Fü Abarama angbü eliki ewü asidi, zalü anü akoro etamurago. ");
INSERT INTO muh_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Te ra ngbü etï tete, fü mere ra ayia azoro jia Abarama. Fü sü atï gbü jijia ꞌduwa mbirrri. Fü Abarama angbü eyi ayi, rïrïrïrï, de mere cürü. ");
INSERT INTO muh_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Fü Me akpo angbü emala ngü fü Abarama, gü ba, “Abarama, mü kpe cürü de. Ma ena angbü baka mere vüngüte ka-mü, fï mere badi. Fü ra ao jia ra eküte mü. Ngü te ma emala fü mü ne, ah de zu ngü, te ena amere te-ye fü wü kundu mü sidi nga mü. Angü te gara, wü kundu mü ena ayia sene, anü akoro agbü gara tö nengete, angbü kpala baka wü ganzi kpara. Wü kpara gbü tö la ena afü ewü ba wü labï ka-wü, ato cïnga te ewü, teka mere bi wü re, baka re kama bala (400). ");
INSERT INTO muh_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","16","Fütanga re kama bala la (400), ma ena adu aküwa wü kundu mü la esaka wü kpara, te ewü ena ato cïnga te ewü la, angü ma ena adu ato kuru te nguwa siti wü kpara la, na cïnga te ewü ena ato te wü kundu mü la. Fü wü kundu mü ayia ace tö la de mere tadu. Fü ewü akö mere bi wü e esaka wü vügü ka-wü la. Fü ewü ayia adu akoro gbü tö ka wü Kanana sene. Gbü re engu la, ma ena ato tö ne fü wü kundu mü. Amba ma to tïtïne de, angü ma ngbü ecï nga wü kpara ka Kanana. Angü wüh ngbü emere *siti ngü efa sü. Ma gü ba, ma ena angbü la mba cüküꞌdaye feke, anga wüh ena afü maguma wü ya? Te gara, te ewü fü maguma wü de la, ma ena adu aliki ewü sene asidi. Fü ra aza tö ka-ewü ne, adu ato fü wü kundu mü. De-mü, Abarama, mü ena ara füh kotö ne, ayiri ayiri. Te mü gbe eyi la, fü wü kundu mü aceka kpï fütanga mü me-wü. Fü mü amaka kpah wü züka ngü. Fü mü adu akpi tïne ferrre.” ");
INSERT INTO muh_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Baka te sü tï nza tete ꞌburu ꞌburu, fü Abarama adu azükü. Engu ga, ni ceka kpï bane de, gbo! te sila de wa gbü ye, te ngbü ecï acï ba ke la. Fü wa la angbü endoro esüka wü so nü, de te Abarama wete ewü, do ne. ");
INSERT INTO muh_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Fü Me amala ngü fü Abarama, gü ba, “Ni ena ato tö ne fü wü kundu kundu ye. Fü tö ne angbü ba tö ka-ewü, akpo kü bü era ngu ka wü *Ezepeto, zalü akoro di era mere ngu de ïrï ye Efürata ne. ");
INSERT INTO muh_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Amba enatikine, tö la, ah ka-ye la esaka nguwa wü gara kpara, de ïrï ewü wü Kena, wü Keneza, kpah bete wü Kadamona. ");
INSERT INTO muh_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Nguwa wü Ete, de wü Pereze, bete wü Refe go ngbü eyi kpah ꞌburu sela. ");
INSERT INTO muh_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Wü gara nguwa wü kpara, baka wü Amora, wü Kanana, wü Girigasa, bete wü Yebusa kpah ꞌburu ladü gbü tö la. De-ni, Me, ni ena aliki nguwa wü kpara la, te gara, gbü tö la ꞌburu asidi. Fü ni adu ato tö engu la tïne fü wü kundu ye de nguwa wü. Fü wü angbü sela fï mere badi.” Dela ngü ta te mere te-ye gbü sïkpï te Me za Abarama ba vüngüte ka-ye tete na ne. ");
INSERT INTO muh_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Baka ta te wü Abarama ngbü gbü tö ka wü *Kanana kpala teka wü re nzükpa ne, wara Abarama, de ïrï ye Sarayï ne, bï ye fefe nda de. Te di bala, fü Sarayï ayia afï nga gara labï ka-ye de ïrï ye Agara, te di de egba *Ezepeto ne. Fü Sarayï ayia amala ngü fü watï ye, gü ba dene, “Watï ni deyï, ye ceka la, Me le de ani bï ye ake ye de. Te di eyi bala ne, ye za labï ka-ni, de ïrï ye Agara ne, eza wara ye tete. Fü wü angbü ake di. E-wu neh da? Me ena ato ye fü ani guguvu na.” Fü Abarama ayia ale. ");
INSERT INTO muh_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Fü Sarayï adu aza Agara, ato fü Abarama, de ah ngbü ba wara ka tete. Fü Abarama angbü ake Agara, awu engu würüse tete. Fü Agara ayia amaka bu. Te Agara wu tïne, ga, ni eyi de bu ni ne, fü engu adu angbü efala Sarayï. ");
INSERT INTO muh_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Fü ngü la adu asiti te Sarayï ꞌduwa ba-neh-ene-la. Fü Sarayï adu amala ngü fü Abarama, gü ba, “De bane neh ene ngü ne? Dela ngü ka-ye! Angü Agara ngbü efala ni enatikine ne, teka ngü ka-ye. E-to ta würüse la fü ye neh da? Ah de ni de? Ah du fü te-ye tïne eyi gbuuu! angbü emü ni, teka te engu du maka ye tïne eyi ne. Dela ngbürü zu ngü fanü fanü na? Ah ba ngü de. Me ladü, te ena awu ngü ka-ye la!” ");
INSERT INTO muh_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abarama gü ba dene, “Ah ba ngü de. Angü Agara de labï ka-ye. Ye za kpah bü Agara, de ye mere engu, ba e te ye ngbü ele, teka de ah je ngü ka-ye.” Fü Sarayï adu angbü emere Agara tïne ꞌduwa sisiti. Fü ngü la adu asiti te Agara afa cu sü. Fü Agara adu akpe kpa etü gü, to te kaje te enü agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Baka te Agara kpe nü kpa etü gü, fü anü akoro kpa füh du-kpa-ngu, kpa te kaje ka Sura. Fü *Malayïka ka Me akoro amaka engu kpala. ");
INSERT INTO muh_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Fü malayïka la ayi-tata na, gü ba dene, “Agara deyï, ye koro neh kaye? Ye de labï ka Sarayï de? Ye enü neh kaye?” Agara gü ba, “Ni ngbü ekpe akpe esaka Sarayï.” ");
INSERT INTO muh_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Malayïka gü ba, “Mü mere e afï nga ngü, te Sarayï mere mü di, la de, angü Me wu ngü te mere mü la eyi. Mü yia eyia, de mü du kpa ka Sarayï, fü mü adi eje ngü kaka-na. ");
INSERT INTO muh_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","11","Angü mü ena abï ye, fü mü agü ïïrï na de Ïsïmayile. Fü Me ato wazi fü yi, de wü di enga mü la. Fü ewü abï ye, asibi asibi. Kpara te ena atanga wü ata mü anza, nda ma. Angü Me je gba ka-mü, teka ngü de te ngbü emere mü ne eyi. ");
INSERT INTO muh_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Mbarase ka-mü la ena aga, akoro ba siti nü ka gü de gü te-ye. Mbarase la tï ale ngü ka wü bu ye te gara nda de. Wü bu ye tï ale ngü kaka-na kpah de. Engu ena angbü emere gü bü faaa! de wü kpara ꞌburu. Wü kpara ena angbü ekpü engu ꞌburu akpü. Engu ena ao kötï ka-ye kpikpi ye. Ah ra kötï te gara de wü di enga ni ye nda de.” ");
INSERT INTO muh_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Fü komö Agara ayia agu. Fü ah afï, gü ba dene, “De bane ne ngü ne? Ma ena aküwa aküwa? Ma wu dene eyi cu Me de? Me wu cïnga ra eyi fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Fütanga ngü la, fü ewü adu angbü eï du-kpa-ngu, te Agara kpe edede la, gü ba, Bïrï-Laroyi. Ah baka e te Agara gü ba, “Bïrï te Me wu cïnga ni gbügbü na.” Enatikine du-kpa-ngu la fï ladü ezengba Kadesa ake Berede. ");
INSERT INTO muh_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Fütanga ngü la, fü Agara ayia afere nga ye, adu kpa gba Abarama. Fü engu ayia ayaka enga ye la. Fü Abarama agü ïrï mbarase la, Ïsïmayile, kpah ba e te Me mala fü Agara. ");
INSERT INTO muh_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Dela ngü ta te wüh yaka Ïsïmayile tete na. Wüh yaka engu ta, o re ka Abarama koro eyi ꞌburu teke bala de füh ye maꞌdiya (86). ");
INSERT INTO muh_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Fütanga ngü la, fü re afü ba re nzükpa de füh ye bata, o re ka Abarama koro eyi ꞌburu ba re teke bala nzükpa de füh ye menewa (99). Fü Me adu akoro agü tamu ye fü Abarama, amala ngü fefe, agü ba, “Abarama, mü wu kpo, gü ba, ma de Me, te ma di de mere wazi. Mü lala gbü nga ra, fü mü angbü emere fï bü züka ngü gbü jia ra. ");
INSERT INTO muh_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ma ena angbü emere fü mü kpah fï bü züka ngü, baka ta te ma mala fü mü te enga gina ne, angü mü tïne eyi de *vüngüte ka-ra. Ma ena ato wazi fü mü, de wü kundu mü, fü ewü abï ye, asibi asibi füh kotö ne afa sü.” ");
INSERT INTO muh_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Te Abarama je ngü la, fü ah abuka gbüra ye kötö, agbo nga ïrï Me. ");
INSERT INTO muh_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","5","Fü Me arü amala gara ngü fü Abarama, gü ba dene, “Dene kpeke ngü, de te ma ena amere fü mü, angü ma eyi de vüngüte ka-mü. Ma ena afü ïrï mü de Abarama ne, fü ewü angbü eï mü tïne Abarayama, angü ma ena ato wazi fü mü, fü wü kundu mü asibi te gara, akoro mere bi nguwa wü kpara. ");
INSERT INTO muh_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Wü kundu mü la ena abï ye, fü ewü asibi asibi afa sü. Fü mere bi nguwa wü miri akoro gbü ewü. ");
INSERT INTO muh_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Baka te nih nzö ngüte eyi ake nih ma, wü kundu mü ena angbü kpah de vüngüte ka-ra fütanga kö mü. Fü ngü la angbü bala, fï mere badi. Fü yi alala, angbü emere fï bü ngü ka-ra. Fü ra angbü eceka kpï fütanga yi. ");
INSERT INTO muh_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tö ka wü *Kanana, de te mü ngbü gbügbü na la mba takü ne, ma ena ato te gara ꞌburu fü yi, de wü kundu mü, teka fü ewü angbü gbügbü fï mere badi. Fü ra angbü eceka kpï fütanga yi me-ra.” ");
INSERT INTO muh_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Fü Me adu kpah, amala gara ngü fü Abarayama, gü ba, “De-mü Abarayama, ah le de mü lala fï te ngü ka-ra, de wü kundu mü sidi nga mü ꞌburu, fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Dene eyi gele, te ma to fü yi, teka fü yi adi emere, de wü kundu mü la ꞌburu. Ah le de wü komoko ꞌburu di etï esa *basa. ");
INSERT INTO muh_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Te yi mere bala la, ngü la ena agü tamu ngü fü wü kpara, gü ba, yi de wü vüngüte ka-ra fanü. ");
INSERT INTO muh_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Wü kpara gbü nguwa mü ꞌburu di etï kpa esa *basa, be kpah te wü labï ka-mü ꞌburu. Ngü la, ah kpo enatikine, de ah nü kpa engagira nü. Wü jaji komoko ꞌburu, de te wüh ena ayaka ewü, te ewü ra koro eyi sïkpï ꞌbajena la, wüh di eza ewü, egü gbü basa. ");
INSERT INTO muh_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","14","Mene kpara te le atï esa basa de, ah mere e adu angbü ba mürü mü tïne de. Angü ah ce da eje rïrï ka-ra eyi kpo. Te yi ngbü eyi da etï esa basa la, ngü la ena agü tamu ngü fü wü kpara ꞌburu, gü ba, yi de wü vüngüte ka-ra fanü. Fü ngü la angbü bala fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Fü Me adu amala ngü fü Abarayama, gü ba, “Teka wara mü de Sarayï ne, ma ena afü kpah ïïrï na, de wüh di eï engu tïne Sara. ");
INSERT INTO muh_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","De-ra Me, ma ena ato wazi fefe na, fü ah bï ye komoko fü mü. Fü ra ato mere wazi fefe na afa sü, fü ah angbü ata ye mere bi nguwa wü kpara. Fü wü miri akoro kpah ꞌburu guguvu na.” ");
INSERT INTO muh_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Fü Abarayama angbü fï bü de gbüra ye kötö, da egbo nga ïrï Me. Fü Abarayama angbü efï ngü la. Fü ah angbü emü zo emaguma ye, gü ba, “Ngü la ena amere te-ye, neh baye baye? Ani gbe ka-ani eyi ꞌbasu mini ake Sara ne. Ni ena adu abï ye tïne sidi sidi, o re ka-ni koro tïne eyi kama biri ne (100), fanü fanü? Te re ka Sara koro kpah eyi teke bala de füh ye nzükpa ne (90), engu ena adu abï ye tïne, neh mbi mbi baye baye?” ");
INSERT INTO muh_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Fü Abarayama adu afï nga gara ye ye, te Agara, egba Ezepeto, bï fü ye ne. Fü ah ayi-ta Me, gü ba, “Anga Ïsïmayile? Ye to wazi fefe na nda-ye de?” ");
INSERT INTO muh_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Fü Me amala, gü ba, “Ngü te ma mala fü mü ne, mü je mbi mbi de? Gina wara mü, Sara ne, ena abï ye komoko fü mü. Fü mü agü ïïrï na Yïsaka. Yïsaka ena adi emere ngü ka vüngüte ka-nih de esüka nih de nih ma ne, duu me-ye. Ma ena ato wazi fü wü kundu ye Yïsaka fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Amba teka Ïsïmayile, ma je gba ka-mü, te mü ku tekaka ne kpah eyi. Ma ena ato kpah wazi fefe na. Ïsïmayile ena abï wü jaji komoko, baka e nzükpa de füh ye ꞌbasu. Fü ewü angbü ꞌburu wü miri. Fü wü kundu ye na abï ye, asibi kpah afa sü. Fü nguwa ewü akoro ba mere kpeke nguwa wü kpara füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Te di bala, kpara te ena adi de vüngüte ka-ra, ah de Yïsaka, te Sara ena abï engu ne. Ah de Ïsïmayile nda de. Ma ngbü emala fü mü kpekpeke, gü ba, Sara ena abï Yïsaka engu ne, fütanga re ngbee biringbö.” ");
INSERT INTO muh_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Dela ngü ta te Me mala fü Abarayama, gü ba, “Yïsaka ena adi de vüngüte ka-ni.” Te Me mala ngü la nza tete, fü ah ayia anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","27","Fü Abarayama adu amere wü ngü de te Me mala fü ye la, kpah nde ꞌduwa gbü ra la. Fü ewü ayia anü atï esa *basa, de wü ye ye Ïsïmayile, de wü komoko ka-ye, bete wü labï ka-ye ꞌburu, ewü te wüh bï ewü kpa gba ka, bete ewü te engu se esaka wü ganzi kpara ne. Dela ngü ka Abarayama, ta te tï esa basa, o re kaka-na koro eyi ba re teke bala nzükpa de füh ye menewa (99). Re ka Ïsïmayile ta nda-ye ngbee nzükpa de füh ye bata. Wüh tï ake Abarayama esa basa ꞌburu gbü ra biringbö. Wü komoko ka Abarayama tï kpah ꞌburu gbü biri ra la. ");
INSERT INTO muh_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Gbü gara ra, fü Me adu kpah agü tamu ye fü Abarayama. Dela o Abarayama ngbü ta la fï engbü ede mere rü ka Mamare ne. Etü ra engu la, Abarayama ngbü ta efe te-ye esa mbula gugu ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Engu ga, ni ceka kpï bane de, gbo! te wü komoko bata, te ewü ngbü ekoro kpakaka na. Wü kpara la, ah ka-ye ta de wü Me, bete wü malayïka ka-ye ꞌbasu. Amba Abarayama wu bala nda-ye de. Fü Abarayama ayia kürrrü, akpe anü amaka ewü kpa te kaje, agü mandï fü ewü, ");
INSERT INTO muh_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","gü ba, “Mandï fü ye, mere kpara. Wü mere e anye sü gba ni sene bü bala de! Wü ngbü la mba cüküꞌdaye feke. ");
INSERT INTO muh_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Wü nü, wü ngbü la mba kötö, de wüh koro de enga ngu fü wü, teka fü wü azürü lö wü di. De wü du, wü ngbü, wü efe mba te-wü esa rü sene, ");
INSERT INTO muh_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","teka fü ewü akoro mba de enga e-mazü fü wü, fü wü amaka la mba wazi feke. Fü wü adu anü sü ka-wü, angü wü koro maka labï ka-wü eyi dene.” Fü ewü ayia ale ngü la, gü ba, “Wayi, ah de züka ngü.” ");
INSERT INTO muh_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Fü Abarayama ayia akpe de woro agbü gugu, kpaka Sara, gü ba, “Ye yia eyia kere, de ye za züka zu, de ye mere kümü fü wü mere kpara de bata ne.” ");
INSERT INTO muh_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Fü Abarayama adu kpah, akpe de woro kpa gbü ꞌbaranga ka wü nü ne, aza enga yiti kpala te zege azege de so ye vürü vürü, anü di, ato fü labï ka-ye, de engu mörö kere, ah zï fü wü ngba ka-ni la. ");
INSERT INTO muh_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Te wüh zï wuru la nza tete, fü Abarayama adu aza e-mazü la, kpah bete gara wuru te wüh mere de ngu-ka nü, anü di, areke, ao cu me-ye engagira wü ngba la. Fü Abarayama ayia tïne, adu angbü kpa esa rü ede ewü sela, emere ngü ewü. ");
INSERT INTO muh_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Fü wü ngba la adu ayi-ta Abarayama, gü ba, “Wara ye, Sara, ladü sela?” Fü Abarayama alügü ngü, gü ba, “Sara ladü kpa esa gugu kpane.” ");
INSERT INTO muh_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Fü mere ewü la ayia amala ngü fü Abarayama, gü ba, “Mere züka ngü ladü, te ma le amala fü mü. Sara ena amaka bu, fü ah abï ye komoko. Ma wu eyi, gü ba, te ma ena adu akoro sene, gbü mene re te ena akoro ne, Sara ena adi de mbarase la eküte ye.” Amba Sara, te mü ngbü ka-mü kpa esa gugu de kpala, mü je ngü la eyi. ");
INSERT INTO muh_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","12","Te Sara je ngü la tete, fü ah ayia atï de zo. Kükürü de, angü wü Abarayama ake Sara gbe ka-wü ta nda-wü eyi fa sü. Re ka Sara, ta te ena abï ye, guru sü ka-ye nda kpah eyi. Fü Sara afï nga ngü, agü ba dene, “Ni gbe tïne eyi bane, watï ni, Abarayama, gbe kpah eyi ne. Ni ena amaka ye la neh mbi mbi baye baye?” ");
INSERT INTO muh_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","14","Fü Me amala ngü fü Abarayama, gü ba, “Ah mere baye te Sara ngbü emü zo, gü ba, ‘Ni ena abï ye neh mbi mbi baye?’ ne. Ah fï nda-ye, gü ba, baka te ni gbe tïne eyi, ngü la ena afa Me? Wazi Me fa ka-ye sü! Angü ngü biringbö te ena afa Me nda ma! Ni ngbü emala fü ye fanü fanü, gü ba, gbü mene re te ena akoro ne, Sara ena abï ye komoko.” ");
INSERT INTO muh_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Fü Sara acere nga ye, agü ba, “Ni mü zo nda-ni de.” Fü Me amala fefe, gü ba, “Ye mü zo di bü eyi.” Dela ngü ta te Me mala fü Sara. ");
INSERT INTO muh_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Fütanga ngü la, fü wü ngba de bata la ayia angbü enü to kpa gbü Sodomo. Fü Abarayama ayia agï nga wü ngba la, anü di kpa te kaje la. Fü Me ayia aceka kpï bane, awu Sodomo nengete. ");
INSERT INTO muh_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Fü ah angbü efï nga ngü kpa emaguma ye, gü ba, “Ni ena angbü ewo ngü, te ni le amere ne, eküte Abarayama, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ah le de ni mala nga ngü la fefe na, angü engu de züka kpara ka-ni, te ni kïna kïna fefe na, gü ba, ‘Wü kundu ye na ena asibi afa sü, fü ewü angbü kpah de mere wazi esaka ewü ne. Kpah bala, ni ena aküwa nguwa wü kpara füh kotö ne nde ꞌburu te ngü kaka-na,’ ne. ");
INSERT INTO muh_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Engu kpah de kpara te ni fe engu, o, teka de ah rï wü jaji ka-ye, bete wü kpara ka-ye nde ꞌburu, teka fü ewü angbü eje rïrï ka-ni. Te di tïne eyi bala ne, ni ena amere wü ngü ꞌburu fü Abarayama, kpah baka ngü ta te ni mala fefe na.” ");
INSERT INTO muh_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Fü Me arü amala ngü fü Abarayama, agü ba, “Ni je nga wü lara bi wü *siti ngü ka wü kpara ka Sodomo ake Gomora, te ewü le ngü ka-ni nda-wü ꞌburu ꞌburu de, ne eyi. ");
INSERT INTO muh_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Te di bala, ni ena anü kpala, teka aceka ngü la cu me-ni de jia ni. Te ngü la ngbürü bala fanü fanü la, ni ena acuru sü ka-ewü la, amörö ewü ꞌburu nde asidi.” ");
INSERT INTO muh_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Fü Me ayia atima wü *malayïka ka-ye de ꞌbasu ne, de wüh nü kpa gbü Sodomo. Fü wü Me adu angbü ka-wü ꞌbasu wü ꞌbasu ake Abarayama ciki sela. ");
INSERT INTO muh_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Fü Abarayama ayia amala ngü fü Me, gü ba, “Mere kpara, mba enga yitangü ka-ra ladü, te ma ele ayi-ta mü di. Te züka wü kpara ladü agbü Sodomo kpala, te ewü mere siti ngü nda-wü de la, mü ena amörö ewü, adünda de wü siti kpara la, kpah ꞌburu nde asidi? ");
INSERT INTO muh_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Mere kpara, ma endaꞌba te-ra fü mü, gü ba, te mü maka züka wü kpara kpala, te ewü di baka e teke ꞌbasu de füh ye nzükpa la, mü ena acuru Sodomo kpah acuru? Mü tï ace da ecuru sü la, teka ngü ka züka wü kpara la, de? ");
INSERT INTO muh_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Angü ah tï te mü ena amörö züka wü kpara la, adünda de wü siti ewü de. Ah ena angbü tïne kpah ba e, te ewü di de siti wü kpara la. Wayi Me, mü ngbü erï wü kpara füh kotö ne ꞌburu me-mü, de wüh di emere züka ngü. Te di bala, ma wu eyi, gü ba, mü tï amere siti ngü la bala de.” ");
INSERT INTO muh_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Me gü ba, “Ah mbi. Te ma maka züka wü kpara kpala, ba e teke ꞌbasu de füh ye nzükpa la, ma tï acuru sü la tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Fü Abarayama adu kpah afüwa te-ye, ayi-ta Me, gü ba, “Mere kpara, ma de kükürü e gbü jia mü ba tö. Ma ena angbü embü mü de bala, neh teka ne? Mba gara enga yitangü ka-ra kpah ladü, te ma ele ayi-ta mü di. ");
INSERT INTO muh_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Anga te mü maka züka wü kpara bü ngbee teke ꞌbasu de füh ye ꞌburuve, gara ꞌburuve tïne eyi ma la. Mü ena acuru sü la fï bü acuru, teka wü kpara ngbee ꞌburuve, de te ewü di ma la?” Me gü ba, “Ah mbi. Te ma maka züka wü kpara baka e teke ꞌbasu de füh ye ꞌburuve la, ma curu sü la tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Fü Abarayama adu kpah andaꞌba te-ye, aku gba fü Me, gü ba, “Anga te ye maka ewü bü ngbee teke ꞌbasu la?” Me gü ba, “Te ni maka züka wü kpara bü ngbee teke ꞌbasu la, ni tï acuru sü la de.” ");
INSERT INTO muh_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abarayama gü ba, “Mere kpara, te ni mala kpah mba gara ngü la, ah mere e asiti te ye de. Anga te ye maka bü ngbee teke biri de füh ye nzükpa la?” Me gü ba, “Te ni maka züka wü kpara kpah bü ngbee ba e teke biri de füh ye nzükpa la, ni tï acuru sü la tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Fü Abarayama adu kpah ayi-ta Me, gü ba, “Mere kpara, ni de töndö kpara, ni ena agü fü ye, dene tïne neh fe? Anga te ye maka züka wü kpara bü ngbee baka e teke biri la?” Me gü ba, “Te ni maka züka wü kpara baka e teke biri la, ni tï acuru sü la tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Fü Abarayama adu kpah, ayi-ta ngü, gü ba, “Mere kpara, ye mere e aza ngü ne baka siti ngü de. Du ngü ka-ni ngbee biringbö, te ni ena amala fü ye. Anga te ye maka ewü bü ngbee ba e nzükpa la?” Me gü ba, “Ni ena awu ngü la. Te ni maka züka wü kpara baka e nzükpa la, ni tï te ni ena acuru sü la de. Ni ena ace da ecuru sü la, teka züka wü kpara la. ꞌDuwa te ewü koro te nzükpa nda-wü de la, ni ena acuru sü la acuru.” ");
INSERT INTO muh_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Dela ngü ta te Me mala ake Abarayama, teka ngü ka Sodomo. Te wüh mala ngü la nza tete, fü Me ayia anü sü ka-ye. Fü Abarayama ayia adu kpa ekötï. ");
INSERT INTO muh_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Etamurago la, fü wü *malayïka de ꞌbasu, ta te Me tima ewü ne, anü akoro agbü *Sodomo. Fü ewü amaka Loto, te ngbü ka-ye emöngïtï ꞌbaranga ka mere kötï la. Te Loto wu ewü tete, fü ah awu, gü ba, wüh ka-wü de wü ganzi kpara. ");
INSERT INTO muh_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Fü ah agü mandï fü ewü, amala ngü fü ewü, gü ba, “Wü mere kpara, ah tï eyi fü wü alügü nga wü, adu ara kpa gba ni, teka de wüh to mba ngu, fü wü atökö te-wü? De wü ra agba ni sene, teka fü wü ayia gügü kpurutokokpï, anü sü ka-wü.” Wüh gü ba, “Aꞌa. Ngü ma. Ani ena ara ka-ani bü te ngambasü sene.” ");
INSERT INTO muh_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Fü Loto amala ngü fü ewü kpekpeke, agü ba, “Te ah bala la, ah ena adi esiti. Wü koro, de wü ra kpa gba ni.” Fü ewü adu tïne ale. Fü ewü ayia anü de wü Loto agba ka. Fü wü kpara ka Loto amere kümü fü ewü. Fü ewü ayia azü. ");
INSERT INTO muh_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Fütanga ngü la cüküꞌdaye, o wüh go ra kötö la de, fü wü komoko de gbü Sodomo la aze, afü kere ewü, kerekere gbaa. Wüh koro te nga wü gbü Sodomo sela ꞌburu, wü kaꞌdörö de wü cögbörö kpara. ");
INSERT INTO muh_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Fü ewü akpo da eï ï, gü ba, “Loto! Loto! Wü komoko, de te ewü koro tïne kpaka ye ne, wüh mbi mbi neh kaye? Ye za ewü, de ye koro de ewü kpaka ani kpakine, de ani o ewü ekürüfe ani ba würüse tete.” ");
INSERT INTO muh_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Te Loto je ngü la tete, fü ngü la asiti tete ꞌduwa ba-neh-ene-la. Fü engu ayia kürrrü, aü möngïtï, akoro kpa etanü, adu ani möngïtï de kürüfe ye. ");
INSERT INTO muh_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Fü engu amala ngü fü ewü, gü ba, “Wü di enga ni ni, wü kpara la, wüh de wü ngba ka-ni. Wü mere e amere mene siti ngü de bala eküte ewü de. ");
INSERT INTO muh_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wü di ni, wü jaji würüse, ladü sene ꞌbasu, te watï ewü di ma. Te ni ena ato wü jaji würüse la fü wü, fü wü ao ewü ekürüfe wü la, ah reke de? Wü mere e akpülü wü ngba ka-ni de ꞌbasu ne de, angü dela wü kpara ka-ni, te ewü koro kpaka ni.” ");
INSERT INTO muh_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Fü wü komoko ka Sodomo la, alügü ngü, gü ba, “Ye ngbü emala dela mene ngü de baye? Ye koro sene ba ganzi kpara. Ye ena angbü kpah da eto rïrï fü ani? Ye ka te-ye emöngïtï asidi, angü ani ena amere ye enatikine, afa nda wü kpara la!” Fü ewü akpo enzi Loto emöngïtï asidi, da ededere engu eküte möngïtï, ba e te ewü ena akuru möngïtï la akuru. ");
INSERT INTO muh_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Fü wü malayïka la ayia aü möngïtï, agbeke Loto, adu di kpaka wü, kpa esambü la, adu ani möngïtï. ");
INSERT INTO muh_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Fü wü malayïka la ayia ani jia siti wü kpara ka Sodomo la ꞌburu, ꞌduwa ndunga! Wüh ceka kpï nda-wü tïne de. Fü ewü angbü egïrï möngïtï tïne agïrï. Fü ewü ace ngü la, ayia adu agba wü. ");
INSERT INTO muh_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Fü wü malayïka la ayia ayi-ta Loto, gü ba, “Wü gara wü mürü ye kpah ladü gbü Sodomo sene? Te wüh ladü la, de ye nü enü, de ye biti ewü, de wü jaji ka-ye, de wügiri ye ꞌburu. De ye za ewü, ye kpe de ewü gbü Sodomo sene asidi. ");
INSERT INTO muh_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Angü Me tima ani teka acuru sü ne, teka mere bi siti ngü ka wü kpara de sene, te ewü ngbü emere ne. Ani ena acuru sü ka Sodomo ne acuru enatikine, asiti ꞌburu nde.” ");
INSERT INTO muh_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Te Loto je ngü la tete, fü engu ayia anü amala ngü la fü wü jaji komoko de ꞌbasu, ta te ewü dara wü di ye ne. Fü Loto akoro amala ngü fü ewü, gü ba, “Wü yia eyia kere kere, de wü kpe go ka-wü kpa gbü gara sü, angü Me ena acuru sü ne enatikine.” Amba wügiri ye Loto de ꞌbasu la le aje ngü la nda-wü de. Ngü la du ngbü ka-ye gbü jia ewü, ba e te Loto ngbü egbo kala la. Fü Loto ayia adu ka-ye. Fü kpï ayia aseke. ");
INSERT INTO muh_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Fü wü malayïka la angbü fï bü emala ngü fü Loto kpekpeke, gü ba, “Kere kere! Mü yia eyia! Mü za wü wara mü, de wü di mü ꞌbasu la, fü mü akpe de ewü, angü yi ena akpi de wü siti wü kpara ka Sodomo, te Me ena ato mere kuru te ewü enatikine ne.” ");
INSERT INTO muh_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Fü Loto adu angbü ka-ye nda la kpah fï bü ejiji. Amba gbü wü ngü la ꞌburu, Me le ta fï bü eyi, teka ale ta-ngü te Loto. Fü wü malayïka ka Me de ꞌbasu la ayia ale kpa Loto, ake wara ka, bete wü jaji kaka-na de ꞌbasu ne, aba esa kpïrï wü, afaka gö! Fü ewü ayia akpe de ewü. ");
INSERT INTO muh_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Fü wü malayïka la amala ngü fü ewü, agü ba, “Yi le woro kere kere, angü yi ena akpi! Yi mere e arü gbamari sene de! Yi mere e aceka kpï sidi nga yi kpah de! Yi le fï bü woro, zalü te yi ena akoro tete, kpa füh wü angbe cögbörö da de kpane, teka fü yi aküwa.” ");
INSERT INTO muh_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Fü Loto alügü ngü fü ewü, gü ba dene, “Mere kpara, ");
INSERT INTO muh_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","te wü da de kpala di bü nengete ne, ani ena akoro akoro kpala? Siti ngü ne ena amaka ani etüngba, fü ani akpi de? Wü de züka kpara, te wü küwa ani eyi. Te di bala ne, de wü du kpah, wü le mba ta-ngü te ani. ");
INSERT INTO muh_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wü wu enga ꞌbaranga ꞌdongoni de kpane eyi? Wü tï ale de ani kpe, nü ngbü kpala? Angü ah mba gbamari, ani tï eyi akpe akoro kpala mba kere, fü ani aküwa. Wü tï ace ꞌbaranga la de? Angü ah ka-ye mba ꞌdongoni.” ");
INSERT INTO muh_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wü malayïka la gü ba, “Wayi, ani le eyi. Ani ena ace ꞌbaranga la ace, ani curu de. ");
INSERT INTO muh_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Te di tïne eyi bala ne, ye kpe ekpe kpala kere kere, angü ani tï amere gara ngü la de, zalü te wü ena akpe akoro kpala feke.” Fü wü Loto ayia akpe. Dela si-ngü te wüh gü ïrï ꞌbaranga la tete, Sügara, angü Loto mala ta, gü ba dene, “Dela kpah mba enga ꞌbaranga ꞌdongoni.” ");
INSERT INTO muh_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Fü Loto akpe akoro kpa gbü Sügara. Ah kpe koro kpala kpurutokokpï, o ra te ekoro. ");
INSERT INTO muh_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Fü Me atima wa kpa gbü kpï, te ngbü ekolo etïtï kötö ꞌduwa mbïï mbïï mbïï! Fü wa la angbü etïtï kpa gbü Sodomo ake Gomora, angbü ecuru sü, enü di ꞌduwa hawuu! ");
INSERT INTO muh_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Fü wa la anza wü kpara de wü e, kpah de mene wü e, te wüh ru kpa gbü yï ne, ꞌduwa ꞌbuti ꞌbuti! Fü tanguwa wü kpara, de wü e gbü Sodomo ake Gomora, anza ꞌduwa anza ꞌburu ꞌburu! ");
INSERT INTO muh_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Wü malayïka la mala ta ngü eyi fü wü Loto, gü ba, “Te wü te ekpe la, wü mere e arü, aceka kpï kpa fütanga wü de.” Amba wara Loto, ta te mü ngbü ekpe sidi nga wü watï mü ne, fü mü ayia ka-mü, aceka kpï kpa sidi. Fü würüse la afere te-ye ꞌduwa ciki sela, akoro ba mere teme, bubu ba ngütü avuturu la. ");
INSERT INTO muh_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Fü Abarayama ayia kpurutokokpï la, anü kpa te sü ta te engu yi-ta Me, teka Sodomo tete na ne. ");
INSERT INTO muh_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Fü Abarayama arü aceka kpï to kpa gbü Sodomo. Fü ah ayia awu mere siti nguwa kpala saꞌdi! te gbala sü ꞌduwa yere! baka nguwa ndi la! ");
INSERT INTO muh_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Dela ngü ta te Me curu sü ka Sodomo ake Gomora tete, de mere wa ne. Me küwa ta bü duu Loto, angü ah fï ta nga ngü mürü ka-wü ake Abarayama ne. ");
INSERT INTO muh_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Fütanga ngü la, fü mere cürü akpo angbü emere Loto. Fü engu adu afï, gü ba dene, “Te ni ngbü gbü Sügara sene, ni ena akpi akpi.” Fü engu ayia aza wü di ye, wü jaji würüse de ꞌbasu ne, anü de ewü kpa füh wü da. Fü ewü ayia angbü ka-wü kpa gbü wü gö kpala. ");
INSERT INTO muh_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Gbü gara sïkpï, fü gina ye Loto ayia amala ngü fü enga ni ye, gü ba dene, “Ye ceka la, wö ani te egbe enza dene. Ani ena amere neh baye, te biri komoko di gbü sü ne, te ena aza ani, teka fü ani abï ye, baka wü bu ani ne, ma ne? ");
INSERT INTO muh_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Te di bala ne, ah le de ani kpürü fï, ato fü wö ani, de ah nzö, ah küya di. Te ah küya eyi la, fü ani ara ekükürüfe, teka fü ani amaka ye. Angü tanguwa ani ena anza nza.” ");
INSERT INTO muh_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Etamurago la, fü ewü aza fï, ato fü wö wü. Fü ah anzö fï ꞌduwa ba-neh-ene-la. Fü fï azoro engu. Fü gina yeye na, ayia anü ara ekükürüfe na. Fü ewü angbü ake di. Amba Loto, mü wu ta, gü ba, dene ye ni ne, nda-mü de, ka fï te mü. ");
INSERT INTO muh_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kpurutokokpï la, fü gina ye Loto la adu kpah amala ngü fü enga ni ye, gü ba dene, “Enga ni ni deyï, ani ngbü esikine eyi ake wö ni. Enatikine, ah le de ani to kpah mere fï fü wö ani, teka fü ye anü ara ekükürüfe na me-ye, kpah baka nda-ni de esikine ne. Fü ani abï ye de wü wö ani, angü tanguwa ani ena anza.” ");
INSERT INTO muh_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Fü ewü adu kpah, aza mere fï, ato fü wö wü. Te fï zoro engu tete, fü yeye na, jaji ne, anü kpah, ara ekükürüfe na. Amba Loto, mü wu ngü la nda-mü kpah fï de, ka fï te mü. ");
INSERT INTO muh_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Fü wü jaji würüse la ayia amaka bu ꞌbasu mini. ");
INSERT INTO muh_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Fü lakï ka-ewü ka yayaka ayia akoro. Fü gina jaji würüse la ayia ayaka enga ye, jaji komoko. Fü ewü agü ïïrï na Müwaba. Müwaba de mere gina kundu ye nguwa wü kpara, te wüh ngbü eï ewü Müwaba ne. ");
INSERT INTO muh_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Fü enga ni ye na de sidi ne, ayia abï nda-ye ye, kpah ye komoko, agü ïïrï na Benami. Benami de mere gina kundu ye nguwa wü kpara te wüh ngbü eï Amona ne. Dela ngü ta te Loto bï wü ye di, eküte wü di ye, wü jaji würüse de ꞌbasu ne. ");
INSERT INTO muh_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Fütanga ngü la, fü Abarayama ayia ace sü ka Mamare, adu angbü enü edebu sü, to gbü kokpa, ade gugu ka-ye esüka wü Kadesa ake Sura, angbü sela. Fütanga ngü la, fü ah ayia anü angbü agbü Gerara. ");
INSERT INTO muh_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Fü Abarayama ayia afiti wü kpara gbü Gerara sela, gü ba dene, “Angü Sara ka-ye nda de enga ni ni.” Miri ka Gerara ta ladü de ïrï ye Abi-Meleke. Fü Abi-Meleke ayia aje nga Sara. Fü engu atima wü kpara ka-ye, de wüh nü, wüh za Sara, koro di fü ni. ");
INSERT INTO muh_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","4","O Abi-Meleke ngbü ake Sara la de, fü Me ayia akoro kpakaka na gbü roto, amala ngü fefe, gü ba, “De-mü, Abi-Meleke, mü kpi ka-mü ne eyi akpi dene, teka ngü ka würüse de te mü za ne. Ah de *siti ngü, angü würüse la, ah de kükürü würüse nda de. Ah ka-ye da wara Abarayama. Te di bala, ngü la siti gbü jia ra eyi fa sü! Ma kïna yi eyi, de wü kpara ka-mü ꞌburu, gü ba, yi tï abï ye tïne de!” Abi-Meleke gü ba, “Mere kpara, ye ena amörö tanguwa ani, anza, neh teka ne? Ni ngbü ake würüse la nda-ni la de! ");
INSERT INTO muh_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Amba Abarayama fiti ni me-ye, gü ba, ‘Sara ka-ye nda de enga ni ni.’ Fü Sara amala kpah bala, ga, ‘Abarayama ka-ye de enga ni ni.’ Te di bala, ni ena awu ngü la ta, mbi mbi neh baye baye, gü ba, engu de wara Abarayama? Ni ka-ni de züka kpara, angü wü Abarayama fiti ni me-wü. Amba ni mere siti ngü ake di nda-ni la kpah de.” ");
INSERT INTO muh_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Me gü ba dene, “Mü mala zu ngü. Ma wu kpo, ga, mü wu ta, gü ba, würüse la de wara Abarayama, ne de. Kpah bala, mü ngbü ake würüse la de, angü ma tïrï kaje fü mü me-ra. ");
INSERT INTO muh_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Te di bala ne, ah le de mü za würüse la, mü lügü engu fü Abarayama. De mü yi-ta Abarayama, de ah ku gba fere teka mü. Angü ah ka-ye de *mürü dofo ka-ra. Te mü lügü wara ka eyi fefe na la, ah ena angbü de tadu. Fü ah aku gba fere, teka fü ra aküwa mü. Amba, te mü lügü Sara enatikine fü watï ye na de la, mü ena akpi, de wü kpara ka-mü nde ꞌburu.” Dela ta ngü te Me mala fü Abi-Meleke gbü roto. ");
INSERT INTO muh_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kpurutokokpï la, fü Abi-Meleke ayia abiti wü cögbörö kpara ka-ye, amala nga roto la fü ewü. Fü mere cürü ayia arï te ewü. ");
INSERT INTO muh_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Fü Abi-Meleke ayia atima ngü gbü nga Abarayama. Te Abarayama koro tete, fü Abi-Meleke ayia amala ngü fefe, gü ba, “Abarayama deyï, ye fiti ni, gü ba, würüse ne de enga ni ni, neh baye baye? Ye mere de ni de bala, neh ene ngü ne? Ye za mere kuru ne, koro di fü ani bane, neh teka ne? Ni mere ta fü ye mbi mbi ne ngü ne? Kpara emere ngü bala ꞌba amere na? ");
INSERT INTO muh_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ye mere mene ngü la bala, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abarayama gü ba, “Ni cere nga wara ni bala kükürü de, angü ni ngbü efï, gü ba, wü kpara de gbü sü ne, wüh fï nga ngü ka Me nda-wü de. Ni fï, ga, wüh ena amörö ni, teka aza wara ni ne. ");
INSERT INTO muh_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ah nda ngbürü fanü, Sara ka-ye nda de enga ni ni, te wö ani bï engu guvu gara würüse. Fü ni adu aza engu wara ni tete. ");
INSERT INTO muh_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Angü, ta gügü, Me mala ngü fü ni, de ni ce gba wö ni, de ni nü, ni ngbü agbü ganzi tö. Teka ngü la fü ni angbü ejiji tikpi tikpi, ba e dene. Te di bala, fü ni amala fü wara ni, gü ba, ‘Gbü wü sü ꞌburu, te ani ena akoro tete, ye mere e amala, gü ba, “Ni de watï ni,” ne de. Ye cere nga ni acere, gü ba, “Ni ka-ni nda-ni de enga ni ni.” Angü dela mba ngü, te ena ale ta-ngü te ni, fü ni küwa.’ ” ");
INSERT INTO muh_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Fü Abi-Meleke aza wü kambiliki, wü yiti, bete wü labï, ayia ato fü Abarayama. Fü ah ayia kpah aza Sara, alügü fefe na. ");
INSERT INTO muh_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Fü Abi-Meleke amala ngü fü Abarayama, gü ba, “Nzö sü de te ye ngbü eceka dene ꞌburu, ah esaka ni. Te ye maka mene sü, te ereke gbü jia ye la, de ye o gba ye gbügbü na.” ");
INSERT INTO muh_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Fü Abi-Meleke adu amala ngü fü Sara, agü ba, “Ye ceka la mere bi wü e, de te ni to fü enga ni ye la, ah ena akoro akoro ꞌburu ba jiase kutu biri (1000). Ni to wü e la ꞌburu, teka fü wü kpara awu, gü ba, dürü ngü, ta te ni dürü eküte ye ne, ah nza eyi. Angü ah ta de dürü ngü ka-ye nda de. Ah ta de dürü ngü ka-ni.” ");
INSERT INTO muh_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Fü Abarayama adu aku gba fü Me teka wü Abi-Meleke, de Me küwa ewü. Angü Me kïna ta wü Abi-Meleke, de wü wara ye eyi ꞌburu, gü ba, wüh tï abï ye tïne de. Amba, baka te Abi-Meleke lügü Sara tete na, fü Abarayama ayia aku gba fü Me, fü ewü adu abï ye. ");
INSERT INTO muh_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Fü Me ayia ato wazi fü Sara, kpah baka e, ta te engu mala fü Abarayama te enga gina ne. ");
INSERT INTO muh_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","5","Fü Sara ayia amaka bu. Fü lakï kaka-na teka ayaka, ayia akoro, kpah baka ngü ta te Me mala fü ewü ne. Sara bï ye la fü Abarayama tïne gbü gbe ye, o re ka Abarayama koro eyi ꞌburu kama biri (100). Fü mbarase la ara akoro sïkpï ꞌbajena. Fü Abarayama ayia aza engu, agü esa *basa, angü dela gele ka-ewü, baka e ta te Me mala fü ewü ne. Fü Abarayama ayia agü ïrï mbarase la, Yïsaka. ");
INSERT INTO muh_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","7","Fü Sara adu angbü de mere tadu, teka ye, de te engu bï ne. Fü engu angbü emü zo, gü ba, “Me de mere e! E-wu ta, gü ba, ma ena abï ye bane, neh da? De te ma gbe tïne eyi ne! Ceka la eceka! Ngü te Me mala ne koro eyi ngbürü bala! A bï ye eyi ake Abarayama tïne gbü gbe a dene!” Fü Sara ayia abï ci, gü ba, “Me to mere tadu eyi fere! Ma bï ye komoko eyi fanü fanü dene! Te yi ena aje ngü ne, yi koro ꞌburu, de nih mü zo ka tadu de nih ma!” ");
INSERT INTO muh_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Fü Yïsaka ayia aga. Fü ni ye na ayia atïrï ka tete. Gbü sïkpï te Yïsaka ce ka tete na la, fü wö ye na ayia amere mere karama, teka ngü la. Angü dela ta gele ka-ewü. ");
INSERT INTO muh_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Fü Sara aceka kpï bane, awu Ïsïmayile, enga Agara, te du ngbü efala Yïsaka afala. ");
INSERT INTO muh_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Fü Sara asü ꞌduwa asü kpaaa! de gü eküte Ïsïmayile. Fü ah amala ngü fü Abarayama, gü ba, “Ape! Ni mbü tïne eyi, esaka labï ne ake enga ye! Ye liki ewü eliki. Kükürü de, angü Yïsaka ena aza e-nga-kpa ye, te gara me-ye, fütanga kö ye. Ïsïmayile tï aza e-nga-kpa ye nda ꞌburu ꞌburu de! Ye liki engu eliki!” ");
INSERT INTO muh_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Fü ngü la asiti te Abarayama ꞌduwa ba-neh-ene-la, angü Ïsïmayile kpah de yeye na. ");
INSERT INTO muh_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","13","Fü Me akoro amala ngü fü Abarayama, gü ba, “Abarayama deyï, ye mere e afï nga ngü, teka Agara ake Ïsïmayile de, angü ni ena aceka kpï fütanga ewü me-ni. Ye mere kpah baka e te Sara ngbü ele la. Ïsïmayile ena ago angbü nengete, kpa gbü gara sü. Fü ni ato wazi fefe na, teka ngü ka-ye. Fü ah abï wü ye, asibi asibi. Fü ni afü wü di Ïsïmayile ba mere nguwa wü kpara, gbü nzö wü kpikpi wü. Amba mene wü kundu kundu ye, te ni mala nga ewü fü ye ne, wüh ena abï ewü gbü nguwa *Yïsaka. Angü ni fe ka-ni Yïsaka.” ");
INSERT INTO muh_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Fü Abarayama ayia gügü kpurutokokpï, aza wü e-mazü, bete mere kölökö, de ngu gbü ye, ayia ato fü Agara. Fü engu ayia ato kaje fü wü Agara ake Ïsïmayile, gü ba, “Wü yia eyia, wü go, wü ngbü kpa te gara sü nengete.” Fü wü Agara ayia ago ka-wü kpa gbü gü, to anga Bïrï-Saba. Fü ewü angbü ejiji gbü sü la. ");
INSERT INTO muh_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Fü ngu de te Abarayama to fü ewü gbü kölökö ne ayia anza. Fü gümü ngu ayia akpo angbü emere ewü. Mbarase yia ekpi akpi ka gümü ngu. Fü ngü la ayia ake te ni ye na. Fü ah ayia ace Ïsïmayile esa rü sela. ");
INSERT INTO muh_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Fü ah ayia anü angbü ka-ye mba canza kpa engagira nü. Fü ah akpo angbü endaꞌba te-ye, gü ba, “Ööö, enga ni te ekpi! Ni ena amere dene baye? Ni le aceka jia enga ni, te ena akpi ka gümü ngu, ne de.” Fü engu atï ꞌduwa eku mere gba. ");
INSERT INTO muh_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Fü Me ayia aje gba, te Ïsïmayile ngbü eku kpa esa rü la. Fü ah ayia atima *malayïka ka-ye kpaka Agara, de ah mala ngü fefe na, gü ba, “Agara deyï, ah de ne ngü ne? Ye mere e akpe cürü de, angü Me je gba ka enga ye, de te ngbü eku kpa esa rü de kpala, ne eyi. ");
INSERT INTO muh_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Enga ye tï akpi nda de. Me ena ato wazi fefe na, fü ah abï mere bi nguwa wü kpara. Te di bala, ye mere e akpe cürü de. Ye yia eyia, de ye du, ye e engu tikpi, angü ah ena küwa.” ");
INSERT INTO muh_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Fü Me ayia agü tamu gara du-kpa-ngu, te di kpala fü Agara. Fü Agara ayia aceka kpï bane, awu du-kpa-ngu la. Fü ah ayia aza mere kölökö la, anü ase ngu la gbügbü cere! Fü ah adu di, ato fü Ïsïmayile. Fü Ïsïmayile ayia anzö ngu la, fü ah ayia tïne aküwa. ");
INSERT INTO muh_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Fü Me angbü fï ele ta-ngü te Ïsïmayile. Fü Ïsïmayile ayia aga, akoro mere komoko. Engu ta de kpara te ngbü emörö wü nü de dïrï ꞌduwa ba-neh-ene-la. Fü ni ye na ayia ase würüse fefe na, kpah egba Ezepeto. Angü Agara ta kpah de egba Ezepeto. Fü ewü ao kötï ka-wü kpa etü gü, agbü Parana. ");
INSERT INTO muh_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Abi-Meleke ta de miri ka wü Feleseto. Gbü gara sïkpï, fü Abi-Meleke aza gara mere kpara ka wü marajümïya ka-ye, de ïrï ye Fïkola. Fü ewü ayia ake di, anü amaka Abarayama kpa gbü Bïrï-Saba. Fü Abi-Meleke amala ngü fü Abarayama, gü ba, “Mere kpara, ma wu kpo, ga, Me ladü ake mü. Ah ngbü eto wazi fü mü, gbü wü ngü ꞌburu, de te mü ngbü emere ne. ");
INSERT INTO muh_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Te di bala, ma ngbü ele de mü kïna kïna te ïrï Me, ga, mü tï te gara, adu afiti ra tïne de. Mü tï afiti wü di ra, de wü kundu ra tïne kpah ꞌburu nde de. Ah le de mü kïna kïna te ïrï Me bala. Angü ma mere züka ngü eyi fü mü. Te di bala, de mü mere kpah züka ngü fere, de wü kpara ka-ra, gbü sü ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abarayama gü ba, “Wayi, ni le ngü la eyi.” ");
INSERT INTO muh_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Fü Abarayama ayia amala gara ngü fü Abi-Meleke, gü ba, “Gara enga ngü kpah ladü, te ngbü eke te ni, angü wü kpara ka-ye za du-kpa-ngu ka-ni, de te wü kpara ka-ni jï ne eyi.” ");
INSERT INTO muh_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Miri Abi-Meleke gü ba, “Amba ni wu mene kpara, de te mere ngü la, nda-ni de. Ni je ngü la kpah bü eyi gömö ye dela. Angü ye ce ta da emala ngü la fü ni gügü, teka ne? Te ah bala, ani ena areke ngü la enatikine.” ");
INSERT INTO muh_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Fü Abarayama ayia aza wü kambiliki, bete wü yiti, ato fü Abi-Meleke. Fü ewü ayia anzö ngüte ake di. ");
INSERT INTO muh_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Fü Abarayama adu kpah aza gara wü kambiliki ba e lorozi, areke ewü, ao kpikpi wü. ");
INSERT INTO muh_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Te Abi-Meleke wu ngü la bala, fü ah amala ngü fü Abarayama, gü ba, “Ngü teka wü kambiliki de lorozi de kpane, neh mbi mbi baye?” ");
INSERT INTO muh_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abarayama gü ba, “Ma to wü kambiliki la eyi fü mü. Mü za ewü eza, teka fü wü kpara awu, gü ba, ma jï ta du-kpa-ngu la me-ra.” Fü Abi-Meleke ayia ale ngü la. ");
INSERT INTO muh_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","32","Fü wü Abi-Meleke ayia alügü nga wü, adu de wü mere kpara ka wü marajümïya ka-ye, agba wü. Dela si-ngü, de te wüh gü ïrï sü la tete, gü ba, Bïrï-Saba. Angü dela sü ta te wü Abarayama nzö ngüte tete ake Abi-Meleke. ");
INSERT INTO muh_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Fütanga wü ngü la, fü Abarayama ayia aza gara züka rü, aru gbü Bïrï-Saba sela. Fü engu ayia agbo nga ïrï Mere Me, te ngbü engbü fï mere badi ne. ");
INSERT INTO muh_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Fü Abarayama ara kötï gbü sü ka wü Feleseto sela teka mere bi wü re. ");
INSERT INTO muh_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Fütanga ngü la, te Yïsaka ga koro tete mba memere, fü Me ayia are maguma Abarayama. Fü Me akoro aï Abarayama, gü ba, “Abarayama! Abarayama!” Fü Abarayama ayia ale ngü, gü ba, “Waye!” ");
INSERT INTO muh_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Fü Me amala ngü fefe, gü ba, “Mü za ye mü de Yïsaka, te mü le engu fa sü ne, fü mü anü di agbü tö ka wü Morïya, teka fü mü awa engu amörö, acuru fere baka laꞌbï. Sü de te ma le de mü mere ngü la tete, ma ena agü tatamu na fü mü. Sü engu la ena adi kpa füh mere da de kpala.” Fü Abarayama ayia ale ngü la. Fü kpï ayia aseke. ");
INSERT INTO muh_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kpurutokokpï la, fü Abarayama ayia anü da egïrï cï-wa, teka acuru Yïsaka fefe na fü Me, de mere fïngangü emaguma ye. Fü ah ayia aza cï-wa la, ai ao füh dongï ka-ye. Fü Abarayama ayia ake Yïsaka, bete wü labï ka-ye ꞌbasu, abe kpah te dongï la, anü agbü sü, de te Me mala nganga na fefe na ne. ");
INSERT INTO muh_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Fü ewü anü, anü, anü, ara te kaje ꞌbasu. Fü Abarayama ayia aceka kpï, awu sü de te Me mala nganga na ne, nengete kpa engagira ye kpala. ");
INSERT INTO muh_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Fü Abarayama ayia amala ngü fü wü labï ka-ye de ꞌbasu ne, gü ba, “Wü ngbü nda-wü sene, de wü dongï ka-ni ne. Ani enü me-ani ake ye ni, kpa füh da de kpala, teka aku gba fü Me. Fü ani adu akoro.” ");
INSERT INTO muh_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Fü Abarayama ayia aza cï-wa, de te engu ena acuru kö Yïsaka fefeh na ne, ao gbü nzö Yïsaka, de ah bï. Fü Abarayama aza nda-ye nye-wa bete mere maguruma. Fü ewü ayia anü sü ake ye ye. ");
INSERT INTO muh_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Te wüh ngbü enü tete, fü Yïsaka ayia ayi-ta wö ye, gü ba, “Wüba,” Fü Abarayama ale ngü, agü ba, “Waye, ye ra, ah mere baye?” Yïsaka gü ba, “Wüba, ma bï cï-wa eyi dene. Nye-wa kpah eyi ladü ne. Anga kambiliki de te nih ena awa, amörö fü Me ne, di nda neh kaye?” ");
INSERT INTO muh_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Fü Abarayama alügü ngü fü ye ye, gü ba, “Enga ra, Me ladü. Ah ena ato kambiliki fü nih me-ye.” Fü ewü angbü fï bü enü ka-wü. ");
INSERT INTO muh_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Te wüh nü koro tete kpa gbü sü, de te Me mala nganga fü Abarayama ne, fü Abarayama ayia abiti teme, afa e ba *cangalï la. Fü ah ayia andrü cï-wa la ezeze na. Fü ah adu azoro Yïsaka, ai gö gö gö! Fü ah abï engu, ao kpa füh cï-wa la. ");
INSERT INTO muh_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Fü ah ayia ato kpa ye, aza mere maguruma ka-ye, de ni wa Yïsaka, amörö di. ");
INSERT INTO muh_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Te Abarayama yia za maguruma tete, de ni wa Yïsaka, fü Me ayia aï engu kpa gbü kpï, gü ba, “Abarayama! Abarayama!” Fü Abarayama ayia ale ngü. ");
INSERT INTO muh_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Fü Me amala ngü fefe, agü ba, “Mü mere e amörö ye mü de. Ma wu eyi kpo, gü ba, mü le eyi ato ye mü, te di de kporo maguma mü ne, fere. Ma wu kpah eyi kpo, gü ba, mü le ngü ka-ra eyi fanü fanü de maguma mü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Fü Abarayama ayia, de ni ceka kpï bane de, gbo! te mere moko kambiliki, te didi ngïlï angïlï. Didi lala eyi gbü wü rü. Fü Abarayama ayia anü agbi di kambiliki la, gbü rü la asidi. Fü ah adu aza kambiliki la, anü amörö, acuru fü Me da ye ye la. ");
INSERT INTO muh_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Dela si-ngü de te Abarayama gü ïrï sü la tete, gü ba, Yakova Yire. Ah ba e te wüh gü ba, “Me ena ato e fere me-ye.” Akoro enatikine, wü kpara ngbü emala, gü ba, “Mere Me ena ato e fü ani gbü sü la kpah bala.” ");
INSERT INTO muh_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Te Abarayama curu kambiliki la nza tete, fü Me adu kpah aï engu, ");
INSERT INTO muh_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","gü ba, “Abarayama, mü je la ngü ka-ra, te ma emala fü mü ne. Ma wu eyi kpo, gü ba, mü ngbü eje ngü ka-ra aje. Angü mü le tïne eyi ato ye mü fere, te di fü mü ba kporo maguma mü ne. Te di eyi bala ne, de-ra Me, ma kïna kïna eyi te ïrï ra, ");
INSERT INTO muh_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","gü ba, ma ena ato wazi fü mü afa sü, teka de wü kundu mü sibi asibi fa sü, akoro ba wü küfara, anga zu-tö. Fü ewü adi ba kpeke wü kpara, adi eza sü esaka wü vügü ka-wü. ");
INSERT INTO muh_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ma ena aküwa nguwa wü kpara füh kotö ne ꞌburu, teka ngü ka wü kundu mü la. Dela ngü te ma ena amere fü yi, angü mü le ngü ka-ra eyi.” ");
INSERT INTO muh_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Te Me mala ngü la nza tete, fü wü Abarayama ayia ake Yïsaka, adu kpa esangü da, kpaka wü labï ka-wü, te ewü ngbü ecï nga ewü la. Fü ewü ayia alügü nga wü, adu agbü Bïrï-Saba, angbü kpala. ");
INSERT INTO muh_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Fütanga ngü la, fü Abarayama aje ngü, gü ba, “Gara enga ni ni de ïrï ye Nayora ne, gina wara ka de ïrï ye Mïleka ne, bï wü jaji eyi fefe.” ");
INSERT INTO muh_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ïrï wü jaji, de te Mïleka bï ewü ne, ïrï gina de Uca, ïrï wü gara de wü Buza, Kemule, ");
INSERT INTO muh_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesede, Azo, Piledasa, bete Yidirafa, ");
INSERT INTO muh_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","be kpah te Betuwele. Betuwele engu la ta de wö ye Rebeka. Dela ïrï wü jaji, de te Mïleka bï fü Nayora, enga ni ye Abarayama. Wü jaji la ta ꞌburu ꞌbajena. ");
INSERT INTO muh_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Fü Nayora abï kpah gara wü jaji bala, ake gara wara ye, de ïrï ye Ruma ne. Ïrï wü jaji la ta de Teba, Gama, Tasa, bete Maka. Dela ꞌburu ïrï wü jaji ka Nayora, enga ni ye Abarayama. ");
INSERT INTO muh_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Fü Sara ayia agbe, o re kaka koro tïne eyi ꞌburu kama biri teke biri de füh ye lorozi (127). Fü engu ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ah kpi kpa gbü Eberone, gbü tö ka wü *Kanana. Fü Abarayama aku gba kö wara ye sela ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Fü Abarayama ayia afï nga ngü teka sü te ni ena ati wara ni gbügbü, angü ta gbü wü re la, wüh ngbü ta eti kpara duu gbü gö da. Fü Abarayama ayia gbü gba sela, anü kpaka wü di enga Ete, amala ngü fü ewü, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Wü ceka eceka, tïtïne wara ni kpi eyi. Ni gbü sü ka-wü sene ba ganzi kpara, te ni ngbü engbü sene mba takü. Te di bala ne, ni ena anü ati wara ni, neh to kaye? Wü tï eyi ato mba enga sü fü ni, fü ni ati engu gbügbü na?” ");
INSERT INTO muh_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Fü wü di enga Ete la alügü ngü fefe na, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mere kpara, ye gbü jia ani ba mere kpara ka Me. Te di bala ne, ye ceka kpah bü mene sü de te ena atï te nga jia ye, fü ye ati wara ye gbügbü na. Kpara te ena atïrï sü te ye nda ma.” ");
INSERT INTO muh_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Fü Abarayama ayia akö ca-e engagira wü di enga Ete la asidi, adu amala ngü fü ewü, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Te wü le ngbürü eyi de ni ti wara ni sene la, wü yi-ta Efürona, ye Cowara, ");
INSERT INTO muh_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","de engu to sü ka-ye kpa füh mere da, te wüh ngbü eï, ga Makepela, de gö ye ne, fere. Mere da engu la, ah ladü to kpa enzö yï kaka-na la. De wü yi-ta Efürona, de engu mala ngü la cu de komö ye, gbü jia wü ꞌburu. Fü ni adu tïne, ato jiase fefe na, kpah baka e te engu ngbü ele. Fü ni anü ati wara ni kpala.” ");
INSERT INTO muh_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Baka te Abarayama ngbü emala ngü la tete, amba Efürona ta kpah ladü esüka wü bu ye, wü di enga Ete, gbü sü ka mabiti ka-wü, emö ꞌbaranga sela. Fü Efürona ayia amala ngü fü Abarayama, gbü jia wü bu ye la kpah ꞌburu, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Wayi, mere kpara, ah nda ngbürü bala, ni ena ato da ka-ni la, de wü gö ye la, nde ꞌburu fü ye kükürü. Ni to eyi fü ye, de ye ti wara ye gbügbü na, kpah gbü jia wü mürü ni dene ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Fü Abarayama adu kpah, akö ca-e engagira wü di enga Ete la. ");
INSERT INTO muh_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Fü Abarayama adu alügü ngü fü Efürona kpah ꞌduwa gbü jia wü kpara la, gü ba, “Ah bala de. Ni ena ato jiase, ase sü la di, fü ah angbü tïne sü ka-ani tete. Ye za jiase ne eza.” ");
INSERT INTO muh_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Fü Efürona alügü ngü fefe, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Te ah bala la, ah mbi. Ah le de ani reke ngü la, teka de ani o fïngangü ka-ani ꞌburu biringbö. Te ye le eyi ato jiase fü ni la, ah le de ye to mbürükü se kama bala (400). Ngü ka jiase la, ah de mere ngü nda kpah de. Ye eza nda-ye bü sü la, de ye ti wara ye gbügbü na.” ");
INSERT INTO muh_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Fü Abarayama ayia ale ngü ka Efürona la. Abarayama ngbü etanga jiase la, ba e ta te wüh ngbü etanga jiase, gbü mene wü re engu ta de kpala. Fü engu ato ngbürükü se kama bala (400) fü Efürona, kpah ꞌduwa ce baka e, ta te Efürona mala nganga gbü jia wü kpara ne. ");
INSERT INTO muh_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","20","Fü Abarayama ayia ati wara ye, gbü tö ka wü Kanana sela, gbü sü te wüh ngbü eï, ga, Makepela ne. Ah ti engu gbü gö da, angü gele ta gbü mene wü re la ka-ye bala. Dela ngü ka sü ta te Abarayama se esaka wü di enga Ete, te wüh ngbü eï, ga, Makepela, te di ede Mamare to kpa fügö ne. Abarayama se ta sü la de wü gö da, de wü rü de gbü sü la ꞌburu. Ah se ta sü la esaka Efürona, de mere bi jiase, gbü jia wü di enga Ete, de wü angbe cögbörö kpara ka-wü nde ꞌburu. Fü sü la adu angbü tïne fï badi, sü ka Abarayama, te engu ngbü eti wü mürü ye gbügbü na. ");
INSERT INTO muh_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Me ngbü ta eto wazi fü Abarayama, fü ah angbü emere wü ngü di, gbü wü re kaka ꞌburu, te engu mere füh kotö ne. Fütanga ngü la, fü Abarayama adu tïne agbe afa sü. Fü Abarayama akpo angbü efï ngü teka ye ye, Yïsaka, te ga koro eyi mere komoko ne. Ah le ta eyi de Yïsaka za würüse. Amba Abarayama le de Yïsaka za egba ganzi kpara nda de, angü gele ka wü kpara, ta gbü wü re la, ka-ye nda da eza te-wü esüka wü de wü mürü wü. Wüh za ta te-wü de wü ganzi kpara kpo de. Fü Abarayama angbü efï nga ngü, ga, ni ena amere dene, neh baye, teka fü ani amaka züka würüse fü ye ni, te ni ce tö ka-ani ta eyi gügü, go ra kötï eyi nengete kpa gbü tö ka wü *Kanana de kpakine ne. ");
INSERT INTO muh_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Fü Abarayama ayia aï mere kpara ka tima ka-ye, te ngbü gbü nzö wü bu ye ꞌburu. Engu ta de diri kpara ka tima ka Abarayama, teka mere bi wü re fa sü, angü ah ngbü tïne eceka kpï fütanga mere bi wü e ka Abarayama ꞌburu me-ye. Fü Abarayama ayia amala ngü fü mürü tima ka-ye la, gü ba, “Ma le amala ngü fü mü, teka würüse te ma le ase fü Yïsaka. Ma le de Yïsaka za egba ganzi kpara de. Te di bala, ma ele de mü yia, mü nü kpa gbü sü ka-a, te wü di enga wüna ngbü tete. Fü mü aceka würüse kpala, te di gbü nguwa a. Fü mü ase, adu akoro de engu fü Yïsaka. Amba ah le de mü kïna kïna de ïrï Mere Me, te ngbü gbü nzö wü kpara ꞌburu ne. Mü kïna te mü, gü ba, ‘Ni ena amere wü ngü, de te ma mala fü ni ne.’ Kpah bala, mü kïna lö ra, gü ba, ‘Ni tï aza würüse fefe gbü nguwa ganzi kpara de.’ ” ");
INSERT INTO muh_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Fü mürü tima la alügü ngü fefe, gü ba, “Anga te würüse engu le ago agbü Kanana kpakine de, teka sü te mo amo la? Te ah bala la, ni ena amere baye? Ni ena adu aza Yïsaka, ago di kpala, teka fü ah aza würüse engu la?” ");
INSERT INTO muh_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Fü Abarayama agü ba, “Aꞌa, ah bala fï de! Mü mere e aza ye ra, adu di kpala fï de. ");
INSERT INTO muh_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Angü Mere Me mala ta me-ye, gü ba, ‘Ma yia, de ma ce gba a, gbü sü te wüh bï ra tete, de ma go kpakine.’ Fü Me akïna kïna, gü ba, ‘Ni ena ato tö ka wü Kanana ne fü wü kundu ra.’ Te di bala, te ye ra ena ace sü ne, adu angbü nengete kpala la, ah esiti. Mü ena amaka züka würüse fefe na, angü Me ena atima *malayïka ka-ye, fü ah atï fü mü engagira nü. Fü ah ale ta-ngü te mü. Fü mü amaka züka würüse, ase, adu di fü Yïsaka. ");
INSERT INTO muh_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Amba, te würüse engu le teka adu ake mü agbü Kanana akine nda de la, de mü ce engu, fü mü adu ka-mü kpakine. Ngü tï amere mü gbü kïna, de te mü kïna te-mü di la de. Te ngü engu kpala kpah baye la, mü mere e aza Yïsaka, adu de engu kpala kpo fï de.” ");
INSERT INTO muh_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Fü mere mürü tima la ayia akïna lö Abarayama, gü ba, “Ni ena amere wü ngü, de te ye mala fü ni ne, kpah ꞌburu bala.” ");
INSERT INTO muh_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Fütanga ngü la, fü mere mürü tima la adu areke te-ye, aza wü kamele ka Abarayama nzükpa. Fü ah aza kpah gara bi wü e esaka Abarayama, ayia ao füh wü nü la, teka anü ase würüse la di. Fü ewü ayia anü, anü, akoro nengete, agbü tö ka Padanarama, gbü gara ꞌbaranga de ïrï ye Arana, ta te enga ni ye Abarayama, de ïrï ye Nayora, ra ta kötï gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Te mere mürü tima ka Abarayama nü koro tete gbü ꞌbaranga la, nga tamurago, gbü lö-ra te wü würüse ngbü ekoro ese ngu tete, fü ah anü de wü kamele ka-ye la, kpa ede du-kpa-ngu la. Fü ah amala ngü fü wü kamele la, de wü ra kötö. ");
INSERT INTO muh_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Fü mürü tima ka Abarayama la ayia aku gba fü Me, gü ba, “Wayi, Me, te mü di de *vüngüte ka Abarayama, mü ü kaje fere enatikine, de ngü de te ma koro tüngüngü na ne mere te-ye fere, baka e te mere kpara ka-ra ngbü ele ne. Mü mere ngü fü mere kpara ka-ra ba mürü, angü mü de vüngüte kaka-na. ");
INSERT INTO muh_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","14","Mü gara tamu würüse, de te mü fe engu, o eyi ba wara Yïsaka tete ne. Angü ma rü eyi de füh du-kpa-ngu ne. Wü würüse, de te ewü ngbü ekoro ese ngu gbü du-kpa-ngu ne, mene würüse te ma ena ayo ngu tete na, te ah to ngu eyi fere, bete mere bi wü kamele ka-ra ne la, amba dela eyi würüse, te mü fe engu, o eyi wara Yïsaka tete na. Te mü mere ngü la fere bala la, amba mü zu de vüngüte ka mere kpara ka-ra.” ");
INSERT INTO muh_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Te mürü tima la ngbü la bü emala ngü la bala de, ah gü ba, ni ceka kpï bane de, gbangbara! te gara jaji würüse, te ngbü ekoro de bütü-ngu gbü nzö ye, ase ngu. Ïrï jaji würüse engu la de Rebeka. Ah de ye Betuwele, enga ni ye Abarayama. ");
INSERT INTO muh_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeka ta de züka jaji würüse, te reke gbü jia wü kpara fa sü. Ah za komoko ta nda la de. Fü Rebeka ayia akoro ase ngu gbü bütü-ngu ka-ye, ayia angbü edu. ");
INSERT INTO muh_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Te mürü tima la wu Rebeka te ngbü edu bala, fü engu ayia akpe de woro, akoro kpakaka na, amala ngü fefe na, gü ba, “Ye to la mba ngu gbü bütü-ngu ka-ye la, de ni nzö.” ");
INSERT INTO muh_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Fü Rebeka alügü ngü fefe, gü ba, “Ye nzö enzö, mere kpara.” Fü Rebeka ayia bü wö! ae bütü-ngu la, azoro esaka ye. Fü mürü tima la ayia anzö ngu la. ");
INSERT INTO muh_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sidi nga ngu, de te engu nzö la, fü Rebeka ayia amala ngü fefe, gü ba, “Ni ena ato ngu fü wü kamele ka-ye la, de wüh nzö te nga wü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Fü Rebeka ayia atökö ngu la gbü bütü-ngu ka-ye ꞌburu gbü mere gada, te wüh ngbü eto ngu fü wü nü gbügbü. Fü Rebeka akpe adu kpa füh du-kpa-ngu, ase gara ngu. Fü ah angbü enda nga ye, da ese ngu fï bala. Fü wü kamele anzö ngu te nga wü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Fü komö mürü tima la ayia agu ka ngü la. Fü engu angbü eceka Rebeka, da efï nga ngü, gü ba, “E-ena adi dela würüse te Me fe engu fü Yïsaka, teka gba ka-ni ne, de?” ");
INSERT INTO muh_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Te wü kamele nzö ngu tï tete, fü mürü tima la ayia aza mere züka mafe, te wüh mere gbü *diki-se, ato fü Rebeka, de ah to gbü gü ye. Fü engu adu aza wü kengbe, te wüh mere kpah gbü diki-se, ato te kpakpa na. ");
INSERT INTO muh_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Fü engu ayi-ta Rebeka, gü ba, “Ye neh mbi mbi de ye da? Te ani nü de wü kpara ka-ni, bete wü nü ka-ni ne, kpa gba wü la, ani tï eyi amaka mba sü ara tete?” ");
INSERT INTO muh_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka gü ba, “Ïrï wö ni de Betuwele, ye Nayora. ");
INSERT INTO muh_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Wü koro ekoro de wü nü ka-wü la ꞌburu, de ani nü kpa ekötï. Wü ena amaka sü ka rara kpa gba ani kpala, te ena atï de wü kpara la, de wü nü ꞌburu. Wüh ena ato kpah zü-e fü wü nü la. Wü koro ekoro.” ");
INSERT INTO muh_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","27","Fü mürü tima la adu angbü de mere tadu te ye, angü würüse la de kundu ye enga ni ye Abarayama. Fü engu agü ba, “Gbo nga e ngbü te ïrï Me, te di de vüngüte ka mere kpara ka-ra ne! Angü ah ngbü emere züka ngü ka vüngüte fü Abarayama, baka ngü ta te engu mala fefe na gügü ne. Amba Me ce ngü la nda de. Teka ra, Me za ra, gü tamu kaje fere teke teke! Fü ra anü akoro eyi kpah te gba wü di enga eyï mere kpara ka-ra.” ");
INSERT INTO muh_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Fü Rebeka akpe adu kpa ekötï, amala nga ngü la fü ni ye. ");
INSERT INTO muh_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Gara enga ni ye Rebeka ta ladü kpala, de ïrï ye Labana. Fü Labana ayia aje kpah ngü, de te Rebeka mala la. Fü ah awu kpah wü züka mafe, bete wü züka kengbe, te mürü tima ka Abarayama la to gbü kpa Rebeka ne. Fü ah aje kpah wü ngü, te mürü tima la mala fü Rebeka ne. Te Labana je ngü la bala, fü ah ayia amü ꞌduwa de woro, anü kpa füh du-kpa-ngu la, teka awu komoko la cu de jia ye. ");
INSERT INTO muh_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Te Labana koro kpaka wü mürü tima la, fü engu amala ngü fü ewü, gü ba, “Mere kpara, ye kpakine baka kpara te Me le ye fa sü. Ye rü te kaje neh teka ne? Wü koro ekoro, ani nü kpa ekötï, angü ni reke sü teka wü eyi. Mba enga sü kpah ladü teka wü nü ka-ye, fü ewü ara tete.” ");
INSERT INTO muh_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Fü mürü tima ka Abarayama la ayia, de wü kpara gbü nga ye, anü de wü Labana kpa ekötï. Te wüh koro kpa ekötï, fü Labana ayia amala ngü fü wü labï ka-ye, gü ba, “Wü furu wü e füh gü wü kamele la asidi, de wü za züka gü, wü to fü wü kamele la, de wüh zü. De wü za kpah ngu, ato fü wü kpara la, de wü zürü küte wü di.” ");
INSERT INTO muh_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Fütanga ngü la, fü ewü adu aza e-mazü, akoro di, ato fü wü ngba la. Fü mürü tima la amala ngü fü Labana, gü ba, “Aꞌa, ani tï azü kümü nda-ani la de. Ni le amala la si-ngü, te wüh tima ni tete, koro di gba wü ne, fü wü feke.” Fü Labana alügü ngü fefe na, gü ba, “Ye mala ngü engu la emala.” ");
INSERT INTO muh_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Fü mürü tima la ayia areke te-ye, akpo emala ngü fü wü Labana, gü ba, “Ni de kpara ka tima ka Abarayama, te di de afudu wö ye ne. ");
INSERT INTO muh_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Angü Me to wazi fü Abarayama eyi fa sü. Abarayama koro tïne eyi mere kpara, de mere bi wü e esaka ye. Me to mere bi se, wü labï, wü nü, ba wü kambiliki, de wü yiti, abe kpah te wü dongï, de wü kamele eyi fefe na fa sü. ");
INSERT INTO muh_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Kpah bala, Sara bï ye komoko kpah eyi fü Abarayama, tïne gbü gbe ye dene. Fü Abarayama ayia ato mere bi wü e ka-ye la kpah eyi, ace ao ꞌburu fü ye ye la. ");
INSERT INTO muh_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Fü Abarayama ayia atima ni, gü ba, ‘Ni koro, ni se würüse fü ye ni la kpakine. Ni mere e, ase würüse la fü ye ni esüka egba wü Kanana, te ani ngbü gbü sü ka-ewü ne, de. ");
INSERT INTO muh_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ni nü kpa gbü sü ka nguwa wö ani kpakine, de ni ceka jaji würüse la gbü nguwa wö ani.’ Fü ni, mürü tima, ayia akïna kïna, ga, ni ena amere ngü la ꞌburu kpah bala, baka e te mere ka-ni mala la. ");
INSERT INTO muh_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ni yi-tata ta kpah eyi, ga, ‘Anga te würüse la le teka adu agbü tö ka wü Kanana nda de, angü sü mo amo la?’ ");
INSERT INTO muh_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Fü Abarayama amala fü ni, gü ba, ‘Me, de te ni, Abarayama, le ngü kaka-na ne, engu ena atima malayïka ka-ye engagira nü, de ah ü kaje fü ni, fü ni afe züka würüse fü ye ni gbü nguwa ani. ");
INSERT INTO muh_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Amba te wü mürü ni le, gü ba, “Jaji würüse engu mere e adu ake ni kpa gbü Kanana de la,” ngü ma, kïna engu de te ni kïna te-ni di ne, tï arï gbü nga ni nda de.’ ");
INSERT INTO muh_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Baka te ni nü koro füh du-kpa-ngu mari ede ꞌbaranga de kpane ne. Fü ni arü, aku gba fü Me, gü ba, ‘Wayi bala Me, ye de vüngüte ka mere kpara ka-ni, Abarayama! Ah le de ye ü kaje fü ni, de ni maka würüse fü ye mere kpara ka-ni. ");
INSERT INTO muh_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Angü ni rü eyi de füh du-kpa-ngu ne, teka amala ngü fü gara jaji würüse te ena akoro, ase ngu. Ni ena ayi-tata, de ah to ngu fü ni, de ni nzö. ");
INSERT INTO muh_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Te jaji würüse engu la le eyi ato ngu fü ni, de wü kamele ka-ni ꞌburu la, dela eyi jaji würüse, te ye fe, de ah di wara Yïsaka, ye mere kpara ka-ni ne.’ Dela gba ka-ni tïne, te ni ku fü Me. ");
INSERT INTO muh_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Kpah bü baka te ni ngbü la eku gba fü Me bala, fü ni awu Rebeka, te ngbü ekoro de bütü-ngu gbü nzö ye. Fü ah akoro kürrrü! anü kpa füh du-kpa-ngu, akpo angbü ese ngu. Fü ni ayia amala ngü fefe na, gü ba, ‘Ye to ngu fü ni, de ni nzö.’ ");
INSERT INTO muh_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Fü engu ayia kere, ae bütü-ngu la, azoro esaka ye. Fü ah ayia ato ngu la, fü ni anzö. Fü ah adu kpah, ase ngu, ato fü wü kamele ka-ni ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Fü ni ayia ayi-tata, gü ba, ‘Ye neh ye da?’ Engu gü ba, ‘Ni de ye Betuwele, te di de ye Nayora, enga ni ye Abarayama,’ ne. Te ni je ngü la bala, fü ni ayia aza mafe ne, ato fefe, teka de engu to gbü gü ye. Fü ni aza kpah wü kengbe, de engu to gbü kpa ye. ");
INSERT INTO muh_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Fü ni adu agbo nga ïrï Me afa sü, angü engu zu de vüngüte ka mere kpara ka-ni. Teka ne de, angü Me gü tamu kaje la me-ye fü ni, fü ni akoro amaka tangbase ne, de wüh za te-wü ake Yïsaka, angü engu de mürü ye Abarayama fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Fü mürü tima la adu ayi-ta ewü, gü ba, “Wü je ngü, de te ni mala la eyi? Te di bala, wü ena alügü ngü fü mere kpara ka-ni, agü neh fe? Wü tï amere ngü la fefe, baka e te engu ngbü ele? Ah le de wü mala züka ngü emala fü mere kpara ka-ni, te wü le eyi ato jaji würüse ne, fü ye mere kpara ka-ni aza engu wara ye tete la. Amba te wü le de la, de wü mala emala fü ni mbölö, teka de ni wu mene ngü, te ni ena amere.” ");
INSERT INTO muh_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Fü wü Labana ake Betuwele alügü ngü, gü ba, “Gara ngü gömö a, te a ena amala nda ma, angü ngü la koro ka-ye kpaka Me. ");
INSERT INTO muh_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","A ena ato Rebeka ato fü yi. Mü ena aza engu aza, anü di, ato fü ye Abarayama wara ka tete, baka e te Me mala.” ");
INSERT INTO muh_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Te mürü tima la je ngü la bala, fü engu ayia abu nzökuta ye kötö, agbo nga ïrï Me. ");
INSERT INTO muh_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Fü engu ayia aza mere bi wü züka e, ato fü Rebeka, baka wü tüngü, wü ꞌbiri, wü kengbe, de wü bongo. Fü ah adu kpah aza mere bi wü se, ato fü wü di enga ni ye Rebeka, bete ni ye na. ");
INSERT INTO muh_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Te ngü la nza tete, fü mürü tima la adu tïne, azü e de wü kpara ka-ye. Fü ewü ayia ara sela. Te kpï seke tete, fü mürü tima la ayia ayi-ta wü di enga ni ye Rebeka, gü ba, “Wü ce kaje fü ani, de ani lügü nga ani, du kpaka mere kpara ka-ani, enatikine.” ");
INSERT INTO muh_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Fü ewü amala ngü fefe, gü ba, “Te enga ni ani ena angbü la mba de wü ani sene, teka sïkpï nzükpa feke, fü wü ayia tïne, ago de ewü la, ah ena adi esiti?” ");
INSERT INTO muh_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mürü tima la gü ba, “Yi mere e atïrï kaje fere enatikine de, angü Me le ta-ngü te ra eyi me-ye, fü ra ayia amere ngü, de te wüh tima ra tüngüngü ne. Te di bala ne, yi ce kaje fere, de ma yia enatikine, de ma du kpaka mere kpara ka-ra.” ");
INSERT INTO muh_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wüh gü ba, “Te ah bala la, ani ena aï Rebeka, ayi-tata teka ngü la feke. Fü ani aje ngü la gögömö.” ");
INSERT INTO muh_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Fü ewü ayia aï Rebeka, ayi-tata, ga, “Rebeka, enga ni ani deyï, ye le eyi ayia enatikine, ago de wü komoko ne agbü Kanana, teka fü ye mere kpara ka-ewü aza ye wara ye tete?” Rebeka gü ba, “Wayi, ni le eyi ago de ewü kpala enatikine.” ");
INSERT INTO muh_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Te wüh je ngü la cu gömö Rebeka bala, fü ewü aci ꞌburu ale, gü ba, “Rebeka go ka-ye ego de ewü.” Fü ewü ayia eto kpah gara mere würüse, kpara ka tima ka ni ye Rebeka, de ah nü, ah di emere tima fü Rebeka. ");
INSERT INTO muh_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Fü wü mürü ye Rebeka amala ngü fefe, agü ba, “Tangbase ka-a, Me to mere wazi fü mü, ꞌduwa ba-neh-ene-la. Fü mü abï wü ye ba ca e kötö ne. Fü wü di enga mü la amere kpeke, adi egü gü da efa wü vügü ka-wü. Me to wazi la fü mü bala.” ");
INSERT INTO muh_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Fü wü Rebeka ayia de wü würüse ka tima ka-ye, te Labana to, alï füh wü kamele. Fü ewü ayia go, de wü kpara ka tima ka Abarayama, agbü Kanana. ");
INSERT INTO muh_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Gbü wü sïkpï la, Yïsaka go ngbü ka-ye gbü gara sü, gbü tö ka wü Kanana sela, te wüh ngbü eï, gü ba, Negebe ne, ede du-kpa-ngu de ïrï ye Bïrï-Laroyi ne. ");
INSERT INTO muh_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Gbü gara ra bane, fü Yïsaka ayia etamurago, anü da endoro egbere lö ye. Engu ga, ni ceka kpï bane de, gbo! te wü kpara te ewü ngbü egboko ekoro füh mere bi wü kamele. Fü ah ayia anü, teka de ani maka te-ani de wü kpara la. ");
INSERT INTO muh_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Wü Rebeka ngbü ta ekoro dela me-wü. Fü Rebeka ayia aceka kpï bane, awu Yïsaka nengete. Fü Rebeka ayia akö füh kamele ka-ye ne kötö. ");
INSERT INTO muh_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Fü ah ayia ayi-ta mürü tima ka Abarayama, gü ba, “Kpara de te ngbü ekoro de kpala, da enü mbi de ani de kpakine, ah de neh da?” Mürü tima la gü ba, “Dela Yïsaka, watï ye ne.” Fü Rebeka ayia aza mere kpa bongo, abuka gbüra ye, ani di. ");
INSERT INTO muh_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Fü mürü tima la ayia anü kpaka Yïsaka kpala. Fü ah atï te nga ngü te mere te-ye de kpala, amala ꞌburu fü Yïsaka, gü ba, “Ni koro de wara ye eyi dene.” ");
INSERT INTO muh_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Fü Yïsaka ayia angbü de mere tadu. Fü ah ayia aza Rebeka, adu di, ao gbü gugu, ta te ni ye na, Sara, ngbü gbügbü na ne, wara ye tete. Fü Yïsaka ale Rebeka ꞌduwa cu afa sü. Te di bala, fü jia Yïsaka adu alofo, fütanga kö ni ye la, teka ngü ka Rebeka. ");
INSERT INTO muh_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Gara wara Abarayama ta kpah ladü de ïrï ye Ketura. ");
INSERT INTO muh_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ah bï ta bi wü jaji komoko fü Abarayama. Ïrï wü jaji la de Zïmerana, Medana, Mïdïyana Yisibaka, Süwa bete Yokosana. ");
INSERT INTO muh_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Fü Yokosana ayia abï nda-ye wü Seba ake Dedana. Fü Dedana abï nda-ye nguwa wü kpara, de te wüh ngbü eï ewü, wü Asura, wü Letusima, bete wü Lumina ne. ");
INSERT INTO muh_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Fü Mïdïyana, ye Abarayama ne, ayia abï nda-ye wü Efa, Efere, Anoka, Abida, bete Eleda. Dela ꞌburu ïrï wü jaji guvu Ketura, de wü ata ye na, te di de gara wara Abarayama ne. ");
INSERT INTO muh_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Te Abarayama di ta la de jia ye ne, engu to ta kpah mere bi wü e eyi fü wü di ye, de te engu bï ewü ake Ketura bete Agara ne. Fü Abarayama ayia amala ngü fü ewü, gü ba, “Ah reke pe, te wü ena akö wü e ka-wü la, ayia ago di to kpa fügö. Te wü ngbü gbamari ede Yïsaka sene la, ah tï de, angü sü ꞌbe de.” Fütanga kö Abarayama, Yïsaka za wü e-nga-kpa wö ye la ꞌburu me-ye. ");
INSERT INTO muh_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abarayama kpi ta, o re kaka koro eyi ꞌburu kama biri teke bata nzükpa de füh ye ꞌburuve (175), o engu gbe tïne eyi fa sü. ");
INSERT INTO muh_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Fü Yïsaka ake Ïsïmayile ayia ati engu gbü gö da kpa gbü Makepela. Dela ta gö da, te Abarayama ti wara ye, Sara, gbügbü na ne. Wüh ti engu kpah ede biki Sara sela. ");
INSERT INTO muh_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Fütanga kö Abarayama, fü Me adu ato mere wazi fü Yïsaka, kpah ba e ta te engu to fü Abarayama ne. Gbü wü re la, Yïsaka ngbü ta ka-ye fï bü ede du-kpa-ngu, de ïrï ye Bïrï-Laroyi ne. ");
INSERT INTO muh_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Dene ïrï wü di Ïsïmayile, mbarase ta te Abarayama bï ake gara wara ye, de ïrï ye Agara ne. ");
INSERT INTO muh_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ïrï gina ye Ïsïmayile ta de Nebayota. Fü Ïsïmayile adu kpah abï wü Kedara, Adabele, Mibisama, ");
INSERT INTO muh_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misima, Duma, Masa, ");
INSERT INTO muh_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adada, Tema, Yeturu, Nafïsa, bete Kedema. ");
INSERT INTO muh_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Dela ꞌburu ïrï wü di Ïsïmayile. Wüh ꞌburu wü jaji komoko nzükpa de füh ye ꞌbasu. Fü ewü aga akoro ꞌburu baka nga nzö nguwa wü kpara, nzükpa de füh ye ꞌbasu. Fü ewü adi egü ïrï wü kötï ka-wü, kpah ꞌburu te nga nguwa wü la. ");
INSERT INTO muh_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","18","Wü di Ïsïmayile la ra kötï ka-wü ta ezengba wü Avïla ake Sura, ede kaje ka Asura, mari ede *Ezepeto to kpa fügö. Fü ewü angbü da ememere wü gü esüka wü, de wü gara wü kundu ye Abarayama ne. Fü re ka Ïsïmayile ayia akoro ꞌburu kama biri teke biri nzükpa de füh ye lorozi (137), fü engu ayia akpi. ");
INSERT INTO muh_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Dene ngü teka wü di Yïsaka, ye Abarayama, te ewü bï ake Sara. ");
INSERT INTO muh_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yïsaka za ta wara ye, de ïrï ye Rebeka ne, o re kaka koro eyi ba re teke ꞌbasu (40). ");
INSERT INTO muh_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Fü Yïsaka ara akoro ake Rebeka baka wü re teke biri, wüh bï ye fï de. Fü Yïsaka angbü eku gba fü Me kpekpeke, de Me to ye fü ani ake wara ni. Fü Me ayia aje gba ka Yïsaka la. Fü Rebeka ayia amaka bu. Fü ewü angbü de mere tadu ake watï ye teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Fütanga ngü la, fü wü ye de guvu Rebeka la akpo angbü eto mere kuru tete na, angü ah wu de, gü ba, ah de wü dadase. Fü Rebeka ayia amala ngü, gü ba, “Si-ngü gbü ngü ne, neh mbi mbi baye?” Fü Rebeka ayia ayi-ta Me, teka de Me sere si-ngü la. ");
INSERT INTO muh_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Fü Me amala ngü fefe, gü ba, “Si-ngü la, ah bane. Ye de guvu mü la, ka-ye wü dadase, ꞌbasu mini wü jaji komoko. Wüh ena akoro ba nguwa wü kpara ꞌbasu. Fü ewü angbü emere gü esüka wü ake enga ni ye. Fü wazi gara na afa kiri ye ka. Mene engu, te ena akoro te enga gina ne, ena angbü eje ngü gömö mene de sidi ne.” Dela ngü ta te Me mala fü Rebeka, teka wü dadase, te engu ena abï ne. ");
INSERT INTO muh_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Fü bu Rebeka ayia andri. Fü Rebeka ayia ayaka wü jaji la ꞌbasu mini, ꞌburu wü jaji komoko. ");
INSERT INTO muh_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","26","Gina ye la, ah ta de mbe kpara, küküte na ngbü de su te ye rurrru, baka su eküte nü la. Fü mene te koro sidi ne azoro lö enga ni ye, gina ne, gö! Wüh gü ïrï gina ye la, Esawu. Fü ewü agü ïrï sidi ye la, *Yakobo. Yïsaka bï ta wü jaji la, o re kaka koro eyi teke bata (60). ");
INSERT INTO muh_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Fü wü jaji la agere, akoro wü komoko. Esawu ta de kpara te ngbü emörö wü nü ꞌduwa ba-neh-ene-la. Yakobo nda-ye de kpara te ngbü engbü ka-ye bü ekötï, da emere wü tima ka kötï. ");
INSERT INTO muh_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Fü Yïsaka ale ngü ka ye ye, de Esawu ne, cu afa sü, teka so, ta te engu ngbü ezü esakaka na ne. Fü Rebeka ale nda-ye di ngü ka enga ye, de Yakobo ne, kpah afa sü. ");
INSERT INTO muh_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gbü gara sïkpï, Yakobo ngbü ta ega fïrïnda ka-ye. Fü Esawu adu akoro kpa da endoro ka-ye agbü gü ne, de mere tala te ye. ");
INSERT INTO muh_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Te Esawu je se fïrïnda, te enga ni ye ngbü ega la, fü engu ayia ayo fïrïnda la eküte enga ni ye, gü ba, “Enga wüna, mü tökö la mba fïrïnda ka-mü la akine, ma la, angü ma kpi ka-ra tïne akine ka tala eyi.” ");
INSERT INTO muh_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Fü Yakobo ayia alügü ngü fü enga ni ye, gü ba, “Mü efï nda-mü, gü ba, ma ena ato fïrïnda ka-ra fü ni bü kükürü bala? Te mü le de ma to fïrïnda ka-ra ne fü ni la, mü ena amere gara ngü fere feke. Ah le de mü mala emala, gü ba, ma ena adi tïne de gina me-ra fü ni, teka fü ra amaka wazi, ta te mü ena amaka ne. Angü mü ka-mü de gina fere. Ma wu eyi, gü ba, sidi nga kö wö nih, mü ena angbü me-mü de mere kpara. Fü Me ato mere wazi fü mü, baka te engu to fü wü wö nih, de wü kundu nih gügü ne.” ");
INSERT INTO muh_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esawu gü ba, “Ma ena angbü ba mere kpara la, neh elaye, te ma eyia eyi ekpi akpi ka tala ne?” ");
INSERT INTO muh_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Fü Yakobo amala ngü fefe, gü ba, “Te mü le eyi la, de mü kïna te-mü ekïna tïtïne, teka fü ra agü fïrïnda ka-ra ne fü mü.” Fü Esawu ayia akïna te-ye, gü ba, “De-mü Yakobo, mü fere tïne eyi ba gina. Fütanga kö wö nih, mü ena angbü mere kpara me-mü.” ");
INSERT INTO muh_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Fü Yakobo ayia aza kümü de fïrïnda, ato fü Esawu. Fü Esawu ayia azü. Fü ah ayia anzö ngu, ayia anü sü ka-ye. Ah fï nga ngü la kpah de. Dela ngü ta te Esawu fala ngü ka mere wazi ka Me, te Me le ato fefe na ne. ");
INSERT INTO muh_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gbü gara re, fü mere kpïrï tala adu kpah atï gbü *Kanana, fü Yïsaka ayia anü kpaka Miri Abi-Meleke, te di de miri ka wü Feleseto gbü Gerara sela. ");
INSERT INTO muh_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Fü Yïsaka ayia afï nga ngü, gü ba, ni le anü agbü *Ezepeto, angü e-mazü ladü kpala. Fü Me akoro amala ngü fü Yïsaka, gü ba, “Mü mere e akpe ago ka cürü agbü Ezepeto la de. Mü ngbü fï bü sela, angü ma ena agü tatamu züka sü fü mü me-ra. ");
INSERT INTO muh_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ah le de mü ngbü sela, angü te mü mere bala la, ma ena angbü ake mü, da eto wazi fü mü. Ma ena ato mere tö ka wü Kanana ne fü mü, de wü kundu mü. Fü yi angbü sela fï mere badi. Ma ena amere mere züka ngü fü yi ꞌburu, kpah baka e ta te ma kïna kïna di fü Abarayama ne. ");
INSERT INTO muh_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ma ena ato wazi fü wü kundu mü, fü ewü abï wü jaji, asibi asibi afa sü, ba wü küfara. Fü ra ato sü ne ꞌburu fü ewü. Ma ena aküwa nguwa wü kpara füh kotö ne ꞌburu, teka ngü ka wü kundu mü la. ");
INSERT INTO muh_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ma ena angbü de wü yi, fü ra amere wü züka ngü fü yi ꞌburu teka ngü ka wö mü, Abarayama. Teka ne de, angü Abarayama ta de kpara te ngbü eje rïrï ka-ra, da emere wü ngü de te ma ngbü emala fefe na ne ꞌburu kpini kpini.” ");
INSERT INTO muh_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Te Yïsaka je wü ngü, te Me mala fefe na la, fü engu angbü fï agbü Gerara kpala. ");
INSERT INTO muh_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Gbü gara sïkpï, fü wü kpara ka Gerara angbü eyi-ta Yïsaka teka wara ka, Rebeka ne, angü Rebeka su ta fa sü. Fü cürü ayia amere Yïsaka. Ah gü ba, “Te ni mala, gü ba, ‘Rebeka de wara ni’ la, e-wu neh da, wü kpara la ena amörö ni, fü ewü adu aza Rebeka.” Fü Yïsaka ayia alügü ngü fü ewü, gü ba, “Rebeka ka-ye de enga ni ni.” ");
INSERT INTO muh_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Fü Yïsaka ayia ayiri gbü Gerara sela teka mere bi wü sïkpï. Gbü gara sïkpï, fü Miri Abi-Meleke ayia aceka kpï te görö kambü ka-ye bane, gbo! te wü Yïsaka, te ewü ngbü etanü, emere wutu ka-wü ake Rebeka. ");
INSERT INTO muh_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Fü Abi-Meleke ayia atima ngü fü wü Yïsaka, de ah koro kere. Fü Yïsaka ayia akoro. Fü Abi-Meleke amala ngü fü Yïsaka, gü ba, “Ni wu eyi, gü ba, Rebeka ka-ye de wara ye. Amba si-ngü de te ye cere nga Rebeka di te ani, gü ba, ‘Angü Rebeka ka-ye de enga ni ni ne,’ neh mbi mbi baye? Ye fiti ani bala, neh kü teka ne?” Yïsaka gü ba, “Ni mala ngü la bala ka cürü. Angü, te ni mala, gü ba, ‘Rebeka de wara ni la,’ e-wu neh da? Wüh ena amörö ni teka ngü kaka-na.” ");
INSERT INTO muh_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Fü Abi-Meleke amala ngü fü Yïsaka, gü ba, “Ye mere ngü la bala fü ani, neh teka ne? Anga ta te gara kpara esüka ani ena anü ta, agïrï Rebeka würüse tete na la ya? Ngü la ena adi ta de *siti ngü ka da? Angü ngü la de siti ngü gbü jia Me. De bane Me ena ato ta kuru te ani teka ngü la.” ");
INSERT INTO muh_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Fü Abi-Meleke ayia awu, gü ba, cürü ngbü emere Yïsaka me-ye. Fü ah adu amala ngü fü wü kpara ka-ye ꞌburu, gü ba, “Wü mere e amere siti ngü fü wü Yïsaka de. Mene kpara te ena akpülü ewü ake wara ye la, wüh ena amörö engu ꞌduwa amörö.” ");
INSERT INTO muh_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Gbü re ka mere tala la, fü Yïsaka ayia asö yï ka-ye gbü tö ka Gerara la. Fü engu aru wü e gbügbü na. Fü Me ato mere wazi gbü yï kaka-na la. Fü wü e kaka la arï afa sü. Fü engu ayia amaka mere langba ndo afa sü le. Amba nda wü bu ye na rï mbi mbi de. ");
INSERT INTO muh_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Fü Me angbü fï bü eto wazi fü Yïsaka efa sü. Fü wü e kaka-na, ba e-mazü, angbü esibi tïne fï bü efa sü. Fü Yïsaka adu akoro tïne kpeke kpara, de mere bi wü e esaka ye, ");
INSERT INTO muh_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ba wü kambiliki, wü yiti, bete wü labï. Fü wü kambiliki, de wü yiti kaka-na la, angbü ezu ꞌduwa efa sü. Te wü kpara ka Feleseto du wu, gü ba, Yïsaka maka mere bi wü e eyi ne, fü ewü ayia angbü ekpü engu, teka wü e de esakaka la. ");
INSERT INTO muh_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Fü ewü afï nga wü du-kpa-ngu, ta te Abarayama, wö ye Yïsaka jï, o engu di la de jia ye ne. Fü ewü akpo asiti wü du-kpa-ngu la, ani ewü ꞌburu asidi, teka wü nü ka Yïsaka ena adi enzö. ");
INSERT INTO muh_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Baka te züka ngü la ngbü emere te-ye tete fü Yïsaka bala, fü Miri Abi-Meleke ayia gbü gara sïkpï, amala ngü fü Yïsaka, gü ba, “Wazi ye fa nda-ani tïne eyi, angü ye tïne eyi de mere bi wü e esaka ye. Te di bala ne, sü ka-ani be tïne de. Ah reke areke te ye ena ayia akö wü e ka-ye, ago angbü di kpa gbü gara sü.” ");
INSERT INTO muh_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Fü Yïsaka ayia akö wü e ka-ye, ago angbü ka-ye to kpa fügö, te nga ze ka Gerara kpala. ");
INSERT INTO muh_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Fü Yïsaka adu afï nga wü du-kpa-ngu, ta te wü kpara ka Abarayama ngbü jï gügü, fü wü kpara ka Feleseto ayia ani ne. Fü wü kpara ka Yïsaka adu aoro wü du-kpa-ngu la, areke te nga wü ꞌburu. Fü Yïsaka agü ïrï wü du-kpa-ngu la kpah ꞌburu, gegege baka e ta te wö ye na gü te enga gina ne. ");
INSERT INTO muh_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Fü wü kpara ka Yïsaka ayia ajï gara du-kpa-ngu, ede ze ta te ewü ra kötï te nganga na ne. Fü ewü ayia amaka ngu, te ngbü edü ꞌduwa kpulu kpulu kpulu bane. ");
INSERT INTO muh_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Te wü kpara, de te ewü ngbü ta eceka kpï fütanga wü nü ka wü kpara ka Gerara ne, wu ngu te ngbü edü de bala, fü ewü akpo angbü ewü nga de wü kpara ka Yïsaka, gü ba, “Ngu la ka-ye ngu ka-ani.” Dela si-ngü te Yïsaka gü ïrï du-kpa-ngu la tete, gü ba, Eseke, te gü ba, “Mawü Nga”. ");
INSERT INTO muh_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Fü wü kpara ka Yïsaka adu kpah ajï gara du-kpa-ngu. Fü wü kpara ka Gerara adu kpah akpo de nga, da eyi-ta komö wü kpara ka Yïsaka. Fü Yïsaka ayia agü ïrï du-kpa-ngu la, gü ba, Sitena, te gü ba, “Makpü”. ");
INSERT INTO muh_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Fü Yïsaka ayia ace sü la, ago angbü ka-ye kpa gbü gara sü. Fü ah adu kpah ajï gara du-kpa-ngu kpala. Fü wü kpara ka sü la angbü emala, gü ba, “Ngu la ka-ye ngu ka Yïsaka.” Wüh mala siti ngü fefe na nda-wü de. Fü Yïsaka ayia agü ïrï du-kpa-ngu la, gü ba, Robota, te gü ba, “Zö-ngbüngbü”. Yïsaka gü ba, “Me to mere züka gu sü eyi fü ani, teka fü ani ago ara kötï gbügbü na, da emaka wü züka ngü.” Fü wü Yïsaka ayia angbü sela. ");
INSERT INTO muh_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Gbü gara re, fü wü Yïsaka ayia adu angbü ka-wü agbü Bïrï-Saba, gbü sü ta te wö ye na o kötï tete na gügü ne. ");
INSERT INTO muh_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Te wü Yïsaka koro kpala, fü Me ayia akoro agü tamu ye fefe gbü biti la, gü ba, “Mü mere e akpe cürü wü kpara ka sü ne nda-mü de. Angü de-ra, Me, te ma di de *vüngüte ka wö mü ne, ma ena angbü fï bü ake mü. Ma tï ace mü nda-ra de. Ma ena ato wazi fü mü, de wü kundu mü, teka ngü ka wö mü, Abarayama. Fü ewü abï ye, asibi asibi, baka ngü ta te ma mala fefe na ne.” ");
INSERT INTO muh_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Fü Yïsaka ayia areke sü kpala, teka angbü egbo nga ïrï Me gbügbü na. Fü engu ayia kpah, ao kötï ede sü la. Fü wü kpara kaka-na akpo kpah egïrï sü teka ajï du-kpa-ngu ka-wü tete na. ");
INSERT INTO muh_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Gbü gara sïkpï, fü Miri Abi-Meleke ayia akoro kpaka Yïsaka, agbü Bïrï-Saba sela. Wüh koro ta de wü mere kpara ka-ye, wü Azata, mere kpara te ngbü eto fïngangü fefe na, bete Fïkola, mere kpara ka wü marajümïya kaka. ");
INSERT INTO muh_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Fü Yïsaka ayia amala ngü fü ewü, gü ba, “De-wü deyï, mere bi fe ni wu wü tïne de. Wü koro afa nga ni kpakine neh teka ne? Wüh koro teka aliki ani gbü sü ne, baka engu de tane?” ");
INSERT INTO muh_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Wüh gü ba, “Ah bala de. Ani mere ta ngü la bala, angü sü be teka ani de wü ye ꞌburu ne nda de. Amba enatikine ani koro bü mba aceka ye. Ani wu eyi tïtïne, gü ba, Me to wazi fü ye eyi cu fa sü. Te di bala ne, ani ele de ani nzö ngüte de wü ye. Amba ani le de ye kïna kïna, ");
INSERT INTO muh_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","gü ba, ‘Ni tï amere siti ngü fü ani de.’ Angü ani mere ta siti ngü fü ye nda-ani kpah de. Ani mala ta fü ye, de ye ce sü ka-ani gbü züka ngü. Te di bala, ah le de ye kïna te-ye ekïna, angü ani wu eyi kpo, gü ba, Me le ye fa sü.” ");
INSERT INTO muh_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Fü Yïsaka ayia angbü de tadu. Fü ah amala ngü fü wü kpara ka-ye, de wüh mere wü e-mazü fü ewü. Fü ewü ayia azü wü e la, kpah da enzö wü e de ewü ꞌburu gbü sü biringbö. ");
INSERT INTO muh_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Te kpï seke tete, kpurutokokpï la, fü ewü ayia anzö *ngüte esüka wü, kpah baka e te ewü mala esikine ne. Fü Yïsaka ayia agï nga ewü, ace kpa te kaje. Fü ewü ayia ago agba wü, gbü züka ngü mürü. ");
INSERT INTO muh_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Gbü ra engu la, fü wü kpara ka Yïsaka adu akoro amala ngü fefe, gü ba dene, “Ani maka ngu gbü du-kpa-ngu, de te ani ngbü ejï ne eyi.” Fü ngü ayia areke te Yïsaka afa sü. ");
INSERT INTO muh_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Fü Yïsaka ayia agü ïrï du-kpa-ngu la, Saba, baka e te wüh gü ba, “Kïna”. Ah gegege ba ïrï ta te Abarayama gü te du-kpa-ngu, te engu jï gbü sü la. Dela si-ngü de te wüh ngbü eï sü la tete enatikine, gü ba, Bïrï-Saba ne. ");
INSERT INTO muh_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Te re ka Esawu koro tete ba e teke ꞌbasu, fü engu ayia ase wü würüse ꞌbasu, ꞌburu wü egba ganzi kpara gbü nguwa wü Ete. Ïrï gina wara ka ta de Yudïta. Ïrï eꞌbaꞌbasu würüse nda ta de Basemata. ");
INSERT INTO muh_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Fü ngü la asiti ta gbü jia wü wö ye na, Yïsaka ake ni ye na, Rebeka afa cu sü. Angü gbü gele ka-ewü, wüh tï aza te-wü de wü ganzi kpara de. ");
INSERT INTO muh_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Fütanga wü ngü la, fü Yïsaka agbe tïne afa sü. Jijia na du ceka kpï mbi mbi nda tïne de. Gbü gara ra, fü Yïsaka ayia aï gina ye ye, de Esawu ne, de ah koro kpaka ni. Fü Esawu ayia ale ngü, akoro kpaka wö ye. ");
INSERT INTO muh_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yïsaka gü ba dene, “Wayi, Esawu, enga ra, ma gbe nza ka-ra tïne eyi dene. Sïkpï ka kpi ka-ra kpah eyi gbamari. ");
INSERT INTO muh_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","Te di bala, ah le de ma ce wazi ka-ra, te Me to fere ne, fü mü, angü mü de gina ye ra, teka fü mü angbü mere mürü kötï fütanga kö ra. Te di bala, de mü za dïrï ka-mü, mü nü, mü gïrï la nü, de mü mörö, fü ra azü ka fele. Te mü mörö nü engu eyi la, de mü fe züka wü so la, de mü zi reke areke. Te ma zü nza eyi la, ma ena ato wazi ka-ra ꞌburu fü mü. Fü ra asü ngüsü esatïkpa mü, teka fü mü amere kpeke.” Fü Esawu ayia anü sü kpa gbü gü, teka agïrï wü nü la, amörö. ");
INSERT INTO muh_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Amba de, Rebeka, mü je ngü de te Yïsaka ngbü emala fü Esawu ne, nda-mü eyi. Te Rebeka wu, gü ba, Esawu nü sü eyi agbü gü ne, ");
INSERT INTO muh_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","fü ah ayia kere, akpe anü, agïrï *Yakobo, amala ngü fefe, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Enga ni, ni ngbü tïtïne dene, fü ni aje ri wö ye, te engu ngbü emala ngü fü Esawu, gü ba, ‘Ni ele ato wazi ka-ni, te Me to fü ni, fefe, de ah ngbü ba mere mürü kötï fütanga ni, angü ah de gina ye ni.’ Ah atima Esawu, de ah nü agbü gü, ah gïrï so fü ni feke, teka fü ni ato wazi la fefe na. ");
INSERT INTO muh_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Te di eyi bala ne, enga ni, dene mani te ye ena amere, afiti wö ye di, teka fü engu ato wazi la fü ye, fü ye angbü ba mere mürü kötï me-ye. ");
INSERT INTO muh_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ye nü enü kpa gbü sü te wü meme ngbü ezü e tete na, de ye za wü di enga meme kpala ꞌbasu. Fü ye amörö ewü, akoro de so ewü fü ni, teka fü ni azï züka wuru gbügbü fü wö ye. Wuru engu la, ah ena adi de wuru te wö ye ngbü ele ngüngü na efa sü, de te engu mala nganga na fü Esawu ne. ");
INSERT INTO muh_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Amba ye ena aza wuru engu me-ye, anü di fü wö ye, de engu zü, angü wö ye ena afï nda-ye, gü ba, dela eyi wuru de te Esawu zï koro di fü ni ne, angü jijia tïne eyi ma. Fü engu ato wazi ka-ye la tïne ꞌburu fü ye.” ");
INSERT INTO muh_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","12","Yakobo gü ba dene, “Anga te wö ni ena ao kpa ye eküte kpa ni, atala la, ni ena amere baye? Angü su de eküte kpa Esawu ne, fa ka-ye nda-ni ne ka. Te di bala, wö ni ena awu teke, gü ba, dela ka-ye kpa ni, ah de kpa Esawu nda de. Fü ngü ka-ni, Yakobo, asiti gbü jia wö ni ꞌduwa afa sü. Ah ena aza ni ba mürü wu, fü mamaguma asiti tïne eküte ni afa sü. Fü engu ao komö ye gbü nga ni. Dela ena adi züka ngü?” ");
INSERT INTO muh_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Rebeka gü ba, “Ye mere e akpe cürü de. Te ngü la du fü te-ye, mere te-ye bala la, komö wö ye tï arï gbü nga ye nda de. Ngü la ena angbü gbü nzö ni. Ye nü enü, ye zoro nda bü wü di enga wü meme la, de ye du di, fü ye amere ngü engu la, ba e te ni mala fü ye la.” ");
INSERT INTO muh_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Fü Yakobo ayia anü azoro wü di enga meme ꞌbasu, amörö ewü, akoro de so ewü, ato fü ni ye. Fü Rebeka ayia azï ꞌduwa züka wuru, te di ꞌduwa mene ngütü de te watï ye ngbü ele efa sü ne. ");
INSERT INTO muh_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Fü Rebeka ayia aza züka bongo gbü nga Esawu, te di ta kpa esambü la, ato fü Yakobo, de engu to te ye, teka fü sese angbü kpah ba se Esawu. ");
INSERT INTO muh_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Fü Rebeka adu aza kpah konü wü meme la, agbala, ai, ao eküte kpa Yakobo, be kpah te ngüngürü na, angü su ta eküküte baka nda Esawu nda ma. ");
INSERT INTO muh_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Fü Rebeka ayia aza kümü, bete züka wuru engu, de te engu zï la, ato fü Yakobo, de engu nü di fü wö ye. ");
INSERT INTO muh_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Fü Yakobo aza e-mazü la, anü di fü wö ye, aï wö ye. Fü Yïsaka ayia ale ngü, gü ba, “Wayi enga ra, mü de neh da?” ");
INSERT INTO muh_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo gü ba, “Ah de-ni, Esawu, gina ye ye ne. Ni mere ngü tïne, te ye mala nganga fü ni ne eyi. So de te ye mala nganga na ne eyi dene. Ye yia eyia tikpi, de ye zü. Fü ye adu tïne ato wazi ka-ye la fü ni.” ");
INSERT INTO muh_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Fü wö ye na alügü ngü, gü ba, “Enga ni, ye mere ngü ye, amaka so la, akoro di kpah bü kere de bala, neh fe ya?” Yakobo gü ba, “Amba Me, te di de *vüngüte ka-ye ne, le ta-ngü te ni me-ye. Fü ni ayia amörö nü la mba kere dene tüngü la.” ");
INSERT INTO muh_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yïsaka gü ba, “Ye koro la mari kpa ede ni akine, de ni tala küte ye. Fü ni awu tete, gü ba, ye ngbürü de ye ni, Esawu, fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Fü Yakobo ayia aka te-ye, akoro gbamari ede wö ye. Fü wö ye na atala küküte, aceka, fü ah amala fefe, gü ba, “A! Dene bane ne ngü ne? Angü ri mü akine baka ri Yakobo. Amba kpa mü nda di ba nda Esawu la.” ");
INSERT INTO muh_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Yïsaka tï ta awu, gü ba, dela Yakobo ne de, angü jijia na ni ka-ye ta eyi. Te engu tala kpa Yakobo, maka su tete, ba su te kpa Esawu ne, fü ah afï nda-ye, gü ba, “Wayi, dela eyi de Esawu fanü. Ni ena ato wazi ka-ni la ato fefe.” ");
INSERT INTO muh_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Fü Yïsaka adu kpah ayi-ta ngü, gü ba, “Mü mala la ngü fere fanü fanü. Mü ngbürü de Esawu fanü?” Yakobo gü ba, “Wayi, wüba, ma ngbürü de Esawu fanü.” ");
INSERT INTO muh_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yïsaka gü ba, “Ah mbi. Mü to e-mazü la eto, de ma zü. Fü ra adu ato wazi ka-ra, te Me to fere, fü mü.” Fü Yakobo ayia ato e-mazü la fü wö ye. Fü wö ye na azü. Fü Yakobo aza kpah fï, ato fü wö ye, anzö. ");
INSERT INTO muh_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Te Yïsaka zü e la nza tete, engu gü ba, “Enga ra, mü ka te-mü, gbamari kpakine, de ma faka mü.” ");
INSERT INTO muh_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Fü Yakobo ayia aka te-ye, akoro gbamari kpaka wö ye. Fü wö ye na ayia afaka engu, ayia aje se bongo de eküküte na ne. Fü ah ayia awu, gü ba, dela ngbürü eyi ye ni, Esawu ne. Fü Yïsaka ayia ato wazi ka-ye fü Yakobo, gü ba, “Enga ra, se mü akine gbooo, gegege ba se züka fu-ndo kpa gbü yï, te Me to wazi ye eyi gbügbü na. ");
INSERT INTO muh_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ma eyi-ta Mere Me, de ah to wazi fü mü fï bü bala. Me to wazi teka de agö di elï füh wü e ka-mü, de wüh ga reke areke. Me to wazi, de ndo de gbü yï ka-mü la rï arï, de jia ye jete jete bala. Me to wazi, de wü rïrü ka-mü la rï arï rudu rudu. ");
INSERT INTO muh_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Me to wazi, fü mü angbü ba mere mürü kötï, kpah baka miri gbü nzö wü di enga ni mü ꞌburu. Fü ewü angbü eje ngü ka-mü. Me to wazi fü mü, teka fü mü angbü gbü nzö nguwa wü kpara ꞌburu. Fü nda-mü wazi afa nda-ewü le ꞌburu. Fü ewü angbü nda-wü esatïlö mü. Mene kpara te ena afala mü, Me ena akïna engu. Mene kpara te ah ena angbü egbo nga ïrï mü, da eyi-ta Me tüngü mü la, Me ena angbü kpah ake di.” Dela ngü de te Yïsaka ku gba di fü Me, de ah mere fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Te Yïsaka ku gba de wü ngü la teka Yakobo nza tete, fü Yakobo ayia anü sü ka-ye. Yakobo kpah bü te enü sü bane, Esawu du koro kpah eyi. ");
INSERT INTO muh_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Fü Esawu ayia aza so, de te engu du koro di ne, azï areke areke. Fü ah aza akoro di fü wö ye. Te engu koro de e la kpaka wö ye, ah gü ba, “Wüba, ma koro eyi. Mü yia eyia tikpi, de mü zü so ka-mü, de te ma zï, koro di fü mü ne, teka fü mü ato wazi ka-mü fere.” ");
INSERT INTO muh_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Wö ye na gü ba, “Mü neh da?” Esawu gü ba, “Ah de-ni Esawu, gina ye ye ne.” ");
INSERT INTO muh_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Fü Yïsaka akpo angbü eyï, gbi gbi gbi, teka ngü la. Fü ah ayi-ta ngü, gü ba, “Te ah bala la, anga mene kpara, te koro tïne de so fere ne, ah nda de neh da? Angü ma zü so kaka-na la tïne kpah eyi. Ma to wazi ka-ra kpah eyi fefe na. Me ena adi ka-ye tïne eyi ake di, fü ah angbü ba mere mürü kötï me-ye. Tïtïne mba gara kaje, te wüh ena adu afü ngü la gbügbü na, nda tïne eyi ma.” ");
INSERT INTO muh_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Te Esawu je ngü de te wö ye mala la, fü engu aba rere ꞌduwa kpa tikpi, “Wuuwu! Wuuwu! Wüba! Anga de-ra! Mü to nda-ra wazi kpah eto!” ");
INSERT INTO muh_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yïsaka gü ba, “Ye ni, gara kaje kpala, te ni ena ato nda-ye gbügbü na ne, nda tïne eyi ma. Angü enga ni ye koro fiti ni bü tïtïne dene, fü ni ato wazi ka-ni ne eyi fefe na. Tïtïne ah ena angbü baka mere mürü kötï fütanga kö ni, tïne me-ye. Da ngü la adu afü nda tïne eyi ma.” ");
INSERT INTO muh_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esawu gü ba, “Amba wüh gü ïïrï Yakobo nda-wü kü mbi, angü engu de mürü wu. Engu fiti ta ra kpah te enga gina, za wazi ka-ra, ka gina ye ne ka! Mü ceka la! Engu du fiti mü kpah eyi, fü mü ayia ato wazi ka Me, ta te mü yia eto fere ne, tïne fefe!” Fü Esawu adu kpah andaꞌba te-ye fü wö ye, gü ba, “Wö ni deyï, gara mba du wazi ladü, te ye ena ato fü ni, anga ah nda ma?” ");
INSERT INTO muh_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yïsaka gü ba dene, “Ye ni deyï, ni mala eyi, gü ba, Yakobo ena angbü tïne me-ye ba miri ka-wü, de wü kundu ye fï mere badi. Fü wü e gbü yï kaka-na ꞌburu adi erï efa sü. Gara ngü kpala te lakï mba, te ni ena adu amere tüngü ye ne tïne eyi ma.” ");
INSERT INTO muh_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esawu gü ba, “Wüna! Amba wüba, wazi esaka mü, te mü ena ato fü kpara nda bü ngbee biringbö? Ma le de mü to nda-ra wazi kpah eto.” Fü Esawu akpo angbü eku tïne fï bü mere siti gba, enü di. ");
INSERT INTO muh_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Fü Yïsaka adu amala ngü fü Esawu, gü ba dene, “Amba ngü ka-mü ena adi bane. Mü ena ao gba mü gbü sü, te wü e tï aga tete de. Agö lï te sü la mbi mbi kpah de. ");
INSERT INTO muh_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Mü ena adi mürü gü. Fü mü angbü efa te-mü esaka wü vügü ka-mü de te-dü ka-mü. Enga ni mü ena angbü gbü nzö mü. Te di bala, gara sïkpï ladü, te yi ena agü gü ake di. Fü mü ayia ka-mü, ace engu.” Dela ngü ta te Yïsaka mala fü Esawu. ");
INSERT INTO muh_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Fütanga ngü la, fü Esawu adu angbü ekpü Yakobo tïne afa sü, teka ngü ta te wö ewü to wazi ka-ye fü Yakobo ne. Fü Esawu angbü efï ngü, teka de ni mörö Yakobo, amba ah ngbü ekpe cürü teka wö ye. Fü ah angbü efï ngü emaguma ye, gü ba, “Ah mbi! Angü wö ani gbe nza ne eyi dene de. Te engu kpi eyi la, ni ena amörö enga ni ni, Yakobo, asidi.” ");
INSERT INTO muh_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Te Rebeka je ngü, te Esawu ngbü efï de bala, fü ah ayia aï Yakobo, amala ngü fefe, gü ba, “Enga ni deyï, ngü de te ye mere fü enga ni ye ne, ah ti ngü la eyi guvu ye. Ah ngbü eo jia ye teka sïkpï, te wö ye ena akpi tete na, de ni mörö ye asidi. ");
INSERT INTO muh_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Enga ni, te di bala ne, ye yia eyia, ye nü agbü Padanarama, kpa gba loko ye, de ïrï ye Labana ne, teka aküwa te-ye. ");
INSERT INTO muh_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ye go, ye ngbü ka-ye kpala, zalü te maguma enga ni ye ena agu. ");
INSERT INTO muh_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Te mamaguma gu eyi la, toto na ena adu aïrï teka ngü, ta te ye mere engu di la. Te ni wu eyi bala la, ni ena atima ngü fü ye, fü ye adu akoro kpakine. Dela ngü te ni ngbü emala fü ye, enga ni, angü, te Esawu mörö ye la, wüh ena adu kpah amörö engu. Te di bala, ngü la ena ato mere cïnga. Angü ah ena adi de mere siti ngü, te wü di enga ni ena akpi anza ꞌduwa ꞌbasu mini, gbü ra biringbö.” ");
INSERT INTO muh_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Fü Rebeka ayia anü kpaka Yïsaka, afiti engu, gü ba, “Ni mbü ka-ni tïne gbü ngü ka wü wara Esawu, wü egba ganzi kpara ne eyi. Wüh je ngü nda-wü de. Te Yakobo ena aza würüse kpah gbü egba ganzi kpara, baka Esawu la, ah ena adi esiti! Ni ena akpi ka-ni akpi, teka ngü ka wü egba ganzi kpara la! Te di bala, ani ena amere dene mbi mbi baye?” ");
INSERT INTO muh_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Te Yïsaka je ngü la tete, fü ngü la atï gbü jijia na ꞌduwa kürrrü. Angü ta gbü wü sïkpï la, wü kpara za te-wü de wü ganzi kpara nda-wü de. Wüh ngbü eza te-wü ka-wü gbü mürü. Fü Yïsaka ayia aï *Yakobo, amala ngü fefe na, gü ba, “Enga ra, ma le teka de mü za würüse esüka wü egba ganzi kpara gbü *Kanana sene kpo fï de. ");
INSERT INTO muh_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ma ele de mü yia eyia, de mü nü kpa gbü nguwa wü ni mü agbü Padanarama, de mü za würüse kpala esüka nguwa wü ni mü la. ");
INSERT INTO muh_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Me di de mü kpala, de ah to bi wü jaji fü mü. De wü jaji la bï wü ye, sibi asibi. Fü ewü aga akoro mere bi nguwa wü kpara. ");
INSERT INTO muh_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Me di de yi, de wü kundu mü la, fï mere badi, kpah baka e te engu di de a ake wüba ta gügü ne. Tö ka wü Kanana, te nih ngbü gbügbü na enatikine ba wü ganzi kpara ne, te gara Me ena ato tö engu fü yi, de wü kundu mü. Angü Me mala ta ngü la fü Abarayama gügü, gü ba, ‘Ni ena ato tö ne fü wü kundu ye.’ ” ");
INSERT INTO muh_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Fü Yakobo ayia anü sü kpala. Dela ta ngü te Yïsaka tima Yakobo tete agbü Padanarama, kpaka loko ye, de ïrï ye Labana ne. ");
INSERT INTO muh_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","Fütanga ngü la, fü Esawu ayia aje ngü la, gü ba, “Wö ni tima Yakobo eyi, de ah nü, ah za würüse agba wü loko ani agbü Padanarama. Angü ah le de Yakobo za egba ganzi kpara de. Yakobo le ngü la kpah eyi. Ngü la areke kpah eyi te wö ni ake ni ni. Wö ni ku gba kpah eyi fü Me, de ah di de Yakobo, da eto wazi fefe na.” ");
INSERT INTO muh_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Teka ngü la, fü Esawu ayia awu, gü ba, te ah bala la, amba wü wö ni ake ni ni le ngü ka wü wara ni, wü egba ganzi kpara ne, nda-wü de. ");
INSERT INTO muh_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Te di bala, fü Esawu ayia anü kpaka afudu ye, de ïrï ye Ïsïmayile ne, teka aza gara würüse kpala, teka de ngü la reke gbü jia wü wö ni. Fü Ïsïmayile ayia ato ye ye de ïrï ye Malata ne, de Esawu za engu. Malata ta de ebabata wara Esawu. ");
INSERT INTO muh_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Baka te Yakobo ayia tete agba wö ye, gbü Bïrï-Saba, enü agbü Padanarama ne, fü ah anü, anü, ara te kaje. ");
INSERT INTO muh_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Fütanga sïkpï ꞌbasu, fü ah akoro agbü gara sü kpala. Fü ra ayia atï. Yakobo gü ba, “Wayi, te ah bala la, ni ena ara sene.” Fü ah aza mere ngbürükü teme, ayia ao esa nzö ye, atï ara. ");
INSERT INTO muh_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Te engu ngbü era tete, fü ah aroto mere siti ꞌbeꞌbe, te yia kü kpa tikpi, ngbüüü kötö. Gbü roto la, fü ah awu wü *malayïka ka Me, te ewü ngbü enü füh ꞌbeꞌbe la, ekoro da edu. ");
INSERT INTO muh_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Fü Me arü nda-ye tikpi, te adu mö ꞌbeꞌbe la, da emala ngü fü Yakobo, gü ba, “Ma de Me, te ma di de *vüngüte ka wü wö mü, wü Abarayama ake Yïsaka. Ma ena ato züka ngü fü mü, angü tö de te mü era fefeh na ne, te gara, ma ena ato fü yi, de wü kundu mü fütanga mü, teka fü yi angbü gbügbü fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Fü wü kundu mü abï wü jaji, asibi asibi baka zu-tö. Fü ewü ao gba wü gbü nzö wü sü ꞌburu, zalü akoro to kpa fügö, kpa kati, de wü debu-sü ꞌburu. Fü wü kpara awu züka ngü, te ma ena amere fü mü la. Fü wü kpara la akpo angbü eku gba fere, teka de ma to wazi fü ani, kpah baka e te ma to fü yi, de wü kundu mü la. ");
INSERT INTO muh_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ma ena ao jia ra eküte mü, angü siti ngü ena amere mü. Ma ena adi eo jia ra te mü, gbü wü sü te mü ena angbü enü gbügbü na ꞌburu. Fü ra aza mü te gara, adu akoro di kpah gbü sü ka wö mü sene. Ma tï ace mü de. Wü ngü de te ma mala fü mü la, ma ena amere amere ꞌburu.” Dela ngü te Me mala fü Yakobo gbü roto. ");
INSERT INTO muh_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Fü Yakobo ayia azükü gbü roto ka-ye la. Fü cürü angbü emere engu ꞌduwa ba-neh-ene-la. Ah gü ba, “Ata! Dene sü te wüh ekpe akpe, angü Me ladü gbü sü ne fanü fanü. Ni wu ta bala nda-ni de. Sü ne ena adi de gba mere Me, amba ah ena adi de kaje te enü agbü kpï.” ");
INSERT INTO muh_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Te kpï seke tete, kpurutokokpï la, fü Yakobo ayia abiti wü teme, afa, ao nzüüü bala. Fü ah adu aza teme, de te engu o nzö ye fefeh na ne, ao ga füh mene ewü de te engu fa la, ba *cangalï fü Mere Me. Fü ah adu aza mü, atökö füh teme la, gü ba, te gara, te ni ena adu akoro tete na, ni ena awu, gü ba, dene sü te Me gü tamu ye tete fü ni. ");
INSERT INTO muh_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Fü Yakobo ayia agü ïrï sü la, ga Betele, ba e te wüh gü ba, “Gba Mere Me”. ");
INSERT INTO muh_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Fü Yakobo ayia akïna kïna fü Me, gü ba, “Wayi bala, Me, mü mala eyi, gü ba, ‘Ni ena angbü eceka kpï fütanga ra, gbü sü ꞌburu te ma ena angbü endoro gbügbü. Ni ena ato kpah e-mazü fere. Fü ni ato kpah bongo, fü ra adi eto te ra. ");
INSERT INTO muh_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Fütanga wü ngü la, ni ena aza ra, alügü gbü sü ka wü wö ra zözö.’ Te di bala, ma ena angbü egbo nga ïrï mü fï mere badi, angü mü de *vüngüte ka-ra fanü fanü. ");
INSERT INTO muh_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Gbü wü e te mü ngbü eto fere ꞌburu, ma ena adi eza tari-e la, elügü fü mü. Te mü to fere baka e nzükpa la, ma ena aza nda-mü biri, alügü fü mü. Dela kïna te ma kïna fü mü enatikine. Teka ngü la, fü ra aza wü teme, afa baka e dene, teka fü ra angbü efï nga ngü la fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Fütanga ngü la, fü *Yakobo ayia anü, anü teka mere bi wü sïkpï. Fü ah anü akoro gbü tö ka Padanarama, ");
INSERT INTO muh_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","kpa füh du-kpa-ngu te di ede Arana, te di mba ce edere sü gbü gü. Bi wü kambiliki ta ladü, te ewü ra kötö gbü wü da-sü bata, ede du-kpa-ngu la. Angü dela ta du-kpa-ngu, de te wü nü ka wü kpara ka Arana ngbü enzö ngu ꞌburu gbügbü na sela. ");
INSERT INTO muh_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wüh ngbü ta eni mö du-kpa-ngu la de mere siti teme, angü wü nü ka gü ena adoto jijia na, asiti. Fü wü kpara, de te ewü ngbü eceka kpï fütanga wü nü ka-wü la, adi ekoro ebiti te-wü ꞌburu feke, teka fü ewü adi ewara mere siti teme engu la emö du-kpa-ngu la asidi. Fü ewü adu ato ngu fü wü nü ka-wü. Te wü nü nzö ngu eyi la, fü ewü adu kpah, awara teme la, alügü te nga ye, ani emö du-kpa-ngu la, angü biri kpara tï awara teme engu la kpikpi ye ne nda de. ");
INSERT INTO muh_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Te Yakobo koro tete kpa füh du-kpa-ngu la, fü engu amala ngü fü wü kpara, te ewü ngbü ecï wü nü ka-wü la, gü ba, “Wü di enga ni ni deyï, ïrï sü ka-wü ne, neh baye?” Fü ewü alügü ngü, gü ba, “Ïrï sü ka-ani ne de Arana.” ");
INSERT INTO muh_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakobo gü ba, “Te di bala ne, wüh wu Labana ye Nayora ne kpo?” Wüh gü ba, “Ani wu engu kpo.” ");
INSERT INTO muh_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","9","Fü Yakobo ayia angbü de tadu. Fü ah amala ngü, gü ba, “Engu ladü mbi?” Wüh gü ba, “Engu ladü mbi. Gara e tete na ꞌburu ma.” Fü Yakobo aceka kpï, awu mere bi wü kambiliki la, te ewü ra ngbü kötö ede du-kpa-ngu la. Fü ah ayia ayi-ta wü kpara la, gü ba, “Si-ngü de te wüh biti wü kambiliki ne tete sene, etü ra ne, neh ene? Te wüh ena ato ngu fü ewü, fü ewü anzö, fü ewü adu alügü ewü, teka fü ewü adu azü e la, ah mere baye?” Wü kpara la gü ba, “Ani ngbü la ecï nga wü bu ani, angü wüh ena akoro ꞌburu feke, teka fü ani awara mere teme de emö du-kpa-ngu la.” Te Yakobo ngbü la bü emala ngü la fü ewü bala, wüh te eceka de, gara jaji würüse te ekoro de wü kambiliki ka-ye. Fü wü kpara la amala ngü fü Yakobo, gü ba, “Ye ceka la jaji würüse te ngbü ekoro la, ah de mbarase ka Labana. Ïïrï na de Rayele. Ah ngbü ekoro de wü kambiliki ka wö ye, angü ah ngbü eceka kpï fütanga ewü me-ye.” ");
INSERT INTO muh_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","12","Te Yakobo wu, gü ba, dela müka ni, te ngbü ekoro de wü kambiliki ka loko ni ne, fü engu ayia amala ngü fü Rayele, gü ba, “Angü ni de enga akara ye, de ïrï ye Rebeka ne.” Fü Yakobo ayia atï te Rayele, afaka engu. Fü ah angbü eku gba tete ꞌduwa ba-neh-ene-la. Fü Yakobo ayia kürrrü, anü awara teme emö du-kpa-ngu la, teka de wü kambiliki ka loko ni la nzö ngu. Fü Rayele ayia amü de woro, adu kpa ekötï, amala nga ngü la fü wö ye, gü ba, “Gara jaji komoko koro eyi, de ïrï ye Yakobo, gü ba, ni de enga enga ni ye.” ");
INSERT INTO muh_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Te Labana je ngü la, gü ba, loko ni koro eyi, fü engu ayia de woro, anü amaka Yakobo, atï tete, afaka engu, adu de engu kpa ekötï. Fü Yakobo ayia atï te nga-ngü de te engu koro di ne, amala ꞌburu fü loko ye. ");
INSERT INTO muh_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Fü Labana ayia amala ngü fü Yakobo, gü ba, “Ye zu de loko ni, te ye koro guvu ni.” Fü Yakobo ayia angbü gba loko ye sela teka fe biringbö. ");
INSERT INTO muh_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Fütanga fe biringbö la, fü Labana awu, gü ba, Yakobo de kpeke kpara, te ngbü emere tima mbi mbi mbi. Fü Labana amala ngü fü Yakobo, gü ba, “Yakobo deyï, angü tima, de te ye ngbü emere fü ni sene ne, ngbü ele ta-ngü te ni ꞌduwa ba-neh-ene-la. Te di eyi bala ne, ni ele ato e fü ye da tima la. Ni wu ngbürü kpo, gü ba, ye zu de loko ni ne, amba kpara tï amere tima bü kükürü bala de. Te di bala, ah le de ye mala nga mene e, te ye ngbü ele, de ni to fü ye, da tima te ye ngbü emere fü ni ne.” ");
INSERT INTO muh_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labana, mü ta de wü di mü, wü jaji würüse ꞌbasu. Ïrï gina de Leya, ïrï jaji engu nda de Rayele. ");
INSERT INTO muh_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Jia Leya ka-ye ta mba fi fi fi bane. Gbüra Rayele reke nda-ye areke ngüra ngüra bala. ");
INSERT INTO muh_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo ngbü ta ele Rayele ka-ye nda cu efa sü. Baka te Labana mala ngü fefe, gü ba, “E te ni ena ato fü ye da tima neh ene?” ne, fü Yakobo ayia amala ngü fü Labana, gü ba, “Loko ni, ni ngbü ele de ye to ye ye Rayele ne fü ni, wara ni tete. Ni ena amere tima fü ye teka wü re lorozi.” ");
INSERT INTO muh_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Labana gü ba, “Ah de züka ngü, te ni ena ato ye ni fü ye, angü ni le ato ye ni fü ganzi kpara nda-ni de. Te di bala, ye ngbü engbü gba ni sene, de ye mere tima la.” ");
INSERT INTO muh_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Fü Yakobo ayia angbü gba Labana sela, da emere tima la teka wü re lorozi. Wü re de lorozi la, ga gbü jia Yakobo nda kpo de, angü engu le ta Rayele cu fa sü. ");
INSERT INTO muh_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Te wü re de lorozi la nza tete, fü Yakobo amala ngü fü Labana, gü ba dene, “Loko ni deyï, ye to wara ni eto, de ni ngbü ake di. Angü tima te ye to fü ni ne nza eyi.” ");
INSERT INTO muh_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Fü Labana ayia ale ngü la. Fü engu ayia amere mere siti karama, aï mere bi wü kpara, de wüh koro gbü karama la. ");
INSERT INTO muh_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Te ra tï tete, gbü sïkpï ka karama la, fü Labana ayia amere mani, aza gina ye ye de Leya ne, anü de engu, ato fü Yakobo da Rayele. Amba Yakobo, mü wu bala nda-mü de. Fü Yakobo ayia angbü ake Leya. ");
INSERT INTO muh_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Fü Labana ayia ato gara labï ka-ye, jaji würüse, de ïrï ye Zerïfa fü Leya, da ah di ele ta-ngü tete.) ");
INSERT INTO muh_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Te kpï seke tete, Yakobo ga, ni ceka kpï bane de, gbo! te Leya! Ah de Rayele nda de! Fü maguma Yakobo ayia anzu ꞌduwa ba-neh-ene-la. Fü ah anü amaka Labana, amala ngü fefe, gü ba dene, “Ye mere de ni de bane neh ene ngü ne? Ye mere mani fü ni bala teka ne? Ni mere ta tima teka wü re de lorozi ne, nda-ni teka Rayele. Ni mere ta tima la teka Leya?” ");
INSERT INTO muh_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Fü Labana alügü ngü fü Yakobo, gü ba, “Ni ena aza jaji, ato fü komoko, ace gina, ao neh mbi mbi baye baye? Dela gele ka-ani nda de. ");
INSERT INTO muh_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ah ba ngü de, te ye le eyi la, de ye cï nga karama ka Leya, te ena anza feke. Angü wüh ena amere karama la teka mere bi sïkpï ba e lorozi. Te karama la nza eyi la, fü ni adu aza Rayele, ato kpah fü ye, wara ye tete. Fü ye adu kpah amere gara tima fü ni teka wü re lorozi.” ");
INSERT INTO muh_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Fü Yakobo ale ngü la. Te karama ka Leya nza tete, fü Labana adu kpah aza Rayele, ato engu fü Yakobo, wara ka tete. ");
INSERT INTO muh_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Fü Labana ayia kpah ato gara labï ka-ye, jaji würüse, de ïrï ye Bïla ne, fü Rayele, de ah di ele ta-ngü tete.) ");
INSERT INTO muh_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Fü Yakobo ayia kpah, angbü ake Rayele. Fü Yakobo ale Rayele nda tïne ꞌduwa, afa Leya ka. Fü Yakobo adu kpah amere tima teka Rayele, teka wü re lorozi. ");
INSERT INTO muh_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Fütanga ngü la, fü Yakobo adu aza wü wara ye la, angbü de ewü. Engu ngbü ta ele Rayele efa Leya di ka. Te Me wu, gü ba, Yakobo le ta Leya mbi mbi de ne, fü Me ato wazi fü Leya de ah di ebï ye. Fü Rayele angbü nda-ye bala, ah bï ye nda de. ");
INSERT INTO muh_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Fü Leya ayia abï gina enga ye, jaji komoko. Fü ah amala ngü, gü ba, “Me wu cïnga ni eyi, fü engu ayia ato wazi fü ni, abï ye dene. Angü watï ni ena adu ale ni, teka ye de te ni bï fefe na ne.” Fü ah ayia agü ïrï mbarase la Rübena teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Fütanga gina ye la, fü Leya abï kpah gara ye, jaji komoko. Fü ah amala ngü, gü ba, “Me wu eyi, gü ba, watï ni le ni de, fü engu ayia ato gara ye komoko, fü ni dene.” Fü ah ayia agü ïrï mbarase la Sïmïyona, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Fütanga engu la, fü Leya adu kpah abï gara ye komoko. Fü ah amala ngü, gü ba, “Watï ni ena adu tïne, ale ni, angü ni bï wü jaji komoko fefe na eyi bata dene.” Fü ah agü ïrï mbarase la *Levi teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Fü Leya adu kpah abï gara ye komoko. Ah gü ba, “Ni gbo nga ïrï Me fa sü, angü engu to gara ye komoko kpah eyi fü ni.” Fü ah ayia agü ïrï mbarase la *Yuda teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Baka te Rayele wu, gü ba, ni bï ye de ne, fü engu adu angbü ekpü tïba ye de Leya ne tïne efa sü. Fü Rayele ayia amala ngü fü Yakobo, gü ba, “Watï ni deyï, ye to ye eto fü ni. Te ah bala de la, ni ena akpi ka cïnga.” ");
INSERT INTO muh_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Fü maguma Yakobo ayia anzu eküte Rayele. Engu gü ba, “Ho! Ni ena ato ye fü ye, ne mbi mbi baye baye, te ni di de Me kpah de ne? Ah ka-ye de ngü ka Me, te le, ga, ye mere e abï ye de ne.” ");
INSERT INTO muh_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rayele gü ba, “Te ah bala, ah le de ye za labï ka-ni, de ïrï ye Bïla ne, de ye ngbü ake di, teka de ah bï wü ye, fü ni aga ewü cu me-ni, ba wü di enga ni.” Fü Yakobo ayia ale ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Fü Rayele aza labï ka-ye la, ato fü Yakobo würüse tete. Fü Yakobo ayia angbü ake Bïla. ");
INSERT INTO muh_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Fü Bïla ayia abï ye komoko fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Fü Rayele ayia amala ngü, gü ba, “Gba ka-ni, te ni ku fü Me ne, Me je eyi. Engu mere ngü, de te ni ngbü endaꞌba te-ni di fefe, ne eyi. Fü engu ayia ato ye komoko fü ni ne.” Fü ah agü ïrï mbarase la Dana, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Fütanga gina ngü la, fü Bïla adu kpah abï gara ye komoko fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Fü Rayele amala ngü, gü ba, “Ni ngbü ta eo siti maguma eküte enga ni ni, teka te ni bï ye de ne. Amba tïtïne labï ka-ni, Bïla, bï wü ye kpah eyi, fü ni adi ega ewü fü watï ni.” Fü ah ayia agü ïrï mbarase la Nafatalï, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Te Leya wu ngü de te Rayele mere la, fü ah afï, gü ba, “Dela züka ngü. Ni ena amere kpah bala, angü ni du bï gara ye nda-ni tïne de.” Fü engu adu aza labï ka-ye de ïrï ye Zerïfa ne, ato kpah fü watï ye. ");
INSERT INTO muh_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Fü Zerïfa ayia abï ye komoko fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Fü Leya ayia agü ïrï mbarase la Gada, baka e te wüh gü ba, “Me ngbü de ra zözö.” ");
INSERT INTO muh_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Fütanga engu dela, fü labï ka Leya adu kpah abï gara jaji komoko fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya gü ba, “Ni ngbü de mere tadu emaguma ni. Angü wü bu ni ena amala ꞌburu, gü ba, ni tïne eyi gbü mere tadu.” Fü ah agü ïrï mbarase la Asera, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Te kpïrï zü koro tete, fü gina mbarase ka Leya de ïrï ye Rübena ne, ayia anü kpa gbü gü. Fü engu anü amaka gara rïnga kpala, ah de rïnga te di baka cagbürara. Fü Rübena ayia aza rïnga la, akoro di, ato fü ni ye. Te Rayele wu rïnga ne tete, fü engu ayia amala ngü fü Leya, gü ba, “Rïnga de te Rübena koro di fü ye ne, ye to kpah nda-ni.” ");
INSERT INTO muh_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya gü ba, “Ape! Ye gbene komoko esaka ni kpah eyi. Watï ni du le ni tïne de, teka ngü ka-ye. Ye le dene kpah agbene rïnga ka-ni?” Fü Rayele amala ngü fü Leya, gü ba, “Te ye le eyi teka ato rïnga ka-ye la fü ni la, ni ena ale, teka de watï ni nü ra enatikine gbü biti ne, kpaka ye.” Fü Leya ayia aza rïnga la, ato fü Rayele. ");
INSERT INTO muh_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Etamurago la, fü Yakobo ayia kpa gbü yï ka-ye la, edu kpa ekötï. Fü Leya ayia anü amaka watï ye kpa te kaje la, amala ngü fefe na, gü ba, “Watï ni deyï, enatikine ye ena ago ara gbü nga ni, angü Rayele le kpah eyi bala, angü rïnga ka-ni, de te enga ni maka kpa gbü gü ne, ni to kpah eyi fefe.” Fü wü Yakobo ayia adu ake Leya, ayia ara tïne gbü biti la kpakaka na kpala. ");
INSERT INTO muh_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Fü Leya ayia aku gba fü Me, de ah to gara ye fü ni. Fü Me ayia aje gba ka Leya. Fü ah ato wazi fefe na. Fü Leya ayia abï kpah gara mbarase, jaji komoko. Fü wü di enga Leya akoro ꞌburuve, ꞌburu wü jaji komoko. ");
INSERT INTO muh_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya gü ba “Ngü te ni mere, ta te ni za labï ka-ni, to fü watï ni ne, reke gbü jia Me eyi. Fü Me ayia ato züka ngü fü ni ne, teka ngü la.” Fü ah ayia agü ïrï mbarase ka-ye la Yïsakara, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Fütanga engu dela, fü Leya adu kpah abï gara ye komoko, fü Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Fü ah amala ngü, gü ba, “Me to züka takpa eyi fü ni. Akpo enatikine, anü kpa engagira nü, watï ni ena angbü egbo nga ïrï ni, angü ni bï bi wü jaji komoko fefe na eyi ꞌburu maꞌdiya dene.” Fü ah ayia agü ïrï mbarase ka-ye la Zebulona, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Fütanga engu la, fü Leya adu kpah abï gara mbarase, tïne jaji würüse. Fü engu agü ïïrï na Dina. ");
INSERT INTO muh_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Rayele, mü ngbü ta fï eku gba fü Me, teka de ah to ye fü ni. Fü Me ayia afï nga Rayele, aje gba kaka-na la. Fü Me ayia ato wazi fü Rayele. ");
INSERT INTO muh_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","Fü Rayele ayia abï ye komoko. Fü ah amala ngü, gü ba, “Ah de züka ngü. Me za lümü gbü jia ni eyi. Ni ena aku gba fü Me, de ah to kpah gara jaji komoko fü ni.” Fü ah ayia agü ïrï mbarase ka-ye la *Yüsefa, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Fütanga ngü te Rayele bï Yüsefa tete, fü Yakobo ayia afï nga ngü, gü ba, “Tïtïne tima de te ni mere teka wü re nzükpa de füh ye bala, teka wü wara ni de ꞌbasu ne, ah nza eyi. Te di bala, ni le eyi aza ewü, adu de ewü kpa gba ani.” Fü ah ayia amala ngü fü Labana, gü ba, “Wügiri ni deyï, ni yia eyi elügü nga ni, adu agba ani. Ye ce wü wara ni, de wü jaji ka-ni, teka de ni go de ewü agba ani, angü ye wu bü kpo, gü ba, tima, ta te ye to fü ni ne, ni mere nza eyi. Te di bala, lakï tï eyi dene, teka fü ni aza wü wara ni, de wü di ni, ago di agba ani.” ");
INSERT INTO muh_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Fü Labana alügü ngu fefe, gü ba, “Enga ni, ye mere e ace ni bala de. Tima ka-ye reke fü ni fa sü, angü ngü la, ni gïrï cu agïrï de kuwa, gü ba, Me to wazi fü ni de bane ne, teka ngü ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Te di bala ne, ah reke fa sü te ye ena angbü la fï bü sene, da emere tima fü ni. De ye mala ngü mene wü e, te ye ngbü ele de ni to fü ye da tima la.” ");
INSERT INTO muh_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","30","Yakobo gü ba, “Ye mala zu ngü! Angü Me to wazi fü ye teka ngü ka-ni fanü. Ye wu kpah bü kpo, gü ba, ni mere tima eyi fü ye reke fa sü. Wü nü ka-ye sibi tïne kpah eyi fa sü, angü ta te ni koro la de ne, wü nü ka-ye sibi bala nda-wü de. Amba tïtïne dene, ni eyi de mere bi wü jaji esaka ni. Te ni ena angbü fï bü emere tima fü ye kükürü bala la, ni ena ato fü wü jaji ka-ni neh ene e ne?” ");
INSERT INTO muh_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Labana gü ba, “Ah mbi. Te ah bala la, mene e te ye ngbü ele, de ni to fü ye, teka tima la, ah de neh ene?” Yakobo gü ba, “Enga ngü mba ladü, te ni ngbü ele de ye mere fü ni. Te ye mere ngü engu la eyi fü ni la, fü ni adu angbü emere tima, da eceka kpï fütanga wü nü ka-ye, baka e ta te enga gina ne. ");
INSERT INTO muh_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ngü te ni ngbü ele de ye mere fü ni ne, ah ba e dene. Te wü nü ka-ye la te ebï wü ye la, de ye di eto gara wü di enga nü ka-ye la fü ni. Te ah di de wü di enga meme la, de ye to mene ewü te ewü ena adi de tere te wü ne. Te ah di de wü kambiliki la, de ye to mene ewü de küte wü ꞌburu bïbïrï bïbïrï ne, teka fü ewü adi ꞌburu nda-ni. Dela ngü de te ni le de ye mere fü ni, teka tima te ni mere fü ye ne. ");
INSERT INTO muh_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Te ani mere bala la, ah ena adi de züka ngü. Ni tï afiti ye gbü ngü la de, angü te ye koro maka mene wü meme te tere di te wü ma, anga enga kambiliki de küte wü bïbïrï de la, ah le de ye wu, gü ba, ni zi ewü eyi azi.” ");
INSERT INTO muh_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labana gü ba, “Ah mbi. Ngü la ngbü ba e te ye mala la.” ");
INSERT INTO muh_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Fü Labana afï nga gara mani. Fü ah ayia kere de woro, anü kpa te sü te wü nü kaka ngbü ezü e tete ne. Fü ah ayia aye süka wü meme ka-ye, akö ewü de tere te wü ne ꞌburu. Fü ah ayia amere kpah bala teka wü kambiliki, akö ewü de bïbïrï ne kpah ꞌburu. Fü engu akö wü nü de te engu fe ewü la, ato ewü fü wü di ye, wü jaji komoko. ");
INSERT INTO muh_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Fü ah amala ngü fü ewü, de wüh nü de wü nü la nengete, angü ni le de wü nü la bï küte ewü de wü bu wü ne tïne de. Angü te wüh bï küte wü la sene la, ah ena adi ꞌburu nda Yakobo. Fü wü jaji ka Labana ayia akö wü nü la, anü de ewü teka wü sïkpï bata, teka de süka ewü ngbü nengete. Fü Yakobo angbü nda-ye fï bü eceka kpï fütanga du wü nü la sela. ");
INSERT INTO muh_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Te Yakobo wu mani de te Labana mere la, fü engu ayia afï nga gara mani, te fa nda Labana la ka. Fü ah ayia anü kpa gbü gü, ade wü yi rü. Fü engu aza wü rü la, asoko ko ewü asidi, ace wü gara, de ah ngbü laꞌbu laꞌbu, teka de wü nü la di eceka. ");
INSERT INTO muh_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Fü Yakobo ayia akö wü rü la, anü de ewü, ao mari, ede sü te wü meme ka Labana ngbü ekoro enzö ngu tete na, angü wü meme la ngbü elüwa sela. ");
INSERT INTO muh_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Angü, te wüh ngbü elüwa bala, da eceka tere wü rü la, wüh ena angbü ebï wü ye ka-wü ꞌburu de tere te wü baka e la. ");
INSERT INTO muh_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Fü Yakobo adu akö wü kambiliki ka-ye, ao ewü mari ede meme ka Labana, te ewü di ꞌburu nde bïbïrï ne, teka wü kambiliki la di ebï wü di enga wü kpah ꞌburu bïbïrï. Fü Yakobo adu amaka mere bi wü meme, de wü kambiliki, teka ngü la. Fü engu akö wü nü ka-ye la, ao kpikpi ye, teka wüh ena angbü endoro de nda Labana. ");
INSERT INTO muh_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Fü Yakobo angbü emere ngü la kpah fï bü bala. Te Yakobo wu mene wü meme, te ewü zege azege la, fü engu adi eza wü rü de tere te wü la, eo kpa ede ngu la, teka de wü meme la di ewu. ");
INSERT INTO muh_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Te ah de mene wü meme, te kürü akürü la, ah o wü rü la kpala nda de. Teka ngü la, fü wü di enga meme, te ewü di kpekpeke, de wazi ewü ne, angbü ꞌburu nda Yakobo. Amba mene ewü te wazi ewü di ma ne, ꞌburu nda Labana. ");
INSERT INTO muh_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Teka ngü la, fü wü nü ka Yakobo azu, afa tïne cu sü. Fü Yakobo akoro tïne kpeke kpara, de mere bi wü e esaka ye. Wü e la, ah de wü kambiliki, wü meme, kpah de wü gara wü e, ba wü kamele, wü dongï, abe kpah te wü labï. ");
INSERT INTO muh_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","2","Fütanga ngü la, fü *Yakobo ayia awu kpo, gü ba, ngü ka-ni du reke gbü jia wügiri ni, Labana ne, baka ta te enga gina ne, nda tïne de. Fü Yakobo adu kpah aje ngü te wü jaji ka Labana ngbü emala, gü ba, “Wü mere bi wü nü, de wü e ꞌburu te di esaka Yakobo ne, ah ꞌburu de wü e ka wö ani. Angü wö ani du ce wü e la esaka Yakobo bala, neh teka ne? Ani wu eyi, gü ba, Yakobo ngbü fï bü efiti wö ani, da ekö wü e kaka la.” ");
INSERT INTO muh_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Baka te Yakobo ngbü efï nga ngü la bala, fü Me ayia akoro amala ngü fü Yakobo, gbü roto, gü ba “De-mü Yakobo, ma ele de mü yia eyia, tïtïne, mü lügü nga mü, mü du kpa gba wö mü, agbü tö ka wü *Kanana. Ma ena adi ake mü.” ");
INSERT INTO muh_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Te ngü la mere te-ye bala, fü Yakobo ayia aï wü wara ye de ꞌbasu ne, Rayele ake Leya, de wüh koro kpaka ni, gbü sü te ni ngbü eceka kpï fütanga wü nü ka-ni tete na. ");
INSERT INTO muh_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Fü ah amala ngü fü wü wara ye la, gü ba, “Ma wu eyi, gü ba, wö yi le ra, ba e ta te enga gina ne, nda tïne de. Te di eyi bala ne, ah ba ngü kpah de, angü Me, te di de *vüngüte ka wü wüba ne, ladü. Engu ngbü ele ta-ngü te ra ne me-ye. ");
INSERT INTO muh_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yi wu kpah kpo, gü ba, tima de te ma ngbü emere fü wö yi ne, ma ngbü emere cu de wazi ra ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Fü wö yi angbü emere mani de ra, adu angbü emala ngü fere ꞌbasu ꞌbasu bala? Fü ah angbü kpah efüfü ngü ka wü e, de te engu mala nganga, gü ba, ‘Ni ena ato fere ne,’ fï bü afüfü. Ngü ma! Me ka-ye ladü! Amba züka ngü te Me tïrï engu, ah mere siti ngü de ra de. ");
INSERT INTO muh_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Angü wö yi mala eyi, gü ba dene, ‘Ni ena ato mene wü di enga wü meme de tere wü ne, ꞌburu fere.’ Fü Me ato wazi fü wü meme, fü ewü angbü ebï wü di enga wü kpah ꞌburu de tere te wü. Te wö yi wu bala, fü ah adu afü ngü la, gü ba, ‘Ni ena adi eto fere mene wü di enga meme de küte ewü lambe lambe.’ Baka te engu fü ngü la bala, fü wü meme adu angbü ebï wü di enga wü kpah ꞌburu de küte ewü lambe lambe. ");
INSERT INTO muh_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dela si-ngü te Me za mere bi wü meme ka wö yi la, to ewü ꞌburu fere ne. ");
INSERT INTO muh_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ta gbü gara biti, gbü lakï te wü meme ngbü elüwa tete, fü ra ayia aroto roto. Fü ra awu wü meme, te ewü ngbü elüwa. Wü moko meme la, wüh ꞌburu ewü de tere te wü. ");
INSERT INTO muh_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Fü Me amala ngü fere gbü roto la, gü ba, ");
INSERT INTO muh_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Ma ceka eceka! Wü moko meme ꞌburu, de te ewü ngbü elüwa la, wüh ka-wü ꞌburu de tere te wü. Wü mene la ena azu wü di enga wü kpah ꞌburu de tere te wü. Dela ngü te ni, Me, mere me-ni. Kükürü de, angü ni wu mani de te Labana ngbü emere de ra la eyi.’ ");
INSERT INTO muh_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Gbü roto la, fü Me amala kpah gara ngü fere, gü ba, ‘De-ra Yakobo, ni de Me, ta te ni sere te-ni fere agbü Betele, gbü sü te ma za teme, fü ra afa *cangalï, fü ra adu kpah akïna kïna fü ni, Me, gü ba, “Ma ena adi ecu ngü ni, Me, fï mere badi.” Te di bala, ah le de ma yia eyia, de ma ce gba Labana, fü ra adu agbü sü ka-a, kpa gbü Kanana.’ Me mala ta ngü fere gbü roto la bala.” Dela ngü ta te Yakobo mala fü wü wara ye, teka wü roto ka-ye la. ");
INSERT INTO muh_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Fü wü Rayele ake Leya ayia alügü ngü, gü ba, “Ah mbi, dela ka-ye züka ngü. Ani go ka-ani ego agbü Kanana. Teka ne de, angü gara e-nga-kpa kpala, te wö ani ena ato fü ani nda ma. ");
INSERT INTO muh_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ani ka-ani gbü jia wö ni tïne eyi ba ganzi kpara la. Ah se ani ka-ye nda eyi asidi, kö jiase ka-ye, züfa nza eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Mere bi wü nü, bete wü mene wü e, te Me za esaka wö ani, to fü ye ne, wü e la tïne kpah eyi ꞌburu nda-ani, de wü di enga ani. Te di bala, ani yia eyia, de ani go agbü Kanana, ba e te Me mala fü ye la.” ");
INSERT INTO muh_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","De te Yakobo je ngü la bala, fü engu ayia kürrrü, angbü ereke te-ye gbü zi. Fü ah ayia abiti wü e ka-ye ꞌburu, te engu ena ago di agbü Kanana ne. Fü ah adu kpah, abiti wü yiti, de wü kambiliki ka-ye, te engu maka de sela ne, atima ewü ꞌburu kpa engagira nü. Fü ah ao wü wara ye, de wü di ye ꞌburu füh wü kamele, de wüh nü di. ");
INSERT INTO muh_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","20","Wü Yakobo ngbü reke te-wü ꞌburu esalakumu, angü Labana ena atïrï ani. Fü ewü angbü ecï nga sïkpï te Labana ena anü tete agbü gü, awete kala wü kambiliki ka-ye. Te Labana nü sü tete kpala, fü wü Yakobo ayia akpe ka-wü sidi nganga na la. Fü Rayele ayia kpah amere mani, azi faranda ka wö ye, te wüh mï gbü se ne, akpe di mini. Wü Yakobo de wü wara ye fiti ta Labana baka e dela. ");
INSERT INTO muh_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Fü ewü ayia akolo sü, anü akö ngu de ïrï ye Efürata ne. Fü ewü anü akoro kpa gbü gara sü, te di kpa eze da, to anga Gïlada. Fü ewü ayia ade gugu, angbü sela. ");
INSERT INTO muh_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Fütanga sïkpï ꞌbasu, fü Labana adu aje nga wü Yakobo, gü ba, “Wüh kpe eyi!” ");
INSERT INTO muh_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Fü Labana ayia akö wü di enga ni ye, anü afa nga wü Yakobo. Fü ewü afa nga Yakobo baaala, fü ewü anü amaka ewü gbü sïkpï lorozi. ");
INSERT INTO muh_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Amba Me mala ta ngü fü Labana gbü roto, gbü biti engu de te kpï seke la, gü ba, “Labana deyï, te ye fa nga Yakobo, maka eyi la, ye mere e awü nga ake di de, angü engu de vüngüte ka-ni. Te ye mere engu esiti la, ye ena awu ngü.” ");
INSERT INTO muh_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Baka te wü Labana nü maka wü Yakobo tete agbü Gïlada, fü ewü anü ade nda-wü gugu kpah mba gbamari ede nda wü Yakobo sela. ");
INSERT INTO muh_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Te wü Labana maka wü Yakobo tete, fü ah ayia amala ngü fü Yakobo, gü ba, “Ye mere mani de ni bala, neh kü teka ne? Ye kö wü di ni, kpe de ewü bü baka wü kpara, te wüh zoro ewü gbü gü, neh teka ne? Dela ngbürü zu ngü fanü fanü na? ");
INSERT INTO muh_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ye ce ta emala nga ye fü ni de, neh teka ne? Wü zi te-wü bü zïrrrï, akpe, anü sü, neh teka ne? Te ni ena awu ta kpo, gü ba, wü yia eyi, ego ago la, de bane ni ena amere mere siti karama, fü wü kpara, teka fü wü ago gbü züka ngü. ");
INSERT INTO muh_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ye ceka la, baka te wü yia kpe ka-wü bü bala, ni sü de, gba ngüsü emaguma wü kundu ni, de wü di ni ne. De bala ne töndö ngü ne? ");
INSERT INTO muh_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Te ni ena aroto ta gbü biti ne de la, de bane ni ena amere ye ta ꞌduwa asiti, teka ngü ka-ye la. Amba Me, te di de *vüngüte ka wö ye ne, koro, mala ngü fü ni, gü ba, ‘Te ni maka ye la, ni mere e awü nga ake ye de.’ ");
INSERT INTO muh_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ah mbi! Baka te ye yia ka-ye nda eyi, edu kpa gba wü wö ye, teka gümü ewü ne, anga si-ngü de te ye zi faranda ka-ni tïne tete ne, ah de neh ene ya?” ");
INSERT INTO muh_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Fü Yakobo ayia alügü ngü fefe na, gü ba, “Ngü te ni ce da emala ngü ni fü ye tete ne, kükürü de, angü ni kpe cürü, gü ba, ye ena aza wü di ye, atïrï ewü de wazi. Dela si-ngü de te ni mala nga ani tete na fü ye de ne. ");
INSERT INTO muh_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amba teka faranda ka-ye la, de-ni Yakobo, ni zi faranda ka-ye nda-ni de. Te wüh maka faranda ka-ye la ngbürü eyi esaka biri kpara esüka wü kpara ka-ni sene la, de wüh za kpara la, wüh mörö engu asidi. Te di bala ne, ye gïrï kpï egïrï kpo kpo kpo kpah gbü jia wü kpara ka-ye la, gbü wü gugu ka-ani ne biri biri ꞌburu. Mene e te ye ena amaka, te di de e ka-ye la, de ye za ꞌduwa aza, ye koro di gbü jia wü di enga ni ani, de te ye koro de ewü ne.” Amba Yakobo, mü wu ta, gü ba, Rayele zi faranda la me-ye ne, nda-mü de. ");
INSERT INTO muh_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Fü Labana ayia akpo angbü egïrï faranda ka-ye ne. Fü ah arï kpa gbü gugu ka Yakobo, agïrï kpï kpala ma. Fü ah adu kpah, arï agïrï kpï gbü gugu ka Leya, de nda wü labï ꞌbasu ne, wü Bïla ake Zerïfa kpah bi ma. Ah maka faranda ka-ye nda kpah de. Fü ah anü kpah agïrï agbü gugu ka Rayele. ");
INSERT INTO muh_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Amba Rayele za ta faranda engu la, wo ka-ye esa gara mere bongo. Fü ah ayia angbü ka-ye gaa fefeh na, da ecï nga wö ye. Te wö ye na rï kpa gbü nganga na la, fü engu ayia agü mandï fü wö ye ciki da ye. Fü ah amala ngü fü wö ye, gü ba, “Wö ni deyï, maguma ye mere e anzu eküte ni de. Si-ngü te ni yia tikpi, agu mandï fü ye de ne, angü ni ngbü ei ku.” Fü Labana agïrï kpï sela, ayiri ayiri, ah maka faranda ka-ye nda kpah de. ");
INSERT INTO muh_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Fü maguma Yakobo ayia anzu eküte Labana. Fü ah akpo angbü ewü nga ake di, gü ba, “Angü de bala neh ene ngü ne? Mene *siti ngü de te ni mere fü ye ne, ah mbi mbi de ne ngü ne? Te ye fa nga ani, koro di zalü de kpakine, ba e te ani di tïne wü mürü zi ne? ");
INSERT INTO muh_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Baka te ye gïrï kpï gbü wü e ka-ani sene ꞌburu ne, ye maka biri e ka-ye eyi gbügbü na? Te ye maka e engu eyi la, de ye za eza, ye koro di, ye o engagira wü di enga ni ye, de wü nda-ni wü kpara sene, teka de wüh ye süka ngü de esüka ani ne kere. ");
INSERT INTO muh_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","39","De-ni Yakobo, ni mere ta tima fü ye, mbü di ambü teka wü re teke biri. Fü wü nü ka-ye ayia ta asibi afa sü ne, ꞌburu teka ngü ka-ni. Wü tima ta te ye to fü ni, teka wü nü ka-ye ne, ni mere eyi ꞌburu mbi. Siti ngü te ni mere gbü tima la, ah de neh ene? Ni mörö ta süka gara wü nü ka-ye, zü eyi? Baka te siti wü nü ngbü ta ezoro süka wü nü ka-ye ne, ni ngbü ta eza nda-ni nü, eo dada na. Te mürü zi koro, zi süka wü nü ka-ye la, fü ni adi kpah eza nda-ni eo dada na. Ni mere ta dela siti ngü? ");
INSERT INTO muh_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ni mbü ta ka tima ka-ye la cu fa sü! Ra ngbü ta ecucuru ni, fü zü angbü kpah emere ni gbü biti! Ra gbü jia ni gbü biti kpah ma, teka tima la! ");
INSERT INTO muh_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Bi wü re ta te ni mere gba ye, baka wü re teke biri ne (20), fï bü gbü wü cïnga bala! Ni mere ta tima fü ye, teka wü wara ni de ꞌbasu la, teka wü re nzükpa de füh ye bala (14). Fütanga ngü la, fü ni adu kpah amere tima fü ye, teka ngü ka wü nü, teka wü re maꞌdiya. Fü ye angbü ta kpah fï bü da efiti ni, enda nganga, da efüfü ri ye fü ni ꞌbasu ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Amba gbü mere bi wü ngü la ꞌburu, Me ngbü ta fï bü ake ni, angü engu de *vüngüte ka-ni, kpah baka wü wö ni, Abarayama ake Yïsaka ne. Te Me ena di ta ake ni de la, de bane ye liki ni eyi gügü, de kpa ni kükürü. Me wu cïnga de te ye to ta eküte ni ne eyi ꞌburu nde. Engu wu züka tima, ta te ni mere fü ye, ne kpah eyi. Dela si-ngü de te Me koro kpaka ye tete esikine gbü biti, gbü roto, amala ngü fü ye kpekpeke ne.” ");
INSERT INTO muh_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Fü Labana ayia alügü ngü fü Yakobo, gü ba, “Enga ni, ani mere e awü nga de, angü ni ena amere tïne dene neh baye ya? Angü wü jaji würüse ꞌbasu, de esaka ye la ꞌburu wü di ni, abe kpah te wü jaji, de te ewü bï ewü fü ye la, wüh kpah ꞌburu de wü kundu ni ne. Wü nü bete wü gara wü e de esaka ye la, ka-wü kpah ꞌburu wü e ka-ni. Gara ngü te ni ena amere nda ma! Angü wazi ni, te ni ena aza wü e la, adu di kpah ma! ");
INSERT INTO muh_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Te di bala, ah le de ani mörö kambiliki emörö esüka ani, fü ani azü ake ye, teka areke ngü de ezengba ani ne di. Ani za kpah mere teme de ani rükü, o, de ah gü tamu kïna de esüka ani ne fü wü kpara.” ");
INSERT INTO muh_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Fü Yakobo ayia ale ngü engu la. Fü ah aza mere ngbürükü teme, arükü, ao, teka de ani di efï nga ngü, de te ani reke esüka ani la tete. ");
INSERT INTO muh_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Fü ah adu amala ngü fü wü kpara ka-ye, de wüh biti wü teme, wüh fa, wüh o gbü sü biringbö nzüüü. Fü ewü angbü ezü e de wü kpara ka Labana la, ede wü teme bala la. ");
INSERT INTO muh_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Fü Yakobo ayia agü ïrï mere teme, te wüh rükü la, gü ba, Galede. Fü Labana ayia agü ïrï wü teme te wüh fa biti la, Yegara-Saduta, ");
INSERT INTO muh_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","gü ba, “Mere bi teme te ani fa ne, ena agü tamu ngü fü wü kpara, gü ba, ani reke ngü ezengba ani eyi.” ");
INSERT INTO muh_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Fü Labana amala gara ngü fü Yakobo, gü ba dene, “Me ladü, te ena adi ewu mene wü ngü de te ye ena angbü emere eta kuru jia ni ne. Te ye ngbü emere wü di ni la esiti, anga te ye nü za kpah gara wü würüse ka-ye la, ye wu, gü ba, Me ladü te ngbü eceka ye de wü ngü la.” Fü ah adu kpah, agü ïrï sü la Mizipa, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Fü Labana adu kpah amala gara ngü fü Yakobo, gü ba, “Dene ngü te ani ena areke ezengba ani enatikine. Angü wü teme te wüh fa ewü dene ne, bete mere teme, te wüh rükü o dene, ");
INSERT INTO muh_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","wüh ena aye zengba tö ka-mü ake nda-ra, fï mere badi. Mü tï aguru sü, anü atï de gü gbü nzö ra, gbü nda-ra sü de. Ma tï kpah aguru sü, anü atï de gü gbü nzö mü, gbü nda-mü sü de. ");
INSERT INTO muh_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Me ladü, ah ena aceka ngü ka-ani la me-ye. Angü engu de vüngüte ka wü wö nih, wü Abarayama ake Nayora.” Fü Yakobo ayia akïna kïna kpah baka e la, te ïrï Me te di de vüngüte ka wö ye na, Yïsaka ne. ");
INSERT INTO muh_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Fü Yakobo ayia aza nü, awa amörö fü Me. Fü engu ayia aï wü kpara ka-ye. Fü ewü ayia akoro azü e la de wü kpara ka Labana gbü sü la. Fü ewü ara sela zalü akoro kpurutokokpï. ");
INSERT INTO muh_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Gügü kpurutokokpï la, fü Labana ayia afaka wü Leya ake Rayele, de wü kundu ye, ayia asü ngüsü emaguma ewü ꞌburu. Fü ah ayia alügü nga ye, adu kpa gba ye. ");
INSERT INTO muh_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Fütanga wü ngü la, fü wü *Yakobo ayia de wü kpara ka-ye, atï te kaje, edu agbü *Kanana. Fütanga bi sïkpï, fü ewü anü akoro agbü tö ka wü Kanana. Fü ewü akoro ede gara ngu kpala. Fü ewü ayia ade gugu ka-wü, angbü sela. Yakobo gü ba, ni ceka kpï bane de, gbangbara! te mere bi wü *malayïka ka Me, te ewü di ka-wü kpah sela. ");
INSERT INTO muh_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Te Yakobo wu wü malayïka la, fü ah angbü de mere tadu, gü ba, “Me tima wü malayïka ka-ye la, teka ale ta-ngü te ani.” Fü ah ayia agü ïrï sü engu la Manayïma, teka ngü ka wü malayïka la. ");
INSERT INTO muh_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Fü wü Yakobo ayia angbü la mba takü gbü Manayïma sela. Fü Yakobo ayia afï nga enga ni ye, Esawu, de tane, ta te sü gü, teka mani, ta te ni mere fefe. Fü engu ayia atima süka wü kpara ka-ye kpa engagira nü, kpaka Esawu, ede da de ïrï ye Seyira, gbü tö ka Edomo ne, ");
INSERT INTO muh_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","gü ba dene, “Te wü nü maka Esawu la, de wü mala fefe, gü ba, ‘Mere kpara deyï, de-ni Yakobo, enga ni ye, ni tima ngü fü ye me-ni. Mere bi wü re te nye sü ne, ni ngbü ta la fï kpa gba loko ani, Labana. ");
INSERT INTO muh_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tïtïne ni du koro eyi dene, de mere bi wü kpara, bete wü nü fütanga ni. Ni tima ngü ne fü ye, teka de ye ce wü *siti ngü, ta te ni mere fü ye ne, ꞌburu asidi. Fü ye aza ni ba enga ni ye.’ ” ");
INSERT INTO muh_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Fü wü kpara ka Yakobo ayia anü amaka Esawu. Fü ewü atï te ngari Yakobo la, amala ꞌburu fefe. Fü ewü adu amala ngü la ꞌburu fü Yakobo, gü ba, “Ani nü maka Esawu eyi. Fü ani amala ngü la ꞌburu fefe. Te engu je ngü la, fü ah ayia angbü ereke te-ye teka akoro kpakine. Engu kpala eyi te kaje enü kpaka ye, de mere bi wü komoko gbü nga ye, baka e kama bala (400).” ");
INSERT INTO muh_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Te Yakobo je ngü la tete bala, fü mamaguma ayia agürü. Fü ah aza wü kpara de gbü nga ye ne, kpah de wü nü ꞌburu, aye süka ewü ꞌbasu, aza gara ewü, atima kpa engagira nü, aza gara ewü, ao kpa sidi. ");
INSERT INTO muh_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ah ngbü efï, gü ba, te Esawu koro teka amörö ani la, de engu mörö gara ewü, de gara ewü la küwa. ");
INSERT INTO muh_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Fü Yakobo ayia aku gba fü Me, gü ba “Wayi bala Me, mü de *vüngüte ka wü wüba, Abarayama ake Yïsaka. Mü je gba ka-ra. Mere kpara, mü je gba ka-ra, angü mü mala ta cu me-mü, teka de ma ce gba Labana, ma du kpa gbü tö te wüh bï ra gbügbü, kpaka wü mürü ra. Fü mü amala kpah, gü ba, ‘Ni ena angbü fï tundu ake ra,’ ne. ");
INSERT INTO muh_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Te di bala, Me, ma de siti kpara. Ma tï ta amaka züka ngü, baka te mü mere fere, ato mere bi wü e enatikine fere, ne de. Kükürü de, angü baka ta te ma koro kö Yürüdene ne, e ta te di esaka ra bü duu ngbangba te ma ngbü endoro di. Tïtïne dene, ma ngbü tïne eyi edu de mere bi wü kpara, abe kpah te wü nü, fütanga ra, baka e te ma ye süka ewü eyi de ꞌbasu ne. ");
INSERT INTO muh_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ako Me, ma koro engagira mü dene, ayi-ta mü, teka de mü le-ta ngü te ra, de ma küwa esaka enga wüna. Cücürü na ngbü eyi emere ra amere, angü engu ena akoro, amörö a anza, de wü jaji, de wü ni ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Wayi, Me, mü tata engu eküte ra atata. Mü fï la nga kïna, ta te mü kïna tüngü ra, gü ba, ‘Ni ena angbü fï ake ra ne, fü ni ato wazi fere, teka de wü kundu ra bï wü ye, sibi asibi baka zu-tö, te ewü tï atanga de,’ ne.” Dela ta gba te Yakobo ku fü Me, kpa gbü Manayïma kpala, teka cürü enga ni ye. ");
INSERT INTO muh_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Fü Yakobo ayia ara ciki era ngu sela. Fü ah ayia afï nga gara ngü, gü ba, ah le de ni fe mba gara wü nü ka-ni, teka atima ewü engagira nü fü Esawu, baka takpa fefe na. Wü nü ta te engu tima ewü ne, wüh bane. ");
INSERT INTO muh_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Wü ca meme kama ꞌbasu (200), wü moko meme teke biri, wü ca kambiliki kama ꞌbasu (200), wü moko kambiliki teke biri, ");
INSERT INTO muh_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","wü yï kamele, bete wü di enga wü teke biri de füh ye nzükpa, wü ca yiti teke ꞌbasu, wü moko yiti nzükpa, wü ca dongï teke biri, wü moko dongï nzükpa. ");
INSERT INTO muh_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Fü Yakobo adu aza wü nü la, aye süka ewü, te nga nguwa wü nü la. Fü ah aza wü labï ka-ye, ao gbü nguwa wü nü la biri biri ꞌburu, atima ewü kpa engagira nü. Fü ah amala ngü fü wü labï la, de wüh di enü biri biri de zengba wü. Wüh mere e anü ꞌburu te sü biringbö de. ");
INSERT INTO muh_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Fü Yakobo adu amala gara ngü fü mene labï, te tï engagira nü de gina wü nü la, gü ba, “Te Esawu maka ye, fü ah ayi-ta ye, gü ba, ‘Ye neh de kpara ka da? Ye ngbü enü neh kaye? Mürü mere bi wü nü ne, neh da?’ la, ");
INSERT INTO muh_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","de ye lügü ngü fefe na, gü ba dene, ‘Mere kpara deyï, ni de labï ka Yakobo, enga ni ye. Wü mere bi wü nü ne ꞌburu kaka, te engu tima ewü fü ye. Ah to ewü eyi fü ye ba takpa, angü ye de mere enga ni ni. Amba Yakobo engu ladü kpa sidi kpala ekoro.’ ” ");
INSERT INTO muh_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Fü Yakobo amala ngü la fü wü labï la, te nga wü biri biri kpah ꞌburu bala, gü ba, “Dela ngü te wü ena amala fefe na, te wü maka te-wü la. ");
INSERT INTO muh_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Wü mala ngü fefe, gü ba, ‘De-ni, Yakobo, labï ka-ye, ni ladü sidi kpala ekoro.’ ” Yakobo to ta mere bi wü züka wü e de bala, teka de sü reke mba eküte Esawu, de engu boro wü siti ngü, ta te ni mere engu di ne. ");
INSERT INTO muh_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Te Yakobo tima mere bi wü nü la tete bala fü Esawu, fü Yakobo ayia ara ka-ye ciki kpa gbü Manayïma sela. ");
INSERT INTO muh_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Fü Yakobo ayia gbü biti la, aza wü wara ye de bala ne, bete wü di ye de nzükpa de füh ye biri ne, atima ewü kpa eta ngu. ");
INSERT INTO muh_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Fü ah adu kpah aza wü gara e ka-ye ꞌburu, atima kpa eta ngu. ");
INSERT INTO muh_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Fü Yakobo ace te-ye, angbü nda-ye ciki sela kpikpi ye, ah kö ngu nda de. Te Yakobo ngbü ta tete kpala, fü gara komoko ayia akoro, atï te Yakobo, akama de gü. Fü ewü akama te-wü, da efüfü te-wü fï bü bala, zalü te kpï kpo ngbü eseke tete. ");
INSERT INTO muh_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Te komoko la wu tete, gü ba, ni tï agbo Yakobo kötö nda-ni de ne, fü engu ayia amï nzö-ku Yakobo kpööö, afu ka! ");
INSERT INTO muh_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Fü Yakobo azoro komoko la kpah fï, gö gö gö! Fü komoko la amala ngü fü Yakobo, gü ba, “Ye ce kpa te ni! Kpï seke eyi!” Yakobo gü ba, “Te ye le de ni ce kpa te ye la, de ye sü ngüsü emaguma ni. Ni tï ace kpa te ye de. ꞌDuwa te ye ena asü ngüsü ye emaguma ni feke, fü ni adu ace kpa te ye, fü ye anü.” ");
INSERT INTO muh_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Komoko la gü ba, “Ïrï ye neh da?” Yakobo gü ba, “Ïrï ni de Yakobo.” ");
INSERT INTO muh_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Komoko la gü ba, “Ni fü ïrï ye tïne eyi, *Yïsarayele. Kükürü de, angü ye de kpeke kpara, ye mere wü kpara füh kotö ne, fa eyi. Ye mere ni, Me, fa kpah eyi!” ");
INSERT INTO muh_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakobo gü ba, “Mere kpara deyï, ye gü la kpah nda-ye ïrï ye fü ni.” Fü komoko la amala ngü, gü ba, “Ye le aje ïrï ni neh teka ne? Ni tï agü ïrï ni fü ye nda-ni de, angü wü kpara tï aje ïrï ni nda-wü de.” Fü kpara la adu tïne, asü ngüsü emaguma Yakobo. Fü ah ayia anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Fü Yakobo adu awu, gü ba, amba kpara te ani kama te-ani ake di ne, ah ka-ye de Me. Fü ah ayia agü ïrï sü la tïne Penuwele, angü ni wu Me eyi de cu jia ni, amba ni kpi nda-ni de. ");
INSERT INTO muh_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Fü kpï ayia aseke. Fü Yakobo ayia ace Penuwele sela, anü sü. Ah ngbü enü tïne jigbi jigbi, teka nzö-ku ye te fu la. ");
INSERT INTO muh_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Dela si-ngü gbü gele ka wü di enga Yïsarayele, te ewü le azü nzö-ku de gbü ku nü di de ne, angü komoko la mï ta nzö-ku Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kpurutokokpï la, fü *Yakobo ayia akö ngu, anü amaka wü wara ye, de wü di ye kpa eta ngu kpala. Fü ewü ale kaje, angbü enü tïne gbü sü biringbö. Fü Yakobo aceka kpï bane de, gbangbara! te wü Esawu, te ewü ngbü ekoro, de mere bi wü komoko fütanga ye, baka e kama bala (400). Te engu wu bala, fü cürü akpo angbü emere engu. Fü ah amala ngü fü wü di ye, de wüh ngbü la de wü ni ewü sela feke. ");
INSERT INTO muh_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Fü ah adu amala ngü fü wü Bïla ake Zerïfa, de wü di enga wü, de wüh tï nda-wü fütanga ni. De Leya tï nda-ye, de wü di enga ye fütanga ewü. Fü wü Rayele adu atï nda-ye duu sidi ake *Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Fü Yakobo atï nda-ye engagira nü, fü ewü anü maka te-wü ake Esawu. Fü Yakobo ayia atï abuka gbüra ye kötö du lorozi, da efüwa te-ye fü Esawu ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Fü Esawu ayia amü de mere woro, akpe atï te enga ni ye, afaka, akpo angbü eku gba eküküte. Fü Yakobo ayia kpah de gba. ");
INSERT INTO muh_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Fü Esawu aceka kpï, awu wü würüse, de wü jaji. Fü ah adu ayi-ta Yakobo, gü ba dene, “Mere bi wü kpara, te ewü ngbü efa nga ye, wü würüse de wü jaji ne, wüh de wü da?” Yakobo gü ba, “Mere kpara deyï, dela wü wara ni, bete wü jaji ka-ni, te Me to fü ni.” ");
INSERT INTO muh_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Fü wü Bïla ake Zerïfa ayia akoro, de wü jaji ka-wü, agü mandï fü Esawu, kpah da efüwa te-wü fefe na. ");
INSERT INTO muh_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Fü wü Leya akoro kpah de nda-ye wü di enga ye, amere kpah bala. Fü wü Rayele adu akoro nda-ye ake Yüsefa tïne sidi, amere kpah bala. ");
INSERT INTO muh_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Fü Esawu ayi-ta Yakobo, gü ba dene, “Enga ni ni deyï, ani maka te-ani te kaje de wü kpara, de mere bi wü nü esaka wü. Ngü engu la neh baye?” Fü Yakobo alügü ngü fefe, gü ba, “Ni tima wü nü la kü me-ni fü ye ba takpa, teka de maguma ye gu eküte ni, teka fü ye adu ale ni.” ");
INSERT INTO muh_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esawu gü ba, “Enga ni ni deyï, ni tï aza wü nü la de, angü mere bi wü nü kpah ladü esaka ni. Wü nda-ani la ti eyi. Wü nda-ye la ngbü fü ye.” ");
INSERT INTO muh_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Fü Yakobo adu kpah andaꞌba te-ye fefe, gü ba, “Mere kpara, te ye le ni eyi la, de ye za mba takpa la eza. Baka te ni wu ye enatikine ne, ni ngbü eyi de mere siti tadu emaguma ni, baka e te ni wu Me la. Teka ne de, angü ni wu kpo, gü ba, ye le ni eyi de maguma ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Te di bala ne, ni ngbü endaꞌba te-ni fü ye, de ye za mba wü nü, de te ni to fü ye la, angü Me le ta-ngü te ni de wü e la me-ye.” Fü Yakobo angbü eso Esawu kpah fï bü bala, zalü fü Esawu ayia ale ngü ka wü nü la. ");
INSERT INTO muh_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Fü Esawu amala ngü fü enga ni ye, gü ba, “Te ah bala la, de ani nü enü kpa ekötï. Angü ni ena agï nga wü.” ");
INSERT INTO muh_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","14","Fü Yakobo alügü ngü fefe, gü ba, “Mere kpara deyï, ah mbi. Amba ye nü nda-ye enü kpa engagira nü. Ani ena afa nga ye ferrre, angü wazi wü jürü wü jaji, de wü di enga nü ne, tï te ewü ena anü kere kere de. Te di bala, ani ena anü nda-ani ferrre, angü wü nü ena akpi. Ni ena afa nga ye zalü akoro di agba ye, agbü Seyira la.” ");
INSERT INTO muh_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esawu gü ba dene, “Te ah bala la, ni ce gara wü komoko ka-ani fü ye, de wü nü de ewü.” Fü Yakobo alügü ngü fefe na, gü ba, “Ye nü enü de wü komoko ka-ye la ꞌburu engagira nü, angü gara e te ena emere ani nda ma. Ani ena afa nga wü.” ");
INSERT INTO muh_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Fü Esawu ayia ale ngü la. Fü ah ayia anü sü kpah ꞌduwa gbü ra engu la, edu agbü Seyira. ");
INSERT INTO muh_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Fü Yakobo adu ayia nda-ye, de wü wara ye, de wü jaji ka-ye sidi. Fü ewü anü akoro kpa gbü gara sü kpala, te wüh ngbü eï, gü ba, Sukota. Fü ah ayia ade wü gugu, angbü ka-ye takü gbü sü la. Fü ewü angbü sela mba cüküꞌdaye. ");
INSERT INTO muh_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","20","Fü ewü ayia ace Sukota, akö Yürüdene kpa eta ngu, anü akoro gbü gara ꞌbaranga de ïrï ye Sekeme, te di gbü tö ka wü *Kanana kpala. Fü ah ayia ao kötï to kpa gbü gü, kpa ede ꞌbaranga la. Fü sü la areke te Yakobo ꞌduwa ba-neh-ene-la. Fü ah ayia anü kpaka wü di enga Amüra, wü kpara ka Sekeme, ase sü la esaka ewü de mere bi jiase. Fü Yakobo ayia areke sü sela, teka angbü egbo nga ïrï Mere Me gbügbü na. Fü ah ayia agü ïrï sü la Ele-Loyi-Yïsarayele, baka e te wüh gü ba, Me de *vüngüte ka wü *Yïsarayele. Dela ngü ta te wü Yakobo yia ce Padanarama, ayia ago angbü ka-wü gbü tö ka-wü, agbü Kanana ne. ");
INSERT INTO muh_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Fü wü *Yakobo ayia angbü gbü Sekeme sela, teka mere bi wü re. Fü wü jaji kaka ayia agegere sela. Gbü gara sïkpï, fü ye Yakobo, jaji würüse de ïrï ye Dina ne, ayia anü aceka wü bu ye jaji würüse gbü sü la, wü egba Sekeme. ");
INSERT INTO muh_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Gara enga Sekeme ta la kpala, jaji komoko de ïrï ye kpah Sekeme, te di ta ye miri ka sü de sela, gbü nguwa wü Ivo. Fü Sekeme ayia awu Dina. Fü Dina ayia asu gbü jijia na efa sü. Fü engu ayia atï te Dina, agbene engu, angbü ake di de wazi. ");
INSERT INTO muh_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Fü gümü Dina adu angbü emere engu tïne ꞌduwa ba-neh-ene-la. Fü ah ayia afiti Dina. Fü Dina ago angbü agba ka na kpala, angü ah ale Dina cu fa sü. ");
INSERT INTO muh_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","5","Fü Yakobo ayia aje, gü ba, Sekeme gbene ye ni, Dina ne eyi. Fü engu ayia anga ka-ye tïïï, ah mala ngü ꞌduwa kpo de. Angü engu ngbü ta ecï nga wü di ye, te ewü ngbü ta endoro, eceka kpï fütanga wü kambiliki agbü gü ne. Fü Sekeme ayia anü kpaka wö ye, te di de miri ka sü la, amala ngü fefe na, gü ba, “Wö ni deyï, jaji würüse de ïrï ye Dina ne su gbü jia ni fa sü. Ni ngbü ele de ye nü kpaka wö ye na, ayi-tata fü ni, teka de ni se engu.” ");
INSERT INTO muh_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Fü wö ye Sekeme ayia anü akoro kpaka Yakobo, teka ayi-ta Dina fü ye ye. ");
INSERT INTO muh_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Te wüh ngbü emala ngü engu la tete, fü wü di Yakobo ayia adu akoro amaka ewü. Fü ewü ayia aje, gü ba, angü Sekeme gbene enga ni ani, Dina, eyi. Fü ngü la ayia ake te ewü ꞌduwa ba-neh-ene-la. Fü ewü amala ngü, gü ba, “De bala ne töndö ngü ne? Sekeme to lümü gbü nzö ani, de wö ani ꞌburu. Dela eyi siti soko eküte ani, wü di enga *Yïsarayele!” ");
INSERT INTO muh_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Fü wö ye Sekeme angbü efüwa te-ye fü wü Yakobo fï bü bala, gü ba, “Yakobo deyï, ye ni le ase mbarase ka-ye, Dina ne, wara ye tete na, angü ah ngbü ele engu cu efa sü. Te di bala la, ah le de wü le ngü la ale, ");
INSERT INTO muh_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","angü te ani za te-ani esüka ani de wü la, ah ena adi de züka ngü. Te wü le de ani za egba wü la, ani ena ace kpah egba ani, fü wü kpara gbü nga wü angbü eza. Fü za-te de esüka ani de bala, areke ngü mürü ka-ani ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wü ena angbü gbü sü ka-ani, gbü Sekeme sene gbü gu sü. Fü ani ato wü sü de sela kpah ꞌburu fü wü. Fü wü angbü endondoro de wü nü ka-wü gbügbü na, ba e te wü ngbü ele. Fü wü angbü kpah emaka mere bi wü züka wü ngü gbü sü ka-ani ne.” ");
INSERT INTO muh_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Fü Sekeme ayia amala ngü fü wügiri ye, Yakobo, gü ba, “Ni ngbü ele tangbase ka-wü ne efa sü. Wü le fü ni, de ni za te-ani ake di. Ni ena ato wü e te wü ngbü ele ne nde ꞌburu fü wü. ");
INSERT INTO muh_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Te wü ngbü ele di kpah bü mere bi jiase la, ngü ma. Ni ena ato ka-wü ato, angü ni ngbü ele Dina efa sü.” ");
INSERT INTO muh_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Fü ngü la asiti ka-ye ta eküte wü di Yakobo cu afa sü, angü Sekeme to mere lümü eyi eküte enga ni ani. Fü ewü ayia afï nga gara mani, afiti Sekeme di, ");
INSERT INTO muh_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","gü ba, “Ani tï ato enga ni ani fü ye nda-ani de, angü wü tï esa *basa nda-wü de. Te ani le ngü la bala la, ah ena ato mere lümü fü nguwa ani. ");
INSERT INTO muh_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Amba, te wü le eyi de ani di eza te-ani esüka ani la, de wü komoko gbü nguwa wü ꞌburu di etï esa basa, baka e te di gbü gele ka-ani ne. ");
INSERT INTO muh_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Te wü le eyi amere ngü la bala la, amba ani tï eyi ato wü egba ani, fü wü adi eza. Fü wü di ani, wü jaji komoko, adi kpah eza egba wü. Te ani mere eyi bala la, fü ani adu angbü tïne de wü gbü mürü. ");
INSERT INTO muh_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Te wü le de la, ngü ma. Ani ena aza tangbase ka-ani, fü ani anü sü ka-ani.” Amba wüh mala ngü la bala nda-wü de mani. ");
INSERT INTO muh_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Fü ngü ka-ewü la ayia areke eküte wü Sekeme ake wö ye ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","20","Fü Sekeme ayia kpah ꞌduwa bü kere, amere ngü la, ba e te ewü mala la, teka ne de, angü ah le ta Dina cu fa sü. Fü wü Sekeme ayia anü kpa te sü te wü kpara ngbü ebiti te-wü tete, ayia amala ngü fü wü kpara gbü nguwa wü ꞌburu, de wüh koro, teka aro mö gbü ngü engu la. Fü wü cögbörö wü kpara ka-ewü akoro, anga angbü tïïï, da eje ngü gömö Sekeme. Wüh ngbü eo lümü tete, angü engu ta de mere kpara esüka ewü. ");
INSERT INTO muh_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Fü Sekeme amala ngü fü wü kpara la, gü ba, “Wü di enga ni ni deyï, wü kpara ne, wüh de züka wü kpara. Ah le de ani le fü ewü, teka de wüh ngbü gbü sü ka-ani sene. Fü ewü angbü kpah endoro de wü nü ka-wü, ba e te ewü ngbü ele. Angü tö ka-ani memere. Ah tï eyi aza ani de ewü ꞌburu. Te ani ena angbü kpah eza te-ani ezengba ani de ewü la, ah ena areke ta kpah afa sü. ");
INSERT INTO muh_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Enga ngü te ni ena amala fütanga ngü la fü wü, ah dene, te wü kpara la ngbü ele de ani mere, teka fü ani angbü tïne de ewü, ba wü kpara biringbö, gbü mürü ne. Ah de ngü teka fü wü komoko ka-ani ꞌburu adi etï esa *basa. ");
INSERT INTO muh_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Te di eyi bala ne, ah le de ani mere ngü engu la, kpah baka e te ewü mala la, teka fü wü mere bi wü nü ka-ewü, de wü mere bi wü e ka-ewü la, adu angbü tïne kpah ꞌburu ba nda-ani.” ");
INSERT INTO muh_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Fü wü kpara ka sü la ayia ꞌburu, ale ngü la. Fü wü komoko gbü sü la ayia ꞌburu, anü atï esa basa gbü ra biringbö. ");
INSERT INTO muh_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","26","Fütanga sïkpï ꞌbasu, o wüh di la fï bü etökö wangü te ka te wü, fü gara wü di Yakobo ꞌbasu de ïrï wü Sïmïyona ake *Levi ayia akö wü dü ka-wü, de wü mere maguruma ka-wü, ayia azi te-wü, anü atï de gü gbü nzö wü kpara la gbü ïrï-to. Fü ewü amörö wü Sekeme ake wö ye, bete wü komoko gbü sü la le ꞌburu. Da ewü te ewü ena amere gü nda ma, angü wüh ꞌburu de ka te wü. Fü ewü aza enga ni wü, Dina, agba wü Sekeme la, adu de engu kpa ekötï. ");
INSERT INTO muh_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Fü wü gara wü di Yakobo ayia anü kpah kpa gbü ꞌbaranga la, atï te wü e ka wü kpara te ewü mörö ewü la, akö le ꞌburu, teka lümü te Sekeme to gbü nzö enga ni ewü ne. Kpara te ena atïrï kaje, atata ewü nda ma, angü wü komoko gbü sü la kpi nza eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","29","Fü ewü ayia akö wü nü ka-ewü, ba wü yiti, wü kambiliki bete wü dongï, abe kpah te wü würüse, de wü jaji, de wü e ka-ewü nde ꞌburu, ayia anü sü di. ");
INSERT INTO muh_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Te Yakobo je ngü la tete, fü ngü la ayia asiti tete ꞌduwa ba-neh-ene-la. Fü ah amala ngü fü wü Sïmïyona ake Levi, gü ba dene, “De-wü deyï, wü mere de bane neh ene ngü ne? Wü za mere siti lïya, koro di eyi gbü nzö ani dene. Wü kpara ka *Kanana de wü kpara ka Pereze ena akpü ani tïne ꞌduwa sürü sürü. Wü ceka la eceka! Baka te ani be kpah de ne, te wü kpara ka wü sü la ena adünda te-wü, atï de gü gbü nzö ani la, ani ena amere neh mbi mbi baye?” ");
INSERT INTO muh_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Wü Sïmïyona ake Levi gü ba, “Wö ani deyï, ye ngbü efï ta de ani mere baye? Ye ceka mere siti lümü te jaji komoko la to gbü nzö enga ni ani ne! Ani ena ace ngü la fefe na ta bü bala, neh baye baye?” ");
INSERT INTO muh_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Fütanga ngü la, fü Me ayia agü tamu ye fü *Yakobo agbü Sekeme kpala. Fü ah amala ngü fefe, gü ba, “Yakobo deyï, ma le de mü ce sü ne, fü mü ayia ago angbü agbü Betele, gbü sü ta te ma sere te-ra fü mü, o mü ngbü ekpe esaka enga ni mü, Esawu ne. Te mü koro kpala, ah le de mü reke sü, teka fü mü angbü egbo nga ïrï ra tete na.” ");
INSERT INTO muh_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","3","Te Yakobo je ngü la tete bala, fü engu adu amala ngü la fü wü wara ye, de wü di ye, be kpah te wü kpara gbü nga ye, gü ba, “Ani le eyi ayia ago angbü agbü Betele. Fü ni areke sü teka angbü egbo nga ïrï Mere Me gbügbü na kpala, angü Me de kpara te ngbü ele ta-ngü te ni me-ye, kü gügü, o ni ngbü ta ekpe cürü enga ni ni tete, zalü akoro di dene. Engu ngbü kpah eceka kpï fütanga ni, gbü wü sü te ni ngbü endoro tete ne ꞌburu. Te di bala, ah le de wü kö wü e ka wü faranda, te ewü ngbü emere fü wü me ka wü kundu wü ne, de wü sötö ꞌburu asidi. Te wü mere eyi bala, de wü du wü zürü se wü di enga me la eküte wü ꞌburu asidi. Fü wü adu ato to bongo, areke te-wü, teka anü agbü Betele, angbü egbo nga ïrï Mere Me kpala.” ");
INSERT INTO muh_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Te wü kpara ka Yakobo je ngü la bala, fü ewü ayia akö wü faranda ka wü di enga me ka-wü la, ato ꞌburu fü Yakobo. Fü ewü agbigbi kpah wü gara wü e ba di, te ewü to gbü güje wü, ato ꞌburu fü Yakobo. Fü Yakobo ayia ajï mere du kpa esa rü agbü Sekeme la, abu ewü, de wü faranda, ꞌburu gbügbü. Fü ah ayia ani nga ewü gö gö gö! ");
INSERT INTO muh_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Fü wü Yakobo ayia ace Sekeme, akpo angbü enü agbü Betele. Fü Me ato mere cürü guvu wü kpara ka Sekeme, fü ewü ace kaje fü wü Yakobo anü sü ka-wü. Wüh liki nga ewü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Fü wü Yakobo anü, anü akoro kpa gbü Betele, te di ta kpah gbü tö ka wü *Kanana sela. ");
INSERT INTO muh_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Fü Yakobo ayia areke sü, teka angbü egbo nga ïrï Me gbügbü sela. Angü dela ta sü te Me gü tamu ye fefe na tete, o engu ngbü ta ekpe esaka enga ni ye ne. ");
INSERT INTO muh_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Baka te wü Yakobo go ngbü tïne eyi sela, gara würüse de ïrï ye Debora ayia akpi. Ah ta de mürü tima ka Rebeka, ni ye Yakobo. Rebeka koro ta de engu kü gügü agbü Padanarama. Fü ewü ayia ati würüse la esa gara rü gbü Betele sela. Fü ewü agü ïrï rü engu la Alünü-Bakuta, baka te wüh gü ba, “Rü ka cïnga.” ");
INSERT INTO muh_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Baka te Yakobo yia tete agbü Padanarama, du ngbü gbü Betele ne, fü Me adu kpah agü tamu ye fefe na sela toto, ayia ato wazi fefe na kpah baka engu tane. ");
INSERT INTO muh_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","11","Fü Me amala ngü fefe, gü ba, “Yakobo deyï, ma de Me, te ngbü gbü nzö wü e füh kotö ne ꞌburu. Wüh ngbü ta eï mü Yakobo, amba enatikine wüh ena adi eï mü tïne *Yïsarayele. Ma to wazi eyi fü mü, de mü bï wü ye füh kotö, sibi asibi. De wü kundu mü bi wü jaji sibi kpah asibi, teka de nguwa yi ga koro mere bi nguwa wü kpara, de wü angbe cögbörö miri esüka wü. ");
INSERT INTO muh_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tö ta te ma gü ba, ma ena ato fü wü wö mü, wü Abarayama ake Yïsaka ne, ma to kpah eyi fü yi, de wü kundu mü, te wüh ena abï ewü ne.” ");
INSERT INTO muh_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Te Me mala ngü la nza tete bala, fü engu ayia ꞌduwa, anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Fü Yakobo ayia aza mere teme, arükü, ao mbi gbü sü, te Me gü tamu ye tete fefe na la. Fü ah adu kpah aza fï, bete mü, ayia atökö füh teme la, acu ngü Mere Me di. ");
INSERT INTO muh_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Dela si-ngü te Yakobo gü ta ïrï sü engu la tete, ga, Betele, angü Me gü ta tamu ye fefe na gbü sü la eyi du ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Fü wü Yakobo ayia ace Betele, angbü enü agbü Beteleme, o Rayele di ta de bu ye. Baka te ewü di la bü te kaje, enü ne, fü lakï ka Rayele ayia akoro teka ayaka. Fü bu Rayele angbü ekeke ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Te bu Rayele ngbü fï da emere engu bala ne, fü würüse de te ngbü eyaka wü jaji ne, ayia amala ngü fefe na, gü ba, “Ye mere e akpe cürü de, angü ye ena ayaka ye komoko.” Fü Rayele ayia ayaka ye komoko kpah baka ngü la, fü wawazi akpo angbü enza. ");
INSERT INTO muh_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Baka te Rayele yia ekpi tete, fü ah ayia agü ïrï mbarase ka-ye la Benoni, te gü ba, “Mere siti kuru.” Amba Yakobo du gü nda-ye, gü ba, Benzamina, te gü ba, “Mbarase te ni o maguma ni tete.” ");
INSERT INTO muh_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Fü Rayele ayia akpi. Fü ewü ayia ati engu ciki sela, edere kaje te ngbü enü agbü Beteleme ne. ");
INSERT INTO muh_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Fü Yakobo ayia aza mere siti teme, ao füh mbükü Rayele. Fü teme la ayia angbü fï füh mbükü sela. ");
INSERT INTO muh_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Fütanga ngü la, fü Yakobo ayia sela, anü akoro agbü gara sü de ïrï ye Migidale-Edere. Fü engu ayia ade gugu, angbü sela. ");
INSERT INTO muh_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Fütanga ngü la, fü Rübena, te di de gina ye Yakobo ne, ayia anü ara ake Bïla, wara wö ye ne. Fü Yakobo ayia aje ngü la. Fü maguma Yakobo ayia anzu teka ngü la cu afa sü. Wü di Yakobo ta te wüh bï ewü agbü Padanarama ne, wüh ta nzükpa de füh ye biri. Fü ewü ayia akoro ꞌburu nzükpa de füh ye ꞌbasu de wü Benzamina. ");
INSERT INTO muh_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leya bï ta wü di enga ye ꞌburu maꞌdiya. Gina ye Yakobo ta de Rübena. Fütanganga na tïne wü Sïmïyona ake *Levi, *Yuda, Yïsakara, bete Zebulona. ");
INSERT INTO muh_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Dene ïrï wü di enga Rayele, wüh ta ngbee ꞌbasu, wü *Yüsefa ake Benzamina. ");
INSERT INTO muh_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bïla bï ta nda-ye wü ye kpah ngbee ꞌbasu, wü Dana ake Nafatalï. ");
INSERT INTO muh_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zerïfa bï nda-ye wü ye ta kpah ngbee ꞌbasu, wü Gada ake Asera. Dela ꞌburu ïrï wü di Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Fütanga ngü la, fü Yakobo ayia aje ngü, gü ba, wö ni, Yïsaka, gbe tïne eyi fa sü. Fü Yakobo ayia anü akoro kpakaka kpa gbü Mamare, gbü ndama ka Abarayama ta gügü ne. ");
INSERT INTO muh_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Fü Yïsaka ayia akpi. Ah kpi ta gbü gbe ye, o re kaka koro eyi ꞌburu kama biri teke bala (180). Fü wü didi, wü Yakobo ake Esawu, ayia ati engu ciki gbü Mamare sela, gbü gö da ta te wüh ti wü wö ye na, Abarayama, gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Dene si-ngü teka wü di Esawu, de wü kundu ye, te wüh eï ewü, gü ba, wü Edomo ne. ");
INSERT INTO muh_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Wü wara Esawu ta ꞌburu bata. Ewü de ꞌbasu ne ta de wü egba ganzi kpara, te engu za ewü agbü *Kanana. Ïrï gara ta de Ada, ïrï gara nda ta Olibama. ");
INSERT INTO muh_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ïrï ebabata wara Esawu ta de Basemata, te wö ye na di ta de Ïsïmayile, afudu ye Esawu ne. ");
INSERT INTO muh_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Wü wara Esawu la bata mini bï ta ye eyi fefe na. Enga Ada ta de Elifaza. Enga Basemata nda de Rüwele. ");
INSERT INTO muh_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Wü di enga Olibama nda-wü de Yewusu, Yalama, bete Kora. Dela ta ꞌburu ïrï wü di Esawu, te wüh bï agbü Kanana. ");
INSERT INTO muh_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Fütanga wü ngü la, fü Esawu ayia akö wü wara ye, de wü di ye, de wü kpara gbü nga ye, abe kpah te wü nü ka-ye, de wü e ka-ye ꞌburu, ayia ace Kanana, anü sü ka-ye kpa gbü gara sü te di nengete ede wü *Yakobo. ");
INSERT INTO muh_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Kükürü de, angü sü, de ta te ewü ra kötï tete sela ake Yakobo ne, be ta fü ewü, teka wü mere bi wü nü ka-ewü la, nda tïne de. ");
INSERT INTO muh_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Dela si-ngü ta te Esawu yia ce Kanana tete, ago angbü ka-ye kpa füh wü rüvü, kpa te nga nzö kötï ka Seyira, te wüh ngbü kpah eï, gü ba, Edomo ne. ");
INSERT INTO muh_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Dene ïrï wü kundu ye Esawu, te engu di de mere kundu ye nguwa wü kpara ka Edomo ne, te ewü go ngbü kpa füh wü rüvü, te nga nzö kötï ka Seyira ne. ");
INSERT INTO muh_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Enga Ada, de ïrï ye ta Elifaza ne, bï wü ye ta ꞌburu ꞌburuve. Ïrï wü jaji la ta de Temana, Omara, Zefo, Gatama, bete Kenaza. Eꞌbaꞌbasu wara Elifaza de ïrï ye Timina ne, bï nda-ye enga ye ngbee biringbö, de ïrï ye Amaleke. Enga Basemata, de ïrï ye Rüwele ne, bï nda-ye wü di ye bala. Ïrï wü jaji la ta de Nata, Zera, Sama bete Mïza. ");
INSERT INTO muh_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Olibama bï ta nda-ye wü jaji bata. Ïrï wü jaji la ta de Yewusu, Yalama, bete Kora. Olibama ta de ye Ana, ye Zibeyona. ");
INSERT INTO muh_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Dene ïrï wü di Esawu, te ewü du koro cögbörö nga nzö nguwa wü kpara. Gina ye Esawu ta de ïrï ye Elifaza ne, ah ta de wö ye nga nzö nguwa wü kpara lorozi, te ewü ngbü gbü Edomo. Wüh ta de wü Temana, wü Omara, wü Zefo, wü Kenaza, wü Kora, wü Gatama, bete wü Amaleke. Dela ta ꞌburu wü nga nzö nguwa wü kpara de ta te Elifaza bï ewü me-ye. Wüh ngbü ta eï ewü, gü ba, wü Edomo, angü wüh ra ta kötï agbü tö ka Edomo. Elifaza ta de enga Ada, wara Esawu. ");
INSERT INTO muh_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rüwele ta nda-ye de wö ye nguwa wü kpara bala. Wü de wü Nata, wü Zera, wü Sama, bete wü Mïza. Dela ta ꞌburu nga nzö nguwa wü kpara ta te Rüwele bï ewü. Rüwele ta de enga Basemata, wara Esawu. ");
INSERT INTO muh_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Gara wara Esawu, ta de ïrï ye Olibama ne, bï ta nda-ye nguwa wü kpara bata. Wüh ta de wü Yewusu, wü Yalama, bete wü Kora. Dela ta ꞌburu ïrï nguwa wü kpara te Olibama, enga Ana, bï koro di. ");
INSERT INTO muh_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Dela, ꞌburu ïrï wü kundu ye Esawu, te ewü di de nga nzö nguwa wü kpara, te wüh ngbü eï ewü, gü ba, wü Edomo. Wüh ta ꞌburu wü angbe cögbörö wü miri gbü nzö nguwa wü la. ");
INSERT INTO muh_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","22","Seyira ta de mere kundu ye nguwa wü kpara, ta te ewü ngbü gügü gbü Edomo, o wü Esawu de wü kpara gbü nga ye go koro, o kötï kpala la de ne. Seyira ta de kpara gbü nguwa wü Ori. Ah ta de wü di ye ꞌbajena. Ïrï wü jaji la ta de Lotana, Sübala, Zibeyona, Ana, Disono, Ezere, Disana, abe kpah te tangbase ka-ewü, de ïrï ye Timina. Ye Seyira, de ïrï ye Lotana ne, ta de wü di ye ꞌbasu, wü Ori ake Emana. ");
INSERT INTO muh_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ye Seyira, de ïrï ye Sübala ne, ta de wü di ye ꞌburuve. Ïrï wü jaji la ta de Alavana, Manata, Ebala, Sefo bete Onama. ");
INSERT INTO muh_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Gara ye Seyira, de ïrï ye Zibeyona ne, ta de wü di ye ꞌbasu, wü Aya ake Ana. Ana ta de mbarase te nü maka gara ngu, te di wangü, o engu ngbü ta eceka kpï fütanga wü nü ka wö ye kpa gbü gü. ");
INSERT INTO muh_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Mene ye Seyira, de ïrï ye Ana ne, bï ta wü jaji ngbee ꞌbasu. Gara de ye komoko, de ïrï ye Disono, bete jaji würüse de ïrï ye Olibama. ");
INSERT INTO muh_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Mene ye Seyira, de ïrï ye Disono ne, bï ta wü jaji komoko bala, de ïrï wü Emadana, Esebana, Yitarana, bete Kerana. ");
INSERT INTO muh_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Mene ye Seyira, de ïrï ye Ezere ne, bï ta wü jaji komoko bata, de ïrï wü Bilana, Zavana, bete Akana. ");
INSERT INTO muh_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Mene ye Seyira, de ïrï ye Disana ne, bï ta wü jaji komoko ngbee ꞌbasu, de ïrï wü Uca ake Arana. ");
INSERT INTO muh_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Dela ꞌburu ïrï wü kundu ye Seyira, te di ta gbü nguwa wü Ori ne. Wü di Seyira ta de lorozi la, wüh ta de wü miri gbü nga nzö nguwa wü, gbü tö ka Seyira sela. ");
INSERT INTO muh_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Dene ïrï wü angbe cögbörö miri, te ewü ngbü zoro sü gbü nzö nguwa wü kpara ka Edomo ta ꞌburu. Wü kpara ka Edomo la o ta nda-wü mere miri kü gügü, o wü kpara ka *Yïsarayele o nda-wü mere miri la de. ");
INSERT INTO muh_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Gina mere miri ka Edomo ta de Bela, ye Beyora, kpara ka Dinaba. ");
INSERT INTO muh_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Fü Bela ayia akpi. Fü ewü adu kpah afe gara mere miri, ao dada na. Ïïrï ta de Yobaba, ye Zera, kpara ka Büzara. ");
INSERT INTO muh_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Fü Yobaba ayia kpah akpi. Fü ewü adu kpah afe gara mere miri, ao dada na, de ïrï ye Üsama, kpara ka Temana. ");
INSERT INTO muh_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Fü Üsama akoro kpah akpi. Fü ewü adu kpah afe gara mere miri, ao dada na, de ïrï ye Adada, ye Bedada, kpara ka Avïta. Adada sö ta gü ezengba wü de wü nguwa wü kpara ka Mïdïyana, agbü tö ka wü Müwaba. Fü engu ayia afa wü kpara ka Mïdïyana la ka. ");
INSERT INTO muh_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Fü Adada adu kpah akpi. Fü ewü adu kpah aza gara mere miri, ao dada na, de ïrï ye Samala, kpara ka Masareka. ");
INSERT INTO muh_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Fü Samala ayia kpah akpi. Fü ewü aza kpah gara mere miri, ao dada na, de ïrï ye Sawüla, kpara ka Robota. ");
INSERT INTO muh_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Fü Sawüla ayia kpah akpi. Fü ewü adu kpah aza gara mere miri, ao dada na, de ïrï ye Balanana, ye Akabora. ");
INSERT INTO muh_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Fü Balanana ayia kpah akpi. Fü ewü adu kpah aza gara mere miri, ao dada na, de ïrï ye Adara, kpara ka Pawu. Ïrï wara Adara ta de Metabele, enga Matarede te ïrï ni ye na di de Mezaba ne. Dela ïrï wü angbe cögbörö wü miri ta te ewü zoro sü gbü Edomo ne. ");
INSERT INTO muh_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Dene ïrï nguwa wü kpara te Esawu bï ewü. Ah de wü Timina, wü Alava, wü Yetete, ");
INSERT INTO muh_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","wü Olibama, wü Ela, wü Pinona, ");
INSERT INTO muh_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","wü Kenaza, wü Temana, wü Mibizara, ");
INSERT INTO muh_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","wü Magadiyele, de wü Yirama. Dela ꞌburu ïrï nga nzö nguwa wü kpara, te ewü di ta mere nguwa wü kpara gbü Edomo ne. Wüh ꞌburu de wü kpara guvu Esawu, angü engu ta me-ye de gina kpara, gbü nguwa wü kpara ka Edomo. Fü ewü angbü egü ïrï wü sü, te ewü go ngbü gbügbü na ne, te ïrï nguwa ewü la. ");
INSERT INTO muh_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Wü Yakobo ngbü ta ejiji de wü di ye, gbü tö ka wü *Kanana, kpah baka wü kundu wü tane. ");
INSERT INTO muh_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","3","Ambadu ye Yakobo ta ladü de ïrï ye *Yüsefa, te Yakobo ngbü ele ngü kaka, efa nda wü gara wü di enga ni ye la ꞌburu. Angü ah bï engu tïne gbü gbe ye. Te re ka Yüsefa koro tete baka e nzükpa de füh ye lorozi, fü Yakobo ayia aza züka bongo de züka tere te ye, ato fü Yüsefa. Wü gara wü di enga eyï Yüsefa, wü di enga Bïla ake Zerïfa, wüh ngbü ta eceka kpï fütanga wü kambiliki ka wö wü. Fü Yüsefa angbü de ewü tïne ba mbarase fütanga ewü. Fü wü di enga ni ye Yüsefa la angbü emere siti ngü. Fü Yüsefa adu angbü emala nga siti ngü ka wü di enga ni ye la ꞌburu fü wö ye. ");
INSERT INTO muh_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Fü wü di enga ni ye Yüsefa awu, gü ba dene, wö ani le Yüsefa ka-ye fa sü ne. Fü ngü la ayia asiti te ewü afa sü. Fü ewü akpo angbü ekpü Yüsefa ꞌduwa sürü sürü. Wüh le amala züka ngü fefe nda-wü tïne de. ");
INSERT INTO muh_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Ta gbü gara biti biringbö, fü Yüsefa ayia aroto. Fü ah akoro amala nga roto la fü wü di enga ni ye, gü ba dene, “Wü di enga ni ni deyï, ni roto roto gbü biti ne, te ani ngbü ewa ndo. Fü ani adi ezï wü ndo la, da ei ewü baka i-ndo. Fü nda-ni i-ndo ne ayia ae te-ye arü mbiii tikpi. Fü nda-wü i-ndo la akoro ꞌburu, angbü ezuru engagira nda-ni la, baka kpara te ecu ngü mere miri la.” Te wü di enga ni ye na je nga roto kaka-na la bala, fü ngü la ayia asiti te ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Fü ewü akpo emala ngü, gü ba, “Ho! Ye ngbü ele afü te-ye, angbü mere miri gbü nzö ani, fü ani adi nda-ani ꞌburu esa lö ye? Ye ngbü emala te komö ye de bala neh ene ngü ne?” Teka ngü la, fü wü di enga ni ye na adu akpü engu tïne ꞌduwa afa sü, teka ngü te engu mala. Wüh gü ba, “Ah ngbü ecu ngü ye de bala ne, neh teka roto ka-ye la?” ");
INSERT INTO muh_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Fütanga ngü la, fü Yüsefa adu kpah aroto gara roto. Gbü roto la, fü ah awu wü ra ake fe, bete wü küfara nzükpa de füh ye biri, te ewü yia koro ꞌburu engangagira, angbü ecu ngüngü. ");
INSERT INTO muh_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Fü ah adu kpah amala nga roto la fü wö ye, de wü di enga ni ye ꞌburu. Te wö ye na je ngü la bala, fü mamaguma ayia asiti eküte Yüsefa, gü ba, “De-ye deyï, dela bala neh ene roto ne? Ye efï nda-ye, gü ba, ni ena ayia cu me-ni, de wü ni ye, de wü di enga ni ye ꞌburu, acu ngü ye fanü fanü?” ");
INSERT INTO muh_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Fü wü di enga ni ye na ayia ati ngü la fï emaguma wü. Fü wö ye na angbü fï bü da efï ngü la emaguma ye. ");
INSERT INTO muh_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Gbü gara ra, fü wü di enga ni ye Yüsefa ayia agbü sü ka-wü, de ïrï ye Eberone ne, aza wü kambiliki ka wö wü, anü di agbü gara sü de ïrï ye Sekeme. ");
INSERT INTO muh_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Fütanga ngü la, fü Yakobo ayia aï Yüsefa kpaka ye, amala ngü fefe, gü ba dene, “Yüsefa deyï, ni ele atima ye kpaka wü di enga ni ye kpa gbü Sekeme.” Yüsefa gü ba, “Wayi, ni le eyi.” ");
INSERT INTO muh_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakobo gü ba, “Ye nü enü, ye ceka wü di enga ni ye, de ye du, ye mala mene ngü te ngbü emere ewü de kpala, de wü kambiliki ne, fü ni, teka fü ni aje gömö ye.” Fü Yüsefa ayia sela, anü aceka wü di enga ni ye agbü Sekeme. ");
INSERT INTO muh_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Te engu koro tete agbü Sekeme kpala, ah maka wü di enga ni ye de. Fü ah angbü endondoro da egïrï ewü. Fü gara komoko akoro amaka engu kpala, ayi-tata, gü ba dene, “De-ye deyï, ah mere baye te ye ngbü endoro de bane? Ye ngbü egïrï neh ene?” ");
INSERT INTO muh_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yüsefa gü ba dene, “Ni ngbü egïrï wü di enga ni ni. Wüh ngbü de wü kambiliki ka wö ani neh to kaye?” ");
INSERT INTO muh_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Fü komoko la alügü ngü fefe, gü ba dene, “Ni je ngü te ewü ngbü emala, gü ba, ‘Ani le anü agbü Dotana.’ Ah ba e te ewü nü sü eyi kpala la.” Fü Yüsefa ayia kpah bü ꞌduwa ayia, anü afa nga ewü, amaka agbü Dotana kpala. ");
INSERT INTO muh_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","20","Fü wü di enga ni ye Yüsefa ayia aceka kpï, awu engu nengete te ngbü ekoro. Fü ewü akpo angbü emere e, nzürrrü! da emala, gü ba, “Yi ceka la! Mürü roto la kpah te ekoro de kpala. Te ah koro eyi la, ah le de nih mörö engu amörö, aza kökö na, asö agbü diri du-kpa-ngu. Fü nih adu amala fü wö ye na, gü ba dene, ‘Siti nü zoro engu eyi, züfa ꞌburu.’ Fü nih awu la ngü gbü roto kaka-na la!” ");
INSERT INTO muh_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Fü Rübena, te di de gina enga ni ewü ne, ayia aje ngü la. Fü ngü la ayia asiti tete afa sü. Fü ah adu afï nga kaje te ni ena aküwa Yüsefa tete na. ");
INSERT INTO muh_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Fü ah ayia amala ngü fü ewü, gü ba dene, “De-wü deyï, ah tï fü ani amörö engu amörö de, angü engu de enga ni ani. Te ah bala la, ani za bü engu, ani gü agbü diri du-kpa-ngu. Fü engu akpi ka-ye kpala de tete-ye.” Amba Rübena ngbü emala ngü la ka-ye nda de mani, angü fïngangü kaka gü ba, te ani gü engu eyi kpala la, fü ni adu aza engu, alügü kpaka wö ni. ");
INSERT INTO muh_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Te Yüsefa koro tete kpaka ewü la, fü ewü ayia bü riii, atï tete, azoro engu gö! Fü ewü ayia agbi züka bongo kaka-na, de tere te ye la, asidi. ");
INSERT INTO muh_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Fü ewü ayia aza engu, anü di, agü agbü diri du-kpa-ngu, te ngu di ta gbügbü na ma. ");
INSERT INTO muh_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Fü ewü adu angbü ezü kümü ka-wü. Wüh te eceka kpï bane de, gbangbara! te wü Arabï te ewü ngbü ekoro to kpa fügö, agbü Gïlada, de wü e ka-wü, baka wü *rü de züka se wü, de wü gara wü züka wü e ka-wü, te ewü enü di, acïnzï agbü *Ezepeto. Wüh ngbü bï wü e la ta ꞌburu füh wü kamele ka-wü. ");
INSERT INTO muh_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Fü *Yuda, gara enga ni ye Yüsefa ne, ayia awu wü Arabï la. Fü ah amala ngü fü wü di enga ni ye, gü ba dene, “Te ani mörö enga ni ani ne amörö, fü ani acere nga kökö na eküte wö ani la, ani ena amaka gbügbü na neh ene? ");
INSERT INTO muh_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Te ah nda bü fïngangü ka-ni la, ah le de ani nü enü, za engu, acïnzï asidi fü wü kpara te ewü ekoro ne. Fü ani aza jiase ka-ani la. Angü engu de enga ni ani. Te ani mörö engu la, ah ena adi esiti.” Fü ewü ale ngü la te nga wü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Te wü Arabï koro tete kpaka ewü sela, fü ewü ayia kere, anü agbeke Yüsefa kpa gbü du la, adu di, ato fü wü Arabï la. Fü wü Arabï la ayia ato mere bi jiase fü ewü, baka teke biri. Fü ewü aza Yüsefa yo! atafa di agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Fütanga ngü la, fü Rübena adu anü akoro füh du-kpa-ngu la, aceka kpï bane, yïrï! Yüsefa nda ma! Fü ngü la asiti tete ꞌduwa ba-neh-ene-la. Fü ah ayia agbürü bongo te ye, asörö traaa! de mere siti gba. ");
INSERT INTO muh_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Fü ah ayia alügü nga ye, adu kpaka wü di enga ni ye, ayi-ta ewü, gü ba dene, “Anga mbarase agbü du la nda tïne eyi ma! Ni ena amere baye?” Wü di enga ni ye la le ngü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Fütanga ngü la, fü ewü ayia aza meme, amörö. Fü ewü aza bongo ka Yüsefa, ayili gbü ngüte meme la, ");
INSERT INTO muh_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","aza, adu di, agü tatamu fü wö wü, gü ba, “Wö ani deyï, ani maka bongo ne kötö to kpane de ngüte te ye. Ye ceka la bongo engu mbi mbi mbi. Ah ena adi neh bongo ka da? Ah de bongo ka ye ye de?” ");
INSERT INTO muh_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Fü Yakobo ayia awu bongo ka Yüsefa teke. Fü ah atï ꞌduwa de gba, gü ba, “Wuuwu! Ye ra, Yüsefa, e-dene bü bongo ka-mü fanü fanü na? Siti nü zoro mü, sösörö mü eyi luru luru, du züfa mü eyi fere dene na? Ma ena amere baye?” ");
INSERT INTO muh_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Fü ah ayia asösörö bongo te ye ꞌburu ꞌburu. Fü ah adu aza kala bongo ka cïnga, ato te ye. Fü ah aku gba kö ye ye la bala, teka mere bi sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Fütanga mere bi sïkpï la, fü wü didi, wü jaji komoko de wü jaji würüse, ayia akoro ꞌburu kpakaka na, teka agu mamaguma, de engu ce ngü ka cïnga la tïne asidi. Fü Yakobo alügü ngü fü ewü, gü ba dene, “Ni le ngü ka-wü la de. Ni ena aku gba ye ni la bala, zalü te ni ena akpi, ago agbü tö.” Fü wö ye Yüsefa angbü fï bü eku gba kökö na bala. ");
INSERT INTO muh_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Baka te wü Arabï la za Yüsefa, nü di agbü Ezepeto, fü ewü anü acïnzï engu fü gara mere kpara ka wü marajümïya kpala de ïrï ye Potifara. ");
INSERT INTO muh_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Gbü gara sïkpï, fü *Yuda ayia ace wü wö ye de wü di enga ni ye, anü angbü agbü gara sü de ïrï ye Adulama. Fü ah ajï gba ye ta ede gba gara komoko de ïrï ye Ïra. ");
INSERT INTO muh_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Te Yuda ngbü kpala, fü engu ayia awu gara jaji würüse kpala, egba *Kanana. Fü Yuda ayia ase engu wara ye tete na. ");
INSERT INTO muh_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Fü wara ka la ayia abï ye komoko. Fü Yuda agü ïïrï na Ere. ");
INSERT INTO muh_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Fü wara ka-na adu kpah abï gara ye komoko. Fü ah agü ïïrï na Onana. ");
INSERT INTO muh_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Fü ewü adu ayia sela, anü angbü agbü gara sü de ïrï ye Keziba. Fü wara ka-na adu abï kpah gara ye komoko. Fü ah agü ïïrï na Sela. ");
INSERT INTO muh_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Fü Ere ayia aga, akoro mere komoko. Fü Yuda ayia ase züka jaji würüse fefe na, de ïrï ye Tamara. ");
INSERT INTO muh_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Amba Ere, mü ka-mü ta de siti kpara gbü jia Me fa sü. Fü Me ayia amörö mü asidi, teka *siti ngü ka-mü la. ");
INSERT INTO muh_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Fü Yuda ayia aï Onana, amala ngü fefe na, gü ba dene, “Ye ni deyï, ye za bende ye ne eza, fü ye abï ye eküküte na, de ah ngbü da enga ni ye te kpi ne.” ");
INSERT INTO muh_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Te Onana je ngü la, gü ba, “Ye de te ani ena amaka ake bende ni ne, ah ena adi ka-ye ye gina enga ni ni te kpi ne,” fü ngü la ayia asiti tete na afa sü. Teka ngü la, te Onana dünda sü rara ake Tamara, engu le ato ye guvu Tamara nda de. Fü ah angbü etökö ngu ye la kötö. ");
INSERT INTO muh_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Fü ngü la asiti gbü jia Me ꞌduwa ba-neh-ene-la. Fü Me ayia amörö Onana kpah asidi. ");
INSERT INTO muh_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Fü mere siti cürü ayia arï te Yuda teka ngü la. Fü Yuda afï nga ngü, gü ba dene, “Ngü ladü gbü nga würüse la, angü wü di ni de ꞌbasu ne kpi eyi ꞌburu esa ngüngü. Tïtïne adu ye ni komoko eyi ngbee biringbö dene. Te ni za würüse la, to kpah fefe na, wara ka tete la, ye ni ne ena akpi ka-ye kpah akpi, ba wü di enga ni ye, te ewü kpi ne.” Angü ah wu, gü ba dene, Me mörö wü di ni me-ye, teka siti ngü ka-ewü, te ewü ngbü emere ne, nda de. Te di bala, fü Yuda ayia amala ngü fü Tamara gbü mani, gü ba dene, “Ye ni, Sela ne, ah ka-ye nda la mba jaji. Ah tï fü ah aza würüse nda la de. Ye cï la nganga na feke, zalü te engu ena aga, akoro memere. Te di bala, ye du la edu, ye ngbü agba wö ye, baka würüse wökö ka-ani, zalü te ye ni la ena aga tete.” Fü Tamara, fü mü ayia adu angbü agba yi kpaka wö mü. ");
INSERT INTO muh_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Fütanga wü re la, fü wara Yuda ayia akpi. Fü Yuda aku gbagba na, teke mere bi sïkpï. Fütanga ngü la, fü Yuda ayia amala ngü fü awuba ka-ye, Ïra, gü ba dene, “Ani nü enü agbü Timena, teka awete kala wü kambiliki ka-ani.” Fü ewü ayia areke te-wü teka anü ka-wü kpala. ");
INSERT INTO muh_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamara, mü ka-mü ta gbü lakï la, fï agba wü wö mü ba würüse wökö. Fü mü aje ngü, gü ba dene, “Wügbi ni yia eyi teka anü agbü Timena, awete kala wü kambiliki ka-ye kpala.” ");
INSERT INTO muh_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Fü Tamara ayia afï nga ngü, gü ba dene, “Wügbi ni fiti ni ka-ye afiti. Ah mala ngü fü ni de mani. Tïtïne yeye na ga koro eyi mere komoko. Ah le ato ni fefe na, wara ka tete fï de. Ah ce ni ka-ye eyi ace. Te di bala ne, ni ena abï ye ake da? Te ah bala, nda-ni mani kpah ladü, te ni ena amere. Ni ena anü, afete engu te kaje. Fü ani amaka ye ake di.” Fü Tamara ayia ꞌduwa, agbi bongo ka giri eküte ye ne asidi, adu aza züka bongo ka-ye, abu eküte ye, abuka nzö ye de gbüra ye di ꞌburu. Fü ah ayia anü kpa te kaje ka Timena, angbü te di kaje, te enü agbü Enayima. Fü ah angbü efete Yuda kpala. ");
INSERT INTO muh_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Te Yuda koro tete na, fü ah ayia aceka kpï, awu gara würüse te ngbü te kaje. Fü ah afï, gü ba, würüse la ngbü egïrï wü komoko, angü ah ngbü ewo gbüra ye esa bongo. ");
INSERT INTO muh_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Te di bala, fü Yuda ayia anü akoro kpaka würüse la, amala ngü fefe, gü ba dene, “De-ye deyï, ni ngbü ele de ani ngbü ake ye.” Yuda, mü wu, gü ba dene, dela Tamara, wara ye ni ne, nda-mü de. Te Tamara je ngü te Yuda mala fefe na de bala, fü ah ayi-ta Yuda, gü ba dene, “Te di bala, ye ena ato fü ni neh ene?” ");
INSERT INTO muh_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda gü ba dene, “Te ye le eyi fü ani angbü ake ye la, te ni koro eyi kpa gbü Timena la, ni ena atima enga meme fü ye.” Tamara gü ba, “Züka ngü. Te di bala ne, amba mene e te ye ena ace fü ni, fü ah angbü esaka ni, fü ni awu, gü ba, ye mala ngü la eyi fanü fanü ne, ah de neh ene?” ");
INSERT INTO muh_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda gü ba, “Te di bala, ye ngbü ele de ni to fü ye neh ene?” Tamara gü ba, “Ye za e gbü kpa ye, ba tüngü, de ye za kpah ku nyarï ka-ye, te ye gü gbü ngürü ye la, de ye to fü ni, bete ngbangba ka-ye la, teka fü ni aza ao kpaka ni sene. Te ye tima enga meme la eyi fü ni fanü fanü la, ni ena alügü wü e ka-ye la.” Fü Yuda aza wü e la, ato fefe na. Fütanga ngü la, fü Tamara ayia anü ake Yuda, fü Yuda awu engu würüse tete na. ");
INSERT INTO muh_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Fü Tamara ayia alügü nga ye, adu kpa ekötï. Fü ah ayia agbi züka bongo te ye ne, ao, adu aza bongo ka giri, ato alügü eküte ye. Fü ah adu angbü kpah ba würüse wökö. Amba gbü ngü la, Tamara maka bu ka-ye nda-ye eyi. ");
INSERT INTO muh_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Fü Yuda adu anü akoro agbü Timena. Fü ah aza enga meme la, ayia atima esaka Ïra, de engu du di fü würüse la. Fü ah amala ngü fü Ïra, gü ba dene, “Ye to enga meme fü würüse la, de ah lügü wü e ka-ni, ta te ni ce o kpakaka na ne.” Te Ïra nü koro agbü Enayima kpala, ah maka würüse la nda de. ");
INSERT INTO muh_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Fü ah ayi-ta wü kpara, gü ba dene, “Würüse de terane, te ngbü eto te-ye fü wü komoko te kaje ne, ah neh kaye?” Wüh gü ba, “Ani wu würüse, te ye mala nganga na la, nda-ani de.” ");
INSERT INTO muh_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Te Ïra du maka Yuda tete, fü ah amala ngü fefe, gü ba dene, “Ni maka würüse la nda-ni de. Ni yi-ta wü kpara kpala ꞌburu. Wüh gü ba, ‘Ani wu würüse, te ngbü eto te-ye fü wü komoko ne, nda-ani de.’ ” ");
INSERT INTO muh_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda gü ba, “Ngü ma. Dene ngü ka-ani nda de, angü ni tima meme eyi fefe, ye maka engu nda de. Te di bala, wü e ka-ni la ngbü kpah engbü ꞌburu kpakaka na kpala, angü wü kpara ena amü ani.” ");
INSERT INTO muh_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Fütanga fe bata, fü Yuda ayia aje ngü, gü ba dene, “Tamara mere siti ngü eyi! Ah eyi de bu ye. Angü ah du fü te-ye eyi baka würüse mürü küla, adi eto te-ye fü wü komoko.” Te Yuda je ngü bala, fü ah ayia atima ngü kpala, gü ba dene, “Te ah eyi bala fanü fanü la, ah le de wüh za Tamara, wüh gü agbü wa, de engu curu, akpi de wü ye la asidi.” ");
INSERT INTO muh_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Baka te ewü je ngü te Yuda tima la, fü ewü ayia aza Tamara, anü di, de ani gü agbü wa. Fü Tamara ayia amala ngü fü ewü, gü ba dene, “Kpara te to ye guvu ni ne, wü e kaka-na dene. Wü za la wü e la, wü nü di, agü tatamu na fü wügbi ni, Yuda, de ah ceka la.” Fü ewü ayia ace kpa te Tamara. Fü ewü ayia aza wü e la, anü di kpaka Yuda. ");
INSERT INTO muh_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda ga, ni ceka kpï bane de, gbo! te wü e ka-ye! Te Yuda wu ngü la, fü ah ayia kürrrü, amala ngü fü ewü, gü ba, “Aꞌa! Tamara mere siti ngü nda de! Ah de-ni, Yuda, ni dürü ngü la eyi me-ni, angü ni le ato Tamara fü ye ni, Sela, de.” Fütanga ngü la, Yuda du ngbü ake Tamara ba würüse tete nda tïne de. ");
INSERT INTO muh_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Fütanga ngü la, fü lakï ka Tamara ayia atï teka ayaka. Amba wü ye de guvu Tamara ne ka-wü nda wü dadase. ");
INSERT INTO muh_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Fü gara mbarase ayia ato kpa ye etanü. Fü würüse te ngbü eyaka wü jaji ne, ayia kere, ai diki ku te kpakpa na, gü ba, “Dela eyi gina.” ");
INSERT INTO muh_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Fü mbarase ayia alügü kpa ye asidi. Fü gara mbarase ayia aluru sü, akoro. Fü würüse la ayia agüka, gü ba dene, “Ah du luru sü, koro fi me-ye neh baye baye?” Fü ewü agü ïrï mbarase la Pereze, baka e te wüh gü ba, “E-luru-sü”. ");
INSERT INTO muh_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Fütanganga na, fü engu de diki ku te kpa ye ne, adu tïne, amü akoro. Fü ewü agü ïïrï na Zera. Ah ba e te wüh gü ba, “Diki-e”. Dela ngü ta te mere Yuda ake wara wü di ye, ta te ewü kpi ne. Angü Yuda bï wü Pereze ake Zera eküte Tamara. ");
INSERT INTO muh_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Baka ta te wü di enga ni ye *Yüsefa cïnzï engu fü wü Arabï ne, fü wü Arabï la aza engu anü di agbü *Ezepeto. Fü ewü anü kpah acïnzï engu fü Potifara, te di de mere kpara ka wü marajümïya ka mere miri ka Ezepeto. Fü Potifara ayia aza Yüsefa, adu di agba ye. ");
INSERT INTO muh_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Fü Yüsefa angbü agba Potifara, kpah baka labï kaka-na. Amba Me ce Yüsefa kpikpi ye nda de. Me ngbü fï bü da ele ta-ngü te Yüsefa, da eto wazi fefe. Teka ngü la, fü tima ka Yüsefa, te engu ngbü emere de kpala ne, angbü enü ka-ye ꞌburu mbi. ");
INSERT INTO muh_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Te Potifara wu, gü ba, Me ngbü eto wazi gbü tima te Yüsefa ngbü emere ne ꞌburu me-ye, ");
INSERT INTO muh_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","fü ngü ka Yüsefa angbü ereke gbü jia Potifara ꞌduwa ba-neh-ene-la. Fü Potifara afe Yüsefa, ao ba züka kpara ka tima ka-ye, gbü nzö wü gara kpara ka tima ka-ye ekötï la ꞌburu. Fü ah ace ngü ka wü e ka-ye kpah ꞌburu nde esaka Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Baka te Potifara o Yüsefa baka mere kpara teka wü ngü ka-ye bala ne, fü Me ato wazi gbü wü e ka Potifara ekötï la ꞌburu, teka ngü ka Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Te di bala, Potifara du fï nga ngü teka wü e ka-ye la tïne de, angü ah wu eyi, gü ba, Yüsefa ladü. Fü Potifara angbü tïne de mere tadu, da ezü tïne bü nzïa e. Yüsefa ka-ye ta de züka jaji komoko, te su asu. Ngü kaka-na reke gbü jia wü kpara fa sü. ");
INSERT INTO muh_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Fü ngü Yüsefa ayia areke kpah gbü jia wara Potifara. Fü wara Potifara angbü eceka Yüsefa ꞌduwa de gügümü na te ye. Gbü gara ra, fü wara Potifara afiti Yüsefa, gü ba dene, “Yüsefa deyï, ni ngbü ele de ani nü ngbü la mba ake ye.” ");
INSERT INTO muh_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Amba ngü la tï ta gbü jia Yüsefa nda de. Fü Yüsefa alügü ngü fefe, gü ba dene, “Aꞌa, bala de. Ye ceka la, tïtïne mürü kötï ne fï nga wü ngü de gba ye ne nda tïne de, angü ni ladü sene. Engu ce wü ngü ka-ye eyi ꞌburu esaka ni. ");
INSERT INTO muh_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Wazi wü e kaka de ekötï ne, tïne ꞌburu esaka ni. Gara e biringbö te engu tïrï te ni nda ma. Nzö de-ye, angü ye de wara ka. Te engu ngbü emere züka ngü fü ni bala la, ah ena areke neh baye, te ni ena amere siti ngü, de bala fü mere kpara ka-ni? Te ni mere ngü la bala, ah ena adi de mere *siti ngü gbü jia Me.” Amba würüse la le ngü te Yüsefa mala la nda de. ");
INSERT INTO muh_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Gbü wü sïkpï ꞌburu, fü würüse la angbü fï da ekpülü Yüsefa de biri ngü ka-ye la, gü ba, “Yüsefa deyï, ani ngbü ake ye.” Fü ah afiti Yüsefa bala ma. Yüsefa le ngü kaka la nda de. Fü Yüsefa ace ka-ye fï bü kpo da engbü ake di. ");
INSERT INTO muh_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gbü gara ra, fü Yüsefa arï angbü ka-ye kpa esambü, da emere tima ka-ye. Gbü sïkpï la, gara wü bu ye, wü kpara ka tima sela ꞌburu ma. Ah ngbü ka-ye bü kpikpi ye. Fü würüse la akoro amaka engu kpikpi ye bala. ");
INSERT INTO muh_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Te würüse la wu bala, fü ah ayia ꞌduwa, atï eküte Yüsefa, azoro bongo kaka-na gö! gü ba dene, “Ani ngbü engbü ake ye tïtïne sene.” Baka te Yüsefa wu bala, fü ah ayia agbürü te-ye kpüla! amü akoro kpa etanü, ace bongo ka-ye ciki esaka würüse la sela. ");
INSERT INTO muh_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Te würüse la wu, gü ba dene, Yüsefa kpe eyi kpa etanü, ce bongo ka-ye, o eyi esaka ni ne, fü ah afï nga gara mani ka-ye kere. ");
INSERT INTO muh_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","15","Fü ah ayia aba rere, de mere gba kpa tikpi, aï gara wü mürü tima ka watï ye ꞌburu kpaka ye, amala ngü fü ewü, gü ba dene, “Yi ceka la ngü ka enga *Ebere ne! Engu koro sene tïtïne dene, agbene ra, gü ba dene, ‘Ni le awu ra würüse tete.’ Ma le nda-ra de! Fü ra ayia ꞌduwa, aba rere kpa tikpi. Te engu wu bala, fü ah ayia amü akoro kpüla kpa etanü, ace bongo ka-ye, ao de esaka ra ne. Ako! Mbarase la! Watï ra za engu, koro di sene, neh teka ne? Teka ato lümü gbü jia ra?” ");
INSERT INTO muh_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Fü würüse la ayia aza bongo ka Yüsefa la, ao, gü ba dene, “Te watï ni du koro eyi la, ah ena aceka ngü gbü ngü la me-ye.” ");
INSERT INTO muh_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Fütanga ngü la, fü mürü kötï adu akoro. Fü wara ka la ayia kpah bü kere, anü amala nga ngü la fefe, gü ba dene, “Watï ni deyï, ye ceka la bü ngü ka labï, enga Ebere ne, ta te ye se engu, de ah mere tima sene ne. Ah koro fütanga ye ne, avi jia ni ꞌduwa ba-neh-ene-la! ");
INSERT INTO muh_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Fü ni ayia aku gba, da eba rere. Fü cürü arï tete na. Fü ah ayia de woro, amü akoro kpa etanü, ce bongo ka-ye ciki ede ni kötö sela. Bongo engu, ah dene!” ");
INSERT INTO muh_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Te mürü kötï je ngü la bala gömö wara ye, fü mamaguma ayia asiti. ");
INSERT INTO muh_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Fü ah ayia anü azoro Yüsefa, ai engu, agü agbü ku, gba mere miri sela. Fü Yüsefa angbü agbü ku kpala. ");
INSERT INTO muh_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Te di bala, fü Me angbü ele ta-ngü te Yüsefa, angü Me ngbü ele engu de maguma ye ꞌburu. Fü Me angbü engbü ake Yüsefa, da eto wazi fefe na agbü ku kpala. Fü ngü ka Yüsefa ayia areke gbü jia mere kpara ka ku la afa sü. ");
INSERT INTO muh_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Fü mere kpara la ayia kpah, aza Yüsefa, ao gbü nzö wü kpara ka ku la ꞌburu. Fü Yüsefa angbü eceka kpï fütanga wü tima gbü ku sela tïne ꞌburu me-ye ereke areke. ");
INSERT INTO muh_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wü e ka ku ꞌburu, te Yüsefa ngbü eceka kpï fütanga ewü ne, mere kpara ka ku la du fï nga ewü nda tïne de. Angü engu wu eyi, gü ba, Me ladü ake Yüsefa, da eto wazi fefe, gbü wü ngü de te engu ngbü emere ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ta gbü wü lakï la, wü gara mere kpara ka tima ka mere miri ka wü *Ezepeto ta ladü ꞌbasu. Gara biringbö, tima kaka-na ta teka adi eza ndüꞌba ka miri, anü di fefe na de e-manzö gbü ye. Nda gara nda teka adi eza ambata de züka türü-e, enü di fü miri. Gbü biri sïkpï, fü wü kpara de ꞌbasu la ayia amere *siti ngü gbü jia miri ka Ezepeto la. ");
INSERT INTO muh_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Fü ngü la ayia asiti gbü jia miri la ꞌduwa ba-neh-ene-la. Fü mamaguma ayia asiti eküte wü kpara ka-ye la. ");
INSERT INTO muh_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Fü miri ayia aza ewü, agü agbü ku, kpah gbü sü te wüh gü *Yüsefa gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Fü mere kpara ka wü marajümïya la ayia amala ngü fü Yüsefa, gü ba dene, “Yüsefa deyï, ye di eceka kpï fütanga wü mere kpara ka miri la.” Fü wü kpara la ara agbü ku kpala bala teka mere bi sïkpï. ");
INSERT INTO muh_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Gbü gara biti, fü wü kpara ka miri de ꞌbasu la ayia aroto. Si-ngü ta gbü wü roto ka-ewü la ꞌburu kpikpi ye kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kpurutokokpï la, fü Yüsefa ayia anü kpaka wü kpara la. Fü ah akoro amaka ewü da efï nga ngü ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Fü Yüsefa ayia amala ngü fü ewü, gü ba dene, “Ah mere neh baye te wü ngbü bü tïïï, de mere siti fïngangü de bane? E-mere wü neh ene?” ");
INSERT INTO muh_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Wüh gü ba, “Ani ngbü bala kükürü de, angü ani roto roto gbü biti ne. Ani ngbü efï, gü ba, ngü ladü gbü wü roto la. Amba kpara te ena amala nga si roto la fü ani nda ma.” Yüsefa gü ba, “Te di bala, wü mala nga roto ka-wü la amala fü ni. Ni ena ayi-ta Mere Me, fü engu asere si roto ka-wü la fü ni. Angü Me de kpara te ngbü esere ngü fü wü kpara ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Dela ꞌduwa, fü mene te ngbü eto e-manzö fü miri ne, ayia amala nga nda-ye roto fü Yüsefa, gü ba dene, “Ni roto gbü biti ne, te ni wu mere siti rïrü. ");
INSERT INTO muh_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Rïrü engu la, yakpakpa na bata. Fü rü la ayia ayi. Ni te eceka de, gbo! te rïrï na te mbe, ngbü ngbaaa bane. ");
INSERT INTO muh_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Te ni wu e la bala, fü ni awu ndüꞌba ka mere miri ne esaka ni. Fü ni ayia akolo rï-rü la, angbü da efï ngungu na. Fü ni ayia atökö gbü ndüꞌba la, aza, anü di, ato fü mere miri, kpah fï baka tima ka-ni, ta te ni ngbü emere ne. Dela roto ka-ni te ni roto ne, ah bala.” ");
INSERT INTO muh_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Fü Yüsefa ayia amala si-ngü gbü roto kaka la fefe na, gü ba dene, “De-ye deyï, roto ka-ye la, ngü gbügbü na bane. Yakpa rü de te ya bata la, wüh baka sïkpï bata. ");
INSERT INTO muh_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Angü fütanga sïkpï bata, miri ena ayia aï ye engagira ye, amala ngbanga ka-ye. Fü ah ace siti ngü ka-ye la ꞌburu. Fü ah adu alügü ye gbü tima ka-ye, ta te ye ngbü emere ne. Fü ye adu kpah adi eto e-manzö fefe na.” ");
INSERT INTO muh_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Fü Yüsefa adu arü amala gara ngü fü komoko la, gü ba dene, “De-ye deyï, te ye du koro eyi kpa gba mere miri kpala, te ngü la mere te-ye eyi fanü la, ye di efï nga ni. To ye mere e aïrï te ni de. Te ye ena anü amaka miri la, ye mala nga ni fefe, de engu ce kpa te ni, gbü ku sene asidi. ");
INSERT INTO muh_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Teka ne de, angü wüh gü ni gbü ku sene bü kükürü bala. Ni mere siti ngü nda-ni de. Siti wü kpara zoro ni ka-wü nda-wü me-wü, ta te ni ngbü agbü sü ka-ani to kpa fügö ne. Fü ewü ayia akoro de ni gbü Ezepeto sene, acïnzï ni asidi. Baka te ni ngbü sene, fü ewü ayia aza ni, agü gbü ku bü kükürü dene. Te di bala, si-ngü te ni ngbü di gbü ku sene, ah de neh ene? De ye mala nga ngü la fü mere miri, de ah fï nga ngü teka ni.” ");
INSERT INTO muh_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Fü mene kpara te ngbü emere ambata fü mere miri, ayia aje ngü de te Yüsefa mala fü kiri ye, gü ba, roto kaka-na la de züka ngü gbü ye ne. Fü ah ayia amala nga nda-ye roto fü Yüsefa, gü ba dene, “Ni roto nda-ni te ni bï wü kuwu bata gbü nzö ni, de ambata gbü ye, ");
INSERT INTO muh_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","kpah de mere bi wü türü-e. Fü ni angbü enü de wü e la fü mere miri. Baka te ni ngbü enü tete, fü mere bi wü lu akoro, adoro wü e de gbü nzö ni la, anza ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Fü Yüsefa ayia amala nga nda-ka roto la, gü ba dene, “De-ye deyï, nda-ye roto la, ngü gbügbü bane. Wü kuwu de bata, te ye bï gbü nzö ye la, ah de wü sïkpï bata. ");
INSERT INTO muh_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Fütanga sïkpï bata, mere miri ena aï ye engagira ye, amala ngbanga ka-ye. Fü ah amörö ye, agï kö ye te rü etikpi. Fü wü lu akoro angbü edoro kö ye la. Dela ngü gbü roto ka-ye la.” ");
INSERT INTO muh_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kpah bala, fütanga sïkpï bata, fü sïkpï ka mere miri, ta te wüh yaka engu gbügbü ayia kpah atï. Fü miri ayia amere karama teka sïkpï la. Fü ah ayia aï wü angbe cögbörö wü kpara ka-ye ꞌburu. Fü ewü ayia akoro gbü karama la. Fü miri ayia atima wü kpara agbü ku, aza wü kpara ka-ye de ꞌbasu ne, akoro di engagira ye, de wü angbe cögbörö kpara ka-ye la. ");
INSERT INTO muh_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Fü mere miri ayia alügü mene kpara ka-ye, te ngbü eto e-manzö fü ye ne, gbü tima ka-ye, kpah baka e te Yüsefa mala ne. ");
INSERT INTO muh_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Fü mere miri ayia aza mene kpara ka ambata ne, amörö engu, aza kökö, agï te rü, kpah gegege baka ngü te Yüsefa mala fü ewü la. ");
INSERT INTO muh_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Amba kpara te to e-manzö fü miri ne, du fï nga Yüsefa nda de. Ah mala ngari Yüsefa fü mere miri kpah de, angü toto ïrï ka-ye teka ngü la eyi. ");
INSERT INTO muh_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Fütanga re ꞌbasu, fü mere miri ka *Ezepeto ayia aroto te engu rü ngbü kpa era mere ngu, de ïrï ye Nile ne. ");
INSERT INTO muh_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Fü ah aceka kpï, awu züka wü yiti lorozi, te ewü ꞌbo gegere ꞌduwa ba-neh-ene-la. Fü ewü akoro era ngu la, angbü da ezü e ka-wü. ");
INSERT INTO muh_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Fü gara wü yiti kpah lorozi, te ewü kürü akürü, jogo jogo bala, ayia akoro kpah, efa nga wü bu wü era ngu sela. ");
INSERT INTO muh_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Fü ewü de jogo jogo ne, ayia atï te wü züka ewü la, azüfa, anza ꞌburu. Fütanga ngü la, fü mere miri la ayia azükü gbü roto la. ");
INSERT INTO muh_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Fü mere miri la adu kpah, atï ara. Fü gara roto adu kpah akoro gbü nzönzö. Fü ah aroto nzö-ndo lorozi, ꞌburu eküte lö-ndo biringbö. Fü nzö-ndo la azï jia ye areke afa sü ꞌburu mudu. ");
INSERT INTO muh_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Fü wü gara lö-ndo lorozi adu kpah akö, ao nzö ye kpah lorozi. Amba mene nzö-ndo lorozi de sidi la, yavü ka-wü ayavü, ce bü caca na. ");
INSERT INTO muh_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Fü wü ca-ndo la adu atï te züka nzö-ndo la, azüfa ewü, anza ꞌburu. Dela wü roto ka mere miri te roto. Fü ah ayia azükü gbü roto ka-ye la. ");
INSERT INTO muh_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Te kpï seke tete na, fü mere miri la adu angbü efï ngü ꞌduwa efa sü. Fü ah ayia aï wü mürü landri de wü mürü talara ꞌburu. Fü ah ayia amala nga wü roto la ꞌburu fü ewü. Fü ah adu ayi-ta ewü, de wüh sere nga si wü roto ka wü yiti, de wü ndo la, fü ni. Fü wü kpara la agïrï si wü roto la ma, wüh maka sisi nda-wü de. Fü ngü ka roto la angbü fï bü esiti fïngangü ka miri la, angü roto la fa wü kpara la eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Fü kpara te ngbü eto e-manzö fü miri ne ayia aje ngü la. Fü ngü ka *Yüsefa ayia atï emamaguma, teka ngü ta te wüh gü ewü tete agbü ku ne. Fü ah ayia anü amala ngü fü mere miri, gü ba, “Wayi, mere miri ka-ani, ni de siti kpara. Angü ni mere siti ngü ta eyi fü ye. ");
INSERT INTO muh_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mere miri deyï, baka te ye kö ani, ake kpara ka ambata, gü agbü ku ne, ");
INSERT INTO muh_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","roto koro ta gbü nzö ani ꞌbasu mini kpala. Kpara ka ambata, roto nda-ye roto kpah kpikpi ye, nda-ni kpah kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Te ani roto roto la, gara enga *Ebere ta ladü agbü ku kpala, te ti de mürü tima ka mere kpara ka wü marajümïya ka-ye la. Fü enga Ebere la ayia amala nga si wü roto ka-ani la ꞌburu fü ani. ");
INSERT INTO muh_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Fü wü ngü te ta engu sere fü ani la, ayia amere te-wü fü ani kpah ꞌburu bala. Angü ye za ni, alügü da tima ka-ni, baka ta te enga gina. Fü ye aza kpara ka ambata, agï engu, emörö te rü. Wü ngü la mere te-wü kpah ꞌburu fanü baka ta te enga Ebere la mala fü ani. Dela ta ngü te mere te-ye, te ani roto tete agbü ku kpala.” ");
INSERT INTO muh_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Te mere miri je ngü la bala, fü ah adu afï nga ngü, gü ba, te enga Ebere sere nga si roto ka kpara ka-ni reke areke bala la, ah tï asere nga si nda-ni roto ne de? Fü ah ayia ꞌduwa, atima wü kpara ka-ye kpa gbü ku la, aï Yüsefa. Fü ewü akpe de woro, anü amaka Yüsefa agbü ku la. Fü ewü aza engu, adürü nzönzö areke areke. Fü ewü aza züka bongo, ato tete, akoro de engu kpaka mere miri ka Ezepeto la. ");
INSERT INTO muh_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fü mere miri la ayia amala ngü fü Yüsefa, gü ba dene, “Ni roto gbü biti ne. Gbü fïngangü ka-ni, roto la de ngü gbü ye. Amba gara kpara, de te ena asere si roto la fü ni, nda ma. Fü ewü ayia amala nga ye fü ni, gü ba, ‘Ye tï eyi asere si-ngü gbü roto.’ Fü ni ayia aï ye dene teka ngü la.” ");
INSERT INTO muh_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yüsefa gü ba dene, “Wayi bala, miri ka-ni, te Me le eyi la, ah ena asere si roto ka-ye la fü ni, angü ni tï asere si roto la fü ye, de tete-ni, de. Amba ni wu, gü ba, Me tima züka ngü eyi fü ye gbü roto ka-ye la, te ena agu maguma ye.” ");
INSERT INTO muh_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Fü miri ayia amala nga roto la fü Yüsefa, gü ba dene, “Ni roto bala, te ni rü ngbü era mere ngu Nile ne. ");
INSERT INTO muh_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Fü wü yiti lorozi, te ewü ꞌbo, gegere agegere ꞌduwa ba-neh-ene-la, fü ewü ayia akoro da ezü e ka-wü füh gümba, era mere ngu la. ");
INSERT INTO muh_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ni te edu awu kpala de, fü wü gara ewü, te ewü kürü akürü, kpah lorozi, koro kpah eyi. Ni wu wü yiti, te ewü kürü siti bala, gügü la fï de. ");
INSERT INTO muh_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Fü siti wü yiti la ayia atï te züka wü bu wü la, azüfa ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Te wü siti yiti la züfa wü bu wü la nza tete na, wüh ꞌbo koro memere kpah de. Wüh kürü ka-wü fï bü akürü, jogo jogo te nga wü la. Fütanga ngü la, fü ni ayia azükü. ");
INSERT INTO muh_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Fü ni adu aroto kpah te biri lö-ndo yaba nzö ye lorozi. Fü ah azï jia ye ꞌburu mudu tete. ");
INSERT INTO muh_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Fü ni adu kpah awu gara lö-ndo, de nzö ye kpah lorozi. Amba mene nzö-ndo la yavü ayavü, ce bü caca. ");
INSERT INTO muh_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Fü ca-ndo la ayia azüfa wü züka ndo la ꞌburu, anza ka. Dela roto te ni roto. Fü ni amala nga roto la fü wü mürü talara ꞌburu. Fü roto la afa ewü ꞌburu. Kpara esüka ewü te ena asere si roto la fü ni nda ma.” ");
INSERT INTO muh_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Fü Yüsefa ayia amala ngü fü mere miri la, gü ba, “Mere kpara deyï, wü roto de te ye roto ꞌbasu la, si-ngü gbü ewü ka-ye ngbee biringbö. Me wu eyi, gü ba, gara ngü ladü kpa engagira nü, te ni, Me, ena amere. Fü ah akoro amala nga ngü la ꞌburu gbü roto ka-ye la, teka fü ye areke te-ye, angbü nzo. ");
INSERT INTO muh_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Wü züka yiti de lorozi, de wü züka nzö-ndo la, wüh ka-wü de wü züka wü re lorozi, te ena akpo enatikine. Si-ngü ka-ewü ꞌburu biringbö. ");
INSERT INTO muh_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Teka siti wü yiti, de siti wü nzö-ndo la, wüh de siti wü re ka kpïrï tala, kpah lorozi, te ena akoro fütanga züka wü re la. ");
INSERT INTO muh_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Si-ngü gbü ewü kpah ꞌburu biringbö, baka te ni mala fü ye la. Dela ngü te Me sere fü ye, teka ngü de te Me ena amere kpa engagira nü. ");
INSERT INTO muh_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mene wü re de te ewü ena akpo enatikine baka wü re lorozi ne, ah ena adi ꞌburu de züka wü re, te wü kpara ena angbü de mere bi wü zü-e esaka wü afa sü, gbü Ezepeto sene. ");
INSERT INTO muh_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Fütanga ngü la, fü mere siti kpïrï tala ayia atï gbü nzö wü kpara ka Ezepeto sene kpah ꞌburu. Siti tala la ena amere wü kpara kpah de wü re lorozi. Fü wü kpara angbü de mere cïnga. Fü ewü angbü efï nga züka wü e, ta te ewü ngbü emere gbü züka wü re la ma. Wüh fï nganga, maka de, angü zü esaka ewü tïne ma. Fü mere siti cïnga la ayia afü kere wü kpara kerekere gbaa. ");
INSERT INTO muh_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ngü de te ye roto roto la tete dü ꞌbasu ne, ah kükürü de, angü Me ngbü emala ngü la kpekpeke, gü ba, ‘Ngü te ni ena amere la, ah tï ayiri nda tïne de.’ ” Dela ngü te Yüsefa mala fü mere miri ka Ezepeto la, teka roto kaka-na. ");
INSERT INTO muh_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Fü Yüsefa adu, andaꞌba te-ye, ato fïngangü fü mere miri la, gü ba dene, “Mere kpara deyï, ah ena areke afa sü, te ye ena areke te-ye mbi mbi mbi, gbü züka wü re de lorozi ne, teka mere kpïrï tala te ena akoro ne. Te di bala, ah le de ye gïrï züka kpara ka-ye, te jijia mba amba, teka fü ye afe engu, ao gbü nzö wü kpara ka-ye ꞌburu. Fü kpara la angbü mere kpara fütanga ye. ");
INSERT INTO muh_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ah ena adi bü nzö engu kpikpi ye ne de. Ah le de ye fe kpah wü gara kpara, ao ewü fütanganga na, gbü nzö wü gara kötï ka-ye biri biri ꞌburu, de wüh di ele ta-ngü te mere kpara la. Fü wü kpara la angbü ebiti wü e, eo gbü kafa ka-ye, ace ao bala, teka siti tala te ena akoro. Te ah de lakï ka ndo, anga lakï gara zü koro me-ye la, ah le de kpara ye süka e ka-ye la gbü wü ꞌburuve, de ah za süsüka na biringbö, ah to fü ye. Fü ye aza ao, teka aküwa wü kpara gbü mere kpïrï tala te ena akoro. ");
INSERT INTO muh_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ah le de wü kpara di ebiti mere bi wü zü gbü kafa ka-ye bala, gbü wü re de lorozi ne ꞌburu. Fü ewü adi eceka kpï fütanga wü zü la aceka mbi mbi mbi ereke areke. Fü ah angbü kpala, ");
INSERT INTO muh_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","angü mene gara re lorozi, de te ena akoro sidi nga engu la, ah ena adi tïne siti wü re. Te ye mere bala la, wü kpara ena angbü ekoro, adi emaka wü e ꞌburu kpaka ye. Fü ewü aküwa esaka mere kpïrï tala la. Dela ngü te ni fï, gü ba, ah tï atï de ye mere bala.” Dela ta fïngangü te Yüsefa to fü mere miri ka Ezepeto, teka kpïrï tala te ena atï gbü nzö wü kpara ne. ");
INSERT INTO muh_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Fütanga ngü te Yüsefa mala fü mere miri la, fü ngü la ayia atï gbü jia miri ꞌduwa kpini. Fü wü angbe cögbörö kpara kaka-na ale kpah ngü la bala. ");
INSERT INTO muh_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Fü miri adu amala ngü fü wü angbe cögbörö kpara ka-ye la, gü ba dene, “Züka ngü! Wü ceka la komoko la! Engu de kpeke kpara, te Me to wazi fefe na me-ye. Ni ena aza engu, ao kpara te ena adi ebiti wü e la me-ye gbü Ezepeto sene. Angü ani tï amaka kpeke kpara bakaka la nda-ani de.” ");
INSERT INTO muh_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Fü mere miri la adu amala ngü fü Yüsefa, gü ba dene, “Yüsefa deyï, ni wu eyi, gü ba, ye de kpeke kpara, te ye wu ngü eyi fa sü, angü Me gü tamu ngü, de te ena amere te-ye kpa engagira nü, ne eyi fü ye. ");
INSERT INTO muh_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Te di bala, ni ele ao ye fütanga ni, teka fü ye angbü gbü nzö wü sü ka-ni ne ꞌburu, de wü kpara ka-ni ngbü ꞌburu esaka ye.” ");
INSERT INTO muh_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","42","Fütanga ngü la, fü mere miri la ayia ꞌduwa, aza tüngü ka miri ka-ye, ato te jikpa Yüsefa. Fü ah amala ngü fefe na, gü ba, “Tïtïne, ni o ye eyi mere kpara gbü sü ka-ni ne ꞌburu.” Fü ah adu kpah aza mere bi züka wü bongo ka-ye, ato fü Yüsefa. Fü ah aza züka mangbaꞌda gbü diki-se, agü gbü ngüngürü na. ");
INSERT INTO muh_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Fü ah aza arabïya, te wü nü ngbü egbeke, ato kpah fü Yüsefa. Te wü kpara wu Yüsefa da enü de arabïya la, fü ewü angbü ꞌburu da emï koko, de wü karayi, da egbo nga ïrï Yüsefa di. ");
INSERT INTO muh_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fü miri la adu amala ngü fü Yüsefa, gü ba dene, “Yüsefa deyï, ni o ye eyi fütanga ni. Kpara gbü Ezepeto sene, te ena amere ngü eta kuru jia ye, ena adi ma. Ni to wazi eyi fü ye, teka amere tima la di ꞌburu. Gara kpara te ena ayi-ta ye, gü ba, ‘Ye mere ngü bala, neh teka ne?’ ne, ah ena adi kpah ma. Te kpara le amere ngü sene la, ah ena ayi-ta ye feke. Dela ngü te ni, mere miri, mala me-ni bala.” ");
INSERT INTO muh_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Fü mere miri la adu agü ïrï Yüsefa tïne Zafenata-Paneya, te di de ïrï ka wü Ezepeto. Fü ah adu aza gara jaji würüse de ïrï ye Asenata, ato fü Yüsefa, de ah ngbü wara ka tete. Asenata ta de ye gara mere kpara, de ïrï ye Potifera. ");
INSERT INTO muh_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Dela ngü ta te mere miri ka Ezepeto fe Yüsefa tete, ao engu gbü nzö wü sü ka-ye ꞌburu, o re ka Yüsefa di ta la bü ngbee teke biri de füh ye nzükpa. Fü Yüsefa angbü endoro te nga nzö wü kötï ka Ezepeto la ꞌburu, da eceka tima ka ndo, te wüh ngbü ebiti gbü wü sü la tïne ꞌburu me-ye. ");
INSERT INTO muh_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","48","Fü wü Yüsefa akpo de tima ka-wü la, angbü da endoro, da ebiti wü zü la, angü wü kpara mere zü ta gbü wü re la ꞌduwa ba-neh-ene-la. Fü wü e arï tïne ꞌduwa ba sirimbi la. Fü e angbü kötö ꞌduwa faaa! Fü wü kpara angbü eto wü e la, fü wü Yüsefa angbü ebiti gbü wü kafa ka mere miri, te wüh jï te nga wü nzö kötï la ꞌburu. Fü wü Yüsefa angbü emere tima la kpini kpini bala, teka wü re lorozi la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Fü wü kafa la asi ꞌburu de wü e gbü wü gbe gbe gbe, dada te wüh ena atanga nda tïne ma. ");
INSERT INTO muh_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","52","Gbü züka wü re lorozi la, fü Yüsefa ayia abï wü jaji komoko ꞌbasu ake wara ye, Asenata ne. Fü Yüsefa agü ïrï gina ye ye la Manase, gü ba, “*Siti ngü ta te wü di enga ni ni mere ni di ne, ni ce eyi fü ewü ꞌburu.” Fü engu adu agü ïrï eꞌbaꞌbasu na la Efürayïma, gü ba, “Me to wazi eyi fü ni. Ni sibi eyi gbü sü, ta te ni maka mere cïnga tete na ne.” ");
INSERT INTO muh_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Fü mene züka wü re de lorozi la ayia anza. ");
INSERT INTO muh_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","55","Fütanga ngü la, fü mere siti kpïrï tala ayia atï gbü nzö wü kpara, kpah baka ngü ta te Yüsefa mala ne. Fü tala la angbü eyükü sü gbü sü ka wü Ezepeto ꞌduwa ayükü. Fü ah atï kpah gbü nzö wü kpara te nga wü gara sü füh kotö la nde ꞌburu. Fü wü kpara ka Ezepeto aci ꞌburu de gba. Fü ewü akpo angbü enü kpaka miri, angbü eku gba fefe na teka e-mazü. Angü e-mazü ka-ye duu gbü kafa ka mere miri ka Ezepeto la. Fü miri la angbü etima ewü kpaka Yüsefa, gü ba, “Wü nü, wü se e esaka Yüsefa la, teka fü wü aküwa.” ");
INSERT INTO muh_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Te Yüsefa wu bala, fü ah ayia aü mö wü kafa, akpo da ecïnzï wü e la fü wü kpara. ");
INSERT INTO muh_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Fü gara wü kpara agbü wü gara sü angbü kpah ekoro da ese wü e kpaka Yüsefa gbü Ezepeto sela, angü tala tï ta te nga wü sü füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ta gbü wü re ka mere kpïrï tala la, wü *Yakobo, wö ye *Yüsefa, ngbü ka-wü ta fï agbü tö ka wü *Kanana kpala. Baka te mere kpïrï tala la tï tete, fü tala la azoro sü, akoro agbü tö ka Kanana kpah ꞌburu. Fü tala la angbü emere wü Yakobo agbü Kanana kpala ꞌduwa ba-neh-ene-la. Fü Yakobo ayia aje ngü, gü ba, “Ndo ladü agbü *Ezepeto.” Fü ah ayia amala ngü fü wü di ye, gü ba dene, “Wü di ni deyï, ah mere neh baye, te wü ngbü bü eceka kpï, da ekpi tala de bane ne? ");
INSERT INTO muh_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Wü yia eyia, wü nü agbü Ezepeto, wü se mba ndo, adu di, fü ani ezü ka tala te ani ke. Angü ni je eyi, gü ba, ndo ladü agbü Ezepeto kpala.” ");
INSERT INTO muh_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Fü wü didi ayia ale ngü la. Fü ewü ayia baka wü kpara nzükpa, anü agbü Ezepeto, teka ase ndo. ");
INSERT INTO muh_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Amba Yakobo le de Benzamina, te di de zu enga ni ye Yüsefa ne, mere e anü gbü nga wü di enga ni ye la nda de, angü gara siti ngü ena amere engu te kaje. ");
INSERT INTO muh_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Fü wü di Yakobo la anü amaka te-wü de wü gara wü bu wü, te ewü ngbü kpah enü ase nda-wü jia ndo agbü Ezepeto la. Angü mere tala la tï gbü tö ka Kanana kpah ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Amba Yüsefa, mü ka-mü ta mere kpara fütanga mere miri ka Ezepeto la. Mü kpah me-mü de kpara te ngbü ecïnzï wü ndo la. Wü kpara ꞌburu, te ewü ngbü enü ese ndo ne, ngbü ekoro kpaka Yüsefa feke. Te di bala, fü wü di enga ni ye na ayia akoro kpah kpakaka na, teka ase ndo ka-wü. Fü ewü ayia abu nzökuta wü engagira Yüsefa, angbü ecu ngüngü. Amba wüh wu ta, gü ba, Yüsefa de enga ni ani, ne nda-wü de. ");
INSERT INTO muh_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","9","Fü Yüsefa ayia awu wü di enga ni ye teke. Fü ah angbü eceka ewü, te ewü ngbü ebuka gbüra wü, da ecu ngü ye ne. Fü ah afï nga roto ka-ye, ta te engu roto ne, amaka. Fü ah ayia amere mani, afü te-ye fü ewü baka ganzi kpara, da emala ngü fü ewü gbü mö ka wü Ezepeto. Fü gara kpara angbü efü ngü la, gbü mö ka wü *Ebere. Fü Yüsefa angbü emala ngü fü ewü ꞌduwa kuwa kuwa bala, gü ba dene, “Yi koro neh kaye?” Fü ewü alügü ngü, gü ba dene, “Ani koro ka-ani agbü Kanana, agïrï mba enga ndo, ase.” Yüsefa gü ba dene, “Yi ngbü esu ka-yi wu! Yi de wü mürü mani! Yi koro sene de mani, awu tö ka-a ne, teka adu amala nganga na fü wü vügü!” ");
INSERT INTO muh_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wüh gü ba dene, “Mere kpara, ah bala de. Ani koro ka-ani bü nzö teka ase ndo. Ani de wü mürü mani nda-ani de. ");
INSERT INTO muh_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ani ka-ani ꞌburu de wü di kpara biringbö. Ani de züka wü kpara. Fanü fanü, ani su wu de.” ");
INSERT INTO muh_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yüsefa gü ba dene, “Wü ngbü esu ka-wü dela wu! Wü ka-wü nda-wü wü mürü mani fanü! Wü ena adu amala nga tö ka-ani ne fü wü vügü ka-ani!” ");
INSERT INTO muh_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Wüh gü ba dene, “Mere kpara deyï, ani endaꞌba te-ani fü ye. Ani su wu nda-ani de. Ani ka-ani ꞌburu de wü di kpara biringbö. Wö ani bï ani ta baka wü kpara nzükpa de füh ye ꞌbasu. Fü gara enga ni ani biringbö ayia adürü. Ambadu ka-ani ladü kpa ekötï, kpaka wö ani, agbü Kanana kpala.” ");
INSERT INTO muh_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yüsefa gü ba dene, “Wü ngbü fï bü esu wu, neh teka ne? Ni wu eyi, gü ba, wü de wü mürü mani! ");
INSERT INTO muh_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Te ah bala, ni ele awu ngü ka-wü la mbi mbi mbi. Ni ena aza wü, agü ꞌburu agbü ku. Fü ni awu la ngü ka-wü la. Angü wü mala eyi fü ni, gü ba dene, ‘Gara enga ni ani kpah ladü kpaka wö ani kpala.’ Te di bala, ni ele awu enga ni wü la cu de jia ni feke. Gara süka wü biringbö nü za engu, koro di fü ni. Te ah koro de engu eyi la, fü ni awu, gü ba, wü mala eyi zu ngü fanü fanü. Fü ni ace kpa te wü. Te ah du koro de la, amba wü ka-wü de wü mürü mani.” Fü Yüsefa akïna lö mere miri ka wü Ezepeto la, gü ba, “Te yi koro de engu de la, yi du agbü Kanana kpah de. Yi ena angbü gbü ku sene, zalü te ma ena awu enga ni yi la cu de jia ra.” ");
INSERT INTO muh_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Fü Yüsefa ayia aza ewü, agü agbü ku. Fü ewü ara kpala sïkpï bata. ");
INSERT INTO muh_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Fütanga sïkpï bata la, fü Yüsefa atima kpara de wüh za ewü, koro de ewü engagira ni. Fü ah arü amala ngü fü ewü, gü ba dene, “De-wü deyï, ni ele aküwa wü, angü ni ka-ni de kpara ka Me. Te di bala, ni ele ngü biringbö de wü mere, fü ni ace kpa ni te wü. ");
INSERT INTO muh_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ni le de gara süka wü biringbö ngbü ciki gbü ku sene. Fü gara wü la ayia ago de ndo fü wü kpara ka-wü de kpa ekötï la, de wüh zü ka tala. ");
INSERT INTO muh_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Te wü du koro eyi kpa ekötï la, de wü za enga ni wü engu la, du di fü ni kpakine. Te ni wu mbarase la eyi cu de jia ni la, ni ena awu, gü ba, ngü ka-wü eyi fanü, fü ni ace kpa te wü.” Te wüh je ngü la, fü ewü ayia ꞌburu ale ngü la. ");
INSERT INTO muh_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Fütanga ngü la, fü ewü akpo da ero mö esüka wü sela, gü ba dene, “Yi ceka la! Mere kuru koro kpah eyi eküte nih dene! Maguma Me siti eyi eküte nih, teka mere *siti ngü, ta te nih mere eküte Yüsefa ne. Angü ah ku gba ta te-ye eyi fü nih ma, nih le ngü tete na de. Nih wu cïcïnga na kpah de. Dela eyi mere siti dürü ngü ka-nih, te nih mere.” ");
INSERT INTO muh_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Fü Rübena ayia amala ngü fü wü di enga ni ye la, gü ba dene, “Ni mala ta fü wü eyi, gü ba dene, ‘Ani mere e amere siti ngü fü mbarase la de.’ Wü le aje ngü, de ta te ni mala fü wü ne, ꞌburu ꞌdö de. Enatikine ani maka mere siti kuru eyi gbü ngü la.” ");
INSERT INTO muh_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yüsefa, mü ngbü eje ngü, de te wü di enga ni mü ngbü emala esüka wü, la nde ꞌburu. Amba wüh wu bala nda-wü de, angü Yüsefa ngbü emala ngü fü ewü ꞌburu gbü ganzi mö. Fü gara kpara angbü efü ngü la fü ewü. ");
INSERT INTO muh_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Te Yüsefa je ngü de te ewü ngbü emala la, fü zikiꞌdi gba ayia amo engu. Fü ah ayia afü kpa ekere e, angbü eku gba kpala, angü wüh ena awu ngura gbü jia ni wu. Fü ah aku gba kpala baaala, ayia atüka te-ye, adu kpaka wü di enga ni ye. Fü ah adu aza gara süka ewü de ïrï ye Sïmïyona ne, ai engu gbü jia ewü sela, agü agbü ku. Fü ah ace kpa te wü bu ye na. ");
INSERT INTO muh_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Fütanga ngü la, fü Yüsefa ayia amala ngü fü wü mürü tima ka-ye, gü ba dene, “Wü nü enü, wü cö ndo gbü wü kombo ka wü kpara ne, de wü to kpah gara e-mazü fü ewü teka kaje.” Amba Yüsefa le aza jiase esaka wü di enga ni ye la nda de. Fü ah afï nga mani, amala fü wü kpara ka-ye la, gü ba, “Wü kpara ka-ni deyï, te wü za jiase ka wü kpara la eyi la, de wü za jiase la, lügü fü ewü zïrrrï, gbü mani, gbü kombo, gbü jia ndo ka-ewü la.” Fü wü kpara ka Yüsefa la adu amere kpah bala. ");
INSERT INTO muh_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Fü wü di enga ni ye Yüsefa ayia abï jia ndo ka-wü gbü wü kombo la, ao füh wü dongï ka-wü, angbü ego di kpa ekötï. ");
INSERT INTO muh_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Te wüh ngbü ego tete na, fü sü atï te ewü te kaje. Fü gara süka ewü ayia afuru mö kombo ka-ye, teka acö jia ndo, ato fü dongï ka-ye. Ah ga, ni ceka kpï de, gbo! te jiase ka-ye gbü jia ndo la. ");
INSERT INTO muh_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Fü ah adu amala ngü fü wü di enga ni ye, gü ba dene, “Wü di enga ni ni deyï, wü ceka la! Nda-ni jiase, de te ni se ndo di ne, ka-ye ladü dene!” Fü ewü aci ꞌburu angbü eyï ayï ka cürü. Maguma ewü tïne kpo ma. Fü ewü agü ba dene, “Ata! Me mere fü ani de bane neh ene ngü ne?” ");
INSERT INTO muh_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Fü ewü ayia ago akoro kpa ekötï, kpaka wö wü, agbü *Kanana. Fü ewü ayia amala nga ngü la ꞌburu fü wö wü, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Wö ani deyï, ngü mere ani agbü Ezepeto kpala fa sü. Komoko de kpala, te di de mere kpara ka wü Ezepeto, te ngbü ecïnzï ndo ne, ngbü emala ngü fü ani ꞌduwa kuwa kuwa bala. Ah gü ba, ‘Ani de siti wü kpara. Ani koro gbü mani, awu sü ka-ani.’ ");
INSERT INTO muh_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ani gü ba, ‘Ah bala de. Ani de mürü mani nda-ani de. Ani de züka wü kpara, te ani yia cu agba wö ani. ");
INSERT INTO muh_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ani ꞌburu wü di kpara biringbö, angü wüh bï ani ꞌburu nzükpa de füh ye ꞌbasu. Fü gara enga ni ani ayia adürü. Amba gara na ladü kpa ekötï akine.’ ");
INSERT INTO muh_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Mere kpara la gü ba dene, ‘Ni ele awu ngü te ani mala ne cu de jia ni. Te ah bala la, ni ele fü Sïmïyona angbü ciki kpala, de du ani ne lügü nga wü, du de jia ndo fü wü kpara ka-ani kpa ekötï, teka tala.’ ");
INSERT INTO muh_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ah gü ba dene, ‘Te ani du koro eyi kpa ekötï kpakine la, de ani za enga ni ani, Benzamina ne, du koro di, teka fü ni awu engu cu de jia ni. Te ni wu engu eyi la, fü ni ale, gü ba, ngü ka-ani, ka-ye fanü. Fü ni adu ace kpa te Sïmïyona, teka fü ani adu tïne, angbü ese wü e-mazü ka-ani ba e te ani ngbü ele.’ Dela ngü de te mere kpara ka wü Ezepeto la mala fü ani kpala. Fü ani ayia alügü nga ani, adu akoro dene.” Dela ngü te wü di enga ni ye Yüsefa mala fü wö wü. ");
INSERT INTO muh_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Baka te ewü kpo ngbü eü wü kombo ka-wü, teka afü jia ndo la gbü wü gara e ne, wüh te eceka de, gbo! te jiase ka-ewü, ta te ewü se ndo di ne, ka-wü ꞌburu ladü te nga wü biri biri ꞌburu. Te wüh wu jiase la, fü ewü angbü de mere cürü te wü, de wü wö wü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Fü wö ewü, Yakobo, ayia amala ngü fü ewü, gü ba dene, “Yi ceka la bü mere siti cïnga de eküte ra ne! Yüsefa dürü kpah eyi! Sïmïyona dürü kpah eyi! Yi yia kpah eza Benzamina esaka ra asidi! Ma ena amere ngü ra tïne neh fe? Yi ena aza engu, adu di kpala, amere de engu neh ene? Ööö! Wüh le amörö wü di ra ne anza fere le ꞌburu?” ");
INSERT INTO muh_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Fü Rübena ayia amala ngü fü wö ye, gü ba dene, “Wö ni deyï, ah bala de. Ye to Benzamina esaka ni, de ni ceka kpï fütanganga na me-ni. Ye fï nga ngü de. Angü engu tï akpi de. Ni ena adu de engu, akoro di kpaka ye akine. Te ni du koro de engu de la, de ye za wü di ni de ꞌbasu ne, ye mörö ewü asidi dada na.” ");
INSERT INTO muh_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yakobo gü ba dene, “Aꞌa! Ni le bala de! Ye ni Benzamina nü de! Angü ni ewü bï ewü ngbee ꞌbasu ake Yüsefa. Yüsefa kpi kpah eyi. Dudu esaka ni ngbee biringbö dene. Te siti ngü mere engu esaka wü kpa te kaje la, ni ena amere dela tïne neh baye? Engu dela, ni ena akpi tïne ka mere cïnga de? Ye ni, Benzamina, tï anü de wü kpala de! Ni mala eyi dela!” ");
INSERT INTO muh_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Fütanga ngü la, fü wü *Yakobo ayia angbü ezü ndo, ta te wüh koro di agbü *Ezepeto ne, anza. Amba mere kpïrï tala la ka-ye fï ladü. Fü Yakobo ayia amala ngü fü wü di ye, gü ba dene, “Wü di ni deyï, wü du la kpah edu agbü Ezepeto, teka ase gara jia ndo, adu di fü ani.” ");
INSERT INTO muh_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Fü *Yuda ayia amala ngü fü wö ye, gü ba dene, “Ani ena amere neh baye? Angü mere kpara de ka wü Ezepeto la mala ta ngü fü ani eyi kpekpeke, gü ba dene, ‘Te ani le adu kpaka ni kpala la, ah le de ani za enga ni ani, Benzamina, du di kpo. Te engu ma la, de ani mere e adu akoro kpala tïne de.’ ");
INSERT INTO muh_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Te di bala la, te ye le eyi de ani du kpah, ase gara ndo kpala la, ah le de ani nü tïne de wü Benzamina. ");
INSERT INTO muh_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Te ye le de la, ani tï te ani ena anü kpala kpikpi ani nda-ani kpah de, angü komoko la mala ta ngü fü ani eyi ꞌduwa kpekpeke, gü ba dene, ‘Te ani du kpala kpikpi ani la, ah ena adi esiti.’ ” ");
INSERT INTO muh_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yakobo gü ba dene, “Anga yi mala nga enga ni yi fefe na, neh teka ne? Te engu di ka-ye ta kpa ekötï akine ne. Dela siti ngü! Yi to mere cïnga te ra bala, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wüh gü ba dene, “Wö ani deyï, komoko la ngbü ta eyi-ta ani ꞌduwa kpini kpini, teka wü ngü de kpa gba ani kpakine ne ꞌburu, gü ba dene, ‘Wö ani ladü de jia ye? Anga gara enga ni ani kpah ladü?’ Te mere kpara yi-ta ngü bala la, de ani nga tïne bü anga? Ani wu ta neh kpo, gü ba, engu ena ayi-ta ani teka Benzamina, de ani du koro de engu? Ani wu bala de. Dela si-ngü te ani mala nganga na tete na ne.” ");
INSERT INTO muh_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Fü Yuda ayia amala ngü fü wö ye, agü ba dene, “Wö ani deyï, ye ce kaje fü Benzamina, de ani nü de ewü, ase ndo, angü ani ena akpi anza de wü jaji ka tala. ");
INSERT INTO muh_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ni ena adi eceka kpï fütanga Benzamina me-ni, zalü te ani ena adu akoro de ewü kpaka ye akine. Te ni du koro de engu de la, de lïya engu la ngbü tïne gbü nzö ni fï mere badi. ");
INSERT INTO muh_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Te di bala, ah le de ani nü ꞌduwa anü enatikine, angü ani du ra eyi fa sü dene. Te ye ena angbü ta etïrï engu de la, de ani nda nga ani agbü Ezepeto dene eyi du ꞌbasu.” ");
INSERT INTO muh_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Yakobo gü ba dene, “Te ah bala la, ah le de wü mere wü ngü bane. Wü za wü züka wü e, te di kpa gbü sü de sene ne, ba *se-mü, bete züka wü rï-rü, de wü gara rü ka wuru de se ye, bete kölökö ka wü. Dela wü e te ewü ena aza, anü di, ato fü mere kpara la, baka takpa ka-wü fefe na. ");
INSERT INTO muh_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Wü za kpah mere bi jiase, teka ase ndo di. Fü wü aza kpah gara jiase, da engu ta te wüh lügü gbü kombo ka-wü ne. E-wu neh da, wü kpara la mere ngü la gbü ïrï-to. ");
INSERT INTO muh_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Kpah bala, ah le de wü za enga ni wü, Benzamina, eza gbü nga wü. De wü yia ꞌduwa enatikine, anü agbü Ezepeto, kpaka komoko la. ");
INSERT INTO muh_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mere Me di de wü, de gbüra wü reke gbü jia komoko la areke, de mamaguma gu eküte wü agu. Fü ah alügü enga ni wü, de te engu zoro, tïrï o de kpala ne. Kpah bala, Me gu mamaguma, de engu mere e ato kpa ye te Benzamina kpah de. Wü nü enü, Me ladü. Te wü kpara le amörö Benzamina la, wüh mörö emörö.” ");
INSERT INTO muh_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Fü wü di Yakobo ayia ꞌduwa kere, aza wü takpa la, areke ꞌburu, aza kpah jiase, ta te wüh lügü fü ewü gbü kombo ne, bete gara jiase, te ewü ena ase ndo di. Fü ewü ayia tïne de wü Benzamina, anü agbü Ezepeto. Te wüh koro kpala, fü ewü anü kürrrü, asere te-wü kpaka *Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Te Yüsefa wu Benzamina esüka wü di enga ni ye la, fü ah ayia amala ngü fü mere mürü tima ka-ye la, gü ba dene, “Ye wu eyi, wü komoko ne, wüh de wü ngba ka-ani. Ye za ewü, ye du de ewü kpa ekötï. De ye nü, ye za mere siti yiti, ye wa, de wüh mere fü ani. Angü ani ena azü e ka tü-ra enatikine de ewü.” Amba wü di enga ni ye Yüsefa wu engu nda-wü la fï de. Ah gbü jia ewü ka-ye ba ganzi kpara la. ");
INSERT INTO muh_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Fü mürü tima ka Yüsefa la ayia aza ewü, anü de ewü kpa gba Yüsefa, kpah baka ngü te engu mala fefe na la. ");
INSERT INTO muh_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Te wüh koro te möngïtï ꞌbaranga ka Yüsefa, fü mere cürü akpo arï te wü, angü wüh ngbü efï, gü ba dene, “Wüh ngbü efiti ani, arï de ani kpala, teka azoro ani gbü ïrï-to, akö wü nü ka-ani ꞌburu, adu afü ani, ao labï ka-wü tete. Ani wu de, anga maguma ewü ngbü esiti te ani ne, teka jiase ka-ewü, ta te ewü lügü fü ani gbü jia ndo ne?” ");
INSERT INTO muh_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Fü ewü ayia ace te-wü, arü ka-wü ciki emöngïtï ꞌbaranga la, gü ba, te ani rï kpala la, wüh ena azoro ani. Fü ewü amala ngü fü komoko ka Yüsefa la, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Mere kpara, mba enga ngü ladü kpaka ani cüküꞌdaye, te ani le amala fü ye. Ani koro ta sene, ase ndo. Te ani se ndo la, fü ani alügü nga ani, angbü ego, ");
INSERT INTO muh_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","fü sü atï te ani, fü ani ara te kaje. Gbü biti la, fü ani ayia afuru mö kombo ka-ani ciki gbü sü la, teka ato ndo fü wü nü ka-ani. Fü ani ayia amaka jiase, ta te ani se ndo di, ne ꞌburu da ye, gbü kombo ka-ani. Jiase la, ani za du koro di kpah eyi esaka ani sene. ");
INSERT INTO muh_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ani du koro dene kpah de gara jiase, ase gara ndo di, angü ani wu mene kpara, de ta te o jiase la gbü kombo ka-ani, ne nda-ani de.” ");
INSERT INTO muh_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Fü komoko la alügü ngü fü ewü, gü ba dene, “Ngü ma. Wü kpe cürü de. Angü jiase de ta te wü se ndo di de sene ne, ah ka-ye nda ladü esaka ni. E-wu neh da, ah ena adi dela Mere Me, te za jiase la me-ye, lügü gbü kombo ka-wü la.” Te wüh je ngü la bala, fü ewü ayia arï anü kpa ekötï la. Fü komoko la ayia anü aza Sïmïyona, akoro di fü ewü. ");
INSERT INTO muh_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Fü wü mürü tima la ase ngu, ato fü ewü, fü ewü azürü lö wü di. Fü ewü ato kpah e fü wü nü ka-ewü, azü. ");
INSERT INTO muh_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Fü wü di enga ni ye Yüsefa ayia aza wü takpa ka-wü, te ewü koro di fü mere kpara la, ao nzo, angü wüh wu eyi, gü ba, “Ani ena azü e enatikine gbü ra ne, de wü mere kpara la.” ");
INSERT INTO muh_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Etü ra la, fü Yüsefa adu akoro agba ye. Fü wü di enga ni ye na ayia akoro kpakaka na la, afüwa te-wü, abuka gbüra wü kötö, acu ngüngü na. Fü ewü aza wü takpa la, ato fefe na. ");
INSERT INTO muh_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Fü Yüsefa agü mandï fü ewü, ayi-ta ewü, gü ba dene, “Yi ꞌburu mbi? Wö yi, ta te yi mala nganga, gü ba, ah gbe eyi ne, ah kpah ladü mbi?” ");
INSERT INTO muh_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Fü ewü alügü ngü, gü ba dene, “Wayi, mere kpara, engu ladü mbi.” Fü ewü adu kpah abuka gbüra wü, acu ngüngü na. ");
INSERT INTO muh_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Fü Yüsefa ayia aceka kpï, awu Benzamina, te di de zu enga ni ye guvu ni ye ne. Fü engu ayi-ta ewü, gü ba dene, “Dela enga ni yi, de ta te yi mala nganga na ne?” Fü ah ayia amala ngü fü Benzamina, gü ba dene, “Enga ra, Me di de mü.” ");
INSERT INTO muh_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Fü cïnga Benzamina ayia arï tete ꞌduwa ba-neh-ene-la. Fü ngura akpo angbü ekoro gbü jijia. Fü ah ayia sela bü ferrre, arï kpa esambü ka-ye ka rara, angbü eku gba kpala. ");
INSERT INTO muh_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nganga yiri kpah de, fü ah adu atüka te-ye, aza ngu, azürü gbüra ye di, adu kpah akoro angbü kpaka ewü kpala. Fü ah adu amala ngü fü wü mürü tima ka-ye, gü ba dene, “Wüh koro de e-mazü ekoro fü ani.” ");
INSERT INTO muh_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","33","Fü wü kpara kaka-na akö da-ngbüngbü, ado areke teka e-mazü la. Fü ewü aza mere züka da-ngbüngbü la, agü fi fü gina ewü. Fü ewü adu agü nda wü gara la fï bala, te nga re ka-ewü, zalü akoro di te ambadu. Fü ngü la ayia aga gbü jia ewü ꞌduwa ba-neh-ene-la, wüh gü ba, “Komoko ne wu ani te nga re ka-ani, neh baye baye?” Fü wü mürü tima ka Yüsefa akoro de e-mazü la. Fü ewü ato nda Yüsefa kpah kpikpi ye. Fü ewü adu ato nda wü di enga ni ye kpah kpikpi ye. Fü ewü ato nda wü gara wü kpara ka Ezepeto la kpah kpikpi ye. Angü wü kpara ka Ezepeto zü e te sü biringbö de wü *Ebere nda-wü de, angü gele ka wü Ebere gbü jia ewü esiti. ");
INSERT INTO muh_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Fü Yüsefa adu aza kpah nda-ye züka so, de te engu ngbü ezü ne, ato fü wü di enga ni ye la, te nga ewü ꞌburu. Ah to nda Benzamina ꞌduwa gbe, fa nda wü di enga ni ye la ka. Fü ewü azü e la, asika di ꞌduwa ba-neh-ene-la. Fü ewü ato kpah fï, fü ewü anzö. Fü ewü ayia angbü tïne de mere tadu ka fï gbü jia wü la. ");
INSERT INTO muh_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Fütanga ngü la, fü *Yüsefa ayia afï nga gara mani. Fü ah amala ngü fü mürü tima ka-ye la, gü ba dene, “Ani ena amere gara mani fü wü kpara la. Ye nü enü, ye kö kombo ka ewü la ꞌburu, de ye nü di, ye cö ndo gbügbü na ꞌburu gbe gbe gbe. Te wüh to jiase eyi fü ye la, de ye za, ye o lügü gbü wü kombo ka-ewü, te nga ye biri biri ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","De ye nü, ye za kpah mere züka ndüꞌba ka-ni, de ye wo gbü ndo gbü kombo ka jia ndo ka ambadu ewü la.” Fü mürü tima ka Yüsefa la ayia amere wü ngü, de te engu mala fefe na la, kpah ꞌburu bala. Fü kpï ayia aseke. ");
INSERT INTO muh_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kpurutokokpï la, fü wü di enga ni ye Yüsefa ayia areke te-wü, akö wü kombo ka-wü, ao füh wü nü ka-wü. Fü ewü ayia agü mandï fü wü Yüsefa, ayia ace ewü, atï te kaje, ego. ");
INSERT INTO muh_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kpah baka nga ngü ne, fü Yüsefa ayia aï mürü tima ka-ye la, amala ngü fefe na, gü ba dene, “De-ye deyï, ye kpe ekpe, ye fa nga wü kpara la. Te ye maka ewü eyi la, de ye mala ngü, to cürü guvu ewü, gü ba dene, ‘Wü mere dela bala neh ene ngü ne? Baka te ani mere fü wü züka ngü, wü du mere nda-wü siti ngü fü ani, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Wü nü zi ndüꞌba ka mere kpara ka-ni, neh teka ne? Te ndüꞌba la di ka-ye nda kü ndüꞌba kaka, te engu ngbü enzö e ka-ye gbügbü, da ewu wü ngü gbügbü na ne? Wü mere dela eyi ꞌduwa *siti ngü, te tï de!’ ” Dela ngü te Yüsefa mala fü mürü tima ka-ye la. ");
INSERT INTO muh_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Fü komoko la ayia ale woro fütanga ewü, anü amaka ewü kpa te kaje la. Fü ah ayia amala ngü fü ewü, gü ba dene, “De-wü deyï, ah mere neh baye te wü zi e ka mere kpara ka-ni, akpe anü sü di ne?” ");
INSERT INTO muh_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Te wüh je ngü la bala, fü ewü ace te-wü, arü, alügü ngü fefe na, gü ba dene, “Apa! Mere kpara! Mü mala de bala mene ngü de baye? A de mürü zi nda-a de. A zi e ka-yi nda-a kpah de. ");
INSERT INTO muh_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Mü ceka la, jiase ta te a maka gbü kombo ka-a ne, a du koro di sene. A mala nganga fü mü de? Te di bala ne, a ena adu azi kpah e ka mere kpara baka e la, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Te ah bala la, mü koro ekoro, agïrï kpï gbü wü kombo ka-a ne. Te mü maka ndüꞌba la eyi gbü kombo ka gara kpara esüka a la, engu me-ye de mürü zi, de ye mörö engu asidi! Fü wü du a ne adu angbü tïne ꞌburu labï ka-yi.” ");
INSERT INTO muh_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mürü tima la gü ba dene, “Wayi, yi mala eyi mbi! Ma ena agïrï kpï gbü wü kombo la agïrï. Amba ma ena aza bü nzö mürü zi, te ma ena amaka ndüꞌba la gbü kombo kaka-na ne, te ma ena adu de engu kpikpi ye, ao labï ka-a tete. Wü bu ye na ago ka-wü fï ago agba wü.” ");
INSERT INTO muh_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Fü ewü ayia ꞌduwa, abï wü kombo ka-wü, ao kötö. Fü ewü atï te mö ewü, afufuru ꞌburu asidi, de mürü tima la koro gïrï kpï gbügbü na. ");
INSERT INTO muh_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Fü mürü tima ka Yüsefa la akpo angbü egïrï kpï gbü wü kombo ka-ewü la, biri biri ꞌburu. Ah kpo te gina ewü, zalü koro di te Benzamina, te di de ambadu ewü ne. Ah te ekoro te nda Benzamina, fü ah ayia aceka kpï bane, gbo! te ndüꞌba gbü kombo kaka-na. ");
INSERT INTO muh_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Te wü di enga ni ye na wu ndüꞌba ka mere kpara la gbü e ka Benzamina, fü ewü aci ꞌburu de gba, atï te bongo ka-wü eküte ewü ne, angbü esösörö. Fü ewü adu akö wü kombo ka-wü la ꞌburu, ao alügü kpah füh wü nü ka-wü, alügü nga wü, adu ꞌburu agba Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Te wüh du koro kpala, wüh maka Yüsefa, te ngbü ka-ye fï ekötï sela. Fü ewü ayia ꞌburu, atï kötö, da efüwa te-wü fü Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Fü Yüsefa ayia amala ngü fü ewü, gü ba dene, “De-wü deyï, wü mere de bala neh ene ngü ne? Ngü la gbü jia wü kpala baka züka ngü? Ni ka-ni de mürü talara. Me gü tamu ngü la eyi, fü ni awu akine.” ");
INSERT INTO muh_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Fü *Yuda ayia amala ngü fü Yüsefa, gü ba dene, “Mere kpara, ngü gömö ani, te ani ena amala fü ye ne, ah tïne ma. Ye wu la mba cïnga ani. Ani de siti wü kpara. Ani fï, gü ba, Me to kuru fü ani, teka siti ngü te ani mere gügü ne. Te di bala, gara ngü te ani ena amala nda ma. Ye gu la maguma ye agu. Ani ena angbü ꞌburu sene ba wü labï ka-ye. Angü ani kpah ꞌburu baka mbarase te wüh maka e la gbü kombo kaka-na ne.” ");
INSERT INTO muh_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yüsefa gü ba dene, “Aꞌa, ngü la tï gbü jia ni nda de. Ni ele aza ka-ni nzö kpara, de te zi e ka-ni ne, ao sene. Te di bala, wü bu ye na ena ayia ka-wü ꞌburu, ago kpa ekötï kpaka wö wü. Angü dela ngü ka-ewü nda de.” ");
INSERT INTO muh_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Fü Yuda ayia aka te-ye gbamari engagira Yüsefa, amala ngü fefe, gü ba dene, “Mere kpara deyï, gara enga ngü mba ladü sene gömö ni, te ni le amala fü ye. Te di bala, maguma ye mere e asiti eküte ni de. Teka ne, angü ye ka-ye cu baka mere miri. ");
INSERT INTO muh_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","20","Ngü te ni le amala fü ye ne, ah dene. Mere kpara, baka ta te ani koro sene te enga gina ne, ye yi-ta ta ani, gü ba, ‘Wö ani ladü?’ Ani gü ba, ‘Wayi engu ladü. Engu gbe tïne eyi fa sü.’ Ye gü ba dene, ‘Anga gara enga ni ani ladü?’ Ani gü ba, ‘Wayi, gara enga ni ani kpah ladü kpaka wö ani kpala. Ni ewü bï ewü ta ngbee ꞌbasu. Fü ah ayia akpi ka-ye. Amba gara enga ni ye na la kpi ka-ye kpah eyi ne. Wö ani du o maguma ye tïne bü duu te engu de biringbö la. Ah le engu kpah fa ani ꞌburu, angü ah bï engu tïne gbü gbe ye.’ ");
INSERT INTO muh_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ye gü ba, ‘Te ah bala la, de ani nü, ani za engu, du koro di, de ni wu engu cu de jia ni.’ ");
INSERT INTO muh_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ani gü ba, ‘Mere kpara deyï, mbarase la tï ace wö ani de. Te ah ce engu bü eyi la, wö ani ena akpi ꞌduwa akpi. Angü wö ani ngbü eo maguma ye ꞌburu tete.’ ");
INSERT INTO muh_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ye gü ba dene, ‘Te ani le akoro de enga ni ani la de la, ani mere e adu akoro kpakine de.’ ");
INSERT INTO muh_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Fü ani ayia alügü nga ani, adu akoro kpaka wö ani kpa ekötï. Fü ani amala ngari ye la kpah ꞌburu fefe na. Amba wö ani le ta de mbarase la nü kpakine nda de. ");
INSERT INTO muh_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Amba baka te jia ndo ka-ani la nza tete, fü wö ani ayia amala ngü fü ani, gü ba dene, ‘Ani lügü nga ani elügü, adu kpakine, ase mba gara e-mazü fü ani.’ ");
INSERT INTO muh_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Fü ani amala ngü fefe na, gü ba dene, ‘Ani tï adu kpikpi ani nda-ani de, ꞌduwa te engu le eyi de ani nü de wü Benzamina, ta te ye mala nganga na ne, angü ye mala ta ngü fü ani kpekpeke, gü ba dene, “Te ani za engu, du koro di de la, de ani mere e adu akoro kpaka ni sene kpah de.” ’ ");
INSERT INTO muh_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Wö ani gü ba dene, ‘Te ani za engu eyi, anü di kpakine, gbü *Ezepeto sene la, de ani ceka kpï fütanganga na mbi mbi mbi. Angü wara ni, Rayele, bï ewü ta fü ni ngbee ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Gara dürü ta kpah eyi. Anga siti nü zoro engu me-ye ya? Ni wu de. ");
INSERT INTO muh_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Baka te engu dene lakï tïne eyi bü me-ye ne, ani le kpah eyi, eza engu esaka ni asidi, neh teka ne? Ngü la ena ato mere cïnga te ni efa sü, angü ni gbe ka-ni nza eyi dene. Fanü te siti ngü nü mere engu kpah eyi la, ni ena akpi ka-ni tïne bü akpi ka cïnga.’ Dela ngü te wö ani mala fü ani, teka ngü ka enga ni ani ne. ");
INSERT INTO muh_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Te di bala, te ani du koro bü kpikpi ani kpaka wö ani la, ah ena adi de züka ngü? Te wö ani wu engu esüka ani de la, engu ena akpi ka-ye ka cïnga. Angü mamaguma le mbarase la fa sü. Amba te wö ani kpi la, siti ngü la ena angbü gbü nzö ni, Yuda. ");
INSERT INTO muh_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Angü ni mala ta fü wö ani, gü ba dene, ‘Ah le de engu ce kpa te mbarase la, de ah nü de wü ani, angü de-ni Yuda, ni ena adi eceka kpï fütanganga na me-ni. Te ni du koro de engu de la, de siti ngü la ngbü gbü nzö ni, fï badi.’ ");
INSERT INTO muh_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Te ngü la mere te-ye eyi kpah bala la, ni le adu awu mere cïnga ka wö ni nda-ni de. Te di bala, ni efüwa te-ni fü ye, te ah tï eyi la, de ye ce la mba kpa te mbarase ne, de engu du de wü di enga ni ye kpaka wö ani. Ye za tïne bü ni, ye o dada na sene, teka de ni ngbü tïne me-ani labï ka-ye. ");
INSERT INTO muh_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Angü, te ah bala de la, ni tï adu kpala, angbü eceka cïnga, te wö ani ena akpi di ne, nda-ani de! Mere kpara, dela ngü te ni, Yuda, ngbü endaꞌba te-ni di fü ye.” ");
INSERT INTO muh_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Te *Yüsefa je ngü te *Yuda mala la, fü ngü la ayia ato mere cïnga tete afa sü. Dada na, te engu ena atüka te-ye ma. Fü ah adu amala ngü fü wü kpara ka *Ezepeto, de te ewü ngbü de ewü kpa esambü la ꞌburu, gü ba, “Wü koro kpa etanü. Wü ce ani de wü kpara ne kpikpi ani,” angü ah le eyi agü tamu ye fü wü di enga ni ye. Fü wü kpara ka Ezepeto la ayia akoro ka-wü ꞌburu kpa etanü, anü sü ka-wü, ace wü Yüsefa, ao de wü di enga ni ye sela kpikpi wü. ");
INSERT INTO muh_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Fü Yüsefa ayia aku mere gba de ri ye kpa tikpi. Fü wü kpara ka Ezepeto, te ewü di ta de kpa etanü la, ayia aje riri na la. Fü ewü akpe amala ngü la fü mere miri. ");
INSERT INTO muh_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Fü Yüsefa ayia tïne amala ngü fü wü di enga ni ye, gbü mö ka-wü, gü ba dene, “Wü di enga wüna, dene de-ra Yüsefa!” Fü ah ayi-ta ewü kpekpeke, gü ba, “Wö ni zu ladü ezükü fanü fanü na? Engu kpala mbi? E te mere wö ni kpala, neh ene?” Te wüh wu, gü ba, engu de Yüsefa, fü maguma ewü ayia akolo ꞌduwa tuu! Fü ewü anga ꞌduwa tïïï. Da ngü te ewü ena alügü fefe na tïne ma, ka cürü, bete lümü. ");
INSERT INTO muh_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Te Yüsefa wu, gü ba, maguma wü di enga ni ni kolo eyi, fü ah adu amala gara ngü fü ewü, gü ba dene, “Wü ka te-wü gbamari kpa ede ni akine.” Fü ewü ayia, aka te-wü gbamari. Fü engu adu amala ngü fü ewü, gü ba dene, “Ma dene zu enga ni yi fanü fanü, ta de te yi cïnzï ra fü wü ganzi kpara ne. Fü wü kpara la aza ra, akoro di, de kpa gbü Ezepeto de kpakine. Fanü fanü, dene de-ra. ");
INSERT INTO muh_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Yi mere e, afï nga ngü la tïne de. Lümü mere e amere yi kpah de. Angü dela ngü te Me mere e ka-ye me-ye, eküte ra. Ah tima ra engagira nü agbü Ezepeto kpakine, teka de ma küwa mere bi wü kpara gbü kpïrï tala ne. ");
INSERT INTO muh_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yi wu eyi, gü ba, tala ne mere wü kpara eyi, de re ꞌbasu dene. Amba du wü siti re ka tala la ladü, ꞌburuve, kpa engagira nü. Gbü wü re de ꞌburuve la, wü kpara tï asö e, anga aru gara e kpo de. ");
INSERT INTO muh_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Te di bala, Me tima ra sene, de ma mere mere kpeke ngü, aküwa nih, de mere bi wü kpara, gbü mere siti tala la, angü nguwa nih ena akpi anza ka tala la. ");
INSERT INTO muh_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Amba si-ngü te ma koro di sene, ah teka siti ngü, ta te yi mere ra di ne, nda de. Me tima ra ka-ye nda me-ye kpakine. Me to kpah mere wazi eyi fere, du o ra kpah eyi mere kpara ka miri, te miri ngbü eje riri na, da ece wü ngü ka-ye ꞌburu esasaka na. Angü Me o ra mere kpara gbü nzö wü kpara ka Ezepeto sene ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Fü Yüsefa ayia amala ngü fü wü di enga ni ye, gü ba, “Wü yia eyia kere, wü du kpaka wö ani. De wü mala fü wö ani, gü ba dene, ‘De-ni Yüsefa, ni tima ri ni dene me-ni. Ni ka-ni ladü kpakine. Me za ni, o eyi baka mere kpara, gbü nzö wü kpara ka Ezepeto ꞌburu. Te di bala, ah le de engu yia kpala eyia kere, de ah go kpaka ni, agbü Ezepeto kpakine. ");
INSERT INTO muh_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ah kö wü kpara ka-ye, wü di ye, de wü kundu ye, de wü nü ka-wü, de wü gara wü e te di esaka ewü kpala ꞌburu, koro di kpakine, teka fü ewü angbü gbamari ede ni sene. Ah koro kere, ah mere e amere kuru de, angü züka sü ladü ede ni kpakine, de ïrï ye Gosene, te ewü ena ago angbü gbügbü na. ");
INSERT INTO muh_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Te wü go ngbü eyi gbü Gosene la, ni ena angbü eceka kpï fütanga wü me-ni, gbü mere kpïrï tala ne. Angü du re ka kpïrï tala la ladü kpa engagira nü baka wü re ꞌburuve. Ah le de wü go de wü wö ani, ngbü gbamari sene, angü wü ena akpi anza ka tala. Dela ri ni, Yüsefa, te ni tima fefe na.’ ” ");
INSERT INTO muh_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Fü Yüsefa adu amala ngü fü Benzamina, de wü gara wü di enga ni ye la ꞌburu, gü ba dene, “Yi ceka la ra zalü kpo kpo kpo, teka fü kuru ra atï gbü jia yi. Kuru ra tï gbü jia yi kpala, baka kuru Yüsefa, la fï de? ");
INSERT INTO muh_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Te di bala, yi du kpala, yi mala nga ngü, te yi wu de sene, ꞌburu fü wö nih, gü ba, ‘Ma ladü agbü Ezepeto kpakine, ba mere kpara de mere bi wü e esaka ra.’ Amba ah le de yi za engu, du koro di kpakine kere.” ");
INSERT INTO muh_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Fü Yüsefa ayia afaka Benzamina de gba. Benzamina, fü mü atï afaka enga ni mü kpah de gba. ");
INSERT INTO muh_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Fü Yüsefa akpo afaka wü di enga ni ye la, te nga ewü biri biri ꞌburu, fï de gba. Fü ewü adu tïne, angbü ero mö esüka wü de tadu. ");
INSERT INTO muh_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Fü mere miri ka Ezepeto aje ngü la, gü ba dene, “Wü di enga ni ye Yüsefa koro eyi kpaka Yüsefa sela.” Fü mere miri la ayia angbü de mere tadu te ye, de wü angbe cögbörö kpara ka-ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Fü mere miri la ayia aï Yüsefa, amala ngü fefe, gü ba dene, “Yüsefa deyï, züka ngü, te wü di enga ni ye koro eyi kpaka ye sene. Ye mala ngü fü ewü, de wüh lügü nga wü agbü *Kanana. ");
INSERT INTO muh_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","De wüh za wö wü, de wü kpara ka-wü kpala, du koro de ewü ꞌburu kpaka ani, agbü Ezepeto sene. Angü ni ena ato züka sü fü ewü, gbü Ezepeto sene. Fü ewü angbü amaka mere bi e-mazü gbü sü la. Fü ewü angbü engbü de mere tadu. ");
INSERT INTO muh_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ye mala kpah fü ewü, gü ba, wü mere arabïya, te wü nü ngbü egbeke agbeke ne, ladü esaka ni. Wüh ena aza wü arabïya la, adu di kpala, akö wü wö wü, de wü würüse, de wü jaji ꞌburu gbügbü na, teka adu de ewü kpakine. ");
INSERT INTO muh_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wüh mere e afï nga wü e de kpa gbü Kanana la de. Wüh ena akoro amaka züka wü e agbü Ezepeto kpakine afa sü. Angü ni me-ni de mere miri ka wü kpara ka Ezepeto.” Dela ngü te mere miri la mala fü Yüsefa, de ah mala fü wü di enga ni ye. ");
INSERT INTO muh_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Fü Yüsefa ayia amere ngü la, kpah baka e de te mere miri mala la. Fü Yüsefa aza wü arabïya, ato fü wü di enga ni ye. Ah to kpah wü e-mazü teka fü ewü azü te kaje. ");
INSERT INTO muh_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Fü Yüsefa aza kpah züka bongo, ato fü ewü. Fü ah ayia aza nda Benzamina, ato ꞌburuve. Fü ah aza kpah mere bi jiase ato kpah fefe na. ");
INSERT INTO muh_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Fü ah akö mere bi züka wü e, atima fü wö ye. Fü engu aza ndo, de wü gara e-mazü, ato, de wü wö ni di ezü te kaje. Fü ah aza wü e la, ao ꞌburu füh wü nü. Ah ta de mere bi wü nü baka teke biri. ");
INSERT INTO muh_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Fü Yüsefa ayia atima wü di enga ni ye la, gü ba dene, “Wü nü enü mbi, de wü du koro kere. Amba wü mere e awü nga te kaje de.” ");
INSERT INTO muh_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Fü wü di enga ni ye Yüsefa ayia gbü Ezepeto sela, alügü nga wü, adu. Fü ewü anü bala, zalü akoro ekötï agbü Kanana, kpaka wö wü. ");
INSERT INTO muh_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Fü ewü ayia amala nga ngü de kpala ꞌburu fü wö wü, gü ba dene, “Wö ani deyï, enga ni ani, Yüsefa, ka-ye ladü. Ah kpi nda de. Engu ka-ye ladü agbü Ezepeto kpala. Wüh o engu tïne eyi, mere kpara fütanga mere miri ka Ezepeto. Engu ngbü eyi gbü nzö wü kpara ka Ezepeto ꞌburu.” Te *Yakobo je ngü la bala, fü mamaguma ayia agürü ꞌduwa wööö! Fü ah afï ngü, gü ba, “Wüh ngbü esu ka-wü nda-wü wu! Wüh ngbü efiti ni dela afiti!” ");
INSERT INTO muh_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Fü ewü atï te ngari Yüsefa, amala ꞌburu fü wö wü. Baka te Yakobo du wu wü arabïya de te Yüsefa tima, abï wü ne, fü maguma mü adu agu. Fü ah adu afï, gü ba, ngü la eyi fanü. ");
INSERT INTO muh_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Fü ah ayia amala ngü, gü ba dene, “Wayi, ma wu eyi, gü ba, ngü la ena adi fanü. Ye ra, Yüsefa kpi nda de. Te ah bala, ma ena anü anü agbü Ezepeto, awu ye ra la cu de jia ra, o ra kpi la de dene.” ");
INSERT INTO muh_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Fütanga ngü la, fü wü *Yakobo ayia areke te-wü, de wü di ye, aza wü e ka-wü, ao ꞌburu gbü wü arabïya, ta te mere miri ka wü *Ezepeto tima ne. Fü ewü ayia aza wü wara wü, de wü jaji, ao kpah ꞌburu gbü wü arabïya, ayia atï te kaje, ego agbü Ezepeto, kpah de wü nü ka-wü ꞌburu. Fü ewü anü bala, akoro agbü gara sü kpala, de ïrï ye Bïrï-Saba. Fü ewü ayia ara sela. Fü Yakobo ayia amörö nü sela teka agbo nga ïrï Mere Me di, kpah baka e ta te wö ye na mere de sela. ");
INSERT INTO muh_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Fü Me ayia amala ngü fü Yakobo gbü roto, gü ba dene, “Yakobo deyï, ");
INSERT INTO muh_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","Mü je la ngü ka-ra, te ma emala fü mü ne, angü ma de Mere Me, te di de *vüngüte ka wö mü. Mü mere e akpe cürü, teka ago angbü agbü Ezepeto, ne de. Angü ma ena afete yi te kaje, zalü akoro di kpala. Ma ena angbü kpah fï de wü yi agbü Ezepeto kpala. Fü ra ato wazi fü wü di mü kpala, fü ewü abï ye, asibi afa sü ꞌduwa ba-neh-ene-la. Fü ewü akoro mere nguwa wü kpara. Fü ra adu alügü ewü te gara, adu akoro di kpah gbü *Kanana sene. Amba teka mü Yakobo, mü ena akpi ciki agbü Ezepeto kpala, esaka *Yüsefa. Fü ah areke da mü me-ye.” Dela ngü ta te Me mala fü Yakobo gbü roto agbü Bïrï-Saba. ");
INSERT INTO muh_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","6","Fü wü Yakobo adu ayia gbü Bïrï-Saba sela. Wü didi na za ta engu, de wü jaji, de wü würüse ka-wü, o ꞌburu gbü wü arabïya, de te miri ka Ezepeto tima ne. Fü ewü ayia akö wü nü ka-wü, angbü enü agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wü kpara ta te ewü go de wü Yakobo agbü Ezepeto ne, ah de wü didi, de wü wara wü didi, wü kundu ye wü jaji komoko, de wü jaji würüse. ");
INSERT INTO muh_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Dene ïrï wü di *Yakobo Yïsarayele, de wü kundu ye, ta te engu go ngbü de ewü agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Mene wü jaji guvu Leya, wüh dene. Rübena, te di de gina ye Yakobo, de wü di ye bala, wü Anoka, Palu, Ezerone, bete Karumi. ");
INSERT INTO muh_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Sïmïyona, de wü di ye maꞌdiya, wü Yemüwele, Yamina, Üwada, Yakina, Zowara, be kpah te Sawüla, ta te engu bï ake egba Kanana ne. ");
INSERT INTO muh_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","*Levi, de wü di ye bata, Gerusona, Kowata, bete Merari. ");
INSERT INTO muh_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","*Yuda, de wü di ye bata, wü Sela, Pereze, bete Zera. Amba wü Ere ake Onana kpi ka-wü ta eyi ꞌbasu mini ciki agbü Kanana. Baka te wüh ngbü agbü Ezepeto kpala, fü Pereze ayia aga akoro mere komoko. Fü ah ayia abï wü di ye ꞌbasu, wü Ezerone ake Amula. ");
INSERT INTO muh_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yïsakara, de wü di ye bala, wü Tola, Puva, Yobo, bete Simerona. ");
INSERT INTO muh_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulona, de wü di ye bata, wü Serede, Elono, bete Yelele. ");
INSERT INTO muh_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Dela ꞌburu wü di Yakobo ta te engu bï agbü Padanarama ake mene wara ye, Leya ne. Gara enga Leya ta kpah ladü, jaji würüse de ïrï ye Dina. Wü di Yakobo, ta te engu bï ake Leya, wü de wü jaji guvu wü ꞌburu teke biri nzükpa de füh ye bata (33). ");
INSERT INTO muh_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Dene ïrï wü di enga Zerïfa. Gada, de wü di ye lorozi, wü Zifeyona, Agï, Suni, Ezebone, Eri, Arodi, bete Areli. ");
INSERT INTO muh_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asera, de wü di ye ꞌburuve, wü Yimena, Yiseva, Yisevi, Beriya, be kpah te jaji würüse de ïrï ye Sera. Beriya bï kpah nda-ye wü jaji ꞌbasu, wü Ebere ake Malekiyele. ");
INSERT INTO muh_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Wü di Yakobo, ta te engu bï ake Zerïfa, de wü ye guvu wü ta ꞌburu nzükpa de füh ye maꞌdiya (16). ");
INSERT INTO muh_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dene ïrï wü di enga Rayele, mene wara Yakobo, ta te Yakobo le engu fa sü ne. Rayele bï ye fefe na ngbee ꞌbasu, wü Yüsefa ake Benzamina. ");
INSERT INTO muh_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Baka ta te Yüsefa ngbü agbü Ezepeto kpala ne, ah za ta egba kpara ka Ezepeto, de ïrï ye Asenata. Fü ewü ayia abï ye ake di kpah ꞌbasu, wü Manase ake Efürayïma. ");
INSERT INTO muh_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benzamina, mü bï nda-mü wü jaji ta nzükpa, wü Bela, Bekere, Asebele, Gera, Namana, Eyi, Rosi, Mupima, Upima bete Arada. ");
INSERT INTO muh_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dela ꞌburu wü di ye Yakobo, ta te engu bï ake Rayele ne. Wü di enga Rayele, de wü jaji guvu wü ꞌburu nzükpa de füh ye bala (14). ");
INSERT INTO muh_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dene ïrï wü di enga Bïla, Dana ake ye ye de Usima. ");
INSERT INTO muh_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafatalï, de wü di ye bala, wü Yasele, Guni, Yezere, bete Silema. ");
INSERT INTO muh_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dela ꞌburu wü di Yakobo ta te engu bï ake Bïla. Wü di enga Bïla, de wü jaji guvu wü ta ꞌburu lorozi (7). ");
INSERT INTO muh_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Wü di Yakobo, de wü kundu ye na, ta te ewü go de ewü agbü Ezepeto ne, wüh ꞌburu teke bata de füh ye maꞌdiya (66). Ah du koro tïne teke bata de füh ye lorozi ne (67) de Yakobo engu na. ");
INSERT INTO muh_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Baka te ewü koro, dünda te-wü de wü Yüsefa agbü Ezepeto ne, fü ewü ayia akoro ꞌburu baka wü kpara teke bata de füh ye nzükpa (70). Angü Yüsefa za ta gara egba kpara ka Ezepeto sela. Fü ewü ayia abï ye ake di ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ta te wü Yakobo nü koro tïne gbamari ede Ezepeto ne, fü Yakobo ayia atima Yuda kpa engagira nü kpaka Yüsefa, teka amala ngü ani fefe, teka de ani nü maka te-ani agbü Gosene. ");
INSERT INTO muh_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Te Yüsefa je ngü la, fü ah ayia ꞌduwa, alï gbü arabïya ka-ye, anü de woro, akoro agbü Gosene, amaka wö ye. Fü Yüsefa atï te wö ye, afaka, da eku gba eküküte na ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Fü wö ye na amala ngü fefe, gü ba dene, “Ye ra, Yüsefa, ma wu mü eyi cu de jia ra dene. Ah de mere züka ngü. Ma fï ta, gü ba, mü kpi ka-mü ta eyi gügü. Ma wu mü eyi dene. Ngü ma, te ma kpi ka-ra tïtïne la, ma tï afï ngü tïne de.” ");
INSERT INTO muh_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Fü Yüsefa ayia amala ngü fü wü di enga ni ye, de wü kpara gbü nga wö ye la ꞌburu, gü ba dene, “Wü di enga ni ni deyï, ni yia eyi, teka anü amala nga wü fü mere miri, gü ba dene, ‘Wü wö ni, de wü kpara gbü nga ye koro eyi sene. ");
INSERT INTO muh_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Wüh koro eyi de wü e ka-wü ta de kpa gbü Kanana ne ꞌburu, baka wü kambiliki, wü meme, de wü yiti fa sü, angü wüh ka-wü de wü mürü wü nü.’ Dela ngü de te ni ena anü amala fü mere miri tïtïne.” ");
INSERT INTO muh_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Fü Yüsefa amala kpah gara ngü fü wü di enga ni ye, gü ba, “Te miri ï wü kpaka ye, yi-ta wü, gü ba dene, ‘Tima ka-wü neh ene la?’ ");
INSERT INTO muh_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","De wü mala kpah fefe na la, gü ba dene, ‘Ani de wü mürü wü nü, angü dela tima ka wü kundu ani ta gügü.’ Te wü mala eyi bala la, miri ena ale ale fü wü angbü gbü Gosene sene, angü wü kpara ka Ezepeto le wü mürü nü adi engbü ede mere kötï ka-wü nda-wü kpo de.” ");
INSERT INTO muh_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Fütanga ngü la, fü *Yüsefa ayia aza süka wü di enga ni ye ꞌburuve, anü de ewü kpaka miri, teka amala nga wü wö ye, te ewü koro ne. Te wüh koro kpaka miri la, fü Yüsefa amala ngü fefe na, gü ba dene, “Wayi, mere miri, wü di enga ni ni, de wü wö ni, de ta te ewü di agbü *Kanana ne, wüh koro eyi ꞌburu sene. Wü wara wü, de wü jürü jaji, de wü nü ka-wü, abe kpah te wü e ka-wü ꞌburu, wüh eyi ꞌburu ladü agbü Gosene.” ");
INSERT INTO muh_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","4","Miri gü ba, “Wayi, ah reke ꞌduwa ba-neh-ene-la, te wü wö ye, de wü di enga ni ye go koro eyi sene.” Fü miri ayia ayi-ta wü di enga ni ye Yüsefa, gü ba dene, “Tima ka-wü neh ene?” Wüh gü ba, “Ani de wü kpara, te ani eceka kpï fütanga wü nü, angü dela tima ka wü kundu ani kü ta gügü. Ani ele la mba enga sü gbü *Ezepeto sene, teka angbü gbügbü, de wü nü ka-ani mba takü, angü mere siti tala tï eyi agbü Kanana. Sü te wü nü ka-ani ena adi ezü e tete na, nda tïne kpah ma. Ani ele ta angbü la mba gbü Gosene sene. Ah ena atï atï fü ye?” ");
INSERT INTO muh_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","Fü mere miri la amala ngü fü Yüsefa, gü ba dene, “Ah mbi. Baka te wü wö ye, de wü di enga ni ye, go koro eyi sene ne, ni to sü fü ewü eyi gbü Gosene sene, de wüh o kötï ka-wü gbügbü na. Te di bala, ah le de ye ceka züka sü te reke areke, ao ewü gbügbü na. Ni ele kpah de ye fe gara ewü, te jia ewü mba amba, fü ewü adi eceka kpï fütanga wü nü ka-ni.” ");
INSERT INTO muh_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Fütanga ngü la, fü Yüsefa adu aza wö ye, anü ake di kpaka miri. Te wüh koro kpala, fü *Yakobo ayia agü mandï fü miri, gü ba dene, “Me di de ye, de ah to wazi fü ye.” ");
INSERT INTO muh_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Fü miri ayi-tata na, gü ba, “Mere kpara deyï, re ka-ye neh eyi fe?” ");
INSERT INTO muh_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo gü ba dene, “Re ka-ni koro eyi baka e kama biri teke biri de füh ye nzükpa (130). Amba re la ka-ye bü de bi wü ngü gbü ye, tadu gbügbü nda ma. Ah koro baka re ka wü kundu ani tane kpah de.” ");
INSERT INTO muh_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Te Yakobo yia, ngbü ego tete, fü ah adu kpah amala ngü fü mere miri, gü ba, “Me di de ye, de ah to wazi fü ye. Ye ngbü ka-ye engbü, ani tadu eyi.” Fü wü Yüsefa adu ake wö ye, akoro kpa ekötï. ");
INSERT INTO muh_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Fü Yüsefa adu anü aceka züka sü, ato fü wü wö ye, de wü di enga ni ye, gbü Gosene sela, kpah baka ngü te mere miri mala fefe na ne. Dela ngü ta te Yüsefa mere, te wü wö ye, de wü di enga ni ye go koro maka engu tete agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Fü Yüsefa angbü eto e-mazü fü wü wö ye, de wü di enga ni ye, de wü kpara gbü nga ewü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Fütanga ngü la, fü siti tala la adu angbü emere wü kpara ka Ezepeto, de wü kpara ka Kanana tïne ꞌduwa ba-neh-ene-la. Fü tala angbü euru ewü tïne ꞌduwa efa sü. E te mü ena awu ba e-mazü, gbü sü la tïne kpo ma. ");
INSERT INTO muh_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Fü wü kpara aci ꞌburu, angbü enü kpaka Yüsefa, adi ese ndo. Fü Yüsefa angbü ebiti jiase ka ndo la ꞌburu, eo ao. Fü ah angbü enü di, eto fü miri. ");
INSERT INTO muh_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Fü jiase ayia anza esaka wü kpara ka Ezepeto, bete wü kpara ka Kanana ꞌburu. Baka te jiase nza esaka wü kpara la ꞌburu, fü ewü ayia anü kpaka Yüsefa, akpo angbü endaꞌba te-wü fefe na, gü ba dene, “Ani ena amere baye? Jiase nza esaka ani eyi! Ye ceka la cïnga te ani! Ah le de ye le la mba ta-ngü te ani de e-mazü, angü ani ena akpi ka tala.” ");
INSERT INTO muh_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Fü Yüsefa alügü ngü fü ewü, gü ba dene, “Te jiase nza esaka wü eyi la, de wü nü, wü koro de wü nü ka-wü, adi ese e-mazü di.” ");
INSERT INTO muh_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Fü ewü ayia adu kpa ekötï, angbü eza wü nü ka-wü, baka wü kambiliki, wü meme, wü yiti, kpah de wü dongï, de wü gara wü nü, ekoro di, adi ese ndo di kpaka Yüsefa. ");
INSERT INTO muh_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Fütanga re biringbö, fü ewü adu kpah akoro kpaka Yüsefa, ayi-tata, gü ba dene, “Mere kpara deyï, ani ena amere tïne eyi baye? Te jiase nza esaka ani, de wü nü ka-ani kpah eyi ꞌburu de bane? E te ani ena ato fü ye, teka ndo tïtïne nda tïne ma! Ani ena amere baye? Angü tala la ngbü fï bü emere ani dene! Du e te lakï esaka ani tïne bü ngïrï ani kükürü, bete tö ka-ani. Amba gara e gbü tö la nda tïne kpah ma. ");
INSERT INTO muh_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ye mere e ace ani akpi ka tala de! Ye to la mba enga ndo fü ani, de ani zü. Te gara kaje tïne ꞌburu ꞌburu ma la, de ye za tïne ani, de wü tö ka-ani ꞌburu. Fü ani angbü tïne wü labï ka miri, teka e-mazü, angü ani ena akpi, anza ka tala. Wü yï ka-ani fere te-wü tïne ꞌburu zugu dene. Te ah bala, ye to mba enga nguwa ndo fü ani, teka fü ani anü aru gbü wü yï ka-ani.” ");
INSERT INTO muh_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Fü Yüsefa ayia ale. Fü ah ayia ase wü yï esaka wü kpara ka Ezepeto ꞌburu fü mere miri. Dela ngü ta te Yüsefa mere, gbü wü re ka mere kpïrï tala, ta te ngbü emere wü kpara agbü Ezepeto ne. ");
INSERT INTO muh_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Fü ah aza wü kpara la, te nga wü sü gbü Ezepeto sela, ao ꞌburu baka wü labï ka mere miri. ");
INSERT INTO muh_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ꞌDuwa yï ka wü mene wü mürü gele, te Yüsefa se nda de. Angü miri ngbü ta eto e-mazü fü ewü me-ye kükürü. Teka ngü la, wü mürü gele la cïnzï wü yï ka-wü, teka e-mazü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Fü Yüsefa ayia aza ndo, ato fü wü kpara ka Ezepeto, gü ba dene, “De-wü deyï, ni se wü, de wü yï ka-wü, tïne eyi ꞌburu. Tïtïne dene, ni o wü tïne eyi ꞌburu wü labï ka mere miri. Wü yï ka-wü la ꞌburu, ah tïne nda mere miri. Te di bala, nguwa ndo dene, wü du di, wü ru gbü yï ka mere miri la. ");
INSERT INTO muh_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Te ndo la rï eyi la, de wü za bebete na, akoro di, ato fü mere miri. Fü wü aza gara na, ao nguwa tete. Amba dudu na la, wüh zü azü. Wü je ngü la eyi?” ");
INSERT INTO muh_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Wüh gü ba, “Wayi, mere kpara, ye mere züka ngü eyi fü ani ꞌduwa ba-neh-ene-la. Te di bala, ani ena angbü tïne wü labï ka mere miri, fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Fü Yüsefa ayia ao ngü la baka rïrï, gbü nzö wü kpara ka Ezepeto ꞌburu. Dela si-ngü te ngü la ngbü enatikine tete gbü Ezepeto baka rïrï, te gü ba, “Te mü maka ngulu ka ndo ꞌburuve la, mü ena ato ngulu biri fü miri, ace du nda-mü bala la fü mü.” Amba rïrï la, ah teka wü kükürü kpara, ah teka wü mürü gele nda de, angü Yüsefa se ta yï ka wü mürü gele nda de. Ah za ewü, o baka wü labï kpah de. ");
INSERT INTO muh_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Fütanga mere kpïrï tala la, wü *Yakobo Yïsarayele ngbü ka-wü ta fï agbü *Ezepeto, gbü sü de ïrï ye Gosene ne. Fü ewü amaka mere bi züka wü gara e kpala afa sü. Fü ewü abï kpah wü jaji kpala, fü ewü asibi afa sü. ");
INSERT INTO muh_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Fü Yakobo amere agbü Ezepeto kpala, ꞌburu baka wü re nzükpa de füh ye lorozi, zalü fü re kaka-na anü akoro ꞌburu baka kama biri teke ꞌbasu de füh ye lorozi (147). ");
INSERT INTO muh_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","30","Te Yakobo Yïsarayele wu, gü ba, re ka-ni eyi mari fü ni akpi, fü ah ayia atima ngü fü ye ye, Yüsefa, de ah koro kpaka ni. Fü Yüsefa ayia akoro kpaka wö ye. Fü Yakobo amala ngü fefe na, gü ba dene, “Yüsefa deyï, ni eyi mari teka akpi. Te ye le ngü ka-ni eyi fanü fanü la, de ye mere e ati kö ni gbü Ezepeto sene de. Ye za kö ni, du di, ti agbü Kanana, kpa gbü sü, ta te wüh ti wü wö ani tete na ne. Ni ele de ye kïna lö ni, gü ba, ‘Ni ena amere ngü la bala.’ ” Yüsefa gü ba, “Wayi, ni le eyi amere ngü ka-ye, de te ye mala la.” ");
INSERT INTO muh_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo gü ba, “De ye kïna lö ni ekïna!” Fü Yüsefa ayia akïna lö wö ye kpah bala. Fü Yakobo ayia ari te-ye, agbo nga ïrï Me ciki füh ngbaga ka-ye, te engu ngbü era fefeh na ne. Fü Yüsefa ayia adu kpa gba ye. ");
INSERT INTO muh_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Fütanga ngü la, fü Yüsefa aje ngü, gü ba dene, “Wö ni eyi de keke.” Fü *Yüsefa ayia de wü di ye, wü Manase ake Efürayïma, anü aceka wö ye. ");
INSERT INTO muh_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Te wü Yüsefa koro tete kpala, *Yakobo, mü ngbü era ka-mü ara kötö ka keke la. Fü ewü anü amala ngü fefe, gü ba dene, “Wü Yüsefa koro eyi aceka ye.” Fü Yakobo atüka te-ye, ayia angbü tikpi. ");
INSERT INTO muh_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Fü ah amala ngü fü Yüsefa, gü ba dene, “Ta gügü, o ra di gbü sü de ïrï ye Betele, gbü *Kanana ne, fü Me, te di de mere mürü wazi ne, ayia agü tamu ye fere, gü ba, ‘De-ni Me, ni ena adi fï ake ra. ");
INSERT INTO muh_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Fü ni ato wazi fere, teka fü ra abï bi wü jaji. Fü wü di ra asibi afa sü, akoro baka mere bi nguwa wü kpara. Te gara, ni ena ato tö ka wü Kanana ꞌburu fü wü kundu ra, teka fü ewü angbü gbügbü fï mere badi.’ Dela ngü ta te Me mala fere agbü Betele. ");
INSERT INTO muh_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tïtïne sïkpï ka-ra eyi mari fü ra akpi. Te ma kpi eyi la, wüh ena aza wü e-nga-kpa ra, aye süsüka, ato ꞌburu fü wü di ra. Wüh tï ato fü wü kundu ra nda-wü de, angü ah de gele ka nguwa nih. Te di bala, Yüsefa, ye ra, ma ngbü efï ngü teka wü di mü de ꞌbasu ne, wü Efürayïma ake Manase, te yi bï ewü o ra koro gbü *Ezepeto sene la de ne. Tïtïne dene, ma ele fü ewü angbü tïne kpah baka wü di ra, teka fü ewü aza kpah e-nga-kpa ra gbü nga ra, baka wü gara wü di ra ne. ");
INSERT INTO muh_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Wü gara wü di mü te wüh ena abï ewü sidi ne, wüh tï aza e-nga-kpa ra nda-wü de. Wüh ena aza nda-wü e-nga-kpa, gbü nga wü Efürayïma ake Manase. Dela ngü te ena amere te-ye, teka wü Efürayïma ake Manase. ");
INSERT INTO muh_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Si-ngü te ma mere ngü la tete na bala, ah teka ngü ka ni mü, Rayele, angü ma le engu fa sü. Ah kpi ta eyi gügü, agbü Kanana. Dela o nih yia tete agbü Padanarama, teka anü agbü Beteleme. Te engu kpi tete ne, ma ngbü de mere cïnga fa sü, fü ra ayia ati engu ciki te kaje.” ");
INSERT INTO muh_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Fü Yakobo ayia aceka kpï, awu wü di Yüsefa de ꞌbasu ne, wü Efürayïma ake Manase, te ewü rü mba canza bane. Amba ah wu ewü reke mbi mbi nda de, angü engu gbe ka-ye tïne eyi fa sü. Jijia na tï aceka kpï mbi mbi kpah de. Fü ah adu ayi-ta Yüsefa, gü ba dene “E-rü ngbü nda-wü de kpala, neh wü da?” Yüsefa gü ba, “Dela wü di ni, de te Me to fü ni agbü Ezepeto sene ne.” Yakobo gü ba dene, “Ye za ewü, ye koro de ewü gbamari fü ni, teka de ni sü ngüsü emaguma ewü.” Fü Yüsefa ayia aza ewü, akoro de ewü gbamari kpaka wö ye. Fü wö ye na ayia afaka ewü, aza ewü, ao eri lö ye. ");
INSERT INTO muh_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Fü ah amala ngü fü Yüsefa, gü ba dene, “Yüsefa deyï, ta te ye dürü tete na ne, ni ngbü efï nda-ni, gü ba dene, ye dürü eyi fï badi. Ni tï adu wu ye tïne kpo de. Amba Me mere fü ni nda bü züka ngü. Enatikine dene, ni du wu ye tïne eyi, kpah de wü di ye mini, baka e dene.” ");
INSERT INTO muh_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Fü Yüsefa ayia amala ngü fü wü di ye la, de wüh yia tïne eri lö kundu wü sela asidi. Fü engu ayia atï abuka gbüra ye kötö, acu ngü wö ye. ");
INSERT INTO muh_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Fü Yüsefa adu aza wü di ye la, aka de ewü, alügü kpah kpaka wö ye, teka de ah sü ngüsü emaguma ewü. Ah za Manase o gbü kokpa ka wö ye, angü engu de gina. Fü ah aza Efürayïma, ao gbü kamisü, angü engu de jaji. ");
INSERT INTO muh_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Fü Yakobo ayia ayïngï kpa ye, adu aza nda kokpa, ao gbü nzö Efürayïma, jaji ne. Fü ah adu aza nda kamisü, ao gbü nzö Manase. ");
INSERT INTO muh_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Fü Yakobo aku gba fü Me, teka wü Yüsefa de wü di ye la, gü ba dene, “Me, mü de *vüngüte ka wü wüba, Yïsaka, ake *Abarayama. Mü kpo ngbü eceka kpï fütanga ra kü gügü, gbü ra ta te wüh bï ra tete na, zalü akoro di dene. ");
INSERT INTO muh_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mü ngbü eküwa ra gbü wü siti ngü ꞌburu. Tïtïne ma ngbü eyi-ta mü teka wü jaji ne, wü Efürayïma ake Manase, de mü to wazi fü ewü, de wüh bï wü ye, de nguwa a sibi asibi, anü kpa engagira nü fï mere badi. Teka de ïrï wü wö a, wü Abarayama ake Yïsaka, mere e adürü de.” ");
INSERT INTO muh_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Baka te Yüsefa wu wö ye, te o kpa ye ka kokpa gbü nzö jaji ne, ngü la tï gbü jijia na nda de. Fü ah amala ngü, gü ba, “Wö ni deyï, ah bala de. Ah le de ye o kpa ye ka kokpa ne gbü nzö Manase, angü Manase me-ye de gina fü Efürayïma.” Fü Yüsefa ayia ta, de ni za kpa wö ni ka kokpa ne, de ni o gbü nzö Manase. ");
INSERT INTO muh_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Fü wö ye na ayia atïrï kpa ye ka-ye gbere! ao kpa ye la fï gbü nzö Efürayïma, gü ba, “Ye ni, ni wu kpo! Manase nda ngbürü de gina me-ye fanü. Wü jaji la ꞌbasu mini ena angbü ba wü mere kpara, de mere bi wü di wü, te ewü ena asibi afa sü. Amba ngü ka Efürayïma ena afa nda Manase afa, fü wü kundu ye na akoro mere bi nguwa wü kpara.” ");
INSERT INTO muh_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Dela ngü ta te Yakobo to wazi di fü wü Efürayïma ake Manase, te engu o Efürayïma tete engagira nü fü gina enga ni ye ne. Fü ah mala ngü, gü ba, “Te wü bu wü ena awu züka ngü, de te Me to fü wü ne, wüh ena angbü eku gba fü Me, gü ba dene, ‘Me di eto kpah züka ngü fü ani, baka e ta te engu to fü wü Efürayïma ake Manase ne.’ ” ");
INSERT INTO muh_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Fü Yakobo amala ngü fü Yüsefa, gü ba dene, “Ni wu eyi, sïkpï ka kpi ka-ni koro eyi mari. Ni wu kpah eyi, gü ba, fütanga ni, Me ena adi fï bü de wü. Fü engu aza wü te gara, alügü ꞌburu agbü Kanana, angü dela sü ka wü kundu ani ta gügü, te Me to fü ani ne. ");
INSERT INTO muh_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Te di bala ne, ni ena aza gara mere züka sü, agbü Kanana la, ato fü ye, Yüsefa. Sü la, ni za ta esaka wü di enga Amora gbü gü, de te-dü, bete keze. Ni ena ato sü la fü ye, Yüsefa, angü ye eyi de mere kpara gbü nzö wü di enga ni ye la ꞌburu. De sü la ngbü esaka ye, de wü di ye, de wü kundu ye, fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Fü *Yakobo ayia aï wü di ye la ꞌburu kpaka ye, gü ba dene, “Wü koro la ꞌburu, wü biti te-wü kpakine, de ni mala wü ngü de te ena amere te-ye fü wü te gara, te Me ena alügü wü tete agbü *Kanana ne.” ");
INSERT INTO muh_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Te wü di *Yakobo Yïsarayele koro tete ꞌburu, fü ah akpo angbü ebï ci ka-ye, gü ba dene, “Wü di Yakobo, yi biti te-yi gbü sü biringbö sene, teka aje ngü ka-ra, ka wö yi. ");
INSERT INTO muh_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rübena, mü de gina ye ra. Mü ta baka wazi ra. Ma bï mü ta o ra di la kpah kpekpeke. Mü ngbü ta gbü nzö wü di enga ni mü ꞌburu. Wazi mü fa ta nda-wü kpah afa. ");
INSERT INTO muh_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Rübena, mü de gina ye ra. Wazi mü ta baka mere ngu te ngbü ego ago. Tïtïne mü mere *siti ngü eyi. Wazi mü nza eyi enatikine! Rübena, mü mere siti ngü eyi. Wazi mü tï afa nda wü di enga ni mü tïne de. Angü mü ngbü eyi ake wara wö mü. Mü to lümü eyi gbü jia wö mü! ");
INSERT INTO muh_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Sïmïyona ake *Levi, yi de mürü gü! Yi za maguruma ka-yi mere gü di! Sïmïyona ake Levi, yi de mürü gü! ");
INSERT INTO muh_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Sïmïyona, ma tï arï gbü ngü ka-yi la nda-ra de! Yi ngbü emörö wü kpara, angü maguma yi esiti! Levi, ngü ka-yi la, de ngü ka-ra nda de. Yi ngbü esiya ka te wü kpara bü kükürü! ");
INSERT INTO muh_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Sïmïyona, ma le ngü ka-yi la nda-ra de. Nguwa yi ena abaya gbü wü sü ka-nih ꞌburu. Levi, Me ena ato kuru te yi ka ngü la. Nguwa yi ena aye süka ye jürü jürü. ");
INSERT INTO muh_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","*Yuda, mü de kpeke kpara. Wü di enga ni mü ena adi ꞌburu agbo nga ïrï mü. Wü di enga ni mü ena ecu ngü mü. Wü vügü ka-mü ena angbü ꞌburu esa lö mü. ");
INSERT INTO muh_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda, mü de kpeke kpara. Yuda, mü ka-mü baka kami. Kami te nü mörö nü ka-ye, te za so ka-ye, go di. Fü ah ra kötö eme so ka-ye. Kpara te ena akpülü engu nda ma. Yuda, mü de kpeke kpara. Kpara te ena akpülü mü kpah ma. ");
INSERT INTO muh_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda, mü de kpeke kpara. Wü di mü ena angbü miri fï badi. Wü di mü ena aza ngbangba ka miri esaka wü fï badi. Angü Mere Miri te Me ena atima fü nih, ah ena adi de kundu kundu mü. Mere Miri te ena angbü gbü nzö wü kpara ꞌburu. Nga nzö nguwa wü kpara ꞌburu ena aje rïrï kaka-na. ");
INSERT INTO muh_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wü kpara ꞌburu ena angbü de tadu, teka ngü ka Miri la, Mere Miri, Mere Miri ena akoro. Sü ena areke de mere bi zü gbü ye. Wü e ena arï rudu rudu, fü ewü asibi afa sü. ");
INSERT INTO muh_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mere Miri, Mere Miri ena akoro. Wü kpara ena azü e asika nde. Fü ewü angbü fï bü de mere tadu! Wü nü ena asibi, fü wü kpara adi ezü fï bü so. ");
INSERT INTO muh_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulona, mü ena angbü era mere ngu. Mere bi *zabu ena adi ekoro kpaka mü. Sü ka-mü ena akpo era ngu la, akoro zalü agbü sü ka wü Sïdona. ");
INSERT INTO muh_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Yïsakara, mü baka gbï. Sü ka-mü reke te mü fa sü. Mü baka gbï te ngbü ebiti wü e gbü nze ye. Angü mü fe te-mü nda-mü de. ");
INSERT INTO muh_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Yïsakara, sü ka-mü reke te mü fa sü. Mü fü te-mü labï gbü sü ka-mü. Mü ngbü emere tima efa sü. Mü fe te-mü kpah de. ");
INSERT INTO muh_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dana, mü de kpeke kpara. Wü kundu mü ena asibi, akoro mere nguwa wü kpara. Miri te ena angbü gbü nzö nguwa mü. Ah ena aye süka ngü ka wü kpara mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dana, mü baka enga kpürü te ngbü edere kaje, da ecï nü te ngbü ebï kpara te kaje. Kpürü ena ade tambu lö nü la. Fü kpara de te di fefeh na, ayere atï kötö. ");
INSERT INTO muh_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Me, ma ngbü eo jia ra kpaka mü. Mü ena aküwa a esaka *siti ngü ka-a. Mü ena akoro areke wü sü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gada, wü mürü gü ena akoro, atï de gü gbü nzö mü. Amba mü ena adu amï ewü ꞌburu. Fü mü aliki nga ewü, anü di. ");
INSERT INTO muh_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asera, mü ena adi emaka mere bi zü. Fü ndo ka-mü adi erï ꞌburu ba mudu. Zü ena afa esaka mü sü, de züka wü türü e, baka e ka wü miri. ");
INSERT INTO muh_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nafatalï, ngü ka-mü reke fa sü. Mü ka-mü baka mügara. Mü ena ale mere woro da eviti kpa etikpi. Nafatalï, mü ena abï wü jaji, te ewü ena asu kpah baka mü. ");
INSERT INTO muh_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yüsefa, mü de kpeke kpara. Mü baka züka rü te erï efa sü. Rïrü te wüh ru era ngu. Rïrü te ngbü erï gbeee, rudu rudu. ");
INSERT INTO muh_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yüsefa, mü de kpeke kpara. Wü vügü ka-mü koro, tï gü gbü nzö mü. Fü ewü alofo mü de wü keze ka-wü. Yüsefa, amba mü kpe cürü nda-mü de. ");
INSERT INTO muh_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Yüsefa, mü de kpeke kpara. Mü i maguma mü gö gö gö! Yüsefa, mü zoro dïrï ka-mü gö! Mü fa wü vügü ka-mü eyi. Yüsefa, mü de kpeke kpara. Me to wazi la me-ye fü mü. Me ka-ye de mere wazi. Me ngbü eceka kpï fütanga nguwa nih ꞌburu, Baka kpara te eceka kpï fütanga kambiliki ka-ye. Yüsefa, Me di de mü. Me to wazi ka-ye fü mü. Me ka-ye de mürü wazi. Me ngbü eküwa wü kpara, te ewü ngbü eto te-wü fefe na. ");
INSERT INTO muh_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yüsefa, Me di de mü. Me ka-ye de *vüngüte ka-nih. Me to agö fü mü de ah lï. Me to ngu fü mü, te tï anzürü gbü karanga de. Yüsefa, Me di de mü. Me to wazi fü wü wara yi. Wü wara yi ena abï wü jaji gbe gbe gbe. Wü di yi la ena aga ꞌburu kpeke wü kpara. ");
INSERT INTO muh_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Yüsefa Me di de mü. Me to wazi fü wü di mü. Me to wazi gbü yï ka-mü, de wü e ka-mü di erï efa sü! Yüsefa, Me di de mü. Me to züka wü e ka-ye fü mü. Züka ngü ka Me ngbü fü mü fï badi, baka da. Yüsefa, Me o mü eyi gbü nzö wü di enga ni mü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benzamina, mü de kpeke komoko. Mü ngbü emere ngü baka siti nü. Benzamina, mü ena angbü ezü so, biti de ra mini! Kpara te ena amofo e ka-mü nda ma.” ");
INSERT INTO muh_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Dela ci ka Yakobo, te engu bï, da esara wü di ye di. Ah bï ci la teka ewü biri biri ꞌburu, kpah te nga ngü ka-ewü. Wü di Yakobo nzükpa de füh ye ꞌbasu la, wüh ꞌburu wü kundu ye nguwa wü kpara nzükpa de füh ye ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Fütanga ngü la, fü Yakobo adu amala ngü fü wü di ye, gü ba dene, “Tïtïne, ni gbe nza eyi. Ni eyi gbamari teka akpi. Te ni kpi eyi la, de wü bï kö ni, du di gbü sü ka-ani, agbü Kanana. Fü wü ati ni gbü mbükü, kpa gbü sü ka wü kundu ani kpala, gbü gö da de ïrï ye Makepela, te wüh ngbü eti wü kundu ani gbügbü na ne. Angü sü de kpala, Abarayama, ta te di de kundu ani ne, se me-ye esaka Efürona, enga Ete. Engu se sü la ta me-ye, de wüh di eti wü kpara ka-ani gbügbü na. ");
INSERT INTO muh_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Angü wüh ti kundu ani Abarayama ake wara ye, Sara, ta gbü sü la. Wüh ti wö ni, Yïsaka, ake wara ye, Rebeka, kpah sela. De-ni Yakobo, ni ti mene wara ni, de ïrï ye Leya ne, kpah sela. ");
INSERT INTO muh_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Teka ngü la, ah le de wü za kö ni, nü di, ti kpah kpala, angü dela sü ka kundu ani, ta te engu se esaka wü Ete ne.” ");
INSERT INTO muh_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo mala ngü la ta bala fü wü di ye. Fü ah adu ara kötö, ace kpa te ye, akpi. ");
INSERT INTO muh_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Te *Yüsefa wu, gü ba, wö ni kpi eyi, fü ah ayia atï afaka kö wö ye esangü ye de mere gba. ");
INSERT INTO muh_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Fütanga gba te engu ku la, fü ah anü aï wü kpara, te ewü ngbü ereke kövö, amala ngü fü ewü, de wüh koro de rü, teka areke kö wö ni di, angü ah ena azi. Fü wü kpara la ayia akoro de rü la. Fü ewü angbü efuru rü la te kö *Yakobo baaala, ");
INSERT INTO muh_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","zalü teka fe biri de tü ye, angü gele ka rü engu la, ah ka-ye bala. Fü kö Yakobo angbü baaala, ah zi nda de. Fü wü kpara ka *Ezepeto akoro, aku gba kö *Yakobo Yïsarayele, teka fe ꞌbasu de tü ye, da ecu ngüngü ba mere miri la. Wüh le ati kökö kere de, angü gele ka wü Ezepeto ka-ye bala. ");
INSERT INTO muh_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Te wüh ku gba Yakobo nza tete na, fü Yüsefa ayia anü kpaka wü kovo ka miri, gü ba dene, “Ani ku gba wö ni nza eyi. Ni ele ati kökö na. Gbü ra te wö ni yia akpi tete na, engu mala ngü fü ni, de ni kïna te-ni, gü ba dene, ‘Te ni kpi eyi la, de-ni Yüsefa, ni za kö ni, adu di, ati agbü *Kanana, gbü sü ta te ni, Yakobo, reke kpala.’ Fü ni ayia akïna lölö na eyi, teka amere ngü la bala. Te di bala, dene ngü te ni ele amala fü miri, de miri le fü ni, teka fü ni aza kö wö ni, anü di, ati agbü Kanana. Fü ni adu kpakine.” ");
INSERT INTO muh_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Fü wü kpara la ayia anü kpaka miri, amala ngari Yüsefa la kpah bala ꞌburu fefe na. Fü miri ayia ale ngü la, gü ba dene, “Ni le eyi fü Yüsefa, de engu za kö wö ye, ah du di agbü Kanana, kpah baka kïna kaka, te engu kïna la.” ");
INSERT INTO muh_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Fü Yüsefa ayia areke te-ye, aza kö wö ye, anü di agbü Kanana. Fü mere bi wü kpara ayia agï nga kö Yakobo, anü di agbü Kanana kpala. Ah ta de wü cögbörö wü kpara ka Ezepeto ꞌburu, bete wü marajümïya, te ewü lï füh wü nü, de wü arabïya ka-wü. Wü kpara ka Yüsefa, de wü di enga ni ye na, bete wü kpara gbü nga wö ye na nü kpah eyi ꞌburu, ce bü wü jürü wü jaji, de wü nü ka kötï ka-ewü, agbü Gosene sela. Dela ta ꞌburu wü kpara, te ewü nü gï nga kö Yakobo agbü Kanana. ");
INSERT INTO muh_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Fü ewü ayia atï te kaje, anü, anü, anü zalü akoro gbamari kpa ede ngu de ïrï ye Yürüdene. Fü ewü akoro füh gara da de ïrï ye Atada. Fü ewü ara sela sïkpï lorozi, da eku gba kö Yakobo ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Fü wü kpara de gbü sü la ayia awu wü Ezepeto, te ewü ngbü eku gba ꞌduwa ba-neh-ene-la. Fü ewü, ayia afü ïrï sü la, gü ba, “Abele-Masïrïyïma,” te gü ba, gba ka wü Ezepeto. Sü engu la gbamari ede Yürüdene. ");
INSERT INTO muh_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","14","Fü wü di Yakobo aza kö wö wü, abï anü di, ati agbü Makepela, gbü sü, ta te engu mala nganga na fü ewü ne. Sü la ka-ye gbamari to kpa fügö, ede Mamare. Angü Abarayama, te di de kundu ye Yakobo ne, se ta sü la me-ye esaka Efürona, teka fü ewü adi eti ani gbügbü na. Fü ewü ayia ati Yakobo kpala. Te wüh ti Yakobo tete na, fü wü Yüsefa ayia de wü di enga ni ye, de wü kpara de te ewü gï nganga na, koro di agbü Kanana ne ꞌburu, ayia alügü nga wü, adu agbü Ezepeto. Dela ngü ta te mere te-ye teka kö Yakobo, te wü di ye na bï kökö na, du di, ti agbü Kanana, gbü sü, ta te wüh ngbü eti wü kundu wü gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Fütanga ngü la, fü wü di enga ni ye Yüsefa adu angbü de mere siti fïngangü emaguma wü, gü ba, “E-wu neh da, Yüsefa ti ngü, ta te ani mere engu di esiti ne, eyi emaguma ye. Baka te wö ani kpi eyi ne, engu ena adu afü te-ye, amere ani esiti.” Fü cürü akpo angbü emere ewü ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Fü ewü ayia atima tima kpaka Yüsefa, gü ba, “Dene ngari wö ani, ta te engu mala, ce o fü ye, te engu yia akpi tete na ne. Ah gü ba, ");
INSERT INTO muh_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Yüsefa deyï, ye mere e ao ngü, ta te ani mere ye di ne, emaguma ye eküte ani, teka adu amere ani fütanga ni esiti de.’ Te di eyi bala ne, ani ngbü endaꞌba te-ani fü ye teka ngü la, de ye wu cïnga ani, angü ani ꞌburu wü kpara ka Me, kpah baka wö ani tane.” Te Yüsefa je ngü la bala, fü engu ayia atï ꞌduwa de gba. ");
INSERT INTO muh_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Fü wü di enga ni ye Yüsefa ayia akoro kpakaka na la, atï abuka gbüra wü ꞌburu kötö, andaꞌba te-wü, gü ba, “Mere kpara, ani tïtïne dene eyi ꞌburu wü kpara, te ani di esaka ye.” ");
INSERT INTO muh_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Fü Yüsefa adu arü amala ngü fü ewü, gü ba dene, “Yi mere e akpe cürü de. Ma tï ato kuru te yi, teka *siti ngü ka-yi, ta te yi mere fere ne de. Angü dela tima ka Me. ");
INSERT INTO muh_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yi mere ta siti ngü ngbürü eyi fere ne, amba Me du fü ngü la eyi, o ba züka ngü tete fü nih ꞌburu, de ma koro kpakine, teka aküwa mere bi wü kpara. ");
INSERT INTO muh_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Yi mere e akpe cürü de. Ma ena adi kpah fï eceka kpï fütanga yi, de wü kpara ka-yi ꞌburu.” Dela wü ngü ta te Yüsefa mala fü wü di enga ni ye de züka maguma ye, kpah de züka ri ye. Te wü di enga ni ye na je ngü la bala, fü maguma ewü adu agu. ");
INSERT INTO muh_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Fütanga ngü la, fü Yüsefa angbü agbü Ezepeto kpala, de wü mürü ye la ꞌburu. Fü re ka Yüsefa ayia akoro ꞌburu kama biri de füh ye nzükpa (110). ");
INSERT INTO muh_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Fü Yüsefa ayia awu wü di Efürayïma, de wü kundu ye Efürayïma, cu de jia ye. Kpah bala ye Manase, de ïrï ye Makira ne, bï kpah nda-ye wü jaji ꞌburu, o Yüsefa di la ladü de jia ye. Fü Yüsefa agü ïrï te wü jaji la kpah ꞌburu me-ye. Fü ah angbü eceka kpï fütanga ewü. ");
INSERT INTO muh_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Fü Yüsefa ayia agbe. Fü sïkpï kaka-na ayia akoro gbamari teka akpi. Fü Yüsefa ayia amala ngü fü wü di ye, de wü di enga ni ye, gü ba dene, “Sïkpï ka-ni koro kpah eyi, teka fü ni akpi. Amba, ni wu eyi, gü ba, Me ena adi de wü. Te gara kpala, Me ena adu kpah alügü wü agbü tö ka-ani, agbü Kanana. Angü Me kïna kïna ta eyi bala, fü wü kundu ani, wü *Abarayama, Yïsaka, bete Yakobo, gü ba, ‘Ni, Me, ni ena ato tö ka wü Kanana la fü wü, de wü kundu wü.’ ” ");
INSERT INTO muh_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Fü Yüsefa amala ngü la fü wü di ye la, gü ba dene, “Wü kïna te-wü ekïna tïtïne, gü ba, ‘Te gara, te Me ena alügü ani agbü Kanana la, ani ena aza biki ni, adu di, ati kpala.’ ” Fü ewü ayia ale ngü la, akïna te-wü fefe na kpah bala. ");
INSERT INTO muh_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Fütanga ngü la, fü Yüsefa ayia ace kpa te ye, akpi, o re kaka koro eyi ꞌburu kama biri de füh ye nzükpa (110). Fü wü kpara te ewü ereke kövö ayia aza rü ka-wü, akoro di, afuru eküte kö Yüsefa, angü ah ena azi zi. Fü ewü aza kökö, ao gbü sanduku, ayia ani mömö na ani. Amba wüh ti engu la de. Fü kö Yüsefa angbü agbü Ezepeto sela, ecï nga re, de te Me ena alügü wü di enga Yïsarayele tete na, agbü Kanana ne. Adu ngü ka Yüsefa ta bala.");
INSERT INTO muh_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu *Kurisito de kpara te Me tima engu kpa füh kotö kpakine, teka aküwa wü kpara. Angü Me reke ta ngü la me-ye bala, gü ba, ni ena atima engu, de wüh bï engu gbü nguwa *Davidi, fü engu angbü kpah Mere Miri gbü nzö wü kpara ba Miri Davidi. Yesu Kurisito engu ne, ah kpah de kundu ye *Abarayama, ta te Me mala ngü fefe, gü ba, ni ena aküwa wü kpara füh kotö ne ꞌburu teka ngü kaka ne. Dene ïrï wü mere kundu kundu ye Yesu Kurisito. ");
INSERT INTO muh_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abarayama ta de wö ye *Yïsaka, fü Yïsaka abï *Yakobo. Fü Yakobo abï *Yuda de wü di enga ni ye nzükpa de füh ye biri ne. ");
INSERT INTO muh_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Fü Yuda abï Pereze. Fü Pereze ayia abï Ezerone. Fü Ezerone abï Rama. ");
INSERT INTO muh_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Fü Rama abï nda-ye ye ye, de ïrï ye Amïnadaba. Fü Amïnadaba abï Nasona. Fü Nasona abï Salamona. ");
INSERT INTO muh_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Fü Salamona abï Büwaza, ïrï ni ye na de Rakaba. Fü Büwaza abï Obede, ïrï ni ye na de Ruta. Fü Obede abï Yese. ");
INSERT INTO muh_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Fü Yese adu abï Davidi, te di ta de mere miri ka wü *Yïsarayele ne. Fü Davidi abï *Solomona, ïrï ni ye na de Beteseba, te di ta wara Uriya ne. ");
INSERT INTO muh_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Fü Solomona abï Robama. Fü Robama abï Abïya. Fü Abïya abï nda-ye Asa. ");
INSERT INTO muh_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Fü Asa adu abï nda-ye Yosafata. Fü Yosafata abï Yorama. Fü Yorama abï Uziya. ");
INSERT INTO muh_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Fü Uziya abï Yütama. Fü Yütama abï Aza. Fü Aza abï Izikiya. ");
INSERT INTO muh_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Fü Izikiya abï nda-ye Manase. Fü Manase abï Amona. Fü Amona abï Yüsiya. ");
INSERT INTO muh_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Fü Yüsiya abï Yekoniya de wü di enga ni ye. Gbü re te Yekoniya ngbü miri gbü *Yudaya tete, fü wü kpara ka *Babïlona akoro de gü, azoro engu, de wü kpara ka-ye ꞌburu, ago di agba wü, labï tete. ");
INSERT INTO muh_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Fü Yekoniya abï Salatïyele tïne kpala. Fü Salatïyele abï Zerubabela. ");
INSERT INTO muh_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Fü Zerubabela adu abï Abiyuda tïne agbü Yudaya, o wüh du eyi agbü tö ka-wü. Fü Abiyuda abï Elïyakima. Fü Elïyakima abï Azora. ");
INSERT INTO muh_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Fü Azora abï Zadoka. Fü Zadoka abï Akimi. Fü Akimi abï Eliyuda. ");
INSERT INTO muh_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Fü Eliyuda abï Elazara. Fü Elazara abï Matana. Fü Matana abï Yakobo. ");
INSERT INTO muh_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Fü Yakobo ayia abï *Yüsefa. Ah de Yüsefa ta te za *Marïya, te wü kpara ngbü efï, gü ba, engu de wö Yesu ne. Amba Yesu ka-ye de Ye Me. ");
INSERT INTO muh_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Te di bala, te kpo te *Abarayama, akoro te Miri *Davidi, wüh baka wü kpara nzükpa de füh ye bala. Akpo gbü re ka Miri Davidi, akoro gbü re te wüh zoro wü kpara ka Yudaya labï tete agbü Babïlona, wüh baka wü kpara nzükpa de füh ye bala. Kpah bala, akpo gbü re, te ewü di labï tete agbü Babïlona, akoro te Yesu *Kurisito, wüh kpah nzükpa de füh ye bala. ");
INSERT INTO muh_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ngü ka yayaka ka Yesu kpo ta bane. *Marïya ta de gara jaji würüse, ta te wüh dara engu fü gara komoko de ïrï ye *Yüsefa. Te wüh dara engu, wüh wu engu würüse tete nda-wü la de. Fü Marïya ayia amaka bu, gbü wazi ka *Nzïla Wazi Me. ");
INSERT INTO muh_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Te Yüsefa wu, gü ba, wara ni, Marïya, maka bu eyi, fü ngü la ato fïngangü fefe afa sü. Ah gü ba, “Te di bala, ah tï fü ni aza engu wara ni tete tïne de. Amba ni le aï engu engagira wü mere kpara, aye süka ngü kaka la, nda-ni kpah de. Te ah bala, ah le fü ni agïrï kaje, ace engu bü zïrrrï bala.” Angü Yüsefa ka-ye ta de züka kpara, te le ato mere lümü te Marïya de. ");
INSERT INTO muh_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","O Yüsefa ngbü efï ngü la bala, fü Me ayia atima *malayïka ka-ye kpakaka na gbü roto, agü ba, “Yüsefa, mü mere e akpe cürü, teka aza Marïya wara mü tete, ne de, angü bu de te engu maka la, ah maka gbü siti kaje de, ah maka bu dela gbü wazi ka Nzïla Wazi Me. ");
INSERT INTO muh_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ye de te Marïya ena abï la, ah ena adi ye komoko, fü mü agü ïïrï na Yesu, angü engu ena aküwa wü kpara ka-ye gbü *siti ngü ka-ewü ꞌburu me-ye.” Si-ngü gbü ïrï de Yesu la, gü ba, *E-küwa-nih. ");
INSERT INTO muh_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Fütanga roto la, fü Yüsefa azükü. Fü ah adu amere wü ngü, de te malayïka mala fe ye ne ꞌburu. Fü ah adu aza Marïya wara ye tete. Amba wüh ngbü ake di baka würüse ake komoko de, zalü gbü sïkpï te Marïya nü yaka gina enga ye tete. Fü Yüsefa agü ïïrï na Yesu, baka te malayïka mala fefe. Wü ngü dela mere te-wü bala kükürü de, angü ah tï kpini de ngü, ta te gara *mürü dofo ba gbü *Ngari Me, gü ba, “Gara jaji würüse, te ngbü ake komoko la de, ena amaka bu. Fü ah abï ye komoko. Fü ewü agü ïïrï na Imanüwele.” Ah ba e te wüh gü ba, “Me eyi tundu de wü nih.” ");
INSERT INTO muh_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","2","Wüh bï ta Yesu agbü Beteleme, gbü tö ka *Yudaya, gbü re ta te gina *Erode ngbü di mere miri gbü Yudaya ne. Ta gbü re la, gara wü e-wu-ngü ta ladü kpa gbü gara sü nengete, to kpa fügö, te ewü wu si-ngü teka wü küfara fa sü. Gbü gara sïkpï bane, fü ewü awu to küfara. Fü ewü ayia awu teke, gü ba, wüh bï mere miri eyi fanü gbü tö ka Yudaya. Fü wü e-wu-ngü la ayia anü akoro agbü Yerüsalema. Fü ewü amala ngü, gü ba, “Ani koro dene teka acu ngü vürü mbarase, de te wüh bï engu, te ena angbü Mere Miri ka wü *Yïsarayele te gara ne. Angü ani wu küfara, de te gü tamu ngü ka yayaka kaka fü ani ne eyi. Te di bala, wüh yaka engu neh to kaye?” ");
INSERT INTO muh_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Te Miri Erode je ngü la bala, fü mamaguma ayia anzu. Fü wü kpara ka Yerüsalema angbü ꞌburu de mere cürü, da efï nga ngü, teka ngü la. ");
INSERT INTO muh_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Fü Miri Erode ayia abiti wü mere *mürü gele, de wü *mürü rïrï ꞌburu, ayi-ta ewü, gü ba, “Angü Mere Miri de te Me gü ba, ‘Ni ena atima engu teka aküwa ani ne,’ wüh ena abï engu neh to kaye?” ");
INSERT INTO muh_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Fü wü kpara la alügü ngü fefe, gü ba, “Wüh ena abï miri la agbü Beteleme, gbü tö ka Yudaya sene. Angü gara *mürü dofo ba ngü la ta eyi gbü *Ngari Me, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wü ceka la Beteleme, te di de enga kötï cüküꞌdaye, esüka wü bu ye gbü tö ka Yudaya ne, mere züka ngü ena akoro gbügbü. Angü wüh ena abï Mere Miri gbü sü la, te ena angbü eceka kpï fütanga wü kpara ka-ni, wü di enga Yïsarayele.’ ” ");
INSERT INTO muh_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Te Miri Erode je ngü la bala, fü ah ayia aï wü e-wu-ngü, te ewü koro kpa fügö ne, kpaka ye kpikpi wü, aro mö de ewü esalakumu. Fü ah ayi-ta ewü, gü ba, “Angü wü wu küfara la neh elaye?” Fü ewü asere ngü la fefe. ");
INSERT INTO muh_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Fü Miri Erode adu amala fü ewü, gü ba, “Wüh ba ta eyi gbü Ngari Me, gü ba, wüh ena abï Mere Miri la agbü Beteleme. Te di bala, wü nü enü kpala, wü gïrï sü de te wüh bï engu tete la. Te wü maka engu eyi la, de wü du mala nganga na fü ni. Angü ni le kpah anü kpala acu ngüngü na.” Amba ah mala ngü la de mani. Engu ngbü efiti ewü teka de ni nü, ni mörö mbarase la. ");
INSERT INTO muh_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Te wü e-wu-ngü la je ri miri bala, fü ewü ayia ale kaje ka-wü, anü sü. Wüh te eceka de, gbo! te küfara de te ewü ngbü efa nganga na ne. Te wüh wu küfara la bala, fü ewü angbü de mere tadu. Fü küfara la atï fï bü engagira ewü, enü. Fü ah anü arü mbiii füh kambü, te wüh ngbü de vürü Yesu gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Fü ewü ayia arï kpa esambü la, amaka vürü Yesu ake *Marïya, te di de ni ye na ne. Fü ewü ayia abu nzökuta wü kötö, teka acu ngü Yesu. Fü ewü ayia afuru wü e ka-wü, te ewü koro di ne. Ah de züka *diki-se, ake züka *se-mü, bete *rü te wüh ecuru acuru de züka se ye. Fü ewü aza wü e la ato, teka acu ngü Yesu di. ");
INSERT INTO muh_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Fütanga ngü la, baka te wü e-wu-ngü la yia edu tete agba wü, fü Me atima *malayïka ka-ye, amala ngü fü ewü gbü roto, gü ba, “Wü mere e adu akoro tïne kpaka Miri Erode de. Wü du ka-wü te gara kaje.” Fü wü kpara la ayia adu agbü tö ka-wü te gara kaje, baka ngü te Me mala fü ewü la. ");
INSERT INTO muh_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Fütanga wü e-wu-ngü la, fü Me atima malayïka ka-ye kpaka *Yüsefa, amala ngü fefe gbü roto, gü ba, “Yüsefa deyï, ye yia eyia kere, ye za vürü mbarase ne, ake ni ye, de ye kpe de ewü nengete agbü *Ezepeto, angü Miri *Erode ena agïrï vürü mbarase ne, teka amörö. Wü ngbü kpala zalü akoro gbü sïkpï te ni ena adu amala ngü fü wü me-ni.” ");
INSERT INTO muh_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Te Yüsefa je ngü la bala, fü ah aza vürü mbarase la, ake ni ye, bü ꞌduwa gbü biti la, akpe de ewü agbü Ezepeto. ");
INSERT INTO muh_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Fü ewü angbü kpala, teka mba re cüküꞌdaye, zalü koro gbü re te Miri Erode kpi tete. Ngü la mere te-ye bala kükürü de, angü ah tï kpini de ngü ta te gara *mürü dofo ba gbü *Ngari Me, gü ba, “Ni, Me, ni ena atima ye ni agbü Ezepeto, fü ni adu aï engu, alügü gbü tö ka-wü.” ");
INSERT INTO muh_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Fü Miri *Erode angbü acï nga wü e-wu-ngü la ma. Wüh fü go kpakaka nda-wü de. Fü mamaguma ayia asiti afa sü teka ngü la. Fü engu awu, gü ba, “Wüh fiti ni ka-wü nda-wü afiti!” Fü engu ayia atima wü marajümïya ka-ye agbü Beteleme, agü ba, “Wü nü kpala, wü gïrï wü jaji komoko gbü nga nzö sü la ꞌburu, de wü mörö ewü amörö ꞌburu asidi. Wüh kpo te wü jaji komoko, te wüh bï ewü gbü re ne, akoro te mene ewü te re ka-wü koro eyi ꞌbasu.” Ah mala ngü la bala teka ngü te wü e-wu-ngü mala fefe, teka sïkpï te ewü wu küfara la tete. Fü wü marajümïya ayia anü agbü Beteleme, amörö wü jaji, baka te Miri Erode mala fü ewü. ");
INSERT INTO muh_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ngü la tï kpini de ngü ta te Me mala, gömö gara *mürü dofo de ïrï ye Yeremaya gügü, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mere bi wü würüse ngbü eku yiyi, da eku gba de mere ngura, teka ngü ka wü di enga wü, te ewü kpi nza. Wüh le de wüh le ta-ngü te ani, agu maguma ani kpah de. Gba ka-ewü la, ah ba e te Rayele, te di de ata ani, wü di enga *Yïsarayele ne, ngbü eku gba la me-ye, angü wü di enganga nza eyi ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Fütanga kpi ka *Erode, fü Me adu atima *malayïka ka-ye kpaka *Yüsefa agbü *Ezepeto kpala, amala ngü fefe gbü roto, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Yüsefa deyï, ye yia eyia, ye za mbarase la ake ni ye, ye du de ewü agbü tö ka-wü, wü *Yïsarayele. Angü wü kpara ta te ewü ngbü egïrï engu teka amörö ne, wüh kpi ka-wü eyi.” ");
INSERT INTO muh_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Fü Yüsefa ayia ꞌduwa, aza Yesu ake ni ye, adu de ewü agbü tö ka wü Yïsarayele. ");
INSERT INTO muh_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Te wüh ngbü edu tete, fü Yüsefa ayia aje ngü, gü ba, “Wüh o gara ye Erode, de ïrï ye Arukïlayo ne, eyi miri da wö ye, agbü *Yudaya kpala.” Te di bala, fü Yüsefa ayia akpe cürü, ah le adu angbü agbü Yudaya nda-ye tïne de. Fü Me adu amala ngü fefe kpah gbü roto, gü ba, “Ye nü, ye ngbü gbü nzö kötï ka *Galïlaya.” ");
INSERT INTO muh_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Fü wü Yüsefa ayia anü angbü agbü Galïlaya kpala. Fü ewü ao gba wü gbü gara kötï, de ïrï ye Nazareta. Ngü ka ngbüngbü ka wü Yesu agbü Nazareta la, ah tï kpini te ri Me, de te engu mala ta gömö wü *mürü dofo, gü ba, “Wüh ena angbü eï Miri la, ‘kpara ka Nazareta’. ” ");
INSERT INTO muh_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Sidi nga mere bi wü re, fü gara komoko de ïrï ye *Yüwane Mürü Babatïza anü angbü kpa etü gü, gbü tö ka *Yudaya sela. Fü ah akpo da erï dofo, de ngü ka Me fü wü kpara de kpala, ");
INSERT INTO muh_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","gü ba, “Wü fü maguma wü, angü Mere Miri, te Me ena atima aküwa ani ne, koro eyi.” ");
INSERT INTO muh_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yüwane Mürü Babatïza de kpara, ta te *mürü dofo Yïsaya mala nganga na gbü *Ngari Me, gü ba, “Gara kpara ena akoro, angbü emala ngü de mere ri ye kpa etü gü, gü ba, ‘Mere Miri, te ena aküwa ani ne, ah te ekoro! Ah le de wü reke kaje fefe! Wü ni wü cudu, wü o kpini, teka fü engu anü tete na.’ ” ");
INSERT INTO muh_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yüwane ngbü ta eto bongo ka-ye, te ewü gbï gbü su nü de ïrï ye kamele, sisiti gbulukusu bane. Ah ngbü ta ei ku konü etadu ye. Zü-e kaka te engu ngbü ezü, ah ka-ye ta bü mbïra te di baka eci, bete wü, de te engu ngbü emaka agbü gü kpala. ");
INSERT INTO muh_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Fü mere bi wü kpara ayia akoro kpaka Yüwane, teka aje ngü ka Me gögömö na. Gara ewü koro gbü wü kötï ede ngu de ïrï ye Yürüdene. Gara ewü koro gbü wü gara nga nzö kötï ka Yudaya. Gara ewü koro nengete agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Te wü kpara la je ngü ka Me gömö Yüwane de bala, fü maguma ewü ayia agürü. Fü ewü akpo da emala nga wü *siti ngü ka-wü fü Me de cïnga. Fü Yüwane angbü eto *babatïza fü ewü gbü ngu Yürüdene. ");
INSERT INTO muh_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Fü mere bi wü *mürü rïrï ka wü *Yïsarayele ayia kpah akoro kpaka Yüwane, teka de engu to babatïza fü ani. Gara ewü de wü *Farusi, gara ewü de wü *Saduke. Te Yüwane wu ewü te ewü ngbü ekoro, fü ah awu teke, gü ba, maguma ewü ka-ye ꞌbasu ꞌbasu. Fü ah adu amala ngü fü ewü, gü ba, “De-yi, wü siti kpara! Mani ka-yi baka nda kpürü! Yi efï nda-yi, gü ba, ‘Ani ena aküwa gbü kuru, te Me ena ato fü wü siti kpara te gara ne,’ bü teka ngü te yi ngbü emala de komö yi, kükürü kükürü de bala? E-mala ngü la fü yi bala neh da? ");
INSERT INTO muh_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Te yi le aküwa fanü la, ah le de yi fü maguma yi, adi emere wü ngü te ena areke gbü jia Me. ");
INSERT INTO muh_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yi fï nda-yi, gü ba, ‘Me ena aküwa ani, angü ani de wü kundu ye *Abarayama ne?’ Ah bala de! Ma emala fü yi dene zu ngü. Te Me le la, ah tï eyi afü wü teme ne ꞌburu, akoro di wü di Abarayama tete, te ngü ka-ewü ena areke gbü jijia, afa nda-yi ka! ");
INSERT INTO muh_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yi ceka la, Me eyi nzo teka ato kuru fü yi, baka kpara te di de gifi esaka ye, teka agïrï mene rü te rï de, fü engu ade, agü agbü wa. ");
INSERT INTO muh_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Amba Me tima gara kpara eyi, te ena akoro arï yi sidi nga ra, wawazi na fa nda-ra ka. Ma nda-ra bü baka labï kaka-na, angü engu me-ye de mere kpara fere. Nda-ra, ma ngbü eto babatïza fü yi de ngu kükürü. Amba nda-ka, ah ena akoro ato babatïza fü yi de wazi ka *Nzïla Wazi Me, te di baka wa, te ena afü yi, fü yi amere ngü ka Me areke areke. ");
INSERT INTO muh_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ah ena akoro de körö ka-ye esaka ye, teka afeke jia ndo ka-ye di. Te engu feke ndo ka-ye eyi la, fü ah aza nzïnzïla la, ao agbü kafa. Fü engu akö caca na la, abu agbü mene wa, te ünü nda kü de.” Dela kpeke ngü ka Me ta te Yüwane Mürü Babatïza ngbü erï wü kpara di. ");
INSERT INTO muh_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Fütanga ngü la, fü Yesu ayia agbü *Galïlaya, anü akoro kpaka *Yüwane agbü ngu Yürüdene, teka aza *babatïza. ");
INSERT INTO muh_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Te Yüwane wu ngü la bala, fü ah angbü de fïngangü teka ngü ka Yesu la, angü ngü la tï gbü jijia de. Fü ah amala fü Yesu, gü ba, “Mere kpara, ah tï fere ato babatïza fü mü me-ra de. Ah le ta fü ra aza babatïza ngbürü esaka mü, angü mü de mere kpara fere.” ");
INSERT INTO muh_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Fü Yesu alügü ngü fefe, gü ba, “Bala de. Ye to babatïza eto fü ni. Ah le fü ngü la amere te-ye enatikine, angü Me le ngü la me-ye bala.” Te Yüwane je ngü la bala, fü ah adu ale. Fü ewü arï agbü ngu, fü Yüwane ato babatïza fü Yesu. ");
INSERT INTO muh_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Te Yesu koro tete gbü ngu, enü kpa füh gümba, fü ah aceka kpï bane de, gbo! te kpï te ü te-ye. Fü *Nzïla Wazi Me akoro agbü kpï baka mö, arü gbü nzönzö. ");
INSERT INTO muh_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Fü ri Me ayia awü agbü kpï, gü ba, “Dene zu Ye ra, te ma o maguma ra eküküte. Ngü kaka reke gbü jia ra ꞌduwa ba-neh-ene-la.” Dela ngü te mere te-ye, te Yesu za babatïza tete esaka Yüwane. ");
INSERT INTO muh_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Fütanga ngü te *Yüwane to *babatïza fü Yesu nza tete, fü *Nzïla Wazi Me ayia aza Yesu, anü di kpa etü gü, teka de *Satana re engu kpala. ");
INSERT INTO muh_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Fü Yesu ara kpa etü gü kpala sïkpï teke ꞌbasu, ah zü e nda de. Fü tala ayia amere engu kpala afa sü. ");
INSERT INTO muh_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fü Satana ayia akoro kpaka Yesu, amala ngü fefe, gü ba, “Te mü zu de Ye Me fanü fanü la, mü fü la wü teme ne, de wüh koro zü-e, fü mü azü.” ");
INSERT INTO muh_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu gü ba, “Mü fï, gü ba, ngü te ena aküwa kpara, ah bü duu de zü-e? *Ngari Me gü neh fe? E te ena aküwa kpara fanü fanü, ah ka-ye de ngü ka Me.” ");
INSERT INTO muh_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Fü Satana adu afï nga gara mani. Fü ah adu aza Yesu, anü di agbü Yerüsalema, alï ake di kpa enzö *Mere Kambü ka Me kpa tikpi, ");
INSERT INTO muh_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","agü ba, “Te mü zu de Ye Me fanü la, mü ce la te-mü, mü tï kpa kötö. Gara ngü tï amere mü de, angü wüh ba ta gbü Ngari Me, gü ba, ‘Me ena atima wü *malayïka ka-ye, teka ale ta-ngü te mü. Wüh ena akoro abï mü esaka wü, mü tï amo lö mü eküte teme de.’ ” ");
INSERT INTO muh_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Fü Yesu alügü ngü fefe, gü ba, “Bala de. Wüh ba ta gbü Ngari Me kpah eyi, gü ba, ‘Mü mere e are maguma Mere Me de.’ ” ");
INSERT INTO muh_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Fütanga ngü la, fü Satana adu kpah aza Yesu, anü di kpa füh mere rüvü kpa tikpi, asere nga nzö wü sü füh kotö ne, de züka wü ngü ka kotö ne ꞌburu fefe na, ");
INSERT INTO muh_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","agü ba, “Te ye tï kötö, acu ngü ni ba me ka-ye la, ni ena ato wü e la ꞌburu fü ye.” ");
INSERT INTO muh_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Te Yesu je ngü la bala, fü ah amala ngü fefe, gü ba, “Satana, mü ce ra ace! Angü Ngari Me mala eyi, gü ba, ‘Mü di ecu nzö ngü Mere Me kpikpi ye, de mü di emere duu rïrï kaka.’ ” ");
INSERT INTO muh_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Te Satana je ngü la bala, fü ah ayia ace la mba Yesu. Fü wü *malayïka ka Me akoro teka ale ta-ngü te Yesu. ");
INSERT INTO muh_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Fütanga ngü la, fü Miri Anïtïpa *Erode azoro *Yüwane, agü agbü ku. Te Yesu yia agbü gü la du koro tete, fü ah aje nga Yüwane bala, fü ah ayia ace sü la, adu ka-ye agbü *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ah du ngbü agbü Nazareta nda-ye tïne de. Ah go ngbü ka-ye agbü Kaparanama, te di era mere ngu de ïrï ye Galïlaya. Tö la, ah ta de sü, te nguwa wü Nafatalï, bete nguwa wü Zebulona ngbü tete. Fü Yesu angbü endoro gbü wü sü la, da emala to ngü ka Me fü wü kpara de kpala. ");
INSERT INTO muh_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngü la tï kpini de ngü ta te *mürü dofo Yïsaya ba gbü *Ngari Me gügü, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Me ena amere züka ngü fü wü kpara gbü tö ka Zebulona bete nda Nafatalï, te ewü ngbü engbü eta ngu Yürüdene, era mere ngu, agbü tö ka Galïlaya, esüka wü *ganzi kpara ne. ");
INSERT INTO muh_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Angü, teka mere bi re, wü kpara la ngbü ka-wü ta gbü mere cïnga ka *siti ngü, gbü siti ngbami ka kpi, angü wüh wu ngü ka Me ta nda-wü de. Amba tïtïne wüh küwa eyi, angü Mere Miri koro eyi kpaka ewü, teka aü fïngangü ka-ewü.” Dela ngü ta te Yïsaya ba teka tö ka Galïlaya. ");
INSERT INTO muh_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Te Yesu ngbü endoro agbü Galïlaya kpala, ah ngbü da emala to ngü ka Me fü wü kpara, gü ba, “Ah le de wü fü maguma wü, angü Miri te Me tima, teka aküwa wü, koro eyi.” ");
INSERT INTO muh_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gbü gara ra, fü Yesu ayia anü andoro edere mere ngu de ïrï ye Galïlaya. Fü engu awu wü gara komoko ꞌbasu, te ewü ngbü egü yïmba ka-wü gbü ngu teka azoro si, angü ah de tima ka-ewü. Ah de Sïmüna Petero ake enga ni ye, de ïrï ye Anderïya. ");
INSERT INTO muh_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Fü Yesu arü amala ngü fü ewü, gü ba, “Yi nü kpakine, yi lala gbü nga ra. Ma ena ao yi, teka angbü efü wü kpara, de wüh le ngü ka Me, da tima ka si te yi ngbü emere ne.” ");
INSERT INTO muh_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Te wüh je ngü la bala, fü ewü ayia ace tima ka si ka-wü la, te wüh ngbü emere la, adu alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Fü wü Yesu ayia sela, anü kpa engagira nü mba cüküꞌdaye. Fü ewü anü amaka kpah wü gara kpara ꞌbasu. Ah de wü *Yakobo ake *Yüwane, wü di Zebedayo. Wüh ngbü ta de wü wö wü gbü *zabu, da ekpokpo jia yïmba ka-wü. Fü Yesu adu aï ewü kpah bala. ");
INSERT INTO muh_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Fü ewü ayia ace wö wü, de wü zabu ka-wü la sela, anü ka-wü, alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Gbü wü sïkpï la, Yesu ngbü ta endoro gbü nzö kötï ka *Galïlaya ꞌburu, da erï wü kpara de to ngü ka Me, kpa *esambü ka biti-te ka-ewü. Ah ngbü ta emala ngü ka *küküwa te Me tima fü ewü ne, kpah da eküwa wü kpara gbü wü keke ka-wü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Teka ngü la, fü nga Yesu awü gbü sü la ꞌburu, akoro zalü agbü tö ka Sïrïya. Te di bala, fü wü kpara angbü eza wü kpara de wü keke ka-wü kpikpi ye kpikpi ye, enü ekoro di kpaka Yesu. Gara ewü de *siti wü di enga me guvu wü, gara ewü te kö-nürü ngbü emere ewü, de mene ewü te küte ewü kpi akpi, ngbü walawala, kpah bete mene ewü te küte ewü ngbü eke efa sü. Wüh ngbü koro de wü kpara la ꞌburu kpaka Yesu, fü engu angbü eküwa ewü. ");
INSERT INTO muh_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Teka ngü la, fü mere bi wü kpara ka Galïlaya ayia ale ngü ka Yesu, akpo angbü efa nganga. Gara wü kpara koro nda-wü nengete agbü Dekapoli, gara ewü koro agbü Yerüsalema, de wü gara wü kötï ka *Yudaya ꞌburu, gara ewü koro nda-wü kpa eta ngu Yürüdene. Wü kpara la koro ꞌburu teka aje ngü de gömö Yesu la. ");
INSERT INTO muh_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Te Yesu wu mere bi wü kpara, te ewü koro kpaka ye de bala, fü engu ayia alï kpa füh rüvü adu angbü kötö. Fü wü kpara kaka-na ayia akoro angbü edede na kpala. ");
INSERT INTO muh_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Fü Yesu akpo da erï ewü, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wü kpara, te ewü ngbü endaꞌba te-wü engagira Me, ba wü mürü cïnga, wüh ena amaka züka ngü me-wü, angü Me ena aküwa ewü agbü sü ka-ye, agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wü kpara, te ewü ngbü eku gba teka *siti ngü ka-wü, wüh ena amaka züka ngü me-wü, angü Me ena agu maguma ewü me-ye. ");
INSERT INTO muh_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wü kpara te ewü o te-wü ba mere kpara de, wüh ena amaka züka ngü me-wü, angü Me ena ato züka sü fü ewü. ");
INSERT INTO muh_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wü kpara, te ewü o maguma wü ꞌburu teka amere ngü te ena areke gbü jia Me, wüh ena amaka züka ngü me-wü, angü Me ena ato wazi ye fü ewü, teka amere ngü la di. ");
INSERT INTO muh_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mene wü kpara, te ewü ngbü eboro siti ngü ka wü bu ewü, wüh ena amaka züka ngü me-wü, angü Me ena aboro kpah siti ngü ka-ewü. ");
INSERT INTO muh_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wü kpara, te ewü ngbü emere ngü ka Me de maguma wü biringbö, wüh ena amaka züka ngü me-wü, angü wüh ena awu Me cu de jia wü. ");
INSERT INTO muh_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mene wü kpara, te ewü ngbü ereke ngü esüka wü bu wü, wüh ena amaka züka ngü me-wü, angü Me ena ï ewü, wü di ye. ");
INSERT INTO muh_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wü kpara, te wü bu wü ngbü ekpülü ewü, da eto cïnga te ewü, teka te wüh ngbü fï bü da elala gbü ngü ka Me ne, wüh ena amaka züka ngü me-wü, angü Me ena aküwa ewü agbü sü ka-ye, agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Wayi, nda-yi, ah le de yi ngbü fï bü da elala gbü nga ra. Angü, te wü kpara ngbü esoko yi, da ekpülü yi, eto mere cïnga te yi, kpah da emala mere bi wü siti ngü eküte yi de wu, teka ngü ka-ra la, ngü ma, yi ena amaka züka ngü te gara. ");
INSERT INTO muh_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Te wüh mere yi bala, ah le de yi ngbü de zo, kpah de mere tadu! Me ena ato mere bi wü züka ngü fü yi te gara agbü kpï, baka nda wü *mürü dofo ka Me ta gügü ne, angü wüh ngbü ta etüka te-wü kpah bala.” ");
INSERT INTO muh_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “De-yi, wü kpara ka-ra, ah le de yi di emere züka ngü esüka wü kpara füh kotö sene, teka fü yi ato wazi fü ewü, baka ngütü te ngbü ereke wü e. Amba te yi mere wü ngü te ngbü ereke areke gbü jia Me nda-yi de la, yi ena adi baka cambiri ngütü, te mi de. Wüh ena amere de cambiri ngütü la neh ene? Wüh ena aza, abu kpa füh ka, angü tima kaka tïne ma. ");
INSERT INTO muh_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ah le de yi di kpah baka ze-wa, te ena angbü elofo sü fü wü kpara füh kotö sene, teka fü wü kpara ꞌburu adi ewu wü züka ngü te yi ngbü emere ne, baka mere kambü te wüh jï ga füh rüvü, te tï awo te-ye de, angü wü kpara ꞌburu tï eyi awu mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Te mü siya wa gbü biti la, mü ena amere di ne? Mü ena ao esa kuwu? Ah bala de! Mü ena ao mba füh gara e kpa tikpi, teka alofo sü fü wü kpara esambü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Te di bala, ah le fü yi angbü emere wü züka ngü esüka wü kpara füh kotö sene, baka ze-wa te ngbü elofo sü esambü ꞌburu. Te yi mere bala, wü kpara ꞌburu ena agbo nga ïrï Wö yi, Me agbü kpï, teka züka ngü ka-yi, te yi ngbü emere la.” ");
INSERT INTO muh_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Wü gara yi ngbü efï nda-wü, gü ba, ma koro dene teka asiti wü *Rïrï te di gbü *Ngari Me ne? Ah bala de. Ma koro teka asiti wü Rïrï la nda-ra de. Amba ma koro ka-ra teka asere si-ngü gbü wü Rïrï la fü yi, teka fü yi aje mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngü te ma ngbü emala fü yi dene, ah de zu ngü. Ah ele fü yi adi fï bü da emere wü ngü baka te Rïrï ka Me ngbü ele, zalü akoro di gbü *adu sïkpï. Angü ngü ka Me ena angbü fï mere badi, gara ngü te ena afü te-ye gbügbü na, nda ma. ");
INSERT INTO muh_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Teka ngü la, te mü ce gara enga ngü cüküꞌdaye gbü Rïrï ka Me eyi asidi, mü ga, ni le engu la de, fü mü angbü kpah erï wü bu mü de ngü la bala, Me tï ale ngü ka-mü agbü sü ka-ye agbü kpï de. Amba, te mü ngbü emere wü Rïrï ka Me ꞌburu ereke areke, da erï wü bu mü de wüh mere kpah bala la, ngü ka-mü ena areke kpah areke gbü jia Me, fü ah ao mü agbü sü ka-ye agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Dene ngü te ma le amala fü yi, te yi le angbü kpara ka Me la, ah le de yi di emere wü ngü, te ena angbü ereke gbü jia Me, afa nda wü *Farusi de wü *mürü rïrï ka. Angü wü Farusi de wü mürü rïrï ngbü efï nda-wü, gü ba, ani de züka wü kpara ka Me me-ani. Amba wüh ngbü emala ngü la bü de komö wü kükürü. Nda-yi, ah le de yi di emere ngü ka Me de maguma yi ꞌburu, afa nda wü Farusi di ka.” ");
INSERT INTO muh_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “*Rïrï ka Me ta te *Müse mala nganga fü wü kundu nih ne, yi je nda-yi de? Engu gü ba, ‘Mü mere e amörö kpara de, angü ngü la esiti gbü jia Me.’ Fü wü kundu nih adu amala, gü ba, ‘Mene kpara te ena amörö kiri ye, wüh ena ato kuru tete.’ ");
INSERT INTO muh_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nda-ra, ngü te ma le amala fü yi, ah bü duu ngü ka mamörö kpara de. Amba te mü ngbü ekpü enga ni mü la, ngü la kpah esiti gbü jia Me. Wüh ena ato kpah kuru te mü. Baka te mü ena asoko kiri mü, gü ba, ‘Ye de töndö kpara,’ la, wüh ena akolo ngü ka-mü. Anga te mü ena afala kiri mü, gü ba, ‘Ye röfö aröfö,’ la, wüh ena agü mü agbü du ka wa! ");
INSERT INTO muh_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mü mere e ato takpa fü Me de siti fïngangü emaguma mü de! Te mü ngbü enü kpa esambü ka Me teka ato takpa fü mere Me, fü mü adu afï nga gara ngü amaka, te di ezengba yi ake kiri mü la, ");
INSERT INTO muh_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","te di bala, ah le fü mü ace takpa ka-mü la ciki ede *cangalï kpala, de mü yia kere, mü nü kpaka kiri mü la, areke ngü la esüka yi feke, fü mü adu ato takpa ka-mü la fü Me. ");
INSERT INTO muh_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Te ngü ladü esüka yi ake kiri mü füh kotö sene, ah le de yi reke ngü esüka yi kere, angü Me wu ngü la kpo! Angü te mü kpi eyi la, Me ena adu akolo ngü la tïne me-ye! Ma emala fü yi dene zu ngü! Me ena ato mü esaka wü *malayïka ka-ye, fü ewü agü mü agbü du ka wa fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “*Rïrï ka Me, ta te *Müse mala nganga fü wü kundu nih, gü ba, ‘Mü mere e amere waza de, angü ngü la, ah esiti gbü jia Me ne,’ yi je ngü la nda-yi de? ");
INSERT INTO muh_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amba nda-ra, ngü te ma le amala fü yi, baka to ngü füh ngü la, ah dene. Te mü ngbü efï nga würüse, da ekpi gügümü emaguma mü la, ah kpah esiti gbü jia Me, angü ah ba e te mü mere waza eyi ake di emaguma mü. ");
INSERT INTO muh_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yi di ekpe *siti ngü akpe! Te jia mü ngbü efiti mü me-ye, teka fü mü atï gbü siti ngü la, ah le fü mü agbi jia mü engu la, agü kötö. Angü ah ena areke pe, te gara e biringbö eküte mü kpi me-ye la, ka mene ngü de te wüh ena aza mü de küte mü ꞌburu, agü agbü mere du ka wa ne. ");
INSERT INTO muh_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Te kpa mü ngbü efiti mü me-ye, teka fü mü atï gbü siti ngü la, ah le de mü wa kpa mü engu la awa, mü gü kötö. Angü ah ena areke pe, te gara e biringbö eküte mü kpi me-ye la, ka mene ngü te wüh ena aza mü de küte mü ꞌburu, agü agbü mere du ka wa ne.” ");
INSERT INTO muh_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Rïrï ka wü kundu nih, gü ba, ‘Te komoko le ace wara ye la, ah le de engu ba köcökpa, ato fü wara ye feke, fü wara ka na ayia ago ka-ye agba wü.’ ");
INSERT INTO muh_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nda-ra, ngü te ma le amala fü yi dene, ah de to ngü. Te kpara ce wara ye bü kükürü bala, ah teka ngü ka waza de la, ah mere *siti ngü eyi gbü jia Me. Angü te würüse la ena anü aza gara komoko te gara la, ngü la ena adi gbü jia Me baka waza, angü mü to engu dela me-mü, de ah mere waza. Kpah bala, komoko te za würüse, te watï ye na ce engu la, ah mere waza kpah eyi gbü jia Me.” ");
INSERT INTO muh_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Rïrï ka wü kundu nih, gü ba, ‘Te mü kïna te-mü te ïrï Me la, mü mere e ace ngü la de. Mü mere ngü la amere, gegege baka kïna te mü kïna te-mü di la, angü mü mala ngü la eyi gbü jia Me.’ Yi wu ngü la bala de? ");
INSERT INTO muh_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Amba nda-ra, ngü te ma le amala fü yi dene, ah de to ngü, gü ba, yi mere e akïna te-yi ꞌburu ꞌburu de. Mü mere e akïna te-mü te ïrï kpï kpah de, angü kpï ka-ye de sü ka Me. Mü mere e akïna te-mü te ïrï kotö ne kpah de, angü kotö ne ka-ye de e ka Me, te engu mere o me-ye. Mü mere e akïna te-mü te ïrï Yerüsalema kpah de, angü Yerüsalema de mere kötï ka Mere Miri Me. Mü mere e akïna ngürü mü, anga lö mü kpah de, angü küte mü ꞌburu de e ka-mü nda de, ah de e ka Me, te engu mere me-ye. Ah le de mü mala ngü bü mbölö. Te mü le ngü la eyi, mü mala, gü ba, ‘Wayi, ni ena amere bala.’ Te mü le de, mü mala kpah mbölö, gü ba, ‘Ni tï amere bala de.’ Angü, te mü mala mere bi wü ngü ngïlï di angïlï, teka afiti kiri mü di la, dela ka-ye ngü te koro esaka *Satana. Ngü ꞌburu te mü mala, gü ba, ni ena amere, mü mere e ace ngü la de, angü Me wu ngü la eyi. Ah le de mü mere ngü la amere bala.” ");
INSERT INTO muh_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Rïrï ka wü kundu nih, gü ba, ‘Te kpara sö jia mü mbürü la, ah le de mü za engu, nü di kpaka wü *kovo de wüh sö kpah jijia. Anga te kpara mï te mü, kürü la, wüh ena akürü kpah nda-ka.’ Yi wu ngü la bala gügü de? ");
INSERT INTO muh_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nda-ra, ngü te ma le amala fü yi dene, ah de to ngü, gü ba, yi mere e alügü siti ngü fü wü bu yi de. Yi mere e amere gü kpaka kpara, anga vügü te mere mü esiti ne, kpah de. Te kpara be gbüra mü la, mü mere e asü gü fefe de. Mü ce gbüra mü fefe, de ah du, ah be kpah toto. ");
INSERT INTO muh_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Te kpara ï mü engagira miri, gü ba, mü to bongo ka-mü biringbö, na jiase ka-ni esaka mü la, mü mere e asü gü fefe de. Mü za gara bongo ka-mü, be kpah te gara la, mü to fefe. ");
INSERT INTO muh_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Te marajümïya za mü de wazi, teka anü abï e ka-ye baka kilometere biringbö la, mü mere e asü gü fefe de. De mü gï nganga de e kaka la kilometere ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Te kpara yo e eküte mü la, de mü to e la fefe. Te kpara le aza matiti esaka mü, mü mere e afï nga ngü de. Mü to matiti la eto fefe.” ");
INSERT INTO muh_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Rïrï ka wü kundu nih, gü ba, ‘Ah le de mü le wü mürü mü, fü mü adu akpü wü vügü ka-mü.’ Yi wu ngü la bala gügü de? ");
INSERT INTO muh_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nda-ra, ngü te ma le emala fü yi dene, ah de to ngü, gü ba, ah le de yi le kpah vügü ka-yi ale. Kpah bala, te gara kpara ngbü emere mü esiti la, de mü di kpah eyi-ta Me tekaka, de Me boro *siti ngü kaka. ");
INSERT INTO muh_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kükürü de, angü te yi mere bala, wü kpara ena awu, gü ba, yi de wü di Me fanü fanü, angü mü ngbü emere züka ngü kpah baka nda Me. Angü Me ngbü eto agö, de ah di elï agbü yï ka züka wü kpara, be kpah te nda siti wü kpara. Me to kpah ra, de ah di esü fü züka wü kpara, kpah fü siti wü kpara ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Anga te yi ngbü ele bü nzö mene wü kpara te ewü ngbü ele ngü ka-yi ne, yi efï, gü ba, Me ena ato züka ngü fü ani teka ngü la? Aꞌa, ah bala de. Angü wü siti kpara, te ewü le ngü ka Me de ne, wüh ngbü emere ngü de bala me-wü. ");
INSERT INTO muh_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Te yi ngbü emere züka ngü bü nzö fü wü di enga ni yi la, yi efï, gü ba, Me ena agbo nga ïrï ani teka ngü la? Aꞌa, ah bala de. Angü siti wü kpara, te ewü le ngü ka Me de ne, wüh ngbü emere züka ngü bü nzö fü wü bu wü bala me-wü. ");
INSERT INTO muh_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dela ngü te ma le amala fü yi, gü ba, ah le de yi di ele wü kpara ꞌburu, da emere züka ngü fü ewü de züka maguma yi, kpah baka te Wö yi, Me agbü kpï, ngbü emere fü yi ne.” ");
INSERT INTO muh_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Fü Yesu adu amala gara ngü fü wü kpara ka-ye, gü ba dene, “Wü di enga wüna, yi ceka te-yi ꞌbe! Te yi le amere züka ngü te ïrï Me la, yi mere e adi emere ngü la gbü jia wü kpara de. Angü, te mü mere ngü la gbü jia wü kpara, teka fü ewü agbo nga ïrï ni di la, ngü ka-mü la tï areke gbü jia Me nda de. Te di bala, Me tï agbo nga mü, ato takpa fü mü gbü ngü la, nda de. ");
INSERT INTO muh_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Te di bala, te mü le ale ta-ngü te wü mürü cïnga la, mü mere e amere ngü la gbü jia wü kpara de. Angü wü kpara ladü te ewü le, de wü bu ani di eceka ani ba züka wü kpara ka Me. Teka ngü la, te ewü le ato e fü wü mürü cïnga la, wüh ngbü emere ngü la te wü kaje, anga kpa *esambü ka biti-te, fü ewü angbü eba wü rere de ngü ka-wü la, teka fü wü kpara ꞌburu awu ani, adi egbo nga ïrï ani tete. Fanü fanü, ma emala fü yi dene zu ngü, gü ba, te wü kpara gbo nga ïrï ewü eyi teka ngü la, Me tï agbo nga ewü nda tïne de, angü wüh maka takpa ka-wü eyi kpaka wü kpara. ");
INSERT INTO muh_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amba nda-yi, wü kpara ka-ra, te yi ele ato e ka-yi fü wü mürü cïnga la, yi mere e amala nga ngü la fü gara kpara de, anga te ah zu de enga ni mü la, mü mala fefe kpah de. ");
INSERT INTO muh_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mü to e la esalakumu, angü Me wu wü ngü ꞌburu. Te di bala, Me wu e te mü to fü wü mürü cïnga la eyi. Engu ena adu ato züka ngü fü mü te gara me-ye.” ");
INSERT INTO muh_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Wü di enga wüna, ma emala fü yi, gü ba, te mü ele aku gba fü Me la, mü mere e amere ngü la gbü jia wü kpara de. Angü wü gara kpara ladü te ewü le, de wü bu ani ceka ani ba züka kpara ka Me. Te di bala, wüh ngbü nda-wü erü tikpi, adi eku gba fü Me gbü jia mere bi wü kpara kpa *esambü ka biti-te, anga te nga wü kaje, teka fü wü kpara angbü eceka ani. Ma ngbü emala fü yi dene zu ngü. Wü kpara ena agbo nga ïrï ewü teka ngü la, amba Me tï agbo nga ewü teka ngü la nda de. ");
INSERT INTO muh_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amba nda-mü, te mü ele ayi-ta Me la, ah le de mü ku gba fü Me esalakumu. De mü rï ka-mü kpa esambü kpikpi mü, ni mö nga mü ani, anga de mü nü, mü gïrï sü, te mü ena ayi-ta Me tete kpikpi mü, angü engu de Wö nih. Te mü ku gba fü Me esalakumu bala, Me ena agbo nga mü me-ye, angü engu wu ngü te di emaguma mü la kpo. ");
INSERT INTO muh_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kpah bala, te yi ngbü eku gba fü Me la, yi mere e adi emala bi wü ngü de. Wü kpara te ewü ngbü eku gba fü wü di enga me, wüh ngbü esama mere bi wü töndö ngü gömö wü de bala me-wü, angü wüh efï nda-wü, gü ba, ‘Me ngbü eje gba ka-ani, teka mere bi wü ngü ka-ani la.’ ");
INSERT INTO muh_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yi mere e adi emere ngü baka nda-ewü la de, angü Me de Wö yi. Engu wu wü ngü te yi ngbü ele kpakaka na ne eyi gügü, o yi mala nganga fefe la de. ");
INSERT INTO muh_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Te di bala, dene kaje te yi ena aku gba fü Me tete na. Wayi bala Wö a Me. Mü de mere Me te mü di agbü kpï. Ah le de wü kpara ꞌburu gbo nga ïrï mü, angü mü de Me biringbö. ");
INSERT INTO muh_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mü koro angbü gbü nzö wü kpara füh kotö ne ꞌburu. De wü kpara ꞌburu di eje rïrï ka-mü. De wüh di emere wü ngü te mü ele füh kotö ne ꞌburu, kpah baka e te ewü emere agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","De mü to zü-e fü a enatikine de a zü. ");
INSERT INTO muh_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","De mü boro *siti ngü ka-a emaguma mü asidi, angü angbü kpah eboro siti ngü ka wü bu a fü ewü. ");
INSERT INTO muh_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mü to wazi fü a, fü a arü di kpekpeke gbü re-ngü ka *Satana, angü a ena adürü. De mü küwa a aküwa esaka Satana. A yi-ta mü de wü ngü la, teka ne de, angü mü de mere Miri ka-a. Mü de mere wazi fa wü kpara ꞌburu. Mü de mere kpara te ewü egbo nga ïrï mü fï mere badi. Ah di bala. ");
INSERT INTO muh_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wü di enga wüna, ah le de yi di eboro siti ngü ka wü bu yi aboro, angü te yi boro siti ngü ka wü bu yi la, Wö yi, Me agbü kpï, ena aboro kpah siti ngü ka-yi. ");
INSERT INTO muh_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amba te yi boro siti ngü ka wü bu yi de, Wö yi, Me agbü kpï ne, tï aboro siti ngü ka-yi kpah de.” ");
INSERT INTO muh_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Wü di enga wüna, te yi le *aꞌbï te-yi, teka aku gba fü Me la, yi mere e asere te-yi gbü jia wü kpara, gü ba, ani ngbü eꞌbï te-ani ne de. Angü wü gara kpara ladü, te ewü le, de wü bu ani di eceka ani ba züka wü kpara ka Me. Te di bala, te ewü ngbü eꞌbï te-wü la, wüh ngbü engbü de mere cïnga, teka fü wü kpara awu ngü la, fü ewü agbo nga ïrï ani tete. Yi mere e amere ngü baka nda-ewü la de! Angü, te yi le de wü kpara di egbo nga ïrï ani la, ngü la gbü jia Me ka-ye esiti! Ma ngbü emala fü yi dene zu ngü. Te wü kpara gbo nga ïrï yi teka ngü la, Me tï agbo nga yi nda tïne de! ");
INSERT INTO muh_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amba nda-yi, te yi le aꞌbï te-yi, teka aku gba fü Me la, ah le de yi zürü gbüra yi azürü, de yi gü mü eküte yi. ");
INSERT INTO muh_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yi reke te-yi areke, ba kpara te ngbü de tadu, angü wü kpara ena awu, gü ba, yi ngbü eꞌbï te-yi. Te yi mere ngü la esalakumu bala la, Me ena awu ngü te di emaguma yi la me-ye, fü engu agbo nga yi.” ");
INSERT INTO muh_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Yi mere e ao maguma yi teka wü e füh kotö ne de, angü wü e füh kotö ne ena anza ka-wü anza. Wü gara ena agörö, wü ka ena alafa wü gara, wü gara ena akï, wü gara ena azi, wü mürü zi ena azi wü gara. ");
INSERT INTO muh_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Amba ah le fü yi ato maguma yi teka adi emere ngü ka Me, fü yi ao fïngangü ka-yi ꞌburu teka züka ngü te yi ena amaka agbü kpï, angü ngü ka Me tï anza nda de. ");
INSERT INTO muh_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jia nih ka-ye baka ze-wa te ngbü elofo sü fü nih. Te mü o fïngangü ka-mü ꞌburu teka ngü ka Me la, Me ena asere züka kaje fü mü, fü mü amaka züka ngü. Angü mü ena angbü baka kpara te ngbü endoro gbü ra-sü. ");
INSERT INTO muh_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amba, te mü ngbü de siti fïngangü emaguma mü, da edürü te kaje ka Me asidi, teka wü e de füh kotö ne la, mü baka kpara te jijia ni ani, te ngbü endoro gbü mbiri sü. Mü ceka te mü ꞌbe, angü te mü le ngü ka Me de maguma mü ꞌbasu ꞌbasu la, ah ena adi gegege ba e te jia mü ni ani la. Mü ena adürü te kaje ka Me asidi, mü tï awu ngü ka Me ꞌburu ꞌburu de, angü mü ngbü endoro gbü ngbami! ");
INSERT INTO muh_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yi ce ngü ka maguma ꞌbasu ꞌbasu asidi, angü kpara biringbö tï ara fü wü miri ꞌbasu nda kü de. Angü mü ena ale ngü ka gara, fü mü ace nda gara. Te mü ngbü eje rïrï ka gara ereke areke, mü ena angbü efala gara la afala. Te di bala, ah le de yi o maguma yi ꞌburu, teka adi emere ngü ka Me. Amba yi mere e ao maguma yi teka wü e füh kotö ne de.” ");
INSERT INTO muh_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Dene ngü te ma le amala fü yi, wü di enga wüna. Yi mere e asiti fïngangü ka-yi, teka ngü ka e-mazü, anga e-manzö nda-yi de. Angü Me le yi fa sü. Anga yi mere e angbü de mere fïngangü teka bongo te yi ena amaka, adi eto eküte yi ne, kpah de. Ngü ka küte yi fa ngü ka bongo ka. Te di bala, Wö nih Me, te o nih ne, ah tï ato wü e la fü nih de? Ah tï eyi ato wü e la fü nih, angü engu le nih fa sü. Kpah bala, ngü ka *küküwa fa ngü ka zü-e ka. Me te ngbü eküwa nih ne, ah ena adi kpah eto zü-e fü nih me-ye. ");
INSERT INTO muh_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yi ceka la bü wü lu, te wüh ru e kpah de, wüh biti wü e fü wü kpah de, kafa ka-ewü kpah ma. Amba Me ce ewü nda de! Ah ngbü fï bü eto zü-e fü ewü! Yi efï nda-yi, gü ba, ngü ka-ani fa ngü ka wü lu la de? Me tï ace yi, fü yi akpi ka tala de. ");
INSERT INTO muh_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Te sïkpï ka kpi ka-mü koro eyi la, wazi mü ladü teka afa te-mü esaka kpi la, fü mü adu angbü acï nga gara sïkpï? Aꞌa, wazi mü nda ma! ");
INSERT INTO muh_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Fïngangü ka-yi mere e asiti teka ngü ka bongo de. Yi ceka la wü yi-rü, wüh ngbü ekoro neh baye baye? Baka te wüh mere tima ꞌburu de, wüh reke bongo tüngü wü kpah de ne. ");
INSERT INTO muh_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma emala fü yi dene zu ngü. Miri *Solomona, ta te di de mere bi wü e esaka ye ne, bongo kaka-na su baka yi-rü agbü gü ne, kpah de. ");
INSERT INTO muh_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Yi wu eyi, gü ba, Me ngbü ereke wü yi-rü eküte wü rü, baka züka bongo te su asu fa sü. Fïngangü ka-yi gü ba, ngü ka-ani fa ngü ka wü yi-rü la de? Yi wu awu, gü ba, Me tï eyi ato züka bongo fü ani. Te di bala, ah le de yi to maguma yi ꞌburu fü Me. ");
INSERT INTO muh_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yi mere e angbü esiti fïngangü ka-yi, teka wü e te yi ena azü, anga e te yi ena anzö, anga bongo te yi ena ato eküte yi ne, nda-yi de. Ah le de yi to maguma yi ꞌburu fü Me. Yi mere e angbü de maguma yi ꞌbasu ꞌbasu de. ");
INSERT INTO muh_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Wü kpara te ewü wu ngü ka Me de ne, wüh ngbü eo to wü teka wü e füh kotö ne bala me-wü. Amba nda-yi, yi mere e adi emere ngü bala de, angü Wö yi, Me, ladü. Ah ena ato wü e la fü yi me-ye, angü ah wu kpo, gü ba, cïnga wü e la ngbü emere yi. ");
INSERT INTO muh_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Te di bala, yi to maguma yi fü Me feke, da emere tima kaka, angü wü e de te yi ngbü efï nga ewü la, Me ena adu ato fü yi. ");
INSERT INTO muh_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wü di enga wüna, te yi te engbü la, yi mere e asiti fïngangü ka-yi, teka ngü te ena adi egambi ne de. Angü ngü te ena akoro de egambi la, ah ena amere te-ye ka-ye bü teka sïkpï engu la. Yi ce ngü ka gambi la esaka Me, angü gbü wü sïkpï ꞌburu cïnga ka-ye fï bü ladü.” ");
INSERT INTO muh_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","2","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Wü di enga wüna, yi mere e adi esiti ïrï wü bu yi, da ekolo ngü ka-ewü, de. Angü Me ena akolo ngü ka-yi te gara, kpah ba e te yi ngbü emere fü wü bu yi la. ");
INSERT INTO muh_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Wü di enga wüna, yi ngbü emala nga wü *siti ngü ka wü bu yi, da ekolo ngü ka-ewü neh teka ne? Ah le de yi fï nga siti ngü ka-yi te enga gina. Angü te mü le aza enga ca-gü gbü jia enga ni mü, o mere ndugu rü di ladü gbü jia mü la, ah de züka ngü? ");
INSERT INTO muh_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mü dela mürü mani! Angü te enga gina, ah le fü mü agbi la mere ndugu rü, te di gbü jia mü ne, feke, teka fü jia mü alofo raaa! Fü mü adu tïne, aza enga ca-gü, te di gbü jia enga ni mü ne sidi. ");
INSERT INTO muh_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Te yi to jiase ka-yi fü wü bürü anga wü mba la, wüh ena ale? Aꞌa, wüh tï ale nda-wü de. Wüh ena aceka jiase la gbü jia wü baka töndö e, angü tima ka e la fü ewü nda ma. Wü bürü ena adu anyüma yi, fü wü mba adu adoto wü e la, asiti ka. Kpah bala, te yi ngbü erï wü bu yi de *Ngari Me, fü ewü angbü efala ngü la afala la, yi ce ewü ace. Yi mere e adi fï bü da emala Ngari Me fü ewü de. Angü wüh ka-wü baka wü bürü, de wü mba la.” ");
INSERT INTO muh_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Yi efï nda-yi, gü ba, Me le ato züka ngü fü ani de? Ah bala de. Te cïnga e ngbü emere mü la, mü ngbü fï bü da eyo eküte Me, Me ena ato e la ato fü mü. Mü ngbü fï bü da eyi-tata gbü wü sïkpï ꞌburu. Mü mere e ace da eï engu de, ah ena amere ngü la fü mü. ");
INSERT INTO muh_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Angü wü kpara ꞌburu, te ewü ngbü eyo e te Me ne, Me ngbü eto e la fü ewü ato. Wü kpara ꞌburu, te ewü ngbü egïrï e kpaka Me, wüh ngbü emaka amaka. Me ngbü kpah eü möngïtï fü mene wü kpara, de te wüh ngbü eï engu ne. ");
INSERT INTO muh_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Gara süka yi ladü sene, te di de wö ye wü jaji, te yeye na yo kümü tete la, ah ena aza teme, ato fefe? ");
INSERT INTO muh_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Anga te yeye na yo si tete la, ah ena aza kpürü, ato fefe? ");
INSERT INTO muh_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anga de-yi, te yi di de siti wü kpara ne, yi wu da eto wü züka e fü wü jaji ka-yi ereke areke. Yi fï nda-yi, gü ba, Me, te di de Wö nih agbü kpï ne, ah tï ato züka wü e fü yi afa sü de? ");
INSERT INTO muh_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Te di bala, wü ngü ꞌburu te yi ngbü ele de wü kpara di emere fü ani, ah le de yi di kpah emere wü ngü engu la fü wü kpara bala. Angü dela si-ngü gbü wü *Rïrï, te *Müse, de wü gara wü *mürü dofo, ba gbü *Ngari Me.” ");
INSERT INTO muh_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Te yi ele aküwa la, ah le de yi le ngü ka Me de maguma yi ngbee biringbö, angü wü kaje ladü ꞌbasu. Te di bala, ah le de yi fe kaje ngbee biringbö. Angü gara la, ah de mere kaje, te mere bi wü kpara ngbü enü ꞌburu tete na. Amba mere kaje la, ah de kaje ka *küküwa nda de. Ah ka-ye de kaje, te ena ato kpi fü kpara fï mere badi. Gara kaje engu ne, ah de suzu kaje, te mere bi wü kpara wu mbi mbi de. Ah le de yi o to yi teka amaka suzu kaje la, angü dela mene kaje, te yi ena amaka küküwa gbügbü, fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Yi ceka te-yi mbi, angü wü mürü mani ladü, te ewü ena akoro, asiti fïngangü ka-yi gbü ngü ka Me. Angü wüh ena angbü esu wu fü yi, gü ba, ani ngbü erï yi dela de ngari Me. Amba ngü ka-ewü la, ah de ngari Me nda de, angü maguma ewü ka-ye sisiti baka nda siya. ");
INSERT INTO muh_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yi ena angbü ewu ewü bü teka *siti ngü te ewü ngbü emere, kpah ba e te yi ngbü ewu wü rü ꞌburu teka rï ewü. Mü tï eyi amaka rï manga eküte patra? Anga mü tï eyi amaka rï güwava eküte rü ngenee? ");
INSERT INTO muh_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ah bala de! Rü manga ena arï ꞌduwa rï manga. Rü ngenee ena arï ꞌduwa rï ngenee. Wü züka rü ꞌburu ngbü erï fï bü wü züka rï-rü, te ereke areke ba-neh-ene-la. Nda wü siti rü kpah bala, wüh ngbü erï fï bü siti rï wü eküte wü. ");
INSERT INTO muh_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Züka rü tï arï siti rï-rü eküte ye de. Siti rü tï arï züka rï-rü te ye de. Kpah bala, wü züka kpara ngbü emere züka ngü me-wü. Wü siti kpara ngbü emere nda-wü fï bü siti ngü. ");
INSERT INTO muh_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Te di bala, yi ena awu wü siti mürü wu la teka wü siti ngü ka-ewü, te ewü ngbü emere. Wü rü ꞌburu te ewü rï züka rï wü de, wüh ena ade ewü ade, agü agbü wa. Ngü ka wü mürü wu la ena adi kpah bala.” ");
INSERT INTO muh_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “E-ena aküwa agbü sü ka Me agbü kpï neh wü da? Angü mere bi wü kpara ladü te ewü ngbü eï ra, gü ba, ‘Ma de Miri ka-ani,’ bü kükürü bala. Wüh tï aküwa nda-wü de, angü maguma ewü ka-ye ꞌbasu ꞌbasu. ꞌDuwa wü mene kpara te ewü ngbü emere züka ngü, te reke gbü jia Wüba Me, wüh ena aküwa me-wü. ");
INSERT INTO muh_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kpah bala, gbü *adu sïkpï, te ma ena akolo ngü ka wü kpara tete, mere bi wü kpara ena andaꞌba te-wü fere, gü ba, ‘Mere kpara, ani de wü kpara ka-ra, angü ani ngbü ta eto ngari ra fü wü kpara. Ani ngbü kpah eliki *siti wü di enga me guvu wü kpara te ïrï ra. Ani ngbü ta emere bi wü kpeke ngü te ïrï ra.’ ");
INSERT INTO muh_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amba, de-ra Yesu, ma ena adu amala fü ewü mbölö, gü ba, ‘De-wü deyï, ma le ngü ka-wü de, angü wü le ngü ka-ra nda-wü de! Wü yia sela eyia de töndö ngü ka-wü la! Angü wü de siti wü kpara.’ ");
INSERT INTO muh_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Mene kpara te ngbü eje ngü ka-ra, fü ah angbü kpah elala tete, engu ena adi baka kpeke kpara, te maka züka sü füh ndu-ta. Fü ah ajï kambü ka-ye fefeh. ");
INSERT INTO muh_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fütanga ngü la, fü mere agö ayia alï de mere wege, fü ngu ayia asi. Amba kambü la mürü nda de, angü wüh jï kambü la te züka sü. ");
INSERT INTO muh_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amba te mü le aje ngü ka-ra, te ma ngbü erï mü di ne, de la, mü ena adi baka töndö kpara, te jï kambü ka-ye bü gbü siki, riri na rï gbü tö nda de. ");
INSERT INTO muh_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Te di bala, te mere agö ena alï de mere wege, fü ngu ayia asi la, kambü ka-mü la ena amürü ꞌduwa amürü, ꞌbüwaa! asidi.” ");
INSERT INTO muh_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Dela ngü te Yesu mala fü mere bi wü kpara kpa füh rüvü. Fü ngü kaka la aga gbü jia wü kpara afa sü. Angü kpara te ena arï wü kpara baka nda Yesu la, ah nda ma. ");
INSERT INTO muh_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yesu mala ngü la fü ewü de mere wazi ka Me. Ah mala baka nda wü *mürü rïrï, te ewü ngbü emala diri nga ngü ne, nda de. ");
INSERT INTO muh_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Fütanga ngü la, fü wü Yesu ayia akö kpa füh rüvü la kötö, angbü enü. Fü mere bi wü kpara ayia afa nganga na. ");
INSERT INTO muh_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Te wü Yesu ngbü enü tete, fü gara komoko, de *jiakö eküte ye, ayia akoro kpaka Yesu. Fü engu ayia abu nzökuta ye kötö engagira Yesu, andaꞌba te-ye, gü ba, “Akooo, mere kpara! Ye de mere mürü wazi! Ni ngbü eyi-ta ye, te ah gbü jia ye ꞌbe la, de ye küwa ni gbü keke ne.” ");
INSERT INTO muh_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Fü Yesu ayia ao kpa ye eküte komoko la, gü ba, “Wayi, ma le eyi. Küte mü reke ereke!” Baka te Yesu mala ngü la tete, ꞌduwa fü küküte ayia areke, adu da ye. ");
INSERT INTO muh_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Fü Yesu adu amala ngü fefe, gü ba, “Ye mere e amala nga ngü la fü wü gara kpara de, ye je ngü la eyi? Amba ah le de ye nü enü, ye mere ngü, ta te *Müse ba gbü *Rïrï ka Me ne. Ye za nü, ye nü di kpaka *mürü gele ka Mere Me, de ah wa, ah to fü Me teka ngü la. Teka fü wü kpara ꞌburu awu, gü ba, küte ye reke eyi fanü.” ");
INSERT INTO muh_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Fütanga ngü la, fü wü Yesu ayia anü akoro agbü Kaparanama. Fü gara mere kpara ka wü marajümïya ka wü *Rüma ayia akoro kpaka Yesu, andaꞌba te-ye fefe, ");
INSERT INTO muh_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","agü ba, “Mere kpara, ni koro ayi-ta ye teka de ye küwa gara labï ka-ni, angü keke ngbü emere engu efa sü. Ah ladü kpala, era ara kpa esambü. Wawazi nza eyi ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Fü Yesu alügü ngü fefe, gü ba, “Ni ena anü kpala, aküwa engu.” ");
INSERT INTO muh_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Fü mere wü marajümïya la adu amala ngü fü Yesu, gü ba, “Akooo, mere kpara, ni ka-ni de *ganzi kpara. Ah tï fü ye arï kpa esambü ka-ni nda de, angü rïrï ka gele ka-wü, wü di enga *Yïsarayele, le bala de. Ni wu eyi, gü ba, wazi ye ladü. Te ye mala bü ngü de komö ye la, labï ka-ni la ena aküwa aküwa. ");
INSERT INTO muh_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ni tï kpah eyi awu ngü la bala, angü ni ngbü kpah esa rïrï ka wü mere kpara ka-ni. Kpah bala, wü gara marajümïya ladü, te ewü di esa rïrï ka-ni. Te ni mala ngü fü gara, gü ba, ye nü enü la, ah ena anü kere, baka te ni mala fefe. Anga te ni mala fü gara, gü ba, ye koro ekoro akine la, ah ena akoro kpah kere. Anga te ni mala ngü fü labï ka-ni, gü ba, ye mere ngü ne bane, ah ngbü kpah emere ngü la kere bala, baka te ni mala fefe.” ");
INSERT INTO muh_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Te Yesu je ngü gömö komoko la bala, fü ngü la ayia areke tete afa sü. Fü engu ayia afü te-ye, amala ngü fü mere bi wü kpara, te ewü ngbü efa nga ye ne, agü ba, “Ceka la! Kpara te to maguma ye fere baka komoko la, ma maka füh kotö ne nda-ra la kü de! Ngü te ma ngbü emala fü yi ne, ah de zu ngü. Gbü nguwa nih, wü Yïsarayele, kpara te to maguma ye bala, ah nda ma. Amba ah ka-ye ꞌduwa de komoko la, te di de ganzi kpara ne! ");
INSERT INTO muh_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Te di bala, ma emala fü yi dene zu ngü. Mere bi wü ganzi kpara ena ayia agbü gara wü sü nengete nengete füh kotö ne, akoro angbü tundu agbü sü ka Me, de wü *Abarayama, *Yïsaka bete *Yakobo, wü kundu nih ta gügü ne, me-wü, angü wü ganzi kpara la to maguma wü eyi fere. ");
INSERT INTO muh_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amba mere bi wü di enga Yïsarayele, te ewü ngbü efï, ga, ani de wü kpara ka Me me-ani ne, wüh ena aliki ewü, ato agbü mbiri sü kpa etanü kpala, fü ewü angbü eku gba, da enyüma gbü te wü de mere cïnga, angü wüh le ngü ka-ra de.” ");
INSERT INTO muh_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Fü Yesu adu amala ngü fü mere kpara ka wü marajümïya la, gü ba, “Ah mbi. Mü go ka-mü ego. Labï ka-mü küwa eyi, angü mü to maguma mü eyi fere.” Bü ciki gbü lö-ra engu la, fü labï ka mere marajümïya la ayia aküwa gbü keke la. ");
INSERT INTO muh_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Gbü gara ra, fü wü Yesu anü akoro kpa gba Sïmüna Petero, fü ewü amaka ni ye wara Petero, te ra kötö ka keke, angü küküte na rï ngbü wüwütü bala. ");
INSERT INTO muh_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Fü Yesu ayia azoro kpa würüse la, fü keke la ayia anza. Fü würüse la ayia anü amere kümü, ato fü ewü. ");
INSERT INTO muh_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ah te ekoro etamurago la, fü mere bi wü kpara ayia aza wü mürü keke, bete mene ewü te *siti wü di enga me ngbü emere ewü, akoro de ewü kpaka Yesu. Fü Yesu aliki wü siti wü di enga me la guvu wü kpara la ꞌburu asidi. Fü ah aküwa kpah mere bi wü gara mürü keke la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngü te Yesu küwa mere bi wü mürü keke la, tï kpini de ngü ta te *mürü dofo Yïsaya ba gbü *Ngari Me ta gügü, gü ba, “Miri te Me ena atima ne, ah ena aküwa nih gbü wü keke ka-nih ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Fütanga ngü la, fü mere bi wü kpara aci akoro, abiti te-wü, angbü ede Yesu. Te Yesu wu bala, fü ah ayia amala ngü fü wü kpara ka-ye, gü ba, “Ani lï elï gbü *zabu, anü kpa etangu.” Ah mala bala, angü ah le anü arï ewü kpala. ");
INSERT INTO muh_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wüh la bü ereke te-wü, fü gara *mürü rïrï biri ayia akoro kpaka Yesu, amala ngü fefe, gü ba, “Mere kpara, ni ele afa nga ye, gbü wü sü ꞌburu, te ye ena angbü enü tete. Ni ena alala fï gbü nga ye, ni tï ace nga ye de.” ");
INSERT INTO muh_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Fü Yesu alügü ngü fü komoko la, gü ba, “Ah le de mü wu awu, gü ba, te mü le afa nga ra la, züka ngü te mü ena amaka füh kotö ne nda ma. Angü de-ra, *Ye Kpara ka Kpï, sü fere füh kotö sene, teka ara, afe te-ra tete, nda ma. Angü wü zaza ngbü era nda-wü gbü wü gö ka-wü. Wü lu ngbü era nda-wü kpah gbü wü suta ka-wü. Amba nda-ra sü fere bala nda ma.” Te komoko la je ngü la bala, fü ah adu ace da efa nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Fütanga ngü la, fü gara *kpara ka Yesu biringbö, ayia amala ngü fefe, gü ba, “Mere kpara, wö ni gbe eyi. Ni le adu acï nganga. Te ah kpi eyi la, fü ni ati engu feke, fü ni adu akoro afa nga ye sidi.” ");
INSERT INTO muh_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Fü Yesu amala ngü fefe, gü ba, “Mü ce wü di enga ni mü, te ewü le ngü ka-ra de ne, de wüh ti wö mü me-wü, angü wüh ka-wü eyi baka wü kövö. Amba nda-mü, mü koro, mü lala gbü nga ra.” ");
INSERT INTO muh_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Fütanga ngü la, fü Yesu ayia de wü kpara ka-ye, alï gbü *zabu, teka anü kpa etangu mere ngu *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Baka te ewü yia, nü la mba ce bane, wüh te eje kpala de, gbu gbu gbu! mere wege te ekoro, da efe jia ngu la de wazi. Fü zabu akpo da eyiki, efüfü te-ye, da ekolo ngu gbü ye efa sü. Zabu la yia ta ebu ewü abu agbü ngu. Amba Yesu, mü ngbü ka-mü era ara. ");
INSERT INTO muh_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Fü wü kpara ka Yesu ayia akoro azükü engu, amala ngü fefe, gü ba, “Mere kpara, mere kpara! Ani te ekpi! Ani te ekpi! Ye zükü la ezükü, de ye küwa ani!” ");
INSERT INTO muh_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Fü Yesu ayia azükü, amala ngü fü ewü, gü ba, “Yi ekpe neh cürü ne? Yi to maguma yi fere mbi mbi la fï de?” Fü engu ayia arü, atata wege ake mere ngu la, gü ba, “Wüh nga anga.” Fü sü ayia anga ꞌduwa, ngbiii! ");
INSERT INTO muh_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Fü ngü la aga gbü jia wü kpara ka Yesu la afa sü, fü ewü angbü emala ngü esüka wü, gü ba, “Apa! De bane neh ene ngü ne? Mene komoko ne, neh baye baye, te engu ngbü emala ngü bü de komö ye, fü wege ake ngu angbü eje riri na ne?” Dela ngü ta te Yesu mere, te engu to rïrï fü mere wege tete. ");
INSERT INTO muh_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Te wü Yesu kö mere ngu la tete de wü kpara ka-ye, fü ewü anü akoro agbü gara sü de ïrï ye Gadara. Baka te ewü ngbü la enü tete, fü ewü amaka te-wü de wü mürü maröfö ꞌbasu, te *siti wü di enga me ngbü emere ewü kpekpeke efa sü, eküte ewü dela gü tïne de! Wüh ngbü ta engbü ka-wü etü wü mbükü. Te di bala, wü kpara tï aguru sü te kaje engu la tïne de, teka ngü ka-ewü. ");
INSERT INTO muh_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Te wü mürü maröfö la wu Yesu te ngbü ekoro, fü ewü ayia akpo eba rere, da emala ngü fü Yesu, de mere ri wü kpa tikpi, gü ba, “De-ye, Ye Mere Me, ye ele amere de ani ne ngü ne? Ye le ato kuru te ani bü gügü, o *adu sïkpï koro la de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Amba mere bi wü mba ka kötï ta ladü gbamari gbü sü la, da ezü e ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Fü wü di enga me la afüwa te-wü fü Yesu, gü ba, “Te ye le aliki ani guvu wü kpara ne asidi la, de ye tima ani, fü ani anü arï guvu wü mba la.” ");
INSERT INTO muh_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Fü Yesu ayia ale ngü ka-ewü la, amala ngü fü ewü, gü ba, “Wayi, wü nü enü, wü rï aguvu wü mba la.” Fü wü di enga me la akoro guvu wü kpara ꞌbasu ne, anü arï aguvu wü mba la. Te di bala, fü wü mba la aci ꞌburu de mere woro, yurrru! ago kpa esa gö, agürü agbü mere ngu. Fü ewü anzö ngu, akpi ꞌburu kpala. ");
INSERT INTO muh_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Te wü kpara, de te ewü ngbü eceka kpï fütanga wü mba la, wu ngü la bala, fü ewü ayia ale woro, anü agbü mere kötï, amala nga ngü, te Yesu mere la, fü wü kpara kpala, gü ba, “Yesu liki wü di enga me guvu wü mürü maröfö de ꞌbasu ne eyi asidi.” ");
INSERT INTO muh_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Te wü kpara agbü mere kötï je nga ngü la bala, fü ewü amala, gü ba, “Dela sirimbi!” Fü ewü ayia akö te-wü ꞌburu, anü kpaka Yesu, andaꞌba te-wü fefe, de ah ce sü ka-ani la ace. Fü wü Yesu ayia alï gbü *zabu, anü sü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Te wü Yesu kö mere ngu de wü kpara ka-ye la tete, fü ewü anü akoro agbü Kaparanama, gbü sü te engu ngbü engbü gbügbü. ");
INSERT INTO muh_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fütanga ngü la, fü wü gara kpara abï gara komoko füh kaꞌda, te küküte kpi akpi ꞌburu, akoro di kpaka Yesu. Fü Yesu awu, gü ba, “Wü kpara la to maguma wü eyi fü ni fanü fanü.” Fü Yesu ayia amala ngü fü mürü keke la, gü ba, “Enga ra, mü gu maguma mü, angü wü *siti ngü ka-mü, ta te mü mere gbü jia Me ne, ma boro eyi ꞌburu asidi.” ");
INSERT INTO muh_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Te wü gara *mürü rïrï je ngü te Yesu mala fü komoko la de bala ne, fü ngü la ayia ake te ewü. Fü ewü angbü efï ngü emaguma wü, gü ba, “Apa! Dene ne töndö ngü ne? Komoko la le ao te-ye da Me? Ah ngbü ka-ye dela efala Me!” ");
INSERT INTO muh_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Amba Yesu wu fïngangü ka-ewü la kpo. Fü ah adu afü te-ye, amala ngü fü ewü, gü ba, “Yi ngbü de siti fïngangü emaguma yi, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Yi wu de, gü ba, ma de *Ye Kpara ka Kpï? Te di bala, wazi ra ladü, teka adi eza siti ngü ka wü kpara füh kotö ne, gbü nzö ewü di asidi. Yi fï nda-yi, gü ba, ngü te ma mala fü mürü keke, gü ba, ma boro siti ngü ka-ye eyi ne, ah de töndö ngü kükürü? Yi ena awu ngü la enatikine!” Fü Yesu adu afü te-ye, amala ngü fü mürü keke la, gü ba dene, “De-ye deyï, ye yia eyia tikpi, de ye za darara ka-ye, ye go kpa ekötï.” ");
INSERT INTO muh_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Te di bala, fü komoko la ayia arü tikpi, aza darara ka-ye, ale kaje, ago agba ye. ");
INSERT INTO muh_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Fü ngü la aga gbü jia wü kpara la afa sü. Fü ewü akpo da egbo nga ïrï Me, teka wazi de te Me to fü Yesu ne. Dela ngü te Yesu gü tamu wazi, de te Me to fü ye ne tete, fü wü mürü rïrï. ");
INSERT INTO muh_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Fütanga ngü la, fü wü Yesu ayia gbü sü la, anü sü ka-wü. Te wü Yesu ngbü eguru sü tete, fü ah awu gara komoko de ïrï ye Matayo *Levi, te ngbü gbü sü ka tima ka-ye, da ero *jiase ka wü e, eto fü miri ka wü Rüma. Fü Yesu arü amala ngü fefe, gü ba, “Matayo, ma ele de mü fa nga ra, baka *mürü tima ka-ra.” Fü Matayo ayia ꞌduwa, alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Fütanga ngü la, fü Matayo ayia areke zü-e agba ye. Fü ah ayia aï wü Yesu, de mere bi wü bu ye, ta te ewü ngbü ero jiase de ewü ne, kpah de mere bi wü kpara, te wü *Farusi le ewü kpah de. Angü wü Farusi la ngbü efï, gü ba, wüh de siti wü kpara. Fü wü kpara la angbü ezü e de wü Yesu kpala. ");
INSERT INTO muh_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fü gara wü Farusi ayia aje ngü la. Fü ewü ayia akoro kpaka wü *kpara ka Yesu, ayi-ta ewü, gü ba, “Ah mere baye, te mere kpara ka-wü ngbü ezü e, de wü siti kpara de bala ne?” ");
INSERT INTO muh_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Te Yesu je ngü la bala, fü ah ayia amala ngü fü wü Farusi la, gü ba, “Te keke te mü ma la, mü ena anü anü kpaka mürü kuwa? Mü tï anü de. ꞌDuwa te keke ladü te mü, fü mü anü kpaka mürü kuwa, de ah küwa ni. ");
INSERT INTO muh_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ngü ka-ra kpah bala. Ma koro füh kotö ne teka züka wü kpara de. Ma koro ka-ra teka aï siti wü kpara, de wüh fü maguma wü, fü ewü aküwa. Amba nda-yi, wü Farusi, te yi gü ba, ani de züka kpara me-ani ne, ah le de yi je la si-ngü gbü ngü te Me mala gbü *Ngari ye, gü ba, ‘De-ni, Me, dene ngü te ni le, de wü mere. Ni le de wü ceka cïnga wü bu wü, ale ewü de züka maguma wü. Angü te wü mere bala de la, mere bi wü nü, de te wü ngbü ewa, eto fü ni baka laꞌbï ne, ni Me, ni tï ale nda-ni de!’ Dela ngü ta te *mürü dofo Oseya ba gbü Ngari Me, teka yi.” ");
INSERT INTO muh_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Fütanga ngü la, fü wü gara kpara ka *Yüwane Mürü Babatïza akoro kpaka Yesu, ayi-tata, agü ba, “Nda-ani, wü kpara ka Yüwane, gara wü sïkpï ladü te ani zü e de, da *eꞌbï te-ani, teka adi eku gba fü Me. Nda wü Farusi kpah bala. Anga ah mere neh baye, te nda-ye wü kpara ne, le ngü ka gele ka-ani mbi mbi de, fü ewü angbü ezü e gbü wü sïkpï ꞌburu ne?” ");
INSERT INTO muh_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Fü Yesu alügü ngü fü ewü gbü mani, gü ba, “Yi ngbü efï nda-yi, gü ba, te wüh ï wü kpara gbü karama la, wüh tï azü e te ewü ï ewü tüngüngü gbü karama la de? Wüh ena azü e azü, angü mürü karama la ladü tundu de ewü. Amba te gara, te wü vügü ena aza mürü karama la, esüka wü awuba ye asidi la, wüh tï azü e de, ka cïnga emaguma wü.” ");
INSERT INTO muh_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Fü Yesu adu kpah amala gara ngü mani fü ewü, teka to rïrï ka Me te engu ngbü erï wü kpara di ne, gü ba, “Te diri bongo ka-mü sörö asörö la, mü tï eyi aza to bongo teka atükü te didiri na la? Mü tï amere bala de, angü didiri na la ena adu kpah asörö ka-ye asörö. ");
INSERT INTO muh_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kpah bala, te mü le aküꞌda fï ka-mü la, de mü mere e aküꞌda gbü diri bütü körö körö ne de. Angü diri bütü la ena adü, aöfö ka-ye, fü fï ka-mü la atökö ka-ye ꞌburu akötö. Ah le fü mü aküꞌda fï ka-mü gbü to bütü, teka fü fï ka-mü angbü ꞌbe. Kpah bala, te mü le to rïrï ka-ra la, mü tï alala fï bü eküte diri gele ka wü kundu mü nda-mü de.” ");
INSERT INTO muh_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Baka te Yesu ngbü la emala ngü la tete fü wü kpara sela, fü gara mere kpara ayia akoro, atï eri lö Yesu, andaꞌba te-ye fefe, gü ba, “Mere kpara, ye ra jaji würüse, kpi eyi tïtïne. Ma endaꞌba te-ra fü mü, de mü koro, mü zükü engu.” ");
INSERT INTO muh_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Fü Yesu ayia de wü kpara ka-ye, afa nganga na. ");
INSERT INTO muh_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Te wüh ngbü enü tete, fü gara würüse ayia azi te-ye ꞌbïlï! amofo mö bongo ka Yesu, to kpa ekükürüfe. Angü ngüte ngbü ta ego eküküte teka wü re nzükpa de füh ye ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Würüse la fï ta emaguma ye, gü ba, “Te ni mofo bü nzö mö bongo kaka-na la, ni ena aküwa gbü keke ka-ni la aküwa.” ");
INSERT INTO muh_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Fü Yesu afü te-ye, awu würüse la, amala ngü fefe, gü ba, “Enga ra, mü gu maguma mü. Mü küwa eyi, angü mü to maguma mü eyi ꞌburu fere.” Yesu bü te emala ngü la bala, ꞌduwa fü keke ka würüse la ayia anza. ");
INSERT INTO muh_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Fü wü Yesu anü akoro agba mere kpara la. Te wüh koro tete kpala, fü ewü amaka mere bi wü kpara, te ewü ngbü eku gba de yiyi, da ebï ci gba, füh kö mbarase la. ");
INSERT INTO muh_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Fü Yesu amala ngü fü ewü, gü ba, “Wü yia eyia, wü koro ekoro kpa etanü, angü jaji würüse ne kpi nda de, ah ngbü ka-ye era ara.” Fü wü kpara la akpo da emü Yesu, da efala ngü kaka la, angü wüh wu eyi fanü, gü ba, mbarase la kpi ka-ye eyi. ");
INSERT INTO muh_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Te wü kpara la koro tete ꞌburu kpa etanü, fü Yesu arï kpa esambü, azoro kpa jaji würüse la. Fü jaji würüse la azükü gbü kpi cukuru! ayia arü tikpi. ");
INSERT INTO muh_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dela ngü ta te Yesu zükü jaji würüse la tete gbü kpi. Fü nga-ngü la ayia awü, abaya esüka wü kpara gbü nga nzö sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Gbü gara ra, o wü Yesu ngbü enü andoro, fü wü gara kpara ꞌbasu, te jia ewü ni ani, ayia akpo da efa nga Yesu, da eku gba, endaꞌba te-wü fü Yesu, gü ba, “Ako Yesu, Mere Miri te Me tima ye teka aküwa ani ne, ye ceka la cïnga te ani ne, baaa!” ");
INSERT INTO muh_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Fü Yesu ayia arï kpa esambü, gbü sü te ewü ngbü engbü tete. Fü wü kpara ꞌbasu la ayia akoro kpakaka na, angü wüh le ace nganga de. Fü Yesu ayi-ta ewü, gü ba, “Wü wu eyi, gü ba, ni tï eyi aü jia wü fanü?” Wü kpara la gü ba, “Wayi, mere kpara, ani wu eyi bala!” ");
INSERT INTO muh_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Fü Yesu amofo jia ewü, agü ba, “Ah mbi. Baka te yi to maguma yi eyi fere fanü ne, ah le de jia yi ü eü.” ");
INSERT INTO muh_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Fü jia wü kpara la ayia aü te-ye. Fü Yesu adu amala ngü fü ewü kpekpeke, gü ba, “Wü mere e amala nga ngü la fü kpara biringbö kpo de.” ");
INSERT INTO muh_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amba wü kpara la le amere ngü, te Yesu mala fü ewü ne, nda-wü de. Fü ewü akpo da emala nga Yesu fü wü kpara, gbü nga nzö wü sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Baka te wü Yesu yia enü tete, fü ewü akoro kpah de gara kpara te ro mö de, angü *siti wü di enga me ngbü emere engu me-wü bala. ");
INSERT INTO muh_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Te Yesu liki siti wü di enga me guvu komoko la tete, ꞌduwa fü engu akpo da ero mö. Fü ngü la aga gbü jia mere bi wü kpara la afa sü. Fü ewü angbü da emala ngü esüka ewü, gü ba, “Ani wu mene ngü de bane gügü gbü tö ka *Yïsarayele sene la de.” ");
INSERT INTO muh_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Amba wü *Farusi kpo da emala nda-wü, gü ba, “Yesu maka wazi, teka aliki *siti wü di enga me la di, esaka *Satana, te di de miri ka wü di enga me ne!” ");
INSERT INTO muh_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Fütanga ngü la, fü Yesu angbü endoro gbü wü kötï ka sü la ꞌburu, da erï wü kpara de to ngü ka Me, kpa *esambü ka biti-te ka-ewü. Fü ah angbü kpah da emala fü ewü, gü ba, “Me ngbü eï wü, de wü koro kpaka ni, fü ni afü wü, akoro di züka wü kpara ka-ni.” Kpah bala, engu ngbü da eküwa wü kpara gbü wü keke ka-ewü ꞌburu. Fü mere bi wü kpara angbü efa nganga na. ");
INSERT INTO muh_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gbü gara sïkpï, fü Yesu ae jia ye, aceka mere bi wü kpara te ewü ngbü efa nga ye ne. Fü ngü ka wü kpara la ato mere cïnga emamaguma, angü wü kpara la ngbü de mere fïngangü, angü maguma ewü ꞌbasu ꞌbasu. Wüh ngbü ka-wü baka wü kambiliki, te kpara di fütanga ewü ma. ");
INSERT INTO muh_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Teka ngü la, fü Yesu ayia amala gara mani fü wü kpara ka-ye, gü ba, “Ah le de yi le ta-ngü te wü kpara la, angü wüh le ta eyi ato maguma wü fü Me ne, amba kpara te ena arï ewü de to *ngari Me nda ma. Wüh baka ndo te ndri eyi agbü yï, amba kpara teka awa ndo la, ao gbü kafa nda ma. ");
INSERT INTO muh_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yi ena amere de ngü la neh baye? Ah le de yi ku gba fü Me kpekpeke, teka de engu tima wü gara kpara, ale ta-ngü te yi, amala ngari Me fü ewü, angü engu me-ye de mürü yï la.” ");
INSERT INTO muh_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Fütanga ngü la, fü Yesu ayia afe wü *mürü tima ka-ye nzükpa de füh ye ꞌbasu ne, ato wazi fü ewü, teka de wüh nü, wüh di eliki *siti wü di enga me, da eküwa wü kpara gbü keke ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dene ïrï wü kpara nzükpa de füh ye ꞌbasu ne. Ah de Sïmüna, te Yesu gü gara ïrï tete, gü ba, Petero, ake enga ni ye, de ïrï ye Anderïya. *Yakobo, ake enga ni ye, de ïrï ye *Yüwane, wü di Zebedayo. ");
INSERT INTO muh_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","*Fïlïpo ake Batülümayo. Toma ake Matayo, kpara ta te ngbü ero *jiase fü miri ka Rüma ne, bete *Yakobo ye Alofaya, ake Tadayo, ");
INSERT INTO muh_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","bete gara Sïmüna, ta te ngbü emere gü teka tö ka-a, ake *Yuda Keriyota ta te to Yesu fü wü vügü ne. ");
INSERT INTO muh_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Fü Yesu ayia amala ngü fü wü kpara ka-ye nzükpa de füh ye ꞌbasu ne, gü ba, “Ma ngbü etima yi dene, teka anü amala ngari ra fü wü kpara. Yi nü la bü nzö kpaka wü di enga *Yïsarayele feke, angü wüh dürü te kaje ka Me eyi asidi, baka wü kambiliki, te ewü dürü adürü agbü gü. Amba yi mere e anü kpaka wü *ganzi kpara, de wü kpara ka *Samarïya, la de. ");
INSERT INTO muh_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Te yi te endoro gbü wü kötï ka-nih, wü Yïsarayele la, yi di emala ngari ra fü ewü, gü ba, ‘Miri, te Me tima teka aküwa ani ne, koro eyi. Ah le de wü fü maguma wü afü.’ ");
INSERT INTO muh_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ah le de yi ngbü kpah da eküwa wü mürü keke, da ezükü wü kpara gbü kpi, kpah da eküwa wü mürü *jiakö. De yi di kpah eliki *siti wü di enga me guvu wü kpara asidi. Ma to wazi ne fü yi, teka amere ngü la di kükürü. Ah le de yi mere wü ngü la fü wü kpara, kpah kükürü. Yi mere e ayo jiase te wü kpara de! ");
INSERT INTO muh_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Te yi te enü la, yi mere e aza wü e esaka yi de. Yi mere e aza jiase esaka yi ꞌburu ꞌburu de. ");
INSERT INTO muh_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yi za kombo kpah de, yi za bongo ꞌbasu ꞌbasu de, yi za gara kamaka kpah de, yi za ngbangba esaka yi kpah de. Wü kpara te yi ena amala ngari ra fü ewü la, wüh ena ale ta-ngü te yi de wü e la ꞌburu me-wü, angü ah le de kpara te ngbü emere tima ne, maka na tima ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Gbü wü sü te yi ena anü akoro gbügbü na, ah le de yi gïrï mene kpara te di de züka maguma ye, fü yi angbü kpa gba ka, zalü gbü sïkpï te yi ena ayia tete gbü sü engu la. ");
INSERT INTO muh_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gbü kötï te yi ena akoro gbügbü na la, gina ngü te yi ena amala fü ewü, ah dene. Yi to mandï fü ewü, gü ba, ‘Me di de yi, gbü kötï ne.’ ");
INSERT INTO muh_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Te wü kpara ka kötï la de züka wü kpara, de lele ka Me emaguma wü la, mandï ka-yi, de te yi to de gu ngü ka Me gbü ye ne, ah ena angbü fü ewü. Amba te ewü le ngü ka-ra gömö yi de, züka gu ngü ka Me, te yi to fü ewü ne, tï angbü gbü kötï la nda de. ");
INSERT INTO muh_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Te wü kpara gbü wü sü engu la le ngü ka-yi nda-wü de la, yi yia sela asidi, de yi bunda zu-tö ka gba ewü la esatïlö yi asidi, ciki sela, teka agü tamu ngü la fü ewü, gü ba, ‘Me le ngü ka-wü de, angü wü le ngü ka wü kpara ka Me, kpah de.’ ");
INSERT INTO muh_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma ngbü emala fü yi dene zu ngü. Gbü sïkpï te Me ena akolo lïya ka wü kpara tete, ah ena ato siti kuru gbü nzö wü kpara la, afa nda siti wü kpara ka *Sodomo bete Gomora ta gügü ne ka. ");
INSERT INTO muh_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yi ceka ꞌbe, angü ma tima yi dene baka wü kambiliki esüka wü siti kpara, te ewü di baka siti wü nü. Te di bala, ah le fü yi amba jia yi amba baka kpürü, amba yi mere siti ngü fü wü kpara de. Yi di kpah emere wü ngü ꞌburu ferrre baka wü mö.” Dela ngü te Yesu mala fü wü kpara ka-ye, te engu tima ewü ne. ");
INSERT INTO muh_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","18","Fü Yesu adu amala gara ngü fü wü kpara ka-ye, gü ba, “Yi ceka te-yi ꞌbe, angü te gara wü vügü ka-ra ena akoro azoro yi, anü di engagira wü miri, fü ewü asüma yi de juru gbü jia wü kpara ꞌburu. Te di bala, yi ena amala ngari ra fü ewü. Kpah bala, wüh ena azoro yi, akoro di engagira wü mere miri ka wü *ganzi kpara, fü yi amala ngari ra kpah fü wü ganzi kpara la. ");
INSERT INTO muh_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gbü ra te wüh ena azoro yi, akoro di tete engagira wü miri la, fïngangü ka-yi mere e asiti, teka ngü de te yi ena amala fü ewü, ne de. Angü *Nzïla Wazi Me ena ato züka fïngangü fü yi me-ye, teka amala mere kpeke ngü di fü ewü. ");
INSERT INTO muh_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Angü, wü ngü de te yi ena adi emala ne, ah ena adi de ngü ka-yi nda de, ah ena adi de ngü te Nzïla Wazi Me ena adi eto fü yi me-ye. ");
INSERT INTO muh_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Yi ceka te-yi ꞌbe, angü wü di enga ni yi, de wü wö yi, ena ato yi cu me-wü fü wü vügü, fü ewü amörö wü gara yi, teka te yi le ngü ka-ra. Wü jaji ena afü te-wü, agü gü kpaka wü wö wü, ato ewü fü kpi teka ngü ka-ra. ");
INSERT INTO muh_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wü kpara ꞌburu ena angbü ekpü yi akpü, teka te yi le ngü ka-ra. Ngü ma, yi rü kpekpeke gbü wü cïnga la ꞌburu, angü Me ena aküwa yi te gara agbü sü ka-ye agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Te wüh ngbü emere yi esiti gbü gara kötï, teka te yi le ngü ka-ra la, de yi kpe, yi nü, yi ngbü kpa gbü gara kötï, amala ngari ra fü wü kpara kpala. Ma ngbü emala fü yi dene zu ngü. De-ra, *Ye Kpara ka Kpï, ma ena adu akoro de wazi ka Wüba, o yi nza tima ka-yi gbü wü sü ꞌburu te di gbü tö ka-nih, wü *Yïsarayele ne, la de. ");
INSERT INTO muh_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ngü ka mbarase tï afa ngü ka mere kpara ka-ye de. ");
INSERT INTO muh_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Te di bala, ngü ka-yi ena adi gbü jia wü kpara kpah baka nda-ra, angü yi de wü kpara ka-ra. Ma mala ngü la kükürü de, angü te wüh ngbü egü siti ïrï eküte ra, gü ba, ma de miri ka wü muruyi la, wüh tï afala yi bala de? Wüh ena adu asoko yi, wü kpara ka-ra, kpah bala. Teka ngü la, ah le di yi rü kpekpeke, kpah baka ra. ");
INSERT INTO muh_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Te di bala, yi mere e akpe cürü wü vügü ka-yi de. Ah le de yi mala ngari ra fü ewü mbölö. ");
INSERT INTO muh_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Angü wü ngü te ma ngbü emala fü yi esalakumu ne, ah le de yi mala wü ngü la de mere ri yi fü wü kpara ꞌburu, baka kpara te ngbü erï dofo. ");
INSERT INTO muh_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yi mere e akpe cürü wü vügü ka-yi de, angü wüh tï eyi amörö bü küte yi kükürü, amba wüh tï amofo *küküwa ka-yi nda-wü kü de. Te di bala, ah le fü yi akpe ꞌduwa Me kpikpi ye, angü, te yi ce ngü ka-ra la, engu de wazi teka amörö küte yi, aza kpah küküwa ka-yi, agü agbü wa. ");
INSERT INTO muh_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Yi mere e akpe cürü de, angü Me ngbü eceka kpï fütanga yi me-ye. Yi ceka la wü lu, te ewü sibi fa sü ne, Me ngbü eceka kpï fütanga ewü biri biri ꞌburu. Toto ïrï teka biri süka ewü de. Amba ah kpah bala teka ngü ka-yi, angü Me le yi fa nda mere bi wü lu la ka. Ah tanga wü su-nzö yi biri biri kpah eyi ꞌburu. Te di bala, to Me tï aïrï te yi tïne de. ");
INSERT INTO muh_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mene kpara te kpe cürü de, fü ah amala nga ye gbü jia wü kpara ngbaa ngbaa ngbaa, gü ba, ‘Ni de kpara ka-ra la,’ gbü *adu sïkpï, ma ena amala nganga kpah engagira Wüba Me, ngbaa ngbaa ngbaa, gü ba, ‘Engu de kpara ka-ra fanü.’ ");
INSERT INTO muh_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amba te mü cere nga mü, gü ba, ‘Ni wu ra de la,’ gbü adu sïkpï, ma ena amala tüngü mü kpah bala, engagira Wüba, Me, gü ba, ‘Ma wu mü kpah de.’ ");
INSERT INTO muh_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yi efï nda-yi, gü ba, ma koro teka fü yi amaka gu ngü esüka wü kpara füh kotö sene? Aꞌa, ah bala de! Kokoro ka-ra füh kotö ne ena ato makpü, fü wü kpara angbü ekpü yi akpü, angü yi de wü kpara ka-ra. ");
INSERT INTO muh_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Angü teka ngü ka-ra, wü jaji komoko ena akpü te-wü de wü wö wü. Wü jaji würüse ena akpü te-wü de wü ni wü. Wü würüse ena akpü kpah te-wü de wü wara wü di enga wü. ");
INSERT INTO muh_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Te di bala, wü vügü ka-yi ena adi kpah bü ciki esüka wü mürü yi. ");
INSERT INTO muh_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Te mü le afa nga ra la, ah le de mü ce ngü ka maguma ꞌbasu ꞌbasu. Te mü le ngü ka wö mü, anga ni mü, fa ngü ka-ra di ka la, mü tï angbü kpara ka-ra nda-mü de. Te mü le ngü ka wü di mü, anga wü di enga mü, fa ngü ka-ra di ka la, mü tï angbü kpara ka-ra nda-mü kpah de. ");
INSERT INTO muh_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wayi, te mü le alala gbü nga ra, ah le de mü reke te-mü fü kpi, baka kpara te ngbü ebï rü gbegbete ka-ye, te wüh ena amörö engu fefeh na. Angü, te mü mere bala de la, mü de kpara ka-ra de. ");
INSERT INTO muh_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amba, te mü le aküwa te-mü de tete-mü la, mü tï aküwa te-mü nda-mü de. Angü, te mü ce te-mü, o fü kpi teka ngü ka-ra la, Me ena aküwa mü me-ye, fï mere badi. ");
INSERT INTO muh_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ma emala fü yi dene zu ngü. Mene kpara te ena ale yi de züka maguma ye, aza yi gbü mürü la, kpara engu la ngbü dela kpah ele ra. Kpah bala, mene kpara te ele ra de züka maguma ye la, ah ngbü dela kpah ele Wüba Me, te tima ra ne. ");
INSERT INTO muh_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mene kpara te ena ale yi, baka wü *mürü dofo ka Me, de züka maguma ye, teka te yi ngbü emala ngari Me fü ani ne, Me ena ato kpah mere züka ngü fefe, te gara agbü kpï kpala, kpah baka e te engu ena ato fü yi. Kpah bala, mene kpara te ena aza yi gbü mürü, angü yi de züka wü kpara ka Me la, Me ena ato kpah mere züka ngü fefe, te gara agbü kpï kpala, kpah baka e te engu ena ato fü yi. ");
INSERT INTO muh_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma ngbü emala fü yi dene zu ngü. Mene kpara te ena ale ta-ngü te yi, ato mba e fü yi ba gu ngu, teka te yi di de kpara ka-ra ne, Me ena ato mere züka ngü fefe, te gara agbü kpï kpala.” ");
INSERT INTO muh_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Dela ngü te Yesu mala fü wü kpara ka-ye nzükpa de füh ye ꞌbasu ne. Fü engu ayia atima ewü, teka anü amala ngari Me fü wü kpara gbü nga nzö sü ka *Galïlaya la ꞌburu, kpah da eküwa wü mürü keke. Fütanga wü ngü la, fü Yesu ayia anü andoro gbü wü kötï ka Galïlaya ꞌburu, teka arï wü kpara de to ngari Me. ");
INSERT INTO muh_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gbü wü sïkpï la, *Yüwane Mürü Babatïza ka-ye fï la bü agbü ku. Fü ah ayia aje nga wü ngü te Yesu ngbü emere la. Yüwane, fü mü ayia atima wü gara kpara ka-mü kpaka Yesu. ");
INSERT INTO muh_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Fü wü kpara ka Yüwane la anü akoro kpaka Yesu, ayi-tata, gü ba, “Mere kpara ka-ani tima ani me-ye, teka ayi-ta ye, gü ba, ‘Ye ngbürü de Ye Me, ta te Me mala nganga, gü ba, ni ena atima füh kotö ne? Anga ah le de ani di la fï bü ecï nganga?’ ” ");
INSERT INTO muh_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Fü Yesu amala ngü fü ewü, gü ba, “Yi du edu, yi mala nga wü ngü, de te ma ngbü emere gbü jia yi ne, ꞌburu fü Yüwane, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Wü kpara te jia ewü ni ani, wüh kpo eyi eceka kpï. Wü kpara de lö wü walawala, wüh kpo eyi enü nü. Küte wü mürü *jiakö reke kpah eyi. Wü kpara te güje ewü do ado, wüh kpo eyi eje ngü. Wü kövö kpo eyi ezükü gbü kpi. Wü mürü cïnga kpo eyi eje ngari Me. Wü ngü la ꞌburu ngbü eyi emere te-wü, ba e ta te wü *mürü dofo ba gbü Ngari Me ne.’ ");
INSERT INTO muh_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Te di bala, yi mala fü Yüwane, gü ba, ‘Mene kpara te ena alala fï bü eküte ra, Me ena aceka engu ba züka kpara ka-ye, fü ah angbü de mere tadu te gara.’ ” ");
INSERT INTO muh_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Fü wü kpara la ayia adu kpaka Yüwane, mere kpara ka-wü. Fü Yesu adu afü te-ye, akpo angbü emala nga Yüwane fü mere bi wü kpara la, gü ba, “Yi ngbü efï teka Yüwane, egü neh fe? Ta te yi ngbü enü kpa etü gü, da eje ngü gömö Yüwane ne, yi nü kpala neh teka ne? Yi ngbü ta efï ngü teka Yüwane, gü ba, engu de töndö kpara, de maguma ye ꞌbasu ꞌbasu, te ngbü emere ngü baka gala, te wege ngbü efe me-ye ne? Aꞌa, ah bala de! ");
INSERT INTO muh_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anga fïngangü ka-yi gü ba, engu de mere miri, te to züka bongo eküte ye? Aꞌa, ah bala kpah de, angü wü kpara te ewü ngbü eto züka bongo eküte wü, wüh ngbü etü gü nda-wü de! Wüh engbü ka-wü gbü mere kötï, anga gba wü miri. ");
INSERT INTO muh_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Amba ma wu eyi, gü ba, yi nü ta kpaka Yüwane kükürü de, angü engu de mürü dofo ka Me fanü. Te di bala, ah le de yi wu awu, gü ba, ngü ka Yüwane fa nda wü gara wü mürü dofo ka Me ꞌburu ka. ");
INSERT INTO muh_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Angü Yüwane me-ye de kpara, ta te wüh ba ngü kaka-na gbü *Ngari Me, gü ba dene, ‘Me mala ngü fü Ye ye, gü ba, “Ni ena atima mürü tima ka-ni kpa engagira nü, teka areke kaje fü ye.” ’ ” ");
INSERT INTO muh_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Ma ngbü emala fü yi dene zu ngü. Esüka wü mürü dofo, de wü diri wü kpara ka Me ta gügü ne ꞌburu, gbü jia Me, kpara te ngü kaka fa nda *Yüwane Mürü Babatïza, nda ma. Amba mene kpara te to maguma ye fere ꞌburu, ngü kaka ena afa nda Yüwane ka, angü *Nzïla Wazi Me ngbü eto wazi fefe me-ye. ");
INSERT INTO muh_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ah kpo gbü sïkpï ta te Yüwane kpo de tima ka-ye, zalü akoro di dene, ngü ka Me ngbü eyi ega esüka wü kpara, angü mere bi wü kpara ngbü eyi eto te-wü, da elala gbü ngü ka Me. Amba siti wü kpara, te ewü di vügü ka ngü ka Me ne, ngbü kpah eyi egïrï kaje, teka atïrï tima ka Me la de wazi. ");
INSERT INTO muh_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","*Müse de wü gara wü mürü dofo ka Me ta gügü ne, wüh ngbü ꞌburu emala nga ngü, de te ngbü emere te-ye gbü wü sïkpï ne. Gina mürü dofo la de Müse, adudu na de Yüwane Mürü Babatïza, te mala nga kokoro ka-ra ne. ");
INSERT INTO muh_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma emala fü yi dene zu ngü, gü ba, Me tima Yüwane Mürü Babatïza me-ye, teka amala ngari ye fü wü kpara, kpah baka e te engu tima mürü dofo *Ïlïya ta gügü ne. ");
INSERT INTO muh_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Te güje yi ladü la, ah le de yi da güje yi, aje ngü ka-ra la areke areke.” ");
INSERT INTO muh_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Fü Yesu adu kpah amala gara ngü fü wü kpara la, gü ba, “Wü kpara te ewü le ngü ka-ra de ne, ma ena amala teka ewü, agü neh fe? Wüh neh baka wü da? Angü ma reke ewü eyi ma! Wüh le züka ngü nda-wü de. Wüh baka wü jaji te ewü ngbü ega yïkï de wü bu wü. Angü gara wü bu ewü ngbü ta emala ngü fü ewü, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ani reke wü ma! Wü le züka ngü nda-wü de! Angü ani ngbü emï kuꞌdu fü wü, wü le alo bï de. Ani ngbü ebï ci gba fü wü, wü le aku gba kpah de!’ ");
INSERT INTO muh_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Wü di enga wüna, yi ceka la! Baka ta te *Yüwane Mürü Babatïza koro ngbü esüka yi sene ne, ah zü e fa sü de, ah nzö fï kpah de. Te di bala, wü gara kpara ngbü ta efala engu, gü ba, ‘Engu de *siti wü di enga me guvu ye!’ ");
INSERT INTO muh_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amba de-ra, te ma koro esüka yi sene, ma ngbü ezü e, kpah da enzö e, fü wü kpara angbü kpah efala ra, gü ba, ‘Ma de mürü kü. Ma ngbü kpah eküya. Ma kpah de awuba ka siti wü kpara.’ Wü kpara te ewü ngbü efala ngü ka-ra ne, ngbü efï nda-wü, gü ba, ani wu ngü fa sü. Amba wüh wu ngü nda-wü kü de. Ah ena adi bü nzö mene wü kpara te ewü le ngü ka-ra eyi ne, wüh ena angbü ewu si-ngü la me-wü.” Dela ngü ta te Yesu mala fü wü kpara, teka ngü ka Yüwane Mürü Babatïza. ");
INSERT INTO muh_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Fütanga wü ngü la, fü Yesu akpo da emala ngü fü wü kpara gbü wü kötï, te engu ngbü endoro gbügbü na ne. Angü engu mere bi wü kpeke lara ngü gbü jia wü kpara gbü wü kötï engu la ma, amba wüh le afü maguma wü nda-wü de. Teka ngü la, fü Yesu amala ngü fü wü kpara la kpekpeke, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“De-yi wü kpara ka Korazïna, bete wü kpara ka Betesayïda, Me ena ato mere kuru te yi te gara, angü yi le ngü ka-ra de. Kükürü de, angü wü mere kpeke ngü, de te ma ngbü emere gbü wü sü ka-yi ne, te ma ena angbü emere ta bala fü wü *ganzi kpara, baka wü kpara ka Tera ake Sïdona la, de bane wüh ngbü ta eyi de mere cïnga te wü, teka *siti ngü ka-wü. Wüh ena angbü ta kpah eto kala bongo eküte wü, eza kpah mbï ebu gbü nzö wü, da endaꞌba te-wü fü Me, gü ba, ‘Ani le eyi afü maguma ani!’ ");
INSERT INTO muh_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Teka ngü la, gbü *adu sïkpï te Me ena akolo ngü ka wü kpara tete, ah ena ato mere kuru te yi, wü kpara ka Korazïna ake Betesayïda, afa nda wü kpara ka Tera bete Sïdona ka. ");
INSERT INTO muh_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kpah bala, de-yi, wü kpara ka Kaparanama, yi fï nda-yi, gü ba, ngü ka-ani ena areke gbü jia Me, fü ani akoro agbü kpï? Aꞌa! Ah bala de! Ngü ka-yi ena asiti gbü jia Me asiti, fü yi anü agbü du ka wa, angü yi le ngü ka-ra de. Kükürü de, angü wü mere kpeke ngü, de te ma ngbü emere gbü wü sü ka-yi ne, te ma ena angbü emere ta bala fü wü siti kpara ka *Sodomo la, de bane wüh fü ta maguma wü eyi. Me tï ta acuru ewü de. ");
INSERT INTO muh_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma emala fü yi dene zu ngü. Gbü *adu sïkpï te Me ena akolo ngü ka wü kpara tete, Me ena ato mere siti kuru gbü nzö yi, afa nda wü kpara ka Sodomo ka, angü yi le ngü ka-ra de.” ");
INSERT INTO muh_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sidi nga ngü la, fü Yesu ayia agbo nga ïrï Me, gü ba, “Wayi, Wüba Me, mü de Miri agbü kpï, mü kpah de Miri gbü nzö wü kpara füh kotö ne ꞌburu. Ma ngbü egbo nga ïrï mü, angü mü to wazi eyi fü wü kpara ka-ra, teka aje to ngari mü ne. Kükürü de, angü wüh o fïngangü ka-wü eyi ꞌburu, teka adi eje ngü la ba wü vürü jaji. Amba teka wü cögbörö kpara, te ewü le aje ngü ka-mü de ne, wüh tï awu si-ngü ka-mü de, angü wüh gü ba, ani wu ngü fa sü. ");
INSERT INTO muh_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wayi bala Wüba, ngü la reke cu te mü, angü mü le me-mü, de wü kpara ka-ra je si-ngü ka-mü.” ");
INSERT INTO muh_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Fü Yesu adu amala ngü fü wü kpara ka-ye, gü ba, “Wüba Me to wazi ka wü ngü eyi ꞌburu esaka ra, teka de ma koro, ma sere ngü ka-ni la fü yi. Kpara biringbö te wu ngü ka-ra mbi mbi mbi nda ma, ꞌduwa Wüba Me, te engu wu ngü ka-ra me-ye. Kpah bala, kpara biringbö, te wu ngü ka Wüba Me, nda ma. Ma wu ngü kaka duu me-ra, be kpah te wü kpara te ma gü tamu ngü ka Me fü ewü ne. ");
INSERT INTO muh_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","De-yi wü kpara, te yi ndïrï eyi, ka wü tiri ngü ka-yi ne, yi le ngü ka-ra, de yi nü kpaka ra kpakine. Ma ena aza wü tiri ngü la gbü nzö yi asidi, fü yi afe te-yi. ");
INSERT INTO muh_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yi to maguma yi fere, de yi ce te-yi ꞌburu, adi eje rïrï ka-ra. Angü ma de mürü *züka maguma, te ma ngbü ewu cïnga wü kpara. Te yi le ngü ka-ra la, ma ena agu maguma yi kpina, fü yi afe te-yi. ");
INSERT INTO muh_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Angü rïrï te ma ena ato fü yi ne, ah kpekpeke nda de. Rïrï la ena ato kpah wazi fü yi, fü ah ale ta-ngü te yi.” Dela ngü ta te Yesu mala fü wü kpara ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Fütanga ngü la, gbü gara *sïkpï ka Me, fü wü Yesu angbü enü de wü kpara ka-ye. Fü ewü afü kpuru gbü gara yï ka ndo, akpo da esösörö fï ndo la, etitiri, ezü, ka tala te ewü. ");
INSERT INTO muh_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fü wü gara *Farusi awu ngü la. Fü ngü la asiti gbü jia ewü, angü wüh ngbü efï, gü ba, “Masörö fï ndo la, ah de tima.” Angü *Rïrï te Müse to fü wü *Yïsarayele mala, gü ba, “Gbü sïkpï ka Me, wüh mere e amere tima ꞌburu ꞌburu de.” Teka ngü la, fü wü Farusi la ayia amala ngü fü Yesu, gü ba, “Ye ceka la! Wü kpara ka-ye ne ngbü emere tima gbü sïkpï ka Me, neh teka ne? Wü je rïrï ka-ani ne nda-wü de? Wü le asiti gele ka-ani, neh teka ne, te ewü ngbü esösörö fï ndo la gbü sïkpï ka Me de bala ne?” ");
INSERT INTO muh_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Te Yesu je ngü la, fü ah alügü ngü fü ewü, gü ba, “Yi tanga *Ngari Me nda-yi neh de? Ngü ta te wüh ba teka mere Miri *Davidi ne, ah gü neh fe? Ta gbü gara ra, tala mere Davidi de wü kpara gbü nga ye. ");
INSERT INTO muh_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Fü Davidi ayia akoro kpaka *mürü gele ka Mere Me, ayi-tata teka e-mazü. Fü mürü gele la ayia aza ambata, de te wüh ngbü eto fü Mere Me ne, ato fü Davidi. Amba *Rïrï ta te *Müse to fü wü mürü gele, gü ba, ambata la teka wü kükürü kpara fa fa fa nda de. ꞌDuwa wü mürü gele ka Mere Me ngbü ezü me-wü. Fü Davidi aza ambata la, azü, ato kpah fü wü kpara gbü nga ye la ꞌburu. Te di bala, wüh mala ta eyi fefe, gü ba, ‘Ye ngbü esiti gele?’ Wüh mala bala de! ");
INSERT INTO muh_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kpah bala, gbü Rïrï ta te Me to fü Müse, wüh ba, gü ba, ‘Wü mürü gele, te ewü emere tima gbü *Mere Kambü ka Me ne, ah le de wüh mere tima ka-wü la kpah gbü sïkpï ka Me.’ Yi wu bala de? Te wü mürü gele la ngbü eyi emere tima gbü sïkpï ka Me bala la, yi ena amala fü ewü, agü ba, ‘Wü ngbü esiti gele ka-ani?’ Yi tï amala bala de, angü yi wu kpo, gü ba, ngü ka gele ka Kambü ka Me la fa ngü ka gele ka sïkpï ka Me afa. ");
INSERT INTO muh_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ma emala fü yi dene zu ngü. De-ra *Ye Kpara ka Kpï, Me to wazi eyi fere fa ngü ka gele ka Kambü ka Me bete nda sïkpï ka Me ꞌburu ka. ");
INSERT INTO muh_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wüh ba kpah gara ngü gbü Ngari Me, gü ba, ‘De-ni, Me, dene ngü te ni le, de wü mere. Ni le de wü ceka cïnga wü bu wü, ale ewü de züka maguma wü. Angü te wü mere bala de la, mere bi wü nü, te wü ngbü ewa, eto fü ni baka laꞌbï ne, ni tï ale nda-ni de!’ Ta te yi ena awu si-ngü la awu mbi mbi mbi, gü ba, ngü ka züka maguma fa ngü ka gele afa la, de bane yi tï amala siti ngü eküte wü kpara ka-ra de. Angü ngü te ewü mere la, ah siti gbü jia Me nda de. ");
INSERT INTO muh_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","De-ra, Ye Kpara ka Kpï, Me to wazi eyi fere, fa ngü ka gele la ka. Ma de mürü sïkpï ka Me la me-ra. Ma ngbü eto to Rïrï ka Me fü wü kpara ka-ra me-ra.” ");
INSERT INTO muh_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Fütanga ngü la, fü Yesu ayia gbü sü la, anü arï kpa *esambü ka biti-te. ");
INSERT INTO muh_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gara komoko ta ladü kpa esambü ka biti-te la, te kpakpa na ze aze. Wü *Farusi ta kpah ladü kpala. Fü ewü angbü efete Yesu, da egïrï kaje te ani ena amaka siti ngü kaka, fü ani amala nganga fü wü *kovo. Teka ngü la, fü ewü ayi-tata teka komoko te kpakpa ze aze la, gü ba, “Gbü jia ye, ah de züka ngü teka aküwa kpara gbü *sïkpï ka Me bane? *Rïrï te Me to fü Müse gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Fü Yesu alügü ngü fü ewü, gü ba, “Te kpara ladü esüka yi sene, de kambiliki ka-ye ngbee biringbö la, te kambiliki kaka la tï gbü mere du gbü sïkpï ka Me la, engu ena amere baye? Ah ena ace kambiliki ka-ye la kpala, angü ah de sïkpï ka Me? ");
INSERT INTO muh_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ngü ka kpara fa ngü ka kambiliki la de? Te di bala, ah de züka ngü teka ale ta-ngü te kpara gbü sïkpï ka Me. Angü Rïrï ka Me mala, gü ba, ah le de nih di emere züka ngü.” ");
INSERT INTO muh_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Fü Yesu adu amala ngü fü komoko la, gü ba, “Mü gbere kpa mü egbere.” Fü komoko la ayia agbere kpa ye. Fü kpakpa na areke te-ye, adu zürrrü te nga ye, kpah baka gara na la. ");
INSERT INTO muh_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Te wü Farusi wu ngü la bala, fü ngü la ake te ewü, angü Yesu reke kpa komoko la gbü sïkpï ka Me. Fü ewü ayia anü, akpo da egïrï kaje, de ani mörö Yesu asidi. ");
INSERT INTO muh_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Te Yesu wu, gü ba, wü *Farusi ngbü eyi egïrï kaje teka amörö ni asidi, fü ah ayia ka-ye, ace sü la. Fü mere bi wü kpara aci anü, afa nganga na. Fü Yesu aküwa wü mürü keke, esüka wü kpara la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Te di bala, fü Yesu amala ngü fü wü kpara, de te engu küwa ewü ne kpekpeke, de wüh mere e, amala nga ni fü wü kpara de, angü Yesu le acu ngü ye de. ");
INSERT INTO muh_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Teka wü ngü te Yesu ngbü ele ta-ngü te wü kpara de gu maguma de bala ne, fü wü kpara adu awu, gü ba, Me fe engu tima me-ye fanü. Angü ngü la tï kpini de ngü, ta te Me mala gömö *mürü dofo Yïsaya, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ceka la! Dene kpara te ni, Me, fe teka amere tima ka-ni, angü ni le engu de maguma ni ꞌburu, da engbü de tadu teka ngü kaka-na. Ni ena ato *Nzïla Wazi ni emamaguma. Ah ena amala nga ni fü wü kpara füh kotö ne ꞌburu, gü ba, ni, Me, ena aküwa ewü. ");
INSERT INTO muh_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kpara ka-ni la tï adi ewü nga, da ega yïkï de wü kpara nda de. Ah tï adi emala ngü de mere ri ye, adi ecu ngü ye, kpah de. ");
INSERT INTO muh_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wü kpara te wazi ewü di ma, baka gala te lölö di walawala, anga baka wa te ngbü nuuu ne, engu tï adi emere ewü esiti de. Engu ena adi ele ta-ngü te ewü, da erï ewü ferrre, de züka maguma ye. Ah ena amere tima ka-ye la bala, zalü te wü kpara ꞌburu ena aje rïrï ka-ni, Me, mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Te di bala, wü nguwa wü kpara füh kotö ne ꞌburu ena ao maguma wü eküküte.” Dela ngü te Me mala gömö mürü dofo Yïsaya ta gügü, teka ngü ka Yesu, o wüh bï engu la de. ");
INSERT INTO muh_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Fütanga ngü la, fü wü gara kpara akoro de gara komoko kpaka Yesu, te jijia ni ani. Ah ro mö nda kpah de, teka *siti wü di enga me te di guguvu. Fü Yesu ayia aküwa komoko la. Fü komoko la akpo da ero mö, kpah da eceka kpï. ");
INSERT INTO muh_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Fü ngü la aga gbü jia wü kpara ꞌburu afa sü. Fü ewü akpo da emala ngü esüka wü, gü ba, “Yesu ena adi de kundu ye Miri *Davidi, te Me le atima teka aküwa ani ne, de?” ");
INSERT INTO muh_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Baka te wü *Farusi je ngü te wü kpara ngbü emala gömö wü de bala ne, fü ngü la ake te ewü efa sü. Fü ewü amala, gü ba, “Me to wazi la fü Yesu me-ye nda de. Yesu maka wazi, teka adi eliki wü di enga me di la, esaka *Satana, miri ka *siti wü di enga me ne.” ");
INSERT INTO muh_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Te Yesu wu fïngangü ka wü Farusi la bala, fü ah ayia amala ngü fü ewü, gü ba, “Te nguwa wü kpara biringbö kpo ngbü emere gü esüka wü la, ngü la ena adi mbi? Ah reke nda de! Nguwa ewü ena akpi, anza ka! Kpah bala, te wü kpara gbü kötï biringbö kpo eyi da emömörö te-wü la, ah ena atï atï? Ah tï kpah de! Kötï la ena asiti, fü ewü abaya asidi! ");
INSERT INTO muh_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Angü, te Satana du ngbü tïne eyi cu egü gü de wü kpara ka-ye la, ah ena ayiri gbü miri ka-ye la ayiri? Engu tï ayiri de, ngü kaka ena anza.” ");
INSERT INTO muh_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Fü Yesu adu ayi-ta wü Farusi la, gü ba, “Te yi gü ba, ma ngbü eliki wü di enga me de wazi ka Satana la, amba e-ngbü eto wazi fü wü kpara ka-yi, teka adi eliki wü di enga me di, neh da? Teka ngü la, wü kpara ka-yi, ena adi emala nga yi zu me-wü fü wü kpara, gü ba, ngü te yi mala la, ah de töndö ngü. ");
INSERT INTO muh_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ma emala fü yi fanü fanü, gü ba, ma ngbü eliki wü di enga me ne gbü wazi ka *Nzïla Wazi Me. Te di bala, ah le de yi wu, gü ba, ma de kpara te Me tima teka aküwa ani ne! ");
INSERT INTO muh_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yi fï la nga ngü ne mbi mbi mbi! Te kpeke kpara ladü, te di de wazi ye fa sü, e-ena arï kpa esambü kaka, agbene wü e kaka, neh da? Angü ah ngbü eceka kpï fütanga kambü ka-ye ꞌbe ꞌbe ꞌbe. Amba, te gara kpeke kpara koro, te wawazi fa nda gina kpara la, ah ena azoro engu, ai gö! agbene wü e kaka ꞌburu, anü sü di. Te di bala, ah le de yi wu, gü ba, wazi ra fa nda Satana, te ngbü embü yi de füh kotö ne ka. ");
INSERT INTO muh_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mene kpara te le ngü ka-ra de, engu de vügü ka-ra. Te kpara le ta-ngü te ra gbü tima ka-ra kpah de la, engu ngbü dela egïrï kaje teka asiti tima ka-ra la. ");
INSERT INTO muh_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ma emala fü yi dene zu ngü. Wü *siti ngü ꞌburu, de te wü kpara ngbü emere, te kpara fü maguma ye la, Me ena aboro wü ngü kaka la ꞌburu. Kpah bala, wü ngü te wü kpara ngbü emala esiti te ïrï Me ne, Me ena aboro kpah asidi. Amba ꞌduwa kpara te ngbü efala Nzïla Wazi Me, Me tï aboro siti ngü kaka la kpo fï de. ");
INSERT INTO muh_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wayi, te mü mala bü siti ngü, da efala ra di la, ngü ma! Me ena aboro siti ngü la, te mü fü maguma mü eyi la. Amba ꞌduwa te mü ngbü emala siti ngü, da efala Nzïla Wazi Me la, Me tï aboro siti ngü ka-mü la nda de. Lïya ka-mü la ena angbü gbü nzö mü bala fï mere badi. ");
INSERT INTO muh_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ngü ka-yi kpah baka ngü ka rü te ngbü erï, fü wü kpara angbü ewu rïrï na. Züka rü ngbü erï kpah bü züka rï-rü, fü wü kpara angbü ezü. Siti rü ngbü erï nda-ye kpah siti rï-rü, te wü kpara tï azü de. Ah bala de? Angü züka rï-rü tï arï eküte siti rü ne, nda de. Anga siti rï-rü tï arï eküte züka rü ne, kpah de. Te di bala, yi tï awu rü teka ngü ka rïrï na. Kpah bala, wü kpara tï eyi awu maguma yi, teka wü ngü te yi ngbü emere. ");
INSERT INTO muh_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","De-yi wü *Farusi, yi de siti wü kpara! Yi de wü mürü mani baka kpürü! Te di bala, yi tï amala züka ngü nda-yi de. Angü wü ngü de te kpara ngbü emala te komö ye ne, ah de wü ngü te ngbü ekoro emamaguma. ");
INSERT INTO muh_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Te di bala, züka kpara ngbü emere züka wü ngü ka-ye duu me-ye, angü züka wü ngü ladü emamaguma. Kpah bala, siti kpara ngbü emere nda-ye kpah fï bü siti wü ngü, te di emamaguma. ");
INSERT INTO muh_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ma emala fü yi dene zu ngü. Gbü sïkpï te Me ena akolo ngü ka wü kpara tete, ah ena ato kuru te yi, teka siti wü ngü te yi ngbü emala ne. ");
INSERT INTO muh_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Angü wüh ena aye süka ngü ka-mü, te nga wü ngü de te ngbü ekoro gömö mü ne. Te mü ngbü ta emala züka ngü la, ngü ka-mü ena adi mbi, angü mü ena amaka tadu gbü ngü la. Amba te mü ngbü ta emala siti ngü la, ngü ka-mü ena adi kpah esiti, angü mü ena amaka cïnga gbü ngü la.” ");
INSERT INTO muh_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Fütanga ngü la, fü wü gara *mürü rïrï de wü *Farusi ayia amala ngü fü Yesu, gü ba, “Mere kpara, ani ena awu baye baye, gü ba, Me tima ye me-ye fanü? Ah le de ye mere la gara talara ngü, fü ani awu.” ");
INSERT INTO muh_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Fü Yesu alügü ngü fü ewü, gü ba, “De-yi, yi ka-yi de siti wü kpara, te yi le ngü ka Me nda-yi de. Te ma ena amere wü talara ngü gbü jia yi la, yi ena ale ngü ka-ra fanü? Yi tï ale nda-yi de! Te di bala, Me tï agü tamu talara ngü biringbö fü yi nda de. Amba ah ena adi bü mene talara ngü, te ena amere te-ye baka nda *Yona tane. ");
INSERT INTO muh_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fanü fanü, ngü ka-ra ena adi kpah baka nda Yona. Angü Yona tï ta gbü mere *yï-ngu, fü mere si ayia ami engu. Fü Yona ara guvu mere si la sïkpï bata. Gbü ebabata sïkpï la, fü si la ayia azï Yona kpa edere ngolo, füh siki. Fü Yona ayia anü agbü Nineve, ba e ta te Me mala fefe, de ah nü mala ngari ni, Me, fü wü kpara de kpala ne. Fü ngü ka Yona la agü tamu wazi ka Me fü wü kpara ka Nineve. Fü ewü ayia afü maguma wü. Kpah bala, de-ra *Ye Kpara ka Kpï, kö ra ena ara gbü tö sïkpï bata. Gbü *ebabata sïkpï la, fü ra adu azükü. ");
INSERT INTO muh_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Te di bala, gbü *adu sïkpï te Me ena akolo ngü ka wü kpara füh kotö ne ꞌburu tete, ah ena ato mere kuru te yi, angü yi le ngü ka-ra de. Wü kpara ka Nineve ena ayia gbü sïkpï la, amala nga *siti ngü ka-yi, angü wüh je ta ri Yona, fü ewü afü maguma wü, adu ale ngü ka Me. Amba ngü ka-ra, te fa nda Yona ka ne, yi le aje nda-yi de. ");
INSERT INTO muh_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kpah bala, mere würüse ta te engu di de miri ka Seba, ena ayia kpah amala nga siti ngü ka-yi. Angü würüse la yia ta agbü tö ka-ye nengete, fü ah akoro teka aje kpeke rïrï gömö Miri *Solomona. Angü Me to ta mere wazi fü Solomona, teka adi ewu wü ngü di. Amba wazi rïrï ka-ra, te fa nda Miri Solomona ka ne, yi le nda-yi kpah de! Dela si-ngü te Me ena ato mere kuru te yi tete ne, angü engu tima ra teka aküwa yi, amba yi le ngü ka-ra nda-yi de!” Dela ngü te Yesu lügü fü wü Farusi, te ewü yi-tata teka talara ngü. ");
INSERT INTO muh_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Fü Yesu adu amala kpah gara ngü fü ewü, gü ba dene, “Te Me liki wü *di enga me eyi guvu kpara asidi la, wü di enga me la ena amere baye? Wüh ena anü, angbü endoro gbü wü siti sü te ürü aürü, agïrï sü te ewü ena angbü tete. Amba, te ewü maka sü de la, ");
INSERT INTO muh_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","wüh ena adu afï nga ngü, gü ba, ‘Ani du la edu agbü sü ka-ani, ta te ani ngbü gbügbü na ne.’ Te wüh du kpaka kpara la, fü ewü amaka sü emaguma kpara la fï bü kükürü, baka kambü te kpara di gbügbü na ma la, ");
INSERT INTO muh_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","wüh ena anü agïrï gara wü bu wü, de ani ngbü de ewü. Fü ewü anü amaka wü gara wü bu wü lorozi, te wazi ewü fa nda gina ewü la ka. Fü ewü adu arï, angbü de ewü guvu kpara la. Te di bala, adu ngü ka kpara la ena angbü baye? Ah ena angbü emere wü *siti ngü tïne, efa mene wü ngü, de ta te engu ngbü emere te enga gina ne ka. Te di bala, ah le de yi ceka te-yi mbi, angü dela ngü te ena amere yi, wü siti kpara, angü yi le ngü ka-ra nda-yi de.” ");
INSERT INTO muh_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Baka te Yesu ngbü la fï bü erï mere bi wü kpara bala, fü wü ni ye Yesu de wü di enga ni Yesu akoro, angbü kpa etanü, angü da ewü, te ewü ena arï, akoro kpaka Yesu, aro mö de ewü, ma, teka ngü ka mere bi wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Fü gara kpara ayia amala ngü fü Yesu, gü ba, “Mere kpara deyï, wü ni ye, de wü di enga ni ye, koro eyi, ngbü kpa etanü kpane. Wüh ngbü ta ele aro mö de wü ye.” ");
INSERT INTO muh_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","49","Te Yesu je ngü la bala, fü ah ayia amala ngü fü kpara la, gü ba, “Ah mbi, amba de-yi, wü kpara te yi biti te-yi sene, teka aje ngü ka-ra ne, yi kpah de wü di enga wüna, de wü wüna. ");
INSERT INTO muh_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Angü te kpara ngbü emere züka ngü, te reke gbü jia Wüba Me agbü kpï la, kpara la kpah de enga wüna, anga wüna.” Dela ngü ta te Yesu mala fü mere bi wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Bü gbü sïkpï engu la, fü Yesu ayia sela, anü akoro era mere ngu *Galïlaya. Fü ah ayia angbü ka-ye kötö kpala, akpo da erï wü kpara ka-ye de ngari Me. ");
INSERT INTO muh_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Fü mere bi wü kpara aci akoro gbe kpakaka na la. Te engu wu bala, fü ah ayia alï ka-ye agbü *zabu, aka te-ye mba canza, anü angbü ka-ye kpala füh ngu, angü wü kpara ena adere ni. Fü mere bi wü kpara la areke te-wü, angbü nda-wü edere ngu sela, da eje ngü gögömö na. ");
INSERT INTO muh_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Fü Yesu angbü erï ewü de mere bi wü ngü ꞌburu gbü mani, gü ba dene, “Gara komoko ta ladü, te za nguwa ndo ka-ye, anü di, amoko kpa agbü yï. ");
INSERT INTO muh_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Te engu kpo ngbü emoko nguwa ka-ye la, fü wü gara jia ndo la, atï te kaje. Fü wü lu awu, akoro adoro. ");
INSERT INTO muh_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Fü wü gara jia ndo la atï füh sï-da, te tö di sela mbi mbi ma. Fü nguwa la ayia akö kere, angü tö sela sere sere. ");
INSERT INTO muh_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Te ra kpo ngbü esü tete, fü wü fu-ndo la aürü ka-wü ꞌburu, angü sï ewü rï gbü tö mbi mbi nda de. ");
INSERT INTO muh_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fü wü gara nguwa ndo la atï ka-wü esüka wü ti. Fü wü nguwa la akö, aga de wü fu-ti la ꞌburu. Fü wü ti awündü züka fu-ndo la. Fü ndo la afü te-ye ꞌburu yï-andüla tete, angü wü fu-ti la ta ewü eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Fü wü gara nguwa ndo la, atï nda-wü gbü züka sü. Fü ewü ayia akö, aga agere, arï gbrrri! Gara zï jia ye mbi, gara zï jia ye fa sü, gara zï jia ye reke ꞌduwa ba-neh-ene-la, angü wüh tï gbü züka tö.” ");
INSERT INTO muh_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Fü Yesu adu amala fü ewü, gü ba, “Te güje mü ladü la, de mü da güje mü te ngü ka-ra la mbi mbi mbi.” Dela ngü te Yesu mala teka nguwa te wüh moko gbü tö. ");
INSERT INTO muh_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Fütanga ngü la mba cüküꞌdaye, fü wü *kpara ka Yesu ayia akoro kpakaka, ayi-tata, gü ba, “Mere kpara, ah mere neh baye, te mü ngbü emala ngü fü wü kpara ne, gbü mani de bane ne?” ");
INSERT INTO muh_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Fü Yesu alügü ngü fü ewü, gü ba, “Wü kpara ta gügü ne, wüh je si-ngü ka Me nda-wü de. Ngü ka Me ngbü gbü jia ewü ꞌdaaa, ah wo te-ye awo. Amba nda-yi, wü kpara ka-ra, yi tï eyi aje si-ngü la, angü ma ngbü esere ngü la fü yi me-ra, gü ba, Me le de wü kpara ꞌburu to maguma wü fü ni. Amba wü gara kpara la tï aje si-ngü la nda-wü de, angü wüh le aje ngü ka-ra de. ");
INSERT INTO muh_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kükürü de, angü te mü le ngü ka-ra ne eyi la, Me ena adu agü tamu gara wü ngü fü mü gbe. Amba te mü le aje ngü ka-ra nda-mü de la, mba enga ngü cüküꞌdaye, te di gbü nzö mü ne, ah ena adürü ka-ye adürü asidi. ");
INSERT INTO muh_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dela si-ngü te ma ngbü emala ngü fü wü kpara tete gbü mani, angü mere bi wü kpara le ngü ka-ra de. Wüh ngbü eceka ngü ka-ra, amba wüh tï awu sisi nda-wü de. Wüh ngbü kpah bü eje ngü ka-ra, te ma ngbü emala ne, amba sisi na rï gbü nzö ewü mbi mbi nda kpah de. ");
INSERT INTO muh_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wü kpara te ewü ngbü emere ngü de bala ne, wüh ena adi baka wü kpara, ta te Me mala ngü ka-ewü gömö *mürü dofo Yïsaya, gü ba dene, ‘De-wü deyï, wü ena aceka ngü ka-ni, Me, ma, wü tï awu si-ngü la nda-wü de. Wü ena aje ngari ni, Me, ma, ngü la tï arï gbü nzö wü kpah de. ");
INSERT INTO muh_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Angü nzö wü koro eyi kpekpeke teka ngü ka-ni. Wü ni güje wü ka-wü ani, angü wü le aje ngü ka-ni de. Wü ni jia wü kpah ani, angü wü le awu si-ngü ka-ni kpah de. Angü te wü ena aje ta si-ngü ka-ni, Me, mbi mbi la, de bane wü ena ace *siti ngü ka-wü, adu ale ngü ka-ni. Fü ni, Me, aküwa wü.’ Dela ngü ta te Me mala gügü teka wü kpara, te ewü le ngü ka-ra de ne. ");
INSERT INTO muh_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amba nda-yi, ah le de yi ngbü de mere tadu, angü yi ngbü eceka wü ngü, de te ma ngbü emere ne, cu de jia yi! Yi ngbü kpah eje wü ngü te ma ngbü emala ne, cu de güje yi ereke areke! ");
INSERT INTO muh_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ma ngbü emala fü yi dene zu ngü. Ta gügü wü *mürü dofo, de wü gara kpara ka Me ꞌburu, ngbü ta de gümü ngü ka-ra te wü, teka awu ra cu de jia wü, teka de ani di eje ngü, baka te ma ngbü emala fü yi dene, cu de güje ani. Amba wüh je nda-wü de, angü wüh kpi ka-wü eyi gügü.” ");
INSERT INTO muh_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Fü Yesu adu amala fü ewü mbölö, gü ba, “Dene si-ngü gbü mani ka kpara te moko nguwa ne. Ah le de yi da güje yi reke areke, teka aje ngü gbügbü. ");
INSERT INTO muh_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Si mani ka nguwa te tï te kaje, ah baka ngü ka mene wü kpara, te wüh mala ngari Me fü ewü, amba ngü la rï gbü nzö ewü de, angü wüh le aje de. Fü *Satana awu bala, ayia kere, akoro aza ngü la emaguma ewü asidi. ");
INSERT INTO muh_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mene nguwa te tï füh sï-da, ah baka mene wü kpara, te wüh mala ngari Me fü ewü. Fü ewü ale ngü la kere, de mere tadu. ");
INSERT INTO muh_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amba wüh rü kpekpeke gbü ngü ka Me de, angü maguma ewü ka-ye ꞌbasu ꞌbasu. Teka ne de, angü wüh to maguma wü fü Me mbi mbi de. Sidi nga sïkpï mba cüküꞌdaye, baka te cïnga koro maka ewü teka ngü ka Me, fü ewü ayia ace ngü ka Me ka. ");
INSERT INTO muh_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mene nguwa te tï esüka wü ti ne, ah baka wü gara kpara te ewü je ngari Me mbi, amba fïngangü ka-ewü ka-ye teka wü ngü de füh kotö ne. Fü gümü wü e ka kotö ne adürü fïngangü ka-ewü, teka ngü ka Me asidi. Teka ngü la, wüh mere tima ka Me mbi mbi de. Wüh ka-wü baka ndo te koro eyi yï-andüla tete. ");
INSERT INTO muh_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mene wü nguwa te ewü tï nda-wü gbü züka sü ne, ah baka mene wü kpara, te ewü je ngari Me, fü ewü ale de maguma wü biringbö, azoro ngü la de kpa wü ꞌbasu, ao to wü, angbü emere. Te di bala, wü kpara la baka ndo te rï reke areke gbrrri. Gara zï jia ye mbi, gara zi jia ye fa sü, gara zi jia ye reke ꞌduwa ba-neh-ene-la. Dela si-ngü gbü mani teka nguwa ndo la.” ");
INSERT INTO muh_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Gbü gara sïkpï fü Yesu adu amala kpah gara mani fü mere bi wü kpara la, gü ba, “Tima ka Me, ah kpah baka ngü ka gara kpara te nü ru ndo ka-ye agbü yï. ");
INSERT INTO muh_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Gbü biti, o wü kpara ngbü ꞌburu era ara, fü gara vügü kaka-na akoro, amoko nguwa siti gü gbü ndo kaka la, ayia anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Te ndo la kpo ngbü ekö, fü nguwa siti gü la akpo kpah ekö. Fü fu-ndo angbü ega tundu de wü siti gü la. ");
INSERT INTO muh_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Fü wü kpara ka tima ka mürü ndo la, akoro amala ngü fefe, gü ba, ‘Apa, mere kpara! Nguwa ta te ye ru ne, ah ka-ye bü de ndo kpikpi ye de? Amba tïtïne siti gü du kö koro gbügbü, neh baye baye?’ ");
INSERT INTO muh_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Fü engu alügü ngü fü ewü, gü ba, ‘Gara vügü ka-ni nü mere ngü la bala me-ye.’ Fü wü kpara ka tima kaka ayi-tata, gü ba, ‘Ye ele de ani nü gbürü wü siti gü gbü ndo la asidi?’ ");
INSERT INTO muh_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amba mürü ndo la le bala de. Fü ah amala ngü fü ewü, gü ba, ‘Wü mere bala la de. Angü te wü nü gbürü wü siti gü la tïtïne la, wü ena agbürü wü fu-ndo ekuru wü siti gü la. ");
INSERT INTO muh_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wü ce wü siti fu-gü la bala. Te ndo la ndri eyi ꞌburu la, ni ena amala fü wü kpara ka tima, gü ba, “Wü gbürü la wü siti gü de gbü ndo la te enga gina. Fü wü ai, abiti nzönzö nzönzö bala. Fü wü agü ewü agbü wa. Fü wü adu awa ndo ka-ni la, abiti ewü ꞌburu agbü kafa.” ’ ” ");
INSERT INTO muh_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Fütanga wü ngü la, fü Yesu adu amala kpah gara mani fü ewü, gü ba, “Ma le amala gara ngü mani, teka agü tamu ngü ka Me di fü yi. Angü, ngü ka Me ka-ye baka jia gara rü de ïrï ye müsïtada, te di de jia ye baka jia lïꞌba, jürrrü bane. Te mü ru jia rü la, ah ena aga, akoro mere rü, te wü lu ena angbü efe te-wü gbügbü. Kpah bala, ngü ka Me ena aga te gara, akoro memere, baka ngü ka rü la.” ");
INSERT INTO muh_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Fütanga ngü la, fü Yesu adu kpah amala gara mani fü ewü, gü ba, “Ngü ka Me ka-ye kpah baka *kö, te würüse ngbü eküꞌda zu ambata di. Fü kö la angbü emere tima ka-ye gbü ambata la ferrre. Fü ah akpo da eu, eu, zalü akoro memere.” Dela wü mani ꞌbasu te Yesu mala fü wü kpara, teka ngü ka Me, te kpo mba ꞌdongoni, amba te gara, ah ena aga akoro memere. ");
INSERT INTO muh_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu ngbü ta emala bi wü ngü ka-ye fü wü kpara la, ꞌburu gbü mani. Ah mala si wü ngü la fü ewü mbölö mbölö nda de. ");
INSERT INTO muh_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngü te Yesu ngbü mere la, Me sere fefe me-ye, de ah di egü tamu ngü fü wü kpara di. Ngü la tï kpah kpini de ngü, ta te Me mala gömö gara *mürü dofo, gü ba, “Ni ena angbü erï wü kpara ꞌburu gbü mani. Engu ena amala kpah nga wü ngü te wo te-ye awo fü ewü.” ");
INSERT INTO muh_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Fütanga wü ngü la, fü Yesu ace bi wü kpara la, ayia arï ka-ye kpa esambü. Fü wü kpara kaka-na ayia akoro kpakaka na, ayi-tata, gü ba, “Mere kpara, ye gü la tamu si mani ka siti gü, te ye mala nganga, fü ani ne.” ");
INSERT INTO muh_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Fü Yesu alügü ngü fü ewü, gü ba, “Ah mbi. Mene kpara te moko züka nguwa ndo gbü yï ne, ah ka-ye de-ra, *Ye Kpara ka Kpï. ");
INSERT INTO muh_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yï engu ne, ah ka-ye de kotö ne. Züka nguwa ndo, te ewü ru la, ah de yi, wü kpara te yi le ngü ka-ra, fü yi ato maguma yi fere. Siti nguwa gü la, ah de wü kpara ka *Satana. ");
INSERT INTO muh_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Vügü te nü moko siti nguwa gü la, ah ka-ye de Satana. Kpïrï ndo, ah de *adu sïkpï, te Me ena akolo ngü ka wü kpara ꞌburu tete. Wü kpara ka tima, te ewü ena awa ndo la, ah de wü *malayïka ka Me. ");
INSERT INTO muh_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Angü gbü adu sïkpï, de-ra Ye Kpara ka Kpï, ma ena atima wü malayïka ka-ra, fü ewü anü aro la fi wü kpara, te ewü ngbü efiti wü bu wü, de wü siti kpara ꞌburu, agü ewü agbü mere du ka wa, kpah ba e te wü kpara ka tima ro siti gü agbü yï, fü ewü agü agbü wa ne. Wü siti kpara la ena angbü kpala da eku gba de mere cïnga, da enyüma gbü te wü. ");
INSERT INTO muh_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amba wü kpara ka Me ena angbü agbü sü ka Me, fü ewü angbü eci aci baka ra te ngbü eci agbü kpï. Fü wü kpara ꞌburu angbü egbo nga ïrï ewü. Te güje yi ladü, ah le de yi da güje yi te ngü ka-ra ne mbi mbi mbi.” ");
INSERT INTO muh_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Fü Yesu adu amala kpah gara ngü fü ewü, gü ba, “Ngü ka kpara te je ngü ka-ra, fü ah afü maguma ye, ara fü Me, ah kpah baka ngü ka gara komoko ta te nü ngbü emere tima gbü yï. Fü ah ayia amaka mere bi jiase ta te gara kpara wo, o gbü tö sela gügü. Fü ah adu aza jiase la, awo kpah, ao te nga jia ye, gbü yï sela. Fü ah ayia adu agba ye, aza wü e ka-ye, acïnzï ꞌburu asidi. Fü ah amaka bi jiase, adu anü ase yï engu la, teka de jiase, ta te wüh wo o gbü tö la, ngbü tïne fü ni. ");
INSERT INTO muh_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ngü ka kpara te je ngü ka-ra, fü ah afü maguma ye, ara fü Me, ah kpah baka ngü ka mere kpara te ngbü egïrï züka ꞌbiri, te wüh ngbü ese de mere bi jiase, teka de ni se fü ni. ");
INSERT INTO muh_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Fü kpara la anü amaka gara memere na, te su fa sü, de mere bi jiase gbü ye. Fü engu adu anü acïnzï wü gara e ka-ye ꞌburu. Fü ah aza jiase la, anü ase ꞌbiri engu la di. Fanü fanü, ngü ka Me fa wü gara ngü füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Fü Yesu adu amala kpah gara mani fü ewü, gü ba dene, “Me ena ato kuru te wü kpara te ewü le ngü ka-ra de, te gara. Ngü la, ah kpah baka ngü ka yïmba, te ewü egü gbü ngu, teka azoro wü si di. Te wüh gü yïmba la eyi gbü ngu la, bi wü si, gbü nguwa wü kpikpi ye kpikpi ye, ena aba ꞌburu gbü yïmba la. ");
INSERT INTO muh_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Te yïmba la diri tïne eyi ka bi wü si gbü ye la, fü wü mürü yïmba la agbeke yïmba ka-wü la kpa füh gümba, teka afe züka wü si gbügbü na la. Fü ewü aza züka wü si ka-wü la ꞌburu, ao gbü kuwu. Fü ewü adu amörö wü sisiti na la ꞌburu, abu kö ewü agbü gü. ");
INSERT INTO muh_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ngü ka Me ena amere te-ye te gara, gbü *adu sïkpï, kpah bala. Angü wü *malayïka ka Me ena akoro, teka aye süka züka wü kpara de siti wü kpara. ");
INSERT INTO muh_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Wüh ena aza siti wü kpara la ꞌburu agü agbü mere du ka wa. Fü ewü angbü eku gba kpala de mere cïnga, da enyüma gbü te wü.” ");
INSERT INTO muh_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Fü Yesu adu ayi-ta wü kpara ka-ye la, gü ba, “Wü ngü de te ni ngbü emala fü wü ne, wü je sisi na eyi mbi mbi mbi?” Fü ewü alügü ngü, gü ba, “Wayi, mere kpara, ani je eyi mbi.” ");
INSERT INTO muh_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Fü engu amala fü ewü, gü ba, “Te di bala, de-yi, wü kpara ka-ra, yi ena adi baka mürü kötï, te rï gbü kafa ka-ye, teka agïrï wü e, te engu ena agafa fü wü kpara, wü didiri na be kpah te wü toto na. Ma mala ngü la kükürü de, angü yi wu da erï wü kpara de gina *Rïrï ka Me, be kpah te to ngü ka-ra, te ma ngbü emala fü yi ne, kpo.” ");
INSERT INTO muh_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Te Yesu mala ngü la fü wü kpara ka-ye nza tete, fü ewü ayia ace sü la, anü sü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Fü wü Yesu adu anü ka-wü agbü Nazareta, gbü kötï ka-wü, ta te engu ga gbügbü na ne. Fü engu akpo da erï wü kpara kpa *esambü ka biti-te ka-wü kpala. Fü ngü ka Yesu, te engu ngbü erï wü kpara di ne, aga gbü jia wü kpara la afa sü. Fü ewü angbü da emala ngü esüka ewü, gü ba, “Apa! Angü komoko ne maka de mere kpeke rïrï de bane neh kaye? Wü mere kpeke ngü ka talara, te engu ngbü emere kpa te wü gara sü ne, e-to wazi la fefe na neh da? ");
INSERT INTO muh_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Komoko ne, de ye kpara, ta te ngbü eforo rü de sene ne de? *Marïya kpah bü de ni ye na. Wü di enga ni ye na bü de wü *Yakobo, *Yüsefa, Sïmüna, bete Yudi, ");
INSERT INTO muh_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","be kpah te wü tangbase kaka, te ani wu ewü ꞌburu kpo ne! Wüh ꞌburu de wü kpara de sene ne! Te di bala, Yesu nü maka nda-ye mere wazi, angbü emere wü lara ngü di, de bane, neh ka-ye?” ");
INSERT INTO muh_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Teka ngü la, wü kpara ka Nazareta le ngü ka Yesu nda-wü de, angü Yesu ga nza kpah bü esüka ewü sela. Fü Yesu adu amala ngü fü ewü, gü ba, “Te mü de *mürü dofo la, wü kpara ena angbü ecu ngü mü acu gbü wü sü ꞌburu. Amba ꞌduwa gbü sü te ewü bï mü tete, wüh tï acu ngü mü nda-wü de. Dela si-ngü te yi le acu ngü ra tete na nda-yi de ne.” ");
INSERT INTO muh_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Teka ngü la, Yesu tï amere wü ngü ka talara gbü Nazareta fa sü nda de, angü wüh le ngü kaka nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gbü wü re engu la, Anïtïpa *Erode ta de mere miri ka wü *Galïlaya. Gbü gara sïkpï, fü miri la ayia aje nga Yesu. Angü ïrï Yesu wü eyi gbü wü sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Te engu je nga Yesu bala, fü ah angbü de cürü. Fü ah amala ngü fü wü kpara ka-ye, gü ba, “Wayi, komoko la, ah ena adi de *Yüwane Mürü Babatïza, ta te ni mörö engu ne. Ah ena azükü gbü kpi dela eyi me-ye! Dela si-ngü te engu ngbü emere bi wü ngü ka talara de bala.” ");
INSERT INTO muh_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Yüwane kpi ta kükürü nda de. Ngü ladü gbügbü na. Angü Miri Anïtïpa Erode mörö Yüwane ta me-ye, teka ngü ka wara ye, de ïrï ye Erodïya ne. Angü miri la fa ta würüse la esaka gara enga ni ye, de ïrï ye *Fïlïpo. Fü ah adu aza engu wara ye tete. Teka ngü la, fü Yüwane ayia amala ngü fü miri la, gü ba, “De-ye deyï, ngü te ye mere la, ah de *siti ngü. Ye fiti wara enga ni ye baye? Ah tï ta fü ye amere bala de. Angü dela siti ngü gbü jia Me!” Teka ngü la, fü ngü ake te Miri Anïtïpa Erode. Fü ah ayia azoro Yüwane, agü agbü ku. ");
INSERT INTO muh_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Miri la ngbü ta egïrï kaje de ni mörö Yüwane tete na, amba cürü ngbü kpah emere engu amere, angü wü kpara ꞌburu ngbü ta eceka Yüwane, baka *mürü dofo ka Me. ");
INSERT INTO muh_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gbü gara sïkpï, fü Miri Anïtïpa Erode ayia amere mere karama ka-ye, teka afï nga sïkpï, te wüh yaka engu tete na. Enga wara miri la ta ladü, ye würüse. Fü jaji würüse la ayia akpo da elo bï engagira wü kpara, te ewü koro gbü karama la. Fü bï ka jaji würüse la areke gbü jia ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Fü miri la ayia amala ngü fü jaji würüse la, akïna te-ye gbü jia wü kpara ꞌburu, gü ba dene, “Enga ni, bï ka-ye la reke gbü jia ani fa sü. Mene e te ye ngbü ele, de ye yi-ta ni tüngüngü, ni ena ato ato fü ye. Ni tï atïrï de.” ");
INSERT INTO muh_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Fü jaji würüse la ayia akpe kpaka ni ye, ayi-tata, gü ba, “Ni ni deyï, mene e te ye ele de ni yo te miri, ah de neh ene?” Fü ni ye na amala fefe, gü ba, “Ye mala fü miri, de wüh nü, wüh mörö Yüwane, de wüh wa nzönzö na, wüh o gbü gada, wüh koro di fü ye, teka fü ani awu, gü ba, Yüwane kpi eyi fanü.” Fü jaji würüse la akpe adu kpaka miri la, amala kpah bala. ");
INSERT INTO muh_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Fü ngü la ato mere fïngangü fü Miri Anïtïpa Erode. Amba teka ngü ka kïna, de te engu kïna te-ye di, gbü jia wü ngba ka-ye ne, ah le ace kïna ka-ye la tïne de, ka vi-jia. Te di bala, fü ah ayia amala ngü fü wü marajümïya ka-ye, teka de wüh nü agbü ku, awa nzö Yüwane, akoro di, ato fü jaji würüse la. ");
INSERT INTO muh_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Fü ewü anü ade ngürü Yüwane, aza nzönzö, akoro di gbü gada, ato fü jaji würüse la. Fü jaji würüse la ayia aza e la, anü di, ato fü ni ye. Dela ta kaje te *Yüwane Mürü Babatïza kpi tete. ");
INSERT INTO muh_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Te wü kpara ka Yüwane Mürü Babatïza je ngü la, fü ewü akoro, abï kökö na, anü di, ati. Fü ewü adu anü amala nga ngü la fü Yesu. ");
INSERT INTO muh_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Te Yesu je, gü ba, wüh mörö *Yüwane Mürü Babatïza eyi ne, fü engu ayia de wü kpara ka-ye, alï gbü *zabu, anü sü ka-wü kpa etangu, gbü sü te kötï di tete ma. Amba mere bi wü kpara je eyi, gü ba, wü Yesu nü sü eyi kpala. Fü wü kpara la aci ꞌburu, ayia afa nga wü Yesu to füh gümba de lö wü. ");
INSERT INTO muh_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Te wü Yesu nü koro tete gbü sü la, fü ewü amaka mere bi wü kpara kpala kpah gbe. Fü engu angbü de mere cïnga teka ngü ka-ewü. Fü engu akpo da eküwa wü mürü keke, te wü kpara la za ewü koro di ne. ");
INSERT INTO muh_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ah te ekoro etamurago, fü wü *kpara ka Yesu ayia akoro kpakaka na, amala ngü fefe, gü ba, “Mere kpara, ye ceka la ra te etï. Ani ena amere de mere bi wü kpara ne, neh baye? Tala mere ewü de? Ah le ta fü ye amala ngü fü ewü, de wüh nü kpa gbü wü gara kötï, agïrï e, ase, azü. Angü sü kpakine edere sü, kötï tete nda ma.” ");
INSERT INTO muh_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Fü Yesu alügü ngü fü ewü, gü ba, “Dela neh ene ngü ne? Yi mere e ace wü kpara la, fü ewü ago de. Ah le de yi to zü-e me-yi fü ewü.” ");
INSERT INTO muh_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wüh gü ba, “Akooo, mere kpara! Ambata esaka ani sene ngbee ꞌburuve bete si ꞌbasu. Wü e la ena atï de mere bi wü kpara la atï fanü?” ");
INSERT INTO muh_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu gü ba, “Yi za wü e la, yi koro di kpaka ra akine.” ");
INSERT INTO muh_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Te wüh koro de ambata bete si la kpaka Yesu, fü engu amala ngü fü bi wü kpara la, de wüh ngbü kötö, füh wü fu-gü sela. Fü engu ayia aza ambata ꞌburuve bete wü si ꞌbasu la, aceka kpï kpa tikpi, agbo nga ïrï Me tekaka. Fü ah akukuru tü wü e la, ato esaka wü kpara ka-ye, de wüh gafa fü wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Fü wü kpara ꞌburu azü e la, asika di, ace dudu. Fü wü kpara ka Yesu ayia aro du wü e la, asi gbü wü kuwu nzükpa de füh ye ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Dela ngü ta te Yesu mere, te engu to zü-e di fü mere bi wü kpara. Wü kpara te ewü zü wü e la, wüh ta baka wü komoko kutu ꞌburuve (5,000). Amba wüh tanga wü jaji de wü würüse nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Fütanga zü-e la, fü Yesu amala ngü fü wü *kpara ka-ye, gü ba dene, “Wü lï elï gbü *zabu, fü wü anü sü nda-wü kpa engagira nü, kpa etangu. Nda-ni, ni ena ato la kaje fü wü kpara ne feke, de wüh go agba wü. Fü ni adu afa nga wü.” Fü wü kpara ka Yesu ayia alï gbü zabu anü sü. ");
INSERT INTO muh_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Fü Yesu ato kaje fü mere bï wü kpara la. Fü ewü abaya, teka ago agba wü. Fü engu adu ayia ka-ye sela, anü kpa füh mere rüvü kpikpi ye, teka aku gba fü Me. Fü engu angbü kpala, da eku gba fü Me, zalü koro di gbü biti, ");
INSERT INTO muh_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","o wü kpara kaka di nda-wü eyi nengete kpa etü ngu gbü zabu. Fü wege akpo angbü efe jia ngu kpekpeke, da enzi ewü, elügü kpa sidi. Fü ngu angbü ekada de ewü. ");
INSERT INTO muh_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ah te ekoro emözekpï, fü Yesu ayia akoro, angbü enü kpaka ewü de lo ye füh ngu. ");
INSERT INTO muh_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Te wü kpara ka Yesu wu Yesu, te ngbü enü füh ngu kpaka wü de bala, wüh wu, gü ba, ah de Yesu ne, nda-wü de. Fü ngü la ato mere cürü fü ewü afa sü. Fü ewü akpo da eba rere, angü wüh fï nda-wü, gü ba, “Ah ka-ye de kuru kpara te ngbü ekoro kpaka ani! Dela sirimbi!” ");
INSERT INTO muh_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Fü Yesu ayia kere, amala ngü fü ewü, gü ba, “Yi mere e akpe cürü de. Ah ka-ye de-ra.” ");
INSERT INTO muh_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Te Petero wu, gü ba, ah de Yesu, fü Petero amala ngü fefe, gü ba, “Mere kpara, te ah ngbürü de mü fanü la, de mü mala ngü fere, de ma kö füh ngu, ma nü kpaka mü la.” ");
INSERT INTO muh_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Fü Yesu amala ngü fefe, gü ba, “Wayi, mü koro ekoro.” Fü Petero ayia akö gbü *zabu, akpo angbü enü kpaka Yesu füh ngu. ");
INSERT INTO muh_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Baka te Petero wu wege te ngbü efe kpekpeke, fü ah akpo erï gbü ngu ne, fü cürü arï tete. Fü ah aku gba te ïrï Yesu, gü ba, “Akooo, mere kpara, mü küwa ra eküwa!” ");
INSERT INTO muh_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Fü Yesu ayia ato kpa ye kere, azoro engu, amala ngü fefe, gü ba, “Apaa Petero! Amba mü to maguma mü fere fanü fanü, nda-mü neh la de? Mü le awu wazi ka-ra fï de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Fü wü Yesu ake Petero adu alï agbü zabu kpaka wü bu wü. Fü wege la adu anga. ");
INSERT INTO muh_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Teka ngü la, fü wü wü kpara ka Yesu, te ewü di gbü zabu la, akpo angbü egbo nga ïrï Yesu, gü ba, “Ye zu de Ye Me fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Fütanga ngü la, fü wü Yesu ayia akö ngu kpa etangu, akoro gbü gara sü de ïrï ye Genezareta. ");
INSERT INTO muh_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Te wü kpara ka Genezareta wu, gü ba, ah de Yesu, fü ewü akpo da amala nganga fü wü kpara gbü sü la ꞌburu, teka de wüh za wü mürü keke ka-wü, akoro di ꞌburu kpaka Yesu, de ah küwa ewü. ");
INSERT INTO muh_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Fü wü kpara la ayia andaꞌba te-wü fü Yesu, de Yesu le fü wü mürü keke, de wüh di emofo bü mö bongo kaka la, teka fü ewü aküwa. Fü Yesu ayia ale ngü la. Te di bala, mene wü kpara, ta te ewü ngbü mofo mö bongo ka Yesu ne, wüh ngbü küwa gbü keke ka-wü la eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fütanga ngü la, fü wü gara wü *mürü rïrï de wü *Farusi ayia agbü Yerüsalema, anü akoro kpaka Yesu. Fü ewü ayi-ta Yesu, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ah mere neh baye, te wü kpara ka-ye ce da emere rïrï ka gele ka wü kundu ani ne? Angü ani ngbü ewu ewü, te wüh le azü e la, wüh le adi ezürü kpa wü te nga rïrï ka gele ka-ani de.” Wüh mala bala kükürü de, angü rïrï ka gele ka wü *Yïsarayele gü ba, te mü le azü e, mü ena azürü kpa mü gbü gara kaje kpikpi ye. Anga te mü ena amere gara ngü, mü ena azürü kpa mü, kpah gbü gara kaje kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Fü Yesu alügü ngü fü ewü, gü ba, “Amba de-yi, yi le aje *Rïrï ka Me de, neh teka ne? Yi ele nda-yi fï bü adi emere wü rïrï ka gele ka wü kundu yi? Dela züka ngü? ");
INSERT INTO muh_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Angü Me to ta Rïrï eyi fü nih, gü ba dene, ‘Ah le fü mü adi ecu ngü wö mü ake ni mü, da eje rïrï ka-ewü.’ ‘Mene kpara te ngbü efala wö ye ake ni ye, ah le de wüh mörö engu amörö asidi.’ ");
INSERT INTO muh_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amba nda-yi, yi gü ba, te kpara kïna te-ye, gü ba dene, ‘Ni le ato e fü wö ni ake ni ni tïne de, angü ni le ato wü e ka-ni la fü Me takpa tete la,’ ngü la ngbü ereke gbü jia yi efa sü. ");
INSERT INTO muh_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Amba te kpara la du ngbü cüküꞌdaye, fü ah adu afü fïngangü ka-ye, fü ah ayia akoro kpaka yi, wü mürü rïrï, agü ba, ‘Ni le areke kïna ta te ni kïna te-ni di ne la,’ yi le nda-yi de. Yi gü ba, ‘Kpara la mere e ace kïna ka-ye la de de de.’ Fü kpara la ayia ace wö ye ake ni ye gbü cïnga teka ngü ka-yi la. Dela züka ngü? Yi le adi ecu ngü ka rïrï ka gele ka-yi, afa Rïrï te Me to ne? ");
INSERT INTO muh_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yi de wü mürü mani! Fanü fanü, *mürü dofo Yïsaya wu mani ka-yi la eyi gügü. Angü Me mala ta ngü la gögömö na, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ni le ngü ka wü mürü mani la de. Angü wüh ngbü egbo nga ïrï ni nda-wü bü de komö wü kükürü, amba maguma ewü le ni nda de. ");
INSERT INTO muh_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wüh ngbü egbo nga ïrï ni, da erï wü kpara, gü ba, “Ani ngbü eto Rïrï ka-ni, Me, fü wü kpara.” Amba dela Rïrï ka-ni nda de. Ah ka-ye de kükürü gele ka wü kundu wü.’ Dela ngü ta te Me mala gömö Yïsaya teka yi.” ");
INSERT INTO muh_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Fütanga ngü la, fü Yesu adu aï bi wü kpara, de te ewü ngbü efa nga ye la, amala ngü fü ewü, gü ba, “Yi da la güje yi, fü yi aje si-ngü te ma le amala fü yi ne mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fïngangü ka-yi gü ba, e te ena asiti yi gbü jia Me, ah de e-mazü? Aꞌa, ah bala de. Ngü te ena asiti yi gbü jia Me, ah ꞌduwa de siti fïngangü te yi ngbü efï emaguma yi, da emala ne.” ");
INSERT INTO muh_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Fütanga ngü la, o wü Yesu du ngbü kpikpi wü de wü kpara ka-ye, fü wü kpara kaka ayia aka te-wü gbamari edede na, amala ngü fefe, gü ba, “Mere kpara, ngü te mü mala la, ah ke te wü *Farusi eyi fa sü. Mü wu bala de?” ");
INSERT INTO muh_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Fü Yesu alügü ngü fü ewü, gü ba, “Yi mere e afï nga ngü ka wü Farusi la baka mere kpeke ngü ne nda-yi de. Angü wüh ka-wü baka siti gü, gbü yï ka Wüba Me. Te di bala, Wüba Me ena agbürü ewü asidi, angü ah ru ewü me-ye nda de. ");
INSERT INTO muh_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yi ce ewü ace. Wüh ngbü efï, gü ba, ani wu ngü fa sü, amba wüh wu ngü ꞌburu ꞌburu nda-wü de. Wüh ka-wü baka kpara, te jijia ni ani, te ele agbeke kiri ye, agü tamu kaje fefe. Te di bala, ngü te ena amere te-ye fü ewü, ah de ne ngü ne? Wüh ena atï ka-wü ꞌbasu mini agbü mere du!” ");
INSERT INTO muh_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Te Yesu mala ngü la bala, fü Petero ayi-ta Yesu, gü ba, “Mere kpara, ah le de mü gü tamu si-ngü gbü ngü mani, teka ngü te ena asiti kpara gbü jia Me, te mü mala tïne fü wü Farusi ne, fü a.” ");
INSERT INTO muh_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu gü ba, “Yi kpah bala? Yi je si-ngü la nda-yi kpah de? ");
INSERT INTO muh_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Zü-e te mü ezü, ah ena asiti mü gbü jia Me neh baye baye? Angü zü-e, te mü ngbü ezü ne, ah nü kpa emaguma mü nda de. Ah enü ka-ye agbü nza mü, anü sü ka-ye agbü gü. Te di bala, zü-e tï asiti mü gbü jia Me nda de! ");
INSERT INTO muh_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amba ngü te ena asiti mü gbü jia Me, ah de *siti ngü, te mü ngbü efï emaguma mü, fü mü adu angbü emala te komö mü. ");
INSERT INTO muh_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Angü te kpara ngbü de siti fïngangü emaguma ye la, wü ngü te engu ena angbü emere ne, ah ena adi kpah ꞌburu de siti wü ngü. Engu ena amörö kpara. Gara, ah ena amere waza, anga yala. Gara, ah ena azi e ka wü kpara. Gara, ah ena asu wu, amala ambalaꞌba eküte kpara, de wü soko. ");
INSERT INTO muh_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dela ꞌburu wü siti ngü, te ewü ena asiti mü gbü jia Me. Amba te mü zü e de libiti te kpa mü la, ngü la tï asiti mü gbü jia Me nda de!” ");
INSERT INTO muh_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Fütanga wü ngü la, fü wü Yesu ayia ace sü la. Fü ewü anü de wü kpara ka-ye agbü wü gara nzö kötï, gbü tö ka wü Kanana, te di gbamari ede mere kötï ka Tera ake Sïdona. ");
INSERT INTO muh_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Fü gara würüse sela akoro, afüwa te-ye kpaka Yesu, agü ba, “Akooo mere kpara, kundu ye *Davidi, te Me tima ye aküwa ani ne, ye ceka la bü cïnga te ni ne. Mbarase ka-ni ladü, jaji würüse, te *siti wü di enga me ngbü emere engu esiti.” ");
INSERT INTO muh_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu, mü lügü ngü fü würüse la nda-mü de. Fü wü kpara kaka-na aka te-wü gbamari edede, amala ngü fefe na kpekpeke, gü ba, “Mere kpara, ye mala ngü fü würüse la, de ah ce da afa nga ani de rere ka-ye la, angü engu ka-ye de egba *ganzi kpara.” ");
INSERT INTO muh_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu gü ba, “Wayi, ah ngbürü bala. Angü Me tima ra fi teka aküwa wü di enga *Yïsarayele, de te wüh dürü te kaje ka Me asidi ne. Ah tima ra kpaka wü ganzi kpara nda de.” ");
INSERT INTO muh_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amba würüse la le ace ngü la nda de. Fü ah aka te-ye akoro, abu nzökuta ye engagira Yesu, afüwa te-ye kpakaka na, gü ba, “Akooo! Mere kpara, mü le ta-ngü te ra baaa!” ");
INSERT INTO muh_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Fü Yesu alügü ngü fefe gbü mani, gü ba, “Te zü-e ladü la, ah le de wüh to la fü wü jaji feke. Angü te wüh za kümü, te wüh le ato fü wü jaji, asötö fi fü wü bürü la, ah de siti ngü.” Yesu mala ngü la bala, angü würüse la ka-ye ganzi kpara fefe. ");
INSERT INTO muh_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Fü würüse la alügü ngü, gü ba, “Wayi, mere kpara, mü mala ngbürü zu ngü. Amba ma kpah baka bürü, te ngbü ero kporo e, te ngbü egürü kötö ne.” ");
INSERT INTO muh_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Fü ngü ka würüse la ayia areke te Yesu afa sü. Fü Yesu amala ngü fefe, gü ba, “Ngü de te mü ngbü ele ne, ah ena amere te-ye fü mü baka e te mü le la, angü mü to maguma mü eyi fere fanü.” Kpah bü ꞌduwa gbü lö-ra engu la, fü yïanga na la ayia aküwa. ");
INSERT INTO muh_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Fütanga ngü la, fü wü Yesu ayia adu ka-wü kpa eküte mere ngu *Galïlaya. Fü ewü anü angbü ka-wü kpa gbü gü, kpa etü wü rüvü kpala. ");
INSERT INTO muh_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Fü mere bi wü kpara ayia aza wü mürü keke ka-wü, akoro di kpaka Yesu. Wü mene ewü te lö ewü di walawala, wü mene ewü te jia ewü di ma, de wü mene ewü te ewü ro mö de, kpah de mere bi wü gara mürü keke. Fü Yesu ayia aküwa ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Fü mere bi wü kpara la awu, gü ba, “Wü mürü keke la küwa eyi ꞌburu. Wü gara ta te ewü ro mö de, wüh du eyi ero mö. Wü kpara ta de lö wü walawala, wüh du eyi enü nü. Wü kpara ta te jia ewü di ma, wüh du eyi eceka kpï.” Fü ngü la aga gbü jia ewü afa sü. Teka ngü la, fü ewü akpo da egbo nga ïrï Mere Me, te di de *vüngüte ka wü *Yïsarayele ne. ");
INSERT INTO muh_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Fütanga ngü la, fü Yesu aï wü kpara ka-ye, amala ngü fü ewü, gü ba, “Cïnga wü kpara ne ngbü erï te ra efa sü, angü wüh ra eyi sïkpï bata dene, zü-e nza esaka ewü eyi. Te ma ce ewü, ago bala la, ah tï de. Wüh ena andïrï te kaje ka tala.” ");
INSERT INTO muh_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Fü wü kpara kaka-na alügü ngü fefe, gü ba, “Ööö, mere kpara, ani ena amaka de mere bi zü-e, te ena atï de mere bi wü kpara baka e la, neh kaye? Te ani di kpakine kpa etü gü, kötï kpah ma ne.” ");
INSERT INTO muh_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Fü Yesu adu ayi-ta ewü, gü ba, “Ambata esaka wü sela neh fe?” Wüh gü ba, “Ambata esaka ani ngbee lorozi bete wü jürü si mba ꞌdongoni. E-di dela e, te ena atï de mere bi wü kpara de bala?” ");
INSERT INTO muh_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Fü Yesu adu afü te-ye, amala ngü fü mere bi wü kpara la, de wüh ngbü ꞌburu kötö. ");
INSERT INTO muh_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Fü engu aza wü ambata lorozi de wü jürü si la, agbo nga ïrï Me tekaka. Fü ah adu akukuru tü wü ambata la, ato esaka wü kpara ka-ye. Fü ewü ayia agafa fü mere bi wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Fü mere bi wü kpara la, azü e la, asika di, atï te nga wü kpini, ace dudu. Fü wü *kpara ka Yesu aro du e la, asi gbü wü kuwu lorozi. ");
INSERT INTO muh_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wü kpara ta te wüh zü e la, wüh baka wü komoko kutu bala (4,000). Amba wüh tanga wü jaji de wü würüse nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Fütanga ngü la, fü Yesu ayia alï gbü *zabu de wü kpara ka-ye, akö ngu, anü sü ka-wü agbü tö ka Magadana. ");
INSERT INTO muh_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fütanga ngü la, fü gara wü *Farusi ayia de gara wü *Saduke, akoro kpaka Yesu. Amba wüh koro ka-wü nda-wü de mani, egïrï nga siti ngü, te Yesu ena adürü gbügbü. Fü ewü ayi-tata, gü ba, “Mere kpara deyï, ye mere la mere lara ngü ka talara fü ani, teka fü ani awu, gü ba, Me tima ye me-ye fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu, fü mü ayia alügü ngü fü wü kpara la, gü ba, “Yi ceka la, te gbüra kpï ngbü ngïla ngïla etamurago la, yi tï eyi awu, gü ba, ‘Agö tï alï egambi de.’ Ah bala de? ");
INSERT INTO muh_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Anga kpurutokokpï, te jia kpï esiti la, yi tï kpah eyi awu, gü ba, ‘Enatikine, agö ena alï alï.’ Te yi tï eyi awu si-ngü teka wü ngü, te ewü ngbü egü tamu wü ngü, de wü lakï füh kotö ne, ꞌburu areke areke la, ah le ta de yi wu kpah awu, gü ba, Me tima ra me-ye. Yi wu bala de, neh teka ne? Yi de wü mürü kögö-nzö! ");
INSERT INTO muh_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yi ka-yi de siti wü kpara! Yi le ngü ka Me nda-yi de! Yi ngbü eyi-ta ra, de ma mere kpeke ngü ka talara gbü jia ani, teka fü ani awu, gü ba, Me tima ra me-ye fanü. Te di bala, Me tï agü tamu lara ngü biringbö fü yi nda de, teka kögö-nzö ka-yi la! Amba ah ena adi bü mene lara ngü, te ena amere te-ye, kpah baka nda *Yona tane. Angü Me ena aküwa ra gbü kpi, kpah ba e ta te engu küwa Yona guvu mere si ne.” Fü Yesu ayia ace ewü sela, anü sü ka-ye kpa te gara sü. ");
INSERT INTO muh_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Fütanga ngü la, fü wü Yesu alï ka-wü gbü *zabu, akö ngu de wü kpara ka-ye la, kpa etangu. Amba to wü kpara kaka-na la ïrï ta aïrï, teka aza ambata fü wü. ");
INSERT INTO muh_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Fü Yesu akpo angbü emala ngü fü ewü de mani, gü ba, “Wü ceka te-wü mbi, teka ngü ka ambata ka wü *Farusi bete nda wü *Saduke, te wüh ngbü emere de *kö gbü ye ne.” ");
INSERT INTO muh_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amba ngü te Yesu mala la, wü kpara kaka je sisi na nda-wü de. Angü fïngangü ka-ewü lala ka-ye fï bü teka ngü ka zü-e. Fü ewü akpo da emala ngü esüka wü, gü ba, “Yesu ngbü emala ngü ka kö gbü ambata ne, angü ah wu eyi, gü ba, ambata esaka ani ma?” ");
INSERT INTO muh_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Amba Yesu wu ngü de te ewü ngbü emala esüka wü ne kpo. Teka ngü la, fü ah afü te-ye, amala ngü fü ewü, gü ba, “De-yi, yi to maguma yi fere de, neh teka ne? Yi fï nda-yi, gü ba, ma ngbü emala ngü ne, teka te ani za ambata de? Fïngangü ka-yi la fï bü teka ngü ka zü-e? ");
INSERT INTO muh_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wü ngü te ma ngbü mere, te yi wu cu de jia yi ne, ngü la rï gbü nzö yi la fï de? Yi fï la nga ambata ꞌburuve terane, te ma za, kukuru to fü bi wü kpara kutu ꞌburuve (5,000) ne. Yi du ro dudu na, biti gbü wü kuwu neh fe? ");
INSERT INTO muh_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Anga gara na, te ma za ambata lorozi, ato fü bi wü kpara kutu bala (4,000) ne. Yi du ro biti gbü wü kuwu neh fe? ");
INSERT INTO muh_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yi fï nga ngü la nda-yi de, neh teka ne? Ah le de yi wu awu, gü ba, ma tï kpah eyi ato gara zü-e fü yi. Amba ngü ka kö gbü ambata, te ma mala nganga fü yi ne, yi wu sisi na de, neh teka ne? Yi fï nda-yi, gü ba, ‘Ma ngbü emala nga ambata fanü?’ Ah bala nda de. Amba ma ngbü emala fü yi, gü ba, ‘Yi ceka te-yi mbi, teka siti fïngangü ka wü Farusi, de wü Saduke.’ ” ");
INSERT INTO muh_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Te di bala, fü wü *kpara ka Yesu, adu aje tïne si-ngü la, gü ba, ngü te Yesu ngbü emala fü ani ne, ah mala ngü la teka mene kö, te wüh ngbü eküꞌda ambata di ne, nda de. Amba ah ngbü emala ngü la ka-ye, teka siti fïngangü ka wü Farusi, de wü Saduke ne. ");
INSERT INTO muh_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Fütanga wü ngü la, fü wü Yesu ayia anü de wü kpara ka-ye, agbü gara sü, te di ede mere kötï de ïrï ye Kayïsarïya Fïlïpoyi. Te wüh koro kpala, fü Yesu ayi-ta wü kpara ka-ye, gü ba, “Angü wü kpara ngbü efï tüngü ni, *Ye Kpara ka Kpï, egü neh fe? Wüh ngbü emala, gü ba, ni de neh da?” ");
INSERT INTO muh_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Fü ewü alügü ngü fefe, gü ba, “Wü kpara ngbü efï, gü ba, ye de kpeke kpara. Angü wü gara kpara ngbü emala nda-wü, gü ba, ye de *Yüwane Mürü Babatïza, te zükü me-ye gbü kpi. Wü gara gü ba, ye de mürü dofo *Ïlïya. Wü gara emala nda-wü, gü ba, ye de mürü dofo Yeremaya, anga gara kpara esüka wü *mürü dofo ka Me ta gügü ne.” ");
INSERT INTO muh_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Fü Yesu adu ayi-ta ewü, gü ba, “Anga cu de-wü, wü ngbü efï nda-wü, gü ba, ni de neh da?” ");
INSERT INTO muh_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sïmüna Petero, fü mü ayia arü amala ngü fefe, gü ba, “Mü de Mere Miri, te Me tima teka aküwa a ne! Mü de Ye Mere Me!” ");
INSERT INTO muh_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Fü Yesu adu afü te-ye, amala ngü fefe, gü ba, “Wayi, Sïmüna ye *Yona, Me to wazi eyi fü mü, fanü fanü. Angü ngü de te mü mala teka ra ne, mü wu ngü la de tete-mü nda-mü de. Ah ka-ye de Wüba, Me, te di agbü kpï ne, ah sere ngü la fü mü me-ye. ");
INSERT INTO muh_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Te di bala, dene ngü te ma le amala fü mü. Enatikine, ïrï mü ena adi tïne de Petero. Angü fanü fanü, mü tïtïne de kpeke kpara baka da. Te di bala, ma ena ajï mere kambü ka-ra füh da engu la. Kambü ka-ra la, ah de wü kpara ka-ra, te ewü ena ato maguma wü fere kpah baka mü. Angü ngü ka-ra ena ato wazi fü ewü, fü ewü arü kpekpeke. Te di bala, wazi ka kpi tï afa ewü de, angü ma ena aküwa ewü me-ra. ");
INSERT INTO muh_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Te di bala, ma ena ato wazi fü mü, teka fü mü adi emala ngari ra di, fü wü kpara füh kotö ne ꞌburu. Ah ena adi ba e te ma to mafüta fü mü, te ena aü möngïtï ka *küküwa fü wü kpara. Angü mene ngü te mü ena akolo kpa füh kotö kpakine, Me ena ale ngü la kpah bala.” Dela ngü te Yesu mala fü Petero. ");
INSERT INTO muh_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Fütanga ngü la, fü Yesu adu afü te-ye, amala ngü fü wü kpara ka-ye ꞌburu kpekpeke, gü ba, “Wü mere e amala la nga ni fü wü kpara, gü ba, ‘Ni de Miri te Me tima ne,’ nda-wü de.” ");
INSERT INTO muh_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ah kpo bü gbü wü sïkpï engu la, fü Yesu akpo tïne emala nga ye fü wü kpara ka-ye mbölö mbölö, gü ba, “Ah le fü ani anü agbü Yerüsalema, angü mere cïnga ladü te ena amaka ni kpala. Wü *mere kovo de wü *mürü rïrï ena ato mere kuru te ni, fü ewü amörö ni asidi. Amba gbü *ebabata sïkpï, Me ena azükü ni gbü kpi la.” ");
INSERT INTO muh_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petero, te mü je ngü la, fü mü aza Yesu, anü di mba edere sü, akpo emala ngü fefe kpekpeke, gü ba, “Ata, mere kpara! Ah tï fü ngü la, amere mü baka e la kpo de!” ");
INSERT INTO muh_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Te Yesu je ngü la bala, fü ah afü te-ye, amala ngü fü Petero, gü ba, “Mü ce ra de ngü ka-mü, ka *Satana la. Mü le de ma mere rïrï ka Me de, neh teka ne? Fïngangü ka-mü la, ah de ngü ka Me nda de. Dela ka-ye siti fïngangü ka wü kpara de füh kotö ne.” ");
INSERT INTO muh_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sidi nga ngü la, fü Yesu afü te-ye, amala ngü fü wü kpara ka-ye la ꞌburu, gü ba, “Te mü ele angbü zu kpara ka-ra la, mü lala fï bü gbü nga ra. Mü mere e afï nga wü e ka-mü ꞌburu ꞌdö de. Mü reke te-mü teka kpi ka-mü, baka kpara te ngbü ebï mere rü gbegbete, te wüh ena abere engu tete na, amörö. ");
INSERT INTO muh_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Angü te mü le aküwa te-mü de tete-mü la, mü tï aküwa te-mü nda-mü de. Amba te mü ce te-mü o fü kpi teka ngü ka-ra la, Me ena aküwa mü me-ye. ");
INSERT INTO muh_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mü fï la nga kuru mü! Angü, te mü ce ngü ka Me, fü mü adu ato te-mü ꞌburu teka ngü ka kotö ne, teka adi emaka mere bi jiase, de mere bi wü züka e de füh kotö ne ꞌburu la, wü e la ena aküwa mü fanü? Wüh tï aküwa mü nda-wü de, angü mü ce ngü ka Me eyi! Te di bala, gara e te mü ena ato fü Me, teka afa kuru mü di, ah de neh ene? E nda ma! ");
INSERT INTO muh_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mü fï nga *adu sïkpï, te gara, te ma ena adu akoro tete na! Angü de-ra, *Ye Kpara ka Kpï, ma ena adu akoro füh kotö ne, de wazi ka Wüba, de wü *malayïka kaka mini. Fü ra akolo ngü ka wü kpara ꞌburu, ato takpa fü ewü, te nga wü ngü te wüh ngbü mere. ");
INSERT INTO muh_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma ngbü emala fü yi dene zu ngü fanü fanü. Wü gara kpara ladü esüka yi sene, wüh tï akpi la de, zalü te wüh ena awu mere wazi te Me to fere, Ye Kpara ka Kpï, te ma ena aküwa wü kpara di ne feke.” Dela ngü ta te Yesu mala fü wü kpara, te ewü le afa nga ye. ");
INSERT INTO muh_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sidi nga sïkpï maꞌdiya, fü Yesu ayia aza wü Petero, *Yakobo bete *Yüwane, anü de ewü kpa enzö mere rüvü. Fü ewü angbü de ewü kpala kpikpi wü. ");
INSERT INTO muh_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Fü küte Yesu akpo da efü te-ye, gbü jia wü kpara ka-ye la. Fü gbügbüra na akpo angbü eci baka ra. Fü bongo kaka-na avi ꞌduwa kpïlïlï, ba ra-sü la. ");
INSERT INTO muh_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wü *kpara ka Yesu de bata ne, te eceka kpï bane de, gbo! te wü kpara ꞌbasu, te ewü koro ngbü ero mö de wü Yesu. Amba wü kpara la, wüh ka-wü de diri wü kpara ka Me ta gügü, wü *Müse ake *Ïlïya. ");
INSERT INTO muh_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petero, te mü wu ngü la bala, fü mü ayia nda-mü bü kere, amala ngü fü Yesu, gü ba, “Ako, mere kpara, ah reke ta ngbürü pe te nih ena angbü ka-nih bü sene, angü sü de sene reke gbü jia ra fa sü. Te di bala, te mü le la, ma ena ajï wü gugu bata, nda-mü biringbö, nda Müse biringbö, nda Ïlïya kpah biringbö.” ");
INSERT INTO muh_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petero bü te emala ngü la bala de, ꞌduwa fü sangu te vi avi kpïlïlï bane, ayia akoro agba ewü ꞌburu. Fü ri Me ayia awü gbü sangu la, gü ba, “Dene zu Ye ra, te maguma ra le fa sü. Yi di eje ꞌduwa rïrï kaka-na.” ");
INSERT INTO muh_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Te wü kpara ka Yesu de bata ne wu ngü la bala, fü cürü arï te ewü afa sü. Fü ewü atï abuka gbüra wü ꞌburu kötö. ");
INSERT INTO muh_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Fü Yesu ayia akoro kpaka ewü, amofo ewü, gü ba, “Yi kpe cürü de, yi yia eyia tikpi.” ");
INSERT INTO muh_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Fü ewü ayia ae gbüra wü tikpi bane, yïrrrï! Wü Müse ake Ïlïya nda-wü tïne ma, ka-ye bü Yesu kpikpi ye, te rü ede ewü sela! Dela ngü te wü kpara ka Yesu de bata ne wu wazi Me di eküte Yesu. Fü ewü ayia ace sü la, adu kpa esa gö, kpaka wü bu wü. ");
INSERT INTO muh_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Baka te Yesu yia tete kpa füh rüvü kpala, edu de wü kpara ka-ye de bata ne, kpaka wü bu wü, fü engu amala ngü fü ewü kpekpeke, gü ba, “Yi mere e amala nga ngü la fü wü kpara de, zalü te gara, te Me ena azükü ra, *Ye Kpara ka Kpï, tete gbü kpi.” ");
INSERT INTO muh_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Fü wü kpara kaka-na de bata ne adu kpah ayi-tata na, gü ba, “Mere kpara, anga wü *mürü rïrï ngbü emala ngü, gü ba, ‘Mürü dofo *Ïlïya ena adu akoro feke, teka areke kaje fü Miri, de te Me ena atima ne’. Te di bala, ngü la ena adi neh baye?” ");
INSERT INTO muh_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Fü Yesu alügü ngü fü ewü, gü ba dene, “Wayi, *Ngari Me mala ngbürü bala fanü, gü ba, Ïlïya ena akoro feke, teka areke maguma wü kpara. ");
INSERT INTO muh_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma emala fü yi dene zu ngü. Ïlïya koro ka-ye ta nda-ye eyi. Amba wü mere *kovo le engu nda-wü de. Fü ewü amere engu esiti, baka te wüh ngbü ele. Teka ngü ka-ra, Ye Kpara ka Kpï, wüh ena ato mere cïnga te ra, kpah bala.” ");
INSERT INTO muh_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Te di bala, fü wü kpara kaka-na la adu awu teke, gü ba, Yesu ngbü emala nga *Yüwane Mürü Babatïza. ");
INSERT INTO muh_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Te wü Yesu du tete kpa esa gö, fü ewü amaka bi wü kpara kpala, fï bü da ecï nganga. Fü gara komoko ayia akoro kpaka Yesu, abu nzökuta ye engangagira, afüwa te-ye fefe, ");
INSERT INTO muh_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","gü ba, “Ako, mere kpara, mü ceka la bü cïnga te mbarase ka-ra ne baaa! *Siti wü di enga me ngbü emere engu esiti, da eto mere cïnga tete. Wüh ngbü egbofo engu, egü gbü wa. Wü gara ne, egü gbü ngu. ");
INSERT INTO muh_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma za ta engu, koro di kpaka wü kpara ka-mü ne, amba wüh tï aküwa engu nda-wü de.” ");
INSERT INTO muh_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Te Yesu je ngü la bala, fü ah ayia amala ngü fü wü *kpara ka-ye, gü ba, “De-yi, wü kpara ka re ne, amba yi ka-yi neh siti wü kpara bane? Yi le ato maguma yi fere de, neh teka ne? Yi ngbü efï, gü ba, ma ena angbü de wü ani sene teka re neh fe, teka fü yi ato maguma yi fere?” Fü ah adu afü te-ye, amala ngü fü wö ye mbarase la, gü ba, “Ye koro de mbarase la kpakine!” ");
INSERT INTO muh_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Fü Yesu adu amala ngü kpekpeke fü siti wü di enga me, te ewü ngbü emere mbarase la, gü ba, “Wü ce engu ace!” Fü wü di enga me la akoro guvu mbarase la, ꞌduwa bü gbü lö-ra engu la. Fü mbarase la ayia aküwa. ");
INSERT INTO muh_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Te wü gara kpara la baya tete, fü wü kpara ka Yesu aka te-wü gbamari edede, ayi-tata na, gü ba dene, “Mere kpara deyï, ani tï aliki siti wü di enga me la de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Yesu gü ba, “Ngü la mere te-ye kükürü de, angü yi to maguma yi fü Me, mbi mbi la de. Ma ngbü emala fü yi dene zu ngü. Te yi ena ato ta maguma yi mba eyi cüküꞌdaye fü Me, baka jia rï bongo la, de bane ngü tï afa yi nda de. Yi tï ta kpah bü eyi amala ngü fü mere rüvü ne, gü ba, ‘Ye yia sela eyia asidi, de ye nü kpa gbü gara sü la,’ de bane, ah tï kpah bü eyi anü.” ");
INSERT INTO muh_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Fütanga ngü la, fü wü Yesu ayia ace sü la, anü akoro gbü nga nzö kötï ka wü *Galïlaya. Te wüh koro biti te-wü kpala de mere bi wü kpara te ewü ngbü efa nganga ne, fü ah amala ngü fü ewü, gü ba, “Fanü fanü, ah tï ayiri de, wü vügü ka-ra ena azoro ra, *Ye Kpara ka Kpï, fü ewü ato ra fü siti wü kpara. ");
INSERT INTO muh_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Fü ewü amörö ra asidi. Amba gbü *ebabata sïkpï, Me ena adu azükü ra gbü kpi la.” Te wü *kpara ka Yesu je ngü la bala, fü ewü angbü ꞌburu de mere cïnga emaguma ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ta gbü wü re la, wü *mürü gele ka wü *Yïsarayele ngbü ta ero jiase esaka wü di enga Yïsarayele te nga wü re ꞌburu, teka adi ereke *Mere Kambü ka Me agbü Yerüsalema di. Gbü gara sïkpï, o Yesu du koro de wü kpara ka-ye agbü Kaparanama, fü wü kpara te ewü ngbü ero jiase la, akoro kpaka Petero, ayi-tata, gü ba, “Mere kpara ka-wü ngbü eto jiase teka areke Mere Kambü ka Me di, ato?” ");
INSERT INTO muh_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Fü Petero alügü ngü fü ewü, gü ba, “Wayi, ah ngbü eto ato.” Te Petero du tete kpa ekötï, ꞌduwa fü Yesu akpo da emala ngü fefe fi me-ye, gü ba, “Petero deyï, ye ngbü efï nda-ye neh baye? Wü kpara, te ewü ena ase ngürü wü fü wü miri ka kotö ne, neh wü da? Ah de wü jaji ka-ewü, anga ah ena adi de wü kükürü kpara?” ");
INSERT INTO muh_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Fü Petero alügü ngü fefe, gü ba, “Ah de wü kükürü kpara.” Yesu gü ba, “Te ah bala, wü jaji ka miri se ngürü wü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amba ma le de ngü ka-nih siti gbü jia wü kpara la de. Te di bala, mü za ngïlï ka-mü, mü nü agbü ngu, teka agü si. Mene si te mü ena azoro te enga gina la, mü ü gögömö na, mü ena amaka jiase, te ena atï tüngü nih ꞌbasu mini. De mü za jiase engu la, mü du di, mü to fü wü kpara la.” ");
INSERT INTO muh_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Fütanga ngü la, fü wü *kpara ka Yesu ayia akoro kpakaka na, ayi-tata, gü ba, “Mere kpara, mene kpara te ye ena afe, fü ah angbü memere fütanga ye te gara, te ye ena angbü tete Miri füh kotö ne, neh da?” ");
INSERT INTO muh_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Fü Yesu ayia aza gara mbarase cüküꞌdaye, ao esüka ewü. ");
INSERT INTO muh_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Fü ah amala ngü fü ewü, gü ba, “Ma ngbü emala fü yi dene zu ngü. Ah le de yi fü fïngangü ka-yi, fü yi angbü eo ngü ka-yi kötö, baka nda wü jaji, te ewü o ngü ka-wü memere nda-wü de ne. Angü te ah bala de la, yi tï arï agbü sü ka Me kpo de. ");
INSERT INTO muh_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Te mü le de ngü ka-ni ngbü memere gbü jia Me la, ah ele de mü ngbü esüka wü bu mü baka jaji. Mü mere e ao ngü ka-mü memere de. ");
INSERT INTO muh_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mene kpara te ena aza mbarase cüküꞌdaye baka engu ne gbü mürü, teka ngü ka-ra la, ah le ka-ye dela cu ra.” ");
INSERT INTO muh_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Fü Yesu adu amala gara ngü fü wü *kpara ka-ye, gü ba dene, “Ah ena adi de mere siti ngü fü mene kpara, te fiti kpara ka-ra, anga ah de mere kpara, anga mbarase cüküꞌdaye. Angü te kpara ka-ra la dürü, du ngbü emere *siti ngü la, Me ena ato mere kuru te mene kpara te fiti engu la! Ah reke ta pe, te wüh ena aza mere siti wö, ai gbü ngürü mürü fiti la, fü ewü agü engu di, agbü mere *yï-ngu. Fanü, ah le ta de mürü fiti la kpi kpala, o engu fiti kpara ka-ra la, la de. Angü kuru de te Me ena ato ta fü mürü fiti la, teka fiti kaka la, ah ena afa mene kpi te wüh gü engu di gbü ngu ne ka. ");
INSERT INTO muh_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Me ena ato mere kuru te wü kpara füh kotö ne, teka ngü ka siti ngü ka-ewü, te wüh ngbü emere. Angü füh kotö ne, te nga wü sïkpï ꞌburu, re-ngü tï alakï de. Amba mene kpara te ngbü efiti wü bu ye, de wüh mere siti ngü ne, Me ena ato mere kuru tete, afa nda wü bu ye, de te engu ngbü efiti ewü la ka. ");
INSERT INTO muh_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yi di ekpe siti ngü akpe! Te kpa mü, anga lö mü, ngbü efiti mü me-ye, teka de mü mere siti ngü la, ah le de mü wa kpa mü, anga lö mü la, awa, mü gü akötö. Angü, ah ena areke pe te gara e biringbö eküte mü ena akpi me-ye, fü mü aküwa, ka engu te wüh ena aza mü, de küte mü ꞌburu, agü gbü mere du ka wa. ");
INSERT INTO muh_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Anga te ah de jia mü, te ngbü efiti mü me-ye, teka fü mü atï gbü siti ngü la, ah le de mü gbi jia mü la agbi, mü gü akötö. Angü, ah reke pe, te mü ena aküwa de jia mü ngbee biringbö, ka engu de te wüh ena agü mü, de jia mü ꞌbasu mini, agbü du ka wa.” Dela ngü ta te Yesu mala fü wü kpara ka-ye, teka kuru te Me ena ato fü wü mürü fiti te gara. ");
INSERT INTO muh_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Fü Yesu adu amala gara ngü fü wü kpara ka-ye, gü ba dene, “Yi mere e adi efala wü kükürü kpara de. Angü Wüba, Me, ngbü efï nga ewü kpekpeke. Ah le de süka ewü biringbö dürü te kaje ka-ni ne de. Teka ngü la, fü engu afe gara wü *malayïka ka-ye, teka adi eceka kpï fütanga ewü. ");
INSERT INTO muh_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Angü de-ra, *Ye Kpara ka Kpï, Me tima ra füh kotö ne, agïrï wü kpara de bala, teka aküwa ewü. ");
INSERT INTO muh_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yi ngbü efï nda-yi neh baye? Te gara kpara ladü de wü kambiliki esaka ye kama biri (100), fü gara na biringbö esüka ewü ayia adürü la, engu ena amere baye? Ah ena ace engu adürü fï bala? Aꞌa! Ah ena ace du wü kambiliki ka-ye la, gbü sü te ewü ngbü ezü e tete sela. Fü engu ayia anü agïrï mene engu biringbö te dürü ne. Ah bala de? ");
INSERT INTO muh_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ma ngbü emala fü yi dene zu ngü. Te engu nü maka kambiliki ka-ye biringbö, de te dürü ne eyi la, ah ena angbü de mere siti tadu tekaka, afa nda mere bi ewü, de te ewü dürü nda-wü de ne. ");
INSERT INTO muh_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ah kpah bala teka ngü ka wü kpara, te ewü ngbü edürü te kaje ka Me asidi ne. Angü Wö yi, Me, le de kpara dürü fï ne nda de.” ");
INSERT INTO muh_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Fü Yesu adu amala gara ngü fü wü kpara ka-ye la, gü ba dene, “Te gara enga ni mü gbü ngü ka Me mere *siti ngü fü mü la, ah le de mü nü kpakaka, de yi ro mö teka ngü la ake di, ꞌbasu yi ꞌbasu. Te engu le ngü la eyi, fü ah adu ace siti ngü la, ah de züka ngü, angü süka yi du reke ake di eyi. Kpah bala, engu küwa gbü siti ngü la eyi. ");
INSERT INTO muh_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amba te engu le ace siti ngü ka-ye la de la, de mü za gara kpara ka Me biringbö, anga ꞌbasu, yi nü de ewü kpakaka na. Angü wüh ena ale ta-ngü te mü, arï engu, de ah ce siti ngü la. ");
INSERT INTO muh_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Te engu je ri wü kpara la kpah de, de mü mala ngü la fü wü kpara ka Me ꞌburu, de wüh ye süka ngü kaka. Te engu je ri yi ꞌburu kpah de la, de yi liki engu esüka yi gbü tima ka Me asidi. Yi du, yi ceka engu baka siti kpara, te le ngü ka Me nda de. ");
INSERT INTO muh_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ma ngbü emala fü yi dene zu ngü. Ma ena ato wazi fü yi, wü kpara ka-ra, teka aye süka ngü ka wü kpara füh kotö ne. Angü ngü te yi ena akolo füh kotö sene, Me ena ale kpah bala. ");
INSERT INTO muh_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Dene kpah gara ngü te ma ena amala fü yi. Te wü kpara ꞌbasu esüka yi sene, ngbü de fïngangü biringbö, teka ayo e kpaka Me la, Me ena ato e la ato fü ewü, baka te ewü ngbü ele. ");
INSERT INTO muh_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te wü kpara ꞌbasu, anga bata, biti te-wü teka amere ngü te ïrï ra la, ma ena adi kpah ladü esüka ewü.” ");
INSERT INTO muh_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Fütanga ngü la, fü Petero ayia aka te-ye gbamari ede Yesu, ayi-tata, gü ba, “Mere kpara, te enga ni ni ngbü fï bü da emere *siti ngü fü ni la, ni ena aboro siti ngü kaka-na, anda nganga, adu neh fe? Ni ena aboro du lorozi?” ");
INSERT INTO muh_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Fü Yesu alügü ngü fefe, gü ba, “E-mala fü mü, gü ba, ah ena adi du lorozi, neh da? Mü ena adi fï bü eboro wü siti ngü kaka te nga wü sïkpï ꞌburu!” ");
INSERT INTO muh_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Fü Yesu adu amala ngü fü wü kpara ka-ye ꞌburu, gü ba dene, “Ah le de wü kpara te ewü ra fü Me, di eboro siti ngü ka wü bu wü, kpah baka te Me ngbü eboro siti ngü ka-ewü. Angü ngü la ena adi ge baka ngü ka gara miri, ta te ï wü kpara ka tima ka-ye, de wüh koro, wüh to jiase te ewü ngbü ero, ebiti ne. ");
INSERT INTO muh_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ah te eceka de, wüh koro de gara kpara ka tima kaka, te zü mere bi jiase, de te engu ngbü ro teka mere bi re ne eyi. ");
INSERT INTO muh_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kpara engu la tï ato mba enga jiase bane nda de. Angü engu siti wü jiase la eyi ꞌburu. Teka ngü la, fü miri la amala ngü fü mere kpara ka tima ka-ye, agü ba, ‘Te komoko la to jiase ka-ni de, ah le de wü za engu, wü cïnzï, de wü jaji ka-ye, de wü wara ye ꞌburu asidi, na jiase ka-ni la.’ ");
INSERT INTO muh_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Te kpara ka tima kaka la je ngü la bala, fü ah ayia atï, abu nzökuta ye kötö engangagira, afüwa te-ye kpakaka na, gü ba, ‘Akooo Miri, ye o la züka maguma kpaka ni, de ye ce ngü fü ni. Ni ena alügü na jiase ka-ye la te gara ꞌburu.’ ");
INSERT INTO muh_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Te miri je ngü la bala, fü cïcïnga ayia arï tete, angü ah wu eyi, gü ba, jiase ka-ni la fa ta sü. Kpara la tï te engu ena alügü fü ni kere nda de. Fü engu ace ngü la fefe bala, ato kaje fefe na, de ah ago kpa gba ye. ");
INSERT INTO muh_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Fü komoko la ayia ale kaje ego kpa gba ye. Fü ah anü amaka te-ye ake gara kiri ye, ta te ewü ngbü emere tima de ewü. Kiri ye na la za ta mba enga jiase esasaka, gü ba, ‘Ni ena alügü kere.’ Fü komoko la ayia atï ꞌduwa eküte kiri ye la, azoro ngüngürü gö gö gö! amala ngü fefe kpekpeke, gü ba, ‘De-ye deyï, ye lügü jiase ka-ni kere, tïtïne sene!’ ");
INSERT INTO muh_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fü kiri ye na la ayia atï eri lölö, afüwa te-ye fefe na, gü ba, ‘Akooo, ye o la mba züka maguma kpaka ni, ni ena alügü jiase ka-ye la baaa!’ ");
INSERT INTO muh_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Komoko la le nda-ye kpo de. Fü ah ayia aza kiri ye la, anü di, agü agbü ku, zalü te engu ena alügü na jiase ka-ni la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Te wü bu ye na, wü kpara ka tima, wu ngü la bala, fü ewü angbü de mere cïnga afa sü. Fü ewü anü amala nga ngü la ꞌburu fü miri. ");
INSERT INTO muh_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Te miri la je ngü la bala, fü engu ayia aï kpara ka tima ka-ye la, amala ngü fefe, gü ba, ‘Ah mere baye? Amba ye ka-ye de siti kpara bala? Ye füwa ta te-ye kpaka ni, fü ni ayia ace ngü ka mere jiase ka-ni ne fü ye bü bala. ");
INSERT INTO muh_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ah mere baye, te ye le ace siti ngü ka kiri ye ne, nda-ye de ne?’ ");
INSERT INTO muh_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Fü maguma miri ayia asiti te kpara ka tima ka-ye la afa sü. Fü ah aza engu, agü agbü ku, de engu ngbü gbü mere cïnga kpala, zalü te engu ena alügü na jiase ka-ni la ꞌburu feke.” ");
INSERT INTO muh_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Te Yesu mala nga ngü la fü wü kpara ka-ye, nza tete, fü ah adu amala gara ngü fü ewü, gü ba, “Ngü ka Wüba, Me, kpah baka ngü ka miri la. Ah le fü yi aboro ngü fü wü bu yi de züka maguma yi fanü fanü, angü, te yi boro ngü ka wü bu yi de, Me boro siti ngü ka-yi nda kpah de.” Dela ngü ta te Yesu rï wü kpara ka-ye di, gbü gara nzö kötï ka *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Fütanga ngü te Yesu rï wü kpara la nza tete, fü engu ayia de wü kpara ka-ye gbü *Galïlaya sela, anü ka-wü kpa etangu Yürüdene, gbü nga nzö kötï ka *Yudaya. ");
INSERT INTO muh_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fü mere bi wü kpara gbü sü la ayia akoro kpah kpakaka. Fü engu ayia aküwa wü mürü keke esüka ewü. ");
INSERT INTO muh_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fü wü gara *Farusi ayia akoro kpaka Yesu, teka are mamaguma. Fü ewü ayi-tata na, gü ba dene, “Gbü fïngangü ka-ye, *Rïrï ka Me, gü neh fe? Kpara tï eyi ace wara ye, teka gara siti ngü te engu mere?” ");
INSERT INTO muh_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Fü Yesu alügü ngü fü wü Farusi la, gü ba, “Yi tanga ngü ta te *Müse ba gbü *Ngari Me ne, nda-yi de? Müse ba, gü ba, ‘Ta te enga gina, Me mere komoko ake würüse. ");
INSERT INTO muh_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Fü Me amala ngü fü ewü, gü ba, “Dela si-ngü te komoko ngbü eyia, ece wö ye ake ni ye, aza wara ye, alala tete na. Fü ewü adu angbü ake di tïne baka kpara biringbö ne.” ’ ");
INSERT INTO muh_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yi wu, gü ba, Me o yi ta eyi me-ye, de yi za te-yi, fü yi akoro baka e biringbö, ne de? Te Me o yi eyi biringbö la, yi mere e aye süka yi tïne de!” ");
INSERT INTO muh_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fü wü Farusi la adu ayi-ta Yesu, gü ba, “Te ah bala la, anga ngü ta te *Müse ba gbü gara buku, gü ba, ‘Te komoko le ace wara ye la, ah le de engu ba köcökpa, ato fü wara ye feke, fü wara ka na ayia ago ka-ye agba wü.’ Si-ngü gbü ngü la gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Fü Yesu alügü ngü fü ewü, gü ba, “Müse ba ta ngü la bala teka ne de, angü nzö wü kundu yi kpekpeke, kpah baka nda-yi! Amba te Me o gina wü kpara tete, ngü la bala nda ma. ");
INSERT INTO muh_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Dene ngü te ma emala fü yi. Te wara mü mere waza nda de, fü mü ayia ace engu, adu aza gara würüse la, mü mere *siti ngü eyi, angü mü mere dela waza.” ");
INSERT INTO muh_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Fütanga ngü la, fü wü *kpara ka Yesu ayia amala ngü fefe, gü ba, “Apa, mere kpara! Te ngü ka maza würüse tïne eyi cu bala la, ah reke pe, te wü kpara ena angbü ka-wü ta bala, wüh za würüse nda-wü de!” ");
INSERT INTO muh_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Fü Yesu amala fü ewü, gü ba, “Bi wü kpara tï aje rïrï la nda-wü de, ꞌduwa wü kpara de te Me to wazi eyi fü ewü, teka amere ngü la. ");
INSERT INTO muh_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Amba ngü te ngbü etïrï wü gara kpara, te ewü za würüse di de ne, ah ka-ye kpikpi ye kpikpi ye. Wü gara kpara za würüse de, angü wüh bï ewü kü bala. Wü gara za würüse de, angü wü gara kpara siti ewü me-wü. Amba wü gara kpara le aza würüse de, kü me-wü, teka tima ka Me, de ani di eo to ani ꞌburu tete. Te wazi mü ladü teka amere ngü la bala la, de mü mere emere baka nda-ewü la.” Dela ngü te Yesu mala fü wü kpara ka-ye, teka ngü ka komoko ake würüse. ");
INSERT INTO muh_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Fütanga ngü la, fü wü gara kpara aza wü jaji ka-wü, akoro di kpaka Yesu, de engu o kpa ye gbü nzö ewü, aku gba fü Me, teka de Me to wazi fü ewü. Te wü *kpara ka Yesu wu ngü la bala, fü ngü la asiti te ewü. Fü ewü akpo da eliki wü jaji la. ");
INSERT INTO muh_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Te Yesu wu ngü la bala, fü ah amala ngü fü wü kpara ka-ye la kpekpeke, gü ba, “Yi ce wü jaji la, de wüh koro kpaka ra. Yi mere e atïrï ewü de, angü wü kpara te ewü ena akoro agbü sü ka Me agbü kpï, ah de wü kpara, te ewü fü ngü ka-wü, koro baka nda wü jürü jaji de bala. Angü wü jürü jaji cu ngü wü de, wüh mere mani kpah de.” ");
INSERT INTO muh_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fü Yesu abiti wü jaji la, ao kpa ye gbü nzö ewü. Dela ngü ta te Yesu mere fü wü jürü jaji. Sidi nga ngü la, fü engu ayia anü sü ka-ye agbü gara sü. ");
INSERT INTO muh_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Fütanga ngü la, fü gara jaji komoko, te di de mere bi wü e esaka ye, ayia akoro kpaka Yesu. Fü ah ayi-tata, gü ba, “Mere kpara, ni ena amere ne züka ngü ne, teka fü ni aküwa agbü sü ka Me fï mere badi?” ");
INSERT INTO muh_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Fü Yesu alügü ngü fefe, gü ba, “Mü ngbü eyi-ta ra teka züka ngü neh teka ne? Züka kpara biringbö nda ma, ꞌduwa Me kpikpi ye. Mü wu bala de? Amba te mü le aküwa fï mere badi la, ah le de mü mere wü *Rïrï ka Me ꞌburu mbi mbi mbi.” ");
INSERT INTO muh_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Fü komoko la ayi-ta Yesu, gü ba, “Neh mene wü rïrï deyi?” Yesu gü ba, “Wü rïrï engu, wüh dene. ‘Mü mere e amörö kpara de. Mü mere e amere waza de. Mü mere e azi e de. Mü mere e adi esutu wu te wü bu mü de. ");
INSERT INTO muh_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mü je rïrï ka wö mü ake ni mü, de mü le wü bu mü, kpah baka e te mü ngbü ele küte mü.’ ” ");
INSERT INTO muh_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Fü ye komoko la alügü ngü fü Yesu, gü ba, “Wayi, mere kpara, gara ngü te ma ena adu amere, ah kpah ladü? Angü wü ngü de te mü tanga ewü la, ma ngbü eyi emere ewü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu gü ba, “Te mü ele de ngü ka-ni reke areke gbü jia Me la, mü nü, mü cïnzï wü e ka-mü ꞌburu. Fü mü aza jiase la, ato ꞌburu fü wü mürü cïnga, de mü du, mü lala gbü nga ra. Angü te mü mere bala, mü ena amaka *küküwa te gara agbü sü ka Me agbü kpï.” ");
INSERT INTO muh_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Te ye komoko la je ngü la gömö Yesu bala, fü engu ayia ace Yesu, anü sü ka-ye agba ye, de mere cïnga emaguma ye. Angü engu ta de mere bi wü e esaka ye fa sü. ");
INSERT INTO muh_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Teka ngü la, fü Yesu afü te-ye, amala ngü fü wü kpara ka-ye, gü ba, “Ma ngbü emala fü yi dene zu ngü. Mene wü kpara, te ewü di de mere bi wü e esaka wü ne, ah kpekpeke teka fü ewü ato maguma wü fü Me. ");
INSERT INTO muh_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma ngbü enda nga ngü ne fü yi, gü ba, ah kpekpeke fü mene wü kpara de mere bi wü e esaka wü, teka fü ewü afü maguma wü, ara fü Me. Angü ah baka ya, te le arï gbü enga gö sögbe. Ah tï eyi arï fanü? Ah tï arï nda de! Amba ngü ka mene kpara de mere bi wü e esaka ye, ah kpah bala. Ah ena adi kpekpeke fefe, teka afü maguma ye, ara fü Me.” ");
INSERT INTO muh_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Te wü *kpara ka Yesu je ngü la bala, fü maguma ewü ayia akolo ka ngü la. Fü ewü akpo da eyi-ta tete-wü, gü ba dene, “Te ngü la tïne bala la, kpara biringbö te ena aküwa neh da?” ");
INSERT INTO muh_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Fü Yesu aceka ewü, adu amala ngü fü ewü, gü ba dene, “Kpara te ena aküwa te-ye de tete-ye nda ma. Angü ngü la fa wü kpara eyi ꞌburu. ꞌDuwa Me te ena aküwa mü me-ye. Angü ngü te ena afa Me nda ma.” ");
INSERT INTO muh_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petero, fü mü ayia amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, ye ceka la, ani ce wü e ka-ani eyi ꞌburu, teka alala gbü nga ye. Te di bala, ngü ka-ani ena adi baye?” ");
INSERT INTO muh_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Fü Yesu alügü ngü, gü ba, “Wayi, yi ena amaka züka ngü amaka, angü yi lala eyi gbü nga ra. Ma ngbü emala fü yi dene zu ngü. Gbü sïkpï te ma ena angbü te gara baka mere Miri de mere wazi, de-yi, wü kpara ka-ra nzükpa de füh ye ꞌbasu ne, yi ena angbü kpah wü cögbörö kpara ede ra, teka akolo ngü ka nguwa wü di enga *Yïsarayele, nzükpa de füh ye ꞌbasu ne. ");
INSERT INTO muh_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kpah bala, te mü ce wü e ka-mü teka ngü ka-ra, Me ena ato mere bi züka ngü fü mü, afa nda-mü te mü ce la. Anga te mü ce neh ene. Te ah de gba mü, wü di enga ni mü, wü wö mü ake ni mü, wü di mü, anga wü yï ka-mü, te mü ce ewü teka ngü ka-ra la, Me ena ato mere bi züka ngü fü mü füh kotö sene, da wü e te mü ce la. Kpah bala, Me ena aküwa mü te gara agbü sü ka-ye agbü kpï, fï mere badi. ");
INSERT INTO muh_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amba yi mere e acu ngü yi nda-yi de, angü bi wü kpara, te ewü mere te-wü baka wü cögbörö kpara füh kotö ne, te gara Me ena afü ewü baka kükürü wü kpara. Kpah bala, mene ewü, de te ewü di ba kükürü wü kpara füh kotö ne, te gara Me ena afü ewü, ao angbe cögbörö wü kpara fü wü bu wü agbü sü ka-ye, agbü kpï.” Dela ngü te Yesu mala, teka wü kpara de mere bi wü e esaka wü. ");
INSERT INTO muh_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Fütanga ngü la, fü Yesu adu kpah amala gara mani fü ewü, gü ba, “Gara ngü ladü, te ma ele amala fü yi, teka züka ngü te yi ena amaka kpaka Me. Gara komoko ta ladü, te di de mere yï ka rïrü ka-ye. Fü wü rï-rü kaka la ayia andri. Gbü gara sïkpï, fü komoko la ayia kpurutokokpï, anü agïrï wü kpara teka amere tima gbü yï ka-ye la. ");
INSERT INTO muh_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Fü ah amaka wü gara kpara, aro mö de ewü areke areke teka tima la, gü ba, ‘Ni ena ato jiase fü wü baka kama biri (100), teka tima ka sïkpï biringbö.’ Fü wü kpara la ale. Fü komoko la ayia atima ewü agbü yï ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ah te ekoro gbü lö-ra menewa, fü engu adu kpah kpa te kaje. Fü ah awu wü gara kpara, te ewü ngbü ka-wü erürü te kaje bü kükürü bala. ");
INSERT INTO muh_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Fü engu amala ngü fü ewü, gü ba, ‘Wü nü enü amere tima agbü yï ka-ni kpala. Ni ena ato jiase fü wü areke areke, teka tima la.’ ");
INSERT INTO muh_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Fü wü kpara la ale, ayia anü fütanga wü bu wü. Sidi nga ewü la, etü ra, fü mürü yï la ayia kpah, anü agïrï gara wü kpara teka tima ka-ye. Fü ah amala ngü fü ewü kpah bala. Fü ah adu kpah anda nga ye gbü lö-ra bata ka tamurago. Fü ah amaka kpah gara wü kpara, atima ewü agbü yï ka-ye la. ");
INSERT INTO muh_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gbü wü ngü la ꞌburu, tima kaka agbü yï ne nza nda la fï de. Ah te ena akoro kpah gbü lö-ra ꞌburuve ka tamurago, fü engu adu kpah anü amaka wü gara kpara, te ewü rü ngbü ka-wü bü kükürü te kaje. Fü komoko la ayi-ta ewü, gü ba, ‘Ah mere baye, te wü ngbü erürü te kaje sene, bü kükürü kükürü gbü ra ne gbuuu, de bane? Wü le amere tima de?’ ");
INSERT INTO muh_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Fü wü kpara la alügü ngü fefe, gü ba, ‘Anga kpara te ena aza ani gbü tima nda kpah ma ne, ani ena amere baye?’ Komoko la gü ba, ‘Ah mbi, te ah bala, wü nü enü sidi nga wü bu wü, amere tima agbü yï ka-ni kpala.’ ");
INSERT INTO muh_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Te wü kpara la mere tima tete te nga wü ꞌburu, koro di etamurago, fü komoko la ayia aï mere kpara ka tima ka-ye, amala ngü fefe, gü ba, ‘Ye nü enü, ye ï wü kpara ka tima la biri biri ꞌburu, de ye to jiase fü ewü ꞌburu yoo, na tima te ewü mere la. Ye kpo de mene wü kpara, te ewü koro sidi ne, akoro te mene ewü, te ewü kpo de tima kü kpurutokokpï ne.’ ");
INSERT INTO muh_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Fü wü kpara ta te ewü koro gbü tima, gbü lö-ra ꞌburuve ka tamurago ne, akoro aza jiase ka-wü biri biri ꞌburu, baka kama biri, kama biri, kpah baka e te engu le ato fü mene wü kpara, te ewü koro kü kpurutokokpï ne. ");
INSERT INTO muh_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wü kpara ta te ewü kpo de tima kü kpurutokokpï ne, fü ewü awu wü bu wü, te ewü ngbü emaka jiase de bala ne, fü ewü angbü de tadu, efï ngü emaguma wü, gü ba, ‘Wayi, te ah bala la, ani ena amaka nda-ani jiase tïne afa sü!’ Amba de, wüh ena ato jiase la fü ewü ꞌburu kpah bü ngbee kama biri, kama biri, baka nda wü bu wü la. ");
INSERT INTO muh_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Fü maguma wü kpara, ta te ewü kpo de tima kü kpurutokokpï ne, ayia asiti. Fü ewü akpo da emala ngü eküte mere kpara la, teka jiase de te wüh to fü ani kpah baka nda wü bu ani, te ewü koro sidi ne. ");
INSERT INTO muh_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Fü ewü akoro, awü nga fü mürü yï la, gü ba, ‘Ye ceka la! Ani ngbü mere tima gbü mere ra ne gbuuu! Ye nü to jiase fü ani kpah baka nda wü kpara, te ewü koro mba tïtïne, mere tima bü teka lö-ra ngbee biringbö, neh teka ne? Nda-ani, ra ngbü curu ani ne bü kükürü bala?’ ");
INSERT INTO muh_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Te mürü yï la je ngü la bala, fü ah alügü ngü fü ewü, gü ba, ‘Wü di enga ni ni, ni fiti wü nda-ni de. Angü wü le tïne me-wü, teka amere tima gbü ra biringbö, teka jiase kama biri. Ah bala de? ");
INSERT INTO muh_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngü la du siti gbü jia wü neh teka ne? Wü za jiase ka-wü eza, de wü du agba wü. Ni le me-ni ato jiase fü wü kpara, te ewü koro sidi ne, ꞌburu bala. ");
INSERT INTO muh_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wü ngbü engbü de kanga, teka te ni di de züka kpara ne? Ni tï amere ngü de jiase ka-ni, baka ngü te ni ngbü ele ne, de? De bala ne töndö ngü ne!’ ” ");
INSERT INTO muh_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Te Yesu mala mani la nza tete, fü ah adu amala ngü fü wü kpara ka-ye, gü ba, “Si-ngü ka mani la, ah teka ngü ka-yi wü kpara ka-ra. Angü züka ngü te wü kpara ka-ra ena amaka kpaka Me ne, ah de *küküwa fï mere badi, te nga ewü biri biri ꞌburu. Mene wü kpara te ewü o ngü ka-wü kötö, Me ena adu afü ewü, ao kpa engagira nü. Amba mene wü kpara te wüh ngbü eo ngü ka-wü memere, baka wü angbe cögbörö wü kpara ne, Me ena adu afü ewü, ao kpa sidi.” ");
INSERT INTO muh_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Fütanga ngü la, fü wü Yesu ayia de wü kpara ka-ye, teka anü agbü Yerüsalema. Te wüh ngbü enü tete te kaje kpa etüngba kpala, fü engu ayia ace te-ye arü, aï wü *kpara ka-ye nzükpa de füh ye ꞌbasu ne, esüka bi wü kpara la, anü de ewü cüküꞌdaye edere sü. ");
INSERT INTO muh_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Fü ah amala ngü fü ewü, gü ba, “Wü di enga wüna, yi wu eyi, gü ba, nih ngbü enü dene agbü Yerüsalema. Te nih ena akoro kpala, wüh ena azoro ra, *Ye Kpara ka Kpï ne, anü di engagira wü *mere kovo bete wü *mürü rïrï, te ewü le ngü ka-ra de. Wü mere kovo la ena akolo ngü ka-ra, gü ba, ‘Ah le de wüh mörö ra asidi.’ ");
INSERT INTO muh_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Fü ewü ayia ato ra fü wü *ganzi kpara. Fü wü ganzi kpara la akpo emü ra, da efala ra, kpah da esüma ra de juru. Fü ewü adu abere ra, amörö füh rü gbegbete. Amba Me ena adu azükü ra gbü *ebabata sïkpï.” Dela ngü ta te Yesu mala fü wü kpara ka-ye, o wüh ngbü enü tete agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Fütanga ngü la, fü wara Zebedayo ayia de wü di enga ye ꞌbasu, *Yakobo ake *Yüwane, akoro kpaka Yesu kpikpi wü. Fü engu abu nzökuta ye engagira Yesu, andaꞌba te-ye fefe. ");
INSERT INTO muh_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Te Yesu wu bala, fü ah ayi-tata, gü ba, “Ye ngbü ele ne ngü ne?” Würüse la gü ba, “Mere kpara, ngü biringbö te ma ele kpaka mü, ah dene. Gbü sïkpï te mü ena angbü mere miri tete, ah le de mü za wü jaji ka-ra de ꞌbasu ne, mü o gara gbü kokpa, de gara ngbü nda-ye gbü kamisü ede mü. Fü yi angbü de ewü gbü miri la.” ");
INSERT INTO muh_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Fü Yesu adu amala ngü fü wü Yakobo ake Yüwane, gü ba, “Ngü te yi yi-ta ra di la, yi wu sisi na mbi mbi de. Te yi le amaka wazi baka nda-ra la, ah le de yi zü kpah mere cïnga baka nda-ra, de te ma ena azü ne. Yi tï eyi azü mere cïnga, baka nda-ra la? Ngü la tï afa yi de?” Fü ewü ale ngü, gü ba, “Wayi, ani le eyi amere ngü la.” ");
INSERT INTO muh_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu gü ba, “Ah mbi. Yi ena azü mere cïnga baka nda-ra fanü fanü. Amba ma tï ao yi baka mere kpara fütanga ra nda-ra de. Ngü la, ah ka-ye de ngü ka Wüba, Me, angü ah reke sü la eyi teka wü kpara ka-ye, te engu fe ewü ne.” ");
INSERT INTO muh_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Fü du wü *kpara ka Yesu nzükpa ne ayia aje ngü la. Fü maguma ewü ayia asiti eküte wü Yakobo ake Yüwane, da efï ngü emaguma wü, gü ba, “Wüh ele ao te-wü ba mere kpara gbü nzö ani?” ");
INSERT INTO muh_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Te Yesu wu ngü la bala, fü ah adu aï wü kpara ka-ye la ꞌburu kpaka ye, amala ngü fü ewü, gü ba, “De-yi, yi wu kpah bü kpo, gü ba, wü miri füh kotö ne ngbü engbü gbü nzö wü kpara de mere wazi. Fü ewü angbü emere wü kpara esa lö wü la, ba e te ewü ngbü ele. ");
INSERT INTO muh_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Yi le amere kpah bala? Ah bala de. Te mü le angbü ba mere kpara esüka wü bu mü la, mü fü te-mü ba jaji, te ngbü emere tima fü wü bu ye. ");
INSERT INTO muh_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Te di bala, ah le de yi fü fïngangü ka-yi baka nda-ra. Angü de-ra, *Ye Kpara ka Kpï, ma koro füh kotö ne, neh teka ne? Yi efï nda-yi, gü ba, ma koro ta teka angbü ba mere miri, teka fü wü bu ra angbü emere tima fere? Ah bala nda de. Ma koro teka amere tima fü wü kpara, da ele ta-ngü te ewü. Angü ma ena ato te-ra fü kpi, teka afa wü kpara gbü *siti ngü ka-ewü, fü ewü aküwa.” Dela ngü te Yesu mala fü wü kpara ka-ye, teka mene kpara te ena angbü memere gbü jia Me. ");
INSERT INTO muh_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Fütanga ngü la, o wü Yesu ngbü fï bü enü te kaje ka Yerüsalema, fü ewü anü akoro agbü Yeriko. Fü ewü ayia sela de mere bi wü kpara gbü nga wü, teka anü agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Fü ewü anü amaka gara wü komoko ꞌbasu te jia ewü ni eyi ani, te ewü koro ngbü edere kaje. Te wü komoko de ꞌbasu la je ngü, gü ba, “Wü Yesu ngbü enü sü dela me-wü ne,” fü ewü ayia akpo da eba rere te ïrï Yesu, gü ba, “Yesu! Kundu ye Miri *Davidi! Ani wu eyi, gü ba, Me tima ye teka aküwa ani ne! Ye ceka la bü cïnga te ani ne baaa!” ");
INSERT INTO muh_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Fü wü kpara aci ꞌburu, amala ngü fü ewü, gü ba dene, “Wü nga anga!” Amba wü kpara de ꞌbasu la le ngü ka-ewü la nda-wü de. Fü ewü angbü fï bü eba rere kpa tikpi, gü ba, “Mere kpara! Miri ka-ani! Ye ceka la bü cïnga te ani ne baaa!” ");
INSERT INTO muh_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Te Yesu je ri wü kpara la, fü ah ace te-ye, arü. Fü ah adu aï ewü kpaka ye, ayi-ta ewü, gü ba, “De-wü deyï, wü ele de ni mere fü wü ne ngü ne?” ");
INSERT INTO muh_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wüh gü ba, “Akooo, mere kpara, a le ta de mü ü jia a, teka de a di eceka kpï!” ");
INSERT INTO muh_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Fü Yesu aceka wü kpara la de mere cïnga emaguma ye, fü ah ayia amofo jia ewü. Fü jia ewü ayia aü te-ye ꞌduwa raaa! Fü ewü atï kpah bü ꞌduwa gbü nga wü Yesu, angbü enü de ewü. Dela ngü ta te Yesu ü jia wü kpara de ꞌbasu la tete. ");
INSERT INTO muh_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Fütanga ngü la, fü wü Yesu anü baaala, anü akoro gbamari ede Yerüsalema. Fü ewü ale kaje ka Betefage, te fü esa mere da de ïrï ye Olïve. Fü Yesu ayia atima gara wü kpara ka-ye ꞌbasu kpa engagira nü, ");
INSERT INTO muh_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","gü ba, “Wü nü enü agbü kötï de kpa engakara wü la. Te wü koro kpala, wü ena amaka yï dongï, te wüh i, o kpala, ake enga ye. Wü furu wü dongï la, de wü za ewü, wü koro di fü ni akine. ");
INSERT INTO muh_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amba te gara kpara yi-ta wü, gü ba, ‘Wü ngbü efuru wü nü la teka ne la?’ de wü lügü ngü fefe, gü ba, ‘Mere kpara ka-ani ngbü ele me-ye. Ani ena alügü fü wü enatikine.’ Te wü mala bala la, wüh ena ace wü nü la fü wü.” ");
INSERT INTO muh_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ngü la mere te-ye bala kükürü de, angü ngü la tï kpini de ngü ta te *mürü dofo Zakarïya, ba gbü *Ngari Me, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Me mala ngü fü wü kpara ka Yerüsalema, gü ba, ‘Wü ceka la! Miri, te ni le atima fü wü ne, ah ena koro kpaka wü, füh enga dongï. Ah ka-ye de züka kpara, de gu maguma ye, te ngbü emere ngü ꞌburu ferrre.’ ” ");
INSERT INTO muh_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Fü wü *kpara ka Yesu de ꞌbasu la ayia anü amere ngü la, kpah ꞌburu baka te Yesu mala fü ewü ne. ");
INSERT INTO muh_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Fü ewü afuru dongï la ake enga ye, aza adu di fü Yesu. Fü ewü ayia aza wü bongo ka-wü, agbala, agü füh gü enga dongï la. Fü Yesu adu alï, angbü fefeh. Fü ewü ale kaje angbü enü agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Fü mere bi wü kpara akpo da efufuru wü bongo ka-wü, angbü egbala te kaje. Wü gara ngbü nda-wü edoro wü zukpa rü, eo ereke areke te kaje, teka agbo nga ïrï Yesu di. ");
INSERT INTO muh_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Fü mere bi wü kpara, ta te wüh ngbü enü de wü Yesu ne, angbü ꞌburu egbo nga ïrï Yesu. Gara nda-wü kpa engagira nü, wü gara nda-wü kpa sidi, da eba rere de tadu, emï koko, da ebï ci, gü ba, “Nih gbo nga ïrï Me! Me to wazi fü mü, angü ah tima mü fü a me-ye! Mü za wazi ka kundu kundu nih *Davidi! Mü koro eyi angbü gbü nzö a, baka mere Miri Davidi engu! Me di de mü! Nih gbo nga ïrï Me kpa gbü kpï!” ");
INSERT INTO muh_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Te Yesu ngbü erï tete enü agbü Yerüsalema, fü sü angbü eyiki ꞌduwa ayiki teka wü kpara. Fü wü gara kpara angbü ꞌburu de mere fïngangü, da eyi-ta ngü esüka wü, gü ba, “Apa! Mere kpara te wüh ngbü egbo nganga na de bane, neh da?” ");
INSERT INTO muh_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Fü mere bi wü kpara, de te ewü ngbü efa nganga na ne, fü ewü angbü elügü ngü fü wü kpara ka Yerüsalema, gü ba, “Ah de Yesu, *mürü dofo ka Me, te koro agbü *Galïlaya ne.” ");
INSERT INTO muh_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Te wü Yesu du koro tete agbü Yerüsalema, fü ewü anü akoro etambasü *Mere Kambü ka Me. Fü ewü amaka mere bi wü kpara kpala, te wüh ngbü ecïnzï wü nü de wü lu, teka fü wü kpara adi ese, eto laꞌbï tete fü mere Me. Wü gara ngbü nda-wü da ekura jiase. Fü ngü la ayia asiti gbü jia Yesu afa sü. Fü engu ayia aliki ewü ꞌburu asidi, anzinzi wü cangalï de wü gbaꞌda ka wü kpara la, agbogbofo ꞌburu kötö. ");
INSERT INTO muh_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Fü ah amala ngü fü ewü kpekpeke, gü ba, “Me mala ta teka Kambü ka-ye, gü neh fe? Me gü ba, ‘Kambü ka-ni, ah de sü te wü kpara ena angbü egbo nga ïrï ni gbügbü.’ Yi wu bala de? Amba nda-yi, yi du fü tambasü Kambü ka Me eyi, ba sü ka wü mürü zi!” ");
INSERT INTO muh_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Fütanga ngü la, fü wü kpara te jia ewü ni ani, de wü mene te lö ewü di walawala, agbeke te-wü, akoro kpaka Yesu kpa etambasü Mere Kambü ka Me kpala. Fü engu ayia aküwa ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Te wü mere *kovo, de wü *mürü rïrï wu wü mere kpeke ngü, te Yesu mere ne, fü ngü la ayia asiti te ewü, angü wü jaji ngbü fï bü da egbo nga Yesu kpa etambasü Mere Kambü ka Me kpala, gü ba, “Gbo nga e ngbü te ïrï Me! Nih gbo nga ïrï Yesu, kundu ye Miri *Davidi!” ");
INSERT INTO muh_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Fü wü mere kovo la ayi-ta Yesu, gü ba, “Ceka la! Wü jaji ne ngbü egbo nga ïrï ye, gü ba, ye de Mere Miri, te Me tima teka aküwa ani ne. Ye le atïrï ewü de, neh teka ne?” Fü Yesu alügü ngü fü ewü, gü ba, “Ma tï atïrï ewü nda-ra de! Angü Me mala eyi, gü ba, ‘De-ni Me, ni to wazi eyi fü wü jürü jaji, de wüh di egbo nga ïrï ni di ereke areke.’ Yi wu bala de?” ");
INSERT INTO muh_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Fü Yesu ayia de wü kpara ka-ye, ace wü angbe cögbörö kpara la sela. Etamurago la, fü ewü anü ara ka-wü agbü Betanïya. ");
INSERT INTO muh_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gügü kpurutokokpï, fü wü Yesu ayia agbü Betanïya, edu kpah agbü Yerüsalema. O wüh ngbü enü tete, fü tala ayia amere Yesu. ");
INSERT INTO muh_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Fü engu afü jia ye, awu rü figi. Fü ah afü akoro kpuru esa rü la, de ni maka ta rïrï na, teka azü ka tala. Amba te engu nü koro kpa esa rü la, rïrï na nda ma, ka-ye bü kpakpa na kükürü. Fü Yesu ayia akïna rü la, gü ba, “Mü tï arï tïne kpo fï de!” Bü gbü lö-ra la, fü rü la ayia akpi. ");
INSERT INTO muh_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Te wü *kpara ka Yesu wu ngü la bala, fü ngü la aga gbü jia ewü afa sü. Fü ewü ayi-ta Yesu, gü ba, “Dene neh ene ngü ne? Rü la ürü bü kere de bala teka ne?” ");
INSERT INTO muh_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Fü Yesu alügü ngü fü ewü, gü ba, “Ma ngbü emala fü yi dene zu ngü. Te yi ena ato ta maguma yi fü Me fanü fanü, maguma yi ngbü ꞌbasu ꞌbasu de la, de bane Me ena ato wazi fü yi, teka fü yi amere wü mere kpeke ngü di kpah bala. Yi tï ta eyi amala ngü fü mere da la, gü ba dene, ‘Ye yia eyia sela, ye nü, ye tï agbü mere ngu.’ Ngü la tï ta kpah eyi amere te-ye, ba e te yi mala la. Amba te maguma yi ngbü engbü ꞌbasu ꞌbasu la, yi tï amere ngü bala ne nda-yi de. ");
INSERT INTO muh_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Te di bala, te mü to maguma mü fü Me fanü fanü la, mene ngü te mü ena ayi-tata kpaka Me, Me ena ato ato fü mü.” Dela ngü te Yesu mala fü wü kpara ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Fütanga ngü la, fü wü Yesu ayia sela, anü akoro agbü Yerüsalema. Fü Yesu ayia arï kpa etambasü *Mere Kambü ka Me, akpo angbü erï wü kpara. Fü wü angbe cögbörö *kovo ayia akoro kpaka Yesu, ayi-tata, gü ba, “De-ye deyï, ye ngbü emere wü ngü de bala ne, neh gbü wazi ka da? Kpara te tima ye, aliki wü kpara etambasü Mere Kambü ka Me ne, neh da?” ");
INSERT INTO muh_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Fü Yesu alügü ngü fü ewü, gü ba, “Ni ele kpah ayi-ta wü de ngü biringbö, de wü lügü fü ni feke, fü ni adu amala nga kpara te to wazi fü ni ne, sidi. ");
INSERT INTO muh_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yitangü ka-ni la, ah teka *Yüwane Mürü Babatïza. E-tima engu teka ato babatïza fü wü kpara neh da? Ah de Me de? Anga ah mere ngü la de tete-ye?” Fü ewü akpo da ega yïkï esüka wü, gü ba, “Ani ena alügü ngü la fefe, agü neh fe? Angü te ani mala, gü ba, ‘Me to wazi fü Yüwane me-ye la,’ Yesu ena adu kpah ayi-ta ani, gü ba, ‘Te ah bala la, ani le ngü kaka de, neh teka ne?’ ");
INSERT INTO muh_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amba te ani mala, gü ba, ‘Yüwane ngbü mere ngü la de tete-ye’ la, ah kpah esiti, angü mere bi wü kpara ne ena afala ani, anga amere ani esiti, angü wüh le ngü ka Yüwane fa sü, gü ba, engu de *mürü dofo ka Me.” ");
INSERT INTO muh_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Te di bala, fü wü angbe cögbörö kpara la alügü ngü fü Yesu, gü ba, “Ani wu kpara te to wazi fü Yüwane ne, nda-ani de.” Kpah bala, fü Yesu adu alügü ngü fü ewü, gü ba, “Wayi, ah mbi! Baka te yi le amala nga Yüwane de ne, ma tï amala nga kpara, te to wazi fere ne, fü yi kpah de.” ");
INSERT INTO muh_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Fütanga ngü la, fü Yesu adu amala gara ngü fü wü cögbörö kpara la gbü mani, gü ba, “Ah le de yi fï nga ngü ne mbi mbi mbi. Gara komoko ta ladü de wü di ye ꞌbasu. Gbü gara ra, fü engu anü amala fü gina ye ye, gü ba, ‘Ye ni deyï, ye nü la mba enatikine ale ta-ngü te ni agbü yï ka-ni ke.’ ");
INSERT INTO muh_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","30","Fü gina yeye la alügü ngü fefe, gü ba, ‘Aꞌa! Ni le nda-ni de!’ Te komoko la wu, gü ba, ye ni le anü de ne, fü ah ayia anü kpaka gara ye ye, amala ngü fefe, gü ba, ‘Ye ni deyï, ye nü la mba enatikine, ale ta-ngü te ni, agbü yï ka-ni.’ Fü yeye la ale ngü la ꞌduwa ale, gü ba, ‘Wayi, wö ni, ni ena anü.’ Amba, ah du nü nda de. Sidi nga ngü la, fü gina mbarase la adu afü fïngangü ka-ye. Fü ah adu anü, amere tima la.” ");
INSERT INTO muh_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Fü Yesu adu ayi-ta wü cögbörö kpara la, gü ba, “Esüka wü jaji de ꞌbasu ne, kpara te mere ngü de te wö ye ngbü ele ne, ah de neh da?” Wüh gü ba, “Ah de gina mbarase.” Yesu gü ba, “Wayi, ah ngbürü bala. Amba dene kpeke ngü te ma le amala fü yi. Ah le de yi wu, gü ba, wü siti wü kpara baka wü kpara de te ewü ngbü ero *jiase fü miri, de wü würüse mürü waza, te wüh fü maguma wü, ale ngü ka-ra la, wüh ena aküwa me-wü agbü sü ka Me agbü kpï. Amba nda-yi, te yi gü ba, ani de züka wü kpara ka Me me-ani ne, yi tï aküwa nda-yi de, angü yi le ngü ka-ra de. ");
INSERT INTO muh_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Angü Yüwane koro ta, gü tamu züka kaje ka Me fü yi, gü ba, ah le de yi fü maguma yi, yi le ngü ka Me, amba yi le ngü ka Yüwane la nda-yi de. Amba wü siti kpara le ngü kaka ka-wü ta bü me-wü, fü ewü ayia ace *siti ngü ka-wü, adu ale ngü ka Me. Baka te yi wu siti wü kpara la, te ewü fü maguma wü de bala ne, yi le afü maguma yi nda-yi kpah de.” Dela ngü te Yesu lügü fü wü cögbörö kpara ka wü Yïsarayele la. ");
INSERT INTO muh_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Fütanga ngü la, fü Yesu adu kpah amala gara mani fü wü cögbörö kpara la, gü ba, “Yi je la gara ngü te ma le amala fü yi dene. Gara komoko ta ladü, te maka züka sü, fü ah ayia aru mere bi rü *vinü ka-ye gbü sü la. Fü ah adu ajï ꞌbaranga ekekere na kerekere gbaa. Fü ah areke kpah sü, teka adi efi rï-rü la gbügbü na. Fü ah ajï kpah kambü teka fü wü kpara adi engbü gbügbü, da efete yï la. Fü engu aza wü kpara ka tima, ao kpala, aro mö de ewü areke areke, de wüh di eceka kpï fütanga yï ka-ni la mbi mbi mbi, angü ni ena anü andoro agbü gara sü nengete. ");
INSERT INTO muh_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Te kpïrï ka makolo rï-rü la koro tete, fü komoko la ayia atima wü labï ka-ye, kpaka wü kpara ka tima ka-ye la, teka aza rï-rü la fü ye. ");
INSERT INTO muh_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Fü wü kpara de te ewü ngbü emere tima agbü yï la, ayia azoro wü labï la. Fü ewü amiki gara, amörö gara, asötö gara de teme. Fü ngü la ato mere fïngangü fü mürü rïrü la. ");
INSERT INTO muh_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Teka ngü la, fü ah ayia atima kpah mere bi wü gara labï ka-ye, afa mene ewü te enga gina ne ka. Fü wü siti kpara la ayia amemere ewü kpah bala. ");
INSERT INTO muh_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Fütanga ngü la, fü engu adu afï nga ngü, gü ba, ‘Te ni tima tïne cu ye ni kpaka wü kpara la, wüh ena akpe cürü mbarase la akpe.’ Fü ah ayia atima ye ye la kpaka ewü kpala. ");
INSERT INTO muh_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Te wü kpara la wu ye mürü rïrü la te ngbü ekoro, fü ewü akpo da emala ngü esüka wü, gü ba, ‘Ceka la! Ye mürü rïrü ne te ekoro! Engu ena aza e-nga-kpa wö ye, te gara me-ye. Te di bala, ah le de ani mörö engu asidi, teka fü yï ka-ewü ne angbü te gara fü ani.’ ");
INSERT INTO muh_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Fü ewü ayia azoro ye mürü rïrü la, anü di agbü gü, amiki engu kpö kpö kpö! amörö ka.” ");
INSERT INTO muh_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Fü Yesu adu ayi-ta wü cögbörö kpara la, gü ba, “Gbü fïngangü ka-yi, te mürü rïrü la du koro kpaka siti wü kpara la, ah ena amere de ewü neh baye?” ");
INSERT INTO muh_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wüh gü ba, “Ah ena amörö siti wü kpara la ꞌburu, adu aza wü gara kpara, ao ewü teka adi eceka kpï fütanga wü rïrü ka-ye la, teka fü ewü angbü eto rï-rü kaka la fefe gbü kpïrï ka-ye.” ");
INSERT INTO muh_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Fü Yesu amala ngü fü wü cögbörö kpara la, gü ba, “Ngü ta te wüh ba gbü *Ngari Me, teka ngü la, gü neh fe? Ngü la gü ba, ‘Wü gara kpara ngbü ta ejï *Mere Kambü ka Me. Fü ewü amaka gara mere rü, te ewü le nda-wü de. Fü ewü ace rü la asidi. Tïtïne rü ta te ewü ce la, Me du o tïne eyi mere kpeke rü de wazi ye, te wü bu ye na ngbü engbü ꞌburu eküküte. Nih gbo nga ïrï Me, angü engu mere mere züka ngü eyi fü nih!’ ");
INSERT INTO muh_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Te di bala, ma ngbü emala fü yi kpekpeke, gü ba, Me tï ale yi ba wü kpara ka-ye tïne kpo fï de! Ah ena adu ale ka-ye ꞌduwa wü *ganzi kpara, te ewü ngbü ele ngü kaka. ");
INSERT INTO muh_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma ngbü emala fü yi dene zu ngü, angü te kpara tï füh rü engu la, ah ena akukuru akukuru, coro coro! Kpah bala, te rü la tï füh kpara la, rü la ena akpaꞌda engu akpaꞌda.” ");
INSERT INTO muh_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Te wü angbe cögbörö wü *kovo la je mani te Yesu mala la, fü ewü awu teke, gü ba, Yesu ngbü emala mani la eküte ani, teka te ani le ngü kaka nda-ani de ne. Fü ngü la ake te ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Teka ngü la, wüh le ta de ani zoro Yesu gbü lö-ra la, amba dada ma, angü wüh ngbü ekpe cürü mere bi wü kpara la. Angü mere bi wü kpara la le ta ngü ka Yesu fa sü, gü ba, engu de *mürü dofo ka Me. Dela mani te Yesu mala teka wü cögbörö kpara, te ewü le ngü kaka de ne. ");
INSERT INTO muh_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Fütanga ngü la, fü Yesu adu kpah amala gara ngü fü wü kpara la gbü mani, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ma le asere la fü yi, kaje te Me ngbü ele, de wü kpara ꞌburu koro tete wü kpara ka-ni. Kaje la, ah baka e dene. Gara miri ta ladü, te reke mere karama teka ye ye, te ele aza würüse. Fü miri la atima ngü fü mere bi wü kpara, teka de wüh koro, wüh zü karama la. ");
INSERT INTO muh_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Te sïkpï ka karama la tï tete, fü miri la ayia atima wü kpara ka tima ka-ye, de wüh nü, wüh ï wü kpara, de te ni tima ngü fü ewü terane ne, gü ba, ‘Tïtïne sïkpï ka karama tï eyi. Wüh koro ekoro ꞌburu enatikine, azü e.’ Amba wü kpara, de te wüh ï ewü ne, wüh le akoro nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Fü engu adu kpah atima wü gara kpara ka tima ka-ye, gü ba, ‘Wü nü, wü mala ngü fü wü kpara, de te ni ï ewü ne, kpekpeke, gü ba, “Tïtïne ni mörö mere bi wü yiti ka-ni eyi. Wüh zï wü e la kpah eyi ꞌburu, ce o nzo. Ah le de wü koro kere, teka azü wü e la, angü wü e la ena asiti!” ’ ");
INSERT INTO muh_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amba wü kpara la, yi fï ngü teka karama la nda-yi de! Fü yi ayia anü ka-yi, teka amere wü ngü ka-yi, ba e te yi ngbü ele. Fü gara anü ka-ye, amere tima agbü yï ka-ye. Fü gara anü nda-ye, ase wü e ka-ye. ");
INSERT INTO muh_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Fü wü gara azoro wü kpara ka tima ka miri la, amemere lara ewü, adu amömörö ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Fü ngü la ayia ake te miri la afa sü. Fü engu ayia atima wü marajümïya ka-ye, amömörö wü kpara la, acuru kötï ka-ewü ꞌburu asidi. ");
INSERT INTO muh_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Fütanga ngü la, fü engu adu amala ngü fü wü kpara ka tima ka-ye, gü ba, ‘Tïtïne, wüh reke wü e teka karama ne ꞌburu eyi nzo. Amba wü kpara, ta te ni ï ewü teka azü karama ne, wüh le akoro nda-wü de. Te di bala, ni ena amere ngü wü e ka-ni ne, neh baye? ");
INSERT INTO muh_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Te ah bala, de wü nü te enga wü kötï biri biri ꞌburu, de wü gïrï bü mene wü kpara te wü ena amaka, wü ï ewü, de wüh koro, wüh zü wü e ne.’ ");
INSERT INTO muh_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Fü wü kpara ka tima la ayia abaya te enga wü kötï. Fü ewü ayia abiti wü kpara te ewü maka ne, wü siti wü kpara, abe kpah te wü züka wü kpara mini. Fü wü kpara asi gbü kambü, de te wüh ngbü ezü e ka karama gbügbü na ne, ꞌduwa gbe! ");
INSERT INTO muh_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Fü miri la ayia arï kpa esambü, teka aceka wü ngba ka-ye ne. Fü jijia ayia atï eküte gara kpara biringbö, te to züka bongo te-ye nda de. ");
INSERT INTO muh_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Fü engu aï kpara la, amala fefe, gü ba, ‘Awuba ni deyï, ah mere baye, te ye le ato züka bongo, te ni to fü ye ne, nda-ye de ne?’ Fü jia kpara la ayia avi. Dada te engu ena alügü ngü nda ma. ");
INSERT INTO muh_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Fü miri la amala ngü fü wü kpara ka tima ka-ye, gü ba, ‘Wü zoro engu, de wü i lölö na, de wü kpakpa na ꞌburu. Wü za engu, wü gü gbü mbiri sü kpa etanü kpala, de ah ngbü, ah ku gba da enyüma gbü te-ye kpala.’ ” ");
INSERT INTO muh_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Teka ngü la, fü Yesu adu kpah amala ngü fü wü kpara la, gü ba, “Me ngbü eï wü kpara ꞌburu de wüh küwa, amba wü kpara te ewü ena akoro kpaka Me, wüh ena adi biri biri. Wüh ena adi ꞌduwa mene wü kpara, te ewü ena afü maguma wü, ale ngü ka Me de maguma wü biringbö.” ");
INSERT INTO muh_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fütanga ngü la, fü wü *Farusi ayia abiti te-wü, angbü efï ngü, gü ba, “Ani ena afiti Yesu, de engu mala siti ngü, teka fü ani azoro engu tete, neh baye baye?” ");
INSERT INTO muh_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Fü ewü atima wü gara kpara ka-wü, bete wü gara kovo ka Miri Anïtïpa *Erode, kpaka Yesu. Fü ewü akoro amaka Yesu, amala ngü fefe na, gü ba, “Mere kpara, ani wu eyi, gü ba, ye de kpeke kpara, te ye ngbü emala zu ngü ka Me fü ani fanü fanü. Angü ye kpe cürü wü kpara nda-ye ꞌburu ꞌdö de, ye ngbü ele ka-ye ꞌduwa ngü ka Me. ");
INSERT INTO muh_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Te di bala, gara ngü ladü te ani le ayi-ta ye di. Ah tï atï fü ani angbü fï bü da ese ngürü ani fü *Kayïsara, miri ka wü *Rüma, te ngbü gbü nzö ani ne? Anga ah tï de? *Rïrï ka Müse gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Amba Yesu, mü wu fïngangü ka-ewü la nda-mü eyi kpo. Fü mü ayia amala fü ewü, gü ba, “Wü de wü mürü mani! Wü le afiti ni bala neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wü za la biri jiase sela, wü sere fü ani.” Fü ewü aza gara jiase biringbö, ato fefe. ");
INSERT INTO muh_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Fü Yesu adu ayi-ta ewü, gü ba, “Kuru kpara, bete ïrï kpara, de eküte jiase ne, ah de nda da?” ");
INSERT INTO muh_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Fü ewü alügü ngü fü Yesu, gü ba, “Ah de kuru Miri Kayïsara.” Yesu gü ba, “Wayi, ah mbi! Te ah de kuru miri la, de yi lügü e ka miri fü miri. De yi lügü nda Me kpah fü Me.” ");
INSERT INTO muh_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Te wü mürü mani la je ngü, de te Yesu lügü fü ewü de bala ne, fü ewü ayia anga. Fü ewü ayia ace Yesu de wü kpara ka-ye sela, anü sü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Wü gara wü kpara ta ladü esüka wü di enga *Yïsarayele, te wüh ngbü eï ewü, gü ba, wü *Saduke. Wü kpara la, wüh ngbü efï nda-wü, gü ba, te kpara kpi eyi la, ah kpi eyi fï badi, ah du azükü gbü kpi la nda tïne de. Gbü sïkpï la, fü wü gara Saduke la ayia akoro kpaka Yesu, ayi-tata gbü mani, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mere kpara, gara ngü ladü te ani le ayi-ta ye di. *Müse ba ta ngü fü ani gbü *Rïrï ka Me, gü ba, ‘Te kpara kpi, ce wara ye, o wüh bï ye ake di la de la, ah le de enga ni ye na za würüse gbü nganga na la, teka abï ye dada na, angü ïïrï ena adürü.’ ");
INSERT INTO muh_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Amba, te wü kpara ena azükü gbü kpi azükü fanü fanü la, ngü la ena adi baye? Angü gara wü komoko ta ladü, wüh guvu ni wü lorozi. Fü gigina aza würüse, fü ah akpi ace würüse la, o wüh bï ye ake di la de. Fü gara enga ni ye na ayia aza würüse la. ");
INSERT INTO muh_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Fü ah ayia kpah akpi, o wüh bï ye la de. Fü ebabata enga ni ye na ayia aza würüse la. Fü ngü la amere te-ye bala, te nga ewü lorozi la ꞌburu, wüh bï ye te würüse la nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Fü würüse la adu akpi nda-ye tïne sidi nga ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Te wü kpara ena azükü azükü gbü kpi fanü la, würüse la ena adi neh wara da? Kükürü de, angü wü kpara de lorozi la ꞌburu, za ta würüse la eyi wara ewü tete!” ");
INSERT INTO muh_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Fü Yesu adu amala ngü fü wü Saduke la, gü ba, “Yi fï nda-yi, gü ba, Me tï azükü wü kpara gbü kpi nda de? Yi dürü bala, neh teka ne? Yi le aje si-ngü gbü *Ngari Me de, neh teka ne? Yi le awu wazi ka Me kpah de, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gbü sïkpï te Me ena azükü wü kpara tete gbü kpi, ngü ka za-te ena adi nda ma. Angü, te Me zükü wü kpara eyi gbü kpi la, Me ena adu afü ewü baka wü *malayïka ka-ye, fü ewü angbü fï mere badi agbü kpï. ");
INSERT INTO muh_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amba, Me mala gbü *Ngari ye, teka ngü ka züzükü ka wü kpara gbü kpi, gü neh fe? ");
INSERT INTO muh_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Me mala ta ngü fü *Müse, gü ba, ‘De-ni Me, ni de *vüngüte ka *Abarayama, ake *Yïsaka bete *Yakobo.’ Amba gbü ra ta te Me mala ngü la tete, o wü Abarayama kpi ka-wü eyi gügü. Fïngangü ka-yi gü ba, Me ena amala ngü teka wü kövö, gü ba, ‘Wüh de wü vüngüte ka-ni?’ Ah bala de. Me mala ngü la, angü wü Abarayama ka-wü eyi ladü ezükü, agbü sü ka Me fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Dela ngü ta te Yesu mala fü wü Saduke, gü ba, Me ena azükü wü kpara ka-ye, fü ewü angbü fï mere badi agbü sü ka-ye agbü kpï kpala. Ta te mere bi wü kpara gbü sü la je ngü la bala, fü ngü la aga gbü jia ewü ꞌburu afa sü, angü Yesu za ngü gömö wü Saduke eyi. ");
INSERT INTO muh_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Te wü *Farusi wu, gü ba, Yesu za ngü gömö wü *Saduke eyi ne, fü ewü aci akoro kpaka Yesu. ");
INSERT INTO muh_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fü gara mere kpara esüka ewü, te di de *mürü rïrï, adu afï nga gara yitangü, teka are maguma Yesu di. Fü Farusi la ayi-ta Yesu, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mere kpara deyï, nda-ni yitangü kpah ladü. Esüka wü *Rïrï ka Me ꞌburu, kpeke rïrï, te fa wü bu ye ꞌburu, neh engu deyi?” ");
INSERT INTO muh_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu gü ba, “Kpeke rïrï te Me to fü ani, gü ba dene, ‘Mü le Mere Me de maguma mü ꞌburu. Mü o fïngangü ka-mü kpah ꞌburu eküküte. Mü to te-mü kpah ꞌburu fefe.’ ");
INSERT INTO muh_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Dela kpeke Rïrï te Me to fü ani, te fa wü bu ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gara Rïrï engu na, gü ba dene, ‘Mü le wü bu mü kpah baka e te mü ngbü ele küte mü.’ Dela gina wü kpeke Rïrï ta te Me to fü ani. ");
INSERT INTO muh_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wü ngü de ꞌbasu la biti wü si-ngü ta te *Müse, de wü gara wü *mürü dofo ka Me, ba gbü *Ngari Me ne eyi ꞌburu, gbü ewü.” Dela ngü ta te Yesu mala fü wü Farusi, teka kpeke Rïrï ka Me. ");
INSERT INTO muh_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","O wü *Farusi ngbü ꞌburu tete ede Yesu, fü Yesu adu ayi-ta ewü, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Yi ngbü eo jia yi da ecï nga *Kurisito, Miri te Me ena atima teka aküwa yi ne. Ah mbi. Fïngangü ka-ye gü ba, wüh ena abï engu neh gbü nguwa da?” Wüh gü ba, “Miri la ena adi kundu kundu ye *Mere Miri Davidi, te ena angbü gbü nzö ani kpah baka Davidi.” ");
INSERT INTO muh_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu gü ba, “Miri la ena adi baka Davidi fanü? Angü Davidi ba ta ngü cu me-ye, gbü wazi ka *Nzïla Wazi Me, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Me mala ngü fü Miri ka-ni, gü ba dene, “Ye ngbü gbü kokpa ka-ni sene! Angü ni fe ye, o eyi Mere Miri! Te di bala, ye ena angbü gbü nzö wü kpara ꞌburu! Angü ni ena ao wü vügü ka-ye ꞌburu esa lö ye!” ’ ");
INSERT INTO muh_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Te Davidi mala, gü ba, ‘Engu de Miri ka-ni la,’ te di bala, wawazi na fa nda Davidi de? Ma ngbü emala fü yi, gü ba, ngü kaka ena afa nda Davidi ka!” ");
INSERT INTO muh_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dela ngü ta te Yesu mala, teka Mere Miri, te Me ena atima teka aküwa wü kpara. Fü komö wü *Farusi la agu ꞌburu agu, wüh du mala gara ngü tïne de. Fütanga ngü la, gara kpara te du le aga yïkï ake di nda tïne ma. ");
INSERT INTO muh_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Fütanga ngü la, fü Yesu arü amala ngü fü wü kpara ka-ye, de mere bi wü kpara la ꞌburu, ");
INSERT INTO muh_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","3","gü ba, “Mene wü *Farusi, te ewü gü ba, ani de wü *mürü rïrï ne, wüh ngbü nda-wü bü erï wü kpara de *Rïrï te Me to fü Müse ne, kükürü kükürü bala. Wüh wu Rïrï di bü kpo, amba wüh mere wü ngü, te ewü ngbü erï yi di la, nda-wü de. Te di bala, ah le fü yi adi eje wü ngü, te ewü ngbü erï yi di la, fü yi angbü emere ereke areke. Amba yi mere e angbü emere mani baka nda-wü la de. Angü wüh ngbü emala fü yi, de yi di emere Rïrï ka Me, amba nda-wü, wüh le adi emere Rïrï ka Me de maguma wü ꞌburu nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wüh ngbü eza wü gara mere bi rïrï ka-wü, eo kpekpeke füh Rïrï ka Me, baka mere tiri e, te ewü ngbü eo gbü nzö wü kpara. Amba cu de-ewü bane, wüh mere Rïrï engu la nda-wü de! ");
INSERT INTO muh_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wü mürü rïrï la, wüh ngbü emere mere bi wü rïrï ka gele ka-wü la, teka de wü kpara wu ani baka züka wü kpara ka Me. Teka ngü la, fü ewü angbü eba wü *Ngari Me eküte wü e, angbü ei eraku wü, wü gara gbü wü kpa wü. Fü ewü angbü fï bü eto bongo, te wüh ngbü emere tima ka Me di ne, eküte wü, teka fü wü kpara adi eceka ani ba wü züka kpara ka Me. ");
INSERT INTO muh_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kpah bala, wüh ngbü ele, de wü kpara ꞌburu di ecu ngü ani. Teka ngü la, te ewü koro gbü sü ka karama, anga te ewü rï kpa *esambü ka biti-te la, wüh le ꞌduwa adi engbü füh züka kpökpö, kpa engagira nü. ");
INSERT INTO muh_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kpah bala, te ewü maka te-wü de wü kpara te kaje la, wüh le de wüh di egü mandï fü ani, da ecu ngü ani acu, kpah da eï ani, ‘Mere kpara.’ ");
INSERT INTO muh_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","10","Amba de-yi, wü kpara ka-ra, yi mere e ao te-yi, de wü kpara di ecu ngü yi ne de. Yi mere e ale de wüh di eï yi, mere kpara ne, kpah de, angü ma de mere kpara ka-yi ꞌduwa me-ra. Te di bala, yi ꞌburu de wü di enga ni. Kpah bala, yi cu ꞌduwa ngü Me. Yi mere e acu ngü wü kpara füh kotö sene, ao ewü memere baka Wö yi, Me ne, kpah de. Angü Me, te di agbü kpï ne, de Wö yi ꞌduwa me-ye kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Te mü le angbü mere kpara esüka wü bu mü la, ah le de mü fü te-mü baka labï, te ngbü emere tima fü wü bu ye. ");
INSERT INTO muh_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te mü le ao te-mü memere la, Me ena adu ao mü baka labï. Amba te mü o te-mü baka labï la, Me ena adu ao mü mere kpara me-ye.” ");
INSERT INTO muh_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Fü Yesu adu afü te-ye, akpo da emala ngü fü wü *mürü rïrï la, gü ba, “De-yi wü Farusi, te yi gü ba, ani de wü *mürü rïrï ne, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Yi gü ba, ani de züka wü kpara ka Me me-ani, amba yi le to ngari Me, de te ma ngbü emala ne, nda-yi de. Gara *siti ngü ka-yi te fa sü, angü yi ngbü kpah etïrï kaje fü wü gara kpara, de wüh mere e, ale to ngü ka Me la kpah de. Te di bala, yi de wü mürü mani! ");
INSERT INTO muh_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Yi ngbü ezi e ka wü würüse wökö gbü mani, ece ewü, eo gbü cïnga. Yi ngbü kpah eyi-ta Me, teka mere bi lö-ra, de wü kpara di ecu ngü ani, kpah teka fü ewü adi eceka ani ba kpeke wü kpara. Te di bala, yi ena amaka mere siti kuru te gara afa sü! ");
INSERT INTO muh_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Yi ngbü endoro gbü wü sü füh kotö ne ꞌburu, teka agïrï kpara te yi ena afü, de ah le ngü ka-ani la, gü ba, ah de zu ngü ka Me. Amba te kpara la du le ngü ka-yi eyi la, fü yi adu angbü erï engu, de mere bi wü siti ngü ka-yi, te yi ngbü emere ne. Te di bala, Me ena adu ato mere siti kuru te yi afa sü, angü yi rï engu de siti ngü ka-yi la me-yi! ");
INSERT INTO muh_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","19","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara. Angü yi ngbü erï wü kpara de ngü ka Me de mani, amba ngü de te yi ngbü erï ewü di la, ah de ngü ka Me nda de. Yi ngbü emala, gü ba, ‘Te kpara kïna te-ye te ïrï *Mere Kambü ka Me la, kïna kaka la, tï amere engu esiti de. Kpah bala, te kpara kïna te-ye te ïrï *cangalï, te wüh ngbü ecuru laꞌbï fefeh fü Me ne la, kïna la mere engu esiti kpah de.’ De bala ne töndö ngü ne? Te kpara kïna te-ye bala, fü ah adu ace kïna ka-ye la, Me ena ato kuru tete ato! Angü wü e la ꞌburu de kpeke e gbü jia Me. Te ah de Kambü ka Me, bete *diki-se de gbügbü la, anga cangalï, te wüh ngbü eto laꞌbï fü Me fefeh, bete laꞌbï la, wüh ꞌburu de kpeke ngü gbü jia Me. ");
INSERT INTO muh_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","21","Te di bala, te mü kïna te-mü te ïrï Kambü ka Me la, mü ngbü dela ekïna te-mü kpah te ïrï Me. Kpah bala, te mü kïna te-mü te ïrï cangalï, te wüh ngbü eto takpa fefeh fü Me ne la, mü ngbü dela kpah ekïna te-mü te ïrï Me. ");
INSERT INTO muh_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Te mü ngbü ekïna te-mü te ïrï kpï la, mü ngbü dela kpah ekïna te-mü te ïrï Me, angü kpï de kpökpö ka Me. ");
INSERT INTO muh_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","De-yi wü *mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Angü yi ngbü eo fïngangü ka-yi kpekpeke teka rïrï ka gele ka-yi. Baka te yi ngbü eto tari wü e ka-yi ꞌburu fü Mere Me ereke areke ne, ah esiti de. Amba yi le ato maguma yi fü Me de, teka ne? Yi le ale ta-ngü te wü mürü cïnga kpah de. Kpah bala, yi ngbü ekolo ngü ka wü kpara de mani. Yi ngbü emere ngü bala, teka ne? Dela ngü te siti gbü jia Me fa sü. ");
INSERT INTO muh_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yi gü ba, ‘Ani ngbü erï wü bu ani,’ amba yi wu ngü ꞌburu ꞌburu de! Yi ngbü eo fïngangü ka-yi mba teka enga ngü cüküꞌdaye, fü yi adu ace memere na ne ka. Yi ngbü baka kpara te gü jia ye bü te enga bükümü cüküꞌdaye gbü ngu te engu le anzö, fü ah ayia aza bükümü asidi. Amba mere siti nzeke ladü gbü ngu la. Fü kpara la adu aza nzeke la, anzö, ami aguvu ye! ");
INSERT INTO muh_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Angü maguma yi baka ndüꞌba anga sila, de te yi ngbü ezürü bü küküte ereke areke ne, amba yi zürü gbügbü na nda-yi de. Siti fïngangü, de ngü ka zi, bete gümü e sibi emaguma yi fa sü! ");
INSERT INTO muh_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","De-mü, te mü gü ba, ni de *Farusi ne, jia mü ni eyi ani! Ah le fü mü areke maguma mü, teka de wü kpara ꞌburu wu mü, gü ba, mü zu de kpara ka Me fanü. ");
INSERT INTO muh_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Yi baka wü mbükü te wüh fa de ründü reke areke, amba kpa gbügbü kpala, bü wü biki kpara, te zi eyi azi, te sese ngbü efu afu. ");
INSERT INTO muh_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ah teka ngü ka-yi kpah bala. Wü kpara ngbü eceka yi baka züka wü kpara nda-wü bü kükürü, amba kpa emaguma yi, wü mani de wü *siti ngü sibi fa sü! ");
INSERT INTO muh_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","De-yi wü mürü rïrï, Me ena ato mere kuru te yi te gara, angü yi de wü mürü mani. Yi ngbü esu wu te-yi, da ereke mbükü wü *mürü dofo ka Me ta gügü ne, gü ba, ani ngbü dela ecu ngü ewü. ");
INSERT INTO muh_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Amba wü kundu yi ngbü mömörö wü mürü dofo la me-wü! Yi ngbü esu wu, gü ba, ‘Te ani ena adi ta ladü gbü wü re ka wü kundu ani de kpala la, de bane ani tï ale ngü ka-ewü, te ewü ngbü mömörö wü mürü dofo la, nda-ani de.’ ");
INSERT INTO muh_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Amba ngü ka-yi de te yi ngbü emere la, ah kpah baka nda wü kundu yi, angü yi le amörö ra, kpah baka te wü kundu yi mörö wü mürü dofo la. Teka ne de, angü yi le aje ngü ka-ra, te ma ngbü erï yi di ne, nda-yi kpah de. ");
INSERT INTO muh_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ngü ma! Ah le de yi mere siti ngü la emere bala eküte ra, angü maguma yi ngbü fï bü enzu, baka nda wü kundu yi! ");
INSERT INTO muh_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yi de siti wü kpara baka wü kpürü! Yi ngbü fï bü da emömörö wü kpara! Yi ena aküwa neh baye baye? Te di bala, Me ena ato mere siti kuru te yi, te gara. ");
INSERT INTO muh_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amba fanü fanü, Me le ta eyi fü yi aküwa. Te di bala, fü Me amala, gü ba, ni ena atima wü mürü dofo kpaka yi, kpah de wü kpeke kpara, te ewü ena arï yi de ngari ni, Me, teka fü yi afü maguma yi, adu kpaka ni. Amba wüh ena arï yi de ngü la bala ma! Yi tï ale ngü ka-ewü la nda-yi de! Yi ena abere gara ewü, amörö füh *rü gbegbete. Fü yi asüma gara ewü gbü jia wü kpara ꞌburu. Yi ena aliki kpah gara ewü gbü wü mere kötï ka-yi asidi. ");
INSERT INTO muh_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Te di bala, Me ena ato mere kuru te yi teka ngü la. Ma ngbü emala fü yi dene zu ngü, ah le de yi ceka ꞌbe! Ah kpo te kpi ka Abele, gina kpara ta te wüh mörö füh kotö ne, akoro te kpi ka Zakarïya, ta te wüh mörö etambasü *Mere Kambü ka Me ne, lïya ka ngüte wü kpara ka Me la ꞌburu ena adi gbü nzö yi, angü yi le ngü ka-ra de.” ");
INSERT INTO muh_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Fü Yesu adu angbü de mere cïnga, gü ba, “Ööö! Yi ceka la mere cïnga te ena amaka wü kpara ka Yerüsalema ne te gara! Angü wüh ngbü emömörö wü mürü dofo, te Me ngbü etima fü ewü ne ꞌburu amörö asidi. Ma ngbü ta ele abiti wü di enga *Yïsarayele ꞌburu, teka aküwa ewü, baka yï-ngü te ngbü ebiti wü di enga ye, esa mbula ye, amba wüh le nda-wü de! ");
INSERT INTO muh_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Te di bala, Me tï ale ngü ka-ewü kpah de! Ah ena ayia ka-ye ace mere Kambü ka-ewü, ka Me, agbü Yerüsalema de kpala. Fü wü vügü akoro, amümürü mere Kambü la, de mere kötï ka-ewü ꞌburu, te gara. ");
INSERT INTO muh_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma emala fü yi dene zu ngü. Wüh tï awu ra tïne de, zalü te ewü ena afü maguma wü, adu ale ngü ka-ra, gü ba, Me tima ra me-ye fanü.” Dela ngü ta te Yesu mala teka mere kuru, te Me ena ato te wü di enga *Yïsarayele ne. ");
INSERT INTO muh_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Fütanga ngü la, fü wü Yesu ayia ace tambasü *Mere Kambü ka Me, akpo angbü enü ka-wü. Fü wü *kpara kaka arü amala ngü fefe na, gü ba dene, “Mere kpara deyï, ye ceka la, züka Kambü ka Me ne. Wüh jï engu kpekpeke, reke areke!” ");
INSERT INTO muh_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu gü ba, “Yi mere e afï, gü ba, Mere Kambü ka Me la ka-ye kpekpeke ne, de. Angü, ma mala fü yi dene zu ngü, te gara, wüh ena amürü kambü la amürü ꞌburu kötö. Da biringbö, te wüh ena ace ao füh kiri ye sela, ena adi ma.” ");
INSERT INTO muh_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Fü wü Yesu ayia ace sü la, anü alï angbü ka-wü kpa füh da de ïrï ye Olïve ne. Te wüh koro kpala, fü wü kpara kaka ayia akoro kpakaka, ayi-tata, gü ba, “Mere kpara, mba ngü ladü te ani le ayi-ta ye di. Ye gü ba, ‘Wüh ena amürü mere Kambü ka Me la asidi.’ Ngü la ena amere te-ye neh elaye? Ah ena adi gbü *adu sïkpï, te ye ena adu akoro, angbü ba mere miri füh kotö ne? Anga ngü, te ena agü tamu ngü la fü ani, gü ba, sïkpï la koro eyi gbamari, ah de ne ngü ne?” ");
INSERT INTO muh_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Fü Yesu alügü ngü fü wü kpara ka-ye la, gü ba, “Yi ceka te-yi mbi teka wü mürü fiti, angü wüh ena afiti yi. ");
INSERT INTO muh_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kükürü de, angü mere bi wü kpara ena akoro, amere mani te ïrï ra, afiti wü bu wü, gü ba, ‘Ani me-ani de mere miri, te Me tima teka aküwa wü kpara.’ Te di bala, mere bi wü kpara ena ale ngü ka-ewü la. Amba nda-yi, yi mere e ale ngü ka-ewü la de. ");
INSERT INTO muh_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","8","Angü mere bi wü ngü ladü, te wüh ena amere te-wü feke, o adu sïkpï la koro la de. Nguwa wü kpara ena ayia atï de gü, gbü nzö nguwa wü gara kpara. Yiki-tö ena amere te-ye gbü mere bi wü sü füh kotö ne. Kpah bala, gbü wü gara sü, mere siti kpïrï tala ena atï gbü nzö wü kpara. Dela ꞌburu wü ngü te wüh ena amere te-wü füh kotö ne, o adu sïkpï koro la de. Wü ngü la ꞌburu ena adi baka gina keke, te kpo da emere würüse te ele ayaka. Te di bala, yi mere e akpe cürü de, angü Me ladü, te ena areke wü ngü la ꞌburu, ba e te engu le. ");
INSERT INTO muh_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Amba nda-yi, yi ceka te-yi mbi, de yi rü kpekpeke, angü wü kpara füh kotö ne ꞌburu ena angbü ekpü yi akpü teka ngü ka-ra. Wüh ena azoro wü gara yi, ato fü wü miri, ato cïnga te ewü. Fü ewü amömörö kpah wü gara yi. ");
INSERT INTO muh_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gbü wü sïkpï engu la, mere bi wü kpara ka-ra ena ace ngü ka-ra. Gara ewü ena akpo da ekpü yi. Kpah bala, wü gara ena angbü da egü tamu yi fü wü vügü. ");
INSERT INTO muh_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mere bi wü mürü wu ena akoro teka afiti wü kpara ka Me, gü ba, ‘Ani de wü *mürü dofo ka Me.’ Fü mere bi wü kpara ale ngü ka-ewü. ");
INSERT INTO muh_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wü kpara ena akpo kpah angbü emere bi wü *siti ngü, gbü wü sü füh kotö ne ꞌburu. Teka ngü la, mere bi wü kpara ena ace ngü ka-ra. ");
INSERT INTO muh_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amba te mü tüka te-mü, alala gbü ngü ka-ra, akoro di gbü *adu sïkpï la, Me ena aküwa mü aküwa fï mere badi. ");
INSERT INTO muh_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amba ah le de yi mala ngari ra fü nguwa wü kpara füh kotö ne ꞌburu feke, de wüh fü maguma wü, o ra du koro la de.” ");
INSERT INTO muh_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Fü Yesu adu amala ngü fü ewü, teka *Mere Kambü ka Me, te wüh ena amürü la, gü ba, “Fanü fanü sirimbi ladü, te ena agü tamu sïkpï la fü yi. Angü gara vügü ka Me ladü, te ena akoro, asiti sü, da emere wü gara lara ngü kpa esa Mere Kambü ka Me la, gegege ba e te *mürü dofo de ïrï ye Danyele ba ta gügü gbü *Ngari Me ne.” Dela ngü te Yesu lügü fü wü kpara ka-ye, teka sirimbi, te ena akoro agü tamu sïkpï, te ewü ena amürü Mere Kambü ka Me agbü Yerüsalema tete na ne. De-mü, te mü ngbü etanga ngü ne, ah le fü mü ao fïngangü ka-mü, teka aje si-ngü la mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Fü Yesu adu amala ngü fü ewü, gü ba dene, “Te yi wu sirimbi la eyi la, yi mere e angbü gbü *Yudaya de! Yi kpe ꞌduwa kpa enzö mere gümba, agbü gü! ");
INSERT INTO muh_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kpah bala, te siti ngü la koro maka mü, te mü ngbü efe te-mü kpa esa e la, mü mere e adu arï kpa esambü, akö wü e ka-mü tïne de. Mü kpe ꞌduwa akpe, angü siti ngü la ena amaka mü. ");
INSERT INTO muh_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Te siti ngü la koro maka mü, da esö e ka-mü kpa gbü yï la, mü mere e adu kpa ekötï, ato züka bongo te mü kpah de. Mü kpe ꞌduwa akpe. ");
INSERT INTO muh_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Gbü wü sïkpï la, mere siti cïnga ena amere wü würüse, te ewü ena adi de bu wü, kpah bete mene ewü, de te ewü ena adi de wü vürü jaji eküte wü ne. Dela ne cïnga ne! Cïnga la ena afa wü gara cïnga füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ah le fü yi adi eku gba fü Me, teka de siti ngü la mere e akoro gbü *sïkpï ka Me de, angü wüh ena ani wü möngïtï ꞌbaranga ꞌburu ani. Anga ngü la mere e amere te-ye gbü bigü kpah de, angü agö bete zü ena amere yi esiti, te yi ena akpe la. ");
INSERT INTO muh_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kü baka te Me mere kotö ne, mere cïnga baka e la mere te-ye nda la de. Gara cïnga te ena akoro baka engu la fütanganga na, ah ena adi kpah ma. ");
INSERT INTO muh_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Fü Me adu afï nga wü kpara ka-ye, te engu fe ewü ne, gü ba, ‘Te di bala, ni ena akolo sïkpï la mba cogbo, teka ngü ka wü kpara ka-ni la, angü wüh ena akpi.’ Te Me ena amere ta bala de la, de bane kpara biringbö, te ena aküwa te gara, esaka siti ngü la, ena adi kpo ma.” ");
INSERT INTO muh_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye, gü ba, “Gbü wü sïkpï la, wü mürü wu ena akoro, adi efiti wü bu wü. Gara ena agü ba, ‘Ni de miri, te Me tima ni teka aküwa wü.’ Gara ena agü ba, ‘Ni nda-ni de *mürü dofo, te ni ngbü emala ngari Me fü wü kpara.’ Wüh ena akpo angbü emere bi wü ngü ka talara, te ena afiti wü kpara ꞌburu. Wüh ena agïrï kpah kaje teka afiti cu yi, wü kpara ka-ra. Te di bala, yi ceka te-yi ꞌbe, yi mere e aje ngü ka wu ka-ewü la nda-yi de! Te gara kpara mala ngü fü yi, gü ba, ‘Miri te Me tima ne koro eyi! Ah ladü kpakine,’ anga ‘Ah ladü kpane,’ yi mere e ale ngü kaka la nda-yi kpah de. ");
INSERT INTO muh_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yi ceka te-yi mbi, angü ma ngbü eyi emala ngü ne fü yi te enga gina dene, o ngü la koro la de, teka fü yi amba jia yi amba, angü wü mürü wu la ena afiti yi. ");
INSERT INTO muh_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Te di bala, te wüh mala fü yi, gü ba, ‘Yi ceka la! Miri te Me tima ne koro eyi! Engu ladü agbü gü kpala,’ yi mere e anü kpala nda-yi de. Kpah bala, te wüh gü ba, ‘Miri la wo te-ye eyi kpakine la,’ yi mere e ale ngü la nda-yi kpah de. ");
INSERT INTO muh_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kükürü de, angü dudu ka-ra, *Ye kpara ka Kpï, wü kpara gbü nga nzö sü füh kotö ne, ena aci awu ngü la te nga wü ꞌburu. Angü ah ena adi baka ülele te ngbü eü, da elofo sü. Dudu ka-ra ena adi bala, ah tï awo te-ye de! ");
INSERT INTO muh_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Angü wü kpara ꞌburu ena awu ngü la. Ah ena adi baka sü te kö nü di ladü tete, fü wü nügünü, de wü gara wü lu, abiti te-wü ꞌburu füh kö nü la. ");
INSERT INTO muh_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Fütanga ngü la, gara wü ngü ena ayia kpah amere te-wü kere, baka ngü ta te wüh ba gbü *Ngari Me, gü ba dene, ‘Wü lara ngü ena akpo da emere te-wü kpa gbü kpï. Angü kokpï, de wü e kpa tikpi ꞌburu, ena akpo da eyiki. Wü küfara ena akpo kpah da egügürü. Ra ena afü te-ye baka biti. Fe tï adu asü kpah de.’ ");
INSERT INTO muh_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Fütanga ngü la, de-ra Ye Kpara ka Kpï, fü ra adu tïne akoro. Wü kpara ꞌburu ena aci da eku gba ka cürü, angü wüh ena awu ra agbü kpï kpala, te ma ngbü ekoro de mere wazi, baka Mere Miri. Fü ewü aci ꞌburu acu ngü ra. ");
INSERT INTO muh_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kono ena awü, fü wü kpara aje ꞌburu. Fü ra ayia atima wü *malayïka ka-ra, teka abiti wü kpara ka-ra, te ma fe ewü ne. Wüh ena abiti ewü edebu wü sü bala ne ꞌburu, akoro di fere. Fü a angbü tundu de ewü fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Fü Yesu adu amala gara ngü fü ewü gbü mani, gü ba, “Ngü ka dudu ka-ra ena adi baka ngü ka wü rü. Angü te yi wu wü rü, te ngbü eyi ayi, da eto to kpa wü la, yi ngbü egü neh fe? Yi tï eyi awu, gü ba, bigü koro eyi. Ah bala de? ");
INSERT INTO muh_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kpah bala, te yi wu wü sirimbi, te ma mala nganga fü yi ne eyi la, de yi wu awu, gü ba, sïkpï ka dudu ka-ra la koro eyi gbamari. ");
INSERT INTO muh_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ma ngbü emala fü yi dene zu ngü. Siti cïnga la ena amaka yi fanü, amba ngü la tï anza ngü ka-yi, wü kpara ka-ra nda de. ");
INSERT INTO muh_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ngü te ma ngbü emala fü yi dene, ah de kpeke ngü, te ena angbü fï mere badi. Angü Me ena agara kotö ne ake kpï, fü ngü ka-ewü anza ꞌburu. Amba ngü ka-ra tï anza nda de.” ");
INSERT INTO muh_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Fü Yesu adu kpah, amala fü wü kpara ka-ye, gü ba, “Te yi le ayi-ta ra, gü ba, sïkpï, te ma ena adu akoro tete na, ena adi elaye la, ma ena alügü ngü fü yi, gü ba, sïkpï la, kpara biringbö, te wu ngü kaka, nda ma. Wü *malayïka agbü kpï, wüh wu kpah de. De-ra, te ma di de Ye Me ne, ma wu kpah de. ꞌDuwa Wüba Me wu ngü teka sïkpï la duu me-ye. ");
INSERT INTO muh_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Te di bala, ah le de yi reke te-yi ngbü nzo, angü sïkpï ka dudu ka-ra ena adi baka ngü, ta te mere te-ye gbü re ka mere kundu nih *Nüwa ne. ");
INSERT INTO muh_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Angü wü kpara ena angbü ezüfa wü e, da enzönzö wü fï ka-wü, kpah da eza te-wü, wüh tï afï ngü ka Me nda-wü kpah de. Ma ena adu akoro, agüka ewü gbü ngü ka-ewü la, kpah ba e ta te mere agö güka wü kpara gbü sïkpï, te Nüwa rï tete gbü *zabu, fü mere ngu la amörö ewü ꞌburu ne. ");
INSERT INTO muh_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ma ngbü emala fü yi dene zu ngü. Gbü sïkpï te ma ena adu akoro tete, te wü kpara ꞌbasu ngbü emere tima agbü yï la, ma ena aküwa mene kpara te le ngü ka-ra eyi. Fü ra ace mene kpara te le ngü ka-ra de ne. ");
INSERT INTO muh_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Te wü würüse ꞌbasu ngbü eyö zu ka-wü tundu gbü sü biringbö la, ma ena aküwa mene te le ngü ka-ra eyi. Fü ra ace kpah mene te le ngü ka-ra de ne. ");
INSERT INTO muh_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Te di bala, de yi reke te-yi, yi ngbü nzo, angü yi wu sïkpï, de te Miri ka-yi ena adu akoro tete na ne, nda-yi de. ");
INSERT INTO muh_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ah le de yi fï nga ngü la mbi mbi mbi. Angü te mürü kötï ena awu ta kpo, gü ba, ‘Mürü zi ena akoro gbü biti ne, teka azi wü e ka-ni la,’ de bane, ah tï ara nda de. Ah ena angbü ta ecï sü, teka afete mürü zi la, aliki, angü mürü zi la ena arï kpa esambü, azi wü e ka-ni. ");
INSERT INTO muh_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Teka ngü la, ma ngbü emala ngü ne fü yi kpekpeke, gü ba, ah le fü yi adi ecï sü, angbü kpah nzo, angü sïkpï ka-ra, *Ye Kpara ka Kpï, te ma ena adu akoro tete ne, yi wu nda-yi de.” ");
INSERT INTO muh_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Fü Yesu adu kpah amala gara mani fü ewü, gü ba, “Te mü ena adi de mere kpara ka tima gbü nzö wü bu mü la, ah le fü mü amere tima ka-mü mbi mbi mbi. Te mere kpara ka-mü yia nü agbü gara sü nengete la, ah le de mü mere wü ngü ꞌburu te engu ce, o esaka mü, da egafa zü-e fü wü bu mü, kpah ba e te engu mala fü mü ne, reke areke. ");
INSERT INTO muh_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Angü te mere kpara ka-mü du maka mü, da emere wü ngü la ꞌburu mbi mbi mbi la, ngü la ena ato mere tadu fü mü. ");
INSERT INTO muh_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma ngbü emala fü mü dene zu ngü. Mere kpara ka-mü ena ace wü ngü ka-ye ꞌburu esaka mü. Fü ah ao mü ba mere kpara, te ena angbü eceka kpï fütanga wü e ka-ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Anga te mü fï emaguma mü, gü ba, ‘Mere kpara ka-ni tï adu akoro kere nda de,’ ");
INSERT INTO muh_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","fü mü angbü ka-mü bü tündü, da emimiki wü bu mü, efï ka-mü bü nzö nga mü, fü mü angbü ka-mü bü da ezüfa wü e, da enzö wü fï, eküküya di la, ");
INSERT INTO muh_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","de-ra mere kpara ka-mü, ma ena adu akoro gbü sïkpï te mü wu de, fü ra amaka mü gbü ïrï-to. ");
INSERT INTO muh_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Te di bala, ma ena aza mü, ato esüka siti wü kpara, de wü mürü mani. Fü ra ato mere siti kuru te yi. Fü yi angbü da enyüma gbü te yi de ewü, de mere cïnga kpala!” ");
INSERT INTO muh_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Fütanga ngü la, fü Yesu adu kpah amala gara mani fü ewü, gü ba, “Sïkpï ka dudu ka-ra, *Ye Kpara ka Kpï, ena adi baka ngü te mere te-ye fü wü jaji würüse nzükpa, ta te ewü reke te-wü, ecï nga komoko, te le akoro aza kiri wü. Fü ewü ayia aza wü lamba ka-wü, asiya. Fü ewü ayia anü gbü biti la, kpa gba kiri wü, te komoko le aza ne. Fü ewü angbü kpala da ecï nga komoko la. ");
INSERT INTO muh_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Wü gara jaji würüse de ꞌburuve ne, wüh de kpeke wü kpara. Fü ewü aza kpah gara mü-wa ka-wü gbü kölökö, anü di mini. Amba wü gara ewü de ꞌburuve ne, wüh ka-wü de töndö wü kpara, wüh za gara mü-wa nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Amba komoko ne, mü koro nda-mü kere de. Teka ngü la, fü wü jaji würüse nzükpa ne, ayia andïrï, atï ꞌburu de ra. ");
INSERT INTO muh_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ah te enü akoro etü biti la, fü komoko la ayia akoro, agüka wü kpara ꞌburu agüka. Fü ewü ayia aje ri wü kpara da emï koko, de wü rere kpa tikpi, gü ba, ‘Wayi! Komoko te le akoro aza tangbase ka-ani ne, koro eyi! Wü za lamba ka-wü eza, de wü koro kere! Teka de ani nü, maka te-ani de ewü, kpa te kaje kpala!’ ");
INSERT INTO muh_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Fü wü jaji würüse de nzükpa ne ayia atïtï, azükü gbü ra, amaka wü lamba ka-wü ꞌburu nuuu! Fü ewü ayia sela, akpo da ee ku lamba ka-wü, amba mü-wa nza eyi! ");
INSERT INTO muh_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Fü mene töndö ewü de ꞌburuve ne, amala ngü fü wü bu wü, gü ba, ‘Akooo, wü di enga ni ani, wü le mba ta-ngü te ani de mü-wa, angü nda-ani nza eyi!’ ");
INSERT INTO muh_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Fü mene wü jaji würüse de ꞌburuve, te jia ewü mba amba ne, ayia alügü ngü fü wü bu wü la, gü ba, ‘Du mü-wa ka-ani mba cüküꞌdaye. Ah tï atï tüngü ani ꞌburu nda de. Wü kpe kere, wü se nda-wü.’ ");
INSERT INTO muh_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Fü töndö wü jaji würüse la akpe anü teka ase mü-wa. Fü watï ye kiri ewü ne ayia akoro fütanga ewü la. Fü wü mene kpeke ewü, te ewü di nzo ne, ayia anü, amaka te-wü de wü komoko la. Fü ewü ayia atï de lamba ka-wü engagira nü, anü de wü komoko la agba ka. Fü komoko la aza ewü, arï di kpa esambü, de te wüh reke teka karama la, ani mö nga wü gö gö gö! ");
INSERT INTO muh_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Fütanga ngü la mba cüküꞌdaye, fü mene töndö ewü ne adu akoro, arü emöngïtï, da eï ï, gü ba, ‘Mere kpara! Mere kpara! Ye ü möngïtï fü ani ke!’ ");
INSERT INTO muh_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Fü komoko la alügü ngü fü ewü, gü ba, ‘Wü neh wü da? Ni wu wü nda-ni de! Ni tï adu aü möngïtï ka-ni kpah de!’ ” ");
INSERT INTO muh_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Fü Yesu adu amala ngü fü wü kpara ka-ye kpekpeke, gü ba, “Yi ceka te-yi ꞌbe, de yi reke te-yi, ngbü nzo! Angü yi tï awu sïkpï, anga lö-ra, de te ma ena adu akoro tete na ne, nda-yi de.” ");
INSERT INTO muh_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Fütanga ngü la, fü Yesu adu kpah amala gara mani fü wü kpara ka-ye, gü ba, “Sïkpï ka dudu ka-ra, *Ye Kpara ka Kpï, ena adi kpah baka ngü, te mere te-ye fü wü kpara ka tima ka gara komoko, te yia nü nengete, agbü gara sü. Te komoko la yia enü tete, fü ah aï wü kpara ka tima ka-ye, ato jiase esaka ewü biri biri ꞌburu, de wüh mere tima di, teka fü jiase la aga. ");
INSERT INTO muh_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Fü engu ato jiase fü gina kpara baka kama ꞌburuve. Fü ah ato jiase fü eꞌbaꞌbasu kpara, baka kama ꞌbasu. Fü ah ato nda ebabata kpara, kama biri. Ah ngbü ye süka jiase la fü ewü bala, te nga wazi ewü gbü tima. Fü ah ayia anü sü ka-ye agbü gara sü. ");
INSERT INTO muh_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Fü mene kpara te maka jiase kama ꞌburuve ne, fü ah anü amere tima de jiase la. Fü ah ayia amaka gara fefeh na kpah kama ꞌburuve. ");
INSERT INTO muh_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Fü eꞌbaꞌbasu kpara, te maka nda-ye kama ꞌbasu ne, anü, amere kpah bala. Fü ah ayia amaka kpah gara fefeh na kama ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Fü kiri ewü, de te maka nda-ye jiase ngbee kama biri ne, ayia anü, ajï du, aza jiase, de te mere kpara to fefe la, ati gbügbü. ");
INSERT INTO muh_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Fü mere kpara ka-ewü la ayia ayiri kpala baaala. Fü engu alügü nga ye adu akoro agba ye. Fü ah ayia aï wü kpara ka tima ka-ye, teka aceka jiase ka-ye, de te engu to esaka ewü ne. ");
INSERT INTO muh_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Fü mene kpara, ta te maka jiase kama ꞌburuve ne, ayia akoro engagira mere kpara ka-ye la, agü ba, ‘Mere kpara deyï, ye to ta jiase fü ni kama ꞌburuve. Ye ceka la, tïtïne ni maka gara kpah eyi fefeh na, kama ꞌburuve. Te di bala, wü jiase ka-ye eyi ꞌburu kutu biri dene.’ ");
INSERT INTO muh_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Fü mere kpara kaka-na, angbü de tadu. Fü ah agbo nga ïïrï na, agü ba, ‘Wayi! Dela züka ngü! Ye de kpeke kpara! Ni to ta enga tima fü ye, ye mere eyi ꞌduwa reke areke. Te di bala, ni ena ace mere bi wü ngü ka-ni esaka ye, fü ni ao ye mere kpara gbü tima ka-ni. Ye koro ekoro, de ani ngbü te sü biringbö tundu ake ye, de mere tadu.’ ");
INSERT INTO muh_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Fütanga ngü la, fü eꞌbaꞌbasu kpara ayia kpah, akoro, agü ba, ‘Mere kpara, ye to ta jiase fü ni, kama ꞌbasu. Ye ceka la, tïtïne ni maka gara kpah eyi fefeh na, kama ꞌbasu. Te di bala, wü jiase ka-ye eyi ꞌburu kama bala dene.’ ");
INSERT INTO muh_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Fü mere kpara kaka angbü kpah de tadu. Fü ah agbo kpah nga ïïrï na, agü ba, ‘Wayi! Dela züka ngü! Ye kpah de kpeke kpara! Ni to ta enga tima fü ye, ye mere eyi ꞌduwa reke areke. Te di bala, ni ena ace mere bi wü ngü ka-ni esaka ye. Fü ni ao ye mere kpara gbü tima ka-ni. Ye koro ekoro, de ani ngbü te sü biringbö tundu ake ye, de mere tadu.’ ");
INSERT INTO muh_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Fü mene kpara, ta te nda-ka jiase di ngbee kama biri ne, adu akoro sidi nga wü bu ye la, amala fü mere kpara ka-ye la, gü ba, ‘Wayi, mere kpara, ye ceka la, jiase ka-ye ta te ye to fü ni ne, ah dene. Ni kpe cürü ye, angü ni wu eyi, gü ba, ye de kpeke kpara. Te ye ru e de la, ye ngbü ka-ye fï bü emaka e. Teka ngü la, fü ni aza jiase ka-ye la, awo gbü tö. Ah dene.’ ");
INSERT INTO muh_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Fü ngü la asiti te mere kpara kaka la. Fü ah amala ngü fefe, gü ba, ‘Ye de siti kpara! Ye kpah de mürü töndö! Te ye ena awu ta kpo, gü ba, ni de kpeke kpara, te ni ngbü emaka wü e gbü wazi ka-ni la, ye za ta jiase ka-ni la, ao kpaka wü kpara, te ewü ngbü eceka kpï fütanga jiase ne, de, neh teka ne? Baka te ni du ne, de bane ni ena amaka jiase ka-ni la, de gara na füh ye.’ ");
INSERT INTO muh_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Fü mere kpara la adu afü te-ye, amala ngü fü wü gara kpara ka tima ka-ye, gü ba, ‘Wü za jiase de kama biri la esasaka asidi, de wü to fü mene kpara, te nda-ka di kutu biri ne. ");
INSERT INTO muh_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Angü mene kpara te mere tima kpekpeke, fü ah amaka mere bi e, wüh ena aza kpah gara wü e, ato fefe. Amba mene kpara te mere tima mbi mbi de, mba enga e te di esasaka, wüh ena aza esasaka asidi. ");
INSERT INTO muh_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Amba teka ngü ka komoko ne, engu de töndö kpara! Wü za engu, wü gü agbü mbiri sü, de ah ngbü, ah ku gba, da enyüma gbü te ye de mere cïnga kpala.’ ” Dela ngü te Yesu mala teka wü kpara ka-ye, de wüh ngbü kpekpeke, da eo to wü, teka tima te ni to fü ewü ne, de wüh di emere de wazi wü ꞌburu, zalü koro gbü sïkpï, te ni ena adu akoro tete. ");
INSERT INTO muh_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Fü Yesu adu kpah amala gara ngü fü wü kpara ka-ye la, gü ba, “Gbü *adu sïkpï, de-ra, *Ye Kpara ka Kpï, ma ena adu akoro de mere wazi, de wü *malayïka ka-ra mini. Fü ra angbü füh kpökpö ka-ra, teka akolo lïya ka wü kpara füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Fü wü malayïka la abiti wü kpara füh kotö ne ꞌburu engagira ra. Fü ra adu aye süka ngü ka-ewü, baka e te kpara ngbü eye süka wü kambiliki ka-ye de wü meme. ");
INSERT INTO muh_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mene züka wü kpara, te ewü di ba wü kambiliki ne, ma ena aza ewü, ao gbü kokpa ka-ra. Amba mene siti ewü, te ewü di baka wü meme ne, ma ena ao ewü gbü kamisü ka-ra. ");
INSERT INTO muh_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Fü ra adu amala fü züka wü kpara, te ewü di gbü kokpa ka-ra ne, gü ba, ‘De-wü, wü de wü kpara te Wüba, Me, küwa wü eyi. Wü koro ekoro akine, de a ngbü de mere tadu gbü züka sü ka Me, ta te engu reke ce o fü wü gügü, o engu mere kotö ne la de ne. ");
INSERT INTO muh_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Angü wü ngbü ta ele ta-ngü te ra, o ra ngbü de wü füh kotö ne. Wü to ta e-mazü fere, o tala ngbü emere ra. Wü to ta ngu fere, o gümü ngu ngbü emere ra. Ma ngbü ta ekolo sü te kaje ba ganzi kpara, fü wü aza ra ngba tete agba wü. ");
INSERT INTO muh_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma ngbü ta ngïrïmu, fü wü ato bongo fere. Ta te ma ngbü eke tete, fü wü akoro ta aceka ra, ale ta-ngü te ra. Ta te ma ngbü agbü ku, fü wü akoro aceka ra, ale kpah ta-ngü te ra.’ ");
INSERT INTO muh_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Te züka wü kpara la ena aje ngü la bala, wüh ena alügü ngü fere, gü ba, ‘Apa! Mere kpara! Ngü la mere te-ye bala, neh elaye? Ani maka ye te tala ngbü emere ye, fü ani ato zü-e fü ye, neh elaye? Gümü ngu ngbü ta emere ye, fü ani ato ngu fü ye anzö, neh elaye? ");
INSERT INTO muh_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ye koro ta baka ganzi kpara, fü ani aza ye ngba tete agba ani, neh elaye? Ye ngbü ngïrïmu, fü ani ato bongo fü ye, neh elaye? ");
INSERT INTO muh_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ye ngbü ta eke, anga wüh zoro ta ye gbü ku, fü ani anü aceka ye, ale ta-ngü te-ye, dela neh elaye? Ani wu ngü la nda-ani de.’ ");
INSERT INTO muh_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ma ena alügü ngü fü ewü, gü ba, ‘Ma ngbü emala fü wü dene zu ngü. Wü ngü ta ꞌburu, te wü ngbü mere fü wü mürü cïnga de kpakine ne, wü ngbü mere dela ꞌburu fere. Angü wü mürü cïnga la de wü di enga wüna!’ ");
INSERT INTO muh_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Fütanga ngü la, ma ena adu afü te-ra, amala ngü fü siti wü kpara, de te ewü di gbü kamisü ka-ra ne, agü ba, ‘De-wü deyï, wü de siti wü kpara! Ma le ngü ka-wü de! Wü yia gbü jia ra sela asidi! Wüh ena aza wü, asö agbü mere wa, te wüh deke teka *Satana de wü kpara ka-ye. Wü ena angbü kpala fï mere badi! ");
INSERT INTO muh_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kükürü de, angü wü le ta-ngü te ra ta de. Tala ngbü ta emere ra, wü le ato zü-e fere de. Ma ngbü ta ekpi gümü ngu, wü le ato ngu fere kpah de. ");
INSERT INTO muh_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma koro ta agba wü baka ganzi kpara, wü le aza ra ngba gba wü de. Ma ngbü ta engbü ngïrïmu, wü le ato bongo fere de. Ma ngbü ta eke ake, wü le ale ta-ngü eküte ra kpah de. Wüh zoro ra ta, gü agbü ku, wü le anü aceka ra kpah de.’ ");
INSERT INTO muh_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Wüh ena alügü ngü fere, gü ba, ‘Apa! Mere kpara! Ngü la mere te-ye bala, neh elaye? Ani maka ta ye de tala te ye neh elaye? Ta te gümü ngu ngbü emere ye ne, ani wu ye nda-ani ta de. Ye ngbü ta enü te kaje, neh elaye? Ye ngbü ta ngïrïmu, anga eke ake, neh elaye? Wüh zoro ye gbü ku ta elaye, fü ani ace ta kpo da ele ta-ngü te ye ne?’ ");
INSERT INTO muh_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ma ena alügü ngü fü ewü, gü ba, ‘Ma ngbü emala fü wü dene zu ngü! Gbü wü sïkpï ta te wü ngbü engbü de wü bu wü kpa füh kotö kpakine ne, wü le adi ele ta-ngü te wü mürü cïnga de. Te di bala, wü ngü de te wü le amere fü wü bu wü de ne, wü ce dela da emere cu fere. Angü wü mürü cïnga la de wü di enga wüna!’ ");
INSERT INTO muh_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Teka ngü la, wüh ena aza siti wü kpara la, agü ewü agbü mere du ka wa, fï mere badi. Amba teka züka wü kpara ne, wüh ena aküwa ka-wü agbü sü ka Me fï mere badi.” Dela wü ngü te Yesu mala fü wü kpara ka-ye teka adu sïkpï, te engu ena adu akoro tete ba Mere Miri. ");
INSERT INTO muh_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Te Yesu rï wü kpara ka-ye de ngü la nza tete, fü engu adu amala gara ngü ka cïnga fü ewü, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yi wu eyi, gü ba, *Karama ka Pasïka ena atï fütanga sïkpï ꞌbasu? Gbü sïkpï ka karama la, wü vügü ka-ra ena azoro ra, *Ye Kpara ka Kpï, ato fü wü miri ka *Rüma, teka fü ewü abere ra, amörö füh *rü gbegbete.” ");
INSERT INTO muh_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gbü wü sïkpï la, baka te Yesu ngbü erï wü kpara ka-ye, fü mere kpara füh kpökpö ka wü mere *kovo, de ïrï ye Kayafa ne, ayia kpah aï wü angbe cögbörö kpara ka wü *Yïsarayele ꞌburu, abiti agba ye. ");
INSERT INTO muh_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Fü ewü akpo angbü egïrï kaje, te ani ena azoro Yesu tete gbü zi, amörö. ");
INSERT INTO muh_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wüh gü ba, “Ani ceka ꞌbe, angü mere bi wü kpara biti te-wü eyi gbü Yerüsalema sene, teka amere mere karama ka Pasïka ne. Te ani zoro Yesu gbü jia ewü la, wüh ena aci ꞌburu de gü eküte ani! Te di bala, ani gïrï kaje, de ani zoro engu gbü zi.” ");
INSERT INTO muh_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ta gbü wü sïkpï la, wü Yesu ngbü ta engbü ka-wü agbü Betanïya, agba gara komoko de ïrï ye Sïmüna, ta te di de *jiakö te ye ne. ");
INSERT INTO muh_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Fü gara würüse akoro amaka ewü, te ewü ngbü da ezü e kpala. Würüse la koro de züka *se-mü gbü enga kölökö, te ewü ngbü ese de mere bi jiase. Fü würüse la ayia atökö se-mü la ꞌburu gbü nzö Yesu. ");
INSERT INTO muh_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Te wü *kpara ka Yesu wu ngü te würüse la mere bala ne, fü ngü la asiti eküte ewü. Fü ewü angbü emala ngü esüka wü, gü ba, “Arape! Wüh ngbü esiti mere bi jiase de bala, neh kü teka ne? Ah za züka e la, etökö kötö bü kükürü kükürü bala! Dela züka ngü? ");
INSERT INTO muh_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ah le ta de wüh za züka se-mü la, cïnzï de mere bi jiase, teka ale ta-ngü di eküte wü mürü cïnga.” ");
INSERT INTO muh_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Amba Yesu wu fïngangü ka wü kpara ka-ye la eyi. Teka ngü la, fü ah ayia amala ngü fü ewü, gü ba, “Yi ngbü ekpülü würüse ne, teka ne? Yi ce engu ace! Ngü de te engu mere, te engu tökö se-mü di gbü nzö ra ne, ah de mere züka ngü gbü jia ra. ");
INSERT INTO muh_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Angü te yi le ale ta-ngü te wü mürü cïnga la, yi tï eyi amere ngü la gbü wü gara sïkpï, angü mere bi wü mürü cïnga ladü füh kotö ne. Amba nda-ra, du sïkpï ka-ra füh kotö ne mba cüküꞌdaye. ");
INSERT INTO muh_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Würüse ne tökö se-mü ne gbü nzö ra, baka e te wüh ngbü emoko se-mü eküte kövö. Kükürü de, angü sïkpï ka kpi ka-ra koro eyi gbamari. ");
INSERT INTO muh_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma ngbü emala fü yi dene zu ngü. Gbü wü sü ꞌburu, te wüh ena angbü emala ngari ra tete, fü wü kpara füh kotö ne, wüh ena angbü efï nga würüse ne, kpah da emala nga ngü de te engu mere ne.” ");
INSERT INTO muh_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Fütanga ngü la, fü *Yuda Keriyota, te di de biri kpara esüka wü *kpara ka Yesu nzükpa de füh ye ꞌbasu ne, ayia anü akoro kpaka wü mere *kovo ka wü Yïsarayele, ");
INSERT INTO muh_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","amala ngü fü ewü, gü ba, “Ni le eyi ato Yesu fü wü. Te di bala, wü ena ato fü ni neh ene?” Te wü mere kpara la je ngü la bala, fü ngü la areke te ewü. Fü ewü ayia ꞌduwa atanga jiase teke biri de füh ye nzükpa, ato fü Keriyota. ");
INSERT INTO muh_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Te di bala, ah kpo bü gbü lö-ra engu la, fü Keriyota akpo angbü egïrï kaje, te ni ena agü tamu Yesu tete fü wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Te sïkpï ka *Karama ka Pasïka koro tete na, fü wü *kpara ka Yesu ayia amala ngü fefe na, gü ba dene, “Mere kpara deyï, ani ena azü nda-ani karama ne, neh kaye? Ye mala emala fü ani, de ani nü teka areke sü engu na.” ");
INSERT INTO muh_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Fü Yesu alügü ngü fü ewü, gü ba, “Wü nü enü agbü Yerüsalema, kpa gba gara kpara kpala, de wü mala ngü fefe, gü ba, ‘Mere kpara ka-ani tima ani kpaka ye, amala ngü fü ye, de ye to sü fü ni, teka fü ani akoro, azü karama ka Pasïka de wü kpara ka-ni gbügbü, angü sïkpï ka-ni koro eyi gbamari.’ ” ");
INSERT INTO muh_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Fü wü kpara la ayia anü, amere wü ngü la kpah ꞌburu, baka te Yesu mala fü ewü ne. Fü ewü ayia areke zü-e ka Karama ka Pasïka la ꞌburu kpa gba komoko la. ");
INSERT INTO muh_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Etamurago la, fü wü Yesu ayia akoro, angbü kötö, akpo da ezü karama la de wü kpara ka-ye nzükpa de füh ye ꞌbasu ne. ");
INSERT INTO muh_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Te wüh ngbü ezü e la tete, fü Yesu ayia amala ngü fü ewü, gü ba, “Ma ngbü emala fü yi dene zu ngü. Gara kpara ladü esüka yi sene, te ena ato ra fü wü vügü.” ");
INSERT INTO muh_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Te wüh je ngü la bala, fü ngü la ato mere cïnga emaguma ewü. Fü ewü akpo da eyi-ta Yesu te nga wü biri biri, gü ba dene, “Mere kpara, ah de ni? Ni ena ato ye me-ni?” ");
INSERT INTO muh_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Fü Yesu alügü ngü fü ewü, gü ba, “Ah de mene kpara, te a ngbü ezü e ake di tundu gbü gada biringbö ne. Ah ena ato ra fü wü vügü me-ye. ");
INSERT INTO muh_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","De-ra, *Ye Kpara ka Kpï, ngü ka kpi ka-ra tï ka-ye kpini, de ngü ta te wüh ba gbü *Ngari Me ne. Amba mere cïnga ena adi fü mene kpara, te ena ato ra fü wü vügü ne, angü Me ena ato mere kuru tete. Ah reke ta pe, te wüh ena abï engu nda-wü de.” ");
INSERT INTO muh_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Te Yesu mala ngü la bala, fü *Yuda Keriyota, kpara te to Yesu fü wü vügü ne, adu ayi-ta Yesu, gü ba, “Mere kpara, ah ena adi de-ra?” Fü Yesu alügü ngü fefe, gü ba, “Ah ngbürü bala, mü mala eyi dela!” ");
INSERT INTO muh_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Fütanga ngü te Yesu mala la, fü ewü adu angbü fï da ezü e ka-wü. Baka te ewü du ngbü ezü e ka-wü la, fü Yesu ayia akpo da emere gara ngü. Fü ah ayia aza ambata, agbo nga ïrï Me tekaka na, akukuru tütü. Fü ah ayia agafa fü wü kpara ka-ye la, gü ba, “Dene küte ra. Yi za eza, de yi zü.” ");
INSERT INTO muh_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Fütanga ambata la, fü engu adu aza ndüꞌba de ngu *vinü gbü ye. Fü ah adu agbo nga ïrï Me fefeh na, ayia ato fü ewü, gü ba, “Yi za ngu vinü ne, yi nzö te nga yi ꞌburu, ");
INSERT INTO muh_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","angü ah de *ngüte ra. Yi nzö ba e, te yi ngbü enzö *ngüte de wü Me. Angü ngüte ra engu ne, ah ena atökö, teka areke ngü ezengba wü kpara de wü Me, teka fü Me aboro wü *siti ngü ka-ewü. ");
INSERT INTO muh_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngü te ma emala fü yi dene, ah de zu ngü. Akpo enatikine, ma tï anzö ngu vinü tïne kpo de, zalü akoro di gbü sïkpï te Me ena ao ra Mere Miri tete na.” ");
INSERT INTO muh_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Te wüh zü karama la nza tete, fü ewü ayia abï ci ka Me. Fü ewü ayia ace sü la, anü sü ka-wü agbü sü te ewü ngbü eï, gü ba, Getesemane, te di esangü da de ïrï ye Olïve ne. ");
INSERT INTO muh_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Fütanga ngü la, o wü Yesu ngbü enü tete agbü Getesemane, fü ah adu amala ngü fü wü kpara ka-ye, gü ba, “Enatikine, gbü biti ne, yi ena akpe abaya ꞌburu ka cürü, ace ra kpikpi ra, baka e ta te wüh ba gbü *Ngari Me, gü ba, ‘Wüh ena amörö kpara, de te ngbü eceka kpï fütanga wü kambiliki ne, fü wü kambiliki la adu abaya ka-wü ꞌburu.’ ");
INSERT INTO muh_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ngü ma! Te ma zükü gbü kpi eyi la, ma ena anü sü agbü *Galïlaya fi me-ra. Fü yi adu anü amaka ra kpala.” ");
INSERT INTO muh_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Fü Petero ayia amala ngü fü Yesu, gü ba, “Ni tï akpe nda-ni kü de! Ngü ma, te wü bu ni kpe ꞌburu la, ni tï ace nga ye nda-ni kü de.” ");
INSERT INTO muh_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu gü ba, “Öꞌöö, Petero enga wüna, mü mala ngbürü mbi ne, amba ngü te ma ngbü emala dene, ah de zu ngü. Enatikine, gbü biti ne, o moko-ngü mï koko la de, mü ena acere nga mü du bata, gü ba, ‘Ni wu ra de.’ ” ");
INSERT INTO muh_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Fü Petero adu kpah amala ngü la kpekpeke, gü ba, “Ma tï acere nga ra kü de! Ngü ma, te ah kpah bü de kpi la, nih ena akpi ake nih ma! Ma kpe cürü de!” Fü gara wü *kpara ka Yesu ayia amala kpah ꞌburu bala. ");
INSERT INTO muh_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Fütanga ngü la, fü wü Yesu anü akoro agbü Getesemane. Te wüh koro kpala, fü engu amala ngü fü wü kpara ka-ye, gü ba, “De-wü deyï, wü ngbü la sene. Ni ena anü nda-ni kpa edere sü, teka aku gba fü Me.” ");
INSERT INTO muh_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Fü engu aza bü nzö Petero ake *Yakobo bete *Yüwane, anü de ewü cüküꞌdaye kpa edere sü. Fü mere cïnga bete fïngangü akpo da emere Yesu, fü mamaguma akpo da egürü. ");
INSERT INTO muh_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Fü engu ayia amala ngü fü wü Petero, gü ba, “Maguma ra ngbü eyi egürü de mere cïnga efa sü, teka ngü ka kpi, te ma ena akpi ne. Te di bala, yi ngbü gbamari ede ra sene, fü nih adi ecï sü tundu de nih ma.” ");
INSERT INTO muh_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Fü Yesu ayia ace wü Petero, anü mba canza edere sü. Fü engu atï, abuka gbüra ye kötö, aku gba fü Me, agü ba, “Wüba, sïkpï ka-ra koro eyi dene! Te ah gbü jia mü mbi la, de mü za cïnga la eküte ra asidi. Amba ngü la, ma ce o eyi esaka mü. Ah le fü mü amere ba e te mü ngbü ele. Ah di ba e te ma le me-ra de.” ");
INSERT INTO muh_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Fü engu ayia adu kpaka wü Petero, amaka ewü ꞌburu da era ara. Fü ah amala ngü fü wü Petero, gü ba, “Ah mere baye? Yi tï angbü ezükü, fü nih acï sü de nih ma mba cüküꞌdaye, nda-yi de? ");
INSERT INTO muh_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ah le de yi di ecï sü, da eku gba fü Me, angü *Satana ena afiti yi! Wayi, ah fanü, maguma yi ngbü ele ngü ka-ra, amba wazi yi, te yi ena amere ngü la di, nda ma.” ");
INSERT INTO muh_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Fü Yesu ayia ace ewü, adu anü kpah kpa edere sü, aku gba fü Me, gü ba, “Wüba, te mü le aza cïnga la eküte ra asidi de la, de ah ngbü bala, de mü mere emere baka e te mü ngbü ele, angü ma ce ngü la eyi esaka mü!” ");
INSERT INTO muh_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Fü engu adu kpah amaka wü kpara ka-ye la, wüh tï ra ka-wü kpah eyi, angü ra zoro jia ewü eyi fa sü. ");
INSERT INTO muh_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Fü Yesu adu kpah ace ewü, anü teka aku ebabata gba fü Me, emala fï bü ngü biringbö, baka mene te enga gina ne. ");
INSERT INTO muh_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Fütanga ngü la, fü Yesu adu akoro kpaka wü kpara ka-ye de bata ne, amala ngü fü ewü, gü ba, “Yi la fï bü era ara, da efe te-yi? Ah ti eyi! Yi zükü ezükü! Yi yia eyia, nih nü, angü sïkpï ka-ra, *Ye Kpara ka Kpï, tï eyi enatikine! Tïtïne wüh te ekoro teka azoro ra, ato fü wü vügü. Yi ceka la! Kpara te ena agü tamu ra ne, ah eyi te ekoro de kpane!” ");
INSERT INTO muh_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Baka te Yesu ngbü la fï bü emala ngü la fü wü kpara ka-ye, fü *Yuda Keriyota, te di biri kpara esüka wü *kpara ka Yesu nzükpa de füh ye ꞌbasu ne, ayia akoro de mere bi wü kpara gbü nga ye, te wü angbe cögbörö *kovo tima ewü, azoro Yesu. Wüh koro ta de wü mere maguruma, bete wü ngbondo esaka wü. ");
INSERT INTO muh_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","49","Fü Keriyota akoro ꞌduwa afaka Yesu, da egü mandï fefe, gü ba dene, “Mere kpara, mü ladü!” Ah mere ngü la bala, kükürü de, angü ah mala ta fü ewü, gü ba, “Mene kpara te ni ena afaka, agü mandï fefe, dela eyi engu. De wü zoro engu azoro!” ");
INSERT INTO muh_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Fü Yesu alügü ngü fefe, gü ba, “Enga wüna, mene ngü, de te mü koro sene teka amere ne, de mü mere emere.” Fü wü kpara la ayia ꞌduwa, aka te-wü, azoro Yesu. ");
INSERT INTO muh_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Fü gara kpara, esüka wü kpara ka Yesu, ayia agbi mere maguruma ka-ye, ade güje gara kpara ka tima ka mere kpara füh kpökpö, akolo gbö! ");
INSERT INTO muh_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Fü Yesu amala ngü fü kpara ka-ye la, gü ba, “Mü ce ngü la ace! Mü lügü maguruma ka-mü kpa da ye! Angü mene kpara te ngbü egü gü de maguruma, wüh ena amörö engu kpah de maguruma. ");
INSERT INTO muh_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fïngangü ka-mü gü ba, ah le de ma mere gü? Te ma ena ale ta agü gü la, de bane ma ena ayi-ta Wüba, Me, de engu tima mere bi wü *malayïka fere, teka ale ta-ngü te ra. Mü wu bala de? ");
INSERT INTO muh_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amba te ma ena amere ngü la ta bala la, ngü ta te wü *mürü dofo ba gbü *Ngari Me, gü ba, ‘Ma ena azü cïnga bala ne,’ ngü la ena mere te-ye baye baye?” ");
INSERT INTO muh_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Fü Yesu adu afü te-ye amala ngü fü wü kpara, te ewü koro azoro ye ne, gü ba, “Ah mere neh baye, te yi koro de wü mere maguruma, bete wü ngbondo esaka yi ne? Ma de siti kpara? Ma ngbü ta engbü etambasü *Mere Kambü ka Me ka-yi, da erï wü kpara de ngü ka Me gbü wü sïkpï ꞌburu ne, yi wu bala de? Yi le ta azoro ra kpala de, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wayi, ngü ma! Yi tï eyi azoro ra. Angü wü ngü la ngbü emere te-ye bala, teka ngü ta te wü mürü dofo ba gbü Ngari Me, teka ra ne, de ah tï kpini.” Te wü kpara ka Yesu wu ngü la bala, fü ewü akpe ka-wü, abaya ꞌburu, ace Yesu bü kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Fü wü kpara, te ewü zoro Yesu ne, aza engu anü di kpa gba Kayafa, te di mere kpara füh kpökpö ka wü *Yïsarayele. Angü wü mere *kovo ka wü Yïsarayele biti te-wü eyi kpala, teka akolo ngü ka Yesu. ");
INSERT INTO muh_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amba Petero, mü ngbü fï bü efa nga wü Yesu mba kpa sidi gbü zi, zalü koro di etambasü ka mere kpara füh kpökpö la. Fü mü anü arï angbü kötö esüka wü kpara ka tima ka mere kpara la, teka awu ngü te wüh ena amere de Yesu. ");
INSERT INTO muh_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Fü wü angbe cögbörö kpara la abiti te-wü, akpo da egïrï mene wü kpara, te ena amala ngü eküte Yesu de wu, gü ba, “Engu mere *siti ngü eyi fanü,” teka de ani mörö engu tete na. ");
INSERT INTO muh_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wüh gïrï ngü la ma, wüh maka nda-wü de! Angü mere bi wü kpara, te ewü koro mala siti ngü eküte Yesu ne, ngü ka-ewü ka-ye ꞌburu kpikpi ye kpikpi ye, angü ah ka-ye ꞌburu de wu. Fü wü gara kpara ꞌbasu ayia arü, amala ngü eküte Yesu de wu, ");
INSERT INTO muh_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","gü ba, “Komoko ne mala ta siti ngü, gü ba, ‘Ni ena amürü Mere Kambü ka-ani, ka Me, te wü kundu ani jï ne, ꞌburu asidi, fü ni adu ajï alügü gbü sïkpï ngbee bata kükürü.’ ” ");
INSERT INTO muh_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Te mere kpara füh kpökpö la je ngü la bala, fü ah ayia arü tikpi, amala ngü fü Yesu, gü ba, “De-mü, mü je la bi wü ngü, te wü kpara ngbü emala eküte mü ne! Mü tï alügü ngü de?” ");
INSERT INTO muh_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Fü Yesu anga ka-ye tïïï, ah lügü ngü nda de. Fü mere kpara füh kpökpö la adu amala ngü fü Yesu, gü ba, “Ma ngbü ekïna mü te ïrï Me! Mü mala la zu ngü fü a! Mü ngbürü de Ye Me, te engu tima füh kotö ne, teka aküwa a?” ");
INSERT INTO muh_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Fü Yesu alügü ngü fefe, gü ba, “Ah ngbürü bala, mü mala eyi dela. Amba ngü te ma ngbü emala fü yi dene, ah de kpeke ngü. Te gara, yi ena awu ra, *Ye Kpara ka Kpï, te ma ena angbü gbü kokpa ka Me, baka Mere Miri! Fü ra adu kpah akoro sene, de mere wazi ka Me, baka agö te biti te-ye teka alï!” ");
INSERT INTO muh_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Te mere kpara füh kpökpö je ngü te Yesu mala la, fü ah ayia asörö bongo de eküte ye ne ꞌduwa traaa! Fü engu amala ngü, gü ba, “Apa! Komoko ne le afü te-ye ba Me! Yi wu eyi? Ngü nza eyi dela! Nih edu kpah agïrï kpara, te ena amala nga siti ngü kaka, neh teka ne? Ah mala siti ngü ka-ye tïne cu eyi de komö ye dela! ");
INSERT INTO muh_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yi ngbü efï nda-yi neh baye?” Fü wü kpara la ango te nga wü ꞌburu wooo, gü ba, “Engu de siti kpara! Wüh mörö engu amörö!” ");
INSERT INTO muh_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Fütanga ngü la, fü ewü ayia akpo da esü ngüsü gbügbüra na, da emï engu, kpah da ebebe engu. ");
INSERT INTO muh_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Fü ewü angbü emala ngü fefe, gü ba, “Te ye de Ye Me la, de ye gü la ïrï kpara, te ngbü emï ye ne, fü ani!” ");
INSERT INTO muh_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Baka te Petero ngbü ka-ye fï etambasü ka mere kpara la, fü gara jaji würüse, kpara ka tima ka mere kpara la, ayia akoro aceka jia Petero, ayi-tata na, gü ba, “Ye de neh da? Ye de süka wü kpara te ngbü endoro gbü nga Yesu ne de?” ");
INSERT INTO muh_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Fü cürü ayia arï te Petero. Fü ah ayia acere nga ye, gbü jia ewü gbere, gü ba, “Ngü te ye ngbü emala la, ni wu nda-ni de! Ye gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Fü Petero ayia ka-ye sela, anü angbü kpa emöngïtï ka ꞌbaranga. Fü gara jaji würüse ka mere kpara la adu kpah awu engu, anü amala nganga fü wü kpara, te ewü ngbü de sela ne, gü ba “Wü ceka la! Komoko la, ah ka-ye de *kpara ka Yesu!” ");
INSERT INTO muh_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Fü Petero adu kpah acere nga ye, gbere! Fü ah ayia akïna te-ye, gü ba, “Fanü fanü, ni wu kpara ka-wü la nda-ni kü de!” ");
INSERT INTO muh_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Fütanga ngü la mba cüküꞌdaye, fü wü gara kpara, de te ewü ngbü gbü ꞌbaranga la, akoro kpaka Petero, amala ngü fefe, gü ba, “Ye zu de kpara ka Yesu, angü ye kpah de kpara ka *Galïlaya. Ani tï eyi awu ngü la, teka ri ye.” ");
INSERT INTO muh_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Fü Petero ayia akïna te-ye kpo kpo kpo, gü ba, “Ma emala fü yi dene zu ngü te ïrï Me! Ma wu ngü ka komoko la nda-ra kü de! Ma su wu de!” Petero bü te emala ngü la bala, fü moko-ngü ayia amï koko. ");
INSERT INTO muh_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Fü Petero adu afï nga ri Yesu, de ta te engu mala fü ye, gü ba, “O moko-ngü mï koko la de, ye ena acere nga ye, du bata, gü ba, ‘Ni wu ni de,’ ne.” Fü Petero ayia akoro kpa etanü, akpo da eku gba, de mere cïnga emaguma ye ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bü gügü kpurutokokpï, fü wü mere *kovo ka wü Yïsarayele abiti te-wü, aro mö esüka wü, teka ngü ka Yesu, gü ba, “Ah le de wüh mörö engu asidi.” ");
INSERT INTO muh_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Fü ewü aza Yesu, anü de engu engagira Miri *Pïlatü, te mere miri ka wü *Rüma o engu gbü nzö wü kpara ka *Yudaya ne. Amba wüh i kpakpa na fï bü ai. ");
INSERT INTO muh_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Fü *Yuda Keriyota, kpara te to Yesu fü wü vügü ne, awu, gü ba, wüh kolo ngü ka Yesu eyi esiti, wüh za engu nü di eyi engagira Miri Pïlatü, teka amörö engu asidi. Fü mamaguma ayia akolo teka ngü la. Fü engu ayia aza jiase teke biri de füh ye nzükpa, te wüh to fü ye ne, anü di, alügü kpaka wü mere wü kovo la, ");
INSERT INTO muh_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","amala ngü fü ewü, gü ba, “Ma mere *siti ngü eyi! Ma to züka kpara eyi fü kpi!” Fü wü mere kpara la alügü ngü fü Keriyota, gü ba, “Ah de ngü ka-ani de! Ah de ngü ka-ye!” ");
INSERT INTO muh_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Fü Keriyota ayia aza jiase la, amoko esaka ye kötö, kpa esa *Mere Kambü ka Me la. Fü ah ayia anü agï te-ye, amörö. ");
INSERT INTO muh_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Fü wü mere kovo ka wü Yïsarayele ayia, aro jiase la. Fü ewü amala ngü, gü ba, “Jiase dela, ah de jiase ka ngüte kpara. Ani tï aza, ao gbü kombo, amere tima ka Me di de, angü rïrï ka-ani gü ba, jiase te wüh to teka ngüte kpara la, wüh tï amere tima ka Me di de.” ");
INSERT INTO muh_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Fü ewü adu amaka fïngangü, gü ba, “Ah le de ani za jiase la, anü ase sü di, teka fü ani angbü eti wü ganzi kpara gbügbü na.” Fü ewü anü, ase sü la esaka wü kpara, te ewü ngbü efo sila. Angü sü la, ah ta de sü te wüh ngbü ecö tö ka sila ka-wü tete. ");
INSERT INTO muh_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Si-ngü te wüh du gü ïrï sü la tete, gü ba, “Sü ka ngüte” ne, angü wüh se sü la de jiase, te wü kovo to fü Keriyota teka Yesu ne. ");
INSERT INTO muh_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ngü ka jiase te mere te-ye bala, ah baka ngü ta te *mürü dofo Yeremaya, ba ta gügü gbü *Ngari Me ne, gü ba, “Jiase de te wüh za teka ase sü ka kpara te ngbü efo sila ne, ah de jiase teke biri de füh ye nzükpa, te di baka jiase ta te wü di enga Yïsarayele ngbü ese labï di.” ");
INSERT INTO muh_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Te wüh koro de Yesu engagira Miri *Pïlatü, fü miri arü ayi-ta Yesu, gü ba dene, “De-mü, wüh gü ba, mü de Miri ka wü *Yïsarayele ne, ngü la fanü?” Yesu gü ba, “Ah bü de te mü mala la.” ");
INSERT INTO muh_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Fü wü mere *kovo ka wü Yïsarayele akpo da emala bi wü kpeke ngü eküte Yesu de wu. Amba Yesu lügü ngü fü ewü nda de. ");
INSERT INTO muh_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Fü Miri Pïlatü adu amala ngü fü Yesu, gü ba, “Bi wü ngü de te wü kpara ne ngbü emala eküte mü ne, mü je nda-mü de? Te mü nga bü tïïï de bane?” ");
INSERT INTO muh_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Fü Yesu anga ka-ye tïïï. Ah lügü ngü fefe na nda-ye kpah de. Fü ngü la aga gbü jia Miri Pïlatü ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ta gbü wü re la, gbü mere sïkpï ka *Pasïka ꞌburu, Miri Pïlatü ngbü ta ece kpa te gara kpara ka ku biringbö, baka e te wü di enga Yïsarayele ngbü ele. ");
INSERT INTO muh_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Amba gbü wü sïkpï la, gara kpara ta ladü agbü ku kpala, de ïrï ye Baraba, te wü kpara wu ngü kaka ꞌburu kpo, angü ah ngbü ta emere gü teka tö ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Fü mere bi wü kpara aci, abiti te-wü kpaka Miri Pïlatü, teka ayi-tata, de ah ce kpa te kpara biringbö ka ku fü ani. Amba Miri Pïlatü wu eyi, gü ba, maguma wü kovo la siti eküte Yesu eyi, fü ewü aza engu, akoro di engagira ni ne, de ni mörö engu asidi. Teka ngü la, fü Pïlatü angbü egïrï kaje, de ni küwa Yesu esaka ewü. Fü Pïlatü arü amala ngü fü mere bi wü kpara la, gü ba dene, “Wü le, de ni lügü fü wü neh da? Ni ena alügü Baraba? Anga ni ena ace kpa te Yesu, te wü ngbü eï engu, gü ba, *Kurisito ne?” ");
INSERT INTO muh_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","O Miri Pïlatü ngbü tete füh kpökpö teka akolo ngü ka Yesu, fü wara ka atima ngü fefe, gü ba, “Watï ni deyï, ye ceka ꞌbe! Ye mere e ato kpa ye eküte züka kpara la nda-ye de! Angü gbü biti ne, ni roto engu, fü ngü la ato mere cïnga fü ni.” ");
INSERT INTO muh_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gbü ngü la, fü wü mere *kovo ka wü Yïsarayele akpo da efiti mere bi wü kpara la, da emala ngü fü ewü, teka de wüh yi-ta miri, de ah ce kpa ye te Baraba, de ah mörö Yesu asidi. ");
INSERT INTO muh_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Te di bala, fü Miri Pïlatü ayi-ta ewü, gü ba, “Wü le de ni ce neh kpa te da?” Wüh gü ba, “Ani le nda-ani Baraba!” ");
INSERT INTO muh_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Fü Miri Pïlatü adu ayi-ta wü kpara la, gü ba, “Amba Yesu, te yi ngbü eï engu, gü ba, ah de Miri ka wü Yïsarayele ne, yi le de ma mere de engu baye?” Fü wü kpara la aci ꞌburu, alügü ngü de mere ri wü kpa tikpi, gü ba dene, “Wüh mörö engu amörö! Wüh bere engu eküte *rü gbegbete!” ");
INSERT INTO muh_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Fü Miri Pïlatü adu ayi-ta ewü, gü ba, “Wü le de ni mörö engu, neh teka ne? Ah mere ne siti ngü ne?” Fü wü kpara la adu akpo da eba rere, afa engu tïne ne di ka, gü ba dene, “Wüh mörö engu amörö! Wüh bere engu eküte rü gbegbete!” ");
INSERT INTO muh_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Te Miri Pïlatü wu, gü ba, ni tï amere gara ngü tïne de, angü mere bi wü kpara la zoro fï bü ngü la gömö wü kpekpeke ne, fü engu ayia aza ngu, azürü kpa ye di, gbü jia wü kpara la ꞌburu. Fü ah adu amala ngü fü ewü, gü ba, “Ngüte Yesu, mere e angbü gbü nzö ni de! Angü ah de ngü ka-wü, te wü le eyi amere bala!” ");
INSERT INTO muh_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Te wü kpara la je ngü la bala, fü ewü aci ꞌburu, amala ngü, gü ba, “Ah le de ngüte komoko la ngbü gbü nzö a, de wü kundu a, fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Fü Miri Pïlatü ayia ace kpa te Baraba, alügü fü ewü, ba e te ewü le. Fü ah adu amala ngü fü wü marajümïya, de wüh süma Yesu de juru. Fü ewü asüma Yesu de ka. Fü Miri Pïlatü adu aza Yesu, ato fü wü marajümïya ka-ye, de wüh nü, wüh bere engu eküte rü gbegbete. ");
INSERT INTO muh_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Fütanga ngü la, fü wü marajümïya ayia aza Yesu, anü di agbü ꞌbaranga, gbü sü ka Miri Pïlatü, te wüh ngbü eï, gü ba, Peretorïyama ne. Fü ewü adu aï wü bu wü ꞌburu, abiti ede Yesu. ");
INSERT INTO muh_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Fü ewü akpo da emü Yesu, gü ba, “Baka te engu di de mere miri ne, ah le de ani cu ngüngü na.” Fü ewü ayia agbi bongo ka Yesu ꞌburu asidi, adu aza diri ngboro bongo ka-ewü, nzenze baka nda miri la, ato eküküte. ");
INSERT INTO muh_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Fü ewü agara bïbï gbü ti, ato gbü nzö Yesu, baka *madudu ka wü miri. Fü ewü ade e baka gbaraka, ato esasaka baka ngbangba ka miri. Fü ewü akpo angbü ebu nzökuta wü kötö, ba wü kpara te ewü ngbü ecu ngü miri la, gü ba, “Wayi! Mandï fü ye, mere miri ka wü *Yïsarayele!” ");
INSERT INTO muh_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Fü ewü angbü esü ngüsü gbügbüra na, adu aza ngbangba esasaka la, akpo da emï nzönzö na di. ");
INSERT INTO muh_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Te wü marajümïya la fala Yesu nza tete, fü ewü adu agbi nze bongo ka-wü la eküküte asidi, adu ato bongo kaka-na, alügü tete. Fü ewü aza engu, anü di teka abere füh rü gbegbete. ");
INSERT INTO muh_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Te wü marajümïya za Yesu tete, teka anü amörö ne, fü ewü anü amaka te-wü de wü gara komoko de ïrï ye Sïmüna, te di de kpara ka Kurene. Fü wü marajümïya azoro engu, ato esa *rü gbegbete, te ewü ena abere Yesu fefeh na ne, angü Yesu ngbü ta enü, da etï, da etï, teka tiri rü la. ");
INSERT INTO muh_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Fü Sïmüna abï mere rü la, anü zalü akoro di agbü Gologota, sü te ewü ena amörö Yesu tete na la. Gologota la, ah baka e te wüh gü ba, “Sü ka biki-nzö,” angü ah de sü te wüh ngbü emörö siti wü kpara tete. ");
INSERT INTO muh_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fü wü gara kpara awu cïnga Yesu. Fü ewü aza ngu *vinü, te wüh mere de rü gbü ye, süsü bala, ato fü Yesu, de ah nzö. Amba, te Yesu re vinü la, ah le anzö nda de. ");
INSERT INTO muh_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Fü wü marajümïya la aza Yesu, agbi bongo kaka-na asidi, aza engu, abere eküte rü gbegbete, gö gö gö! adu ae rü gbegbete la tikpi. Fü ewü aza bongo ka Yesu, akpo da esö gümare teka wü bongo kaka la. ");
INSERT INTO muh_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","38","Fü ewü aza ngü te wüh ba teka Yesu, abere eküte rü gbegbete la, to tikpi, te gü ba, “Dene Yesu, Mere Miri ka wü *Yïsarayele.” Fü ewü ayia aza wü mürü zi ꞌbasu, abere ewü eküte wü rü gbegbete ka-ewü ede nda Yesu, gara gbü kokpa, gara gbü kamisü. Fütanga ngü la, fü ewü adu angbü kötö, da efete Yesu, angü wü kpara kaka ena akoro aküwa engu. ");
INSERT INTO muh_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Fü wü gara kpara, te ewü ngbü enü te kaje la, awu Yesu. Fü ewü angbü egü nzö wü de tadu, da esoko engu, ");
INSERT INTO muh_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gü ba dene, “Ata! De-ye deyï, ye gü ta, ga, ‘Ni de mere mürü wazi. Ni tï eyi amürü *Mere Kambü ka Me, adu afa gara gbü sïkpï ngbee bata!’ Te ye de Ye Me fanü fanü la, de ye küwa te-ye, ye kö kötö!” ");
INSERT INTO muh_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Wü mere *kovo ka wü Yïsarayele ngbü ta kpah efala engu, gü ba, ");
INSERT INTO muh_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Komoko la ngbü ta eküwa wü gara kpara. Ah mere neh baye, te engu tï aküwa te-ye de ne? Te engu ena adi ta de Mere Miri, te Me tima fü ani fanü la, ah le ta de engu küwa te-ye, kö kötö, teka fü ani awu mere wazi kaka, adu ale ngü kaka. ");
INSERT INTO muh_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Angü ah ngbü ta emala ngü, gü ba, ‘Ni de Ye Me, Me ena aküwa ni.’ Te ah bala la, ah mbi! Ani ena awu ngü la. Te Me ngbü ele ngü kaka fanü la, de ah küwa engu!” ");
INSERT INTO muh_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Fü wü mürü zi de ꞌbasu, ta te wüh bere edede na ne, angbü kpah esoko engu bala. ");
INSERT INTO muh_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Fütanga ngü la, ah te enü akoro etü ra, fü sü ayia atï ꞌduwa mbirrri, baka biti la. Fü e la ayiri bala, zalü akoro gbü lö-ra bata ka tamurago. ");
INSERT INTO muh_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gbü lö-ra engu la, fü Yesu ayia aku gba de mere ri ye kpa tikpi, gü ba dene, “Eli, Eli, lama sabakatanï?” Ah baka e te wüh gü ba dene, “Me, Mere Miri ka-ra, mü ce ra kpikpi ra, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wü gara kpara, ta te wüh rü gbü sü la, wüh je ngü, te Yesu mala la, mbi mbi nda-wü de. Fü gara ewü afï, gü ba dene, “Ah ngbü dela neh eï *Ïlïya, de ah koro, ah küwa ni?” ");
INSERT INTO muh_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Fü biri kpara esüka ewü, ayia bü kere de woro, anü aza e ba lïfa, föꞌdö föꞌdö bala, agü gbü fï, ato te nzö e baka gbaraka la, ae, ato te komö Yesu, de ah ꞌbü. ");
INSERT INTO muh_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Fü gara ewü amala ngü fefe, gü ba, “Ye ce la engu ace, ani ceka la. E-wu neh da, anga Ïlïya ena akoro aküwa engu ya?” ");
INSERT INTO muh_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Fütanga ngü la, fü Yesu adu kpah, aku gba de mere ri ye kpa tikpi. Fü ah ayia ace maguma ye, akpi. ");
INSERT INTO muh_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Gbü lö-ra te Yesu kpi tete na la, fü mere bongo, ta te wüh i, kolo tü *Mere Kambü ka Me agbü Yerüsalema di, baka ngisi ne, ayia asörö tü ye de tete-ye mbaaa, kü kpa tikpi, ngbüüü kötö! Fü tö ayia ayiki te-ye, fü wü da angbengbe te-wü. Fü ngü la angbü gbü jia wü kpara ba sirimbi. ");
INSERT INTO muh_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Fü wü mbükü ayia aü te-wü. Fü mere bi wü kpara ka Me, ta te ewü kpi ne, fü Me azükü ewü ꞌburu gbü kpi la. ");
INSERT INTO muh_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Fütanga ngü te Yesu zükü tete gbü kpi ne, fü wü kpara ka Me, te wüh zükü la, akoro anü arï ꞌburu agbü Yerüsalema. Fü mere bi wü kpara awu ewü cu de jia wü. Dela ta ngü te Yesu kpi tete na. ");
INSERT INTO muh_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mere kpara ka wü marajümïya, de wü marajümïya ka-ye, te ewü ngbü efete Yesu ne, fü ewü awu yiki-tö, bete ra te ünü teka lö-ra bata ne, fü wü ngü la angbü gbü jia ewü baka sirimbi. Fü ewü akpe cürü ka ngü la, gü ba, “Apa! Te ah bala la, komoko ne, ah ka-ye de Ye Me fanü fanü!” ");
INSERT INTO muh_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Bi wü würüse, ta te ewü ngbü efa nga Yesu ne, kpah ladü gbü sü te Yesu kpi tete na la. Wüh de wü *Marïya Egba-Magadala, bete *Marïya ni ye Yakobo ake Yüsa, bete wara Zebedayo, te di de ni ye wü *Yüwane ake *Yakobo, kpah de mere bi wü bu wü, ta te ewü nü koro agbü Yerüsalema de wü Yesu ne. Angü te wü Yesu ngbü ta la da endoro agbü *Galïlaya ne, wü würüse la ngbü ta efa nganga na, da ele ta-ngü tete. Gbü lö-ra te Yesu kpi tete na, wü würüse la ngbü nda-wü kpala, mba canza edere sü, da eceka kpï. Fü ewü awu ngü ka kpi kaka-na la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Gara *kpara ka Yesu ta ladü gbü sü la, de ïrï ye *Yüsefa, kpara ka Arïmatayo, te di de mere bi wü e esaka ye. ");
INSERT INTO muh_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Te Yesu kpi tete, fü engu anü kpaka Miri *Pïlatü etamurago la, andaꞌba te-ye fefe na, gü ba dene, “Mere kpara, ni le ayi-ta ye de gara ngü biringbö. Te ah tï gbü jia ye la, ni ele de ye to kö Yesu fü ni, ni ti.” Fü Miri Pïlatü ayia ale de wüh to kö Yesu fefe, de ah nü di, ah ti. ");
INSERT INTO muh_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Fü wü Yüsefa ayia anü, aza kö Yesu eküte rü gbegbete asidi, anü di, agaga de züka bu bongo, te engu se toto. ");
INSERT INTO muh_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Fü ewü aza kö Yesu, anü di, ati gbü to mbükü, ta te engu jï fü ye gbü da, angü gele ka wü *Yïsarayele ta bala. Fü ewü awara gara mere siti ngbürükü da, ao emö mbükü la, ani di. Fü ewü adu anü sü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Fü *Marïya Egba-Magadala ake kiri ye, *Marïya ni ye wü Yüsa ne, fü ewü angbü ka-wü mba canza kötö, da eceka kpï mbiii to kpaka mbükü la. Fü ewü awu sü te ewü ti Yesu tete na ne. Dela ngü ta te wüh ti Yesu tete na. ");
INSERT INTO muh_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Baka egambi la, te di de *sïkpï ka Me ka wü *Yïsarayele ne, fü wü *mere kovo ka wü Yïsarayele, de wü *Farusi ayia abiti te-wü ꞌburu, anü akoro kpaka Miri *Pïlatü. ");
INSERT INTO muh_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Fü ewü amala ngü fefe, gü ba, “Mere kpara, ani ngbü efï nga gara ngü, ta te mürü wu la ngbü emala, o engu di ta la ladü de jia ye ne. Angü ah ngbü ta emala, gü ba, ‘Te ni ena kpi la, gbü *ebabata sïkpï, ni ena adu azükü.’ ");
INSERT INTO muh_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Te di bala, ani ngbü efï, gü ba, ah ena adi mbi, te ye ena atima wü marajümïya, teka anü aceka kpï fütanga mbümbükü la mbi mbi mbi, zalü akoro di gbü ebabata sïkpï la. Angü wü kpara kaka-na ena adu akoro, azi kökö na, atafa di. Fü ewü adu afü ngü, angbü esu wu fü wü kpara, gü ba, ‘Yesu, mere kpara ka-ani, zükü ka-ye eyi gbü kpi!’ Te di bala, mene wu, de te wüh ena adu asu sidi ne, ah ena afa gigina na ne tïne ka!” ");
INSERT INTO muh_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Fü Miri Pïlatü alügü ngü fü ewü, agü ba, “Wayi, ah mbi, yi za wü marajümïya la, yi nü de ewü o kpala, teka de wüh ceka kpï fütanga mbümbükü la. De yi mere ngü la ba e te yi le.” ");
INSERT INTO muh_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Fü wü mere kpara la ayia de wü marajümïya la, anü kpa füh mbükü Yesu, adete dere mbükü la gö gö gö! Fü ewü amala ngü fü wü marajümïya la, de wüh ngbü kpala, adi efete mö mbükü la kpekpeke, angü wüh ena azi kö Yesu. ");
INSERT INTO muh_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gügü kpurutokokpï, gbü sïkpï ka biri ka wü *Yïsarayele, te di de sïkpï ka Me ka-nih ne, fü *Marïya Egba-Magadala ayia ake gara kiri ye, *Marïya ne, anü teka aceka mbükü Yesu. ");
INSERT INTO muh_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","4","Baka te wü würüse la yia ngbü enü tete, fü yiki-tö ayia amere te-ye kpa füh mbükü Yesu kpala. Fü wü marajümïya, ta te ewü ngbü eceka kpï fütanga mbükü Yesu ne, ayia awu *malayïka ka Me. Fü ewü akpo angbü eyï ayï de mere cürü. Fü ewü atïtï ꞌburu kötö, angbü baka wü kövö la. Fü malayïka la ayia anzi mere da de emö mbükü la asidi. Te wü würüse la nü koro kpa füh mbükü kpala, fü ewü aceka kpï bane, gbo! te malayïka ka Me, te ngbü ka-ye ga füh mere da, ta te wüh o emö mbükü ne! Gbügbüra na ngbü eci aci lelele bala! Bongo kaka vi kpah avi kpïlïlï! ");
INSERT INTO muh_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Fü malayïka la arü amala ngü fü wü würüse la, gü ba, “Yi kpe cürü de! Ma wu eyi, gü ba, yi ngbü egïrï Yesu, ta te wüh bere engu füh rü gbegbete ne. ");
INSERT INTO muh_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Engu sene nda ma, angü ah zükü ka-ye gbü kpi eyi, baka ta te engu mala fü yi ne. Yi ceka la sanga, ta te ewü o kökö gbügbü na ne. Ah eyi kükürü! ");
INSERT INTO muh_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Te di bala, yi nü enü kere kere, yi mala nganga na fü wü kpara kaka, gü ba dene, ‘Yesu zükü eyi! Ah tafa ka-ye eyi kpa engagira nü agbü *Galïlaya. Wü nü enü, wü ena amaka engu kpala!’ Dela ngü te ma le amala fü yi, ah dela.” ");
INSERT INTO muh_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Te wü würüse la je ngü gömö malayïka bala, fü ewü ayia kpa füh mbükü la ꞌduwa kere, de mere cürü te wü, kpah de mere tadu emaguma wü teka ngü la. Fü ewü anü de woro, teka amala nga ngü la fü du wü *kpara ka Yesu la. ");
INSERT INTO muh_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","O wüh ngbü la bü enü tete, fü ewü aceka kpï, gbo! te Yesu, te rü te kaje. Fü ah agü mandï fü ewü, gü ba, “Me di de yi!” Fü wü würüse la akoro kpakaka na, atï, abu nzökuta wü kötö, azoro lölö na, da ecu ngüngü na. ");
INSERT INTO muh_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Fü Yesu amala ngü fü ewü, gü ba. “Yi kpe cürü de! Yi nü enü, yi mala fü wü di enga wüna, de wüh nü agbü Galïlaya, angü wüh ena amaka ra kpala.” Fü wü würüse la ayia anü amala ngü la, ba e te Yesu mala fü ewü la. ");
INSERT INTO muh_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amba, o wü würüse la nü koro kpa füh mbükü Yesu la de, fü wü marajümïya, ta te ewü ngbü eceka kpï fütanga mbükü Yesu ne, fü wazi ewü ayia adu akoro. Fü ewü ayia sela ꞌduwa, anü akoro agbü Yerüsalema, amala nga wü ngü, de te ngbü mere te-ye kpa füh mbükü Yesu ne, ꞌburu fü wü mere *kovo ka wü Yïsarayele, gü ba dene, “O ani ngbü efete mbükü, fü yiki-tö ayia amere te-ye. Fü *malayïka ka Me akoro, anzi mere da de emö mbükü la asidi. Tïtïne kö Yesu gbü mbükü la nda ma!” ");
INSERT INTO muh_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Fü wü mere kovo la ayia aï wü gara wü bu wü, abiti, teka aro mö de ewü, agïrï mani, te ani ena amere teka ngü la. Fü ewü afï nga gara mani, amaka. Fü ewü ayia aza mere bi jiase, ato fü wü marajümïya la, ");
INSERT INTO muh_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","amala ngü fü ewü kpekpeke, gü ba, “Ah le fü yi amala ngü la fü wü kpara, gü ba, ‘Wü *kpara ka Yesu koro gbü biti ne, o ani ngbü era ara, azi kökö na, anü sü di.’ ");
INSERT INTO muh_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Te di bala, yi mere e akpe cürü de. Angü a wu eyi, gü ba, te Miri *Pïlatü je, gü ba, wüh zi kö Yesu eyi, o yi ngbü era ara la, ah ena azïnga, fü ah ato kuru te yi. Amba, ngü ma, a ena anü, agu mamaguma me-a.” ");
INSERT INTO muh_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Fü wü marajümïya la aje rïrï ka wü mere kovo la, aza jiase la. Fü ewü akpo da esu wu la fü wü kpara, gü ba, “Wü kpara ka Yesu koro zi kö Yesu eyi.” Fü ngü la awü, abaya esüka wü di enga *Yïsarayele ꞌburu, zalü akoro di enatikine dene. ");
INSERT INTO muh_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Fütanga ngü la, fü du wü *kpara ka Yesu, nzükpa de füh ye biri ne, ayia anü agbü *Galïlaya. Fü ewü anü alï kpa füh gümba, ta te Yesu mala nganga na fü ewü ne. ");
INSERT INTO muh_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Fü ewü akoro amaka Yesu kpala. Baka te ewü wu Yesu, fü ngü la aga gbü jia ewü afa sü. Fü ewü abu nzökuta wü kötö, agbo nga ïïrï na. Amba maguma gara ewü fï bü ꞌbasu ꞌbasu, angü ngü la ngbü gbü jia ewü baka sirimbi. ");
INSERT INTO muh_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Gbü gara sïkpï, fü Yesu akoro kpah, amala ngü fü ewü, gü ba, “Wüba Me to mere wazi eyi fere, mene wazi agbü kpï, de mene füh kotö ne ꞌburu esaka ra. ");
INSERT INTO muh_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Te di bala, yi baya, yi nü te nga sü füh kotö ne ꞌburu, de yi mala ngari ra fü nguwa wü kpara ꞌburu nde. Te wüh le ngü ka-ra eyi la, de yi to *babatïza fü ewü te ïrï Wüba Me, de ïrï ra Ye Me, kpah de ïrï *Nzïla Wazi Me. ");
INSERT INTO muh_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yi mala nga wü rïrï, ta te ma mala fü yi ne, ꞌburu fü ewü, de wüh di emere kpah bala. Ah le fü yi awu awu, gü ba, gbü wü sïkpï ꞌburu, ma ena angbü de wü yi tundu, zalü akoro di gbü *adu sïkpï, te ma ena adu akoro tete füh kotö ne.” Dela ngü ta te Miri Yesu mala fü wü kpara ka-ye, te engu zükü tete gbü kpi.");
INSERT INTO muh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dene züka tofo ngü ka Me teka Yesu *Kurisito, te di de Ye Me. ");
INSERT INTO muh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ngü la kpo ba e ta te wü Yïsaya, ba gbü *Ngari Me ta gügü, o wü bï Yesu la de, gü ba, “Me mala ngü fü Ye ye, gü ba, ‘Ni ena atima mürü tima ka-ni kpa engagira nü, teka areke kaje fü ye.’ ” ");
INSERT INTO muh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","*Mürü dofo Yïsaya gü ba, “Gara kpara ena akoro, angbü emala ngü de mere ri ye kpa etü gü, gü ba dene, ‘Mere Miri, te ena aküwa ani ne, ah te ekoro! Ah le de wü reke kaje fefe! Wü ni wü cudu, wü o kpini, teka fü engu anü tete na.’ ” ");
INSERT INTO muh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mürü tima engu la, ah de *Yüwane Mürü Babatïza. Fü engu akoro fütanga mere bi wü re, angbü kpa etü gü, da emala ngari Me fü wü kpara kpala. Fü mere bi wü kpara angbü ekoro kpakaka na, adi eje ngari Me gögömö na. Fü ah angbü emala ngü fü ewü, gü ba dene, “Wü ce *siti ngü ka-wü ꞌburu asidi, wü fü maguma wü, teka fü wü aza *babatïza, fü Me aboro siti ngü ka-wü ꞌburu.” Dela ngü ta te Yüwane mala fü wü kpara la, te engu ngbü eto babatïza fü ewü. ");
INSERT INTO muh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Fü mere bi wü kpara ayia anü kpakaka na, teka aje ngari Me gögömö na. Wü gara ewü koro agbü Yerüsalema, de wü gara nga nzö kötï ka *Yudaya ꞌburu. Te wü kpara la je ngü ka Me gömö Yüwane de bala, fü maguma ewü ayia agürü. Fü ewü akpo da emala nga wü siti ngü ka-wü fü Me de cïnga. Fü Yüwane angbü eto babatïza fü ewü gbü ngu Yürüdene. ");
INSERT INTO muh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yüwane ngbü ta eto bongo ka-ye te ewü gbï gbü su nü de ïrï ye kamele, sisiti gbulukusu bane. Fü ah ngbü ei ku konü etadu ye. Zü-e kaka-na ta nda bü mbïra te di baka eci, bete wü, te engu ngbü emaka agbü gü la. ");
INSERT INTO muh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Fü Yüwane amala ngü ka Me fü wü kpara, gü ba dene, “Me tima gara kpara eyi, te ena akoro arï yi sidi nga ra, wawazi na fa nda-ra ka. Ma nda-ra bü baka labï kaka, te ena areke kaje fefe. Ma be teka tima la nda-ra de, angü engu me-ye de mere kpara fere. ");
INSERT INTO muh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nda-ra, ma ngbü eto babatïza fü yi de ngu kükürü. Amba nda-ka, ah ena ato babatïza fü yi de wazi ka *Nzïla Wazi Me, teka fü yi angbü emere ngü ka Me ereke areke.” ");
INSERT INTO muh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Baka ta te Yüwane ngbü emala ngari Me kpa etü gü ne, Yesu ngbü ka-ye gbü gara kötï de ïrï ye Nazareta. Gbü gara ra, fü Yesu ayia anü kpaka Yüwane kpa etü gü la. Fü Yüwane ayia ato *babatïza fefe gbü ngu Yürüdene. ");
INSERT INTO muh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te engu to babatïza nza tete, fü Yesu ayia akoro kpa füh gümba. Ah te eceka kpï de, gbo! te kpï te ü te-ye. Fü *Nzïla Wazi Me akoro kpa gbü kpï baka mö, arü gbü nzö Yesu. ");
INSERT INTO muh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Fü ri Me awü kpa gbü kpï la, gü ba dene, “Mü zu de Ye ra, te maguma ra ngbü tete. Ngü ka-mü reke gbü jia ra ꞌduwa ba-neh-ene-la.” ");
INSERT INTO muh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Fütanga ngü la, fü Nzïla Wazi Me aza Yesu, anü di kpa etü gü, ");
INSERT INTO muh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","kpa gbü sü ka siti wü nü. Fü ah ara kpala sïkpï teke ꞌbasu. Fü *Satana akoro afiti Yesu kpala ma. Fü wü *malayïka ka Me angbü ta ele ta-ngü te Yesu kpala. ");
INSERT INTO muh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Fütanga ngü la, fü ewü azoro Yüwane, anü di agü agbü ku. Te Yesu je ngü la, fü ah ayia ace sü la, adu ka-ye agbü *Galïlaya. Fü ah angbü endoro da emala ngari Me fü wü kpara kpala, ");
INSERT INTO muh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","gü ba dene, “Mere sïkpï koro eyi gbamari. Miri te Me tima teka aküwa wü ne, koro eyi. Te di bala, wü ce *siti ngü ka-wü, de wü le to ngü ka Me de maguma wü biringbö.” ");
INSERT INTO muh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gbü gara ra, fü Yesu ayia anü andoro era mere ngu de ïrï ye *Galïlaya. Fü engu akoro amaka wü gara komoko ꞌbasu, te ewü ngbü egü yïmba ka-wü gbü ngu teka azoro si, angü ah de tima ka-ewü. Ah de Sïmüna Petero ake enga ni ye, de ïrï ye Anderïya. ");
INSERT INTO muh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Fü Yesu arü amala ngü fü ewü, gü ba dene, “Yi nü kpakine, yi lala gbü nga ra. Ma ena ao yi, teka angbü efü wü kpara, de wüh le ngü ka Me, da tima ka si te yi ngbü emere ne.” ");
INSERT INTO muh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Te wüh je ngü la, fü ewü ayia kere, ace tima ka si ka-wü la, te ewü ngbü emere la, adu alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Fü wü Yesu ayia sela, anü kpa engagira nü mba cüküꞌdaye. Fü ewü anü amaka wü gara wü kpara ꞌbasu. Ah de wü *Yakobo ake *Yüwane, wü di Zebedayo. Wüh ngbü ka-wü gbü *zabu, da ekpokpo jia yïmba ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Fü Yesu ayia aï ewü kpah bala. Fü ewü ayia ace wö wü, Zebedayo, agbü zabu kpala, de wü kpara ka tima ka-ye. Fü ewü ayia anü alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Gbü gara ra, fü wü Yesu ayia anü akoro agbü Kaparanama. Fü *sïkpï ka Me amaka ewü kpala. Fü ewü ayia anü arï kpa *esambü ka biti-te. Fü Yesu akpo da erï wü kpara kpala. ");
INSERT INTO muh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Fü rïrï kaka-na la ayia aga gbü jia wü kpara la afa sü. Wüh gü ba, “Rïrï ka komoko ne ka-ye kpikpi ye. Angü ah ngbü emala mere kpeke ngü, baka kpara te Me tima engu me-ye. Wü kpara ka-ani, te ewü ngbü erï ani de sene ne, wüh rï ani bala nda-wü de.” ");
INSERT INTO muh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gara komoko ta ladü kpa esambü ka biti-te la, de *siti wü di enga me guvu ye. Fü komoko la ayia akpo da eba rere kpa tikpi, gü ba, ");
INSERT INTO muh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu deyï, tima ka-ani gbü ngü ka-ye nda ma. Ye koro sene teka ne? Teka amörö ani asidi? Ani wu ye kpo. Ye de züka kpara te Me tima ye me-ye füh kotö ne.” ");
INSERT INTO muh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Fü Yesu ayia amala ngü fü siti wü di enga me la, gü ba dene, “Yi nga anga, de yi koro guvu komoko la asidi!” ");
INSERT INTO muh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Fü siti wü di enga me la ayia agbürü komoko la, agbo kötö, da eba rere. Fü ewü ayia ace komoko la, akpe, atafa ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dela ngü ta te Yesu mere, te engu liki siti wü di enga me di, guvu gara komoko asidi. Fü ngü la aga gbü jia wü kpara ꞌburu, baka mere ngü cucu. Fü ewü akpo da eyi-ta tete-wü, gü ba dene, “Apa! De bane ne ngü ne? Amba rïrï ka Yesu ne, ah ka-ye de kpeke rïrï fanü fanü. Angü ah ngbü eto rïrï fü siti wü di enga me, fü ewü angbü eje ngü kaka!” ");
INSERT INTO muh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Teka ngü la, fü ïrï Yesu ayia awü gbü nga nzö wü sü ka *Galïlaya ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Fütanga ngü la, fü wü Yesu ayia ace *kambü ka biti-te. Fü ewü anü de wü *Yakobo ake *Yüwane, kpa gba wü Sïmüna Petero ake Anderïya. ");
INSERT INTO muh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Te wüh koro kpala, fü ewü amaka wügiri ye Sïmüna, würüse, te keke ngbü emere engu efa sü, te ra ngbü kötö. Küküte ꞌburu wütü awütü. Fü ewü amala nga würüse la fü Yesu. ");
INSERT INTO muh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Fü Yesu ayia anü akoro kpaka würüse la, azoro kpakpa na, ae engu tikpi. Fü soko würüse la ayia alofo. Fü würüse la ayia anü amere kümü, ato fü ewü. ");
INSERT INTO muh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Etamurago la, te ra tï tete na, fü mere bi wü kpara ayia aza wü mürü keke ka-wü, bete wü kpara te *siti wü di enga me ngbü emere ewü ne, akoro de ewü kpaka Yesu. ");
INSERT INTO muh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Fü wü kpara gbü sü la aci abiti te-wü gbe gbe gbe kpa emöngïtï ka kambü te Yesu di gbügbü na. ");
INSERT INTO muh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Fü Yesu ayia aküwa mere bi wü kpara de wü keke eküte wü la ꞌburu. Fü ah aliki *siti wü di enga me guvu gara ewü asidi. Fü siti wü di enga me la angbü eku gba. Fü Yesu ayia atïrï ewü. Kükürü de, angü wüh wu ta eyi, gü ba, Yesu ka-ye de kpara te Me tima engu me-ye füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gügü emözekpï, o sü lofo la de, fü Yesu ayia kpikpi ye, ace Kaparanama, anü akoro kpa gbü gara sü, kpa gbü gü, teka aku gba fü Me. ");
INSERT INTO muh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Te wü Sïmüna Petero zükü tete, Yesu nda ma! Fü ewü ayia anü agïrï engu. ");
INSERT INTO muh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Fü ewü anü amaka Yesu agbü gü kpala, amala ngü fefe, gü ba dene, “Mere kpara deyï, ani du edu kpa ekötï, angü wü kpara ꞌburu ngbü egïrï ye, teka de ye küwa ani.” ");
INSERT INTO muh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu gü ba, “Ani nü la kpa gbü gara sü, teka fü ni amala ngari Me fü mene wü kpara de kpala. Angü dela tima ka-ni, te Me tima ni tüngüngü.” ");
INSERT INTO muh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Fütanga ngü la, fü Yesu akpo da endoro gbü wü kötï ka *Galïlaya ꞌburu nde, da erï wü kpara de to ngü ka Me, kpa *esambü ka biti-te ka-ewü, kpah da eliki *siti wü di enga me guvu wü gara kpara, te ngbü emere ewü ne, asidi. ");
INSERT INTO muh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gbü gara ra, fü gara komoko ayia akoro kpaka Yesu, de *jiakö te ye. Fü komoko la abu nzökuta ye kötö, andaꞌba te-ye, gü ba, “Ni wu eyi, gü ba, ye de mere mürü wazi fa sü. Te ah ꞌbe gbü jia ye la, de ye reke la mba küte ni ne.” ");
INSERT INTO muh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Fü ngü komoko la ake te Yesu afa sü. Fü ah ayia ao kpa ye eküte komoko la, gü ba, “Wayi, ma le eyi. Küte mü reke ereke.” ");
INSERT INTO muh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Fü jiakö ayia agürü eküte komoko la asidi. Fü küküte adu akoro te nga ye. ");
INSERT INTO muh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Fü Yesu amala ngü fü komoko la kpekpeke, ");
INSERT INTO muh_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","gü ba, “De-ye deyï, ye mere e amala nga ngü la fü wü gara kpara de. Ye nü enü, ye mere ngü, ta te *Müse ba gbü *Rïrï ka Me ne. Ye za nü, ye nü di kpaka *mürü gele ka Mere Me, de ah wa, ah to fü Me teka ngü la. Teka fü wü kpara ꞌburu awu, gü ba, küte ye reke eyi fanü.” ");
INSERT INTO muh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amba ngü te Yesu mala fü komoko la, ah je nda de. Fü ah ayia anü, akpo da emala nga ngü la fü wü kpara bü faaa. Fü nga ngü la awü, abaya gbü wü sü ꞌburu. Teka ngü la, da Yesu te engu ena angbü agbü mere kötï ngbaangba gbü jia wü kpara ne tïne ma. Fü ah angbü ka-ye ewo te-ye agbü gü. Te wüh je nga Yesu bala, fü mere bi wü kpara ayia te nga nzö wü kötï ꞌburu, angbü ekoro kpakaka na agbü gü la. ");
INSERT INTO muh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gbü gara sïkpï, fü wü Yesu ayia adu kpa ekötï, agbü Kaparanama. Te wü kpara je nganga na, gü ba, Yesu du koro eyi kpa ekötï ne, ");
INSERT INTO muh_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","fü mere bi wü kpara aci akoro abiti te-wü gbe, kpa esambü te Yesu ngbü gbügbü na ne. Fü sü ani kpa esambü ꞌburu yere. Fü gara wü kpara angbü nda-wü kpa etanü, ede möngïtï. Fü Yesu angbü emala to ngari Me fü ewü. ");
INSERT INTO muh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Baka te Yesu ngbü la emala to ngari Me fü wü kpara la, fü ewü ayia akoro de gara komoko, te küküte kpi akpi ꞌburu. Wü kpara te ewü bï engu, wüh baka wü kpara bala. Fü ewü abï engu füh kaꞌda, de ani koro di kpaka Yesu, de ah küwa engu. ");
INSERT INTO muh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Te wüh koro kpala, fü ewü amaka mere bi wü kpara, te ewü ni sü emöngïtï ꞌburu yere. Da ewü, te ewü ena arï kpa esambü de mürü keke la, akoro di kpaka Yesu ne, nda ma. Te di bala, fü ewü ayia afï nga gara mani. Fü ewü ayia alï kpa tikpi, enzö kambü, afuru nzö kambü la mbiii te sü, te Yesu ngbü ero mö tete na ne. Fü ewü ai ku te kaꞌda ka mürü keke la, abï engu di, ato te görö te ewü furu la ferrre, ao kötö engagira Yesu. ");
INSERT INTO muh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Te Yesu wu ngü la bala, fü ah awu, gü ba, wü kpara la to maguma wü eyi fü ni fanü fanü. Fü ngü la areke gbü jijia na afa sü. Fü ah ayia amala ngü fü mürü keke la, gü ba dene, “Enga ra, *siti ngü ka-mü ta te mü mere gbü jia Me ne, ma za gbü nzö mü eyi asidi.” ");
INSERT INTO muh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Gara wü *mürü rïrï ta kpah ladü kpala. Te wüh je ngü te Yesu mala fü komoko la bala, fü ewü angbü efï nga ngü emaguma wü, ");
INSERT INTO muh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","gü ba dene, “Dene ne töndö ngü ne? Yesu yia efü te-ye ba Me? Angü kpara füh kotö ne, te tï aza siti ngü gbü nzö wü kpara, ah ngbürü ladü? Ah nda ma! ꞌDuwa Me te ngbü eza siti ngü ka wü kpara me-ye.” ");
INSERT INTO muh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Amba Yesu wu fïngangü ka-ewü la eyi. Fü ah ayia ayi-ta ewü, gü ba dene, “Yi ngbü efï nga ngü la emaguma yi bala, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Yi wu de, gü ba, ma de *Ye Kpara ka Kpï? Te di bala, wazi ra ladü, teka adi eza siti ngü ka wü kpara füh kotö ne, gbü nzö ewü di asidi. Yi fï nda-yi, gü ba, ma mala töndö ngü kükürü? Yi ena awu ngü la enatikine.” Fü Yesu adu afü te-ye, amala ngü fü mürü keke la, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“De-ye deyï, ye yia eyia, ye za darara ka-ye, ye go kpa ekötï.” ");
INSERT INTO muh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Fü mürü keke la ayia ꞌduwa cukuru, gbü jia wü kpara ꞌburu, arü atikpi. Fü ah aza darara ka-ye, ayia ago di agba ye. Dela ngü ta te Yesu mere, te engu küwa komoko, te küküte na kpi akpi ne. Fü ngü la aga gbü jia wü kpara la afa ꞌduwa sü. Fü ewü aci ꞌburu, agbo nga ïrï Me, gü ba, “Ani wu ngü de bala gügü la de!” ");
INSERT INTO muh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Fü wü Yesu ayia anü andoro kpa era mere ngu. Fü mere bi wü kpara angbü ekoro kpakaka na la, teka aje ngü gögömö na. Fü Yesu angbü erï ewü de to ngari Me kpala. ");
INSERT INTO muh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Gbü gara ra, fü Yesu ayia anü andoro. Fü ah amaka gara komoko de ïrï ye *Levi Matayo, ye Alofaya, te ngbü ka-ye ero *jiase ka wü e esaka wü kpara, adi eto fü Miri ka wü Rüma. Fü Yesu arü amala ngü fü Levi, gü ba dene, “Levi deyï, mü yia eyia, mü lala gbü nga ra.” Fü Levi ayia ace tima ka-ye la, alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Fütanga ngü la, fü Levi ayia aï wü Yesu de wü kpara ka-ye agba ye. Fü ah aï kpah mere bi wü bu ye, de te ewü ngbü ero jiase de ewü ne, abe kpah te gara wü kpara, te wü *mürü rïrï gü ba, wüh de siti wü kpara ne. Fü wü kpara la akoro ꞌburu, angbü ezü e tundu de wü Yesu kpala. Angü wü kpara la ngbü ta ꞌburu efa nga Yesu. ");
INSERT INTO muh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wü gara mürü rïrï ta ladü, te ewü eï ewü, gü ba, wü *Farusi. Wü Farusi la, wüh de wü kpara te ewü le adi emere gele ka-wü mbi mbi mbi. Fü wü Farusi aje ngü, gü ba, “Yesu ngbü ezü e de wü siti wü kpara.” Fü ewü ayia akoro amaka wü *kpara ka Yesu, ayi-ta ewü, gü ba, “Ah mere baye, te Yesu ngbü ezü e de wü siti wü kpara ne?” ");
INSERT INTO muh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Te Yesu je ngü te ewü mala la, fü ah amala ngü, gü ba dene, “Te keke te mü ma la, mü ena anü anü kpaka mürü kuwa? Mü tï anü de. ꞌDuwa te mü de keke te mü la, mü ena anü anü kpaka mürü kuwa, de ah küwa ni. Ngü ka-ra kpah bala. Angü ma koro füh kotö ne, neh teka wü da? Teka aküwa züka wü kpara? Ah bala de. Ma koro teka aküwa siti wü kpara, de wüh ce *siti ngü ka-wü asidi.” ");
INSERT INTO muh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gbü wü gara sïkpï, wü *Farusi zü e de. Wüh ngbü *eꞌbï te-wü, teka adi eku gba fü Me. Wü kpara ka *Yüwane Mürü Babatïza ngbü emere kpah bala. Gbü ngü la, fü wü kpara ayia akoro kpaka Yesu, ayi-tata, gü ba dene, “De-ye deyï, wü kpara ka Yüwane, de wü Farusi ꞌburu, wüh zü e enatikine de, teka aku gba fü Me. Anga ah mere baye, te nda-ye wü kpara ne, ngbü nda-wü ezü e ne? Wüh fï nga gele ka-ani mbi mbi mbi nda-wü de?” ");
INSERT INTO muh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Fü Yesu ayia alügü ngü fü ewü gbü mani, gü ba dene, “Te wü ngba nü agbü karama la, wüh tï azü e de? Wüh tï eyi azü e, angü mürü karama la ladü tundu de ewü. ");
INSERT INTO muh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amba te gara, te wü vügü ena aza mürü karama la, esüka wü awuba ye asidi la, wüh tï azü e de, ka cïnga emaguma wü.” ");
INSERT INTO muh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Fü Yesu adu amala gara wü mani fü ewü, teka to rïrï ka Me, te engu ngbü erï wü kpara di ne, gü ba dene, “Te diri bongo ka-mü sörö asörö la, mü tï eyi aza to bongo, teka atükü te didiri na la? Mü tï amere bala de, angü didiri na la ena adu kpah asörö ka-ye asörö. ");
INSERT INTO muh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kpah bala, te mü le aküꞌda fï ka-mü la, de mü mere e aküꞌda gbü diri bütü körö körö ne de. Angü diri bütü la ena adü, aöfö ka-ye, fü fï ka-mü la atökö ka-ye ꞌburu akötö. Ah le fü mü aküꞌda fï ka-mü gbü to bütü, angü fï ka-mü la ena asiti siti. Kpah bala, te mü ngbü ele to rïrï ka-ra la, mü tï alala fï bü eküte diri gele ka wü kundu mü nda-mü de.” ");
INSERT INTO muh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gbü gara *sïkpï ka Me, fü wü Yesu angbü enü de wü kpara ka-ye. Fü ewü afü kpuru gbü yï ka ndo. Te wüh ngbü enü tete, fü wü *kpara ka Yesu la akpo da esösörö fï ndo, da etitiri koko na, ezü ka tala. ");
INSERT INTO muh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fü wü gara *Farusi awu ngü la bala. Fü ngü la asiti gbü jia ewü, angü wüh ngbü efï, gü ba, “Masörö fï ndo la, ah de tima.” Angü *Rïrï ta te Müse to fü wü *Yïsarayele ne, gü ba, “Wüh mere e adi emere tima gbü sïkpï ka Me ꞌburu ꞌburu de.” Fü wü Farusi la akoro amala ngü fü Yesu, gü ba dene, “De-ye deyï, wü kpara ka-ye ne, ngbü emere tima gbü sïkpï ka Me, neh teka ne? Ngü la siti gbü jia Me fa sü!” ");
INSERT INTO muh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu gü ba dene, “De-wü deyï, wü tanga *Ngari Me nda-wü neh de? Ngü ta te wüh ba teka *Mere Miri Davidi ne, ah gü neh fe? Ta gbü gara ra, fü tala ayia amere wü Davidi, de wü kpara gbü nga ye. ");
INSERT INTO muh_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Fü Davidi ayia akoro kpaka *mürü gele ka Mere Me, ayi-tata teka e-mazü. Fü mürü gele la ayia aza ambata, de te wüh ngbü eto fü Mere Me ne, ato fü Davidi. Fü Davidi azü, ato kpah fü wü kpara gbü nga ye ꞌburu. Wüh mala ta eyi fefe, gü ba, ‘Ye ngbü esiti gele?’ Wüh mala bala de! Amba gbü *Rïrï ta te Müse to fü wü mürü gele ne, ambata la, ah teka wü kükürü kpara fa fa fa nda de. ꞌDuwa wü mürü gele ka Mere Me ngbü ezü me-wü. Dela ngü ta te Davidi mere, ta gügü, o Abïyatara di de mere kpara füh kpökpö ka wü mürü gele.” ");
INSERT INTO muh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Fü Yesu adu amala kpah gara ngü fü ewü, gü ba dene, “Me o wü kpara füh kotö ne, neh teka ne? Teka amere gele ka sïkpï ka-ye? Ah bala de. Me o sïkpï ka-ye teka fü wü kpara adi efe te-wü gbügbü na. ");
INSERT INTO muh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","De-ra, *Ye Kpara ka Kpï, Me to wazi eyi fere, fa ngü ka gele la di ka. Ma de mürü *sïkpï ka Me la me-ra. Ma ngbü kpah eto to *rïrï ka Me fü wü kpara ka-ra me-ra.” ");
INSERT INTO muh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gbü gara *sïkpï ka Me, fü Yesu anü arï kpa *esambü ka biti-te. Gara komoko ta ladü kpala te kpakpa na ze aze. ");
INSERT INTO muh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wü gara *Farusi ta kpah ladü kpala. Fü ewü angbü efete Yesu, da egïrï kaje te ani ena amaka siti ngü kaka tete, fü ani amala nganga fü wü *kovo. Fü ewü angbü eceka Yesu, da efete engu kpekpeke, anga engu ena aküwa komoko la gbü sïkpï ka Me ya? Angü wüh ngbü efï nda-wü, gü ba, maküwa kpara, ah de tima. ");
INSERT INTO muh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Fü Yesu ayia aï komoko te kpakpa na ze aze la, gü ba dene, “De-ye deyï, ye koro la kpa engagira nü akine.” Fü komoko la ayia akoro. ");
INSERT INTO muh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Fü Yesu ayi-ta wü Farusi la, gü ba dene, “Gbü jia yi, ah le fü kpara amere ne ngü ne, gbü sïkpï ka Me? Wüh di emere züka ngü? Anga *siti ngü reke me-ye? Ah le de nih küwa kpara? Anga ah le de nih ce kpara fü kpi? *Rïrï ka Me, te *Müse mala fü nih ne, gü neh fe?” Fü ewü anga ka-wü tï. Wüh le ngü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Fü Yesu ayia aceka kpï füh ewü ngberrre ꞌburu. Fü mamaguma ayia asiti teka ngü ka-ewü la, angü nzö ewü kpekpeke. Fü ah adu arü amala ngü fü komoko la, gü ba dene, “Mü gbere kpa mü egbere.” Fü komoko ayia agbere kpa ye. Fü kpakpa na ayia areke, adu zürrrü te nga ye. ");
INSERT INTO muh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Te wü Farusi wu ngü la, fü ngü la ake te ewü, angü Yesu reke kpa komoko la gbü sïkpï ka Me. Fü ewü ayia akoro kpa etanü, anü abiti te-wü de wü kovo ka Miri Anïtïpa *Erode. Fü ewü akpo da egïrï kaje, te ani ena amörö Yesu tete na. ");
INSERT INTO muh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Fütanga ngü la, fü wü Yesu ayia de wü kpara ka-ye, anü andoro kpa era mere ngu. Fü mere bi wü kpara ayia rurrru! anü afa nganga na, angü wüh je nga wü mere kpeke ngü, te engu ngbü emere ne. Wü kpara la koro te nga mere bi wü sü. Gara ewü koro agbü nga nzö kötï ka wü *Galïlaya. Gara ewü koro nengete, agbü Yerüsalema, de wü gara nga nzö kötï ka *Yudaya. Gara ewü koro gbü nga nzö kötï ka wü Edomaya, gara gbü nga nzö kötï kpa etangu Yürüdene, gara agbü wü mere kötï de ïrï wü Tera bete Sïdona de wü sü ede ewü. ");
INSERT INTO muh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Te Yesu wu mere bi wü kpara la, fü ah ayia amala ngü fü wü kpara ka-ye, gü ba dene, “Wü nü la enü, wü koro de *zabu, de ni lï gbügbü, angü wü kpara ne ena adere ni.” ");
INSERT INTO muh_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yesu mala ngü la bala kükürü de, angü mere bi wü mürü keke koro eyi sela. Fü ewü angbü egbene sü agbene, gü ba dene, “Wayi, ah le de ani zoro küte Yesu, teka fü ani aküwa.” Angü wüh wu eyi, gü ba, Yesu ngbü eyi eküwa mere bi wü kpara. ");
INSERT INTO muh_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Gara wü kpara te *siti wü di enga me ngbü emere ewü, te ewü wu Yesu tete, fü ewü atï kötö, aba rere, gü ba, “Yesu, mü de Ye Me.” ");
INSERT INTO muh_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Fü Yesu amala ngü fü siti wü di enga me la kpekpeke, gü ba, “Wü mere e agü tamu ni de.” Dela ngü ta te Yesu küwa mere bi wü kpara tete. ");
INSERT INTO muh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Gbü gara ra, fü wü Yesu ayia anü kpa enzö mere rüvü. Fü ah ayia aï wü *kpara ka-ye la kpaka ye kpala. ");
INSERT INTO muh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Fü ah ayia afe süka ewü nzükpa de füh ye ꞌbasu, ao ewü, wü *mürü tima ka-ye. Fü ah amala ngü fü ewü, gü ba, “Ma fe yi teka fü nih angbü endoro de nih ma. Te gara, ma ena atima yi, teka fü yi adi emala ngari ra fü wü kpara. ");
INSERT INTO muh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma ena ato wazi fü yi teka fü yi adi eliki *siti wü di enga me di.” ");
INSERT INTO muh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dene ïrï wü kpara te Yesu fe ewü ne. Sïmüna, te Yesu gü gara ïrï tete na, gü ba, Petero, ");
INSERT INTO muh_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","wü *Yakobo ake *Yüwane, wü di Zebedayo, te Yesu gü ïrï te ewü, gü ba, wü Büwanerage, gü ba, wüh baka mügbara. ");
INSERT INTO muh_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Wü Anderïya, bete *Fïlïpo, bete Batülümayo, bete Matayo, bete Toma, bete *Yakobo ye Alofaya, bete Tadayo, bete Sïmüna ta te di kpara te mere gü teka tö ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Abe kpah te *Yuda Keriyota, ta te gü tamu Yesu fü wü vügü ne. Dela ta ngü ka wü kpara te Yesu fe ewü. ");
INSERT INTO muh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Fütanga ngü la, fü mere bi wü kpara adu abiti te-wü kpaka Yesu gbe. Da wü Yesu, te ewü ena azü e de wü kpara ka-ye, nda ma. ");
INSERT INTO muh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Fü wü di enga ni ye Yesu, te ewü di kpa gbü gara sü, ayia aje ngü la. Fü ewü afï nda-wü, gü ba dene, “Nzö Yesu siti eyi.” Fü ewü ayia anü kpakaka na, de ani zoro engu, adu di kpa ekötï. ");
INSERT INTO muh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Fü nga wü ngü, te Yesu ngbü emere la, adu kpah awü akoro zalü agbü Yerüsalema. Fü gara wü *mürü rïrï ayia agbü Yerüsalema kpala, anü akoro kpaka Yesu teka awu ngü la cu de jia wü. Te wüh wu wü kpeke ngü, te Yesu ngbü emere ne, fü ewü akpo da emala siti ngü, gü ba, “Yesu maka wazi teka aliki *siti wü di enga me di ne, neh kaye? *Satana to wazi la fefe me-ye, angü engu de miri ka wü di enga me!” ");
INSERT INTO muh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Te Yesu je ngü la, fü ah ayia aï wü mürü rïrï la kpaka ye, adu arü amala ngü fü ewü de mani, gü ba dene, “Satana ena aliki te-ye de tete-ye, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Te nguwa wü kpara biringbö kpo eyi emere gü esüka wü la, züka ngü ena adi ladü? Ngü la reke nda de, angü nguwa wü kpara la ena anza. ");
INSERT INTO muh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kpah bala, te wü kpara gbü kötï biringbö kpo eyi da emömörö te-wü la, ah ena atï atï? Ah tï nda de. Kötï la ena asiti, fü ewü abaya asidi. ");
INSERT INTO muh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Angü te Satana ena angbü eto wazi fere me-ye, teka aliki wü kpara ka-ye di la, ah ena adi ba e te engu siti tima ka-ye me-ye. De bane, ngü ka Satana ena anza ka!” ");
INSERT INTO muh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Teka ngü la, fü Yesu adu arü amala gara mani fü ewü, gü ba dene, “Te kpeke kpara ladü, te di de wazi ye fa sü, e-ena arï kpa esambü kaka, agbene wü e kaka, neh da? Angü, ah ngbü eceka kpï fütanga kambü ka-ye ꞌbe ꞌbe ꞌbe. Amba, te gara kpeke kpara koro, te wawazi fa nda gina kpara la, ah ena azoro engu, ai gö! agbene wü e kaka ꞌburu, anü sü di. Te di bala, ah le de yi wu, gü ba, wazi ra fa nda Satana, te ngbü embü yi de füh kotö ne ka.” ");
INSERT INTO muh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Fü Yesu adu amala gara ngü fü ewü, gü ba dene, “Ngü te ma emala fü yi dene, ah de kpeke ngü. Wü *siti ngü ꞌburu te wü kpara ngbü emere ne, te kpara fü maguma ye la, Me ena aboro ngü kaka la ꞌburu. Kpah bala, wü ngü te wü kpara ngbü emala esiti te ïrï Me ne, Me ena aboro kpah asidi. ");
INSERT INTO muh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ꞌDuwa kpara te ngbü esoko *Nzïla Wazi Me, Me boro ngü kaka-na la kpo fï de. Lïya kaka-na la ena angbü fï gbü nzönzö na fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu mala ngü la bala, teka te wü mürü rïrï la soko Nzïla Wazi Me, gü ba, “Yesu maka wazi la esaka *siti wü di enga me,” ne. ");
INSERT INTO muh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Fütanga ngü la, fü wü di enga ni ye Yesu ayia akoro de wü ni ye na. Te wüh koro tete, fü ewü amaka bi wü kpara te ewü biti te-wü, ngbü ede Yesu. Da ewü te ewü ena arï akoro kpaka Yesu kpa esambü la, ah nda ma. Fü ewü arü kpa etanü, atima kpara kpakaka na, gü ba, “Ye nü, ye ï Yesu fü ani.” Fü kpara la akoro amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, wü ni ye, de wü di enga ni ye, ladü kpa etanü kpane. Wüh ngbü ta ele awu ye.” ");
INSERT INTO muh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","34","Yesu gü ba dene, “Ah mbi.” Fü ah adu aceka kpï füh wü kpara la ngberrre ꞌburu, gü ba, “Amba de-yi, wü kpara te yi biti te-yi sene, teka aje ngü ka-ra ne, yi kpah de wü di enga wüna, de wü wüna. ");
INSERT INTO muh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Angü te mü ngbü ele ngü ka Me da emere la, mü ena adi fere baka wüna, anga enga wüna.” Dela ngü ta te Yesu mala fü mere bi wü kpara la. ");
INSERT INTO muh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Gbü gara ra, fü Yesu adu anü andoro era mere ngu *Galïlaya, adu kpah angbü erï wü kpara kpala. Fü mere bi wü kpara aci kpah, akoro kpakaka na la gbe. Te engu wu bala, fü ah ayia alï ka-ye gbü *zabu, angbü kpala füh ngu, angü wü kpara ena adere ni. Fü bi wü kpara la angbü nda-wü kpa füh gümba, da eje ngü gögömö na. ");
INSERT INTO muh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Fü Yesu angbü erï ewü de mere bi wü ngü ꞌburu gbü mani, gü ba, ");
INSERT INTO muh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Yi da la güje yi, de yi je ngü ka-ra ne. Gara komoko ta ladü, te le amoko ndo ka-ye. Fü ah ayia aza nguwa ndo, anü di agbü yï, amoko. ");
INSERT INTO muh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Te engu ngbü emoko ndo la, fü wü gara jia ndo atï te kaje. Fü wü lu awu jia ndo la. Fü ewü ayia kere, akoro adoro nguwa la, ami ka. ");
INSERT INTO muh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Fü gara nguwa atï füh wü sï-da, te tö di sela mbi mbi ma. Fü nguwa la ayia akö kere, teka ne de, angü tö sela sere sere. ");
INSERT INTO muh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Fü ra ayia asü. Fü fu-ndo la ayia aürü ka-ye ꞌburu, angü sïsï na rï gbü tö mbi mbi de. ");
INSERT INTO muh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fü gara nguwa atï esüka wü ti. Fü nguwa la akö aga de wü fu-ti la ꞌburu. Fü wü ti awündü züka fu-ndo la. Fü ah adu afü te-ye yï-andüla tete. Ah zï jia de. ");
INSERT INTO muh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Fü gara nguwa atï gbü züka sü. Fü ah ayia akö, agere, arï gbrrri! Gara zï jia ye mbi, gara zï jia ye fa sü, gara zï jia ye reke ꞌduwa ba-neh-ene-la, angü ah tï gbü züka tö.” ");
INSERT INTO muh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Fü Yesu adu amala fü ewü, gü ba, “Te güje mü ladü la, de mü da güje mü te ngü ka-ra la mbi mbi mbi.” Dela ngü te Yesu mala teka nguwa te wüh moko gbü tö. ");
INSERT INTO muh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Fütanga ngü la, te Yesu di kpikpi ye, fü wü kpara te engu fe ewü, nzükpa de füh ye ꞌbasu ne, ayia de wü gara wü kpara kaka-na, anü kpakaka na. Fü ewü ayi-tata teka si mani te engu mala la. ");
INSERT INTO muh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu gü ba, “Ta gügü, wü kpara je si-ngü ka Me nda-wü de. Ngü ka Me ngbü gbü jia ewü ꞌdaaa, ah wo te-ye awo. Nda-yi, wü kpara ka-ra, ma ngbü eyi esere ngü la fü yi ꞌburu mbölö mbölö, gü ba, Me le de wü kpara ꞌburu to maguma wü fü ni. Amba wü gara kpara la tï aje si-ngü la nda-wü de, angü wüh le ngü ka-ra de. Teka ngü la, ma ngbü emala ngü la fü ewü ꞌburu de mani. ");
INSERT INTO muh_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ah kpah baka ngü ta te Me mala teka wü kpara la, gömö *mürü dofo Yïsaya, gü ba dene, ‘De-wü deyï, wü ena aceka ngü ka-ni ma, wü tï awu si-ngü la nda-wü de. Wü ena aje ngari ni, Me, ma, ngü la tï arï gbü nzö wü kpah de. Angü, te wü ena aje ta si-ngü ka-ni, Me, mbi mbi la, de bane wü ena ace *siti ngü ka-wü, adu ale ngü ka-ni, teka fü ni aboro siti ngü ka-wü.’ Dela ngü ta te Me mala gügü teka wü kpara, te ewü le ngü ka-ra de ne.” ");
INSERT INTO muh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Fü Yesu adu amala ngü fü ewü, gü ba dene, “Yi tï awu si mani ka nguwa la nda-yi kpah de? Te di bala, yi ena awu si wü ngü gbü wü gara mani ꞌburu, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ma ena amala si-ngü la fü yi. Kpara te moko nguwa la, ah baka kpara te emala ngari Me. ");
INSERT INTO muh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nguwa te tï te kaje, ah baka mene wü kpara, te wüh mala ngari Me fü ewü, amba ngü la rï gbü nzö ewü nda de. Fü *Satana awu ngü la, ayia kere, akoro aza ngü la emaguma ewü asidi. ");
INSERT INTO muh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nguwa te tï füh wü sï-da, ah baka mene wü kpara, te wüh mala ngari Me fü ewü. Fü ewü ayia aje ngü la, ale de züka tadu. ");
INSERT INTO muh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amba wüh rü kpekpeke gbü ngü ka Me de, angü maguma ewü ka-ye ꞌbasu ꞌbasu. Teka ne de, angü wüh to maguma wü fü Me mbi mbi de. Nga ngü la yïrï kpah de, fü cïnga ayia akoro teka ngü ka Me la. Teka wü ngü la, fü wü kpara la ayia ace ngü ka Me kere, teka ngü ka cïnga la. Fü ewü adu angbü emere gara wü ngü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nguwa te tï esüka wü ti, ah baka mene wü kpara, te ewü le ngari Me eyi, ");
INSERT INTO muh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amba fïngangü ka-ewü ka-ye ꞌbasu ꞌbasu. Wüh ngbü efï nga wü e ka füh kotö ne. Fü gümü jiase ayia amere ewü, bete gümü wü gara wü e fa sü. Teka ngü la, wüh tï amere tima ka Me mbi mbi de, fü ngü ka Me ayia afü te-ye emaguma ewü baka yï-andüla. ");
INSERT INTO muh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nguwa de te tï gbü züka sü, ah baka mene wü kpara, te wüh mala ngari Me fü ewü. Fü ewü aje ngü la, ayia ale de maguma wü ꞌburu. Fü ngü ka Me la aga kpa emaguma ewü baka ndo te zï jia ye mbi, gara zï jia ye fa sü, gara zï jia ye reke ꞌduwa ba-neh-ene-la. Dela si-ngü gbü mani teka nguwa ndo la.” ");
INSERT INTO muh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Fü Yesu adu amala gara mani fü mere bi wü kpara la, gü ba dene, “Te mü siya wa ka-mü gbü biti, akoro di, ao kpa esambü la, mü ena amere di baye? Mü ena abuka sila fefeh? Anga mü ena ao esa ngbaga? Ah bala de. Mü ena ao wa ka-mü kpa tikpi füh e, teka fü ah alofo sü mbi. ");
INSERT INTO muh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kpah bala, ngü ka-ra te wü kpara je mbi mbi de, te wo te-ye awo fü ewü ne, wüh ena awu ngü la te gara, angü Me ena agü tamu ngü la fü ewü me-ye. ");
INSERT INTO muh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Te güje mü ladü la, de mü da güje mü teka aje ngü ka-ra la mbi mbi mbi.” ");
INSERT INTO muh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Fü Yesu adu amala gara ngü fü ewü, gü ba dene, “Ngü te ma ngbü emala fü yi ne, yi o fïngangü ka-yi ꞌburu tete na. Teka ne de, angü, te mü fï nga ngü ka-ra mbi mbi la, sisi na ena arï gbü nzö mü. Fü Me adu agü tamu gara wü ngü fü mü gbe. ");
INSERT INTO muh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Angü te mü le ngü ka-ra ne eyi, Me ena adu agü tamu gara wü ngü fü mü gbe. Amba, te mü le aje ngü ka-ra nda-mü de la, mba enga ngü cüküꞌdaye, te di gbü nzö mü ne, ah ena adürü ka-ye adürü asidi.” ");
INSERT INTO muh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Fü Yesu adu amala kpah gara ngü fü mere bi wü kpara la de mani, gü ba dene, “Ngari Me ngbü efü maguma kpara, fü ah akoro kpara ka Me, neh baye baye? Ngü la, ah baka nguwa ndo, te gara kpara moko gbü yï ka-ye. ");
INSERT INTO muh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kpara la tï aga ndo ka-ye la me-ye nda de, amba wü e la ena angbü ega ka-wü de tete-wü. Te di bala, nguwa la ena ato sï ye, fü ah akö, ");
INSERT INTO muh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","angü nguwa la ngbü emaka wazi ka-ye gbü tö. Fü ah ato fu ye. Fü ah akpo angbü ega, adu ao gba ye. Fü ah akpo ezï jia ye, akoro ndo. ");
INSERT INTO muh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Te kpïrï ndo la koro eyi la, fü mürü ndo la awu, gü ba, ‘Wayi, ndo ka-ni ndri eyi. Fü ah aza maguruma ka-ye, anü agbü yï, awa ndo ka-ye la di.’ ” ");
INSERT INTO muh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Fü Yesu adu amala gara ngü fü ewü, gü ba dene, “Ma ena amala gara mani fü yi teka agü tamu ngü ka Me di fü yi. ");
INSERT INTO muh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Angü ngü ka Me, ah baka jia gara rü de ïrï ye müsïtada, te di de jia ye baka lïꞌba, jürrrü bane. ");
INSERT INTO muh_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Te mü ru nguwa la, ah ena akö, aga, akoro mere rü, da eto sa-e, te wü lu ena angbü efe te-wü gbügbü. Kpah bala, ngü ka Me ena aga te gara, akoro memere, baka ngü ka rü la.” ");
INSERT INTO muh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dela ngü ka Me, ta te Yesu mala fü bi wü kpara la gbü mani. Ah ngbü mala bi wü gara ngü fü ewü, gbü mani kpah bala. Ah ngbü emala wü ngü la fü ewü ferrre, de wüh je mbi. ");
INSERT INTO muh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Amba ah mala si wü ngü la fü ewü mbölö mbölö nda de. Ah ngbü emala wü ngü la fü ewü ꞌburu gbü mani. ꞌDuwa te ewü du ngbü kpikpi wü, de wü kpara ka-ye la, fü ah angbü esere si-ngü la fü ewü tïne mbölö mbölö. ");
INSERT INTO muh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Gbü ra la, etamurago, fü Yesu ayia amala ngü fü wü kpara ka-ye, gü ba dene, “Ani nü enü kpa etangu.” ");
INSERT INTO muh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Fü wü *kpara ka Yesu ayia alï gbü *zabu, te engu di gbügbü na. Fü ewü anü sü ka-wü, yo! ace mere bi wü kpara la kpa füh gümba kpala. Wü gara zabu ngbü ta kpah enü kpala. ");
INSERT INTO muh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wüh te ekoro kpa etü mere ngu *Galïlaya la, fü mere wege ayia akpo angbü efe jia ngu la de wazi. Fü zabu angbü eyiki, da efüfü te-ye, ekolo ngu gbü ye. Fü ngu angbü esi gbü zabu la. Zabu la yia ta ebu ewü abu agbü ngu. ");
INSERT INTO muh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu, mü ngbü ka-mü gbü zabu to kpa sidi kpala, era ka-mü ara, o nzö mü ga füh bongo. Fü wü kpara kaka akoro azükü engu, gü ba dene, “Mere kpara! Mere kpara! Ani te ekpi! Ani te ekpi! Te ani kpi la, ngü ena asiti te-ye de?” ");
INSERT INTO muh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Fü Yesu ayia azükü. Fü ah adu arü amala ngü fü wege, gü ba, “Wege, mü nga enga! Ngu, mü ngbü ziii.” Fü wege ayia anga. Fü ngu ayia angbü ziii. Fü sü ayia anga ꞌduwa ngbiii. ");
INSERT INTO muh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Fü Yesu adu arü amala ngü fü wü kpara ka-ye, gü ba dene, “Yi ekpe neh cürü ne? Yi to maguma yi fere mbi mbi la de? Ah le de yi to maguma yi fere.” ");
INSERT INTO muh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Fü cürü arï te ewü afa sü, teka ngü ka wazi ka Yesu la. Fü ewü angbü da eyi-ta tete-wü, gü ba dene, “Apa! De bane neh ene ngü ne? Kpara ladü füh kotö ne, te tï amala ngü fü wege bete mere ngu, fü ewü aje rïrï kaka-na baka e la?” Dela ngü ta te Yesu mere, te engu to rïrï fü mere wege tete. ");
INSERT INTO muh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","2","Fütanga ngü la, fü wü Yesu ayia anü de *zabu la, anü akoro kpa etangu mere ngu *Galïlaya. Fü ewü ayia akö, akoro kpa füh gümba, gbü tö ka wü Garasa. Fü ewü amaka gara komoko kpala, de *siti wü di enga me guvu ye, te ewü mere engu, o ba mürü maröfö. Komoko la koro ka-ye kpa esüka wü mbükü, ");
INSERT INTO muh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","angü ah ngbü era ka-ye etü wü mbükü. Wüh ngbü ta ei engu ai de ku-se, edü wü kengbe gbü lölö na ꞌburu. Fü engu akolo ku-se la, akukuru wü kengbe la kpah ꞌburu asidi. Teka ne de, angü nda-ka wazi fa nda wü kpara ꞌburu. Kpara te tï ai engu nda tïne ma. ");
INSERT INTO muh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Komoko la ngbü ta endoro kpa füh wü da, enzö wü gümba, da endoro etü wü mbükü, eku gba biti de ra, da edütü te-ye de teme. ");
INSERT INTO muh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Fü komoko la ayia awu Yesu nengete. Fü ah ayia ale woro, akpe akoro kpaka Yesu, abu nzökuta ye kötö engangagira, andaꞌba te-ye fefe. ");
INSERT INTO muh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Fü Yesu arü amala ngü fü wü *siti wü di enga me, te ewü ngbü emere komoko la, gü ba dene, “Wü ce engu ace!” Fü komoko la aba rere kpa tikpi, de mere ri ye, gü ba, “Yesu, Ye Mere Me, ye ce ni ace! Tima ka-ni gbü ngü ka-ye nda ma. Ni kïna ye eyi te ïrï Me, gü ba, ye mere e ato cïnga te ni de!” ");
INSERT INTO muh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Fü Yesu ayi-ta komoko la, gü ba, “Ïrï ye neh da?” Komoko la ga, “Ïrï ni de Bi-nzö-gü.” Ah gü ïrï ye bala, angü wü di enga me la sibi guguvu fa sü. ");
INSERT INTO muh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Fü wü di enga me la afüwa te-wü fü Yesu, gü ba dene, “Ye mere e aliki ani te sü ne asidi de.” ");
INSERT INTO muh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Gara wü mba ka kötï ta ladü sela, mere bi ewü baka kutu ꞌbasu (2,000). Wüh ngbü ka-wü füh mere gümba da ezü e ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Fü wü di enga me la afüwa te-wü fü Yesu, gü ba, “Ye tima ani kpaka wü mba la, de ani nü rï guvu ewü.” ");
INSERT INTO muh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Fü Yesu ayia ale ngü ka-ewü la. Fü wü di enga me la ayia akoro guvu komoko la asidi, ace engu, akpe arï aguvu wü mba la. Fü wü mba la ayia ka-wü, yurrru! de mere woro, ago kpa esa gö. Fü ewü agürü agbü mere ngu, anzö ngu, akpi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Te wü kpara, de te ewü ngbü eceka kpï fütanga wü mba la, wu ngü la bala, fü cürü amere ewü. Fü gara ewü akpe de woro, anü amala nga ngü, te Yesu mere la fü wü kpara agbü mere kötï, bete wü sü edede la ꞌburu. Te wü kpara la je ngü la bala, fü ewü ayia anü akoro gbü sü la, teka aceka ngü la cu de jia wü. ");
INSERT INTO muh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Te wüh koro kpala, fü ewü amaka komoko, ta te di de mere bi wü di enga me guvu ye ne, nzönzö na fü te-ye tïne, koro eyi mbi. Ah to bongo kpah eyi te-ye. Fü ah adu angbü ka-ye kötö ede wü Yesu. Fü wü kpara angbü de mere cürü, gü ba, “Dela sirimbi!” ");
INSERT INTO muh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Fü wü kpara te ewü wu ngü la cu de jia wü ne, fü ewü ayia amala nga ngü la fü wü bu wü, gü ba, “Yesu liki wü di enga me guvu komoko ne eyi asidi. Fü wü di enga me la ayia arï aguvu wü mba ka kötï. Fü wü mba la akpe atï ꞌburu agbü ngu, akpi kpala.” ");
INSERT INTO muh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Fü wü kpara la aci ꞌburu, amala ngü fü Yesu, gü ba, “Ye yia sene eyia, ye ce sü ka-ani, de ye nü kpa gbü gara sü.” ");
INSERT INTO muh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Fü wü Yesu ayia alï gbü *zabu, de ani nü. Fü komoko, de te *siti wü di enga me koro guguvu na ne, ayia ayi-ta Yesu, gü ba dene, “Ni ele de ani nü ka-ani ake ye.” ");
INSERT INTO muh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu le nda de, gü ba, “Aꞌa. Ye du edu kpa gba wü, kpaka wü mürü ye, de ye mala nga züka ngü te Me mere fü ye ne, angü Me wu cïnga ka-ye eyi fanü.” ");
INSERT INTO muh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Fü komoko la ayia adu ka-ye, angbü endoro gbü nga nzö kötï de ïrï ye Dekapoli, adi emala nga ngü te Yesu mere fü ye ne. Fü ngü la aga gbü jia wü kpara de kpala afa sü. ");
INSERT INTO muh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Fütanga ngü la, fü wü Yesu adu alügü nga wü kpa etangu mere ngu *Galïlaya. Fü mere bi wü kpara aci akoro, abiti te-wü kpaka Yesu era ngu kpala. ");
INSERT INTO muh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Gara komoko ta ladü kpala de ïrï ye Yayïrü. Engu ta de mere kpara te ngbü emere tima kpa *esambü ka biti-te. Te Yayïrü wu Yesu tete, fü engu ayia akoro, atï eri lö Yesu, ");
INSERT INTO muh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","andaꞌba te-ye fefe, gü ba dene, “Mere kpara deyï, ye koro, ye küwa ye ni, mba jaji würüse, angü keke ngbü emere engu efa sü. Ah yia eyi ekpi akpi. Ye koro la, de ye o kpa ye eküküte na, de ah küwa.” ");
INSERT INTO muh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Te Yesu je ngü la, fü ewü ayia anü de wü Yayïrü. Fü mere bi wü kpara aci anü kpah gbü nga ewü, enzinzi te-wü, da ededere Yesu. ");
INSERT INTO muh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amba gara mürü keke ta kpah ladü sela. Ah de gara würüse, te ngüte ngbü ego tete gbü wü sïkpï ꞌburu. Ah mere engu eyi bala teka wü re nzükpa de füh ye ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ngü la ngbü ta eto mere cïnga fü würüse la efa sü. Ah ngbü ta enü kpaka mere bi wü mürü kuwa, eto mere bi jiase fü ewü, de wüh küwa ni. Wüh to rü fefe ma. Wüh küwa engu nda-wü kpah de. Fü keke la angbü fï ega ngü, enü kpa engagira nü. Fü jiase anza esasaka na ꞌburu, teka keke la. ");
INSERT INTO muh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Te würüse la je nga Yesu, gü ba, “Engu koro eyi sela ne,” fü ah ayia anü kpala. Te engu koro kpala, fü ah ayia azi te-ye ꞌbïlï ꞌbïlï, esüka mere bi wü kpara la, anü amofo mö bongo ka Yesu to kpa ekükürüfe. ");
INSERT INTO muh_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Angü ah fï, gü ba, “Te ni mofo bü mö bongo ka Yesu la, ni ena aküwa.” ");
INSERT INTO muh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Würüse la bü te emofo bongo ka Yesu bane, ꞌduwa fü ngüte la ayia akolo. Fü würüse la adu awu, gü ba, keke ka-ni nza eyi. ");
INSERT INTO muh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu, fü mü awu emaguma mü, gü ba, gara kpara mofo bongo ka-ni eyi, angü wazi ka-ni, de te Me to fü ni ne, mere tima eyi. Fü ah arü, afü te-ye, gü ba, “E-mofo bongo ka-ni neh da?” ");
INSERT INTO muh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Fü wü kpara kaka amala ngü fefe, gü ba dene, “Mere kpara, ye ena angbü eyi-ta ngü bala ne, ye wu mere bi wü kpara, te ewü ngbü egbene sü agbene, ne de? Fü ye adu ayi-ta ngü, gü ba, ‘E-zoro bongo ka-ni neh da?’ ” ");
INSERT INTO muh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Fü Yesu angbü fï bü da eceka kpï ede ye, egïrï kpara te mofo bongo ka-ye ne. ");
INSERT INTO muh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Te würüse la wu, gü ba, keke ka-ni nza eyi ne, fü ah ayia akoro de mere lümü, atï eri lö Yesu, da eyï ayï de cürü, afüwa te-ye fü Yesu, gü ba dene, “Ah de ni, ni mofo bongo ka-ye me-ni, fü keke ka-ni anza dene.” ");
INSERT INTO muh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu gü ba dene, “Enga ra, mü küwa eyi fï badi, teka te mü to maguma mü eyi fere. Mü nü enü de gu maguma.” ");
INSERT INTO muh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Baka te Yesu ngbü emala ngü fü würüse la, fü wü kpara gba Yayïrü, te mbarase kaka ngbü eke ake ne, akpe akoro. Fü ewü amala ngü fü Yayïrü, gü ba dene, “Yayïrü deyï, ah nza eyi. Ye mere e ambü mere kpara la tïne de, angü mbarase ka-ye ne kpi eyi.” ");
INSERT INTO muh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amba Yesu, mü le ngü ka-ewü la nda-mü de. Fü mü adu amala ngü fü Yayïrü, gü ba dene, “Yayïrü deyï, ye kpe cürü de. Ye to maguma ye fü ni.” ");
INSERT INTO muh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Fü wü Yesu ayia de wü Petero, *Yakobo bete *Yüwane, anü kpa gba Yayïrü. Fü ewü ace mere bi wü kpara la sidi nga wü, angü Yesu le de bi wü kpara la nü fa nga ni kpala tïne de. ");
INSERT INTO muh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Te wüh nü koro agba Yayïrü, fü ewü amaka mere bi wü kpara kpala, da eku mere siti gba, de wü yiyi. Dela gba nda tïne de! ");
INSERT INTO muh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Fü Yesu adu arü amala ngü fü wü kpara la, gü ba dene, “Wü ngbü eku gba neh teka ne? Mbarase la kpi akpi nda de. Ah ngbü era ka-ye ara.” ");
INSERT INTO muh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Fü ewü aci ꞌburu angbü emü engu, gü ba, “Dene ne töndö ngü ne?” Fü Yesu ayia aliki ewü ꞌburu etanü, aza ꞌduwa wö ye mbarase, ake ni ye na, bete wü Petero de wü bu ye, te ewü koro de ewü ne. Fü ewü ayia arï te sü, te wüh o kö mbarase la tete. ");
INSERT INTO muh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Te wüh koro kpa esambü la, fü ewü ayia awu kö mbarase. Fü Yesu ato kpa ye, azoro kpa mbarase di, aï mbarase la, amala ngü fefe gbü ngü mündü ka-wü, gü ba, “Talïta gumi!” Ah ba e te ewü gü ba dene, “Jaji würüse deyï, ye yia eyia tikpi.” ");
INSERT INTO muh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Fü jaji würüse la azükü, ayia cukuru atikpi da endoro. Angü mbarase la, re kaka-na koro eyi nzükpa de füh ye ꞌbasu. Fü Yesu amala ngü fü ewü, gü ba dene, “Wü mere e amala nga ngü la fü wü bu wü fa fa fa de.” Fü ah adu amala ngü fü wü wö ye mbarase la, ake ni ye na, gü ba, “Wü mere kümü, wü to fü mbarase la.” Dela ngü ta te Yesu küwa ye Yayïrü di. Fü ngü la aga gbü jia wü kpara afa sü. ");
INSERT INTO muh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Gbü gara ra, fü Yesu ayia de wü kpara ka-ye, ace sü era mere ngu *Galïlaya, adu anü agbü kötï ka-wü, ta te engu ga gbügbü na ne. ");
INSERT INTO muh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Fü *sïkpï ka Me amaka ewü kpala. Fü Yesu ayia anü arï kpa *esambü ka biti-te, akpo da arï wü kpara kpala. Fü bi wü kpara angbü da eje ngü gögömö na. Fü ngü la aga gbü jia ewü afa sü. Fü ewü angbü da emala ngü esüka wü, gü ba dene, “Angü komoko ne maka de mere kpeke rïrï de bane neh kaye? Mere kpeke ngü ka talara, te engu ngbü emere kpa te gara sü ne, e-to wazi la fefe na neh da? ");
INSERT INTO muh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Te engu di kpah bü de kpara, te ngbü eforo rü de sene ne? Te ni ye na di kpah bü de *Marïya ne. Ani wu wü di enga ni ye na kpah kpo ne, wü *Yakobo, *Yüsefa, Yudi, bete Sïmüna, abe kpah te wü jaji würüse, te ewü di ꞌburu wü kpara de sene ne. Te di bala, Yesu maka de nda-ye wazi de bala neh kaye?” Teka ngü la, wüh le ngü kaka nda-wü ꞌburu ꞌburu de. ");
INSERT INTO muh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Fü Yesu adu arü alügü ngü fü ewü, gü ba dene, “Te mü de *mürü dofo la, wü kpara gba yi tï acu ngü mü nda-wü de. Amba ꞌduwa agbü gara wü sü fü wü kpara angbü ecu ngü mü. Dela si-ngü te yi le acu ngü ra tete na nda-yi de ne.” ");
INSERT INTO muh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Teka ngü la, ah tï fü Yesu amere kpeke wü ngü ka talara kpa gbü sü ka-wü la nda de, angü wü kpara de kpala, de wü mürü ye na, wüh le ngü kaka-na nda-wü de. ꞌDuwa mba wü mürü keke biri biri, te engu ngbü eo kpa ye gbü nzö ewü, fü keke ka-ewü angbü enza. ");
INSERT INTO muh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Dela ngü ta te mere Yesu, gbü sü ta te engu ga gbügbü na. Fü ngü la aga gbü jia Yesu afa cu sü, angü wü kpara kpa gba ewü la le ngü kaka nda-wü de. Fütanga ngü la, fü Yesu angbü endoro gbü wü kötï kpala ꞌburu nde, da erï wü kpara de to ngü ka Me. ");
INSERT INTO muh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Gbü gara ra, fü Yesu aï wü kpara ka-ye, nzükpa de füh ye ꞌbasu ne kpaka ye, angü ah le atima ewü, teka anü amala to ngari Me agbü wü gara sü. Fü engu ato wazi fü ewü, teka fü ewü adi eliki *siti wü di enga me di, de wü muruyi. Fü ah ayia atima ewü ꞌbasu ꞌbasu, ");
INSERT INTO muh_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","gü ba dene, “Yi nü enü, yi mala ngari ra fü wü kpara. Te yi te enü la, yi mere e aza mere bi wü e esaka yi de. Yi za ambata kpah de. Yi za kombo kpah de. Yi za jiase kpah de. Yi za ꞌduwa ngbangba esaka yi, fü yi anü di. ");
INSERT INTO muh_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yi mere e ato bongo eküte yi ꞌbasu ꞌbasu kpah de. Yi to bü mba kamaka gbü lö yi. ");
INSERT INTO muh_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mene sü te yi ena anü akoro gbügbü na, te wü kpara la za yi eyi gbü mürü, de yi ngbü nzö gba kpara biringbö la, zalü gbü sïkpï te yi ena ayia anü sü tete. ");
INSERT INTO muh_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Mene sü te ewü le ngü ka-yi gbügbü de, yi mere e angbü sela de. Yi yia sela, de yi bunda zu-tö ka kötï ka-ewü la, te lö yi asidi, ciki sela, de wüh wu ngü la, teka agü tamu ngü la fü ewü, gü ba dene, ‘Me le ngü ka-wü de, angü wü le ngü wü kpara ka-ni, Me, kpah de.’ ” Dela ngü te Yesu mala fü wü kpara ka-ye, te engu tima ewü ne. ");
INSERT INTO muh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Fü wü *kpara ka Yesu la ayia anü sü, abaya, angbü da emala ngari Me fü wü kpara, gü ba, “Wü ce *siti ngü ka-wü asidi. Wü fü maguma wü, adu ale ngü ka Me.” ");
INSERT INTO muh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Fü ewü amaka mere bi wü kpara, de siti wü di enga me guvu ewü. Fü ewü aliki siti wü di enga me la guvu ewü asidi. Fü ewü amaka kpah mere bi wü mürü keke. Fü ewü afuru mü gbü nzö ewü. Fü ewü ayia aküwa. ");
INSERT INTO muh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Gbü wü re engu la, Anïtïpa *Erode ta de mere miri ka wü *Galïlaya. Gbü gara ra fü miri la aje nga Yesu. Angü ïrï Yesu wü ka-ye eyi gbü wü sü la ꞌburu. Fü wü kpara angbü eyi-ta tete-wü, gü ba, “Apa! Yesu mbi mbi neh da?” Wü gara ga, “Engu de *Yüwane Mürü Babatïza, ta te wüh mörö engu ne. Ah zükü me-ye gbü kpi. Teka ngü la, fü engu angbü emere wü kpeke ngü ka talara.” ");
INSERT INTO muh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Gara kpara gü ba, “Engu de gara *mürü dofo, baka wü mürü dofo ta te ewü ngbü emala ngari Me gügü ne.” Gara gü ba dene, “Wayi! Engu de mürü dofo *Ïlïya.” ");
INSERT INTO muh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Te Miri Anïtïpa Erode je nga Yesu, fü ah akpe cürü, angbü de mere fïngangü, gü ba, “Wayi, komoko la, ah de Yüwane, ta te ni mörö engu ne. Ah zükü me-ye gbü kpi.” ");
INSERT INTO muh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Angü Yüwane kpi ta kükürü nda de. Ngü ladü gbügbü na. Miri Anïtïpa Erode mörö Yüwane ta me-ye, teka ngü ka wara ye, de ïrï ye Erodïya ne. Angü miri la fa ta würüse la esaka gara enga ni ye, de ïrï ye *Fïlïpo. Fü ah adu aza engu wara ye tete. Teka ngü la, fü Yüwane ayia amala ngü fü miri la, gü ba, “De-ye deyï, ngü te ye mere la, ah de siti ngü. Ye fiti wara enga ni ye baye? Ah tï ta fü ye amere bala de. Angü dela siti ngü gbü jia Me!” Teka ngü la, fü miri la ayia azoro Yüwane, agü gbü ku. Erodïya, fü mü aje kpah ngü la, ati ngü la guvu mü. Fü mü akpo da egïrï kaje de ni mörö Yüwane asidi. Mü maka de, angü watï mü le de. ");
INSERT INTO muh_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Miri la ngbü ekpe cürü, angü ah wu eyi, gü ba, Yüwane de züka kpara ka Me. Te di bala, fü ah angbü egïrï kaje teka aküwa Yüwane esaka wara ye. Ah le ta de ni di eje ngari Me gömö Yüwane, angü ngü la reke tete na areke. Amba gara mamaguma le nda de, angü ngü la ngbü kpah esiti fïngangü kaka asiti. ");
INSERT INTO muh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amba, Erodïya, mü ngbü fï bü egïrï kaje, amörö Yüwane tete na. Gbü gara ra, fü mü ayia amaka kaje engu ne. Angü watï mü mere mere karama ka-ye, teka afï nga sïkpï te wüh yaka engu tete na. Fü ah ayia aï cögbörö wü kpara ka-ye, de wü nzö-gü ka-ye, de wü mere kpara ka Galïlaya ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fü Erodïya ayia atima enga ye, jaji würüse, de ah nü, ah lo bï engagira miri, de wü ngba ka-ye. Fü jaji würüse la akpo da elo bï, elo bï ꞌduwa ba-neh-ene-la. Fü bï kaka ayia areke gbü jia miri de wü ngba ka-ye afa sü. Fü miri ayia amala ngü fü jaji würüse la, gü ba dene, “Enga ni, ngü ka-ye reke gbü jia ani fa sü. Te di bala, ni ena ato fü ye neh ene?” ");
INSERT INTO muh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Fü miri la ayia akïna te-ye gbü jia wü kpara ꞌburu, gü ba, “Mene e te ye ngbü ele, de ye yi-ta ni tüngüngü, ni ena ato ato fü ye. Ni tï atïrï de. Te ye le kpah de ni ye süka sü ka-ni fü ye la, ni ena aye aye.” ");
INSERT INTO muh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Fü jaji würüse la ayia akpe kpaka ni ye, ayi-tata, gü ba dene, “Ni ni deyï, mene e te ye le de ni yi-ta miri tekaka, de ah to fü ni, neh ene?” Ni ye na gü ba, “Enga ni deyï, ye mala fü miri de ah tima kpara, ah nü, ah mörö Yüwane Mürü Babatïza. De ah wa nzönzö na, ah koro di fü ye, teka fü ani awu, gü ba dene, Yüwane kpi eyi fanü.” ");
INSERT INTO muh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Fü jaji würüse la ayia akpe adu kpaka miri, amala ngü fefe, gü ba dene, “Wayi, mere kpara, ngü te ni le, ah dene. Ni ele de wüh mörö Yüwane asidi. Fü ewü awa nzönzö na, ao gbü gada, akoro di, ato fü ni enatikine.” ");
INSERT INTO muh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Fü ngü la asiti gbü jia Miri Anïtïpa Erode afa sü. Amba teka ngü ka kïna, de te engu kïna te-ye di, gbü jia wü ngba ka-ye ne, ah le ace kïna ka-ye la tïne de, ka vi-jia. ");
INSERT INTO muh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Te di bala, fü ah ayia atima marajümïya ka-ye, gü ba, “Ye nü, ye koro de nzö Yüwane.” Fü marajümïya la ayia anü agbü ku, ade ngürü Yüwane, akolo gbö! ");
INSERT INTO muh_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","aza nzönzö na, ao gbü gada, akoro di, ato fü jaji würüse la. Fü jaji würüse la aza nzö Yüwane, ayia anü di, ato fü ni ye. ");
INSERT INTO muh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dela ta ngü te Yüwane Mürü Babatïza kpi tete. Te wü kpara kaka-na je ngü la, fü ewü akoro, abï kökö na, anü di, ati. Dela si-ngü te Miri Anïtïpa Erode kpe cürü Yesu tete, gü ba, engu de Yüwane Mürü Babatïza, te zükü me-ye gbü kpi. ");
INSERT INTO muh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Fütanga ngü la, fü wü *mürü tima ka Yesu, ta te engu tima ewü ne, adu akoro kpaka Yesu. Fü ewü akpo amala nga ngü ꞌburu, te ewü ngbü mere kpala, kpah de ngü te ewü ngbü rï wü kpara di. ");
INSERT INTO muh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Fü mere bi wü kpara aci abiti te-wü kpaka ewü la, wü gara da ekoro, wü gara da ego. Da sü te wü Yesu ena azü e tete ma, da fe te-wü kpah ma. Te di bala, fü Yesu adu arü amala ngü fü wü mürü tima ka-ye ne, gü ba dene, “Ani nü la mba afe te-ani kpa te gara sü, te wü kpara di tete ma.” ");
INSERT INTO muh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Fü ewü ayia alï gbü *zabu, anü kpa te gara sü te kötï di tete ma. ");
INSERT INTO muh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Te wü mere bi wü kpara la wu, gü ba, wü Yesu nü sü eyi kpala, fü ewü aci ꞌburu, anü de woro, afa nga Yesu. Amba wüh le nda-wü kaje de lö wü to kpa füh gümba. Fü ewü akpe akoro agbü sü, te wü Yesu enü tete na ne, fi me-wü. ");
INSERT INTO muh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Te wü Yesu nü koro gbü sü la, fü ewü amaka mere bi wü kpara kpala kpah gbe. Fü cïnga ewü arï te Yesu, angü wüh ngbü gbü jijia baka wü kambiliki, te kpara di gbü nga ewü ma. Fü ah ayia akpo erï ewü de mere bi wü ngü, zalü koro di etamurago. ");
INSERT INTO muh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Etamurago la, fü wü kpara ka Yesu ayia akoro amala ngü fefe, gü ba dene, “Mere kpara deyï, ye ceka la, ra te etï dene! Ani ena amere baye, teka wü mere bi wü kpara ne? Tala mere ewü de? Te sü di kpakine edere sü, kötï kpah ma ne. ");
INSERT INTO muh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ah le ta de ye mala ngü fü ewü, de wüh nü kpa gbü gara kötï, agïrï e, ase, azü.” ");
INSERT INTO muh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu gü ba dene, “Yi ena ato zü-e fü wü kpara la me-yi.” Wüh gü ba, “Apa! Wü kpara la sibi fa sü! Ani ena amaka mere bi zü-e, tüngü wü kpara la, neh kaye? Anga ani ena ase e la neh de jiase fe? Ah ba e te mü ena amere tima teka re biringbö, fü mü amaka jiase la.” ");
INSERT INTO muh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu gü ba, “Ambata esaka wü sela neh fe? Wü nü la, wü ceka.” Fü ewü ayia anü aceka, amaka ambata ngbee ꞌburuve, bete si ꞌbasu. Fü ewü adu amala nganga na fü Yesu. ");
INSERT INTO muh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ta gbü sü la, züka fu-gü ladü fula fula, bane. Fü Yesu adu arü, amala ngü fü wü kpara ka-ye, gü ba dene, “Wü biti wü kpara la tundu tundu, de wüh ngbü la kötö, füh gü sene.” ");
INSERT INTO muh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Fü ewü ayia abiti te-wü gbü wü da-sü ka-wü, gara ewü kama biri (100), wü gara ewü teke ꞌbasu de füh wü nzükpa. ");
INSERT INTO muh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Fü Yesu aza ambata ꞌburuve bete si ꞌbasu la, ayia aceka kpï kpa tikpi, agbo nga ïrï Me teka zü-e la. Fü ah ayia akukuru tü wü ambata la, aza ato esaka wü kpara ka-ye, de wüh gafa fü wü kpara ꞌburu. Fü ewü adu agafa wü si kpah bala. ");
INSERT INTO muh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Fü wü kpara aci ꞌburu, azü e la, asika nde. ");
INSERT INTO muh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Fü wü *kpara ka Yesu ayia aro du zü-e la, asi gbü wü kuwu nzükpa de füh ye ꞌbasu. ");
INSERT INTO muh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dela ngü ta te Yesu mere, te engu to zü-e di fü mere bi wü kpara. Wü kpara te ewü zü e la, wüh baka wü komoko kutu ꞌburuve (5,000). ");
INSERT INTO muh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Fütanga ngü la, fü Yesu ayia amala ngü fü wü kpara ka-ye, gü ba dene, “Wü za *zabu eza, anü nda-wü kpa engagira nü, kpa etangu, kpa gbü Betesayïda. Nda-ni, ni la ece kpa te bi wü kpara ne, de wüh go agba wü feke. Fü ni adu afa nga wü.” Fü wü *kpara ka Yesu ayia alï gbü zabu, anü sü. ");
INSERT INTO muh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Fü Yesu ato mandï fü mere bi wü kpara la. Fü ewü abaya, ago agba wü. Fü Yesu ayia anü kpa enzö mere rüvü kpikpi ye, angbü kpala, da eku gba fü Me. ");
INSERT INTO muh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Fü du ra la atï te Yesu, kpa enzö rüvü la kpikpi ye, o wü kpara kaka di nda-wü nengete, kpa etü ngu gbü zabu. ");
INSERT INTO muh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ah te ekoro emözekpï, o kpï seke nza la de, fü Yesu ayia aceka kpï, awu wü kpara ka-ye, te ewü ngbü embü ambü ka mere wege. Angü wege la ngbü enzi ewü, elügü kpa sidi. Fü Yesu ayia, de ni nü kpaka ewü la. Amba wüh ka-wü nengete etü ngu. Fü ah ayia angbü enü de lö ye füh ngu. Fü ah anü, anü akoro gbamari ede zabu la. ");
INSERT INTO muh_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Fü ewü ayia awu engu da enü füh ngu de bala, wüh gü ba, “Dela sirimbi!” Fü mere cürü ayia arï te ewü. Fü ewü afï nda-wü, gü ba, “Dela kuru kpara, te koro gbü mbükü!” Fü ewü ayia aba rere ka cürü kpa tikpi, angü wüh wu, gü ba, ah de Yesu ne, nda-wü de. Fü Yesu akoro amala ngü fü ewü, gü ba dene, “Yi gu maguma yi agu. Yi kpe cürü de, ah ka-ye de-ra.” ");
INSERT INTO muh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Fü ah ayia alï kpaka ewü agbü zabu. Fü mere wege, te ngbü emere ewü la, ayia anga. Dela ngü ta te Yesu mere te engu nü tete na de lö ye füh ngu. Fü ngü la aga gbü jia wü kpara kaka-na ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Angü wüh wu si-ngü gbü ngü ta te engu mere, te engu to zü-e fü wü mere bi wü kpara la, nda-wü de. Nzö ewü kpekpeke, angü wüh to maguma wü fü Yesu mbi mbi la de. ");
INSERT INTO muh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Fü wü Yesu ayia akö ngu kpa etangu, akoro gbü gara sü de ïrï ye Genezareta. Fü ewü ai zabu ka-wü, ace edere ngolo sela. ");
INSERT INTO muh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wüh te ekoro kpala, fü wü kpara aci ꞌburu awu, gü ba, Yesu koro eyi. ");
INSERT INTO muh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Fü ewü ayia abaya, akpe de woro kpa gbü wü gara kötï kpala ꞌburu nde, amala nga ngü la fü wü kpara ꞌburu. Fü ewü akpo da ebï wü mürü keke de darara ka-wü, enü de ewü kpa te sü te ewü je, gü ba, Yesu ladü tete na. ");
INSERT INTO muh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gbü wü sü ꞌburu te Yesu ngbü ekoro tete na, agbü wü mere kötï, bete wü jürü kötï edere sü ne, wü kpara ngbü ebï wü mürü keke ka-wü, ekoro di, eo gbü ngambasü. Fü ewü angbü da efüwa te-wü fü Yesu, gü ba, “Ani ele amofo bü mba mö bongo ka-ye, de ani küwa.” Wü kpara ta te ewü ngbü emofo mö bongo ka Yesu ne, fü ewü angbü eküwa, gbü keke ka-wü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Gbü gara ra, fü wü Yesu amaka te-wü de wü *Farusi, de wü gara wü *mürü rïrï, te ewü koro kpa gbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Wü Farusi le rïrï ka gele ka-wü fa sü. Angü gele ka-ewü teka azürü e, ah fa sü. Te mü le azü e, mü ena azürü kpa mü gbü gara kaje kpikpi ye. Te mü koro da ese e, mü ena azürü kpa mü kpah gbü gara kaje kpikpi ye. Gele teka azürü ndüꞌba ka-ye kpikpi ye. Gele teka azürü sila kpah kpikpi ye. Gele teka azürü e, te wüh mï gbü se kpah kpikpi ye. Dela gele ka wü kundu kundu wü *Yïsarayele, ta te wü Farusi le fa sü. Te mü mere bala de, wüh gü ba, “Ah esiti gbü jia Me.” Te wü Farusi la koro kpaka Yesu, fü ewü awu kaje te wü *kpara ka Yesu ngbü ezürü kpa wü di, teka azü e ne, ah baka rïrï ka gele ka-ewü, ka wü Yïsarayele, nda de. Fü ewü adu ayi-ta Yesu, gü ba dene, “Ah mere baye te wü kpara ka-ye ne ngbü ezü e de libiti te kpa wü de bala? Wüh ce gele ka wü kundu ani, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu gü ba dene, “De-yi deyï, yi ngbü ele gele ka wü kundu nih efa sü bala, neh teka ne? Yi de wü mürü mani! Fanü fanü, *mürü dofo Yïsaya wu mani ka-yi la eyi gügü. Angü Me mala ta ngü la gögömö na, gü ba dene, ‘Ni le ngü ka wü mürü mani la de. Angü wüh ngbü egbo nga ïrï ni nda-wü bü de komö wü kükürü, amba maguma ewü le ni nda de. ");
INSERT INTO muh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wüh ngbü egbo nga ïrï ni, da erï wü kpara, gü ba, “Ani ngbü eto *Rïrï ka-ni, Me, fü wü kpara.” Amba dela Rïrï ka-ni nda de. Ah ka-ye de kükürü gele ka wü kundu wü.’ Dela ngü ta te Me mala gömö Yïsaya teka yi.” ");
INSERT INTO muh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","9","Fü Yesu adu amala gara ngü fü ewü, gü ba dene, “Rïrï ka Me, ta te engu to fü yi ne, yi le aje de, neh teka ne? Yi ngbü ele ꞌduwa rïrï ka gele ka wü kundu yi. Dela neh züka ngü? ");
INSERT INTO muh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Angü *Müse to ta *Rïrï ka Me fü yi, gü ba dene, ‘Ah le fü mü adi ecu ngü wö mü ake ni mü, da eje rïrï ka-ewü.’ ‘Mene kpara te ngbü efala wö ye ake ni ye, ah le de wüh mörö engu amörö asidi.’ Dela eyi Rïrï ka Me. ");
INSERT INTO muh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Nda-yi, wü *mürü rïrï, yi ce ngü ka Me la teka gara gele ka-yi de ïrï ye korobana ne. Korobana la, ah baka e te kpara kïna te-ye, gü ba dene, ‘Ni le ato e fü wü wö ni ake ni ni tïne de. Ni ena ato e la fü Me.’ Dela e te ewü gü ba, korobana. ");
INSERT INTO muh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Te kpara la du ngbü cüküꞌdaye, fü mamaguma ayia agu, fü ah akoro kpaka yi, wü mürü rïrï, gü ba, ‘Ni le areke kïna te ni kïna te-ni di la asidi,’ yi le nda-yi de. Yi gü ba, ‘Kpara la mere e ace kïna ka-ye la de.’ Fü kpara la ayia ace wü wö ye de wü ni ye ꞌburu gbü cïnga teka ngü ka-yi la. ");
INSERT INTO muh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gbü ngü la, yi ngbü ece *Rïrï ka Me asidi, ao gele ka wü kundu nih kpa engagira nü. Angü fanü fanü mere bi wü ngü ladü te yi ngbü emere kpah ba e la.” Dela ngü ta te Yesu mala fü wü mürü rïrï la. ");
INSERT INTO muh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Fü Yesu adu arü amala ngü fü wü kpara ꞌburu, gü ba dene, “Yi je la ngü te ma ngbü emala fü yi ne mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ngü te ena asiti mü gbü jia Me, ah de ne ngü ne? Ah ena adi de zü-e te mü ngbü ezü? Ah bala de. Ah ena adi ꞌduwa *siti ngü te mü ngbü efï emaguma mü, ah ena asiti mü gbü jia Me me-ye. ");
INSERT INTO muh_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Te güje mü ladü, de mü da güje mü te ngü te ma mala la.” ");
INSERT INTO muh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Fü wü Yesu ayia ace wü kpara la, arï kpa esambü. Fü wü *kpara ka Yesu akoro ayi-tata na teka ngü te engu mala la, gü ba dene, “Si-ngü la, ah gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu gü ba dene, “Yi kpah bala? Yi je si-ngü la nda-yi kpah de? Zü-e te mü ezü, ah ena asiti mü gbü jia Me, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Angü zü-e nü kpa emaguma mü nda de. Ah enü ka-ye kpa gbü nza mü, anü sü ka-ye agbü gü.” Ngü te Yesu mala la, ah baka e te engu gü ba, zü-e te kpara ezü, ah ꞌburu mbi gbü jia Me. ");
INSERT INTO muh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Fü Yesu agü ba, “Ngü te ena asiti mü gbü jia Me, ah de siti ngü, te mü ngbü efï emaguma mü. ");
INSERT INTO muh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Angü te kpara ngbü de siti fïngangü emaguma ye la, wü ngü te engu ena angbü emere ne, ah ena adi kpah ꞌburu de siti wü ngü. Ah ena amere yala, ah ena afiti wara kiri ye, ah ena amere waza. Gara ena ati ngü guvu ye, asoko kpara, amörö kpara. Gara ena akpi gümü e, amere zü, azi e ka kiri ye. Gara ena acu ngü ye, afiti kiri ye de mani, emere wü gara töndö ngü, te Me le de. ");
INSERT INTO muh_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wü kpara ꞌburu ngbü emere wü ngü de bala, ah teka siti ngü te di emaguma ewü. Dela wü ngü te ena asiti mü gbü jia Me me-ye.” ");
INSERT INTO muh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Fütanga ngü la, fü wü Yesu ace sü la, ayia anü kpa gbü nga nzö kötï ka Tera. Fü ewü anü akoro agba gara kpara kpala. Yesu le ta de wü kpara wu ni nda-wü de. Amba dada na te engu ena awo te-ye nda ma. ");
INSERT INTO muh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Gara würüse ta la kpala, te *siti wü di enga me ngbü emere yïanga, jaji würüse, efa sü. Fü würüse la aje ngü, gü ba, “Yesu koro eyi.” Fü ah ayia anü akoro kpaka Yesu, abuka gbüra ye kötö, ");
INSERT INTO muh_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","andaꞌba te-ye fü Yesu, gü ba, “Mere kpara, ye koro, ye küwa enga ni, aliki siti wü di enga me guguvu asidi.” Amba würüse la de egba Sarüfanisiya, ah de egba *Yïsarayele nda de. ");
INSERT INTO muh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Fü Yesu adu arü amala ngü fü würüse la de mani, gü ba dene, “Te zü-e ladü la, ah le de wüh to la fü wü jaji feke. Angü te wüh za kümü, te wüh le ato fü wü jaji, asötö fi fü wü bürü la, ah de siti ngü.” Yesu mala bala, angü würüse la ka-ye de *ganzi kpara fefe. ");
INSERT INTO muh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Fü würüse la alügü ngü, gü ba, “Wayi, mere kpara, ah ngbürü bala fanü. Anga te wü jaji ngbü da ezü e la, wü bürü ngbü nda-wü fï bü ezü kpokporo na, te ngbü egürü kötö, la de?” ");
INSERT INTO muh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Fü ngü la ayia areke te Yesu afa sü. Fü ah alügü ngü fefe, gü ba, “Wayi, mü lügü ngü la eyi mbi. Siti wü di enga me la ce enga mü eyi. Mü go ego agba mü.” ");
INSERT INTO muh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Fü würüse la ayia ago agba ye, amaka enga ye kpala te ra ka-ye kötö. Siti wü di enga me la ce engu eyi fanü. ");
INSERT INTO muh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Fütanga ngü la, fü wü Yesu ayia agbü nga nzö kötï ka Tera, fü ewü ale kaje ka Sïdona. Fü ewü adu ale kaje ka Dekapoli, anü akoro era mere ngu *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Te wü Yesu koro kpala, fü ewü aza gara komoko te gügüje na di ma, te ro mö mbölö mbölö kpah de, akoro di kpaka Yesu. Fü ewü andaꞌba te-wü fü Yesu, gü ba, “Mere kpara deyï, ye o kpa ye gbü nzö enga ni ani ne, aküwa engu.” ");
INSERT INTO muh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Fü Yesu ayia aza komoko ne esüka mere bi wü kpara la, anü di kpa edere sü. Fü ah ayia aza jikpa ye ato gbü güje komoko la, adu asü ngüsü te jikpa ye, ato te mimi na. ");
INSERT INTO muh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Fü ah arü ae jia ye kpa tikpi, awo wazi, gü ba dene, “Afata,” baka ngü te ewü gü ba, “Gügüje ü te-ye eü.” ");
INSERT INTO muh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Fü güje komoko la ayia aü. Fü mimi na ayia afuru te-ye. Fü komoko la akpo da emala ngü mbölö mbölö. ");
INSERT INTO muh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Fü Yesu adu amala ngü fü wü kpara la kpekpeke, gü ba dene, “De-wü deyï, wü mere e amala nga ngü la fü wü bu wü de.” Amba wü kpara la le aje ngü ka Yesu la nda-wü de. Fü ewü ayia akpo da emala nga ngü la fü wü kpara ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Fü ngü la aga gbü jia wü kpara ꞌduwa ba-neh-ene-la. Wüh gü ba, “Yesu ngbü emere wü ngü ꞌburu ꞌdö mbi. Angü ah ngbü ereke wü kpara ꞌburu. Yi ceka la, wü kpara ta te güje ewü di ma, wüh kpo tïne eyi eje ngü! Wü kpara ta te ewü ro mö de ne, wüh kpo tïne eyi ero mö!” ");
INSERT INTO muh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gbü gara ra, fü mere bi wü kpara adu akoro, abiti te-wü kpaka Yesu gbe. Fü Yesu akpo angbü erï ewü. Fü ewü ara kpala sïkpï bata. Fü zü-e ayia anza esaka ewü. Fü Yesu ayia aï wü kpara ka-ye kpaka ye, amala ngü fü ewü, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Tïtïne cïnga wü kpara ne ngbü erï te ra arï, angü nih ra eyi de ewü sene sïkpï bata dene. Zü-e esaka ewü tïne eyi ma. ");
INSERT INTO muh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Te ma mala ngü fü ewü de wüh go agba wü la, wüh ena andïrï ka-wü andïrï te kaje ka tala, angü gara ewü koro nengete.” ");
INSERT INTO muh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Fü wü kpara kaka-na alügü ngü fefe, gü ba, “Ööö mere kpara, ani ena amaka mere bi zü-e, tüngü wü kpara la, neh kaye? Te ani di kpakine kpa edere sü, kötï sene kpah ma ne.” ");
INSERT INTO muh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu gü ba dene, “Ambata esaka wü sela neh fe?” Wüh gü ba, “Ambata ngbee lorozi.” ");
INSERT INTO muh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Fü Yesu adu amala ngü fü wü kpara la ꞌburu, de wüh ngbü kötö. Fü ah ayia aza ambata la, agbo nga ïrï Me tekaka. Fü ah adu akukuru tü ambata la ꞌburu, aza ato fü wü kpara ka-ye, de wüh gafa fü wü kpara la ꞌburu. Fü ewü ayia aza ambata la, agafa fü wü kpara la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wü jürü si ta kpah ladü esaka ewü mba rooo. Fü Yesu akö wü si la, agbo nga ïrï Me, ato fü wü kpara ka-ye, gü ba, “Wü gafa kpah egafa fü ewü.” ");
INSERT INTO muh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Fü wü kpara la aci ꞌburu azü e la, asika di. Fü wü *kpara ka Yesu aro dudu na gbü wü kuwu lorozi. ");
INSERT INTO muh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wü kpara ta te ewü zü e la, wüh baka wü kpara kutu bala (4,000). Fü Yesu ayia ato kaje fü wü kpara la ꞌburu, de wüh go agba wü. ");
INSERT INTO muh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Fü wü Yesu ayia alï agbü *zabu de wü kpara ka-ye, anü ka-wü kpa etangu, agbü nga nzö kötï ka Dalamanuta. ");
INSERT INTO muh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fütanga ngü la, fü gara wü *Farusi ayia akoro kpaka Yesu de mani, akpo da ekpülü engu de yïkï ka-wü, gü ba dene, “Mere kpara deyï, ye mere la mere lara ngü ka talara fü ani, teka fü ani awu, gü ba, Me tima ye me-ye fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Fü ngü ka-ewü la ake te Yesu afa sü. Fü ah ayia awo wazi, agü ba, “De-yi, siti wü kpara de gbü wü re ne, yi le de ma mere mere ngü ka talara gbü jia ani, neh teka ne? Ngü te ma emala dene, ah de zu ngü. Ma tï amere ngü ka talara gbü jia yi nda-ra de.” ");
INSERT INTO muh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Fü ah ayia ace wü Farusi la, adu alï gbü *zabu de wü kpara ka-ye, anü sü ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","15","Te wü Yesu ngbü ekö mere ngu la tete de *zabu, fü Yesu adu amala gara ngü fü ewü de mani, gü ba dene, “De-wü deyï, wü di eceka te-wü mbi teka ambata ka wü *Farusi bete nda Miri Anïtïpa *Erode, te wüh ngbü emere de *kö ne, angü kö ka-ewü la, ah esiti.” Amba wü *kpara ka Yesu, te yi lï gbü zabu la, to yi ïrï teka aza zü-e fü yi eyi. Yi za bü enga ambata ngbee biringbö. ");
INSERT INTO muh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Te di bala, wüh je si mani te Yesu mala la nda-wü de, angü fïngangü ka-ewü lala fï bü teka ngü ka zü-e. Fü ewü angbü da eyi-ta tete-wü, gü ba dene, “Si-ngü la neh baye? Ah mala ngü la fü ani bala ne, teka te ambata di esaka ani ma ne?” ");
INSERT INTO muh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Te Yesu wu fïngangü ka-ewü bala, fü ah amala fü ewü, gü ba dene, “De-yi, yi ngbü efï ngü bala, neh teka ne? Fïngangü ka-yi la fï bü teka ngü ka zü-e? Ngü te ma mala ne, ah rï gbü nzö yi la fï de? Nzö yi kpekpeke! ");
INSERT INTO muh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Wü ngü te ma ngbü emere, te yi ngbü ewu cu de jia yi ne, ngü la rï gbü nzö yi la fï de? ");
INSERT INTO muh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yi fï la nga ambata ꞌburuve terane, te ma za, kukuru to fü bi wü kpara kutu ꞌburuve (5,000) ne. Yi du ro dudu na, biti gbü wü kuwu neh fe?” Wüh gü ba, “Nzükpa de füh ye ꞌbasu.” ");
INSERT INTO muh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu gü ba, “Anga gara na, te ma za ambata lorozi, ato fü bi wü kpara kutu bala (4,000) ne. Yi du ro biti gbü wü kuwu neh fe?” Wüh gü ba, “Kuwu si lorozi.” ");
INSERT INTO muh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu gü ba dene, “Te di bala, ngü te ma mala fü yi ne, yi je sisi la de, neh teka ne? Ah le de yi wu awu, gü ba, ma tï kpah eyi ato gara zü-e fü yi. Amba ngü ka kö gbü ambata, te ma mala nganga fü yi ne, yi wu sisi na de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Fü wü Yesu anü de *zabu, anü akoro agbü Betesayïda. Te wüh koro kpala, fü wü kpara akoro de gara komoko te jijia na di ma, kpaka Yesu. Fü ewü andaꞌba te-wü fü Yesu, gü ba, “Mere kpara, ye reke la jia enga ni ani ne.” ");
INSERT INTO muh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Fü Yesu ayia azoro kpa komoko la, aza engu, anü di canza kpa edere sü. Fü ah asü ngüsü te jikpa ye, ao gbü jia komoko la. Fü ah ao kpa ye gbü nzö komoko la, gü ba, “De-ye deyï, ye ceka la kpï eceka. Ye te ewu e?” ");
INSERT INTO muh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Komoko ne, jia mü ceka kpï mba cüküꞌdaye, fü mü agü ba dene, “Ni ngbü ewu sü akine mba sawu sawu bala. Wü kpara ngbü gbü jia ni baka wü ndugu rü la.” ");
INSERT INTO muh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Fü Yesu adu kpah ao kpa ye gbü jia komoko la. Fü jia komoko la ayia alofo, raaa! Fü komoko la akpo da ewu wü kpara, de wü e, ꞌburu mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Fü Yesu amala ngü fefe, agü ba dene, “De-ye deyï, ye go ego agba wü. Ye mere e adi endoro agbü mere kötï, anga agba wü kpara ꞌda ꞌda ꞌda de.” Dela ngü te Yesu mere, ta te engu reke jia gara komoko agbü Betesayïda. ");
INSERT INTO muh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Fütanga ngü la, fü Yesu ayia de wü kpara ka-ye, anü gbü wü jürü kötï te di ede Kayïsarïya Fïlïpoyi. Te wüh ngbü enü tete te kaje, fü Yesu ayia ayi-ta ewü, gü ba dene, “Wü kpara ngbü efï, gü ba, ni de neh da?” ");
INSERT INTO muh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wüh gü ba dene, “Wü kpara ngbü efï, gü ba, ye de kpeke kpara. Angü wü gara kpara ngbü emala nda-wü, gü ba, ‘Ye de *Yüwane Mürü Babatïza, te zükü gbü kpi.’ Wü gara gü ba dene, ‘Ye de mürü dofo *Ïlïya.’ Wü gara gü ba dene, ‘Ye de gara *mürü dofo, baka wü mürü dofo ka Me ta gügü ne.’ ” ");
INSERT INTO muh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yesu gü ba dene, “Anga cu de-wü, wü ngbü efï nda-wü, gü ba, ni de neh da?” Petero, fü mü ayia arü, alügü ngü fü Yesu, gü ba dene, “Mü de *Kurisito, Mere Miri, te Me tima teka aküwa a ne!” ");
INSERT INTO muh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Fü Yesu amala ngü fü ewü ꞌburu kpekpeke, gü ba dene, “De-wü deyï, wü mere e amala fü wü kpara, gü ba, ni de Kurisito ne, la de.” ");
INSERT INTO muh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Fütanga ngü la, fü Yesu ayia akpo emala ngü fü wü kpara ka-ye, teka kpi ka-ye, gü ba dene, “Mere cïnga ladü, te ena amere ra. Dela cïnga nda de. Angü ah le de cïnga mere *Ye Kpara ka Kpï bala. Wü *kovo, de wü *mürü gele, de wü *mürü rïrï, wüh le ngü ka-ra nda-wü de. Wüh ena amörö ra, amba gbü *ebabata sïkpï, Me ena adu azükü ra.” ");
INSERT INTO muh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesu mala ngü ka kpi ka-ye la ꞌburu mbölö mbölö. Te Petero je ngü la, fü ah ayia aza Yesu esüka wü bu ye edere sü, amala ngü fefe, gü ba dene, “Ngü la mere e adi bala de.” ");
INSERT INTO muh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Fü Yesu afü te-ye, aceka wü gara kpara ka-ye. Fü ah adu amala ngü fü Petero kpekpeke, gü ba dene, “Mü ce ra de ngü ka-mü ka *Satana la! Angü fïngangü ka-mü la, ah de ngü ka Me nda de. Dela ka-ye siti fïngangü ka wü kpara de füh kotö ne.” ");
INSERT INTO muh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Fü Yesu ayia abiti wü kpara ka-ye, de mere bi wü kpara, ꞌburu te sü biringbö. Fü ah akpo da erï ewü, gü ba dene, “Te mü ele angbü baka zu kpara ka-ra la, mü mere e afï nga wü e ka-mü ꞌburu ꞌdö de. Mü reke te-mü teka kpi ka-mü, baka kpara te ngbü ebï mere *rü gbegbete, te wüh ena abere engu fefeh na, amörö. Fü mü ayia alala gbü nga ra. ");
INSERT INTO muh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Te mü le aküwa te-mü de tete-mü, mü tï aküwa te-mü nda-mü de. Amba te mü ce te-mü, o fü kpi teka ngü ka-ra la, Me ena aküwa mü me-ye. ");
INSERT INTO muh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mü fï la nga kuru mü! Te mü ce ngü ka Me, fü mü adu ato te-mü ꞌburu teka ngü ka kotö ne, da emaka mere bi jiase, de mere bi wü züka e de füh kotö ne ꞌburu la, wü e la ena aküwa mü fanü? Wüh tï aküwa mü nda-wü de, angü mü ce ngü ka Me eyi. ");
INSERT INTO muh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Te di bala, gara e te mü ena ato fü Me, teka afa kuru mü di, ah de neh ene? E nda ma! ");
INSERT INTO muh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mü fï nga *adu sïkpï, te gara, te ma ena adu akoro tete na. Angü de-ra, *Ye Kpara ka Kpï, ma ena adu akoro füh kotö ne, de wazi ka Wüba, de wü *malayïka kaka mini. Te di bala, mü mere e akpe cürü siti wü kpara, de füh kotö ne, nda-mü de. Angü te mü ce ngü ka-ra, teka cürü ewü la, ma ena ace mü kpah ace gbü sïkpï, te ma ena adu akoro tete.” ");
INSERT INTO muh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Fü Yesu adu amala gara ngü fü ewü, gü ba dene, “Ma ngbü emala fü yi dene zu ngü fanü fanü. Wü gara kpara ladü esüka yi sene, wüh tï akpi la de, zalü te wüh ena awu mere wazi, te Me to fere, *Ye Kpara ka Kpï, te ma ena aküwa wü kpara di, ne feke.” Dela ngü ta te Yesu mala fü wü kpara, te ewü le afa nga ye. ");
INSERT INTO muh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Fütanga sïkpï maꞌdiya, fü Yesu ayia aza wü Petero, *Yakobo, bete *Yüwane. Fü ewü anü akoro kpa enzö mere rüvü. Te wüh koro kpala, fü küte Yesu akpo da efü te-ye, da ecï acï gbü jia ewü. ");
INSERT INTO muh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Fü bongo kaka-na avi kpah avi kpïlïlï, angbü da ecï acï baka ra. Kpara te ena azürü bongo, avi akoro di bala, ah nda ma. ");
INSERT INTO muh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wüh te eceka kpï bane de, gbo! te wü kpara ꞌbasu. Ah de wü *Ïlïya ake *Müse, diri wü kpara ka Me ta gügü ne. Fü Yesu angbü da ero mö de ewü. ");
INSERT INTO muh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Fü mere cürü ayia arï te wü Petero. Fü fïngangü ka-wü akpo da endoro ꞌdaaa. Fü Petero ayia amala ngü fü Yesu, gü ba dene, “Mere kpara, sü de sene, ah reke gbü jia ni fa sü. Ah tï ta fü ani angbü sene. Te di bala, ani ena ajï wü gugu bata, nda-ye biringbö, nda Müse biringbö, nda Ïlïya kpah biringbö.” Ah mala ngü la bala, angü ah wu züka ngü, te engu ena amala ne, nda de. ");
INSERT INTO muh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Petero bü te emala ngü la, fü sangu ayia akoro, agba ewü ꞌburu. Fü ri Me awü gbü sangu la, gü ba dene, “Dene zu Ye ra, te maguma ra le engu fa sü. Yi di eje ꞌduwa rïrï kaka-na.” ");
INSERT INTO muh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wüh te eceka kpï bane de, yïrrrï! Wü Müse ake Ïlïya nda-wü tïne ma! Yesu ka-ye bü eyi kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Fü wü Yesu ayia kpa füh rüvü kpala, alügü te-wü, adu kpa esa gö. Te wüh ngbü edu tete, fü Yesu ayia amala ngü fü wü Petero, gü ba dene, “De-wü deyï, wü mere e amala nga ngü la fü wü kpara de, zalü te gara, te ni, Ye Kpara ka Kpï, ena azükü tete na gbü kpi.” ");
INSERT INTO muh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Fü ewü angbü da efï nga ngü la emaguma wü, da eyi-ta tete-wü, gü ba dene, “De bala neh ene ngü ne, te Yesu mala, gü ba, ‘Ni ena azükü gbü kpi ne.’ ” ");
INSERT INTO muh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Fü ewü adu ayi-ta Yesu, gü ba dene, “Mere kpara deyï, wü *mürü rïrï gü ba, ‘*Ïlïya ena akoro feke, teka areke kaje fü Miri te Me ena atima la.’ Te di bala, ngü la ena adi neh baye?” ");
INSERT INTO muh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Yesu gü ba dene, “Wayi, *Ngari Me mala ngbürü bala fanü, gü ba, Ïlïya ena akoro feke, teka areke maguma wü kpara. Amba Ïlïya koro ka-ye ta eyi. Fü siti wü kpara ayia amere engu, de mere siti ngü ka-wü, kpah baka e ta te wü *mürü dofo ba gbü *Ngari Me tekaka ne. Kpah bala, wü mürü dofo ba ta teka ni, *Ye Kpara ka Kpï, gü neh fe? Wüh gü ba, ‘Wü kpara ena ato kpah mere cïnga te ni, da efala ni.’ ” Dela ngü ta te Yesu mala fü wü Petero teka Ïlïya, o wüh ngbü edu tete kpa esa gö. ");
INSERT INTO muh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Fütanga ngü la, fü wü Yesu adu akoro kpa esa gö. Fü wü Yesu amaka bi wü kpara kpala gbe, kpah de gara wü *mürü rïrï, te ewü ngbü da ega yïkï de wü kpara kaka, te ewü ce ewü de kpala. ");
INSERT INTO muh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Te wü kpara la wu Yesu, fü ngü la aga gbü jia ewü ꞌduwa ba-neh-ene-la. Fü ewü aci ꞌburu, anü de woro, akoro kpakaka, agü mandï fefe na. ");
INSERT INTO muh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Fü Yesu arü amala ngü fü wü mürü rïrï la, gü ba dene, “Wü ngbü ega yïkï de wü kpara ka-ni, egü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Fü gara komoko esüka ewü ayia amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, ni koro de mbarase ka-ni, de ye liki *siti wü di enga me guguvu na asidi. Angü wü di enga me la ngbü emere mbarase la esiti, ah tï amala ngü de. ");
INSERT INTO muh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gbü wü gara sïkpï, e la ngbü egbürü engu, egbogbofo kötö. Fü mbarase angbü da enyüma gbü te ye. Fü durufu angbü ekoro gögömö na, tuku tuku bala! Fü küküte na aürü, angbü jökötö. Ni koro sidi nga ye sene. Fü ni amaka bü wü kpara ka-ye. Fü ni ayi-ta ewü, de wüh liki wü di enga me la, amba wüh tï aliki nda-wü de.” ");
INSERT INTO muh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Te Yesu je ngü la, fü ah adu arü amala ngü fü wü kpara ka-ye, gü ba dene, “De-wü, wü kpara ka re ne, wü ena ato maguma wü fü ni mbi mbi neh elaye? Ni ena angbü de wü sene teka re neh fe, teka fü ngü ka-ni arï gbü nzö wü? Te di bala, wü za mbarase la, koro di kpakine.” ");
INSERT INTO muh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Baka te wüh ngbü ekoro de mbarase la, fü siti wü di enga me la ayia awu Yesu. Fü ewü ayia agbürü mbarase la, agbo kötö. Fü mbarase la angbü da eyili te-ye kötö, fü durufu angbü ekoro gögömö. ");
INSERT INTO muh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Fü Yesu ayi-ta wö ye mbarase la, gü ba dene, “Siti wü di enga me la kpo da emere engu neh elaye?” Wö ye mbarase ga, “Ah kpo de engu gügü, o engu di la gbü jaji te-ye. ");
INSERT INTO muh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ah ngbü fï da emere engu bala. Gara ne, ah ngbü egbürü engu, egbo agbü wa, gara ne gbü ngu, ta de ni mörö engu asidi. Wayi, mere kpara, ye ceka cïnga ni, ale ta-ngü te ni. Te wazi ye ladü la, de ye küwa ye ni la.” ");
INSERT INTO muh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu gü ba dene, “Ngü la ena afa ni? Ah fa ni nda de. Ah de ngü ka-ye. Te ye le ngü ka-ni de maguma ye biringbö la, ngü te ena afa ye nda ma.” ");
INSERT INTO muh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Fü wö ye mbarase la ayia andaꞌba te-ye fü Yesu, gü ba dene, “Ni le ngü ka-ye ngbürü eyi ne, amba maguma ni kpakine ꞌbasu ꞌbasu. Ni ena amere baye? Ye to wazi fü ni, teka de maguma ni ngbü biringbö.” ");
INSERT INTO muh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Fü Yesu ae jia ye, awu mere bi wü kpara te ewü koro. Fü ah adu arü amala ngü fü siti wü di enga me la, gü ba dene, “De-wü, de te wü ngbü emere mbarase ne, de engu je ngü de, ah ro mö kpah de ne, wü ce engu ece. Wü mere e amere engu tïne de.” ");
INSERT INTO muh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Fü siti wü di enga me la aba rere kpa tikpi, ayia agbürü mbarase la, agbo kötö. Fü mbarase la aboto ꞌduwa aboto baka kövö. Fü ewü ayia akoro guguvu na asidi. Fü wü kpara afï, gü ba, “Mbarase la kpi eyi.” ");
INSERT INTO muh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Fü Yesu ayia azoro kpa mbarase la, ae engu tikpi. Fü mbarase la ayia arü tikpi. Siti wü di enga me la ce engu tïne eyi! ");
INSERT INTO muh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Fü wü Yesu ayia adu kpa ekötï. Te wüh du ngbü kpikpi wü, fü wü kpara kaka-na ayi-tata na, gü ba dene, “Ani tï aliki siti wü di enga me la de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu gü ba, “Mene *siti wü di enga me ne, wüh koro guvu kpara kükürü kükürü bala nda-wü de. Ah le aku gba fü Me feke, fü Me ato wazi, teka aliki siti wü di enga me la di.” ");
INSERT INTO muh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Fütanga ngü la, fü wü Yesu ayia ace sü la, anü akoro gbü nga nzö kötï ka wü *Galïlaya. Yesu le ta de wü kpara wu ani nda-wü de. ");
INSERT INTO muh_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Angü ah ngbü da erï wü kpara ka-ye de kpeke ngü, gü ba dene, “Te gara, wü vügü ka-ra ena azoro ra, *Ye Kpara ka Kpï, fü ewü ato ra fü siti wü kpara. Fü ewü amörö ra asidi. Amba gbü *ebabata sïkpï, Me ena adu azükü ra gbü kpi la.” ");
INSERT INTO muh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ngü te Yesu mala la, wü kpara kaka-na, wüh je sisi na mbi mbi nda-wü de. Wüh le ta de ani yi-tata na teka si-ngü la. Wüh du yi-tata na nda-wü de, ka lümü. ");
INSERT INTO muh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Fütanga ngü la, fü wü Yesu adu akoro kpa ekötï, agbü Kaparanama. Baka te ewü du koro tete, fü Yesu ayi-ta wü kpara ka-ye, gü ba dene, “Te ani di tïne te kaje, da edu ne, wü ngbü emala esüka wü ne ngü ne?” ");
INSERT INTO muh_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Fü ewü anga ka-wü tï ka lümü. Angü wüh ngbü tïne da ega yïkï, gü ba dene, “Kpara te ena angbü mere kpara esüka ani, fütanga Yesu, neh da?” ");
INSERT INTO muh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Amba Yesu wu fïngangü ka-ewü la kpo. Fü Yesu ayia angbü kötö, amala ngü fü wü kpara ka-ye la, gü ba dene, “Te mü ele angbü mere kpara gbü nzö wü bu mü la, ah le de mü o ngü ka-mü kötö, ba mbarase te ngbü emere tima fü wü kpara, teka fü ngü ka-mü areke gbü jia Me.” ");
INSERT INTO muh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Fü Yesu ayia aza gara mbarase cüküꞌdaye, ao esüka ewü. Fü ah adu abï mbarase la esaka ye, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mene kpara te ena aza mbarase, baka engu ne, gbü mürü teka ngü ka-ra la, ah le ra eyi. Kpah bala, te mü le ra eyi la, mü le Wüba Me, te tima ra ne kpah eyi.” ");
INSERT INTO muh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Fütanga ngü la, fü *Yüwane adu amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, ani maka gara kpara, te ngbü eliki *siti wü di enga me guvu wü kpara, te ïrï ye. Teka ngü la, fü ani ayia atata engu, angü ah de kpara esüka ani nda de.” ");
INSERT INTO muh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu gü ba dene, “Yi mere e atata engu de. Kpara la ngbü emere mere kpeke ngü la de wazi ka-ra. Te di bala, ah ena adu afü te-ye, amala siti ngü te ïrï ra, neh baye baye? ");
INSERT INTO muh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kpara te di de vügü ka-nih de, dela eyi kpara ka-nih. ");
INSERT INTO muh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ngü te ma emala dene, ah de zu ngü. Mene kpara te ena ale ta-ngü te yi, ato mba e fü yi ba gu ngu, teka te yi di de wü kpara ka-ra ne, Me ena ato mere züka ngü fefe, te gara agbü kpï.” ");
INSERT INTO muh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Fü Yesu adu amala gara ngü fü wü kpara ka-ye, gü ba dene, “Kpara te fiti kpara ka-ra, anga ah de mere kpara, anga mbarase cüküꞌdaye, fü engu adürü te kaje ka Me asidi la, Me ena ato mere kuru tete. Ah ena adi ta mbi, te wüh ena aza mere siti wö, ai gbü ngürü mürü fiti la, fü ewü aza engu di, agü agbü mere yï-ngu feke, o engu fiti wü kpara la, la de. Angü kuru de te Me ena ato ta te mürü fiti la, teka fiti kaka la, ah ena afa mene kpi, te wüh gü engu di gbü ngu, ne ka. ");
INSERT INTO muh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yi di ekpe *siti ngü akpe! Te kpa mü ngbü efiti mü me-ye, teka de mü mere siti ngü la, ah le de mü wa kpa mü la awa, mü gü akötö. Angü ah ena areke pe, te gara e biringbö eküte mü ena akpi me-ye, fü mü aküwa, ka engu te wüh ena aza mü, de küte mü ꞌburu, agü gbü mere du ka wa. Angü wa te ngbü ecuru kpara kpala, ah ünü nda de. ");
INSERT INTO muh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Kpah bala, te lö mü ngbü efiti mü me-ye, teka de mü mere siti ngü la, ah le de mü wa lö mü la awa, mü gü akötö. Angü, ah ena areke pe, te gara e biringbö eküte mü ena akpi me-ye, fü mü aküwa, ka engu te wüh ena aza mü, de küte mü ꞌburu, agü gbü mere du ka wa. ");
INSERT INTO muh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anga te ah de jia mü, te ngbü efiti mü me-ye, teka fü mü amere siti ngü la, ah le de mü gbi jia mü la agbi, mü gü akötö. Angü ah reke pe, te mü ena aküwa de jia mü ngbee biringbö, ka engu te wüh ena agü mü de jia mü ꞌbasu mini, agbü du ka wa. ");
INSERT INTO muh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Angü kpa gbü wa la, cïnga fa sü. Wa ngbü ecuru wü kpara kpala. Wü ru kpah ladü kpala, te ewü ngbü ezü kpara. Cïnga la nza nda de, fï mere badi! ");
INSERT INTO muh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Wü kpara ꞌburu te ewü le adi de kpara ka-ra, ah le de Me reke ewü, baka se te wüh ngbü eto gbü wa, teka fü ewü angbü *nzïla. ");
INSERT INTO muh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yi nda-yi baka ngütü, angü ngütü reke fa sü. Amba te ngütü mi tïne de la, wüh ena amere di neh baye? Wüh ena abu agbü gü. Ah le de yi ngbü ba züka ngütü, te mi ami. Yi ce ngü ka yïkï, fü yi adi ele te-yi esüka yi ale.” Dela wü ngü ta te Yesu mala fü wü kpara ka-ye. ");
INSERT INTO muh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Fütanga ngü la, fü wü Yesu ayia ace sü la, anü agbü nga nzö kötï ka *Yudaya, anü akö Yürüdene kpa eta ngu. Te wüh koro kpala, fü mere bi wü kpara aci abiti te-wü kpaka Yesu. Fü engu adu akpo da erï ewü, baka te engu ngbü emere gügü ne. ");
INSERT INTO muh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fü wü gara *Farusi ayia akoro kpaka Yesu, teka are mamaguma. Fü ewü ayi-tata na, gü ba dene, “Yesu deyï, te kpara ce wara ye la, ngü la ena adi esiti gbü jia Me?” ");
INSERT INTO muh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Fü Yesu adu ayi-ta ewü, gü ba dene, “*Müse ba ta ngü fü ani, gbü *Rïrï ka Me teka ngü la, gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wüh ga, “Müse le ta eyi, gü ba dene, ‘Te komoko ele ace wara ye la, ah le de engu ba köcökpa, ato fü wara ye feke, fü wara ka la ayia ago ka-ye agba wü.’ ” ");
INSERT INTO muh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu gü ba dene, “Müse ba ta ngü la bala teka ne de, angü nzö wü kundu yi ta kpekpeke, kpah baka nda-yi! ");
INSERT INTO muh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mü nü, mü ceka ngü ta te Müse ba, teka gina wü kpara, te Me o füh kotö ne. Müse gü ba, ‘Me mere komoko ake würüse.’ ");
INSERT INTO muh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Fü Me amala ngü fü ewü, gü ba, ‘Dela si-ngü te komoko ngbü eyia, ece wö ye ake ni ye, aza wara ye, alala tete na. ");
INSERT INTO muh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Fü ewü adu angbü ake di tïne baka kpara biringbö ne.’ Yi wu, gü ba, Me o yi ta eyi me-ye, de yi za te-yi, fü yi akoro baka e biringbö, ne de? ");
INSERT INTO muh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Te Me o yi eyi biringbö la, yi mere e aye süka yi tïne de!” ");
INSERT INTO muh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Fü wü Yesu ayia de wü kpara ka-ye, adu ka-wü kpa ekötï. Fü wü kpara kaka-na ayia ayi-tata na teka ngü la. ");
INSERT INTO muh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Fü Yesu alügü ngü fü ewü, gü ba dene, “Te mü ce wara mü, fü mü ayia aza gara würüse la, mü mere *siti ngü eyi, angü mü mere dela waza. ");
INSERT INTO muh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kpah bala, teka würüse te yia esaka watï ye, anü aza gara komoko. Ah mere waza kpah eyi.” Dela ta ngü te Yesu mala teka komoko ake wara ye. ");
INSERT INTO muh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Gbü gara ra, fü wü gara kpara ayia akoro de wü jaji ka-wü kpaka Yesu, de engu o kpa ye gbü nzö ewü, teka de Me to wazi fü ewü. Te wü *kpara ka Yesu wu ngü la bala, fü ngü la asiti te ewü. Fü ewü akpo da eliki wü jaji la. ");
INSERT INTO muh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Te Yesu wu ngü la bala, fü mamaguma ayia anzu. Fü ah amala ngü fü wü kpara ka-ye la kpekpeke, gü ba dene, “Yi ce wü jaji la, de wüh koro kpaka ra. Yi mere e atïrï ewü de, angü wü kpara te maguma ewü di ba nda wü jürü jaji de bala, wüh ka-wü de wü kpara ka Me. Angü wü jürü jaji cu ngü wü de, wüh mere mani kpah de. ");
INSERT INTO muh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngü te ma emala dene, ah de kpeke ngü. Te mü ele ara fü Me, ah le de mü fü maguma mü, ba nda wü jürü jaji. Te maguma mü ngbü ba nda wü jaji de la, mü tï arï gbü sü ka Me agbü kpï kpah de.” ");
INSERT INTO muh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Fü Yesu ayia abï wü jaji la esaka ye, ao kpa ye gbü nzö ewü. Fü ah ayia aku gba fü Me teka ewü, de Me to wazi fü ewü. Dela ngü ta te Yesu mere fü wü jürü jaji. ");
INSERT INTO muh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Fütanga ngü la, fü wü Yesu ayia de ani ce sü la. Baka te ewü ngbü eyia tete, fü gara komoko akpe akoro, abu nzökuta ye engagira Yesu, ayi-tata, gü ba dene, “Züka mere kpara, ni ena amere baye, teka fü ni aküwa agbü sü ka Me fï mere badi?” ");
INSERT INTO muh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu gü ba, “Mü ga, ‘Ma de züka kpara,’ neh teka ne? Züka kpara ladü füh kotö ne? Züka kpara füh kotö ne biringbö nda ma, ꞌduwa Me kpikpi ye, mü wu bala de? ");
INSERT INTO muh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Te mü le aküwa la, ah le de mü mere wü *Rïrï ka Me ꞌburu, mbi mbi mbi. Mü wu Rïrï la de? Rïrï la gü ba, ‘Mü mere e amörö kpara de. Mü mere e amere waza de. Mü mere e azi e de. Mü mere e adi esutu wu te wü bu mü de. Mü mere e afiti kiri mü de mani de. Mü je rïrï ka wö mü ake ni mü.’ ” ");
INSERT INTO muh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Komoko ne gü ba, “Mere kpara, ni kpo da emere wü ngü la eyi kü gügü, o ni di la jaji, zalü akoro dene, ni ngbü fï bü emere wü rïrï la.” ");
INSERT INTO muh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Fü Yesu aceka jia komoko la. Fü ngü ka komoko la areke tete na afa sü. Fü Yesu amala ngü fefe, gü ba, “Ah de züka ngü. Amba gara ngü ladü biringbö, te mü mere la de. Mü du edu, mü cïnzï wü e ka-mü ꞌburu asidi. Fü mü aza jiase la, ato ꞌburu fü wü mürü cïnga. Fü mü adu alala gbü nga ra. Te di bala, mü ena amaka *küküwa te gara, agbü sü ka Me agbü kpï.” ");
INSERT INTO muh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Te komoko la je ngü la, fü ah akpo da endunduru gbüra ye, de mere cïnga emaguma ye. Fü ah ayia alügü nga ye, adu kpa gba ye, de mere fïngangü gbü nzö ye, angü wü e fa ta esasaka sü. ");
INSERT INTO muh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Fü Yesu afü te-ye, amala ngü fü wü kpara ka-ye, gü ba, “Atï! Te mü de kpara de mere bi wü e esaka mü la, mü ena afü te-mü, ato maguma mü fü Me, neh baye baye?” ");
INSERT INTO muh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Fü ngü la aga gbü jia wü *kpara ka Yesu afa sü. Fü Yesu adu anda nga ngü la, gü ba, “Ah de kpeke ngü teka fü kpara ato maguma ye fü Me. ");
INSERT INTO muh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ah baka ya, te le arï gbü enga gö sögbe. Ah tï eyi arï kpala fanü? Ah tï arï nda de! Amba ngü ka mene kpara de mere bi wü e esaka ye, ah kpah bala. Ah ena adi kpekpeke fefe, teka afü maguma ye, ara fü Me.” ");
INSERT INTO muh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Fü ngü anza gömö wü kpara ka Yesu ꞌburu. Fü ewü akpo da eyi-ta tete-wü, gü ba dene, “Te ngü la tïne bala la, biri kpara ladü te ena aküwa?” ");
INSERT INTO muh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Fü Yesu aceka jia ewü, gü ba dene, “Kpara te ena aküwa te-ye de tete-ye nda ma. Angü ngü la fa wü kpara eyi ꞌburu. ꞌDuwa te Me ena aküwa mü me-ye. Angü ngü te ena afa Me nda ma.” ");
INSERT INTO muh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petero, fü mü arü amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, ye ceka la, ani ce wü e ka-ani eyi ꞌburu, teka alala gbü nga ye. Te ah di bala ne, ngü ka-ani ena adi baye?” ");
INSERT INTO muh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesu gü ba, “Wayi, yi ena amaka züka ngü. Ngü te ma emala dene, ah de zu ngü. Te mü ce wü e ka-mü teka ra, teka amala ngari ra fü wü kpara la, Me ena ale ta-ngü te mü fanü. Mü ena amaka kpah cïnga füh kotö ne, angü wü vügü ka-nih ladü. Amba Me ena ato mere bi züka ngü fü mü, afa nda-mü te mü ce la. Anga mü ce neh ene? Te ah de gba mü, wü di enga ni mü, wü wö mü ake ni mü, anga wü di mü, te mü ce ewü teka ra la, Me ena ato kpah mere bi züka ngü fü mü füh kotö sene, da wü e te mü ce la. Kpah bala, Me ena aküwa mü gbü sü ka-ye agbü kpï, fï mere badi. ");
INSERT INTO muh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amba yi mere e acu ngü yi nda-yi de, angü bi wü kpara, te ewü mere te-wü baka wü cögbörö kpara füh kotö ne, te gara, Me ena afü ewü baka kükürü wü kpara. Kpah bala, mene ewü, de te ewü di ba kükürü wü kpara füh kotö ne, te gara Me ena afü ewü, ao angbe cögbörö wü kpara fü wü bu wü agbü sü ka-ye, agbü kpï.” Dela ngü te Yesu mala, teka wü kpara de mere bi wü e esaka wü. ");
INSERT INTO muh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Fütanga ngü la, fü wü Yesu ayia angbü enü agbü Yerüsalema. Te wüh ngbü enü tete, fü Yesu ayia atï nda-ye kpa engagira nü. Fü wü kpara kaka-na angbü efa nganga na de mere fïngangü gbü nzö wü. Fü mere bi wü kpara angbü kpah enü fütanga ewü de mere cürü te wü. Fü Yesu adu kpah aza wü kpara ka-ye nzükpa de füh ye ꞌbasu ne mba canza edere sü. Fü ah akpo da emala ngü fü ewü, teka ngü te ena amere ye agbü Yerüsalema kpala, ");
INSERT INTO muh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","gü ba dene, “Te nih ena akoro agbü Yerüsalema la, wüh ena azoro ra, *Ye Kpara ka Kpï, anü di engagira wü *mere kovo bete wü *mürü rïrï, te ewü le ngü ka-ra de ne. Wü mere kpara la ena akolo ngü ka-ra, gü ba, ‘Ah le de wüh mörö ra asidi.’ Fü ewü ayia ato ra fü wü *ganzi kpara. ");
INSERT INTO muh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Fü wü ganzi kpara la akpo angbü emü ra, da efala ra, da esü ngüsü gbüra ra, da esüma ra de juru. Fü ewü amörö ra asidi. Gbü *ebabata sïkpï, Me ena adu azükü ra gbü kpi la.” Dela ngü ta te Yesu mala fü wü kpara ka-ye teka kpi ka-ye. ");
INSERT INTO muh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Fütanga ngü la, fü wü *Yakobo ake *Yüwane, wü di Zebedayo ayia arü amala ngü fü Yesu, gü ba dene, “Mere kpara deyï, gara enga ngü ladü gömö ani, te ani ele ayi-ta ye di.” ");
INSERT INTO muh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu gü ba dene, “Wü mala emala.” ");
INSERT INTO muh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wüh gü ba, “Gbü sïkpï te ye ena angbü mere miri tete na, ani ele angbü ede ye, baka wü cögbörö kpara ka-ye, gara gbü kokpa, gara gbü kamisü.” ");
INSERT INTO muh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu gü ba, “Ngü te yi mala la, yi wu sisi na mbi mbi de. Te yi le amaka wazi baka nda-ra la, ah le de yi zü kpah mere cïnga baka nda-ra, de te ma ena azü ne. Yi tï eyi azü mere cïnga, baka nda-ra la? Ngü la tï afa yi de?” ");
INSERT INTO muh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wüh gü ba dene, “Wayi, ani le eyi amere ngü la.” Yesu gü ba, “Ah mbi. Yi ena azü mere cïnga baka nda-ra fanü fanü. ");
INSERT INTO muh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amba ma tï ao yi baka mere kpara, fütanga ra, nda-ra de. Ngü la ka-ye de ngü ka Wüba Me, angü ah reke sü la eyi teka wü kpara ka-ye, te engu fe ewü.” ");
INSERT INTO muh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fü du wü *kpara ka Yesu nzükpa ne ayia aje ngü la. Fü maguma ewü ayia asiti eküte wü *Yakobo ake *Yüwane. Fü ewü angbü da efï ngü emaguma wü, gü ba, “Wüh ele ao te-wü ba mere kpara gbü nzö ani?” ");
INSERT INTO muh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Te Yesu wu ngü la bala, fü ah adu aï wü kpara ka-ye la ꞌburu kpaka ye, amala ngü fü ewü, gü ba dene, “De-yi, yi wu eyi, gü ba, wü miri füh kotö ne ngbü engbü gbü nzö wü bu wü de mere wazi, fü ewü angbü emere wü kpara esa lö wü ne, baka e te ewü ele. ");
INSERT INTO muh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Yi le amere kpah bala? Ah bala de. Te mü ele angbü ba mere kpara esüka wü bu mü la, mü fü te-mü baka jaji, te ngbü emere tima fü wü bu ye. ");
INSERT INTO muh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Te di bala, ah le de yi fü fïngangü ka-yi baka nda-ra. Angü de-ra, *Ye Kpara ka Kpï, ma koro füh kotö ne, neh teka ne? Yi efï nda-yi, gü ba, ma koro ta teka angbü ba mere miri, teka fü wü bu ra angbü emere tima fere? Ah bala nda de. Ma koro teka amere tima fü wü kpara, da ele ta-ngü te ewü. Angü ma ena ato te-ra fü kpi, teka afa wü kpara gbü *siti ngü ka-ewü, fü ewü aküwa.” Dela ngü te Yesu mala fü wü kpara ka-ye, teka mene kpara te Me ena ao memere. ");
INSERT INTO muh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Baka te wü Yesu ngbü fï bü enü te kaje ka Yerüsalema, fü ewü anü akoro agbü Yeriko. Fü ewü ayia sela de mere bi wü kpara gbü nga wü, teka anü agbü Yerüsalema. Fü ewü amaka gara komoko de ïrï ye Batïmaya, te ngbü edere kaje, da eyo e te wü kpara, angü jijia na nda ma. ");
INSERT INTO muh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Fü Batïmaya aje ngü, gü ba dene, “Yesu koro eyi.” Fü ah ayia aba rere kpa tikpi, gü ba dene, “Yesu! Kundu ye *Davidi! Ni wu eyi, gü ba, Me tima ye teka aküwa ani ne! Ye ceka la bü cïnga te ni baaa!” ");
INSERT INTO muh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Fü wü kpara aci ꞌburu, amala ngü fefe, gü ba dene, “Ye nga enga!” Batïmaya le ngü ka-ewü la nda de. Ah ngbü fï eba rere kpa tikpi bala, gü ba, “Yesu! Kundu ye Davidi! Ye ceka la bü cïnga te ni baaa!” ");
INSERT INTO muh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Fü Yesu arü amala ngü, gü ba, “Wü ï engu akine.” Fü ewü ayia aï Batïmaya kpaka Yesu, gü ba dene, “Yesu te eï ye. Ye gu maguma ye, de ye yia eyia, ye nü kpakaka na la.” ");
INSERT INTO muh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Fü Batïmaya ayia agbi mere bongo ka-ye asidi, ace kötö. Fü ah ayia akpe anü kpaka Yesu. ");
INSERT INTO muh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Fü Yesu ayi-ta Batïmaya, gü ba dene, “De-ye deyï, ye ele de ni mere fü ye ne ngü ne?” Batïmaya gü ba, “Akoo, mere kpara, ma ele de mü ü jia ra, teka de ma di eceka kpï!” ");
INSERT INTO muh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu gü ba, “Ah mbi. Mü küwa eyi, teka te mü to maguma mü eyi fü Me. Mü go ego.” Fü jia Batïmaya ayia aü raaa! Fü Batïmaya ayia akpo da efa nga wü Yesu. ");
INSERT INTO muh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Fütanga ngü la, wü Yesu ngbü fï enü agbü Yerüsalema. Fü ewü anü, anü akoro gbamari ede Yerüsalema, angü wüh le kaje ka Betefage ake Betanïya, te di esa mere da de ïrï ye Olïve. Te wüh nü koro gbamari kpala, fü Yesu ayia atima gara wü kpara ka-ye ꞌbasu kpa engagira nü, ");
INSERT INTO muh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","gü ba, “Wü nü enü agbü kötï de kpa engakara wü la. Te wü koro kpala, wü ena amaka dongï, te wüh i, o kpala, enganga na, te wüh lï fefeh na la de. Wü furu dongï la, wü du di fü ni akine. ");
INSERT INTO muh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Te wüh yi-ta wü, gü ba, ‘Wü ngbü efuru enga nü la teka ne?’ la, de wü lügü ngü fü ewü, gü ba dene, ‘Mere kpara ka-ani ngbü ele me-ye. Ani ena alügü fü wü enatikine.’ ” ");
INSERT INTO muh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Te wüh je ngü la, fü wü kpara ꞌbasu la ayia anü agbü Betanïya. Fü ewü amaka enga dongï, te wüh i o etanü, ede möngïtï. Fü ewü ayia afuru dongï la, ba e te Yesu mala fü ewü. ");
INSERT INTO muh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fü wü gara kpara ayi-ta ewü, gü ba, “Ah mere baye, te wü ngbü efuru enga dongï ne?” ");
INSERT INTO muh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Fü ewü ayia alügü ngü fü ewü, gü ba dene, “Mere kpara ka-ani ngbü ele me-ye. Ani ena alügü enatikine.” Fü wü kpara la ale. Fü ewü ayia aza dongï la, adu di kpaka Yesu. ");
INSERT INTO muh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Te wüh koro de dongï la kpaka Yesu, fü ewü agü wü bongo ka-wü füh gügü na. Fü Yesu ayia alï fefeh na, anü di agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Fü mere bi wü kpara ayia akoro, teka agbo nga ïrï Yesu. Fü gara ewü agbala bongo ka-wü kötö te kaje. Wü gara ngbü nda-wü edoro wü zukpa rü, da egü te kaje, teka agbo nga ïrï Yesu di. ");
INSERT INTO muh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Fü gara wü kpara atï kpa engagira nü fefe na, gara ewü nda-wü kpa sidi. Fü ewü angbü ꞌburu egbo nga ïrï Yesu, da ebï ci, da emï koko, gü ba, “Nih gbo nga ïrï Me! Me to wazi fü mü, angü ah tima mü fü a me-ye! ");
INSERT INTO muh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mü za wazi ka kundu kundu nih *Davidi! Mü koro eyi angbü gbü nzö a, baka mere Miri Davidi engu! Me di de mü! Nih gbo nga ïrï Me kpa gbü kpï!” ");
INSERT INTO muh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Baka te Yesu nü koro agbü Yerüsalema, fü ah anü arï kpa etambasü *Mere Kambü ka Me. Fü ah aceka kpï, aceka wü ngü de kpala ꞌburu. Fü ewü ayia de wü kpara ka-ye, nzükpa de füh ye ꞌbasu ne, adu kpa gbü Betanïya, ara kpala, angü sü yia etï atï. ");
INSERT INTO muh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kpurutokokpï la, fü wü Yesu ayia ace Betanïya, edu agbü Yerüsalema. O wüh ngbü enü tete, fü tala ayia amere Yesu. ");
INSERT INTO muh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Fü Yesu aceka kpï, awu nzö rü figi, te kpakpa na bi abi. Fü ah afü kpuru akoro kpala, de ni maka rïrï na. Te wüh nü koro kpa esa rü la, rïrï na nda ma, ka-ye bü kpakpa na kükürü. Angü ah de fe kaka, te ngbü erï tete na, nda de. ");
INSERT INTO muh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Fü Yesu ayia akïna rü engu la, gü ba dene, “Mü ngbü fï bala. Wü kpara tï azü rï mü tïne fï de, fï mere badi.” Fü wü *kpara ka Yesu ayia aje ngü de te engu mala la. ");
INSERT INTO muh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Te wü Yesu du koro tete agbü Yerüsalema, fü ewü ayia anü akoro etambasü *Mere Kambü ka Me. Fü ewü amaka mere bi wü kpara kpala, te ewü ngbü ecïnzï wü nü de wü lu, teka fü wü kpara adi ese, eto laꞌbï tete fü Me. Wü gara ngbü nda-wü da ekura jiase. Fü ngü la ayia asiti gbü jia Yesu afa sü. Fü engu ayia aliki ewü ꞌburu asidi, anzinzi wü cangalï de wü gbaꞌda ka wü kpara la, agbogbofo ꞌburu kötö. ");
INSERT INTO muh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Fü ah amaka kpah wü gara kpara te ewü ngbü da ebï e ka-wü, ekolo sü di kpuru etambasü Kambü ka Me la. Fü Yesu ayia atïrï kaje la te ewü, gbere. ");
INSERT INTO muh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Fü ah akpo da erï wü kpara, gü ba dene, “Me mala ta teka Kambü ka-ye, gü neh fe? Me gü ba, ‘Kambü ka-ni, ah de sü te wü kpara füh kotö ne ꞌburu ena akoro angbü egbo nga ïrï ni gbügbü.’ Yi wu bala de? Amba nda-yi, yi du fü tambasü Kambü ka Me eyi, ba sü ka wü mürü zi!” ");
INSERT INTO muh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Fü wü mere *mürü gele bete wü *mürü rïrï ayia aje ngü la. Fü ngü la asiti te ewü afa sü. Fü ewü akpo da egïrï kaje de ani mörö Yesu tete na. Wüh maka kaje kere de, angü cürü ngbü emere ewü, teka mere bi wü kpara te ewü le ka-wü ngü ka Yesu, gü ba, “Engu ngbü erï ani de mere kpeke rïrï.” ");
INSERT INTO muh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Etamurago la, fü wü Yesu ayia ace Yerüsalema, ayia adu agbü Betanïya. ");
INSERT INTO muh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kpurutokokpï la, fü wü Yesu alügü te-wü, edu agbü Yerüsalema. Te wüh ngbü edu te kaje la, fü ewü adu amaka rü de esikine, te Yesu kïna ne. Rü la ürü ka-ye eyi, de sï ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petero, fü mü adu afï nga kïna, te Yesu kïna rü la di ne. Fü mü amala ngü fü Yesu, gü ba dene, “Mere kpara, ye ceka la! Rü de esikine te ye kïna ne, ah ürü ka-ye eyi!” ");
INSERT INTO muh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu gü ba, “Ah de wazi ka Me. Te yi to maguma yi fü Me, Me ena ato wazi fü yi kpah bala. ");
INSERT INTO muh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngü te ma emala dene, ah de zu ngü. Te mü ena ato ta maguma mü fü Me ꞌburu ꞌburu la, Me ena ato wazi fü mü, teka fü mü amere wü mere kpeke ngü di kpah bala. Mü tï eyi amala ngü fü mere siti da la, gü ba dene, ‘Mere da la yia eyia, ah tï agbü mere ngu.’ Ah ena amere te-ye kpah bala. Amba te maguma mü ngbü ꞌbasu ꞌbasu la, Me to wazi fü mü nda de. ");
INSERT INTO muh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kpah bala, mene ngü te mü ena ayi-ta Me tete na, ah le de mü o maguma mü ꞌburu te Me, gü ba, ‘Fanü fanü, Me tï eyi amere ngü la fü ni.’ Te maguma mü ngbü ꞌbasu ꞌbasu de la, Me ena amere ngü la fü mü amere fanü. ");
INSERT INTO muh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Te mü ngbü eku gba fü Me, mü mere e ati ngü te kiri mü emaguma mü de. Mü boro *siti ngü ka kiri mü emaguma mü asidi feke, teka fü Me, te di de Wö nih agbü kpï ne, aboro kpah wü siti ngü ka-mü.” Dela ngü te Yesu mala, teka kpara te le aku gba fü Me. ");
INSERT INTO muh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Fütanga ngü la, fü wü Yesu adu anü akoro agbü Yerüsalema. Fü Yesu angbü endoro ka-ye etambasü ka *Mere Kambü ka Me. Fü wü mere *kovo ayia de wü *mürü rïrï, akoro kpaka Yesu, ayi-tata, ");
INSERT INTO muh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","gü ba dene, “De ye deyï, ngü te ye mere esikine de sene ne, ye mere ngü la neh de wazi ka da? Kpara te tima ye, aliki wü kpara etambasü Mere Kambü ka Me ne, neh da?” ");
INSERT INTO muh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu gü ba, “Gara ngü ladü biringbö, te ni ele ayi-ta wü di feke. Te wü lügü ngü la eyi, fü ni adu amala nga kpara, de te to wazi la fü ni ne. ");
INSERT INTO muh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yitangü ka-ni, ah teka *Yüwane Mürü Babatïza. Kpara te to wazi fü Yüwane, de ah to babatïza fü wü kpara, neh da? Me to wazi fefe me-ye de? Anga ah mere ngü la de tete-ye?” ");
INSERT INTO muh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Fü ewü akpo da emala ngü esüka wü, gü ba dene, “Ani ena alügü ngü la fefe, agü neh fe? Te ani gü ba, ‘Me to wazi fü Yüwane me-ye la,’ ah esiti, angü Yesu ena adu kpah ayi-ta ani, agü ba dene, ‘Te di bala ne, ah mere baye, te ani le ngü ka Yüwane de ne?’ ");
INSERT INTO muh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Te ani mala fefe, gü ba, ‘Yüwane mere ngü la de tete-ye la,’ ah tï kpah de, angü maguma wü kpara ꞌburu ena asiti te ani.” Wüh ngbü ekpe cürü teka mere bi wü kpara, angü wü kpara ngbü ele ngü ka Yüwane, gü ba, “Engu ka-ye zu de *mürü dofo ka Me.” ");
INSERT INTO muh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Te di bala, fü wü angbe cögbörö kpara la adu alügü ngü fü Yesu, gü ba dene, “Ani wu kpara te to wazi fü Yüwane ne, nda-ani de.” Yesu gü ba, “Wayi, ah mbi! Te ah bala la, ni tï amala nga kpara, te to wazi fü ni ne, kpah de.” ");
INSERT INTO muh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Fütanga ngü la, fü Yesu adu kpah amala ngü fü wü cögbörö kpara la de mani, gü ba dene, “Gara komoko ta ladü, te nü maka züka sü, fü ah ayia aru rü *vinü ka-ye gbügbü. Fü ah adu ajï ꞌbaranga ekekere na kerekere gbaa. Fü ah areke kpah sü, teka adi efi rï-rü la gbügbü na. Fü ah ajï kpah kambü teka fü wü kpara adi engbü gbügbü, da efete yï la. Fü engu aza wü kpara ka tima, ao kpala, aro mö de ewü areke areke, de wüh di eceka kpï fütanga yï ka-ni la mbi mbi mbi, angü ni ena anü andoro agbü gara sü nengete. ");
INSERT INTO muh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Te kpïrï ka makolo rï-rü la koro tete na, fü komoko la ayia atima gara labï ka-ye kpaka wü kpara ka tima ka-ye la, gü ba, ‘Wü to rï-rü ka-ni la fü ni.’ ");
INSERT INTO muh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Fü labï la ayia anü akoro kpaka wü kpara ka tima la. Fü ewü ayia azoro labï la, amï engu, alügü kpaka mere kpara ka-ye, de kpa ye kükürü. ");
INSERT INTO muh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Fü mürü rïrü la adu kpah atima gara labï ka-ye. Fü labï la anü akoro kpaka ewü. Fü ewü amï nzönzö na, amemere lalara. Fü labï la akpe adu kpaka mere kpara ka-ye kpah de kpa ye kükürü. ");
INSERT INTO muh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Fü mürü rïrü la adu kpah atima gara labï ka-ye. Fü ewü amiki labï la, amörö ka. Fü ewü angbü ememere wü labï ka mürü rïrü la fï bü bala, emimiki gara ewü, emömörö gara ewü. ");
INSERT INTO muh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Gara labï te mürü rïrü la ena adu atima nda tïne ma. Tïne bü eyi duu kporo yeye na, te mamaguma ngbü tete na ne. Fü ah afï, gü ba dene, ‘Te ni tima ye ni la, wüh ena akpe cücürü na akpe.’ Fü ah ayia atima ye ye la kpaka ewü. ");
INSERT INTO muh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Te wü kpara la wu ye mürü rïrü la te ngbü ekoro, fü ewü amala ngü esüka wü, gü ba dene, ‘Ceka la! Ye mürü rïrü ne te ekoro! Engu ena aza e-nga-kpa wö ye, te gara me-ye. Te di bala, ah le de ani mörö engu asidi, teka fü yï ka-ewü ne angbü te gara fü ani.’ ");
INSERT INTO muh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Fü ewü ayia azoro ye mürü rïrü la, amï, amörö, aza kökö na, asö agbü gü.” ");
INSERT INTO muh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Fü Yesu adu ayi-ta wü cögbörö kpara la, gü ba, “Gbü fïngangü ka-yi, mürü rïrü la ena amere de wü siti kpara la, neh baye? Ah ena ayia akoro kpaka ewü de mere wazi, amömörö ewü ꞌburu. Fü ah aza to wü kpara, ao eme rïrü ka-ye la.” Dela mani te Yesu mala fü wü cögbörö kpara ka wü *Yïsarayele. ");
INSERT INTO muh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Fü ah adu ayi-ta wü cögbörö kpara la, gü ba dene, “*Ngari Me mala teka ngü la, gü neh fe? Ah gü ba, ‘Wü gara kpara ngbü ta ejï *Mere Kambü ka Me. Fü ewü amaka gara mere rü, te ewü le nda-wü de. Fü ewü ace rü la asidi. Tïtïne rü ta te ewü ce la, Me du o tïne eyi mere kpeke rü de wazi ye, te wü bu ye na ngbü engbü ꞌburu eküküte. ");
INSERT INTO muh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nih gbo nga ïrï Me, angü engu mere mere züka ngü eyi fü nih!’ ” ");
INSERT INTO muh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Fü wü cögbörö kpara la awu, gü ba, Yesu mala mani la eküte ani, teka te ani le ngü kaka nda-ani de ne. Fü ngü la ake te ewü afa sü. Fü ewü angbü egïrï kaje teka de ani zoro Yesu. Wüh le azoro engu gbü jia wü kpara nda-wü de, angü maguma wü kpara ena asiti eküte ani. Te di bala, fü ewü ayia ace engu, ago ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fütanga ngü la, fü wü cögbörö kpara atima gara wü *Farusi kpaka Yesu, bete gara wü kovo ka Miri Anïtïpa *Erode, gü ba dene, “Wü fiti Yesu, de engu mala siti ngü eküte miri ka wü *Rüma, teka de ani zoro engu gbü riri na la.” ");
INSERT INTO muh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Fü ewü anü akoro amaka Yesu, amala ngü fefe, gü ba dene, “Mere kpara, ani wu eyi, gü ba, ye de kpeke kpara, te ye ngbü emala zu ngü ka Me fü ani fanü fanü. Angü ye kpe cürü kpara nda-ye ꞌburu ꞌdö de. Ye ngbü ele ka-ye ꞌduwa ngü ka Me. Te di bala, gara ngü ladü te ani le ayi-ta ye di. Ah tï atï fü ani ase ngürü ani fü *Kayïsara, Miri ka wü Rüma, te ngbü gbü nzö ani ne? ");
INSERT INTO muh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Anga ah tï de? *Rïrï ka Müse gü neh fe?” Amba Yesu, mü wu mani ka-ewü la nda-mü eyi kpo. Fü mü ayia alügü ngü fü ewü, gü ba, “Wü ngbü ere maguma ni de ngü bala, neh teka ne? Wü za la biri jiase sela, wü sere fü ani.” ");
INSERT INTO muh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Fü ewü aza gara jiase biringbö, ato fefe na. Fü ah aceka jiase la, agü ba dene, “E-gbü jiase ne, neh kuru da? Wüh ba eküküte na ne, neh ïrï da?” Wüh ga, “Ah de kuru Kayïsara, te di de Miri ka wü Rüma ne.” ");
INSERT INTO muh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu gü ba, “Ah mbi! Te ah de nda miri la, de yi lügü fü miri. De yi lügü nda Me kpah fü Me.” Dela ngü ta te Yesu mala fü wü kpara la, teka mase ngürü. Fü ngü kaka la aga gbü jia wü kpara la afa sü. ");
INSERT INTO muh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wü gara kpara ta ladü esüka wü di enga *Yïsarayele, te wüh eï ewü, gü ba, wü *Saduke. Wüh fï nda-wü, gü ba, “Te kpara kpi eyi la, ah kpi eyi fï mere badi. Ah du azükü gbü kpi tïne de.” Te di bala, fü gara wü Saduke akoro kpaka Yesu, ayi-tata gbü mani, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mere kpara, gara ngü ladü te ani le ayi-ta ye di. *Müse ba ta ngü fü ani gbü *Rïrï ka Me, gü ba, ‘Te kpara kpi, ce wara ye, o wüh bï ye ake di la de la, ah le de enga ni ye na za würüse gbü nganga na la, teka abï ye dada na, angü ïïrï na ena adürü.’ ");
INSERT INTO muh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Amba, te wü kpara ena azükü gbü kpi azükü fanü fanü la, ngü la ena adi baye? Angü gara wü komoko ta ladü, wüh guvu ni wü lorozi. Fü gina ewü ayia aza würüse. Fü ah ayia akpi, o wüh bï ye ake di la de. ");
INSERT INTO muh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Fü eꞌbaꞌbasu adu aza würüse nga kpa enga ni ye la. Fü ah ayia akpi. Wüh bï ye ake di kpah de. Fü ebabata na adu kpah aza würüse la. Fü ah ayia kpah akpi, ace engu fï kükürü. ");
INSERT INTO muh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Wü jaji komoko de lorozi la, wüh za würüse la te nga wü ꞌburu. Fü ewü akpi ꞌburu, wüh bï ye te würüse la nda-wü de. Fütanga ewü la ꞌburu, fü würüse la adu kpah akpi. ");
INSERT INTO muh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Te wü kpara ena azükü azükü gbü kpi fanü la, würüse la ena adi neh wara da? Kükürü de, angü engu ta eyi wara ewü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu gü ba, “Yi fï nda-yi, gü ba, Me tï azükü wü kpara gbü kpi nda de? Yi dürü bala, neh teka ne? Yi wu si-ngü de te wüh ba gbü *Ngari Me ne de, neh teka ne? Yi le awu wazi ka Me kpah de, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gbü sü ka Me agbü kpï kpala, wü kpara za te-wü nda-wü de. Angü te wü kpara zükü eyi gbü kpi la, Me ena afü ewü baka wü *malayïka ka-ye. ");
INSERT INTO muh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wüh ba ngü gbü *Ngari Me teka ngü ka züzükü gbü kpi, gü neh fe? Gbü ra ta te Me gü tamu ye tete fü *Müse, Me mala ta fefe, gü neh fe? Ah gü ba dene, ‘De-ni Me, ni de *vüngüte ka *Abarayama, ake *Yïsaka bete *Yakobo.’ ");
INSERT INTO muh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Amba, gbü ra ta te Me mala ngü la tete, o wü Abarayama kpi ka-wü eyi gügü. Me ena amala ngü teka wü kövö, gü ba, ‘Wüh de wü vüngüte ka-ni?’ Ah bala de. Me mala ngü la, angü wü Abarayama ka-wü eyi ladü ezükü, agbü sü ka Me fï mere badi. Te di bala, fïngangü ka-yi te gü ba, wü kpara tï azükü gbü kpi nda-wü de ne, ngü la de mere siti wu!” Dela ngü ta te Yesu mala fü wü Saduke, gü ba, “Me ena azükü wü kpara ka-ye, fü ewü angbü fï mere badi agbü sü ka-ye agbü kpï kpala.” ");
INSERT INTO muh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Gara *mürü rïrï ngbü ta eje yïkï te wü *Saduke ngbü ega de wü Yesu ne. Te engu je ngü te Yesu lügü fü ewü la, fü ngü la areke gbü jijia na afa sü. Fü mürü rïrï la adu ayi-ta Yesu, gü ba dene, “Mere kpara deyï, nda-ni yitangü kpah ladü. Esüka wü *Rïrï ka Me ꞌburu, kpeke rïrï, te fa wü bu ye ꞌburu, neh engu deyi?” ");
INSERT INTO muh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu gü ba, “Kpeke Rïrï te Me to fü nih, wü di enga *Yïsarayele, gü ba dene, ‘Me ka-ye ngbee biringbö. Ah de miri ka-nih me-ye. Kpara te fa engu nda ma. ");
INSERT INTO muh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mü le Me de maguma mü ꞌburu. Mü o fïngangü ka-mü kpah ꞌburu tete. Mü le ngü kaka de wazi mü kpah ꞌburu. Mü to te-mü kpah ꞌburu fefe.’ Dela kpeke Rïrï te Me to fü nih, te fa wü bu ye ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Eꞌbaꞌbasu na gü ba dene, ‘Mü le wü bu mü, baka e te mü ngbü ele küte mü.’ Dela gina wü kpeke *Rïrï ta te Me to fü nih. Gara rïrï te fa ewü dela nda ma.” ");
INSERT INTO muh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Te mürü rïrï la je ngü te Yesu mala la, fü ngü la areke tete afa sü. Fü ah alügü ngü fü Yesu, gü ba dene, “Wayi, mere kpara, mü mala zu ngü fanü fanü. Me ka-ye kü biringbö. Gara kpara te fa engu kpo fï ma. ");
INSERT INTO muh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Te mü le Me de maguma mü ꞌburu, o fïngangü ka-mü ꞌburu tete, fü mü ale ngü kaka de wazi mü kpah ꞌburu, fü mü adu ale wü bu mü, baka e te mü ngbü ele küte mü la, ngü ka-mü ena areke gbü jia Me afa sü. Gele ka wü kundu nih gü ba, te mü le de ngü ka-ni reke gbü jia Me la, ah le de mü za nü, awa fefe. Amba ngü ka lele fa ngü ka gele la ka.” ");
INSERT INTO muh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Fü ngü ka mürü rïrï la adu areke gbü jia Yesu afa sü. Fü Yesu adu amala ngü fefe, gü ba dene, “Wayi, fïngangü ka-mü mbi. Mü eyi gbamari akoro zu kpara ka Me.” Dela ngü ta te Yesu mala, teka kpeke Rïrï ka Me. Fütanga ngü la, gara kpara, te du le aga yïkï ake di, nda tïne ma. ");
INSERT INTO muh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Fütanga ngü la, fü Yesu angbü da erï wü kpara etambasü ka *Mere Kambü ka Me, gü ba dene, “Wü *mürü rïrï mala teka *Kurisito, Miri te Me ena atima füh kotö ne, teka aküwa wü kpara, gü neh fe? Wüh gü ba, ‘Miri la ena adi de kundu ye Mere Miri *Davidi, te ena angbü gbü nzö ani kpah baka Davidi,’ ah bala de? Amba Miri la ena angbü baka Davidi fanü? ");
INSERT INTO muh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Angü Davidi ba ta ngü cu me-ye, gbü wazi ka *Nzïla Wazi Me, gü ba dene, ‘Me mala ngü fü Miri ka-ni, gü ba dene, “Ye ngbü gbü kokpa ka-ni sene. Angü ni fe ye, o eyi Mere Miri. Te di bala, ye ena angbü gbü nzö wü kpara ꞌburu! Angü ni ena ao wü vügü ka-ye ꞌburu esa lö ye!” ’ ");
INSERT INTO muh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dela ngü ta te Davidi ba teka Miri la, gü ba, ‘Engu de miri ka-ni.’ Te di bala, wawazi na fa nda Davidi de? Ma emala fü yi, gü ba, ngü kaka ena afa nda Davidi afa.” Dela ngü ta te Yesu mala teka Mere Miri, te Me ena atima teka aküwa wü kpara. Fü mere bi wü kpara angbü eje ngü kaka-na la de mere tadu. ");
INSERT INTO muh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Fü Yesu adu arï wü kpara la, gü ba, “Yi ceka ꞌbe teka ngü ka wü *mürü rïrï. Yi mere e angbü baka ewü de. Angü wüh le de wü kpara ꞌburu di ecu ngü ani. Te di bala, fü ewü angbü eto ngboro bongo eküte wü, endondoro di esüka wu kpara. Wüh ngbü ele de wü kpara ꞌburu ngbü egü mandï fü ani baka wü mere kpara. ");
INSERT INTO muh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Te wüh koro kpa *esambü ka biti-te la, wüh ngbü ele adi engbü füh züka da-ngbüngbü te reke areke. Gbü wü sü ka karama, wüh ngbü emere kpah bala. Wüh ele ka-wü bü adi engbü gbü wü sü ka wü cögbörö kpara. ");
INSERT INTO muh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wüh le de wü kpara ꞌburu wu ani baka züka wü kpara ka Me. Te di bala, wüh ngbü emere dela züka ngü te ena reke gbü jia Me? Ah bala de! Te wüh ngbü eku gba fü Me la, wüh ngbü eza mere bi wü ngü te komö wü gbe! Amba ngü ka Me emaguma ewü nda ma. Wüh ngbü kpah da ezi wü e ka wü würüse wökö de mani. Te di bala, Me ena ato mere siti kuru te wü mürü rïrï la te gara afa sü.” Dela ngü te Yesu mala, teka wü mürü rïrï la. ");
INSERT INTO muh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Fütanga ngü la, fü Yesu adu angbü kötö ede kuwu, te wü kpara ngbü eto takpa fü Me gbügbü na. Fü ah angbü eceka wü kpara, te ewü ngbü eto takpa ka-wü la. Wü gara kpara te ewü di de mere bi wü e esaka wü, wüh ngbü eto nda-wü mere bi jiase. ");
INSERT INTO muh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Fü gara würüse wökö, mürü cïnga, ayia akoro ato nda-ye mba ꞌduwa enga jiase ngbee ꞌbasu, baka e te wüh ena ase ambata biringbö di. ");
INSERT INTO muh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Fü Yesu adu amala ngü fü wü kpara ka-ye, gü ba dene, “De-yi, yi ceka la ngü ka würüse la. Ngü te ma emala dene, ah de zu ngü. Jiase te würüse wökö la to ne, ah reke gbü jia Me, fa nda wü bu ye la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Angü wü kpara de mere bi e esaka wü ne, e te ewü to fü Me, ngüngü gbü jia ewü nda ma, angü dudu ladü esaka ewü. Amba würüse la to nda-ye jiase eyi ꞌburu. Dudu na esasaka, te engu ena ase mba enga zü-e di, nda tïne ma.” Dela ngü te Yesu mala teka takpa, te wüh ngbü eto fü Me. ");
INSERT INTO muh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Fütanga ngü la, fü wü Yesu ayia ace tambasü *Mere Kambü ka Me. Fü gara *kpara ka Yesu arü amala ngü fefe na, gü ba dene, “Mere kpara deyï, ye ceka la, züka Kambü ka Me ne, te wüh fa de angbe cögbörö da ne!” ");
INSERT INTO muh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu gü ba dene, “Mü ceka la bü mere züka Kambü ka Me ne? Te gara, wüh ena amürü kambü la amürü ꞌburu asidi. Da biringbö, te wüh ena ace ao füh kiri ye, ena adi ma.” ");
INSERT INTO muh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Fü ewü ayia ace sü la, adu anü alï kpa füh da de ïrï ye Olïve, adu angbü eceka Mere Kambü ka Me, te di kpa eta ngu de kpala. Fü Petero ayia ake *Yakobo, *Yüwane bete Anderïya, anü ayi-ta Yesu, ");
INSERT INTO muh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","gü ba, “Mere kpara, gara ngü ladü te ani le ayi-ta ye di. Ye gü ba, ‘Wüh ena amürü mere Kambü ka Me la asidi.’ Ngü la ena amere te-ye neh elaye? Anga ngü, te ena agü tamu ngü la fü ani, gü ba, sïkpï la koro eyi gbamari, ah de ne ngü ne?” ");
INSERT INTO muh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Fü Yesu alügü ngü fü wü kpara ka-ye, gü ba, “Yi ceka te-yi mbi teka wü mürü fiti, angü wüh ena afiti yi. ");
INSERT INTO muh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Angü mere bi wü kpara ena akoro, amere mani te ïrï ra, afiti wü bu wü, gü ba, ‘Ani de Miri, te Me tima ani me-ye.’ Te di bala, mere bi wü kpara ena ale ngü ka-ewü la. Amba nda-yi, yi mere e ale ngü ka-ewü la de. ");
INSERT INTO muh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","Angü mere bi wü ngü ladü, te wüh ena amere te-wü feke, o *adu sïkpï la koro la de. Nguwa wü kpara ena ayia atï de gü gbü nzö nguwa wü gara kpara. Yiki-tö ena amere te-ye gbü mere bi wü sü füh kotö ne. Kpah bala, gbü wü gara sü, mere siti kpïrï tala ena atï gbü nzö wü kpara. Dela ꞌburu wü ngü te ena amere te-wü füh kotö ne, o adu sïkpï koro la de. Wü ngü la ꞌburu ena adi baka gina keke, te kpo da emere würüse te ele ayaka. Te di bala, yi mere e akpe cürü de, angü Me ladü, te ena areke wü ngü la ꞌburu, ba e te engu le. ");
INSERT INTO muh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amba nda-yi, yi ceka te-yi mbi, de yi rü kpekpeke, angü wü vügü ka-ra ena azoro gara yi, anü di ato fü wü cögbörö kpara, de wü miri. Fü ewü amï yi teka ngü ka-ra. Te di bala, yi ena amala ngari ra fü wü mere kpara la. ");
INSERT INTO muh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Angü, ah le de wüh mala ngari ra fü nguwa wü kpara füh kotö ne ꞌburu feke, o adu sïkpï koro la de. ");
INSERT INTO muh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gbü ra te yi ena arü engagira wü mere kpara la, yi mere e angbü de mere fïngangü gbü nzö yi de. Yi mala bü mene ngü te *Nzïla Wazi Me ena ato te komö yi. Angü, ngü te yi ena adi emala la, ah ena adi de ngü kaka, ah de ngü ka-yi nda de. ");
INSERT INTO muh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Yi ngbü ꞌbe ꞌbe ꞌbe, angü wü kpara ꞌburu ena angbü ekpü yi teka ngü ka-ra. Wü di enga ni yi ena afü te-wü ba wü vügü ka-yi, agü tamu yi fü wü vügü, amörö yi. Wü wö yi ena amere kpah bala, fü wü di yi amere kpah bala. Amba ah le de mü i maguma mü, zalü koro di gbü ra te cïnga la ena anza, fü mü aküwa.” ");
INSERT INTO muh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Fü Yesu adu amala gara ngü fü ewü, teka *Mere Kambü ka Me, te wüh ena amürü la, gü ba, “Fanü fanü sirimbi ladü te ena agü tamu sïkpï la fü yi. Angü gara vügü ka Me ladü, te ena akoro, asiti sü kpa esa Mere Kambü ka Me.” Dela ngü te Yesu mala fü wü kpara ka-ye, teka sirimbi, te ena akoro agü tamu sïkpï, te wüh ena amürü Mere Kambü ka Me agbü Yerüsalema tete na. (De-mü, te mü ngbü etanga ngü ne, ah le fü mü ao fïngangü ka-mü teka aje si-ngü la mbi mbi mbi.) Fü Yesu adu kpah amala fü ewü, gü ba dene, “Te yi wu sirimbi la, yi mere e angbü agbü *Yudaya de. Yi kpe ꞌduwa kpa enzö mere gümba, agbü gü! ");
INSERT INTO muh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Te siti ngü la koro maka mü, te mü ngbü efe te-mü kpa esa e la, mü mere e adu arï kpa esambü, akö wü e ka-mü, tïne de. Mü kpe ꞌduwa akpe, angü siti ngü la ena amaka mü. ");
INSERT INTO muh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Te siti ngü la koro maka mü da esö e ka-mü kpa gbü yï la, mü mere e adu kpa ekötï, ato züka bongo te mü, kpah de. Mü kpe ꞌduwa akpe. ");
INSERT INTO muh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Angü sirimbi la ena agü tamu mere siti cïnga, te ena akoro eküte yi, te fa wü gara cïnga füh kotö ne ꞌburu. Yi ceka la, mere cïnga ka wü würüse, te ewü di de bu wü, kpah bete mene ewü, de te ewü di de vürü wü jaji eküte wü ne. Dela ne cïnga ne! ");
INSERT INTO muh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ah le fü yi adi eku gba fü Me, de siti ngü la mere e akoro gbü bigü de. Angü agö bete zü ena amere wü kpara, te ewü ena akpe la. ");
INSERT INTO muh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kü baka te Me mere kotö ne, mere cïnga baka e la mere te-ye nda la de. Gara cïnga te ena akoro fütanganga na, baka engu la, ah ena adi kpah ma. ");
INSERT INTO muh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Fü Me adu afï nga wü kpara ka-ye, te engu fe ewü ne, gü ba, ‘Te di bala, ni ena akolo sïkpï la mba cogbo, teka ngü ka wü kpara ka-ni la, angü wüh ena akpi.’ Te Me ena amere ta bala de la, de bane kpara biringbö, te ena aküwa esaka siti ngü la, ena adi kpo ma.” ");
INSERT INTO muh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Fü Yesu adu kpah, amala gara ngü fü wü kpara ka-ye, gü ba, “Gbü wü sïkpï la, wü mürü wu ena akoro, adi efiti wü bu wü. Gara ena agü ba, ‘Ni de miri, te Me tima ni teka aküwa wü.’ Gara ena agü ba, ‘Ni nda-ni de *mürü dofo, te ni ngbü emala ngari Me fü wü kpara.’ Wüh ena akpo angbü emere bi wü ngü ka talara, te ena afiti wü kpara ꞌburu. Wüh ena agïrï kpah kaje teka afiti cu yi, wü kpara ka-ra. Te di bala, yi ceka te-yi mbi, yi mere e aje ngü ka wu ka-ewü la nda-yi de! Te gara kpara mala ngü fü yi, gü ba, ‘Miri te Me tima ne koro eyi! Ah ladü kpakine,’ anga ‘Ah ladü kpane,’ yi mere e ale ngü kaka la nda-yi kpah de. ");
INSERT INTO muh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yi ceka te-yi mbi, angü ma ngbü eyi emala ngü ne fü yi te enga gina dene, o ngü la koro la de, teka fü yi amba jia yi amba, angü wü mürü wu la ena afiti yi. ");
INSERT INTO muh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Fütanga ngü la, gara wü ngü ena ayia kpah amere te-wü, baka e ta te wüh ba gbü *Ngari Me, gü ba dene, ‘Wü lara ngü ena akpo da emere te-wü kpa gbü kpï. Angü kokpï de wü e kpa tikpi ꞌburu ena akpo da eyiki ");
INSERT INTO muh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wü küfara ena akpo kpah da egügürü. Ra ena afü te-ye baka biti. Fe tï adu asü kpah de.’ ");
INSERT INTO muh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Fütanga ngü la, de-ra *Ye Kpara ka Kpï, fü ra adu tïne akoro. Wü kpara ꞌburu ena aci awu ra kpa gbü kpï, te ma ngbü ekoro de mere wazi, baka Mere Miri. Fü ewü aci ꞌburu acu ngü ra. ");
INSERT INTO muh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Fü ra ayia atima wü *malayïka ka-ra, teka abiti wü kpara ka-ra, te ma fe ewü. Wüh ena abiti ewü edebu sü bala ne ꞌburu, akoro di fere. Fü a angbü tundu de ewü fï mere badi.” ");
INSERT INTO muh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Fü Yesu adu amala gara ngü fü ewü gbü mani, gü ba, “Ngü ka dudu ka-ra, ah baka ngü ka wü rü. Angü te yi wu wü rü te ngbü eyi ayi, da eto to kpa wü la, yi ngbü egü neh fe? Yi tï eyi awu, gü ba, bigü koro eyi. Ah bala de? ");
INSERT INTO muh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kpah bala, te yi wu wü sirimbi, te ma mala nganga fü yi ne eyi la, de yi wu awu, gü ba, sïkpï ka dudu ka-ra la koro eyi gbamari. ");
INSERT INTO muh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ngü te ma emala dene, ah de zu ngü. Siti cïnga la ena amaka yi fanü, amba ngü la tï anza ngü ka-yi, wü kpara ka-ra nda de. ");
INSERT INTO muh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ngü te ma ngbü emala fü yi, ah de kpeke ngü, te ena angbü fï mere badi. Angü Me ena agara kotö ne ake kpï, fü ngü ka-ewü anza ꞌburu. Amba ngü ka-ra tï anza nda de.” ");
INSERT INTO muh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Fü Yesu adu kpah, amala fü wü kpara ka-ye, gü ba, “Te yi le ayi-ta ra, gü ba, sïkpï te ma ena adu akoro tete na, ena adi elaye la, ma ena alügü ngü fü yi, gü ba, kpara biringbö, te wu ngü la, nda ma. Wü *malayïka agbü kpï, wüh wu kpah de. De-ra, te ma di de Ye Me, ma wu kpah de. ꞌDuwa Wüba Me, ah wu sïkpï la duu me-ye. ");
INSERT INTO muh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Te di bala, yi ceka te-yi mbi, da ecï sü, angü yi wu sïkpï la nda-yi de. ");
INSERT INTO muh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ngü la ena adi baka mere kpara te yia, ce gba ye, anü kpa gbü gara sü. Fü ah aï wü kpara ka tima ka-ye, agafa tima fü ewü, te ewü ena adi emere sidi nga ni. Fü ah amala ngü fü kpara te ecï möngïtï, gü ba, ‘Ye cï sü mbi mbi mbi, da ecï nga dudu ka-ni.’ ");
INSERT INTO muh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kpah bala, ma emala ngü fü yi, gü ba, yi ceka te-yi mbi, da ecï nga dudu ka-ra, angü yi wu sïkpï ka dudu ka-ra la nda-yi de. Anga ma ena adu akoro neh etamurago, etü biti, te gina gba moko-ngü, anga kpurutokokpï? Yi wu kpah de. ");
INSERT INTO muh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yi ceka te-yi mbi, angü te ma du koro maka yi gbü ïrï-to, anga da era ra la, ah ena adi esiti.” ");
INSERT INTO muh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dela wü ngü ta te Yesu mala fü wü kpara ka-ye, teka ngü te ena amere te-ye te gara. Yesu mala ngü la kpah fü nih ꞌburu, gü ba, “Nih ceka te-nih mbi mbi mbi, da ecï sü.” ");
INSERT INTO muh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ngü ne ngbü emere te-ye ta gbü mere sïkpï ka wü *Yïsarayele, te ewü eï, gü ba, *Pasïka ne. Ah de *sïkpï te wüh zü ambata de kö gbü ye de. Te du sïkpï ka Pasïka la lakï tïne ngbee sïkpï ꞌbasu ne, fü wü mere *kovo ka wü Yïsarayele ayia abiti te-wü, de wü *mürü rïrï, de wü mere *mürü gele. Fü ewü akpo angbü egïrï kaje, te ani ena azoro Yesu tete na gbü zi, amörö. ");
INSERT INTO muh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Fü ewü angbü ero mö esüka wü teka ngü la, gü ba dene, “Ani ceka ꞌbe, angü mere bi wü kpara biti te-wü eyi sene, teka mere sïkpï te di gbamari ne. Te ani zoro Yesu gbü jia ewü la, wüh ena aci de gü eküte ani! Te di bala, ani gïrï kaje, de ani zoro engu gbü zi.” ");
INSERT INTO muh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ta gbü wü sïkpï la, wü Yesu ngbü ta engbü ka-wü agbü Betanïya, agba gara komoko de ïrï ye Sïmüna, ta te di de *jiakö te ye ne. Fü gara würüse akoro amaka ewü, te ewü ngbü da ezü e kpala. Würüse la koro de *züka se-mü esaka ye, te wüh se de mere bi jiase. Fü würüse la aza enga kölökö de se-mü la gbü ye, ayia amï mö kölökö la, akuru mbürrrü! Fü ayia atökö se-mü la ꞌburu gbü nzö Yesu. ");
INSERT INTO muh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Te wü gara kpara wu ngü te würüse la mere bala ne, fü ngü la asiti eküte ewü ꞌduwa ba-neh-ene-la. Fü ewü akpo da emala ngü esüka wü, gü ba, “Würüse la mere ngü la bala, neh teka ne? Ah za züka e ne, etökö kötö bü kükürü kükürü bala! Dela züka ngü? ");
INSERT INTO muh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ah le ta de wüh za züka se-mü la, cïnzï de mere bi jiase, teka ale ta-ngü di eküte wü mürü cïnga.” Fü ewü aci ꞌburu ekpülü würüse la. ");
INSERT INTO muh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Fü Yesu adu arü amala ngü fü ewü, gü ba dene, “Yi ekpülü engu neh teka ne? Yi ce engu ace. Ngü de te engu mere, te engu tökö se-mü gbü nzö ra ne, ah de mere züka ngü gbü jia ra. ");
INSERT INTO muh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Angü du sïkpï ka-ra füh kotö ne mba cüküꞌdaye. Te yi le ale ta-ngü te wü mürü cïnga, yi tï eyi amere ngü la sidi nga ra, baka e te yi le, angü mere bi wü mürü cïnga ladü füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amba würüse ne tökö se-mü gbü nzö ra, baka e te wüh ngbü emoko se-mü eküte kövö. Kükürü de, angü sïkpï ka kpi ka-ra koro eyi gbamari. ");
INSERT INTO muh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngü te ma emala dene, ah de zu ngü. Gbü wü sü ꞌburu te wüh ena amala ngari ra tete fü wü kpara füh kotö ne, wüh ena angbü efï nga würüse ne, kpah da emala nga ngü de te engu mere ne.” ");
INSERT INTO muh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Fütanga ngü la, fü *Yuda Keriyota, te di biri kpara esüka wü *kpara ka Yesu nzükpa de füh ye ꞌbasu ne, ayia anü kpaka wü mere *kovo ka wü Yïsarayele. Fü ah amala ngü fü ewü, gü ba, “Ni ena agïrï kaje, te ni ena ato Yesu di fü wü.” ");
INSERT INTO muh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Te wü mere kpara la je ngü te Keriyota mala fü ewü de bala ne, fü ngü la areke gbü jia ewü ꞌduwa ba-neh-ene-la. Fü ewü alügü ngü fefe na, gü ba dene, “Te ye to Yesu fü ani fanü fanü la, ani ena ato jiase fü ye.” Te di bala, fü Keriyota akpo da egïrï züka kaje, te ni ena agü tamu Yesu tete fü ewü. ");
INSERT INTO muh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Dene gele ta te wü di enga *Yïsarayele ngbü emere teka *Karama ka Pasïka. Gbü gina sïkpï ka Pasïka la, wüh mürü kötï ꞌburu ngbü eza togo kambiliki, anü di kpaka wü *mürü gele ka Mere Me, de wüh wa, ato fü Me. Te mürü gele wa eyi, fü wü mürü kötï aza so kambiliki la, anü di, azü de wü kpara agba wü ꞌburu. Te di bala, te sïkpï ka Pasïka la koro tete na, fü wü *kpara ka Yesu arü amala ngü fefe na, gü ba dene, “Mere kpara deyï, ani ena azü nda-ani karama ka Pasïka ne, neh kaye? Ye mala emala fü ani, de ani nü, teka areke sü engu na.” ");
INSERT INTO muh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Fü Yesu ayia atima wü kpara ka-ye ꞌbasu, gü ba, “Wü nü kpa gbü Yerüsalema kpala. Wü ena amaka gara komoko kpala, te se ngu ka-ye, ego di. Wü fa nga komoko la, zalü koro di gbü kötï, te engu ena arï gbügbü. ");
INSERT INTO muh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","De wü mala ngü fü mürü kötï la, gü ba, ‘Mere kpara ka-ani gü ba dene, “Ye to kambü ka ngba fü ani, teka fü ani azü karama ka Pasïka ne gbügbü, de wü kpara ka-ni.” ’ ");
INSERT INTO muh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Mürü kötï ena agü tamu mere guvu kambü, te di kpa tikpi füh kiri ye, de wü e gbü ye ꞌburu nzo. Te di bala, de wü reke zü-e fü ani kpala.” ");
INSERT INTO muh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Fü wü kpara ꞌbasu la ayia anü agbü Yerüsalema. Fü ewü amaka wü e ꞌburu, kpah baka e te Yesu mala fü ewü. Fü ewü areke sü kpala teka azü Pasïka ka-wü la. ");
INSERT INTO muh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Etamurago la, fü wü Yesu ayia de wü *mürü tima ka-ye, anü akoro agbü Yerüsalema. Fü ewü anü akoro agbü sü, te wüh reke de kpala. ");
INSERT INTO muh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Fü ewü akpo da ezü karama ka-wü. Te wüh ngbü ezü e tete, fü Yesu ayia amala ngü fü wü kpara ka-ye la, gü ba dene, “Ngü te ma emala fü yi dene, ah de zu ngü. Gara kpara ladü esüka yi sene, te ena ato ra fü wü vügü. A ngbü ezü e ne cu ake di!” ");
INSERT INTO muh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Te wüh je ngü la bala, fü ngü la ato mere cïnga fü ewü. Fü ewü akpo da eyi-ta Yesu, te nga wü biri biri, gü ba dene, “Ah de ni? Ni ena ato ye me-ni?” ");
INSERT INTO muh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu gü ba dene, “Ah de kpara esüka yi, nzükpa de füh ye ꞌbasu ne. Kpara te a ngbü ezü e ake di tundu gbü gada biringbö ne. ");
INSERT INTO muh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","De-ra, *Ye Kpara ka Kpï, ma ena amaka cïnga, fü ra akpi, baka e ta te wüh ba gbü *Ngari Me teka ra ne. Amba ah ena adi de mere cïnga fü mene kpara, te ena ato ra fü wü vügü ne. Dela cïnga nda de! Ah reke ta pe, te wüh ena abï engu nda-wü ta de.” ");
INSERT INTO muh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baka te ewü du ngbü kpah ezü e ka-wü la, fü Yesu ayia akpo da emere gara ngü. Fü ah ayia aza ambata, agbo nga ïrï Me tekaka na, adu akukuru, ayia agafa fü ewü, gü ba dene, “Dene küte ra. Yi za eza, de yi zü.” ");
INSERT INTO muh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Fü engu adu aza ndüꞌba de ngu *vinü gbü ye, agbo nga ïrï Me tekaka, ayia ato fü ewü. Fü ewü anzö te nga ewü ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Fü ah adu amala ngü fü ewü, gü ba dene, “Dene *ngüte ra. Yi nzö enzö, ba e te yi enzö *ngüte de wü Me. Angü ngüte ra engu ne, ah ena atökö, teka areke ngü ezengba wü kpara de wü Me. ");
INSERT INTO muh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngü te ma emala dene, ah de zu ngü. Akpo enatikine, ma tï anzö ngu vinü tïne kpo de, zalü akoro di gbü sïkpï te Me ena ao ra Mere Miri tete na.” ");
INSERT INTO muh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Te wü Yesu zü karama la nza tete, fü ewü ayia abï ci ka Me. Fü ewü ayia ace sü la, anü kpa füh da de ïrï ye Olïve. ");
INSERT INTO muh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Fütanga ngü la, o wü Yesu ngbü enü agbü Getesemane, fü ah adu amala ngü fü wü kpara ka-ye, gü ba dene, “Yi ena akpe abaya ꞌburu ka cürü, ace ra kpikpi ra, baka e ta te wüh ba gbü *Ngari Me, gü ba, ‘Wüh ena amörö kpara de te ngbü eceka kpï fütanga wü kambiliki ne, fü wü kambiliki la adu abaya ka-wü ꞌburu.’ ");
INSERT INTO muh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ngü ma! Te ma zükü gbü kpi eyi la, ma ena anü sü engagira nü agbü *Galïlaya. Fü yi adu anü amaka ra kpala.” ");
INSERT INTO muh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Fü Petero ayia amala ngü fü Yesu, gü ba dene, “Ni kpe de! Te wü bu ni kpe akpe ꞌburu la, nda-ni, ni tï ace ye de.” ");
INSERT INTO muh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu gü ba dene, “Petero enga wüna, ngü te ma emala dene, ah de zu ngü. Enatikine, gbü biti ne, o moko-ngü mï eꞌbaꞌbasu koko la de, mü ena acere nga mü du bata, gü ba, ‘Ni wu ra de.’ ” ");
INSERT INTO muh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Fü Petero adu kpah amala ngü la kpekpeke, gü ba, “Ma ce mü de. Te ah kpah bü de kpi la, nih ena akpi ake nih ma! Ma kpe cürü de!” Fü gara wü *kpara ka Yesu, fü ewü aci ꞌburu, amala nda-wü kpah bala. ");
INSERT INTO muh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Fü wü Yesu anü akoro agbü Getesemane. Fü Yesu amala ngü fü wü kpara ka-ye, gü ba dene, “De-wü deyï, wü ngbü la sene. Ni ena anü nda-ni kpa edere sü cüküꞌdaye, teka aku gba fü Me.” ");
INSERT INTO muh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Fü engu ayia aza Petero, ake *Yakobo bete *Yüwane, anü de ewü cüküꞌdaye kpa edere sü. Fü mere cïnga bete fïngangü akpo da emere Yesu, fü mamaguma akpo da egürü. ");
INSERT INTO muh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Fü ah amala ngü fü wü Petero, gü ba, “Maguma ra te egürü ka mere cïnga, baka e te ma ena akpi akpi la. Yi ngbü ede ra sene, adi ecï sü.” ");
INSERT INTO muh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Fü engu ayia anü cüküꞌdaye edere sü. Fü ah abuka gbüra ye kötö, aku gba fü Me, gü ba, “Wüba, te ah reke te mü la, kpi ka-ra te ekoro ne, de mü nzi ngü la eküte ra asidi. ");
INSERT INTO muh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wayi, Wüba, ngü te ena afa mü, ah nda ma. Te ah gbü jia mü mbi la, ma ele de mü nzi siti ngü la eküte ra asidi. Ngü la, ma ce o eyi esaka mü, de ah ngbü ba e te mü ngbü ele. Ah di ba e, te ma le me-ra ne, de.” ");
INSERT INTO muh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Fü engu ayia adu kpaka wü Petero, amaka ewü da era ara. Fü ah amala ngü fü Petero, gü ba dene, “Ah mere baye? Mü ngbü era ka-mü ara? Mü tï angbü ezükü, fü nih acï sü de nih ma mba cüküꞌdaye, nda-mü de? ");
INSERT INTO muh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ah le de yi di ecï sü, da eku gba fü Me, angü *Satana ena afiti yi! Wayi, ah fanü, maguma yi ngbü ele ngü ka-ra, amba wazi yi, te yi ena amere ngü la di, nda ma.” ");
INSERT INTO muh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Fü Yesu adu kpah anü agbü sü, te engu ngbü eku gba fü Me tete na ne. Fü ah aku gba fü Me, amala ngü kpah baka engu de tïne ne. ");
INSERT INTO muh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Fütanga ngü la, fü ah adu kpah amaka wü Petero fï da era ara, angü ra ngbü emere ewü efa sü. Fü ngü anza gömö ewü ꞌburu, ka vi-jia. ");
INSERT INTO muh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Fü engu ayia anü kpah kpala, aku gba fü Me, adu kpah amaka ewü fï da era ara. Fü ah ayia amala ngü fü ewü, gü ba dene, “Yi la fï bü era ara? Ah ti eyi! Angü sïkpï ka-ra, *Ye Kpara ka Kpï tï eyi enatikine! Wüh to ra eyi fü wü vügü! ");
INSERT INTO muh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yi yia la eyia, nih reke te-nih! Yi ceka la! Kpara te ena agü tamu ra ne, ah eyi te ekoro de kpane!” ");
INSERT INTO muh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Baka te Yesu ngbü la fï bü da emala ngü la fü wü kpara ka-ye, fü *Yuda Keriyota, te di de biri kpara esüka wü *kpara ka Yesu, nzükpa de füh ye ꞌbasu ne, ayia akoro, de mere bi wü kpara gbü nga ye, te wü angbe cögbörö *kovo tima ewü, azoro Yesu. Wüh koro ta de wü mere maguruma, de wü ngbondo esaka wü. ");
INSERT INTO muh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Angü Yuda Keriyota mala ta fü ewü, gü ba, “Ni ena agü tamu Yesu fü wü. Mene kpara te ni ena afaka, dela eyi engu. Wü zoro engu gö! anü di kpaka wü mere kpara.” ");
INSERT INTO muh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Fü Keriyota akoro kürrrü, afaka Yesu, gü ba dene, “Mere kpara, mü ladü!” ");
INSERT INTO muh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Fü ewü ayia ꞌduwa azoro Yesu. ");
INSERT INTO muh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Fü gara kpara ka Yesu ayia aza mere maguruma ka-ye, ade güje gara kpara ka tima ka mere kpara füh kpökpö, akolo tuu! ");
INSERT INTO muh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Fü Yesu arü amala ngü fü wü kpara te ewü zoro engu ne, gü ba dene, “Dene neh ene ngü ne? Ah mere neh baye te yi koro de wü mere maguruma, de wü ngbondo esaka yi ne. Ma de siti kpara? ");
INSERT INTO muh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Gbü wü sïkpï ne ꞌburu, ma ngbü engbü de wü yi, etambasü *Mere Kambü ka Me, da erï wü kpara kpala. Yi wu bala de? Yi le ta azoro ra kpala de, neh teka ne? Ah mbi. Yi zoro ra ezoro, angü wüh ba ta ngü la eyi gbü *Ngari Me teka ra bala.” ");
INSERT INTO muh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Fü wü *kpara ka Yesu aci ꞌburu, akpe, ace engu. ");
INSERT INTO muh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Gara jaji komoko ta ladü kpala, te bu mba bu bongo ka rara te-ye, angbü efa nga wü Yesu, te wüh zoro engu. Fü ewü adu afü te-wü azoro kpah jaji komoko la. ");
INSERT INTO muh_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Fü jaji komoko la ayia akpe, ace bongo ka-ye ciki esaka ewü, anü sü ngïrïmu. ");
INSERT INTO muh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Fü wü kpara, te ewü zoro Yesu ne, aza engu anü di kpa engagira mere kpara füh kpökpö ka wü di enga *Yïsarayele. Angü wü mere *kovo ka wü Yïsarayele biti te-wü kpala, teka akolo ngü ka Yesu. ");
INSERT INTO muh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Amba Petero, mü ngbü nda-mü da efa nga wü Yesu, mba kpa sidi gbü zi, zalü koro di etambasü ka mere kpara füh kpökpö. Fü mü anü arï angbü kötö, eya te-mü te wa, esüka wü komoko ka mere kpara füh kpökpö la. ");
INSERT INTO muh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Fü wü mere kovo la abiti te-wü, akpo da egïrï mene wü kpara, de te ewü ena amala ngü eküte Yesu de wu, gü ba, “Engu mere siti ngü eyi fanü,” teka de ani mörö engu tete na. Wüh gïrï ngü la ma, wüh maka nda-wü de! ");
INSERT INTO muh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Angü mere bi wü kpara, te ewü koro mala siti ngü eküte Yesu ne, ngü ka-ewü ka-ye ꞌburu kpikpi ye kpikpi ye, angü ah ka-ye ꞌburu de wu. ");
INSERT INTO muh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Fü wü gara kpara ayia arü amala ngü eküte Yesu de wu, gü ba dene, ");
INSERT INTO muh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ani je gara siti ngü ta te Yesu mala, gü ba, ‘Ni ena amürü *Mere Kambü ka Me, te wü kundu ani jï ne, ꞌburu asidi, fü ni adu ajï alügü gbü sïkpï ngbee bata. Amba, ah ena adi tïne de mene kambü, te wü kpara jï de kpa wü ne de.’ ” ");
INSERT INTO muh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amba ngü ka-ewü, te ewü mala la, ah koro biringbö kpah de. Ah ka-ye fï bü kpikpi ye kpikpi ye. ");
INSERT INTO muh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Fü mere kpara füh kpökpö ayia arü tikpi. Fü ah amala ngü fü Yesu, gü ba dene, “De-ye deyï, ye lügü ngü fü ani de, neh teka ne? Ye je ngü de te wü kpara ngbü emala eküte ye ne de?” ");
INSERT INTO muh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Fü Yesu anga ka-ye tïïï, ah lügü ngü nda de. Fü mere kpara la adu ayi-ta Yesu kpekpeke, gü ba dene, “Yesu, mü de neh da? Mü mala la zu ngü fü a! Mü ngbürü de Ye Me, te engu tima füh kotö ne teka aküwa a ne?” ");
INSERT INTO muh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu gü ba, “Wayi, ah ngbürü bala. Te gara yi ena awu ra, *Ye Kpara ka Kpï, te ma ena angbü gbü kokpa ka Me, baka Mere Miri! Fü ra adu kpah akoro sene de mere wazi ka Me, baka agö te biti te-ye teka alï!” ");
INSERT INTO muh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Te mere kpara füh kpökpö je ngü te Yesu mala la, fü ah ayia asörö bongo eküte ne ꞌduwa traaa! Fü engu amala ngü, gü ba, “Apa! Komoko ne le afü te-ye ba Me? Yi wu eyi? Ngü nza eyi dela! Nih edu kpah agïrï kpara, te ena amala nga siti ngü kaka, neh teka ne? Ah mala siti ngü ka-ye tïne cu eyi de komö ye dela! Yi ngbü efï nda-yi neh baye?” Fü ewü aci ꞌburu amala ngü, gü ba dene, “Ah de siti kpara! Wüh mörö engu amörö!” ");
INSERT INTO muh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Fü ewü akpo da ememere engu. Gara ewü esü ngüsü gbügbüra na. Wü gara i jijia na, da emiki engu, gü ba dene, “Te ye gü ba, ‘Ni de *mürü dofo ka Me,’ la, de ye mere la ngü ka talara. Ye gü la ïrï kpara de te mï ye ne.” Fü wü marajümïya ka mere kpara la aza engu, anü di, da ebebe. ");
INSERT INTO muh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Petero, mü ngbü ka-mü fï bü etambasü ka mere kpara la, da eya te-mü te wa. Fü gara jaji würüse, kpara ka tima ka mere kpara la, ayia akoro aceka jia Petero, ayi-tata, gü ba dene, “Ye de neh da? Ye kpah de süka wü kpara, te ewü ngbü endoro gbü nga Yesu ne de?” ");
INSERT INTO muh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Fü cürü ayia arï te Petero. Fü ah acere nga ye, gbere, gü ba dene, “Ngü te mü mala la, ma je nda-ra mbi mbi de. Mü gü neh fe?” Fü Petero ayia ace da wa la, anü arü kpa emöngïtï ka ꞌbaranga la. ꞌDuwa fü moko-ngü ayia amï gina koko. ");
INSERT INTO muh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Fü würüse la adu kpah amaka Petero. Fü ah arü amala ngü fü wü bu ye, gü ba dene, “Wü ceka la! Komoko la, ah ka-ye de kpara ka Yesu!” ");
INSERT INTO muh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Fü Petero adu acere nga ye kpah gbere, gü ba, “Aꞌa! Ni wu komoko ka-ye la nda-ni de.” Fütanga ngü la mba cüküꞌdaye, fü wü kpara la adu amala ngü fü Petero, gü ba dene, “Fanü fanü, ye de kpara ka Yesu, angü ye kpah de kpara ka *Galïlaya, bakaka.” ");
INSERT INTO muh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Fü Petero ayia akïna te-ye, gü ba, “Ma wu komoko la nda-ra de.” ");
INSERT INTO muh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Petero bü te emala ngü la de, fü moko-ngü ayia amï eꞌbaꞌbasu koko. Fü Petero adu afï nga ngü, ta te Yesu mala fü ye, gü ba, “Ye ena acere nga ye du bata, o moko-ngü mï eꞌbaꞌbasu koko la de ne.” Fü ngü la ato mere cïnga fü Petero. Fü ah ayia akpo da eku gba de mere ngura ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gügü kpurutokokpï la, fü wü mere *kovo ka wü *Yïsarayele adu afï nga ngü, te ani ena amere teka Yesu. Fü ewü amaka ngü la, adu aza Yesu, ai engu, anü di kpa engagira mere kpara de ïrï ye *Pïlatü, de te Miri ka wü *Rüma o engu me-ye gbü nzö wü kpara ka *Yudaya ne. ");
INSERT INTO muh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Te wüh koro de Yesu engagira Miri Pïlatü, fü miri arü amala ngü fü Yesu, gü ba dene, “De-mü, wüh gü ba, mü de Miri ka wü Yïsarayele ne. Ngü la fanü?” Yesu gü ba, “Ah bü de te mü mala la.” ");
INSERT INTO muh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Fü wü mere kovo ka wü Yïsarayele akpo da emala bi wü ngü eküte Yesu de wu. Amba Yesu lügü ngü fü ewü nda de. ");
INSERT INTO muh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Fü Miri Pïlatü adu amala ngü fü Yesu, gü ba dene, “Gara ngü gömö ye, te ye ena amala fütanga wü ngü ne nda ma? Ye je bi wü ngü, te ewü emala eküte ye ne, de?” ");
INSERT INTO muh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu lügü ngü fefe na nda-ye kpah de. Fü ngü la aga gbü jia Miri Pïlatü ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ta gbü wü re la, gbü mere sïkpï ka *Pasïka ꞌburu, Miri Pïlatü ngbü ta ece kpa te gara kpara ka ku biringbö, ba e te wü di enga Yïsarayele ngbü ele. ");
INSERT INTO muh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","11","Te di bala, fü wü gara kpara ayia akoro kpaka Miri Pïlatü, ayi-tata, gü ba dene, “Mere kpara, ah ena atï atï fü ye ace kpa te kpara ka ku biringbö fü ani, kpah baka e te ye ngbü emere gbü wü sïkpï ka Pasïka ꞌburu ne?” Baka te Miri Pïlatü, wu eyi, gü ba, maguma wü kovo la siti eyi eküte Yesu, fü ewü aza engu akoro di kpaka ni, teka de ni mörö engu asidi ne, fü engu ayia agïrï kaje, de ni küwa Yesu tete na. Fü ah ayia amala ngü fü wü kpara la, gü ba dene, “Wü le de ni ce neh kpa te da? Te ni ce kpa te Yesu, miri ka-wü ne, ah esiti?” Te wü kpara la je ngü te Miri Pïlatü mala de bala ne, fü ewü aci ꞌburu, amala ngü fü Miri Pïlatü, gü ba, “Ani ele de ye ce kpa te Baraba engu fü ani!” Wüh mala bala kükürü de, angü wü kovo to ta ngü eyi guvu ewü gügü, gü ba, “Te Pïlatü gü ba, ni le ace kpa te Yesu la, de wü ce ka-wü kpo. Wü mala fefe, gü ba, ‘Ani le ka-ani Baraba engu.’ ” Baraba ta süka wü kpara te wüh gü gbü ku, teka te wüh ngbü emömörö wü kpara teka tö ka-wü. ");
INSERT INTO muh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Miri Pïlatü gü ba, “Anga Yesu, de te wüh ngbü eï engu, gü ba, ah de Miri ka wü *Yïsarayele ne, ni ena amere de engu neh ene?” ");
INSERT INTO muh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Fü ewü aci ꞌburu, aba rere kpa tikpi, gü ba dene, “Wüh mörö engu amörö! Wüh bere engu eküte *rü gbegbete!” ");
INSERT INTO muh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Miri Pïlatü gü ba, “Teka neh? Engu kpo neh ene lïya ne? Ah mere ne *siti ngü ne?” Fü ewü adu akpo da eba rere, afa engu de tïne ne ka, gü ba, “Wüh mörö engu amörö! Wüh bere engu eküte rü gbegbete!” ");
INSERT INTO muh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Fü cürü arï te Miri Pïlatü, teka mere bi wü kpara la. Fü ah adu ale ngü ka-ewü. Fü ah ayia ace kpa te Baraba fü ewü, ba e te ewü le. Fü ah adu aï wü marajümïya ka-ye de wüh süma Yesu. Fü ewü asüma Yesu de siti juru konü de biki gbü ye. Fütanga ngü la, fü Miri Pïlatü adu aza Yesu, ato fü wü marajümïya ka-ye, de wüh nü, wüh bere engu eküte rü gbegbete. ");
INSERT INTO muh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Fütanga ngü la, fü wü marajümïya ayia aza Yesu, anü di agbü ꞌbaranga, gbü sü ka Miri Pïlatü, te wüh ngbü eï, gü ba, Peretorïyama ne. Fü ewü adu aï wü bu wü ꞌburu, abiti ede Yesu. ");
INSERT INTO muh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Fü ewü akpo da emü Yesu, gü ba, “Baka te engu di de mere miri ne, ah le de ani cu ngüngü na.” Fü ewü ayia agbi bongo ka Yesu asidi, adu aza diri ngboro bongo ka-wü, nzenze baka nda miri la, ato eküküte na. Fü ewü agara bïbï gbü ti, ato gbü nzö Yesu, baka *madudu ka wü miri. ");
INSERT INTO muh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Fü ewü angbü egü mandï fefe, da ede kpa wü, gü ba dene, “Wayi! Mandï fü ye, mere miri ka wü Yïsarayele!” ");
INSERT INTO muh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Fü ewü aza e baka gbaraka la, akpo da emï nzönzö na di, da esü ngüsü gbügbüra na, kpah da ebu nzökuta wü kötö, ba wü kpara te ewü ngbü ecu ngü miri la. ");
INSERT INTO muh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Te wüh fala Yesu nza tete, fü ewü agbi nze bongo tete na la asidi, adu ato bongo kaka-na, alügü tete. Fü ewü aza engu, anü di teka abere füh *rü gbegbete. ");
INSERT INTO muh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Te wü marajümïya za Yesu tete, teka anü amörö ne, fü ewü anü amaka te-wü de wü gara komoko de ïrï ye Sïmüna, kpara ka Kurene, te ngbü enü ka-ye te kaje, agbü Yerüsalema. Fü ewü azoro Sïmüna, ato esa *rü gbegbete, te ewü ena abere Yesu tete na ne, angü Yesu ngbü ta enü, da etï, da etï, teka tiri rü la. ");
INSERT INTO muh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Fü Sïmüna abï mere rü la, anü di fütanga Yesu, zalü akoro di gbü sü de ïrï ye Gologota, sü te wüh ena amörö Yesu tete na ne. Gologota la, ah baka e te wüh gü ba, “Sü ka biki-nzö,” angü ah de sü te wüh ngbü emörö siti wü kpara tete. ");
INSERT INTO muh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Fü gara kpara awu cïnga Yesu, aza ngu *vinü, te di de rü gbü ye, ato fü Yesu. Amba Yesu le nda de. ");
INSERT INTO muh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Fü wü marajümïya aza Yesu, agbi bongo kaka-na asidi, aza engu, agbere eküte rü gbegbete, abere engu gö gö gö! adu ae rü gbegbete la tikpi. Ngü la mere te-ye gbü lö-ra menewa ka kpurutokokpï. Fü ewü aza bongo ka Yesu la, asö de gümare, aye süsüka na esüka wü. ");
INSERT INTO muh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Fü ewü aba nga siti ngü kaka, ao eküte rü gbegbete la, to tikpi, gü ba dene, “Dene Mere Miri ka wü Yïsarayele.” ");
INSERT INTO muh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Fü ewü ayia aza wü mürü zi ꞌbasu, abere ewü eküte wü rü gbegbete ka-ewü ede nda Yesu, gara gbü kokpa, gara gbü kamisü. ");
INSERT INTO muh_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Ngü la tï kpini de ngü ta te wüh ba gbü Ngari Me, gü ba, “Wüh ena akolo ngü ka züka kpara ka-ni, Me, dünda de wü siti kpara.”) ");
INSERT INTO muh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Fü wü gara kpara, te ewü ngbü enü te kaje la, awu Yesu. Fü ewü akpo da esoko engu, da egü nzö wü de tadu, gü ba dene, “Ata! Ye gü ta, ga, ‘Ni de mere mürü wazi. Ni tï eyi amürü *Mere Kambü ka Me, adu afa gara gbü sïkpï ngbee bata!’ ");
INSERT INTO muh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Te ye de mere wazi bala, de ye kö la ekö kötö, ye küwa te-ye.” ");
INSERT INTO muh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wü mere *kovo ka wü Yïsarayele ngbü kpah da emü Yesu bala, da emala ngü esüka wü, gü ba dene, “Komoko la ngbü ta eküwa wü gara kpara. Ah mere neh baye, te engu tï aküwa te-ye de ne? ");
INSERT INTO muh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Te engu ena adi ta de Mere Miri te Me tima fü ani fanü la, ah le ta de engu küwa te-ye, de ah kö kötö, teka fü ani awu mere wazi kaka, adu ale ngü kaka.” Wü mürü zi, te ewü bere ewü de wü Yesu ne, wüh ngbü kpah da esoko engu bala. ");
INSERT INTO muh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Fütanga ngü la, ah te enü akoro etü ra, fü sü ayia atï ꞌduwa mbirrri, baka biti la. Fü e la ayiri bala, zalü akoro gbü lö-ra bata ka tamurago. ");
INSERT INTO muh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gbü lö-ra engu la, fü Yesu ayia aku gba de mere ri ye kpa tikpi, gü ba dene, “Eloyi, Eloyi, lama sabakatanï?” Ah baka e te wüh gü ba dene, “Me, Mere Miri ka-ra, mü ce ra kpikpi ra, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wü gara kpara te ewü di kpala, wüh je ngü te Yesu mala la mbi mbi nda-wü de, fü gara ewü afï, gü ba dene, “Ah ngbü dela neh eï *Ïlïya, de ah koro, ah küwa ni?” ");
INSERT INTO muh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Fü gara komoko ayia akpe de woro, aza e baka lïfa föꞌdö föꞌdö bala, agü gbü fï, ato te nzö e baka gala la, aza ato te komö Yesu, de ah ꞌbü, gü ba dene, “E-wu neh da, anga Ïlïya ena akoro aküwa engu?” ");
INSERT INTO muh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Fü Yesu ayia aku gba kpa tikpi, ayia ace maguma ye, akpi. ");
INSERT INTO muh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Gbü lö-ra te Yesu kpi tete na, fü mere bongo ta te wüh i, kolo tü *Mere Kambü ka Me agbü Yerüsalema di, baka ngisi ne, fü ah ayia asörö te-ye de tete-ye, mbaaa kü kpa tikpi ngbüüü kötö. Fü ngü la aga gbü jia wü kpara ba sirimbi. Dela ta ngü te Yesu kpi tete na. ");
INSERT INTO muh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gara mere kpara ka wü marajümïya ngbü ta eceka Yesu kpala. Te engu je gba ka Yesu bala, fü ah awu kaje te Yesu kpi tete na, fü ah agü ba, “Komoko ne, ah ka-ye de Ye Me fanü fanü.” ");
INSERT INTO muh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Bi wü würüse ta te ewü ngbü efa nga Yesu ne, kpah ladü gbü sü te Yesu kpi tete na la. Wüh de wü *Marïya Egba-Magadala, bete Salüme, bete *Marïya ni ye wü Yakobo ake Yüsa, kpah de mere bi wü bu wü, te ewü nü koro agbü Yerüsalema de wü Yesu. Angü, te wü Yesu di ta da endoro agbü *Galïlaya, wü würüse la ngbü ta efa nganga na, da ele ta-ngü tete. Gbü lö-ra te Yesu kpi tete na, wü würüse la ngbü nda-wü mba canza edere sü kpala, da eceka kpï. Fü ewü awu ngü ka kpi kaka ꞌburu. ");
INSERT INTO muh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Gara komoko ta ladü de ïrï ye *Yüsefa kpara ka Arïmatayo, te di de mere kpara esüka wü mere *kovo ka wü Yïsarayele. Ah kpah de kpara te ngbü eo jia ye teka Miri, te Me ena atima teka aküwa wü kpara ne. Sïkpï de ta te Yesu kpi tete na ne, ah ka-ye ta sïkpï te wü kpara ngbü ereke te-wü tete, teka *sïkpï ka Me ka wü Yïsarayele. Te di bala, etamurago la, fü Yüsefa ayia, ai maguma ye gö, anü kpaka Miri *Pïlatü, andaꞌba te-ye fefe na, gü ba dene, “Mere kpara, ni le ayi-ta ye de gara ngü biringbö. Te ah tï eyi gbü jia ye la, ni ele de ye to kö Yesu fü ni, ni ti.” ");
INSERT INTO muh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fü Miri Pïlatü adu afï nga ngü la, gü ba dene, “Yesu mere ngü ye, adu akpi kece neh fe?” Fü Miri Pïlatü ayia aï mere kpara ka wü marajümïya ka-ye, ayi-tata, gü ba dene, “Yesu kpi eyi fanü?” ");
INSERT INTO muh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Komoko la ga, “Wayi, ah kpi eyi fanü.” Te Miri Pïlatü je ngü la bala, fü ah ayia ale ngü ka Yüsefa, ato kö Yesu fefe. ");
INSERT INTO muh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Fü Yüsefa ayia anü ase züka bu bongo, akoro di. Fü ah adu aza kö Yesu eküte *rü gbegbete asidi, adu agaga de bu bongo la. Fü ah anü de kö Yesu, ati agbü gara gö da, te wüh jï sere sere bane, angü gele ka wü *Yïsarayele ta bala. Fü ah awara mere ngbürükü da, ao emö nga mbükü la, ani di. ");
INSERT INTO muh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Dela ta ngü te ewü ti kö Yesu tete na. *Marïya Egba-Magadala ake *Marïya ni ye Yüsa, wüh ngbü nda-wü fï bü da eceka ngü la. Fü ewü awu sü te wüh ti Yesu tete na ne. ");
INSERT INTO muh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kpurutokokpï la, wü kpara ꞌburu ngbü efe te-wü, angü ah de *sïkpï ka Me. Etamurago la, te ra tï tete na, *sïkpï ka Me nza eyi. Te di bala, fü *Marïya Egba-Magadala ayia de wü Salüme, bete *Marïya ni ye Yakobo, ayia anü ase *züka se-mü, teka amoko eküte kö Yesu. ");
INSERT INTO muh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gügü kpurutokokpï, fü ewü ayia anü kpa füh mbükü. ");
INSERT INTO muh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Te wüh ngbü enü tete na, fü ewü angbü emala ngü esüka wü, gü ba dene, “Anga mere siti da, te wüh ni mö mbükü la di ne, ani ena amere di, neh baye? Kpara te ena anzi da la asidi neh da, teka fü ani arï kpala?” ");
INSERT INTO muh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Fü ewü anü akoro kpa füh mbükü la, aceka kpï, yïrrrï! Da, ta te wüh o emö mbükü ne, wüh nzi eyi asidi! ");
INSERT INTO muh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Fü ewü ayia arï agbü gö da, te wüh ti Yesu gbügbü na ne. Gbo! te gara jaji komoko de züka bu bongo te ye, te ngbü gbü mbükü kpala gbü kokpa. Fü cürü arï te ewü ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Fü jaji komoko la ayia amala ngü fü ewü, gü ba dene, “Yi kpe cürü de. Ma wu eyi, gü ba, yi ngbü egïrï Yesu, kpara te wüh bere engu te *rü gbegbete ne. Ah zükü eyi. Yi ceka la sanga, ta te wüh o kökö gbügbü na ne. Engu sene ma! ");
INSERT INTO muh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yi du edu, yi mala ngü la fü wü Petero de wü bu ye, gü ba dene, ‘Yesu zükü eyi! Ah nü sü eyi kpa engagira nü agbü *Galïlaya. Wüh nü enü, fü ewü amaka engu kpala, kpah ba ngü ta te engu mala fü ewü ne.’ ” ");
INSERT INTO muh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Te wü würüse la je ngü la bala, fü ewü ayia akoro kpa etanü, ale woro de mere cürü emaguma wü. Wüh mala ngü la fü wü gara kpara nda-wü de, ka cürü. Köcökpa engu ta te Marako ba de kpa ye ne, ah dürü ka-ye eyi gügü. Amba wü gara wü köcökpa ladü fa sü, ta te wü diri wü kpara ta gügü ba esaka Marako. Wü köcökpa la gegege ba nda Marako te dürü ne. Gbü gara wü köcökpa la baka Marako 16:9-20 ngbürü ladü. Gbü gara wü köcökpa baka Marako 16:9-20 nda ma. Anga Marako ba ngü la me-ye fanü? Anga gara kpara? Nih wu de. Amba wü ngü la tï kpini de wü ngü te wü Matayo ake Luka ba ne. ");
INSERT INTO muh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gbü sïkpï ka biri ka wü *Yïsarayele, te di de *sïkpï ka Me ka-nih ne, gügü emözekpï, amba Yesu zükü ka-ye gbü kpi eyi. Gina kpara te Yesu gü tamu ye fefe, ah de *Marïya Egba-Magadala, ta te engu liki *siti wü di enga me guguvu na lorozi ne. ");
INSERT INTO muh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Fü Marïya ayia anü amaka wü bu ye, wü *kpara ka Yesu, te ewü ngbü da eku gba Yesu. ");
INSERT INTO muh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Fü Marïya amala ngü fü ewü, gü ba dene, “Yesu zükü eyi! Ni wu engu eyi cu de jia ni.” Amba wüh le ngü la nda-wü de, gü ba, “Ah ka-ye de wu!” ");
INSERT INTO muh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Fütanga ngü la, fü wü gara *kpara ka Yesu ꞌbasu ayia ace Yerüsalema, adu agba wü. Fü Yesu akoro amaka ewü te kaje. Amba wüh wu, gü ba, ah de Yesu ne, nda-wü de, angü küküte fü te-ye ka-ye eyi kpikpi ye. Fü Yesu ayia agü tamu ye fü ewü. Fü ewü adu awu engu. ");
INSERT INTO muh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Fü ewü ayia alügü nga wü, adu anü amala nga ngü la fü wü bu wü. Amba wü bu ewü le ngü ka-ewü la kpah de. ");
INSERT INTO muh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Fütanga ngü la, fü wü kpara ka Yesu nzükpa de füh ye biringbö ne, angbü ezü e ka-wü kpa esambü. Fü Yesu akoro agü tamu ye fü ewü. Fü ah arü amala ngü fü ewü, gü ba dene, “De-wü deyï, ah mere baye te nzö wü ngbü kpekpeke bala? Wü bu wü mala nga ni fü wü, gü ba, ‘Ni zükü eyi ne,’ wü le ngü la de, neh teka ne?” ");
INSERT INTO muh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Fü Yesu adu arü amala gara ngü fü ewü, gü ba dene, “Yi nü, yi baya te nga sü füh kotö ne ꞌburu, de yi mala ngari ra fü wü kpara ꞌburu nde. ");
INSERT INTO muh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mene kpara te to maguma ye fere, de yi to *babatïza fefe na, fü Me aküwa engu. Mene kpara te le ngü ka-ra la de, ah küwa kpah de. ");
INSERT INTO muh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Wü kpara te ewü ena ato maguma wü fere, Me ena ato wazi fü ewü me-ye, teka fü ewü amere wü angbe cögbörö tiri ngü di, teka fü wü kpara awu, gü ba, ngari ra ka-ye de zu ngü fanü fanü. Angü yi ena angbü da eliki *siti wü di enga me guvu wü kpara asidi. Yi ena angbü da emala bü ganzi mö ka wü gara kpara. ");
INSERT INTO muh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yi ena azoro wü siti kpürü de kpa yi, kpürü de yi nda de. Te yi nzö siti rü la, ah mere yi esiti kpah de. Fü yi adi eo kpa yi gbü nzö wü mürü keke, fü keke ka-ewü adi egu.” Dela ta ngü te Miri Yesu mala fü wü kpara ka-ye, te engu zükü tete gbü kpi. ");
INSERT INTO muh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Fütanga ngü la, fü Me ayia aza Yesu, ago di agbü sü ka-ye, agbü kpï. Fü Yesu angbü kpala gbü kokpa ka Me. ");
INSERT INTO muh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Te wü *kpara ka Yesu je ngü te engu mala fü ewü la, fü ewü ayia abaya te nga wü sü ꞌburu, angbü da emala ngü ka Yesu fü wü kpara ꞌburu nde. Fü Miri Yesu angbü da eto wazi fü ewü teka tima ka-ye la. Fü ah angbü kpah eto wazi fü ewü, de wüh ngbü emere wü mere tiri ngü ka talara di, teka fü wü kpara awu, gü ba, “Ngü ka Yesu, te ewü ngbü emala la, ah ka-ye de zu ngü fanü fanü.” Dela ngü teka Yesu *Kurisito, Ye Me. Adudu na bala.");
INSERT INTO muh_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Wayi bala, mere kpara Teyofile, ma ngbü eba ngü ne fü mü teka ngü ka Yesu *Kurisito. Angü bi wü kpara kpo ta eyi, ere da eba ngü teka ngü ka Yesu, ta te engu ngbü emere esüka nih de sene ne. Wüh ba ngü la, gegege baka te ewü je gömö wü kpara, de te ewü wu ngü la ta cu de jia wü ne. Kpah bala, ma ngbü ta egïrï lö ngü la. Ma maka eyi mbi. Tïtïne fü ra adu afï, gü ba, ah reke fa sü, te ma ena aba nga wü ngü, de te mere te-wü la, ꞌburu fü mü. ");
INSERT INTO muh_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma mere bala, teka de mü wu mbi mbi mbi, gü ba, ngü ka Yesu, ta te ewü ngbü erï mü di ne, ah ka-ye de zu ngü fanü. ");
INSERT INTO muh_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gbü wü re ta te gina *Erode ngbü mere miri tete, gbü nga nzö sü ka *Yudaya, gara mürü gele ka Me ta ladü de ïrï ye Zakarïya. Ïrï wara ka ta de Elïzabeta, te di kpah gbü nguwa *Arona. ");
INSERT INTO muh_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wü Zakarïya ake wara ye, Elïzabeta, ta ꞌbasu mini de züka wü kpara gbü jia Me, te ewü ngbü emere wü rïrï ka Me ꞌburu de maguma wü biringbö. ");
INSERT INTO muh_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amba, wüh bï ye ta nda-wü de, angü Elïzabeta ka-ye ta de wündü. Kpah bala, wüh gbe ka-wü ta eyi ꞌbasu mini, re ka-ewü nye sü kpah eyi fa sü. ");
INSERT INTO muh_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gbü gara sïkpï, wü Zakarïya de wü bu ye ngbü ta emere tima ka-wü gbü *Mere Kambü ka Me agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Fü ewü amere gele ka mafe kpara, teka afe mene kpara, te ena arï agbü *nzïla sü kpa esambü ka Me, teka adi ecuru *rü de züka se ye baka kïcï kpala. Fü ïrï Zakarïya akoro me-ye. Fü Zakarïya arï agbü nzïla sü teka amere tima ka gele la engakara Me. ");
INSERT INTO muh_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Gbü lö-ra te Zakarïya rï tete kpala, fü mere bi wü kpara angbü nda-wü da eyi-ta Me kpa etanü. ");
INSERT INTO muh_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Fü *malayïka ka Me ayia akoro kpaka Zakarïya kpa esambü ka Me kpala, arü gbü kokpa ede *cangalï, de te wüh ngbü ecuru züka se-rü fü Me tete na la. ");
INSERT INTO muh_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Te Zakarïya wu malayïka ka Me la, fü fïngangü kaka ayia adürü ka cürü. ");
INSERT INTO muh_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Fü malayïka la amala ngü fü Zakarïya, gü ba, “Zakarïya, mü kpe cürü de, angü Me je gba ka-mü eyi. Wara mü, Elïzabeta, ena abï ye komoko fü mü. Fü mü agü ïïrï na *Yüwane. ");
INSERT INTO muh_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Mü ena angbü de tadu teka ngü kaka. Kpah bala, mere bi wü kpara ena angbü de tadu teka ngü kaka-na. ");
INSERT INTO muh_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Angü ah ena adi de mere kpeke kpara gbü tima ka Me. Te di bala, ah tï anzö fï nda de. Angü, gbü sïkpï te wüh ena ayaka engu tete, Me ena ato wazi ka *Nzïla Wazi ye fefe. ");
INSERT INTO muh_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ah ena alügü mere bi wü di enga *Yïsarayele, ta te ewü dürü gbü ngü ka Me ne, ꞌburu te züka kaje ka Me. ");
INSERT INTO muh_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Engu ena angbü endoro, da emere tima ka Me, gbü wazi ka Nzïla Wazi Me, gegege baka nda *Ïlïya, *mürü dofo ka Me ta gügü ne. Ngü te engu ena arï wü kpara di ne, ena areke ngü esüka wü wö ye wü jaji, de wü di wü ꞌburu me-ye. Ah ena arï wü mürü kögö-nzö, de wüh fü maguma wü, adu angbü emere züka ngü gbü jia Me. Ah ena areke kpah maguma wü kpara, teka fü ewü angbü nzo, acï nga Mere Miri te Me ena atima.” Dela ngü ta te malayïka ka Me mala fü Zakarïya. ");
INSERT INTO muh_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Te Zakarïya je ngü la bala, fü mamaguma akolo. Fü ah ayia amala ngü fü malayïka la, gü ba, “Ngü la, ma ena awu baye baye, gü ba, ah de zu ngü? Angü tïtïne a gbe ka-a eyi ꞌbasu mini fa sü.” ");
INSERT INTO muh_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Fü malayïka la alügü ngü fefe, gü ba, “Ma de malayïka Gabürele. Ma ngbü erü engakara Me, teka angbü emere wü tima kaka-na. Engu tima ra me-ye teka amala ngü la fü mü. ");
INSERT INTO muh_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mü le aje ri ra de, neh teka ne? Te di bala, mü tï aro mö de. Mü ena angbü aböbö, zalü akoro gbü sïkpï te wara mü ena ayaka tete.” Fü malayïka la ayia anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gbü lö-ra engu la, fü ngü la aga gbü jia mere bi wü kpara, te ewü ngbü nda-wü ecï nga Zakarïya kpa etanü ne, afa sü, angü Zakarïya yiri agbü *nzïla sü ka Me la eyi fa sü. ");
INSERT INTO muh_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Te Zakarïya koro tete kpa etanü, ah tï aro mö nda tïne de. Fü ah angbü emala ngü fü wü kpara la bü de kpa ye. Fü wü kpara la awu teke, gü ba, Me sere gara ngü eyi fü Zakarïya agbü nzïla sü ka-ye kpala. ");
INSERT INTO muh_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Te sïkpï ka tima ka Zakarïya nza tete, fü engu ayia ago kpa gba ye. ");
INSERT INTO muh_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Sidi nga sïkpï mba cüküꞌdaye, fü wara ka, Elïzabeta amaka bu. Fü Elïzabeta amala ngü, gü ba, “Wayi, ni gbo nga ïrï Me, teka züka ngü te engu mere fü ni ne! Angü ngü ta te wüh ngbü efala ni di ne, Me reke ngü engu na la eyi.” Fü Elïzabeta ayia awo ngü la teka fe ꞌburuve. Ah mala fü wü kpara ꞌburu ꞌburu de. ");
INSERT INTO muh_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Fütanga ngü la, fü Me ayia atima *malayïka ka-ye, Gabürele, kpaka gara jaji würüse de ïrï ye *Marïya, agbü gara kötï de ïrï ye Nazareta, gbü nga nzö sü ka *Galïlaya. Ngü la mere te-ye, o bu Elïzabeta mere eyi fe maꞌdiya. Marïya ta de jaji würüse, te wüh dara engu fü gara komoko de ïrï ye *Yüsefa, ta te di gbü nguwa Miri *Davidi. ");
INSERT INTO muh_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Fü Malayïka Gabürele ayia arï kpaka Marïya kpa esambü, amala ngü fefe, gü ba, “Mandï fü mü, Marïya. Mü ngbü de tadu, angü Me ladü tundu de mü. Ah o *züka maguma ye eyi te mü, fü ah ato mere wazi fü mü teka ngü la.” ");
INSERT INTO muh_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Te Marïya je ngü la bala, fü mamaguma agürü. Fü ah angbü da eyi-ta tete-ye, gü ba, si-ngü gbü mandï la gü neh fe? ");
INSERT INTO muh_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Fü malayïka la amala ngü fefe, gü ba, “Marïya, mü kpe cürü de, angü ngü ka-mü reke gbü jia Me fa sü. ");
INSERT INTO muh_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mü ena amaka bu, fü mü abï ye komoko, agü ïïrï na Yesu. ");
INSERT INTO muh_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mbarase la, ah ena angbü mere kpara. Wüh ena angbü eï engu Ye Me. Mere Me ena ato wazi fefe, de ah ngbü mere miri füh kpökpö ka kundu ye, *Davidi. ");
INSERT INTO muh_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ah ena angbü mere miri gbü nzö nguwa *Yïsarayele ꞌburu, fï mere badi. Wazi miri kaka tï anza kpo fï de.” ");
INSERT INTO muh_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Baka te Marïya je ngü la bala, fü ah amala ngü fü malayïka la, gü ba, “Apa! Ngü la ena amere te-ye bala, neh baye baye? Baka te ni wu ngü ka komoko nda-ni la de ne.” ");
INSERT INTO muh_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Fü malayïka alügü ngü fefe, gü ba, “*Nzïla Wazi Me ena ato wazi la fü mü me-ye. Angü mbarase de te mü ena abï ne, ah ena adi de Ye Me. ");
INSERT INTO muh_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mü ceka la, mürü mü, Elïzabeta, maka bu kpah eyi, gbü gbe ye. Wü kpara ngbü ta efala engu, gü ba, ‘Ah de wündü, ah tï abï ye de.’ Tïtïne engu eyi de bu, fe maꞌdiya dene. ");
INSERT INTO muh_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Angü ngü te ena afa Me, nda kü ma.” ");
INSERT INTO muh_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Te Marïya je ngü la bala, fü ah amala, gü ba, “Wayi, ma de labï ka Me. Ma eyi esa rïrï kaka. Ah le fü ngü la amere te-ye fere, baka te mü mala la.” Fütanga ngü la, fü malayïka la ayia ace engu, anü sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Te *Marïya je nga Elïzabeta, gü ba, engu eyi de bu ye ne, fü ah ayia bü kere, gbü wü sïkpï la, anü aceka Elïzabeta, agba wü Zakarïya, te di eze wü da agbü *Yudaya. ");
INSERT INTO muh_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Te engu koro agba Zakarïya, fü ah amaka Elïzabeta, agü mandï fefe. ");
INSERT INTO muh_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Te Elïzabeta je ri Marïya, te gü mandï fü ye ne, fü engu awu ꞌduwa te mbarase kpo da emere wutu guvu ye. Fü Elïzabeta amaka wazi ka *Nzïla Wazi Me, amala ngü de ri ye kpa tikpi, gü ba, “Marïya, Me le ngü ka-mü eyi fanü, fa wü würüse füh kotö ne ꞌburu. Kpah bala, engu ena ato wazi fü mbarase, de te mü ena abï ne. ");
INSERT INTO muh_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","De-mü, te mü di de ni ye Miri ka-ra ne, mü koro aceka ra tïne bü cu me-mü bane? Apa! Ngü la neh baye? ");
INSERT INTO muh_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Marïya, mü ceka la, te ma je ri mü, de te mü to mandï fere ne, mbarase kpo ꞌduwa da emere wutu de tadu guvu ra. ");
INSERT INTO muh_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Züka ngü di fü mü, de te mü to maguma mü eyi fü Me, teka ale ngü de te engu mala fü mü ne. Te di bala, wü ngü la ena amere te-wü ꞌburu tenga riri na, ba e te engu mala fü mü.” Dela ngü te Elïzabeta mala fü Marïya. ");
INSERT INTO muh_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Teka ngü la, fü *Marïya angbü de tadu, ayia akpo ebï ci, gü ba, “Maguma ra ngbü eyi de mere tadu. ");
INSERT INTO muh_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ma egbo nga ïrï Mere Me, te küwa ra ne. ");
INSERT INTO muh_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Angü engu fï nga ra eyi, te ma di de labï kaka-na ne. Akpo enatikine, anü kpa engagira nü, wü kpara ꞌburu ena adi emala nga ra, gü ba, ‘Ma de würüse te Me to züka ngü eyi fefe.’ ");
INSERT INTO muh_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Me mere mere kpeke ngü eyi fere. Ma egbo nga ïïrï na, angü engu de wazi fa sü. Ah ka-ye kpah *nzïla. ");
INSERT INTO muh_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wü kpara ꞌburu, te ewü ngbü emere rïrï kaka, engu ena aküwa ewü fï mere badi. ");
INSERT INTO muh_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ah ngbü emere wü mere kpeke ngü. Ah baya wü mürü kögö-nzö eyi, angü wawazi na fa sü. ");
INSERT INTO muh_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ah gügürü wü miri, de te ewü ngbü engbü gbü nzö wü kpara füh kotö ne, eyi ꞌburu kötö. Fü ah aza wü kükürü kpara, adu ao da ewü. ");
INSERT INTO muh_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ah to mere bi wü e fü wü kpara, te ewü ngbü ekpi de tala ne. Amba wü kpara, ta te ewü di de mere bi wü e esaka wü ne, ah liki ewü eyi de kpa wü kükürü. ");
INSERT INTO muh_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ah koro teka ale ta-ngü te wü kpara ka-ye, wü di enga *Yïsarayele, de *züka maguma ye, ");
INSERT INTO muh_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","kpah baka ngü ta te engu mala fü *Abarayama, gü ba, ‘Ni ena amere wü ngü la bala te gara fefe na, de wü di ye ꞌburu, fï mere badi,’ ne.” Dela ci ta te Marïya bï, te engu koro tete kpaka Elïzabeta. ");
INSERT INTO muh_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Fü Marïya angbü kpaka Elïzabeta kpala, teka wü fe bata. Fü ah ayia ago kpa gba wü, agbü Nazareta. ");
INSERT INTO muh_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Fütanga ngü la, fü sïkpï ka Elïzabeta ayia atï teka ayaka. Fü engu ayaka mbarase ka-ye la, jaji komoko. ");
INSERT INTO muh_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Te wü bu ye Elïzabeta, de wü mürü ye na je ngü la, fü ewü angbü de tadu afa sü, gü ba, “Me to züka ngü eyi fefe.” ");
INSERT INTO muh_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Gbü sïkpï ꞌbajena, fütanga yayaka la, fü ewü akoro, teka agü mbarase la esa *basa. Wüh le ta agü ïrï wö ye na, Zakarïya, eküküte. ");
INSERT INTO muh_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Fü Elïzabeta ace kpo, gü ba, “Aꞌa, ïïrï na ena adi *Yüwane.” ");
INSERT INTO muh_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Fü ewü alügü ngü fefe, gü ba, “Apa! Ïrï kpara baka e la ladü gbü nguwa yi fanü? Ah nda ma.” ");
INSERT INTO muh_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Fü ewü ayi-ta Zakarïya bü de kpa wü, gbü ngü la, angü ah tï aro mö nda de. Wüh gü ba, “Ye ele de wüh gü ïrï mbarase ne, neh da?” ");
INSERT INTO muh_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Fü Zakarïya ayo köcökpa. Fü ah aba ngü fefeh, gü ba, “Ïïrï na de Yüwane.” Fü ngü la aga gbü jia wü kpara ꞌburu aga afa sü. ");
INSERT INTO muh_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kpah bü gbü lö-ra engu la, fü mi Zakarïya ayia afuru te-ye. Fü ah akpo tïne da ero mö mbölö mbölö. Fü ah akpo da egbo nga ïrï Me de mere ri ye kpa tikpi. ");
INSERT INTO muh_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Teka ngü la, fü cürü arï te wü bu ye na la afa sü. Fü ngü la awü, abaya esüka wü kpara te nga nzö rüvü ka *Yudaya sela ꞌburu, tïne ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mene wü kpara ꞌburu ta te ewü je nga ngü la, fü ewü angbü de mere fïngangü, da eyi-ta ngü esüka wü, gü ba, “Apa! Ngü ka mbarase la, ah ena angbü te gara, neh baye?” Angü wüh tï eyi awu, gü ba, mbarase la, Me to wazi eyi me-ye fefe fanü fanü. ");
INSERT INTO muh_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Fütanga ngü la, fü *Nzïla Wazi Me ato wazi fü Zakarïya. Fü engu akpo da emala ngü baka *mürü dofo, da ebï ci, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Gbo nga e fü Mere Me, te di de Mere Miri agbü kpï, te ngbü gbü nzö wü kpara ka-ye, wü *Yïsarayele. Nih gbo nga ïrï Mere Me, angü ah koro eyi teka aküwa nih, wü kpara ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Me tima kpeke kpara eyi teka aküwa nih, engu de kundu ye Miri *Davidi. ");
INSERT INTO muh_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ah mala ta wü ngü la gügü gömö wü mürü dofo ka-ye, ");
INSERT INTO muh_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","gü ba, ‘Ni ena atima Mere Miri, te ena aküwa nih esaka wü vügü ka-nih.’ ");
INSERT INTO muh_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wayi, Me sere *züka maguma ye eyi fü nih. Ah fï nga ngü ta te engu mala fü kundu nih, *Abarayama ne, eyi, ");
INSERT INTO muh_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","gbü sïkpï ta te ewü *nzö ngüte tete ake di, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Ni ena aküwa nih esaka wü vügü ka-nih, teka fü nih amere tima ka-ni de wazi, cürü tïne ma. ");
INSERT INTO muh_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Teka de nih ngbü ba züka wü kpara ka-ni, da emere wü züka ngü gbü jia ni, te nga wü sïkpï ꞌburu, o nih di la ladü de jia nih, füh kotö sene.’ ");
INSERT INTO muh_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Te di bala, de-mü, ye ra, wüh ena angbü eï mü, gü ba, mü de mürü dofo ka Mere Me. Angü mü ena anü kpa engagira nü, da ereke kaje fü Mere Miri te Me ena atima. ");
INSERT INTO muh_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kpah teka agü tamu ngü la fü wü kpara kaka, gü ba, ‘Ah ena akoro teka aküwa ewü, angü ah ena aboro *siti ngü ka-ewü.’ ");
INSERT INTO muh_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kükürü de, angü züka maguma ka Me fü nih fa sü. Engu ena atima kpara te ena aküwa nih, te ena alofo sü fü nih füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Teka ngü la, sü ena alofo gbü jia wü kpara ꞌburu, ta te ewü ngbü gbü mbiri sü ka kpi ne, alofo. Nih ena angbü endoro tïne te züka kaje, de gu ngü emaguma nih teka ngü ka Me.” Dela ci ka Zakarïya ta te engu bï teka ngü ka ye ye, *Yüwane Mürü Babatïza ne. ");
INSERT INTO muh_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Fü mbarase la aga, akoro mere komoko. Fü engu amaka kpah wazi, angbü kpeke kpara gbü jia Me. Fü engu angbü kpa etü gü kpala, zalü koro di gbü sïkpï, te engu koro gü tamu ye fü wü di enga Yïsarayele tete. ");
INSERT INTO muh_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Gbü wü re engu la, fü mere Miri *Kayïsara Agusito ato kpeke rïrï, gü ba, wü kpara ꞌburu nü ba ïrï wü gbü köcökpa, teka fü ni awu, gü ba, wüh neh fe? ");
INSERT INTO muh_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ngü la mere te-ye, o Kuriniyo ngbü ta miri tete, gbü nga nzö kötï ka Sïrïya. Ngü la, ah de gina ngü, te wüh ba ïrï wü kpara bala. ");
INSERT INTO muh_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Teka ngü la, fü wü kpara ꞌburu ayia anü aba ïrï wü, agbü sü te nguwa ewü di gbügbü na. ");
INSERT INTO muh_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","*Yüsefa, fü mü ayia agbü Nazareta, teka anü aba ïrï mü agba yi, agbü Beteleme, te di de kötï ta te wüh bï Miri *Davidi gbügbü na, angü Yüsefa koro gbü nguwa Davidi. ");
INSERT INTO muh_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Fü ewü anü ake *Marïya, würüse ta te engu le aza ne, teka aba ïrï wü kpala ake di. Amba bu Marïya ndri ka-ye eyi. Ah gbamari teka ayaka. ");
INSERT INTO muh_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Fü sïkpï ka yayaka atï fü Marïya, o wüh di ciki agbü Beteleme kpala. ");
INSERT INTO muh_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Fü Marïya ayaka gina enga ye, ye komoko. Fü engu agaga mbarase la de bongo, aseke engu gbü külü e, te wü yiti ngbü ezü e gbügbü na, ciki esambü ka wü yiti la, angü wüh maka ta züka sü ka rara nda-wü de. ");
INSERT INTO muh_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gara wü kpara ta ladü gbü sü la, te ewü ngbü endoro de wü kambiliki ka-wü gbü gü, da efete ewü. ");
INSERT INTO muh_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Gbü biti la, fü Me atima gara *malayïka ka-ye kpaka ewü. Fü wazi ka Me alofo sü ede ewü kpala ꞌburu raaa! Fü cürü ayia arï te ewü afa sü. ");
INSERT INTO muh_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Fü malayïka la amala ngü fü ewü, gü ba, “Yi mere e akpe cürü de, angü ma koro kpaka yi de züka tofo ngü, te ena areke wü kpara füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Angü enatikine gbü Beteleme, wüh yaka Miri, te Me tima teka aküwa yi ne, eyi. ");
INSERT INTO muh_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Dene ngü te yi ena awu engu tete. Yi ena amaka vürü jaji, te wüh gaga engu de bongo, seke gbü külü e, te wü yiti ngbü ezü wü e ka-wü gbügbü na ne.” ");
INSERT INTO muh_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Fütanga ngü te malayïka mala la, rurrru! fü mere bi wü malayïka ka Me ayia agbü kpï, akoro arü, abiti te-wü ede kiri wü la. Fü ewü akpo da ebï ci, da egbo nga ïrï Me, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nih gbo nga ïrï Me. Nih gbo nga Me agbü kpï. Me to züka gu ngü eyi fü wü kpara ka-ye. Wü kpara te engu le ngü ka-ewü, wüh ena angbü de mere tadu füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Te wü malayïka la nza ci ka-wü tete, fü ewü ayia ace wü mürü kambiliki la, ago ka-wü agbü kpï. Fü wü mürü kambiliki la amala ngü esüka wü ngberrre, gü ba, “Ani nü la enü agbü Beteleme, teka aceka mene ngü, de te Me sere fü ani ne, cu de jia ani.” ");
INSERT INTO muh_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Fü ewü ayia bü kere, anü akoro agbü Beteleme, amaka *Marïya ake *Yüsefa, bete vürü mbarase, te wüh seke engu gbü külü e, te wü yiti ngbü ezü e gbügbü na la, fanü. ");
INSERT INTO muh_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Te wü mürü kambiliki koro wu ngü la bala, fü ewü amala nga ngü, de te malayïka mala fü ewü, teka ngü ka mbarase la, ꞌburu fü wü kpara. ");
INSERT INTO muh_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Baka te wü kpara je ngü de gömö wü mürü kambiliki la, fü ngü la aga gbü jia ewü ꞌburu afa sü. ");
INSERT INTO muh_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Fü Marïya akpo angbü da efï nga ngü la emaguma ye. ");
INSERT INTO muh_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Fü wü mürü kambiliki la ale kaje ka-wü ago, da ecu ngü Me, kpah da egbo nga ïïrï na, teka wü ngü ꞌburu te ewü nü ceka cu de jia wü, baka te ewü je gömö wü malayïka ka Me ne. ");
INSERT INTO muh_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Gbü sïkpï ꞌbajena, fütanga yayaka la, fü wü *Yüsefa ake *Marïya aza mbarase, anü di, agü esa *basa, baka te di gbü gele ka wü *Yïsarayele. Fü ewü agü ïïrï na Yesu, ïrï ta te *malayïka mala nganga fü Marïya, o engu maka bu la de ne. ");
INSERT INTO muh_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Fütanga ngü la, fü sïkpï ayia atï fü Marïya, teka fü ewü areke ngü kaka sidi nga yayaka, baka te di gbü *Rïrï ka Müse. Te di bala, fü wü Yüsefa ake Marïya ayia anü de vürü mbarase, agbü *Mere Kambü ka Me agbü Yerüsalema, teka ato takpa fü Me, ba e te *Müse ba gbü Rïrï ka Me, gü ba, “Wüh ena adi eto wü mö ꞌbasu, teka areke ngü ka würüse, te bï ye, di.” Wüh le kpah ao Yesu engagira Mere Me, angü wüh ba ta kpah eyi, gbü Rïrï ka Me, gü ba, “Te würüse bï gina enga ye, te ah de komoko la, ah le fü ewü aza engu, akoro di, ao engagira Mere Me.” ");
INSERT INTO muh_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gara kpara ta ladü agbü Yerüsalema kpala, de ïrï ye Sïmïyona. Engu de züka kpara, te le ngü ka Me de maguma ye biringbö. Ah ngbü ta kpah eo jia ye teka miri, te Me ena atima teka aküwa ani, wü di enga Yïsarayele ne. Angü *Nzïla Wazi Me ngbü ta eto wazi fefe me-ye. ");
INSERT INTO muh_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Fü Nzïla Wazi Me la amala ngü fefe, gü ba, ye tï akpi la de, zalü te ye ena awu Miri la cu de jia ye feke. ");
INSERT INTO muh_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Fü wü Marïya ake Yüsefa aza Yesu, anü akoro di kpa etambasü Kambü ka Me, teka ao engu engagira Mere Me, baka te di gbü rïrï ka gele ka-ewü. Gbü sïkpï la, fü Nzïla Wazi Me aza Sïmïyona, anü di kpah kpala, teka awu Yesu. ");
INSERT INTO muh_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Te Sïmïyona koro maka ewü kpala, fü ah abï Yesu esaka ye, akpo da egbo nga ïrï Me, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Wayi Mere Me, enatikine ma wu Mere Miri E-küwa-nih eyi cu de jia ra, kpah ba e ta te mü mala fere. Te di bala, ma tï e ka-ra eyi akpi tïne, de gu maguma. Angü mbarase ne, mü tima engu teka aküwa wü kpara füh kotö ne ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Engu ena adi de ra-sü te ena agü tamu züka kaje ka-mü fü wü *ganzi kpara ꞌburu. Kpah bala, wü kpara ena agbo nga wü kpara ka-mü, wü di enga Yïsarayele, teka ngü kaka.” ");
INSERT INTO muh_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Fü ngü de te Sïmïyona mala, teka Yesu ne, aga gbü jia wü Marïya ake Yüsefa afa sü. ");
INSERT INTO muh_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Fü Sïmïyona ayia ao kpa ye füh wü Marïya, ayi-ta Me, de ah to wazi fü ewü. Fü ah amala ngü fü Marïya, ni ye Yesu, gü ba, “Mbarase ka-mü ne, Me fe engu teka are maguma wü kpara. Angü wü gara kpara ena ato maguma wü fefe, fü ewü aküwa. Amba mene ewü de te ewü le ngü kaka de ne, wüh küwa kpah de. Angü engu de Ri Me te Me tima fü nih, amba mere bi wü kpara tï ale ngü la nda-wü de. ");
INSERT INTO muh_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Te di bala, siti fïngangü ka-ewü, ta te wo te-ye awo ne, ena asere te-ye. Amba nda-mü Marïya, cïnga ena akuru maguma mü, teka ngü ka mbarase ne, baka te wüh sö e de maguruma la.” ");
INSERT INTO muh_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Gara mere würüse wökö ta kpah ladü kpala, de ïrï ye Ana, ye Fanüwele. Engu ta de *mürü dofo ka Me, te Nzïla Wazi Me ngbü ta eto wazi fefe, de ah di emala ngari Me. Wüh za ta te-wü ake watï ye, ra ngbee re lorozi. Fü watï ye na akpi ace engu. Fü würüse la angbü kpikpi ye, fütanga watï ye, zalü te re kaka koro tete teke bala de füh ye bala (84). Ah ngbü ta endoro etambasü *Mere Kambü ka Me te nga wü sïkpï ꞌburu, da egbo nga ïrï Me, ra de biti, da eku gba fefe, kpah da *eꞌbï te-ye. ");
INSERT INTO muh_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Te wü Yüsefa ake Marïya koro de Yesu etambasü ka Mere Kambü ka Me la, fü Ana akoro kpaka ewü. Te engu wu Yesu, fü ah akpo ꞌduwa da egbo nga ïrï Me. Fü ah adu akpo da emala nga Yesu fü bi wü kpara, de te ewü ngbü ecï nga miri, te Me ena atima, teka aküwa wü di enga Yïsarayele ne, gü ba, miri la koro eyi dene. ");
INSERT INTO muh_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Te wü Yüsefa ake Marïya nza wü ngü, te di gbü *Rïrï ka Me ꞌburu tete, fü ewü ayia ago agba wü, agbü Nazareta, te di gbü nga nzö sü ka *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Fü Yesu aga, akoro züka kpeke mbarase. Fü engu awu wü ngü afa sü. Fü Me angbü ele ta-ngü tete, da eto wazi fefe. ");
INSERT INTO muh_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Wü *Yüsefa ake *Marïya ngbü ta enü agbü Yerüsalema tenga wü re ꞌburu, teka azü *Karama ka Pasïka, baka rïrï ka gele ka wü di enga *Yïsarayele. Te re ka Yesu koro tete nzükpa de füh ye ꞌbasu, fü ewü anü agbü Yerüsalema, teka azü Karama ka Pasïka de wü ni ye. ");
INSERT INTO muh_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Te wü sïkpï ka karama la nza tete, fü ni ye Yesu ake Yüsefa ayia ka-wü de wü bu wü, atï te kaje, angbü ego. Fü ewü anü gbü ra dela gbuuu, wüh fï nda-wü, gü ba, “Yesu dene ladü de wü bu ye sela, ego.” Amba Yesu, mü ce te-mü ka-mü, ngbü eyi ciki agbü Yerüsalema kpala. Etamurago la, fü ewü akpo da egïrï engu esüka wü bu ye, angü gbü sïkpï engu la, wüh wu engu de. ");
INSERT INTO muh_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wüh gïrï engu ma, wüh maka de. Fü ewü ara te kaje. Fü kpï aseke. Fü ewü alügü nga wü adu agbü Yerüsalema, teka agïrï engu kpala. ");
INSERT INTO muh_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Te wüh du koro tete agbü Yerüsalema la, fü ewü ara aseke kpah kpï. Tïne gbü sïkpï engu la, fü ewü adu amaka Yesu kpa etambasü *Mere Kambü ka Me, te ngbü esüka wü *mürü rïrï, da eje ngü gömö ewü, kpah da eyi-ta ewü de wü kpeke yitangü. ");
INSERT INTO muh_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wü ngü de te engu ngbü elügü fü wü mürü rïrï la, ah ka-ye ꞌburu wü kpeke ngü. Fü ngü la aga gbü jia wü kpara la afa sü. ");
INSERT INTO muh_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Te wü ni ye Yesu maka engu kpa esüka wü kpara la tete, fü komö ewü ayia agu ka ngü la. Fü ni ye na, Marïya, amala ngü fefe na, gü ba, “Enga ni, ye mere ani ake wö ye bala, neh teka ne? Te ani ngbü egïgïrï ye de mere cïnga emaguma ani de bane ne!” ");
INSERT INTO muh_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Fü Yesu alügü ngü fü ewü, gü ba, “Yi ngbü egïrï ra, neh teka ne? Yi wu de, gü ba, ah le fü ra angbü engbü esambü ka Wüba?” ");
INSERT INTO muh_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amba ngü de te Yesu mala fü ewü de bala ne, wüh wu si-ngü gbügbü na nda-wü de. ");
INSERT INTO muh_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Fütanga ngü la, fü Yesu ayia ago de wü ni ye, agbü Nazareta. Angü ah ngbü ta eje rïrï ka-ewü ereke areke. Fü ni ye na ao to ye fï te ngü te Yesu lügü fü ewü la. ");
INSERT INTO muh_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Fü Yesu aga, akoro mere kpeke komoko, te wu ngü fa sü. Ngü kaka reke gbü jia Me fa sü, gbü jia wü kpara kpah bala. ");
INSERT INTO muh_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ta gbü re te mere miri *Kayïsara Tiberïya ngbü füh kpökpö ka wü *Rüma teka re nzükpa de füh ye ꞌburuve, dela o wü Anasï ake Kayafa di ta de wü mere kpara füh kpökpö ka wü *mürü gele ka wü *Yïsarayele agbü Yerüsalema. Ta gbü wü re la, *Yüwane ye Zakarïya ngbü ta engbü ka-ye kpa etü gü kpala. Fü Me ayia amala ngü fefe, de ah kpo de tima ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Fü Yüwane ayia akpo da endoro gbü wü kötï te ewü di agbü gü, gbamari ede mere ngu Yürüdene, da emala ngari Me, gü ba, “Wü ce *siti ngü ka-wü ꞌburu asidi, wü fü maguma wü, teka fü wü aza *babatïza, fü Me aboro siti ngü ka-wü ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngü la tï kpini baka ngü te *mürü dofo Yïsaya ba ta gügü gbü *Ngari Me, gü ba, “Gara kpara ena akoro, angbü emala ngü de mere ri ye kpa etü gü, gü ba, ‘Mere Miri, te ena aküwa ani ne, te ekoro! Ah le de wü reke kaje fefe mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wüh ena ani wü cudu ꞌburu ani. Wüh ena asoro mere rüvü asoro, fü ewü agbigbi wü ndugu rü, de wü da ꞌburu asidi. Wüh ena afü wü cïngïlï kaje ꞌburu, ao mbi. Angü ah le de kaje la ngbü ngba ngba ngba teka Mere Miri la, ");
INSERT INTO muh_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","teka fü wü kpara ꞌburu awu, gü ba, Me tima kpara eyi teka aküwa ani.’ ” Dela ngü ta te Yïsaya ba teka ngü ka Yüwane. ");
INSERT INTO muh_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Fü mere bi wü kpara aci akpo da ekoro kpaka Yüwane, teka de ah to babatïza fü ani. Te Yüwane wu ngü la bala, fü engu amala fü ewü, gü ba, “De-yi, wü mürü mani! Yi baka wü kpürü, angü maguma yi esiti! Yi efï nda-yi, gü ba, ani ena aküwa gbü kuru, te Me ena ato fü wü siti kpara te gara ne, bü teka ngü, te yi ngbü emala bü de komö yi kükürü kükürü de bala? E-mala ngü la fü yi bala, neh da? ");
INSERT INTO muh_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Te yi le aküwa fanü la, ah le de yi fü maguma yi, adi emere wü ngü te ena areke gbü jia Me. Yi efï nda-yi, gü ba, ‘Ani ena aküwa, angü ani de wü kundu ye *Abarayama,’ ne? Aꞌa! Yi mere e afï nga ngü bala de! Te Me le la, ah tï eyi afü wü teme ne ꞌburu, akoro di wü di Abarayama tete, te ngü ka-ewü ena areke gbü jijia, afa nda-yi ka! ");
INSERT INTO muh_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yi ceka la, Me eyi nzo teka ato kuru fü yi, baka kpara te di de gifi esaka ye, teka agïrï mene rü te rï de, fü engu ade, agü agbü wa.” ");
INSERT INTO muh_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Te mere bi wü kpara la je ngü gömö Yüwane bala, fü maguma ewü ayia akolo. Fü ewü akpo da eyi-tata, gü ba, “Ani ena amere tïne dene neh baye?” ");
INSERT INTO muh_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Fü Yüwane alügü ngü fü ewü, gü ba, “Ah le de yi di ele ta-ngü te-yi esüka yi. Te mü de bongo esaka mü ꞌbasu la, mü za gara, mü to fü kiri mü, de te ngbü ngïrïmu ne. Te mü de zü-e esaka mü, ah le fü mü aye süsüka, ato gara fü kiri mü te ngbü engbü tala.” ");
INSERT INTO muh_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Fü wü gara kpara, te ewü ngbü ero *jiase, eto fü miri, akoro kpaka Yüwane, de ah to babatïza fü ani. Fü ewü ayi-tata, gü ba, “Mere kpara, ani ena amere nda-ani baye?” ");
INSERT INTO muh_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Fü Yüwane amala ngü fü ewü, gü ba, “Jiase te yi ngbü ero esaka wü kpara ne, yi mere e ao gara jiase fefeh de, ah ngbü ba e te wü miri mala fü yi.” ");
INSERT INTO muh_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Wü marajümïya ta kpah ladü sela, fü ewü ayi-ta Yüwane, de nda-wü ngü, gü ba, “Amba de ani, nda-ani ngü ena adi neh baye?” Fü Yüwane alügü ngü kpah fü ewü, gü ba, “Yi mere e angbü egbürü jiase ka wü kpara de wazi de, angü dela zi. Yi mere e angbü ezoro wü kpara bü kükürü, da esutu wu eküte ewü kpah de. Jiase ka tima te wüh ngbü eto fü yi la, ah le fü yi adi eza de züka maguma yi.” ");
INSERT INTO muh_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Teka ngü la, fü mere bi wü kpara akpo da eyi-ta tete-wü, teka ngü ka Yüwane, gü ba, “Anga engu ena adi de *Kurisito, Miri te Me tima teka aküwa ani ne?” ");
INSERT INTO muh_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Te Yüwane wu ngü la bala, fü engu amala ngü fü mere bi wü kpara la, gü ba, “Ma de Kurisito engu nda-ra de! Ma ngbü eto babatïza fü yi de ngu kükürü. Amba Mere Miri engu ladü, te ena akoro sidi nga ra. Wawazi na fa nda-ra ka. Ma nda-ra bü baka labï kaka, te ena areke kaje fefe. Ma be teka tima la nda-ra de, angü engu me-ye de mere kpara fere. Te engu ena akoro la, ah ena ato babatïza fü yi de wazi ka *Nzïla Wazi Me, te di baka wa, teka fü yi amere tima ka Me areke areke. ");
INSERT INTO muh_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ah ena akoro de körö esaka ye, teka afeke jia ndo ka-ye di. Te engu feke jia ndo ka-ye eyi la, ah ena aza jijia na, ao agbü kafa. Fü engu adu akö caca na la, acuru acuru gbü mere wa te ünü nda de.” ");
INSERT INTO muh_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dela ngari Me te Yüwane ngbü erï wü kpara di. Fü ah angbü kpah emala mere bi wü gara ngü gbü mani fü ewü bala. ");
INSERT INTO muh_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Fü Yüwane angbü ta kpah erï Miri Anïtïpa *Erode, teka bi wü siti ngü te engu ngbü emere, baka te ewü za te-wü ake Erodïya, te di de wara enga ni ye, de ïrï ye *Fïlïpo ne. ");
INSERT INTO muh_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Teka ngü la, fü miri la adu amere kpah gara mere siti ngü, teka te engu zoro Yüwane, gü agbü ku ne. ");
INSERT INTO muh_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Te enga gina, o Miri Anïtïpa *Erode zoro *Yüwane, gü agbü ku la de, fü Yesu ayia akoro kpaka Yüwane, teka aza *babatïza, o mere bi wü kpara za nda-wü eyi ꞌburu. Fü Yüwane ayia ato babatïza fefe. Fütanga babatïza, fü Yesu akpo da eku gba fü Me. Fü kpï ayia aü te-ye. ");
INSERT INTO muh_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Fü *Nzïla Wazi Me akoro kpala baka mö, arü gbü nzö Yesu. Fü ri Me ayia awü kpa gbü kpï, gü ba, “Mü zu de Ye ra, te ma le fa sü, te ma o maguma ra eküküte.” Dela ngü ta te mere te-ye, te Yesu za babatïza tete esaka Yüwane. ");
INSERT INTO muh_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu kpo ta de tima, te Me tima engu de ah mere ne, o re kaka koro eyi teke biri de füh ye nzükpa. Wü kpara ngbü ta efï nda-wü, gü ba, engu de ye *Yüsefa, watï ye *Marïya, te di de ye Eli ne. ");
INSERT INTO muh_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Angü nguwa ewü kpo ta bane. Eli ta de ye Matata. Matata de ye Levi. Levi de ye Meleki. Meleki de ye Yanayï. Yanayï de ye Yüsefa. ");
INSERT INTO muh_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yüsefa de ye Matatïya. Matatïya de ye Amüsa. Amüsa de ye Nawuma. Nawuma de ye Eseli. Eseli de ye Naga. ");
INSERT INTO muh_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naga de ye Mata. Mata de ye Matatïya. Matatïya de ye Semeyini. Semeyini de ye Yüseka. Yüseka de ye Yoda. ");
INSERT INTO muh_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda de ye Yüwane. Yüwane de ye Resa. Resa de ye Zerubabela. Zerubabela de ye Salatïyele. Salatïyele de ye Neri. ");
INSERT INTO muh_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri de ye Meleki. Meleki de ye Adï. Adï de ye Küsama. Küsama de ye Elemadama. Elemadama de ye Ere. ");
INSERT INTO muh_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere de ye Yesüwa. Yesüwa de ye Eliyezere. Eliyezere de ye Yürïma. Yürïma de ye Matata. Matata de ye Levi. ");
INSERT INTO muh_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi de ye Sïmïyona. Sïmïyona de ye Yuda. Yuda de ye Yüsefa. Yüsefa de ye Yünama. Yünama de ye Elïyakima. ");
INSERT INTO muh_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elïyakima de ye Meleya. Meleya de ye Mena. Mena de ye Matata. Matata de ye Natana. Natana de ye *Davidi, ta te di miri ka wü di enga *Yïsarayele ne. ");
INSERT INTO muh_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Davidi ta de ye Yese. Yese de ye Obede. Obede de ye Büwaza. Büwaza de ye Salamona. Salamona de ye Nasona. ");
INSERT INTO muh_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasona de ye Amïnadaba. Amïnadaba de ye Adimina. Adimina de ye Rama. Rama de ye Ezerone. Ezerone de ye Pereze. Pereze de ye Yuda. ");
INSERT INTO muh_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ah de *Yuda, te di de ye Yakobo ne. *Yakobo de ye Yïsaka. *Yïsaka de ye Abarayama. *Abarayama de ye Tera. Tera de ye Nayora. ");
INSERT INTO muh_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nayora de ye Seruga. Seruga de ye Ruu. Ruu de ye Pelege. Pelege de ye *Ebere. Ebere de ye Sela. ");
INSERT INTO muh_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela de ye Kenana. Kenana de ye Arafakasada. Arafakasada de ye Seme. Seme de ye *Nüwa. Nüwa de ye Lemeke. ");
INSERT INTO muh_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemeke de ye Metusela. Metusela de ye Enoka. Enoka de ye Yerede. Yerede de ye Malalele. Malalele de ye Kenana. ");
INSERT INTO muh_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenana de ye Enosa. Enosa de ye Sete. Sete de ye *Adama. Adama nda-ye tïne de gina kpara ta te Me mere engu ne. ");
INSERT INTO muh_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Fütanga ngü te *Yüwane to *babatïza fü Yesu nza tete agbü Yürüdene, fü *Nzïla Wazi Me ayia arï emaguma Yesu. Fü Nzïla Wazi Me la ayia aza engu, anü di kpa etü gü. ");
INSERT INTO muh_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Fü tala ayia amere Yesu agbü gü kpala ꞌduwa ba-neh-ene-la, angü ah ra sïkpï teke ꞌbasu, ah zü e de. Fü *Satana angbü fï bü da ere mamaguma gbü wü sïkpï la. ");
INSERT INTO muh_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Fü Satana ayia amala ngü fefe, gü ba, “Te mü zu de Ye Me fanü fanü la, mü mala ngü fü teme dene, de ah fü te-ye, koro zü-e tete fü mü, fü mü azü.” ");
INSERT INTO muh_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu gü ba, “Mü fï, gü ba, e te ena aküwa kpara, ah bü duu de zü-e? *Ngari Me gü neh fe? E te ena aküwa kpara fanü fanü, ah ka-ye de ngü ka Me.” ");
INSERT INTO muh_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Fütanga ngü la, fü Satana ayia aza Yesu, anü di kpa füh mere rüvü kpa tikpi, asere wü züka ngü de füh kotö ne, de wü nga nzö sü ꞌburu fefe na bü kere kere bala, ");
INSERT INTO muh_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","gü ba, “Ceka la wü e la, ah ꞌburu de nda-ra. Ma tï eyi ato bü nzö fü mene kpara, te ma le ngü kaka. ");
INSERT INTO muh_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Te mü cu ngü ra ba me ka-mü la, ma ena ato wü e la ato ꞌburu fü mü. Ma ena ato kpah wazi fü mü, de wü züka wü e de füh kotö ne ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Fü Yesu adu alügü ngü fefe, gü ba, “Wüh ba gbü Ngari Me, gü ba, ‘Mü di ecu nzö ngü Mere Me kpikpi ye, de mü di emere duu rïrï kaka.’ ” ");
INSERT INTO muh_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Te Satana je ngü la bala, fü ah adu kpah aza Yesu, anü di agbü Yerüsalema, alï ake di kpa enzö *Mere Kambü ka Me kpa tikpi. Fü ah ayia amala ngü fefe, gü ba, “Te mü zu de Ye Me fanü la, mü ce la te-mü, mü tï kpa kötö kpala, ah mere ngü de. ");
INSERT INTO muh_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Angü wüh ba gbü Ngari Me, gü ba, ‘Me ena atima wü *malayïka ka-ye teka ale ta-ngü te mü. ");
INSERT INTO muh_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Wüh ena akoro abï mü esaka wü, mü tï amo lö mü eküte teme de.’ ” ");
INSERT INTO muh_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Fü Yesu alügü ngü fefe, gü ba, “Wüh ba kpah eyi gbü Ngari Me, gü ba, ‘Mü mere e are maguma Mere Me de.’ ” ");
INSERT INTO muh_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Te Satana re Yesu tete de wü ngü la ꞌburu bi ma ne, fü ah ayia ace la mba engu teka gara sïkpï. ");
INSERT INTO muh_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Fütanga wü ngü la, fü Yesu ayia kpala, adu agbü *Galïlaya. Fü *Nzïla Wazi Me angbü ake di, da eto wazi emamaguma. Fü nganga ayia awü gbü nga nzö sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Fü engu akpo da erï wü kpara gbü wü *kambü ka biti-te ka-ewü kpala. Fü wü kpara ꞌburu angbü egbo nganga na. ");
INSERT INTO muh_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Fütanga ngü la, fü Yesu ayia anü akoro agbü Nazareta, gbü sü ta te engu ga gbügbü na. Gbü *sïkpï ka Me, fü engu ayia arï kpa esambü ka biti-te, baka te engu ngbü emere gügü gbü wü sïkpï ka Me ꞌburu. Fü ah ayia arü tikpi teka atanga *Ngari Me fü ewü. ");
INSERT INTO muh_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Fü ewü aza buku ka *mürü dofo Yïsaya, ato fefe na, de ah tanga. Fü engu aza buku la, aü, amaka sü de te ewü ba ngü gbügbü kpala, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nzïla Wazi Me ngbü eto wazi fere, angü Me fe ra eyi teka aza ngari ni, Me, anü di, amala fü wü mürü cïnga. Ah tima ra kpah kpaka wü kpara agbü ku, teka amala fü ewü, gü ba, ‘Ni, Me, ena afuru wü gbü ku la afuru.’ Ah tima ra kpah de ma nü kpaka wü kpara de te jia ewü ni ani, gü ba ‘Ni ena aü jia wü.’ Ah tima ra kpah teka aküwa wü labï gbü cïnga ka-ewü. ");
INSERT INTO muh_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ah tima ra kpah kpaka wü kpara ka-ye, amala ngü fü ewü, gü ba dene, ‘Sïkpï te ni, Me, ena aküwa wü tete, koro eyi.’ ” ");
INSERT INTO muh_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Te Yesu tanga wü ngü la nza tete, fü engu alügü buku la kpaka mürü tima. Fü ah adu angbü ka-ye kötö. Fü wü kpara ꞌburu de kpa esambü ka biti-te la angbü da eceka engu de kpeke jia. ");
INSERT INTO muh_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Fü engu akpo da emala ngü fü wü kpara la, gü ba, “Ngü ta te wüh ba gbü buku ne, ah tï eyi kpini baka e te yi ngbü ewu dene.” ");
INSERT INTO muh_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Teka ngü la, fü ngü ka Yesu aga gbü jia wü kpara ꞌburu, teka kpeke ngü, de te engu ngbü emala fü ewü la. Fü ewü akpo tïne angbü da emala nganga na esüka wü, gü ba, “Apa! Ye komoko la, ah de ye *Yüsefa de?” ");
INSERT INTO muh_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Te Yesu je ngü la bala, fü ah amala ngü fü ewü, gü ba, “Wü kpeke ngü ꞌburu, te yi ngbü eje nga ra di, te ma ngbü emere agbü Kaparanama ne, yi ngbü efï, gü ba, ma mere gbü sü ka-nih sene de, neh teka ne? Ngü ka-yi baka ngü mani, te wüh ngbü emala, gü ba, ‘Te mü de mürü kuwa la, ah le de mü di kpah eküwa wü mürü mü.’ ");
INSERT INTO muh_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ma ngbü emala fü yi dene zu ngü. Angü te mü de *mürü dofo la, wü kpara gbü wü gara sü ꞌburu ena angbü ecu ngü mü me-wü, amba ꞌduwa wü mürü mü, wüh cu ngü mü nda-wü de. ");
INSERT INTO muh_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dene kpah gara kpeke ngü te ma ngbü emala fü yi. Yi efï nda-yi, gü ba, Me tï ale ta-ngü te wü *ganzi kpara de? Aꞌa, ah bala de! Yi ceka la, gbü wü re ta te mürü dofo *Ïlïya ngbü emere tima ka Me tete na, agö lï de, teka re bata de tü ye. Fü mere tala ayia atï gbü sü la ꞌburu. Gbü wü re la, mere bi wü wökö ta ladü gbü tö ka wü *Yïsarayele. ");
INSERT INTO muh_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amba Me tima ta Ïlïya kpaka ewü, teka ale ta-ngü te ewü, nda de. Me tima engu ka-ye bü duu kpaka gara würüse wökö, te di de ganzi kpara agbü Zarefata, agbü tö ka Sïdona. Yi fï nga ngü la nda-yi neh de? ");
INSERT INTO muh_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kpah bala, gbü wü re ta te Ïlïsa ngbü emere tima tete, mere bi wü mürü *jiakö ta ladü gbü tö ka wü Yïsarayele, amba wüh küwa ꞌburu de. ꞌDuwa Namana kpikpi ye, te di de ganzi kpara, kpara ka Sïrïya ne, küwa ka-ye bü duu me-ye.” ");
INSERT INTO muh_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Te mere bi wü kpara la je ngü la tete bala, fü ewü azïnga eküte Yesu. ");
INSERT INTO muh_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Fü ewü ayia azoro Yesu, agbeke engu, anü di kpa etanü mba canza ede mere kötï ka-wü. Fü ewü aza engu, alï di kpa füh mere rüvü, de ani nzi engu, agü akötö. ");
INSERT INTO muh_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yïrï! Fü Yesu adürü ka-ye bü esüka ewü sela, anye sü ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Gbü gara ra, fütanga ngü la, fü Yesu anü akoro agbü Kaparanama. Gbü *sïkpï ka Me, fü Yesu arï kpa *esambü ka biti-te, akpo da erï wü kpara kpala. ");
INSERT INTO muh_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Fü ngü de te Yesu ngbü erï ewü di la, ayia aga gbü jia ewü ꞌburu afa sü. Angü ah ngbü ta erï wü kpara la de mere wazi, baka mere kpara te Me tima engu me-ye. ");
INSERT INTO muh_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gara komoko ta ladü, kpa esambü ka biti-te la, de *siti wü di enga me guvu ye. Fü komoko la ayia akpo da eba rere de mere ri ye, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Apa! Yesu, nda-ani ngü de wü ye, ah de ne ngü ne? Ye koro dela teka amörö ani asidi? Ani wu ye kpo. Ye de züka kpara te Me tima füh kotö ne!” ");
INSERT INTO muh_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Fü Yesu arü amala ngü fü siti wü di enga me la kpekpeke, gü ba, “Yi nga anga, de yi koro guvu komoko la asidi!” Fü siti wü di enga me la ayia agbürü komoko la, agbo kötö, esüka wü kpara sela. Fü ewü ayia akoro guguvu, akpe, atafa ka-wü. Wüh mere engu esiti de. ");
INSERT INTO muh_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Fü ngü la aga gbü jia wü kpara ꞌburu afa sü. Fü ewü angbü emala ngü esüka wü, gü ba, “Apa! Dene bane neh ene ngü ne? Yi ceka la, Yesu ngbü emala ngü fü wü di enga me de wazi, fü ewü angbü eje ngü kaka, angbü ekoro guvu kpara asidi! Ah maka de wazi la neh kaye?” ");
INSERT INTO muh_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Teka ngü la, fü nga Yesu awü esüka wü kpara gbü nga nzö sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Fütanga ngü la, fü Yesu ayia ace *kambü ka biti-te la. Fü ah ayia anü ka-ye agba Sïmüna Petero. Gbü sïkpï la, ni ye wara Sïmüna ngbü ta eke ake. Sosoko rï ta fa sü. Fü ewü andaꞌba te-wü fü Yesu, de ah küwa engu. ");
INSERT INTO muh_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Fü Yesu akoro, arü ede würüse la, amala ngü fü keke la kpekpeke. Bü baka te engu mala ngü la, fü keke la ayia anza. Fü würüse la ayia anü ꞌduwa amere kümü, ato fü ewü. ");
INSERT INTO muh_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Etamurago la, te ra tï tete na, fü wü kpara gbü wü sü la ayia aza wü mürü wü, te ewü di de wü keke te wü ꞌburu, akoro de ewü kpaka Yesu, de ah küwa ewü. Fü Yesu ayia ao kpa ye gbü nzö ewü biri biri ꞌburu. Fü keke ka-ewü la anza ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wüh koro ta kpah de mere bi wü kpara, de *siti wü di enga me guvu wü. Fü Yesu amala ngü fü siti wü di enga me la. Fü ewü ayia akoro guvu wü kpara la asidi, da eku gba de mere ri wü, gü ba, “Yesu, ye de Ye Me fanü fanü!” Teka ngü la, fü Yesu angbü emala ngü fü ewü kpekpeke, da etïrï ewü, gü ba, “Wü nga anga.” Kükürü de, angü siti wü di enga me la wu ta eyi, gü ba, Yesu ka-ye de *Kurisito te Me tima engu füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Te kpï seke tete, fü Yesu ayia agbü Kaparanama kpala, anü ka-ye agbü gü, teka aku gba fü Me. Fü mere bi wü kpara akpo da egïrï engu. Te wüh nü maka engu, wüh le ta de engu ce ani, anü agbü gara sü de. Fü ewü angbü egïrï kaje teka atïrï engu. ");
INSERT INTO muh_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Te Yesu wu ngü la bala, fü ah amala ngü fü ewü, gü ba, “Ah le fü ni anü kpah agbü gara wü sü, amala ngü ka Me fü wü kpara de kpala. Angü Me tima ni ngbürü teka ngü la. Wü mere e atïrï ni sela de.” ");
INSERT INTO muh_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Fü Yesu ayia akpo da endoro gbü nga nzö wü sü la ꞌburu, da erï wü kpara de ngü ka Me, kpa *esambü ka biti-te ka-ewü. ");
INSERT INTO muh_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gbü gara sïkpï, fü Yesu akoro angbü ede mere ngu de ïrï ye *Galïlaya. Fü mere bi wü kpara akoro teka aje ngari Me gögömö na. Fü ewü akpo da enzinzi te-wü da egbene sü. ");
INSERT INTO muh_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Fü Yesu aceka kpï, ayia awu wü *zabu ꞌbasu te wüh i o edere ngolo. Wü mümürü koro gbügbü na eyi. Wüh ngbü ezürü wü yïmba ka si ka-wü. ");
INSERT INTO muh_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Gara zabu la, ah de nda Sïmüna Petero. Fü Yesu ayia alï angbü gbügbü. Fü ah ayi-ta Sïmüna, teka de ah ka de zabu la mba cüküꞌdaye etü ngu. Fü Yesu angbü ka-ye gbü zabu la, kpa etü ngu kpala. Wü kpara nda-wü ꞌburu füh gümba. Fü engu akpo da erï wü kpara de to ngari Me. ");
INSERT INTO muh_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Te Yesu mala ngari Me nza tete, fü ah amala ngü fü Sïmüna, gü ba, “Ye ka de zabu la kpa etü ngu, gbü sü te cu acu, fü wü agü yïmba ka-wü de wü bu ye la, teka fü wü azoro si.” ");
INSERT INTO muh_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Fü Sïmüna amala ngü fefe na, gü ba, “Akoo! Mere kpara, ani mere tima di bü eyi gbü biti ne, ngïrrrï! ani maka e nda-ani mbele de. Amba teka ngü de te ye mala la, ani ena agü yïmba engu la bü agü bala.” ");
INSERT INTO muh_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te wüh gü yïmba ka-wü tete, baka te Yesu mala fü ewü la, fü ewü ayia azoro mere bi si gbe gbe gbe. Dela si tïne de! Yïmba ka-ewü yia ekolo akolo, teka tiri wü si. ");
INSERT INTO muh_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Fü wü Sïmüna aï wü bu wü, te ewü di gbü gara zabu ne, da ecökölö ewü de kpa wü, teka de wüh koro, ale ta-ngü te ani. Fü ewü akoro, aro wü si gbü wü zabu de ꞌbasu ne, asi ꞌburu gbe! Zabu yia tïne erï arï esa ngu teka tiri wü si te fa sü. ");
INSERT INTO muh_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Te Sïmüna wu ngü la bala, fü cürü arï tete afa sü. Fü ah ayia abu nzökuta ye kötö, eri lö Yesu, andaꞌba te-ye fefe, gü ba, “Mere kpara, mü yia ede ra sela asidi, angü ma ka-ra de siti kpara.” Angü ngü ka mere bi wü si la ga gbü jia wü Sïmüna de wü bu ye cu fa sü. ");
INSERT INTO muh_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Fü cürü ayia arï kpah te wü bu ye Sïmüna de ꞌbasu, wü *Yakobo ake *Yüwane, wü di Zebedayo, te ewü ngbü gbü gara zabu ne, afa sü. Fü Yesu ayia amala ngü fü Sïmüna, gü ba, “Mü mere e akpe cürü de. Akpo enatikine, mü ena angbü ezoro wü kpara fü Me.” ");
INSERT INTO muh_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Fü ewü agbeke wü zabu ka-wü la edere ngolo, ace ao sela, ayia bü kürrrü, alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Gbü gara sïkpï, o wü Yesu ngbü tete gbü gara mere kötï, fü gara komoko te di de *jiakö eküte ye, ayia akoro kpaka Yesu. Fü engu ayia abu nzökuta ye kötö engagira Yesu, andaꞌba te-ye fefe, gü ba, “Akoo, mere kpara! Ye de mere mürü wazi! Ni ngbü eyi-ta ye, te ah gbü jia ye ꞌbe la, de ye küwa ni gbü keke ka-ni ne.” ");
INSERT INTO muh_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Fü Yesu ayia ao kpa ye eküte komoko la, gü ba, “Wayi, ma le eyi. Küte mü reke ereke!” Baka te Yesu mala ngü la tete, ꞌduwa fü keke la ayia ace engu. ");
INSERT INTO muh_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Fü Yesu adu amala ngü fü komoko la kpekpeke, gü ba, “De-ye deyï, ye mere e amala nga ngü la fü wü gara kpara de. Ye nü enü, ye mere ngü, ta te *Müse ba gbü *Rïrï ka Me ne. Ye za nü, ye nü di kpaka *mürü gele ka Mere Me, de ah wa, ah to fü Me teka ngü la, teka fü wü kpara ꞌburu awu, gü ba, küte ye reke eyi fanü.” ");
INSERT INTO muh_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Teka ngü la, fü nga Yesu ayia awü tïne afa sü. Fü mere bi wü kpara aci angbü da ebiti te-wü, teka adi eje to ngari Me gögömö na. Kpah bala, teka de Yesu küwa ani gbü wü keke ka-ani. ");
INSERT INTO muh_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amba fü Yesu angbü enü ewo te-ye agbü gü, teka adi eku gba fü Me kpikpi ye, kpala. ");
INSERT INTO muh_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gbü gara sïkpï, Yesu ngbü ta erï wü kpara de to ngari Me. Fü mere bi wü kpara akoro teka aje ngü la gögömö na. Gara wü *Farusi, de wü *mürü rïrï, ta kpah ladü esüka ewü. Gara ewü koro ta agbü wü nzö kötï ka *Galïlaya, gara nengete agbü *Yudaya, bete mene wü gara te ewü koro agbü mere kötï, Yerüsalema ne. Fü Me angbü eto mere wazi fü Yesu teka aküwa wü mürü keke la di. ");
INSERT INTO muh_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wüh te eceka de, wü gara kpara bï gara komoko te küküte kpi akpi, koro di eyi, ta de ani nü di kpaka Yesu. Fü ewü agïrï kaje, ta de ani rï de mürü keke la kpa esambü, ao engagira Yesu. ");
INSERT INTO muh_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amba dada ma, angü mere bi wü kpara ni ta kaje eyi ꞌburu. Da ewü te wüh ena arï akoro kpaka Yesu ma. Fü gara fïngangü akoro gbü nzö ewü. Fü ewü ayia alï kpa enzö kambü, afuru nzö kambü la, ai ku te kaꞌda la, ato komoko la di te görö, de te ewü furu la, ferrre esüka wü kpara la, ao ꞌduwa mbiii engagira Yesu, de ah küwa engu. ");
INSERT INTO muh_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Te Yesu wu ngü de te wü kpara la mere de bala, fü ah awu teke, gü ba, wüh to maguma wü eyi fü ni fanü fanü. Fü ah adu amala ngü fü mürü keke la, gü ba, “Enga wüna, ma boro *siti ngü ka-mü, te mü mere gbü jia Me ne, eyi!” ");
INSERT INTO muh_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Te wü mürü rïrï, de wü Farusi je ngü la bala, fü ngü la ake te-wü. Fü ewü angbü da efï ngü emaguma wü, gü ba, “Apa! Dene ne töndö ngü ne? Komoko la neh da, te ngbü efala Me de bala? Ah ngbü eo te-ye baka Me? Kpara biringbö füh kotö ne, te tï aboro siti ngü ka kpara ladü? Ah nda ma! Ah ka-ye ꞌduwa de Me kpikpi ye, te tï aboro siti ngü ka kpara.” ");
INSERT INTO muh_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Amba Yesu wu fïngangü ka-ewü la eyi, fü ah amala ngü fü ewü, gü ba, “Yi ngbü efï ngü la emaguma yi bala, neh teka ne? ");
INSERT INTO muh_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Yi wu de, gü ba, ma de *Ye Kpara ka Kpï? Te di bala, wazi ra ladü, teka adi eza siti ngü ka wü kpara füh kotö ne, gbü nzö ewü asidi. Yi fï nda-yi, gü ba, ma mala töndö ngü kükürü? Yi ena awu ngü la enatikine!” Fü Yesu adu afü te-ye, amala ngü fü mürü keke la, gü ba, “De-ye deyï, ye yia eyia, ye za darara ka-ye, ye go kpa ekötï.” ");
INSERT INTO muh_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yesu kpah bü te emala ngü la anza, fü mürü keke la ayia ꞌduwa, arü tikpi gbü jia wü kpara la ꞌburu. Fü ah aza darara ka-ye la, ago agba ye, de mere tadu, kpah da egbo nga ïrï Me. ");
INSERT INTO muh_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dela ngü te Yesu küwa mürü keke la tete. Fü ngü la aga gbü jia mere bi wü kpara la afa sü. Fü ewü akpo da egbo nga ïrï Me, de mere cürü emaguma wü, gü ba, “Apa! Enatikine ani wu mere kpeke ngü eyi!” ");
INSERT INTO muh_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Fütanga ngü la, fü Yesu ayia akoro kpa etanü. Fü ah awu gara komoko de ïrï ye *Levi Matayo, te ngbü gbü sü ka tima ka-ye, da ero *jiase ka wü e esaka wü kpara, teka angbü eto fü miri ka wü Rüma. Fü Yesu arü amala ngü fefe, gü ba, “De-mü Levi, mü yia eyia, mü fa nga ra!” ");
INSERT INTO muh_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Fü Levi ayia ace wü e ka tima ka-ye la ꞌburu sela, ayia kürrrü, alala gbü nga Yesu. ");
INSERT INTO muh_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Fütanga ngü la, fü Levi ayia amere mere karama fü Yesu kpa gba ye. Fü bi wü bu ye, te ewü ngbü ero jiase fü miri de ewü ne, akoro kpah gbü karama la, be kpah te bi wü gara kpara. Fü ewü angbü ezü e de wü Yesu tundu. ");
INSERT INTO muh_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Te wü *Farusi, de wü gara *mürü rïrï wu ngü la bala, fü ewü angbü edi ngü eküte wü Yesu gbü ngingiri ngü, gü ba, “Ah mere baye, te wü Yesu ngbü ezü e, de wü siti kpara de bala ne?” ");
INSERT INTO muh_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Te Yesu je ngü la bala, fü ah adu amala ngü fü ewü, gü ba, “Te keke te mü ma la, mü ena anü kpaka mürü kuwa anü? Mü tï anü de. ꞌDuwa te keke ladü te mü, fü mü anü kpaka mürü kuwa, de ah küwa ni. ");
INSERT INTO muh_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngü ka-ra kpah bala. Ma koro füh kotö ne, neh teka wü da? Teka züka wü kpara? Aꞌa, ah bala de! Ma koro ka-ra teka siti wü kpara, aï ewü, de wüh fü maguma wü.” ");
INSERT INTO muh_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Gbü gara sïkpï, fü wü gara kpara akoro kpaka Yesu, ayi-tata, gü ba, “Wü *Farusi zü e de, da *eꞌbï te-wü, teka adi eku gba fü Me, teka bi sïkpï. Wü kpara ka *Yüwane Mürü Babatïza ngbü emere kpah bala. Anga ah mere neh baye, te nda-ye wü kpara ne, ngbü ezü e gbü wü sïkpï ꞌburu ne? Wüh le gele ka-ani mbi mbi nda-wü de?” ");
INSERT INTO muh_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Fü Yesu alügü ngü fü ewü gbü mani, gü ba, “Yi fï nda-yi, gü ba, te wüh ï wü kpara gbü karama la, wüh tï azü e de? Wüh ena azü e azü, angü mürü karama la ladü tundu de ewü. ");
INSERT INTO muh_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amba te gara, te wü vügü ena aza mürü karama la, esüka wü awuba ye asidi la, wüh tï azü e de, ka cïnga emaguma wü.” ");
INSERT INTO muh_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Fü Yesu adu kpah amala gara ngü mani fü ewü, teka to ngari Me, te engu ngbü erï wü kpara di ne, gü ba, “Te diri bongo ka-mü sörö asörö la, mü tï eyi aza to bongo, teka atükü te didiri na la? Mü tï amere bala de, angü didiri na la ena adu kpah asörö ka-ye asörö. ");
INSERT INTO muh_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kpah bala, te mü le aküꞌda fï ka-mü la, de mü mere e aküꞌda gbü diri bütü körö körö ne de. Angü diri bütü la ena adü, aöfö ka-ye, fü fï ka-mü la atökö ka-ye ꞌburu akötö. ");
INSERT INTO muh_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ah le fü mü aküꞌda fï ka-mü gbü to bütü, angü fï ka-mü la ena asiti siti. Kpah bala, te mü ngbü ele to rïrï ka-ra la, mü tï alala fï bü eküte diri gele ka wü kundu mü nda-mü de. ");
INSERT INTO muh_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wü gara kpara ngbü emala, gü ba, ‘Duru fï reke ka-ye me-ye.’ Teka ngü la, wü kpara le adi enzö to fï fütanga duduru na nda-wü de.” Dela ngü te Yesu mala fü wü kpara teka to rïrï, te engu ngbü erï wü kpara di. ");
INSERT INTO muh_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gbü gara *sïkpï ka Me, fü wü Yesu angbü enü de wü *kpara ka-ye. Fü ewü afü kpuru gbü yï ka ndo. Te wüh ngbü enü tete, fü wü kpara ka Yesu akpo da esösörö fï ndo la, da etitiri koko na, ezü ka tala. ");
INSERT INTO muh_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Fü wü gara *Farusi awu ngü la. Fü ngü la asiti gbü jia ewü, gü ba, “Masörö fï ndo la, ah de tima.” Angü rïrï ka wü *Yïsarayele gü ba, “Gbü sïkpï ka Me, mü mere e amere tima ꞌburu ꞌburu de.” Teka ngü la, fü wü Farusi la ayia akoro amala ngü fü wü Yesu, gü ba, “Wü ceka la! Wü ngbü emere tima gbü sïkpï ka Me, neh teka ne? Wü je rïrï ka-ani ne nda-wü de? Wü le asiti gele ka-ani neh teka ne, te wü ngbü esösörö fï ndo la gbü sïkpï ka Me de bala ne?” ");
INSERT INTO muh_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Te Yesu je ngü la bala, fü ah alügü ngü fü ewü, gü ba, “De-wü deyï, wü tanga *Ngari Me nda-wü neh de? Ngü ta te wüh ba teka Mere Miri *Davidi ne, ah gü neh fe? Ta gbü gara ra, tala mere Davidi de wü kpara gbü nga ye. ");
INSERT INTO muh_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Fü Davidi ayia akoro kpaka *mürü gele ka Mere Me, ayi-tata teka e-mazü. Fü mürü gele la ayia aza ambata, de te wüh ngbü eto fü Mere Me ne, ato fü Davidi. Fü Davidi azü, ato kpah fü wü kpara gbü nga ye ꞌburu. Wüh mala ta eyi fefe, gü ba, ‘Ye ngbü esiti gele?’ Wüh mala bala de! Amba gbü rïrï ta te *Müse to fü wü mürü gele ne, ambata la, ah teka wü kükürü kpara fa fa fa nda de. ꞌDuwa wü mürü gele ka Mere Me ngbü ezü me-wü.” ");
INSERT INTO muh_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Fü Yesu adu amala gara ngü fü ewü, gü ba, “De-ra, *Ye Kpara ka Kpï, Me to wazi eyi fere, fa ngü ka gele la ka. Ma de mürü sïkpï ka Me la me-ra. Ma ngbü eto to *Rïrï ka Me fü wü kpara ka-ra me-ra.” ");
INSERT INTO muh_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gbü gara *sïkpï ka Me, fü Yesu anü arï kpa *esambü ka biti-te, akpo da erï wü kpara kpala. Gara komoko ta ladü kpala, te kpakpa na ka kokpa ze aze. ");
INSERT INTO muh_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Wü gara *mürü rïrï, de wü *Farusi ta kpah ladü kpala. Fü ewü angbü efete Yesu, da egïrï kaje te ani ena amaka siti ngü kaka tete, fü ani amala nganga fü wü *kovo. Fü ewü angbü eceka Yesu, da efete engu kpekpeke, anga engu ena aküwa komoko la gbü sïkpï ka Me ya? Angü wüh fï nda-wü, gü ba, maküwa kpara, ah de tima. ");
INSERT INTO muh_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Amba Yesu wu fïngangü ka-ewü la eyi kpo. Teka ngü la, fü engu amala ngü fü komoko, de te kpakpa na ze aze ne, gü ba, “De-ye deyï, ye yia eyia, de ye koro la kpa engagira nü akine.” Fü komoko la ayia akoro. ");
INSERT INTO muh_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Fü Yesu amala ngü fü wü mürü rïrï la, gü ba, “Ma ele ayi-ta yi de ngü biringbö. Gbü jia yi, ah tï fü kpara adi emere neh ene ngü ne, gbü wü sïkpï ka Me? *Rïrï ka Me, te *Müse mala fü nih, gü neh fe? Wüh di emere züka ngü? Anga siti ngü reke me-ye? Ah le de nih küwa kpara? Anga ah le de nih ce kpara fü kpi?” ");
INSERT INTO muh_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Fü engu ayia aceka kpï füh ewü ngberrre ꞌburu. Fü ah adu amala ngü fü komoko la, gü ba, “Mü gbere kpa mü egbere!” Fü komoko la ayia agbere kpa ye. Fü kpakpa na areke te-ye, adu zürü! te nga ye. ");
INSERT INTO muh_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Te wü mürü rïrï la wu ngü la bala, fü ngü la ake te ewü afa sü, angü Yesu reke kpa komoko la gbü sïkpï ka Me. Fü maguma ewü ayia asiti eküte Yesu. Fü ewü akpo da emala ngü esüka wü, gü ba, “Ani ena amere de Yesu neh baye?” ");
INSERT INTO muh_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Fütanga ngü la, fü Yesu ayia ka-ye, anü kpa enzö mere rüvü, teka aku gba fü Me kpala. Fü ah angbü kpala da eyi-ta Me gbü biti la ngïrrrï. ");
INSERT INTO muh_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Te kpï seke tete, fü engu aï wü *kpara ka-ye ꞌburu kpaka ye. Fü ah ayia afe wü gara kpara nzükpa de füh ye ꞌbasu, esüka wü kpara ka-ye la, ao ewü, wü *mürü tima ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Dene ïrï wü kpara, de te engu fe ewü ne. Sïmüna, de te Yesu gü gara ïrï tete, gü ba, Petero, ake enga ni ye de ïrï ye Anderïya. Wü *Yakobo ake *Yüwane, wü *Fïlïpo ake Batülümayo, ");
INSERT INTO muh_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","wü Matayo ake Toma, bete *Yakobo ye Alofaya, ake Sïmüna ta te ngbü emere gü teka tö ka-wü ne. ");
INSERT INTO muh_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Gara de *Yuda, ye Yakobo, te wüh gü gara ïïrï na Tadayo, bete *Yuda Keriyota ta te to Yesu fü wü vügü ne. Dela ta ngü ka wü kpara te Yesu fe ewü. ");
INSERT INTO muh_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Fütanga ngü la, fü wü Yesu ayia kpa enzö mere rüvü la, adu kpa esa gö. Fü ah adu amaka mere bi wü gara wü *kpara ka-ye, te ewü ngbü gbü züka sü te di sele sele bala. Fü ewü ayia angbü de ewü sela. Fü mere bi wü gara wü kpara ayia akoro kpah kpakaka na, teka aje to ngari Me gögömö. Wüh koro ta agbü Yerüsalema bete tö ka *Yudaya ꞌburu. Gara ewü koro nengete agbü Tera ake Sïdona. Gara wü kpara la koro ta teka fü Yesu aküwa ani gbü wü keke ka-ani. Gara ewü de wü kpara, ta te *siti wü di enga me ngbü emere ewü. ");
INSERT INTO muh_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wü mürü keke la ꞌburu le amofo küte Yesu, angü wüh wu eyi, gü ba, wawazi na ladü, teka aküwa ani ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Fütanga ngü la, fü Yesu ae gbüra ye, aceka wü *kpara ka-ye. Fü ah amala ngü fü ewü, gü ba, “De-yi, wü mürü cïnga, Me ena ato züka ngü fü yi te gara, angü yi ena amaka *küküwa, angbü agbü sü ka Me agbü kpï. ");
INSERT INTO muh_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","De-yi, wü kpara te yi ngbü engbü de tala tïtïne, Me ena ato züka ngü fü yi te gara, angü yi ena amaka mere bi zü-e. De-yi, wü kpara te yi ngbü eku gba tïtïne, Me ena ato züka ngü fü yi te gara, angü yi ena angbü de mere tadu. ");
INSERT INTO muh_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kpah bala, de-yi, wü kpara te wü bu yi ngbü ekpü yi akpü, da esoko yi, kpah da efala yi, teka ngü ka-ra ne, Me ena ato züka ngü fü yi te gara. ");
INSERT INTO muh_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Te wüh mere mü bala la, ah le de mü ngbü ka-mü de tadu emaguma mü, angü te gara, mü ena amaka mere züka ngü agbü sü ka Me agbü kpï. Mü mere e afï nga ngü de, angü ta gügü, wü kundu ewü ngbü emere siti ngü fü diri wü *mürü dofo ka Me kpah bala. ");
INSERT INTO muh_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amba nda-yi, wü kpara de mere bi e esaka yi, yi ena amaka cïnga te gara, angü yi maka züka ngü nda-yi eyi füh kotö ne. ");
INSERT INTO muh_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","De-yi, wü kpara te yi ngbü ezü züka e enatikine, yi ena amaka cïnga te gara, angü tala ena angbü emere yi. De-yi, wü kpara te yi ngbü de tadu enatikine, yi ena amaka cïnga te gara, angü yi ena angbü eku gba. ");
INSERT INTO muh_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kpah bala, de-yi, te wü kpara ꞌburu ngbü egbo nga ïrï yi de enatikine ne, yi ena amaka cïnga te gara, angü wü kpara ngbü ta egbo nga siti wü mürü wu ta gügü ne kpah bala.” ");
INSERT INTO muh_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Fü Yesu adu amala gara ngü fü ewü, gü ba, “De-yi te yi ngbü eje ri ra ne, dene ngü te ma ele amala fü yi. Ah le de yi di ele wü vügü ka-yi de maguma yi ꞌburu, kpah da emere züka ngü fü wü kpara te ewü ngbü ekpü yi. ");
INSERT INTO muh_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wü kpara te ewü ngbü esoko yi, da eto cïnga te yi, ah le de yi ku gba fü Me teka ewü, de Me boro *siti ngü ka-ewü la. ");
INSERT INTO muh_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Te kpara be gbüra mü la, mü mere e azïnga tete de, de mü ce gbüra mü fefe, de ah du, ah be kpah toto. Te kpara gbene bongo ka-mü la, de mü ce kpah gara bongo ka-mü fefe na, de ah za kpah bala. ");
INSERT INTO muh_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Te kpara yo e eküte mü la, mü mere e atïrï engu de. Te kpara za e ka-mü la, mü mere e ayo de, mü ce e engu la fefe. ");
INSERT INTO muh_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mene züka ngü, de te yi ele de wü kpara di emere fü yi ne, de yi di kpah emere bala fü wü bu yi. ");
INSERT INTO muh_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Te yi ngbü ele bü nzö wü kpara, de te ewü ngbü ele ngü ka-yi ne la, Me ena ato züka ngü fü yi, neh baye baye? Angü wü siti kpara, de te ewü le ngü ka Me de ne, wüh ngbü emere ngü la esüka wü bala me-wü. ");
INSERT INTO muh_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amba te yi ngbü emere züka ngü bü nzö fü wü kpara, de te ewü ngbü emere züka ngü fü yi ne la, Me ena ato züka ngü fü yi, neh baye baye? Wü siti kpara ngbü emere ngü bala me-wü. ");
INSERT INTO muh_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kpah bala, te yi ngbü eto e bü nzö fü wü kpara, de te yi wu eyi, gü ba, wüh ena alügü nana fü ani ne, Me ena ato züka ngü fü yi, neh baye baye? Angü wü siti kpara, te ewü le ngü ka Me de ne, wüh ngbü emere kpah bala esüka wü me-wü, angü wüh wu eyi kpo, gü ba, wüh ena alügü na e la alügü fü ani. ");
INSERT INTO muh_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amba nda-yi, wü kpara ka-ra, ah le de ngü ka-yi ngbü kpikpi ye. Ah le de yi le wü vügü ka-yi ale, da emere züka ngü fü ewü. Kpah bala, te yi to e fü wü kpara la, yi mere e afï nganga na tïne de. Angü te yi mere bala, Me ena ato mere bi züka ngü fü yi, agbü sü ka-ye agbü kpï. Kpah bala, wüh ena awu, gü ba, yi zu de wü di Me fanü. Angü Me ngbü emere züka ngü fü wü siti kpara, de wü züka kpara kpah ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Te di bala, yi di ewu cïnga wü bu yi, kpah baka Wö yi, Me, te ngbü ewu cïnga yi ne.” ");
INSERT INTO muh_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Fü Yesu adu amala gara ngü fü ewü, gü ba, “Wü di enga wüna, yi mere e adi esiti ïrï wü bu yi, da ekolo lïya ka-ewü de, angü Me ena akolo lïya ka-yi kpah bala. Angü, te yi ngbü eboro siti ngü ka wü bu yi la, Me ena aboro *siti ngü ka-yi, te yi ngbü emere ne, kpah aboro. ");
INSERT INTO muh_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yi di eto e fü wü bu yi, teka fü Me adi kpah eto e fü yi. Angü te yi mere bala la, Me ena ato mere bi züka ngü fü yi, afa mene te yi ngbü eto ne ka. Teka ne de, wü ngü de te yi ngbü emere fü wü bu yi ne, Me ena adi emere fü yi kpah bala.” ");
INSERT INTO muh_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Fütanga ngü la, fü Yesu amala gara ngü fü ewü gbü mani, gü ba dene, “Kpara te jijia ni ani, tï ale ta-ngü te kiri ye, de te jijia ni kpah ani ne, nda de. Kükürü de, angü wüh ena atï ka-wü ꞌbasu mini agbü mere du. Kpah bala, kpara te to maguma ye fü Me de, tï arï wü bu ye de ngari Me kpah de. ");
INSERT INTO muh_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ngü ka mbarase tï afa nda mere kpara ka-ye de. Amba mene mbarase te ngbü eje rïrï ka mere kpara ka-ye mbi mbi mbi la, ah ena adu te gara, angbü emere wü ngü kpah baka mere kpara ka-ye la. ");
INSERT INTO muh_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Te mü le aza enga ca-gü gbü jia enga ni mü, o mere ndugu rü di ladü gbü jia mü la, ah de züka ngü? Mü dela mürü mani! Angü te enga gina, ah le fü mü agbi la mere ndugu rü, te di gbü jia mü ne feke, teka fü jia mü alofo raaa! Fü mü adu aza enga ca-gü, te di gbü jia enga ni mü ne, sidi.” ");
INSERT INTO muh_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Fü Yesu adu amala kpah gara ngü fü ewü gbü mani, gü ba dene, “Siti rï-rü tï eyi arï eküte züka rü, de te wüh ngbü ezü rïrï na ne? Ah bala de. Kpah bala, züka rï-rü tï arï eküte siti rü ne, kpah de. ");
INSERT INTO muh_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mü ena awu wü rü ꞌburu teka rï ewü. Mü tï eyi amaka rï manga eküte patra? Anga mü tï eyi amaka rï güwava eküte rü ngenee? Ah bala de! Rü manga ena arï ꞌduwa rï manga. Rü ngenee ena arï ꞌduwa rï ngenee. ");
INSERT INTO muh_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Te di bala, züka kpara ngbü emere züka ngü ka-ye duu me-ye, angü züka ngü ladü emamaguma. Kpah bala, siti kpara ngbü emere nda-ye wü siti ngü, angü mamaguma esiti. Angü ngü te mü ngbü emala de komö mü, kpah da emere ne, ah de ngü de te ngbü ekoro emaguma mü.” ");
INSERT INTO muh_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Fü Yesu adu amala kpah gara ngü fü ewü, gü ba dene, “Yi ngbü eï ra, mere kpara, mere kpara, bü kükürü bala, neh teka ne? Amba wü ngü de te ma ngbü erï yi di ne, yi le aje de, neh teka ne? Dela züka ngü? ");
INSERT INTO muh_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mene kpara te ngbü eje ngü ka-ra, fü ah angbü kpah emere ne, ma ena asere ngü kaka fü yi. ");
INSERT INTO muh_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Engu ena adi baka mene kpara te ele ajï kambü ka-ye. Fü ah amaka züka sü füh ndu-ta teka kambü la. Fü ah ajï du, arï areke, areke teka ato rü kambü la gbügbü. Baka te engu jï kambü ka-ye la nza tete, fü mere agö ayia alï. Kambü la mürü nda de, angü wüh jï kambü la reke areke te züka sü, füh nduta. ");
INSERT INTO muh_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amba te mü le aje ngü ka-ra, de te ma ngbü erï mü di ne, de la, mü ena adi baka kpara te jï kambü ka-ye bü gbü siki, riri na rï gbü tö nda de. Te mere agö lï la, kambü la ena amürü ka-ye kere, angü ah ngbü bü ngönzö ngönzö füh siki.” Dela wü ngü te Yesu rï mere bi wü kpara di gbü mene sü te di sele sele, gbü sïkpï te engu fe wü *mürü tima ka-ye nzükpa de füh ye ꞌbasu ne tete. ");
INSERT INTO muh_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Fütanga ngü la, fü Yesu ayia de wü kpara ka-ye, anü akoro agbü Kaparanama. ");
INSERT INTO muh_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Gara mere kpara ka wü marajümïya ka wü *Rüma ta ladü kpala, te labï kaka ngbü eke efa sü. Keke la fa engu eyi, ah yia ta ekpi akpi. Te mere kpara la je nga Yesu, fü ah amala ngü fü wü gara *kovo ka wü *Yïsarayele, de wüh nü kpaka Yesu, ayi-tata de engu koro, ah küwa labï ka-ni la, angü ngü labï kaka la ke tete na ta fa sü. ");
INSERT INTO muh_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Te wü mere kpara ka wü Yïsarayele la koro tete kpaka Yesu, fü ewü andaꞌba te-wü fefe, gü ba, “Akoo mere kpara! Ah le de ye le ta-ngü te komoko la, aküwa labï kaka, angü engu de züka kpara fanü fanü. ");
INSERT INTO muh_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ah jï ta *kambü ka biti-te fü ani me-ye, angü ah le ngü ka nguwa ani, wü Yïsarayele, fa sü.” ");
INSERT INTO muh_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Te Yesu je ngü la bala, fü ah ayia kürrrü, anü de wü kpara la. Te wüh nü koro gbamari ede gba mere kpara ka wü marajümïya la, fü mere kpara la ayia awu ewü te ewü ngbü ekoro. Fü ah atima gara wü awuba ye, anü amaka Yesu te kaje. Fü ewü amala ngari mere kpara la fü Yesu, agü ba, “Mere kpara, deyï, ye mbü te-ye de. Angü ni ka-ni de *ganzi kpara, ah tï fü ye arï kpa esambü ka-ni nda-ye de, angü rïrï ka gele ka-wü, wü di enga Yïsarayele, le bala de. ");
INSERT INTO muh_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Te di bala, ah tï fü ni akoro kpaka ye me-ni kpah de. Amba ni wu eyi, gü ba, wazi ye ladü. Te ye mala ta bü ngü kpa da ye kpala la, labï ka-ni la ena aküwa aküwa. ");
INSERT INTO muh_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Angü ni tï kpah eyi awu ngü la bala, teka te ni ngbü kpah esa rïrï ka wü mere kpara ka-ni ne. Kpah bala, wü gara marajümïya ladü, te ewü di esa rïrï ka-ni. Te ni mala ngü fü gara, gü ba, ye nü enü la, ah ena anü kere, baka te ni mala fefe. Anga te ni mala fü gara, gü ba, ye koro ekoro akine la, ah ena akoro kpah kere. Anga te ni mala ngü fü labï ka-ni, gü ba, ye mere mene ngü ne, ah ngbü kpah emere ngü engu la kere, baka te ni mala fefe.” ");
INSERT INTO muh_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Te Yesu je ngü la bala, fü ngü la aga gbü jijia. Fü engu afü te-ye, amala ngü fü mere bi wü kpara, te ewü ngbü efa nga ye ne, agü ba, “Kpara te to maguma ye fere baka komoko la, ma maka füh kotö ne nda-ra la kü de. Anga gbü nguwa nih, wü di enga Yïsarayele, kpara te to maguma ye bala, ah kpah ma. Amba ah ka-ye ꞌduwa de komoko la, te di de ganzi kpara ne.” ");
INSERT INTO muh_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Fü wü kpara, ta te ewü tima ewü ne, ayia ace Yesu te kaje sela. Fü ewü adu akoro kpaka mere kpara la, amaka labï la, keke kaka nza eyi! ");
INSERT INTO muh_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Fütanga ngü la, fü Yesu ayia de wü *kpara ka-ye, anü agbü gara kötï de ïrï ye Nayïna. Fü mere bi wü kpara angbü efa nga ewü. ");
INSERT INTO muh_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Gara würüse wökö ta ladü gbü kötï la, ah bï ye kü bü ngbee biringbö, jaji komoko. Fü mbarase la ayia akpi ka-ye. Te wü Yesu nü koro kpa emöngïtï ꞌbaranga ka kötï la, fü ewü amaka te-wü de mere bi wü kpara, te ewü bï kö mbarase la, enü di, ati. Fü ni ye mbarase la angbü enü fütanga kö enga ye la, da eku gba. ");
INSERT INTO muh_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Te Miri Yesu wu ngü la bala, fü cïnga würüse la arï tete. Fü ah amala ngü fefe, gü ba, “Ye ku gba de!” ");
INSERT INTO muh_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Fü Yesu anü akoro gbamari, amofo kaꞌda de te wüh bï kövö fefeh na la. Fü wü kpara la ace te-wü, arü. Fü Yesu amala ngü fü kövö la, gü ba, “Mbarase, ma emala ngü fü mü, mü zükü ezükü, mü yia tikpi!” ");
INSERT INTO muh_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Fü kövö la azükü, ayia tikpi, akpo da ero mö. Fü Yesu aza engu, alügü fü ni ye na. ");
INSERT INTO muh_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Fü ngü la ato cürü te wü kpara la ꞌburu. Fü ewü akpo da egbo nga ïrï Me, da emala ngü, gü ba, “Wü ceka la, mere *mürü dofo ka Me koro eyi esüka ani!” Fü wü gara amala nda-wü, gü ba, “Yesu de kpara te Me tima me-ye, teka aküwa ani!” ");
INSERT INTO muh_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Fü tofo ngü ka Yesu la, awü abaya te nga nzö kötï gbü sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Te wü kpara ka *Yüwane Mürü Babatïza je nga Yesu, teka wü ngü de te engu ngbü emere de bala, fü ewü anü amala nganga fü Yüwane agbü ku kpala. Te Yüwane je ngü la gömö wü kpara ka-ye bala, fü ah aï gara wü kpara ka-ye ꞌbasu, ");
INSERT INTO muh_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","atima ewü kpaka Miri Yesu, teka ayi-tata, gü ba, “Ye ngbürü me-ye de Ye Me, ta te Me mala nganga na, gü ba, ni ena atima füh kotö ne? Anga ah le de ani cï nga gara kpara te ena akoro?” ");
INSERT INTO muh_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Te wü kpara la nü koro kpaka Yesu kpala, fü ewü amala ngü fefe, gü ba, “Yüwane Mürü Babatïza tima ani, teka ayi-ta ye, gü ba, ‘Ye ngbürü de Ye Me, ta te Me mala nganga, gü ba, “Ni ena atima füh kotö ne?” Anga ah le de ani di la fï bü ecï nganga?’ ” ");
INSERT INTO muh_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wü kpara la koro ta, maka Yesu, te ngbü eküwa mere bi wü mürü keke, kpah da eliki *siti wü di enga me, te ngbü emere wü gara kpara. Ah ngbü kpah da eü jia mere bi wü kpara, de te ni eyi ani ne. ");
INSERT INTO muh_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Baka te Yesu mere ngü la nza tete, fü ah adu alügü ngü fü wü kpara ka Yüwane Mürü Babatïza la, gü ba, “Yi du edu, yi mala nga wü ngü, de te ma ngbü emere, ne ꞌburu fü Yüwane, gü ba, ‘Wü kpara de te jia ewü ni ani, wüh kpo eyi eceka kpï. Wü kpara de lö wü walawala, wüh kpo eyi enü nü. Wü mürü *jiakö küwa eyi. Wü kpara te güje ewü do ado, wüh kpo eyi eje ngü. Wü kövö kpo eyi ezükü gbü kpi. Wü mürü cïnga ngbü eyi eje ngari Me. Wü ngü la ꞌburu ngbü eyi emere te-wü, ba e ta te wü *mürü dofo ba gbü *Ngari Me ne.’ ");
INSERT INTO muh_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Te di bala, yi mala fefe, gü ba, ‘Mene kpara te ena alala fï bü eküte ra, Me ena aceka engu ba züka kpara ka-ye, fü ah angbü de mere tadu te gara.’ ” ");
INSERT INTO muh_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Fü wü kpara la ayia adu kpaka Yüwane, mere kpara ka-wü. Fü Yesu adu afü te-ye, akpo angbü emala nga Yüwane fü mere bi wü kpara la, gü ba, “Yi ngbü efï teka Yüwane, egü neh fe? Ta te yi ngbü enü kpa etü gü, da eje ngü gömö Yüwane ne, yi nü kpala neh teka ne? Yi ngbü ta efï, gü ba, Yüwane de töndö kpara, de maguma ye ꞌbasu ꞌbasu, te ngbü emere ngü baka gala, te wege ngbü efe me-ye ne? Aꞌa, ah bala de! ");
INSERT INTO muh_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Anga fïngangü ka-yi, gü ba, Yüwane de mere miri, te to züka bongo eküte ye? Aꞌa, ah bala kpah de, angü wü kpara te ewü ngbü eto züka bongo eküte wü, bete wü kpara te ewü di de mere bi wü e esaka wü ne, ngbü kpa etü gü nda-wü de! Wüh engbü ka-wü gbü mere kötï, anga gba wü miri. ");
INSERT INTO muh_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Amba ma wu eyi, gü ba, yi nü ta aceka Yüwane kükürü de, angü engu de *mürü dofo ka Me fanü. Wayi, ma emala fü yi dene zu ngü, gü ba, ngü ka Yüwane fa nda wü mürü dofo ꞌburu ka. ");
INSERT INTO muh_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Angü Yüwane me-ye de kpara, ta te wüh ba ngü kaka-na gbü Ngari Me, gü ba dene, ‘Me mala ngü fü Ye ye, gü ba, “Ni ena atima mürü tima ka-ni kpa engagira nü, teka areke kaje fü ye.” ’ ” ");
INSERT INTO muh_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Fü Yesu adu kpah amala gara ngü fü ewü, gü ba, “Ma ngbü emala fü yi dene zu ngü. Esüka wü mürü dofo ka Me ꞌburu, kpara te fa Yüwane Mürü Babatïza nda ma. Amba mene kpara te to maguma ye fere ꞌburu, ngü kaka ena afa nda Yüwane ka, angü *Nzïla Wazi Me ngbü eto wazi fefe me-ye. ");
INSERT INTO muh_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mere bi wü kpara je ngari Me ta gömö Yüwane, de wü siti wü kpara ꞌburu. Fü ewü ayia ale ngü la, afü maguma wü, aza *babatïza esakaka. ");
INSERT INTO muh_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amba wü *Farusi de wü *mürü rïrï, le afü maguma wü nda-wü de, angü wüh o maguma wü fï bü teka gele ka-wü. Te di bala, wüh le aza babatïza esaka Yüwane kpah de.” ");
INSERT INTO muh_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Fü Yesu adu kpah amala gara ngü fü wü kpara la, gü ba, “Wü kpara te ewü le ngü ka-ra de ne, ma ena amala teka ewü, agü neh fe? Wüh neh baka wü da? ");
INSERT INTO muh_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wüh ena areke ewü ma! Wüh le züka ngü nda-wü de! Wüh de wü mürü yïkï, baka wü jaji te ewü ngbü ega yïkï esüka wü. Angü wü gara wü bu ewü ngbü ta emala ngü fü ewü, gü ba, ‘Ani reke wü ma! Wü le züka ngü nda-wü de. Angü ani ngbü emï kuꞌdu fü wü, wü le alo bï de. Ani ngbü ebï ci gba fü wü, wü le aku gba kpah de!’ ");
INSERT INTO muh_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Angü, baka ta te Yüwane Mürü Babatïza koro ngbü esüka yi sene, ah zü e fa sü de, ah nzö fï kpah de. Te di bala, wüh ngbü ta efala engu, gü ba, ‘Engu de *siti wü di enga me guvu ye!’ ");
INSERT INTO muh_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amba de-ra, te ma koro esüka yi sene, ma ngbü ezü e, kpah da enzö e, fü ewü angbü kpah efala ra, gü ba, ‘Ma de mürü kü. Ma ngbü kpah eküya. Ma kpah de awuba ka siti wü kpara.’ ");
INSERT INTO muh_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wü kpara te ewü ngbü efala ngü ka-ra ne, ngbü efï nda-wü, gü ba, ani wu ngü fa sü. Amba wüh wu ngü nda-wü kü de. Ah ena adi bü nzö mene wü kpara, te ewü le ngü ka-ra eyi ne, wüh ena angbü ewu si-ngü la me-wü.” Dela ngü te Yesu mala fü wü kpara, teka ngü ka Yüwane Mürü Babatïza. ");
INSERT INTO muh_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fütanga ngü la, fü gara *Farusi de ïrï ye Sïmüna, aï Yesu, kpa gba ye teka azü e. Fü Yesu ayia anü akoro agba ka. Fü ewü angbü ezü e. ");
INSERT INTO muh_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gara würüse ta ladü gbü sü la, te ngbü emere wü *siti ngü efa sü. Te engu je, gü ba, wü Yesu ngbü ezü e agba Sïmüna, fü ah ayia aza *züka se-mü gbü kölökö, arï di kpa esambü, gbü nga wü Yesu, o wüh ngbü ezü e. ");
INSERT INTO muh_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Fü würüse la akoro angbü eri lö Yesu, akpo da eku gba de ngura. Fü ngungura angbü ego eküte lö Yesu. Fü würüse la angbü ekö ngura la de su-nzö ye, da efaka lö Yesu. Fü ah adu aza züka se-mü ka-ye la, akpo etökö da efuru eküte lö Yesu. ");
INSERT INTO muh_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Te Sïmüna wu ngü la bala, fü ah akpo da efï nga ngü emaguma ye, gü ba, “Ho! Te Yesu ena adi ta *mürü dofo ka Me fanü fanü la, de bane ah wu eyi, gü ba, ‘Würüse de te engbü emofo ni ne, ah ka-ye de siti würüse, mürü küla.’ ” ");
INSERT INTO muh_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Te Yesu wu ngü la bala, fü ah amala ngü fü mürü kötï la, gü ba, “Sïmüna, ni le amala mba enga ngü fü ye.” Fü Sïmüna ale ngü, gü ba, “Wayi, mere kpara, ye mala emala.” ");
INSERT INTO muh_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Fü Yesu amala ngü fefe gbü mani, gü ba, “Wü kpara ꞌbasu ta ladü, te ewü za matiti ka gara kpara. Gara za nda-ye mere bi jiase, baka kama ꞌburuve (500), gara za nda-ye ngbee teke ꞌbasu de füh ye nzükpa (50). ");
INSERT INTO muh_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amba jiase esaka ewü ꞌbasu mini, teka alügü matiti ka kpara la di ne, nda ma. Fü mürü jiase la awu cïnga ewü. Fü ah adu ace ngü la fü ewü. Te di bala, kpara te ena ale mürü jiase la afa sü, esüka ewü de ꞌbasu ne, neh da?” ");
INSERT INTO muh_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Fü Sïmüna alügü ngü fefe, gü ba, “Ni efï, gü ba, ah ena adi de mene kpara de mere bi jiase gbü nga ye ne.” Yesu gü ba, “Wayi, ye mala eyi mbi.” ");
INSERT INTO muh_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Fü Yesu afü te-ye kpaka würüse la, adu amala ngü fü Sïmüna, gü ba, “Mü wu würüse ne eyi? Ah le ngü ka-ra fa nda-mü ka. Ceka la, te ma koro gba mü sene, mü le ato ngu fere azürü lö ra di de. Amba würüse ne, ah zürü lö ra eyi de ngura ye. Fü ah adu akö de su-nzö ye. ");
INSERT INTO muh_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kpah bala, tïne te mü gü mandï fere ne, mü faka ra nda-mü de. Amba würüse ne, ah ce da efaka lö ra nda de. ");
INSERT INTO muh_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mü za ra reke areke, ba ngba ka-mü ne, kpah de. Amba würüse ne, ah za ra cu reke areke. ");
INSERT INTO muh_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Teka ngü la, ma ngbü emala fü mü, gü ba, mere bi wü *siti ngü ka würüse la, te engu mere la, Me boro eyi ꞌburu asidi. Nih tï eyi awu ngü la bala, angü ah le ra eyi fa sü. Amba te mü gü ba, ni mere siti ngü fa sü de, te ah bala, mü le ngü ka-ra mbi mbi nda-mü kpah de.” ");
INSERT INTO muh_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Fü Yesu adu amala ngü fü würüse la, gü ba, “Ma boro wü siti ngü ka-mü eyi ꞌburu.” ");
INSERT INTO muh_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Te gara wü *Farusi, de te ewü ngbü ezü e de wü Yesu ne, je ngü la bala, fü ewü akpo da emala ngü esüka wü, gü ba, “Komoko la ngbü eboro siti ngü ka wü kpara, ne baye baye? Ah ngbü efï, gü ba, ni de Me?” ");
INSERT INTO muh_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Fü Yesu adu amala tïne adu ngü fü würüse la, gü ba, “Mü küwa eyi, angü mü to maguma mü eyi fere. Mü nü enü de gu maguma.” ");
INSERT INTO muh_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Fütanga ngü la, fü Yesu akpo da endoro de wü *kpara ka-ye nzükpa de füh ye ꞌbasu ne, gbü wü nga nzö kötï ka sü la ꞌburu. Ah ngbü ta emala to ngari Me fü wü kpara kpala, kpah da esere fü ewü, gü ba, “Miri te Me tima teka aküwa wü koro eyi, ah le de wü fü maguma wü afü.” ");
INSERT INTO muh_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Wüh ngbü endoro kpah de wü gara würüse, ta te engu liki *siti wü di enga me guvu ewü, de wü gara ta te engu küwa ewü gbü wü keke ka-ewü ne. Ah de wü *Marïya Egba-Magadala, ta te Yesu liki siti wü di enga me guguvu lorozi ne, ");
INSERT INTO muh_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","bete Yüwana, wara Kuza, te di de kpara te engbü eceka kpï fütanga tima ka Miri Anïtïpa *Erode ne, bete Süzana, de mere bi gara ewü. Wü würüse la ngbü ta eza wü e ka-wü, adi ele ta-ngü di te wü Yesu. ");
INSERT INTO muh_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Mere bi wü kpara ngbü ta fï bü ekoro kpaka Yesu, teka adi eje to ngari Me gögömö na. Wüh koro ta gbü nga nzö wü kötï ka sü la ꞌburu. Gbü gara sïkpï, fü Yesu, ayia akpo da emala ngari Me fü mere bi wü kpara la gbü mani, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Gara komoko ta ladü, te za nguwa ka-ye, anü di, amoko kpa agbü yï. Te engu koro kpala, fü ah akpo emoko nguwa ka-ye la. Fü wü gara nguwa atï nda-wü te jia kaje, fü wü kpara angbü edoto. Fü wü lu awu nguwa la, ayia akoro kere, adoro, ami. ");
INSERT INTO muh_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fü gara bete nguwa atï füh sï-da, te tö di sela mbi mbi ma. Fü nguwa la ayia akö kere, teka ne de, angü tö sela sere sere. Fü ra ayia asü. Fü fu-ndo la aürü ka-ye ꞌburu, angü sasa na ka-ye de da. ");
INSERT INTO muh_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fü gara nguwa atï esüka wü ti. Fü nguwa la akö aga de wü fu-ti la ꞌburu. Fü wü ti awündü züka fu-ndo la. Fü ah adu afü te-ye yï-andüla tete, angü wü fu-ti la ta ewü eyi ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amba wü gara nguwa tï nda-wü gbü züka sü. Fü ewü ayia akö ꞌburu, aga, arï, azï jia wü, gbrrri, afa sü, baka e kama biri (100) te nzö ndo biringbö.” Fü Yesu adu amala ngü fü ewü de mere ri ye, gü ba, “Te güje mü ladü la, de mü da güje mü te ngü ka-ra la mbi mbi mbi.” Dela ngü te Yesu mala teka nguwa, te wüh moko. ");
INSERT INTO muh_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Te wü *kpara ka Yesu je ngü la bala, fü ewü ayi-tata, gü ba, “Si-ngü gbü mani la, gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Fü Yesu alügü ngü fü ewü, gü ba, “Ta gügü, wü kpara je si-ngü ka Me nda-wü de. Ngü ka Me ngbü gbü jia ewü ꞌdaaa, ah wo te-ye awo. Nda-yi, wü kpara ka-ra, ma ngbü eyi esere ngü la fü yi ꞌburu mbölö mbölö, gü ba, Me le de wü kpara ꞌburu to maguma wü fü ni. Amba wü gara kpara la tï aje si-ngü la nda-wü de, angü wüh le ngü ka-ra de. Teka ngü la, ma ngbü emala ngü la fü ewü ꞌburu de mani. Ah kpah baka ngü ta te Me mala teka wü kpara la, gömö *mürü dofo Yïsaya, gü ba dene, ‘Wü ena aceka ngü ka-ni ma, wü tï awu sisi na nda-wü de. Wü ena aje ngari ni, Me, ma, ngü la tï arï gbü nzö wü mbi mbi kpah de.’ Dela ngü ta te Me mala gügü teka wü kpara, te ewü le ngü ka-ra de ne.” ");
INSERT INTO muh_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Fü Yesu akpo da emala si mani la fü ewü, gü ba, “Dene si-ngü gbü mani ka nguwa ne. Nguwa te wüh moko agbü yï ne, ah ka-ye baka ngari Me, te ewü ngbü emala fü wü kpara. ");
INSERT INTO muh_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nguwa te tï te kaje, ah ba wü mene kpara, te wüh mala ngari Me fü ewü, amba ngü la rï gbü nzö ewü, fü ewü ao emaguma wü ne de. Te *Satana wu ngü la bala, fü ah ayia kere, akoro aza ngü la emaguma ewü asidi, angü wüh ena ara fü Me, fü ewü aküwa. ");
INSERT INTO muh_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nguwa te tï füh sï-da, ah ba mene wü kpara, te wüh mala ngari Me fü ewü, fü ewü ayia aje ngü la, ale de mere tadu te wü. Amba wüh rü kpekpeke gbü ngü ka Me de. Wüh to maguma wü bü teka sïkpï mba cüküꞌdaye. Baka te cïnga maka ewü, fü ewü ayia ace ngü ka Me ka. ");
INSERT INTO muh_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Nguwa te tï nda-ye esüka wü ti ne, ah baka mene wü kpara te ewü le ngari Me la eyi, amba wüh maka wazi teka arü kpekpeke, gbü ngü ka Me nda-wü de. Angü fïngangü ka-ewü ka-ye ꞌbasu ꞌbasu, teka ngü ka jiase, de ngü ka tadu, de wü gara e füh kotö ne. Fü wü ngü la angbü esiti fïngangü ka wü kpara la, wüh tï amere tima ka Me mbi mbi nda-wü de. Fü ewü angbü ka-wü ꞌburu baka yï-andüla tete. ");
INSERT INTO muh_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amba, mene nguwa te tï gbü züka sü ne, ah baka mene wü kpara de te ewü je ngari Me, fü ewü ale de maguma wü biringbö, azoro ngü la de kpa wü ꞌbasu, ao to wü, angbü emere. Wü kpara la, wüh baka ndo te rï reke areke, gbrrri bala. Dela si-ngü gbü mani teka nguwa ndo la.” ");
INSERT INTO muh_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Fütanga ngü la, fü Yesu amala kpah gara mani fü ewü, gü ba, “Yi je eyi, gü ba, te wüh siya wa teka alofo sü kpa esambü gbü biti la, wüh ngbü ebuka neh esa sila? Anga eo esa ngbaga? Ah bala de. Wüh ngbü esiya wa, eo kpa tikpi füh e, teka fü ah angbü elofo sü fü wü kpara ꞌburu. Angü, te wü kpara ena angbü erï kpa esambü la, fü ewü angbü eceka kpï tete mbi mbi mbi. ");
INSERT INTO muh_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kpah bala, ngü ka-ra te wü kpara je mbi mbi de, te wo te-ye awo fü ewü ne, wüh ena awu ngü la te gara, angü Me ena adu asere ngü la fü ewü me-ye ngbaa ngbaa ngbaa. ");
INSERT INTO muh_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Yi da güje yi teka ngü, de te ma ngbü emala fü yi ne, mbi mbi mbi. Kükürü de, angü te mü le ngü ka-ra ne eyi la, Me ena adu agü tamu gara wü ngü fü mü gbe. Amba te mü le aje ngü ka-ra nda-mü de, mba enga ngü cüküꞌdaye te di gbü nzö mü ne, ah ena adürü ka-ye adürü asidi.” ");
INSERT INTO muh_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Fütanga ngü la, fü wü di enga ni ye Yesu ayia akoro kpakaka na de wü ni ye na. Te wüh koro tete, fü ewü amaka mere bi wü kpara, te wüh biti te-wü, ngbü ede Yesu, teka aje to ngari Me gögömö. Amba da wü ni ye na, te ewü ena arï anü kpakaka kpa esambü la, nda ma. ");
INSERT INTO muh_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Te wü kpara la wu ngü la bala, fü ewü amala ngü fü Yesu, gü ba, “Mere kpara deyï, wü ni ye, de wü di enga ni ye, koro eyi, ngbü kpa etanü kpane. Wüh ngbü ele awu ye.” ");
INSERT INTO muh_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Te Yesu je ngü la bala, fü ah ayia amala ngü fü wü kpara la ꞌburu, gü ba, “Ah mbi, amba mene wü kpara, te ewü ngbü eje rïrï ka Me, angbü emere ne, wüh kpah baka wüna, de wü di enga wüna.” Dela ngü ta te Yesu mala fü mere bi wü kpara la. ");
INSERT INTO muh_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gbü gara sïkpï, fü Yesu ayia amala ngü fü wü *kpara ka-ye, nzükpa de füh ye ꞌbasu ne, gü ba, “Ani nü la kpa etangu.” Fü wü kpara kaka ayia ale. Fü ewü alï ꞌburu gbü *zabu, teka akö ngu. ");
INSERT INTO muh_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Fü ewü anü, anü, anü akoro kpa etü mere ngu *Galïlaya la. Amba Yesu tï ka-ye eyi era ara. Fü mere wege ayia akoro kere, akpo da efe jia ngu de wazi. Fü zabu akpo da eyiki, efüfü te-ye, da ekolo ngu gbü ye. Fü ngu angbü esi gbü zabu la. Zabu la yia ta ebu ewü abu agbü ngu. ");
INSERT INTO muh_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fü wü *kpara ka Yesu angbü de cürü. Fü ewü anü azükü engu, gü ba, “Mere kpara, mere kpara, ani te ekpi! Ani te ekpi!” Fü Yesu ayia azükü, awu ngü la bala. Fü ah amala ngü fü siti wege la, gü ba, “Wege, mü nga anga! Ngu, mü ngbü ziii!” Fü wege ayia anga. Fü ngu angbü ziii. Fü sü ayia anga ꞌduwa ngbiii! ");
INSERT INTO muh_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Fü Yesu adu amala ngü fü wü kpara ka-ye, gü ba, “Yi ekpe neh cürü ne? Yi to maguma yi fere mbi mbi la fï de?” Fü ngü la aga gbü jia wü kpara kaka-na la afa sü. Fü ewü angbü de cürü, da emala ngü esüka wü, gü ba, “Apa! De bane neh ene ngü ne? Komoko la neh da, te ngbü emala ngü bü de komö ye, fü wü wege de wü ngu angbü eje rïrï kaka-na ne?” Dela ngü ta te Yesu mere, te engu to rïrï fü mere wege tete. ");
INSERT INTO muh_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Te wü Yesu kö ngu tete, fü ewü akoro kpa füh gümba, agbü tö ka wü Garasa, te di kpa etangu mere ngu *Galïlaya. ");
INSERT INTO muh_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Gara komoko ta ladü kpala, te *siti wü di enga me sibi guguvu gbe fa sü. Teka mere bi sïkpï, ah ngbü engbü ka-ye ngïrïmu. Ah ngbü ta ekötï nda kpah de, ah ngbü era ka-ye etü wü mbükü. Fü wü di enga me la angbü ta emere engu efa sü. Fü wü kpara angbü ꞌburu ekpe engu akpe. Fü ewü angbü edü wü kengbe gbü kpakpa, de wü lölö na. Fü ah angbü ekukuru wü kengbe la eküte ye asidi. Fü wü di enga me la angbü eza engu, enü di agbü gü. Baka te wü Yesu ngbü la bü ekoro kpa füh gümba, fü komoko la awu Yesu. Fü ah akoro atï kötö eri lölö na, da eba rere. Fü Yesu amala ngü fü wü siti wü di enga me la, gü ba, “Wü ce engu ace!” Fü komoko la andaꞌba te-ye kpaka Yesu, da emala ngü fefe de mere ri ye, gü ba, “Yesu, Ye Mere Me, ye ele amere de ni ne ngü ne? Tima ka-ni gbü ngü ka-ye nda ma! Ni ngbü endaꞌba te-ni fü ye, de ye mere e ato kuru te ni la de!” ");
INSERT INTO muh_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Te Yesu je ngü la bala, fü ah ayi-tata, gü ba, “Ïrï ye neh da?” Fü komoko la alügü ngü, gü ba, “Ïrï ni de Bi-nzö-gü.” Ah gü ïrï ye bala, angü wü di enga me sibi guguvu gbe fa sü. ");
INSERT INTO muh_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Fü wü di enga me la, andaꞌba te-wü fü Yesu, gü ba, “Ye mere e aliki ani, ato agbü mere du ka cïnga ne de.” ");
INSERT INTO muh_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mere bi wü mba ka kötï ta ladü gbü sü la, te ewü ngbü ezü e füh gümba sela. Fü wü di enga me la afüwa te-wü fü Yesu, gü ba, “Ye tima ani, de ani nü rï kpa guvu wü mba la.” Fü Yesu ayia ale ngü la fü ewü, de wüh nü, baka te ewü mala. ");
INSERT INTO muh_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Fü wü di enga me la ayia akoro guvu komoko la asidi, ace engu, akpe arï aguvu wü mba la. Fü wü mba la aci de mere woro, ago kpa esa gö, agürü agbü mere ngu, anzö ngu, akpi ꞌburu kpala. ");
INSERT INTO muh_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Te wü kpara, de te ewü ngbü eceka kpï fütanga wü mba la, wu ngü la bala, fü cürü amere ewü. Fü gara ewü akpe de woro, anü amala nga ngü, te Yesu mere la, fü wü kpara agbü mere kötï, bete wü sü edede la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Te wüh je ngü la, fü mere bi wü kpara akpe akoro, teka aceka ngü la cu de jia wü. Fü ewü akoro amaka komoko, ta te wü di enga me ngbü emere engu ne, te ngbü ka-ye eri lö Yesu sela. Ah to tïne züka bongo eküte ye, fïngangü kaka du koro kpah eyi mbi. Fü ngü la ato cürü fü wü kpara la afa sü, gü ba, “Dela sirimbi!” ");
INSERT INTO muh_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Fü wü kpara, de te ewü wu ngü la cu de jia wü ne, ayia angbü emala nga komoko la fü wü bu wü, gü ba, “Yesu liki wü di enga me guguvu na me-ye.” ");
INSERT INTO muh_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Fü ngü la ato mere fïngangü, de cürü fü wü kpara ka sü la ꞌburu. Fü ewü aci ꞌburu ayi-ta Yesu, de ah ce sü ka-ani. Fü Yesu alï de wü kpara ka-ye gbü *zabu, teka anü ka-wü. ");
INSERT INTO muh_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Fü komoko de te wü di enga me koro guguvu na ne, ayia andaꞌba te-ye fü Yesu, gü ba, “Ni ele anü ka-ni ake ye.” Fü Yesu alügü ngü fefe, gü ba, ");
INSERT INTO muh_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Aꞌa, ye du edu kpa gba wü, fü ye amala nga züka ngü, de te Me mere fü ye ne, fü wü di enga ni ye.” Fü komoko la ayia adu, angbü endoro gbü nga nzö kötï la, da emala nga ngü, de te Yesu mere fü ye ne, fü wü kpara. ");
INSERT INTO muh_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Fütanga ngü la, fü wü Yesu alügü nga wü adu kpa etangu agbü sü ka-wü, agbü *Galïlaya. Te wü Yesu du koro tete, fü mere bi wü kpara aci akoro kpakaka na de mere tadu, angü wüh ngbü ta kü ecï nganga. ");
INSERT INTO muh_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Gara komoko ta ladü kpala de ïrï ye Yayïrü. Engu ta de mere kpara te ngbü emere tima kpa *esambü ka biti-te. Fü Yayïrü ayia akoro, atï eri lö Yesu, andaꞌba te-ye fefe gü ba, “Mere kpara deyï, ye koro la mba agba ni, teka aküwa ye ni.” ");
INSERT INTO muh_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Angü yeye na ka-ye ta ngbee biringbö, ye würüse te re kaka di baka nzükpa de füh ye ꞌbasu. Mbarase la ngbü ta eke efa sü, ah yia ekpi akpi. Te Yesu je ngü la, fü ewü ayia anü de wü Yayïrü. Fü mere bi wü kpara aci kpah anü gbü nga ewü, da enzinzi te-wü, ededere Yesu. ");
INSERT INTO muh_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Amba gara würüse ta kpah ladü sela, te ngüte ngbü ego tete teka wü re nzükpa de füh ye ꞌbasu. Ngü la ngbü ta eto mere cïnga fü würüse la efa sü. Ah ngbü ta enü kpaka mere bi wü mürü kuwa, de wüh küwa ni, amba wü mürü kuwa la to rü fefe ma, ah le ta-ngü tete de. ");
INSERT INTO muh_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te würüse la je nga Yesu, gü ba, “Engu koro eyi sela ne,” fü ah ayia agbeke te-ye, anü kpala. Te engu koro kpala, fü ah ayia azi te-ye ꞌbïlï ꞌbïlï, esüka mere bi wü kpara la, anü amofo mö bongo ka Yesu to kpa ekükürüfe. Würüse la kpah bü te emofo bongo ka Yesu, ꞌduwa fü ngüte la ayia akolo tete. ");
INSERT INTO muh_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Te Yesu wu ngü la bala, fü ah ayi-ta ngü, gü ba, “E-mofo bongo ka-ni neh da?” Fü wü kpara ꞌburu acere nga wü gbere. Fü Petero ayia amala ngü, gü ba, “Mere kpara, ye ena angbü eyi-ta ngü bala ne, ye wu mere bi wü kpara, te ewü ngbü egbene sü agbene, ne de?” ");
INSERT INTO muh_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Fü Yesu angbü de ngü la fï gömö ye, gü ba, “Gara kpara mofo ni eyi, angü ni wu eyi kpo, gü ba, wazi te Me to fü ni ne mere tima eyi.” ");
INSERT INTO muh_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Te würüse la wu, gü ba, Yesu wu ngü la eyi, fü ah aka te-ye, akoro atï eri lö Yesu, küküte ꞌburu eloꞌböka ka cürü. Ah du cere nga ye tïne de. Fü ah amala fü Yesu gbü jia wü kpara la ꞌburu, gü ba, “Ah de ni, ni mofo bongo ka-ye me-ni. Teka ngü la, fü ni ayia aküwa dene.” ");
INSERT INTO muh_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Fü ngü la areke te Yesu, fü ah amala fefe, gü ba, “Enga ra, mü küwa eyi, teka te mü to maguma mü eyi fere. Mü nü enü de gu maguma.” ");
INSERT INTO muh_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Baka te Yesu ngbü la bü emala ngü fü würüse la, fü gara kpara akpe akoro agba Yayïrü, te mbarase kaka ngbü eke ake ne, amala ngü fefe, gü ba, “Yayïrü deyï, ah nza eyi! Ye mere e ambü mere kpara la tïne de, angü ye ye kpi ka-ye eyi.” ");
INSERT INTO muh_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Te Yesu je ngü la bala, fü ah amala ngü fü Yayïrü, gü ba, “Ye mere e akpe cürü de. Te ye to maguma ye ꞌburu fü ni, mbarase ka-ye ena aküwa.” ");
INSERT INTO muh_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Fü wü Yesu ayia anü akoro agba Yayïrü. Fü ewü amaka wü kpara kpala ꞌburu da eku gba de mere cïnga te wü, teka kpi ka mbarase la. Te Yesu wu ngü la bala, fü ah amala ngü fü ewü, gü ba, “Wü mere e aku gba de, angü mbarase la ngbü era ka-ye ara, ah kpi akpi nda de!” Fü wü kpara la, aci ꞌburu angbü emü ngü ka Yesu la amü, angü wüh wu eyi fanü, gü ba, mbarase la kpi ka-ye eyi. Fü Yesu ayia arï te sü, te ewü o kö mbarase la tete. Ah le fü mere bi wü kpara arï kpa esambü kpala de. Ah za bü Petero, *Yüwane ake *Yakobo gbü nga ye, bete wö ye mbarase la, ake ni ye na. ");
INSERT INTO muh_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Fü Yesu ato kpa ye, azoro kpa jaji würüse la, amala ngü fefe, gü ba, “Enga ra, mü yia eyia tikpi!” ");
INSERT INTO muh_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Fü mbarase la ayia azükü gbü kpi. Fü Yesu adu amala ngü fü wü wö ye na ake ni ye na, de wüh to zü-e fefe. ");
INSERT INTO muh_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Fü ngü la aga gbü jia wö ye mbarase la, ake ni ye na afa sü. Fü Yesu amala ngü fü ewü kpekpeke, gü ba, “Wü mere e amala nga ngü la fü wü kpara de de de.” ");
INSERT INTO muh_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Gbü gara ra, fü Yesu aï wü kpara ka-ye, nzükpa de füh ye ꞌbasu ne kpaka ye, angü ah le atima ewü, teka anü amala to ngari Me agbü wü gara sü. Fü engu ato wazi fü ewü, teka fü ewü adi eliki *siti wü di enga me di, de wü muruyi, kpah da eküwa wü mürü keke. Fü engu amala ngü fü ewü, gü ba dene, “Yi nü enü, yi mala ngari ra fü wü kpara, gü ba, ‘Miri, te Me tima teka aküwa ani ne, koro eyi. Ah le de wü fü maguma wü afü.’ Yi di kpah eküwa wü mürü keke. ");
INSERT INTO muh_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Te yi te enü, yi mere e aza wü e esaka yi de. Yi za ngbangba de. Yi za kombo kpah de. Yi za ambata kpah de. Yi za jiase kpah de. Yi za bongo ꞌbasu ꞌbasu kpah de. ");
INSERT INTO muh_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gbü wü sü te yi ena anü akoro gbügbü na, te wü kpara la za yi eyi gbü mürü, de yi ngbü nzö gba kpara biringbö la, zalü gbü sïkpï te yi ena ayia anü sü tete. ");
INSERT INTO muh_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kpah bala, teka mene wü sü te wü kpara le ngü ka-yi gbügbü de, yi mere e angbü sela de. Yi yia sela asidi, de yi bunda zu-tö ka sü ka-ewü la te lö yi, ce ciki sela, teka agü tamu ngü la fü ewü, gü ba dene, ‘Me le ngü ka-wü de, angü wü le ngü wü kpara ka-ni, Me, kpah de.’ ” Dela ngü te Yesu mala fü wü kpara ka-ye, te engu tima ewü ne. ");
INSERT INTO muh_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Fütanga ngü la, fü wü *kpara ka Yesu la ayia anü andoro gbü wü kötï ka sü la biri biri ꞌburu, da emala to ngari Me fü wü kpara, kpah da eküwa wü mürü keke gbü wü sü la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Fütanga ngü la, fü ïrï Yesu awü ka-ye tïne gbü wü sü la ꞌburu. Fü wü kpara akpo da eyi-ta tete-wü, gü ba, “Apa! Mene kpara la neh da?” Wü gara ewü gü ba, “Ah de *Yüwane Mürü Babatïza, ta te Miri Anïtïpa *Erode mörö ne, ah zükü me-ye gbü kpi.” Wü gara gü ba, “Ah ena adi de gara *mürü dofo, te zükü me-ye gbü kpi.” Wü gara gü ba, “Ah de mürü dofo *Ïlïya, te zükü me-ye gbü kpi.” Fü Miri Anïtïpa Erode aje nga Yesu, fü fïngangü kaka akpo angbü endoro faaa. ");
INSERT INTO muh_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Teka ngü la, fü ah angbü efï ngü, gü ba, “Angü ni mörö ta Yüwane eyi ne, amba mene kpara, te ni ngbü kpah eje nganga ne, neh da?” Fü ah akpo da egïrï kaje, de ni wu Yesu, cu de jia ni. ");
INSERT INTO muh_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Fü wü *mürü tima ka Yesu, ta te engu tima ewü ne, adu akoro kpakaka. Fü ewü amala nga wü ngü, de te ewü nü mere kpala ne, ꞌburu fefe. Fü Yesu ayia aza nzö bü ewü, anü di agbü gara sü de ïrï ye Betesayïda. ");
INSERT INTO muh_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Te wü kpara je, gü ba, Yesu nü sü eyi agbü Betesayïda, fü mere bi ewü aci ayia anü afa nganga na kpala. Te Yesu wu ngü la bala, fü ah awu cïnga ewü. Fü ah akpo da emala to ngari Me fü ewü, kpah da eküwa wü gara mürü keke esüka ewü. ");
INSERT INTO muh_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Etamurago la, o ra tï nza la de, fü wü *kpara ka Yesu, nzükpa de füh ye ꞌbasu ne, ayia angbü de mere fïngangü. Fü ewü ayia anü kpaka Yesu, amala ngü fefe, gü ba. “Mere kpara, ani ena amere baye, teka mere bi wü kpara ne? Baka te ani di kpakine edere sü, kötï kpah ma ne, ani ena amere baye? Ah le de ye mala ngü fü wü kpara la, de wüh nü agbü mere kötï, teka agïrï zü-e, kpah bete sü ka rara fü wü kpala.” ");
INSERT INTO muh_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Te Yesu je ngü la bala, fü ah amala ngü fü ewü, gü ba, “Yi ena ato zü-e fü ewü enatikine me-yi.” Wüh gü ba, “Apa! Mere kpara! Ambata esaka ani sene ngbee ꞌburuve bete si ꞌbasu ne. Wü e la ena atï de mere bi wü kpara la kü atï fanü? Anga te ani ena anü ase e la, ah ena aza jiase neh fe?” ");
INSERT INTO muh_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wüh mala ngü la bala kükürü de, angü wüh wu eyi, gü ba, wü kpara la sibi fa sü, wü kpara la ta ꞌburu baka wü komoko kutu ꞌburuve (5,000). Fü Yesu adu amala ngü fü wü kpara ka-ye la, gü ba, “Yi biti wü kpara la, de wüh ngbü kötö tundu tundu, baka wü kpara teke ꞌbasu de füh ye nzükpa gbü sü biringbö.” ");
INSERT INTO muh_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Baka te wü kpara kaka-na je ngü la bala, fü ewü anü ꞌduwa abiti wü kpara la ꞌburu, angbü gbü wü da-sü ka-wü, baka te engu mala la. ");
INSERT INTO muh_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Fü Yesu ayia aza wü ambata ꞌburuve la, bete wü si ꞌbasu ne esaka ye, ae jia ye, aceka kpï kpa tikpi, agbo nga ïrï Me teka zü-e la. Fü ah akukuru tü wü ambata la, ato esaka wü kpara ka-ye, de wüh gafa fü wü kpara la ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Fü wü kpara la aci ꞌburu, azü e la, asika di, ace dudu na kötö sela. Fü wü kpara ka Yesu adu aro du wü e la ꞌburu, abiti gbü wü kuwu, asi gbe gbe gbe, nzükpa de füh ye ꞌbasu. Dela ngü ta te Yesu mere, te engu to zü-e di fü mere bi wü kpara ne. ");
INSERT INTO muh_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gbü gara ra, fü Yesu anü angbü ka-ye kpikpi ye, da eku gba fü Me. Fü wü kpara kaka ayia akoro kpakaka na. Fü Yesu ayi-ta ewü, gü ba, “Angü wü kpara ngbü emala tüngü ra egü neh fe? Wüh gü ba, ma de neh da?” ");
INSERT INTO muh_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Fü ewü alügü ngü fefe, gü ba, “Wü kpara ngbü efï, gü ba, ye de kpeke kpara. Angü wü gara kpara ngbü emala nda-wü, gü ba, ‘Mü de *Yüwane Mürü Babatïza.’ Wü gara ewü gü ba, ‘Mü de mürü dofo *Ïlïya.’ Wü gara emala nda-wü, gü ba, ‘Mü de biri kpara esüka wü *mürü dofo ka Me ta gügü ne, te zükü me-ye gbü kpi.’ ” ");
INSERT INTO muh_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Fü Yesu adu ayi-ta ewü, gü ba, “Anga cu de-yi, yi ngbü efï nda-yi teka ra, egü neh fe?” Petero, fü mü ayia arü amala ngü fefe, gü ba, “Mü de *Kurisito, Mere Miri te Me tima teka aküwa a ne!” ");
INSERT INTO muh_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Te Yesu je ngü gömö Petero de bala, fü ah amala ngü fü wü kpara ka-ye la kpekpeke, gü ba, “Yi mere e amala nga ra fü wü kpara, gü ba, ma de Kurisito, ne de.” ");
INSERT INTO muh_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Fü Yesu adu kpah amala gara ngü fü ewü teka kpi ka-ye, gü ba, “Mere cïnga ladü te ena amere ra, angü ah le de cïnga mere *Ye Kpara ka Kpï bala. Wü angbe cögbörö kpara, de wü mürü gele ka Me, bete wü *mürü rïrï, wüh ngbü eyi ekpü ra. Te di bala, wüh ena amörö ra amörö. Amba gbü *ebabata sïkpï, Me ena azükü ra gbü kpi la.” ");
INSERT INTO muh_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Fütanga ngü la, fü Yesu amala ngü fü mere bi wü kpara la ꞌburu, gü ba, “Te mü le angbü zu kpara ka-ra la, mü mere e afï nga wü e ka-mü ꞌburu ꞌdö de. Mü reke te-mü teka kpi ka-mü, baka kpara te ngbü ebï mere *rü gbegbete, te wüh ena abere engu fefeh na, amörö. Fü mü ayia alala fï bü gbü nga ra. ");
INSERT INTO muh_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Te mü le aküwa te-mü de tete-mü la, mü tï aküwa te-mü nda-mü de. Amba te mü ce te-mü o fü kpi, teka ngü ka-ra la, Me ena aküwa mü me-ye. ");
INSERT INTO muh_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mü fï la nga kuru mü! Angü te mü ce ngü ka Me, fü mü adu ato te-mü ꞌburu teka ngü ka kotö ne, da emaka mere bi jiase, de mere bi wü züka e, de füh kotö ne ꞌburu la, wü e la ena aküwa mü fanü? Wüh tï aküwa mü nda-wü de, angü mü ce ngü ka Me eyi! ");
INSERT INTO muh_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mü fï nga *adu sïkpï, te ma ena adu akoro tete na. Angü de-ra, Ye Kpara ka Kpï, ma ena adu akoro füh kotö ne, de wazi ka Wüba, de wü *malayïka kaka mini. Angü te mü ce ngü ka-ra, ma ena ace mü kpah ace, gbü adu sïkpï, te ma ena adu akoro tete na. ");
INSERT INTO muh_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma ngbü emala fü yi dene zu ngü fanü fanü. Wü gara kpara ladü esüka yi sene, wüh tï akpi la de, zalü te wüh ena awu mere wazi te Me to fere, Ye Kpara ka Kpï, te ma ena aküwa wü kpara di ne feke.” Dela ngü ta te Yesu mala fü wü kpara te ewü le afa nga ye. ");
INSERT INTO muh_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Fütanga sïkpï ꞌbajena, fü Yesu aza wü Petero ake *Yüwane, bete *Yakobo. Fü ewü ayia anü kpa enzö mere rüvü, teka aku gba fü Me kpala. ");
INSERT INTO muh_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Te wüh koro kpala, fü gbüra Yesu ayia afü te-ye, o engu ngbü eku gba fü Me. Fü bongo kaka avi ꞌduwa kpïlïlï! Ah ngbü kpah eci aci baka ra. ");
INSERT INTO muh_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Wüh te eceka kpï bane de, gbo! te wü kpara ꞌbasu, te ewü koro de mere wazi ka Me. Fü ewü angbü ero mö de wü Yesu, teka ngü ka kpi kaka-na, te engu ena akpi agbü Yerüsalema ne. Amba wü kpara la, wüh ka-wü de diri wü kovo ka Me ta gügü, wü *Müse ake *Ïlïya. ");
INSERT INTO muh_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Te ngü la ngbü emere te-ye tete, Petero de wü bu ye ne kpi ka-wü eyi de ra. Fü ewü adu azükü, awu Yesu, de wü kpara ꞌbasu, te ewü ngbü de ewü ne, te küte ewü ngbü ꞌburu eci aci gbü wazi ka Me. ");
INSERT INTO muh_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Baka te wü kpara la yia ece Yesu tete, fü Petero ayia amala ngü fü Yesu, gü ba, “Mere kpara, wü kpara ne di ngbü enü neh ka-ye? Ah reke ta ngbürü pe te ani ena angbü ka-ani bü sene, angü sü de sene reke gbü jia ni fa sü. Te di bala, ani ena ajï wü gugu bata, nda-ye biringbö, nda Müse biringbö, nda Ïlïya kpah biringbö.” Petero mala ngü la bü bala, angü ah wu züka ngü, te engu ena amala ne, nda de. ");
INSERT INTO muh_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petero bü te emala ngü la bala, fü sangu ayia akoro agba ewü ꞌburu. Fü ngü la ato mere cürü eküte wü Petero afa sü. ");
INSERT INTO muh_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Fü ri Me ayia awü gbü sangu la, gü ba, “Dene zu de Ye ra, te maguma ra le engu fa sü, angü ma fe engu me-ra. Yi di eje rïrï kaka-na.” ");
INSERT INTO muh_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Fütanga ri Me de te ewü je ne, wüh te efü jia wü bane de, yïrrrï! wü Müse ake Ïlïya nda-wü tïne eyi ma, bü Yesu te ngbü ka-ye kpikpi ye. Fü ngü la aga gbü jia wü *kpara ka Yesu de bata la afa sü. Fü komö ewü agu ꞌduwa agu. Gbü wü sïkpï la, wüh mala nga ngü, de te ewü wu la, fü biri kpara mbele de. ");
INSERT INTO muh_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Te kpï seke tete, kpurutokokpï la, fü wü Yesu ayia de wü kpara ka-ye de bata la, adu kpa esa gö. Fü ewü anü amaka te-wü kpah de mere bi wü kpara te kaje. ");
INSERT INTO muh_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Esüka mere bi wü kpara la, gara komoko ta ladü te yeye di ngbee biringbö, ye komoko. *Siti wü di enga me ngbü ta emere mbarase la, da egbofo engu kötö. Fü ah angbü eku gba. Fü durufu angbü ekoro gögömö tuku tuku bala! Te e la kpo eyi da emere engu la, ah ngbü emere engu sisiti, ah le ace engu kere de. Te komoko la wu Yesu, fü ah akpo endaꞌba te-ye fefe na, gü ba, “Akoo, mere kpara! Ye ceka la cïnga te ani ne baaa! Ni le de ye küwa la ye ni ne, angü siti wü di enga me ngbü emere engu ꞌduwa ba-neh-ene-la. ");
INSERT INTO muh_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ni za engu koro ta di kpaka wü kpara ka-ye, sidi nga ye sene, de wüh küwa engu ne, amba wazi ewü, te ewü ena aliki wü di enga me la di, nda ma. Fü ni angbü ecï nga ye di dene.” ");
INSERT INTO muh_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Te Yesu je ngü la bala, fü ah ayia amala ngü fü wü kpara ka-ye, gü ba, “De-yi wü kpara ka re ne, yi de wü siti kpara, yi le ato maguma yi fü Me de, neh teka ne? Ma ena angbü de wü yi sene teka re neh fe, teka fü ngü la arï gbü nzö yi?” Fü ah adu afü te-ye, amala ngü fü wö ye mbarase la, gü ba, “Ye koro de mbarase la akine!” ");
INSERT INTO muh_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Te wö ye mbarase la za ta mbarase la, enü di tete kpaka Yesu, wüh te ekoro gbamari, fü wü di enga me la ayia agbürü engu, agbo kötö. Fü mbarase akpo eyiyili te-ye. Te Yesu wu bala, fü ah ayia amala ngü fü wü di enga me la kpekpeke, gü ba, “Wü ce engu ace!” Fü wü di enga me ayia ace mbarase la. Fü mbarase la ayia aküwa. Fü Yesu aza engu, ato fü wö ye. ");
INSERT INTO muh_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Fü komö wü kpara la agu ꞌburu agu, ga, “Ani wu mere wazi ka Me enatikine eyi!” ");
INSERT INTO muh_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Baka te mere bi wü kpara la ngbü la fï bü emala nga ngü la esüka wü, fü Yesu afü te-ye, amala ngü fü wü kpara ka-ye, gü ba, “Ngü de te ma emala fü yi dene, ah le de ngü la rï gbü nzö yi mbi mbi mbi. Angü wüh ena ato ra fü wü vügü ka-ra, fü ewü amörö ra.” ");
INSERT INTO muh_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amba ngü de te Yesu mala fü ewü la, wüh wu si-ngü gbügbü na nda-wü de, angü si-ngü la wo te-ye ka-ye fü ewü awo. Wüh le ta de ani yi-ta Yesu teka si-ngü la. Wüh du yi-tata na nda-wü de, ka lümü. ");
INSERT INTO muh_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Fütanga ngü la, fü wü *kpara ka Yesu, akpo da ega yïkï esüka wü, gü ba, “Kpara te ena angbü mere kpara esüka ani fütanga Yesu neh da?” ");
INSERT INTO muh_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Te Yesu wu fïngangü ka-ewü bala, fü ah ayia aza mbarase cüküꞌdaye, ao ede ye. ");
INSERT INTO muh_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Fü ah amala ngü fü ewü, gü ba, “Mene kpara te ena ao ngü ka-ye kötö, baka jaji la, ah ena adi ka-ye me-ye de mere kpara gbü jia Me. Mene kpara te ena aza mbarase baka engu ne gbü mürü, te ïrï ra la, ah le ka-ye dela cu ra. Kpah bala, te mü le ra eyi la, amba mü le Wüba Me, te tima ra ne, kpah eyi.” ");
INSERT INTO muh_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Fütanga ngü la, fü *Yüwane ayia amala ngü fü Yesu, gü ba, “Mere kpara, ani maka gara komoko kpane, te ngbü eliki wü di enga me guvu wü kpara te ïrï ye. Te ani wu ngü la, fü ani atata engu, de ah ce ngü la asidi, angü engu de kpara esüka ani nda de.” ");
INSERT INTO muh_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Te Yesu je ngü la bala, fü ah alügü ngü fü Yüwane, gü ba, “Yi mere e atata engu de, angü mene kpara te gü gü de wü nih de, ah ngbü dela ele ta-ngü te nih.” ");
INSERT INTO muh_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Fütanga ngü la, baka te sïkpï ka Yesu koro tete gbamari, teka ago agbü kpï, fü Yesu ayia areke te-ye, teka anü agbü Yerüsalema. ");
INSERT INTO muh_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Fü ah ayia atima wü gara kpara ka-ye engagira nü, teka areke sü fü wü gbü gara kötï biringbö, gbü tö ka *Samarïya. Fü wü Yesu adu ayia de wü gara kpara ka-ye, tïne fütanga ewü. ");
INSERT INTO muh_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Te wü kpara gbü kötï engu la wu, gü ba, wü Yesu te enü agbü Yerüsalema, fü ngü la asiti te ewü. Te di bala, wüh le de Yesu ra gba ani sela de. ");
INSERT INTO muh_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Te wü *Yakobo ake *Yüwane wu ngü la bala, fü ngü la ake te ewü, fü maguma ewü ayia anzu. Fü ewü amala ngü fü Yesu, gü ba, “Mere kpara, ah le de nih ku gba fü Me, de ah tima wa, teka acuru wü kpara la!” ");
INSERT INTO muh_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Te Yesu je ngü la bala, fü ah afü te-ye, amala ngü fü ewü kpekpeke, gü ba, “Yi ce ngü la, angü dela fïngangü ka *Satana. Yi wu bala de? De-ra, *Ye kpara ka Kpï, ma koro füh kotö ne teka amörö kpara nda-ra de, amba ma koro teka aküwa ewü.” ");
INSERT INTO muh_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Fütanga ngü la, fü ewü ale kaje ka-wü, anü sü, ara agbü gara kötï. ");
INSERT INTO muh_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Te wü Yesu ngbü enü tete te kaje ka Yerüsalema la, fü gara kpara ayia akoro kpaka Yesu, amala ngü fefe, gü ba, “Ni ele afa nga ye, gbü wü sü ꞌburu, te ye ena angbü enü tete. Ni ena alala fï gbü nga ye, ni tï ace nga ye de.” ");
INSERT INTO muh_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Fü Yesu alügü ngü fü komoko la, gü ba, “Ah le de mü wu awu, gü ba, te mü le afa nga ra la, züka ngü te mü ena amaka füh kotö ne nda ma. Angü de-ra, *Ye Kpara ka Kpï, sü fere füh kotö ne, teka ara, afe te-ra tete, nda ma. Angü wü zaza ngbü era nda-wü gbü wü gö ka-wü. Wü lu ngbü era nda-wü kpah gbü wü suta ka-wü. Amba nda-ra, sü fere bala nda ma.” Te komoko la je ngü la bala, fü ah adu ace da efa nga Yesu. ");
INSERT INTO muh_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Gbü gara sïkpï, fü Yesu amala ngü fü gara kpara, gü ba, “Mü lala gbü nga ra.” Fü kpara la alügü ngü fefe, gü ba, “Mere kpara, ni le eyi. Amba wö ni gbe eyi. Ni le adu acï nganga. Te ah kpi eyi la, fü ni ati engu feke, fü ni adu akoro afa nga ye sidi.” ");
INSERT INTO muh_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu gü ba, “De-mü, mü nü, mü mala ngari Me fü wü kpara. Mü ce wü di enga ni mü, te ewü le ngü ka-ra de ne, de wüh ti wö mü me-wü, angü wüh ka-wü kpah eyi baka kövö la.” ");
INSERT INTO muh_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Gbü gara sïkpï, fü gara kpara amala kpah ngü bala fü Yesu, gü ba, “Mere kpara, ni le eyi afa nga ye. Amba ah le de ni nü la kpa ekötï, asere ngü la fü wü di enga ni ni feke. Ye cï nga ni. Ni ena adu akoro.” ");
INSERT INTO muh_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Yesu je ngü la bala, fü ah amala ngü fefe, gü ba, “Te maguma mü ꞌbasu ꞌbasu la, mü tï ara fü Me, amere tima kaka mbi mbi de.” ");
INSERT INTO muh_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Fütanga ngü la, fü Miri Yesu ayia afe kpah gara wü kpara ka-ye teke bata nzükpa de füh ye ꞌbasu (72) ne, teka atima ewü ꞌbasu ꞌbasu kpa engagira nü, gbü wü sü ꞌburu te engu ele anü tete. ");
INSERT INTO muh_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Fü ah amala ngü fü ewü, gü ba, “Bi wü kpara ladü, te ewü di eyi nzo teka ato maguma wü fere. Amba wü kpara te ewü ena amala ngü ka-ra fü ewü, wüh ka-wü mba nzoko. Ah baka yï te di memere fa sü, amba wü kpara, te ewü ena amere tima gbü yï la, wüh be nda-wü de. Te di bala, ah le de yi yi-ta Me, te di de mere mürü tima la, de ah tima wü gara kpara, teka ale ta-ngü te yi gbü tima la. ");
INSERT INTO muh_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","4","Yi nü enü! Yi mere e aza mere bi wü e esaka yi de. Yi mere e aza jiase de, yi za kombo kpah de, yi za gara kamaka fü yi kpah de. Yi mere e angbü erürü te kaje, da egü mandï fü wü kpara ꞌdaaa de. Te di bala, yi ceka ꞌbe, angü ma tima yi dene baka wü kambiliki esüka wü siti kpara, te ewü di baka siti wü nü. ");
INSERT INTO muh_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Te yi koro gbü gara kötï, gina ngü te yi ena amala fü ewü, yi ena ato mandï fü ewü, gü ba, ‘Me di de yi, gbü kötï ne.’ ");
INSERT INTO muh_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Te mürü kötï la de züka kpara, de lele ka Me emaguma ye la, mandï ka-yi, de te yi to de gu ngü ka Me gbü ye ne, ah ena angbü fefe na. Amba te mürü kötï la le ngü ka-yi de, züka gu ngü ka Me, te yi to fü ewü ne, tï angbü gbü kötï la nda de. ");
INSERT INTO muh_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gbü mene kötï, de te wüh ena ale ngü ka-yi, yi ngbü duu sela, yi zü wü e ꞌburu, de te wüh ena angbü eto fü yi ne. Anga te ah de e-manzö, baka ngu, yi mere e ace de, angü ah le fü kpara te ngbü emere tima ne, amaka na tima ka-ye. Yi mere e angbü endoro, da era gba wü kpara fa fa fa, da egïrï wü züka ngü, ne de. ");
INSERT INTO muh_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gbü wü sü ꞌburu, de te yi ena akoro gbügbü, te wüh le ngü ka-yi la, yi ngbü sela. Wü e ꞌburu, de te wüh ena ato fü yi ne, yi zü azü. Yi mere e ace de. ");
INSERT INTO muh_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Te yi maka wü mürü keke gbü wü sü la, de yi küwa ewü aküwa. De yi mala kpah fü wü kpara ꞌburu gü ba, ‘Wü fü maguma wü efü, angü Miri, te Me tima teka aküwa ani ne, koro eyi.’ ");
INSERT INTO muh_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Amba te yi nü koro gbü wü gara sü, te wü kpara le ngü ka-yi de la, yi mere e angbü sela de. Yi yia sela asidi, de yi furu zu-tö gba ewü la esatïlö yi asidi, de yi mala fü ewü, gü ba, ‘Ani mere ngü la kükürü de, angü ani mere bala teka ace kïna ka Me gbü nzö wü. Amba ah le fü wü awu, gü ba, Miri, te Me tima teka aküwa ani ne, koro eyi.’ ” ");
INSERT INTO muh_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Fütanga ngü la, fü Yesu amala fü ewü, gü ba, “Ngü te ma emala fü yi dene, ah zu de kpeke ngü. Gbü sïkpï te Me ena akolo ngü ka wü kpara, ah ena ato mere kuru te wü kpara gbü sü la, afa nda siti wü kpara ka *Sodomo ta gügü ne afa.” ");
INSERT INTO muh_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Fü Yesu adu amala gara ngü, teka wü kpara gbü wü kötï, te engu ngbü emere tima ka-ye gbügbü ne, gü ba, “De-yi wü kpara ka Korazïna, de wü kpara ka Betesayïda, Me ena ato mere kuru te yi te gara, angü yi le ngü ka-ra de. Angü wü mere kpeke ngü, de te ma ngbü emere gbü wü sü ka-yi ne, te ma ena angbü emere ta bala fü wü *ganzi kpara, baka wü kpara ka Tera ake Sïdona la, de bane wüh ngbü ta eyi de mere cïnga te-wü, teka *siti ngü ka-wü, da eto kala bongo eküte wü, eza kpah mbï abu gbü nzö wü, da endaꞌba te-wü fü Me, agü ba, ‘Ani le eyi afü maguma ani!’ ");
INSERT INTO muh_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Teka ngü la, gbü sïkpï te Me ena akolo ngü ka wü kpara, ah ena ato mere kuru te yi, wü kpara ka Korazïna ake Betesayïda, afa nda wü kpara ka Tera bete Sïdona ka. ");
INSERT INTO muh_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kpah bala, de-yi, wü kpara ka Kaparanama, yi fï nda-yi, gü ba, ngü ka-ani ena areke gbü jia Me, fü ani akoro agbü kpï? Aꞌa! Ah bala de! Ngü ka-yi ena asiti gbü jia Me asiti, fü yi anü agbü du ka wa, angü yi le ngü ka-ra de.” ");
INSERT INTO muh_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Fütanga ngü la, fü Yesu adu amala ngü fü wü kpara ka-ye, te engu yia etima ewü la, gü ba, “Kpara te ena aje ri yi, engu ngbü dela eje ri ra. Mene kpara te je ri yi de, ah je ri ra kpah de. Kpah bala, kpara te je ri ra de, ah je ri Me te tima ra ne, kpah de.” Dela ngü te Yesu mala fü wü kpara ka-ye teke bata nzükpa de füh ye ꞌbasu (72), te engu tima ewü ne. Fü ewü ayia anü amere tima, kpah baka e te Yesu mala fü ewü la. ");
INSERT INTO muh_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Te wü *kpara ka Yesu teke bata nzükpa de füh ye ꞌbasu (72) ne mere tima ka-wü nza tete, fü ewü adu akoro kpaka Yesu. Fü ewü angbü de mere tadu, da emala nga ngü la fefe, gü ba, “Wayi bala, mere kpara, baka e te ani nü ne, ani ngbü eto rïrï fü *siti wü di enga me te ïrï ye. Fü ewü angbü eje ri ani, da ekpe ani akpe!” ");
INSERT INTO muh_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Fü Yesu amala ngü fü ewü, gü ba, “Ngü la mere te-ye kükürü de, angü Me sö *Satana eyi kpa kötö. Fü ra awu engu te ngbü eyere, etï baka ülele ka mügbara, angü Me nza wawazi eyi. ");
INSERT INTO muh_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yi je la ngü de te ma emala fü yi ne. Ma to wazi eyi fü yi, teka amere gü de wü siti wü di enga me, te ewü di de vügü ka-nih ne, da eza esaka ewü. Te di bala, yi tï eyi adoto wü kpürü, de wü etünü gbü lö yi. Gara siti ngü biringbö tï amere yi kpo de. ");
INSERT INTO muh_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yi ngbü de tadu, teka ngü ka wü di enga me, de te ewü ngbü eje rïrï ka-yi ne? Wayi, ah mbi, amba ah le fü yi angbü de mere tadu, angü wüh ba ïrï yi eyi gbü buku ka *küküwa agbü kpï.” ");
INSERT INTO muh_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Fütanga ngü la, fü Yesu ayia angbü de mere tadu emaguma ye, teka ngü te Me mere fü wü kpara ka-ye, te wü bu ewü ngbü eceka ewü baka töndö kpara ne. Fü ah akpo da egbo nga ïrï Me gbü wazi ka *Nzïla Wazi Me, gü ba, “Wayi, Wüba Me, mü de Miri agbü kpï, mü kpah de Miri füh kotö ne, gbü nzö wü kpara ꞌburu. Ma ngbü egbo nga ïrï mü, angü mü wo ngü ka-mü te wü e-wu-ngü, de angbe cögbörö wü kpara ꞌburu, awo. Fü mü adu agü tamu ngü la fü töndö wü kpara, te ewü di ka-wü baka wü jaji ne. Ah fanü Wüba, ngü engu ka-ye bala, angü mü le ngü la me-mü, de ah mere te-ye bala. ");
INSERT INTO muh_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wüba, mü ce wü ngü eyi ꞌburu esaka ra. Kpara biringbö te wu ngü ka-ra mbi mbi mbi nda ma, ꞌduwa de-mü Wüba, mü wu ngü ka-ra ka-mü me-mü. Kpah bala, kpara biringbö, te wu ngü ka-mü, Wüba, nda ma. Ma wu ngü ka-mü duu me-ra, de wü kpara te ma gü tamu ngü ka-mü fü ewü ne.” ");
INSERT INTO muh_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Fütanga ngü la, fü Yesu adu afü te-ye kpaka wü kpara ka-ye, amala ngü bü nzö fü ewü, gü ba, “Me mere züka ngü eyi fü yi, angü yi ngbü eceka wü ngü, de te ma ngbü emere ne, cu de jia yi! ");
INSERT INTO muh_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Angü ta gügü wü *mürü dofo, de wü miri, de wü diri kpara ka Me ꞌburu, ngbü ta eo gümü ra, de ani wu ra cu de jia ani, baka te yi ngbü ewu dene, amba wüh wu ra nda-wü de. Wüh le ta de ani di eje ngü, te ma ngbü emala ne, baka te yi ngbü eje de güje yi dene, amba wüh je nda-wü kpah de.” Dela ngü ta te Yesu mala fü wü kpara ka-ye teke bata nzükpa de füh ye ꞌbasu (72) ne, gbü sïkpï, te ewü du koro kpakaka na, fütanga tima, de te engu tima ewü di ne. ");
INSERT INTO muh_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Fütanga ngü la, fü gara *mürü rïrï biringbö ayia akoro kpaka Yesu, teka are mamaguma gbü mani. Fü ah ayi-ta Yesu, gü ba, “Mere kpara, ni ena amere neh baye, teka fü ni aküwa, angbü gbü sü ka Me, fï mere badi?” ");
INSERT INTO muh_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu gü ba, “Gbü *Rïrï ka Me te engu to fü nih ne, wüh ba teka ngü la, gü neh fe?” ");
INSERT INTO muh_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Fü mürü rïrï la, alügü ngü, gü ba, “Ma je ngü gbü Rïrï la, gü ba, ‘Mü le Mere Me de maguma mü biringbö, mü o fïngangü ka-mü kpah ꞌburu tete, mü le ngü kaka de wazi mü kpah ꞌburu, mü to te-mü kpah ꞌburu fefe. De mü le wü bu mü kpah baka e te mü ngbü ele küte mü.’ ” ");
INSERT INTO muh_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Fü Yesu alügü ngü fefe, gü ba, “Züka ngü, mü mala ngü la eyi reke areke. Ah le de mü mere bala, teka fü mü aküwa.” ");
INSERT INTO muh_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Fü mürü rïrï la adu afï ngü emaguma ye, gü ba, “Te ni le ngü la ꞌduwa ale la, wü kpara ena afï, gü ba, Yesu za ngü gömö ni eyi.” Fü ah adu kpah ayi-ta Yesu, gü ba, “Mene wü bu ni, te ni ena ale ewü ne, neh mene ewü deyï?” ");
INSERT INTO muh_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Fü Yesu adu amala ngü fefe gbü mani, gü ba, “Ta gbü biri ra, gara komoko yia ta agbü Yerüsalema, teka anü agbü Yeriko. Te engu nü koro kpa etüngba kpala, fü ah anü amaka te-ye de wü siti kpara, te ewü ngbü efete wü kpara. Fü wü kpara la azoro engu, amï, agbo kötö, agbene wü bongo kaka ꞌburu, aza wü jiase kaka, akpe ka-wü, atafa, ace engu gbülüküsü kötö sela. ");
INSERT INTO muh_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Fütanga ngü la mba cüküꞌdaye, fü gara *kovo ka Me angbü enü kpah bü te kaje engu la. Fü engu anü akoro, gbo! te komoko la kötö! Fü cürü arï tete, fü ah ade sü ka-ye edere sü, anye sü. ");
INSERT INTO muh_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sidi nga kovo la, fü gara kpara gbü nguwa *Levi, te ewü ngbü emere tima kpa esambü ka Me, ayia kpah akoro te sü te ewü mï komoko la tete. Fü ah aka te-ye, akoro gbamari, aceka komoko la bala, akolo sü ka-ye kpah kpa edere sü, atafa. ");
INSERT INTO muh_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Fütanga enga Levi la, fü gara komoko angbü kpah efü te kaje la. Ah ka-ye de *ganzi kpara, enga *Samarïya. Te enga Samarïya la wu komoko la bala, fü cïnga komoko la arï tete afa sü. ");
INSERT INTO muh_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Fü ah aka te-ye, akoro gbamari kpakaka na. Fü ah ae engu tikpi, aza rü te wüh mere de ngu *vinü, azürü wü ka de eküküte la di, aꞌbüra de mü, ai de züka bongo. Fü ah ae engu, ao füh nü ka-ye, de te engu ngbü endoro di ne, abï engu, anü di agbü kambü ka wü ngba. Fü ah ale ta-ngü tete kpala areke areke. ");
INSERT INTO muh_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Baka egambi la, fü ah aza jiase, ato fü mere kpara ka tima ka kambü ka wü ngba la, amala ngü fefe, gü ba, ‘Ni ce komoko ne eyi esaka ye, de ye le ta-ngü tete na mbi mbi mbi. Te jiase la be de, de ye za jiase ka-ye, ye se wü e tüngüngü na di. Ni ena adu akoro, alügü na jiase ka-ye la ꞌburu da ye.’ ” ");
INSERT INTO muh_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Dela ngü ta te Yesu mala fü *mürü rïrï la. Fü ah adu ayi-tata na, gü ba, “Esüka wü kpara ta de bata la, kpara te mere züka ngü neh da?” ");
INSERT INTO muh_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Fü mürü rïrï la alügü ngü, gü ba, “Ah de mene kpara, de te le ta-ngü te komoko la.” Fü Yesu adu amala ngü fefe, gü ba, “Wayi, ah ngbürü baka te mü mala la. Mü nü enü, de mü mere züka ngü fü wü bu mü kpah bala.” ");
INSERT INTO muh_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Baka te wü Yesu ngbü la fï bü enü tete agbü Yerüsalema, fü ewü anü akoro agbü Betanïya. Fü gara würüse de ïrï ye Marata ayia aza ewü agba ye, baka wü ngba ka-ye. ");
INSERT INTO muh_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Gara enga ni ye Marata ta ladü de ïrï ye *Marïya. Te wü Yesu koro ngbü kötö, fü Marïya akoro angbü kötö eri lö Yesu, teka aje ngari Me gögömö na. ");
INSERT INTO muh_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Fü maguma Marata angbü enzu te Marïya, teka bi wü tima, te engu ngbü emere zü-e fü wü Yesu ne. Angü Marïya ce ta engu gbü tima la kpikpi ye. Fü Marata akoro kpaka Yesu, amala ngü fefe, gü ba, “Mere kpara, ngü la gbü jia ye neh baye, te enga ni ni, Marïya, ce ni, embü de tima kpikpi ni de bane ne? Ye mala fefe, de ah koro, ah le ta-ngü te ni ke!” ");
INSERT INTO muh_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Fü Yesu alügü ngü fefe, gü ba, “Apaa, Marata, mü ngbü engbü de mere fïngangü ne bü teka mere bi wü tima te mü ngbü emere ne? Ah le bala de. Ah le de mü o fïngangü ka-mü biringbö teka ngü ka Me. ");
INSERT INTO muh_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ngü de te enga ni mü, Marïya fe, teka angbü eje ri ra ne, ah de züka ngü te reke fa sü. Wüh tï aza ngü la esasaka na asidi de.” Dela ngü te Yesu mala fü Marata teka ngü ka maje ngari Me. ");
INSERT INTO muh_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gbü gara sïkpï biringbö, Yesu ngbü ta eku gba fü Me gbü gara sü. Te engu ku gba fü Me nza tete, fü gara kpara biringbö esüka wü kpara kaka-na, ayi-tata, gü ba, “Mere kpara, ye gü tamu maku gba fü Me fü ani, kpah baka nda *Yüwane Mürü Babatïza, ta te engu gü tatamu fü wü kpara ka-ye ne ke.” ");
INSERT INTO muh_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Fü Yesu amala fü ewü, gü ba, “Te yi ngbü eku gba fü Me la, yi di emala fefe, gü ba, Wayi bala Wö a Me agbü kpï! Ah le fü wü kpara ꞌburu agbo nga ïrï mü, angü mü de Me biringbö. Mü de Mere Miri. Mü koro, mü ngbü gbü nzö wü kpara füh kotö ne, baka e te mü ngbü engbü agbü kpï. ");
INSERT INTO muh_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","De mü to zü-e fü a gbü wü sïkpï biri biri ꞌburu. ");
INSERT INTO muh_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mü boro wü *siti ngü ka-a emaguma mü asidi, angü a ngbü kpah eboro siti ngü ka wü kpara, de te ewü ngbü emere fü a ne. De mü ce a, fü a atï gbü re-ngü ka *Satana, de, angü a ena adürü.” Dela gba te Yesu gü tatamu fü wü kpara ka-ye, de wüh di eku bala fü Me. ");
INSERT INTO muh_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Fütanga ngü la, fü Yesu adu kpah amala ngü fü ewü, gü ba, “Te ngü fa mü, fü mü anü kpaka gara kiri mü gbü biti, ayi-tata, gü ba, ‘De-ye deyï, gara enga ni ni koro eyi, gbü