﻿USE sofia;
DROP TABLE IF EXISTS sofia.mti_vpl;
CREATE TABLE mti_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mti_vpl WRITE;
INSERT INTO mti_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1"," Ebraam usiwa, Devid usiwa Iesu Keriso, Iesu Keriso isimurawaiwa mu yaiyawa tenewa: ");
INSERT INTO mti_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ebraam me Aisak baraune, Aisak me Jekob baraune, Jekob me Juda ge me tatawaiwa teyamne, ");
INSERT INTO mti_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda me Tama gumbe Peres ge Seira teyamne, Peres me Esuron baraune, Esuron me Ram baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram me Aminadab baraune, Aminadab me Nason baraune, Nason me Sarumon baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sarumon me Reab gumbe Boas baraune, Boas me Ruti gumbe Obed baraune, Obed me Jesi baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi me kin Devid baraune, Devid me Urayas biviwa gumbe Soromon baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromon me Reoboam baraune, Reoboam me Abaija baraune, Abaija me Eisa baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Eisa me Josiyapat baraune, Josiyapat me Jeoram baraune, Jeoram me Ujaiya baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujaiya me Jotam baraune, Jotam me Eias baraune, Eias me Ejekaiya baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ejekaiya me Manase baraune, Manase me Amon baraune, Amon me Josaiya baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","me kumiwa Babiron amog wakeya, Josaiya me Jekonaiya ge tatawaiwa teyamne. ");
INSERT INTO mti_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Namu Babiron amog wakeya, ivi Jekonaiya me Searutieru baraune, Searutieru me Jerubaberu baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jerubaberu me Abaiud baraune, Abaiud me Eraiyakim baraune, Eraiyakim me Eijo baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eijo me Jeidok baraune, Jeidok me Eikim baraune, Eikim me Eraiud baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eraiud me Erieija baraune, Erieija me Matan baraune, Matan me Jekob baraune, ");
INSERT INTO mti_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","sira Jekob me Meri memawa Josep baraune, Iesu mu waya Keriso me Meri gumbe yaine. ");
INSERT INTO mti_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Meoya Ebraam gumbe onke Devid gumbe uwanewa, mu kum muma kumiwa undag 14. Devid gumbe onke Babiron amog wakeyawa kumiwa uwane, mu kum muma kumiwa undag 14. Sira Babiron amog wakeyawa kumiwa onke Keriso gumbe uwanewa, mu kum muma kumiwa undag 14. ");
INSERT INTO mti_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mame me Iesu Keriso aninin yaig onnewa. Me inawa Meri Josep gaibu yapapara aya, sira mu memgebip oya amareme kumiwa apa, Guwawa Iyakaisiyapama gumbe me bugane. ");
INSERT INTO mti_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Megara Josep taibe me kwetan den anone, kuiyawa me apan da oraimina, meoya me imidanave me guwave kwepe aipe. ");
INSERT INTO mti_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Megara Josep mameib yaug anoiviwa, Ayapan aneya meuma uyavi gumbe uwag dig wane, Josep, Devid usiwa, Meri biyugwa aug gwe aga a den a, kuiyawa me kikiyan gumbewa Guwawa Iyakaisiyapama gumbe wanedne. ");
INSERT INTO mti_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Me urapan yaipe, sira ge iviwa ug Iesu yua, kuiyawa me iyayapan meuma kukaeba emewa waita mumpe. ");
INSERT INTO mti_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Watavit propeta gumbe Ayapan dig wanewa natawa veniyatan oya, mame dividivi undag veniyane. ");
INSERT INTO mti_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yauya, otau inipama kikiyan gumbe wakepe, sira urapan yaipe, sira mu iviwa ug me Emanueru yupe. (Me natawa God nu gunup.) ");
INSERT INTO mti_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep kub gumbe wan yoine, sira Ayapan aneya meuma aninin wanewa me ane, sira biviwa aune. ");
INSERT INTO mti_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Megara me gaibu den nag vinne, namu me urapan kikiyan baraune, sira me iviwa ug yune Iesu. ");
INSERT INTO mti_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu Betureem at Judia danave yainewa kumive, kin Erod kumiwa apa, ano koukawa igiyawa kum dauwaiviwa apa onam at Jerusarem uwaya, ");
INSERT INTO mti_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sira waya, Ud me Ju igiyawa kin muma atan oya yainewa ampa wakene? Kum dauwaiviwa apa nu marantun meuma yautu, meoya nu waddega wantan oya onantu. ");
INSERT INTO mti_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kin Erod mame anonewa, me anogugut aune, sira Jerusarem igiyawa mu gaibu anogugut auya. ");
INSERT INTO mti_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Sira me pirisi koukawa ge Gwangwan toewanewan igiyawa undag munan auwane, meve dirum wane Keriso ampa yaine wag didnegiya? ");
INSERT INTO mti_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Betureem at Judia apa garawa waya, Kuiyawa mame propeta wait tenewa: ");
INSERT INTO mti_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ge Betureem, at piyu Juda apa, Juda namuyoiyoi igiyawa danowo ge kusikarenwa da onan di: kuiyawa namuyoiyoi abnawa ye guniyap uwape, sira me iyayapan neuma Isuraeru amat a mumpe. ");
INSERT INTO mti_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Meve kin Erod ano koukawa igiyawa munan guwave auwane, sira mu gumbo kum divi marantun me dauwane yaug anone. ");
INSERT INTO mti_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Me mu temunne at Betureem amiya. Me mu gumbo wane, Aisiya sira ud kikiyan oya yaimoyai diuya. Me yauyawa, tatevit didnegiya anotna, meve ne gaibu aneg me waddega wantna. ");
INSERT INTO mti_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Namu mu kin aninin wanewa anog amiya, yauya, mu marantun me kum dauwaiviwa apa yauyawa namuwon aiginke, at me ud kikiyan wakenewa apa tumag yoine. ");
INSERT INTO mti_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mu marantun yauyawa, mu degadega kokavit aya. ");
INSERT INTO mti_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Gwe dana unig amiyawa, mu kikiyan inawa Meri gaibu yawamiya. Sira mu me kwanowa poyag petat ag waddega aya. Meve mu dividivi oraimumu mumawa watapiya, sira mu puyo waniya: gooru ge tayawa oraiminawa ge gegura maaru. ");
INSERT INTO mti_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","God uyavi gumbe dirum wane kin Erod gumbe den taig aisiya, meve at muma sira taig ebu ube amiya. ");
INSERT INTO mti_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Mu taig amiyawa, yauya, Ayapan aneya meuma uyavi gumbe uwag Josep dine, Wan yoiya, arampuna ud ge inawa tama, sira yankwek at Ejipt a guwave aisiya, sira asime wakeya meve ne watna anoa, kuiyawa kin Erod ud yaug aug toinguttan oya aivi. ");
INSERT INTO mti_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Meve me wan yoig ud ge inawa arampuna tam a guwave at Ejipt amiya, ");
INSERT INTO mti_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","sira asimeve wakeya, meve kin Erod boane. Meoya propeta gumbe Ayapan wanewa natawa uwane. Ejipt apa ne utunwa auwana dauwag onne. ");
INSERT INTO mti_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kin Erod yaug anone ano koukawa igiyawa ugai waniya, meoya danawa piriwane, sira me dirumne urapan at Betureem apa wakeyawa undag gutpe, sira gwetoimu megiyave wakeyawa gaibu undag gutpe. Mu bairawan muma duwam ge ankwatavewa. Me bairawan me ano koukawa igiyawa gumbo yaug anone. ");
INSERT INTO mti_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Me apa propeta Jeremaiya gumbe wanewa natawa uwane: ");
INSERT INTO mti_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","At Rama apa iyayapan nouwa anoya, it aen, Reiseru me usitainawa munan iruwaivi, me watmemeyamtanwa topayane, kuiyawa mu den wakeya. ");
INSERT INTO mti_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kin Erod boane, meve Ayapan aneya meuma uyavi danave Ejipt apa Josep uwag wane, ");
INSERT INTO mti_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wan yoiya, ud ge inawa tam at piyu Isuraeru aisiya, kuiyawa iyayapan mu ud inaiinai meuma autan ayawa wait boriruwaya. ");
INSERT INTO mti_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Meve me wan yoig, ud ge inawa tam at piyu Isuraeru danave amiya. ");
INSERT INTO mti_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Megara me anone Akeraius me mamawa kin Erod at meuma aune at Judia amaraivi, me asime aitanwa a ane. Uyavi danave God gwangwan dine, meve me at Gariri amiya, ");
INSERT INTO mti_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","sira me gwetoimu me at iviwa Nasaret amog wakeya. Meve propeta gumbe wanewa natawa uwane: Iyayapan me Nasaret apan waya. ");
INSERT INTO mti_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Me kumiwa apa Babataito Abnawa Jon at Judia apa inguiwa arawa danave uwag opata waivi, ");
INSERT INTO mti_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nonemagewa biroriyaya, kuiyawa God toimuwawa koni aivi. ");
INSERT INTO mti_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Apan mame me propeta Aisaya gumbe wanewa: Apan da noiwa at inguiwa arawa danave auwaivi, Ayapan oya ebu waribiya, ebu siwavit menan waribiya. ");
INSERT INTO mti_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon wape meuma mae kameru gumawa gumbe wadne, sira me powawa oya mae kwapiwa berip gaibu. Nakwai meuma me paki ge kemari. ");
INSERT INTO mti_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iyayapan Jerusarem ge Judia undag, sira at Jodan visive undag apa Jon oya amiya. ");
INSERT INTO mti_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mu kukaeba muma boruwawa aya, sira mu yoi Jodan danave Jon gumbe babataito aya. ");
INSERT INTO mti_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Megara me Parisi ge Sadusi igiyawa obiren at meve babataito atan omome yawamne. Me dirum wane, Ye mokare kukaeba usitainawa! Bira wat diruine ye oma ane God danapiri meuma oniviwa me aninin gaveamon? ");
INSERT INTO mti_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nonemagewa biroriyag natawa oraivit inamigimiya. ");
INSERT INTO mti_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ye daneyap den anoya, ye oma ane yembovit waya, Nu mamunwa me Ebraam. Ne diruitna, God oma ane an mame tobiyape Ebraam usitainaven ape. ");
INSERT INTO mti_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gwit yoma taiwa apa wait baraune wakene, sira yoma desirom desirom me natawa oraivit den impewa me kwatpe aikpe, me iyam danave aorepe. ");
INSERT INTO mti_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ne yoi gumbe nonemagewa biroriyatan oya babataito aiyempna. Megara ivi amanap apan da onivi, me yusiwa kokavit ne mina onan. Ne oma den ane sandoro meuma wapukiyag autna. Me Guwawa Iyakaisiyapama ge iyam gumbe babataito aiyempe. ");
INSERT INTO mti_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Me ereri kokawa meuma me nanive, sira me natawa ge kwapiwa kepteivi arawa yug waribiyape. Nakwai wiit agoniyag buim danave tepe, meve nakwai wiit kwapiwa iyam yaibobot danave aorepe itpe onanape. ");
INSERT INTO mti_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Meve Iesu Gariri apa Yoi Jodan onivi Jon oya. Babataito me gumbe awantan oya. ");
INSERT INTO mti_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Megara Jon me yankwetan anog wane, Ne imunap ge gungap babataito atna. Megara ge nenan onagana? ");
INSERT INTO mti_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iesu garawa wane, Gare mame di atna, oraivitwa undag atanwa me nunan oraiwa. Meve Jon bainda wane. ");
INSERT INTO mti_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesu babataito anewa, me tatevit yoi yankweg dauwag aine. Me konive kwimin watabne, sira God Guwawa meuma nenip umuk mina menan aig onivi yaune. ");
INSERT INTO mti_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Sira noiwa kwimin danave uwag wane, Mame ne utunwa me ne nonenwa aunewa, me gumbe ne degadega eni. ");
INSERT INTO mti_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Meve Seitan Iesu amaorot atan oya, Guwawa Iesu dine, meve Iesu at inguiwa arawa danave aine. ");
INSERT INTO mti_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aram 40 ge oiyat 40 danave me nakwai den nane, sira me iyagon adne. ");
INSERT INTO mti_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Amaorot abnawa uwag me digwane, Ge God Usiwa ipewa, an mame diya tobiyape bredi ape. ");
INSERT INTO mti_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Iesu gara wane, Me tene: Iyayapan bredi mekut gumbe den vinigimpe, megara gae undag me God noive uwanewa. ");
INSERT INTO mti_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Meve Seitan at koka iyakaisi me aug aine, sira me dine temporu dewam opampa anewa egave yoine. ");
INSERT INTO mti_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Me wane, Ge God Usiwa ipewa, gembovit pisag aiga. Kuiyawa me tene: Me matai aneya dirumpe ge genan, sira ge amagwa an gumbe den tope mu nanuwo wan augempe. ");
INSERT INTO mti_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Iesu gara wane, Me gaibu tene: Ayapan God geuma den ayag yauya. ");
INSERT INTO mti_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sira Seitan me aug tui kokawa dog aine, sira me toimu koka undag ge dividivi mumawa oraimumuwa toewanne. ");
INSERT INTO mti_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Me wane, Ge nenan kwanagapoe ag nenan waragatan awa, ne mame undag gentna. ");
INSERT INTO mti_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iesu me digwane, Seitan, gunap asipa aga! Kuiyawa me aib tene: Ayapan God geuma waiya, sira me mekut nau meuma a. ");
INSERT INTO mti_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Meve Seitan me kweg aine, sira aneya uwag menan nau wariya. ");
INSERT INTO mti_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iesu Jon nog danave barauya anonewa, me at Gariri taig aine. ");
INSERT INTO mti_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","At Nasaret kweg aine, me at Kapenaum aig vinne. At asime me awau megiyave wakene, sira me at Jeburun ge Naptari danave. ");
INSERT INTO mti_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Me propeta Aisaya gumbe wanewa natawa uwane. ");
INSERT INTO mti_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","At Jeburun ge at Naptari, ebu me awau gumbe, sira me yoi Jodan visi gambenwa apa, at Gariri me Ju onan igiyawa mumawa ");
INSERT INTO mti_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","iyayapan sisip danave wakeemewa eyawa koka mu yauya, bo gugup arawa danave wakeeme igiyawa egowo eyawa dauwane. ");
INSERT INTO mti_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Me kumiwa apa Iesu opata amatog wane, Nonemagewa biroriyaya, kuiyawa God toimuwawa me koni aivi. ");
INSERT INTO mti_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iesu poeman Gariri megiyave aivinewa, me tatagwani duwam yawamne, Saimon me Pita vemewa ge gwaneba Andru. Mu poeman danave uwariri aoreme, kuiyawa mu gwambui upeme igiyawa. ");
INSERT INTO mti_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iesu dirumne, Amanap oneya, wag toyau yentna, ye iyayapan upeme igiyawa aya. ");
INSERT INTO mti_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tatevit uwariri muma yankweg me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","At asime amomewa me upeba tatagwani duwam yawamne, Jebedi usiwa Jemus ge gwaneba Jon. Mu wa danave mamowa Jebedi gaibu. Mu uwariri muma tamibarip eme. Iesu munan auwane, ");
INSERT INTO mti_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","sira mu tatevit wa ge mamowa yankwem me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iesu at Gariri danave at undag aine, sinagogu muma danave toyau munivi. Me God toimuwawa gae oraiwa meuma oya waivi, sira iyayapan yapowo yuwat kusiwa yuwat kokawa gina ubeube undag warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","At Siria undag gae meuma wateteyam aine anoya, sira iyayapan menan yuwat gina ubeube igiyawa undag bog onamiya. Mu dawai kokavit anoemewa, airapu kukaeba danowo unigemewa, warago ayawa, amo nanu gegeraimusiawa, mu gaibu warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iyayapan obiren mu at Gariri ge Dekaporis, Jerusarem, Judia, ge at Jodan ama asi gambenwa uwag Iesu amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesu iyayapan undag yawamnewa, tui gambenwa dog aig yan wakene. Aigowawa me gumbe uwaya, ");
INSERT INTO mti_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","sira amatog toyau munne, wane: ");
INSERT INTO mti_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Guwowa danave pukpuk wagawag igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa kwimin toimuwawa me mumawa. ");
INSERT INTO mti_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Danadawai aueme igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa watmemeyam munigimpe. ");
INSERT INTO mti_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Memeyu igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa piyu kwan meumawa me mumawa. ");
INSERT INTO mti_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Oraivitwa oya iyagon ge meyowa toyaivi igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa mu gumbo matai noidauwape. ");
INSERT INTO mti_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ano nunigimtanwa igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa mu gaibu ano nunigimpe. ");
INSERT INTO mti_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nonowa esine igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa mu God yaupe. ");
INSERT INTO mti_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yum tueme igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa munan wape God usitainawa. ");
INSERT INTO mti_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Oraivitwa oya edawai aueme igiyawa, mu gumbo waribiya wakeigimpe, kuiyawa kwimin toimuwawa me mumawa. ");
INSERT INTO mti_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nenan oya Iyayapan ye anokukam yempewa, edawai yempewa, sira uga gumbe dividivi gae kukaeba yempewa, ye guniyap waribiya wakeigimpe! ");
INSERT INTO mti_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Me kumive degadega ag tare wariya, kuiyawa kwimin danave garawa yeuma me kokavit: ebu desiroma gumbe mu propeta mu ye namuyap uwayawa meib edawai muniya. ");
INSERT INTO mti_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ye piyu siuraneba. Megara siuran demtawa me onanape ipewa, me aninin oma ape sira demta wape? Me dividivi gumbe oraimina onan, sira me aug piyu egave aorepe iyayapan amowo embaba tampe. ");
INSERT INTO mti_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ye piyu eyawa. At toimu me tui kuiyave wakenewa me oma den ane tobotpe. ");
INSERT INTO mti_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyayapan dun oketpe me kabum ankwatave den baraupe. Mu dun yokeiviwa egave yudatpe. Meve me iyayapan undag eyawa mumpe gwe danave. ");
INSERT INTO mti_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ebu desirom gumbe, dun yeuma iyayapan namuwo esipe. Meve mu ye anoano yeuma oraiwa yaupe. Mamewa kwiminau wakenewa me watdega wampe. ");
INSERT INTO mti_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Den anoya ne uwanawa gwangwan ge propeta gaiyawa wag muintan oya, ne uwanawa me natawa matattan oya. ");
INSERT INTO mti_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne natawa diruitna. Kwimin ge piyu den onanapewa, gigirum kusikaren da ge komakom meuma gwangwan danave wakeyawa den di onanape. Dividivi undag natawa veniyape. ");
INSERT INTO mti_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bira da me gwangwan mame danave gwangwan kusikaren da desirom togomiyape, iyayapan upeba epin desiroma toyau mumpewa, mu wape God toimuwawa danave me kusikarenwa. Megara bira da me gwangwan mame amave aigimpe, epin desiroma toyau mumpewa, mu wape God toimuwawa danave me kokawa. ");
INSERT INTO mti_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kuiyawa ne diruina. Parisi igiyawa ge Gwangwan toewanewan igiyawa oraiwa mumawa me koka sira oraiwa yeuma kokavit onanwa, ye oma den ane God toimuwawa unigiya. ");
INSERT INTO mti_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ye anoyana me watavit iyayapan gumbo wane, Den toa boipe, bira da me topewa me pui aupe. ");
INSERT INTO mti_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Megara ne diruitna. Bira da me danapiri tatawa gumbe apewa me pui aupe. Sira bira da me tatawa gumbe warago wapewa, me Daiboru Painauvitwa nanuwo baraupe. Sira bira da Kuiyagwa kukaine wapewa, me at kukaeba geena iyam meuma igiviwa danave aorepe. ");
INSERT INTO mti_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Meoya ge puyo geuma iyakaisi kem meuma apa te atanwa sira ge tatagwa me divi da ge gungap anokukam ane anowawa, ");
INSERT INTO mti_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","puyo geuma iyakaisi kem meuma namive kweya. Namu a tatag gumbe baigan akape, meve onag puyo geuma barauwa. ");
INSERT INTO mti_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ge anavi geuma me ge augem keptete arawa aisenewa, ge ebu taibe tatevit wag yum tuya. Megara ge me gaibu yum den tuiyawa, me augen keptete abnawa nanive baraugempe, sira me augen nog amaraiviwa nanive baraugempe, sira nog gumbe baraugempe. ");
INSERT INTO mti_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne ge natawa diruktna. Ge anmagawa kodorant desirom oieba garawa den barauwawa, me den dauwag aga. ");
INSERT INTO mti_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ye yaug anoyana me wait aib wane, Uinantaraki den aya. ");
INSERT INTO mti_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Megara ne ge diruktna. Bira da vesin yaug ano kukaeba anoiviwa me nonewa wait gaibu vinne. ");
INSERT INTO mti_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ge yangagwa yutan ge gungap ano kukaeba apewa, me watukiyak epa aoreya. Kuiyawa ge kwapugwa da desirom waropiyawa me oraiwa, ge kwapugwa undag at kukaeba geena danave aorepetan. ");
INSERT INTO mti_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Sira nanigwa yutan ge gungap kukaeba apewa, kwagomiyag epa aoreya. Kuiyawa ge kwapugwa da desirom waropiyawa me oraiwa, ge kwapugwa undag at kukaeba geena danave aikpetan. ");
INSERT INTO mti_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Me wane, Bira da vesin meuma kwepe garakue apewa, garakue atan gigirumawa me yug wampe. ");
INSERT INTO mti_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Megara ne dirukna. Bira da biviwa uinantaraki den aivi go ui onan kwepewa me uinantaraki ape. Bira da vesin me wait yankwenewa me aupewa me uinantaraki. ");
INSERT INTO mti_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sira ye anoyana watavit iyayapan dirumwane, Agi geuma den togoma, Ayapan gumbe agi wanawa me a. ");
INSERT INTO mti_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Megara ne diruktna. Agi den waigima, kwimin gumbe agi den waigima, kuiyawa me God wakeiviwa arawa, ");
INSERT INTO mti_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","piyu gumbe agi den waigima, kuiyawa me amawa emnewa, at Jerusarem gumbe agi den waigima, kuiyawa me kin gwetoimu meuma kokawa. ");
INSERT INTO mti_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sira kuiyagap agi den waigima, kuiyawa ge oma den ane kuiyagumawa desirom wara pupuyu go pumpune ape. ");
INSERT INTO mti_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Maib ye waya, Natawa, me Natawa, sira Onan me Onan, gae da imugap sira wawa me kukaeba. ");
INSERT INTO mti_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ye anoyana me wane, Yangawa oya me yangawa, donawa oya me donawa. ");
INSERT INTO mti_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Megara ne diruitna, ano kukaeba abnawa den toa. Bira da ge kwauyegwa gambenwa yutan apa topewa, me sira menan biroriya gambenwa da tope. ");
INSERT INTO mti_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Sira bira da ge augem keptete arawa aisene wape geuma ankwatavewa autan anopewa, me kweya wape geuma egavewa gaibu aupe. ");
INSERT INTO mti_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Bira da ge gungap 1 mirion agetan wapewa, me gaibu 2 mirion aisiya. ");
INSERT INTO mti_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bira da ge gungap nun wapewa me wana, sira bira da divi da gungap aug danam atan wapewa den gumbe topaiya. ");
INSERT INTO mti_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ye anoyana me wane, Baigan geuma evegwa gumbe sira anavi geuma wat topaya. ");
INSERT INTO mti_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Megara ne diruitna. Anavi yeuma baigan muniya, sira nun yeuma waya bira da edawai guniyap apewa. ");
INSERT INTO mti_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Meoya ye Mamewa, kwiminau wakenewa usitainawa mina aya. Me wape kum oraiwa ge kukaeba igiyawa gumbo dauwape ig esipe, sira uvin baraupe aig ompe oraiwa ge kukaeba igiyawa gumbo. ");
INSERT INTO mti_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Bira da ye baigan yeniviwa ye baigan niyayawa, garawa divi aumon? Takesi tameme igiyawa gaibu emewa di? ");
INSERT INTO mti_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Sira ye tateaiw mekut gaun yeuma muniya, me divi da oraimina? Iyayapan undagit emewa di. Ju onan igiyawa gaibu emewa di. ");
INSERT INTO mti_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Meoya oraivitwa aigimiya, kuiyawa Mamewa kwiminauwa me oraivitwa. ");
INSERT INTO mti_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yaukape. Ye iyayapan yaug anotan oya mu namuwo oraivitwa yeumawa den aya. Ye ayawa, garawa da Mamewa kwiminau wakenewa gumbe den auya. ");
INSERT INTO mti_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Meoya ge tawara onan igiyawa munawa, ugauga igiyawa mina namugap den kae trampet upiya. Mu iyayapan ebnotu muma autan oya ebu taibe ge sinagogu danave muneme. Ne natawa diruitna. Mu wait garawa mumawa auya. ");
INSERT INTO mti_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Megara ge tawara onan igiyawa munawa, nanigwa ketaiwa den yaug anope dimbae nanigwa yutanwa aivi. ");
INSERT INTO mti_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tawara onan igiyawa divi muntanwa guwave muna. Meve Mamagwa me divi da guwave egewa yaviviwa, garawa gempe. ");
INSERT INTO mti_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ye nun watanwa, ugauga igiyawa mina den aya. Kuiyawa mu sinagogu danave sira ebu taibe wan yoig nun watan anoeme. Mu imuwo iyayapan yawampe. Ne natawa diruitna, mu garawa mumawa wait auya. ");
INSERT INTO mti_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Megara ge nun watanwa, gwe geuma dana unig ankwin tobora, meve Mamagwa gumbe nun wa. Me guwave wakene sira den yavetewa. Me gumbe nun wa. Meve Mamagwa me divi guwave egewa yaviviwa, me garawa gempe. ");
INSERT INTO mti_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Sira ye nun wayawa, Ju onan igiyawa mina gae egave egave den waya, kuiyawa mu anoeme me God anope nun yobutatae. ");
INSERT INTO mti_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mu mina den aya, kuiyawa Mamewa namu yaug anone ye divi watan ene. ");
INSERT INTO mti_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nun mamaib waya. Mamunwa kwiminauwa, ge ivugwa ayamat aigimpe, ");
INSERT INTO mti_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Toimu geuma uwape, Ge ano geuma kwimin danave aivi mina, piyu egave gaibu ape, ");
INSERT INTO mti_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kum gare evedni nakwai nunigima. ");
INSERT INTO mti_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iyayapan mu kukaeba muma gunup emewa nu anog yankwetu, me mina kukaeba numa anog yankweya. ");
INSERT INTO mti_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Den tam amaorot gumbe tenuna, megara kukaeba gumbe tam waita nuna. ");
INSERT INTO mti_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Iyayapan kukaeba guniyap apewa anog yankweya, ye Mamewa kwiminauwa me gaibu kukaeba yeuma anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kuiyawa ye iyayapan ano muma kukaeba den anog yan kweyawa, Mamewa kukaeba yeuma den anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ge kwit atanwa, ugauga igiyawa mina ge ginangagwa den butuipe. Kuiyawa mu ginungowa butubutui ape iyayapan mu yaug anope mu kwit eme. Ne natawa diruitna. Mu garawa muma wait auya. ");
INSERT INTO mti_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Megara ge kwit atanwa, ge oira kuiyagap wara sira ginangagwa muina. ");
INSERT INTO mti_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kuiyawa kwit egewa iyayapan den yaug anope. Megara Mamagwa den yavetewa me yaug anope sira Mamagwa me yawagivi. Me guwave egewa garawa geuma gempe. ");
INSERT INTO mti_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Piyu egave oraiwa yeuma den teg aigimiya, me apa gwagwap tupe, ni tupe sira kukaipe, sira ub igiyawa toke vig ub ape. ");
INSERT INTO mti_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Megara kwimin danave garawa oraiwa yeuma teg aigimiya, me apa gwagwap den tupe, ni den tupe sira den kukaipe, sira ub igiyawa den toke vig ub ape. ");
INSERT INTO mti_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kuiyawa dividivi oraiminavitwa yeuma wakeyawa arawa, me apa nonewa gaibu wakepe. ");
INSERT INTO mti_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kwapugwa duniwa me yangagwa. Yangagwa oraimina apewa, ge kwapugwa undag eyawa noidauwape. ");
INSERT INTO mti_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Megara ge yangagwa kukaipewa, ge kwapugwa undag sisip noidauwane. Meve eyawa danagap wakenewa me sisip gaibu ipewa, sisip me kokavit aninin! ");
INSERT INTO mti_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Bira da oma den ane apan koka duwam gumbo nau muma ape. Me apan koka da topayape, dawa wat baigan awampe, sira me dawa wan enagatpe, dawa topayape. Ge oma den ane God ge anmagawa nauwawa duwam wara. ");
INSERT INTO mti_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Meoya ne diruitna. Inaiinai yeuma oya nakwai divi nenewa go yoi divi nenewa, danadawai den anoya. Ge kwapuiwa oya ye divi enenewa danadawai den anoya. Inaiinai me kokavit, megara nakwai me koka onan. Kwapuiwa me kokavit, megara enwape mina onan. ");
INSERT INTO mti_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nenip vereg aiviwa yauya; mu nau den vereme sira maura den tameme sira buim danave nakwai den teeme, megara Mamunwa kwiminau nakwai munivi neme. Ye kokavit, nenip mina onan. ");
INSERT INTO mti_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Meoya ne diruitna. Inaiinai yeuma oya nakwai divi nenewa go yoi divi nenewa, danadawai den anoya. Ge kwapuiwa oya ye divi enenewa danadawai den anoya. ");
INSERT INTO mti_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Divi oya ye wape yeuma oya danadawai aumon? Yauya, ben riri wayo arawa apa aninin yoivi? Mu nau den wareme sira yarat den yateme. ");
INSERT INTO mti_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Megara ne diruitna. Soromon me dividivi oraiminawa undag danave wakene, sira wape eniviwa oraimina, megara ben mame oraiminavit di, Soromon wape eniviwa me mina onan. ");
INSERT INTO mti_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wayo piyu ega gare wakene go umae iyam danave aorepe. Megara God me wayo gumbe wape yaimoyai wanne. Meoya anintom God me yenan oya wape tu yempe? Ye anotumat yeuma kusikareren! ");
INSERT INTO mti_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Meoya ye danadawai den avigimiya. Ye vene Nakwai divi nata? go Yoi divi nata? go Divi wape enta? ");
INSERT INTO mti_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kuiyawa dividivi undag mame Ju onan igiyawa botan anoeme, go ye Mamewa kwiminau yaug anone ye divi anoene. ");
INSERT INTO mti_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Meoya, namu me toimuwawa ge ano oraivitwa meuma diuya, dividivi undag mame gaibu ye yempe. ");
INSERT INTO mti_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Meoya danadawai umaewa oya den anoya, kuiyawa danadawai umaewa me umae anope. Kum desirom desirom ibnawa kokavit gaibu wakene. ");
INSERT INTO mti_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Pui den yuwamiya. Pui yuwamiyawa ye gaibu matai pui yuyempe. ");
INSERT INTO mti_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kuiyawa ye iyayapan upeba pui yuwamiyawa, ebu desirom mina ye matai pui yuepe, sira ye om yuyawa, ebu desirom mina me matai om yuepe. ");
INSERT INTO mti_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ge yangut tatag yangawa danave atapupu wakeya yawa. Megara divi oya den yaug anoa yoma yare yangag danave wakene? ");
INSERT INTO mti_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ge aninin tatag dig wamon, ge yangagwa gumbe atapupu atan autna? Yawa, yangagwa danave yoma yare evedni wakene. ");
INSERT INTO mti_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ye ugauga igiyawa. Namu gembo yangagwa yoma yare atan aukape, sira meve ge yaiyai yaukape atapupu tatag yangave atan auwa. ");
INSERT INTO mti_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dividivi iyakaisiyapama kweyau den muniya. Keri yeuma bui namuwo den aoreya. Meib ayawa, mu amo danave em babatam ape, sira matai yenan tobiyak tuiyepe musimusi ape. ");
INSERT INTO mti_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Kinuni aya yempe; didimama aya yauya; ankwin papapak toya yenan watappe. ");
INSERT INTO mti_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kuiyawa bira da kinuni apewa aupe; bira da didimama apewa yaupe; bira da papapak topewa me ankwin watappe. ");
INSERT INTO mti_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ye yapeyap bira me ud meuma bredi oya wapewa, an wampe? ");
INSERT INTO mti_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sira, me gwambui oya wapewa, bira me mokare wampe? ");
INSERT INTO mti_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ye kukaeba igiyawa. Megara ye yaug anoyana aninin garawa oraimumu ud yeuma muniya. Meib ye Mamewa kwiminauwa menan nun wayawa garawa oraimumu kokavit anintom yempe! ");
INSERT INTO mti_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Meoya dividivi undag oya, Ye imuyap iyayapan ye guniyap anopewa meib ye mu gumbo aya. Kuiyawa mame Gwangwan ge Propeta. ");
INSERT INTO mti_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ankwin popotuwa gumbe unigiya. Kuiyawa ankwin teyapama ge ebu teteyaine me ainewa watkukamtan arawa. Iyayapan obiren me gumbe unigeme. ");
INSERT INTO mti_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Megara ankwin kusikaren ge ebu popotu me inaiinai ebuwawa, sira iyayapan aboit onan upeba mukut yaug anoeme. ");
INSERT INTO mti_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yaimoyai yaukapa ugauga propeta gumbo. Mu sip kwapiwa mina enkapa yenan uwape, megara mu inaiinai mumawa mae urup ");
INSERT INTO mti_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ye mu yaug anoya yoma magawa muma gumbe. Iyayapan yoma ganapama gumbe greip tampe, go wayo iviwa sisos gumbe inaru tampe? ");
INSERT INTO mti_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Me mina yoma undag oraimumuwa natawa oraivit impe, megara yoma kukaeba me magawa kukaeba impe. ");
INSERT INTO mti_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yoma oraiwa oma den ane magawa kukaeba den impe, sira yoma kukaeba oma den ane magawa oraiwa impe. ");
INSERT INTO mti_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yoma undag me magawa oraiwa me den impewa, me kwatpe aikpe sira iyam danave aorepe. ");
INSERT INTO mti_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Me mina, ye mu yaug anoya natawa muma gumbe. ");
INSERT INTO mti_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Iyayapan mu nenan, Ayapan, Ayapan, vemewa mu matai undag kwimin toimuwawa den unikpe, megara upeba mukut unikpe. Apan bira ne Maman kwiminauwa anoiviwa aiviwa mekut unikpe. ");
INSERT INTO mti_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Me kumiwa apa, iyayapan obiren nenan wape, Ayapan, Ayapan, nu ivugwa gumbe God gaiyawa keptetu, sira ivugwa gumbe airapu kukaeba atatai imtu, sira irayauyau obiren atu. Ge me yaug anoana. ");
INSERT INTO mti_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Me kumive ne taibe diruitna, Ne den di yauyem anona. Ye kukaeba ene igiyawa. Gunap asipa aisiya. ");
INSERT INTO mti_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Meoya bira da me gae neuma anopewa mu ageyau gumbe baraupewa, me apan kuiya esinewa me gwe meuma bontatan egave sinewa mina. ");
INSERT INTO mti_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Uvin aigne, nin uwane, taig gwe tone ipuniyane, go gwe me den aigne, kuiyawa me irap meuma bontatan egave sine. ");
INSERT INTO mti_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Megara bira da ne gae neuma mame anopewa sira den ageyau gumbe baraupewa me warago apan, me gwe meuma nuge egave sinewa mina. ");
INSERT INTO mti_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uvin aigne, nin uwane, taig gwe tone ipuniyane aigne. Me kokavit biyau aig tog yayane. ");
INSERT INTO mti_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesu gae meuma mame wag dirumne onananewa, iyayapan obiren toyau munnewa anog teraya, ");
INSERT INTO mti_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kuiyawa Iesu me apan da bira yusiwa aunewa mina wag dirumne, Gwangwan toewanewan igiyawa mina onan. ");
INSERT INTO mti_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iesu tui apa aig onnewa, iyayapan obiren amave onamiya. ");
INSERT INTO mti_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Apan me yuwat warumne iviwa reprosi gaibuwa Iesu namive uwag konive yug wane, Ayapan, ge imugap anoigima ipewa, ge oma ane ne warinam nega. ");
INSERT INTO mti_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iesu naniwa baraune apan yumne. Me wane, Ne imunap anoeni. Oraimina a! Tatevit reprosi meuma onanane. ");
INSERT INTO mti_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Meve Iesu me dig wane, Yaukapa. Iyayapan da den diruma. Megara gembovit ag pirisi gumbe toyauwana. Sira Mosisi gwangwan wanewa mina puyo baraug wana me gumbe iyayapan yaug anope ge wait oraimina ana. ");
INSERT INTO mti_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iesu Kapenaum unignewa, senturion uwane me gumbe waita autan oya. ");
INSERT INTO mti_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Me wane, Ayapan, nau neuma abnawa gwe dana vinivi, me naniwa ge amawa buburuimusia sira dawai kokavit warivi. ");
INSERT INTO mti_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iesu me dig wane, Ne aneg me warinampna. ");
INSERT INTO mti_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Senturion garawa wane, Ayapan, ne oraimina onan, meoya oma den ane ge gwanob neuma ankwatave unig onaga. Gae mekut nega. Meve nau neuma abnawa me inaipe. ");
INSERT INTO mti_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kuiyawa ne nembo apan da yusiwa ankwatave wakenawa, sira mut igiyawa ne ankwatanap wakeya. Ne apan mame, Aga, ditnawa me aipe; sira da wa, Onaga, ditnawa me ompe. Ne nau neuma abnawa, Mame a, ditnawa me ape. ");
INSERT INTO mti_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesu mame anonewa, me terane sira amave amomewa igiyawa gumbo wane, Ne natawa diruitna, ne at Isuraeru apa mame mina anotumat kokavit den yauna. ");
INSERT INTO mti_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne yenan veni. Iyayapan obiren kum dauwaiviwa ge kum aigiviwa apa onampe, sira Ebraam, Aisak ge Jekob gaibu kwimin toimuwawa danave buyunai apa wakepe. ");
INSERT INTO mti_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Megara God toimuwawa usitainawa daieve sisip danave emepe asimeve mu it ge donowa kitosai aigimpe. ");
INSERT INTO mti_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Meve Iesu senturion dine, Aga! Ge anotumat ana mina me gumbe ape. Nau meuma abnawa me kumive inaine. ");
INSERT INTO mti_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Meve Iesu Pita gwe meuma uwag gwe danave unigne. Pita nimnagawa vesinwa yuwat amipam aug deriyat egave parau vinivi yaune. ");
INSERT INTO mti_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iesu me naniwa yumne, meve yuwat amipam yankwene. Me wan yoine amatog Iesu amara wanne. ");
INSERT INTO mti_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aram muniwaiviwa, iyayapan airapu kukaeba danowo wakeyawa obiren me gumbe tam uwaya. Iesu me gae meuma gumbe airapu kukaeba tam atatai imne amiya, sira yuwat igiyawa undag inaimusia. ");
INSERT INTO mti_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mame propeta Aisaya me gumbe wanewa natawa uwane: Me danadawai numa aune, sira yuwat numa aug aine. ");
INSERT INTO mti_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu me iyayapan obiren yawamne mu me gumbe birorot aya. Me wag dirumne poeman visi gambenwa dauwag ampe. ");
INSERT INTO mti_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Meve Gwangwan toewanewan abnawa me gumbe uwag dine, Toewanewan, ne ge ampa agawa ne amagap anekna. ");
INSERT INTO mti_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Iesu garawa wane, Mae okusi nog gaibu, sira nenip painauwa enawa gaibu, megara Apan Usiwa kubvintan oya at neuma onan. ");
INSERT INTO mti_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aigowawa desirom da me dine, Ayapan, namu ne kwenega anekna maman neuma sitna. ");
INSERT INTO mti_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Megara Iesu dig wane, Amanap onaga. Bo igiyawa kwema mumbo si ampe. ");
INSERT INTO mti_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iesu wa danave aignewa aigowawa me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yauya! Taig kokawa awau gumbe uwane, yawarat uwag wa tog umne. Megara Iesu kubvinivi. ");
INSERT INTO mti_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aigowawa amog me wagwanamiya, waya, Ayapan, waita nuna! Nu nonun natan aivi! ");
INSERT INTO mti_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Iesu me garawa wane, Ye anotumat yeuma kusikareren, divi oya ye a ene? Meve me wan yoine, taig ge awau dirumne, meve me memeyaig botone. ");
INSERT INTO mti_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Apan undag a aya sira singui garawa aya, Apan mame divi? Taig ge awau noiwa auya. ");
INSERT INTO mti_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Me Gadarin igiyawa arawa me poeman asiwama gambenwa apa uwanewa, apan duwam airapu kukaeba danowo wakeyawa mu babat danave dauwag omog Iesu yauya. Mu iyayapan gureme igiyawa, meoya bira da oma den ane ebu asime aivi. ");
INSERT INTO mti_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","God Usiwa, nu gunup divi amon? mu kwaruwaya. Kum me ge barauwanawa den uwane me matai, megara watkukam nuntan oya ge mapa onagana? ");
INSERT INTO mti_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mu gumbo kusi asinut bui obiren amareme. ");
INSERT INTO mti_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Airapu Iesu gumbe nun waya, Ge taibe tenuna antawa bui obiren danowo unikta. ");
INSERT INTO mti_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Me dirum wane, Aisiya. Mu dauwag amog bui danowo unigiya. Bui obiren undag uyug visive tatevit aigeg awau danave aigiya. Meve yoi danave boriruwaya. ");
INSERT INTO mti_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bui amareme igiyawa a ag kintog amiya. Mu amog toimu danave uwaya. Sira gae mame undag dirumiya. Apan duwam airapu kukaeba danowo wakeyawa gumbe sira dividivi undag gaibu gae waya. ");
INSERT INTO mti_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Meve Iesu yautan oya iyayapan undag toimu danave wakeyawa dauwag uwaya. Mu me yauyawa dig waya me at muma kweg aipe. ");
INSERT INTO mti_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesu wa danave aigne, awau gambenwa dauwag aig at meuma uwane. ");
INSERT INTO mti_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Apan da goma egave parau viniviwa apan upeba aug Iesu oya onamiya. Iesu anotumat muma yaunewa, me apan me amananiwa buburuimusiawa gumbe wane, Ne utunwa yai wakeya; Kukaeba geuma anog yankwene. ");
INSERT INTO mti_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Me kumive, Gwangwan toewanewan igiyawa upeba mumbovit wa ge ano aya, Apan mame God gumbe ae waivi! ");
INSERT INTO mti_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Iesu me anoano muma yaug anog wane, Divi oya ye dividivi kukaeba nonemageyap anoene? ");
INSERT INTO mti_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ambuwa me taibe, Kukaeba geuma anog yankwene, watna, go Wan yoig aga, watna go? ");
INSERT INTO mti_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ne imunap ye yaug anoya. Apan Usiwa me piyu egave yusiwa gaibu, me oma ane kukaeba anog yankwepe. Meve me amananiwa wabuburumnewa abnawa dig wane, Wan yoiya, goma geuma aug gwe aga. ");
INSERT INTO mti_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Meve apan wan yoig gwe meuma aine. ");
INSERT INTO mti_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iyayapan undag mame yauyawa, mu teraya; sira mu God me yusiwa mame apan gumbe wannewa waragasiya. ");
INSERT INTO mti_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iesu asimeve kweg uwag aiviwa, apan da iviwa Matiu me takesi tamivi abnawa gwe kusi apa wakene me yaune. Me dig wane, Amanap onaga, Matiu wan yoig me amave aine. ");
INSERT INTO mti_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Meve Iesu me gweyau augoi nakwaeba naiviwa, yauya, takesi tamemewa ge kukaeba igiyawa obiren uwag Iesu ge me aigowawa gaibu nakwai neme. ");
INSERT INTO mti_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi igiyawa mame yauya, mu aigowawa singui muniya, Divi oya toewanewan yeuma me takesi tamemewa ge kukaeba igiyawa gaibu nakwai nene? ");
INSERT INTO mti_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iesu mame anonewa wane, Iyayapan mu doketa oya anoemewa mu ui kwapuwa oraimumuwa igiyawa onan, mu yuwat igiyawa. ");
INSERT INTO mti_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ne baigan anoeni, go puyo maeba ne topai. Ye aisiya mame natawa yaug anoya: Kuiyawa ne oraimumu igiyawa munan den onedna go kukaeba igiyawa munan aig onedna. ");
INSERT INTO mti_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Meve Jon aigowawa Iesu gumbe uwag me singui aya, Nu ge Parisi igiyawa gaibu kwit ete, megara ge aigo geumawa kwit den aya, me aninin? ");
INSERT INTO mti_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Iesu garawa wane, Memgebip abnawa evebaviwa mu apan memgebip mataiwa gaibu wakeyawa, mu aninin danadawai aug iruwape? Megara kum me uwapewa, memgebip abnawa mu kwem aug aipe; meve mu kwit ape. ");
INSERT INTO mti_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Apan da wape mataiwa kidnausiren waremig wape namuwa gumbe den agempe, me meib apewa, matai wape mataiwa kidnausiren me wape namuwa viviyotpe sira me koka ape. ");
INSERT INTO mti_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Sira iyayapan wain mataiwa mae kwapiwa irutawa ageniyawa namuwa danave den egampe. Kuiyawa mu meib apewa, mae kwapiwa irut ageniyawa matai dumetpe. Wain dauwag areriyape, sira mae kwapiwa gurupot ageniyawa kukaipe. Mu mae kwapiwa gurupot ageniyawa mataiwa danave wain mataiwa areriyape. Nunganwa ge mataiwa duwam oraimina wakepe. ");
INSERT INTO mti_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesu me gae mame waiviwa, sinagogu namuyoiyoi abnawa uwag namive konive yune, me wane, Ne gwaitanwa gare mame di boane. Megara, onaga ge nanigwa me gumbe barauwa, me sira inaipe. ");
INSERT INTO mti_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iesu wan yoig me gaibu amiya, sira aigowawa gaibu amiya. ");
INSERT INTO mti_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yauya, me apa, vesin da me bairawan 12 danave ganigani wariviwa me daieven uwag wape meuma ginawa yumne. ");
INSERT INTO mti_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vesin me membo wane, Ne wape meuma oma ane yumpnawa, ne inaigitna. ");
INSERT INTO mti_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iesu biroriyag vesin me yaune, me wane, Gwaitanwa, yusiyusi a. Anotumat geuma gumbe ge inaigitana. Sira me apa vesin inaine. ");
INSERT INTO mti_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iesu me sinagogu namuyoiyoi abnawa gwe meuma unignewa, me bepuru kae emewa igiyawa ge wayug wayug igiyawa yawamne. ");
INSERT INTO mti_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Me wane, Dauwag asipa aisiya. Otau mame bo den ane, me kubvinivi. Megara mu me gumbe towaya. ");
INSERT INTO mti_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Me iyayapan dirumne daieve amiyawa, me pantut danave unigne otau nanive yumne, meve otau wan yoine. ");
INSERT INTO mti_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gaiyawa mame at ampa ampa undag aine anoya. ");
INSERT INTO mti_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iesu me apa kweg aiviwa, yanga bored duwam mu amave amog kwaruveme, Devid Usiwa, ano nunigima! ");
INSERT INTO mti_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iesu me gwe dana unig ainewa, yanga bored igiyawa me gumbe uwaya. Iesu me singui munne, Ye anotumat ene ne oma ane mame atna? Mu garawa waya, E, Ayapan. ");
INSERT INTO mti_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Meve me yangowa yum wane, Anotumat yeuma enewa gumbe, mame guniyap veniyape. ");
INSERT INTO mti_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Meve mu yangowa oraimina aya. Iesu gwangwan yusipamit dirumne, Gae mame iyayapan den yaug anope. ");
INSERT INTO mti_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Megara mu dauwag amog gae mame at undag barauya aine. ");
INSERT INTO mti_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Me konive mu duwam dauwag amiyawa, yauya, apan da me airapu danave wakenewa sira me oma den ane gae wanewa Iesu menan aug uwaya. ");
INSERT INTO mti_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesu airapu kukaeba atataine dauwag ainewa, apan me noiwa borednewa amatog gae waivi. Iyayapan obiren terag waya, Mame mina at Isuraeru apa da den yautu. ");
INSERT INTO mti_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Megara Parisi igiyawa waya, Me airapu amaraiviwa abnawa dine me airapu kukaeba atatai imne dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iesu toimu kokawa ge gwe gwe undag uwag aine, sira sinagogu muma danave toyau munivi, God toimuwawa gae oraiwa meuma dirumivi, sira yuwat ge kwapiwa ibnawa tamiyawa warinamunivi. ");
INSERT INTO mti_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Meve me iyayapan obiren yawamne, me gumbo danadawai anone. Kuiyawa, mu yutuwa ge waita onan, sip me amaraiviwa abnawa gaibu onan mina. ");
INSERT INTO mti_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Meve me aigowawa dirumne, Maura obiren, go nau atanwa obiren onan. ");
INSERT INTO mti_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Maura Ayapaneba gumbe nun waya, me nau igiyawa tepe maura kumiwa nau meuma danave ampe. ");
INSERT INTO mti_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Me apasoro 12 meuma munan auwane. Me yusiwa meuma munne. Me airapu kukaeba atatai imtan sira yuwat kusi yuwat koka undag warinamuntan oya. ");
INSERT INTO mti_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aigowawa 12 ivuwa mame: Namu, Saimon me waya Pita, sira me gwaneba Andru; Jebedi usiwa Jemus, sira me gwaneba Jon; ");
INSERT INTO mti_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pirip ge Batoromiu; Tomas ge Matiu takesi tamivi abnawa; Arupies usitainawa Jemus ge Tadaiyas; ");
INSERT INTO mti_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Jerot abnawa Saimon sira Isukariot Judas me Iesu gumbe anavi ag omin baraunewa. ");
INSERT INTO mti_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesu aigowawa 12 mame gwangwan wag dirumne tene dauwag amiya: Ju onan igiyawa ebu muma den aisiya, sira Samaria igiyawa gwetoimu dana den unigiya. ");
INSERT INTO mti_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isuraeru gwe muma sip kwawayawa munan aisiya. ");
INSERT INTO mti_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Munan aisiyawa, opata mame waya: Kwimin toimuwawa me koni uwatan aivi. ");
INSERT INTO mti_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Yuwat igiyawa warinamuniya, bo igiyawa waya sira inaipe, sira yuwat warumamne iviwa reprosi tamiya igiyawa waribiyamuniya, sira airapu kukaeba atatai imiya. Ye ingui auyana, meoya ingui muniya. ");
INSERT INTO mti_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","An maga gooru, anmaga siruva go anmaga kopa kokopek berip yeuma danave den aukapa aisiya. ");
INSERT INTO mti_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ebu aisiyawa ikwai, wape egavewa da, sandoro, tutu den aukapa aisiya. Kuiyawa nau eme igiyawa nakwai mumpe nape me oraimina. ");
INSERT INTO mti_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ampa ampa gwe ge toimu kokawa unigiyawa apan da baigan abnawa diuya. Me gweyave wakeigimiya meve me kweya. ");
INSERT INTO mti_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gwe me uwayawa yum baigan yeuma waniya. ");
INSERT INTO mti_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Gwe me oma ape baigan yempewa yum yeuma gwe gumbe wakepe; go, oma den apewa yum yeuma sira taig yenan ompe. ");
INSERT INTO mti_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bira da ye guniyap baigan den yempewa sira gae yeuma den anopewa, amedanawa atapupu toderereyak gwe go toimu kokawa kweg aisiya. ");
INSERT INTO mti_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne natawa ye diruitna. Anog keptete kumiwa apa, Sodom ge Gomora ibnawa muma me bembemu, go gwetoimu asime ibnawa me koka. ");
INSERT INTO mti_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ne teyemeni aisiya. Me sip mae urup danave ampe mina. Meoya mokare mina kuiyewa oraivit ape, sira unatun mina danewa oraivit ape. ");
INSERT INTO mti_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iyayapan munan yaukape. Mu matai tam teyempe kansoru gumbe, sira sinagogu danave murap gumbe ye guraipe. ");
INSERT INTO mti_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nenan oya mu amareme igiyawa ge kin mu namuwo ye tam onampe. Ye nenan mu ge Ju onan igiyawa gae taibe dirumiya. ");
INSERT INTO mti_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Megara mu tam yempewa, aninin watan, divi watan, ye den anoya. Me kumive ye anin wayawa matai ano yempe. ");
INSERT INTO mti_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Kuiyawa gae wayawa me ye onan, Mamewa Guwawa Iyakaisiyapama ye guniyap munan gae wape. ");
INSERT INTO mti_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tatawa gwaneba anavi ag omin baraupe, da botope. Mamawa usiwa gumbe anavi ape botope; usitainawa mu mamuwa ge inowa gumbo gara kwaviyape, mu boriruwape. ");
INSERT INTO mti_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kuiyawa me ivunwa oya, iyayapan undag ye diruipe watkukam yempe, go bira da oiyeba konive yusiyusi apewa matai waita mumpe. ");
INSERT INTO mti_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Gwetoimu mame igiyawa ye edawai yempewa, tam gwetoimu da aisiya. Ne natawa diruitna. Ye oma den ane at Isuraeru gwetoimu undag aisiya, Apan Usiwa uwayempeve. ");
INSERT INTO mti_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Gigirum usiwa me toewanewan abnawa meuma gumbe egave onan. Nau usiwa me kokawa meuma gumbe egave onan. ");
INSERT INTO mti_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Gigirum usiwa me oma ane toewanewan abnawa meuma me mina apewa, me oraimina. Nau usiwa me oma ane kokawa meuma me mina apewa, me oraimina. Gwe kuiya abnawa airapu kokawa Berujeburu mu didnetpewa, aninin gwe meuma igiyawa dirumpe! ");
INSERT INTO mti_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Meoya iyayapan munan den a aya. Guwave barauyawa me matai undag taibe ape, sira guwave barauyawa iyayapan matai undag yaug anope. ");
INSERT INTO mti_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ne ye arampuna diruitnawa eyawa gae iyayapan gumbo dirumiya; nauneyap ne simura watnawa gwe egave gae waya. ");
INSERT INTO mti_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iyayapan kwapiwa tope boape megara oma den ane guwawa tope boape. Meoya iyayapan munan den a aigimiya. Megara God me oma ane kwapiwa ge guwawa duwam gutpe boriruwape at kukaeba geena danave. Meoya God gumbe a aigimiya. ");
INSERT INTO mti_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Nenip dirori duwam anmaga asarion desirom gumbe gwiruwareme. Ye me anoyana. Mamewa bainda den wapewa, desirom da piyu egave den aikpe. ");
INSERT INTO mti_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Sira ye kuiye gumawa undag basiyaivi. ");
INSERT INTO mti_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Meoya den a aigimiya; ye painauvit, nenip dirori ye mina onan. ");
INSERT INTO mti_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bira da iyayapan namuwo ne yaug ano nekpewa, ne matai Maman kwiminau wakenewa namive me yaug ano nekpe. ");
INSERT INTO mti_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Megara bira da iyayapan namuwo ne den yaug anonekpewa, ne matai Maman kwiminau wakenewa namive me den yaug anotna. ");
INSERT INTO mti_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ye den anoya ne piyu egave yum aug onedna. Ne yum oya den onedna, mut oya onedna. ");
INSERT INTO mti_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kuiyawa ne onedna apan me mamawa gaibu daietaitai atan oya, gwaitawa inawa gaibu daietaitai atan oya, wainiwa inawa nimnagawa gaibu daietaitai atan oya. ");
INSERT INTO mti_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sira inomamo usitainawa desiroma me gara anavi ape. ");
INSERT INTO mti_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Bira da me mamawa go inawa baigan meuma koka mumpe, megara nenan baigan koka den aigimpewa me ne gunap oraimina onan. Bira da gwaitawa go usiwa baigan meuma koka mumpe nenan baigan koka den aigimpewa me ne gunap oraimina onan: ");
INSERT INTO mti_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Sira bira da me korosi meuma aug amanap den onigimpewa me ne gunap oraimina onan. ");
INSERT INTO mti_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Bira da inaiinai meuma aupewa, me matai waropiyape, sira bira da me inaiinai meuma nenan waropiyapewa me matai yaug aupe. ");
INSERT INTO mti_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Bira da ye baiganieg au yempewa me ne au nekpe, sira bira da me ne au nekpewa me Maman me baraunedne aig onednawa au nekpe. ");
INSERT INTO mti_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Bira da me propeta aupewa, kuiyawa me propeta, me matai propeta garawa meuma me aupe, sira bira da me apan oraiwa aupewa, kuiyawa me apan oraiwa, matai apan oraiwa garawa meuma aupe. ");
INSERT INTO mti_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sira bira da yoi taigipama ap gumbe apan kusida mame wampewa, kuiyawa me ne aigo neumawa, ne natawa diruitna, me garawa meuma matai den di waropiyape. ");
INSERT INTO mti_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Meib Iesu me aigowawa 12 toyau munne onanane, meve me at gwetoimu mumawa ampa ampa opata ge toyau toyau atan oya aine. ");
INSERT INTO mti_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Meve Jon nog danave Keriso divi aiviwa gaiyawa me anone. Me aigowawa tene amiya. ");
INSERT INTO mti_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mu Iesu gumbe waya, Matai uwatan vemewa me ge, go nu apan da menan amaraigimta? ");
INSERT INTO mti_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iesu garawa wane, Taig aisiya, sira divi yavenewa ge anoenewa Jon diya: ");
INSERT INTO mti_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iyayapan yangabored musiawa mu inaimut yaveme, sira ama buburu musiawa a gigeme, iyayapan yuwat warumamne iviwa reprosi tamiyawa mu oraimina aya, nauno boredmusiawa gae anoeme, boriruwayawa sira inaimusia, sira tawara onan igiyawa gumbo gae oraiwa opata dirumeme. ");
INSERT INTO mti_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bira da nenan den aig aikpewa me gumbe waribiya wakeigimpe! ");
INSERT INTO mti_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon aigowawa mame sira taig amiyawa, Iesu amatog iyayapan undag gumbo Jon oya dirumne: Ye at inguiwa arawa divi yautan oya dauwag aisiyana? Me gwab riid taig viyaiviwa yautan oya? ");
INSERT INTO mti_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Me onan ipewa ye divi yautan dauwag aisiyana? Apan da me wape oraimina ennewa yautan aisiyana? Iyayapan wape oraimumu enemewa mu kin gweyawa danave wakeeme. ");
INSERT INTO mti_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Me onan ipewa, ye divi yautan oya dauwag aisiyana? Me propeta da yautan oya? E, ne diruitna. Me kokavitwa, propeta da mina onan. ");
INSERT INTO mti_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jon menan tenewa mame: Ne umum abnawa barautna namuiban ompe, sira me genan ebu geuma tamibarip ape. ");
INSERT INTO mti_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne natawa diruitna: Ye daneyap vesin gumbe apan me Babataito Abnawa Jon kokawa minawa da den yaine; megara kwimin toimuwawa danave kudnausiren wakenewa me kokawa, Jon mina onan. ");
INSERT INTO mti_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Babataito Abnawa Jon kumiwa apa onne gare mame, iyayapan kwimin toimuwawa oya yusiwavit gara aya eme. Sira iyayapan yusiwavit gara aya emewa me aueme. ");
INSERT INTO mti_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propeta ge Gwangwan gaiyawa undag waya divi matai matatpe, meve Jon uwane. ");
INSERT INTO mti_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Sira ye me autan anoenewa, apan mame me Eraija, me uwatan aiviwa. ");
INSERT INTO mti_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bira da naunawa gaibuwa me kweya anope. ");
INSERT INTO mti_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kum gare mame ne aninin guwaguwawa atna? Me ud usiusiwa gwiruwaremewa arawa apa yan wakeemewa mina. Mu ud usiusiwa upeba munan auveme: ");
INSERT INTO mti_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Nu bepuru yenan kae atu, megara ye den tare wariyana; Nu bo bererinawa totu, megara ye den iruwayana. ");
INSERT INTO mti_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon uwane me nakwaeba ge yoiba den nanewa, mu waya, Me airapu kukaeba gaibu. ");
INSERT INTO mti_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Apan Usiwa uwane me nakwaeba ge yoiba naiviwa, mu waya, Me nakwai nabot nabot ge yoi koka naiviwa, sira me takesi tameme igiyawa ge kukaeba igiyawa gumbo yaire munne. Megara me aiviwa iyayapan toyau mumpe anoano meumawa me oraimina. ");
INSERT INTO mti_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Meve Iesu amatog at gwetoimu kokawa gumbo me irayauyau meuma obiren anewa pui yumne, kuiyawa mu nonemagowa den biroriyaya. ");
INSERT INTO mti_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","At Koreijin, ano kukaeba gungap! At Betuseida, ano kukaeba gungap! Kuiyawa irayauyau ye guniyap me anewa, at Taiya ge at Saidon danave me anewa ipewa, mu tate wape memeyuwa eniya sira atapupu kuiyowo egamne nonomagowa biroriyapono. ");
INSERT INTO mti_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Megara, ne diruitna, at Taiya ge at Saidon yaug anope keptete kumive ibnawa muma me bembemu, go ye yaug anoya ye ibnawa yeuma me ibnapam. ");
INSERT INTO mti_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sira ge Kapenaum! Ge matai kwimin dog aga? Onan, ge matai at kukaeba ades danave yan aiga. Kuiyawa irayauyau ge gungap me anewa meib me at Sodom danave anewa ipewa, kum gare Sodom me meib wakepe. ");
INSERT INTO mti_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Megara ne diruitna, keptete kumive at Sodom ibnawa meuma me bembemu, go ibnawa geuma me koka. ");
INSERT INTO mti_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Me kumiwa apa Iesu wane, Maman, Ayapan kwiminau ge piyuwau wakeyawa, ne ge watdega gemeni. Kuiyawa ge anoano koukawa igiyawa gumbo ge dividivi mame yaug anoyawa gumbo guwave teyana, go ud usiusiwa gumbo taibe watapana. ");
INSERT INTO mti_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Maman. Mame anoano geuma oraiwa gumbe pawane. ");
INSERT INTO mti_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dividivi undag Maman nedne. Maman mekut Apan Usiwa yaug anone. Sira bira da Maman den yaug anone. Sira Usiwa imive iyayapan mu Maman oya yaug anopewa mu mukut Maman yaug anope. ");
INSERT INTO mti_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Uiwa topayasiviwa ge ibnawa aviviwa undag, nenan oneya. Sira ne yentna nonewa emiya. ");
INSERT INTO mti_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne nonenmagawa oraivit sira mokona eni, meoya ye guniyap yo neuma aug gunap yaug anoya. Meib aya ipewa nonemagewa nonewa emtan yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kuiyawa yo neuma me taibe sira ibnawa neuma me bembemu. ");
INSERT INTO mti_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Me kumive, Sabat Kumiwa apa Iesu nakwai wiit veriyawa danave aivi. Me aigowawa iyagon aramne, mu amatog nakwai wiit uba tam naya. ");
INSERT INTO mti_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisi igiyawa mame yawamiyawa, mu me gumbe waya, Yawa! Aigowagwa geuma Sabat Kumiwa apa Gwangwan togomeme. ");
INSERT INTO mti_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Megara Iesu garawa wane, Ye Devid ge owawa iyagon wakeyawa kumiwa me aninin ane? Ye basiyayana go onan? ");
INSERT INTO mti_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Me God gweyawa unig aine, me ge owawaiwa bredi waribiyayawa tam naya Mu tam nemewa me Gwangwan painau tuyaueme, pirisi igiyawa mukut nemewa. ");
INSERT INTO mti_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ye gwangwan buka meuma basiyana, go onan? Sabat Kumiwa apa pirisi igiyawa temporu danave nau waremewa mu Sabat Kumiwa togomeme, go mu painau den tuyaueme. ");
INSERT INTO mti_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne diruitna, apan da me kokavitwa sira temporu mina onan, me mapa wakene. ");
INSERT INTO mti_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ne anoeniwa me baigan, puyo maeba onan, ye gae mame natawa yaug anoyanawa, ye kukaeba onan igiyawa pui den yuwampono. ");
INSERT INTO mti_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kuiyawa Apan Usiwa me Sabat Kumiwa Ayapaneba. ");
INSERT INTO mti_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","At me apa Iesu kweg aine, me sinagogu muma danave unig aine, ");
INSERT INTO mti_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","sira apan naniwa gegerainewa asimeve wakene. Mu Iesu singui aya, Sabat Kumiwa apa warinamtan me bainda go, onan? Mame me Iesu pui yutan oya. ");
INSERT INTO mti_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Me mu dirum wane, Bira da ye daniyap sip amaraivi, sip me Sabat Kumiwa apa dukup danave aikpe ipewa, ye me aropiya dauwape, go onan? ");
INSERT INTO mti_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mae sip me menan anowawa me kusikareren iyayapan munan kokavit! Meoya Sabat Kumiwa apa oraiwa atanwa me bainda. ");
INSERT INTO mti_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Meve Iesu apan gumbe digwane, Nanigwa atan dima. Meoya me naniwa siwadne, oraimina di ane. Me naniwa gamben mina oraimina ane. ");
INSERT INTO mti_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Megara Parisi igiyawa dauwag amog Iesu aninin totan oya gae yuya. ");
INSERT INTO mti_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Iesu me yaug anone at me apa yankweg aine. Iyayapan obiren me amave amiya, sira me yuwat muma undag warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","I Iesu yaigipam dirumne, umum den wape ne bira. ");
INSERT INTO mti_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mame me propeta Aisaya gumbe wanewa natawa uwatan aivi oya: ");
INSERT INTO mti_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nau neuma abnawa me ne wait watkiniyanawa me mame, apan mame ne baigan neuma gumbe, sira me gumbe ne degadega eni; Ne Guwanwa neuma me gumbe barautna, sira me iyayapan undag piyu egave wakeemewa gumbo gaiyawa oraiwa opata wag dirumpe. ");
INSERT INTO mti_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Me diguragut go ae den waigimpe; bira da ebu taibe noiwa den anope, ");
INSERT INTO mti_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ben riid kamokamot anewa me den warensipe, sira iyam meru yusi onanwa me den wabumpe, namu me amat amumpe anoano oraivitwa aupe. ");
INSERT INTO mti_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ju onan igiyawa owanowan muma me iviwa gumbe baraupe. ");
INSERT INTO mti_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Meve iyayapan apan da me airapu danave unig wakene yangawa boredne sira noiwa borednewa me aug Iesu gumbe uwaya, me warinamne, meoya me gae wane sira yangut ane. ");
INSERT INTO mti_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyayapan undag terag waya, Mame me Devid Usiwa go? ");
INSERT INTO mti_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Megara Parisi igiyawa gae mame anoyawa mu waya, Me airapu kokawa Berujeburu gumbe apan me airapu atatai imivi dauwag amome. ");
INSERT INTO mti_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Iesu danowa yaug anone mu dirumwane, At kokawa da wagomiyak me mekut ube yoipewa me matai aikpe, sira gwetoimu kowawa da go gwe togomiyak me mekut ube yoipewa me den yoipe. ");
INSERT INTO mti_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Seitan me Seitan atatai impe dauwag aipe, me togomiyak me mekut ube yoipewa me aninin toimu meuma yoipe? ");
INSERT INTO mti_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne airapu kukaeba Berujeburu iviwa gumbe atatai imigimtnawa, aninin ud yeumawa atatai impe mu dauwag ampe. Meoya ud yeumawa mu ye keptete abnawa yeuma ape. ");
INSERT INTO mti_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Megara ne God Guwawa gumbe airapu kukaeba atatai imeniwa, God toimuwawa me ye guniyap wait uwane. ");
INSERT INTO mti_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Go, apan da me apan yusipam gweyawa unig dividivi meuma tamtan anopewa, namu me apan yusipama murap gumbe den tupewa, aninin gwe meuma tammon? Meve me gwe meuma ubape. ");
INSERT INTO mti_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Apan me ne gaibu den waketuwa me topainednewa, sira apan me ne gaibu den agoniyatawa me matai ubeube ampe. ");
INSERT INTO mti_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sira ne diruitna. Iyayapan kukaeba ayawa sira gae kukaeba wayawa matai kukaeba muma anog yankwepe, go Guwawa Iyakaisiyapama gumbe gae kukaeba wayawa kukaeba muma den anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Apan da bira me Apan Usiwa gumbe anokukam wanewa me matai kukaeba meuma anog yankwepe, go kum mame gare danave go kum ivi uwapewa danave, apan da bira Guwawa Iyakaisiyapama gumbe anokukam wapewa me matai kukaeba meuma den anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yoma oraiwa me magawa oraivit impe, sira yoma kukaeba me magawa kukaeba impe, kuiyawa yoma me magawa gumbe iyayapan yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ye mokare kukaeba upewaiwa mina. Ye kukaeba minawa aninin divi da oraiwa ye vene? Kuiyawa nonemagawa danave noidauwanewa me aigivi noiwa gae waivi. ");
INSERT INTO mti_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Apan oraiwa dividivi oraiwa nonewa danave wakenew a oraiwa tam ompe, sira apan kukaeba dividivi kukaeba nonewa danave wakenewa kukaeba tam ompe. ");
INSERT INTO mti_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne ye diruitna. Iyayapan gae gwambe gwambe vemewa matai keptete kumive mu natawa dipe. ");
INSERT INTO mti_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kuiyawa gae yeuma gumbe ye matai oraivit igiyawa diruipe, sira gae yeuma gumbe ye matai kukaeba igiyawa diruipe. ");
INSERT INTO mti_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Meve Parisi igiyawa ge Gwangwan toewanewan igiyawa upeba Iesu gumbe garawa waya, Toewanewan, irayauyau ge gungap yautan anoete. ");
INSERT INTO mti_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Iesu garawa dirumne, Kukaeba ge uinantaraki kumiwa igiyawa irakoniwa oya nun veme! Megara propeta Jona irakoniwa meuma mekut mumpe, dawa onan. ");
INSERT INTO mti_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kuiyawa Jona me kum duwamdesi ge aram duwamdesi gwambui koka danave wakene, me desiroma Apan Usiwa kum duwamdesi ge aram duwamdesi piyu danave wakepe. ");
INSERT INTO mti_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","At Nineve igiyawa mu matai pui keptete kumive, kum mame garewa igiyawa gaibu wan yoipe, iyayapan mame dirum wakukamumpe; kuiyawa mu Jona opata meuma gumbe nonemagowa biroriyaya. Megara, yauya, gare apan kokawa mapa, Jona me mina onan. ");
INSERT INTO mti_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwiin sausu apa matai uwape, sira pui keptete kumive gare mame igiyawa gaibu yoipe iyayapan mame dirum wakukampe; kuiyawa kwiin me Soromon anoano meuma anotan oya piyu gina gambenwa apa dauwag onne. Megara, yauya, gare apan kokawa mapa, Soromon mina onan. ");
INSERT INTO mti_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Airapu kukaeba apan danave dauwag ainewa, me yoi onan arawa gigivi nonewa emtan arawa didimama aivi go da den yaune. ");
INSERT INTO mti_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Meve me wane, Ne gwe wait kwenawa sira taig anekna. Me sira taig uwane gwe danave yaunewa gwe danave ingui, ereri aiyane sira dividivi yaiyai tene. ");
INSERT INTO mti_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Meve me sira dauwag aine airapu kukaeba upeba yusipama 7 tam onne. Kukaeba muma koka, me membo mina onan. Mu undag uwag asime unig vineme. Meve apan me inaiinai meuma oieba di kukaine, namuwa mina onan. Gare mame kukaeba igiyawa me matai meib ape. ");
INSERT INTO mti_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesu iyayapan undag gae ande dirumiviwa, me inawa ge gwanebaiwa gwe daieve yoiya. Iesu gaibu gae watan anoeme. ");
INSERT INTO mti_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Apan da me dine, Yawa. Inag ge gwanegaiwa gwe daieve yoieme. Ge gaibu gae watan anoeme. ");
INSERT INTO mti_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Iesu garawa digwane, Ne inan me bira, tatangwanen mu bira? ");
INSERT INTO mti_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Me aigowawa naniwa yug wane, Yauya, ne inan ge tatangwanen mawa wakeya. ");
INSERT INTO mti_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kuiyawa bira da Maman me kwimin danave wakenewa anoano meuma aiviwa me ne tatangwanen ge yogiyanaiwa ge inan. ");
INSERT INTO mti_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kum me desiroma Iesu gwe dauwag aine sira poeman visive yan wakene. ");
INSERT INTO mti_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iyayapan obiren me gumbe birorot agoniyaya, meoya me wa danave unig aig yan wakene, meve iyayapan undag awau visive wan yoiya. ");
INSERT INTO mti_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sira me dividivi obiren maibe gumbe wag dirumne, Nau abnawa yawa meuma emetan oya dauwag aine. ");
INSERT INTO mti_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Meve me yawa emiviwa, upeba ebu taibe aigiya. Nenip uwag undag naboriya. ");
INSERT INTO mti_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Upeba an egave aigiya, asime piyu koka onan. Mu tatevit dumiya, kuiyawa piyu kusi da egave. ");
INSERT INTO mti_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Megara kum dauwag mu igamne undag toyaimusia, kuiyawa mu taiwa epampa den aigiya. ");
INSERT INTO mti_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yawa upeba gan danave aigiya. Yawa yaig yoiya, go gan warumne. ");
INSERT INTO mti_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yawa upeba piyu oraiwa egave aigiya. Upeba 100 mina natawa inamiya, upeba koniwa 60 mina natawa inamiya, upeba koniwa 30 mina natawa inamiya. ");
INSERT INTO mti_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Bira da naunawa gaibuwa kweya anope. ");
INSERT INTO mti_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aigowawa Iesu gumbe uwag singui aya, Divi oya ge iyayapan maibe gumbe dirumege? ");
INSERT INTO mti_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Me gara wane, Kwimin toimuwawa anoano guwavewa me wait toyau yenna, megara mu ne den guwavewa muneni. ");
INSERT INTO mti_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bira da me aunewa, me matai sira egave kokavit aupe. Bira da me den aunewa, me matai gumbe atan aupe. ");
INSERT INTO mti_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ne maibe gumbe dirumeni: Mu yaveme, go mu den yaupe; Mu anoeme, go mu den anope sira den yaug anope. ");
INSERT INTO mti_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Propeta Aisaya wanewa mu danowo natawa matadne: Ye anoene, megara den di yaug anoya; ye yavene, megara den di yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kuiyawa iyayapan mame nonowa e den sivi, mu naunowa boredne, sira mu yangowa abumiya. Mu yangowo den yaveme. Mu naunowo den anoeme, nonomagave den yaug anoeme, sira nonomagawa den tobieme. Ne den warinamuntna. ");
INSERT INTO mti_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Megara, yangewa waribiyane, kuiyawa mu yaveme, sira naunewa waribiyane, kuiyawa mu anoeme. ");
INSERT INTO mti_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne natawa diruitna. Propeta ge apan oraimumuwa obiren ye yavenewa mu yautan anoya, megara oma den ane yauya, sira ye anoenewa mu anotan anoya, megara oma den ane anoya. ");
INSERT INTO mti_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Meoya yawa emeiviwa abnawa maibeyawa ye anoya: ");
INSERT INTO mti_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Apan da God toimuwawa gaiyawa anog den yaug anopewa, me danave vednewa me matai airapu kukaeba uwag aug aipe. Mame me yawa ebu taibe vednewa. ");
INSERT INTO mti_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Apan da yawa an egave emiviwa me gae anog koni degadega gumbe avivi abnawa. ");
INSERT INTO mti_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Megara, me taiwa onan, kum koni pipi aigimpe mina. Kuiyawa gae oya ibnawa go edawai uwapewa me tatevit uyug aikpe. ");
INSERT INTO mti_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Apan da me yawa gan danave tamiviwa, me gaiyawa anope, go piyu mame anoano meuma anope sira dividivi tawara oraimumu ugai wampe me gae imiwa atataipe, natawa den impe. ");
INSERT INTO mti_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Megara apan da yawa piyu oraiwa egave tamiviwa gae anog yaug anope. Me natawa impewa, upeba 100 mina, 60 mina, 30 mina impe. ");
INSERT INTO mti_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesu maibe dawa mu dirumne: Kwimin toimuwawa me apan da yawa oraiwa nau meuma danave emivi mina. ");
INSERT INTO mti_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Megara iyayapan kubvinemewa, anavi uwag nakwai wiit yapowo wayo emeg aine. ");
INSERT INTO mti_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nakwai wiit yaieg dumeg uba toya, go wayo gaibu yaiya. ");
INSERT INTO mti_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kokawa nau igiyawa meuma uwag gumbe waya, Kokawa, ge yawa oraimumu nau geuma danave emeyana, go onan? Wayo ampa uwaya? ");
INSERT INTO mti_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Mame anavi ane, kokawa garawa wane. Nau igiyawa me dig waya, Ge anoegewa nu an undag biyauta? ");
INSERT INTO mti_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me garawa wane, Onan, kuiyawa ye wayo biyauyawa ye nakwai wiit gaibu biyauya. ");
INSERT INTO mti_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kweya undagit wakepe duwam yoipe, meve maura kumiwa uwape. Me kumiwa apa kwaptan igiyawa dirumpna, namu wayo wat agoniyag itap tug iyam yangave aorepe, meve nakwai wiit wat agoniyag tam onampe buim neuma danave teya. ");
INSERT INTO mti_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iesu me maibe dawa mu dirumne: Kwimin toimuwawa me gayum yawa mina. Apan da me aug aig nau meuma danave vedne. ");
INSERT INTO mti_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Gayum yawa me yawa undag yapowo kusikareren. Megara, me yainewa, me nau danave yoiemewa yapowo kokavit ane sira yoma mina ane. Nenip painauwa uwag naniwa gumbe en wariya. ");
INSERT INTO mti_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sira me maibe da mu dirumne: Kwimin toimuwawa me iist mina. Vesin da me aug parawa me 3 saton danave bidwag ag kamasiyanewa, parawa tan koka ane. ");
INSERT INTO mti_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu dividivi undag mame maibe gumbe iyayapan dirumne; me maibe den kwene dividivi undag maibe gumbe dirumne. ");
INSERT INTO mti_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Me propeta gumbe gae wanewa natawa veniyatan oya: Ne nonwa maibe gumbe watapna, piyu amatog onnewa dividivi guwavewa ne gae diruitna. ");
INSERT INTO mti_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Meve Iesu me iyayapan undag kwem gwe dana unig aine. Aigowawa meuma me gumbe uwag waya, Wayo maibeyawa natawa didnuna. ");
INSERT INTO mti_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Iesu garawa wane, Yawa oraiminawa emiviwa me Apan Usiwa. ");
INSERT INTO mti_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nau me piyu mame undag, sira yawa oraiwa me God toimuwawa usitainawa. Wayo me airapu kukaeba usitainawa, ");
INSERT INTO mti_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","sira anavi me wayo emenewa me airapu kukaeba. Maura kumiwa me kum oieba sira kwaptan igiyawa me aneya. ");
INSERT INTO mti_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Meoya wayo biyaupe sira iyam oketpe igampe, kum oieba kumiwa me meib. ");
INSERT INTO mti_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Apan Usiwa me aneya meuma tepe dauwag ampe. Me dividivi kukaeba emewa undag ge ano gwambe emewa undag toimu meuma danave agoniyape. ");
INSERT INTO mti_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mu iyam meru danave emepe. Mu iruwaigimpe sira donowa kitosaigimpe. ");
INSERT INTO mti_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Me apa oraimumu igiyawa mu Mamowa toimuwawa kwiminau danave kum mina yuigimpe esigimpe. Bira da naunawa gaibuwa kweya anope. ");
INSERT INTO mti_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kwimin toimuwawa me nau danave divi da oraiminavitwa guwavewa mina. Apan da me yaupewa, me guwave sira baraupe, degadega ag taig aipe. Me dividvi meumawa undag gwiruwat anmaga aupe meve nau me gwiruwat aupe. ");
INSERT INTO mti_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Sira kwimin toimuwawa me gwiruwatwat abnawa me keri oraiwa didimama aivi mina. ");
INSERT INTO mti_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Me garawa meuma koka da desirom yaupewa, me aig dividivi meuma undag gwiruwat anmaga aupe meve keri gwiruwat aupe. ");
INSERT INTO mti_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Sira kwimin toimuwawa me uwariri mina. Awau danave baraupe aikpe gwambui gina ubeube undag bope. ");
INSERT INTO mti_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Me noidauwapewa, gwambui botag eme igiyawa me ororiyape dauwape awau visive baraupe. Meve mu yan wakeg gwambui oraiwa bog pot dana empe, kukaeba epa emepe. ");
INSERT INTO mti_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Oieba kumiwa apa me meib ape. Aneya uwape togomiyape kukaeba igiyawa ube tepe sira oraimumu igiyawa ube tepe. ");
INSERT INTO mti_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Sira mu iyam meru danave emepe. Mu iruwaigimpe sira donowa kitosaigimpe. ");
INSERT INTO mti_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ye dividivi undag mame yaug anoyana? E, mu Iesu gumbe garawa waya. ");
INSERT INTO mti_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Meve Iesu dirumne, Meoya ano kokawa igiyawa mu kwimin toimuwawa aigowawa ayawa mu gwe abnawa mina. Me buim meuma danave dividivi mataiwa ge nunganwa gaibu tampe. ");
INSERT INTO mti_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesu maibe gumbe dirumne onananewa, meapa kwem aine. ");
INSERT INTO mti_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","At meuma uwane. Me amatog iyayapan sinagogu danave toyau munne. Mu undag terag singui aya. Apan mame anoano mame ge irayauyau yusiwa mame ampa aune? ");
INSERT INTO mti_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Apan mame gwe sisi abnawa usiwa onan go? Inawa meuma iviwa me Meri, sira mu gwanebaviwa Jemus, Josep, Saimon ge Judas onan go? ");
INSERT INTO mti_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yogiyawaiwa meuma undag nu gaibu onan go? Apan mame dividivi undag mame ampa aune? ");
INSERT INTO mti_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Sira mu Iesu gumbe ano topayaya. Megara Iesu dirumne, Propeta me gwetoimu meuma ge gwe meuma danowo mekut ebnotu gumbe da onan. ");
INSERT INTO mti_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iesu me apa irayauyau obiren den ane yauya, kuiyawa mu Iesu gumbe anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Me kumiwa apa, at amaraiviwa kin Erod Iesu umumawa anone, ");
INSERT INTO mti_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","sira me nau meuma eme igiyawa dirum wane, Mame me Babataito Abnawa Jon. Jon boriruwayawa igiyawa gumbo sira inaig yoine, meoya inaiinai ubeube yusiwa me gumbe nau aivi. ");
INSERT INTO mti_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kin Erod Jon aune, sira naniwa tune, nog danave baraune, me Erodias me tatawa Pirip biviwa oya. ");
INSERT INTO mti_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jon yusipamit dine: Ge vesin me auwanawa me Gwangwan togomiege. ");
INSERT INTO mti_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erod Jon tope boitan anone, megara iyayapan oya a ane, kuiyawa mu me propeta anoeme. ");
INSERT INTO mti_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Erod yainewa kumiwa apa, Erodias gwaitawa mu munan tare wadne, Erod degadega kokavit ane, ");
INSERT INTO mti_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","meoya divi da gwaitawa me nun wapewa me wantan oya agi yaigipamit wane. ");
INSERT INTO mti_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Megara inawa me otau meib toewanne, me wane, Gare Babataito Abnawa Jon kuiyawa en egave baraug nega. ");
INSERT INTO mti_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kin danadawai anone. Megara agi meuma yaigipamit wane oya, sira iyayapan buyunai gumbewa yaveme oya, me dirumne otau nun waiviwa wampe. ");
INSERT INTO mti_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Me iyayapan upeba tene nog amiya. Mu Jon meyawa kwagomi aya. ");
INSERT INTO mti_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Me kuiyawa en egave baraug aug onam otau wanne. Otau me aug inawa oya aig wanne. ");
INSERT INTO mti_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jon aigowawa uwag me kwapiwa aug sig umiya. Meve mu amog Iesu umum mame diya. ");
INSERT INTO mti_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesu umum mame anonewa, me mekut wa gumbe dauwag pomtone arawa aine. Iyayapan me anoyawa, iyayapan obiren gwetoimu apa dauwag Iesu amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iesu yoi visi gambenwa wa gumbe dauwanewa, iyayapan obiren yawamne. Me mu gumbo danadawai anone sira yuwat muma warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Augoi ariviwa, aigowawa mu Iesu gumbe uwag waya, Mapa gina inguiwa arawa, sira at augoi arivi. Iyayapan teya ampe. Mu gwetoimu ampe mumbovit nakwai muma gwiruwatpe. ");
INSERT INTO mti_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Megara Iesu gara wane, Mu den ampe. Ye nakwai da muniya. ");
INSERT INTO mti_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aigowawa garawa waya. Mapa bredi naningambenit ge gwambui duwam mekut wakeya. ");
INSERT INTO mti_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tam mapa nenan oneya, Iesu wane. ");
INSERT INTO mti_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sira Iesu me iyayapan obiren wayo egave yan waketan dirumne. Me bredi naningambenit ge gwambui duwam tam owan kwimin yaug gaun wane. Meve bredi warensine aigowawa munne. Aigowawa iyayapan obiren keb ag muniya. ");
INSERT INTO mti_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mu undag naya oma ane. Sira aigowawa mu musimusiwa ande wakeyawa kwiniyag pot 12 enamiya noidauwaya. Mu undag naya oma ane. Aigowawa mu musimusiwa ande wakeyawa kwiniyag pot 12 enamiya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iyayapan me nayawa undag apan 5,000, vesin ge usitainowa gaibu den basiyaya. ");
INSERT INTO mti_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iesu tatevit aigowawa dirumne wa danave unigiya sira visi gambenwa namiven amome, Iesu me iyayapan tene taig amiya. ");
INSERT INTO mti_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Me iyayapan tene taig amiyawa, me tui visi gambenwa dodne me mekut nun watan oya aine. At augoi uwag onnewa, me mekut asimeve wakene. ");
INSERT INTO mti_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Wa wait asinut aine piyu visive onan, yawarat tone aig ge dauwaivi kuiyawa taig gaibu garadodot aya. ");
INSERT INTO mti_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iesu wanteteyau aram kum koniwa duwamdesi mina poeman egave munan aivi. ");
INSERT INTO mti_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aigowawa me Iesu poeman egave oniviwa yaug a aya. Me airapu, mu waya. Mu a ake kwaruwaya. ");
INSERT INTO mti_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iesu tatevit mu dirumne: Yusiyusi aya! Ma ne. A den aya. ");
INSERT INTO mti_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita garawa wane, Ayapan, ge ipewa, ne didnega yoi egave genan onekna. ");
INSERT INTO mti_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Me wane, Onaga. Meve Pita wa gumbe atan dauwag yoi egave amave Iesu menan aine. ");
INSERT INTO mti_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Megara me taig yaune a ane. Me amatog yoi dana unig wane, Ayapan waita nega! ");
INSERT INTO mti_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iesu tatevit me nanive wan aune. Me wane, Anotumat geuma kusi. Divi oya nenan pipangitege? ");
INSERT INTO mti_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Sira Iesu ge Pita wa danave dauwaya, taig memeyaig aigne. ");
INSERT INTO mti_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Meve wa dana wakeya igiyawa me gumbe kwanagapoe ag waya, Natawa di ge God Usiwa. ");
INSERT INTO mti_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Meve mu awau togomiyag at piyu Genesaret apa uwaya. ");
INSERT INTO mti_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Sira at asime igiyawa mu Iesu yaug anoya. Mu at toimu undag birorot wakeyawa gumbo gae barauya aine. Iyayapan yuwat igiyawa undag tam Iesu gumbe onamiya. ");
INSERT INTO mti_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sira Iesu gumbe nun waya, yuwat igiyawa me gumbe uwag wape meuma ginawa yumtan oya. Yuwat igiyawa yumiyawa mu undag inaimusia. ");
INSERT INTO mti_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Meve Parisi igiyawa ge Gwangwan toewanewan igiyawa upeba Jerusarem apa Iesu gumbe onam singui aya, ");
INSERT INTO mti_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Divi oya aigowagwa upanaiwa kuinui muma togomiyaya? Mu nanuwa den muinekapa naya! ");
INSERT INTO mti_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iesu garawa wane, Divi oya ye upanaiwa kuinui yeuma oya God gwangwan meuma togomiene? ");
INSERT INTO mti_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kuiyawa God wane, Mameaiwa ge ineaiwa ebnotu amuniya, sira Bira da inamamawa gumbo anokukam apewa matai tope boape. ");
INSERT INTO mti_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Megara ye vene, Bira da inamamawa gumbo, dividivi me ne yenan tamnawa me God puyuwawa ane, meib dirumpe ipewa, ");
INSERT INTO mti_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","me inamamawa me gumbe ebnotu den ape. Ye upanaiwa kuinui yeuma oya God gaiyawa natawa onan mina aya. ");
INSERT INTO mti_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ye ugauga ene igiyawa! Aisaya guniyap diruinewa me natawa: ");
INSERT INTO mti_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Iyayapan mame nouwa muma gumbe ebnotu nenan eme, megara imudanowo muma ne gunap painau. ");
INSERT INTO mti_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mu imuwa undag ne gunap den waiya eme; mu iyayapan toyau toyau muma mekut toyau muneme. ");
INSERT INTO mti_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesu iyayapan obiren munan auwane menan onamiya, Anoya, sira yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Divi da apan noiwa danave unikpewa me den ape apan miyot ape, megara divi da noiwa danave dauwapewa me ape apan miyot ape. ");
INSERT INTO mti_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Meve aigowawa me gumbe uwag singui aya, Ge anoana Parisi igiyawa gae mame anoyawa danopiriwane? ");
INSERT INTO mti_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me gara wane, Yauya. Maman kwiminauwa me den vednewa undag matai taiwa gaibu wan biyaupe. ");
INSERT INTO mti_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mu yankwemiya; mu yangabored igiyawa. Apan da yangaborednewa me eveba yangaborednewa gaibu ampewa duwam matai nog aikpe. ");
INSERT INTO mti_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita wane, Maibe natawa muma didnuna anota. ");
INSERT INTO mti_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iesu singui munne, Ye ande ano pimpan gitene? ");
INSERT INTO mti_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ye den anoyana dividivi undag noiwa gumbe danave aigeme sira kwapiwa gumbe daueme? ");
INSERT INTO mti_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Megara divi da nonap dauwaiviwa me nonemagawa apa uwag onivi. Mame apan miyot umpe. ");
INSERT INTO mti_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kuiyawa, ano kukaeba anoiviwa, toen guttanwa, uinantaraki, vesin apan payaupayau, ub, gae ugauga, garadi, dividivi undag mame nonenmagawa apa daueme. ");
INSERT INTO mti_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mame me apan miyot umpe, megara nakwai naniwa den muinkapa napewa me den ape apan miyot ape. ");
INSERT INTO mti_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iesu at me kwenewa, me uwag aig at Taiya ge at Saidon aine. ");
INSERT INTO mti_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","At Keinan vesin da me at me visive apa onnewa me gumbe uwag kwaruwane, Ayapan, Devid Usiwa, nenan danadawai anoa! Gwaitanwa airapu kukaeba gumbewa me dawai kokavit anoivi. ");
INSERT INTO mti_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Iesu gae da garawa den wane. Meoya aigowawa me gumbe uwag gae yusipamit nun waya, Kweya aipe. Vesin me amunup kwaruwag onivi. ");
INSERT INTO mti_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Me garawa wane, Ne at Isuraeru sip kwawanewa mukut oya baraunedne aig onedna. ");
INSERT INTO mti_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vesin me uwag namive koniwa yug wane. Ayapan. Waita nega. ");
INSERT INTO mti_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iesu garawa wane, Me oraimina onan ud bredi muma aug kweyau aoretna nape. ");
INSERT INTO mti_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vesin wane, Ayapan, me natawa. Megara kokawa meuma teboro ankwatave bredi musimusiwa aikpewa kweyau me nape. ");
INSERT INTO mti_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Meve Iesu garawa wane, Vesin, anotumat geuma koka. Nun geuma me atna. Sira me konive me gwaitawa inaine. ");
INSERT INTO mti_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iesu at me kweg poeman Gariri visive aine. Meve me tui gambenwa dauwag aig me apa yan wakene. ");
INSERT INTO mti_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iyayapan obiren me gumbe uwaya. Mu amo kukaimusiawa, ama nanuwa gongamayawa, yangowa kukaimusiawa, noi boredmusiawa ge upeba obiren tam uwaya. Mu Iesu amave teya. Iesu mu warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Noi boredmusiawa gae waya, ama nanuwa gongamayawa oraimumu aya, ama kukaimusiawa a amiya, yangowa kukaimusiawa sira yanguraya. Iyayapan obiren mu yawamiya teraya, sira mu Isuraeru God muma watdega aya. ");
INSERT INTO mti_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iesu aigowawa munan auwane onamiya dirumne, Ne iyayapan mame munan danadawai aueni. Mu ne gaibu wait kum duwamdesi waketu, go mu nakwai onan. Ne iyagon gumbe den tetna sira taig ampe. Mu ebu taibe yangowa viyape uyug aikpetan. ");
INSERT INTO mti_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Me aigowawa garawa waya, Mapa gina inguiwa arawa. Ampa nu bredi tamta iyayapan undag mame nape oma ape? ");
INSERT INTO mti_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Iesu singui munne, Ye bredi anintom guniyap wakeya? Mu gara waya, 7, sira gwambui kusikusiwa gaibu. ");
INSERT INTO mti_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Me iyayapan wag dirumne piyu egave yan wakeya. ");
INSERT INTO mti_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Meve me bredi 7 ge gwambui wan tamne. Me gaun wanewa, mu warensig aigowawa munne. Mu iyayapan kep teg muniya. ");
INSERT INTO mti_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mu undag naya oma ane. Ivi aigowawa bredi musimusiwa tam pot 7 danave eniya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iyayapan nayawa undag 4,000. Mu vesin ge ud mu gaibu den basiyaya. ");
INSERT INTO mti_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iesu iyayapan tene amiyawa, me wa dana unig aig at Magadan gambenwa oya aine. ");
INSERT INTO mti_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi igiyawa ge Sadusi igiyawa Iesu gumbe uwaya. Iesu gumbe ageyau atan oya irakoniwa kwiminau toyaumuntan oya nun waya. ");
INSERT INTO mti_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me gara wane, At augoi uwag ompewa, ye waya, Me kum oraimina ape, kuiyawa kwimin me gug itpe, ");
INSERT INTO mti_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","sira mumbevit ye waya, Gare mame nin okup ape, kuiyawa kwimin gug idne irikup tobodne. Kwimin yauyawa kwimin aninin tobiyak atanwa ye yaug anoyana, megara divi oya ye oma den ane yaug anoyana kum irawa me aninin. ");
INSERT INTO mti_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kukaeba ge uinantaraki kumiwa igiyawa irakoniwa oya nun veme! Megara Jona irakoniwa meuma mekut mumpe, dawa onan. Iesu meve mu yan kwem aine. ");
INSERT INTO mti_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mu awau visi gambenwa dauwayawa, aigowawa bredi botan imuwa atataine. ");
INSERT INTO mti_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iesu mu dirumne, Yaukapa. Parisi igiyawa iist muma ge Sadusi igiyawa iist muma gumbo yaukapa. ");
INSERT INTO mti_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Mu mumbovit gae garawa ano aya sira waya, Kuiyawa me nu bredi da den tam onantu. ");
INSERT INTO mti_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu gae muma yaug anog singui munne, Ye anotumat kusi igiyawa, divi oya ye yembovit gae gara wano ene bredi den botan oya? ");
INSERT INTO mti_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ye ande den di yaug anoene? Imuiwa atataine? Iyayapan 5,000 oya bredi naningambenit munna naya, pot anintom mina ye agoniyayana, me imuiwa atataine? ");
INSERT INTO mti_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sira, iyayapan 4,000 oya bredi 7 munna naya, pot anintom mina ye agoniyayana? ");
INSERT INTO mti_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ye ande den di yaug anoene ne bredi oya den diruieni? Megara Parisi ge Sadusi igiyawa iist muma mu yaukape. ");
INSERT INTO mti_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Meve mu yaug anoya me mu dirum wanewa me bredi iist gumbe onan, megara Parisi igiyawa ge Sadusi igiyawa toyau toyau muma gumbe wane. ");
INSERT INTO mti_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iesu at Sesariya Piripi ainewa, me aigowawa singui munne, Iyayapan mu Apan Usiwa bira veme? ");
INSERT INTO mti_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Mu garawa waya, Upeba me Babataito abnawa Jon veme, upeba Eraija veme, sira upeba Jeremaiya go propeta da veme. ");
INSERT INTO mti_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Me mu singui munne, Ye aninin vene ne bira? ");
INSERT INTO mti_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita gara wane, Ge Keriso, God Usiwa wakeiviwa. ");
INSERT INTO mti_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iesu garawa wane, Jona usiwa Saimon. God waribiya genne. Kuiyawa mame apan da den toyau genne, Maman kwiminau wakenewa me toyau genne. ");
INSERT INTO mti_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sira ne dirukna. Ge Pita. Ne an koka mame egave siosi neuma sitna. Ades ankwin meuma me den painau tuyaupe. ");
INSERT INTO mti_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne kwimin toimuwawa kii meumawa gentna. Divi da ge piyuwau tuwawa, kwimin danave tupe, sira divi da ge piyuwau vetawa, kwimin danave vetpe. ");
INSERT INTO mti_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Meve me aigowawa gwangwan dirumne, Bira da den waya ne Keriso. ");
INSERT INTO mti_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Me kumiwa apa onne, Iesu amatog aigo meuma wak dirumivi. Me at Jerusarem matai aitanit di, namuyoiyoi igiyawa, pirisi koukawa ge Gwangwan toewanewan igiyawa gumbo dividivi obiren danadawai autanit di, sira me tope boipe kum duwamdesiyawa sira inaipe. ");
INSERT INTO mti_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita me Iesu megiyave baraug amatog yaigipam dig wane, Onan di, Ayapan! Mame ge gungap den di matatpe. ");
INSERT INTO mti_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iesu tobiyak Pita dine, Seitan, daienap aga. Ge ebu neuma borege. Ge God dividivi anoano meuma den anoege, iyayapan dividivi anoano muma anoege. ");
INSERT INTO mti_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Meve Iesu aigo meuma dirumne, Da bira imive ne amanap ontan ape ipewa, me membo di topayape korosi meuma di wan aupe meve ne amanap ompe. ");
INSERT INTO mti_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kuiyawa bira da inaiinai meumawa amaratan anopewa, matai me waropiyape, go bira da inaiinai meuma nenan waropiyapewa matai me yaug aupe. ");
INSERT INTO mti_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Apan me piyu mame undag aupe, go guwawa meuma waropiyapewa oraiwa meuma aninin? Apan me guwawa meuma sira autan oya me divi da garawa wampe? ");
INSERT INTO mti_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kuiyawa Apan Usiwa me Mamawa eyawa danave aneya gaibu aig onektaneni, me apa apan desirom desirom wait aninin anewa gumbe garawa wantna. ");
INSERT INTO mti_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne natawa diruitna. Mapa yokeyawa yapowo upeba mu Apan Usiwa me toimuwawa meuma gaibu oniviwa yaupe, ivi mu boriruwape. ");
INSERT INTO mti_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Oiyat 6 onananewa, Iesu me Pita Jemus ge Jemus tatawa Jon tam, mukut tui painau dog amiya. ");
INSERT INTO mti_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Asimeve me irawa mu namuwo biroriyane. Me ginanamiwa kum mina yune, sira wape meuma eyawa mina pupuyuiren biroriyane. ");
INSERT INTO mti_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Meve, yauya, me namive Mosisi ge Eraija uwaya Iesu gaibu gae veme. ");
INSERT INTO mti_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita Iesu gumbe wane, Ayapan, nu mapa waketuwa me oraimina. Ge imugap anowawa, ne tent duwamdesi siyampna desirom genan oya, desirom Mosisi oya ge desirom Eraija oya. ");
INSERT INTO mti_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Meve me gae waiviwa, irikup esinewa mu undag umamne. Noiwa irikup danave wane, Mame ne Utunwa nonenmagawa. Ne me gumbe degadega kokavit eni. Me gumbe anoigimiya! ");
INSERT INTO mti_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aigowawa mame anoyawa, mu ginungowa piyu gumbe kwanowa sig a aya. ");
INSERT INTO mti_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Megara Iesu uwag mu yumam wane, Wan yoiya, a den aya. ");
INSERT INTO mti_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mu yangut wan ayawa, bira da den yauya Iesu mekut yauya. ");
INSERT INTO mti_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Meve mu tui gumbe yan aig omomewa, Iesu mu gwangwan dirumne, Apan Usiwa bo gumbe sira inaipeve, ye divi yauyanawa iyayapan dirumiya. ");
INSERT INTO mti_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aigowawa me singui aya, Divi oya Gwangwan toewanewan igiyawa veme Eraija namu uwatanit di? ");
INSERT INTO mti_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iesu garawa wane, Me natawa. Eraija namu uwape. Me dividivi undag waribiyape. ");
INSERT INTO mti_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Megara ne diruitna. Eraija wait uwane, go mu me den yaug anoya sira dividivi undag anoemewa me gumbe aya. Ebu desirom, Apan Usiwa mu nanuwo gumbe dawai autan aivi. ");
INSERT INTO mti_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kum me apa aigowawa yaug anoya me gae dirumiviwa me Babataito Abnawa Jon oya. ");
INSERT INTO mti_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mu iyayapan obiren gumbo uwayawa, apan da Iesu gumbe uwane namive koniwa yune. ");
INSERT INTO mti_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Me wane, Ayapan, ud neuma oya ano wanna. Me bototo ag igetet aivi dawai kokavit anoivi. Me iyam danave kum evedni aigivi sira yoi danave meib aigivi. ");
INSERT INTO mti_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ne me aigo geumawa munan aug onedna, go mu oma den ane warinamiya. ");
INSERT INTO mti_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Iesu garawa wane, Kum gare igiyawa mu anotumat den eme sira danowo siwavit onan. Ne kum anintoi mina guniyap waketna? Ne kum anintoi mina iyagit guniyap waketna? Ud apan me mapa nenan aug onaga. ");
INSERT INTO mti_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iesu airapu kukaeba gumbe gae yusipam dinewa, airapu kukaeba ud apan gumbe dauwag aine. Kum me koniwa apa me inaine. ");
INSERT INTO mti_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Meve aigowawa guwave uwag Iesu singui aya, Divi oya nu oma den ane airapu kukaeba atataitu dauwag aine? ");
INSERT INTO mti_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Me garawa wane, Kuiyawa ye anotumat yeuma me kusi. Ne natawa diruitna. Ye anotumat yeuma gayum yawa kusi mina da ipewa, ye tui mame waya, Biyau asime aga, me biyau aipe. Ye oma ane dividivi undag aya. ");
INSERT INTO mti_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(-) ");
INSERT INTO mti_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mu at Gariri apa undag uwag agoniyayawa, Iesu mu dirum wane, Apan Usiwa ominawa iyayapan nanuwo baraupe. ");
INSERT INTO mti_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mu tope boape, go kum duwamdesiyawa me sira inaig yoipe. Aigowawa undag danadawai kokavit auya. ");
INSERT INTO mti_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesu ge aigowawa at Kapenaum uwayawa, temporu oya anmagawa tameme igiyawa duwam Pita gumbe uwag singui aya, Toewanewan geuma me temporu oya anmagawa barauivi go? ");
INSERT INTO mti_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","E, me aivi, me garawa dirumne. Pita gwe danave unignewa, Iesu namu me gumbe gae wane, Saimon, ge aninin anoege? me singui ane. Piyu kin mumawa bira gumbe nauwawa ge takesi tameme? Kin usitainawa gumbo go iyayapan upeba gumbo? ");
INSERT INTO mti_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita gara wane, Iyayapan upeba gumbo. Iesu dirumne, Usitanawa mu den teya me bainda. ");
INSERT INTO mti_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Megara anopipanum den amunta. Ge awau ag gwambui oya kimai aoreya. Gwambui namu aropawa me auya. Noiwa watapawa anmaga stateru desirom yawa. Me aug aga takesi neumawa ge geumawa oya mu muna. ");
INSERT INTO mti_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Me kumiwa apa aigowawa Iesu gumbe uwag singui aya, Kwimin toimuwawa danave bira kokavit? ");
INSERT INTO mti_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iesu ud kusi da menan auwane onne mu yapowo yoine. ");
INSERT INTO mti_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Sira me wane, Ne natawa diruitna. Ye nonewa den biroriyag ud kusi mame mina den ayawa, ye matai kwimin toimuwawa den di unigiya. ");
INSERT INTO mti_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Meoya, bira da ud kusi mame mina mokona apewa, kwimin toimuwawa danave me kokavitwa ape. ");
INSERT INTO mti_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Sira bira da mame mina ud kusi desirom ne ivunwa gumbe baigan wampewa me baigan neppe. ");
INSERT INTO mti_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Megara bira da ud kusi mame ne gunap anotumat anewa desirom da ano gwambe toyau wampewa, an kokawa me parawa waremewa me meyave tug poeman epampa danave aorepe none nape, me me oya me bainda. ");
INSERT INTO mti_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Piyu mame me kukaeba. Kuiyawa dividivi me iyayapan watkukam munivi. Dividivi kukaeba me ompe, megara apan da dividivi kukaeba munan tam ompewa me kukaeba! ");
INSERT INTO mti_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ge nanigwa gambenwa go amagwa gambenwa gwambe ag ge kukaeba gempewa, me kwagomiyag atan aoreya. Nanigwa desirom ge amagwa desirom gumbe inaiinai danave unigawa me oraimina. Megara nanigwa duwam ge amagwa duwam gaibu iyam meru yaibobot danave aore gempe aigawa me oraimina onan. ");
INSERT INTO mti_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Sira yangagwa ape ge kukaeba a ipewa wapukiyag atan aoreya. Yangagwa desirom gumbe inaiinai danave unigawa me oraimina, megara yangagwa duwam gumbe at kukaeba geena iyam meru danave aore gempewa me oraimina onan. ");
INSERT INTO mti_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ye ud usiusiwa desirom mame yangut yan den yauya. Ne natawa diruitna. Mu aneya muma kwimin danave wakeyawa Maman kwimin danave wakenewa me ginanamiwa evedni yaveme. ");
INSERT INTO mti_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(-) ");
INSERT INTO mti_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ye aninin anoene? Apan da sip undag 100 tamne. Mu yapowo desirom dauwag aine. Me sip undag 99 tui kusiwa aiviwa kwem me dauwag aig desirom me kwawanewa diupe, go onan? ");
INSERT INTO mti_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sira ne natawa diruitna. Mae sip desirom me kwawanewa sira me yaupewa degadega kokavit ape. Undak 99 den kwawayawa oya degadega meuma me kusi. ");
INSERT INTO mti_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ebu desirom, ye Mamewa kwiminauwa me den anoivi ud kusikusi mame mina desirom da kwawape. ");
INSERT INTO mti_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tatagwa ge gungap kukaeba apewa, menan aga me kukaeba meuma toewana, me ye duwam yekut danave. Ge nogwa me aupewa, ge tatagwa sira auwa. ");
INSERT INTO mti_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Megara, me ge nogwa den aupewa, ud da desirom go duwam tam aga. Iyayapan duwam go duwamdesi yoig gae taibe wapewa dividivi anewa undag wat kiniyape. ");
INSERT INTO mti_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sira, me gae muma den aupewa, siosi igiyawa diruma. Me siosi noiwa den aupewa, ge Ju onan igiyawa go takesi tameme igiyawa gumbo a mina gumbe ape. ");
INSERT INTO mti_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ne natawa diruitna. Ye divi da piyu egave tuyawa kwimin danave meib tupe, sira divi da ye piyu egave vesiyawa kwimin danave vetpe. ");
INSERT INTO mti_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Sira ne diruitna. Ye duwam piyu egave divi da ye nonewa desirom nun wayawa, Maman kwiminauwa yenan me ape. ");
INSERT INTO mti_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Kuiyawa apan duwam go duwamdesi ne ivunwa gumbe onam agoniyapewa, ne mu gaibu. ");
INSERT INTO mti_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Meve Pita Iesu gumbe uwag singui ane, Ayapan, tatanwa gunap kukaeba apewa koni animpo mina anog yankwetna? Koniwa undag 7 mina? ");
INSERT INTO mti_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iesu garawa wane, Ne diruitna. Koniwa undag 7 mina onan, koniwa undag 77 mina. ");
INSERT INTO mti_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Meoya, kwimin toimuwawa me piyu kin mumawa mina. Me nau meuma emewa gumbo garawa meuma autan anone. ");
INSERT INTO mti_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Me amatog garawa meuma sira tamnewa, apan da anmaga 10,000 tarant nun wag aunewa menan aug onne. ");
INSERT INTO mti_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Me garawa oma den anewa, kokawa meuma dig wane me ge biviwa sira usitainawa meumawa undag gwiruwag nog me garawa tobotpe. ");
INSERT INTO mti_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nau meuma aiviwa me namive koniwa yune. Me nun wane, Gunap yaimoyai amara, sira ne matai dividivi garawa undag geuma atna. ");
INSERT INTO mti_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nau aiviwa kokawa meuma danadawai me gumbe aune, garawa togomiyane sira me kwene aine. ");
INSERT INTO mti_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Megara nau meuma aiviwa dauwag aine, me nau gaibu emewa desirom, me anmagawa 100 denari me gumbe nog den tobodnewa yaune. Me apan me yum meyawa wabottan ane. Me dig wane, Nog garawa den anawa nega. ");
INSERT INTO mti_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nau aiviwa eveba namive konive yug nun wane, Gunap yaiyai amara. Ne matai garawa geuma atna. ");
INSERT INTO mti_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Megara me den anone. Me aine sira apan me nog danave baraune. Garawa meuma baraupeve nog dana dauwape. ");
INSERT INTO mti_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nau eme igiyawa upeba me aninin veniyane yauyawa, mu tet kokavit aya, sira amok kokawa muma dividivi veniyanewa undag diya. ");
INSERT INTO mti_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Meve kokawa muma nau aivi abnawa menan auwane me wane, Ge nau aivi abnawa kukaeba. Ge nenan nun wana meoya ne nog geuma undag togomiyana. ");
INSERT INTO mti_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ge nau evegwa gumbe danadawai aupa. Kuiyawa ne ge gungap danadawai auna mina di. Megara ge den auwana. ");
INSERT INTO mti_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kokawa meuma danapiriwane, me nog amareme igiyawa gumbo nanuwo baraune, meve me nog garawa meuma undag baraupeve, sira me taibe dauwape. ");
INSERT INTO mti_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ye tateaiwa nonewa gumbe den anog yankweyanawa, Maman neuma kwiminauwa ye desirom desirom guniyap ma meib aiyempe. ");
INSERT INTO mti_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesu dividivi gaiyawa wane onananewa, me at Gariri kwene sira yoi Jodan visi gambenwa aine at Judia danave unigne. ");
INSERT INTO mti_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iyayapan obiren me amave amiya, sira me asimeve mu warinamumne. ");
INSERT INTO mti_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Parisi igiyawa upeba me gumbe uwag amaorot awaniya. Mu singui aya, Natawa divi da wakepewa apan me biviwa yankwepe, me Gwangwan gumbe bainda? ");
INSERT INTO mti_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Me garawa wane, Ye den basiyana? Wait namu piyu wadne abnawa me apan ge vesin gaibu wadne, ");
INSERT INTO mti_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","sira wane, Kuiyawa mame oya, apan mamawa ge inawa yankwe munke biviwa gumbe yunatpe, sira mu duwam kwapuwa desirom ape. ");
INSERT INTO mti_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Meoya mu duwam onan mu desirom. Meoya God toboranewa apan oma den ane tam ubeube tepe. ");
INSERT INTO mti_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Mu singui aya, Divi oya Mosisi gwangwan wane, memgebip garakue oya vesin yankwetan gigirumawa teg wana kwegem vesin aipe? ");
INSERT INTO mti_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Iesu garawa wane, Mosisi vesin yeuma yan kwektanwa bainda wane kuiyawa ye nonewa yaigiwa dadi. Megara wait namuiren apa ebu me meib onan. ");
INSERT INTO mti_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne diruitna, biviwa me apan da gaibu den vinne go memawa me yankwepe sira vesin da ube aupewa me uinantaraki. ");
INSERT INTO mti_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aigowawa me diya, Apan ge vesin yapowo inaiinai muma mamaib minawa, memgebip den apewa me oraimina go? ");
INSERT INTO mti_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iesu garawa wane, Iyayapan undag oma den ane gae mame aupe. Upeba mukut oma ane me aupe. ");
INSERT INTO mti_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kuiyawa upeba mu mamaraga meib yaiya. Upeba iyayapan gumbo mamaraga aya. Sira upeba kwimin toimuwawa oya memgebip den ape. Apan da bira gae mame aupe oma apewa me aupe. ");
INSERT INTO mti_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Meve ud usiusiwa Iesu gumbe tam uwaya, me naniwa gumbo tek munan nun watan oya. Megara aigowawa munan diguragut aya. ");
INSERT INTO mti_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Iesu wane, Ud usiusiwa yan kwemiya nenan onampe, sira mu den toboriya. Kuiyawa kwimin toimuwawa iyayapan meiba mu mumawa. ");
INSERT INTO mti_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Me naniwa gumbo baraunewa, me asime apa aine. ");
INSERT INTO mti_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Me kumive apan da Iesu gumbe uwag singui ane, Toewanewan, ne oraiwa divi akape inaiinai yaibobot auten? ");
INSERT INTO mti_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iesu garawa wane, Oraiwa divi oya ge singui negege? Oraiwa me God mekut. Ge inaiinai uniktan anowawa, gwangwan noiwa avigima. ");
INSERT INTO mti_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Me ambuwa? apan me singui ane. Iesu garawa wane, Den toingura, uinantaraki den a, ub den a, gae ugauga den wa, ");
INSERT INTO mti_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mamag ge inag ebnotu aigima, sira ge iyayapan baigan munigima ge gembo baigan niege mina. ");
INSERT INTO mti_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Apan mataiwa wane, Ne undag mame amareni. Ne ambuwa sira aten? ");
INSERT INTO mti_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iesu garawa wane, Ge oraivit atan anoegewa, aga, dividivi geuma gwiruwara tawara onan igiyawa muna, sira oraiwa geuma kwimin danave teya. Meve amanap onaga. ");
INSERT INTO mti_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apan mataiwa me mame anonewa, danadawai gumbe me aine, kuiyawa me tawara kokavit gaibu. ");
INSERT INTO mti_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Meve Iesu aigo meuma dirumne, Ne natawa diruieni. Tawara abnawa kwimin toimuwawa danave uniktanwa me yaigiwa dadi. ");
INSERT INTO mti_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sira ne diruieni. Mae kameru inup nogawa uniktanwa me taibe, megara tawara abnawa God toimuwawa danave unikpewa me yaigiwa dadi. ");
INSERT INTO mti_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aigowawa gae mame anoyawa, mu tet kokavit aya sira singui aya, Bira da oma ane waita aupe? ");
INSERT INTO mti_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Iesu yangut yawam dirumwane, Apan me gumbe mame den oma ane, megara God dividivi undag me gumbe oma ane. ");
INSERT INTO mti_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita me garawa wane, Nu dividivi undag yankweg amagap ongete! Nunan divi? ");
INSERT INTO mti_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iesu mu dirumwane, Ne natawa diruieni, dividivi undag mataiwa biroriyape, Apan Usiwa eyawa seya egave wakepewa, ye bira da amanap oneyawa sira kin seyaiba 12 egave wakeg Isuraeru dam mumawa 12 mu amaraya. ");
INSERT INTO mti_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Sira iyayapan undag bira da gwe meuma, tatawaiwa, yogeyawaiwa, mamawa, inawa, usitainawa go nau meumawa ne ivunwa oya kwepewa, garawa undag koni 100 mina aupe, sira inaiinai yaibobot matai aupe. ");
INSERT INTO mti_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Megara iyayapan obiren namu yoiemewa mu ivi ape, sira ivi yoiemewa mu namu ape. ");
INSERT INTO mti_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kwimin toimuwawa me mamaib. Piyu abnawa mumbevit iyayapan upeba bope greip nauwawa meuma wattan oya dauwag aine. ");
INSERT INTO mti_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Me ung wane garawa muma kum desirom desirom anmaga 1 denari mumpe, meve me greip nau meuma danave tene amiya. ");
INSERT INTO mti_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kum koniwa 9 mina avinewa, me dauwag aine iyayapan upeba gwiruwaremewa arawa danave ui onan yokeg gigemewa yawamne. ");
INSERT INTO mti_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me mu dirumne, Ye gaibu aisiya greip nau neuma danave nau aya, sira ne garawa yeuma noi omavit yentna. ");
INSERT INTO mti_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Mu amiya. Me sira dauwag aine kum koniwa 12 mina sira kum koniwa 3 mina meib sira gina desiroma ane. ");
INSERT INTO mti_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kum koniwa 5 mina me dauwag aine iyayapan upeba ui onan yoiyag gigeme yawamne. Me singui munne, Ye divi oya kum undag mapa ui onan yoiyag gigene, kum aigivi? ");
INSERT INTO mti_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kuiyawa bira da nu den tamanne, mu garawa waya. Me mu dirumwane, Ye gaibu aisiya greip nau neuma danave nau aya. ");
INSERT INTO mti_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","At augoi uwag onnewa, greip nauwawa abnawa nau meuma ankwatavewa dine, Nau igiyawa diruma onampe garawa muma bope, namuiren ivi bone igiyawa tampe sira namu bone igiyawa ivi tampe. ");
INSERT INTO mti_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kum koniwa 5 mina bone igiyawa uwag anmaga noi omavit garawa 1 denari muma auya. ");
INSERT INTO mti_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nau igiyawa namu bonewa uwayawa, mu anoya garawa muma kokavit aupe. Megara mu desirom desirom garawa muma noi omavit boya. ");
INSERT INTO mti_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mu garawa muma auyawa, mu amatog piyu abnawa gumbe diguraguraya. ");
INSERT INTO mti_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mu waya, Apan mame ivi bonewa mu kum koniwa desirom mekut nau aya. Nu kum gare kum amiwa danave nau kokavit atu, megara ge no iomavit mu gaibu garawa nunana. ");
INSERT INTO mti_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Megara mu da desirom gumbe me garawa wane, Enda, ne ge gungap anokukam den ana. Ge 1 denari gumbe nau atan oya ge ung wana, go onan? ");
INSERT INTO mti_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Garawa geuma aug aga. Ne apan ivi bonawa garawa muma gina desirom ge gennawa mina muntan eni. ");
INSERT INTO mti_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ne natawa eni dividivi neumawa gumbe anin aten. Megara ye gigirene, kuiyawa ne keb abnawa? ");
INSERT INTO mti_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Meoya ivi me namu yoipe sira namu me ivi yoipe. ");
INSERT INTO mti_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gare Iesu Jerusarem dog ainewa, me aigowawa 12 tamne megiyave teg mu dirumne, ");
INSERT INTO mti_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Nu at Jerusarem angete, sira Apan Usiwa matai pirisi koukawa ge Gwangwan toewanewan igiyawa gumbo anavi ape. Mu me bo atan oya dima yug baraupe, ");
INSERT INTO mti_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","sira aug Ju onan igiyawa gumbo baraupe, iyagau ape, murap gumbe tope meve yoma korosi gumbe tope boape. Kum duwamdesi danave me inaig sira yoig uwape. ");
INSERT INTO mti_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Meve Jebedi usitainawa inawa usitanawa gaibu Iesu gumbe uwaya, sira koniwa yug me oraiwa oya singui ane. ");
INSERT INTO mti_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ge divi oya anoege? Iesu singui ane. Vesin me wane, Agi didnega. Utunwa duwam mame toimu geuma danave dawa nanigwa yutanwa apa sira dawa nanigwa ketaiwa apa wakepe. ");
INSERT INTO mti_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ye singui yeumawa ye den yaug anoyana, Iesu mu dirum wane. Ne ap mame yoi natnawa ye oma ane naya? Nu oma ane nata, mu garawa waya. ");
INSERT INTO mti_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Iesu mu dirum wane, Ye oma ane ap neuma gumbe yoi naya, megara naninwa yutan go ketai apa wakepewa me ne agi den diruitna. Ne Maman gumbe at mame me iyayapan munan waribiyane. ");
INSERT INTO mti_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aigowawa 10 gae mame anoyawa, mu tatagwane duwam gumbo diguragut aya. ");
INSERT INTO mti_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iesu undag agoniyag munan auwane sira dirumne, Ye yaug anoyana Ju onan igiyawa yusiwa muma iyayapan gumbo kokavit eme, sira namuyoiyoi igiyawa mu yutuwa painauvit iyayapan gumbo eme. ");
INSERT INTO mti_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Megara ye gaibu onan. Ye bira da ye guniyap kokawa atan anoyawa me iyayapan ankwatowo nau aya, ");
INSERT INTO mti_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","sira bira da namuyoiyoi atan oya anoiviwa, me nau geuma ankwatave aiviwa atanit di. ");
INSERT INTO mti_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Apan Usiwa iyayapan nau meuma atan oya den aig onne, megara me iyayapan munan nau atan oya sira inaiinai meuma wampe iyayapan obiren kukaeba muma oya garawa atan oya aig onne. ");
INSERT INTO mti_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iesu ge aigowawa at Jeriko kweg amomewa, iyayapan obiren amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Apan yanga bored duwam ebu megiyave yan wakeeme, sira mu anoya Iesu uwag aivi, mu auwaya, Ayapan, Devid Usiwa, ano nunigima! ");
INSERT INTO mti_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iyayapan obiren gae yankwetan dirumwaya, megara mu kwat kokavit gerave gerave waya, Ayapan, Devid Usiwa, ano nunigima! ");
INSERT INTO mti_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iesu tumag yoig munan auwane. Ye nenan divi oya anoene yenan divi atna? me singui munne. ");
INSERT INTO mti_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ayapan, mu garawa waya, Nu yan gut atan anoete. ");
INSERT INTO mti_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iesu mu gumbo danadawai aune sira yangowa yumne. Tatevit mu yangowa oraimina aya sira me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mu at Jerusarem uweme tui Orivu kuiyave at Betepage uwayawa, Iesu aigowawa duwam tene amiya, ");
INSERT INTO mti_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","mu dirum wane, Gwetoimu asime aisiya, sira meve mae donki ge donki usiwa tuwamiyawa yawamiya. Murap vet tam nenan oneya. ");
INSERT INTO mti_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Apan da divi da yenan wapewa, me diya, Ayapan imiwa munan anoivi, sira me tatevit yempe oneya. ");
INSERT INTO mti_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Mame propeta gumbe gae wanewa natawa uwane: ");
INSERT INTO mti_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saion gwaitawa diya, Yawa, kin yeuma yenan uwaivi, me memeyu gumbe mae donki egave onivi, mae donki usiwa me tawara bog oniviwa me egave dauwag onivi. ");
INSERT INTO mti_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aigowawa amog Iesu aninin dirumnewa mu aya. ");
INSERT INTO mti_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mu donki ge donki usiwa gaibu tam uwaya, wape geravewa muma egave teya, sira Iesu dauwag egave wakene. ");
INSERT INTO mti_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iyayapan obiren wape muma ebu taibe, upeba bayan kwayawa kwab ebu taibe yupamiya. ");
INSERT INTO mti_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iyayapan namu menan amiyawa, sira upeba amave omomewa au ge kwaru veme, Osanna, Devid Usiwa gumbe! Ayapan iviwa gumbe uwaiviwa, me gumbe waribiya wakeigimpe! Osanna at painauiren danave! ");
INSERT INTO mti_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iesu Jerusarem unignewa, gwetoimu undag terake singui aya, Mame me bira? ");
INSERT INTO mti_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iyayapan undag garawa waya, Mame Iesu, propeta, Gariri danave at Nasaret apa onne. ");
INSERT INTO mti_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iesu temporu arawa unignewa, iyayapan undag mu gwiruwaremewa ge garawa emewa amatog atatai imne dauwag amiya. Me teboro me anmaga biroriyag auemewa sira umuk gwiruwaremewa undag aug tobiyane. ");
INSERT INTO mti_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Me dirumwane, Gigirum tene. Gwe neumawa me wape nun gweyawa, megara ye ene me yuaore toaore igiyawa dagup muma mina aivi. ");
INSERT INTO mti_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Temporu danave yanga bored igiyawa ge amo kukaimusiawa me gumbe uwaya sira mu warinamunne. ");
INSERT INTO mti_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Megara pirisi kokawa ge Gwangwan toewanewan igiyawa yauya Iesu dividivi oraiwa anewa yauya sira temporu arawa danave yauya ud usiusiwa augek kwarueme, Osanna Devid Usiwa gumbe. Mu danowo piriwane. ");
INSERT INTO mti_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mu singui aya, Ud torawa mame dimbae vemewa ge anoege? E, Iesu garawa wane, Ye den basiyayana? Ud torawa ge kikiyan nouwa gumbe ge waiya waiya oraivit tamibarip ana. ");
INSERT INTO mti_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sira me kwem at toimu Betani dauwag aine. Asimeve me vinne. ");
INSERT INTO mti_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Umae wanteigimpe mumbevit gwetoimu taig oniviwa ebu taibe me iyagon adne. ");
INSERT INTO mti_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yoma inaru ebu visive yaune, me gumbe uwane, megara yoma egave divi da den yaune kwayawa mekut yaune. Meve me dig wane, Ge natawa sira den impe! Tatevit yoma inaru toyaine. ");
INSERT INTO mti_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Aigowawa mame yauyawa, mu teraya. Yoma inaru mame aninin ag tatevit toyaine? mu singui aya. ");
INSERT INTO mti_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iesu garawa wane, Ne natawa diruieni. Ye anotumat guniyap wakepewa sira den pipamgisia, yoma inaru gumbe pawanewa ye oma ane aya, megara me mekut onan, sira ye tui mame dig waya, Aga, gembovit poeman danave aiga, sira meib atanit di. ");
INSERT INTO mti_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ye anotumat ayawa, ye nun yeuma gumbe wayawa matai me auya. ");
INSERT INTO mti_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iesu temporu arawa unigne, sira me toyau muniviwa, pirisi koukawa ge namu yoiyoi igiyawa me gumbe uwaya, sira mu singui aya, Ge dividivi mame egewa divi yusiwa gumbe ege? Sira yutugwa mame bira genne? ");
INSERT INTO mti_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iesu garawa wane, Ne singui desirom yentna. Ye garawa didnegiyawa, ne matai ye diruitna ne dimbae yusiwa gumbe dividivi mame eni. ");
INSERT INTO mti_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jon Babataito meuma me ampa uwane? Me kwiminau aig onne, go iyayapan gumbe uwane? Mu mumbovit gae wageyau aya, sira waya, Me kwiminau aig onne nu watawa, me matai singui ape, Me divi oya me gumbe anotumat den ayana? ");
INSERT INTO mti_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iyayapan gumbe onne nu aib watawa, nu iyayapan gumbo a ete, kuiyawa mu undag anotumat eme Jon me propeta da. ");
INSERT INTO mti_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Meoya mu Iesu garawa dig waya, Nu den yaug anotu. Meve Iesu mu dirumwane, Ne mina den diruitna ne dimbae yusiwa gumbe dividivi mame eni. ");
INSERT INTO mti_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ye aninin anoene? Apan da me ud duwam. Me aig ud namuwa gumbe dine, Ud, gare aga greip nauwawa danave nau wara. ");
INSERT INTO mti_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Me garawa wane, Ne topai, megara ivi me kuiyawa tobiyane nau aine. ");
INSERT INTO mti_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Meve mamawa usiwa dawa gumbe aig gae desiroma dine. Me garawa wane, Maman ne atna, megara me den aine. ");
INSERT INTO mti_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ud duwam ambuwa mamawa anoiviwa ane? Namuwa, mu garawa waya. Iesu mu dirumwane, Ne natawa diruieni. Takesi tameme igiyawa ge uinantaraki vesinawa mu God toimuwawa namuyap unigeme. ");
INSERT INTO mti_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kuiyawa Jon guniyap uwane ebu oraiwa toyauyenne, megara ye me gumbe anotumat den ayana. Megara takesi tameme igiyawa ge uinantaraki vesinawa anotumat aya. Sira ivi mame yauyanawa, ye nonemagewa den biroriyayana sira anotumat me gumbe den ayana. ");
INSERT INTO mti_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Maibe dawa yaiyai anoya. Piyu abnawa me yoma greip vedne. Me si birorot tune, nau danave wain oya dukup wadne, sira amaratan gweyawa sine. Meve me nau wareme igiyawa upeba gumbo greip nau meuma amaratan oya dirumne aramawa aine. ");
INSERT INTO mti_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maura kumiwa uwanewa, nau amareme igiyawa gumbo natawa botan oya me nau meuma eme igiyawa tene amiya. ");
INSERT INTO mti_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nau amareme igiyawa mu nau meuma eme igiyawa wa tam desirom toya, dawa toya boine; sira duwamdesiyawa an gumbe toya. ");
INSERT INTO mti_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sira me nau meuma eme igiyawa da tene munan amiya. Mu namuwa mina onan me obiren tene amiya. Sira nau amareme igiyawa ebu desirom mu gumbo aya. ");
INSERT INTO mti_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Oieba, me usiwa munan baraune aine. Me wane, Mu matai ne utunwa ebnotu wampe. ");
INSERT INTO mti_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Megara nau amareme igiyawa mu usiwa yauyawa, mu mukut gara wa ano aya, Mame at piyu me matai kwan aupewa. Anta, me toin gutta boipe at piyu meuma nu auta. ");
INSERT INTO mti_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Meoya mu me auwag greip nauwawa si daieve aoreya me toya boine. ");
INSERT INTO mti_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Meoya greip nauwawa kuiya mamawa uwanewa, me nau amareme igiyawa gumbo aninin ape? ");
INSERT INTO mti_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mu garawa waya, Me matai kukaeba igiyawa undag gutpe boriruwape, sira me matai greip nauwawa meuma nau amareme igiyawa da amarape. Mu maura kumiwa natawa me gumbe matai wampe. ");
INSERT INTO mti_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iesu mu dirum wane, Ye Baiboru den basiyana? An me gwe sisi igiyawa topayayawa me an natawa oraivitwa me visidonawa apa teyawa ane. Mame Ayapan ane, nu yangunup yautunewa me oraimina me da den kukaine. ");
INSERT INTO mti_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Meoya ne diruitna. God toimuwawa me matai ye guniyap atan aupe, sira iyayapan bira yaiyai yoma magawa danowo natawa impewa mu mumpe. ");
INSERT INTO mti_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Bira da an mame egave aikpewa me dumetpe musimusi ape, sira an mame me apan da egave aikpewa apan mame matai musimusi ape. ");
INSERT INTO mti_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pirisi koukawa ge Parisi igiyawa mu Iesu maibe gumbe wane anoyawa, mu yaug anoya me gae mu gumbo waivi. ");
INSERT INTO mti_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Mu me yum autanwa ebu didimama eme, megara mu iyayapan munan a aya, kuiyawa iyayapan mu yaug anoya Iesu me propeta. ");
INSERT INTO mti_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iesu sira maibe gumbe mu dirumne. ");
INSERT INTO mti_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Kwimin toimuwawa me kin me usiwa meuma memgebip buyunai tamibarip aivi mina. ");
INSERT INTO mti_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Me nau meuma aiviwa tene amiya iyayapan buyunai munan ep tenewa uwape, megara mu topayag den onamiya. ");
INSERT INTO mti_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Meve sira me nau usiwa meuma upeba tene amiya sira wane, Iyayapan munan ep tenawa dirumiya, Ne augoi nakwaeba neuma wait tamibarip ana, burumakau apan neumawa sira mae me kadnawa koka gaibu wait gattona, sira dividivi undag wait waribiyana. Memgebip buyunaeba oneya. ");
INSERT INTO mti_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Megara mu gae meuma den auya, sira mu amiya. Desirom nau meuma aine, dawa anmaga nauwawa aine. ");
INSERT INTO mti_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iyayapan upeba nau meuma aiviwa yumamiya, wakukam muniya sira guriya boriruwaya. ");
INSERT INTO mti_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kin me danapiriwane. Me mut igiyawa meuma tene amiya, sira iyayapan kaninga guriyawa me guriya sira gwetoimu muma iyam okeriya idne. ");
INSERT INTO mti_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Meve me nau meuma aiviwa dirumwane, Memgebip buyunai nakwaeba me wait waribiyatu, megara iyayapan ne ep munan tenawa mu oma den ane buyunai oya. ");
INSERT INTO mti_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ebu kokawa aisiya sira bira da undag ye yauyawa ep teya buyunai nakwaeba onampe. ");
INSERT INTO mti_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Meoya nau meuma emewa ebu taibe amiya iyayapan undag mu yawamiyawa agoniyag tam onamiya. Mu iyayapan oraiwa ge kukaeba igiyawa. Mu uwag buyunai arawa noi dauwane. ");
INSERT INTO mti_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Megara kin dauwag munan wanewa igiyawa yawamnewa, me apan da memgebip wapeyawa den ennewa me yaug anone. ");
INSERT INTO mti_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Me singui ane, Enda, ge memgebip wapeyawa den enkapa ge aninin unigana? Apan me noi onan wakene. ");
INSERT INTO mti_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Meve kin me nau eme igiyawa dirumwane, Me naniwa ge amawa murap tuya, sira me daieve aoreya, sisip danave wakepe, asimeve me iruwaigimpe donawa kitosaigimpe. ");
INSERT INTO mti_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Obiren munan ep tene, megara duwamit tamne. ");
INSERT INTO mti_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Meve Parisi igiyawa dauwag amiya, Iesu gae meuma gumbe me amawa ororiyatan oya gae yuya. ");
INSERT INTO mti_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mu aigo muma teya iyayapan mu dam iviwa Erod danave wakeyawa gaibu Iesu oya amiya, sira mu waya, Toewanewan, nu yaug anotu ge gae natawa vege, sira ge God ebuwawa natawa gumbe toyau nunege. Ge iyayapan gumbo a den ege, kuiyawa ge munan den anoege mu bira. ");
INSERT INTO mti_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Did nuna anota, ge imugap aninin? Siisa gumbe takesi barauta me oraimina go onan? ");
INSERT INTO mti_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Megara Iesu imu danowo yaug anone me wane, Ye ugauga vene igiyawa, ye divi oya ne ugai negatan ene? ");
INSERT INTO mti_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Anmaga me ye takesi oya garawa atanwa me toyau negiya. Mu anmaga 1 denari menan aug onamiya, ");
INSERT INTO mti_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","sira me singui munne, Mame bira ginanamiwa ge bira iviwa? ");
INSERT INTO mti_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mu garawa waya, Me Siisa meuma. Meve me dirumwane, Meoya Siisa meumawa me Siisa waniya, sira God meumawa me God waniya. ");
INSERT INTO mti_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mu gae mame anoyawa, mu teraya. Meoya mu yankwek amiya. ");
INSERT INTO mti_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadusi igiyawa mu anog veme iyayapan boriruwapewa sira den inaipe. Kum desiroma apa, mu Iesu gumbe uwag singui aya. ");
INSERT INTO mti_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Mu waya, Toewanewan, Mosisi wane, Apan da me ud onan me boipewa, gwaneba me tatawa kwapuraeba aupe meve mu ud da aupe. ");
INSERT INTO mti_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Gare nu tatanaiwa undag 7. Tatawa namuwa vesin aug me boane, ud onan, me biviwa kwene gwaneba vesin me aune. ");
INSERT INTO mti_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Gwaneba duwameba ge duwamdesiyawa aig onne undag 7 gumbo ebu desiroma meib sira aya. ");
INSERT INTO mti_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Oieba, vesin me boane. ");
INSERT INTO mti_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Gare mu boriruwaya sira mu yoipewa kumiwa apa, vesin me undag 7 danave bira biviwa ape, kuiyawa mu undag vesin me auya? ");
INSERT INTO mti_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iesu garawa wane, Ye anopipanum ene, kuiyawa Baiboru ge God yusiwa den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iyayapan boriruwape sira yoipe kumiwa apa, apan vesin den aupe, sira vesin apan den aupe, kwimin danave mu matai aneya mina wakepe. ");
INSERT INTO mti_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Megara bo igiyawa sira yoipewa me gumbe God yenan anin wanewa den basiyana, ");
INSERT INTO mti_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ne Ebraam God meuma, Aisak God meuma, sira Jekob God meuma. Me bo igiyawa God muma onan, megara me kaninga wakeemewa God muma. ");
INSERT INTO mti_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iyayapan mame anoyawa, mu Iesu toyau toyau meuma gumbe teraya. ");
INSERT INTO mti_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iesu Sadusi igiyawa nouwa tobodnewa Parisi igiyawa anoyawa mu onam agoniyaya. ");
INSERT INTO mti_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mu danave apan desirom me gwangwan gumbe ano kokavitwa me amawa ororiyag Iesu gumbe singui ane: ");
INSERT INTO mti_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Toewanewan, Gwangwan undag me danave gwangwan ambuwa me kokavitwa? ");
INSERT INTO mti_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iesu garawa wane, Nonegmagawa undag gaibu, guwawa geuma undag gaibu, imugwa undag gaibu, Ayapan God geuma gumbe baigan a. ");
INSERT INTO mti_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Mame gwangwan namuirenwa ge gwangwan kokavitwa. ");
INSERT INTO mti_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Sira duwameba me mamaib, Ge iyayapan baigan munigima ge gembo baigan niege mina. ");
INSERT INTO mti_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gwangwan undag ge Propeta undag, gwangwan duwam mame ankwatave wakeya. ");
INSERT INTO mti_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi igiyawa undag agoniyayawa, Iesu me singui munne, ");
INSERT INTO mti_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ye Keriso oya aninin anoene? Me bira usiwa? Mu garawa waya. Devid usiwa. ");
INSERT INTO mti_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Me mu dirum wane, Me aninin, Devid me Guwawa Iyakaisiyapama gumbe gae waivi me auwane Ayapan, ");
INSERT INTO mti_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ayapan me Ayapan neuma dig wane: Nanin yutanwa apa wakeigima, ivi ne anavi geuma amag danawa ankwatave tetna. ");
INSERT INTO mti_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devid me Keriso gumbe Ayapan waiviwa, me aninin Devid usiwa? ");
INSERT INTO mti_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Bira da Iesu gumbe garawa den watan anoya. Me kum me apa man onne bira da Iesu gumbe singui da watan den anone. ");
INSERT INTO mti_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Meve Iesu iyayapan ge aigowawa dirumwane: ");
INSERT INTO mti_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Gwangwan toewanewan igiyawa ge Parisi igiyawa Mosisi seya meuma gumbe wakeya. ");
INSERT INTO mti_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Meoya ye ebnotu muniya, sira mu ye diruyempewa dividivi undag aya. Megara mu emewa ye den aya, kuiyawa mu opata emewa den ageyau aya. ");
INSERT INTO mti_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mu tawara ibnapam tuvek sira iyayapan oiewo teeme, megara mu mumbovit nanuwo desirom da den aug baraupe mu den ipunatan anoeme. ");
INSERT INTO mti_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Mu dividivi emewa me iyayapan yawamtan oya. Mu Baiboru gigirumawa teg tameg enatanwa bokesiyawa pepetu ape, sira mu wape ginawa muma dararogu yobuyobu dumeme; ");
INSERT INTO mti_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","mu buyunai nemewa ayamat arawa waketan anoeme, sira sinagogu danave seya painauwa waketan anoeme, ");
INSERT INTO mti_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","mu gwiruwaremewa arawa apa iyayapan gumbo baigan autan anoeme, sira iyayapan mu Rabai wape mu anoeme. ");
INSERT INTO mti_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Megara iyayapan gumbo ye Rabai den waya, kuiyawa ye Kokawa yeuma desirom mekut sira ye undag tatawaiwa. ");
INSERT INTO mti_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Sira bira da piyu egave Maman den wape, kuiyawa ye Mameiwa me desirom me kwimin danave wakenewa. ");
INSERT INTO mti_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iyayapan gumbo Toewanewan den waigimiya, kuiyawa ye toewanewan yeuma me desirom, me Keriso. ");
INSERT INTO mti_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ye guniyap kokavitwa me nau yeuma aivi abnawa. ");
INSERT INTO mti_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kuiyawa bira da membovit me kokawa atan anopewa me iviwa yan aug aikpe, sira bira da membovit mokona apewa me kokawa ape. ");
INSERT INTO mti_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ye ano kukaeba guniyap! Gwangwan toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye kwimin toimuwawa iyayapan ginongowa toborene. Ye yembovit den unigiya, sira ye tobod muniya iyayapan mu uniktan oya ageyau emewa. ");
INSERT INTO mti_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ye kukaeba, ye Gwangwan toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye kwapura gweyowo gumbo dividivi undag naborene, sira iyayapan yau yemtan oya nun yobutatae vene. Meoya ye matai ibnawa kokavit auya. ");
INSERT INTO mti_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ye ano kukaeba guniyap! Toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye anotumat tobiroriyanewa desirom da autan oya at undag sira poeman undag aisene, sira apan desirom auyanawa, ye ene apan mame geena usiwa mina, apan mame kukaeba meuma egave sira aivine, ye me mina onan. ");
INSERT INTO mti_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ye ano kukaeba guniyap! Yango boredmusiawa amat muma igiyawa! Ye wayana, Apan da temporu gumbe agi wapewa, me natawa onan; megara apan da temporu gooru meuma gumbe agi wapewa, me gumbe tupe agi meuma atanit di. ");
INSERT INTO mti_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ye nokonoko igiyawa yange boredmusia! Me kokawa ambuwa, gooru go temporu me gooru iyakaisi apewa? ");
INSERT INTO mti_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ye sira wayana, Bira da iyakaisi kem meuma gumbe agi wapewa, natawa onan; megara bira da me egave puyo gumbe agi wapewa, me agi meuma tupe. ");
INSERT INTO mti_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ye yangewa boredmusia igiyawa! Me ambuwa natawa koka, puyo go iyakaisi kem meuma me puyo iyakaisi apewa? ");
INSERT INTO mti_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Meoya, bira da me iyakaisi kem meuma gumbe agi wapewa me me gumbe sira me egave dividivi undag gumbe agi wape. ");
INSERT INTO mti_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Sira bira da temporu gumbe agi wapewa me gumbe sira me danave wakenewa gumbe agi wape. ");
INSERT INTO mti_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Sira bira da me kwimin gumbe agi wapewa, me God seya meuma gumbe sira me egave wakenewa gumbe agi wape. ");
INSERT INTO mti_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ye ano kukaeba guniyap! Gwangwan toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye mint, diru, ge kumin undag naninwanit danave kebag desirom God gumbe puyo wanene. Megara ye Gwangwan kokawa obiren oraiwa, ano wanigimtan ge anotumat emewa mu ye topaiene. Ye gae iviwa oraiwa, ano wanigimtan ge anotumat emewa ageyau atanit di, megara gae namuwa gaibu anoigimiya. ");
INSERT INTO mti_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ye yangewa boredmusiawa toyaumuneme igiyawa! Ye yoi kondowin siya musimusi dauwag ampe megara mae kameru ipatpe. ");
INSERT INTO mti_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ye ano kukaeba guniyap! Gwangwan toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye ap ge en daiewa muinene, megara danavewa miyot umamne, dividivi tamtanwa ge mukut mukut noidauwane. ");
INSERT INTO mti_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi igiyawa yangewa boredne! Namu ap ge en danawa muin waribiyaya, sira meve matai daiewa gaibu oraimina ape. ");
INSERT INTO mti_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ye ano kukaeba guniyap! Gwangwan toewanewan igiyawa ge Parisi igiyawa! Ye ugauga enewa! Ye yanpot puipuyu wariya mina, daiewa yautanwa oraimina, megara danave iyayapan boriruawayawa marednawa ge miyotawa undag noidauwane. ");
INSERT INTO mti_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ebu desiroma, daieve gumbe iyayapan yangowo ye oraimina, megara ye daneyap ugauga enewa ge ano gwambe enewa noidauwane. ");
INSERT INTO mti_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ye ano kukaeba guniyap! Gwangwan toewanewan igiyawa ge Parisi igiyawa, ye ugauga enewa! Ye yanpot siya propeta munan, sira oraiwa igiyawa irayauyau muma ben wariyana. ");
INSERT INTO mti_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sira ye wayana, Nu upanaiwa kumiwa apa wakeponowa, nu mu gaibu den apono propeta di muma aignewa. ");
INSERT INTO mti_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sira ye yembovit vene, ye iyayapan mu propeta kaninga guriyawa usitainawa. ");
INSERT INTO mti_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ye isimureaiwa kukaeba amatog aya onan den ane, ye aigimiya me onanape! ");
INSERT INTO mti_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ye mokare! Ye mokare kukaeba usitainawa! Ye geena aisetan wapewa aninin megiyave uwag aisiya. ");
INSERT INTO mti_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Meoya ne propeta ge ano kokawa igiyawa ge Gwangwan toewanewan igiyawa yenan teeni omome. Upeba ye matai guriya sira yoma korosi gumbe guriya boriruwape; upeba ye matai sinagogu yeuma danave murap gumbe guriya sira gwetoimu dauwag dauwa aigimpe gut atatai imiya watkukamuniya. ");
INSERT INTO mti_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Me gumbe oraimumu igiyawa undag piyu egave diyowa aignewa guniyap uwape. Aber oraiwa diyawa gumbe onne Berekaiya usiwa Jakaraya diyawa gumbe onne. Me Berekaiya usiwa Jakaraya ye temporu sira iyakaisi kem meuma yapave toen guriya boine. ");
INSERT INTO mti_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne natawa diruieni. Undak mame matai kum garewa igiyawa gumbo uwape. ");
INSERT INTO mti_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","A, Jerusarem Jerusarem. Ye propeta guriyana sira yenan tena onamiyawa an gumbe guriyana. Kum koniwa anintom mina ne utuntainanwa yenan anog agoniyag tena. Kumkum inawa usitainawa agoniyag maviwa ankwatave tepewa mina, megara ye den anoene. ");
INSERT INTO mti_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yauya, gwe yeuma matai yan kwepe iyayapan onan mina. ");
INSERT INTO mti_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kuiyawa ne diruitna. Ye sira den yaunegiya, meve ye waya, Apan me Ayapan iviwa gumbe uwapewa waribiyape. ");
INSERT INTO mti_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iesu temporu arawa yankweg dauwag aivi, meve aigowawa me gumbe uwag temporu gweyawa toyau wampe yaupe. ");
INSERT INTO mti_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iesu garawa wane, Ye dividivi undag mame yavene. Ne natawa diruieni. An desirom da mapa dawa egave den wakepe; an undag gwiriruwag aikpe. ");
INSERT INTO mti_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tui Orivu kuiyave Iesu wakenewa, aigowawa me gumbe guwave uwaya. Mu waya, Nu didnuna, kum divi dividivi mame pawape, sira ge uwag onagawa irakoniwa, kum oieba irakoniwa me divi? ");
INSERT INTO mti_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iesu garawa wane, Apan da ye ugai yempe yaukapa. ");
INSERT INTO mti_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kuiyawa ne ivunwa gumbe iyayapan obiren onampe sira wape, Ne Keriso, sira mu iyayapan obiren ugai mumpe. ");
INSERT INTO mti_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wanampa mut gaiyawa ge kigemuk mut oya anoya, megara me den teraya. Dividivi meiba pawatanit di, go oieba oya me matai uwape. ");
INSERT INTO mti_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","At sinsin igiyawa mu at sinsin igiyawa dawa gaibu matai yoig mut watpe, sira at kokawa me at kokawa dawa gaibu matai yoig mut watpe. At upeba gumbe matai iyagon ge pinunu ape. ");
INSERT INTO mti_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Undak mame ud yaitan dawaiba amatoiviwa mina. ");
INSERT INTO mti_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Meve iyayapan mu ye tam edawai yempe sira ye guriyempe boriruwaya. Sira ne ivunwa oya at undag igiyawa ye matai topai yempe. ");
INSERT INTO mti_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Me kumiwa gumbe iyayapan obiren matai anotumat muma gumbe taig ampe, sira mu upeba gumbo gara anavi ge topai aigimpe, ");
INSERT INTO mti_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","sira propeta ugauga emewa mu matai uwape sira iyayapan obiren ugai mumpe. ");
INSERT INTO mti_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Anoano kukaeba koka ape oya, baigan mumawa matai taigiwape, ");
INSERT INTO mti_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","megara bira da oieba kumiwa yusiyusi ag yoipewa me matai waita wampe. ");
INSERT INTO mti_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sira God toimuwawa gae oraiwa meuma mame matai at undag danave opata wape, sira at undag igiyawa mu gae mame anope, kum oieba meve uwape. ");
INSERT INTO mti_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Meoya propeta Danieru me gumbe gae wanewa mina, Topai abnawa me di wakukampewa at iyakaisiyapama apa yokepe yauyawa, Basiemewa igiyawa yaug anoya ");
INSERT INTO mti_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","at Judia danave wakeyawa mu tui gumbe a ampe. ");
INSERT INTO mti_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Bira da gwe meuma egave wakenewa gwe gumbe dividivi tamtan oya den yan aikpe. ");
INSERT INTO mti_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Bira da nau danave wakenewa wape meuma autan oya den taig aipe. ");
INSERT INTO mti_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Me kumiwa apa, me kukaine vesin bug ayawa ge inowaiwa ud am munemewa oya. ");
INSERT INTO mti_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nun waya, ye a aisiyawa me taigipam kumiwa go Sabat Kumiwa apa den veniyape. ");
INSERT INTO mti_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Me kumive danadawai kokavit ape, me piyu amatonewa onne gare mame me noi omavit onan ane sira me noi omavit matai den ape. ");
INSERT INTO mti_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Me kumiwa den togomiyape pipi apawa, iyayapan desirom da den vinigimpe. Megara wak tamne igiyawa oya kumiwa pipi ape. ");
INSERT INTO mti_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Me kumiwa apa, iyayapan da guniyap wapewa, Yauya, Keriso mame! go Me asime! megara den anotumat aya. ");
INSERT INTO mti_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Keriso ugaugaeba sira propeta ugaugaeba mu matai uwape, sira mu guwaguwawa kokavit ge irayauyau ape, sira me oma apewa mu wak tamne igiyawa gumbo matai uga yempe. ");
INSERT INTO mti_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yauya, ne gare mame wait ye diruina. ");
INSERT INTO mti_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Meoya bira da ye diruipe, Me asime, at inguiwa arawa apa, megara den aisiya; go Pantut danave me wakene, megara den anotumat aya. ");
INSERT INTO mti_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kuiyawa kapesi kum dauwaiviwa apa dauwape kum aigiviwa apa tare ape me yauya, Apan Usiwa sira uwatanwa meib. ");
INSERT INTO mti_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Bo kwapiwa wakenewa apa nenip boriruwayawa kwapuwa nemewa matai agoniyape. ");
INSERT INTO mti_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Me danadawai kumiwa ivi tatevit kum matai sisip uwag ompe, sira dud den esipe; marantun kwimin gumbe aikpe, sira kwimin yusiwa ipunapun ape. ");
INSERT INTO mti_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Me kumive, Apan Usiwa guwaguwawa matai kwimin danave uwape, sira piyu egave iyayapan undag matai iruwape. Mu Apan Usiwa kwimin irikup egave yusiwa ge eyawa koka gaibu uwapewa matai yaupe. ");
INSERT INTO mti_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sira me kae trampet upipe uigawa kokavit wape, aneya meuma tepe onampe, sira kwimin piyu gina gambenwa yunadnewa aig gambenwa uwanewa, at ginawa duwam ge duwam gumbe, iyayapan gomiya munnewa matai agoniyape. ");
INSERT INTO mti_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Gare yoma inaru toyau nuniviwa gumbe yaug anoya: Yoma naniwa kwekweru ape sira kwayawa duwaigimpewa, ye bodu kumiwa me koni aivi yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ebu me desiroma, ye me dividivi mame undag yauyawa, Apan Usiwa me ankwin noive koni aivi yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne natawa diruitna. Namu dividivi undag mame veniyape, ivi matai kum garewa uwag aipe. ");
INSERT INTO mti_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kwimin ge piyu matai onanape, megara gae neuma den onanape, me yaibobot. ");
INSERT INTO mti_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Megara bira da kum ge koniwa den yaug anone, sira aneya kwimin danavewa mu mina den yaug anoya, sira Usiwa mina den yaug anone, megara Mamawa mekut yaug anone. ");
INSERT INTO mti_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Apan Usiwa uwatanwa me Noa kumiwa ane mina di. ");
INSERT INTO mti_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Me kumiwa apa iyayapan nakwai ge yoi neme, memgebip eme sira gwaitawaiwa apan muneme sira onne me kumiwa apa Noa wa dana unigne ivi nin kokavit uwane. ");
INSERT INTO mti_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sira mu den yaug anoya divi aninin atan aiviwa, megara nin uwag dividivi undag umamne. Apan Usiwa uwatan aigimpewa kumiwa me meib. ");
INSERT INTO mti_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Apan duwam nau dana wakepe; dawa matai aug aipe sira dawa kwepe. ");
INSERT INTO mti_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vesin duwam an gumbe parawa puraramigimpe, desirom aug aipe sira dawa kwepe. ");
INSERT INTO mti_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Meoya yaukapa, kuiyawa ye den yaug anoyana kum divi Ayapan yeuma uwape. ");
INSERT INTO mti_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Megara mame yaiyai yaug anoya: Gwe abnawa aram kumiwa divi ub usiwa ompe yaug anonewa, me yaukapa wakepe sira gwe meuma den toyayag ub ape. ");
INSERT INTO mti_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Meoya ye gaibu anoka wakeya, kuiyawa ye den menan amaraigimiyawa Apan Usiwa uwape. ");
INSERT INTO mti_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kokawa me nau meuma waremewa igiyawa amara muntan oya, sira nakwai kumiwa apa nakwai muntan oya amaraivi abnawa baraune. Amaraivi abnawa me anotumat meuma koka sira anoano meuma oraivit gumbe, gare me bira? ");
INSERT INTO mti_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kokawa meuma matai taig uwape sira amat abnawa me nau warigimpe yaupewa, menan oraimina ape. ");
INSERT INTO mti_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne natawa diruitna. Kokawa matai dividivi meuma undag amaraivi abnawa wampe me amarape. ");
INSERT INTO mti_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Megara me amaraivi abnawa kukaeba ipewa, sira me membovit danave anope, Kokawa neuma tate den sira taig ompe, ");
INSERT INTO mti_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","sira me amatog nau eme igiyawa meuma gurigimpe, nakwai ge yoi yaigipama neme igiyawa gaibu nemewa, ");
INSERT INTO mti_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","amaraivi abnawa me den amaraivi kumiwa apa, me den yaug anoivi kum koniwa apa kokawa meuma uwape. ");
INSERT INTO mti_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kokawa meuma matai me gattope musimusi ape, sira me ugauga eme igiyawa gaibu baraupe wakepe, asimeve me iruwaigimpe sira donawa kitosaigimpe. ");
INSERT INTO mti_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Meve kwimin toimuwawa me vesin otau inipama undag 10 mu dun muma bog apan matai vesin aunewa baigan muntan oya amiya mina. ");
INSERT INTO mti_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vesin otau inipama undag 10 danave, undag 5 warago guramne sira upeba 5 ano yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Warago guramne igiyawa dun muma boya, megara oira gaibu den boya. ");
INSERT INTO mti_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Anoyawa igiyawa mu dun muma gaibu oira muma kuningi danave usiya. ");
INSERT INTO mti_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Apan matai vesin aunewa tatevit den uwane, mu undag kub emamne sira amatog kubviniya. ");
INSERT INTO mti_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nup bagiwa apa auwaya, Apan vesin matai aunewa mapa! Dauwag oneya me yauya! ");
INSERT INTO mti_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Meve vesin otau inipama undag wan yoig dun muma tamibarip aya. ");
INSERT INTO mti_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Warago vesinawa mu yaug anoyawa vesinawa gumbo waya, Oira yeuma upeba nuniya; dun numa botoivi. ");
INSERT INTO mti_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Onan, mu garawa waya, Me oma den ane duwam nu ge ye oya. Oira gwiruwareme igiyawa gumbo aisiya sira yenan oya upeba yembovit gwiruwariya. ");
INSERT INTO mti_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Oira gwiruwattan ebu taibe amomewa, apan matai vesin aunewa uwane. Otau inipama mu tam waribiyayawa me gaibu memgebip buyunai unigiya. Meve ankwin tobodne. ");
INSERT INTO mti_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wanampa upeba uwaya. Mu waya, Ayapan! Ayapan! Ankwin nunan watapa! ");
INSERT INTO mti_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Megara me garawa wane, Me natawa diruitna, ne den yaug anoyemna. ");
INSERT INTO mti_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Meoya amat yaiyai aya, kuiyawa kum go kum koniwa ye den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sira kwimin toimuwawa me apan da me nau usitainawa auwane dividivi meumawa amaratan oya dirumne sira aramawa ainewa mina. ");
INSERT INTO mti_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Apan me iyayapan desirom desirom ano ubeube tamiyawa yaug anomunne, meoya nau usiwa da anmaga 5 tarant wanne, dawa anmaga 2 tarant, dawa anmaga 1 tarant munne. Meve me amdau aramawa aine. ");
INSERT INTO mti_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Apan me anmaga 5 tarant aunewa tatevit aig sira anmaga meuma nau wattan oya baraune sira egave anmaga 5 tarant aune. ");
INSERT INTO mti_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Dawa anmaga 2 tarant aunewa egave anmaga 2 tarant sira aune. ");
INSERT INTO mti_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Megara apan dawa anmaga 1 tarant aunewa aig dukup wadne, kokawa anmaga meuma guwave baraune. ");
INSERT INTO mti_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kum yobutatae onananewa, nau usitainawa kokawa muma taig onne, sira mu gaibu anmaga muma basiyaya. ");
INSERT INTO mti_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Apan me anmaga 5 tarant aunewa anmaga dawa 5 tarant egave aug uwane. Me wane, Kokawa, ge anmaga 5 tarant ne negana. Yawa, ne egave anmaga dawa 5 tarant sira auna. ");
INSERT INTO mti_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kokawa meuma garawa wane, Bainda di ana. Ge oraimina ge anotumat nau usiwa! Ge dividivi kusikusiwa gaibu yaimoyai amarana, meoya ne matai barau gentna dividivi obiren amara. Onaga. Kokawa geuma gaibu degadega aya! ");
INSERT INTO mti_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Apan me anmaga 2 tarant aunewa uwane. Me wane, Kokawa, ge anmaga 2 tarant ne negana, yawa, ne egave anmaga dawa 2 tarant sira auna. ");
INSERT INTO mti_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Me kokawa meuma garawa wane, Bainda di ana. Ge oraimina ge anotumat nau usiwa! Ge dividivi kusikusiwa gaibu yaimoyai amarana, meoya ne matai barau gentna dividivi obiren amara. Onaga. Kokawa geuma gaibu degadega aya! ");
INSERT INTO mti_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sira apan anmaga 1 tarant aunewa uwane. Me wane, Kokawa, ne anona ge apan yaigipam, ge den verana arawa apa maura tam agoniyana sira ge yawa den irobabai ana arawa apa agoniyana. ");
INSERT INTO mti_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Meoya ne gungap a ana, sira dauwag anedna anmaga geuma piyu danave guwave sig umna. Yawa, ge geumawa mame. ");
INSERT INTO mti_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kokawa meuma garawa wane, Ge nau usiwa kukaeba sira ge topai abnawa! Ge anoana, ne den vedna arawa apa maura tam agoniyana sira ne yawa den irobababi ana arawa apa agoniyana? ");
INSERT INTO mti_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Bainda divi oya, ge anmaga neuma anmaga gweyawa bank gumbe baraupa, sira ne taig uwapopowa, ne anmaga egavewa gaibu sira aupopo. ");
INSERT INTO mti_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Anmaga me gumbe man auya, sira anmaga 10 tarant aunewa abnawa me waniya. ");
INSERT INTO mti_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kuiyawa bira da dividivi aunewa sira wampe kokavit aupe. Megara bira da den aunewa me gumbe matai atan aupe. ");
INSERT INTO mti_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nau usiwa kukaeba daieve sisip danave aorepe, asimeve me it ge donawa kitosaigimpe. ");
INSERT INTO mti_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Apan Usiwa aneya undag gaibu eyawa meuma gumbe uwapewa, me matai kwimin eyawa danave seya meuma gumbe wakepe. ");
INSERT INTO mti_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","At piyu undag igiyawa matai me namive agoniyape, sira sip amaraiviwa abnawa mae sip ube mae goot ube togomiyape mina me iyayapan upeba gumbo meib togomiyape. ");
INSERT INTO mti_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Me matai mae sip naniyutanwa ge mae goot naniketaiwa gumbe tepe. ");
INSERT INTO mti_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Meve kin me iyayapan naniyutanwa wakeyawa dirum wape, Oneya, ye ne Maman waribiyennewa. God toimuwawa auya me piyu wadnewa gumbe yenan waribiyanewa. ");
INSERT INTO mti_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kuiyawa ne iyagon adnednewa ge nakwai negana nana. Ne meyanwa toyainewa, ge yoi negana nana. Ne at da abnawa anawa, ge nenan auwana gungap wakena. ");
INSERT INTO mti_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne kwapunwa taibe wakenawa, ge wape ennegana. Ne yuwaranawa, ge amara negana. Ne nog danave wakenawa, ge amdau nenan uwana. ");
INSERT INTO mti_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Meve iyayapan oraimumuwa garawa waya, Ayapan, nu aniyau ge iyagon aradne yautu sira nakwai gentu? ");
INSERT INTO mti_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Aniyau nu ge at da ube abnawa ana yautu sira genan auwatu gunup wakeyana, go ge kwapugwa taibe wakeyanawa nu wape engentu? ");
INSERT INTO mti_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Aniyau nu ge yuwarana sira nog danave wakeyana yautu genan amdau onantu? ");
INSERT INTO mti_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kin garawa wane, Ne natawa diruieni. Ye divi da ne tatanaiwa yapowo gwanenwa kusikarenwa gumbe ayanawa, me ne gunap ayana. ");
INSERT INTO mti_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Meve kin me naniketaiwa apa wakeyawa igiyawa dirumwane, Ye inaiinai yeuma kukaine! Gunap atan aisiya. Iyam yaibobot me kukaeba igiyawa ge aneya meuma oya waribiyanewa danave ye undag aisiya. ");
INSERT INTO mti_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kuiyawa ne iyagon adnednewa, ye divi da den negiyana. Ne meyanwa toyainewa, ye yoi da den negiyana. ");
INSERT INTO mti_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne at da abnawa anawa, ye den nenan auwayana. Ne kwapunwa taibe wakenawa, ye den wape ennegiyana. Ne yuwaranawa, sira nog danave wakenawa, ye den nenan amdau oneyana. ");
INSERT INTO mti_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Meve mu garawa wape, Ayapan, nu aniyau yaugemtu ge iyagon aragne, meyagwa toyaine, at da abnawa ana, ingui wakeyana, yuwaranawa go nog danave wakeyanawa, nu den waita gentu? ");
INSERT INTO mti_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Sira kin me garawa wape, Ne natawa diruieni. Ye divi da ne tatanaiwa yapowo gwanenwa kusikarenwa gumbe den ayanawa, nenan den ayana. ");
INSERT INTO mti_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Meve mu matai garawa kukaeba yaibobot danave unikpe, megara iyayapan oraimumuwa inaiinai yaibobot danave unikpe. ");
INSERT INTO mti_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesu dividivi undag mame gae wane onananewa, me aigo meuma dirumwane, ");
INSERT INTO mti_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ye yaug anoyana, Uwag Gaveya Buyunaeba kum duwam wakene, Apan Usiwa matai mut igiyawa nanuwo baraupe korosi gumbe tope. ");
INSERT INTO mti_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Me kumiwa apa, pirisi koukawa ge namu yoiyoi igiyawa mu pirisi painauvitwa iviwa Kayapas gweyawa imat namiwa apa agoniyaya. ");
INSERT INTO mti_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sira aninin ake Iesu aug totanwa oya gaiyawa dima yuya. ");
INSERT INTO mti_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mu waya, Megara buyunai kumiwa apa onan. Kuiyawa iyayapan danowo mut yoipetan. ");
INSERT INTO mti_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Iesu me at Betani apa apan Saimon gweyave wakene. Me yuwat warumne iviwa reprosi aunewa. ");
INSERT INTO mti_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Vesin da oira tayapama garawa kokavitwa me an kuningi iviwa Arabasta danave aug Iesu gumbe uwane. Iesu teboro gumbe intut wakenewa vesin me oira kuiyave egamne. ");
INSERT INTO mti_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Aigowawa mame yauyawa, danopiriwane. Mu singui aya, Mame dimbae oya beregam aivi? ");
INSERT INTO mti_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oira tayapama mame garawa kokawa gumbe gwiruwatpono, meve anmaga gwandokuwaeba igiyawa mumpono. ");
INSERT INTO mti_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iesu mame yaug anonewa, me dirumne, Divi oya ye vesin mame pui yuene? Vesin me ne gunap oraimina di ane. ");
INSERT INTO mti_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gwandokuwaeba igiyawa mu kum evedni ye gaibu wakeya, megara ne guniyap evedni den wakeeni. ");
INSERT INTO mti_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vesin me kwapunap oira tayapam me egamnewa, me iragi neuma barautan oya tamibarip ane. ");
INSERT INTO mti_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne natawa diruieni. Piyu mame danave at ampa ampa undag gae oraiwa mame opata wapewa, vesin mame anewa gaibu dirumpe me imug anope. ");
INSERT INTO mti_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Meve aigowawa 12 danave desirom me Isukariot Judas me pirisi koukawa gumbo aine, ");
INSERT INTO mti_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","sira wane, Ne me ge nanigap barautnawa ge anmaga anintom negmon? Meoya mu anmaga siruva 30 waniya. ");
INSERT INTO mti_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Meve Judas me Iesu nanuwo barautan oya ebu da oraiwa diune. ");
INSERT INTO mti_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Onanwa Bredi Buyunaeba kumiwa me kum namuiren danave aigowawa Iesu gumbe uwag singui aya, Uwag Gaveya Buyunaeba oya ge anoege nu ambuwa apa tamibarip ata? ");
INSERT INTO mti_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iesu garawa wane, Gwetoimu koka aisiya, apan da wakene sira me diya, Toyautoyau abnawa wane, Kum neumawa me koni aivi. Ne gwe geuma apa aigo neuma gaibu Uwag Gaveya Buyunaeba oketna. ");
INSERT INTO mti_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Meoya aigowawa mu Iesu dirumwanewa aya sira Uwag Gaveya Buyunaeba oya tamibarip aya. ");
INSERT INTO mti_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Augoi uwag onnewa, Iesu me aigowawa 12 gaibu teboro apa intu uteg wakeya. ");
INSERT INTO mti_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sira mu nakwai nemewa, me wane, Ne natawa diruitna. Ye da ne omin neuma barautan aivi. ");
INSERT INTO mti_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Mu undag danadawai kokavit auya sira amatog desirom desirom me gumbe waya, Ayapan, natawa di me ne onan? ");
INSERT INTO mti_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iesu garawa wane, Naniwa ne gaibu kabum danave puwamnewa me matai ne anavi nekpe. ");
INSERT INTO mti_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Baiboru gumbe nenan tenewa mina Apan Usiwa me matai kweg aipe. Apan Usiwa gumbe omin meuma tepewa me gumbe ano kukaeba wakeigimpe! Me den yaipawa me menan oya oraimina. ");
INSERT INTO mti_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Meve Judas me menan anavi apewa wane, Rabai natawa di me ne onan? Iesu gara wane, Onan, me ge di. ");
INSERT INTO mti_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mu nakwai nemeve, Iesu bredi aug gaun wag warensine. Aug naya, mame ne kwapunwa, me meib wane, aigowawa munne. ");
INSERT INTO mti_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sira me ap aug gaun wag me mun wane, Ye undag me gumbe naya. ");
INSERT INTO mti_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mame ne diyanwa agiyawa. Iyayapan obiren ano kukaeba mumawa wad muitan oya aikpe. ");
INSERT INTO mti_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne diruieni. Gare utan aipewa ne yoi me greip magawa gumbe wariyawa sira den natna, megara matai Maman God toimuwawa danave ne ye gaibu natna. ");
INSERT INTO mti_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Mu God bererinawa toya, meve mu dauwag tui Orivu dog amiya. ");
INSERT INTO mti_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Meve Iesu me aigowawa dirumne, Aram gare mame ye nenan oya undag uyug aigiya. Kuiyawa me wait tenewa di: Ne matai sip amaraivi abnawa totna, sira sip agoniyag wakeyawa matai marewampe. ");
INSERT INTO mti_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Megara ne sira wan yoitnawa, ivi ne matai namuiban at Gariri anekna. ");
INSERT INTO mti_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita gara wane, Anten undag genanwa oya uyug aikpe go, megara ne onan di. ");
INSERT INTO mti_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesu gara wane, Ne natawa diruitna. Aram gare mame koni duwamdesi ge wa, Ne den yaug anogemna, ivi kumkum wape. ");
INSERT INTO mti_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Megara Pita gae yusipamit wane, Anten ne ge gaibu bo ata go, megara ne den di watna, Ne den yaug anogemna. Sira aigowawa upeba undag gae desiroma waya. ");
INSERT INTO mti_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Meve Iesu me aigowawa gaibu at iviwa Gessemani amiya, me dirumwane, Ye mapa wakeya, ne dauwag asime angeni nun watna. ");
INSERT INTO mti_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iesu me Pita ge Jebedi usitainawa duwam tam gaibu aine, sira me amatog anogugut ag danadawai aune. ");
INSERT INTO mti_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Meve me dirumwane, Ne guwanwa bo gumbe anogugut aivi. Mapa wakeg ne gunap amaraigimiya. ");
INSERT INTO mti_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Iesu koni pipi aine, piyu egave ginangaven aig nun wane, Maman, oma ape ipewa ap mame gunap atan auwa. Megara ne anoeniwa onan, ge anoegewa a. ");
INSERT INTO mti_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Meve me sira taig onne aigowawa yawamne mu kubvineme. Me Pita dine, Ye kum koniwa desirom da ne gunap yangut den ene? ");
INSERT INTO mti_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yangewa mereruwape nun waigimiya, matai amaorot danave den aigiya. Kuiyawa guwawa me yusipam, megara kwapiwa yusi onan. ");
INSERT INTO mti_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iesu koni duwam atan aig nun wane, Maman, ne ap mame natanit di ipewa, ne natna, ge anoegewa a. ");
INSERT INTO mti_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Iesu sira taig onnewa, me yawamne mu ande kubvineme, kuiyawa mu yangowa ibnawa ane. ");
INSERT INTO mti_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Meoya me sira mu kwem aine nun koni duwamdesiyawa desiroma wane. ");
INSERT INTO mti_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Meve me sira taig onne aigowawa dirumne, Ye kub ge nonewa ande emene? Yauya, kum koni manman ane. Apan Usiwa me kukaeba igiyawa nanuwo aitan aivi. ");
INSERT INTO mti_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wan yoiya, anta! Anavi nednewa mapa uwane! ");
INSERT INTO mti_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesu ande gae waiviwa, 12 danave desirom, Judas, me uwane. Me gaibu iyayapan obiren mut ge seri tam onamiya. Mu pirisi koukawa igiyawa ge namu yoiyoi igiyawa teya onamiya. ");
INSERT INTO mti_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gare anavi abnawa mu gaibu gae wait yuya guwaguwawa aya, Apan me ne uwa totnawa me me, me yumiya. ");
INSERT INTO mti_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas Iesu gumbe ob manivi wane, Kaiwa kaiwa, Rabai! sira me uwa tone. ");
INSERT INTO mti_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iesu garawa wane, Enda, ge divi oya onagana? Meve iyayapan menan uwag amog yumeg auya. ");
INSERT INTO mti_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Iesu gaibu wakeyawa da desirom deba meuma arobne dauwane pirisi kokawa nauwawa aiviwa da viyag naunawa togomiyane. ");
INSERT INTO mti_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iesu me dig wane, Benesi geuma sira arave barauwa. Bira da deba arotpewa me matai deba gumbe boape. ");
INSERT INTO mti_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne Maman oya auwatnawa, me tatevit aneya mut igiyawa riijon undag 12 egave ankwatanap tepe. Me ye den yaug anoyana? ");
INSERT INTO mti_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Megara mame veniyanewa, aninin Baiboru gaiyawa natawa veniyape? ");
INSERT INTO mti_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Me kumiwa apa Iesu iyayapan dirumne, Ne ub igiyawa tam namuyoiyoi eni go? Meoya ye deba ge seri gumbe ne yumnektan uwayana? Kum evedni ne temporu arawa danave wakeg toyau toyau eni, megara ye den ne yum negiyana. ");
INSERT INTO mti_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Megara propeta gigirumawa natawa uwatan oya mame undag veniyape. Aigo meuma undag Iesu yankweg a amiya. ");
INSERT INTO mti_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iyayapan mu Iesu auyawa me aug pirisi painauvitwa Kayapas amiya. Me apa, Gwangwan toewanewan igiyawa ge iyayapan namuyoiyoi igiyawa agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Megara Pita me asinut kusi da Iesu amave aine, me pirisi painauvitwa at meuma apa dauwag aig unig nau eme igiyawa gaibu yan wakene aninin ape yawatan oya. ");
INSERT INTO mti_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pirisi koukawa ge Daiboru Painauvitwa igiyawa undag mu Iesu pui yug totan oya irayau ugauga muma tamtan anoeme. ");
INSERT INTO mti_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ugauga veme igiyawa obiren uwaya, megara mu divi da den yauya. Oieba duwam uwaya. ");
INSERT INTO mti_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Taibe waya, Apan mame wane, Ne oma ane God temporuwawa toyayag kum duwamdesi danave sira sitna. ");
INSERT INTO mti_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Meve pirisi painauvitwa owan yoig Iesu dig wane, Ge garawa da wa, go onan? Iyayapan mame ge pui aug onam yuwageme, ge dimbae anoege? ");
INSERT INTO mti_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Megara Iesu me di iyagidne. Sira pirisi painauvitwa me dig wane, Ne ge dirugeni God wakeiviwa me yangave nu did nuna. Ge Keriso God Usiwa, go onan? ");
INSERT INTO mti_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Iesu gara wane, E, ge vegewa me natawa. Ne ye diruitna, matai ye Apan Usiwa yauya. Nani yutanwa yusipama apa wakeg kwiminau irikup egave uwape. ");
INSERT INTO mti_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Meve pirisi painauvitwa wape meuma waremig wane, Me God iviwa wakukamne. Dimbae oya nu yangunup upeba sira yauton, gare ye anoyana gae me God iviwa wakukamne. ");
INSERT INTO mti_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ye anin anoenan? Mu garawa waya, Me di bo ape. ");
INSERT INTO mti_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Meve mu gwitup Iesu ginanamiwa emiya, mu nanuwa abum toya, sira iyayapan upeba mu Iesu nanuwa petawa gumbe toya. ");
INSERT INTO mti_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Mu me gumbe waya, Keriso, did nuna. Bira ge togne? ");
INSERT INTO mti_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita me gwe imat namive wakene, nau vesinawa me gumbe uwag wane, Ge mina gaibu Gariri apan Iesu gaibu wakeege. ");
INSERT INTO mti_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Megara Pita iyayapan undag namuwo yan um wane, Ge anin vegewa den yaug anona. ");
INSERT INTO mti_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sira Pita ankwin noive dauwag aine, meve vesin otau da me yaug iyayapan asimeve wakeyawa dirumne, Apan mame me Nasaret apan Iesu gaibu wakenewa. ");
INSERT INTO mti_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita sira yan umne, me God namive agi wane, Apan me ne den yaug anona. ");
INSERT INTO mti_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ivi kusi pungi wanewa, iyayapan asimeve yokeyawa mu amog Pita gumbe uwag waya, Natawa di, ge mu desiroma da. Gae vegewa noiwa toyau nunivi. ");
INSERT INTO mti_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Meve me amatog aewag wane. Me gae natawa di mu gumbo wane, Apan asime ne den yaug anona. Me konive tatevit kumkum wane. ");
INSERT INTO mti_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Meve Pita me watavit Iesu gae wanewa imug anone, Namu koni duwamdesi ge ne topai negawa, koni kumkum wape, sira me daieve dauwag aig it kokavit wane. ");
INSERT INTO mti_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mumbevit, pirisi koukawa ge namuyoiyoi igiyawa undag uwag Iesu bo totan oya dima yuya. ");
INSERT INTO mti_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mu Iesu tuya, me tueg aug Pairat, kansoru kokawa, nanive barauya. ");
INSERT INTO mti_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Me kumiwa apa, Judas me Iesu anavi anewa yaug anone mu waya Iesu me kukaeba abnawa. Me ano gugut ane, sira taig aig, anmagawa siruva 30 pirisi koukawa ge namuyoiyoi igiyawa gumbo sira munne, ");
INSERT INTO mti_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Me wane, Ne kukaeba ana. Kuiyawa apan oraiwa diyawa gumbe anavi ana. Megara mu waya, Nu gunup me aninin? Me ge anoano geuma. ");
INSERT INTO mti_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas anmaga siruva temporu danave baraug aine. Meve me aig meyawa membovit kuigi en boane. ");
INSERT INTO mti_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pirisi koukawa anmaga siruva tam waya, Anmaga mame puyo bokesiyawa danave barautanwa me oraimina onan, kuiyawa me diyawa garawa oya. ");
INSERT INTO mti_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mu gae wag anoyawa anmaga me gumbe ui wariviwa abnawa arawa gwiruwariya. Mu aya at da igiyawa babat muma. ");
INSERT INTO mti_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Meoya waya me diyawa arawa me kumiwa onne gare mame di. ");
INSERT INTO mti_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Me kumive, propeta Jeremaiya wanewa natawa matadne. Mu anmaga siruva 30 tamiya. Me garawa me Isuraeru igiyawa menan anog barauyawa, ");
INSERT INTO mti_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","sira Ayapan didnedne mina, mu garawa baraug ui wariviwa abnawa arawa gwiruwariya. ");
INSERT INTO mti_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iesu Keriso me kansoru kokawa namive wanyoine. Meve kansoru kokawa singui ane, Ge Ju igiyawa kin muma? Iesu gara wane, Anin vegewa me natawa. ");
INSERT INTO mti_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Megara pirisi koukawa ge namuyoiyoi igiyawa menan pui yuyawa, me garawa anin da den wane. ");
INSERT INTO mti_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Meve Pairat Iesu dig wane, Ge den anoege? Inaiinai kukaeba undag mu gungap pui yuwageme. ");
INSERT INTO mti_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Megara pui yuemewa Iesu garawa da den wane. Kansoro kokawa me kokavit terane. ");
INSERT INTO mti_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gare, buyunai kokawa kumive, kansoru kokawa anoanowawa wakene. Nog aegiya iyayapan wagomiya waniyawa desirom ingui arob baraupe dauwag aipe. ");
INSERT INTO mti_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Me kumive, nog aigne abnawa iviwa Barabas wakene. Iyayapan me yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Meoya, iyayapan obiren agoniyayawa, Pairat dirum wane, Ye bira oya anoene ne aropna dauwag aipe? Barabas go Iesu iyayapan Keriso vemewa? ");
INSERT INTO mti_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kuiyawa me yaug anone mu gunarepam eme oya Iesu aug waniya. ");
INSERT INTO mti_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pairat keptete arawa apa seya egave wakenewa, biviwa umum abnawa menan baraune onne, wane, Apan oraiwa asime gumbe divi da den a. Ne gare uyavi me namiwa vinnawa danadawai auna. ");
INSERT INTO mti_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Megara pirisi koukawa ge namuyoiyoi igiyawa mu iyayapan obiren gumbo dirumiya, Barabas oya waya, sira Iesu boatan waya. ");
INSERT INTO mti_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kansoro kokawa singui munne, Apan duwam ambuwa oya anoene aropna? Mu waya, Barabas. ");
INSERT INTO mti_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pairat dirum wane, Ne Iesu mu vemewa Keriso oya aninin aten? Mu undag gara waya, Yoma korosi gumbe toya! ");
INSERT INTO mti_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Megara Pairat wane, Divi oya? Kukaeba meuma divi ane? Megara mu nouwa au ge kwaruwag waya, Korosi gumbe toya! ");
INSERT INTO mti_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pairat gare yaug anone me oma den ane mu tobot mumpe, mut amatog wadarareak eme. Me yoi aug iyayapan obiren namuwo naniwa muin wane, Apan mame diyawa gumbe ne kukaeba onan. Me ye anoano yeuma. ");
INSERT INTO mti_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iyayapan undag garawa waya, Diyawa gunup aikpe, sira utuntainunwa gumbo aikpewa me divi da onan. ");
INSERT INTO mti_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Meve me Barabas me arobne munan dauwag aine. Me Iesu murap yaigipama gumbe toya, sira korosi gumbe totan oya mu nanuwo baraune. ");
INSERT INTO mti_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Meve kansoru kokawa mut igiyawa meumawa mu kansoru kokawa gwe meuma danave Iesu aug unig amiya, mut igiyawa undag me birorot yoiya. ");
INSERT INTO mti_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Meve Iesu wape meuma atan aug wape diyapama enwaniya. ");
INSERT INTO mti_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Meve mu murap ipuni ganaganapam aug ikoki ag, Iesu kuiyave tonasiya, naniwa yutanwa gumbe tutu waniya aune, me namive koniwa yuweg iyagau eme, waya, Kaiwa kaiwa, Ju igiyawa Ayapan mumawa. ");
INSERT INTO mti_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mu gwitup Iesu emkwaniya, tutu aug kuiyave toya. ");
INSERT INTO mti_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mu Iesu gumbe iyagau wag, wape asime atan aropeg wape meuma aug enwaniya. Meve me aug amiya yoma korosi gumbe tope boitan oya. ");
INSERT INTO mti_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mu dauwag amomewa, at Sairin abnawa iviwa Saimon yauya, sira mu ayag waniya me korosi oieve autan oya. ");
INSERT INTO mti_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mu at iviwa Gorugosa uwaya. (Me natawa at me kuiyamarednawa.) ");
INSERT INTO mti_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Asimeve mu wain sisiwa gaibu biroriyayawa aug Iesu waniya, megara me di dimuine, den nane. ");
INSERT INTO mti_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mu me korosi gumbe tog yudapke wape meuma oya kae kusi akape wape meuma kep teya. ");
INSERT INTO mti_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mu asime yan wakeg yangowa Iesu yaveme. ");
INSERT INTO mti_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mu pui yueg gigirumawa teg me kuiyawa egave barauya, me teg waya, APAN MAME ME IESU, JU IGIYAWA KIN MUMAWA. ");
INSERT INTO mti_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ub igiyawa duwam korosi gumbe Iesu gaibu guriya, desirom naniyutanwa apa, dawa naniketaiwa apa. ");
INSERT INTO mti_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iyayapan bira bira uwag amomewa gae kukaeba Iesu gumbe veme, kuiyowa viyaviya eme, ");
INSERT INTO mti_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","mu veme, Ge wana, Temporu toyayag sira kum duwamdesi danave sitna. Gembovit wag inaigita. Ge God Usiwa ipewa, korosi gumbe yan aig onaga. ");
INSERT INTO mti_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ebu desiroma, pirisi koukawa ge Gwangwan toewanewan igiyawa mu Iesu gumbe iyagau eme. ");
INSERT INTO mti_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Mu waya, Me iyayapan upeba waita munne, megara membo oma den ane wad inaine. Me Isuraeru kin mumawa ipewa, gare mame korosi gumbe aiga, meve nu anotumat genta. ");
INSERT INTO mti_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Me God gumbe anotumat aivi. Gare God menan anopewa, me waita wampe, kuiyawa me wane, Ne God Usiwa di. ");
INSERT INTO mti_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ebu desiroma, ub igiyawa mu Iesu gaibu korosi gumbe guriyawa mu mina meib yano veme. ");
INSERT INTO mti_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kum kuiyunup ge kum koniwa duwamdesi yapave aramsisip at undag umne. ");
INSERT INTO mti_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kum koniwa duwamdesi mina apa Iesu kwaruwane, Eroi Eroi rama sabakutani? Me natawa, Maman maman, divi oya ne yankwenegana? ");
INSERT INTO mti_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iyayapan upeba asime apa yoiemewa anog waya, Me Eraija oya auwaivi. ");
INSERT INTO mti_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mu da tatevit kintog aig sponji aune, me wain sisipama em arob, tutu ginave yug Iesu natan oya wanne. ");
INSERT INTO mti_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Megara iyayapan upeba waya, Me yankweya wakepe. Nu yauta Eraija uwag me waita wampe, go. ");
INSERT INTO mti_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Meve Iesu noiwa koka auwane me gaup meuma oieba dauwane. ");
INSERT INTO mti_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Me kumive, wape kokawa me temporu danave barauya aignewa yapave viyodne aig gina gambenwa uwane duwam ane, piyu ipunapun ane, an koukawa pepeyodmusia, ");
INSERT INTO mti_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","dagup watabmusia, boriruwayawa iyakaisi obiren kwapuwa sira inai musia. ");
INSERT INTO mti_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mu dagup danave dauwaya, namu Iesu yoine, ivi mu dagup danave dauwaya, sira mu gwetoimu kokawa iyakaisiyapama danave unig amiya, iyayapan obiren gumbo uwag toyau muniya. ");
INSERT INTO mti_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Senturion ge iyayapan me gaibu Iesu yangut yavemewa mu pinunu sira dividivi undag matadmusiawa yauya, sira mu a ag waya, Natawa di, me God Usiwa. ");
INSERT INTO mti_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vesin obiren asimeve painauvit Iesu yangut yaveme. Mu Iesu at Gariri apa Iesu amave amiya amat meuma atan oya. ");
INSERT INTO mti_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mu danave Magdara vesin Meri, Meri me Jemus ge Josep inawa, Jebedi usitainawa inawa gaibu wakeya. ");
INSERT INTO mti_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Augoi uwag onne, tawara abnawa iviwa Josep me Arimataya apan me uwane. Me membo gaibu Iesu aigowawa ane. ");
INSERT INTO mti_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Me Pairat gumbe aig Iesu kwapiwa autan oya nun wane, Pairat me kwapiwa wantan wane. ");
INSERT INTO mti_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josep me kwapiwa aune, wape rinen oraimina gumbe panne, ");
INSERT INTO mti_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","sira dagup mataiwa meuma me an koka kwabnewa me danave baraune. Dagup ankwin noive an koka itarag tobot aine. ");
INSERT INTO mti_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Me apa Magdara vesin Meri, ge Meri dawa mu dagup visigambenwa apa wakeya. ");
INSERT INTO mti_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kum dawa, kum me Tamibarip Kumiwa onananewa, pirisi koukawa ge Parisi igiyawa Pairat gumbe amiya. ");
INSERT INTO mti_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mu waya, Kokawa, ugauga waivi abnawa wakenewa kumiwa apa wane, Kum duwamdesi danave ne sira inaigitna, nu anoete. ");
INSERT INTO mti_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Meoya gae muna kum 3 danave dagup yaiyai amaraigimpe. Meib den ape ipewa me aigowawa matai onam me kwapiwa ub ag aug ampetan. Sira iyayapan dirum wape, Bo igiyawa gumbo, me sira inaine. Ugauga namuwa me kusi, ugauga iviwa me kokavit. ");
INSERT INTO mti_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pairat garawa wane, Mut igiyawa tetna ampe, dagup yaiyai amarape. ");
INSERT INTO mti_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Meoya mu amog dagup an gumbe tobot wabatamiya, mut igiyawa dagup amaraya. ");
INSERT INTO mti_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat Kumiwa onanane, pura danave kum namuirenwa mumbevit apa, Magdara vesin Meri, ge Meri dawa dagup yautan oya amiya. ");
INSERT INTO mti_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yauya! Pinunu koka ipuniyane. Kuiyawa Ayapan aneya meumawa kwimin apa aigne, dagup aine, an watariyag egave yan wakene. ");
INSERT INTO mti_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ginanamiwa yautanwa me kapisi mina warivi, sira wape meuma me puipuyu snow mina. ");
INSERT INTO mti_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mut igiyawa mu aneya yaug a aya, mu daram daram ag bo igiyawa mina aya. ");
INSERT INTO mti_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aneya vesin dirumwane, A den aya. Ne yaug anona ye Iesu me korosi gumbe toyawa oya yobene. ");
INSERT INTO mti_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Me mapa onan. Me wanewa mina sira yoine. Oneya mu barauyawa arawa yauya. ");
INSERT INTO mti_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Meoya tatevit aiseg aigowawa dirumiya, Iesu bo igiyawa gumbo sira yoine. Me namuiban Gariri aivi, asimeve ye me yauya. Ne mame diruina. ");
INSERT INTO mti_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Vesin a aya, megara degadega gumbe tatevit dagup apa yankweg amiya, aigowawa dirumtan oya kintog amiya. ");
INSERT INTO mti_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tatevit Iesu nuntosa munne, me gaun munne. Vesin uwag Iesu amave yumiya, sira watdega aya. ");
INSERT INTO mti_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Iesu dirum wane, A den aya. Aiseg ne tatanaiwa dirumiya, Gariri ampe. Asimeve mu ne yaunetpe. ");
INSERT INTO mti_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Vesin ebu taibe amomewa, mut igiyawa upeba wait toimu kokawa Jerusarem amog, pirisi koukawa gumbo dividivi matadmusiawa undag umum waya. ");
INSERT INTO mti_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Meve pirisi koukawa mu namuyoiyoi igiyawa upeba gaibu agoniyag dima yuya. Mu mut igiyawa anmaga kokavit muneg waya, ");
INSERT INTO mti_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Me aigowawa arampuna nu kubvineteve omog Iesu kwapiwa ub ag aug amiya. ");
INSERT INTO mti_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Umum mame kansoru kokawa anopewa, nu gae yaimoyai wag dita, ye danadawai onan. ");
INSERT INTO mti_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Meve mut igiyawa mu anmaga tam aninin dirumiyawa mu meib aya. Meoya gae mame Ju igiyawa yapowo wateteyamne onne gare mame. ");
INSERT INTO mti_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Meve aigowawa 11 Gariri amiya, tui me Iesu dirumnewa dog amiya. ");
INSERT INTO mti_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mu Iesu yauyawa, waiya aya. Megara upeba pipammusia. ");
INSERT INTO mti_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Meve Iesu mu gumbo uwag wane, Yusiwa undag kwimin danavewa ge piyu egavewa me ne nedne. ");
INSERT INTO mti_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Meoya ye aisiya, aya iyayapan mu at da undag danave wakeyawa mu aigowawa ape. Sira Mamawa Usiwa Guwawa iviwa gumbe babataito amuniya. ");
INSERT INTO mti_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sira ye anoano undag me ne toyau yennawa toyau muniya, anoano undag noiwa aug amarape. Yauya, ne kum evedni ye guniyap, piyu mame oieba gumbe viripusiwa onan. ");
INSERT INTO mti_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","God Usiwa Iesu Keriso gae oraiwa amatonewa. ");
INSERT INTO mti_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Propeta Aisaya buka meuma danave tene, “Yawa, ne umum abnawa barautna namugap ompe, me ebu geuma waribiyape.” ");
INSERT INTO mti_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“At inguiwa arawa danave apan da noiwa auwaivi, ‘Ayapan oya ebu waribiya, ebu siwavit menan waribiya.’” ");
INSERT INTO mti_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Meve Jon uwane, at inguiwa arawa apa babataito amunivi, sira opata me nonemagowa biroriyag babataito atan oya, wag dirumivi. ");
INSERT INTO mti_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","At Judia ge Jerusarem igiyawa undag menan amiya. Mu kukaeba muma boruwa aya, sira mu yoi Jodan danave me gumbe babataito aya. ");
INSERT INTO mti_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon wape ennewa me mae kameru gumawa gaibu, kwit gumbe powawa topanne, sira me paki ge kemari mundanavewa naivi. ");
INSERT INTO mti_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mame me gaiyawa, “Sira apan ne amanap uwapewa me yusipama, ne me mina onan. Ne oma den ane kwanasik amawa sandoro vetna. ");
INSERT INTO mti_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ne yoi gumbe babataito ayenna, go me Guwawa Iyakaisiyapama gumbe babataito ayempe.” ");
INSERT INTO mti_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Me kumiwa apa Iesu at Nasaret Gariri danave apa onne, sira me Jon gumbe yoi Jodan apa babataito ane. ");
INSERT INTO mti_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sira Iesu yoi gumbe dauwanewa, kwimin watabne Guwawa me umuk mina aig onivi yaune. ");
INSERT INTO mti_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sira noiwa kwimin apa uwane, “Ge ne utunwa ne baigan neuma gungap, ge gungap ne degadega eni.” ");
INSERT INTO mti_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tatevit Guwawa me baraune at inguiwa arawa aine. ");
INSERT INTO mti_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","At inguiwa arawa apa me kum 40 wakeg Seitan amaorot uwag wanne. Mundanavewa maeba me gaibu wakeya, sira aneya me gumbe uwag waniya. ");
INSERT INTO mti_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jon me nog barauya aignewa, meve Iesu Gariri aine God gae meuma oraiwa opata wane. ");
INSERT INTO mti_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Me wane, “Kum me uwaivi, God toimuwawa me koni aivi. Ye nonemagewa biroriyaya sira gae oraiwa anotumat aya.” ");
INSERT INTO mti_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sira Iesu poeman Gariri visive ainewa, me yawamne Saimon ge gwaneba Andru mu poeman danave uwariri aoreme. Kuiyawa mu gwambui upeme igiyawa. ");
INSERT INTO mti_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iesu dirumne, “Amanap oneya. Wag toyau yentna, ye iyayapan upeme igiyawa aya.” ");
INSERT INTO mti_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tatevit uwariri muma yankweg me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sira me kusi atan aike Jebedi usiwa Jemus ge gwaneba Jon mu wa danave uwariri muma tamibarip eme yawamne. ");
INSERT INTO mti_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Munan tatevit auwanewa, mu mamowa Jebedi ge nau meumawa igiyawa wa danave kwemiya. Mu me amave amiya. ");
INSERT INTO mti_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mu at Kapenaum amiya. Sabat Kumiwa apa Iesu sinagogu unig aine, sira me amatok wak toyau munne. ");
INSERT INTO mti_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Iyayapan toyau munnewa anog teraya. Kuiyawa apan da bira yusiwa aunewa mina toyau munne, me Gwangwan toewanewan igiyawa mina onan. ");
INSERT INTO mti_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sira sinagogu me danave apan da wakene. Me danave airapu kukaeba wakeya. Me kwaruwag wane. ");
INSERT INTO mti_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret apan Iesu, ge nugunup divi amon? Nu watkukam nuntan onagana? Ne yaug anona ge bira. Ge God Apan Iyakaisi meuma.” ");
INSERT INTO mti_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iesu gae yusipamit wane, “Gae yankweya! Me gumbe yankweg dauwaya!” ");
INSERT INTO mti_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Airapu kukaeba mu apan yusipamit ipuniyane, me gumbe awauepam dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iyayapan undag yaveg anoya, mu garawag anoya, “Mame divi? Mame toewanewan yusipama mataiwa? Me yusipamit airapu kukaeba dirumnewa, mu noiwa auya.” ");
INSERT INTO mti_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Me umum meuma tatevit at Gariri apa undag wateteyamne. ");
INSERT INTO mti_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Koni mu sinagogu yankweg dauwag amiyawa, me Jemus ge Jon gaibu Saimon ge Andru gwe muma amiya. ");
INSERT INTO mti_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimon nimnagawa vesinawa yuwat amipam aug gweyau deriyat egave wakene. Iyayapan mu Iesu gumbe umum waya. ");
INSERT INTO mti_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Me menan aine, me nanive aug enagadne yoine. Yuwat amipam onanane, me amatog munan amat munivi. ");
INSERT INTO mti_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kum aigne augoiyau, iyayapan yuwat igiyawa ge airapu kukaeba doramnewa tam Iesu gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","At toimu igiyawa undag ankwin noive agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Iesu iyayapan obiren yuwat gina ubeube warinamunne. Me airapu kukaeba imne amiya. Me den bainda wane airapu kukaeba divi da wape, kuiyawa mu anoya me bira. ");
INSERT INTO mti_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mumbevit aram muniwa apa, Iesu wan yoine, gwe kwene sira pontone arawa aike nun waivi. ");
INSERT INTO mti_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon ge me owowaviwa meuma menan yob onamiya. ");
INSERT INTO mti_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mu me yauyawa mu boboepaniyawa me diya, “Iyayapan undag genan yob eme!” ");
INSERT INTO mti_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iesu garawa wane, “Marewan gwe manmanwa ampa ampa anta. Asimeve gaibu ne oma ane opata wak dirumpna, kuiyawa me oya onedna.” ");
INSERT INTO mti_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Me at Gariri undag amdau birorot aine. Me sinagogu muma danave opata wak dirumne, sira airapu kukaeba imne amiya. ");
INSERT INTO mti_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apan me yuwat warumne iviwa reprosi aunewa uwane. Me koniwa yug nun wane, “Nenan ano negawa, ge waribiya nega oraimina atna.” ");
INSERT INTO mti_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesu danadawai aune, me naniwa ereriyane apan gumbe yum dig wane, “Ne imunap, oraimina a!” ");
INSERT INTO mti_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tatevit yuwat warumne iviwa reprosi yankwene, sira me oraimina ane. ");
INSERT INTO mti_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesu gwangwan yusipamit gaibu tatevit me baraune aine, ");
INSERT INTO mti_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","me apa didne, “Yaukapa. Iyayapan da den diruma. Megara gembovit ag pirisi gumbe toyauwana. Sira Mosisi gwangwan wanewa mina gembo muintan oya puyo barauwa wana me gumbe iyayapan yaug anope ge oraimina ana.” ");
INSERT INTO mti_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Megara aike amatog me iyayapan umum dirum wane. Gae mame wateteyamne. Meoya, Iesu at kokawa oma den ane taibe aine, me iyayapan onanwa arawa apa daieve aig wakene. Megara iyayapan mu ampa ampa omeg me gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kum oiyat dawa apa, Iesu Kapenaum unigne, iyayapan anoya me gweyau onne. ");
INSERT INTO mti_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Iyayapan obiren uwag agoniyaya. Gwe danawa at da den wakene ankwin noiwa gaibu noidauwane. Me gae wag dirumne. ");
INSERT INTO mti_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Apan duwam ge duwam mu apan amananiwa buburuimusiawa yotug me gumbe onamiya. ");
INSERT INTO mti_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Me kumive mu oma den ane me aug Iesu gumbe barauya, kuiyawa iyayapan noidauwane. Mu Iesu egave gwanob yayag apan amananiwa buburuimusiawa parauvinne gomaepam murap kwigieneya aigne. ");
INSERT INTO mti_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesu anotumat muma yawamne, meve apan me amananiwa buburuimusiawa gumbe wane, “Utunwa, kukaeba geuma anog yankwene.” ");
INSERT INTO mti_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Megara Gwangwan toewanewan igiyawa upeba mu asime wakeya, mu danowo wag dirumiya, ");
INSERT INTO mti_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Apan mame divi oya gae mamaib wane? Me God gumbe watkukamivi. Bira me oma ane kukaeba anog yankwetan, God mekut ape?” ");
INSERT INTO mti_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iesu tatevit me guwawa meuma gumbe mame anone divi mu danowo anoemewa, sira me wak dirumne, “Divi oya ye mame anoene? ");
INSERT INTO mti_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ambuwa me taibe; ne watna, apan amananiwa buburuimusiawa gumbe, ‘Ge kukaeba geuma anog yankwena,’ da watna, ‘Wan yoiya goma geuma aug aga.’ ");
INSERT INTO mti_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Megara, ne imunap ye yaug anoya. Apan Usiwa me piyu egave yusiwa gaibu, me oma ane kukaeba anog yankwepe.” Meve me amananiwa buburuimusiawa abnawa dig wane, “Ne ge dirukna, wan yoiya, goma geuma aug gwe aga.” ");
INSERT INTO mti_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ne ge dirukna, wan yoiya, goma geuma aug gwe aga.” ");
INSERT INTO mti_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Me wan yoike, goma meuma aug mu undag namuwo dauwag aine. Mu undag mame gumbe teraya, sira mu God waragasiya waya, “Nu meib da den yavetewa!” ");
INSERT INTO mti_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iesu sira awau visive aine. Iyayapan obiren me gumbe onamiya, me amatog wag toyau munne. ");
INSERT INTO mti_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Me aiviwa, me Rivai me Arupies usiwa takesi tamivi abnawa gweyawa kusi apa wakene yaune. “Amanap onaga,” Iesu me dine, Rivai wan yoik amave aine. ");
INSERT INTO mti_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Iesu me Rivai gweyave augoi nakwaeba naiviwa, yauya, takesi tameme igiyawa ge kukaeba igiyawa obiren uwag Iesu ge me aigowawa gaibu nakwai neme. Kuiyawa iyayapan obiren mu mina Iesu amave amome. ");
INSERT INTO mti_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Gwangwan toewanewan igiyawa mu Parisi igiyawa, me iyayapan kukaeba ge takesi tamemewa gaibu neme yawamiya. Mu singui aigowawa gumbo waya, “Divi oya me takesi tamemewa ge iyayapan kukaeba gaibu wakeg neme?” ");
INSERT INTO mti_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iesu mame anone mu dirumne, “Ui oraimumu igiyawa mu doketa oya den anoeme, megara yuwat igiyawa mu doketa oya anoeme. Ne iyayapan oraiwa auwatan oya den uwana, go iyayapan kukaeba oya munan uwana.” ");
INSERT INTO mti_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Gare Jon aigowawa ge Parisi igiyawa kwit eme. Iyayapan upeba uwag Iesu gumbe singui aya, “Jon aigowawa ge Parisi igiyawa aigowawa mu kwit eme, megara geumawa mu onan. Me aninin?” ");
INSERT INTO mti_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","“Memgebip abnawa me amdau igiyawa meuma gaibu wakeyawa, oma ane kwit ape? Mu me gaibu wakeyawa oma den ane kwit ape. ");
INSERT INTO mti_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Megara kum uwape me memgebip abnawa gumbo aug aipe. Me kumiwa apa mu kwit ape. ");
INSERT INTO mti_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Bira da wape musiwa mataiwa waremig wape namuwa gumbe den agenpe, me meib apewa, matai wape musiwa mataiwa me wape namuwa viviyotpe sira me koka ape. ");
INSERT INTO mti_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Sira bira da wain mataiwa mae kwapiwa irut namuwa danave den egampe. Me meib apewa, wain me mae kwapiwa irutawa dumetpe, sira wain ge kwapiwa irut duwam onanape. Meoya me wain mataiwa kwapiwa irutawa mataiwa danave egampe.” ");
INSERT INTO mti_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat Kumiwa da, Iesu me nau danave aivi. Me aigowawa amome. Mu amatog nakwai wiit upeba tameme neme. ");
INSERT INTO mti_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi igiyawa wag diya, “Yawa, divi oya mu Sabat Kumiwa apa Gwangwan togomeme?” ");
INSERT INTO mti_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Me garawa wane, “Ye Devid ge owawa iyagon wakeyawa kumiwa me aninin ane? Ye basiyayana go onan? ");
INSERT INTO mti_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Me Abiataru me pirisi kokawa kumiwa apa, Devid me God gweyawa unigne bredi me waribiyanewa nane. Me Gwangwaneba me pirisi igiyawa mukut nape. Sira me upeba aigowawa munne naya.” ");
INSERT INTO mti_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Meve me wag dirumne, “Sabat Kumiwa me apan oya, sira apan me Sabat Kumiwa oya onan. ");
INSERT INTO mti_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Meoya Apan Usiwa me Sabat Kumiwa Ayapaneba.” ");
INSERT INTO mti_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iesu sinagogu danave unig aine. Apan naniwa gegerainewa asime apa wakene. ");
INSERT INTO mti_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iyayapan upeba mu Iesu pui yutan oya yaveg anoeme gae ambuwa ditom. Me Sabat Kumiwa apa warinampe go onan, yautan oya mu yangowa me gumbe wakene. ");
INSERT INTO mti_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iesu me apan naniwa gegerainewa gumbe aib wane, “Iyayapan namuwo wan yoiya.” ");
INSERT INTO mti_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Meve Iesu wag dirumne, “Sabat Kumiwa Gwangwan gumbe ambuwa oraiwa: Oraiwa atanwa go kukaeba atanwa, inaiinai waita wantan go toinguttan?” Megara mu nouwa iyadmusia. ");
INSERT INTO mti_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Me birorot danapiripam yangut yawamne, anogugud ane mu nonowa yaigipam. Sira apan me digwane, “Nanigwa atan dima.” Me naniwa siwadne oraimina di ane. ");
INSERT INTO mti_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Meve Parisi igiyawa dauwag amiya, sira Erod igiyawa gaibu mu aninin akape Iesu totan oya, mu iyapeba paneme. ");
INSERT INTO mti_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu me aigowawa gaibu awau amiya. Iyayapan obiren mu Gariri apa onamiyawa amowo amiya. ");
INSERT INTO mti_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mu me aiviwa undag anoyawa, Judia, Jerusarem, Idumia ge at kokawa birorot me Jodan gambenwa, ge Taiya ge Saidon birorot apa iyayapan obiren me gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Me aigowawa dirumne, “Iyayapan obiren oya ne iyayapan asinut siririyatna. Wa kusikarenwa aug negiya.” ");
INSERT INTO mti_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Me iyayapan obiren warinam munne, meoya yuwat igiyawa me yumtan oya garaman ag me gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Airapu kukakaeba me yavemewa, mu me namive uyug aigek kwaruwaya, “Ge God Usiwa.” ");
INSERT INTO mti_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Megara Iesu yaigipam dirumne, umum den wape ne bira. ");
INSERT INTO mti_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iesu tui dog aine. Iyayapan me anoiviwa munan auwane. Mu menan onamiya. ");
INSERT INTO mti_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Me aigowawa 12 tamne. Mu me gaibu, sira opata waigimtan tepe ampe, ");
INSERT INTO mti_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","sira mu yusiwa auk airapu kukaeba atatai impe. ");
INSERT INTO mti_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iyayapan mame mu aigowawa 12 om yuwamnewa: Me Saimon ug Pita yune; ");
INSERT INTO mti_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","sira Jebedi usitainawa Jemus ge gwaneba Jon gumbo me ivuwa Boanaji munne, me natawa aegnaminin ge kapisi usitainawa. ");
INSERT INTO mti_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pirip, Batoromiu, Matiu, Tomas, Jemus me Arupies usiwa, Tadaiyas, Saimon me Jerot abnawa. ");
INSERT INTO mti_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Isukariot Judas, me Iesu ominawa baraunewa. ");
INSERT INTO mti_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Meve Iesu gwe unigne. Sira iyayapan obiren agoniyaya, meoya me ge aigowawa mu nakwai natanwa kum onan. ");
INSERT INTO mti_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iesu inawa tatawaiwa ge yogeyawaiwa mame anoyawa, mu autan onamiya. Kuiyawa mu waya, “Me kuiya kukaine.” ");
INSERT INTO mti_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sira Gwangwan toewanewan igiyawa mu Jerusarem apa onamiyawa waya, “Berujeburu me wait aune! Airapu kukaeba kokawa usiwa gumbe me airapu kukaeba atatai imivi.” ");
INSERT INTO mti_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Meoya Iesu munan auwane onamiya, meve me gae maibe gumbe mu dirumne: “Seitan me aninin Seitan atatai itan? ");
INSERT INTO mti_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Toimu togomiyak ge yoik apewa, gwetoimu me oma den ane yoipe. ");
INSERT INTO mti_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sira gwe togomiyak ge yoik apewa, gwe me oma den ane yoipe. ");
INSERT INTO mti_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sira Seitan me danave mut ape togomiyak yoik apewa, me den yoipe onanape. ");
INSERT INTO mti_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Natawa di, bira da me apan yusipam gweyawa unig dividivi meuma tamtan anopewa, namu apan yusipama den tupewa, oma den ane gwe dana unig dividivi tampe. Meoya namu tukapa, meve divdivi bope. ");
INSERT INTO mti_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne natawa diruitna, apan kukaeba apewa go God gumbe ano kukam wapewa mu anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Megara bira da Guwawa Iyakaisiyapama gumbe ano kukam wapewa, me den anog yan kwepe. Me yaibobot kukaeba meuma ane onan den ape.” ");
INSERT INTO mti_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Me mame wane. Kuiyawa mu veme, “Iesu me airapu kukaeba aune.” ");
INSERT INTO mti_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Iesu inawa ge gwanebaiwa uwaya. Mu daieve yokeg ud da barauya unig menan auwane. ");
INSERT INTO mti_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iyayapan obiren mu birorot me gumbe yan wakeya mu wak diya, “Inag ge gwanegaiwa gwe daieve wakeg genan yobeme.” ");
INSERT INTO mti_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Me singui wane, “Ne inan ge tatanaiwa mu bira?” ");
INSERT INTO mti_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Me iyayapan mu ikukuk paneg wakeyawa birorot yawamne, dirumne, “Ne inan ge tatanaiwa mawa wakeya! ");
INSERT INTO mti_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Da bira me God anowawa aiviwa me tatangwanen ge yogiyanaiwa ge inan.” ");
INSERT INTO mti_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sira Iesu amatok awau visive toyaumunne. Iyayapan obiren me gumbe uwaya. Meoya me awau egave wa danawa unig yan wakene. Iyayapan obiren mu awau visive wakeya. ");
INSERT INTO mti_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iesu dividivi undag gae maibe gumbe toyau munne. Me toyaumunnewa danave aib wane, ");
INSERT INTO mti_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Anoya! Nau abnawa me yawa tam vettan aine. ");
INSERT INTO mti_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Me yawa emeiviwa, upeba ebu taibe aigiya. Nenip uwag naboriya. ");
INSERT INTO mti_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Upeba an egave aigiya, asime piyu koka onan. Mu tatevit dumiya, kuiyawa piyu kusi da egave. ");
INSERT INTO mti_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Megara kum dauwag mu igamne undag toyaimusia, kuiyawa mu taiwa epampa den aigiya. ");
INSERT INTO mti_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yawa upeba gan danave aigiya. Yawa yaig yoiya, go gan warumne, meoya natawa den inne. ");
INSERT INTO mti_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sira upeba piyu oraiwa gumbe aigiya. Me yaig yoiya koka aya natawa iniya. Me 30, 60, 100 mina natawa inamiya.” ");
INSERT INTO mti_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Meve Iesu wane, “Da bira anotan oya naunawa gaibu ipewa me anope.” ");
INSERT INTO mti_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Iesu mekut wakenewa, aigowawa 12 ge upeba da mu me gumbe birorot wakeyawa, mu gae maibe meuma oya singui waya. ");
INSERT INTO mti_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Iesu mu dirum wane, “God toimuwawa anoano guwavewa me wait toyau yenna. Megara asipa painauwa igiyawa mu gumbo dividivi undag gae maibe gumbe dirum veni. ");
INSERT INTO mti_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Mu yaveme megara den auveme, sira anoveme megara den yaug anoeme; mu kukaeba muma anok den yankwepe!’” me meib. ");
INSERT INTO mti_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Meve Iesu mu dirumne, “Ye gae maibe mame den anoene? Aninin akape ye gae maibe da anoene? ");
INSERT INTO mti_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nauwaruat abnawa me gae emeivi. ");
INSERT INTO mti_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Iyayapan upeba mu yawa ebu taiba mina. Mu gae anopewa, tatevit Seitan uwak gae mu danowo emenewa tam aipe. ");
INSERT INTO mti_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Iyayapan upeba mu yawa mu an egave mina. Mu gae anopewa tatevit degadega gumbe aupe. ");
INSERT INTO mti_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Megara taiwa onan, meoya kum koni pipi aigimpe. Gae gumbe ibnawa go edawai uwapewa, mu tatevit a ampe. ");
INSERT INTO mti_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iyayapan upeba da mu yawa gan danave mina. Mu gae anope, ");
INSERT INTO mti_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","megara piyu mame anoano meuma anopewa, tawara ugai mumpewa, dividivi undag da atanwa anoemewa mu unig gae tobotpe, meoya natawa den impe. ");
INSERT INTO mti_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Iyayapan upeba mu yawa piyu oraiwa gumbe mina. Mu gae anope, aupe, sira mu 30, 60, 100 mina natawa inampe.” ");
INSERT INTO mti_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Me wak dirumne, “Ye dun kabum go deriyat ankwatave barautan oya aug oniyana? Garawa ye me dun yokeiviwa egave barauya. ");
INSERT INTO mti_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dividivi undag me guwave wakenewa me taibe ape, sira dividivi undag guwavewa me watappe. ");
INSERT INTO mti_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Da bira anotan oya naunawa gaibu ipewa me anope.” ");
INSERT INTO mti_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sira me meib wane, “Anoenewa yaimoyai anoya. Ye om yuyawa, ebu desirom mina me matai om yuepe,—sira egave yempe. ");
INSERT INTO mti_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Da bira aunewa me sira kokavit aupe. Megara, da bira den aunewa, divi aunewa me gumbe atan aupe.” ");
INSERT INTO mti_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Me sira wane, “God toimuwawa me mame mina. Apan yawa piyuwau emene. ");
INSERT INTO mti_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Aram ge kum, apan me kubvinivi wan yoiviwa, yawa toen dumivi yaivi, go me aninin yaivi den yaug anone. ");
INSERT INTO mti_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Piyu me mekut natawa inivi—namu powawa, meve begawa, meve begawa danave natawa inivi. ");
INSERT INTO mti_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Me natawa kweraipewa, tatevit deba gumbe gomiyape, kuiyawa maura kumiwa uwane.” ");
INSERT INTO mti_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sira me wane, “God toimuwawa me divi mina anin waton, sira divi gae maibe nu anin waton? ");
INSERT INTO mti_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Me gayum yawa mina, me yawa kudnausiren me ge piyuwau emegewa. ");
INSERT INTO mti_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Megara me emenewa, me yaig yoipe, nau danave dividivi undag wakeyawa danowo me kokavit ape, sira me naniwa koka yupe, nenip painauwa uwag gugupave wakeigimpe.” ");
INSERT INTO mti_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iesu me gae wak dirumne gae maibe obiren gina desiroma gumbe. Mu undag yaug anoya mina ane. ");
INSERT INTO mti_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Me maibe den kwene dividivi undag maibe gumbe dirumne. Megara me aigowawa mukut, gumbo natawa taibe wane. ");
INSERT INTO mti_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Oiyat me augoiyau uwanewa, me aigowawa dirum wane, “Nu anta asiwa visi gambenwa.” ");
INSERT INTO mti_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iyayapan mu kwemiya. Me wa danave, mu me mina gaibu amome. Asimeve me mina wa upeba gaibu amome. ");
INSERT INTO mti_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Meve taig okup uwag yawarat wa umne. Yoi wa noidauwane. ");
INSERT INTO mti_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Iesu wa namive unan yug kubvinivi. Aigowawa me togwanamiya, wag diya, “Ewanewan, ge nu den amat anuna nonunwa napewa?” ");
INSERT INTO mti_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Me wan yoine, taig dig wane sira yawarat gumbe dine, “Iyagisia! Ipunapun onan!” Meve taig aig botone, sira awau botone. ");
INSERT INTO mti_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Me wag dirumne, “Divi oya ye a ene? Ye ande anotumat onan?” ");
INSERT INTO mti_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mu a akape gara wa aya, “Mame me bira? Taig ge yawarat me noiwa auya!” ");
INSERT INTO mti_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mu at Gerasa me poeman gambenwa dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iesu wa kweg dauwag onnewa, apan me airapu kukaeba gumbewa me nuntosatan oya babat apa uwane. ");
INSERT INTO mti_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Apan mame babat apa vinivi. Bira da oma den ane tupe, aiyan murapeba sein gumbe tuya go oma den ane. ");
INSERT INTO mti_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kuiyawa me kapet go aiyan murapeba sein gumbe naniwa ge amawa evedni tueme, megara me aiyan murapeba sein gomiyane sira kapet me amawa tuiyawa gomiyane. Bira da yusipama onan me aug baraupe aikpe. ");
INSERT INTO mti_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Meoya kum ge aram yampot apa ge tui gumbe me it awau epam membovit an gumbe ingan toivi. ");
INSERT INTO mti_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Me Iesu asipa painau yaunewa, me kintog namive aig konive yune. ");
INSERT INTO mti_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Me kwat kuiyaven wane, “Ge nu gunup divi amon, Iesu, God Painauvitwa Usiwa? God namive agi wa. Ge dawai den nega!” ");
INSERT INTO mti_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kuiyawa Iesu me gumbe wane, “Ge airapu kukaeba, apan mame gumbe dauwa!” ");
INSERT INTO mti_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iesu me gumbe singui wane, “Ge ivugwa anin?” Garawa wane, “Ne ivunwa me Riijon, kuiyawa nu aboit.” ");
INSERT INTO mti_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sira me Iesu gumbe nun wa ge wa ane, at mame apa den tepe ampe. ");
INSERT INTO mti_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bui obiren koni tui gambenwa apa mo muneme. ");
INSERT INTO mti_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Me airapu Iesu gumbe nun wane, “Tenuna anta bui danowo, bainda wa, anta bui danowo unikta.” ");
INSERT INTO mti_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Me gumbo bainda wane, sira meve airapu kukaeba uwag dauwaya bui danowo amiya. Bui undag 2,000 mina, erai wareg aigeg awau apa nonowa naya boriruwaya. ");
INSERT INTO mti_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Iyayapan mu bui amaremewa kintog amog at kokawa ge at gwetoimu apa mame dirumiyawa, iyayapan dauwag divi aninin anewa yautan onamiya. ");
INSERT INTO mti_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mu Iesu gumbe onamiyawa, mu yauya apan me danave airapu kukaeba obiren dadi wakeyawa. Me wape enne, kuiyawa oraiminavit gumbe yan wakene. Mu a aya. ");
INSERT INTO mti_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mu me yauyawa iyayapan gumbo dirumiya apan me airapu kukaeba pannewa gumbe anin ane, sira dirumiya bui gumbo anin anewa gaibu. ");
INSERT INTO mti_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Meve iyayapan amatog Iesu dig waya at muma kweg aipe. ");
INSERT INTO mti_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iesu amatog wa avig aiviwa, apan me airapu kukaeba pannewa uwag wane ne gaibu anta. ");
INSERT INTO mti_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Iesu me bainda den wane, sira wane, “Vesin ud munan taig aga, diruma Ayapan anintom ge gungap ane sira ano gennewa.” ");
INSERT INTO mti_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Meoya apan me at Dekaporis gumbe aike amatog dirumne Iesu anintom menan ane. Meve iyayapan undag anog teraya. ");
INSERT INTO mti_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iesu sira wa gumbe awau gambenwa ainewa, iyayapan obiren Iesu gumbe agoniyaya. Me awau visive wakenewa, ");
INSERT INTO mti_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","sinagogu amaraivi abnawa da, iviwa Jairos, asime uwane. Iesu yaunewa me amave aigne, ");
INSERT INTO mti_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iesu gumbe nun wa ge wane, “Ne gwaitanwa kudnausiren me boaivi. Garawapa onakpa ge nanigwa gumbe baraupa, me aninapa inaig wakepa.” ");
INSERT INTO mti_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Meoya Iesu me gaibu amiyawa, iyayapan obiren amave amog birorot empaniya. ");
INSERT INTO mti_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vesin da me bairawan 12 danave ganigani wariviwa asimeve wakene. ");
INSERT INTO mti_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doketa obiren yauya megara den warinamiya danadawai kokavit me aune. Sira dividivi meuma undag gumbe wakenewa mumbodne, go inai den aune yuwat koka ande wakene. ");
INSERT INTO mti_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Me Iesu oya veme anonewa, me on iyayapan yapowo yoig daieven wapeyawa yumne. ");
INSERT INTO mti_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kuiyawa me anone, “Wapeyawa yumpna ipewa, ne inaigitna.” ");
INSERT INTO mti_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tatevit me ganigani wariviwa gomane. Me uiwa danave demtawa aune dawai onanane. ");
INSERT INTO mti_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iesu tatevit anone me yusiwa me gumbe dauwag aine. Me iyayapan yapowo birorot yavivi dirumne, “Bira ne wape yumne?” ");
INSERT INTO mti_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aigowawa meuma garawa waya, “Ge yavege iyayapan agoniyag ge manageme, ge singui divi oya vegan, ‘Bira ne yumnedne?’” ");
INSERT INTO mti_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iesu me bira ane yawatan oya di birorot yavivi. ");
INSERT INTO mti_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Meve vesin me aninin me gumbe matadne yaug anone. Daramipam uwake Iesu amave aigne natawa undag dirum wane. ");
INSERT INTO mti_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iesu dig wane, “Gwaitanwa! Anotumat geuma warinam genne. Yum gumbe aga, dawai geuma auegewa onanane.” ");
INSERT INTO mti_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesu gae ande waiviwa, iyayapan upeba Jairos me sinagogu amaraivi abnawa gweyawa apa uwag waya, “Ge gwaitagwa me boane. Divi oya toewanewan gumbe wayug wayug ege?” ");
INSERT INTO mti_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu gae muma veme anonewa, sinagogu amaraivi abnawa gumbe wane, “A den a. Di anotumat a.” ");
INSERT INTO mti_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Me den bainda wane bira da gaibu amave aipe. Pita, Jemus ge Jon me Jemus gwaneba mu mukut. ");
INSERT INTO mti_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mu sinagogu amaraivi abnawa gweyawa meuma uwayawa, Iesu yawamne mu danadawai gumbe iruveme sira it aen gaibu veme. ");
INSERT INTO mti_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Me aig unig dirumne, “Divi oya ye wayug wayug ge it aen venan? Ud den boane, me di kubvinivi.” ");
INSERT INTO mti_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mu Iesu gumbe towaya. Namu Iesu iyayapan undag bog tene dauwag amiya, ivi ud mamawa inawa ge me aigowawa mu me gaibu tam ud ampa wakenewa me unig aine. ");
INSERT INTO mti_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Me ud nanive aug dig wane, “Tarisa kum!” (Me natawa, “Otau, genan veni, wan yoiya!”) ");
INSERT INTO mti_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tatevit otau wan yoig birorot aine. (Me bairawan 12 onanane.) Mu mame gumbe tet kokavit aya. ");
INSERT INTO mti_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iesu gwangwan kokavit munne bira da mame den wape anope. Me dirumne nakwai da otau wampe nape. ");
INSERT INTO mti_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iesu asime kwemne, gwetoimu meuma aine. Aigowawa amave amiya. ");
INSERT INTO mti_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat Kumiwa uwanewa, me sinagogu danave amatog toyau munne. Iyayapan obiren me anoyawa anog teraya. Mu singui aya, “Apan mame divi mame aiviwa ampa tamne? Sira me anoano oraiwa mame wannewa ge irayauyau aiviwa me divi gumbe aune? ");
INSERT INTO mti_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Apan mame me gwe sisi abnawa, onan? Mame me Meri usiwa ge Jemus, Josep, Judas ge Saimon tatawa, onan? Me yogiyawaviwa mapa nu gaibu wakeya, onan?” Mu Iesu gumbe anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Iesu wag dirumne, “Propeta me gwetoimu meuma, iyayapan meuma, gwe meuma danowo mekut ebnotu gumbe da onan.” ");
INSERT INTO mti_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Me asimeve irayauyau den ane. Me anewa me naniwa yuwat igiyawa upeba kuiyovo tene inaimusia. ");
INSERT INTO mti_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sira Iesu anotumat muma onan oya terane. Meve Iesu gwe gwe gumbo birorot aine toyau mumne. ");
INSERT INTO mti_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Apasoro 12 munan auwane gumbe uwaya. Mu duwam duwam tene amiya. Airapu kukaeba atatai imtan oya yusiwa munne. ");
INSERT INTO mti_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mame gwangwan meuma: “Amdau oya divi da den auya. Tutu mekut auya, bredi onan, ikwai onan, powawa berip danave anmaga onan. ");
INSERT INTO mti_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sandoro mekut tuya, go gweb ankwatavewa duwam den eniya. ");
INSERT INTO mti_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Evedni evedni gwe ambuwa unigimiyawa, asime wakeigimiya, meve at gwe me kweya. ");
INSERT INTO mti_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ye at ambuwa uwaya den baigan yempewa go gae yeuma den anopewa, mu yaug anotan oya amedanawa atapupu toya aikpe, meve at me kweya.” ");
INSERT INTO mti_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mu amiya, sira iyayapan nonemagowa biroriyatan oya opata muniya. ");
INSERT INTO mti_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mu airapu kukaeba obiren atatai imiya, sira yuwat igiyawa obiren egowo oira egamiya, mu inaimusia. ");
INSERT INTO mti_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iesu iviwa koka anewa, Kin Erod me anone. Iyayapan upeba waya, “Babataito abnawa Jon boriruwayawa igiyawa gumbo sira inaig yoine, meoya inaiinai ubeube yusiwa me gumbe nau aivi.” ");
INSERT INTO mti_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Upeba waya, “Me Eraija.” Sira upeba waya, “Me propeta da watavitwa mina.” ");
INSERT INTO mti_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Megara Erod me anonewa wane, “Jon me ne meyawa kwagomiyanawa boriruwayawa gumbo sira inaig yoine!” ");
INSERT INTO mti_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kuiyawa Erod membo dirumne Jon aupe, yumeg tuya, aueg nog barauya. Mame me anewa Erod tatawa Pirip biviwa Erodias me aunewa oya. ");
INSERT INTO mti_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Kuiyawa Jon me Erod gumbe wane, “Ge tatag biviwa auwanawa me gwangwan gumbe oraimina onan.” ");
INSERT INTO mti_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Meoya Erodias me Jon gumbe anog danapiriwane, me imive me tope boitan anone. Megara me mina den ane, ");
INSERT INTO mti_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kuiyawa Erod me Jon gumbe a ane sira me papara vinne. Kuiyawa me anone Jon me apan iyakaisiyapama ge danawa esine abnawa. Erod me Jon opata waivi anonewa, anopipanum ane, megara me degadega gumbe anoivi. ");
INSERT INTO mti_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Meve ivi kum oraiwa uwane. Erod yainewa kumiwa apa me koukawa meumawa, mut igiyawa amaramunemewa, Gariri koukawa mumawa igiyawa munan buyunai tamne. ");
INSERT INTO mti_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Erodias gwaitawa uwag unig tare wadne. Erod ge amdau igiyawa mu degadega aya. Kin me otau gumbe wane, “Divi da anoegewa ne gunap wa. Me ne gentna.” ");
INSERT INTO mti_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sira me gae gwangwan gumbe agi wane, “Ge divi da autan anoegewa ne gentna. Ge imugap at neuma kokawa gambenwa autan anoegewa me ne gentna.” ");
INSERT INTO mti_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Otau mame dauwag aig inawa dine, “Ne divi oya nun waten?” Me garawa wane, “Babataito Abnawa Jon kuiyawa wa.” ");
INSERT INTO mti_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Meoya otau me tatevit kinipam aig kin gumbe uwag nun wane, “Ne imunap Babataito Abnawa Jon kuiyawa. Gare mame di en egave baraug nega.” ");
INSERT INTO mti_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kin danadawai kokavit anone. Megara agi meuma yaigipamit wane oya, sira iyayapan buyunai gumbewa yaveme oya, otau wanewa me topai den ane. ");
INSERT INTO mti_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kin me tatevit Jon kuiyawa aug ontan oya gae yusipam wane. Toinguttanwa abnawa baraune aine. Me nog danave unig aike Jon meyawa togomiyane, ");
INSERT INTO mti_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","sira kuiyawa en egave baraug aug taig onne. Me otau me wanne. Otau me inawa me wanne. ");
INSERT INTO mti_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon aigowawa mame anoyawa uwag me kwapiwa aug yampot danave barauya. ");
INSERT INTO mti_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Apasoro mu Iesu birorot empaniya. Mu dividivi ayawa ge toyau munnewa undag Iesu gumbe waya. ");
INSERT INTO mti_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Me dirum wane, “At wayug wayug onan arawa ne gunap ye yekut oneya nonewa emiya.” Kuiyawa iyayapan obiren uwa ge am emewa, mu nakwai muma natanwa kumiwa onan. ");
INSERT INTO mti_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Meoya mu mukut wa gumbe pontone arawa amiya. ");
INSERT INTO mti_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mu kwemum amiyawa iyayapan obiren mu yaug anoya. Meoya mu gwetoimu undag apa amowo kinipam amog asimeve namuwon uwaya. ");
INSERT INTO mti_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iesu wa avig on aigne iyayapan obiren yawamne. Me munan danadawai anone. Kuiyawa mu sip mina mu sip amaraivi abnawa gaibu onan. Meoya me amatog toyautoyau obiren ane. ");
INSERT INTO mti_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kum aigivi augoiyau uwaiviwa, aigowawa Iesu gumbe uwaya. Mu waya, “Mame gina inguiwa arawa, sira kum onanatan aivi. ");
INSERT INTO mti_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Iyayapan kwema ampe, kuiyawa mu oma ane at ama gambenwa go gweyowa ampe. Nakwai divi da mumbo gwiruwat nape.” ");
INSERT INTO mti_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Megara me garawa wane, “Ye nakwai da muniya.” Me gumbe waya, “Me 200 denari aupe! Nu anta bredi me 200 denari gumbe gwiruwak mu munta?” ");
INSERT INTO mti_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Iesu singui wag dirumne, “Ye bredi anintom tamiyan? Aiseg yauya.” Mu yawamiyawa aib waya, “Naningambenit ge gwambui duwam.” ");
INSERT INTO mti_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Meve Iesu mu dirum wane, “Ye iyayapan dirumiya kuiya dada wayo egave yan wakepe.” ");
INSERT INTO mti_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Sira mu kuiya dada 100 go 50 yan wakeya. ");
INSERT INTO mti_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Iesu bredi 5 ge gwambui duwam bog kwimin wan yaune, me gaun gumbe wane, bredi warensine. Meve me iyayapan namuwo mu tetan oya aigowawa munne. Me gwambui duwam gaibu mu undag kebag munne. ");
INSERT INTO mti_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mu undag naya oma ane. ");
INSERT INTO mti_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aigowawa bredi ge gwambui naya musimusiwa pot 12 enamiya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Apan mu nayawa me 5,000. ");
INSERT INTO mti_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iesu tatevit aigowawa dirumne wa danave unigiya sira at Betuseida namiven amome, Iesu me iyayapan tene taig amiya. ");
INSERT INTO mti_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iesu iyayapan obiren yankwem, tui visi gambenwa nun watan oya dog aine. ");
INSERT INTO mti_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Augoiyau uwane. Wa awau dana bunangave yokene, Iesu mekut piyuwau wakene. ");
INSERT INTO mti_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Me aigowawa yawamnewa mu bara wareg itan utan eme. Kuiyawa taig gurivi. Arampuna kum koniwa duwamdesi wanteteyau me dauwag poeman egave amave munan aine. Me koni mu emariya muntan ane. ");
INSERT INTO mti_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mu Iesu poeman egave amave onivi yauyawa, mu yaug anoyawa me airapu. Mu kwaru waya. ");
INSERT INTO mti_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Kuiyawa mu undag me yauya a aya. Tatevit Iesu munan dirum wane, “Yusiyusi aya! Ma ne. A den aya.” ");
INSERT INTO mti_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Meve me wa danave mu gaibu dauwag ainewa, taig memeyaig aigne. Mu teraya guwowa puk wane. ");
INSERT INTO mti_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Kuiyawa mu bredi gumbe den yai yaug anoya. Mu nonomagowa yaigiwane. ");
INSERT INTO mti_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Awau gambenwa dauwag amiya piyu Genesaret apa uwaya, sira anika aoreya. ");
INSERT INTO mti_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mu wa gumbe dauwag onamiyawa, iyayapan tatevit Iesu irawa yawag anoya. ");
INSERT INTO mti_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sira mu at me undag gwe gwe kintoya. Mu Iesu ampa wakenewa anoyawa, yuwat igiyawa kem egave bog at me uwaya. ");
INSERT INTO mti_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sira me ainewa at ampa ampa—gwetoimu apa, at koka apa, at diri gambenwa apa—mu yuwat igiyawa gwiruwaremewa arawa apa teya. Mu me gumbe nun waya Iesu wape meuma noibamawa yumpe. Iyayapan yumiyawa mu undag inaimusia. ");
INSERT INTO mti_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Parisi igiyawa ge Gwangwan toewanewan upeba mu Jerusarem apa onamiya mu Iesu empaniya. ");
INSERT INTO mti_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Mu yawamiya Iesu aigowawa upeba mu nanuwa miyot den muinkapa nakwai neme. ");
INSERT INTO mti_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi igiyawa ge Ju igiyawa undag mu upanaiwa kuinui muma ag omome, meoya mu nanuwa den muinpewa nakwai den nape. ");
INSERT INTO mti_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mu gwiruwaremewa arawa apa taig onampewa mu mumbo kwapuwa den muinpewa divi da den nape. Sira wagobaviwa wakewake mumawa gwangwanepam obiren. Mu ap, noum, ui yaigipama, upeba gaibu muineme. ");
INSERT INTO mti_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Meoya Parisi igiyawa ge Gwangwan toewanewan singui Iesu gumbe waya, “Divi oya ge aigowagwa mu upanaiwa kuinui mumawa gaibu den amat nanuwa miyotapam gumbe nakwai nape?” ");
INSERT INTO mti_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Iesu gara wag dirumne, “Aisaya me ye ugauga ene igiyawa guniyap wanewa bainda wane. Me aib tene, ‘Iyayapan mame nouwa muma gumbe ebnotu nenan eme, megara imudanowo muma ne gunap painau. ");
INSERT INTO mti_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mu imuwa undag ne gunap den waiya eme; mu iyayapan toyau toyau muma mekut toyau muneme.’ ");
INSERT INTO mti_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ye God Gwangwan meuma yan kweyana, iyayapan kuinui mumawa aug ongene.” ");
INSERT INTO mti_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sira me wag dirumne, “Ye upeaiwa ano muma amat ag ongetan oya God Gwangwan meuma atan barauyana! ");
INSERT INTO mti_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sira Mosisi wane, ‘Ye mameaiwa ge ineaiwa gumbo ebnotu amuniya.’ sira, ‘Bira da inawa ge mamawa gumbo anokukam apewa me matai tope boape.’ ");
INSERT INTO mti_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Megara ye vene, apan da inamamawa gumbo aib wape, ‘Dividivi me ne yenan tamnawa me Korban ane’, (Korban me God puyowawa.) ");
INSERT INTO mti_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ye me apan gumbe diya inamamawa oya divi da den ape. ");
INSERT INTO mti_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mamaib Ye upanaiwa kuinui yeuma gumbe God gae meuma yusi onan ane. Sira mame mina ye obiren ayana.” ");
INSERT INTO mti_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iesu sira iyayapan obiren munan auwane menan onamiya, “Ye undag ne watna anoya, mame yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Divi da asipa daieve wakenewa me apan danave unikpe me oma den ane apan miyot ape. Megara apan gumbe dauwag onnewa me apan miyot ape.” ");
INSERT INTO mti_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(-) ");
INSERT INTO mti_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesu iyayapan obiren yankwemne sira gwe unig ainewa, aigowawa me gumbe maibe mame oya singui waya. ");
INSERT INTO mti_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Iesu dirumne, “Ye me kwiyewa boredne? Ye den yaug anoyana, divi da me apan danave unignewa me oma den ane me miyot ape? ");
INSERT INTO mti_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kuiyawa me apan nonemagawa danave den unikpe, go danave unikpe, meve kwapive uwag aipe.” Iesu me mame waivi, me watabne nakwai undag oraimina. ");
INSERT INTO mti_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sira me wane, “Divi da apan gumbe uwag oniviwa me apan miyot ape. ");
INSERT INTO mti_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kuiyawa apan danave wakeyawa, sira taibe watna, apan miyot ayawa me nonemagawa gumbe wakeya me dauwag omome. Mu ano kukaeba anoiviwa, vesin apan payaupayau, ub, toenguttan, yaug anogugurivi, ");
INSERT INTO mti_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nunipama, ano kukam, ugauga, yaug anoguguraiviwa, yano, membo iviwa wai yaivi, warago aiviwa. ");
INSERT INTO mti_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kukaeba mame undag apan danave dauwape. Me ape apan miyot ape.” ");
INSERT INTO mti_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iesu at me yankweg at Taiya megiyawa oya aine. Me gwe danave unignewa, me imive iyayapan me den yaug anope, go me oma den ane guwave ape. ");
INSERT INTO mti_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Vesin da me gwaitawa kusiwa airapu kukaeba aunewa me Iesu oya anone. Me tatevit uwane amave aigne. ");
INSERT INTO mti_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Me at Griisu vesinawa, at Siria Penisia apa yaine. Me Iesu gumbe nun wane airapu kukaeba gwaitawa gumbe dauwag aitan oya. ");
INSERT INTO mti_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","“Ud usiusiwa kwema namu nape divi undag mu anoemewa,” Iesu wane, “Kuiyawa me oraimina onan ud bredi muma aug kweyau aoretna nape.” ");
INSERT INTO mti_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vesin garawa wane, “Ayapan, me natawa. Megara, kweyau me teboro ankwatave wakenewa ud usiusiwa bredi mumawa musimusiwa nape.” ");
INSERT INTO mti_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Me vesin gumbe wane, “Ge garawa geuma me oraiminavit! Aga. Airapu kukaeba ge gwaitagwa wait yankweg dauwag aine.” ");
INSERT INTO mti_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vesin gweyawa aine yaune me gwaitawa parao viniviwa. Airapu kukaeba wait me yankweg dauwag aine. ");
INSERT INTO mti_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Meve Iesu at Taiya yankweg at Saidon uwag aine, meve me sira Gariri poeman gumbe at Dekaporis megiyave uwane. ");
INSERT INTO mti_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Me apa, iyayapan upeba apan me nauna boredne sira gae yaimoyai den waiviwa aug Iesu gumbe uwaya. Mu Iesu gumbe nun waya naniwa apan egave barautan oya. ");
INSERT INTO mti_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iesu me iyayapan obiren yapowo me atan aune. Me naniguriwa duwam apan nauna nogave enne. Meve me gwitup emne apan pednawa yumne. ");
INSERT INTO mti_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Me kwimin owan yaune anogugut ane wag dine, “Epata!” Me natawa, “Me watapa!” ");
INSERT INTO mti_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Meve apan naunawa watabne. Sira me pednawa bururuwane me amatog gae siwavit wane. ");
INSERT INTO mti_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iesu gwangwan wag dirumne bira da den dipe. Iesu gae sira dirumne, megara iyayapan egave me oya gae wag amome. ");
INSERT INTO mti_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyayapan tet kokavit ag waya, “Me dividivi anewa undag oraiminavit. Nauna borednewa me anone, noi borednewa me gae wane.” ");
INSERT INTO mti_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kum me apa iyayapan obiren sira agoniyaya, go mu gumbo nakwai onan. Iesu aigowawa munan auwane onamiya. Me mu gumbo wane, ");
INSERT INTO mti_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ne iyayapan mame oya danadawai aueni. Mu ne gunap wakeya kum duwamdesi wait onanane, go mu gumbo nakwai onan. ");
INSERT INTO mti_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ne mu tetna iyagon gwe ampe ipewa, mu ebu taibe matai yangowa viyape uyug aikpe, kuiyawa mu upeba aramavit onamiya.” ");
INSERT INTO mti_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Me aigowawa garawa waya, “Mapa gina inguiwa arawa. Ampa nu bredi tamta iyayapan undag mame nape oma ape?” ");
INSERT INTO mti_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Iesu singui munne, “Ye guniyap bredi anintom?” mu garawa waya, “Me 7.” ");
INSERT INTO mti_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Me iyayapan obiren dirumne piyu gerave yan wakeya. Me bredi 7 tamnewa engaun wanne. Me wasig munne iyayapan namuwo tepe. Mu meib di aya. ");
INSERT INTO mti_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mu gwambui kusikusi upeba mina gaibu. Me me oya gaun wag aigo meuma dirumne keb ag mumpe. ");
INSERT INTO mti_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iyayapan naya oma ane. Ivi aigowawa mu musimusiwa wakeyawa tamiyawa pot 7 enamiya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iyayapan 4,000 mina wakeya. Meve Iesu tene amiya. ");
INSERT INTO mti_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Me wa dana aigowawa gaibu unig aig at Darumanuta oya amiya. ");
INSERT INTO mti_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Parisi igiyawa uwaya mu amatog Iesu singui aya. Me gumbe ageyau atan oya irakoniwa kwiminau toyaumuntan oya nun waya. ");
INSERT INTO mti_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iesu anogugut ane wane, “Divi oya iyayapan mame garewa mu irakoniwa oya nun veme? Ne natawa diruitna. Irawa da mu gumbo den mumpe.” ");
INSERT INTO mti_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Meve me mu yankwemne. Me taig wa danave unigne sira visi gambenwa oya togomiyane. ");
INSERT INTO mti_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aigowawa bredi aug onantanwa oya imuwa atataine, megara bredi en desirom di wa danave wakene. ");
INSERT INTO mti_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Iesu mu gumbo gwangwan wane, “Yaukapa. Parisi iist muma ge Erod iist meuma gumbo yaukapa.” ");
INSERT INTO mti_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mu gae garawa ano ag waya, “Me kuiyawa nu bredi gunup onan.” ");
INSERT INTO mti_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Garawano muma Iesu yaug anog singui dirumne, “Divi oya bredi den auyana oya gae vene? Ye ande den di yauyana den di yaug anoyana? Ye nonemagewa yaigiwane? ");
INSERT INTO mti_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ye yangewa gaibu, go oma den ane yauya, ye naunewa gaibu, go oma den ane anoya? Sira ye den imugiya? ");
INSERT INTO mti_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ne iyayapan 5,000 oya bredi 5 kesanawa, musimusiwa pot noidauwayawa anintom ye tamiyana?” Mu garawa waya, “12.” ");
INSERT INTO mti_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Sira iyayapan 4,000 oya bredi 7 kesanawa, musimusiwa pot noidauwayawa anintom ye tamiyana?” Mu garawa waya, “7.” ");
INSERT INTO mti_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Me mu gumbo wane, “Ye ande den yaug anoyana?” ");
INSERT INTO mti_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mu at Betuseida uwayawa, iyayapan upeba yanga bored apan aug onamiya. Iesu me kwapiwa yumtan oya nun gumbe waya. ");
INSERT INTO mti_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Me yanga bored apan nanive aune sira aug at gwe yankweg dauwag amiya. Apan yangave me gwitup emne sira naniwa me gumbe baraune Iesu singui ane, “Ge divi da yavege?” ");
INSERT INTO mti_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Me meram wane, “Ne iyayapan yawameni. Mu yoma mina a gigeme.” ");
INSERT INTO mti_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sira Iesu naniwa duwam apan yangawa duwam tene. Meve me yangawa watabne, me yangawa oraimina ane, sira me dividivi undag yaune esine. ");
INSERT INTO mti_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iesu me baraune gwe aine, wane, “Gwetoimu danave den unig aga.” ");
INSERT INTO mti_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Iesu ge aigowawa at gwe Sesaria Piripi apa amiya. Ebu taibe me singui munne, “Iyayapan veme ne bira?” ");
INSERT INTO mti_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Mu garawa waya, “Upeba me Babataito abnawa Jon veme, upeba Eraija veme, sira upeba propeta da veme.” ");
INSERT INTO mti_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Iesu singui wane, “Megara ye anin? Ye vene ne bira?” Pita gara wane, “Ge Keriso.” ");
INSERT INTO mti_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Iesu mu gwangwan dirumne nenan oya bira da den diya. ");
INSERT INTO mti_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Me meve amatog toyau munne. Apan Usiwa dividvi obiren oya edawai aupe sira namuyoiyoi igiyawa ge pirisi koukawa ge Gwangwan toewanewan igiyawa mu me di topayape, sira me tope boape kum duwamdesiyawa sira inaig yoipe. ");
INSERT INTO mti_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mame oya me taibe di wane. Pita me Iesu megiyave baraug amatog yaigipam dig wane. ");
INSERT INTO mti_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Megara Iesu tobiyag aigo meumawa yangut yawamne Pita gumbe gae yaigipam dig wane, “Seitan, daienap uwag aga! Ge God dividivi meuma den anoege, iyayapan dividivi muma anoege.” ");
INSERT INTO mti_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Meve Iesu iyayapan ge aigo meuma auwanewa mu onamiya. Me wane: “Da bira imive ne amanap ontan ape ipewa, me membo di topayape korosi meuma di wan aupe meve ne amanap ompe. ");
INSERT INTO mti_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kuiyawa da bira imive inaiinai meuma waita wantan apewa me waropiyape, go da bira inaiinai meuma nenan oya ge gae oraiwa oya waropiyapewa me waita wampe. ");
INSERT INTO mti_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Apan me piyu mame undag aupe, go guwawa meuma waropiyapewa oraiwa meuma aninin? ");
INSERT INTO mti_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Apan me guwawa meuma sira autan oya me divi da garawa wampe? ");
INSERT INTO mti_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Uinan taraki ge kukaeba eme kum mame gare danave, da bira nenan ge gae neumawa oya ubmam apewa, Mamawa eyawa meuma danave Apan Usiwa me aneya iyakaisi gaibu uwapewa kumiwa apa me apan asime gumbe ubmam ape.” ");
INSERT INTO mti_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sira Iesu mu gumbo wane, “Ne natawa diruitna. Mapa yokeyawa yapowo upeba mu God toimuwawa yusiwa gaibu onivi yaupe, ivi mu boriruwape.” ");
INSERT INTO mti_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Oiyat 6 onananewa, Iesu me Pita, Jemus ge Jon tam tui painau dog amiya. Me apa undag mukut wakeya, sira mu namuwo me irawa biroriyane. ");
INSERT INTO mti_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Me wapeyawa biroriyane di puipuiyuren ane. Bira da oma den ane mame mina wape puipuyuiren ape piyu mame danave. ");
INSERT INTO mti_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Meve Eraija ge Mosisi mu namuwo uwaya. Mu Iesu gaibu gae veme. ");
INSERT INTO mti_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita Iesu gumbe wane, “Rabai, mapa nu waketu me oraimina. Mapa nu tent duwamdesi siyamta—desirom genan oya, desirom Mosisi oya ge Eraija oya.” ");
INSERT INTO mti_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Me den yaug anone anin watan, mu di teraya.) ");
INSERT INTO mti_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Meve irikup uwane mu undag umamne, sira noiwa irikup danave uwane: “Mame ne Utunwa nonenmagawa. Me gumbe anoigimiya!” ");
INSERT INTO mti_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mu tatevit yangut birorot ayawa, da bira mu gaibu den yauya. Iesu mekut yauya. ");
INSERT INTO mti_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mu tui apa aig omomewa, Iesu mu gae yusipam dirumne, da bira den diya divi mu yauyawa, me wakepe Apan Usiwa bo gumbe sira yoig wanekpeve. ");
INSERT INTO mti_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mu me yauyawa mukut yumnasiya. Mu gae garawano aya bo apa sira yoig wanekpe me natawa divi. ");
INSERT INTO mti_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Sira mu me gumbe dig waya, “Divi oya Gwangwan toewanewan muma waya me Eraija namu di uwape?” ");
INSERT INTO mti_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Iesu garawa wane, “Natawa di, Eraija namu uwape, sira dividivi undag waribiyape. Divi oya gigirum tene me Apan Usiwa edawai kokavit autanit di sira topayape? ");
INSERT INTO mti_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Megara ne diruitna. Eraija wait uwane. Mu dividivi undag anoemewa me gumbe aya, me namu menan gigirum aninin tene mina.” ");
INSERT INTO mti_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mu aigo meuma upeba gumbo uwaya. Mu yauya iyayapan obiren mu gumbo aoreg wakeya, sira Gwangwan toewanewan igiyawa mu gaibu garadi eme. ");
INSERT INTO mti_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iyayapan undag Iesu yauyawa tatevit mu di terake gaun wantan oya menan kin tog amiya. ");
INSERT INTO mti_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Me dirumne, “Ye mu gaibu divi oya garadi ene?” ");
INSERT INTO mti_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Iyayapan obiren yapowo apan da garawa wane, “Toewanewan, ne ud neuma genan aug onegna. Me airapu kukaeba danave unigne gae watan oma den ane. ");
INSERT INTO mti_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Airapu kukaeba yumtan oya aiviwa me piyu gumbe aorene aigivi. Me noiwa poriman dauwaivi, donawa kitosiaivi, sira kwapiwa kwatataine. Ne aigo geuma gumbo nun wana airapu kukaeba atataitan oya dirumna, go mu oma den ane.” ");
INSERT INTO mti_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iesu garawa wane, “A, iyayapan garewa anotumat den eme! Kum anintom mina ne ye gaibu waketna? Kum anintom mina ye guniyap ne iyagit waketna? Ud nenan aug oneya.” ");
INSERT INTO mti_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Meve mu ud aug onamiya. Airapu me Iesu yaunewa, tatevit ud aorene daramdaram ane sira piyu egave aorene aigne bautoivi, noiwa poriman dauwaivi. ");
INSERT INTO mti_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iesu ud mamawa dine, “Kum anintom me mamaib ane?” “Ud torave apa,” me garawa wane. ");
INSERT INTO mti_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Kum evedni airapu kukaeba me toin guttanwa oya yoma yangave aorene sira yoi dana aorene. Megara ge oma ape ipewa, nu ano nuna sira waita nuna.” ");
INSERT INTO mti_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iesu wane. “Ge wana, ‘Ge oma ape ipewa?’ Bira da anotumat apewa oma ane dividivi undag ape.” ");
INSERT INTO mti_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ud mamawa tatevit gambena wane, “Ne anotumat eni. Waita nega anotumat den eniwa biroriyag anotumat oraimina atna!” ");
INSERT INTO mti_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iesu iyayapan obiren kin tog omome yawamnewa me airapu kukaeba gumbe wakakae ane. Me wane, “Ge nauna bored ge noi bored airapuwawa, ne ge gungap gae yusipamit veni, me gumbe dauwag aga me danave sira den uniga.” ");
INSERT INTO mti_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Airapu kwaruwane, kwapiwa kwatataine me gumbe yankweg dauwag aine. Ud kwapiwa yauya bo kwapiwa mina di, undag waya, “Me boane.” ");
INSERT INTO mti_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Megara Iesu nanive aune me enagadne amave wan yoine. ");
INSERT INTO mti_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iesu gwe dana unig aine. Meve aigowawa me gumbe mukut singui aya, “Divi oya nu oma den ane vete dauwag aipe?” ");
INSERT INTO mti_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Iesu garawa wane, “Ebu mamaiba oma ane dauwag aipe nun gumbe mekut.” ");
INSERT INTO mti_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mu at me yankweya Gariri uwag kweyag amiya. Iesu imive iyayapan da den yaug anope mu ampa wakeya. ");
INSERT INTO mti_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kuiyawa me aigowawa toyau munivi, me wane, “Apan Usiwa ominawa iyayapan nanuwo baraupe. Mu tope boape, sira kum duwamdesiyawa sira inaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Megara mu den yaug anoya me anin wanewa sira mu me oya Iesu gumbe singui den waya. Mu a aya. ");
INSERT INTO mti_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mu at Kapenaum uwaya. Me gwe danave unig ainewa, Iesu amatog singui munne, “Ye ebu taibe divi oya garawa anoene?” ");
INSERT INTO mti_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Megara mu di iyadmusia, kuiyawa ebu taibe mu danowo kokawa bira me oya diguragut aya. ");
INSERT INTO mti_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Me yan wakenewa, Iesu aigo meuma 12 munan auwane onamiya sira dirumwane, “Da bira namu yoitan imive wakepewa, me di virioiyeba apa yoipe. Me iyayapan undag yapowo nau abnawa ape.” ");
INSERT INTO mti_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Me ud kusi da aune, sira me ane yapowo yokene. Me vitave aune mu gumbo wane, ");
INSERT INTO mti_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Da bira me ud usiusiwa da gumbe ne ivunwa gumbe engaun apewa, me ne gunap engaun ape; sira da bira me ne gunap engaun apewa, me ne gunap engaun den ape ne baraunedne onegnawa gumbe engaun ape.” ");
INSERT INTO mti_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon wane, “Toewanewan, nu apan da yautu, airapu kukaeba ge ivugwa gumbe wane dauwag amiya. Nu me yankwetan oya ditu, kuiyawa apan me numawa onan.” ");
INSERT INTO mti_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Iesu wane, “Me den toboriya. Da bira ne ivunwa gumbe irayauyau apewa, irayauyau onanapeve oma den ane nenan oya gae kukaeba da wape. ");
INSERT INTO mti_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kuiyawa da bira me nu gunup daietaitai den anewa me numawa. ");
INSERT INTO mti_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ne ye natawa diruitna. Da bira anone ye Keriso meumawa, me oya me yoi ap me ne ivunwa gumbe yempewa, natawa di garawa meuma matai den di waropiyape. ");
INSERT INTO mti_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Megara bira da ud kusi mame ne gunap anotumat anewa desirom da ano gwambe toyau wampewa, an kokawa me parawa waremewa me meyave tug poeman danave aorepe none nape, me me oya me bainda. ");
INSERT INTO mti_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nanigwa ape ge kukaeba a ipewa, kwagomiyag epa aoreya. Me oraiwa ge gungap kwapugwa kukaipewa inaiinai danave unig aga, go me kukaine nanigwa duwam gaibu aig at kukaeba geena me iyam yaibobot igiviwa danave aiga. ");
INSERT INTO mti_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(-) ");
INSERT INTO mti_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Sira amagwa ape ge kukaeba a ipewa, kwagomiya. Me oraiwa ge gungap ge amagwa desirom gumbe inaiinai danave unig aga, go me kukaine me amagwa duwam gaibu at kukaeba geena danave aore gempe aiga. ");
INSERT INTO mti_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(-) ");
INSERT INTO mti_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Sira, yangagwa ape ge kukaeba a ipewa, topukiyag atan aoreya. Me oraimina ge gungap ge yangagwa desirom gumbe God toimuwawa unig aga, me oraimina, megara yangagwa duwam gaibu aore gempe at kukaeba geena danave aigawa me kukaine. ");
INSERT INTO mti_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Me apa, “‘Nagam den borirueme, sira iyam den botoivi.’” ");
INSERT INTO mti_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Iyayapan undag matai iyam gumbe siuran mina ape. ");
INSERT INTO mti_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Siuran me oraimina, megara me demtawa meuma onanape ipewa, ye aninin aya demtawa sira ape? Siuran daneyap auya, undag yum gumbe wakeigimiya.” ");
INSERT INTO mti_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iesu at meve kweke at Judia aine, Jodan togomiyane. Sira iyayapan undag me gumbe uwaya. Kum evedni toyau muniviwa mina mu toyau munne. ");
INSERT INTO mti_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi igiyawa upeba me gumbe uwaya amaorot aya, “Apan me biviwa gaibu garakue atan me Gwangwan gumbe bainda wane?’ ");
INSERT INTO mti_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Me garawa wane, “Mosisi Gwangwan aninin yenne?” ");
INSERT INTO mti_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mu waya, “Mosisi apan meib bainda wane, ‘Memgebip garakue oya vesin yankwetan gigirumawa teg wana kwegem vesin aipe.’” ");
INSERT INTO mti_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Mosisi Gwangwan mame yenan tene, kuiyawa ye nonewa yaigiwa dadi.” Iesu garawa wane. ");
INSERT INTO mti_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Megara wait namuiren dividivi wad tenewa, God apan ge vesin wad temunne. ");
INSERT INTO mti_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kuiyawa mame oya, apan mamawa ge inawa yankwe munke biviwa gumbe yunatpe, ");
INSERT INTO mti_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","sira apan ge vesin mu kwapuwa desirom ape. Meoya mu duwam onan, mu desirom. ");
INSERT INTO mti_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Meoya God toboranewa, apan oma den ane tam ubeube tepe.” ");
INSERT INTO mti_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Meve mu gwe danave wakeyawa, aigowawa mame oya singui waya. ");
INSERT INTO mti_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Iesu gara wane, “Bira da biviwa yankwepe sira vesin da ube aupewa, me vesin namuwa gumbe uinantaraki. ");
INSERT INTO mti_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Sira vesin memawa gumbe yankweg, apan da ube aupe ipewa, me memawa namuwa gumbe kukaeba atan aivi me uinantaraki aivi.” ");
INSERT INTO mti_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iyayapan ud usiusiwa tam Iesu gumbe uwaya. Mu imuwo Iesu ud usiusiwa yumam waribiyak muntan oya. Megara Iesu aigo meumawa gae yusipamit mu dirumiya. ");
INSERT INTO mti_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Iesu mame yaunewa danapiriwane mu gumbo wane, “Ud usiusiwa yan kwemiya nenan onampe, sira mu den toboriya. Kuiyawa God toimuwawa iyayapan meiba mu mumawa. ");
INSERT INTO mti_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ne natawa diruitna. Da bira me ud usiusiwa mina God toimuwawa den aupewa den di God toimuwawa unikpe.” ");
INSERT INTO mti_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sira Iesu ud usiusiwa bog agoniya munne, egowo naniwa barauk waribiya munne. ");
INSERT INTO mti_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iesu amatog ebu taibe aivinewa, apan da me kintog gumbe uwane, me namive konive yug dine, “Toewanewan oraiwa, divi akape inaiinai yaibobot auten?” ");
INSERT INTO mti_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Divi oya wana, ne oraiwa?” Iesu garawa wane. “Da bira oraimina onan, me God mekut. ");
INSERT INTO mti_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ge Gwangwan yaug anoana. ‘Den toengura, uinantaraki den a, ub den a, gae ugauga den wa, den ugai mun dividivi muma tamigima, inag mamag gumbo ebnotu aigima.’” ");
INSERT INTO mti_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Sira me wane, “Toewanewan, ne undag mame wait ud toranap gumbe yumnad onedna.” ");
INSERT INTO mti_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesu me yangurag danadawai gumbe wane. “Ge anoano geuma desirom da gumbe yan aigana. Aga dividivi undag ge gungap wakeyawa tam guiruwara sira tawara onan igiyawa muna, ge kwiminau garawa oraivitwa auwa. Meve amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Me kumive, apan mame kwanawa sig ginawa butuine. Me danadawai gumbe aine, kuiyawa me tawara kokavit gaibu. ");
INSERT INTO mti_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesu tobiyag aigo meuma yawam wane, “Tawara abnawa me God toimuwawa uniktanwa me yaigiwa dadi!” ");
INSERT INTO mti_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aigo meumawa Iesu gaiyawa gumbe anog teraya. Iesu sira wane, “Ud neumawa, God toimuwawa uniktanwa me yaigiwa dadi. ");
INSERT INTO mti_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mae kameru me inup nogawa uniktanwa me taibe, megara tawara abnawa me God toimuwawa uniktanwa me yaigiwa dadi.” ");
INSERT INTO mti_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aigo meumawa mu di teraya, sira gae garawano aya, “Bira da oma ane waita aupe?” ");
INSERT INTO mti_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Iesu mu yawam wane, “Apan me gumbe mame oma den ane, megara God gumbe oma ane. God dividivi undag oma ane.” ");
INSERT INTO mti_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita me Iesu gumbe wane, “Nu dividivi undag yankweg amagap ongete!” ");
INSERT INTO mti_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Ne natawa ye diruitna,” Iesu garawa wane, “Bira da me nenan sira Gae oraiwa oya gwe, tatawaiwa, yogeyawaiwa, inawa, mamawa, usitainawa go nauwawa yankwempewa, ");
INSERT INTO mti_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","me kum garewa danave koniwa 100 mina aupe,—gwe, tatawaiwa, yogeyawaiwa, inawaiwa, usitainawa, nauwawa—sira edawai gaibu aupe—, kum mataiwa danave inaiinai yaibobot aupe. ");
INSERT INTO mti_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Megara iyayapan obiren namu yoiemewa mu ivi ape, sira ivi yoiemewa mu namu ape.” ");
INSERT INTO mti_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mu dauwag Jerusarem dog amomewa Iesu me namu yoine, aigowawa undag teraya. Mu amowo amomewa undag a aya. Me aigowawa 12 tam megiyave tene, dirumne divi da me gumbe matatpewa. ");
INSERT INTO mti_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Me wane, “Nu Jerusarem angete, sira Apan Usiwa matai pirisi koukawa ge Gwangwan toewanewan igiyawa gumbo anavi ape. Mu me bo atan oya dima yug baraupe, sira me aug Ju onan igiyawa gumbo baraupe. ");
INSERT INTO mti_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mu me gumbe yano wampe sira gwitup me gumbe emkwampe, murap gumbe tope, meve toengutpe. Kum duwamdesiyawa, sira inaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jebedi usitainawa Jemus ge Jon mu Iesu gumbe uwag waya, “Toewanewan, nu imunup divi da nun gungap watawa nunan ge a.” ");
INSERT INTO mti_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Dimbae da ne yenan oya aten?” me singui wane. ");
INSERT INTO mti_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mu garawa waya, “Ge wag didnuna. Eyawa geumawa danave desirom nanigwa yutanwa apa wanekpe, sira dawa nanigwa ketaiwa apa wanekpe.” ");
INSERT INTO mti_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","“Dimbae oya nun venewa ye me den yaug anoyana,” Iesu wane. “Ye oma ane yoi ap ne natnawa ye me naya, sira babataito me ne autnawa ye oma ane auya?” ");
INSERT INTO mti_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Nu oma ane,” mu garawa waya. Iesu mu dirumne, “Ne ap neuma gumbe yoi natnawa ye naya, sira babataito me ne autnawa ye me gumbe babataito auya. ");
INSERT INTO mti_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Megara ne naniyutanwa go naniketaiwa waketanwa me ne oma den ane yentna. At meiba bira God munan tamibarip anewa mu munan.” ");
INSERT INTO mti_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aigo meumawa 10 mu gae mame anoyawa, Jemus ge Jon gumbo danopiriwane. ");
INSERT INTO mti_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iesu munan auwane agoniyaya, wane, “Ye yaug anoyana, Ju onan namuyoiyoi igiyawa mu iyayapan amat amuniya, sira iyayapan koukawa mu yutuwa painauvit iyayapan gumbo eme. ");
INSERT INTO mti_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Megara ye gaibu onan. Ye bira da ye guniyap kokawa atan anoyawa me iyayapan ankwatowo nau aya, ");
INSERT INTO mti_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","sira bira da namuyoiyoi atan oya anoiviwa, me iyayapan undag munan ankwatave nau aiviwa atanit di. ");
INSERT INTO mti_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Kuiyawa Apan Usiwa iyayapan nau meuma atan oya den aig onne, megara me iyayapan munan nau atan oya sira inaiinai meuma wampe iyayapan obiren kukaeba muma oya garawa atan oya aig onne.” ");
INSERT INTO mti_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Meve mu at Jeriko uwaya. Iesu ge aigowawa iyayapan obiren gaibu gwetoimu kweemewa, yangabored abnawa Barutimias (Natawa me Taimias usiwa), me ebu megiyave yan wakeg dividivi oya nun waivi. ");
INSERT INTO mti_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Meve me yaug anonewa me Nasaret apan Iesu, me amatog kwaruwane, “Iesu, Devid Usiwa, ano nega!” ");
INSERT INTO mti_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Iyayapan obiren me diyag waya, sira me dig waya nogwa iyadgita, megara me kwaruwagewa ane, “Devid usiwa, ne ano nega!” ");
INSERT INTO mti_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iesu tumag yoig wane, “Au menan waya,” mu apan yangabored oya auwaya, “Yutugwa auwa. Wan yoiya. Me genan auwaivi.” ");
INSERT INTO mti_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Enwape meumawa epa aorene, sira me amave pisiag wan yoig Iesu gumbe onne. ");
INSERT INTO mti_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iesu me singui wane, “Ge imugap ne dimbae genan atna?” Yangabored apan wane, “Rabai, ne yautan anoeni.” ");
INSERT INTO mti_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iesu me gumbe wane, “Aga. Anotumat geuma warinam genne.” Me tatevit yangawa oraimina ane, Iesu amave ebu taibe aine. ");
INSERT INTO mti_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mu at Jerusarem uweme tui Orivu kuiyave at Betepage uwayawa, Iesu aigowawa duwam tene amiya, ");
INSERT INTO mti_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","dirum wane, “Gwetoimu da namuyep aisiya. Ye me unigiyawa, eme apa mae donki mataiwa me gerave bira da den dauwanewa murap gumbe tuya wakene ye yauya. Murap atan vesiya, sira aug mame oneya. ");
INSERT INTO mti_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Da bira ye guniyap singui aib wapewa, ‘Ye divi oya mae donki mataiwa murap tuyawa vetene?’ me gumbe aib waya, ‘Ayapan imive wakene. Me sira baraupe koni kusi da mapa ompe.’” ");
INSERT INTO mti_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mu amiya sira donki usiwa me ebu taibe ankwin gumbe murap tuya wakenewa yauya. Mu murap vetemewa, ");
INSERT INTO mti_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","iyayapan upeba asimeve yokeyawa mu dirum waya, “Ye divi oya donki usiwa murap vetene?” ");
INSERT INTO mti_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Mu Iesu dirumne mina garawa wayawa mu bainda waya. ");
INSERT INTO mti_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mu donki usiwa Iesu gumbe aug uwaya. Mu wape geravewa mumawa donki gerave emeya, Iesu me gerave dauwag wakene. ");
INSERT INTO mti_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iyayapan obiren wape geravewa mumawa ebu taibe yayabeyaya, sira upeba mundana yoma naniwa kesiag ebu taibe yayabeyaya. ");
INSERT INTO mti_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iyayapan namive yoig amomewa amave yoiemewa mu kwaruwaya, “Osanna! Apan me Ayapan iviwa gumbe uwapewa, me gumbe waribiya wakeigimpe!” ");
INSERT INTO mti_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Mamunwa Devid kin arawa meuma me oniviwa, me gumbe waribiya wakeigimpe! Osanna at painauiren danave!” ");
INSERT INTO mti_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iesu Jerusarem aig temporu arawa unig aine. Me atan yaug man yaug dividivi undag yaune. Kum wait onanane, me aigowawa 12 gaibu dauwag Betani amiya. ");
INSERT INTO mti_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wantene mu Betani kweemewa, Iesu iyagon adne. ");
INSERT INTO mti_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Me painau yangurane inaru kwayawa gaibu yaune. Magawa da gaibu go onan me yautan aine. Inaru gumbe uwanewa, me yaune magawa onan, kwayawa mekut, kuiyawa inaru kumiwa onan. ");
INSERT INTO mti_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Meve Iesu yoma gumbe wane, “Da bira matai ge magawa geuma den nape.” Me waiviwa aigowawa anoya. ");
INSERT INTO mti_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusarem uwaiviwa Iesu temporu arawa unigne, Iesu temporu arawa unignewa, iyayapan mu gwiruwaremewa ge garawa emewa amatog atatai imne dauwag amiya. Me teboro me anmaga biroriyag auemewa sira umuk gwiruwaremewa undag aug tobiyane. ");
INSERT INTO mti_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Da bira bainda gumbo den wane gwiruwaremewa muma tam temporu arawa danave unig dauwag ampe. ");
INSERT INTO mti_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sira me mu toyau mum wane, “Me da den tene? ‘Ne gwe neuma wape nun gweyawa iyayapan undag oya.’ Megara ye ayana me yuaore toaore igiyawa dagup muma mina ane.” Meib tene. ");
INSERT INTO mti_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pirisi koukawa ge Gwangwan toewanewan igiyawa mame anoyawa mu amatog toatan oya ebu didimama aya. Kuiyawa mu Iesu gumbe a aya, natawa iyayapan undag me Iesu toewanewan meuma gumbe degadega eme. ");
INSERT INTO mti_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","At augoi adnewa, mu gwetoimu kokawa yankweg dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mumbevit mu yoma inaru megiyave uwag amomewa, mu yauya yoma inaru taiwa gaibu undag toyaine. ");
INSERT INTO mti_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita meve imug anone Iesu gumbe wane, “Rabai, Yawa! Yoma inaru me ge yawag wanawa me toyaine!” ");
INSERT INTO mti_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","“God gumbe anotumat a,” Iesu garawa wane. ");
INSERT INTO mti_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“Ne natawa diruitna. Bira da tui mame gumbe aib wapewa, ‘Aga, poeman danave aiga,’ sira me nonemagawa apa anopipanum den ape me membo wanewa pawape anotumat apewa, me gumbe pawape. ");
INSERT INTO mti_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Meoya ne ye diruitna. Divi da oya nun wayanawa, me ye wait auyana anotumat ayawa me yeumawa ape. ");
INSERT INTO mti_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ye wan yoig nun waigimiyawa, ye bira da gumbe anokukam ag a ayawa, kukaeba meuma anog yankweya. Meib aya ipewa Mamewa kwiminauwa me mina ye kukaeba yeuma anog yankwepe.” ");
INSERT INTO mti_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(-) ");
INSERT INTO mti_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mu sira Jerusarem uwaya. Iesu temporu arawa danave yoig gigiviwa, pirisi koukawa, Gwangwan toewanewan igiyawa sira namuyoiyoi igiyawa me gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mu singui waya, “Ge dividivi mame egewa divi yusiwa gumbe ege? Sira yutugwa mame bira genne?” ");
INSERT INTO mti_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iesu garawa wane, “Ne singui desirom yentna. Ye garawa didnegiya, ne matai ye diruitna ne divi yusiwa gumbe dividivi mame eni. ");
INSERT INTO mti_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon babataito meumawa me kwimin apa onne go iyayapan gumbo onne? Ne didnegiya!” ");
INSERT INTO mti_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mu mumbovit gae wageyau aya, sira waya, “Nu aib wata ipewa, ‘Kwimin apa onne,’ me matai wape, ‘Divi oya ye anotumat me gumbe den ayana?’ ");
INSERT INTO mti_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sira nu aib wata ipewa, ‘Iyayapan gumbo onne’....” (Mu iyayapan gumbo a aya, kuiyawa iyayapan undag yumnasiya Jon me propeta da.) ");
INSERT INTO mti_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Meoya mu Iesu gumbe garawa waya, “Nu den yaug anotu,” Iesu wane, “Ne mina ye den diruitna yutunwa divi gumbe ne mame eni.” ");
INSERT INTO mti_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iesu maibe gumbe amatog wag dirumne. “Apan da greip nau meuma vedne. Me si birorot panne, sira wain gotosatanwa oya dukup sine, sira wakeg amaraigimtan gweyawa sine. Meve nau wareme igiyawa mu amaraigimpe me membo at da aine. ");
INSERT INTO mti_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maura kumiwa uwane. Me nau meuma aiviwa baraune nau amareme igiyawa gumbo greip nauwawa danave greip kwerawa botan oya aine. ");
INSERT INTO mti_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Megara mu nau meuma aiviwa yum tug tog naniwa ingui barauya aine. ");
INSERT INTO mti_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Meve me nau abnawa meuma da munan baraune aine. Mu me kuiyave tog ano ubmameba me gumbe aya. ");
INSERT INTO mti_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Me ande da sira baraune aine, sira mu me toenguriya boine. Sira me upeba obiren tene amiya. Upeba mu guriya, upeba guriya boriruwaya. ");
INSERT INTO mti_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Me desirom me baraupe aipewa wakene, me usiwa me nonemagawa. Me oieba baraune aine, wane, ‘Mu ne utunwa ebnotu wampe.’ ");
INSERT INTO mti_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Megara nau igiyawa garawano aya, ‘Mame me kwan autanwa abnawa. Oneya me tota boipe, meve me dividivi meuma numawa ape.’ ");
INSERT INTO mti_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Meoya mu auwag toya boine, sira me greip nau meuma daieve aoreya. ");
INSERT INTO mti_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Meve greip nauwawa kuiya mamawa membo me dimbae ape? Me taig ompe nau igiyawa mu gutpe sira greip nau meuma iyayapan upeba mumpe. ");
INSERT INTO mti_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ye gae mame Baiboru danavewa den yaug basiene? ‘An me gwe sisi igiyawa topayayawa me an natawa kokawa me visidonawa apa teyawa mina ane. ");
INSERT INTO mti_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mame Ayapan ane, nu yangunup yautunewa me oraimina me da den kukaine.’” ");
INSERT INTO mti_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Meve mu Iesu aug totan oya ebu diuya, kuiyawa me maibe gumbe munan dirumnewa mu anoya. Megara mu iyayapan undag munan a aya. Meve mu Iesu yankweg amiya. ");
INSERT INTO mti_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ivi mu Parisi igiyawa ge Erod igiyawa upeba Iesu oya teya amiya, Iesu gae meumawa gumbe yumtan oya. ");
INSERT INTO mti_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mu Iesu gumbe onamiyawa, waya, “Toewanewan, nu yaug anotu ge apan natawa. Sira iyayapan oma den ane ge augempe. Kuiyawa ge mu den yawam anoana mu bira, ge natawa gumbe God ebuwawa toyaumunege. Siisa gumbe takesi garawa apewa me oraimina go onan? ");
INSERT INTO mti_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nu garawa ata go nu garawa den ata?” Megara ugauga mumawa Iesu yaug anone, me singui munne, “Ye divi oya ne aunegatan oya ageyau ene? Denari aug oneya yautna.” ");
INSERT INTO mti_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mu anmagawa aug onamiya sira me singui munne, “Mame bira guwawa? Sira bira tenewa?” “Siisa meuma,” mu garawa waya. ");
INSERT INTO mti_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Meve Iesu mu gumbo wane, “Siisa meumawa Siisa waniya, sira God meumawa God waniya.” Mu me gumbe teraya. ");
INSERT INTO mti_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Meve Sadusi igiyawa mu veme bo gumbe sira den inaipe. Mu Iesu gumbe uwag singui waya, ");
INSERT INTO mti_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Toewanewan, Mosisi nunan tene, ‘Apan tatawa botopewa sira kwapuraeba yankwenewa ud onanwa, me gwaneba kwapuraeba autanit di sira tatawa oya ud tepe.’ ");
INSERT INTO mti_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Gare tatawaiwa undag 7 wakeya. Tatawa namuwa vesin aug me boane, ud onan. ");
INSERT INTO mti_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Duwameba kwapura aune megara me mina boane, ud onan. Duwamdesiyawa mina meib. ");
INSERT INTO mti_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mamaib onamiyawa, apan 7 ud onan. Oieba, vesin gaibu botone. ");
INSERT INTO mti_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sira mu yoipewa kumiwa apa, vesin me undag 7 danave bira biviwa ape, kuiyawa mu undag vesin me auya?” ");
INSERT INTO mti_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iesu garawa wane, “Ye gwambe yaug anoyana, kuiyawa ye Baiboru ge God yusiwa den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wanampa boriruwayawa yoig wanekpewa, apan vesin den aupe, sira vesin apan den aupe, kwimin danave mu matai aneya mina wakepe. ");
INSERT INTO mti_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Boriruwayawa yoig wanektan oya, Mosisi buka meuma danave, mundana apa God me Mosisi gumbe anin wanewa ye den basiyayana? ‘Ne Eburaam God meuma, Aisak God meuma sira Jekob God meuma.’ ");
INSERT INTO mti_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Me bo igiyawa God muma onan, megara me kaninga wakeemewa God muma. Ye gwambe di ene!” ");
INSERT INTO mti_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Gwangwan toewanewan desirom da uwane. Me Iesu gae garawa eme anone yaug anone Iesu garawa oraimina munne, me wag dine, “Gwangwan undag danave natawa kokavitwa me ambuwa?” ");
INSERT INTO mti_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iesu garawa wane, “Kokavitwa me mame: ‘Isuraeru anoya. Ayapan God numa me Ayapan desiromiren. ");
INSERT INTO mti_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nonegmagawa undag gaibu, guwawa geuma undag gaibu, imugwa undag gaibu, yutugwa undag gaibu, Ayapan God geuma gumbe baigan a.’ ");
INSERT INTO mti_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Duwameba me mame. ‘Ge iyayapan baigan munigima ge gembo baigan niege mina.’ Gwangwan kokavitwa mame minawa da den wakene.” ");
INSERT INTO mti_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Apan me garawa wane, “Ge bainda wana, toewanewan. ‘God desiromiren sira da ube onan, me mekut. ");
INSERT INTO mti_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‘Nonegmagawa undag gaibu, anoano geuma undag gaibu, yutugwa undag gaibu, me gumbe baigan a’, sira ‘Ge iyayapan baigan munigima ge gembo baigan niege mina,’ Mame oraiminavitwa. Mae puyo okeremewa ge nakwai teemewa me mina onan.” ");
INSERT INTO mti_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesu yaunewa me garawa oraivit wane, me gumbe wane, “Ge God toimuwawa apa arama den wakeyana.” Kum me ivi, bira da Iesu gumbe singui da watan den anone. ");
INSERT INTO mti_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iesu temporu arawa apa toyau muniviwa me singui munne, “Aninin Gwangwan toewanewan igiyawa veme Keriso me Devid usiwa? ");
INSERT INTO mti_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devid membo waivi Guwawa Iyakaisiyapama gumbe taibe wane: ‘Ayapan me Ayapan neuma gumbe wane: “Nanin yutanwa apa wakeigima, ivi anavi geuma amagwa ankwatave ne tetna.” ’ ");
INSERT INTO mti_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devid membo Keriso gumbe Ayapan wane, aninin Keriso me Devid usiven ape?” Iyayapan obiren me gumbe degadegaepam anoeme. ");
INSERT INTO mti_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Iesu toyau muniviwa me wane, “Gwangwan toewanewan igiyawa oya yaukape. Mu imuwo wape yobutaren oraivitwa enam gwiruwaremewa arawa apa birorot gigimpe iyayapan engaun mumpe. ");
INSERT INTO mti_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sira mu imuwo sinagogu danave seya painauwa waketan anoeme sira buyunai nemewa at painauwa apa waketan anoeme. ");
INSERT INTO mti_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mu kwapura gweyowa apa iyab muneme, sira iyayapan yawamtan oya nun yobenut veme. Iyayapan meiba mu matai ibnapamit nau mumpe.” ");
INSERT INTO mti_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iesu puyo barauemewa arawa gambena apa yan wakene, iyayapan anmaga temporu puyo teemewa danave teeme yaune. Tawara igiyawa obiren anmaga koka teeme. ");
INSERT INTO mti_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Megara kwapura gwandakwaeba uwane me anmaga kopa kusiwa reputa duwam tene. Anmaga reputa duwam garawa me anmaga kodorant desirom. ");
INSERT INTO mti_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iesu aigo meuma auwane mu onamiya. Me wane, “Ne ye natawa diruitna. Kwapura gwandakwaeba mame me puyo teemewa danave puyo obiren tene, iyayapan upeba undag mina onan. ");
INSERT INTO mti_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mu tawara egave em yoiya. Megara kwapura mame me undag me gumbe wakeg aigimtanwa meme tene.” ");
INSERT INTO mti_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iesu me temporu arawa yankweg dauwag aitan aiviwa, aigo meuma desirom da me gumbe wane, “Yawa, toewanewan! An kouka! Gwe oraimina!” ");
INSERT INTO mti_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“Ge gwe kouka undag mame yavege?” Iesu garawa wane, “An desirom da mapa dawa egave den wakepe; an undag gwiriruwag aikpe.” ");
INSERT INTO mti_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Temporu gambena apa, Iesu tui Orivu kuiyave wakenewa, Pita, Jemus, Jon ge Andru mukuren me gumbe singui waya, ");
INSERT INTO mti_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Didnuna, kum divi dividivi mame pawape? Sira undag mame pawatan aigimpewa irakoniwa aninin?” ");
INSERT INTO mti_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iesu mu gumbo amatog wane, “Yaukape iyayapan da ye den uga yempe. ");
INSERT INTO mti_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Obiren ne ivunwa gumbe uwape, waigimpe, ‘Ne me,’ sira obiren ugai mumpe. ");
INSERT INTO mti_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wanampa mut gaiyawa ge kigemuk mut oya anoyawa, me den teraya. Dividivi meiba pawatanit di, go oieba oya me matai uwape. ");
INSERT INTO mti_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","At sinsin igiyawa mu at sinsin igiyawa dawa gaibu matai yoig mut watpe, sira at kokawa me at kokawa dawa gaibu matai yoig mut watpe. At upeba gumbe matai iyagon ge pinunu ape, sira iyagon kumiwa uwape. Undak mame ud yaitan dawaiba amatoiviwa mina. ");
INSERT INTO mti_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ye yembovit amaraya. Iyayapan ye tam teempe daiboru yemboa nanuwo, sira sinagogu danave gurepe. Sira ne nau neumawa oya ye amareme igiyawage kin yeuma mu namuwo yoiya. Me dividivi undag ye yauyanawa mu dirumtan oya. ");
INSERT INTO mti_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gae oraiwa namuiren dig gwetoimu undag gumbo opata wape. ");
INSERT INTO mti_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mu ye da tuepewa sira nanuwo te yempewa, namu gae anin watan oya den anoya. Kum me kumiwa apa toyau yempewa me di waya, kuiyawa ye den gae waya, Guwawa Iyakaisiyapama me wape. ");
INSERT INTO mti_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tatawa gwaneba anavi ag omin baraupe, da botope. Mamawa usiwa gumbe anavi ape botope; usitainawa mu mamuwa ge inowa gumbo gara kwaviyape, mu boriruwape. ");
INSERT INTO mti_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kuiyawa me ivunwa oya, iyayapan undag ye diruipe watkukam yempe, go bira da oiyeba konive yusiyusi ag yoigimpewa matai waita wampe. ");
INSERT INTO mti_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Wanan ye yauya ‘Topai abnawa me di wakukampewa’ me yokeigimpe megara at meumawa onan—Basiemewa igiyawa yaug anoya—iyayapan mu Judia apa wakeyawa mu tui gumbe a ampe. ");
INSERT INTO mti_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Bira da me gweyawa gwanob gerave wakenewa den kweg aikpe, sira divi da autan oya gwe den unikpe. ");
INSERT INTO mti_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Bira da nau danave wakenewa wape autan oya den sira taig ompe. ");
INSERT INTO mti_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Me kumiwa di kukaipe, vesin bug ayawa gumbo, sira inanaiwa ud am munemewa gumbo. ");
INSERT INTO mti_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Meoya ye nun waya mame taigipam kumiwa danave den pawape. ");
INSERT INTO mti_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kuiyawa me danadawai kokavitwa kumiwa. Me God at piyu wadne kumiwa apa onne gare mame, me den pawane sira me matai den pawape. ");
INSERT INTO mti_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ayapan me kumiwa den kwagomiyape pipi apewa, iyayapan desirom da den vinigimpe. Megara wak tamne igiyawa oya, Ayapan me kumiwa kwagomiyane pipi ane. ");
INSERT INTO mti_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Me kumiwa apa, iyayapan da guniyap wapewa, ‘Yauya, Keriso mame!’ go ‘Yauya, me asime!’ megara den anotumat aya. ");
INSERT INTO mti_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Keriso ugaugaeba sira propeta ugaugaeba mu matai uwape, sira mu guwaguwawa ge irayauyau ape, sira me oma apewa mu wak tamne igiyawa gumbo matai uga yempe. ");
INSERT INTO mti_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Meoya yembovit amaraya. Ne dividivi undag kum namiven wait ye diruina. ");
INSERT INTO mti_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Megara danadawai kumiwa me amave atataivi, ‘Kum matai sisip uwag ompe, sira dud den esipe; sira kwimin yusiwa ipunapun ape. ");
INSERT INTO mti_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","marantun kwimin gumbe aikpe, Sira kwimin yusiwa meuma ipunapun ape.’ ");
INSERT INTO mti_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Me kumive, iyayapan mu Apan Usiwa me irikup danave yusiwa ge eyawa koka gaibu uwaigimpe yaupe. ");
INSERT INTO mti_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sira Apan Usiwa me aneya meuma tepe ompe, kwimin piyu gina gambenwa yunadnewa aig gambenwa uwanewa, at ginawa duwam ge duwam gumbe, iyayapan gomiya munnewa matai agoniyape. ");
INSERT INTO mti_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Gare yoma inaru gumbe maibe mame yaug anoya. Yoma begawa duwaipe sira kwayawa taibe apewa, tate ye yaug anoya me kum kumiwa me koni aivi. ");
INSERT INTO mti_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ebu me desiroma, ye me dividivi mame undag yauyawa, Apan Usiwa me ankwin noive koni aivi yaug anoya. ");
INSERT INTO mti_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ne natawa diruitna, namu dividivi undag mame veniyape, ivi matai kum garewa uwag aipe. ");
INSERT INTO mti_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kwimin ge piyu mame onanape, megara gae neumawa den onanape.” ");
INSERT INTO mti_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Oiyat me, nib koniwa da bira den yaug anone. Aneya kwiminauwa ge Usiwa mu mina den yaug anoya. Megara Maman mekut yaug anone. ");
INSERT INTO mti_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Amat yembovit aya! Yangewa mereruwape yangut aigimiya! Ye den yaug anoyana kum divi me uwape. ");
INSERT INTO mti_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Me gwe mamawa ampa aivinewa mina. Me gwe meuma yankweg nau meumawa amaratanwa igiyawa kuiyave kuiyave tepe amarape, desirom desirom nau meumawa anin tenewa ape, sira ankwin noive amaraivi abnawa dipe yangut aigimpe. ");
INSERT INTO mti_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Meoya yangut ande aigimiya, kuiyawa ye den yaug anoyana kum divi gwe mamawa taig uwape—anten augoiyau go aram nub bagiwa apa go kokorek waigimpe gumbe go wantete apa go. ");
INSERT INTO mti_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Me ui onan da uwapewa, me den kubvinigimiya yawaipe. ");
INSERT INTO mti_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ne ye guniyap veniwa ne meib iyayapan undag gumbo veni, ‘Yangewa mereruwape kaipat aigimiya!” ");
INSERT INTO mti_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gare Uwag Gaveya Buyunaeba ge Bredi Iisut Onanwa Buyunaeba oya oiyat duwam wakeya. Pirisi koukawa ge Gwangwan toewanewan igiyawa mu aninin ake Iesu aug totanwa oya gaiyawa dima yuya. ");
INSERT INTO mti_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mu waya, “Buyunai danave oraimina onan, kuiyawa iyayapan mut yoipetan.” ");
INSERT INTO mti_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Iesume at Betani apa apan Saimon gweyave wakene. Me yuwat warumne iviwa reprosi aunewa. Me teboro apa wakenewa, vesin da uwane. Arabasta ap me danave Narudo oira tayapama me garawa kokawa wakenewa, me aug uwane. Me ap warensine oira tayapama Iesu kuiyave egamne. ");
INSERT INTO mti_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iyayapan upeba asimeve wakeyawa mut igamne gae garawa aya, “Me divi oya oira tayapama beregam aivi? ");
INSERT INTO mti_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Me gwiruwatponowa me garawa 300 denari sira egave aupono. Sira anmaga me gwandokuwaeba igiyawa mumpono.” Mu gae gera gerave me gumbe wa ge wa aya. ");
INSERT INTO mti_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Megara Iesu wane, “Yankweya me anoiviwa ape. Divi oya ye me pui yuene? Me ne gunap oraimina di ane. ");
INSERT INTO mti_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gwandokuwaeba igiyawa mu kum evedni ye gaibu wakeya. Sira ye oma ape mu waita muniya kum da ye imuyep apewa. Megara ne guniyap evedni den wakeeni. ");
INSERT INTO mti_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Vesin mame oma ane anewa ane. Me oira tayapama kwapunwa egamnewa me bo neuma oya namiven tamibarip ane. ");
INSERT INTO mti_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne natawa diruieni. Piyu mame danave at ampa ampa undag gae oraiwa mame opata wapewa, vesin mame anewa gaibu dirumpe me imug anope.” ");
INSERT INTO mti_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Meve Judas Isukariot, aigowawa 12 danowo desirom da, me Iesu ominawa tetan oya pirisi koukawa munan aine. ");
INSERT INTO mti_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mu mame anoyawa degadega aya. Mu anmaga wantan oya agi waya. Meoya Judas me Iesu nanuwo barautan oya ebu da oraiwa diune. ");
INSERT INTO mti_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Iist Onanwa Bredi Buyunaeba kum namuirenwa, me Uwag Gaveya sip usiwa toin guttan kumiwa, Iesu aigowawa me gumbe singui waya, “Ampa ge imugap Uwag Gaveya Buyunaeba nakwai meuma ge natan oya nu ampa anke tamibarip ata?” ");
INSERT INTO mti_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Meoya me aigowawa duwam tene amiya, sira dirum wane, “Gwetoimu kokawa danave aisiya. Me apa apan da me yoi irutawa aug aivinewa me ye yauyempe, me amave aisiya. ");
INSERT INTO mti_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Gwe danave unig amiyawa, gwe abnawa gumbe waya, ‘Toewanewan didnunne. Ne amdau pantut neuma ampa? Me danave ne Uwag Gaveya Buyunaeba aigo neuma gaibu nata.’ ");
INSERT INTO mti_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pantut kokawa painauwa me toyau yempe yauya teboro ge seya dividivi wait tamibarip ane. Me apa nunan tamibarip aya.” ");
INSERT INTO mti_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Me aigowawa dauwag amiya. At kokawa danave unigiyawa mu yauya dividivi wait Iesu mu gumbo wanewa mina. Meve mu Uwag Gaveya Buyunaeba oya tamibarip aya. ");
INSERT INTO mti_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","At augoi uwag onnewa, Iesu aigowawa 12 gaibu asime uwaya. ");
INSERT INTO mti_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mu teboro apa wakek nakwai nemewa, Iesu wane, “Ne natawa diruitna. Ye da ne omin neuma barautan aivi—ud me gare ne gaibu nakwai netewa da.” ");
INSERT INTO mti_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mu danadawai auya desirom desirom me gumbe waya, “Natawa di me ne onan?” ");
INSERT INTO mti_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Iesu garawa mu gumbo wane, “Me aigo neuma 12 danowo desirom da. Me ne gaibu bredi kabum danave puwamnewa. ");
INSERT INTO mti_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Baiboru gumbe nenan tenewa mina Apan Usiwa me matai kweg aipe. Apan Usiwa gumbe omin meuma tepewa me gumbe ano kukaeba wakeigimpe! Me den yaipawa me menan oya oraimina.” ");
INSERT INTO mti_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu nakwai nemewa Iesu bredi aune, engaun wanne sira wapeyam aigo meuma munne. Me wane, “Auya, mame ne kwapunwa.” ");
INSERT INTO mti_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Meve me ap aune, engaun wanne, sira aigo meuma munne me gumbe mu undag naya. ");
INSERT INTO mti_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Iesu mu gumbo wane, “Mame ne ganigani neuma agi wanawa, ganigani areriyag aikpe iyayapan obiren munan. ");
INSERT INTO mti_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne ye natawa diruitna. Ne yoma greip magawa yoiba sira den natna. Ne waketna God toimuwawa danave meve mataiwa natna.” ");
INSERT INTO mti_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mu waiyawaiya bererinawa toya onananewa, mu dauwag tui Orivu oya amiya. ");
INSERT INTO mti_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iesu mu gumbo wane, “Ye undag matai uyug aigiya. Kuiyawa me wait tenewa di: ‘Mae sip amaraivi abnawa ne totnawa sip mu marewampe.’ ");
INSERT INTO mti_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Megara ne sira wan yoitnawa, ivi ne matai namuiban at Gariri anekna.” ");
INSERT INTO mti_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita taibe wane, “Anten undag matai uyug aikpe mina, go ne onan.” ");
INSERT INTO mti_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iesu garawa wane, “Ne natawa diruktna. Kum garewa,—aram garewa—, namu ge koniwa duwamdesi wa me ne den yaug anonega, ivi kokorek koniwa duwameba wape.” ");
INSERT INTO mti_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Megara Pita noiwa yusipamit wane, “Anten ne ge gaibu bo ata go, megara ne den di watna, ‘Ne den yaug anogemna.’” Sira aigowawa upeba undag gae desiroma waya. ");
INSERT INTO mti_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mu at iviwa Gessemani oya amiya. Aigo meuma gumbo Iesu wane, “Ne nun waigimpnawa ye mapa wakeya.” ");
INSERT INTO mti_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Me Pita, Jemus ge Jon tam gaibu amiya. Me amatog danadawai kokavit aune. ");
INSERT INTO mti_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Me gumbo wane, “Danadawai kokavit auna guwanwa bo yumatawa apa avivi. Mame apa wakeg yangewa mereruwape.” ");
INSERT INTO mti_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kusi utan aig petat piyu egave aigne nun wane, “Me oma ape ipewa kum mame ne gunap uwag gaveyag aipe.” ");
INSERT INTO mti_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Me sira wane, “Abba Maman, ge gungap dividivi undag oma ane. Ne gunap ap mame atan auwa. Megara ne anoeniwa onan, anoegewa a.” ");
INSERT INTO mti_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Meve aigo meumawa Iesu sira taig onne. Me yawamnewa mu kubvineme. Me Pita gumbe wane, “Saimon, ge kubvinege? Ge kum desirom mina oma den ane yangut aigima? ");
INSERT INTO mti_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yangagwa mereruwape kaipat aigima sira nun waigima. Amaorot danave den uyug aiga. Guwagwa imive aivi, go kwapugwa yusiwa onan.” ");
INSERT INTO mti_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iesu me sira taig aig gae desiroma gumbe nun wane. ");
INSERT INTO mti_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Me sira taig onnewa, me yawamne mu sira ande kubvineme. Kuiyawa yangowa ibnawaya. Mu den yaug anoya anin Iesu gumbo wape. ");
INSERT INTO mti_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Koni duwamdesiyawa Iesu sira taig uwane mu gumbo wane, “Ye kub ande vinene, nonewa emene? Minambe! Kum uwane. Yauya, Apan Usiwa kukaeba igiyawa nanuwo omin meuma baraupe. ");
INSERT INTO mti_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wan yoiya! Anta! Mame ne omin neuma tenewa abnawa uwane!” ");
INSERT INTO mti_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iesu me gae waivinewa, Judas me aigowawa 12 danowo desirom da uwane. Me gaibu iyayapan obiren deba ge gadiga tam uwaya. Pirisi koukawa, Gwangwan toewanewan igiyawa sira namuyoiyoi igiyawa mu teya onamiya. ");
INSERT INTO mti_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gare omin baraunewa abnawa mu gaibu ebu wariya. “Apan me ne uwa totnawa me me. Me yum yusiwa veyag aug aisiya.” ");
INSERT INTO mti_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas tatevit Iesu gumbe uwag wane, “Rabai!” sira me uwatone. ");
INSERT INTO mti_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iyayapan Iesu yum auya. ");
INSERT INTO mti_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Me apa Iesu gumbe yokeemewa danowo desirom da me deba meuma arobne pirisi painauvitwa nau meuma wariviwa da viyag naunawa kwagomiyane aigne. ");
INSERT INTO mti_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iesu wane, “Ne ub igiyawa tam namuyoiyoi eni go? Meoya ye deba ge seri gumbe ne yumnektan uwayana? ");
INSERT INTO mti_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kum evedni ne ye gaibu, sira temporu arawa danave ye toyau emeni, megara ye den ne yum negiyana. Megara Baiboru gaiyawa me di veniyape.” ");
INSERT INTO mti_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Meve iyayapan undag Iesu yankweyeg a amiya. ");
INSERT INTO mti_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Apan mataiwa me taibe, wape rinen egavewa mekut enne. Me Iesu amave aivinewa mu me yumtan eme. ");
INSERT INTO mti_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Me wape meuma yankweg taibe kintog a aine. ");
INSERT INTO mti_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mu Iesu pirisi painauvitwa gumbe aug amiya. Pirisi koukawa ge namuyoiyoi igiyawa ge Gwangwan toewanewan igiyawa undag uwag agoniyaya. ");
INSERT INTO mti_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita kusi isinutiren me amave aig pirisi painauvitwa gwe arawa unigne. Me apa gwe amaremewa gaibu yan wakeg iyam veraivi. ");
INSERT INTO mti_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pirisi koukawa ge Daiboru Painauvitwa igiyawa undag Iesu tope boatan oya gae umum natawa didimama eme. Megara mu natawa da den yauya. ");
INSERT INTO mti_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iyayapan obiren me gumbe ugauga waya, megara umum muma wayawa me den yunadne. ");
INSERT INTO mti_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Meve iyayapan upeba wan yoike ugauga umumawa mame me gumbe waya: ");
INSERT INTO mti_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nu anotu me wane, ‘Ne temporu mame me iyayapan siyawa wakukampna, sira kum duwamdesi danave dawa me iyayapan nanuwo den sipewa ne sitna.’” ");
INSERT INTO mti_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Megara me apa umum mumawa den yunadne. ");
INSERT INTO mti_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Meve pirisi painauvitwa iyayapan yapowo wan yoine Iesu gumbe singui wane, “Ge garawa wa go onan? Iyayapan mame umum kukaeba gungap vemewa ge anin anoege?” ");
INSERT INTO mti_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Megara Iesu ande iyaigidne garawa den wane. Pirisi painauvitwa me gumbe singui sira wane, “Ge Keriso, Waribiyanewa Usiwa?” ");
INSERT INTO mti_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Iesu garawa wane, “Ne me. Ye matai yauya Apan Usiwa me Yusipama naniyutanwa apa wakeigimpe, sira guwaveru kwiminau egave wakeg uwaigimpe yauya.” ");
INSERT INTO mti_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pirisi painauvitwa wape meumawa warimine. Me wane, “Divi oya nu yauyawa da tamta? ");
INSERT INTO mti_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ye God gumbe iyagau mina anoene. Ye anin anoene?” Mu undag me gumbe anog waya me boatanit di. ");
INSERT INTO mti_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Meve iyayapan upeba amatog gwitup me gumbe emiya. Mu me yangawa tuboriya nanuwa gumbe toya, sira waya, “Ge wa, bira toagivi!” Sira gwe amaremewa me aug toya. ");
INSERT INTO mti_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita me gwe visive painau wakenewa vesin otau me pirisi painauvitwa nauwawa aiviwa da megiyave uwane. ");
INSERT INTO mti_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Me yaune Pita iyam iraivi, sira me gumbenut yangut yaune, wane, “Ge mina Nasaret apan Iesu gaibu gigene.” ");
INSERT INTO mti_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Megara me uyai wag wane, “Ne den yaug anona ge divi oya vege.” Me ankwin noiwa gumbe aine. ");
INSERT INTO mti_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Meve vesin otau nauwawa aiviwa me Pita yaune, iyayapan birorot yokeyawa gumbo me sira amatog wane, “Apan mame mu dawa.” ");
INSERT INTO mti_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Me sira uyai wane. Pungi den wane, iyayapan birorot yokeyawa sira Pita gumbe waya, “Natawa di, ge mu desiroma da, kuiyawa ge Gariri apan.” ");
INSERT INTO mti_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Me amatog aewag wane. Me gae natawa di mu gumbo wane, “Apan mame ye menan venewa ne den yaug anona.” ");
INSERT INTO mti_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tatevit kumkum duwameba wane. Meve Pita me watavit Iesu gae wanewa imug anone, “Namu koni duwamdesi ge ne topai negawa, ivi kumkum koni duwam wape.” Sira me petat tog iruwane. ");
INSERT INTO mti_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mumbevit pirisi koukawa, namu yoiyoi igiyawa, Gwangwan toewanewan igiyawa, ge Daiboru Painauvitwa igiyawa undag gaibu dima yuya. Mu Iesu tug dauwag amiya. Pairat nanive me barauya. ");
INSERT INTO mti_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pairat Iesu gumbe singui wane, “Ge Ju igiyawa kin mumawa?” Iesu garawa wane, “E, meme vege.” ");
INSERT INTO mti_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pirisi koukawa Iesu gumbe dividivi undag pui yusipamit yuya. ");
INSERT INTO mti_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Sira Pairat me singui wane, “Ge gae garawa da den wa? Yawa, mu ge gungap dividivi undag pui yuwageme.” ");
INSERT INTO mti_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ande Iesu gae garawa da den wanewa, Pairat terane. ");
INSERT INTO mti_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gare, buyunai kokawa kumive, kansoru kokawa anoanowawa wakene. Nog aegiya iyayapan wag desirom ingui arob baraupe dauwag aipe. ");
INSERT INTO mti_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Apan da iviwa Barabas nog dana wakene. Iyayapan mut igamivi mut ag guriya boriruwaya. Me mu gaibu nog danave wakeya. ");
INSERT INTO mti_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aninin bairawan evedni Pairat munan aivi mina atan oya, iyayapan obiren Pairat gumbe uwag amatog dig waya. ");
INSERT INTO mti_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pairat garawa wane, “Ye anoene ne Ju igiyawa kin muma yenan kwetna dauwag aipe?” ");
INSERT INTO mti_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kuiyawa me yaug anone pirisi koukawa mu gunarepam eme oya Iesu aug waniya. ");
INSERT INTO mti_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Megara pirisi koukawa mu iyayapan obiren Pairat dipe mu imuwo Barabas kwepe dauwag aipe. ");
INSERT INTO mti_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Meoya, Pairat sira dirum wane, “Ne apan mu vemewa Keriso oya aninin aten?” ");
INSERT INTO mti_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mu kwaruwaya, “Korosi gumbe toya!” ");
INSERT INTO mti_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Megara Pairat wane, “Divi oya? Kukaeba meuma divi ane?” Megara mu nouwa au ge kwaruwag waya, “Korosi gumbe toya!” ");
INSERT INTO mti_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pairat imive iyayapan obiren degadega ape. Sira me Barabas me arobne dauwag aine. Me Iesu murap yaigipama gumbe toya, sira korosi gumbe totan oya mu nanuwo baraune. ");
INSERT INTO mti_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mut igiyawa Iesu auwag kokawa gweyawa danave unig amiya. Gwe me Romu kokawa muma baraune onne amarag viniviwa. Sira mut igiyawa undag agoniyatan auwaya. ");
INSERT INTO mti_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mu me gumbe wape yobutaren en waniya,—wape gamateba me pundirit ge diyapam yapavewa,—meve mu murap ipuni ganaganapam aug ikoki ag kuiyave tonasiya. ");
INSERT INTO mti_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Meve mu amatog menan auwaya, “Kaiwa kaiwa! Ju igiyawa kin mumawa!” ");
INSERT INTO mti_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sira mu tutu gumbe me kuiyave toya, gwitup me gumbe emiya, koniwo yug me gumbe petat aya. ");
INSERT INTO mti_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mu Iesu gumbe iyagau wag, wape asime atan aropeg wape meuma yobutatae aug enwaniya, wape gamateba me pundirit ge diyapam yapavewa. Meve me auwag taibe dauwaya yoma korosi gumbe tope boitan oya. ");
INSERT INTO mti_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Saimon me at Sairin apan, Rupas ge Arekisanda mamowa. At meuma apa uwag onnewa. Me korosi oieve autan oya ayag waya aune. ");
INSERT INTO mti_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mu Iesu auwag at iviwa Gorugosa uwaya. Me natawa at me Kuiyamarednawa. ");
INSERT INTO mti_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Meve mu wain me gegura iviwa maaru gaibu biroriyayawa waniya, go me den nane. ");
INSERT INTO mti_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Meve mu korosi egave toya. Mu wape meuma kepteya, biravit divi autan oya kae kusi aya. ");
INSERT INTO mti_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mu korosi egave me toyawa me mumbe kum koniwa 9 apa. ");
INSERT INTO mti_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Gigirum me kukaeba meuma teg yauyawa me aib tene: JU IGIYAWA KIN MUMAWA. ");
INSERT INTO mti_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mu ub igiyawa duwam korosi egave mu gaibu towamiya, da naniyutanwa, da naniketaiwa apa. ");
INSERT INTO mti_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(-) ");
INSERT INTO mti_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iyayapan bira bira uwag amomewa gae kukaeba Iesu gumbe veme, kuiyowa viyaviya eme, mu veme, “Ge wana, ‘A! Temporu toyayag sira kum duwamdesi danave sitna.’ Gembovit wag inaigita. ");
INSERT INTO mti_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Korosi gumbe aig onaga gembo waita a!” ");
INSERT INTO mti_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ebu desirom gumbe pirisi koukawa ge Gwangwan toewanewan igiyawa mu gaibu Iesu gumbe yano waya. Mu waya, “Me iyapan upeba waita munne, go me oma den ane membo ingan waita wampe! ");
INSERT INTO mti_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Keriso, Isuraeru kin mumawa, gare mame di korosi gumbe aig onaga. Nu yautave ge gungap anotumat ata.” Iyapan Iesu gaibu korosi egave towamiyawa mu mina gae kukaeba Iesu gumbe dig waya. ");
INSERT INTO mti_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kum kuiyunup aune, at undag sisip uwag aine, augoi kum koniwa duwamdesi aune. ");
INSERT INTO mti_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kum duwamdesi aunewa Iesu noiwa kokavit wane, “Eroi Eroi rama sabakutani?”—Me natawa, “Maman maman, divi oya ne yankwenegana?” ");
INSERT INTO mti_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iyayapan upeba megiyave yokeemewa anog waya, “Anoya! Me Eraija oya auwaivi.” ");
INSERT INTO mti_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Apan desirom kin tog, sponji danave wain sisipam em arob aug tutu ginave yune Iesu natan oya wanne, me wane, “Me yankweya wakepe. Nu yauta Eraija uwag me aug aikpe, go.” ");
INSERT INTO mti_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iesu awau kokavit wanewa gaup meuma oieba tareyane. ");
INSERT INTO mti_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Temporu danave wape kokawa me geroriyayawa me kuiyawa apa dumed aig onke ginawa uwane duwam ane. ");
INSERT INTO mti_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Senturion me Iesu namive yoinewa me awau wanewa anone, me aninin botone yaug wane, “Natawa di apan mame God Usiwa!” ");
INSERT INTO mti_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vesin upeba painau apa yan greme. Mu danowo Magdara vesin Meri, Jemus kusikaren ge Josep inawa Meri ge Sarome wakeya. ");
INSERT INTO mti_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","At Gariri apa vesin mu Iesu amave onamiya sira amat meuma aya. Vesin obiren upeba me gaibu at Jerusarem uwayawa mu asimeve wakeya. ");
INSERT INTO mti_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Augoi uwag onne. Kum me Tamibarip Kumiwa, sira me namiven umae Sabat Kumiwa. ");
INSERT INTO mti_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","At Arimataya apan Josep, me Daiboru Painauvitwa igiyawa yapowo kokawa. Me membo God toimuwawa uwatanwa oya amaraivi. Me ano meuma yusipamit ane Pairat gumbe uwag Iesu kwapiwa oya nun wane. ");
INSERT INTO mti_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pairat Iesu wait boanewa anog terane. Me senturion menan auwag singui wane Iesu wait boane go onan. ");
INSERT INTO mti_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Me senturion gumbe natawa di wat kiniyanewa, Iesu kwapiwa Josep wanne. ");
INSERT INTO mti_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep wape rinen gwiruwadne. Kwapiwa aug aignewa wape me gumbe panne. Sira dagup danave baraune. Dagup me an koka kwabnewa. Meve me an koka wak siririyane dagup ankwinawa tobodne. ");
INSERT INTO mti_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Magdara vesin Meri ge Jose inawa Meri mu Iesu barauyawa arawa yangowo yauya. ");
INSERT INTO mti_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat Kumiwa onananewa, Magdara vesin Meri ge Jemus inawa Meri ge Sarome, mu Iesu kwapiwa oira barautan oya aroma gwiruwariya. ");
INSERT INTO mti_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pura danave kum namuirenwa mumbevit, kum di dauwaivi, dagup oya onamiya, ");
INSERT INTO mti_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","sira vesin mu gae singui garawa aya, “Bira da dagup ankwinawa apa an itariyape watappe?” ");
INSERT INTO mti_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Megara mu yangut wan yauyawa, mu an koka me wait itariyane. ");
INSERT INTO mti_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mu dagup danave unigiyawa, mu apan mataiwa me wape yobutatae puipuyuwa enne yutanwa apa yan wakeivi yauya. Vesin a aya. ");
INSERT INTO mti_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Megara me wane, “A den aya. Ye Nasaret apan Iesu me korosi egave toyawa oya yobene? Me sira inaig yoine! Me mapa den wakene. Yauya me barauyawa arawa. ");
INSERT INTO mti_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ye aisiya, aigo meuma ge Pita dirumiya, ‘Me namuiban Gariri aivi, me anin diruinewa mina, me apa ye me yauya.’” ");
INSERT INTO mti_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Vesin mu daramdaram sira pimpangit ag, dagup apa dauwag kintog amiya. Mu da bira divi da den diya, kuiyawa a aya. ");
INSERT INTO mti_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pura amatonewa apa mumbevit Iesu sira inaig yoinewa, me Magdara vesin Meri gumbe namu uwane. Numan Iesu airapu kukaeba 7 vesin me gumbe atatai imne. ");
INSERT INTO mti_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Iyayapan mu Iesu gaibu gigemewa danadawai auwag iruveme. Meri mu gumbo aig dirumne. ");
INSERT INTO mti_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mu anoya Iesu me inaine vesin me yaune, megara mu anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ivi apan duwam mu at da oya amomewa, Iesu tobiyane gina ube mu gumbo uwane. ");
INSERT INTO mti_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mu duwam mame sira taigiya upeba gumbo umum waya, megara mu mina anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ivi aigowawa 11 nakwai nemewa Iesu mu gumbo uwamunne. Me anotumat muma yan aigne sira nokakae aya oya me mu gumbo yamdapam wane. Kuiyawa Iesu sira inaig yoinewa iyayapan yauyawa mu iyayapan upeba gumbo umum wayawa mu anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Me mu dirumne, “Piyu undag gumbe dauwag aisiya. Sira gae oraiwa undag wat temunnewa gumbo dirumiya. ");
INSERT INTO mti_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Bira da anotumat ag babataito apewa me waita aupe. Megara bira da me anotumat den apewa me ibnawa aupe. ");
INSERT INTO mti_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Sira irairawa mame anotumat aya igiyawa gumbo. Ne ivunwa gumbe airapu kukaeba atatai impe; mu pednowa mataiwa gumbe gae wape; ");
INSERT INTO mti_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mu mokare nanuwo gumbe wan aupe; mu yoi kukaeba nape, go mu gumbo da den di kukaipe; mu nanuwa yuwat igiyawa egowo tepe oraimina ape.” ");
INSERT INTO mti_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ayapan Iesu mu gumbo gae wane, meve me kwimin danave dog aine sira God naniyutanwa apa wakene. ");
INSERT INTO mti_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Meve aigowawa dauwag amiya sira ampa ampa gae wag dirumiya. Ayapan mu gaibu nau ag gae meuma wat kiniyatan oya irairawa toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Iyayapan obiren dividivi me nu yapunup anotumat atuwa gigirumawa amatog teeme. ");
INSERT INTO mti_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Me dividivi mu barauya aig onne gunup. Iyayapan mu amatonewa gumbe yangowo yauyawa sira gae anotumat igiyawa desiromit tetan oya nau eme. ");
INSERT INTO mti_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ne gaibu amatonewa gumbe yaimoyai dividivi yaug anona. Meoya Teopiras, apan kokawa oraiwa, genan yunat tetanwa me oraimina anoeni. ");
INSERT INTO mti_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Me gumbe ge yaug anoa dividivi wait toyau geniyawa me natawa. ");
INSERT INTO mti_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judia kin Erod kumive, pirisi iviwa me Jakaraya wakene. Me Abaija dam meuma desiroma. Me biviwa Erisabet gaibu me Aaron dam gumbe yaig onnewa. ");
INSERT INTO mti_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Duwam mame mu God yangave oraimina eme. Mu Ayapan gwangwaneba undagit yaimoyai amareme. ");
INSERT INTO mti_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mu ud onan. Kuiyawa Erisabet me agara vesin, sira mu duwam aita gudne. ");
INSERT INTO mti_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jakaraya dam meuma nau gumbe, meoya God namive me pirisi nau meuma aivi. ");
INSERT INTO mti_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pirisi nauwawa gwangwan gumbe, me kae bumpa gumbe wagomiyaya. Meve me Ayapan temporu danave unig aine yoma tayapama okettan oya. ");
INSERT INTO mti_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Me yoma tayapama okeriviwa, iyayapan obiren daieve agoniyag nun veme. ");
INSERT INTO mti_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ayapan aneyaeba me gumbe uwane, sira iyakaisi kem meuma yoma tayapama yutanwa apa yokene. ");
INSERT INTO mti_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Meve Jakaraya me yaunewa, me terag a ane. ");
INSERT INTO mti_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Aneya me gumbe wane, “Jakaraya a den a. Nun geumawa God anone. Ge biyuk Erisabet utugwa ud apan baraugempe. Ge iviwa ug yuwa me Jon. ");
INSERT INTO mti_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Me degadega gumbe gungap, sira iyayapan obiren degadega ape kuiyawa me yaitanwa oya, ");
INSERT INTO mti_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kuiyawa me Ayapan namive kokawa ape. Me wain ge yoi yaigipama upeba den naigimpe. Guwawa Iyakaisiyapama noidauwape inawa danave yaipewa gaibu. ");
INSERT INTO mti_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Me God muma Ayapan gumbe Isuraeru usitainawa obiren sira bog ompe. ");
INSERT INTO mti_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Me Eraija guwawa ge yusiwa meuma gumbe Ayapan namive namu aipe. Me mamawaviwa nonowa tobiroriyape usitainawa gumbo. Me ape anoano topai eme igiyawa nonomagowa tobiroriyape anoano oraiwa igiyawa nonomagowa ape. Meve iyayapan waribiya mumpe Ayapan oya.” ");
INSERT INTO mti_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakaraya aneya gumbe singui wane, “Aninin ne oma ane mame yaug anotna? Ne nembo tayawa ana, sira ne vesin tayawa ane.” ");
INSERT INTO mti_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aneya garawa wane, “Ne Gebrieru. Ne God namive yokeeniwa. God ne baraunegne genan watan oya, sira gae oraiwa mame diruktan oya onedna. ");
INSERT INTO mti_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gare mame ge yawa. Gare ge nogwa iyagita sira oma den ane gae wa. Kuiyawa gae neuma gumbe anotumat den ana. Kumiwa uwapewa gae neuma me natawa pawape. Ivi kum uwapewa oma ane gae wa.” ");
INSERT INTO mti_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Iyayapan Jakaraya oya amareme, mu pipam muteme divi oya temporu danave yobutatae wakene. ");
INSERT INTO mti_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Me dauwanewa, me gae den dirumne. Mu yaug anoya me irawa me uyavi minawa temporu danave yaune. Kuiyawa me guwaguwawa aivi, noiwa iyagit wakene. ");
INSERT INTO mti_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nau meuma kumiwa wadne onananewa me sira taig gwe aine. ");
INSERT INTO mti_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ivi mame me biviwa Erisabet bugane, sira dud nanin gambenit me gwe bod wakene. ");
INSERT INTO mti_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Me wane, “Ayapan mame me nenan ane. Gare me anoiviwa toyau negne, sira me ne ubmam neuma aug aine iyayapan gumbo.” ");
INSERT INTO mti_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Dud naningamben desirom danave, God aneyaeba Gebrieru baraune Nasaret aine. Me gwetoimu Gariri danave. ");
INSERT INTO mti_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Otau me apan iviwa Josep autan oya yapapara aya. Josep me Devid dam meuma yaig onnewa. Otau iviwa me Meri. ");
INSERT INTO mti_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneya menan aig wane, “Gaun neumawa ge gungap. Ge baigan kokavit auwana! Ayapan ge gungap.” ");
INSERT INTO mti_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meri anopipanum kokavit ane. Sira anopipanum ane gaun mame natawa divi. ");
INSERT INTO mti_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Megara aneya me gumbe wane, “Meri, a den a. God baigan meuma ge auwana. ");
INSERT INTO mti_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ge bug a, sira ud apan yaipe. Ge iviwa ug yuwa me Iesu. ");
INSERT INTO mti_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Me iviwa koka ape. Iyayapan wape me Apan Kokawa Painauvitwa Usiwa. Ayapan God me wampe mamawa Devid kin arawa aupe. ");
INSERT INTO mti_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Me Jekob gweyawa yaibobot amarape viripusiwa onan. Kin at meuma onan den di ape.” ");
INSERT INTO mti_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","“Aninin mame ape? Ne apan den yaug anona.” Meri singui wane. ");
INSERT INTO mti_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Aneya garawa wane, “Guwawa Iyakaisiyapama gungap uwape. Apan Kokawa Painauvitwa yusiwa meuma ge um gempe. Meve me yaipewa, iyayapan aib wape, me Apan Iyakaisiyapama, sira me God Usiwa. ");
INSERT INTO mti_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yawa. Ge evegwa Erisabet aita kumive ud autan aivi. Iyayapan waya me agara ane, megara me dud nanin gamben desirom danave bug aivi. ");
INSERT INTO mti_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kuiyawa God gumbe oma den anewa onan.” ");
INSERT INTO mti_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri wane, “Ne Ayapan nauwawa eniwa. Gae geuma anin wanawa me gunap matatpe.” Meve aneya yankweg aine. ");
INSERT INTO mti_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Me kumive Meri tam yoig at kokawa me tui arawa Judia oya tatevit aine. ");
INSERT INTO mti_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Me Jakaraya gweyawa unig aig, me gaun meuma Erisabet wanne. ");
INSERT INTO mti_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Erisabet Meri gaun meuma anonewa, kikiyan inawa danave tupit dodne. Erisabet me demtawa aune Guwawa Iyakaisiyapama gumbe. ");
INSERT INTO mti_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Noiwa kokavit wane, “Vesin yapowo waribiya genne. Ud inawa danave wakenewa me mina waribiyane. ");
INSERT INTO mti_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ayapan neuma inawa gunap uwanewa me oya ne anin waten? ");
INSERT INTO mti_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gaun geuma ne naunanap unignewa, dananap ud degadega gumbe tupit dodne. ");
INSERT INTO mti_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Vesin me anotumat ane dividivi undag Ayapan wanewa me di matatpewa me di waribiyane.” ");
INSERT INTO mti_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Sira Meri wane: “Guwanwa Ayapan waieni, ");
INSERT INTO mti_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Guwanwa me God Waita Abnawa neuma gumbe degadega eni, ");
INSERT INTO mti_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","kuiyawa me ankwatave nau vesinawa ano negne. Gare mame apa utan aipewa, iyayapan undag mu nenan wape waribiya nedne, ");
INSERT INTO mti_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kuiyawa Ayapan yusipama me divi kokavit nenan ane. Me iviwa Iyakaisi. ");
INSERT INTO mti_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Me ano nunanawa iyayapan mu me gumbe aeba emewa gumbo wateteyamivi. Me kum gare aipe viripusiwa onan. ");
INSERT INTO mti_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Me naniwa gumbe yusiwa ane. Me iyayapan mu imuwo apanapan eme igiyawa atatai imne. ");
INSERT INTO mti_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Me amareme igiyawa at muma gumbe bog yantene. Megara me mokona igiyawa me owantene. ");
INSERT INTO mti_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Me iyagon igiyawa dividivi oraiwa utamne. Megara tawara obiren igiyawa kwemne ingui amiya. ");
INSERT INTO mti_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Me ano nunanawa meuma imiwa den atataine, sira me Isuraeru nau igiyawa meuma waita munne. ");
INSERT INTO mti_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nu isimuranaiwa, Ebraam ge me dam meumawa aig onnewa gumbo wanewa mina me ape. Me viripusiwa onan.” ");
INSERT INTO mti_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri dud duwamdesi mina Erisabet gaibu wakene, meve sira taig gwe aine. ");
INSERT INTO mti_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Erisabet ud autan kumiwa uwanewa, me kikiyan apan baraune. ");
INSERT INTO mti_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Me iyayapan meumawa ge owawaviwa mu anoya, Ayapan ano kokavit anowanne, sira me degadega meuma kebaya. ");
INSERT INTO mti_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kum naningamben duwamdesiyawa, mu kikiyan kwapiwa tuitan oya onamiya. Mu ug mamawa iviwa Jakaraya yutan anoya. ");
INSERT INTO mti_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Megara inawa me wane, “Onan, me wape Jon.” ");
INSERT INTO mti_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mu me gumbe waya, “Me apa iyayapan geuma da iviwa Jon onan.” ");
INSERT INTO mti_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mu mamawa guwaguwawa me toewaniya. Mu yaug anotan oya singui waya kikiyan iviwa ug aninin yumon? ");
INSERT INTO mti_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Me yoma pepetu gigirum tetan oya wane mu aug onamiya. “Me iviwa Jon,” me tenewa iyayapan teraya. ");
INSERT INTO mti_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tatevit noiwa watabne, pednawa vedne, sira me amatog gae wag, God wan enagadne. ");
INSERT INTO mti_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iyayapan meuma undag gaibu a aya. At tui arawa Judia apa undag iyayapan dividivi undag mame oya gaiyawa veme. ");
INSERT INTO mti_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyayapan undag mu mame anoyawa me oya anog veme, “Kikiyan mame aigin aninin atan?” Kuiyawa Ayapan naniwa me gumbe. ");
INSERT INTO mti_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Me mamawa Jakaraya me Guwawa Iyakaisiyapama gumbe demtawa aune, sira wane: ");
INSERT INTO mti_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ayapan wan enagasiya. Isuraeru God mumawa. Kuiyawa me uwane, iyayapan meuma waita muntan oya. ");
INSERT INTO mti_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Me waita numa oya nau aivi abnawa Devid gweyawa danave kuiya donawa yudabne yoine. ");
INSERT INTO mti_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Watavit me propeta iyakaisiyapama nouwa gumbo did nunne. Me meib ane. ");
INSERT INTO mti_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Waita me anavi numa gumbo, ge iyayapan topai nuniyawa mu nanuwo gumbo. ");
INSERT INTO mti_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Me mamanaiwa gumbo ano nunne. Sira agi iyakaisiyapama imug teg anone. ");
INSERT INTO mti_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Me gwangwan me mamunwa Ebraam gumbe wanewa imug teg anone. ");
INSERT INTO mti_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Me anavi numa nanuwo gumbo waita numpe. Piyu egave kum numawa undagit nu Ayapan namive danowa esinewa gaibu, oraivitwa gaibu, a gaibu onan nu wakeg Ayapan ankwatave nau ata. ");
INSERT INTO mti_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ge ne utunwa, iyayapan ge gungap wape ge egave painauvitwa propeta. Kuiyawa Ayapan namive namu aga, menan ebuwawa waribiya. ");
INSERT INTO mti_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kukaeba mumawa anog yankwetan gumbe waita mumpe, sira iyayapan meumawa gumbo me anoanowawa mumpe. ");
INSERT INTO mti_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","God numa ano nunivi oraiwa me oya mame ape. Sira ano nunivi gumbe painauvitwa apa kum dauwaiviwa nu gunup uwape. ");
INSERT INTO mti_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Iyayapan mu sisip ge bo gugup danave wakeyawa gumbo eyawa esipe, amunwa yum ebuwawa danave uniktan oya amara numpe.” ");
INSERT INTO mti_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ud me koka ane, sira guwawa danave yusipamit ane. Me at inguiwa arawa danave wakene, meve me Isuraeru igiyawa gumbo taibe ag toewan munne. ");
INSERT INTO mti_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kum me danave Siisa Augustus gaiyawa iyayapan undag dirumne, iyayapan at undag danave agoniyape ivuwa tetan oya. ");
INSERT INTO mti_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Apan kokawa Kirinius at Siriya apa amaraiviwa kumiwa apa, mame me namuiren ivuwa tetan.) ");
INSERT INTO mti_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iyayapan undag at kokawa muma gumbe ivuwa tetan oya amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Meoya Josep mu mina gaibu, at kokawa Nasaret me Gariri danave wakenewa dauwag Devid arawa kokawa Betureem me Judia danave wakenewa dog aine. Kuiyawa me Devid dam meuma desiroma. ");
INSERT INTO mti_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Me Meri gaibu ivuwa tetan oya asime amiya. Meri me gaibu mem atan oya me gumbe yapapara ane, sira me ud autan oya amaraivi. ");
INSERT INTO mti_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mu asime wakeyawa kumive, ud kikiyan yaitanwa kumiwa uwane. ");
INSERT INTO mti_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Me ud apan namu meuma baraune. Me wape gumbe panne sira yoma kabum kwapiyawa me danave baraune. Kuiyawa gwe kokawa iyayapan vinemewa danave mu at onan oya. ");
INSERT INTO mti_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sira at megiyave wayo arawa apa sip amareme igiyawa mu daieve wakeya. Arampuna mu den kubvineme mu sip muma amareme. ");
INSERT INTO mti_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ayapan aneya meumawa mu gumbo uwane. Ayapan eyawa meuma mu gumbo birorot esinewa, mu a aya. ");
INSERT INTO mti_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Megara aneya mu gumbo wane, “Ye den a aya. Ne gae oraiwa aug onedna. Me degadega kokawa iyayapan undag munan. ");
INSERT INTO mti_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gare mame Devid arawa kokawa meuma danave Waita Abnawa me yenan yaine. Me Keriso Ayapan. ");
INSERT INTO mti_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mame me ye irayauyau yeuma. Ye kikiyan yauya. Me wape gumbe paniya yoma kabum kwapiyawa danave barauya vinivi.” ");
INSERT INTO mti_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pungi den wane, kwiminau mut igiyawa abototoi aneya gaibu uwaya, sira God waiya ag waneme. ");
INSERT INTO mti_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Painauvitwa danave eyawa God gumbe. Piyuwau iyayapan mu me meumawa yum gumbo.” ");
INSERT INTO mti_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneya yankwem kwimin danave dog amiyawa, sip amaremewa garawa ano aya, “Betureem anta, sira mame matadnewa yauta, Ayapan me oya wag did nunnewa.” ");
INSERT INTO mti_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Meve mu tatevit amog Meri ge Josep yawamiya. Mu kikiyan me kabum danave viniviwa yauya. ");
INSERT INTO mti_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mu yauyawa, ud mame oya wait dirumiyawa mu gae wateteyamiya. ");
INSERT INTO mti_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyayapan undag mu anoyawa, sip amaremewa wait wayawa oya anog teraya. ");
INSERT INTO mti_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Megara Meri dividivi undag mame nonemagave imug teg anoivi. ");
INSERT INTO mti_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Sip amaremewa God wag degawan sira taig amiya. Kuiyawa dividivi undag mu anog yauyawa me aneya wayawa mina di. ");
INSERT INTO mti_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kum naningamben duwamdesiyawa apa, me kwapiwa tuitan kumiwa uwane. Mu ug Iesu yuya. Iviwa me watavit aneya wannewa, ivi bug ane. ");
INSERT INTO mti_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mu miyot muintan muma kumiwa me Mosisi Gwangwaneba gumbe me onananewa, Josep ge Meri me Ayapan gumbe me wantan oya aug Jerusarem amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ayapan Gwangwaneba danave aib tene, “Ud apan undag me inowa danowa watap namu yaiemewa me Ayapan oya iyakaisi ape.” ");
INSERT INTO mti_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Sira Ayapan gwangwaneba danave aib tene, “Unatun vesin apan duwam, go umuk mataiwa duwam.” Me gumbe mu puyo muma God wantan oya amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kum me apa apan iviwa Simeon at Jerusarem apa wakeivi. Me apan oraiwa sira anotumat abnawa. God me Isuraeru watmemeyam muntan oya amaraivi. Guwawa Iyakaisiyapama Simeon me egave. ");
INSERT INTO mti_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Guwawa Iyakaisiyapama toewanne namu Iesu Keriso yaupeve, me bo ape. ");
INSERT INTO mti_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Guwawa gumbe demtawa aunewa, me temporu arawa danave unigne. Ud oya Gwangwan anoanowawa atan oya inamamawa kikiyan Iesu aug unigiya. ");
INSERT INTO mti_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon ud nanive wan aug God waiyag wane: ");
INSERT INTO mti_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ayapan. Ge gae geuma meib. Gare mame yum gumbe nau abnawa geuma yankweg aipe. ");
INSERT INTO mti_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kuiyawa ne yanganap waita geuma yauna. ");
INSERT INTO mti_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Waita me iyayapan undag namuwo tamibarip anawa. ");
INSERT INTO mti_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sira waita me dun. Me Ju onan igiyawa gumbo toyau mumpe. Sira me eyawa iyayapan geuma Isuraeru gumbo.” ");
INSERT INTO mti_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ud mamawa ge inawa me wanewa mu anog teraya. ");
INSERT INTO mti_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon waribiya munka inawa Meri dine, “Yawa. Ud mame watgomiyane. Me gumbe Isuraeru danave iyayapan obiren aigimpe sira yoigimpe. Sira me irayauyau ape me iyayapan dig watkukampewa. ");
INSERT INTO mti_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Deba gumbe guwagwa yupe. Me anoano obiren mu nonemagowo wakeyawa matai taibe atan oya.” ");
INSERT INTO mti_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Me mina vesin propeta Anna wakene. Me dam Aseru, apan Panueru gwaitawa. Me vesin tayawa. Namu memgebip aya, ivi memawa gaibu bairawan 7 wakeya. ");
INSERT INTO mti_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Meve kwapura ane, me gumbe wakene bairawan meuma 84 aune. Vesin me temporu arawa danave wakeivi yan den kweivi. Kum aram kwit aivi nun waivi God waiyaivi. ");
INSERT INTO mti_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kum koni me apa di, me munan dog onne. Vesin me God gaun wanne. Iyayapan mu Jerusarem gumbe God waita wantan oya amaremewa wakeya. Vesin mu undag gumbo ud oya wane. ");
INSERT INTO mti_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josep ge Meri dividivi undag mu Ayapan Gwangwaneba wanewa ayawa, mu at Gariri, gwetoimu muma Nasaret sira taig amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ud usiwa koka ane. Yusipam ane. Me anoano meuma oraiwa gumbe noidauwane. God baigan meuma me egave wakene. ");
INSERT INTO mti_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Bairawan evedni, mamawa inawa Uwag Gaveya Buyunaeba oya Jerusarem amome. ");
INSERT INTO mti_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Iesu bairawan meuma 12 aunewa, mu gwe anoanowawa gumbe buyunai oya dog amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Buyunai onananewa, meve me mamawa inawa gwe amome. Ud wabuwabu Iesu Jerusarem danave wakene, megara mu den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mu anoya Iesu iyayapan gaibu wakene, meoya mu kum desirom mina amiya. Meve mu amatog menan diuya mu iyayapan muma ge owawa gumbo. ");
INSERT INTO mti_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mu me den yauyawa, me oya didimama ag Jerusarem taig amiya. ");
INSERT INTO mti_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kum duwamdesiyawa, mu temporu arawa danave me yauya. Me Gwangwan toewanewan igiyawa yapowo wakeg ano mumivi sira singui mumivi. ");
INSERT INTO mti_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyayapan undag mu me wane anoya a aya, me anoiviwa ge gara waiviwa gumbe. ");
INSERT INTO mti_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mamawa inawa me yauyawa, a kokavit aya. Me inawa me gumbe wane, “Ud neuma, diwan ge mameib nu gunup ana? Ge mamag ge ne anogugut anog ag genan diuete.” ");
INSERT INTO mti_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Divi oya ye nenan diuene?” me singui wane. “Ye den anoyana ne Mamanwa gweyawa danave waketanit di?” ");
INSERT INTO mti_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Megara mu den yaug anoya Iesu gaiyawa natawa dimbae waivi. ");
INSERT INTO mti_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Meve Iesu mu gaibu Nasaret aig amiya, sira mu nouwa aune. Megara dividivi undag mame inawa noneve teg anoivi. ");
INSERT INTO mti_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Meve Iesu anoano oraiwa gaibu koka ane, sira yaig dorivi. God ge iyayapan baigan muma me gumbe wakene. ");
INSERT INTO mti_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Siisa Tiberius amaraivi kumiwa gumbe bairawan 15 danave, Pontio Pairat me Judia apa kokawa at amarag wakene. Erod me at Gariri ayapaneba, sira Erod gwaneba Pirip me at Ituriya ge at Terakonitis ayapaneba, sira Rusania me at Abirini ayapaneba. ");
INSERT INTO mti_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas ge Kayapas mu pirisi painauvitwa wakeyawa kumiwa apa, at inguiwa arawa apa God gaiyawa Jakaraya usiwa Jon gumbe uwane. ");
INSERT INTO mti_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon me yoi Jodan birorot visigambenwa undag aig, opata me nonemagowa biroriyag babataito atan oya, wag dirumivi. ");
INSERT INTO mti_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Propeta Aisaya gae meuma bukaeba danave aib tene: “At inguiwa arawa danave apan da noiwa auwaivi, ‘Ayapan oya ebu waribiya, ebu siwavit menan waribiya. ");
INSERT INTO mti_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","At togewa undag umpe, tui ge oiewa baraupe pawawa ape. Ebu gegerainewa wasiwampe siwavit ape, sira ebu aig ge dauwanewa moiyuppe. ");
INSERT INTO mti_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iyayapan undag mu God waita meuma yaupe.’” ");
INSERT INTO mti_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iyayapan mu Jon gumbe babataito atan oya uwag agoniyaya. Jon wag dirumne, “Ye mokare kukaeba usitainawa! Bira wat diruine ye oma ane God danapiri meuma oniviwa me aninin gaveamon? ");
INSERT INTO mti_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nonemagewa biroriyag natawa oraivit inamigimiya. Ye den amatog yenan waya. ‘Nu mamunwa me Ebraam.’ Kuiyawa ne ye diruitna, God oma ane an mame tobiyape Ebraam usitainaven ape. ");
INSERT INTO mti_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Gwit yoma taiwa apa wait baraune wakene, sira yoma desirom desirom me natawa oraivit den impewa me kwatpe aikpe, me iyam danave aorepe.” ");
INSERT INTO mti_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iyayapan agoniyayawa singui waya, “Nu aninin aton?” ");
INSERT INTO mti_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Me garawa wane, “Apan wape duwam gaibuwa me wape onanwa gumbe keb ag mumpe. Nakwai mina meib ape.” ");
INSERT INTO mti_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takesi tameme igiyawa mu mina babataito atan uwaya. Mu singui waya, “Toewanewan, nu aninin aton?” ");
INSERT INTO mti_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Me dirumne, “Sira tamtan diruyeniyawa mekut tamiya, da den tamiya.” ");
INSERT INTO mti_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Meve mut igiyawa me gumbe singui waya, “Nu anin aton?” Me gara wane, “Den ayamun anmaga tamiya, sira den ugaimun ibnawa muniya. Garawa yeuma gumbe degadega aya.” ");
INSERT INTO mti_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Iyayapan Keriso oya anog amareme, meoya nonowa danave anopipanum eme anten Jon me Keriso go. ");
INSERT INTO mti_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jon gara gumbo wane, “Ne yoi gumbe babataito ayemeni. Megara apan da yusiwa kokavitwa me matai uwape. Ne oma den ane me sandoro murapeba vetna. Me Guwawa Iyakaisiyapama ge iyam gumbe babataito aiyempe. ");
INSERT INTO mti_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Me ereri kokawa meuma me nanive, sira me natawa ge kwapiwa kepteivi arawa yug waribiyape. Nakwai wiit agoniyag buim meuma danave tepe, meve nakwai wiit kwapiwa iyam yaibobot danave aorepe itpe onanape.” ");
INSERT INTO mti_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Gae gina ubeubewa gumbe Jon iyayapan toyau munne, sira gae oraiwa opata mu gumbo wane. ");
INSERT INTO mti_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Megara Gariri Ayapaneba Erod me Erodias me tatawa biviwa oya ge dividivi undag kukaeba meuma anewa oya, Jon me Erod diengudne. ");
INSERT INTO mti_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Meoya me Jon nog danave baraune. Kukaeba meuma undag gumbo kukaeba da desirom me gaibu agoniyane. ");
INSERT INTO mti_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Meve iyayapan undag babataito ayawa, Iesu gaibu babataito ane. Me nun waiviwa, kwimin watabne. ");
INSERT INTO mti_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Guwawa Iyakaisiyapama me umuk mina aig on egave wakene. Noiwa kwimin apa uwane: “Ge ne utunwa nonenmagawa gungap aviviwa. Ne gungap degadega eni.” ");
INSERT INTO mti_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sira Iesu nau meuma amatonewa, bairawaneba me 30 mina. Iyayapan anoyawa me Josep usiwa, me Eri usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat usiwa, Rivai usiwa, Meruki usiwa, Jannai usiwa, Josep usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias usiwa, Emos usiwa, Naum usiwa, Esuri usiwa, Nangai usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mat usiwa, Matias usiwa, Semein usiwa, Josek usiwa, Joda usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanan usiwa, Resa usiwa, Jerubaberu usiwa, Searutieru usiwa, Neri usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Meruki usiwa, Adi usiwa, Kosam usiwa, Erumadam usiwa, Eru usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josiya usiwa, Erieseru usiwa, Jorim usiwa, Matat usiwa, Rivai usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeon usiwa, Juda usiwa, Josep usiwa, Jonam usiwa, Eriakim usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Merea usiwa, Menna usiwa, Matasa usiwa, Neitan usiwa, Devid usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesi usiwa, Obed usiwa, Boas usiwa, Sarumon usiwa, Nausion usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab usiwa, Admin usiwa, Aruni usiwa, Esuron usiwa, Peret usiwa, Juda usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jekob usiwa, Aisak usiwa, Ebraam usiwa, Tera usiwa, Naoru usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug usiwa, Reu usiwa, Pereg usiwa, Eber usiwa, Seira usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Keinan usiwa, Arupakad usiwa, Sem usiwa, Noa usiwa, Remek usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Metusera usiwa, Enok usiwa, Jered usiwa, Maarareru usiwa, Keinan usiwa, ");
INSERT INTO mti_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enosu usiwa, Setu usiwa, Adam usiwa, God usiwa. ");
INSERT INTO mti_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesu Guwawa Iyakaisiyapama gumbe noidauwanewa, yoi Jodan apa sira taig onne. Guwawa Iyakaisiyapama me aug aine at inguiwa arawa danave wakene. ");
INSERT INTO mti_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Asimeve oiyat 40 danave, Seitan Iesu ayag yaune. Me kumiwa nakwai den nane, sira kum oieba me iyagon. ");
INSERT INTO mti_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seitan me dig wane, “Ge God Usiwa ipewa, an mame diya tobiyape bredi ape.” ");
INSERT INTO mti_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iesu gara wane, “Me tene: ‘Iyayapan bredi mekut gumbe den vinigimpe.’” ");
INSERT INTO mti_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seitan me Iesu aug at opampawa dog aine. Tatevit toimu koka undag piyu mame danavewa toewanne. ");
INSERT INTO mti_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Meve gumbe wane, “At undag yusipama ge eyawa meuma undag gentna. Kuiyawa mu negnewa, ne bira da anotnawa oma ane wantna. ");
INSERT INTO mti_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Meoya ge ne waiya negawa, undag mame me geumawa ape.” ");
INSERT INTO mti_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iesu gara wane, “Me aib tene: ‘Ayapan God geuma waiya, sira me mekut nau meuma a.’” ");
INSERT INTO mti_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Seitan me Iesu aug Jerusarem aine, sira ane temporu dewam opampa anewa egave yoine. Me wane, “Ge God Usiwa ipewa, mame apa gembovit pisiag aiga. ");
INSERT INTO mti_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kuiyawa me tene: ‘Me genan anog ge yaimoyai amaragemtan oya aneya meuma dirumpe. ");
INSERT INTO mti_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Amagwa an den tope, mu nanuwo wan augempe.’” ");
INSERT INTO mti_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iesu gara wane, “Me wane, ‘Ayapan God geuma den ayag yauya.’” ");
INSERT INTO mti_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Seitan ayaiviwa undag mame onananewa, me gumbe kum kusida Iesu yankweg aine. ");
INSERT INTO mti_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Guwawa yusiwa gumbe Iesu Gariri taig onne. Gae meuma birorot aine at visi donawa undag. ");
INSERT INTO mti_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Iesu sinagogu muma danave toyau munne, sira iyayapan undag waiya waniya. ");
INSERT INTO mti_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Meve me at Nasaret koka anewa arawa aine. Sabat Kumiwa apa evedni meib aiviwa mina me sinagogu danave unigne. Meve basiatan oya wan yoine. ");
INSERT INTO mti_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Propeta Aisaya gigirum tenewa paniyawa me wanne. Watabnewa meib tenewa yaune. ");
INSERT INTO mti_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ayapan Guwawa meuma gunap wakene. Kuiyawa me oira gumbe waribiya nedne, gae oraiwa dividivi onan igiyawa gumbo opata watan oya. Me baraunedne onedna. Ne anekna nog igiyawa gumbo anog yankwetan oya watna. Yanga boredmusiawa igiyawa gumbo yangut oraimina atan oya watna. Sira nau ibnawa auemewa waita mumpe ingui amtan oya watna. ");
INSERT INTO mti_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ayapan anoiviwa oraiwa bairawan meuma oya opata wag dirumtan oya onedna.” ");
INSERT INTO mti_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Meve me gigirum tenewa paniyawa panne, sira nau aiviwa me wan yanwakene. Sinagogu danave iyayapan yangowo me temtem yaveme. ");
INSERT INTO mti_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Iesu amatog mu dirumivi, “Gare mame gae Baiboru mame danave anoenewa natawa uwane.” ");
INSERT INTO mti_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyayapan undag me gumbe dega aya, sira gae demtawa me noive uwanewa gumbe teraya. “Mame me Josep usiwa go,” mu waya. ");
INSERT INTO mti_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Iesu mu dirumne, “Ne anoeni, ye yaug auya gae mame: ‘Doketa, gembo warinama!’ Sira ye didnegiya, ‘Nu anotu ge Kapenaum danave anawa, mapa at geumawa apa Sira a.’” ");
INSERT INTO mti_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Me wane, “Ne gae natawa veni. Iyayapan propeta me gumbe at meumawa apa bainda den waya. ");
INSERT INTO mti_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ne watnawa me natawa. Eraija kumiwa danave, kwimin bairawan duwamdesi ge dud 6 danave tobodne. At undag danave kait kokawa ane. Kwapura obiren Isuraeru danave wakeya, ");
INSERT INTO mti_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","megara God Eraija den baraune munan aine. Kwapura me Sarepat at Saidon danave apa wakenewa me mekut gumbe aine. ");
INSERT INTO mti_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Propeta Eraija me kumive Isuraeru apa yuwat warumamne iviwa reprosi obiren wakeya, megara bira da den warinamunne. Siria apan Naaman me mekut warinamne.” ");
INSERT INTO mti_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iyayapan undag sinagogu danave mame anoyawa, mu danopiriwaya. ");
INSERT INTO mti_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mu wan yoiyeg Iesu atatai iya gwetoimu kokawa yankweg dauwag aine. Sira tui kusi mu gwetoimu muma siya donave aug aine, me aorepe uyug aitan oya. ");
INSERT INTO mti_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Megara Iesu iyayapan danowo unig troag gamben dauwag aine. ");
INSERT INTO mti_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Meve Iesu Gariri danave Kapenaum me gwetoimu kokawa aig aine. Sabat Kumiwa apa me amatog toyau munivi. ");
INSERT INTO mti_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mu toyau munnewa anog teraya. Kuiyawa gae meuma yusipamit. ");
INSERT INTO mti_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sinagogu danave apan da wakene. Me airapu kukaeba miyotapama gumbe wakene. Me noiwa kwaruwane. ");
INSERT INTO mti_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Akai! Nasaret apan Iesu, ge nu gunup divi amon? Ge nu wakukam nuntan onagana? Ne anona ge bira, ge God Apan Iyakaisiyapama!” ");
INSERT INTO mti_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iesu yusipamit wane, “Gae yankweya! Me gumbe yankweg dauwaya!” Meve airapu apan me namuwo aorene, yankweg dauwag amiya. Megara me den wakukamne. ");
INSERT INTO mti_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyayapan undag teraya sira garawano waya, “Toyau toyau mame divi? Me yusipamit airapu kukaeba dirumnewa, mu dauwaya!” ");
INSERT INTO mti_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sira umum meuma at megiyave undag wateteyamne. ");
INSERT INTO mti_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iesu sinagogu yankweg Saimon gweyawa aine. Me kumive Saimon nimnagawa vesinwa yuwat amipam aug diravivi. Mu Iesu waita wantan oya waya. ");
INSERT INTO mti_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Meve me yuwat amipam egave kwanasig dig wane, sira yuwat amipam me yankwene. Me tatevit owan yoig amatog waita wanne. ");
INSERT INTO mti_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kum aigiviwa, iyayapan yuwat gina ubeube tamiya igiyawa boeg me gumbe onamiya. Meve me naniwa desirom desirom egowo tene, sira inaimusia. ");
INSERT INTO mti_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Airapu kukaeba iyayapan obiren yankweg dauwag kwaruwaya, “Ge God Usiwa!” Megara Iesu mu dirum bainda den wane mu wape. Kuiyawa mu anoya me Keriso. ");
INSERT INTO mti_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wantenewa me pomtone arawa dauwag aine. Iyayapan Iesu oya didimama eme, sira mu amog me wakenewa gumbe uwaya. Me gaibu waketan oya mu ageyau aya. ");
INSERT INTO mti_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Megara me wane, “Ne God toimuwawa gae oraiwa meuma opata di watna gwetoimu da danave gaibu. Kuiyawa me oya ne baraunegne onedna.” ");
INSERT INTO mti_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Me sinagogu Judia danave opata yunadwaivi. ");
INSERT INTO mti_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kum da Iesu me Poeman Genesaret visive yokene, iyayapan me birorot empanig God gaiyawa anoeme, ");
INSERT INTO mti_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","me awau ginave wa duwam yawamne. Gwambui botag igiyawa dauwag amiya sira uwariri muma muineme. ");
INSERT INTO mti_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Me wa da danave dauwane. Me Saimon meumawa. Sira me dine visiwa gumbe kusi atan barauwa aipe. Meve me yanwakeg wa gumbe iyayapan toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Me gae waiviwa yankwenewa, Saimon gumbe wane, “Poeman dana bagive dauwape, uwariri teya aikpe gwambui tamtan oya.” ");
INSERT INTO mti_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon gara wane, “Kokawa, nu aram nau kokavit atu, megara natawa da den autu. Megara ge vege oya uwariri tetna aikpe.” ");
INSERT INTO mti_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Mu me ayawa, mu gwambui obiren tamiya. Mu uwariri mumawa koni vitan ane. ");
INSERT INTO mti_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Meoya mu owawa wa da gumbe onam waita muntan oya munan nanigapoe aya. Mu omeg wa duwam eniya noidauwane, sira mu amatog koni uniktan aya. ");
INSERT INTO mti_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pita mame yaunewa, me Iesu konive aig wane. “Ayapan, yankweneg aga, ne kukaeba abnawa!” ");
INSERT INTO mti_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kuiyawa me ge owawa undag teraya gwambui obiren tamiya oya. ");
INSERT INTO mti_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jebedi usitainawa, Jemus ge Jon, mu Saimon owawa. Mu gaibu teraya. Meve Iesu Saimon gumbe wane, “Ge den tera. Gare mame apa utan aipewa ge iyayapan upigima.” ");
INSERT INTO mti_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Meve wa muma ororiya painau visive baraueg dividivi undag yankweg me amave amiya. ");
INSERT INTO mti_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Iesu gwetoimu koka da danave wakene. Me kumiwa apan me yuwat warumne iviwa reprosi aunewa uwane. Me Iesu yaunewa, namive aig nun wane, “Ayapan, ge imugap apewa, ne warinam nega.” ");
INSERT INTO mti_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iesu naniwa iberiyag apan yumne, sira wane, “Ne imunap, oraimina a!” Sira tatevit yuwat warumne iviwa reprosi yankwene aine. ");
INSERT INTO mti_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Meve me dig wane, “Iyayapan da den diruma. Megara gembovit ag pirisi gumbe toyauwana. Sira Mosisi wanewa mina gembo muintan oya puyo barauwa wana, me gumbe iyayapan yaug anope ge oraimina ana.” ");
INSERT INTO mti_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Megara Iesu gae meuma kokavit wateteyamne undag anoya. Meoya iyayapan abototoi me gumbe gae anotan ge yuwat muma warinamuntan uwaya. ");
INSERT INTO mti_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Megara me kum evedni pomtone arawa apa aig nun waivi. ");
INSERT INTO mti_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iesu kum da mu toyau munivi, meve Parisi igiyawa ge Gwangwan toewanewan igiyawa asime wakeya. Mu gwetoimu Gariri, Judia ge Jerusarem danave wakeyawa undag uwaya. Sira me Ayapan yusiwa gumbe yuwat warinamunne. ");
INSERT INTO mti_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Apan upeba apan amananiwa buburuimusiawa goma egave baraug aug uwaya. Sira gwe danave barautan oya ageyau ag me namive barautan oya didimama aya. ");
INSERT INTO mti_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Meve mame atan oya ebu diuya onan, kuiyawa iyayapan noidauwane. Meoya gwe egave dauwag, nog waremieg, nog gumbe gomaepam barauya iyayapan yapowo Iesu namive aigne. ");
INSERT INTO mti_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Me anotumat muma yaunewa, me wane, “Enda, kukaeba geuma anog yankwene.” ");
INSERT INTO mti_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Parisi igiyawa ge Gwangwan toewanewan igiyawa mukut amatog anoeme, “Apan mame bira? Me God gumbe gae kukaeba waivi. Bira oma ane kukaeba anog yankwepe, me God mekuriren oma ane?” ");
INSERT INTO mti_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu yaug anone mu divi danowo anoemewa, sira singui wane, “Divi oya ye dividivi mame nonemageyap anoene? ");
INSERT INTO mti_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ambuwa me taibe, ‘Kukaeba geuma anog yankwene,’ watna, go ‘Wan yoig aga,’ watna go? ");
INSERT INTO mti_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Megara, ne imunap ye yaug anoya. Apan Usiwa me piyu egave yusiwa gaibu, me oma ane kukaeba anog yankwepe.” Meve me amananiwa wabuburumnewa abnawa dig wane, “Ne ge dirukna, wan yoiya, goma geuma aug gwe aga.” ");
INSERT INTO mti_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tatevit me mu namuwo wan yoig goma egave viniviwa aug God wag dega gumbe gwe meuma aine. ");
INSERT INTO mti_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyayapan undag teraya sira God waragasiya. Mu danowo a noidauwane, sira waya, “Nu gare inaiinai gina ube da yautu.” ");
INSERT INTO mti_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mame ivi, Iesu uwag aig takesi tamivi abnawa yaune. Iviwa Rivai, takesi tamivi abnawa gwe kusi danave wakene. Me dig wane, “Amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sira me wan yoig dividivi undag yankweg amave aine. ");
INSERT INTO mti_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Meve Rivai Iesu oya nakwaeba koka gweyave ane. Takesi tamemewa obiren ge iyayapan da obiren mu gaibu neme. ");
INSERT INTO mti_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Megara Parisi igiyawa ge Gwangwan toewanewan igiyawa mu dam desiroma mu Iesu aigowawa gumbo kwavimun waya, “Ye divi oya nakwai ge yoi takesi tamemewa ge iyayapan kukaeba gaibu nene?” ");
INSERT INTO mti_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iesu mu gumbo gara wane, “Iyayapan mu doketa oya anoemewa mu ui kwapuwa oraimumuwa igiyawa onan, mu yuwat igiyawa. ");
INSERT INTO mti_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne iyayapan oraimumuwa munan auwatan oya den uwana, kukaeba igiyawa nonemagowa biroriyatan oya uwana.” ");
INSERT INTO mti_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Mu me gumbe waya, “Jon aigowawa kum evedni nakwai kwit eme sira nun veme, sira Parisi igiyawa aigowawa mu meib eme. Megara aigowagwa nakwai ge yoi neme.” ");
INSERT INTO mti_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iesu mu gumbo gara wane, “Memgebip abnawa me amdau igiyawa meuma gaibu wakene. Me apa ye oma ane amdau igiyawa nakwai muma kwit ape? ");
INSERT INTO mti_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Megara me kumiwa uwape. Memgebip abnawa mu gumbo aug aipe. Kum me danave mu nakwai kwit ape.” ");
INSERT INTO mti_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Me maibe mame dirumne: “Bira da den ape wape mataiwa musiwa da aug namuwa gumbe baraug agempe. Me meib apewa, me wape mataiwa viyotpe, sira musiwa mataiwa gumbewa me namuwa gumbe mina den ape. ");
INSERT INTO mti_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Bira da den ape wain mataiwa kwapiwa irutawa namuwa danave wain egampe. Meib ape ipewa wain mataiwa kwapiwa irutawa dumetpe wain egampe. ");
INSERT INTO mti_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Meoya wain mataiwa me kwapiwa irutawa mataiwa danave egampe. ");
INSERT INTO mti_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Sira bira da den ape wain namuwa nakape ivi mataiwa oya anope. Kuiyawa me wane, ‘Namuwa me oraiwa.’” ");
INSERT INTO mti_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat Kumiwa apa, Iesu nau danave aiviwa, aigowawa amatog nakwai wiit tam nanuwo diraudirau ag nag amome. ");
INSERT INTO mti_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Parisi igiyawa upeba singui waya, “Gare Sabat Kumiwa. Divi oya ye Sabat Kumiwa apa Gwangwan togomene?” ");
INSERT INTO mti_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iesu gara dirumne, “Devid ge owawa iyagon wakeyawa kumiwa me aninin ane? Ye basiyayana go onan? ");
INSERT INTO mti_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Me God gweyawa unig aine, sira bredi waribiyanewa me gwangwan gumbe pirisi mekut naiviwa, aug nane sira upeba gaibu wakeyawa munne.” ");
INSERT INTO mti_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Meve Iesu dirumne, “Apan Usiwa me Sabat Kumiwa Ayapaneba.” ");
INSERT INTO mti_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat Kumiwa da, Iesu sinagogu danave unig toyau munivi. Asimeve apan me naniyutanwa gegerainewa wakene. ");
INSERT INTO mti_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Parisi igiyawa ge Gwangwan toewanewan igiyawa Iesu pui yutan oya natawa didimama eme, Sabat Kumiwa me warinampe go onan? Me yautan oya mu yangowa me gumbe wakene. ");
INSERT INTO mti_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Megara Iesu yaug anone mu divi anoeme. Me apan naniwa gegerainewa gumbe wane, “Iyayapan namuwo wan yoiya.” Sira me wan yoig asimeve yokene. ");
INSERT INTO mti_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Meve Iesu mu gumbo wane, “Ne singui diruitna. Gwangwan gumbe me ambuwa oraiwa, Sabat Kumiwa me oraiwa atan go kukaeba atan, inaiinai waita wantan go wakukamtan?” ");
INSERT INTO mti_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Me gumbo yangut undag birorot yangut yawamne, meve apan dig wane, “Nanigwa atan dima.” Me meib ane, sira naniwa oraimina di ane. ");
INSERT INTO mti_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mu danopiripam, amatog garawano aya aninin Iesu gumbe atan oya. ");
INSERT INTO mti_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Me kumive, Iesu nun oya tui dog aine, sira aram desirom God gumbe nun waivi. ");
INSERT INTO mti_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wantene mumbevit, aigowawa munan auwane, sira aigowawa 12 gomiyane mu ivuwa apasoro ug yuwamne. ");
INSERT INTO mti_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon me Iesu ug yune iviwa Pita, me gwaneba Andru, Jemus, Jon, Pirip, Batoromiu, ");
INSERT INTO mti_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Arupies usiwa Jemus, Jerot vemewa Saimon, ");
INSERT INTO mti_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jemus usiwa Judas, Judas Isukariot me Iesu gumbe anavi ag omin baraunewa. ");
INSERT INTO mti_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Me mu gaibu tui gumbe aig amog at pawawa apa yokeya. Asimeve aigowawa obiren wakeya. Sira iyayapan obiren mu Judia apa, Jerusarem apa, poeman visiwa apa, sira Taiya ge Saidon apa onamiyawa mu undag agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mu me gumbe anotan onamiya, sira yuwat warina muntan oya onamiya. Iyayapan mu airapu kukaeba gumbowa warinamunne, ");
INSERT INTO mti_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","sira iyayapan undag Iesu yumtan oya ageyau aya, kuiyawa yusiwa me gumbe uwag on iyayapan undag warinamunivi. ");
INSERT INTO mti_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Me yangawa enagat aigowawa yawam wane. “Pukpuk wagawag igiyawa ye guniyap waribiya wakeigimpe, kuiyawa God toimuwawa me yeumawa. ");
INSERT INTO mti_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Gare iyagon igiyawa, ye guniyap waribiya wakeigimpe, kuiyawa ivi ye oma ape. Gare iruveme igiyawa, ye guniyap waribiya wakeigimpe, kuiyawa ivi ye towaya. ");
INSERT INTO mti_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Iyayapan ye Apan Usiwa iviwa oya topai yeneme sira atatai yeneme ubmam yeneme ye ivuiwa airapu mina watkukam yenemewa, ye guniyap waribiya wakeigimpe! ");
INSERT INTO mti_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Me kumive degadega aya, sira degadega ag tare wariya. Kuiyawa kwimin danave garawa yeuma me kokavit. Mu mamoaiwa God propeta gumbo meib aya. ");
INSERT INTO mti_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Megara ye tawara igiyawa, ye ano kukaeba guniyap! Kuiyawa ye wait watmemeyemne. ");
INSERT INTO mti_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gare ye nakwai kokavit nene igiyawa, ye ano kukaeba guniyap! Kuiyawa ye matai iyagon aisiya. Gare ye tovene igiyawa, ye ano kukaeba guniyap! Kuiyawa ivi ye danadawai aug iruwaya. ");
INSERT INTO mti_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Iyayapan undag yenan gae bainda wayawa, ye ano kukaeba guniyap! Kuiyawa mu mamoaiwa ugauga propetaeba gumbo meib aya. ");
INSERT INTO mti_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Megara bira da nenan anopewa ne diruitna. Anavi yeuma gumbo baigan aigimiya. Bira da ye topai yempewa gumbo oraiwa aya, ");
INSERT INTO mti_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","bira da ye guniyap anokukam aigimpewa waribiya muniya, bira da ye guniyap gwambe aigimpewa mu munan nun waya. ");
INSERT INTO mti_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bira da ge kwauyegwa topewa, me kwauyegwa gambenwa gaibu menan tobiya. Bira da wape geuma egavewa aupewa, yankweya wape geuma ankwatavewa me gaibu aupe. ");
INSERT INTO mti_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bira da nun guniyap wapewa muniya. Bira da divi geumawa aupewa, sira tobiyag autan oya den wa. ");
INSERT INTO mti_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ye imuyap iyayapan ye guniyap anopewa meib ye mu gumbo aya. ");
INSERT INTO mti_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bira da ye baigan yeniviwa ye baigan niyayawa, garawa divi aumon? Oraiwa guniyap da divi? Kukaeba igiyawa gaibu imuwo aupewa, mu imuwo amumpe. ");
INSERT INTO mti_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bira da oraiwa aiyenemewa, ye mu gumbo oraiwa aya. Oraiwa ye guniyap me divi? Kukaeba igiyawa gaibu meib di eme. ");
INSERT INTO mti_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ye iyayapan gumbo dividivi yeumawa wanampa sira tobiyag yentan oya muniyanawa, oraiwa ye guniyap me divi? Kukaeba igiyawa gaibu wanampa sira undag tobiyag autan oya mumpe. ");
INSERT INTO mti_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Megara anavi yeuma baigan muniya. Oraiwa mu gumbo aya, sira muniya. Mu muniyawa divi da man autan owanowan den aya. Meve garawa yeuma kokavit. Sira ye Painauvit Abnawa usitainaven aya. Kuiyawa gaun den veme ge kukaeba eme igiyawa gumbo Painauvit Abnawa baigan meuma kokavit amunivi. ");
INSERT INTO mti_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ye Mamewa ano yemivi, me mina ye gaibu ano munigimiya. ");
INSERT INTO mti_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Pui den yuwamiya, ye pui den yuepe. Den dirumiya, ye gara den diruipe. Kukaeba muma anog yankweya, kukaeba yeuma anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Muniya, mu ye yempe. Iyayapan om oraivit ape, ibnawa aikpe, ipuniyape, noidauwape, togegap egampe. Kuiyawa ye om yuyawa, ebu desirom mina me matai om yuepe.” ");
INSERT INTO mti_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sira me gae maibe mame dirum wane, “Apan yanga borednewa oma ane apan da yanga borednewa amarape? Mu duwam dukup danave den aikpe? ");
INSERT INTO mti_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gigirum usiwa me toewanewan abnawa meuma gumbe egave onan. Megara ud mu gigirumawa oma anewa meve toewanewan meuma mina ape. ");
INSERT INTO mti_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ge yangut tatag yangawa danave atapupu wakeya yawa. Megara divi oya den yaug anoa yoma yare yangag danave wakene? ");
INSERT INTO mti_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ge aninin tatag dig wamon, ‘Tatan, ge yangagwa gumbe atapupu atan autna?’ Yawa, yangagwa danave yoma yare wakene. Ye ugauga igiyawa. Namu gembo yangagwa yoma yare atan aukape, sira meve ge yaiyai yaukape atapupu tatag yangave atan auwa. ");
INSERT INTO mti_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yoma oraiwa natawa kukaeba den impe, meib yoma kukaeba natawa oraiwa den impe. ");
INSERT INTO mti_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yoma desirom desirom me ingan natawa gumbe yaug anone. Iyayapan yoma ganapama gumbe inaru den tampe, sira ipuni gumbe greip den tampe. ");
INSERT INTO mti_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Apan oraiwa dividivi oraiwa nonewa danave wakenewa oraiwa aug ompe, sira apan kukaeba dividivi kukaeba nonewa danave wakenewa kukaeba aug ompe. Kuiyawa apan dividivi me nonewa noidauwag egamnewa wape. ");
INSERT INTO mti_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ye diwan ne gunap ‘Ayapan, Ayapan’ venan, megara ne veniwa den enan? ");
INSERT INTO mti_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Bira da nenan uwag gae neuma anope sira mu ageyau gumbe baraupewa, apan me divi mina ne ye toyau yentna. ");
INSERT INTO mti_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Apan me dukup kokavit wad kuiyawa an bon egave gwe siviwa mina. Nin uwanewa, yoi nin yusiwa uwag gwe manne. Megara gwe den ipun ane, kuiyawa yaimoyai sine. ");
INSERT INTO mti_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Apan me gae neuma anope sira den ageyau gumbe baraupewa, apan me gwe nium onan piyu egave gwe siviwa mina. Yoi nin yusiwa uwag gwe mannewa, me tatevit biyau aigne, undag watkukamne.” ");
INSERT INTO mti_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iesu gae mame undag wa bodne iyayapan mu naunowa taig anoeme, meve aig Kapenaum unig aine. ");
INSERT INTO mti_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Senturion nau meuma aiviwa abnawa wakene, me kokawa imiwa aunewa, yuwarane koni boatan aivi. ");
INSERT INTO mti_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Senturion Iesu gaiyawa anone. Me Ju igiyawa koukawa upeba tene menan amiya. Meve Iesu gumbe onamiyawa nau meuma aivi abnawa warinamtan oya nun wane. ");
INSERT INTO mti_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mu onam Iesu gumbe uwag me gumbe yai dieg amiya, “Apan mame oraiwa, meoya ge garawapa mame a. ");
INSERT INTO mti_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Kuiyawa me iyayapan numa nonowa avivi, sira sinagogu numa sine.” ");
INSERT INTO mti_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Meve Iesu mu gaibu amiya. Me gwe meuma megiyave uwanewa, senturion me owawa tene Iesu oya amog waya, “Ayapan, gembo danadawai den auwa, kuiyawa ne oraiwa onan, ne kukaeba, ne gwanob neuma ankwatave den onaga. ");
INSERT INTO mti_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne anoeni ne oraimina onan, meoya gungap den onekna. Gae geuma me di wa, me gumbe nau neuma aivi abnawa me inaipe. ");
INSERT INTO mti_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kuiyawa ne yusiwa upeba ankwatave wakena, ne gaibu mut igiyawa ne ankwatanap. Ne apan da ditna, ‘Aga,’ me aipe, sira da ditna, ‘Onaga,’ me ompe. Ne nau neuma aivi abnawa ditna, ‘Mame a,’ me ape.” ");
INSERT INTO mti_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iesu mame me anonewa, me gumbe terane. Me tobiyag iyayapan me gaibu onamiyawa dirum wane, “Ne ye diruitna. Ne at Isuraeru apa mame mina anotumat kokavit den yauna.” ");
INSERT INTO mti_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Meve me tene amiya igiyawa gwe taig onam yauyawa, nau meuma abnawa inaig wakene. ");
INSERT INTO mti_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tatevit, Iesu gwetoimu iviwa waya Nain aine, sira aigowawa ge iyayapan undag me gaibu amiya. ");
INSERT INTO mti_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Me gwetoimu ankwin noiwa megiyave uwaiviwa, apan boanewa iyayapan aug dauwag amome. Me inawa usiwa desiromiren meuma, sira me kwapura. Iyayapan gwetoimu undag inawa gaibu wakeya. ");
INSERT INTO mti_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ayapan me yaunewa, nonewa danadawai aug wane, “It den waya.” ");
INSERT INTO mti_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Meve me dauwag aig iragi paniyawa yumne, auyawa igiyawa mu di yokeya. Me wane, “Ud mataiwa, ne ge dirukna. Wan yoiya!” ");
INSERT INTO mti_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bo abnawa yug wan yoine, amatog gae wane. Iesu aug inawa itan wanne. ");
INSERT INTO mti_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mu undag a aya, sira God gumbe waiyaya. Mu waya, “Propeta kokawa nu yapunup matadne. God iyayapan meuma waita muntan oya uwane.” ");
INSERT INTO mti_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iesu gaiyawa mame Judia undag ge at koukawa birorot danave uwane. ");
INSERT INTO mti_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon aigowawa dividivi mame undag Jon gumbe waya. Me duwam munan auwaivi, ");
INSERT INTO mti_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me mu tene Ayapan gumbe singui atan amiya, “Matai uwatan vemewa me ge, go nu apan da menan amaraigimta?” ");
INSERT INTO mti_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Mu Iesu gumbe uwag waya, “Babataito Abnawa Jon genan singui gentan oya nu tenunne onantu, ‘Matai uwatan vemewa me ge, go nu apan da menan amaraigimta?’” ");
INSERT INTO mti_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Me kumive di, iyayapan obiren mu yuwat gaibu, danadawai gaibu sira airapu kukaeba gaibuwa Iesu warinamunne, sira yango boredmusiawa yangowa mereruwaya. ");
INSERT INTO mti_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Meoya me gae aug gigeme igiyawa gumbo gara wane, “Taig aisiya, sira divi yauyanawa ge anoyanawa Jon diya: Iyayapan yangabored musiawa mu inaimut yaveme, sira ama buburu musiawa a gigeme, iyayapan yuwat warumamne iviwa reprosi tamiyawa mu oraimina aya, nauno boredmusiawa gae anoeme, boriruwayawa sira inaimusia, sira tawara onan igiyawa gumbo gae oraiwa opata dirumeme. ");
INSERT INTO mti_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bira da nenan den aig aikpewa me gumbe waribiya wakeigimpe!” ");
INSERT INTO mti_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Namu Jon gae aug gigeme igiyawa Iesu kweg amiya, ivi Iesu gae amatog iyayapan agoniyayawa gumbo Jon oya dirumivi, “Ye at inguiwa arawa divi yautan oya dauwag aisiyana? Me gwab riid taig viyaiviwa yautan oya? ");
INSERT INTO mti_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Me onan ipewa ye divi yautan dauwag aisiyana? Apan da me wape oraimina ennewa yautan aisiyana? Iyayapan wape oraimumu enemewa mu kin gweyawa danave wakeeme. ");
INSERT INTO mti_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Megara, ye divi yautan oya dauwag aisiyana? Me propeta da yautan oya? E, ne diruitna, me kokavitwa, propeta da mina onan. ");
INSERT INTO mti_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Menan tenewa mame: ‘Ne umum abnawa barautna namuiban ompe, sira me genan ebu geuma tamibarip ape.’ ");
INSERT INTO mti_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne ye diruitna. Bira bira vesin gumbo yaiyawa yapowo Jon me mekuriren painao egave yaine. Megara God toimuwawa danave kusikarenwa me kokawa, Jon mina onan. ");
INSERT INTO mti_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iyayapan undag Jon gaiyawa anoyawa, sira takesi tameme igiyawa gaibu, mu yaug anoya, me God ebuwawa me oraimina, meoya mu babataito Jon gumbe aya. ");
INSERT INTO mti_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Megara Parisi igiyawa ge Gwangwan anoano koukawa igiyawa mu God anoanowawa topai aya, meoya mu babataito Jon gumbe den aya. ");
INSERT INTO mti_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iyayapan kum mame garewa aninin om yuwampna? Sira mu divi mina? ");
INSERT INTO mti_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mu ud usiusiwa mina. Ud torawa mu gwiruwaremewa arawa apa wakeeme sira aug garawano eme: ‘Nu bepuru yenan kae atu, megara ye tare den wariyana; Nu bo bererinawa totu, megara ye den iruwayana.’ ");
INSERT INTO mti_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kuiyawa Babataito abnawa Jon uwane sira me bredi ge wain den nanewa, ye vene, ‘Me airapu kukaeba gaibu.’ ");
INSERT INTO mti_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Apan Usiwa uwane me nakwaeba ge yoiba naiviwa, ye vene, ‘Me nakwai nabot nabot ge yoi koka naiviwa, sira me takesi tameme igiyawa ge kukaeba igiyawa gumbo yaire munne.’ ");
INSERT INTO mti_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Megara me usitainawa undag me anoano meuma oraimina me toewan muniya.” ");
INSERT INTO mti_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Gare Parisi apan da me Iesu gaibu augoi nakwaeba natan oya menan wane. Meoya me Parisi gweyawa aig teboro apa wakene. ");
INSERT INTO mti_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Vesin me at kokawa apa wakewake meuma kukainewa, me anone Iesu me Parisi gweyave naivi. Vesin me uinoum danave oira tayapama wakenewa aug onne, ");
INSERT INTO mti_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","me iripam aivi sira Iesu daieve amave yoine. Me amatog amawa yangawa it aeg kwanivi. Meve me kuiyagumawa gumbe muinivi, amawa noive uwatone, meve oira tayapama egamne. ");
INSERT INTO mti_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisi abnawa me Iesu menan auwanewa mame yaune. Sira mekut wane, “Apan mame propeta ipewa, me yaug anope. Vesin me yumiviwa me bira me aninin. Kuiyawa me kukaeba vesinawa.” ");
INSERT INTO mti_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iesu gara me gumbe wane, “Saimon, ne gae da diruktan eni.” “Didnega, toewanewan,” me wane. ");
INSERT INTO mti_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Apan duwam anmaga wanka avivi abnawa gumbe anmaga auya. Da 500 denari gumbe aune, sira da 50 denari gumbe aune. ");
INSERT INTO mti_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maun duwam garawa sira tobiyag wantan oya oma den ane. Meoya me duwam garawa sira autan oya yankwene. Meve ambuwa me nonewa kokavit autan?” ");
INSERT INTO mti_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon gara wane, “Ne anona me da garawa kokavit yankwenewa.” “Ge yaimoyai yaug anoana,” Iesu wane. ");
INSERT INTO mti_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Meve vesin gumbe tobiyag Saimon gumbe wane, “Ge vesin mame yavege? Ne ge gweyagwa dana onednawa, ge yoi da den negana amanwa muintan oya. Megara me it meuma gumbe amanwa puwam kuiyagumawa gumbe muinne. ");
INSERT INTO mti_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ge nogwa uwa den tonegana, megara ne unignawa gumbe, vesin mame amanwa gumbe uwa den kwene. ");
INSERT INTO mti_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ge oira kuiyanwa den egamana, megara me oira tayapama amanwa egave egamne. ");
INSERT INTO mti_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Meoya ne dirukna. ‘Vesin me dividivi obiren kukaeba meuma anog yankwene, kuiyawa me nonewa kokavit aune.’ Megara me kidnausiren anog yankwenewa nonewa kidnausiren aune.” ");
INSERT INTO mti_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Meve Iesu me gumbe wane, “Ge kukaeba geuma anog yankwene.” ");
INSERT INTO mti_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eb teyawa mu amatog mukut veme, “Apan mame me bira? Kukaeba anog yankweivi.” ");
INSERT INTO mti_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iesu vesin gumbe wane, “Ge anotumat geuma waita genne. Yum gumbe aga.” ");
INSERT INTO mti_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kum kusi ivi, Iesu at kokawa aine, gwe upeba amdau gaibu gidne. Meve me God toimuwawa gae oraiwa meuma gumbe wag dirumne. Sira aigowawa 12 me gaibu amiya. ");
INSERT INTO mti_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sira vesin upeba mu airapu kukaeba gumbo warinamunne ge yuwat warinamunnewa gaibu. Vesin dawa me Meri mu veme at Magdara vesin. Vesin mame me gumbe Iesu airapu kukaeba 7 atatai imnewa. ");
INSERT INTO mti_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna me Erod nau meuma aiviwa kokawa Kusa biviwa, Susanna ge vesin upeba gaibu. Vesin mame mu tawara dividivi muma gumbe waita muneme. ");
INSERT INTO mti_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iyayapan obiren agonieme, iyayapan at koukawa apa Iesu oya omome, meoya Iesu maibe mame dirumne: ");
INSERT INTO mti_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nau abnawa yawa meuma emetan aine. Me yawa emeiviwa, yawa upeba ebu taibe aigiya. Iyayapan amowo embabatam aya, nenip painau aigeg naya. ");
INSERT INTO mti_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yawa upeba an egave aigiya, mumin dauwaya. Megara toyaimusia, kuiyawa me apa yoi onan. ");
INSERT INTO mti_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yawa upeba gan dana aigiya. Yaig gan gaibu yoiya, sira gan yawa warumamne. ");
INSERT INTO mti_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yawa upeba piyu oraiwa egave aigiya. Me yaig dauwag natawa koniwa 100 mina inamiya.” Iesu mame wanewa, me auwane, “Bira da naunawa gaibuwa me kweya anope.” ");
INSERT INTO mti_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aigowawa Iesu gumbe singui waya maibe mame natawa aninin. ");
INSERT INTO mti_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Me wane, “God toimuwawa anoano guwavewa ye wait toyau yenna. Megara iyayapan upeba gumbo ne maibe gumbe dirumeni. ‘Mu yaveme, megara oma den ane yaupe. Mu anoeme, megara oma den ane yaug anope.’ ");
INSERT INTO mti_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maibe natawa me mame. Yawa me God gaiyawa. ");
INSERT INTO mti_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ebu taibe aigiyawa natawa me mamaib. Iyayapan mu anoeme, megara airapu kukaeba uwag God gaiyawa nonowa gumbe aug aipe. Meoya mu anotumat muma den apewa waita den aupe. ");
INSERT INTO mti_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yawa an egave aigiyawa me natawa me meib. Iyayapan mu God gaiyawa anog degaepam aueme, megara mu taiwa gaibu onan. Mu anotumat muma kum koni pipi, kuiyawa amaorot kumiwa uwapewa mu aikpe. ");
INSERT INTO mti_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Gan dana aigiyawa natawa me meib. Iyayapan mu anoeme, megara mu ebuwowo amome, mu inaiinai danadawaeba dividivi obirenwa ge kwapiwa inaiinaiba umiya, meoya mu natawa yaimoyai den impe. ");
INSERT INTO mti_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Megara yawa piyu oraiwa egave aigiyawa natawa me meib. Iyayapan mu nonowa bembemuwa ge nonowa oraiwa gumbe gae anog auemewa yai amareme natawa inamivi. ");
INSERT INTO mti_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Bira da damempa oket aug noum danave guwave den baraupe, go kubvintan deriyateba ankwatave den baraupe. Garawa me deriyat egave baraupe. Meve bira da ompewa me eyawa yaupe. ");
INSERT INTO mti_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kuiyawa guwave barauyawa me matai undag taibe ape, sira guwave barauyawa iyayapan matai undag yaug anope. ");
INSERT INTO mti_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Meoya yaimoyai yaug anoya. Bira da aunewa sira egave aupe. Bira da den aunewa me anoivi me meumawa me gumbe atan aupe.” ");
INSERT INTO mti_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gare Iesu inawa ge gwanebaiwa me yautan uwaya. Megara mu oma den ane me gumbe uwaya, kuiyawa iyayapan obiren agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Apan da me dine, “Yawa. Inag ge gwanegaiwa gwe daieve yoieme. Ge yaugemtan oya anoeme.” ");
INSERT INTO mti_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Iesu gara wane, “Ne inan ge gwanenaiwa mu iyayapan mu God gaiyawa anog ageyau emewa.” ");
INSERT INTO mti_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kum da Iesu aigowawa dirum wane, “Poeman visi gambenwa apa anta.” Meve mu wa danave dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mu wa gumbe amomewa, me kubvinivi. Taig yusipama awau danave aigne, meoya mu poeman tog umamivi, sira mu a muma koka ane. ");
INSERT INTO mti_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aigowawa meuma amog me togwanam veme, “Kokawa, kokawa, nu nonunwa natan aivi!” Me wan yoig taig ge yawarat yusiwa dirum wane. Taig yusiwa yankwene sira undag botone. ");
INSERT INTO mti_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Ye anotumat yeuma ampa?” aigowawa dirumne. Mu terag a ake gara wa ano aya, “Apan mame bira? Me taig ge yoi gumbo wanewa mu noiwa auya.” ");
INSERT INTO mti_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Mu at Gerasa apa amiya. Me poeman Gariri gambenwa gumbe. ");
INSERT INTO mti_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iesu awau aig visive dauwanewa, apan da nuntosane. Me airapu kukaeaba gumbe dodnewa sira me at kokawa apa onne. Me wape onan gwe onan babat dana kum yobenut wakeivi. Inaiinai meumawa meib di onne. ");
INSERT INTO mti_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Me Iesu yaunewa, me kwat wag me amave aigne. Sira au wan kuiyaven waivi, “Iesu, God Painauvitwa Usiwa, nu gunup divi amon? Ne nun veni den watkukam nega!” ");
INSERT INTO mti_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kuiyawa Iesu airapu kukaeba dig wane apan mame gumbe yankweg dauwape. Airapu kukaeba evedni me kikikit yumne, meoya naniwa amawa murap gumbe tuya iyayapan amat me gumbe eme. Megara me murap tuiyawa togomiyane, sira airapu kukaeba atataine pomtone arawa aine. ");
INSERT INTO mti_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iesu me gumbe singui wane, “Ivugwa anin?” Me gara wane, “Riijon,” kuiyawa airapu kukaeba obiren me danave unig wakeya. ");
INSERT INTO mti_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sira mu Iesu gumbe nun waya me den dirumpe mu dukup epampa danave aig ampe. ");
INSERT INTO mti_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bui obiren tui gambenwa apa iyayapan amareme. Airapu kukaeba Iesu gumbe nun waya me bainda wape mu bui danave am unikpe, meoya Iesu mu gumbo bainda wane. ");
INSERT INTO mti_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Airapu kukaeba apan danave dauwag uwayawa, mu bui danave am unigiya. Sira bui tui naunawa kintog erai wat amog awau danave aigiya nonowa naya. ");
INSERT INTO mti_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bui amareme igiyawa mu divi anin anewa yauya, sira mu kintog amog at kokawa ge at gwetoimu apa mame dirumiya. ");
INSERT INTO mti_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Meve iyayapan mu Iesu divi anin anewa yautan oya dauwag onamiya. Mu Iesu gumbe uwag yauyawa, apan me airapu kukaeba danave dauwag ainewa, me wape enne sira nonewa oraimina gumbe Iesu amave yanwakene. Mu a aya. ");
INSERT INTO mti_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iyayapan mu yauyawa, iyayapan da gumbo dirumiya, apan me airapu kukaeba gaibuwa aninin wait inaine. ");
INSERT INTO mti_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Meve at Gerasa igiyawa a ag Iesu diya yankwem aitan oya waya. Meoya Iesu wa gumbe dauwag kwem aine. ");
INSERT INTO mti_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Apan me airapu kukaeba danave dauwag ainewa me gaibu aitan oya nun wane. Megara Iesu me baraune aig wane, ");
INSERT INTO mti_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Taig gwe aga sira anintom God ge gungap anewa mu diruma.” Meoya apan kweg aine sira Iesu anintom menan anewa at kokawa undag dirumne. ");
INSERT INTO mti_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gare Iesu taignewa, iyayapan obiren kaiwa kaiwa waniya. Kuiyawa mu undag menan amareme. ");
INSERT INTO mti_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Meve apan iviwa Jairas, me sinagogu namuyoiyoi abnawa, me uwag Iesu amave aig gwe meuma gaibu ongetan oya nun wane. ");
INSERT INTO mti_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kuiyawa me gwaitawa desiromiren, otau bairawan 12 mina. Me boaivi. Iesu aiviwa, iyayapan undag garaman ag Iesu gumbe amiya. ");
INSERT INTO mti_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Vesin da wakene. Me bairawan 12 danave ganigani warivi. Megara bira da oma den ane warinamne. ");
INSERT INTO mti_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Me Iesu daieven uwag wape meumawa ginawa yumne. Meve ganigani wariviwa me tatevit gomane. ");
INSERT INTO mti_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iesu singui wane, “Bira ne yumnedne?” Mu undag uyai wayawa, Pita wane, “Kokawa, iyayapan obiren agoniyag ge manageme.” ");
INSERT INTO mti_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Megara Iesu wane, “Bira da ne yumnedne. Ne yutunwa gunap dauwag aine anona.” ");
INSERT INTO mti_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Meve vesin yaug anone me oma den ane yaug anog guwave umpe. Me daramipam uwag me amave aigne. Iyayapan undag namuwo, me wane divi oya Iesu yumne sira aninin tatevit inaine. ");
INSERT INTO mti_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Meve me gumbe Iesu wane, “Gwaitan, anotumat geuma ge warinam genne. Yum gumbe aga.” ");
INSERT INTO mti_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iesu ande gae waiviwa, Jairas me sinagogu namuyoiyoi abnawa, me gweyawa apa apan da onnewa wane, “Ge gwaitagwa botone. Meoya toewanewan abnawa sira danadawai den wana.” ");
INSERT INTO mti_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iesu anog Jairas gumbe wane, “A den a, anotumat a, me sira inaipe.” ");
INSERT INTO mti_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Me Jairas gweyawa uwanewa, me iyayapan gaibu uniktanwa watai munne. Me Pita, Jon ge Jemus, ge ud inamamawa mukut gaibu unigiya. ");
INSERT INTO mti_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Meve, iyayapan undag gwaitawa oya iruwag danadawai aueme. Iesu dirumwane, “It yankweya. Me den botone. Me kubvinivi.” ");
INSERT INTO mti_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mu anoya me botone, meoya me gumbe iyagau ag toveme. ");
INSERT INTO mti_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Megara Iesu gwaitanwa nanive wan aug wane, “Ne utunwa, wan yoiya!” ");
INSERT INTO mti_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Me guwawa taigne, sira tatevit me wan yoine. Meve Iesu dirumne divi da waniya nape. ");
INSERT INTO mti_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inamamawa teraya. Megara Iesu gwangwan dirumne bira da gumbe den waya me anin anewa. ");
INSERT INTO mti_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Meve Iesu auwag apasoro 12 agoniyayawa, me airapu kukaeba undag atatai imtan oya ge yuwat kukaeba warinamuntan oya yusiwa ge ano yusipam munne. ");
INSERT INTO mti_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Sira God toimuwawa gaiyawa opata muntan oya ge yuwat igiyawa warinamuntan oya me tene dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iesu dirum wane, “Amdau oya divi da den auya. Tutu onan, ikwai onan, nakwai onan, anmagawa onan, wape duwam onan. ");
INSERT INTO mti_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Sira gwe ambuwa ye unigiyawa, asime wakeigimiya, meve at gwe me kweya. ");
INSERT INTO mti_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ye at ambuwa uwaya iyayapan den baigan yempewa go gae yeuma den anopewa, mu yaug anotan oya amedanawa atapupu toya aikpe, meve at kokawa muma kweya.” ");
INSERT INTO mti_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mu meve dauwag gwe gwe amog, God gae oraiwa opata wag gigiya, iyayapan ampa ampa warinam muniya. ");
INSERT INTO mti_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erod me at kokawa ayapaneba me dividivi pawaiviwa undag anone, sira nonewa painau ane. Kuiyawa iyayapan upeba veme, “Jon boriruwayawa igiyawa gumbo sira inaig yoine.” ");
INSERT INTO mti_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Iyayapan upeba veme, “Eraija me sira uwane,” sira upeba veme, “Me propeta da watavitwa mina, me sira inaig taig uwane.” ");
INSERT INTO mti_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Megara Erod wane, “Ne Jon meyawa kwagomiyana. Apan mame gumbe iyayapan vemewa sira me gumbe ne anoeniwa me bira?” Meoya Erod Iesu yautan oya diune. ");
INSERT INTO mti_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sira apasoro taig uwaya. Mu dividivi ayawa Iesu gumbe umum waya. Meve Iesu mu tam me gaibu guwave at Betuseida amiya. ");
INSERT INTO mti_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Megara iyayapan agoniyayawa mu yaveg anoya sira amave amtan oya onamiya. Me kaiwa kaiwa munke God toimuwawa oya dirum wane. Sira me inaimuntan anoeme igiyawa warinamunne. ");
INSERT INTO mti_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ivi aram muniwaiviwa mu apasoro uwake Iesu dig waya, “Iyayapan agoniyayawa wa ampe. Gweyowa birorot ge at gambenwa apa amke nakwai ge vintanwa didimama ape. Kuiyawa nu mapa gina inguiwa arawa waketu.” ");
INSERT INTO mti_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Me gara wane, “Ye divi da nakwai muniya.” Mu gara waya, “Nu bredi naningambenit ge gwambui duwam me mekut, da onan. Meoya agoniyayawa mame undag oya nu an nakwai gwiruwatta?” ");
INSERT INTO mti_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Apan undag 5,000 mina me apa wakeya. Megara Iesu aigowawa dirum wane, “Waya. Kuiyawa desirom desirom 50 mina agoniyag yanwakepe.” ");
INSERT INTO mti_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Aigowawa me dirum wanewa mina aya, sira iyayapan undag yanwakeya. ");
INSERT INTO mti_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Meve Iesu bredi naningambenit ge gwambui duwam tam, kwimin wan yaug gaun wane. Meve sike aigowawa munne. Mu iyayapan keb ag muniya. ");
INSERT INTO mti_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mu undag naya oma ane. Aigowawa mu musimusiwa ande wakeyawa kwiniyag pot 12 enamiya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kum da Iesu mekut nun waiviwa, aigowawa me gaibu. Iesu dirum wane, “Iyayapan aninin veme, ne bira?” ");
INSERT INTO mti_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Mu gara waya, “Upeba me Babataito abnawa Jon veme, upeba Eraija veme, sira upeba veme propeta namuwa da sira inaig taig uwanewa da.” ");
INSERT INTO mti_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iesu mu gumbo wane, “Ye aninin vene, ne bira?” Pita gara wane, “Ge God Keriso.” ");
INSERT INTO mti_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Iesu mu gumbo gwangwan dirumne bira da mame oya den dirumpe. ");
INSERT INTO mti_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Sira me wane, “Apan Usiwa matai danadawai obiren di aupe. Namuyoiyoi igiyawa, pirisi koukawa ge Gwangwan toewanewan igiyawa me topayape, toin gutpe, kum duwamdesiyawa danave me sira inaig yoipe. Me di matatpe.” ");
INSERT INTO mti_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Me mu undag dirum wane: “Da bira imive ne amanap ontan ape ipewa, me evedni membo topayape korosi meuma wan aupe meve ne amanap ompe. ");
INSERT INTO mti_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kuiyawa bira da inaiinai meumawa membo autan anopewa, me matai waropiyape. Megara bira da inaiinai meumawa nenan oya waropiyapewa, me matai aupe. ");
INSERT INTO mti_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Apan me piyu mame undag aupe, go membo waropiyape sira anokukampe ipewa oraiwa meuma aninin? ");
INSERT INTO mti_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bira da ne ge gae neuma gumbe ubmam ape ipewa, matai Apan Usiwa me membo ge Mamawa ge iyakaisi aneya eyawa danave uwape kumiwa apa, me gumbe ubmam ape. ");
INSERT INTO mti_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne natawa diruitna. Mapa yokeyawa yapowo upeba mu God toimuwawa yaupe, ivi mu boriruwape.” ");
INSERT INTO mti_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Oiyat 8 mina onananewa, Iesu mame wane. Me Pita, Jon ge Jemus tam me gaibu tui egave nun watan oya dog aine. ");
INSERT INTO mti_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Me nun waiviwa, ginanamiwa biroriyane. Sira wape gaibu pupuyuiren biroriyane kapisi kapisi aivi. ");
INSERT INTO mti_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yauya. Apan duwam mu Iesu gaibu gae veme. Mu Mosisi ge Eraija. ");
INSERT INTO mti_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Mu eyawa danave uwaya. Mu Iesu bowawa gaiyawa veme. Gaiyawa me Iesu Jerusarem apa aitan aiviwa. ");
INSERT INTO mti_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita ge me owowaiwa mu yangowa ibnawa aivi. Megara mu yangowa merameg, mu me eyawa meuma ge apan duwam Iesu gaibu yokeya yauya. ");
INSERT INTO mti_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Apan duwam Iesu yankweg amomewa, Pita Iesu gumbe wane, “Kokawa, nu mapa waketuwa me oraimina. Nu gwe kusi duwamdesi sita. Desirom me genan oya, desirom me Mosisi oya, desirom me Eraija oya.” Pita membo den yaug anone divi waivi. ");
INSERT INTO mti_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Me gae mame waiviwa, guwaveru uwag mu umamne, guwaveru danave unigiya, meoya aigowawa a aya. ");
INSERT INTO mti_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Noiwa guwaveru apa uwane wane, “Mame ne Utunwa. Me ne anog wagomiyag wannawa. Me gumbe anoigimiya.” ");
INSERT INTO mti_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Noiwa wanewa, mu yauya Iesu mekut wakene. Mu Iesu mekut yauya. Mu mame anog iyadmusia. Sira me kumive mu yauyawa bira da umum den waya. ");
INSERT INTO mti_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kum umae, mu tui apa aig onamiyawa, iyayapan obiren Iesu yauya. ");
INSERT INTO mti_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Iyayapan obiren yapowo apan da noiwa kokavit kwaruwane, “Toewanewan, ne gungap nun veni. Ud neuma yawa. Me ne ud desiromiren. ");
INSERT INTO mti_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yawa. Airapu kukaeba me dodnewa, tatevit au ge kwaruwag daram daram aivi, noiwa poriman borivi. Den yankweg aivi kwekweru onan, sira me wakukamivi. ");
INSERT INTO mti_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne aigowagwa gumbo nun wana me dauwag aipe. Megara oma den ane mu aya.” ");
INSERT INTO mti_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iesu wane, “A, iyayapan garewa mu anotumat muma onan. Wakewake muma gegeru. Kum anintom ne ye gaibu wakeigimpna sira amara yenigimpna? Ud geuma aug mapa onaga.” ");
INSERT INTO mti_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ud torawa me man oniviwa, airapu kukaeba me aug aoreivi piyu egave aig daramiwa waivi. Megara Iesu airapu kukaeba dig wane, sira ud waribiyag mamawa gumbe sira wanne. ");
INSERT INTO mti_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Meve undag God nauwawa kokavitwa gumbe teraya. Dividivi undag Iesu anewa gumbe iyayapan undag arag vemewa, Iesu aigowawa dirum wane, ");
INSERT INTO mti_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ne ye diruitnawa yaimoyai anoya. Apan Usiwa ominawa iyayapan nanuwo baraupe.” ");
INSERT INTO mti_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Megara mu den yaug anoya me anin wanewa sira me oya dig anotanwa a aya. Me mu gumbo guwave ane, meoya mu den yaug anoya. Sira mu gae mame Iesu gumbe singui den waya. Mu a aya. ");
INSERT INTO mti_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aigowawa mu mukut amatog garawa eme, mu yapowo ud ambuwa kokavit atan? ");
INSERT INTO mti_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iesu gae mumawa imive anonewa, ud usiwa aug me megiyave baraune yokene. ");
INSERT INTO mti_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Meve mu dirum wane, “Da bira me ud kusi mame gumbe ne ivunwa gumbe engaun apewa, me ne gunap engaun ape; sira da bira me ne gunap engaun apewa, me ne gunap engaun den ape ne baraunedne onegnawa gumbe engaun ape. Kuiyawa ye undag yapeyap kusikarenwa me kokavitwa.” ");
INSERT INTO mti_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon gara wane, “Kokawa. Nu apan da yautu, airapu kukaeba ge ivugwa gumbe wane dauwag amiya. Nu me yankwetan oya ageyau atu, kuiyawa apan me numawa onan.” ");
INSERT INTO mti_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iesu dirumne, “Den diya yankwepe. Kuiyawa da bira me nu gunup daietaitai den anewa me numawa.” ");
INSERT INTO mti_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Iesu kwimin wan dog aitanwa kumiwa koni aiviwa, me Jerusarem aitan oya anone. ");
INSERT INTO mti_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sira me umumawa namu tene amiya. Mu amog Samaria gwe da uwag dividivi waribiyag menan amareme. ");
INSERT INTO mti_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Megara iyayapan asimeve wakeyawa mu Iesu gumbe baigan den aya, kuiyawa Iesu Jerusarem oya aivi. ");
INSERT INTO mti_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Me aigowawa Jemus ge Jon mu mame yaveg waya, “Ayapan. Nu wata iyam igiviwa kwiminau aig wakukam mumpe. Ge anoege?” ");
INSERT INTO mti_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Megara Iesu mu gumbo tobiyag gae yusipamit toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sira mu gwetoimu da amiya. ");
INSERT INTO mti_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mu ebutaibe amomeve, apan da Iesu dig wane, “Ne ge amagap onekna. Ge ampa agawa ne amagap anekna.” ");
INSERT INTO mti_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iesu gara wane, “Mae okusi piyu nogave wakene, sira nenip en painau wadne, megara Apan Usiwa kubvintan oya at meuma onan.” ");
INSERT INTO mti_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Iesu apan da dig wane, “Amanap onaga.” Megara apan wane, “Ayapan, namu ne kwenega anekna maman neuma sitna.” ");
INSERT INTO mti_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iesu dirumne, “Yankweya. Bo igiyawa kwema mumbo si ampe, megara ge aga God toimuwawa gaiyawa opata waigima.” ");
INSERT INTO mti_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Da sira gaibu wane, “Ayapan, ne amagap onekna. Megara namu kwe nega taig aneg iyayapan neuma nanuwa gaun amuntnave.” ");
INSERT INTO mti_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iesu gara wane, “Bira da me namu ib aupe ivi daieven yaupewa me oraimina onan God toimuwawa oya.” ");
INSERT INTO mti_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mame ivi Ayapan aigowawa upeba 72 gomiyamunne. Me tene duwam duwam namive namu amiya. Mu gwetoimu koka ge gwe gwe undag me matai aipewa arawa undag guigiya. ");
INSERT INTO mti_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Me mu dirumne, “Maura obiren, go nau atanwa obiren onan. Maura Ayapaneba gumbe nun waya, me nau igiyawa tepe maura kumiwa nau meuma danave ampe. ");
INSERT INTO mti_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aisiya! Ne ye teeni. Ye aisiyawa me sip usiwa mae urup danave teeni mina. ");
INSERT INTO mti_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Anmaga ikwaeba ge ikwai ge sandoro den tamiya. Bira da ebu taibe yauyawa den baigan niyaya. ");
INSERT INTO mti_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ye gwe unigiyawa namu waya, ‘Yum gwe mame gumbe.’ ");
INSERT INTO mti_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yum apan asime ipewa, yum geuma me gumbe wakepe. Onan ipewa, yum me genan sira taig ompe. ");
INSERT INTO mti_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Gwe desirom apa wakeya, sira dividivi ye yempewa naigimiya. Kuiyawa nau eme igiyawa mu nau garawa auya. Gwe gwe gumbe ipunapun ag birorot den gigiya. ");
INSERT INTO mti_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ye gwetoimu dana unigiya sira baigan yempewa, dividivi namuyap tepewa naya. ");
INSERT INTO mti_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Asimeve yuwat igiyawa wakeyawa warinamuniya, sira mu dirumiya, ‘God toimuwawa koni aivi.’ ");
INSERT INTO mti_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Megara ye gwetoimu uwayawa iyayapan den baigan yempewa, ebu taibe dauwag waya, ");
INSERT INTO mti_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Atapupu gwetoimu yeumawa me amunwa batamne. Nu atapupu mame guniyap toderere ata. Megara, God toimuwawa koni aiviwa me anoya.’ ");
INSERT INTO mti_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne ye diruitna. Me kumiwa apa, Sodom ge Gomora ibnawa muma me bembemu, go gwetoimu asime ibnawa me koka. Ne diruiyeni. Me kumive, Sodom kusi wakukampe, megara gwetoimu asime kokavit wakukampe. ");
INSERT INTO mti_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","At Koreijin, ano kukaeba gungap! At Betuseida, ano kukaeba gungap! Kuiyawa irayauyau ye guniyap me anewa, at Taiya ge at Saidon danave me anewa ipewa, mu tate wape pumpunewa enag atapupu danave yan wakeg nonomagowa biroriyapono. ");
INSERT INTO mti_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Me kumive at Taiya ge at Saidon garawa muma me bembemu, megara ye garawa me ibnapam. ");
INSERT INTO mti_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sira ge Kapenaum! Ge matai kwimin dog aga? Onan, ge matai at kukaeba ades danave yan aiga. ");
INSERT INTO mti_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Bira da ye ano yeniviwa me nenan anoivi. Sira bira da ye topai yemiviwa me ne topai negivi. Megara bira da ne topai negiviwa, me ne baraunedne onednawa topayaivi.” ");
INSERT INTO mti_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aigowawa 72 degadega gaibu sira taig uwag waya, “Ayapan, ge ivugwa gumbe airapu kukaeba gaibu nu ano nuniya.” ");
INSERT INTO mti_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Iesu wane, “Ne yauna Seitan kwiminau kapisi wariviwa mina aigne. ");
INSERT INTO mti_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yauya. Ye mokare ge wawano egave emtan oya sira ye anavi mut yusiwa undag guttan oya yusipama yenna, meoya divi da guniyap kukaeba da den ape. ");
INSERT INTO mti_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Megara airapu kukaeba ye ano yemivi oya degadega den aya. Ye ivuiwa kwimin danave tene oya degadega aya.” ");
INSERT INTO mti_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Me kumiwa apa Guwawa Iyakaisiyapama gumbe degadega kokavitwa gumbe Iesu wane, “Maman, kwimin ge piyu ayapaneba, ne ge watdega gemeni. Kuiyawa ge anoano koukawa igiyawa gumbo ge dividivi mame yaug anoyawa gumbo guwave teyana, go ud usiusiwa gumbo taibe watapana. E, Maman. Mame anoano geuma oraiwa gumbe pawane. ");
INSERT INTO mti_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dividivi undag Maman ne nedne. Maman mekut Apan Usiwa yaug anone. Sira bira da Maman den yaug anone. Sira Usiwa imive iyayapan mu Maman oya yaug anopewa mu mukut Maman yaug anope.” ");
INSERT INTO mti_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Me tobiyag me aigowawa guwave dirum wane, “Ye gare yavenewa matai yaupe. Yangowa me waribiyape. ");
INSERT INTO mti_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ne ye diruitna. Propeta ge kin obiren ye gare yavenewa mu mina yautan anoya. Megara oma den ane yauya. Gare ye anoenewa mu anotan anoya. Megara oma den ane anoya.” ");
INSERT INTO mti_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kum da Gwangwan gumbe anoano kokavitwa da wan yoig Iesu ag yautan oya singui wane, “Toewanewan. Ne divi akape yaibobot inaiinaiba auten?” ");
INSERT INTO mti_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Me gara wane, “Gwangwan gigirumawa danave aninin teya? Ge aninin basiege?” ");
INSERT INTO mti_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Me gara wane, “‘Nonegmagawa undag gaibu, guwawa geuma undag gaibu, yutugwa undag gaibu, imugwa undag gaibu, Ayapan God geuma gumbe baigan a.’ Sira ‘Ge iyayapan baigan munigima ge gembo baigan niege mina.’” ");
INSERT INTO mti_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iesu gara wane, “Meme. Ge bainda wana. Mame ge awa, ge yaibobot inaiinaiba auwa.” ");
INSERT INTO mti_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Megara me membovit iviwa waiyatan oya anone. Me Iesu dine, “Ne evenwa me bira?” ");
INSERT INTO mti_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iesu gara wane, “Apan da Jerusarem apa aig Jeriko aig aiviwa, ebu taibe me ub igiyawa nanuwo danave aigne. Mu yumeg wapeyawa vieg, me toveg, me bo koni totan aneve kweyeg amiya. ");
INSERT INTO mti_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pirisi da ebu desiroma aig onne. Megara me apan yaunewa me yankweg ebu megiyave uwag aine. ");
INSERT INTO mti_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Me mina di Rivai apan da me aig at me uwane me yaunewa ebu megiyave uwag aine. ");
INSERT INTO mti_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Megara, Samaria apan ebu me aine, apan me gumbe uwane. Uwag me yaunewa danadawai aune. ");
INSERT INTO mti_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Me menan aig, oira ge wain kamot yangave egamne, meve kamot meuma popanne. Meve me mae donki meuma egave apan baraug aug nonowa ememe gweyawa aig baraune amarane. ");
INSERT INTO mti_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Vinne wantene me anmaga meuma denari duwam aug nonowa ememe gweyawa abnawa wanne. Me wane, ‘Me amara. Ne sira taig uwatnawa, apan mame oya anintom aoreyawa meve garawa da sira gentna egave gaibu.’ ");
INSERT INTO mti_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Mu duwamdesi mame gumbo anoege. Apan ambuwa me eveba, apan me ub igiyawa nanuwo danave aignewa gumbe?” ");
INSERT INTO mti_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Me gara wane, “Me danadawai menan anonewa.” Iesu me dine, “Ge aga meib di aigima.” ");
INSERT INTO mti_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iesu ge me aigowawa mu amomewa, Iesu gwe da uwane. Vesin iviwa Maata me baigan gumbe gweyave me baraune. ");
INSERT INTO mti_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Vesin me gwaneba gaibu iviwa Meri. Me Ayapan amave yanwakeg me waiviwa anoivi. ");
INSERT INTO mti_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Megara Maata me imiwa iyai den wakene, kuiyawa dividivi undag waribiyatan oya nau kokavit aivi. Me Iesu gumbe uwag wane, “Ayapan, ne nekut nau eni, ne gwanenwa yankwenegne. Ge den anoege? Dia me ne waita netpe.” ");
INSERT INTO mti_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ayapan gara wane, “Maata, Maata, dividivi obiren oya danadawai auege anogugut ege. ");
INSERT INTO mti_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Megara desirom mekut Meri anoivi. Me oraiwa wat gomiyane. Me gumbe den aug aipe.” ");
INSERT INTO mti_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kum da Iesu at da apa wakeg nun waivi. Nun wane onananewa, aigowawa da desirom me wane, “Ayapan, nun waigimtan oya toewan nuna Jon aigowawa toewan munne mina.” ");
INSERT INTO mti_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Me dirum wane, “Ye nun watanwa, mamaib waya: ‘Mamunwa, ivugwa ayamat aigimpe. Toimu geuma uwape. ");
INSERT INTO mti_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kum gare evedni nakwai numa nunigima. ");
INSERT INTO mti_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kukaeba numa anog yankweya, nu mina iyayapan mu kukaeba muma gunup emewa anog yankweta. Amaorot gumbe den tenuna.’” ");
INSERT INTO mti_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sira me mu dirum wane, “Anten ye daneyap desirom eveba gaibu, me menan aig aram nub bagiwa uwag wapa, ‘Enda, bredi duwamdesi nega, ");
INSERT INTO mti_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","kuiyawa ne evenwa amdau aigin sira on gunap uwane. Ne divi da onan me namive barautna.’ ");
INSERT INTO mti_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Gwe danave me garawa wane, ‘Nenan den anoa. Ankwin me wait tobodne. Ne ud ne gunap kubvineme. Ne wan den yoig divi da den gentna.’ ");
INSERT INTO mti_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ne diruitna. Me eveba oya, wan den yoig bredi den wampe. Megara waigimpewa, me oya wan yoig dividivi anoiviwa me wampe. ");
INSERT INTO mti_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Meoya ne ye diruitna. Kinuni aigimiya me yempe. Didimama aigimiya me yauya. Papapak toigimiya me ankwin yenan watappe. ");
INSERT INTO mti_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bira da kinuni apewa aupe. Bira da didimama apewa yaupe. Bira da papapak topewa me ankwin watappe. ");
INSERT INTO mti_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ye yapeyap mamawa da wakene? Ge utugwa gwambui oya wapewa, me garawa mokare wampe? ");
INSERT INTO mti_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A, me kokorek bagiwa oya kinuni apewa, me wawano wampe? ");
INSERT INTO mti_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ye kukaeba igiyawa. Megara ye yaug anoyana aninin garawa oraimumu ud yeuma muniya. Meib ye Mamewa kwiminauwa menan nun wayawa Guwawa Iyakaisiyapama kokavit anintom yempe!” ");
INSERT INTO mti_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Iesu airapu kukaeba me noiwa borednewa atatai imne dauwag amiya. Airapu kukaeba dauwag amiyawa, apan me noiwa borednewa gae wane. Meoya iyayapan obiren teraya. ");
INSERT INTO mti_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Megara iyayapan upeba waya, “Berujeburu me airapu kukaeba kokawa muma gumbe me airapu kukaeba atatai imivi.” ");
INSERT INTO mti_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Upeba me gumbe ageyau atan oya kwiminauwa irakoniwa da kinuni aya. ");
INSERT INTO mti_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Iesu danowa yaug anone mu dirumwane, “Toimu da wagomiyak me mekut ube yoipewa me matai aikpe, sira gwe togomiyak me mekut ube yoipewa me aikpe. ");
INSERT INTO mti_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seitan togomiyak me mekut ube yoipewa me aninin toimu meuma yoipe? Ne mame veni, kuiyawa ye yano vene ne airapu Berujeburu gumbe atatai imeni. ");
INSERT INTO mti_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne airapu kukaeba Berujeburu iviwa gumbe atatai imigimtnawa, ye aigoewa bira gumbe atatai impe mu dauwag ampe. Meoya, ye aigoewa mu ye keptete abnawa yeuma ape. ");
INSERT INTO mti_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Megara ne God naniguriwa gumbe airapu kukaeba atatai imeniwa, God toimuwawa me guniyap uwane. ");
INSERT INTO mti_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Meve apan yusipama mut undag tamke membo gweyawa amat aiviwa, dividivi meuma undag bainda. ");
INSERT INTO mti_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Megara bira da yusipamit tewampe me gumbe yusiwa kokavit apewa, beyan me apan anotumat anewa me aupe sira dividivi tamnewa kebape. ");
INSERT INTO mti_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ne gunap onanwa me ne gunap anavi aiviwa. Sira ne gunap den agoniyaiviwa me wat murarianewa. ");
INSERT INTO mti_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Airapu kukaeba apan danave dauwag ainewa, me yoi onan arawa gigivi nonewa emtan arawa didimama aivi go da den yaune. Meve me wane, ‘Ne gwe wait kwenawa sira taig anekna.’ ");
INSERT INTO mti_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Me sira taig uwane gwe danave yaunewa gwe danave ingui, ereri aiyane sira dividivi yaiyai tene. ");
INSERT INTO mti_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Meve me sira dauwag aine airapu kukaeba upeba yusipama 7 tam onne. Kukaeba muma koka, me membo mina onan. Mu undag uwag asime unig vineme. Meve apan me inaiinai meuma oieba di kukaine, namuwa mina onan.” ");
INSERT INTO mti_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Dividivi mame oya Iesu waiviwa, iyayapan agoniyayawa danowo vesin da wane, “Danave yaiyanawa ge am gennewa me waribiyane.” ");
INSERT INTO mti_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Megara me wane, “Onan, God gaiyawa anoeme ge auemewa waribiya mumpe.” ");
INSERT INTO mti_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iyayapan agoniyayawa koka aivi, meoya Iesu wane, “Kum garewa kukaeba. Me irakoniwa oya nun veme! Megara propeta Jona irakoniwa meuma mekut mumpe, dawa onan. ");
INSERT INTO mti_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kuiyawa Jona me Nineve igiyawa oya irakoniwa ane. Apan Usiwa me meib kum garewa igiyawa oya irakoniwa ape. ");
INSERT INTO mti_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwiin sausu apa matai uwape, sira pui keptete kumive gare mame igiyawa gaibu yoipe iyayapan mame dirum wakukampe; kuiyawa kwiin me Soromon anoano meuma anotan oya piyu gina gambenwa apa dauwag onne. Megara, yauya, gare apan kokawa mapa, Soromon mina onan. ");
INSERT INTO mti_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nineve igiyawa keptete oieba kumive kum garewa igiyawa gaibu wan yoig kum garewa igiyawa pui yuwampe. Kuiyawa mu Jona opata meuma gumbe nonemagowa biroriyaya. Megara yauya. Mapa kokawa wakene Jona me mina onan. ");
INSERT INTO mti_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bira da dun oket aug guwave go kabum ankwatave den baraupe. Megara deriyat egave baraupe yokepe. Bira da onampewa mu eyawa yaupe. ");
INSERT INTO mti_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ge yangagwa me ge kwapugwa duniwa. Ge yangagwa oraimina apewa, ge kwapugwa undag me mina eyawa noidauwane. Megara me oraimina den anewa, ge kwapugwa me mina sisip noidauwane. ");
INSERT INTO mti_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Meoya yaukape. Eyawa ge gungaba sisip den uwape. ");
INSERT INTO mti_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Meoya ge ui kwapugwa undag eyawa noidauwane sira sisip desirom da den wakenewa, dun eyawa gungap esivi mina me undagit esine.” ");
INSERT INTO mti_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iesu gae wane onananewa, Parisi abnawa nakwai me gaibu natan oya eb baraune, meoya me unig aine teboro apa yan wakene. ");
INSERT INTO mti_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Megara Parisi abnawa me Iesu nakwai oya namu den muinnewa yaug terane. ");
INSERT INTO mti_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Meve Ayapan me gumbe wane, “Bainda, ye Parisi igiyawa ap ge en daiewa muinene, megara danavewa miyot umamne, dividivi tamtanwa ge mukut mukut noidauwane ");
INSERT INTO mti_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ye kuiyewa onan igiyawa! Me daievewa aninin anewa daneyap me mina meib ane, go onan? ");
INSERT INTO mti_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Megara dividivi ye daneyap wakeyawa mu tawara onan igiyawa muniya, meve dividivi undag guniyap muimpe oraimina ape. ");
INSERT INTO mti_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Parisi igiyawa, ye ano kukaeba guniyap! Kuiyawa ye wayo mint, wayo rue ge dividivi nakwai undag naninwanit danave kebag desirom God oya puyo baraugimiya. Megara oraivitwa ge God baigan meuma ye topai ene. Ye gae iviwa dividivi mame atanit di, sira dividivi upeba me mina gaibu atanit di. ");
INSERT INTO mti_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Parisi igiyawa, ye ano kukaeba guniyap! Kuiyawa ye sinagogu danave seya painauwa waketan anoene, sira gwiruwaremewa arawa danave iyayapan gaun muma autan anoene. ");
INSERT INTO mti_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ye ano kukaeba guniyap! Kuiyawa ye dagup me guwave wakeyawa mina, iyayapan mu den yaug anoka egave gigeme.” ");
INSERT INTO mti_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Apan da Gwangwan yaug anonewa me gumbe gara wane, “Toewanewan, dividivi mame ge vegewa, me nu gaibu yan barau nunege.” ");
INSERT INTO mti_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iesu gara wane, “Ye Gwangwan yaug anoyanawa, ye ano kukaeba guniyap! Kuiyawa ye mu yaigiwa aninaka auton me ibnawa kokavitwa iyayapan gumbo munene, megara ye yembovit naniguri desirom da gumbe me den yumke waita muniya. ");
INSERT INTO mti_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ye ano kukaeba guniyap! Kuiyawa ye propeta oya dagup siene, megara ye isimureiwa mu guriya. ");
INSERT INTO mti_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ye isimureiwa ayawa ye yangovo yauyawa sira mu ayawa ye undagit yaug anoyana. Kuiyawa ye isimureiwa propeta guriya, sira ye dagup muma siene. ");
INSERT INTO mti_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Meoya, God me anoano meuma gumbe wane, ‘Ne propeta ge apasoro tetna munan onampe, megara upeba mu gutpe sira upeba mu edawai mumpe. ");
INSERT INTO mti_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Meoya piyu amatone kumiwa apa propeta undag di muma oya kum gare igiyawa ibnawa aupe. ");
INSERT INTO mti_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aber di meuma apa amatog, iyakaisi kem meuma ge God gweyawa yapave Jakaraya toya boine onne mu diyawa gumbo kum gare igiyawa ibnawa aupe. E, ne diruitna, kum gare igiyawa ibnawa undag aupe.’ ");
INSERT INTO mti_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ye ano kukaeba guniyap, Gwangwan yaug anoyanawa. Kuiyawa ye anoano ankwin wataptanwa aug aisiyana. Ye yembovit den unigiyana, sira uniktan eme igiyawa toboriyana.” ");
INSERT INTO mti_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Meve Iesu asimeve yankweg ainewa, Parisi igiyawa ge Gwangwan toewanewan igiyawa mu amatog danapiripam gumbe waya, sira gae yabdapam gumbe singui ag wa ge wa aya. ");
INSERT INTO mti_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iesu gae divi da gwambe wapewa me auwatan oya amareme. ");
INSERT INTO mti_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pungi den wane, iyayapan obiren agonieme, meoya mu gara em eme. Meve Iesu amatog gae namu aigowawa gumbo wane, “Yaukapa, Parisi igiyawa iist muma gumbe. Me ugauga mumawa. ");
INSERT INTO mti_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Guwave barauyawa me matai undag taibe ape, sira guwave barauyawa iyayapan matai undag yaug anope. ");
INSERT INTO mti_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Sira ye divi arampuna guwave wayawa me eyawa matai anope. Sira ye pantut danave nauneyap mumumu wayanawa me matai gwe egave taibe ape. ");
INSERT INTO mti_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ne owanaiwa, ne diruitna. Iyayapan da mu kwapiwa tope boape, megara ivi oma den ane divi da ape. Meoya mu gumbo a den aya. ");
INSERT INTO mti_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Megara ne toyau yempna ye bira gumbe a aya. Me kwapiwa tope. Tope onanapeve ye at kukaeba geena danave aore empe me yusiwa aunewa gumbe a aya. E, ne ye diruitna. Me gumbe a aya. ");
INSERT INTO mti_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Nenip dirori naningambenit oya asarion duwam gumbe gwiruwareme. Mu desirom da God imiwa den atataivi. ");
INSERT INTO mti_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Natawa di. Ye kuiye gumawa undag basiyaivi. Meoya den a aigimiya; ye painauvit, nenip dirori ye mina onan. ");
INSERT INTO mti_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Meoya ne ye diruitna. Bira da iyayapan namuwo ne yaug ano nekpewa, Apan Usiwa me matai God aneya meuma namuwo me yaug ano nekpe ");
INSERT INTO mti_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Megara da bira iyayapan namuwo wape, ‘Ne me den yaug anona,’ me God aneya meuma namuwo wape, ‘Ne me den yaug anona.’ ");
INSERT INTO mti_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Sira da bira gae kukaeba Apan Usiwa gumbe wapewa, me matai anog yankwepe. Megara da bira gae di kukaeba Guwawa Iyakaisiyapama gumbe wapewa, me matai den anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Sinagogu, namuyoiyoi igiyawa sira iyayapan koukawa gumbo ye tamyem uwapewa, yembovit aninin amaratan oya go divi watanwa oya den anoya. ");
INSERT INTO mti_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kuiyawa Guwawa Iyakaisiyapama matai me kumiwa apa anin watanwa ye toyau yempe.” ");
INSERT INTO mti_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Apan da iyayapan agoniyayawa danave me gumbe wane, “Toewanewan, ne tatan diya. Dividivi undag maman kwenewa me tamnewa ne gaibu kebape.” ");
INSERT INTO mti_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iesu gara wane, “Keptete abnawa go ye yapave abnawa oya bira ne tum yunedne?” ");
INSERT INTO mti_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Meve mu gumbo wane, “Yaukape! Danewa nuniatatu undag oya yaukape. Amat yeuma yaimoyai aya. Kuiyawa apan inaiinai meuma me tawara meuma gaibu den wakene.” ");
INSERT INTO mti_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Sira me mu gumbo maibe mame wane: “Tawara abnawa nau meuma danave maura vinne. ");
INSERT INTO mti_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Me membovit imug anone, ‘Ne divi atna? Ne nakwai neuma tetanwa arawa den wakene.’ ");
INSERT INTO mti_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Meve me wane, ‘Ne mame atna. Ne gopad neuma yayatna sira mataiwa kokavit sitna. Sira me apa ne nakwai ge tawara neuma undag tam danave tetna. ");
INSERT INTO mti_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sira ne nembo gunap watna, “Guwanwa, tawara oraiwa obiren unaiwadna wakene. Bairawan obiren me gumbe wakeya. Danadawai den aviya, nakwai na, yoi na, sira degadega a.” ’ ");
INSERT INTO mti_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Megara God me gumbe wane, ‘Ge pimpangitana! Aram gare ge guwagwa gungap me atan aupe. Meve gembo genan waribiyanawa bira tampe?’ ");
INSERT INTO mti_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Bira da me tawara membo oya unaiwadne, megara me God namive tawara onan abnawa anewa, me maibe mame mina.” ");
INSERT INTO mti_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Meve Iesu aigowawa gumbo wane, “Meoya ne diruitna. Inaiinai yeuma oya nakwai divi nenewa, danadawai den anoya. Ye kwapuiwa oya ye divi enenewa danadawai den anoya. ");
INSERT INTO mti_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Inaiinai me koka nakwai me mina onan. Sira kwapiwa me koka, enwape me mina onan. ");
INSERT INTO mti_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nenip owau yaug anoya. Mu divi da den vereme, sira maura den tameme, sira mu nakwai pantut muma go buim muma onan. Megara God mu utamivi. Ye di oraimina, nenip ye mina onan. ");
INSERT INTO mti_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ye daneyep da bira danadawai aviviwa inaiinai meuma kusi yobutatae ape oma ane go onan? ");
INSERT INTO mti_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ye dividivi kusikaren mame oma den ane ayawa, divi oya dividivi upeba oya danadawai auya? ");
INSERT INTO mti_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ben iviwa riri yaug anoya. Me aninin yoivi. Mu nau da den wareme sira murap kusi da den diraueme. Megara ne ye diruitna. Soromon me dividivi oraiminawa undag danave wakene, sira wape eniviwa oraimina, megara ben mame oraiminavit di, Soromon wape eniviwa me mina onan. ");
INSERT INTO mti_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wayo piyu ega gare wakene go umae iyam danave aorepe. Megara God me wayo gumbe wape yaimoyai wanne. Meoya anintom God me yenan oya wape tu yempe? Ye anotumat yeuma kusikareren! ");
INSERT INTO mti_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sira ye nakwai divi natan ge yoi divi natan oya didimama wansin den anoigimiya, danadawai den avigimiya. ");
INSERT INTO mti_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Kuiyawa dividivi undag mame Ju onan igiyawa botan anoeme, go ye Mamewa yaug anone ye divi anoene. ");
INSERT INTO mti_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Meoya, namu Me toimuwawa ge ano oraivitwa meuma diuya, dividivi undag mame gaibu ye yempe. ");
INSERT INTO mti_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Agonagon kusi, a den aya. Ye Mamewa me God toimuwawa degadega gumbe yentan anoivi. ");
INSERT INTO mti_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ye dividivi yeuma iyayapan gumbo gwiruwariya, meve tawara onan igiyawa gumbo muniya. Yenan oya anmaga kokopetawa me den puwaiviwa ainamiya. Sira dividivi oraivitwa me matai den kukaipewa kwimin apa tam agoniya. Me apa ub abnawa me gumbe den ompe sira gwagwap den yoig wakukampe. ");
INSERT INTO mti_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kuiyawa dividivi oraiminavitwa yeuma wakeyawa arawa, me apa nonewa gaibu wakepe. ");
INSERT INTO mti_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Berip yeuma poveyep tuya, sira dun yeuma okeriya igigimpe. ");
INSERT INTO mti_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Apan kokawa muma memgebip nakwaeba apa taig uwag ankwin papapak topewa, oma ane ankwin tatevit menan wataptan oya amareme igiyawa mina ye meib wakeya. ");
INSERT INTO mti_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Apan kokawa muma me matai uwape kumiwa, nau wareme igiyawa me aniyau uwapewa yangut aigimpewa me yawampewa me oraimina. Ne natawa diruiyeni. Apan kokawa me matai waita muntanwa oya berip meuma powave tupe, sira nau wareme igiyawa tampe teboro apa yan wakepe munan oya amarape. ");
INSERT INTO mti_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kokawa muma me nup bagiwa go mumbevit at muniwa gumbe taig uwape, sira nau wareme igiyawa mu wait waribiyag amareme me yawampewa, me oraiwa munanwa oya. ");
INSERT INTO mti_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Megara mame yaiyai yaug anoya: Gwe abnawa aram kumiwa divi ub usiwa ompe yaug anonewa, me yaukapa wakepe sira gwe meuma den toyayag ub ape. ");
INSERT INTO mti_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ye gaibu anoka wakeya, kuiyawa ye den menan amaraigimiyawa Apan Usiwa uwape.” ");
INSERT INTO mti_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita singui wane, “Ayapan, ge maibe mame nu gunup vege, go iyayapan undag gumbo vege?” ");
INSERT INTO mti_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ayapan gara wane, “Kokawa me nau meuma eme igiyawa amara muntan oya, sira nakwai kumiwa apa nakwai muntan oya amaraivi abnawa baraune. Amaraivi abnawa me anotumat meuma koka sira anoano meuma oraivit gumbe, gare me bira? ");
INSERT INTO mti_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kokawa meuma matai taig uwape sira amat abnawa me nau warigimpe yaupewa, menan oraimina ape. ");
INSERT INTO mti_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne natawa diruitna. Kokawa matai dividivi meuma undag amaraivi abnawa wampe me amarape. ");
INSERT INTO mti_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Megara nau meuma wariviwa abnawa membovit danave anope, ‘Ne kokawa neuma uwatan oya kumiwa me tate den uwape,’ meve me amatog apan ge vesin nau meuma waremewa igiyawa gurigimpe sira nakwai ge yoi nak pimpanoigimpe. ");
INSERT INTO mti_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Amaraivi abnawa me den amaraivi kumiwa apa, me den yaug anoivi kum koniwa apa kokawa meuma uwape. Kokawa meuma matai me gattope musimusi ape, sira anotumat den emewa igiyawa gaibu baraupe wakepe. ");
INSERT INTO mti_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nau meuma wariviwa abnawa me kokawa meuma anoiviwa yaug anone. Megara den waribiyag amaraigimpewa, sira kokawa meuma wanewa den apewa, me kokawa meuma koni obiren me tope. ");
INSERT INTO mti_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Megara da bira den yaug anone, meoya kukaeba meuma aiviwa, me kusi tope. Bira da kokavit aunewa me kokavit autan kinuni ape. Sira bira da me gumbe kokavit baraunewa, me kokavit autan kinuni ape. ");
INSERT INTO mti_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ne iyam piyu gerave aoretan oya uwana. Aninin ne yusipamit anoeni iyam wait igivi. ");
INSERT INTO mti_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Megara ne babataito neuma wakene me avitan oya eni. Sira danadawai kokavit ne aug anegimpna undag meve onanapeve. ");
INSERT INTO mti_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ye anoene ne piyu egave yum aug uwana? Ne diruitna. Onan, ne mut ge ano ubeube oya uwana. ");
INSERT INTO mti_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mame apa utan aib ainewa, me apa inamamawa usitainawa desiroma danave naningambenit wakepewa, duwamdesi me duwam gumbo daietaitai ape, sira duwam me duwamdesi gumbo daietaitai ape. ");
INSERT INTO mti_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mamawa me usiwa gumbe daietaitai ape. Usiwa me mamawa gumbe daietaitai ape. Inawa me gwaitawa gumbe daietaitai ape. Gwaitawa me inawa gumbe daietaitai ape. Inawa wainiwa gumbe daietaitai ape. Wainiwa me inawa gumbe daietaitai ape.” ");
INSERT INTO mti_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Me iyayapan agoniyayawa gumbo wane, “Ye yauya at kum aigiviwa apa guwaveru dauwag barauvigimpewa, ye tate waya, ‘Me uvin uwatan aivi,’ meve uvin uwape. ");
INSERT INTO mti_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sira at gambenwa sausu apa taig man toigimpewa, ye waya, ‘Me amiwatan aivi,’ meve amiwape. ");
INSERT INTO mti_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ugauga eme igiyawa! Piyu ge kwimin irawa me aninin, ye yaug anoyana di. Kum mame garewa ye aninin den yaug anoyana? ");
INSERT INTO mti_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Divi oya ye yembo divi oraiwa den yaug anoyana? ");
INSERT INTO mti_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ge anavi geuma gaibu kukaeba wasiwamtan abnawa oya aisenewa, ebu taibe yusiyusi ake baigan me gumbe ag yum tua. Meib den awa me ge augen gempe keptete abnawa gumbe uwaya. Sira keptete abnawa me augempe nog amaraiviwa nanive. Nog amaraiviwa me nog danave aoregempe aiga. ");
INSERT INTO mti_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ne ge dirukna. Ge nog danave den taibe dauwag aga. Anmaga kusi reputa oieba ge garawa ape, meve taibe dauwag aga.” ");
INSERT INTO mti_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Me kumive iyayapan upeba uwag Iesu gumbe waya. Gariri igiyawa diyawa ge puyo maeba mumawa Pairat bidwag ane. ");
INSERT INTO mti_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iesu garawa wane, “Gariri igiyawa mu danadawai mamaib auyawa, me kuiyawa kukaeba muma kokavit sira Gariri igiyawa upeba undag kukaeba muma kusi meib ye anoene? ");
INSERT INTO mti_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne ye diruitna. Onan di! Megara ye nonemagewa den biroriyaya ipewa, ye mina undag matai boriruwaya. ");
INSERT INTO mti_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sairoam apa gwe airan gerowo aignewa, iyayapan 18 boriruwaya. Megara mu kukaeba muma kokavit, sira iyayapan upeba undag mu Jerusarem apa wakeyawa mu kukaeba muma kusikaren meib ye anoene? ");
INSERT INTO mti_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ne ye diruitna. Onan di! Megara ye nonemagewa den biroriyaya ipewa, ye mina undag matai boriruwaya.” ");
INSERT INTO mti_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Meve Iesu maibe mame dirumne: “Apan da yoma greip nauwawa danave vedne, sira me magawa yautan aine, megara da den yaune. ");
INSERT INTO mti_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Meoya apan me greip nauwawa amaraiviwa gumbe wane, ‘Ne yoma magawa yautan oya onedna, megara yoma magawa da den yauna, sira gare bairawan duwamdesi onanane. Me kwap aoreya! Divi oya piyu ingui nau aivi?’ ");
INSERT INTO mti_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Apan garawa wane, ‘Apan kokawa, yankweya, bairawan desirom sira wakepe. Ne kuiyave mutat sig um yautnave. ");
INSERT INTO mti_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Me bairawan umaewa magawa impewa, me oraimina! Onan ipewa, meve kwap aoreya.’” ");
INSERT INTO mti_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat Kumiwa apa, Iesu sinagogu danave toyau munivi. ");
INSERT INTO mti_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Sira vesin da me apa wakene. Me guwawa gumbe daiyewa gegeraine, bairawan 18 onanane. Me oma den ane siwavit wan yoine. ");
INSERT INTO mti_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iesu vesin me yaune auwane sira me gumbe wane, “Vesin, ge inaigitana yuwat geuma gumbe.” ");
INSERT INTO mti_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Meve me naniwa me gumbe baraune, tatevit siwavit ane. Vesin me God waragadne. ");
INSERT INTO mti_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sinagogu namuyoiyoi igiyawa ano kukam ane. Kuiyawa Iesu Sabat Kumiwa apa warinamne oya. Sira iyayapan gumbo wane, “Oiyat 6 me nau apewa me bainda. Meoya kum me danave onag warinama, megara Sabat Kumiwa apa bainda onan.” ");
INSERT INTO mti_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Megara Ayapan garawa me gumbe wane, “Ye ugauga eme igiyawa! Ye da Sabat Kumiwa apa burumakau yeuma go mae donki yeuma mae gweyawa apa murap vet yoi muntan oya tam dauwag aisiene, go onan? ");
INSERT INTO mti_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Vesin mame me Ebraam gwaitawa. Seitan me yumnadne wakene, bairawan yobutaren 18 onanane. Sira Sabat Kumiwa apa me yumnadne wakenewa yankwene, sira vesin yai wakene. Divi oya me oraimina onan?” ");
INSERT INTO mti_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iesu mame wanewa, me anavi meuma undag ubmam waramiya. Iyayapan mu dividivi oraimina undag me anewa gumbe degadega aya. ");
INSERT INTO mti_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Meve Iesu singui munne, “God toimuwawa me divi mina? Divi gumbe omaomaeba om wattna? ");
INSERT INTO mti_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Me gayum yawa mina. Me apan tamne sira nau meuma danave vedne. Me yaig yoine yoma ane, sira painau nenipawa uwag naninaniwa gumbe en wariya.” ");
INSERT INTO mti_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sira singui munne, “Divi gumbe God toimuwawa omaomaeba om wattna? ");
INSERT INTO mti_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Me iist mina. Vesin da me aug parawa me 3 satas danave bidwag ag kamasiyanewa, parawa tan koka ane.” ");
INSERT INTO mti_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Meve Jerusarem oya aiviwa Iesu at kokawa ge gwetoim danave aine iyayapan toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Apan da me gumbe singui wane, “Ayapan, iyayapan duwamit mukut waita autan eme?” Me mu gumbo wane, ");
INSERT INTO mti_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Yusiyusi aya ankwin popotuwa gumbe unigiya. Ne ye diruitna. Kuiyawa iyayapan obiren matai uniktan oya yusiyusi ape, megara obiren oma den ane unikpe. ");
INSERT INTO mti_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gwe abnawa me wan yoipe sira ankwin tobotpewa, ye matai daieve yokeya yembovit ankwin papapak toya vene, ‘Apan, ankwin nunan watapa.’ Megara me garawa wape, ‘Ne ye den yaug anoyemna ye ampa oniyana.’ ");
INSERT INTO mti_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Meve ye matai waya, ‘Nu nakwai ge yoi ge gaibu natu, sira ge nu ebu numa kokawa apa toyau nunana.’ ");
INSERT INTO mti_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Megara gara wape, ‘Ne ye den yauyem anona. Ye ampa uwayana den yaug anona. Ye undag kukaeba enewa igiyawa ne gunap asipa aisiya.’ ");
INSERT INTO mti_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ebraam, Aisak, Jekob ge propeta undag mu God toimuwawa danave wakeya, megara God me ye yembovit daieve tam emeyempewa, sira asimeve ye it ge donewa kitosai aigimiya. ");
INSERT INTO mti_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iyayapan kum dauwaiviwa apa ge kum aigiviwa apa, sira noosu ge sausu apa uwag God toimuwawa danave buyunai apa wakepe. ");
INSERT INTO mti_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Me natawa, iyayapan obiren namu yoiemewa mu ivi ape, sira ivi yoiemewa mu namu ape.” ");
INSERT INTO mti_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Me kumiwa apa, Parisi igiyawa upeba Iesu gumbe uwag waya, “At mame yankweg at da ube aga. Erod ge toaktan oya aivi.” ");
INSERT INTO mti_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Iesu gara wane, “Aiseg mae okusi asime diya, ‘Ne gare umaewa airapu atatai impna, sira iyayapan warinamuntna, sira kum duwamdesiyawa ne nau oieba wat wapukiyatna. ");
INSERT INTO mti_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Megara ne garewa umaewa maimawa di anegimpna. Kuiyawa propeta me Jerusarem daieve den boape.’ ");
INSERT INTO mti_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","A, Jerusarem Jerusarem. Ye propeta guriyana sira yenan tena onamiyawa an gumbe guriyana. Kum koniwa anintom mina ne utuntainanwa yenan anog agoniyag tena. Kumkum inawa usitainawa agoniyag maviwa ankwatave tepewa mina, megara ye den anoene. ");
INSERT INTO mti_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yauya, ye gwe yeuma me kukaig wakepe. Ne ye diruitna, namu ye waya, ‘Apan me Ayapan iviwa gumbe uwapewa me gumbe waribiya wampe.’ Ivi ye ne sira yaunegiya.” ");
INSERT INTO mti_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat Kumiwa da, Iesu Parisi namu yoiyoi aiviwa me gweyave nakwai natan oya aine. Sira mu me iyaiyai yangowo yaveme. ");
INSERT INTO mti_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Me apa me namive apan me kwapiwa tantamusiawa aunewa wakene. ");
INSERT INTO mti_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iesu Parisi ge Gwangwan anoano kokawa igiyawa gumbo singui munne, “Me Gwangwan wakene, warinamtanwa Sabat Kumiwa apa gaibu go onan?” ");
INSERT INTO mti_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Megara mu iyadmusia. Meoya Iesu apan yumne, sira me warinamne, sira me baraune aine. ");
INSERT INTO mti_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Meve Iesu singui munne, “Ye da ud go burumakau me Sabat Kumiwa apa yoi oya dukup danave aikpe ipewa, ye matai me tatevit den ororeak taibe dauwape?” ");
INSERT INTO mti_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mu gae garawa da den waya. ");
INSERT INTO mti_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Amdau igiyawa teboro apa painau waketan anoemewa me yaug anonewa, maibe mame gumbe dirumne. ");
INSERT INTO mti_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Iyayapan da memgebip buyunaeba oya genan ep tepewa, ayapan arawa den wakeya. Kuiyawa apan kokawa ge minag onan, menan ep baraupe ipewa, me at mame aupe. ");
INSERT INTO mti_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Buyunai abnawa me ep duwam yenan tenewa me gungap uwag wape, ‘Apan mame at geuma wana.’ Me kumive apa, ge ubmam waratpe, sira ge at ankwatavewa auwa. ");
INSERT INTO mti_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Megara ep genan teyawa, at ankwatavewa auwa. Ge me auwa ipewa, buyunai tamnewa uwape matai ge gungap wape, ‘Evenwa, at oraiwa aga.’ Meve iyayapan geuma waya uwayawa undag namuwo apa matai gungap petat tope. ");
INSERT INTO mti_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Kuiyawa da bira membovit painau apewa me mokona ape, sira da bira membovit mokona apewa me matai painau ape.” ");
INSERT INTO mti_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Meve Iesu buyunai tamnewa gumbe wane, “Ge kum kuiyunup nakwaeba go aram nakwaeba munawa, owogwa ge tatagaiwa ge dam desiroma ge iyayapan tawara obirenwa igiyawa munanwa oya ep den teya. Ge meib awa ipewa, mu matai genan ep tepe, sira me gumbe ge garawa agempe. ");
INSERT INTO mti_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Megara ge buyunai munawa, tawara onan igiyawa, ui kwapiwa kukaimusiawa ge amowa kukaimusiawa sira yangabored igiyawa oya munan ep teya. ");
INSERT INTO mti_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mu oma den ane ge garawa agempe, meoya ge gungap waribiya wakeigimpe! Kuiyawa oraiwa igiyawa sira yoigimpewa kumiwa apa, ge matai garawa gempe.” ");
INSERT INTO mti_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Mu da teboro apa Iesu gaibu wakeyawa mame anonewa, Iesu gumbe wane, “Apan me waribiyane, me God toimuwawa danave buyunai nape.” ");
INSERT INTO mti_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iesu garawa wane, “Apan da buyunai kokawa tamibarip ane sira iyayapan obiren munan ep tene. ");
INSERT INTO mti_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Buyunai kumiwa apa, me nau meuma aivi abnawa baraune aine. Iyayapan munan ep tenewa dirumtan oya aine, ‘Oneya, kuiyawa gare mame dividivi undag wait tamibarip atu onanane.’ ");
INSERT INTO mti_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Megara mu undag minamina topai aya. Namuwa wane, ‘Ne at piyu gwiruwadna, aneg yautanit di. Garawapa nenan den anoa.’ ");
INSERT INTO mti_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Dawa wane, ‘Ne gare di burumakau yoma gumbe duwam duwam kwadnat tutanwa me naningambenit gwiruwadna, ne tug ageyau atna meoya angeni. Garawapa nenan den anoa.’ ");
INSERT INTO mti_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mina dawa wane, ‘Ne gare di memgebip ana, meoya oma den ane onekna.’ ");
INSERT INTO mti_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nau meuma aivi abnawa taig onne, sira umum mame kokawa meuma gumbe wane. Meve gwe abnawa danawa piriwane, sira nauwawa wariviwa dine, ‘Tatevit gwetoimu kokawa dana ebu taiba ge ebu kusikusiwa dauwag aga, sira tawara onan igiyawa ge ui kwapiwa kukaimusiawa, yangabored sira amowa kukaimusiawa tam onaga.’ ");
INSERT INTO mti_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nau meuma aivi abnawa wane, ‘Apan, ge wanawa nu wait atu, megara pantut danave at ande wakene.’ ");
INSERT INTO mti_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Meve kokawa meuma nau meuma aivi abnawa dine, ‘Ne gwe neuma noidauwatan oya, at ebu taiba ge ben veriyawa apa dauwag aga, sira mu diruma unig onampe. ");
INSERT INTO mti_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne ye diruitna, iyayapan danowo desirom da ep munan tenawa matai buyunai neuma demtawa da den aupe.’” ");
INSERT INTO mti_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iyayapan obiren Iesu gaibu amome, sira mu gumbo tobiyag wane, ");
INSERT INTO mti_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bira da nenan ontan apewa, inamamawa, biviwa ge usitainawa, tatawaiwa ge yogiyawaiwa den topaimumpewa, sira membo inaiinai meumawa gaibu den topayapewa, me oma den ane ne aigowanwa ape. ");
INSERT INTO mti_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sira bira da me korosi meuma aug amanap den onigimpewa me oma den ane ne aigowanwa ape. ");
INSERT INTO mti_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ye daneyap bira da gwe painau da sitan anopewa, me namu yanwakek yaug anokape anmaga me gumbe oma ape sipe go onan. ");
INSERT INTO mti_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kuiyawa me sitan ebuebuwawa tepe sira oma den ane onanape ipewa, iyayapan me yaupewa matai iyagau wampe. ");
INSERT INTO mti_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mu wape, ‘Apan mame amatog gwe sine, megara oma den ane si botpe.’ ");
INSERT INTO mti_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kin da me kin dawa gaibu mut atan ape ipewa, kin da me namu yanwakeg ebuebuwawa yaug anokape. Kin dawa mut igiyawa 20,000 tamke oniviwa, me mut igiyawa 10,000 tam mu enbotpe mut ape oma ape go onan. ");
INSERT INTO mti_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kin da oma den ape ipewa, kin dawa arama matai oniviwa me umum igiyawa tepe ampe, yumtutu gaiyawa wape. ");
INSERT INTO mti_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ebu me desirom, ye daneyap bira da tawara meuma undag den topayapewa me oma den ane ne aigowanwa ape. ");
INSERT INTO mti_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Siuran me oraimina, megara me demtawa meuma onanape ipewa, me aninin ape sisiwa sira ape? ");
INSERT INTO mti_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Me piyu oya sira mutat agoniemewa oya divi da den ape. Me epa aore eme. Da bira naunawa gaibu ipewa, me kweya anope.” ");
INSERT INTO mti_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gare takesi tameme igiyawa ge kukaeba eme igiyawa undag Iesu gumbe gaiyawa anotan oya agoniyaya. ");
INSERT INTO mti_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Megara Parisi igiyawa ge Gwangwan toewanewan igiyawa mu simura weme, “Apan mame me kukaeba emewa engaun aivi sira nakwai mu gaibu naivi.” ");
INSERT INTO mti_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Meve Iesu maibe mame mu gumbo wane. ");
INSERT INTO mti_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ye daneyap da bira sip 100 gaibu wakene, desirom da mu danowo kwawape ipewa, me 99 taibe yankwem sip kwawanewa yautan oya diupe? ");
INSERT INTO mti_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sira me yaupewa, me degadegaepam me auke oieve barauk, ");
INSERT INTO mti_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","aig gwe uwape. Meve me owowaiwa sira iyayapan meuma munan auwag agoniyape, mu gumbo wape, ‘Ne gaibu degadega ata. Ne sip neuma kwawanewa sira yauna.’ ");
INSERT INTO mti_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne diruitna. Ebu me desiroma, kukaeba abnawa desirom me nonemagawa biroriyape ipewa, kwimin apa degadega kokavit. Iyayapan oraivitwa 99 mu nonemagowa biroriyatan den anoemewa oya kwimin apa degadega wakene, megara degadega me mina onan. ");
INSERT INTO mti_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Vesin da anmaga siruva naninwanit gumbe wakene. Sira me desirom waropiyape ipewa, me dun oketpe, gwe eremui aiyape, didimama yaimoyai aiginkape yaupe, go onan? ");
INSERT INTO mti_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Me yaupewa, me owowaiwa sira iyayapan meuma munan auwag agoniyape mu gumbo wape, ‘Ne gaibu degadega ata. Ne anmaga neuma waropiyanawa sira yauna.’ ");
INSERT INTO mti_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ebu me desiroma, ne ye diruitna, kukaeba abnawa desirom nonemagawa biroriyape ipewa, God aneya namive degadega kokavit.” ");
INSERT INTO mti_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iesu gae meuma yunadne. “Apan da me usiwa duwam. ");
INSERT INTO mti_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gwaneba mamawa gumbe wane, ‘Maman, kwan geuma undag me gambenwa nega.’ Meoya me tawara meuma buwangave kepteg wanne. ");
INSERT INTO mti_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Me ivi pungi den wane, gwaneba dividivi undag tam agoniyane at aramawa da aine. Sira me apa irobabai ane wakewake meuma kukaine, tawara meuma undag wakukamne onanane. ");
INSERT INTO mti_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Namu me tawara meuma undag wakukamne onananewa, at me apa undag kait kokawa uwag onne. Me amatog danadawai aune. ");
INSERT INTO mti_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Meoya me at me abnawa oya aine. Sira at abnawa me aug baraune nau aig bui meuma amaraivi. ");
INSERT INTO mti_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Diwat me bui nemewa me napa danawa bimwapa oya me anog imututu ane. Megara bira da divi da den di wanne. ");
INSERT INTO mti_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Me wakene imiwa sira taig onnewa, me wane, ‘Iyayapan obiren maman tamnewa nakwai obiren neme sira obiren ande mu gumbo wakeya, ne iyagon adnegivi, boatan eni. ");
INSERT INTO mti_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ne maman oya sira taig anekna, me gumbe watna, “Maman, ne ge gungap sira kwimin gumbe inaiinai kukaeba ana. ");
INSERT INTO mti_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ne oraimina onan, meoya ne ge utugwa sira den wa. Aunega iyayapan nauwagwa emewa igiyawa mina da atna.” ’ ");
INSERT INTO mti_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Meve wan yoine sira mamawa oya aine. Megara me ebu taibe aramavit ande oniviwa, mamawa me yaune, danadawai koka menan aune. Me usiwa oya kintog aine, me nanive yum uwatone. ");
INSERT INTO mti_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Usiwa me gumbe wane, ‘Maman, ne ge gungap sira kwimin gumbe inaiinai kukaeba ana. Ne oraimina onan, meoya ne ge utugwa sira den wa.’ ");
INSERT INTO mti_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Megara mamawa nau meuma eme igiyawa gumbo wane, ‘Tatevit! Wape yobutarenwa oraivitwa aug oneya, sira me enwaniya. Kwit nanigiriwa oya aug oneg enwaniya, sira sandoro tam oneg amawa enwaniya. ");
INSERT INTO mti_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mae burumakau apanbarawa kadnapama aug oneg toenguriya. Buyunaeba ag degadegaeba ata. ");
INSERT INTO mti_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kuiyawa utunwa mame botone sira inaine. Me inanadne sira me yauna.’ Meoya mu amatog degadega aya. ");
INSERT INTO mti_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Me emewa, tatawa me nau danave. Me gwe megiyave uwanewa, me inau bererin ge tare noiwa anone. ");
INSERT INTO mti_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Meoya mamawa nauwawa eme igiyawa da menan auwane onne, sira me singui ane ye dimbae ene. ");
INSERT INTO mti_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Me garawa wane, ‘Ge gwanek sira taig uwane, mamag burumakau apanbarawa kadnapam toengudne, kuiyawa me oraivit bainda di taig uwane.’ ");
INSERT INTO mti_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tatawa danawa piriwane sira danave unig aitan oya topayane. Meoya mamawa dauwag aine sira me gumbe gae wak memeyamne. ");
INSERT INTO mti_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Megara me mamawa gumbe garawa wane, ‘Yawa! Bairawan obiren mame onananewa ne genan nau eni. Sira ge gwangwan geumawa da den di topayana. Megara ne evenwainwa gaibu degadega atan oya, ge mae goot da den di negana. ");
INSERT INTO mti_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Megara utugwa mame vesin gaibu nag vin gigin tawara geuma wakukamne, sira gwe taig uwanewa, ge burumakau apanbarawa kadnapam menan toengurana!’ ");
INSERT INTO mti_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Mamawa wane, ‘Ud neumawa, ge kum evedni ne gaibu wakeete, sira dividivi undag neumawa me geumawa. ");
INSERT INTO mti_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kuiyawa gwaneg mame me boane, megara sira inaine. Me inanadne, megara sira yautu. Meoya nu di buyunai ag degadega atanit di.’” ");
INSERT INTO mti_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iesu aigowawa dirumne. “Tawara abnawa da me amaraivi abnawa da aune. Sira amaraivi abnawa me tawara abnawa tawara meuma wakukamivine oya diyag waya. ");
INSERT INTO mti_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Meoya me menan wane unig onne singui ane, ‘Ne genan oya mame anona, me divi? Ge oma den ane sira amaratanwa aigima, meoya nau geuma egewa umumawa didnega.’ ");
INSERT INTO mti_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Amaraivi abnawa membovit gumbe wane, ‘Gare ne aninin atna? Kokawa neuma me nau neuma atan avivi. Ne yutunwa oma den ane dukup watna, sira nun watan oya ubmam wadnegivi. ");
INSERT INTO mti_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ne yaug anona divi atna. Me gumbe nau neuma mame apa waropiyatnawa, iyayapan matai gwe muma gumbe auneg kaiwa wape.’ ");
INSERT INTO mti_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Meoya me kokawa meuma gumbe anmagawa ingui tamiyawa me desirom desirom auwane. Me namuiren abnawa singui ane, ‘Ge anintom kokawa gumbe iyai auwana?’ ");
INSERT INTO mti_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Me garawa wane, ‘Oira meuma 100 bate.’ Amaraivi abnawa me dine, ‘Ingui auwanawa gigirum auwa, tatevit yanwakeg tonkuiya 50 ape.’ ");
INSERT INTO mti_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Meve me apan duwameba gumbe singui ane, ‘Ge anintom ingui auwana?’ Me garawa wane, ‘Parawa 100 koru.’ Me gumbe dine, ‘Ingui auwanawa gigirum geuma auwa, sira tonkuiya 80 ape.’ ");
INSERT INTO mti_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kokawa meuma me natawa den aivi amaraivi abnawa gumbe nau meuma oraivit ane oya wane. Kuiyawa me anewa membo oya di ano ag ane. Piyu mame igiyawa mumbo oraiwa muma oya ano ag eme, megara eyawa igiyawa mu mina onan. ");
INSERT INTO mti_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne ye diruitna. Ye piyu tawara meuma oraiwa tam yembovit oya oveaiwa danowa auya, me gumbe me onanapewa, yaibobot gweyawa danave ye matai kaiwa kaiwa aiempe. ");
INSERT INTO mti_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bira da dividivi kusikarenwa gumbe owaniyapewa, sira me dividivi kokavitwa gumbe me mina owaniyape. Bira da dividivi kusikarenwa gumbe den owaniyapewa, sira dividivi kokavitwa gumbe me mina den owaniyape. ");
INSERT INTO mti_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Meoya ye piyu tawara oraiwa meuma gumbe den owaniyayawa, bira tawara natapama gumbe owanowan ye guniyap ape? ");
INSERT INTO mti_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Sira ye apan da tawara meumawa gumbe owanowan den ayawa ipewa, guniyap den owaniyemtawa ipewa, bira tawara yeuma yempe? ");
INSERT INTO mti_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bira da nau wariviwa oma den ane apan koka duwam gumbo nau muma ape. Me apan koka da topayape, dawa wat baigan awampe, sira me dawa wan enagatpe, dawa topayape. Ge oma den ane God ge anmaga nauwawa duwam wara.” ");
INSERT INTO mti_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi igiyawa anmaga oya anoemewa undag mame anoya, sira aenaen Iesu gumbe eme. ");
INSERT INTO mti_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iesu mu gumbo wane, “Iyayapan yangowo ye yembovit oraivitwa oya ene, megara God nonenmagewa yeuma yaug anone. Iyayapan gumbo ayamat kokavit anoemewa mu God yangave den ewaniyane. ");
INSERT INTO mti_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gwangwan ge Propeta mu namuwa waya sira Jon gumbe onanane. Me kumiwa apa man onne, gae oraiwa God toimuwawa oya opata veme, sira iyayapan undag ayamuneme ebu me danave unikpe. ");
INSERT INTO mti_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kwimin ge piyu inanatanwa me bembemu. Megara Gwangwan gigirum danave tenewa koni desirom dauwag aikpewa me yaigiwa dadi. ");
INSERT INTO mti_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bira da biviwa yankwepe sira vesin da ube aupewa, me uinantaraki. Sira apan da vesin memawa yankwenewa me aupewa me uinantaraki.” ");
INSERT INTO mti_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tawara abnawa me wape gamat pundirit ge diyapam yapavewa enivi, wape rinen oraiminawa enamivi, maura gumbe kum evedni vinivine. ");
INSERT INTO mti_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Me ankwin noive, apan nun abnawa iviwa Rasaros me kwapiwa sisipopot obiren tamnewa wakene. ");
INSERT INTO mti_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Sira divi tawara abnawa teboro meuma gumbe musimusi aigiviwa natan oya anoivine. Kweyau gaibu uwag sisipopot meuma dimui eme. ");
INSERT INTO mti_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kum uwanewa nun abnawa botone, sira aneya mu aug Ebraam wakenewa oya amiya. Sira tawara abnawa mina boane, sira yanpot apa barauya. ");
INSERT INTO mti_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ades danave me dawai avivi, yangut anewa, Ebraam at painauvit Rasaros gaibu wakene yaune. ");
INSERT INTO mti_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Meoya me gumbe auwane, ‘Maman Ebraam, ano nunigima, Rasaros barauwa ompe, naniwa yoi danave empe sira pednanwa empe taigiwape, kuiyawa ne iyam danave edawai gumbe wakeeni.’ ");
INSERT INTO mti_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Megara Ebraam garawa wane, ‘Ud, imug anoa. Wait inaiinai geuma kumiwa apa ge dividivi oraiwa tamana. Me kumive Rasaros dividivi kukaeba tamne. Megara gare me oraivit amat awaniya sira ge edawai gumbe wakeyana. ");
INSERT INTO mti_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Undag mame wakeya sira upeba wakeya, nu ge ye bunangave me karirin koka wakene, meoya iyayapan bira imuwo mame apa genan onantanwa oma den ane, sira oma den ane da bira yan me apa nunan dauwag onampe.’ ");
INSERT INTO mti_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Me garawa wane, ‘Maman, gare ne nun gungap veni. Rasaros barauwa me maman gweyawa aipe. ");
INSERT INTO mti_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kuiyawa ne tatanaiwa naningambenit wakeya. Gwangwan dirumpe, me gumbe mu mina at mame edawai arawa den onampe.’ ");
INSERT INTO mti_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ebraam garawa wane, ‘Mu Mosisi ge Propeta gumbo wakeya, yankwema mu gumbo anope.’ ");
INSERT INTO mti_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Me wane, ‘Onan, maman Ebraam, iyayapan da boriruwayawa apa munan aipe ipewa, mu matai nonenmagowa biroriyape.’ ");
INSERT INTO mti_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Me me gumbe wane, ‘Mu Mosisi ge Propeta gumbo den anope ipewa, apan da boriruwayawa apa sira inaipewa, mu matai nouwa den aupe.’” ");
INSERT INTO mti_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iesu aigowawa gumbo wane, “Dividivi me iyayapan wakukampe kukaeba apewa uwatan aivi. Megara apan me me gumbe mu wakukampe kukaeba apewa me di kukaine. ");
INSERT INTO mti_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Bira da ape ud kusi mame desirom da kukaeba apewa, an kokawa me parawa waremewa me meyave tug poeman danave aorepe none nape, me me oya me bainda. ");
INSERT INTO mti_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yembovit yaukape. Tatagwa go gwanegwa kukaeba ape ipewa, gae yaigipam diya anope sira nonemagawa biroriyape ipewa, kukaeba meuma oya anog yankweya. ");
INSERT INTO mti_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Me kukaeba ge gungap kum desirom danave koni 7 ape ipewa, sira me koni 7 taig on ge gungap uwag, ‘Ne nonenmagawa biroriyana.’ meib wapewa, me anog yankweya.” ");
INSERT INTO mti_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aigowawa mu Ayapan gumbe waya, “Anotumat numa a koka ape!” ");
INSERT INTO mti_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Me garawa wane, “Ye anotumat yeuma me gayum yawa kusi mame mina apewa, ye yoma iviwa maruberi mame gumbe waya, ‘Kuiyapam biyau poeman danave yaig wakeya.’ Sira me ye noiwa matai aupe. ");
INSERT INTO mti_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Bira da daneyap nau abnawa da wakene me piyu siviwa go sip amaraivi. Wanan me nau apa taig ompewa, me nau meuma wariviwa gumbe wape, ‘Gare mame onaga, sira yanwakeg nakwai na,’ meib nau abnawa dipe go onan? ");
INSERT INTO mti_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Me aib watanwa da onan, ‘Aram nakwaeba natanwa oya tamibarip a. Gembovit tamibarip ag nenan amara ne nakwai ge yoi naigimpna. Meve ge nakwai ge yoi na.’ ");
INSERT INTO mti_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Me anin wanewa me anewa oya, me nau wariviwa abnawa gumbe gaun wape? ");
INSERT INTO mti_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Meoya ye mina, ye dividivi ayawa ye diruiyawa gumbe ayana, ye aib watanwa, ‘Nu nau geuma waretewa nu oraimina onan. Nu nau numawa di atu.’” ");
INSERT INTO mti_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Gare ebu taibe Jerusarem oya Iesu aivi, me Samaria ge Gariri yumateba apa a yoig guidne. ");
INSERT INTO mti_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Me gwetoimu da danave uwanewa, yuwat warumamne iviwa reprosi igiyawa 10 me nuntosa munne. Mu kusi painau yokeya. ");
INSERT INTO mti_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Sira mu kwat kokavit waya, “Iesu, Kokawa, ano nunigima!” ");
INSERT INTO mti_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Me mu yawamnewa wane, “Aisiya, yembovit pirisi gumbe toyau waniya.” Mu amomewa, mu muinamne. ");
INSERT INTO mti_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Desirom mu danowo me yaune me wait inainewa, me noiwa kokavit God gumbe waiya waiya wag sira taig onne. ");
INSERT INTO mti_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Me membovit Iesu amave aigne, sira me gumbe gaun wane. Me Samaria apan. ");
INSERT INTO mti_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iesu singui wane, “Apan undag naninwanit den muinamna? Upeba 9 ampa wakeya? ");
INSERT INTO mti_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","God gumbe kaiwa kaiwa watan oya taig onnewa, apan noi ubewa, mame mekut? Da bira onan?” ");
INSERT INTO mti_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Meve Iesu me gumbe wane, “Yoiya sira aga. Anotumat geuma gumbe ugwa oraimina ane.” ");
INSERT INTO mti_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi igiyawa Iesu gumbe kum divi God toimuwawa uwapewa oya singui ayawa, me garawa wane, “God toimuwawa uwapewa matai oma den ane yauta. ");
INSERT INTO mti_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Go iyayapan matai wape, ‘Mame me,’ go ‘Itame me,’ kuiyawa God toimuwawa me ye imui daneyap.” ");
INSERT INTO mti_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Meve me aigowawa gumbo wane, “Ye imuyep kum da Apan Usiwa uwape yautanwa oya anoenewa, megara ye oma den ane yauya, me kumiwa matai onivi. ");
INSERT INTO mti_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iyayapan matai ye guniyap wape, ‘Itame me!’ go, ‘Mame me!’ Mu amowo den kintog gigimiya. ");
INSERT INTO mti_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kuiyawa Apan Usiwa kumiwa apa, me kapisi mina ape, me kwimin yunadnewa apa merampe esipe aipe kwimin gambenwa yunadnewa apa. ");
INSERT INTO mti_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Megara me namu dividivi obiren gumbe danadawai di aukape, sira iyayapan kum garewa topayape. ");
INSERT INTO mti_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Me gare di apan Noa kumiwa apa anewa mina. Sira Apan Usiwa kumiwa matai me mina di. ");
INSERT INTO mti_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iyayapan nakwai ge yoi neme, apan vesin avivi, vesin apan avivi, me mina mu memgebip eme, meve kum aune apan Noa wa koka danave unigne. Meve nin uwane, sira mu undag nin umamne. ");
INSERT INTO mti_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Apan Rot kumiwa apa me mina meib. Iyayapan nakwai yoi neme, gwit garawareme, vereme sira gwe sieme. ");
INSERT INTO mti_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Megara Rot me Sodom kweg ainewa kumiwa apa, iyam ge sarupa kwimin apa aigne, sira mu undag iyam meru igamne. ");
INSERT INTO mti_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Apan Usiwa sira uwape kumiwa me meib di. ");
INSERT INTO mti_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Me kumive, da bira gweyawa gerave wakepewa, tawara meuma gwe danave wakepe ipewa, tamtan oya den anog aikpe. Mina meib, da bira nau danave wakepewa divi da oya den taig aipe. ");
INSERT INTO mti_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Apan Rotu biviwa imug anoya. ");
INSERT INTO mti_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Da bira inaiinai meuma oya anopewa me matai waropiyape, sira da bira inaiinai meuma waropiyapewa me matai yumnatpe. ");
INSERT INTO mti_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne ye diruitna, me arameba apa, apan duwam deriyat desirom apa wakepe, dawa me matai aupe sira dawa me wakepe. ");
INSERT INTO mti_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Vesin duwam matai parawa atapupu atan oya birori aigimpe, dawa me matai aupe sira dawa me wakepe.” ");
INSERT INTO mti_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(-) ");
INSERT INTO mti_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mu singui aya, “Ayapan, ampa?” Me garawa wane, “Bo kwapiwa wakenewa apa, nenip boriruwayawa kwapuwa nemewa matai agoniyape.” ");
INSERT INTO mti_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Meve nun evedni waigimpe sira topai den di ape, me gumbe Iesu toyau muntan oya aigowawa gumbo maibe mame wane. ");
INSERT INTO mti_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Me wane, “At kokawa da apa, keptete abnawa wakene. Me God gumbe a den aivi sira me iyayapan munan den anoivi. ");
INSERT INTO mti_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sira at me apa, kwapura da wakene, me gumbe nun gumbe kum evedni onivi. Me waivi, ‘Anavi neuma gumbe pui yuwana, sira nenan engambana.’ ");
INSERT INTO mti_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kuiyawa kum upeba me topayaivi. Megara iviren me membovit wane, ‘Ne God gumbe a den eni sira iyayapan oya den anoeni, ");
INSERT INTO mti_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","megara kwapura mame ande danadawai negivi. Nenan oniviwa ne matai unuwa topayatpe, meoya me pui yuwantna!’” ");
INSERT INTO mti_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Sira Ayapan wane, “Keptete abnawa kukaeba wanewa me anoya. ");
INSERT INTO mti_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Gomiyamunne igiyawa God gumbe kum aram auemewa oya munanwa oya God matai den puiyu mumpe? Me matai mu ande topai mumigimpe? ");
INSERT INTO mti_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ne ye diruitna. God imive puiyu munan oya tatevit ape. Megara Apan Usiwa uwapewa, piyu egave me matai anotumat oma ane yaupe?” ");
INSERT INTO mti_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iyayapan mu oraivitwa muma oya anotumat emewa sira iyayapan upeba gumbo ivuwa aug yan barauemewa munan Iesu maibe mame wane. ");
INSERT INTO mti_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Apan duwam nun watan temporu arawa danave unig amiya. Dawa Parisi abnawa sira dawa me takesi tamivi abnawa. ");
INSERT INTO mti_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi abnawa wan yoig sira membo oya nun wane, ‘God, ne ge gungap gaun veni me ne iyayapan upeba mina onan. Ne ub emewa kukaeba emewa uinantaraki emewa go apan mame takesi tamiviwa abnawa mu mina onan. ");
INSERT INTO mti_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ne pura desirom danave koni duwam nakwai kwit eni, sira undag me aueniwa naninwanit danave kebag desirom puyo wanigimpna.’ ");
INSERT INTO mti_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Megara takesi tamivi abnawa painau wan yoine. Me kwimin wan den yaune, sira togewa tog wane, ‘God, ne kukaeba eniwa, nenan anoa.’ ");
INSERT INTO mti_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ne ye diruitna. Apan mame me God namive oraimina ane sira gwe aine, megara apan dawa mina onan. Kuiyawa da bira iviwa membovit wan enagappewa me matai yan baraupe, sira da bira membovit mokona apewa me iviwa matai enagatpe.” ");
INSERT INTO mti_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iyayapan ud usiusiwa tam Iesu yumampe oya tam amome. Iesu aigowawa mame yauyawa mu tobotmuniya. ");
INSERT INTO mti_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Megara Iesu ud usiusiwa menan omome oya munan auwane sira wane, “Ud usiusiwa yan kwemiya nenan onampe, sira mu den toboriya. Kuiyawa God toimuwawa iyayapan meiba mu mumawa. ");
INSERT INTO mti_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ne natawa diruitna, Da bira me ud usiusiwa mina God toimuwawa den aupewa den di God toimuwawa unikpe.” ");
INSERT INTO mti_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Namuyoiyoi abnawa da Iesu singui ane, “Toewanewan oraiwa, ne divi akape inaiinai yaibobot auten?” ");
INSERT INTO mti_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iesu garawa wane, “Divi oya ne gunap wana oraiwa? Da bira oraimina onan, me God mekut. ");
INSERT INTO mti_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ge Gwangwan yaug anoana. ‘Uinantaraki den a, den toengra, ub den a, gae ugauga den wa, ebnotu inag mamag gumbo aigima.’” ");
INSERT INTO mti_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Me wane, “Ne ud toranap dividivi mame undag yumnadna.” ");
INSERT INTO mti_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Iesu mame anonewa, me gumbe wane, “Ge desirom ande wakene. Dividivi undag geumawa gwiruwara, sira tawara onan igiyawa waita muna, Ge kwimin apa oraiwa matai auwa. Meve ne amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Me mame anonewa, me danadawai koka aune. Kuiyawa me tawara kokavit gaibu. ");
INSERT INTO mti_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iesu me yaug wane, “Tawara igiyawa mu gumbo yaigiwa dadi me God toimuwawa uniktan oya! ");
INSERT INTO mti_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mae kameru inup nogawa gumbe uniktanwa me taibe, megara tawara abnawa God toimuwawa uniktanwa me yaigiwa dadi.” ");
INSERT INTO mti_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iyayapan da mame anoyawa singui aya, “Me natawa ipewa, bira oma ane waita aupe?” ");
INSERT INTO mti_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iesu garawa wane, “Iyayapan gumbo oma den ane, megara God gumbe oma ane.” ");
INSERT INTO mti_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita me gumbe wane, “Nu dividivi undag yankweg amagap ongete!” ");
INSERT INTO mti_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Iesu mu gumbo wane, “Ne natawa ye diruitna. Da bira gwe go biviwa go tatawaiwa go inamamawa go usitainawa mu God toimuwawa oya yankwenewa, ");
INSERT INTO mti_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","me kum mame danave koni obiren tampe, sira kum mataiwa uwapewa inaiinai yaibobot aupe.” ");
INSERT INTO mti_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iesu aigowawa 12 tam megiyave tene dirumne, “Nu Jerusarem oya dog angetan ete, sira Apan Usiwa gumbe dividivi propeta teyawa undag me pawape. ");
INSERT INTO mti_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Me aug Ju onan igiyawa gumbo mumpe. Mu me gumbe iyagau ape, sira gutup gumbe empe me gumbe wape pimpanoine, sira murap gumbe tope toengutpe boape. ");
INSERT INTO mti_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kum duwamdesiyawa apa, me sira inaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aigowawa mu gaiyawa mame desirom da den yaug anoya. Natawa mu gumbo guwave ane, sira Iesu divi oya waiviwa mu den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iesu at Jeriko uwaiviwa, yangabored abnawa da ebu megiyave wakeke nun waivi. ");
INSERT INTO mti_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Me iyayapan megiyave uwag amomewa anone, me singui munne mame divi pawaivi. ");
INSERT INTO mti_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mu me gumbe waya, “Nasaret apan Iesu uwag aivi.” ");
INSERT INTO mti_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Me kwaruwane, “Iesu, Devid Usiwa, ano nega!” ");
INSERT INTO mti_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iyayapan ebu namu yoiyoi emewa me gae yankwetan oya dig waya. Megara me kwat kokavit gerave gerave wane, “Devid Usiwa, ano nega!” ");
INSERT INTO mti_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iesu tumag yoine, apan yan me nenan aug onamtan oya wane. Me Iesu megiyave uwanewa, Iesu me singui ane, ");
INSERT INTO mti_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ge imugap ne dimbae genan atna?” Me gara wane, “Ayapan, ne yautan anoeni.” ");
INSERT INTO mti_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iesu me gumbe wane, “Yangagwa auwa. Anotumat geuma warinam genne.” ");
INSERT INTO mti_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Me yangawa tatevit oraimina ane, sira God waiya waiya ake Iesu amave aine. Iyayapan undag mame yauyawa, mu mina God gumbe waiya waiya aya. ");
INSERT INTO mti_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iesu at Jeriko unig uwag aivi. ");
INSERT INTO mti_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Me apa apan da wakene, me iviwa Jakies. Me takesi tamemewa me kokawa muma da, me tawara abnawa. ");
INSERT INTO mti_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Me imive yaupe Iesu aninin, megara me apan pipi, meoya oma den ane yaupe. Kuiyawa iyayapan obiren tobot tobot eme. ");
INSERT INTO mti_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Meoya me namu kintog aine, me yautan oya yoma inaru mina dodne, kuiyawa Iesu ebu me apa onivi. ");
INSERT INTO mti_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iesu at me apa uwanewa, me yangut wan ag yaune. Sira me gumbe wane, “Jakies, tatevit yan aiga. Ne gare gwe geuma apa waketan di eni.” ");
INSERT INTO mti_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Meoya me tate yan aigne, degadegaepam me gumbe kaiwa kaiwa wanne. ");
INSERT INTO mti_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iyayapan undag mame yauyawa, amatog diguragut ag waya, “Apan me kukaeba aiviwa gweyawa aine sira me amdau abnawa meuma ane.” ");
INSERT INTO mti_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Megara Jakies wan yoig Ayapan gumbe wane, “Yawa, Ayapan! Gare mame di ne tawara neuma undag gambenwa pukpuk wagawag igiyawa muntna, sira da bira wape me gumbe ne ugauga anawa, ne matai koni duwam ge duwam garawa wantna.” ");
INSERT INTO mti_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iesu me gumbe wane, “Kum mame gare, God waita meuma gwe mame uwane, kuiyawa apan mame mina me Ebraam usiwa. ");
INSERT INTO mti_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Apan Usiwa uwanewa bira da inanadnewa me didimama atan oya sira me waita wantan oya uwane.” ");
INSERT INTO mti_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mu mame anoemewa gumbe, me gae waiviwa maibe da mu gumbo wane, kuiyawa me Jerusarem ug maneve, sira iyayapan anoya me God toimuwawa meuma pungi den ape taibe uwape. ");
INSERT INTO mti_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Me wane, “Apan me painauvit dam me gumbe yainewa at da aramawa aine. Me membovit kin tum yupe atan sira taig ongetan oya. ");
INSERT INTO mti_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Meoya me nau usitainawa undag 10 auwane, sira mu gumbo anmaga 10 minas munne. Me wane, ‘Anmaga mame gumbe nau aya, nau aigimiya ne sira taig uwatna.’ ");
INSERT INTO mti_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Megara me iyayapan meuma me topayaya, meoya ivi umum igiyawa teya amiya sira waya, ‘Nu imunup apan mame kin den ape.’ ");
INSERT INTO mti_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Megara me baraune kin ane, sira taig gwe uwane. Meve me nau meuma waremewa me anmaga munnewa oya umum baraune me gumbe yaug anope mu anmaga munnewa gumbe anintom auya. ");
INSERT INTO mti_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Apan namuirenwa uwag wane, ‘Apan, anmaga neganawa 1 minas gumbe 10 minas gerave sira auna.’ ");
INSERT INTO mti_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Me kokawa meuma garawa wane, ‘Nau oraimina ana, nau neuma wariviwa oraiwa! Dividivi kusikarenwa oya ge anotumat geuma gaibu, meoya gwetoimu kokawa undag 10 amara.’ ");
INSERT INTO mti_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Apan duwameba uwag wane, ‘Apan, ge anmaga geuma 1 minas gumbe 5 minas gerave sira auna.’ ");
INSERT INTO mti_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Me kokawa meuma garawa wane, ‘Ge gwetoimu kokawa undag 5 amara.’ ");
INSERT INTO mti_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Meve nau meuma wariviwa dawa uwag wane, ‘Apan, mame ge anmaga geumawa. Ne yumnadna wape kwetawa gumbe benam tog barauna wakene. ");
INSERT INTO mti_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne ge gungap a ana, kuiyawa ge apan yaigipama. Ge divi da den barauwanawa atan auwa, sira divi da den veranawa sig tama.’ ");
INSERT INTO mti_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kokawa meuma garawa wane, ‘Ne gae geumawa gumbe pui yugempna. Ge nauwaruwat kukaeba. Ge nenan mamaib vege? Ge yaug anoana ne apan yaigipama, divi da den baraunawa me atan avieni, divi da den vednawa me sig tameni? ");
INSERT INTO mti_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Divi oya ge ne anmaga neuma anmaga gweyawa bank danave den barauwana? Ge meib apa ipawa, ne sira taig uwanawa, ne anmaga usiwa gaibu ibiyapopo.’ ");
INSERT INTO mti_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Meve me iyayapan megiyowo yokeyawa gumbo wane, ‘1 minas meuma me gumbe atan auya, sira apan 10 minas aunewa me waniya.’ ");
INSERT INTO mti_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mu waya, ‘Apan, me 10 minas wait me gumbe!’ ");
INSERT INTO mti_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Me garawa wane, ‘Ne ye diruitna. Da bira kokavit aunewa me sira gerave wampe. Megara da bira den aunewa sira kusida me gumbe wakenewa me atan aupe. ");
INSERT INTO mti_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Megara iyayapan mu anavi neuma imuwo ne kin muma den atna anoemewa tam mawa oneya, sira ne namunap guriya boriruwape.’” ");
INSERT INTO mti_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesu mame wanewa, ivi meve Jerusarem oya dog aine. ");
INSERT INTO mti_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mu at Jerusarem uweme tui kusi vemewa tui Orivu kuiyave at Betepage ge at Betani uwayawa, Iesu aigowawa duwam dirumne tene amiya, ");
INSERT INTO mti_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Gwetoimu da namuyep aisiya. Ye me unigiyawa, eme apa mae donki mataiwa me gerave bira da den dauwanewa murap gumbe tuya wakene ye yauya. Murap atan vesiya, sira aug mame oneya. ");
INSERT INTO mti_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Da bira ye guniyap singui aib wapewa, ‘Ye divi oya mae donki mataiwa murap tuyawa vetene?’ me gumbe aib waya, ‘Ayapan imive wakene.’” ");
INSERT INTO mti_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mu namu tene amiyawa, Iesu dirumnewa me mina di yauya. ");
INSERT INTO mti_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mu mae donki mataiwa murap vetemewa, mae me mamawa mu singui munne, “Ye divi oya mae donki mataiwa murap tuyawa vetene?” ");
INSERT INTO mti_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Mu garawa waya, “Ayapan imive wakene.” ");
INSERT INTO mti_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mu Iesu gumbe aug onamiya, sira wape muma donki mataiwa gerave emeya, sira Iesu gerave barauya. ");
INSERT INTO mti_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Iesu aiviwa, iyayapan wape ebu taibe yayabeyaya. ");
INSERT INTO mti_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Me tui Orivu amave obmaniviwa, aigowawa agoniyayawa undag amatog degadegaepam waiya waiya God gumbe veme, kuiyawa dividivi undag me anewa pawanewa mu yauya: ");
INSERT INTO mti_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Kin me Ayapan iviwa gumbe uwapewa, me gumbe waribiya wakeigimpe! Yum kwimin apa sira eyawa at painauiren danave!” ");
INSERT INTO mti_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Parisi upeba agonagon gumbo wakeyawa Iesu gumbe waya, “Toewanewan, aigowagwa diruma.” ");
INSERT INTO mti_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Me garawa wane, “Ne ye diruitna, mu gae yankwepe ipewa, an matai noiwa kwaruwape.” ");
INSERT INTO mti_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesu Jerusarem obmaniviwa at kokawa yaug, Iesu Jerusarem oya iruwane. ");
INSERT INTO mti_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Sira wane, “Ge kum mame yum oya yaug anopa ipawa. Megara gare ge yangagwa gumbe guwave wakene. ");
INSERT INTO mti_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Me kumiwa anavi geuma ge gungap uwape. Mu piyu beyan watpe, sira yenan oya birorot pampe, gamben gamben uwagempe. ");
INSERT INTO mti_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ge danagap, mu ge usitainagwa gaibu tog aoregempe, em gempe, piyu gerave aigiya. Mu ape an desirom da mapa dawa egave den wakepe. Kuiyawa God kum divi genan oniviwa ge den yaug anoana.” ");
INSERT INTO mti_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Meve Iesu temporu arawa unigne, sira amatog iyayapan gwiruwaremewa atatai imune dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sira me mu gumbo wane, “Me tenewa, ‘Ne gwe neuma me nun gweyawa di. Megara ye ayana me yuaore toaore dagup muma mina ane.’” ");
INSERT INTO mti_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kum evedni Iesu temporu arawa danave toyau munivi. Megara pirisi koukawa, Gwangwan toewanewan igiyawa, iyayapan yapowo namu yoiyoi igiyawa, mu Iesu tope boatan oya ebu didimama eme. ");
INSERT INTO mti_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Megara mu me atan oya oma den ane ebuwawa da yauya. Kuiyawa iyayapan undag gae meuma anotan oya anoeme. ");
INSERT INTO mti_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kum da Iesu iyayapan temporu arawa apa toyau munivi, sira gae oraiwa opata waivi. Pirisi koukawa, Gwangwan toewanewan ge namuyoiyoi igiyawa gaibu agoniyaya sira amog Iesu gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mu waya, “Nu didnuna. Ano yusiwa divi gumbe mame ege? Bira ano yusiwa mame genne?” ");
INSERT INTO mti_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Me garawa wane, “Ne mina ye singui da diruitna. Ne didnegiya. ");
INSERT INTO mti_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon babataito meuma me kwimin apa onne, go iyayapan gumbo onne?” ");
INSERT INTO mti_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mu mumbovit gae wageyau aya, sira waya, “Nu aib watawa ipewa, ‘Kwimin apa onne’, me matai singui aib wape, ‘Divi oya me gumbe anotumat den ene?’ ");
INSERT INTO mti_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Megara nu aib wata ipewa, ‘Iyayapan gumbo onne,’ iyayapan undag matai an gumbe gutnumpe, kuiyawa mu anotumat eme Jon me propeta di.” ");
INSERT INTO mti_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Meoya mu garawa waya, “Nu den yaug anotu me ampa onne.” ");
INSERT INTO mti_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iesu wane, “Ne mina den diruitna divi ano yusiwa gumbe ne dividivi mame eni.” ");
INSERT INTO mti_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iesu iyayapan gae maibe mame amatog dirumne: “Apan da yoma greip vedne, sira nauwareme igiyawa upeba wane nau ape, sira me kum yobenut yankwem aine. ");
INSERT INTO mti_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Maura kumiwa uwanewa me nau meuma aiviwa baraune onne nau wareme igiyawa gumbo, yoma greip kwerawa mu upeba wantan oya. Megara nau wareme igiyawa me toya sira yankweya naniwa ingui barauya aine. ");
INSERT INTO mti_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Me menan nau aiviwa dawa sira baraune onne. Megara mu apan me sira toya, sira gwambe me gumbe ubmamepam aya, sira yankweya naniwa ingui taig aine. ");
INSERT INTO mti_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Me sira duwamdesiyawa baraune onne, sira meib tog aoreya. ");
INSERT INTO mti_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Meve greip nauwawa kuiya abnawa wane, ‘Ne anin atna? Ne ud neuma me gumbe baigan eniwa barautna aipe. Anten mu matai me gumbe ebnotu wampe!’ ");
INSERT INTO mti_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Megara nau wareme igiyawa me yauya gae garawa waya, ‘Mame me kwan autan usirenwa, me toengutta, sira dividivi meuma undag me numawa ape.’ ");
INSERT INTO mti_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Meve mu greip nauwawa daieve yumeg aug amiya sira me toya boane. Greip nauwawa kuiya abnawa matai mu gumbo anin ape? ");
INSERT INTO mti_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Me matai taig uwape sira mu nau wareme igiyawa gutpe boriruwape sira greip nauwawa igiyawa upeba mumpe.” Iyayapan mame anoyawa, mu waya, “Mame matai meib den di ape!” ");
INSERT INTO mti_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iesu mu temtemtem yawam singui munne, “Mame tenewa me natawa divi: ‘An me gwe sisi igiyawa topayayawa me an natawa oraivitwa me visidonawa apa teyawa ane.’ ");
INSERT INTO mti_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Da bira an mame gerave aikpewa me dumetpe musimusi ape. Sira an mame me apan da egaven aikpewa me toengutpe musimusi ape.” ");
INSERT INTO mti_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Gwangwan toewanewan igiyawa ge pirisi koukawa Iesu tatevit yumtan oya ebu yobatan oya waya, kuiyawa mu yaug anoya me maibe mu gumbo wane. Megara mu iyayapan munan a aya. ");
INSERT INTO mti_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Me gumbe mu kaipat yaimoyai eme. Mu karap igiyawa waen kwimiya amiya, mu natawa eme mina ugauga eme. Mu anog ieme Iesu gae da gwambe wapewa, me gumbe mu yum aug ampe amaraivi abnawa yusiwa ge ano yusipam gumbe. ");
INSERT INTO mti_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Meoya karap igiyawa me singui aya, “Toewanewan, nu yaug anotu ge gae vegewa toyautoyau egewa me natawa gumbe. Sira ge den iyayapan gumbo yan umege, megara God ebuwawa gumbe toyautoyau ege gae natawa anin wanewa gumbe. ");
INSERT INTO mti_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nu Siisa gumbe takesi garawa ata me bainda go onan?” ");
INSERT INTO mti_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iesu ugauga muma gumbe yawamne, mu gumbo wane, ");
INSERT INTO mti_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Anmaga denari toyau negiya yautna. Bira ginangawa ge iviwa egave wakene?” ");
INSERT INTO mti_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mu garawa waya, “Siisa ginangawa.” Sira mu gumbo wane, “Meve Siisa meuma me Siisa waniya, sira God meuma me God waniya.” ");
INSERT INTO mti_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iyayapan obiren yangowo mu oma den ane Iesu gae meuma aupe. Sira me garawa wanewa mu anog arag teya sira mu nouwa iyagisia. ");
INSERT INTO mti_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi igiyawa veme, bo gumbe sira den inaig yoig wanekpe. Mu upeba singui muma aug omog Iesu gumbe uwaya. ");
INSERT INTO mti_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mu waya, “Toewanewan, Mosisi nunan oya aib tene. ‘Apan da tatawa me vesin aune botone usiwa da onan ipewa, gwaneba me kwapura aupe tatawa oya ud tepe yave atanit di.’ ");
INSERT INTO mti_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sira tatagwanepam 7 wakeya. Tatawa namuwa vesin aug me boane, ud onan boane. ");
INSERT INTO mti_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Me duwameba mina meib. ");
INSERT INTO mti_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sira duwamdesiyawa kwapura me aune. Ebu me desiroma naningambenit gamben duwameba yaveg boane sira ud onan di. ");
INSERT INTO mti_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Oieba vesin mina boane. ");
INSERT INTO mti_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gare, sira mu yoipewa kumiwa apa, vesin me apan undag 7 danave bira biviwa ape, kuiyawa mu undag vesin me auya?” ");
INSERT INTO mti_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iesu garawa mu gumbo wane, “Iyayapan kum mame garewa apan vesin aupe sira vesin apan aupe. ");
INSERT INTO mti_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Megara iyayapan oraivitwa mu piyu mataiwa aupe, mu bo gumbe sira yoipe. Mu apan vesin den aupe, vesin apan den aupe. ");
INSERT INTO mti_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mu oma den ane sira bo ape, kuiyawa mu aneya mina ape. Mu God usitainawa, mu bo gumbe sira inaig yoig usitainawa ape. ");
INSERT INTO mti_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bo igiyawa sira yoig inaipewa, me gumbe Mosisi mundana apa taibe di yaug anone. Me Ayapan aib auwane, ‘Ebraam God meuma, Aisak God meuma ge Jekob God meuma.’ ");
INSERT INTO mti_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Me bo igiyawa God muma onan, megara me kaninga wakeemewa God muma. Kuiyawa iyayapan undag God gumbe inaig wakeya.” ");
INSERT INTO mti_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Gwangwan toewanewan upeba garawa waya, “Toewanewan, bainda di wana!” ");
INSERT INTO mti_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Me ivi, bira da Iesu gumbe singui da watan den anone. ");
INSERT INTO mti_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Meve Iesu mu gumbo wane, “Mu aninin Keriso me Devid usiwa waya? ");
INSERT INTO mti_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Buka Sam danave Devid membo wane: ‘Ayapan me Ayapan neuma gumbe wane: “Nanin yutanwa apa wakeigima, ivi ne anavi geuma amagwa ankwatave tetna em nategewa ape.” ’ ");
INSERT INTO mti_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Meoya Devid me gumbe ‘Ayapan’ wanewa, aninin me Devid usiven ape?” ");
INSERT INTO mti_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iyayapan undag anoemewa, Iesu aigowawa gumbo wane, ");
INSERT INTO mti_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Gwangwan toewanewan igiyawa gumbo yaukape. Mu imuwo wape muma yobu tam a gigeme, sira mu imuwo baigan en gaun gumbe gwiruwaremewa arawa apa autan anoeme, sira mu imuwo sinagogu danave at oraiwa apa waketan anoeme, sira buyunai nemewa ayamat arawa waketan anoeme. ");
INSERT INTO mti_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mu kwapura gweyowa dividivi undag naboreme, sira iyayapan yawampe oya nun yobutaren wape. Iyayapan meiba me matai ibnawa kokavit mumpe.” ");
INSERT INTO mti_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iesu yangut wan yaunewa, tawara igiyawa puyo muma temporu puyo teemewa danave teeme yaune. ");
INSERT INTO mti_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Me yaune kwapura tawara onanwa da anmaga kopa kusiwa reputa duwam teivi yaune. ");
INSERT INTO mti_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Me wane, “Ne ye natawa diruitna. Kwapura gwandakwaeba mame me puyo obiren tene, iyayapan upeba undag mina onan. ");
INSERT INTO mti_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iyayapan mu tawara obiren muma gerave em yoig puyo muma teya. Megara vesin mame kusi gumbe wakeg aigimtanwa meme tene.” ");
INSERT INTO mti_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aigo meuma upeba temporu an oraimumu gumbe ge puyo gumbe beniyayawa me gaiyawa veme. Iesu wane, ");
INSERT INTO mti_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ye mame apa yavene. Ne diruitna kum me uwapewa an desirom da mapa dawa egave den wakepe; an undag gwiriruwag aikpe.” ");
INSERT INTO mti_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mu singui waya, “Toewanewan, kum divi dividivi mame pawape? Sira dividivi mame pawatan aigimpewa irakoniwa aninin?” ");
INSERT INTO mti_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Me wane, “Yaukape. Iyayapan da den kwemiya uga yempe. Kuiyawa obiren matai ne ivunwa gumbe uwape waigimpe, ‘Ne me mame,’ sira ‘Kum koni di aivi.’ Mu amowo den di aisiya. ");
INSERT INTO mti_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wanampa mut gaiyawa ge dividivi tobiyaigimpewa oya anoyawa, me den teraya. Dividivi mame pawatanit di, go oieba den uwape, me matai.” ");
INSERT INTO mti_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Meve me mu gumbo wane, “Iyayapan mu iyayapan dawa gaibu matai yoig mut watpe, sira at kokawa me at kokawa dawa gaibu matai yoig mut watpe. ");
INSERT INTO mti_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Me apa matai pinunu kokavit ipunapun ape, nakwai gambenwa iyagon uwape, yuwat kukaeba at ubeube danave kep tepe, uyaeba ape, sira irakoniwa kokavit kwimin apa pawape. ");
INSERT INTO mti_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Megara dividivi undag mame ivi pawape. Namu mu nanuwo ye guniyap aorepe ye diruig edawai yempe. Sira mu ye au yen sinagogu ge nog eme yempe. Sira ye tamiyem kin ge amareme igiyawanamuwo ye yoiya. Dividivi undag mame ne ivunwa oya ye guniyap pawape. ");
INSERT INTO mti_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Me ye natawa yeuma mu gumbo taibe ape. ");
INSERT INTO mti_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Megara aninin yembovit gae gumbe ayun wariyawa, namuiren kwiyewa imug den anoya. ");
INSERT INTO mti_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kuiyawa ne matai ye gae ge ano oraiwa yentna. Meoya anavi yeuma undag matai oma den ane gae gumbe ayun go topayape. ");
INSERT INTO mti_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ye matai inemamewa, tatewaiwa, iyai desiroma sira yairewaiwa ye omin yeuma tepe. Sira matai mu ape ye upeba boriruwaya. ");
INSERT INTO mti_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iyayapan undag ye matai topai yempe kuiyawa ne ivunwa oya. ");
INSERT INTO mti_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Megara kwiye gumawa desirom da den pukwag aikpe. ");
INSERT INTO mti_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yaiyai yokeigimiya gumbe ye matai inaiinai auya. ");
INSERT INTO mti_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Megara mut igiyawa Jerusarem yurempe yauyawa, ye me yaug anoya kukaig wakukamtan kumiwa me koni aivi. ");
INSERT INTO mti_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Meve iyayapan at Judia apa wakeyawa dirumiya tui gumbe a ampe, at kokawa apa wakeyawa dirumiya dauwag ampe, sira at piyu gambenwa apa wakeyawa dirumiya at kokawa danave den unikpe. ");
INSERT INTO mti_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kuiyawa mame me garawa atanwa kumiwa, sira wait undag tenewa me taibe ape. ");
INSERT INTO mti_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Me kumiwa apa vesin bug ayawa ge inanaiwa ud am munemewa mu matai danadawai koka aupe. Me apa matai piyu gerave danadawai koka uwape sira iyayapan mame gumbo God danapiriwape. ");
INSERT INTO mti_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mu matai benesi gumbe gutpe aikpe, sira matai ankwatave nau eme igiyawa ape, at da apa undag tepe wakepe, matai Ju onan igiyawa Jerusarem gerave em wakukam aigimpe meve Ju onan igiyawa kum muma onanape. ");
INSERT INTO mti_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Sira me apa matai kum gumbe, dud ge marantun gumbo irakoniwa pawape, sira piyu gerave poeman noiwa uyaeba ape sira tui kokavit dog aoregimpe, meoya iyayapan uiwa a ape. ");
INSERT INTO mti_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Iyayapan matai piyu undag gerave dividivi uwapewa anog a gumbe bototo ape. Kwimin yusiwa ipunapun ape. ");
INSERT INTO mti_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Me kumive matai Apan Usiwa irikup danave wakeg yusiwa ge eyawa koka gaibu uwape mu yaupe. ");
INSERT INTO mti_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dividivi mame amatog aigimpewa, wan yoiya sira kuiewa enagasiya. Kuiyawa ye sira gwiruwaremtan kumiwa koni aivi.” ");
INSERT INTO mti_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sira me maibe mame dirum wane; “Yoma inaru ge yoma undag yawamiya. ");
INSERT INTO mti_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Mu kwayawa duwaigimpewa, me ye yaug anoya bodu kumiwa koni aivi. ");
INSERT INTO mti_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ebu me desiroma, ye me dividivi mame undag yauyawa, Apan Usiwa me ankwin noive koni aivi yaug anoya. ");
INSERT INTO mti_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne natawa diruitna. Namu dividivi undag mame veniyape, ivi matai kum garewa uwag aipe. ");
INSERT INTO mti_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kwimin ge piyu mame matai onanape, megara ne gae neumawa den onanape. ");
INSERT INTO mti_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Vesin ge apan inaiiani kukaeba oya, yoinanan oya, inaiinai anogugut gumbe oya ye nonemagewa emiyempewa, me kumiwa uwayempe, ye matai nama mina emiyempe. Meoya yembovit yaukape. ");
INSERT INTO mti_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kuiyawa me kumiwa iyayapan undag piyu gerave wakeyawa gumbo uwape. ");
INSERT INTO mti_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Megara ye kum evedni amat ag nun waigimiya. Me gumbe dividivi undag mame pawapewa, ye oma ape ayun wariya, sira me gumbe ye oma ape Apan Usiwa namive yoiya.” ");
INSERT INTO mti_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kum desirom desirom Iesu temporu arawa danave toyau toyau aivi, sira aram desirom desirom me dauwag aig tui Orivu apa vinivi. ");
INSERT INTO mti_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sira iyayapan undag mumbevit gae wape anotan oya temporu arawa danave onamiya. ");
INSERT INTO mti_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gare me Bredi Iist Onanwa Buyunaeba, me iyayapan wayawa Uwag Gaveya Buyunaeba, me di koni aivi. ");
INSERT INTO mti_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pirisi koukawa ge Gwangwan toewanewan igiyawa mu Iesu tope boatan oya ebu upeba yobareme, kuiyawa mu iyayapan ayowa eme. ");
INSERT INTO mti_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Meve iviwa waya Isukariot Judas, me aigowawa 12 me danowa da. Seitan me danave unigne. ");
INSERT INTO mti_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sira Judas me pirisi koukawa ge temporu porisu igiyawa koukawa aine mu gaibu gae waya aninin me Iesu ominawa tepe. ");
INSERT INTO mti_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mu degadega aya sira anmaga me wantan oya bainda waya. ");
INSERT INTO mti_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Me bainda wane, sira iyayapan den wakeyave Iesu avig mu muntan oya me kumiwa yob warivi. ");
INSERT INTO mti_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Meve Iist Onanwa Bredi Buyunaeba kumiwa uwane, me apa Uwag Gaveya Buyunaeba sip usiwa me tog puyo ape. ");
INSERT INTO mti_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Sira Iesu me Pita ge Jon wain kwimun waivi, “Aisiya, sira dividivi Uwag Gaveya Buyunaeba nu natan oya tamibarip aya.” ");
INSERT INTO mti_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Sira mu Iesu gumbe waya, “Imugap ampa nu tamibarip ata?” ");
INSERT INTO mti_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Iesu garawa mu gumbo wane, “Ye at koka me unigiyawa apan da irut aug aivi me nuntosa yempe, me amave aisiya, gwe me unikpewa me unigiya. ");
INSERT INTO mti_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ye gwe abnawa gumbe aib diya, ‘Toewanewan abnawa ge dirugivi. Uwag Gaveya Buyunaeba ne aigo neumawa gaibu natna. Meoya amdau pantut me ampa?’ ");
INSERT INTO mti_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pantut koka painauwa undag waribiyayawa me toyau yempe. Me apa tamibarip aya.” ");
INSERT INTO mti_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mu amiya. Sira dividivi yauyawa me wait Iesu dirumne mina di. Meve mu Uwag Gaveya Buyunaeba oya tamibarip aya. ");
INSERT INTO mti_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Me kumiwa uwanewa, Iesu ge apasoro mu teboro apa parau wakeya. ");
INSERT INTO mti_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Me mu gumbo wane, “Ne imunap kokavit, Uwag Gaveya Buyunaeba mame ye gaibu natna. Meve edawai autna. ");
INSERT INTO mti_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kuiyawa ne ye diruiyeniwa, ne matai Uwag Gaveya Buyunaeba me sira den natna. Me wakepe aipe God toimuwawa danave Uwag Gaveya Buyunaeba natawa uwapeve, meve natna.” ");
INSERT INTO mti_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Me ap aug gaun wanne, meve wane, “Mame auya sira yembovit kebaya. ");
INSERT INTO mti_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ne ye diruiyeni. Ne matai yoma greip magawa yoiba sira den natna wakeg aigimpe God toimuwawa uwapeve, meve natna.” ");
INSERT INTO mti_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Me bredi aug gaun wanne, meve wasine mu munne wane, “Mame ne kwapunwa ye yeneni. Mame aya imug teg ano negigimiya.” ");
INSERT INTO mti_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nakwai naya onanane, meve ebu desiroma Iesu ap aug wane, “Ap mame me agi neuma mataiwa di neuma gumbe. Me yenan oya ururuwak aikpe. ");
INSERT INTO mti_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Megara yauya, ne omin neuma tetanwa abnawa naniwa teboro gumbe ne gaibu waketu. ");
INSERT INTO mti_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Baiboru gumbe nenan tenewa mina Apan Usiwa me matai kweg aipe. Apan Usiwa gumbe omin meuma tepewa me gumbe ano kukaeba wakeigimpe!” ");
INSERT INTO mti_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mu amatog mumbovit singui veme, mu gumbo bira ebu mame ape. ");
INSERT INTO mti_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mina ebu da kukaeba yaigiyoine, bira mu gumbo yaug anope kokawa bira ape. ");
INSERT INTO mti_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iesu mu gumbo wane, “Ju onan igiyawa kin mumawa iyayapan egave yutuwa gumbe nau eme, sira yutuwa gumbe namu yoiyoi igiyawa gumbo iyayapan waya mu amaremewa. ");
INSERT INTO mti_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Megara ye meib onan. Kokawa ye guniyap me ud mataiwa mina ape, sira amaraiviwa me nau wariviwa mina ape. ");
INSERT INTO mti_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kokawa me teboro apa wakene go nau warivi go? Me teboro apa wakene. Megara ne ye guniyap nau wariviwa mina nau wareni. ");
INSERT INTO mti_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ye ne danadawai aueniwa megiyanap yoiyana igiyawa. ");
INSERT INTO mti_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Maman toimuwawa amaratan oya yusiwa nedne mina, ne ye yusiwa yentna. ");
INSERT INTO mti_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Meoya ye toimu neuma danave teboro neuma apa yoi ge nakwai naya, sira kin seyaiba egave wakeg Isuraeru dam mumawa 12 amaraigimiya. ");
INSERT INTO mti_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Saimon, Saimon, anoa. Seitan imive nakwai wiit natawa ge mutat ubeube tetan mina ye undag amaorot ape. Seitan imive ye undag nakwai wiit natawa ge mutat mina viyaviya atan aivi. ");
INSERT INTO mti_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Megara ne genan oya nun wana. Kuiyawa ne imunap ge anotumat geuma yan den aikpe. Ge sira taigawa, tatagaiwa geuma wad tuwama.” ");
INSERT INTO mti_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Megara me garawa wane, “Ayapan, ne ge gaibu nog anektan sira bo atan oya tamibarip ana.” ");
INSERT INTO mti_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Iesu garawa wane, “Pita, ne ge dirukna. Kum gare ge koni duwamdesi wa den yauneg anoana, meve kumkum wape.” ");
INSERT INTO mti_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Meve Iesu mu gumbo singui wane, “Ne anmaga ikwaeba, ikwai go sandoro den te yenna aisiyanawa, ye divi da oma den ane go onan?” Mu garawa waya, “Onan di.” ");
INSERT INTO mti_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Me mu gumbo wane, “Megara ye anmaga ikwaeba da auyawa me auya, ikwai gaibu auya. Ye benesi da den auyawa, wape yeuma gwiruwat anmaga aug, me gumbe benesi gwiruwat auya. ");
INSERT INTO mti_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ne ye diruitna. ‘Me kukaeba igiyawa gaibu basiyaya.’ Mame ne gunap tenewa di matatpe. Ne gunap tenewa me di koni matatpe.” ");
INSERT INTO mti_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Mu waya, “Ayapan yawa, mapa benesi duwam wakeya,” me garawa wane, “Me oma ane.” ");
INSERT INTO mti_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iesu tui Orivu dauwag aine. Me kum evedni meib aivi. Sira aigowawa amave amiya. ");
INSERT INTO mti_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","At me uwayawa, me mu dirum wane, “Ye matai kukaeba gumbe uyug den aigiya, meoya nun waigimiya.” ");
INSERT INTO mti_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Me yankwem an vereme aig aigiviwa me mina aine, sira koniwa yug nun wane. ");
INSERT INTO mti_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Maman, ge ano geumawa ipewa, ap mame ne gunap atan auwa. Me ne ano neumawa onan, megara ge ano geumawa veniyape.” ");
INSERT INTO mti_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Sira aneya kwimin apa me gumbe uwane, me waita wan yusiwa wanne. ");
INSERT INTO mti_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Me danadawai koka aunewa, me nun gerave yaiyai wane. Me amun wadnewa, di mina piyu gerave aigne. ");
INSERT INTO mti_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Me nun wane onanane wan yoine sira aigowawa oya uwanewa, mu danadawai muma gumbe kubvineme yawamne. ");
INSERT INTO mti_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Me mu gumbo wane, “Ye divi oya kubvinene? Wan yoiya, nun waigimiya, me gumbe ye matai kukaeba gumbe uyug den aigiya.” ");
INSERT INTO mti_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iesu ande gae waiviwa, iyayapan me gumbe uwaya. Apan da me iviwa waya Judas, me aigowawa 12 danavewa da. Me namuyoiyoi aivi. Me uwa totan oya Iesu gumbe obmanne. ");
INSERT INTO mti_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Megara Iesu me gumbe wane, “Judas, ge Apan Usiwa uwa toto gumbe ominawa teege?” ");
INSERT INTO mti_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iesu gaibu birorot wakeyawa divi me pawatan aivi yauya. Mu waya, “Ayapan, nu benesi numa gaibu mut ata?” ");
INSERT INTO mti_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sira mu da benesi viyane pirisi painauvitwa me nauwawa aiviwa da naunawa yutanwa kwagomiyane aigne. ");
INSERT INTO mti_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Megara Iesu wane, “Mame mina sira den aya.” Me apan naunawa yumne warinamne. ");
INSERT INTO mti_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Meve Iesu pirisi painauvitwa, temporu porisu igiyawa koukawa sira namuyoiyoi igiyawa menan onamiyawa dirum wane, “Ne ub igiyawa tam namuyoiyoi eni go? Meoya ye deba ge seri gumbe ne yumnektan uwayana? ");
INSERT INTO mti_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kum evedni ne ye gaibu temporu arawa apa wakeete, sira ye naniwa da den ne gunap barauyana. Megara kum mame me yeumawa. Me sisip yusiwa.” ");
INSERT INTO mti_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Meve mu me auya. Mu me aug, pirisi painauvitwa gweyawa amiya. Pita painau utupa mu amowo aivi. ");
INSERT INTO mti_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sira mu pirisi painauvitwa gweyawa danave panki yapave me apa iyam okereg undag yan wakeya. Pita mu gaibu yan wakeya. ");
INSERT INTO mti_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Vesin nau aiviwa da iyam okeriya eyave Pita yan wakene yaune. Vesin me keni tog yaug wane, “Apan mame me gaibu wakenewa.” ");
INSERT INTO mti_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Megara Pita onan di wane, “Vesin, ne me den yaug anona.” ");
INSERT INTO mti_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kusi pungi wanewa, apan da me yaug sira wane, “Ge mina mu desiroma da.” Megara Pita gara wane, “Apan, ne onan.” ");
INSERT INTO mti_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kum koniwa desirom onanane mina, apan da sira gae yusipam wane, “Natawa di, apan mame me gaibu wakeyawa da, kuiyawa me Gariri abnawa.” ");
INSERT INTO mti_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita wane, “Apan, ne den yaug anona ge divi oya vege.” Me koni me apa gae waiviwa kumkum wane. ");
INSERT INTO mti_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ayapan tobiyag Pita yangut siwavit yaune, meve Pita me watavit Ayapan me gumbe gae wanewa imug anone, “Kum gare, namu koni duwamdesi ge ne topai negawa, ivi kumkum wape.” ");
INSERT INTO mti_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Sira me dauwag aig it kokavit wane. ");
INSERT INTO mti_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iyayapan Iesu amaremewa amatog iyagau okereme sira me toeme. ");
INSERT INTO mti_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sira me yangawa toboriya, me gumbe ayag singui waya, “Ge propeta, ge bira toadne?” ");
INSERT INTO mti_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Sira mu gae kukaeba obiren me gumbe waya. ");
INSERT INTO mti_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wantenewa, dam namuyoiyoi igiyawa, pirisi koukawa ge Gwangwan toewanewan igiyawa onam agoniyaya. Mu Iesu aug Daiboru Painauvitwa gumbe amiya. ");
INSERT INTO mti_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mu waya, “Ge Keriso ipewa, me diruna.” Megara Iesu wane, “Ne Keriso ye diruitnawa, ye matai anotumat den anegiya. ");
INSERT INTO mti_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sira ne ye singui yempnawa, ye matai garawa den waya. ");
INSERT INTO mti_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Megara mame apa utan aipewa, Apan Usiwa matai God me yusipamit naniyutanwa apa wakepe.” ");
INSERT INTO mti_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mu undag waya, “Ge me God Usiwa?” Iesu garawa wane, “Ye natawa vene. Ne meme di.” ");
INSERT INTO mti_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Meve mu waya, “Nu divi oya taibe watan igiyawa da yobaton? Nu membo noive meme anotu.” ");
INSERT INTO mti_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Meve iyayapan undag wan yoig Pairat gumbe Iesu aug amiya. ");
INSERT INTO mti_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mu Iesu gumbe amatog kukaeba diyag veme, “Nu yautu apan mame iyayapan numa kuiyowa watpipam munivi. Me Siisa gumbe takesi den tepe me iyayapan dirumivi, sira ne kin Keriso waivi.” ");
INSERT INTO mti_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pairat singui ane, “Ge Ju igiyawa kin mumawa?” Iesu garawa wane, “Ge natawa vege, ne meme di.” ");
INSERT INTO mti_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pairat me tobiyag pirisi koukawa ge iyayapan gumbo dirum wane, “Ne yauna, apan mame danave kukaeba da onan.” ");
INSERT INTO mti_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Megara mu gae yusipamit diyag waya, “Apan mame toyau meuma at Judia undag iyayapan danowa undag aune. Gariri apa amatog on mame uwane.” ");
INSERT INTO mti_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pairat mame anonewa singui ane, “Apan mame Gariri apan?” ");
INSERT INTO mti_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Me yaug anone me Erod yusiwa ankwatave wakenewa. Sira tate me baraune Erod oya aine. Kuiyawa kum me kumiwa apa Erod Jerusarem apa wakene. ");
INSERT INTO mti_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Erod Iesu yaunewa degadega kokavit ane. Kuiyawa me gaiyawa anone, kum yobutatae me imive me yautan anoivi, sira me irayauyau meuma yautan anoivi. ");
INSERT INTO mti_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Meoya me gumbe singui obiren ane, megara Iesu garawa den wane. ");
INSERT INTO mti_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pirisi koukawa ge Gwangwan toewanewan igiyawa mu yokek gae kukaeba me gumbe yusipamit diyag veme. ");
INSERT INTO mti_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Meve Erod ge mut igiyawa meumawa me iviwa aug yan barauya iyagau waniya. Meve wape oraimina en waniya barauya Pairat oya taig aine. ");
INSERT INTO mti_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Oiyat me, Erod ge Pairat yaire aya. Namu mu anavi eme. ");
INSERT INTO mti_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairat me pirisi koukawa, namuyoiyoi igiyawa ge iyayapan auwane mu onamiya. ");
INSERT INTO mti_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Mu dirumne, “Ye apan mame nenan aug onekke sira aib wayana. Apan mame namuyoiyoi gwambe aivi. Ne gare ye namuyap epinawa yobana, megara me kukaeba meuma kuiyawa da den yaug anona. ");
INSERT INTO mti_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erod me meib. Me sira me baraune nunan onne. Yauya, me kukaeba da den ane bo atan oya. ");
INSERT INTO mti_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Meoya ne murap gumbe tog meve kwetna aipe.” ");
INSERT INTO mti_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(-) ");
INSERT INTO mti_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iyayapan undagit nouwa desiromit kwaruwaya, “Apan mame toengura, ge Barabas aropa dauwag nunan ompe.” ");
INSERT INTO mti_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas me nog aig wakene, kuiyawa at kokawa danave me mut amatone sira iyayapan gudne oya.) ");
INSERT INTO mti_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pairat imive Iesu yankwepe aipe, meoya mu gumbo sira wane. ");
INSERT INTO mti_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Megara mu kwaruwaya, “Me korosi gumbe toya! Korosi gumbe toya!” ");
INSERT INTO mti_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Sira me mu gumbo koni duwamdesiyawa wane, “Megara me kukaeba divi da ane? Ne kukaeba meuma bo totanwa me ne da den yauna. Meoya ne aug murap gumbe totna meve kwetna aipe.” ");
INSERT INTO mti_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Megara mu kwat wansin ande veme. Mu imuwo me yoma korosi gumbe tope botope. Mu kwat mumawa natawa matadne. ");
INSERT INTO mti_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Meoya Pairat iyayapan noiwa aune sira yoig wane mu imuwo gumbe ape. ");
INSERT INTO mti_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Sira Pairat Barabas kwene aine, mu imuwo gumbe. Apan me mut amatone sira iyayapan gudne oya nog aigne wakene. Pairat Iesu mu nanuwo baraune sira mu Iesu gumbe anoano muma gumbe aya. ");
INSERT INTO mti_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mu me auwag amomewa, Sairin apan iviwa Saimon me at meuma apa oniviwa mu auya. Mu yoma korosi oieve baraug diyag waya. Me aug Iesu amave yoine. ");
INSERT INTO mti_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iyayapan obiren Iesu amave amiya, sira vesin obiren gaibu danadawai auwag it menan wag amome. ");
INSERT INTO mti_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Megara Iesu munan tobiyag wane, “Jerusarem gwaitawaiwa, it nenan den waya, go yembo yenan ge ud yeuma oya iruwaya. ");
INSERT INTO mti_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kuiyawa, yauya, kum me onivi iyayapan aib wapewa, ‘Agara vesin, danowo ud onanwa, sira ud am den munemewa, mu gumbo waribiya wakeigimpe!’ ");
INSERT INTO mti_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kum me kumiwa, iyayapan tui gumbe amatog wape, ‘Egunup aiga,’ sira tui kusikaren gumbe wape, ‘Um nuna.’ ");
INSERT INTO mti_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mu yoma kaninga gumbe dividivi mame apewa, yoma toyainewa gumbe aninin ape?” ");
INSERT INTO mti_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kukaeba igiyawa duwam gaibu me gaibu bo atan oya tam amiya. ");
INSERT INTO mti_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mu amog at iviwa Kuiyamarednawa vemewa uwaya. Meve Iesu yoma korosi gumbe toya sira apan kukaeba duwam gaibu guriya. Dawa naniyutanwa dawa naniketaiwa apa. ");
INSERT INTO mti_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Iesu wane, “Maman, kukaeba muma anog yankwema. Mu den yawag anoya mu divi eme.” Mu kae kusida aya wape meuma keptetan oya. ");
INSERT INTO mti_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iyayapan yokeg yangureme. Namuyoiyoi igiyawa iyagau me gumbe waya, “Me iyayapan upeba waita munne. Apan mame God wagomiyanewa Keriso ipewa, me membovit warinampe.” ");
INSERT INTO mti_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mut igiyawa uwake iyagau me gumbe aya, sira omoke wain sisipama waniya. ");
INSERT INTO mti_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mu waya, “Ge Ju igiyawa kin mumawa ipewa, ge gembovit inaigita.” ");
INSERT INTO mti_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Me egave gae mame teya: MAME JU IGIYAWA KIN MUMAWA. ");
INSERT INTO mti_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apan kukaeba desirom yoma korosi gumbe toyawa Iesu gumbe iyagau wane, “Ge Keriso ipewa, ge gembovit ge nu gaibu warinam nuna.” ");
INSERT INTO mti_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Go apan kukaeba dawa garawa wane aib diengudne. “Ge God aeba den ege? Ge ibnawa gina desirom auege. ");
INSERT INTO mti_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu ibnawa nuniyawa me bainda. Kuiyawa garawa me atuwa nu aviete. Go apan mame kukaeba da den ane.” ");
INSERT INTO mti_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Meve kukaeba abnawa da dig wane, “Iesu, toimu geuma danave unig Ayapan awa kumiwa apa, nenan imug anoa.” ");
INSERT INTO mti_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iesu menan aib garawa wane, “Ne ge natawa dirugeni. Gare ge ne gaibu paradais danave waketa.” ");
INSERT INTO mti_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kum kuiyunup mina aune. Sisip at undag umne aine augoi adne kum koniwa duwamdesi aune. ");
INSERT INTO mti_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kum tobiroriyane sisip uwag onne. Temporu danave wape gwarapama, me yapave viyodne aigne duwam ane. ");
INSERT INTO mti_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iesu au kokavit wane, “Maman, ge nanigap ne guwanwa barautna.” Meib wag gaup meuma oieba pukuwane. ");
INSERT INTO mti_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Senturion yaune divi matadne. God watdegawan wane, “Natawa di, Apan mame oraivit di abnawa.” ");
INSERT INTO mti_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iyayapan undag yanguratan oya onam agoniyayawa, mu undag yauya divi matadne. Mu danadawai gaibu togewo toya sira taig amiya. ");
INSERT INTO mti_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Megara Iesu yaug anoyawa igiyawa ge vesin mu at Gariri apa amave onamiyawa, at painau yoike dividivi undag mame yangureme. ");
INSERT INTO mti_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Gare apan iviwa Josep wakene, me Daiboru Painauvitwa igiyawa intum anewa, me apan oraiwa sira ano kukaeba den anoiviwa. ");
INSERT INTO mti_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Apan mame kansoru igiyawa nouwa ge mu atan ayawa gumbe den kiniyane. Me at Arimataya abnawa, at me Ju igiyawa gwetoimu mumawa. Me God toimuwawa yautan amaraivi. ");
INSERT INTO mti_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Apan mame Pairat gumbe aine, sira imive Iesu kwapiwa autan oya wane. ");
INSERT INTO mti_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Meve me aug aigne. Me wape gumbe panke sira aug aig dagup me buinunu kwapiya apa baraune. Me apa iragi numan da den barauya. ");
INSERT INTO mti_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kum me Tamibarip Kumiwa, sira Sabat Kumiwa koni uwatan aivi. ");
INSERT INTO mti_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Vesin gaibu me amowo onamiya. Mu at Gariri apa Iesu amave onamiyawa. Mu dagup yauya, me kwapiwa aninin barauyawa yauya. ");
INSERT INTO mti_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Meve mu sira taig amiya, gegura ge oira tayapama tamibarip aya. Megara mu Sabat Kumiwa oya gwangwan gumbe nonowa emiya. ");
INSERT INTO mti_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pura danave kum namuirenwa, mumbevit vesin mu gegura me kwapiwa barautan oya mu tamibarip ag tam dagup amiya. ");
INSERT INTO mti_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mu yauya an dagup gumbe wait itari aya. ");
INSERT INTO mti_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Meve mu unigiyawa, Ayapan Iesu kwapiwa den wakene yauya. ");
INSERT INTO mti_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mu ano pimpanum emewa, apan duwam wape pupuyu esiviwa enke namuwo yoiya. ");
INSERT INTO mti_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mu a ake kwanowa yan piyu gumbe siya. Megara mu mu gumbo waya, “Divi oya ye wakeiviwa abnawa oya bo danowo yobene? ");
INSERT INTO mti_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Me mapa onan. Me sira inaig yoine. Me ande at Gariri apa wakenewa kumiwa apa, me ye diruinewa imug teg anoya. ");
INSERT INTO mti_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Me aib wane, ‘Apan Usiwa me aug kukaeba igiyawa nanuwo baraupe. Yoma korosi gumbe tope botope. Kum duwamdesiyawa apa me sira inaig yoipe.’” ");
INSERT INTO mti_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Meve mu gae meuma sira imug teg anoya. ");
INSERT INTO mti_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mu sira dagup gumbe taigiyawa, aigowawa 11 ge iyayapan upeba undag dividivi mame undag dirumiya. ");
INSERT INTO mti_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Vesin mu ivuwa me Magdara vesin Meri, Joanna ge Meri me Jemus inawa. Sira vesin upeba mu gaibu wakeyawa apasoro igiyawa dividivi mame undag dirumiya anoya. ");
INSERT INTO mti_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Megara apasoro igiyawa anoya gae mumawa natawa mina onan. Meoya vesin gumbo anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Megara Pita wan yoig dagup oya kintog aine, me kwanawa sig dagup danave yaunewa, wape rinen mekut wakene. Me mame gumbe terag gwe sira taig aine. ");
INSERT INTO mti_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sira kum me desirom danave, mu duwam gwetoimu iviwa Emaus amome. Me Jerusarem gumbe yobu meuma 11 kiromitas mina. ");
INSERT INTO mti_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mu dividivi undag pawanewa oya gae garawa eme. ");
INSERT INTO mti_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Mu gae wag yugeyau ag amomewa, Iesu membo me apa uwane mu gaibu amiya. ");
INSERT INTO mti_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mu yaimoyai den yaveme, meoya Iesu irawa yaiyai den yauya. ");
INSERT INTO mti_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Me singui munne, “Ye divi oya gae garawa ano ag aisiene?” Mu anogugut ag tum ag yokeya. ");
INSERT INTO mti_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Apan dawa iviwa Kreopas garawa wane, “Ge Jerusarem apa wakeyana. Megara me apa kum me kumiwa dividivi pawanewa gekut den anoana?” ");
INSERT INTO mti_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Me singui wane, “Me divi?” Mu me gumbe waya, “Nasaret Apan Iesu oya. Me propeta. Me God ge iyayapan undag namuwo gae wag anewa me yusiatatu. ");
INSERT INTO mti_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pirisi koukawa ge namuyoiyoi igiyawa numawa boatan gaiyawa oya wag barauya. Sira mu yoma korosi gumbe toya botone. ");
INSERT INTO mti_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Megara nu anotu me Isuraeru waita wampe. Sira dividivi undag mame gaibu, dividivi mame pawanewa gare mame kum duwamdesiyawa. ");
INSERT INTO mti_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Megara nu vesin numa upeba waya, nu teratu. Mu gare mumbevit babat amiya. ");
INSERT INTO mti_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Megara me kwapiwa den yauya. Mu sira taig onam didnuniya, mu aneya guwaguwawa yauya. Sira mu waya me sira inaig wakene. ");
INSERT INTO mti_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kum me kumiwa apa, iyayapan numa upeba dagup amiya. Sira yauyawa me aninin vesin waya mina yauya, go mu me den yauya.” ");
INSERT INTO mti_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Me munan wane, “Ye kuiyewa onan. Dividivi propeta wayawa undag anotumat den ene kusi da mapa di. Ye nonemagewa yaigiwane oya den anoene. ");
INSERT INTO mti_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Keriso dividivi edawai mame auke, meve eyawa meuma danave unikpe.” ");
INSERT INTO mti_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Meve me namu Mosisi ge propeta gigirumawa undag gumbo amatog, Baiboru danave aninin membo mu teyawa toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mu gwetoimu me oya amomewa koni uwatan emewa, megara Iesu yauyawa me namuwo aivi. ");
INSERT INTO mti_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mu me yusipamit wataig waya, “Gunup wakeya. Kuiyawa kum aigivi, aram uwatan aivi.” Meoya Iesu unig aine mu gaibu wakeya. ");
INSERT INTO mti_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iesu nakwai oya mu gaibu yanwakeya. Me bredi auke, gaun wag warensine mu munne. ");
INSERT INTO mti_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Sira mu yangowo watabnewa, mu apan me Iesu yaug anoya. Megara me mu yapowo inanadne. ");
INSERT INTO mti_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mu garawa ano aya. “Me epin taibe didnuniviwa, sira me Baiboru didnuniviwa, nonunwa idne. Natawa di.” ");
INSERT INTO mti_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tatevit mu wan yoike Jerusarem taig amiya. Me apa apasoro 11 ge iyayapan mu agoniemewa mu yawamiya. ");
INSERT INTO mti_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sira mu veme, “Keriso sira inaine me natawa di. Me Saimon gumbe uwane.” ");
INSERT INTO mti_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mu dirumiya aninin epin taibe pawane. Sira me bredi warensinewa, kum me kumiwa mepe Iesu yaug anoya. ");
INSERT INTO mti_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mu gae mame ande vemewa, Iesu membo mu yapowo yoine. Sira me mu gumbo wane, “Yum ye guniyap.” ");
INSERT INTO mti_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mu terake a aya, sira mu anoya guwawa yaveme. ");
INSERT INTO mti_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Iesu mu gumbo wane, “Ye divi oya daneyap anoene? Divi oya pimpangitene? ");
INSERT INTO mti_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Naninwa amanwa yauya. Ne meme. Yumneg yauya. Kuiyawa guwawa me mame mina kwapiwa ge marednawa gaibu onan. Ye yavene ne kwapunwa ge marednanwa gau.” ");
INSERT INTO mti_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Me gae mame onananewa naniwa ge amawa toyau munne. ");
INSERT INTO mti_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mu degadega kokavit ag teraya, meoya mu ande anotumat den aya. Me dirumne, “Gare mapa ye divi da wakene, ne natna?” ");
INSERT INTO mti_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Mu gwambui idnewa simiwa waniya. ");
INSERT INTO mti_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Me aug mu namuwo nane. ");
INSERT INTO mti_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Me mu gumbo wane, “Ne ande guniyap wakenawa mame diruina. Mosisi Gwangwaneba, propeta bukaeba ge Sam bukaeba danave nenan teyawa dividivi undag matatpe.” ");
INSERT INTO mti_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Meve mu Baiboru natawa yaug anotan oya Iesu nono magowa watabne. ");
INSERT INTO mti_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mu dirumne, “Mapa aib tene. Keriso edawai aupe, bo ape sira kum duwamdesiyawa apa boriruwayawa igiyawa gumbo sira inaig yoipe. ");
INSERT INTO mti_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nonenmagowa biroriyatanwa ge kukaeba anog yankwetanwa oya Iesu iviwa gumbe at undag opata wape. Jerusarem apa amatope. ");
INSERT INTO mti_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ye dividivi undag mame yauyanawa igiyawa. ");
INSERT INTO mti_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Maman agi wanewa yenan barautna aikpe. Megara gare gwetoimu kokawa danave wakeya, ivi yusiwa painauwa opa aigon ye wape mina en yempe yusiwa auya.” ");
INSERT INTO mti_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iesu mu tamne at Betani visive dauwag amiyawa, me naniwa enagadne, mu waribiya munne. ");
INSERT INTO mti_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Me waribiya mun, mu kwem kwimin danave dog aine. ");
INSERT INTO mti_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mu degadega koka gumbe at Jerusarem taig amiya. ");
INSERT INTO mti_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mu temporu arawa danave evedni wakeeme. God watdega waneme. ");
INSERT INTO mti_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Namuiren amatonewa me apa Gae wakene, sira Gae me God gaibu, sira Gae me God. ");
INSERT INTO mti_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Namuiren amatonewa me apa me God gaibu wait wakene. ");
INSERT INTO mti_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Me gumbe dividivi undag waramne. Dividivi undag waramnewa yapowo me gumbe den wadnewa divi da den wakene. ");
INSERT INTO mti_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Me danave inaiinai wakene, sira inaiinai mame me eyawa iyayapan munan. ");
INSERT INTO mti_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Eyawa me sisip danave esivi, megara sisip me den yaug anone. ");
INSERT INTO mti_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Apan da God baraunewa me uwane; me iviwa Jon. ");
INSERT INTO mti_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Me taibe watan oya uwane. Me eyawa oya taibe watan oya, sira iyayapan undag me gumbe anotumat atan oya. ");
INSERT INTO mti_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Me eyawa onan, megara me eyawa oya taibe watan oya uwane. ");
INSERT INTO mti_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Eyawa natawa me iyayapan undag gumbo esipewa me piyu mame uwatan aivi. ");
INSERT INTO mti_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Me piyu mame apa wakene, sira piyu mame me gumbe wadne, megara piyu mame me den yaug anone. ");
INSERT INTO mti_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Me at meuma uwane, megara iyayapan meuma me den auya. ");
INSERT INTO mti_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Megara bira bira undag me auyawa sira me iviwa gumbe anotumat ayawa, God usitainawa atan oya yusiwa munne: ");
INSERT INTO mti_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Mu diyawa mumawa go kwapiwa anoanowawa go iyayapan ano mumawa gumbe den yaiya, megara God gumbe yaiya. ");
INSERT INTO mti_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gae me kwapiven ane, sira me gunup wakene. Nu me eyawa meuma yautu. Eyawa mame me Usiwa desiromiren eyawa. Me Mamawa gumbe onne. Eyawa me ano oraiwa ge ano natawa gumbe noidauwane. ");
INSERT INTO mti_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon me me oya taibe wane. Me kwaruwag wane, “‘Apan da ne amanap uwapewa ne minan onan me yusipama, kuiyawa me ne namunap wakene,’ ne wait wanawa, me apan mame oya wana.” ");
INSERT INTO mti_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Me gumbe ano oraiwa noidauwane. Me gumbe nu undag ano oraiwa egave noidauwanewa autu. ");
INSERT INTO mti_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kuiyawa Gwangwan Mosisi gumbe nunne, megara ano oraiwa ge ano natawa Iesu Keriso gumbe uwane. ");
INSERT INTO mti_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Bira da God den yaune. Megara Usiwa Desiromiren mekut me Mamawa gumbe wakenewa me taibe wag toyau nunne. ");
INSERT INTO mti_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jon taibe wanewa me mamaib. Ju igiyawa mu pirisi ge Rivai igiyawa teya amiya, Jerusarem apa me gumbe singui ag yautan oya amiya. Mu singui ag waya, “Ge bira?” ");
INSERT INTO mti_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Me den yan umune. Me garawa taibe di wane, “Ne Keriso onan.” ");
INSERT INTO mti_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Sira mu me gumbe singui aya, “Meve, ge bira? Ge Eraija, go?” Me wane, “Ne me onan.” “Ge propeta da?” Megara wane, “Onan.” ");
INSERT INTO mti_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Meve mu waya, “Ge bira? Gae natawa didnuna. Nu tenuniya onantuwa igiyawa gumbo nu wata anope. Ge gembo anin wamon?” ");
INSERT INTO mti_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Me gara wane, “Propeta Aisaya gae meuma gumbe wane mina, ne at inguiwa arawa danave, ‘Ayapan oya ebu siwavit waribiya,’ auwaiviwa abnawa noiwa.” ");
INSERT INTO mti_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mu Parisi igiyawa gumbo temuniya onamiya. ");
INSERT INTO mti_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mu me singui aya, “Ge Keriso onan, go Eraija onan, go propeta onan ipewa, divi oya ge babataito ege?” ");
INSERT INTO mti_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jon gara wane, “Ne yoi gumbe babataito eni. Megara desirom da den yaug anoyanawa me guniyap yokene. ");
INSERT INTO mti_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Apan me ne amanap uwapewa, ne oma den ane sandoro murap meuma vetna.” ");
INSERT INTO mti_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Dividivi mame yoi Jodan gambenwa apa at Betani apa pawane. Me apa Jon babataito aivi. ");
INSERT INTO mti_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Umaipa, Jon me Iesu me gumbe onivi yaug wane, “Yauya, God Sip Usiwa, me piyu undag kukaeba muma tam aipe! ");
INSERT INTO mti_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘Apan me ne amanap uwape. Me koka ne kudnausiren. Kuiyawa me ne namunaba,’ ne meib wait veniwa, apan mame oya. ");
INSERT INTO mti_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ne nembo me den yaug anona. Megara apan mame matai iyai Isuraeru gumbo taibe atan oya ne uwag yoi gumbe babataito eni!” ");
INSERT INTO mti_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Meve Jon taibe dirumne. “Ne Guwawa me umug mina kwimin apa aig onne sira me egave wakene yauna. ");
INSERT INTO mti_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne nembo me den yaug anona. Megara God me ne yoi gumbe babataito atan oya baraunednewa wag didnedne, ‘Guwawa apan da egave aig on wakepe yawawa, me Guwawa Iyakaisiyapama gumbe babataito ape.’ ");
INSERT INTO mti_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne yauna, meoya ne taibe veni apan mame me God Usiwa.” ");
INSERT INTO mti_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Umaipa, Jon me aigowawa duwam gaibu yokeya. ");
INSERT INTO mti_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Me Iesu uwag aivi yaune, me wane, “Yauya, God Sip Usiwa!” ");
INSERT INTO mti_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aigowawa duwam me meib wane anoyawa, mu Iesu amave amiya. ");
INSERT INTO mti_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iesu tobiyag mu amave amomewa yawam dirumne, “Ye imuyep dimbae?” Mu waya, “Rabai, (Me tobiyak tenewa, toewanewan), ge ampa wakeege?” ");
INSERT INTO mti_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Me gara wane, “Oneg yauya.” Meve mu amiya sira me wakeiviwa arawa yauya. Sira kum me, me gaibu wakeya. Kum koniwa me augoi 4 mina. ");
INSERT INTO mti_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jon aigowawa duwam mu Jon wanewa anoyawa Iesu amave amiya. Desirom da me Andru, me Saimon Pita gwaneba. ");
INSERT INTO mti_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Me namu tatawa Saimon didimama ag yaug dine, “Nu Mesaiya yautu.” (Mesaiya tobiyak tenewa me Keriso). ");
INSERT INTO mti_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Sira me Iesu gumbe Saimon aug onne. Iesu me yaune sira wane, “Ge Saimon, Jon usiwa. Ge ivugwa Kepas dirugeni.” (Me tobiyak tenewa me Pita). ");
INSERT INTO mti_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Umaipa Iesu me Gariri aitan anone. Pirip yaunewa me gumbe wane, “Amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Andru ge Pita mina, Pirip me Betuseida apa onnewa. Mu gwetoimu desirom. ");
INSERT INTO mti_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pirip me Natanieru didimama aigin yaune sira dig wane, “Nu apan da yautu. Menan oya Mosisi Gwangwan danave tene sira propeta teya. Me Nasaret apan Iesu, Josep usiwa.” ");
INSERT INTO mti_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanieru wane, “At Nasaret apa oma ane divi da oraiwa uwape, go?” Pirip wane, “Onag yawa.” ");
INSERT INTO mti_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iesu Natanieru me gumbe ob maniviwa yaune wane, “Mame me Isuraeru apan di, me gumbe uga onan.” ");
INSERT INTO mti_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanieru Iesu gumbe wane, “Ge aninin ne yauneg anoege?” Iesu gara wane, “Ge yoma inaru ankwatave wakeege yawagna. Meve ivi Pirip genan auwane.” ");
INSERT INTO mti_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Meve Natanieru gara wane, “Rabai, ge God Usiwa. Ge Isuraeru kin mumawa.” ");
INSERT INTO mti_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iesu gara wane, “Ge yoma inaru ankwatave wakeege yawagna ne ge dirugna, meoya ge anotumat ana? Ge dividivi kokawa matai yawa.” ");
INSERT INTO mti_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Meve me gumbe wane, “Ne natawa di dirugeni. Kwimin watappe, sira God aneya meuma Apan Usiwa egave aig ge dauwa aigimpewa ge matai yawa.” ");
INSERT INTO mti_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kum duwamdesiyawa, Gariri dana at Keina apa memgebip eme, Iesu inawa me apa gaibu, ");
INSERT INTO mti_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","memgebip oya Iesu ge aigowawa gaibu munan eb teya uwaya. ");
INSERT INTO mti_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wain onananewa Iesu inawa me gumbe wane, “Mu wain onan.” ");
INSERT INTO mti_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iesu gara wane, “Vesin, ge dimbae oya ge gungap nau atna vege? Ne kum neuma den uwane, me matai.” ");
INSERT INTO mti_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iesu inawa naueme igiyawa gumbo dirum wane, “Me anin diruipewa undag me gumbe aya.” ");
INSERT INTO mti_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gare asimeve uinoum me an gumbe wariyawa 6 wakeya. Uinoum me Ju igiyawa inaiinai mumawa gumbe mu muintan oya wakeyawa. Uinoum desirom me yoi utpe noidauwapewa me 75 go 115 ritas mina. ");
INSERT INTO mti_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iesu mu gumbo wane, “Uinoum yoi avenam waramiya noidauwape.” Mu yoi avenam waramiya uinoum noidauwaya. ");
INSERT INTO mti_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Meve Iesu me mu dirum wane, “Gare mame di utamiya. Sira buyunai amaraiviwa kokawa gumbe tam aisiya.” Mu meib wanewa mina di aya. ");
INSERT INTO mti_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Sira buyunai amaraiviwa kokawa yoi me tobiyane wain anewa nag anone. Me den yaug anone me ampa onne. Megara naueme igiyawa yoi usiyawa mu yaug anoya. Meve me memgebip abnawa menan auwag, ");
INSERT INTO mti_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","wane, “Bira bira da namu wain demtapama oraiwa tam onampe. Amdau igiyawa kokavit nape onanapewa meve wain demta onanwa tam onampe. Megara ge di wain oraiwa barauwana wakene gare mame di.” ");
INSERT INTO mti_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iesu mame irayauyau namuirenwa Gariri dana at Keina apa ane. Me eyawa meuma taibe ane, sira aigowawa anotumat muma me gumbe aya. ");
INSERT INTO mti_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Meve ivi Iesu inawa, gwanebaviwa ge aigowawa gaibu Kapenaum aig amiya. Me apa kum koni kusida wakeya. ");
INSERT INTO mti_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ju igiyawa Uwag Gaveya Buyunaeba muma di koni aiviwa Iesu Jerusarem dog aine. ");
INSERT INTO mti_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Temporu arawa danave iyayapan burumakau, sip ge umug gwiruwareme yawamne. Sira anmaga garawa tobieme igiyawa wakeeme yawamne. ");
INSERT INTO mti_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Meoya me murap kusi wariyawa me gumbe temporu arawa apa undag gud atatai imne. Iesu sip ge burumakau atatai imne, sira anmaga garawa tobieme igiyawa anmaga mumawa tam egamne sira teboro muma tam tobiyane. ");
INSERT INTO mti_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Iyayapan mu umug gwiruwaremewa gumbo me wane, “Dividivi mapa tam dauwag aisiya! Maman gweyawa den tobiyaya gwiruwareme gweyawa den ape! ");
INSERT INTO mti_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Me aigowawa mu imug anoya me wait Baiboru gumbe aninin teg wanewa, “Ge gwe geuma oya anoeniwa nonenmagawa danave iyam mina igivi.” ");
INSERT INTO mti_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Meoya Ju igiyawa me gumbe gara waya, “Divi divi mame ge ana oya, irayauyau divi da nu gunup toyau nuna yauton ge yutugwa toyau nuntan oya?” ");
INSERT INTO mti_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iesu gara mu gumbo wane, “Temporu mame yayag wakukamiyawa, ne kum duwamdesi danave sira sitna.” ");
INSERT INTO mti_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ju igiyawa gara waya, “Temporu mame sieme bairawan 46 aune. Sira ge kum duwamdesi danave oma ane sira siya?” ");
INSERT INTO mti_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Megara temporu me Iesu wanewa me membo kwapiwa oya wane. ");
INSERT INTO mti_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Me ivi boane sira inainewa, aigowawa me wait meib wanewa imug teg anoya. Meve Baiboru ge gae Iesu wanewa gumbe mu anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Uwag Gaveya Buyunaeba oya Iesu Jerusarem apa wakenewa, Iesu irayauyau aivi iyayapan obiren yauya, sira me iviwa gumbe anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Megara Iesu membo anotumat den munne. Kuiyawa iyayapan undag nonomagowa me yaug anone. ");
INSERT INTO mti_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Me apan gumbe bira bira taibe watanwa me anotan den anoivi, kuiyawa iyayapan nonomagowa danave divi wakenewa me membo yaug anone. ");
INSERT INTO mti_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Parisi apan da iviwa Nikodemas wakene. Me Ju namuyoiyoi abnawa da. ");
INSERT INTO mti_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Me Iesu gumbe arampuna onne, sira me gumbe wane, “Rabai, nu yaugem anotu ge toewanewan abnawa God gumbe onaganawa. Kuiyawa God me gumbe den wakenewa, bira da oma den ane ape irayauyau ge egewa.” ");
INSERT INTO mti_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iesu gara me gumbe wane, “Ne ge natawa di dirugeni. Bira da sira den yaipewa me oma den ane God toimuwawa yaupe.” ");
INSERT INTO mti_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemas wane, “Megara aninin oma ape apan me wait tayawa anewa sira yai yoipe? Natawa di, me oma den ane inawa dana sira unikpe sira yaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iesu gara wane, “Ne ge natawa di dirugeni. Bira da yoi ge Guwawa gumbe sira den yaipewa, oma den ane God toimuwawa unikpe. ");
INSERT INTO mti_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kwapiwa gumbe yaipewa me kwapiwa, megara Guwawa gumbe yaipewa me guwawa. ");
INSERT INTO mti_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ne wana, ye sira di yaiya. Megara gae neuma veniwa gumbe den anopipanum a. ");
INSERT INTO mti_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Taig me anoiviwa gumbe viyaivi, sira ge noiwa anoa. Megara ge den yaug anoana me ampa onivi go ampa aivi. Iyayapan guwawa gumbe yaiyawa me mina di.” ");
INSERT INTO mti_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemas gara wane, “Mame me aninin?” ");
INSERT INTO mti_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iesu gara wane, “Ge Isuraeru toewanewan mumawa, megara mame ge den yaug anoege? ");
INSERT INTO mti_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ne natawa di dirugeni. Nu yaug anotuwa gae vete, sira nu yautuwa taibe vete. Megara ye nu vetewa ande den yaug anoene. ");
INSERT INTO mti_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ne dividivi at piyu mame danavewa oya ye guniyap wanawa ye den anotumat ayanawa, ne dividivi kwimin danavewa oya watna ipewa me aninin anotumat aya? ");
INSERT INTO mti_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Bira da kwimin den dog aine, megara desirom me kwimin apa aeg onnewa wakene. Me Apan Usiwa. ");
INSERT INTO mti_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mosisi at inguiwa arawa apa mokare enagadne mina di, Apan Usiwa me enagappe. ");
INSERT INTO mti_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Iyayapan undag mu Apan Usiwa gumbe anotumat emewa mu inaiinai yaibobot aupe.” ");
INSERT INTO mti_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God baigan meuma kokavit at piyu mame gumbe, meoya me Usiwa Desiromiren munne. Bira da me gumbe anotumat apewa me bo den ape inaiinai yaibobot aupe. ");
INSERT INTO mti_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God piyu mame pui yutan oya Usiwa den baraune onne, me piyu mame me gumbe waita muntan oya. ");
INSERT INTO mti_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Bira da Usiwa gumbe anotumat apewa, me gumbe pui den yupe. Megara bira da anotumat den anewa, me gumbe wait pui aune. Kuiyawa me God Usiwa Desiromiren iviwa gumbe anotumat den ane. ");
INSERT INTO mti_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Puiyuyu me mame mina. Eyawa piyu mame uwane. Megara iyayapan eyawa gumbe topai aya sisip gumbe baigan aya, kuiyawa dividivi muma emewa me kukaeba. ");
INSERT INTO mti_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bira da kukaeba aiviwa me eyawa topai aivi, sira matai eyawa gumbe den ompe, kuiyawa me divi anewa matai taibe ape oya a aivi. ");
INSERT INTO mti_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Megara bira da natawa gumbe aiviwa me eyawa gumbe ompe. Kuiyawa dividivi me aiviwa God gumbe aivi, sira me di taibe ape yautanwa oya. ");
INSERT INTO mti_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mame ivi, Iesu aigowawa gaibu at Judia apa amiya, sira me apa mu gaibu wakeya. Sira me babataito amunivi. ");
INSERT INTO mti_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon me mina at Sarim megiyave at Aenon apa babataito amunivi. Kuiyawa me apa yoi koka. Sira iyayapan kum evedni babataito atan oya omome. ");
INSERT INTO mti_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Kuiyawa kum mame apa, Jon nog danave den barauyave. ");
INSERT INTO mti_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Meoya wat muintanwa oya, garawa ano atanwa pawane Jon aigowawa ge Ju igiyawa mu yapowo. ");
INSERT INTO mti_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mu Jon gumbe onam waya, “Rabai, apan me ge gaibu yoi Jodan gambenwa apa wakeyanawa, me gumbe ge taibe wanawa, me babataito amunivi, sira iyayapan undag me gumbe omome.” ");
INSERT INTO mti_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon gara wane, “Apan oma den ane divi da aupe, kwimin apa wannewa mekut aupe. ");
INSERT INTO mti_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ye yembovit ne divi wanawa yauneg anoyanawa igiyawa, ‘Ne Keriso onan, ne baraunedne me namiven onednawa.’ ");
INSERT INTO mti_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Memgebip vesinawa aupewa me memgebip abnawa. Eveba me memgebip abnawa oya wakeg me gaiyawa anoivi. Sira memgebip abnawa noiwa anoiviwa, me degadega kokavit aivi. Ne gaibu degadega gumbe noidauwane. ");
INSERT INTO mti_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Me uwag kokavit di ape, ne kudnausiren di atna.” ");
INSERT INTO mti_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Apan bira painau uwanewa me iyayapan undag egowo wakene. Apan piyu mame apa uwanewa me piyu mame wakene, sira gae wapewa me piyu mame oya wape. Apan me kwimin apa uwanewa me iyayapan undag egowo. ");
INSERT INTO mti_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Me yaunewa ge anonewa oya gae wape, megara bira da me taibe wanewa den aune. ");
INSERT INTO mti_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bira da me taibe wanewa aunewa me bainda wag kiniyane God me natawa di. ");
INSERT INTO mti_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kuiyawa apan me God baraune onnewa God gae meuma waivi. God me Guwawa wanivi om gumbe onan. ");
INSERT INTO mti_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamawa me Usiwa gumbe baigan niyaivi sira dividivi undag me nanive tene. ");
INSERT INTO mti_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bira da Usiwa gumbe anotumat aigimpewa me inaiinai yaibobot aupe, megara bira da Usiwa topayaiviwa matai inaiinai den yaupe, sira God danapiriwa me gumbe wakene.” ");
INSERT INTO mti_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Parisi igiyawa anoya Iesu me aigowawa obiren tamivi sira babataito amunivi. Jon tamnewa mina onan. Ayapan me yaug anonewa, ");
INSERT INTO mti_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","—go Iesu membo babataito den amunivi, aigowawa eme.— ");
INSERT INTO mti_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","me Judia kweg sira Gariri taig aine. ");
INSERT INTO mti_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Megara me at Samaria danave di dauwag aitanit di. ");
INSERT INTO mti_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Meve me at Samaria danave gwetoimu iviwa waya Sikaya uwane. At me Jekob me usiwa Josep oya piyu wannewa me megiyave. ");
INSERT INTO mti_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekob yoi dukup meuma me apa. Iesu aramavit onne uiwa topayadne oya yoi dukup visive yan wakene. Kum koniwa me kum kuiyunup mina. ");
INSERT INTO mti_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria vesin da yoi uttan oya uwane. Iesu me gumbe wane, “Garawapa yoi nega?” ");
INSERT INTO mti_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Me aigowawa nakwai gwiruwattan oya gwetoimu da amiya. ");
INSERT INTO mti_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria vesin me gumbe wane, “Ge Ju apan, sira ne Samaria vesin. Dimbae oya ne gunap yoi oya vege?” (Kuiyawa Ju igiyawa ge Samaria igiyawa yapowo baigan onan.) ");
INSERT INTO mti_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iesu me gumbe gara wane, “Ge God ano puyo meuma yaug anoa ipewa, sira bira yoi oya dirugiviwa anoa ipewa, ge ne didnekpawa, ne inaiinai yoiba gempopo.” ");
INSERT INTO mti_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vesin wane, “Kokawa, ge yoi uttanwa da den auwana, sira yoi dukup mame me epampa. Ge inaiinai yoiba me ampa aumon? ");
INSERT INTO mti_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ge kokavitwa? Nu mamunwa Jekob mina onan? Jekob yoi dukup mame nunne, sira me membo, me usitainawa ge mae bui meuma undag yoi dukup mame gumbe naya.” ");
INSERT INTO mti_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iesu gara wane, “Bira da yoi mame napewa me sira meyawa toyaipe. ");
INSERT INTO mti_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Megara bira da yoi ne wantnawa me napewa, matai meyawa sira den di toyaipe. Natawa di. Yoi me ne wantnawa me apan danave yamarogu ape sira yoi inaiinai yaibobot me apa dauwaigimpe.” ");
INSERT INTO mti_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Vesin me gumbe wane, “Kokawa, yoi me nega. Me gumbe ne meyanwa den toyaipe sira evedni yoi uttan oya mapa den onigimpna.” ");
INSERT INTO mti_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iesu vesin dine, “Aga, memag aug mapa taig oneya.” ");
INSERT INTO mti_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ne memanwa onan,” vesin gara wane. Iesu vesin gumbe wane, “Ne memanwa onan ge meib wanawa me natawa. ");
INSERT INTO mti_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kuiyawa ge memagwa nanin gambenit tamana, sira ge gare apan auwanawa me ge memagwa onan. Ge wanawa me natawa di.” ");
INSERT INTO mti_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Vesin wane, “Kokawa, ne gaitom yaugen anoeni ge propeta. ");
INSERT INTO mti_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu mamanaiwa tui mame egave waiya eme. Megara ye vene at me waiya atanwa me Jerusarem apa di.” ");
INSERT INTO mti_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iesu me gumbe wane, “Vesin, anotumat gunap a. Ye matai Maman gumbe waiya ayawa tui mame egave onan sira Jerusarem apa onan. Kum meiba matai onivi. ");
INSERT INTO mti_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Waita me Ju igiyawa gumbo ompe. Nu yaug anotuwa gumbe waiya ete. Ye den yaug anoyanawa gumbe waiya ene. ");
INSERT INTO mti_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Megara kumiwa me onivi. Me kumive, waiya natawa eme igiyawa mu guwawa ge natawa gumbe Mamanwa waiya ape. Gare me kumiwa. Kuiyawa Maman waiya meiba eme igiyawa didi mama aivi. ");
INSERT INTO mti_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God me Guwawa, meoya me gumbe waiya eme igiyawa mu guwawa ge natawa gumbe waiya di ape.” ");
INSERT INTO mti_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Vesin me gumbe wane, “Ne anona Mesaiya (Me iyayapan veme Keriso) onivi. Me uwapewa, dividivi undag nu gunup yaug ano numpe esipe.” ");
INSERT INTO mti_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Meve Iesu me gumbe wane, “Gae ge gungap veniwa ne me.” ");
INSERT INTO mti_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pungi den wane, aigowawa sira taig uwaya. Mu me vesin gaibu gae waiviwa yaug anopipanum aya. Megara bira da den wane, “Ge imugap dimbae?” go “Ge dimbae oya vesin gaibu gae vege?” ");
INSERT INTO mti_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Meve vesin me yoi uinoum, yan baraug sira taig gwetoimu aine, iyayapan gumbo wane. ");
INSERT INTO mti_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Oneg yauya. Apan da me dividivi ne anawa undag gunap wanewa wakene. Anten apan mame me Keriso go?” ");
INSERT INTO mti_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Meve mu gwetoimu apa dauwag me gumbe onamiya. ");
INSERT INTO mti_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dividivi mame pawaivi kumiwa apa, aigowawa me ayag waya, “Rabai, divi da nave.” ");
INSERT INTO mti_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Megara me mu gumbo wane, “Nakwai da ye den yaug anoyanawa me ne gunap.” ");
INSERT INTO mti_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Meve aigowawa gae garawa ano aya, “Bira da nakwai meuma tam uwane?” ");
INSERT INTO mti_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Me mu gumbo wane, “Ne nakwai neuma me ne baraunedne onednawa me anoiviwa atna sira me nau meumawa oieba watpukiyatna onanape. ");
INSERT INTO mti_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ye aib vene, go onan? ‘Dud 4 wakeya, meve maura kumiwa uwape.’ Ne ye diruitna. Yangewa meram nau wan yauya! Mu wait kweraimusia maura oya. ");
INSERT INTO mti_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Maura enivi abnawa me garawa meumawa wait amatog avivi, sira inaiinai yaibobot oya natawa agoniyaivi. Kuiyawa yawa veriviwa ge maura eniviwa maun degadega atan oya. ");
INSERT INTO mti_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Meib, gae me natawa, ‘Da me yawa verivi sira dawa me agoniyaivi.’ ");
INSERT INTO mti_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ye yembo nau kokavit den ayanawa agoniyag tamtan oya ne ye te yenna aisiyana. Upeba nau kokavit aya, sira nau mumawa gumbe ye natawa agoniyag tamiyana.” ");
INSERT INTO mti_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria igiyawa obiren gwetoimu me apa vesin taibe wanewa gaiyawa oya me gumbe anotumat aya. Kuiyawa vesin me wane, “Dividivi undag ne anawa me gunap wane.” ");
INSERT INTO mti_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Meoya Samaria igiyawa me gumbe uwayawa, me mu gumbo waketan oya nun waya. Me oiyat duwam wakene. ");
INSERT INTO mti_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Sira me gaiyawa gumbe iyayapan obiren upeba gaibu anotumat me gumbe aya. ");
INSERT INTO mti_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Mu vesin gumbe waya, “Nu gare ge wanawa oya anotumat den atu. Kuiyawa nu numbovit anoete, sira nu yaug anotu apan mame natawa di piyu mame Waita Abnawa.” ");
INSERT INTO mti_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kum duwam onananewa me kweg Gariri oya aine. ");
INSERT INTO mti_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesu membo taibe wane, “Iyayapan mu propeta gumbo arowo den ayamat a muneme.” ");
INSERT INTO mti_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Meoya me Gariri apa uwanewa, Gariri igiyawa kaiwa kaiwa gumbe baigan niyaya. Kuiyawa mu mina Uwag Gaveya Buyunaeba oya amiya, sira Jerusarem danave Uwag Gaveya Buyunaeba apa anewa undag mu yauya. ");
INSERT INTO mti_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Me at Keina Gariri danave sira aine. At asime apa me yoi tobiyane wain ane. Sira at Kapenaum apa kin nau meuma aiviwa wakene, me usiwa yuwat ane. ");
INSERT INTO mti_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Apan mame Iesu Judia apa on Gariri uwane anonewa me Iesu oya aine. Me gumbe aig on usiwa warinamtan oya nun wane. Kuiyawa me usiwa bo koni atan aivi. ");
INSERT INTO mti_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iesu me gumbe wane, “Ye irayauyau ge anopipanum den yauya ipewa, ye matai anotumat den di aya.” ");
INSERT INTO mti_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kin nau meuma aiviwa wane, “Kokawa, aig onaga, ne utunwa bo atan aivi.” ");
INSERT INTO mti_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iesu me gumbe wane, “Ge aga. Utugwa inaipe.” Apan me Iesu gae meuma me gumbe wanewa anotumat ane, sira kweg aine. ");
INSERT INTO mti_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Apan me ebu taibe, me nauwawa emewa yawamne. Mu dieg waya, “Utugwa inaine.” ");
INSERT INTO mti_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Meoya me singui wane, “Kum divi ud neuma inaine?” Mu me gumbe waya, “Kwapiwa amun watau augoi kum koniwa 1 mina apa kwene.” ");
INSERT INTO mti_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Mamawa meve anone kum me desirom apa Iesu me gunap wane, “Utugwa inaipe.” Meoya me membo ge biviusitainawa gaibu undag anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mame Iesu Judia kweg Gariri uwanewa irayauyau meuma duwameba ane. ");
INSERT INTO mti_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kum da ivi, Ju igiyawa Buyunai muma wakene, meoya Iesu Jerusarem dauwag aine. ");
INSERT INTO mti_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusarem apa, Ankwin Iviwa Sip wakene. Me megiyave paurum wakene. Paurum me gae Ibru gumbe me iviwa Betuseida waya. Sira me apa, ebu gwanob gaibu 5 wakeya. ");
INSERT INTO mti_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mame mu danowo, yuwat igiyawa—yangaboredmusiawa amogegeraimusiawa iruwaru enamiyawa—obiren parau vineme. Mu yoi aitanwa oya amareme. ");
INSERT INTO mti_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(-) ");
INSERT INTO mti_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mu danowo apan da yuwaranewa wakene, bairawan 38 onanane. ");
INSERT INTO mti_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iesu apan mame parau vinivi yaune, sira yaug anone me danadawai gumbe wakenewa kum yobtaren. Me dig wane, “Ge imugap inaigittan anoege?” ");
INSERT INTO mti_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yuwat abnawa gara wane, “Kokawa, yoi avit wariviwa kumiwa, paurum danave uniktan oya bira da den waita negivi. Ne uniktan eniwa, apan da me namunap aigivi.” ");
INSERT INTO mti_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Meve Iesu me gumbe wane, “Wan yoig goma geuma aug aga.” ");
INSERT INTO mti_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Koni desirom apan me inaine. Me goma meuma aug aine. Megara kum me Sabat Kumiwa. ");
INSERT INTO mti_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Meoya Ju igiyawa apan me inainewa gumbe waya, “Gare me Sabat Kumiwa. Meoya Gwangwan tobodne ge goma geuma den aug aga.” ");
INSERT INTO mti_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Megara me gara wane, “Apan me ne warinam nednewa ne gunap wane, ‘Goma geuma aug aga.’” ");
INSERT INTO mti_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Mu me gumbe singui waya, “Apan me bira ge dirug wanewa, ‘aug aga?’” ");
INSERT INTO mti_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Apan me inainewa me den yaug anone me bira. Kuiyawa Iesu at me apa iyayapan obiren danowo tobiyag aine. ");
INSERT INTO mti_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Me ivi Iesu apan me temporu arawa danave yaune, sira me gumbe wane, “Yawa, ge sira inaigitana. Kukaeba egewa yankweya, kuiyawa divi da kukaeba ibnapama matai gungap pawapetan.” ");
INSERT INTO mti_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Apan me aine. Ju igiyawa dirum wane, “Apan me ne warinamnednewa me Iesu.” ");
INSERT INTO mti_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Meoya Ju igiyawa Iesu edawai waniya. Me dividivi mame Sabat Kumiwa apa ane oya. ");
INSERT INTO mti_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Me mu gumbo wane, “Ne Maman evedni nau meuma wat onne kum mame gare di, meoya ne mina meib nau wareni.” ");
INSERT INTO mti_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mame oya, Ju igiyawa yusiyusi ag Iesu tope bo atan oya ageyau aya. Kuiyawa me Sabat Kumiwa togomiyaiviwa me mekut onan, me God Mamawa waivi, sira me membo God mina omaoma ane waivi oya. ");
INSERT INTO mti_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Meoya Iesu gara mu gumbo wane, “Ne ye natawa diruieni. Usiwa oma den ane divi da mekut ape. Me oma ane dividivi Mamawa aiviwa me yaviviwa me ape. Kuiyawa dividivi undag Mamawa aiviwa Usiwa mina meib ape. ");
INSERT INTO mti_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kuiyawa Mamawa me baigan ane Usiwa gumbe, sira me aiviwa undag Usiwa toyau wanne. Sira Mamawa matai dividivi koukawa Usiwa toyau wampe kusi mame mina onan. Me gumbe ye teratan oya. ");
INSERT INTO mti_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mamawa iyayapan boriruwayawa sira inaiinai mumpe. Me mina di, Usiwa me mina mu me imive wakenewa gumbo inaiinai mumpe. ");
INSERT INTO mti_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Sira gerave Mamawa bira da den kep tepe, megara keptete yusiwa undag me Usiwa gumbe wanne. ");
INSERT INTO mti_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kuiyawa iyayapan undag Mamawa gumbe mu ayamat eme mina di mu Usiwa gumbe ayamat atanit di. Bira da Usiwa gumbe ayamat den apewa, me Mamawa bira Usiwa baraune onnewa gumbe mina ayamat den ape. ");
INSERT INTO mti_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ne ye natawa diruieni. Bira da gae neuma anope sira ne baraunedne onednawa gumbe anotumat apewa, me inaiinai yaibobot aupe. Sira me matai pui den yuwampe, sira me wait bo painau tuiyaug aine inaiinai aune. ");
INSERT INTO mti_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne ye natawa diruieni. Kum uwaivi, iyayapan boriruwayawa me God Usiwa noiwa anope. Kum garewa me me. Sira iyayapan mu anopewa mu matai wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Kuiyawa Mamawa me membo gumbe inaiinai wakene, me mina Mamawa wane Usiwa me membo gumbe inaiinai wakene. ");
INSERT INTO mti_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Meve me keptete oya me gumbe yusipamit wanne, kuiyawa me Apan Usiwa. ");
INSERT INTO mti_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mame gumbe den teraya. Kuiyawa kum onivi yampot danave wakeyawa matai Usiwa noiwa anope dauwag onampe. ");
INSERT INTO mti_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Dividivi oraimina ayawa mu matai yoig inaiinai aupe. Dividivi kukaeba ayawa mu matai yoig pui yumumpe. ");
INSERT INTO mti_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ne nembovit oma den ane divi da atna. Ne anonawa gumbe keptena. Sira ne keptete neuma me oraimina. Kuiyawa ne nembovit imunap atan oya den anoeni, ne baraunedne onednawa ano meumawa atan eni. ");
INSERT INTO mti_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ne nembovit nembo oya taibe watnawa ipewa, ne taibe watanwa me natawa onan. ");
INSERT INTO mti_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Apan da me nenan oya taibe waiviwa wakene. Ne yaug anona me nenan oya taibe waiviwa me natawa. ");
INSERT INTO mti_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ye Jon oya iyayapan teyana amiya, sira me natawa gumbe taibe wane. ");
INSERT INTO mti_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Megara iyayapan taibe watanwa ne matai den autna. Ye waita autan oya ne dividivi mame veni. ");
INSERT INTO mti_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon me damempa ig esiviwa. Sira ye imuyep me eyawa meuma danave koni kusida degadega atan anoyana. ");
INSERT INTO mti_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Megara taibe watanwa ne gunap me oraiminavit, sira Jon taibe watanwa mina onan. Maman nau nedne. Ne me wapukiyatna undag onanape, sira ne nau mame wareni. Nau mame di me ne Maman baraunedne onednawa oya taibe waivi. ");
INSERT INTO mti_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Maman baraunedne onedna, sira me membo nenan oya taibe waivi. Ye me noiwa da den di anoyana, sira me irawa aninin mina den di yauyana. ");
INSERT INTO mti_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sira gae meuma ye daneyep den wakene. Kuiyawa me baraune onnewa gumbe ye anotumat den ene. ");
INSERT INTO mti_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ye Baiboru basiyag yobene, kuiyawa ye anoene me danave inaiinai yaibobot wakene. Megara Baiboru me nenan oya taibe waivi. ");
INSERT INTO mti_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Megara ye ne gunap oneg inaiinai autan oya topai ene. ");
INSERT INTO mti_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ne iyayapan gumbo ayamat den autna. ");
INSERT INTO mti_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ne ye yaug anoyenna. God baigan meuma noneyep den wakene. ");
INSERT INTO mti_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne Maman iviwa gumbe uwana, megara ye ne den aunegiyana. Apan da me iviwa gumbe uwapopo ipawa, ye me matai aupono. ");
INSERT INTO mti_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ye garagara ayamat auene. Megara ayamat me God desiromiren gumbe ompewa ye den auyawa, aninin ye akape anotumat aya? ");
INSERT INTO mti_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ye den anoya ne matai yenan Mamanwa namive pui yuentna. Yenan puiyuyu atanwa me Mosisi, me gumbe ye owaniyag barauyanawa. ");
INSERT INTO mti_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ye Mosisi gumbe anotumat aponowa, ye ne gunap anotumat apono. Kuiyawa me nenan tene. ");
INSERT INTO mti_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Megara tenewa ye anotumat den aya ipewa, gae neumawa ye aninin anotumat aya?” ");
INSERT INTO mti_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kum da mame ivi, Iesu poeman Gariri, me iviwa poeman Tiberias, togomiyag visi gambenwa dauwag aine. ");
INSERT INTO mti_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sira iyayapan obiren amave amiya. Kuiyawa irakoniwa Iesu yuwat igiyawa gumbo anewa mu yauya. ");
INSERT INTO mti_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Meve Iesu tui dog aine, sira aigowawa gaibu yan wakeya. ");
INSERT INTO mti_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ju igiyawa Uwag Gaveya Buyunaeba me koni aivi. ");
INSERT INTO mti_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iesu yangut wan ag yawamnewa iyayapan obiren menan omome. Me Pirip gumbe wane, “Bredi me iyayapan mame natan oya nu ampa gwiruwatton?” ");
INSERT INTO mti_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Me singui mame wanewa me di amawa toreyag yaune. Kuiyawa Iesu wait yaug anone me divi atan aivi. ");
INSERT INTO mti_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pirip me gumbe gara wane, “Anmaga 200 denari gumbe bredi gwiruwatta sira iyayapan desirom desirom musi musi napewa, matai oma den ape.” ");
INSERT INTO mti_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aigowawa desirom da, Saimon Pita gwaneba Andru me gumbe wane, ");
INSERT INTO mti_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Bredi baari gumbe okeriyawa 5 ge gwambui kusikusi duwam ud apan mame gumbe wakeya. Megara iyayapan obiren, meoya mame oma ape go?” ");
INSERT INTO mti_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iesu wane, “Iyayapan dirumiya yan wakepe.” At me apa wayo arawa. Meve apan undag yan wakeya. Undag 5,000 mina. ");
INSERT INTO mti_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iesu meve bredi aug gaun wane, sira yan wakeyawa peyam kep ag munne. Me gwambui gumbe mina meib ane. Natan anoemewa mu munne. ");
INSERT INTO mti_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mu undag naya oma anewa, me aigo meumawa gumbo wane, “Nakwai naya upeba wakeyawa tamiya. Undag tamiya da den yankweya.” ");
INSERT INTO mti_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Meve mu tam agoniyaya, sira bredi baari 5 nayawa, musimusiwa tam agoniyag pot undag 12 danave enamiya noidauwaya. ");
INSERT INTO mti_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Irakoniwa Iesu anewa iyayapan yauya, sira mu waya, “Natawa di, mame me propeta di me piyu mame uwatanwa.” ");
INSERT INTO mti_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iesu yaug anone mu onam wape me kin atanwa oya. Meoya sira yankweg mekut unig dauwag tui aine. ");
INSERT INTO mti_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Augoi uwanewa, aigowawa poeman visi aig amiya. ");
INSERT INTO mti_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Me apa mu wa danave dauwaya, sira poeman togomiyag Kapenaum oya amome. Gare sisip wait uwag onne, megara Iesu ande mu gumbo den uwane. ");
INSERT INTO mti_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Taig yusipamit toivi, poeman yawarat koka aivi. ");
INSERT INTO mti_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mu barauwag 4 go 5 kiromitas mina amomewa, Iesu poeman egave on wa obmanivi. Mu me yaveg a aya. ");
INSERT INTO mti_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Megara me mu gumbo wane, “Ma ne. A den aya.” ");
INSERT INTO mti_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Meve mu degadegaepam me aug wa danave barauya, pungi den waneve wa at me oya mu amomewa uwaya. ");
INSERT INTO mti_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wantenewa iyayapan obiren poeman visi gambenwa apa wakeyawa yaug anoyawa, wa desirom mekut me apa wakene, Iesu me aigowawa gaibu den unigiya, aigowawa mukut me yankweg amiya. ");
INSERT INTO mti_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ayapan gaun wane sira iyayapan bredi nayawa arawa megiyave apa wa upeba Tiberias apa onam unigiya. ");
INSERT INTO mti_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iyayapan yaug anoya Iesu ge aigowawa at me apa den wakeya. Mu wa danave dauwag Iesu didimama atan oya Kapenaum uwaya. ");
INSERT INTO mti_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Poeman visi gambenwa apa Iesu me yaveg waya, “Rabai, ge aniyau at mame apa uwana?” ");
INSERT INTO mti_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iesu gara wane, “Ne natawa ye diruieni. Ye nenan didimama ene. Me ye irayauyau ge irakoniwa yauyanawa oya onan, ye bredi nayana oma ane oya. ");
INSERT INTO mti_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nakwai me matai watkukampewa oya nau den aya. Nakwai me wakeigimtanwa ge inaiinai yaibobot avigimtanwa oya nau aya. Apan Usiwa yempewa me me. Me gumbe God Mamanwa bainda wag kiniyane.” ");
INSERT INTO mti_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Meve me gumbe waya, “God nauwawa atan oya nu divi aton?” ");
INSERT INTO mti_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iesu gara mu gumbo wane, “God nauwawa me mame. Me baraune onnewa gumbe ye anotumat ayawa.” ");
INSERT INTO mti_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Meve mu me gumbe waya, “Nu yaug ge gungap anotumat atan oya dimbae irakoniwa nuna? Matai dimbae a? ");
INSERT INTO mti_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nu wagonaiwa at inguiwa arawa apa manna naya. Me meib tene, ‘Me bredi kwimin apa onnewa munne naya.’” ");
INSERT INTO mti_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iesu mu gumbo wane, “Ne gae natawa ye diruieni. Bredi kwimin apa onne sira ye yennewa me Mosisi onan. Megara Mamanwa bredi natawa kwimin apa ye yempe. ");
INSERT INTO mti_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kuiyawa God bredi meuma me kwimin apa uwag at piyu gumbe inaiinai wampe.” ");
INSERT INTO mti_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Meve waya, “Kokawa, kum evedni bredi mame nunigima.” ");
INSERT INTO mti_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Meve Iesu taibe wane, “Ne me inaiinai bredi meuma. Da bira nenan ompewa me matai iyagon den atpe. Bira da nenan anotumat aiviwa meyawa matai den toyaipe. ");
INSERT INTO mti_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Megara ne wait diruina. Ye ne yaunegiyana, megara ye ande anotumat den ene. ");
INSERT INTO mti_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Maman negnewa undag nenan onampe. Bira da nenan ompewa ne matai den di yankwetna aipe. ");
INSERT INTO mti_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kuiyawa ne kwimin apa aig onednawa me ne anoeniwa atan oya onan, megara me ne baraunedne onednawa me anoiviwa atan oya. ");
INSERT INTO mti_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ne baraunedne onednawa me anoiviwa me mamaib. Me nednewa undag yapowo desirom da den waropiyatna, sira ne kum oieba apa mu enagat muntna wan yoipe. ");
INSERT INTO mti_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Maman anoiviwa me mamaib. Me iyayapan undag Usiwa yaug me gumbe anotumat apewa mu matai inaiinai yaibobot aupe. Sira ne kum oieba apa mu enagat muntna wan yoipe.” ");
INSERT INTO mti_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Me wane, “Ne bredi kwimin apa aig onednawa.” Meoya Ju igiyawa me gumbe diguragut aya. ");
INSERT INTO mti_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Mu waya, “Mame me Iesu onan? Me Josep usiwa, sira mamawa ge inawa nu yaug anomuntu. Aninin oma ane me gare wane, ‘Ne kwimin apa aig onedna.’” ");
INSERT INTO mti_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iesu gara wane, “Ye yembovit gara di enewa yankweya. ");
INSERT INTO mti_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maman ne baraunedne onedna. Me den auwapewa, da bira oma den ane nenan ompe. Sira ne kum oieba apa me enagatna wan yoipe. ");
INSERT INTO mti_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propeta buka muma danave teya, ‘God mu undag toyau mumpe.’ Iyayapan undag Mamawa gumbe anopewa sira me gumbe gigirum yaug anopewa nenan onampe. ");
INSERT INTO mti_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Da bira Mamawa den yaune. Megara God gumbe onnewa me mekut Mamawa yaune. ");
INSERT INTO mti_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne gae natawa diruieni. Da bira anotumat apewa me inaiinai yaibobot aupe. ");
INSERT INTO mti_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ne inaiinai bredi meuma. ");
INSERT INTO mti_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ye isimureiwa manna at inguiwa arawa apa naya, megara mu boriruwaya. ");
INSERT INTO mti_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Megara bredi mame kwimin apa aig onnewa, da bira me napewa, den boape. ");
INSERT INTO mti_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ne bredi me evedni wakeiviwa sira kwimin apa aig onnewa. Bira da bredi mame nape ipewa, me wakepe yaibobot tunano. Sira bredi me wantnawa ne kwapunwa, me piyu mame inaiinaiba oya.” ");
INSERT INTO mti_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Meve Ju igiyawa mumbovit garagara diguragut eme waya, “Aninin oma ane apan mame kwapiwa numpe nata?” ");
INSERT INTO mti_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iesu mu gumbo wane, “Ne gae natawa diruieni. Ye Apan Usiwa me kwapiwa ge diyawa meuma den nayawa, ye matai inaiinai den auya. ");
INSERT INTO mti_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Da bira ne kwapunwa ge diyanwa napewa me inaiinai yaibobot aupe. Sira kum oieba apa ne matai me enagatna wan yoipe. ");
INSERT INTO mti_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Kuiyawa kwapunwa me nakwai natawa di, ne diyanwa me mina yoi natawa di. ");
INSERT INTO mti_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Da bira kwapunwa ge diyanwa napewa me ne gunap wakepe, sira ne me gumbe wakeigimpna. ");
INSERT INTO mti_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Maman wakeiviwa ne baraunedne onedna, sira Maman gumbe ne wakena. Ebu me mina di. Da bira ne nanekpewa me matai ne gunap wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mame me bredi kwimin apa aig onne. Mame ye isimureiwa manna naya sira boriruwayawa me mina onan. Da bira bredi mame napewa me matai wakeigimpe yaibobot tunano.” ");
INSERT INTO mti_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kapenaum apa sinagogu danave, me toyau munivi kumiwa apa gae mame wane. ");
INSERT INTO mti_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aigowawa obiren me anog waya, “Gae mame me yaigiwa. Bira oma ane anog aupe?” ");
INSERT INTO mti_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iesu yaug anone me aigowawa me gumbe kwavieme, mu gumbo wane, “Mame ye anopipanum ag vene? ");
INSERT INTO mti_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Apan Usiwa namu wakenewa arawa dog aipe me ye yauyawa ye aninin anomon? ");
INSERT INTO mti_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Inaiinai waniviwa me Guwawa. Kwapiwa oma den ane divi da ape. Gae ne ye guniyap wanawa me Guwawa, sira me inaiinai. ");
INSERT INTO mti_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Megara ye upeba anotumat den ene.” Kuiyawa Iesu wait namuiren apa yaug anone, bira bira anotumat den eme sira bira matai me ominawa tepe. ");
INSERT INTO mti_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sira wane, “Meoya ne ye diruina, ‘Mamawa bainda den wapewa, bira da oma den ane ne gunap ompe.’” ");
INSERT INTO mti_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kum mame apa, aigowawa obiren me gumbe yankweg taigiya, me amave sira den amiya. ");
INSERT INTO mti_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Iesu me aigowawa 12 gumbo wane, “Ye mina imuyep yankweg aisetan anoene?” ");
INSERT INTO mti_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Pita me gumbe gara wane, “Ayapan, nu bira oya anta? Inaiinai yaibobot gaiyawa me ge gungap. ");
INSERT INTO mti_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu anotumat ag yaug anotu, ge me iyakaisi abnawa God meuma.” ");
INSERT INTO mti_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Meve Iesu gara mu gumbo wane, “Ne ye aigowawa 12 gomiyenna. Megara ye daneyap desirom me airapu kukaeba.” ");
INSERT INTO mti_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Me Saimon Isukariot usiwa Judas oya wane. Me aigowawa 12 danave da, megara ivi me ominawa barautan aivi.) ");
INSERT INTO mti_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Meve Iesu Gariri apa birorot guidne. Me imive Judia apa den waketan anoivi, kuiyawa Ju igiyawa imuwo me totan oya eme. ");
INSERT INTO mti_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Megara Ju igiyawa buyunaeba iviwa Gwe Gopad Buyunaeba me koni aivi. ");
INSERT INTO mti_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iesu gwanebaviwa me gumbe waya, “Ge at mame yankweg Judia aga. Me gumbe aigo geumawa mu ge divi egewa yaupe. ");
INSERT INTO mti_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Bira da me imive membo iyayapan undag namuwo taibe wakepe ipewa, divi da den guwave ape. Ge dividivi mame egewa, gembovit at piyu mame toewan muna yaupe.” ");
INSERT INTO mti_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gwanebaviwa mu mina gaibu me gumbe anotumat den eme. ");
INSERT INTO mti_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Meoya Iesu mu dirumne, “Ne kum neuma oraiwa ande den uwane. Megara ye kum yeuma evedni wait uwag mapa wakene. ");
INSERT INTO mti_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Piyu mame oma den ane ye topai yempe. Megara ne topai nekpe. Kuiyawa mu kukaeba emewa ne taibe wana. ");
INSERT INTO mti_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ye buyunai oya dog aisiya. Ne buyunai mame oya den anekna. Kuiyawa ne kum neuma oraiwa ande den uwane.” ");
INSERT INTO mti_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Me mameib wag Gariri apa wakene. ");
INSERT INTO mti_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Megara gwanebaviwa buyunai oya amiyawa, me mina guwave aine, taibe onan. ");
INSERT INTO mti_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Buyunai apa Ju igiyawa menan didimama ag, singui veme, “Apan me ampa?” ");
INSERT INTO mti_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iyayapan obiren yapowo mu menan kigemug veme. Upeba waya, “Me apan oraimina.” Iyayapan upeba gara waya, “Onan, me iyayapan gwambe namuyoiyoi ag munivi.” ");
INSERT INTO mti_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Megara bira da menan oya divi da taibe den wane. Kuiyawa Ju igiyawa munan a aya. ");
INSERT INTO mti_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Buyunai emewa yapave wait uwaiviwa, Iesu temporu arawa dog aig amatog toyau munivi. ");
INSERT INTO mti_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ju igiyawa mu terag waya, “Apan mame gigirum da den tene. Me aninin dividivi kokawa meiba yaug anone.” ");
INSERT INTO mti_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iesu gara gumbo wane, “Ne toyau muneniwa me neumawa onan. Apan me ne baraunedne onednawa me meumawa. ");
INSERT INTO mti_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bira da imive God anoiviwa atan anope ipewa, me matai yaug anope, ne toyau muneniwa God gumbe onne go, ne nembo imunap veni go? ");
INSERT INTO mti_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Bira da membovit wapewa membovit oya waiya autan anope. Megara me baraune onnewa oya waiya autan anopewa me natawa. Sira me gumbe ugauga da den wakene. ");
INSERT INTO mti_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mosisi Gwangwan meuma ye yenne go onan? Megara ye gwangwan den yumnasiyana. Divi oya ye ne tonektan oya ene?” ");
INSERT INTO mti_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iyayapan obiren gara waya, “Ge airapu kukaeba gungap. Bira ge toattan oya aivi?” ");
INSERT INTO mti_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iesu gumbo wane, “Ne irayauyau da ana, sira ye undag terayana. ");
INSERT INTO mti_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mosisi kwapituitui ye yenne. (Megara me Mosisi gumbe den onne, isimuranaiwa gumbo onne,) sira ye Sabat Kumiwa apa kwapituitui ene. ");
INSERT INTO mti_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mosisi Gwangwan meuma amaratan oya, ye Sabat Kumiwa apa kwapituitui enewa, divi oya apan kwapiwa undag meuma Sabat Kumiwa apa ne warinameni oya ye ne gunap danewa piriwaivi? ");
INSERT INTO mti_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yautanwa gumbe puiyuyu yankweya, sira natawa gumbe puiyuyu aigimiya.” ");
INSERT INTO mti_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Meve Jerusarem igiyawa upeba waya, “Apan mame mu tope boatan aiviwa go? ");
INSERT INTO mti_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yauya, apan mame me iyayapan yangowo taibe waivi, megara mu gae da den me gumbe veme. Amareme igiyawa yaiyai yaug anoya me Keriso? ");
INSERT INTO mti_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Megara apan mame ampa onnewa nu yaug anotu. Keriso uwapewa bira da den yaug anope me ampa onne.” ");
INSERT INTO mti_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iesu temporu arawa danave toyau munivi gumbe noiwa kokavit wane, “Ye ne yauneg anoyana, sira ye yaug anoyana ne ampa onedna. Ne nembo anoano neuma oya mapa den uwana. Ne baraunedne onednawa me natawa. Ye me den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ne me yaug anona, kuiyawa ne me gumbe onedna, me ne baraunedne onedna.” ");
INSERT INTO mti_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Meve mu amatog me yumiya, megara da bira den naniwa me gumbe tone. Kuiyawa kum meuma den uwane, matai. ");
INSERT INTO mti_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iyayapan obiren mu me gumbe anotumat eme, sira waya, “Keriso uwapewa irakoniwa me matai kokavit ape, megara apan mame mina ape go?” ");
INSERT INTO mti_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi igiyawa anoya iyayapan obiren anoano meiba me oya kigemug veme. Meve pirisi koukawa ge Parisi igiyawa mu temporu amaremewa teya me tutan oya amiya. ");
INSERT INTO mti_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iesu wane, “Ne kum kusida ande ye gaibu waketna. Meve ne baraunedne onednawa gumbe anekna. ");
INSERT INTO mti_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ye matai nenan oya didimama aya, megara ye ne den yaunegiya. Sira ampa ne waketnawa ye oma den ane oneya.” ");
INSERT INTO mti_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ju igiyawa gae garawano aya, “Me wane, ‘Nu oma den ane me yauta.’ Apan mame ampa aitan aivi? Iyayapan numawa Griisu igiyawa yapowo wakeg ampa ampa vineme. Me aig mu toyau mumpe? ");
INSERT INTO mti_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Me aib wane, ‘Nenanwa didimama aya, megara ye ne den yaunegiya,’ sira ‘Ne ampa waketnawa ye oma den ane oneya.’ Me natawa aninin?” ");
INSERT INTO mti_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Buyunai oieba kumiwa me kum muma kokawa. Me kumive, Iesu wan yoig sira noiwa kokavit wane, “Da bira meyawa toyaigimpewa me kweya nenan ompe sira yoi nape. ");
INSERT INTO mti_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Da bira anotumat ne gunap apewa, Baiboru waiviwa mina, yamarogu yoi inaiinai gaibuwa matai me danave noidauwag egamigimpe.” ");
INSERT INTO mti_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mame me wane. Me bira da me gumbe anotumat emewa matai Guwawa autan oya wane. Kum me apa Guwawa ande den munne, kuiyawa Iesu eyawa ande den aune. ");
INSERT INTO mti_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iyayapan gae meuma anoemewa, upeba waya, “Natawa di, apan mame me propeta,” ");
INSERT INTO mti_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","sira upeba waya, “Me Keriso.” Upeba waya, “Aninin oma ane Keriso Gariri apa ontan? ");
INSERT INTO mti_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Keriso Devid dam meuma gumbe ompe, sira Betureem at kokawa Devid wakenewa apa ompe. Meib Baiboru waivi go onan?” ");
INSERT INTO mti_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iyayapan meiba Iesu oya gomiyag ge yoig aya. ");
INSERT INTO mti_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mu yapowo upeba me totan oya anoeme, megara bira da me gumbe nanuwa da den yumiya. ");
INSERT INTO mti_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Meve temporu amaremewa mu pirisi koukawa ge Parisi igiyawa munan sira taig amiya. Mu waya, “Diwan ye me den aug oniyana?” ");
INSERT INTO mti_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Amaremewa mu gara waya, “Apan mame gae waivi minawa bira da den wane.” ");
INSERT INTO mti_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisi igiyawa gara waya, “Ye mina uga yemne? ");
INSERT INTO mti_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Namuyoiyoi igiyawa go Parisi igiyawa daneyap bira da me gumbe anotumat eme? ");
INSERT INTO mti_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Megara iyayapan obiren mame mu Gwangwan da den yaug anoya. Mu anokukam gumbe wakeya.” ");
INSERT INTO mti_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemas wag dirumne. Me namu Iesu oya onne, sira me mu desirom. ");
INSERT INTO mti_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gwangwan numawa gumbe, namu me divi anewa yaug anotanwa oya me gumbe anoigimpe, meve pui yupe keptete ape, go onan?” ");
INSERT INTO mti_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mu gara waya, “Ge mina Gariri apa onagana, go? Baiboru gumbe yaug anoa, propeta me Gariri apa den dauwag ompe.” Baiboru Namu tenewa obiren danave Jon 7:53–8:11 den wakene. ");
INSERT INTO mti_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Meve mu desirom desirom taig gweyowon amiya. ");
INSERT INTO mti_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Megara Iesu tui Orivu aine. ");
INSERT INTO mti_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wanteivine mumbevit me temporu arawa dana sira unig aine. Me apa iyayapan undag me gumbe birorot agoniyaya. Me yan wakeg amatog toewan munivi. ");
INSERT INTO mti_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gwangwan toewanewan igiyawa ge Parisi igiyawa mu vesin me uinantaraki aiviwa aug uwaya. Mu vesin yapowo barauya wan yokene. ");
INSERT INTO mti_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Sira me gumbe waya, “Toewanewan, vesin mame uinantaraki aiviwa yumiya. ");
INSERT INTO mti_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Gwangwan danave Mosisi wag did nunne, vesin meiba an gumbe tota. Gare ge anin wamon?” ");
INSERT INTO mti_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mu singui mame vemewa me gumbe amatoriyag yautanwa oya veme. Kuiyawa me gumbe pui yutan oya. Megara Iesu kwana sig, naniguriwa gumbe piyu egave amatog teivi. ");
INSERT INTO mti_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mu me gumbe singui ande vemewa, me siwavit wan yoig gumbo wane, “Ye daneyap da kukaeba meuma onan ipewa, me namu an aug me tope.” ");
INSERT INTO mti_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Me sira kwana sig piyu egave tene. ");
INSERT INTO mti_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Kum me apa, mu anoyawa, iyayapan tayawa namu amatog desirom desirom amiya, sira Iesu mekut kweya. Vesin me gaibu ande me apa yokene. ");
INSERT INTO mti_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iesu wan siwavit yoig gumbe wane, “Vesin, mu ampa? Da bira ge gungap kukaeba den wane?” ");
INSERT INTO mti_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Me gara wane, “Ayapan, bira da den wane.” Iesu wane, “Ne gaibu ge kukaeba den watna. Gare mame aga, kukaeba den a.” ");
INSERT INTO mti_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iesu mu gumbo gae sira wane, “Ne piyu mame eyawa meuma. Da bira ne amanap ompewa matai sisip gumbe den aipe, sira inaiinai eyawa meuma aupe.” ");
INSERT INTO mti_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi igiyawa me gumbe waya, “Ge gembo genan taibe vege, meoya gae geuma me natawa onan.” ");
INSERT INTO mti_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iesu gara mu gumbo wane, “Ne nembovit oya ne nekut yaug anotanwa ipewa gae neuma me natawa. Kuiyawa ne yaug anona ne ampa onedna sira ne ampa angeni. Megara ye den yaug anoyana ne ampa onedna sira ne ampa angetan eni. ");
INSERT INTO mti_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ye iyayapan anoemewa ebuwawa gumbe pui yuwamene. Ne bira da den pui yutna. ");
INSERT INTO mti_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Megara ne pui yutna ipewa, ne puiyuyu neumawa me natawa. Kuiyawa ne nekuriren onan, ne ge ne baraunedne onednawa gaibu yokena. ");
INSERT INTO mti_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gwangwan yeumawa tene, me apan duwam taibe watanwa me natawa. ");
INSERT INTO mti_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ne desirom me nembovit oya taibe veni. Sira Maman me ne baraunedne onednawa gaibu nenan taibe waivi.” ");
INSERT INTO mti_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Meve mu me gumbe singui waya, “Ge Mamag ampa?” Iesu gara wane, “Ye ne ge Maman nu den yaunun anoyana. Ye ne yauneg anoyawa ipewa, ye Maman gaibu yaug anopono.” ");
INSERT INTO mti_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Me temporu arawa danave puyo teemewa apa, gae mame toyau munivi gumbe me gae mame wane. Megara da bira me yumtan oya den aya. Kuiyawa kum meuma ande den uwane. ");
INSERT INTO mti_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iesu mu gumbo sira wane, “Ne angeni. Sira ye matai nenan oya didimama aya, sira ye matai kukaeba yeumawa gumbe boriruwaya. At me ne aneknawa ye oma den ane oneya.” ");
INSERT INTO mti_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Meoya Ju igiyawa waya, “Me wane, ‘At me ne aneknawa ye oma den ane oneya?’ Me membovit tog boape go?” ");
INSERT INTO mti_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sira me mu gumbo wane, “Ye ankwatau oneyana. Ne painau onedna. Ye piyu mame igiyawa, sira ne piyu mame abnawa onan. ");
INSERT INTO mti_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Meoya ne ye diruina me ye kukaeba yeumawa gumbe boriruwaya. Sira ye ne gunap anotumat den ayawa ipewa, ye kukaeba yeuma gumbe boriruwaya.” ");
INSERT INTO mti_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Mu me gumbe waya, “Ge bira?” Iesu gara wane, “Amatonewa apa wag ongeniwa me me. ");
INSERT INTO mti_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne yenan oya watanwa me obiren, sira yenan pui yutanwa me obiren. Megara me ne baraunedne onednawa me natawa. Sira ne dividivi me gumbe anonawa piyu mame gumbe veni.” ");
INSERT INTO mti_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Me Mamawa oya dirumiviwa mu den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iesu wane, “Ye Apan Usiwa enagasiyawa, meve yaug anoya ne divi. Sira ye matai yaug anoya ne nembovit oya da den ana. Maman toyau nednewa mina di ne dividivi mame diruieni. ");
INSERT INTO mti_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ne baraunedne onednawa me ne gaibu. Me ne den kwenedne. Kuiyawa ne kum evedni me gumbe degadega aiviwa me eni.” ");
INSERT INTO mti_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Me dividivi mame waiviwa, iyayapan obiren anotumat me gumbe aya. ");
INSERT INTO mti_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Meoya Ju igiyawa mu me gumbe anotumat ayawa, mu gumbo Iesu wane, “Ye toewanewan neumawa yumnasiyawa ipewa, ye natawa di ne aigowanwa. ");
INSERT INTO mti_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Meve ye natawa yaug anoya, sira natawa me matai ye ui onan barau yempe.” ");
INSERT INTO mti_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Mu me gumbe gara waya, “Nu Ebraam wagobaviwa. Sira da bira gumbe ankwatave nau eme igiyawa meib da den di atu. Ge aninin oya aib wana, “Matai ui onan barau yempe?” ");
INSERT INTO mti_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iesu mu gumbo gara wane, “Ne gae natawa ye diruieni. Da bira kukaeba aiviwa me kukaeba ankwatave nau aivi abnawa. ");
INSERT INTO mti_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sira ankwatave nau aivi abnawa me gwe danave yaibobot den wakeigimpe. Megara usiwa me apa yaibobot wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Meoya Usiwa me ye ui onan yai waketan barau yempe ipewa, ye ui onan yai wakeya, me natawa di. ");
INSERT INTO mti_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ne yaug anona ye Ebraam wagobaviwa. Megara ye ne tonegiya boatan oya ene. Kuiyawa gae neumawa ye guniyap den wakene. ");
INSERT INTO mti_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ne Maman gumbe yaunawa ne ye diruieni. Megara ye mameaiwa gumbo anoyanawa ye ene.” ");
INSERT INTO mti_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mu gara waya, “Ebraam nu mamunwa.” Iesu wane, “Ye Ebraam usitainawa ipewa, me dividivi aninin anewa ye aigimiya. ");
INSERT INTO mti_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gae natawa ne God gumbe anonawa ye diruieni, megara ye ne tonektan oya anoene. Ebraam divi da meib den ane. ");
INSERT INTO mti_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye dividivi me mameiwa ayawa ye ene.” Mu waya, “Nu ebu taibe usitainawa onan. Nu mamunwa desiromiren me God mekut.” ");
INSERT INTO mti_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iesu mu gumbo wane, “God ye mameiwa ipewa, ye ne gunap baigan aigimpono. Kuiyawa ne God gumbe onedna sira gare ne mapa wakena. Ne nembo ano neuma gumbe den onedna. Megara me ne baraunedne onedna. ");
INSERT INTO mti_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Divi oya gae neuma ye oma den ane yaug anoene? Kuiyawa ye guniyap oma den ane ne veniwa auya. ");
INSERT INTO mti_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye mamewa Seitan, ye me usitainawa. Ye imuyep mamewa anoiviwa atan anoene. Me amatog onnewa apa iyayapan gurivi abnawa. Natawa da den yumnasivi. Kuiyawa me gumbe natawa den wakene. Me uga uga pednave waivi. Kuiyawa me ugaepama sira ugauga mamawa. ");
INSERT INTO mti_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Megara ne natawa ye diruieni, meoya ye ne gunap anotumat den ene! ");
INSERT INTO mti_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ye guniyap da bira oma ane ne kukaeba neuma taibe waya? Ne natawa diruigimpnawa ipewa, divi oya anotumat ne gunap den ene? ");
INSERT INTO mti_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Apan da bira me God meumawa ipewa, me God aninin waiviwa anog aupe. Megara ye God aninin waiviwa den anog auyana, kuiyawa ye God meumawa onan.” ");
INSERT INTO mti_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ju igiyawa me gumbe gara waya, “Ge Samaria apan sira airapu kukaeba danagap wakene. Nu bainda vete.” ");
INSERT INTO mti_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iesu gara wane, “Ne dananap airapu kukaeba den wakene, megara ne Maman gumbe ayamat eni, sira ye ne yan yaunegene. ");
INSERT INTO mti_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Megara ne eyawa neuma den anoeni. Eyawa anoiviwa sira keptete abnawa wakene. ");
INSERT INTO mti_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne gae natawa diruieni. Da bira gae neumawa yumnatpewa, me bo den di ape.” ");
INSERT INTO mti_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ju igiyawa me gumbe waya, “Gare nu yaug anotu airapu kukaeba danagap wakene. Ebraam botone sira propeta mina boriruwaya. Megara ge wana, ‘Da bira gae neuma yumnatpewa me bo den di tope.’ ");
INSERT INTO mti_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ge koka? Nu mamunwa Ebraam kusi? Me botone sira propeta mu mina boriruwaya. Ge bira vege?” ");
INSERT INTO mti_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iesu gara wane, “Ne ayamat nembovit oya autnawa ipewa, ayamat neumawa me natawa onan. Ayamat ne negnewa me Maman. Sira me gumbe ye vene, ‘Me God numawa.’ ");
INSERT INTO mti_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ye me den yaug anoyana, megara ne me yaug anona. Ne me den yaug anona watna ipewa, ne matai ye mina ugaen atatu. Megara ne me yaug anona, sira gae meumawa amareni. ");
INSERT INTO mti_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ye mamewa Ebraam me kum neumawa yautan oya anone, degadega ane. Sira me yaug degadega ane.” ");
INSERT INTO mti_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ju igiyawa me gumbe waya, “Ge bairawan geuma ande gare 50 ankwatave, megara ge Ebraam yawana?” ");
INSERT INTO mti_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iesu mu gumbo wane, “Ne gae natawa di diruieni. Namu ne wakenave, meve Ebraam yaine!” ");
INSERT INTO mti_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Mame gumbe, mu an tam me totan oya aya. Megara Iesu guwave unig temporu arawa apa yankweg aine. ");
INSERT INTO mti_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Me ebu taibe aiviwa, apan da yangawa boredneve yainewa yaune. ");
INSERT INTO mti_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aigowawa meuma me gumbe singui aya, “Rabai, me yangawa boredneve yainewa me kukaeba bira ane? Apan mame ane go inamamawa aya go?” ");
INSERT INTO mti_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iesu gara wane, “Apan mame me kukaeba den ane, inamamawa mu mina kukaeba den aya. Megara mame pawanewa me gumbe God nau meumawa taibe atanwa oya. ");
INSERT INTO mti_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kum, nu ne baraunedne onednawa nauwawa atanit di. Aram uwaivi, bira da oma den ane nau ape. ");
INSERT INTO mti_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ne piyu mame apa wakeeniwa, ne piyu mame eyawa meuma.” ");
INSERT INTO mti_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Me gae mame wanewa, me gwitup piyu egave emne, me gumbe piyu wadne kawait ane. Meve me yangave wadne. ");
INSERT INTO mti_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Me gumbe wane, “Aga, condowin Sairoam apa muina.” (Gae mame natawa me bira baraune aine abnawa.) Meve me aig muinne. Yangawa oraimina ane, gwe aine. ");
INSERT INTO mti_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Me megiyave wakeeme igiyawa ge iyayapan mu nungan me nun waivi yauyawa waya, “Apan mame desiroma me yan wakeg nun waiviwa go?” ");
INSERT INTO mti_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Upeba waya, “Apan mame me me.” Sira iyayapan upeba waya, “Onan, me apan me desiroma mina.” Me membo wane, “Ne apan me.” ");
INSERT INTO mti_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Mu waya, “Aninin yangagwa watabne?” ");
INSERT INTO mti_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Me gara wane, “Apan iviwa Iesu mu vemewa me kawait gumbe wadne sira tam yanganap wadne. Me didneg wane, ‘Sairoam ag muina.’ Meoya ne aneg yanganwa muinna, oraimina ane oma ane yauna.” ");
INSERT INTO mti_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Mu me gumbe waya, “Apan me gare ampa?” Me wane, “Ne den yaug anona.” ");
INSERT INTO mti_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mu apan nungan yangabored me aug Parisi igiyawa gumbo uwaya. ");
INSERT INTO mti_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Iesu kawait wadne yangawa watabnewa me Sabat Kumiwa apa. ");
INSERT INTO mti_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Meoya Parisi igiyawa mina me gumbe singui sira waya, “Aninin ge yangagwa oraimina ane?” Me wane, “Me kawait yanganap wadnewa ne sira muinna. Gare ne oma ane yaveni.” ");
INSERT INTO mti_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi igiyawa upeba waya, “Apan me God gumbe den onne. Kuiyawa me Sabat Kumiwa den amaraivi.” Megara upeba waya, “Aninin iyayapan kukaeba oma ane dividivi meiba irakoniwa ape pawape?” Mu yapowo kep teya. ");
INSERT INTO mti_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Meoya mu sira apan yangabored gumbe waya, “Yangagwa me watabne, gare ge aninin me oya wamon?” Me wane, “Me propeta.” ");
INSERT INTO mti_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Apan yangaboredne sira oraimina anewa gumbe Ju igiyawa anotumat den aya. Meoya mu apan me inamamawa tam onamtan oya waya, mu onamiya. ");
INSERT INTO mti_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Mu singui ag waya, “Mame ye ud yeumawa? Mame me yangaboredneve yaine ye wayanawa? Aninin oma ane gare me yavivi?” ");
INSERT INTO mti_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Me inamamawa gara waya, “Nu yaug anotu me nu ud numawa. Sira nu yaug anotu me yangawa boredneve yaine. ");
INSERT INTO mti_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Megara nu den yaug anotu me aninin oma ane gare yavivi, sira nu den yaug anotu me yangawa bira watabne. Me gumbe ye singui ag yauya. Me wait koka ane, oma ane membovit wape.” ");
INSERT INTO mti_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Me inamamawa meib waya. Kuiyawa mu Ju igiyawa gumbo a aya. Ju igiyawa bainda wayawa, da bira Iesu me Keriso wapewa, me sinagogu apa atataipe. ");
INSERT INTO mti_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Meoya me inamamawa waya, “Me wait koka ane. Membo singui aya.” ");
INSERT INTO mti_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Mu apan yangawa borednewa sira ontan oya waya me onne. Mu waya, “Eyawa God gumbe wana. Nu yaug anotu apan me kukaeba aiviwa.” ");
INSERT INTO mti_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Me gara wane, “Anten, me kukaeba aiviwa go onan ne den yaug anona. Desirom ne yaug anona. Ne yanganwa boredneve yaina, megara gare ne oma ane yaveni!” ");
INSERT INTO mti_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Meve mu me gumbe waya, “Me ge gungap dimbae ane? Me aninin yangagwa watabne?” ");
INSERT INTO mti_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Me mu gumbo gara wane, “Ne ye wait diruina. Megara ye den anoyana. Divi oya ye sira anotan oya ene? Ye imuyep gaibu me aigowawa atan anoene?” ");
INSERT INTO mti_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mu me gumbe danowa piriwane sira waya, “Ge apan me aigowawa! Nu Mosisi aigo meumawa! ");
INSERT INTO mti_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nu yaug anotu God me Mosisi gumbe wanewa. Megara nu den di yaug anotu apan me ampa onne.” ");
INSERT INTO mti_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Apan me gara wag dirumne, “Mame terana! Ye den yaug anoyana me ampa onne. Megara me ne yanganwa watabne. ");
INSERT INTO mti_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nu yaug anotu God kukaeba igiyawa vemewa den anoivi. Megara nu yaug anotu da bira God gumbe ayamat aivi sira me anoiviwa aiviwa, me gumbe God me anope. ");
INSERT INTO mti_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Apan da me yangawa boredneve yainewa yangawa watabnewa kuinuiyawa da den waya anotu piyu mame amatog onnewa. ");
INSERT INTO mti_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Apan me God gumbe den ompa ipawa, me divi da den apa.” ");
INSERT INTO mti_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mu gara waya, “Ge kukaeba kokavitwa gumbe di yaiyana, aninin gare nu toyau nuntan oya ege.” Meve mu me atataiya dauwag aine. ");
INSERT INTO mti_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesu anone mu me atataiya. Sira me apan me yaug wane, “Ge Apan Usiwa gumbe anotumat ege?” ");
INSERT INTO mti_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Apan me gara wane, “Kokawa, me bira? Ne didnega, ne imunap me gumbe anotumat atna.” ");
INSERT INTO mti_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iesu me gumbe wane, “Ge gare apan me yawana. Ge gaibu gae vegewa me me.” ");
INSERT INTO mti_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Me wane, “Ayapan, ne anotumat eni.” Sira me gumbe waiyane. ");
INSERT INTO mti_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Meve Iesu wane, “Ne keptete oya piyu mame uwana. Yangaboredmusiawa yaupe, sira yangowa oraiwa igiyawa mu yangowa borettan oya.” ");
INSERT INTO mti_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi igiyawa upeba me gaibu wakeya. Mu gae mame anoya. Sira me gumbe waya, “Nu mina yangunwa boredne, go?” ");
INSERT INTO mti_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iesu mu gumbo wane, “Ye yangewa boretpa ipawa, ye kukaeba den apono. Megara gare ye vene, ‘Nu oma ane yavete.’ Meoya kukaeba yeumawa ande wakene.” ");
INSERT INTO mti_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ne gae natawa diruieni. Apan da me sip si meuma ankwin gumbe den unikpe, sira ebu da ube gumbe dauwag aikpewa me ub abnawa ge upaatatuwa. ");
INSERT INTO mti_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Apan da me ankwin gumbe unikpewa me sip meuma amaraiviwa. ");
INSERT INTO mti_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ankwin amaraiviwa me oya watappe, sira sip me noiwa anope. Me sip meuma iviwa meuma gumbe auwape, sira tam dauwag aipe. ");
INSERT INTO mti_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Me sip meuma undag tam dauwapewa, me namuwon yoig aipe. Sira sip meuma me amave ampe, kuiyawa mu me noiwa yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Megara mu noi ubewa amave den ampe. Mu matai me gumbe a ampe. Kuiyawa mu noi ubewa noiwa den yaug anoya.” ");
INSERT INTO mti_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesu mu gumbo maibe mame wane. Megara mu den yaug anoya me mu gumbo dimbae waivi. ");
INSERT INTO mti_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Meoya Iesu sira wane, “Ne gae natawa diruieni. Ne sip ankwinawa. ");
INSERT INTO mti_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iyayapan undag wait ne namunap uwayawa mu ub sira upoatatuwa. Sip mu me noiwa den anoya. ");
INSERT INTO mti_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ne ankwin. Da bira ne gunap unikpewa me matai waita aupe. Me matai unig ompe sira dauwag aipe, nakwaeba wayo oraiwa yaupe. ");
INSERT INTO mti_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ub abnawa me ub atan oya, toen guttan oya, wakukamtan oya uwape. Ne uwanawa mu inaiinai avigimtan oya, sira danowo noidauwatan oya. ");
INSERT INTO mti_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ne sip amat abnawa oraiwa. Sip amat abnawa oraiwa sip meuma oya inaiinai meumawa wavereaivi. ");
INSERT INTO mti_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Apan me anmaga gumbe nau wannewa me sip amat abnawa natawa onan, sira sip mu meumawa onan. Meoya mae urup ompe yaupewa, me sip yankweg a aipe. Meve mae urup me sip tampe, sira marewam ampe. ");
INSERT INTO mti_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Apan me a aivi. Kuiyawa me anmaga gumbe nau wannewa oya, sira me sip nonewa den aune oya. ");
INSERT INTO mti_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ne sip amat abnawa oraiwa. Ne sip neuma oya yaug anoeni. Sira sip neumawa ne yauneg anoeme. ");
INSERT INTO mti_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Maman ne yaug ano nedne sira ne Maman yaug anona mina di. Sira sip oya ne inaiinai neumawa wavereatna. ");
INSERT INTO mti_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne sip neumawa upeba gaibu, megara mu sip obiren mame si danave den wakeya. Mu mina ne tam ongetanit di. Mu mina ne nonwa anope, sira meve sip desirom agoniyape sira amat abnawa desirom ape. ");
INSERT INTO mti_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ne inaiinai neumawa wavereatnawa inaiinai neumawa sira autna, meoya Maman baigan gunap aivine. ");
INSERT INTO mti_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Bira da ne gunap inaiinai den aupe, megara nembo anoeniwa gumbe wavereatna. Ne yutunwa auna, me gumbe wavereatna, sira yutunwa gumbe me sira autna. Gwangwan mame Maman gumbe auna.” ");
INSERT INTO mti_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ju igiyawa gae mame anoyawa, mu yapowo sira kepteya. ");
INSERT INTO mti_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mu obiren waya, “Me airapu kukaeba dodne sira warago tone. Divi oya me gae waiviwa anoene?” ");
INSERT INTO mti_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Iyayapan upeba waya, “Apan mame gaiyawa me airapu kukaeba dodnewa gaiyawa mina onan. Aninin airapu kukaeba yangawa boredmusiawa oma ane watappe?” ");
INSERT INTO mti_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Me kumive, Jerusarem apa Temporu Waribiyatanwa Buyunaeba kumiwa aune. Me taig kumiwa. ");
INSERT INTO mti_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iesu me temporu arawa danave Soromon ebuwawa gwanob gaibuwa danave yoig gigivi. ");
INSERT INTO mti_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ju igiyawa gumbe birorot agoniyag waya, “Ge kum koniwa anintom mina nu mapa waketon nu anopipanum ete? Ge Keriso ipewa, taibe di diruna anota.” ");
INSERT INTO mti_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iesu mu gumbo gara wane, “Ne ye wait diruina. Megara ye anotumat den ene. Ne Maman iviwa gumbe irakoniwa eniwa me nenan oya taibe waivi. ");
INSERT INTO mti_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Megara ye anotumat den ene. Kuiyawa ye sip neuma onan. ");
INSERT INTO mti_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sip neuma ne nonwa anoya. Ne mu yaug ano munna, sira mu ne amanap onampe. ");
INSERT INTO mti_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne inaiinai yaibobot muntna. Mu bo den di ape, sira da bira oma den ane ne naninap mu tampe. ");
INSERT INTO mti_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ne Maman me mu ne gunap negnewa me kokavitwa. Me iyayapan undag mina onan. Da bira oma den ane Maman nanive mu tampe. ");
INSERT INTO mti_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ne Maman gaibu desirom.” ");
INSERT INTO mti_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ju igiyawa sira me totan oya an tamiya. ");
INSERT INTO mti_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iesu mu gumbo gara wane, “Ne irayauyau obiren ag ye toyau yenna. Irayauyau me Maman gumbe uwaya. Irayauyau ambuwa gumbe ye imuyep an gumbe tonektan oya ene?” ");
INSERT INTO mti_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ju igiyawa me gumbe gara waya, “Nu an gumbe ge toaktan etewa me dividivi mame gumbe da oya onan, megara God gumbe ae vege oya. Kuiyawa ge apanirenwa, megara ge God mina ege.” ");
INSERT INTO mti_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iesu gara mu gumbo wane, “‘Ne wana ye God,’ Gwangwan yeuma danave me tene, go onan? ");
INSERT INTO mti_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Baiboru oma den ane onan di ape.—Iyayapan God gae meuma auyawa gumbo ‘Ye, God,’ meib wapa ipawa,— ");
INSERT INTO mti_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Maman mu toyau munnewa ne iyakaisiyapama, sira piyu mame oya Me baraunedne uwana. ‘Ne God Usiwa,’ ne wana oya, divi oya ‘Ge God gumbe ae vege,’ ye wayana? ");
INSERT INTO mti_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ne Maman nauwawa den aigimpopo ipawa, ne den anotumat negiya. ");
INSERT INTO mti_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Megara ne me eniwa, sira ande ye ne gunap oma den ane anotumat aya ipewa, irakoniwa neuma me gumbe anotumat aya. Me gumbe Maman ne dananap wakene, sira ne Maman danave wakenawa ye matai yaimoyai anoya sira yaug anoya.” ");
INSERT INTO mti_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Mu sira me yumtanwa oya aya, megara me nanuwo dauwag aine. ");
INSERT INTO mti_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Meve Iesu taig yoi Jodan gambenwa dauwag aine, sira Jon amatog babataito amunivi arawa aine. At me apa wakene. ");
INSERT INTO mti_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Iyayapan obiren me gumbe onamiya. Mu waya, “Jon irakoniwa desirom da den di ane, megara gae undag Jon apan mame oya wanewa me natawa.” ");
INSERT INTO mti_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","At me apa, iyayapan obiren Iesu gumbe anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gare apan da iviwa Rasaros me yuwarane. Me at Betani apan, at me Meri ge yogiyawa Maata gwetoimu mumawa. ");
INSERT INTO mti_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Vesin Meri mame me vesin desiroma me oira tayapama oraiwa Ayapan gumbe egamne sira me amawa kuiyagumawa gumbe muinnewa. Me yuba Rasaros yuwarane. ");
INSERT INTO mti_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Meoya yogiyawaiwa Iesu oya gae baraug waya, “Ayapan, apan me ge baigan niegewa yuwarane.” ");
INSERT INTO mti_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iesu mame anog wane, “Yuwat mame matai bo gumbe den onanape. Me God eyawa meuma oya. God Usiwa me gumbe eyawa aupe.” ");
INSERT INTO mti_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesu baigan ane Maata ge me yogiyawa ge Rasaros gumbo. ");
INSERT INTO mti_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Iesu anone Rasaros me yuwarane, megara me wakenewa apa oiyat duwam sira wakene. ");
INSERT INTO mti_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Meve me aigowawa gumbo wane, “Sira Judia anta.” ");
INSERT INTO mti_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aigowawa me gumbe waya, “Rabai, watavit koni kusi da, Ju igiyawa an gumbe tottan aya, megara sira taig asime agetan ege?” ");
INSERT INTO mti_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iesu gara wane, “Kum me kum koniwa 12 gaibu, go onan? Da bira kum aipewa me uyug den aikpe. Kuiyawa me piyu mame eyawa meuma yavivi. ");
INSERT INTO mti_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Da bira arampuna aipewa me uyug aikpe. Kuiyawa me danave eyawa den wakene.” ");
INSERT INTO mti_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Namu me mame wane, ivi sira dirum wane, “Apan numawa Rasaros me di kubvinivine, megara ne asime angeni, me wagwa nampna wan yoipe.” ");
INSERT INTO mti_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Me aigowawa garawa me gumbe waya, “Ayapan, me kubvinigimpe ipewa, me sira oraimina ape.” ");
INSERT INTO mti_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iesu me bo meumawa oya wane. Megara me aigowawa anoyawa me kubiren oya waivi. ");
INSERT INTO mti_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Meve Iesu taibe mu dirumne, “Rasaros me boane. ");
INSERT INTO mti_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ne yenan degadega eni ne me apa onan. Kuiyawa ye anotumat aigimtan oya. Megara menan anta.” ");
INSERT INTO mti_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Meve Tomas (mu waya Didimas) aigowawa upeba gumbo wane, “Nu mina anta, sira me gaibu bo ata.” ");
INSERT INTO mti_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Iesu uwanewa, me yaug anone Rasaros wait dagup danave barauya kum duwam ge duwam onanane. ");
INSERT INTO mti_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani me Jerusarem megiyave, 3 kiromitas mina. ");
INSERT INTO mti_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Sira Ju igiyawa obiren tatowa oya Maata ge Meri munan watmemeyam muntan oya onamiya. ");
INSERT INTO mti_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata Iesu onivi anonewa, me yautan dauwag aine. Megara Meri gweyau wakene. ");
INSERT INTO mti_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata Iesu gumbe wane, “Ayapan, ge mapa wakepa ipawa, ne yunwa den bo apa. ");
INSERT INTO mti_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sira ne gare mame ande yaug anoeni ge divi oya wawa me God matai gempe.” ");
INSERT INTO mti_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iesu me gumbe wane, “Ge yugwa matai sira inaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata gara me gumbe wane, “Ne yaug anoeni kum oieba apa sira inaig yoitanwa kumive me sira inaig yoipe.” ");
INSERT INTO mti_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iesu me gumbe wane, “Ne sira inai muttanwa, ge inaiinaiba. Da bira ne gunap anotumat apewa, me boape ipewa matai sira inaig wakepe. ");
INSERT INTO mti_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sira da bira wakeg anotumat ne gunap apewa, me bo den di ape. Ge mame anotumat ege?” ");
INSERT INTO mti_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Vesin me gumbe wane, “E, Ayapan. Ne anotumat eni ge me Keriso God Usiwa. Ge piyu mame gumbe uwatanwa oya wayawa.” ");
INSERT INTO mti_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Namu me mame wanewa, ivi me taig aine sira yogiyawa Meri auwane menan onne. Me wane, “Toewanewan me asime. Me genan oya waivi.” ");
INSERT INTO mti_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Meri mame anonewa, me tatevit wan yoig menan aine. ");
INSERT INTO mti_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gare Iesu gwetoimu den unigne. Maata menan yaunewa arawa apa ande wakene. ");
INSERT INTO mti_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ju igiyawa mu Meri gaibu gwe danave watmemeyam wakeyawa yawamiya, me tatevit wan yoig aine. Me dagup aig asime apa iruwatan aivi anog, mu me amave amiya. ");
INSERT INTO mti_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Meri at me Iesu wakenewa uwane. Me yaunewa, me amave namive aig wane, “Ayapan, ge mame apa wakepa ipawa, ne yunwa bo den apa.” ");
INSERT INTO mti_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iesu yaune me iruwaivi sira Ju igiyawa me gaibu onamiyawa mina iruveme. Me guwawa gumbe anogugut kokavit ag danadawai aune. ");
INSERT INTO mti_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Me wane, “Ye me ampa barauyana?” “Ayapan. Onag yawa,” mu me gumbe waya. ");
INSERT INTO mti_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iesu iruwane. ");
INSERT INTO mti_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Meve Ju igiyawa waya, “Yauya, me gumbe baigan koka meuma me aninin!” ");
INSERT INTO mti_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Megara mu upeba waya, “Apan me apan yangabored yangawa watabne, megara me oma den ane apan mame yumnadne me bo den ape?” ");
INSERT INTO mti_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iesu sira danadawai kokavit aune, sira dagup oya onne. Dagup me nog kokawa an gumbe ankwin toboremewa. ");
INSERT INTO mti_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iesu wane, “An me atan auya.” Maata me boanewa yogiyawa wane, “Ayapan. Gare mame gumamawa kukaine. Kuiyawa me barauya kum duwam ge duwam onanane.” ");
INSERT INTO mti_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iesu me gumbe wane, “Ne ge dirugna, go onan? Ge anotumat a ipewa, ge God eyawa meuma yawa.” ");
INSERT INTO mti_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Meve mu an atan auya. Iesu yangut wan yaune sira wane, “Maman, ne ge gungap gaun veni ge ne wana anoana. ");
INSERT INTO mti_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne anona ge kum evedni ne veni anoege. Megara ne mame wana iyayapan obiren birorot yokeyawa oya, sira ge ne baraunegana onedna me mu matai anotumat atan oya.” ");
INSERT INTO mti_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesu meib wanewa, noiwa kokavit wane, “Rasaros, dauwag onaga!” ");
INSERT INTO mti_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Bo abnawa me naniwa ge amawa wape yobutataewa gumbe paniya sira wape da ginangawa paniyawa gaibu dauwag onne. Iesu mu gumbo wane, “Enwapeyawa atan vesiya sira yankweya aipe.” ");
INSERT INTO mti_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Meoya Ju igiyawa obiren mu Meri oya amdau onamiya sira Iesu anin anewa mu yauyawa, Iesu gumbe anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Megara iyayapan upeba Parisi oya amiya, sira wag dirumiya Iesu anin ane. ");
INSERT INTO mti_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Meve pirisi amaraiviwa ge Parisi igiyawa Daiboru Painauvitwa autan oya auwaya, sira waya, “Nu divi etan? Apan mame irakoniwa obiren aivi. ");
INSERT INTO mti_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu me yankweta meib aigimpe ipewa, iyayapan undag matai me gumbe anotumat ape. Sira meve Romu igiyawa onampe at numawa ge iyayapan numawa undag aupe.” ");
INSERT INTO mti_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Meve Kayapas me iyayapan mu danowo apan desirom sira bairawan me danave pirisi painauvitwa anewa mu gumbo gae wane, “Ye divi da den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ye den yaug anoyana me oraiwa yenan oya apan desirom boape iyayapan munan, megara iyayapan numawa undag boriruwapewa me oraimina onan.” ");
INSERT INTO mti_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mame me membo oya den wane. Me pirisi painauvitwa aneve iyape wane me Iesu Ju igiyawa undag oya bo totan aivi, ");
INSERT INTO mti_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","sira Ju igiyawa undag mukut oya onan, iyayapan ampa ampa God usitainawa amiyawa oya, me mu tam onampe agoniyape desirom ape oya me bo totan aivi. ");
INSERT INTO mti_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Me kumiwa apa, mu Iesu totanwa oya iyapeba paniya. ");
INSERT INTO mti_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Meoya Iesu Ju igiyawa gumbo taibe sira den gigivi. Meve Iesu yankweg at inguiwa megiyave aine sira gwetoimu me iviwa waya Epuraim unig aine, sira me apa me aigowawa gaibu wakeya. ");
INSERT INTO mti_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Sira Ju Uwag Gaveya Buyunaeba koni ane. Iyayapan obiren at kusikusiwa apa uwag agoniyag Jerusarem dog amiya, namu buyunai gumbe mu muintanwa oya, ivi Uwag Gaveya Buyunaeba kumiwa uwape. ");
INSERT INTO mti_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Mu Iesu oya didimama eme, sira mu temporu arawa apa yokeya, sira mu gae gara wag anoeme, “Ye aninin anoenan? Me buyunai oya ompe go onan?” ");
INSERT INTO mti_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Megara pirisi koukawa ge Parisi igiyawa gae yusipamit muneg waya, da bira Iesu ampa wakepe yaug anope ipewa, mu gumbo umum wape. ");
INSERT INTO mti_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iesu at Betani uwane. Oiyat 6 onanapeve Uwag Gaveya Buyunaeba uwape. Rasaros me Iesu wane bo gumbe inaig yoinewa asime wakene. ");
INSERT INTO mti_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Me apa Iesu oya augoi nakwaeba tamibarip aya. Maata nakwai kep aivi. Rasaros mu yapowo teboro apa me gaibu wakene. ");
INSERT INTO mti_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Meve Meri oira tayapama oraimina,—iviwa Narudo,—me garawa kokavitwa, ibnawa 300 grams mina aug sira Iesu amawa apa egamne, sira amawa kuiyagumawa gumbe muinne. Sira oira tayapama oraimina gwe dana undag noidauwane. ");
INSERT INTO mti_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Megara aigowawa desirom iviwa Judas Isukariot me ivi Iesu oya omin tetanwa wane, ");
INSERT INTO mti_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dimbae oya oira tayapama mame ge den gwiruwarana anmaga 300 denari gumbe aug gwandokwaeba igiyawa gumbo muntanwa.” ");
INSERT INTO mti_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mame me wanewa me gwandokwaeba igiyawa amat amuntan onan, me ub abnawa. Me anmaga eneme ikwaeba amaraiviwa, sira anmaga ikwaeba danave wakeyawa me membo oya anog ub aivi. ");
INSERT INTO mti_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iesu gara wane, “Yankweya me anoiviwa ape. Me imive oira tayapama mame baraune wakene ne sig um negatanwa kumiwa apa. ");
INSERT INTO mti_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ye kum minaminawa tawara onan igiyawa gaibu wakeigimiya, ne guniyap evedni den wakeeni.” ");
INSERT INTO mti_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ju igiyawa obiren yaug anoya Iesu me apa wakene, meoya onamiya. Iesu mekut oya den onamiya, megara Rasaros me bo gumbe me wane yoig wanednewa gaibu yautan onamiya. ");
INSERT INTO mti_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pirisi koukawa igiyawa Rasaros mina gaibu totan oya iyapeba paniya. ");
INSERT INTO mti_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Kuiyawa me oya Ju igiyawa obiren Iesu gumbe amome sira anotumat me gumbe eme. ");
INSERT INTO mti_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Umaipa, iyayapan obiren mu buyunai oya onamiyawa anoya Iesu Jerusarem oya ebu taibe onivi. ");
INSERT INTO mti_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Mu moyu kwayawa tam dauwag me yautan oya amiya, sira kwaruwaya, “Osanna! Ayapan iviwa gumbe uwaiviwa, me gumbe God waribiya wakeigimpe! Isuraeru kin mumawa, me gumbe waribiya wakeigimpe!” ");
INSERT INTO mti_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iesu donki mataiwa yaug egave dauwag wanedne, me wait tenewa mina, ");
INSERT INTO mti_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion Gwaitawa, den a aya. Yauya. Kin yeumawa me onivi, donki mataiwa egave.” ");
INSERT INTO mti_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Namiven aigowawa dividivi undag mame den yaug anoya. Megara namu Iesu eyawa aune, ivi mu meve yaug anoya dividivi undag mame menan oya wait tenewa, sira dividivi undag mame mu me gumbe aya. ");
INSERT INTO mti_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iyayapan mu Iesu Rasaros dagup apa auwane me sira bo apa wan yoig onnewa me kumive apa Iesu gumbe wakeeme igiyawa, mu yauyawa gaiyawa taibe waya. ");
INSERT INTO mti_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mame oya iyayapan obiren me gumbe embot veatan oya dauwag amiya, kuiyawa mu anoya Iesu irayauyau mame anewa. ");
INSERT INTO mti_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Meoya Parisi igiyawa gae garawano aya, “Nu divi da oraiwa den ete. Yauya, at undag me amave amome!” ");
INSERT INTO mti_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Iyayapan mu Buyunai danave waiya atan oya dauwag onamiya, sira mu danowo at Griisu igiyawa upeba wakeya. ");
INSERT INTO mti_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pirip me Betuseida Gariri danave apa onnewa, mu me oya onamiya, sira nun waya, “Iesu yautan anoete.” ");
INSERT INTO mti_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pirip me Andru ditan oya aine, meve Andru ge Pirip mu Iesu ditan oya amiya. ");
INSERT INTO mti_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iesu gara wane, “Apan Usiwa me eyawa autanwa kumiwa uwane. ");
INSERT INTO mti_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne natawa diruieni. Nakwai wiit yawa desirom piyu gumbe den aikpe boape ipewa, me di desirom wakeigimpe. Megara me boapewa, me natawa obiren iyaig dararuwape. ");
INSERT INTO mti_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Da bira inaiinai meuma oya baigan apewa me matai waropiyape, megara da bira inaiinai meuma piyu mame apa topayapewa, me matai yumnatpe sira inaiinai yaibobot aupe. ");
INSERT INTO mti_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Da bira nenan nau aiviwa me ne amanap ompe. Ne ampa waketnawa me mina me apa wakepe. Bira da nenan nau aiviwa me ne Maman garawa wampe. ");
INSERT INTO mti_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Gare ne nonenmagawa danadawai avieni, meoya ne aninin waten? ‘Maman, kum mame garewa apa waita nega,’ watna? Onan, kuiyawa kum mame oya ne uwana. ");
INSERT INTO mti_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maman, ivugwa eyawa meuma esipe!” Meve noiwa kwimin apa onne, “Ne eyawa wait ana esine, eyawa sira esipe.” ");
INSERT INTO mti_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iyayapan me apa wakeyawa anog waya, “Me kwimin wane,” upeba waya, “Me aneya me gumbe wane.” ");
INSERT INTO mti_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iesu wane, “Noiwa mame uwanewa me yenan oya, me nenan onan.” ");
INSERT INTO mti_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kum mame gare puiyuyu kumiwa piyu mame egave; gare piyu mame amaraivi abnawa atataipe dauwag aipe. ");
INSERT INTO mti_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Megara ne piyu mame apa dog aneknawa, ne matai iyayapan undag tampna onampe ne gunap.” ");
INSERT INTO mti_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Me mame wanewa me toyau munne bo aninin atanwa oya. ");
INSERT INTO mti_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iyayapan kwaruwaya, “Nu Gwangwan yaug anotu me Keriso wakeigimpe yaibobot, meoya ge me anin wa, ‘Apan Usiwa me dog aitanit di?’ ‘Apan Usiwa me bira?’” ");
INSERT INTO mti_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Meve Iesu mu dirumne, “Eyawa me kum kusi da guniyap wakepe. Meoya aisiya, eyawa guniyap wakene, sisip den panepe. Apan me arampuna aiviwa me den yaug anone me ampa aivi. ");
INSERT INTO mti_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wait eyawa guniyap wakenewa, eyawa me anotumat aya ye eyawa usitainaven atan oya.” Me gae wane onananewa, Iesu mu kwem guwave aine. ");
INSERT INTO mti_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Iesu dividivi undag irayauyau yangowo ane pawane, megara ande me gumbe anotumat den aya. ");
INSERT INTO mti_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Mame me propeta Aisaya gae meuma wanewa matattan oya, “Ayapan, gae numawa bira anotumat ane, sira bira gumbe Ayapan naniwa taibe ane?” ");
INSERT INTO mti_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Mu oma den ane anotumat aya, kuiyawa Aisaya gae da aib wane, ");
INSERT INTO mti_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Me wane mu yangowa boredne, sira Me wane mu nonowa yaigiwaya, meoya mu oma den ane yangowo yaupe, ge oma den ane nonomagave yaug anope sira nonowa den tobiyape, ge ne matai den warinamuntna.” ");
INSERT INTO mti_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaya mame wanewa me Iesu eyawa yaug me oya wane. ");
INSERT INTO mti_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Megara namuyoiyoi danowo obiren mu me gumbe anotumat aya. Megara mu taibe den waya, kuiyawa Parisi igiyawa munan a aya. Mu matai sinagogu apa atatai impe dauwag amtan den anoeme. ");
INSERT INTO mti_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kuiyawa mu imuwo iyayapan gumbo ayamat autan oya anoeme. Ayamat God gumbe atanwa me onan. ");
INSERT INTO mti_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Meve Iesu kwaruwane, “Bira da anotumat ne gunap aiviwa, me ne nekut gunap anotumat den aivi, megara ne baraunedne onednawa gaibu me gumbe anotumat aivi. ");
INSERT INTO mti_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bira da ne yaunegiviwa me apan da bira ne baraunedne onednawa me yavivi. ");
INSERT INTO mti_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ne piyu mame gumbe uwanawa me eyawa, me bira da ne gunap anotumat aigimpewa me sisip dana den wakeigimtan oya. ");
INSERT INTO mti_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bira da gae neuma anope sira den ape ipewa, ne matai pui me den yuwantna. Kuiyawa ne piyu mame pui yutanwa oya den uwana, megara waita muntan oya piyu mame uwana. ");
INSERT INTO mti_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Bira da ne topai negiviwa sira gae neuma den yumnasiviwa oya dividivi pui yuwatanwa me wakene. Gae me ne di wanawa me matai kum oieba kumiwa apa pui yuwampe. ");
INSERT INTO mti_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kuiyawa ne divi wanawa me ne gunap onan, megara Maman me baraunedne onednawa me divi watanit di sira anin toyau muntanit di wanewa gumbe ne veni. ");
INSERT INTO mti_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne yaug anona me gwangwaneba wanewa me inaiinai yaibobot aug ompe. Meoya ne divi veniwa me Maman didnedne gumbe veni.” ");
INSERT INTO mti_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Iesu yaug anone me piyu mame kweg Mamawa oya aitanwa kumiwa uwane, ivi Uwag Gaveya Buyunaeba uwape. Me iyayapan meumawa mu piyu mame egave wakeyawa baigan munne, me baigan amunivine aigin oieba. ");
INSERT INTO mti_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Augoi nakwaeba kumiwa apa, Seitan me Judas Isukariot me Saimon usiwa imiwa aune Iesu ominawa barautan oya. ");
INSERT INTO mti_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesu yaug anone me Mamawa dividivi undag Iesu nanive baraune, sira me God gumbe onne sira God oya taig aivine. ");
INSERT INTO mti_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Me nakwai arawa apa wan yoig wapeyawa geravewa arobne, sira wape tabero aug powave topanne. ");
INSERT INTO mti_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Meve, yoi kabum danave aregamne, amatog aigowawa amowa muinne, wape tabero powave topannewa gumbe muin karariya munne. ");
INSERT INTO mti_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Me Saimon Pita gumbe uwanewa, me me gumbe wane, “Ayapan, ge ne amanwa muina?” ");
INSERT INTO mti_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iesu gara wane, “Ge gare den yaug anoana divi ne eni, megara matai yaug anoa.” ");
INSERT INTO mti_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita wane, “Onan, garawapa ne amanwa den di muina.” Iesu gara wane, “Ne den muintnawa, ge ne gaibu onan.” ");
INSERT INTO mti_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pita gara wane, “Ayapan, amanwa mekut onan, naninwa ge kuiyanwa gaibu.” ");
INSERT INTO mti_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iesu gara wane, “Apan me yoi inewa me imive amawa mekut muimpe. Kwapiwa undag miyot onan. Sira ye miyot onan, megara ye da me miyot gaibu.” ");
INSERT INTO mti_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kuiyawa me yaug anone bira me omin meuma tetan oya aivi, meoya aib wane, “Ye miyot onan, megara ye da me miyot gaibu.” ");
INSERT INTO mti_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Amowa muinne onananewa, me wape meuma enne sira taig at meumawa onne. Singui munne, “Ne divi anawa ye yaug anoyana? ");
INSERT INTO mti_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ye ne gunap ‘Toewanewan’ sira ‘Ayapan’ wayana, me natawa di, kuiyawa ne me. ");
INSERT INTO mti_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ne, Toewanewan yeuma sira Ayapan yeuma, amewa muinnawa, ye mina meib amewa gara muin aigimiya. ");
INSERT INTO mti_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ne ye guniyap anawa ye mina meib atanit di. Ne guwaguwawa ye guniyap ana. ");
INSERT INTO mti_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne natawa diruieni. Nau aiviwa me kokawa onan, megara me ayapan meuma kokawa, sira gae aug aiviwa me kokawa onan, megara bira baraune onnewa me kokawa. ");
INSERT INTO mti_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Dividivi mame ye yaug anoyanawa, sira ye aigimiyawa ye waribiya yempe. ");
INSERT INTO mti_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ne ye undag oya den veni. Ne yaug anona iyayapan ne wait watgomiya munnawa. Megara mame me Baiboru wanewa me pawatan oya: ‘Da bira bredi neuma naiviwa me amadanawa ne gunap num eunegne.’ ");
INSERT INTO mti_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ne namu guniyap veni, meve pawape. Me wanampa me pawapewa, meve ye ne me anotumat atan oya. ");
INSERT INTO mti_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ne ye natawa diruieni, da bira apan da ne barauna onnewa aunewa me ne aunedne; sira da bira ne aunednewa me ne baraunedne onednawa aune.” ");
INSERT INTO mti_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Namu Iesu gae mame wanewa, ivi me guwawa gumbe danadawai aune, sira taibe wane, “Ne natawa diruieni, ye desirom da ne ominanwa baraupe.” ");
INSERT INTO mti_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mu den yaug anoya meoya mu anopipanum eme bira mu danowo apa oya me wane, meoya me aigowawa yangut garayau aya. ");
INSERT INTO mti_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iesu aigowawa desirom da me Iesu baigan niyanewa megiyave wakene. ");
INSERT INTO mti_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Meoya Saimon Pita me wid ge poe gumbe toyau wanne sira wane, “Diya ambuwa oya me wane.” ");
INSERT INTO mti_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iesu megiyave wakenewa, me singui ane, “Ayapan, me bira?” ");
INSERT INTO mti_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iesu gara wane, “Apan bira ne bredi musiwa kabum danave puwam wantnawa, apan me me.” Meve bredi musiwa puwamne sira Saimon usiwa Judas Isukariot gumbe wanne. ");
INSERT INTO mti_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas bredi aunewa, Seitan tatevit me gumbe unigne. Iesu me dig wane, “Divi anin atan egewa tatevit a.” ");
INSERT INTO mti_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Megara da bira nakwai arawa apa den yaug anone Iesu me gumbe mame divi oya wane. ");
INSERT INTO mti_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas anmaga me gumbe amaraivi oya, upeba aib anoya me Iesu dine divi da Buyunai oya gwiruwattan oya go divi da tawara onan igiyawa gumbo muntan oya. ");
INSERT INTO mti_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas bredi aunewa, tatevit dauwag aine. Aram wait uwane. ");
INSERT INTO mti_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas dauwag ainewa, Iesu wane, “Gare mame Apan Usiwa eyawa aune sira God me Apan Usiwa gumbe eyawa aune. ");
INSERT INTO mti_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","God me gumbe eyawa aune ipewa, God gaibu matai Usiwa oya membovit eyawa wampe, sira me gumbe tatevit eyawa wampe. ");
INSERT INTO mti_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ne usitainanwa, ne matai ye guniyap kusi koni waketna. Ye matai nenanwa diuya. Ju igiyawa dirumna mina, gare ye diruieni: ‘Ne ampa angeniwa ye matai oma den ane oneya.’ ");
INSERT INTO mti_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Gwangwan mataiwa ye guniyap yeneni, baigan garagara aya. Ne ye guniyap baigan ana mina, ye mina meib baigan garagara atanit di. ");
INSERT INTO mti_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ye baigan garagara aigimiya ipewa, mame gumbe iyayapan undag yaug anope me ye ne aigowanwa.” ");
INSERT INTO mti_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pita me gumbe singui wane, “Ayapan, ge ampa agege?” Iesu gara wane, “Ne ampa angeniwa ge gare mame oma den ane amanap onaga, megara ge matai amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita me gumbe singui wane, “Ayapan, divi oya gare mame oma den ane amagap onetna? Ne inaiinai neuma genan oya waropiyatna.” ");
INSERT INTO mti_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Meve Iesu gara wane, “Ge natawa di inaiinai geuma nenan oya baraua? Ne natawa dirugeni. Namu ge koni duwamdesi ne den yaug ano negana watan ege, ivi kokorek noiwa wape.” ");
INSERT INTO mti_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nonemagewa den danadawai aupe. God gumbe anotumat aya, me mina ne gunap anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ne Maman gweyave pantut obiren wakeya. Me mina meib onan ipawa, ne wait diruipopo. Ne at yeuma tamibarip atan oya me apa angeni. ");
INSERT INTO mti_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sira ne anekna yenan oya at tamibarip atnawa, ne sira taig onekna sira ne gunap ye waketan oya tam yempna, mame mina ne ampa waketnawa ye mina me apa wakeya. ");
INSERT INTO mti_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ye at me ebuwawa yaug anoyana ne ampa angeniwa.” ");
INSERT INTO mti_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas me gumbe wane, “Ayapan, nu den yaug anotu ge ampa agege, meoya nu aninin ebu yaug anoton?” ");
INSERT INTO mti_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iesu gara wane, “Ne ebu, natawa sira inaiinai. Ne gunap onanwa, bira da Maman gumbe oma den ane uwape. ");
INSERT INTO mti_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ye ne yaug ano negiyawa ipewa, ye Maman gaibu yaug anoya. Megara gare mame ye Maman yaug anoyana, sira wait me yauyana.” ");
INSERT INTO mti_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pirip me gumbe wane, “Ayapan, Mamagwa toyau nuna, meve nu gunup oma ape.” ");
INSERT INTO mti_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iesu gara wane, “Pirip, ne kum yobenut di ye guniyap wakena, megara ge ne den yaug ano negana. Da bira ne yaunednewa me Maman yaune. Divi oya vege, ‘Mamagwa toyau nuna?’ ");
INSERT INTO mti_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ge anotumat den ege ne Maman danave sira Maman ne dananap wakene? Gae ne ye guniyap veniwa me neumawa onan. Maman ne dananap wakenewa me nau meuma warivi. ");
INSERT INTO mti_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ne wana, ‘Ne Maman danave wakena, sira Maman ne dananap wakene.’ Ne wanawa anotumat aya. Go divi anawa gumbe anotumat aya. ");
INSERT INTO mti_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ne ye natawa diruieni, da bira anotumat ne gunap apewa, ne nau eniwa me matai ape. Sira me matai dividivi kokavitwa ape, me mame mina onan, kuiyawa ne Maman gumbe angeni. ");
INSERT INTO mti_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sira ne ivunwa gumbe divi da oya nun wayawa ne matai atna. Me Usiwa gumbe Maman eyawa autan oya. ");
INSERT INTO mti_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ye ivunwa gumbe divi da oya nun wayawa, ne matai me atna. ");
INSERT INTO mti_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ye ne gunap baigan ayawa ipewa, gwangwan neuma ye amaraya. ");
INSERT INTO mti_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Sira ne matai Maman gumbe nun watna, sira me matai amat ayenigimtan abnawa yempe. Me ye gaibu yaibobot wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Me Guwawa natawa di. Piyu mame oma den ane me aupe, kuiyawa me den yaupe sira den yaug anope. Megara ye me yaug anoyana, kuiyawa me ye gaibu vinivi sira me ye guniyap wakepe. ");
INSERT INTO mti_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne matai tanam mina den yan kweyempna, ne matai yenan sira taig onetna. ");
INSERT INTO mti_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kum koni kusi da, piyu mame oma den ane sira yaunekpe, megara ye matai yaunegiya. Kuiyawa ne inaig wakeeni, meoya ye mina meib inaig wakeya. ");
INSERT INTO mti_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kum me kumiwa, ye yaug anoya ne Maman gumbe wakena, sira ye ne gunap, ne ye guniyap. ");
INSERT INTO mti_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Bira da gwangwan neuma aug amarapewa, me apan me ne gunap baigan aiviwa. Apan me ne gunap baigan negiviwa Maman me gumbe matai baigan ape, sira ne mina me gumbe baigan atna, sira me gumbe ne taibe atna.” ");
INSERT INTO mti_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Meve Judas, me Judas Isukariot onan, wane, “Megara Ayapan, divi oya nu gunup taibe ana, sira piyu mame gumbe diwan den taibe ana?” ");
INSERT INTO mti_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iesu gara wane, “Da bira ne gunap baigan atan ape ipewa me ne gae neuma amarape. Meib ape ipewa, ne Maman me gumbe baigan ape, sira nu me gumbe onanta sira me gaibu wakeigimta. ");
INSERT INTO mti_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Da bira me ne gunap baigan den aiviwa me gae neuma den amaraivi. Gae mame anoenewa me ne gae neumawa onan, me Maman me ne baraunedne onednawa me gae meumawa. ");
INSERT INTO mti_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ne guniyap ande wakenave, dividivi undag mame ne ye guniyap wana. ");
INSERT INTO mti_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Megara Amat Ayenigimtanwa Abnawa, Me Guwawa Iyakaisiyapama, me ivunwa gumbe Maman baraupe ompewa, me matai dividivi undag ye guniyap toyau yempe, sira dividivi undag ne wanawa me wag diruiyempe ye sira anoya. ");
INSERT INTO mti_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yum ye guniyap baraueni, ne yum neuma ye yentna. Yum me ne yentnawa mina piyu mame den yempe. Nonemagewa den aya danadawai aupe, sira a den aya. ");
INSERT INTO mti_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ye anoene ne veniwa, ‘Ne angeni sira taig onekna ye guniyap.’ Ne gunap ye baigan aya ipewa, ye degadega aya me ne Maman gumbe angeni, kuiyawa Maman me kokavitwa ne mina onan. ");
INSERT INTO mti_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ne gare mame namu wait wag diruinave, ivi pawape. Me kuiyawa me pawapewa ye anotumat atan oya. ");
INSERT INTO mti_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ne ye gaibu gae yobenut den watna, kuiyawa piyu mame amaraiviwa me onivine. Me oma den ane ne gunap divi da ape. ");
INSERT INTO mti_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Megara piyu mame di yaug anope, ne Maman gumbe baigan eni sira ne me di eni Maman dividivi di wag didnednewa. Gare mame wan yoiya anta.” ");
INSERT INTO mti_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ne yoma greip natawa sira ne Maman me nau abnawa. ");
INSERT INTO mti_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Naniwa upeba me natawa den inamiviwa kesiape. Naniwa upeba me natawa inamiviwa me sivisip kwig waribiyape natawa obiren inampe. ");
INSERT INTO mti_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ne wait gae guniyap wanawa gumbe ye wait muinyenne oraimina ayana. ");
INSERT INTO mti_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ne gunap ande wakeigimiya, sira ne mina ye guniyap ande wakeigimpna. Naniwa mekut oma den ane natawa impe, me yoma greip gumbe waketanit di. Me mina ye ne gunap den wakeyawa ye oma den ane natawa iniya. ");
INSERT INTO mti_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ne yoma greip; ye naninaniwa. Apan ne gunap ande wakeigimpe ipewa, ne me danave wakeigimpna, me matai natawa obiren impe. Ne gunap den wakeyawa ye matai divi da den aya. ");
INSERT INTO mti_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Da bira ne gunap ande den wakeigimpe ipewa, me naniwa mina aug epa aorepe toyaipe; naninani meiba tam iyam dana emepe igampe. ");
INSERT INTO mti_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ye ne gunap ande wakeigimiya sira ne gae neumawa me ye guniyap ande wakeigimpe ipewa, nun divi da imuyep anoenewa nun waya, me matai yempe. ");
INSERT INTO mti_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ye natawa obiren inamiya, ye ne aigowanwa aya. Mame gumbe Maman eyawa aupe. ");
INSERT INTO mti_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Maman ne gunap baigan anewa mina, ne ye guniyap baigan yeneni. Gare baigan neuma gumbe ande wakeigimiya. ");
INSERT INTO mti_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ne gwangwan neuma gumbe ye wakeigimiya ipewa, ye baigan neuma danave wakeya, me gare di Maman gwangwan meuma amarag me baigan meuma danave wakeeni mina. ");
INSERT INTO mti_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ne dividivi mame diruina, kuiyawa me degadega neuma ye guniyap wakepe sira degadega yeuma matai kokavit atanwa oya. ");
INSERT INTO mti_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ne baigan yenan anawa mina baigan garagara aya. Mame me Gwangwan neuma. ");
INSERT INTO mti_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Apan da me inaiinai meuma evebaviwa oya barautan, baigan kokawa da mame mina onan. ");
INSERT INTO mti_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ye gwangwan neuma aya ipewa, ye ne owanaiwa. ");
INSERT INTO mti_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne ye nau neuma ene igiyawa sira den watna, kuiyawa nau aivi abnawa me kokawa meuma aiviwa den yaug anone. Megara, ne ye watna owanaiwa, kuiyawa dividivi undag Maman gumbe anonawa wag diruina ye yaug anoene. ");
INSERT INTO mti_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ye ne den wagomiya negiyana, megara ne ye wagomiya yenna. Me ye aisiya sira natawa obiren inamigimtan oya, sira Maman dividivi undag ne ivunwa gumbe ye nun wayawa me matai yempe oya. ");
INSERT INTO mti_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Baigan garagara aya, mame ne gwangwan neumawa. ");
INSERT INTO mti_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Piyu mame topaiyempewa, me yaug anoya me namu ne topainedne. ");
INSERT INTO mti_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ye piyu mame imui danewa aupawa, piyu mame ye guniyap baigan niempopo. Megara ye piyu mame meumawa onan. Ne ye piyu mame apa wagomiya yenna. Meoya piyu mame ye topaiyenne. ");
INSERT INTO mti_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ne wana, ‘Nau aiviwa me kokawa onan, megara me ayapan meuma kokavitwa.’ Gae mame ne wanawa imug anoya. Mu ne edawai negiyawa, ye mina edawai yempe. ");
INSERT INTO mti_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mu ye mamaib amat aiyempe ne ivunwa oya, kuiyawa mu ne baraunedne onednawa den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ne den uwag mu gumbo den gae wapopowa, mu kukaeba muma da den wakene. Megara gare mame di mu kukaeba muma oya singui onan. ");
INSERT INTO mti_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Bira da ne topai negiviwa me Maman gaibu topayaivi. ");
INSERT INTO mti_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ne daneyap divi da me bira da den anewa den anawa ipawa, kukaeba muma onan. Megara gare mame ne ge Maman irayauyau numa yaveme, sira nu duwam gunup topai nuneme. ");
INSERT INTO mti_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mame matadnewa me Gwangwan meuma danave gae divi tenewa me pawatan oya. Gae me mamaib wane, ‘Mu topai negiya, kuiyawa da onan.’ ");
INSERT INTO mti_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ne Amat Ayenigimtanwa Abnawa Maman gumbe barautna ompe. Me Guwawa Natawa me Maman gumbe ompewa. Me ompewa nenan taibe wag diruipe. ");
INSERT INTO mti_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ye ne gaibu amatog onnewa gumbe wakeete, meoya ye gaibu taibe wag dirumiya. ");
INSERT INTO mti_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ne dividivi mame wag diruieni, kuiyawa ne imunap ye den uyug aigiya. ");
INSERT INTO mti_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mu sinagogu apa ye atatai yempe. Ne natawa diruieni, kum uwape. Me kumive iyayapan ye gurempe, sira mu anoemewa mu God gumbe nau meuma eme. ");
INSERT INTO mti_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Mu mame apewa mu Maman ge ne den yaug ano nuniya. ");
INSERT INTO mti_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ne mame diruina, kuiyawa kum me uwapewa ye yaug anoya dividivi undag ne diruinawa. Ne mame namu den diruina, kuiyawa ne ye guniyap wakeeni oya. ");
INSERT INTO mti_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Megara gare ne Maman me ne baraunedne onednawa oya angetan eni. Sira ye undag nenan singui den waya, ‘Ge ampa agege?’ ");
INSERT INTO mti_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Megara mame diruina, meoya danadawai noneyap noidauwane. ");
INSERT INTO mti_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Megara ne natawa diruieni, ne aneknawa ye oraiwa yeuma oya. Den aneknawa, Amat Ayenigimtanwa Abnawa matai guniyap den ompe. Megara ne anekna ipewa, ne me barautna guniyap ompe. ");
INSERT INTO mti_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Me uwapewa me kukaeba oya, oraiwa oya, pui yutanwa oya piyu mame toyau mumpe. ");
INSERT INTO mti_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ne kukaeba oya gae veni, kuiyawa mu ne gunap anotumat den eme. ");
INSERT INTO mti_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Sira ne oraiwa oya gae veni, kuiyawa ne Maman gumbe anekna sira ye oma den ane ne sira yaunegiya. ");
INSERT INTO mti_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne pui yutanwa oya gae veni, natawa me piyu mame amaraiviwa matai pui aupe. ");
INSERT INTO mti_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ne ye diruitanwa gunap obiren wakeya, megara ye oma den ane gare yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Megara Me, Guwawa Natawa, uwapewa me matai ye aigo yempe, dividivi undag natawa gumbe. Me matai membo anoiviwa den wape, megara me dividivi anoiviwa me wape, sira me dividivi apewa me oya wape. ");
INSERT INTO mti_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Guwawa me ne eyawa neuma aug uwape. Me matai ne neumawa aupe sira ye guniyap ape ye yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Dividivi undag Maman meumawa me neumawa. Meoya ne wana Guwawa me neumawa aupe sira ape ye yaug anoya. ");
INSERT INTO mti_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kum koni kusi da ye ne den yaunegiya, sira me ivi kusi da yobenut onan ye ne sira yaunegiya.” ");
INSERT INTO mti_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Aigowawa upeba gae gara waya, “‘Kusi da yobenut onan ye oma den ane ne sira yaunegiya, meve me ivi kusi da yobenut onan ye ne sira yaunegiya,’ sira ‘Kuiyawa ne Maman oya angeni,’ me meib wanewa natawa aninin?” ");
INSERT INTO mti_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ande mu singui eme, “Anininwa oya aib wane, ‘Kum yobe onan?’ Nu den yaug anotu me divi waivi.” ");
INSERT INTO mti_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Iesu yaug anone mu imuwo mame oya singui ape, meoya me mu gumbo wane, “Ye gae gara wa anoene, ‘Kusi da yobe onan ye oma den ane ne sira yaunegiya, sira me ivi pungi den wape ne sira yaunegiya,’ ne meib wanawa oya? ");
INSERT INTO mti_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ne natawa diruieni, ye iruwaigimiya sira danadawai avigimiya, megara piyu mame degadegaeba aigimpe. Ye matai danadawai avigimiya, megara ye danadawai yeuma tobiyape degadega ape. ");
INSERT INTO mti_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vesin ud barautan oya me dawai aupe, kuiyawa kum meuma uwane. Megara ud yaipewa me dawai imiwa atataipe, kuiyawa ud piyu mame gumbe yaine oya vesin degadega meumawa kokavit aivi. ");
INSERT INTO mti_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gare ye danadawai yeuma kumiwa, megara ne sira ye yauyempna, meve ye degadega aya, sira ye degadega yeuma da bira den aug aipe. ");
INSERT INTO mti_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Me kumive ye ne sira den divi da oya singui negiya. Ne natawa diruieni, divi da oya ne ivunwa gumbe nun wayawa Maman matai yempe. ");
INSERT INTO mti_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ye ne ivunwa gumbe divi da oya nun den wayana onne gare mame. Nun wayawa, ye matai auya. Me degadega yeuma kokavit atan oya. ");
INSERT INTO mti_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ne dividivi mame oya maibe gumbe guniyap wana. Kum uwapewa, maibe gumbe den watna, megara Maman oya taibenut diruitna. ");
INSERT INTO mti_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Me kumive ye matai ne ivunwa gumbe nun waigimiya. Ne aib den veni, ‘Ne matai Maman gumbe nun watna yenanwa oya.’ ");
INSERT INTO mti_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Maman membo ye guniyap baigan aivine, kuiyawa ye ne gunap baigan ayana sira anotumat ayana me ne God gumbe onedna. ");
INSERT INTO mti_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne Maman gumbe onedna, piyu mame uwana. Ne piyu yankweeni sira Maman oya taig angeni.” ");
INSERT INTO mti_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Meve Iesu aigowawa waya, “Ge gare gae taibenut vege sira gae maibe gumbe den vege. ");
INSERT INTO mti_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gare nu yaug anotu me ge dividivi undag yaug anoyana, sira me bira da imive wakenewa den ge singui gempe. Mame ane nu anotumat atune me ge God gumbe onagana.” ");
INSERT INTO mti_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iesu gara wane, “Ye gare mame anotumat anegene? ");
INSERT INTO mti_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yauya. Kum me onivine sira wait uwane, me kumive ye matai marewan aisiya. Ye desirom desirom matai gweyeban aisiya. Ye matai nekut yankwenegiya. Megara ne nekut den waketna, kuiyawa Maman me ne gunap wakeivi. ");
INSERT INTO mti_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ne dividivi undag mame wait diruinawa, me ne gunap ye yum autan oya. Piyu mame danave ye matai danadawai auya. Megara yutuiwa sira auya! Ne wait piyu mame tona aigne.” ");
INSERT INTO mti_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Iesu mame wane, meve kwimin yaug nun wane: “Maman, kum wait uwane. Ud geuma me eyawa geumawa oma ane sira tobiyag gentan oya eyawa ud geuma wana. ");
INSERT INTO mti_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kuiyawa yusiwa me iyayapan undag amaramuntan oya ge wanana. Me iyayapan me wananawa undag gumbo inaiinai yaibobot muntan oya. ");
INSERT INTO mti_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Inaiinai yaibobot me God ge Iesu Keriso yaug anotanwa; God me desiromirenwa ge natawa, sira Iesu Keriso me God baraune onnewa. ");
INSERT INTO mti_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nau me ne wattanwa oya ge neganawa wadna onanane, sira ne piyu egave eyawa geuma toyau munna. ");
INSERT INTO mti_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maman, namu ge gungap wakenawa, ne eyawa gaibu, ivi at piyu ge wad teyana. Me eyawa desiroma gumbe, gare mame di ge gungap waribiya nega. ");
INSERT INTO mti_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Iyayapan piyu mame egave neganawa mu gumbo ivugwa toyau munna yaug anogemiya. Mu geumawa, sira ge mu ne gunap negana, sira mu gae geumawa aug amaraya. ");
INSERT INTO mti_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gare mu yaug anoya dividivi ge ne neganawa me ge gungap onne. ");
INSERT INTO mti_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kuiyawa ne gae ge neganawa me mu dirumna, sira mu me aviya. Mu me yaug anoya me ne e baraunegana onedna, sira mu anotumat aya me ge baraunegana onedna. ");
INSERT INTO mti_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ne mu munan nun veni. Ne piyu mame oya nun den veni, megara iyayapan neganawa oya munan nun veni, kuiyawa mu geumawa. ");
INSERT INTO mti_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Neumawa undag me geumawa, sira geumawa undag me neumawa. Sira ne eyawa mu gumbo auna. ");
INSERT INTO mti_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ne piyu mame gumbe yobe den waketna, megara mu piyu mame gumbe ande wakepe, sira ne genan ongeni. Maman Iyakaisiyapama, mu egowon a ivugwa yusiwa gumbe—ivugwa me ne neganawa—me gumbe mu desirom ape nu minun. ");
INSERT INTO mti_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ne mu gumbo piyu mame danave wakenawa ivugwa me neganawa gumbe mu egowon ana, sira amat amunna bainda wakeya. Da bira den inanadne, megara da bira watkukamtan usiwa me inanadne. Me me gumbe Baiboru natawa pawatan oya. ");
INSERT INTO mti_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Gare mame genan ongeni. Megara piyu mame apa ande wakenave dividivi mame veni, me gumbe ne degadega neuma mu yapowo noidauwatan oya. ");
INSERT INTO mti_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gae geumawa wait munna, megara piyu mame mu topai munne. Kuiyawa, ne piyu mame abnawa onan, ne mina mu gaibu piyu mame igiyawa onan. ");
INSERT INTO mti_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Piyu mame apa mu atan tamtan oya nun den veni, megara kukaeba igiyawa gumbo mu egowon atan oya nun veni. ");
INSERT INTO mti_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ne piyu mame abnawa onan, ne mina mu piyu mame igiyawa onan. ");
INSERT INTO mti_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Natawa gumbe mu muin iyakaisi ape, ge gae geuma me natawa. ");
INSERT INTO mti_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ge piyu mame danave ne baraunegana uwanawa mina, ne mu temunna piyu mame danave amiya. ");
INSERT INTO mti_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Munan oya ne nembovit muintna iyakaisi eni, me mu mina meib natawa gumbe muin iyakaisi atan oya. ");
INSERT INTO mti_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Ne mu mukut munan nun den veni. Gae muma gumbe anotumat ne gunap emewa igiyawa munan gaibu nun veni. ");
INSERT INTO mti_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Kuiyawa, Maman, ge ne gunap sira ne ge gungap me mina mu undag desirom atan oya. Mu mina nu gunup ape, me gumbe piyu mame anotumat ape me ge ne baraunegana onedna. ");
INSERT INTO mti_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eyawa ge neganawa me munna. Nu desirom atunewa mina, me gumbe mu mina meib desirom aigimtan oya. ");
INSERT INTO mti_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne mu danowo sira ge ne dananap wakeya. Me mu desirom di yusipamit atanwa oya. Me kuiyave piyu mame yaug anope me ne ge baraunegana onedna sira ge ne gunap baigan ana mina, ge mu gumbo gaibu baigan ana. ");
INSERT INTO mti_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Maman, ne imunap iyayapan neganawa ne wakeeni arawa apa gunap wakeigimpe. Me gumbe mu eyawa neuma yaupe, eyawa me ge neganawa kuiyawa me ge baigan gunap ana ivi piyu mame wad teyana. ");
INSERT INTO mti_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ne Maman oraivitwa, piyu mame me ge den yaug anogemne, megara ne ge yaugem anona, sira mu yaug anoya me ge ne baraunegana onedna. ");
INSERT INTO mti_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne ana mu ivugwa yaugem anoya, sira ne me aigimtanit di. Kuiyawa me baigan geuma neganawa matai mu danowo wakeigimpe, sira ne nembo mina meib ne mu danowo wakeigimpna.” ");
INSERT INTO mti_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Iesu me gae mame wane onananewa, me aigowawa gaibu yankweg sira yoi Kideron aig dauwag amiya. Ama asi gambenwa apa nau benawa da wakene, sira Iesu ge aigowawa me danave unig amiya. ");
INSERT INTO mti_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas me omin barautan anoiviwa at me yaug anone, kuiyawa Iesu kum minaminawa aigowawa gaibu at me apa agonieme. ");
INSERT INTO mti_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Meoya Judas me apa onne. Mut igiyawa ge temporu amareme igiyawa mu pirisi koukawa ge Parisi igiyawa gumbo onamiyawa Judas namuyoiyoi amunne. Mu damempa, dun ge mut tam omome. ");
INSERT INTO mti_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iesu mame undag me gumbe pawatan aiviwa yaug anone, sira dauwag aig mu singui munne, “Ye bira diuene?” ");
INSERT INTO mti_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Mu gara waya, “Iesu Nasaret abnawa.” Iesu wane, “Ne me.” Sira Judas omin barautan aivinewa me apa mu gaibu yokene. ");
INSERT INTO mti_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Iesu, “Ne me,” aib wanewa, mu daiyowon taig piyu egave uyug aigiya. ");
INSERT INTO mti_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mu gumbo me sira singui munne, “Ye bira diu ene?” Sira mu waya, “Iesu Nasaret abnawa.” ");
INSERT INTO mti_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iesu gara wane, “Ne wait diruina, ‘Ne me.’ Ye nenan didimama aigimiya ipewa, iyayapan mame yankwemiya ampe.” ");
INSERT INTO mti_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Mame pawanewa me gumbe gae me wanewa me natawa atan oya: “Iyayapan ge neganawa desirom da ne den waropiyana.” ");
INSERT INTO mti_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Meve Saimon Pita benesi gumbe wakenewa, aug uwag aike pirisi painauvitwa nau aivi abnawa me naunawa yutanwa kwagomiyane. Nau aivi abnawa me iviwa Marukas. ");
INSERT INTO mti_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Iesu Pita gumbe wane, “Benesi geuma atan barauwa. Ne Maman ap me ne nednewa den natna go onan?” ");
INSERT INTO mti_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Meve mut igiyawa ge mut namuyoiyoi abnawa kokawa gaibu sira Ju igiyawa teya onamiyawa Iesu yumeg tuiya. ");
INSERT INTO mti_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Sira namu Annas oya namuwon baraug aug amiya. Me Kayapas nimnagawa apanwa. Me bairawan me danave me pirisi painauvitwa ane. ");
INSERT INTO mti_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapas me apan bira Ju igiyawa naunowa yunewa. Me wanewa me oraiwa apan da desirom boape iyayapan munan. ");
INSERT INTO mti_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon Pita ge aigowawa upeba desirom mu Iesu amave amome. Aigowawa mame me Iesu gaibu pirisi painauvitwa gweyawa arawa apa unigne, kuiyawa pirisi painauvitwa me apan mame yaug anone. ");
INSERT INTO mti_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Megara Pita ankwin noiwa apa di amarane. Aigowawa da me pirisi painauvitwa yaug anonewa dauwag aine, sira me ankwin amaraiviwa gumbe gae wane sira Pita aug unigne. ");
INSERT INTO mti_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ankwatave nau aivi vesinawa me ankwin amaraiviwa me Pita gumbe singui wane, “Ge me aigowawa da go onan?” Me gara wane, “Ne onan.” ");
INSERT INTO mti_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Me taig, meoya nau eme igiyawa ge temporu amareme igiyawa uwa amiwatan oya iyam okeriyawa omagawa gumbe birorot yokeya. Pita gaibu mu gaibu yokeg iraivi. ");
INSERT INTO mti_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pirisi kokavitwa Iesu gumbe aigowawa sira toyau toyau meuma oya singui ane. ");
INSERT INTO mti_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iesu me gumbe gara wane, “Ne piyu mame gumbe gae taibenut di wana. Ne kum evedni sinagogu ge temporu arawa me Ju igiyawa undag agoniemewa apa toyau muneni. Ne gae da guwave den wana. ");
INSERT INTO mti_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Divi oya ne gunap singui vege? Iyayapan ne gunap anoyawa mu gumbo singui muna. Ne divi wanawa mu yaug anoya.” ");
INSERT INTO mti_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesu gae mame wanewa, temporu amareme igiyawa da wane, “Ge pirisi painauvitwa gumbe ebu mame mina garawa wana?” Sira me Iesu tone. ");
INSERT INTO mti_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iesu me gumbe gara wane, “Ne gae gwambe wapopo ipawa, divi kukaine oya taibe wa. Megara ne gae natawa wanawa, divi oya ne tonegana?” ");
INSERT INTO mti_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Meve Annas wane me tueg murapepam, aueg pirisi painauvitwa Kayapas oya amiya. ");
INSERT INTO mti_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita yokeg iyam iraivine, iyayapan me gumbe singui ag waya, “Ge me aigowawa da go onan?” Pita me yan umne wane, “Ne me onan.” ");
INSERT INTO mti_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Pirisi kokavitwa me nau eme igiyawa meuma da, me apan bira naunawa Pita kwagomiyanewa mu dam desiroma, me wane, “Ne ge orivu nau benawa danave yawagna go onan?” ");
INSERT INTO mti_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita sira uyai wane, me kumive kumkum tatevit wane. ");
INSERT INTO mti_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Meve Ju igiyawa Kayapas gumbe Romu amaraiviwa abnawa gweyawa kokawa meuma danave Iesu aug amiya. Gare mame mumbevit, Ju igiyawa mu Uwag Gaveya Buyunaeba natan oya miyot autan den anoeme, meoya mu gweyawa kokawa meuma danave den unigiya. ");
INSERT INTO mti_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Meoya Pairat mu gumbo dauwag aine, sira singui wane, “Apan mame ikikiene kuiyawa divi oya?” ");
INSERT INTO mti_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Mu gara waya, “Apan mame kukaeba den apa ipawa, nu me den aug genan onampono.” ");
INSERT INTO mti_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pairat mu gumbo wane, “Ye yembovit me auya sira gwangwan yeumawa gumbe pui yuya.” Meve Ju igiyawa me gumbe waya, “Megara nu apan da tota bo atanwa oya nu yutunwa da den wakene.” ");
INSERT INTO mti_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Mame pawanewa me Iesu bo aninin atan aiviwa oya gae wanewa me natawa atan oya. ");
INSERT INTO mti_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Meve Pairat gweyawa kokawa danave taig unig aine, sira Iesu oya auwag me gumbe singui ane, “Ge Ju igiyawa kin mumawa?” ");
INSERT INTO mti_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iesu gara wane, “Yan me ge singui geumawa, go iyayapan upeba nenan oya ge gungap wayawa?” ");
INSERT INTO mti_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pairat gara wane, “Ne Ju abnawa? Ge augem nenan onamiyawa me iyayapan geumawa sira pirisi amarayawa geumawa. Ge divi ana?” ");
INSERT INTO mti_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iesu gara wane, “Ne at toimu neuma piyu mame danave onan. Me piyu mame danave wakepopo ipawa, ne nau neuma eme igiyawa mu Ju igiyawa gumbo ne aunettan eme oya mut watpono. Megara ne at toimu neuma me at da apa wakene.” ");
INSERT INTO mti_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pairat me gumbe wane, “Meoya ge kin?” Iesu gara wane, “Me natawa di, ge wanawa mina ne kin. Mame oya ne yaina. Sira mame oya ne piyu mame danave uwana natawa taibenut atan oya. Iyayapan undag mu natawa danave wakeemewa mu ne nonwa avigimpe.” ");
INSERT INTO mti_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pairat me gumbe singui wane, “Natawa me dimbae?” Me mame wanewa, Ju igiyawa oya dauwag aine, sira wane, “Me gumbe kukaeba da den yauna. ");
INSERT INTO mti_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Megara nu inaiinai numawa wakene. Ne ye guniyap nog abnawa desirom Uwag Gaveya Buyunaeba apa yankwetna dauwag aipe. Ye anoene ne Ju igiyawa kin muma yenan kwetna dauwag aipe?” ");
INSERT INTO mti_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mu au ge kwat sira waya, “Onan, apan mame onan. Barabas nuna.” Barabas me to aore ag tawara tamivi abnawa kukaeba da. ");
INSERT INTO mti_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Meve Pairat Iesu aune sira ane murap gumbe toya. ");
INSERT INTO mti_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mut igiyawa murap ipuni ganaganapam aug ikoki ag kuiyave tonasiya. Mu wape yobutaren me enwaniya. Wape gamateba me pundirit ge diyapam yapavewa. ");
INSERT INTO mti_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sira Iesu oya dog am ge am ag waya, “Kaiwa kaiwa, Ju igiyawa kin muma!” Sira mu nanuwo ginangave toya. ");
INSERT INTO mti_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pairat sira dauwag on Ju igiyawa gumbo wane, “Yauya, ne me aug yenan ongeni. Kuiyawa me gumbe kukaeba diuna da den yauna. Meoya ye me yaug anotan oya.” ");
INSERT INTO mti_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iesu gan kin keretawa mina kuiyave tonasiya sira wape yobutaren me gamat pundirit ge diyapam yapavewa me enwaniya dauwag uwanewa, Pairat mu gumbo wane, “Apan mame yauya!” ");
INSERT INTO mti_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pirisi koukawa ge temporu amareme igiyawa me yauya, sira tatevit mu kwaruwaya, “Korosi gumbe toya! Korosi gumbe toya!” Megara Pairat gara wane, “Ye me aug aisiya sira korosi gumbe toya. Ne yauna kukaeba da me gumbe onan.” ");
INSERT INTO mti_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ju igiyawa me gumbe gara waya, “Nu gwangwan numa gaibu, sira gwangwan me gumbe me di bo tope, kuiyawa me waivi me God Usiwa.” ");
INSERT INTO mti_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pairat mame anonewa, me a kokavit ane. ");
INSERT INTO mti_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Me gweyawa kokawa danave taig unig aine, sira me Iesu gumbe singui wane, “Ge ampa onagana?” Megara Iesu garawa den wane. ");
INSERT INTO mti_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pairat wane, “Ge ne gunap garawa watan topayana? Ge den yaug anoana ne yutunwa wakene watna ge yankwe gempe go watna ge korosi gumbe togempe?” ");
INSERT INTO mti_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iesu gara wane, “Ge yutugwa egonup den auwawa ipewa, ge yutugwa da den wakene ne gunap. Meoya apan bira ne auneg ge gungap onnewa me kukaeba kokavit ane.” ");
INSERT INTO mti_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Me apa utan ainewa, Pairat Iesu gumbe ag yaune me vetpa ingui dauwag aitan oya ane, megara Ju igiyawa ande au ge kwat veme, “Ge apan mame yankweya aipe ipewa, ge Siisa eveba onan. Da bira me kin wapewa, me Siisa gumbe daietaitai aivi.” ");
INSERT INTO mti_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairat gae mame anonewa, me Iesu aug dauwag onne, sira puiyuyu wakeiviwa arawa gerave yan wakene. At iviwa me an pepetu arawa. (Me gae Ibru gumbe waiviwa Gabasa.) ");
INSERT INTO mti_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Me Uwag Gaveya Buyunaeba oya tamibarip eme kumiwa, sira mumbe kum koniwa 6 mina. Pairat Ju igiyawa gumbo wane, “Yauya, mame ye kin yeuma.” ");
INSERT INTO mti_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Megara mu kwaruwaya, “Toya bo tope! Toya bo tope! Korosi gumbe toya.” Pairat mu gumbo wane, “Ne kin yeuma korosi gumbe totna?” Pirisi koukawa garawa waya, “Me nu kin numa onan, megara Siisa mekut me nu kin numa.” ");
INSERT INTO mti_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Oiebiren Pairat me Iesu korosi gumbe totan oya aug munne. ");
INSERT INTO mti_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mu Iesu aug amiya. Iesu me korosi meuma aug aivine, sira me dauwag at Kuiyamarednawa aine. (Gae Ibru gumbe waiviwa Gorugosa). ");
INSERT INTO mti_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mame apa mu Iesu korosi gumbe toya, sira me apa iyayapan duwam gaibu—da gambenwa apa sira da gambenwa apa,—Iesu me buwangave. ");
INSERT INTO mti_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pairat pui yutanwa tene, sira korosi egave baraune. Me mamaib tene: IESU NASARET APAN, JU IGIYAWA KIN MUMAWA. ");
INSERT INTO mti_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ju igiyawa obiren pui yutanwa mame basiyaya, kuiyawa at ampa Iesu korosi gumbe totanwa me at kokawa megiyave, sira gigirum me teyawa me gae Ibru, gae Raten ge gae Griik gumbe teya. ");
INSERT INTO mti_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Meve Ju pirisi koukawa muma Pairat gumbe waya, “‘Ju igiyawa kin muma’ meib den teya, megara ‘Apan mame me Ju igiyawa kin muma wane meib teya.’” ");
INSERT INTO mti_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pairat garawa wane, “Ne dividivi wait tenawa me di tena.” ");
INSERT INTO mti_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mut igiyawa Iesu korosi gumbe toyawa, mu wape meuma tamiya, sira mut igiyawa me wapeyawa tameg keb atan oya kuiyawa 4 teya. Wape ankwatavewa mina gaibu auya. Wape mame den ageniyawa, sira wape desirom ageniya kuiyawa apa aigne amawa uwane. ");
INSERT INTO mti_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Mu gae gara waya, “Me den warimita. Kae bumpai gumbe ag yauta bira me aupe.” Mame pawanewa me Baiboru anin waiviwa me natawa pawatan oya. Me tenewa, “Mu ne wape neuma mu mumbovit kepteya, sira kae bumpai aya ne wape ankwatavewa neuma oya.” Meoya mame me mut igiyawa aninin ayawa. ");
INSERT INTO mti_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iesu korosi meuma megiyave, inawa, me inawa yogiyawa, Kuropa biviwa Meri, sira Magdara vesin Meri mu yokeya. ");
INSERT INTO mti_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iesu inawa aigowawa me gumbe baigan anewa mu yokeeme yamne, me inawa gumbe wane, “Vesin, mame ge utugwa.” ");
INSERT INTO mti_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Meve aigowawa gumbe wane, “Mame ge inag.” Me kumiwa apa utanainewa, aigowawa mame me aug gwe meuma aine. ");
INSERT INTO mti_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mame ivi, Iesu yaug anone dividivi undag gare onanane, sira meve Baiboru wanewa natawa pawatan oya wane, “Ne meyanwa toyaivi.” ");
INSERT INTO mti_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Uinoum me apa barauya wakene. Danave wain sisipama wakene. Sira mu sponji gumbe wain sisipama em arob ben isop naniwa tueg aueg Iesu noive barauya. ");
INSERT INTO mti_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Iesu me wain sisipama nag wane, “Me onanane,” sira me kuiyawa kwanawa sig boane, sira me guwawa owan wanne. ");
INSERT INTO mti_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kum me apa, tamibarip eme kumiwa, sira wantepewa me Sabat Kumiwa. (Sabat Kumiwa mame me oiyat kokavitwa.) Ju igiyawa mu imuwo iragi kwapiwa Sabat Kumiwa korosi gumbe den wakepe, meoya mu Pairat gumbe dikape, airanuwa sikape iragi kwapuwa tam ampe. ");
INSERT INTO mti_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Meoya mut igiyawa onamiya sira apan namu Iesu gaibu korosi gumbe toyawa me airanuwa siya, sira upeba mina meib aya. ");
INSERT INTO mti_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Megara mu Iesu gumbe uwayawa, mu yaug anoya me wait boane, meoya me airaniwa den toensiya. ");
INSERT INTO mti_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Megara, mut igiyawa da Iesu megiyawa mut gumbe yunewa, tatevit diyawa ge yoi uwag aigne. ");
INSERT INTO mti_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Apan bira me yaunewa me taibe wane, sira me gaiyawa me natawa. Apan me yaug anone me gae natawa waivi. Me natawa di waivi, ye anotumat atan oya. ");
INSERT INTO mti_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dividivi mame pawanewa me gumbe Baiboru wanewa natawa pawatanwa oya: “Me marednawa da desirom den toensipe.” ");
INSERT INTO mti_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Sira Baiboru gaiyawa dawa me wane, “Mu matai yaupe apan bira mu mut gumbe yuyawa.” ");
INSERT INTO mti_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Me ivi, Arimataya apan Josep Iesu kwapiwa autan oya Pairat gumbe nun wane. Josep me Iesu aigowawa, megara guwave gumbe, kuiyawa Ju igiyawa gumbo a aivine. Pairat bainda wane, meve uwag kwapiwa aune. ");
INSERT INTO mti_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemas me namu Iesu oya arampuna amdau ainewa, me maaru ge aroe bidwag ayawa ibnawa 30 kg mina aug uwane. ");
INSERT INTO mti_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Apan duwam Iesu kwapiwa aug, gegura tayapama ge wape rinen gumbe paniya. Mame me Ju igiyawa inaiinai muma gumbe aya. ");
INSERT INTO mti_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","At me apa Iesu korosi gumbe toyawa apa me nau benawa da wakene, sira nau benawa me danave me dagup mataiwa wakene, sira me apa iragi da den di barauya. ");
INSERT INTO mti_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Mu me apa Iesu barauya, kuiyawa me Ju igiyawa Tamibarip Kumiwa sira dagup me megiyave. ");
INSERT INTO mti_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pura danave kum namuirenwa mumbevit apa, sisip ande wakeneve, Magdara vesin Meri dagup aine, sira an ankwin noive wakenewa watariyaya yaune. ");
INSERT INTO mti_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Meoya vesin me Saimon Pita ge aigowawa dawa me Iesu baigan gumbe anewa munan kintog on dirumne, “Mu Ayapan dagup gumbe aug amiya, sira nu den yaug anotu mu ampa me barauya.” ");
INSERT INTO mti_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Meoya Pita ge aigowawa dawa dagup oya amatog amome. ");
INSERT INTO mti_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Duwam mu kintoeme, aigowawa dawa me kintog namu aig dagup uwane, Pita mina onan. ");
INSERT INTO mti_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Me apa kwanasig yaunewa, wape rinen yaune, megara me danave den unig aine. ");
INSERT INTO mti_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Meve Saimon Pita me amave oniviwa uwane, sira dagup dana unig aine. Wape iviwa rinen wakene yaune. ");
INSERT INTO mti_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Me yaune, wape rinen me Iesu kuiyave paniyawa me wape dawa me Iesu kwapiwa paniyawa gaibu onan. Mu ube ube wakeya, sira Iesu kuiyawa paniyawa me meib di wakene. ");
INSERT INTO mti_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Meve aigowawa da me dagup namu uwanewa mina danave unig aine. Me yaug anotumat ane. ");
INSERT INTO mti_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu ande Baiboru gumbe den yaug anoya me Iesu bo igiyawa gumbo sira inaig yoitanwa oya wanewa. ");
INSERT INTO mti_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Meve aigowawa taig gweyowon amiya. ");
INSERT INTO mti_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Megara Meri dagup daieve ande yokeg it waivi. Me it waivinewa, me kwanasig dagup danawa yautan oya aivi. ");
INSERT INTO mti_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Sira aneya duwam mu wape pupuyuwa eneg Iesu kwapiwa barauya arawa apa yan wakeya me yawamne. Dawa me kuiyawa apa sira dawa me amawa apa wakeya. ");
INSERT INTO mti_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mu me gumbe waya, “Vesin, divi oya ge it vege?” Me wane, “Mu Ayapan neuma aug amiya, ne den yaug anona me ampa barauya.” ");
INSERT INTO mti_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Me kumiwa apa, me tobiyag yaune Iesu me apa yokene, megara me den yaug anone me Iesu. ");
INSERT INTO mti_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Me wane, “Vesin, divi oya ge it vege? Ge bira oya didimama ege?” Me anone me nau benawa amaraivi abnawa da, sira me wane, “Kokawa, ge me aug agawa ipewa, didnega ampa ge me barauwana, ne me autna.” ");
INSERT INTO mti_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iesu me gumbe wane, “Meri.” Me me gumbe tobiyag kwaruwane, “Rabonai!” (Natawa me toewanewan.) ");
INSERT INTO mti_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iesu wane, “Ne den yum nega, kuiyawa ne Maman oya ande den taig wan anedna. Megara, ne tatanaiwa munan aiseg dirumiya, ‘Ne Maman ge ye Mamewa, sira God neumawa ge God yeumawa me gumbe taig angeni.’” ");
INSERT INTO mti_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Magdara vesin Meri me aigowawa munan umum aug aine: “Ne Ayapan yauna!” Sira me mu dirumne me dividivi undag me gumbe wanewa. ");
INSERT INTO mti_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pura me kum namuirenwa augoi aram muniwaivi kumiwa oiyat desiroma apa, aigowawa agoniyag wakeya, sira ankwin toboriya kuiyawa Ju igiyawa gumbo a aya. Me kumive Iesu uwag mu yapowo yokeg wane, “Yum ye guniyap.” ");
INSERT INTO mti_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Me gae mame onananeve, naniwa ge megiyawa toyau munne. Aigowawa Ayapan yauyawa mu degadega kokavit aya. ");
INSERT INTO mti_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iesu sira wane, “Yum ye guniyap. Maman ne baraunedne onednawa mina, ye ne teeni dauwag aisiya.” ");
INSERT INTO mti_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sira me mame wanewa, me mu gumbo nonewa gaup upimun sira wane, “Guwawa Iyakaisiyapama auya. ");
INSERT INTO mti_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ye da bira kukaeba meuma anog yankweyawa ipewa, mu kukaeba muma Maman anog yankwepe; ye den anog yankweya ipewa, mu kukaeba muma Maman den anog yankwepe.” ");
INSERT INTO mti_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas (veme Didimas), aigowawa 12 danave da, Iesu uwanewa kumive aigowawa upeba gaibu onan. ");
INSERT INTO mti_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Meoya aigowawa upeba me gumbe waya, “Nu Ayapan yautune.” Megara mu gumbo wane, “Namu naniwa ikoko toyawa arawa oma ane yautna, sira naningriwa ikoko toya arawa oma ane entna, sira megiyawa mut yuyawa arawa naninwa oma ane entnawa, ne anotumat atna.” ");
INSERT INTO mti_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Oiyat 8 onanane, me aigowawa sira gwe danave yokeya, Tomas mu gaibu. Ankwin toboriya, megara Iesu uwag yapowo yokeg wane, “Yum ye guniyap.” ");
INSERT INTO mti_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Meve me Tomas gumbe wane, “Ge nanigriwa mapa baraug naninwa yawa. Nanigwa iveriya sira megiyanwa gumbe ena. Den pipangita, anotumat a.” ");
INSERT INTO mti_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas me gumbe wane, “Ayapan neuma sira God neuma!” ");
INSERT INTO mti_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iesu me dine, “Ge anotumat ana, kuiyawa ge ne yaunegana. Iyayapan mu ne den yaunegiya megara anotumat ayawa mu waribiya mumpe.” ");
INSERT INTO mti_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesu irakoniwa upeba obiren mu buka mame danave den tenewa aigowawa namuwo ane. ");
INSERT INTO mti_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Megara dividivi mame tenewa, ye Iesu me Keriso sira God Usiwa anotumat atan oya, anotumat gumbe ye inaiinai me iviwa gumbe autan oya. ");
INSERT INTO mti_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Dividivi mame ivi, Poeman Tiberias visive Iesu aigowawa gumbo sira taibe ane. Me meib pawane; ");
INSERT INTO mti_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita, Tomas (veme Didimas), Natanieru me Keina Gariri danave apa onnewa, Jebedi usitainawa, sira aigowawa da duwam mu agoniyaya. ");
INSERT INTO mti_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pita dirumne, “Ne gwambui tamtan oya botag angeni.” Sira mu waya, “Nu meib ge gaibu anta.” Meve mu dauwag amiya wa danave unigiya, megara aram me mu gwambui da den upiya. ");
INSERT INTO mti_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Mumbevit Iesu eg visive yokene, megara aigowawa den yaug anoya me Iesu. ");
INSERT INTO mti_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Me mu gumbo wane, “Owanaiwa, ye gwambui da den upiyana?” Mu gara waya, “Onan.” ");
INSERT INTO mti_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Me wane, “Uwariri yeuma wa yutanwa apa aoreya, ye matai gwambui upiya.” Mu meib ayawa, gwambui obiren upiya, meoya mu oma den ane uwariri ororiyape dauwape. ");
INSERT INTO mti_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Meve aigowawa me Iesu baigan gumbe aiviwa Pita gumbe wane, “Me Ayapan!” Saimon Pita me anone me Ayapan, me wapeyawa geravewa me gumbe panne (kuiyawa me kwapiwa taibe), sira pisiag poeman danave aigne. ");
INSERT INTO mti_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aigowawa upeba mu wa kusi gumbe uwariri me gwambui noidauwanewa ororiyaya, kuiyawa mu eg visiwa gumbe arama onan. Me 90 mitas mina. ");
INSERT INTO mti_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Mu eg visive dauwag aigiyawa, iyam omagawa igivi yauya, sira gwambui me iyam omagawa egave teyawa ge bredi upeba mu yauya. ");
INSERT INTO mti_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iesu mu gumbo wane, “Ye gwambui gare mame di upiyanawa me upeba tam oneya.” ");
INSERT INTO mti_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita wa gerave dauwag uwariri gwambui noidauwanewa ororiyak eg gerave tene. Me gwambui koukawa 153 noidauwane. Me di obiren, megara uwariri den viyodne. ");
INSERT INTO mti_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iesu me gumbo wane, “Oneya, mumbe nakwaeba naya.” Mu yaug anoya me Ayapan, meoya aigowawa da me singui atan oya da den di aib waya, “Ge bira?” ");
INSERT INTO mti_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iesu uwane, bredi aune sira mu gumbo munne, sira gwambui gaibu mina meib ane. ");
INSERT INTO mti_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Namu Iesu bo igiyawa gumbo yoine, ivi Iesu aigowawa gumbo taibe uwane, sira mame me kum duwamdesiyawa. ");
INSERT INTO mti_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mu nakwai naya onananewa, Iesu Saimon Pita gumbe wane, “Saimon, Jon usiwa, ge ne gunap natawa di baigan negege sira iyayapan mame upeba eme mina onan?” Me wane, “E, Ayapan. Ge yaug anoana ne ge gungap baigan eni.” Iesu wane, “Sip usiwa neuma amara.” ");
INSERT INTO mti_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iesu sira wane, “Saimon, Jon usiwa, ge natawa di ne gunap baigan ege?” Me gara wane, “E, Ayapan, ge yaug anoana ne ge gungap baigan eni.” Iesu wane, “Sip neuma amara.” ");
INSERT INTO mti_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kum duwamdesiyawa Iesu me gumbe wane, “Saimon, Jon usiwa, ‘Ge ne gunap baigan ege?’” Pita danadawai aune, kuiyawa Iesu kum duwamdesiyawa me gumbe singui wane; “Ge ne gunap baigan ege?” Me wane, “Ayapan, ge dividivi undag yaug anoana; ge yaug anoana me ne ge gungap baigan eni.” Iesu wane, “Sip neuma amara. ");
INSERT INTO mti_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne ge natawa dirugeni, ge wait apan mataiwa gumbe wakeyanawa, ge wape gembovit enana sira ampa agetan anoegewa agana; megara ge wanan tayawa awa, ge matai nanigwa siwavit dima, sira apan da wape geuma engempe sira namuyoiyoi agempe ampa ge den agetan anoegewa augem aipe.” ");
INSERT INTO mti_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iesu mame wanewa, me bo ginaanat me gumbe Pita eyawa God gumbe aug uwape esipewa, me toyau muntanwa oya. Meve me gumbe wane, “Amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita tobiyag yaune, aigowawa me gumbe Iesu baigan niyaiviwa mu amowo onivi. (Apan mame me aram nakwaeba apa Iesu gumbe intu udne, “Ayapan, bira omin geuma barautan oya aivi?” wanewa.) ");
INSERT INTO mti_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita me yaunewa me singui wane, “Ayapan, apan mame me aninin?” ");
INSERT INTO mti_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iesu gara wane, “Namu me yanga kani wakepe, ivi ne sira taig uwatanwa oya ne imunap ipewa, ge gungap me aninin? Ge ne amanap di onaga.” ");
INSERT INTO mti_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Meoya, gae me aigowawa mame den boatanwa tatawaiwa gumbo wateteyamiya. Megara Iesu meib den wane me den boape; megara aib wane, “Namu me yanga kani wakepe, ivi ne sira taig uwatanwa oya ne imunap ipewa, ge gungap me aninin?” ");
INSERT INTO mti_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Apan me dividivi mame gumbe taibe wane sira dividivi mame tenewa me aigowawa me. Nu yaug anotu me divi taibe wanewa me natawa. ");
INSERT INTO mti_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iesu dividivi obiren upeba gaibu ane. Ne aib anoeni, desirom desirom me anewa gaibu gigirum tepono ipawa, piyu mame apa oma den ane buka mame undag tepono. ");
INSERT INTO mti_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teopiras, buka neuma namuwa danave, Iesu me amatog nau anewa ge toewan munnewa undag tena. ");
INSERT INTO mti_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Iesu apasoro gomiyamun, Guwawa Iyakaisiyapama gumbe dirumne. Ivi God me aug kwimin dog aine. Amatonewa kumiwa ge me dog aine kumiwa bunangave gaiyawa undag tena. ");
INSERT INTO mti_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Me edawai aune, ivi kum 40 danave membo mu gumbo uwamunne. God toimuwawa oya wag dirumne. Sira natawa obiren gumbo me membo inainewa apasoro mu toyaumunne. ");
INSERT INTO mti_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iesu mu gaibu wakeyawa, me gwangwan mame dirumne, “Ye Jerusarem den kweya. Ye gunap Maman agi meuma anoyana. Me amaraya. ");
INSERT INTO mti_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Kuiyawa Jon me yoi gumbe babataito yenne, megara pipi mame danave ye Guwawa Iyakaisiyapama gumbe babataito aya.” ");
INSERT INTO mti_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mu desirom agoniyag aib singui waya, “Ayapan, ge kum mame gare agege Isuraeru toimu numawa sira siya?” ");
INSERT INTO mti_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iesu dirumwane. “Kum ge at koniwa yaug anotan den waya. Me Mamawa mekut yusiwa baraune me yaug anone. ");
INSERT INTO mti_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Megara Guwawa Iyakaisiyapama guniyap uwapewa yutuiwa auya. At Jerusarem, at Judia ge Samaria undag, sira at piyu gina pusiwa apa ye yangeyap yauyanawa nauwawa aya.” ");
INSERT INTO mti_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Iesu mame wane, meve mu yaveme dog aine, sira irikup me tobodne me den yauya. ");
INSERT INTO mti_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iesu dog aiviwa mu temtem kwimin yaveme. Yauya, apan duwam wape puipuyu eniyawa mu megiyowo wan yoiya. ");
INSERT INTO mti_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mu waya, “Gariri igiyawa, ye diwan mapa yokeg kwimin yavene? Iesu mame kweyeg kwimin dog ainewa, me sira uwape ye aninin yauyanawa mina di.” ");
INSERT INTO mti_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mu waya tui Orivu apa Jerusarem sira taig amiya. Tui mame Jerusarem megiave sira Sabat kumive oma ape ampe. ");
INSERT INTO mti_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Mu gwetoimu kokawa uwayawa, mu gwe dana painau pantut doreg amiya. Meapa mu wakeeme. Uwayawa mu Pita, Jon, Jemus ge Andru, Pirip ge Tomas, Batoromiu ge Matiu, Arupies usiwa Jemus ge Jerot abnawa Saimon, ge Jemus usiwa Judas. ");
INSERT INTO mti_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mu undag desirom agoniyag nun veme. Mu vesin da gaibu, Meri me Iesu inawa ge Iesu gwanebaviwa gaibu. ");
INSERT INTO mti_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kum me apa undag tatawaviwa 120 mina wakeya sira Pita mu danowo wan yoine. ");
INSERT INTO mti_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Me wane, “Tatangwanen, Judas me ebu iyayapan toewan munne mu Iesu yumiya. Guwawa Iyakaisiyapama Devid noive gumbe Judas oya matai matatpewa gaiyawa wane. Me gigirum tenewa me matadne. ");
INSERT INTO mti_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas nu gunup wakenewa me nau mame ane.” ");
INSERT INTO mti_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Me kukaeba meuma oya garawa aune, me gumbe piyu gwiruwadne. Sira me apa kuiyaven aigne, me kwapiwa dumedne danawa taibe ane. ");
INSERT INTO mti_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusarem danave mame iyayapan undag yaug anoya. Sira piyu mame gae muma gumbe mu waya, Akerudama me natawa Ganigani Piyuwawa.) ");
INSERT INTO mti_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sira Pita wane, “Buka Sam me gumbe tene, ‘At meuma dividivi den yaipe. Me apa bira da den wakepe. Sira apan da me arawa aupe.’ ");
INSERT INTO mti_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Me oya Ayapan Iesu nu gunup vin wakeivi kumiwa apa, ");
INSERT INTO mti_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","me Jon Babataito amatog onne God Iesu gunup aug dog ainewa. Me kumive nu gaibu nau atu danunup apan da desirom nu gaibu Iesu sira inai yoinewa yangave yaunewa ape.” ");
INSERT INTO mti_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Meve mu apan duwam wagomiyaya. Mu Josep, me Barusabas waya sira iviwa da Jastas, ge Matias. ");
INSERT INTO mti_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Meve mu nun waya, “Ayapan, ge iyayapan undag nonowa yaug anoana. ");
INSERT INTO mti_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ge wagomiyanawa duwam mame dana ambuwa apasoro nauwawa mame aug amarapewa toyau nuna. Judas kweg at meuma aine.” ");
INSERT INTO mti_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Meve mu kae bumpai mina ayawa, me Matias namive aigne, meoya me apasoro 11 gumbo agoniyane. ");
INSERT INTO mti_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentikost kumiwa uwanewa, mu undag at desirom agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pungi den wane mu noiwa anoya, taig yusipamit kwimin apa toivi mina. Me gwe undag mu wakeyawa noidauwane. ");
INSERT INTO mti_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iyam meru pednawa minawa ube ube onke mu desirom desirom egowo wakeya. ");
INSERT INTO mti_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Mu undag Guwawa Iyakaisiyapama gumbe demtawa auya. Sira mu amatog gae ube ube waya, kuiyawa Guwawa Iyakaisiyapama gae watan oya waita munne. ");
INSERT INTO mti_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gare, Jerusarem apa God gumbe aepam petat toeme Ju igiyawa wakeya. Mu kwimin ankwatave at undag apa onam wakeya. ");
INSERT INTO mti_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Noiwa mame pawanewa, iyayapan obiren agoniyag uwaya. Mu teraya, kuiyawa mu desirom desirom gae muma ubeube aigowawa veme anoya. ");
INSERT INTO mti_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Mu yaug anog teraya, sira mu waya, “Iyai mame gae vemewa undag Gariri igiyawa go? ");
INSERT INTO mti_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Mu desirom desirom gae numawa veme mu anoetewa, mame aninin? ");
INSERT INTO mti_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nu Parutia, Medes, Eramaiti igiyawa, sira Mesopotamia apa, Judia apa, Kapadosia apa, Pontas apa, Esia apa, ");
INSERT INTO mti_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigia apa, Pampiria apa, Ejipt ge Sairin megiyave Ribia apa vinetewa, sira Romu apa amdau onamiyawa, ");
INSERT INTO mti_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ju igiyawa ge iyayapan mu anotumat mumawa yankweg Ju anotumat mumawa gumbe anotumat ayawa gaibu wakeya. Sira Kurete ge Arab igiyawa mu gae numa gumbe God yusipamit aiviwa gaiyawa veme anoete. Mame aninin!” ");
INSERT INTO mti_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Mu yaug terag anopipanum eme, sira mu garawano aya, “Mame natawa divi?” ");
INSERT INTO mti_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Megara upeba mu gumbo iyagau ake waya, “Mu wain kokavit naya.” ");
INSERT INTO mti_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Meve Pita apasoro 11 gaibu wan yoik noiwa gae yabdapam iyayapan dirumne. “Ne iyayapan neuma Ju igiyawa ge Jerusarem apa wakeemewa undag, mame yaimoyai guniyap watna naunewa ne gunap. ");
INSERT INTO mti_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ye meib anovene. Megara iyayapan mame mu wain den naya, kuiyawa kum gare 9 mumbevit. ");
INSERT INTO mti_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mame propeta Joeru wanewa. ");
INSERT INTO mti_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Kum oieba God wape, ne Guwawa neuma iyayapan undag gumbo egampna. Ye usitainewa ge gwaiteaiwa God gaiyawa wape. Ud mataiwa irakoniwa uyavi minawa yaupe, sira iyai tayawa mu uyavi gumbe yaupe. ");
INSERT INTO mti_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Me kumive, nau neuma eme igiyawa, apan ge vesin gaibu, mu gumbo Guwawa neuma egampna, sira mu God gaiyawa wape. ");
INSERT INTO mti_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ne opa kwimin danave anopipanumowa toyau muntna, sira epa piyu egave irakoniwa toyau muntna. Mu ganigani ge iyam ge aup dog aipewa. ");
INSERT INTO mti_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kum me tobiyape sisip uwape, sira dud me tobiyape ganigani ape, meve Ayapan eyawa kokawa kumiwa uwape. ");
INSERT INTO mti_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Megara me apa undag me Ayapan iviwa gumbe auwapewa matai waita waita aupe. ");
INSERT INTO mti_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Isuraeru igiyawa ye mame anoya. God me Nasaret apan Iesu wagomiyane ye guniyap irayauyau, anopipanumowa ge at irakoniwa ane. God apan mame yenan taibe ane. Ye yembovit mame yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God yumateba ge ano meuma me matai dimbae matatpewa yaug anopewa gumbe apan mame God barau yenne. Sira ye apan mame kukaeba igiyawa nanuwo gumbo barauyana korosi egave toya boane. ");
INSERT INTO mti_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","God me bo dawaeba gumbe warinamne sira inaig yoine. Kuiyawa me gumbe mina den ane, me bo aug yumnatpe. ");
INSERT INTO mti_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devid me oya wane: ‘Evedni ne Ayapan namunap yaveni. Me ne nanin yutanwa apa wakene, meoya ne ipunapun den atna. ");
INSERT INTO mti_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Meoya ne nonenwa me degadega ane, sira ne pednanwa degadega noiwa uwane. Ne kwapunwa gaibu owanowan gumbe wakepe. ");
INSERT INTO mti_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kuiyawa ge ne guwanwa ades danave den wakepe. Apan iyakaisi geuma den kweya putaipe. ");
INSERT INTO mti_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Inaiinai ebuwawa toyau negana, sira ge namugap degadega neuma noidauwape.’ ");
INSERT INTO mti_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tatangwanen, ne natawa di diruitna. Isimuranewa Devid boane siya, me yampotawa gare mapa gunup. ");
INSERT INTO mti_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Me propeta, meoya me anone wagoba da matai kin arawa aupe God agi gumbe wane. ");
INSERT INTO mti_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Me yavivi ivi anin ape, Iesu sira inainewa gaiyawa wane, ‘Me ades danave evedni den kwepe kwapiwa den puwaipe.’ ");
INSERT INTO mti_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","God me Iesu mame sira inaine, sira nu undag me yangunup yautu. ");
INSERT INTO mti_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sira God Iesu aug nanin yutanwa apa baraune. Iesu Mamawa gumbe Guwawa Iyakaisiyapama aune me Mamawa me gumbe wait agi wanewa. Iesu Guwawa Iyakaisiyapama egamne gare ye mame yavene sira anoenewa. ");
INSERT INTO mti_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devid kwimin den dog aine. Me wane, ‘Ayapan me Ayapan neuma wane. Nanin yutanwa apa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ivi ne anavi geuma ne atna amag ankwatave barautna.’ ");
INSERT INTO mti_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Meoya, Isuraeru igiyawa undag, mame yai yaug anotanit di. God me Iesu mame Ayapan ge Keriso anewa, ye korosi gumbe toyana.” ");
INSERT INTO mti_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Meve iyayapan mame anoyawa, mu nonomagowa mut mina yuwamiya, mu Pita ge apasoro upeba gumbo waya, “Tatangwanen, nu anin aton?” ");
INSERT INTO mti_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita gara wane, “Ye undag desirom desirom nonemagewa biroriyape kukaeba yeuma yankweya, sira Iesu Keriso iviwa gumbe babataito auya, me kukaeba yeuma anog yankwepe. Sira puyo meuma me Guwawa Iyakaisiyapama auya. ");
INSERT INTO mti_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Agi mame yenan ge ye usitainewa ge iyayapan undag painau wakeyawa oya munne. Natawa me iyayapan undag Ayapan God numawa wagomiya munnewa mu munan munne.” ");
INSERT INTO mti_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita gae upeba gaibu taibe dirumwane, “Kukaeba kum garewa apa yaimoyai ayun wariya.” ");
INSERT INTO mti_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Iyayapan gae meumawa auyawa mu babataito auya. Me kumive iyayapan 3,000 mina agoniyag aigowawa aya. ");
INSERT INTO mti_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mu apasoro toewanewan mumawa yaimoyai yumateme, baigan amuneme, bredi warensieme sira nun veme. ");
INSERT INTO mti_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iyayapan undag teraya. Apasoro anopipanumawa ge irakoniwa obiren aya. ");
INSERT INTO mti_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Anotumat igiyawa agoniyake dividivi undag divi da den wane me nekut neuma. ");
INSERT INTO mti_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tawara ge dividivi kusiwa mumawa gwiruwareme anmagawa auke, bira da mu anoemewa keb ag muneme. ");
INSERT INTO mti_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kum evedni mu temporu arawa danave danowa desirom toboreme. Mu gweyowa danave bredi warensiya sira toborake nakwai naya degadega ge danowa oraivit gumbe. ");
INSERT INTO mti_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mu God waragateme sira iyayapan undag mu gumbo baigan amuneme. Sira Ayapan kum evedni waita waita auyawa mu desirom toboraya. ");
INSERT INTO mti_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kum da apa nun watan kumiwa me augoi kum koniwa 3 mina Pita ge Jon temporu dog amiya. ");
INSERT INTO mti_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Gare apan da amawa gegerainewa meib di yainewa me evedni yotug am temporu ankwin noiwa me iviwa “Kakare Oraivitwa” apa barauya. Apan mame temporu arawa unigemewa gumbo nun waivi. ");
INSERT INTO mti_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Meve me Pita ge Jon unig ataneme yawamne. Mu gumbo divi da oya nun wane. ");
INSERT INTO mti_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita yangut temtemtem yaune, Jon sira meib. Pita wane, “Nu yaununa.” ");
INSERT INTO mti_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sira me mu gumbo owanowan ane divi da aupe. Apan me mu gumbo yangut yawamne. ");
INSERT INTO mti_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sira Pita wane, “Siruva ge gooru ne gunap onan. Go, dimbae da ne gunap ne ge gentna. Nasaret apan Iesu Keriso iviwa gumbe aga.” ");
INSERT INTO mti_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nani yutanwa gumbe me wan aune. Sira tatevit apan me amawa ge koniwa yusi wane. ");
INSERT INTO mti_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Me amave owan em yoik sira amatog a aine. Sira me a aivi, pisiapisia aivi ge God gumbe waiyaivi mu gaibu temporu arawa dana unig amiya. ");
INSERT INTO mti_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Iyayapan undag me a aivi sira God gumbe waiyaiviwa yauya. ");
INSERT INTO mti_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mu yaug anoya me apan desiroma temporu arawa ankwin noiwa “Kakare Oraivitwa” waya apa yan wakek nun waivi. Mu me gumbe divi matadnewa mu yawak teraya. ");
INSERT INTO mti_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Me Pita ge Jon gumbo kwab nadnewa, iyayapan undag terake kinikinipam onam gumbo at iviwa waya Soromon ebuwawa gwanob gaibuwa uwaya. ");
INSERT INTO mti_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita mame yaune, me mu gumbo wane, “Isuraeru igiyawa, dimbae oya mame ye terayana? Dimbae oya ye yangut yau nunene, ye anoene nu nukut yutunwa go anotumat numawa gumbe apan mame warinamtu? ");
INSERT INTO mti_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ebraam, Aisak ge Jekob God mumawa, sira isimuranaiwa God mumawa, me eyawa meuma nau meuma abnawa Iesu wanne. Ye me toen guttan oya nanuwo barauyana. Pairat me yan kwepe aipe wane, go ye Pairat namive me topayayana. ");
INSERT INTO mti_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ye Iyakaisi ge Oraiwa abnawa topayayana, sira wayana iyayapan gurivi abnawa yan kwepe aipe. ");
INSERT INTO mti_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ye inaiinai kuiyabariwa toen guriyana. Megara God me Iesu bo igiyawa gumbo warinamne. Nu yangunup me yautu. ");
INSERT INTO mti_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iesu iviwa gumbe, sira anotumat meuma gumbe, apan mame me ye gare yaug anoenewa yusiwa aune. Anotumat me Iesu gumbe onnewa, ye undag namuyap apan mame ui kwapiwa undagit inaine. ");
INSERT INTO mti_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tatangwanen, ne anona. Namu yoiyoi yeumawa ayawa mina ye ayana. Kuiyawa ye den yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Megara God namu wane Keriso edawai aupe, propeta undag mu nouwo waya. Gare God me ane matadne. ");
INSERT INTO mti_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nonemagewa biroriyaya, meve God oya tobiyaya. Meapa God kukaeba yeuma undag muimpe. ");
INSERT INTO mti_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Waribiyatan kumiwa Ayapan gumbe uwape. God Keriso baraupe ompe. God yenan wagomiyanewa me Iesu. ");
INSERT INTO mti_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Iesu kwiminau wakene, sira God dividivi undag mataiven biroriyatanwa kumiwa uwape, meve Iesu uwape. Me kumiwa oya, propeta iyakaisiyapama nouwo God watavit kum obiren agi wane. ");
INSERT INTO mti_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mosisi wane, ‘Ayapan God yeuma yenan propeta ne mina wan yoipe ye dam desiroma yapeyap. Ye naunewa taig dividivi undag ye guniyap waiviwa anoya. ");
INSERT INTO mti_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Bira da propeta me gumbe naunawa den taig anopewa, me iyayapan meuma gumbo atan kwagomiyape onanape.’ ");
INSERT INTO mti_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sira, propeta Samueru gumbe amatog onne propeta upeba onamiya. Mu undag, kum garewa gaiyawa waya. ");
INSERT INTO mti_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ye propeta usitainawa. Ye agisiyawa usitainawa. God isimuranaiwa gumbo agisiyawa wadne. God Ebraam gumbe wane, ‘Ge wagogaiwa gumbo iyayapan undag piyu egave waribiyape.’ ");
INSERT INTO mti_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Namu God nauwawa aiviwa wan yoine yenan baraune onne. Kuiyawa me waribiya yempe sira ye desirom desirom kukaeba yeuma gumbe tobiroriya yempe.” ");
INSERT INTO mti_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ge Jon iyayapan dirumemewa, pirisi igiyawa ge temporu amat namu yoiyoi abnawa ge Sadusi igiyawa mu gumbo uwaya. ");
INSERT INTO mti_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mu anopipanum kokavit aya, kuiyawa Pita ge Jon iyayapan toewanewan eme sira Iesu bo tog sira inaine me ebu meib, mu bo gumbe inai mutpewa igiyawa gaiyawa dirumeme. ");
INSERT INTO mti_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Mu Pita ge Jon yumamiya. Augoi arivi oya, mu nog dana teya waya umae mumbe kwempe dauwag ampe. ");
INSERT INTO mti_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Megara iyayapan obiren gae anoyawa mu anotumat aya. Apan 5,000 mina anotumat aya. ");
INSERT INTO mti_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Umaewa namuyoiyoi igiyawa, iyayapan amareme igiyawa ge Gwangwan toewanewan mu Jerusarem apa toboraya. ");
INSERT INTO mti_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Pirisi painauvitwa Annas, Kayapas, Jon, Arekisanda sira iyayapan upeba pirisi painauvitwa dam meumawa gaibu mu me apa. ");
INSERT INTO mti_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mu waya Pita ge Jon mu namuwo tam onampe. Mu amatog singui muneme, “Dimbae ano yusiwa gumbe go dimbae iviwa gumbe ye mame ayana?” ");
INSERT INTO mti_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Meapa Pita Guwawa Iyakaisiyapama gumbe noidauwane, mu gumbo wane, “Namuyoiyoi igiyawa ge iyayapan amareme igiyawa! ");
INSERT INTO mti_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ye gare singui nuntan oya tamnun oniyana. Kuiyawa me nu yuwat abnawa gumbe oraimina atu sira me dimbae gumbe inaine oya yavene ipewa, ");
INSERT INTO mti_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ye ge Isuraeru igiyawa undag, mame anoya. Apan mame yuwat meuma undagit onanane ye namuyap yoiviwa, me Nasaret apan Iesu Keriso iviwa gumbe. Ye Iesu korosi egave toyana megara God me bo gumbe inaig yoine. ");
INSERT INTO mti_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Apan mame me, ‘An me gwe sisi igiyawa topayayawa, me an natawa oraivitwa me visidonawa apa teyawa ane. Mame Ayapan ane.’ ");
INSERT INTO mti_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Bira da waita oma ape den numpe. Apan mame mekut waita numpe. Kwimin ankwatave God iyayapan yapowo iviwa da den wanne. Iviwa mame mekut gumbe nu waita oma ape auta.” ");
INSERT INTO mti_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mu yauya Pita ge Jon ano yusiwa auya a den aya, sira mu anog teraya apan duwam mu gigirum den teya iyayapanirenwa. Mu yaug anoya Pita ge Jon mu Iesu gaibu wakeya. ");
INSERT INTO mti_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mu yauya apan inainewa asime mu gaibu yokene, meoya mu gae divi da oma den ane waya. ");
INSERT INTO mti_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mu dirumiya Daiboru Painauvitwa gumbe atan dauwag aisiya, sira mu toborak gae yuya. ");
INSERT INTO mti_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Mu waya, “Nu gare apan mame gumbo dimbae aton? Iyayapan undag Jerusarem apa wakeemewa yaug anoya mu irakoniwa koka oraivit aya, meoya nu oma den ane uyai wata. ");
INSERT INTO mti_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Megara mame iyayapan yapowo gerave wateteyamiviwa tobottan oya, iviwa mame gumbe sira bira da den dipe gae yaigipam dirumta.” ");
INSERT INTO mti_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Meve mu sira munan uniktan oya auwaya unigiyawa mu gumbo gae yusipam dirumiya: Iesu iviwa gumbe gae ge toewanewan den di aya. ");
INSERT INTO mti_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita ge Jon gara waya, “Ye yembovit anoya ambuwa oraimina, God namive God noiwa auta go ye noiwa auta. ");
INSERT INTO mti_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nu oma den ane nu yautuwa ge anotuwa gaiyawa vetewa yankweta.” ");
INSERT INTO mti_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mu a ag kwemiya amiya. Mu oma den ane anoya mu aninin akape garawa ibnawa mumpe. Kuiyawa iyayapan undag God waieme matadnewa gumbe. ");
INSERT INTO mti_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Apan irayauyau mame gumbe inainewa bairawan meuma 40 mina. ");
INSERT INTO mti_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita ge Jon mu kwemiyawa taig amog iyayapan muma gumbo uwaya. Sira mu gumbo waya pirisi kokawa ge namuyoiyoi igiyawa mu wayawa undag dirumiya. ");
INSERT INTO mti_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Iyayapan muma mame anoyawa, mu imudanowa undag desirom God gumbe nouwa enagasiya, sira mu waya, “Ayapan, ge kwimin ge piyu ge poeman sira dividivi undag mu danowo wakeyawa me ge watteyana. ");
INSERT INTO mti_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nau geuma aivi abnawa isimuranaiwa Devid noiwa gumbe, sira Guwawa Iyakaisiyapama gumbe ge wana, ‘Dimbae oya Ju onan igiyawa au ge kwaruveme, sira piyu igiyawa mu divi da natawa onanwa oya anoeme? ");
INSERT INTO mti_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Piyu ayapanowa mu namu yoiya, sira namuyoiyoi igiyawa agoniyag toborag mu Ayapan ge Keriso noiwa den auya.’ ");
INSERT INTO mti_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Natawa di, Erod ge Pontio Pairat mu Ju onan igiyawa ge Isuraeru igiyawa gaibu gwetoimu koka mame danave agoniyaya. Mu nau geuma aiviwa abnawa iyakaisi, ge oira kuiyave egamanawa abnawa, Iesu gumbe topayag anokukam aya. ");
INSERT INTO mti_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nanigwa ge imugwa gumbe namiven ge anog anawa mu aya. ");
INSERT INTO mti_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ayapan. Gare ge yawa mu a amuniya. Kwema nau geuma emewa igiyawa mu gae geuma yusipamit dirumpe. ");
INSERT INTO mti_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Warinamtan oya nanigwa dima iyayapan warinamumpe. Sira iyakaisi nau geuma aivi abnawa Iesu iviwa gumbe irakoniwa ge anopipanumawa ape.” ");
INSERT INTO mti_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mu meib nun wayawa at me agoniemewa ipunapun ane. Undak mu Guwawa Iyakaisiyapama demtawa auweg God gaiyawa yusipamit amatog waya. ");
INSERT INTO mti_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Anotumat igiyawa undag mu nonowa ge anoano desirom ane. Bira da dividivi meuma den wane me nekut neuma, sira mu dividivi mumawa keb aya. ");
INSERT INTO mti_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apasoro yutuwa kokavitwa gumbe Ayapan Iesu sira inaig yoinewa yauyawa waya, sira ano oraiwa kokawa mu undag gumbo. ");
INSERT INTO mti_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tawara onanwa abnawa da mu gumbo den wakene. Iyayapan piyu mumawa go gwe mumawa gwiruwariya anmagawa tam uwag, ");
INSERT INTO mti_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Apasoro amowo teya. Mu keb ag iyayapan anoemewa meib muniya. ");
INSERT INTO mti_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Josep me Rivai apan, me at Saipras apa yaine. Apasoro me waya Banabas. Me natawa watmemeyamivi usiwa. ");
INSERT INTO mti_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Me piyu meuma gwiruwadne, sira anmagawa aug uwag apasoro amowo baraune. ");
INSERT INTO mti_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gare, apan iviwa Ananias, me biviwa Sappira gaibu toboraya, mu tawara muma gwiruwariya. ");
INSERT INTO mti_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Biviwa gaibu ano muma desirom, Ananias garawa upeba me membo oya yumnadne, upeba bog onke apasoro amowo tene. ");
INSERT INTO mti_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Megara Pita wane, “Ananias, dimbae oya Seitan me danagwa aune, Guwawa Iyakaisiyapama gumbe uga wana, sira piyu garawa upeba gembo oya yumnatana? ");
INSERT INTO mti_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Me undag geumawa di. Gwiruwarana, go me ande amat geuma gumbe. Divi oya ugauga anoege? Ge iyayapan gumbo uga den wana, go God gumbe uga wana.” ");
INSERT INTO mti_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Meve Ananias gae mame anonewa, me uyug aig botone. Sira iyayapan mame anoyawa, a kokavit mu undagit gumbo uwane. ");
INSERT INTO mti_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Apan tamaru mu owan yoig kwapiwa panke yotug aug amog sig umiya. ");
INSERT INTO mti_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ivi kum koniwa 3 mina onanane meve biviwa uwane. Me den yaug anone divi matadne. ");
INSERT INTO mti_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita vesin dig wane, “Didnega. Mame me ye piyu garawa auyanawa?” Me wane, “E. Garawa meme.” ");
INSERT INTO mti_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita me dine, “Ge memag gaibu bainda wayana, Ayapan Guwawa meuma gumbe ageyau ayana? Yawa. Memag sig umiyawa mu ankwin noive unig omome, sira mu ge gaibu yotugem ampe.” ");
INSERT INTO mti_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Koni kusi me apa me Pita amave uyug aig botone. Sira apan tamaru mu unig onam yauya me botone. Sira yotug aug amiya memawa megiyave me sig umiya. ");
INSERT INTO mti_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Siosi undag ge undag mame anoyawa gumbo a kokavit uwane. ");
INSERT INTO mti_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apasoro nanuwo gumbe irakoniwa ge anopipanum obiren iyayapan yapowo matat muteme. Sira mu undag danowa desirom gumbe toborag Soromon ebuwawa gwanob gaibu apa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Iyayapan upeba bira da mu gaibu den toboraya, go iyayapan painauwa mu ebnotu a muneme. ");
INSERT INTO mti_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sira apan ge vesin obiren Ayapan gumbe anotumat aya. Iyayapan agoniemewa kokavit aivi. ");
INSERT INTO mti_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Meoya iyayapan yuwat igiyawa yotug epin taibe apa uwaya, sira kem ge goma gerowo te muniya, Pita uwag aiviwa Pita gugup da gerowo umpe oya anoeme. ");
INSERT INTO mti_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Iyayapan obiren Jerusarem birorot gwetoimu apa onamiya. Mu yuwat igiyawa ge airapu miyotapama mu gumbo wakenewa yotug onam agoniyaya mu undag inaimusia. ");
INSERT INTO mti_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pirisi painauvitwa ge me owawaiwa undag mu Sadusi igiyawa mumawa, anokukam gumbo noidauwane. ");
INSERT INTO mti_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Mu apasoro yumamiya, sira mu nog taibewa danave temuniya. ");
INSERT INTO mti_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Megara arampuna Ayapan aneya meuma nog ankwinawa watab tam dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Me wane, “Aisiya. Temporu dana yoiya iyayapan gumbo inaiinai mame gaiyawa undag dirumiya.” ");
INSERT INTO mti_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Mu anoyawa, wantete mu temporu arawa dana unigiya amatog toyau muniya. Sira pirisi painauvitwa ge owawaiwa uwag Daiboru Painauvitwa ge iyai Isuraeru mu koukawa undag munan auwaya. Mu apasoro tam onamtan oya iyayapn teya nog amiya. ");
INSERT INTO mti_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Megara nau eme igiyawa nog gumbe uwayawa mu nog danave mu den yawamiya. Mu sira taig amog umum waya. ");
INSERT INTO mti_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nu yautu nog ankwin undag toboriya. Sira ankwin amaremewa yokeya, me watapiyawa bira da epa danave den yautu. ");
INSERT INTO mti_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Temporu amaremewa kokawa muma ge pirisi koukawa gae mame anoyawa apasoro gumbo anopipanum aya aninin mame aivi. ");
INSERT INTO mti_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Apan da onke wane, “Yauya. Apan ye nog dana temuniyawa temporu arawa danave yokeg iyayapan toyau muneme.” ");
INSERT INTO mti_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Meve temporu amaremewa kokawa muma me nau eme igiyawa gaibu amiya apasoro tam onamiya. Megara mu gwambe mu gumbo den aya. kuiyawa mu iyayapan gumbo a aya matai an gumbe gutpetan. ");
INSERT INTO mti_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mu apasoro tam onam Daiboru Painauvitwa danave yokeya. Pirisi painauwa singui munne. ");
INSERT INTO mti_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Me wane, “Nu gae yaigipamit diruitu iviwa mame gumbe toyau toyau den aya. At Jerusarem danave toyau toyau yeuma noidauwane. Sira apan mame ganiganiyawa ibnawa gunup barauene.” ");
INSERT INTO mti_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita ge apasoro upeba gara waya, “Nu God noiwa auta, iyayapan nouwa den auta. ");
INSERT INTO mti_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ye korosi egave Iesu baraug toyana. Isimuranaiwa God mumawa me bo gumbe warinamne. ");
INSERT INTO mti_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God Iesu mame me naniyutanwa apa enagadne. Me Kin Usiwa ge Waita Abnawa. Kuiyawa God me nonemagowa biroriyatanwa ge kukaeba muma anog yankwetanwa Isuraeru munigimpe. ");
INSERT INTO mti_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nu dividivi mame yangunup yautunewa. Sira Guwawa Iyakaisiyapama me God noiwa aueme igiyawa mu munnewa me gaibu yangave yaunewa.” ");
INSERT INTO mti_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mu mame anoya, meve mu danowa piripiri wane sira mu imuwo apasoro gurampe boriruwape. ");
INSERT INTO mti_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Megara, Parisi abnawa da wakene. Iviwa Gamarieru, me Gwangwan toewanewan abnawa. Me iyayapan undag ebnotu awaniya. Me Daiboru Painauvitwa danave wan yoik gae meuma yaigipam dirumne, apasoro mame koni pipi mu daieve temuniya dauwag ampe. ");
INSERT INTO mti_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Me dirumne, “Isuraeru igiyawa, ye yaimoyai yaug anoya aninin apan mame gumbo kwayub amuniya. ");
INSERT INTO mti_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kum da apa Teudas wan yoig membovit apan kokawa mina wane. Apan 400 mina me amave amiya. Megara me toen guriya sira me amave amomewa undag a mina mina amboriya. Onan di ane. ");
INSERT INTO mti_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Mame onananewa Gariri apan Judas wan yoig iyayapan ivuwa basiemewa kumiwa danave iyayapan ugai munne kokawa gumbo daietaitai aya. Megara me gaibu toen guriya sira me amave amomewa undag a minamina amboriya. Onan di ane. ");
INSERT INTO mti_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Meoya ne gare diruieni. Iyayapan mame yan kwemiya ampe. Kuiyawa dividivi mame apan gumbe ompe ipewa, me matai onanape. ");
INSERT INTO mti_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Megara me God gumbe ompe ipewa, ye guniyap oma den ane apan mame toboriya. Anten ye yembovit God gumbe matai mut aya go?” ");
INSERT INTO mti_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Mu gae meuma auya. Mu apasoro munan auwaya murap gumbe guriya. Mu gwangwan dirumiya Iesu iviwa gumbe den waigimiya meve kwemiya dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Apasoro Daiboru Painauvitwa kweg degadega gumbe amiya. Kuiyawa mu yaug anoya mu mumbo oma ane iviwa oya dawai ge iyagau aueme. ");
INSERT INTO mti_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kum evedni mu temporu arawa ge gwe gwe danave Iesu me Keriso toyau muneme wag omome. Sira den kwene. ");
INSERT INTO mti_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kum me danave aigo meuma tobod mumawa koka aivi. Gae Griik veme Ju igiyawa, mu gae Ibru veme Ju igiyawa gumbo yano veme. Kuiyawa mu kwapura yaimoyai amat den amneme evedni nakwai keb gumbe. ");
INSERT INTO mti_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Meve apasoro 12 mu aigo muma undag agoniyag toborag waya, “God gae meuma yankwek nakwai amarata me nugnup oraimina onan. ");
INSERT INTO mti_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tatangwanen. Apan 7 wagomiya muniya, iyayapan veme oraimumuwa. Sira mu danowa Guwawa Iyakaisiyapama gumbe noidauwane, sira mu ano kokawa gaibu. Nu nau mame mu munta. ");
INSERT INTO mti_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nu imunwa undag nun gumbe ge God gae meuma wag dirumtan yumnatta aigimpe.” ");
INSERT INTO mti_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Mu gae waya iyayapan undag ung waya. Mu Stepen wagomiyaya, me anotumat ge Guwawa Iyakaisiyapama gumbe noidauwane. Sira mu Pirip, Prokoras, Nikanoru, Timon, Parumenas ge Nikoras gomiya muniya. Antiok abnawa Nikoras me Ju anotumat muma gumbe biroriyanewa. ");
INSERT INTO mti_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mu iyayapan mame temiya apasoro namuwo yoiya. Mu nun waya sira nanuwa egowo teya. ");
INSERT INTO mti_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","God gae meuma wateteyamne. Jerusarem apa aigo meumawa tobod muma tatevit koka aivi. Sira pirisi obiren anotumat gumbe noiwa auya. ");
INSERT INTO mti_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gare Stepen iyayapan yapowo anopipanumawa oraiwa ge irakoniwa ane matadne. Me God ano meuma oraiwa ge yusiwa gumbe noidauwane. ");
INSERT INTO mti_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mu waya intum aya igiyawa Sinagogu mumawa apa onamiyawa wakeya. Mu Sairin igiyawa ge Arekisandria igiyawa sira Sirisia ge Esia apa onamiyawa. Mu wan yoig amatog Stepen gaibu garadi aya. ");
INSERT INTO mti_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Go, me ano kokawa ge Guwawa gumbe gae waivi, meoya mu oma den ane me gumbe garawa waya. ");
INSERT INTO mti_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mu uga muma gumbe iyayapan upeba ugai mun waya, “Nu Stepen me Mosisi gumbe ge God gumbe gae kukaeba da waivi anotu.” ");
INSERT INTO mti_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sira mu iyayapan ge iyayapan amareme igiyawa ge Gwangwan toewanewan igiyawa nib danowa auya. Mu Stepen yumiya Daiboru Painauvitwa namive aug amiya. ");
INSERT INTO mti_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sira mu iyayapan yangowa den yauyawa wan yoik uga gaiyawa wape, “Ud mame at iyakaisi ge Gwangwan gumbe gae wabatam waiviwa den kwene. ");
INSERT INTO mti_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Apan mame me, ‘Nasaret apan Iesu me at mame wakukampe, sira inaiinai me Mosisi gumbe on nu gunup uwanewa me biroriyape.’ me meib waiviwa nu anotu.” ");
INSERT INTO mti_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iyayapan undag mu Daiboru Painauvitwa danave wakeyawa yangut temtemtem Stepen yaveme. Sira mu yauyawa me ginangawa me aneya ginangawa mina. ");
INSERT INTO mti_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pirisi painauvitwa me singui ane, “Me natawa di?” ");
INSERT INTO mti_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stepen gara wane, “Tatangwanen ge mamanaiwa. Ye ne gunap naunewa taiya. Nu mamunwa Ebraam ande at Mesopotamiya wakenewa God eyawa me gumbe uwane. Meve me aig at Aran apa vinivi. ");
INSERT INTO mti_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God wane, ‘Ge iyayapan geuma ge at geuma kweya, sira aga piyu ne toyau gentna.’ ");
INSERT INTO mti_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Me Sarudia igiyawa arowa kweg at Aran apa wakeivi. Ivi me mamawa boane, meve God me baraune at mame onne gare ye wakeene. ");
INSERT INTO mti_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God mamawa kwanawa da mawapa den wanne. Me amawa emnewa arawa piyu musiwa da den wanne. Megara God me gumbe agi wane. Me apa Ebraam ud onan, go God me ge me wagobaiwa gumbo agi wane piyu mame mamawa kwanawa oya ivi mumpe. ");
INSERT INTO mti_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God me gumbe meib wane, ‘Ge wagogaiwa matai at da ube am me apa wakeigimpe. Sira bairawan 400 danave mu ankwatave nau eme igiyawa ape, sira mu gumbo gwambe ape.’ ");
INSERT INTO mti_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Sira God wane, ‘At da ube igiyawa mu tam ankwatave nau eme igiyawa ape ipewa, ne matai mu kepte muntna. Ivi meve mu at me apa dauwag onampe mame apa waiya nekpe.’ ");
INSERT INTO mti_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Sira God kwapituitui agi meuma Ebraam wanne. Epin meib Ebraam Aisak mamaven ane sira Aisak yoine oiyat 8 onanane Aisak kwapiwa tuine. Ivi Aisak me Jekob mamaven ane. Jekob me dam 12 namuyoiyoi igiyawa mu mamowon ane. ");
INSERT INTO mti_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Dam namuyoiyoi igiyawa mu Josep gumbe danowa piriwane, meoya mu me Ejipt danave gwiruwariya, ankwatave nau aivi abnawa ane. Go, God me gaibu. ");
INSERT INTO mti_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Sira dividivi undag ibnawa gumbe God me waita wanne. Me Ejipt kin Parao namive imive ge ano painauwa me wanne. Parao me Josep wagomiyane namuyoiyoi abnawa ane at Ejipt undag ge kin gweyawa undag amaratan oya. ");
INSERT INTO mti_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Meve at Ejipt ge Keinan undag kait tene kumiwa uwane. Ibnawa kokavit aueme, meoya mamanaiwa mu oma den ane nakwai boya. ");
INSERT INTO mti_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekob Ejipt apa nakwai grein wakene anonewa, me mamanaiwa namu te munne amiya. ");
INSERT INTO mti_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Mu amdau duwameba amiyawa, Josep me tatawaiwa dirumne ne bira. Sira Parao me Josep dam meuma yaug anone. ");
INSERT INTO mti_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ivi meve, Josep gae baraune aine, sira me oya mamawa Jekob ge me dam meuma 75 munan wane undag onamiya. ");
INSERT INTO mti_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Meve Jekob Ejipt aig aine, sira asimeve Jekob ge mamanaiwa mu boriruwaya. ");
INSERT INTO mti_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mu kwapuwa sira tam at Sekem taigiya, sira babat dana te muniya. Babat piyu me Ebraam Amor usitainawa gumbo anmaga upeba gumbe gwiruwadne. ");
INSERT INTO mti_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","God Ebraam agi wanewa me kumiwa manman aiviwa, iyayapan numa tobot muma Ejipt danave namuyoiyoi abnawa aivi. ");
INSERT INTO mti_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ivi kin da me Josep gumbe den anonewa Ejipt danave kin ane. ");
INSERT INTO mti_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kin mame iyayapan numa gumbo ano gwambe ag ibnawa munne, isimuranaiwa mu dirumne kikiyan muma matai yaiyawa boriruwatan oya epa emeya. ");
INSERT INTO mti_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Me kumiwa apa Mosisi yaine. Me usiren onan God yautanwa me oraimina. Dud duwamdesi danave me mamawa gweyave amaraya koka ane. ");
INSERT INTO mti_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Me daieve barauya, Parao gwaitawa me aune sira me usiven atan oya amarane dog koka ane. ");
INSERT INTO mti_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ejipt ano muma painauwa undag Mosisi toyau waniya yaug anone, sira gaiyawa atan ge yusiatatu. ");
INSERT INTO mti_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Sira Mosisi bairawan meuma 40 mina aune Isuraeru usitainawa me owowaiwa munan danadawai aune. ");
INSERT INTO mti_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Me Ejipt apan da me owawaiwa desirom da gumbe gwambe aivi yaune. Me waitawan apan me egaven me yoig garawa Ejipt apan toen gudne. ");
INSERT INTO mti_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosisi anone owawaiwa yaug anoya God Mosisi naniwa gumbe waita waita mumpe, megara owawaviwa den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kum umae Mosisi owawaiwa gumbo uwane mu mut eme. Me wasiwamuntan oya dirum wane, ‘Apan, ye tatangwanen. Dimbae oya ye yembovit gara toene?’ ");
INSERT INTO mti_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Megara apan me eveba gwambe aiviwa Mosisi itarag atan barauk wane, ‘Bira namuyoiyoi ge keptete numa barau genne? ");
INSERT INTO mti_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Watau ge Ejipt apan toen gurana mina ge imugap ne toen gudnettan anoege?’ ");
INSERT INTO mti_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosisi mame anonewa me Midian piyuwawa a aine. Asime noi ubewa mina wakene ud duwam usitainawa yaiya. ");
INSERT INTO mti_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Bairawan 40 mina onanane. Tui Sainai megiyave at inguiwa arawa apa yoma kusi yoiya. Me apa iyam meru igemewa me danave aneya Mosisi gumbe uwane. ");
INSERT INTO mti_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Me mame yaunewa, me a ane. Me aig gumbe uwane yaimoyai yangut yaviviwa me Ayapan noiwa anone. ");
INSERT INTO mti_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ne ge mamagaiwa God muma, Ebraam ge Aisak ge Jekob God muma.’ Mosisi daram daram ge a kokavit ane, sira yaimoyai yangut den yaune. ");
INSERT INTO mti_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Meve Ayapan me gumbe wane, ‘Sandoro atan boa. Ge yokeyana piyu me piyu iyakaisi. ");
INSERT INTO mti_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne natawa di Ejipt danave iyayapan neuma gumbo gwambe eme yauna, sira ne mu awau muma anona. Meoya ne aig oneg mu waita mun naninwa gumbe muntna. Gare aga, ne barau gentna taig Ejipt aga.’ ");
INSERT INTO mti_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Iyayapan mu Mosisi mame gumbe topayag waya, ‘Bira ge namuyoiyoi abnawa ge keptete abnawa agenne?’ Apan mame God aneya nanive baraune aine, me namu yoiyoi abnawa ak iyayapan mu sira autan oya gwiruwadne. Aneya me yoma kusi dana me gumbe uwawannewa. ");
INSERT INTO mti_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Apan mame at Ejipt apa mu tam tene dauwaya, sira at Ejipt apa, Poeman Diapama apa sira bairawan 40 danave at inguiwa arawa apa anopipanumawa ge irakoniwa ane. ");
INSERT INTO mti_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mame Mosisi me Isuraeru igiyawa dirumne, ‘God ye tateaiwa gumbo propeta da ne minan yenan wagomiyape yoipe.’ ");
INSERT INTO mti_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Apan mame at inguiwa arawa apa daiboru danave aneya ge mamanaiwa gaibu wakeya. Aneya me tui Sainai apa dine. Sira apan mame inaiinai gaiyawa aug ye yenne. ");
INSERT INTO mti_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Megara nu mamanaiwa me noiwa den autan anoeme. Sira mu me topayag sira mu nibdanowa tobiroriyag at Ejipt taiktan anoeme. ");
INSERT INTO mti_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mu Aaron gumbe diya, ‘Nunan god wara, me nu namunup aipewa. Kuiyawa Mosisi me at Ejipt apa tam nun onnewa, nu den yaug anotu dimbae me gumbe matadne.’ ");
INSERT INTO mti_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kum me apa mu burumakau usiwa wariya ugauga god gumbe puyo barauya. Sira mu nanuwa gumbe wariyawa degadega eme. ");
INSERT INTO mti_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","God mu gumbo daiewa taine, sira kwiminau ugauga god meuma gumbe waieme God den tobod munne. Me propeta bukaeba danave tenewa. ‘Isuraeru gwe mumawa. At inguiwa arawa apa bairawan 40 danave puyo maeba ge puyo yeuma gunap barauyana? Ye den di barauya. ");
INSERT INTO mti_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ye Moreku nun gweyawa ge god Repan marantun meuma yotuene. Ye waiyatan oya ugauga god wariyana. Meoya ne ye tam aneg Babiron utunban aramavit teyentna.’ ");
INSERT INTO mti_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nu isimuranaiwa at inguiwa arawa danave tabenako gaibu. Mu God yangowo yauyawa. Me Mosisi dine ge yawanawa irawa gina desirom meib siya, meoya God gae meuma amave me siya. ");
INSERT INTO mti_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nu isimuranaiwa tabenako mame meib di sig amome. God nu isimuranaiwa namuwo Ju onan igiyawa atatai imne, sira mu arowa nu isimuranaiwa munne. Me kumive Josiya mu gaibu me aug onamiya. Onam Devid kumive uwane. ");
INSERT INTO mti_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Devid God namive God ano oraiwa meuma aune, sira me Jekob God meuma oya gwe sitan oya nun wane. ");
INSERT INTO mti_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Megara Soromon God oya gwe sine. ");
INSERT INTO mti_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Megara God Painauvitwa apan nanuwo gwe siyawa oma den ane danave vinpe. Propeta mamaib waivi. ");
INSERT INTO mti_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ayapan wane, kwimin me ne kin wakeeniwa arawa, sira piyu me ne amanwa egave baraunawa. Sira gwe gina ube ambuwa ye nenan simon? Sira ne nonenwa emigimtanwa arawa me ampa? ");
INSERT INTO mti_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ne naninwa dividivi undag mame den wadna?’ ");
INSERT INTO mti_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ye nonewa yaigipam, sira ye nonewa ge naunewa kwapituitui gumbe onan. Ye mameaiwa mina Guwawa Iyakaisiyapama gumbe ebnotu onan kum evedni ene. ");
INSERT INTO mti_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Propeta da ye mameaiwa den edawai muniya? Numan, Oraivitwa uwaivi gaiyawa vemewa mu guriya. Gare ye me Oraivitwa ominawa teyake me toen guriyana. ");
INSERT INTO mti_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ye aneya amat muma gumbe Gwangwan auyana, megara ye Gwangwan aninin wanewa amave den aisiyana.” ");
INSERT INTO mti_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mu mame anoyawa, mu danowa piripiri wane sira me gumbe donowa ikimikim aya. ");
INSERT INTO mti_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Megara Stepen me Guwawa Iyakaisiyapama gumbe noidauwanewa, yangut owan kwimin yaug sira God eyawa meuma ge Iesu God naniyutanwa apa yokene yaune. ");
INSERT INTO mti_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Me wane, “Yauya. Kwimin watabne Apan Usiwa me God naniyutanwa apa yokeivine ne yaveni.” ");
INSERT INTO mti_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Iyayapan mu naunowa tobot wansin kwaruwag Stepen oya kintog amiya. ");
INSERT INTO mti_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Mu me oreriyag gwe daieve aoreya an gumbe me toya botone. Koni me apa yangowo yauyawa igiyawa wape muma apan mataiwa iviwa Sauru amave teya. ");
INSERT INTO mti_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mu Stepen an gumbe toemewa, me noive nun wane, “Ayapan Iesu, ne guwanwa auwa.” ");
INSERT INTO mti_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Meve me konive popoyam aig yune sira kwaruwane, “Ayapan, kukaeba mame mu gumbo den anoa.” Me meib wag utan vinne. ");
INSERT INTO mti_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sauru ung wane Stepen toya. Me kumiwa apa at Jerusarem apa siosi oya edawai koka kumiwa uwane. Sira iyayapan undag at dada Judia ge Samaria danave marewan amiya. Apasoro mukut Jerusarem apa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Anotumat epampa igiyawa Stepen sig umiya sira menan it kokavit wag danadawai auya. ");
INSERT INTO mti_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Go, Sauru amatog siosi wakukamivi. Me gwe gwe aivi vesin ge apan bog oreriyag nog dana temunivi. ");
INSERT INTO mti_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Marewan ampa ampa amiya igiyawa gae opata wag gigeme. ");
INSERT INTO mti_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pirip at Samaria aig aine sira Keriso opataeba me apa wane. ");
INSERT INTO mti_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Iyayapan obiren agoniyayawa mu Pirip gaiyawa anoya sira irakoniwa me ane yauya. Mu undag me wanewa naunowa taiya anoya. ");
INSERT INTO mti_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Airapu kukaeba iyayapan obiren gumbo kwat gaibu wag dauwag amiya. Naniwa gegeraimusia ge amowa gegeraimusia mu obiren inaimusia. ");
INSERT INTO mti_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Meoya degadega kokavit gwetoimu koka me danave pawane. ");
INSERT INTO mti_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Megara gwetoimu mame danave apan da iviwa Saimon wakene. Me dum kwasisim numan amatog onne gwetoimu mame danave me ane. Samaria igiyawa teraya. Me membovit wane ne kokawa. ");
INSERT INTO mti_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sira iyayapan undag, kusiwa apa dog aig kokawa gumbo uwane, me gumbe yaimoyai yaug anoeme waya, “Apan mame me God yusiwa kokavitwa aune.” ");
INSERT INTO mti_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iyayapan mu me gumbe yaimoyai anoeme. Kuiyawa mu dum meuma oya bairawan obiren teraya. ");
INSERT INTO mti_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Go, Pirip opata me God toimuwawa ge Iesu Keriso iviwa meuma oya waivi iyayapan anotumat aya, sira apan ge vesin babataito aya. ");
INSERT INTO mti_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon membo anotumat ag babataito ane. Me Pirip amave ampa ampa amiya. Sira irayauyau kokavit ge irakoniwa matadne me yaune terane. ");
INSERT INTO mti_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria igiyawa God gae meuma auya. Sira apasoro mu Jerusarem apa wakeyawa anoya. Mu Pita ge Jon mu gumbo temiya amiya. ");
INSERT INTO mti_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mu eme apa onam uwaya. Mu Samaria igiyawa munan nun waya mu matai Guwawa Iyakaisiyapama aupe. ");
INSERT INTO mti_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kuiyawa Guwawa Iyakaisiyapama ande bira da egave den uwane. Mu Iesu Keriso iviwa gumbe babataito mekut auya. ");
INSERT INTO mti_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Meve Pita ge Jon mu egowo nanuwa teyawa Guwawa Iyakaisiyapama auya. ");
INSERT INTO mti_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Apasoro nanuwa egowo teemewa Guwawa Iyakaisiyapama aigne Saimon yaune. Me apasoro gumbo anmagawa aug on wan wane. ");
INSERT INTO mti_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Ne naninwa bira da egave barautnawa, me Guwawa Iyakaisiyapama aupe ne mina yusipama mame negiya autna.” ");
INSERT INTO mti_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita me gumbe wane, “Anmagawa geuma ge gungap watkukampe. Kuiyawa ge God ano puyowawa meuma anmagawa gumbe gwiruwatan ege. ");
INSERT INTO mti_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ge mame gumbe den yunadne, sira ge mame den auwa. Kuiyawa ge nonegwa God namive oraimina onan. ");
INSERT INTO mti_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Meoya ge nonegmagawa biroriya sira Ayapan gumbe nun wa. Anten danagap anoegewa me matai anog yankwepe. ");
INSERT INTO mti_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ne yaug anona ge ande sisiwa geuma koka danave wakeyana sira kukaeba geuma ande yumnat genivi wakeege.” ");
INSERT INTO mti_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon garawa wane, “Ayapan gumbe nenan nun waya. Ye meib ayawa ye divi da wayawa ne gunap den matatpe.” ");
INSERT INTO mti_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Apasoro mu ginongowa yaigipam aya yangowa yauyawa waya. Sira Ayapan gaiyawa waya. Meve mu sira at Jerusarem taig amome. Samaria igiyawa gwetoimu obiren yapave opata wag amome. ");
INSERT INTO mti_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Meoya Ayapan aneya meuma Pirip gumbe wane, “Wan yoig ebu asime sausu gambenwa apa aga. Ebu me aig Jerusarem uwag Gasa uwane. Gare at Gasa me at inguiwa arawa ane.” ");
INSERT INTO mti_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Me amatog aine. Me epin taibe Etiopia apan me kin vesinawa ankwatave nau kokawa aiviwa nuntosane. Me apan kokawa da Etiopia kin vesinawa iviwa Kandasi anmaga undag amaraivi abnawa. Apan mame Jerusarem waiyatan oya dog aine. ");
INSERT INTO mti_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Gare me gwe taig aivi. Me mae osi pui oreriyag aiviwa danave wakeg propeta Aisaya buka meuma tenewa basiyaivi. ");
INSERT INTO mti_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Guwawa Pirip dine, “Ag mae osi pui oreriyag aiviwa gumbe ug man me gaibu aisia.” ");
INSERT INTO mti_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Meve Pirip kin tog gumbe aig apan me propeta Aisaya bukaeba basiyaivi anone. Me wane, “Ge dimbae basiege yaug anoana?” ");
INSERT INTO mti_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Me wane, “Bira da den toyaunekpewa ne aninin oma ane yaug anotna?” Me Pirip oya wane, “Dog onag megiyanap wakeya.” ");
INSERT INTO mti_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Me Baiboru dana gigirum basiyaivi. Me aib tene, ‘Mae sip guremewa arawa apa veyag aivi mina, sira sip usiwa gumawa tuivi abnawa namive yokeivi mina me noiwa da den wane. ");
INSERT INTO mti_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Me iviwa aug yan barauya sira me gumbe keptete den aya. Bira da oma den ane kum meuma oya wape. Inaiinai meuma piyuwawa atan aug aine. ");
INSERT INTO mti_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kin vesinawa ankwatave nau kokawa aiviwa me Pirip digwane, “Toyaunega. Propeta bira oya mame waivi, membo oya waivi go da bira oya waivi?” ");
INSERT INTO mti_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pirip noiwa watabne, sira gigirum mame gumbe amatog Iesu oya opata wane. ");
INSERT INTO mti_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Meve mu ebu gumbe amog at yoi da gumbe uwaya. Kin vesinawa ankwatave nau kokawa aiviwa me wane, “Yawa. Yoi wakene. Dimbae oya ne babataito den aten? Babataito atanit di.” ");
INSERT INTO mti_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(-) ");
INSERT INTO mti_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Me mae osi pui oreriyag aiviwa tobodne yokene. Pirip ge kin vesinawa ankwatave nau kokawa aiviwa mu duwam yoi danave aigiya Pirip babataito awanne. ");
INSERT INTO mti_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mu yoi danave dauwayawa Ayapan Guwawa meuma me Pirip aug aine. Kin vesinawa ankwatave nau kokawa aiviwa me Pirip sira den yaune, megara me degadega gumbe sira taig aine. ");
INSERT INTO mti_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pirip at Asotas apa uwa wanne. Me gwetoimu undag aig gae oraiwa opata waivi meve Sesariya aine. ");
INSERT INTO mti_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sauru imive anoiviwa Ayapan aigowaiwa gumbo anavi ag ibnawa muntan ge guttan anoivi, sira me pirisi painauvitwa oya aine. ");
INSERT INTO mti_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Me gigirum oya nun wane Damaskas sinagogu upeba munan. Me anotumat mame eme igiyawa, apan go vesin go, yawampewa, mu tam tuwam bog Jerusarem onampe. ");
INSERT INTO mti_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Sira me aig Damaskas ob maniviwa, eyawa tatevit kwimin apa gumbe birorot esine. ");
INSERT INTO mti_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sira me piyu egave aignewa, meve noiwa anone, “Sauru Sauru, divi oya edawai negege?” ");
INSERT INTO mti_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sira me wane, “Ayapan, ge bira?” Sira Ayapan garawa wane, “Ne Iesu me ge edawai negegewa. ");
INSERT INTO mti_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gare wan yoig gwetoimu danave aga. Sira ge meve dirukpe divi ge amon.” ");
INSERT INTO mti_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Iyayapan mu me gaibu amomewa noiwa anoya, go apan da den yauya, meoya divi da den waya mu di yokeya. ");
INSERT INTO mti_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sauru piyu egave wan yoine. Yangawa meramne, go divi da oma den ane yaune. Meoya iyayapan nanive auweg Damaskas amiya. ");
INSERT INTO mti_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Me oiyat duwamdesi danave oma den ane divi da yaune, sira nakwai ge yoi den nane. ");
INSERT INTO mti_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aigowawa da iviwa Ananias Damaskas apa wakene. Ayapan irawa uyavi minawa danave wane, “Ananias,” me garawa wane, “Ayapan, ne mapa.” ");
INSERT INTO mti_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Meve Ayapan wane, “Wan yoig ebu iviwa ‘Siwavit’ aga, sira Judas gweyawa apa Tarsas apan iviwa Sauru wakene. Menan ag yawa. Me nun waivi. ");
INSERT INTO mti_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Me yaune irawa uyavi minawa danave, apan iviwa Ananias unig me kuiyave naniwa baraupe yangawa sira merampe.” ");
INSERT INTO mti_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Megara Ananias garawa wane, “Ayapan, ne anona apan mame at Jerusarem apa iyayapan iyakaisi geumawa gumbo dividivi kukaeba obiren ane.” ");
INSERT INTO mti_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pirisi koukawa me yusiwa waniyawa, me gumbe me oma ane iyayapan mu ivugwa auvemewa mu tam tuwampe.” ");
INSERT INTO mti_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Megara Ayapan mamaib wane, “Aga. Apan asime me uinoum neuma ne wagomiyanawa. Me ivunwa aug Ju onan igiyawa ge kin muma upeba ge Isuraeru wagobaviwa gumbo aipe. ");
INSERT INTO mti_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne me toyau wantna ivunwa oya me anintom danadawai aupe.” ");
INSERT INTO mti_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Meoya Ananias dauwag aine, sira gwe asime danave unig naniwa Sauru kuiyave baraug wane, “Evenwa Sauru. Ayapan Iesu me ebu taibe ge ongegewa apa uwagenne. Me ne baraunedne genan onedna. Ge sira oma ape yawa sira Guwawa Iyakaisiyapama gungap noidauwape.” ");
INSERT INTO mti_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tatevit divi da me gwambui kwapi ganawa minawa Sauru yangave aigne, meve me oma ane sira yaune. Me wan yoig babataito ane, ");
INSERT INTO mti_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","sira nakwai nag yusiwa aune. Sauru me kum upeba aigowawa me Damaskas danave wakeyawa gaibu wakene. ");
INSERT INTO mti_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sira tatevit sinagogu upeba apa me amatog opata wane, “Iesu me God Usiwa.” ");
INSERT INTO mti_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iyayapan mu mame anoyawa, terag waya, “Apan mame me apan me Jerusarem apa iyayapan mu Iesu iviwa auwayawa wakukamnewa, go onan? Me mapa onnewa, me mu tam tuwam pirisi koukawa gumbo aipe go?” ");
INSERT INTO mti_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Megara Sauru me yusiwa koka aivi, sira wag toewan munne Iesu me Keriso. Sira Ju igiyawa mu Damaskas apa wakeyawa terag anopipanum aya. ");
INSERT INTO mti_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Oiyat obiren onanane, sira Ju igiyawa Sauru tope boatan oya gae waya, ");
INSERT INTO mti_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","megara Sauru me anoano muma yaug anone. Mu Sauru tope boatan oya kum ge aram gwetoimu ankwin meuma undag yaveme. ");
INSERT INTO mti_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Meoya aigowawa mu arampuna me aug pot danave enag murap gumbe tuweg an gumbe siyawa daieve yukokoramiya aigne. ");
INSERT INTO mti_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sauru Jerusarem uwanewa, me Iesu aigowaiwa intum atan oya ageyau ane, megara mu den anotumat aya me aigowawa, sira mu a aya. ");
INSERT INTO mti_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Megara Banabas me aune, sira me aug apasoro gumbo aine. Meve Banabas natawa mu dirumne. Sauru Damaskas aiviwa, ebu taibe aninin Ayapan yaune, sira divi Ayapan dine, sira me Damaskas apa Iesu iviwa oya iyayapan gumbo gae yusipamit wane, meib Banabas dirumne. ");
INSERT INTO mti_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Meve Sauru aigowaiwa gaibu Jerusarem apa wakene, sira ingui uwag aine. Sira Ayapan iviwa gumbe gae yusipamit wane. ");
INSERT INTO mti_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Me gae Griik veme Ju igiyawa mu gaibu gae veme sira gae garawa veme. Megara mu me bo totan oya ageyau eme. ");
INSERT INTO mti_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tatawaviwa anoano muma yaug anoya, meoya me aug Sesariya amiya, sira me barauya Tarsas aine. ");
INSERT INTO mti_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Siosi me meib at Judia, at Gariri, at Samaria undag apa siya, sira yum amareme, sira Ayapan gumbe ebnotu aya. Sira Guwawa Iyakaisiyapama me amaraivi ge yusiwa wanivi meoya anotumat igiyawa obiren eme. ");
INSERT INTO mti_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita at obiren amdau aine. Me anotumat igiyawa iyakaisi mu at Ridda wakeyawa gaibu munan amdau aig uwane. ");
INSERT INTO mti_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Meapa, me apan iviwa Aeneas me yuwarane bairawan 8 deriyat egave wakenewa yaune. Me amananiwa buburuimusiawa aune. ");
INSERT INTO mti_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita dine, “Aeneas, Iesu Keriso ge warinamgempe. Wan yoiya sira deriyat geuma aug onaga.” Meve tatevit me wan yoine. ");
INSERT INTO mti_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iyayapan mu at Ridda ge at Saron apa wakeyawa mu Aeneas yaug Ayapan gumbe sira taig amiya. ");
INSERT INTO mti_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","At Joppa apa, aigo vesinawa iviwa Tabita (Gae Griik gumbe me Dorukas.) wakene. Vesin mame anoano oraiwa obiren aivi sira dividivi munivi. ");
INSERT INTO mti_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Megara me kumiwa apa, me yuwarag boane. Iyayapan kwapiwa muiniya sira me pantut painauwa gwe danave barauya. ");
INSERT INTO mti_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","At Ridda me at Joppa megiyave wakene. Aigowawa anoya Pita me at Ridda apa wakene, meoya mu apan duwam teya menan amiya, sira nun waya “Tatevit onaga.” ");
INSERT INTO mti_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Meoya Pita wan yoig mu gaibu dauwag amiya. Pita uwanewa, mu me aug pantut painauwa amiya. Kwapura undag mu me gumbe yoig iruveme, mu wape ankwatavewa ge wape egavewa obiren mu Dorukas ainamenewa toewaniya. ");
INSERT INTO mti_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita wane iyayapan undag dauwag amiya, koniwa yug nun wane. Sira tobiroriyag iragi kwapiwa yaug wane, “Tabita, wan yoiya.” Meve me yangawa meramne sira me Pita yaug wan yoine. ");
INSERT INTO mti_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita nanive wan aug waita wanne, sira me amave wan yoine. Me anotumat igiyawa iyakaisi ge kwapura auwane mu onamiya, me toewamunne me inaine. ");
INSERT INTO mti_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Gae mame at Joppa undag danave wateteyamne, sira iyayapan obiren Ayapan gumbe anotumat aya. ");
INSERT INTO mti_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sira Pita kum kusi da at Joppa apa, mae kwapiwa waribiyaivi oraimina eme abnawa Saimon gweyave wakene. ");
INSERT INTO mti_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Apan da desirom at Sesariya apa wakene. Me iviwa Korunerias. Iyayapan waya at Itari mut igiyawa wakeya. Me danave me senturion aivi. ");
INSERT INTO mti_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Me imi danawa undag God gumbe sira biviusitainawa undag gaibu God aeba ag ebnotu eme. Me puyo obiren Ju igiyawa gumbo munivi sira evedni nun waivi. ");
INSERT INTO mti_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kum da augoiyau kum koniwa 3 mina me irawa uyavi minawa yaune. Me danave me taibe God aneya meuma yaune. Me gumbe uwag wane, “Korunerias!” ");
INSERT INTO mti_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korunerias me aneya temtem yaug a ane. Me wane, “Ayapan, me divi?” Aneya me garawa wane, “Nun ge puyo geuma God namive dauwag yaugen anoivi. ");
INSERT INTO mti_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Gare iyayapan teya at Joppa ampe Saimon aug oneya. Iviwa dawa iyayapan veme Pita. ");
INSERT INTO mti_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Apan mame me iviwa Saimon me kwapiwa waribiyaivi oraimina eme abnawa gaibu wakene, me gweyawa poeman visive.” ");
INSERT INTO mti_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Meve aneya me gumbe gae wag aine. Korunerias nau meuma emewa duwam ge mut abnawa desirom munan auwane. Mut abnawa me ankwatave wakene imi danawa undag God gumbe. ");
INSERT INTO mti_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Me dividivi undag dig dirumne mu tene at Joppa amiya. ");
INSERT INTO mti_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kum umae mu amome gwetoimu ob manemewa, Pita nun watan oya at me gwe egave dog aine. Me kum kuiyunup mina. ");
INSERT INTO mti_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Me iyagon adne nakwai natan anone. Nakwai meuma tamibarip emewa me yangawa gwengwen aivi den yaiyai anoivi. ");
INSERT INTO mti_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Me yaune kwimin watabne kabum da me wape koka pepetu minawa noi bamawa duwam ge duwam bog piyu egave aig onivi. ");
INSERT INTO mti_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Me danave piyuwau mae gina ubeube amowa duwam ge duwam gaibuwa, dararat piyuwau amomewa, kwimin nenipawa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Meve, noiwa me dine, “Pita, wan yoiya. Gud na.” ");
INSERT INTO mti_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Megara Pita wane, “Ayapan, onan di. Den netewa ge miyotapama desirom da numan den di nana.” ");
INSERT INTO mti_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Noiwa duwameba sira me gumbe wane, “God waribiyanewa meib miyotapama den wa.” ");
INSERT INTO mti_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Meiba koni duwamdesi matadnewa, tatevit kabum me kwimin danave aug dog aine. ");
INSERT INTO mti_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita membo anopipanum aivi, irakoniwa me uyavi minawa yaunewa me natawa aninin. Apan upeba Korunerias tene amiyawa, Saimon gweyawa ampa yaug anoya. Meve ankwin daieve yokeya. ");
INSERT INTO mti_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mu auwag singui aya, “Saimon me iviwa dawa iyayapan veme Pita me mapa wakene?” ");
INSERT INTO mti_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita irawa me uyavi minawa oya anoiviwa, God Guwawa meuma me wane, “Yawa. Iyayapan duwamdesi genan yobeme. ");
INSERT INTO mti_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wan yoig dauwag aiga. Sira mu gaibu aisiya anopipanum den a. Ne mu tena onamiya.” ");
INSERT INTO mti_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pita yan aig iyayapan dirum wane, “Ye Pita oya yobene. Me ne. Ye dimbae oya oniyana?” ");
INSERT INTO mti_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Mu garawa waya, “Apan iviwa Korunerias wakene. Me senturion aiviwa sira apan oraiwa. Me God gumbe a aiviwa, me Ju igiyawa undag iviwa enagatemewa. Aneya iyakaisiyapama me dine, ‘Ge Pita aug gwe geuma oya onaga, gae wape anoa.’” ");
INSERT INTO mti_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Meve Pita eb munan baraune gwe danave wakeg vimpe. Kum umae Pita wan yoig mu gaibu amiya. Sira tatawaiwa upeba at Joppa apa wakeyawa me gaibu amiya. ");
INSERT INTO mti_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kum umae mu Sesariya uwaya. Korunerias me di dam desiroma ge owawaiwa auwag onamiya munan amaraivi. ");
INSERT INTO mti_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita uwanewa, Korunerias dauwag yaug, sira namive koniwa yune, sira watdega ane. ");
INSERT INTO mti_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Meve Pita wane wan yoine, sira wane, “Wan yoiya. Ne apan di.” ");
INSERT INTO mti_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Sira me Korunerias gaibu gae wag gwe danave unig amiya, me yaune iyayapan obiren iyameme. ");
INSERT INTO mti_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Me mu dirumne, “Ye yaug anoyana mina, Ju igiyawa mu Ju onan igiyawa gaibu tobot eme go amdau emewa me Gwangwan gumbe bainda onan. Megara God ne toyau nedne oma den ane watna bira da gumbe iyakaisi onanwa go miyotawa. ");
INSERT INTO mti_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Meoya ne eb yeumawa aunawa, ne den pimpangidna genan onedna. Ne singui gentna, dimbae oya ye aninin nenan eb teyana?” ");
INSERT INTO mti_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Meve Korunerias wane, “Ne gwe neuma danave kum koniwa mame asinutuwa kum oiyat koni duwamdesiyawa nun veni. Yaunawa, apan da me wape eyawa ennewa namunap yoig ");
INSERT INTO mti_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wane, ‘Korunerias, God me nun geuma anone, sira ge dividivi wantanwa me imug anone. ");
INSERT INTO mti_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Meoya apan da barauwa at Joppa aipe, sira Saimon oya eb baraupe me ompe. Iviwa da Pita waya. Apan mame me Saimon mae kwapiwa waribiyaivi oraimina eme abnawa gweyave wakeivi. Gweyawa poeman visive wakene.’ ");
INSERT INTO mti_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Meoya tatevit ne apan da tena genan onamiya. Ge onagana, me oraimina. Nu undag God namive wakeetewa anoano undag me God genan wanewa anotan oya.” ");
INSERT INTO mti_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Meve Pita amatog gae wane, “Mame gumbe ne yaug anona me taibe. God desirom desirom gumbe ubeube den ape, ");
INSERT INTO mti_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","bira da mu at kokawa ubeube wakeyawa God waiyaigimpe ipewa, sira oraiwa ape ipewa, God mu matai aupe. ");
INSERT INTO mti_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","God me Iesu Keriso gumbe yum baiganeba wag teteyamne, sira Isuraeru wagobabiwa gumbo gae meumawa baraune aine. Iesu Keriso mame me Ayapan iyayapan undag munan. ");
INSERT INTO mti_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Namu babataito me Jon opata wanewa onne, ivi Gariri apa onne Judia undag danave aninin veniyanewa ye iyaiyai yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Me Nasaret apan Iesu umumawa. God me apan mame gumbe Guwawa Iyakaisiyapama ge yusiwa egamne. Iesu mame gumbe God wakenewa, me aig anoano oraiwa ane, sira iyayapan undag mu airapu kukaeba gaibu wakeyawa warinamunne. ");
INSERT INTO mti_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sira nu dividivi undag mu Ju igiyawa arawa ge Jerusarem danave Iesu anewa yangnup yautune. Iyayapan mu apan mame korosi gumbe toya botone. ");
INSERT INTO mti_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Megara God wane Iesu mame kum duwamdesiyawa sira inaig uwanunne gunup. ");
INSERT INTO mti_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Megara me iyayapan undag gumbo onan, me nu gunup uwane. God wait numan nunan oya wagomiyane sira nu yangunup yautuwa ete. Namu Iesu sira inaine, ivi nu me gaibu nakwai natune. ");
INSERT INTO mti_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","God Iesu wat kiniyane. Iesu mame me keptete abnawa. Me bo igiyawa ge wakeemewa igiyawa kepte mumpe. Iesu nu didnunne iyayapan gumbo mame oya opata wata. ");
INSERT INTO mti_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iesu oya, propeta undag mu taibe waya bira da apan mame gumbe anotumat apewa iviwa gumbe me kukaeba meuma anog yankwepe.” ");
INSERT INTO mti_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita gae mame waiviwa, Guwawa Iyakaisiyapama me iyayapan undag mu gaiyawa anoemewa gumbo aigne. ");
INSERT INTO mti_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Anotumat igiyawa mu kwapiwa tuieme sira Pita gaibu onamiyawa mu teraya. Kuiyawa mu yauya Guwawa Iyakaisiyapama ano puyo Ju onan igiyawa gumbo aigne. ");
INSERT INTO mti_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mu anoya mu gae ubeube veme sira God degadega waneme. Meoya Pita garawa wane. ");
INSERT INTO mti_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iyayapan mame mu Guwawa Iyakaisiyapama auya nu mina, bira da oma ane yoi tobotpe sira babataito den ape?” ");
INSERT INTO mti_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sira me dirumwane Iesu Keriso iviwa gumbe babataito ape. Mu Pita gumbe nun waya me kum upeba danave wakepe. ");
INSERT INTO mti_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apasoro ge tatawaiwa at Judia danave wakeyawa mu anoya. Ju onan igiyawa mu meib God gaiyawa auya. ");
INSERT INTO mti_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pita Jerusarem dog aine, kwapituitui igiyawa me gumbe yano waya, ");
INSERT INTO mti_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ge kwapituitui onan igiyawa gumbo agana nakwai mu gaibu nana.” ");
INSERT INTO mti_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pita mu gumbo amatog gae konive konive natawa undag dirumne. ");
INSERT INTO mti_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ne gwetoimu kokawa Joppa apa nun veniwa, ne yanganwa gwengwen aivi yaiyai den anoeni irawa uyavi minawa yauna. Kabun da me wape koka pepetu minawa noi bamawa duwam ge duwam bog kwimin apa aig on ne gunap uwane. ");
INSERT INTO mti_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne yangut yaimoyai yauna. Piyuwau mae amowa duwam ge duwam gaibuwa, munnoga guguyanowa, dararat piyuwau amomewa, sira kwimin nenipawa mu yawamna. ");
INSERT INTO mti_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Sira noiwa ne didnegivi anona, ‘Pita, wan yoig gud na.’ ");
INSERT INTO mti_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ne wana, ‘Ayapan, onan di. Kuiyawa den netewa ge miyotapama desirom da numan den di nana.’ ");
INSERT INTO mti_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Noiwa duwameba kwimin apa sira wane anona, me garawa wane, ‘God muinewa divi da ne den neni den wa.’ ");
INSERT INTO mti_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Meiba koni duwamdesi matadne. Sira dividivi undag bog kwimin dog aine. ");
INSERT INTO mti_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Kumive di apan duwamdesi gwe namive ne wakeeniwa apa yokeya. Mu Sesariya apa tene ne gunap uwaya. ");
INSERT INTO mti_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Guwawa ne didnedne, “Ge mu gombo aisiya anopipanum den a. Ne tatanaiwa 6 mu gaibu antu, sira nu apan gweyawa uniktu. ");
INSERT INTO mti_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Me nu didnunne. Me aneya yaune. Aneya me gweyawa danave yokeg wane, ‘Iyayapan teya at Joppa ampe Pita waya Saimon me aug onampe. ");
INSERT INTO mti_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Apan Pita ge ge iyayapan geuma undag waitawaita amumpe gaiyawa wape.’ ");
INSERT INTO mti_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Gae amatog wanawa, amatonewa apa Guwawa Iyakaisiyapama nu egunup aigne me mina meib mu egowo aigne. ");
INSERT INTO mti_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Meapa Ayapan wanewa ne imug anona. Me wane, ‘Jon babataito yoi gumbe amunne, go ye Guwawa Iyakaisiyapama gumbe babataito aya.’ ");
INSERT INTO mti_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Meoya nu Ayapan Iesu Keriso gumbe anotumat atuwa, God ano puyowawa nunne. God ano puyowawa meib desiroma meib God mumpe. Aninin ne oma ane God aiviwa tobotna?” ");
INSERT INTO mti_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Mu dividivi mame anoyawa nouwa iyagisia. Sira God eyawa wai ag waya, “God me Ju onan igiyawa gaibu inaiinai natawa autan oya nonemagowa biroriyatanwa munne.” ");
INSERT INTO mti_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gare Stepen oya edawai amatone. Iyayapan marewaniya Penisiya, Saipras ge Antiok am uwaya, sira mu Ju igiyawa mukut gae waya bira da onan. ");
INSERT INTO mti_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Megara mu danowa Penisiya ge Saipras igiyawa upeba wakeya. Mu Antiok uwayawa Griisu igiyawa gaibu dirumeme Ayapan Iesu gaiyawa opata veme. ");
INSERT INTO mti_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ayapan naniwa mu gumbo. Iyayapan tobod mumawa kokawa mu anotumat ag Ayapan gumbe tobiyaya. ");
INSERT INTO mti_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Siosi me Jerusarem apa wakeyawa naunowa umum mame anoya. Meoya mu Banabas barauya Antiok aine. ");
INSERT INTO mti_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Me uwanewa God ano oraiwa meuma yaug degadega ane. Danewa yaigipamit amarag Ayapan gaibu wakeigimtan dirum yusiwa munne. ");
INSERT INTO mti_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Me apan oraimina sira Guwawa Iyakaisiyapama ge anotumat me gumbe noidauwane. Iyayapan obiren Ayapan gumbe onamiya. ");
INSERT INTO mti_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Meve Banabas at Tarsas aine, sira Sauru oya yobag yaune. ");
INSERT INTO mti_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sira meve Banabas Sauru yaune me aug at Antiok onamiya. Bairawan desirom siosi danave agoniyaya iyayapan abototoi toyau muniya. Sira at Antiok apa aigowawa namuiren Kristian veme. ");
INSERT INTO mti_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kum mame danave propeta upeba Jerusarem apa aig onam at Antiok uwaya. ");
INSERT INTO mti_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mu danowo desirom me iviwa Agabas wan yoine Guwawa gumbe matai matatpewa dine. Matai kait kokawa kumiwa uwape piyu egave undag warumpe. (Mame Kraudias amaraivi kumiwa apa pawane.) ");
INSERT INTO mti_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Meoya aigowawa desirom desirom yutuwa muma gumbe tatawaiwa at Judia apa wakeemewa waita a muntan oya anoya. ");
INSERT INTO mti_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mu me di aya. Banabas ge Sauru nanuwo puyo me waita muntan oya barauya namu yoiyoi igiyawa oya tam amiya. ");
INSERT INTO mti_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kum me apa kin Erod me iyayapan siosi danave wakeyawa edawai muntan oya naniwa baraune. ");
INSERT INTO mti_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Me Jemus, Jon tatawa, deba donave botone. ");
INSERT INTO mti_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Me yaug anone Ju igiyawa me gumbe degadega aya. Me Pita gaibu yumtan ane. Me Iist Onan Brediyawa Buyunaeba apa matadne. ");
INSERT INTO mti_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Me Pita aug nog danave baraune. Me mut igiyawa agonagon 4 nanuwo barau munne amarape. Agonagon muma desirom danave mut igiyawa 4. Erod imive me Uwag Gaveya Buyunaeba onanapeve Pita aug iyayapan namuwo taibe dauwape. ");
INSERT INTO mti_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Me mina, Pita nog danave yumnadne wakene. Megara siosi menan God gumbe nun evedni yaigipamit veme. ");
INSERT INTO mti_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Erod imive Pita aug taibe dauwatan anoivi. Aram watauwa Pita mut igiyawa duwam yapowo kubvinivi. Me aiyan murapeba sein duwam gumbe tunasiya, sira mut igiyawa ankwin noive nog amareme. ");
INSERT INTO mti_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Amta onan Ayapan aneya meuma uwane, sira eyawa nog danave esine. Aneya me Pita megiyave yug me wagwanamne yoine. Me wane, “Tatevit wan yoiya.” Meve aiyan murapeba sein me nanive geyot aigne. ");
INSERT INTO mti_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sira aneya me gumbe wane, “Berip geuma ena, sira sandoro ena.” Meoya Pita meib di ane. Meve aneya wane, “Wape egavewa ena sira ne amanap onaga.” ");
INSERT INTO mti_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Sira me dauwag aneya amave aine. Aneya me gumbe aiviwa gare natawa di matasivi me yaimoyai den yaug anone. Me irawa uyavi minawa anone. ");
INSERT INTO mti_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Mu ankwin namuwa ge duwameba gaveyag meve aiyan ankwinawa uwaya. Me ankwin daievenwa me gwetoimu koka aine. Sira ankwin me mu munan inganit watabne. Meve mu dauwag amiya, sira ebu taibe amomewa, aneya me tatevit yankweg aine. ");
INSERT INTO mti_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Meve Pita membovit imiwa taig anog wane, “Gare mame di yaug anona. Ayapan me aneya meuma nenan baraune onne. Erod naniwa gumbe sira Ju igiyawa mu imug anoemewa yaigipamit undag gumbe Ayapan waita nedne.” ");
INSERT INTO mti_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita mame yaug anonewa, Jon mu waya Mak, me inawa Meri gwe meuma aine. Asimeve iyayapan obiren agoniyag nun veme. ");
INSERT INTO mti_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ankwin papapak tonewa, nau warivi vesinawa iviwa Roda me garawa watan onne. ");
INSERT INTO mti_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Sira me Pita noi irawa yaug anonewa, me degadega kokavit ane. Me ankwin wataptan imiwa atataine taig kintog gwe dana unig aine. Me kwaruwane, “Pita ankwin noive.” ");
INSERT INTO mti_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mu waya, “Kwiyagwa kukaine.” Megara me egave egave waivi, “Me natawa di.” Mu waya, “Me aneya meuma.” ");
INSERT INTO mti_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Megara Pita papapak ande toivi. Mu ankwin watapke me yauya, sira mu tet koka aya. ");
INSERT INTO mti_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita me munan naniwa viyane noiwa iyagisia, sira Ayapan aninin nog dana waita negne dauwag onedna dirumne. Pita dirum wane, “Jemes tatagwanebaiwa mame oya dirumiya anope.” Meve me at da oya aine. ");
INSERT INTO mti_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wantene, Pita gumbe divi matadne mut igiyawa garawano aya. Mut igiyawa wayug wayug kokavit aya. ");
INSERT INTO mti_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erod Pita menan yaimoyai yobadne, megara oma den ane yaune. Meoya me nog amaremewa singui munne, meve nog amaremewa guttan oya dirumne. Meve me Judia yankwek Sesariya aigke asime apa wakene. ");
INSERT INTO mti_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Erod me Taiya ge Saidon igiyawa gumbo danawa piri wane. Meoya mu toborak kin gumbe amdau onamiya, sira mu yum oya Brastas me kin ankwatave amaraiviwa gumbe nun waya. Kwiyawa mu kin arawa apa nakwai muma boeme. ");
INSERT INTO mti_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Erod gae watan kumiwa barauya. Me kumive Erod kin wapeyawa enamne sira kin arawa wakeg iyayapan gumbo gae wane. ");
INSERT INTO mti_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Iyayapan kwat veme, “Mame God noiwa, apan noiwa onan.” ");
INSERT INTO mti_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tatevit, Ayapan aneya meuma Erod tone. Kuiyawa Erod God gumbe den waiyane. Nagam tune. ");
INSERT INTO mti_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ayapan gaiyawa me yoig koka aivi sira watete amne. ");
INSERT INTO mti_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas ge Sauru nau muma onanane, sira Mak waya Jon gaibu at Jerusarem taigiya. ");
INSERT INTO mti_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiok siosi danave propeta ge toewanewan igiyawa wakeya. Mu Banabas, Naijer waya Simeon, Sairin apan Rukias, Manaen, me piyu mame namuyoiyoi abnawa Erod gaibu am naya, ge Sauru. ");
INSERT INTO mti_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Mu Ayapan waieme sira kwit emewa, Guwawa Iyakaisiyapama wane, “Banabas ge Sauru nenan wagomiyak negiya. Ne nau neuma atan oya munan auwana nau ape.” ");
INSERT INTO mti_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mu kwit ake nun waya. Mu nanuwa egowo teya sira mu temiya amiya. ");
INSERT INTO mti_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mu duwam Guwawa Iyakaisiyapama temunne amiya. Mu Serukia amiya sira me apa Saipras oya wa gumbe amiya. ");
INSERT INTO mti_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Meve mu at Saramis uwaya Ju sinagogu danave mu God gae meuma opata waya. Jon mu gaibu wakeg waitawaita muniya. ");
INSERT INTO mti_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Mu ginayapawa undag birorot amiya meve at Papos uwaya. Asime apa mu ugauga propeta, Ju dum abnawa me iviwa Baru-Iesu nun tosaya. ");
INSERT INTO mti_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Apan mame at me namuyoiyoi atan abnawa Serugio Poras gumbe wakene. Serugio Paurus me anoano abnawa sira Banabas ge Sauru munan auwane. Kuiyawa me God gae meuma anotan anoivi. ");
INSERT INTO mti_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Sira kwasisim da Eraimas wakene. (Iviwa Eraimas me tobiroriyanewa natawa kwasisim.) Me mu duwam topai munne, sira me imive at me namuyoiyoi abnawa anotumat meuma biroriape. ");
INSERT INTO mti_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Megara Sauru, iviwa da waya Poru, me Guwawa Iyakaisiyapama noidauwane yangut Eraimas temtemtem yaune wane, ");
INSERT INTO mti_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ge uga ge gwambe undag ge gungap noidauwane, ge airapu kukaeba usiwa, sira oraiwa undag anavi ana. Ge Ayapan ebuwawa siwavitwa epin gwambe ege me den yankweege? ");
INSERT INTO mti_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Gare yawa. Ayapan naniwa ge egagap wakene. Ge yangagwa muniwape koni pipi danave kum eyawa den yawa.” Tatevit igu ge aram me gumbe uwaya, meoya me pom ge pam aivi bira da me naniwa wattan oya. ");
INSERT INTO mti_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mame mataddnewa at me namuyoiyoi abnawa me yaune, me anotumat ane. Kuiyawa me Ayapan toewanewan meuma gumbe terane. ");
INSERT INTO mti_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Papos apa Poru ge owawaiwa Pampuria danave at Perga oya wa gumbe amiya. Asimeve Jon mu kwem sira taig at Jerusarem aine. ");
INSERT INTO mti_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perga apa mu Pisidia danave at Antiok amiya. Sabat kumive mu sinagogu unig yan wakeya. ");
INSERT INTO mti_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Gwangwan ge Propeta buka mumawa basiyaya onanane. Sinagogu namuyoiyoi igiyawa gae mu gumbo veme, “Tatangwanen, ye yapeyap bira da dega muntan gaiyawa wakepewa iyayapan mame oya wat dirumiya.” ");
INSERT INTO mti_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Meve Poru wan yoik naniwa viyak wane, “Isuraeru igiyawa ge God gumbe aepam emewa, ne watna anoya. ");
INSERT INTO mti_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isuraeru igiyawa God mumawa. Me mamanaiwa wagomiyamunne. Iyayapan Ejipt danave wakeyawa me yusiwa munne obiren aya. Naniwa painau enagakke iyayapan namuwo yoik tam at me kweg dauwag onamiya. ");
INSERT INTO mti_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","At Inguiwa arawa danave bairawan 40 mina mu amat amunne. ");
INSERT INTO mti_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","At Keinan danave dam 7 me wakukamunne. Piyu me keb ag munne piyu kwan muma ane. ");
INSERT INTO mti_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Undag mame bairawan 450 mina aune. Dividivi mame onanane me keptete igiyawa munne, meve propeta Samueru baraune onne. ");
INSERT INTO mti_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Meve iyayapan kin oya autan anoeme. Meoya God dam Benjamin apan Kis usiwa Sauru munne. Me bairawan 40 amarane. ");
INSERT INTO mti_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","God Sauru itarane, meve Devid aug yudabne kin muma ane. Me Devid yaug natawa wane, ‘Ne Jesi usiwa Devid yauna. Me nonenwa, sira dividivi undag ne anoeniwa me ape.’ ");
INSERT INTO mti_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Apan mame yawa meuma gumbe, God me Waita Abnawa Iesu baraune. Me Isuraeru uwanewa agi wanewa gumbe. ");
INSERT INTO mti_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Namu Jon nonemagowa biroriyatan ge babataito atan oya Isuraeru igiyawa undag gumbo opata wane, ivi Iesu uwane. ");
INSERT INTO mti_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon inaiinai meuma onanaivi me wane, ‘Ye anoene ne bira? Ne apan me onan. Go, yauya. Me ivi amanap onivi. Ne oma den ane beyawa sandoro murapeba vetna.’ ");
INSERT INTO mti_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tatangwanen, Ebraam wagobaviwa, sira ye yapeyap God gumbe aepam emewa. Waita waita gaiyawa mame nunan baraune onne. ");
INSERT INTO mti_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusarem igiyawa ge namuyoiyoi mumawa mu Iesu mame den yaug anoya, sira propeta gaiyawa Sabat Kumiwa evedni basieme go mu den yaug anoya. Mu Iesu kukaeba abnawa waya, me gumbe propeta gae mumawa natawa ane. ");
INSERT INTO mti_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mu Iesu gumbe toen guttan oya ibnawa da den yauya, megara mu Pairat me ayaya tope bototan. ");
INSERT INTO mti_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Mu Iesu oya dividivi undag aya onananewa, sira yoma korosi gumbe aug aigeg dagup danave barauya. ");
INSERT INTO mti_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Megara God ane boriruwayawa igiyawa gumbo Iesu sira inaine. ");
INSERT INTO mti_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iesu me gaibu Gariri dauwag Jerusarem onamiyawa oiyat obiren namuwo uwaivine. Gare mu yangowo yauyawa igiyawa iyayapan numawa gumbo. ");
INSERT INTO mti_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","God mamanaiwa gumbo agi wanewa nu opata ye guniyap vete. ");
INSERT INTO mti_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","God Iesu warinamne yoine. Me gumbe, agi meuma me natawa wagobabiwa gunup toyau nunne. Buka Sam duwameba danave mamaib tene. ‘Ge ne utunwa. Gare ne barau genna.’ ");
INSERT INTO mti_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","God me Iesu bo gumbe warinamne yoine sira den di putaipe. Me gumbe me mamaib wane, ‘Ne Devid gumbe agi wanawa. Agi me iyakaisi ge natawa waribiya yentna.’ ");
INSERT INTO mti_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Meoya ampa da danave mamaib wane, ‘Ge Iyakaisi Abnawa geuma oma den ane kweya putaipe.’ ");
INSERT INTO mti_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Devid wakeivi kumive me God anoano meuma oya nauwawa ane. Sira me botone isimuranaiwa gumbo barauya kwapiwa putaine. ");
INSERT INTO mti_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Megara God warinamne bo gumbe yoinewa me den putaine. ");
INSERT INTO mti_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Meoya tatanaiwa, Apan mame gumbe, kukaeba anog yankwetan opataeba ye guniyap waivi ye yaiyai yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosisi Gwangwan gumbe iyayapan mu dividivi undag gumbe oma den ane oraimina aya, megara Apan mame gumbe iyayapan desirom desirom anotumat ape ipewa, dividivi undag gumbe oraimina ape God namive. ");
INSERT INTO mti_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ye yaimoyai yaukapa, propeta buka muma danave wayawa ye guniyap den matatpe. ");
INSERT INTO mti_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Yauya. Ye, ae vene igiyawa. Anopipanum aya, onanaya. Ye kum yeuma apa divi da atna. Bira da ye guniyap natawa taibe diruipe, go ye anotumat den di aya.’” ");
INSERT INTO mti_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Poru ge Banabas sinagogu kweg amomewa, iyayapan nun waya pura da umae Sabat Kumiwa gae mame sira didnuniya. ");
INSERT INTO mti_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Sinagogu daiboruwawa onanane. Ju igiyawa obiren ge God noiwa aueme anotumat mumawa tobiroriyayawa mu Poru ge Banabas amowo amiya. Mu gumbo gae waya, sira mu dirumiya God ano oraiwa meuma danave wakeigimiya. ");
INSERT INTO mti_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pura da umae Sabat Kumiwa apa gwetoimu igiyawa koni undag God gaiyawa anotan oya agoniyaya. ");
INSERT INTO mti_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Megara Ju igiyawa mu iyayapan agoniemewa yauyawa, anokukam muma nibdanowa noidauwane, sira Poru wanewa gumbe topayak gae kukaeba gumbe veme. ");
INSERT INTO mti_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Me oya Poru ge Banabas garawa taibe mu gumbo waya, “Nu God gae meuma namu ye guniyap wapono go. Megara ye topayayana sira ye yembovit yaibobot inaiinaiba oya oma den ane yaug anog barauya. Yauya. Nu Ju onan igiyawa gumbo angetan anoete. ");
INSERT INTO mti_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kuiyawa mamaib Ayapan did nunne. ‘Ne ana ge Ju onan igiyawa eyawa muma ana. Me ge waitawaita aug piyu viripusiwa aitan oya.’” ");
INSERT INTO mti_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ju onan igiyawa mame anoyawa, mu degadega ake Ayapan gae meuma waiyaya. Yaibobot inaiinaiba oya wagomiyayawa munnewa undag anotumat aya. ");
INSERT INTO mti_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","At me apa undag Ayapan gae meuma wateteyamiya. ");
INSERT INTO mti_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Megara Ju igiyawa God noiwa aueme ano wake wake painau vesinowa ge gwetoimu namu yoiyoi igiyawa danowa kwaikwai aya. Mu Poru ge Banabas edawai muniya mu imiya dauwag arowon amiya. ");
INSERT INTO mti_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mu duwam garawa amowa atapupu tog sira at Aikoniam amiya. ");
INSERT INTO mti_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Aigowawa mu danowo degadega ge Guwawa Iyakaisiyapama gumbo noidauwane. ");
INSERT INTO mti_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","At Aikoniam apa, evedni mu amomewa mina, Poru ge Banabasi mu duwam toborak Ju sinagogu muma unigiya. Mu gae wayawa Ju ge Griisu igiyawa obiren anotumat aya. ");
INSERT INTO mti_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Megara Ju igiyawa upeba anotumat den eme. Mu Ju onan igiyawa danowa dana kwaikwai aya, Ju onan igiyawa mu ano kukaeba tatawaiwa gumbo anoya. ");
INSERT INTO mti_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kum obiren mu asimeve wakeg Ayapan gumbe gae yusipamit waya. Ayapan mu nanuwa gumbe irakoniwa ge anopipanumawa aya. Sira Ayapan ano oraiwa meuma natawa toyau munne. ");
INSERT INTO mti_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Megara gwetoimu danave iyayapan kep upeba gamben gamben teya. Gamben Ju igiyawa gaibu, dawa apasoro gaibu. ");
INSERT INTO mti_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ju onan igiyawa ge Ju igiyawa mu duwam namuyoiyoi igiyawa muma gaibu apasoro gumbo ubmamawa atanwa ge an gumbe guttanwa oya ano eme. ");
INSERT INTO mti_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mu duwam me yaug anoyawa, Rikakonia gwetoimuwawa Ristra ge Derube, sira gwetoimu megiyavewa oya a amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Asimeve mu gae oraiwa sira evedni opata veme. ");
INSERT INTO mti_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ristra apa apan amawa gegerainewa asime yan wakene. Me meib yaine a den yoig aivi. ");
INSERT INTO mti_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Apan mame Poru gae waivi naunawa taig anoivi. Poru me temtemtem yaune, sira me yaug anone apan me amawa oraimina atan oya anotumat gumbe wakene. ");
INSERT INTO mti_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Me noiwa kokavit wane, “Amagap wan yoiya.” Meve me pisapisag amatog aine. ");
INSERT INTO mti_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Iyayapan obiren Poru dimbae anewa yauyawa, Rikakonia gae muma gumbe nouwa owan kwaruwaya, “God me apaniren mina ane nu gunup aig onne.” ");
INSERT INTO mti_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Mu Banabas me Seus veme, sira Poru me Erumes veme, kuiyawa Poru me gae abnawa. ");
INSERT INTO mti_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Seus temporu meuma gwetoimu ankwin namive yokene. Seus pirisi meuma me burumakau apanit ge ben tam gwetoimu ankwin noiwa onne. Kuiyawa me ge iyayapan obiren imuwo puyo menan tepe. ");
INSERT INTO mti_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Apasoro Poru ge Banabas mame anoyawa, mu wape muma viya iyayapan obiren danowo toen dum kwarapam unigiya. ");
INSERT INTO mti_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Mu waya, “Iyayapan numa. Dimbae ye mame ene? Nu iyayapan ye mina di. Nu gae oraiwa yenan aug ongete. Dividivi mame oraimina onan. Ye mame yan kwem God yaibobot viniviwa gumbe tobiroriyaya oya. God kwimin ge piyu ge paurum ge mu danowo dividivi undag me wadne. ");
INSERT INTO mti_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Watavit kumiwa apa God kwemne piyu egave iyayapan undag mu ebu muma minamina amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Megara me membovit taibe aivinewa den yankwene. Me baigan meuma gumbe kwimin apa uvin ge maura kumiwa nunivi sira nakwai ge degadega gumbe nu danunup noidauwane.” ");
INSERT INTO mti_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mu gae mame natawa mina oya wa ge wa eme. Waigin oieba iyayapan obiren puyo muntan emewa me yan kweya. ");
INSERT INTO mti_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Meve Ju igiyawa upeba Antiok ge Aikoniam apa onamiya. Mu iyayapan obiren niuo kaeya muniya, sira Poru agim gumbe toya. Mu anoya me wait botone sira gwetoimu daieve me oreriyag dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Megara aigowawa agoniyag Poru birorot paniyawa, me wan yoike gwetoimu danave unig aine. Kum umae me Banabas gaibu Ristra kweg Derube amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mu gae oraiwa gwetoimu danave opata wag aigowawa obiren tamiya. Meve mu taig at Ristra, Aikoniam ge Antiok amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Mu aigowawa guwowa gumbe yusiwa muniya. Anotumat kikikit yumnattan dirumeme. Mu waya, “God toimuwawa danave nu uniktanwa me yaigiwa obiren dadi danave unigtan ete.” ");
INSERT INTO mti_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Poru ge Banabas siosi desirom desirom namuyoiyoi munan atan oya gomiya muniya. Sira mu munan nun waya kwit ag mu tam anotumat gumbe Ayapan gumbe teya. ");
INSERT INTO mti_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Mu duwam Pisidia gaveyag uwag amiya meve Pampiria uwaya. ");
INSERT INTO mti_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Meve mu Peruga danave gae opata waya sira aigeg at Ataria amiya. ");
INSERT INTO mti_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ataria apa mu wa egave taig Antiok onamiya. Antiok apa numan God oraiwa gumbe mu te muniya amiya, gare nau muma undag onanane. Sira Antiok taig onamiya. ");
INSERT INTO mti_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Asime mu uwag siosi igiyawa mu desiromit toboraya. Dividivi undag God mu gumbo wakeg anewa sira anotumat ankwineba Ju onan igiyawa munan watabnewa umumawa waya. ");
INSERT INTO mti_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Mu asime apa aigo igiyawa gaibu kum yobutatae wakeya. ");
INSERT INTO mti_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Sira iyayapan upeba Judia apa aig onam tatawaiwa toewan muneme, “Mosisi Gwangwan meuma gumbe ye kwapiwa den tuiyawa, ye oma den ane waitawaita auya.” ");
INSERT INTO mti_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Poru ge Banabas mu yapowo wan yoieg gae yaigipamit garawa eme. Poru ge Banabas ge upeba danowo wag gomiya muniya. Mu Jerusarem amotan eme. Me apa apasoro ge namuyoiyoi igiyawa gaibu gae watan oya. ");
INSERT INTO mti_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Siosi igiyawa te muniya. Mu Penisiya ge Samaria gaveag amome. Mu epin taibe gae undag dirumiya. Ju onan igiyawa aninin nib danowo God gumbe tobiroriyaya. Tatawaiwa undag me anoya degadega kokavit aya. ");
INSERT INTO mti_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Meve mu onam Jerusarem uwaya. Siosi igiyawa, apasoro namu yoiyoi igiyawa mu gaun muniya. Mu dividivi undag God mu gumbo wakeg anewa umum dirumiya. ");
INSERT INTO mti_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Megara, numan Parisi intum aya gare anotumat emewa mu wan yoik waya, “Ju onan igiyawa kwapiwa mu tuitanit di. Sira Mosisi Gwangwaneba oya wag dirumta mu amaratanit di.” ");
INSERT INTO mti_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Sira apasoro ge namuyoiyoi igiyawa singui mame yaug anotan oya toboraya. ");
INSERT INTO mti_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Mu gae yusipamit garawa aya onanane. Pita wan yoik mu dirumne, “Tatangwanen, ye anoyana, kum mayabit apa God ye yapeyap wat gomiyane Ju onan igiyawa ne nonuwa gumbe gae oraiwa anok sira anotumat aya. ");
INSERT INTO mti_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Sira God me iyayapan danowa yaug anonewa, Guwawa Iyakaisiyapama nu nunne mina Ju onan igiyawa munne. Mu gumbo meib taibe uwa munne. ");
INSERT INTO mti_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Me nu ge Ju onan igiyawa yapave ube da den wadne. Kuiyawa me anotumat muma gumbe mu danowa muinne. ");
INSERT INTO mti_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Megara ye dimbae oya aigowaiwa meyowa yoma tek ibnawa munag oya God gumbe ageyau ene? Isimuranaiwa ge nu oma den ane ibnawa mamaib autu. ");
INSERT INTO mti_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Nu anotumat atu Ayapan numa Iesu ano oraiwa gumbe waitawaita autu. Sira mu mina meib.” ");
INSERT INTO mti_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Meve iyayapan undag agoniyayawa nouwa iyagisia. Banabas ge Poru mu God Ju onan igiyawa yapowo mu gumbo irakoniwa ge anopipanumawa anewa gae waya. Gae vemewa, mu yaimoyai anoya. ");
INSERT INTO mti_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Mu gae waya onanane meve Jemus garawa wane, “Tatangwanen, ne gunap anoigimiya. ");
INSERT INTO mti_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","God aninin namu Ju onan igiyawa gumbo kwayub a munne, sira me iviwa gumbe waya igiyawa mu yapowo iyayapan meuma bone, Simeon nu gunup wait gae wasiwamne. ");
INSERT INTO mti_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Propeta gae mumawa gae mame desirom ane. Me meib di tene. ");
INSERT INTO mti_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Dividivi mame onanapewa, ne sira taig Devid tabenako meuma gomag aignewa sitna. Undag gongamak aignewa sira sitna numanwa mina ape. ");
INSERT INTO mti_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Me, iyayapan upeba, mu Ju onan igiyawa, mu ne ivunwa gumbe iyayapan vemewa sira mu undag Ayapan kinuni atan oya. ");
INSERT INTO mti_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ayapan me watavit ampa wag dirumnewa, me meib waivi.’ ");
INSERT INTO mti_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Meoya, oieba, ne ano neuma gumbe keptena. Ju onan igiyawa mu God gumbe nib danowa tobiroriyayawa den anopipanum amuniya. ");
INSERT INTO mti_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Megara, nu gigirum munan mamaib teg dirumta. Ugauga goddeba namive tene miyotawa, uinantaraki, mae meyawa inoniyayawa ge ganigani mu yankwetanit di. ");
INSERT INTO mti_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Kuiyawa watavit ampa gwetoimu desirom desirom danave Mosisi Gwangwaneba opata vemewa wakeya, sira Sabat Kumiwa apa evedni sinagogu danave mu basiyag omome.” ");
INSERT INTO mti_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Meve apasoro, namuyoiyoi igiyawa ge siosi undag ung wayawa, siosi igiyawa mu yapowo apan upeba gomiya mumpe sira mu tepe Poru ge Banabas gaibu Antiok ampe. Mu Judas, (me iviwa veme Barusabas), ge Sairas gomiya muniya. Mu tatawaiwa yapowo namuyoiyoi igiyawa. ");
INSERT INTO mti_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Mu gaibu gigirum baraueme aivi. Mu mamib teya. “Tateaiwa, apasoro ge namuyoiyoi igiyawa mu Antiok, Siria ge Sirisiya danave Ju onan tatawaiwa oya kaiwa kaiwa muma veme. ");
INSERT INTO mti_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nu amutan den watu, go nu yapunup iyayapan upeba mu gae waya gumbe ye anopipanum ayana sira ye nonemagewa yaimoyai den wakene. Nu meib anoete. ");
INSERT INTO mti_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nu danunwa undag desirom ane. Nu apan upeba gomiya muntu sira nu iyayapan numa nonunmagawa Poru ge Banabas gaibu yenan te muntu. ");
INSERT INTO mti_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Poru ge Banabas mame mu Ayapan numa Iesu Keriso iviwa oya inaiinai muma topayaya. ");
INSERT INTO mti_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Meoya nu Judas ge Sairas temete mu gae desiroma mu nouwa gumbe wape. ");
INSERT INTO mti_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Guwawa Iyakaisiyapama ge nu dividivi mame amaratan anoetewa me mekut yempe. Ibnawa da den yempe. ");
INSERT INTO mti_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ugauga goddeba namive tenewa, ganigani, mae meyawa inoniyayawa ge uinantaraki yan kweya. Ye yaukapa dividivi mame gumbe painau wakeyawa me oma ane. Wakeya.” ");
INSERT INTO mti_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mu marewan dauwag Antiok aig amiya. Me apa mu siosi igiyawa toborak gigirum mu nanuwo barauya. ");
INSERT INTO mti_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Iyayapan gigirum basiyag yusiwa muntan gaiyawa gumbe degadega aya. ");
INSERT INTO mti_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ge Sairas mu mina mumbovit propeta. Mu gae obiren waya tatawaiwa yusiwa munke degadega aya. ");
INSERT INTO mti_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Mu oiyat upeba asime wakeya. Tatawaiwa yum gumbe temuniya. Mu at kweya at namu on temuniya amiyawa apa taig amiya. ");
INSERT INTO mti_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(-) ");
INSERT INTO mti_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Poru ge Banabas ande Antiok apa wakeya. Me apa mu iyayapan upeba obiren gaibu Ayapan gae meuma toewanewan ge opata amuniya. ");
INSERT INTO mti_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Oiyat upeba onanane Poru me Banabas gumbe wane, “Nu numan Ayapan gae meuma opata atu. Asimeve sira taig gwetoimu desirom dada gumbe tatanaiwa gumbo amdau anta. Mu aninin emewa nu yauta.” ");
INSERT INTO mti_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas imive mu gaibu Jon aug ampe. Jon iviwa da Mak. ");
INSERT INTO mti_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Megara Poru imive den anoivi, kuiyawa Jon me Pampiria apa yankwem aike nau mu gaibu den ane. ");
INSERT INTO mti_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mu daietaitai aya. Meoya mu ubeube amiya. Banabas me Mak aug wa gumbe Saipras oya amiya. ");
INSERT INTO mti_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Poru me Sairas wagomiyane. Tatawaiwa mu Ayapan ano oraiwa gumbe anotumat yusipamit ag temuniya amiya. Mu kwem amiya. ");
INSERT INTO mti_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Poru me Siria ge Sirisiya danave uwag aine. Me kumiwa apa siosi yusiwa munne. ");
INSERT INTO mti_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Poru me Derube uwag meve Ristra aine. Me apa aigowawa iviwa Timoti wakene. Timoti me Ju anotumat vesinawa usiwa sira mamawa me Griisu apan. ");
INSERT INTO mti_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ristra ge Aikoniam apa tatawaiwa gae me oya oraivit veme. ");
INSERT INTO mti_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Poru imive apan mame gaibu aitan anoivi. Meoya Poru Timoti kwapiwa tuine. Kuiyawa me Ju igiyawa at me apa vinemewa mu undag yaug anoya me mamawa Griisu apan. ");
INSERT INTO mti_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sira mu at kokawa uwage uwag amome. Jerusarem apa apasoro ge namuyoiyoi igiyawa gwangwan gaiyawa yuya. Meoya me noiwa autan oya mu umum barau ge barau amiya. ");
INSERT INTO mti_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Meoya siosi anotumat gumbe yusiyusi aya sira iyayapan evedni tobod muma koka aivi. ");
INSERT INTO mti_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Guwawa Iyakaisiyapama tobod munne Esia apa gae den waya, meoya mu Prigia ge Garatia uwag gaveyag amiya. ");
INSERT INTO mti_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mu Misia yumateba amog uwayawa, mu amatog Bitinia uniktan anoeme, go Iesu Guwawa bainda den wane. ");
INSERT INTO mti_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Meoya mu Misia uwag Troas aigeg amiya. ");
INSERT INTO mti_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Arampuna irawa uyavi minawa Poru gumbe uwane. Mesedonia apan da Poru namive yokeke me gumbe nun waivi, “Dauwag Mesedonia onag waita nuna.” ");
INSERT INTO mti_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Poru irawa uyavi minawa yaune, tatevit nu Masedonia angetan tamibarip atu. God nunan auwane gae oraiwa opata gumbo watan ete meib taibe di yaug anotu. ");
INSERT INTO mti_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas apa nu wa autu siwavit Samotrake antu. Kum umae nu Niaporis uwatu. ");
INSERT INTO mti_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Meve nu Piripi antu. Me at kokawa Romu amaraivi, sira me at yumateba Masedonia danave namuiren gwetoimuwawa. Gwetoimu mame danave nu oiyat upeba waketu. ");
INSERT INTO mti_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabat Kumiwa apa nu gwetoimu ankwin noiwa nu dauwag antu yoi gambenwa uwatu. Nu anoete at me nun arawa. Nu me apa uwag yan waketu, vesin agoniyayawa gumbo gae watu. ");
INSERT INTO mti_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Vesin da me iviwa Ridia me Poru gae meuma anoivi. Me gwetoimu koka Taiataira danave wape me gamat diyapam ge burut yapavewa gwiruwarivi sira me God waiyaivi vesinawa. Ayapan Ridia nonemagawa watabne Poru gae waiviwa gumbe naunawa yaimoyai taig anoivi. ");
INSERT INTO mti_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Me ge apan ud meumawa babataito aya. Me mu gumbo nun kokavit wane, “Ye yaug anoyana ipewa ne Ayapan gumbe anotumat eniwa, oneg ne gwe neuma apa wakeya.” Me kaeya munne. ");
INSERT INTO mti_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nu nun veme arawa oya angetewa, otau da airapu kukaeba danave wakenewa nuntosa atu. Me koukawa ankwatawo nau aivi. Me guwawa yaug anone ivi divi matatpe dum gumbe. Me dum ag, garawa kokavit aug koukawa meuma garawa tameme. ");
INSERT INTO mti_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Otau mame Poru ge nu amunup on kwaruwaivi, “Iyayapan mame God Painauvitwa ankwatave nau eme igiyawa. Mu waitawaita ebuwawa ye diruieme.” ");
INSERT INTO mti_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Me kum obiren mame aivi. Me gumbe Poru uiwa topayadne meve man tobiroriyak airapu kukaeba gumbe wane, “Iesu Keriso iviwa gumbe ne dirugeni. Me gumbe man dauwa.” Me apa airapu kukaeba me yankweg dauwag aine. ");
INSERT INTO mti_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Me koukawa meumawa mu anmaga waremewa ebuwawa waropiyaya yauya, meoya mu Poru ge Sairas yumam tuwam orodmun amog gwiruwaremewa arawa unig uwaya. ");
INSERT INTO mti_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Mu tam onam gabemant nau eme igiyawa koukawa namuwo uwag waya, “Iyayapan mame Ju igiyawa, sira gwetoimu numawa wakukameme. ");
INSERT INTO mti_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mu inaiinai taibe did nuneme. Inaiinai me nu Romu igiyawa auta go atawa me gwambe.” ");
INSERT INTO mti_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iyayapan obiren wan yoik toboraya mu duwam gumbo danowa piriwane. Gabemant nau eme igiyawa koukawa dirumiya wape muma vike murap gumbe guriya. ");
INSERT INTO mti_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Koni obiren murap gumbe mu duwam guriya tam nog dana emeya. Mu nog amaraivi abnawa yaimoyai amat amuntan oya diya. ");
INSERT INTO mti_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nog amaraivi abnawa gae diyawa nouwa aune. Mu duwam nog dana bagive temuniya. Mu amowo kapet tuwamiya. ");
INSERT INTO mti_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nub danawa Poru ge Sairas God gumbe nun veme bererin tovemewa nog igiyawa upeba mu gumbo naunowa taig anoeme. ");
INSERT INTO mti_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Amta onan pinunu koka uwane, nog nium barauyawa ipunapun ane. Meve nog ankwinawa undag inganit watabmusia sira murap undag amowo kapesiyawa tutakwag aigiya. ");
INSERT INTO mti_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nog amaraivi abnawa gwanad yoine yaune nog ankwinawa watabmusia. Me mureme tum meuma aug membo ingan yutan ane kuiyawa me anone nog igiyawa wait dauwag a amiya. ");
INSERT INTO mti_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Megara Poru noiwa kokavit kwaruwane, “Ge gembovit den yuwa. Nu undag mapa.” ");
INSERT INTO mti_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nog amaraivi abnawa dun oya auwane. Tatevit unig daramdaram ag Poru ge Sairas namuwo uyug aigne. ");
INSERT INTO mti_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Me mu tam dauwag aig dirumne, “Koukawa. Ne aninin aka waitawaita autna?” ");
INSERT INTO mti_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Mu waya, “Ayapan Iesu gumbe anotumat a, me gumbe ge ge vesin ud geuma gaibu waitawaita auya.” ");
INSERT INTO mti_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mu God gaiyawa me ge iyayapan undag me gwe meuma danave wakeyawa dirumiya. ");
INSERT INTO mti_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Aram me kumiwa apa nog amaraivi abnawa mu tam dauwag aik kamot muma muinne. Sira tatevit me ge vesin ud meuma undag babataito aya. ");
INSERT INTO mti_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Meve me mu duwam tam gwe meuma unig amiya. Me nakwai munan namuwo tamibarip ane mu naya. Me vesin ud meuma undag gaibu God gumbe anotumat ayawa degadega aya. ");
INSERT INTO mti_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Wantene gabemant nau eme igiyawa koukawa mu nouwa nau eme igiyawa temuniya uwak diya, “Iyayapan yan me kwemiya dauwag ampe.” ");
INSERT INTO mti_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nog amaraivi abnawa gae mame Poru dine, “Gabemant nau eme igiyawa koukawa mu nouwa nau eme igiyawa tenuniya waya ye duwam kweyempe dauwag aisiya. Meoya gare yum gumbe dauwag aisiya.” ");
INSERT INTO mti_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Megara Poru noive nau eme igiyawa gumbo wane, “Gabemant nau eme igiyawa koukawa nu Romu igiyawa yai den kepte nuniya. Nu taibe murap gumbe gut nunke nog dana te nuniya. Gare nu guwave kwe nuntan eme. Onan di. Mu mumbo ingan onam kwe numpe dauwag anta.” ");
INSERT INTO mti_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nouwa nau eme igiyawa gabemant nau eme igiyawa koukawa gumbo gae mame umum waya. Poru ge Sairas mu Romu igiyawa mu anoya a aya. ");
INSERT INTO mti_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Mu uwaya nonowa watmemeyam muniya. Sira mu nog daieve tam gwetoimu danave yankweg dauwag amtan oya waya. ");
INSERT INTO mti_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Poru ge Sairas nog danave dauwaya. Mu Ridia gwe meumna unigiya. Meve mu tatawaiwa yawamiya ano yusiwa gaiyawa mu dirumiya. Sira kwem amiya. ");
INSERT INTO mti_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mu Ampiporis ge Aporonia gaveyag amome Tesaronika uwaya. Ju sinagogu muma asimeve wakene. ");
INSERT INTO mti_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Poru evedni aiviwa mina me sinagogu danave unigne. Sabat Kumiwa duwamdesi Baiboru gumbe garawano aya. ");
INSERT INTO mti_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Keriso dawai auke bo gumbe sira inaine me taibe wane sira gae mame natawa di wane. Me wane, “Iesu oya ye diruieni, Iesu mame me Keriso di.” ");
INSERT INTO mti_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ju igiyawa upeba mu yaug anoya Poru ge Sairas amowo amiya. God waiyawaiya veme Griisu obiren sira tawara vesinawa dodogu onan wakeya. ");
INSERT INTO mti_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Go Ju igiyawa upeba watkukameya. Gwiruwareme arawa apa apan kukaeba upeba ui onan gigeme. Ju igiyawa tam desirom agoniya muniya. Mu gwetoimu danave wayug wayug muma noidauwane. Mu tatevit Jeson gweyawa dana unigak Poru ge Sairas tam agonagon namuwo tetan oya munan yobareme. ");
INSERT INTO mti_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Megara mu da oma den ane yawamiya. Meoya mu Jeson ge tatawaiwa upeba orod mun gwetoimu namu yoiyoi munan onamiya mu kwat veme, “Iyayapan mu piyu undag egave wayug wayug eme mu at mame gumbe unig onamiya. ");
INSERT INTO mti_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jeson me gwe meuma dana mu tamne. Iyayapan mame undag mu kin da Iesu wakene veme, meoya mu Romu dana kokavit abnawa Siisa gwangwan meuma amave den amome.” ");
INSERT INTO mti_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Me mina iyayapan obiren ge gwetoimu namuyoiyoi igiyawa mu gae mame anoya ui aepam eme. ");
INSERT INTO mti_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mu Jeson ge iyayapan upeba gumbo garawa auya meve kwemiya dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Tatevit, tatawaiwa aram danave Poru ge Sairas temuniya dauwag at Berea amiya. Me apa uweme Ju sinagogu muma unig amiya. ");
INSERT INTO mti_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea igiyawa mu iyayapan oraimina. Tesaronika igiyawa mina onan. Mu imuwa God gaiyawa yaug anotan oya anoeme. Sira gae Baiboru gumbe yumnasiya go onan oiyat evedni yaimoyai yaveme. ");
INSERT INTO mti_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Meoya mu yapowo obiren anotumat aya. Mu anotumat igiyawa yapowo Griisu tawara vesinawa ge apan dodogu onan wakeya. ");
INSERT INTO mti_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Megara Ju igiyawa Tesaronika apa wakeyawa mu anoya Poru Berea apa gaibu God gaiyawa opata waivi. Mu asime gaibu onamiya, sira iyayapan obiren anopipanum amuniya sira meve mu wayug wayug aya. ");
INSERT INTO mti_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Meoya tatawaiwa tatevit Poru barauya me poeman aine, go Sairas ge Timoti Berea apa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Poru aigoyaya gaibu amiyawa mu me aug Asen amiya. Sira Poru dirumne Sairas ge Timoti tatevit onam gumbe uwape. Mu gae me auwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Poru Asen danave munan amaraivi. Gwetoimu me god ugaugaeba noidauwane yaune danawa piripiriwane. ");
INSERT INTO mti_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Meoya Poru me sinagogu danave Ju igiyawa ge God waiya emewa gaibu gae garawa aya. Sira kum evedni gwiruwaremewa arawa apa asime iyayapan wakeemewa gaibu gae garawa aya. ");
INSERT INTO mti_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikuros igiyawa ge Stoik igiyawa anoano anoemewa upeba me gaibu garawa aya. Epikuros upeba waya, “Apan mame dimbae watan aivi?” Sira upeba waya, “Ne anoeniwa at painauwa goddeba oya waivi.” Kuiyawa Poru me Iesu ge sira inainewa opata waivi. ");
INSERT INTO mti_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Meve mu Poru daiboru arawa Areopagas aug amiya waya, “Mame toyautoyau mataiwa ge opata vege. Me dimbae toyau nuna? ");
INSERT INTO mti_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ge anoano gina ubewa nu naununwa gumbe tam ongege. Meoya nu imunup anotan me dimbae.” ");
INSERT INTO mti_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Asen igiyawa ge at ubewa igiyawa me apa vinemewa undag mu kum muma gumbe divi da den ag wakeeme. Mu anoano mataiwa oya gaiyawa veme sira naunowa taieme. ");
INSERT INTO mti_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Meve Poru me Areopagas bunangave wan yoik wane, “Asen igiyawa. Ne ebu undag gumbe yauyemna, ye anotumat kokavit ene igiyawa. ");
INSERT INTO mti_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ne a gigeni sira yangut yaimoyai ye waienewa yawameni. Ne yauna iyakaisi kem meuma gaibu wakene. Me egave ‘God me gumbe den yaug anotuwa oya,’ me tene. Ye den yaug anog sira waienewa me dimbae diruitna. ");
INSERT INTO mti_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God piyu ge piyu danave dividivi undag wadne. Sira God mame kwimin ge piyu Ayapaneba. Meoya me iyayapan nanowa gumbe siyawa temporueba danave den vinivi. ");
INSERT INTO mti_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Sira me divi da anoiviwa oya iyayapan nanowa gumbo waita wantan oya den anoivi. Kuiyawa God me membovit inaiinai, ge gaup ge dividivi undag iyayapan munne. ");
INSERT INTO mti_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sira me apan desirom gumbe iyayapan undag piyu egave wadne. Me piyu egave undag temunne mu vinag wakeeme. Me kumive kumive iyayapan tene sira mu vinag wakeeme yumateba baraune. ");
INSERT INTO mti_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God mame ane iyayapan me gumbe kiniyatan oya. Sira mu me didimama apewa me yaupe. God nu desirom desirom gunup painau den wakene. ");
INSERT INTO mti_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kuiyawa nu God danave vinete, a gigete, wakeete. Me natawa di, ye yapeyap buka Sam me Baiboru danave wakenewa mina teeme igiyawa mu waya, ‘Nu gaibu dam desiroma gumbe yaig onnewa.’ ");
INSERT INTO mti_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nu God usitainawa. Iyayapan upeba ano muma emewa gumbe oraimina, sira nanuwa gumbe nau eme oraimina. Mu gooru, siruva go an gumbe god guwawa wariya. Megara God me mina onan. Nu meib di anotanit di. ");
INSERT INTO mti_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Watavit kumiwa apa iyayapan den yaug anog emewa God anog yankwemne, mu anoemewa eme. Megara gare God iyayapan undag ampa ampa wakeemewa dirumne nonemagowa biroriyaya. ");
INSERT INTO mti_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Kuiyawa God me Apan da wagomiyane. Apan me natawa gumbe piyu keptetan oya God kum meuma baraune. Sira God boriruwayawa igiyawa gumbo me sira inaine meoya iyayapan undag mame natawa toyau munne.” ");
INSERT INTO mti_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Bo gumbe inaipe mu anoyawa, upeba me iyagau eme. Sira upeba waya, “Nu mame gumbe kum da sira ge gungap anota.” ");
INSERT INTO mti_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Poru iyayapan agoniyayawa danave kwem dauwag aine. ");
INSERT INTO mti_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Megara iyayapan upeba Poru amave amog anotumat aya. Mu Areopagas apa keptete abnawa da Daionisius, vesin da iviwa Damaris ge iyayapan upeba. ");
INSERT INTO mti_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Dividivi mame onanane, ivi Poru Asen kweg at Korint aine. ");
INSERT INTO mti_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Asimeve Poru Ju apan iviwa Akuira yaune, me at Pontas apa yainewa. Me matai at Itari apa dauwag biviwa Prisira gaibu onamiya. Kuiyawa Kraudias me Romu ayapaneba me Ju igiyawa undag at Romu yankwetan oya dirumne. Poru mu gumbo aine. ");
INSERT INTO mti_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Kuiyawa Poru me mina baram gumbe gwe sivi abnawa, meoya mu gaibu wakeg nau aya. ");
INSERT INTO mti_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabat Kumiwa apa evedni me sinagogu danave toyau munne. Poru me imive gae meuma oyog oyog ape anone. Griisu igiyawa ge Ju igiyawa yan tope me noiwa aupe. ");
INSERT INTO mti_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sairas ge Timoti Masedonia apa onamiya. Meve Poru membovit gae toyau muntan oya nib danawa undag me apa wakene, sira me Ju igiyawa gumbo taibe dirumne Iesu me Keriso. ");
INSERT INTO mti_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Megara mu Poru gae meume noiwa den auya gae gwambe waya. Meoya Poru wape meuma viyaviya ane mu gumbo wane, “Ye ganigani yeumawa kuieyap aikpe. Ne amat neuma ye guniyap onan. Gare mame apa ne Ju onan igiyawa gumbo anekna.” ");
INSERT INTO mti_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Poru me apa yan kwek dauwag apan da gwe meuma aine. Me iviwa Taitias Jastas, God waiyaivi abnawa. Gwe meuma sinagogu megiyave. ");
INSERT INTO mti_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sinagogu namuyoiyoi abnawa Krispas ge vesin ud meuma undag anotumat Ayapan gumbe aya. Sira Korint igiyawa obiren mu anok anotumat aya babataito aya. ");
INSERT INTO mti_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Aram da arampuna Ayapan irawa uyavi minawa gumbe Poru dine, “A den a. Gae waigima. Nogwa den iyagita. ");
INSERT INTO mti_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ne ge gungap. Da bira ge gungap divi da den ape. Da bira ge den towakpe. Kuiyawa ne iyayapan neuma obiren gwetoimu mame danave wakeya.” ");
INSERT INTO mti_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Poru bairawan desirom ge dud 6 mina mapa wakene, God gaiyawa toyau munne. ");
INSERT INTO mti_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gario me at Akaia amaraivi abnawa kumive, Ju igiyawa danowa desirom aya Poru totan oya me keptete arawa aug amiya. ");
INSERT INTO mti_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Mu waya, “Apan mame iyayapan Gwangwan gumbe ubeube ag God waiya atan oya ayag munivi.” ");
INSERT INTO mti_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Poru noiwa watap gae watan aiviwa, Gario me Ju igiyawa gumbo wane, “Ye Ju igiyawa, me ugauga emewa go kukaeba kokavit emewa oya ipewa, ne ye guniyap naunanwa taig anotna. ");
INSERT INTO mti_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Megara me gae, ge iviwa ge Gwangwan yeuma oya singui gumbe ipewa, ye yembovit ibnawa yeuma wasiwamiya. Ne dividivi mame gumbe den keptetna.” ");
INSERT INTO mti_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Me keptete arawa apa mu atatai imne. ");
INSERT INTO mti_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Meve mu undag sinagogu namuyoiyoi abnawa Sostene yumiya keptete arawa namive me toya. Megara Gario dividivi mame oya den anone. ");
INSERT INTO mti_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Poru ande oiyat obiren Korint apa wakene, meve tatawaiwa gumbo wakeyo wane, wa gumbe Siria aine. Prisira ge Akuira gaibu amiya. Poru me God gumbe agi wane oya at Senkrea apa kuiyagumawa wadne. ");
INSERT INTO mti_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mu at Epesas uwaya. Poru asimeve Prisira ge Akuira kwemne me mekut sinagogu unigne Ju igiyawa gumbo garawano aya. ");
INSERT INTO mti_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mu me diya kum kusi yobe mu gumbo waketan oya waya. Megara me waketan den anone. ");
INSERT INTO mti_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Me wak kwem agi wane, “God ano meuma ipewa ne matai sira taig onekna.” Meve me at Epesas apa wa gumbe dauwag aine. ");
INSERT INTO mti_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Meve me at Sesariya uwag aigne sira dog aig Jerusarem siosi igiyawa yawamne meve at Antiok aig aine. ");
INSERT INTO mti_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Poru asimeve kum upeba wakene. Sira me amdau amatog at Garatia ge Prigia danave undag aig aigowawa undag ano yusiwa gaiyawa dirmne. ");
INSERT INTO mti_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sira Ju apan iviwa Aporos me at Arekisandria apan me at Epesas onne. Me gae oraivit waivi abnawa sira me Baiboru anoano meuma yaug anone. ");
INSERT INTO mti_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Apan mame Ayapan ebuwawa toyau waniya. Me Guwawa meuma igivi Iesu gumbe gae siwavit toyaumunivi, go me Jon babataito meuma mekut anone. ");
INSERT INTO mti_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apan mame sinagogu danave amatog gae taibe yusipamit waivi. Prisera ge Akuira me anoya. Mu gwe muma ontan oya me diya, God ebu meuma yaimoyai me diya. ");
INSERT INTO mti_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aporos me Akaia aitan anoivi. Tatawaiwa me yusiyusi atan gaiyawa me diya. Sira aigowawa asime wakeyawa gigirum munan teya. Me asime uwanewa, wait God oraiwa gumbe anotumat aya igiyawa gumbo waitawaita kokavit munne. ");
INSERT INTO mti_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Me Baiboru gumbe Iesu me Keriso taibe ane, sira me Ju igiyawa gae muma yusipamit taibe, yan tene. ");
INSERT INTO mti_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Aporos at Korint apa wakeiviwa, Poru amave at ebu me poeman visive onan aig Epesas uwane. Asimeve me aigowawa upeba yawamne. ");
INSERT INTO mti_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Sira me singui munne, “Ye anotumat ayawa Guwawa Iyakaisiyapama auyana?” Mu garawa waya, “Onan. Nu den di anotu Guwawa Iyakaisiyapama autan oya.” ");
INSERT INTO mti_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Sira me wane, “Ye babataito dimbae auyana?” Mu waya, “Jon babataito meumawa nu autu.” ");
INSERT INTO mti_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Poru wane, “Jon babataito meumawa me nonemagowa biroriyatan oya. Me iyayapan dirumne apan da me ivi ne amanap onivi, me Iesu. Me gumbe anotumat aya.” ");
INSERT INTO mti_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Mu mame anoya, Iesu Keriso iviwa gumbe babataito aya. ");
INSERT INTO mti_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Poru kuiyowo naniwa tenewa Guwawa Iyakaisiyapama egowo aigne. Sira mu gae pednowa ubeube waya, God oya gae waya. ");
INSERT INTO mti_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iyayapan undag 12 mina me apa wakeya. ");
INSERT INTO mti_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Meve Poru sinagogu danave unig dud duwamdesi danave taibe yusipamit toyau munne, sira God toimuwawa oya gae yusipamit dirumne. ");
INSERT INTO mti_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Megara iyayapan upeba danowa yaigiwane naunowa den taig anoya sira iyayapan obiren namuwa Ebu mame oya gae kukaeba waya, meoya Poru kwemne. Sira Poru aigowawa kwemtan oya dirumne. Sira Poru me Tairanas gigirum gweyawa danave evedni wag dirumne. ");
INSERT INTO mti_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Toewanewan mame bairawan duwam danave meib di aine. Meoya Ju igiyawa ge Griisu igiyawa undag Esia danave vinemewa Ayapan gae meuma anoya. ");
INSERT INTO mti_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God Poru naniwa gumbe irayauyau kokavit ane. ");
INSERT INTO mti_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Poru me atop go wape kapet tuiviwa atan tam yuwat igiyawa gumbo tenewa, yuwat kwemne ge airapu kukaeba dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ju igiyawa mu airapu kukaeba danowo wakeyawa dauwag amtan oya nauwawa emewa mu ampa amdau amome. Mu upeba airapu kukaeba danowo wakeyawa gumbo Ayapan Iesu iviwa gumbe ageyau gumbe waya, “Poru opata waivi Iesu iviwa gumbe ne diruieni.” ");
INSERT INTO mti_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ju pirisi kokawa iviwa Seva usitainawa 7 mame meib aya. ");
INSERT INTO mti_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Sira Airapu kukaeba garawa gumbo wane, “Ne Iesu yaug anona sira Poru gaibu yaug anona, go ye bira?” ");
INSERT INTO mti_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Airapu kukaeba danave wakenewa pisiak egowo dauwane sira mu duwam yan emamne sira mu undag gudne. Meoya mu taibe aya siget boya gwe yan kweg kin tog dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Mame Ju ge Griisu igiyawa undag at Epesas apa vinemewa yaug anoya. Sira mu a gaibu ake Ayapan Iesu iviwa enagasiya. ");
INSERT INTO mti_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Sira anotumat aya igiyawa obiren uwak dividivi mu emewa taibe vesiya. ");
INSERT INTO mti_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Kwasisim dum emewa obiren bukaeba tam uwaya iyayapan yangowo okeriya. Mu garawa basiyag toborayawa garawa 50,000 siruva koin mina. ");
INSERT INTO mti_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Epin mamaib. Ayapan gaiyawa wateteyamiya koka ane sira me yusiwa kokavit aivi. ");
INSERT INTO mti_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Dividivi mame undag matadne onananewa, Guwawa Poru toyau wanne. Me gumbe me Masedonia ge Akaia yapave gaveyag uwag Jerusarem aitan oya anone. Me wane, “Ne namu Jerusarem anekna ivi Romu gaibu yautna.” ");
INSERT INTO mti_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Meoya me nauwawa emewa duwam Timoti ge Erastas tene Masedonia amiya. Poru me membo ande at Esia apa kusi pipi wakene. ");
INSERT INTO mti_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Me kumiwa apa ebu mame gumbe wayug wayug koka yaig yoine. ");
INSERT INTO mti_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Siruva gumbe warivi abnawa iviwa Demetrius wakene. Me siruva gumbe Arutemis god gweyawa kusikusiwa waramivi. Nanuwo wareme igiyawa anmaga kokavit munivi. ");
INSERT INTO mti_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sira me nanuwo wareme igiyawa ge nau desiroma igiyawa dirumne undagit desirom agoniyaya. Me wane, “Iyayapan undag. Ye anoyana nu nau mame gumbe anmaga kokavit tamete. ");
INSERT INTO mti_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ye yavene sira anoene. Apan mame Poru at Epesas danave mekut onan Koni Esia danave undag iyayapan obiren gae yusipam gumbe toyau munivi mu anopipanum aya. Me waivi, ‘God iyayapn nanuwo waremewa me god onan.’ ");
INSERT INTO mti_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu nau numawa waropiyatan ete sira iyayapan nau numawa oraimina sira den wape. Iyayapan god vesinawa kokawa Arutemis gweyawa matai den anope, sira Esia undag ge piyu undag god vesinawa eyawa meuma waiyeme, go eyawa meuma aiktan aivi.” ");
INSERT INTO mti_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Mu mame anoya mu danowo piripiriwane sira amatog kwaruveme, “Epesas igiyawa muma Arutemis me kokawa.” ");
INSERT INTO mti_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Sira gwetoimu undag wayug wayug aya, sira iyayapan mu Masedonia igiyawa Gaias ge Aristarukas yumamiya. Mu Poru gaibu gigemewa. Iyayapan undag kuiyowa desirom ane kae eme gweyawa danave igemat unigiya. ");
INSERT INTO mti_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Poru imive iyayapan danowo uniktan anoivi, megara aigo meuma me toboriya. ");
INSERT INTO mti_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Esia danave nau koka eme igiyawa mu Poru evebaiwa. Mu gae aug aiviwa menan barauk toborak waya, kae eme gweyawa danave den uniga. ");
INSERT INTO mti_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Daiboru danave anopipanum. Iyayapan obiren den yaug anoya divi oya agoniyaya, me oya mu gae kuiyawa ubeube kwaruwaya. ");
INSERT INTO mti_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ju igiyawa mu apan me Arekisanda namuwo itaraya. Sira iyayapan upeba gae watan oya me diya. Meoya me naniwa viyane iyayapan namuwo wasiwamtan watan anoivi. ");
INSERT INTO mti_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Megara mu yaug anoya me Ju abnawa, sira mu undag nouwa desirom ande kwaruveme kum koniwa duwam mina, “Epesas vesin goddeba numa me kokavitwa.” ");
INSERT INTO mti_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Gwetoim koka gigirum tete abnawa me iyayapan undag nouwa tobot mun wane, “Iyayapan neuma Epesas igiyawa. Gwetoimu Epesas me god vesinawa kokavitwa Arutemis ge me guwawa me kwimin apa aig onnewa amaraivi. Bira da den yaug anone? ");
INSERT INTO mti_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Mame natawa nu oma den ane topayata. Meoya ye noiwa iyaigisia, sira igemat den di aya. ");
INSERT INTO mti_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iyayapan mame ye tam oniyanawa, mu den aya temporu miyot ane, sira mu god vesinawa gae kukaeba den waya. ");
INSERT INTO mti_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Meoya Demetrius ge me owawaiwa nau desiroma emewa mu gunat gumbo atan ape ipewa, keptetan kumiwa wakene, sira at amareme igiyawa wakeya, meoya desirom desirom pui yutan oya keptetan arawa ampe. ");
INSERT INTO mti_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ye gae guniyap obiren ipewa, gwangwan daiboru kokawa gumbe gae wag yugeyau ape. ");
INSERT INTO mti_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Gare mame wayug wayug gaiyawa oya, asiwa apa natawa oraimina onan. Meoya wayug wayug mame oya, anten wakukam yempe go. Mame oya nu oma den ane ye waita yenta.” ");
INSERT INTO mti_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Meib wag daiboru onanane dauwag amiya. ");
INSERT INTO mti_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wayug wayug onanane, ivi Poru aigowawa oya auwane agoniyag yutuwa munne, sira dirumwane wakeyo, sira Masedonia oya kweg aine. ");
INSERT INTO mti_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Sira at me gumbe uwag aine, tatawaiwa gumbo gae dadi wag yutuwa munne. Meve Griisu uwane. ");
INSERT INTO mti_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Poru me apa dud duwamdesi wakene. Me wa gumbe Siria aitan aivi, megara me kumiwa apa Ju igiyawa me gumbe ano guwavewa eme, meoya anog namu Masedonia aikape meve sira taig aitan anone. ");
INSERT INTO mti_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Berea apan Sopateru me Pairas usiwa, ge Tesaronika apan duwam Aristarukas ge Sekandas, ge Derube apan Gaias, ge Timoti, sira Esia apan Titikas ge Tropimas mu Poru aigo waniya. ");
INSERT INTO mti_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mu namu wait amiya, sira at Troas apa nunan amareme. ");
INSERT INTO mti_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Iist Onan Bredi Buyunaeba onanane, sira nu wa gumbe at Piripi kwetune. Oiyat 5 onanane, meve at Troas apa undagit toboratune, sira oiyat 7 asime apa waketu. ");
INSERT INTO mti_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pura amatonewa apa, nu undagit agoniyatu bredi warensitan oya. Me kumiwa apa, Poru oiyat umae kwetan anone iyayapan gumbo gae waivi aram nub bagiwa uwane. ");
INSERT INTO mti_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Gwe egadodot siyawa danave dun dadi, me apa nu agoniyag gae watune. ");
INSERT INTO mti_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Apan mataiwa iviwa Yutikas gwe kwanogawa apa yan wakeivi. Me yangawa kub emne, sira Poru gae meuma yobutatae waivinewa, me kubvinne imiwa atataine, sira me gwe danawa egavewa duwamdesiyawa apa piyu egave uyug aigne. Wan auyawa, me wait boane. ");
INSERT INTO mti_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Poru aig onne, me egave toketam vinne, sira me enagadne, wane, “Den a aya. Me inaivi.” ");
INSERT INTO mti_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Me sira dog aine, bredi wasig nane, sira gae dirumivine wantene, meve kweg aine. ");
INSERT INTO mti_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iyayapan mu apan mataiwa me sira inainewa auwag gwe amiya, sira watmemeyam kokavit amunne. ");
INSERT INTO mti_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Meve nu namu wa danave dauwatune, Asos oya antune. Nu Asos apa Poru wa danave dauwatan oya anotune, kuiyawa Poru imive amave aitan. ");
INSERT INTO mti_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","At Asos apa Poru nutusa nunne, meve me wa danave entu, sira Mitrene antune. ");
INSERT INTO mti_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Meapa wa gumbe antune, wantene at Kiyosu poeman danave uwatune, sira oiyat dawa at Samos uwatune, sira oiyat dawa at Miretas uwatune. ");
INSERT INTO mti_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Poru imive Epesas atan kweg yapave togomiyane at asime uwatan oya anone, kuiyawa at Esia danave me kum waropiyatan den anone. Me imive Pentekost kumiwa danave at Jerusarem apa waketan anone, meoya me tatevit aivi. ");
INSERT INTO mti_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Poru me Miretas apa umum igiyawa tene Epesas amiya, sira Epesas siosi namuyoiyoi igiyawa munan auwane. ");
INSERT INTO mti_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Mu agoniyayawa, Poru dirum wane. “Ne at Esia uwana. Me kumiwa apa onne gare mame ne aninin ye gaibu kum evedni vineniwa, ye yaug anoyana. ");
INSERT INTO mti_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ne mokona kokavit gumbe sira it gaibu, sira edawai obiren me Ju igiyawa amaorot mumawa negiyawa danave ne Ayapan numa nauwawa ana. ");
INSERT INTO mti_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Dividivi undag me waita yeniyawa ne toyau yenna sira topai den ana. Iyayapan namuwa sira gwe gwe gumbe ne toyau yenna. ");
INSERT INTO mti_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ne Ju igiyawa ge Griisu igiyawa gumbo taibe wanawa, mu nonemagowa biroriyag God gumbe sira amtanit di sira Ayapan numawa Iesu gumbe anotumat atanit di. ");
INSERT INTO mti_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ne gare Guwanwa tunedne Jerusarem angeni. Ne den yaug anoeni divi ne gunap asimeve matatpe. ");
INSERT INTO mti_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Toimu desirom desirom danave Guwawa Iyakaisiyapama taibe toyau nedne. Ne yaug anonawa, murap gumbe tunektan ge dawai autan nenan amareme. ");
INSERT INTO mti_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Megara ne ebu angeniwa undag kintotna oma ape ipewa, sira nau neuma me Ayapan Iesu nednewa undag atna oma ape ipewa, ne inaiinai neuma oma ape waropiyatna. Nau neumawa me God ano oraiwa meuma gae oraiwa dirumpna taibe ape. ");
INSERT INTO mti_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Yauya. Ye yapeyap aneg God toimuwawa oya opata yenna. Megara gare mame di ne yaug anona ginanganwa sira den yauya. ");
INSERT INTO mti_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Meoya ne gare mapa wat kinieni. Iyayapan undag pui mumawa oya, me ne anoeniwa onan. ");
INSERT INTO mti_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Kuiyawa ne God anoano meuma undag yenan wana onanane. ");
INSERT INTO mti_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ye yembovit ge iyayapan yeuma undag oya amat munigimiya. Guwawa Iyakaisiyapama me yenan iyayapan namuyoiyoi mumawa ane. Kuiyawa me ye God siosi meuma me God diyawa meuma gumbe gwiruwadnewa amaratan oya. ");
INSERT INTO mti_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ne anoeniwa ye kwe yempnawa, mae urup muripama ye guniyap matai wakukam yempe. ");
INSERT INTO mti_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ye yapeyap upeba matai gae ugauga gumbe aigowawa upeba tamepe mumawa ape. ");
INSERT INTO mti_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Meoya yaukapa. Ne bairawan 3 danave oiyat ge aram evedni it gaibu ye desirom desirom toyau yeneni. Garawapa imug anoigimiya. ");
INSERT INTO mti_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Sira gare, God ge ano oraiwa meuma gaiyawa yenan naniyap baraueni. Gae meumawa oma ane yenan amat yempe sira koka aya, sira me oma ane iyayapan undag mu iyakaisi ayawa danave ye kwan matai auya. ");
INSERT INTO mti_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne iyayapan gooru ge siruva go wape mumawa den autan anona. ");
INSERT INTO mti_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ye yaug anoyana. Naninwa mame ne wakewake neuma oya sira ne gaibu wakeemewa muma oya nau wariya. ");
INSERT INTO mti_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ne dividivi undag ye toyau yeneni. Nu meib iyayapan mu yusiwa onanwa gumbo waita muntanit di. Sira nu imug anota Ayapan Iesu membovit wanewa gaiyawa, ‘Wantanwa me waribiya koka, sira autanwa me waribiya kusi.’” ");
INSERT INTO mti_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Poru meib wane onanane, sira konive yug iyayapan undag gaibu nun waya. ");
INSERT INTO mti_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Iyayapan undag iruwaya, sira Poru meyave yum obiren uwatoya. ");
INSERT INTO mti_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sira mu danadawai koka Poru gaiyawa gumbe auya, kuiyawa me wane, “Ye ginanganwa sira den di yauya.” Meve Poru wa autanwa oya mu me aigoyag amiya. ");
INSERT INTO mti_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nu mu kwemtu wa gumbe antu, sira at Kosu siwavit uwatu. Oiyat umae at Rodes uwatu, sira me apa at Patara antu. ");
INSERT INTO mti_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Me apa nu wa me at Penisia aitan aivi yautune, meoya wa me gerave dauwag antune. ");
INSERT INTO mti_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Koni pipi me apa Saipras yautu. Sira naniketaiwa apa me yaug, Siria oya sira yunat antune, sira at Taiya apa aigtune. Kuiyawa me apa wa numa tawara mumawa aiktanwa anoeme. ");
INSERT INTO mti_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nu aigowawa upeba yawamtu, me apa oiyat 7 waketu. Guwawa gumbe mu Poru dig waya at Jerusarem oya den di aipe. ");
INSERT INTO mti_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kum mame onananewa, nu at me apa kweg antune. Mu undag bivituiwa ge usitainawa gaibu agoniyag sira nu gaibu wemun antu gwetoimu daieve angek uwatu. Sira poeman visive uwag koninup yug nun watune. ");
INSERT INTO mti_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Meve nu garawa watu aisiyo. Sira wa danave dauwag unigtu, mu gwe muma taig amiya. ");
INSERT INTO mti_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nu at Taiya apa amatog wa gumbe onantu, nu Ptoremais uwatune. Me apa nu tatanaiwa baigan muntu, sira oiyat desiroi mu gaibu waketune. ");
INSERT INTO mti_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Oiyat umae me apa kwetu Sesariya uwatu. Me apa apan 7 gomiyamuniya mu danowo desirom me gae oraiwa opata veme igiyawa da Pirip wakene. Nu me gweyave waketu. ");
INSERT INTO mti_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Apan mame gwaitowaiwa otau 4 gaibu mu God gaiyawa vemewa. ");
INSERT INTO mti_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nu oiyat upeba mepe waketunewa, propeta iviwa Agabas Judia apa aig uwane. ");
INSERT INTO mti_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Me nu gunup uwane, sira Poru berip meuma aune. Me naniwa ge amawa berip gumbe tug wane, “Guwawa Iyakaisiyapama me waivinewa, ‘Ju igiyawa mu apan me berip mame gaibuwa mamaib Jerusarem apa tupe, sira mu me Ju onan igiyawa nanuwo baraupe.’” ");
INSERT INTO mti_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nu mame anotunewa, nu sira iyayapan upeba gaibu Poru gumbe nun watune Jerusarem den aipe. ");
INSERT INTO mti_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Meve Poru garawa wane, “Ye mamaib nenan iruvene sira nonenmagawa toenguriyana. Divi oya meib ene? Ne tamibarip ana Ayapan Iesu iviwa oya, Jerusarem danave murap gumbe den tunekpe go tonekpe boatna, me meiba ne gunap bainda.” ");
INSERT INTO mti_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Me nu gae numawa autan den anonewa, nu ditune, “Ayapan me anoiviwa ape,” meve nounuwa tobottu divi da den watu. ");
INSERT INTO mti_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kum mame onananewa, nu a atan oya tamibarip atune, sira Jerusarem dog antu. ");
INSERT INTO mti_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sesariya aigowawa upeba nu gaibu antune, sira Saipras apan Manason me aigowawa namuwa gumbe mu tam nuniya antune. Asimeve waketan anotune. ");
INSERT INTO mti_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusarem uwag tatanaiwa degadega gumbe baigan nuniya. ");
INSERT INTO mti_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Oiyat umae, Poru nu tam nunne sira Jemus oya amdau antune. Asimeve namuyoiyoi igiyawa undagit agoniyag wakeya. ");
INSERT INTO mti_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Poru mu baigan munne, sira me nauwawa gumbe God aninin Ju onan igiyawa danave anewa, desirom desirom amatog waivine. ");
INSERT INTO mti_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Mu mame anoya sira God gumbe watdega aya, sira Poru gumbe mamaib waya, “Tatunwa, ge yaug anoana, Ju igiyawa danave anotumat emewa 10,000 egave animpo mina dadi wakeya. Mu undag anoemewa Gwangwan me yaigipamit yumnasiemewa me kokawa di. ");
INSERT INTO mti_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Mu mamaib veme. Usitainawa gumbo kwapuwa den tuiyampe sira kuinui numa gumbe den wakeigimpe. Meib, ge Ju igiyawa mu Ju onan igiyawa danave wakeemewa Mosisi topai atan oya toyau munege. ");
INSERT INTO mti_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Meve nu aninin aton? Mu anoeme di ge uwana. ");
INSERT INTO mti_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Meoya nu dirutawa garawapa ge a. Nu gunup apan undag 4 mu God gumbe agi ayawa. ");
INSERT INTO mti_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mu tam aga, sira kwapugwa mu gaibu wat muina, sira kuiyowa gumawa tuipe oya garawa baraua. Ge meib a ipewa, iyayapan undag yaug anope mu genan oya anoemewa me natawa onan, ge gwangwan gumbe yaimoyai wakeegewa. ");
INSERT INTO mti_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ju onan igiyawa mu anotumat emewa gumbo nu wat kiniyatunewa mamaib. Mae puyowawa me god ugaugaeba gumbe waniyawa, sira diyawa, ge mae me meyakoniwa yuemewa, ge uinantaraki emewa mu topai atanit di. Nu munan wait gigirum tetune.” ");
INSERT INTO mti_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Meoya Poru iyayapan mu tamne, sira oiyat umae undagit wat muinamne sira temporu arawa danave unigiya, sira muinnewa kumiwa onananewa, apan desirom desirom oya puyo wanigimtanwa kumiwa dirumne. ");
INSERT INTO mti_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Megara oiyat 7 koni onanatan aiviwa, Ju igiyawa mu at Esia apa onamiyawa Poru temporu arawa danave wakene yauya, meoya mu iyayapan obiren dirum waya mu uwa danowa kwaiya. Mu nanuwo kwapive barauya, ");
INSERT INTO mti_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","sira kwaruwaya, “Isuraeru igiyawa, waita nuniya! Apan mame me at undag apa iyayapan undag toyau toyau munivi, iyayapan numawa, Gwangwan numawa ge at mame oya garadodot atan eme. Sira megiyave Griisu apan aug temporu arawa danave unig onne, sira at iyakaisiyapama mame miyot miyot ane.” ");
INSERT INTO mti_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Watavit mu yauya Epesas apan Tropimas gaibu Poru me gwetoimu danave wakeya. Meoya mu gwambe anoya Poru me aug temporu arawa danave unig onamiya. ");
INSERT INTO mti_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Sira meve gwetoimu undag ege aig waya, sira iyayapan Poru gumbe kintog amiya sira me yumiya, sira me aug temporu arawa daieve ororiyak amiya. Ankwin tatevit toboriya. ");
INSERT INTO mti_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sira mu me totanwa oya anog emewa, umum me mut namuyoiyoi abnawa kokawa gumbe uwane. At undag Jerusarem danave wayug wayug eme. ");
INSERT INTO mti_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Me tatevit mut igiyawa ge senturion tam munan amiya. Iyayapan mu mut namuyoiyoi abnawa kokawa ge mut igiyawa yawamiyawa Poru toemewa yankweya. ");
INSERT INTO mti_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mut namuyoiyoi abnawa kokawa me Poru gumbe uwag yumtune, sira aiyan murapeba sein duwam gumbe tutan dirum wane. Meve singui wanewa, Poru me bira sira me dimbae ane? ");
INSERT INTO mti_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Megara iyayapan obiren danowo upeba dividivi muma oya kwaruwaya, sira upeba dividivi muma oya kwaruwaya, meoya wayug wayug oya me oma den ane natawa yaug anone. Meoya mut namuyoiyoi abnawa kokawa me dirum wane Poru aug mut igiyawa gweyowa ampe. ");
INSERT INTO mti_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Poru tet apa uwaiviwa, mut igiyawa Poru painau wan auya, kuiyawa iyayapan dadi me totanwa oya eme. ");
INSERT INTO mti_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Kuiyawa iyayapan obiren amowo omome kwaruvemewa, “Me toya.” ");
INSERT INTO mti_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mu Poru aug mut igiyawa gweyowa danave unig amomewa, mut namuyoiyoi abnawa kokawa gumbe Poru wane, “Ne oma ane gae ge dirukna?” Mut igiyawa namuyoiyoi abnawa kokawa wane, “Ge gae Griik vege? ");
INSERT INTO mti_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ge Ejipt apan me wayug wayug namu aivi sira mut igiyawa 4,000 mina gaibu at inguiwa arawa a amiyawa?” ");
INSERT INTO mti_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Poru garawa wane, “Ne Ju abnawa me Sirisia danave Tarusas apan, sira ne toimu me abnawa di. Garawapa ne kwenega iyayapan gae dirumpna.” ");
INSERT INTO mti_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Mut namuyoiyoi abnawa kokawa dig wane gae wape, meve Poru tet egave yoine, sira iyayapan gumbo naniwa viyane. Sira mu undag noi iyadmusiawa, me gae Ibru gumbe gae mamaib dirum wane. ");
INSERT INTO mti_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Tatangwanen ge mamanaiwa. Gare mame yenan paparavintan eniwa watna ye anoya.” ");
INSERT INTO mti_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Poru gae Ibru gumbe waivinewa anoyawa, mu undagit di noi iyadmusia. Meoya Poru gae di yunad waivi. ");
INSERT INTO mti_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ne Ju abnawa me Sirisia danave Tarusas apa yainawa. Ne toimu me danave koka ana, sira Gamarieru ankwatave wagonaiwa Gwangwan mumawa oya yaigipamit gigirumawa tena. Ye undag gare enewa mina ne God oya kokavit anona. ");
INSERT INTO mti_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ne ebu mame gumbe edawai munna, murap gumbe apan vesin tuwamna, nog danave emena, sira upeba boriruwaya. ");
INSERT INTO mti_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mame oya, pirisi painauvitwa ge iyayapan koukawa daiboru koka muma mu nenan taibe wape. Ne gigirum mumawa me iyayapan mame tatawaiwa oya teyawa auna, sira Damaskas oya kweg anedna. Kuiyawa nu me apa wakeyawa igiyawa tuwam, mu tam Jerusarem ongetan sira ibnawa muntan oya. ");
INSERT INTO mti_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Meve angeniwa kum kuiyunup apa, ne Damaskas koni uwatan eniwa, tatevit eyawa kokavit gunap birorot yune esine. ");
INSERT INTO mti_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ne piyu egave aidnawa, noiwa anona nenan wane, ‘Sauru, Sauru, ge divi oya edawai negege?’ ");
INSERT INTO mti_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Meve ne garawa wana, ‘Ayapan, ge bira?’ Apan asime garawa wanewa, ‘Ne Nasaret apan Iesu me edawai negegewa.’ ");
INSERT INTO mti_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Iyayapan mu ne gunap wakeyawa eyawa asime yauya sira a aya, megara me noiwa me nenan waiviwa mu yaiyai den yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ne singui wana, ‘Ayapan, ne divi atna?’ Ayapan nenan wane, ‘Wan yoiya, Damaskas aga. Asime apa divi ge atanwa matai ge dirukpe.’ ");
INSERT INTO mti_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Megara eyawa yusiwa meuma oya yanganwa oma den ane yangut ana. Iyayapan mu ne gaibuwa naninap aug Damaskas unigiya. ");
INSERT INTO mti_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Me apa apan da iviwa Ananias wakene. Me Gwangwan numa gumbe anotumat oraiwa aiviwa abnawa, sira me me apa wakeemewa Ju igiyawa undag me apa wakeemewa danowo mu menan ebnotu eme. ");
INSERT INTO mti_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananias uwag ne megiyanap yoig wane, ‘Tatan Sauru, oma ane ge yawa.’ Sira me koniwa apa ne oma ane apan me yauna. ");
INSERT INTO mti_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Me mamaib wane, ‘Isimuranaiwa God mumawa me genan wat kiniyane, sira me ano meuma yaug anoa, sira Ayapan oraiwa yawa, sira gae meuma noive waiviwa anoa. ");
INSERT INTO mti_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ge yangagap yaug anoanawa a, sira iyayapan undag gumbo ge divi yawanawa sira anoanawa diruma anope. ");
INSERT INTO mti_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Divi oya topai ege? Wan yoiya. Me iviwa gumbe babataito a, sira kukaeba geuma muina.’ ");
INSERT INTO mti_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mamaib ne Jerusarem sira taig anedna, sira temporu arawa danave nun veniwa, ne uyavi mina vinna, ");
INSERT INTO mti_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","sira Ayapan yauna. Ayapan gae waivi, ‘Tate Jerusarem gare mame di kweg aga, kuiyawa nenan oya taibe wanawa mu den anog aupe.’ ");
INSERT INTO mti_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Meve ne garawa wana, ‘Ayapan, mu yaug anoya ne sinagogu dada dana anotumat genan eme igiyawa tam nog danave tena, sira murap gumbe gudna. ");
INSERT INTO mti_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sira Stepen me genan boinewa diyawa aignewa, ne me apa wakena, sira yutuwa munna, sira me toeme igiyawa wape muma amareni.’ ");
INSERT INTO mti_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Meve Ayapan ne didneg wane, ‘Aga, ne ge baraugentna aramawa Ju onan igiyawa gumbo.’” ");
INSERT INTO mti_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Iyayapan Poru gae wag mame waiviwa anoeme, megara gare mame kwaruwaya, “Apan mame minawa piyu egave atan auya. Me tota di boipe.” ");
INSERT INTO mti_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Meve iyayapan boboi ge kwaruwaya, wape muma painau emiya, sira atapupu owan kwiminau emiya. ");
INSERT INTO mti_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Meoya mut namuyoiyoi abnawa kokawa dirumnewa Poru aug mut igiyawa gweyowa unig ampe. Sira me yaug anotan anoivi divi oya iyayapan kwat Poru gumbe mamaib veme. Meoya me dirumne me murap gumbe tog singui ape. ");
INSERT INTO mti_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mu Poru murap gumbe me totanwa oya tuyawa, Poru senturion me asime yokeivinewa dig wane, “Keptete den baraune sira Romu sinsin apan murap gumbe tope, me bainda go?” ");
INSERT INTO mti_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Senturion mame anonewa, me mut namuyoiyoi abnawa kokawa menan aine umum dine, “Ge divi a? Apan asime me Romu sinsin apan.” ");
INSERT INTO mti_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mut namuyoiyoi abnawa kokawa me Poru menan aine singui ane, “Ne didnega, ge Romu sinsin apan?” Poru wane, “E, ne meme.” ");
INSERT INTO mti_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Meve mut namuyoiyoi abnawa kokawa wane, “Ne sinsin apan atan oya anmaga koka barauna.” Meve Poru wane, “Ne Romu sinsin danave yoina.” ");
INSERT INTO mti_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Meoya iyayapan mu Poru gumbe singui watan emewa, tatevit me gumbe atan siririyag amiya. Sira mut namuyoiyoi abnawa kokawa yaug anone Poru me Romu sinsin apan, me a ane kuiyawa murap sein gumbe Poru tuya. ");
INSERT INTO mti_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Oiyat umae, mut namuyoiyoi abnawa kokawa me divi oya Ju igiyawa mu Poru gumbe keptete barautan oya anotan anoivi, meoya me dirum wane Poru aiyan murapeba sein gumbe tuyanawa atan vesiya. Sira me dirum wane pirisi koukawa ge Daiboru Painauvitwa igiyawa undag agoniyape, Poru aug amiya, sira namuwo yoine. ");
INSERT INTO mti_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Meve Poru Daiboru Painauvitwa tem yawam dirum wane, “Owanaiwa, ne gare mame God namive anog vinan ongeniwa imug imug oraiwa gumbe.” ");
INSERT INTO mti_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sira pirisi painauvitwa Ananias me iyayapan mu Poru megiyave yoiemewa gumbo dirum wanewa, Poru noive toya. ");
INSERT INTO mti_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Me kumiwa apa Poru me gumbe wane, “Ge bogigi me pupuyu wadnewa! God matai ge towakpe. Ge Gwangwan gumbe matai pui yunettan arawa apa wakeege, megara ge Gwangwan togomege sira mu ne tonektan oya dirumana?” ");
INSERT INTO mti_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Meve iyayapan mu megiyave yoiemewa waya, “God pirisi painauvitwa gumbe ge gae gwambe vege?” ");
INSERT INTO mti_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Meoya Poru garawa wane, “Owanaiwa, ne den yaug anona me pirisi painauvitwa. Baiboru tenewa, ‘Iyayapan namuyoiyoi abnawa muma gumbo gae gwambe den wa.’” ");
INSERT INTO mti_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Megara Poru yaug anone iyayapan upeba mu Sadusi igiyawa upeba mu Parisi igiyawa, Daiboru Painauvitwa danave kwaruwane, “Owanaiwa, ne Parisi abnawa sira Parisi usiwa. Mu ne pui yunegeme boriruwayawa mu matai sira inaig yoipewa anoetewa oya.” ");
INSERT INTO mti_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Me mame wanewa, Parisi igiyawa ge Sadusi igiyawa yapowo garadi aya. Sira Daiboru Painauvitwa me kuiya 2 togomiyaya. ");
INSERT INTO mti_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Kuiyawa Sadusi igiyawa wayawa, sira inaig yoitanwa onan, aneya den wakene, sira guwawa den wakene. Megara Parisi igiyawa wayawa mame undag wakeya. ");
INSERT INTO mti_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wayug wayug koka aivi sira Gwangwan toewanewan upeba mu Parisi igiyawa muma wan yoiya sira gae yaigipam dirumeme waya, “Nu oma den ane yautune dividivi kukaeba da apan mame gumbe. Anten guwawa go aneya me gumbe wane go?” ");
INSERT INTO mti_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Garadi kokavit emewa, mut namuyoiyoi abnawa kokawa me Poru gumbe danadawai aune, kuiyawa mu Poru matai tog kesia kesia ape anoivi. Me mut igiyawa dirum wane aig Poru yutuwa gumbe aug mut igiyawa gweyowa ampe. ");
INSERT INTO mti_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Aram me danave Ayapan Poru megiyave yoig wane, “Yusiyusi a. Ge Jerusarem apa nenan oya gae wana. Meib ge Romu danave gaibu gae wa.” ");
INSERT INTO mti_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Wantenewa, Ju igiyawa agoniyaya sira agi wayawa, namu Poru tope boipe, ivi mu nakwai ge yoi nape. ");
INSERT INTO mti_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kigemuk mame wayawa me iyayapan 40 sira egave mina. ");
INSERT INTO mti_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mu pirisi koukawa ge iyayapan namu yoiyoi igiyawa gumbo amiya waya, “Nu agi yusipamit watunewa, namu nu Poru tota boipe ivi divi da nata. ");
INSERT INTO mti_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Gare mame ye sira Daiboru Painauvitwa gaibu ugauga ag, mut namuyoiyoi abnawa kokawa gumbe mamaib nun waya, nu Poru sira yautan anoete meoya Poru aug nunan onampe. Nu tamibarip atune Poru asime uwaigimpewa nu me tota boipe.” ");
INSERT INTO mti_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Megara Poru yogiyawa usiwa kigemuk mame anonewa, me mut igiyawa gweyowa gumbe aig Poru dine. ");
INSERT INTO mti_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Meve Poru me senturion da auwag wane, “Garawapa apan mataiwa mame mut namuyoiyoi abnawa kokawa gumbe aug aga. Me umum da gaibu me ditan.” ");
INSERT INTO mti_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Senturion me apan mame aug mut namuyoiyoi abnawa kokawa gumbe aine sira wane, “Nog abnawa Poru nenan auwane sira nun wanewa, apan mataiwa mame umum geumawa me gumbe wakene, meoya me genan ompe.” ");
INSERT INTO mti_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Mut namuyoiyoi abnawa kokawa nanive aug atan aine sira singui ane, “Divi ge didnektan anoege?” ");
INSERT INTO mti_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Me garawa wane, “Ju igiyawa mamaib ung waya. Mu Poru gumbe yaug anotan oya ugauga ape. Sira genan nun wapewa ge umae Poru aug Daiboru Painauvitwa gumbe onaga. ");
INSERT INTO mti_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Garawapa gae muma den auwa. Kuiyawa iyayapan 40 egave mina agi wayawa, namu Poru tope boipe, ivi mu nakwai ge yoi nape. Mu menan amareme. Gare mame di mu tamibarip aya onanane, mu amareme ge nun muma autan oya.” ");
INSERT INTO mti_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Meve mut namuyoiyoi abnawa kokawa dig wane, “Iyayapan da den diruma ge mame did neganawa,” sira apan mataiwa kwene aine. ");
INSERT INTO mti_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sira me senturion duwam munan auwane sira dirumne, “Mut igiyawa amowo amomewa 200, mut igiyawa mu mae osi egave amomewa 70, sira apan mut tamiyawa 200 tamiya tamibarip aya, aram gare kum koniwa 9 aupewa at Sesariya ampe oya.” ");
INSERT INTO mti_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Sira amaraiviwa kokawa Perikus gumbe Poru yaiyai me aug ampe oya, mae osi upeba Poru waniya egave aitan oya. ");
INSERT INTO mti_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Sira me mamaib gigirum tene. ");
INSERT INTO mti_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Kraudias Raisias, Amaraiviwa koka numawa Perikus gaun neuma ge gungap. ");
INSERT INTO mti_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ju igiyawa mu apan mame aug totan emewa, ne yaug anona me Romu sinsin. Meoya ne mut igiyawa neuma tam onedna, sira menan papara vinna. ");
INSERT INTO mti_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ne yaug anotan anona divi oya mu me oya pui yuya, meoya ne wana me Ju Daiboru Painauvitwa muma gumbe aug amiya. ");
INSERT INTO mti_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Sira yaug anona mu me oya pui yuyawa, me singui me Ju Gwangwan mumawa gumbe. Megara yaug anona me kukaeba me gumbe onan bo atanwa go nog aitanwa oya. ");
INSERT INTO mti_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Megara ne apan mame oya kigemuk umumawa auna. Meoya ne tatevit genan barauna onne. Sira ne iyayapan mu me oya pui yuemewa gumbo dirum wanawa, ge namugap ye pui me yuya.” ");
INSERT INTO mti_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Meve me dirum wanewa mina, mut igiyawa mu Poru aug at Antipatris oya arampuna amiya. ");
INSERT INTO mti_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Oiyat umae, mut igiyawa mae osi egave amomewa kwemiya Poru gaibu amtan oya, sira mut igiyawa amowo mut gweyawa taig amiya. ");
INSERT INTO mti_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Mut igiyawa mae osi egave amomewa at Sesariya uwaya, amaraiviwa kokawa gigirum waniya, sira Poru nanive barauya. ");
INSERT INTO mti_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Amaraiviwa kokawa me gigirum basianewa, Poru gumbe singui ane me at ambuwa toimuwawa abnawa. Sira me yaug anone Poru me at Sirisia apan, ");
INSERT INTO mti_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","sira wane, “Namu iyayapan mu ge oya pui yuwagemewa onampe, ivi ne singui gentna.” Sira dirum wanewa Poru yaiyai amarape Erod gweyawa kokawa danave. ");
INSERT INTO mti_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sira oiyat 5 onananeve, pirisi painauvitwa Ananias me iyayapan namuyoiyoi igiyawa ge papara aivi abnawa iviwa Teruturas gaibu Sesariya aig amiya. Meve mu namuyoiyoi abnawa kokawa namive Poru gumbe pui yuya. ");
INSERT INTO mti_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Meve Poru auwaya unignewa Teruturas amatog pui yuwanne wane, “Kokawa numa Perikus, ge gungap nu degadega ete, ge ankwatagap yum oraimina auete, sira ge anoano oraiwa geuma gumbe at mame danave yaiyai oraimina biroriyaivi. ");
INSERT INTO mti_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nu dividivi oraiwa mame at ampa ampa danave yautu, meoya gaun ge gungap vete. ");
INSERT INTO mti_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Gare ge gungap ne den ibnawa gentna, meoya ne gae pipi mame dirukna. Garawapa gae neuma anoa ebnotu geuma gumbe. ");
INSERT INTO mti_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Apan mame me yuwat iviwa Pesto mina, sira Ju igiyawa mu piyu mame undag danave wakeemewa mu yapowo waivi mut darat waivi. Me namuyoiyoi abnawa Nasaret kuiya da danave. ");
INSERT INTO mti_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Apan mame me temporu miyot miyot atan aivi, meoya nu me yumtune. ");
INSERT INTO mti_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","(-) ");
INSERT INTO mti_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Apan koka numawa Perikus, ge gembovit dividivi mame yobag yawawa, ge matai yaug anoa divi oya nu me diyag vete.” ");
INSERT INTO mti_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ju igiyawa gaibu ung waya me anoano meuma oya, sira waya undag mame natawa di. ");
INSERT INTO mti_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Meve amaraiviwa kokawa me Poru gumbe naniwa yune sira wane Poru gae watan oya. Meoya Poru garawa wane, “Ne anona apan koka numawa ge bairawan dadi iyayapan oya keptete ege abnawa, meoya ne degadega gumbe nembo oya papara vintna. ");
INSERT INTO mti_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ge yaiyai yobawa yaug anoa, ne God waiyatan oya Jerusarem dog anedna, sira me apa onnewa gare oiyat 12 mina onanaivi. ");
INSERT INTO mti_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Sira bira da den yaunedne, temporu arawa danave, sinagogu danave, gwetoimu koka danave ne bira da gaibu diguragut etewa, sira iyayapan gaibu nu wayug wayug etewa. ");
INSERT INTO mti_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Mu pui yunegemewa oya mu matai natawa da oma den ane toyau gempe. ");
INSERT INTO mti_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Megara ne namugap taibe watna, epin me Ju igiyawa wayawa anotumat ugaugaeba gumbe ne isimuranaiwa God numawa waiyaeni. Dividivi undag me Gwangwan ge Propeta bukaeba danave tenewa ne anotumat eni. ");
INSERT INTO mti_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Sira iyayapan mame gaibu anoeme mina, ne imug imug God gumbe anoeniwa, apan oraiwa ge apan kukaeba matai bo gumbe sira inaimutpe. ");
INSERT INTO mti_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Meoya ne kum evedni oraivitwa neuma eni, God ge iyayapan namuwo mu pui den yunekpe. ");
INSERT INTO mti_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Namu bairawan dadi onanane, ivi ne evenaiwa gumbo dividivi muntan oya ge puyo barautan oya sira taig onedna. ");
INSERT INTO mti_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Puyo asime oya, nenan muinne sira ne temporu arawa danave unig wakenawa, mu ne yaunegiya. Megara iyayapan dadi den wakeya sira garawa den eme. Ju igiyawa upeba mu Esia apa onamiyawa mu mukut wakeya. ");
INSERT INTO mti_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mu anoano muma oya pui yunektan anoeme ipewa, mu namugap onam ne pui yunekpe di. ");
INSERT INTO mti_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Go, iyayapan mu mapa wakeemewa kwemna wape divi kukaeba neuma yauyawa ne Daiboru Painauvitwa namive yoinawa kumiwa apa. ");
INSERT INTO mti_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ne yapowo yoinawa, ne divi desirom kwaruwanawa, ‘Ye gare mame pui yunegenewa boriruwayawa sira inaimut yoipe oya.’” ");
INSERT INTO mti_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Megara Perikus Ebu mame oya anoano kokawa yaug anone, meoya me wane, “Mut namuyoiyoi abnawa kokawa Raisias aig ompewa, kukaeba yeuma mame waribiyata,” sira keptete kumiwa utuban barautan oya wane. ");
INSERT INTO mti_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Meve me senturion gumbe dig wanewa, Poru aug danave yangut yaiyai yavigimpe. Megara Poru ui onan kwepe wakeigimpe, meve owawaiwa oma ane Poru me amaraigimpe. ");
INSERT INTO mti_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Oiyat upeba onanane, Perikus me biviwa Drusira me Ju vesinawa aug onne, sira Poru auwane. Meve me Keriso Iesu gumbe anotumat aiviwa gaiyawa wane anoya. ");
INSERT INTO mti_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Megara Poru dirum wane oraiminawa ge numbo amat numawa ge pui yutanwa kumiwa oniviwa oya, meoya Perikus a ag wane, “Gare mame ge oma ane gwe sira taig aga. Kum da ne genan auwatna.” ");
INSERT INTO mti_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kum desirom me apa, me anoiviwa Poru gumbe anmagawa guwave aupe, meoya me Poru oya kum dada menan auwane me gaibu gae waya. ");
INSERT INTO mti_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Bairawan duwam onananewa, Porukias Pestas me Perikus nau meuma aune. Megara Perikus imive Ju igiyawa degadega atan oya me Poru kwene nog dana ande wakene. ");
INSERT INTO mti_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestas me at meuma amaratan oya uwane, sira oiyat duwamdesi onananewa Sesariya apa Jerusarem dog aine. ");
INSERT INTO mti_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Meve pirisi koukawa ge Ju namuyoiyoi igiyawa mu onamiya Poru pui yuya. ");
INSERT INTO mti_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Mu nun wayawa Pestas me baigan gumbe munan atan oya, sira nun wayawa Poru aug Jerusarem onampe. Kuiyawa mu iyayapan upeba dirumiya ebu taibe Poru amareme me totan oya. ");
INSERT INTO mti_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Megara Pestas garawa wane, “Poru me Sesariya apa nog dana wakene, sira ne gare mame di taig anekna. ");
INSERT INTO mti_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Meoya me gumbe dividivi kukaeba wakepewa, namuyoiyoi igiyawa yeuma ne gaibu aig anta, sira me gumbe pui yuya.” ");
INSERT INTO mti_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestas oiyat dawa 8 go 10 mina mu gaibu wakeya, Sesariya aig aine. Oiyat umae, kepteiviwa danave me arawa egave wakene, me wane Poru aug unig onampe. ");
INSERT INTO mti_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Poru uwanewa, Ju igiyawa mu Jerusarem apa aig onamiyawa Poru gumbe birorot yoiya, sira amatog kukaeba koka meuma oya dig waya, megara oma den ane yaiyai natawa watkiniyaya. ");
INSERT INTO mti_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Megara Poru membovit oya papara vin wane, “Ne divi da kukaeba den ana Ju igiyawa Gwangwan muma gumbe, go temporu gumbe, go Siisa gumbe.” ");
INSERT INTO mti_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Megara Pestas anoiviwa Ju igiyawa degadega ape, meoya singui Poru gumbe wane, “Ge imugap Jerusarem agetan anoege dividivi mame oya namnap kepteya?” ");
INSERT INTO mti_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Meve Poru garawa wane, “Ne Siisa keptete meuma namive yoieniwa, ne mapa keptete atan eni oraimina. Ge gembo yaug anoana, ne Ju igiyawa gumbo kukaeba da den ana. ");
INSERT INTO mti_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kukaeba da oya boatan apopowa, ne a den atna ne bo atna. Megara dividivi me iyayapan mame pui yunegemewa natawa onan. Bira da oma den ane nenan aug nanuwo baraupe. Ne Siisa gumbe keptete atan oya nun watna.” ");
INSERT INTO mti_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Me kumive Pestas gae waya iyayapan mu wakeyawa gaibu, sira garawa wane, “Ge Siisa gumbe keptete atan oya nun wanawa, Siisa gumbe aga.” ");
INSERT INTO mti_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Oiyat dawa upeba onanane, kin Agrippa ge Berunike Pestas ebnotu wantan oya Sesariya uwaya. ");
INSERT INTO mti_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mu me apa kum dadi wakeyawa, Pestas kin gumbe Poru wakeiviwa oya dine, “Apan da nog danave wakene me Perikus kwenewa. ");
INSERT INTO mti_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ne Jerusarem anednawa, pirisi ge Ju namuyoiyoi igiyawa ne did negiya sira nun waya apan mame me kukaeba oya dima yuya. ");
INSERT INTO mti_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Me kumiwa apa, ne garawa dirum wana, ‘Bira da me kukaeba iyayapan pui yupewa, me oma ane pui yueme igiyawa namuwo membo oya parau vimpe. Parau den vimpe ipewa, me matai boatan den baraupe aipe. Me Romu gwangwan muma wanewa.’ ");
INSERT INTO mti_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Meoya iyayapan mu kukaeba meuma pui yuemewa mapa agoniyayawa, ne kum den waropiyana oiyat umae tatevit keptete arawa egave wakena, sira apan asime kwena dauwag onne. ");
INSERT INTO mti_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Iyayapan mu kukaeba meuma pui yuemewa wan yoiya, megara kukaeba meuma anoeniwa oya mu desirom da den waya. ");
INSERT INTO mti_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Dividivi mumawa me gae yugeyau wayawa me anotumat mumawa oya, sira apan iviwa Iesu me boinewa oya. Poru wane Iesu sira inaig wakene. ");
INSERT INTO mti_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ne den di yaug anona dividivi mame aninin yum tam atna, meoya menan singui ana, ‘Ge imugap Jerusarem aga, sira dividivi mame oya keptete atan anoege?’ ");
INSERT INTO mti_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Megara Poru imive wakenewa, namu me aug amarape, ivi Romu ayapaneba me keptete danave gae meuma wape. Meoya ne dirum wana namu aug amarape, ivi Siisa gumbe me aug ampe.” ");
INSERT INTO mti_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Meve Agrippa me Pestas gumbe wane, “Ne anoeniwa apan mame membovit gaiyawa anotna.” Pestas garawa wane, “Umaipa ge gae meuma anoa.” ");
INSERT INTO mti_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Meoya oiyat umae, Agrippa ge Berunike mu ben muma oraivitwa wat uwaya, sira mu gae anoemewa gweyawa unigiya mut igiyawa namuyoiyoi koukawa ge toimu namuyoiyoi igiyawa gaibu. Meve Pestas dirum wanewa, Poru aug unig onamiya. ");
INSERT INTO mti_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Sira Pestas wane, “Kin Agrippa ge iyayapan undag mapa waketuwa, yauya. Ju igiyawa undag Jerusarem danave ge mapa Sesariya danave kwaruwaya me tope boitan di, sira kukaeba meuma nenan vemewa me apan mame oya. ");
INSERT INTO mti_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ne anoeniwa me bo atan oya divi da den ane. Megara me membovit Romu ayapaneba gumbe keptete atan wane, meoya ne yaug anonawa me barautna asime aipe. ");
INSERT INTO mti_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Megara Kokavitwa neuma gumbe me oya tetan oya divi da natawa ne gunap onan. Meoya ye undag namuyap, sira kin Agrippa, ge genan oya aug onedna. Gae meuma yaug anotawa, ivi gigirum tetan oya divi da autnave. ");
INSERT INTO mti_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Kuiyawa nog abnawa barautan aipe oya kukaeba meuma dimbae gigirum den tetnawa, me oraimina onan.” ");
INSERT INTO mti_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Meve Agrippa me Poru gumbe wane, “Ge oma ane gae wa gembo oya.” Meoya Poru naniwa dimne membovit oya amatog papara vinne. ");
INSERT INTO mti_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Kin Agrippa. Ne degadega eni, kuiyawa ne gare mame oma ane nembo oya papara vintna divi da undag me Ju igiyawa pui yunegemewa oya. ");
INSERT INTO mti_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Kuiyawa me genan, Ju igiyawa anoano muma ge ibnawa muma oya ge yaiyai yaug anoana. Garawapa nenan naunagwa taiya ebnotu gumbe. ");
INSERT INTO mti_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Gare mame di gae watna. Ne aninin vinan namuiren iyayapan neuma danowo wakeeniwa, sira Jerusarem danave ne ud toranap onne gare mame aninin wakeeniwa Ju igiyawa undag yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ne namuiren onne gare mame yaunek anoya, meoya mu oma ane nenan oya gae wape. Dam numawa me yaigipamitwa anotumat numawa danave, sira ne Parisi abnawa ag wakena onne gare mame. ");
INSERT INTO mti_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Sira gare mame, keptetan oya yoinawa me owanowan me God numawa me isimuranaiwa gumbo agiyawa anewa oya. ");
INSERT INTO mti_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Dam 12 numawa mu aram ge kum God gumbe nau yusipamit eme. Mu imug imug muma agi natawa yautan ge autan anoeme. Kin neuma, ne anoeniwa mame gumbe Ju igiyawa mu nenan pui yunegeme. ");
INSERT INTO mti_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","God oma ane boriruwayawa sira wape inai mutpe, divi oya ye me anotumat den ene? ");
INSERT INTO mti_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Watavit ne gaibu anona ne Nasaret apan Iesu iviwa gumbe anavi yusipamit atanit di. ");
INSERT INTO mti_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ne Jerusarem danave meib ana di. Pirisi koukawa mu yusiwa negiya, iyayapan iyakaisi dadi nog danave tena, mu guremewa ne ung wana. ");
INSERT INTO mti_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Sira ne kum evedni sinagogu dada gumbe angeni mu nau ibnapam atan oya. Ne ayamuneni gae kukaeba wape. Ne ginanganwa pipau toivine, sira toimu upeba apa mu edawai muntan oya anedna. ");
INSERT INTO mti_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Mamaib pirisi koukawa mu yusiwa negiya, sira Damaskas oya angeniwa, ");
INSERT INTO mti_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","epin taibe kum kuiyunup apa, kin neuma, ne yauna eyawa me kokavit kum eyawa mina onan kwimin apa aig onne. Me ne ge ne gaibu angetewa igiyawa gunup birorot yune. ");
INSERT INTO mti_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nu undag piyu egave petat aiktu, sira ne noiwa nenan gae Ibru gumbe waivine anona, ‘Sauru Sauru, divi oya ne edawai negege? Yoma gaut ganaganapam gumbe amagap toawa, me ge gungap dawaiba.’ ");
INSERT INTO mti_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ne wana, ‘Ayapan, ge bira?’ Me garawa wane, ‘Ne Iesu me ge edawai negegewa. ");
INSERT INTO mti_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kuiyagwa enagata, sira amagap wan yoiya. Ne genan uwanawa me ge nau neuma atan abnawa a sira yangagap yawanawa watan abnawa a. Ne ge kini ageneni. Ge diruma divi da ge yawanawa sira divi da ne matai genan uwag toyau gentnawa. ");
INSERT INTO mti_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ne matai genan parau vintna iyayapan geuma ge Ju onan igiyawa danowo, meve munan ne baraugeneni aga. ");
INSERT INTO mti_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ne mu yangowa muma watapna, sira mu sisip gumbe te muntna. Seitan yusiwa gumbe biroriyag God gumbe onampe. Anotumat gunap eme igiyawa, kukaeba muma anog yankwetna, sira mu God toimuwawa aupe iyayapan iyakaisi danowo.’ ");
INSERT INTO mti_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Meoya kin Agrippa, ne ugegeyawa kwiminauwa gumbe ebnotu topai den ana. ");
INSERT INTO mti_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ne namu Damaskas igiyawa gumbo opata wana, sira ivi Jerusarem igiyawa, Judia danave undag sira Ju onan igiyawa gumbo gaibu. Ne opata wanawa mu nonemagowa biroriyag God gumbe sira amtanit di, sira mu nonemagowa biroriyayawa toyau muntanit di emewa gumbe. ");
INSERT INTO mti_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Meoya Ju igiyawa temporu arawa danave ne aunegiya, sira ageyau eme tonektanwa oya eme. ");
INSERT INTO mti_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Sira kum me apa on gare mame uwane. God waitawaita nedne yusiyusi yoina, sira kusikusiwa ge koukawa gumbo ne gae dirum wana. Propeta igiyawa ge Mosisi waya aninin matai veniyapewa. Ne me mekut dirum wana. Divi upeba da den dirum wana. ");
INSERT INTO mti_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mu wayawa, Keriso edawai aupe, sira bo gumbe inaipe, meve iyayapan meuma ge Ju onan igiyawa gumbo namuiren eyawa oya dirumpe.” ");
INSERT INTO mti_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Poru meib parau viniviwa, Pestas noiwa kokavit wane, “Poru, ge kuiyagwa kukaine. Ge anoano kokavit anoana, meoya ge kuiyagwa kukaine.” ");
INSERT INTO mti_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Meve Poru mamaib wane, “Kokawa neuma Pestas, ne kuiyanwa yaiyai nau aivi. Ne gae natawa di veni. ");
INSERT INTO mti_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kin dividivi mame yaiyai yaug anone, kin gumbe ne siwavit gae veni. Dividivi mame nib yuniwa apa den pawane, meoya ne anoeni dividivi undag mame kin gumbe guwave da onan. ");
INSERT INTO mti_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kin Agrippa, ge propeta gumbo anotumat ege? Ne anoeniwa ge anotumat ege.” ");
INSERT INTO mti_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Sira Agrippa Poru dine, “Kum pipi danave, ne Kristian atan oya ge yusiyusi ege.” ");
INSERT INTO mti_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Poru garawa wane, “Kum pipi go yobe me divi da onan. Ne imunap gekut oya onan, megara iyayapan undag mu gae neuma gare mame anoemewa ne minan ape, megara murap mame tunegiyawa oya den anoeni.” ");
INSERT INTO mti_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Me apa, kin ge namuyoiyoi kokawa ge Berunike sira iyayapan upeba mu asime wakeyawa wan yoiya. ");
INSERT INTO mti_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Mu dauwag taibe amiyawa, gae garawa veme, “Apan asime me bo atanwa go nog aitan oya divi da den aivi.” ");
INSERT INTO mti_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Sira meve Agrippa me Pestas dine, “Apan mame Siisa gumbe keptete oya nun den wanewa, ne anoeni me taibe dauwag aipa.” ");
INSERT INTO mti_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Gare mu yaug anoyawa, nu wa gumbe Itari angetan ete. Poru ge nog igiyawa upeba mu senturion iviwa Jurias nanive teya. Me Romu kokavitwa mut igiyawa meuma danave wakenewa. ");
INSERT INTO mti_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nu Adramaitium wa meuma danave dauwag kweg antu. Wa mame at toimu ampa ampa Esia danave unig dauwag aitan aiviwa. At Tesaronika danave Masedonia apan Aristarukas me nu gaibu. ");
INSERT INTO mti_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Oiyat umae at Saidon uniktu. Jurias baigan gumbe Poru amaraivi, sira ung wane Poru me owawaiwa oya aipe baigan gumbe ape. ");
INSERT INTO mti_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Me apa nu dauwag antu, megara taig gud nunnewa, Saipras megiyave antu. ");
INSERT INTO mti_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sira Sirisia ge Pampiria poeman danave antune, sira at Maira toimu Rusia danave uniktu. ");
INSERT INTO mti_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Asimeve Arekisandria wa meuma me Itari aitan aiviwa wakene, senturion me yaune, sira wane nu wa asime dauwatu. ");
INSERT INTO mti_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kum upeba danave wa ekekenut aivine. Sira nu at Kunidas poeman meuma yusiyusi ag uwatune. Megara taig koka anewa nu oma den ane sira angetan, meoya nu at Kurete me poeman Sarumone apa wakenewa visive antu. ");
INSERT INTO mti_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Poeman visive angete, yusiyusi ag angek at iviwa waya wa yoiviwa arawa oraiwa uniktu. At me megiyave, at Rasea gwetoimu wakene. ");
INSERT INTO mti_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Kum koka waropiyatu, sira kwit kumiwa wait onanane, meoya wa gumbe angetanwa me kukaeba, Poru dirum wane, ");
INSERT INTO mti_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Iyayapan neuma, ne anoeniwa a numawa mame danave kukaeba pawatan aivi, tawara ge wa mame mukut onan inaiinai numawa gaibu kukaeba uwanuntan aivi.” ");
INSERT INTO mti_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Megara senturion me wa yumnasiviwa abnawa ge wa mamawa anotumat yusipamit ane. Poru wanewa me anotumat yusipamit den ane. ");
INSERT INTO mti_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Sira wa yoiviwa arawa mame me bainda onan taig kumiwa danave waketanwa oya, meoya iyayapan dadi wayawa maib, mame kweta, sira oma ape ipewa Kurete danave wa yoivi arawa Penikus anta—me sausuwest ge noosuwest gumbe wakenewa anta, sira taig kumiwa at me apa waketa. ");
INSERT INTO mti_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Sira taig memeyaivinewa sausu apa uwanewa, iyayapan kum mame di apa wa anika ororiyaya dauwane, at Kurete ginayapawa visive angete. ");
INSERT INTO mti_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Megara kum koni yobe onan, taig koka iviwa Yurokraidon me tui ge pawawa apa aig onne. ");
INSERT INTO mti_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Wa taig yumnadnewa, oma den ane wa aine taig manne. Meoya wa kwetune ingan aivi. ");
INSERT INTO mti_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Megara wa me ginayapawa kusi iviwa Kauda megiyave aivi, meoya nu oma ane yusiyusi ag wa kusi yumnattu. ");
INSERT INTO mti_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nu wa kusi enagattu wa kokawa danave barautu, sira murap me wait tamibarip ayawa gumbe tutune. Sira wa me at Sirutes togewa apa aitan aivine nu a atune, meoya nu wa anika meuma barautu poeman danave aigne wa inganit aivine. ");
INSERT INTO mti_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Taig koka gumbe aig ge dauwa antune, sira oiyat umae iyayapan amatog tawara upeba wa danave wakeyawa emetune. ");
INSERT INTO mti_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Oiyat duwamdesi apa, nu nanuwo wa dividivi meumawa upeba tam epa emeya. ");
INSERT INTO mti_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nu oma den ane kum ge marantun yawamtu, oiyat upeba onanane, taig koka ande toivinewa, oieba nu gob waitawaita oya anog yankwetu. ");
INSERT INTO mti_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bira da kum obiren nakwai da den naya, meoya Poru namuwo yoig dirum wane, “Iyayapan neuma, ne gae neuma aug wa gumbe at Kurete ginayapawa apa den onantuwa, nu kukaeba mame ge waropiyatanwa den gaveyapono. ");
INSERT INTO mti_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Megara gare mame di ne wasiwam yeneni. Yusiyusi aya. Ye daneyap undag da bira inaiinai den waropiyape. Wa mekut waropiyata. ");
INSERT INTO mti_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Watau arampuna, God nauwawa eniwa aneyaeba namunap yoine, ");
INSERT INTO mti_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","me wane, ‘Poru, den a a. Ge Siisa namive yoitanit di. Sira God me iyayapan undag mu wa danave ge gaibu wakeyawa genna.’ ");
INSERT INTO mti_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Meoya iyayapan neuma, yusiyusi aya. Ne God gumbe anotumat eniwa, dividivi undag me matai veniyape wait ne didnednewa mina. ");
INSERT INTO mti_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nu matai ampa ginayapawa visive angetanit di.” ");
INSERT INTO mti_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Oiyat 14 onanane, aram sisipuna danave, nu poeman Adria apa aig ge dauwa etewa, aram nub bagiwa apa wa nau eme igiyawa anoyawa, wa me piyu da uwatan aivi. ");
INSERT INTO mti_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Mu poeman epampa meuma aninin om wariyawa, mu yaug anoya epampa meumawa 40 mitas mina. Sira utunut siririyaya sira om wariyawa me 30 mitas mina. ");
INSERT INTO mti_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Mu anogugut ayawa me an koka poeman danave dauwapetan, meoya wa anika duwam ge duwam wa virive apa emiya sira wantetan oya amareme. ");
INSERT INTO mti_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Megara wa nau eme igiyawa wa gumbe a amotan eme, sira mu ugauga ake wa anika aoretan oya eme, wa kusi barauya poeman egave ekekenut aigivi. ");
INSERT INTO mti_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Meoya Poru me senturion ge mut igiyawa dirum wane, “Wa danave iyayapan mame den wakepe ipewa, ye gaibu waitawaita den auya.” ");
INSERT INTO mti_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Meve mut igiyawa wa kusi murap meuma togomiyaya kweya ingan aine. ");
INSERT INTO mti_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Wanteivi omome, Poru wasiwam munne undag nakwai natan oya, “Ye amarene amarene, onne gare nakwai da den nayana, oiyat 14 onanane. ");
INSERT INTO mti_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Meoya ne ye diruiyeni nakwai naya. Mame ye sira yutuiwa yempe oya. Kuiyegumewa danave desirom da den waropiyape.” ");
INSERT INTO mti_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Meib wane, sira bredi aune iyayapan undag namuwo God gumbe gaun wane, sira warensig amatog nane. ");
INSERT INTO mti_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Meve iyayapan yutuwa auya, sira amatog nakwai naya. ");
INSERT INTO mti_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Nu wa danave waketuwa undag 276. ");
INSERT INTO mti_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Undag nakwai kokavit naya oma ane, meve wa beumatan oya mu nakwai wiit emeya poeman danave aigeya. ");
INSERT INTO mti_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Wantenewa, mu at piyu ginangawa yaiyai den yaug anoya, megara mu awau eg baraune yauyawa, mu imuwo awau uniktan anoya. ");
INSERT INTO mti_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Wa anika murapeba togomiyaya poeman danave aigne, me koniwa apa murap barauk tuyawa vesiya, sira wa wapeyawa taig autan oya wan yuya dauwane, sira awau noiwa oya amome. ");
INSERT INTO mti_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Sira togewa me apa yoi poeman danave kintoiviwa duwam uwagaveya eme, meoya wa togewa apa yabnadne. Wa kuiyawa yabnadne aitanwa oma den ane, sira yawarat yusipamitwa wa viriwa yabnewa, me amatog dumedne. ");
INSERT INTO mti_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mut igiyawa garawano ayawa mu nog igiyawa undag gutpe boriruwape, kuiyawa nog igiyawa oi tek a ampewa me bainda onan me kukaine. ");
INSERT INTO mti_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","44","Megara senturion anoiviwa me Poru waita wantan. Meoya me mu anoemewa topayane. Me dirum wanewa namu birabira oma ane oi teemewa pisiag aigiya poeman danave sira piyu egave dauwape, ivi iyayapan upeba yoma peyawa ge wa peyawa upeba yumnat oeteg ampe. Meib aya, sira iyayapan undag piyu egave yaiyai dauwaya. ");
INSERT INTO mti_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Meib nu waita autuwa, yaug anotu at mame me ginayapawa mu waya Maruta. ");
INSERT INTO mti_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ginayapawa mame igiyawa mu inaiinai nugunup oraimina di aya. Me kumiwa apa uvin uwane taig wadnunne, meoya mu iyam okeriya baigan muma oraimina nugunup aya. ");
INSERT INTO mti_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Poru yoma gedoapam aug iyam yangave aorenewa, iyam amiwa gumbe mokare kukaeba gedo danave dauwane, me Poru naniwa adne. ");
INSERT INTO mti_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ginayapawa igiyawa yauya mokare nanive geroriyane, sira gae garawa aya, “Apan mame iyayapan gurivi nu den pimpan gitta. Me poeman gumbe waita aune, megara vesin goddeba oraiminawa me yan den kweya vinigimpe.” ");
INSERT INTO mti_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Megara Poru mokare naniwa geroriyanewa iyam danave totarane, me divi da den wakukamne. ");
INSERT INTO mti_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ginayapawa igiyawa mu anoemewa gare mame di tampe sira uyug aig tatevit botope. Meoya mu amareme. Megara divi da den matadne, mu anoemewa biroriyag amatog waya, “Apan mame me god.” ");
INSERT INTO mti_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","At asime megiyave, namuyoiyoi abnawa painau iviwa Pabrius me piyu meuma wakene. Me nu angetan wanewa nu antu, sira me nu baigan kokavit gunup ane oiyat duwamdesi onanane. ");
INSERT INTO mti_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Me kumiwa apa, me mamawa yuwarane ui amiwa ge ni yoipam tuivi gumbe viniviwa arawa apa wakeivi. Meoya Poru apan asime oya aig nun wane, naniwa egave baraune me oraimina ane. ");
INSERT INTO mti_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Mame anewa, ginayapawa igiyawa yuwat gaibu upeba onamiya yuwat muma gumbe inaimusia. ");
INSERT INTO mti_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Sira mu munan ebnotu kokavit aya, sira nu wa gumbe dauwag antunewa mu tawara obiren nu imunup anoetewa nunan tamibarip aya. ");
INSERT INTO mti_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Dud duwamdesi onanane, nu wa gumbe dauwag antu. Me Arekisandria wa meuma, me taig kumiwa apa ginayapawa mame apa wakenewa, me wa kuiyave naturup goddeba ivuwa Kasta ge Porakus teyawa. ");
INSERT INTO mti_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nu Sirakiusu antu, sira kum duwamdesi waketu. ");
INSERT INTO mti_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Asime apa nu wa gumbe dauwag antu, sira at Regium uwatu. Kum desirom onananewa taig me sausu apa amatog tone, meoya oiyat dawa Puteori uwatune. ");
INSERT INTO mti_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Meapa nu tatanaiwa upeba yawamtu, sira didnuniyawa kum 7 danave mu gaibu waketu. Mame mina nu Romu uwatu. ");
INSERT INTO mti_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Tatangwanen nunan anoyawa, mu nu yau nuntan oya Romu apa at Api Porum ge at Tores Tavans onamiya. Poru mu yawam God gumbe gaun wane, mu ano yusiwa waniya. ");
INSERT INTO mti_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nu Romu uwatuwa, Poru mut igiyawa gaibu gwe dana vintan ung waya. ");
INSERT INTO mti_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kum duwamdesi onanane. Poru Ju igiyawa koukawa agoniyatan oya wane, sira mu agoniyayawa Poru mu dirum wane, “Ne tatanaiwa, ne divi da den ana. Iyayapan neuma gumbo sira isimuranaiwa anoano muma gumbe kukaeba den ana. Megara Jerusarem apa mu yum negiya sira Romu igiyawa nanuwo baraunegiya. ");
INSERT INTO mti_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Romu igiyawa yaimoyai yaunegiya, megara ne bo atan oya natawa da den yauyawa, mu anoemewa matai kwenetpe dauwag anetna. ");
INSERT INTO mti_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Megara Ju igiyawa mu topai aya, meoya ne Siisa gumbe keptete atan oya nun wana. Natawa meib, ne owanaiwa gumbo pui den yuwameni. ");
INSERT INTO mti_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kuiyawa mame oya, ne imunap ye yavetna sira ye gaibu gae watna, meoya ye guniyap ongetan wana. Isuraeru owanowan oya ne murap gumbe tunegiya.” ");
INSERT INTO mti_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Meve mu waya, “Nu umum genan da den autune Judia gumbe. Sira nu owanaiwa upeba mapa onamiya, megara mu gumbo bira da genan gae gwambe den toyau nuniya, sira gwambe den waya. ");
INSERT INTO mti_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nu anoetewa ge divi anoegewa siwavitwa anotanwa me oraimina di. Nu anotuwa anotumat dam mame gumbe at obiren apa iyayapan pui yuwameme.” ");
INSERT INTO mti_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Sira mu gae yuya kum desirom, meve iyayapan obiren gaibu Poru gwe me apa wakenewa mu uwaya. Poru me gae mumbe wag onivi aram uwane. Me God toimuwawa oya gae wane, sira Mosisi Gwangwan ge propeta bukaeba oya wag, mu toyau munivi Iesu oya. ");
INSERT INTO mti_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Iyayapan upeba mu me dimbae wanewa gumbe anotumat eme, megara iyayapan upeba mu anotumat den eme. ");
INSERT INTO mti_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Mame mina, mu anoemewa desirom den ane, sira mu taig amomewa, Poru gae desirom wane, “Guwawa Iyakaisiyapama me Aisaya gumbe me isimureaiwa gumbo wanewa me me di. ");
INSERT INTO mti_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Iyayapan mame gumbo ag diruma. Ye anoene, megara den di yaug anoya; ye yavene, megara den di yaug anoya. ");
INSERT INTO mti_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kuiyawa iyayapan mame nonowa e den sivi, mu naunowa boredne, sira mu yangowa abumiya. Mu yangowo den yaveme. Mu naunowo den anoeme, nonomagave den yaug anoeme, sira nonomagawa den tobieme. Ne den warinamuntna.’ ");
INSERT INTO mti_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Meoya yaug anoya. Waita waita mame God meuma baraune Ju onan igiyawa gumbo aine. Mu matai anope.” ");
INSERT INTO mti_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","(-) ");
INSERT INTO mti_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Mame mina, Poru bairawan duwam danave gwe me anmaga meuma gumbe koni pipi vinigimtanwa oya aunewa apa vinivi, sira iyayapan me gumbe amdau onamiyawa undag me baigan gumbo ane. ");
INSERT INTO mti_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Me yusipamit, sira bira da me gumbe tobottanwa onan di, God toimuwawa oya gae taibe dirum wag Ayapan Iesu Keriso oya toyau munne. ");
INSERT INTO mti_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Poru, Iesu Keriso me nauwawa eniwa, God me gae oraiwa oya wagomiya nedne nenan auwane apasoro ana. ");
INSERT INTO mti_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","—Gae oraiwa me Baiboru iyakaisiyapama danave propeta gumbo watavit agi wanewa. ");
INSERT INTO mti_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Me Usiwa oya. Me kwapiwa gumbe Devid dam meuma apa yaig onnewa. ");
INSERT INTO mti_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Guwawa Iyakaisiyapama gumbe, me bo igiyawa gumbo sira inaine, sira God yusiwa kokavitwa gumbe taibe wanewa me God Usiwa. Me Ayapan numawa Iesu Keriso. ");
INSERT INTO mti_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Me gumbe nu God ano oraiwa ge apasoro nauwawa tamtu. Me Iviwa wateteyamtan, Ju onan igiyawa undag auwatan sira mu anotumat gumbe noiwa autan oya. ");
INSERT INTO mti_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ye gaibu iyayapan mu Iesu Keriso auwanewa danowo.— ");
INSERT INTO mti_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ye undag at Romu danave wakeyanawa, iyayapan iyakaisi atan oya God auwanewa, God baigan yeniviwa, ye undag guniyap ne mame teeni. Mamunwa God ge Ayapan Iesu Keriso God ano oraiwa ge yum meumawa ye guniyap wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Namuirenwa, ye undag oya God neuma gumbe gaun veni Iesu Keriso gumbe. Kuiyawa anotumat yeuma gumbe iyayapan gae wag me piyu mame undag wateteyamivi. ");
INSERT INTO mti_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Ne Usiwa gae oraiwa meuma oya opata veni, meiba gumbe ne God nauwawa eni nonenmagawa undag gumbe. God taibe wape, ne evedni yenan anoeni. ");
INSERT INTO mti_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Evedni nun veniwa, God ano meuma gumbe ebu nenan watappe meve oieba ne gare mame oma ane yenan ongetan anoeni. ");
INSERT INTO mti_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Ye yauyemtan oya yusipamit anoeni, kuiyawa ne atan anoeni ye yutuiwa ape guwawa puyowawa upeba keb atna gumbe. ");
INSERT INTO mti_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Gae dawa me mamaib, ne anoeniwa ye guniyap sira anotumat yeuma ge ne anotumat neuma gumbe yutunwa garawan ata. ");
INSERT INTO mti_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Tatangwanen, ne yusipamit anoeni ye yaug anoya. Ne at upeba igiyawa gumbo magawa upeba tamna. Me mina ne ye guniyap magawa upeba tamtan anoeni. Meoya ne kum obiren ageyau ana guniyap ongetan oya. Megara ano da tobodne onne gare mame. ");
INSERT INTO mti_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ne sira muntanwa di gaibu, Griisu igiyawa ge ano onan igiyawa gumbo, sira gigirum igiyawa ge gigirum onan igiyawa gumbo. ");
INSERT INTO mti_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Meoya ne gae oraiwa ye at Romu apa wakeyenewa guniyap opata di atan anoeni. ");
INSERT INTO mti_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ne gae oraiwa gumbe ubmam onan. Gae oraiwa me God yusiwa. Me oma ane anotumat igiyawa undag waita mumpe, namu Ju igiyawa, meve Griisu igiyawa me mina gumbo. ");
INSERT INTO mti_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Kuiyawa gae oraiwa danave God oraivitwa taibe toyau nunne, sira oraivitwa God namive me namuiren amatonewa apa onne anotumat gumbe oieba aune. “Oraivit abnawa God namive me anotumat gumbe wakeigimpe,” Baiboru meib tene. ");
INSERT INTO mti_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Kuiyawa iyayapan upeba God namive oraiwa onanwa gumbe natawa toboreme. Mu God waiya den emewa ge oraiwa onanwa oya God danapiriwa me toyau munivi kwimin apa. ");
INSERT INTO mti_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","God divi meumawa mu yaug anopono me taibe esine. Me God toyau munne. ");
INSERT INTO mti_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Kuiyawa piyu mame wadnewa kumiwa apa onne gare mame, God wadnewa mu God anoano meuma guwavewa,—me God yusiwa yaibobot ge God inaiinai meuma,—taibe yauya sira yaug anoya. Mu singui da onan. ");
INSERT INTO mti_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Kuiyawa mu God yaug anoya God me God di, megara mu God den waiyaya. Mu God gaun den waniya, meve anoemewa natawa onan ane, nonomagowa waragowawa gumbe aram uwamunne. ");
INSERT INTO mti_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Mu waya nu undag yaug anotune igiyawa, megara mu kuiyowa onan igiyawa aya. ");
INSERT INTO mti_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Mu God eyawa meuma aug tobiroriyaya iyayapan mu watkukampewa irawa, nenip irawa, mae irawa, sira wararat emewa irawa minawa. ");
INSERT INTO mti_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Meoya nonowa kukaeba anoemewa oya God mu miyot munne. Meve mu kwapuwa oya anog kukaeba garagara aya. ");
INSERT INTO mti_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Mu God natawa aug tobiyaya ugauga eme. Wadnewa waiyatanwa garawa, mu waramnewa waiya eme, nauwawa eme. Nu wadnunnewa me mekut di waiyaigimta oieba onan. Amen. ");
INSERT INTO mti_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Me mina God mu munnewa ano kukaeba ubmameba oya. Sira meve vesin mu taibe toboratanwa aug tobiroriyaya toboratanwa ubewa oya. ");
INSERT INTO mti_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Ebu desiroma, apan mu vesin gaibu taibe toboratanwa yankweya, sira mu apan gumbo ano kukaeba ubmameba gumbe nonowa iyam mina igne, sira mu kukaeba apan gumbo eme. Mu gwambe muma garawa mu mukut aueme. Me taibewa. ");
INSERT INTO mti_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Sira mu God yaug anotan den anoya, meoya God mu munnewa kukaeba anoemewa, meve mu emewa mu meib den aigimpono. ");
INSERT INTO mti_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Mu mamaib. Mu demtawa auemewa me oraiwa onanwa, kukaeba, nuniatatu ge ano kukaeba. Sira mu demtawa anoemewa me anogugut, toenguttan anoiviwa, mut atan anoiviwa, uga watan anoiviwa ge kukaeba atan anoiviwa, sira mu yano igiyawa. ");
INSERT INTO mti_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Mu iyayapan upeba ano tam yanteiviwa igiyawa, God topai eme igiyawa, iyayapan upeba gumbo ayamat den eme igiyawa, mokona onan igiyawa, mumbo enagateg gaiyawa veme igiyawa, kukaeba atan anoeme igiyawa, sira inomamowa nouwo den aueme igiyawa, ");
INSERT INTO mti_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","den yaug anoeme igiyawa, agi togomieme igiyawa, danadawai den aueme igiyawa, sira ano den muneme igiyawa. ");
INSERT INTO mti_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Mu God gwangwaneba anoeme. God gwangwaneba gumbe, mu meib apewa gutpe boriruwape. Mu me yaug anoeme, megara mu me eme. Sira mu desiroma eme igiyawa gumbo bainda veme nonomagowa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Meoya ye iyayapan upeba pui yuwamenewa, divi da den waya ye yenan tobot yemtan oya. Ye iyayapan upeba pui yuwamene, me gumbe ye yembovit pui yuene me ye kukaeba igiyawa. Kuiyawa ye pui yuwamenewa ye sira meib di ene. ");
INSERT INTO mti_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nu yaug anotu, iyayapan mu meib emewa gumbo God keptetanwa me oraimina. ");
INSERT INTO mti_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Iyayapan mu meib emewa gumbo ye pui yuwamene, megara ye gaibu gina desiroma ene. Ye God keptete apa ye guwave aisiene anoene? Onan di. ");
INSERT INTO mti_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Go God baigan meuma amat yempe nonewa biroriyatan gumbe, ye me den yaug anoene? Me baigan meuma kokavitwa ge yaimoyai waketanwa ge nonewa memeyu me kusi onan, ye me den yaug anoene? ");
INSERT INTO mti_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Megara ye nonewa yaigiwa sira nonewa biroriyatanwa onan, me gumbe, God danapiri meuma yenan oya ye tam unai warene. God danapiri kumiwa,—God keptetanwa meuma oraiwa uwatanwa kumiwa,—me kumive God danapiri uwape. ");
INSERT INTO mti_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","God iyayapan dividivi emewa gumbo garawa mumpe. ");
INSERT INTO mti_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Iyayapan mu oraiwa emewa ge me eyawa, ayamat ge anoano yaibobot oya diuemewa mu gumbo inaiinai yaibobot mumpe. ");
INSERT INTO mti_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Iyayapan mu ubeube wakeg natawa topayag oraiwa onanwa noiwa auemewa mu gumbo God anokukam ge danapiriwa aikpe. ");
INSERT INTO mti_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Edawai ge danadawai me dividivi kukaeba eme igiyawa undag gumbo aikpe, Ju igiyawa namuwo Griisu igiyawa ge iyayapan upeba. ");
INSERT INTO mti_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Oraiwa eme igiyawa undag gumbo eyawa, ayamat ge yum aikpe, Ju igiyawa namuwo sira Griisu igiyawa ge iyayapan upeba. ");
INSERT INTO mti_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","God bira da desirom mekut oya den anoivi. ");
INSERT INTO mti_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Undag mu Gwangwaneba den aug kukaeba emewa mu wakukampe Gwangwaneba gumbe onan. Undag bira Gwangwaneba ankwatave kukaeba emewa mu pui aupe Gwangwaneba gumbe. ");
INSERT INTO mti_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Kuiyawa Gwangwan anoeme igiyawa God namive mu oraimina onan, megara Gwangwan gumbe wakeeme igiyawa God ape mu oraimina ape God namive. ");
INSERT INTO mti_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","(Ju onan igiyawa mu Gwangwan gumbe onan, megara mu yaiyawa apa onnewa Gwangwan aninin waiviwa gumbe ape ipewa, mu mukut Gwangwan. ");
INSERT INTO mti_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Mame mina, mu toewan muneme me nonomagave Gwangwan divi waiviwa tene. Nonomagawa oraiwa gaibu mame toewan muneme. Mu anoano muma pui gara yueme, sira mu mumbovit papara vineme.) ");
INSERT INTO mti_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ne gae oraiwa neuma gumbe veni. Keriso Iesu gumbe, God me ivi iyayapan guwave mumawa keptepe, sira God keptetanwa meuma me oiyat desiroma apa. ");
INSERT INTO mti_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ye waigimiya ipewa, “Nu Ju igiyawa,” sira Gwangwan gumbe wakeigimiya ipewa, God gumbe degadega aigimiya ipewa, ");
INSERT INTO mti_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ye God ano meuma yaug anoigimiya ipewa, Gwangwan gumbe aninin atanwa toewan yenne sira amaraigimiya ipewa, ");
INSERT INTO mti_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Gwangwan me anoano ge natawa irawa mumawa ye autanwa gumbe, ye mamaib anoya ipewa, “Nu waita igiyawa yanga bored igiyawa oya, sira dun sisip danave wakeya igiyawa oya, ");
INSERT INTO mti_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","namuyoiyoi igiyawa gigirum onan igiyawa oya, sira toewanewan igiyawa ud torawa munan,” ");
INSERT INTO mti_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ye iyayapan toyau munenewa, divi oya ye yembovit den toewanene. Ye ub den atan oya opata vene, megara divi oya ye ub ene? ");
INSERT INTO mti_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ye venewa iyayapan uinantaraki den aigimiya, megara divi oya ye uinantaraki ene? Ye god ugaugaeba topaiene, megara divi oya ye temporu dividivi meuma ub ene? ");
INSERT INTO mti_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ye Gwangwan gumbe degadega ene, megara divi oya ye Gwangwan togomiyag God aug yan barautan ene? ");
INSERT INTO mti_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“Ju onan igiyawa yapowo God iviwa iyagau eme kuiyawa me ye,” tene. Me meib di. ");
INSERT INTO mti_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ye Gwangwan amaraya ipewa, kwapituitui me natawa gaibu. Ye Gwangwan den amara aigimiya ipewa, ye kwapituitui yeuma me kwapituitui onanwa mina aya. ");
INSERT INTO mti_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kwapituitui onan igiyawa mu kwapituitui den auya, megara mu Gwangwan desirom desirom amaraigimiya ipewa, mu kwapituitui igiyawa mina aya, go? E, meib aya. ");
INSERT INTO mti_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Sira ye Gwangwan gigirum gaibu sira kwapituitui gaibu igiyawa, megara ye Gwangwan den amarene. Meoya kwapuwa gumbe kwapituitui den auya igiyawa mu Gwangwan amaraigimiya ipewa, mu ye pui yuepe? E, meib ape. ");
INSERT INTO mti_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Kwapiwa taibe yautanwa gumbe Ju apan me Ju apan sinsin onan. Kwapiwa gumbe kwapituitui anewa me kwapituitui sinsin onan. ");
INSERT INTO mti_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Megara Ju apan guwavewa me Ju apan sinsin, sira kwapituitui me Guwawa Iyakaisiyapama ge nonemagawa gumbe sira me gigirum gumbe onan me kwapituitui sinsin. Waiya waiya me iyayapan gumbo den onivi, megara God gumbe. ");
INSERT INTO mti_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Meve Ju oraiwa meuma me divi? Kwapituitui garawa me divi? ");
INSERT INTO mti_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Anoano undag danave obiren wakeya. Namuirenwa God anotumat munne sira God gaiyawa munne. ");
INSERT INTO mti_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Meve me divi? Anotumat onan igiyawa yapowo wakeyawa, anotumat onanwa me gumbe God anotumateba onanape go? ");
INSERT INTO mti_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Onan di, me den onanape. Iyayapan undag ugauga igiyawa meib nu dirum watawa, nu watanit di, “God me anotumat abnawa.” Mamaib tene, “Ge gae geuma gumbe oraivitwa auwa, sira pui gempewa me matai auwa.” ");
INSERT INTO mti_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Megara, oraiwa onanwa numawa God namive me God oraiwa toewan numpe ipewa, me aninin? God me danapiriwa numpewa me oraiwa onan? (Ne iyayapan ano inaiinai muma gumbe veni.) ");
INSERT INTO mti_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Onan, me meib onan di. Me meib ipewa, aninin God me at piyu mame pui yupe? ");
INSERT INTO mti_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ne ugauga neuma gumbe God natawa ega egave taibe ape, sira God eyawa taibe apewa, divi oya God pui yunekpe ne kukaeba oya? ");
INSERT INTO mti_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","“Kukaeba ata me gumbe oraiwa toewan muntan,” meib watawa bainda go?—Iyayapan ano mame gumbe pui yununeme. Iyayapan upeba veme me gae numa mina.—Mame mina garawa anoeme igiyawa, me oya mu pui autanit di. ");
INSERT INTO mti_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Meve me divi? Nu oraimina iyayapan upeba mina onan? Nu watavit wag pui yumuntu, “Ju igiyawa ge Griisu igiyawa, iyayapan undag mu kukaeba gumbe wakeeme.” ");
INSERT INTO mti_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kuiyawa mamaib tene. “Bira da God namive oraiwa onan. Da desirom onan. ");
INSERT INTO mti_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Bira da den yaug anobodne. Bira da God oya den didimama aivi. ");
INSERT INTO mti_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Undag daieve amiya sira ebu muma waropiyaya, sira undag kukaeba gumbe toboraya. Bira da den oraiwa aivi. Da desirom onan.” ");
INSERT INTO mti_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","“Mu meyowa mempotat yampot watabne. Mu pednowa gumbe ugauga veme.” “Mu nou kwapiwa ankwatave mokare yoiba kukaeba wakene.” ");
INSERT INTO mti_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","“Mu nouwa enewaruwat ge sisiwa gumbe noidauwane.” ");
INSERT INTO mti_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","“Amowa mu oma ane kintoeme mut ag ganigani wattan oya. ");
INSERT INTO mti_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Watkukamtanwa ge danadawai mu ebuwave. ");
INSERT INTO mti_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Sira mu yum ebuwawa den yaug anoya.” ");
INSERT INTO mti_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","“Mu yangowo namive God gumbe a onan.” ");
INSERT INTO mti_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nu mamaib yaug anotu. Dividivi gumbe Gwangwan waiviwa undag me Gwangwan ankwatave wakeeme igiyawa munan. Me nouwa undag iyaigitpe, piyu mame undag God keptete gumbe noiwa autan oya. ");
INSERT INTO mti_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Kuiyawa Gwangwan aigimtanwa gumbe, bira da oma den ane oraimina ape God namive. Megara Gwangwan gumbe kukaeba numa yaug anota. ");
INSERT INTO mti_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Megara gare mame di, God oraiwa meuma me taibe toyau nunne, me Gwangwan amaratanwa gumbe onan. Me Gwangwan ge Propeta bukaeba danave wait tenewa. ");
INSERT INTO mti_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Me God oraiwa me Iesu Keriso gumbe anotumat eme igiyawa undag mu gumbo muniviwa. Ube onan iyayapan yapowo. ");
INSERT INTO mti_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Iyayapan undag kukaeba aya, meoya God gumbe mu oma den ane eyawa aupe. ");
INSERT INTO mti_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Megara God ano oraiwa gumbe, Keriso Iesu sira gwiruwat nuntan gumbe, oraiwa God namive ingui nunne. ");
INSERT INTO mti_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","God me Keriso Iesu taibe toyau munne. Me puyo maeba God danapiriwa yankwetan oya ganigani gumbe sira anotumat gumbe. Me toewamuniviwa God oraiwa meuma. Kuiyawa God me ano yaimoyai wakeigimtanwa gumbe, iyayapan gumbo ibnawa den munne, yaunewa mu kukaeba muma me mu mukut ayawa. ");
INSERT INTO mti_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Me gare mame di God oraiwa meuma toewan muntan oya, God mekut oraiwa toewan muntan oya, Iesu gumbe anotumat aivi abnawa me God awanivi oraimina God namive ag toewan muntan oya. ");
INSERT INTO mti_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Meve apanapan numawa ampa wakene? Me wait aug aine. Me ebu ambuwa gumbe? Me dividivi etewa ebuwawa gumbe? Onan di, me anotumat ebuwawa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Nu ano numa mameib. Apan oraimina God namive apewa Gwangwan aug atanwa gumbe onan. Me anotumat gumbe. ");
INSERT INTO mti_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Go God me God Ju igiyawa mukut oya go? Me Ju onan igiyawa gaibu God muma onan go? E, God me God Ju onan igiyawa mu gaibu. ");
INSERT INTO mti_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","God me desirom apewa, me meib. God mame kwapituitui igiyawa anotumat gumbe oraiwa ape God namive, sira me kwapituitui onan igiyawa gaibu anotumat gumbe oraiwa ape God namive. ");
INSERT INTO mti_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Meve nu anotumat gumbe Gwangwan natawa yusiwa onanape go? Onan di. Megara nu Gwangwan aug yudapta. ");
INSERT INTO mti_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Meve Ebraam oya—me nu isimuranwa kwapiwa gumbe—nu aninin waton? ");
INSERT INTO mti_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ebraam divi da atanwa gumbe God namive oraimina anewa, me oma ane apanapan wakene. Megara God namive me meib onan. ");
INSERT INTO mti_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Baiboru anin waivi? Me tenewa, “Meve Ebraam God gumbe anotumat ane. Meoya God ane me oraiwa ane.” ");
INSERT INTO mti_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Bira da nau ape ipewa, garawa me puyo onan, megara me garawa mu menan barautanit di.” ");
INSERT INTO mti_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","God ape God anavi eme igiyawa oraimina ape God namive. Nau den eme igiyawa mu God gumbe anotumat ape ipewa, God me anotumat mumawa gumbe mu oraiwa ape. ");
INSERT INTO mti_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Divi da den atanwa gumbe God ane oraimina aya igiyawa mu waribiya munnewa. Devid mame oya mamaib wane. ");
INSERT INTO mti_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“Iyayapan mu Gwangwan togomiemewa God anog yankwene sira Me kukaeba muma anog yan tobodnewa, mu gumbo waribiya wakeigimpe, ");
INSERT INTO mti_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Iyayapan gumbo Ayapan kukaeba muma den basiyaiviwa, mu gumbo waribiya wakeigimpe!” ");
INSERT INTO mti_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Meve waribiya atanwa mame me kwapituitui igiyawa mukut, go kwapituitui onanwa igiyawa gaibu? Nu watu, “Ebraam me anotumat meuma gumbe God ane oraimina ane.” ");
INSERT INTO mti_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Megara divi gumbe God ane me oraimina ane anotumat meuma gumbe. Me kwapituitui ane onananeve? Go, me kwapiwa den tuiyave? Me kwapituitui ane onananeve onan, megara me kwapi den tuiyave ane. ");
INSERT INTO mti_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","12","Me kwapituitui den ane kumiwa apa, anotumat meuma gumbe God ane oraimina ane. Meoya, me kwapituitui siren aune anoanowawa gumbe. Kwapituitui onan igiyawa mu anotumat gumbe God ane oraimina ape. Me Ebraam kwapituitui onan igiyawa undag mu God ane anotumat gumbe oraimina ape God namive mu mamuwon atan oya, sira kwapituitui igiyawa mu mamuwon atan oya. Natawa me mamaib. Iyayapan da kwapituitui aya. Iyayapan upeba mu anotumat me mamunwa Ebraam kwapituitui onan kumive aunewa me amave amome. Sira Ebraam me iyayapan mame undag mamowa ape. ");
INSERT INTO mti_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Ebraam ge isimuranaiwa gumbo God agi munne. Agi munnewa me piyu mame kwanawa autanwa igiyawa atan oya. Agi munnewa me Gwangwan gumbe onan, megara anotumat oraiwa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Iyayapan mu kwan autanwa igiyawa Gwangwan gumbe ape ipewa, anotumat me natawa onan, sira agi me yusiwa onanape. ");
INSERT INTO mti_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Gwangwan me danapiriwa pawaivi. Gwangwan den wakepewa, Gwangwan togomiyatanwa onan. ");
INSERT INTO mti_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Meoya anotumat gumbe nu oma ane piyu mame kwanawa autanwa igiyawa ata. Me God ano oraiwa gumbe. Me mina, agi mame Ebraam dam meuma yaig onamiyawa gumbo,—Gwangwan gaibu igiyawa mukut onan, megara Ebraam anotumat meuma amave omomewa igiyawa gaibu,—nau aigimpe. Mamaib tene, “Ne ana ge piyu undag apa wakeeme igiyawa munan mamowon ana.” Me meib. Ebraam me nu undag mamunwa. ");
INSERT INTO mti_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","God gumbe me anotumat ane. Me natawa God mame namive. God mame oma ane ape boriruwaya igiyawa sira inaimutpe, sira oma ane auwape den wakenewa me matai wakepe. ");
INSERT INTO mti_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Me oma den ane owanowan aune kumiwa apa, anotumat ane owanowan gumbe. Me at undag igiyawa me mamowon atan oya, kuiyawa God wane, “Ge dam geuma yaig ampewa mame mina ape.” ");
INSERT INTO mti_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ebraam bairawan 100 mina onanane, sira me yaug anone me kwapiwa me bo igiyawa kwapuwon ane. Sira me yaug anone Seira danawa boane. Megara anotumat meuma yusi den uwane. ");
INSERT INTO mti_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Me anotumat onanwa den aune, sira me God agi meuma den anopipanum ane. Megara anotumat meuma yusi waivi, sira me Eyawa God wanne. ");
INSERT INTO mti_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Me God gumbe anotumat yusipamit ane. Me anonewa God yusipama sira God oma ane agi meuma ape. ");
INSERT INTO mti_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Meoya dividivi mame gumbe God ane me oraimina ane God namive. ");
INSERT INTO mti_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","24","Baiboru tene, “God ane me oraimina ane God namive.” Me meib tenewa me mekut oya onan, megara nunan gaibu. Natawa mamaib. God ane Ayapan numa Iesu sira inaine boriruwaya igiyawa gumbo. Nu God me anotumat ata ipewa, God ape nu oraimina ata God namive. ");
INSERT INTO mti_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ayapan Iesu me kukaeba numa oya barauya aig boane. Meve God ane me sira inaine nu oraimina atan oya. ");
INSERT INTO mti_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","God ane nu oraimina atu God namive anotumat numa gumbe. Meoya nu Ayapan numa Iesu Keriso gumbe God ge nu gunup yapave yum gaibu. ");
INSERT INTO mti_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","God amara nunne nu God ano oraiwa mame danave uwatu Keriso gumbe. Nu God eyawa meuma oya anog degadega ete. ");
INSERT INTO mti_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Me mekut onan, megara nu danadawai gaibu degadega ete. Kuiyawa nu mamaib anoete. Danadawai ape nu unwa nikiyag waketanwa oya. ");
INSERT INTO mti_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Unuwa nikiatanwa ape inaiinai oraiwa oya. Inaiinai oraiwa ape owanowan oya. Nu me yaug anotu. ");
INSERT INTO mti_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Owanowan mame den yan barau numpe. Kuiyawa God me Guwawa Iyakaisiyapama nunne. Me gumbe God me baigan meuma egamivi nonunmagawa danave. ");
INSERT INTO mti_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Nu ande yutunwa onan kumiwa apa, kum God baraunewa apa, Keriso boane God anavi atu igiyawa nunan. ");
INSERT INTO mti_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Apan oraiwa oya apan da boape, go onan? Anten onan go. Apan da me anoiviwa gumbe ano munivi abnawa menan matai boape, go onan? Anten iyayapan upeba mukut mu meib ape. ");
INSERT INTO mti_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Megara, nu kukaeba igiyawa kumiwa apa Keriso nunan boane. Me gumbe God baigan meuma gunup toewan nunivi. ");
INSERT INTO mti_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Meoya God me waita numpe danapiri meuma gumbe, kuiyawa God ane nu oraimina atune God namive Keriso diyawa gumbe. Me meib di wakenewa. ");
INSERT INTO mti_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Namu nu God anaviyawa. Megara Usiwa bo meuma gumbe God waribiya nunne. Meoya gare mame, Usiwa inaiinai meuma gumbe God waita nunivi. Me meib di wakenewa. ");
INSERT INTO mti_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Me mame mekut onan. Upiba gaibu. Ayapan numa Iesu Keriso me gumbe gare baigan autune. Me gumbe, God gumbe degadega kokavit ete. ");
INSERT INTO mti_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Natawa mamaib. Apan da desirom me gumbe kukaeba piyu mame gumbe unigne. Kukaeba gumbe bo unigne. Mameiba gumbe bo wateteyamne iyayapan undag piyu mame egave. Kuiyawa iyayapan undag ano kukaeba aya. ");
INSERT INTO mti_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Kuiyawa Gwangwan den munne kumiwa apa gaibu kukaeba piyu mame danave wakene. Megara Gwangwan den wakenewa, iyayapan oma den ane kukaeba yaug anoya. ");
INSERT INTO mti_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Adam gwangwan togomiyane. Adam kumiwa apa onne Mosisi kumiwa uwane, iyayapan mu gwangwan togomiyayawa wakeya. Iyayapan kukaeba muma me Adam kukaeba meuma mina onan. Megara bo iyayapan gumbo nau warivi. Adam me bira matai oniviwa me irawa meuma. ");
INSERT INTO mti_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Megara puyo ebuwawa ge gwangwan togomi atanwa ebuwawa me ube. Apan desirom gwangwan togomiyanewa gumbe iyayapan obiren boriruwaya. Megara me egave, God ano oraiwa, ge puyo me Apan Desirom Iesu Keriso ano oraiwa gumbe uwanewa, iyayapan obiren gumbo maura vinivi. ");
INSERT INTO mti_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Sira puyo ebuwawa ge apan desirom kukaeba meuma garawa ebuwawa me ubeube. Keptete kumiwa apa, gwangwan desirom togomi atanwa gumbe “Kukaeba abnawa,” wane. Megara God oraiwa ebuwawa gumbe, God ape gwangwan togomiemewa obiren oraimina ape God namive. ");
INSERT INTO mti_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Apan da desirom kukaeba atanwa gumbe, bo uwag nu amara nunne. Me egave, Iyayapan bira God ano oraiwa ge oraiminawa puyowawa koka auyawa mu gumbo inaiinai amara mumpe Apan Desirom Iesu Keriso gumbe. ");
INSERT INTO mti_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Mame mina, kukaeba atanwa desirom gumbe, iyayapan undag mu kukaeba God namive wane. Me meib desiroma, oraiwa atanwa desirom gumbe, iyayapan undag mu oraimumu God namive wane, sira inaiinai munivi. ");
INSERT INTO mti_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Natawa mamaib. Apan da God noiwa den aunewa gumbe God ane iyayapan obiren God namive kukaeba igiyawa aya. Mame mina, Apan Da God noiwa aunewa gumbe God matai ape iyayapan obiren God namive oraiwa igiyawa ape. ");
INSERT INTO mti_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Gwangwan unig uwanewa me kukaeba koka atanwa oya. Megara kukaeba koka aiviwa apa, God ano oraiwa me noidauwane sira egave. ");
INSERT INTO mti_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Natawa mamaib. Kukaeba me bo gumbe amarane, me mina, God ano oraiwa me Ayapan numa Iesu Keriso gumbe oraiwa puyowawa gumbe amaraivi. Me inaiinai yaibobot muntan oya. ");
INSERT INTO mti_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Meve nu anin waton? Nu kukaeba danave wakeigimta God ano oraiwa koka aigimtan oya? ");
INSERT INTO mti_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Onan di. Nu wait kukaeba gumbe boriruwatu. Aninin nu oma ane kukaeba danave inaiinai aug wakeigimton? ");
INSERT INTO mti_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Go, ye den yaug anoene go? Nu undag Iesu Keriso gumbe babataito autu. Natawa me bo meuma gumbe babataito autu. ");
INSERT INTO mti_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Meoya nu Keriso bo meuma gumbe babataito autu, me gumbe Keriso gaibu sig um nunne. Me Mamawa eyawa meuma gumbe, Keriso sira inaine boriruwayawa gumbo mina, nu gaibu inaiinai mataiwa gumbe vinigimtan oya. ");
INSERT INTO mti_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Nu Keriso gumbe toboraigimta ipewa, sira nu Keriso bo meuma mina boriruwaigimta ipewa, Keriso sira inaine mina nu meib inaigitta. ");
INSERT INTO mti_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nu mameib yaug anotu. Nu apan namuwa Keriso gaibu korosi egave boriruwaya. Natawa mamaib. Kukaeba kwapiwa wakukamne, kukaeba ankwatave nau eme igiyawa yankwetan oya. ");
INSERT INTO mti_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Boriruwaya igiyawa mu kukaeba gumbe yankweya. ");
INSERT INTO mti_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Nu mamaib anotumat ete. Nu Keriso gaibu bo ata ipewa, nu Keriso gaibu sira inaigitta. ");
INSERT INTO mti_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Nu mamaib anotu, Keriso boriruwaya igiyawa gumbo sira inaine, bo den ape, bo Keriso gumbe oma den ane nau ape. ");
INSERT INTO mti_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Kuiyawa Keriso me koni desirom mekut kukaeba numa gumbe bo ane. Keriso inaiviwa me God gumbe inaivi. ");
INSERT INTO mti_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ye mameib anoigimiya. Ye bo igiyawa kukaeba gumbe. Sira ye God gumbe wakeene igiyawa Keriso Iesu gumbe. ");
INSERT INTO mti_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Meoya bo atanwa kwapuiwa oya kukaeba den kwemiya nau aigimpe, sira ye ano kukaeba yeuma oya noiwa den aug aigimiya. ");
INSERT INTO mti_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Sira ye kwapuiwa da den kukaeba aineba ape kukaeba atan oya. Megara ye yembovit oraimina aineba ape, sira God gumbe puyo aya, kuiyawa ye boriruwaya igiyawa gumbo sira inaigisiana. ");
INSERT INTO mti_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Meoya kukaeba me yenan nau den watpe. Kuiyawa ye Gwangwan ankwatave den wakeene, megara God ano oraiwa ankwatave wakeene. ");
INSERT INTO mti_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Nu anin waton? Nu Gwangwan ankwatave den wakeete, megara God ano oraiwa ankwatave wakeete, meoya “Kukaeba ata,” nu wata? Onan di. ");
INSERT INTO mti_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ye mame den yaug anoyana? Ye yembovit puyo ag ankwatave nau ene igiyawa mina noiwa auyawa, ye me gumbe ankwatave nau ene igiyawa aya. Ye kukaeba ankwatave nau ene igiyawa ayawa matai bo aya, megara noiwa autanwa ankwatave nau ene igiyawa ayawa ye matai oraimina aya God namive. ");
INSERT INTO mti_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","18","Ne God gumbe gaun veni, kuiyawa ye watavit kukaeba nauwawa ene igiyawa, megara gare toewan yemnewa natawa nonemagewa gumbe noiwa auyana, kukaeba gumbe yankweyana, sira oraiwa ankwatave nau eme igiyawa ayana. ");
INSERT INTO mti_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Ye kwapuiwa gumbe yusi uwane, meoya ne iyayapan ebuwave veni. Ye watavit kwapuiwa miyot ge Gwangwan togomiyatan ankwatave nau ene igiyawa ayana, sira egave ye Gwangwan togomiyayana. Megara gare mame ye kwapuiwa keb aya, kwemiya me oraiwa God ankwatave nau emewa ape, sira ye meib di iyakaisi aigimiya. ");
INSERT INTO mti_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ye kukaeba ankwatave nau ene igiyawa kumiwa apa, ye oraiwa God namive me gumbe den anog wakeyana. ");
INSERT INTO mti_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Gare mame di ye me oya ubmam ene. Me kumiwa apa, ye oraiwa da auyana? Dividivi mame oieba me bo. ");
INSERT INTO mti_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Megara gare mame di, ye kukaeba yankweg God ankwatave nau ene igiyawa ayana. Ye natawa me gumbe iyakaisi ayanawa auyana. Mame oieba me inaiinai yaibobot. ");
INSERT INTO mti_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Kukaeba garawa me bo. Megara God puyowawa me inaiinai yaibobot me Ayapan numa Iesu Keriso nuniviwa. ");
INSERT INTO mti_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Tatangwanen, ye den yaug anoyana? Gwangwan me wakeiviwa abnawa menan yusiwa aug nau aigimpe.—Ne iyayapan Gwangwan yaveg anoyawa mu gumbo veni.— ");
INSERT INTO mti_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Vesin memawa aunewa me memawa gaibu Gwangwan gumbe tug wakeivi, memawa wakeivi kumiwa apa. Megara memawa bo topewa, meve vesin me Gwangwan gumbe yankwepe. ");
INSERT INTO mti_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Meoya vesin memawa wakenewa kumiwa apa apan da gaibu nag vinigimpewa me wape uinantaraki vesinawa. Megara memawa bo apewa, meve apan da gaibu nag vinigimpewa, me uinantaraki vesinawa onan. Kuiyawa vesin me Gwangwan gumbe wait yankwene. ");
INSERT INTO mti_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Tatangwanen, me meib desiroma. Ye wait Gwangwan gumbe bo ayana, Keriso kwapiwa gumbe. Me apan da gaibu ye yunat atanwa oya sira meve God oya natawa intan oya. Apan me boriruwayawa gumbo sira inainewa abnawa. ");
INSERT INTO mti_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Nu kwapunwa gumbe waketunewa kumiwa apa, nu bo natawa meuma autu, kuiyawa anoano kukaeba obiren me Gwangwan gumbe kwapunup nau wareme. ");
INSERT INTO mti_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Megara nu wait Gwangwan me tam nunnewa gumbe boriruwatu. Meoya nu Gwangwan gumbe wait yankwetu, gare mame nu God nauwawa ete Guwawa mataiwa gumbe, gigirum namuwa gumbe onan. ");
INSERT INTO mti_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Nu anin waton? Gwangwan me kukaeba go? Onan di. Megara ne Gwangwan den yaug anopopo ipawa, kukaeba den yaug anona. “Dividivi tamtan oya nun den waigima,” Gwangwan meib den wanewa, ne den yaug anona dividivi tamtan oya nun waigimtanwa me gwambe. ");
INSERT INTO mti_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Megara kukaeba me Gwangwan mame gumbe kumiwa aune sira ane ne nonenmagave dividivi undag tamtan oya nun wana. Gwangwan den wakenewa, kukaeba me bo anewa. ");
INSERT INTO mti_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ne watavit wakena Gwangwan gumbe onan. Megara gwangwan uwanewa kumiwa apa, kukaeba inaine, sira ne bo ana. ");
INSERT INTO mti_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Meoya ne mameib yaug anona. Gwangwan mame di amara nunigimpe inaiinai oya, megara me amara nunigimpe bo kumive. ");
INSERT INTO mti_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kuiyawa kukaeba me kumiwa aune sira gwangwan mame gumbe gunap ugai nedne, sira gwangwan gumbe ne to nedne bo ana. ");
INSERT INTO mti_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Meoya Gwangwan me iyakaisiyapama, gwangwan gaibu iyakaisiyapama sira bainda ge oraimina. ");
INSERT INTO mti_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Meve oraiwa mame bo aug wag negne? Onan di. Me kukaeba. Kukaeba me oraiwa mame gumbe bo aug wag negne. Mame gumbe kukaeba me taibe ane, sira gwangwan gumbe me kukaeba kokavit di ane. ");
INSERT INTO mti_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nu yaug anotu Gwangwan me guwawa mina. Megara ne apan kukaeba abnawa. Ne gwiruwat negiya, sira ne kukaeba ankwatave wakeeniwa. ");
INSERT INTO mti_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Ne den yaug anoeni aninin eni. Ne den eni divi atan anoeniwa. Ne eniwa me topayeniwa. ");
INSERT INTO mti_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Ne topayeniwa eni ipewa, natawa me ne Gwangwan me oraimina oya bainda veni. ");
INSERT INTO mti_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Meoya me aiviwa ne onan, megara kukaeba me ne gunap wakeiviwa aivi. ");
INSERT INTO mti_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ne yaug anonawa ne gunap kwapunwa danave ano oraiwa den wakene. Kuiyawa evedni ne imunap ano oraiwa atan anoeni, megara ne me den eni. ");
INSERT INTO mti_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Ne ano oraiwa atan anoeni, megara den eni. Ne ano kukaeba atanwa den anoeni, megara me ne eni. ");
INSERT INTO mti_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ne divi da den atan anoeniwa megara eniwa, me ne onan, megara kukaeba me ne gunap wakeiviwa aivi. ");
INSERT INTO mti_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Meoya ne imunap ano oraiwa atan anoeni, megara ne gwangwan yauna me ano kukaeba ne gunap wakene. ");
INSERT INTO mti_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Kuiyawa ne apan dananaba oya degadega eni God Gwangwan meuma gumbe. ");
INSERT INTO mti_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Megara kwapunwa danave gwangwan da wakene. Me mut aivi nonenmagawa gwangwaneba gaibu, sira aune, sira me ane ne nog abnawa me kukaeba gwangwaneba ankwatave wakenewa ana. Ne meib yaug anona. ");
INSERT INTO mti_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ae, ne anokukam abnawa! Bira ne bo mame kwapunwa gumbe waita nekpe? ");
INSERT INTO mti_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ne God gumbe Ayapan numa Iesu Keriso oya yusipamit gaun veni. Meoya ne nonenmagawa danave God Gwangwaneba nauwawa eni, megara kwapunwa danave kukaeba gwangwaneba nauwawa eni. ");
INSERT INTO mti_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Meoya gare mame di, Iesu gumbe anotumat eme igiyawa gumbo God wape mu kukaeba muma da onan. ");
INSERT INTO mti_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Kuiyawa Keriso Iesu gumbe, Guwawa inaiinaiba gwangwan meuma wakene, sira me ne yankwe nedne, kukaeba ge bo gwangwaneba gumbe. ");
INSERT INTO mti_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kwapunwa gumbe nu yutunwa onan, meoya Gwangwan oma den ane waita nunne, megara God waita nunne. God Usiwa baraune aig onne kukaeba numawa oya. Me nu minun kukaeba gaibu mina ane, meve kwapiwa gumbe kukaeba numa garawa aune onan di ane. ");
INSERT INTO mti_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nu Guwawa gumbe angete, kwapunwa anoanowawa gumbe onan. Me Gwangwan waiviwa undag nu gunup ape matattan oya. ");
INSERT INTO mti_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Bira da kwapiwa anowawa anog aiviwa abnawa me kwapiwa anoanowawa me mekut anog aivi. Bira da Guwawa anog aiviwa abnawa me Guwawa anoanowawa me mekut anog aivi. ");
INSERT INTO mti_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Kwapiwa anowawa oya anog aiviwa me bo. Guwawa anowawa oya anog aiviwa me inaiinai ge yum. ");
INSERT INTO mti_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Kuiyawa kwapiwa anowawa me God gumbe anavi aivi. Me God Gwangwaneba noiwa den avivi. Nu aib wata, me oma den ane noiwa aupe. ");
INSERT INTO mti_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Kwapiwa anowawa danave wakeiviwa abnawa oma den ane matai God me gumbe degadega ape. ");
INSERT INTO mti_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Megara God Guwawa ye none mageyap wakeiviwa, ye kwapuiwa gumbe onan, megara Guwawa gumbe. Bira da Keriso Guwawa den aunewa me Keriso meuma onan. ");
INSERT INTO mti_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Keriso guniyap wakeiviwa, ye kwapuiwa kukaeba gumbe bo ane, megara guwewa inai muteme oraiwa God namive gumbe. ");
INSERT INTO mti_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","God ane Iesu Keriso boriruwaya igiyawa gumbo sira inaine. Me Guwawa ye guniyap wakeiviwa, God ape ye kwapuiwa me bo apewa sira inai mutpe. Kuiyawa God me Iesu Keriso boriruwaya igiyawa gumbo sira inainewa. ");
INSERT INTO mti_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Meoya tatangwanen, nu kwapunwa noiwa autan den di anoete, meoya kwapunwa anowawa gumbe vin anigimtan den di anoete. ");
INSERT INTO mti_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ye kwapuiwa anowawa gumbe wakeigimiyawa, ye bo aya. Megara Guwawa gumbe, kwapuiwa aiviwa guriya boriruwape ipewa, ye inaigisia. ");
INSERT INTO mti_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Iyayapan bira da God amara muniviwa mu God usitainawa. ");
INSERT INTO mti_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ankwatave nau aivi abnawa guwawa me ape ye sira a aya. Ye guwawa meiba da den auyana, megara ye God Usiven atanwa me Guwawa auyana. Nu Guwawa gumbe watu, “Abba, Maman.” ");
INSERT INTO mti_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Guwawa membovit nunan taibe waivi guwunwa gaibu, nu God usitainawa. ");
INSERT INTO mti_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Nu usitainawa ipewa, nu kwan autan igiyawa gaibu. Eyawa autan oya nu Keriso gaibu edawai auete ipewa, nu God kwan autan igiyawa, sira Iesu Keriso gaibu kwan autan igiyawa. ");
INSERT INTO mti_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Kum ivi eyawa toewan numpe. Nu gare edawai gina ubeube auete. Edawai me kudnausiren, megara eyawa me kokavitwa. Ne meib di anoeni. ");
INSERT INTO mti_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","God wattenewa mu God usitainawa taibe uwatanwa oya nonomagowo amareme. ");
INSERT INTO mti_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","God wattenewa mu natawa onan ane. Me God anoano meuma gumbe ane, God wattenewa mu anoano muma onan. God ane mu noiwa auya, meoya mu owanowan gumbe. ");
INSERT INTO mti_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","God wattenewa mu mumbovit kwemne watkukamtan ebuwawa gumbe dauwag ampe. Mu mumbovit God usitainawa eyawa gumbe ui onan yai wakeigimpe. ");
INSERT INTO mti_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nu mamaib yaug anotu. God wattenewa mu danadawai aueme me apa onne gare mame. Ud yaitanwa gumbe edawai avig uiwa nikiaivi mina. ");
INSERT INTO mti_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Me mekut onan, megara mame gaibu. Nu numbovit Guwawa natawa autune, sira nu nonunmagawa apa unuwa nikiag amarete. God usitanawa atan oya. Natawa me nu sira gwiruwat nuntan. ");
INSERT INTO mti_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Nu waita nunne owanowan mame gumbe. Owanowan yavetewa me owanowan natawa onan. Bira da den autan anope wait aunewa oya. ");
INSERT INTO mti_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Divi da den yautunewa oya nu anoigimtawa, nu nonunmagawa apa iyagit amaraigimta. ");
INSERT INTO mti_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Guwawa me mina meib aivi. Me nu yutunwa onanwa oya waita nunivi. Nu den yaug anotu aninin nun watanwa. Megara Guwawa uiwa nikiyaiviwa gumbe,—gae gumbe oma den ane wata,—me gumbe waita nuntan oya nun waivi. ");
INSERT INTO mti_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","God me oma ane nonunmagawa undag yaug anoivi. Meoya God oma ane Guwawa aninin anoiviwa yaug anoivi. Kuiyawa Guwawa me God noiwa avivi, sira me gumbe iyayapan iyakaisi nunan nun waivi. ");
INSERT INTO mti_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","God gumbe baigan eme igiyawa, mu iyayapan mu God auwanewa God anoiviwa gumbe. God oma ane dividivi undag gumbo iyayapan munanwa oya nau ape sira garawa oraimina mumpe. Nu me yaug anotu. ");
INSERT INTO mti_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Kuiyawa God me iyayapan upeba wait yaug ano munne. Sira me wait anewa iyayapan mame irawa me matai Usiwa mina ape. Natawa me tatawaiwa obiren gumbo Usiwa me ud namotawa ape. ");
INSERT INTO mti_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","God me iyayapan mu God wait anog munan auwanewa auwane. God anog munan auwanewa igiyawa God ane oraimina aya. Meve God ane oraimina aya igiyawa gumbo eyawa munne. ");
INSERT INTO mti_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Gare mame me gumbe nu anin waton? God me nunanwa oya aiviwa, bira nu gunup anavi ape? ");
INSERT INTO mti_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","God me Usiwa desiromirenwa oya nonewa den aune nu nunan oya nunne. Me gaibu baigan gumbe dividivi undag ui onan den numpe go? Onan di. ");
INSERT INTO mti_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Bira God anog munan auwane igiyawa gumbo dirum watkukam munivi? God ane mu oraimina. ");
INSERT INTO mti_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Bira pui yuwamivi? Iesu Keriso bo ane, sira inaine. Me God naniyutanwa apa wakene, sira waita nuntan oya nun waivi. ");
INSERT INTO mti_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Bira God baigan meuma gumbe tam ube tenumpe. Me ibnawa go, danadawai go, edawai go, iyagon go, ui kwapiwavit go, tapon go, deba go? ");
INSERT INTO mti_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","“Genan oya nu bo yavete mumbe apa aig kum aigivi. Mu anoeme nu sip gureme mina.” meib tene. ");
INSERT INTO mti_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Megara God me nunan baigan aiviwa gumbe, dividivi mame undag danave, nu auta yusipamit. ");
INSERT INTO mti_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Ne mamaib anotumat eni. God baigan meuma me Ayapan numa Keriso Iesu apa wakenewa gumbe, bira da den tam ube tenumpe. Bo, inaiinai, aneya, kukaeba amareme igiyawa, gare mame di wakenewa, matai uwapewa, yusiwa da, painau, epampa, sira dividivi upeba me God wattenewa undag danave, mu oma den ane God baigan meuma gumbe den tam ube tenumpe. ");
INSERT INTO mti_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ne Keriso danave natawa di diruieni, uga mina onan. Ne nonenmagawa oraiwa gaibu mamaib Guwawa Iyakaisiyapama gumbe taibe veni. ");
INSERT INTO mti_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ne nonenmagave anogugut kokavitwa ag danadawai evedni aueni. ");
INSERT INTO mti_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ne den apopo ipawa ne Keriso gumbe ube anekpopo, tatanaiwa munan sira kwapunwa desiroma igiyawa munan. Ne den apopo ipawa ne diguragut abnawa munan. ");
INSERT INTO mti_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Mu Isuraeru igiyawa. Usitainaven atanwa, eyawa, God agiyawa iyayapan munan, Gwangwan autanwa, taparoro, ge agi mu mumawa. ");
INSERT INTO mti_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Isimuranaiwa mu mina mumawa. Keriso me mina kwapiwa gumbe mu gumbo uwane. Keriso mame me opa painau, sira God wattenewa undag mu ankwatave. Keriso me God me nu waiyaigimtan. Amen. ");
INSERT INTO mti_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Megara God gaiyawa me yusiwa onan den ane. Kuiyawa nu oma den ane wata Isuraeru apa onamiya igiyawa undag mu Isuraeru. ");
INSERT INTO mti_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Sira nu oma den ane wata Ebraam gumbe yaig onamiya igiyawa undag mu usitainawa. Kuiyawa me, “Aisak gumbe yaig onamiya igiyawa mu veme ge ututainagwa apa yaieg onamiyawa.” ");
INSERT INTO mti_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Natawa me ud kwapuwa gumbe yaiyawa mu God usitainawa onan. Ud agi gumbe yaieg onamiyawa mu usitainawa yaieg onamiyawa. ");
INSERT INTO mti_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Agi gaiyawa me mamaib. “Ne bairawan umaewa ne mapa sira taig onetna gare mame mina. Sira Seira kikiyan apan baraupe.” ");
INSERT INTO mti_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Mame mekut onan. Nu isimuranaiwa Aisak gumbe Rebeka bugane. ");
INSERT INTO mti_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Usitainawa mu den yaiya sira oraiwa ge kukaeba den aya kumiwa apa, Rebeka me umum anone, “Tatawa me gwaneba nau meuma atan abnawa ape.” Kuiyawa God anoiviwa me yusipamit yoivi, divi da atanwa gumbe onan, megara Ayapan me iyayapan munan auwaiviwa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","“Ne Jekob gumbe baigan ana, sira Eso anokukam ana,” meib tene. ");
INSERT INTO mti_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Meve nu anin waton? Ano kukaeba da God gumbe go onan? Onan di. ");
INSERT INTO mti_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","God me Mosisi gumbe wane, “Ne iyayapan ano muneniwa anomuneni, sira ne iyayapan mu nenan danadawai auemewa munan danadawai aueni.” ");
INSERT INTO mti_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Meoya iyayapan anoano mumawa emewa me natawa koka onan, megara God anoano meuma nuniviwa me natawa koka. ");
INSERT INTO mti_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Baiboru me Parao gumbe wane, “Ne ge agemna wan yoiya, kuiyawa ne imunap yutunwa toyau muntna ge gungap, sira at undag ne ivunwa yaug anope.” ");
INSERT INTO mti_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Mame mina, God me iyayapan ano meuma muntan anoiviwa ano meuma munivi, sira me iyayapan ano meuma muntan topayaiviwa munan topayaivi. ");
INSERT INTO mti_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ye ne gunap mamaib waya, “Meib aigimpe ipewa, divi oya God iyayapan gumbo pui yuwamivi? Bira me God yumateba topayane?” ");
INSERT INTO mti_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Megara apan. Ye God topayene. Ye bira? Wattenewa oma ane wape wattene abnawa gumbe, “Dimbae oya ge ne mameib anegana?” ");
INSERT INTO mti_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ui warivi abnawa me yusiwa gaibu go onan? Piyu gumbe me oma ane ui warampe dividivi oraiminawa oya, sira ui warampe dividivi kukaeba oya. ");
INSERT INTO mti_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","God mamaib anoivi ipewa, me aninin? God imive danapiriwape, sira yusiwa toyau mumpe. Megara anoano oraiwa koka gumbe uiwa nikiag amaraivi, sira me ui me God watkukamtan anoiviwa den watkukampe. ");
INSERT INTO mti_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Me gaibu eyawa koka toyau nuntan oya. Ui me ano muniviwa wakeya. God ui me wait tamibarip aneve wakeya. ");
INSERT INTO mti_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Nu ui me ano nuniviwa. God nunan auwane Ju igiyawa gumbo mu mukut onan megara Ju onan igiyawa mu gaibu. ");
INSERT INTO mti_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","26","Osea Bukaeba danave me waivi, “Mu ne iyayapan neuma onan, megara ne auwatnawa mu ne iyayapan neuma. Sira mu iyayapan mu ne den baigan munnawa, megara ne auwatnawa mu ne baigan muneniwa. Ne wana, ‘Ye ne iyayapan neuma onan.’ At desiroma apa, mu wape God wakeiviwa usitainawa.” ");
INSERT INTO mti_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Sira Isuraeru munan, Aisaya mamaib kwaruwane. “Isuraeru usitainawa mu obiren, poeman visive nuge mina. Megara iyayapan wakeyawa mukut mu waita mumpe. ");
INSERT INTO mti_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ayapan gae meuma undag aug oraimina sira tatevit ape piyu egave.” ");
INSERT INTO mti_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Sira Aisaya namu wane mina. “Ayapan yusipamitwa me utuntainunwa den numpa ipawa, nu Sodom mina apono, sira Gomora mina apono.” ");
INSERT INTO mti_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Nu me anin waton? Ju onan igiyawa mu oraiwa oya didimama den aya, megara oraiwa auya. Natawa mamaib, oraiwa me anotumat gumbe. ");
INSERT INTO mti_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Megara Isuraeru me oraiwa gwangwaneba diunewa mu oma den ane auya. ");
INSERT INTO mti_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Divi oya? Kuiyawa mu anotumat gumbe den diuya, megara mu dividivi atanwa minawa gumbe diuya. Mu amawa totariyatanwa an me gumbe amowa toya. ");
INSERT INTO mti_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Me mamaib tenewa mina. “Yauya. Ne Saion apa amawa totariyatanwa anawa ge an koka me ape uyug aigatanwa tetna. Bira da me gumbe anotumat ape ipewa, me ubmam den ape.” ");
INSERT INTO mti_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Tatangwanen. Ne nonenmagawa anowawa, God gumbe Isuraeru igiyawa munan nun watanwa, mu waita aupe. ");
INSERT INTO mti_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ne yaug anog taibe veniwa mu God gumbe degadegaepam waiya eme. Megara me gigirum anowawa gumbe onan. ");
INSERT INTO mti_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Kuiyawa mu God oraiwa meuma den yaug anoya, sira mu God oraiwa meuma gumbe noiwa den auya. Kuiyawa mu imuwo oraiwa mu mukut tamtan oya anoya. ");
INSERT INTO mti_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Keriso me ane Gwangwan onanane, meoya anotumat igiyawa undag God namive oraimina ape. ");
INSERT INTO mti_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mosisi tenewa, Gwangwan oraiwa eme igiyawa inai mutpe oraiwa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Megara anotumat oraiwa meuma mamaib waivi. “Ye den waya nonemageyap bira kwimin dog aitan?” Natawa me mameib, Keriso kwimin apa aug aig ontan oya. ");
INSERT INTO mti_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Sira, “Ye den waya bira piyu nog epampa aikpe,” Natawa me mameib, Keriso boriruwaya igiyawa gumbo dauwape. ");
INSERT INTO mti_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Megara anin waivi? “Gae gungap, nogap sira nonenmagave wakene.” Mame me anotumat numawa gaiyawa me nu wateteyametewa. ");
INSERT INTO mti_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kuiyawa ge nogap, “Iesu me Ayapan,” vegewa, sira nonegap, “God ane Iesu boriruwayawa igiyawa gumbo sira inaine,” anotumat egewa, ge waita auwa. ");
INSERT INTO mti_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Apan nonenmagave anotumat apewa, God namive oraiwa aupe. Sira noiwa gumbe taibe waiviwa waita aupe. ");
INSERT INTO mti_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Baiboru mamaib waivi, “Me gumbe anotumat aivi abnawa me matai ubmam den ape.” ");
INSERT INTO mti_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ju igiyawa ge Ju onan igiyawa mu yapowo ubeube onan. Ayapan desiroma me iyayapan undag Ayapanowa. Ayapan oya auveme igiyawa undag munanwa Me ano oraiwa kokavit. ");
INSERT INTO mti_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Kuiyawa, “Bira da Ayapan oya auwaiviwa me waita aupe.” ");
INSERT INTO mti_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Megara me gumbe anotumat den ayawa, aninin mu me gumbe oma ane auwape? Mu me gumbe den anoyawa, aninin me gumbe oma ane anotumat ape? Wateteyamivi abnawa den wakenewa, aninin oma ane anope. ");
INSERT INTO mti_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Bira da den baraug aipewa, aninin akape wateteyampe? Mamaib tene, “Iyayapan mu gae oraiwa aug omomewa amowa me oraivitwa.” ");
INSERT INTO mti_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Iyayapan obiren gae oraiminawa auya, megara upeba mu den auya. Aisaya wanewa, “Ayapan, bira gae numawa anotumat ane?” ");
INSERT INTO mti_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Me meib. Anotumat me anoano apa amatope, sira anoano me Keriso gaiyawa gumbe amatope. ");
INSERT INTO mti_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Megara ne singui watna, “Mu den anoya?” Onan di. “Nouwa at piyu egave undag. Mu gae muma amiya at piyu viri pusiwa.” ");
INSERT INTO mti_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Megara ne mamaib watna. “Isuraeru mu den yaug anoya go?” Namuiren, Mosisi mamaib wane. “Ne atna ge degadega den a, den watgomiyamunne igiyawa gumbo. Sira ne atna ye danepiriwape, iyayapan mu anoano den yaug anoemewa gumbo.” ");
INSERT INTO mti_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Sira Aisaya yusipamit waivi. “Ne nenan didimama den eme igiyawa ne yaunegiya, sira ne nenan den autan anoeme igiyawa gumbo ne taibe toyau munna.” ");
INSERT INTO mti_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Sira Isuraeru gumbe mamaib waivi, “Iyayapan mu nounwa den aueme sira anavi eme, megara ne naninwa mu gumbo kum desirom danave munna.” ");
INSERT INTO mti_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Meve ne watna, God me iyayapan meuma topai munne? Onan di. Ne gaibu Isuraeru abnawa, sira Ebraam yaig onnewa, Benjamin dam meuma gumbe onnewa. ");
INSERT INTO mti_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","God me iyayapan meuma mu wait yaug anonewa den topai munne. Ye Baiboru danave Eraija oya tenewa apa aninin waivinewa den yaug anoyana. Me God gumbe Isuraeru pui yug wane. ");
INSERT INTO mti_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Ayapan, mu propeta geuma guriya boriruwaya, sira kem geuma iyakaisiyapama aueg tobiroriyaya. Ne nekut kwenegiya. Mu tonektanwa oya a ge yaug eme.” ");
INSERT INTO mti_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Megara me gumbe garawa anin wane? “Ne nenan iyayapan 7,000 amareni wakeya. Mu Baaru gumbe den konuwa yueme.” ");
INSERT INTO mti_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Ebu desiroma, gare mame di iyayapan mu God ano oraiwa gumbe amaraivi wakeemewa mu meib di wakeya. ");
INSERT INTO mti_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Me ano oraiwa gumbe ipewa, me divi da atanwa gumbe onan di. Me meib onan ipewa, ano oraiwa me ano oraiwa onan. ");
INSERT INTO mti_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Meve me aninin? Isuraeru mu oma den ane auya divi da autan oya anoemewa. God wat gomiyanewa igiyawa mu auya, megara iyayapan upeba nonomagowa yaigiwane. ");
INSERT INTO mti_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Mamaib tene, “God me guwowa yusi onanwa munne, yangowo mu den yaupewa munne, sira naunowo mu den anotanwa munne. Gare mame apa onnewa.” ");
INSERT INTO mti_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Devid gaibu aib waivi. “Teboro mumawa mu munan nama ape, gue katau ape, divi da amawa totariyatanwa anawa ape, sira garawa muma ape. ");
INSERT INTO mti_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Mu yangowa muniwape sira mu oma den ane yaupe. Mu daiyowa gegerai mutpe meib di wakeigimpe.” ");
INSERT INTO mti_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Sira singui watna. Mu amowa totainewa uyug aigtan oya? Onan di. Mu Gwangwan togomiyaya, me gumbe waita Ju onan igiyawa gumbo onamiya. Me mu kwemiya Isuraeru kwavi atan oya. ");
INSERT INTO mti_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Mu Gwangwan togomiyayawa me piyu mame tawara muma oya, sira mu waropiyayawa me Ju onan igiyawa tawara muma oya. Meoya mu waita autanwa me obiren egave tawara kokavitwa autan oya. ");
INSERT INTO mti_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Meoya ne Ju onan igiyawa yenan veni. Ne Ju onan igiyawa munan apasoro ana, meoya ne anoeniwa nau neuma me koka. ");
INSERT INTO mti_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Sira me gumbe, ne imunap wakenewa, ne atna iyayapan neuma kwavi ape. Sira ne imunap atna iyayapan upeba yapowo waita aupe. ");
INSERT INTO mti_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Mu epa aore muntanwa me piyu mame yum tutanwa oya ipewa, mu tamtanwa me bo gumbe sira yoipewa. Natawa meib. ");
INSERT INTO mti_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Wiit maura namuirenwa me iyakaisiyapama ipewa, nakwai wiit atapupu undag me iyakaisiyapama. Taiwa me iyakaisiyapama ipewa, yoma naniwa gaibu me iyakaisiyapama. ");
INSERT INTO mti_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Yoma naniwa upeba tentamag aigiya sira ye yoma Orivu mundanavewa me gumbe yunad yenne, sira yoma Orivu taiwa gumbe mumin dauwaivi ye avigimiya ipewa, ");
INSERT INTO mti_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ye oma den ane apanapan aigimiya yoma naniwa gumbe. Ye taiwa den waita wanene, megara taiwa me waita yenivi. ");
INSERT INTO mti_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ye waya, yoma naniwa togomiyayawa me ne yunatanwa oya. ");
INSERT INTO mti_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Me meib. Mu togomiyayawa mu anotumat onanwa gumbe, megara ye anotumat yeuma gumbe yokeene. Ye apanapan den aya, megara a aya. ");
INSERT INTO mti_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","God naniwa namu wakenewa gwagwai den tupawa, me ye yenan oya gwagwai den tupe. ");
INSERT INTO mti_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Yauya. God baigan meuma ge yaigipamitwa. Iyayapan uyug aigemewa egowo wakenewa me yaigipamitwa. Ye egeyap wakenewa me God baigan meuma. Ye me danave wakeigimiya ipewa, me meib di wakeigimiya. Megara ye meib den ayawa, ye gaibu togomiyape. ");
INSERT INTO mti_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Sira mu anotumat onanwa den amaraigimpewa, mu matai yunat ape. God oma ane mu sira yunat mumpe. ");
INSERT INTO mti_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Mundana yoma Orivu gumbe togomiya yenne, sira Orivu nau danavewa gumbe yunat yenne ipewa, Orivu nau danavewa naniwa me yoma Orivu namuwa gumbe sira yunat ape. Me taibe yaigiwa onan. ");
INSERT INTO mti_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Tatangwanen, ne imunap, ye guwavewa mame yaug anotanit di. Ye aib den anoya ye ano kokawa igiyawa. Guwavewa mame natawa mamaib, Isuraeru igiyawa upeba nonomagowa yaigiwane, sira Ju onan igiyawa anintom mina obiren apewa, Isuraeru igiyawa nonomagowa yaigiwanewa me onanape. ");
INSERT INTO mti_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Mamaib Isuraeru undag matai waita aupe. Mamaib tene, “Munan parau viniviwa me Saion apa uwape, sira me Jekob gumbe tobiyape God gumbe anotumat den atanwa me aug epa aorepe. ");
INSERT INTO mti_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Mame me ne agi neumawa mu munan munnawa. Me apa ne kukaeba mumawa atan autna.” ");
INSERT INTO mti_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Gae oraiwa gumbe, mu God gumbe anavi eme igiyawa ye yenan. Megara God watgomiya munnewa gumbe, mu God baigan muniviwa isimuranowa gumbo. ");
INSERT INTO mti_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","God puyo nunnewa ge God nunan auwaiviwa me den di tobiroriyape. ");
INSERT INTO mti_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","31","Ye namu God gumbe noiwa den auyana, megara gare mame ye ano yemiviwa me gumbe auene mu noiwa den aueme gumbe. Mame mina mu gare mame noiwa den aueme, me mu mumbo gaibu ano muniviwa autan oya, ano yemiviwa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kuiyawa God anoiviwa me iyayapan undag gumbo ano munigimpe, meoya God ane iyayapan undag noiwa den aueme. ");
INSERT INTO mti_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","God tawaraeba—God anoano oraiwa ge God ano meuma— me epampa aninin! Keptete me nu undag matai oma den ane yaug anota. Ebu meuma me mina, nu oma den ane matai popon yuta. ");
INSERT INTO mti_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Kuiyawa bira Ayapan nonewa yaug anotan? Sira bira Ayapan waitaeba ane? ");
INSERT INTO mti_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Sira bira God gumbe namu divi da wanne, meve garawa sira aupe? ");
INSERT INTO mti_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kuiyawa dividivi undag mu God apa, God gumbe, God oya wakeya. Eyawa me God mame gumbe wakeigimpe viripusiwa onan. Amen. ");
INSERT INTO mti_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Meoya tatangwanen, ne ye diruieni, God anoyeniviwa oya. Ye aya ye kwapuiwa me wakeiviwa ge iyakaisiyapama ge God aupewa puyowaven ape. Meve ye kwapuiwa puyowawa God gumbe puyo waniya. Me ye guwewa waiya waiyaeba. ");
INSERT INTO mti_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ye piyu mame ebuwawa mina den auya. Megara God anoiviwa yaug anotan oya, dimbae me oraimina sira dimbae God aupe, dimbae oraiminavitwa yaug anotan oya, ye nonewa mataiwa tobiyaya. ");
INSERT INTO mti_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","God ano oraiwa me ne nednewa gumbe, ye undag desirom desirom ne wat diruiene. Ye yembovit apanapan yeuma oya den yaug anoya, anoano yeuma gumbe wakeya. Megara ye mokona atanwa ebuwawa yaug anopono, anotumat yeuma me God yennewa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","5","Kwapunwa desirom, megara danave obiren. Desirom desirom nau muma ube ube. Mame mina, nu obiren, megara Keriso gumbe nu kwapunwa desirom. Nu desirom desirom me yunat tunewa. ");
INSERT INTO mti_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Ano oraiwa nunnewa gumbe nu puyo ube autu. Meoya me God gaiyawa watanwa ipewa, anotumat gumbe ye waya. ");
INSERT INTO mti_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Me nau atanwa ipewa me nau aigimiya, sira toewanewan ipewa me toewan munigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Wag dia yusiwa muntanwa ipewa ye wag dirumigimiya. Keb atanwa ipewa me keb aigimiya umu onan. Kokawa atanwa ipewa me yaimoyai kokawa aya. Waita muntanwa ipewa me waita munigimiya degadega gumbe. ");
INSERT INTO mti_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Baigan gumbe wakeyawa, uga den waigimiya. Ye kukaeba topai aigimiya, sira oraiwa autanwa me avigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Tatangwanen baiganowa gumbe baigan garagara aya. Ayamat gumbe ayamat garagara aya. Ye desirom desirom yaug anoya iyayapan mu tam waiya munigimiya yembo den waiya yemigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ye nau yaigipamit aigimiya, sira guwagwa gumbe iyam mina igigimiya, Ayapan gumbe nau meuma aigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Owanowan gumbe degadega aigimiya. Edawai gumbe uiwa nikiyaigimiya. Evedni nun waigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Iyapan iyakaisi ano mumawa me divi waita muniya. Amdau igiyawa gumbo baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Iyayapan mu ye edawai yenemewa gumbo waribiya muniya. Waribiya muntanit di, megara kukaeba oya den nun waya. ");
INSERT INTO mti_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ye degadega aya degadega eme igiyawa gaibu. Ye iruwaya iruveme igiyawa gaibu. ");
INSERT INTO mti_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Ye undag nonewa desirom ape, apanapan den aya, megara ye ankwatave igiyawa gumbo naniga aviyaya. Ye yaug anoya ye anoano igiyawa onan. ");
INSERT INTO mti_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Bira da kukaeba anewa oya ye kukaeba den aya. Ye iyayapan undag gumbo oraivit aya. Dividivi undag me iyayapan anoeme oraivitwa, ye me aigimiya. ");
INSERT INTO mti_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Oma ape ipewa, ye iyayapan undag gumbo yum tuya yenanwa oya. ");
INSERT INTO mti_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Iyayapan neuma, ye yekut garawa kukaeba den aya. Megara God nanive barauya. Kuiyawa mamaib tene. “Garawa atanwa me neuma. Ne garawa atna, Ayapan meib waivi.” ");
INSERT INTO mti_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Anavi yeuma iyagon aupewa, me nakwai waniya. Anavi yeuma meyawa toyaipewa, me yoi waniya. Mamaib aigimiyawa gumbe, ye me kuiyave kapupun igiviwa teya. ");
INSERT INTO mti_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kukaeba den painau tuyauyempe. Megara ye oraiwa yeuma gumbe kukaeba painau tuyauya. ");
INSERT INTO mti_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Iyayapan undag mu yutuwa me painau wakeiviwa me noiwa autanit di. Yutuwa me God gumbe. Yutuwa undag mu wakeemewa me God a munne. ");
INSERT INTO mti_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Meoya iyayapan mu yusiwa gumbe toemewa mu God gwangwan meuma togomieme. Togomieme igiyawa mu mukut pui aupe. ");
INSERT INTO mti_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ye kukaeba ayawa, matai namuyoiyoi abnawa gumbe a aya. Ye oraiminawa ayawa, a den aya. Ye yusiwa gumbe a den atan anoenewa, oraimina aigimiya. Meib ayawa, apan koka yusiwa gaibu me matai ye bainda yempe. ");
INSERT INTO mti_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Kuiyawa me God nauwawa aivi abnawa me garawa oraiwa agempe. Ge kukaeba aigimawa, me gumbe a a. Me deba ui onan den avivi. Natawa me God nauwawa aivi abnawa, sira kukaeba eme igiyawa gumbo diguragut gumbe garawa mumpe. ");
INSERT INTO mti_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Meoya ye noiwa autanit di. Diguragut gumbe a atanwa gumbe mekut onan, megara ye nonemagewa oraimina gumbe noiwa autanit di. ");
INSERT INTO mti_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ebu me desiroma gumbe, ye takesi barautanit di. Mu God nau meuma eme igiyawa mu nau muma yaigipamit evedni emewa. ");
INSERT INTO mti_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ye iyayapan gumbo nau yeuma di aigimiya. Bira da takesi barautan wapewa, ye me di barautanit di. Bira da dividivi takesiyawa barautan wapewa, ye barautanit di. A atanwa me a aya. Ayamat atanwa me ayamat aya. ");
INSERT INTO mti_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Divi da ove gumbo auyanawa, tate sira muniya. Megara baigan me meib di wakepe. Me ube. Iyayapan upeba gumbo baigan muneme igiyawa mu Gwangwan bainda di amareme. ");
INSERT INTO mti_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","“Uinantaraki den aya, den toya boipe, ub den aya, nunit den waigimiya,” gwangwan mame me wakeya, sira gwangwan upeba wakeya, megara gwangwan mame me gwangwan upeba gaibu toborane, “Ge iyayapan baigan munigima ge gembo baigan niege mina.” ");
INSERT INTO mti_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Baigan me iyayapan gumbo den watkukamivi. Meoya baigan me Gwangwan gumbe oraiminavit aivi. ");
INSERT INTO mti_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Kum mame garewa ye yaug anoyana me divi, meoya ye meib di aigimiya. Ye kub gumbe wan yoitan kumiwa me koni aivi. Nu anotumat atu kumiwa apa waita me painau, megara gare waita kumiwa me koni di aivi. ");
INSERT INTO mti_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Aram onanaivi, sira wantetanwa koni aivi. Meoya aram anoanowawa yankweta, sira eyawa mut wapeyawa enta. ");
INSERT INTO mti_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Ui onan wakeetewa, yoi yaigipama netewa, uinantaraki etewa, uinantaraki oya anoetewa, mut etewa, sira yano anoetewa, mame me wakewake kukaeba anoanowawa, meoya me aug epa aoreta. Meve kum wakewake oraimina meuma oya wakeigimta. ");
INSERT INTO mti_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ayapan Iesu Keriso aug eniya. Kwapuiwa anowawa kukaeba oya den anog aigimiya. ");
INSERT INTO mti_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ye bira anotumat meuma yusi uwanewa auya. Anoano meuma den topai aya. ");
INSERT INTO mti_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Bira da anoiviwa dividivi undag me oma ane naigimpe, megara yutu onan abnawa me nakwai mekut naivi. ");
INSERT INTO mti_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Naivi abnawa me den naivi abnawa den di yan yaupe. Sira den naivi abnawa me naivi abnawa den di yan yaupe. Kuiyawa God me aune. ");
INSERT INTO mti_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ge pui yuege. Ge bira? Ge diwan apan da nauwawa aivinewa pui yuege? Me yoipe go wakepe, me kokawa meuma me mekut amara wanivi. Me wan yoipe. Kuiyawa Ayapan oma ane wape me wan yoipe. ");
INSERT INTO mti_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Apan da anoiviwa kum da me ano kokawa, sira kum upeba me mina onan. Apan upeba anoemewa kum undag me desirom di. Ye desirom desirom ye yembovit ano yeuma gumbe. ");
INSERT INTO mti_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Bira da kum amaraiviwa me meib aivi Ayapan oya. Bira da nakwai naiviwa me meib aivi Ayapan oya. Kuiyawa me God gumbe gaun waivi. Bira da nakwai den naiviwa me meib aivi Ayapan oya. Me gaibu God gumbe gaun waivi. ");
INSERT INTO mti_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Nu bira da numbovit ano numa oya den wakeete. Sira Nu bira da numbovit ano numa oya bo den ata. ");
INSERT INTO mti_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Nu wakeigimta ipewa, nu Ayapan oya wakeigimta. Nu bo atawa, nu Ayapan oya bo ata. Kuiyawa nu waketawa go boriruwatawa me Ayapan oya. ");
INSERT INTO mti_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Keriso boane sira inaine. Me Ayapan atan oya boriruwayawa igiyawa ge wakeemewa igiyawa munan. ");
INSERT INTO mti_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Me meib. Megara ge divi oya tatagaiwa pui yu munege? Sira ge divi oya tatagaiwa yan yawamege? Nu undag God keptete arawa apa namive yoketa. ");
INSERT INTO mti_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Mamaib tene. “Ayapan waivi. Ne yangan kani wakeeni. Ne namunap konuwa undag yupe, sira pednowa undag God waiya ape.” ");
INSERT INTO mti_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Me meib. Meoya nu nunanwa oya God gumbe matai wata. ");
INSERT INTO mti_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Meoya nu pui gara yu den aigimta. Megara egave upeba gaibu ata. Tateaiwa munan ebu boratanwa den boriya, tog uyug aigatanwa den barauya. Me yaug anotanit di. ");
INSERT INTO mti_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Ayapan Iesu gumbe ne yaug anona sira yusipamit anoeniwa, God namive nakwai ge mae undag kukaeba da den wakene. Undag me oraimina. Apan da me mekut nakwai kukaeba yaug anope ipewa, me me gumbe me miyot. ");
INSERT INTO mti_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ge tatag nakwai geuma oya anopipanum aiviwa, ge baigan gumbe amat den ege. Keriso me menan boane. Nakwai geuma anoanowawa gumbe me den watkukama. ");
INSERT INTO mti_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Meoya ge divi oraiwa yaug anoegewa gumbe iyayapan upeba den kwema ge yan yawakpe. ");
INSERT INTO mti_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Kuiyawa God toimuwawa me nakwai ge yoi naigimtanwa anowawa onan, megara oraiwa ge yum ge degadega Guwawa Iyakaisiyapama gumbe. ");
INSERT INTO mti_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Mame mina, Keriso nau meuma eme igiyawa mu God waiya munivi, sira iyayapan mu auya. ");
INSERT INTO mti_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Meoya yum atanwa oya oraiminawa, guwawa gumbe yaig yoitan oya oraiminawa, mu munan nu nau yaigipamit aigimta. ");
INSERT INTO mti_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Nakwai mae anoanowawa gumbe God nauwawa den wakukamiya. Undag mu oraimina, miyot onan. Divi natanwa gumbe apan da uyug aikpe ipewa, nakwai mae me oraimina onan, me kukaeba. ");
INSERT INTO mti_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Mae den natanwa, wain den natanwa, sira tatag uyug aigtanwa oya divi da den atanwa mu oraimina. ");
INSERT INTO mti_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Anotumat ge auwanawa God namive amaraigima. Me ge anotumat geuma, meib gungap wakeigimpe. Apan da bira waribiyapewa me membovit me divi aunewa gumbe pui den aupewa. ");
INSERT INTO mti_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Megara apan da bira ano pipanum aiviwa gumbe naiviwa, me kukaeba abnawa ape. Kuiyawa me anotumat meuma gumbe den onne. Dividivi undag me anotumat gumbe den onnewa me kukaeba. ");
INSERT INTO mti_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nu iyayapan yutumpama me iyayapan yutu onanwa gumbo iyaiyai ag waita muntanit di. Me gumbe numbo degadega den ata. ");
INSERT INTO mti_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Nu desirom desirom owanaiwa dega munta, mu oraiwa muma me divi nu yaug anota, mu sig dotan oya munan anota. ");
INSERT INTO mti_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Keriso me membo den wat degayane. Megara wait tenewa mina, “Diguragut dirueme igiyawa diguragut mumawa me eganap onne.” ");
INSERT INTO mti_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Wait tenewa undag me toewan nuntan oya tene. Baiboru oma ane uiwa nikiatanwa ge yusiwa wantanwa munivi. Me gumbe nu owanowan autan oya tene. ");
INSERT INTO mti_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Ne imunap meib, God me unuwa nikiaigimtanwa ge yusiwa nuntanwa nuniviwa, me ape ye anoano meiba desiroma auya, ye da da Keriso Iesu amave aisiene mina. ");
INSERT INTO mti_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Me ye nonewa desirom ape, noiwa desirom ape, Ayapan numa Iesu Keriso Mamawa God waiyatan oya. ");
INSERT INTO mti_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Keriso tam nunne God eyawa oya. Mame mina, ye gara tam aya. ");
INSERT INTO mti_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Ne veni. God natawa meuma toewan muntan oya, Keriso me kwapituitui igiyawa nauwawa aivi abnawa ane. Me agi me isimuranaiwa gumbo munnewa sira yaug anog kiniyatan oya. ");
INSERT INTO mti_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Sira me, God ano munnewa gumbe, Ju onan igiyawa gaibu God waiyatan oya. Meib tenewa mina, “Meoya ne Ju onan igiyawa danave ne ge watdega gentna, sira ivugwa gumbe bererin tog waiya gentna.” ");
INSERT INTO mti_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Sira mameib tene, “Ju onan igiyawa, Ayapan igiyawa gaibu degadega aya.” ");
INSERT INTO mti_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Sira tenewa, “Ju onan igiyawa undag, Ayapan watdega aya. At undag igiyawa, bererin tog watdega waniya.” ");
INSERT INTO mti_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Sira Aisaya mame waivi, “Jesi taiwa meuma matai dauwag yoipe. Me apan me Ju onan igiyawa amara muntan oya wan yoipewa. Ju onan igiyawa me gumbe owanowan avigimpe.” ");
INSERT INTO mti_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ne aib anoeni, Owanowan Goddeba me degadega undag ge yum undag anotumat gumbe ye yempe guniyap noidauwape, sira Guwawa Iyakaisiyapama yusiwa gumbe ye owanowan yempe guniyap noidauwape. ");
INSERT INTO mti_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Tatangwanen. Ne aib yusipamit anoeni. Ye guniyap oraiminavitwa noidauwane, ye guniyap anoano noidauwane, sira ye oma ane gara toewanewan ene. ");
INSERT INTO mti_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Ne upeba yusipamit tena. Me ye yaug anoigimtanwa oya. ");
INSERT INTO mti_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Kuiyawa God gumbe ne ano oraiwa auna, Ju onan igiyawa munan Keriso nauwawa abnawa atan oya. God gae oraiwa gumbe, ne pirisi nauwawa eni. Me Ju onan igiyawa mu God puyo maeba me Guwawa Iyakaisiyapama gumbe iyakaisi anewa ape oya. ");
INSERT INTO mti_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","God nauwawa eni oya, ne Keriso gumbe degadega eni. ");
INSERT INTO mti_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","God ne anegivi. Me ne gunap Keriso ane Ju onan igiyawa mokona aya oya. Gae upeba watan me den anoeni. Keriso nau ane gae ge anoano atanwa gumbe. ");
INSERT INTO mti_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Sira me nau ane, yautanwa ge irayauyau yusiwa gumbe sira Guwawa yusiwa gumbe. Meib ne Keriso gaiyawa oraiwa wateteyameni, Jerusarem apa onne Iririkam at undag. ");
INSERT INTO mti_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Mame mina, ne den sina iyayapan upeba wait nium barauya arawa egave. Kuiyawa ne imunap, ne gae oraiwa wateteyampna Keriso iviwa den yaug anoya arawa apa. ");
INSERT INTO mti_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Me mamaib tenewa mina. “Me gumbe bira da den wane anoyawa yaupe, sira den anoya igiyawa yaug anope.” ");
INSERT INTO mti_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Mameiba oya, ne tobod nedne, meoya oma den ane yenan onedna. ");
INSERT INTO mti_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Gare mame, ne nau atanwa arawa me mapa at da sira onan di, sira watavit ampa ne ye yau yemtan oya anoeni. ");
INSERT INTO mti_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Ne at Spein aneknawa me ne oneg guniyap uwatna. Kuiyawa ne imunap anonawa, guniyap waketna kum kusida, sira nonenmagawa degadega gumbe apenam watna, sira yaunekpe anetna, meve ne me apa anekna. ");
INSERT INTO mti_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Megara gare mame, ne Jerusarem angetan eni iyayapan iyakaisi gumbo nau atan oya. ");
INSERT INTO mti_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Kuiyawa at Masedonia ge at Akaia igiyawa degadega gumbe puyo agoniyaya, pukpuk wagawag igiyawa mu iyayapan iyakaisi igiyawa Jerusarem apa wakeyawa, mu yapowo wakeyawa munan. ");
INSERT INTO mti_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Mu degadega gumbe aya, sira mu iyayapan munan nau muma auya. Guwawa gumbe, Ju onan igiyawa mu iyayapan gumbo divi da auya, meoya mu tawara gumbe waita muntanit di. ");
INSERT INTO mti_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Meoya namu ne me atna, magawa mame muntna, ivi yenan amdau onetna sira at Spein anekna. ");
INSERT INTO mti_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Ne mamaib anotumat eni, ne yenan amdau onetnawa, ne Keriso waribiyaeba noidauwanewa yenan aug onetna. ");
INSERT INTO mti_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Tatangwanen. Ne nonenmagawa gumbe, Ayapan numa Iesu Keriso gumbe sira Guwawa baiganeba gumbe nun veni. Ne nenanwa nun veni, garawapa ye gaibu nenan yusipamit God gumbe nun waigimiya. ");
INSERT INTO mti_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ne imunap, ne oma ane waita nekpe, anotumat onan igiyawa Judia apa gumbo. Sira ne imunap, ne nau neuma Jerusarem oya eniwa, me oya iyayapan iyakaisi mu bainda wag aupe. ");
INSERT INTO mti_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Me onanapeve, God anoanowawa gumbe, degadega gumbe yenan ongetan anoeni. Sira guniyap nonenwa emtan anoeni. ");
INSERT INTO mti_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ne imunap Yum Goddeba me ye undag guniyap wakeigimpe. Amen. ");
INSERT INTO mti_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Nu yogiyunwa Pibe me siosi kansoru wakenewa Senkrea apa, ne me wag waita waneni yenan. ");
INSERT INTO mti_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Garawapa Ayapan gumbe, ebu oraiwa me iyayapan iyakaisi oya me gumbe vesin mame baigan niyaya. Sira vesin mame divi da guniyap autan anoiviwa me waita waniya. Vesin mame me iyayapan obiren waita munne, sira ne gaibu waita nedne. ");
INSERT INTO mti_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Keriso Iesu gumbe Prisira ge Akuira mu ne gaibu nau desiroma. Garawapono baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Iyayapan mame ne inaiinai neuma oya inaiinai muma topayag waita negiya. Ne nekut onan, megara Ju onan igiyawa siosi mumawa undag mu gumbo gaun veme. ");
INSERT INTO mti_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Sira ye garawapono siosi mu gweyowo wakeyawa gumbo baigan muniya. Ne evenwa nonenmagawa Epaenetas gumbe baigan niyaya. Apan mame me namuirenwa me Esia danave Keriso gumbe anotumat anewa. ");
INSERT INTO mti_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Meri gumbe baigan niyaya. Me yenanwa nau yaigipamit ane. ");
INSERT INTO mti_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Andronikas ge Junias gumbo baigan muniya. Mu at desiroma igiyawa ne gaibu, sira nu nog apa undagit tenuniya. Apasoro mu iyayapan mame yaug ano muniya mu ivuwa koka. Mu namu Keriso gumbe wakeemewa, ne ivi. ");
INSERT INTO mti_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Keriso gumbe ne evenwa nonenmagawa Ampriatas gumbe baigan niyaya. ");
INSERT INTO mti_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Keriso gumbe Ubruanus me ne gaibu nau desiroma, sira ne evenwa nonenmagawa Stakis, mu baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Aperes me Keriso ag yaune sira me aunewa, me baigan waniya. Aristoburas gweyawa igiyawa mu baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Erodion me at neuma desiroma, me baigan waniya. Narukisas gweyawa igiyawa mu Keriso gumbe wakeyawa mu baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Tripena ge Triposa mu Keriso gumbe nau yaigipamit emewa mu baigan muniya. Evenwa Pasis me Keriso gumbe yusipamit nau anewa, me baigan waniya. ");
INSERT INTO mti_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Rupas me God watgomiyanewa me baigan waniya. Sira me inawa ne inanwa mina, me baigan waniya. ");
INSERT INTO mti_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Asinkritas, Peregon, Erumes, Patrobas, Erumas sira tatawaviwa gaibu mu baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Pirorogas, Juria, Nereus ge yogiyawa, sira Orimpas ge iyayapan iyakaisiyapama undag, mu gaibu baigan muniya. ");
INSERT INTO mti_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Uwatoto iyakaisi gumbe baigan gara gara aya. Keriso siosi undag mu baigan ye neme. ");
INSERT INTO mti_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Tatangwanen. Ne ye diruitna. Ye toewanewan yaug anoyana. Iyayapan upeba toewanewan anotan den anoeme. Mu veme mu mina ube, sira iyayapan uyug aikpe oya divi da baraupe. Meoya yaimoyai mu munan yaukape. Mu yankwemiya. ");
INSERT INTO mti_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Iyayapan meiba mu Ayapan numa Keriso nauwawa den eme, megara mu mumbo anoano muma gumbe nau eme. Gae memeyu ge gae me ape iyayapan degadega atanwa, gae mame gumbe mu mokona igiyawa mu ugai m