﻿USE sofia;
DROP TABLE IF EXISTS sofia.mta_vpl;
CREATE TABLE mta_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES mta_vpl WRITE;
INSERT INTO mta_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Na, ini sa medoo tupù i Hésus Kelistu. Si Hésus sa tugod i Datù Dabid, owoy si Dabid sa tugod i Ablaham. ");
INSERT INTO mta_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Na, umanak Ablaham i si Isak. Umanak Isak i si Hakob. Umanak Hakob i si Huda owoy sa medoo hadi di. ");
INSERT INTO mta_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iya sa anak i Huda owoy si Tamal sawa di, si Palés owoy si Sala. Umanak Palés i si Islon. Umanak Islon i si Alam. ");
INSERT INTO mta_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Umanak Alam i si Aminadab. Umanak Aminadab i si Naason. Umanak Naason i si Salmon. ");
INSERT INTO mta_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Iya sa anak i Salmon owoy si Lahab sawa di, si Boos. Iya sa anak i Boos owoy si Lut sawa di, si Obéd. Umanak Obéd i si Hési. ");
INSERT INTO mta_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Umanak Hési i si Datù Dabid. Na, umanak Dabid i si Salomon owoy iya sa inay di sa tapay sawa i Uliya sinawa i Dabid. ");
INSERT INTO mta_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Umanak Salomon i si Loboam. Umanak Loboam i si Abiya. Umanak Abiya i si Asa. ");
INSERT INTO mta_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Umanak Asa i si Hosapat. Umanak Hosapat i si Holam. Umanak Holam i si Usiyas. ");
INSERT INTO mta_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Umanak Usiyas i si Hotam. Umanak Hotam i si Akas. Umanak Akas i si Isikiyas. ");
INSERT INTO mta_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Umanak Isikiyas i si Manasa. Umanak Manasa i si Amon. Umanak Amon i si Hosiya. ");
INSERT INTO mta_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Umanak Hosiya i si Hékoniyas owoy sa medoo hadi di. Iya ma sa egoh da nesigkem owoy medoo duma da etaw Hudiyu owoy inuwit da dutu mediyù dò diyà sa menuwa Babiloniya. ");
INSERT INTO mta_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na, egoh da inuwit dutu Babiloniya dò, umanak Hékoniyas i si Salatiél. Umanak Salatiél i si Sélubabel. ");
INSERT INTO mta_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Umanak Sélubabel i si Abiyud. Umanak Abiyud i si Iliyakim. Umanak Iliyakim i si Asol. ");
INSERT INTO mta_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Umanak Asol i si Sadok. Umanak Sadok i si Akim. Umanak Akim i si Iliyud. ");
INSERT INTO mta_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Umanak Iliyud i si Iliyasal. Umanak Iliyasal i si Matan. Umanak Matan i si Hakob. ");
INSERT INTO mta_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Umanak Hakob i si Hosé. Migsawa Hosé i si Maliya sa inay i Hésus. Owoy si Hésus sa ginelal da Mésayas sa Tigtu Datù eg-angat-angatan sa medoo Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na, sepulù owoy epat sa kedoo da nesetugod edung sa egoh i Ablaham taman sa egoh i Datù Dabid. Owoy sepulù owoy epat ma sa kedoo da nesetugod edung sa egoh i Dabid taman sa egoh da inuwit sa medoo Hudiyu dutu Babiloniya dò. Owoy sepulù owoy epat ma sa kedoo da nesetugod edung sa egoh da inuwit Babiloniya dò taman sa egoh i Hésus sa Mésayas miglesut. ");
INSERT INTO mta_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na, ini sa tulon denu sa kinelesut i Hésus Kelistu. Si Maliya sa inay di owoy iya sa maama binayal di, si Hosé. Dodoo, egoh da endà pa nesehulid, neketiig Maliya i mig-obol dé polo danà sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na, metiengaw etaw Hosé i. Huenan di, egoh di neketiig obol dé si Maliya, iya sa penemdem di meked sumawa si Maliya, enù ka guwaen di dò nesalà Maliya i. Dodoo ungayà di endà medoo da umantang anì endà memalaan Maliya i. ");
INSERT INTO mta_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Egoh i Hosé egpenemdem pelà denu sa baelan di, duen sa egsugùsuguen i Nemula tinegeinep di. Guwaen di, “O Hosé, tugod i Dabid, yaka eg-eked duu egsawa si Maliya enù ka egkelalingen dé danà sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Owoy umanak maama, owoy iya sa pengadani ko si Hésus, enù ka kagdi sa umaluk sa langun etaw denu sa salà da.” ");
INSERT INTO mta_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Na, nebaelan iya wé diyà si Hosé owoy si Maliya enù ka neketuu dé sa kagi i Nemula tinulon sa tegesugkow di egoh anay. Guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hê, umobol sa kenogon owoy umanak maama pengadanan da si Imanuwél.” Na, ini sa selepangan di, diyà dé kenita Nemula i. ");
INSERT INTO mta_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Agulé, egoh i Hosé mig-enaw, migpangunut diyà sa kagi sa egsugùsuguen i Nemula diyà kenagdi. Huenan di sinawa di Maliya i, ");
INSERT INTO mta_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","dodoo endà neseuma sa lawa da taman sa egoh di miglesut sa anak di. Agulé pinengadanan i Hosé si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na, egoh i Datù Hélod mig-ipat sa tanà Hudiya, miglesut Hésus i diyà sa menuwa Bétlihém diyà uwang Hudiya. Egoh di magtu miglesut, duen etaw neketiig tandà diyà bituen migtebow diyà Hélusalém kedu mediyù dò denu tebowon agdaw. ");
INSERT INTO mta_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Egoh da migtebow, eg-igsà da, guwaen da, “Kenà sa batà kumedatù diyà etaw Hudiyu? Enù ka hinaa ké sa tandà di miglesut sa bituen milegdaw denu tebowon agdaw, huenan di mig-angay ké dahini anì datuen ké kagdi.” ");
INSERT INTO mta_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na, egoh i Datù Hélod migdineg duen sa datù mekesambì kenagdi, tigtu nebukul lapeg sa langun etaw tegeHélusalém. ");
INSERT INTO mta_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Agulé, egsetiponen di sa langun ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis, owoy eg-igsaan di kagda sa kenà di lumesut Mésayas i sa Tigtu Datù eg-angat-angatan sa medoo Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Egsagbì da, guwaen da, “Dutu Bétlihém dò diyà siini uwang Hudiya. Enù ka iya sa igsulat sa tegesugkow i Nemula egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kiyu i etaw tegeBétlihém diyà uwang Hudiya, apiya di pa eglalag sa medoo menuwa diyà sa tanà Hudiya, uman pa lumalag sa menuwa yu enù ka lumesut diyà keniyu sa Tigtu Datù sumabà sa medoo etaw ku tugod i Islaél.’” ");
INSERT INTO mta_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Agulé, igsasà i Hélod sa medoo etaw neketiig tandà diyà bituen kedu tebowon agdaw. Egoh da eglebù, eg-igsaan di kagda nengan da mighaa sa bituen. ");
INSERT INTO mta_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Agulé, egpeangayen di kagda Bétlihém dò owoy guwaen di, “Angay yu lagbet sa batà dutu. Amuk hauwen yu, pelikù yu dema dini angay yu tulon diyà kenak anì mangay a ma dumatù kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Agulé eglegkang sa etaw neketiig tandà diyà bituen. Egoh da eg-ipanaw, eghauwen da dema sa bituen hinaa da dutu tebowon agdaw dò. Egoh da mighaa sa bituen, tigtu neanggan sa pedu da, huenan di eg-unutan da sa bituen taman egoh di mig-etud migpesoyol diyà sa selatal dalesan kenà i Hésus eg-ugpà. ");
INSERT INTO mta_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Agulé, egoh da eggemow diyà sa dalesan, hinaa da sa batà owoy si Maliya inay di. Egligkued da egdatù sa batà. Agulé, egbekaden da sa baul dinaleman da sa langun taman milagà inuwit da, bulawan, owoy sa lana milagà mepion ngadeg, owoy sa bulung kepengadan da mila. Ibegay da uloy diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, tinulonon i Nemula kagda tegeinep anì endà dé pelikù da diyà si Hélod. Iya maen di ya mig-ukit da diyà sa sebaen ma dalan egoh da eglikù diyà sa hagda tanà. ");
INSERT INTO mta_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na, egoh da mig-ipanaw dé sa etaw neketiig tandà diyà bituen, duen sa egsugùsuguen i Nemula tinegeinep i Hosé. Guwaen di, “O Hosé, enaw ka dé. Uwit ko sa batà owoy sa inay di, owoy pelaguy yu angay Igiptu dò. Ugpà yu dutu taman endà pelikuen ku kiyu dini, enù ka ipelagbet i Hélod sa batà anì ipeimatay di.” ");
INSERT INTO mta_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Agulé, apiya di pa teliwadà sigep, mig-enaw Hosé i owoy eg-ipanaw uwiten di sa sawa di owoy si Hésus. Hê eg-ipanaw da sigep mangay Igiptu dò. ");
INSERT INTO mta_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Agulé eg-ugpà da dutu taman sa egoh i Hélod nematay. Na, danà iya wé binaelan da, neketuu sa kagi i Nemula tinulon sa tegesugkow di egoh anay, guwaen di, “Pelikuen ku dema sa anak ku kedu diyà tanà Igiptu.” ");
INSERT INTO mta_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na, netiigan i Hélod neakalan danà da endà egpelikù diyà kenagdi sa medoo etaw neketiig tandà diyà bituen. Huenan di, tigtu egbulit temù owoy egpeangayen di sa medoo sundalu diyà menuwa Bétlihém lapeg sa medoo menuwa medapag dahiya anì imatayan da sa langun batà maama magtu miglesut taman sa duwa gepalay dé miglesut. Iya sa binaelan di anì imatayan di hedem Hésus i enù ka duwa gepalay ma dé sa lugay di egoh da mighaa sa tandà bituen. ");
INSERT INTO mta_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, danà iya wé binaelan di, neketuu dé sa inikagi i Hilimiyas sa tegesugkow i Nemula egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Duen sa dinegen yu dutu menuwa Lama dò. Suminegaw temù sa medoo tugod i Lakél owoy dumelawit da ma enù ka sinegawan da sa anak da. Endà mebaluy di pepionen sa pedu da enù ka inimatayan sa medoo anak da.” ");
INSERT INTO mta_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na, egoh i Hélod nematay dé, duen sa egsugùsuguen i Nemula tinegeinep i Hosé dutu Igiptu dò. ");
INSERT INTO mta_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Guwaen di, “O Hosé, enaw ka dé. Uwit ko sa batà owoy sa inay di, owoy pelikù yu angay dutu tanà Islaél dò, enù ka nematay dé sa etaw egkelukuy eg-imatay sa batà.” ");
INSERT INTO mta_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Agulé, mig-enaw Hosé i owoy inuwit di sa sawa di owoy si Hésus, owoy eglikù da dema dutu Islaél dò. ");
INSERT INTO mta_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dodoo endà eg-angay da diyà sa uwang Hudiya enù ka nelimedangan Hosé i egoh di neketiig si Alkilayo sa datù eg-ipat uwang Hudiya. Kagdi sa nekesambì sa emà di nematay si Hélod. Dodoo sinugù i Nemula Hosé i danà sa tegeinep di, huenan di eglagbas da eg-angay uwang Galiliya dò. ");
INSERT INTO mta_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Agulé eg-ugpà da diyà sa menuwa Nasalét diyà uwang Galiliya. Huenan di, neketuu sa kagi sa tegesugkow i Nemula egoh anay denu si Hésus, guwaen di, “Kagdi sa etaw tegeNasalét.” ");
INSERT INTO mta_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na, sebaen agdaw, duen sa etaw pinengadanan da si Huwan sa Tegebautis enù ka kagdi sa egbautis etaw diyà wayeg. Mig-angay diyà sa melabel tanà mediyù dalesan dutu uwang Hudiya dò. Owoy egtegudon sa kagi i Nemula diyà sa medoo etaw, ");
INSERT INTO mta_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","guwaen di, “Ekedi yu dé sa medoo salà yu, enù ka buyu dé tumebow sa kedatù i Nemula diyà kenita.” ");
INSERT INTO mta_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na, si Huwan sa igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, “Dumuen sa maama mikagi metaled dutu siedò melabel tanà mediyù dalesan. Iya sa guwaen di, ‘Abung-abungi yu sa ukitan i Datù tumebow. Petudà yu sa medoo dalan di.’” ");
INSERT INTO mta_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Na si Huwan, igkawal di sa hinabel bulbul hinagtay kamiliyu, owoy iya sa sabitan di sa netikal kunul hinagtay. Iya sa kaenen di sa kasuk owoy sa teneb linaday. ");
INSERT INTO mta_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Medoo sa etaw mig-angay diyà kenagdi kedu diyà menuwa Hélusalém, owoy kedu diyà sa medoo menuwa diyà uwang Hudiya, owoy kedu ma sa uwang lawaꞌt Holdan. ");
INSERT INTO mta_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Egtulonen da sa medoo salà da eg-ekedan da owoy egbautisan i Huwan kagda diyà sa lawa Holdan anì tandaan da sa kineeked da sa salà da. ");
INSERT INTO mta_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Duen ma sa medoo ulu-ulu diyà sa simbaan etaw Hudiyu, sa medoo etaw Palasiyu owoy etaw Sadusiyu ma, eg-angay da ma diyà si Huwan anì egpebautis da ma diyà wayeg. Dodoo, egoh i Huwan mighaa kenagda, guwaen di, “Lagà yu medoo uled! Negaip a maen di ya eg-angay yu diyà kenak. Iya sa penemdem yu daa kéen, egpelaguy yu sa kepigtamay i Nemula tumebow. ");
INSERT INTO mta_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Amuk tuu sa keeked yu sa salà yu, sambii yu sa adat yu medaet anì kumepion. Amuk hediya, lagà yu sa kayu mepion kebunga. ");
INSERT INTO mta_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dodoo yoko egpenemdem duu mekeiwod yu sa kepigtamay i Nemula keniyu. Apiya kiyu sa tugod i Ablaham, pigtamayan i Nemula doo kiyu amuk endà sambian yu duu sa adat yu. Apiya meimet di kiyu migtamay, mekehaa pa Nemula i sa isambì di keniyu sa tugod i Ablaham. Mebaluy tugod i Ablaham siini medoo batu amuk iya sa uyot i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Taa yu. Igpeayaw dé sa agsà diyà sa kayu. Sumalà dé sa kayu endà egbunga mepion, pilayen owoy ulowen.” ");
INSERT INTO mta_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Guwaen i Huwan ma, “Tumebow pa sa mekesambì kenak sa tigtu eglowon diyà kenak. Amuk tumebow, mekelilang a enù ka apiya sa talumpà igsugù di diyà kenak, egkemalaan a eg-uwit. Wayeg daa sa ibautis ku keniyu anì tandaan yu sa keeked yu salà, dodoo sa etaw mekesambì kenak, iya polo sa ibautis di keniyu sa Metiengaw Suguy i Nemula owoy apuy. ");
INSERT INTO mta_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Siedò maama tumebow lagà sa maama etapen di sa palay inelik di. Tiponen di sa palay owoy itagù di diyà sa sibay di, dodoo ulowen di sa opoh di diyà sa apuy endà mepadeng.” ");
INSERT INTO mta_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na, egoh i Huwan egbautis pelà sa medoo etaw diyà wayeg, miglegkang Hésus i diyà sa uwang Galiliya owoy mig-angay diyà sa lawaꞌt Holdan anì pebautis ma diyà si Huwan. ");
INSERT INTO mta_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Dodoo buyu eg-eked Huwan i egbautis si Hésus, guwaen di, “Endà mepion di amuk aken sa egbautis keniko, enù ka tigtu eglowon ka diyà kenak. Kuna polo sa bautis kenak.” ");
INSERT INTO mta_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Egsagbì Hésus i, guwaen di, “Unuti ko dé sa kepebautis ku, enù ka mepion amuk mangunut ki diyà sa langun igsugù i Nemula.” Agulé, binautisan i Huwan Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na, egoh di migpebautis dé, eggaun Hésus i kedu dalem sa wayeg. Hê, neukaan sa langit, owoy hinaa di sa Metiengaw Suguy i Nemula egpetuntun kedu langit dò eg-angay egtenà diyà kenagdi. Egoh di egpetuntun, migpeiling manuk menatad. ");
INSERT INTO mta_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Agulé duen sa eg-ikagi kedu diyà langit, guwaen di, “Ini sa anak ku eghiduwan ku temù, owoy tigtu a netuuwan diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Na, egoh i Hésus migpebautis dé diyà sa lawa Holdan, inuwit sa Suguy i Nemula eg-angay dutu siedò melabel tanà mediyù dalesan anì tepengan i Satanas Hésus i anì mekesalà. ");
INSERT INTO mta_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na, egpeketues temù Hésus i enù ka epat pulù agdaw dé sa lugay di endà egpekekaen di dahiya. ");
INSERT INTO mta_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Agulé, egdapag Satanas i diyà kenagdi anì tepengan di, guwaen di, “Amuk kuna sa Tigtu Anak i Nemula, baluy ko kaenen siini batu danà sa tunung ko anì mekedan sa kelikutan ko.” ");
INSERT INTO mta_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Dodoo migsagbì Hésus i, guwaen di, “Meked a iya wé enù ka iya sa kagi i Nemula igpesulat, ‘Endà mepion di amuk kaenen daa sa pedakelen etaw, sa langun kagi i Nemula polo sa eg-udesan etaw.’” ");
INSERT INTO mta_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Agulé, inuwit i Satanas Hésus i dutu Hélusalém dò owoy igtagù di diyà sa buung sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Guwaen i Satanas, “Amuk kuna sa Tigtu Anak i Nemula, laway ka anì mehaa sa tunung i Nemula, enù ka iya sa kagi i Nemula igpesulat, guwaen di, ‘Igsalig i Nemula kuna diyà sa medoo egsugùsuguen di anì buligan da kuna.’ Iya ma sa igpesulat di, ‘Selangawen da kuna anì endà mekesiud ka diyà batu.’” ");
INSERT INTO mta_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Dodoo migsagbì Hésus i, guwaen di, “Meked a iya wé enù ka iya ma sa kagi i Nemula igpesulat, guwaen di, ‘Yaka egtepeng duu Datù Nemula i.’” ");
INSERT INTO mta_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Agulé, inuwit i Satanas Hésus i diyà sa kogol getan mehagtaw owoy igpehaa di kenagdi sa langun kedatuan sa langun datù diyà tanà owoy sa langun egkegaga da ma. ");
INSERT INTO mta_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Guwaen i Satanas, “Iya sa uyot ku begayan ku kuna siini langun hinaa ko. Niko langun iya wé amuk egligkued ka danà ko egpenemula kenak.” ");
INSERT INTO mta_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dodoo migsagbì Hésus i, guwaen di, “O Satanas, pediyù ka diyà kenak. Meked a iya wé enù ka iya sa kagi i Nemula igpesulat, ‘Si Datù Nemula daa sa penemulawen ké. Kagdi daa sa mepangunutan ké.’” ");
INSERT INTO mta_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Agulé, sinalidan i Satanas Hésus i owoy duen egsugùsuguen i Nemula migtebow anì buligan da Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, egoh i Hésus neketiig nebilanggu dé Huwan Tegebautis i, miglikù Hésus i diyà sa uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tinalà di sa menuwa Nasalét, eg-angay eg-ugpà dutu menuwa Kapelenaum dò. Iya sa menuwa medapag diyà sa lanaw Galiliya denu tanà i Sabulon owoy tanà i Naptali. ");
INSERT INTO mta_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na, danà sa binaelan di, neketuu dé sa kagi igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sa langun etaw eg-ugpà diyà sa tanà i Sabulon owoy tanà i Naptali ma, owoy sa eg-ugpà medapag diyà sa lanaw ma, owoy sa eg-ugpà dutu dibaluy lawa Holdan ma, owoy sa medoo etaw tegeGaliliya beken etaw Hudiyu, ");
INSERT INTO mta_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","langun da lagà sa etaw eg-ugpà diyà deleman, dodoo hauwen da doo sa etaw pinengadanan sa Legdaw i Nemula. Edung egoh anay nelimedangan da sa kepatay da owoy sa kepigtamay i Nemula kenagda, dodoo mekedan doo sa kelimedang da amuk tumebow sa Legdaw i Nemula, lagà sa deleman mekedan amuk lumesut sa agdaw.” ");
INSERT INTO mta_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Agulé, mig-edung Hésus i egtulù diyà sa medoo etaw, guwaen di, “Ekedi yu sa medoo salà yu, enù ka buyu dé tumebow sa kedatù i Nemula diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Na, sebaen agdaw eg-ipanaw Hésus i diyà sa mantadan lanaw Galiliya. Hinaa di sa duwa telehadi, si Simon kepengadan da ma si Pidelu, owoy si Andelis hadi di. Egpuket da diyà sa lanaw enù ka kagda sa tegepuket. ");
INSERT INTO mta_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Mig-ikagi Hésus i diyà kenagda, guwaen di, “Unut-unut yu kenak, enù ka edung ini egoh beken sedà daa sa egkuwaen yu, dodoo etaw polo sa ipekuwa ku keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hê, petow dé sinalidan da sa puket da owoy mig-unut da dé si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Agulé, egoh da eg-ipanaw uman, hinaa i Hésus sa duwa anak i Sébediyu, si Santiyago owoy si Huwan hadi di. Dalem da sa kumpit owoy sa emà da enù ka eg-upionen da sa puket. Agulé inumow i Hésus kagda duwa. ");
INSERT INTO mta_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hê, petow dé sinalidan da sa kumpit da owoy sa emà da ma enù ka umunut da si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na, eg-ipanaw Hésus i egtukiden di sa medoo menuwa diyà uwang Galiliya, owoy takà egtulù diyà sa medoo simbaan etaw Hudiyu. Igtulù di sa Mepion Tegudon denu sa kedatù i Nemula, owoy egbulungan di ma sa medoo etaw sumalà dé sa linadu da. ");
INSERT INTO mta_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Huenan di, nekeseluh sa lalag di diyà sa langun uwang Siliya. Inuwit da diyà kenagdi sa langun etaw eglinadu, sumalà dé sa linadu da, ataw ka linahuk busaw ataw ka egbeketketen ataw ka pikat. Nelikuan da dé langun danà i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huenan di, medoo temù sa etaw eg-unut-unut diyà kenagdi. Duen kedu uwang Galiliya dò, duen ma kedu diyà Dikapolis, duen ma kedu Hélusalém owoy sa uwang Hudiya, owoy duen ma kedu tanà dutu lawa Holdan. ");
INSERT INTO mta_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na, egoh di mighaa sa melaweng etaw, migtekedeg Hésus i diyà sa mepokò getan owoy migpenuu dahiya. Agulé eg-angay sa medoo pasek di egdapag diyà kenagdi, ");
INSERT INTO mta_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","owoy egtuluen di kagda. Guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Na, sa langun etaw egpeketiig endà mekegaga da mael mepion asal endà buligan i Nemula duu, neanggan da doo enù ka egpekeunut da sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Owoy sa langun etaw egkebukul danà sa salà da, neanggan da doo enù ka upionen i Nemula kagda. ");
INSERT INTO mta_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Owoy sa langun etaw egpetukééyen da kagda, neanggan da doo enù ka mebegayan da sa langun igpasad i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Owoy sa langun etaw amuk temù pedu da egpangunut diyà sa igsugù i Nemula, neanggan da doo enù ka tabangan i Nemula kagda anì kumetiengaw da. ");
INSERT INTO mta_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Owoy sa langun etaw mehidu sa duma da, neanggan da doo enù ka hiduwan i Nemula ma kagda. ");
INSERT INTO mta_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Owoy sa langun etaw amuk sebaen daa sa pedu da eg-unut diyà si Nemula, neanggan da doo enù ka hauwen da Nemula i kani. ");
INSERT INTO mta_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Owoy sa langun etaw egpelanihen da sa keugpà da, neanggan da doo enù ka meanak i Nemula kagda. ");
INSERT INTO mta_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Owoy sa langun etaw egkepelihay danà da egpangunut diyà sa uyot i Nemula, neanggan da doo enù ka egpekeunut da sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Amuk duen etaw egpeumàumà keniyu danà sa kepigtuu yu kenak ataw ka egpelihay keniyu ataw ka egtulon sa endà tuu denu keniyu, neanggan yu doo ");
INSERT INTO mta_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","enù ka hediya ma sa kepelihay da sa medoo tegesugkow i Nemula egoh anay. Keanggani yu polo temù enù ka duen sa tigtu mepion untung yu dutu langit dò.” ");
INSERT INTO mta_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Agulé guwaen i Hésus, “O medoo pasek ku, kiyu lagà sa timus ipepion nanam kaenen, enù ka kumepion sa langun etaw diyà tanà danà yu. Dodoo amuk mekedan sa keemis sa timus, endà dé mebaluy di peemis. Mekebuung daa owoy mekogkogon da enù ka endà dé mebaluy di itimus. ");
INSERT INTO mta_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Egoh yu eg-ugpà diyà tanà, lagà yu sa palitaan eglegdaw diyà deleman, enù ka mehaa sa langun etaw diyà tanà kiyu i. Hediya ma, endà mekedilung sa menuwa diatas getan. ");
INSERT INTO mta_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hediya ma, amuk duen etaw egtemtem palitaan, endà pelagkeban di duu solok, dodoo mehagtaw polo sa kenà di itagù anì melegdawan sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hediya ma, baeli yu daa sa mepion egbaelan yu, enù ka amuk eghauwen liyu etaw sa mepion egbaelan yu, oloen da Nemula i sa Emà ta diyà langit.” ");
INSERT INTO mta_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Agulé guwaen i Hésus, “Yoko egpenemdem duu iya sa pesuwan di mig-angay a diyà tanà anì peulanen ku sa uledin ta igsugkow i Mosis owoy sa igtulù sa medoo tegesugkow i Nemula egoh anay. Dodoo mig-angay a polo dini anì meketuu sa langun igtulù da. ");
INSERT INTO mta_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tuu ini i eg-ikagiyen ku diyà keniyu. Taman endà mekedan sa langit owoy tanà, endà mekedan sa uledin i Nemula, apiya tukééy, dodoo meketuu doo sa langun kagi uledin di. ");
INSERT INTO mta_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amuk duen etaw eg-eked hedem sa uledin, apiya sebaen daa, owoy itulù di ma sa keeked di uledin diyà sa duma di, iya sa etaw tigtu tukééy diyà sa kedatù i Nemula. Dodoo, amuk duen etaw egpangunut diyà sa langun uledin owoy itulù di ma sa ukit kepangunut diyà sa duma di, iya sa etaw kumedakel diyà sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk endà eglowon sa kepangunut yu uledin i Nemula diyà sa kepangunut sa medoo Palasiyu owoy tegetulù ma, endà doo mekeunut yu sa kedatù di.” ");
INSERT INTO mta_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Agulé guwaen i Hésus, “Netiigan yu doo sa uledin igtulù da diyà etaw egoh anay, guwaen di, ‘Yoko eg-imatay ya etaw, enù ka meuwit diyà uwis sa etaw mig-imatay.’ ");
INSERT INTO mta_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Dodoo mikagi a diyà keniyu, mepigtamayan doo sa etaw egbulit diyà duma di. Owoy amuk mikagi medaet sa etaw diyà sa duma di, meuwit doo diyà sa medoo datù anì antangen da. Owoy sa etaw egtubad duma di, mekeangay doo diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Huenan di, amuk mangay yu diyà sa Dalesan i Nemula enù ka duen sa ibegay yu uloy diyà si Nemula, owoy egketulengan yu dahiya duen pelà sa salà yu diyà sa duma yu, ");
INSERT INTO mta_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","agulé salidi yu dé sa ibegay yu owoy seupionoy yu pelà muna diyà sa duma yu. Agulé pelikù yu dema diyà Dalesan i Nemula anì megay yu diyà si Nemula sa hinagtay eg-imatayan yu. ");
INSERT INTO mta_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na, amuk duen etaw tumipu keniko, angay ka muna diyà kenagdi anì seupionoy yu pelawà egoh yu endà pa meuwit diyà sa uwis. Enù ka amuk diyà yu sa taengan sa uwis, mebaluy doo ipeuwit di kuna diyà sa pulis anì mebilanggu ka. ");
INSERT INTO mta_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk mebilanggu ka, endà mekelaun ka taman endà mekeimpas ka sa langun salà ko.” ");
INSERT INTO mta_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Agulé guwaen i Hésus, “Netiigan yu dé sa uledin igtulù i Mosis egoh anay, guwaen di, ‘Yoko egbigà ya.’ ");
INSERT INTO mta_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Dodoo mikagi a diyà keniyu, amuk eghauwen sa maama sa bayi owoy duen sa pedu di egkeiyap, egbigà dé sa maama diyà sa pedu di. ");
INSERT INTO mta_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Huenan di, amuk neenggat yu diyà salà danà sa mata yu denu kuwanan, kedani yu dé iya wé mata yu owoy buungi yu dé. Enù ka uman pa mepion sa egoh di sebaen daen sa mata yu diyà sa egoh lawa yu mekeangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hediya ma, amuk neenggat yu diyà salà danà sa belad yu denu kuwanan, tagped yu dé owoy buungi yu ma dé, enù ka uman pa mepion sa egoh di sebaen daen sa belad yu diyà sa egoh lawa yu mekeangay diyà sa lanaw apuy endà mepadeng.” ");
INSERT INTO mta_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Agulé guwaen i Hésus, “Netiigan yu ma dé sa uledin igtulù da egoh anay, guwaen di, ‘Amuk eg-ekedan sa maama sa sawa di, duen sa sulat ibegay di diyà sa sawa di anì tandaan di sa keeked di sawa di.’ ");
INSERT INTO mta_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dodoo mikagi a diyà keniyu, amuk eg-ekedan sa maama sa sawa di endà migbigà, mekebigà doo sa bayi amuk sumawa sa sebaen maama owoy mekebigà ma doo sa maama sumawa sa bayi inekedan sa sawa di.” ");
INSERT INTO mta_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Agulé guwaen i Hésus, “Netiigan yu ma dé sa uledin igtulù da egoh anay, guwaen di, ‘Amuk duen sa igpasad yu diyà si Nemula, endà mebaluy di amuk endà petuuwen yu duu sa igpasad yu.’ ");
INSERT INTO mta_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Dodoo mikagi a diyà keniyu, yoko egpengibet ta amuk egpasad yu diyà sa duma yu. Yoko egpengibet duu sa langit owoy sa tanà, enù ka sa langit sa lagà penuuwan i Nemula owoy sa tanà sa lagà kinadalan lisen di. Yoko ma egpengibet duu sa menuwa Hélusalém, enù ka iya sa kenà di mugpà sa Tigtu Datù ta. ");
INSERT INTO mta_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yoko ma egpengibet duu sa ulu yu, enù ka endà megaga yu duu meluman sa balut ulu yu, iling ka peitemen iling ka pebulaen. ");
INSERT INTO mta_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amuk metudà sa kagi yu, ikagi yu daa ‘Hoò,’ ataw ka ikagi yu daa ‘Endà,’ enù ka amuk petuuwen yu sa kagi yu danà sa kepengibet yu, iya sa kagi kedu si Satanas.” ");
INSERT INTO mta_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Agulé guwaen i Hésus, “Netiigan yu ma dé sa uledin igtulù da egoh anay, guwaen di, ‘Amuk piseken sa etaw sa mata sa duma di, mepisek ma sa hagdi mata. Hediya ma, amuk kedanan sa etaw sa ngipen sa duma di, mekedan ma sa hagdi ngipen.’ ");
INSERT INTO mta_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Dodoo mikagi a diyà keniyu, yoko egsulì duu sa etaw egbael medaet diyà keniyu. Amuk duen etaw tumagpì sa bélén ko denu kuwanan, pedibaluyi ko denu bibang anì umanan di sa ketagpì di amuk iya sa ungayà di. ");
INSERT INTO mta_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Owoy amuk duen etaw umagak keniko diyà sa uwis anì pekawen di sa kawal ko danà sa utang ko kenagdi, begayi ko ma sa lapin ko. ");
INSERT INTO mta_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Owoy amuk tegelen ka sa sundalu egpeuwit sa langun taman di taman sakakilumitelu, uwit ko polo taman duwa kakilumitelu. ");
INSERT INTO mta_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Owoy amuk duen etaw egpegeni diyà keniko, begayi ko sa egpegeniyen di. Owoy amuk egkelukuy egsagbay sa etaw diyà keniko, pesagbay ko ma.” ");
INSERT INTO mta_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Agulé guwaen i Hésus, “Netiigan yu ma dé sa uledin igtulù da egoh anay, guwaen di, ‘Hiduwi yu sa duma yu owoy kelepuhi yu sa kuntelà yu.’ ");
INSERT INTO mta_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dodoo mikagi a diyà keniyu, hiduwi yu sa medoo kuntelà yu owoy simbai yu ma sa etaw egpelihay keniyu. ");
INSERT INTO mta_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Amuk hediya, mekesuet yu si Nemula sa Emà ta diyà langit, enù ka egpelegdawen di sa agdaw diyà sa langun etaw, iling ka medaet etaw ataw ka mepion. Owoy ibegay di ma sa udan diyà sa hinemulaan langun etaw, iling ka mepion sa egbaelan da ataw ka medaet. ");
INSERT INTO mta_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Huenan di, hiduwi yu ma sa langun etaw. Amuk iya daa sa eghiduwan yu sa medoo mehidu keniyu, endà duen sa mepion untung mesakem yu, enù ka hediya mendaa sa medoo medaet etaw atung egpeetuken sa Sulutan, iya ma daa sa eghiduwan da sa mehidu kenagda. ");
INSERT INTO mta_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Owoy adati yu ma sa langun etaw. Amuk iya daa sa adatan yu sa medoo duma yu etaw Hudiyu, endà metuuwan Nemula i diyà sa keadat yu, enù ka hediya mendaa sa medoo etaw beken Hudiyu, iya ma daa sa eg-adatan da sa duma da daa. ");
INSERT INTO mta_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Huenan di, pepion yu sa adat yu diyà sa langun etaw, petepengi yu sa metiengaw adat i Nemula sa Emà ta diyà langit.” ");
INSERT INTO mta_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Agulé guwaen i Hésus, “Yoko egpetiig duu sa kepangunut yu si Nemula diyà sa medoo etaw anì metuuwan da diyà sa mepion egbaelan yu. Enù ka amuk ungayà yu oloen yu etaw, endà duen sa untung mesakem yu diyà sa Emà ta diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Huenan di, amuk duen sa ibegay yu diyà sa etaw pubeli, yoko egtulon duu diyà sa langun etaw anì oloen da kiyu, enù ka hediya ma sa egbaelan sa medoo liyu etaw guwaen da dò metiengaw etaw da. Ipehaa da sa kebegay da diyà sa simbaan etaw Hudiyu owoy diyà sa kalasada ma anì meolò da etaw. Tuu ini i eg-ikagiyen ku diyà keniyu. Tapay da dé nekekuwa sa untung da. ");
INSERT INTO mta_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Dodoo amuk egtabangan yu sa etaw pubeli, yoko egpetiig duu diyà sa liyu etaw, labi pa amuk sa loyuk yu. ");
INSERT INTO mta_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Amuk endà ipehaa yu duu diyà sa medoo etaw sa ketabang yu etaw pubeli, mehaa doo i Emà ta Nemula, owoy begayan di kiyu untung.” ");
INSERT INTO mta_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Agulé guwaen i Hésus, “Amuk egsimbà yu diyà si Nemula, yoko eg-iling duu sa medoo etaw guwaen da dò metiengaw etaw da, enù ka egkeiyap da egsimbà diyà sa simbaan da owoy diyà sa kalasada ma anì mehaa da etaw. Tuu ini i eg-ikagiyen ku diyà keniyu. Tapay dé nekekuwa da sa untung da. ");
INSERT INTO mta_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dodoo amuk egsimbà yu, likù yu diyà sa niyu dalesan. Pintui yu anì endà mehaa yu etaw owoy simbai yu diyà sa Emà ta si Nemula endà mehaa di etaw. Apiya endà hauwen etaw kiyu egsimbà, mehaa doo i Emà ta owoy begayan di ma kiyu untung. ");
INSERT INTO mta_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Amuk egsimbà yu, yoko egpedoo duu sa kagi yu uloy, enù ka iya lagà sa kesimbà sa etaw endà egpigtuu enù ka guwaen da dò dinegen i Nemula sa kesimbà da danà di medoo temù sa kagi da. ");
INSERT INTO mta_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yoko eg-iling duu sa hagda, enù ka tapay dé netiigan i Emà ta Nemula sa ungayà yu egoh yu endà pa eg-ikagi diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Huenan di, amuk sumimbà yu, ilingi yu ini i, guwaen yu, ‘O Emà ké diyà langit, ungayà ké oloen ka etaw. ");
INSERT INTO mta_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ungayà ké ma pedatù ka diyà sa langun etaw diyà siini sinukub langit, owoy ungayà ké ma meketuu sa uyot ko diyà tanà lagà sa ketuu di dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Begayi ko kami sa kaenen ké uman agdaw. ");
INSERT INTO mta_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Peuloyi ko sa medoo salà ké, éhê mendaa sa kepeuloy ké sa salà duma ké. ");
INSERT INTO mta_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tuliki ko kami anì endà mekeukit ké diyà sa kenà ké tepengan anì endà ma mekebael ké salà. Owoy pediyù ko kami diyà si Satanas.’” ");
INSERT INTO mta_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Agulé guwaen i Hésus, “Amuk ipeuloy yu sa salà binaelan sa duma yu diyà keniyu, ipeuloy ma i Emà ta diyà langit sa medoo salà yu. ");
INSERT INTO mta_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Dodoo amuk endà ipeuloy yu duu sa salà duma yu, endà ma ipeuloy i Emà ta duu sa niyu medoo salà.” ");
INSERT INTO mta_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Agulé guwaen i Hésus, “Amuk egpeulanen yu sa kekaen yu anì sumimbà yu daa, yoko egpetiig duu diyà sa medoo etaw danà sa palas yu medaet. Yoko eg-iling duu sa etaw guwaen da dò metiengaw etaw da. Amuk egpeulanen da sa kekaen da, ungayà da metiigan sa medoo etaw sa baelan da, huenan di endà egsuwat da owoy endà ma egdiepug da. Tuu ini i eg-ikagiyen ku diyà keniyu. Tapay dé nekekuwa da sa untung da. ");
INSERT INTO mta_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dodoo amuk egpeulanen yu sa kekaen yu anì sumimbà yu daa, suwat yu owoy diepug yu ma, ");
INSERT INTO mta_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","anì endà metiigan sa liyu etaw duu sa kepeulan yu kekaen. Apiya di pa endà metiigan da duu, metiigan doo i Emà ta Nemula endà mehaa etaw, owoy begayan di ma kiyu untung.” ");
INSERT INTO mta_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Agulé guwaen i Hésus, “Yoko egtipon duu sa medoo pantiyali yu diyà tanà, enù ka medaetan danà kaba owoy meledak ma owoy mekuwa ma menakaw. ");
INSERT INTO mta_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dodoo tipon yu polo sa pantiyali yu dutu langit dò danà yu egbael mepion. Amuk hediya, endà medaetan di danà kaba owoy endà ma meledak di owoy endà ma mekuwa di menakaw. ");
INSERT INTO mta_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Iya sa mepion egbaelan yu enù ka sumalà dé sa kenà sa pantiyali yu, iya ma sa kenà sa pedu yu.” ");
INSERT INTO mta_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Agulé guwaen i Hésus, “Lagà palitaan diyà lawa yu sa mata yu enù ka iya sa iilag yu. Amuk mepion sa mata yu, lagà milegdaw sa langun lawa yu. ");
INSERT INTO mta_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dodoo amuk medaetan sa mata yu, dumeleman sa lawa yu. Diya ma sa pedu yu, enù ka amuk eg-eked yu egpigtuu, deleman yu temù owoy tigtu medaet sa egbaelan yu.” ");
INSERT INTO mta_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Agulé guwaen i Hésus, “Endà mebaluy di amuk duwa sa kaunutan sa maama atung egsugùsuguen, enù ka sebaen daa sa eghiduwan di owoy sa sebaen egkelepuhan di. Sebaen daa sa egpangunutan di owoy sa sebaen eg-ekedan di. Hediya ma, endà ma mebaluy di amuk duwa sa kaunutan yu, ataw ka si Nemula ataw ka sa medoo pantiyali yu. ");
INSERT INTO mta_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Na, iya sa pesuwan ku eg-ikagi a diyà keniyu, pelénég yu sa pedu yu denu sa hagtay yu. Yoko ma egkebukul la denu sa kaenen yu ataw ka sa ginis yu, enù ka amuk milagà sa igbegay i Nemula sa lalù ta owoy sa lawa ta, melemu ma sa kebegay di sa kaenen yu owoy sa ginis yu. ");
INSERT INTO mta_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Haa yu sa medoo manuk eglayanglayang. Endà eg-ohok da owoy endà ma egketu da, owoy endà ma duen sa taguan palay da. Dodoo egpekaenen i Emà ta diyà langit kagda. Labi pa endà ipaten di kiyu, enù ka uman yu pa milagà diyà sa medoo manuk. ");
INSERT INTO mta_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Apiya egkebukul yu egpenemdem sa kelalù yu diyà tanà, endà doo mesumpatan yu duu apiya sakaulas daa. ");
INSERT INTO mta_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Yoko ma egkebukul la egpenemdem sa kenà yu kumuwa sa ginis yu. Haa yu sa medoo balangan keluwen egbulok mepion. Apiya di pa endà eggalebek da owoy endà ma eghabel da ginis, metolol da doo. ");
INSERT INTO mta_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Dodoo taa yu, hih, sa eg-ikagiyen ku diyà keniyu. Apiya di pa metolol sa ginis igluhub i Datù Salomon egoh anay, uman pa metolol sa keluwen épê bulok diyà sa ginis i Salomon. ");
INSERT INTO mta_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nehagtay sa keluwen ini egoh di, dodoo simag, kuwaen etaw enù ka ulowen da diyà apuy. Na, amuk mepion sa kepeginis i Nemula sa keluwen endà melugay di diyà tanà, uman pa mepion sa kepeginis di keniyu, o medoo etaw tukééy kepigtuu. ");
INSERT INTO mta_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Huenan di, yoko egkebukul la denu sa kaenen yu ataw ka sa inemen yu ataw ka sa ginis yu. ");
INSERT INTO mta_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Enù ka sa langun etaw diyà tanà endà egpigtuu, takà da egkebukul denu sa hagtay da. Dodoo netiigan i Emà ta diyà langit endà mehagtay yu amuk endà duen sa kaenen yu ataw ka sa ginis yu. ");
INSERT INTO mta_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dodoo kiyu, udesi yu polo sa kedatù i Nemula owoy sa kepangunut yu diyà sa hagdi uyot. Amuk hediya, mebegayan di ma kiyu sa hagtay yu. ");
INSERT INTO mta_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Huenan di, yoko egkebukul la egpenemdem sa kelikutan tumebow diyà keniyu simag, enù ka mepion amuk egpenemdemen yu polo iya wé amuk tumebow. Yoko eg-uman duu sa kelikutan yu ini egoh di danà yu egkebukul denu sa endà pa eghauwen yu duu, enù ka enget doo sa kelikutan yu ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Agulé guwaen i Hésus, “Yoko egsigbolow duu sa duma yu nesalà anì endà ma ipaten i Nemula duu sa salà yu. ");
INSERT INTO mta_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Amuk medoo sa isigbolow yu duma yu, medoo ma sa isigbolow i Nemula keniyu, enù ka sa isigbolow yu duma yu, iya ma sa isigbolow i Nemula keniyu. ");
INSERT INTO mta_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na, amuk menemdem ka tumabang sa duma ko nesalà, maen di ya eglagbeten ko sa hagdi tukééy bulah, dodoo endà egpenemdemen ko duu sa niko bulah éhê kedakel bugsud dalesan? ");
INSERT INTO mta_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Maen di ya guwaen ko diyà sa duma ko, ‘O Akay, kedanan ku sa bulah ko,’ dodoo endà egkehaa ko duu sa niko éhê bugsud dalesan. ");
INSERT INTO mta_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tegeakal yu kiyu i. Kedani ko polo muna sa niko dakel bulah anì kumetiengaw sa kehaa ko kumedan sa tukééy bulah sa duma ko.” ");
INSERT INTO mta_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Agulé egtulon Hésus i balatan, guwaen di, “Yoko egbegay duu diyà sa medoo tuyang sa milagà diyà sa kehaa i Nemula enù ka hemueden da daa kiyu, owoy yoko ma egsawel duu diyà sa medoo babuy sa pélas milagà enù ka utuhan da daa. Hediya ma, yoko eg-uman na egtulù sa medoo etaw eg-eked egpigtuu sa kagi i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Agulé guwaen i Hésus, “Amuk meudes yu sumimbà, mekekuwa yu sa egpegeniyen yu diyà si Nemula; owoy amuk lumagbet yu, mehaa yu doo sa lagbeten yu; owoy amuk umumow yu, mekegemow yu doo. ");
INSERT INTO mta_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Enù ka sumalà dé sa etaw meudes megeni, iya sa etaw mekekuwa; owoy sumalà dé sa etaw meudes lumagbet, iya sa etaw mekehaa; owoy sumalà dé sa etaw meudes umumow, iya sa etaw mekegemow. ");
INSERT INTO mta_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Upama, duen sebaen maama diyà keniyu. Amuk egpegeni kaenen sa anak di, endà mebaluy di begayan di batu. ");
INSERT INTO mta_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hediya ma, amuk egpegeni sedà sa anak di, endà ma mebaluy di begayan di uled. ");
INSERT INTO mta_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Apiya di pa endà metiengaw yu kiyu i, netiigan yu doo sa mepion ibegay yu diyà sa anak yu. Labi pa endà mepion sa ibegay sa Emà ta diyà langit diyà sa langun etaw egpegeni. ");
INSERT INTO mta_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Na, amuk ungayà yu mepion sa egbaelan sa duma yu diyà keniyu, baeli yu ma sa mepion diyà kenagda. Amuk hediya, mepangunutan yu doo sa langun uledin igsugkow i Mosis owoy sa igtulù sa tegesugkow i Nemula egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Agulé guwaen i Hésus, “Amuk ungayà yu munut diyà sa kedatù i Nemula, ukit yu daa diyà sa tukééy selat. Dodoo melabel sa selat mangay diyà sa lanaw apuy owoy melemu ma sa dalan di, huenan di medoo sa etaw eg-ukit dahiya. ");
INSERT INTO mta_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Dodoo tukééy polo sa selat mangay diyà sa lalù endà meelut di owoy melikut ma sa dalan di, huenan di diisek ma daa sa etaw mekehaa sa dalan di.” ");
INSERT INTO mta_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Agulé guwaen i Hésus, “Tulik yu anì endà meakalan yu danà sa tegesugkow butbuten. Apiya di pa mepion gaa sa egbaelan da lagà sa hinagtay kebilibili, medaetan yu doo enù ka sa pedu da lagà sa mebalaw tinggalung. ");
INSERT INTO mta_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amuk eghauwen yu sa egbaelan da, metiigan yu amuk tuu kagda sa tegesugkow i Nemula ataw ka beken, enù ka endà duen sa bunga palas mekaen etaw diyà sa teledes owoy endà ma duen sa pigus mekaen etaw diyà sa kesulusulu. ");
INSERT INTO mta_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Amuk mepion sa kayu, mepion ma sa mebunga di; dodoo amuk medaet sa kayu, medaet ma sa mebunga di. ");
INSERT INTO mta_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Amuk mepion sa kayu, endà egbunga di medaet; owoy amuk medaet sa kayu, endà ma egbunga di mepion. ");
INSERT INTO mta_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sumalà dé sa kayu endà egbunga mepion, pilayen owoy ulowen. ");
INSERT INTO mta_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Huenan di, amuk eghauwen yu sa egbaelan sa etaw, metiigan yu doo amuk tuu kagda sa tegesugkow i Nemula ataw ka beken.” ");
INSERT INTO mta_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Agulé guwaen i Hésus, “Endà langun di etaw eg-umow kenak guwaen da ‘O Datù ké’ sa etaw mekeunut sa kedatù i Nemula, dodoo iya daa sa etaw mekeunut sa kedatù i Nemula sa medoo etaw tigtu egpangunut diyà sa uyot i Emà ku diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amuk meuma siedò agdaw, dumuen etaw mikagi diyà kenak, guwaen da, ‘O Datù, ukai ko kami anì mekeangay ké diyà keniko, enù ka migtulù ké sa kagi i Nemula danà ké mig-unut keniko, owoy nekepelaun ké ma busaw diyà etaw danà sa ngadan ko inumow ké, owoy nekebael ké ma panduan danà sa tunung ko.’ ");
INSERT INTO mta_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Agulé mikagi a diyà kenagda, guwaen ku, ‘Taa yu, endà nelayaman ku kiyu ya. Pediyù yu diyà kenak, kiyu i tegebael salà.’” ");
INSERT INTO mta_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Agulé guwaen i Hésus, “Uman sebaen etaw egdinegdineg sa eg-ikagiyen ku owoy egpangunut ma, iya lagà sa maama milantek egbael dalesan. Petigdegen di sa bugsud di diyà sa batu dalem tosong. ");
INSERT INTO mta_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Agulé meleges sa udan, owoy egkemahà sa wayeg owoy egdagpak sa meleges kelamag diyà sa dalesan di. Dodoo endà nepilay di enù ka pinetigdeg diyà batu. ");
INSERT INTO mta_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Dodoo, uman sebaen etaw egdineg daa uloy sa eg-ikagiyen ku, dodoo endà egpangunutan di duu, kagdi lagà sa maama bunegbuneg egbael dalesan diyà enay-enay. ");
INSERT INTO mta_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Agulé meleges sa udan, owoy egkemahà sa wayeg owoy egdagpak sa meleges kelamag diyà sa dalesan di. Hê, nepilay owoy tigtu nedaetan ma.” ");
INSERT INTO mta_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Na, egoh i Hésus neubus egtulù, negaip temù sa medoo etaw migdineg, ");
INSERT INTO mta_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","enù ka endà nesetepeng sa ukit ketulù di owoy sa ukit ketulù sa medoo tegetulù uledin igsugkow i Mosis, enù ka dakel polo sa hagdi egkegaga egtulù. ");
INSERT INTO mta_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na, miglungel Hésus i owoy mig-unut sa medoo etaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Agulé duen sa maama eglinadu dempid mig-angay diyà si Hésus. Egligkued egpegeni, guwaen di, “O Datù, megaga ko kumedan siini linadu ku amuk iya sa ungayà ko.” ");
INSERT INTO mta_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Agulé, binegeng i Hésus sa belad di owoy sinabaan di sa maama. Guwaen di, “Meiyap a doo. Haa ko, nelikuan ka dé.” Hê, petow dé nekedan sa linadu di dempid. ");
INSERT INTO mta_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Agulé guwaen i Hésus diyà kenagdi, “Taa ko, hih. Yaka egtulon duu diyà etaw sa egoh ko nelikuan. Dodoo angay ka polo pehaa diyà sa tegesimbà diyà Dalesan i Nemula owoy begay ka ma sa hinagtay ulowen diyà si Nemula iling sa igsugù i Mosis denu sa kepelanih ko diyà sa kehaa i Nemula. Amuk hediya, tandaan ko diyà sa langun etaw sa egoh ko nelikuan.” ");
INSERT INTO mta_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na, egoh i Hésus migtebow diyà sa menuwa Kapelenaum, duen sa kapitan sundalu etaw Loma eg-angay egdapag diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Egpegeni, guwaen di, “O Datù, eglinadu sa egsugùsuguen ku diyà sa dalesan ku. Egtodel dé owoy tigtu egkesakitan.” ");
INSERT INTO mta_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Agulé guwaen i Hésus, “Munut a keniko enù ka bulungan ku.” ");
INSERT INTO mta_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Dodoo egsagbì sa kapitan, guwaen di, “O Datù, yaka eg-unut ta, enù ka memala a amuk gumemow ka diyà sa dalesan ku enù ka tukééy a etaw diyà keniko. Dodoo ikagi ko daa anì melikuan sa egsugùsuguen ku. ");
INSERT INTO mta_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Netiigan ku sa egkegaga ko egsugù, enù ka aken ma sa maama egpekegaga, enù ka legkang diyà sa ulu-ulu ku sa egkegaga ku owoy egpekesugù a ma sa medoo sundalu ku. Amuk guwaen ku diyà sa sebaen sundalu, ‘Ipanaw ka,’ hê mipanaw ma dé. Amuk guwaen ku diyà sa sebaen ma sundalu, ‘Téél ka dé,’ hê misalu ma dé. Amuk guwaen ku diyà sa egsugùsuguen ku, ‘Baeli ko siini,’ hê baelan di ma dé.” ");
INSERT INTO mta_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na, egoh i Hésus migdineg iya wé, tigtu negaip owoy mig-ikagi diyà sa medoo etaw eg-unut diyà kenagdi, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu, tigtu egpigtuu siini maama. Apiya sa langun etaw Hudiyu, endà hinaa ku duu sa kepigtuu da iling siini hagdi. ");
INSERT INTO mta_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Eg-ikagiyen ku ini i diyà keniyu. Amuk meuma sa kedatù i Nemula, mekeunut doo sa medoo balangan etaw beken Hudiyu kedu diyà sa langun balangan tanà diyà siini sinukub langit. Meseselengan da mista sa tupù yu si Ablaham owoy si Isak owoy si Hakob diyà sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Duen ma duma ta etaw Hudiyu ungayà da hedem mekeunut diyà sa kedatù i Nemula, dodoo mehemagawan da polo dutu siedò deleman kenà da mepigtamayan. Suminegaw da dutu owoy kuméget sa ngipen da danà da tigtu mepasangan.” ");
INSERT INTO mta_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Agulé guwaen i Hésus diyà sa kapitan, “Likù ka dé, enù ka neketuu dé sa pinegeni ko kenak danà sa kepigtuu ko.” Hê, petow dé nelikuan sa egsugùsuguen di egoh i Hésus mig-ikagi iya wé. ");
INSERT INTO mta_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Agulé miggemow Hésus i diyà sa dalesan i Pidelu, owoy hinaa di dahiya sa bayi nugangan i Pidelu eghibat danà di egkegenaw temù. ");
INSERT INTO mta_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Agulé sinabaan di sa belad di. Hê petow dé nelikuan sa bayi, owoy migtigdeg minengana di Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Egoh di mig-eled sa agdaw, duen sa medoo etaw linahuk busaw inuwit da diyà si Hésus. Agulé pinelesut i Hésus sa busaw diyà kenagda danà sa kagi di daa, owoy binulungan di ma sa medoo eglinadu. ");
INSERT INTO mta_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na, danà iya wé binaelan di, neketuu dé sa kagi igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, “Kagdi sa kumedan sa linadu ta, owoy bulungan di ma sa langun sakit ta.” ");
INSERT INTO mta_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, egoh i Hésus mighaa sa melaweng etaw eg-unut kenagdi, eg-ikagi diyà sa medoo pasek di anì kumatin da tanà dutu sa lanaw. ");
INSERT INTO mta_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Agulé, duen sa tegetulù sa uledin igsugkow i Mosis eg-angay diyà si Hésus. Guwaen di diyà kenagdi, “O Mistelu, sumalà dé sa angayan ko, umunut-unut a keniko.” ");
INSERT INTO mta_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Dodoo guwaen i Hésus, “Taa ko, hih. Amuk lekipes, duen salag di diyà lungag kayu. Amuk manuk awang, duen ma salag di diyà pulu kayu. Dodoo melikutan ka umunut-unut diyà kenak, aken i Kakay Langun, enù ka endà duen sa tigtu kenà ku mugpà.” ");
INSERT INTO mta_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Agulé, duen ma sebaen etaw eg-unut diyà si Hésus, owoy guwaen di, “O Datù, umunut-unut a diyà keniko, dodoo muna a pelawà mangay lumebeng sa emà ku.” ");
INSERT INTO mta_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Dodoo guwaen i Hésus, “Unut-unut ka dé diyà kenak, enù ka mepion polo amuk sa etaw endà duen lalù da sa lumebeng sa duma da nematay.” ");
INSERT INTO mta_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na, egoh i Hésus mig-edà kumpit, mig-unut ma sa medoo pasek di. ");
INSERT INTO mta_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hê, egoh da eg-ipanaw, nesampen da sepuk diyà sa lanaw, owoy buyu dé egketegeb sa kumpit da danà sa wayeg egpekedalem. Dodoo egtudug Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Agulé, inangay da eg-enaw kagdi, guwaen da, “O Datù, buligi ko kami, enù ka egpekesugsug ki.” ");
INSERT INTO mta_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Dodoo guwaen i Hésus, “Maen di ya egkelimedangan yu? Tukééy daa sa kepigtuu yu diyà kenak.” Agulé migtigdeg Hésus i owoy hinawidan di sa kelamag owoy sa dakel lambeg. Hê migsabuh dé owoy miglinek ma dé. ");
INSERT INTO mta_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Agulé egkegaip da danà sa tunung di, owoy egseolomoy da, guwaen da, “Ngadan ini i maama? Apiya sa kelamag owoy sa lambeg, egpangunut da doo diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Agulé, egoh da egdunggù tanà dutu sa lanaw diyà uwang Gadala, duen sa duwa maama linahuk busaw migtelabuk si Hésus kedu diyà sa kenà lebeng. Tigtu da mebalaw, huenan di endà egpekeukit sa medoo etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Egoh da mighaa si Hésus, pinetaled da sa kagi da, guwaen da, “O Anak i Nemula, maen di ya egbogowen ko kami? Yaka pelà egpigtamay kenami, enù ka endà pa egkeuma sa agdaw di.” ");
INSERT INTO mta_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Duen ma sa medoo babuy eglagbet kaenen da medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Agulé, egpegeni sa medoo busaw diyà si Hésus, guwaen da, “Amuk hemagawan ko kami, peangay ko kami dutu siedò medoo babuy.” ");
INSERT INTO mta_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Guwaen i Hésus, “Dutu yu dé.” Agulé, miglesut sa medoo busaw owoy mighalì da eglahuk diyà sa medoo babuy. Hê migletu sa langun babuy miglungel diyà sa kesagdigan owoy nekelesek da diyà sa lanaw. Nelened da langun. ");
INSERT INTO mta_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Agulé egpelaguy sa medoo tegeipat babuy eg-angay da egtulon diyà sa dakel menuwa sa langun hinaa da owoy sa medoo nebaelan sa duwa maama linesutan busaw. ");
INSERT INTO mta_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Agulé inangay sa medoo etaw egsiegung Hésus i. Egoh da mighaa kenagdi, egpegeni da anì endà lumagbas di diyà sa hagda menuwa. ");
INSERT INTO mta_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Agulé, mig-edà kumpit Hésus i egkatin dema tanà dutu sa lanaw enù ka eglikù diyà sa hagdi menuwa. ");
INSERT INTO mta_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na, duen sa maama egtodel sa langun lawa di linungon da diyà sa kateli inuwit da diyà si Hésus. Egoh i Hésus neketiig dakel sa kepigtuu da diyà kenagdi, guwaen di diyà sa maama egtodel, “O Akay, pebagel ko sa pedu ko, enù ka nekepeuloy dé sa medoo salà ko.” ");
INSERT INTO mta_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Agulé nelikutan sa pedu sa medoo tegetulù uledin igsugkow i Mosis. Egseolomoy da, guwaen da, “Ay, dakel temù sa salà siini maama, enù ka egtepengen di Nemula i.” ");
INSERT INTO mta_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Dodoo netiigan i Hésus sa penemdem da, owoy guwaen di, “Maen di ya medaet sa pedu yu danà sa inikagi ku igpeuloy dé sa salà di? ");
INSERT INTO mta_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Enù di ya, ngadan tayu sa melemu egbaelan sa etaw, ipeuloy di sa salà siini maama egtodel ataw ka bulungan di anì meketigdeg owoy mekebigkat? Endà mebaluy di amuk etaw daa. ");
INSERT INTO mta_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Dodoo duen pelawà sa ipehaa ku diyà keniyu anì metiigan yu aken sa Kakay Langun anì metiigan yu ma amuk mekegaga a egpeuloy salà diyà tanà.” Agulé guwaen i Hésus diyà sa maama egtodel, “Na, Akay, tigdeg ka dé. Uwit ko sa kateli ko owoy likù ka dé.” ");
INSERT INTO mta_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Hê, migtigdeg sa maama owoy miglikù ma dé. ");
INSERT INTO mta_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Agulé, egoh sa langun etaw dahiya mighaa iya wé, nelenawan da owoy eg-oloen da ma Nemula i enù ka igbegay di diyà si Hésus sa egkegaga di egpeuloy salà. ");
INSERT INTO mta_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na, egoh i Hésus eg-ipanaw dema, hinaa di Matéyo i sa atung egpeetuken sa Sulutan egpenuu diyà sa lawì atung kenà di eg-etuk. Agulé guwaen i Hésus diyà kenagdi, “Unut-unut ka kenak.” Hê, migtigdeg Matéyo i owoy eg-unut ma dé diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Agulé, egkaen Hésus i owoy sa medoo pasek di diyà sa dalesan i Matéyo. Migtebow ma sa medoo atung egpeetuken sa Sulutan owoy sa medoo tegebael salà, owoy neseunut da egkaen si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Egoh sa medoo Palasiyu mighaa sa binaelan i Hésus, eg-igsaen da sa medoo pasek di, guwaen da, “Amuk metiengaw etaw sa datù yu, maen di ya egselenganen di egkaen sa medoo atung egpeetuken sa Sulutan owoy sa medoo duma da tegebael salà?” ");
INSERT INTO mta_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Dodoo egoh i Hésus migdineg sa inikagi da, sinagbian di kagda, guwaen di, “Amuk metéél sa etaw, endà duen maen di ya lumagbet tegebulung. Sa etaw eglinadu polo sa lumagbet tegebulung. ");
INSERT INTO mta_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Enù di ya, ngadan sa selepangan siini kagi i Nemula igpesulat, guwaen di, ‘Beken iya sa ungayà ku sa hinagtay ibegay yu diyà kenak. Dodoo iya polo sa tigtu ungayaen ku sa kesehiduway yu.’ Na, pineangay a dini anì isasà ku sa medoo etaw neketiig duen salà da, beken duu sa medoo etaw guwaen da dò endà duen salà da.” ");
INSERT INTO mta_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Agulé, duen sa pasek i Huwan Tegebautis migtebow da diyà si Hésus, owoy guwaen da diyà kenagdi, “Takà ké egpeulan sa kekaen ké anì sumimbà ké daa, owoy hediya ma sa adat sa medoo Palasiyu. Dodoo sa niko pasek, maen di ya endà ma egpeulanen da sa kekaen da?” ");
INSERT INTO mta_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Agulé sinagbian i Hésus kagda peligad, guwaen di, “Amuk duen pista kawing, endà mebaluy di amuk peulanen ta sa kekaen ta amuk dahiya pelawà sa maama egpesawaen. Dodoo dumuen pa sa agdaw mekedan sa maama diyà sa medoo duma di. Iya pelawà sa egoh da peulan sa kekaen da enù ka mebukul da.” ");
INSERT INTO mta_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Agulé, migbael peligad Hésus i denu sa egoh di endà meseamut sa magtu igtulù di owoy sa tapay uledin. Guwaen di, “Upama, duen tapay ginis ko nelisì, endà mepion di amuk itabung ko diyà sa tapay sa magtu ginis endà pinìpian di, enù ka kumipes sa tabung di owoy meumanan sa kedakel lisì di. ");
INSERT INTO mta_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hediya ma, amuk sa magtu wain owoy sa kunul kambing taguan wain, endà mebaluy di itagù ta sa magtu wain diyà sa tapay taguan di enù ka mebetu danà sa kelukotok di enù ka endà eghened sa tapay kunul kambing. Melemet sa wain owoy medaetan ma sa taguan di. Iya polo sa mepion baelan ta, itagù ta sa magtu wain diyà sa magtu taguan di anì endà medaetan da.” ");
INSERT INTO mta_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Na, egoh i Hésus telibubu egtulù, migtebow diyà kenagdi sa maama ulu-ulu diyà sa simbaan Hudiyu. Migligkued diyà sa taengan di owoy migpegeni, guwaen di, “Magtu pelà nematay sa anak ku bayi, dodoo amuk angayen ko sumabà, umenaw doo.” ");
INSERT INTO mta_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Agulé, eglegkang Hésus i inunutan da sa maama owoy sa medoo pasek di. ");
INSERT INTO mta_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, duen ma sa bayi sepulù owoy duwa gepalay dé sa lugay di endà egkedit sa depanug di adat bayi. Agulé, egoh da eg-ipanaw pelawà, egsetugdug sa bayi owoy eg-amisen di sa pelingping ginis i Hésus, ");
INSERT INTO mta_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","enù ka egpenemdemen di melikuan amuk meamis di daa sa ginis i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Agulé, migpelikù eg-isalu Hésus i owoy eghauwen di sa bayi. Guwaen di, “O Okon, pebagel ko sa pedu ko, enù ka nelikuan ka dé danà sa kepigtuu ko.” Hê, petow dé migkedit sa depanug di. ");
INSERT INTO mta_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na, egoh i Hésus migtebow diyà sa dalesan sa ulu-ulu simbaan, hinaa di sa duma etaw egpalendeg danà sa pedu da medaet owoy sa medoo etaw egsinegaw. ");
INSERT INTO mta_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Agulé hinemagawan di kagda, guwaen di, “Yoko egdahiya ya. Endà nematay sa batà, egtudug daa.” Dodoo eggemenan da kagdi i. ");
INSERT INTO mta_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Agulé egoh sa medoo etaw migliyu, migdalem Hésus i sa bilik owoy sinabaan di belad sa batà. Hê, mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Agulé miglalag sa egoh i Hésus mig-enaw sa nematay diyà sa uwang iya wé menuwa. ");
INSERT INTO mta_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na, egoh i Hésus miglegkang, duen sa duwa maama langap egsetugdug diyà kenagdi. Eg-umow da egpegeni, guwaen da, “O tugod i Dabid, hiduwi ko kami.” ");
INSERT INTO mta_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Agulé, egoh i Hésus miggemow diyà sa dalesan, migpedapag sa duwa maama diyà kenagdi. Mig-igsà Hésus i, guwaen di, “Enù di ya, egpigtuu yu duen egkegaga ku egbulung keniyu?” Migsagbì da, guwaen da, “Hoò, Datù, egpigtuu ké dé.” ");
INSERT INTO mta_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Agulé inamis i Hésus sa mata da, owoy guwaen di, “Na, netuu dé sa ungayà yu danà sa kepigtuu yu.” ");
INSERT INTO mta_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hê, mig-ilag da dé. Agulé, tigtu hinawidan i Hésus kagda, guwaen di, “Yoko egtulon duu diyà etaw sa binaelan ku diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Dodoo egoh da miglegkang dahiya, tinulon da polo diyà sa medoo etaw diyà sa langun menuwa dahiya. ");
INSERT INTO mta_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na, egoh da lumegkang sa duwa maama langap, duen sa maama buneg linahuk busaw inuwit etaw diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Agulé, egoh i Hésus migpelesut sa busaw diyà kenagdi, nekeikagi dé sa maama. Negaip temù sa langun etaw mighaa sa maama nelikuan, owoy guwaen da, “Ay, kita i medoo tugod i Islaél, endà pa hinaa ta duu sa binaelan etaw lagà ini i binaelan di taman ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Dodoo guwaen sa medoo Palasiyu dahiya, “Egpekegaga egpelesut busaw danà sa tunung sa datù busaw.” ");
INSERT INTO mta_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na, tinukid i Hésus sa langun dakel menuwa owoy sa medoo tukééy, owoy takà egtulù diyà sa medoo simbaan Hudiyu. Igtulù di sa Mepion Tegudon denu sa kedatù i Nemula, owoy binulungan di ma sa medoo etaw eglinadu, sumalà dé sa linadu da. ");
INSERT INTO mta_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Egoh di mighaa sa melaweng etaw nesetipon diyà kenagdi, eghiduwan di kagda temù enù ka egkepasangan da owoy endà ma duen sa egbulig kenagda, enù ka lagà da kebilibili melemu metelas amuk endà duen sa eg-ipat kenagda. ");
INSERT INTO mta_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Agulé, guwaen i Hésus diyà sa medoo pasek di, “Lagà palay melegà sa medoo etaw endà pa egpigtuu owoy nebaluy temù sa palay, dodoo endà medoo sa etaw egketu. ");
INSERT INTO mta_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huenan di, simbà yu diyà sa épê di, si Nemula, anì umowen di pa sa medoo etaw kumetu sa palay di.” ");
INSERT INTO mta_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na, sinetipon i Hésus sa sepulù owoy duwa salu di, owoy binegayan di kagda tunung anì mekegaga da pelesut busaw diyà sa etaw owoy mekebulung da ma sa etaw eglinadu, sumalà dé sa linadu da. ");
INSERT INTO mta_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Na, ini ngadan sa sepulù owoy duwa salu di: si Simon sa sebaen ngadan di si Pidelu, owoy si Andelis hadi di; owoy sa duwa anak i Sébediyu, si Santiyago owoy si Huwan hadi di, ");
INSERT INTO mta_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","owoy si Pilipi, owoy si Baltolomi, owoy si Tomas, owoy si Matéyo sa atung egpeetuken sa Sulutan, owoy sa sebaen ma Santiyago anak i Alpiyo, owoy si Tadiyo, ");
INSERT INTO mta_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","owoy sa sebaen ma Simon sa mebagel eghemalang sa tanà Hudiya, owoy si Hudas Iskaliyot sa maama tumampil diyà sa kuntelà i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na, pineangay i Hésus sa sepulù owoy duwa salu di anì tumegudon da, guwaen di, “Yoko eg-angay ya diyà sa medoo menuwa etaw beken Hudiyu, owoy yoko ma eg-angay ya diyà sa medoo menuwa diyà uwang Samaliya. ");
INSERT INTO mta_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Angay yu polo tegudon diyà sa medoo duma ta tugod i Islaél. Tabangi yu kagda enù ka lagà da sa kebilibili netelas. ");
INSERT INTO mta_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sumalà dé sa angayan yu, tegudon yu anì meketiig sa medoo etaw sa egoh di buyu dé tumebow sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bulungi yu sa medoo etaw eglinadu, owoy enaw yu ma sa etaw nematay. Owoy bulungi yu ma sa etaw eglinadu dempid, owoy pelaun yu ma sa busaw miglahuk diyà sa etaw. Yoko egpebayad duu sa etaw egtabangan yu, enù ka endà ma egbayadan yu duu sa egkegaga igpeuloy i Nemula diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Amuk mipanaw yu, ulan sa medoo eg-uwiten yu enù ka iya sa gumastu keniyu sa etaw tinabangan yu lagà sa kegastu da sa egsugùsuguen da. Ulan sa keuwit yu bulawan ataw ka pilak apiya salaad. Ulan ma sa keuwit yu duma kawal yu ataw ka duma talumpà yu ataw ka tuked ataw ka puyut.” ");
INSERT INTO mta_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Guwaen i Hésus, “Sumalà dé sa menuwa tebowon yu, iling ka dakel menuwa ataw ka tukééy, lagbet yu sa etaw miadat keniyu owoy ugpà yu dé diyà kenagdi taman endà meuma sa kelegkang yu dema. ");
INSERT INTO mta_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Sumalà dé sa dalesan gemowon yu, huna yu ikagi diyà sa etaw di, guwaen yu, ‘Mebegayan yu mepion danà i Nemula.’ ");
INSERT INTO mta_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na, amuk miadat da keniyu, mebegayan da doo mepion danà sa inikagi yu diyà kenagda. Dodoo amuk endà miadat da keniyu, ulan dé enù ka pelikù dema diyà keniyu sa inikagi yu. ");
INSERT INTO mta_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amuk duen etaw endà miadat da keniyu ataw ka endà egpigtuu da sa igtulù yu, salidi yu dé iya wé. Amuk sumalid yu sa dalesan di ataw ka sa menuwa, agtag yu sa kepung diyà sa lisen yu anì tandaan yu sa kepigtamay i Nemula tumebow diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Taa yu ini i eg-ikagiyen ku. Apiya di pa pigtamayan i Nemula pa uman sa etaw tegeSodoma owoy etaw tegeGomola danà sa tigtu medaet binaelan da egoh anay, uman pa dakel doo sa kepigtamay di mekeuma diyà sa menuwa eg-eked keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Agulé, guwaen i Hésus diyà sa medoo salu di, “Taa yu, hih. Mipedu yu kiyu i lagà sa kebilibili, dodoo egpeangayen ku kiyu diyà sa medoo etaw lenglengen, lagà da sa mebalaw tinggalung. Huenan di, tulik yu temù anì endà mael yu medaet diyà etaw. ");
INSERT INTO mta_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tulik yu, enù ka duen medaet etaw sigkemen da kiyu, owoy agaken da ma kiyu diyà sa uwis, owoy tapesen da ma kiyu diyà sa medoo simbaan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Owoy uwiten da ma kiyu diyà sa medoo sulutan owoy diyà sa medoo datù ma danà sa kepigtuu yu diyà kenak. Huenan di, meketulù yu doo sa Mepion Tegudon denu kenak diyà kenagda owoy diyà sa etaw beken Hudiyu ma. ");
INSERT INTO mta_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Amuk meagak yu diyà sa uwis, yoko egkebukul la egpenemdem sa kesagbì yu kenagda ataw ka sa ikagiyen yu diyà kenagda, enù ka amuk meuma sa egoh yu sumagbì, metiigan yu ma doo sa sagbì yu mekesugat. ");
INSERT INTO mta_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Enù ka beken danà sa niyu daa penemdem sa isagbì yu nesugat, dodoo danà yu polo netulù sa Metiengaw Suguy i Emà ta Nemula. ");
INSERT INTO mta_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Apiya sa etaw telehadi, ipesigkem da sa duma da anì ipeimatay da. Hediya ma, ipeimatay ma sa medoo maama sa anak da, owoy kuntelaen ma sa medoo batà sa lukes da anì ipeimatay da. ");
INSERT INTO mta_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Melepuhan langun etaw kiyu danà sa kepigtuu yu diyà kenak. Dodoo amuk metigkelan sa etaw siini langun kelikutan, mebegayan doo sa lalù endà meelut di. ");
INSERT INTO mta_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amuk egkepelihay yu diyà sa sebaen menuwa, pelaguy yu angay diyà sa sebaen ma menuwa. Tuu ini i eg-ikagiyen ku diyà keniyu, endà ubusen yu duu egtulù diyà sa langun menuwa kenà da eg-ugpà tugod i Islaél taman endà pelikù a dema, aken i Kakay Langun.” ");
INSERT INTO mta_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Guwaen i Hésus, “Tuu ini i eg-ikagiyen ku. Endà lumowon sa etaw egtuluen diyà sa mistelu egtulù kenagdi. Hediya ma, endà ma lumowon sa udipen diyà sa datù di. ");
INSERT INTO mta_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Huenan di, meanggan doo sa etaw egtuluen amuk meketepeng sa egkegaga di diyà sa egkegaga sa mistelu di. Hediya ma, meanggan ma doo sa udipen amuk meuma sa kedakel di diyà sa kedakel sa datù di. Na, netiigan yu dé pinengadanan da aken si Bilsibul datù busaw. Huenan di, amuk medaet sa kepengadan da kenak, aken i Datù yu, labi pa endà medaet sa kepengadan da keniyu, kiyu i etaw ku.” ");
INSERT INTO mta_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Na, guwaen i Hésus, “Yoko egkelimedangan duu sa medoo etaw, enù ka sa langun linimunan, meawangan doo; owoy sa langun linidung, mehaa doo. ");
INSERT INTO mta_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Amuk hediya, sumalà dé sa tinulon ku diyà keniyu diyà delem, metulon yu doo diyà medoo etaw diyà legdaw. Owoy sumalà dé sa binadàbadà ku diyà keniyu diyà tukééy bilik pinintuan, peegal-egal yu doo diyà duwangen. ");
INSERT INTO mta_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yoko egkelimedangan duu sa etaw mekepatay keniyu diyà tanà, enù ka sa lawa yu daa sa ketamanan sa egkegaga da. Endà mekeimatay da sa suguy yu. Dodoo kelimedangi yu polo Nemula i, enù ka mekepatay lawa etaw owoy humemaga ma sa suguy etaw mangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Dodoo dakel doo sa kehidu i Nemula keniyu. Upama, amuk meli ki duwa maya diyà padian, pila pa sa lagà da? Dodoo endà duen sa maya menabù diyà tanà amuk beken iya sa uyot i Emà ta Nemula. ");
INSERT INTO mta_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Huenan di, yoko egkelenawan na enù ka uman pa dakel sa lagà yu diyà sa medoo tukééy manuk. Apiya sa balut ulu yu daa, netiigan i Nemula doo sa kedoo di enù ka tigtu eghiduwan di kiyu.” ");
INSERT INTO mta_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Guwaen i Hésus, “Na, sa etaw egtulon diyà duma di sa kedatù di kenak, iya ma sa etaw tulonen ku diyà si Emà ku diyà langit anì metiigan di kagdi sa etaw ku. ");
INSERT INTO mta_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Dodoo sa etaw egpalaw kenak diyà sa medoo duma di, iya ma sa etaw endà tulonen ku duu diyà si Emà ku diyà langit.” ");
INSERT INTO mta_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Agulé guwaen i Hésus, “Yoko egpenemdem duu mig-angay a diyà tanà anì pelanihen ku sa pedu sa langun etaw. Dodoo uman pa egsekuntelaay sa medoo etaw danà ku mig-angay diyà tanà. ");
INSERT INTO mta_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Egkesekuntelà sa lukes etaw owoy sa anak di danà ku mig-angay dahini. Hediya ma, egkesekuntelà sa nugangan owoy sa awas di. ");
INSERT INTO mta_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Owoy iya sa tigtu egkesekuntelà sa etaw sa medoo duma di diyà sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na, apiya di pa eghiduwan sa etaw aken dodoo uman pa dakel sa kehidu di sa emà di owoy sa inay di, endà doo mebaluy di kagdi sa egpepasek diyà kenak. Hediya ma, amuk uman pa dakel sa kehidu di anak di diyà sa kehidu di kenak, endà ma mebaluy di egpepasek diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Endà ma mebaluy di egpepasek sa etaw diyà kenak amuk endà eg-unut-unut di diyà kenak owoy endà ma metigkelan di duu sa kelikutan di lagà sa egoh di egtiang sa bugsud kenà di mematay. ");
INSERT INTO mta_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Huenan di, sumalà dé sa etaw umeked umunut diyà kenak enù ka egpekihagtay, iya polo sa etaw mematay. Dodoo sumalà dé sa etaw umeked pekihagtay anì umunut diyà kenak, iya polo sa etaw melalù taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Guwaen i Hésus, “Na, sumalà dé sa etaw miadat keniyu, eg-adatan di ma aken. Owoy sumalà dé sa etaw miadat kenak, eg-adatan di ma sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amuk miadat yu sa etaw tegesugkow kagi i Nemula danà di egsugkow sa kagi i Nemula, duen doo sa untung ibegay i Nemula diyà keniyu éhê mendaa sa untung ibegay di diyà sa tegesugkow di. Diya ma, amuk miadat yu sa metiengaw etaw danà di metiengaw sa adat di, duen doo sa untung ibegay i Nemula diyà keniyu éhê mendaa sa untung ibegay di diyà sa metiengaw etaw. ");
INSERT INTO mta_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Taa yu, hih, sa eg-ikagiyen ku diyà keniyu. Amuk egkelupahan sa etaw ku tigtu tukééy diyà sa kehaa yu, owoy amuk begayan yu wayeg danà di eg-unut-unut diyà kenak, mebegayan i Nemula doo kiyu untung.” ");
INSERT INTO mta_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Na, egoh i Hésus neubus mig-ikagi sa igsugù di diyà sa sepulù owoy duwa salu di, mig-ipanaw dema eg-angay egtulù sa kagi i Nemula diyà sa medoo menuwa medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, egoh i Huwan Tegebautis diyà sa bilangguwan, dinineg di sa medoo binaelan i Hésus Kelistu. Agulé igpesugkow di diyà sa duma pasek di sa igsà di diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Agulé guwaen da diyà si Hésus, “Tuloni ko kami amuk kuna sa Tigtu Datù pineangay i Nemula migtebow, ataw ka sebaen ma etaw polo sa angat-angatan ké.” ");
INSERT INTO mta_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Agulé migsagbì Hésus i, guwaen di, “Angay yu dé tulon dutu si Huwan dò sa hinaa yu owoy sa dinineg yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nekeilag dé sa medoo langap, owoy nekebigkat ma dé sa medoo pikat. Nelikuan ma dé sa medoo etaw eglinadu dempid, owoy nekedineg ma dé sa medoo bisuwen, owoy mig-enaw ma sa medoo nematay. Owoy nekedineg ma dé sa medoo pubeli etaw sa Mepion Tegudon denu kenak. ");
INSERT INTO mta_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tulon yu ma diyà kenagdi meanggan doo sa etaw amuk endà egkeduwa sa pedu di egpigtuu diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na, egoh sa pasek i Huwan miglikù, mig-edung Hésus i eg-ikagi diyà sa melaweng etaw denu si Huwan. Guwaen di, “Egoh yu mig-angay eghahaa si Huwan dutu siedò melabel tanà mediyù dalesan, endà iling di elê takà egkepilaypilay danà kelamag enù ka endà egkehalì sa pedu di. ");
INSERT INTO mta_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Egoh yu miglenged si Huwan dutu siedò melabel tanà mediyù dalesan, endà hinaa yu duu sa etaw migluhub metolol ginis, enù ka iya daa sa etaw egluhub milagà ginis sa medoo etaw eg-ugpà diyà sa dakel menuwa datù. ");
INSERT INTO mta_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Dodoo egoh yu mig-angay dutu, inangay yu eghahaa sa tegesugkow i Nemula. Na, tigtu tuu si Huwan sa tegesugkow i Nemula, owoy miglowon pa kagdi i diyà sa medoo tegesugkow i Nemula egoh anay danà sa galebek di tigtu dakel. ");
INSERT INTO mta_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Enù ka igpesulat i Nemula sa denu si Huwan egoh anay, guwaen di, ‘Duen sa egsugùsuguen ku pehunawen ku diyà keniko anì upionen di sa ukitan ko tumebow.’ ");
INSERT INTO mta_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Na, tuu ini i eg-ikagiyen ku diyà keniyu. Sa langun etaw inanak diyà tanà, endà duen miglowon diyà si Huwan Tegebautis. Dodoo sumalà dé sa tukééy etaw umunut sa kedatù i Nemula, iya polo sa lumowon diyà si Huwan. ");
INSERT INTO mta_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Egoh i Huwan endà pa egtegudon, takà migtulù sa medoo tegesugkow i Nemula owoy migsulat ma Mosis i denu sa kedatù i Nemula tumebow. Agulé edung egoh i Huwan egtegudon taman ini egoh di, duen medoo etaw dakel sa ungayà da umunut sa kedatù i Nemula, owoy duen ma medoo mebalaw etaw ungayà da hedem pekawen da sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amuk migtuu yu sa kagi igtulù sa tegesugkow i Nemula egoh anay, netiigan yu doo lagà si Iliyas Huwan i, enù ka tinulon da duen sa etaw tumebow mekeiling si Iliyas anì upionen di sa ukitan i Datù tumebow. ");
INSERT INTO mta_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na, amuk mipedu yu egdineg, penemdem yu dé sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Agulé guwaen i Hésus, “Ngadan iya balatan ku keniyu medoo duma ku eg-ugpà diyà tanà ini egoh di? Lagà yu sa medoo batà egselapan diyà padian owoy egseolomoy da. ");
INSERT INTO mta_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Guwaen sa duma batà, ‘Binaelan ké sa dalemetan anì egdelayaw yu, dodoo eg-eked yu. Migdelawit ké ma anì umunut yu egsinegaw, dodoo eg-eked yu ma.’ ");
INSERT INTO mta_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iya maen di ya lagà yu siedò batà enù ka egoh yu neketiig sa adat i Huwan Tegebautis, inekedan yu kagdi i. Egoh yu neketiig endà medoo sa kekaen di owoy endà ma eg-inem di wain, iya sa kagi yu, guwaen yu, ‘Linahuk busaw ini i maama.’ ");
INSERT INTO mta_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Dodoo egoh yu neketiig sa adat sa Kakay Langun egkaen owoy eg-inem, inekedan yu ma. Iya sa kagi yu, guwaen yu, ‘Taa yu, meibeg kumaen siini maama owoy meibeg ma uminem mekehilu, owoy egloyuken di ma sa medoo medaet etaw atung egpeetuken sa Sulutan owoy sa medoo tegebael salà ma.’ Dodoo sa medoo etaw eg-unut diyà si Nemula, netuuwan da doo sa melabel pagitung di danà da eghaa sa langun binaelan di.” ");
INSERT INTO mta_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Agulé, egsigbolowen i Hésus sa langun etaw eg-ugpà diyà sa medoo menuwa kenà di migbael sa medoo panduan, enù ka endà eg-ekedan da duu sa salà da. ");
INSERT INTO mta_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Guwaen di, “O medoo etaw tegeKolasin owoy etaw tegeBétsaida, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu, enù ka endà eg-ekedan yu duu sa salà yu apiya di pa dakel sa medoo panduan igpehaa i Nemula diyà keniyu. Dodoo sa etaw tegeTilo owoy etaw tegeSidon, amuk egpekehaa da hedem sa medoo panduan egoh anay iling sa panduan hinaa yu, meekedan da doo sa hagda salà owoy tandaan da doo sa keeked da salà danà da migginis sakù owoy binuhbuhan da ma abuh sa ulu da. ");
INSERT INTO mta_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Taa yu, hih, sa eg-ikagiyen ku diyà keniyu. Apiya pigtamayan i Nemula pa uman sa etaw Tilo owoy etaw Sidon, uman pa dakel doo sa kepigtamay di mekeuma diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","O medoo etaw tegeKapelenaum, apiya di pa ungayà yu pedakelen yu kiyu taman langit dò, petukééyen i Nemula doo kiyu anì mekesugsug yu diyà bayà. Amuk nekehaa sa medoo etaw tegeSodoma egoh anay sa medoo panduan iling sa panduan hinaa yu, meekedan da doo hedem sa salà da owoy endà ma medaetan sa hagda menuwa. ");
INSERT INTO mta_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Taa yu sa eg-ikagiyen ku diyà keniyu. Apiya pigtamayan i Nemula pa uman sa medoo etaw Sodoma danà sa tigtu medaet binaelan da egoh anay, uman pa dakel doo sa kepigtamay di mekeuma diyà keniyu enù ka endà egpigtuu yu diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Agulé egsimbà Hésus i, guwaen di, “O Emà, kuna sa Datù diyà langit owoy diyà tanà. Egpesalamat a diyà keniko enù ka igpehaa ko dé sa penemdem ko diyà sa medoo etaw épê tukééy penemdem lagà batà, dodoo linidung ko diyà sa medoo etaw épê dakel penemdem. ");
INSERT INTO mta_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","O Emà, enget ma doo iya wé egbaelan ko enù ka iya sa egkepionon pedu ko.” ");
INSERT INTO mta_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Agulé guwaen i Hésus, “Aken sa sinaligan i Emà sa langun penemdem di. Endà duen etaw egpeketiig kenak liyu daa si Emà. Endà ma duen etaw egpeketiig si Emà liyu daa aken i anak di owoy sa medoo etaw tuluen ku denu kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Agulé guwaen i Hésus, “Amuk egkeliteg yu danà yu egbaba sa adat yu mebegat, angay yu diyà kenak enù ka kedanan ku diyà keniyu anì mekeetud yu. ");
INSERT INTO mta_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiang yu sa ipeuwit ku keniyu lagà sa kukung, owoy ilingi yu ma aken enù ka mepion sa pedu ku owoy mipedu a ma diyà keniyu, owoy mekeetud yu ma. ");
INSERT INTO mta_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Endà mebegat sa ipetiang ku diyà keniyu owoy melemu ma sa ipeuwit ku keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na, egoh sebaen Sapetu sa agdaw keetud da, mig-ukit da Hésus i diyà sa dalan egtelek tinibah. Egpeketues sa medoo pasek di, huenan di inelus da sa palay owoy sinukut da ma. ");
INSERT INTO mta_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Dodoo, egoh sa medoo Palasiyu mighaa sa binaelan da, guwaen da diyà si Hésus, “Taa ko. Egtipay dé sa medoo pasek ko sa uledin ta denu sa agdaw keetud, enù ka galebek iya wé binaelan da.” ");
INSERT INTO mta_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Agulé sinagbian i Hésus kagda, guwaen di, “Lagà yu endà nekebasa sa kagi i Nemula denu sa binaelan i Dabid sa tupù ta egoh anay egoh di nelikutan neketues owoy sa medoo duma di. ");
INSERT INTO mta_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Migludep Dabid i diyà sa Dalesan i Nemula owoy kinaen di sa epan diyà sa lamisan sa epan igbegay diyà si Nemula. Pinekaen di ma sa medoo duma di. Apiya di pa migtipay diyà sa uledin ta denu siedò epan enù ka sa tegesimbà daa sa mekekaen iya wé, beken doo salà iya wé binaelan di. ");
INSERT INTO mta_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Hediya ma, netiigan ku kiyu doo sa neketiig sa uledin igsugkow i Mosis denu sa egbaelan sa medoo tegesimbà diyà sa Dalesan i Nemula. Eggalebek da doo uman Sapetu sa agdaw keetud ta, dodoo beken salà iya wé egbaelan da. ");
INSERT INTO mta_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Taa yu, hih, ini i eg-ikagiyen ku diyà keniyu. Apiya di pa milagà siedò Dalesan i Nemula, uman pa doo milagà sa etaw migtebow dé diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Duen sa kagi i Nemula igpesulat, guwaen di, ‘Beken iya sa ungayà ku sa hinagtay ibegay yu diyà kenak. Dodoo iya polo sa tigtu ungayaen ku sa kesehiduway yu.’” Agulé guwaen i Hésus, “Amuk tigtu yu neketiig sa selepangan iya wé kagi i Nemula igpesulat, endà sigbolowen yu duu sa etaw endà duen salà di. ");
INSERT INTO mta_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na, aken i Kakay Langun sa Datù diyà siini uledin ta denu sa agdaw keetud, huenan di mekegaga a tumulù etaw sa mepion egbaelan da diyà sa agdaw keetud.” ");
INSERT INTO mta_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na, eg-uman Hésus i eg-ipanaw owoy egludep diyà sa simbaan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Duen dahiya sa maama melungoy dibaluy belad, owoy duen ma dahiya medoo etaw ungayà da tipuwen da Hésus i amuk meketipay sa uledin da. Huenan di, eg-igsaan da, guwaen da, “Enù di ya, amuk mulung sa etaw diyà sa agdaw keetud, meketipay pa diyà sa uledin igsugkow i Mosis?” ");
INSERT INTO mta_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Agulé migsagbì Hésus i, guwaen di, “Upama, duen sa hinagtay yu kebilibili nenabù dalem sa tosong diyà sa agdaw keetud, ngadan di etaw iya wé amuk endà alukan di duu sa nenabù? ");
INSERT INTO mta_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Apiya di pa milagà sa kebilibili, uman pa milagà sa etaw. Huenan di, endà meketipay ki sa uledin igsugkow i Mosis amuk mepion sa baelan ta diyà sa agdaw keetud.” ");
INSERT INTO mta_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Agulé guwaen i Hésus diyà sa maama melungoy belad, “Begeng ko sa belad ko.” Hê, egoh di egbegeng, nelikuan dé sa belad di nekeiling dé kebagel sa dibaluy belad di. ");
INSERT INTO mta_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Agulé, miglegkang sa medoo Palasiyu owoy egseolomoy da sa ukit keimatay da si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na, egoh i Hésus neketiig sa ungayà da mimatay kenagdi, miglegkang dahiya. Mig-unut sa medoo etaw kenagdi owoy egbulungan di sa langun etaw eglinadu, ");
INSERT INTO mta_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","dodoo eghawidan di kagda anì endà tulonen da duu sa denu kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Huenan di, neketuu dé sa kagi i Nemula tinulon i Isayas sa tegesugkow i Nemula egoh anay, ");
INSERT INTO mta_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","guwaen di, “Ini sa tigtu sinaligan ku hinemilì ku. Eghiduwan ku temù owoy netuuwan a diyà kenagdi. Peugpaen ku sa Metiengaw Suguy ku diyà kenagdi. Tulonen di sa metudà adat ku diyà sa langun etaw, lapeg sa etaw beken Hudiyu anì mealukan da. ");
INSERT INTO mta_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Endà kumagkag di diyà etaw endà egpigtuu owoy endà ma sumigbolow di. Amuk tumulù diyà kalasada, endà pedakelen di duu kagdi. ");
INSERT INTO mta_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Apiya di pa melungoy pelà sa kepigtuu sa etaw lagà sa keluwen melemu metepù, endà meekedan di duu. Hediya ma amuk tukééy pelà sa kepigtuu etaw lagà sa tukééy legdaw palitaan, endà ma meekedan di duu dodoo tabangan di polo kagda. Owoy udesan di sa ketulù di sa tuu tegudon taman endà mekeseluh di diyà sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Owoy amuk metulonon sa etaw beken Hudiyu, migtuu da ma doo diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Agulé, inuwit da diyà si Hésus sa maama langap owoy nebuneg danà di linahuk busaw. Agulé pinelesut i Hésus sa busaw diyà kenagdi. Egoh di miglesut, egpekeikagi dé sa maama owoy mig-ilag ma dé. ");
INSERT INTO mta_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Negaip sa langun etaw mighaa sa binaelan i Hésus, owoy egseikagiyay da, guwaen da, “Kagdi kéen sa Tigtu Datù tugod i Dabid eg-angat-angatan ta.” ");
INSERT INTO mta_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Dodoo egoh sa medoo Palasiyu migdineg iya wé, guwaen da, “Iya sa pesuwan di megaga di egpelesut sa busaw diyà etaw danà sa tunung i Bilsibul, sa datù busaw.” ");
INSERT INTO mta_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Dodoo netiigan i Hésus sa penemdem da, huenan di guwaen di diyà kenagda, “Upama, sumalà dé sa medoo etaw eg-unut diyà sa datù, amuk sekuntelaay da, endà melugay di mekedan sa kedatù sa kaunutan da. Diya ma sa segemalay ataw ka sa medoo etaw diyà sa sebaen menuwa, amuk selimbulay da, endà melugay di medaetan ma sa menuwa da. ");
INSERT INTO mta_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Diya ma sa kedatù i Satanas, endà mebaluy di amuk pelesuten di sa medoo busaw etaw di, enù ka medaetan ma sa kedatù di amuk kuntelaen di sa etaw di. ");
INSERT INTO mta_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Na, amuk tuu sa kagi yu egpelesut a busaw danà sa tunung i Bilsibul, ngadan keduwan di ya atu sa tunung sa duma yu egpelesut busaw? Netiigan ta butbut iya wé inikagi yu danà sa binaelan sa medoo duma yu, enù ka netiigan ta kedu si Nemula sa egkegaga da owoy sa naken ma egkegaga. ");
INSERT INTO mta_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amuk egpelesut a busaw diyà etaw danà sa tunung sa Metiengaw Suguy i Nemula, tuu ma doo migtebow dé sa kedatù i Nemula diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Agulé, egpeligad Hésus i anì metiigan da tinabanan di dé Satanas i, guwaen di, “Upama, endà duen etaw mekeludep diyà sa dalesan sa maama mebagel anì lampasen di sa medoo langun taman di taman endà poloten di duu sa épê dalesan. Amuk tinabanan di, lampasen di doo sa langun taman di.” ");
INSERT INTO mta_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Agulé guwaen i Hésus, “Sumalà dé sa etaw endà eg-unut di diyà kenak, iya sa etaw egkuntelà kenak. Owoy sumalà dé sa etaw endà egtabang di kenak egtipoh etaw, iya sa etaw tegehemaga. ");
INSERT INTO mta_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Huenan di, eg-ikagiyen ku ini i diyà keniyu. Mekepeuloy i Nemula sa salà sa etaw, sumalà dé sa medaet egbaelan di ataw ka sa medaet eg-ikagiyen di. Dodoo sa etaw egsumbung sa Metiengaw Suguy i Nemula, endà mebaluy di mekepeuloy sa salà di. ");
INSERT INTO mta_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Amuk egsumbungen sa etaw sa Kakay Langun, mekepeuloy doo sa salà di. Dodoo amuk egsumbungen di sa Metiengaw Suguy i Nemula, endà mekepeuloy sa salà di taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Agulé egtulon balatan Hésus i, guwaen di, “Amuk duen sa sebaen kayu, endà mebaluy di amuk medaet owoy mepion ma sa kebunga di. Enù ka amuk mepion sa kayu, mepion ma sa kebunga di; dodoo amuk medaet sa kayu, medaet ma sa kebunga di. Metiigan yu sa kayu amuk eghauwen yu sa bunga di. ");
INSERT INTO mta_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Na, lagà yu uled, enù ka medaet sa adat yu. Endà duen sa mepion meikagi yu enù ka medaet sa pedu yu. Sumalà dé sa medoo tinipon sa etaw diyà sa pedu di, iya ma sa meikagi di. ");
INSERT INTO mta_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Amuk mepion sa etaw, mepion ma sa egbaelan di danà sa pedu di mepion. Dodoo amuk medaet sa etaw, medaet ma sa egbaelan di danà sa pedu di medaet. ");
INSERT INTO mta_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Taa yu, hih, sa eg-ikagiyen ku diyà keniyu. Amuk meuma sa agdaw i Nemula migtamay etaw, pigtamayan di sa langun etaw mig-ikagi sa uloy kagi. ");
INSERT INTO mta_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Enù ka amuk mepion sa eg-ikagiyen yu, endà mepigtamayan yu. Dodoo amuk medaet sa eg-ikagiyen yu, mepigtamayan yu doo.” ");
INSERT INTO mta_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Na, egsasà sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, guwaen da, “O Mistelu, ungayà ké ipehaa ko kenami sa panduan ko anì metiigan ké kuna sa pineangay i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Dodoo migsagbì Hésus i, guwaen di, “Medeumà siini medoo etaw eg-ugpà diyà tanà ini egoh di owoy iniyugan da Nemula i. Endà egpigtuu da gaa amuk endà hauwen da duu sa dakel panduan. Eg-igsaen da sa panduan, dodoo endà duen panduan ibegay i Nemula liyu daa sa panduan diyà si Honas sa tegesugkow i Nemula egoh anay. ");
INSERT INTO mta_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Inamah sa dakel sedà Honas i, owoy mig-ugpà dalem sa getek di taman telu agdaw. Agulé sinuwah di dema owoy nehagtay doo. Diya ma aken i Kakay Langun, mugpà a dalem tanà taman telu agdaw. ");
INSERT INTO mta_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Na, amuk meuma sa agdaw i Nemula migtamay etaw, tumigdeg sa medoo etaw Niniba owoy sigbolowen da kiyu enù ka inekedan da sa salà da egoh da migdineg sa ketegudon i Honas egoh anay. Dodoo apiya di pa uman pa dakel egkegaga sa maama dahini ini egoh di diyà si Honas, tapay doo endà egpigtuu yu. ");
INSERT INTO mta_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Diya ma, amuk meuma siedò agdaw i Nemula migtamay etaw, tumigdeg ma sa dakel booy kedu diyà sa mediyù tanà Siba, owoy sigbolowen di ma kiyu enù ka endà egpigtuu yu. Apiya mediyù temù sa keduwan di, mig-angay egdinegdineg sa uledin i Nemula diyà si Datù Salomon egoh anay. Taa yu, hih, apiya di pa uman pa dakel egkegaga sa maama dahini ini egoh di diyà si Salomon, tapay doo endà egpigtuu yu.” ");
INSERT INTO mta_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Agulé guwaen i Hésus, “Amuk miglesut sa busaw kedu diyà etaw, egtimbultimbul eglagbet sa kenà di eg-ugpà diyà sa melabel tanà mediyù dalesan. Amuk endà eghauwen di duu sa kenà di eg-ugpà, ");
INSERT INTO mta_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","guwaen di, ‘Pelikù a diyà sa tapay dalesan ku kenà ku miglegkang.’ Agulé egoh di egtebow, hinaa di sa dalesan di pinegenoson owoy tinipoh sa langun taman di, dodoo endà duen etaw di. ");
INSERT INTO mta_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Agulé, eg-angayen di sa pitu duma di busaw uman pa medaet diyà kenagdi, owoy egpelikù da dema eglahuk langun owoy eg-ugpà da dahiya. Hê, ini egoh di egtemù sa kelikutan siini etaw linahuk da. Adi-adi pa sa egoh di anay linahuk. Hediya ma sa mebaelan sa medoo medaet etaw diyà tanà ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na, egoh i Hésus telibubu egtulù diyà sa medoo etaw, migtebow sa inay di owoy sa medoo hadi di maama. Eg-angatan da kagdi i diyà duwangen, enù ka ungayà da mikagi diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Agulé egtulonon etaw Hésus i, guwaen di, “Taa ko, diyà duwangen sa inay ko owoy sa medoo hadi ko. Ungayà da mikagi diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Agulé guwaen i Hésus, “Tulonen ku diyà keniyu sa inay ku owoy sa medoo hadi ku.” ");
INSERT INTO mta_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Agulé egtinuduan di sa medoo pasek di, owoy guwaen di, “Taa yu. Ini polo sa inay ku owoy sa medoo hadi ku, ");
INSERT INTO mta_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","enù ka sa medoo etaw egpangunut sa uyot i Emà ku si Nemula diyà langit, iya polo sa lagà inay ku owoy tebay ku owoy hadi ku maama.” ");
INSERT INTO mta_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na, egoh iya ma dé agdaw, miglegkang Hésus i diyà sa dalesan mig-angay egpenuu diyà sa mantadan lanaw. ");
INSERT INTO mta_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Agulé egkesetipon sa melaweng etaw dahiya, huenan di mighalì Hésus i egpenuu diyà kumpit, dodoo migtigdeg diyà mantadan sa medoo etaw egtuluen di. ");
INSERT INTO mta_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Agulé medoo sa itulù di kenagda danà di migtulon peligad. Guwaen di, “Duen sa maama mig-angay egsawel benì diyà sa hinemulaan di. ");
INSERT INTO mta_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Egoh di migsawel sa benì, duen neketenà diyà dalan, hê neimet sa medoo manuk egkaen. ");
INSERT INTO mta_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Duen duma benì neketenà diyà sa menipis tanà batuwen. Medelamet migtubù enù ka endà mekepal sa tanà di. ");
INSERT INTO mta_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hê egoh di meedup sa agdaw, eglegupay owoy nematay dé enù ka endà medalem sa kedalid di. ");
INSERT INTO mta_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Duen ma duma benì neketenà diyà sa sepinitpinit. Agulé neseselengan da egtubù owoy nesilung sa palay danà sa sepinit. ");
INSERT INTO mta_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dodoo neketenà sa duma benì diyà sa mepion tanà owoy egtubù. Uman sa sebaen benì, nekesugat temù sa kebunga di, duen nekeuma telu pulù, duen enem pulù, owoy duen magatus.” ");
INSERT INTO mta_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Agulé, egoh i Hésus migtulon siini peligad, guwaen di, “Amuk mipedu yu egdineg, penemdem yu dé sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Agulé, mig-angay eg-igsà sa medoo salu i Hésus diyà kenagdi, guwaen da, “Enù di ya, ngadan maen di ya egtulon ka peligad egoh ko egtulù sa medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Agulé guwaen i Hésus egsagbì, “Igpetiig i Nemula dé diyà keniyu denu sa kedatù di, dodoo endà ipetiig di duu diyà sa medoo liyu etaw. ");
INSERT INTO mta_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Enù ka sa etaw egpigtuu, meumanan pa sa netiigan di anì megulub. Dodoo sa etaw endà egpigtuu, mekedan pa uman sa tukééy egketiigan di. ");
INSERT INTO mta_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iya sa pesuwan ku egtulon a peligad diyà kenagda anì endà hauwen da duu sa selepangan di apiya di pa takà da eghahaa owoy endà metiigan da duu apiya di pa takà da egdinegdineg. ");
INSERT INTO mta_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Huenan di, neketuu dé diyà kenagda sa kagi i Nemula igsulat i Isayas sa tegesugkow di egoh anay, guwaen di, ‘Na, siini medoo etaw, apiya di pa takà da egdinegdineg, endà doo metiigan da duu sa selepangan di. Apiya di pa takà da eghahaa, endà ma hauwen da duu. ");
INSERT INTO mta_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Enù ka metegas sa ulu da anì endà meketiig da, owoy sinagpeng da sa telinga da anì endà mekedineg da, owoy miglipedeng da anì endà mekehaa da. Dodoo amuk ekedan da iya wé, metiigan da doo sa kagi ku, owoy metuing ma sa pedu da diyà kenak owoy migtuu da ma diyà kenak, owoy alukan ku ma kagda, guwaen i Nemula.’ ");
INSERT INTO mta_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Dodoo kiyu, neanggan yu temù ini egoh di enù ka nekeilag sa mata yu owoy nekedineg ma sa telinga yu. ");
INSERT INTO mta_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Taa yu, hih. Sa medoo tegesugkow i Nemula owoy sa medoo etaw i Nemula ma egoh anay, ungayà da humaa hedem sa eghauwen yu, dodoo endà dé nekehaa da. Ungayà da ma dumineg hedem sa egdinegen yu, dodoo endà ma dé nekedineg da.” ");
INSERT INTO mta_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Agulé guwaen i Hésus, “Taa yu, hih, ini sa selepangan sa peligad sa etaw egsawel benì. ");
INSERT INTO mta_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sa benì neketenà diyà dalan, iya lagà sa medoo etaw egdineg daa uloy denu sa kedatù i Nemula dodoo endà netiigan da duu. Agulé, egtebow Satanas i owoy egkedanan di sa kagi i Nemula diyà sa pedu da anì endà mekepigtuu da. ");
INSERT INTO mta_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Na, sa benì neketenà diyà sa menipis tanà batuwen, iya lagà sa medoo etaw egdineg sa kagi i Nemula owoy neanggan dé sa pedu da egoh da egsakem. ");
INSERT INTO mta_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Dodoo lagà endà duen dalid di, enù ka endà melugay di sumabuh da migtuu amuk egkepelihay da danà sa kepigtuu da sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na, sa benì neketenà diyà tanà sepiniten, iya lagà sa medoo etaw egdineg sa kagi i Nemula, dodoo lagà egkesilung sa kepigtuu da enù ka egkelakà da danà sa medoo langun taman da owoy sa ungayà da pekawasà. Huenan di, endà mebaluy di sa kebunga sa kepigtuu da. ");
INSERT INTO mta_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Na, sa benì neketenà diyà sa mepion tanà, iya lagà sa medoo etaw egdinegdineg sa kagi i Nemula owoy egketiigan da ma. Mepion sa kebunga sa kepigtuu da, duen nekeuma telu pulù, duen enem pulù, owoy duen magatus.” ");
INSERT INTO mta_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Agulé egpeligad dema Hésus i, guwaen di, “Lagà ini i sa kedatù i Nemula. Duen sa maama eghemula sa mepion benì diyà sa tinibah di. ");
INSERT INTO mta_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dodoo egoh sa sigep egoh sa medoo etaw migtudug, duen sa maama kuntelà di mig-angay diyà iya wé tinibah di owoy igsawel di ma sa bunga keluwen éhê egoh-egoh palay. Agulé miglikù dé. ");
INSERT INTO mta_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na, neseselengan da egtubù sa mepion palay owoy sa keluwen. Dodoo egoh sa palay egbunga, nehaa da sa medoo keluwen enù ka endà duen bunga di. ");
INSERT INTO mta_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Agulé mig-angay sa medoo egsugùsuguen sa épê tinibah diyà kenagdi, owoy eg-igsaan da, guwaen da, ‘O Datù, ngadan sa keduwan di sa medoo keluwen diyà sa palay ko, enù ka mepion doo sa benì hinemula ké diyà sa tinibah ko?’ ");
INSERT INTO mta_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Agulé migsagbì sa épê di, guwaen di, ‘Iya danà sa kuntelà ku.’ Agulé mig-igsà da, guwaen da, ‘Enù di ya, baduten ké pa sa keluwen ataw ka endà?’ ");
INSERT INTO mta_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Dodoo migsagbì, guwaen di, ‘Yoko pelà egbadut duu sa keluwen anì endà ma mebadut sa palay hinemula ta. ");
INSERT INTO mta_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pemaen yu dé sa ketunas da ini egoh di. Dodoo amuk meuma sa keketu ta, suguen ku sa medoo etaw egketu anì muna da madut sa keluwen owoy begkesen da anì temteman da. Iya pelawà kumetu da sa palay, owoy itagù da diyà sa dalesan taguan palay ku.’” ");
INSERT INTO mta_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Egpeligad dema Hésus i, guwaen di, “Na, sa kedatù i Nemula, iya lagà segebelahan dalem mustad hinemula sa maama diyà sa hemulaan di. ");
INSERT INTO mta_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Apiya di pa uman pa tukééy sa dalem di diyà sa medoo liyu benì, uman pa kumedakel doo diyà sa medoo hinemula di amuk migtubù dé. Tepengen di sa kehagtaw kayu owoy mekebaluy sumalag sa medoo manuk diyà sa panga di.” ");
INSERT INTO mta_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Agulé, egpeligad dema Hésus i, guwaen di, “Lagà sa yis ipelenuk epan sa kedatù i Nemula. Apiya di pa tigtu tukééy sa ig-amut sa bayi diyà medoo temù tapung amuk egbael epan, endà melugay di eglenuk langun.” ");
INSERT INTO mta_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na, takà migtulù Hésus i denu sa kedatù i Nemula diyà sa medoo etaw nesetipon danà sa medoo peligad tinulon di. Endà duen sa itulù di kenagda liyu daa sa peligad di. ");
INSERT INTO mta_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Huenan di, neketuu dé sa kagi tinulon sa tegesugkow i Nemula egoh anay, guwaen di, “Tumulù a diyà sa medoo etaw danà sa peligad. Tulonen ku diyà kenagda sa kagi linidung edung egoh tanà binaelan taman ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Agulé, sinalidan i Hésus sa medoo etaw nesetipon owoy miggemow diyà sa dalesan. Mig-unut sa medoo salu di kenagdi, owoy guwaen da, “Tuloni ko kami, hih, sa selepangan sa peligad denu sa keluwen migtunas diyà sa tinibah.” ");
INSERT INTO mta_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Agulé migsagbì Hésus i, guwaen di, “Aken i Kakay Langun sa etaw mighemula sa mepion benì. ");
INSERT INTO mta_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iya sa tinibah sa tanà, owoy iya sa mepion benì sa etaw mig-unut diyà sa kedatù i Nemula. Dodoo iya sa keluwen di sa etaw mig-unut diyà si Satanas. ");
INSERT INTO mta_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iya sa medaet etaw mighemula keluwen, si Satanas. Iya sa selepangan agdaw keketu da sa sabuhanan agdaw, owoy iya sa egketu sa medoo egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tinipon da sa keluwen anì ulowen da. Hediya ma sa mebaelan amuk meuma sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Enù ka aken i Kakay Langun, peangayen ku sa medoo egsugùsuguen ku anì kedanan da diyà sa kedatù ku sa langun etaw tegebael salà owoy sa medoo etaw eg-enggat duma da diyà salà. ");
INSERT INTO mta_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Agulé mekebuung da langun diyà sa apuy endà mepadeng dutu bayà dò. Suminegaw da dutu owoy kuméget sa ngipen da danà da tigtu mepasangan. ");
INSERT INTO mta_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dodoo, sumenang lagà agdaw sa medoo metiengaw etaw diyà sa kedatù i Nemula sa Emà da. Na, amuk mipedu yu egdineg, penemdem yu dé sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Agulé guwaen i Hésus, “Lagà ini i sa kedatù i Nemula. Duen bulawan tapay dé nekeluyung diyà sa kenà eghemula. Agulé, duen sa etaw nekehaa sa bulawan. Tigtu neanggan, dodoo linidung di dema owoy miglikù. Agulé, dinagang di sa langun taman di anì egbeliyen di iya wé hinemulaan. ");
INSERT INTO mta_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Lagà ini i ma sa kedatù i Nemula. Duen sa etaw tegebeli sa mepion balangan pélas. ");
INSERT INTO mta_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Agulé, hinaa di sa pélas tigtu milagà temù enù ka tigtu metolol sa egoh-egoh di. Hê, mig-angay egdagang sa langun taman di anì egbeliyen di iya wé pélas.” ");
INSERT INTO mta_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Agulé guwaen i Hésus, “Lagà ini i ma sa kedatù i Nemula. Duen puket egnabuen diyà lanaw anì mekekuwa sa medoo balangan sedà. ");
INSERT INTO mta_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Egoh sa puket nepenù sedà, inuwit etaw diyà sa mantadan kenà da egpenuu anì hemilien da sa mepion sedà anì iawuh da dalem suladan, dodoo ibuung da sa medaet sedà. ");
INSERT INTO mta_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hediya ma sa mebaelan sa etaw amuk meuma sa sabuhanan agdaw, enù ka mangay sa medoo egsugùsuguen i Nemula anì kuwaen da sa medaet etaw nekeamut diyà sa mepion etaw. ");
INSERT INTO mta_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Agulé ibuung da sa medaet etaw diyà sa apuy endà mepadeng dutu bayà dò. Suminegaw da dutu owoy kuméget sa ngipen da danà da tigtu mepasangan.” ");
INSERT INTO mta_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Agulé mig-igsà Hésus i diyà sa medoo salu di, guwaen di, “Enù di ya, netiigan yu pa ini i igtulù ku diyà keniyu?” Guwaen da egsagbì, “Hoò, netiigan ké dé.” ");
INSERT INTO mta_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Agulé guwaen i Hésus, “Amuk duen sa tegetulù uledin neketiig sa igtulù ku denu sa kedatù i Nemula, kagdi sa tigtu mekegaga tumulù diyà sa medoo etaw, enù ka meketulù sa tapay tegudon owoy sa magtu tegudon ma. Kagdi lagà sa etaw épê medoo langun taman diyà sa dalesan di, duen sa tapay owoy duen ma sa magtu.” ");
INSERT INTO mta_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Na, egoh i Hésus neubus migtulù sa medoo peligad, miglegkang diyà sa lanaw Galiliya ");
INSERT INTO mta_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","owoy miglikù diyà sa tapay menuwa di, Nasalét. Agulé, migtulù diyà sa simbaan Hudiyu. Negaip sa medoo etaw migdineg kenagdi, owoy guwaen da, “Ay, milantek sa ketulù di, owoy mepion ma sa panduan binaelan di. ");
INSERT INTO mta_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dodoo netiigan ta kagdi doo sa anak sa kalpintilu, owoy si Maliya doo sa inay di. Netiigan ta ma sa medoo hadi di, si Santiyago owoy si Hosé owoy si Simon owoy si Hudas. ");
INSERT INTO mta_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Owoy eg-ugpà ma sa medoo tebay di diyà sa menuwa ta. Dodoo ngadan keduwan di ya kéé langun ini i?” ");
INSERT INTO mta_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na, iya sa pesuwan di endà egpigtuu da diyà si Hésus. Agulé, guwaen i Hésus diyà kenagda, “Sumalà dé sa tegesugkow i Nemula, eg-ekedan sa medoo duma di telehadi owoy sa medoo duma di diyà sa tigtu menuwa di, dodoo pigtuuwen polo sa medoo etaw diyà sa liyu menuwa.” ");
INSERT INTO mta_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na, iya sa pesuwan di endà iseg di medoo sa panduan binaelan i Hésus dahiya enù ka endà egpigtuu da. ");
INSERT INTO mta_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na, si Hélod sa Datù egsabà sa tanà Galiliya, migdineg denu sa medoo binaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Agulé, guwaen di diyà sa medoo egsuguen di, “Kagdi doo si Huwan Tegebautis mig-enaw kéen egoh di nematay. Iya pesuwan di ya dakel sa tunung di egbael panduan.” ");
INSERT INTO mta_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Na, igpeimatay i Hélod Huwan i danà di migsigbolow si Hélod, guwaen di, “Migtipay ka dé sa uledin ta danà ko mig-agaw si Hélodiyas.” Na, si Hélodiyas sa sawa i Pilipi hadi i Hélod. Na, danà sa kesigbolow i Huwan, huenan di igpesigkem i Hélod kagdi owoy igpepolot di owoy binilanggu di ma. ");
INSERT INTO mta_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ungayà di hedem ipeimatay di, dodoo nelimedangan di sa medoo etaw Hudiyu enù ka guwaen da si Huwan sa tigtu tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na, egoh i Hélod migpista sa agdaw di miglesut, egdelayaw sa kenogon anak i Hélodiyas diyà sa taengan sa medoo etaw eglenged. Tigtu neanggan Hélod i, ");
INSERT INTO mta_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","huenan di, migpengibet diyà sa kenogon, guwaen di, “Sumalà dé sa egpegeniyen ko diyà kenak, ibegay ku diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Agulé tinuu sa kenogon kagi sa inay di, huenan di, guwaen di diyà si Hélod, “Petagpedi ko sa ulu i Huwan Tegebautis owoy petoyowi ko diyà sa lampay, owoy peuwiti ko diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Agulé tigtu nebukul sa pedu i Hélod. Dodoo danà di migpengibet owoy ungayà di ma endà mesigbolow di etaw eglenged kenagdi, huenan di, tinuu di sa igsasà sa kenogon. ");
INSERT INTO mta_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hê, igsugù di dé sa kepetagped sa ulu i Huwan dalem bilangguwan. ");
INSERT INTO mta_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Agulé tinoyo da lampay sa ulu di, owoy igbegay da diyà sa kenogon, owoy inuwit di ma diyà sa inay di. ");
INSERT INTO mta_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Agulé mig-angay sa medoo pasek i Huwan diyà sa bilangguwan, owoy kinuwa da sa lawa di enù ka ilebeng da. Agulé mig-angay da egtulon diyà si Hésus denu sa kinepatay i Huwan. ");
INSERT INTO mta_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na, egoh i Hésus migdineg denu sa kinepatay i Huwan, eglegkang dahiya owoy mig-edà kumpit eg-angay eglebù. Dodoo egoh sa medoo etaw neketiig sa inangayan i Hésus, miglohot da kenagdi. Eghemantad da daa kedu diyà sa menuwa da. ");
INSERT INTO mta_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Agulé egoh i Hésus migtenà, hinaa di sa melaweng etaw nesetipon dahiya. Nehiduwan di kagda temù owoy binulungan di ma sa medoo eglinadu anì melikuan da. ");
INSERT INTO mta_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Egoh di mahapun dé, mig-angay sa medoo salu i Hésus diyà kenagdi, owoy guwaen da, “Mahapun dé owoy mediyù dalesan siini kenà ta nesetipon. Huenan di, peangay ko siini medoo etaw diyà sa medoo menuwa anì meli da kaenen da.” ");
INSERT INTO mta_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Dodoo guwaen i Hésus, “Yoko egpeipanaw duu kagda. Kiyu polo sa megay kaenen da.” ");
INSERT INTO mta_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Agulé guwaen da, “Duen diyà kenami lima getibulu daa tukééy epan owoy duwa daa sedà nelegà.” ");
INSERT INTO mta_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Agulé guwaen i Hésus, “Uwit yu diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Agulé pinepenuu di sa medoo etaw diyà sa keluwenluwen, owoy kinuwa di ma sa lima getibulu epan owoy sa duwa sedà. Eglengag diyà langit owoy egsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Agulé kinebéngkebéng di sa epan, owoy igbegay di diyà sa salu di owoy tinukid da egbegayan sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hê, langun da migkaen owoy nebesug da. Agulé, tinipoh sa salu di sa nesamà da egkaen sepulù owoy duwa pa gesolok. ");
INSERT INTO mta_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Duen kéen lima ngibu maama migkaen dahiya liyu sa batà owoy bayi. ");
INSERT INTO mta_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Agulé pineedà i Hésus sa medoo salu di diyà kumpit anì humuna da mangay tanà dutu lanaw dò, enù ka egpelikuen di pelà sa melaweng etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Agulé egoh da mig-ipanaw dé, sebaen i Hésus daen nesamà. Agulé migtekedeg eg-angay egsimbà diyà sa mepokò getan. Egoh di sumigep dé, dahiya pelawà diyà sa getan. ");
INSERT INTO mta_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dodoo neteliwadaan dé diyà lanaw sa kumpit inedaan sa salu di, owoy egkepasangan da temù danà sa dakel lambeg enù ka egkesungsung da sa meleges kelamag. ");
INSERT INTO mta_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Egoh di buyu egsimag, mig-angay Hésus i diyà kenagda egbigkat diyà sa kagpaꞌt wayeg. ");
INSERT INTO mta_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Dodoo egoh da mighaa kenagdi egbigkat diyà sa kagpaꞌt wayeg, tigtu nelimedangan sa medoo salu di. Eglesing da danà da nelimedangan owoy guwaen da, “Busaw kéen.” ");
INSERT INTO mta_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Petow dé mig-ikagi Hésus i diyà kenagda, guwaen di, “Pebagel yu sa pedu yu enù ka aken doo sa hinaa yu. Yoko egkelimedangan na.” ");
INSERT INTO mta_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Agulé guwaen i Pidelu, “O Datù, amuk tuu kuna iya wé, pebigkat ko aken diyà sa kagpaꞌt wayeg mangay a diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Agulé guwaen i Hésus, “Angay ka dé dini.” Hê, miglaun Pidelu i diyà kumpit owoy egbigkat ma diyà kagpaꞌt wayeg eg-angay diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Dodoo egoh di migtugedam sa meleges kelamag, nelimedangan owoy buyu dé egkeeled diyà wayeg. Mig-umow, guwaen di, “O Datù, aluki ko aken.” ");
INSERT INTO mta_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Agulé mesiyapat sinabaan i Hésus, guwaen di, “Maen di ya tukééy daa sa kepigtuu ko diyà kenak? Maen di ya egkeduwa sa pedu ko egpigtuu?” ");
INSERT INTO mta_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hê, egoh da mig-edà diyà kumpit, migsabuh dé sa kelamag. ");
INSERT INTO mta_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Agulé eg-oloen sa medoo salu di diyà kumpit Hésus i, guwaen da, “Tigtu tuu kuna sa Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na, egoh da migkatin dé sa lanaw, migdunggù da si Hésus diyà sa tanà Génésalét. ");
INSERT INTO mta_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Agulé kinilala sa medoo etaw Génésalét Hésus i, huenan di, igsugkow da diyà sa medoo medapag menuwa anì meuwit sa langun etaw eglinadu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Agulé, migpegeni da diyà kenagdi amuk mebaluy amisen daa sa etaw eglinadu sa pelingping ginis di. Hê, nelikuan dé sa langun etaw nekeamis. ");
INSERT INTO mta_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na, duen etaw Palasiyu owoy etaw tegetulù uledin igsugkow i Mosis mig-angay da diyà si Hésus kedu Hélusalém dò. Mig-igsà da, ");
INSERT INTO mta_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","guwaen da, “Maen di ya egtipay sa medoo pasek ko sa adat sa tupù ta danà da endà egpegusê amuk kumaen da?” ");
INSERT INTO mta_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Agulé guwaen i Hésus, “Na kiyu, egtipay yu ma doo sa uledin i Nemula danà yu mig-iling sa adat sa tupù yu. ");
INSERT INTO mta_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Igsugù i Nemula, guwaen di ‘Adati yu sa emà yu owoy sa inay yu.’ Owoy igsugù di ma, ‘Meimatayan sa etaw egpeumàumà sa emà di ataw ka sa inay di.’ ");
INSERT INTO mta_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Dodoo sa niyu itulù, mepion amuk endà tabangan sa etaw sa inay di owoy sa emà di amuk guwaen di, ‘Igbegay ku dé diyà si Nemula siini itabang ku hedem keniyu.’ ");
INSERT INTO mta_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Dodoo danà yu mig-unut diyà iya wé adat yu, ininiyugan yu dé sa kagi i Nemula denu sa keadat etaw sa lukes di. ");
INSERT INTO mta_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ay, neakalan yu kiyu i, enù ka guwaen yu dò metiengaw etaw yu. Tigtu tuu sa kagi i Nemula igsulat i Isayas sa tegesugkow di egoh anay denu keniyu, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Siini medoo etaw, ebà daa sa ig-adat da kenak, dodoo endà egpigtuu sa pedu da diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Huenan di, endà duen sa untung sa kesimbà da diyà kenak enù ka beken kedu kenak sa uledin igtulù da, dodoo danà sa penemdem etaw daa sa itulù da.’ ” ");
INSERT INTO mta_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Agulé, inumow i Hésus sa medoo etaw nesetipon dahiya anì dumapag da diyà kenagdi. Guwaen di, “Dinegdineg yu, hih, anì metiigan yu ini i. ");
INSERT INTO mta_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Endà mesalà sa etaw danà sa igsungit di diyà sa ebà di, dodoo mesalà polo sa etaw danà sa kagi di medaet eglesut diyà sa ebà di.” ");
INSERT INTO mta_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Agulé migdapag sa medoo salu i Hésus diyà kenagdi, owoy guwaen da, “Netiigan ko pa atu egbulit dé sa medoo Palasiyu danà iya wé inikagi ko?” ");
INSERT INTO mta_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Migsagbì Hésus i, guwaen di, “Mebadut doo sa medoo endà hinemula i Emà ku duu diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Huenan di, pemaen yu dé sa medoo Palasiyu, enù ka lagà da langap eg-agak sa duma da langap. Dodoo endà mekeagak sa langap sa duma di langap, enù ka menabù da langun diyà sa medalem tosong diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Agulé guwaen i Pidelu, “Selepang ko diyà kenami sa peligad ko.” ");
INSERT INTO mta_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Guwaen i Hésus, “Negaip a enù ka lagà yu sa medoo liyu etaw endà pa egpeketiig. ");
INSERT INTO mta_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Maen di ya endà pa metiigan yu ini i? Sumalà dé sa kaenen igsungit etaw diyà sa ebà di, egdalem daa diyà sa getek di, agulé eglesut dema diyà sa lawa di. ");
INSERT INTO mta_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dodoo amuk medaet sa kagi eglesut diyà sa ebà di, iya danà sa pedu di medaet, owoy iya sa kenà di mesalà diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Enù ka sa pedu etaw sa linegkangan sa medaet penemdem di, owoy sa keseuma da lawa di sa etaw beken sawa di, owoy sa keimatay di, owoy sa kebigà di, owoy sa kepenakaw di, owoy sa kebutbut di owoy sa kesumbung di duma di. ");
INSERT INTO mta_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Mesalà sa etaw danà iya wé medaet egbaelan di, dodoo endà mesalà di amuk endà egpegusê di egkaen.” ");
INSERT INTO mta_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Agulé, miglegkang Hésus i dahiya owoy eg-angay diyà sa uwang tanà medapag diyà sa menuwa Tilo owoy menuwa Sidon. ");
INSERT INTO mta_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Duen sa bayi eg-ugpà dahiya sa etaw tegeKanan beken etaw Hudiyu. Mig-angay diyà si Hésus, owoy egpetaled eg-ikagi, guwaen di, “O Datù, tugod i Dabid, hiduwi ko aken, enù ka egkepasangan temù sa anak ku bayi danà di linahuk busaw.” ");
INSERT INTO mta_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Dodoo endà egsagipaen i Hésus duu. Agulé, migpedapag sa medoo salu di diyà kenagdi, owoy egpegeni da, guwaen da, “Hemagawi ko iya wé bayi, enù ka takaan di kita eglohot owoy takà eg-umow.” ");
INSERT INTO mta_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Agulé eg-ikagi Hésus i, guwaen di, “Pineangay i Nemula aken anì tabangan ku sa medoo tugod i Islaél enù ka lagà da sa medoo kebilibili netelas.” ");
INSERT INTO mta_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Dodoo migpedapag sa bayi diyà si Hésus, owoy migligkued diyà sa taengan di owoy guwaen di, “O Datù, tabangi ko aken.” ");
INSERT INTO mta_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Agulé, egpeligad Hésus i anì metiigan sa bayi sa medoo etaw Hudiyu daa sa tabangan di. Guwaen di, “Endà mepion di amuk pekawen ta sa kaenen sa batà anì ibegay ta diyà sa tuyang.” ");
INSERT INTO mta_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Agulé guwaen sa bayi, “O Datù, tuu iya wé. Dodoo mebaluy doo amuk kumaen sa tuyang sa kaenen nelemet kedu diyà sa lamisan sa épê da.” ");
INSERT INTO mta_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Agulé, guwaen i Hésus egsagbì, “O Okon, tigtu dakel sa kesalig ko diyà kenak. Huenan di, ibegay ku diyà keniko sa egpegeniyen ko.” Hê, petow dé nelikuan sa anak di bayi. ");
INSERT INTO mta_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na, miglegkang Hésus i dahiya owoy eg-ipanaw eghemantad diyà sa mantadan Lanaw Galiliya. Agulé egtekedeg diyà sa getan owoy egpenuu dahiya. ");
INSERT INTO mta_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Agulé medoo temù sa etaw mig-angay diyà kenagdi eg-uwit sa etaw eglinadu. Duen etaw pikat, duen ma nesadil, duen ma langap, duen ma buneg, owoy duen ma sa medoo eglinadu. Itenà da kagda diyà sa taengan i Hésus owoy egbulungan di kagda langun. ");
INSERT INTO mta_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Agulé, tigtu negaip sa medoo etaw mighaa iya wé, enù ka nekeikagi dé sa etaw buneg, owoy nelikuan ma dé sa etaw nesadil, owoy nekebigkat ma dé sa pikat, owoy mig-ilag ma dé sa langap. Huenan di, eg-oloen da Nemula i, sa Nemula egsaligan sa medoo tegeIslaél. ");
INSERT INTO mta_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Agulé, sinetipon i Hésus sa medoo salu di, owoy guwaen di, “Egkehiduwan ku siini medoo etaw dahini, enù ka telu agdaw dé sa lugay da eg-unut-unut diyà kenak, owoy endà ma dé duen kaenen da. Endà mepion di amuk pelikuen ku kagda amuk egpeketues da enù ka kumelenek da mipanaw.” ");
INSERT INTO mta_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Agulé guwaen sa salu di, “Diyà ki sa melabel tanà mediyù dalesan, owoy endà duen sa kenà ta kumuwa kaenen anì pekaenen ta siini medoo etaw enù ka medoo da temù.” ");
INSERT INTO mta_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Agulé mig-igsà Hésus i, guwaen di, “Pila sa kedoo epan diyà keniyu?” Guwaen da migsagbì, “Duen diyà kenami sa pitu getibulu daa epan owoy duen ma sa tukééy sedà anan diisek.” ");
INSERT INTO mta_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Agulé, pinepenuu i Hésus sa medoo etaw diyà tanà. ");
INSERT INTO mta_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Agulé, kinuwa di sa pitu getibulu epan owoy sa tukééy sedà, owoy egsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Kinebéngkebéng di owoy igbegay di diyà sa medoo salu di, owoy tinukid da egbegayan sa langun etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hê, langun da migkaen owoy nebesug da dé. Agulé tinipoh sa salu di sa nesamà da egkaen pitu pa gesolok. ");
INSERT INTO mta_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Na, duen dahiya epat ngibu maama migkaen, liyu sa medoo bayi owoy sa medoo batà. ");
INSERT INTO mta_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Agulé egpeipanawen i Hésus sa medoo etaw, owoy mig-edà kumpit Hésus i eg-angay dutu uwang menuwa Magadan dò. ");
INSERT INTO mta_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na, duen etaw Palasiyu owoy etaw Sadusiyu mig-angay da diyà si Hésus anì tepengan da. Huenan di, mig-igsà da panduan diyà kenagdi anì metiigan da gaa kagdi sa pineangay i Nemula diyà tanà. ");
INSERT INTO mta_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Dodoo guwaen i Hésus, “Amuk melalegà sa langit egoh agdaw eg-eled, guwaen yu, ‘Umagdaw simag.’ ");
INSERT INTO mta_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Diya ma amuk melalegà sa langit magtu kesimag owoy hauwen yu ma sa dakel alung, guwaen yu, ‘Mudan igkani.’ Neketiig yu doo sa medoo tandà diyà langit, dodoo endà metiigan yu duu sa tandà eghauwen yu ini egoh di. ");
INSERT INTO mta_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Medeumà siini medoo etaw eg-ugpà diyà tanà ini egoh di owoy ininiyugan da Nemula i, enù ka endà egpigtuu da gaa amuk endà hauwen da duu sa dakel panduan. Eg-igsaen yu sa panduan, dodoo endà duen panduan ibegay i Nemula liyu daa sa panduan diyà si Honas egoh anay.” Agulé sinalidan i Hésus kagda. ");
INSERT INTO mta_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na, egkatin sa medoo salu i Hésus tanà dutu sa lanaw, dodoo endà duen sa epan inuwit da enù ka nelipengan da. ");
INSERT INTO mta_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Agulé, migpeligad Hésus i, guwaen di, “Tulik yu, hih, anì mekeiwod yu sa ipelenuk epan sa etaw Palasiyu owoy etaw Sadusiyu.” ");
INSERT INTO mta_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Dodoo sa medoo salu di, endà netiigan da duu sa peligad tinulon i Hésus, huenan di egseolomoy da, guwaen da, “Iya sa inikagi di enù ka endà duen sa epan inuwit ta.” ");
INSERT INTO mta_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Dodoo netiigan i Hésus sa penemdem da, owoy guwaen di, “Ay, tukééy daa sa kepigtuu yu diyà kenak. Maen di ya egseolomen yu sa egoh yu endà mig-uwit epan? ");
INSERT INTO mta_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Negaip a keniyu, enù ka endà pa netiigan yu duu sa egkebaelan ku. Nelipengan yu kéen sa lima getibulu daa epan igpekaen ku diyà sa lima ngibu etaw owoy sa medoo solok pinenù yu sa nesamà ta migkaen. ");
INSERT INTO mta_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nelipengan yu ma kéen sa pitu getibulu daa epan igpekaen ku diyà sa epat ngibu etaw owoy sa medoo solok pinenù yu sa nesamà ta migkaen. ");
INSERT INTO mta_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Negaip a keniyu, enù ka endà pa netiigan yu duu beken tigtu epan sa selepangan sa inikagi ku giina. Tulik yu polo anì mekeiwod yu sa lagà ipelenuk epan sa etaw Palasiyu owoy etaw Sadusiyu.” ");
INSERT INTO mta_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Agulé, netiigan sa medoo salu di beken tigtu ipelenuk epan sa ipeiwod di kenagda, dodoo sa ketulù etaw Palasiyu owoy etaw Sadusiyu polo. ");
INSERT INTO mta_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na, mig-angay Hésus i diyà sa tanà nesakupan sa menuwa Sisaliya Pilipos. Egoh da migtebow, eg-igsaan di sa medoo salu di, guwaen di, “Ngadan di etaw a gaa, aken i Kakay Langun, guwaen sa medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Migsagbì da, guwaen da, “Duen etaw guwaen da dò si Huwan Tegebautis ka gaa, owoy duen ma etaw guwaen da dò si Iliyas ka gaa, ataw ka si Hilimiyas ka gaa, ataw ka sa sebaen ma tegesugkow i Nemula egoh anay kuna i.” ");
INSERT INTO mta_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Agulé guwaen i Hésus, “Enù di ya kiyu i, ngadan sa kagi yu denu kenak?” ");
INSERT INTO mta_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Migsagbì Simon Pidelu i, guwaen di, “Kuna si Kelistu sa Tigtu Datù sinugù i Nemula. Kuna sa Anak sa Tigtu Nemula melalù taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Agulé guwaen i Hésus, “O Simon, anak i Honas, binagian ka, enù ka beken etaw daa diyà tanà sa egpetiig keniko aken sa Anak i Nemula, dodoo si Emà ku diyà langit polo sa egtulon keniko denu kenak. ");
INSERT INTO mta_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Taa ko ini i eg-ikagiyen ku diyà keniko. O Pidelu, eggelalen ku kuna batu enù ka lagà ketegas batu sa kepigtuu ko diyà kenak, owoy lagà siini batu sa petigdegan ku simbaan ku éhê sa medoo etaw egpigtuu. Apiya di pa mepelihay sa etaw ku taman meimatayan da, endà doo meatuwan da. ");
INSERT INTO mta_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kuna sa egbegayan ku egkegaga lagà ka egsabà gunsì anì meukaan sa kedatù i Nemula diyà langit. Huenan di, amuk duen sa eghawidan ko diyà tanà, iya ma sa mehawidan dutu langit dò. Owoy amuk duen sa pandayaen ko diyà tanà, iya ma sa mepandayà dutu langit dò.” ");
INSERT INTO mta_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Agulé, tigtu hinawidan i Hésus sa medoo salu di anì endà tulonen da duu diyà etaw kagdi si Mésayas sa Tigtu Datù sinugù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na, egoh iya, mig-edung Hésus i egtulon diyà sa medoo salu di denu sa ketamanan di. Guwaen di, “Mekeangay a dutu Hélusalém dò. Medoo sa kelikutan ku dutu danà sa medoo kaunutan etaw Hudiyu owoy sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Imatayan da aken, dodoo umenaw a mendaa diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Agulé, inuwit i Pidelu Hésus i egtangkà owoy eghawidan di, guwaen di, “O Datù, endà mebaelan ko iya wé hedem danà i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Agulé migpelikù eg-isalu Hésus i diyà si Pidelu, owoy guwaen di, “Yaka egdahiya ya. Lagà ka si Satanas enù ka begayan ko aken hedem salà. Beken kedu si Nemula iya wé ungayà ko, dodoo kedu diyà etaw daa.” ");
INSERT INTO mta_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Agulé, guwaen i Hésus diyà sa medoo salu di, “Amuk iya sa pedu sa sebaen etaw umunut-unut diyà kenak, meekedan di sa hagdi ungayà owoy sakemen di sa naken. Lagà metiang di ma sa bugsud kenà di mematay, enù ka uman agdaw metigkelan di sa kelikutan di danà di egpangunut sa igsugù ku. Owoy tigtu mekeunut-unut ma diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huenan di, sumalà dé sa etaw umeked umunut diyà kenak enù ka egpekihagtay, iya polo sa etaw mematay. Dodoo sumalà dé sa etaw umeked pekihagtay anì umunut-unut diyà kenak, iya polo sa etaw kumelalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Amuk hediya, endà duen sa tigtu untung mekuwa etaw diyà sa medoo langun taman di diyà tanà. Apiya di pa mekuwa di sa langun, mekesugsug doo enù ka endà duen sa mekesambì di anì melalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na, aken sa Kakay Langun, amuk pelikù a dini unutan a sa medoo egsugùsuguen ku kedu langit owoy sumenang a danà sa senang i Emà ku. Amuk meuma sa agdaw ku pelikù, ibegay ku diyà sa langun etaw sa untung nesugat diyà sa binaelan da. ");
INSERT INTO mta_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tuu ini i eg-ikagiyen ku diyà keniyu. Duen duma etaw dahini ini egoh di endà pa mematay da taman endà hauwen da duu sa ketebow sa Kakay Langun egoh di kumedatù.” ");
INSERT INTO mta_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, egoh di neuma enem agdaw, inuwit i Hésus Pidelu i owoy si Santiyago owoy si Huwan hadi di. Egtekedeg da diyà sa mehagtaw getan kenà da eglebù. ");
INSERT INTO mta_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Agulé, egoh da eghahaa si Hésus, nepelumanan sa palas di egsenang lagà sa agdaw, owoy migkebulà temù sa ginis di enù ka tigtu egsenang. ");
INSERT INTO mta_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hê, hinaa da ma dahiya Mosis i owoy si Iliyas egseolomoy da si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Agulé, eg-ikagi Pidelu i diyà si Hésus, guwaen di, “O Datù, mepion doo enù ka dahini ké. Amuk meiyap ka, mael a telu lawì dini, sebaen niko, sebaen si Mosis, sebaen si Iliyas.” ");
INSERT INTO mta_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Egoh i Pidelu telibubu eg-ikagi iya wé, hê tinenaan da gaeb egsenang. Agulé, duen sa eg-ikagi kedu dalem sa gaeb, guwaen di, “Ini sa anak ku eghiduwan ku owoy tigtu a netuuwan diyà kenagdi. Dinegdineg yu dé diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Egoh sa salu di migdineg iya wé, nekelagkeb da enù ka tigtu da nelimedangan. ");
INSERT INTO mta_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Agulé inangay i Hésus kagda eg-amis, owoy guwaen di, “Tigdeg yu dé. Yoko egkelimedangan na.” ");
INSERT INTO mta_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hê, egoh da egtengang, iya daa sa hinaa da dahiya si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na, egoh da eglungel kedu diyà sa getan, hinawidan i Hésus kagda, guwaen di, “Yoko egtulon duu diyà etaw sa hinaa yu taman endà meenaw sa Kakay Langun egoh di mematay.” ");
INSERT INTO mta_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Agulé eg-igsà sa medoo salu di, guwaen da, “Amuk hediya, maen di ya atu inikagi sa medoo tegetulù uledin igsugkow i Mosis, muna gaa Iliyas i tumebow diyà sa ketebow sa Tigtu Datù sinugù i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Migsagbì Hésus i, guwaen di, “Tuu ini i. Muna Iliyas i tumebow anì abungan di sa ukitan i Datù tumebow. ");
INSERT INTO mta_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Dodoo eg-ikagiyen ku ini i diyà keniyu. Migtebow dé Iliyas i, dodoo endà egkilalaen sa medoo ulu-ulu kagdi i. Pinelihay da polo danà sa hagda ungayà. Hediya ma aken i Kakay Langun, mepelihay a ma danà da.” ");
INSERT INTO mta_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Agulé, netiigan da dé si Iliyas doo sa pinegulepengan di si Huwan Tegebautis. ");
INSERT INTO mta_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na, egoh da miglungel dé, netebowon da sa medoo etaw. Duen maama dahiya mig-angay egdapag diyà si Hésus owoy egligkued diyà sa taengan di. ");
INSERT INTO mta_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Guwaen di, “O Datù, hiduwi ko sa anak ku maama. Egbeketketen danà di linahuk busaw owoy egkepasangan temù enù ka takà egpekesunù diyà apuy owoy egkeeled diyà wayeg. ");
INSERT INTO mta_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Inuwit ku ma diyà sa medoo salu ko anì bulungan da hedem, dodoo endà egkegaga da duu.” ");
INSERT INTO mta_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Agulé eg-ikagi Hésus i, guwaen di, “Ay, kiyu i medoo etaw ini egoh di, ngahàngahà yu temù owoy tigtu yu endà egsalig diyà kenak. Huenan di, egkesemek a dé eg-ugpà diyà keniyu, owoy buyu a dé egtalawen danà sa endà kepigtuu yu. Na, uwit ko dini sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Agulé, hinawidan i Hésus sa busaw owoy miglesut ma dé. Hê, petow dé nelikuan sa batà. ");
INSERT INTO mta_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Agulé, egoh da i Hésus eglebù, eg-igsà da diyà kenagdi, guwaen da, “Maen di ya endà negaga ké duu eghemaga sa busaw diyà sa batà?” ");
INSERT INTO mta_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Migsagbì Hésus i, guwaen di, “Endà megaga yu duu enù ka tukééy pelà sa kepigtuu yu. Tuu ini i eg-ikagiyen ku diyà keniyu. Apiya di pa tukééy daa sa kepigtuu yu diyà kenak lagà tukééy dalem mustad, dakel doo sa megaga yu. Upama amuk suguen yu siini getan pehalì daedò é, mangunut doo diyà sa kagi yu. Enù ka sumalà dé sa baelan yu, megaga yu langun. ");
INSERT INTO mta_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Dodoo siini balangan busaw, endà mehemagawan da amuk endà tigtu yu sumimbà diyà si Nemula owoy amuk endà peulanen yu duu sa kekaen yu.” ");
INSERT INTO mta_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na, egoh da nesetipon diyà sa uwang Galiliya, mig-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Aken i Kakay Langun, buyu a dé mekebegay diyà sa medoo liyu etaw ");
INSERT INTO mta_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","anì imatayan da aken, dodoo meenaw a mendaa diyà sa ketelu di agdaw.” Egoh sa medoo salu di migdineg iya wé, tigtu da nebukul temù. ");
INSERT INTO mta_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na, egoh da migtebow diyà sa menuwa Kapelenaum, duen etaw dahiya eg-etuk sa ibegay etaw Hudiyu diyà sa Dalesan i Nemula diyà Hélusalém. Eg-igsaan da Pidelu i, guwaen da, “Enù di ya, mekebegay pa sa mistelu yu sa pilak eg-etuken ké ibegay diyà sa Dalesan i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Migsagbì Pidelu i, guwaen di, “Hoò, megay doo.” Agulé egoh di miggemow diyà sa dalesan, egoh i Pidelu endà pa eg-ikagi, eg-igsaan i Hésus kagdi, guwaen di, “O Simon, ngadan sa penemdem ko denu ini i? Ngadan tayu di etaw mekebegay pilak diyà sa datù diyà tanà, ataw ka sa tigtu duma di iling ka sa liyu etaw?” ");
INSERT INTO mta_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Migsagbì Pidelu i, guwaen di, “Sa medoo liyu etaw daa sa mekebegay.” Agulé guwaen i Hésus, “Amuk hediya, endà mekebegay sa medoo tigtu duma di. ");
INSERT INTO mta_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Dodoo endà mepion di amuk bulitan sa medoo tegeetuk pilak kita, huenan di angay ka duli lanaw dò owoy hauwen ko doo sa pilak diyà sa ebà sa sedà muna mekuwa ko. Mekeenget doo iya wé diyà sa mekebegay ta diyà sa Dalesan i Nemula, enù ka duwa ki. Uwit ko owoy begayi ko dé diyà sa tegeetuk.” ");
INSERT INTO mta_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na egoh iya, mig-angay eg-igsà sa medoo salu i Hésus diyà kenagdi, guwaen da, “Ngadan tayu di etaw sa dakel diyà sa medoo etaw eg-unut diyà sa kedatù i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Agulé, inumow i Hésus sa batà owoy pinetigdeg di diyà sa taengan sa medoo salu di. ");
INSERT INTO mta_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Endà mekeunut yu diyà sa kedatù i Nemula amuk endà pelumanan yu duu sa pedu yu anì mekeiling yu batà sa keunut yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Enù ka sa etaw egpetukééyen di kagdi iling siini batà, iya polo sa dakel etaw diyà sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Owoy sumalà dé sa etaw miadat sa etaw ku éhê siini batà danà di etaw ku, meadatan di ma aken i danà iya wé egbaelan di.” ");
INSERT INTO mta_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Agulé guwaen i Hésus, “Amuk duen sa etaw eg-enggat diyà salà sa etaw ku egpigtuu éhê siini batà, iya sa etaw tigtu mepigtamayan i Nemula. Adi-adi pa amuk tagkesan dakel batu diyà lieg di anì meeled diyà dagat. ");
INSERT INTO mta_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mepasangan sa medoo etaw diyà tanà enù ka duen sa egbegay salà diyà kenagda. Duen doo sa takà egbegay salà diyà etaw, dodoo tigtu mepigtamayan sa etaw eg-enggat sa duma di egbael salà. ");
INSERT INTO mta_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Upama, amuk meenggat yu diyà salà danà sa belad yu ataw ka sa lisen yu, tagped yu owoy buungi yu ma dé enù ka uman pa mepion sa egoh yu melalù taman melugay apiya di pa neputuk sa belad yu ataw ka lisen yu diyà sa egoh yu épê duwa belad ataw ka duwa lisen mekeangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hediya ma, amuk meenggat yu diyà salà danà sa mata yu, lesò yu owoy buungi yu ma dé enù ka uman pa mepion sa egoh yu melalù apiya di pa sebaen daa sa mata yu diyà sa egoh yu épê duwa mata mekeangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hahaa yu, anì endà eg-ekedan yu duu sa tukééy etaw ku lagà siini batà. Tuu ini i eg-ikagiyen ku diyà keniyu, kagda sa egtulikan sa medoo egsugùsuguen i Nemula duma i Emà ku diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Na, ini sa pesuwan di mig-angay sa Kakay Langun diyà tanà anì mealukan sa medoo etaw egpekesugsug.” ");
INSERT INTO mta_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Agulé guwaen i Hésus, “Upama, duen sa etaw diyà keniyu épê magatus kebilibili. Amuk netelas sa sebaen kebilibili di, salidan di sa siyow pulù owoy siyow egtabtab diyà getan, owoy eg-angayen di eglagbet sa sebaen netelas taman endà hauwen di duu. ");
INSERT INTO mta_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk hinaa di sa sebaen netelas, tigtu meanggan sa pedu di danà di mighaa. Uman pa sa kekeanggan di danà di mighaa sa sebaen diyà sa kekeanggan di diyà sa siyow pulù owoy siyow endà netelas. ");
INSERT INTO mta_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hediya ma sa Emà ta diyà langit, enù ka ungayà di endà duen etaw mekesugsug apiya sebaen daa tukééy etaw di.” ");
INSERT INTO mta_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Agulé guwaen i Hésus, “Amuk duen duma ko egpigtuu egbael salà diyà keniko, angay ko tulon diyà kenagdi sa medaet binaelan di, dodoo lebù yu daa egseolomoy. Agulé, amuk eg-ekedan di sa salà di, egbuligan ko dé kagdi i egpepigtuu. ");
INSERT INTO mta_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Dodoo amuk endà egpigtuu di diyà sa kagi ko, peunut ko sa duma etaw, iling ka sebaen etaw ataw ka duwa, owoy pelikù yu dema diyà kenagdi anì dumuen duwa etaw ataw ka telu egpetuu sa kagi ko diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Agulé, amuk endà egpigtuu di diyà keniyu, tulon ko dé diyà sa umpungan i Hésus. Agulé amuk endà pa egpigtuu di diyà sa kaunutan sa umpungan i Hésus, yoko eg-unut duu enù ka kagdi dé lagà etaw tegebael salà endà egpigtuu diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na, tuu ini i eg-ikagiyen ku diyà keniyu. Amuk duen sa eghawidan yu diyà tanà, iya ma sa mehawidan dutu langit dò. Owoy amuk duen sa egpandayaen yu diyà tanà, iya ma sa mepandayà dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ini ma sa eg-ikagiyen ku diyà keniyu. Amuk duwa yu daa dahini diyà tanà owoy neseunut sa pedu yu denu sa isimbà yu, mebegayan yu doo i Emà ku diyà langit sa egpegeniyen yu. ");
INSERT INTO mta_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Enù ka amuk duwa yu daa nesetipon ataw ka telu yu anì sumimbà yu diyà kenak, dahiya a ma doo diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Agulé, migpedapag Pidelu i diyà si Hésus owoy guwaen di, “O Datù, amuk takà egkesalà sa etaw diyà kenak, pila gulê ipeuloy ku sa salà di? Enget pa amuk pitu gulê?” ");
INSERT INTO mta_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Agulé migsagbì Hésus i, guwaen di, “Endà. Beken pitu gulê daa, dodoo takà ko peuloyi polo kenagdi, apiya taman pitu pulù gulê anan tigpituway. ");
INSERT INTO mta_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Enù ka lagà ini i sa kedatù i Nemula. Duen sa datù ungayà di eg-etuk sa utang sa medoo etaw di. ");
INSERT INTO mta_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Egoh di mig-edung eg-etuk, inuwit da diyà kenagdi sa etaw épê dakel utang danà di migsagbay ngibu-ngibuwan pilak. ");
INSERT INTO mta_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dodoo endà pa egpekebayad di sa utang di, huenan di igsugù sa datù anì meudipen da lapeg sa sawa di owoy sa medoo anak di owoy medagang ma sa langun taman da anì bayadan di sa utang di. ");
INSERT INTO mta_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Dodoo migligkued sa etaw diyà sa taengan sa datù, owoy egpegeni, guwaen di, ‘O Datù, angat-angat ka pelà, hih, enù ka impasan ku sa langun utang ku diyà keniko.’ ");
INSERT INTO mta_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Agulé, igpeuloy dé sa datù sa langun utang di danà sa kehidu di kenagdi, owoy linengaan di ma kagdi i. ");
INSERT INTO mta_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Agulé egoh sa maama miglegkang dahiya, nesiegungan di diyà dalan sa sebaen duma di nekeutang tukééy daa pilak diyà kenagdi. Hê, egpelengen di kagdi, owoy guwaen di, ‘Bayadi ko dé sa utang ko kenak.’ ");
INSERT INTO mta_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Agulé, egligkued diyà sa taengan di, owoy egpegeni, guwaen di, ‘O Akay, angat-angat ka pelà, hih, enù ka impasan ku sa langun utang ku diyà keniko.’ ");
INSERT INTO mta_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Dodoo eg-eked siedò etaw, owoy ipebilanggu di polo kagdi taman endà mekebayad di. ");
INSERT INTO mta_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Na, egoh sa medoo duma di neketiig iya wé, tigtu nebukul sa pedu da. Agulé, mig-angay da egtulon diyà sa datù sa langun binaelan di. ");
INSERT INTO mta_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Hê, igpeangay sa datù iya wé etaw, owoy guwaen di, ‘Dupang ka kuna i etaw. Egoh ko migpegeni diyà kenak, igpeuloy ku dé diyà keniko sa langun utang ko. ");
INSERT INTO mta_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Maen di ya endà ma egkehiduwan ko sa duma ko éhê mendaa sa kehidu ku keniko?’ ");
INSERT INTO mta_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Agulé, tigtu egbulitan sa datù kagdi i owoy ipebilanggu di anì mepigtamayan taman endà mebayadan di duu sa langun utang di.” ");
INSERT INTO mta_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Agulé guwaen i Hésus, “Hediya ma sa baelan i Emà ku Nemula diyà keniyu amuk endà tigtu yu duu ipeuloy sa salà sa duma yu.” ");
INSERT INTO mta_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na, egoh i Hésus neubus migtulù iya wé, eglegkang diyà sa uwang Galiliya owoy eg-angay tanà dutu lawaꞌt Holdan diyà sa uwang Hudiya. ");
INSERT INTO mta_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eg-unut ma sa melaweng etaw diyà kenagdi owoy egbulungan di ma sa langun etaw eglinadu dahiya. ");
INSERT INTO mta_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na, duen etaw Palasiyu mig-angay diyà si Hésus enù ka eglagbeten da sa kagi di neketipay sa uledin. Eg-igsà da, guwaen da, “Enù di ya, meketipay pa sa etaw diyà sa uledin ta amuk eg-ekedan di sa sawa di apiya endà duen sa medaet binaelan di?” ");
INSERT INTO mta_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Agulé migsagbì Hésus i, guwaen di, “Lagà yu endà nekebasa sa kagi i Nemula igpesulat. Egoh i Nemula migbael sa langun taman egoh anay, binaelan di sa sebaen maama owoy sa sebaen bayi. ");
INSERT INTO mta_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ini sa kagi i Nemula igpesulat, guwaen di, ‘Iya maen di ya mesalidan sa maama sa emà di owoy sa inay di owoy mekeugpà dé diyà sa sawa di enù ka lagà sebaen etaw da daa.’ ");
INSERT INTO mta_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Na, endà dé duwa sa etaw telesawa, dodoo nesesebaen da dé. Huenan di, endà mepion di amuk mesepalak sa etaw telesawa enù ka nesesebaen da dé danà i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Agulé, eg-igsaan dema sa medoo Palasiyu, guwaen da, “Amuk endà mebaluy di iya wé, ngadan sa pesuwan di igsugù i Mosis egoh anay dumuen sa igsulat ibegay sa maama diyà sa sawa di anì tandaan di sa keeked di egoh di eghemaga kenagdi?” ");
INSERT INTO mta_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Agulé migsagbì Hésus i, guwaen di, “Iya sa igtulù i Mosis mebaluy ekedan yu sa sawa yu, enù ka netiigan di metegas sa ulu yu. Dodoo egoh anay egoh i Nemula migbael sa etaw, endà mebaluy di ekedan sa etaw sa sawa di. ");
INSERT INTO mta_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk eg-ekedan sa maama sa sawa di endà migbigà, egbigà doo amuk sawaen di sa sebaen bayi.” ");
INSERT INTO mta_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Agulé guwaen sa medoo salu di, “Amuk iya sa kelikutan sa etaw épê sawa, uman pa mepion hedem amuk endà dé sumawa di.” ");
INSERT INTO mta_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Agulé guwaen i Hésus, “Beken sa langun etaw sa endà sumawa, dodoo sa etaw hinemilì i Nemula daa sa endà sumawa. ");
INSERT INTO mta_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Enù ka endà nesetepeng di sa pesuwan di endà sumawa sa etaw. Duen etaw endà sumawa enù ka duen sa kulang da egoh da miglesut. Owoy duen ma etaw endà sumawa enù ka kinapun da. Owoy duen ma etaw endà sumawa anì endà mealang da egtulù denu sa kedatù i Nemula. Amuk kuna sa etaw hinemilì i Nemula anì endà sumawa ka, pangunut ka dé diyà sa igsugù di.” ");
INSERT INTO mta_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na, duen medoo etaw mig-uwit sa medoo anak da diyà si Hésus anì sabaan di kagda anì isimbà di. Dodoo eghawidan sa medoo salu di kagda. ");
INSERT INTO mta_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Agulé, guwaen i Hésus diyà sa salu di, “Pandayà yu dé sa medoo batà mangay diyà kenak. Yoko eghawid duu, enù ka iya sa etaw mekeunut diyà sa kedatù i Nemula sa medoo etaw egpekeiling pedu batà.” ");
INSERT INTO mta_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Agulé, sinabaan i Hésus sa medoo batà owoy isimbà di kagda. Agulé, miglegkang dema dahiya. ");
INSERT INTO mta_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na, duen sa maama mig-angay eg-igsà diyà si Hésus, guwaen di, “O Mistelu, ngadan sa mepion baelan ku anì dumuen lalù ku endà meelut di?” ");
INSERT INTO mta_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Guwaen i Hésus, “Maen di ya eg-igsaen ko diyà kenak sa mepion egbaelan ko? Endà duen sa etaw mepion liyu daa si Nemula. Dodoo amuk ungayà ko melalù ka taman melugay, pangunuti ko sa uledin i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Agulé, eg-igsà dema sa maama, guwaen di, “Ngadan tayu sa uledin pangunutan ku?” Agulé guwaen i Hésus, “Iya sa uledin di, yoko eg-imatay ya etaw, owoy yoko egbigà ya, owoy yoko egpenakaw wa, owoy yoko egbutbut ta egtipu sa duma yu, ");
INSERT INTO mta_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","owoy adati yu sa emà yu owoy sa inay yu, owoy hiduwi ko ma sa duma ko éhê mendaa sa kehidu ko keniko.” ");
INSERT INTO mta_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Agulé guwaen sa maama, “Langun siini uledin di, anan egpangunutan ku. Ngadan pa sa baelan ku?” ");
INSERT INTO mta_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Guwaen i Hésus diyà kenagdi, “Amuk iya sa ungayà ko tigtu metiengaw ka diyà sa kehaa i Nemula, angay ko dagang sa langun taman ko owoy tukidi ko begayi diyà sa medoo etaw pubeli. Amuk hediya, dumuen sa pantiyali ko diyà langit. Agulé angay ka dini unut-unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Dodoo egoh di migdineg sa kagi i Hésus, miglikù owoy nebenges temù sa pedu di enù ka tigtu kawasà. ");
INSERT INTO mta_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Agulé, mig-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Tigtu melikut sa medoo kawasà etaw mekeunut sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Egtulonen ku diyà keniyu endà megaga da duu. Uman pa melemu sa hinagtay kamiliyu eg-ukit diyà sa tosong dagum diyà sa kawasà etaw mekeunut diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Egoh sa medoo salu di migdineg iya wé, tigtu da negaip temù owoy guwaen da, “Amuk hediya, endà duen etaw kéen mealukan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Dodoo eg-inengtengen i Hésus kagda, owoy guwaen di, “Tuu ma doo, endà mebaluy di amuk etaw daa, dodoo mebaluy doo amuk si Nemula enù ka megaga di doo sa langun egbaelan.” ");
INSERT INTO mta_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Agulé guwaen i Pidelu, “Taa ko. Sinalidan ké dé sa langun taman ké enù ka eg-unut-unut ké keniko. Enù kami i duu, ngadan sa untung mekuwa ké?” ");
INSERT INTO mta_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Agulé, guwaen i Hésus diyà kenagda, “Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk pelumanan i Nemula sa tanà, menuu sa Kakay Langun diyà sa bangkù di metolol egoh di kumedatù. Owoy kiyu i salu ku, menuu yu ma diyà sa sepulù owoy duwa bangkù sa datù enù ka ipaten yu sa sepulù owoy duwa geumpung tugod i Islaél. ");
INSERT INTO mta_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na, sumalà dé sa etaw sinalidan di sa dalesan di ataw ka sa tanà di, ataw ka sa emà di owoy sa inay di, ataw ka sa kakay di owoy sa hadi di, ataw ka sa medoo anak di danà di eg-unut-unut diyà kenak, meumanan pa magatus gulê sa mesakem di owoy dumuen ma sa lalù di endà meelut di. ");
INSERT INTO mta_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Dodoo sa medoo etaw dakel diyà sa kehaa yu ini egoh di, kumetukééy da polo kani. Owoy sa medoo etaw tukééy diyà sa kehaa yu ini egoh di, pedakelen i Nemula polo kagda.” ");
INSERT INTO mta_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Agulé guwaen i Hésus, “Lagà ini i sa kedatù i Nemula. Duen sa etaw épê tanà hinemulaan di palas. Agulé, sebaen agdaw eglapus eglagbet etaw anì gumalebek da diyà sa hinemulaan di. ");
INSERT INTO mta_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Igpasad di diyà sa anay etaw kinuwa di sa sukay da sapilak, enù ka iya sa enget sukay sa etaw eggalebek segeagdaw. Agulé egpegalebeken di kagda diyà sa hinemulaan di. ");
INSERT INTO mta_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Agulé egoh di alas siyow, egpelikù eglagbet etaw anì gumalebek da. Hê, hinaa di sa medoo etaw diyà padian endà duen galebek da. ");
INSERT INTO mta_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Guwaen di diyà kenagda, ‘Angay yu ma eggalebek diyà sa hinemulaan ku owoy sukayan ku kiyu sa nesugat.’ Agulé eggalebek da ma dé. ");
INSERT INTO mta_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na, egoh di alas sepulù owoy duwa, egpelikù dema diyà sa padian anì umanan di sa kedoo etaw eggalebek. Hediya ma sa binaelan di egoh di alas telu mahapun. ");
INSERT INTO mta_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Agulé, egoh di buyu alas lima mahapun, egpelikù dema diyà sa padian owoy duen ma etaw hinaa di dahiya endà duen galebek da. Eg-igsaan di kagda, guwaen di, ‘Maen di ya eg-ugpà yu uloy dahini owoy endà eggalebek yu?’ ");
INSERT INTO mta_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Egsagbì da, guwaen da, ‘Enù ka endà duen etaw egpegalebek kenami.’ Agulé guwaen di, ‘Angay yu ma galebek dutu siedò hinemulaan ku.’ ");
INSERT INTO mta_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Agulé, egoh di eg-eled dé sa agdaw, eg-ikagi sa maama diyà sa sinaligan di, guwaen di, ‘Umow ko sa medoo etaw eggalebek owoy sukayi ko dé. Sukayi ko muna sa hudihudi eggalebek, agulé sukayi ko sa muna eggalebek.’ ");
INSERT INTO mta_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na, sapilak sa sukay di diyà sa uman sebaen etaw mig-edung eggalebek egoh di alas lima mahapun. ");
INSERT INTO mta_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Huenan di, egoh di eg-angay egsukay sa medoo etaw eggalebek edung magtu kesimag, iya sa penemdem da umanan pa sa hagda sukay. Dodoo, sapilak ma doo sa sukay di kenagda. ");
INSERT INTO mta_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Egoh da migkuwa sa sukay da, egsigbolow da diyà sa etaw egpegalebek kenagda, ");
INSERT INTO mta_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","guwaen da, ‘Sakaulas daa sa lugay siedò etaw eggalebek, dodoo kami, egtigkelan ké sa meedup agdaw eggalebek neelut agdaw. Maen di ya nesetepeng sa kesukay ko kenami eggalebek?’ ");
INSERT INTO mta_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Agulé, guwaen sa épê tanà diyà sa sebaen etaw, ‘Na, Akay, endà lapisen ku kiyu enù ka tapay dé inikagi ku sapilak sa sukay yu egoh ku migpegalebek keniyu, owoy iya ma sa igbegay ku diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, kuwa yu sa sukay yu owoy likù yu dé. Enù ka iya sa ungayà ku nesetepeng sa isukay ku sa hudihudi eggalebek owoy sa muna eggalebek. ");
INSERT INTO mta_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Endà mehawidan a etaw amuk meiyap a megay sa pilak ku diyà sa sumalà dé etaw egkeiyapan ku. Enù di ya, egsinu-sinu ka danà ku metawag diyà kenagda?’” ");
INSERT INTO mta_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Agulé guwaen i Hésus, “Hediya ma, kumedakel doo sa medoo etaw tukééy dé diyà sa kehaa yu ini egoh di. Dodoo kumetukééy polo sa medoo etaw dakel diyà sa kehaa yu ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, egoh i Hésus egtekedeg eg-angay Hélusalém dò, inuwit di sa sepulù owoy duwa salu di owoy eg-ikagiyan di kagda egoh di endà duen liyu etaw mekedineg. ");
INSERT INTO mta_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Guwaen di, “Taa yu, hih. Mangay ki Hélusalém dò. Amuk tumebow ki dutu, mekebegay sa Kakay Langun diyà sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Mesesebaen sa penemdem da meimatayan a, ");
INSERT INTO mta_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","huenan di ibegay da aken diyà sa medoo etaw beken Hudiyu. Peumàumaan da aken, owoy tapesen a ma, owoy imatayan da ma aken itutuk diyà sa kayu igbugsud. Dodoo amuk meuma sa ketelu di agdaw, meenaw a doo.” ");
INSERT INTO mta_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Agulé, mig-angay diyà si Hésus sa sawa i Sébediyu owoy sa duwa anak di, si Santiyago owoy si Huwan. Egligkued diyà sa taengan i Hésus enù ka duen sa egpegeniyen di diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Agulé eg-igsà Hésus i, guwaen di, “Ngadan sa ungayà ko diyà kenak?” Guwaen sa bayi, “Amuk meuma sa kedatù ko, pepenuu ko siini duwa anak ku anì kumedatù da ma, sebaen denu kuwanan ko owoy sebaen denu bibang ko.” ");
INSERT INTO mta_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Agulé, guwaen i Hésus diyà kenagda, “Endà netiigan yu duu sa kebegat sa egpegeniyen yu diyà kenak. Enù di ya, mekegaga yu pa tumigkel sa kelikutan meukitan ku?” Guwaen da egsagbì, “Hoò, metigkelan ké doo iya wé.” ");
INSERT INTO mta_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Agulé guwaen i Hésus, “Meukitan yu ma doo sa kelikutan mekeuma diyà kenak. Dodoo beken aken sa humemilì tayu sa etaw mekepenuu denu kuwanan ku ataw ka denu bibang ku, enù ka si Emà ku polo sa mekehemilì sa etaw mekepenuu dahiya.” ");
INSERT INTO mta_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na, egoh sa sepulù duma salu di migdineg denu sa pinegeni da diyà si Hésus, egbulitan da Santiyago i owoy si Huwan hadi di. ");
INSERT INTO mta_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Agulé, sinetipon i Hésus sa langun salu di owoy guwaen di, “Netiigan ta dé sa egbaelan sa medoo ulu-ulu etaw beken Hudiyu, enù ka takaan da egpeges sa medoo etaw da danà sa dakel egkegaga da, owoy takaan da ma kagda egsugù. ");
INSERT INTO mta_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Dodoo endà mebaluy di amuk ilingan yu iya wé egbaelan da. Amuk duen etaw diyà keniyu ungayà di pedakelen di kagdi, mepion polo amuk petukééyen di lagà sa egsugùsuguen yu atung egbulig keniyu. ");
INSERT INTO mta_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Hediya ma, amuk duen etaw diyà keniyu ungayà di pedakelen di kagdi, mepion amuk petukééyen di polo kagdi lagà sa udipen yu. ");
INSERT INTO mta_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Meilingan di ma aken i Kakay Langun, enù ka beken iya sa pesuwan ku mig-angay diyà tanà anì metabangan a etaw. Dodoo mig-angay a dini anì metabangan ku polo sa medoo etaw owoy meimatayan a ma anì melaun ku sa medoo etaw neudipen danà sa salà da.” ");
INSERT INTO mta_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na, egoh da i Hésus migtalà diyà sa menuwa Héliko, duen melaweng etaw eg-unut diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Duen duwa maama langap egpenuu diyà sa kilidan kalasada. Egoh da neketiig tumalà Hésus i dahiya, eg-umow da, guwaen da, “O tugod i Dabid, hiduwi ko kami.” ");
INSERT INTO mta_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Agulé, eghawidan sa medoo etaw, guwaen da, “Yoko egséléken na.” Dodoo, eg-umanen da polo eg-umow metaled, guwaen da, “O Datù, tugod i Dabid, hiduwi ko kami.” ");
INSERT INTO mta_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Agulé, mig-ugpà Hésus i owoy inumow di kagda, guwaen di, “Ngadan sa egkeiyapan yu baelan ku diyà keniyu?” ");
INSERT INTO mta_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Guwaen da, “O Datù, ungayà ké umilag ké hedem.” ");
INSERT INTO mta_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Agulé eghiduwan i Hésus kagda, owoy eg-amisen di sa mata da. Hê, petow da dé mig-ilag, owoy eg-unut-unut da ma diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na, egoh da i Hésus egkedapag diyà Hélusalém, buyu da dé dumagpak diyà sa menuwa Bétpagi diyà sa lagpian Getan Olibu. Agulé, sinugù i Hésus sa duwa salu di, ");
INSERT INTO mta_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","guwaen di, “Huna yu dé angay dutu siedò menuwa tebowon ta. Amuk tumebow yu dutu, hauwen yu sa hinagtay asnu owoy sa nati di. Lengà yu owoy uwit yu dini. ");
INSERT INTO mta_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amuk duen etaw umigsà keniyu, iya sa sagbì yu, guwaen yu, ‘Igsugù i Datù enù ka duen sa penemdem di.’ Agulé pandayaen di kiyu eg-uwit sa hinagtay owoy sa nati di.” ");
INSERT INTO mta_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Na, danà iya wé, neketuu dé sa kagi sa tegesugkow i Nemula egoh anay, ");
INSERT INTO mta_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","guwaen di, “Ini sa tulon ko diyà sa medoo etaw tegeHélusalém. Haa yu, tumebow sa Datù yu ini egoh di. Dodoo kagdi sa migpetukééy owoy egkudà diyà sa nati asnu.” ");
INSERT INTO mta_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Agulé, mig-ipanaw sa duwa salu di owoy tinuu da sa igsugù di kenagda. ");
INSERT INTO mta_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Agulé inuwit da sa hinagtay asnu owoy sa nati di diyà si Hésus. Inampisan da ginis sa iyug di owoy migkudà Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Agulé, igtenàtenà sa medoo etaw sa ginis da diyà sa ukitan i Hésus, owoy duen ma etaw egkuwa panga kayu melaweng daun itenàtenà da diyà sa ukitan di, enù ka egtandaan da sa kedatù da kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na, sa medoo etaw eg-unut diyà si Hésus, iling ka muna ataw ka hudihudi, eg-edung da eg-ikagi metaled. Guwaen da, “Meolò sa tugod i Dabid eg-angat-angatan ta. Meolò ma sa pineangay i Datù Nemula. Meolò ma Nemula i diyà langit.” ");
INSERT INTO mta_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na, egoh i Hésus migtebow diyà Hélusalém, negaip sa langun etaw dahiya. Egseigsaay da, guwaen da, “Ngadan iya wé etaw egtebow?” ");
INSERT INTO mta_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Egsagbì sa medoo etaw mig-unut diyà si Hésus, guwaen da, “Kagdi si Hésus sa tegesugkow i Nemula kedu diyà menuwa Nasalét diyà sa uwang Galiliya.” ");
INSERT INTO mta_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Agulé, migludep Hésus i diyà sa Dalesan i Nemula owoy hinemagawan di sa medoo etaw tegedagang owoy sa medoo egbeli dahiya. Pinekinilid di ma sa medoo lamisan etaw tegesambì pilak owoy sa medoo bangkù sa tegedagang manuk imatayan da ibegay diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Guwaen di diyà kenagda, “Iya sa kagi i Nemula igpesulat, guwaen di, ‘Sa Dalesan ku iya sa dalesan atung egsimbaan etaw.’ Dodoo danà sa egbaelan yu dahini, nebaluy dalesan sa medoo tegelapis polo siini Dalesan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Agulé, duen ma medoo etaw langap owoy etaw pikat mig-angay da diyà si Hésus diyà sa Dalesan i Nemula, owoy egbulungan di kagda. ");
INSERT INTO mta_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dodoo egbulit sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis danà da mighaa sa medoo panduan binaelan i Hésus owoy danà da ma migdineg sa kagi sa medoo batà egseumowoy diyà sa Dalesan i Nemula, guwaen da, “Meolò sa tugod i Dabid!” ");
INSERT INTO mta_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Huenan di, egbulitan sa medoo ulu-ulu Hésus i, guwaen da, “Amuk egdinegen ko sa kagi da, maen di ya endà eghawidan ko duu?” Migsagbì Hésus i, guwaen di, “Egdinegen ku doo sa kagi da, dodoo mepion doo iya wé diyà kenak. Lagà endà nekebasa yu sa kagi i Nemula igpesulat, guwaen di, ‘Tinulù i Nemula sa medoo batà anì mepion sa keolò da kenagdi.’ ” ");
INSERT INTO mta_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Agulé sinalidan i Hésus kagda dahiya, owoy eg-angay dutu menuwa Bétaniya dò kenà di mesegduwan. ");
INSERT INTO mta_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na, egoh di sumimag egoh da egpelikù Hélusalém dò, egpeketues Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hinaa di sa kayu pigus medapag diyà sa ilis kalasada owoy eg-angay eglagbet sa bunga di. Dodoo endà duen bunga di, anan daun di daa sa hinaa di. Huenan di, guwaen di diyà sa kayu, “Endà dé munga di ini i kayu.” Hê, petow dé nelaeb sa kayu pigus. ");
INSERT INTO mta_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Egoh sa medoo salu di mighaa iya wé, negaip da owoy guwaen da, “Maen di ya petow dé nelaeb siini kayu pigus?” ");
INSERT INTO mta_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk egpigtuu yu diyà si Nemula owoy amuk endà egsagàsagà yu, mekebael yu doo panduan uman pa dakel diyà siini panduan ku diyà sa kayu pigus. Amuk ikagiyan yu daa siini getan anì humalì dagat dò, mangunut doo diyà sa kagi yu. ");
INSERT INTO mta_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amuk egsimbà yu diyà si Nemula owoy egsalig yu ma diyà kenagdi, mekuwa yu doo sa egpegeniyen yu.” ");
INSERT INTO mta_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na, migpelikù Hésus i diyà sa Dalesan i Nemula owoy egtulù dema dahiya. Agulé, duen medoo ulu-ulu tegesimbà owoy medoo kaunutan Hudiyu eg-angay da eg-igsà diyà kenagdi, guwaen da, “Ngadan keduwan sa egkegaga ko egbael siini medoo binaelan ko? Ngadan di etaw sa migpeangay keniko?” ");
INSERT INTO mta_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Egsagbì Hésus i, guwaen di, “Duen ma sa igsà ku diyà keniyu. Amuk sagbian yu aken, tulonen ku ma diyà keniyu sa keduwan sa naken egkegaga. ");
INSERT INTO mta_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Enù di ya, ngadan sa migsugù si Huwan egoh di migbautis sa medoo etaw diyà wayeg, ataw ka si Nemula ataw ka sa etaw daa?” Agulé, egsesigbolowoy da denu sa isagbì da, guwaen da, “Amuk sumagbì ki, guwaen ta, ‘Si Nemula sa migsugù kenagdi,’ sumulì mikagi Hésus i, guwaen di, ‘Maen di ya endà egpigtuuwen yu duu?’ ");
INSERT INTO mta_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dodoo amuk sumagbì ki, guwaen ta, ‘Sa etaw daa,’ melimedangan ki sa medoo etaw enù ka netuuwan da si Huwan sa tegesugkow i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huenan di, egsagbì da diyà si Hésus, guwaen da, “Enday ta duu. Endà netiigan ké duu sa migsugù si Huwan.” Agulé guwaen i Hésus, “Amuk hediya, endà ma tulonen ku duu diyà keniyu sa keduwan sa naken egkegaga.” ");
INSERT INTO mta_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Agulé guwaen i Hésus, “Na, penemdem yu ini i eg-ikagiyen ku. Duen sa maama épê duwa anak maama. Mig-angay diyà sa lebì lawa anak di owoy guwaen di, ‘Na Adug, angay ka galebek diyà sa hinemulaan ku ini egoh di.’ ");
INSERT INTO mta_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Dodoo guwaen di egsagbì, ‘Meked a.’ Agulé, endà iseg di nelugay, nepelumanan sa penemdem di owoy eg-angay doo eggalebek. ");
INSERT INTO mta_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Agulé mig-angay sa maama diyà sa hadi anak di, owoy hediya ma sa igsugù di kenagdi. Agulé guwaen sa anak di, ‘Hoò, mangay a gumalebek.’ Dodoo endà eg-angay di eggalebek. ");
INSERT INTO mta_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na, ngadan sa tayu batà migpangunut diyà sa igsugù sa emà di?” Sinagbian da, guwaen da, “Sa kakay anak di.” Agulé, guwaen i Hésus diyà kenagda, “Tuu ini i eg-ikagiyen ku diyà keniyu. Duen medoo etaw nekehuna diyà keniyu egpekeunut diyà sa kedatù i Nemula, apiya di pa medaet da etaw, lagà sa medoo atung egpeetuken sa sulutan owoy sa medoo tegepediyangdang. ");
INSERT INTO mta_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mig-angay egtulù si Huwan Tegebautis diyà keniyu anì ekedan yu sa salà yu anì kumetiengaw yu diyà sa kehaa i Nemula, dodoo endà egpigtuuwen yu duu. Iya polo sa migpigtuu diyà kenagdi sa medoo etaw egpeetuken sa Sulutan owoy sa medoo tegepediyangdang. Apiya di pa hinaa yu sa egoh da migpigtuu, endà doo eg-ekedan yu duu sa medaet egbaelan yu owoy endà ma egpigtuu yu diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Agulé guwaen i Hésus, “Dinegdineg yu siini peligad ku. Duen sa maama mighemula palas diyà sa tanà di. Linesed di, owoy tinosongon di sa dakel batu kenà di humemeg palas, owoy binaelan di ma sa lawì mehagtaw kenà sa tegebantay umugpà. Agulé, igsalig di diyà sa medoo etaw atung eg-ipat, enù ka mangay mediyù dò. ");
INSERT INTO mta_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Agulé, egoh di neuma sa bulan kepupu sa bunga di, pineangay di sa duma egsugùsuguen di diyà sa medoo etaw tegeipat anì kuwaen da sa hagdi baed. ");
INSERT INTO mta_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Dodoo egoh da migtebow, medaet polo sa kinebael sa etaw tegeipat, enù ka sinesuntuk da sa sebaen owoy inimatayan da ma sa sebaen, owoy binuung da ma batu sa sebaen. ");
INSERT INTO mta_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Agulé, pineangay dema sa épê tanà sa uman pa kedoo egsugùsuguen di diyà kenagda. Dodoo, hediya ma medaet sa kinebael da kenagda. ");
INSERT INTO mta_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Agulé, pineangay di sa anak di diyà kenagda, enù ka guwaen di dò meadatan da doo sa anak di amuk hauwen da. ");
INSERT INTO mta_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dodoo egoh sa medoo tegeipat mighaa sa anak di, egseolomoy da, guwaen da, ‘Ini sa etaw kumuwa siini hinemulaan lalawan di diyà sa emà di. Téél yu dé, imatayan ta anì nita polo sa hinemulaan di.’ ");
INSERT INTO mta_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Agulé, sinigkem da owoy hinemagawan da kedu diyà sa hinemulaan, owoy inimatayan da. ");
INSERT INTO mta_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na, amuk mangay dutu sa épê hinemulaan, ngadan sa baelan di diyà siedò medoo etaw tegeipat?” ");
INSERT INTO mta_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Agulé guwaen da egsagbì, “Iya sa baelan di imatayan di siedò medaet etaw tegeipat, owoy isalig di ma sa hinemulaan di diyà sa liyu etaw anì kagda polo sa megay sa hagdi baed uman palay.” ");
INSERT INTO mta_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Agulé guwaen i Hésus diyà kenagda, “Lagà yu endà nekebasa siini kagi i Nemula igpesulat, guwaen di, ‘Sa sebaen batu inekedan sa medoo tegebael dalesan pulung batu enù ka guwaen da dò endà duen ulan di, iya polo sa tigtu miulan batu hinemilì ku. Anan mepion iya wé binaelan i Datù, huenan di meolò kagdi i.’ ");
INSERT INTO mta_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Na, tuu ini i eg-ikagiyen ku diyà keniyu. Endà dé mekeunut yu sa kedatù i Nemula, dodoo iya polo sa mekeunut diyà sa kedatù di sa etaw takà egpangunut diyà sa igsugù di. ");
INSERT INTO mta_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Amuk mekekinagpà sa etaw diyà siini batu, melepù. Dodoo amuk menabù siini batu diyà sa etaw, melupet.” ");
INSERT INTO mta_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na, egoh sa medoo ulu-ulu tegesimbà owoy etaw Palasiyu migdineg sa peligad i Hésus, netiigan da kagda sa egkesugat peligad di. ");
INSERT INTO mta_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Huenan di, ungayà da hedem sigkemen da Hésus i. Dodoo endà megaga da duu enù ka nelimedangan da sa medoo etaw, enù ka netuuwan sa medoo etaw si Hésus sa tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na, egpeligad dema Hésus i diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","guwaen di, “Lagà ini i sa kedatù i Nemula diyà langit. Duen sa datù egbael pista enù ka kumawing sa anak di. ");
INSERT INTO mta_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Egoh di neuma sa agdaw da kumaen, sinugù di sa medoo egsugùsuguen di anì angayen da sa langun etaw igsasà di, dodoo eg-eked da polo eglenged. ");
INSERT INTO mta_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Agulé, pineangay di sa medoo duma egsugùsuguen di diyà sa medoo etaw igsasà di. Guwaen da, ‘Angay yu gaa dutu. Sinumbalì dé gaa sa sapì owoy sa hinagtay mitabà, owoy nelegà dé sa langun kaenen. Téél yu dé, angay yu kaen gaa.’ ");
INSERT INTO mta_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Dodoo lagà endà egdinegen da duu, enù ka egpeiges da polo sa hagda galebek. Duen sa sebaen eg-angay diyà sa hinemulaan di, owoy duen ma sa eg-angay diyà sa tinda di. ");
INSERT INTO mta_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Owoy duen ma liyu etaw migsigkem sa medoo egsugùsuguen di, owoy sinesuntuk da kagda, owoy inimatayan da ma. ");
INSERT INTO mta_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Agulé egbulit temù sa datù. Huenan di, pineangay di sa medoo sundalu di anì imatayan da siedò medoo tegeimatay owoy ulowen da ma sa hagda menuwa. ");
INSERT INTO mta_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Agulé, guwaen sa datù diyà sa medoo egsugùsuguen di, ‘Nelegà dé sa kaenen pista, dodoo endà egpelengeden ku duu sa medoo etaw igsasà ku enù ka mig-eked da eg-angay dini. ");
INSERT INTO mta_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Huenan di, angay yu diyà sa dakel kalasada, owoy pelenged yu diyà sa pista ku sa langun etaw hauwen yu dahiya.’ ");
INSERT INTO mta_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Agulé, mig-angay da diyà sa medoo kalasada, owoy egpelengeden da diyà pista sa langun etaw hinaa da, iling ka mepion etaw ataw ka medaet. Agulé, nebelet etaw sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Na, endà nelugay di, inangay sa datù egtelow sa medoo etaw miglenged diyà sa pista di. Agulé, hinaa di sa sebaen etaw endà ikawal di duu sa kawal sa etaw eglenged sa pista kawing. ");
INSERT INTO mta_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Agulé guwaen sa datù diyà kenagdi, ‘O Akay, maen di ya miggemow ka dini amuk endà ikawal ko duu sa kawal sa eglenged pista kawing?’ Dodoo endà egpekesagbì di. ");
INSERT INTO mta_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Agulé, guwaen sa datù diyà sa egsugùsuguen di, ‘Polot yu sa belad di owoy sa lisen di, owoy buungi yu ma dé kagdi diyà sa deleman kenà di mepigtamayan. Suminegaw dutu owoy kuméget sa ngipen di danà di tigtu mepasangan.’” ");
INSERT INTO mta_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Agulé guwaen i Hésus, “Apiya di pa medoo sa etaw igsasà i Nemula anì mekeunut da sa kedatù di, tukééy daa sa etaw mehemilì di.” ");
INSERT INTO mta_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Agulé sinalidan sa medoo Palasiyu Hésus i, owoy egseolomoy da sa kebael da kenagdi anì metipu da kagdi amuk meamu sa kagi di. ");
INSERT INTO mta_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Agulé, duen duma pasek da owoy duma etaw i Datù Hélod pineangay da diyà si Hésus. Guwaen da diyà kenagdi, “O Mistelu, netiigan ké anan tuu sa langun eg-ikagiyen ko. Endà eghalìhalien ko duu sa igtulù ko sumalà dé sa balangan etaw egdineg, dodoo metudà polo sa ketulù ko sa uyot i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na, duen sa igsà ké diyà keniko. Tuloni ko kami sa penemdem ko. Enù di ya, meketipay ki pa sa uledin igsugkow i Mosis amuk megay ki pelesintu diyà si Sisal sa sulutan ta? Mepion pa ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dodoo netiigan i Hésus sa pandapat da medaet, owoy guwaen di, “Kiyu i tegeakal etaw, enù ka guwaen yu dò metiengaw etaw yu. Maen di ya egtepengan yu aken? ");
INSERT INTO mta_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pehauwi yu diyà kenak sa kuleta ibegay yu pelesintu.” Agulé igbegay da diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eg-igsà Hésus i, guwaen di, “Ngadan iya wé etaw diyà sa kuleta owoy sa sulat di?” ");
INSERT INTO mta_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Egsagbì da, guwaen da, “Iya si Sisal sa sulutan ta.” Guwaen i Hésus, “Amuk hediya, begayi yu diyà si Sulutan Sisal sa hagdi egpegeniyen, owoy begayi yu ma diyà si Nemula sa hagdi egpegeniyen.” ");
INSERT INTO mta_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Egoh da migdineg iya wé sagbì di, egkegaip da, owoy sinalidan da kagdi i owoy eg-ipanaw da ma dé. ");
INSERT INTO mta_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na siiya agdaw, duen etaw Sadusiyu mig-angay da eg-igsà diyà si Hésus. Kagda sa etaw Hudiyu egtulù endà umenaw di gaa sa etaw nematay. ");
INSERT INTO mta_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Eg-igsà da, guwaen da, “O Mistelu, duen sa igsulat i Mosis denu sa egbaelan ta amuk nematay sa maama épê sawa dodoo endà duen anak da. Iya sa baelan di, ipesawa diyà sa hadi di sa balu anì dumuen anak da lagà sa anak sa maama nematay. ");
INSERT INTO mta_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, duen pitu maama telehadi mig-ugpà diyà kenita. Agulé migsawa sa kakay da, dodoo endà duen anak da egoh di nematay. Hê, inited sa tigtu hadi di sa sawa sa kakay di. ");
INSERT INTO mta_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hediya ma sa nebaelan sa keduwa maama owoy sa ketelu di taman sa kepitu di, enù ka nesetuhìtuhì da migsawa sa bayi, dodoo nelengon da nematay endà duen anak. ");
INSERT INTO mta_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Agulé hudihudi nematay sa bayi. ");
INSERT INTO mta_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, tulon ko diyà kenami. Amuk meuma sa keenaw sa medoo etaw nematay, ngadan tayu di etaw diyà sa pitu telehadi sa mesawa siedò bayi? Enù ka anan da migsawa kenagdi egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Dodoo migsagbì Hésus i, guwaen di, “Tigtu eg-amu sa penemdem yu, enù ka endà netiigan yu duu sa kagi i Nemula igpesulat owoy endà ma netiigan yu duu sa egkebaelan i Nemula danà sa tunung di. ");
INSERT INTO mta_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amuk enawen di sa medoo etaw nematay, endà dé sesawaay da enù ka lagà da dé egsugùsuguen di diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Endà netiigan yu duu umenaw doo sa etaw nematay enù ka lagà yu endà nekebasa sa kagi i Nemula igpesulat, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Aken sa Nemula egpigtuuwen da i Ablaham si Isak owoy si Hakob.’ Na, egoh i Nemula mig-ikagi iya wé, nelugay da dé nematay da Ablaham i si Isak owoy si Hakob. Dodoo apiya di pa nematay da dé diyà tanà, nehagtay da doo diyà sa kehaa i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Agulé negaip sa medoo etaw danà da migdineg sa ketulù i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Na, egoh sa medoo etaw Palasiyu neketiig tinabanan i Hésus sa medoo Sadusiyu danà sa sagbì di nesugat, nesetipon da ma diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Duen sebaen Palasiyu tegetulù sa uledin i Mosis ungayà di tepengan di Hésus i, huenan di eg-igsà, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O Mistelu, ngadan sa tayu mapulù uledin diyà sa langun uledin igsugkow i Mosis egoh anay?” ");
INSERT INTO mta_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Egsagbì Hésus i, guwaen di, “Pusungi ko si Nemula sa Datù ko. Peunuti ko diyà kenagdi sa langun pedu ko owoy sa langun penemdem ko ma. ");
INSERT INTO mta_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iya sa tigtu mapulù uledin diyà sa langun uledin. ");
INSERT INTO mta_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Owoy ini sa keduwa di uledin mapulù, ‘Hiduwi ko sa duma ko éhê mendaa sa kehidu ko keniko.’ ");
INSERT INTO mta_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Amuk egpangunutan ko siini duwa uledin, mepangunutan ko dé sa langun uledin igsugkow i Mosis owoy sa langun ketulù sa medoo tegesugkow i Nemula egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Na, egoh da nesetipon pelà sa medoo Palasiyu, eg-igsaan i Hésus kagda, ");
INSERT INTO mta_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","guwaen di, “Ngadan sa penemdem yu denu si Mésayas sa Tigtu Datù eg-angat-angatan sa medoo Hudiyu? Ngadan di etaw sa tupù di?” Migsagbì da, guwaen da, “Kagdi sa tugod i Dabid egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Agulé guwaen i Hésus, “Amuk tuu iya wé, maen di ya guwaen i Dabid si Mésayas sa Datù di? Enù ka pinesulat sa Suguy i Nemula Dabid i egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ini sa kagi i Datù Nemula diyà sa Datù ku, guwaen di, Penuu ka dahini denu kuwanan ku taman atuwan ku sa medoo kuntelà ko owoy ipeutuh ku keniko.’ ");
INSERT INTO mta_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na, amuk iya sa kagi i Dabid egoh anay denu si Mésayas, guwaen di ‘Datù ku,’ endà mebaluy di tugod i Dabid daa kagdi i, dodoo Datù di ma.” ");
INSERT INTO mta_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dodoo endà duen etaw mekesagbì kenagdi. Huenan di edung egoh iya, endà dé eg-uman da eg-igsà enù ka egkelenawan da amuk metepelan da. ");
INSERT INTO mta_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Agulé, migtulù Hésus i diyà sa medoo salu di owoy diyà sa medoo etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Guwaen di, “Sa medoo tegetulù uledin owoy sa medoo Palasiyu, kagda sa sinaligan sa uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huenan di, pangunut yu takà diyà sa langun igtulù da keniyu. Dodoo yoko eg-iling duu sa egbaelan da enù ka endà egpangunut da sa uledin igtulù da. ");
INSERT INTO mta_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Takaan da egdugang sa uledin melikut, dodoo endà egtabangan da duu sa etaw egpangunut diyà sa uledin. Lagà da sa etaw egpebegat sa duma da, dodoo endà egtabangan da duu kagda. ");
INSERT INTO mta_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Takà da ipehaa sa kepangunut da uledin diyà sa medoo etaw anì metuuwan sa etaw diyà kenagda. Pelabelen da sa kenà di sinulatan kagi i Nemula eg-uwit-uwiten da owoy eg-upionen da sa metaes kawal da anì egpenemdemen etaw kagda sa metiengaw etaw diyà sa kehaa i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Amuk mangay da diyà sa pista, ungayà da kagda sa muna pekaenen. Owoy amuk mangay da diyà sa simbaan, ungayà da menuu diyà sa bangkù ginelal. ");
INSERT INTO mta_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Egkeiyap da amuk egsaluan sa medoo etaw kagda diyà sa padian owoy amuk eg-umowen etaw kagda ‘Mistelu.’ ");
INSERT INTO mta_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Dodoo endà mepion di amuk umowen etaw kiyu ‘Mistelu,’ enù ka setelehadiyay yu langun owoy aken daa sa mistelu egtulù keniyu. ");
INSERT INTO mta_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Endà ma mepion di amuk umowen yu ‘Emà’ sa liyu etaw diyà tanà, enù ka sebaen daa sa Emà yu si Nemula diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Endà ma mepion di amuk umowen yu etaw ‘Datù,’ enù ka aken daa sa Datù yu si Mésayas pineangay i Nemula diyà tanà. ");
INSERT INTO mta_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Na, sa tayu dakel etaw diyà keniyu, mepion amuk lagà egsugùsuguen yu polo. ");
INSERT INTO mta_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iya maen di ya enù ka sa etaw egpedakelen di kagdi, iya sa petukééyen i Nemula, dodoo sa etaw egpetukééyen di kagdi, iya sa pedakelen i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Guwaen i Hésus, “O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Eg-alangen yu sa medoo etaw egkelukuy eg-unut diyà sa kedatù i Nemula. Medaet iya wé enù ka endà mekeunut yu sa kedatù di owoy hawidan yu ma sa etaw anì endà ma mekeunut da. ");
INSERT INTO mta_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Egtepelen yu sa medoo dalesan sa bayi balu danà sa medoo pandapat yu, dodoo eglidungen yu sa medaet egbaelan yu. Amuk hauwen yu etaw, melugay yu ubòubò egsimbà. Huenan di, uman pa dakel sa kepigtamay i Nemula mekeuma diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Tigtu megelol yu egtulù anì mekeunut sa etaw diyà keniyu, apiya sebaen daa. Dodoo danà sa ketulù yu kenagdi, uman polo migkedupang siedò etaw, huenan di mepigtamayan diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Hahaa yu enù ka dakel sa kepigtamay i Nemula mekeuma diyà keniyu. Lagà yu sa etaw langap eg-agak sa duma di langap. Egtulù yu mebaluy tipayen sa etaw sa igpasad di amuk iya daa sa igpengibet di sa Dalesan i Nemula. Dodoo itulù yu ma endà mebaluy di tipayen sa etaw sa igpasad di amuk igpengibet di sa bulawan diyà sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kiyu lagà sa langap etaw egkebuneg. Endà mekepenemdem yu enù ka apiya di pa milagà siedò bulawan, uman pa doo milagà sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Egtulù yu ma mebaluy tipayen sa etaw sa igpasad di amuk iya daa sa igpengibet di sa kenà da eg-imatay hinagtay diyà sa Dalesan i Nemula. Dodoo itulù yu ma endà mebaluy di tipayen sa etaw sa igpasad di amuk iya sa igpengibet di sa hinagtay inimatayan da dahiya. ");
INSERT INTO mta_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kiyu lagà langap enù ka endà duen sa egketiigan yu. Apiya di pa milagà sa hinagtay inimatayan da diyà sa Dalesan i Nemula, uman pa milagà sa kenà da eg-imatay hinagtay dahiya. ");
INSERT INTO mta_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huenan di, amuk ipengibet sa etaw sa kenà da eg-imatay hinagtay diyà sa Dalesan i Nemula, beken iya daa sa igpengibet di enù ka ipengibet di ma sa langun igtenà dahiya. ");
INSERT INTO mta_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hediya ma, amuk ipengibet sa etaw sa Dalesan i Nemula, beken iya daa sa igpengibet di enù ka ipengibet di ma Nemula i sa eg-ugpà dahiya. ");
INSERT INTO mta_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Owoy amuk ipengibet sa etaw sa langit, iya sa igpengibet di sa kenà i Nemula egpenuu, huenan di si Nemula sa tigtu igpengibet di. ");
INSERT INTO mta_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Egtaladan yu Nemula i sa langun egketuwen yu, apiya sa medoo tukééy ipinanam kaenen daa. Dodoo endà egpangunutan yu duu sa mapulù uledin di, enù ka medaet sa adat yu diyà sa duma yu owoy endà eghiduwan yu duu kagda owoy endà ma kesaligan yu. Na, nesugat sa egbaelan yu egtalad, dodoo eg-amu yu enù ka endà egpeunuten yu duu dahiya sa mepion adat yu diyà sa duma yu. ");
INSERT INTO mta_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lagà yu sa etaw langap eg-agak sa duma di langap. Lagà yu sa etaw egkedan sa beneboh diyà sa inemen di, dodoo amahen yu polo sa dakel hinagtay kamiliyu. ");
INSERT INTO mta_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Lagà yu sa etaw eglingu sa medoo iyug tabù owoy batik, dodoo lueden doo sa dalem di. Hediya ma, eg-udes yu egpigtuu diyà sa medoo adat yu, dodoo lenglengen sa pedu yu owoy big-imawen yu. ");
INSERT INTO mta_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kiyu i medoo Palasiyu, lagà yu etaw langap enù ka endà duen sa egketiigan yu. Huna yu pepion sa pedu yu anì kumepion ma sa langun egbaelan yu, lagà sa etaw eglingu sa dalem tabù owoy batik anì tigtu melanih langun. ");
INSERT INTO mta_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Lagà yu sa lebeng binintulà mebulà. Apiya di pa metolol sa egoh-egoh di, nepenù doo tuelan etaw nematay owoy mahù ma. ");
INSERT INTO mta_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Diya ma kiyu i, mepion sa egbaelan yu diyà sa kehaa etaw, dodoo diyà sa lungag yu nepenù yu butbut owoy salà. ");
INSERT INTO mta_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“O medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka guwaen yu dò metiengaw etaw yu. Eg-upionen yu sa kenà lebeng sa medoo tegesugkow i Nemula owoy sa liyu metiengaw etaw nematay egoh anay, owoy egpetololen yu ma sa medoo lebeng da. ");
INSERT INTO mta_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iya sa kagi yu, guwaen yu, ‘Amuk nehagtay ké daa egoh anay, endà mekeunut ké hedem sa medoo tupù ta mig-imatay sa medoo tegesugkow i Nemula egoh anay.’ ");
INSERT INTO mta_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na, danà iya wé inikagi yu, ipetiig yu dé medaet ma sa pedu yu enù ka kiyu sa tugod sa etaw mig-imatay sa medoo tegesugkow i Nemula egoh anay. ");
INSERT INTO mta_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na, ilingi yu dé sa medoo tupù yu anì ubusen yu sa medaet inedungan da. ");
INSERT INTO mta_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Lagà yu uled owoy medoo anak uled, enù ka tigtu medaet sa egbaelan yu. Endà mekeiwod yu sa kepigtamay i Nemula tumebow, enù ka hemagawan di kiyu mangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Taa yu ini i eg-ikagiyen ku diyà keniyu. Peangayen ku pa diyà keniyu sa medoo tegesugkow i Nemula owoy sa medoo etaw milantek owoy sa medoo etaw tumulù keniyu. Dodoo duen etaw diyà kenagda imatayan yu, owoy duen ma itutuk yu diyà sa kayu igbugsud, owoy duen ma tapesen yu diyà sa simbaan yu, owoy duen ma pelihayen yu sumalà dé sa angayan da. ");
INSERT INTO mta_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Huenan di, pigtamayan i Nemula kiyu i langun danà sa tupù yu mig-imatay sa medoo etaw metiengaw egoh anay, edung sa egoh i Abel sa metiengaw etaw inimatayan egoh anay taman sa egoh i Sakaliyas anak i Balakiyas inimatayan egoh anay medapag diyà sa kenà da eg-imatay hinagtay diyà sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tuu ini i eg-ikagiyen ku diyà keniyu. Mepigtamayan i Nemula kiyu i etaw eg-ugpà diyà tanà ini egoh di danà siedò medoo metiengaw etaw inimatayan da egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Agulé guwaen i Hésus, “O medoo etaw tegeHélusalém, taa yu, hih. Takà yu eg-imatay sa medoo tegesugkow i Nemula, owoy egsebuungen yu ma batu sa medoo etaw pineangay di diyà keniyu anì mematay da. Nelugay dé sa pedu ku egtipoh keniyu anì ipaten ku kiyu, lagà sa umelen egtipoh sa anak di, dodoo eg-eked yu polo. ");
INSERT INTO mta_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Haa yu siini menuwa yu igtohonen i Nemula dé. ");
INSERT INTO mta_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Taa yu, hih, ini i eg-ikagiyen ku diyà keniyu. Endà dé mehaa yu duu aken taman endà pelumanan yu sa pedu yu diyà kenak. Iya pelawà mehaa yu aken amuk mikagi yu, guwaen yu, ‘Meolò sa pineangay i Datù Nemula diyà tanà.’ ” ");
INSERT INTO mta_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Agulé, migliyu Hésus i diyà sa Dalesan i Nemula. Egoh di miglegkang, migpedapag sa medoo salu di diyà kenagdi anì ipehaa da diyà kenagdi sa metolol Dalesan i Nemula owoy sa medoo dalesan medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Dodoo guwaen i Hésus diyà kenagda, “Apiya di pa eg-oloen yu siini medoo eghauwen yu metolol, egtulonen ku keniyu tumebow pa sa agdaw di mekedan langun. Megubal sa kelatkat di anan batu sinelogsudlogsud anì pa sebaen sa mesamà.” ");
INSERT INTO mta_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Agulé mig-angay Hésus i diyà sa Getan Olibu owoy migpenuu dahiya. Egoh da eglebù dahiya, migpedapag sa medoo salu di diyà kenagdi owoy eg-igsà da, guwaen da, “Tuloni ko kami, hih, nengan di ya tumebow iya wé tinulon ko? Ngadan sa tandà di amuk buyu meuma sa kepelikù ko owoy amuk medapag ma sa sabuhanan agdaw?” ");
INSERT INTO mta_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Agulé guwaen i Hésus, “Tulik yu anì endà meakalan yu, ");
INSERT INTO mta_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","enù ka dumuen sa medoo etaw tegeakal tumebow peiling kenak guwaen da kagda gaa si Mésayas sa Tigtu Datù sinugù i Nemula. Hê, meakalan sa medoo etaw umunut diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Amuk dinegen yu sa medoo etaw egsegilaway medapag diyà keniyu ataw ka sa lalag sa gila dutu mediyù dò, yoko egkelimedangan na, enù ka muna pelawà mukit siini medoo medaet diyà tanà, dodoo beken pelà iya sa tandà di meuma sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mesegila sa medoo etaw, enù ka sa medoo etaw diyà sa sebaen tanà mangay da gumila diyà sa sebaen ma tanà, owoy sa medoo etaw sa sebaen datù mangay da ma gumila diyà sa sebaen ma datù. Dumuen ma dakel bitil owoy dakel linug umukit diyà sa medoo balangan tanà. ");
INSERT INTO mta_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Dodoo apiya di pa medaet iya wé meukitan yu, iya polo sa edungan sa kelikutan yu tumebow, lagà sa edungan sa kesakit sakal tugedamen sa bayi amuk lesutan. ");
INSERT INTO mta_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Huenan di, melepuhan langun etaw kiyu i danà sa kepigtuu yu kenak. Sigkemen da kiyu anì mepelihay yu owoy imatayan da ma kiyu. ");
INSERT INTO mta_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Amuk hediya, duen ma medoo etaw umeked da migtuu diyà kenak. Meselepuh da, owoy ibegay da ma diyà sa ulu-ulu sa duma da egpigtuu anì meimatayan da. ");
INSERT INTO mta_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Duen ma medoo etaw tumebow ubòubò da tegesugkow i Nemula, owoy meakalan ma sa medoo etaw danà sa ketulù da. ");
INSERT INTO mta_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mekeseluh ma sa medaet adat etaw, huenan di tukééy daa sa kesehiduway sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Dodoo amuk metigkelan sa etaw siini langun kelikutan, mebegayan doo sa lalù endà meelut di. ");
INSERT INTO mta_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mekeseluh ma siini tegudon denu sa kedatù i Nemula diyà siini sinukub langit anì mekedineg sa langun etaw. Agulé, tumebow sa sabuhanan agdaw.” ");
INSERT INTO mta_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Guwaen i Hésus, “Na, iya sa tinulon i Daniyél tegesugkow i Nemula egoh anay dumuen sa etaw tumebow mael medaet dalem sa Dalesan i Nemula owoy tigtu melimedangan sa medoo etaw danà sa egbaelan di. Na, amuk egpekebasa yu sa kagi i Daniyél igsulat, petiigtiig yu. Na, amuk hauwen yu siedò medaet diyà sa Dalesan i Nemula, ");
INSERT INTO mta_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","pelaguy yu angay yu diyà sa medoo getan, kiyu i eg-ugpà diyà tanà Hudiya. ");
INSERT INTO mta_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Amuk diyà duwangen sa etaw owoy diatas sa langun taman di, endà dé mebaluy di amuk gumemow angayen di, dodoo salidan di polo. ");
INSERT INTO mta_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Diya ma amuk diyà tinibah sa etaw, endà dé mebaluy di amuk lumikù angayen di sa kawal di, dodoo melaguy polo. ");
INSERT INTO mta_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Amuk meuma iya wé, mepasangan da temù sa medoo bayi obol owoy sa medoo egpesusu tukééy anak da enù ka melikutan da melaguy. ");
INSERT INTO mta_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Huenan di, simbà yu diyà si Nemula anì endà mekepelaguy yu amuk timpù udan ataw ka sa agdaw keetud. ");
INSERT INTO mta_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Enù ka tigtu medaet temù iya wé kelikutan tumebow diyà tanà. Endà pa duen sa kelikutan uman pa medaet hinaa ta edung sa egoh tanà binaelan taman ini egoh di, owoy endà ma duen sa kelikutan tumebow lumowon sa kedaet di. ");
INSERT INTO mta_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dodoo kinulangan i Nemula sa lugay siedò medaet, enù ka amuk endà kulangan di duu, mekesugsug sa langun etaw. Dodoo kinulangan di dé danà sa kehidu di sa medoo etaw hinemilì di. ");
INSERT INTO mta_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Na, amuk duen etaw mikagi diyà keniyu, guwaen di, ‘Kaini dé Mésayas i sa Tigtu Datù sinugù i Nemula,’ ataw ka guwaen di, ‘Daedò é kagdi i,’ yoko egpigtuu duu iya wé. ");
INSERT INTO mta_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Enù ka tumebow pa sa medoo etaw tegebutbut, owoy guwaen da dò kagda gaa si Mésayas sa Tigtu Datù, ataw ka ubòubò da tegesugkow i Nemula. Mael da ma sa medoo panduan owoy sa medoo tandà egkegaipan etaw, enù ka iya sa ungayà da akalan da hedem sa medoo etaw hinemilì i Nemula, asal mebaluy. ");
INSERT INTO mta_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Huenan di, tulik yu anì endà meakalan yu, enù ka tapay ku dé tinulon iya wé diyà keniyu egoh di endà pa tumebow. ");
INSERT INTO mta_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Na, amuk duen etaw mikagi diyà keniyu, guwaen di, ‘Haa yu, dutu siedò melabel tanà mediyù dalesan sa Tigtu Datù sinugù i Nemula,’ yoko eg-angay ya dutu. Diya ma, amuk guwaen sa etaw, ‘Haa yu, kagdi sa miglidung daedò é,’ yoko egpigtuu duu. ");
INSERT INTO mta_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Enù ka sa kepelikù sa Kakay Langun, lagà sa legdaw silà mekebensek uwang tanà kedu tebowon agdaw taman eledan agdaw, enù ka mehaa doo sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Upama, sumalà dé sa kenà sa nematay, iya ma sa kenà da mesetipon sa medoo uwak. Diya ma, metiigan yu doo sa ketebow ku.” ");
INSERT INTO mta_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Agulé guwaen i Hésus, “Amuk meubus iya wé kelikutan, dumeleman sa tanà enù ka kumeitem sa agdaw owoy endà ma sumenang sa bulan. Menabù ma sa medoo bituen kedu diyà langit, owoy humalìhalì sa langun eghauwen ta diyà langit. ");
INSERT INTO mta_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iya pelawà mehaa etaw sa tandà diyà langit sa ketebow sa Kakay Langun. Suminegaw sa langun etaw diyà tanà, enù ka hauwen da aken i Kakay Langun pelikù peunutan gaeb diyà langit. Dakel sa egkegaga ku kumedatù owoy tigtu dakel ma sa senang ku. ");
INSERT INTO mta_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dumuen sa metaled dagì petegbuliyen ku, owoy peangayen ku ma sa medoo egsugùsuguen ku anì setiponen da sa langun etaw hinemilì ku, sumalà dé sa kenà da eg-ugpà diyà siini sinukub langit.” ");
INSERT INTO mta_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Agulé guwaen i Hésus, “Taa yu, hih, siini balatan denu sa kayu pigus. Amuk egtugbung sa kayu pigus owoy egdaun sa medoo panga di, metiigan yu doo medapag dé sa meedup agdaw. ");
INSERT INTO mta_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Diya ma, amuk hauwen yu siedò medoo tinulon ku umukit, metiigan yu ma doo buyu a dé pelikù. ");
INSERT INTO mta_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tuu ini i eg-ikagiyen ku diyà keniyu. Sa medoo duma ta eg-ugpà diyà tanà ini egoh di, amuk endà pa mematay da langun, hauwen da doo iya wé tinulon ku umukit. ");
INSERT INTO mta_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mekedan pa siini langit owoy siini tanà, dodoo endà mekedan sa kagi ku taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Agulé guwaen i Hésus, “Endà tulonen ku duu diyà keniyu sa agdaw ku pelikù ataw ka sa ulas di. Endà duen etaw meketiig sa kepelikù ku, iling ka sa medoo egsugùsuguen i Nemula diyà langit ataw ka aken i Anak i Nemula, enù ka si Emà ku daa sa meketiig. ");
INSERT INTO mta_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amuk meuma sa agdaw sa Kakay Langun pelikù, mepetow sa medoo etaw eg-ugpà diyà tanà éhê mendaa sa medoo etaw duma i Nuwi egoh anay. ");
INSERT INTO mta_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Enù ka egoh anay egoh di endà pa egdagpak sa dakel kemahà, endà eglengaan da duu sa medoo egbaelan da diyà tanà, enù ka egkaen da owoy eg-inem da owoy egpesawa da ma taman endà egdalem si Nuwi diyà sa dakel kumpit. ");
INSERT INTO mta_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dodoo endà netiigan da duu sa sugsug da egtebow taman endà egdagpak sa dakel memahà. Hê nelened da langun. Hediya ma, mepetow ma sa medoo etaw amuk pelikù sa Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Taa yu, hih. Amuk meuma siedò agdaw ku pelikù, dumuen duwa maama diyà sa tinibah, mekedan sa sebaen owoy mesamà sa duma di. ");
INSERT INTO mta_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dumuen ma duwa bayi eggiling, mekedan sa sebaen owoy mesamà sa duma di. ");
INSERT INTO mta_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Huenan di, tulik yu enù ka endà netiigan yu duu sa atas i Datù yu pelikù. ");
INSERT INTO mta_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Taa yu, hih. Amuk netiigan sa épê dalesan sa ketebow sa tegepenakaw amuk sigep, endà tumudug di dodoo unungan di polo anì endà mekeludep di dalem sa tegepenakaw. ");
INSERT INTO mta_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Huenan di, tulik yu takà enù ka endà netiigan yu duu sa agdaw sa Kakay Langun tumebow.” ");
INSERT INTO mta_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Agulé guwaen i Hésus, “Upama, ngadan di etaw sa sinaligan sa datù eghemilien di? Iya sa etaw hemilien di, sa egsugùsuguen di meudes owoy melabel penemdem. Kagdi sa kaunutan diyà sa medoo duma di egsugùsuguen owoy kagdi sa metiig egbegay kaenen diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Amuk tumebow sa datù, mebagian temù siedò kaunutan amuk mepion sa kepangunut di sa igsugù sa datù di. ");
INSERT INTO mta_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk mepion sa egbaelan di, kagdi sa mesaligan sa datù sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Dodoo sa kaunutan endà mipedu di, iya sa penemdem di melugay sa ketebow sa datù di. ");
INSERT INTO mta_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Agulé tapesen di sa medoo duma di egsugùsuguen, owoy takà egpista owoy eghiluwen neseunut da sa etaw tegepehilu. ");
INSERT INTO mta_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Agulé, pelikù sa datù di diyà sa agdaw endà netulikan di duu owoy sa ulas endà netiigan di duu. ");
INSERT INTO mta_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hê, pigtamayan di temù, enù ka iya sa ketamanan sa langun etaw ubòubò egpigtuu. Suminegaw da temù dutu owoy kuméget sa ngipen da danà da tigtu mepasangan.” ");
INSERT INTO mta_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Agulé guwaen i Hésus, “Amuk meuma sa kepelikù ku, lagà ini ma sa kedatù i Nemula. Duen sa sepulù kenogon mangay tumelabuk sa maama kawingen. Uman sebaen kenogon, pulung da eg-uwit palitaan. ");
INSERT INTO mta_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mipedu sa lima kenogon, dodoo endà mipedu sa lima. ");
INSERT INTO mta_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na, sa lima endà mipedu, inuwit da sa palitaan da, dodoo endà inuwitan da duu lanaegas legà di. ");
INSERT INTO mta_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dodoo inuwit sa lima kenogon mipedu sa lanaegas diyà butul anì duen iuman da amuk meimet. ");
INSERT INTO mta_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Agulé, egoh da eg-angat-angat sa ketebow sa maama kawingen, egkepilut da langun owoy neketudug da enù ka nelugay sa ketebow di. ");
INSERT INTO mta_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Agulé teliwadà sigep, egdinegen da sa etaw eg-umow, guwaen di, ‘Egtebow dé sa maama kawingen. Téél yu dé angay yu telabuk.’ ");
INSERT INTO mta_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hê, mig-enaw sa sepulù kenogon, owoy eg-upionen da sa sembuwan palitaan da. ");
INSERT INTO mta_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Agulé, egpegeni sa lima kenogon endà mipedu diyà sa lima mipedu, guwaen da, ‘Begayi yu kami lanaegas enù ka buyu dé mepadeng sa nami palitaan.’ ");
INSERT INTO mta_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Agulé migsagbì sa kenogon mipedu, guwaen da, ‘Endà ibegay ké duu, enù ka endà meketukid di diyà kenita sa lanaegas inuwit ké. Mepion amuk mangay yu meli dutu tinda dò.’ ");
INSERT INTO mta_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Agulé mig-angay da egbeli lanaegas. Egoh da mig-ipanaw dé, migtebow dé sa maama kawingen. Agulé mig-unut sa lima kenogon mipedu diyà kenagdi eggemow diyà sa dalesan kenà da egpista. Egoh da migdalem dé langun, nepintuan dé sa dalesan. ");
INSERT INTO mta_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Agulé endà nelugay di, migtebow ma sa lima kenogon kedu diyà sa tinda. Eg-umow da diyà sa duwangen, guwaen da, ‘O Datù, ukai ko kami enù ka gumemow ké.’ ");
INSERT INTO mta_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Dodoo migsagbì iya wé maama, guwaen di, ‘Endà ukaan ku duu enù ka endà nelayaman ku duu kiyu ya.’” ");
INSERT INTO mta_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Agulé guwaen i Hésus, “Hediya ma, tulik yu ma enù ka endà netiigan yu duu sa agdaw ku pelikù ataw ka sa ulas di.” ");
INSERT INTO mta_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Agulé guwaen i Hésus, “Lagà ini ma sa kedatù i Nemula. Duen sa maama mangay mediyù tanà dò. Dodoo egoh di buyu mipanaw, inumow di sa medoo egsugùsuguen di owoy saligan di kagda sa pilak di anì ipaten da. ");
INSERT INTO mta_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Binegayan di pilak sa uman sebaen etaw danà sa egkegaga da. Lima ngibu sa igbegay di diyà sa sebaen etaw, owoy duwa ngibu sa sebaen, owoy sengibu sa sebaen ma etaw. Agulé mig-ipanaw dé. ");
INSERT INTO mta_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na, sa etaw binegayan lima ngibu, eg-angay egpeanak sa pilak di, owoy duen ma sa untung nekuwa di lima ngibu. ");
INSERT INTO mta_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hediya ma sa binaelan sa etaw binegayan duwa ngibu, enù ka duen ma sa untung nekuwa di duwa ngibu. ");
INSERT INTO mta_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dodoo sa etaw binegayan sengibu, mig-angay polo migkali tanà anì ilidung di sa pilak sa datù di. ");
INSERT INTO mta_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Na, egoh di nelugay, miglikù dema sa datù da, owoy igpeangay di sa medoo egsugùsuguen di sinaligan di pilak anì hauwen di sa untung nekuwa da. ");
INSERT INTO mta_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Agulé, migtebow sa egsugùsuguen di binegayan lima ngibu, owoy inuwit di ma sa untung nekuwa di lima ngibu. Guwaen di, ‘O Datù, sa lima ngibu pilak igbegay ko kenak, haa ko, kaini ma sa untung nekuwa ku lima ngibu ma.’ ");
INSERT INTO mta_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Guwaen sa datù, ‘Mepion iya wé binaelan ko. Kuna sa mepion egsugùsuguen ku kesaligan. Umanan ku sa isalig ku diyà keniko danà ko mipedu eg-ipat sa tukééy igsalig ku. Ungayà ku meanggan ka ma temù lagà sa kekeanggan ku.’ ");
INSERT INTO mta_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Agulé migtebow ma sa egsugùsuguen di binegayan duwa ngibu, owoy guwaen di, ‘O Datù, sa duwa ngibu pilak igbegay ko kenak, haa ko, kaini ma sa untung nekuwa ku duwa ngibu ma.’ ");
INSERT INTO mta_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Guwaen sa datù, ‘Mepion iya wé binaelan ko. Kuna sa mepion egsugùsuguen ku kesaligan. Umanan ku sa isalig ku diyà keniko danà ko mipedu eg-ipat sa tukééy igsalig ku. Ungayà ku meanggan ka ma temù lagà sa kekeanggan ku.’ ");
INSERT INTO mta_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Agulé, migtebow ma sa egsugùsuguen di binegayan sengibu, owoy guwaen di, ‘O Datù, netiigan ku kuna sa mebalaw etaw, enù ka meketu ko sa medoo palay endà inohok ko duu owoy dakel ma sa untung mekuwa ko apiya beken niko sa inay di. ");
INSERT INTO mta_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Huenan di, iglidung ku polo sa pilak ko diyà tanà enù ka nelimedangan a egpeanak sa pilak ko amuk metelas. Haa ko, kaini doo sa pilak ko.’ ");
INSERT INTO mta_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Agulé guwaen sa datù, ‘Kuna sa egsugùsuguen ku endà mipedu owoy pauken ka. Netiigan ko doo meketu ku sa medoo palay endà inohok ku duu. Netiigan ko ma dakel sa untung mekuwa ku apiya beken naken sa inay di. ");
INSERT INTO mta_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maen di ya endà igsalig ko duu sa pilak ku diyà sa medoo etaw atung egpantiyali? Amuk hediya, mehaa ku doo sa pilak ku owoy sa anak di ma amuk tumebow a.’ ");
INSERT INTO mta_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Agulé, guwaen di diyà sa medoo duma di dahiya, ‘Kuwa yu sa sengibu pilak igbegay ku diyà kenagdi owoy begayi yu diyà sa etaw épê sepulù ngibu. ");
INSERT INTO mta_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Enù ka mebegayan pa uman sa etaw egkesaligan ku anì sumubela. Dodoo sa etaw endà egkesaligan ku duu, apiya di pa tukééy sa langun taman di, mekedan pa uman. ");
INSERT INTO mta_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, siini egsugùsuguen ku endà mipedu, hemagawi yu kagdi anì mekeangay dutu siedò deleman kenà di mepigtamayan. Suminegaw dutu owoy kuméget sa ngipen di danà di tigtu mepasangan.’” ");
INSERT INTO mta_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Agulé guwaen i Hésus, “Amuk pelikù a anì kumedatù a, aken i Kakay Langun, meunutan a sa langun egsugùsuguen ku kedu diyà langit. Agulé, menuu a dutu siedò mapulù bangkù ku amuk kumedatù a. ");
INSERT INTO mta_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Metipon diyà kenak sa langun etaw kedu diyà sa langun balangan tanà. Agulé, baeden ku kagda diyà sa duwa geumpung, lagà sa tegeipat kebilibili eggalal sa medoo kambing kedu diyà sa medoo kebilibili, ");
INSERT INTO mta_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","enù ka tiponen di sa medoo kebilibili denu kuwanan di owoy tiponen di ma sa medoo kambing denu bibang di. ");
INSERT INTO mta_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Agulé mikagi a diyà sa medoo etaw denu kuwanan ku, guwaen ku, ‘Na, unut-unut yu dé kenak, enù ka kiyu sa hinemilì i Emà ku anì meanggan yu. Angay yu dé diyà sa kedatù i Nemula diyà langit, enù ka iya sa tinapay di migbael egoh tanà endà pa binaelan. ");
INSERT INTO mta_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Peangayen ku kiyu dutu enù ka pinekaen yu aken egoh ku mineketues, owoy pineinem yu aken egoh ku nelupahan. Apiya di pa endà nelayaman yu duu aken egoh ku migtebow diyà keniyu, pinegemow yu doo aken diyà sa dalesan yu. ");
INSERT INTO mta_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Egoh di endà duen ginis ku, binegayan yu aken ginis; owoy egoh ku miglinadu, inipat yu aken; owoy egoh ku nebilanggu, linengenan yu aken.’ ");
INSERT INTO mta_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Agulé migsà sa medoo metiengaw etaw denu kuwanan ku, guwaen da, ‘O Datù, nengan ko ya mineketues owoy pinekaen ké kuna, ataw ka nelupahan ka owoy pineinem ké kuna? ");
INSERT INTO mta_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nengan ko ya endà nelayaman ké duu kuna owoy pinegemow ké kuna diyà sa dalesan ké? Nengan ko ya endà duen ginis ko owoy binegayan ké kuna? ");
INSERT INTO mta_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nengan ko ya miglinadu ataw ka nebilanggu ka owoy linengenan ké kuna?’ ");
INSERT INTO mta_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Agulé aken i Datù sa sumagbì diyà kenagda, guwaen ku, ‘Tuu ini i eg-ikagiyen ku diyà keniyu. Apiya di pa binaelan yu iya wé diyà sa sebaen etaw egpigtuu diyà kenak, apiya tigtu tukééy etaw diyà sa kehaa yu, lagà doo binaelan yu iya wé diyà kenak.’ ");
INSERT INTO mta_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Agulé, mikagi a ma diyà sa medoo etaw denu bibang ku, guwaen ku, ‘Kedan yu dé diyà kenak, kiyu i etaw pigtamayan i Nemula. Angay yu dutu lanaw apuy dò endà mepadeng taman melugay, enù ka iya sa tinapay i Nemula migbael anì mepigtamayan Satanas i owoy sa medoo etaw di. ");
INSERT INTO mta_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iya ma sa ketamanan yu enù ka egoh ku mineketues, endà pinekaen yu duu aken; owoy egoh ku nelupahan, endà pineinem yu duu aken. ");
INSERT INTO mta_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Egoh ku migtebow diyà keniyu, endà pinegemow yu duu aken diyà sa dalesan yu. Owoy egoh di endà duen ginis ku, endà binegayan yu duu aken. Miglinadu a owoy nebilanggu a, dodoo endà linengenan yu duu aken.’ ");
INSERT INTO mta_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Agulé, igsaan da ma aken, guwaen da, ‘O Datù, nengan ko ya hinaa ké kuna mineketues, ataw ka nelupahan ka, ataw ka endà duen gemowon ko, ataw ka endà duen ginis ko, ataw ka miglinadu ka, ataw ka nebilanggu ka, owoy endà binuligan ké duu kuna?’ ");
INSERT INTO mta_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Agulé sumagbì a diyà kenagda, guwaen ku, ‘Tuu ini i eg-ikagiyen ku diyà keniyu. Danà yu endà migbulig sa sebaen etaw ku tigtu tukééy diyà sa kehaa yu, lagà aken ma sa endà binuligan yu duu.’ ");
INSERT INTO mta_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Agulé, mehemagawan da dutu anì mepigtamayan da taman melugay. Dodoo melalù polo sa medoo metiengaw etaw taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Na, egoh i Hésus neubus migtulù iya wé, eg-ikagi diyà sa medoo salu di, ");
INSERT INTO mta_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","guwaen di, “Netiigan yu duwa agdaw pa meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Agulé mekebegay sa Kakay Langun diyà sa medoo etaw anì itutuk da diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Agulé, nesetipon sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan etaw Hudiyu diyà sa dakel dalesan i Kayipas, sa Tigtu Ulu-ulu Tegesimbà. ");
INSERT INTO mta_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Eglagbeten da sa ukit kesigkem da si Hésus anì ipeimatay da, enù ka ungayà da lidungen da diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dodoo guwaen da, “Endà mebaluy di sigkemen ta kagdi i diyà siini pista, enù ka sulian kéen sa medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, egoh i Hésus diyà sa menuwa Bétaniya, eglengen diyà si Simon, sa etaw nelikuan dempid. ");
INSERT INTO mta_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Egoh da egkaen pelà, duen sa bayi migtebow eg-uwit sa metolol tukééy butul alabastelu nepenù lana mepion ngadeg owoy tigtu mapulù. Agulé, migdapag diyà si Hésus owoy hinudud di sa lana diyà sa ulu di egoh di egkaen pelà. ");
INSERT INTO mta_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Agulé, egoh sa medoo salu i Hésus mighaa sa binaelan sa bayi, egbulit da, owoy guwaen da, “Maen di ya linemet di iya wé? ");
INSERT INTO mta_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mepion polo hedem amuk dagangen di anì mekekuwa medoo pilak anì mekebegay diyà sa etaw pubeli.” ");
INSERT INTO mta_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Dodoo netiigan i Hésus sa pesuwan da egbulit, owoy guwaen di, “Yoko egsigbolow duu siini bayi, enù ka tigtu mepion sa binaelan di diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Enù ka tapay doo duen sa etaw pubeli diyà keniyu anì mebuligan yu ma. Dodoo aken, endà dé iseg a melugay mugpà diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Huenan di, hinududan di aken lana anì tapayen di pepion sa lawa ku sa egoh ku ilebeng. ");
INSERT INTO mta_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tuu ini i eg-ikagiyen ku diyà keniyu. Endà melipengan di etaw kagdi i, enù ka metulon iya wé binaelan di diyà kenak, sumalà dé sa menuwa diyà siini sinukub langit kenà da egtulù sa Mepion Tegudon.” ");
INSERT INTO mta_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Na, duen sebaen maama diyà sa sepulù owoy duwa salu i Hésus, si Hudas Iskaliyot. Mig-angay diyà sa medoo ulu-ulu tegesimbà, ");
INSERT INTO mta_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","owoy guwaen di, “Pila sa ibegay yu diyà kenak amuk mekuwa yu Hésus i danà sa egbaelan ku?” Agulé, duen kuleta igbegay da diyà kenagdi telu pulù pilak. ");
INSERT INTO mta_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hê, mig-edung Hudas i eglagbet sa mepion gai di megay si Hésus diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na, egoh di neuma dé sa muna agdaw sa pista egoh etaw Hudiyu egkaen sa epan endà duen ipelenuk di, mig-angay da eg-igsà sa medoo salu i Hésus diyà kenagdi, guwaen da, “Ngadan sa kenà ké mael kaenen ta egpista sa Agdaw Kinetalà Sa Kepigtamay i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Guwaen i Hésus diyà kenagda, “Angay yu dutu siedò etaw diyà menuwa Hélusalém owoy ikagi yu diyà kenagdi, guwaen yu, ‘Ini sa kagi i Mistelu, medapag dé sa kepatay di gaa. Kumaen gaa siini pista ta lapeg sa medoo salu di diyà sa dalesan ko.’” ");
INSERT INTO mta_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Agulé, tinuu da sa langun igsugù di diyà kenagda owoy egtapayen da sa kaenen da egpista. ");
INSERT INTO mta_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na, egoh di mahapun dé, egpenuu da egkaen Hésus i sa sepulù owoy duwa salu di. ");
INSERT INTO mta_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Egoh da egkaen pelawà, guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Duen diyà keniyu sa sebaen etaw tumampil diyà sa medoo kuntelà ku anì meimatayan a.” ");
INSERT INTO mta_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Hê, egkebukul da temù, owoy eg-edung da eg-igsà sigbaenbaenay diyà kenagdi, guwaen da, “O Datù, beken aken sa inikagi ko?” ");
INSERT INTO mta_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Egsagbì Hésus i, guwaen di, “Iya sa megay kenak diyà sa medoo kuntelà ku sa sebaen duma ku egkesetugen egkaen diyà siini bilu. ");
INSERT INTO mta_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mematay doo sa Kakay Langun enù ka meketuu sa kagi i Nemula igpesulat denu kenak. Dodoo tigtu mepigtamayan siedò maama megay kenak diyà sa medoo kuntelà ku. Adi-adi pa hedem amuk endà inanak iya wé maama.” ");
INSERT INTO mta_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Agulé eg-igsà Hudas i, sa maama migtampil diyà sa kuntelà di, guwaen di, “O Mistelu, beken ma aken sa megay keniko diyà sa kuntelà ko?” Migsagbì Hésus i, guwaen di, “Tuu iya wé inikagi ko.” ");
INSERT INTO mta_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na, egoh da egkaen pelawà, sinabaan i Hésus sa sebaen epan owoy migsimbà egpesalamat diyà si Nemula. Agulé, tinepitepi di owoy igtukid di igbegay diyà sa medoo salu di. Guwaen di, “Kuwa yu owoy kaen yu dé, enù ka ini sa lawa ku.” ");
INSERT INTO mta_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Agulé, sinabaan di ma sa tabù duen wain, owoy migsimbà ma egpesalamat diyà si Nemula. Tinukid di sa medoo salu di, owoy guwaen di, “Inem yu langun tigtukééykééyéy. ");
INSERT INTO mta_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Enù ka ini sa depanug ku lumesut amuk meimatayan a anì metigtuwan sa salà sa langun etaw anì mekepeuloy sa salà da. Siini depanug ku, iya sa tandà di neketuu sa magtu ukit igpasad i Nemula umaluk etaw. ");
INSERT INTO mta_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Taa yu, hih. Endà dé uminem a uman siini wain eg-inemen ta taman endà uminem ki sa magtu wain diyà sa kedatù i Emà ku.” ");
INSERT INTO mta_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Agulé egduyuy da eg-olò si Nemula. Agulé eg-ipanaw da eg-angay Getan Olibu dò. ");
INSERT INTO mta_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Agulé, guwaen i Hésus diyà sa medoo salu di, “Igkani sigep, melaguy yu langun owoy salidan yu aken danà sa kelikutan mekeuma diyà kenak, enù ka meketuu sa kagi i Nemula igpesulat, guwaen di, ‘Meimatayan ku sa etaw tegeipat kebilibili, hê mesepalak ma sa medoo kebilibili.’ ");
INSERT INTO mta_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Dodoo, amuk meenaw a dema, hunawan ku kiyu mangay Galiliya dò.” ");
INSERT INTO mta_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Agulé, eg-ikagi Pidelu i diyà si Hésus, guwaen di, “Apiya sumalid sa medoo duma ta, endà sumalid a, aken i duu.” ");
INSERT INTO mta_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniko. Egoh sa ebos endà pa umukolò amuk buyu sumimag, palawen ko polo aken beken duma ko taman telu gulê.” ");
INSERT INTO mta_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Dodoo guwaen i Pidelu, “Endà palawen ku duu kuna, apiya di pa meseselengan ki mematay.” Hediya ma sa inikagi sa medoo duma salu di. ");
INSERT INTO mta_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na, mig-angay Hésus i owoy sa medoo salu di diyà sa kenà hinemulaan kepengadan da Gétsémani. Agulé, mig-ikagi diyà kenagda, guwaen di, “Penuu yu dini, enù ka mangay a sumimbà daedò é.” ");
INSERT INTO mta_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Inuwit di Pidelu i owoy sa duwa maama anak i Sébediyu. Agulé, egkebogo dé temù sa pedu di owoy tigtu egkebukul ma. ");
INSERT INTO mta_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Guwaen di diyà kenagda, “Tigtu medaet sa pedu ku owoy lagà a buyu mematay danà sa pedu ku medaet. Ugpà yu pelawà dini. Yoko egtudug ga, dodoo tulik yu polo.” ");
INSERT INTO mta_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Agulé, migtangkà tukééy Hésus i diyà kenagda owoy miglagkeb diyà tanà. Egsimbà, guwaen di, “O Emà ku, amuk mebaluy, kedani ko diyà kenak siini dakel kelikutan ku lagà wain mepait buyu egkeinem ku. Dodoo peukit ko diyà kenak sa niko uyot, beken sa naken.” ");
INSERT INTO mta_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Agulé, migpelikù Hésus i diyà sa kenà sa telu salu di, owoy eghauwen di kagda egtudug. Guwaen di diyà si Pidelu, “Ay, negaip a keniyu, enù ka endà metigkelan yu duu taman sakaulas daa, dodoo neketudug yu polo. ");
INSERT INTO mta_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yoko egtudug ga, dodoo simbà yu polo anì endà mekeukit yu diyà sa kenà sa pedu yu tepengan anì endà ma mekebael yu salà. Apiya di pa meiyap sa pedu yu mangunut diyà kenak, melenek doo sa lawa yu.” ");
INSERT INTO mta_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Agulé, migtangkà dema Hésus i diyà kenagda owoy egsimbà dema, guwaen di, “O Emà ku, amuk endà mebaluy di mekedan siini kelikutan ku lagà wain mepait egkeinem ku, ungayà ku polo meketuu sa niko uyot.” ");
INSERT INTO mta_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Agulé, migpelikù dema diyà sa kenà sa medoo salu di owoy eghauwen di kagda egtudug dema enù ka endà metigkelan da duu sa pilut da. ");
INSERT INTO mta_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Agulé, migtangkà dema Hésus i diyà kenagda owoy egsimbà dema sa ketelu di gulê. Diya mendaa sa kagi di egsimbà. ");
INSERT INTO mta_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Agulé, migpelikù dema diyà sa kenà sa medoo salu di owoy guwaen di diyà kenagda, “Ay, maen di ya takà yu polo egtudug? Taa yu. Neuma dé sa ulas egoh ku mekebegay diyà sa medoo etaw tegebael salà, aken i Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enaw yu dé. Haa yu, dahini dé sa etaw megay kenak diyà sa kuntelà ku. Mangay ki dé tumelabuk kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na, egoh i Hésus eg-ikagi pelawà, migtebow Hudas i, sa sebaen maama diyà sa sepulù owoy duwa salu di. Duen medoo etaw mig-unut kenagdi migkemkem sundang owoy lubog. Kagda sa pineangay sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, si Hudas sa migtampil diyà sa kuntelà i Hésus, tapay dé tinulon di diyà sa medoo etaw sa tandà baelan di, guwaen di, “Iya sa etaw eglagbeten yu sa ingadekan ku. Sigkem yu dé.” ");
INSERT INTO mta_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na, egoh da migtebow dahiya, migpedapag Hudas i diyà si Hésus owoy guwaen di, “O Mistelu.” Hê, pinengadekan di. ");
INSERT INTO mta_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Agulé guwaen i Hésus, “O Akay, petéél ko dé sa niko ungayà.” Agulé, migpedapag sa medoo etaw diyà si Hésus, owoy sinigkem da owoy meeles sa kesabà da. ");
INSERT INTO mta_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na, duen sa sebaen duma i Hésus mighugut sa sundang di, owoy tinigbas di sa egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà. Nesapsap sa telinga di. ");
INSERT INTO mta_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Dodoo guwaen i Hésus diyà kenagdi, “Gumà ko sa sundang ko, enù ka amuk duen etaw egkemkem sundang anì mimatay, iya polo sa etaw meimatayan danà sundang. ");
INSERT INTO mta_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Endà metiigan ko duu kéen ini i. Amuk umumow a tabang diyà si Emà ku, peangayen di doo sa ngibu-ngibuwan egsugùsuguen di anì tabangan da aken. ");
INSERT INTO mta_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Dodoo amuk baelan ku iya wé, endà meketuu di sa kagi i Nemula igpesulat egoh anay denu sa kelikutan mehaa ku.” ");
INSERT INTO mta_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Agulé, mig-ikagi Hésus i diyà sa medoo etaw migtebow, guwaen di, “Maen di ya eg-uwit yu sundang owoy lubog egoh yu eg-angay egsigkem kenak? Beken a sa etaw tegelampas. Uman agdaw egpenuu a diyà sa Dalesan i Nemula egoh ku egtulù keniyu, dodoo endà egsigkemen yu duu aken. ");
INSERT INTO mta_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Dodoo ukitan ku dé siini langun kebael yu kenak, enù ka neketuu dé sa kagi i Nemula igsulat sa medoo tegesugkow di egoh anay denu kenak.” Hê, migpelaguy sa medoo salu di owoy sinalidan da kagdi i. ");
INSERT INTO mta_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Agulé, sa medoo etaw migsigkem si Hésus, inuwit da kagdi i eg-angay diyà sa dalesan i Kayipas, sa Tigtu Ulu-ulu Tegesimbà. Nesetipon dé dahiya sa medoo kaunutan Hudiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na, migtangkà Pidelu i eg-unut diyà kenagda, dodoo neketaman daa diyà sa ilis duwangen sa dalesan sa Tigtu Ulu-ulu Tegesimbà. Agulé, mig-angay migpenuu diyà sa duwangen kenà sa medoo tegebantay anì metiigan di sa mebaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na, sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu, eglagbeten da sa kenà i Hésus mekesalà anì tipuwen da anì ipeimatay da. ");
INSERT INTO mta_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dodoo apiya di pa egbutbut sa medoo etaw denu sa binaelan di, endà dé duen sa pesuwan di ipeimatay da. Agulé, duen duwa etaw mig-angay diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","owoy guwaen da, “Dinineg ké sa inikagi siini etaw, guwaen di melukat di gaa sa Dalesan i Nemula daedò é owoy petigdegen di dema gaa amuk meuma sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Agulé, migtigdeg sa Tigtu Ulu-ulu Tegesimbà, owoy guwaen di diyà si Hésus, “Ngadan sa sagbì ko denu iya wé? Tuu pa atu iya wé itipu da keniko, ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Dodoo migpetemed Hésus i. Agulé, eg-ikagi dema sa Tigtu Ulu-ulu Tegesimbà, guwaen di, “Danà sa egkegaga i Nemula mehagtay taman melugay, egsuguen ku kuna anì tumulon ka sa tuu kagi. Tuloni ko kami amuk kuna si Mésayas sa Anak i Nemula ataw ka beken.” ");
INSERT INTO mta_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Guwaen i Hésus, “Tuu iya wé gelal igbegay ko kenak. Dodoo tulonen ku ma diyà keniyu, endà melugay di hauwen yu aken i Kakay Langun menuu denu kuwanan i Nemula épê dakel egkegaga. Owoy hauwen yu ma aken kani petuntun kedu langit dò unutan gaeb.” ");
INSERT INTO mta_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Hê, eglisien sa Tigtu Ulu-ulu Tegesimbà sa kawal di anì tandaan di sa kebulit di danà iya wé inikagi i Hésus. Guwaen di, “Sinumbung di dé Nemula i enù ka guwaen di Anak i Nemula gaa. Endà dé lumagbet ki uman sa ketipu etaw denu kagdi enù ka dinineg ta langun sa kesumbung di. ");
INSERT INTO mta_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ngadan sa penemdem yu denu kenagdi?” Guwaen da, “Meimatayan doo, enù ka dakel sa salà di.” ");
INSERT INTO mta_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Agulé, egteptepan da Hésus i owoy egsesuntuken da ma. Duen ma etaw egtagpì kenagdi, ");
INSERT INTO mta_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","owoy guwaen da, “O Tegesugkow i Nemula, amuk kuna si Mésayas sa pineangay i Nemula, ingadani ko sa etaw egtagpì keniko.” ");
INSERT INTO mta_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na, egpenuu Pidelu i dahiya diyà sa duwangen dalesan. Duen sa bayi egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà eg-angay egdapag diyà si Pidelu owoy guwaen di, “Kuna ma sa duma i Hésus tegeGaliliya.” ");
INSERT INTO mta_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Dodoo egpalaw Pidelu i, owoy egdinegen sa medoo etaw kagdi i egpalaw, guwaen di, “Endà netiigan ku duu iya wé guwaen ko.” ");
INSERT INTO mta_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Agulé, mighalì Pidelu i medapag diyà sa gemowon. Duen dema sa sebaen bayi egsugùsuguen mighaa si Pidelu, owoy guwaen di diyà sa medoo etaw dahiya, “Siini maama sa duma i Hésus tegeNasalét.” ");
INSERT INTO mta_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Dodoo egpalaw dema Pidelu i. Egpengibet owoy guwaen di, “Endà netiigan ku duu iya wé maama.” ");
INSERT INTO mta_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Egoh di nelugaylugay, duen dema sa liyu etaw migpedapag diyà si Pidelu, owoy guwaen da, “Tigtu tuu, kuna sa duma i Hésus, enù ka netiigan ké kuna ma sa etaw tegeGaliliya danà sa kagi ko.” ");
INSERT INTO mta_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dodoo guwaen i Pidelu, “Mepigtamayan a i Nemula amuk egbutbut a. Tigtu endà netiigan ku duu iya wé maama.” Hê, umukolò dé sa ebos. ");
INSERT INTO mta_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Agulé, netulengan i Pidelu sa inikagi i Hésus diyà kenagdi, guwaen di, “Egoh sa ebos endà pa umukolò amuk buyu sumimag, palawen ko polo aken beken duma ko taman telu gulê.” Agulé, mig-ipanaw Pidelu i owoy temù egsinegaw danà sa pedu di nebukul. ");
INSERT INTO mta_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na, egoh di magtu kesimag, nesetipon sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu, owoy egpenemdemen da sa itipu da si Hésus diyà sa gubilenu anì meimatayan da. ");
INSERT INTO mta_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Agulé, pinolot da sangkalì owoy inagak da diyà si Pilatu, sa Gubilenu da. ");
INSERT INTO mta_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, si Hudas sa migbegay si Hésus diyà sa medoo kuntelà di, egoh di neketiig meimatayan da Hésus i, eg-ekedan di sa binaelan di medaet. Huenan di, migpelikù diyà sa medoo ulu-ulu tegesimbà owoy diyà sa medoo kaunutan Hudiyu, enù ka ungayà di ipelikù di hedem sa telu pulù pilak igbegay da kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Guwaen di, “Nesalà a dé, enù ka igbegay ku diyà keniyu iya wé maama anì meimatayan, dodoo endà duen sa hagdi salà.” Dodoo egsagbì da, guwaen da, “Endà duen sa penemdem ké denu sa niko salà. Muni dé diyà keniko iya wé.” ");
INSERT INTO mta_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Agulé igsawel i Hudas sa pilak dalem sa Dalesan i Nemula. Hê, miglegkang dahiya owoy eg-angay egpebitin. ");
INSERT INTO mta_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na, egtipohen sa medoo ulu-ulu tegesimbà sa pilak igsawel di, owoy guwaen da, “Tumipay ki sa uledin igsugkow i Mosis amuk dalemen ta siini pilak diyà sa taguan pilak diyà Dalesan i Nemula, enù ka ini sa igbayad sa kepatay etaw.” ");
INSERT INTO mta_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Agulé, egoh da migseolomoy, nesesebaen dé sa penemdem da denu sa egbaelan da diyà sa pilak. Igbeli da tanà diyà sa tegepilpil anì duen sa lebengan sa beken etaw tegeHélusalém. ");
INSERT INTO mta_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iya sa igbeli da tanà sa pilak igbayad da sa kinepatay i Hésus. Huenan di, pinengadanan etaw iya wé Tanà Depanug taman ini egoh di. ");
INSERT INTO mta_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na, danà sa binaelan da, neketuu dé sa kagi i Hilimiyas sa tegesugkow i Nemula egoh anay, guwaen di, “Kinuwa da sa telu pulù pilak, enù ka iya sa enget lagà etaw diyà sa penemdem sa medoo tugod i Islaél, ");
INSERT INTO mta_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","owoy iya ma sa ibeli da tanà diyà sa tegepilpil, enù ka hediya ma sa igsugù i Nemula diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, egoh i Hésus inagak da diyà si Gubilenu Pilatu, inigsaan i Pilatu, guwaen di, “Enù di ya, kuna sa Sulutan diyà sa medoo Hudiyu?” Migsagbì Hésus i, guwaen di, “Tuu iya wé gelal igbegay ko kenak.” ");
INSERT INTO mta_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dodoo apiya di pa egtipuwen sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu Hésus i, endà doo egsagbì di. ");
INSERT INTO mta_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Huenan di, inigsaan i Pilatu dema, guwaen di, “Maen di ya endà egsagbian ko duu sa medoo ketipu da keniko?” ");
INSERT INTO mta_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Dodoo endà egsagbì Hésus i, apiya di pa medoo sa itipu da kenagdi. Iya maen di ya tigtu negaip Pilatu i. ");
INSERT INTO mta_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, uman meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, iya sa adat i Gubilenu Pilatu lengaan di sa sebaen etaw nebilanggu, sumalà dé sa hemilien da. ");
INSERT INTO mta_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na, egoh iya, duen sa medaet etaw nebilanggu eglalag. Iya sa ngadan di si Balabas. ");
INSERT INTO mta_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Agulé, egoh sa medoo etaw nesetipon, inigsaan i Pilatu kagda, guwaen di, “Ngadan sa tayu etaw lengaan ku diyà keniyu, ataw ka si Balabas ataw ka si Hésus ginelal yu si Mésayas? Ngadan tayu sa hemilien yu?” ");
INSERT INTO mta_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iya sa inikagi di enù ka netiigan di igpesigkem sa medoo ulu-ulu Hudiyu Hésus i danà da egkesina diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Egoh i Pilatu egpenuu pelà diyà sa kenà da eg-antang, duen etaw migtebow sinugù sa sawa di, guwaen di, “Yaka egpigtamay duu iya wé maama enù ka endà duen sa salà di. Nebukul temù sa sawa ko egoh giina danà di migtegeinep denu iya wé maama egoh sigep.” ");
INSERT INTO mta_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Dodoo sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu, inikagiyan da sa medoo etaw dahiya anì pegeniyen da lengaan i Pilatu Balabas i owoy ipeimatay di Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Agulé, eg-igsà dema Pilatu i, guwaen di, “Ngadan sa tayu etaw egkeiyapan yu lengaan ku?” Guwaen da egsagbì, “Si Balabas.” ");
INSERT INTO mta_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eg-igsà dema Pilatu i, guwaen di, “Amuk hediya, ngadan sa baelan ku diyà si Hésus sa ginelal yu si Mésayas?” Hê, eg-ikagi da langun, guwaen da, “Petutuki ko diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Dodoo guwaen i Pilatu, “Maen di ya? Ngadan sa salà binaelan di?” Dodoo migpetaled da polo eg-ikagi, guwaen da, “Petutuki ko diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Na, netiigan i Pilatu endà mekegaga di kenagda owoy buyu da dé egbogo temù. Huenan di migkuwa wayeg owoy egpegusê belad di diyà sa kehaa etaw. Guwaen di, “Danà ku migpegusê sa belad ku, egtandaan ku diyà keniyu beken naken salà sa kepatay siini maama. Muni dé diyà keniyu amuk imatayan yu.” ");
INSERT INTO mta_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Migsagbì da, guwaen da, “Mepion diyà kenami amuk mepigtamayan ké taman sa medoo tugod ké danà sa kepatay di, enù ka iya sa nami salà.” ");
INSERT INTO mta_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Agulé igpelengà i Pilatu Balabas i kedu diyà bilangguwan. Hê, igpetapes di Hésus i owoy sinugù di ma sa sundalu di anì itutuk da diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Agulé, inuwit sundalu Hésus i dalem sa dakel dalesan sa gubilenu, owoy sinetipon da sa langun duma da sundalu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Agulé, egkedanan da sa kawal di owoy ipekawal da kenagdi sa kawal melalegà lagà sa kawal sulutan. ");
INSERT INTO mta_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Liningkal da ma sa belagen épê dugi owoy isukub da diyà sa ulu di, lagà sa metolol sayap sulutan. Duen ma sa kayu ipesabà da diyà sa belad di denu kuwanan, lagà sa metolol tuked sulutan. Agulé egligkued da diyà sa taengan di enù ka ubòubò da egdatù kenagdi, guwaen da, “Meolò ka, kuna i sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Agulé egteptepan da, owoy kinuwa da sa kayu sinabaan di anì ibalbal da diyà sa ulu di. ");
INSERT INTO mta_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Agulé, egoh da neubus egpeumàumà si Hésus, egkedanan da sa kawal di melalegà, owoy ipekawal da dema sa hagdi tapay kawal. Agulé, eg-agaken da dutu siedò kenà di imatayan. ");
INSERT INTO mta_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na, egoh da miglegkang dahiya, duen sa maama kedu Silini dò nesiegungan da. Iya sa ngadan di, si Simon. Igtegel sa sundalu ipetiang diyà kenagdi sa kayu kenà i Hésus meketutuk. ");
INSERT INTO mta_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Agulé, miglagbas da eg-angay diyà sa tukééy getan kepengadan da Golgota. Iya sa selepangan di, Kulobong Ulu. ");
INSERT INTO mta_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Egoh da migtebow dahiya, igbegay da diyà si Hésus sa wain inamutan sa tigtu mepait. Dodoo egoh di migtémtém, endà inemen di duu. ");
INSERT INTO mta_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hê, igtutuk da dé Hésus i diyà sa kayu, owoy igbugsud da. Agulé, egkusing da egseatuwen da sa ginis di. ");
INSERT INTO mta_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Egoh di neubus iya wé, egpenuu da egtulik kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Duen ma sa igsulat igtagù da diyà sa lekeatas ulu di anì tandaan da sa itipu da kenagdi. Iya sa kagi di, “Ini si Hésus sa Sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Duen ma duwa maama tegelampas igtutuk da diyà sa kayu igbugsud, sa sebaen denu kuwanan i Hésus, sa sebaen denu bibang di. ");
INSERT INTO mta_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na, egkilingkiling sa medoo etaw egtalà dahiya owoy egpeumàumaan da Hésus i. ");
INSERT INTO mta_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Guwaen da, “Iyoh! Melukat ko sa Dalesan i Nemula daedò é, owoy petigdegen ko dema diyà sa ketelu di agdaw? Amuk tuu ka Anak i Nemula, tenà ka atu kedu diyà sa kayu igbugsud anì mealukan ko kuna ya.” ");
INSERT INTO mta_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hediya ma, egpeumàumaan da ma Hésus i sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo kaunutan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Guwaen da, “Inalukan di gaa sa medoo liyu etaw, dodoo endà megaga di duu kagdi umaluk. Iya sa kagi di sulutan gaa diyà sa medoo tugod i Islaél. Dodoo endà migtuu ki taman endà tumenà di kedu diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Si Nemula gaa sa egsaligan di. Na, hauwen ta atu amuk alukan i Nemula kagdi ini egoh di enù ka iya sa kagi di Anak i Nemula gaa.” ");
INSERT INTO mta_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hediya ma, egpeumàumaan da ma Hésus i sa duwa maama tegelampas duma di igtutuk diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na, egoh di alas sepulù owoy duwa, tinenaan deleman sa uwang tanà taman telu kaulas. ");
INSERT INTO mta_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Agulé, egoh di alas telu mahapun, migpetaled Hésus i eg-ikagi, guwaen di diyà sa kagi Hibelu, “Eli, Eli, lama sabaktani?” Na, iya sa selepangan sa inikagi di, “O Nemula ku, maen di ya ininiyugan ko aken?” ");
INSERT INTO mta_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Egoh sa medoo etaw dahiya migdineg iya wé kagi di, guwaen da, “Eg-umowen di Iliyas i sa tegesugkow i Nemula egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Agulé, duen sebaen etaw dahiya migletu mig-angay sa tabung, owoy eleden di diyà sa wain mepait, owoy igtagù di diyà sa kayu anì idugol di diyà sa ebà i Hésus anì metepes di. ");
INSERT INTO mta_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Dodoo guwaen sa medoo liyu etaw, “Angatan ta pelà anì mehaa ta atu amuk tumebow si Iliyas anì alukan di kagdi.” ");
INSERT INTO mta_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Agulé, pinetaled i Hésus dema sa kagi di. Hê, nekedan dé sa ginawa di. ");
INSERT INTO mta_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Agulé, minelisì teliwadà edung lekeatas taman leketanà sa dakel ginis ighabeng dalem sa teliwadà luwang Dalesan i Nemula. Eglinug temù owoy netedal ma sa medoo dakel batu. ");
INSERT INTO mta_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Neukaan ma sa medoo batu tinosongon etaw kenà etaw iglebeng, owoy mig-enaw dema sa medoo etaw nematay migpigtuu diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Miglaun da kedu diyà lebeng, owoy egoh i Hésus mig-enaw dema, mig-angay da diyà sa menuwa Hélusalém kenà medoo etaw mighaa kenagda. ");
INSERT INTO mta_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hê, nelimedangan sa kapitan owoy sa medoo sundalu tegetulik si Hésus egoh sa tanà miglinug owoy egoh da mighaa sa medoo nebaelan dahiya. Guwaen da, “Tuu, Anak i Nemula doo ini i maama.” ");
INSERT INTO mta_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na, duen ma medoo bayi migtigdeg da mediyùdiyù anì eghauwen da sa langun kinebael da si Hésus. Kagda sa mig-unut kenagdi kedu siedò tanà Galiliya taman Hélusalém dò anì egbuligan da kagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Dahiya si Maliya tegeMagdala, owoy sebaen ma Maliya inay i Santiyago owoy si Hosé, owoy siedò bayi sawa i Sébediyu, owoy sa medoo duma da ma. ");
INSERT INTO mta_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na, egoh di mahapun dé, duen sa kawasà etaw tegeAlimatiya migtebow. Iya sa ngadan di, si Hosé, owoy mig-unut-unut ma diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Agulé, inangay di egpegeni diyà si Pilatu sa lawa i Hésus anì ilebeng di. Huenan di, igsugù i Pilatu anì ibegay da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Agulé, kinuwa i Hosé diyà sa kayu igbugsud owoy binedbed di sa magtu ginis mebulà. ");
INSERT INTO mta_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Duen sa magtu lebeng tinosongon di diyà batu owoy iya sa kenà di iglebeng sa lawa i Hésus. Agulé, kinelid di sa dakel batu anì mesagpeng sa lebeng. Agulé, miglegkang dahiya. ");
INSERT INTO mta_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na, hinaa i Maliya tegeMagdala owoy sa sebaen ma Maliya iya wé langun binaelan i Hosé, enù ka migpenuu da medapag diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na, umenaw simag sa agdaw keetud etaw Hudiyu, mig-angay sa medoo Palasiyu owoy medoo ulu-ulu tegesimbà diyà si Pilatu. ");
INSERT INTO mta_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Guwaen da, “O Datù, netulengan ké sa kagi iya wé etaw tegebutbut. Iya sa kagi di egoh di endà pa nematay, meenaw dema gaa diyà sa ketelu di agdaw. ");
INSERT INTO mta_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huenan di, mepion amuk peangayen ko pebantay sa medoo sundalu ko diyà sa lebeng di taman telu agdaw, anì endà penakawen sa medoo pasek di sa lawa di anì endà ma metulon da duu sa egoh di neenaw dema. Duen dé sa medoo etaw neakalan di, dodoo uman pa medaet amuk meakalan da dema danà di gaa neenaw dema.” ");
INSERT INTO mta_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Migsagbì Pilatu i, guwaen di, “Na, uwit yu sundalu dutu owoy pebantayi yu temù sa lebeng.” ");
INSERT INTO mta_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Agulé, mig-angay da diyà sa kenà lebeng owoy tinaguan da tandà sa dakel batu igsagpeng sa lebeng di anì metiigan da amuk duen sa menakaw. Agulé, ipebantay da diyà sa medoo sundalu. ");
INSERT INTO mta_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Na, egoh di neelut sa agdaw keetud da egoh di magtu kesimag Akad egkawatkawat pelawà, mangay Maliya i tegeMagdala owoy si Maliya sebaen diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hê, egoh da endà pa egtebow diyà lebeng, petow dé duen dakel linug, enù ka duen egsugùsuguen i Nemula migpetuntun kedu langit dò owoy kinelid di sa batu igsagpeng lebeng, owoy migpenuu dahiya. ");
INSERT INTO mta_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Egsenang temù sa palas di lagà silà owoy tigtu mebulà temù sa ginis di. ");
INSERT INTO mta_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Eglukub sa medoo sundalu egbantay lebeng danà da nelimedangan temù, owoy netuwal da ma lagà da etaw nematay. ");
INSERT INTO mta_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na, egoh sa duwa bayi migtebow diyà sa kenà lebeng, mig-ikagi sa egsugùsuguen i Nemula diyà kenagda, guwaen di, “Yoko egkelimedangan na. Netiigan ku eglagbeten yu Hésus i sa igtutuk da diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dodoo endà dé dahini di, enù ka neenaw dé enù ka neketuu dé sa tinulon di diyà keniyu egoh anay. Awuh yu dé anì mehaa yu sa kenà di pinehibat. ");
INSERT INTO mta_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, petéél yu dé angay yu tulon diyà sa medoo salu di, guwaen yu, ‘Neenaw dé egoh di nematay owoy humuna keniyu mangay Galiliya dò kenà yu humaa kenagdi.’ Na, yoko egkelipeng duu siini kagi ku diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Agulé, medelamet da miglegkang diyà sa kenà lebeng. Apiya di pa nelimedangan da, tigtu da doo neanggan owoy egletu da anì metulon da diyà sa medoo salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Agulé, petow da dé nesesiegung si Hésus diyà dalan, owoy guwaen di, “Kumelanih sa keugpà yu.” Agulé, migpedapag da diyà kenagdi, owoy migligkued da owoy egsabaan da sa lisen di enù ka eg-oloen da. ");
INSERT INTO mta_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Agulé guwaen i Hésus, “Yoko egkelimedangan na. Angay yu tulon dutu siedò medoo salu ku anì mangay da Galiliya dò enù ka dutu sa kenà da humaa kenak.” ");
INSERT INTO mta_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, egoh sa duwa bayi miglegkang diyà lebeng, mig-ipanaw ma sa medoo sundalu tegebantay lebeng eg-angay Hélusalém dò. Egtulon da diyà sa medoo ulu-ulu tegesimbà sa langun hinaa da diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Agulé, nesetipon sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu, owoy egseolomen da sa baelan da. Agulé, binegayan da pilak sa medoo sundalu, ");
INSERT INTO mta_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","owoy guwaen da, “Tulon yu diyà sa medoo etaw, guwaen yu, ‘Egoh sigep inangay sa medoo pasek di egpenakaw sa lawa di egoh ta neketudug.’ ");
INSERT INTO mta_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na, amuk mekedineg sa gubilenu denu iya wé, kami polo sa molom diyà kenagdi anì endà bulitan di kiyu.” ");
INSERT INTO mta_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Agulé, kinuwa sa medoo sundalu sa medoo pilak owoy tinuu da ma sa igsasà da. Na, hediya ma doo sa egtulonen sa medoo etaw Hudiyu taman ini egoh di. ");
INSERT INTO mta_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na, mig-angay sa sepulù owoy sebaen salu i Hésus Galiliya dò diyà siedò getan pineangayan i Hésus kenagda. ");
INSERT INTO mta_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Agulé, egoh da mighaa kenagdi, eg-oloen da. Dodoo duen duma etaw egkeduwa sa pedu da denu si Hésus. ");
INSERT INTO mta_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Agulé, migpedapag Hésus i diyà kenagda owoy guwaen di, “Binegayan a dé egkegaga anì kumedatù a diyà sa langun dutu langit dò owoy diyà tanà ma. ");
INSERT INTO mta_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Huenan di, angay yu diyà sa medoo menuwa diyà siini sinukub langit. Tulù yu sa langun etaw anì umunut-unut da kenak, owoy bautisi yu ma kagda anì tandaan da mesesebaen da si Emà ta Nemula owoy aken i Anak di owoy sa Metiengaw Suguy di. ");
INSERT INTO mta_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tulù yu ma kagda anì mangunut da sa langun igsugù ku keniyu. Na, taa yu, hih. Takaan ku kiyu eg-unut-unut taman endà meuma sa sabuhanan agdaw.”");
INSERT INTO mta_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ini sa edungan sa Mepion Tegudon denu si Hésus Kelistu Anak i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Egoh anay duen sa kagi i Nemula igsulat i Isayas sa tegesugkow di, guwaen di, “Dumuen sa etaw ku pehunawen ku diyà keniko anì ipetiig di sa egoh ko buyu dé tumebow. ");
INSERT INTO mta_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tumebow diyà sa melabel tanà mediyù dalesan owoy dinegen sa medoo etaw eg-angay diyà kenagdi sa kagi di metaled, guwaen di, ‘Abung-abungi yu sa ukitan i Datù tumebow. Petudà yu sa medoo dalan di.’ ” ");
INSERT INTO mta_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na, neketuu dé iya wé kagi i Nemula igpesulat, enù ka migtebow si Huwan Tegebautis dutu siedò melabel tanà mediyù dalesan. Migtegudon diyà sa medoo etaw, guwaen di, “Ekedi yu sa medoo salà yu owoy pebautis yu ma diyà wayeg anì tandaan yu sa keeked yu salà, owoy ipeuloy i Nemula sa medoo salà yu.” ");
INSERT INTO mta_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na, duen medoo etaw mig-angay egdineg diyà si Huwan kedu diyà sa langun uwang Hudiya owoy duen ma medoo kedu diyà sa menuwa Hélusalém. Tinulon da sa medoo salà da eg-ekedan da owoy egbautisan i Huwan kagda diyà sa lawa Holdan. ");
INSERT INTO mta_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, igkawal i Huwan sa hinabel bulbul kamiliyu, owoy iya sa sabitan di sa netikal kunul hinagtay. Iya sa kaenen di sa kasuk owoy sa teneb linaday. ");
INSERT INTO mta_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Egtegudon diyà sa medoo etaw, guwaen di, “Dumuen sa etaw tumebow mekesambì kenak owoy tigtu eglowon diyà kenak. Amuk tumebow, mekelilang a owoy memalaan a ma dumapag kenagdi lumengà sa talumpà di. ");
INSERT INTO mta_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wayeg daa sa ibautis ku keniyu, dodoo sa etaw mekesambì kenak, iya polo sa ibautis di keniyu sa Metiengaw Suguy i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na, egoh i Huwan egbautis pelà sa medoo etaw diyà wayeg, mig-angay Hésus i diyà kenagdi kedu menuwa Nasalét diyà uwang Galiliya, owoy binautisan i Huwan kagdi diyà sa lawaꞌt wayeg Holdan. ");
INSERT INTO mta_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hê, egoh i Hésus miggaun kedu dalem sa wayeg, hinaa di sa langit neukaan owoy sa Metiengaw Suguy i Nemula egpetuntun eg-angay egtenà diyà kenagdi egpeiling manuk menatad. ");
INSERT INTO mta_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Agulé, duen sa eg-ikagi kedu diyà langit, guwaen di, “Kuna sa Anak ku eghiduwan ku temù. Tigtu a netuuwan diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Agulé, egoh i Hésus migpebautis, petow dé pineangay sa Suguy i Nemula kagdi diyà sa melabel tanà mediyù dalesan. ");
INSERT INTO mta_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eg-ugpà dahiya taman epat pulù agdaw owoy takaan i Satanas egtepengan kagdi i anì mekesalà. Duen ma sa medoo uled tanà neduma di dahiya, dodoo duen medoo egsugùsuguen i Nemula mig-angay egtabang si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na, egoh i Huwan nebilanggu danà i Datù Hélod, mig-angay Hésus i diyà uwang Galiliya egtulù sa Mepion Tegudon kedu si Nemula. ");
INSERT INTO mta_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Guwaen di, “Neuma dé sa agdaw igpasad i Nemula diyà sa medoo etaw egoh anay, enù ka buyu dé tumebow sa kedatù i Nemula diyà keniyu. Huenan di, ekedi yu dé sa medoo salà yu owoy pigtuu yu dé diyà siini Mepion Tegudon.” ");
INSERT INTO mta_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na, egoh i Hésus eghemantad diyà sa lanaw Galiliya, hinaa di si Simon owoy si Andelis hadi di. Egpuket da diyà sa lanaw enù ka kagda sa tegepuket. ");
INSERT INTO mta_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Agulé guwaen i Hésus diyà kenagda, “Unut-unut yu kenak, enù ka edung ini egoh beken sedà daa sa egkuwaen yu dodoo etaw polo sa ipekuwa ku keniyu.” ");
INSERT INTO mta_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hê, petow dé sinalidan da sa puket da owoy mig-unut da dé si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Agulé, egoh i Hésus eg-ipanaw uman, hinaa di sa duwa anak i Sébediyu, si Santiyago owoy si Huwan hadi di. Eg-upionen da sa puket dalem sa kumpit da. ");
INSERT INTO mta_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Agulé inumow i Hésus kagda. Hê, sinalidan da sa emà da diyà sa kumpit lapeg sa medoo tegepuket egsukayan di, enù ka eg-unut da dé si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na, migtebow da Hésus i diyà sa menuwa Kapelenaum. Egoh di neuma Sapetu sa agdaw keetud da, migdalem Hésus i diyà sa simbaan da owoy migtulù diyà sa medoo etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tigtu egkegaip sa medoo etaw egoh da migdineg sa ketulù di, enù ka endà nesetepeng sa ukit ketulù di owoy sa ukit ketulù sa medoo tegetulù uledin igsugkow i Mosis, enù ka dakel polo sa hagdi egkegaga egtulù. ");
INSERT INTO mta_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hê, egoh i Hésus egtulù pelawà, duen sa maama linahuk busaw egludep diyà sa simbaan da. Pinetaled di sa kagi di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O Hésus tegeNasalét, ngadan sa kebael ko kenami i busaw? Enù di ya, eg-angayen ko kami egpedaetan imet? Egkilalaen ku doo kuna sa Metiengaw Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dodoo hinawidan i Hésus, guwaen di, “Yaka dé egséléken na. Laun ka dé.” ");
INSERT INTO mta_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hê, tigtu egpelabayenen sa busaw sa maama linahuk di, owoy miglesing ma metaled, agulé miglaun dé diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na, tigtu egkegaip sa langun etaw dahiya owoy egseolomoy da, guwaen da, “Ngadan ini i? Magtu tegudon kéen ini i, enù ka duen sa egkegaga siini etaw egsugù egpelesut sa medoo busaw, owoy egpangunutan da doo sa kagi di.” ");
INSERT INTO mta_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na, danà iya wé binaelan i Hésus, medelamet nekeseluh sa lalag di diyà sa uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Agulé, miglaun Hésus i diyà sa simbaan Hudiyu owoy mig-angay diyà sa dalesan i Simon owoy si Andelis. Mig-unut ma si Santiyago owoy si Huwan. ");
INSERT INTO mta_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Egoh da migtebow, tinulon da diyà si Hésus eglinadu sa nugangan i Simon bayi eghibat danà di egkegenaw temù. ");
INSERT INTO mta_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Agulé mig-angay Hésus i egdapag diyà sa eglinadu, owoy sinabaan di sa belad di owoy pinetigdeg di. Hê, petow dé nelikuan iya wé bayi owoy mig-edung ma dé egmengana kenagda. ");
INSERT INTO mta_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Na, egoh di mig-eled dé sa agdaw, inuwit da diyà si Hésus sa langun etaw eglinadu owoy sa medoo etaw linahuk busaw. ");
INSERT INTO mta_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Medoo temù sa etaw kedu diyà iya wé menuwa egkesetipon diyà sa duwangen kenà i Hésus eg-ugpà. ");
INSERT INTO mta_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Binulungan di sa medoo etaw eglinadu sumalà dé sa linadu da, owoy duen ma medoo busaw pinelesut di diyà sa medoo etaw. Dodoo hinawidan i Hésus sa medoo busaw anì endà mikagi da, enù ka egkilalaen da kagdi i. ");
INSERT INTO mta_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na, egoh di umawang dé sa kesimag di, mig-enaw Hésus i owoy eg-angay eglebù diyà sa kenà endà duen dalesan enù ka sumimbà dahiya. ");
INSERT INTO mta_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Agulé inangay i Simon owoy sa medoo duma di eglagbet kagdi i. ");
INSERT INTO mta_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Egoh da mighaa kenagdi, guwaen da, “Eglagbeten sa langun etaw kuna i.” ");
INSERT INTO mta_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Dodoo migsagbì Hésus i, guwaen di, “Lumagbas ki polo diyà sa medoo liyu menuwa anì tumegudon a ma dahiya, enù ka iya sa pesuwan ku mig-angay a dini.” ");
INSERT INTO mta_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Agulé, egtukiden di sa langun menuwa diyà uwang Galiliya, owoy egtegudon diyà sa medoo simbaan Hudiyu, owoy egpelesuten di ma sa busaw miglahuk diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na, duen sa maama eglinadu dempid mig-angay diyà si Hésus. Migligkued diyà sa taengan di owoy egpegeni tabang, guwaen di, “Megaga ko kumedan siini linadu ku amuk iya sa ungayà ko.” ");
INSERT INTO mta_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Agulé, eghiduwan i Hésus kagdi, owoy binegeng di sa belad di owoy sinabaan di sa maama. Guwaen di, “Meiyap a doo. Haa ko, nelikuan ka dé.” ");
INSERT INTO mta_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hê, petow dé nekedan sa linadu di dempid owoy nelikuan dé. ");
INSERT INTO mta_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Agulé tigtu hinawidan i Hésus, guwaen di, “Yaka egtulon duu diyà etaw sa egoh ko nelikuan. Dodoo angay ka polo pehaa diyà sa tegesimbà owoy begay ka ma sa hinagtay ulowen diyà si Nemula iling sa igsugù i Mosis denu sa kepelanih ko diyà sa kehaa i Nemula. Amuk hediya, tandaan ko diyà sa langun etaw sa egoh ko nelikuan dé.” Agulé pineipanaw i Hésus dé. ");
INSERT INTO mta_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Dodoo egoh sa maama mig-ipanaw, tinulon di polo diyà sa medoo etaw sa binaelan i Hésus diyà kenagdi. Huenan di, endà dé mekeangay Hésus i diyà sa medoo menuwa, dodoo eg-ugpà diyà sa kenà endà medoo dalesan enù ka eg-angay diyà kenagdi sa medoo etaw kedu diyà sa langun menuwa. ");
INSERT INTO mta_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na, egoh di neuma sa sebaen agdaw, egpelikù Hésus i diyà sa menuwa Kapelenaum. Dinineg sa medoo etaw sa egoh di miglikù diyà sa dalesan di, ");
INSERT INTO mta_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","huenan di medoo temù sa etaw egkesetipon dahiya. Nebelet sa dalesan lapeg sa duwangen di medapag diyà sa selat di, huenan di endà dé mekeukit sa etaw dahiya. Na, egoh i Hésus egtegudon sa kagi i Nemula diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","duen sa maama egtodel sa langun lawa di egseoyongon epat gemaama diyà sa kateli. ");
INSERT INTO mta_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dodoo endà duen sa ukitan da eg-oyong mangay diyà si Hésus, enù ka nealang da danà sa medoo etaw egkesepisok. Huenan di, inuwit da sa kateli dutu siedò iyug atep mepatag. Tinosongon da sa atep diyà sa selatal kenà i Hésus owoy tinuntun da sa maama lapeg sa kateli di diyà sa taengan i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na, egoh i Hésus neketiig dakel sa kepigtuu da, guwaen di diyà sa maama egtodel, “O Akay, nekepeuloy dé sa medoo salà ko.” ");
INSERT INTO mta_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, duen medoo tegetulù uledin igsugkow i Mosis egpenuu dahiya. Nelikutan sa pedu da danà sa inikagi i Hésus, owoy ");
INSERT INTO mta_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","egseolomoy da, guwaen da, “Ay, dakel temù sa salà siini maama, enù ka egtepengen di Nemula i. Endà duen etaw mekepeuloy salà liyu daa si Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dodoo netiigan i Hésus sa penemdem da, huenan di guwaen di diyà kenagda, “Maen di ya egkelikutan sa pedu yu danà sa inikagi ku? ");
INSERT INTO mta_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Enù di ya, ngadan tayu sa melemu egbaelan sa etaw, ipeuloy di sa salà siini maama egtodel ataw ka bulungan di anì meketigdeg anì umuwit sa kateli di owoy mekebigkat ma? Endà mebaluy di amuk etaw daa. ");
INSERT INTO mta_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Dodoo duen pelawà sa ipehaa ku diyà keniyu anì metiigan yu aken sa Kakay Langun anì metiigan yu ma amuk mekegaga a egpeuloy salà diyà tanà.” Agulé, guwaen i Hésus diyà sa maama egtodel, ");
INSERT INTO mta_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“O Akay, tigdeg ka dé. Uwit ko sa kateli ko owoy likù ka dé.” ");
INSERT INTO mta_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Hê, migtigdeg sa maama, owoy mesiyapat inuwit di sa kateli di, owoy eghauwen sa medoo etaw sa kelikù di. Huenan di, tigtu egkegaip da langun owoy eg-oloen da Nemula i, guwaen da, “Edung egoh anay endà duen sa eghauwen ta binaelan etaw éhê iya wé.” ");
INSERT INTO mta_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na, egoh i Hésus migpenaug, eg-angay dema diyà sa mantadan Lanaw Galiliya. Egkesetipon dema sa medoo etaw diyà kenagdi owoy egtuluen di kagda. ");
INSERT INTO mta_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Agulé, egoh di eg-ipanaw uman, hinaa di sa maama atung egpeetuken sa sulutan egpenuu diyà sa lawì atung kenà di eg-etuk. Iya sa ngadan di si Lebi anak i Alpiyo. Agulé guwaen i Hésus diyà kenagdi, “Unut-unut ka kenak.” Hê migtigdeg Lebi i owoy eg-unut ma dé diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Agulé, egkaen Hésus i owoy sa medoo pasek di diyà sa dalesan i Lebi. Duen ma dahiya sa medoo etaw duma da egkaen, sa medoo atung egpeetuken sa Sulutan owoy sa medoo etaw tegebael salà, enù ka medoo da eg-unut-unut diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Duen ma dahiya sa medoo etaw Palasiyu tegetulù uledin igsugkow i Mosis. Egoh da mighaa si Hésus neseunut da egkaen sa medoo etaw tegebael salà owoy sa medoo atung egpeetuken sa sulutan, eg-igsaan da sa medoo pasek i Hésus, guwaen da, “Maen di ya egselenganen i Hésus egkaen sa medoo etaw atung egpeetuken sa sulutan owoy sa medoo duma da tegebael salà?” ");
INSERT INTO mta_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Dodoo egoh i Hésus migdineg iya wé inikagi da, sinagbian di kagda, guwaen di, “Amuk metéél sa etaw, endà duen maen di ya lumagbet tegebulung. Sa etaw eglinadu polo sa lumagbet tegebulung. Pineangay a dini anì isasà ku sa medoo etaw neketiig duen salà da, beken duu sa medoo etaw guwaen da dò endà duen salà da.” ");
INSERT INTO mta_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Na, sebaen agdaw egpeulanen sa medoo Palasiyu owoy sa medoo pasek i Huwan Tegebautis sa kekaen da anì sumimbà da daa. Agulé, duen etaw mig-angay eg-igsà diyà si Hésus, guwaen da, “Takaan da egpeulan sa medoo pasek i Huwan sa kekaen da anì sumimbà da daa, owoy hediya ma sa adat sa medoo Palasiyu. Dodoo sa niko pasek, maen di ya endà ma egpeulanen da sa kekaen da?” ");
INSERT INTO mta_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Agulé migsagbì Hésus i peligad, guwaen di, “Amuk duen sa pista kawing, endà mebaluy di amuk peulanen ta sa kekaen ta amuk dahiya pelawà sa maama egkawingen. ");
INSERT INTO mta_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Dodoo dumuen pa sa agdaw mekedan sa maama diyà sa medoo duma di. Iya pelawà sa egoh da peulan sa kekaen da enù ka mebukul da.” ");
INSERT INTO mta_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Agulé, egpeligad dema Hésus i denu sa egoh di endà meseamut sa magtu igtulù di owoy sa tapay uledin. Guwaen di, “Upama, duen tapay ginis ko nelisì, endà mepion di amuk itabung ko diyà sa tapay sa magtu ginis endà pinìpian di, enù ka kumipes sa tabung di owoy meumanan pa kedakel sa lisì di. ");
INSERT INTO mta_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hediya ma, amuk sa magtu wain owoy sa kunul kambing taguan wain, endà itagù ta sa magtu wain diyà sa tapay taguan di enù ka mebetu danà sa kelukotok di enù ka endà eghened sa tapay kunul kambing. Melemet sa wain owoy medaetan ma sa taguan di. Dodoo, itagù ta polo sa magtu wain diyà sa magtu taguan di.” ");
INSERT INTO mta_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na, egoh sa sebaen Sapetu sa agdaw keetud da, mig-ukit Hésus i owoy sa medoo pasek di diyà sa dalan egtelek tinibah. Egoh da eg-ipanaw, inelus sa medoo pasek di sa palay owoy sinukut da. ");
INSERT INTO mta_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Agulé, guwaen sa medoo Palasiyu diyà si Hésus, “Taa ko. Egtipay sa medoo pasek ko sa uledin ta denu sa agdaw keetud, enù ka galebek iya wé binaelan da.” ");
INSERT INTO mta_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Migsagbì Hésus i, guwaen di, “Lagà yu endà nekebasa sa kagi i Nemula denu sa binaelan i Dabid egoh anay egoh di nelikutan neketues lapeg sa medoo duma di. ");
INSERT INTO mta_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Egoh i Abiatal sa Tigtu Ulu-ulu Tegesimbà, migludep Dabid i diyà sa Dalesan i Nemula owoy kinaen di sa epan diyà sa lamisan, sa epan igbegay diyà si Nemula. Pinekaen di ma sa medoo duma di. Apiya di pa migtipay ma diyà sa uledin ta denu siedò epan enù ka sa tegesimbà daa sa mekekaen iya wé, beken doo salà iya wé binaelan di.” ");
INSERT INTO mta_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Guwaen i Hésus ma, “Muna binaelan i Nemula sa etaw, agulé sinugù di sa agdaw keetud da. Amuk hediya, uman pa milagà sa etaw diyà sa agdaw keetud. ");
INSERT INTO mta_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na, aken i Kakay Langun sa Datù diyà siini uledin ta denu sa agdaw keetud, huenan di mekegaga a tumulù etaw sa mepion egbaelan da diyà sa agdaw keetud.” ");
INSERT INTO mta_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Agulé, egludep dema Hésus i diyà sa simbaan Hudiyu. Duen dahiya sa maama melungoy dibaluy belad. ");
INSERT INTO mta_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Duen ma etaw dahiya egtulikan da Hésus i amuk bulungan di sa etaw diyà sa agdaw keetud anì dumuen sa meketipu da kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Agulé, guwaen i Hésus diyà sa maama, “O Akay, angay ka dini.” ");
INSERT INTO mta_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Agulé, eg-igsaan i Hésus sa medoo etaw dahiya, guwaen di, “Ngadan tayu sa mepion diyà sa uledin ta denu sa agdaw keetud, tumabang ki ataw ka meumàumà ki? Ngadan tayu sa mepion, alukan ta sa etaw ataw ka imatayan ta?” Dodoo endà egsagbì da. ");
INSERT INTO mta_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Agulé, egtukiden i Hésus eghaa kagda owoy egbulit enù ka egkebukulan di kagda danà di endà duen kehidu da sa duma da. Agulé, guwaen di diyà sa maama melungoy belad, “Begeng ko sa belad ko.” Egoh di migbegeng, petow dé nelikuan sa belad di. ");
INSERT INTO mta_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Agulé, miglaun sa medoo Palasiyu owoy egkeseolom da sa medoo etaw i Datù Hélod enù ka eglagbeten da sa ukit keimatay da si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Agulé, mig-ipanaw Hésus i owoy sa medoo pasek di eg-angay diyà sa Lanaw Galiliya. Medoo temù sa etaw eg-unut-unut diyà kenagdi. Duen kedu uwang Galiliya, duen ma kedu uwang Hudiya, ");
INSERT INTO mta_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","duen ma kedu diyà Hélusalém, owoy kedu da ma uwang Idumiya, owoy duen ma kedu tanà dutu lawaꞌt Holdan, owoy kedu da ma sa uwang menuwa Tilo owoy menuwa Sidon. Tigtu medoo sa etaw mig-angay diyà si Hésus enù ka dinineg da sa lalag sa medoo panduan di. ");
INSERT INTO mta_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huenan di, eg-ikagiyan i Hésus sa medoo pasek di anì kuwaen da sa kumpit anì dumalem egtulù diyà sa medoo etaw enù ka egkesedeldel da egdapag diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Binulungan di sa medoo etaw eglinadu, huenan di egkesedeldel da egdapag diyà kenagdi anì meamis da. ");
INSERT INTO mta_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Duen ma etaw linahuk busaw eg-angay egdapag diyà si Hésus. Egoh da mighaa kenagdi, egligkued da eg-umow diyà sa taengan di, guwaen da, “Kuna sa Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Dodoo tigtu hinawidan i Hésus kagda anì endà tulonen da duu diyà etaw sa denu kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Agulé migtekedeg Hésus i diyà sa getan, owoy sinetipon di sa medoo etaw egkeiyapan di. Mig-angay da migdapag diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hinemilì di sa sepulù owoy duwa enù ka ginelal di kagda salu di. Agulé guwaen di diyà kenagda, “Hinemilì ku kiyu anì takà yu umunut kenak, owoy peangayen ku ma kiyu anì tumegudon yu, ");
INSERT INTO mta_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","owoy begayan ku ma kiyu egkegaga pelesut busaw diyà etaw.” ");
INSERT INTO mta_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Na, ini ngadan sa sepulù owoy duwa etaw hinemilì di: si Simon pinengadanan di ma si Pidelu, ");
INSERT INTO mta_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","owoy si Santiyago anak i Sébediyu, owoy si Huwan hadi i Santiyago. Pinengadanan di siini duwa etaw Boanilges, enù ka lagà kilat sa pedu da. ");
INSERT INTO mta_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Hinemilì di ma si Andelis, owoy si Pilipi, owoy si Baltolomi, owoy si Matéyo, owoy si Tomas, owoy sa sebaen ma Santiyago anak i Alpiyo, owoy si Tadiyo, owoy sa sebaen ma Simon sa mebagel eghemalang sa tanà Hudiya, ");
INSERT INTO mta_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","owoy si Hudas Iskaliyot sa maama tumampil diyà sa medoo kuntelà i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Agulé eglikù Hésus i, dodoo endà egpekekaen di owoy sa medoo salu di enù ka medoo temù sa etaw egkesetipon dema diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huenan di, egoh sa medoo tigtu duma i Hésus migdineg endà egpekekaen di, eg-angayen da kagdi enù ka duen etaw guwaen da dò egkelengleng Hésus sa. ");
INSERT INTO mta_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Duen ma tegetulù uledin igsugkow i Mosis kedu diyà Hélusalém, guwaen da, “Si Bilsibul datù busaw sa miglahuk diyà kenagdi, huenan di megaga di egpelesut busaw diyà etaw danà sa tunung igbegay i Bilsibul diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Agulé, inumow i Hésus sa medoo etaw owoy tinulonon di kagda peligad. Guwaen di, “Endà mebaluy di si Satanas sa egpelesut sa duma di busaw diyà sa etaw. ");
INSERT INTO mta_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Enù ka upama, amuk egsekuntelaay sa medoo etaw eg-unut diyà sa datù, endà melugay di mekedan sa kedatuan sa kaunutan da. ");
INSERT INTO mta_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Diya ma sa segemalay amuk egselimbulay da, endà melugay di medaetan ma sa malayan da. ");
INSERT INTO mta_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hediya ma, amuk egkuntelaen i Satanas sa medoo etaw di, endà ma melugay di mekedan sa egkegaga di egpedatù, enù ka medaetan ma sa kedatuan di.” ");
INSERT INTO mta_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Eg-uman Hésus i egpeligad anì metiigan da tinabanan di Satanas i, guwaen di, “Upama, endà duen etaw mekeludep diyà sa dalesan sa maama mebagel anì lampasen di sa medoo langun taman di taman endà poloten di duu sa épê dalesan. Amuk tinabanan di, lampasen di doo sa langun taman di.” ");
INSERT INTO mta_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tuu ini i eg-ikagiyen ku diyà keniyu. Mekepeuloy i Nemula doo sa salà etaw, sumalà dé sa medaet egbaelan da ataw ka sa medaet eg-ikagiyen da. ");
INSERT INTO mta_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Dodoo sa etaw egsumbung sa Metiengaw Suguy i Nemula, endà mekepeuloy iya wé salà di owoy endà ma mekedan di taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na, iya sa inikagi i Hésus diyà kenagda enù ka guwaen sa medoo tegetulù linahuk busaw Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Agulé, migtebow sa inay i Hésus owoy sa medoo hadi di maama. Egoh da pelawà diyà duwangen, igpeuwit da sa kagi da diyà si Hésus anì menaug. ");
INSERT INTO mta_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Duen ma melaweng etaw egpenuu medapag diyà kenagdi, owoy guwaen da, “Taa ko, diyà duwangen sa inay ko owoy sa medoo hadi ko. Ungayà da mikagi diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Dodoo guwaen i Hésus, “Tulonen ku diyà keniyu sa inay ku owoy sa medoo hadi ku.” ");
INSERT INTO mta_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Agulé, eg-inengtengen di sa medoo etaw egpenuu medapag diyà kenagdi, owoy guwaen di, “Taa yu. Ini polo sa inay ku owoy sa medoo hadi ku, ");
INSERT INTO mta_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","enù ka sa medoo etaw egpangunut diyà sa uyot i Emà ku si Nemula, iya lagà sa inay ku owoy tebay ku owoy hadi ku maama.” ");
INSERT INTO mta_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na, eg-edung dema Hésus i egtulù diyà sa mantadan lanaw. Temù medoo sa etaw egkesetipon dahiya, huenan di mighalì Hésus i egpenuu dalem sa kumpit. Dodoo diyà da mantadan sa medoo etaw egdinegdineg sa kagi di. ");
INSERT INTO mta_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Agulé, medoo sa itulù di kenagda danà di migtulon peligad. ");
INSERT INTO mta_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Egoh di egtulù, guwaen di, “Na, duen sa maama eg-angay egsawel benì diyà sa hinemulaan di. ");
INSERT INTO mta_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Egoh di egsawel, duen benì neketenà diyà dalan. Hê, neimet sa medoo manuk egkaen. ");
INSERT INTO mta_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Duen ma duma benì neketenà diyà sa menipis tanà batuwen. Medelamet migtubù enù ka endà mekepal sa tanà di. ");
INSERT INTO mta_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hê egoh di meedup sa agdaw, eglegupay owoy nematay dé enù ka endà medalem sa kedalid di. ");
INSERT INTO mta_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Duen ma duma benì neketenà diyà sa sepinitpinit. Agulé neseselengan da egtubù owoy nesilung sa palay danà sa sepinit, huenan di endà egbunga di. ");
INSERT INTO mta_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dodoo, neketenà sa duma benì diyà sa mepion tanà. Agulé egtubù owoy eglenuk owoy egbunga. Uman sebaen benì, nekesugat temù sa kebunga di, duen nekeuma telu pulù, duen enem pulù owoy duen magatus.” ");
INSERT INTO mta_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Agulé guwaen i Hésus, “Amuk mipedu yu egdineg, penemdem yu, hih, sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na, egoh di endà iseg medoo etaw, mig-angay diyà si Hésus sa sepulù owoy duwa salu di owoy sa duma etaw. Eg-igsaen da sa selepangan sa peligad di. ");
INSERT INTO mta_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Agulé guwaen i Hésus, “Kiyu i medoo pasek ku, igpetiig i Nemula dé diyà keniyu sa penemdem nelidung egoh anay denu sa kedatù di. Dodoo metulonon daa peligad sa medoo liyu etaw, ");
INSERT INTO mta_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","enù ka ‘Apiya di pa takà da eghahaa, endà eghauwen da duu, owoy apiya di pa takà da egdinegdineg, endà metiigan da duu. Dodoo amuk meketiig da, meekedan da polo sa medaet egbaelan da owoy metuing doo sa pedu da diyà si Nemula anì ipeuloy di sa salà da.’ ” ");
INSERT INTO mta_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Agulé, guwaen i Hésus diyà kenagda, “Egkegaip a keniyu enù ka endà egketiigan yu duu siini peligad tinulon ku. Amuk endà egketiigan yu duu, endà ma metiigan yu duu sa medoo liyu peligad ku. ");
INSERT INTO mta_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na sa peligad tinulon ku, iya sa selepangan sa benì igsawel etaw sa kagi i Nemula nekeseluh diyà sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sa benì neketenà diyà dalan, iya lagà sa medoo etaw egdineg daa uloy sa kagi i Nemula. Agulé, egtebow Satanas i owoy egkedanan di diyà sa pedu da anì endà mekepigtuu da. ");
INSERT INTO mta_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Na, sa benì neketenà diyà sa tanà batuwen, iya lagà sa medoo etaw egdineg sa kagi i Nemula owoy neanggan dé sa pedu da egoh da egsakem, ");
INSERT INTO mta_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","dodoo lagà endà duen dalid di, enù ka endà melugay di sumabuh da migtuu amuk egkepelihay da danà sa kepigtuu da sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na, sa benì neketenà diyà tanà épê sepinitpinit, iya lagà sa medoo etaw egdineg sa kagi i Nemula, ");
INSERT INTO mta_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","dodoo lagà egkesilung sa kepigtuu da. Egkelakà da danà sa medoo langun taman da owoy sa ungayà da egpekawasà owoy danà ma sa medoo angayan pedu da. Huenan di, endà mebaluy di sa kebunga sa kepigtuu da. ");
INSERT INTO mta_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dodoo sa benì neketenà diyà sa mepion tanà, iya lagà sa medoo etaw egdinegdineg sa kagi i Nemula owoy tigtu da egpigtuu. Mepion sa kebunga sa kepigtuu da, duen nekeuma telu pulù, duen enem pulù, duen magatus.” ");
INSERT INTO mta_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Agulé, eg-uman Hésus i eg-ikagi diyà kenagda, guwaen di, “Amuk tinemteman etaw sa palitaan, endà pelagkeban di duu solok owoy endà ma peleketanaen di duu diyà sa kateli. Dodoo mehagtaw polo sa kenà di itagù anì hauwen sa langun etaw sa legdaw di. ");
INSERT INTO mta_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hediya ma, meawangan doo sa langun linimunan owoy mehaa doo sa langun linidung anì metiigan yu sa selepangan di. ");
INSERT INTO mta_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amuk mipedu yu egdineg, penemdem yu hih sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Guwaen i Hésus ma diyà kenagda, “Pigtuu yu temù sa igtulù ku dinineg yu. Amuk hediya, ipetiig i Nemula doo diyà keniyu, owoy pesubelawen di pa sa metiigan yu. ");
INSERT INTO mta_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Enù ka sa etaw egpigtuu, meumanan pa sa netiigan di. Dodoo sa etaw endà egpigtuu, mekedan pa uman sa tukééy egketiigan di.” ");
INSERT INTO mta_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Egpeligad dema Hésus i, guwaen di, “Lagà ini i sa kedatù i Nemula. Duen sa etaw mighemula benì diyà sa tinibah di, ");
INSERT INTO mta_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","dodoo egpandayaen di daa sa ukit kelenuk sa medoo hinemula di. Egtudug amuk sigep owoy eggalebek amuk agdaw, dodoo uman agdaw egtunas sa medoo hinemula di owoy eglenuk doo apiya di pa endà netiigan di duu sa ukit kelenuk di. ");
INSERT INTO mta_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Takà eglenuk sa hinemula di danà sa tanà daa. Muna egtebagang, agulé eglesut sa daun di, agulé lumesut ma sa bunga di owoy egkelegà ma dé. ");
INSERT INTO mta_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Amuk melegà dé, egpupuwen sa épê tanà sa bunga di, enù ka neuma dé sa kepupu di.” ");
INSERT INTO mta_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Agulé guwaen i Hésus, “Enù di ya, ngadan sa pegulepengan ku sa kedatù i Nemula? Ngadan sa peligad tulonen ku anì metiigan yu? ");
INSERT INTO mta_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sa kedatù di lagà sa segebelahan dalem mustad hinemula etaw diyà sa hemulaan di. Apiya di pa uman pa tukééy sa dalem di diyà sa langun benì, ");
INSERT INTO mta_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","egtubù doo owoy uman pa kumedakel diyà sa medoo liyu hinemula etaw. Dakel sa panga di anì mekebaluy sumalag sa medoo manuk dahiya.” ");
INSERT INTO mta_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na, egtegudon Hésus i sa kagi i Nemula diyà kenagda danà sa medoo liyu peligad tinulon di taman sa egketiigan da daa. ");
INSERT INTO mta_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Endà duen sa itulù di kenagda liyu daa sa peligad di, dodoo egoh da eglebù sa medoo salu di, sinelepang di diyà kenagda sa medoo peligad di. ");
INSERT INTO mta_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na, egoh di buyu eg-eled sa agdaw, eg-ikagi Hésus i diyà sa medoo salu di, guwaen di “Kumatin ki tanà dutu sa lanaw.” ");
INSERT INTO mta_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Agulé, sinalidan da sa medoo etaw nesetipon diyà sa mantadan, owoy mig-edà sa medoo salu di diyà sa kumpit kenà i Hésus tapay egpenuu. Duen ma sa medoo liyu kumpit eg-edaan sa medoo etaw dahiya anì eg-unutan da Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hê, nesampen da sa meleges kelamag diyà sa lanaw owoy egkeawuhan wayeg sa kumpit da taman sa egoh di buyu dé egketegeb. ");
INSERT INTO mta_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dodoo egdanan Hésus i egtudug diyà sa ulinan kumpit. Agulé inangay da eg-enaw, guwaen da, “O Mistelu, egpekesugsug ki. Maen di ya endà egsagipaen ko duu?” ");
INSERT INTO mta_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Agulé, mig-enaw Hésus i owoy hinawidan di sa kelamag owoy sa dakel lambeg, guwaen di, “Sabuh yu dé.” Hê, petow dé migsabuh owoy miglinek ma dé. ");
INSERT INTO mta_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Agulé guwaen i Hésus, “Maen di ya egkelimedangan yu? Endà pa egpigtuu yu kéen diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dodoo egkegaip da temù owoy egseolomoy da, guwaen da, “Ngadan ini i maama? Apiya sa kelamag owoy sa lambeg, egpangunut da doo diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na, egdunggù da Hésus i diyà sa uwang Gelasin tanà dutu sa lanaw. ");
INSERT INTO mta_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Egoh i Hésus migtenà, migtelabuk sa maama linahuk busaw kedu diyà sa kenà lebeng ");
INSERT INTO mta_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","enù ka iya sa kenà di eg-ugpà. Tigtu mebagel owoy endà mebaluy di molot, enù ka apiya sangkalì sa ipolot da, anan mebugtus. ");
INSERT INTO mta_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Apiya di pa medoo gulê egpoloten da sa belad di owoy sa lisen di, mebugtus doo sa medoo igpolot. Endà egkesabaan di etaw enù ka mebagel temù. ");
INSERT INTO mta_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Huenan di, agdaw owoy sigep takà egtimbultimbul diyà sa kenà lebeng owoy getan-getan, owoy takà ma eg-umow owoy egpalian di batu sa lawa di. ");
INSERT INTO mta_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Egoh sa maama migsugpayal si Hésus, egletu eg-angay dutu owoy egligkued diyà sa taengan di. ");
INSERT INTO mta_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Agulé, eghemagawan i Hésus sa busaw miglahuk diyà kenagdi, guwaen di, “Laun ka dé diyà siini etaw.” Dodoo pinetaled di sa kagi di, guwaen di, “O Hésus, maen di ya egbogowen ko aken? Netiigan ku kuna sa Anak i Nemula sa Nemula tigtu mapulù. Ini egoh di diyà sa kehaa i Nemula, egpegeni a diyà keniko anì yaka pa egpigtamay kenak.” ");
INSERT INTO mta_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Agulé inigsaan i Hésus, guwaen di, “Ngadan ko ya?” Migsagbì, guwaen di, “Si Melaweng sa ngadan ku enù ka medoo ké temù miglahuk diyà siini etaw.” ");
INSERT INTO mta_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Agulé, tigtu egpegeni diyà si Hésus anì endà hemagawan di duu dutu mediyù dò. ");
INSERT INTO mta_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, duen ma medoo babuy eglagbet da kaenen diyà sa getan-getan medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Agulé, migpegeni sa busaw diyà si Hésus, guwaen di, “Amuk mebaluy diyà keniko, mangay ké lumahuk diyà sa medoo babuy.” ");
INSERT INTO mta_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Agulé, pinandayà di dé kagda. Agulé miglesut sa medoo busaw diyà sa maama owoy mighalì da eglahuk diyà sa babuy. Hê, sa medoo babuy, duwa ngibu, migletu da langun miglungel diyà sa kesagdigan owoy nekelesek da diyà sa lanaw. Nelened da langun. ");
INSERT INTO mta_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Agulé, egpelaguy sa medoo tegeipat babuy eg-angay egtulon diyà sa dakel menuwa owoy diyà sa medoo liyu dalesan medapag dahiya. Egoh sa medoo etaw migdineg, eg-angay da diyà si Hésus anì hauwen da sa nebaelan sa medoo babuy. ");
INSERT INTO mta_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Egoh da migtebow diyà si Hésus, hinaa da sa maama magtu linesutan medoo busaw. Egpenuu owoy migginis dé owoy neketuleng ma dé. Egoh da mighaa iya wé, tigtu da egkelenawan. ");
INSERT INTO mta_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Agulé, sa medoo etaw mighaa sa binaelan i Hésus diyà sa maama linahuk busaw owoy sa nebaelan sa medoo babuy, egtulon da diyà sa medoo etaw egtebow. ");
INSERT INTO mta_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Agulé, egpegeni da diyà si Hésus anì sumalid diyà sa menuwa da. ");
INSERT INTO mta_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na, egoh i Hésus eg-edà kumpit, egpegeni eg-unut sa maama linesutan busaw diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Dodoo hinawidan di, guwaen di, “Likù ka polo, angay ko tulon diyà sa medoo duma ko sa mepion binaelan i Nemula diyà keniko owoy sa dakel kehidu di keniko.” ");
INSERT INTO mta_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Agulé, eglikù sa maama owoy takà egtulon diyà sa uwang menuwa Dikapolis denu sa dakel ketabang i Hésus diyà kenagdi. Huenan di, egkegaip sa langun etaw tinulonon di. ");
INSERT INTO mta_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na, egoh da i Hésus miglikù migkatin tanà dutu sa lanaw, tigtu medoo sa etaw egkesetipon diyà kenagdi diyà mantadan. ");
INSERT INTO mta_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Agulé, duen sa maama ulu-ulu diyà sa simbaan Hudiyu migtebow. Iya sa ngadan di, si Hailu. Egoh di mighaa si Hésus, migligkued diyà sa taengan di, ");
INSERT INTO mta_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","owoy egpegeni, guwaen di, “Buyu dé egkematay sa tukééy anak ku bayi danà sa linadu di. Egpegeni a diyà keniko angay ko pa sabai anì melikuan owoy mehagtay.” ");
INSERT INTO mta_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Agulé, eg-unut Hésus i diyà si Hailu. Na, egoh da eg-ipanaw, medoo da temù eg-unut kenagda owoy egkesedeldel da. ");
INSERT INTO mta_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, duen ma sa bayi sepulù owoy duwa dé gepalay sa lugay di endà egkedit sa depanug di adat bayi. ");
INSERT INTO mta_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Apiya di pa takà egpebulung diyà sa medoo tegebulung, endà egkegaga da duu. Neimet uloy sa pilak di egbayad dodoo endà nelikuan di, egtemù polo sa linadu di. ");
INSERT INTO mta_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Egoh di migdineg sa lalag i Hésus, mig-unut ma diyà sa medoo etaw egsetugdug kenagdi enù ka egtelukunan di eg-amis sa ginis di, ");
INSERT INTO mta_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","enù ka egpenemdemen di melikuan amuk meamis di daa sa ginis i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hê, egoh di mig-amis sa kawal i Hésus, petow dé migkedit sa depanug di, owoy egtugedamen di nekedan dé sa linadu di. ");
INSERT INTO mta_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na, tinugedam i Hésus ma duen nebaelan sa tunung di, huenan di mig-ugpà owoy eghahauwen di sa medoo etaw. Eg-igsà, guwaen di, “Ngadan tayu di etaw sa mig-amis sa ginis ku?” ");
INSERT INTO mta_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Egsagbì sa medoo salu di, guwaen da, “O Mistelu, eghauwen ko doo sa medoo etaw egkesepisok diyà keniko. Maen di ya eg-igsaen ko ngadan tayu di etaw sa mig-amis keniko?” ");
INSERT INTO mta_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Dodoo, eghahauwen i Hésus sa medoo etaw anì lagbeten di sa mig-amis sa ginis di. ");
INSERT INTO mta_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Agulé egkelimedangan sa bayi enù ka netiigan di nekedan sa linadu di danà di mig-amis sa ginis i Hésus. Huenan di, mig-angay diyà kenagdi owoy eglukub ma danà di egkelenawan. Migligkued diyà sa taengan di owoy tinulon di diyà kenagdi langun denu sa linadu di owoy sa pesuwan di nelikuan. ");
INSERT INTO mta_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Agulé guwaen i Hésus, “O Okon, nelikuan ka dé danà sa kepigtuu ko. Mepion sa kelikù ko enù ka migtanà sa pedu ko danà sa linadu ko nekedan.” ");
INSERT INTO mta_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na, egoh i Hésus telibubu eg-ikagi diyà sa bayi, duen etaw migtebow kedu diyà sa dalesan i Hailu. Eg-ikagi da diyà si Hailu, guwaen da, “Endà dé sa anak ko bayi. Yaka dé uman duu egbogo sa mistelu.” ");
INSERT INTO mta_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Dodoo endà egsagipaen i Hésus duu sa inikagi da. Guwaen di diyà si Hailu, “Yaka egkelenawan na. Pigtuu ka daa diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Endà duen etaw pineunut i Hésus eg-angay diyà sa dalesan liyu daa si Hailu owoy si Pidelu owoy si Santiyago owoy si Huwan hadi i Santiyago. ");
INSERT INTO mta_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Egoh da migtebow diyà sa dalesan sa ulu-ulu simbaan, hinaa i Hésus sa medoo etaw egséléken dahiya. Duen egsinegaw owoy duen ma egdelawit. ");
INSERT INTO mta_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Egoh di miggemow diyà sa dalesan, guwaen di diyà sa medoo etaw, “Maen di ya takà yu egséléken? Yoko egsinegaw wa. Endà nematay sa batà, egtudug daa.” ");
INSERT INTO mta_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dodoo eggemenan da polo kagdi i. Agulé, pinelaun i Hésus sa langun etaw kedu diyà sa dalesan. Inuwit di sa emà sa batà owoy sa inay di, owoy sa telu salu di egludep diyà sa bilik kenà sa batà pinehibat. ");
INSERT INTO mta_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Agulé, sinabaan di belad sa batà owoy guwaen di diyà sa hagdi kagi, “Talita kumi.” Na, iya sa selepangan di, “O Okon, enaw ka dé.” ");
INSERT INTO mta_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Hê, petow dé mig-enaw sa batà owoy egbigkat ma dé. Huenan di, tigtu negaip temù sa emà di owoy sa inay di, dodoo hinawidan i Hésus kagda anì endà tulonen da duu diyà etaw. Agulé, sinugù di kagda anì pekaenen da sa anak da. Na, sepulù owoy duwa gepalay dé sa kelukes di. ");
INSERT INTO mta_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na, miglegkang Hésus i owoy sa medoo salu di dahiya owoy migpelikù da diyà sa tapay menuwa di Nasalét. ");
INSERT INTO mta_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Egoh di neuma sa agdaw Sapetu, sa agdaw keetud etaw Hudiyu, mig-angay Hésus i egtulù diyà sa simbaan da. Egkegaip sa medoo etaw nesetipon dahiya egoh da migdineg sa kagi di. Guwaen da, “Ay, ngadan keduwan sa egkegaga di? Maen di ya milantek sa ketulù di? Maen di ya egkegaga di egbael sa panduan? ");
INSERT INTO mta_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Enù ka siini maama, netiigan ta doo kagdi sa kalpintilu anak i Maliya. Netiigan ta ma sa medoo hadi di, si Santiyago owoy si Hosé owoy si Hudas owoy si Simon. Owoy eg-ugpà ma sa medoo tebay di diyà sa menuwa ta. Ngadan keduwan sa hagdi egkegaga kéé?” Na, iya sa pesuwan di endà egpigtuu da diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dodoo guwaen i Hésus diyà kenagda, “Sumalà dé sa tegesugkow i Nemula, eg-ekedan sa medoo duma di telehadi owoy sa medoo liyu etaw diyà sa tigtu menuwa di. Dodoo eg-adatan polo sa medoo etaw diyà sa liyu menuwa.” ");
INSERT INTO mta_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na, iya sa pesuwan di endà iseg di medoo sa panduan binaelan i Hésus dahiya enù ka endà egpigtuu da. Tukééy daa sa etaw eglinadu sinabaan di anì melikuan da. ");
INSERT INTO mta_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Egkegaip Hésus i enù ka endà egpigtuu sa medoo etaw dahiya. Na, egtukid Hésus i egtulù diyà sa langun menuwa medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Agulé, sinetipon di sa sepulù owoy duwa salu di anì peangayen di kagda petegudon. Tinigduwa-duwa di kagda, owoy binegayan di kagda tunung anì mekegaga da pelesut busaw miglahuk diyà etaw. ");
INSERT INTO mta_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Migsasà diyà kenagda, guwaen di, “Amuk mipanaw yu, ulan sa medoo eg-uwiten yu, liyu daa sa tuked. Ulan sa keuwit yu sa legà ataw ka puyut ataw ka pilak. ");
INSERT INTO mta_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mebaluy tumalumpà yu, dodoo ulan sa keuwit yu duma kawal yu.” ");
INSERT INTO mta_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Guwaen di ma, “Amuk mekeuma yu diyà sa menuwa, ugpà yu diyà sa dalesan gemowon yu. Yoko eghalìhalì ya taman endà meuma sa kelegkang yu dema. ");
INSERT INTO mta_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Dodoo amuk tumebow yu diyà sa menuwa endà miadat da keniyu ataw ka meked da dumineg sa igtulù yu, salidi yu iya wé. Amuk sumalid yu dahiya, agtag yu sa kepung diyà sa lisen yu anì tandaan yu sa kepigtamay i Nemula tumebow diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Hê, eg-ipanaw sa medoo salu di, owoy egtegudon da anì ekedan sa medoo etaw sa salà da. ");
INSERT INTO mta_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Egpelesuten da ma sa medoo busaw miglahuk diyà etaw, owoy medoo ma sa etaw eglinadu linulowon da lana owoy nelikuan da dé. ");
INSERT INTO mta_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na, si Datù Hélod sa eg-ipat tanà Galiliya, migdineg denu sa medoo binaelan i Hésus enù ka nekeseluh dé sa lalag di diyà sa langun menuwa. Duen etaw, guwaen da dò kagdi doo kéen si Huwan Tegebautis mig-enaw egoh di nematay. Iya maen di ya dakel gaa sa tunung di egbael panduan. ");
INSERT INTO mta_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Duen ma etaw, guwaen da dò si Iliyas tegesugkow i Nemula egoh anay gaa Hésus i. Owoy duen ma liyu etaw, guwaen da dò sebaen ma tegesugkow i Nemula gaa Hésus i éhê sa medoo tegesugkow di egoh anay. ");
INSERT INTO mta_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dodoo egoh i Datù Hélod migdineg denu sa binaelan i Hésus, guwaen di, “Kagdi doo kéen si Huwan Tegebautis sa tinagpedan ku ulu mig-enaw dema kéen egoh di nematay.” ");
INSERT INTO mta_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Iya sa inikagi i Hélod, enù ka igpeimatay di si Huwan danà di migsigbolow si Hélod, guwaen di, “Migtipay ka dé sa uledin ta danà ko mig-agaw sa sawa hadi ko.” Iya sa kagi i Huwan enù ka sinawa i Hélod sa ibò di, si Hélodiyas, sa tapay sawa i Pilipi hadi di. Huenan di, igsugù i Hélod egpesigkem Huwan i owoy igpebilanggu di ma. ");
INSERT INTO mta_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na, binulitan ma i Hélodiyas Huwan i, owoy ungayà di ipeimatay di, dodoo endà megaga di duu ");
INSERT INTO mta_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","enù ka eg-adatan i Hélod Huwan i enù ka netiigan di si Huwan sa metiengaw etaw sinugù i Nemula. Huenan di, eglanggungan di kagdi. Egkeiyap ma egdinegdineg sa itulù di, dodoo tigtu nebogo sa pedu di egoh di egdineg. ");
INSERT INTO mta_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na, egoh i Hélod egpista sa agdaw di miglesut, igsasà di sa langun ulu-ulu owoy sa langun datù sundalu owoy sa langun kawasà etaw tegeGaliliya. Iya ma sa agdaw di ipeselengan i Hélodiyas sa kepeimatay di si Huwan. ");
INSERT INTO mta_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Agulé, egoh sa kenogon anak i Hélodiyas eg-angay egdelayaw diyà sa kenà da egpista, tigtu neiyap Hélod i owoy sa medoo duma di. Huenan di, guwaen di diyà sa kenogon, “Sumalà dé sa egkeiyapan ko, pegeni ko diyà kenak owoy ibegay ku keniko.” ");
INSERT INTO mta_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Migpengibet diyà sa kenogon, guwaen di, “Sumalà dé sa egpegeniyen ko diyà kenak, apiya baeden ko sa kedatuan ku, ibegay ku doo diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Agulé, mig-angay eg-igsà sa kenogon diyà sa inay di ngadan sa mepion egpegeniyen di. Migsagbì sa inay di, guwaen di, “Pegeni ko sa ulu i Huwan Tegebautis.” ");
INSERT INTO mta_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Agulé, medelamet egpelikù diyà si Datù Hélod, owoy guwaen di, “Ungayà ku ipetagped ko sa ulu i Huwan Tegebautis owoy petoyowi ko diyà sa lampay owoy pedelamet ko peuwiti diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Agulé, tigtu nebukul temù Hélod i, dodoo endà mesangkà di duu enù ka memala amuk endà ipetuu di duu sa igpengibet di dinineg sa langun etaw miglenged pista. ");
INSERT INTO mta_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Huenan di, sinugù di sa sundalu anì angayen di sa ulu i Huwan Tegebautis. Hê, inangay sa sundalu egtagped sa ulu i Huwan dalem sa bilangguwan. ");
INSERT INTO mta_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Inuwit di sa ulu di tinoyo lampay owoy igbegay di diyà sa kenogon, owoy igbegay sa kenogon diyà sa inay di. ");
INSERT INTO mta_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na, egoh sa medoo pasek i Huwan migdineg denu sa kinepatay di, inangay da egkuwa sa lawa di diyà sa bilangguwan owoy iglebeng da. ");
INSERT INTO mta_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na, egoh sa medoo salu i Hésus miglikù, egtulonen da diyà kenagdi sa langun binaelan da owoy sa ketulù da. ");
INSERT INTO mta_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Agulé guwaen i Hésus diyà kenagda, “Mangay ki pelawà lumebù diyà sa kenà di endà duen etaw anì mekeetud ki.” Iya maen di ya enù ka medoo temù sa etaw takà eg-angay diyà si Hésus owoy endà duen sa ulas da apiya di pa egkaen da. ");
INSERT INTO mta_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Agulé, mig-edà da kumpit enù ka mangay da diyà sa kenà da eglebù. ");
INSERT INTO mta_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dodoo hinaa sa medoo etaw sa kelegkang da, owoy egkilalaen da si Hésus sa dalem kumpit. Huenan di, egletu da eghemantad kedu diyà sa medoo menuwa da, owoy nehunawan da Hésus i diyà sa kenà di dumunggù. ");
INSERT INTO mta_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Egoh i Hésus migtenà, hinaa di sa melaweng etaw nesetipon dahiya. Nehiduwan di kagda temù enù ka lagà da sa hinagtay kebilibili melemu metelas amuk endà duen sa eg-ipat kenagda. Huenan di, medoo sa igtulù i Hésus diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Agulé, egoh di mahapun dé, mig-angay sa medoo salu di diyà kenagdi, owoy guwaen da, “Mahapun dé, owoy mediyù dalesan siini kenà ta nesetipon. ");
INSERT INTO mta_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Peangay ko siini medoo etaw diyà sa medoo menuwa owoy sa medoo dalesan nepalak diyà siini dapag ta anì meli da kaenen da.” ");
INSERT INTO mta_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Dodoo guwaen i Hésus, “Kiyu polo sa megay kaenen da.” Agulé guwaen da, “Apiya sa duwa gatus pilak, tapay doo endà mekegaga di ibeli epan amuk ipekaen ta diyà siini medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Guwaen i Hésus, “Angay yu haa pila sa kedoo legà yu.” Egoh da neketiig, guwaen da migsagbì, “Duen legà ké lima getibulu daa epan owoy duwa ma daa tukééy sedà nelegà.” ");
INSERT INTO mta_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Agulé, egseumpungen i Hésus sa medoo etaw owoy egpepenuuwen di kagda diyà sa keluwenluwen. ");
INSERT INTO mta_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Egoh da migpenuu dé, duen lima pulù geetaw ataw ka magatus diyà sa uman sebaen umpungan. ");
INSERT INTO mta_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Agulé, kinuwa i Hésus sa lima getibulu epan owoy sa duwa sedà. Eglengag diyà langit owoy egsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Agulé, kinebéngkebéng di sa epan owoy igbegay di diyà sa medoo salu di anì tinukid da egbegayan sa langun etaw. Hediya ma sa kinebael di sa duwa sedà. ");
INSERT INTO mta_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hê, langun da minekekaen owoy nebesug da ma dé. ");
INSERT INTO mta_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Agulé, tinipoh sa medoo salu di sa sepulù owoy duwa pa gesolok sa samà da egkaen epan owoy sedà. ");
INSERT INTO mta_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na, lima ngibu sa kedoo sa maama migkaen dahiya, liyu sa batà owoy bayi. ");
INSERT INTO mta_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Agulé, pineedà i Hésus sa medoo salu di diyà kumpit anì humuna da mangay dutu menuwa Bétsaida dò tanà dutu sa lanaw, enù ka egpelikuen di pelà sa melaweng etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Agulé, egoh da mig-ipanaw dé, migtekedeg Hésus i eg-angay egsimbà diyà sa mepokò getan. ");
INSERT INTO mta_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Egoh di sumigep dé, neteliwadaan dé diyà lanaw sa kumpit inedaan sa medoo salu di, owoy si Hésus diyà pelawà sa getan kenà di eglebù. ");
INSERT INTO mta_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sinugpayal di sa medoo salu di egkepasangan da eg-owong enù ka egkesungsung da sa meleges kelamag. Agulé egoh di buyu sumimag, mig-angay Hésus i diyà kenagda egbigkat diyà sa kagpaꞌt wayeg. Buyu nehunawan di kagda, ");
INSERT INTO mta_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","dodoo egoh da mighaa kenagdi egbigkat diyà sa kagpaꞌt wayeg, guwaen da dò busaw iya wé hinaa da. Eglesing da ");
INSERT INTO mta_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","enù ka tigtu nelimedangan da langun egoh da mighaa kenagdi. Dodoo mig-ikagi Hésus i diyà kenagda, guwaen di, “Pebagel yu sa pedu yu enù ka aken doo sa hinaa yu. Yoko egkelimedangan na.” ");
INSERT INTO mta_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Agulé, mig-edà Hésus i diyà sa kumpit da, owoy petow dé migsabuh sa kelamag. Tigtu egkegaip da temù ");
INSERT INTO mta_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","enù ka apiya di pa hinaa da sa panduan binaelan di diyà sa lima getibulu epan, endà pa netiigan da duu sa tunung di enù ka metegas pelà sa ulu da. ");
INSERT INTO mta_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na, egoh da migkatin dé tanà dutu sa lanaw, migdunggù da Hésus i diyà sa tanà Génésalét, owoy linabuan da sa kumpit da dahiya. ");
INSERT INTO mta_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Egoh da migtenà dé, mesiyapat kinilala sa medoo etaw dahiya Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huenan di, egletu da tinukid da sa medoo menuwa diyà sa melabel tanà dahiya anì uwiten da sa langun etaw eglinadu, lapeg sa kateli da, diyà si Hésus sumalà dé sa kenà di gaa. ");
INSERT INTO mta_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Sumalà dé sa inangayan i Hésus, iling ka dakel menuwa ataw ka diisek menuwa, eg-uwiten da doo sa medoo eglinadu diyà kenagdi. Igtenà da kagda diyà sa padian owoy migpegeni da diyà kenagdi amuk mebaluy amisen da daa sa pelingping ginis di. Hê, nelikuan dé sa langun etaw nekeamis. ");
INSERT INTO mta_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na sebaen agdaw, duen sa medoo Palasiyu owoy tegetulù uledin igsugkow i Mosis mig-angay da diyà si Hésus kedu diyà Hélusalém. ");
INSERT INTO mta_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Hinaa da sa medoo salu i Hésus migtipay diyà sa adat Palasiyu enù ka endà egpeguséén da duu sa belad da egoh da egkaen. ");
INSERT INTO mta_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Na, sa adat Palasiyu owoy sa medoo duma da Hudiyu, endà kumaen da amuk endà muna da egpegusê sa belad da, enù ka iya sa adat igtulù sa medoo tupù da egoh anay. ");
INSERT INTO mta_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hediya ma, amuk eglikù da kedu diyà padian, endà pa kumaen da taman endà pelanihen da sa lawa da. Owoy medoo ma sa adat eg-unutan da denu sa kepegusê da tabù ataw ka kuden ataw ka bilu galang. ");
INSERT INTO mta_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Huenan di, egsigbolow sa medoo Palasiyu owoy tegetulù uledin, guwaen da diyà si Hésus, “Maen di ya endà eg-iling sa medoo pasek ko sa adat sa tupù ta? Enù ka endà egpegusê da belad egoh da egkaen.” ");
INSERT INTO mta_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Migsagbì Hésus i, guwaen di, “Neakalan yu kiyu i, enù ka guwaen yu dò metiengaw etaw yu. Tigtu tuu sa kagi i Nemula igsulat i Isayas sa tegesugkow di egoh anay denu keniyu, guwaen di, ‘Siini medoo etaw, ebà daa sa ig-adat da kenak, dodoo endà egpigtuu sa pedu da diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Huenan di, endà duen sa untung sa kesimbà da diyà kenak, enù ka beken kedu kenak sa uledin igtulù da, dodoo danà sa penemdem etaw daa sa itulù da.’ ");
INSERT INTO mta_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Hediya ma kiyu i, enù ka inekedan yu dé sa uledin i Nemula, enù ka iya daa sa eg-unutan yu sa adat igtulù etaw.” ");
INSERT INTO mta_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Guwaen i Hésus, “Tigtu netiigan yu doo sa ukit yu eg-eked sa uledin i Nemula, enù ka takà yu polo egpangunut diyà sa niyu adat. ");
INSERT INTO mta_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Netiigan ta iya wé enù ka igsugkow i Mosis sa uledin i Nemula egoh anay, guwaen di, ‘Adati yu sa emà yu owoy sa inay yu.’ Owoy tinulon di ma, ‘Meimatayan sa etaw egpeumàumà sa emà di ataw ka sa inay di.’ ");
INSERT INTO mta_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Dodoo kiyu, igtulù yu polo mepion amuk endà tabangan sa etaw sa emà di owoy sa inay di amuk guwaen di diyà kenagda, ‘Ingadanan ku kulban ini i itabang ku keniyu hedem, enù ka igbegay ku dé diyà si Nemula.’ ");
INSERT INTO mta_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Huenan di, eg-alang yu sa etaw anì endà metabangan di duu sa emà di owoy sa inay di. ");
INSERT INTO mta_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Danà yu egtulù siini adat yu kedu sa tupù yu, eg-iniyugan yu dé sa kagi i Nemula denu sa keadat etaw sa lukes di. Na, duen ma sa medoo liyu egbaelan yu éhê mendaa iya wé.” ");
INSERT INTO mta_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Agulé, inumow i Hésus dema sa medoo etaw anì pedapag da diyà kenagdi. Guwaen di diyà kenagda, “Dinegdineg yu sa itulù ku anì metiigan yu. ");
INSERT INTO mta_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Endà mesalà sa etaw danà sa kaenen igsungit di diyà sa ebà di, dodoo nesalà polo sa etaw danà sa medaet eglegkang diyà sa pedu di. ");
INSERT INTO mta_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Amuk mipedu yu egdineg, penemdem yu, hih, sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Agulé, migsalid Hésus i diyà sa medoo etaw, owoy eg-angay eggemow diyà sa dalesan. Eg-igsaen sa medoo salu di sa selepangan sa peligad di. ");
INSERT INTO mta_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Agulé guwaen i Hésus, “Negaip a enù ka lagà yu sa medoo liyu etaw endà egpeketiig. Sumalà dé sa kaenen igsungit etaw diyà sa ebà di, endà mesalà di dahiya, ");
INSERT INTO mta_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","enù ka egdalem daa diyà sa getek di, agulé eglesut dema diyà sa lawa di. Endà eg-ukit di diyà sa pedu di.” Na, danà iya wé inikagi i Hésus, netiigan ta mebaluy kaenen ta sa langun balangan kaenen. ");
INSERT INTO mta_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Agulé, eg-uman Hésus i eg-ikagi, guwaen di, “Nesalà polo sa etaw danà sa medaet eglegkang diyà sa pedu di. ");
INSERT INTO mta_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Enù ka sa pedu di sa linegkangan sa medaet penemdem di, owoy sa keseuma da lawa sa etaw beken sawa di, owoy sa kepenakaw di owoy sa keimatay di etaw, owoy sa kebigà di, ");
INSERT INTO mta_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","owoy sa kebig-ima di, owoy sa langun egbaelan di medaet, owoy sa keakal di, owoy sa endà kebigmala di egbigà, owoy sa kebigsina di, owoy sa kesumbung di, owoy sa kepeolòolò di, owoy sa kepengahàngahà di. ");
INSERT INTO mta_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Eglegkang diyà sa pedu di siini medoo egbaelan di medaet, owoy iya sa pesuwan di nesalà.” ");
INSERT INTO mta_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Agulé, miglegkang Hésus i dahiya owoy eg-angay diyà sa uwang tanà menuwa Tilo. Egoh di migtebow dahiya, miggemow diyà sa dalesan. Apiya di pa sa ungayà di endà duen etaw meketiig sa kenà di, endà doo mekebaluy di lumidung. ");
INSERT INTO mta_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na, duen sa bayi épê anak bayi linahuk busaw. Egoh di migdineg sa kinetebow i Hésus, medelamet eg-angay diyà kenagdi owoy egligkued diyà sa taengan di, ");
INSERT INTO mta_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","enù ka egpegeni anì pelesuten di sa busaw miglahuk diyà sa anak di. Beken etaw Hudiyu siini bayi, dodoo etaw Ponisiya polo kedu tanà Siliya dò. ");
INSERT INTO mta_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Agulé migsagbì Hésus i peligad, guwaen di, “Muna pelawà pekaenen ta sa medoo batà, enù ka endà mepion di amuk pekawen ta sa kaenen batà anì ibegay ta diyà sa medoo tuyang.” ");
INSERT INTO mta_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Dodoo migsagbì sa bayi, guwaen di, “O Datù, tuu iya wé inikagi ko, dodoo mebaluy doo kumaen sa medoo tuyang leketanà sa lamisan amuk duen kaenen batà nelemet.” ");
INSERT INTO mta_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Agulé guwaen i Hésus, “Danà iya wé inikagi ko, mebaluy lumikù ka dé enù ka miglesut dé sa busaw diyà sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hê, egoh di miglikù, hinaa di sa anak di eghibat owoy endà dé duen busaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na, egoh i Hésus egpelikù kedu diyà sa uwang menuwa Tilo, mig-ukit diyà sa menuwa Sidon owoy sa uwang menuwa Dikapolis, owoy eglagbas diyà sa Lanaw Galiliya. ");
INSERT INTO mta_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Agulé, duen sa maama nebuneg owoy bisuwen inuwit etaw diyà kenagdi. Egpegeni da anì sabaan di sa maama anì melikuan. ");
INSERT INTO mta_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Agulé, inuwit i Hésus sa maama egtangkà diyà sa medoo etaw. Kinesek di sa tosong telinga sa bisuwen, owoy tineptepan di sa ketudù di owoy igdulét di diyà sa dilà sa maama. ");
INSERT INTO mta_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Agulé, eglengag diyà langit owoy egsugnu owoy eg-ikagi, guwaen di diyà sa hagdi kagi, “Ipata.” Na, iya sa selepangan sa inikagi di, “Meukaan dé.” ");
INSERT INTO mta_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hê, petow dé egpekedineg sa maama, owoy nekedan dé sa kebegat dilà di owoy egpekeikagi ma dé metudà. ");
INSERT INTO mta_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Agulé, sinasà i Hésus sa medoo etaw dahiya anì endà tulonen da duu diyà sa medoo liyu etaw sa hinaa da binaelan di. Dodoo, lemban polo tinulon da sa hinaa da, apiya di pa hinawidan di kagda. ");
INSERT INTO mta_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Egkegaip temù sa langun etaw, owoy guwaen da, “Tigtu mepion sa langun binaelan di, enù ka egpedinegen di sa etaw bisuwen owoy egpeikagiyen di sa etaw buneg.” ");
INSERT INTO mta_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na sebaen agdaw, tigtu medoo dema sa etaw nesetipon diyà si Hésus. Egoh di neimet dé sa legà da, sinetipon i Hésus sa medoo salu di owoy guwaen di diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Egkehiduwan ku siini medoo etaw dahini, enù ka telu agdaw dé sa lugay da eg-unut-unut diyà kenak owoy neimet dé sa kaenen da. ");
INSERT INTO mta_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amuk pelikuen ku kagda egoh da egpeketues, kumelenek da mipanaw enù ka mediyù sa keduwan sa medoo duma da.” ");
INSERT INTO mta_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Guwaen sa medoo salu di, “Ngadan sa kenà ta kumuwa kaenen diyà siini melabel tanà mediyù dalesan anì pekaenen ta siini medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mig-igsà Hésus i, guwaen di, “Pila sa kedoo epan diyà keniyu?” Migsagbì da, guwaen da, “Pitu daa getibulu.” ");
INSERT INTO mta_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Agulé, pinepenuu i Hésus sa medoo etaw diyà tanà. Kinuwa di sa pitu getibulu epan, owoy egsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Kinebéngkebéng di owoy igbegay di diyà sa medoo salu di, owoy tinukid da egbegay sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Duen ma dahiya sa tukééy sedà anan diisek. Agulé, egoh i Hésus migsimbà migpesalamat diyà si Nemula danà sa tukééy sedà, igsugù di ma diyà sa medoo salu di anì itukid da ma ibegay diyà sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Hê, nekekaen sa langun etaw dahiya owoy nebesug da dé. Agulé, tinipoh sa medoo salu di sa nesamà da egkaen pitu pa gesolok. ");
INSERT INTO mta_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na, duen kéen epat ngibu geetaw migkaen dahiya. ");
INSERT INTO mta_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Egoh da neubus egkaen, egpelikuen i Hésus kagda. Agulé mig-edà kumpit dema Hésus i owoy sa medoo salu di enù ka mangay da dutu uwang Dalmanuta dò. ");
INSERT INTO mta_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na, duen Palasiyu eg-angayen da egsigbolow Hésus i. Ungayà da tepengan da kagdi, huenan di, mig-igsà da panduan diyà kenagdi anì metiigan da amuk tuu kagdi sa pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Dodoo egsugnu Hésus i danà sa pedu di nedaetan, owoy guwaen di, “Kiyu i medoo duma ku Hudiyu, maen di ya endà egpigtuu yu diyà kenak amuk endà duen panduan mehaa yu? Tuu ini i eg-ikagiyen ku diyà keniyu, endà duen panduan ipehaa i Nemula diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Agulé, sinalidan i Hésus dé kagda owoy mig-edà kumpit anì mangay tanà dutu sa lanaw. ");
INSERT INTO mta_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, nelipengan sa medoo salu i Hésus eg-uwit sa medoo legà da, dodoo duen segetibulu daa epan dalem sa kumpit da. ");
INSERT INTO mta_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Agulé migpeligad Hésus i diyà kenagda, guwaen di, “Tulik yu, hih, anì mekeiwod yu sa ipelenuk epan sa medoo etaw Palasiyu owoy etaw i Datù Hélod.” ");
INSERT INTO mta_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dodoo sa medoo salu di, endà netiigan da duu sa peligad tinulon i Hésus, huenan di egseolomoy da, guwaen da, “Iya sa inikagi di enù ka endà duen epan inuwit ta.” ");
INSERT INTO mta_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Dodoo netiigan i Hésus sa eg-ikagiyen da, owoy guwaen di, “Maen di ya egseolomen yu sa egoh yu endà mig-uwit epan? Maen di ya endà pa egpeketiig yu sa egkegaga ku? Maen di ya metegas pelà sa ulu yu? ");
INSERT INTO mta_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Duen mata yu, dodoo lagà endà eghaa yu. Duen telinga yu, dodoo lagà endà egpekedineg yu. Nelipengan yu kéen sa binaelan ku egoh ku migpekaen sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pila pa atu kedoo sa solok pinenù yu sa samà ta migkaen egoh ku migkebéngkebéng sa lima getibulu epan igpekaen ta diyà sa lima ngibu etaw?” Guwaen da egsagbì, “Sepulù owoy duwa pa gesolok.” ");
INSERT INTO mta_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Agulé guwaen i Hésus, “Egoh sa pitu getibulu epan sa igpekaen ta diyà sa epat ngibu etaw, pila pa atu kedoo sa solok pinenù yu sa samà ta migkaen?” Guwaen da, “Pitu gesolok pa.” ");
INSERT INTO mta_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Agulé guwaen i Hésus, “Huenan di, negaip a keniyu, enù ka endà pa egketiigan yu duu sa inikagi ku giina.” ");
INSERT INTO mta_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na, migtebow da Hésus i diyà sa menuwa Bétsaida. Duen sa maama langap inuwit etaw diyà kenagdi, owoy egpegeni da anì amisen di anì umilag. ");
INSERT INTO mta_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Agulé, inagak i Hésus sa langap migliyu da diyà sa menuwa. Egoh di migdulét ngingi di diyà mata sa langap, egsabaan di owoy eg-igsaan di, guwaen di, “Duen pa sa eghauwen ko?” ");
INSERT INTO mta_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eglangalanga sa maama owoy guwaen di, “Eghauwen ku sa medoo etaw egbigkatbigkat, dodoo lagà kayu pelawà sa palas da.” ");
INSERT INTO mta_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Agulé, eg-amisen i Hésus dema sa mata di. Hê, egoh di eglangalanga dema, tigtu metiengaw dé sa kehaa di enù ka mig-ilag dé sa mata di. ");
INSERT INTO mta_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Agulé egpelikuen i Hésus, owoy guwaen di, “Yaka dé eg-ukit ta diyà sa menuwa.” ");
INSERT INTO mta_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na, eglagbas Hésus i owoy sa medoo salu di eg-angay diyà sa uwang tanà menuwa Sisaliya Pilipos. Egoh da pelà diyà dalan, mig-igsà Hésus i diyà kenagda, guwaen di, “Ngadan di etaw a gaa guwaen sa medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Egsagbì da, guwaen da, “Duen etaw guwaen da dò si Huwan Tegebautis ka gaa, owoy duen ma etaw guwaen da dò si Iliyas ka gaa ataw ka sa sebaen ma tegesugkow i Nemula egoh anay kuna i.” ");
INSERT INTO mta_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Agulé guwaen i Hésus, “Enù di ya kiyu i, ngadan sa kagi yu denu kenak?” Migsagbì Pidelu i, guwaen di, “Kuna si Mésayas sa Tigtu Datù sinugù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Agulé, hinawidan i Hésus kagda anì endà tulonen da duu diyà etaw. ");
INSERT INTO mta_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Agulé, mig-edung Hésus i egtulù diyà sa medoo salu di denu sa ketamanan di, guwaen di, “Medoo sa kelikutan mekeuma diyà kenak, aken i Kakay Langun. Meekedan a sa medoo kaunutan ta etaw Hudiyu owoy sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Imatayan da aken dodoo umenaw a mendaa diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tigtu sinelepang di diyà kenagda denu sa mebaelan di. Agulé inuwit i Pidelu Hésus i egtangkà owoy hinawidan di anì endà meketuu iya wé inikagi di. ");
INSERT INTO mta_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Dodoo migpelikù eg-isalu Hésus i anì eghahauwen di sa medoo salu di. Sinigbolow di Pidelu i, guwaen di, “Yaka egdahiya ya. Lagà ka si Satanas, enù ka beken kedu si Nemula iya wé ungayà ko, dodoo kedu diyà etaw daa.” ");
INSERT INTO mta_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Agulé, sinetipon i Hésus sa medoo salu di owoy sa medoo liyu etaw. Guwaen di diyà kenagda, “Amuk iya sa pedu sebaen etaw umunut-unut diyà kenak, meekedan di sa hagdi ungayà owoy sakemen di sa naken. Lagà metiang di ma sa bugsud kenà di mematay enù ka metigkelan di sa kelikutan di danà di egpangunut diyà sa igsugù ku. Owoy tigtu mekeunut-unut ma diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Huenan di, sumalà dé sa etaw umeked umunut diyà kenak enù ka egpekihagtay, iya polo sa etaw mematay. Dodoo sumalà dé sa etaw umeked pekihagtay anì umunut-unut diyà kenak anì tumulù sa Mepion Tegudon, iya polo sa etaw kumelalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Amuk hediya, endà duen sa tigtu untung mekuwa etaw diyà sa medoo langun taman di diyà tanà. Apiya di pa mekuwa di sa langun, mekesugsug doo ");
INSERT INTO mta_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","enù ka endà duen sa mekesambì di anì melalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ini egoh di eg-iniyugan sa medoo etaw tegebael salà Nemula i. Sumalà dé sa etaw eg-eked egtulon denu kenak owoy endà ma egpigtuu di sa kagi ku danà di memala, iya ma sa etaw endà meingadanan ku duu amuk pelikù a, aken i Kakay Langun. Amuk pelikù a, unutan a sa medoo egsugùsuguen ku metiengaw owoy sumenang a ma danà sa senang i Emà ku.” ");
INSERT INTO mta_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Duen duma etaw dahini ini egoh di endà pa mematay da taman endà hauwen da duu sa egoh di mekeuma sa kedatù i Nemula épê dakel egkegaga.” ");
INSERT INTO mta_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na, egoh di neuma enem agdaw, inuwit i Hésus Pidelu i owoy si Santiyago owoy si Huwan, owoy egtekedeg da diyà sa mehagtaw getan kenà da eglebù. Hê, egoh da eghahaa si Hésus, nepelumanan sa palas di. ");
INSERT INTO mta_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Migkebulà temù sa ginis di owoy egsenang ma. Endà duen nekelowon sa kebulà di diyà siini tanà. ");
INSERT INTO mta_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Agulé, hinaa da ma dahiya Iliyas i owoy si Mosis egseolomoy da si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Agulé, eg-ikagi Pidelu i diyà si Hésus, guwaen di, “O Mistelu, mepion doo enù ka dahini ké. Mael ké lawì, telu, sebaen niko, sebaen si Mosis, sebaen si Iliyas.” ");
INSERT INTO mta_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dodoo, nekeamu eg-ikagi Pidelu i danà da tigtu nelimedangan. ");
INSERT INTO mta_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Agulé, tinenaan da gaeb, owoy duen eg-ikagi kedu dalem sa gaeb, guwaen di, “Ini sa anak ku eghiduwan ku. Dinegdineg yu dé diyà kagdi.” ");
INSERT INTO mta_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hê, eglangalanga da, dodoo endà duen etaw eghauwen da liyu daa si Hésus sa tapay duma da. ");
INSERT INTO mta_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na, egoh da eglungel kedu diyà sa getan, hinawidan i Hésus kagda, guwaen di, “Yoko egtulon duu diyà etaw sa hinaa yu taman endà meenaw sa Kakay Langun egoh di mematay.” ");
INSERT INTO mta_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Agulé tinuu da iya wé inikagi di, dodoo takà da egseolomoy denu sa selepangan sa inikagi di umenaw gaa amuk mematay. ");
INSERT INTO mta_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Agulé eg-igsaan da Hésus i, guwaen da, “Maen di ya atu inikagi sa medoo tegetulù uledin igsugkow i Mosis, muna gaa Iliyas i tumebow diyà sa ketebow sa Tigtu Datù sinugù i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Migsagbì Hésus i, guwaen di, “Tuu ini i. Muna Iliyas i tumebow anì abungan di sa ukitan i Datù tumebow. Dodoo iya ma sa kagi i Nemula igpesulat denu kenak, tigtu mepelihay a owoy meekedan a ma, aken i Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Taa yu ini i eg-ikagiyen ku diyà keniyu. Migtebow dé Iliyas i, dodoo pinelihay da polo danà sa hagda ungayà, enù ka neketuu sa kagi i Nemula igpesulat egoh anay denu kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na, egoh da i Hésus migtebow diyà sa medoo duma salu di, hinaa da sa melaweng etaw nesetipon diyà kenagda, owoy egsigbolow ma sa medoo tegetulù uledin igsugkow i Mosis diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Egoh sa medoo etaw mighaa si Hésus, tigtu da nepetow. Hê, egletu da egtelabuk kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Agulé eg-igsà Hésus i, guwaen di, “Ngadan sa egseolomen yu diyà kenagda?” ");
INSERT INTO mta_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Migsagbì sa sebaen etaw, guwaen di, “O Mistelu, inuwit ku sa anak ku diyà keniko, enù ka nebuneg danà di linahuk busaw. ");
INSERT INTO mta_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Egkepasangan temù enù ka uman sumabà sa busaw, idagsà di dema diyà tanà owoy egbohok ma sa ebà di, owoy egkéget ma sa ngipen di owoy egkegkeg ma sa langun lawa di. Migpegeni a diyà sa medoo salu ko anì pelaunen da sa busaw, dodoo endà megaga da duu.” ");
INSERT INTO mta_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Agulé eg-ikagi Hésus i, guwaen di, “Ay, kiyu i medoo etaw ini egoh di, tigtu yu endà egsalig diyà kenak. Huenan di, egkesemek a dé eg-ugpà diyà keniyu, owoy buyu a dé egtalawen danà sa endà kepigtuu yu. Na, uwit ko dé dini sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Agulé, inuwit da sa batà diyà si Hésus. Hê, egoh sa busaw eghaa si Hésus, egpetiglongenen di sa batà owoy igdagsà di diyà tanà. Egkelidkelid owoy egbohok sa ebà di. ");
INSERT INTO mta_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Agulé inigsaan i Hésus sa emà di, guwaen di, “Pila dé agdaw sa lugay di anan éhê iya?” Migsagbì sa emà di, guwaen di, “Edung dé sa egoh di tukééy pelà. ");
INSERT INTO mta_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Owoy egsabaan sa busaw takà anì imatayan di hedem, enù ka takà di igsunù diyà sa apuy owoy diyà wayeg. Dodoo amuk megaga ko, hiduwi ko kami owoy pelaun ko sa busaw diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Guwaen i Hésus, “Maen di ya egkeduwa sa pedu ko denu sa egkegaga ku? Amuk egpigtuu ka daa diyà si Nemula, mebegayan ka doo sa langun egpegeniyen ko.” ");
INSERT INTO mta_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Agulé, pinetaled sa emà di sa kagi di, guwaen di, “Egpigtuu a doo, dodoo kulang pa sa kepigtuu ku. Huenan di, umani ko polo sa kepigtuu ku.” ");
INSERT INTO mta_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na, egoh i Hésus mighaa sa medoo etaw egkesetipon diyà kenagdi, hinemagawan di sa busaw. Guwaen di, “Kuna i busaw egpebisu etaw owoy egpebuneg, laun ka dé diyà sa batà, owoy yaka dé egpelikù ya diyà kagdi.” ");
INSERT INTO mta_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Agulé, eglesing owoy egpelukuben di temù sa batà. Hê, miglaun dé diyà kenagdi. Agulé, lagà dé nematay sa batà enù ka endà nekelanuhen di, huenan di duen etaw guwaen da dò nematay dé. ");
INSERT INTO mta_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Dodoo sinabaan i Hésus belad sa batà anì petigdegen di. Hê, neketigdeg dé. ");
INSERT INTO mta_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Na, egoh da i Hésus miglikù diyà sa dalesan da, eg-igsà sa medoo salu di egoh da eglebù, guwaen da, “Maen di ya endà negaga ké duu eghemaga sa busaw diyà sa batà?” ");
INSERT INTO mta_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Migsagbì Hésus i, guwaen di, “Siini balangan busaw, endà mehemagawan da amuk endà tigtu yu sumimbà diyà si Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na, miglegkang da Hésus i dahiya owoy eg-ukit da diyà sa tanà Galiliya. Endà egkeiyap di amuk metiigan medoo etaw sa kenà di, ");
INSERT INTO mta_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","enù ka ungayà di temuen di tumulù sa medoo salu di. Guwaen di diyà kenagda, “Aken i Kakay Langun, buyu a dé mekebegay diyà sa medoo liyu etaw anì imatayan da aken. Dodoo amuk meimatayan a dé, meenaw a mendaa diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dodoo endà netiigan da duu sa selepangan iya wé inikagi di, dodoo egkelenawan da ma eg-igsà diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na, egoh da migtebow diyà sa menuwa Kapelenaum, miggemow da diyà sa dalesan, owoy eg-igsaan i Hésus sa medoo salu di, guwaen di, “Ngadan sa egsesigbolowen yu egoh ta diyà dalan?” ");
INSERT INTO mta_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Dodoo endà egsagbì da enù ka egkemalaan da danà da egkesesigbolow tayu sa dakel etaw diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Agulé migpenuu Hésus i, owoy sinetipon di sa sepulù owoy duwa salu di diyà kenagdi, guwaen di, “Amuk duen etaw diyà keniyu ungayà di pedakelen di kagdi, petukééyen di polo kagdi lagà sa egsugùsuguen yu.” ");
INSERT INTO mta_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Agulé, kinuwa i Hésus sa batà, owoy pinetigdeg di diyà sa taengan sa medoo salu di. Egsekepuwen di, owoy guwaen di, ");
INSERT INTO mta_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Sumalà dé sa etaw miadat sa etaw ku éhê siini batà danà di etaw ku, meadatan di ma aken danà iya wé egbaelan di. Owoy sumalà dé sa etaw miadat kenak, meadatan di ma sa migpeangay kenak diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na, eg-ikagi Huwan i diyà si Hésus, guwaen di, “O Mistelu, hinaa ké sa sebaen maama egpelesut busaw danà sa ngadan ko. Hinawidan ké, enù ka endà eg-unut-unut di diyà kenita.” ");
INSERT INTO mta_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Dodoo guwaen i Hésus, “Yoko eghawid duu, enù ka amuk duen etaw egpekebael panduan danà sa ngadan ku, endà medelamet di sumumbung kenak. ");
INSERT INTO mta_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Enù ka sumalà dé sa etaw endà egkuntelà di kenita, iya polo sa etaw tumabang kenita. ");
INSERT INTO mta_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk duen etaw egbegay wayeg diyà keniyu anì mekeinem yu danà di kiyu sa etaw ku, duen doo sa untung mesakem di diyà si Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Agulé guwaen i Hésus, “Amuk duen sa etaw eg-enggat diyà salà sa etaw ku egpigtuu éhê siini batà, iya sa etaw tigtu mepigtamayan i Nemula. Adi-adi pa amuk tagkesan dakel batu diyà sa lieg di owoy mekebuung diyà dagat. ");
INSERT INTO mta_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Huenan di, amuk meenggat yu diyà salà danà sa belad yu, tagped yu owoy buungi yu ma dé, enù ka uman pa mepion sa egoh yu melalù taman melugay apiya di pa neputuk sa belad yu diyà sa egoh yu épê duwa belad mekeangay diyà sa lanaw apuy endà mepadeng. ");
INSERT INTO mta_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Na, endà dé mematay sa medoo sapat egkaen kenagda dutu lanaw apuy dò, owoy endà ma mepadeng sa apuy mekedaig kenagda dutu. ");
INSERT INTO mta_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hediya ma, amuk meenggat yu diyà salà danà sa lisen yu, tagped yu owoy buungi yu ma dé, enù ka uman pa mepion sa egoh yu melalù taman melugay apiya di pa neputuk sa sebaen lisen yu diyà sa egoh yu épê duwa lisen mekeangay diyà sa lanaw apuy. ");
INSERT INTO mta_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na, endà dé mematay sa medoo sapat egkaen kenagda dutu lanaw apuy dò, owoy endà ma mepadeng sa apuy mekedaig kenagda dutu. ");
INSERT INTO mta_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hediya ma, amuk meenggat yu diyà salà danà sa dibaluy mata yu, lesò yu dé, enù ka uman pa mepion sa egoh yu mekeunut diyà sa kedatù i Nemula apiya di pa sebaen daa sa mata yu diyà sa egoh yu épê duwa mata mekeangay diyà sa lanaw apuy. ");
INSERT INTO mta_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na, endà dé mematay sa medoo sapat egkaen kenagda dutu lanaw apuy dò owoy endà ma mepadeng sa apuy mekedaig kenagda dutu.” ");
INSERT INTO mta_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Agulé, egtulon peligad Hésus i, guwaen di, “Lagà timus owoy apuy sa kelikutan meukitan sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na, mepion doo sa timus, dodoo amuk mekedan sa keemis di, endà dé mebaluy di itimus. Huenan di, udes yu bael sa mepion anì meilingan yu duu sa timus endà mekedan sa keemis di anì kumelanih ma sa keugpà yu langun.” ");
INSERT INTO mta_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Agulé, miglegkang Hésus i diyà sa menuwa Kapelenaum owoy egbatas sa lawa Holdan eg-angay dutu uwang Hudiya dò. Agulé medoo temù sa etaw egkesetipon diyà kenagdi, owoy egtuluen di dema kagda enù ka iya sa adat di. ");
INSERT INTO mta_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na, duen ma etaw Palasiyu mig-angay da diyà si Hésus enù ka eglagbeten da sa ukit ketipu da kenagdi amuk meamu sa sagbì di. Eg-igsaan da, guwaen da, “Enù di ya, meketipay pa sa etaw diyà sa uledin ta amuk ekedan di sa sawa di?” ");
INSERT INTO mta_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Agulé egsulì eg-igsà Hésus i, guwaen di, “Ngadan sa igsugù i Mosis egoh anay denu sa keeked etaw sawa di?” ");
INSERT INTO mta_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Migsagbì da, guwaen da, “Igtulù i Mosis mebaluy doo amuk duen sa isulat igbegay sa maama diyà sa sawa di anì tandaan di sa keeked di egoh di eghemaga kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Dodoo guwaen i Hésus, “Iya sa igtulù i Mosis mebaluy ekedan yu sa sawa yu enù ka netiigan di metegas sa ulu yu egtuluen. ");
INSERT INTO mta_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dodoo, egoh anay egoh i Nemula migbael sa langun taman, binaelan di sa sebaen maama owoy sa sebaen bayi. ");
INSERT INTO mta_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Iya maen di ya mesalidan sa maama sa emà di owoy sa inay di owoy mekeugpà ma dé diyà sa sawa di ");
INSERT INTO mta_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","enù ka lagà sebaen etaw da daa.’ Endà dé duwa sa etaw telesawa, dodoo nesesebaen da polo. ");
INSERT INTO mta_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Huenan di, endà mepion di amuk mesepalak sa etaw telesawa, enù ka nesesebaen da dé danà i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Na, egoh da i Hésus miggemow diyà sa dalesan, eg-igsà sa medoo salu di denu sa keeked etaw sawa di. ");
INSERT INTO mta_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Agulé, guwaen i Hésus diyà kenagda, “Amuk eg-ekedan sa maama sa sawa di, egbigà doo amuk sawaen di sa liyu bayi. ");
INSERT INTO mta_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hediya ma sa bayi, egbigà ma doo amuk eg-ekedan di sa sawa di owoy sawaen di sa liyu maama.” ");
INSERT INTO mta_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na, duen medoo etaw eg-uwit anak da diyà si Hésus anì sabaan di kagda anì isimbà di. Dodoo eghawidan sa medoo salu di kagda. ");
INSERT INTO mta_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Egoh i Hésus mighaa iya wé, egbulit owoy guwaen di diyà kenagda, “Pandayà yu dé sa medoo batà umangay diyà kenak. Yoko eghawid duu, enù ka iya sa etaw mekeunut diyà sa kedatù i Nemula sa medoo etaw egpekeiling pedu batà. ");
INSERT INTO mta_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa etaw endà egpekeiling di pedu batà sa kepigtuu di diyà si Nemula, iya sa etaw endà mekeunut di diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Agulé, tinukid di kagda eghimu, owoy egsabaan di sa ulu da owoy isimbà di kagda. ");
INSERT INTO mta_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na, egoh i Hésus eg-ipanaw dema, duen sa maama egletu eg-angay diyà kenagdi owoy egligkued diyà sa taengan di. Eg-igsà, guwaen di, “O Mistelu, tigtu mepion ka etaw, ngadan sa baelan ku anì mekesakem a sa lalù endà meelut di?” ");
INSERT INTO mta_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Agulé guwaen i Hésus, “Maen di ya eg-ikagiyen ko aken mepion a etaw? Endà duen mepion etaw liyu daa si Nemula. ");
INSERT INTO mta_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Neketiig ka doo sa medoo uledin igsugkow i Mosis, guwaen di, ‘Yoko eg-imatay ya etaw, owoy yoko egbigà ya, owoy yoko egpenakaw wa, owoy yoko egbutbut ta egtipu sa duma yu, owoy yoko eglapis duu sa etaw, owoy adati yu sa emà yu owoy sa inay yu.’ ” ");
INSERT INTO mta_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Agulé guwaen sa maama, “O Mistelu, langun siini uledin di anan egpangunutan ku edung egoh ku batà pelawà.” ");
INSERT INTO mta_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eg-inengtengen i Hésus kagdi enù ka eghiduwan di, owoy guwaen di, “Kulang pa sebaen sa egbaelan ko. Angay ko dagang sa langun taman ko owoy tukidi ko begayi diyà sa medoo etaw pubeli. Amuk hediya, dumuen sa pantiyali ko diyà langit. Agulé angay ka dini unut-unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Na, egoh di migdineg iya wé, sinalidan di Hésus i owoy nebenges temù sa pedu di enù ka tigtu kawasà. ");
INSERT INTO mta_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Agulé, eg-inengtengen i Hésus sa medoo salu di, owoy guwaen di, “Tigtu melikut temù sa medoo kawasà etaw mekeunut sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dodoo egkegaip sa medoo salu di danà iya wé inikagi di. Agulé eg-uman Hésus i eg-ikagi, guwaen di, “O medoo batà ku, tigtu melikut sa medoo etaw mekeunut diyà sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Uman pa melemu sa hinagtay kamiliyu eg-ukit diyà sa tosong dagum diyà sa kawasà etaw mekeunut diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Egoh sa medoo salu di migdineg iya wé, tigtu da negaip owoy egseolomoy da, guwaen da, “Amuk hediya, endà duen etaw kéen mealukan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Dodoo eg-inengtengen i Hésus kagda, owoy guwaen di, “Tuu ma doo, endà mebaluy di amuk etaw daa, dodoo mebaluy amuk si Nemula enù ka megaga di doo sa langun egbaelan.” ");
INSERT INTO mta_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Agulé guwaen i Pidelu, “Taa ko. Sinalidan ké dé sa langun taman ké enù ka eg-unut-unut ké keniko. Enù di ya kami i, ngadan sa mehaa ké?” ");
INSERT INTO mta_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Guwaen i Hésus diyà kenagda, “Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa etaw sinalidan di sa dalesan di ataw ka sa kakay di owoy sa hadi di, ataw ka sa emà di owoy sa inay di, ataw ka sa medoo anak di, ataw ka sa tanà di danà di eg-unut-unut diyà kenak anì egtulù sa Mepion Tegudon, ");
INSERT INTO mta_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","meumanan pa magatus gulê sa mesakem di diyà sa sinalidan di. Apiya di pa egkepelihay diyà tanà, mebegayan doo dalesan owoy hadi di owoy tebay di owoy inay di owoy anak di owoy tanà di, owoy dumuen ma sa lalù di endà meelut di amuk sambian i Nemula siini tanà. ");
INSERT INTO mta_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dodoo sa medoo etaw dakel diyà sa kehaa yu ini egoh di, kumetukééy da polo kani. Owoy sa medoo etaw tukééy diyà sa kehaa yu ini egoh di, pedakelen i Nemula polo kagda.” ");
INSERT INTO mta_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, egtekedeg Hésus i owoy sa medoo salu di eg-angay Hélusalém dò. Muna Hésus i, egsetugdugen sa medoo salu di. Tigtu egkegaip da enù ka Hélusalém sa angayan di sa kenà etaw egkelukuy eg-imatay kenagdi, owoy nelimedangan ma sa medoo liyu etaw eg-unut-unut diyà kenagda. Agulé, egtiponen i Hésus sa sepulù owoy duwa salu di anì tulonen di sa mebaelan di dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Guwaen di, “Taa yu, hih, mangay ki Hélusalém dò. Amuk tumebow ki dutu, mekebegay sa Kakay Langun diyà sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Mesesebaen sa penemdem da meimatayan a, huenan di ibegay da aken diyà sa medoo etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Peumàumaan da aken, owoy teptepan a, owoy tapesen a owoy imatayan da ma aken. Dodoo amuk meuma sa ketelu di agdaw, meenaw a doo.” ");
INSERT INTO mta_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Agulé, mig-angay diyà si Hésus Santiyago i owoy si Huwan, sa duwa anak i Sébediyu. Guwaen da, “O Mistelu, ungayà ké baelan ko sa egpegeniyen ké diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eg-igsà Hésus i, guwaen di, “Ngadan sa egpegeniyen yu baelan ku?” ");
INSERT INTO mta_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Egsagbì da, guwaen da, “Amuk meuma sa egoh ko kumedatù kani, pepenuu ko ma kami anì mekeunut ké kumedatù, sebaen denu kuwanan ko owoy sebaen denu bibang ko.” ");
INSERT INTO mta_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Dodoo guwaen i Hésus diyà kenagda, “Endà netiigan yu duu sa kebegat sa egpegeniyen yu diyà kenak. Enù di ya, megaga yu pa tumigkel sa kelikutan meukitan ku? Metigkelan yu pa sa dakel lihay peukiten i Nemula diyà kenak?” ");
INSERT INTO mta_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Hoò,” guwaen da, “metigkelan ké doo.” Agulé guwaen i Hésus, “Tuu ini i. Meukitan yu ma doo sa kelikutan mekeuma diyà kenak, owoy sa dakel lihay éhê sa meukitan ku kani. ");
INSERT INTO mta_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Dodoo beken aken sa humemilì tayu sa etaw mekepenuu denu kuwanan ku ataw ka denu bibang ku. Si Emà ku polo sa mekehemilì sa etaw mekepenuu dahiya.” ");
INSERT INTO mta_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na, egoh sa sepulù duma salu di migdineg denu sa pinegeni da diyà si Hésus, egbulitan da Santiyago i owoy si Huwan. ");
INSERT INTO mta_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Agulé, sinetipon i Hésus sa langun salu di, owoy guwaen di diyà kenagda, “Netiigan ta doo sa egbaelan sa medoo datù etaw beken Hudiyu, enù ka takaan da egpeges sa medoo etaw da danà sa dakel egkegaga da, owoy takaan da ma kagda egsugù. ");
INSERT INTO mta_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Dodoo endà mebaluy di amuk ilingan yu iya wé egbaelan da. Amuk duen sa etaw diyà keniyu ungayà di egpedakelen di kagdi, petukééyen di polo kagdi lagà sa egsugùsuguen yu. ");
INSERT INTO mta_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Hediya ma, amuk duen etaw diyà keniyu ungayà di pedakelen di kagdi, mepion amuk petukééyen di polo kagdi lagà sa udipen yu. ");
INSERT INTO mta_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Meilingan di ma aken i Kakay Langun, enù ka beken iya sa pesuwan ku mig-angay a diyà tanà anì metabangan a etaw, dodoo mig-angay a dini anì metabangan ku polo sa medoo etaw owoy meimatayan a ma anì melaun ku sa medoo etaw neudipen danà sa salà da.” ");
INSERT INTO mta_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na, migtebow Hésus i owoy sa medoo salu di diyà sa menuwa Héliko. Egoh da egtalà dahiya, duen sa etaw temù medoo eg-unut diyà kenagda. Duen ma sa maama langap egpenuu egpegeni pilak diyà sa kilidan kalasada. Iya sa ngadan di si Baltimiyu anak i Timiyu. ");
INSERT INTO mta_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Egoh di neketiig tumalà Hésus i tegeNasalét, eg-umow, guwaen di, “O Hésus, tugod i Dabid, hiduwi ko aken.” ");
INSERT INTO mta_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eghawidan sa medoo etaw, guwaen da, “Yaka egséléken na.” Dodoo eg-uman polo eg-umow metaled, guwaen di, “O tugod i Dabid, hiduwi ko aken.” ");
INSERT INTO mta_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Agulé, eg-ugpà Hésus i owoy guwaen di, “Uwit yu diyà kenak.” Agulé guwaen sa medoo etaw diyà sa langap, “Pebagel ko sa pedu ko. Tigdeg ka dé, enù ka igsasà di kuna angay ka dutu gaa.” ");
INSERT INTO mta_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hê, petow dé migtigdeg, owoy egoh di miglengà sa sebaen kawal di, mig-angay diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Agulé guwaen i Hésus, “Ngadan iya wé egkeiyapan ko baelan ku diyà keniko?” Egsagbì sa langap, guwaen di, “O Datù, ungayà ku umilag a hedem.” ");
INSERT INTO mta_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Guwaen i Hésus, “Likù ka dé, enù ka nelikuan ka dé danà sa kepigtuu ko.” Hê, petow dé mig-ilag sa langap, owoy eg-unut-unut ma diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na, egoh da i Hésus egkedapag diyà Hélusalém, buyu da dé dumagpak diyà sa menuwa Bétpagi owoy sa menuwa Bétaniya diyà sa Getan Olibu. Agulé, sinugù i Hésus sa duwa salu di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Huna yu dé angay dutu siedò menuwa tebowon ta. Amuk tumebow yu dutu, hauwen yu sa hinagtay nati asnu igtagkes endà pa nelayam di egkudaan. Lengà yu owoy uwit yu dini. ");
INSERT INTO mta_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Amuk duen etaw umigsà keniyu, guwaen di, ‘Maen di ya eglengaen yu iya wé?’ iya sa sagbì yu, guwaen yu, ‘Igsugù i Datù enù ka duen sa penemdem di owoy ipelikù di mendaa dini.’” ");
INSERT INTO mta_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Agulé, mig-ipanaw sa duwa salu di owoy hinaa da sa nati asnu igtagkes medapag diyà sa pintuan dalesan diyà sa kilidan kalasada. Agulé eglengaen da dé. ");
INSERT INTO mta_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dodoo duen etaw dahiya mig-igsà, guwaen da, “Ngadan sa egbaelan yu? Maen di ya eglengaen yu iya wé?” ");
INSERT INTO mta_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Egsagbì da sa tinulon i Hésus diyà kenagda. Hê, egpandayaen da dé kagda. ");
INSERT INTO mta_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Agulé, inuwit da sa nati asnu diyà si Hésus, owoy inampisan da ginis sa iyug di owoy migkudà Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Agulé, itenàtenà sa medoo etaw sa ginis da diyà sa ukitan i Hésus, owoy itenàtenà ma sa medoo liyu etaw sa panga kayu kinuwa da diyà sa kilidan kalasada, enù ka egtandaan da sa kedatù da kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na, sa medoo etaw eg-unut diyà si Hésus, iling ka muna ataw ka hudihudi, eg-edung da eg-ikagi metaled, guwaen da, “Meolò Nemula i. Meolò ma sa pineangay i Datù Nemula. ");
INSERT INTO mta_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Meolò ma sa Datù sa Tugod i Datù Dabid egtebow dahini. Meolò ma Nemula i diyà langit.” ");
INSERT INTO mta_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na, egoh i Hésus migtebow diyà Hélusalém, migludep diyà sa Dalesan i Nemula. Agulé, egoh di mighaa sa medoo langun taman dahiya, egpelikù dema lapeg sa medoo salu di eg-angay Bétaniya dò enù ka mahapun dé. ");
INSERT INTO mta_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Na, egoh di sumimag, egpelikù da dema mangay Hélusalém dò kedu Bétaniya. Egoh da eg-ipanaw, egpeketues Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Agulé, egsugpayalen di sa kayu pigus melaweng daun. Huenan di inangay di egtelow amuk duen sa bunga di. Dodoo egoh di nekeuma dé, hinaa di anan daun daa enù ka endà pa neuma sa kebunga di. ");
INSERT INTO mta_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Agulé, guwaen di diyà sa kayu, “Edung ini egoh di, endà dé kaenen di etaw sa bunga ko.” Na, dinineg ma sa medoo salu di iya wé inikagi di. ");
INSERT INTO mta_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na, egoh da migtebow Hélusalém dò, migludep Hésus i diyà sa Dalesan i Nemula, owoy hinemagawan di sa medoo etaw tegedagang owoy sa medoo egbeli. Pinekinilid di ma sa medoo lamisan etaw tegesambì pilak owoy sa medoo bangkù sa tegedagang manuk imatayan da ibegay diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Hinawidan di ma sa medoo etaw eghated sa langun taman da eg-ukit diyà sa duwangen Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Agulé, egtuluen di sa medoo etaw dahiya, guwaen di, “Iya sa kagi i Nemula igpesulat, guwaen di, ‘Sa Dalesan ku, iya sa dalesan atung egsimbaan sa langun etaw diyà siini sinukub langit.’ Dodoo danà sa egbaelan yu dahini, nebaluy dalesan sa medoo tegelapis polo siini Dalesan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na, duen medoo ulu-ulu tegesimbà owoy medoo tegetulù uledin igsugkow i Mosis migdineg iya wé inikagi i Hésus. Agulé egseolomoy da eglagbet sa ukit da mimatay kenagdi, dodoo nelimedangan da Hésus i, enù ka egkegaip sa langun etaw sa medoo igtulù di. ");
INSERT INTO mta_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Agulé, egoh di mahapun dé, eglegkang dema Hésus i owoy sa medoo salu di diyà Hélusalém owoy eglikù da. ");
INSERT INTO mta_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na, umenaw sumimag, egoh da eg-ipanaw egpelikù Hélusalém dò, hinaa da iya wé kayu pigus endà duen bunga di. Tigtu nelaeb dé lapeg sa dalid di nematay. ");
INSERT INTO mta_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Agulé, netulengan i Pidelu sa binaelan i Hésus, owoy guwaen di, “O Datù, haa ko sa kayu pigus tinubad ko, nelaeb dé.” ");
INSERT INTO mta_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Guwaen i Hésus diyà kenagda, “Pigtuu yu dé diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk ikagiyan sa etaw siini getan anì humalì dagat dò, meketuu doo sa inikagi di amuk endà egsagàsagà di egpigtuu, dodoo tigtu egpigtuuwen di polo sa egoh di netuu sa kagi di. ");
INSERT INTO mta_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Huenan di, ini sa eg-ikagiyen ku diyà keniyu. Amuk egsimbà yu diyà si Nemula owoy duen sa egpegeniyen yu diyà kenagdi, peeles yu dé sa pedu yu egpigtuu sa egoh yu migsakem sa pinegeni yu, agulé begayan i Nemula doo kiyu sa egpegeniyen yu. ");
INSERT INTO mta_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Dodoo amuk egsimbà yu diyà si Nemula, peuloyi yu sa salà duma yu anì ipeuloy ma i Emà ta Nemula diyà langit sa salà binaelan yu. ");
INSERT INTO mta_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Dodoo amuk endà tigtu yu duu ipeuloy sa salà duma yu, endà ma ipeuloy i Emà ta diyà langit sa salà binaelan yu.” ");
INSERT INTO mta_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na, egoh da migtebow dema diyà Hélusalém, egbigkatbigkat Hésus i dalem sa Dalesan i Nemula. Agulé, duen medoo tegetulù uledin igsugkow i Mosis owoy medoo ulu-ulu tegesimbà owoy medoo kaunutan etaw Hudiyu mig-angay da diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eg-igsà da, guwaen da, “Ngadan keduwan sa egkegaga ko egbael siini medoo binaelan ko? Ngadan di etaw sa migpeangay keniko?” ");
INSERT INTO mta_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Egsagbì Hésus i, guwaen di, “Duen ma sa igsà ku diyà keniyu. Amuk sagbian yu aken, tulonen ku ma diyà keniyu sa keduwan sa naken egkegaga. ");
INSERT INTO mta_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Enù di ya, ngadan sa migsugù si Huwan egoh di migbautis sa medoo etaw diyà wayeg, ataw ka si Nemula ataw ka sa etaw daa?” ");
INSERT INTO mta_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Agulé, egsesigbolowoy da sa kesagbì da, guwaen da, “Amuk sumagbì ki, guwaen ta, ‘Si Nemula sa migsugù kenagdi,’ sumulì mikagi Hésus i guwaen di, ‘Maen di ya atu endà egpigtuuwen yu duu?’ ");
INSERT INTO mta_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dodoo endà ma sumagbì ki, guwaen ta, ‘Sa etaw daa.’” Na, endà sumagbì da etaw daa sa migsugù si Huwan enù ka nelimedangan da sa medoo etaw enù ka netuuwan sa langun etaw kagdi sa tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Huenan di, egsagbì da diyà si Hésus, guwaen da, “Enday ta duu. Endà netiigan ké duu sa migsugù si Huwan.” Agulé guwaen i Hésus, “Amuk hediya, endà ma tulonen ku duu diyà keniyu sa keduwan sa naken egkegaga.” ");
INSERT INTO mta_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na, migtulon peligad Hésus i diyà kenagda, guwaen di, “Duen sa maama mighemula palas diyà sa tanà di. Linesed di, owoy tinosongon di sa dakel batu kenà da humemeg palas, owoy binaelan di ma sa lawì mehagtaw kenà sa tegebantay umugpà. Agulé, igsalig di diyà sa medoo etaw tegeipat, enù ka mangay mediyù dò. ");
INSERT INTO mta_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Agulé, egoh di neuma sa bulan di kepupu sa bunga di, pineangay di sa egsugùsuguen di diyà sa medoo tegeipat anì kuwaen di sa hagdi baed. ");
INSERT INTO mta_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Dodoo egoh sa egsugùsuguen di migtebow, egsabaan sa medoo tegeipat polo kagdi owoy egsebalbalen da ma owoy eghemagawan da, dodoo endà duen sa igbegay da. ");
INSERT INTO mta_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Agulé, pineangay sa épê hinemulaan sa sebaen ma egsugùsuguen di diyà kenagda. Dodoo egsebalbalen da sa ulu di owoy egpeumàumaan da ma. ");
INSERT INTO mta_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Agulé, pineangay dema sa épê hinemulaan sa sebaen ma egsugùsuguen di, dodoo inimatayan da polo. Medoo ma sa liyu egsugùsuguen di pineangay di diyà kenagda, dodoo duen sa binalbal da owoy duen ma sa inimatayan da. ");
INSERT INTO mta_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Agulé, iya sa tigtu hudihudi pineangay di diyà kenagda sa anak di eghiduwan di, enù ka diyà sa penemdem di meadatan da doo sa anak di. ");
INSERT INTO mta_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dodoo egoh di migtebow, egseolomoy sa medoo tegeipat, guwaen da, ‘Ini sa etaw kumuwa siini tanà lalawan di diyà sa emà di. Téél yu dé, imatayan ta anì nita polo sa hinemulaan.’ ");
INSERT INTO mta_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Agulé, sinigkem da owoy inimatayan da owoy igbuung da sa lawa di diyà dibaluy sa hinemulaan. ");
INSERT INTO mta_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na, tulonen ku diyà keniyu sa mebaelan sa épê hinemulaan. Angayen di doo mimatay siedò medaet etaw owoy isalig di sa hinemulaan di diyà sa medoo liyu etaw. ");
INSERT INTO mta_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lagà yu endà nekebasa siini kagi i Nemula igpesulat, guwaen di, ‘Sa sebaen batu inekedan sa medoo egbael dalesan pulung batu enù ka guwaen da dò endà duen ulan di, iya polo sa tigtu miulan batu hinemilì ku. ");
INSERT INTO mta_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Anan mepion iya wé binaelan i Datù, huenan di meolò kagdi i.’ ” ");
INSERT INTO mta_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Agulé, egoh sa medoo ulu-ulu etaw Hudiyu migdineg iya wé, netiigan da kagda sa egkesugat peligad i Hésus. Huenan di, ungayà da hedem sigkemen da Hésus i, dodoo endà megaga da duu enù ka nelimedangan da sa medoo etaw eg-unut-unut diyà kenagdi. Hê, sinalidan da dé Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Agulé, duen duma etaw Palasiyu owoy duma etaw i Datù Hélod pineangay sa medoo ulu-ulu etaw Hudiyu diyà si Hésus anì metipu da kagdi amuk meamu sa kagi di. ");
INSERT INTO mta_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Egoh da migtebow diyà si Hésus, guwaen da, “O Mistelu, netiigan ké anan tuu sa langun eg-ikagiyen ko. Endà eghalìhalien ko duu sa igtulù ko sumalà dé sa balangan etaw egdineg, dodoo metudà polo sa ketulù ko sa uyot i Nemula. Na, duen ma sa igsà ké diyà keniko. Enù di ya, meketipay ki pa sa uledin igsugkow i Mosis amuk megay ki pelesintu diyà si Sisal sa Sulutan ta dutu Loma dò? Megay ki ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Dodoo netiigan i Hésus sa pandapat da medaet, huenan di guwaen di, “Maen di ya egtepengan yu aken? Uwit yu diyà kenak sa kuleta anì hauwen ku.” ");
INSERT INTO mta_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Hê, igbegay da diyà si Hésus. Agulé guwaen di, “Ngadan iya wé etaw diyà sa kuleta owoy sa sulat di?” Guwaen da egsagbì, “Iya si Sisal sa Sulutan ta.” ");
INSERT INTO mta_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Agulé guwaen i Hésus, “Amuk hediya, begayi yu diyà si Sulutan Sisal sa hagdi egpegeniyen, owoy begayi yu ma diyà si Nemula sa hagdi egpegeniyen.” Hê, tigtu egkegaip da egoh da migdineg iya wé sagbì di. ");
INSERT INTO mta_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na, duen etaw Sadusiyu mig-angay da eg-igsà diyà si Hésus. Kagda sa etaw Hudiyu egtulù endà umenaw di gaa sa etaw nematay. ");
INSERT INTO mta_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Guwaen da, “O Mistelu, duen sa igsulat i Mosis diyà kenita denu sa egbaelan ta amuk nematay sa maama épê sawa dodoo endà duen anak da. Iya sa baelan di, ipesawa diyà sa hadi di sa balu anì dumuen anak da lagà sa anak sa maama nematay. ");
INSERT INTO mta_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, duen pitu maama setelahadiyay. Agulé migsawa sa kakay da, dodoo endà duen anak da egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Hê, inited sa tigtu hadi di sa sawa sa kakay di, dodoo nematay ma egoh di endà pa duen anak da. Hediya ma sa nebaelan sa ketelu maama taman sa kepitu. ");
INSERT INTO mta_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nesesetugdugtugdug sa pitu telehadi egsawa sa bayi, dodoo langun da nematay endà mig-anak da. Agulé, hudihudi nematay sa bayi. ");
INSERT INTO mta_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, tulon ko kenami. Amuk meuma sa keenaw sa etaw nematay, ngadan tayu di etaw sa mesawa siedò bayi diyà siini pitu telehadi? Enù ka anan da migsawa kenagdi egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Agulé migsagbì Hésus i, guwaen di, “Tigtu eg-amu sa penemdem yu, enù ka endà netiigan yu duu sa kagi i Nemula igpesulat owoy endà ma netiigan yu duu sa egkebaelan i Nemula danà sa tunung di. ");
INSERT INTO mta_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Amuk enawen i Nemula sa etaw nematay, endà dé sesawaay da enù ka lagà da dé egsugùsuguen di diyà langit. ");
INSERT INTO mta_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Endà netiigan yu duu denu sa keenaw sa etaw nematay enù ka lagà yu endà nekebasa sa kagi i Nemula igsulat i Mosis denu sa egoh sa kayu eglegleg egoh i Nemula mig-ikagi diyà kenagdi, guwaen di, ‘Aken sa Nemula egpigtuuwen da i Ablaham owoy si Isak owoy si Hakob.’ ");
INSERT INTO mta_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na, egoh i Nemula mig-ikagi iya wé diyà si Mosis, nelugay da dé nematay si Ablaham owoy si Isak owoy si Hakob. Apiya di pa nematay da dé diyà tanà, nehagtay da doo diyà sa kehaa i Nemula. Iya maen di ya tigtu eg-amu yu enù ka guwaen yu dò endà umenaw sa etaw nematay.” ");
INSERT INTO mta_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na, duen ma etaw tegetulù uledin igsugkow i Mosis dahiya migdineg sa kesigbolow da diyà si Hésus. Egoh di neketiig tigtu mepion sa sagbì i Hésus diyà sa medoo Sadusiyu, eg-igsà ma, guwaen di, “O Mistelu, ngadan sa tayu mapulù uledin diyà sa langun uledin igsugkow i Mosis egoh anay?” ");
INSERT INTO mta_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Egsagbì Hésus i, guwaen di, “Ini sa tigtu mapulù uledin di, ‘O medoo tugod i Islaél, taa yu hih, sebaen daa sa Datù ta si Datù Nemula, ");
INSERT INTO mta_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","huenan di, pusungi yu sa Datù yu si Nemula. Peunuti yu diyà kagdi sa langun pedu yu owoy sa langun penemdem yu owoy sa langun egkegaga yu.’ ");
INSERT INTO mta_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Owoy ini sa keduwa di uledin mapulù, ‘Hiduwi ko sa duma ko éhê mendaa sa kehidu ko keniko.’ Na, endà duen liyu uledin mekelowon diyà siini duwa uledin di.” ");
INSERT INTO mta_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Agulé mig-ikagi sa tegetulù uledin, guwaen di, “O Mistelu, mepion iya wé sagbì ko. Tuu sa guwaen ko si Nemula daa sa Datù ta owoy endà duen sa liyu Nemula. ");
INSERT INTO mta_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tuu ma sa guwaen ko ipusung ta Nemula i owoy ipeunut ta diyà kagdi sa langun pedu ta owoy sa langun egkegaga ta, owoy hiduwan ta ma sa duma ta éhê mendaa sa kehidu ta kenita. Uman pa mepion sa kepangunut ta siini duwa uledin diyà sa keimatay ta hinagtay ulowen diyà si Nemula ataw ka sumalà dé sa liyu ibegay ta diyà kagdi.” ");
INSERT INTO mta_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Egoh i Hésus neketiig milantek sa sagbì sa tegetulù uledin, guwaen di diyà kenagdi, “Buyu ka dé mekeunut sa kedatù i Nemula.” Huenan di, endà dé duen etaw eg-uman eg-igsà diyà si Hésus, enù ka egkelenawan da amuk metepelan da. ");
INSERT INTO mta_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na, egoh i Hésus egtulù diyà sa Dalesan i Nemula, guwaen di, “Maen di ya iya sa igtulù sa medoo tegetulù uledin denu si Mésayas sa Tigtu Datù eg-angat-angatan sa medoo Hudiyu, guwaen da kagdi gaa sa tugod i Dabid egoh anay? ");
INSERT INTO mta_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na, tuu iya wé inikagi da, dodoo pinesulat sa Metiengaw Suguy i Nemula Dabid i egoh anay, guwaen di, ‘Ini sa kagi i Datù Nemula diyà sa Datù ku, guwaen di, Penuu ka dahini denu kuwanan ku taman atuwan ku sa medoo kuntelà ko owoy ipeutuh ku keniko.’ ");
INSERT INTO mta_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na, amuk iya sa kagi i Dabid egoh anay denu si Mésayas, guwaen di ‘Datù ku’, endà mebaluy di amuk tugod i Dabid daa kagdi i, dodoo Datù di polo.” Na, tigtu egkeiyap sa medoo etaw egdineg sa igtulù i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Agulé, eg-uman egtulù diyà kenagda, guwaen di, “Hahaa yu sa medoo tegetulù uledin igsugkow i Mosis anì endà umiling yu kenagda. Igluhub da takà sa metaes kawal da metolol, owoy egkeiyap da ma amuk egsaluan etaw kagda diyà sa padian. ");
INSERT INTO mta_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amuk mangay da diyà sa simbaan, ungayà da menuu da diyà sa bangkù ginelal. Owoy amuk mangay da diyà pista, ungayà da kagda sa muna pekaenen. ");
INSERT INTO mta_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Egtepelen da ma sa medoo dalesan sa bayi balu danà sa medoo pandapat da, dodoo eglidungen da sa medaet egbaelan da. Amuk hauwen da etaw, melugay da ubòubò egsimbà. Huenan di, uman pa dakel sa kepigtamay i Nemula mekeuma diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na, egpenuu Hésus i dalem sa Dalesan i Nemula medapag diyà sa atung taguan pilak ibegay etaw. Eghauwen di sa medoo etaw egdalem pilak dahiya. Duen medoo kawasà etaw egdalem dahiya sa medoo pilak. ");
INSERT INTO mta_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Agulé, migtebow sa bayi balu pubeli owoy egdalemen di sa duwa tukééy kuleta di tigtu diisek sa lagà di. ");
INSERT INTO mta_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Agulé, sinetipon i Hésus sa medoo salu di, owoy guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Miglowon polo sa igbegay siini bayi balu pubeli diyà sa igbegay sa langun duma etaw. ");
INSERT INTO mta_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Iya maen di ya enù ka endà egkelikutan da egbegay enù ka medoo sa pantiyali da. Dodoo siini bayi balu pubeli, inimet di sa langun kehagtayan di egbegay, apiya di pa pubeli daa.” ");
INSERT INTO mta_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na, egoh i Hésus eglaun kedu diyà sa Dalesan i Nemula, eg-ikagi sa sebaen salu di, guwaen di, “O Mistelu, haa ko siini Dalesan i Nemula. Tigtu metolol siini medoo batu binaelan da dalesan owoy tigtu metolol ma siini dalesan binaelan da.” ");
INSERT INTO mta_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Agulé guwaen i Hésus, “Apiya di pa eg-oloen yu siini metolol dalesan eghauwen yu, tumebow pa sa agdaw di mekedan langun. Megubal sa kelatkat di anan batu sinelogsudlogsud anì pa sebaen sa mesamà.” ");
INSERT INTO mta_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na, egoh da migtebow diyà sa Getan Olibu, migpenuu Hésus i owoy egsugpayalen di sa Dalesan i Nemula. Agulé, mig-angay da diyà kenagdi Pidelu i owoy si Santiyago owoy si Huwan owoy si Andelis. Egoh da eglebù, eg-igsà da, ");
INSERT INTO mta_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","guwaen da, “Tuloni ko kami, hih, nengan di ya tumebow iya wé tinulon ko? Ngadan sa tandà di amuk buyu meuma iya wé?” ");
INSERT INTO mta_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Mig-edung Hésus i egtulù, guwaen di, “Tulik yu anì endà meakalan yu, ");
INSERT INTO mta_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","enù ka dumuen sa medoo etaw tegeakal tumebow peiling kenak guwaen da kagda gaa si Kelistu. Hê, meakalan da sa medoo etaw umunut diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Amuk dinegen yu sa medoo etaw egsegilaway medapag diyà keniyu ataw ka sa lalag sa gila dutu mediyù dò, yoko egkelimedangan na, enù ka muna pelawà mukit siini medoo medaet diyà tanà, dodoo beken pelà iya sa tandà di meuma sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mesegila sa medoo etaw, enù ka sa medoo etaw diyà sa sebaen tanà mangay da gumila diyà sa sebaen ma tanà, owoy sa medoo etaw sa sebaen datù mangay da gumila diyà sa sebaen ma datù. Dumuen ma dakel linug owoy dakel bitil umukit diyà sa medoo balangan tanà. Dodoo apiya di pa medaet iya wé meukitan yu, iya polo sa edungan sa kelikutan yu tumebow, lagà sa edungan sa kesakit sakal tugedamen sa bayi amuk lesutan. ");
INSERT INTO mta_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Dodoo tulik yu, enù ka sigkemen da kiyu owoy agaken da ma kiyu diyà sa uwis. Tapesen da ma kiyu diyà sa medoo simbaan Hudiyu. Uwiten da ma kiyu diyà sa medoo sulutan owoy sa medoo datù ma danà sa kepigtuu yu diyà kenak. Meketulù yu doo diyà kenagda sa Mepion Tegudon denu kenak. ");
INSERT INTO mta_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amuk endà pa neuma sa sabuhanan agdaw, muna pelawà mekeseluh siini Mepion Tegudon diyà sa langun etaw diyà siini sinukub langit. ");
INSERT INTO mta_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amuk sigkemen da kiyu anì meuwit yu diyà sa uwis, yoko egkebukul la egpenemdem sa ikagiyen yu diyà kenagda. Amuk meuma sa egoh yu sumagbì, mebegayan yu doo sa kagi milantek enù ka beken danà sa niyu penemdem daa dodoo danà yu polo netulù sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Apiya sa etaw telehadi, ipesigkem da sa duma da anì ipeimatay da. Hediya ma, ipeimatay ma sa medoo maama sa anak da, owoy kuntelaen ma sa medoo batà sa lukes da anì ipeimatay da. ");
INSERT INTO mta_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Melepuhan langun etaw kiyu danà sa kepigtuu yu kenak. Dodoo amuk metigkelan sa etaw siini langun kelikutan, mebegayan doo sa lalù endà meelut di.” ");
INSERT INTO mta_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Guwaen i Hésus, “Na, dumuen ma sa etaw tumebow mael medaet dalem sa Dalesan i Nemula sa kenà di endà mekepandayà. Na, amuk egpekebasa yu sa kagi i Nemula igpesulat, petiigtiig yu. Na, amuk hauwen yu siedò medaet diyà sa Dalesan i Nemula, pelaguy yu angay yu diyà sa medoo getan, kiyu i eg-ugpà diyà tanà Hudiya. ");
INSERT INTO mta_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amuk diyà duwangen sa etaw owoy diatas sa langun taman di, endà mebaluy di amuk gumemow angayen di, dodoo salidan di dé polo. ");
INSERT INTO mta_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Diya ma amuk diyà tinibah sa etaw, endà mebaluy di amuk lumikù angayen di sa kawal di, dodoo melaguy dé polo. ");
INSERT INTO mta_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Amuk meuma iya wé, mepasangan da temù sa medoo bayi obol owoy sa medoo egpesusu tukééy anak da enù ka melikutan da melaguy. ");
INSERT INTO mta_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Huenan di, simbà yu diyà si Nemula anì endà mekepelaguy yu amuk timpù udan. ");
INSERT INTO mta_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Enù ka tigtu medaet temù iya wé kelikutan mekeuma diyà tanà. Endà pa duen di sa kelikutan uman pa medaet hinaa ta edung sa egoh i Nemula migbael tanà taman ini egoh di, owoy endà ma dumuen sa kelikutan lumowon sa kedaet di diyà iya wé tumebow. ");
INSERT INTO mta_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dodoo kinulangan i Nemula sa lugay siedò medaet, enù ka amuk endà kulangan di duu, mekesugsug sa langun etaw. Dodoo kinulangan di dé sa lugay di danà sa kehidu di sa medoo etaw hinemilì di. ");
INSERT INTO mta_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Na, amuk duen etaw mikagi diyà keniyu, guwaen da, ‘Haa yu, kaini dé sa Tigtu Datù sinugù i Nemula,’ ataw ka guwaen da, ‘Haa yu, daedò é kagdi i,’ yoko egpigtuu duu iya wé. ");
INSERT INTO mta_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Enù ka tumebow pa sa medoo etaw tegebutbut, owoy guwaen da dò kagda gaa sa Tigtu Datù sinugù i Nemula, ataw ka ubòubò da tegesugkow i Nemula. Mael da doo sa medoo panduan owoy sa medoo tandà egkegaipan etaw, enù ka iya sa ungayà da akalan da hedem sa medoo etaw hinemilì i Nemula, asal mebaluy. ");
INSERT INTO mta_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huenan di, tulik yu anì endà meakalan yu, enù ka tapay dé tinulon ku langun iya wé diyà keniyu egoh di endà pa tumebow.” ");
INSERT INTO mta_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Agulé guwaen i Hésus, “Amuk meubus iya wé kelikutan, dumeleman sa tanà enù ka kumeitem sa agdaw owoy endà ma sumenang sa bulan. ");
INSERT INTO mta_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Menabù ma sa medoo bituen kedu diyà langit, owoy humalìhalì sa langun eghauwen ta diyà langit. ");
INSERT INTO mta_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Iya pelawà hauwen etaw aken i Kakay Langun tumebow peunutan gaeb, owoy tigtu dakel sa egkegaga ku kumedatù owoy dakel ma sa senang ku. ");
INSERT INTO mta_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Owoy peangayen ku ma sa medoo egsugùsuguen ku diyà sa langun uwang tanà anì setiponen da sa langun etaw hinemilì ku, sumalà dé sa kenà da eg-ugpà diyà siini sinukub langit.” ");
INSERT INTO mta_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Eg-uman Hésus i egtulù, guwaen di, “Taa yu, hih, siini balatan denu sa kayu pigus. Amuk egtugbung sa kayu pigus owoy egdaun sa medoo panga di, metiigan yu doo medapag dé sa meedup agdaw. ");
INSERT INTO mta_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hediya ma, amuk hauwen yu siedò medoo tinulon ku umukit, metiigan yu ma doo buyu a dé pelikù. ");
INSERT INTO mta_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuu ini i eg-ikagiyen ku diyà keniyu. Sa medoo duma ta eg-ugpà diyà tanà ini egoh di, amuk endà pa mematay da langun, hauwen da doo iya wé tinulon ku umukit. ");
INSERT INTO mta_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mekedan pa sa langit owoy siini tanà, dodoo endà mekedan sa kagi ku taman melugay.” ");
INSERT INTO mta_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Guwaen i Hésus, “Endà tulonen ku duu diyà keniyu sa agdaw ku pelikù ataw ka sa ulas di. Endà duen etaw meketiig sa kepelikù ku, iling ka sa medoo egsugùsuguen i Nemula diyà langit ataw ka aken i Anak i Nemula, enù ka si Emà ku daa sa meketiig. ");
INSERT INTO mta_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Huenan di, tulik yu owoy hahaa yu, enù ka endà egketiigan yu duu sa atas ku pelikù. ");
INSERT INTO mta_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lagà a sa etaw mangay mediyù dò owoy endà egtulonen di duu sa atas di pelikù. Igsalig di sa medoo langun taman di diyà sa medoo egsugùsuguen di, owoy igsugù di ma diyà sa uman sebaen etaw sa hagda galebek, owoy inikagiyan di ma sa tegebantay selat anì tigtu egtulik. ");
INSERT INTO mta_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Huenan di, tulik yu enù ka endà netiigan yu duu sa atas ku pelikù, aken i épê dalesan, enù ka mebaluy mahapun ataw ka teliwadà sigep ataw ka umukolò manuk ataw ka magtu kesimag. ");
INSERT INTO mta_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tulik yu takà anì endà mepetow yu amuk metebowon ku kiyu egtudug. ");
INSERT INTO mta_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Na, eg-ikagiyen ku ma diyà sa langun etaw ini i eg-ikagiyen ku diyà keniyu anì tumulik yu langun.” ");
INSERT INTO mta_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Na, duwa pa agdaw meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, owoy iya ma sa pista egoh da egkaen sa epan endà duen igpelenuk di. Agulé, eglagbeten sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin sa ukit kesigkem da si Hésus anì ipeimatay da, enù ka ungayà da lidungen da diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Egseolomoy da, guwaen da, “Endà mebaluy di sigkemen ta kagdi i diyà siini pista, enù ka sulian kéen sa medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, egoh i Hésus diyà sa menuwa Bétaniya, eggemow diyà sa dalesan i Simon, sa etaw nelikuan dempid. Agulé, egoh da egkaen pelà, duen sa bayi migtebow eg-uwit sa metolol tukééy butul alabastelu nepenù lana mepion ngadeg pinengadanan da naldo owoy tigtu mapulù. Agulé migdapag diyà si Hésus. Hê, tinepù di sa lieg butul owoy hinudud di sa lana diyà sa ulu i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Agulé, egbulit sa duma etaw dahiya egoh da mighaa sa binaelan di, owoy egseolomoy da, guwaen da, “Maen di ya linemet di iya wé lana? ");
INSERT INTO mta_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mepion polo hedem amuk dagangen di anì mekekuwa medoo pilak anì mekebegay diyà sa medoo etaw pubeli, enù ka subela telu gatus sa lagà di.” Agulé, tigtu egsesigbolowen da sa bayi. ");
INSERT INTO mta_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Dodoo guwaen i Hésus, “Pandayà yu dé. Yoko egsigbolow duu, enù ka tigtu mepion temù sa binaelan di diyà kenak. ");
INSERT INTO mta_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Enù ka tapay doo duen sa etaw pubeli diyà keniyu anì mebuligan yu ma kagda sumalà dé sa agdaw di. Dodoo aken, endà dé iseg a melugay mugpà diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Binaelan siini bayi diyà kenak taman sa negaga di egbael. Hinududan di aken lana anì tapayen di pepion sa lawa ku sa egoh ku ilebeng. ");
INSERT INTO mta_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tuu ini i eg-ikagiyen ku diyà keniyu. Endà melipengan di etaw kagdi i, enù ka metulon iya wé binaelan di diyà kenak, sumalà dé sa menuwa diyà siini sinukub langit kenà da egtulù sa Mepion Tegudon.” ");
INSERT INTO mta_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na, duen sebaen maama diyà sa sepulù owoy duwa salu i Hésus, si Hudas Iskaliyot. Mig-angay eg-olom diyà sa medoo ulu-ulu tegesimbà anì mekuwa da Hésus i danà sa baelan di. ");
INSERT INTO mta_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Egoh da neketiig sa penemdem i Hudas, neanggan da owoy migpasad da megay pilak diyà kenagdi. Hê, mig-edung dé Hudas i eglagbet sa mepion gai di megay si Hésus diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, neuma dé sa muna agdaw sa pista da egkaen sa epan endà duen ipelenuk di. Iya ma sa agdaw da eg-imatay sa anak kebilibili kaenen da amuk egpista da sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Huenan di, eg-igsà sa medoo salu i Hésus, guwaen da, “Ngadan sa kenà ko egpeangay kenami anì tapayen ké mael sa kaenen ta egpista sa Agdaw Kinetalà Sa Kepigtamay i Nemula?” ");
INSERT INTO mta_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Agulé, sinugù i Hésus sa duwa salu di, guwaen di, “Angay yu dutu siedò menuwa, owoy hauwen yu dahiya sa maama eg-otol buyung nepenù wayeg. Unut yu kenagdi ");
INSERT INTO mta_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","mangay diyà sa dalesan gemowon di. Ikagi yu diyà sa épê dalesan, guwaen yu, ‘Ini sa kagi i Mistelu, kenà sa sibay ko gaa kenà di egkaen siini pista ta lapeg sa medoo salu di?’ ");
INSERT INTO mta_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Agulé, ipehaa di diyà keniyu sa dakel sibay lekeatas duen lamisan owoy langun taman eg-ipaten diyà pista. Dahiya sa kenà yu egtapay sa pista ta.” ");
INSERT INTO mta_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Agulé, eg-ipanaw sa duwa salu di eg-angay Hélusalém dò, owoy hinaa da sa langun tinulon i Hésus diyà kenagda. Agulé, egtapayen da sa kaenen da egpista. ");
INSERT INTO mta_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na, egoh di mahapun dé, egkesetipon da Hésus i owoy sa sepulù owoy duwa salu di diyà sa dalesan. ");
INSERT INTO mta_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Agulé, egoh da egkaen pelawà diyà sa lamisan, eg-ikagi Hésus i, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Duen sa sebaen etaw diyà keniyu duma ta egkaen ini egoh di sa megay kenak diyà sa kuntelà ku anì meimatayan a.” ");
INSERT INTO mta_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Hê, egkebukul da temù, owoy sigbaenbaenay da eg-igsà diyà kenagdi, guwaen da, “O Datù, beken aken sa inikagi ko?” ");
INSERT INTO mta_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Migsagbì Hésus i, guwaen di, “Iya sa megay kenak diyà sa medoo kuntelà ku sa sebaen etaw diyà keniyu i sepulù owoy duwa salu ku. Kagdi sa duma ku egkesetugen egkaen diyà siini bilu. ");
INSERT INTO mta_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mematay a doo, aken i Kakay Langun, enù ka meketuu sa kagi i Nemula igpesulat denu kenak. Dodoo tigtu mepigtamayan sa maama megay kenak diyà sa medoo kuntelà ku. Adi-adi pa hedem amuk endà inanak iya wé maama.” ");
INSERT INTO mta_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na, egoh da egkaen pelawà, sinabaan i Hésus sa sebaen epan owoy migsimbà egpesalamat diyà si Nemula. Agulé, tinepitepi di owoy igtukid di igbegay diyà sa medoo salu di. Guwaen di, “Kuwa yu owoy kaen yu dé, enù ka ini sa lawa ku.” ");
INSERT INTO mta_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Agulé, sinabaan di ma sa tabù duen wain, owoy migsimbà ma egpesalamat diyà si Nemula. Agulé, tinukid di egbegay sa medoo salu di, owoy langun da mig-inem iya wé. ");
INSERT INTO mta_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Guwaen i Hésus, “Ini sa depanug ku lumesut amuk meimatayan a anì metigtuwan sa salà sa langun etaw. Siini depanug ku, iya sa tandà di neketuu sa magtu ukit igpasad i Nemula umaluk etaw. ");
INSERT INTO mta_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tuu ini i eg-ikagiyen ku diyà keniyu. Endà dé uminem a uman siini wain eg-inemen ta taman endà uminem ki sa magtu wain diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Agulé egduyuy da eg-olò si Nemula. Agulé eg-ipanaw da eg-angay Getan Olibu dò. ");
INSERT INTO mta_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Agulé, eg-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Melaguy yu langun igkani owoy salidan yu aken, enù ka meketuu sa kagi i Nemula igpesulat, guwaen di, ‘Meimatayan ku sa etaw tegeipat kebilibili, hê, mesepalak sa medoo kebilibili.’ ");
INSERT INTO mta_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Dodoo amuk meenaw a dema, hunawan ku kiyu mangay Galiliya dò.” ");
INSERT INTO mta_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Agulé guwaen i Pidelu diyà kenagdi, “Apiya sumalid sa langun duma ta, endà sumalid a, aken i.” ");
INSERT INTO mta_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Migsagbì Hésus i, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniko. Egoh sa ebos endà pa umukolò taman duwa gulê igkani sigep, palawen ko polo aken beken duma ko taman telu gulê.” ");
INSERT INTO mta_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Dodoo pinebagel i Pidelu sa kagi di, guwaen di, “Endà dé palawen ku duu kuna, apiya di pa meseselengan ki mematay.” Hediya ma sa inikagi sa medoo duma salu di. ");
INSERT INTO mta_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na, egoh da migtebow diyà sa kenà hinemulaan kepengadan da Gétsémani, eg-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Penuu yu dini, enù ka mangay a sumimbà daedò é.” ");
INSERT INTO mta_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Agulé, inuwit di Pidelu i owoy si Santiyago owoy si Huwan. Hê, egkedaet temù sa pedu di owoy tigtu egkebukul ma, ");
INSERT INTO mta_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","owoy guwaen di, “Tigtu medaet sa pedu ku, owoy lagà a buyu mematay danà sa pedu ku medaet. Ugpà yu pelawà dini. Yoko egtudug ga, dodoo tulik yu polo.” ");
INSERT INTO mta_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Agulé, migtangkà tukééy Hésus i diyà kenagda, owoy miglagkeb diyà tanà. Egsimbà diyà si Nemula anì endà meukitan di duu sa dakel kelikutan di, asal mebaluy. ");
INSERT INTO mta_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Guwaen di, “O Emà ku, megaga ko mael langun. Huenan di, amuk mebaluy, kedani ko diyà kenak siini dakel kelikutan ku lagà wain mepait buyu egkeinem ku. Dodoo peukit ko diyà kenak sa niko uyot, beken sa naken.” ");
INSERT INTO mta_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Agulé, migpelikù Hésus i diyà sa kenà sa telu salu di, owoy eghauwen di kagda egtudug. Guwaen di diyà si Pidelu, “O Simon, neketudug yu dé atu? Maen di ya endà metigkelan yu duu taman sakaulas daa? ");
INSERT INTO mta_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yoko egtudug ga, dodoo simbà yu polo anì endà mekeukit yu diyà sa kenà sa pedu yu tepengan anì endà ma mekebael yu salà. Apiya di pa meiyap sa pedu yu mangunut diyà kenak, melenek doo sa lawa yu.” ");
INSERT INTO mta_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Agulé, migtangkà dema Hésus i diyà kenagda, owoy egsimbà dema éhê mendaa sa kagi di egoh di muna migsimbà. ");
INSERT INTO mta_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Agulé, migpelikù dema diyà sa telu salu di, owoy eghauwen di kagda egtudug enù ka endà metigkelan da duu sa pilut da. Egoh di mig-enaw kenagda, endà netiigan da duu sa sagbì da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Agulé, egoh i Hésus neubus egsimbà sa ketelu di gulê, egpelikù dema diyà kenagda owoy guwaen di, “Ay, maen di ya takà yu polo egtudug? Naal dé. Neuma dé sa ulas egoh ku mekebegay diyà sa medoo etaw tegebael salà, aken i Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enaw yu dé. Haa yu, dahini dé sa etaw megay kenak diyà sa kuntelà ku. Mangay ki dé tumelabuk kenagdi.” ");
INSERT INTO mta_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Hê, egoh i Hésus eg-ikagi pelà, migtebow Hudas i, sa sebaen maama diyà sa sepulù owoy duwa salu di. Duen medoo etaw mig-unut kenagdi migkemkem sundang owoy lubog. Kagda sa pineangay sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin owoy sa medoo kaunutan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, si Hudas sa migtampil diyà sa kuntelà i Hésus, tapay dé tinulon di diyà sa medoo etaw sa tandà baelan di, guwaen di, “Iya sa etaw eglagbeten yu sa ingadekan ku. Sigkem yu dé owoy bantayi yu temù amuk eg-uwiten yu kagdi.” ");
INSERT INTO mta_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na, egoh i Hudas migtebow dahiya, eg-angay egdapag diyà si Hésus owoy guwaen di, “O Mistelu.” Hê pinengadekan di. ");
INSERT INTO mta_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Agulé, egsigkemen da Hésus i owoy meeles ma sa kesabà da. ");
INSERT INTO mta_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Dodoo, duen sa sebaen duma i Hésus mighugut sa sundang di owoy tinigbas di sa egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà. Hê, nelaplap sa telinga di. ");
INSERT INTO mta_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Agulé, eg-ikagi Hésus i diyà kenagda, guwaen di, “Maen di ya eg-uwit yu sundang owoy lubog egoh yu eg-angay egsigkem kenak? Beken a etaw tegelampas. ");
INSERT INTO mta_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Uman agdaw takà a egtulù keniyu diyà sa Dalesan i Nemula, dodoo endà egsigkemen yu duu aken. Dodoo ukitan ku dé siini kebael yu kenak, enù ka neketuu dé sa kagi i Nemula igpesulat denu kenak.” ");
INSERT INTO mta_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Hê, migpelaguy sa medoo salu di owoy sinalidan da kagdi i. ");
INSERT INTO mta_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na, duen ma sa melaud dahiya mig-emut kayab eg-unut diyà si Hésus. Egtegelen da ma egsabà sa medoo duma i Hudas, ");
INSERT INTO mta_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","dodoo sa kayab di daa sa nesabaan da nesalidan di. Hê, nekepelaguy dé migpelawalawa. ");
INSERT INTO mta_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Agulé, inuwit da Hésus i eg-angay diyà sa dalesan sa Tigtu Ulu-ulu Tegesimbà. Nesetipon da dahiya sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Migtangkà ma Pidelu i eg-unut diyà kenagda eg-angay dutu, dodoo neketaman daa diyà sa duwangen sa dalesan sa Tigtu Ulu-ulu Tegesimbà. Agulé migpenuu dahiya diyà sa kenà sa medoo tegebantay enù ka eg-ingadang ma diyà sa apuy da. ");
INSERT INTO mta_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, sa medoo ulu-ulu tegesimbà owoy sa langun kaunutan Hudiyu, eglagbeten da sa kenà i Hésus mekesalà anì tipuwen da anì ipeimatay da. Dodoo, endà duen sa salà di netiigan da. ");
INSERT INTO mta_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Apiya di pa egbutbut sa medoo etaw egtipu si Hésus, endà doo nesetepeng sa inikagi da. ");
INSERT INTO mta_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Agulé, duen ma liyu etaw butbuten migtigdeg dahiya, owoy egtipuwen da Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Guwaen da, “Dinineg ké sa inikagi siini etaw, guwaen di melukat di gaa siini Dalesan i Nemula binaelan etaw, owoy amuk meuma sa telu agdaw, petigdegen di gaa sa magtu endà binaelan di etaw.” ");
INSERT INTO mta_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Dodoo apiya di pa iya sa tinulon da, endà doo nesesebaen sa kagi da egtipu si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Agulé, migtigdeg sa Tigtu Ulu-ulu Tegesimbà diyà sa teliwadà da, owoy eg-igsaan di Hésus i, guwaen di, “Ngadan sa sagbì ko denu iya wé? Tuu pa atu iya wé igtipu da keniko, ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Dodoo migpetemed polo Hésus i, endà egsagbì di. Agulé, eg-ikagi dema sa Tigtu Ulu-ulu Tegesimbà, guwaen di, “Tuloni ko kami amuk kuna si Mésayas sa Anak i Nemula, ataw ka beken.” ");
INSERT INTO mta_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Migsagbì Hésus i, guwaen di, “Hoò, aken iya wé. Dodoo endà melugay di hauwen yu doo aken i Kakay Langun menuu denu kuwanan i Nemula épê dakel egkegaga. Owoy hauwen yu ma aken kani petuntun kedu langit dò unutan gaeb.” ");
INSERT INTO mta_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Hê, eglisien sa Tigtu Ulu-ulu Tegesimbà sa kawal di danà sa kebulit di si Hésus. Guwaen di, “Endà dé lumagbet ki uman sa ketipu etaw denu kenagdi, ");
INSERT INTO mta_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","enù ka dinineg ta dé langun sa kesumbung di si Nemula guwaen di Anak i Nemula gaa. Ngadan sa penemdem yu denu kenagdi?” Agulé eg-ikagi da langun, guwaen da, “Meimatayan doo, enù ka dakel sa salà di.” ");
INSERT INTO mta_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Agulé, duen ma sa medoo etaw dahiya egteptepan da Hésus i. Eglimunan da ma ginis sa mata di, owoy egtagpien da, guwaen da, “Ingadani ko sa etaw egtagpì keniko.” Agulé egsesuntuken ma sa medoo sundalu. ");
INSERT INTO mta_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na, egoh i Pidelu diyà pelà sa duwangen dalesan, duen sa bayi egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà eg-angay egdapag diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Egoh di mighaa si Pidelu eg-ingadang dahiya, eg-inengtengen di owoy guwaen di, “Kuna ma sa duma i Hésus tegeNasalét.” ");
INSERT INTO mta_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Dodoo egpalaw Pidelu i, guwaen di, “Endà egketiigan ku duu iya wé guwaen ko.” Agulé, mighalì Pidelu i eg-angay medapag diyà sa bengawan lesed. Hê, umukolò dé sa manuk. ");
INSERT INTO mta_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Agulé, hinaa sa bayi dema Pidelu i, owoy eg-ikagi diyà sa medoo etaw dahiya, guwaen di, “Siini maama ma sa sebaen duma i Hésus.” ");
INSERT INTO mta_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Dodoo egpalaw dema Pidelu i. Agulé egoh di nelugaylugay, eg-ikagi sa medoo etaw dahiya diyà si Pidelu, guwaen da, “Tigtu tuu kuna sa duma i Hésus, enù ka kuna ma sa etaw tegeGaliliya.” ");
INSERT INTO mta_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dodoo egpengibet Pidelu i, guwaen di, “Mepigtamayan a i Nemula amuk egbutbut a. Tigtu tuu endà netiigan ku duu iya wé maama eg-ikagiyen yu.” ");
INSERT INTO mta_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hê, umukolò dema sa manuk sa keduwa di dé gulê. Agulé, netulengan i Pidelu sa inikagi i Hésus diyà kenagdi, guwaen di, “Egoh sa ebos endà pa umukolò taman duwa gulê igkani sigep, palawen ko polo aken beken duma ko taman telu gulê.” Agulé egsinegaw Pidelu i danà sa pedu di migkedaet. ");
INSERT INTO mta_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Na, umenaw sumimag, egkesetipon da sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu owoy sa medoo tegetulù uledin igsugkow i Mosis owoy sa langun ulu-ulu etaw Hudiyu. Nesetipon da anì seolomen da sa kebael da si Hésus. Agulé, pinolot da owoy inagak da diyà si Gubilenu Pilatu. ");
INSERT INTO mta_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Egoh da migtebow dahiya, eg-igsaan i Pilatu Hésus i, guwaen di, “Enù di ya, kuna sa sulutan diyà sa medoo Hudiyu?” Migsagbì Hésus i, guwaen di, “Tuu iya wé gelal igbegay ko kenak.” ");
INSERT INTO mta_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na, medoo sa igtipu sa medoo ulu-ulu tegesimbà diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Huenan di, eg-igsaan i Pilatu dema Hésus i, guwaen di, “Taa ko sa medoo itipu da diyà keniko, Maen di ya endà egsagbian ko kagda?” ");
INSERT INTO mta_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Dodoo endà egsagbì Hésus i, huenan di tigtu egkegaip Pilatu i. ");
INSERT INTO mta_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na, uman meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, iya sa adat i Gubilenu Pilatu lengaan di sa sebaen etaw nebilanggu egpegeniyen da. ");
INSERT INTO mta_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na egoh iya, duen medoo maama nebilanggu danà da migkuntelà diyà sa gubilenu owoy danà da ma mig-imatay etaw egoh da neselimbul. Iya sa sebaen maama diyà kenagda si Balabas. ");
INSERT INTO mta_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na, egoh sa medoo etaw nesetipon, eg-edung da egpegeni diyà si Pilatu anì lengaan di sa sebaen etaw nebilanggu, enù ka iya sa adat di uman meuma iya wé pista. ");
INSERT INTO mta_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Agulé eg-igsà Pilatu i, guwaen di, “Enù di ya, ungayaen yu atu lengaan ku diyà keniyu sa sulutan diyà sa medoo Hudiyu?” ");
INSERT INTO mta_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Na, iya sa inikagi di enù ka netiigan di igpesigkem sa medoo ulu-ulu tegesimbà Hésus i danà da egkesina diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dodoo inikagiyan sa medoo ulu-ulu tegesimbà sa medoo etaw dahiya anì egpegeniyen da lengaan i Pilatu polo Balabas i. ");
INSERT INTO mta_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Agulé eg-igsà dema Pilatu i, guwaen di, “Amuk hediya, ngadan di polo sa baelan ku diyà siini maama ginelal yu Sulutan diyà etaw Hudiyu?” ");
INSERT INTO mta_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Egpetaled da polo eg-ikagi, guwaen da, “Petutuki ko dé diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eg-igsà dema Pilatu i, guwaen di, “Maen di ya? Ngadan sa salà binaelan di?” Dodoo eg-ikagi da dema uman metaled, guwaen da, “Petutuki ko diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, ungayà i Pilatu metuuwan sa medoo etaw diyà kenagdi, huenan di linaun di Balabas i diyà kenagda. Agulé, igpetapes di Hésus i, owoy sinugù di sa sundalu di anì itutuk da diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Agulé, inuwit sundalu Hésus i dalem sa dakel dalesan sa gubilenu, owoy sinetipon da sa medoo duma da sundalu dahiya. ");
INSERT INTO mta_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Agulé, igpekawal da kenagdi sa kawal melalegà, lagà sa metolol kawal sulutan. Liningkal da ma sa belagen épê dugi isukub da diyà sa ulu di, lagà sa metolol sayap sulutan. ");
INSERT INTO mta_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ubòubò da ma egdatù kenagdi, guwaen da, “Meolò ka, kuna i Sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Agulé, takaan da egbalbal kayu sa ulu di owoy egteptepan da ma. Egligkued da ma diyà sa taengan di enù ka ubòubò da egdatù kenagdi. ");
INSERT INTO mta_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Egoh da neubus egpeumàumà si Hésus, egkedanan da diyà kenagdi sa kawal melalegà, owoy ipekawal da dema sa hagdi tapay kawal. Agulé, eg-agaken da dutu siedò kenà di imatayan. ");
INSERT INTO mta_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na, egoh da eg-ipanaw pelà, nesiegungan da Simon i tegeSilini magtu migtebow kedu getan. Kagdi sa emà i Alihandelo owoy si Lupo. Mangay Hélusalém dò hedem, dodoo igtegel sa sundalu igpetiang kenagdi sa kayu kenà i Hésus meketutuk. ");
INSERT INTO mta_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Agulé eg-uwiten da Hésus i diyà sa tukééy getan pinengadanan da Golgota. Iya sa selepangan di, Kulobong Ulu. ");
INSERT INTO mta_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Egoh da migtebow dutu, egbegayan da kagdi sa wain inamutan bulung pinengadanan da mila, dodoo eg-eked eg-inem. ");
INSERT INTO mta_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hê, igtutuk da diyà sa kayu owoy igbugsud da. Agulé, egkusing da egseatuwen da sa ginis di anì metiigan da sa kebaed da. ");
INSERT INTO mta_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na, alas siyow sa egoh da migtutuk si Hésus diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Duen ma sa igsulat igtagù da diyà sa lekeatas ulu di anì tandaan da sa itipu da kenagdi. Iya sa kagi di, “Ini sa Sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Duen ma sa duwa maama tegelampas igtutuk da diyà sa kayu igbugsud dahiya, sa sebaen denu kuwanan i Hésus, sa sebaen denu bibang di. ");
INSERT INTO mta_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Huenan di, neketuu dé sa kagi i Nemula igpesulat egoh anay, guwaen di, “Diyà sa kehaa etaw, kagdi sa duma etaw tegebael medaet.” ");
INSERT INTO mta_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na, egkilingkiling sa medoo etaw egtalà dahiya, owoy egpeumàumaan da Hésus i, guwaen da, “Iyoh! Melukat ko sa Dalesan i Nemula daedò é, owoy petigdegen ko dema diyà sa ketelu di agdaw. ");
INSERT INTO mta_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Amuk megaga ko iya wé, tenà ka atu kedu diyà sa kayu igbugsud anì mealukan ko kuna ya.” ");
INSERT INTO mta_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hediya ma, egpeumàumaan ma sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Egseolomoy da, guwaen da, “Egkealukan di gaa sa medoo liyu etaw, dodoo endà megaga di duu kagdi umaluk. ");
INSERT INTO mta_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iya sa kagi di kagdi gaa sa Tigtu Datù sinugù i Nemula owoy sa sulutan gaa diyà kenita i etaw Hudiyu. Dodoo endà migtuu ki taman endà hauwen ta duu tumenà kedu diyà sa kayu igbugsud.” Hediya ma egpeumàumà ma sa duwa maama duma di igtutuk diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Na, egoh di alas sepulù owoy duwa, tinenaan deleman sa uwang tanà taman telu kaulas. ");
INSERT INTO mta_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Agulé, egoh di dé alas telu mahapun, migpetaled Hésus i eg-ikagi, guwaen di diyà sa kagi di, “Eli, Eli, lama sabaktani.” Na, iya sa selepangan sa inikagi di, “O Nemula ku, maen di ya ininiyugan ko aken?” ");
INSERT INTO mta_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Egoh sa medoo etaw dahiya migdineg iya wé inikagi di, guwaen da, “Taa yu, eg-umowen di Iliyas i sa tegesugkow i Nemula egoh anay.” ");
INSERT INTO mta_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Agulé, duen sa etaw egletu eg-uwit tabung. Eg-eleden di diyà sa wain mepait, owoy igtagù di diyà sa kayu anì idugol di diyà sa ebà i Hésus anì metepes di. Guwaen di diyà sa medoo liyu etaw, “Angatan ta pelà anì mehaa ta amuk tumebow Iliyas i anì petenaen di kedu diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Agulé, pinetaled i Hésus dema sa kagi di. Hê, nekedan dé sa ginawa di. ");
INSERT INTO mta_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na, minelisì teliwadà edung lekeatas taman leketanà sa dakel ginis ighabeng dalem sa teliwadà luwang sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na sa kapitan sundalu migtigdeg diyà sa taengan i Hésus, egoh di mighaa sa ukit i Hésus nematay, eg-ikagi, guwaen di, “Tuu, Anak i Nemula ini i maama.” ");
INSERT INTO mta_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Duen ma medoo bayi egtigdeg mediyùdiyù anì eghauwen da sa langun kinebael da si Hésus. Dahiya ma Maliya i tegeMagdala, owoy si Salomi, owoy sa sebaen ma Maliya inay i Hosé owoy Santiyago hadi i Hosé. ");
INSERT INTO mta_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mig-unut-unut siini medoo bayi diyà si Hésus egoh di pelawà diyà uwang Galiliya enù ka binuligan da kagdi. Duen ma dahiya sa medoo duma bayi mig-unut kenagdi egoh di mig-angay Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Na, duen sa maama tegeAlimatiya, si Hosé. Kagdi ma sa sebaen kaunutan etaw Hudiyu, owoy eg-adatan ma etaw. Eg-angat-angatan di ma sa ketebow sa kedatù i Nemula diyà tanà. Na, sa agdaw egoh i Hésus nematay, iya ma sa agdaw egtapayen sa medoo Hudiyu sa langun egbaelan da enù ka simag sa agdaw keetud da. Na, egoh di mahapun dé, pinebagel i Hosé sa pedu di owoy mig-angay diyà si Pilatu anì egpegeniyen di sa lawa i Hésus anì ilebeng di. ");
INSERT INTO mta_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Egkegaip Pilatu i, enù ka guwaen di dò endà pa nematay Hésus i. Huenan di, igpeangay di sa kapitan sundalu owoy eg-igsaen di amuk nematay dé Hésus i. ");
INSERT INTO mta_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Agulé, egoh i Pilatu neketiig nematay dé Hésus i, egpandayaen di Hosé i kumuwa sa lawa di. ");
INSERT INTO mta_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Agulé, kinuwa i Hosé diyà sa kayu igbugsud, owoy binedbed di sa mepion ginis mebulà bineli di. Agulé, igtagù di dalem sa lebeng tinosongon etaw diyà batu, owoy kinelid di sa dakel batu anì mesagpeng sa lebeng. ");
INSERT INTO mta_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Na, hinaa i Maliya tegeMagdala owoy si Maliya inay i Hosé sa kenà lawa i Hésus iglebeng. ");
INSERT INTO mta_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na, egoh di neelut sa agdaw keetud, neseunut da Maliya i tegeMagdala owoy si Salomi owoy sa sebaen Maliya inay i Santiyago. Migbeli da sa bulung mepion ngadeg anì mangay da itagù diyà sa lawa i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Hê, egoh di umenaw simag Akad, eglapus da temù eg-angay diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Egoh da eg-ipanaw pelawà, egseolomoy da, guwaen da, “Amuk tumebow ki dutu, ngadan di etaw sa pekeliden ta sa batu igsagpeng lebeng?” ");
INSERT INTO mta_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Dodoo egoh da migtebow diyà sa lebeng, hinaa da nekelid dé sa batu igsagpeng lebeng. Tigtu dakel iya wé batu. ");
INSERT INTO mta_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Agulé mig-awuh da dalem sa tosong lebeng, owoy eghauwen da dahiya sa maama tigtu mebulà sa ginis di egpenuu denu kuwanan da. Hê, egkegaip da temù. ");
INSERT INTO mta_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Agulé, eg-ikagi diyà kenagda, guwaen di, “Yoko egkelimedangan na. Netiigan ku eglagbeten yu si Hésus tegeNasalét sa igtutuk da diyà sa kayu igbugsud. Endà dé dahini di, enù ka neenaw dé. Haa yu, ini sa kenà di pinehibat. ");
INSERT INTO mta_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dodoo angay yu tulon diyà sa medoo salu di, lapeg si Pidelu, guwaen yu, ‘Humuna Hésus i diyà keniyu mangay Galiliya dò, owoy iya sa kenà yu humaa kenagdi, enù ka iya sa tapay tinulon di diyà keniyu.’” ");
INSERT INTO mta_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Huenan di, miglaun sa telu bayi owoy egletu da kedu diyà sa kenà lebeng, enù ka eglukub da danà da egkegaip temù. Endà duen sa netulon da diyà etaw enù ka nelimedangan da. ");
INSERT INTO mta_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, egoh i Hésus mig-enaw iya wé magtu kesimag Akad, iya sa anay etaw kenà di egpehaa, si Maliya tegeMagdala sa pinelesutan di pitu busaw egoh anay. ");
INSERT INTO mta_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Agulé, mig-angay Maliya i egtulon diyà sa medoo salu i Hésus. Egoh di migtebow, egkebukul da pelà owoy egsinegaw da ma danà sa kinepatay i Hésus. ");
INSERT INTO mta_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Apiya di pa dinineg da mig-enaw Hésus i owoy hinaa i Maliya kagdi, endà doo egpigtuuwen da duu. ");
INSERT INTO mta_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Agulé, egpehaa Hésus i diyà sa duwa pasek di egoh da eg-ipanaw kedu diyà sa dakel menuwa. Dodoo endà pa egkilalaen da duu, enù ka nehalì sa egoh-egoh di. ");
INSERT INTO mta_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Hê, egoh da migkilala kenagdi, egpelikù da Hélusalém dò, owoy egtulonon da sa medoo duma da, dodoo endà ma egpigtuu da. ");
INSERT INTO mta_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Agulé, egpehaa Hésus i diyà sa sepulù owoy sebaen salu di egoh da egkaen. Egsigbolowen di kagda enù ka endà egpigtuu da owoy metegas sa ulu da, enù ka endà egpigtuuwen da duu sa tinulon sa medoo etaw mighaa kenagdi egoh di mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Agulé sinugù di kagda, guwaen di, “Angay yu diyà sa langun menuwa diyà siini sinukub langit. Tulù yu sa langun etaw sa Mepion Tegudon. ");
INSERT INTO mta_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sumalà dé sa etaw egpigtuu sa itulù yu owoy egpebautis ma, mebegayan doo sa lalù endà meelut di. Dodoo sa etaw endà egpigtuu, iya sa mepigtamayan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ini sa medoo panduan mebaelan sa etaw egpigtuu diyà kenak. Mekegaga da egpelesut busaw diyà etaw danà sa tunung sa ngadan ku. Mekeikagi da ma sa medoo balangan kagi endà netiigan da duu. ");
INSERT INTO mta_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Apiya di pa egsabaan da sa uled ataw ka eg-inem da sa mekehilu, endà doo mesakitan da. Owoy amuk itenà da sa belad da diyà sa etaw eglinadu, melikuan doo.” ");
INSERT INTO mta_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Na, egoh i Datù Hésus mig-ikagi iya wé diyà sa medoo salu di, mebatun dé dutu langit dò owoy egpenuu dé denu kuwanan i Nemula. ");
INSERT INTO mta_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Agulé, eg-ipanaw sa medoo salu di owoy egtulù da sa Mepion Tegudon sumalà dé sa eg-angayan da. Egtabangan i Datù Hésus kagda anì metuuwan sa langun etaw diyà sa ketegudon da danà sa medoo panduan egkebaelan da.");
INSERT INTO mta_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O Datù Tiyopilu, migsulat dé sa medoo etaw sa ukit-ukit sa kineugpà i Hésus dahini diyà kenita. ");
INSERT INTO mta_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inudesan da egsulat sa tinulon sa salu di enù ka sa salu di sa tapay mighaa sa langun binaelan di egoh di anay mig-edung, owoy takà da ma egtegudon iya wé diyà kenita. ");
INSERT INTO mta_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na Akay, iya ma sa uyot ku isulat ku diyà keniko sa denu si Hésus enù ka tapay doo eg-udesan ku sa egoh di mig-edung taman ini egoh di. Ungayà ku setiponen ku owoy sedenuwen ku diyà siini isulat ku sa medoo balangan dinineg ku, ");
INSERT INTO mta_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","anì metiigan ko tuu sa langun dinineg ko denu si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na, egoh anay egoh i Hélod sa Datù eg-ipat sa tanà Hudiya, duen sa tegesimbà diyà sa medoo Hudiyu, si Sakaliyas. Kagdi sa sebaen tegesimbà diyà sa medoo duma di tegesimbà tugod i Abiya miggalebek diyà sa Dalesan i Nemula diyà menuwa Hélusalém. Iya sa sawa di, si Ilisabét, sa sebaen ma tugod i Alon sa tegesimbà egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na, duwa da telesawa metiengaw etaw owoy endà duen salà da diyà sa kehaa i Nemula. Endà duen kenà da eg-amu egpangunut diyà sa langun uledin i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Dodoo endà duen anak da, enù ka tapay dé endà eg-anak si Ilisabét edung egoh da egsesawaay taman egoh da dé migkelukes. ");
INSERT INTO mta_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Agulé, neuma sa pasad da i Sakaliyas owoy sa medoo duma di tugod i Abiya eggalebek diyà sa Dalesan i Nemula, enù ka takà da egkesesambìsambì sa medoo tegesimbà. ");
INSERT INTO mta_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na iya sa adat sa medoo tegesimbà egsekusingay da anì metiigan da sa etaw mangay dalem sa Dalesan i Nemula anì ulowen di sa mepion ngadeg. Na egoh iya, nehemilì Sakaliyas i. ");
INSERT INTO mta_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Agulé egoh di neuma sa pasad di eg-ulow sa mepion ngadeg, mig-angay Sakaliyas i dalem sa Dalesan i Nemula, owoy egsimbà ma sa medoo etaw nesetipon diyà sa duwangen di. ");
INSERT INTO mta_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hê, duen sa egsugùsuguen i Nemula migpehaa diyà kenagdi egtigdeg denu kuwanan sa kenà di eg-ulow mepion ngadeg. ");
INSERT INTO mta_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Egoh i Sakaliyas mighaa kenagdi, nepetow owoy nelimedangan ma. ");
INSERT INTO mta_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Dodoo guwaen sa egsugùsuguen i Nemula, “Yaka egkelimedangan na, o Sakaliyas, enù ka dinineg i Nemula sa kesimbà ko. Umanak maama sa sawa ko si Ilisabét, owoy iya sa pengadani ko, si Huwan. ");
INSERT INTO mta_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Amuk lumesut sa anak ko, meanggan ka temù owoy meanggan ma sa pedu sa medoo etaw, ");
INSERT INTO mta_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","enù ka kagdi sa etaw pedakelen i Nemula. Endà dé uminem di wain mekehilu ataw ka sa langun balangan mekehilu. Dodoo egoh di endà pa eglesut, linuhub dé sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tuingen di sa pedu sa medoo tugod i Islaél diyà si Nemula sa Datù da. ");
INSERT INTO mta_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Egoh anay tigtu mebagel sa galebek i Iliyas egtuing sa pedu sa medoo etaw danà sa Metiengaw Suguy i Nemula. Diya ma Huwan i kani, enù ka tuingen di sa pedu sa medoo lukes maama anì mesesebaen sa pedu da sa anak da, owoy tuingen di ma sa pedu sa tegetipay si Nemula anì umunut da sa penemdem sa medoo egpangunut. Iya maen di ya anì abungan di sa medoo etaw anì mekepangunut da diyà si Datù amuk tumebow.” ");
INSERT INTO mta_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Agulé, guwaen i Sakaliyas diyà sa egsugùsuguen i Nemula, “Ngadan sa tandà di anì mekepigtuu a sa inikagi ko denu sa keanak ké, enù ka lukes a dé aken i owoy sa sawa ku ma?” ");
INSERT INTO mta_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Migsagbì sa egsugùsuguen i Nemula, guwaen di, “Aken si Gabiyél sa eg-ugpà diyà si Nemula. Pineangay di aken diyà keniko anì tulonen ku diyà keniko siini mepion baelan di. ");
INSERT INTO mta_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na, danà ko endà egpigtuu siini tinulon ku, mebuneg ka ini egoh di taman endà tumebow sa agdaw di metuu. Metuu doo sa inikagi ku amuk meuma sa pasad di.” ");
INSERT INTO mta_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Agulé, eg-angat-angatan pelà sa medoo etaw sa kelesut i Sakaliyas. Negaip da enù ka minelugay dalem sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Egoh di miglesut, endà dé egpekeikagi di diyà kenagda, huenan di netiigan da duen sa hinaa di igpehaa i Nemula. Egbunegan di kagda takà, enù ka nebuneg dé. ");
INSERT INTO mta_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na, egoh di neubus sa pasad di eggalebek diyà sa Dalesan i Nemula, miglikù Sakaliyas i diyà sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Agulé, melugaylugay pa kedu iya, egkelalingen sa sawa di si Ilisabét, owoy takà eg-ugpà diatas taman lima gebulan. Iya sa kagi di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Siini egtebow diyà kenak binaelan i Datù enù ka eghiduwan di aken, owoy kinedanan di dé sa kekemala ku diyà sa medoo duma ku.” ");
INSERT INTO mta_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Agulé, neuma dé enem gebulan egoh i Ilisabét eg-obol, sinugù i Nemula Gabiyél i eg-angay dutu menuwa Nasalét dò diyà uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Duen sa sebaen kenogon eg-ugpà dahiya, si Maliya. Minesebayal da si Hosé, sa tugod i Datù Dabid. ");
INSERT INTO mta_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na, egoh i Gabiyél migtebow diyà si Maliya, guwaen di, “O Okon, meanggan ka dé enù ka hinemilì i Nemula kuna owoy medapag sa pedu i Nemula diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Dodoo egkebukul temù Maliya i danà iya wé inikagi i Gabiyél owoy egtakaan di egpenemdem sa selepangan di. ");
INSERT INTO mta_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Agulé guwaen sa egsugùsuguen i Nemula, “Yaka egkelimedangan na, Maliya, enù ka tinunungan ka danà i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Taa ko, kumelalingen ka dé owoy umanak ka maama. Iya sa pengadani ko, si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kagdi sa dakel etaw lumalag owoy kagdi sa Anak i Nemula, sa tigtu Nemula eglowon diyà langun. Ibegay i Datù Nemula diyà kenagdi sa kedatù i Dabid sa tupù di. ");
INSERT INTO mta_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kumedatù diyà sa langun Hudiyu tugod i Hakob taman endà meelut di. Endà duen ketamanan sa hagdi kedatù.” ");
INSERT INTO mta_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Agulé, guwaen i Maliya diyà sa egsugùsuguen i Nemula, “Enù kebaluy ini i eg-ikagiyen ko? Enù ka endà pa duen maama nekeuma sa lawa di diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Guwaen sa egsugùsuguen i Nemula, “Tumenà sa Metiengaw Suguy i Nemula diyà keniko, owoy melunog ka sa tunung i Nemula, sa tigtu Nemula eglowon diyà langun. Iya maen di ya metiengaw sa anak ko lumesut owoy kagdi sa Tigtu Anak i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na, taa ko sa duma telahadi ko si Ilisabét. Apiya di pa lukes dé owoy tapay dé endà egpekeanak, egkelalingen doo eg-obol maama enem gebulan dé ini egoh di. ");
INSERT INTO mta_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Enù ka amuk si Nemula, anan meketuu sa langun egbaelan di.” ");
INSERT INTO mta_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Agulé guwaen i Maliya, “Taa ko, aken sa etaw egpangunut diyà si Datù. Mepion amuk meketuu diyà kenak iya wé tinulon ko.” Agulé, sinalidan sa egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Agulé, endà melugay di kedu iya, miglegkang Maliya i owoy migpetééltéél eg-angay diyà sa sebaen menuwa diyà sa getan-getan diyà uwang Hudiya. ");
INSERT INTO mta_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Egoh di migtebow dahiya, miggemow diyà sa dalesan i Sakaliyas owoy saluan di Ilisabét i. ");
INSERT INTO mta_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hê, egoh i Ilisabét egdineg sa kesalù i Maliya, egtabed sa batà diyà sa getek di. Linuhub Ilisabét i sa Metiengaw Suguy i Nemula, ");
INSERT INTO mta_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","owoy pinetaled di sa kagi di, guwaen di, “O Maliya, diyà langun bayi diyà tanà, kuna daa sa tigtu tinunungan i Nemula owoy tinunungan ma sa batà lumesut diyà keniko. ");
INSERT INTO mta_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Egkegaip a, enù ka endà egketiigan ku duu sa pesuwan di eg-angay diyà kenak sa inay i Datù ku enù ka tukééy a etaw aken i. ");
INSERT INTO mta_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Taa ko, egoh ku migdineg sa kesalù ko, egtabed sa eg-obolen ku danà di egkeanggan. ");
INSERT INTO mta_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tinunungan ka, enù ka pinigtuu ko metuu sa inikagi i Datù diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Agulé guwaen i Maliya, “Egpedakelen sa pedu ku si Datù, ");
INSERT INTO mta_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","owoy megaen sa pusung ku danà i Nemula sa eg-aluk kenak. ");
INSERT INTO mta_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Apiya tukééy a etaw, netulengan di aken. Taa ko, edung ini egoh metulengan sa langun etaw aken owoy guwaen da, ‘Tinunungan Maliya i.’ ");
INSERT INTO mta_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Iya maen di ya enù ka dakel sa binaelan i Nemula diyà kenak. Mekegaga temù kagdi i owoy tigtu metiengaw. ");
INSERT INTO mta_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Eghiduwan di sa langun etaw eg-adat kenagdi edung egoh anay taman melugay. ");
INSERT INTO mta_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Igpehaa di sa dakel egkegaga di danà sa binaelan di, owoy pinepelaguy di sa medoo egpedakelen da kagda diyà sa pedu da. ");
INSERT INTO mta_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pinetukééy di sa medoo dakel datù, owoy pinedakel di sa medoo tukééy etaw. ");
INSERT INTO mta_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Binegayan di mepion sa medoo etaw egpeketues anì mebesug da, dodoo hinemagawan di sa medoo etaw kawasà owoy endà duen igbegay di inuwit da. ");
INSERT INTO mta_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Tinabangan di sa medoo tugod i Islaél enù ka netulengan di sa igpasad di diyà sa medoo tupù ta. Tinulon di sa kehidu di diyà si Ablaham owoy diyà sa langun tugod di taman melugay.” ");
INSERT INTO mta_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Agulé, miglengen Maliya i diyà sa kenà i Ilisabét taman telu gebulan. Agulé miglikù diyà sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na, egoh di neuma sa agdaw i Ilisabét eglesutan, maama sa inanak di. ");
INSERT INTO mta_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Egoh di eg-anak, dinineg sa medoo duma di sa dakel kehidu i Datù Nemula kenagdi. Agulé, neseunut da egkeanggan si Ilisabét. ");
INSERT INTO mta_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Agulé egoh di walu dé agdaw miglesut, nesetipon diatas sa medoo duma da anì pekelaingen da sa ipat sa batà owoy begayan da ngadan di, enù ka inunutan da sa tapay adat Hudiyu. Ungayà da peingadanan da si Sakaliyas, enù ka iya ngadan sa emà di. ");
INSERT INTO mta_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Dodoo guwaen i Ilisabét, “Beken iya wé. Ingadanan ta polo si Huwan.” ");
INSERT INTO mta_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“Maen di ya?” guwaen sa medoo duma di, “Endà duen duma yu épê iya wé ngadan.” ");
INSERT INTO mta_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Agulé, binunegan da sa emà di eg-igsà sa kepengadan di sa batà. ");
INSERT INTO mta_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Egbunegan di ma kagda egpebegay egsulatan di, owoy iya sa igsulat di, “Si Huwan sa ngadan di.” Hê, negaip da langun. ");
INSERT INTO mta_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Agulé, nekedan dé sa kekebuneg di, owoy mig-ikagi ma eg-olò si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Agulé, nelenawan sa langun duma da. Nekeseluh dé iya wé lalag diyà sa langun etaw diyà siedò getan-getan diyà uwang Hudiya, enù ka takà da egseolomoy sa ukit-ukit sa kelesut i Huwan. ");
INSERT INTO mta_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Langun sa migdineg, inipat da diyà sa pedu da sa ukit-ukit di, owoy guwaen da, “Dakel temù kéen sa ketamanan ini batà.” Iya sa kagi da enù ka tinunungan i Nemula Huwan i. ");
INSERT INTO mta_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Agulé, linuhub Sakaliyas i sa Metiengaw Suguy i Nemula. Hê, migsugkow, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Egpekeolò ki si Nemula sa Datù ta, kita i medoo tugod i Islaél, enù ka migpedapag diyà kenita owoy inalukan di kita. ");
INSERT INTO mta_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pineangay di diyà kenita sa tegealuk tigtu mekegaga. Kagdi sa sebaen tugod i Dabid migpangunut diyà si Nemula egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Igpasad i Nemula sa tegealuk egoh anay danà sa medoo tegesugkow di metiengaw, enù ka guwaen i Nemula ");
INSERT INTO mta_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","alukan di kita kedu diyà sa egkegaga sa medoo egkuntelà kenita. ");
INSERT INTO mta_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Eghiduwan di doo kita, enù ka iya sa igpasad di diyà sa medoo tupù ta, owoy endà melipengan di duu sa tigtu tuu igpasad di diyà kenita. ");
INSERT INTO mta_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Pinengibetngibetan di sa pasad di diyà si Ablaham tupù ta egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iya sa igpasad di alukan di kita kedu sa medoo kuntelà ta anì endà melimedangan ki mangunut diyà kagdi. ");
INSERT INTO mta_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Iya maen di ya anì metiengaw sa pedu ta owoy metudà sa adat ta diyà sa kehaa di taman sa lugay ta nehagtay. ");
INSERT INTO mta_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","O anak ku, melugaylugay pa kuna sa tegesugkow i Nemula, sa Nemula tigtu eglowon diyà langun. Mekehuna ka si Datù anì abung-abungan ko sa ukitan di tumebow. ");
INSERT INTO mta_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Enù ka ipetiig ko diyà sa medoo etaw di sa kealuk di kenagda danà sa kepeuloy di sa medoo salà da. ");
INSERT INTO mta_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mekegaga ka iya wé enù ka tigtu eghiduwan i Nemula kita. Lagà teleséng agdaw sa ketebow di eg-aluk kenita, ");
INSERT INTO mta_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","enù ka pelegdawan di kita apiya di pa lagà ki sa etaw eg-ugpà diyà deleman owoy lagà ki ma nematay danà sa kepigtamay i Nemula kenita. Iya maen di ya anì ipehaa di diyà kenita sa ukit pedu ta tumanà.” ");
INSERT INTO mta_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na, miglenuk Huwan i owoy migketudà sa pedu di diyà si Nemula. Agulé, mig-ugpà dutu siedò melabel tanà mediyù dalesan taman endà tumebow sa agdaw di lumalag diyà sa medoo tugod i Islaél. ");
INSERT INTO mta_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na, egoh i Hésus buyu lumesut, si Sisal Agustu sa sulutan diyà Loma. Sinugù di sa langun balangan etaw di taman sa uwang tanà di anì isulat da sa ngadan da diyà sa medoo libelu di anì bilangen di sa etaw di. ");
INSERT INTO mta_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Egoh siini anay igsugù i Sulutan Agustu denu sa kesulat da sa ngadan da, si Kiliniyu sa salu i Agustu eg-ipat sa uwang Siliya. ");
INSERT INTO mta_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Na, egpelikù sa uman sebaen etaw mig-angay diyà sa tapay menuwa sa emà da anì isulat da sa ngadan da diyà sa medoo libelu. ");
INSERT INTO mta_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Mig-ipanaw ma Hosé i owoy sa bayi binayal di, si Maliya, anì isulat da ma sa ngadan da. Miglegkang da diyà menuwa Nasalét diyà uwang Galiliya owoy mig-angay da dutu Bétlihém dò diyà uwang Hudiyu, enù ka iya sa tapay menuwa i Datù Dabid sa tupù da. Na, egoh da mig-ipanaw eg-angay Bétlihém dò, obol dé Maliya i. ");
INSERT INTO mta_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Agulé, egoh da dutu Bétlihém dò, neuma dé sa agdaw di eglesutan. ");
INSERT INTO mta_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hê, mig-anak maama Maliya i, owoy iya sa lebì lawa di. Binekut di ginis owoy igtenà di diyà sa toyowon kaenen sapì. Migtudug da diyà sa dalesan sapì enù ka nebelet etaw sa dalesan atung petudugan etaw kedu mediyù. ");
INSERT INTO mta_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, egoh i Hésus eglesut, duen diyà uwang Bétlihém medoo maama tegeipat sa medoo kebilibili. Eg-ugpà da dutu siedò keluwenluwen kenà da egpetabtab kebilibili. Apiya sigep dé, egtulikan da doo sa medoo kebilibili da. ");
INSERT INTO mta_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hê, duen sa egsugùsuguen i Nemula migpehaa diyà kenagda, owoy nelegdawan da sa senang i Nemula. Temù da nelimedangan. ");
INSERT INTO mta_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Dodoo guwaen sa egsugùsuguen di diyà kenagda, “Yoko egkelimedangan na. Taa yu, mepion temù siini egtulonen ku diyà keniyu enù ka mekepion pedu sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Siini sigep duen sa batà maama miglesut diyà menuwa Bétlihém sa tapay menuwa i Dabid. Kagdi sa atung umaluk keniyu denu sa medoo salà yu, owoy kagdi si Kelistu sa Tigtu Datù pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Na, iya sa tandà di anì kilalaen yu, sa batà binekut ginis igtenà diyà sa toyowon kaenen sapì.” ");
INSERT INTO mta_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hê, melugay pa silà netipon diyà kenagdi sa melaweng duma di egsugùsuguen i Nemula. Eg-oloen da Nemula i, guwaen da, ");
INSERT INTO mta_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Meolò Nemula i dutu langit dò. Tumanà ma sa pedu sa medoo etaw diyà tanà sa egketaguan sa pedu di.” ");
INSERT INTO mta_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Agulé, egoh sa medoo egsugùsuguen i Nemula miglikù langit dò, migseikagiyay sa medoo tegeipat kebilibili, guwaen da, “Mangay ki dé Bétlihém dò anì hauwen ta sa batà miglesut igpetiig i Datù diyà kenita.” ");
INSERT INTO mta_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Agulé, migpetééltéél da eg-angay dutu. Egoh da migtebow, hinaa da Maliya i owoy si Hosé owoy sa batà igtenà diyà sa toyowon kaenen sapì. ");
INSERT INTO mta_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Egoh da mighaa sa batà, tinulon da sa denu sa batà dinineg da diyà sa egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Negaip sa langun etaw egdineg danà sa tinulon sa medoo tegeipat kebilibili. ");
INSERT INTO mta_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Dodoo, igtagù i Maliya sa kagi da diyà sa pedu di owoy takaan di egpenemdem sa inikagi da. ");
INSERT INTO mta_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Agulé miglikù sa medoo tegeipat kebilibili. Egoh da miglikù, inolò da temù Nemula i danà sa dinineg da owoy sa hinaa da enù ka neketuu. ");
INSERT INTO mta_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Agulé, egoh di walu dé agdaw miglesut sa batà, pinekelaing da sa ipat di owoy binegayan da ngadan di, enù ka inilingan da sa adat Hudiyu. Si Hésus sa pinengadanan da enù ka iya sa kinepengadan sa egsugùsuguen i Nemula egoh i Maliya endà pa egkelalingen. ");
INSERT INTO mta_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Agulé, melugaylugay pa kedu iya, neuma sa pasad da eg-angay diyà sa tegesimbà diyà sa Dalesan i Nemula diyà Hélusalém. Inuwit da sa batà eg-angay dutu, enù ka egpangunutan da sa uledin igsugkow i Mosis. Igpehaa da sa batà diyà sa tegesimbà anì isalig da diyà si Nemula, enù ka iya sa uledin i Nemula igpesulat, “Mekesalig diyà si Nemula sa langun maama muna lumesut anì meipat da sa langun uledin di.” Ini ma sa binaelan da dutu danà sa igsugù i Nemula, ibegay da sa duwa melipati diyà sa tegesimbà anì ulowen di diyà si Nemula. Iya maen di ya enù ka pelanihen da diyà sa kehaa i Nemula sa bayi magtu mig-anak. ");
INSERT INTO mta_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, duen sa maama tegeHélusalém, si Simiyon. Kagdi sa metiengaw etaw owoy eg-udesan di sa medoo igsugù i Nemula. Eg-angat-angat ma sa ketebow sa Tigtu Datù pineangay i Nemula, sa umaluk sa medoo tugod i Islaél. Eg-ugpaan sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nelugay dé igpetiig sa Metiengaw Suguy i Nemula diyà kenagdi endà mematay di taman endà hauwen di duu sa Tigtu Datù pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Agulé, danà sa Suguy i Nemula mig-angay Simiyon i diyà sa Dalesan i Nemula. Dahiya dé egoh i Hosé owoy si Maliya mig-uwit si Hésus dalem anì umunut da sa adat da denu sa uledin i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Agulé, sinepipi i Simiyon sa batà owoy inolò di Nemula i, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Datù Nemula, mepion dé amuk mematay a enù ka migtanà dé sa pedu ku. ");
INSERT INTO mta_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ini egoh di neketuu sa igpasad ko diyà kenak enù ka nekehaa sa mata ku sa ialuk ko. ");
INSERT INTO mta_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Hinemilì ko kagdi i anì ipehaa ko diyà sa langun balangan etaw. ");
INSERT INTO mta_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kagdi sa legdaw diyà sa medoo etaw beken Hudiyu anì mekehaa da sa ukitan da mangay diyà keniko. Huenan di, lumalag ké kami i etaw ko tugod i Islaél danà sa lalag di.” ");
INSERT INTO mta_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Agulé, negaip sa emà di owoy sa inay di danà sa inikagi i Simiyon denu si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Agulé, migsimbà Simiyon i anì tabangan i Nemula kagda. Mig-ikagi ma diyà si Maliya, sa inay sa batà, guwaen di, “Taa ko, ini sa metamanan siini batà danà i Nemula. Mebaed sa medoo tugod i Islaél danà sa penemdem da denu kenagdi. Dumuen medoo mekesugsug danà da eg-eked kenagdi, dodoo medoo ma sa kumelalù danà da egpigtuu diyà kenagdi. Kagdi sa itepeng i Nemula sa medoo etaw. Medoo da tumipu kenagdi anì mehaa sa penemdem diyà sa pedu da. Mebukul ka ma temù, Okon, enù ka lagà egtepiyen kelu sa kesakit sa pedu ko.” ");
INSERT INTO mta_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Na, duen ma diyà sa Dalesan i Nemula sa tegesugkow i Nemula bayi. Iya sa ngadan di, si Ana. Kagdi sa anak i Panuél sa duma tugod i Asél. Lukes temù siini bayi balu enù ka walu pulù owoy epat gepalay dé, owoy pitu gepalay daa sa lugay di épê sawa. Uman agdaw owoy uman sigep eg-ugpà diyà sa Dalesan i Nemula enù ka takà eg-olò si Nemula. Egtakaan di ma egpeulan sa kekaen di anì sumimbà. ");
INSERT INTO mta_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Agulé, egoh i Simiyon eg-ikagi pelà diyà si Maliya, migtebow ma Ana i diyà kenagda. Migpesalamat diyà si Nemula denu sa batà. Agulé, egtulon ma sa denu sa batà diyà sa langun tegeHélusalém eg-angat-angat sa kealuk i Nemula kenagda. ");
INSERT INTO mta_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Na, egoh i Hosé owoy si Maliya neubus da migpangunut diyà sa uledin i Datù igsugkow i Mosis denu sa batà magtu miglesut, miglikù da dutu menuwa Nasalét dò diyà uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Agulé, miglenuk Hésus i owoy migkebagel ma owoy kumelabel ma sa penemdem di danà i Nemula migtabang kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na, uman segepalay amuk meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, mig-angay egpista sa emà i Hésus owoy sa inay di dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Agulé, egoh i Hésus sepulù owoy duwa dé gepalay, mig-angay da dema dutu, enù ka iya sa adat da. ");
INSERT INTO mta_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na, egoh di neubus sa pista, mig-ipanaw da miglikù, dodoo mig-ugpà polo Hésus i diyà Hélusalém. Endà netiigan sa lukes di sa egoh di eg-ugpà, ");
INSERT INTO mta_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","enù ka iya sa antap da eg-unut ma diyà sa medoo duma da eg-ipanaw. Egoh da segeagdaw dé diyà dalan, linagbet da Hésus i diyà sa medoo duma da, ");
INSERT INTO mta_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","dodoo endà hinaa da duu. Agulé, pinelikuan da eglagbet dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Agulé, egoh di neuma telu agdaw, hinaa da kagdi diyà sa Dalesan i Nemula. Migpenuu diyà sa kenà sa medoo tegetulù, owoy egdinegdinegen di sa egseolomen da owoy takaan di ma kagda eg-igsà. ");
INSERT INTO mta_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Negaip sa langun etaw migdineg sa inikagi di danà sa medoo netiigan di owoy sa igsagbì di ma mepion. ");
INSERT INTO mta_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Na, egoh sa inay di owoy sa emà di mighaa kenagdi, negaip da ma owoy sinigbolow sa inay di, guwaen di, “O Adug, ngadan iya wé egbaelan ko diyà kenami? Egkebukul ké eglagbet keniko enù ka endà hinaa ka.” ");
INSERT INTO mta_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Guwaen i Hésus, “Maen di ya takà yu eg-amu eglagbet kenak? Maen di ya endà netiigan yu duu egpekeugpà a dahini diyà sa dalesan sa Emà ku?” ");
INSERT INTO mta_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Dodoo endà netiigan da duu sa igsagbì di diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Agulé, mig-unut dema Hésus i kenagda eglikù Nasalét dò, owoy iya sa adat di takaan di kagda egpangunutan. Hê, igtagù sa inay di diyà sa pedu di sa langun binaelan di. ");
INSERT INTO mta_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na, migkedakel Hésus i owoy migkelabel ma sa penemdem di. Eg-uman egketuuwan Nemula i owoy sa medoo etaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Na, nelugay dé kedu iya, mig-edung Huwan i anak i Sakaliyas sa ketegudon di diyà sa medoo Hudiyu. Egoh iya, sepulù owoy lima gepalay dé sa lugay di sulutan si Sulutan Sisal Tibeliyu sa sambì i Sulutan Sisal Agustu, owoy si Ponkiyu Pilatu sa gubilenu diyà uwang Hudiya. Duen ma telu salu i Sulutan Tibeliyu beken etaw Hudiyu diyà sa telu tanà eg-abay diyà sa tanà Hudiya. Si Hélod sa salu di diyà uwang Galiliya, owoy si Pilipi hadi i Hélod sa salu di diyà uwang Ituliya owoy Telakonitu, owoy si Lisaniyas sa salu di diyà uwang Abilina. ");
INSERT INTO mta_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na, egoh iya ma, si Anas owoy si Kayipas sa Tigtu Ulu-ulu Tegesimbà. Na, egoh i Huwan mig-ugpà dutu siedò melabel tanà mediyù dalesan, migtebow sa kagi i Nemula diyà kenagdi anì sumugkow. ");
INSERT INTO mta_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Agulé, mig-ipanawpanaw Huwan i egtegudon diyà uwang lawa Holdan. Iya sa tegudon di igpeges di diyà sa medoo etaw, guwaen di, “Ekedi yu sa medoo salà yu owoy pebautis yu diyà wayeg anì tandaan yu sa keeked yu salà, owoy ipeuloy i Nemula sa medoo salà yu.” ");
INSERT INTO mta_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na, si Huwan sa igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, “Dumuen sa maama mikagi metaled dutu siedò melabel tanà mediyù dalesan. Iya sa guwaen di, ‘Abung-abungi yu sa ukitan i Datù tumebow. Petudà yu sa medoo dalan di. ");
INSERT INTO mta_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Penù yu tanà sa langun baug owoy kedani yu sa langun kogol getan anì mesepatag. Petudà yu sa langun logkù dalan owoy pelanih yu sa langun dalan duhelduhel ");
INSERT INTO mta_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","anì hauwen sa langun etaw sa ialuk i Nemula.’” ");
INSERT INTO mta_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Na, egoh sa etaw migdineg sa igtulù i Huwan, mig-angay sa melaweng etaw diyà kenagdi anì egpebautis da diyà wayeg. Agulé guwaen i Huwan, “Lagà yu medoo uled. Negaip a maen di ya eg-angay yu diyà kenak. Iya sa penemdem yu daa kéen, egpelaguy yu sa kepigtamay i Nemula tumebow. ");
INSERT INTO mta_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Amuk tuu sa keeked yu sa salà yu, sambii yu sa adat yu anì kumepion. Amuk hediya, lagà yu sa kayu mepion kebunga. Dodoo yoko egpenemdem duu mekeiwod yu sa kepigtamay i Nemula keniyu. Apiya kiyu sa tugod i Ablaham, pigtamayan i Nemula doo kiyu amuk endà sambian yu sa adat yu. Apiya meimet di kiyu migtamay, mekehaa pa Nemula i sa isambì di sa tugod i Ablaham. Mebaluy tugod i Ablaham siini medoo batu amuk iya sa uyot i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Taa yu, igpeayaw dé sa agsà diyà sa kayu. Sumalà dé sa kayu endà egbunga mepion, pilayen owoy ulowen.” ");
INSERT INTO mta_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Agulé, inigsaan sa melaweng etaw, guwaen da, “Amuk hediya, ngadan sa mebaelan ké anì sumambì ké sa adat ké?” ");
INSERT INTO mta_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Migsagbì Huwan i, guwaen di, “Amuk duen duwa kawal ko, begayi ko sa sebaen diyà sa etaw endà duen. Amuk duen sa kaenen ko, iya ma sa baeli ko.” ");
INSERT INTO mta_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duen ma maama dahiya atung egpeetuken sa sulutan mig-angay diyà si Huwan anì egpebautis diyà wayeg. Guwaen da, “Enù di ya, ngadan sa mebaelan ké ma kami i?” ");
INSERT INTO mta_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Migsagbì Huwan i, guwaen di, “Yoko egpesubela sa keetuk yu.” ");
INSERT INTO mta_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mig-igsà ma sa medoo sundalu diyà kenagdi, guwaen da, “Enù di ya, ngadan sa mebaelan ké ma kami i?” Guwaen di diyà kenagda, “Yoko egtegel duu sa medoo etaw danà sa kesundalu yu. Yoko ma egtipu sa etaw endà duen salà di. Yoko eg-alum duu sa sukay yu.” ");
INSERT INTO mta_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na, egketéél sa pedu sa medoo etaw danà sa ketegudon i Huwan, enù ka sa antap da buyu dé tumebow sa Tigtu Datù pineangay i Nemula. Iya ma sa egsesigbolowen da diyà sa pedu da ataw ka si Huwan sa Tigtu Datù eg-angat-angatan da ataw ka beken. ");
INSERT INTO mta_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Huenan di inikagiyan i Huwan kagda, guwaen di, “Tumebow pa sa temù eglowon diyà kenak. Amuk tumebow, mekelilang a owoy memalaan a ma dumapag kenagdi lumengà sa talumpà di. Wayeg daa sa ibautis ku keniyu, dodoo sa etaw mekesambì kenak, iya polo sa ibautis di keniyu sa Metiengaw Suguy i Nemula owoy apuy. ");
INSERT INTO mta_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Siedò maama tumebow lagà sa maama buyu etapen di sa palay inelik di. Tiponen di sa palay owoy itagù di diyà sa sibay di, dodoo ulowen di sa opoh di diyà sa apuy endà mepadeng.” ");
INSERT INTO mta_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hediya ma sa medoo kagi i Huwan egpeges sa medoo etaw egoh di migtulù kenagda sa Mepion Tegudon. ");
INSERT INTO mta_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hê, endà nelugay di kedu iya, nebilanggu Huwan i danà i Datù Hélod sa eg-ipat sa uwang Galiliya. Iya maen di ya enù ka inindaw i Huwan Hélod i danà di mig-agaw si Hélodiyas sa sawa hadi di, owoy danà sa medoo medaet binaelan di ma. ");
INSERT INTO mta_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iya ma sa tigtu salà di sa egoh di egbilanggu si Huwan. ");
INSERT INTO mta_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Na, egoh i Huwan endà pa nebilanggu di, medoo sa etaw migpebautis diyà wayeg anì tandaan da sa kepigtuu da, owoy migpebautis ma Hésus i. Egoh di miggaun kedu dalem sa wayeg, egsimbà Hésus i. Hê, neukaan sa langit ");
INSERT INTO mta_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","owoy migpetuntun sa Metiengaw Suguy i Nemula diyà kenagdi. Egoh di egpetuntun, migpeiling manuk éhê menatad. Agulé duen ma eg-ikagi kedu langit dò, guwaen di, “Kuna sa anak ku eghiduwan ku temù. Tigtu a netuuwan diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na, egoh i Hésus mig-edung sa ketegudon di, labi telu pulù gepalay dé sa egoh di miglesut. Iya sa penemdem sa medoo etaw kagdi sa anak i Hosé daa. Na, ini sa medoo tupù i Hosé. Umemà Hosé i si Héli. ");
INSERT INTO mta_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Umemà Héli i si Matat. Umemà Matat i si Lebi. Umemà Lebi i si Mileki. Umemà Mileki i si Hana. ");
INSERT INTO mta_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Umemà Hana i si Hosé. Umemà Hosé i si Matatiyas. Umemà Matatiyas i si Amos. Umemà Amos i si Nahum. Umemà Nahum i si Isli. Umemà Isli i si Nagay. ");
INSERT INTO mta_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Umemà Nagay i si Maat. Umemà Maat i si Matatiyas. Umemà Matatiyas i si Sémei. Umemà Sémei i si Hosé. Umemà Hosé i si Hoda. ");
INSERT INTO mta_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Umemà Hoda i si Hoanan. Umemà Hoanan i si Lésa. Umemà Lésa i si Sélubabel. Umemà Sélubabel i si Salatiél. Umemà Salatiél i si Neli. ");
INSERT INTO mta_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Umemà Neli i si Mileki. Umemà Mileki i si Adi. Umemà Adi i si Kosam. Umemà Kosam i si Ilemadam. Umemà Ilemadam i si Il. ");
INSERT INTO mta_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Umemà Il i si Hosuwa. Umemà Hosuwa i si Iliyasal. Umemà Iliyasal i si Holim. Umemà Holim i si Matat. Umemà Matat i si Lebi. ");
INSERT INTO mta_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Umemà Lebi i si Simiyon. Umemà Simiyon i si Huda. Umemà Huda i si Hosé. Umemà Hosé i si Honam. Umemà Honam i si Iliyakim. ");
INSERT INTO mta_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Umemà Iliyakim i si Meleya. Umemà Meleya i si Mena. Umemà Mena i si Matata. Umemà Matata i si Natan. Umemà Natan i si Dabid. ");
INSERT INTO mta_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Umemà Dabid i si Hési. Umemà Hési i si Obéd. Umemà Obéd i si Boos. Umemà Boos i si Salmon. Umemà Salmon i si Naason. ");
INSERT INTO mta_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Umemà Naason i si Aminadab. Umemà Aminadab i si Admin. Umemà Admin i si Alni. Umemà Alni i si Islon. Umemà Islon i si Palés. Umemà Palés i si Huda. ");
INSERT INTO mta_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Umemà Huda i si Hakob. Umemà Hakob i si Isak. Umemà Isak i si Ablaham. Umemà Ablaham i si Tala. Umemà Tala i si Nakol. ");
INSERT INTO mta_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Umemà Nakol i si Sélug. Umemà Sélug i si Lagaw. Umemà Lagaw i si Pélég. Umemà Pélég i si Ibél. Umemà Ibél i si Sélah. ");
INSERT INTO mta_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Umemà Sélah i si Kayinan. Umemà Kayinan i si Alpakad. Umemà Alpakad i si Sém. Umemà Sém i si Nuwi. Umemà Nuwi i si Lamék. ");
INSERT INTO mta_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Umemà Lamék i si Matusalen. Umemà Matusalen i si Inok. Umemà Inok i si Haled. Umemà Haled i si Mahalalél. Umemà Mahalalél i si Kayinan. ");
INSERT INTO mta_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Umemà Kayinan i si Inos. Umemà Inos i si Sét. Umemà Sét i si Adam. Umemà Adam i si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, egoh i Hésus miglikù kedu diyà sa lawa Holdan kenà di migpebautis, linuhub sa Metiengaw Suguy i Nemula. Agulé, inuwit sa Suguy i Nemula ");
INSERT INTO mta_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","eg-angay dutu siedò melabel tanà mediyù dalesan. Na, epat pulù agdaw sa lugay i Hésus dutu, owoy iya ma sa lugay i Satanas egtepeng si Hésus anì mekesalà. Agulé, egpeketues temù Hésus i enù ka epat pulù agdaw ma sa lugay di endà duen kaenen di. ");
INSERT INTO mta_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na, guwaen i Satanas, “Amuk kuna sa Tigtu Anak i Nemula, baluy ko kaenen siini batu anì mekedan sa kelikutan ko.” ");
INSERT INTO mta_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Dodoo migsagbì Hésus i, guwaen di, “Meked a iya wé, enù ka iya sa kagi i Nemula igpesulat, ‘Endà mepion di amuk kaenen daa sa pedakelen etaw.’ ” ");
INSERT INTO mta_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Agulé, inuwit i Satanas Hésus i diyà sa kogol getan mehagtaw owoy igpehaa di diyà kenagdi segepelàpelà daa sa langun kedatuan sa langun datù diyà tanà. ");
INSERT INTO mta_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Guwaen i Satanas, “Iya sa uyot ku ibegay ku diyà keniko siini langun hinaa ko. Niko pa sa langun egkegaga siini medoo datù owoy sa langun taman da. Mebaluy ibegay ku iya wé enù ka tapay nekebegay diyà kenak, owoy muni dé diyà kenak sa begayan ku. ");
INSERT INTO mta_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amuk penemulawen ko aken, niko langun iya wé.” ");
INSERT INTO mta_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Dodoo migsagbì Hésus i, guwaen di, “Meked a iya wé, enù ka iya sa kagi i Nemula igpesulat, ‘Si Datù Nemula daa sa penemulawen ké. Kagdi daa sa mepangunutan ké.’ ” ");
INSERT INTO mta_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Agulé, inuwit i Satanas Hésus i dutu Hélusalém dò owoy igtagù di diyà sa buung sa Dalesan i Nemula. Guwaen i Satanas, “Amuk kuna sa Tigtu Anak i Nemula, laway ka anì mehaa sa tunung i Nemula ");
INSERT INTO mta_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","enù ka iya sa kagi i Nemula igpesulat, guwaen di, ‘Igsalig di kuna diyà sa medoo egsugùsuguen di anì tulikan da kuna.’ ");
INSERT INTO mta_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iya ma sa igpesulat di, ‘Selangawen da kuna anì endà mekesiud ka diyà batu.’ ” ");
INSERT INTO mta_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Dodoo migsagbì Hésus i, guwaen di, “Meked a enù ka iya sa kagi i Nemula igpesulat, guwaen di, ‘Yaka egtepeng duu Datù Nemula i.’ ” ");
INSERT INTO mta_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na, egoh di neubus sa langun penemdem i Satanas igtepeng diyà si Hésus, migsalid dé taman endà meuma sa egoh di tumepeng kenagdi uman. ");
INSERT INTO mta_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, miglikù Hésus i dutu uwang Galiliya dò owoy tinunungan sa Suguy i Nemula. Huenan di, nekeseluh sa lalag di diyà sa langun etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Migtulù ma diyà sa medoo simbaan Hudiyu diyà uwang Galiliya, owoy inolò sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Agulé, miglikù Hésus i dutu siedò tapay menuwa di Nasalét. Egoh di neuma Sapetu sa agdaw keetud da, mig-angay Hésus i diyà sa simbaan da enù ka iya sa adat di. Agulé, migtigdeg anì masa sa kagi i Nemula igpesulat. ");
INSERT INTO mta_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Igtayal da diyà kenagdi sa libelu igsulat i Isayas, sa tegesugkow i Nemula egoh anay. Bekahen di sa libelu, hinaa di sa egbasawen di. Guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sa Suguy i Datù Nemula eg-ugpà diyà kenak, enù ka hinemilì di aken anì itulù ku sa Mepion Tegudon diyà sa medoo etaw pubeli. Pinesugkow i Datù aken diyà sa medoo etaw sinabaan anì tulonen ku kenagda sa ukit kelengà di. Pinesugkow a ma diyà sa medoo langap anì tulonon ku kagda sa ukit kepeilag i Datù. Sinugù di ma aken anì alukan ku sa medoo egpelihayen, ");
INSERT INTO mta_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","anì tulonon ku ma egtebow dé sa pasad i Datù eg-aluk sa medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Agulé, egoh i Hésus neubus egbasa, tinigem di sa libelu owoy igpelikù di diyà sa maama eg-ipat. Agulé migpenuu anì egtulù. Hê, egketiponon mata sa langun etaw Hésus i, ");
INSERT INTO mta_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","huenan di mig-edung egtulù, guwaen di diyà kenagda, “Siini agdaw ini egoh, neketuu dé sa kagi i Nemula binasa ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Agulé, inolò da Hésus i danà sa kagi di anan metudà owoy melanih. Dodoo negaip da ma, guwaen da, “Kagdi doo sa duma ta anak i Hosé. Keduwan di ya siini keikagi di mebagel?” ");
INSERT INTO mta_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na, netiigan i Hésus neduwa sa pedu da, owoy guwaen di, “Apiya endà mikagi yu, ini sa eg-ikagiyen sa pedu yu egpelagà kenak, ‘O tegebulung, bulung ko sa medoo tigtu duma ko dahini anì eghauwen ké sa egkegaga ko.’ Iya sa guwaen yu enù ka ungayà yu ilingan ku diyà siini tigtu menuwa ku sa panduan binaelan ku dinineg yu dutu siedò menuwa Kapelenaum. ");
INSERT INTO mta_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dodoo endà mekeunut a sa uyot yu enù ka endà egpigtuu yu diyà kenak. Tuu ini i ikagiyen ku diyà keniyu, sumalà dé sa tegesugkow i Nemula, eg-ekedan sa medoo tapay duma di amuk mekeuma diyà sa tigtu menuwa di. ");
INSERT INTO mta_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Taa yu, hih. Egoh i Iliyas sa tegesugkow i Nemula, migtenà pengagdaw diyà sa tanà ta taman telu gepalay owoy tengà. Migtenà ma dakel bitil taman uwang siini tanà. Apiya di pa duen dahini medoo bayi balu etaw Hudiyu, ");
INSERT INTO mta_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pineangay i Nemula doo Iliyas i diyà sa menuwa Salépta diyà uwang Sidon. Iya daa sa etaw tinabangan di sa bayi balu beken etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hediya ma egoh i Ilisiya sa tegesugkow i Nemula, apiya di pa duen medoo etaw Hudiyu eglinadu dempid, iya daa polo sa binulungan di si Naman sa maama beken etaw Hudiyu diyà uwang Siliya.” ");
INSERT INTO mta_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Agulé, egoh sa medoo etaw Hudiyu diyà sa simbaan migdineg siini kagi i Hésus denu sa kehidu i Nemula sa etaw beken Hudiyu, migbulit da temù. ");
INSERT INTO mta_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Hê, petow da migtigdeg langun anì hemagawan da kedu diyà sa menuwa da. Na, diyà getan-getan sa kenà menuwa da, huenan di tinegel da eg-agak Hésus i diyà sa kesagdigan anì itinudul da. ");
INSERT INTO mta_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Dodoo migtelek polo teliwadà diyà sa medoo etaw. Hê sinalidan di dé kagda. ");
INSERT INTO mta_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Agulé, miglungel Hésus i mig-angay diyà sa menuwa Kapelenaum diyà uwang Galiliya. Egoh di neuma Sapetu sa agdaw keetud da, migtulù diyà sa simbaan da. ");
INSERT INTO mta_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Negaipan da enù ka dakel sa egkegaga di egtulù. ");
INSERT INTO mta_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, duen sa maama linahuk busaw diyà sa simbaan da. Hê, iglengatlengat di sa kagi di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O Hésus tegeNasalét, ngadan sa kebael ko kenami i busaw? Enù di ya, eg-angayen ko kami egpedaetan imet? Egkilalaen ku doo kuna sa Metiengaw Etaw Sinugù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dodoo hinawidan i Hésus, guwaen di, “Yaka dé egséléken na. Laun ka dé.” Hê, igdugsù sa busaw sa maama diyà teliwadà da owoy miglesut dé. Dodoo endà duen sa kenà di nedaetan sa lawa di. ");
INSERT INTO mta_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Agulé, negaip sa langun etaw, owoy egseolomoy da, guwaen da, “Maen di ya dakel sa egkegaga sa kagi di? Egsuguen di uloy egpelesut sa medoo busaw, owoy egpangunut da doo miglesut.” ");
INSERT INTO mta_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Agulé dinineg sa medoo etaw taman uwang Kapelenaum sa lalag sa medoo binaelan di. ");
INSERT INTO mta_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na, egoh i Hésus miglaun kedu diyà sa simbaan Hudiyu, miggemow diyà sa dalesan i Simon. Na, eglinadu sa nugangan i Simon bayi, huenan di egpegeni da tabang diyà si Hésus enù ka egkegenaw temù. ");
INSERT INTO mta_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Agulé, migtigdeg Hésus i medapag diyà sa bayi owoy hinawidan di sa kekegenaw di anì mekedan. Hê, petow dé nekedan. Agulé migtigdeg sa bayi owoy patuluy ma dé egmengana si Hésus owoy sa medoo duma di. ");
INSERT INTO mta_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Na, egoh di eg-eled dé sa agdaw, inuwit sa medoo etaw sa langun duma da eglinadu diyà si Hésus. Sinigbaenbaen di kagda migsabà, hê nelikuan da ma langun. ");
INSERT INTO mta_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Duen ma busaw pinelesut di diyà sa medoo etaw inuwit da diyà kenagdi. Egoh da eglesut, eglengat da, guwaen da, “Kuna sa Anak i Nemula.” Dodoo hinawidan i Hésus kagda anì endà mikagi da, enù ka netiigan da kagdi sa Tigtu Datù pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Agulé, umenaw simag eg-angay eglebù Hésus i diyà sa kenà endà duen dalesan enù ka sumimbà. Dodoo linagbet sa medoo etaw Kapelenaum kagdi i. Egoh da mighaa kenagdi, hinawidan da anì endà sumalid di. ");
INSERT INTO mta_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Dodoo guwaen i Hésus, “Mangay a pa diyà sa medoo liyu menuwa anì tumulù a sa Mepion Tegudon denu sa kedatù i Nemula diyà sa medoo etaw, enù ka iya sa pesuwan ku pineangay a diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Agulé, takà migtegudon Hésus i diyà sa medoo simbaan Hudiyu diyà uwang Hudiya. ");
INSERT INTO mta_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Na, sebaen agdaw egoh i Hésus egtigdeg diyà mantadan sa lanaw Génésalét, egkesedeldel sa medoo etaw egdapag diyà kenagdi enù ka ungayà da mekedineg sa kagi i Nemula itulù di. ");
INSERT INTO mta_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Duen duwa kumpit hinaa di migdunggù dahiya, dodoo migtenà sa tegepuket enù ka egpeguséén da sa puket da. ");
INSERT INTO mta_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Agulé migdalem Hésus i diyà sa sebaen kumpit, sa kumpit i Simon Pidelu. Ipeilud di si Simon sa kumpit anì ipetangkàtangkà diyà sa mantadan. Agulé, migpenuu Hésus i egtulù diyà sa medoo etaw diyà mantadan. ");
INSERT INTO mta_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Egoh di neubus egtulù, guwaen i Hésus diyà si Simon, “Ilud ko diyà sa kenà di medalem owoy puket yu anì mekekuwa yu uton.” ");
INSERT INTO mta_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Dodoo migsagbì Simon i, guwaen di, “O Mistelu, endà mekekuwa ki kéen enù ka neelut ké sigep sa kepuket ké, dodoo endà egpekekuwa ké. Dodoo amuk iya sa igsugù ko, muket ké dema.” ");
INSERT INTO mta_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hê, egoh da migpuket, medoo temù sa sedà nekuwa da owoy buyu dé egkelisì sa puket da. ");
INSERT INTO mta_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kinobil da sa duma da diyà sa sebaen kumpit anì mangay da tumabang. Egoh da migtebow, pinenù da sedà sa duwa kumpit da taman buyu egketegeb. ");
INSERT INTO mta_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na, egoh i Simon Pidelu eghaa iya wé, egligkued diyà sa taengan i Hésus, owoy guwaen di, “O Datù, salidi ko dé aken, enù ka aken sa etaw tegebael salà.” ");
INSERT INTO mta_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Iya sa inikagi di enù ka tigtu negaip da sa medoo duma di danà sa medoo uton nekuwa da. ");
INSERT INTO mta_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hê, negaip ma Santiyago i owoy si Huwan, sa duwa anak i Sébediyu duma i Simon tegepuket. Dodoo guwaen i Hésus diyà si Simon, “Yaka egkelenawan na, enù ka edung ini egoh di beken sedà daa sa egkuwaen ko, dodoo etaw polo sa ipekuwa ku keniko.” ");
INSERT INTO mta_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na, egoh da migdunggù, sinalidan da dahiya sa langun taman ipaten da, owoy mig-unut da dé si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na, egoh i Hésus diyà sa sebaen menuwa diyà uwang Galiliya, duen dahiya sa maama eglinadu neseluh dempid sa lawa di. Egoh di mighaa si Hésus, migligkued owoy egpegeni, guwaen di, “O Datù, megaga ko kumedan siini linadu ku, amuk iya sa ungayà ko.” ");
INSERT INTO mta_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Agulé, binegeng i Hésus sa belad di owoy sinabaan di sa maama. Guwaen di, “Meiyap a doo. Haa ko, nelikuan ka dé.” Hê, petow dé nekedan sa linadu di dempid. ");
INSERT INTO mta_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Agulé, hinawidan i Hésus tumulon sa egoh di nelikuan. Sinugù di polo, guwaen di, “Angay ka pehaa diyà sa tegesimbà diyà sa Dalesan i Nemula, owoy begay ka hinagtay ya ulowen diyà si Nemula iling sa igsugù i Mosis denu sa kepelanih ko diyà sa kehaa i Nemula. Amuk hediya, tandaan ko diyà sa medoo etaw sa egoh ko nelikuan dé.” ");
INSERT INTO mta_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Dodoo egkedakel polo sa lalag i Hésus diyà sa medoo etaw. Huenan di, medoo temù sa etaw egkesetipon diyà kenagdi anì dinegen da sa ketulù di owoy ipebulung da ma sa medoo balangan linadu da. ");
INSERT INTO mta_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Dodoo takà egsalidsalid Hésus i diyà kenagda eg-angay egsimbà diyà sa melabel tanà mediyù dalesan. ");
INSERT INTO mta_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na, sebaen agdaw egoh i Hésus migtulù diyà sa medoo Hudiyu, duen ma medoo kaunutan da egpenuu dahiya sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu. Kedu da diyà langun menuwa diyà uwang Galiliya owoy uwang Hudiya owoy Hélusalém. Na, eg-ugpà sa tunung i Datù diyà si Hésus anì mekegaga mulung diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na, duen maama egtodel sa langun lawa di eg-oyongen da diyà sa kateli. Iya sa ungayà da angay da itenà diyà sa taengan i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Dodoo endà egpekehaa da sa kenà da umukit eg-oyong kenagdi diyà si Hésus, enù ka nealang da danà sa medoo etaw egkesepisok. Huenan di, inuwit da sa kateli dutu siedò iyug atep mepatag. Tinosongon da sa atep owoy tinuntun da sa maama lapeg sa kateli di diyà sa taengan i Hésus teliwadà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Agulé, egoh i Hésus neketiig dakel sa kepigtuu da, guwaen di diyà sa maama egtodel, “O Akay, nekepeuloy dé sa medoo salà ko.” ");
INSERT INTO mta_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dodoo nelikutan sa pedu sa medoo Palasiyu owoy sa medoo tegetulù uledin danà sa inikagi i Hésus. Egseolomoy da, guwaen da, “Ay, dakel temù sa salà siini maama. Enù ka egtepengen di Nemula i. Endà duen etaw mekepeuloy salà liyu daa si Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dodoo egoh i Hésus egpeketiig sa penemdem da, mikagi, guwaen di, “Maen di ya egkelikutan sa pedu yu danà sa kagi ku? ");
INSERT INTO mta_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Enù di ya, ngadan tayu sa melemu egbaelan sa etaw, ipeuloy di sa salà siini maama egtodel ataw ka bulungan di anì meketigdeg owoy mekebigkat? Endà mebaluy di amuk etaw daa. ");
INSERT INTO mta_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Dodoo duen pelawà sa ipehaa ku diyà keniyu anì metiigan yu aken sa Kakay Langun anì metiigan yu ma amuk mekegaga a egpeuloy salà diyà tanà.” Agulé guwaen i Hésus diyà sa maama egtodel, “Na Akay, tigdeg ka dé. Uwit ko sa kateli ko owoy likù ka dé.” ");
INSERT INTO mta_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hê, hinaa da mesiyapat ma dé migtigdeg sa maama. Inuwit di sa kateli di owoy eglikù dé. Egoh di eg-ipanaw, eg-oloen di Nemula i. ");
INSERT INTO mta_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Agulé, tigtu da negaip temù sa langun etaw dahiya dodoo eg-oloen da ma Nemula i. Nelenawan da ma, guwaen da, “Minekehaa ki medoo egpekegaip ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na, egoh i Hésus eg-ipanaw dema, hinaa di Lebi i sa atung egpeetuken sa sulutan migpenuu diyà sa lawì atung kenà di eg-etuk. Agulé guwaen i Hésus diyà kenagdi, “Unut-unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Hê, migtigdeg Lebi i owoy sinalidan di sa langun kehagtayan di dahiya enù ka mig-unut ma dé diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na, migbael dakel pista Lebi i diyà sa dalesan di danà sa keadat di si Hésus. Medoo temù sa etaw duma da egkaen, owoy duen ma medoo atung egpeetuken sa sulutan dahiya. ");
INSERT INTO mta_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Dodoo sa medoo Palasiyu owoy sa medoo duma da tegetulù uledin igsugkow i Mosis, egsigbolowen da sa pasek i Hésus, guwaen da, “Amuk metiengaw etaw yu, maen di ya egselenganen yu egkaen owoy eg-inem sa medoo medaet etaw sa atung egpeetuken sa sulutan owoy sa duma da tegebael salà?” ");
INSERT INTO mta_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Agulé sinagbian i Hésus kagda, guwaen di, “Amuk metéél sa etaw, endà duen pesuwan di lumagbet tegebulung. Sa etaw eglinadu polo sa lumagbet tegebulung. ");
INSERT INTO mta_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pineangay a dini anì isasà ku sa medoo etaw neketiig duen salà da anì ekedan da sa salà da, beken duu sa medoo etaw guwaen da dò endà duen sa hagda salà.” ");
INSERT INTO mta_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na, duen etaw mig-ikagi diyà si Hésus, guwaen da, “Takaan da egpeulan sa medoo pasek i Huwan sa kekaen da anì sumimbà da daa. Hediya ma sa adat sa medoo pasek Palasiyu. Dodoo sa niko pasek, takà da polo egkaen owoy eg-inem. Maen di ya endà ma egpeulanen da duu sa kekaen da?” ");
INSERT INTO mta_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Agulé, migsagbì Hésus i peligad, guwaen di, “Amuk duen pista kawing, endà mebaluy di amuk peulanen ta sa kekaen ta amuk dahiya pelawà sa maama egkawingen. ");
INSERT INTO mta_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Dodoo dumuen pa sa agdaw mekedan sa maama diyà sa medoo duma di. Iya pelawà sa egoh da peulan sa kekaen da enù ka mebukul da.” ");
INSERT INTO mta_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Agulé, migbael peligad Hésus i denu sa egoh di endà meseamut sa magtu igtulù di owoy sa tapay uledin. Guwaen di, “Upama, duen tapay ginis ko nelisì, endà mepion di amuk itabung ko sa magtu ginis diyà sa tapay, enù ka medaetan sa magtu owoy endà meseunut sa palas di diyà sa tapay ginis. ");
INSERT INTO mta_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hediya ma, endà ma mebaluy di amuk itagù ta sa magtu wain diyà sa tapay taguan di kunul kambing, enù ka mebetu danà sa kelukotok di enù ka endà mekehened sa tapay kunul kambing. Medaetan sa taguan di, agulé melemet sa wain. ");
INSERT INTO mta_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mepion polo amuk itagù ta sa magtu wain diyà sa magtu taguan ma anì endà melemet di. ");
INSERT INTO mta_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na, amuk tegeinem sa etaw sa tapay wain, ekedan di sa magtu enù ka guwaen di, ‘Mepion doo ini tapay wain.’” ");
INSERT INTO mta_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na, egoh sebaen Sapetu sa agdaw keetud da, mig-ukit Hésus i owoy sa pasek di diyà sa dalan egtelek tinibah. Inelus sa medoo pasek di sa palay owoy kinelupi da owoy kinaen da. ");
INSERT INTO mta_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dodoo, migsigbolow sa medoo Palasiyu, guwaen da, “Maen di ya egtipayen yu sa uledin ta denu sa agdaw keetud, enù ka galebek iya wé egbaelan yu?” ");
INSERT INTO mta_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Migsagbì Hésus i, guwaen di, “Lagà yu endà nekebasa sa kagi i Nemula denu sa binaelan i Dabid egoh anay egoh di nelikutan neketues owoy sa medoo duma di. ");
INSERT INTO mta_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Migludep Dabid i diyà sa Dalesan i Nemula owoy kinaen di sa epan diyà sa lamisan sa epan igbegay diyà si Nemula. Pinekaen di ma sa medoo duma di. Apiya di pa migtipay ma diyà sa uledin ta denu siedò epan enù ka sa tegesimbà daa sa mekekaen iya wé, beken doo salà iya wé binaelan di.” ");
INSERT INTO mta_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Guwaen i Hésus ma, “Aken sa Kakay Langun sa Datù diyà siini uledin ta denu sa agdaw keetud, huenan di mekegaga a tumulù etaw sa mepion egbaelan da diyà sa agdaw keetud.” ");
INSERT INTO mta_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na, egoh sebaen Sapetu sa agdaw keetud da, migludep Hésus i diyà sa simbaan Hudiyu owoy egtulù dahiya. Duen sa maama dahiya melungoy belad denu kuwanan di. ");
INSERT INTO mta_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dahiya ma sa medoo Palasiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. Egtulikan da Hésus i amuk bulungan di sa etaw diyà sa agdaw keetud enù ka ungayà da dumuen sa salà di metulon da. ");
INSERT INTO mta_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Dodoo netiigan i Hésus sa penemdem da, huenan di guwaen di diyà sa maama melungoy belad, “O Akay, angay ka tigdeg dahini.” Hê, miglegkang sa maama owoy mig-angay migtigdeg diyà dapag i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Agulé, guwaen i Hésus diyà sa medoo etaw dahiya, “Migsà a diyà keniyu. Ngadan tayu sa mepion diyà sa uledin denu sa agdaw keetud, tumabang ki ataw ka meumàumà ki? Ngadan tayu sa mepion, alukan ta sa etaw ataw ka imatayan ta?” ");
INSERT INTO mta_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Agulé, tinukidtukid i Hésus kagda eghahaa, owoy guwaen di diyà sa maama melungoy belad, “Begeng ko sa belad ko.” Hê, egoh di egbegeng, nelikuan dé sa belad di. ");
INSERT INTO mta_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dodoo nepenù bulitan sa medoo Palasiyu owoy sa medoo tegetulù uledin. Agulé, egseolomoy da eglagbet sa ukit kebael da si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na, egoh di melugaylugay, migtekedeg Hésus i anì sumimbà dutu siedò getan. Neelut di sigep takà egsimbà diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Agulé, umenaw simag sinetipon di sa medoo pasek di, owoy hinemilì di sa sepulù owoy duwa diyà sa kedoo da enù ka eggelalen di kagda salu di. ");
INSERT INTO mta_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na, ini ngadan sa medoo etaw hinemilì di, si Simon pinengadanan di ma si Pidelu, owoy si Andelis hadi i Pidelu, owoy si Santiyago owoy si Huwan. Hinemilì di ma Pilipi i, owoy si Baltolomi, ");
INSERT INTO mta_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","owoy si Matéyo, owoy si Tomas, owoy sa sebaen ma Santiyago anak i Alpiyo, owoy sa sebaen Simon kepengadan da si Mebagel enù ka mebagel eghemalang sa tanà Hudiya. ");
INSERT INTO mta_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Hinemilì di ma Hudas i anak i Santiyago, owoy si Hudas Iskaliyot sa maama tumampil diyà sa kuntelà i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Agulé, miglungel Hésus i owoy sa salu di, owoy egtigdeg da diyà sa sugud. Nesetipon dahiya sa medoo etaw di owoy sa melaweng etaw kedu mediyù dò. Duen kedu uwang Hudiya owoy duen ma kedu diyà Hélusalém. Kedu da ma diyà menuwa Tilo owoy menuwa Sidon medapag diyà dagat. Nesetipon da anì dumineg da sa ketulù di owoy ipebulung da ma sa medoo linadu da. ");
INSERT INTO mta_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mig-angay ma diyà kagdi sa medoo etaw linahuk busaw. Hê, nelikuan da dé. ");
INSERT INTO mta_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Inudesan sa langun etaw eg-amis Hésus i enù ka dakel sa tunung diyà sa lawa di. Hê, nelikuan da dé langun. ");
INSERT INTO mta_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Agulé, tinaeng i Hésus sa medoo pasek di owoy guwaen di, “Apiya pubeli yu etaw, neanggan yu enù ka egpekeunut yu sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Apiya di pa egpeketues yu ini egoh di, neanggan yu enù ka mebesug yu doo. “Apiya di pa egsinegaw yu ini egoh di, neanggan yu enù ka gumemen yu doo. ");
INSERT INTO mta_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Apiya di pa egkelepuhan yu etaw owoy eg-ekedan da kiyu owoy egtubaden da kiyu owoy egtipuwen da kiyu danà sa keunut yu sa Kakay Langun, neanggan yu doo. ");
INSERT INTO mta_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Enù ka hediya ma pinelihay sa medoo tupù da sa medoo tegesugkow i Nemula egoh anay. Amuk meuma sa kelikutan yu, keanggan yu polo temù owoy sautsaut yu ma danà sa kekeanggan yu, enù ka tigtu mepion sa untung yu dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Na, apiya kawasà yu etaw, melikutan yu doo enù ka nekuwa yu dé sa kepionon pedu yu diyà sa pantiyali yu. ");
INSERT INTO mta_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Apiya di pa nebesug yu ini egoh di, melikutan yu doo enù ka meketues yu kani. “Apiya di pa eggemen yu ini egoh di, melikutan yu doo enù ka mebukul yu temù owoy suminegaw yu ma. ");
INSERT INTO mta_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Amuk egkeolò yu etaw, melikutan yu doo enù ka lagà yu sa medoo tegesugkow butbuten egoh anay inolò sa medoo tupù yu endà egpigtuu.” ");
INSERT INTO mta_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Agulé guwaen i Hésus, “O medoo etaw egdineg, ini sa kagi ku diyà keniyu: hiduwi yu sa medoo kuntelà yu owoy baeli yu mepion diyà sa medoo egkelepuh keniyu. ");
INSERT INTO mta_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Sagbii yu mepion sa medoo egtubad keniyu, owoy simbai yu ma sa medoo egkudì keniyu. ");
INSERT INTO mta_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Amuk duen etaw tumagpì sa bélén ko, pedibaluyi ko ma sa dibaluy bélén ko anì umanan di sa ketagpì di amuk iya sa ungayà di. Amuk duen etaw pekawen di sa kawal ko, begayi ko ma sa lapin ko. ");
INSERT INTO mta_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Sumalà dé sa etaw megeni diyà keniko, begayi ko. Amuk kuwaen sa etaw sa langun taman ko, yaka dé eghawid duu. ");
INSERT INTO mta_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amuk ungayà yu mepion sa egbaelan duma yu diyà keniyu, baeli yu ma sa mepion diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Amuk iya daa sa eghiduwan yu sa medoo mehidu keniyu, endà metuuwan Nemula i, enù ka hediya mendaa sa medoo tegebael salà, iya ma daa sa eghiduwan da sa mehidu kenagda. ");
INSERT INTO mta_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amuk iya daa sa kenà yu egbael mepion sa medoo egbael mepion ma daa diyà keniyu, endà metuuwan ma Nemula i, enù ka hediya mendaa sa egbaelan sa medoo tegebael salà. ");
INSERT INTO mta_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amuk iya daa sa egpesagbayen yu sa medoo mekegaga pelikù diyà keniyu, endà metuuwan ma Nemula i, enù ka hediya mendaa sa medoo tegebael salà, iya ma daa sa egpesagbayen da sa medoo duma da tegebael salà amuk mekepelikù da sa langun ipesagbay. ");
INSERT INTO mta_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dodoo hiduwi yu sa medoo kuntelà yu, owoy bael yu mepion polo diyà kenagda. Pesagbay yu owoy yoko egpenemdem duu sa kepelikù di. Amuk hediya, tigtu dakel sa untung yu owoy mekesuet yu ma si Nemula, enù ka eghiduwan di sa langun etaw, apiya medaet da owoy endà mipedu da. ");
INSERT INTO mta_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hiduwi yu sa langun etaw iling sa kehidu sa Emà yu si Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Agulé guwaen i Hésus, “Yoko egsigbolow duu sa duma yu nesalà anì endà ma ipaten i Nemula duu sa salà yu. Yoko egpenemdem duu egpigtamay sa duma yu anì endà ma mepigtamayan i Nemula duu kiyu. Peuloyi yu salà sa duma yu anì ipeuloy i Nemula ma sa niyu salà. ");
INSERT INTO mta_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Begay yu diyà etaw anì begayan i Nemula ma kiyu. Sumubela pa sa kebegay di keniyu, enù ka tanesen di owoy uluwan di anì medoo temù sa mehaa yu. Amuk metawag yu egbegay diyà etaw, metawag ma Nemula i megay diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Agulé, egtulon Hésus i balatan diyà kenagda, guwaen di, “Endà mekeagak sa langap sa duma di langap, enù ka menabù da langun diyà sa medalem tosong. ");
INSERT INTO mta_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Endà ma lumowon sa etaw egtuluen diyà sa mistelu egtulù kenagdi, enù ka sumalà dé sa egkegaga sa mistelu, iya ma daa megaga sa egtuluen di. ");
INSERT INTO mta_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Na, amuk menemdem ka tumabang sa duma ko nesalà, maen di ya eglagbeten ko sa hagdi tukééy bulah, dodoo endà egpenemdemen ko duu sa niko bulah éhê kedakel bugsud dalesan? ");
INSERT INTO mta_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Maen di ya guwaen ko diyà sa duma ko, ‘O Akay, kedanan ku sa bulah ko,’ dodoo endà egkehaa ko sa niko éhê bugsud dalesan? Tegeakal yu kiyu i. Kedani ko polo muna sa niko dakel bulah anì kumetiengaw sa kehaa ko kumedan sa tukééy bulah sa duma ko.” ");
INSERT INTO mta_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Agulé migtulon balatan Hésus i, guwaen di, “Amuk mepion sa kayu, endà egbunga di medaet. Diya ma amuk medaet sa kayu, endà munga di mepion. ");
INSERT INTO mta_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Metiigan ta sa medoo balangan kayu amuk eghauwen ta sa bunga di. Endà duen penemdem ta lumagbet ki sa pigus mekaen etaw diyà sa kesulusulu, owoy endà ma lumagbet ki sa bunga palas mekaen etaw diyà sa kayu begongoh. ");
INSERT INTO mta_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hediya ma sa medoo etaw. Amuk mepion sa etaw, mepion ma sa egbaelan di danà sa pedu di mepion. Dodoo amuk medaet sa etaw, medaet ma sa egbaelan di danà sa pedu di medaet. Sumalà dé sa itagù sa etaw diyà sa pedu di, iya ma sa meikagi di.” ");
INSERT INTO mta_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Agulé guwaen i Hésus, “Maen di ya eg-umowen yu aken, guwaen yu, ‘O Datù, O Datù,’ dodoo endà egpangunutan yu duu sa itulù ku? ");
INSERT INTO mta_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mael a balatan diyà uman sebaen etaw eg-angay diyà kenak owoy egdinegdinegen di sa kagi ku owoy egpangunut ma. ");
INSERT INTO mta_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iya sa etaw lagà sa maama egbael dalesan, kinalian di medalem taman neuma sa batu, agulé pinetigdeg di sa bugsud di. Hê, egoh di egkemahà sa wayeg, nekesugat diyà sa dalesan, dodoo endà nepilay di enù ka mebagel. ");
INSERT INTO mta_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Dodoo uman sebaen etaw egdineg daa uloy sa kagi ku owoy endà egpangunutan di duu, kagdi lagà sa maama egbael dalesan endà kinalian di duu sa bugsud di. Hê, egoh di egkemahà sa wayeg, nekesugat diyà sa dalesan, nepilay doo owoy tigtu medaetan.” ");
INSERT INTO mta_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Na, egoh di neubus sa langun kagi i Hésus diyà sa kedineg sa medoo etaw, mig-angay Hésus i diyà menuwa Kapelenaum. ");
INSERT INTO mta_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na, duen ma sa kapitan sundalu etaw Loma eg-ugpà dahiya. Eglinadu sa egsuguen di tigtu eghiduwan di owoy buyu dé egkematay. ");
INSERT INTO mta_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Agulé, egoh sa kapitan egdineg sa lalag i Hésus, sinugù di sa medoo kaunutan Hudiyu anì angayen da Hésus i anì bulungan di sa egsuguen di. ");
INSERT INTO mta_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Egoh da nekeuma diyà si Hésus, eglakawan da, guwaen da, “Apiya beken etaw Hudiyu siini kapitan, mipedu doo. Mepion amuk tabangan ko ");
INSERT INTO mta_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","enù ka eghiduwan di kita i etaw Hudiyu owoy ginastuwan di ma sa simbaan ké dahini.” ");
INSERT INTO mta_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Agulé, mig-unut Hésus i kenagda. Egoh da buyu dumagpak diyà sa dalesan sa kapitan, duen duma di pinetelabuk di diyà si Hésus anì isugkow da sa kagi sa kapitan, guwaen da, “O Datù, yaka eggemow wa enù ka memala gaa amuk gumemow ka diyà sa dalesan di enù ka tukééy etaw gaa. ");
INSERT INTO mta_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Huenan di, endà siegungen di kuna. Dodoo ikagi ko daa anì melikuan sa egsuguen di gaa. ");
INSERT INTO mta_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Netiigan di sa egkegaga ko egsugù, enù ka kagdi ma sa maama egpekegaga gaa, enù ka legkang diyà sa ulu-ulu di sa egkegaga di owoy egpekesugù ma sa medoo sundalu di gaa. Amuk guwaen di diyà sa sebaen sundalu gaa, ‘Ipanaw ka dé,’ hê mipanaw dé. Amuk guwaen di diyà sa sebaen ma sundalu gaa, ‘Téél ka dé,’ hê misalu ma dé. Amuk guwaen di diyà sa egsuguen di gaa, ‘Baeli ko siini,’ hê baelan di ma dé.” ");
INSERT INTO mta_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Na, egoh i Hésus migdineg iya wé, tigtu negaip owoy migtaeng diyà sa medoo etaw eg-unut diyà kenagdi, guwaen di, “Eg-ikagiyen ku ini i diyà keniyu, tigtu egpigtuu siini maama. Apiya sa langun etaw Hudiyu, endà hinaa ku duu sa kepigtuu da iling siini hagdi.” ");
INSERT INTO mta_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Agulé, egoh da egpelikù dé sa medoo egtelabuk, hinaa da sa egsuguen sa kapitan nelikuan dé. ");
INSERT INTO mta_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Agulé, melugaylugay kedu iya, mig-angay Hésus i dutu siedò menuwa Nain. Mig-unut ma sa medoo salu di owoy sa melaweng etaw. ");
INSERT INTO mta_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Agulé, egoh da medapag diyà sa selat kutà sa menuwa, nesiegungan da sa medoo etaw egtiang lungun sa maama nematay. Bugtung anak sa balu iya wé nematay. Medoo sa etaw kedu diyà sa menuwa mig-unut kenagdi eg-angay diyà sa kenà da eglebeng. ");
INSERT INTO mta_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Egoh i Datù Hésus mighaa sa bayi balu, tigtu eghiduwan di owoy guwaen di, “Yaka egsinegaw wa.” ");
INSERT INTO mta_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Agulé, migpedapag Hésus i owoy sinabaan di sa lungun. Hê mig-ugpà sa egtiang lungun. Guwaen i Hésus, “O Adug, enaw ka dé.” ");
INSERT INTO mta_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Hê, mig-enaw sa etaw nematay owoy egpenuu owoy mig-ikagi. Agulé, inagak i Hésus eg-angay diyà sa inay di. ");
INSERT INTO mta_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nelenawan sa langun etaw mighaa iya wé, owoy eg-oloen da Nemula i, guwaen da, “Migtebow dé diyà kenita sa tigtu tegesugkow i Nemula.” Guwaen da ma, “Mig-angay dé Nemula i eg-aluk diyà sa medoo etaw di.” ");
INSERT INTO mta_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Agulé, nelagtawan sa langun etaw sa lalag panduan binaelan i Hésus taman uwang Hudiya owoy sa tanà medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na, tinulonon sa medoo pasek i Huwan kagdi denu sa langun binaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Agulé, inumow di sa duwa pasek di enù ka peangayen di kagda peigsà diyà si Datù Hésus amuk tuu kagdi sa Tigtu Datù pineangay i Nemula migtebow, ataw ka sa sebaen ma etaw polo sa angat-angatan da. ");
INSERT INTO mta_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Egoh da migtebow diyà si Hésus, guwaen da, “Sinugù i Huwan Tegebautis kami eg-angay eg-igsà diyà keniko, guwaen di, ‘Enù di ya, kuna sa Tigtu Datù pineangay i Nemula migtebow, ataw ka sebaen ma etaw polo sa angat-angatan ké?’” ");
INSERT INTO mta_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na, egoh da eglimud si Hésus, binulungan di sa medoo etaw eglinadu. Pinelaun di ma sa busaw miglahuk diyà etaw, owoy pineilag di ma sa medoo langap. ");
INSERT INTO mta_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Huenan di, sinagbian di kagda, guwaen di, “Angay yu dé tulon dutu si Huwan dò sa hinaa yu owoy sa dinineg yu diyà kenak. Nekeilag dé sa medoo langap, owoy nekebigkat ma dé sa medoo pikat. Nelikuan ma dé sa medoo etaw eglinadu dempid, owoy nekedineg ma dé sa medoo bisuwen owoy mig-enaw ma sa medoo nematay. Owoy nekedineg ma dé sa medoo pubeli etaw sa Mepion Tegudon denu kenak. ");
INSERT INTO mta_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tulon yu ma diyà kagdi meanggan doo sa etaw amuk endà egkeduwa sa pedu di egpigtuu diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Na, egoh da miglikù sa sinugù i Huwan, mig-edung eg-ikagi Hésus i diyà sa melaweng etaw denu si Huwan. Guwaen di, “Egoh yu mig-angay eghahaa si Huwan dutu siedò melabel tanà mediyù dalesan, endà iling di elê takà egkepilaypilay danà kelamag enù ka endà egkehalì sa pedu di. ");
INSERT INTO mta_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Egoh yu miglenged si Huwan dutu siedò melabel tanà mediyù dalesan, endà hinaa yu duu sa etaw migluhub metolol ginis, enù ka iya daa sa egluhub milagà ginis owoy duen dakel hagtay sa medoo etaw eg-ugpà diyà sa dakel menuwa datù. ");
INSERT INTO mta_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Dodoo egoh yu mig-angay dutu, inangay yu eghahaa sa tegesugkow i Nemula. Na, tigtu tuu si Huwan sa tegesugkow i Nemula owoy miglowon pa kagdi i diyà sa medoo tegesugkow i Nemula egoh anay danà sa galebek di tigtu dakel. ");
INSERT INTO mta_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Enù ka igpesulat i Nemula sa denu si Huwan egoh anay, guwaen di, ‘Duen sa egsugùsuguen ku pehunawen ku diyà keniko anì upionen di sa ukitan ko tumebow.’ ” ");
INSERT INTO mta_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Sa langun etaw inanak diyà tanà, endà duen miglowon diyà si Huwan. Dodoo sumalà dé sa tukééy etaw umunut sa kedatù i Nemula, iya polo sa lumowon diyà si Huwan.” ");
INSERT INTO mta_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, egoh sa medoo etaw lapeg sa medoo atung egpeetuken sa sulutan migdineg sa ketegudon i Huwan egoh anay, netuuwan da diyà sa kagi i Nemula denu sa salà da owoy migpebautis da ma diyà si Huwan. ");
INSERT INTO mta_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Dodoo sa medoo Palasiyu owoy sa medoo tegetulù uledin igsugkow i Mosis, inekedan da sa uyot i Nemula diyà kagda enù ka mig-eked da ma egpebautis diyà si Huwan. ");
INSERT INTO mta_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Guwaen i Hésus, “Ngadan iya balatan ku keniyu medoo duma ku eg-ugpà diyà tanà ini egoh di? Ngadan sa pelagaan ku keniyu? ");
INSERT INTO mta_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lagà yu sa medoo batà egselapan diyà padian owoy egseolomoy da. Guwaen sa duma batà, ‘Binaelan ké sa dalemetan anì egdelayaw yu, dodoo eg-eked yu. Migdelawit ké ma anì umunut yu egsinegaw, dodoo eg-eked yu ma.’ ");
INSERT INTO mta_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iya maen di ya lagà yu siedò batà enù ka egoh yu neketiig sa adat i Huwan Tegebautis, inekedan yu kagdi i. Egoh yu neketiig endà egkaen di epan owoy endà eg-inem di wain, iya sa kagi yu, guwaen yu, ‘Linahuk busaw ini i maama.’ ");
INSERT INTO mta_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dodoo egoh yu neketiig sa adat sa Kakay Langun egkaen owoy eg-inem, inekedan yu ma. Iya sa kagi yu, guwaen yu, ‘Taa yu, meibeg kumaen siini maama owoy meibeg uminem mekehilu, owoy egloyuken di ma sa medoo medaet etaw atung egpeetuken sa sulutan owoy sa medoo tegebael salà ma.’ ");
INSERT INTO mta_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Dodoo sa medoo etaw eg-unut diyà si Nemula, netuuwan da diyà sa melabel pagitung di.” ");
INSERT INTO mta_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na, duen sa sebaen Palasiyu migsasà si Hésus anì mangay kumaen diyà kenagdi. Agulé, miggemow Hésus i diyà sa dalesan di owoy egpenuu da egkaen. ");
INSERT INTO mta_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, duen ma sa bayi tegebael salà eg-ugpà diyà iya wé menuwa. Egoh di neketiig egkaen Hésus i diyà sa dalesan Palasiyu, mig-angay dahiya eg-uwit sa tukééy butul alabastelu nepenù lana mepion ngadeg. ");
INSERT INTO mta_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Agulé, migtigdeg diyà sa selatal lisen i Hésus owoy egsinegaw. Pinelê di luhà sa lisen i Hésus, owoy hinunas di balut ulu di. Pinengadekan di ma sa lisen di, owoy linulowon di lana mepion ngadeg. ");
INSERT INTO mta_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na, sa Palasiyu migsasà si Hésus, egoh di mighaa sa binaelan sa bayi, iya sa penemdem di amuk tuu si Hésus sa tegesugkow i Nemula, metiigan di tegebael salà siini bayi eg-amis kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Agulé, inikagiyan i Hésus sa Palasiyu, guwaen di, “O Simiyon, duen sa ikagiyen ku diyà keniko.” Migsagbì, guwaen di, “Ngadan di ya, Mistelu?” ");
INSERT INTO mta_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Guwaen i Hésus, “Duen sa duwa maama eg-utang diyà sa maama kawasà. Iya sa utang sa sebaen, lima gatus, owoy iya ma sa utang sa duma di, lima pulù. ");
INSERT INTO mta_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hê, egoh da endà nekebayad, igpeuloy di dé sa utang da. Na, ngadan tayu diyà siini duwa maama sa dakel pedu diyà sa kawasà?” ");
INSERT INTO mta_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Migsagbì Simiyon i, guwaen di, “Iya sa uman dakel pedu kéen sa maama uman dakel utang igpeuloy di.” Guwaen i Hésus, “Nesugat sa sagbì ko.” ");
INSERT INTO mta_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Agulé, mig-isalu Hésus i diyà sa bayi, owoy guwaen di dema diyà si Simiyon, “Hinaa ko pa atu sa binaelan siini bayi diyà kenak? Egoh ku miggemow diyà sa dalesan ko, endà inadatan ko aken enù ka endà migbegay ka wayeg ipegusê ku sa lisen ku. Dodoo siini bayi, pinelê di luhà sa lisen ku owoy hinunas di balut ulu di. ");
INSERT INTO mta_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Endà migpengadek ka kenak egoh ku migtebow. Dodoo siini bayi, endà dé miglengà di migpengadek sa lisen ku edung egoh di migtebow. ");
INSERT INTO mta_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Endà ma hinukowon ko duu lana sa ulu ku, dodoo siini bayi, linulowon di lana mepion ngadeg sa lisen ku. ");
INSERT INTO mta_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Huenan di, ini sa tulonen ku diyà keniko. Apiya di pa medoo sa salà siini bayi, igpeuloy dé langun. Iya tandà di ya dakel kehidu di kenak. Dodoo, amuk egpenemdemen sa etaw tukééy daa sa salà di igpeuloy, tukééy ma daa sa kehidu di.” ");
INSERT INTO mta_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Agulé, guwaen i Hésus diyà sa bayi, “Igpeuloy dé sa medoo salà ko.” ");
INSERT INTO mta_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hê, egseolomoy sa medoo duma di egkaen, guwaen da, “Maen ini i maama egpekepeuloy salà?” ");
INSERT INTO mta_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Dodoo guwaen i Hésus diyà sa bayi, “Inalukan ka dé danà sa kepigtuu ko. Likù ka dé, enù ka migtanà dé sa pedu ko.” ");
INSERT INTO mta_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Agulé melugaylugay pa, tinukid i Hésus sa medoo dakel menuwa owoy sa tukééy, owoy igtulù di diyà sa medoo etaw sa Mepion Tegudon denu sa kedatù i Nemula. Eg-unut ma diyà kenagdi sa sepulù owoy duwa salu di ");
INSERT INTO mta_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","owoy sa medoo bayi nelikuan linadu owoy sa duma da bayi linesutan busaw. Iya sa duma bayi si Maliya tegeMagdala linesutan pitu busaw, ");
INSERT INTO mta_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","owoy si Huana sawa i Kusa sa ulu-ulu sa medoo egsugùsuguen i Datù Hélod, owoy si Susana, owoy sa medoo duma bayi. Na, siini medoo bayi, igbegay da sa duma langun taman da anì eggastuwan da Hésus i owoy sa medoo salu di. ");
INSERT INTO mta_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Agulé, mig-angay da diyà si Hésus sa medoo etaw kedu sa uman sebaen menuwa. Egoh da nesetipon sa temù medoo etaw, tinulonon di kagda peligad, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Na, duen sa maama mig-angay egsawel benì di diyà sa hinemulaan di. Egoh di egsawel, duen benì neketenà diyà dalan. Nekogkogon lisen medoo etaw owoy neimet ma manuk tanà egkaen. ");
INSERT INTO mta_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Duen ma duma benì neketenà diyà sa menipis tanà batuwen. Hê, egoh di egtubù, nematay enù ka endà duen wayeg di. ");
INSERT INTO mta_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Duen ma duma benì neketenà diyà sa kenà sa medoo bunga sepinitpinit. Agulé, neseselengan da egtubù owoy nesilung sa palay danà sa sepinit. ");
INSERT INTO mta_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Neketenà ma sa duma benì diyà sa mepion tanà owoy egtubù. Uman sebaen benì, nekesugat temù sa kebunga di nekeuma magatus.” Agulé, egoh i Hésus egtulon siini peligad, mig-ikagi metaled, guwaen di, “Amuk mipedu yu egdineg, penemdem yu dé sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na, mig-igsà sa medoo salu i Hésus sa selepangan siini peligad. ");
INSERT INTO mta_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Agulé guwaen i Hésus, “Igpetiig i Nemula dé diyà keniyu sa penemdem nelidung egoh anay denu sa kedatù di. Dodoo metulonon da daa peligad sa medoo liyu etaw anì endà eghauwen da duu sa selepangan di apiya di pa takà da eghahaa owoy endà egketiigan da duu apiya di pa takà da egdinegdineg.” ");
INSERT INTO mta_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Agulé guwaen i Hésus, “Ini selepangan sa peligad ku. Iya sa lagà benì sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sa tanà duen dalan kenà di neketenà sa benì, iya lagà sa etaw egdineg daa uloy, agulé egtebow Satanas i owoy egkedanan di sa kagi i Nemula diyà sa pedu da anì endà mekepigtuu da anì endà ma mealukan da. ");
INSERT INTO mta_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sa menipis tanà batuwen kenà di neketenà sa benì, iya lagà sa etaw egdineg sa kagi i Nemula owoy neanggan sa pedu da danà da egsakem. Dodoo lagà endà duen dalid di, enù ka endà melugay di sumabuh da migtuu amuk egkepelihay da. ");
INSERT INTO mta_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sa tanà duen sepinitpinit kenà di neketenà sa benì, iya lagà sa etaw nekedineg, dodoo amuk melugaylugay mesilung sa kepigtuu da enù ka egkelakà da danà sa medoo langun taman da owoy sa medoo egkepionon nanam da. Huenan di, endà mebaluy di sa kebunga sa kepigtuu da. ");
INSERT INTO mta_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na, sa mepion tanà kenà di neketenà sa benì, iya lagà sa etaw egdinegdineg sa kagi i Nemula owoy egpeelesen da diyà sa pedu da enù ka tigtu tuu sa pedu da. Metigkel da owoy mepion sa kebunga sa kepigtuu da.” ");
INSERT INTO mta_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Agulé, eg-uman Hésus i eg-ikagi diyà kenagda, guwaen di, “Amuk tinemteman etaw sa palitaan, endà pelagkeban di duu solok, owoy endà ma peleketanaen di duu diyà sa kateli. Dodoo itagù di polo diyà sa mehagtaw anì hauwen sa langun etaw eggemow sa legdaw di. ");
INSERT INTO mta_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hediya ma, meawangan doo sa langun linimunan, owoy metulon doo sa langun linidung anì metiigan doo langun. ");
INSERT INTO mta_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Huenan di, pigtuu yu temù sa dinineg yu, enù ka sa etaw egpigtuu, meumanan pa sa metiigan di. Dodoo sa etaw endà egpigtuu, apiya di pa egpenemdemen di duen egketiigan di, mekedan pa uman sa tukééy egketiigan.” ");
INSERT INTO mta_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Agulé, egoh i Hésus egtulù, migtebow sa inay di owoy sa medoo hadi di maama, dodoo endà egpekelagbas da diyà kenagdi enù ka nealang da sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Agulé egtulonon etaw Hésus i, guwaen da, “Taa ko, diyà duwangen sa inay ko owoy sa medoo hadi ko. Ungayà da hauwen da kuna.” ");
INSERT INTO mta_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Dodoo migsagbì Hésus i, guwaen di, “Iya lagà sa inay ku owoy sa medoo hadi ku maama sa medoo etaw egdineg sa kagi i Nemula owoy egpangunut da ma.” ");
INSERT INTO mta_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Na, sebaen agdaw mig-edà kumpit Hésus i owoy sa medoo salu di. Guwaen di diyà kenagda, “Kumatin ki tanà dutu siini lanaw.” Agulé, eg-ipanaw da dé. ");
INSERT INTO mta_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Egoh da eg-ipanaw, neketudug Hésus i. Hê, nesampen da sepuk owoy egkedaleman wayeg sa kumpit da. Buyu da egpekesugsug. ");
INSERT INTO mta_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Agulé, inangay da eg-enaw Hésus i, guwaen da, “O Datù, egpekesugsug ki.” Agulé, mig-enaw Hésus i owoy hinawidan di sa kelamag owoy sa dakel lambeg. Hê, migsabuh dé owoy miglinek ma dé. ");
INSERT INTO mta_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Agulé guwaen i Hésus, “Kenà sa kepigtuu yu?” Dodoo egkelenawan da owoy egkegaip da ma danà sa tunung i Hésus. Egseolomoy da, guwaen da, “Ngadan ini i maama? Egkegaga di eghawid sa sepuk owoy sa lambeg, owoy egpangunut da doo diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Agulé, egoh da migkatin kedu Galiliya dò, egdunggù da diyà sa tanà Gelasin tanà dutu sa lanaw. ");
INSERT INTO mta_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Na, egoh i Hésus migtenà, migtelabuk sa maama tegeGelasin linahuk busaw. Nelugay dé egpelawalawa, owoy endà eg-ugpà di diyà dalesan enù ka eg-ugpà polo diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Egoh di mighaa si Hésus, eglesing owoy egligkued diyà sa taengan di. Metaled sa kagi di, guwaen di, “O Hésus, maen di ya egbogowen ko aken? Netiigan ku doo kuna sa Anak i Nemula, sa Nemula tigtu mapulù. Egpegeni a diyà keniko, yaka egpigtamay kenak.” ");
INSERT INTO mta_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iya sa inikagi di danà i Hésus mighemaga sa busaw miglahuk diyà sa maama anì lumaun. Na, nelugay dé egkepelihay iya wé maama danà sa busaw takà egsabà kenagdi. Medoo dé gulê pinolot da sangkalì owoy tali, owoy inudesan da egtulik. Dodoo takaan di polo egbugtus sa polot di owoy inagak sa busaw eg-angay dutu siedò melabel tanà mediyù dalesan. ");
INSERT INTO mta_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Agulé, inigsaan i Hésus kagdi, guwaen di, “Ngadan ko ya?” Migsagbì, guwaen di, “Si Melaweng a.” Iya sa sagbì di enù ka medoo temù sa busaw miglahuk diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Agulé, migpegeni da diyà si Hésus anì endà peangayen di duu kagda dutu bayà dò sa kenà da mepigtamayan. ");
INSERT INTO mta_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, duen ma sa medoo babuy eglagbet kaenen da diyà getan-getan medapag dahiya. Agulé, migpegeni sa busaw diyà si Hésus anì pandayaen di kagda mangay lumahuk diyà sa medoo babuy. Agulé pinandayà di dé. ");
INSERT INTO mta_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hê, miglesut sa medoo busaw diyà sa maama owoy mighalì da eglahuk diyà sa babuy. Hê, migletu sa langun babuy miglungel diyà sa kesagdigan owoy nekelesek da diyà sa lanaw. Nelened da langun. ");
INSERT INTO mta_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na, egoh sa medoo tegeipat babuy mighaa iya wé, egpelaguy da eg-angay egtulon sa hinaa da diyà sa medoo etaw diyà sa dakel menuwa owoy diyà sa medoo liyu dalesan medapag dahiya. ");
INSERT INTO mta_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Agulé, mig-angay sa medoo etaw dutu anì hauwen da sa medoo nebaelan dinineg da. Egoh da migtebow diyà si Hésus, hinaa da sa maama linesutan medoo busaw egpenuu diyà sa dapag i Hésus. Migginis dé owoy neketuleng ma dé. Egoh da mighaa iya wé, tigtu egkelenawan da langun. ");
INSERT INTO mta_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na, egtulon sa medoo etaw mighaa diyà sa medoo etaw egtebow denu sa egoh i Hésus migbulung sa maama linahuk busaw. ");
INSERT INTO mta_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Agulé, tigtu nelenawan sa langun etaw tegeGelasin, huenan di eg-ikagiyan da Hésus i anì sumalid diyà kenagda. Agulé, mig-edà dema kumpit Hésus i enù ka lumikù. ");
INSERT INTO mta_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Egoh di eg-edà, egpegeni eg-unut sa maama linesutan busaw. Dodoo hinemagawan i Hésus, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Likù ka polo, angay ko tulon diyà etaw sa tigtu mepion binaelan i Nemula diyà keniko.” Agulé, miglikù dé owoy igseluh di egtulon diyà sa langun etaw diyà menuwa di sa ukit-ukit sa dakel ketabang i Hésus diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na, egoh i Hésus migpelikù diyà Galiliya, tinelabuk sa melaweng etaw kagdi i enù ka eg-angat-angatan da. ");
INSERT INTO mta_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Agulé, duen sa maama ulu-ulu diyà sa simbaan Hudiyu eg-angay diyà si Hésus. Iya sa ngadan di, si Hailu. Migligkued diyà sa taengan i Hésus, owoy egpegeniyen di mangay kenà di dò, ");
INSERT INTO mta_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","enù ka buyu dé egkematay sa bugtung anak di bayi. Sepulù owoy duwa gepalay dé sa lugay di miglesut. Agulé, mig-unut Hésus i diyà si Hailu. Egoh di eg-ipanaw, egkesedeldel sa medoo etaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na, duen sa bayi dahiya egdepanugan. Iya sa lugay di sepulù owoy duwa gepalay dé endà egkedit sa depanug di adat bayi. Apiya di pa takà egpebulung diyà sa medoo etaw, endà doo egkegaga da duu. ");
INSERT INTO mta_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Agulé, migsetugdug sa bayi owoy egtelukunan di eg-amis sa pelingping ginis i Hésus. Hê, petow ma dé migkedit sa eglinaduwen di depanug. ");
INSERT INTO mta_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Agulé, guwaen i Hésus, “Ngadan tayu di etaw sa mig-amis kenak?” Dodoo endà duen egtulon. Agulé guwaen i Pidelu, “O Mistelu, maen di ya eg-igsà ka, enù ka egkesedeldel sa medoo etaw diyà keniko?” ");
INSERT INTO mta_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Dodoo guwaen i Hésus, “Duen sa etaw mig-amis kenak enù ka tinugedam ku sa tunung ku miglesut.” ");
INSERT INTO mta_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na, egoh sa bayi egpeketiig hinaa dé sa binaelan di, mig-angay diyà si Hésus eglukub danà di nelenawan. Migligkued diyà sa taengan di owoy tinulon di diyà sa langun etaw sa pesuwan di mig-amis owoy sa egoh di ma petow nelikuan. ");
INSERT INTO mta_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Agulé guwaen i Hésus, “O Okon, nelikuan ka dé danà sa kepigtuu ko. Mepion sa kelikù ko, enù ka migtanà sa pedu ko.” ");
INSERT INTO mta_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Na, egoh i Hésus telibubu eg-ikagi diyà sa bayi, duen sa maama egtebow kedu sa dalesan i Hailu. Guwaen di diyà si Hailu, “Endà dé sa anak ko bayi. Yaka dé uman duu egbogo sa mistelu.” ");
INSERT INTO mta_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Dodoo egoh i Hésus migdineg sa kagi di, migsagbì, guwaen di, “O Hailu, yaka egkelenawan na. Pigtuu ka daa anì melikuan sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Agulé, egoh da migtebow diyà sa dalesan i Hailu, hinawidan i Hésus sa langun duma di eggemow liyu daa si Pidelu owoy si Huwan owoy si Santiyago owoy sa emà sa batà owoy sa inay di. ");
INSERT INTO mta_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Apiya di pa egsinegaw sa langun etaw dahiya owoy egdelawitan da ma sa kenogon nematay, guwaen doo i Hésus, “Yoko egsinegaw wa, enù ka endà nematay di. Egtudug daa.” ");
INSERT INTO mta_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dodoo ginemenan da polo kagdi i, enù ka netiigan da nematay dé. ");
INSERT INTO mta_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dodoo sinabaan i Hésus belad sa batà owoy eg-umow, guwaen di, “O Okon, enaw ka dé.” ");
INSERT INTO mta_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hê, migpelikù sa suguy di owoy petow dé mig-enaw. Agulé, sinugù i Hésus kagda anì pekaenen da sa kenogon. ");
INSERT INTO mta_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Negaip sa emà di owoy sa inay di, dodoo hinawidan i Hésus kagda anì endà tulonen da duu sa binaelan di. ");
INSERT INTO mta_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na, sinetipon i Hésus sa sepulù owoy duwa salu di, enù ka begayan di kagda tunung owoy dakel egkegaga anì mekegaga da pelesut sa medoo busaw owoy sa langun balangan linadu. ");
INSERT INTO mta_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Agulé, pineangay di kagda egpetegudon denu sa kedatù i Nemula owoy bulungan da ma sa etaw eglinadu. ");
INSERT INTO mta_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Guwaen i Hésus diyà kenagda, “Amuk mipanaw yu, ulan dé sa medoo eg-uwiten yu, iling ka tuked ataw ka puyut ataw ka legà ataw ka pilak ataw ka duma kawal yu. ");
INSERT INTO mta_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amuk mekeuma yu diyà sa menuwa, ugpà yu dé diyà sa dalesan gemowon yu. Yoko eghalìhalì ya taman endà meuma sa kelegkang yu dema. ");
INSERT INTO mta_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dodoo sumalà dé sa menuwa tebowon yu endà miadat keniyu, salidi yu dé. Amuk sumalid yu dahiya, agtag yu sa kepung diyà sa lisen yu anì tandaan yu sa kepigtamay i Nemula tumebow diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Agulé, mig-ipanaw da dé egtukiden da sa medoo menuwa. Sumalà dé sa menuwa egtebowon da, migpeges da egtulon sa Mepion Tegudon owoy egbulungan da ma sa medoo eglinadu anì melikuan da. ");
INSERT INTO mta_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Na, si Hélod sa Datù eg-ipat sa tanà Galiliya, egoh di migdineg denu sa medoo binaelan i Hésus, nelakà sa pedu di enù ka duen etaw eg-ikagi, guwaen da gaa si Huwan mig-enaw egoh di nematay Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dodoo duen ma etaw guwaen da gaa si Iliyas tegesugkow i Nemula egoh anay kagdi i egpehaa diyà etaw. Owoy duen ma etaw guwaen da gaa sebaen ma tegesugkow i Nemula egoh anay neenaw dé kagdi i. ");
INSERT INTO mta_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Dodoo guwaen i Hélod, “Beken si Huwan iya wé etaw, enù ka igpetagped ku dé sa ulu di egoh anay. Ngadan di etaw kéé siini maama egbael sa medoo dinineg ku?” Agulé, udesan di humaa Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Na, egoh sa medoo salu di miglikù diyà si Hésus, tinulon da diyà kenagdi sa binaelan da diyà sa medoo tinebowon da. Agulé, inuwit di kagda eg-angay eglebù diyà sa uwang menuwa Bétsaida. ");
INSERT INTO mta_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dodoo egoh sa medoo etaw neketiig sa inangayan i Hésus, linohot da eglenged Hésus i dutu. Agulé, sinaluan di kagda owoy tinulonon di kagda denu sa kedatù i Nemula, owoy binulungan di ma sa medoo eglinadu anì melikuan da. ");
INSERT INTO mta_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Na, egoh di mahapun dé, mig-angay sa sepulù owoy duwa salu di diyà kenagdi, owoy guwaen da, “Peangay ko siini medoo etaw diyà sa medoo menuwa diyà siini dapag ta anì lumagbet da sa kenà da mekekaen owoy sa kenà da meketudug, enù ka mediyù dalesan siini kenà ta nesetipon.” ");
INSERT INTO mta_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Dodoo guwaen i Hésus, “Kiyu polo sa megay kaenen da.” Agulé guwaen da, “Duen diyà kenami lima getibulu daa epan owoy duwa daa sedà nelegà. Iya daa sa kaenen ta lapeg siini medoo etaw, amuk endà peangayen ko kami pebeli.” ");
INSERT INTO mta_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iya sa inikagi da enù ka mekeuma kéen lima ngibu sa maama dahiya, liyu sa batà owoy bayi. Agulé, guwaen i Hésus diyà sa salu di, “Pepenuu yu kagda. Seumpung yu tiglima-limaway pulù.” ");
INSERT INTO mta_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hê, inunutan da sa kagi di owoy pinepenuu da sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Agulé, kinuwa i Hésus sa lima getibulu epan owoy sa duwa sedà. Eglengag diyà langit owoy egsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Agulé, kinebéngkebéng di owoy igbegay di diyà sa salu di anì tukiden da megay sa melaweng etaw. ");
INSERT INTO mta_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hê, langun da nekekaen owoy nebesug da. Agulé, tinipoh sa salu di sa samà da egkaen sepulù owoy duwa pa gesolok. ");
INSERT INTO mta_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Na sebaen agdaw, egpeiges egsimbà Hésus i, owoy dahiya ma sa medoo salu di. Agulé, inigsaan di kagda, guwaen di, “Ngadan di etaw a gaa, aken i, guwaen sa medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Guwaen da migsagbì, “Duen etaw guwaen da dò si Huwan Tegebautis ka gaa, owoy duen ma etaw guwaen da dò si Iliyas ka gaa. Duen ma etaw guwaen da dò sebaen ma tegesugkow i Nemula egoh anay mig-enaw dema gaa kuna ya.” ");
INSERT INTO mta_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Agulé guwaen i Hésus, “Enù di ya kiyu i, ngadan sa kagi yu denu kenak?” Migsagbì Pidelu i, guwaen di, “Kuna si Kelistu sa Tigtu Datù sinugù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Dodoo tigtu hinawidan i Hésus kagda anì endà tulonen da duu diyà etaw. ");
INSERT INTO mta_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Agulé, guwaen i Hésus ma, “Medoo sa kelikutan ku mekeuma diyà kenak, aken i Kakay Langun. Meekedan a sa medoo kaunutan ta etaw Hudiyu owoy sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Imatayan da ma aken, dodoo umenaw a mendaa diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na, guwaen i Hésus diyà sa langun etaw, “Amuk iya sa pedu sa sebaen etaw umunut-unut diyà kenak, meekedan di sa hagdi ungayà owoy sakemen di sa naken. Lagà metiang di ma sa bugsud kenà di mematay, enù ka uman agdaw metigkelan di sa kelikutan di danà di mekepangunut diyà sa igsugù ku. Owoy tigtu mekeunut-unut ma diyà kenak. ");
INSERT INTO mta_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huenan di, sumalà dé sa etaw umeked umunut diyà kenak enù ka egpekihagtay, iya polo sa etaw mematay. Dodoo sumalà dé sa etaw umeked pekihagtay anì umunut-unut diyà kenak, iya polo sa etaw kumelalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Amuk hediya, endà duen sa tigtu untung mekuwa etaw diyà sa medoo langun taman di diyà tanà. Apiya di pa mekuwa di sa langun, mekesugsug doo. ");
INSERT INTO mta_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Sumalà dé sa etaw eg-eked egtulon denu kenak owoy endà ma egpigtuu di sa kagi ku danà di memala, iya ma sa etaw endà meingadanan ku duu amuk pelikù a, aken i Kakay Langun. Amuk pelikù a, unutan a sa senang ku owoy sa senang i Emà ku owoy sa senang sa medoo egsugùsuguen di metiengaw. ");
INSERT INTO mta_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tuu ini i eg-ikagiyen ku diyà keniyu. Duen duma etaw dahini ini egoh di endà pa mematay da taman endà hauwen da duu sa kedatù i Nemula mekeuma.” ");
INSERT INTO mta_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na, egoh di sakapadian kéen kedu iya wé inikagi i Hésus, inuwit di Pidelu i owoy si Huwan owoy si Santiyago egtekedeg diyà sa getan anì sumimbà. ");
INSERT INTO mta_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Agulé, egoh i Hésus telibubu egsimbà, nepelumanan sa palas di owoy tigtu migkebulà sa ginis di mekesilang. ");
INSERT INTO mta_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Hê, egpehaa dahiya sa duwa maama egsenang, si Mosis owoy si Iliyas. Egseolomoy da Hésus i denu sa kepatay di dutu Hélusalém dò, enù ka medapag dé petuuwen di iya wé. ");
INSERT INTO mta_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na, egtudug Pidelu i owoy sa duwa duma di, dodoo egoh da mig-enaw, hinaa da sa senang i Hésus owoy sa duwa maama nesedapag da egtigdeg. ");
INSERT INTO mta_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Agulé, egoh sa duwa maama buyu da dé sumalid, eg-ikagi Pidelu i, guwaen di, “O Mistelu, mepion ma doo enù ka dahini ké. Mael ké lawì, telu, sebaen niko, sebaen si Mosis, sebaen si Iliyas.” Dodoo eg-amu Pidelu i eg-ikagi, enù ka endà netiigan di duu sa penemdem di. ");
INSERT INTO mta_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hê, egoh di pelà eg-ikagi, tinenaan da gaeb owoy egkelenawan da egoh da nekedalem diyà sa gaeb. ");
INSERT INTO mta_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Agulé, duen sa eg-ikagi kedu dalem sa gaeb, guwaen di, “Ini sa anak ku ginelal ku datù. Dinegdineg yu diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Agulé, egoh di mig-ikagi iya wé, si Hésus daen sa hinaa da dahiya. Na, sa langun hinaa da dahiya, endà tinulon da duu mapes. ");
INSERT INTO mta_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Na, egoh di sumimag, miglungel da kedu diyà sa getan, owoy medoo temù sa etaw migtelabuk si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hê, duen sebaen maama diyà kenagda eg-umow, guwaen di, “O Mistelu, egpehiduhidu a diyà keniko denu siini bugtung anak ku maama. ");
INSERT INTO mta_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Enù ka uman sumabà sa busaw, mepetow lumengat owoy takà egtiglongen sa lawa di owoy mohok ma sa ebà di. Legenen di ma temù taman endà tumoluh sa lawa di owoy buyu endà lengaan di duu. ");
INSERT INTO mta_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Migpegeni a diyà sa medoo pasek ko anì pelaunen da sa busaw, dodoo endà egkegaga da duu.” ");
INSERT INTO mta_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Agulé eg-ikagi Hésus i, guwaen di, “Ay, kiyu i medoo etaw ini egoh di, ngahàngahà yu temù owoy tigtu yu endà egsalig diyà kenak. Egkesemek a dé eg-ugpà diyà keniyu owoy buyu a dé egtalawen danà sa endà kepigtuu yu. Na, uwit ko dini sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Agulé, egoh sa batà eg-angay diyà si Hésus, igdagsà sa busaw owoy egpetiglongenen di. Dodoo hinawidan i Hésus sa busaw. Hê, nelikuan dé sa batà. Agulé, pinelikù di diyà sa emà di. ");
INSERT INTO mta_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na, tigtu da negaip langun danà sa dakel egkegaga i Nemula. Na, egoh da pelawà negaip sa langun binaelan i Hésus, eg-ikagi Hésus i diyà sa medoo salu di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Pegunggungi yu ini i kagi ku diyà sa telinga yu, enù ka buyu a dé mekebegay diyà sa medoo liyu etaw, aken i Kakay Langun.” ");
INSERT INTO mta_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Dodoo endà netiigan da duu sa selepangan iya wé inikagi di, enù ka nelidung diyà kenagda anì endà meketiig da. Dodoo egkelenawan da ma eg-igsà diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na, egsesigbolowoy sa medoo salu di denu sa tayu dakel etaw diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dodoo egoh i Hésus neketiig sa pedu da, kinuwa di sa batà owoy pinedapag di diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Agulé guwaen di, “Sumalà dé sa etaw miadat siini batà danà di etaw ku, meadatan di ma aken; owoy sumalà dé sa etaw miadat kenak, meadatan di ma sa migpeangay kenak diyà tanà. Huenan di, iya sa dakel etaw diyà sa kehaa i Nemula sa tigtu tukééy etaw diyà sa kehaa yu.” ");
INSERT INTO mta_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Agulé, guwaen i Huwan egsagbì, “O Datù, hinaa ké sa sebaen maama egpelesut busaw danà sa ngadan ko. Hinawidan ké enù ka endà eg-unut-unut di diyà kenita.” ");
INSERT INTO mta_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Dodoo guwaen i Hésus, “Yoko eghawid duu, enù ka sumalà dé sa etaw endà egkuntelà di keniyu, iya polo sa etaw tumabang keniyu.” ");
INSERT INTO mta_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na, nelugaylugay pa kedu iya egoh di buyu meuma sa pasad i Hésus mebatun, pineeles di sa pedu di mangay dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pinehuna di ma sa medoo egsugùsuguen di anì lagbeten da sa kenà di tumudug. Agulé, migtebow da diyà sa menuwa diyà uwang Samaliya. ");
INSERT INTO mta_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Dodoo eg-ekedan sa medoo etaw eg-ugpà dahiya Hésus i gumemow diyà sa menuwa da enù ka netiigan da kagdi sa etaw Hudiyu mangay sumimbà Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Agulé, egoh sa salu di si Santiyago owoy si Huwan neketiig sa keeked da, guwaen da, “O Datù, mepion pa amuk suguen ké sa apuy kedu diyà langit anì imeten di kagda?” ");
INSERT INTO mta_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Dodoo eg-isalu Hésus i owoy hinawidan di kagda. ");
INSERT INTO mta_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Agulé, mig-angay da diyà sa sebaen ma menuwa. ");
INSERT INTO mta_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na, egoh da eg-ipanaw diyà sa kalasada, duen sa maama eg-ikagi diyà si Hésus, guwaen di, “Sumalà dé sa angayan ko, umunut-unut a keniko.” ");
INSERT INTO mta_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Dodoo guwaen i Hésus, “Taa ko, hih. Amuk lekipes, duen salag di diyà lungag kayu. Amuk manuk awang, duen ma salag di diyà pulu kayu. Dodoo melikutan ka umunut-unut diyà kenak, aken i Kakay Langun, enù ka endà duen sa tigtu kenà ku mugpà.” ");
INSERT INTO mta_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Agulé, guwaen i Hésus diyà sa sebaen ma maama dahiya, “Unut-unut ka diyà kenak.” Dodoo migsagbì, guwaen di, “O Datù, muna a pelawà mangay lumebeng sa emà ku.” ");
INSERT INTO mta_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Dodoo guwaen i Hésus, “Mepion polo amuk sa etaw endà duen lalù da sa lumebeng sa duma da nematay. Dodoo kuna, angay ka tulù denu sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Agulé, guwaen sa sebaen ma maama, “O Datù, umunut-unut a diyà keniko, dodoo muna a pelawà mangay umebal diyà sa medoo duma ku diatas.” ");
INSERT INTO mta_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Guwaen i Hésus, “Yaka eg-iling duu sa maama egdadu takà eglangalanga, enù ka endà mepion sa danà di egdadu. Diya ma sa etaw neduwa sa pedu di eg-unut diyà kenak, endà duen sa ulan di diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Na, hinemilì i Hésus sa pitu pulù owoy duwa pasek di. Tinigduwa-duwa di kagda egpeipanaw peangay diyà sa langun menuwa buyu tebowon di. ");
INSERT INTO mta_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Agulé guwaen di diyà kenagda, “Lagà palay melegà sa medoo etaw endà pa egpigtuu owoy nebaluy temù sa palay, dodoo endà medoo sa etaw egketu. Huenan di, simbà yu diyà sa épê di si Nemula, anì umowen di pa sa medoo etaw kumetu sa palay di. ");
INSERT INTO mta_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Na, ipanaw yu dé. Hahaa yu, hih. Mipedu yu kiyu i, lagà yu anak kebilibili; dodoo peangayen ku kiyu diyà sa medoo etaw lenglengen, lagà da sa mebalaw tinggalung. ");
INSERT INTO mta_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ulan sa keuwit yu sa taguan pilak ataw ka puyut ataw ka duma talumpà yu. Yoko egsetawit duu sa etaw diyà dalan anì endà meéngén yu. ");
INSERT INTO mta_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Sumalà dé sa dalesan gemowon yu miadat keniyu, huna yu ikagi diyà sa etaw di, guwaen yu, ‘Kumelanih sa keugpà yu diyà siini dalesan danà i Nemula.’ ");
INSERT INTO mta_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na, amuk mepion pedu sa etaw eg-ugpà dahiya, mebegayan da doo sa melanih keugpà danà sa inikagi yu. Dodoo amuk endà, mekepelikù dema diyà keniyu sa inikagi yu. ");
INSERT INTO mta_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ugpà yu daa diyà siedò dalesan kenà yu anay miggemow. Yoko eghalìhalì ya. Kaen yu owoy inem yu sa igmengana da keniyu. Mepion amuk gastuwan da kiyu, enù ka lagà sukay yu kiyu i medoo tegegalebek. ");
INSERT INTO mta_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Sumalà dé sa menuwa tebowon yu miadat keniyu, kaen yu sa imengana da keniyu. ");
INSERT INTO mta_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Bulung yu sa medoo eglinadu anì melikuan da, owoy guwaen yu, ‘Nekeuma dé diyà keniyu sa kedatù i Nemula.’ ");
INSERT INTO mta_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Dodoo sumalà dé sa menuwa tebowon yu umeked keniyu, ukit yu diyà sa medoo kalasada di owoy guwaen yu, ");
INSERT INTO mta_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Apiya siini kepung menuwa yu egdeket diyà sa lisen ké, egkedanan ké enù ka endà mipedu yu. Dodoo taa yu, nekeuma dé hedem diyà keniyu sa kedatù i Nemula, dodoo eg-ekedan yu polo.’ ");
INSERT INTO mta_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Taa yu, hih, sa inikagi ku. Apiya di pa pigtamayan i Nemula pa uman sa etaw tegeSodoma danà sa tigtu medaet binaelan da egoh anay, uman pa dakel doo sa kepigtamay di mekeuma diyà sa menuwa eg-eked keniyu.” ");
INSERT INTO mta_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Agulé guwaen i Hésus, “O medoo etaw tegeKolasin owoy etaw tegeBétsaida, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu, enù ka endà eg-ekedan yu duu sa salà yu apiya di pa dakel sa panduan igpehaa i Nemula diyà keniyu. Dodoo sa etaw tegeTilo owoy etaw tegeSidon, amuk egpekehaa da hedem sa medoo panduan iling sa eghauwen yu, meekedan da doo sa salà da owoy tandaan da ma doo sa keeked da danà da migginis sakù owoy binuhbuhan da ma abuh sa ulu da. ");
INSERT INTO mta_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Apiya di pa pigtamayan i Nemula pa uman sa etaw Tilo owoy Sidon, uman pa dakel doo sa kepigtamay di mekeuma diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","O medoo etaw tegeKapelenaum, apiya di pa ungayà yu pedakelen yu kiyu taman langit dò, petukééyen i Nemula doo kiyu anì mekesugsug yu diyà bayà.” ");
INSERT INTO mta_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Agulé, guwaen i Hésus diyà sa etaw hinemilì di, “Amuk egdinegdineg sa etaw keniyu, lagà aken ma sa egdinegdinegen di; owoy amuk eg-eked sa etaw keniyu, lagà aken ma sa eg-ekedan di, owoy amuk eg-eked sa etaw kenak, lagà eg-ekedan di ma sa migpeangay kenak.” ");
INSERT INTO mta_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Na, melugaylugay egpelikù dema sa medoo sinugù i Hésus. Neanggan sa pedu da owoy guwaen da, “O Datù, apiya sa medoo busaw, eg-unutan da doo sa sugù ké danà sa ngadan ko.” ");
INSERT INTO mta_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Agulé guwaen i Hésus diyà kenagda, “Hinaa ku sa egoh i Satanas tinabanan nenabù kedu langit dò lagà silà. ");
INSERT INTO mta_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Taa yu, hih. Binegayan ku kiyu egkegaga anì utuhan yu sa uled owoy sa menipit owoy tumaban yu ma diyà sa langun kebagel i Satanas sa kuntelà ta. Dodoo endà duen sa mekepesakit keniyu. ");
INSERT INTO mta_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yoko egkeanggan duu sa egkegaga yu diyà medoo busaw, dodoo keanggani yu polo enù ka nekesulat sa ngadan yu diyà sa libelu i Nemula dutu langit dò.” ");
INSERT INTO mta_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na, tigtu neanggan Hésus i danà sa Metiengaw Suguy i Nemula, huenan di egsimbà, guwaen di, “O Emà, kuna sa Datù diyà langit owoy diyà tanà. Egpesalamat a diyà keniko enù ka igpehaa ko sa penemdem ko diyà sa medoo etaw épê tukééy penemdem lagà batà, dodoo linidung ko diyà sa medoo etaw épê dakel penemdem. O Emà, enget ma doo iya wé egbaelan ko enù ka iya sa egkepionon pedu ko.” ");
INSERT INTO mta_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Agulé guwaen i Hésus, “Aken sa sinaligan i Emà sa langun penemdem. Endà duen etaw egpeketiig kenak liyu daa si Emà. Endà ma duen etaw egpeketiig si Emà liyu daa aken i Anak di owoy sa medoo etaw tuluen ku denu kenagdi.” ");
INSERT INTO mta_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Agulé, eg-isaluwan i Hésus sa medoo salu di anì endà mekedineg sa liyu etaw, owoy guwaen di diyà kenagda, “Neanggan yu danà sa eghauwen yu diyà kenak ini egoh di. ");
INSERT INTO mta_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Taa yu, hih. Sa medoo tegesugkow i Nemula owoy sa medoo datù egoh anay, ungayà da humaa hedem sa eghauwen yu, dodoo endà dé nekehaa da. Ungayà da ma dumineg hedem sa egdinegen yu, dodoo endà dé nekedineg da.” ");
INSERT INTO mta_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Na, duen sa maama tegetulù uledin igsugkow i Mosis egtigdeg owoy egtepengan di Hésus i, guwaen di, “O Mistelu, ngadan sa baelan ku anì mekesakem a sa lalù endà meelut di?” ");
INSERT INTO mta_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Guwaen i Hésus, “Ngadan sa nebasa ko sa igsugù i Nemula igsulat diyà sa libelu?” ");
INSERT INTO mta_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Egsagbì sa maama, guwaen di, “Ini sa igsugù i Nemula, guwaen di, ‘Pusungi ko si Nemula sa Datù ko. Peunuti ko diyà kenagdi sa langun pedu ko owoy sa langun penemdem ko owoy sa langun egkegaga ko. Hiduwi ko ma sa duma ko éhê mendaa sa kehidu ko keniko.’ ” ");
INSERT INTO mta_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Agulé guwaen i Hésus, “Nesugat sa sagbì ko. Pangunuti ko dé anì kumelalù ka.” ");
INSERT INTO mta_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Dodoo iya sa ungayà sa maama metandaan di metiengaw sa egbaelan di, huenan di, eg-igsà dema, guwaen di, “Ngadan di etaw sa duma ku mehiduwan ku?” ");
INSERT INTO mta_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Egsagbì Hésus i, guwaen di, “Upama, duen sa maama Hudiyu eg-angay menuwa Héliko dò kedu diyà Hélusalém. Egoh di eg-ipanaw, ginebek sa medoo tegelampas egsuntuk kagdi owoy sinebalbal da. Linampas da ma sa ginis di owoy sa langun taman di. Hê, sinalidan da dé sa maama buyu nematay. ");
INSERT INTO mta_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Agulé, nekeukit dahiya diyà sa kalasada sa maama Hudiyu tegesimbà. Egoh di eghaa, eg-iwod eg-ukit diyà sa kilidan kalasada. ");
INSERT INTO mta_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Agulé, nekeukit ma dahiya sa maama Hudiyu sa sebaen tugod i Lebi. Egoh di eghaa, eg-iwod ma eg-ukit diyà sa kilidan kalasada. ");
INSERT INTO mta_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Agulé, duen ma sa maama tegeSamaliya sa beken etaw Hudiyu eg-ukit dahiya. Egoh di eg-ipanaw, nekeuma diyà sa kenà sa maama liniputan. Egoh di eghaa, eghiduwan di temù. ");
INSERT INTO mta_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Agulé, mig-angay diyà kenagdi owoy binulung di wain owoy lana sa medoo palì di owoy pinolot di ma. Sinapuwat di diyà sa kudà di, owoy inuwit di dutu siedò dalesan atung tudugan etaw egtalàtalà owoy inipat di dahiya. ");
INSERT INTO mta_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Egoh di sumimag, binegayan di pilak sa tegeunung dalesan, guwaen di, ‘Ipat ko owoy sumalà dé sa samà utang di danà sa keipat ko kenagdi, bayadan ku pa amuk pelikù a.’” ");
INSERT INTO mta_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Agulé guwaen i Hésus, “Na, diyà siini balatan ku, ngadan tayu di etaw diyà siini telu maama sa tuu duma sa maama liniputan tegelampas?” ");
INSERT INTO mta_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Egsagbì sa tegetulù, guwaen di, “Iya sa tuu duma di sa egtabang kenagdi.” Guwaen i Hésus, “Na, ilingi ko ma iya wé.” ");
INSERT INTO mta_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na, egoh i Hésus owoy sa salu di mig-ipanaw, egtebow da diyà sebaen menuwa. Duen sa bayi dahiya, si Maleta, egpegemowen di Hésus i diyà sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Duen ma sa hadi di bayi, si Maliya. Egpenuu medapag diyà sa lisen i Datù Hésus enù ka egdinegdinegen di sa ketulù di. ");
INSERT INTO mta_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Dodoo egkelakà sa pedu i Maleta danà di egmengana kenagda. Agulé, eg-angay diyà si Hésus owoy guwaen di, “O Datù, maen di ya endà medaet sa pedu ko danà sa hadi ku egsalig diyà kenak sa langun kemengana? Amuk eghiduwan ko aken, sugù ko anì tumabang.” ");
INSERT INTO mta_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Dodoo egsagbì Datù i, guwaen di, “O Maleta, taa ko, hih. Medoo sa bogo ko danà sa medoo egbaelan ko. ");
INSERT INTO mta_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Dodoo sebaen daa sa mebaelan yu mepion. Hinemilì i Maliya sa mepion egbaelan owoy endà mekedan iya wé hinemilì di.” ");
INSERT INTO mta_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na, sebaen agdaw egsimbà Hésus i diyà sa kenà da eg-ugpà. Agulé, eg-ikagi sa sebaen salu di, guwaen di, “O Datù, tului ko kami sa ukit kesimbà iling sa ketulù i Huwan sa medoo pasek di.” ");
INSERT INTO mta_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Agulé guwaen i Hésus diyà kenagda, “Amuk sumimbà yu, guwaen yu, ‘O Emà, ungayà ké oloen ka etaw. Ungayà ké ma pedatù ka diyà sa langun etaw diyà siini sinukub langit. ");
INSERT INTO mta_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Begayi ko kami sa kaenen ké uman agdaw. ");
INSERT INTO mta_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Peuloyi ko sa medoo salà ké, enù ka hediya ma kami ipeuloy ké ma sa salà sa medoo duma ké. Tuliki ko ma kami anì endà mekeukit ké diyà sa kenà ké tepengan anì endà ma mekebael ké salà.’” ");
INSERT INTO mta_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Agulé, guwaen i Hésus diyà kenagda, “Upama, teliwadà sigep eg-angay ka diyà sa dalesan sa duma ko, owoy guwaen ko, ‘O Akay, pesagbayi ko hih sa kaenen diyà kenak, ");
INSERT INTO mta_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","enù ka migtebow dé sa loyuk ku kedu mediyù dò, owoy endà duen sa igmengana ku.’ ");
INSERT INTO mta_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Agulé, sumagbì sa duma ko kedu diatas, guwaen di, ‘Yaka egbogo kenak. Nepintuan sa dalesan ku owoy eg-idegà ké medoo anak ku. Endà mekeenaw a owoy endà ma mebegayan ku kuna.’ ");
INSERT INTO mta_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Na, taa yu, hih. Apiya di pa endà egpangunut siedò maama diyà sa egpegeniyen ko danà sa kehidu di keniko, mekepangunut doo danà sa kepeges ko. Umenaw owoy ibegay di sa sumalà dé sa kulang ko. ");
INSERT INTO mta_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hediya ma sa kesimbà yu. Amuk meudes yu sumimbà, mekekuwa yu doo sa egpegeniyen yu diyà si Nemula; owoy amuk lumagbet yu, mehaa yu doo sa lagbeten yu, owoy amuk umumow yu, mekegemow yu. ");
INSERT INTO mta_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Enù ka sumalà dé sa etaw meudes megeni, iya sa etaw mekekuwa; owoy sumalà dé sa etaw meudes lumagbet, iya sa etaw mekehaa; owoy sumalà dé sa etaw meudes umumow, iya sa etaw mekegemow. ");
INSERT INTO mta_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Upama, duen sebaen maama diyà keniyu. Amuk egpegeni uton sa anak di, endà mebaluy di begayan di uled. ");
INSERT INTO mta_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Amuk egpegeni anak manuk sa anak di, endà mebaluy di begayan di menipit. ");
INSERT INTO mta_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Apiya di pa endà metiengaw yu kiyu i, netiigan yu doo sa mepion ibegay yu diyà sa anak yu. Labi pa endà mepion sa ibegay sa Emà ta diyà langit, enù ka ibegay di doo sa Metiengaw Suguy di diyà sa etaw egpegeni.” ");
INSERT INTO mta_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na, pinelaun i Hésus sa busaw diyà sa maama nebuneg danà sa busaw miglahuk. Hê, egoh di miglesut, nekeikagi dé sa maama, huenan di negaip sa medoo etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Dodoo guwaen sa medoo liyu etaw, “Egpekegaga egpelesut busaw danà sa tunung i Bilsibul, sa datù busaw.” ");
INSERT INTO mta_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Duen ma liyu etaw eg-igsà panduan diyà si Hésus, enù ka tepengan da amuk tuu kagdi sa kedu si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Dodoo netiigan i Hésus sa penemdem da, huenan di guwaen di diyà kenagda, “Upama, sumalà dé sa medoo etaw eg-unut diyà sa datù, amuk sekuntelaay da, endà melugay di mekedan sa kedatù sa kaunutan da. Diya ma amuk sekuntelaay sa segemalay, endà ma melugay di mekedan sa menuwa da. ");
INSERT INTO mta_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na, guwaen yu pelesuten ku sa busaw danà sa tunung i Satanas. Dodoo amuk egkuntelaen i Satanas sa medoo busaw etaw di, endà melugay di mekedan sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Amuk tuu sa kagi yu egpelesut a busaw danà sa tunung ibegay i Bilsibul diyà kenak, ngadan keduwan di ya atu sa tunung sa duma yu egpelesut busaw? Netiigan ta butbut iya wé inikagi yu danà sa binaelan sa medoo duma yu, enù ka netiigan da kedu si Nemula sa egkegaga da owoy sa naken ma egkegaga. ");
INSERT INTO mta_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Na, amuk egpelesut a busaw danà sa tunung i Nemula, tuu ma doo migtebow dé sa kedatù i Nemula diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Agulé, igpegulepeng i Hésus Satanas i diyà sa maama egtulik, guwaen di, “Upama, duen sa maama mebagel egtulik sa dalesan di owoy medoo sa kinemkem di, huenan di endà duen sa mekekuwa sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Dodoo amuk egtebow sa maama uman pa mebagel, eggebeken di sa maama egtulik owoy eg-atuwan di owoy egkedanan di sa langun kinemkem di kenà di egsalig. Agulé eglampasen di sa langun taman di owoy itukidtukid di ibegay diyà sa medoo duma di.” ");
INSERT INTO mta_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Agulé guwaen i Hésus, “Sumalà dé sa etaw endà eg-unut di diyà kenak, iya sa etaw egkuntelà kenak. Owoy sumalà dé sa etaw endà egtabang di kenak egtipoh etaw, iya sa etaw tegehemaga.” ");
INSERT INTO mta_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Agulé guwaen i Hésus, “Amuk miglesut sa busaw kedu diyà sa etaw, egtimbultimbul eglagbet sa kenà di eg-ugpà diyà sa melabel tanà mediyù dalesan. Amuk endà eghauwen di duu sa kenà di eg-ugpà, guwaen di, ‘Pelikù a diyà sa tapay dalesan ku kenà ku miglegkang.’ ");
INSERT INTO mta_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Agulé, egoh di egtebow, hinaa di sa dalesan di pinegenoson owoy tinipoh sa langun taman di, dodoo endà duen etaw di. ");
INSERT INTO mta_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Agulé, eg-angayen di sa pitu duma di busaw uman pa medaet diyà kenagdi. Egpelikù da dema eglahuk langun owoy eg-ugpà da dahiya. Hê, ini egoh di egtemù sa kelikutan siini etaw linahuk da. Adi-adi pa sa egoh di anay linahuk.” ");
INSERT INTO mta_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Na, egoh i Hésus egtulù diyà sa medoo etaw, duen sa bayi duma da egpetaled eg-ikagi, guwaen di, “Neanggan sa bayi mig-anak keniko owoy migpesusu keniko.” ");
INSERT INTO mta_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dodoo guwaen i Hésus, “Iya polo sa meanggan sa medoo etaw egdinegdineg sa kagi i Nemula owoy egpangunut da ma.” ");
INSERT INTO mta_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Agulé, egkedoo sa etaw egkesetipon diyà si Hésus. Guwaen di, “Medeumà siini medoo etaw eg-ugpà diyà tanà ini egoh di, enù ka endà migtuu da gaa amuk endà hauwen da duu sa dakel panduan. Eg-igsaen da sa panduan, dodoo endà duen panduan ibegay i Nemula liyu daa sa panduan diyà si Honas egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Inamah sa dakel sedà Honas i taman telu agdaw, huenan di netiigan sa medoo etaw tegeNiniba kagdi sa sinugù i Nemula egoh anay. Hediya ma aken i Kakay Langun, duen sa mebaelan ku kani anì metiigan sa medoo etaw ini egoh di aken sa sinugù i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Na, amuk meuma sa agdaw i Nemula migtamay sa medoo etaw endà egpigtuu, tumigdeg sa dakel booy kedu sa mediyù tanà Siba, owoy sigbolowen di kiyu enù ka endà egpigtuu yu. ");
INSERT INTO mta_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Apiya di pa mediyù temù sa keduwan di, mig-angay doo egdinegdineg sa uledin i Nemula diyà si Datù Salomon egoh anay. Taa yu, hih. Apiya di pa uman pa dakel egkegaga sa maama dahini ini egoh di diyà si Salomon, tapay doo endà egpigtuu yu. Diya ma, amuk meuma siedò agdaw i Nemula, tumigdeg sa medoo etaw tegeNiniba owoy sigbolowen da kiyu enù ka inekedan da sa salà da egoh da migdineg sa ketegudon i Honas. Apiya di pa uman pa dakel egkegaga sa maama dahini ini egoh di diyà si Honas, tapay doo endà egpigtuu yu.” ");
INSERT INTO mta_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Agulé guwaen i Hésus, “Amuk duen etaw egtemtem palitaan, endà itagù di duu diyà sa sedep dalesan owoy endà ma pelagkeban di duu solok. Dodoo mehagtaw polo sa kenà di egtenà anì hauwen sa langun etaw eggemow sa legdaw di. ");
INSERT INTO mta_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Lagà palitaan diyà lawa yu sa mata yu enù ka iya sa iilag yu. Amuk mepion sa mata yu, lagà milegdaw sa langun lawa yu. Dodoo amuk medaetan sa mata yu, deleman sa lawa yu. ");
INSERT INTO mta_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hediya ma, hahaa yu anì endà medaet sa pedu yu, apiya di pa guwaen yu dò mepion sa pedu yu. ");
INSERT INTO mta_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dodoo amuk sebaen daa sa pedu yu diyà si Nemula, tigtu yu milegdaw. Apiya tukééy daa, endà duen delem diyà keniyu, enù ka lagà yu sa dalesan milegdaw danà sa palitaan di mehagtaw.” ");
INSERT INTO mta_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Agulé, egoh i Hésus egtulù, duen sa maama Palasiyu angayen di Hésus i pekaen dutu kenà di dò. Agulé, eggemow owoy egpenuu egkaen. ");
INSERT INTO mta_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dodoo negaip sa Palasiyu diyà si Hésus, enù ka endà dé egpegusê di egkaen nekeiling sa adat Palasiyu. ");
INSERT INTO mta_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Agulé guwaen i Datù diyà kenagdi, “Taa yu. Kiyu i medoo Palasiyu, lagà yu sa etaw eglingu sa medoo iyug tabù owoy batik, dodoo lueden doo sa dalem di. Hediya ma, eg-udes yu egpegusê sa lawa yu daa, dodoo lenglengen sa pedu yu owoy big-imawen yu. ");
INSERT INTO mta_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Endà mipedu yu kiyu i. Amuk binaelan i Nemula sa lawa yu owoy sa lungag yu ma, maen di ya endà egketiigan yu duu kagdi sa eghaa sa pedu yu ma? ");
INSERT INTO mta_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huenan di, pepion yu sa pedu yu anì mehaa etaw sa kehidu yu kenagda legkang diyà sa pedu yu, enù ka amuk mepion sa pedu yu endà mehaa di etaw, mepion ma doo sa egbaelan yu. ");
INSERT INTO mta_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“O medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu, enù ka apiya di pa egtaladan yu si Nemula sa medoo tukééy hinemula yu ipinanam kaenen, medaet doo sa adat yu diyà sa medoo duma yu owoy endà ma mehidu yu si Nemula. Nesugat sa egbaelan yu egtalad, dodoo eg-amu yu enù ka endà egpeunuten yu duu dahiya sa mepion adat yu owoy sa kehidu yu. ");
INSERT INTO mta_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“O medoo Palasiyu, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka egpeolòolò yu. Amuk mangay yu simbaan dò, ungayà yu menuu diyà sa bangkù ginelal, owoy egkeiyap yu ma amuk saluan sa medoo etaw kiyu diyà sa padian. ");
INSERT INTO mta_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka medaet sa adat yu mekedeket diyà sa medoo etaw. Lagà yu sa kenà lebeng endà duen tandà di ig-alang sa ukitan etaw.” ");
INSERT INTO mta_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Agulé, migsagbì sa sebaen tegetulù uledin igsugkow i Mosis, guwaen di, “O Mistelu, egpeumàumaan ko ma kami danà iya wé eg-ikagiyen ko.” ");
INSERT INTO mta_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Agulé guwaen i Hésus, “O medoo tegetulù uledin, hahaa yu. Dakel ma sa kepigtamay i Nemula mekeuma diyà keniyu enù ka egpebegatan yu sa medoo etaw danà sa medoo uledin yu melikut, dodoo kiyu, lagà endà egtabangan yu duu kagda egtiang sa mebegat. ");
INSERT INTO mta_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka eg-upionen yu sa kenà lebeng sa medoo tegesugkow i Nemula egoh anay, dodoo kagda sa inimatayan sa medoo tupù yu. ");
INSERT INTO mta_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lagà egpetuuwen yu sa kepatay da danà yu eg-upion sa lebeng da. Sa medoo tupù yu sa mig-imatay kenagda egoh anay, owoy kiyu sa eg-upion sa lebeng da. ");
INSERT INTO mta_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Iya maen di ya mig-ikagi Nemula i danà sa melabel pagitung di, guwaen di, ‘Peangayen ku diyà kenagda sa medoo tegesugkow ku owoy medoo salu ku. Dodoo duen duma etaw diyà kenagda pelihayen da polo owoy imatayan da ma.’ ");
INSERT INTO mta_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na, mepigtamayan sa medoo etaw eg-ugpà diyà tanà ini egoh di danà sa tupù yu mig-imatay sa langun tegesugkow i Nemula egoh anay edung egoh tanà binaelan taman ini egoh di, ");
INSERT INTO mta_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","kedu sa egoh i Abel inimatayan egoh anay taman sa egoh i Sakaliyas inimatayan medapag diyà sa kenà da mig-imatay hinagtay diyà sa Dalesan i Nemula egoh anay. Dodoo, langun sa tegesugkow inimatayan sa tupù yu, iya sa salà babaen yu kiyu i etaw eg-ugpà diyà tanà ini egoh di. ");
INSERT INTO mta_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","O medoo tegetulù uledin, hahaa yu. Dakel sa kepigtamay i Nemula mekeuma diyà keniyu enù ka lagà iglidung yu sa kagi i Nemula diyà baul owoy kinedanan yu ma sa gunsì di. Endà duen pedu yu migtuu sa kagi di owoy eg-alangen yu ma sa medoo etaw egkelukuy egpigtuu.” ");
INSERT INTO mta_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na, egoh i Hésus eg-ipanaw kedu dahiya, egpegesen sa medoo Palasiyu owoy sa medoo tegetulù uledin kagdi i enù ka ungayà da pedoowen di sa kagi di egsagbì kenagda. ");
INSERT INTO mta_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Egpelaeban da sa kagi di enù ka eglagbeten da sa kenà di mesalà anì metulon da. ");
INSERT INTO mta_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na, egoh i Hésus egtulù, ngibu-ngibuwan sa etaw egkesetipon diyà kenagdi taman egkesepisok da owoy egkeseutuh da. Agulé, muna eg-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Tulik yu anì mekeiwod yu sa ipelenuk epan sa etaw Palasiyu, enù ka guwaen da dò endà duen salà da. ");
INSERT INTO mta_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dodoo sa langun linimunan, meawangan doo; owoy sa langun linidung, mehaa doo. ");
INSERT INTO mta_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Huenan di, sumalà dé sa inikagi ko diyà delem, medineg doo diyà legdaw. Sumalà dé sa binadàbadà ko diyà tukééy bilik pinintuan, peegal-egal doo diyà duwangen. ");
INSERT INTO mta_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“O medoo loyuk ku, taa yu, hih. Yoko egkelimedangan duu sa etaw mekepatay keniyu diyà tanà, enù ka sa lawa yu daa sa ketamanan sa egkegaga da. ");
INSERT INTO mta_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Dodoo kelimedangi yu polo Nemula i, enù ka mekepatay owoy megaga di ma humemaga sa suguy etaw diyà sa lanaw apuy endà mepadeng. Huenan di, kagdi polo sa kelimedangi yu. ");
INSERT INTO mta_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Dodoo dakel doo sa kehidu i Nemula keniyu. Upama, apiya di pa tukééy sa lagà sa lima maya amuk dagangen, endà doo melipengan i Nemula duu, apiya sebaen daa. ");
INSERT INTO mta_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Labi pa endà metulengan i Nemula kiyu. Apiya sa balut ulu yu, netiigan di doo sa kedoo di, huenan di yoko egkelenawan na enù ka uman pa dakel sa lagà yu diyà sa medoo tukééy manuk.” ");
INSERT INTO mta_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na,” guwaen i Hésus, “eg-ikagiyen ku ini i diyà keniyu. Sa etaw egtulon diyà duma di sa kedatù di kenak, aken i Kakay Langun, iya ma sa tulonen ku diyà sa medoo egsugùsuguen i Nemula anì metiigan da kagdi sa etaw ku. ");
INSERT INTO mta_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Dodoo sa etaw egpalaw kenak diyà sa medoo duma di, iya ma sa etaw endà tulonen ku duu diyà sa medoo egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Na, amuk egsumbung sa etaw sa Kakay Langun, mekepeuloy pa sa salà di. Dodoo amuk egsumbung sa etaw sa Metiengaw Suguy i Nemula, endà mekepeuloy sa salà di.” ");
INSERT INTO mta_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Guwaen i Hésus, “Amuk meagak yu diyà sa medoo simbaan Hudiyu owoy diyà sa medoo kaunutan da anì tipuwen da kiyu, yoko egkebukul la egpenemdem sa kesagbì yu kenagda ataw ka sa ikagiyen yu, ");
INSERT INTO mta_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","enù ka amuk meuma sa egoh yu sumagbì, metiigan yu doo sa kesagbì yu nesugat danà yu netulù sa Metiengaw Suguy i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, duen sa etaw diyà sa medoo nesetipon dahiya. Guwaen di diyà si Hésus, “O Mistelu, tulù ko sa kakay ku maama anì baeden di diyà kenak sa lalawan ké diyà sa emà ké.” ");
INSERT INTO mta_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Dodoo guwaen i Hésus, “O Akay, beken aken sa datù yu diyà sa lalawan yu.” ");
INSERT INTO mta_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Agulé, guwaen i Hésus diyà sa medoo etaw, “Hahaa yu sa pedu yu anì endà egkeilayaman yu duu sa langun taman diyà tanà. Apiya subela sa langun taman sa etaw, beken iya sa linegkangan sa lalù di.” ");
INSERT INTO mta_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Agulé tinulonon di kagda balatan, guwaen di, “Duen sa maama kawasà, owoy tigtu nebaluy sa hinemulaan di. ");
INSERT INTO mta_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Agulé guwaen sa penemdem di, ‘Ay, egkelikutan a enù ka endà duen taguan ku sa medoo nekuwa ku.’ ");
INSERT INTO mta_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Owoy guwaen di ma, ‘Iya sa baelan ku, lukaten ku sa tapay dalesan taguan palay, owoy baelan ku sa uman pa dakel anì dumuen taguan sa palay ku owoy sa langun taman ku.’ ");
INSERT INTO mta_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Guwaen di ma diyà sa pedu di, ‘Duen medoo langun taman ku endà meimet di taman melugay. Huenan di, meked a dé eggalebek uman. Mista a polo anì mepion sa nanam ku.’ ");
INSERT INTO mta_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dodoo guwaen i Nemula diyà kenagdi, ‘Endà milantek sa penemdem ko. Igkani sigep mematay ka dé. Apiya di pa medoo sa langun taman ko, mekebegay doo diyà sa liyu etaw.’ ");
INSERT INTO mta_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Na, hediya ma sa mebaelan sa kawasà etaw egtagù sa langun pedu di diyà sa pantiyali di diyà tanà, dodoo endà kawasà di diyà sa kehaa i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Agulé, guwaen i Hésus diyà sa medoo salu di, “Iya sa pesuwan ku eg-ikagi a diyà keniyu, pelénég yu sa pedu yu denu sa hagtay yu. Yoko ma egkebukul la denu sa kaenen yu ataw ka sa ginis yu, ");
INSERT INTO mta_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","enù ka amuk milagà sa igbegay i Nemula sa lalù ta owoy sa lawa ta, melemu ma sa kebegay di sa kaenen yu owoy sa ginis yu. ");
INSERT INTO mta_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Haa yu sa medoo uwak. Endà eg-ohok da owoy endà ma egketu da. Endà ma duen sibay da ataw ka dalesan taguan palay. Dodoo egpekaenen i Nemula doo kagda. Labi pa endà ipaten di kiyu, enù ka uman pa milagà yu diyà sa medoo manuk. ");
INSERT INTO mta_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Apiya di pa egkebukul yu egpenemdem sa kelalù yu diyà tanà, endà doo mesumpatan yu duu apiya sakaulas daa. ");
INSERT INTO mta_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Amuk endà megaga yu duu siini tukééy kesumpat, endà ma duen pesuwan yu egkebukul denu sa hagtay yu diyà tanà. ");
INSERT INTO mta_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Haa yu sa medoo bulok. Apiya di pa endà eggalebek da owoy endà ma eghabel da ginis, metolol da doo. Taa yu, hih. Apiya di pa metolol sa ginis igluhub i Datù Salomon egoh anay, uman pa metolol sa medoo bulok diyà sa ginis i Salomon. ");
INSERT INTO mta_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nehagtay siini medoo bulok ini egoh di, dodoo simag, kuwaen etaw enù ka ulowen da diyà apuy. Na, amuk mepion sa kepeginis i Nemula bulok endà melugay di, uman pa mepion sa kepeginis di keniyu, o medoo etaw tukééy kepigtuu. ");
INSERT INTO mta_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yoko egkebukul la denu sa kaenen yu ataw ka sa ginis yu. Yoko ma egkebukul la egpenemdem sa hagtay yu ");
INSERT INTO mta_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","enù ka sa langun balangan etaw diyà tanà beken etaw i Nemula, takà da egkebukul denu sa hagtay da. Dodoo netiigan i Emà ta endà mehagtay yu amuk endà duen kaenen yu owoy ginis yu. ");
INSERT INTO mta_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dodoo kiyu, udesi yu polo sa kedatù i Nemula. Amuk hediya, mebegayan di ma kiyu sa hagtay yu.” ");
INSERT INTO mta_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Guwaen i Hésus, “O medoo etaw eg-ipaten ku, apiya di pa endà medoo yu, yoko egkelenawan na enù ka egpeunuten i Emà kiyu diyà sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Dagang yu sa langun taman yu owoy tukidi yu begayi diyà sa etaw pubeli. Amuk hediya, tiponen yu sa pantiyali yu diyà pitakà yu endà meledak di dutu langit dò. Endà ma mekedan di sa pantiyali yu owoy endà mekuwa di menakaw owoy endà ma medaetan di danà kaba. Iya sa mepion baelan yu ");
INSERT INTO mta_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","enù ka sumalà dé sa kenà sa pantiyali yu, iya ma sa kenà sa pedu yu.” ");
INSERT INTO mta_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Agulé guwaen i Hésus, “Tulik yu sa kepelikù ku lagà yu sa etaw eg-angat-angat egluhub dé sa ginis di owoy eg-ipat sulù anì endà mepadeng di. ");
INSERT INTO mta_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Huenan di, lagà yu sa egsugùsuguen eg-angat-angat sa datù da egtebow kedu diyà pista. Tulik yu anì mesiyapat yu eg-ukà amuk dinegen yu sa kagi di tumebow. ");
INSERT INTO mta_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Amuk tumebow sa datù, ataw ka teliwadà sigep ataw ka buyu sumimag, hauwen di sa medoo egsugùsuguen di egtulik. Tuu ini i eg-ikagiyen ku diyà keniyu. Kagda doo sa etaw di meanggan, enù ka pepenuuwen di kagda owoy kagdi polo sa egmengana kenagda lagà kagdi polo sa egsugùsuguen da. ");
INSERT INTO mta_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Taa yu, hih. Amuk netiigan sa épê sa dalesan sa ketebow sa tegepenakaw amuk sigep, unungan di anì endà mekeludep di dalem. ");
INSERT INTO mta_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Huenan di, tulik yu ma enù ka endà egketiigan yu sa agdaw sa Kakay Langun tumebow.” ");
INSERT INTO mta_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Agulé, guwaen i Pidelu, “O Datù, egpeligadan ko kami etaw ko, ataw ka sa langun etaw?” ");
INSERT INTO mta_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Guwaen i Datù, “Upama, ngadan di etaw sa sinaligan sa datù eghemilien di? Iya sa etaw hemilien di, sa egsugùsuguen di meudes owoy melabel penemdem. Kagdi sa kaunutan diyà sa medoo duma di egsugùsuguen owoy kagdi sa metiig egbegay kaenen diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Amuk tumebow sa datù, mebagian siedò kaunutan amuk mepion sa kepangunut di sa igsugù sa datù di. ");
INSERT INTO mta_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk mepion sa egbaelan di, kagdi sa mesaligan sa datù sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Dodoo sa kaunutan endà mipedu di, iya sa penemdem di melugay sa ketebow sa datù di. Agulé tapesen di sa egsugùsuguen maama owoy bayi, owoy takà egpista owoy eghiluwen. ");
INSERT INTO mta_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Hê, pelikù sa datù di diyà sa agdaw endà netulikan di duu owoy sa ulas endà netiigan di duu. Pigtamayan di temù enù ka iya sa ketamanan sa langun etaw endà mipedu. ");
INSERT INTO mta_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Na, amuk egpeketiig sa etaw sa uyot sa datù di, dodoo endà duen pedu di egpangunut, tapesen di temù. ");
INSERT INTO mta_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dodoo, amuk eg-amu sa sebaen egsugùsuguen di danà di endà neketiig sa uyot sa datù di, tapesen di ma doo dodoo tukééy daa. Amuk dakel sa egkegaga igsalig i Nemula diyà sa etaw, dakel ma sa galebek di eg-angat-angatan i Nemula. Owoy amuk medoo sa isalig sa medoo liyu etaw diyà sa etaw, dakel ma sa eg-angat-angatan da diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Agulé guwaen i Hésus, “Mig-angay a dahini anì uwiten ku sa apuy diyà tanà, enù ka medaetan sa melanih keugpà sa medoo etaw. Huenan di ungayà ku hedem netemteman dé. ");
INSERT INTO mta_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Dodoo, muna a pa mukit diyà sa dakel egkelikutan ku. Egkebukul temù sa pedu ku taman endà mekeukit a dahiya. ");
INSERT INTO mta_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yoko egpenemdem duu mig-angay a diyà tanà anì pelanihen ku sa pedu sa langun etaw. Dodoo taa yu, hih, uman da polo sekuntelaay danà ku mig-angay diyà tanà. ");
INSERT INTO mta_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Edung ini egoh di, endà nesesebaen sa pedu sa medoo etaw eg-ugpà diyà sebaen dalesan. Amuk lima da, mebaluy egkesekuntelà da sa telu owoy sa duwa. ");
INSERT INTO mta_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Egkesekuntelà sa lukes etaw sa anak di maama owoy bayi. Hediya ma, egkesekuntelà sa nugangan owoy sa awas di bayi.” ");
INSERT INTO mta_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Agulé, eg-ikagi ma Hésus i diyà sa medoo etaw nesetipon, guwaen di, “Amuk hauwen yu sa dakel alung denu eledan agdaw, iya sa kagi yu, ‘Mudan kani.’ Hê, metuu sa kagi yu. ");
INSERT INTO mta_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Amuk eghauwen yu ma sa kelamag kedu kimataan, iya sa kagi yu, ‘Umagdaw ini egoh di.’ Hê, metuu ma doo sa inikagi yu. ");
INSERT INTO mta_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ay, tegeakal yu kiyu i, enù ka apiya di pa neketiig yu sa medoo tandà udan owoy sa medoo tandà agdaw, endà doo netiigan yu duu sa tandà eghauwen yu ini egoh di. ");
INSERT INTO mta_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Negaip a diyà keniyu enù ka endà netiigan yu duu sa nesugat baelan yu. ");
INSERT INTO mta_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Amuk duen etaw tumipu keniko, angay ka pehiduhidu diyà kenagdi diyà dalan anì endà uwiten di duu kuna diyà sa uwis. Iya maen di ya enù ka amuk meuwit ka diyà sa uwis, ibegay di kuna diyà sa pulis anì mebilanggu ka. ");
INSERT INTO mta_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Taa ko, hih. Amuk mebilanggu ka, endà mekelaun ka taman endà mekeimpas ka sa langun salà ko.” ");
INSERT INTO mta_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na, duen etaw mig-angay da egtulon diyà si Hésus denu sa medoo tegeGaliliya igpeimatay i Gubilenu Pilatu diyà sa Dalesan i Nemula egoh da eg-imatay hinagtay ibegay diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Agulé egsagbì Hésus i, guwaen di, “Iya sa penemdem yu kéen, uman pa dakel sa salà siini nematay diyà sa salà sa medoo duma da tegeGaliliya enù ka tigtu medaet sa kinepatay da. ");
INSERT INTO mta_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dodoo, taa yu. Endà tuu di iya wé penemdem yu. Diya ma kiyu i, mekesugsug yu ma doo amuk endà ekedan yu duu sa niyu salà. ");
INSERT INTO mta_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Haa yu ma sa sepulù owoy walu etaw nematay diyà sa menuwa Siloyi danà sa dakel dalesan pupù nepilay. Iya sa penemdem yu kéen, uman pa dakel sa salà siini nematay diyà sa salà sa langun tegeHélusalém. ");
INSERT INTO mta_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dodoo, taa yu. Endà tuu di iya wé penemdem yu. Diya ma kiyu i, mekesugsug yu ma doo amuk endà ekedan yu duu sa niyu salà.” ");
INSERT INTO mta_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Agulé, egpeligad Hésus i, guwaen di, “Duen sa kayu pigus hinemula sa maama diyà sa hinemulaan di kayu. Agulé, eg-angayen di eglagbet sa bunga di, dodoo endà duen hinaa di. ");
INSERT INTO mta_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Huenan di, guwaen di diyà sa egsugùsuguen di eg-ipat kayu, ‘Haa ko. Telu gepalay a eg-angay eglagbet bunga diyà siini kayu, dodoo endà duen eghauwen ku. Pilay ko dé, enù ka egkelapis siini tanà ku danà di endà egbunga siini kayu.’ ");
INSERT INTO mta_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Agulé, egsagbì sa eg-ipat kayu, guwaen di, ‘O Datù, maen dé pelawà taman segepalay pa, enù ka kali-kaliyen ku pelawà sa tanà di owoy abunuwan ku ma. ");
INSERT INTO mta_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mepion hedem amuk munga amuk segepalay pa. Dodoo amuk endà dé munga di, iya pelawà pilayen ku diyà keniko.’” ");
INSERT INTO mta_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na, sebaen Sapetu sa agdaw keetud da, egtulù Hésus i diyà sa sebaen simbaan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Duen sa bayi dahiya egkelikutan danà busaw, enù ka sepulù owoy walu gepalay dé sa lugay di nebugkug owoy endà egpekebaluy di egtigdeg petudà. ");
INSERT INTO mta_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Egoh i Hésus eghaa kenagdi, inumow di owoy guwaen di, “O Inà, nelengaan ka dé sa linadu ko.” ");
INSERT INTO mta_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Agulé, egsabaan i Hésus. Hê, petow dé migtigdeg owoy eg-oloen di Nemula i. ");
INSERT INTO mta_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Dodoo egkelangget sa kaunutan eg-ipat simbaan, enù ka migbulung Hésus i diyà sa agdaw keetud da. Agulé egsigbolow, guwaen di diyà sa medoo etaw dahiya, “Uman sakapadian, enem agdaw sa lugay yu egpekegalebek. Huenan di, iya polo sa medoo agdaw yu egpebulung, beken ini egoh di enù ka agdaw keetud.” ");
INSERT INTO mta_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dodoo sinagbian i Hésus, guwaen di, “Tegeakal yu kiyu i. Amuk sa agdaw keetud, eggalebek yu ma doo enù ka lengaan yu ma sa sapì yu ataw ka sa kudà yu anì peinemen yu. ");
INSERT INTO mta_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Haa yu siini bayi, apiya tugod i Ablaham kagdi i, sepulù owoy walu gepalay dé sa lugay di lagà pinolot i Satanas. Maen di ya endà mepion di amuk melengaan diyà sa agdaw keetud?” ");
INSERT INTO mta_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na, danà iya wé inikagi i Hésus, egkemalaan sa langun kuntelà di, dodoo egkeanggan sa medoo liyu etaw dahiya danà sa medoo dakel egbaelan di egkegaipan da. ");
INSERT INTO mta_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Agulé, eg-uman Hésus i egtulù, guwaen di, “Enù di ya, ngadan sa pegulepengan ku sa kedatù i Nemula anì metiigan yu? ");
INSERT INTO mta_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Sa kedatù di lagà segebelahan dalem mustad hinemula sa maama diyà sa hemulaan di. Apiya tukééy temù, egoh di egtubù, egtepengen di sa kehagtaw kayu owoy mekebaluy sumalag sa medoo manuk diyà sa panga di.” ");
INSERT INTO mta_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Guwaen i Hésus ma, “Ngadan sa pegulepengan ku sa kedatù i Nemula? ");
INSERT INTO mta_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lagà sa yis ipelenuk epan sa kedatù di. Apiya di pa tigtu tukééy sa ig-amut sa bayi diyà sa medoo temù tapung amuk egbael epan, endà melugay di eglenuk langun.” ");
INSERT INTO mta_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na, egoh i Hésus eg-ipanaw eg-angay Hélusalém dò, egtukiden di egtulù sa medoo menuwa eg-ukitan di. ");
INSERT INTO mta_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Agulé, duen sa etaw eg-igsà, guwaen di, “O Datù, enù di ya endà medoo di kéen sa etaw mealukan i Nemula?” Guwaen i Hésus diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Tukééy daa sa selat ukitan etaw mangay diyà sa kedatù i Nemula. Huenan di, udes yu lagbet anì mekeangay yu dalem, enù ka medoo sa etaw kumelukuy dumalem kani dodoo endà dé mekedalem da. ");
INSERT INTO mta_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Amuk pintuan sa épê dalesan sa selat di, endà dé mekegemow yu, apiya tumigdeg yu owoy takà yu tumeguktuk sa bengawan di. Apiya umumow yu, guwaen yu, ‘O Datù, ukai ko kami,’ sagbian di kiyu, guwaen di, ‘Endà nelayaman ku duu kiyu.’ ");
INSERT INTO mta_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Agulé guwaen yu, ‘Kami sa duma ko egkaen owoy eg-inem egoh anay, owoy migtulù ka ma diyà sa menuwa ké.’ ");
INSERT INTO mta_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Dodoo guwaen di, ‘Taa yu, endà nelayaman ku kiyu ya. Pediyù yu dé diyà kenak, kiyu i tegebael salà.’ ");
INSERT INTO mta_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na, amuk meuma sa kedatù i Nemula, hauwen yu sa pineunut di dahiya si Ablaham owoy si Isak owoy si Hakob owoy sa medoo tegesugkow i Nemula. Dodoo hemagawan di kiyu i duu dutu siedò kenà yu mepigtamayan. Suminegaw yu dutu owoy kuméget sa ngipen yu danà yu tigtu mepasangan. ");
INSERT INTO mta_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Amuk meuma sa kedatù i Nemula, dumuen medoo balangan etaw beken Hudiyu umunut kedu diyà sa langun balangan tanà diyà siini sinukub langit. Mesetipon da langun enù ka mista da dahiya. ");
INSERT INTO mta_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na, kumedakel doo sa duma etaw tukééy dé diyà sa kehaa yu ini egoh di. Dodoo kumetukééy polo sa duma etaw dakel diyà sa kehaa yu ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na egoh iya, duen duma Palasiyu egpedapag da diyà si Hésus, owoy guwaen da, “Salidi ko dé sa menuwa ké enù ka ungayà i Datù Hélod imatayan di kuna gaa.” ");
INSERT INTO mta_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Agulé guwaen i Hésus diyà kenagda, “Apiya tegepandapat siedò datù yu, angay yu tulon kenagdi siini kagi ku, guwaen ku, ‘Haa ko. Pelesuten ku sa medoo busaw owoy bulungan ku sa medoo eglinadu siini agdaw owoy simag ma. Amuk meuma sa ketelu di agdaw, meubus dé sa galebek ku.’ ");
INSERT INTO mta_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Na, siini agdaw diyà a dalan owoy simag owoy sebaen simag taman endà tumebow a Hélusalém dò, enù ka endà mebaluy di mekesugsug sa tegesugkow i Nemula amuk endà dutu di. ");
INSERT INTO mta_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O medoo etaw tegeHélusalém, taa yu, hih. Takà yu eg-imatay sa medoo tegesugkow i Nemula, owoy egsebuungen yu ma batu sa medoo etaw pineangay di diyà keniyu anì mematay da. Nelugay dé sa pedu ku egtipoh keniyu anì ipaten ku kiyu, lagà a umelen egtipoh sa anak di, dodoo eg-eked yu. ");
INSERT INTO mta_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Haa yu siini menuwa yu igtohonen dé i Nemula. Taa yu, hih, ini i eg-ikagiyen ku diyà keniyu. Endà dé mehaa yu duu aken taman endà pelumanan yu sa pedu yu diyà kenak. Iya pelawà mehaa yu aken amuk mikagi yu, guwaen yu, ‘Meolò ta sa pineangay i Datù Nemula diyà tanà.’” ");
INSERT INTO mta_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na, sebaen Sapetu agdaw keetud da, eg-angay Hésus i egkaen diyà sa dalesan sa sebaen kaunutan sa medoo Palasiyu. Egtulikan da sa egbaelan di. ");
INSERT INTO mta_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hê, duen sa maama eglinadu lagbuk dahiya. ");
INSERT INTO mta_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Agulé, eg-ikagi Hésus i diyà sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo Palasiyu, guwaen di, “Enù di ya, amuk mulung sa etaw diyà sa agdaw keetud, meketipay pa diyà sa uledin ta ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Dodoo endà egsagbì da. Agulé, sinabaan i Hésus sa etaw eglinadu owoy egbulungan di. Hê, egoh di nelikuan, pinelikù di dé. ");
INSERT INTO mta_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Agulé guwaen i Hésus diyà kenagda, “Upama, amuk nenabù sa anak yu ataw ka sa hinagtay yu dalem sa paligì, ngadan di etaw iya wé amuk endà petow di umaluk apiya sa agdaw keetud?” ");
INSERT INTO mta_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dodoo endà egpekesagbì da. ");
INSERT INTO mta_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na, egoh i Hésus eg-ugpà pelawà diyà sa kenà Palasiyu, eghahauwen di sa medoo etaw egpanteken da takà sa medoo penuuwan sa etaw ginelal diyà sa medapag lamisan. Huenan di, egtulonon di kagda balatan, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Amuk isasà da kuna diyà sa pista kawing, yaka egpenuu duu sa penuuwan sa etaw ginelal, enù ka mebaluy duen ma duma etaw igsasà da uman pa dakel gelal diyà keniko. ");
INSERT INTO mta_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Amuk tumebow siedò etaw épê dakel gelal, mangay sa egsasà diyà keniko owoy guwaen di, ‘Halì ka, hih, enù ka kagdi polo sa menuu dahini.’ Agulé, kemalaan ka dema humalì mangay menuu diyà sa medoo duma ko endà duen gelal. ");
INSERT INTO mta_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Dodoo iya polo sa baelan ko. Amuk eglenged ka pista, angay ka penuu diyà sa penuuwan sa medoo etaw endà duen gelal. Agulé amuk tumebow sa egsasà, mebaluy ikagiyan di kuna, guwaen di, ‘O Akay, téél ka dé. Penuu ka polo daedò é diyà sa penuuwan sa medoo ginelal.’ Na, amuk hediya, kumedakel ka diyà sa kehaa sa langun etaw diyà sa pista. ");
INSERT INTO mta_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Iya maen di ya enù ka sa etaw egpedakelen di kagdi, iya sa petukééyen i Nemula, dodoo sa etaw egpetukééyen di kagdi, iya polo sa pedakelen i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Agulé, eg-ikagiyan i Hésus sa maama migsasà kenagdi, guwaen di, “Amuk kuna sa egbael pista, yaka egsasà duu sa medoo loyuk ko ataw ka sa medoo hadi ko maama ataw ka sa medoo tigtu duma ko ataw ka sa medoo duma ko kawasà. Iya maen di ya enù ka mekesulì da ma sumasà keniko lagà egbayadan da kuna. ");
INSERT INTO mta_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Dodoo amuk egbael ka pista, mepion amuk isasà ko sa medoo etaw pubeli owoy sa medoo etaw nedaetan lawa owoy sa medoo etaw pikat owoy sa medoo langap. ");
INSERT INTO mta_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Amuk iya sa egbaelan ko, meanggan ka doo apiya di pa endà mekesulì da sumasà owoy endà ma mekebayad da keniko. Meanggan ka doo enù ka mebegayan i Nemula kuna untung amuk enawen di sa medoo etaw di metiengaw.” ");
INSERT INTO mta_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Agulé, duen sa sebaen maama duma i Hésus egkaen diyà sa lamisan. Egoh di migdineg iya wé inikagi i Hésus, guwaen di diyà kenagdi, “Amuk meuma sa kedatù i Nemula, meanggan mendaa sa etaw umunut kumaen diyà sa pista di.” ");
INSERT INTO mta_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Dodoo guwaen i Hésus diyà kenagdi, “Duen sa sebaen maama egbael dakel pista, owoy igsasà di sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Agulé, egoh di neuma sa agdaw da egkaen, pineangay di sa egsugùsuguen di diyà sa medoo etaw igsasà di. Guwaen di, ‘Angay yu dé diatas gaa, enù ka nelegà dé sa kaenen pista.’ ");
INSERT INTO mta_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dodoo langun da egdawà. Guwaen sa sebaen igsasà di diyà sa egsugùsuguen di, ‘Endà mekeangay a dutu enù ka duen sa tanà bineli ku owoy angayen ku pelawà tumelow. Pehiduhidu a diyà kenagdi anì endà bulitan di duu aken.’ ");
INSERT INTO mta_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Agulé, guwaen sa sebaen ma igsasà di, ‘Endà mekeangay a dutu enù ka duen sa bineli ku sepulù sapì kinapun owoy mangay a pelawà tumepeng sa kegalebek da. Pehiduhidu a diyà kenagdi anì endà bulitan di duu aken.’ ");
INSERT INTO mta_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Agulé, guwaen sa ketelu igsasà di ma, ‘Endà mekeangay a dutu enù ka magtu a migsawa.’ ");
INSERT INTO mta_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Agulé, eglikù sa egsugùsuguen di diyà sa kaunutan di owoy tinulon di sa keeked sa medoo igsasà di. Egoh di migdineg iya wé, egbulit owoy guwaen di, ‘Téél ka dé angay ka diyà sa medoo kalasada owoy dalan diyà sa menuwa ta, owoy uwit ko angay dini sa medoo etaw hinaa ko, iling ka pubeli etaw ataw ka etaw nedaetan lawa ataw ka langap.’ ");
INSERT INTO mta_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Agulé egoh sa egsugùsuguen migtebow dema, guwaen di, ‘O Kaunutan, inuwit ku dé sa medoo etaw igsugù ko, dodoo subela sa kaenen binaelan ko diyà sa kedoo da.’ ");
INSERT INTO mta_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Agulé, guwaen sa kaunutan diyà sa egsugùsuguen di, ‘Angay ka dema lagbet sa medoo etaw endà duen dalesan, sa medoo egtimbultimbul diyà dalan diyà sa kilidan menuwa ta. Tegel ko kagda uwit anì mebelet etaw sa dalesan ku. ");
INSERT INTO mta_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Dodoo sa anay igsasà ku, apiya sebaen, endà mekesawit da sa kaenen binaelan ku.’” ");
INSERT INTO mta_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na, duen melaweng etaw eg-unut diyà si Hésus egoh di eg-ipanaw. Agulé, eg-isaluwan di kagda owoy guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Endà mebaluy di egpepasek sa etaw diyà kenak amuk beken aken daa sa tigtu eghiduwan di. Endà mebaluy di amuk endà eglowon sa kehidu di kenak diyà sa kehidu di liyu etaw, iling sa emà di ataw ka sa inay di ataw ka sa sawa di ataw ka sa anak di ataw ka sa medoo duma di telehadi. Apiya sa hagdi ungayà, meekedan di ma doo. ");
INSERT INTO mta_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Endà mebaluy di egpepasek sa etaw diyà kenak amuk endà metigkelan di duu sa kelikutan di lagà sa egoh di egtiang sa bugsud kenà di mematay. Diya ma endà mebaluy di egpepasek amuk endà takà di umunut-unut diyà kenak. ");
INSERT INTO mta_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Upama, amuk duen sebaen duma ko egpenemdem egbael sa dakel dalesan, muna egpenemdemen di sa lagà di owoy sa kedoo pilak di ataw ka mekeenget taman meubus. ");
INSERT INTO mta_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Amuk endà nekeenget sa pilak di, endà megaga di duu umubus sa dalesan di. Agulé eggemenan sa medoo duma di, ");
INSERT INTO mta_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","guwaen da, ‘Siini maama eg-edung egbael dalesan hedem, dodoo endà neubus di duu.’ ");
INSERT INTO mta_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Hediya ma, sa datù amuk sumulì eggila diyà sa sebaen ma datù, muna penemdemen di sa kedoo etaw di salagsà amuk mekegaga da diyà sa kuntelà di tumebow épê duwa lagsà. ");
INSERT INTO mta_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Amuk iya sa antap di endà mekegaga da, suguen di sa duma etaw di peangay dutu amuk mediyù pelawà sa kuntelà di anì seikagiyay da mepion anì endà mesegila da. ");
INSERT INTO mta_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hediya ma kiyu i, amuk ungayà yu egpepasek diyà kenak, muna tepengi yu sa pedu yu amuk mekegaga yu umeked sa langun taman yu owoy sa langun duma yu ma. Amuk endà mekegaga yu, endà mebaluy di pepasek yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Na, lagà sa timus nekedanan keemis di sa etaw endà nekegaga di eg-eked sa langun egkeiyapan di. Mepion doo sa timus, dodoo amuk mekedan dé sa keemis di, endà dé mebaluy di peemis. ");
INSERT INTO mta_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Apiya di pa iamut yu diyà sa abunu anì itagù diyà sa hinemulaan, endà doo mebaluy di. Iya daa polo sa baeli yu, buungi yu dé. Amuk mipedu yu egdineg, penemdem yu dé sa kagi ku dinineg yu.” ");
INSERT INTO mta_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na, sa medoo atung egpeetuken sa sulutan owoy sa medoo tegebael salà, takà da eg-angay diyà si Hésus anì dinegen da sa kagi di. ");
INSERT INTO mta_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Huenan di, egsigbolow sa medoo Palasiyu owoy sa medoo tegetulù uledin igsugkow i Mosis, guwaen da, “Endà mepion ini i maama enù ka egsaluan di sa medoo tegebael salà owoy eg-unut ma kenagda egkaen.” ");
INSERT INTO mta_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Agulé, migtulon Hésus i balatan diyà kenagda, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Upama, duen sa maama diyà keniyu épê magatus kebilibili. Amuk netelas sa sebaen, salidan di sa siyow pulù owoy siyow diyà sa keluwenluwen owoy eg-angayen di eglagbet sa sebaen netelas taman endà eghauwen di duu. ");
INSERT INTO mta_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Agulé, egoh di mighaa sa sebaen kebilibili di, neiyap sa pedu di owoy tiniang di eglikù. ");
INSERT INTO mta_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Agulé, egoh di migtebow diatas, inumow di sa medoo loyuk di owoy sa medoo duma di owoy guwaen di, ‘O medoo duma ku, meanggan ki dé enù ka hinaa ku dé sa kebilibili ku netelas.’ ");
INSERT INTO mta_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Taa yu, hih. Hediya ma, meanggan ma Nemula i owoy sa medoo egsugùsuguen di diyà langit amuk duen sa sebaen etaw tegebael salà eg-ekedan di dé sa salà di. Dodoo endà duen maen da meanggan danà sa siyow pulù owoy siyow etaw guwaen da dò endà duen salà da.” ");
INSERT INTO mta_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Agulé guwaen i Hésus, “Upama, duen sa bayi épê sepulù kuleta milagà. Amuk netelas sa sebaen, temteman di sa palitaan owoy megenos ma lumagbet. Egtemuen di eglagbet sa kuleta netelas taman endà hauwen di duu. ");
INSERT INTO mta_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Agulé, egoh di mighaa sa kuleta, egsetiponen di sa medoo loyuk di owoy sa medoo duma di, owoy guwaen di, ‘O medoo duma ku, keanggani yu ma dé enù ka hinaa ku dé sa kuleta ku netelas.’ ");
INSERT INTO mta_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Taa yu, hih. Hediya ma, meanggan ma sa medoo egsugùsuguen i Nemula diyà langit amuk duen sa sebaen etaw tegebael salà eg-ekedan di dé sa salà di.” ");
INSERT INTO mta_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Agulé, guwaen i Hésus, “Duen sa maama épê duwa anak maama. ");
INSERT INTO mta_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Agulé, guwaen sa hadi anak di diyà sa emà di, ‘O Emà, baed ko sa langun taman ko. Begayi ko dé aken ini egoh di sa naken lalawan.’ Agulé, binaed di diyà kenagda sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na, endà ma melugay di, tinipoh sa hadi anak di sa langun taman di. Mig-ipanaw mig-angay dutu mediyù dò, owoy kinedanan di dutu sa langun taman di danà sa medoo kadupangan binaelan di. ");
INSERT INTO mta_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Agulé, egoh di neimet sa langun taman di, migtenà pengagdaw binitil sa langun etaw diyà sa kenà di eg-ugpà, owoy nelikutan ma sa hagtay di. ");
INSERT INTO mta_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huenan di, mig-angay eggalebek diyà sa maama épê tanà dahiya. Sinugù sa épê tanà kagdi dutu siedò keluwenluwen anì pekaenen di sa medoo babuy lii di. ");
INSERT INTO mta_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hê, tigtu egpeketues temù owoy egkeimawan di hedem egkaen sa kaenen babuy, enù ka endà duen etaw egbegay kaenen diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Hê, neketuleng dema sa maama, owoy guwaen di, ‘Subela sa kaenen sa medoo maama eggalebek diyà sa emà ku, dodoo egpekesugsug a polo dahini danà bitil. ");
INSERT INTO mta_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lumegkang a mangay diyà sa emà ku, owoy mikagi a pa diyà kenagdi, “O Emà, nesalà a diyà si Nemula owoy diyà keniko ma. ");
INSERT INTO mta_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Huenan di, endà pelawà mebaluy di amuk aken sa anak ko, dodoo pegalebek ko aken iling sa medoo tegegalebek diyà keniko.”’ ");
INSERT INTO mta_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Hê, miglegkang eg-angay dutu siedò kenà emà di. Dodoo egoh di mediyù pa, hinaa sa emà di egsugpayal. Nedaetan pedu sa emà di owoy migletu egtelabuk kenagdi. Kininagpaan di owoy iningadekan di. ");
INSERT INTO mta_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Agulé, guwaen sa anak di, ‘O Emà, nesalà a diyà si Nemula owoy diyà keniko. Huenan di, endà pelawà mebaluy di amuk aken sa anak ko.’ ");
INSERT INTO mta_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Dodoo guwaen sa emà di diyà sa medoo egsugùsuguen di, ‘Petéél yu uwit sa temù mepion ginis anì pekawal yu. Tagui yu ma sa tising diyà sa belad di owoy sa talumpà diyà sa lisen di. ");
INSERT INTO mta_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kuwa yu sa nati sapì mitabà owoy dulisi yu anì mista ki ");
INSERT INTO mta_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","enù ka lagà nematay dé sa anak ku, dodoo nehagtay doo. Lagà netelas, dodoo hinaa doo.’ Agulé, eg-edung da egpista. ");
INSERT INTO mta_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, dutu siedò tinibah da sa kakay anak di maama. Egoh di miglikù medapag diyà sa dalesan, egdinegen di sa medoo dagì dalemetan owoy sa medoo egdelayaw. ");
INSERT INTO mta_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hê, inumow di sa sebaen egsugùsuguen da owoy inigsà di, guwaen di, ‘Maen di ya egpista da?’ ");
INSERT INTO mta_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Agulé guwaen sa egsugùsuguen, ‘Migtebow dé sa hadi ko maama. Dinulisan sa emà ko sa nati sapì mitabà, enù ka egpistawan di sa hadi ko migpelikù dé enù ka nehagtay doo owoy metéél doo sa lawa di.’ ");
INSERT INTO mta_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Dodoo migbulit sa kakay anak di owoy mig-eked eg-angay diatas. Agulé, miglesut sa emà di owoy inikagiyan di anì gumemow. ");
INSERT INTO mta_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Dodoo sinagbian di sa emà di, guwaen di, ‘Haa ko. Medoo a dé gepalay eg-ugpà diyà keniko lagà sa egsugùsuguen ko, owoy endà duen sebaen inekedan ku sa igsugù ko. Dodoo apiya sa nati kambing daa, endà igbegay ko duu diyà kenak anì mista ké sa medoo loyuk ku. ");
INSERT INTO mta_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Dodoo egoh di migtebow siini dupang anak ko nekeimet sa langun taman ko danà sa kepigbayi di, egdulisan ko dé sa nati sapì mitabà anì mista yu.’ ");
INSERT INTO mta_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Agulé, guwaen sa emà di, ‘O Adug, tapay ka dé eg-ugpà diyà kenak, owoy lagà niko sa langun taman ku. ");
INSERT INTO mta_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yaka egkedaet sa pedu ko. Mepion amuk meanggan ki polo enù ka lagà nematay sa hadi ko, dodoo nehagtay doo. Lagà netelas, dodoo hinaa dé.’” ");
INSERT INTO mta_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na, egtulon ma peligad Hésus i diyà sa medoo salu di, guwaen di, “Duen sa maama sinaligan sa kawasà etaw sa langun taman di. Dodoo dinineg sa kawasà etaw kinedanan sa salu di sa duma langun taman di. ");
INSERT INTO mta_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Huenan di, igpeangay di sa salu di owoy guwaen di, ‘Duen sa dinineg ku kinedanan ko sa duma langun taman ku gaa. Uwit ko dini sa langun sulat ko denu sa langun taman igsalig ku diyà keniko, enù ka endà depa muman a sumalig diyà keniko.’ ");
INSERT INTO mta_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Agulé guwaen pedu iya wé salu di, ‘Ay, nelikutan a enù ka tuu sa dinineg di. Endà dé dumuen sa hagtay ku enù ka endà dé uman di duu isalig diyà kenak. Endà mekegaga a gumalebek diyà tanà, owoy endà ma mekepegeni a enù ka memala a.’ ");
INSERT INTO mta_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Agulé, neketuleng sa penemdem di. Guwaen di diyà sa pedu di, ‘Netiigan ku dé sa baelan ku anì dumuen medoo loyuk ku mekelomò kenak, amuk mekedan sa hagtay ku danà sa kaunutan ku eghemaga kenak.’ ");
INSERT INTO mta_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hê, igpeangay di sigbaenbaenay sa langun etaw nekeutang diyà sa kaunutan di. Guwaen di diyà sa muna egtebow, ‘Enù kedoo di ya sa utang ko diyà sa kaunutan ku?’ ");
INSERT INTO mta_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Guwaen di, ‘Magatus kalatà lana.’ Agulé guwaen sa salu, ‘Kuwa ko siini sulat utang ko. Penuu ka owoy sulati ko daa polo lima pulù.’ ");
INSERT INTO mta_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Agulé, guwaen di dema diyà sa sebaen nekeutang, ‘Enù kedoo di ya sa utang ko?’ Guwaen di, ‘Magatus gesakù palay.’ Guwaen sa salu, ‘Kuwa ko siini sulat utang ko. Sulati ko daa polo walu pulù.’ ");
INSERT INTO mta_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Na, apiya di pa inekedan sa maama kawasà sa salu di endà mipedu, eg-oloen di doo sa penemdem di mebagel. Na, haa yu sa medoo etaw diyà tanà endà egpigtuu diyà si Nemula, uman pa dakel sa ketiigan da egkuwa untung diyà sa ketiigan sa medoo etaw egpigtuu diyà si Nemula lagà legdaw. ");
INSERT INTO mta_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Huenan di, ini sa eg-ikagiyen ku diyà keniyu. Amuk duen pantiyali yu, lagbet yu mepion na egbaelan yu anì meseloyuk yu sa medoo etaw. Amuk meimet sa medoo pantiyali yu diyà tanà, peugpaen i Nemula kiyu dutu langit dò kani.” ");
INSERT INTO mta_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Agulé, guwaen i Hésus, “Amuk kesaligan sa etaw apiya tukééy sa igsalig diyà kenagdi, kesaligan ma doo amuk dakel sa igsalig diyà kenagdi. Dodoo amuk logkù pedu sa etaw eg-ipat sa tukééy igsalig diyà kenagdi, logkù ma doo sa pedu di amuk dakel sa igsalig diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Huenan di, amuk endà kesaligan ka eg-ipat sa pantiyali ko diyà tanà, endà ma duen sumalig diyà keniko sa tigtu pantiyali melalù. ");
INSERT INTO mta_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Amuk endà kesaligan ka eg-ipat sa igsalig sa sebaen etaw diyà keniko, endà ma duen megay diyà keniko sa tigtu pantiyali ko melalù. ");
INSERT INTO mta_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Endà mebaluy di amuk duwa sa kaunutan sa maama atung egsugùsuguen, enù ka sebaen daa sa eghiduwan di owoy sa sebaen egkelepuhan di. Sebaen daa sa egpangunutan di owoy sa sebaen eg-ekedan di. Hediya ma, endà mebaluy di amuk duwa sa kaunutan yu, ataw ka si Nemula ataw ka sa medoo pantiyali yu.” ");
INSERT INTO mta_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na, egdinegdinegen sa medoo Palasiyu sa langun igtulù di denu pantiyali. Dodoo eggemenan da kagdi enù ka kagda sa dakel pedu diyà pantiyali. ");
INSERT INTO mta_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Agulé, guwaen i Hésus diyà kenagda, “Ubòubò yu egpetiengaw keniyu diyà sa kehaa sa medoo etaw, dodoo netiigan i Nemula doo sa pedu yu. Apiya di pa tigtu mepion sa egbaelan yu diyà sa kehaa etaw, iya polo sa tigtu medaet diyà sa kehaa i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Agulé guwaen i Hésus, “Edung egoh anay taman endà egtebow si Huwan Tegebautis, iya sa tegudon egpangunutan yu sa medoo uledin igsugkow i Mosis owoy sa igsulat sa medoo tegesugkow i Nemula egoh anay. Dodoo edung egoh i Huwan egtebow, egdinegen yu sa Mepion Tegudon denu sa kedatù i Nemula, owoy ini egoh di duen medoo etaw egkelukuy da eg-unut sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Dodoo apiya di pa mekedan sa langit owoy sa tanà, endà mebaluy di mekedan sa igtulù i Nemula igsugkow i Mosis, apiya tukééy daa. ");
INSERT INTO mta_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ini sa sebaen igtulù i Nemula endà mekedan di. Amuk eg-ekedan sa maama sa sawa di, mekebigà doo amuk sawaen di sa sebaen bayi. Owoy mekebigà ma sa maama amuk sawaen di sa bayi inekedan sa sawa di.” ");
INSERT INTO mta_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Agulé guwaen i Hésus, “Duen sa maama kawasà igluhub di sa medoo ginis tigtu milagà, owoy uman agdaw lagà kaenen pista sa egkaenen di. ");
INSERT INTO mta_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Duen ma sa maama pubeli, si Lasalo. Neseluh liboh sa lawa di, owoy takà eghibat diyà duwangen dalesan sa kawasà. ");
INSERT INTO mta_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eg-angat-angatan di egkaen sa medoo kaenen egketaktak kedu diyà sa lamisan sa kawasà. Apiya sa medoo tuyang, takà da eg-angay egdilà sa medoo liboh di. ");
INSERT INTO mta_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Na, nematay sa maama pubeli, owoy inuwit sa medoo egsugùsuguen i Nemula sa suguy di dutu siedò eg-ugpaan i Ablaham diyà bayà. Agulé, nematay ma sa maama kawasà owoy iglebeng da. ");
INSERT INTO mta_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mig-angay sa suguy di dutu bayà dò kenà di egkepasangan temù. Egoh di eg-ugpà dahiya, egsugpayalen di mediyù si Ablaham owoy si Lasalo neseabay da. ");
INSERT INTO mta_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Agulé egpetaled eg-umow, guwaen di, ‘O Bébê Ablaham, hiduwi ko aken. Sugù ko Lasalo ya anì dulétén di wayeg siini dilà ku enù ka egkepasangan a temù danà sa legleg apuy dahini.’ ");
INSERT INTO mta_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Dodoo guwaen i Ablaham, ‘O Adug, netulengan ko pa sa keugpà yu si Lasalo diyà tanà? Egoh iya, mepion sa nesakem ko, dodoo medaet sa nesakem i Lasalo. Na, ini egoh di mepion dé sa keugpà i Lasalo, dodoo kuna polo sa egkepasangan dahiya. ");
INSERT INTO mta_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dodoo, duen ma sa pesuwan di endà egsuguen ku duu egpeangay diyà keniko. Duen diyà sa teliwadà ta sa dakel nesekawangan tanà anì endà meseamut ki. Endà mekebatas sa etaw mangay diyà keniyu, owoy endà ma mekebatas sa etaw mangay dini kedu diyan.’ ");
INSERT INTO mta_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Agulé guwaen sa kawasà, ‘O Bébê, amuk hediya, duen sa egpegeniyen ku diyà keniko. Peangay ko Lasalo ya dutu dalesan i Emà ku dò, ");
INSERT INTO mta_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","enù ka duen lima pa hadi ku maama. Ungayà ku hawidan di kagda anì endà mekeangay da ma diyà siini kenà ku egkepasangan.’ ");
INSERT INTO mta_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Dodoo guwaen i Ablaham, ‘Duen diyà kenagda sa uledin igsugkow i Mosis owoy sa igsulat sa medoo tegesugkow i Nemula. Mepion amuk pigtuuwen da iya wé.’ ");
INSERT INTO mta_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Dodoo guwaen di, ‘O Bébê Ablaham, endà migtuu da amuk iya daa. Dodoo amuk duen etaw mangay diyà kenagda kedu diyà siini kenà nematay, ekedan da doo sa salà da.’ ");
INSERT INTO mta_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Dodoo guwaen i Ablaham, ‘Amuk endà egpigtuu da sa uledin igsugkow i Mosis owoy sa igsulat sa medoo tegesugkow i Nemula, endà ma migtuu da apiya di pa duen sa umenaw kedu diyà sa kenà nematay.’” ");
INSERT INTO mta_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na, guwaen i Hésus diyà sa medoo salu di, “Duen doo sa takà egbegay salà diyà etaw, dodoo tigtu mepigtamayan sa etaw eg-enggat sa duma di diyà salà. ");
INSERT INTO mta_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Adi-adi pa amuk tagkesan dakel batu diyà sa lieg di owoy mekebuung diyà dagat, anì endà meenggat di diyà salà sa etaw ku éhê siini batà. ");
INSERT INTO mta_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Huenan di, tulik yu dé sa egbaelan yu. “Na, amuk mesalà sa duma ko egpigtuu, indaw ko kagdi, owoy amuk ekedan di sa salà di, peuloyi ko dé. ");
INSERT INTO mta_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Apiya nesalà diyà keniko pitu gulê segeagdaw, dodoo uman mangay diyà keniko, guwaen di, ‘Inekedan ku dé sa salà ku,’ peuloyi ko dema kenagdi sa langun salà di.” ");
INSERT INTO mta_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Agulé, guwaen sa medoo salu di diyà si Datù, “Umani ko sa kepigtuu ké.” ");
INSERT INTO mta_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Guwaen i Datù, “Apiya di pa tukééy daa sa kepigtuu yu diyà kenak lagà tukééy dalem mustad, dakel doo sa megaga yu. Upama, amuk suguen yu siini dakel kayu pehalì dalem dagat, mangunut doo diyà sa kagi yu owoy mehemula dema dutu.” ");
INSERT INTO mta_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Guwaen i Hésus, “Upama, duen sa egsugùsuguen ko egdadu ataw ka eg-ipat kebilibili. Amuk lumikù diatas kedu diyà sa galebekan di, endà mepion di amuk muna kumaen egoh ko endà pa kumaen. ");
INSERT INTO mta_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Iya polo sa guwaen ko diyà kenagdi, ‘Baeli ko pelawà sa kaenen ku. Sambii ko sa ginis ko melanih owoy mengana ko aken taman meubus a egkaen owoy eg-inem. Iya ka pelawà kaen owoy inem.’ ");
INSERT INTO mta_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Taa ko siedò egsugùsuguen ko. Apiya di pa egpangunut diyà sa langun igsugù ko, endà duen pesuwan di egsubela sa pedu ko enù ka iya ma daa sa eg-angat-angatan ko diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Diya ma kiyu i. Apiya di pa egpangunut yu dé sa langun igsugù i Nemula keniyu, iya daa sa meikagi yu, guwaen yu, ‘Kita sa egsugùsuguen i Nemula daa. Endà duen pesuwan di egsubela sa pedu di diyà kenita enù ka iya daa sa eg-angat-angatan di diyà kenita.’” ");
INSERT INTO mta_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na, egoh i Hésus eg-angay Hélusalém dò, mig-ukit teliwadaan diyà uwang Samaliya owoy uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Egoh di egtebow diyà sa sebaen menuwa dahiya, duen sepulù maama eglinadu dempid egtelabuk kenagdi. Egtigdeg da mediyùdiyù ");
INSERT INTO mta_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","owoy egpetaled da eg-ikagi, guwaen da, “O Hésus, o Datù, hiduwi ko kami.” ");
INSERT INTO mta_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Egoh i Hésus eghaa kenagda, guwaen di, “Angay yu pehaa diyà sa tegesimbà diyà Dalesan i Nemula.” Hê, egoh da eg-ipanaw, nekedan dé sa linadu da. ");
INSERT INTO mta_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Agulé, egoh sa sebaen maama hinaa di nelikuan dé, egpelikù dema owoy egpetaled eg-ikagi eg-olò si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Egligkued diyà sa taengan i Hésus owoy egpesalamat diyà kenagdi. Na, etaw Samaliya sa maama migpelikù. ");
INSERT INTO mta_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Agulé guwaen i Hésus, “Apiya di pa binulungan ku sa sepulù kedoo da, sebaen daa sa egpelikù eg-olò si Nemula, owoy beken etaw Hudiyu kagdi ya. Negaip a, enù ka endà ma egpelikù sa siyow duma ta etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Agulé, guwaen i Hésus diyà sa maama nelikuan, “Tigdeg ka dé owoy ipanaw ka dé, enù ka nelikuan ka danà sa kepigtuu ko.” ");
INSERT INTO mta_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na, duen etaw Palasiyu mig-igsà da diyà si Hésus sa pasad sa kedatù i Nemula tumebow. Agulé egsagbì, guwaen di, “Endà hauwen di etaw sa ketebow sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Endà ma meikagi di etaw, guwaen di, ‘Kaini dé sa kedatù di,’ ataw ka ‘Daedò é.’ Taa yu, diyà doo pedu sa medoo etaw sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Agulé guwaen i Hésus diyà sa medoo salu di, “Meuma pa sa agdaw egoh yu tigtu meiyap humaa sa kedatù sa Kakay Langun diyà tanà, dodoo endà pa mehaa yu duu, apiya segeagdaw daa. ");
INSERT INTO mta_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Dumuen etaw mikagi diyà keniyu, guwaen da, ‘Kaini dé,’ ataw ka ‘Daedò é.’ Dodoo yoko eg-unut ta eg-angay dutu, ");
INSERT INTO mta_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","enù ka sa kepelikù sa Kakay Langun, lagà legdaw silà mekebensek diyà uwang tanà enù ka mehaa doo sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Dodoo muna mepelihay sa Kakay Langun owoy meekedan ma sa medoo etaw eg-ugpà diyà tanà ini egoh di. ");
INSERT INTO mta_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Na, amuk meuma sa pasad sa Kakay Langun, mepetow sa medoo etaw eg-ugpà diyà tanà éhê mendaa sa medoo etaw duma i Nuwi egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Egoh iya, endà eglengaan da duu sa medoo egbaelan da diyà tanà, enù ka egkaen da owoy eg-inem da owoy egpesawa da taman endà egdalem Nuwi i diyà sa dakel kumpit. Hê, egdagpak sa dakel kemahà owoy nepetow negelà sa langun etaw nesamà. ");
INSERT INTO mta_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Diya ma egoh i Lot eg-ugpà diyà tanà. Endà eglengaan sa medoo etaw duma di sa medoo egbaelan da diyà tanà, enù ka egkaen da owoy eg-inem da owoy egbeli da owoy egdagang da owoy eghemula da owoy egbael da dalesan. ");
INSERT INTO mta_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Dodoo, sa agdaw egoh i Lot egpelaguyan di sa menuwa Sodoma, duen apuy owoy asulpul éhê baga nenabù kedu langit lagà meleges udan. Nepetow negelà sa langun etaw nesamà dahiya. ");
INSERT INTO mta_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Diya ma amuk meuma sa agdaw sa Kakay Langun pehaa diyà tanà, mepetow ma doo sa langun etaw.” ");
INSERT INTO mta_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Guwaen i Hésus, “Amuk meuma siedò agdaw, amuk diyà duwangen sa etaw owoy diatas sa langun taman di, endà mebaluy di amuk gumemow angayen di. Diya ma amuk diyà tinibah sa etaw, endà dé mebaluy di amuk lumikù angayen di sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ketulengi yu sa sawa i Lot. Nematay danà di egpelikù eglalingay egoh di egpelaguy kedu Sodoma. ");
INSERT INTO mta_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sa etaw big-ulaanen, iya sa etaw mekesugsug. Dodoo sa etaw endà big-ulaanen, iya sa etaw melalù. ");
INSERT INTO mta_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Taa yu, hih. Amuk meuma sa sigep di pehaa diyà tanà, dumuen duwa etaw egtudug diyà sebaen kateli. Mekedan sa sebaen owoy mesamà sa duma di. ");
INSERT INTO mta_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dumuen ma duwa bayi eggiling, mekedan sa sebaen owoy mesamà sa duma di. ");
INSERT INTO mta_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dumuen ma duwa maama diyà sa tinibah, mekedan sa sebaen owoy mesamà sa duma di.” ");
INSERT INTO mta_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Agulé, guwaen sa medoo salu di, “O Datù, kenà iya wé mebaelan?” Guwaen i Hésus diyà kenagda, “Upama, sumalà dé sa kenà sa nematay, iya ma sa kenà da mesetipon sa medoo uwak. Diya ma, metiigan yu doo sa ketebow ku.” ");
INSERT INTO mta_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Agulé, egtulon balatan Hésus i anì itulù di kenagda anì takà da egsimbà anì endà ma mesemek da. ");
INSERT INTO mta_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Guwaen di, “Diyà sa sebaen dakel menuwa, duen sa datù endà mehidu di. Endà eg-adatan di duu Nemula i ataw ka sa medoo liyu etaw. ");
INSERT INTO mta_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Duen ma sa bayi balu diyà siedò menuwa takà eg-angay diyà sa datù, owoy guwaen di, ‘O Datù, tabangi ko aken. Antang ko kami sa kuntelà ku tegepelihay.’ ");
INSERT INTO mta_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dodoo eg-eked polo egtabang kenagdi. Agulé, egoh di melugaylugay pa, guwaen sa datù diyà sa pedu di, ‘Apiya di pa endà eg-adatan ku duu Nemula i ataw ka sa medoo liyu etaw, ");
INSERT INTO mta_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tabangan ku doo umantang siini bayi balu takà egbogo kenak. Amuk endà tabangan ku duu, egkebogo a temù danà di takà eg-angay dahini.’” ");
INSERT INTO mta_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Agulé guwaen i Datù Hésus, “Taa yu, hih, sa inikagi iya wé datù. Apiya di pa endà eg-adatan di duu sa medoo liyu etaw, egtabangan di doo sa etaw takà egpegeni tabang diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Amuk hediya sa binaelan iya wé datù, labi pa endà tabangan i Nemula duu sa medoo etaw hinemilì di takà egsimbà diyà kenagdi agdaw owoy sigep. Amuk endà egkesemek da egsimbà, endà ma melugay sa ketabang di diyà kenagda, ");
INSERT INTO mta_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","dodoo medelamet polo sa ketabang di. Huenan di, yoko egkesemek ka egsimbà. Dodoo amuk pelikù a diyà tanà, aken i Kakay Langun, endà medoo di kéen sa etaw egpigtuu hauwen ku.” ");
INSERT INTO mta_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na, egtulon Hésus i balatan diyà sa etaw melepuh sa duma da enù ka guwaen da dò metiengaw da etaw owoy egsalig da daa diyà sa hagda pedu. ");
INSERT INTO mta_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Guwaen di, “Duen duwa maama eg-angay egsimbà diyà sa Dalesan i Nemula. Sa sebaen, Palasiyu, owoy sa sebaen, maama atung egpeetuken sa sulutan. ");
INSERT INTO mta_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Agulé, egtigdeg teliwadà sa Palasiyu owoy egsimbà diyà sa pedu di daa, guwaen di, ‘O Nemula, egpesalamat a diyà keniko enù ka mepion a etaw. Endà eg-ilingan ku duu sa medoo liyu etaw enù ka tegelapis da owoy endà mipedu da owoy tegebigà da ma. Egpesalamat a ma diyà keniko enù ka endà eg-ilingan ku duu siini maama atung egpeetuken sa sulutan. ");
INSERT INTO mta_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mepion ma sa adat ku enù ka duwa gulê uman sakapadian egpeulanen ku sa kekaen ku anì sumimbà a, owoy egtalad a ma diyà keniko sa langun taman ku.’ ");
INSERT INTO mta_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Dodoo sa maama atung egpeetuken sa sulutan, egpediyùdiyù egtigdeg diyà sa kenà medoo etaw. Endà eglengag di langit dò enù ka egkemalaan, owoy egdukduken di daa sa kagpa di danà di egkebukul. Guwaen di, ‘O Nemula, hiduwi ko aken enù ka aken sa etaw tegebael salà.’ ");
INSERT INTO mta_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na, taa yu, hih. Amuk miglikù da dé diatas, siini maama polo sa pineuloyon i Nemula salà, beken sa Palasiyu. Iya maen di ya enù ka sa etaw egpedakelen di kagdi, iya sa petukééyen i Nemula, dodoo sa etaw egpetukééyen di kagdi, iya sa pedakelen i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na, duen etaw eg-uwit diyà si Hésus sa medoo tukééy batà anì sabaan di owoy isimbà di. Dodoo, egoh sa medoo salu di eghaa iya wé, eghawidan da kagda. ");
INSERT INTO mta_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Dodoo inumow i Hésus sa medoo eg-uwit batà eg-angay diyà kenagdi, owoy guwaen di, “Pandayà yu dé sa medoo batà mangay diyà kenak. Yoko eghawid duu, enù ka iya sa etaw mekeunut diyà sa kedatù i Nemula sa medoo etaw egpekeiling pedu batà. ");
INSERT INTO mta_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa etaw endà egpekeiling di pedu batà sa kepigtuu di diyà si Nemula, iya sa etaw endà mekeunut di diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na, duen dahiya sa kaunutan Hudiyu eg-igsà diyà si Hésus, guwaen di, “O Mistelu, tigtu mepion ka etaw. Ngadan sa baelan ku anì mekesakem a sa lalù endà meelut di?” ");
INSERT INTO mta_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Agulé guwaen i Hésus, “Maen di ya eg-ikagiyen ko aken mepion a etaw? Endà duen mepion etaw liyu daa si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Netiigan ko doo sa medoo uledin igsugkow i Mosis, guwaen di, yoko egbigà ya, owoy yoko eg-imatay ya etaw, owoy yoko egpenakaw wa, owoy yoko egbutbut ta egtipu sa duma yu, owoy adati yu sa emà yu owoy sa inay yu.” ");
INSERT INTO mta_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Agulé guwaen sa maama, “Langun siini uledin di anan egpangunutan ku edung egoh ku batà pelawà.” ");
INSERT INTO mta_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Egoh i Hésus egdineg iya wé, guwaen di, “Kulang pa sebaen sa baelan ko. Dagang ko sa langun taman ko owoy tukidi ko begayi diyà sa medoo etaw pubeli. Amuk hediya, dumuen sa pantiyali ko diyà langit. Agulé angay ka dini unut-unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dodoo egoh di egdineg iya wé, nebukul temù sa kaunutan enù ka tigtu kawasà. ");
INSERT INTO mta_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hê, egoh i Hésus eghaa sa egoh di nebukul temù, guwaen di, “Tigtu melikut sa medoo kawasà etaw mekeunut diyà sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Uman pa melemu sa hinagtay kamiliyu eg-ukit diyà sa tosong dagum diyà sa kawasà etaw mekeunut diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Egoh sa medoo etaw egdineg iya wé kagi di, guwaen da, “Amuk hediya, endà duen etaw kéen mealukan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Guwaen i Hésus, “Tuu ma doo, endà mebaluy di amuk etaw daa, dodoo amuk si Nemula, mebaluy doo.” ");
INSERT INTO mta_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Agulé guwaen i Pidelu, “Taa ko. Sinalidan ké dé sa langun taman ké enù ka eg-unut-unut ké keniko. Enù kami i duu, ngadan sa mehaa ké?” ");
INSERT INTO mta_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Agulé guwaen i Hésus diyà kenagda, “Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa maama sinalidan di sa dalesan di, ataw ka sa emà di owoy sa inay di, ataw ka sa medoo hadi di maama, ataw ka sa sawa di, ataw ka sa medoo anak di danà di eg-unut-unut sa kedatù i Nemula, ");
INSERT INTO mta_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","meumanan pa kumedoo sa mesakem di ini egoh di owoy dumuen ma sa lalù di endà meelut di amuk sambian i Nemula siini tanà.” ");
INSERT INTO mta_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Agulé, tinipon i Hésus sa sepulù owoy duwa salu di, owoy guwaen di diyà kenagda, “Taa yu, hih. Mangay ki Hélusalém dò. Amuk tumebow ki dutu, meketuu sa langun igsulat sa medoo tegesugkow i Nemula egoh anay denu sa Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mekebegay a diyà sa medoo etaw beken Hudiyu. Peumàumaan da aken owoy pelihayen a ma owoy teptepan a ma. ");
INSERT INTO mta_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tapesen a ma owoy imatayan da ma aken. Dodoo amuk meuma sa ketelu di agdaw, meenaw a doo.” ");
INSERT INTO mta_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dodoo sa medoo salu di, endà netiigan da duu sa inikagi di, enù ka nelidung, huenan di endà neketiig da. ");
INSERT INTO mta_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Na, egoh i Hésus buyu dé egtebow diyà sa menuwa Héliko, duen sa maama langap egpenuu egpegeni pilak diyà sa kilidan kalasada. ");
INSERT INTO mta_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Egoh di egdineg sa melaweng etaw egtalà, inigsà di sa egbaelan da. ");
INSERT INTO mta_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Agulé, tinulonon da egtalà Hésus i tegeNasalét. ");
INSERT INTO mta_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Hê, eg-umow, guwaen di, “O Hésus, tugod i Dabid, hiduwi ko aken.” ");
INSERT INTO mta_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Agulé, sa etaw muna diyà si Hésus, hinawidan da, guwaen da, “Yaka egséléken na.” Dodoo eg-uman polo eg-umow metaled, guwaen di, “O tugod i Dabid, hiduwi ko aken.” ");
INSERT INTO mta_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Agulé, eg-ugpà Hésus i, owoy igsugù di igpeuwit diyà kenagdi sa langap. Egoh di medapag, inigsaan di, ");
INSERT INTO mta_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","guwaen di, “Ngadan iya wé egkeiyapan ko baelan ku diyà keniko?” Guwaen di, “O Datù, ungayà ku umilag a hedem.” ");
INSERT INTO mta_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Agulé, guwaen i Hésus diyà kenagdi, “Meilag ka dé. Nelikuan ka dé danà sa kepigtuu ko.” ");
INSERT INTO mta_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hê, petow dé mig-ilag sa langap. Eg-unut-unut ma dé diyà si Hésus owoy takaan di eg-olò Nemula i. Egoh sa langun etaw eghaa iya wé, eg-oloen da ma Nemula i. ");
INSERT INTO mta_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Agulé, migtebow Hésus i diyà menuwa Héliko owoy eg-ukit dahiya. ");
INSERT INTO mta_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na, duen sa maama tegeHéliko, si Sakiyu. Kagdi sa kaunutan sa medoo atung egpeetuken sa sulutan, owoy kawasà ma. ");
INSERT INTO mta_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ungayà di humaa si Hésus, dodoo endà egpekehaa di enù ka mepokò etaw owoy nedilungan sa melaweng etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huenan di, migletu mighunahuna Sakiyu i, owoy egkagbul diyà sa kayu kepengadan da sikamolo anì hauwen di Hésus i enù ka mukit dahiya. ");
INSERT INTO mta_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Agulé, egoh i Hésus egtebow diyà sa kenà di, eglengag owoy eghauwen di. Guwaen di, “O Sakiyu, petééltéél ka hulus, enù ka mekeugpà a diyà sa dalesan ko ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Hê, mesiyapat eghulus owoy egsaluan di Hésus i. Pinegemow di diyà sa dalesan di owoy tigtu neiyap sa pedu di. ");
INSERT INTO mta_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dodoo egoh sa medoo etaw eghaa sa kegemow da, egsesigbolowoy da, guwaen da, “Maen di ya eglengenan i Hésus iya wé maama tegebael salà?” ");
INSERT INTO mta_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Agulé egpedapag Sakiyu i diyà si Hésus, owoy guwaen di, “O Datù, haa ko. Ibegay ku igkani diyà sa medoo etaw pubeli sebaed sa langun taman ku. Amuk linapis ku sa etaw, pesubelawen ku pa sa ipelikù ku diyà kenagda. Upama, amuk sebaen sa kinuwa ku, pelikuen ku epat.” ");
INSERT INTO mta_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Agulé guwaen i Hésus, “Siini agdaw egtebow dé sa kealuk i Nemula diyà siini malayan ko danà sa kepigtuu ko. Haa ko, kuna sa tigtu tugod i Ablaham enù ka egpigtuu ka ma lagà kagdi. ");
INSERT INTO mta_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Iya pesuwan di mig-angay sa Kakay Langun diyà tanà enù ka eglagbeten di sa medoo etaw egpekesugsug anì mealukan da.” ");
INSERT INTO mta_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na, egoh sa medoo etaw dahiya egdinegdineg siini eg-ikagiyen i Hésus, guwaen da dò buyu dé ipehaa sa kedatù i Nemula diyà kenagda, enù ka medapag da dé diyà Hélusalém. Huenan di, egtulon peligad Hésus i, ");
INSERT INTO mta_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","guwaen di, “Duen sa mapulù etaw mig-angay dutu siedò mediyù tanà anì kumedatù dutu dodoo pelikù mendaa. ");
INSERT INTO mta_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Agulé, egoh di buyu mipanaw, inumow di sa sepulù egsugùsuguen di, owoy tinukid di kagda egbegay sa sepulù kuleta bulawan, guwaen di, ‘Peanak yu siini pilak isalig ku diyà keniyu taman endà tumebow a.’ ");
INSERT INTO mta_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dodoo egkelepuhan da kagdi i sa medoo etaw duma di dahiya. Huenan di, egoh di mig-ipanaw, ipeuwit da ma sulat dutu siedò eg-angayan di, guwaen da, ‘Endà egkeiyap ké siini maama kumedatù diyà kenami.’ ");
INSERT INTO mta_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Dodoo migkedatù doo. Agulé, egoh di egpelikù, igpeangay di sa medoo egsugùsuguen di sinaligan di pilak anì hauwen di sa untung nekuwa da. ");
INSERT INTO mta_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Agulé, egtebow sa muna egsugùsuguen di, guwaen di, ‘O Datù, sa sebaen kuleta igbegay ko kenak nekeuma dé sepulù.’ ");
INSERT INTO mta_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Agulé guwaen sa datù, ‘Mepion sa binaelan ko. Apiya tukééy sa igsalig ku keniko, kuna sa mepion egsugùsuguen ku kesaligan, huenan di kuna sa salu ku diyà sa sepulù dakel menuwa.’ ");
INSERT INTO mta_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Agulé, egtebow ma sa keduwa egsugùsuguen di, guwaen di, ‘O Datù, sa sebaen kuleta igbegay ko kenak nekeuma dé lima.’ ");
INSERT INTO mta_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Agulé egsagbì sa datù, guwaen di, ‘Kuna sa salu ku diyà sa lima dakel menuwa.’ ");
INSERT INTO mta_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Agulé, egtebow ma sa sebaen, guwaen di, ‘O Datù, kaini doo sa kuleta ko igtagù ku binekut ku musala. ");
INSERT INTO mta_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Iya maen di ya endà duen untung ko enù ka egkelimedangan ku kuna. Netiigan ku kuna sa mebalaw etaw, enù ka dakel sa untung mekuwa ko apiya beken niko sa inay di, owoy apiya di pa beken kuna sa mig-ohok meketu ko doo sa medoo palay.’ ");
INSERT INTO mta_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Agulé guwaen sa datù, ‘Sa inikagi ko, iya sa kenà di nehaa sa salà ko. Kuna sa egsugùsuguen ku endà mipedu. Netiigan ko aken sa mebalaw etaw. Netiigan ko ma mekuwa ku untung apiya beken naken sa inay di owoy apiya beken aken sa mig-ohok meketu ku doo sa palay. ");
INSERT INTO mta_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Maen di ya endà igsalig ko duu sa pilak ku diyà sa medoo etaw atung egpantiyali? Amuk hediya, mehaa ku sa pilak ku owoy sa anak di ma egoh ku egtebow.’ ");
INSERT INTO mta_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Agulé, guwaen sa datù diyà sa medoo duma etaw dahiya, ‘Kuwa yu sa kuleta di owoy begayi yu diyà sa etaw épê sepulù.’ ");
INSERT INTO mta_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Dodoo negaip da owoy guwaen da, ‘O Datù, duen doo sa sepulù diyà kenagdi, maen di ya umanan ko?’ ");
INSERT INTO mta_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Dodoo guwaen sa datù da, ‘Taa yu hih. Mebegayan pa uman sa etaw kesaligan. Dodoo sa etaw endà kesaligan, apiya tukééy sa langun taman di mekedan pa uman. ");
INSERT INTO mta_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, sa medoo kuntelà ku, siedò duma ta endà egkeiyap kenak kumedatù diyà kenagda, uwit yu dahini owoy imatayi yu diyà sa taengan ku.’” ");
INSERT INTO mta_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na, egoh i Hésus mig-ikagi iya wé, eghunawan di sa medoo etaw eg-angay Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Agulé, egoh di medapag diyà sa menuwa Bétaniya owoy menuwa Bétpagi diyà sa Getan Olibu, sinugù di sa duwa salu di, ");
INSERT INTO mta_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","guwaen di, “Huna yu dé angay dutu siedò menuwa tebowon ta. Amuk tumebow yu dutu, hauwen yu sa hinagtay nati asnu igtagkes endà pa nelayam di egkudaan. Lengà yu owoy uwit yu dini. ");
INSERT INTO mta_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Amuk duen etaw umigsà keniyu, guwaen di, ‘Maen di ya eglengaen yu?’ iya sa sagbì yu, guwaen yu, ‘Igsugù i Datù enù ka duen sa penemdem di.’” ");
INSERT INTO mta_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Agulé, mig-ipanaw sa duwa sinugù di owoy hinaa da sa tinulon di diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Agulé, egoh da eglengà sa nati, guwaen sa épê di, “Maen di ya eglengaen yu sa nati?” ");
INSERT INTO mta_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Guwaen da egsagbì, “Igsugù i Datù enù ka duen sa penemdem di.” ");
INSERT INTO mta_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Agulé, inuwit da sa nati asnu diyà si Hésus. Inampisan da ginis sa iyug di owoy pekudaen da Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Egoh di eg-ipanaw, igtenàtenà sa medoo etaw sa ginis da diyà sa ukitan di, enù ka egtandaan da sa kedatù da kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na, egoh i Hésus medapag diyà Hélusalém egoh di endà pa lumungel diyà sa Getan Olibu, eg-edung sa medoo etaw di eg-olò si Nemula. Egpetaleden da sa kagi da eg-olò owoy egpesalamat da diyà si Nemula danà sa medoo dakel panduan binaelan i Hésus hinaa da. ");
INSERT INTO mta_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Guwaen da, “Meolò ini i Datù ta pineangay i Datù Nemula. Metanà sa pedu sa langun etaw dutu langit dò, owoy meolò ma Nemula i diyà langit.” ");
INSERT INTO mta_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Duen ma etaw Palasiyu eg-unut diyà si Hésus, owoy guwaen da diyà kenagdi, “O Mistelu, hawidi ko sa medoo pasek ko eg-olò keniko.” ");
INSERT INTO mta_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Dodoo egsagbì Hésus i, guwaen di, “Taa yu. Apiya pesabuhen ku siini medoo etaw ku, sa medoo batu polo sa metaled umolò.” ");
INSERT INTO mta_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Agulé, egoh i Hésus medapag diyà Hélusalém, egsugpayalen di sa menuwa owoy egsinegaw danà sa kehidu di sa medoo etaw eg-ugpà dahiya. ");
INSERT INTO mta_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Guwaen di, “Kiyu i tegeHélusalém, mepion pa hedem amuk neketiig yu ini egoh sa medoo egpigtuuwen yu anì kumelanih sa keugpà yu, dodoo lagà nedilungan diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Melikutan yu kani enù ka tumebow sa pasad sa medoo kuntelà yu gumila diyà keniyu. Ulinguten da kutà sa menuwa yu owoy pelaeban sundalu kiyu anì endà mekepelaguy yu. ");
INSERT INTO mta_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Gelaen da kiyu langun taman sa medoo anak yu. Lukaten da sa langun dalesan yu batu taman mesepalak sa langun batu sinelogsudlogsud. Mekesugsug yu enù ka endà netiigan yu duu ini sa agdaw i Nemula umaluk keniyu hedem.” ");
INSERT INTO mta_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na, egoh i Hésus migtebow Hélusalém dò, migludep diyà sa Dalesan i Nemula owoy hinemagawan di sa medoo etaw tegedagang hinagtay dahiya. ");
INSERT INTO mta_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Guwaen di diyà kenagda, “Iya sa kagi i Nemula igpesulat, guwaen di, ‘Sa dalesan ku iya sa dalesan atung egsimbaan etaw.’ Dodoo danà sa egbaelan yu, nebaluy dalesan sa medoo tegelapis siini Dalesan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na, uman agdaw egtulù Hésus i diyà sa Dalesan i Nemula. Dodoo sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo kaunutan etaw Hudiyu, eglagbeten da polo sa ukit da mimatay kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Dodoo endà megaga da duu egpetuu sa uyot da, enù ka tigtu egkeiyap sa medoo etaw egdineg sa kagi di. ");
INSERT INTO mta_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na, sebaen agdaw egoh i Hésus egtulù diyà sa medoo etaw diyà Dalesan i Nemula, itulù di sa Mepion Tegudon. Egoh di telibubu egtulù, eg-angay diyà kenagdi sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis owoy sa medoo kaunutan Hudiyu. ");
INSERT INTO mta_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mig-ikagi da, guwaen da, “Tuloni ko kami, hih, ngadan keduwan sa egkegaga ko egbael siini medoo egbaelan ko? Ngadan di etaw sa migpeangay keniko?” ");
INSERT INTO mta_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Egsagbì Hésus i, guwaen di, “Duen ma igsà ku diyà keniyu. Sagbii yu, hih. ");
INSERT INTO mta_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Enù di ya, ngadan sa migsugù si Huwan egoh di migbautis sa medoo etaw diyà wayeg, ataw ka si Nemula ataw ka sa etaw daa?” ");
INSERT INTO mta_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Agulé, egsesigbolowoy da sa kesagbì da, guwaen da, “Amuk sumagbì ki, guwaen ta, ‘Si Nemula sa migsugù kenagdi,’ sumulì mikagi Hésus i, guwaen di, ‘Maen di ya atu endà egpigtuuwen yu duu?’ ");
INSERT INTO mta_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dodoo amuk sumagbì ki, guwaen ta, ‘Sa etaw daa,’ buungen sa medoo etaw kita batu anì mematay ki, enù ka netuuwan da si Huwan sa tegesugkow i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Agulé, egsagbì da diyà si Hésus, guwaen da, “Endà netiigan ké duu sa migsugù si Huwan.” ");
INSERT INTO mta_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Agulé guwaen i Hésus diyà kenagda, “Amuk hediya, endà ma tulonen ku duu diyà keniyu sa keduwan sa naken egkegaga.” ");
INSERT INTO mta_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Agulé, egtulon peligad Hésus i diyà sa medoo etaw dahiya, guwaen di, “Duen sa maama mighemula palas diyà sa tanà di. Agulé, igsalig di diyà sa medoo etaw tegeipat enù ka mangay dutu mediyù dò owoy melugay dutu. ");
INSERT INTO mta_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Egoh di neuma sa bulan kepupu, pineangay di sa egsugùsuguen di diyà sa medoo tegeipat anì ibegay da diyà kenagdi sa hagdi baed. Dodoo, sinesuntuk da polo owoy hinemagawan da ma, dodoo endà duen sa igbegay da. ");
INSERT INTO mta_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Agulé, pineangay di dema dutu sa sebaen egsugùsuguen di, dodoo sinesuntuk da ma owoy egpeumàumaan da ma. Hinemagawan da ma, dodoo endà duen sa igbegay da. ");
INSERT INTO mta_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Agulé, pineangay di sa ketelu egsugùsuguen di. Dodoo pinalian da polo owoy sinegodoy da kedu diyà sa hinemulaan. ");
INSERT INTO mta_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Agulé, guwaen sa épê hinemulaan diyà sa pedu di, ‘Enù iya wé kebael ku kéé? Mepion pa kéen amuk peangayen ku dutu sa anak ku eghiduwan ku, enù ka adatan da kéen.’ ");
INSERT INTO mta_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dodoo egoh sa medoo tegeipat mighaa, egseolomoy da, guwaen da, ‘Ini sa etaw kumuwa siini hinemulaan lalawan di diyà sa emà di. Mepion amuk imatayan ta anì nita polo sa hinemulaan di.’ ");
INSERT INTO mta_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Agulé, hinemagawan da kedu diyà sa hinemulaan owoy inimatayan da. “Na, ngadan sa baelan siini épê hinemulaan diyà sa medoo tegeipat? ");
INSERT INTO mta_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iya sa baelan di, angayen di kagda mimatay owoy isalig di polo sa hinemulaan di diyà sa liyu etaw.” Agulé, egoh sa medoo etaw egdineg iya wé, guwaen da, “Ay, mepion hedem amuk endà meketuu di iya wé.” ");
INSERT INTO mta_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Dodoo eg-inengtengen i Hésus kagda owoy guwaen di, “Meketuu doo iya wé enù ka duen sa kagi i Nemula igpesulat, guwaen di, ‘Sa sebaen batu inekedan sa medoo tegebael dalesan pulung batu enù ka guwaen da dò endà duen ulan di, iya polo sa tigtu miulan batu hinemilì ku.’ ");
INSERT INTO mta_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na, amuk mekekinagpà sa etaw diyà siini batu, melepù. Dodoo amuk menabù siini batu diyà sa etaw, melupet.” ");
INSERT INTO mta_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na, sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis, netiigan da kagda sa egkesugat sa peligad di. Huenan di, ungayà da hedem sabaan da Hésus i egoh iya wé agdaw, dodoo egkelimedangan da sa medoo etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Na, edung egoh iya, takaan da egtulik Hésus i sa medoo ulu-ulu owoy sa medoo tegetulù uledin igsugkow i Mosis anì sigkemen da. Duen ma etaw pineangay da diyà si Hésus, sa duma etaw egpeiling sa mepion pedu, dodoo eglagbeten da daa sa kagi di neketipay sa uledin da anì metipu da kagdi ipesigkem da diyà sa gubilenu da. ");
INSERT INTO mta_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Agulé, eg-igsà da diyà si Hésus, guwaen da, “O Mistelu, netiigan ké anan tuu sa eg-ikagiyen ko owoy sa igtulù ko. Endà eghalìhalien ko duu sa igtulù ko sumalà dé sa balangan etaw egdineg, dodoo metudà polo sa ketulù ko sa uyot i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, ini sa igsà ké diyà keniko. Enù di ya, meketipay ki pa sa uledin igsugkow i Mosis amuk megay ki pelesintu diyà si Sisal sa Sulutan ta? Mepion pa ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Dodoo netiigan i Hésus sa pandapat da medaet, huenan di guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pehauwi yu diyà kenak sa kuleta. Ngadan iya wé etaw di owoy sa igsulat di?” Egsagbì da, guwaen da, “Iya si Sisal sa Sulutan ta.” ");
INSERT INTO mta_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Guwaen i Hésus, “Na, amuk hediya, begayi yu diyà si Sulutan Sisal sa hagdi egpegeniyen, owoy begayi yu ma diyà si Nemula sa hagdi egpegeniyen.” ");
INSERT INTO mta_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Apiya di pa eglagbeten da sa kagi di nekeamu, endà doo duen dinineg da kagi kenà di mesalà. Egkegaip da polo danà sa sagbì di, owoy endà dé eg-ikagi da. ");
INSERT INTO mta_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Agulé, duen ma etaw Sadusiyu mig-angay da diyà si Hésus. Kagda sa etaw Hudiyu egtulù endà umenaw di gaa sa etaw nematay. ");
INSERT INTO mta_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Eg-igsà da, guwaen da, “O Mistelu, duen sa igsulat i Mosis diyà kenita denu sa egbaelan ta amuk nematay sa maama épê sawa dodoo endà duen anak da. Iya sa baelan di, ipesawa diyà sa hadi di sa balu anì dumuen anak da lagà sa anak sa maama nematay. ");
INSERT INTO mta_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, duen pitu maama telehadi. Agulé migsawa sa kakay da, dodoo endà duen anak di egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hê, inited sa tigtu hadi di sa ibò di, dodoo nematay ma. ");
INSERT INTO mta_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hediya ma sa nebaelan sa ketelu di taman sa kepitu, enù ka nesetugdugtugdug sa pitu telehadi egsawa siedò bayi, dodoo nelengon da nematay endà duen anak. ");
INSERT INTO mta_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Agulé hudihudi nematay ma sa bayi. ");
INSERT INTO mta_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, tulon ko kenami, amuk meuma sa keenaw sa nematay, ngadan tayu di etaw diyà sa pitu telehadi mesawa sa bayi enù ka anan da migsawa kenagdi egoh anay?” ");
INSERT INTO mta_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Agulé egsagbì Hésus i kenagda, guwaen di, “Egsesawaay pelà sa medoo etaw diyà tanà, ");
INSERT INTO mta_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","dodoo amuk dutu dé langit dò endà dé sesawaay sa medoo etaw metiengaw diyà sa kehaa i Nemula amuk enawen di kagda. ");
INSERT INTO mta_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Endà dé mematay da enù ka lagà da sa egsugùsuguen i Nemula diyà langit. Kagda sa anak i Nemula enù ka enawen di kagda. ");
INSERT INTO mta_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na, netiigan ké tuu sa keenaw sa medoo nematay danà sa igsulat i Mosis denu sa egoh sa kayu eglegleg egoh i Nemula mig-ikagi diyà kenagdi, guwaen di, ‘Aken sa Nemula egpigtuuwen da i Ablaham si Isak owoy si Hakob.’ Na, egoh i Nemula mig-ikagi iya wé, nelugay da dé nematay da Ablaham i si Isak owoy si Hakob. ");
INSERT INTO mta_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Apiya di pa nematay da dé diyà tanà, nehagtay da doo diyà sa kehaa i Nemula. Amuk nehagtay da doo diyà sa kehaa i Nemula, umenaw da mendaa.” ");
INSERT INTO mta_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Agulé, egsagbì sa duma tegetulù uledin, guwaen da, “O Mistelu, mepion sa kesagbì ko.” ");
INSERT INTO mta_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Agulé, endà dé eg-uman da eg-igsà enù ka egkelenawan da metepelan. ");
INSERT INTO mta_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Agulé, eg-ikagi Hésus i diyà kenagda, guwaen di, “Maen di ya iya sa kagi sa medoo etaw denu si Kelistu sa Tigtu Datù eg-angat-angatan sa medoo Hudiyu, guwaen da kagdi gaa sa tugod i Dabid? ");
INSERT INTO mta_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na, tuu iya wé inikagi da, dodoo guwaen i Dabid si Kelistu sa Datù di egoh di migsulat ini i diyà sa sebaen libelu ta, Isalem, guwaen di, ‘Ini sa kagi i Datù Nemula diyà sa Datù ku, guwaen di, Penuu ka dahini denu kuwanan ku ");
INSERT INTO mta_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","taman atuwan ku sa medoo kuntelà ko owoy ipeutuh ku keniko.’ ");
INSERT INTO mta_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na, amuk iya sa kagi i Dabid egoh anay denu si Kelistu, guwaen di ‘Datù ku,’ endà mebaluy di amuk tugod i Dabid daa Kelistu i, dodoo Datù di ma polo.” ");
INSERT INTO mta_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Agulé, egoh sa medoo etaw egdinegdineg, mig-ikagi Hésus i diyà sa medoo salu di, guwaen di, ");
INSERT INTO mta_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Hahaa yu sa medoo tegetulù uledin igsugkow i Mosis anì endà umiling yu kenagda. Igluhub da sa metaes kawal da metolol, owoy egkeiyap da amuk egsaluan etaw kagda diyà sa padian. Amuk mangay da diyà simbaan, ungayà da menuu da diyà sa bangkù ginelal. Amuk mangay da diyà pista, ungayà da kagda sa muna pekaenen. ");
INSERT INTO mta_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Egtepelen da ma sa medoo dalesan sa bayi balu danà sa medoo pandapat da, dodoo eglidungen da sa medaet egbaelan da. Amuk hauwen da etaw, melugay da ubòubò egsimbà. Huenan di, uman pa dakel sa kepigtamay i Nemula mekeuma diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na, egoh i Hésus pelawà diyà sa Dalesan i Nemula, miglengag owoy hinaa di sa medoo kawasà etaw egdalemen da diyà sa atung taguan pilak sa ibegay da diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Agulé hinaa di ma sa bayi balu pubeli egdalemen di dahiya sa duwa tukééy kuleta di. ");
INSERT INTO mta_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Eglowon polo sa igbegay siini balu pubeli diyà sa igbegay sa langun etaw kawasà. ");
INSERT INTO mta_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iya maen di ya enù ka endà egkelikutan da egbegay enù ka medoo sa pantiyali da. Dodoo siini bayi balu, inimet di sa langun kehagtayan di egbegay apiya pubeli etaw.” ");
INSERT INTO mta_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Agulé, egseolomoy sa duma salu i Hésus sa hinaa da diyà sa Dalesan i Nemula, enù ka metolol sa medoo dakel batu di owoy duen medoo tamuk milagà igbegay etaw igsanggat diyà sa kelatkat di. Dodoo guwaen i Hésus, ");
INSERT INTO mta_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Na, siini medoo eghauwen yu ini egoh di, meuma pa sa agdaw di mekedan langun. Megubal sa kelatkat di anan batu sinelogsudlogsud anì pa sebaen sa mesamà.” ");
INSERT INTO mta_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Agulé, inigsaan da Hésus i, guwaen da, “O Mistelu, nengan di ya tumebow iya wé tinulon ko? Ngadan sa tandà di amuk buyu dé meuma iya wé?” ");
INSERT INTO mta_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Agulé guwaen i Hésus, “Tulik yu anì endà meakalan yu, enù ka dumuen sa medoo etaw tegeakal tumebow peiling kenak guwaen da kagda gaa si Kelistu. Iya ma sa guwaen da, neuma dé sa agdaw i Nemula sumambì siini tanà. Dodoo yoko eg-unut duu kagda. ");
INSERT INTO mta_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Amuk dinegen yu sa medoo etaw egsegilaway ataw ka sa medoo etaw egkuntelà diyà sa gubilenu, yoko egkelimedangan na enù ka muna pelawà mukit siini medoo medaet diyà tanà. Dodoo beken pelà iya sa tandà di meuma sa sabuhanan agdaw.” ");
INSERT INTO mta_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Guwaen di ma, “Mesegila sa medoo etaw, enù ka sa medoo etaw diyà sebaen tanà, mangay da gumila diyà sa sebaen ma tanà, owoy sa medoo etaw sa sebaen datù, mangay da ma gumila diyà sa sebaen ma datù. ");
INSERT INTO mta_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dumuen ma dakel linug owoy mekeseluh diyà sa uwang tanà sa dakel bitil owoy dakel linadu. Dumuen ma medoo dakel egkelimedangan etaw owoy medoo dakel panduan mehaa etaw diyà langit. ");
INSERT INTO mta_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Dodoo egoh di endà pa meuma iya wé, sigkemen sa medoo etaw kiyu owoy pelihayen da kiyu. Agaken da kiyu diyà sa simbaan Hudiyu kenà da tumipu keniyu anì mebilanggu yu. Uwiten da ma kiyu diyà sa medoo sulutan owoy sa medoo datù ma danà sa kepigtuu yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dodoo iya ma sa agdaw yu tumulon diyà kenagda sa Mepion Tegudon denu kenak. ");
INSERT INTO mta_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Peeles yu diyà sa pedu yu ini i kagi ku, yoko pelawà egpenemdem duu sa kesagbì yu kenagda taman endà tumebow yu dutu, ");
INSERT INTO mta_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","enù ka iya pelawà ibegay ku diyà keniyu sa kagi yu owoy sa penemdem yu milantek anì endà duen kuntelà yu meketaban sa eg-ikagiyen yu. ");
INSERT INTO mta_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Apiya sa emà yu owoy sa inay yu owoy sa medoo hadi yu owoy kakay yu owoy sa medoo duma telahadi yu owoy sa medoo loyuk yu, iya doo sa tumipu keniyu owoy duen ma duma yu ipeimatay da. ");
INSERT INTO mta_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Melepuhan langun etaw kiyu danà sa kepigtuu yu kenak. ");
INSERT INTO mta_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Dodoo danà yu metigkel sa langun kelikutan yu, mesakem yu doo sa lalù endà meelut di. Apiya sebaen balut ulu yu, melalù doo taman melugay.” ");
INSERT INTO mta_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Agulé guwaen i Hésus, “Amuk hauwen yu sa menuwa Hélusalém neseulingutan sa medoo sundalu, metiigan yu dé buyu dé medaetan iya wé menuwa. ");
INSERT INTO mta_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Amuk meuma iya wé, pelaguy yu angay diyà sa medoo getan, kiyu i eg-ugpà diyà tanà Hudiya. Mekepelaguy ma mangay dutu sa medoo etaw eg-ugpà diyà Hélusalém, owoy endà ma mekepelikù da dalem sa menuwa sa medoo etaw eggalebek diyà sa hinemulaan da. ");
INSERT INTO mta_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iya maen di ya enù ka neuma sa pasad i Nemula migtamay sa menuwa Hélusalém anì meketuu sa langun tapay igpesulat di. ");
INSERT INTO mta_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Amuk meuma iya wé, mepasangan temù sa medoo bayi obol owoy sa medoo egpesusu tukééy anak da, enù ka pigtamayan i Nemula sa medoo etaw Hudiyu owoy mepasangan da temù taman sa uwang tanà da. ");
INSERT INTO mta_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Duen etaw mematay danà da tinigbas, owoy duen ma etaw mesigkem agaken da mangay diyà sa medoo balangan tanà. Agawen sa medoo etaw beken Hudiyu sa menuwa Hélusalém owoy kagda daa sa umipat taman endà meelut sa lugay da eg-atu diyà sa medoo Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Guwaen i Hésus, “Amuk buyu tumebow sa Kakay Langun, duen medoo panduan diyà agdaw owoy bulan owoy sa medoo bituen. Mepasangan sa penemdem sa medoo balangan etaw diyà tanà enù ka dakel temù sa labal dagat owoy sumenok ma takà. ");
INSERT INTO mta_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mekenah sa medoo maama danà da melimedangan sa medaet dumagpak diyà sa langun tanà, enù ka humalìhalì sa langun eghauwen ta diyà langit. ");
INSERT INTO mta_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iya pelawà hauwen etaw aken i Kakay Langun tumebow peunutan gaeb. Dakel sa egkegaga ku kumedatù owoy tigtu dakel ma sa senang ku. ");
INSERT INTO mta_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Na, amuk hauwen yu siini medoo tinulon ku umedung umukit diyà tanà, keanggani yu dé owoy lengag yu langit dò enù ka buyu yu dé mealukan.” ");
INSERT INTO mta_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Agulé, egtulon dema balatan Hésus i, guwaen di, “Haa yu sa kayu pigus owoy sa medoo duma kayu. ");
INSERT INTO mta_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Amuk eghauwen yu sa egoh da egtugbung, metiigan yu doo medapag dé sa meedup agdaw. ");
INSERT INTO mta_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Diya ma, amuk hauwen yu siedò medoo tinulon ku umukit, metiigan yu doo buyu dé meuma sa kedatù i Nemula diyà etaw. ");
INSERT INTO mta_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tuu ini i eg-ikagiyen ku diyà keniyu. Sa medoo duma ta eg-ugpà diyà tanà ini egoh di, amuk endà pa mematay da langun, hauwen da doo iya wé tinulon ku umukit. ");
INSERT INTO mta_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mekedan pa siini langit owoy siini tanà, dodoo endà mekedan sa kagi ku taman melugay.” ");
INSERT INTO mta_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Guwaen i Hésus, “Tulik yu anì endà mepetow yu amuk tumebow siedò agdaw sa Kakay Langun. Haa yu anì endà melipeng sa pedu yu danà yu hiluwen ataw ka danà sa medaet nanam lawa yu. Haa yu ma anì endà melakà sa pedu yu danà yu egpenemdem sa hagtay yu. Umamu yu amuk iya, ");
INSERT INTO mta_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","enù ka sa ketebow di lagà nepekasan keteb diyà sa langun etaw diyà siini sinukub langit. ");
INSERT INTO mta_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Huenan di, tulik yu owoy simbà yu takà anì mekegaga yu tumigkel sa medoo kelikutan tumebow diyà tanà anì endà ma memalaan yu tumigdeg diyà sa taengan sa Kakay Langun.” ");
INSERT INTO mta_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na, amuk agdaw, egtulù Hésus i diyà sa Dalesan i Nemula diyà Hélusalém, dodoo amuk sigep eg-angay eg-ugpà diyà sa Getan Olibu. ");
INSERT INTO mta_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Uman magtu kesimag eg-angay sa langun etaw diyà sa Dalesan i Nemula anì dinegen da sa ketulù di. ");
INSERT INTO mta_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, medapag dé meuma sa pista egoh da egkaen sa epan endà duen igpelenuk di, sa kepengadan da Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eglagbeten sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis sa ukit keimatay da si Hésus, dodoo nelenawan da diyà sa medoo etaw enù ka medoo da egpigtuu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na, si Hudas Iskaliyot sa sebaen maama diyà sa sepulù owoy duwa salu i Hésus. Linuhub i Satanas ");
INSERT INTO mta_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","anì tumampil diyà sa kuntelà i Hésus. Huenan di, mig-angay eg-olom diyà sa medoo ulu-ulu tegesimbà owoy diyà sa medoo kapitan tegebantay sa Dalesan i Nemula. Egseolomen da sa baelan di anì mekuwa da Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Agulé, neanggan da owoy migpasad da egbegay pilak diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Hê, eg-unutan i Hudas dé sa penemdem da. Agulé eglagbeten di sa mepion gai di megay si Hésus diyà kenagda amuk endà duen medoo etaw egkesetipon diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, neuma dé sa agdaw da egkaen sa epan endà duen ipelenuk di. Iya ma sa agdaw da eg-imatay sa anak kebilibili kaenen da amuk egpista da sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Agulé, sinugù i Hésus Pidelu i owoy si Huwan, guwaen di, “Angay yu baeli sa kaenen ta egpista anì pistawan ta sa Agdaw Kinetalà Sa Kepigtamay i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Guwaen da diyà kenagdi, “Ngadan kenà ké mael?” ");
INSERT INTO mta_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Guwaen di, “Taa yu. Amuk tumebow yu dutu siedò menuwa, hauwen yu sa maama egtiang buyung nepenù wayeg. Unut yu kenagdi mangay diyà sa dalesan gemowon di. ");
INSERT INTO mta_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tulon yu diyà sa épê dalesan, guwaen yu, ‘Iya sa kagi i Mistelu, kenà sa sibay ko gaa kenà di egkaen siini pista ta lapeg sa medoo pasek di?’ ");
INSERT INTO mta_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Agulé, ipehaa di diyà keniyu sa dakel sibay lekeatas duen lamisan owoy langun taman eg-ipaten diyà pista. Dahiya sa kenà yu egtapay sa pista ta.” ");
INSERT INTO mta_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Agulé, eg-ipanaw da dé owoy hinaa da sa langun tinulon i Hésus. Agulé, egtapayen da sa kaenen da egpista. ");
INSERT INTO mta_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Agulé, egoh di neuma sa ulas da kumaen, egpenuu Hésus i owoy sa sepulù owoy duwa salu di. ");
INSERT INTO mta_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Guwaen di diyà kenagda, “Meiyap a temù egkaen diyà keniyu siini Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, enù ka buyu a dé meimatayan. ");
INSERT INTO mta_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Taa yu, hih. Endà pa kumaen a uman siini pista taman endà meketuu sa selepangan di diyà sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Agulé, sinabaan di sa tabù duen wain owoy migsimbà ma egpesalamat diyà si Nemula. Guwaen di diyà sa medoo salu di, “Kuwa yu dé. Inem yu dé langun tigtukééykééyéy. ");
INSERT INTO mta_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Taa yu, hih. Endà pa uminem a uman siini wain eg-inemen ta taman endà meuma sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Agulé, sinabaan di ma sa sebaen epan, owoy migsimbà egpesalamat diyà si Nemula. Tinepitepi di owoy igtukid di diyà kenagda. Guwaen di, “Ini sa lawa ku ibegay ku sa itigtu ku keniyu. Kaen yu dé. Ilingi yu takà siini egbaelan ta anì metulengan yu aken.” ");
INSERT INTO mta_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Diya ma sa egbaelan di diyà sa wain egoh da neubus egkaen. Igtukid di diyà kenagda, owoy guwaen di, “Ini sa depanug ku lumesut amuk meimatayan a anì metigtuwan sa salà yu. Siini depanug ku, iya sa tandà di meketuu sa magtu ukit igpasad i Nemula umaluk etaw.” ");
INSERT INTO mta_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Agulé guwaen i Hésus, “Dodoo, haa yu. Duen sa sebaen duma ta egkaen diyà siini lamisan ta ini egoh, sa maama megay kenak diyà sa kuntelà ku. ");
INSERT INTO mta_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mematay doo sa Kakay Langun danà di meketuu sa penemdem i Nemula. Dodoo tigtu mepigtamayan sa maama megay kenak diyà sa medoo kuntelà ku.” ");
INSERT INTO mta_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Agulé, eg-edung sa medoo salu di egseigsaay sa tayu di megay kenagdi diyà sa kuntelà di. ");
INSERT INTO mta_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, egsesigbolowoy ma sa medoo salu i Hésus denu sa tayu dakel etaw diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Dodoo guwaen i Hésus diyà kenagda, “Sa medoo datù etaw beken Hudiyu, takaan da egpeges sa medoo etaw da danà sa gelal da, owoy sa ungayà da meolò da etaw danà sa egbaelan da. ");
INSERT INTO mta_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Dodoo endà mebaluy di ilingan yu iya wé. Mepion amuk lagà sa hadi yu polo sa tayu dakel etaw diyà keniyu. Owoy mepion amuk lagà sa egsugùsuguen yu polo sa kaunutan yu. ");
INSERT INTO mta_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Enù di ya, ngadan sa tayu dakel etaw, sa etaw egpenuu egkaen ataw ka sa etaw tegehated kaenen? Iya sa dakel etaw sa egpenuu egkaen. Dodoo taa yu, apiya aken sa Datù yu, lagà aken polo sa tegehated kaenen. ");
INSERT INTO mta_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Apiya di pa medoo sa kelikutan ku, takà yu doo eg-unut-unut diyà kenak. ");
INSERT INTO mta_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huenan di, begayan ku kiyu sa kedatù yu lagà sa kinebegay i Emà sa kedatù ku. ");
INSERT INTO mta_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Huenan di, amuk kumedatù a, mekekaen yu ma diyà sa lamisan ku owoy mekeipat yu sa sepulù owoy duwa geumpung tugod i Islaél.” ");
INSERT INTO mta_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Agulé, guwaen i Hésus, “O Simon, taa ko. Pinandayà i Nemula dé Satanas i anì tepengan di kuna anì mekedan sa kepigtuu ko, lagà sa etaw eg-etap. ");
INSERT INTO mta_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Dodoo igsimbà ku kuna anì endà mekedan sa kepigtuu ko. Apiya di pa mesalà ka diyà kenak, tuingen ko pa sa pedu ko. Hê amuk iya, tabangi ko dé sa kepigtuu sa medoo duma ko.” ");
INSERT INTO mta_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Agulé egsigbolow Simon Pidelu i, guwaen di, “O Datù, mekeunut a doo keniko, apiya mebilanggu ki ataw ka mematay ki.” ");
INSERT INTO mta_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Guwaen i Hésus, “O Pidelu, taa ko, hih. Egoh sa ebos endà pa umukolò amuk buyu sumimag, palawen ko polo aken beken duma ko taman telu gulê.” ");
INSERT INTO mta_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Agulé, guwaen i Hésus diyà sa medoo salu di, “Egoh ku migpetegudon keniyu, hinawidan ku kiyu eg-uwit sa langun taman yu, iling ka taguan pilak ataw ka puyut ataw ka duma talumpà yu. Enù di ya sa hagtay yu egoh iya, nelikutan yu pa?” Egsagbì da, guwaen da, “Enget doo sa hagtay ké.” ");
INSERT INTO mta_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Agulé guwaen di, “Dodoo edung ini egoh di amuk duen taguan pilak ataw ka puyut yu, uwit yu dé. Amuk endà duen sundang yu, mepion amuk dagangen yu sa kawal yu anì mekebeli yu sundang. ");
INSERT INTO mta_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iya maen di ya enù ka meketuu pelawà ini i kagi i Nemula igpesulat denu kenak, guwaen di, ‘Diyà sa kehaa sa medoo etaw, kagdi sa duma sa medoo etaw tegebael medaet.’ Na, ini egoh di ekedan da aken enù ka meketuu sa langun meukitan ku igpesulat di egoh anay.” ");
INSERT INTO mta_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Agulé, guwaen sa medoo salu di, “O Datù, haa ko. Kaini dé sa duwa sundang.” Dodoo danà da endà egpeketiig, eg-ikagi Hésus i, guwaen di, “Naal dé.” ");
INSERT INTO mta_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Agulé, miglegkang Hésus i owoy mig-angay dema diyà sa Getan Olibu, enù ka iya sa eg-angayan di takà. Mig-unut ma sa medoo salu di. ");
INSERT INTO mta_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Egoh da migtebow, guwaen i Hésus diyà kenagda, “Simbà yu dé anì endà mekeukit yu diyà sa kenà sa pedu yu tepengan anì endà ma mekebael yu salà.” ");
INSERT INTO mta_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Agulé, migtangkà Hésus i diyà kenagda, sa kediyù di meuma muung. Egligkued egsimbà, ");
INSERT INTO mta_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","guwaen di, “O Emà, amuk mepion diyà keniko, kedani ko diyà kenak siini kelikutan ku lagà wain mepait buyu egkeinem ku. Dodoo, peukit ko diyà kenak sa niko uyot, beken sa naken.” ");
INSERT INTO mta_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Agulé, duen sa egsugùsuguen i Nemula kedu langit dò migpehaa diyà kenagdi anì pebagelen di. ");
INSERT INTO mta_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Egkebukul temù sa pedu di, huenan di eg-umanan di sa kesimbà di, owoy eglimusengen temù lagà depanug egketaktak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Agulé, egoh di neubus egsimbà, migpelikù diyà sa kenà sa medoo salu di, owoy hinaa di kagda egtudug danà da netamay nebukul. ");
INSERT INTO mta_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Guwaen di, “Ay, maen di ya egtudug yu? Enaw yu dé, owoy simbà yu polo anì endà mekeukit yu diyà sa kenà sa pedu yu tepengan.” ");
INSERT INTO mta_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Agulé, egoh di pelawà eg-ikagi, migtebow sa medoo etaw inuwit i Hudas, sa sebaen maama diyà sa sepulù owoy duwa salu i Hésus. Migdapag diyà si Hésus enù ka pengadekan di. ");
INSERT INTO mta_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Dodoo guwaen i Hésus, “O Hudas, maen di ya hinemilì ko sa kepengadek ko kenak amuk egtandaan ko sa kebegay ko sa Kakay Langun diyà sa medoo kuntelà di?” ");
INSERT INTO mta_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Agulé, egoh sa medoo duma i Hésus neketiig sa egkebaelan di, guwaen da, “O Datù, tumigbas ké dé?” ");
INSERT INTO mta_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hê, tinigbas sa sebaen duma da sa egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà. Nesapsap sa telinga di denu kuwanan. ");
INSERT INTO mta_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Dodoo guwaen i Hésus, “Naal dé.” Agulé sinabaan di sa telinga sa maama. Hê nelikuan dema. ");
INSERT INTO mta_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Agulé, mig-ikagi Hésus i diyà sa medoo etaw migtebow, sa medoo ulu-ulu tegesimbà owoy sa medoo kapitan tegetulik sa Dalesan i Nemula owoy sa medoo kaunutan Hudiyu. Guwaen di, “Maen di ya eg-uwit yu sundang owoy lubog egoh yu eg-angay egsigkem kenak? Beken a sa etaw tegelampas. ");
INSERT INTO mta_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Egoh ku eg-amut diyà keniyu uman agdaw diyà sa Dalesan i Nemula, endà egsabaan yu duu aken. Dodoo mesigkem yu aken siini sigep danà sa egkegaga i Satanas sa kaunutan sa medoo etaw eg-ugpà diyà deleman.” ");
INSERT INTO mta_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Agulé, sinigkem da Hésus i owoy inagak da eg-angay diyà sa dalesan sa Tigtu Ulu-ulu Tegesimbà. Migpetangkà daa Pidelu i eg-unut diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Egoh da migtebow, duen ma apuy tinemeg sa medoo tegebantay diyà teliwadà sa duwangen owoy egpenuu da eg-ingadang dahiya. Hê, egpenuu ma dahiya Pidelu i diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na, duen ma sa bayi egsugùsuguen da. Hinaa di Pidelu i egpenuu nelegdawan apuy owoy egpeelesen di eghahaa. Guwaen di, “Siini maama sa duma i Hésus giina.” ");
INSERT INTO mta_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Dodoo egpalaw Pidelu i, guwaen di, “O Okon, endà netiigan ku duu iya wé maama.” ");
INSERT INTO mta_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Agulé nelugaylugay, duen dema sa sebaen maama eghaa si Pidelu. Guwaen di, “Kuna ma sa duma pasek di.” Dodoo guwaen i Pidelu, “Endà, Akay. Beken aken sa duma di.” ");
INSERT INTO mta_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Agulé, sakaulas pa kedu iya, duen sebaen ma maama mebagel sa kagi di, guwaen di, “Tigtu tuu, duma i Hésus ini i maama, enù ka kagdi ma sa tegeGaliliya.” ");
INSERT INTO mta_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Dodoo guwaen i Pidelu, “O Akay, tigtu endà netiigan ku duu sa eg-ikagiyen ko.” Hê, egoh i Pidelu eg-ikagi pelawà, umukolò dé sa ebos. ");
INSERT INTO mta_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Agulé, tinengang i Hésus Pidelu i. Hê, netulengan di sa kagi i Datù diyà kenagdi egoh di mig-ikagi, guwaen di, “Egoh sa ebos endà pa umukolò amuk buyu sumimag, palawen ko polo aken beken duma ko taman telu gulê.” ");
INSERT INTO mta_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Agulé, mig-ipanaw Pidelu i, owoy egsinegaw temù danà sa pedu di nebukul. ");
INSERT INTO mta_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Agulé, sa medoo maama egbantay si Hésus, egsegemenan da owoy sinesuntuk da. ");
INSERT INTO mta_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Eglimunan da ginis sa mata di, owoy egpeumàumaan da, guwaen da, “O Tegesugkow i Nemula, ingadani ko atu sa etaw egtagpì keniko.” ");
INSERT INTO mta_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na, medoo ma sa medaet kagi da takà egpeumàumà si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na, egoh di sumimag, nesetipon sa medoo kaunutan Hudiyu owoy sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Inagak da Hésus i diyà sa kenà da nesetipon. ");
INSERT INTO mta_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Agulé guwaen da diyà kenagdi, “Tuloni ko kami amuk kuna si Kelistu sa Tigtu Datù eg-angat-angatan ké.” Dodoo guwaen i Hésus, “Apiya di pa tulonon ku kiyu, endà ma migtuu yu, ");
INSERT INTO mta_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","owoy endà ma sumagbì yu amuk duen igsà ku diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Dodoo endà melugay di menuu sa Kakay Langun denu kuwanan i Nemula épê dakel egkegaga.” ");
INSERT INTO mta_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Agulé guwaen da langun, “Amuk hediya, Anak i Nemula ka, hih?” Migsagbì, guwaen di, “Tuu sa gelal ibegay yu kenak.” ");
INSERT INTO mta_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Agulé guwaen da, “Endà dé lumagbet ki uman sa ketulon etaw denu sa salà di, enù ka dinineg ta langun sa inikagi di medaet kedu diyà sa ebà di, guwaen di kagdi gaa sa Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Agulé, migtigdeg sa langun etaw nesetipon dahiya owoy inagak da Hésus i diyà si Pilatu sa Gubilenu da. ");
INSERT INTO mta_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Agulé, mig-edung da egtipu si Hésus diyà sa Gubilenu, guwaen da, “Hinaa ké siini maama egpekuntelaen di sa medoo duma ké Hudiyu diyà sa sulutan ta. Hinawidan di kami egbegay pelesintu diyà si Sulutan Sisal. Kagdi gaa si Kelistu, sa sebaen ma sulutan.” ");
INSERT INTO mta_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Agulé, inigsaan i Pilatu Hésus i, guwaen di, “Enù di ya, kuna sa sulutan diyà sa medoo Hudiyu?” Migsagbì, guwaen di, “Tuu iya wé gelal igbegay ko kenak.” ");
INSERT INTO mta_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Agulé, guwaen i Pilatu diyà sa medoo ulu-ulu tegesimbà owoy sa medoo etaw ma, “Endà duen egketiigan ku salà ini i maama.” ");
INSERT INTO mta_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Dodoo egpeges da egtipu, guwaen da, “Takà egtulù eg-edung Galiliya dò taman dahini anì egpekuntelaen di sa medoo etaw diyà si Sulutan.” ");
INSERT INTO mta_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Agulé, egoh i Pilatu migdineg iya wé, eg-igsaan di kagda amuk si Hésus sa tegeGaliliya. ");
INSERT INTO mta_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na, egoh di neketiig si Hésus sa etaw kedu Galiliya sa tanà eg-ipaten i Hélod, igpeuwit di Hésus i diyà si Datù Hélod enù ka diyà Hélusalém ma egoh iya. ");
INSERT INTO mta_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Agulé, neanggan temù Hélod i egoh di mighaa si Hésus enù ka medoo sa dinineg di denu kenagdi. Tapay dé egkeiyapan di humaa Hésus i owoy sa panduan egbaelan di. ");
INSERT INTO mta_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Huenan di, medoo sa eg-igsaen di diyà si Hésus, dodoo endà egsagbì di. ");
INSERT INTO mta_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hê, egtigdeg ma dahiya sa medoo ulu-ulu tegesimbà owoy sa medoo tegetulù uledin igsugkow i Mosis. Pineges da egtipu Hésus i diyà si Datù Hélod. ");
INSERT INTO mta_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Agulé, pineumàumaan i Hélod lapeg sa medoo sundalu di Hésus i. Igpekawal da sa metolol ginis éhê ginis sulutan owoy eggemenan da. Agulé, pinelikù di diyà si Pilatu. ");
INSERT INTO mta_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, danà iya wé, baluy da dé neseloyuk si Hélod owoy si Pilatu, enù ka tapay da nesekuntelà egoh anay. ");
INSERT INTO mta_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Agulé, sinetipon i Pilatu sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan Hudiyu owoy sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Guwaen di, “Egoh yu mig-uwit siini maama diyà kenak, tinulon yu sa salà di, guwaen yu, ‘Egpekuntelaen di sa medoo etaw.’ Na, dinineg yu dé sa egoh ku mig-igsà kenagdi denu sa binaelan di, dodoo endà duen salà di netiigan ku. Endà tuu sa tinulon yu salà di. ");
INSERT INTO mta_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Diya ma sa penemdem i Datù Hélod, huenan di pinelikù di diyà kenita. Endà duen salà di sa pesuwan ku peimatay kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Huenan di, isugù ku daa ipetapes owoy lengaan ku.” ");
INSERT INTO mta_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na, iya sa inikagi di enù ka uman meuma siedò pista da, iya sa adat di lengaan di diyà kenagda sa sebaen duma da nebilanggu. ");
INSERT INTO mta_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Dodoo migpetaled da polo eg-ikagi, guwaen da, “Ulan iya wé maama. Si Balabas polo sa lengai ko diyà kenami.” ");
INSERT INTO mta_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na, nebilanggu Balabas i danà di migpekuntelà sa medoo etaw tegeHélusalém diyà sa gubilenu owoy danà di ma mig-imatay etaw. ");
INSERT INTO mta_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Agulé, inikagiyan i Pilatu dema kagda enù ka ungayà di hedem lengaan di Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Dodoo migpetaled da polo eg-ikagi, guwaen da, “Peimatayi ko! Petutuki ko diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Guwaen i Pilatu dema, “Maen di ya? Ngadan sa salà binaelan di? Endà duen salà di netiigan ku sa pesuwan ku peimatay kenagdi. Huenan di, isugù ku daa ipetapes owoy lengaan ku.” ");
INSERT INTO mta_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Dodoo pineges da temù Pilatu i. Migpetaled da eg-ikagi anì ipeimatay di Hésus i diyà sa kayu igbugsud. Hê, tinabanan da Pilatu i danà sa kagi da metaled. ");
INSERT INTO mta_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Agulé inunutan di sa pinegeni da anì metuu sa ungayà da. ");
INSERT INTO mta_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Huenan di, linengaan di sa maama nebilanggu hinemilì da, siedò maama migkuntelà diyà sa gubilenu owoy mig-imatay. Dodoo igsugù di sa kepatay i Hésus enù ka iya sa ungayà da. ");
INSERT INTO mta_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na, egoh sa sundalu eg-uwit si Hésus dutu siedò kenà da mimatay, nesiegungan da Simon i tegeSilini magtu migtebow kedu getan. Mangay Hélusalém dò hedem, dodoo tinegel da polo egpetiang sa kayu kenà i Hésus meketutuk owoy pinesetugdug da diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na, egoh i Hésus eg-ipanaw, mig-unut ma sa medoo etaw. Duen ma sa medoo bayi takà egpetaled egsinegaw danà sa kekebukul da kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Dodoo eglalingayen i Hésus kagda, owoy guwaen di, “O medoo bayi tegeHélusalém, yoko egsinegaw kenak, dodoo sinegawi yu polo kiyu owoy sa medoo anak yu. ");
INSERT INTO mta_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Taa yu, hih. Amuk meuma kani sa pasad di melikutan yu temù, iya sa ikagiyen sa medoo etaw, guwaen da, ‘Nebagian polo siedò bayi tapay endà eg-anak, sa bayi endà duen anak di egpesusuwen di.’ ");
INSERT INTO mta_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Amuk meuma iya wé, umumow sa medoo etaw diyà sa medoo getan, guwaen da, ‘Kebugal yu dé anì metambakan ké. Imatayi yu dé kami.’ ");
INSERT INTO mta_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Amuk ini sa kebael da kenak apiya di pa endà duen salà ku, uman-uman pa kebael da keniyu ya épê salà.” ");
INSERT INTO mta_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na, duen ma duwa maama tegebael medaet inuwit sundalu enù ka seselenganen da kagda mimatay si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Agulé, egoh da migtebow diyà sa getan kepengadan da Kulobong Ulu, igtutuk da Hésus i diyà sa kayu owoy igbugsud da. Diya ma sa kebael da sa duwa maama tegebael medaet, sebaen denu kuwanan i Hésus, sebaen denu bibang di. ");
INSERT INTO mta_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Agulé guwaen i Hésus, “O Emà, peuloyi ko sa salà siini medoo etaw, enù ka endà netiigan da duu sa egbaelan da.” Agulé, egkusing sa medoo sundalu egseatuwen da sa ginis i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na, eghahaa sa medoo etaw egtigdeg dahiya, dodoo sa medoo kaunutan da, egpeumàumaan da Hésus i, guwaen da, “Inalukan di gaa sa medoo etaw. Amuk tuu kagdi si Kelistu sa Tigtu Datù pineangay i Nemula, mepion amuk alukan di ma kagdi i.” ");
INSERT INTO mta_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Egpeumàumaan ma sa medoo sundalu kagdi i. Ig-angay da igpeima-ima igtayal diyà kenagdi sa wain eg-inemen da, ");
INSERT INTO mta_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","owoy guwaen da, “Amuk kuna sa Sulutan diyà sa medoo Hudiyu, aluki ko atu kuna.” ");
INSERT INTO mta_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Duen ma igsulat igtagù da diyà sa lekeatas ulu di. Iya sa kagi di, “Ini sa Sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Agulé, sa sebaen maama tegebael medaet igtutuk diyà sa kayu igbugsud, pinedaet di ma Hésus i eg-ikagi, guwaen di, “Iyoh! Amuk tuu kuna si Kelistu, maen di ya endà megaga ko duu umaluk kuna owoy kami ma?” ");
INSERT INTO mta_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Dodoo, egsigbolowen sa duma di igtutuk diyà sa kayu igbugsud, guwaen di, “Maen di ya endà egkelimedangan ka si Nemula? Haa ko. Sebaen daa sa kepigtamay da kenita si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tuu sa kepigtamay da kenita danà sa binaelan ta medaet, dodoo siini duma ta endà duen sa hagdi medaet binaelan.” ");
INSERT INTO mta_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Guwaen di ma, “O Hésus, ketulengi ko aken amuk kumedatù ka.” ");
INSERT INTO mta_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Agulé, guwaen i Hésus diyà kenagdi, “Tuu ini i eg-ikagiyen ku diyà keniko. Mekeunut ka kenak igkani dutu bayà dò diyà sa mepion ugpaan sa metiengaw etaw nematay.” ");
INSERT INTO mta_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Na, egoh di buyu alas sepulù owoy duwa, tinenaan deleman sa uwang tanà taman alas telu mahapun, ");
INSERT INTO mta_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","enù ka nedilungan sa agdaw. Minelisì ma teliwadà sa dakel ginis ighabeng dalem sa teliwadà luwang Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Agulé, pinetaled i Hésus sa kagi di, guwaen di, “O Emà, isalig ku diyà keniko sa suguy ku.” Hê, egoh di mig-ikagi iya wé, nekedan dé sa ginawa di. ");
INSERT INTO mta_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na, egoh sa kapitan sundalu mighaa sa medoo nebaelan dahiya egoh i Hésus nematay, inolò di Nemula i owoy guwaen di, “Tuu ma doo, metiengaw etaw ini i maama.” ");
INSERT INTO mta_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na, melaweng sa etaw dahiya eghaa sa medoo kinebael da si Hésus. Egoh da mighaa, eglikù da owoy takaan da egdukduk sa kagpa da danà sa pedu da nebukul temù. ");
INSERT INTO mta_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Dodoo sa langun loyuk i Hésus owoy sa medoo bayi mig-unut kenagdi kedu siedò tanà Galiliya, migtigdeg da ma mediyùdiyù owoy eghauwen da ma sa langun kebael da si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Na, duen sa sebaen kaunutan etaw Hudiyu, si Hosé. Kagdi sa etaw tegeAlimatiya, sa menuwa diyà sa uwang Hudiya. Metiengaw etaw Hosé i owoy anan mepion sa adat di owoy eg-angat-angatan di ma sa kedatù i Nemula. Apiya di pa kaunutan Hudiyu kagdi i, endà eg-unutan di duu sa penemdem sa medoo duma di kaunutan owoy sa kinebael da si Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Agulé, mig-angay diyà si Pilatu owoy pinegeni di sa lawa i Hésus anì ilebeng di. ");
INSERT INTO mta_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Agulé, kinuwa di sa lawa i Hésus diyà sa kayu igbugsud, owoy binedbed di sa mebulà ginis mepion. Igtagù di dalem sa lebeng magtu tinosongon etaw diyà batu, sa endà pa linebengan etaw. ");
INSERT INTO mta_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Agulé, buyu dé eg-eled sa agdaw, owoy egtapayen sa medoo Hudiyu sa langun egbaelan da, enù ka amuk eg-eled dé sa agdaw iya sa edungan sa agdaw keetud da. ");
INSERT INTO mta_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na, sa medoo bayi mig-unut si Hésus kedu Galiliya dò, inunutan da Hosé i egoh di mig-angay eglebeng si Hésus. Hinaa da sa kenà lebeng owoy sa ketenà di sa lawa i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Agulé, miglikù da owoy egtapayen da egtipoh sa bulung mepion ngadeg itagù da diyà sa lawa sa nematay. Agulé, mig-etud da diyà sa agdaw keetud da, enù ka inunutan da sa uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na, umenaw simag Akad, mig-angay sa medoo bayi dutu siedò kenà i Hésus iglebeng. Eglapus da temù owoy inuwit da sa bulung mepion ngadeg tinapay da enù ka itagù da diyà sa lawa i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dodoo egoh da egtebow, hinaa da neukaan dé sa lebeng enù ka nekelid sa dakel batu igsagpeng lebeng. ");
INSERT INTO mta_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Agulé, egoh da mig-awuh diyà sa tosong lebeng, endà dé hinaa da duu sa lawa i Hésus. ");
INSERT INTO mta_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Negaip da temù. Hê, egoh da telibubu egkegaip, migpehaa diyà kenagda sa duwa maama egsenang sa ginis da. ");
INSERT INTO mta_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Agulé, migkudung sa medoo bayi danà da nelimedangan temù. Dodoo guwaen sa duwa maama, “Maen di ya eglagbeten yu sa etaw nehagtay diyà sa kenà lebeng? ");
INSERT INTO mta_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Endà dahini di enù ka neenaw dé. Egketulengan yu pa atu sa tinulon di diyà keniyu egoh di pelawà dutu Galiliya dò? ");
INSERT INTO mta_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iya sa tinulon di, guwaen di, ‘Ini sa ketamanan sa Kakay Langun, mekebegay diyà sa medoo etaw tegebael salà. Itutuk da kagdi diyà sa kayu ibugsud, dodoo amuk meuma sa ketelu di agdaw meenaw doo.’” ");
INSERT INTO mta_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Agulé, netulengan da sa inikagi i Hésus, ");
INSERT INTO mta_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","huenan di miglikù da kedu diyà sa kenà lebeng owoy tinulon da sa langun hinaa da diyà sa sepulù owoy sebaen salu i Hésus owoy diyà sa langun duma da ma. ");
INSERT INTO mta_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na, iya sa etaw egtulon iya wé diyà sa medoo salu di, si Maliya tegeMagdala, owoy si Huana, owoy si Maliya inay i Santiyago, owoy sa medoo duma da bayi. ");
INSERT INTO mta_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Dodoo egoh sa medoo salu di migdineg sa tinulon da, endà egpigtuuwen da duu enù ka guwaen da uloy kagi daa iya wé inikagi da. ");
INSERT INTO mta_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Dodoo egletu Pidelu i eg-angay dutu siedò kenà lebeng. Egoh di migtebow, migpepokòpokò tanà, dodoo iya daen sa nesalilan di sa mebulà ginis endà duen dalem di. Agulé, miglikù owoy takaan di egpenemdem sa langun ukit-ukit nebaelan dahiya. ");
INSERT INTO mta_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na, iya ma sa agdaw keipanaw sa duwa pasek i Hésus eglikù eg-angay dutu menuwa Imayus dò. Iya sa kediyù di diyà Hélusalém kéen, sepulù owoy sebaen kakilumitelu. ");
INSERT INTO mta_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na, egoh da eg-ipanaw, egseolomoy da sa langun ukit-ukit kinebael sa medoo etaw si Hésus diyà Hélusalém. ");
INSERT INTO mta_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hê, egoh da egseolomoy, migpedapag Hésus i diyà kagda owoy eg-unut-unut ma. ");
INSERT INTO mta_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Apiya di pa eghauwen da, endà egkilalaen da duu. ");
INSERT INTO mta_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Agulé, guwaen di diyà kenagda, “Ngadan iya wé egseolomen yu giina egoh yu eg-ipanaw?” Hê, mig-ugpà da owoy anan mebegat sa palas da. ");
INSERT INTO mta_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Agulé, migsagbì sa sebaen, si Kelipas, guwaen di, “Negaip a maen di ya endà neketiig ka. Kuna daa kéen sa etaw eg-ugpà diyà Hélusalém endà neketiig sa medoo neukit-ukitan dahiya endà pa nelugay di.” ");
INSERT INTO mta_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Agulé guwaen di, “Ngadan iya wé neukit-ukitan dahiya?” Guwaen da, “Iya sa eg-ikagiyen ké sa denu si Hésus tegeNasalét. Kagdi sa tegesugkow i Nemula, mebagel sa keikagi di egtulù owoy medoo sa dakel panduan di. Pinetuu i Nemula sa langun binaelan di owoy netuuwan ma sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Dodoo sa medoo ulu-ulu tegesimbà owoy sa medoo kaunutan ta, igbegay da polo diyà sa gubilenu anì meimatayan. Hê, igpetutuk da diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nebukul ké enù ka iya sa penemdem ké hedem kagdi sa umaluk kenita i etaw Islaél. Owoy duen ma sa pesuwan ké egkegaip. Apiya di pa telu dé agdaw egoh di nematay, ");
INSERT INTO mta_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","duen ma duma ké bayi eggaipan da kami enù ka miglapus da mig-angay dutu siedò lebeng, ");
INSERT INTO mta_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","dodoo endà hinaa da gaa sa lawa di. Egoh da miglikù, tinulon da kenami duen sa hinaa da dutu gaa, duwa egsugùsuguen i Nemula owoy guwaen da ma nehagtay doo Hésus i gaa enù ka mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na, duen ma duma ké maama mig-angay eghaa dutu siedò kenà lebeng. Netuuwan da diyà sa tinulon sa bayi, dodoo endà ma hinaa da duu Hésus i.” ");
INSERT INTO mta_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Agulé, guwaen i Hésus diyà kenagda, “O medoo endà duen pedu, maen di ya negaip yu? Maen di ya endà pa egpekepigtuu yu sa langun igsulat sa medoo tegesugkow i Nemula egoh anay? ");
INSERT INTO mta_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Tinulon da sa ketamanan i Kelistu sa Tigtu Datù eg-angat-angatan ta. Endà pa kumedatù di dutu langit dò taman endà mekeukit di muna diyà siini medoo egkelikutan di. Maen di ya egkegaipan yu?” ");
INSERT INTO mta_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Agulé, igtulù di diyà kenagda sa denu kenagdi diyà sa langun kagi i Nemula igpesulat edung diyà sa igsulat i Mosis taman sa igsulat sa medoo tegesugkow di. ");
INSERT INTO mta_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na, egoh da medapag diyà sa menuwa eg-angayan da, buyu dé egtalà Hésus i. ");
INSERT INTO mta_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Dodoo hinawidan da temù, guwaen da, “Na Akay, tudug ka pelawà segdu diyà kenami enù ka mahapun dé.” Agulé, mig-unut Hésus i diyà kenagda eggemow. ");
INSERT INTO mta_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na, egoh da egkaen mahapun, kinuwa di sa epan owoy egpesalamat diyà si Nemula danà sa kaenen da. Tinepi di sa epan owoy igbegay di diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Agulé, lagà nebukehén sa mata da, hê kinilala da dé Hésus i. Dodoo petow dé endà hinaa da duu. ");
INSERT INTO mta_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Agulé, migseikagiyay da, guwaen da, “Tuu ma doo, netuuwan ki temù danà di migtulù kenita diyà dalan. Migkepion sa pedu ta lagà apuy eglemat danà di migselepang sa kagi i Nemula igpesulat.” ");
INSERT INTO mta_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Agulé, egpesiyapat da egpelikù Hélusalém dò. Egoh da migtebow dutu, hinaa da sa sepulù owoy sebaen salu i Hésus nesetipon owoy sa medoo duma da. ");
INSERT INTO mta_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tinulon sa etaw nesetipon diyà kenagda, guwaen da, “Tuu ma doo, mig-enaw dé Datù i, enù ka migpehaa diyà si Pidelu.” ");
INSERT INTO mta_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Agulé, tinulon ma sa duwa etaw magtu migtebow sa nebaelan da diyà dalan owoy sa kekilala da ma si Hésus egoh di migtepi epan. ");
INSERT INTO mta_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Agulé, egoh da mig-ikagi pelawà, petow dé hinaa da Hésus i migtigdeg dahiya. Sinaluan di kagda, guwaen di, “Kumelanih sa keugpà yu.” ");
INSERT INTO mta_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dodoo nepetow da owoy egkelimedangan da temù, enù ka guwaen da dò suguy di daa sa hinaa da. ");
INSERT INTO mta_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Agulé guwaen i Hésus, “Maen yu ya egkegaip? Maen di ya neduwa sa pedu yu denu kenak? ");
INSERT INTO mta_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Haa yu sa kagpa belad ku owoy sa iyug lisen ku. Tuu, aken si Hésus. Sabai yu aken anì metuuwan yu. Amuk suguy ku daa, endà duen tigtu lawa di, dodoo duen doo sa lawa ku eghauwen yu.” ");
INSERT INTO mta_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hê, egoh di mig-ikagi iya wé, igpehaa di diyà kenagda sa kagpa belad di owoy sa iyug lisen di. ");
INSERT INTO mta_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Negaip da owoy neanggan ma sa pedu da, dodoo tapay doo neduwa sa pedu da. Huenan di, guwaen i Hésus, “Duen pa kaenen yu dahini?” ");
INSERT INTO mta_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Agulé, binegayan da kagdi tukééy sedà tinueg da. ");
INSERT INTO mta_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hê, kinuwa di owoy kinaen di egoh da eghaa kenagdi. ");
INSERT INTO mta_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Agulé guwaen i Hésus, “Taa yu, hih. Egoh ku mig-ugpà pelawà diyà keniyu, ini sa tinulon ku diyà keniyu, guwaen ku meketuu sa langun igsulat denu kenak diyà sa uledin i Nemula igsugkow i Mosis owoy diyà sa igsulat sa medoo tegesugkow i Nemula owoy diyà sa igsulat diyà libelu Isalem.” ");
INSERT INTO mta_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Agulé, pineilag di sa pedu da anì metiigan da sa kagi i Nemula igpesulat. ");
INSERT INTO mta_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Guwaen di diyà kenagda, “Duen sa kagi i Nemula igpesulat egoh anay, guwaen di mepigtamayan Kelistu i owoy meimatayan ma, dodoo meenaw mendaa diyà sa ketelu di agdaw. ");
INSERT INTO mta_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iya ma sa igpesulat di, amuk ekedan sa etaw sa salà da owoy migtuu da diyà kenak, ipeuloy i Nemula doo sa salà da. Metulon yu iya wé diyà sa langun etaw diyà sa langun balangan tanà edung diyà sa menuwa Hélusalém. ");
INSERT INTO mta_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hinaa yu dé sa egoh di neketuu siini igpesulat i Nemula, huenan di kiyu dé sa meketulon diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Taa yu. Peangayen ku diyà keniyu sa Metiengaw Suguy i Nemula sa igpasad i Emà ku. Dodoo angat-angati yu pelà diyà Hélusalém taman endà tumebow di diyà keniyu sa tunung kedu langit dò.” ");
INSERT INTO mta_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Agulé, miglegkang da diyà Hélusalém owoy inuwit i Hésus kagda eg-angay medapag Bétaniya dò. Agulé, pinetigdeg di sa duwa belad di owoy migsimbà egpegeni sa ketabang i Nemula diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hê ligò di egsimbà, sinalidan di kagda owoy nebatun dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Agulé, miglikù da Hélusalém dò owoy tigtu neanggan sa pedu da. ");
INSERT INTO mta_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Takà da eg-angay diyà sa Dalesan i Nemula owoy egsimbà da ma eg-olò si Nemula.");
INSERT INTO mta_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na, egoh anay egoh di endà pa duen tanà, tapay dé duen Kelistu i ginelal sa Kagi i Nemula. Kagdi sa duma i Nemula owoy tigtu Nemula ma. ");
INSERT INTO mta_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Egoh anay egoh di endà pa duen sa langun taman binaelan di, tapay dé kagdi sa duma i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pineduen i Nemula sa langun taman danà i Kelistu migbael, owoy endà duen sa nebaelan amuk beken danà di. ");
INSERT INTO mta_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kagdi sa egpelalù etaw taman melugay. Lagà legdaw siini lalù enù ka melegdawan sa penemdem sa langun etaw anì metiigan da Nemula i. ");
INSERT INTO mta_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Egkelegdawan siini legdaw i Nemula sa deleman diyà tanà, owoy endà mekeatu sa delem diyà sa legdaw. ");
INSERT INTO mta_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, duen sa maama sinugù i Nemula. Iya sa ngadan di si Huwan. ");
INSERT INTO mta_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pineangay i Nemula kagdi anì tumulon diyà sa medoo etaw denu si Hésus Kelistu sa legdaw i Nemula anì mekepigtuu sa langun etaw danà sa ketegudon di. ");
INSERT INTO mta_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Beken si Huwan sa legdaw i Nemula, dodoo mig-angay daa egtulù denu sa legdaw i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hê, migtebow diyà tanà sa tigtu legdaw si Hésus Kelistu anì pelegdawan di sa pedu sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Na, migtebow Kelistu i diyà tanà, dodoo endà egkilalaen sa medoo etaw duu apiya di pa binaelan i Nemula sa tanà danà di. ");
INSERT INTO mta_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Apiya di pa mig-angay diyà sa menuwa duma di etaw Hudiyu, endà egsakemen da duu. ");
INSERT INTO mta_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Dodoo sa langun etaw migsakem kenagdi owoy migpigtuu da ma diyà kenagdi, binegayan di doo kagda egkegaga anì meanak i Nemula kagda. ");
INSERT INTO mta_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Beken lagà sa kelesut etaw diyà tanà sa keanak di kenagda, enù ka beken danà sa uyot etaw daa ataw ka sa penemdem etaw daa. Dodoo danà sa uyot i Nemula polo, inanak di kagda. ");
INSERT INTO mta_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na, neetaw diyà tanà iya wé etaw ginelal Kagi i Nemula, owoy mig-ugpà diyà kenami. Hinaa ké sa senang di. Dakel sa senang di enù ka kagdi sa bugtung Anak i Emà di Nemula. Dakel sa ketabang ipeuloy di diyà kenita owoy anan tuu sa langun kagi di. ");
INSERT INTO mta_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Kagdi sa tinulon i Huwan egoh di migtegudon diyà etaw, guwaen di, “Ini sa etaw tinulon ku diyà keniyu, enù ka iya sa inikagi ku duen sa etaw mekesambì kenak. Kagdi sa eglowon diyà kenak enù ka tapay dé duen kagdi ya egoh sa tanà endà pa duen.” ");
INSERT INTO mta_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Na, danà sa tigtu dakel ketabang ipeuloy di kenita, takaan di kita egtabang taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Igpetiig i Nemula diyà kenita sa medoo uledin di danà i Mosis. Dodoo danà i Hésus Kelistu polo, igpetiig di dé diyà kenita sa dakel ketabang igpeuloy di kenita owoy sa tuu tegudon. ");
INSERT INTO mta_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Endà duen etaw mekehaa si Nemula. Dodoo sa bugtung Anak di sa egpetiig diyà kenita denu sa Emà di si Nemula, enù ka nesesebaen da daa. ");
INSERT INTO mta_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na, duen ma duma etaw tegesimbà owoy medoo tugod i Lebi mig-angay diyà si Huwan sa Tegebautis. Kagda sa pineangay sa medoo ulu-ulu etaw Hudiyu tegeHélusalém anì igsaan da Huwan i. Guwaen da, “Ngadan ko ya etaw?” ");
INSERT INTO mta_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Endà memalaan Huwan i egsagbì diyà kenagda, dodoo egtulonen di sa tuu kagi, guwaen di, “Beken aken sa Tigtu Datù sinugù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Agulé, eg-igsaan da dema, guwaen da, “Enù di ya, si Iliyas ka kéen, sa tegesugkow i Nemula egoh anay?” Guwaen i Huwan, “Beken.” Agulé guwaen da dema, “Kuna kéen sa tegesugkow i Nemula eg-angat-angatan ké.” Migsagbì, guwaen di, “Beken ma.” ");
INSERT INTO mta_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Agulé guwaen da, “Tuloni ko kami ngadan ko ya etaw anì dumuen sa metulon ké diyà sa medoo etaw migpeangay kenami. Ngadan ko ya etaw kuna ya?” ");
INSERT INTO mta_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Migsagbì Huwan i, “Aken sa igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, ‘Dumuen sa maama mikagi metaled dutu siedò melabel tanà mediyù dalesan. Iya sa guwaen di, Petudà yu sa dalan ukitan i Datù tumebow.’” ");
INSERT INTO mta_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, siini medoo etaw eg-igsà diyà si Huwan, kagda sa pineangay sa medoo Palasiyu. ");
INSERT INTO mta_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Eg-igsaan da dema, guwaen da, “Maen di ya egbautis ka etaw atu amuk beken kuna sa Tigtu Datù pineangay i Nemula owoy beken si Iliyas ka owoy beken ka sa tegesugkow i Nemula eg-angat-angatan ké?” ");
INSERT INTO mta_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Guwaen i Huwan egsagbì, “Tuu, egbautis a etaw diyà wayeg. Dodoo taa yu, duen diyà keniyu sa sebaen etaw endà egkilalaen yu duu. ");
INSERT INTO mta_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kagdi sa mekesambì kenak. Kagdi sa tigtu eglowon diyà kenak, owoy tigtu a mepokò diyà kenagdi. Huenan di, memala a amuk aken sa egsugùsuguen di egkedan talumpà di daa.” ");
INSERT INTO mta_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Na, iya sa kenà da eg-igsà si Huwan sa menuwa Bétaniya tanà dutu lawa Holdan kenà di egbautis etaw. ");
INSERT INTO mta_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Na, egoh di sumimag, hinaa i Huwan Hésus i eg-angay diyà kenagdi. Agulé, guwaen i Huwan diyà sa medoo etaw dahiya, “Taa yu hih. Ini sa etaw lagà anak kebilibili ibegay i Nemula, enù ka mekedan sa salà sa langun etaw danà sa kepatay di. ");
INSERT INTO mta_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kagdi sa etaw tinulon ku diyà keniyu egoh ku mig-ikagi, guwaen ku, ‘Duen sa etaw mekesambì kenak, dodoo eglowon diyà kenak enù ka tapay dé duen kagdi ya egoh sa tanà endà pa duen.’ ");
INSERT INTO mta_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Egoh anay, endà egkilalaen ku duu kagdi i. Dodoo migbautis a etaw diyà wayeg anì ipetiig ku kagdi i diyà sa medoo duma ta tugod i Islaél.” ");
INSERT INTO mta_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Guwaen i Huwan, “Hinaa ku sa Metiengaw Suguy i Nemula migpetuntun kedu langit eg-angay egtenà diyà si Hésus. Egoh di egpetuntun, egpeiling manuk éhê menatad. ");
INSERT INTO mta_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Egoh anay, endà pa netiigan ku duu si Hésus sa Tigtu Datù sinugù i Nemula. Dodoo si Nemula sa migsugù kenak anì mautis a etaw diyà wayeg, migtulon diyà kenak, guwaen di, ‘Amuk hauwen ko sa Metiengaw Suguy ku petuntun mangay mugpà diyà sa etaw, kagdi sa etaw hinemilì ku anì ibautis di etaw sa Metiengaw Suguy ku.’ ");
INSERT INTO mta_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na, hinaa ku dé iya wé, owoy egtulonen ku dé diyà keniyu kagdi sa Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Na, egoh di sumimag, dahiya da dema si Huwan owoy duwa pasek di. ");
INSERT INTO mta_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Agulé, egoh i Huwan mighaa si Hésus egtalà, guwaen di, “Taa yu, hih. Kagdi sa etaw lagà anak kebilibili ibegay i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Na, egoh sa duwa pasek di migdineg iya wé, sinalidan da Huwan i owoy eg-unut da polo si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Agulé, egoh i Hésus egpelikù eg-isalu, hinaa di kagda eg-unut-unut diyà kenagdi owoy mig-igsà, guwaen di, “Maen di ya eg-unut yu kenak?” Egsagbì da, guwaen da diyà sa hagda kagi, “O Labi.” Na, iya sa selepangan di, “O Mistelu.” Guwaen da, “Kenà ko ya eg-ugpà?” ");
INSERT INTO mta_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Guwaen i Hésus, “Unut yu kenak anì hauwen yu sa kenà ku.” Huenan di, eg-unut da kenagdi owoy hinaa da sa kenà di eg-ugpà. Eglengen da diyà kenagdi edung alas epat mahapun taman eg-eled dé sa agdaw. ");
INSERT INTO mta_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na, si Andelis sa sebaen diyà siini duwa etaw migdineg si Huwan owoy mig-unut diyà si Hésus. Hadi i Simon Pidelu Andelis i. ");
INSERT INTO mta_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Agulé, egpanayen di eghaa sa kakay di, si Simon, owoy guwaen di diyà kenagdi, “Hinaa ké dé si Mésayas.” Na, iya sa selepangan sa ngadan di, si Kelistu sa Tigtu Datù pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Agulé, inuwit di Simon i eg-angay diyà si Hésus. Agulé, eg-inengtengen i Hésus owoy guwaen di, “Kuna si Simon anak i Huwan, dodoo egpengadanan ku kuna si Sipas.” Na, iya sa selepangan sa ngadan Sipas owoy Pidelu, sa batu. ");
INSERT INTO mta_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Na, egoh di sumimag, ungayà i Hésus mangay dutu tanà Galiliya dò. Agulé hinaa di Pilipi i, owoy guwaen di diyà kenagdi, “Unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Na, kedu diyà Bétsaida Pilipi i, owoy iya ma sa menuwa kenà da eg-ugpà si Andelis owoy si Pidelu. ");
INSERT INTO mta_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Agulé, hinaa i Pilipi Natanayél i, owoy guwaen di, “Hinaa ké dé sa etaw igsulat i Mosis egoh anay diyà sa libelu sa uledin i Nemula, owoy kagdi ma sa igsulat sa medoo tegesugkow i Nemula egoh anay. Kagdi si Hésus tegeNasalét, sa anak i Hosé.” ");
INSERT INTO mta_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Dodoo guwaen i Natanayél, “Endà duen sa mepion kedu diyà Nasalét.” Guwaen i Pilipi, “Na, mangay ki dutu anì hauwen ko.” ");
INSERT INTO mta_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na, egoh i Hésus mighaa si Natanayél eg-angay diyà kenagdi, eg-ikagi denu si Natanayél, guwaen di, “Ini sa tigtu tugod i Islaél enù ka endà duen sa iglidung di.” ");
INSERT INTO mta_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Agulé eg-igsà Natanayél i, guwaen di, “Maen di ya egkilalaen ko aken?” Guwaen i Hésus egsagbì, “Egoh i Pilipi endà pa mig-angay keniko, hinaa ku kuna diyà sa pesu kayu pigus.” ");
INSERT INTO mta_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Guwaen i Natanayél, “O Mistelu, tuu kuna sa Anak i Nemula. Kuna ma sa Tigtu Datù diyà siini tanà Islaél.” ");
INSERT INTO mta_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Agulé guwaen i Hésus, “Enù di ya, iya daa sa pesuwan ko egpigtuu danà ku migtulon sa egoh ku mighaa keniko diyà sa pesu kayu pigus? Taa ko, hih. Hauwen ko kani sa medoo baelan ku uman pa egkegaipan etaw diyà iya wé.” ");
INSERT INTO mta_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Guwaen i Hésus ma, “Tuu ini i eg-ikagiyen ku diyà keniyu. Hauwen yu sa langit meukaan owoy hauwen yu ma sa medoo egsugùsuguen i Nemula mebatun owoy petuntun mangay diyà kenak, aken i Kakay Langun.” ");
INSERT INTO mta_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Na, egoh di neuma duwa agdaw, duen sa pista kawing dutu menuwa Kana dò diyà uwang Galiliya. Eglenged sa inay i Hésus sa pista, ");
INSERT INTO mta_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","owoy dahiya ma si Hésus owoy sa medoo pasek di enù ka igsasà ma sa etaw egbael pista kagda. ");
INSERT INTO mta_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na, egoh da egpista, neimet dé sa wain eg-inemen da. Huenan di, eg-ikagi sa inay i Hésus diyà kenagdi, guwaen di, “Endà dé duen sa wain da.” ");
INSERT INTO mta_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Egsagbì Hésus i, guwaen di, “Yaka egbogo kenak, Inay, enù ka endà pa neuma sa agdaw egoh ku egpehaa sa tunung ku.” ");
INSERT INTO mta_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Agulé, guwaen sa inay di diyà sa medoo etaw tegebulig dahiya, “Sumalà dé sa ikagiyen di diyà keniyu, unuti yu dé.” ");
INSERT INTO mta_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, iya sa adat Hudiyu egpegusê da amuk kumaen da. Huenan di, duen dahiya sa enem buyung daleman da wayeg ipegusê da. Uman sebaen buyung kedaleman epat kalatà wayeg ataw ka enem. ");
INSERT INTO mta_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Agulé, guwaen i Hésus diyà sa medoo etaw tegebulig, “Penù yu wayeg sa buyung.” Hê, pinenù da wayeg sa langun buyung. ");
INSERT INTO mta_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Agulé, guwaen i Hésus dema, “Sakug yu owoy uwit yu dutu siedò maama tegetulik pista.” Agulé, inuwit da diyà sa maama tegetulik pista. ");
INSERT INTO mta_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hê, tinukawan di sa wayeg nebaluy wain. Endà netiigan di duu sa keduwan sa wain, dodoo netiigan doo sa etaw tegebulig enù ka kagda sa migkuwa sa wayeg. Egoh di migtukaw sa wain, inumow di sa maama egkawingen, ");
INSERT INTO mta_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","owoy guwaen di diyà kenagdi, “Iya sa adat sa etaw egbael pista, itenà da muna sa tigtu mepion wain. Agulé amuk uminem temù sa medoo etaw, itenà da sa wain endà iseg di mepion. Huenan di negaip a, enù ka endà itenà ko duu ini i tigtu mepion wain taman ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Na, egoh i Hésus migbael siini panduan diyà menuwa Kana diyà uwang Galiliya, iya sa anay panduan binaelan di anì ipehaa di sa tunung di. Huenan di, migpigtuu dé sa medoo pasek di diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Agulé, mig-ipanaw Hésus i owoy sa inay di owoy sa medoo hadi di owoy sa medoo pasek di eg-angay da dutu menuwa Kapelenaum dò. Endà iseg da melugay eg-ugpà dahiya. ");
INSERT INTO mta_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na, buyu dé egkeuma sa pasad sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Huenan di, mig-angay Hésus i dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Egoh di migtebow, duen medoo etaw hinaa di diyà sa duwangen Dalesan i Nemula, sa medoo etaw tegedagang sapì owoy kebilibili owoy menatad enù ka iya sa imatayan da amuk sumimbà da. Hinaa di ma sa medoo etaw tegesambì pilak diyà sa lamisan da. ");
INSERT INTO mta_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Egoh di mighaa iya wé, binaelan di sa tapes tali owoy eghemagawan di sa medoo sapì owoy kebilibili anì mekeliyu da diyà sa Dalesan i Nemula. Pinekinilid di ma sa medoo lamisan sa tegesambì pilak, hê netayak sa langun pilak da. ");
INSERT INTO mta_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Guwaen di diyà sa medoo tegedagang menatad, “Kedani yu iya wé dini. Ini sa Dalesan i Emà, dodoo nebaluy dalesan padian polo danà yu takà egdagang dahini.” ");
INSERT INTO mta_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na, egoh sa medoo pasek di mighaa sa binaelan i Hésus, netulengan da sa kagi i Nemula igpesulat, guwaen di, “O Nemula, tigtu medaet sa pedu ku, enù ka dakel temù sa kehidu ku sa dalesan ko.” ");
INSERT INTO mta_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Agulé, eg-igsaan sa medoo kaunutan Hudiyu Hésus i, guwaen da, “Ngadan sa panduan mebaelan ko anì metiigan ké kuna sa binegayan i Nemula egkegaga anì mekebael ka iling iya wé?” ");
INSERT INTO mta_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Migsagbì Hésus i, guwaen di, “Amuk lukaten yu siini dalesan kenà i Nemula eg-ugpà, petigdegen ku dema diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Agulé eggemenan da kagdi, guwaen da, “Epat pulù owoy enem gepalay sa lugay da migbael siini Dalesan i Nemula egoh anay. Gasama iya, petigdegen ko daa diyà sa ketelu di agdaw.” ");
INSERT INTO mta_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Dodoo endà netiigan da duu iya sa dalesan inikagi i Hésus sa lawa di. ");
INSERT INTO mta_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Dodoo, egoh i Hésus neenaw diyà sa ketelu di agdaw egoh di nematay, netulengan sa medoo pasek di iya wé inikagi di. Huenan di, egpigtuuwen da sa kagi i Nemula igpesulat denu sa keenaw di owoy sa inikagi i Hésus ma. ");
INSERT INTO mta_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na, egoh i Hésus eg-ugpà pelà diyà Hélusalém egoh da egpista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, medoo sa etaw egpigtuu dé diyà kenagdi danà da mighaa sa medoo panduan binaelan di. ");
INSERT INTO mta_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Dodoo endà egketuuwan Hésus i diyà kenagda, enù ka netiigan di sa pedu sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Apiya di pa endà duen etaw egtulon diyà kenagdi sa penemdem da, netiigan di doo sa pedu sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na, duen dahiya sa maama Palasiyu, si Nikodimu. Kagdi sa sebaen ulu-ulu diyà etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Na sebaen sigep, mig-angay eg-ikagi diyà si Hésus, guwaen di, “O Mistelu, netiigan ké kuna sa tegetulù pineangay i Nemula diyà tanà, enù ka endà duen etaw egpekebael panduan iling sa panduan ko amuk beken kedu si Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Migsagbì Hésus i, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniko. Amuk endà duwa sa kenà di inanak sa etaw, endà mekeunut di sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Agulé guwaen i Nikodimu, “Enù kebaluy sa lukes maama eglesut? Mekebaluy pa egpelikù dalem sa getek inay di anì lumesut dema?” ");
INSERT INTO mta_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Migsagbì Hésus i, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniko. Amuk endà anaken sa etaw danà sa wayeg owoy danà sa Suguy i Nemula ma, endà mekeunut di sa kedatù i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa inanak etaw diyà tanà, etaw daa. Dodoo sa inanak sa Suguy i Nemula, iya sa épê sa lalù i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Huenan di, yaka egkegaip duu siini guwaen ku, meanak yu dema langun. ");
INSERT INTO mta_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Haa ko sa kelamag. Mangay doo sumalà dé sa angayan di. Egkedineg ko sa dagì di, dodoo endà egketiigan ko duu sa keduwan di ataw ka sa angayan di. Hediya ma sa etaw inanak sa Suguy i Nemula. Endà eghauwen ta duu sa Suguy i Nemula, dodoo eghauwen ta doo sa danà di.” ");
INSERT INTO mta_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Guwaen i Nikodimu eg-igsà, “Enù kebaluy iya wé?” ");
INSERT INTO mta_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Egsagbì Hésus i, guwaen di, “Kuna sa tegetulù diyà sa medoo tugod i Islaél. Maen di ya endà egketiigan ko duu iya wé? ");
INSERT INTO mta_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tuu ini i eg-ikagiyen ku diyà keniko. Eg-ikagiyen ké sa netiigan ké owoy egtulonen ké ma sa hinaa ké, dodoo endà egpigtuuwen yu duu sa eg-ikagiyen ké. ");
INSERT INTO mta_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Amuk endà egpigtuu ka sa ketulon ku denu sa medoo eghauwen diyà tanà, endà ma mekebaluy ka migtuu sa ketulon ku denu sa medoo eghauwen dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na, endà duen etaw nebatun dutu langit dò anì egtulon sa medoo eghauwen dutu, liyu daa aken i Kakay Langun sa migpetuntun kedu dutu. ");
INSERT INTO mta_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Na, egoh anay egoh sa medoo Hudiyu egkematay danà da hinemued uled dutu siedò melabel tanà mediyù dalesan, binaelan i Mosis sa galang éhê uled owoy igtagù di diyà sa kayu igbugsud anì mealukan sa etaw eg-inengteng diyà sa galang éhê uled. Hediya ma aken i Kakay Langun, meketagù a ma diyà sa kayu igbugsud, ");
INSERT INTO mta_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","anì melalù taman melugay sa langun etaw egpigtuu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Na, eghiduwan i Nemula temù sa langun etaw diyà tanà. Huenan di, pineangay di sa Anak di bugtung diyà tanà anì mealukan da. Sumalà dé sa etaw egpigtuu diyà kenagdi, endà mekesugsug di enù ka dumuen lalù di polo endà meelut di. ");
INSERT INTO mta_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pineangay i Nemula sa Anak di diyà tanà anì alukan di sa langun etaw. Beken iya sa pesuwan di anì pigtamayan di sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Amuk egpigtuu sa etaw diyà sa Anak di, endà mepigtamayan da. Dodoo sa etaw endà egpigtuu, tapay doo netiigan ta mepigtamayan da danà sa medoo salà da, enù ka endà egpigtuu da diyà sa bugtung Anak i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Na, iya sa pesuwan da mepigtamayan sa etaw endà egpigtuu enù ka migtebow dé sa legdaw diyà sa langun etaw, dodoo egkeiyapan da polo sa delem enù ka medaet sa egbaelan da. ");
INSERT INTO mta_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sumalà dé sa etaw tegebael medaet, egkelepuhan di sa legdaw. Huenan di, endà eg-angay di diyà sa legdaw enù ka meked amuk mehaa sa egbaelan di. ");
INSERT INTO mta_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Dodoo sa etaw eg-unut sa tuu tegudon, eg-angay polo diyà sa legdaw anì mehaa sa medoo egbaelan di danà sa kepangunut di diyà si Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Agulé, mig-angay Hésus i owoy sa medoo pasek di diyà sa uwang Hudiya. Nelugaylugay da eg-ugpà dahiya, enù ka egbautis da etaw. ");
INSERT INTO mta_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Egbautisan i Huwan ma sa medoo etaw dutu Inon dò medapag diyà menuwa Salim enù ka dakel sa wayeg dahiya. Medoo sa etaw eg-angay egpebautis diyà kenagdi, ");
INSERT INTO mta_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","enù ka egoh iya endà pa nebilanggu di. ");
INSERT INTO mta_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Agulé, egsesigbolowoy sa medoo pasek i Huwan owoy sa etaw Hudiyu denu sa adat kepegusê da anì kumelanih da. ");
INSERT INTO mta_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Huenan di, mig-angay da diyà si Huwan owoy guwaen da, “O Mistelu, netulengan ko pa siedò duma ko egoh ko tanà dutu lawa Holdan, sa etaw tinulon ko diyà kenami egoh anay? Hê, egbautis ma dé etaw, owoy duen ma dé sa medoo etaw eg-unut diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Migsagbì Huwan i, guwaen di, “Endà egkesina a denu iya wé, enù ka endà duen sa megaga sa etaw amuk beken si Nemula sa egbegay diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Netiigan yu doo sa inikagi ku egoh anay, guwaen ku, ‘Beken aken sa Tigtu Datù sinugù i Nemula, dodoo pineangay i Nemula aken anì abungan ku sa ukitan i Datù tumebow.’ ");
INSERT INTO mta_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na upama, amuk duen sa kawing, iya sa eg-unutan sa bayi sa maama egkawingen, beken sa maama loyuk di. Dodoo sa loyuk di, meanggan ma doo amuk dinegen di sa maama eg-ikagi diyà sa bayi egsawaen di. Hediya ma aken i, lagà a sa loyuk sa maama egkawingen enù ka tigtu meanggan a ma amuk mangay sa medoo etaw diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Meumanan sa lalag i Hésus owoy kumetukééy sa naken lalag.” ");
INSERT INTO mta_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Na, sa etaw pineangay dini kedu langit dò, kagdi sa eglowon diyà sa langun. Dodoo sa etaw eg-ugpà diyà tanà, iya sa etaw kedu diyà tanà daa owoy eg-olomen di daa sa medoo eghauwen di diyà tanà. Dodoo iya sa eglowon diyà sa langun sa etaw kedu diyà langit. ");
INSERT INTO mta_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Egtulonen di sa hinaa di owoy sa dinineg di diyà langit, dodoo endà medoo sa etaw egpigtuu diyà sa kagi di. ");
INSERT INTO mta_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dodoo, sumalà dé sa etaw egpigtuu diyà sa kagi di, iya sa etaw netandaan di tuu sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Na, sa etaw pineangay i Nemula diyà tanà, kagdi sa egtulon sa kagi i Nemula enù ka tigtu pineugpà i Nemula sa Metiengaw Suguy di diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tigtu eghiduwan i Emà ta Nemula sa Anak di si Hésus, owoy igsalig di sa egkegaga diyà kenagdi anì kumedatù diyà sa langun. ");
INSERT INTO mta_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na, sumalà dé sa etaw egpigtuu diyà sa Anak i Nemula, duen dé sa lalù di taman melugay. Dodoo sa etaw endà egpigtuu diyà kenagdi, endà melalù di dodoo mepigtamayan i Nemula polo taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na, dinineg sa medoo Palasiyu sa egoh di uman pa medoo sa etaw eg-unut diyà si Hésus egbautisan di diyà sa kedoo etaw eg-unut diyà si Huwan Tegebautis. ");
INSERT INTO mta_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Dodoo beken duu si Hésus sa egbautis etaw, dodoo sa medoo pasek di daa. ");
INSERT INTO mta_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Na, egoh i Hésus migdineg denu iya wé penemdem Palasiyu, miglegkang Hésus i diyà sa uwang Hudiya mangay dutu uwang Galiliya dò. ");
INSERT INTO mta_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Egoh di eg-ipanaw eg-angay Galiliya dò, mig-ukit da diyà sa uwang Samaliya. ");
INSERT INTO mta_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Diyà uwang Samaliya, migtebow da diyà sa menuwa Sikal medapag diyà sa tanà igbegay i Hakob diyà sa anak di si Hosé egoh anay. ");
INSERT INTO mta_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Duen ma dahiya sa medalem paligì binaelan i Hakob egoh anay. Na, egpenuu Hésus i medapag diyà sa paligì enù ka egkeliteg danà di eg-ipanaw. Egoh di egpenuu, buyu dé egpekebugsang. ");
INSERT INTO mta_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Hê, egtebow sa bayi tegeSamaliya eg-angay wayeg. Guwaen i Hésus diyà sa bayi, “Begayi ko aken wayeg. Uminem a.” ");
INSERT INTO mta_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Na, iya sa pinegeni di enù ka endà dahiya sa medoo pasek di danà da mig-angay egbeli kaenen dutu siedò menuwa. ");
INSERT INTO mta_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tigtu egkegaip sa bayi enù ka egkeselepuh da sa medoo Hudiyu owoy sa medoo etaw Samaliya owoy egkeseiwod da takà. Huenan di, guwaen sa bayi, “Maen di ya egpegeniyan ko aken wayeg? Kuna sa etaw Hudiyu owoy aken sa bayi tegeSamaliya.” ");
INSERT INTO mta_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Guwaen i Hésus egsagbì, “Endà egketiigan ko duu sa igbegay i Nemula owoy endà ma egkilalaen ko duu sa etaw egpegeni wayeg diyà keniko. Enù ka amuk egketiigan ko sa igbegay i Nemula owoy egkilalaen ko ma sa egpegeni, kuna polo sa megeni diyà kenak owoy ibegay ku diyà keniko sa wayeg egpelalù etaw.” ");
INSERT INTO mta_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Agulé guwaen sa bayi, “Endà duen baledi ko owoy medalem ma siini paligì. Kenà ko kumuwa sa wayeg egpelalù etaw? ");
INSERT INTO mta_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Enù di ya, mekelowon ka pa diyà si Hakob sa tupù ta? Kagdi sa migkali siini paligì owoy igbegay di diyà kenami. Ini sa inineman di owoy sa inineman ma sa medoo anak di owoy sa medoo sapì di. Enù di ya, dakel pa sa egkegaga ko anì mekekuwa ka wayeg apiya di pa endà duen kenà ko kumuwa?” ");
INSERT INTO mta_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Guwaen i Hésus egsagbì, “Sa langun etaw eg-inem siini wayeg, eglupahan da doo. ");
INSERT INTO mta_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Dodoo sa etaw eg-inem sa wayeg ibegay ku diyà kenagdi, endà dé lumupahan di. Sa wayeg ibegay ku diyà kenagdi mebaluy tebulan diyà kenagdi. Mebagel sa kebuwalbuwal di owoy mekepelalù kenagdi taman melugay.” ");
INSERT INTO mta_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Guwaen sa bayi, “Begayi ko aken iya wé wayeg anì endà dé lumupahan a anì endà dé mekeuman a mangay wayeg dahini.” ");
INSERT INTO mta_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Agulé guwaen i Hésus, “Angay ko dé sa sawa ko owoy pelikù yu mendaa dini.” ");
INSERT INTO mta_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Egsagbì sa bayi, guwaen di, “Endà duen sawa ku.” Guwaen i Hésus, “Netuuwan a sa guwaen ko endà duen sawa ko, ");
INSERT INTO mta_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","enù ka lima sa sawa ko egoh anay owoy ini egoh di duen sa maama eg-ugpà diyà keniko beken sawa ko. Tuu sa guwaen ko.” ");
INSERT INTO mta_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Agulé guwaen sa bayi, “O Datù, netiigan ku dé kuna sa tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Egoh anay siini getan sa kenà medoo tupù ké egsimbà diyà si Nemula, dodoo kiyu i etaw Hudiyu egsigbolow yu, guwaen yu, ‘Hélusalém polo sa nesugat atung kenà ta egsimbà diyà si Nemula.’” ");
INSERT INTO mta_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Agulé, guwaen i Hésus diyà kenagdi, “O Okon, pigtuu ko ini i eg-ikagiyen ku. Meuma pa sa agdaw beken diyà siini getan daa sa kenà etaw egsimbà diyà si Emà owoy beken ma dutu Hélusalém dò, enù ka mebaluy sumimbà ki sumalà dé sa kenà ta. ");
INSERT INTO mta_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kiyu i etaw tegeSamaliya, endà egketiigan yu duu sa egsimbaan yu. Dodoo kami i Hudiyu, egketiigan ké doo sa egsimbaan ké enù ka kedu diyà Hudiyu sa etaw umaluk sa langun etaw denu sa salà da. ");
INSERT INTO mta_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dodoo, egkeuma dé ini egoh di sa agdaw egoh sa medoo etaw sumimbà diyà si Nemula diyà sa pedu da daa owoy mekepigtuu da sa tuu tegudon denu kenagdi. Amuk hediya, tuu sa kesimbà da enù ka iya sa ungayà i Emà éhê iya sa kesimbà etaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Endà duen lawa di Nemula i owoy endà ma mehaa ta duu. Huenan di, sa etaw egsimbà diyà kenagdi, mekesimbà da diyà sa pedu da owoy mekepigtuu da sa tuu tegudon denu kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Agulé guwaen sa bayi, “Netiigan ku tumebow pa Mésayas i kepengadan ta si Kelistu. Amuk tumebow, tuluen di kita sa langun penemdem i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Guwaen i Hésus diyà sa bayi, “Haa ko sa etaw eg-ikagi diyà keniko ini egoh di. Aken sa maama tumebow eg-ikagiyen ko.” ");
INSERT INTO mta_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na, egoh i Hésus pelà eg-ikagi diyà sa bayi, migtebow sa medoo pasek di. Tigtu da negaip danà da mighaa si Hésus eg-ikagi diyà sa bayi. Dodoo endà eg-igsaen da duu sa ungayaen sa bayi diyà kenagdi, owoy endà ma eg-igsaan da Hésus i sa pesuwan di eg-ikagi diyà sa bayi. ");
INSERT INTO mta_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Agulé, sinalidan sa bayi sa taguan wayeg di, owoy eglikù diyà sa menuwa. Egoh di migtebow, eg-ikagi diyà sa medoo etaw dahiya, guwaen di, ");
INSERT INTO mta_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Unut yu kenak mangay paligì dò anì hauwen yu ma sa maama migtulon diyà kenak sa langun binaelan ku. Enù di ya, kagdi kéen si Kelistu sa Tigtu Datù sinugù i Nemula?” ");
INSERT INTO mta_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Huenan di, eg-ipanaw sa medoo etaw eg-angay diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na, egoh sa bayi mig-ipanaw dé, eg-ikagi sa medoo pasek i Hésus, guwaen da, “O Mistelu, kaen ka dé.” ");
INSERT INTO mta_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Guwaen i Hésus egsagbì, “Duen sa kaenen ku endà egketiigan yu duu.” ");
INSERT INTO mta_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Huenan di, egseigsaay da, guwaen da, “Enù di ya, duen kéen etaw mig-uwit kaenen diyà kenagdi?” ");
INSERT INTO mta_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Agulé guwaen i Hésus diyà kenagda, “Iya sa lagà kaenen ku sa kepangunut ku diyà sa uyot sa migpeangay kenak dahini taman meubus sa galebek ibegay di diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Duen sa kagi yu, guwaen yu epat gebulan pa meuma sa keketu ta. Dodoo eg-ikagiyen ku ini i diyà keniyu, neuma dé sa agdaw keketu. Haa yu siini medoo etaw eg-angay dini enù ka lagà da sa palay melegà mebaluy dé kumetu. ");
INSERT INTO mta_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na sa etaw egketu, duen ma sa untung mesakem di diyà si Nemula danà di egtulù, owoy melalù ma taman melugay sa medoo etaw egketuwen di. Apiya di pa eghemula sa sebaen etaw owoy egketu sa liyu etaw, meanggan da doo langun. ");
INSERT INTO mta_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tuu sa guwaen etaw, ‘Eghemula sa sebaen etaw, dodoo sebaen ma etaw polo sa kumetu.’ ");
INSERT INTO mta_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na, peangayen ku kiyu peketu diyà sa tanà kenà yu endà mighemula. Dodoo, danà sa sebaen ma etaw migtulù kenagda, medoo sa etaw ketuwen yu anì mekeunut da sa kedatù i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na, duen medoo etaw tegeSamaliya migpigtuu dé diyà si Hésus danà sa inikagi sa bayi, guwaen di, “Tinulon di diyà kenak sa langun binaelan ku.” ");
INSERT INTO mta_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Huenan di, egoh sa medoo tegeSamaliya migtebow diyà si Hésus, tigtu da egpegeni diyà kenagdi anì mugpà diyà kenagda. Huenan di, eg-ugpà Hésus i dahiya taman duwa agdaw. ");
INSERT INTO mta_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Egoh di egtulù kenagda, neumanan pa sa kedoo etaw egpigtuu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Guwaen da diyà sa bayi, “Beken danà sa inikagi ko sa pesuwan ké migpigtuu, dodoo danà ké polo migdineg diyà kenagdi owoy netiigan ké ma tuu kagdi sa eg-aluk sa langun etaw denu sa salà da.” ");
INSERT INTO mta_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Na, egoh di neelut sa duwa agdaw, miglegkang Hésus i diyà Samaliya owoy lumagbas mangay Galiliya dò. ");
INSERT INTO mta_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iya sa tapay inikagi i Hésus, guwaen di, “Sumalà dé sa tegesugkow i Nemula, eg-ekedan sa medoo duma di amuk diyà sa tigtu menuwa di.” ");
INSERT INTO mta_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Dodoo egoh i Hésus migtebow Galiliya dò, egkeanggan polo sa medoo etaw tegeGaliliya owoy eg-adatan da ma kagdi i enù ka hinaa da sa langun binaelan di dutu Hélusalém dò egoh da miglenged sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Agulé, egpelikù dema Hésus i diyà sa menuwa Kana diyà uwang Galiliya. Iya sa menuwa kenà di migbael sa panduan diyà wayeg nebaluy wain. Na, diyà sa menuwa Kapelenaum, duen sa ulu-ulu sa tegetabang diyà sa sulutan, owoy duen sa anak di maama eglinadu. ");
INSERT INTO mta_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Egoh di migdineg sa ketebow i Hésus diyà Galiliya kedu Hudiya dò, mig-angay diyà si Hésus, owoy egpegeni anì mangay Kapelenaum dò anì bulungan di sa anak di enù ka buyu dé egkematay. ");
INSERT INTO mta_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Dodoo guwaen i Hésus diyà sa ulu-ulu, “Amuk endà duen sa mehaa yu egkegaipan etaw ataw ka panduan egbaelan ku, endà migtuu yu diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Agulé guwaen sa ulu-ulu, “O Datù, unut ka kenak anì endà mematay sa anak ku.” ");
INSERT INTO mta_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Guwaen i Hésus diyà kenagdi, “Likù ka dé enù ka nelikuan dé sa anak ko.” Hê, migpigtuu sa ulu-ulu sa inikagi i Hésus owoy mig-ipanaw ma dé. ");
INSERT INTO mta_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Egoh di eg-ipanaw pelà eglikù, nesesiegung da sa duma egsugùsuguen di diyà dalan, owoy guwaen da diyà kenagdi, “Nelikuan dé sa anak ko.” ");
INSERT INTO mta_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Agulé mig-igsà diyà kenagda, “Nengan di ya nelikuan sa anak ku?” Guwaen da egsagbì, “Egoh alas sebaen egoh neagdaw, nekedan dé sa keedup di.” ");
INSERT INTO mta_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Agulé, netulengan sa ulu-ulu iya sa tigtu ulas egoh i Hésus mig-ikagi nelikuan dé sa anak di. Huenan di, egpigtuu da dé diyà si Hésus sa ulu-ulu owoy sa langun malayan di. ");
INSERT INTO mta_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Na, iya sa keduwa panduan binaelan i Hésus. Binaelan di iya wé diyà uwang Galiliya egoh di migpelikù kedu diyà uwang Hudiya. ");
INSERT INTO mta_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Agulé, duen dema sa pista etaw Hudiyu, huenan di mig-angay Hésus i eglenged pista dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, duen sa linaw diyà Hélusalém medapag diyà sa bengawan kutà di kepengadan da Bengawan sa Kebilibili. Pinengadanan da linaw Bétsata diyà sa hagda kagi Hibelu owoy duen ma lima kemalig diyà sa kilidan di. ");
INSERT INTO mta_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na, duen medoo etaw eglinadu eg-ugpà diyà sa medoo kemalig dahiya. Duen langap, duen pikat, owoy duen egtodel. Eg-angat-angatan da sa egoh sa wayeg lumanglilis, ");
INSERT INTO mta_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","enù ka duen gaa sa egsugùsuguen i Nemula egpetuntun diyà sa linaw anì lumanglilis sa wayeg. Hê, melikuan sa etaw muna nekedalem diyà wayeg, sumalà dé sa linadu di. ");
INSERT INTO mta_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, duen sa maama dahiya eglinadu, telu pulù owoy walu gepalay dé sa lugay di eglinadu. ");
INSERT INTO mta_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Hinaa i Hésus kagdi eghibat dahiya, owoy netiigan di tigtu nelugay dé eglinadu. Agulé eg-igsà Hésus i, guwaen di, “O Akay, meiyap ka pa amuk melikuan ka?” ");
INSERT INTO mta_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Egsagbì sa eglinadu, guwaen di, “O Datù, amuk eglanglilis sa wayeg, endà duen sa duma ku dahini dumalem kenak diyà sa wayeg. Dumalem a hedem, dodoo nehunawan a polo sa sebaen ma etaw egdalem diyà wayeg.” ");
INSERT INTO mta_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Agulé guwaen i Hésus, “Enaw ka dé. Dilin ko sa ikam ko, owoy bigkat ka ma dé.” ");
INSERT INTO mta_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hê, nepetow dé nelikuan sa maama. Dinilin di sa ikam di, owoy nekebigkat ma dé. Na, Sapetu agdaw keetud da sa egoh di nelikuan. ");
INSERT INTO mta_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Huenan di, egbulitan sa medoo kaunutan Hudiyu sa maama nelikuan, guwaen da, “Migtipay ka dé sa uledin ta denu sa agdaw keetud, enù ka galebek iya wé keuwit ko ikam.” ");
INSERT INTO mta_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dodoo guwaen sa maama egsagbì, “Sa etaw migbulung kenak, igsugù di igpedilin sa ikam ku owoy pineipanaw di aken.” ");
INSERT INTO mta_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eg-igsaan da, guwaen da, “Ngadan di etaw sa migsugù keniko egpedilin sa ikam ko owoy egpeipanaw keniko?” ");
INSERT INTO mta_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Dodoo sa maama nelikuan, endà netiigan di duu ngadan di etaw sa migbulung kenagdi, enù ka medoo temù sa etaw egkesetipon dahiya owoy nekelawek Hésus i diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Agulé, hinaa i Hésus kagdi diyà sa Dalesan i Nemula, owoy guwaen di, “Taa ko, hih. Nelikuan ka dé. Na, sabuh ka dé egbael salà anì endà dé mekeuma sa tigtu medaet diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Agulé, mig-ipanaw sa etaw nelikuan owoy mig-angay egtulon diyà sa medoo kaunutan Hudiyu si Hésus sa migbulung kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Huenan di, edung egoh iya, egpelihayen da Hésus i, enù ka egbulitan da danà di migbulung sa etaw diyà Sapetu agdaw keetud da. ");
INSERT INTO mta_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Dodoo migsagbì Hésus i, guwaen di diyà kenagda, “Sa Emà ku Nemula, endà umetud di eggalebek apiya di pa Sapetu. Huenan di, takà a ma eggalebek.” ");
INSERT INTO mta_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Egoh da migdineg iya wé inikagi di, dakel temù sa kekelukuy da mimatay kenagdi. Egseolomoy da, guwaen da, “Beken iya daa sa tinipay di sa agdaw keetud ta, dodoo migtipay ma doo diyà si Nemula enù ka guwaen di si Nemula sa hagdi Emà. Amuk hediya, egtepengen di Nemula i.” ");
INSERT INTO mta_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Agulé, eg-ikagi Hésus i diyà sa medoo kaunutan Hudiyu, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Aken sa Anak i Nemula, huenan di endà duen sa egbaelan ku amuk naken daa penemdem. Iya daa sa egbaelan ku sa hinaa ku egbaelan i Emà. Sumalà dé sa egbaelan di, iya ma sa egbaelan ku. ");
INSERT INTO mta_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tigtu eghiduwan i Emà Nemula aken i Anak di, huenan di igpehaa di diyà kenak sa langun egbaelan di. Owoy ipebael di ma diyà kenak sa medoo panduan uman pa dakel diyà siini binaelan ku anì tigtu yu megaip langun. ");
INSERT INTO mta_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eg-enawen i Emà sa medoo etaw nematay owoy begayan di kagda lalù. Hediya ma sa egbaelan ku enù ka mebegayan ku ma lalù sa langun etaw eghemilien ku. ");
INSERT INTO mta_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Beken si Emà sa tumulon sa ketebowon sa langun etaw amuk mematay da, dodoo binegayan di aken egkegaga anì tumulon a sa ketebowon sa langun etaw, ");
INSERT INTO mta_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","enù ka ungayà di oloen a etaw, iling sa keolò da kenagdi. Sumalà dé sa etaw endà eg-olò di kenak, endà ma oloen di duu si Emà sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tuu ini i eg-ikagiyen ku diyà keniyu. Sa etaw egpangunut diyà sa kagi ku owoy egpigtuu ma diyà si Emà sa migpeangay kenak, iya sa etaw mekesakem sa lalù endà meelut di. Endà mepigtamayan di, enù ka lagà endà dé mematay di enù ka duen dé sa lalù di taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tuu ini i eg-ikagiyen ku diyà keniyu. Lagà nematay sa medoo etaw danà sa salà da. Dodoo edung ini egoh di, sumalà dé sa etaw dumineg sa kagi ku owoy egpigtuu diyà kenak, aken i Anak i Nemula, iya sa etaw mebegayan lalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Danà i Emà sa egpelalù etaw taman melugay, binegayan di ma aken egkegaga anì mekepelalù a etaw taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Owoy binegayan di ma aken egkegaga anì tumulon a sa ketebowon sa medoo etaw amuk mematay da, enù ka aken sa Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Yoko egkegaip duu siini eg-ikagiyen ku. Meuma pa kani sa agdaw egoh sa langun etaw nematay dumineg sa keumow ku kenagda, ");
INSERT INTO mta_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","owoy umenaw da langun. Meenaw sa medoo etaw migbael mepion anì melalù da taman melugay. Dodoo sa medoo etaw migbael salà, umenaw da anì mepigtamayan da uman taman melugay.” ");
INSERT INTO mta_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Guwaen i Hésus ma, “Endà duen sa egbaelan ku amuk naken daa egkegaga, dodoo eg-unutan ku polo sa uyot i Emà Nemula. Huenan di, meketulon a sa ketebowon sa langun etaw amuk mematay da, owoy tigtu metudà sa ketulon ku danà i Nemula migtulù kenak. Endà eg-unutan ku duu sa naken uyot daa, dodoo iya polo sa unutan ku sa uyot sa migpeangay kenak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Amuk aken daa sa tumulon keniyu denu kenak, endà metuuwan yu kéen diyà sa eg-ikagiyen ku. ");
INSERT INTO mta_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Dodoo duen doo sa sebaen ma egtulon denu sa egbaelan ku, owoy netiigan ku anan tuu sa kagi di denu kenak. ");
INSERT INTO mta_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Na, si Huwan Tegebautis sa pineangayan yu sa medoo etaw anì eg-igsà da denu kenak, kagdi ma sa migtulon sa tuu tegudon denu kenak. ");
INSERT INTO mta_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dodoo mebaluy amuk endà duen etaw diyà tanà daa egtulon denu kenak. Dodoo igpetulengtuleng ku keniyu sa tegudon i Huwan denu kenak anì migtuu yu anì mealukan yu. ");
INSERT INTO mta_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Na, lagà sa palitaan dakel legdaw Huwan i. Nelugaylugay yu neanggan danà yu nelegdawan sa legdaw di, enù ka netuuwan yu diyà sa tuu tegudon di. ");
INSERT INTO mta_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dodoo miglowon pa sa ketulon i Nemula denu kenak diyà sa ketulon i Huwan denu kenak, enù ka sa medoo panduan binaelan ku igpebael i Emà diyà kenak, iya sa tandà di aken sa pineangay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kagdi ma sa egpetiig denu kenak, dodoo endà egdinegen yu duu sa kagi di owoy endà ma eghauwen yu duu sa palas di. ");
INSERT INTO mta_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Owoy endà ma igtagù yu duu sa kagi di diyà sa pedu yu, enù ka endà egpigtuu yu diyà kenak apiya di pa aken sa pineangay di. ");
INSERT INTO mta_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Na, kiyu i etaw Hudiyu, takà yu eg-inau sa kagi i Nemula igpesulat, enù ka guwaen yu dò melalù yu taman melugay danà sa keinau yu. Apiya di pa tinulon iya wé kagi i Nemula sa denu kenak, tapay yu doo endà egpigtuu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ungayà ku hedem mangunut yu diyà kenak anì kumelalù yu taman melugay, dodoo eg-eked yu polo.” ");
INSERT INTO mta_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Guwaen i Hésus, “Na, beken iya sa ungayà ku egpeolòolò a diyà etaw, ");
INSERT INTO mta_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","enù ka netiigan ku doo kiyu owoy netiigan ku ma endà duen sa kehidu yu si Nemula diyà sa pedu yu. ");
INSERT INTO mta_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Apiya di pa pineangay i Emà aken anì tumulù a keniyu denu kenagdi, eg-eked yu doo egpigtuu diyà kenak. Dodoo netiigan ku amuk tumulù sa liyu etaw endà pineangay i Nemula, iya polo sa egpigtuuwen yu. ");
INSERT INTO mta_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Na, ini sa pesuwan di endà egpigtuu yu diyà kenak, enù ka egkeiyapan yu sa kepeolòolò yu diyà sa duma yu, dodoo endà meiyap yu sa keolò sa tigtu Nemula keniyu. ");
INSERT INTO mta_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Yoko egpenemdem duu aken sa tumipu keniyu diyà si Nemula. Dodoo si Mosis polo sa tumipu keniyu amuk meuma siedò agdaw, enù ka apiya di pa egpigtuu yu sa igtulù i Mosis anì melalù yu hedem, endà doo tigtu yu egpigtuu. Huenan di, mepigtamayan i Nemula kiyu. ");
INSERT INTO mta_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Amuk tigtu tuu daa sa kepigtuu yu diyà si Mosis, mekepigtuu yu ma diyà kenak enù ka igsulat di sa denu kenak. ");
INSERT INTO mta_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Dodoo amuk endà pigtuuwen yu duu sa kagi igsulat di egoh anay, endà ma pigtuuwen yu duu sa kagi ku.” ");
INSERT INTO mta_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Na sebaen agdaw, migkatin Hésus i tanà dutu sa Lanaw Galiliya, kepengadan da ma Lanaw Tibiliyas. ");
INSERT INTO mta_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Medoo temù sa etaw mig-unut kenagdi danà da mighaa sa medoo panduan binaelan di egoh di migbulung sa medoo etaw eglinadu. ");
INSERT INTO mta_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Agulé, egtekedeg Hésus i owoy sa medoo pasek di diyà sa mepokò getan, owoy migpenuu da dahiya. ");
INSERT INTO mta_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na egoh iya, buyu dé neuma sa pasad sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Agulé, egoh i Hésus mighaa sa medoo etaw egtekedeg eg-angay diyà kenagdi, eg-igsà diyà si Pilipi, guwaen di, “Kenà ta i kumuwa sa kaenen ipekaen ta diyà siini medoo etaw?” ");
INSERT INTO mta_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Na, iya sa igsà di anì tepengan di sa kepigtuu i Pilipi, dodoo tapay dé netiigan di sa baelan di. ");
INSERT INTO mta_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Migsagbì Pilipi i, guwaen di, “Apiya di pa sa nekuwa etaw eggalebek taman walu gebulan, tapay doo endà mekegaga di iya wé ibeli ta kaenen. Apiya tigtukééykééyen sa kepekaen ta kenagda, tapay doo kulang enù ka medoo da temù.” ");
INSERT INTO mta_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Agulé, eg-ikagi sa sebaen ma salu i Hésus, si Andelis hadi i Simon Pidelu, guwaen di, ");
INSERT INTO mta_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Duen sa batà maama dini mig-uwit sa legà di duwa sedà nelegà owoy lima getibulu tukééy epan. Dodoo tigtu endà mekegaga iya wé, enù ka medoo temù sa etaw egkesetipon.” ");
INSERT INTO mta_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Agulé guwaen i Hésus diyà kenagda, “Pepenuu yu sa medoo etaw.” Na, melabel sa keluwenluwen dahiya, huenan di migpenuu sa langun etaw. Duen kéen lima ngibu maama dahiya, liyu sa bayi owoy batà. ");
INSERT INTO mta_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Agulé, kinuwa i Hésus sa epan owoy migsimbà egpesalamat diyà si Nemula danà siedò kaenen igbegay i Nemula. Agulé igpetukidtukid di igpebegay diyà sa medoo etaw migpenuu dahiya. Hediya ma sa binaelan di diyà sa duwa sedà nelegà. Hê, nebesug da langun. ");
INSERT INTO mta_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Egoh da nebesug dé langun, guwaen i Hésus diyà sa medoo salu di, “Tipoh yu dé sa kaenen nesamà anì endà melemet di.” ");
INSERT INTO mta_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Na, egoh da migtipoh sa kaenen nesamà, duen sepulù owoy duwa pa gesolok nepenù sa epan nesamà endà neimet da duu egkaen diyà sa lima getibulu epan. ");
INSERT INTO mta_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Egoh sa medoo etaw mighaa siini panduan binaelan i Hésus, guwaen da, “Tigtu tuu kagdi sa tegesugkow i Nemula pineangay di diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Dodoo netiigan i Hésus sa ungayà da sabaan da kagdi anì tegelen da pedatù diyà kenagda. Huenan di, miglegkang dahiya owoy migtekedeg uman diyà sa getan anì eglebù, enù ka beken iya sa hagdi ungayà. ");
INSERT INTO mta_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na, egoh di mahapun dé, eglungel sa medoo salu i Hésus eg-angay da lanaw dò. ");
INSERT INTO mta_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mig-edà da kumpit anì mangay da Kapelenaum dò tanà dutu sa lanaw. Hê inut di sigep dé, dodoo endà pa egtebow Hésus i, huenan di eg-ipanaw da dé. ");
INSERT INTO mta_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hê, migkeleges polo sa kelamag owoy tigtu dakel ma dé sa lambeg. ");
INSERT INTO mta_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na, egoh da mig-owong lima kakilumitelu kéen kedu diyà sa mantadan, neteliwadaan da dé diyà lanaw. Agulé, hinaa da Hésus i egbigkat diyà kagpaꞌt wayeg eg-angay diyà kenagda. Hê, tigtu da nelimedangan. ");
INSERT INTO mta_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Dodoo guwaen i Hésus, “Yoko egkelimedangan na. Aken doo ini i.” ");
INSERT INTO mta_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Agulé, egkeanggan da dé owoy pineedà da Hésus i diyà kumpit. Hê, egoh di mig-edà, petow da dé nekedunggù diyà Kapelenaum sa eg-angayan da. ");
INSERT INTO mta_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Na, egoh di sumimag, dahiya pelà diyà mantadan sa medoo etaw sinalidan sa medoo salu i Hésus egoh da mig-edà kumpit. Netiigan da endà eg-unut Hésus i eg-edà kumpit, enù ka hinaa da sebaen daa sa kumpit inedaan sa salu di egoh neagdaw. ");
INSERT INTO mta_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Endà hinaa da Hésus i dahiya, dodoo duen duma kumpit kedu Tibiliyas dò migdunggù medapag diyà sa tanà kenà da migkaen sa epan egoh i Datù migpesalamat diyà si Nemula danà siedò epan. ");
INSERT INTO mta_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Agulé, egoh da neketiig endà dé dahiya Hésus i owoy sa medoo salu di, eg-edà da ma kumpit sa medoo etaw eg-angay Kapelenaum dò enù ka lagbeten da Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Agulé, egoh sa medoo etaw migtebow Kapelenaum dò, hinaa da Hésus i owoy guwaen da diyà kenagdi, “O Mistelu, nengan ko ya mig-angay dini?” ");
INSERT INTO mta_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Migsagbì Hésus i, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Endà netuuwan a keniyu enù ka sa kelagbet yu kenak beken danà yu egpeketiig sa selepangan sa panduan ku. Dodoo eglagbeten yu daa aken danà yu nebesug sa kaenen binaelan ku panduan egoh neagdaw. ");
INSERT INTO mta_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yoko egpedeles duu sa kaenen diyà tanà daa enù ka meledak kani. Dodoo pedeles yu polo sa kaenen egpelalù etaw taman melugay. Iya sa kaenen ibegay ku diyà keniyu, aken i Kakay Langun, enù ka tinandaan i Emà Nemula aken sa pineangay di.” ");
INSERT INTO mta_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Agulé, guwaen da diyà si Hésus, “Ngadan sa ukit baelan ké anì petuuwen ké sa uyot i Nemula?” ");
INSERT INTO mta_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Migsagbì Hésus i, guwaen di, “Iya sa uyot i Nemula diyà keniyu, pigtuu yu diyà sa maama pineangay di diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Eg-igsà da dema, guwaen da, “Ngadan sa panduan mebaelan ko ipehaa ko diyà kenami anì migtuu ké diyà keniko? Ngadan sa niko egbaelan? ");
INSERT INTO mta_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Egoh anay egoh sa medoo tupù ta mig-ukit diyà sa melabel tanà mediyù dalesan, kinaen da sa kaenen mana binaelan i Nemula, enù ka duen sa kagi i Nemula igpesulat, ‘Igbegay di diyà kenagda sa kaenen kedu langit dò.’ ” ");
INSERT INTO mta_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Beken si Mosis sa migbegay kaenen kedu langit dò, dodoo sa Emà ku polo sa egbegay keniyu sa tigtu kaenen kedu langit dò. ");
INSERT INTO mta_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Iya sa tigtu kaenen ibegay i Nemula sa kaenen egpetuntun kedu diyà langit sa egpelalù langun etaw diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Agulé guwaen da, “O Datù, begayi ko kami takà siini kaenen.” ");
INSERT INTO mta_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Guwaen i Hésus, “Aken sa kaenen egpelalù etaw. Endà dé meketues sa etaw eg-angay egsalig diyà kenak owoy endà dé lumupahan sa etaw egpigtuu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Dodoo tinulonon ku kiyu giina, guwaen ku, ‘Apiya di pa eghauwen yu dé aken, tapay yu doo endà egpigtuu.’ ");
INSERT INTO mta_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Na, sa langun etaw igbegay i Emà diyà kenak, mangay da migtuu diyà kenak, owoy endà ma ekedan ku duu sa etaw eg-angay diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iya maen di ya migpetuntun a kedu diyà langit anì umunut a sa ungayà sa migpeangay kenak. Beken naken daa ungayà sa eg-unutan ku. ");
INSERT INTO mta_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ini sa ungayà sa migpeangay kenak, endà duen sebaen etaw lengaan ku diyà sa langun etaw igbegay di diyà kenak, owoy enawen ku kagda langun amuk meuma sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ini sa ungayà sa Emà ku, mebegayan da lalù taman melugay sa langun etaw egpeketiig kenak owoy egpigtuu ma diyà kenak, aken i Anak i Nemula, owoy enawen ku ma kagda amuk meuma sa sabuhanan agdaw.” ");
INSERT INTO mta_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Na, nelangget sa pedu sa medoo Hudiyu owoy egsigbolowen da Hésus i danà sa kagi di guwaen di, “Aken sa kaenen migpetuntun kedu langit dò.” ");
INSERT INTO mta_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Egseolomoy da, guwaen da, “Siini maama si Hésus anak i Hosé. Kinilala ta sa emà di owoy sa inay di. Enù kebaluy sa inikagi di migpetuntun gaa kedu langit dò?” ");
INSERT INTO mta_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Agulé migsagbì Hésus i, guwaen di, “Yoko egkelangget ta egsigbolow denu kenak. ");
INSERT INTO mta_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Endà duen etaw mekeunut diyà kenak amuk beken si Emà migpeangay kenak sa atung umagak kenagdi, owoy iya sa etaw enawen ku amuk meuma sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Iya sa igsulat sa tegesugkow i Nemula egoh anay, guwaen di, ‘Metulù sa langun etaw danà i Nemula.’ Na, taa yu, hih. Uman sebaen etaw duminegdineg diyà si Emà owoy meketiig ma sa igtulù di, iya sa etaw mekeunut diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Dodoo yoko egpenemdem duu duen etaw nekehaa si Emà, enù ka endà duen etaw mighaa kenagdi liyu daa aken i kedu diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa etaw egpigtuu diyà kenak, dumuen lalù di endà meelut di. ");
INSERT INTO mta_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Aken sa kaenen mekepelalù etaw. ");
INSERT INTO mta_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Apiya di pa kinaen sa tupù ta sa kaenen mana egoh anay egoh da mig-ukit diyà sa melabel tanà mediyù dalesan, nematay da doo. ");
INSERT INTO mta_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Dodoo siini kaenen migpetuntun kedu langit dò, sumalà dé sa etaw kumaen iya wé, endà dé mekesugsug sa suguy di. ");
INSERT INTO mta_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aken sa kaenen melalù migpetuntun kedu langit dò. Amuk kumaen sa etaw siini kaenen, endà dé meelut sa lalù di. Iya sa kaenen ibegay ku anì kumelalù sa langun etaw diyà tanà, sa ekud ku.” ");
INSERT INTO mta_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Na, egoh da migdineg iya wé inikagi di, egsesigbolowoy da temù sa medoo Hudiyu, guwaen da, “Enù kebaluy siini maama ibegay di sa ekud di ipekaen di kenita?” ");
INSERT INTO mta_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Dodoo guwaen i Hésus diyà kenagda, “Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk endà kumaen yu sa ekud ku owoy amuk endà uminem yu sa depanug ku, endà dumuen sa lalù diyà keniyu. Aken sa Kakay Langun, ");
INSERT INTO mta_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","owoy sumalà dé sa etaw egkaen sa ekud ku owoy eg-inem sa depanug ku, iya sa mebegayan lalù endà meelut di owoy enawen ku kagdi diyà sa sabuhanan agdaw. ");
INSERT INTO mta_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iya maen di ya enù ka sa ekud ku sa tigtu kaenen, owoy sa depanug ku sa tigtu eg-inemen. ");
INSERT INTO mta_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Amuk egkaen sa etaw sa ekud ku owoy eg-inem sa depanug ku, iya sa etaw eg-ugpà diyà kenak owoy diyà a ma kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tigtu melalù si Emà sa migpeangay kenak diyà tanà, owoy melalù a ma danà di. Diya ma sa etaw egkaen kenak, melalù da ma danà ku. ");
INSERT INTO mta_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aken sa tigtu kaenen migpetuntun kedu langit dò. Beken lagà di sa kaenen igbegay i Nemula kinaen sa tupù ta egoh anay, enù ka apiya di pa kinaen da iya wé, nematay da doo. Dodoo sa etaw kumaen siini kaenen, endà dé meelut sa lalù di.” ");
INSERT INTO mta_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na, iya sa inikagi i Hésus egoh di egtulù diyà sa simbaan Hudiyu diyà menuwa Kapelenaum. ");
INSERT INTO mta_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na, egoh sa medoo pasek di egdineg iya wé inikagi i Hésus, guwaen da, “Melikut iya wé inikagi di. Endà meketiig ki dumineg iya wé.” ");
INSERT INTO mta_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Apiya endà tinulonon di etaw, tapay doo netiigan i Hésus egkebogo sa pedu da danà sa igtulù di. Agulé guwaen di diyà kenagda, “Enù di ya, egkealang pa sa kepigtuu yu danà siini inikagi ku? ");
INSERT INTO mta_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Enù di ya, amuk hauwen yu aken i Kakay Langun mebatun dutu siedò tapay kenà ku, ketiigan yu pa sa inikagi ku ataw ka endà? ");
INSERT INTO mta_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Taa yu, hih. Iya daa sa egpelalù etaw sa Suguy i Nemula. Endà duen egkegaga sa ekud ku diyà sa lalù etaw. Dodoo, sa inikagi ku diyà keniyu, iya sa kagi sa Suguy i Nemula owoy sa mekepelalù etaw. ");
INSERT INTO mta_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Dodoo duen duma etaw diyà keniyu endà doo migtuu da.” Na, iya sa inikagi i Hésus enù ka tapay dé netiigan di sa medoo etaw endà egpigtuu owoy netiigan di ma sa tumampil diyà sa kuntelà di. ");
INSERT INTO mta_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Agulé guwaen i Hésus, “Iya maen di ya tinulonon ku kiyu endà duen etaw mekeunut diyà kenak amuk beken si Emà sa pepigtuu kenagda.” ");
INSERT INTO mta_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na, danà iya wé inikagi i Hésus, miglikù sa medoo pasek di owoy endà dé eg-unut-unut da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Huenan di, guwaen i Hésus diyà sa sepulù owoy duwa tigtu pasek di, “Enù di ya kiyu i, lumikù yu ma?” ");
INSERT INTO mta_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Migsagbì Simon Pidelu i, guwaen di, “O Datù, amuk tumangkà ké diyà keniko, ngadan di etaw polo sa angayan ké petulù? Kuna daa sa kenà ké egdineg sa medoo kagi egpelalù etaw taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Egpigtuu ké dé diyà keniko, owoy netiigan ké ma kuna sa Maama Metiengaw pineangay i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Agulé guwaen i Hésus, “Apiya di pa aken sa mighemilì keniyu sepulù yu owoy duwa salu ku, duen doo sebaen etaw i Satanas diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Na, iya sa etaw inikagi di si Hudas anak i Simon Iskaliyot. Apiya di pa kagdi sa sebaen maama diyà sa sepulù owoy duwa salu i Hésus, tumampil doo diyà sa medoo kuntelà i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Agulé, egtukiden i Hésus sa medoo menuwa diyà uwang Galiliya. Meked mangay uwang Hudiya dò, enù ka duen medoo kaunutan Hudiyu egkelukuyan da eg-imatay. ");
INSERT INTO mta_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Na, buyu dé neuma sa pasad sa pista etaw Hudiyu kepengadan da Pista Lawì. ");
INSERT INTO mta_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Agulé, eg-ikagi sa medoo hadi i Hésus diyà kenagdi, guwaen da, “Mepion amuk lumegkang ka dini owoy lumenged ka sa pista dutu Hudiya dò anì hauwen sa medoo pasek ko sa medoo panduan egbaelan ko. ");
INSERT INTO mta_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Enù ka amuk ungayà sa etaw lumalag, endà mebaluy di ilidung di sa medoo panduan egbaelan di. Na, amuk duen panduan mebaelan ko, mepion amuk ipehaa ko diyà sa langun etaw diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na, iya sa inikagi da enù ka apiya di pa hadi i Hésus kagda, endà doo egpigtuu da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Agulé guwaen i Hésus diyà kenagda, “Endà pa egkeuma sa pasad ku mangay dutu. Dodoo kiyu, mepion doo sa keipanaw yu sumalà dé sa agdaw di. ");
INSERT INTO mta_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Endà duen sa maen yu egkelepuhan sa medoo etaw egkuntelà diyà si Nemula, dodoo aken polo sa egkelepuhan da danà ku takà egtulon diyà kenagda sa medaet egbaelan da. ");
INSERT INTO mta_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Huna yu dé angay pista dò. Endà pa mangay a dutu enù ka endà pa egkeuma sa pasad ku mangay dutu.” ");
INSERT INTO mta_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Na, egoh i Hésus neubus eg-ikagi iya wé, eg-ugpà daa diyà Galiliya. ");
INSERT INTO mta_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Na, egoh sa medoo hadi di mig-angay da dé eglenged sa pista diyà Hélusalém, eg-angay ma Hésus i dutu, dodoo linidung di sa keipanaw di enù ka ungayà di endà duen etaw meketiig. ");
INSERT INTO mta_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na, eglagbeten sa medoo kaunutan Hudiyu Hésus i diyà sa pista diyà Hélusalém. Egseigsaay da, guwaen da, “Kenà di kéé ini egoh?” ");
INSERT INTO mta_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Medoo temù sa etaw eglenged sa pista, owoy egsesigbolowoy da denu si Hésus. Duen duma etaw, guwaen da, “Mepion etaw kagdi ya.” Owoy duen ma etaw, guwaen da, “Endà, enù ka eg-akalan di sa medoo etaw danà sa ketulù di.” ");
INSERT INTO mta_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Dodoo egsebadàbadaay da daa eg-ikagi denu kenagdi, enù ka egkelimedangan da sa medoo kaunutan Hudiyu egbulit kenagda. ");
INSERT INTO mta_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na, egoh di egketeliwadaan sa pista, mig-angay Hésus i diyà sa Dalesan i Nemula owoy eg-edung egtulù diyà sa medoo etaw nesetipon dahiya. ");
INSERT INTO mta_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Egoh di egtulù, tigtu negaip sa medoo kaunutan Hudiyu, owoy guwaen da, “Keduwan di ya sa hagdi melabel penemdem, enù ka endà migpetulù di diyà sa medoo ulu-ulu simbaan?” ");
INSERT INTO mta_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Egsagbian i Hésus kagda, guwaen di, “Beken naken penemdem daa ini i igtulù ku, dodoo danà polo i Nemula migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Sumalà dé sa etaw mangunut diyà sa uyot i Nemula, iya sa etaw meketiig sa keduwan sa itulù ku, iling ka kedu si Nemula ataw ka naken penemdem daa. ");
INSERT INTO mta_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Enù ka amuk duen etaw egtulù sa hagdi penemdem daa, iya daa sa ungayà di egpeolòolò diyà etaw. Dodoo amuk egtulù sa etaw anì meolò Nemula i sa migpeangay kenagdi, kesaligan polo sa langun igtulù di enù ka endà egbutbut di. ");
INSERT INTO mta_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Apiya di pa igsugkow i Mosis sa uledin i Nemula diyà keniyu egoh anay, endà doo duen etaw diyà keniyu egpangunut diyà sa uledin di. Maen di ya egkelukuyan yu aken eg-imatay?” ");
INSERT INTO mta_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Hê, egsagbì sa medoo etaw, guwaen da, “Egkelengleng ka dé danà ko linahuk busaw. Endà duen etaw egpenemdem eg-imatay keniko.” ");
INSERT INTO mta_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Agulé guwaen i Hésus, “Egoh dini duen sebaen panduan binaelan ku, dodoo negaip yu langun enù ka agdaw keetud egoh iya. ");
INSERT INTO mta_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dodoo kiyu, eggalebek yu ma diyà sa agdaw keetud enù ka apiya di pa agdaw keetud, egpekelaing yu doo ipat sa anak yu maama anì mekepangunut yu sa uledin igsugkow i Mosis denu sa kepekelaing ipat. Na, beken kedu si Mosis daa siini adat kepekelaing ipat, enù ka iya sa adat sa medoo tupù ta egoh anay egoh i Mosis endà pa duen. ");
INSERT INTO mta_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na, amuk egpekelaingen yu sa ipat da diyà sa agdaw keetud anì endà tipayen yu duu sa uledin igsugkow i Mosis, maen di ya egbulitan yu aken danà ku migbulung sa langun lawa etaw diyà sa agdaw keetud? ");
INSERT INTO mta_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Yoko egsigbolow duu sa egbaelan etaw danà sa eghauwen yu daa, dodoo penemdem yu polo sa egbaelan di anì metiigan yu sa ketuu di.” ");
INSERT INTO mta_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na, duen duma etaw tegeHélusalém egseolomen da sa denu si Hésus, guwaen da, “Enù di ya, kagdi kéen sa etaw eglagbeten sa medoo kaunutan ta anì imatayan da? ");
INSERT INTO mta_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Taa yu, hih. Takà egtulù diyà sa kenà etaw egkesetipon, dodoo endà duen etaw eghawid kenagdi. Enù di ya, netiigan sa medoo kaunutan ta kéé kagdi si Kelistu sa Tigtu Datù sinugù i Nemula? ");
INSERT INTO mta_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Dodoo beken kagdi kéen iya wé enù ka amuk tumebow sa Tigtu Datù peangayen i Nemula, endà duen etaw meketiig sa keduwan di. Dodoo siini etaw, netiigan ta doo langun sa keduwan di.” ");
INSERT INTO mta_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Egoh i Hésus egtulù diyà sa Dalesan i Nemula, pinetaled di sa kagi di, guwaen di, “Guwaen yu dò egketiigan yu aken owoy sa keduwan ku, dodoo endà metiigan yu duu. Endà mig-angay a dini danà sa naken ungayà daa, dodoo pineangay a polo dini. Kesaligan sa migpeangay kenak, dodoo kiyu, endà metiigan yu duu kagdi ya. ");
INSERT INTO mta_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Dodoo egketiigan ku doo enù ka kagdi sa keduwan ku owoy kagdi ma sa migpeangay kenak.” ");
INSERT INTO mta_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hê, egoh di mig-ikagi iya wé, duen etaw egkelukuy egsigkem kenagdi, dodoo endà pa egkesabaan da duu enù ka endà pa neuma sa agdaw hinemilì i Nemula egoh di mesigkem. ");
INSERT INTO mta_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dodoo duen dé medoo etaw egpigtuu diyà kenagdi, owoy guwaen da, “Kagdi doo sa Tigtu Datù sinugù i Nemula, enù ka endà duen etaw mekelowon diyà siini etaw egbael panduan.” ");
INSERT INTO mta_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Na, dinineg sa medoo Palasiyu sa medoo etaw egseolomoy denu si Hésus. Agulé, neseunut sa pedu da owoy sa medoo ulu-ulu tegesimbà, owoy sinugù da sa medoo tegebantay Dalesan i Nemula anì sigkemen da Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Agulé guwaen i Hésus diyà sa medoo etaw nesetipon, “Endà dé iseg a melugay mugpà diyà keniyu, enù ka lumikù a diyà sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Apiya di pa lagbeten yu aken, endà hauwen yu duu, enù ka endà ma mekeangay yu diyà sa kenà ku mekeugpà.” ");
INSERT INTO mta_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Egoh sa medoo kaunutan Hudiyu migdineg iya wé, egseigsaay da, guwaen da, “Ngadan sa angayan di endà hauwen ta duu gaa? Enù di ya, mangay kéé dutu siedò kenà medoo etaw Hudiyu eg-ugpà diyà sa menuwa etaw beken Hudiyu anì tuluen di ma sa medoo etaw beken Hudiyu? ");
INSERT INTO mta_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ngadan sa selepangan sa inikagi di endà hauwen ta duu gaa apiya di pa lagbeten ta? Maen di ya guwaen di endà mekeangay ki gaa diyà sa kenà di mekeugpà?” ");
INSERT INTO mta_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na, iya sa tigtu mapulù agdaw diyà sa pista da sa sabuhanan agdaw di. Egoh iya, migtigdeg Hésus i owoy pinetaled di sa kagi di, guwaen di, “Amuk eglupahan yu, angay yu diyà kenak anì peinemen ku kiyu. ");
INSERT INTO mta_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Enù ka iya sa kagi i Nemula igpesulat, guwaen di, ‘Amuk duen etaw egpigtuu diyà kenak, egbuwalbuwal diyà sa pedu di sa wayeg egpelalù kenagdi taman melugay.’” ");
INSERT INTO mta_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Na, iya sa selepangan sa wayeg egpelalù etaw inikagi i Hésus sa Metiengaw Suguy i Nemula sakemen sa langun etaw egpigtuu diyà kenagdi. Dodoo egoh i Hésus mig-ikagi iya wé, endà pa egkesakem da duu sa Suguy i Nemula enù ka endà pa nebatun Hésus i dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Na, egoh da migdineg iya wé inikagi i Hésus, duen etaw eg-ikagi, guwaen da, “Kagdi sa tigtu Tegesugkow i Nemula eg-angat-angatan ta.” ");
INSERT INTO mta_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Duen ma etaw eg-ikagi, guwaen da, “Kagdi si Kelistu sa Tigtu Datù sinugù i Nemula.” Dodoo guwaen sa liyu etaw, “Beken kagdi sa eg-angat-angatan ta, enù ka endà mebaluy di etaw tegeGaliliya sa Tigtu Datù sinugù i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Enù ka duen sa kagi i Nemula igpesulat, guwaen di, Tugod i Datù Dabid sa Tigtu Datù sinugù i Nemula, owoy lumesut dutu Bétlihém dò enù ka iya sa tapay menuwa i Dabid egoh anay.” ");
INSERT INTO mta_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Na, nesetigesa sa penemdem sa medoo etaw denu si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Duen ma etaw ungayà da sigkemen da hedem, dodoo endà egkesabaan da duu. ");
INSERT INTO mta_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na, egoh sa medoo tegebantay Dalesan i Nemula migpelikù da diyà sa etaw migsugù kenagda, eg-igsaan sa medoo Palasiyu owoy sa medoo ulu-ulu tegesimbà kagda, guwaen da, “Kenà di dé? Maen di ya endà inuwit yu duu?” ");
INSERT INTO mta_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Migsagbì sa medoo tegebantay, guwaen da, “Enù ka endà duen sa liyu etaw egtegudon iling sa hagdi ketegudon.” ");
INSERT INTO mta_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Agulé guwaen sa medoo Palasiyu diyà kenagda, “Enù di ya, neakalan yu ma dé danà di? ");
INSERT INTO mta_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Dodoo kami, endà neakalan ké diyà kenagdi, enù ka endà duen sa kaunutan etaw Hudiyu egpigtuu diyà kenagdi. Owoy endà ma duen sa duma ké etaw Palasiyu egpigtuu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dodoo siini medoo liyu etaw, endà netiigan da duu sa kagi i Nemula igsugkow i Mosis egoh anay. Huenan di, pigtamayan i Nemula kagda taman melugay.” ");
INSERT INTO mta_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Dahiya ma Nikodimu i, enù ka kagdi ma sa etaw Palasiyu, owoy iya sa mig-angay eg-igsà diyà si Hésus egoh anay. Eg-ikagi Nikodimu i diyà sa medoo duma di Palasiyu, guwaen di, ");
INSERT INTO mta_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Endà mebaluy di diyà sa uledin ta igsugkow i Mosis amuk pigtamayan sa etaw amuk endà pa neigsaan ta duu denu sa binaelan di anì metiigan ta sa salà di.” ");
INSERT INTO mta_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Dodoo egsagbian sa medoo duma di, guwaen da, “Kuna ma kéen sa etaw tegeGaliliya lagà kagdi. Maen di ya egkeiyap ka tumabang kenagdi? Inauwi ko polo sa kagi i Nemula igpesulat anì metiigan ko tigtu endà duen sebaen tegesugkow i Nemula tumebow kedu Galiliya dò.” ");
INSERT INTO mta_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Agulé, miglikù sa uman sebaen etaw diyà sa hagdi dalesan. ");
INSERT INTO mta_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Dodoo eg-angay Hésus i diyà Getan Olibu. ");
INSERT INTO mta_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Egoh di sumimag, migpelikù Hésus i mig-angay diyà sa Dalesan i Nemula. Agulé, egoh sa langun etaw nesetipon diyà kenagdi, migpenuu owoy eg-edung egtulù kenagda. ");
INSERT INTO mta_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Egoh di telibubu egtulù, migtebow sa medoo Palasiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. Eg-uwiten da diyà si Hésus sa bayi hinaa etaw migbigà. Pinetigdeg da kagdi teliwadà sa medoo etaw, ");
INSERT INTO mta_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","owoy guwaen da diyà si Hésus, “O Mistelu, hinaa etaw siini bayi egoh di migbigà giina. ");
INSERT INTO mta_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Duen sa uledin igsugkow i Mosis egoh anay, guwaen di, ‘Buungen batu sa etaw egbigà anì mematay.’ Na, ngadan sa niko penemdem denu kenagdi?” ");
INSERT INTO mta_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na, eg-igsaan da Hésus i enù ka ungayà da begayan da kagdi salà amuk tipayen di sa uledin igsugkow i Mosis. Dodoo egkudung Hésus i owoy igsulat di sa ketudù di diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Dodoo takaan da kagdi eg-igsà. Agulé, egpetudà dema egpenuu Hésus i owoy guwaen di diyà kenagda, “Sumalà dé sa etaw diyà keniyu endà duen salà di, mepion amuk kagdi sa muna muung batu.” ");
INSERT INTO mta_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hê, egkudung dema Hésus i owoy egsulat dema diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Egoh sa medoo Palasiyu owoy sa medoo tegetulù migdineg sa sagbì i Hésus, egkeseinut-inut da langun eglikù, dodoo iya muna miglikù sa medoo lukes. Hê, iya daen sa nesamà si Hésus owoy sa bayi egtigdeg dahiya. ");
INSERT INTO mta_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Agulé, egpetudà dema egpenuu Hésus i owoy guwaen di diyà sa bayi, “O Okon, kenà sa medoo etaw migtipu keniko? Duen pa etaw egbegay salà diyà keniko?” ");
INSERT INTO mta_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Egsagbì sa bayi, “O Datù, endà dé duen di.” Agulé guwaen i Hésus, “Endà ma megay a salà diyà keniko. Likù ka dé, owoy yaka dé eg-uman na egbael salà.” ");
INSERT INTO mta_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Na, egtulù dema Hésus i diyà sa medoo etaw nesetipon, guwaen di, “Aken sa legdaw egsenang diyà sa pedu sa langun etaw diyà tanà. Amuk eg-unut sa etaw diyà kenak, endà duen deleman diyà sa pedu di, enù ka melegdawan polo danà sa legdaw egpelalù etaw taman melugay.” ");
INSERT INTO mta_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Egoh sa medoo Palasiyu migdineg sa inikagi di, guwaen da, “Kuna mendaa sa migtulon denu keniko diyà kenami. Huenan di, endà egketuuwan ké diyà sa inikagi ko.” ");
INSERT INTO mta_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Migsagbì Hésus i, guwaen di, “Apiya di pa aken daa sa migtulon diyà keniyu denu kenak, tuu doo sa inikagi ku, enù ka netiigan ku sa keduwan ku owoy sa angayan ku ma. Dodoo kiyu, endà netiigan yu duu sa keduwan ku ataw ka sa angayan ku. ");
INSERT INTO mta_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amuk sumigbolow yu diyà etaw, danà sa niyu daa penemdem sa kesigbolow yu. Dodoo aken, beken iya sa pesuwan ku mig-angay diyà tanà anì sumigbolow a diyà etaw. ");
INSERT INTO mta_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Dodoo amuk sumigbolow a, tigtu tuu sa kesigbolow ku enù ka beken danà sa naken daa penemdem, dodoo duwa ké si Emà migpeangay kenak sa sumigbolow. ");
INSERT INTO mta_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na, duen uledin igsugkow i Mosis eg-unutan yu, guwaen di, ‘Amuk neseunut sa kagi sa duwa etaw, tuu doo sa kagi da.’ ");
INSERT INTO mta_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Huenan di, tigtu tuu sa kagi ku, enù ka egtulonen ku sa denu kenak diyà keniyu, owoy si Emà sa migpeangay kenak, kagdi ma sa egtulon sa denu kenak.” ");
INSERT INTO mta_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Agulé, eg-igsaan sa medoo Palasiyu, guwaen da, “Kenà emà ko ya atu?” Egsagbì Hésus i, guwaen di, “Endà egketiigan yu duu aken, huenan di endà ma egketiigan yu duu sa Emà ku. Amuk metiigan yu aken, metiigan yu ma doo sa Emà ku.” ");
INSERT INTO mta_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Na, iya sa kagi i Hésus egoh di egtulù kenagda diyà sa Dalesan i Nemula diyà sa bilik kenà sa taguan pilak ibegay etaw diyà si Nemula. Dodoo endà duen etaw mekesigkem kenagdi, enù ka endà pa neuma sa pasad hinemilì i Nemula egoh da mekesigkem kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Agulé, eg-ikagi dema Hésus i diyà kenagda, guwaen di, “Buyu a dé sumalid diyà keniyu. Apiya di pa lagbeten yu aken, mematay yu doo danà sa medoo salà yu, owoy endà ma mekeuma yu diyà sa angayan ku.” ");
INSERT INTO mta_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huenan di, egseigsaay sa medoo kaunutan Hudiyu, guwaen da, “Ngadan sa selepangan sa inikagi di endà mekeuma ki gaa diyà sa angayan di? Enù di ya, petoyò kéen?” ");
INSERT INTO mta_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Agulé guwaen i Hésus, “Kiyu sa etaw eg-ugpà diyà tanà daa, owoy iya daa sa niyu penemdemen sa medoo eghauwen yu diyà tanà. Dodoo aken, kedu a langit polo, huenan di egtulonen ku sa langun eghauwen ma diyà langit. ");
INSERT INTO mta_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iya maen di inikagi ku mematay yu danà sa medoo salà yu, enù ka endà mekepeuloy sa salà yu amuk endà pigtuuwen yu duu sa langun tinulon ku denu kenak.” ");
INSERT INTO mta_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Agulé eg-igsà da, guwaen da, “Ngadan ko ya etaw kuna ya?” Egsagbì Hésus i, guwaen di, “Aken sa tinulon ku diyà keniyu edung sa egoh ku anay egtulù. ");
INSERT INTO mta_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Duen pa sa medoo ikagiyen ku denu keniyu anì metiigan yu medaet sa egbaelan yu. Dodoo, iya daa sa itulù ku diyà sa langun etaw diyà tanà sa medoo dinineg ku diyà sa migpeangay kenak, enù ka anan tuu sa kagi di.” ");
INSERT INTO mta_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Dodoo tapay doo endà egketiigan da duu iya sa inikagi i Hésus si Nemula sa Emà di. ");
INSERT INTO mta_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Huenan di, eg-ikagi dema Hésus i diyà kenagda, guwaen di, “Amuk meuma sa egoh yu tumutuk kenak diyà sa kayu ibugsud, aken i Kakay Langun, metiigan yu doo tuu sa langun tinulon ku denu kenak. Owoy metiigan yu ma doo endà duen sa sebaen egbaelan ku danà sa naken daa penemdem, dodoo iya daa sa eg-ikagiyen ku, sa igtulù sa Emà ku diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Takà ké egkeseunut sa migpeangay kenak. Endà salidan di aken, enù ka takà a egbael sa uyot di.” ");
INSERT INTO mta_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Egoh da migdineg iya wé inikagi di, medoo dé sa etaw migpigtuu diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Agulé, eg-ikagi Hésus i diyà sa medoo Hudiyu egpigtuu diyà kenagdi, guwaen di, “Amuk takà yu mangunut diyà sa itulù ku, tigtu egpepasek yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Amuk hediya, metiigan yu sa tuu tegudon, owoy mekelaun yu ma dé danà sa tuu tegudon.” ");
INSERT INTO mta_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Egsagbì da, guwaen da, “Kami sa tugod i Ablaham owoy endà inudipen ké etaw kami i. Maen di ya iya sa inikagi ko mekelaun ké dé?” ");
INSERT INTO mta_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Sa etaw egbael salà, iya sa etaw neudipen danà sa salà di enù ka endà nekegaga di egbael mepion. ");
INSERT INTO mta_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Amuk udipen, endà eg-ugpà di diyà sa dalesan sa épê di taman melugay, enù ka mebaluy mehemagawan. Dodoo sa anak etaw, endà mehemagawan di duu, enù ka mebaluy takà mugpà diyà sa kenà emà di. ");
INSERT INTO mta_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Huenan di, amuk aken sa egpelaun keniyu kedu diyà salà yu, aken i Anak i Nemula, tigtu tuu nekelaun yu dé. ");
INSERT INTO mta_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Netiigan ku kiyu sa tugod i Ablaham, dodoo tigesa polo sa niyu pedu diyà sa hagdi, enù ka ungayà yu mimatay kenak danà yu endà egpigtuu diyà sa itulù ku. ");
INSERT INTO mta_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iya sa itulù ku sa igpehaa sa Emà ku diyà kenak. Dodoo kiyu, iya polo sa egbaelan yu sa tinulon sa emà yu keniyu.” ");
INSERT INTO mta_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Egsagbian da, guwaen da, “Si Ablaham sa lagà emà ké enù ka kami sa tugod di.” Dodoo guwaen i Hésus eg-ikagi, “Amuk tigtu tugod i Ablaham kiyu i, ilingan yu doo sa mepion binaelan di egoh anay. ");
INSERT INTO mta_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Dodoo apiya di pa tinulù ku kiyu sa tuu tegudon igpetiig i Nemula diyà kenak, egkelukuyan yu polo aken eg-imatay. Beken hediya sa binaelan i Ablaham. ");
INSERT INTO mta_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Dodoo eg-ilingan yu polo sa binaelan sa emà yu.” Agulé, egbulit da egsagbì, guwaen da, “Beken ké anak tanà, kami i. Sebaen daa sa Emà ké si Nemula, owoy kami sa tigtu anak di.” ");
INSERT INTO mta_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Guwaen i Hésus diyà kenagda, “Beken si Nemula sa Emà yu, enù ka amuk tuu si Nemula sa Emà yu, hiduwan yu doo aken, enù ka si Nemula sa keduwan ku egoh ku mig-angay dini. Beken danà sa naken egkegaga daa sa keangay ku dini, enù ka si Nemula polo sa migpeangay kenak dini. ");
INSERT INTO mta_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ini sa pesuwan di endà metiigan yu duu sa inikagi ku enù ka meked yu dumineg sa tegudon ku. ");
INSERT INTO mta_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas polo sa lagà emà yu, huenan di meiyap yu ma umunut sa medaet ungayà di. Edung egoh tanà binaelan taman ini egoh di, tegeimatay Satanas i, owoy endà ma eg-unutan di duu sa tuu tegudon enù ka endà duen sa tuu diyà kenagdi. Anan butbut sa langun eg-ikagiyen di enù ka hagdi adat iya wé. Kagdi sa tegebutbut owoy kagdi ma sa keduwan sa langun butbut. ");
INSERT INTO mta_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Dodoo anan tuu sa eg-ikagiyen ku diyà keniyu, huenan di endà migtuu yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Endà duen etaw diyà keniyu mekeikagi amuk duen salà ku, enù ka endà duen di. Apiya di pa tuu sa egtulonen ku, endà doo migtuu yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Amuk anak i Nemula sa etaw, migtuu doo diyà sa kagi i Nemula. Dodoo kiyu, endà egpigtuu yu diyà sa kagi di enù ka beken anak di kiyu ya.” ");
INSERT INTO mta_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Na, egoh sa medoo kaunutan Hudiyu migdineg iya wé inikagi i Hésus, guwaen da diyà kenagdi, “Tuu kéen sa inikagi ké kuna sa etaw tegeSamaliya egkelepuh kenami i etaw Hudiyu. Egkelengleng ka dé danà ko linahuk busaw.” ");
INSERT INTO mta_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Egsagbì Hésus i, guwaen di, “Endà linahuk a busaw. Eg-oloen ku daa Nemula i Emà ku. Gasama iya, egpeumàumaan yu polo aken. ");
INSERT INTO mta_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Beken iya sa ungayà ku egpeolòolò a diyà etaw. Dodoo si Nemula, iya sa ungayà di meolò a etaw, owoy ipetiig di tuu sa kagi ku. ");
INSERT INTO mta_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk egpigtuu sa etaw diyà sa itulù ku, endà dé mematay di taman melugay.” ");
INSERT INTO mta_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Eg-ikagi sa medoo kaunutan Hudiyu, guwaen da, “Na, netiigan ké dé tigtu ka linahuk busaw. Enù ka si Ablaham owoy sa medoo tegesugkow i Nemula egoh anay, anan da nematay. Dodoo kuna, iya sa kagi ko amuk egpigtuu sa etaw diyà sa igtulù ko, endà dé mematay di. ");
INSERT INTO mta_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Enù di ya, eglowon ka pa diyà sa tupù ta si Ablaham? Enù ka si Ablaham owoy sa medoo tegesugkow i Nemula egoh anay, anan da doo nematay. Ngadan ko ya etaw kuna ya?” ");
INSERT INTO mta_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Egsagbì Hésus i, guwaen di, “Amuk egpedakelen ku aken, endà duen ulan di iya wé. Dodoo iya polo sa egpedakel kenak si Nemula Emà ku. Guwaen yu dò kagdi sa Nemula egsaligan yu, ");
INSERT INTO mta_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","dodoo endà egketiigan yu duu kagdi i. Dodoo aken polo sa neketiig kenagdi. Upama, amuk guwaen ku endà netiigan ku duu kagdi, mekeiling a keniyu egbutbut. Dodoo netiigan ku doo kagdi ya owoy eg-unut a ma sa kagi di. ");
INSERT INTO mta_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na, sa tupù yu si Ablaham, ungayà di humaa sa agdaw egoh ku mangay diyà tanà. Hê, hinaa di dé, huenan di tigtu neanggan egoh di mighaa.” ");
INSERT INTO mta_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Agulé, eg-ikagi sa medoo kaunutan Hudiyu, guwaen da, “Endà pa nekeuma ka lima pulù gepalay. Gasama iya guwaen ko hinaa ko si Ablaham sa tupù ta.” ");
INSERT INTO mta_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Agulé guwaen i Hésus, “Tuu ini i eg-ikagiyen ku diyà keniyu. Egoh i Ablaham endà pa duen di diyà tanà, tapay a dé duen.” ");
INSERT INTO mta_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Egoh da migdineg iya wé inikagi i Hésus, eghudut da batu buungen da enù ka imatayan da hedem. Dodoo, eglidung Hésus i owoy eglaun kedu diyà sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na, egoh i Hésus eg-ipanaw, hinaa di sa maama langap inuwit di miglesut sa kinelangap di. ");
INSERT INTO mta_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Agulé, eg-igsà sa medoo salu i Hésus, guwaen da, “O Mistelu, maen di ya inuwit di miglesut sa kinelangap di? Ngadan tayu di etaw sa nesalà, kagdi ataw ka sa emà di owoy sa inay di?” ");
INSERT INTO mta_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Migsagbì Hésus i, guwaen di, “Beken danà sa hagdi salà sa kinelangap di, owoy beken ma danà sa salà sa lukes di. Dodoo nelangap polo anì mehaa sa tunung i Nemula diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Amuk agdaw pelawà, egbaelan ta doo sa galebek igsugù sa migpeangay kenak, enù ka endà dé duen etaw mekegalebek amuk sigep. ");
INSERT INTO mta_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Egoh ku eg-ugpà pelawà diyà tanà, aken sa legdaw egsenang diyà sa langun etaw enù ka itulù ku kenagda sa tuu tegudon.” ");
INSERT INTO mta_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Agulé, egoh i Hésus mig-ikagi iya wé, eg-ileb diyà tanà owoy kinuwa di sa tanà pinelê di ileb. Hê igdulét di diyà mata sa langap, ");
INSERT INTO mta_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","owoy guwaen di, “Angay ka diepug wayeg dò kepengadan Wayeg Siloyi.” Na, iya sa selepangan sa kagi Siloyi, sa Pineangay. Agulé, mig-angay sa langap egdiepug dutu. Hê egoh di eglikù, mig-ilag dé. ");
INSERT INTO mta_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Na, negaip sa medoo duma di owoy sa medoo etaw mighaa kenagdi migpegeni pilak egoh anay. Egseigsaay da, guwaen da, “Enù di ya, kagdi sa maama migpenuu owoy takà migpegeni pilak ataw ka beken?” ");
INSERT INTO mta_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Duen etaw egsagbì, guwaen da, “Tuu, kagdi doo sa takà migpegeni.” Dodoo duen ma etaw, guwaen da, “Beken kagdi iya wé. Nesetepeng daa sa palas da.” Dodoo guwaen sa maama, “Tuu, aken sa langap takà migpegeni pilak.” ");
INSERT INTO mta_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Agulé, eg-igsà sa medoo etaw diyà kenagdi, guwaen da, “Amuk kuna sa langap, maen di ya mig-ilag ka dé?” ");
INSERT INTO mta_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Guwaen di egsagbì, “Duen etaw pinengadanan da si Hésus mig-ileb diyà tanà migbael libutà igdulét di diyà sa mata ku, owoy pineangay di aken dutu wayeg Siloyi dò anì egdiepug a. Huenan di, mig-angay a dutu. Hê, egoh ku ubus egdiepug, mig-ilag a dé.” ");
INSERT INTO mta_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Eg-igsà da dema, guwaen da, “Kenà sa maama ini egoh di?” Egsagbì, guwaen di, “Endà netiigan ku duu sa inangayan di.” ");
INSERT INTO mta_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Agulé, inuwit da sa maama nelikuan langap diyà sa medoo Palasiyu. ");
INSERT INTO mta_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, iya sa agdaw egoh i Hésus migbael libutà igbulung di mata sa langap sa agdaw keetud etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Iya maen di ya inigsaan ma sa medoo Palasiyu sa ukit kepeilag di dema. Agulé, guwaen sa maama diyà kenagda, “Igdulét i Hésus sa libutà diyà sa mata ku. Agulé, mig-angay a egdiepug wayeg dò. Hê, mig-ilag a dé.” ");
INSERT INTO mta_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Agulé, duen duma Palasiyu eg-ikagi, guwaen da, “Siini etaw migbulung, beken kagdi sa pineangay i Nemula enù ka tinipay di sa uledin ta denu sa agdaw keetud.” Dodoo duen ma liyu etaw eg-ikagi, guwaen da, “Amuk kagdi sa etaw tegebael salà, endà mekebael di panduan iling sa binaelan di.” Hê, egsesigbolowoy da denu sa binaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Agulé, eg-igsà da dema diyà sa maama, guwaen da, “Ngadan sa niko penemdem denu kenagdi, enù ka guwaen ko eg-ilag ka dé danà di migbulung keniko?” Egsagbì sa maama, guwaen di, “Kagdi sa tegesugkow i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na, endà egpigtuu sa medoo kaunutan Hudiyu sa egoh di langap egoh anay owoy mig-ilag dé. Huenan di, igpeangay da sa emà di owoy sa inay di ");
INSERT INTO mta_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","owoy eg-igsaan da kagda, guwaen da, “Enù di ya, ini sa anak yu ataw ka beken? Tuu ataw ka endà inuwit di miglesut sa kinelangap di? Amuk hediya, maen di ya atu mig-ilag dé?” ");
INSERT INTO mta_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Migsagbì sa emà di owoy sa inay di, guwaen da, “Netiigan ké kagdi sa anak ké, owoy netiigan ké ma inuwit di miglesut sa kinelangap di. ");
INSERT INTO mta_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Dodoo endà netiigan ké duu sa pesuwan di mig-ilag dé. Endà ma netiigan ké duu sa etaw migbulung kenagdi. Dodoo mepion amuk kagdi polo sa igsaan yu, enù ka mipedu dé owoy mekesagbì ma denu sa kineilag di.” ");
INSERT INTO mta_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na, iya sa sagbì sa emà di owoy sa inay di enù ka nelimedangan da sa medoo ulu-ulu etaw Hudiyu, enù ka tapay dé nesesebaen sa penemdem da pigtamayan da sa etaw amuk guwaen di si Hésus sa Tigtu Datù pineangay i Nemula. Iya sa kepigtamay da endà dé peludepen da duu diyà sa simbaan da. ");
INSERT INTO mta_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iya maen di ya mig-ikagi sa emà di owoy sa inay di, guwaen da, “Mipedu dé. Mepion amuk kagdi polo sa igsaan yu.” ");
INSERT INTO mta_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Agulé, inumow sa medoo ulu-ulu dema sa maama nelikuan langap. Guwaen da diyà kenagdi, “Pengibet ka diyà si Nemula amuk tuu sa tulonen ko diyà kenami. Enù ka netiigan ké dé endà tuu di sa kagi ko egoh giina denu sa maama migpeilag keniko, enù ka netiigan ké kagdi sa tegebael salà.” ");
INSERT INTO mta_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Guwaen sa maama, “Endà egketiigan ku duu amuk tuu kagdi sa etaw tegebael salà ataw ka endà. Ini daa sa netiigan ku, egoh anay nelangap a, dodoo ini egoh eg-ilag a dé.” ");
INSERT INTO mta_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Agulé, eg-igsaan da dema, guwaen da, “Ngadan sa binaelan di diyà keniko? Enù di ya sa ukit kebulung di sa mata ko?” ");
INSERT INTO mta_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Migsagbì sa maama, guwaen di, “Tinulon ku dé iya wé diyà keniyu egoh giina, dodoo endà dinineg yu duu kéen. Maen di ya egkeiyapan yu egdineg dema? Enù di ya, ungayà yu pepasek yu diyà kagdi?” ");
INSERT INTO mta_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Egoh da migdineg iya wé, egbulit da owoy egpeumàumaan da, guwaen da, “Kuna sa hagdi pasek, dodoo kami polo sa pasek i Mosis sa tegesugkow i Nemula egoh anay. ");
INSERT INTO mta_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Enù ka netiigan ké doo si Nemula sa mig-ikagi diyà si Mosis egoh anay. Dodoo iya wé etaw, endà netiigan ké duu sa hagdi keduwan.” ");
INSERT INTO mta_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Agulé egsagbì sa maama, guwaen di, “Ay, tigtu a negaip keniyu. Enù ka endà netiigan yu duu sa keduwan siini etaw apiya di pa kagdi sa migpeilag sa mata ku. ");
INSERT INTO mta_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Netiigan ta doo endà dinegen i Nemula duu sa kesimbà sa etaw tegebael salà. Dodoo iya polo sa egdinegen di sa etaw eg-adat kenagdi owoy eg-unut diyà sa uyot di. ");
INSERT INTO mta_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Edung egoh tanà binaelan taman ini egoh di, endà duen etaw netiigan ta mekegaga mulung sa langap amuk inuwit di miglesut sa kinelangap di. ");
INSERT INTO mta_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Amuk beken kedu si Nemula siini etaw migbulung kenak, endà megaga di duu egbael panduan iling ini i binaelan di.” ");
INSERT INTO mta_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Guwaen da egsagbì, “Edung egoh ko miglesut taman ini egoh, kuna polo sa etaw tegebael salà. Huenan di, endà mekebaluy ka tumulù kenami.” Hê, hinemagawan da kagdi i kedu diyà sa Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na, egoh i Hésus migdineg denu sa kehemaga da sa maama nelikuan kedu diyà sa Dalesan i Nemula, inangay di kagdi eglagbet. Egoh di mighaa kenagdi, eg-igsà Hésus i, guwaen di, “Enù di ya, migtuu ka pa diyà sa Kakay Langun?” ");
INSERT INTO mta_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Agulé guwaen sa maama, “O Datù, ngadan di etaw sa Kakay Langun? Tuloni ko aken, hih, anì migtuu a diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Guwaen i Hésus diyà kenagdi, “Hinaa ko dé egoh giina, owoy kagdi ma sa eg-ikagi diyà keniko ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Agulé guwaen sa maama, “O Datù, egpigtuu a dé diyà keniko.” Hê, egligkued diyà sa taengan i Hésus enù ka egdatuen di. ");
INSERT INTO mta_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Agulé guwaen i Hésus, “Ini sa pesuwan di mig-angay a diyà tanà anì mehaa sa egbaelan sa langun etaw. Na, sa etaw lagà langap enù ka endà netiigan di duu sa tuu tegudon, iya sa etaw egtabangan ku anì umilag. Dodoo sa etaw guwaen da dò meilag da, iya polo sa etaw melangap enù ka endà egpigtuu da.” ");
INSERT INTO mta_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Duen ma etaw Palasiyu medapag diyà si Hésus. Egoh da migdineg iya wé, eg-igsà da, guwaen da, “Enù di ya kami i, langap ké ma?” ");
INSERT INTO mta_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Agulé guwaen i Hésus egsagbì, “Amuk langap yu danà yu endà neketiig sa tuu tegudon, endà duen sa salà yu. Dodoo guwaen yu dò eg-ilag yu owoy netiigan yu ma sa uyot i Nemula, huenan di tapay doo duen salà yu enù ka endà eg-unut yu diyà sa hagdi uyot.” ");
INSERT INTO mta_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Na, egtulon Hésus i peligad denu sa medoo etaw di owoy sa eg-ipat kenagda. Guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk duen etaw egludep diyà sa lugenan kebilibili, dodoo endà eg-ukit di diyà sa bengawan enù ka egtipay sa lesed lugenan, iya sa etaw tegepenakaw owoy tegelampas. ");
INSERT INTO mta_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Dodoo iya polo sa etaw tegeipat kebilibili sa etaw eg-ukit diyà bengawan. ");
INSERT INTO mta_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Amuk tumebow diyà lugenan, eg-ukaan sa tegebantay bengawan kagdi i. Agulé eg-umowen di sa ngadan sa hagdi kebilibili, owoy eg-unutan da ma kagdi mangay liyu dò enù ka nelayaman da sa kagi di eg-umow. ");
INSERT INTO mta_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Egoh di migpelaun sa medoo kebilibili di, eghunawan di kagda owoy egsetugdug da diyà kenagdi enù ka egkelayaman da sa kagi di. ");
INSERT INTO mta_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Dodoo endà eg-unutan da duu sa liyu etaw. Melaguy da polo kedu diyà kenagdi, enù ka endà egkilalaen da duu sa kagi di.” ");
INSERT INTO mta_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na, iya sa peligad tinulon i Hésus diyà kenagda, dodoo endà netiigan da duu sa selepangan di. ");
INSERT INTO mta_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Huenan di, egselepangen i Hésus sa peligad di diyà kenagda, guwaen di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Aken lagà sa bengawan ukitan sa medoo kebilibili mangay diyà sa lugenan. ");
INSERT INTO mta_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Iya lagà sa tegepenakaw owoy tegelampas sa medoo liyu etaw mig-angay egtulù egoh ku endà pa migtebow. Dodoo sa medoo etaw ku lagà kebilibili ku, endà egpigtuu da diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na, aken lagà sa bengawan ukitan etaw mangay diyà si Nemula. Sumalà dé sa etaw umukit diyà kenak, iya sa mealukan ku. Kagda lagà sa kebilibili ku takà egdalem diyà sa lugenan owoy lumiyu ma anì tumabtab. ");
INSERT INTO mta_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dodoo sa tegepenakaw, iya daa sa pesuwan di eg-angay diyà sa lugenan anì menakaw owoy mimatay owoy pedaetan di sa kebilibili. Dodoo aken, mig-angay a diyà tanà anì melalù yu taman melugay owoy tigtu megulub ma sa lalù yu. ");
INSERT INTO mta_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Aken sa tigtu mepion tegeipat kebilibili. Amuk sa mepion tegeipat kebilibili, maen dé amuk meimatayan anì mealukan sa kebilibili. ");
INSERT INTO mta_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Dodoo amuk sa etaw egsukayan daa, beken kagdi sa tigtu tegeipat kebilibili enù ka beken hagdi sa kebilibili. Amuk eghauwen di sa mebalaw tinggalung eglohot kebilibili, egpelaguyan di sa medoo kebilibili. Hê, egbangaen sa tinggalung sa kebilibili owoy nesepalak da langun. ");
INSERT INTO mta_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Egpelaguy sa etaw egsukayan enù ka beken kagdi sa épê kebilibili owoy endà ma eghiduwan di duu sa kebilibili eg-ipaten di. ");
INSERT INTO mta_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Dodoo aken sa tigtu mepion tegeipat kebilibili. Netiigan ku sa Emà ku owoy netiigan di ma aken. Hediya ma sa medoo etaw ku, enù ka netiigan ku kagda owoy netiigan da ma aken. Huenan di, mepion diyà kenak amuk meimatayan a anì mealukan ku kagda. ");
INSERT INTO mta_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Duen ma sa medoo liyu etaw lagà sa kebilibili ku, dodoo endà diyà da siini lugenan. Kuwaen ku ma kagda owoy dinegen da ma sa kagi ku anì munut da ma diyà kenak. Huenan di, mebaluy mesesebaen sa umpungan da langun owoy sebaen ma daa sa eg-ipat kenagda. ");
INSERT INTO mta_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Na, tigtu eghiduwan i Emà ku aken enù ka mepion diyà kenak amuk meimatayan a anì mealukan ku sa medoo etaw ku, dodoo meenaw a mendaa. ");
INSERT INTO mta_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Endà tegelen a etaw mimatay, dodoo danà sa naken uyot mebaluy meimatayan a. Megaga ku lumengà sa hagtay ku anì mematay a owoy megaga ku dema kumuwa sa hagtay ku, enù ka iya sa igsugù i Emà ku diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Na, egoh sa medoo etaw Hudiyu migdineg sa inikagi i Hésus, egsesigbolowoy da enù ka endà nesesebaen sa penemdem da. ");
INSERT INTO mta_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Duen etaw diyà kenagda eg-ikagi, guwaen da, “Egkelengleng danà di linahuk busaw. Yoko egdinegdineg ga diyà kagdi.” ");
INSERT INTO mta_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Dodoo duen ma liyu etaw eg-ikagi, guwaen da, “Amuk linahuk busaw kagdi i, endà mekebaluy di tumulù iling iya wé, enù ka tigtu mepion sa ketulù di. Amuk linahuk busaw, endà megaga di duu peilag sa mata sa langap.” ");
INSERT INTO mta_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, neuma dé sa pasad sa pista etaw Hudiyu egoh da mineketuleng sa kinepeluman sa Dalesan i Nemula diyà Hélusalém egoh anay. ");
INSERT INTO mta_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Megenaw sa tanà egoh iya, owoy eg-ipanawpanaw Hésus i diyà sa luglug Dalesan i Nemula kepengadan da Luglug i Salomon. ");
INSERT INTO mta_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Agulé, egkesetipon sa medoo kaunutan Hudiyu diyà si Hésus, owoy eg-ikagi da, guwaen da, “Nelugay dé endà tigtu netiigan ké duu kuna. Tuloni ko kami amuk tuu kuna si Kelistu sa Tigtu Datù sinugù i Nemula, ataw ka beken.” ");
INSERT INTO mta_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Egsagbì Hésus i, guwaen di, “Tinulon ku dé iya wé diyà keniyu, dodoo endà egpigtuu yu diyà kenak. Binaelan ku sa medoo panduan danà sa egkegaga igbegay i Emà diyà kenak, owoy iya sa tandà di aken sa sinugù di. ");
INSERT INTO mta_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Dodoo kiyu, tapay yu doo endà egpigtuu enù ka beken kiyu sa kebilibili ku. ");
INSERT INTO mta_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Egdinegen sa medoo kebilibili ku sa kagi ku owoy netiigan ku kagda owoy eg-unut-unut da ma diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Begayan ku kagda sa lalù endà meelut di anì endà dé mepigtamayan da. Endà ma dé duen etaw mekelampas kenagda diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na, si Emà sa migbegay kenagda diyà kenak anì ipaten ku kagda. Nekelowon sa hagdi egkegaga diyà sa langun, huenan di endà duen sa mekelampas kenagda diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Enù ka nesesebaen ké daa si Emà.” ");
INSERT INTO mta_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Egoh sa medoo Hudiyu migdineg iya wé inikagi i Hésus, eghudut da dema batu buungen da enù ka imatayan da hedem. ");
INSERT INTO mta_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Dodoo guwaen i Hésus diyà kenagda, “Igpehaa ku dé sa medoo mepion panduan igpebael i Emà ku diyà kenak. Tayu sa binaelan ku pesuwan di egbuungen yu aken batu?” ");
INSERT INTO mta_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Egsagbì da, guwaen da, “Beken danà sa medoo panduan binaelan ko sa pesuwan di buungen ké kuna batu, dodoo danà ko daa migsumbung si Nemula. Apiya di pa etaw ka daa diyà tanà, guwaen ko dò nesetepeng yu si Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Agulé guwaen i Hésus, “Netiigan yu doo iya sa kagi i Nemula igpesulat diyà sa libelu yu, guwaen di, ‘Kiyu doo sa lagà nemula.’ ");
INSERT INTO mta_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Na, netiigan ta endà mehalì di sa kagi i Nemula igpesulat enù ka anan tuu taman melugay. Huenan di, amuk nemula sa iningadanan di sa medoo etaw sinugù di egoh anay, ");
INSERT INTO mta_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","maen di ya guwaen yu migsumbung a si Nemula amuk iya sa kagi ku aken sa Anak i Nemula? Na, aken sa hinemilì i Nemula owoy sa pineangay di diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Upama amuk endà egbaelan ku duu sa medoo panduan igpebael i Emà diyà kenak, yoko egpigtuu ya diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Dodoo amuk egbaelan ku sa ipebael di diyà kenak, apiya di pa endà egpigtuuwen yu duu aken, pigtuu yu doo sa medoo panduan egbaelan ku anì tigtu metiigan yu eg-ugpà si Emà diyà kenak owoy diyà a ma kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Na, egoh da migdineg iya wé inikagi i Hésus, ungayà da sigkemen da, dodoo nekelesò diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Agulé, mig-ipanaw Hésus i kedu diyà Hélusalém, owoy migbatas sa lawa Holdan eg-angay diyà sa tapay atung kenà i Huwan migbautis etaw egoh anay. Dahiya sa kenà di mig-ugpà Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Duen medoo etaw mig-angay diyà kenagdi, owoy egseikagiyay da, guwaen da, “Apiya di pa endà duen panduan binaelan i Huwan egoh anay, tuu doo sa langun inikagi di denu si Hésus.” ");
INSERT INTO mta_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hê, medoo sa etaw dutu egpigtuu dé diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Na, duen sa maama eglinadu, si Lasalo. Eg-ugpà diyà sa menuwa Bétaniya, owoy eg-ugpà ma dahiya sa tebay di si Maliya owoy si Maleta. ");
INSERT INTO mta_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na, si Maliya sa mighudud lana mepion ngadeg diyà sa lisen i Hésus owoy hinunas di ma balut ulu di. Na, eglinadu sa kakay di maama, si Lasalo. ");
INSERT INTO mta_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Huenan di, duen etaw pineangay da i Maliya diyà si Hésus anì egtulonen da diyà kenagdi, guwaen da, “O Datù, eglinadu sa loyuk ko eghiduwan ko.” ");
INSERT INTO mta_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Agulé, egoh i Hésus migdineg iya wé, guwaen di, “Beken sa kepatay di sa ketamanan siini linadu i Lasalo. Dodoo iya polo sa pesuwan di eglinadu anì meolò Nemula i owoy meolò ma sa Anak di danà iya wé.” ");
INSERT INTO mta_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na, eghiduwan i Hésus Maleta i owoy sa hadi di owoy si Lasalo. ");
INSERT INTO mta_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Dodoo egoh di migdineg sa linadu i Lasalo, eg-ugpà pelà duwa agdaw diyà sa tapay kenà di. ");
INSERT INTO mta_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Agulé egoh di neuma duwa agdaw, guwaen i Hésus diyà sa medoo salu di, “Mangay ki dema dutu Hudiya dò.” ");
INSERT INTO mta_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Dodoo guwaen sa medoo salu di, “O Mistelu, mepion amuk endà dé pelikù ka dutu, enù ka egoh dini, egpenemdemen sa medoo Hudiyu kuna eg-imatay buungen da kuna batu.” ");
INSERT INTO mta_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Egsagbì Hésus i, guwaen di, “Na, duen sepulù owoy duwa kaulas diyà uman sebaen agdaw. Amuk eg-ipanaw sa etaw amuk agdaw, endà mekebigkulek di enù ka eg-ilag doo danà sa agdaw. ");
INSERT INTO mta_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Dodoo amuk sigep sa keipanaw sa etaw, mekebigkulek doo enù ka endà duen legdaw diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Agulé, egoh i Hésus mig-ikagi iya wé, guwaen di dema diyà sa medoo salu di, “Neketudug sa loyuk ta, si Lasalo, dodoo angayen ku umenaw.” ");
INSERT INTO mta_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Agulé guwaen sa salu di, “O Datù, amuk neketudug, nelikuan dé, enù ka sa ketudug di sa tandà di nelikuan.” ");
INSERT INTO mta_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na, inikagi i Hésus sa egoh i Lasalo nematay, dodoo guwaen da dò inikagi di sa ketudug di daa. ");
INSERT INTO mta_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Huenan di, sinelepang di sa inikagi di, guwaen di, “Nematay dé Lasalo i. ");
INSERT INTO mta_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Dodoo mepion polo sa pedu ku enù ka endà dahiya a egoh di nematay, enù ka kumedakel sa kepigtuu yu danà sa hauwen yu dutu. Na, mangay ki dutu kagdi dò.” ");
INSERT INTO mta_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Agulé, eg-ikagi Tomas i kepengadan da si Seping, guwaen di diyà sa medoo duma di salu i Hésus, “Na, munut ki ma kenagdi mangay dutu anì sebaen daa sa kepatay ta.” ");
INSERT INTO mta_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na, egoh i Hésus migtebow diyà Bétaniya, dinineg di epat agdaw dé Lasalo i iglebeng. ");
INSERT INTO mta_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na, medapag sa menuwa Bétaniya diyà Hélusalém, enù ka telu kakilumitelu kéen sa kediyù di. ");
INSERT INTO mta_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Huenan di, duen medoo Hudiyu mig-angay diyà si Maleta owoy si Maliya, enù ka eg-imùimuen da kagda danà sa kakay da nematay. ");
INSERT INTO mta_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Na, egoh i Maleta migdineg medapag dé tumebow Hésus i, eg-angayen di egtelabuk, dodoo diatas pelà Maliya i. ");
INSERT INTO mta_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Egoh i Maleta migtebow diyà si Hésus, guwaen di, “O Datù, amuk dahini ka egoh i Kakay eglinadu, endà mematay di hedem. ");
INSERT INTO mta_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Dodoo apiya di pa nematay dé ini egoh, netiigan ku doo ibegay i Nemula diyà keniko sumalà dé sa pegeniyen ko diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Guwaen i Hésus, “Umenaw dema sa kakay ko.” ");
INSERT INTO mta_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Guwaen i Maleta, “Netiigan ku umenaw doo amuk meuma sa keenaw sa langun etaw diyà sa sabuhanan agdaw.” ");
INSERT INTO mta_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Agulé guwaen i Hésus, “Aken sa egpekeenaw etaw, owoy aken sa egpelalù etaw. Apiya di pa nematay sa etaw egpigtuu diyà kenak, melalù doo. ");
INSERT INTO mta_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Sumalà dé sa etaw egpigtuu diyà kenak, endà dé mekesugsug sa suguy di enù ka melalù taman melugay. Enù di ya, egpigtuuwen ko pa ini i kagi ku?” ");
INSERT INTO mta_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Hoò, Datù,” guwaen i Maleta. “Egpigtuu a doo kuna sa Anak i Nemula sa Tigtu Datù eg-angat-angatan ké mangay diyà tanà kedu diyà langit.” ");
INSERT INTO mta_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Egoh i Maleta mig-ikagi iya wé, eg-angayen di sa hadi di si Maliya. Binadàbadaan di, guwaen di, “Dahini dé sa mistelu owoy igsasà di kuna.” ");
INSERT INTO mta_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Egoh i Maliya migdineg iya wé, medelamet eglegkang eg-angay diyà si Hésus, ");
INSERT INTO mta_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","enù ka endà pa migdalem Hésus i diyà sa menuwa Bétaniya, dodoo eg-ugpà pelawà diyà sa kenà i Maleta migtelabuk kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, sa medoo Hudiyu eg-imùimù si Maliya diatas sa dalesan di, hinaa da sa kelegkang di medelamet owoy sa keipanaw di. Huenan di, egsetugdug da enù ka iya sa penemdem da mangay suminegaw dutu siedò kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na, egoh i Maliya migtebow diyà sa kenà i Hésus, egligkued diyà sa taengan di owoy guwaen di, “O Datù, amuk dahini ka egoh i Kakay eglinadu, endà mematay di hedem.” ");
INSERT INTO mta_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Egoh i Hésus eghaa si Maliya owoy sa medoo Hudiyu eg-unut kenagdi egsinegaw, nebukul temù sa pedu di owoy egkebenung sa palas di. ");
INSERT INTO mta_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Guwaen di, “Kenà i Lasalo i iglebeng?” Agulé guwaen da, “O Datù, unut ka kenami mangay dutu anì hauwen ko.” ");
INSERT INTO mta_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hê, egsinegaw Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iya maen di ya guwaen sa medoo Hudiyu, “Haa yu, eghiduwan di temù Lasalo i.” ");
INSERT INTO mta_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Dodoo egseikagiyay sa medoo liyu etaw, guwaen da, “Pineilag di sa maama langap. Maen di ya atu endà negaga di duu eghawid sa kepatay i Lasalo?” ");
INSERT INTO mta_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Agulé nebukul dema Hésus i temù egoh di migtebow diyà sa kenà lebeng, sa takub sinagpengan batu. ");
INSERT INTO mta_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Agulé guwaen di, “Kedani yu dé sa batu.” Dodoo eg-ikagi Maleta i hadi sa nematay, guwaen di, “O Datù, mahù dé enù ka epat agdaw dé sa lugay di iglebeng.” ");
INSERT INTO mta_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Agulé, guwaen i Hésus diyà kenagdi, “Taa ko sa tinulon ku diyà keniko egoh giina, guwaen ku amuk migtuu ka, mehaa ko sa dakel tunung i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hê, egkedanan da sa batu igsagpeng lebeng. Agulé eglengag Hésus i owoy guwaen di, “O Emà, egpesalamat a diyà keniko enù ka dinineg ko dé aken. ");
INSERT INTO mta_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Netiigan ku takaan ko aken egdinegdineg, dodoo danà sa medoo etaw dahini, inikagi ku iya wé anì migtuu da kuna sa migpeangay kenak diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Agulé egoh di ubus egsimbà, egpetaled eg-umow, guwaen di, “O Lasalo, laun ka dé.” ");
INSERT INTO mta_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hê, eglaun dé Lasalo i. Nebedbed ginis sa langun lawa di lapeg sa belad di owoy sa lisen di ma. Nebekut ma musala sa kilay di. Agulé, guwaen i Hésus diyà kenagda, “Lengai yu dé. Kedani yu sa ginis igbekut kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Na, sa medoo etaw Hudiyu mig-angay diyà si Maliya, egoh da mighaa iya wé panduan binaelan i Hésus, egpigtuu da dé diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Dodoo duen ma medoo liyu etaw eg-angay egtulon diyà sa medoo Palasiyu denu sa binaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Agulé, egoh sa medoo ulu-ulu tegesimbà owoy sa medoo Palasiyu migdineg iya wé, egkesetipon da owoy sa medoo kaunutan Hudiyu. Guwaen da, “Ngadan sa mepion mebaelan ta? Enù ka medoo sa panduan egbaelan iya wé etaw. ");
INSERT INTO mta_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Amuk endà hawidan ta duu, melengon migtuu sa langun etaw diyà kenagdi. Amuk hediya, dinegen sa ulu-ulu ta diyà Loma duen sa sebaen ma datù dahini. Medaet iya wé enù ka peangayen da sa medoo sundalu dahini anì pedaetan da sa Dalesan i Nemula owoy sa nita menuwa ma.” ");
INSERT INTO mta_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Na, duen sa etaw dahiya, si Kayipas, sa Tigtu Ulu-ulu Tegesimbà egoh iya wé palay. Guwaen di diyà sa medoo duma di ulu-ulu, “Endà egpekepenemdem yu. ");
INSERT INTO mta_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Maen di ya endà egketiigan yu duu ini i? Uman pa mepion amuk sebaen daa sa etaw mematay, beken daa amuk sa langun etaw mematay. Mepion amuk kagdi daa sa meimatayan anì endà meimatayan ki langun, kita i Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Na, beken danà sa hagdi penemdem daa iya wé inikagi i Kayipas, dodoo danà di sa Tigtu Ulu-ulu Tegesimbà egoh iya wé palay, igpetulon i Nemula diyà kenagdi sa egoh i Hésus meimatayan anì tigtuwan di sa salà sa langun etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Beken sa Hudiyu daa sa metabangan danà sa kepatay i Hésus, dodoo meanak i Nemula sa langun etaw sumalà dé sa menuwa da anì mesesebaen da danà sa kepatay i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Agulé edung egoh iya, takà da egseolomoy sa medoo kaunutan Hudiyu eglagbet sa ukit keimatay da si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Huenan di, endà dé eg-ipanawpanaw Hésus i diyà sa kenà sa medoo etaw diyà uwang Hudiya. Dodoo eglegkang polo eg-angay dutu menuwa Ipelaim dò diyà sa tanà eg-abay diyà sa melabel tanà mediyù dalesan. Agulé eg-ugpà dahiya lapeg sa medoo salu di. ");
INSERT INTO mta_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Na, buyu dé neuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Huenan di, egoh sa pista endà pa eg-edung, mig-angay sa medoo etaw Hélusalém dò kedu diyà sa medoo menuwa anì mangunut da sa adat Hudiyu denu sa kepelanih da diyà sa kehaa i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Egoh da nesetipon diyà sa Dalesan i Nemula, eglagbeten da Hésus i owoy egseigsaay da, guwaen da, “Ngadan sa penemdem yu? Lumenged pa Hésus i sa pista, ataw ka endà?” ");
INSERT INTO mta_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dodoo egoh iya, tapay dé igsasà sa medoo ulu-ulu tegesimbà owoy sa medoo Palasiyu anì metulonon da amuk duen etaw meketiig sa kenà i Hésus anì sigkemen da. ");
INSERT INTO mta_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Na, enem agdaw pa meuma sa pasad sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, eg-angay Hésus i diyà sa menuwa Bétaniya. Iya sa menuwa i Lasalo sa inenaw i Hésus egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na, egoh di migtebow dutu, egpistawan sa medoo loyuk di kagdi. Egbulig Maleta i eg-iluh kaenen egoh da kumaen, owoy si Lasalo sa sebaen etaw diyà kenagda egselengan egkaen diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na si Maliya tebay i Lasalo, inuwit di sa butul nepenù lana mepion ngadeg kepengadan da naldo. Iya sa kedakel butul di sa tengà litelus owoy tigtu milagà iya wé lana. Hê, hinudud di diyà sa lisen i Hésus, owoy iya sa ighunas di sa balut ulu di. Agulé, neseluh ngadeg di sa luwang dalesan. ");
INSERT INTO mta_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Agulé, eg-ikagi sa sebaen salu i Hésus, si Hudas Iskaliyot, sa tumampil diyà sa medoo kuntelà i Hésus. Guwaen di, ");
INSERT INTO mta_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Ay! Nelemet iya wé lana. Mepion polo hedem amuk dagangen anì mekuwa sa medoo pilak anì itukidtukid da ibegay diyà sa medoo pubeli, enù ka mapulù sa lagà di enù ka egpekeuma sa sukay etaw eg-ulenal taman segepalay.” ");
INSERT INTO mta_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Na, beken danà sa kehidu di etaw pubeli sa pesuwan di mig-ikagi iya wé, dodoo danà di polo tegepenakaw enù ka takà egpenakaw sa duma pilak igsalig da diyà kenagdi enù ka kagdi sa tegeipat sa pilak da. ");
INSERT INTO mta_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Dodoo guwaen i Hésus, “Pandayà yu dé. Yoko egpemala duu enù ka tapayen di dé siini lana anì pepion sa lawa ku sa egoh ku ilebeng. ");
INSERT INTO mta_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tapay doo duen sa etaw pubeli diyà keniyu anì mebuligan yu ma. Dodoo aken, endà dé iseg a melugay mugpà diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na, dinineg sa medoo Hudiyu sa ketebow i Hésus dutu Bétaniya dò, huenan di mig-angay da ma dutu. Beken si Hésus daa sa egkeiyapan da eghaa, dodoo egkeiyapan da ma humaa Lasalo i sa inenaw i Hésus egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Huenan di, egseolomoy sa medoo ulu-ulu tegesimbà anì imatayan da ma Lasalo i, ");
INSERT INTO mta_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","enù ka danà sa kineenaw di, migsabuh dé sa medoo Hudiyu eg-unut diyà kenagda enù ka egpigtuu da polo diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Na, egoh di sumimag dé, dinineg sa medoo etaw eglenged pista sa egoh i Hésus eg-angay Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Huenan di, egtelabuken da kagdi owoy mig-uwit da ma panga kayu melaweng daun, enù ka iya sa adat da egsalù sa datù. Egpetaled da ma eg-ikagi, guwaen da, “Meolò Nemula i. Meolò ma sa pineangay i Datù Nemula. Meolò ma sa Tigtu Datù ta tugod i Islaél.” ");
INSERT INTO mta_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na, hinaa i Hésus sa nati asnu owoy egkudà dahiya. Huenan di, neketuu dé sa kagi i Nemula igpesulat egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O kiyu i tegeHélusalém, yoko egkelenawan na. Haa yu, tumebow sa Datù yu egkudà diyà sa nati asnu.” ");
INSERT INTO mta_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na, egoh i Hésus egkudà eg-angay Hélusalém dò, endà pa netiigan sa medoo salu di duu neketuu dé iya wé kagi i Nemula igpesulat. Dodoo, egoh i Hésus neenaw dema owoy nebatun dutu langit dò, netulengan da sa binaelan da diyà kenagdi owoy netiigan da ma dé neketuu sa kagi i Nemula denu kenagdi danà iya wé binaelan di. ");
INSERT INTO mta_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na, medoo sa etaw mighaa si Hésus egoh di mig-umow si Lasalo dutu kenà lebeng dò egoh di mig-enaw kenagdi egoh di nematay. Agulé, egtulonon da sa medoo liyu etaw denu iya wé binaelan i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Huenan di, egtelabuken sa medoo etaw Hésus i egoh di egtebow Hélusalém dò enù ka dinineg da denu siedò panduan binaelan di. ");
INSERT INTO mta_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Dodoo egoh sa medoo Palasiyu neketiig eg-unut-unut sa medoo etaw diyà si Hésus, egseolomoy da, guwaen da, “Taa yu. Tinabanan ki dé, enù ka sa langun etaw diyà tanà eg-unut-unut da dé diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na, duen ma etaw Geligu mig-angay Hélusalém dò anì egsimbà da ma egoh da eglenged sa pista. ");
INSERT INTO mta_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Agulé, eg-angay da diyà si Pilipi, sa etaw tegeBétsaida diyà uwang Galiliya. Guwaen da diyà kenagdi, “O Akay, ungayà ké mikagi ké ma diyà si Hésus.” ");
INSERT INTO mta_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Agulé, eg-angay egtulon Pilipi i diyà si Andelis sa ungayà da. Agulé, duwa da mig-angay diyà si Hésus owoy tinulon da ma diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Egsagbì Hésus i, guwaen di diyà kenagda, “Buyu dé egkeuma sa pasad egoh i Nemula pehaa sa kedatù ku, aken i Kakay Langun. ");
INSERT INTO mta_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tuu ini i eg-ikagiyen ku diyà keniyu. Endà duen ulan sa benì amuk endà eghemulaen di diyà tanà. Amuk ilebeng dé diyà tanà owoy egtunas ma, kumedoo temù sa bunga di. ");
INSERT INTO mta_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Amuk iya daa sa pedakelen etaw diyà sa pedu di sa kepekihagtay di, iya polo sa etaw mematay. Dodoo amuk endà egpedakelen di duu sa kepekihagtay di diyà tanà enù ka eg-unut-unut diyà kenak, iya polo sa etaw melalù taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Amuk iya sa ungayà yu pepasek yu diyà kenak, unut-unut yu kenak anì mekeangay yu ma diyà sa angayan ku. Sumalà dé sa etaw egpangunut diyà sa igsugù ku, iya sa etaw pedakelen sa Emà ku.” ");
INSERT INTO mta_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Agulé eg-ikagi Hésus i, guwaen di, “Tigtu nebukul sa pedu ku. Ngadan sa ikagiyen ku egsimbà diyà si Emà? Endà mebaluy di pegeniyen ku diyà kenagdi anì alangen di siini dakel kelikutan umukit diyà kenak, enù ka iya sa pesuwan ku mig-angay diyà tanà anì ukitan ku sa kelikutan ku.” ");
INSERT INTO mta_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Agulé, egsimbà Hésus i, guwaen di, “O Emà, pehauwi ko sa dakel egkegaga ko diyà sa medoo etaw.” Hê, egoh di mig-ikagi iya wé, duen sa eg-ikagi kedu langit, guwaen di, “Igpehaa ku dé sa dakel egkegaga ku danà sa medoo binaelan ko, owoy uman pa ipehaa ku.” ");
INSERT INTO mta_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na, dinineg sa medoo etaw egtigdeg dahiya iya wé kagi, owoy guwaen da, “Kilat kéen iya wé.” Dodoo guwaen sa medoo liyu etaw, “Duen sa egsugùsuguen i Nemula mig-ikagi diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Dodoo guwaen i Hésus diyà kenagda, “Iya sa pesuwan i Nemula mig-ikagi anì metiigan yu dinineg di sa kagi ku. Endà ipetiig di duu iya wé diyà kenak, enù ka tapay dé netiigan ku dinineg di sa kagi ku. ");
INSERT INTO mta_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Edung ini egoh pigtamayan i Nemula sa langun etaw egkuntelà kenagdi diyà tanà, owoy tabanan di ma dé Satanas i, sa eg-unutan sa medoo etaw tegebael salà. ");
INSERT INTO mta_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Dodoo aken, amuk itagù a diyà sa kayu igbugsud, isasà ku sa langun etaw diyà siini sinukub langit anì migtuu da diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Na, iya sa inikagi di anì metiigan da sa ukit kepatay di. ");
INSERT INTO mta_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dodoo egsagbì sa medoo etaw, guwaen da, “Duen sa igtulù diyà kenami diyà sa kagi i Nemula igpesulat, melalù polo taman melugay sa Tigtu Datù hinemilì i Nemula. Dodoo kuna, maen di ya guwaen ko meketagù sa Kakay Langun diyà sa kayu igbugsud? Ngadan di etaw iya wé Kakay Langun?” ");
INSERT INTO mta_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Agulé guwaen i Hésus, “Duen pelà sa legdaw diyà keniyu, dodoo endà iseg di melugay mekedan. Huenan di, unuti yu dé sa legdaw egoh di pelà diyà keniyu anì endà deleman yu, enù ka sa etaw eg-ipanaw diyà deleman, endà metiigan di duu sa angayan di. ");
INSERT INTO mta_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Dodoo amuk diyà keniyu pelà sa legdaw, unuti yu dé sa legdaw anì melegdawan yu.” Egoh i Hésus ubus eg-ikagi iya wé, sinalidan di sa medoo etaw owoy eg-angay diyà sa kenà di endà mehaa etaw. ");
INSERT INTO mta_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Apiya di pa hinaa da sa medoo panduan binaelan di, endà doo egpigtuu da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na, danà da endà egpigtuu, neketuu dé sa kagi igsulat i Isayas sa tegesugkow i Nemula egoh anay, guwaen di, “O Datù, endà duen etaw egpigtuu sa igtulù ké. Endà ma egpigtuu da apiya di pa ipehaa ko sa tunung ko diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Huenan di, endà mekepigtuu da enù ka guwaen i Isayas ma, ");
INSERT INTO mta_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pinelangap i Nemula kagda anì endà mehaa da duu sa egbaelan di, owoy pinetegas di ma sa ulu da anì endà ma metiigan da duu sa selepangan di. Enù ka amuk metiigan da, migtuu da doo diyà kenagdi owoy metuing ma sa pedu da diyà kenagdi anì mealukan i Nemula kagda.” ");
INSERT INTO mta_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na, inikagi i Isayas iya wé egoh anay, enù ka nehaa di sa dakel tunung i Hésus, owoy tinulon di ma dé sa denu kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Apiya di pa iya sa igsulat i Isayas egoh anay, duen doo medoo ulu-ulu etaw Hudiyu egpigtuu diyà si Hésus. Dodoo linidung da polo sa kepigtuu da enù ka nelimedangan da sa medoo Palasiyu humawid kenagda lumudep diyà sa simbaan da. ");
INSERT INTO mta_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iglidung da sa kepigtuu da enù ka apiya di pa ungayà da metuuwan Nemula i diyà kenagda, uman doo dakel sa uyot da oloen etaw. ");
INSERT INTO mta_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na, pinetaled i Hésus sa kagi di, guwaen di, “Amuk egpigtuu sa etaw diyà kenak, beken aken daa sa egpigtuuwen di, dodoo egpigtuuwen di ma sa migpeangay kenak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Sa etaw mighaa kenak, hinaa di ma Emà i sa migpeangay kenak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aken sa legdaw mig-angay diyà tanà anì mekelaun sa langun etaw egpigtuu diyà kenak kedu diyà sa deleman. ");
INSERT INTO mta_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sumalà dé sa etaw migdineg sa igtulù ku, dodoo endà egpigtuuwen di duu, beken aken sa mekepigtamay kenagdi, enù ka beken iya sa pesuwan ku mig-angay a diyà tanà anì pigtamayan ku sa medoo etaw, dodoo mig-angay a dini anì alukan ku polo kagda. ");
INSERT INTO mta_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Dodoo amuk duen etaw eg-eked kenak owoy endà ma egpigtuuwen di duu sa igtulù ku, mepigtamayan doo amuk meuma sa sabuhanan agdaw. Ini sa pesuwan di mepigtamayan danà sa kagi igtulù ku endà egpigtuuwen di duu. ");
INSERT INTO mta_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Enù ka beken sa naken penemdem daa sa igtulù ku, dodoo si Emà sa migpeangay kenak, kagdi sa migsugù kenak sa ikagiyen ku owoy sa itulù ku. ");
INSERT INTO mta_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Netiigan ku iya sa egpelalù etaw taman melugay sa igsugù di. Huenan di, takà ku igsugkow diyà keniyu sa kagi di igtulù diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Na, segdu pa endà meuma sa pasad sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Na egoh iya, tapay dé netiigan i Hésus buyu dé meuma sa kelegkà di diyà tanà anì pelikù mangay diyà sa Emà di. Takaan di eghidu sa medoo etaw di diyà tanà, dodoo apiya di pa medapag dé sa kepatay di, igpehaa di doo diyà kenagda sa kehidu di kenagda. ");
INSERT INTO mta_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Na, egoh mahapun, egkaen Hésus i owoy sa medoo salu di. Dahiya ma si Hudas anak i Simon Iskaliyot, owoy tapay dé binegayan i Satanas penemdem anì tumampil diyà sa medoo kuntelà i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Na, netiigan i Hésus doo igbegay i Emà di sa langun egkegaga diyà kenagdi owoy netiigan di ma pineangay i Nemula kagdi diyà tanà owoy pelikù dema mangay diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Huenan di, egoh da pelà egkaen, migtigdeg Hésus i owoy egkedanan di sa kawal di owoy igleget di sa tuliyà diyà sa hawak di. ");
INSERT INTO mta_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Agulé, eghudud wayeg diyà sa palanggana, owoy egtukiden di egpeguséén lisen sa medoo salu di. Eghunasen di ma tuliyà sa lisen da. ");
INSERT INTO mta_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Egoh di nekeuma diyà si Simon Pidelu, eg-ikagi Pidelu i, guwaen di, “O Datù, beken kuna sa megusê sa lisen ku.” ");
INSERT INTO mta_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Egsagbì Hésus i, guwaen di, “Endà pa egketiigan ko duu sa egbaelan ku. Dodoo metiigan ko doo kani.” ");
INSERT INTO mta_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Dodoo guwaen i Pidelu, “Endà mebaluy di kuna sa megusê sa lisen ku.” Egsagbì Hésus i, guwaen di, “Amuk endà egpeguséén ku duu, endà ma mebaluy di kuna sa pasek ku.” ");
INSERT INTO mta_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Agulé guwaen i Simon Pidelu, “O Datù, amuk hediya, beken sa lisen ku daa sa peguséén ko, dodoo peguséi ko ma lapeg sa belad ku owoy sa ulu ku.” ");
INSERT INTO mta_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Egsagbì Hésus i, guwaen di, “Amuk ubus dé egpedigus sa etaw, iya daen sa peguséén di sa lisen di, enù ka melanih dé sa langun lawa di. Hediya ma kiyu i, lagà yu ma sa etaw magtu migpedigus enù ka melanih yu dé. Dodoo duen pa sebaen etaw diyà keniyu endà melanih di.” ");
INSERT INTO mta_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Na, mig-ikagi Hésus i endà melanih sa sebaen etaw diyà kenagda, enù ka tapay dé netiigan di sa tayu etaw tumampil diyà sa medoo kuntelà di. ");
INSERT INTO mta_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Agulé, egoh i Hésus ubus migpegusê sa lisen da, kumawal dema owoy egpelikù egpenuu diyà sa kenà di. Eg-igsà diyà kenagda, guwaen di, “Enù di ya, metiigan yu pa sa pesuwan ku migpegusê lisen yu? ");
INSERT INTO mta_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na, guwaen yu aken sa Mistelu yu owoy sa Datù yu ma, owoy nesugat iya wé enù ka tuu doo aken sa Mistelu yu owoy sa Datù yu. ");
INSERT INTO mta_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Apiya di pa aken sa Mistelu yu owoy sa Datù yu, pineguséén ku sa lisen yu enù ka migpetukééy a diyà keniyu. Huenan di, peguséi yu ma lisen sa duma yu anì tandaan yu sa kepetukééy yu keniyu diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iya sa binaelan ku diyà keniyu anì meilingan yu aken. ");
INSERT INTO mta_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk udipen, endà mekelowon di diyà sa datù di. Hediya ma sa tegesugkow, endà ma mekelowon di diyà sa etaw egsugù kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na, netiigan yu dé ini i igtulù ku keniyu. Amuk pangunutan yu iya wé, tigtu yu meanggan temù. ");
INSERT INTO mta_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Dodoo beken langun yu sa eg-ikagiyan ku, enù ka netiigan ku doo sa pedu sa uman sebaen etaw hinemilì ku. Duen sa sebaen etaw diyà keniyu tumampil diyà sa medoo kuntelà ku anì meketuu sa kagi i Nemula igpesulat egoh anay, guwaen di, ‘Iya sa kumuntelà kenak sa sebaen duma ku doo meseselengan kumaen.’ ");
INSERT INTO mta_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na, egoh di endà pa meuma iya wé, tapay dé tinulon ku diyà keniyu. Huenan di, amuk hauwen yu sa ketuu di, mekepigtuu yu doo tapay a dé duen egoh anay. ");
INSERT INTO mta_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tuu ini i eg-ikagiyen ku diyà keniyu. Sumalà dé sa etaw miadat sa etaw pineangay ku, eg-adatan di ma aken. Owoy sumalà dé sa etaw eg-adat kenak, eg-adatan di ma sa migpeangay kenak.” ");
INSERT INTO mta_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na, egoh i Hésus ubus eg-ikagi iya wé, tigtu egkebukul sa pedu di. Agulé, guwaen di diyà sa medoo salu di, “Tuu ini i eg-ikagiyen ku diyà keniyu. Duen diyà keniyu sebaen etaw tumampil diyà sa kuntelà ku anì meimatayan a.” ");
INSERT INTO mta_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Egoh sa medoo salu di migdineg iya wé, negaip da owoy egseinengtengay da, enù ka endà netiigan da duu tayu di etaw iya wé inikagi di. ");
INSERT INTO mta_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, iya sa mig-abay si Hésus sa salu di eghiduwan di temù. ");
INSERT INTO mta_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Agulé, egtanguan i Simon Pidelu kagdi, owoy guwaen di, “Igsai ko ngadan di etaw iya wé inikagi di.” ");
INSERT INTO mta_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Agulé, migdapag diyà si Hésus, owoy eg-igsaan di, guwaen di, “O Datù, tayu di etaw diyà kenami sa tumampil diyà sa kuntelà ko?” ");
INSERT INTO mta_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Migsagbì Hésus i, guwaen di, “Iya sa etaw tumampil sa begayan ku siini epan idamù ku diyà sa sabaw.” Hê, igdamù i Hésus sa epan owoy igbegay di diyà si Hudas anak i Simon Iskaliyot. ");
INSERT INTO mta_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Egoh i Hudas migsakem sa epan, linahuk i Satanas dé kagdi i. Agulé guwaen i Hésus diyà kenagdi, “Pedelamet ko dé baeli sa ungayà ko.” ");
INSERT INTO mta_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Dodoo sa medoo etaw duma di neseselengan egkaen, endà netiigan da duu sa pesuwan i Hésus mig-ikagi iya wé diyà si Hudas. ");
INSERT INTO mta_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na, si Hudas sa eg-ipat sa pilak da. Huenan di duen duma salu i Hésus guwaen da dò sinugù i Hésus kagdi eg-angay egbeli sa kulang da diyà sa pista. Owoy duen ma salu di, guwaen da dò sinugù di egpebegay pilak diyà sa medoo etaw pubeli. ");
INSERT INTO mta_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Na, egoh i Hudas migkaen sa epan igbegay i Hésus kenagdi, medelamet eglaun kedu dalem sa dalesan, owoy sigep dé. ");
INSERT INTO mta_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na, egoh i Hudas mig-ipanaw dé, eg-ikagi Hésus i, guwaen di, “Buyu dé egkeuma sa egoh di mehaa sa dakel tunung ku, aken i Kakay Langun. Owoy danà sa mebaelan ku, mehaa ma sa dakel tunung i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Amuk mehaa sa dakel tunung i Nemula danà sa mebaelan ku, ipehaa ma i Nemula sa dakel tunung ku, owoy buyu dé egkeuma iya wé. ");
INSERT INTO mta_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Na, kiyu i etaw ku eghiduwan ku, endà dé iseg a melugay mekeugpà diyà keniyu. Apiya di pa lagbeten yu aken, nesetepeng doo sa kagi ku diyà keniyu owoy sa inikagi ku egoh dini diyà sa medoo ulu-ulu etaw Hudiyu, endà mekeuma yu diyà sa angayan ku. ");
INSERT INTO mta_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na, duen sa magtu igsugù ku diyà keniyu. Sehiduway yu dé. Hiduwi yu sa duma yu lagà sa kehidu ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Amuk egsehiduway yu, iya sa kenà etaw meketiig kiyu sa pasek ku.” ");
INSERT INTO mta_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Agulé, eg-igsà Simon Pidelu i, guwaen di, “O Datù, angayan ko ya?” Egsagbì Hésus i, guwaen di, “Endà pa mekeunut ka kenak mangay dutu siedò angayan ku. Dodoo sebaen agdaw pa, mekeangay ka ma dutu.” ");
INSERT INTO mta_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Guwaen i Pidelu, “O Datù, maen di ya endà mekeunut a keniko ini egoh di? Mebaluy doo diyà kenak amuk mematay a danà ku eg-unut keniko.” ");
INSERT INTO mta_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Agulé guwaen i Hésus, “Tuu pa atu mebaluy diyà keniko amuk mematay ka danà ko eg-unut kenak? Dodoo tuu ini i eg-ikagiyen ku diyà keniko. Amuk endà pa umukolò sa ebos amuk buyu sumimag, palawen ko polo aken beken duma ko taman telu gulê.” ");
INSERT INTO mta_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Agulé, guwaen i Hésus diyà sa medoo salu di, “Yoko egkebukul la. Salig yu polo diyà si Nemula owoy salig yu ma diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Duen medoo sibay dutu siedò kenà i Emà ku. Enù ka amuk endà tuu iya wé, endà tulonen ku duu diyà keniyu sa egoh ku mangay dutu anì tapayen ku mael sa kenà yu umugpà. ");
INSERT INTO mta_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Amuk meubus ku egtapay sa kenà yu umugpà, pelikù a angayen ku kiyu anì mugpà yu ma dé diyà sa kenà ku taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Netiigan yu ma dé sa dalan mangay diyà sa angayan ku.” ");
INSERT INTO mta_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Agulé eg-ikagi Tomas i diyà kenagdi, guwaen di, “O Datù, endà egketiigan ké duu sa angayan ko. Huenan di, endà ma egketiigan ké duu sa dalan di.” ");
INSERT INTO mta_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Egsagbì Hésus i, guwaen di, “Aken sa dalan mangay diyà si Nemula. Aken sa tuu egpigtuuwen etaw, owoy aken ma sa egpelalù etaw taman melugay. Endà duen etaw mekeangay diyà si Emà amuk beken aken sa ukitan di. ");
INSERT INTO mta_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Amuk tigtu yu neketiig kenak, metiigan yu ma sa Emà ku. Edung ini egoh di, netiigan yu dé kagdi i owoy hinaa yu ma danà yu mighaa kenak.” ");
INSERT INTO mta_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Agulé guwaen i Pilipi diyà kenagdi, “O Datù, pehauwi ko diyà kenami sa Emà ko, enù ka iya daa sa ungayà ké.” ");
INSERT INTO mta_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Egsagbì Hésus i, guwaen di, “O Pilipi, nelugay a dé diyà keniyu. Huenan di, negaip a enù ka endà pa egketiigan ko duu aken. Enù ka sa medoo etaw mighaa kenak, hinaa da ma si Emà. Maen di ya egpegeniyen ko diyà kenak ipehaa ku si Emà diyà keniyu? ");
INSERT INTO mta_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Lagà endà egpigtuu ka eg-ugpà Emà i diyà kenak owoy diyà a ma kenagdi. Apiya sa langun eg-ikagiyen ku diyà keniyu, beken danà sa naken penemdem daa iya wé, dodoo iya polo sa binaelan sa Emà ku eg-ugpà diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pigtuu yu dé sa inikagi ku eg-ugpà Emà i diyà kenak owoy eg-ugpà a ma diyà kenagdi. Amuk endà egpigtuuwen yu duu iya wé apiya aken sa eg-ikagi iya wé, pigtuu yu polo danà sa medoo panduan binaelan ku. ");
INSERT INTO mta_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk egpigtuu sa etaw diyà kenak, mebaelan di doo sa medoo panduan iling sa binaelan ku owoy uman pa dakel sa hagdi mebaelan, enù ka lumikù a diyà si Emà. ");
INSERT INTO mta_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Enù ka amuk duen sa egpegeniyen yu diyà si Nemula danà sa kepigtuu yu diyà kenak, ibegay ku doo iya wé diyà keniyu anì mehaa sa dakel tunung i Emà danà sa egbaelan ku. ");
INSERT INTO mta_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Sumalà dé sa egpegeniyen yu diyà kenak danà sa kepigtuu yu diyà kenak, ibegay ku ma doo.” ");
INSERT INTO mta_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Agulé, guwaen i Hésus, “Amuk eghiduwan yu aken, mangunut yu ma diyà sa igsugù ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ikagiyen ku diyà si Emà anì peangayen di diyà keniyu sa Tegetabang mekesambì kenak, owoy umugpà diyà keniyu taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kagdi sa Metiengaw Suguy i Nemula egtulù keniyu sa tuu tegudon. Na sa medoo etaw endà egpigtuu diyà kenak, endà mesakem da duu kagdi i enù ka endà egkilalaen da duu owoy endà ma metiigan da duu. Dodoo kiyu, netiigan yu dé kagdi enù ka eg-unut diyà keniyu owoy eg-ugpà ma diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na, amuk mipanaw a, endà tigtu yu meilu, enù ka pelikù a mendaa diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Endà iseg di melugay endà dé mehaa a etaw diyà tanà. Dodoo kiyu, hauwen yu mendaa aken enù ka meenaw a dema. Danà ku melalù taman melugay, kumelalù yu ma taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Amuk meuma sa keenaw ku, tigtu metiigan yu doo eg-ugpà a diyà si Emà. Hediya ma, diyà a ma keniyu owoy diyà yu ma kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Na, iya sa etaw mehidu kenak sa etaw egpeketiig sa igsugù ku owoy egpangunut ma. Owoy sa etaw mehidu kenak, iya sa eghiduwan i Emà ku owoy eghiduwan ku ma kagdi i owoy ipetiig ku diyà kenagdi sa denu kenak.” ");
INSERT INTO mta_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Agulé, eg-ikagi sa sebaen Hudas, beken si Hudas Iskaliyot, guwaen di, “O Datù, maen di ya kami daa sa pinetiig ko denu keniko, dodoo endà petiigen ko duu sa medoo liyu etaw?” ");
INSERT INTO mta_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Egsagbì Hésus i, guwaen di, “Enù ka endà tigtu da mehidu kenak. Dodoo amuk mehidu sa etaw kenak, mangunut ma doo diyà sa igtulù ku. Hiduwan i Emà ma kagdi owoy mangay ké mugpà si Emà diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Dodoo sa etaw endà mehidu kenak, endà egpangunutan di duu sa igtulù ku. Na sa igtulù ku keniyu, beken danà sa naken penemdem daa, dodoo danà i Emà polo sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Egtulonen ku ini i enù ka diyà a pelawà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Dodoo peangayen i Emà diyà keniyu sa Tegetabang mekesambì kenak. Kagdi sa Metiengaw Suguy i Nemula, owoy itulù di keniyu sa langun mepion owoy ipetulengtuleng di ma diyà keniyu sa langun tinulon ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Apiya di pa salidan ku kiyu, melanih doo sa pedu yu, enù ka melanih sa naken pedu owoy iya ma sa ibegay ku diyà keniyu. Na, sa medoo etaw diyà tanà endà egpigtuu, endà megaga da duu megay iling sa kebegay ku diyà keniyu. Huenan di, yoko egkebukul la owoy yoko ma egkelimedangan na. ");
INSERT INTO mta_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Dinineg yu dé sa inikagi ku diyà keniyu egoh giina guwaen ku, ‘Buyu a dé mipanaw dodoo pelikù a dema diyà keniyu.’ Amuk tigtu eghiduwan yu aken, meanggan yu doo danà ku mangay diyà si Emà, enù ka kagdi sa eglowon diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Egoh ku endà pa sumalid diyà keniyu, tapay dé tinulon ku diyà keniyu anì migtuu yu diyà kenak amuk hauwen yu sa ketuu di. ");
INSERT INTO mta_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Endà iseg di melugay sa keikagi ku keniyu, enù ka buyu dé tumebow Satanas i, sa kaunutan etaw endà egpigtuu. Dodoo endà mekegaga di kenak. ");
INSERT INTO mta_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Dodoo, baelan ku polo sa igsugù i Emà diyà kenak anì metiigan sa langun etaw eghiduwan ku Emà i. Na, tigdeg yu dé, lumegkang ki dini.” ");
INSERT INTO mta_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Agulé egtulù Hésus i, guwaen di, “Aken lagà sa pesu keleg palas egbunga, owoy si Emà sa eg-ipat sa palas. ");
INSERT INTO mta_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Amuk duen sa panga di endà egbunga, kedanan di. Owoy egtegpulen di ma sa langun panga di egbunga anì uman pa kumedoo sa bunga di. ");
INSERT INTO mta_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Hediya ma kiyu i, enù ka migkelanih yu ma dé danà yu migsakem sa igtulù ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Huenan di, amuk mugpà yu diyà kenak, mugpà a ma diyà keniyu. Enù ka endà munga sa panga palas amuk endà eg-ugpà di diyà sa pesu di. Hediya ma kiyu i, endà mebaelan yu duu sa mepion amuk endà eg-ugpà yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Eg-ikagi a dema ini i. Aken lagà sa pesu palas owoy kiyu lagà sa panga ku. Amuk eg-ugpà sa etaw diyà kenak owoy mugpà a ma diyà kenagdi, iya sa etaw munga medoo. Dodoo sa etaw migtangkà diyà kenak, endà dé duen sa mebaelan di mepion. ");
INSERT INTO mta_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Amuk endà eg-ugpà sa etaw diyà kenak, kagdi lagà sa panga palas sepangen owoy ibuung. Amuk megangu dé, tiponen owoy ibuung diyà sa apuy anì meulow. ");
INSERT INTO mta_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Dodoo kiyu, amuk eg-ugpà yu diyà kenak owoy egsakemen yu ma sa igtulù ku, mebegayan yu doo sumalà dé sa egpegeniyen yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Meolò Nemula i Emà ku amuk medoo sa bunga yu mepion. Amuk hediya, egtandaan yu kiyu sa pasek ku. ");
INSERT INTO mta_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Eghiduwan ku kiyu lagà sa kehidu i Emà kenak. Huenan di, ugpà yu diyà kenak anì mehiduwan ku kiyu takà. ");
INSERT INTO mta_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Amuk mangunut yu diyà sa igsugù ku keniyu, hiduwan ku kiyu takà. Diya ma aken i, egpangunut a sa igsugù i Emà diyà kenak owoy endà ma egtangkà a diyà sa kehidu di. ");
INSERT INTO mta_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Iya sa tinulon ku diyà keniyu anì meanggan yu lagà sa kekeanggan ku anì tigtu yu meanggan temù. ");
INSERT INTO mta_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ini sa igsugù ku keniyu, sehiduway yu dé lagà sa kehidu ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Amuk duen etaw mematay danà di eg-aluk sa medoo loyuk di, iya sa tandà di tigtu eghiduwan di kagda. Endà duen sa mekelowon diyà sa hagdi kehidu. ");
INSERT INTO mta_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na, kiyu sa loyuk ku amuk egpangunut yu diyà sa igsugù ku keniyu. ");
INSERT INTO mta_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Endà dé ingadanan ku duu kiyu udipen, dodoo kiyu dé sa loyuk ku. Amuk udipen, endà egketiigan di duu sa baelan sa datù di. Dodoo kiyu sa loyuk ku, enù ka igpetiig ku dé diyà keniyu sa langun dinineg ku diyà sa Emà ku. ");
INSERT INTO mta_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Beken kiyu sa mighemilì kenak, dodoo aken polo sa mighemilì keniyu. Ginelal ku ma kiyu anì mangay yu tumulù anì kumedoo temù sa bunga yu endà mekedan di. Huenan di, sumalà dé sa egpegeniyen yu diyà si Emà danà yu egpigtuu diyà kenak, ibegay di doo diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na, ini sa igsugù ku diyà keniyu, sehiduway yu dé langun.” ");
INSERT INTO mta_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Eg-uman Hésus i egtulù, guwaen di, “Amuk egkelepuhan sa etaw endà egpigtuu kiyu, yoko egkegaip pa enù ka nelepuhan da aken sa egoh da endà pa melepuh keniyu. ");
INSERT INTO mta_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Upama, amuk munut yu sa etaw endà egpigtuu, loyuken da doo kiyu. Dodoo endà eg-unut yu diyà kenagda, enù ka hinemilì ku dé kiyu. Huenan di, egkelepuhan da doo kiyu. ");
INSERT INTO mta_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Petulengtuleng yu sa kagi ku diyà keniyu, guwaen ku, ‘Endà mekelowon sa udipen diyà sa datù di.’ Na, amuk egpelihayen da aken i datù yu, pelihayen da ma kiyu. Amuk egpigtuuwen da sa igtulù ku, pigtuuwen da ma sa ketulù yu. ");
INSERT INTO mta_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Dodoo medaet sa kebael da keniyu danà di kiyu sa etaw ku enù ka endà ma netiigan da duu Nemula i sa migpeangay kenak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Upama amuk endà mig-angay a diyà tanà anì egtegudon a diyà kenagda, endà mesalà da danà da endà egpigtuu diyà kenak. Dodoo tinulù ku dé kagda sa tuu tegudon, huenan di endà dé mekeikagi da endà duen salà da. ");
INSERT INTO mta_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Amuk egkelepuhan a etaw, beken aken daa sa egkelepuhan di, egkelepuhan di ma Emà i. ");
INSERT INTO mta_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Upama, amuk endà hinaa da duu sa medoo panduan binaelan ku endà megaga di sa liyu etaw mael, endà mesalà da danà sa medaet kebael da kenak. Dodoo, nesalà da doo enù ka hinaa da sa medoo panduan binaelan ku owoy egkelepuhan da ma aken owoy si Emà. ");
INSERT INTO mta_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Na, danà sa kelepuh da kenak, neketuu dé sa kagi i Nemula igpesulat egoh anay, guwaen di, ‘Apiya di pa endà duen sa pesuwan da egkelepuh kenak, kelepuhan da doo aken.’ ");
INSERT INTO mta_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Na, peangayen ku diyà keniyu sa Tegetabang kedu diyà si Emà. Iya sa Metiengaw Suguy i Nemula tumulù sa tuu tegudon. Amuk tumebow diyà tanà kedu diyà si Emà, ipetiig di ma sa denu kenak diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Owoy kiyu ma sa tumulù denu kenak diyà sa medoo etaw enù ka inunutan yu aken edung sa egoh ku anay migtulù taman ini egoh di.” ");
INSERT INTO mta_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Guwaen i Hésus, “Tinulon ku dé langun iya wé diyà keniyu anì endà kumelenek sa kepigtuu yu diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Enù ka meuma sa agdaw kani egoh yu mehemagawan kedu diyà sa simbaan ta. Owoy meimatayan yu ma enù ka guwaen da dò metuuwan Nemula i diyà sa egbaelan da. ");
INSERT INTO mta_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iya sa baelan da diyà keniyu enù ka endà metiigan da duu Nemula i Emà ku, owoy endà ma metiigan da duu aken. ");
INSERT INTO mta_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dodoo, tapay dé tinulon ku ini i diyà keniyu anì metulengan yu doo amuk meuma sa egoh da mael medaet diyà keniyu.” Agulé guwaen i Hésus, “Egoh anay egoh yu mig-edung eg-unut kenak, endà egtulonen ku duu ini i diyà keniyu enù ka diyà a pelà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Dodoo buyu a dé pelikù diyà si Emà sa migpeangay kenak. Huenan di, negaip a keniyu, enù ka apiya di pa buyu a dé mipanaw, endà eg-igsaen yu duu sa angayan ku. ");
INSERT INTO mta_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Dodoo, egkebukul polo sa pedu yu danà sa tinulon ku keniyu sa kelikutan mekeuma diyà keniyu kani. ");
INSERT INTO mta_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Dodoo tuu ini i eg-ikagiyen ku diyà keniyu. Uman pa mepion amuk salidan ku kiyu, enù ka upama amuk endà mipanaw a, endà tumebow sa Tegetabang diyà keniyu. Dodoo amuk mipanaw a, peangayen ku kagdi diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Amuk tumebow, ipetiig di diyà sa langun etaw duen sa salà da, owoy ipetiig di ma kenagda sa metiengaw adat, owoy ipetiig di ma sa kepigtamay i Nemula sa medoo etaw endà egpigtuu. ");
INSERT INTO mta_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ini sa pesuwan di ipetiig di diyà kenagda duen sa salà da, enù ka endà egpigtuu da diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ipetiig di ma sa metiengaw adat enù ka pelikù a diyà si Emà owoy endà dé hauwen yu duu aken. ");
INSERT INTO mta_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Owoy ipetiig di ma pigtamayan i Nemula sa etaw endà egpigtuu enù ka inatuwan di dé Satanas i, sa kaunutan etaw tegebael medaet. ");
INSERT INTO mta_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na, duen pa hedem sa medoo kagi ungayà ku itulù ku keniyu, dodoo endà pa megaga yu duu. ");
INSERT INTO mta_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Dodoo amuk tumebow sa Metiengaw Suguy i Nemula anì tumulù sa tuu tegudon, kagdi sa petiig diyà keniyu sa langun tuu. Beken danà sa hagdi penemdem daa sa itulù di keniyu, dodoo iya sa itulù di sa dinineg di diyà si Emà owoy ipetiig di ma diyà keniyu sa medoo mehaa kani. ");
INSERT INTO mta_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Owoy ipeolò di ma aken, enù ka tulonen di diyà keniyu sa langun eg-ikagiyen ku. ");
INSERT INTO mta_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ini sa pesuwan di guwaen ku tulonen di diyà keniyu sa eg-ikagiyen ku, enù ka iya sa eg-ikagiyen ku sa langun eg-ikagiyen sa Emà ku.” ");
INSERT INTO mta_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Agulé, guwaen i Hésus, “Endà iseg di melugay endà dé hauwen yu duu aken. Dodoo amuk melugaylugay pa hauwen yu dema aken.” ");
INSERT INTO mta_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Egoh sa medoo salu di migdineg iya wé, egseigsaay da, guwaen da, “Ngadan sa selepangan iya wé inikagi di, guwaen di endà iseg di melugay endà dé hauwen ta duu dodoo amuk melugaylugay pa hauwen ta dema? Ngadan sa selepangan sa inikagi di pelikù gaa diyà sa Emà di?” ");
INSERT INTO mta_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Egseigsaay da ma, guwaen da, “Ngadan sa selepangan sa inikagi di guwaen di endà iseg di melugay? Endà metiigan ta duu sa eg-ikagiyen di.” ");
INSERT INTO mta_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na, netiigan i Hésus duen sa igsaen da diyà kenagdi hedem. Huenan di, guwaen di, “Maen di ya egseigsaay yu denu sa inikagi ku guwaen ku, ‘Endà iseg di melugay endà dé hauwen yu aken, dodoo amuk melugaylugay pa hauwen yu dema aken?’ ");
INSERT INTO mta_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tuu ini i eg-ikagiyen ku diyà keniyu. Suminegaw yu temù danà sa mebaelan ku, dodoo meanggan polo sa etaw egkuntelà kenak. Apiya di pa mebukul yu temù, meanggan yu doo kani amuk hauwen yu dema aken. ");
INSERT INTO mta_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Taa yu, hih. Amuk duen sa bayi buyu dé lesutan, egkebukul asal neuma dé sa egoh di egsakalan. Dodoo amuk miglesut dé sa anak di, nelipengan di sa egoh di nesakitan enù ka neanggan dé polo danà sa anak di miglesut. ");
INSERT INTO mta_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Hediya ma kiyu i, apiya di pa egkebukul yu ini egoh di, tigtu yu doo meanggan amuk hauwen yu dema aken. Endà duen etaw mekekedan sa kekeanggan yu. ");
INSERT INTO mta_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Amuk meuma iya wé agdaw, endà dé uman yu mekepegeni tabang diyà kenak. Tuu ini i eg-ikagiyen ku diyà keniyu. Amuk duen sa egpegeniyen yu diyà si Emà danà sa kepigtuu yu diyà kenak, ibegay di doo diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Taman ini egoh di, endà pa duen sa egpegeniyen yu diyà kenagdi danà sa kepigtuu yu diyà kenak. Dodoo edung ini egoh di, pegeni yu polo diyà kenagdi danà sa kepigtuu yu diyà kenak owoy mebegayan yu doo anì tigtu yu meanggan.” ");
INSERT INTO mta_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Agulé guwaen i Hésus, “Igtulù ku iya wé diyà keniyu danà sa medoo peligad. Dodoo buyu dé meuma sa agdaw egoh beken dé peligad sa itulù ku keniyu, enù ka metudà dé sa ketulù ku keniyu denu si Emà. ");
INSERT INTO mta_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Amuk meuma iya wé, kiyu dé sa pegeni diyà si Emà danà sa kepigtuu yu diyà kenak. Iya maen di ya endà duen sa pesuwan ku megeni diyà kenagdi denu keniyu ");
INSERT INTO mta_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","enù ka eghiduwan di kiyu. Eghiduwan i Emà kiyu enù ka eghiduwan yu aken owoy egpigtuu yu ma kedu a si Nemula. ");
INSERT INTO mta_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tuu mig-angay a diyà tanà owoy kedu a ma diyà si Emà. Hê, buyu a dé lumegkà diyà siini tanà enù ka lumikù a dé dutu si Emà dò.” ");
INSERT INTO mta_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Agulé, guwaen sa medoo salu di diyà kenagdi, “Tigtu metudà dé sa eg-ikagiyen ko enù ka endà egpeligad ka. ");
INSERT INTO mta_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Netiigan ké dé kuna sa neketiig langun, enù ka apiya di pa endà igsaan ka etaw, netiigan ko doo sa penemdem da. Huenan di, egpigtuu ké dé kedu ka diyà si Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Agulé guwaen i Hésus, “Enù di ya, egpigtuu yu dé? ");
INSERT INTO mta_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Dodoo buyu dé meuma sa agdaw egoh yu mesepalak langun. Lumikù sa uman sebaen etaw diyà sa hagdi menuwa, enù ka salidan yu dé aken anì sebaen ku daa. Dodoo duen doo sa duma ku si Emà. ");
INSERT INTO mta_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ini sa pesuwan ku migtulon ini i diyà keniyu anì metanà sa pedu yu danà ta nesesebaen. Mepelihay yu doo diyà tanà danà sa medoo etaw endà egpigtuu, dodoo pebagel yu polo sa pedu yu enù ka inatuwan ku dé sa kaunutan etaw tegebael medaet.” ");
INSERT INTO mta_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Agulé, egoh i Hésus ubus mig-ikagi diyà sa medoo salu di, eglengag diyà langit owoy egsimbà, guwaen di, “O Emà, neuma dé sa pasad hinemilì ko. Pedakel ko aken i Anak ko anì pedakelen ku ma kuna. ");
INSERT INTO mta_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Enù ka igsalig ko dé diyà kenak sa egkegaga anì kumedatù a diyà sa langun etaw anì ibegay ku sa lalù endà meelut di diyà sa langun etaw igsalig ko diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iya sa etaw melalù taman melugay sa etaw egpeketiig keniko, kuna i tigtu Nemula, owoy neketiig ma kenak, aken i Hésus Kelistu sa pineangay ko diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Igpehaa ku dé sa dakel tunung ko diyà tanà, enù ka neubus ku dé egbael sa langun galebek igsugù ko kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Emà, begayi ko diyà kenak sa dakel tunung ku diyà langit iling sa dakel tunung ku egoh anay egoh ku diyà keniko egoh sa tanà endà pa duen. ");
INSERT INTO mta_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Igpetiig ku dé kuna diyà sa medoo etaw igsalig ko diyà kenak diyà tanà. Hinemilì ko kagda egoh anay owoy igsalig ko kagda diyà kenak, owoy migpangunut da ma diyà sa kagi ko. ");
INSERT INTO mta_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Netiigan da ma dé kedu diyà keniko sa langun igbegay ko diyà kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Igsugkow ku diyà kenagda sa langun igtulù ko diyà kenak, owoy pinigtuu da ma dé. Netiigan da ma tuu kedu a diyà keniko, owoy egpigtuu da ma kuna sa migpeangay kenak diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“O Emà, isimbà ku kagda. Beken sa medoo etaw endà egpigtuu sa isimbà ku, dodoo isimbà ku polo sa medoo etaw igsalig ko diyà kenak, enù ka kagda ma sa etaw ko. ");
INSERT INTO mta_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Enù ka niko sa langun etaw ku, owoy hediya ma naken ma sa etaw ko. Owoy nehaa sa dakel tunung ku danà da. ");
INSERT INTO mta_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na, buyu a dé pelikù diyà keniko, owoy endà dé mugpà a diyà tanà. Dodoo siini medoo etaw ku, dahini da pelà diyà tanà. O Emà ku, tigtu ka metiengaw. Tuliki ko kagda danà sa tunung ko igsalig ko diyà kenak anì mesesebaen da iling kenita nesesebaen. ");
INSERT INTO mta_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Egoh ku pelà diyà kenagda, mepion sa ketulik ku kenagda danà sa egkegaga ko igsalig ko diyà kenak. Egtulikan ku kagda, owoy endà duen sebaen mekesugsug diyà kenagda, liyu daa sa etaw migtangkà diyà kenak danà sa medaet ungayà di. Dodoo danà iya wé binaelan di, neketuu doo sa kagi ko igpesulat. ");
INSERT INTO mta_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na, buyu a dé lumikù diyà keniko. Dodoo isimbà ku kagda egoh ku pelà diyà tanà anì tigtu da meanggan lagà sa kekeanggan ku. ");
INSERT INTO mta_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Igsugkow ku dé diyà kenagda sa kagi ko. Dodoo, egkelepuhan sa medoo etaw diyà tanà endà egpigtuu kagda enù ka endà eg-iling da diyà kenagda. Hediya ma aken i, endà ma eg-iling a diyà sa medoo etaw diyà tanà endà egpigtuu. ");
INSERT INTO mta_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Endà isasà ku duu keniko amuk kedanan ko sa medoo etaw ku diyà tanà. Dodoo ini sa isasà ku keniko, tuliki ko kagda anì endà medaetan sa kepigtuu da danà i Satanas. ");
INSERT INTO mta_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Enù ka endà dé eg-iling da diyà sa medoo etaw diyà tanà endà egpigtuu, enù ka eg-ilingan da aken egoh ku endà ma eg-iling a diyà sa etaw diyà tanà endà egpigtuu. ");
INSERT INTO mta_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na, ungayà ku petiengawen ko sa medoo etaw ku danà da neketiig sa tuu tegudon. Sa kagi ko, iya sa tuu tegudon. ");
INSERT INTO mta_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pineangay ko aken diyà tanà, hediya ma peangayen ku kagda anì tumegudon da diyà sa langun etaw diyà tanà. ");
INSERT INTO mta_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Danà sa kehidu ku kenagda, egpebegay a diyà keniko owoy egpangunut a ma sa uyot ko. Iya sa egbaelan ku anì pebegay da ma diyà keniko owoy tuu ma sa kepangunut da sa uyot ko. ");
INSERT INTO mta_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“O Emà, beken kagda daa sa isimbà ku, dodoo isimbà ku ma sa medoo etaw migtuu diyà kenak kani danà sa ketulù da. ");
INSERT INTO mta_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Emà, isimbà ku kagda anì mesesebaen da langun iling kenita nesesebaen, enù ka diyà ka kenak owoy diyà a ma keniko. Ungayà ku ma diyà da ma kenita, anì migtuu sa langun etaw kuna sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na, sa dakel tunung ko igbegay ko diyà kenak, iya ma sa ibegay ku diyà kenagda anì mesesebaen da ma iling kenita nesesebaen. ");
INSERT INTO mta_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Enù ka diyà a kenagda owoy diyà ka ma kenak. Ungayà ku tigtu mesesebaen da anì metiigan sa langun etaw kuna sa migpeangay kenak owoy sa eghidu kenagda lagà sa kehidu ko kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“O Emà, ungayà ku mugpà diyà sa kenà ku kani siini medoo etaw igsalig ko diyà kenak, anì hauwen da sa dakel tunung ku igbegay ko diyà kenak, enù ka eghiduwan ko aken egoh anay egoh sa tanà endà pa duen. ");
INSERT INTO mta_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Emà, tigtu ka metiengaw. Endà netiigan sa medoo etaw diyà tanà endà egpigtuu kuna. Dodoo aken, netiigan ku kuna owoy netiigan ma siini medoo etaw ku kuna sa migpeangay kenak. ");
INSERT INTO mta_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Enù ka igpetiig ku dé kuna diyà kenagda, owoy uman pa ipetiig ku kuna diyà kenagda, enù ka ungayà ku sehiduway da iling sa kehidu ko kenak, owoy mugpà a ma diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na, egoh i Hésus ubus egsimbà, eg-ipanaw da lapeg sa medoo salu di egkatin da sa wayeg Kidelon. Agulé egdalem da diyà sa hinemulaan kayu dahiya. ");
INSERT INTO mta_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, si Hudas sa migtampil diyà sa medoo kuntelà i Hésus, netiigan di siedò hinemulaan inangayan da enù ka iya sa kenà da i Hésus takà egkesetipon sa medoo salu di. ");
INSERT INTO mta_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Huenan di, iya ma sa inangayan i Hudas mig-uwit medoo sundalu owoy sa medoo tegebantay Dalesan i Nemula pineangay sa medoo ulu-ulu tegesimbà owoy medoo Palasiyu. Mig-uwit da kinemkem owoy sulù ma. ");
INSERT INTO mta_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na, tapay dé netiigan i Hésus sa langun baelan da diyà kenagdi, huenan di inangay di kagda egtelabuk. Eg-igsà, guwaen di, “Ngadan di etaw sa eglagbeten yu?” ");
INSERT INTO mta_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Guwaen da egsagbì, “Si Hésus tegeNasalét.” Guwaen i Hésus, “Aken sa eglagbeten yu.” Na, dahiya ma Hudas i sa migtampil diyà sa kuntelà i Hésus, owoy kagdi sa inunutan sa medoo sundalu. ");
INSERT INTO mta_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Egoh i Hésus mig-ikagi, guwaen di, “Aken sa eglagbeten yu,” petow da nekeesud-esud owoy nekeetok da. ");
INSERT INTO mta_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Agulé eg-igsà dema Hésus i, guwaen di, “Ngadan di etaw sa eglagbeten yu?” Guwaen da egsagbì, “Si Hésus tegeNasalét.” ");
INSERT INTO mta_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Agulé guwaen i Hésus, “Tinulonon ku dé kiyu aken sa eglagbeten yu. Amuk tuu aken sa eglagbeten yu, yoko eglapeg duu siini medoo duma ku.” ");
INSERT INTO mta_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iya sa inikagi i Hésus enù ka neketuu sa kagi di egsimbà giina, guwaen di, “O Emà, endà duen sebaen mekesugsug diyà sa medoo etaw igsalig ko diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Agulé, hinugut i Simon Pidelu sa sundang di. Hê, tinigbas di sa egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà. Nesapsap sa telinga di denu kuwanan. Iya sa ngadan di, si Malko. ");
INSERT INTO mta_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Agulé, guwaen i Hésus diyà si Pidelu, “Gumà ko sa sundang ko, enù ka meuma a doo sa kelikutan igbegay sa Emà ku diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Agulé, sa medoo sundalu owoy sa kapitan da owoy sa medoo tegebantay Dalesan i Nemula, egsigkemen da Hésus i owoy pinolot da. ");
INSERT INTO mta_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Muna inagak da diyà si Anas nugangan i Kayipas. Na, si Kayipas sa Tigtu Ulu-ulu Tegesimbà egoh iya wé palay, ");
INSERT INTO mta_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","owoy kagdi ma sa mig-ikagi egoh dini diyà sa medoo ulu-ulu Hudiyu, guwaen di, “Uman pa mepion amuk sebaen daa sa meimatayan beken daa amuk sa langun etaw mematay.” ");
INSERT INTO mta_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, si Simon Pidelu owoy sa sebaen salu di, nekehudihudi da diyà si Hésus. Egoh da migtebow diyà sa kutà sa menuwa Tigtu Ulu-ulu Tegesimbà, eg-unut sa sebaen salu i Hésus egludep diyà sa duwangen dalesan, enù ka kinilala sa Tigtu Ulu-ulu Tegesimbà kagdi i. ");
INSERT INTO mta_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Dodoo eg-ugpà pelawà Pidelu i diyà dibaluy sa kutà medapag diyà sa bengawan. Agulé, egpelikù sa salu i Hésus, owoy eg-ikagi diyà sa bayi tegebantay bengawan anì pelagbasen di ma Pidelu i. ");
INSERT INTO mta_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Hê, eg-igsà sa bayi diyà si Pidelu, guwaen di, “Enù di ya, kuna ma sa pasek iya wé maama nesigkem?” Dodoo egpalaw Pidelu i, guwaen di, “Beken pasek di aken i.” ");
INSERT INTO mta_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na, egoh iya wé sigep, megenaw sa tanà, huenan di egtemeg sa medoo tegebantay owoy sa medoo egsugùsuguen sa bagaꞌt apuy anì ingadang da dahiya. Agulé, eg-iling ma eg-ingadang Pidelu i. ");
INSERT INTO mta_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na, eg-igsaan sa Tigtu Ulu-ulu Tegesimbà Hésus i denu sa medoo pasek di owoy sa igtulù di ma. ");
INSERT INTO mta_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Egsagbì Hésus i, guwaen di, “Netiigan sa langun etaw sa igtulù ku, enù ka takà a migtulù diyà sa medoo simbaan ta owoy diyà sa Dalesan i Nemula kenà etaw takà egkesetipon. Huenan di, endà nelidung sa igtulù ku. ");
INSERT INTO mta_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Maen di ya eg-igsaan ko aken? Mepion polo amuk igsaan ko sa medoo etaw migdineg sa igtulù ku, enù ka netiigan da doo sa inikagi ku diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hê, egoh i Hésus mig-ikagi iya wé, tinagpì sa sebaen tegebantay. Guwaen di, “Maen di ya hediya sa kesagbì ko diyà sa Tigtu Ulu-ulu Tegesimbà?” ");
INSERT INTO mta_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Egsagbì Hésus i, guwaen di, “Amuk medaet sa inikagi ku, tulon ko ngadan sa kedaet di. Dodoo amuk endà medaet di, maen di ya tinagpì ko aken?” ");
INSERT INTO mta_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Agulé, pineangay i Anas Hésus i ligò di tapay doo pinolot diyà si Kayipas, sa Tigtu Ulu-ulu Tegesimbà egoh iya wé palay. ");
INSERT INTO mta_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, diyà pelà duwangen Pidelu i egtigdeg medapag diyà sa apuy enù ka eg-ingadang. Agulé, eg-igsaan etaw kagdi i, guwaen da, “Kuna ma kéen pasek iya wé maama?” Dodoo egpalaw Pidelu i, guwaen di, “Beken aken pasek di ya.” ");
INSERT INTO mta_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Duen ma dahiya sa egsugùsuguen sa Tigtu Ulu-ulu Tegesimbà sa duma telahadi sa sinapsapan i Pidelu telinga. Eg-ikagi diyà si Pidelu, guwaen di, “Kuna kéen sa duma i Hésus hinaa ku diyà sa hinemulaan kayu giina.” ");
INSERT INTO mta_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Dodoo egpalaw dema Pidelu i, guwaen di, “Beken aken iya wé.” Hê, umukolò dé sa ebos. ");
INSERT INTO mta_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Na, egoh di umawang dé, inagak da dema Hésus i eg-angay da diyà sa dalesan i Gubilenu Pilatu kedu diyà sa dalesan i Kayipas. Dodoo endà eggemow sa medoo ulu-ulu etaw Hudiyu diyà sa dalesan sa gubilenu, anì endà metipay da duu sa uledin igsugkow i Mosis denu sa kepelanih da. Enù ka amuk gumemow da diyà sa dalesan etaw beken Hudiyu, endà mebaluy da kumaen sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Huenan di, eglaun Pilatu i eg-angay eg-igsà diyà kenagda, guwaen di, “Ngadan sa igtipu yu diyà siini etaw?” ");
INSERT INTO mta_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Egsagbì sa medoo ulu-ulu, guwaen da, “Duen sa salà di. Upama amuk endà duen salà di, endà agaken ké duu diyà keniko anì pigtamayan ko.” ");
INSERT INTO mta_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Agulé guwaen i Pilatu, “Amuk netiigan yu duen sa salà di, mepion amuk kiyu polo sa migtamay kenagdi danà sa medoo uledin yu.” Egsagbì sa medoo ulu-ulu, guwaen da, “Endà mebaluy di kami sa mimatay sa etaw migtipay sa nami uledin.” ");
INSERT INTO mta_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Na, iya sa inikagi da enù ka meketuu sa kagi i Hésus denu sa kepatay di diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Egludep dema Pilatu i diyà sa dalesan di owoy igpeangay di Hésus i. Agulé, eg-igsaan di dema kagdi, guwaen di, “Enù di ya, kuna sa Sulutan diyà sa medoo Hudiyu?” ");
INSERT INTO mta_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Guwaen i Hésus, “Enù di ya, danà sa niko penemdem iya wé igsà ko kenak ataw ka tinulonon ka etaw denu kenak?” ");
INSERT INTO mta_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Egsagbì Pilatu i, guwaen di, “Beken a Hudiyu aken i, huenan di endà netiigan ku duu sa denu keniko. Maen di ya inagak ka diyà kenak sa medoo duma ko Hudiyu owoy sa medoo ulu-ulu tegesimbà? Ngadan iya wé salà binaelan ko?” ");
INSERT INTO mta_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Egsagbì Hésus i, guwaen di, “Beken diyà siini tanà daa sa kedatù ku. Enù ka upama, amuk diyà siini tanà sa kedatù ku, lumimbul doo sa medoo etaw ku anì endà mesigkem a ulu-ulu etaw Hudiyu. Dodoo beken diyà siini tanà sa kedatù ku.” ");
INSERT INTO mta_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Eg-igsà dema Pilatu i, guwaen di, “Amuk hediya, kuna sa Sulutan?” Guwaen i Hésus, “Tuu sa gelal igbegay ko diyà kenak Sulutan a, enù ka iya sa pesuwan ku neetaw a diyà tanà. Pineangay a diyà tanà anì ipetiig ku sa tuu tegudon diyà sa langun etaw. Amuk meiyap sa etaw sa tuu tegudon, duminegdineg da diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Hê, guwaen i Pilatu, “Ngadan di polo atu sa tuu?” Na, egoh i Pilatu mig-ikagi iya wé, eglaun dema eg-angay diyà sa medoo Hudiyu nesetipon. Guwaen di diyà kenagda, “Endà duen netiigan ku salà binaelan siini etaw. ");
INSERT INTO mta_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na, uman meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula, iya sa adat yu pelaunen ku diyà keniyu sa sebaen etaw nebilanggu hemilien yu. Meiyap yu pa atu lengaan ku diyà keniyu sa Sulutan diyà sa medoo Hudiyu?” ");
INSERT INTO mta_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dodoo egpetaled da eg-ikagi, guwaen da, “Beken iya wé. Si Balabas polo sa lengai ko diyà kenami.” Na, si Balabas sa etaw tegelampas. ");
INSERT INTO mta_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Agulé, igsugù i Pilatu igpetapes Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Egoh sa medoo sundalu ubus migtapes kenagdi, liningkal da sa belagen épê dugi owoy igsukub da diyà sa ulu di lagà sa metolol sayap sulutan. Igpekawal da ma kenagdi sa kawal melalegà lagà sa kawal sulutan. ");
INSERT INTO mta_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Agulé, egdapag da diyà kenagdi ubòubò da egdatù, guwaen da, “Meolò ka, kuna i Sulutan diyà sa etaw Hudiyu.” Hê, egtagpien da ma takà. ");
INSERT INTO mta_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Agulé, eglaun dema Pilatu i owoy eg-ikagi diyà sa medoo Hudiyu nesetipon. Guwaen di, “Taa yu, hih. Uwiten ku kagdi i diyà sa taengan yu anì metiigan yu endà duen sa salà di egketiigan ku.” ");
INSERT INTO mta_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Agulé egoh i Hésus miglaun, tapay doo nekesukub sa belagen épê dugi owoy egkawal ma sa melalegà kawal sulutan. Guwaen i Pilatu, “Kaini dé siini etaw.” ");
INSERT INTO mta_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dodoo, egoh da mighaa si Hésus sa medoo ulu-ulu tegesimbà owoy sa medoo tegebantay Dalesan i Nemula, egpetaled da eg-ikagi, guwaen da, “Peimatayi ko dé! Petutuki ko diyà sa kayu ibugsud.” Dodoo guwaen i Pilatu, “Kiyu polo sa agak kenagdi dutu owoy petutuki yu diyà sa kayu ibugsud. Enù ka aken, endà duen sa salà netiigan ku diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Agulé guwaen sa medoo Hudiyu, “Duen sa uledin ké igsugkow i Mosis tinipay siiya etaw. Huenan di, meimatayan enù ka guwaen di dò kagdi sa Anak i Nemula.” ");
INSERT INTO mta_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na, egoh i Pilatu migdineg iya wé inikagi da, tigtu nelimedangan temù. ");
INSERT INTO mta_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Egpelikù dema dalem sa dalesan di, owoy eg-igsaan di Hésus i, guwaen di, “Keduwan ko ya, kuna i?” Dodoo endà egsagbì Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Agulé, guwaen i Pilatu diyà kenagdi, “Maen di ya endà egsagbian ko aken? Taa ko. Duen sa egkegaga ku anì melaun ku kuna i, ataw ka ipetutuk ku kuna diyà sa kayu igbugsud.” ");
INSERT INTO mta_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Guwaen i Hésus egsagbì, “Endà duen sa megaga ko diyà kenak amuk beken si Nemula sa egbegay. Huenan di, sa etaw mig-agak kenak diyà keniko, uman pa dakel sa hagda salà diyà sa niko.” ");
INSERT INTO mta_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Na, egoh i Pilatu migdineg iya wé inikagi i Hésus, ungayà di lengaan di hedem. Dodoo, migpetaled da polo eg-ikagi sa medoo Hudiyu, guwaen da, “Amuk lengaan ko iya wé, kuna polo sa kuntelà i Sisal sa Sulutan ta. Enù ka amuk egpesulutan sa etaw iling kenagdi, iya sa kuntelà i Sulutan Sisal.” ");
INSERT INTO mta_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Egoh i Pilatu migdineg sa inikagi da, inuwit di dema Hésus i diyà sa duwangen owoy migpenuu diyà sa bangkù uwis diyà sa saeg batu, kepengadan etaw Hudiyu Gabata. ");
INSERT INTO mta_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Na egoh iya, buyu dé egpekebugsang sa agdaw, owoy simag meuma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. Agulé, eg-ikagi Pilatu i diyà sa medoo Hudiyu, guwaen di, “Kaini dé sa Sulutan yu.” ");
INSERT INTO mta_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Dodoo migpetaled da dema eg-ikagi, guwaen da, “Imatayi ko dé! Imatayi ko dé! Petutuki ko diyà sa kayu ibugsud.” Eg-igsà Pilatu i, “Enù di ya, meiyap yu amuk ipetutuk ku sa Sulutan yu diyà sa kayu ibugsud?” Guwaen sa medoo ulu-ulu tegesimbà, “Sebaen daa sa Sulutan ké, si Sisal diyà Loma.” ");
INSERT INTO mta_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Hê, inunutan i Pilatu sa hagda ungayà, owoy igbegay di Hésus i diyà kenagda anì ipetutuk da diyà sa kayu ibugsud. ");
INSERT INTO mta_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Na, eg-uwiten sa medoo sundalu Hésus i owoy igpetiang da kenagdi sa kayu kenà da itutuk kenagdi. Eglegkang da diyà Hélusalém eg-angay diyà sa tukééy getan kepengadan da Kulobong Ulu. Na, Golgota sa ngadan di diyà sa kagi Hibelu. ");
INSERT INTO mta_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dahiya sa kenà da migtutuk si Hésus diyà sa kayu igbugsud. Duen ma sa duwa maama igtutuk da dahiya, sa sebaen denu kuwanan di, sa sebaen denu bibang di, owoy teliwadà Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na, duen sa igsulat i Pilatu igtagù da diyà sa lekeatas ulu i Hésus. Iya sa kagi di, “Ini si Hésus tegeNasalét sa Sulutan diyà etaw Hudiyu.” ");
INSERT INTO mta_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hê, nekebasa sa medoo etaw iya wé, enù ka medapag diyà Hélusalém sa kenà i Hésus igtutuk diyà sa kayu igbugsud. Telu balangan kagi iya wé igsulat, sa kagi Hibelu owoy sa kagi etaw Loma owoy sa kagi Geligu. ");
INSERT INTO mta_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Agulé, egsigbolowen sa medoo ulu-ulu tegesimbà Pilatu i, guwaen da, “Maen di ya igsulat ko, ‘Ini sa Sulutan diyà etaw Hudiyu’? Mepion hedem amuk iya polo sa igsulat ko, ‘Siini etaw, guwaen di kagdi gaa sa Sulutan diyà etaw Hudiyu.’” ");
INSERT INTO mta_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Dodoo egsagbì Pilatu i, guwaen di, “Endà dé mepelumanan di iya wé igsulat ku.” ");
INSERT INTO mta_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na, egoh sa medoo sundalu ubus migtutuk si Hésus diyà sa kayu igbugsud, kinuwa da sa ginis di owoy binaed da epat baed sigbaenay kenagda. Kinuwa da ma sa metaes kawal di hinabel endà ginapà. ");
INSERT INTO mta_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Egseolomoy da, guwaen da, “Endà mepion di amuk lisien ta ini i, mepion polo sekusingay ki anì metiigan ta tayu sa mekekuwa.” Na, danà iya wé egbaelan da, neketuu dé sa kagi i Nemula igpesulat egoh anay, guwaen di, “Sebaeden da sa ginis ku, owoy sekusingen da ma sa kawal ku.” Hediya ma sa binaelan sa medoo sundalu diyà sa ginis i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, duen ma medoo bayi egtigdeg medapag diyà sa kenà i Hésus igtutuk. Dahiya sa inay di, owoy sa hadi inay di, owoy si Maliya sawa i Kelopas, owoy si Maliya tegeMagdala. ");
INSERT INTO mta_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Egoh i Hésus mighaa sa inay di owoy sa salu di eghiduwan di temù, eg-ikagi Hésus i diyà sa inay di, guwaen di, “O Inay, dahiya doo sa niko anak.” ");
INSERT INTO mta_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Agulé, guwaen di ma diyà sa salu di, “Dahiya doo sa inay ko.” Hê, edung egoh iya, egpeugpaen sa salu di sa inay i Hésus diyà sa dalesan di. ");
INSERT INTO mta_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na, netiigan i Hésus inubus di dé sa langun igpebael i Nemula diyà kenagdi. Agulé guwaen di, “Eglupahan a.” Na, danà iya wé inikagi di, neketuu dé sa kagi i Nemula igpesulat egoh anay denu kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na, duen sa butul dahiya nepenù wain inamutan wayeg. Ineled da sa tabung diyà sa wain, owoy igtagù da diyà sa panga kayu hisop. Agulé, igdugol da diyà sa ebà i Hésus anì metepes di. ");
INSERT INTO mta_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Egoh di migtepes, guwaen di, “Neubus dé langun.” Hê, egpetuyuh owoy nekedan ma dé sa ginawa di. ");
INSERT INTO mta_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Na, mig-angay sa medoo ulu-ulu Hudiyu diyà si Pilatu anì isugù di ipetepù sa lisen sa telu etaw igtutuk diyà sa kayu igbugsud anì medelamet da mematay. Enù ka ungayà da kedanan da sa lawa sa nematay diyà sa kayu igbugsud, enù ka mahapun Diyamat dé, owoy melihi diyà kenagda amuk diyà sa kayu igbugsud pelà sa nematay amuk Sapetu agdaw keetud da, owoy tigtu mapulù iya wé agdaw Sapetu enù ka iya ma sa Pista Sa Agdaw Kinetalà Sa Kepigtamay i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Huenan di, sinugù i Pilatu sa sundalu di. Hê, mig-angay da dutu owoy tinepù da sa lisen sa sebaen etaw duma i Hésus igtutuk. Agulé, tinepù da ma sa lisen sa sebaen ma duma di. ");
INSERT INTO mta_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Dodoo egoh da mig-angay diyà si Hésus, hinaa da nematay dé. Huenan di, endà tinepù da duu. ");
INSERT INTO mta_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Dodoo sa sebaen sundalu, tinebek di sigpù sa kabigan i Hésus. Hê, miglesut sa depanug owoy sa wayeg. ");
INSERT INTO mta_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Na, aken egsulat ini i sa mighaa sa langun kebael da si Hésus, owoy tuu ini i egtulonen ku diyà keniyu. Netiigan ku tuu ini i igsulat ku, owoy iya sa pesuwan ku egsulat anì mekepigtuu yu ma. ");
INSERT INTO mta_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Na, danà iya wé binaelan da diyà si Hésus, neketuu dé sa kagi i Nemula igpesulat, guwaen di, “Endà duen sebaen tuelan di metepù.” ");
INSERT INTO mta_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Duen ma sa kagi i Nemula igpesulat neketuu dé, guwaen di, “Hauwen etaw doo kagdi i tinebek sigpù.” ");
INSERT INTO mta_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na, duen sa etaw tegeAlimatiya, si Hosé, owoy kagdi ma sa mig-unut-unut diyà si Hésus, dodoo linidung di sa kepigtuu di enù ka nelimedangan di sa medoo ulu-ulu etaw Hudiyu. Agulé, inangay di egpegeni diyà si Pilatu sa lawa i Hésus anì ilebeng di. Agulé, pinandayà i Pilatu iya wé, huenan di inangay i Hosé sa lawa i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Na, iya sa duma i Hosé, si Nikodimu. Kagdi sa mig-angay eg-igsà diyà si Hésus sigep egoh anay. Inuwit di ma sa lima pulù kakilu kéen bulung mepion ngadeg, sa bulung kepengadan da mila ig-amut diyà sa bulung alos. ");
INSERT INTO mta_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Agulé, kinuwa da sa lawa i Hésus owoy binekut da sa mepion ginis mebulà owoy igpeunut da ma sa bulung mepion ngadeg, enù ka iya sa adat etaw Hudiyu amuk ilebeng da sa nematay. ");
INSERT INTO mta_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, duen sa hinemulaan kayu medapag diyà sa kenà i Hésus igtutuk diyà sa kayu igbugsud. Duen dahiya sa delama tinosongon etaw endà pa duen kenà di linebengan. ");
INSERT INTO mta_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Huenan di, iya sa kenà da eglebeng si Hésus, enù ka medapag diyà sa kenà di nematay owoy buyu ma meuma sa agdaw keetud da. ");
INSERT INTO mta_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na, egkawatkawat pelà magtu kesimag Akad, eg-angay Maliya tegeMagdala i dutu siedò kenà lebeng. Egoh di migtebow, hinaa di nekedan sa dakel batu igsagpeng lebeng. ");
INSERT INTO mta_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Agulé, egletu eg-angay diyà si Simon Pidelu owoy diyà sa salu i Hésus eghiduwan di temù. Eg-ikagi Maliya i diyà kenagda, guwaen di, “Kinedanan da dé sa lawa i Datù diyà sa lebeng. Endà netiigan ta duu sa kenà da migtagù.” ");
INSERT INTO mta_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Agulé, miglegkang Pidelu i owoy sa salu i Hésus eg-angay dutu siedò kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Egletu da duwa, dodoo nehunawan Pidelu i sa duma di salu i Hésus migtebow diyà sa kenà lebeng. ");
INSERT INTO mta_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Egoh di migtebow, sinalil di sa tosong lebeng owoy hinaa di sa mebulà ginis neketenà dahiya. Dodoo endà mig-awuh di dalem. ");
INSERT INTO mta_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Hê, migtebow ma Pidelu i, owoy mig-awuh dalem sa lebeng. Hinaa di sa mebulà ginis neketenà dahiya. ");
INSERT INTO mta_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Owoy hinaa di ma sa musala igpolot diyà sa ulu i Hésus, dodoo nekepeiges diyà sa mebulà ginis owoy tapay doo nelegpì. ");
INSERT INTO mta_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Agulé, eg-awuh ma dalem sa salu i Hésus nekehuna migtebow. Egoh di mighaa sa ginis neketenà dahiya, nekepigtuu sa egoh i Hésus mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Na egoh iya, endà pa netiigan sa medoo salu i Hésus sa kagi i Nemula igpesulat denu sa keenaw di egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hê, eglikù sa duwa salu di. ");
INSERT INTO mta_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na, si Maliya tegeMagdala, eg-ugpà diyà sa kilidan lebeng owoy egsinegaw. Egoh di telibubu egsinegaw, egkudung egsalil dalem sa lebeng. ");
INSERT INTO mta_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hê, hinaa di dahiya sa duwa egsugùsuguen i Nemula egginis mebulà temù. Egpenuu da diyà sa tapay kenà i Hésus igtenà, sebaen denu ulu di owoy sebaen denu lisen di. ");
INSERT INTO mta_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Eg-igsaan da Maliya i, guwaen da, “O Okon, maen ko ya egsinegaw?” Egsagbì, guwaen di, “Enù ka kinuwa da sa lawa sa Datù ku, owoy endà netiigan ku duu sa kenà da migtagù.” ");
INSERT INTO mta_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Agulé, egkiling Maliya i owoy eghauwen di Hésus i egtigdeg dahiya, dodoo endà egkilalaen di duu. ");
INSERT INTO mta_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Eg-igsà Hésus i, guwaen di, “O Okon, maen ko ya egsinegaw? Ngadan di etaw iya wé eglagbeten ko?” Dodoo iya sa agtem i Maliya kagdi sa tegeipat kayu hinemula, huenan di guwaen di diyà kenagdi, “Amuk kuna sa migkuwa sa lawa di, tulon ko diyà kenak sa kenà ko migtagù, enù ka angayen ku.” ");
INSERT INTO mta_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Agulé guwaen i Hésus, “O Maliya.” Hê, eg-isalu Maliya i diyà kenagdi, owoy guwaen di diyà sa kagi Hibelu, “Laboni.” Na, iya sa selepangan di, “Mistelu.” ");
INSERT INTO mta_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Dodoo guwaen i Hésus, “Yaka pelà egsabà kenak, enù ka endà pa nebatun a diyà si Emà. Dodoo, angay ko tulon diyà sa medoo duma ku lumikù a diyà si Nemula Emà ku. Kagdi sa Emà yu ma owoy sa Nemula yu ma.” ");
INSERT INTO mta_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Agulé, eg-angay Maliya tegeMagdala i diyà sa medoo salu i Hésus, owoy guwaen di, “Hinaa ku dé Datù ya giina.” Agulé, egtulonon di kagda sa langun inikagi i Hésus diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na, egoh di sigep Akad, nesetipon sa medoo salu i Hésus diyà sa dalesan pinebagel da egpintù enù ka nelimedangan da sa medoo ulu-ulu etaw Hudiyu. Apiya di pa nepintuan sa dalesan, petow dé migtigdeg Hésus i diyà teliwadà da, owoy guwaen di, “Kumelanih sa pedu yu.” ");
INSERT INTO mta_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Egoh di mig-ikagi iya wé, igpehaa di diyà kenagda sa kelaing belad di owoy sa kelaing kabigan di. Huenan di, tigtu da neanggan temù sa medoo salu di enù ka hinaa da Datù Hésus i. ");
INSERT INTO mta_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Agulé, guwaen i Hésus dema, “Kumelanih sa pedu yu. Pineangay i Emà ku aken egoh anay anì egtegudon a, hediya ma peangayen ku kiyu anì tumegudon yu ma.” ");
INSERT INTO mta_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hê, hiniyup di kagda owoy guwaen di, “Sakem yu dé sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amuk ipeuloy yu sa salà duma yu, mekepeuloy i Nemula ma sa salà di. Dodoo amuk endà ipeuloy yu duu sa salà di, endà ma ipeuloy i Nemula duu.” ");
INSERT INTO mta_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, si Tomas pinengadanan da si Seping sa sebaen maama diyà sa sepulù owoy duwa salu i Hésus. Endà dahiya di egoh i Hésus migpehaa diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Huenan di, eg-ikagi sa medoo duma salu di diyà si Tomas, guwaen da, “Hinaa ké dé Datù Hésus i.” Dodoo guwaen i Tomas, “Endà migtuu a neenaw dé Hésus i taman endà hauwen ku duu sa kelaing belad di danà tutuk, owoy itiyuk ku ma sa ketudù ku. Amuk endà ma egsabaan ku duu sa kelaing kabigan di, endà ma doo migtuu a.” ");
INSERT INTO mta_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na, egoh di neuma sakapadian, nesetipon dema sa medoo salu i Hésus diyà sa dalesan, owoy dahiya ma dé Tomas i. Apiya di pa pinebagel da egpintù sa dalesan, petow dé egtigdeg Hésus i diyà teliwadà da. Guwaen di, “Kumelanih sa pedu yu.” ");
INSERT INTO mta_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Agulé eg-ikagi diyà si Tomas, guwaen di, “Haa ko sa belad ku. Tiyuki ko sa ketudù ko diyà sa kelaing ku, owoy sabai ko ma sa kelaing kabigan ku. Yaka dé egkeduwa sa pedu ko, dodoo pigtuu ka polo.” ");
INSERT INTO mta_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Hê, guwaen i Tomas, “Kuna sa Datù ku owoy sa Nemula ku ma.” ");
INSERT INTO mta_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Agulé guwaen i Hésus, “Egpigtuu ka dé danà ko mighaa kenak ini egoh di. Dodoo uman pa meanggan sa medoo etaw migtuu, apiya di pa endà hauwen da duu aken.” ");
INSERT INTO mta_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na, duen ma sa medoo liyu panduan binaelan i Hésus hinaa ké, kami i salu di. Dodoo endà igsulat ku duu diyà siini libelu sa langun hinaa ké. ");
INSERT INTO mta_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Huenan di, igsulat ku ini i anì migtuu yu si Hésus sa Tigtu Datù sinugù i Nemula owoy kagdi sa Anak i Nemula. Amuk egpigtuu yu diyà kenagdi, melalù yu taman melugay. ");
INSERT INTO mta_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Na sebaen agdaw, egpehaa dema Hésus i diyà sa medoo salu di diyà sa mantadan Lanaw Tibiliyas. Ini sa ukit tulon denu sa kepehaa di diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nesetipon sa medoo salu di. Dahiya si Simon Pidelu, owoy si Tomas pinengadanan da si Seping, owoy si Natanayél tegeKana diyà uwang Galiliya, owoy sa duwa anak i Sébediyu, owoy duen ma sa duwa salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Agulé, eg-ikagi Simon Pidelu i diyà sa medoo duma di salu i Hésus, guwaen di, “Mangay a muket.” Guwaen sa medoo duma di, “Munut ké ma keniko.” Agulé, mig-edà da kumpit. Dodoo apiya di pa neelut da sigep egpuket, endà duen sa nekuwa da sedà. ");
INSERT INTO mta_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Agulé, egoh di egteleséng sa agdaw, egtigdeg Hésus i diyà sa mantadan, dodoo endà egkilalaen sa medoo salu di duu. ");
INSERT INTO mta_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Agulé, eg-umowen i Hésus kagda, guwaen di, “O Akay, duen pa sa nekuwa yu?” Guwaen da egsagbì, “Endà duen di.” ");
INSERT INTO mta_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Agulé guwaen i Hésus, “Nabù yu dema sa puket denu kuwanan yu anì mekekuwa yu.” Hê, egnabuen da dema, dodoo egoh da egbatun, endà egkehenat da duu enù ka medoo temù sa sedà nekuwa da. ");
INSERT INTO mta_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na, sa salu di eghiduwan i Hésus temù, eg-ikagi diyà si Pidelu, guwaen di, “Ay, si Datù iya wé.” Agulé, egoh i Pidelu neketiig si Hésus iya wé, egkawal dema enù ka endà migkawal di egoh di egpuket. Agulé, miglaway diyà wayeg anì medelamet tumebow diyà sa mantadan. ");
INSERT INTO mta_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Dodoo sa medoo duma di salu i Hésus, egpekehudi da egdunggù enù ka diyà da kumpit. Eggodoyen da sa puket da nepenù sedà, enù ka medapag da dé diyà mantadan. Iya kediyù da ya kéen siyow pulù kamitelu. ");
INSERT INTO mta_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Egoh da migtenà diyà mantadan, hinaa da sa epan owoy sa bagaꞌt apuy kenà sa sedà tinueg. ");
INSERT INTO mta_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Agulé, guwaen i Hésus diyà kenagda, “Uwit yu dini sa duma sedà nekuwa yu giina.” ");
INSERT INTO mta_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Agulé, mig-angay dema Simon Pidelu i diyà sa kumpit, enù ka eggodoyen di diyà mantadan sa puket nepenù sedà anan dakel. Iya sa kedoo sedà nekuwa da magatus lima pulù owoy telu. Apiya di pa medoo sa sedà nekuwa da, endà ma nelisì sa puket. ");
INSERT INTO mta_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Agulé guwaen i Hésus diyà kenagda, “Téél yu, kumaen ki dé.” Na, endà duen etaw eg-igsà sa ngadan di, enù ka netiigan da doo kagdi si Datù. ");
INSERT INTO mta_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Agulé, mig-angay Hésus i egkuwa sa epan, owoy itukidtukid di igbegay diyà kenagda. Diya ma sa binaelan di diyà sa tinueg sedà. ");
INSERT INTO mta_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na, iya sa ketelu di gulê egpehaa Hésus i diyà sa medoo salu di edung sa egoh di mig-enaw egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na, egoh da ubus egkaen, eg-igsà Hésus i diyà si Simon Pidelu, guwaen di, “O Simon anak i Huwan, enù di ya, uman pa dakel sa niko kehidu kenak diyà sa kehidu sa medoo duma ko?” Egsagbì Pidelu i, guwaen di, “Hoò, Datù. Netiigan ko dé eghiduwan ku kuna.” Agulé guwaen i Hésus, “Ipat ko, hih, sa medoo etaw ku lagà da nati kebilibili ku.” ");
INSERT INTO mta_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Eg-igsà dema Hésus i, guwaen di, “O Simon anak i Huwan, mehidu ka pa kenak?” Guwaen i Pidelu egsagbì, “Hoò, Datù. Netiigan ko doo eghiduwan ku kuna.” Guwaen i Hésus, “Ipat ko, hih, sa medoo etaw ku lagà sa kebilibili ku.” ");
INSERT INTO mta_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Agulé, eg-igsà dema Hésus i sa ketelu di gulê, guwaen di, “O Simon anak i Huwan, eghiduwan ko pa aken temù?” Hê, egkebukul sa pedu i Pidelu enù ka telu gulê dé sa keigsà i Hésus amuk eghiduwan di. Huenan di, guwaen i Pidelu, “O Datù, netiigan ko doo langun. Netiigan ko ma eghiduwan ku kuna.” Agulé guwaen i Hésus diyà kenagdi, “Ipat ko dé sa medoo etaw ku lagà sa kebilibili ku. ");
INSERT INTO mta_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tuu ini i eg-ikagiyen ku diyà keniko. Egoh anay egoh ko batàbatà pelà, egpekekawal ka owoy egpekehemilì ka ma sa angayan ko. Dodoo amuk kumelukes ka, mekelipo ka owoy poloten ka owoy meagak ka ma diyà sa kenà ko endà meiyap.” ");
INSERT INTO mta_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na, iya sa inikagi i Hésus anì ipetiig di sa ukit kepatay i Pidelu anì meolò Nemula i. Agulé, guwaen i Hésus diyà kenagdi, “Unut-unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Agulé, egtuing Pidelu i owoy hinaa di hudihudi siedò salu i Hésus eghiduwan di temù. Iya sa salu i Hésus migdapag diyà kenagdi egoh da migkaen egoh di endà pa nematay owoy sa mig-igsà diyà kenagdi ngadan tayu di etaw diyà kenagda sa tumampil diyà sa medoo kuntelà di. ");
INSERT INTO mta_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na, egoh i Pidelu mighaa kenagdi, eg-igsà, guwaen di, “O Datù, ngadan sa mebaelan siini duma ta kani?” ");
INSERT INTO mta_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Egsagbì Hésus i, guwaen di, “Upama, amuk iya sa ungayà ku endà mematay di taman endà pelikù a diyà tanà, endà duen niko ya dahiya. Dodoo kuna, unut-unut ka daa kenak.” ");
INSERT INTO mta_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Agulé, nekedineg sa medoo etaw egpigtuu denu iya wé inikagi i Hésus, huenan di guwaen da dò endà dé mematay di iya wé salu di. Dodoo, beken iya sa inikagi i Hésus endà dé mematay di, dodoo ini polo sa inikagi di, guwaen di, “Upama, amuk iya sa ungayà ku endà mematay di taman endà pelikù a diyà tanà, endà duen niko ya dahiya.” ");
INSERT INTO mta_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Na, aken iya wé salu di inikagi di. Aken sa migtulon langun ini i owoy aken ma sa migsulat ini i. Na, netiigan ké tuu doo ini i igsulat ku. ");
INSERT INTO mta_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na, duen pa sa medoo liyu binaelan i Hésus endà nekesulat ku duu dahini. Upama, amuk mekesulat sa langun binaelan di, iya sa antap ku kulang pa sa kedakel siini uwang tanà taguan sa langun libelu denu si Hésus.");
INSERT INTO mta_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Akay Tiyopilu, egoh ku anay migsulat diyà keniko, tinulon ku sa langun binaelan i Hésus owoy sa igtulù di ma edung sa egoh di anay egtulù ");
INSERT INTO mta_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","taman sa egoh di nebatun dutu langit dò. Egoh di neenaw dema egoh di nematay, takà egpehaa Hésus i diyà sa medoo salu di hinemilì di owoy tinulù di ma kagda denu sa kedatù i Nemula. Taman epat pulù agdaw, takà egpehaa Hésus i diyà kenagda. Huenan di, tigtu egketiigan da nehagtay dema Hésus i enù ka hinaa da kagdi. Egoh di endà pa nebatun dutu langit dò, tinulù di kagda danà sa egkegaga sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na, sebaen agdaw egoh da nesetipon, eg-ikagi Hésus i diyà sa medoo salu di, guwaen di, “Ugpà yu diyà Hélusalém. Angati yu sa ketuu sa igpasad i Nemula, sa tapay tinulon ku diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Egoh anay migbautis si Huwan sa medoo etaw diyà wayeg anì tandaan da sa kepigtuu da. Dodoo endà melugay di iya sa ibautis i Nemula keniyu sa Metiengaw Suguy di lumuhub diyà keniyu.” ");
INSERT INTO mta_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Na, egoh sa medoo salu i Hésus nesetipon dema, eg-igsà da diyà kenagdi, guwaen da, “O Datù, enù di ya, ini egoh di sa agdaw egoh ko humemaga sa etaw beken Hudiyu egkedatù diyà kenita, anì ipelikù ko sa kedatù ta diyà sa duma ta tugod i Islaél?” ");
INSERT INTO mta_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Egsagbì Hésus i, guwaen di, “Endà metiigan yu duu sa atas di, enù ka si Emà ta Nemula daa sa meketiig iya wé danà sa hagdi egkegaga. ");
INSERT INTO mta_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Dodoo yoko egkelipeng duu ini i. Amuk tumebow sa Metiengaw Suguy i Nemula diyà keniyu, tunungan yu anì meketulù yu denu kenak diyà Hélusalém, owoy diyà sa langun menuwa diyà uwang Hudiya owoy uwang Samaliya, owoy taman siini sinukub langit.” ");
INSERT INTO mta_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Egoh di neubus eg-ikagi, egkebatun Hésus i dutu langit dò. Egoh da eghaa, nekedilung dé Hésus i diyà gaeb owoy endà dé hinaa da duu. ");
INSERT INTO mta_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ligò di egkebatun, eglengag da eg-inengteng diyà langit. Petow dé duen sa duwa egsugùsuguen i Nemula migkawal mebulà migtebow diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Eg-ikagi da, guwaen da, “O medoo tegeGaliliya, yoko eglengag ga. Nebatun Hésus i miglikù dutu langit dò. Dodoo pelikù mendaa diyà tanà éhê mendaa sa kehaa yu egoh di nebatun dutu langit dò.” ");
INSERT INTO mta_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Agulé, miglikù sa medoo salu i Hésus dutu Hélusalém dò kedu diyà Getan Olibu. Sakakilumitelu kéen sa kediyù di kedu diyà Hélusalém. ");
INSERT INTO mta_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na, egoh sa medoo salu i Hésus migtebow diyà Hélusalém, nesetipon da diyà sa bilik dalesan kenà da eg-ugpà. Ini sa nesetipon, si Pidelu owoy si Huwan owoy si Santiyago owoy si Andelis, si Pilipi owoy si Tomas, si Baltolomi owoy si Matéyo, owoy sa sebaen ma Santiyago anak i Alpiyo, owoy sa sebaen ma Simon sa mebagel eghemalang sa tanà Hudiya, owoy sa sebaen Hudas anak sa sebaen Santiyago. ");
INSERT INTO mta_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Takà da egkesetipon owoy nesesebaen sa pedu da langun amuk egsimbà da. Nesetipon ma sa medoo bayi dahiya, owoy sa medoo hadi i Hésus owoy sa inay di ma, si Maliya. ");
INSERT INTO mta_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Na, sebaen agdaw nesetipon sa medoo etaw egpigtuu, duen kéen magatus duwa pulù sa kedoo da. Egtigdeg Pidelu i owoy eg-ikagi, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“O medoo loyuk ku, neketuu dé sa kagi igpesulat sa Suguy i Nemula diyà si Dabid egoh anay denu si Hudas sa eg-enggat sa medoo etaw anì egsigkemen da Hésus i. ");
INSERT INTO mta_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Si Hudas sa duma ké, enù ka kagdi ma sa hinemilì i Hésus anì mulig diyà sa galebek ké.” ");
INSERT INTO mta_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, duen sa pilak kinuwa i Hudas danà sa binaelan di medaet, owoy iya sa igbeli di tanà. Agulé migpetoyò Hudas i. Hê, nenabù owoy nebetù sa getek di. ");
INSERT INTO mta_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Netiigan sa langun etaw tegeHélusalém iya wé binaelan di. Huenan di, egpengadanan da sa tanà di, Akildama, enù ka iya sa selepangan di, tanà binayadan di depanug. ");
INSERT INTO mta_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Eg-ikagi dema Pidelu i, guwaen di, “Neketuu dé sa kagi i Dabid igsulat egoh anay diyà sa libelu ta Isalem, guwaen di, ‘Meigtohon sa dalesan di. Endà dumuen etaw mugpà dahiya.’ Duen ma sa kagi i Nemula igpesulat diyà sa libelu Isalem, guwaen di, ‘Pesambì sa sebaen etaw sa galebek di.’ ");
INSERT INTO mta_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Na, mepion amuk hemilien ké sa sebaen etaw munut kenami sa mighaa si Datù Hésus nehagtay dema egoh di nematay. Mepion ma amuk kagdi sa duma ké takà mig-unut kenami edung sa egoh i Hésus migpebautis diyà si Huwan taman sa egoh di nebatun langit dò.” ");
INSERT INTO mta_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Agulé, hinemilì da sa duwa maama, si Matiyas owoy si Hosé. Iya ma sa ngadan i Hosé, si Balsabas owoy si Husto. ");
INSERT INTO mta_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Agulé egsimbà da, guwaen da, “O Datù ké, netiigan ko sa pedu sa langun etaw. Huenan di, petiigi ko diyà kenami sa tayu di etaw hinemilì ko ");
INSERT INTO mta_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","mekesambì si Hudas anì dumuen sa sebaen ma salu egbulig kenami, enù ka sinalidan i Hudas sa galebek di danà di mig-angay diyà sa hagdi kenà sa ketamanan sa langun etaw tegebael medaet.” ");
INSERT INTO mta_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Agulé egoh da migsimbà, egkusing da eghemilì. Hê nehemilì Matiyas i. Agulé, pineunut da kagdi diyà sa sepulù owoy sebaen salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Na, egoh di neuma sa agdaw sa Pista Pintikostis, nesetipon diyà sa sebaen dalesan sa langun etaw egpigtuu diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Petow dé duen sa dagì dinineg da kedu langit dò éhê delegdeg kelamag. Nebelet dagì di sa dalesan kenà da nesetipon. ");
INSERT INTO mta_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Agulé, hinaa da sa éhê legleg apuy nepalak owoy netukid sa pulu sa langun etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hê, migluhub sa Metiengaw Suguy i Nemula diyà kenagda. Mig-edung da eg-ikagi sa medoo balangan kagi endà netiigan da duu, enù ka egpeikagiyen sa Metiengaw Suguy i Nemula kagda. ");
INSERT INTO mta_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, duen medoo metiengaw etaw Hudiyu kedu diyà sa langun balangan tanà eg-ugpà diyà menuwa Hélusalém. ");
INSERT INTO mta_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Egoh da migdineg sa metaled kagi, medoo da nesetipon. Negaip da temù, enù ka egkedineg sa uman sebaen etaw sa hagdi balangan kagi inikagi sa medoo etaw egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tigtu da negaip temù sa medoo etaw egdineg, owoy eg-ikagi da, guwaen da, “Anan tegeGaliliya ini i medoo etaw eg-ikagi. ");
INSERT INTO mta_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Maen di ya megaga da mikagi sa tapay kagi ta? ");
INSERT INTO mta_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Medoo sa keduwan ta, enù ka duen etaw dahini tegePaletiya, owoy etaw tegeMidiya, owoy etaw tegeIlam. Duen ma etaw kedu Misopotamiya, owoy etaw tegeHudiya, owoy etaw kedu Kapadosiya, owoy etaw kedu Ponto, owoy etaw kedu Asiya. ");
INSERT INTO mta_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Duen ma etaw kedu Peligiya, owoy etaw kedu Pampiliya, owoy etaw kedu Igiptu, owoy etaw kedu uwang Libiya medapag diyà Silini. Duen ma etaw kedu Loma, etaw Hudiyu owoy etaw beken Hudiyu egpangunut diyà sa adat Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Duen ma etaw kedu Kelita, owoy etaw kedu Alabiya. Dodoo egdinegen ta langun diyà sa medoo balangan kagi ta sa tinulon sa medoo etaw tegeGaliliya denu sa mepion binaelan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Na, tigtu da negaip temù owoy egkebogo sa penemdem da. Egseigsaay da, guwaen da, “Ngadan sa selepangan ini i?” ");
INSERT INTO mta_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Dodoo duen ma liyu etaw egpeumàumà sa medoo etaw egpigtuu, guwaen da, “Eghiluwen da dé danà da eg-inem wain.” ");
INSERT INTO mta_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Agulé, egtigdeg da Pidelu i owoy sa sepulù owoy sebaen salu i Hésus. Egpetaled Pidelu i eg-ikagi, guwaen di, “O medoo etaw Hudiyu owoy sa kedoo yu eg-ugpà diyà Hélusalém, dinegdineg yu, hih, enù ka duen sa tulonen ku diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sa penemdem yu guwaen yu dò eghiluwen ké wain, dodoo endà eghiluwen ké enù ka endà pa meedup sa agdaw. ");
INSERT INTO mta_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Dodoo tigesa sa medoo hinaa yu giina, enù ka neketuu dé ini egoh di sa medoo kagi igsulat i Howil sa tegesugkow i Nemula egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ini sa kagi i Nemula. Amuk buyu meuma sa sabuhanan agdaw, ipeluhub ku sa Suguy ku diyà sa langun etaw. Tumulon sa medoo anak yu, maama owoy bayi, sa kagi ku egtebowtebow diyà kenagda. Dumuen sa ipehaa ku diyà sa medoo batàbatà maama diyà keniyu. Tegeinepen ma sa medoo lukes maama diyà keniyu sa ipehaa ku kenagda. ");
INSERT INTO mta_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tuu ini i. Amuk meuma iya wé, ipeluhub ku sa Suguy ku diyà sa medoo etaw egpangunut diyà kenak, iling ka maama ataw ka bayi, owoy tumulon da sa kagi ku egtebowtebow diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ipehaa ku sa medoo panduan diyà awang, owoy dumuen ma sa medoo egkegaipan etaw diyà tanà. Dumuen sa depanug owoy sa apuy owoy sa mekepal ebel. ");
INSERT INTO mta_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dumeleman sa agdaw owoy kumelalegà sa bulan mekeiling depanug amuk buyu tumebow siedò agdaw ku sumambì sa tanà. Megaipan sa langun etaw owoy oloen da aken danà siedò agdaw ku hauwen da. ");
INSERT INTO mta_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dodoo mealukan doo sa langun etaw umumow diyà si Datù.’ ");
INSERT INTO mta_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Na, o medoo duma ku tugod i Islaél, dinegdineg yu, hih, sa eg-ikagiyen ku diyà keniyu. Si Hésus tegeNasalét sa Tigtu Datù sinugù i Nemula diyà tanà. Iya sa tandà di kagdi sa pineangay i Nemula sa medoo tandà hinaa yu owoy sa medoo panduan igpebael i Nemula diyà kenagdi. Netiigan yu dé enù ka diyà keniyu sa egoh di egbael iya wé. ");
INSERT INTO mta_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Tapay dé netiigan i Nemula sa kebael yu si Hésus, dodoo danà doo sa ungayà i Nemula sa kesigkem yu kenagdi. Igsugù yu Hésus i igpetutuk diyà sa medoo etaw tegebael salà anì ipeimatay yu kagdi. ");
INSERT INTO mta_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dodoo inenaw i Nemula mendaa egoh di nematay. Linaun di sa anak di kedu diyà sa lebeng di enù ka endà mekeatu sa kepatay etaw diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Egoh anay migsulat Dabid i denu si Hésus, guwaen di, ‘Netiigan ku takà eg-unut kenak Nemula i. Denu kuwanan ku anì egbulig kenak, huenan di endà mebogo a. ");
INSERT INTO mta_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Iya maen di ya tigtu neiyap sa pedu ku owoy oloen ku Nemula i. Apiya di pa nematay sa lawa ku, duen doo sa mepion eg-angat-angatan ku, ");
INSERT INTO mta_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","enù ka netiigan ku endà tangtangen di sa suguy ku dutu bayà dò. Owoy endà mebaluy di diyà kenagdi amuk meledak sa lawa ku, enù ka hinemilì di aken. ");
INSERT INTO mta_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Igpetiig di diyà kenak dumuen sa lalù ku endà meelut di. Tigtu mepion sa pedu ku enù ka takà eg-unut diyà kenak.’ ");
INSERT INTO mta_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“O medoo loyuk ku, metumàmà sa kagi ku diyà keniyu denu sa tupù ta si Dabid. Egoh anay nematay Dabid i owoy iglebeng dé dalem sa batu tinosongon etaw. Tapay doo duen sa lebeng di diyà kenita taman ini egoh di. ");
INSERT INTO mta_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dodoo egoh i Dabid endà pa nematay, kagdi sa tegesugkow i Nemula owoy netiigan di sa igpasad i Nemula diyà kenagdi. Igpasad i Nemula dumuen sa sebaen tugod di kumedatù iling sa kedatù di. ");
INSERT INTO mta_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Egoh anay netiigan i Dabid sa baelan i Nemula, huenan di migtulon denu sa keenaw sa Tigtu Datù sinugù i Nemula, guwaen di, ‘Endà metangtang di dutu bayà dò, owoy endà ma meledak sa lawa sa etaw hinemilì di.’ ");
INSERT INTO mta_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Na, netiigan ké mig-ikagi Dabid i denu si Hésus, enù ka inenaw i Nemula Hésus i egoh di nematay owoy hinaa ké langun sa egoh di nehagtay dema. ");
INSERT INTO mta_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pinedakel i Nemula kagdi owoy pinepenuu di denu kuwanan di. Pinetuu di dé sa igpasad di diyà kenagdi sa kepeangay di sa Metiengaw Suguy di diyà kenita, owoy iya sa hinaa yu giina owoy sa dinineg yu ma. ");
INSERT INTO mta_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na, beken sa lawa i Dabid sa nebatun dutu langit dò, dodoo si Hésus polo sa nebatun. Egoh anay igsugkow i Dabid sa kagi i Nemula, guwaen di, ‘Mig-ikagi Nemula i diyà sa Datù ku, guwaen di, Penuu ka dahini denu kuwanan ku ");
INSERT INTO mta_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","taman atuwan ku sa medoo kuntelà ko owoy ipeutuh ku keniko.’ ");
INSERT INTO mta_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Na, o medoo tugod i Islaél, apiya di pa inimatayan yu Hésus i egoh yu migtutuk kenagdi diyà sa kayu igbugsud, ipetiig ké doo diyà keniyu kagdi sa hinemilì i Nemula sa Datù ta owoy sa Tigtu Datù sinugù di diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na, egoh sa medoo etaw migdineg sa inikagi i Pidelu, tigtu nebogo sa pedu da. Eg-igsà da diyà kenagdi owoy sa duma salu i Hésus, guwaen da, “O Akay, ngadan sa mebaelan ké, kami i?” ");
INSERT INTO mta_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Egsagbì Pidelu i, guwaen di, “Ekedi yu dé sa salà yu owoy pebautis yu anì metandaan di sa kepigtuu yu diyà si Hésus Kelistu. Amuk egpigtuu yu, ipeuloy i Nemula sa medoo salà yu owoy mesakem yu sa Metiengaw Suguy i Nemula ibegay di diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Egoh anay igpasad i Datù ta Nemula ibegay di sa Suguy di diyà keniyu owoy diyà sa medoo tugod yu owoy diyà sa medoo etaw mediyù, enù ka begayan di sa langun etaw igsasà di anì migtuu da.” ");
INSERT INTO mta_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na, medoo ma sa kagi i Pidelu diyà kenagda. Isasà di kenagda, guwaen di, “Yoko eg-unut ta diyà sa duma yu tegebael medaet anì endà mepigtamayan yu.” ");
INSERT INTO mta_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Agulé, medoo sa etaw egpigtuu sa kagi i Pidelu owoy egpebautis da ma. Duen buyu telu ngibu etaw egpigtuu egoh iya wé agdaw, owoy nekeunut da sa medoo muna egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Takà da egdinegdineg sa ketulù sa medoo salu i Hésus. Egseamutay sa medoo etaw egpigtuu, owoy nesetipon da amuk egsimbà da diyà si Nemula owoy amuk eg-ilingan da sa ketepitepi epan sa ketulù i Hésus kenagda. ");
INSERT INTO mta_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Na, duen medoo panduan owoy medoo tandà egkegaipan etaw egbaelan sa medoo salu i Hésus. Huenan di, tigtu negaip sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Takà egkesetipon sa langun etaw egpigtuu owoy nesesebaen sa pedu da. Huenan di, egsebegayay da sa medoo langun taman da. ");
INSERT INTO mta_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Egdagangen da ma sa tanà da owoy sa medoo langun taman da, owoy itukid da ibegay sa pilak da diyà sa duma da egkepasangan. ");
INSERT INTO mta_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Egkesetipon da uman agdaw diyà sa Dalesan i Nemula, owoy eg-angay da egkaen diyà sa hagda dalesan. Tigtu neanggan da egoh da neseunut egkaen. ");
INSERT INTO mta_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Eg-oloen da takà Nemula i, owoy netuuwan sa medoo liyu etaw diyà kenagda. Uman agdaw egkeumanan sa kedoo etaw eg-alukan i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na sebaen agdaw, eg-angay Pidelu i owoy si Huwan diyà sa Dalesan i Nemula egoh di alas telu dé mahapun, enù ka iya sa ulas da egsimbà. ");
INSERT INTO mta_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Duen sa maama pikat inuwit di miglesut sa kepikatan di egpenuu diyà sa bengawan sa Dalesan i Nemula kepengadan da sa Metolol Pintuan. Uman agdaw eg-uwiten sa medoo duma di anì megeni pilak diyà sa medoo etaw eggemow dahiya. ");
INSERT INTO mta_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Egoh di mighaa si Pidelu owoy si Huwan eggemow diyà sa Dalesan i Nemula, egpegeni pilak diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Agulé egoh da eghaa sa pikat, guwaen i Pidelu diyà kenagdi, “Inengteng ko kami.” ");
INSERT INTO mta_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Huenan di, eghahaa sa pikat diyà kenagda enù ka eg-angat-angat pilak diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dodoo guwaen i Pidelu, “Endà duen pilak ku, dodoo begayan ku kuna sa mekebegay ku. Huenan di, danà sa tunung i Hésus Kelistu tegeNasalét, bigkat ka dé.” ");
INSERT INTO mta_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Agulé, egsabaan i Pidelu sa belad di denu kuwanan owoy pinetigdeg di. Hê, petow dé nebegeng sa lisen di owoy migkebagel ma dé. ");
INSERT INTO mta_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Huenan di, egtigdeg owoy egbigkatbigkat. Agulé, eg-unut diyà si Pidelu owoy si Huwan lumudep diyà sa Dalesan i Nemula. Egbigkatbigkat owoy egsautsaut owoy eg-oloen di ma Nemula i. ");
INSERT INTO mta_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eghauwen sa langun etaw dahiya sa maama egbigkat owoy eg-olò si Nemula. ");
INSERT INTO mta_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Egkilalaen da kagdi sa etaw takà egpegeni pilak diyà sa Metolol Pintuan sa Dalesan i Nemula. Huenan di, tigtu negaip da enù ka hinaa da nekebigkat dé sa pikat. ");
INSERT INTO mta_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, egoh i Pidelu owoy si Huwan diyà sa luglug Dalesan i Nemula kepengadan da Luglug i Salomon, egsabà pelà diyà kenagda sa maama nelikuan danà di neanggan temù. Agulé, egletu sa medoo etaw eg-angay diyà kenagda enù ka tigtu da negaip. ");
INSERT INTO mta_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Egoh i Pidelu mighaa sa medoo etaw nesetipon, eg-ikagi, guwaen di, “O medoo duma ku tugod i Islaél, yoko egkegaip duu sa hinaa yu. Yoko eg-inengteng duu kami, enù ka beken danà sa nami tunung sa nekegaga egbulung siini maama, owoy beken ma danà sa ketiengaw ké. ");
INSERT INTO mta_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dodoo si Nemula sinaligan sa tupù ta si Ablaham owoy si Isak owoy si Hakob, kagdi polo sa nekegaga egbulung siini maama. Binulungan di kagdi anì meolò Hésus i pineangay di diyà tanà. Dodoo kiyu, igbegay yu Hésus i diyà sa egkegaga i Gubilenu Pilatu. Apiya di pa ungayà i Pilatu lengaan di Hésus i, hinawidan yu polo anì meimatayan sa pineangay i Nemula diyà kenita. ");
INSERT INTO mta_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Apiya di pa metiengaw Hésus i owoy endà duen salà di, inekedan yu doo. Migpegeni yu polo diyà si Pilatu anì lengaan di sa sebaen etaw tegeimatay. ");
INSERT INTO mta_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Igpeimatay yu polo Hésus i, sa egbegay lalù endà meelut di diyà sa langun etaw, dodoo inenaw i Nemula kagdi i egoh di nematay. Tuu iya wé, enù ka hinaa ké kagdi i egoh di mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Danà sa tunung i Hésus, nelikuan dé siini maama hinaa yu owoy kinilala yu. Danà di migpigtuu diyà si Hésus, nelikuan dé owoy nekebigkat ma dé, owoy iya sa hinaa yu ini egoh di. ");
INSERT INTO mta_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“O medoo duma ku, netiigan ku doo inimatayan yu lapeg sa medoo ulu-ulu yu Hésus i, enù ka endà netiigan yu duu kagdi sa Tigtu Datù sinugù i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dodoo danà iya wé kebael yu, igpetuu i Nemula sa kagi di igsugkow sa medoo tegesugkow di egoh anay, guwaen da, ‘Meimatayan sa Tigtu Datù peangayen i Nemula diyà tanà.’ ");
INSERT INTO mta_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Huenan di, ekedi yu dé sa medoo salà yu owoy pangunut yu diyà si Nemula anì ipeuloy di sa salà yu. ");
INSERT INTO mta_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Amuk hediya sa baelan yu, kumelanih sa pedu yu danà i Datù Nemula owoy pelikuen di ma Hésus i sa Tigtu Datù hinemilì di. ");
INSERT INTO mta_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Dodoo mugpà pelawà dutu langit dò taman sa egoh i Nemula meluman sa langun taman, enù ka iya sa igpasad di igpesugkow di diyà sa medoo tegesugkow di egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Egoh anay, mig-ikagi Mosis i diyà sa medoo tugod i Islaél, guwaen di, ‘Peangayen i Datù Nemula sa sebaen tegesugkow di diyà keniyu, éhê mendaa sa kinepeangay di kenak. Kagdi ma sa tugod yu. Dinegdineg yu sa langun tulonen di diyà keniyu. ");
INSERT INTO mta_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Amuk duen etaw endà egpangunut diyà sa eg-ikagiyen di, iya sa etaw beken etaw i Nemula owoy mekesugsug ma.’ ");
INSERT INTO mta_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Na, sa langun tegesugkow i Nemula egoh anay, si Samuwél owoy sa medoo nekehudihudi kenagdi, anan da egtulon denu sa ketebow i Hésus Kelistu. Hê, neketuu dé ini egoh di sa kagi da egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kita ma sa pinasadan i Nemula, enù ka tinulon sa medoo tegesugkow di sa pasad di diyà kenita. Neketuu dé ini egoh di sa pasad di diyà sa medoo tupù ta, enù ka mig-ikagi Nemula i diyà si Ablaham egoh anay, guwaen di, ‘Mesugkudan sa langun etaw diyà tanà danà sa sebaen tugod ko.’ ");
INSERT INTO mta_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Huenan di, kita sa muna pineangayan i Nemula si Hésus anì tabangan di kita amuk ekedan ta sa salà ta.” ");
INSERT INTO mta_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Na, egoh i Pidelu owoy si Huwan eg-ikagi pelà diyà sa medoo etaw nesetipon, duen migtebow diyà kenagda sa medoo tegesimbà owoy sa ulu-ulu sa medoo tegebantay Dalesan i Nemula. Duen ma medoo etaw Sadusiyu eg-unut kenagda. Na, iya sa penemdem etaw Sadusiyu endà dé umenaw gaa sa etaw nematay. ");
INSERT INTO mta_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Huenan di, egbulit da, enù ka egtulù Pidelu i owoy si Huwan mig-enaw Hésus i egoh di nematay, huenan di mebaluy doo umenaw sa langun etaw nematay. ");
INSERT INTO mta_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Hê, egsigkemen da Pidelu i owoy si Huwan. Egbilangguwen da kagda segdu enù ka mahapun dé owoy ungayà da igsaan da kagda amuk umenaw simag. ");
INSERT INTO mta_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dodoo egpigtuu dé sa medoo etaw migdineg sa inikagi i Pidelu owoy si Huwan. Buyu lima ngibu dé sa kedoo maama egpigtuu diyà si Hésus, lapeg sa tapay egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Na, egoh di umenaw simag, egkesetipon diyà Hélusalém sa medoo ulu-ulu etaw Hudiyu owoy sa medoo kaunutan Hudiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dahiya ma Anas i sa Tigtu Ulu-ulu Tegesimbà, owoy si Kayipas, owoy sa sebaen Huwan, owoy si Alihandelo, owoy sa medoo tigtu duma i Anas. ");
INSERT INTO mta_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Agulé, egpetigdegen da Pidelu i owoy si Huwan diyà sa taengan da, owoy eg-igsaan da kagda, guwaen da, “Enù di ya sa kebael yu? Ngadan di etaw sa egbegay tunung diyà keniyu? Ngadan di etaw sa eg-ingadanan yu anì megaga yu mulung sa pikat?” ");
INSERT INTO mta_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Agulé, linuhub sa Metiengaw Suguy i Nemula Pidelu i owoy egsagbì diyà kenagda. Guwaen di, “O medoo ulu-ulu owoy kaunutan ké, ");
INSERT INTO mta_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","eg-igsaan yu kami denu sa panduan binaelan ké diyà sa maama pikat. Eg-igsaen yu ma sa pesuwan di nelikuan dé. ");
INSERT INTO mta_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tulonon ké kiyu owoy sa langun tugod i Islaél anì metiigan yu sa pesuwan di nelikuan siini pikat. Egtigdeg diyà sa taengan yu owoy nelikuan dé danà sa tunung i Hésus Kelistu tegeNasalét. Si Hésus sa inimatayan yu, dodoo inenaw i Nemula kagdi egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na, si Hésus sa tinulon sa kagi i Nemula igpesulat, guwaen di, ‘Sa sebaen batu inekedan yu, kiyu i tegebael dalesan pulung batu, iya polo sa tigtu miulan batu hinemilì ku.’ ");
INSERT INTO mta_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Na, endà duen liyu etaw mekealuk kenita denu sa salà ta. Sumalà dé sa etaw diyà siini sinukub langit, endà duen liyu etaw pineangay i Nemula diyà tanà anì alukan di sa medoo etaw denu sa salà da.” ");
INSERT INTO mta_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Agulé, tigtu negaip sa medoo ulu-ulu diyà sa Dalesan i Nemula enù ka mebagel Pidelu i owoy si Huwan egsagbì kenagda, apiya di pa tukééy sa pinangagian da. Dodoo netiigan da kagda sa duma i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dodoo sa medoo ulu-ulu diyà Dalesan i Nemula, endà negaga da duu egsigbolow sa kagi i Pidelu owoy si Huwan enù ka hinaa da sa maama nelikuan egtigdeg dahiya. ");
INSERT INTO mta_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Agulé, pinelaun da Pidelu i owoy si Huwan kedu diyà sa bilik kenà da nesetipon. Iya sa binaelan da anì egseolomoy sa medoo ulu-ulu, ");
INSERT INTO mta_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","guwaen da, “Ngadan sa mebaelan ta? Endà mepalaw ta duu iya wé panduan binaelan da, enù ka negaipan sa langun etaw diyà Hélusalém owoy netiigan da ma. ");
INSERT INTO mta_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mepion polo amuk limedangen ta kagda anì endà muman da tumulon denu si Hésus diyà sa medoo etaw anì endà mekeseluh sa kagi denu kenagdi.” ");
INSERT INTO mta_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Huenan di, egoh da migpedalem dema si Pidelu owoy si Huwan, eghawidan da kagda anì endà kumedoo sa etaw egpigtuu diyà si Hésus, guwaen da, “Yoko eg-uman na egtulù denu si Hésus.” ");
INSERT INTO mta_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Dodoo egsagbì Pidelu i owoy si Huwan, guwaen da, “Penemdem yu ini i. Ngadan sa tayu mepion diyà si Nemula, iling ka mangunut ké diyà sa niyu kagi ataw ka mangunut ké diyà si Nemula? ");
INSERT INTO mta_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Endà mekesabuh ké umolom denu sa hinaa ké owoy sa dinineg ké.” ");
INSERT INTO mta_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Agulé, eg-umanen sa medoo ulu-ulu Hudiyu eglimedang Pidelu i owoy si Huwan. Agulé linengaan da kagda, enù ka endà duen sa pesuwan da egpelihayen enù ka eg-oloen sa langun etaw Nemula i danà sa maama nelikuan dé. ");
INSERT INTO mta_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Na, labi dé epat pulù gepalay sa kelukes sa maama nelikuan. ");
INSERT INTO mta_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Na, egoh i Pidelu owoy si Huwan nekelaun, eg-angay da diyà sa medoo duma da egpigtuu owoy egtulonen da diyà kenagda sa kehawid sa medoo kaunutan Hudiyu owoy sa medoo ulu-ulu tegesimbà. ");
INSERT INTO mta_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Egoh sa medoo etaw egpigtuu migdineg iya wé, egsimbà da langun diyà si Nemula, guwaen da, “O Datù Nemula, kuna sa migbael sa langit owoy sa tanà owoy sa dagat owoy sa langun taman diyà tanà. ");
INSERT INTO mta_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kuna ma sa migpeikagi si Dabid, sa tupù ké migpangunut diyà keniko egoh anay, enù ka danà sa Metiengaw Suguy ko, guwaen i Dabid, ‘Maen di ya egbulit sa medoo etaw beken Hudiyu? Owoy maen di ya egpenemdemen sa etaw Hudiyu sa pandapat da umatu, dodoo endà megaga da duu. ");
INSERT INTO mta_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nesetipon sa medoo sulutan diyà tanà anì gumila da, owoy nesetipon ma sa medoo ulu-ulu ta anì liputan da Nemula i owoy sa Tigtu Datù sinugù di.’ ");
INSERT INTO mta_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na, neketuu dé iya wé kagi i Dabid ini egoh di, enù ka dahini diyà Hélusalém nesetipon da Hélod i owoy si Ponkiyu Pilatu owoy sa medoo tugod i Islaél owoy sa medoo duma etaw beken Hudiyu anì imatayan da Hésus i, sa pineangay ko diyà kenami, apiya di pa endà duen salà di. Kagdi sa Tigtu Datù sinugù ko diyà tanà. ");
INSERT INTO mta_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inimatayan da kagdi, dodoo danà sa dakel egkegaga ko owoy danà sa tapay penemdem ko, tapay dé netiigan ko sa langun kebael da kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Datù ké, netiigan ko ma sa kelimedang da kenami i etaw egpangunut diyà keniko. Huenan di, buligi ko kami anì endà melimedangan ké tumulon sa kagi ko. ");
INSERT INTO mta_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pehauwi ko sa tunung ko anì melikuan sa medoo etaw eglinadu owoy dumuen ma medoo panduan ko owoy medoo egkegaipan etaw danà sa tunung i Hésus, sa sinugù ko.” ");
INSERT INTO mta_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Na, egoh da neubus egsimbà, egkekayung sa dalesan kenà da nesetipon. Agulé linuhub sa Metiengaw Suguy i Nemula kagda, huenan di endà dé egkelimedangan da duu egtulon sa kagi i Nemula diyà sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Na, nesesebaen sa pedu sa medoo etaw egpigtuu. Endà duen etaw lumaguk sa langun taman di, dodoo egsebuligay da takà. ");
INSERT INTO mta_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tigtu tinunungan i Nemula sa medoo salu i Hésus anì tumulù da denu sa keenaw i Datù Hésus danà da mighaa kenagdi nehagtay dema. Tigtu egtabangan i Nemula sa langun etaw egpigtuu diyà kagdi. ");
INSERT INTO mta_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Endà duen etaw pubeli diyà kenagda enù ka egdagangen da sa tanà da owoy sa dalesan da, owoy ibegay da sa pilak diyà sa medoo salu i Hésus anì itukid da ibegay diyà sa medoo duma da egkepasangan. ");
INSERT INTO mta_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, duen sa maama tegeSipeli, sa tugod i Lebi. Iya sa ngadan di si Hosé, dodoo ingadanan sa medoo salu i Hésus kagdi si Bilnabi enù ka tegebulig. ");
INSERT INTO mta_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Dinagang di sa tanà di owoy inuwit di sa pilak ibegay di diyà sa medoo salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Na, duen sa maama si Ananiyas, owoy sa sawa di si Sapila. Dinagang da sa duma tanà da, ");
INSERT INTO mta_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","dodoo nesesebaen sa pedu da eglaguk sa pilak di. Agulé inuwit i Ananiyas sa duma pilak di diyà sa medoo salu i Hésus, owoy ubòubò di ibegay imet sa langun pilak. ");
INSERT INTO mta_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Agulé guwaen i Pidelu, “O Ananiyas, maen di ya eg-unutan sa pedu ko sa penemdem i Satanas anì mutbut ka diyà sa Metiengaw Suguy i Nemula? Kulang ini i pilak ko diyà sa lagà sa tanà dinagang ko. ");
INSERT INTO mta_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Egoh ko endà pa egdagang sa tanà, kuna sa épê di, owoy egoh ko migdagang, niko ma sa pilak di. Endà tinegel ka etaw egpebegay pilak egoh ko egdagang sa tanà ko. Maen di ya pinenemdem ko kami eg-akal denu sa lagà sa tanà ko? Beken kami sa egbutbutan ko, dodoo si Nemula polo.” ");
INSERT INTO mta_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Na, egoh i Ananiyas migdineg iya wé inikagi i Pidelu, nepilay dé owoy nematay ma. Hê, eg-angayen sa medoo melaud egbekut ginis sa nematay, owoy sineoyongon da eg-angay eglebeng. Agulé tigtu nelimedangan sa langun etaw migdineg denu sa kinepatay di. ");
INSERT INTO mta_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Agulé telu kaulas kedu iya, migtebow Sapila i, dodoo endà netiigan di duu nematay dé sa sawa di. ");
INSERT INTO mta_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Eg-ikagi Pidelu i, guwaen di, “Tuloni ko aken. Enù di ya, ini daa sa langun pilak igbayad sa tanà dinagang yu?” Guwaen sa bayi egsagbì, “Hoò, iya daa sa kedoo di.” ");
INSERT INTO mta_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Guwaen i Pidelu, “Maen di ya egpenemdemen yu telesawa tumepeng sa Suguy i Nemula amuk metiigan di sa salà yu ataw ka endà? Haa ko. Diyà pelawà selat sa etaw miglebeng sa sawa ko giina, owoy uwiten da ma kuna dutu.” ");
INSERT INTO mta_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Hê, petow dé nematay ma sa bayi. Egoh sa medoo maama migtebow dahiya, nematay dé si Sapila. Agulé, eg-uwiten da ma sa lawa di owoy ilebeng da ma dapag sa sawa di. ");
INSERT INTO mta_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Huenan di, tigtu nelimedangan sa langun etaw egpigtuu owoy sa medoo liyu etaw migdineg denu siini nebaelan da. ");
INSERT INTO mta_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na, duen medoo panduan owoy medoo tandà egkegaipan etaw binaelan sa medoo salu i Hésus diyà sa kehaa sa medoo liyu etaw. Takà egkesetipon sa medoo etaw egpigtuu diyà sa luglug Dalesan i Nemula kepengadan da Luglug i Salomon. ");
INSERT INTO mta_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dodoo apiya di pa netuuwan sa medoo etaw diyà kenagda, endà doo duen etaw eg-unut diyà kenagda amuk endà tigtu di egpigtuu, enù ka nelimedangan di sa pedu di endà tuu. ");
INSERT INTO mta_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dodoo egkedoo sa etaw egpigtuu diyà si Datù, duen medoo maama owoy medoo bayi ma eg-unut diyà sa etaw egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Na, danà sa medoo panduan egbaelan sa salu i Hésus, eg-uwiten etaw sa medoo eglinadu diyà sa kilidan kalasada, owoy itenà da ma sa kamah owoy sa ikam da dahiya anì mekesugat sa alung i Pidelu diyà kenagda amuk tumalà enù ka ungayà da melikuan da. ");
INSERT INTO mta_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Eg-angay ma Hélusalém dò sa medoo etaw eg-ugpà diyà sa medoo liyu menuwa medapag dahiya, owoy eg-uwiten da sa medoo etaw eglinadu owoy sa medoo etaw kinudì busaw. Hê, nelikuan da dé langun. ");
INSERT INTO mta_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na, egbulit sa Tigtu Ulu-ulu Tegesimbà owoy sa medoo duma di etaw Sadusiyu. Tigtu egkesina da, ");
INSERT INTO mta_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","huenan di egsigkemen da sa medoo salu i Hésus owoy egbilangguwen da ma. ");
INSERT INTO mta_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Dodoo egoh di sumigep, inukaan sa egsugùsuguen i Nemula sa pintù bilangguwan, owoy egpelaunen di sa medoo salu i Hésus. Egsuguen di kagda, ");
INSERT INTO mta_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","guwaen di, “Angay yu diyà sa Dalesan i Nemula. Tuloni yu sa langun etaw denu sa lalù ibegay i Nemula diyà etaw.” ");
INSERT INTO mta_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na, egpangunut sa medoo salu i Hésus diyà sa kagi di egsugù. Huenan di, egoh di sumimag, egdalem da diyà sa Dalesan i Nemula owoy eg-edung da egtulù. Na, egoh iya magtu kesimag, nesetipon sa Tigtu Ulu-ulu Tegesimbà owoy sa medoo duma di anì setiponen da sa langun kaunutan Hudiyu. Egoh da nesetipon langun diyà sa Dalesan i Nemula, igpeangay da sa medoo salu i Hésus dutu bilangguwan dò. ");
INSERT INTO mta_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Dodoo egoh sa sinugù da migtebow diyà sa bilangguwan, endà hinaa da duu sa salu i Hésus dalem sa bilangguwan. Agulé, egpelikù da diyà sa medoo ulu-ulu nesetipon diyà Dalesan i Nemula, owoy guwaen da, ");
INSERT INTO mta_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Egoh ké migtebow dutu, nepintuan doo sa bilangguwan owoy egbantay doo sa medoo tegebantay. Dodoo egoh ké mig-ukà sa pintuan, endà duen etaw hinaa ké dalem.” ");
INSERT INTO mta_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na, egoh sa medoo ulu-ulu tegesimbà owoy sa ulu-ulu sa tegebantay Dalesan i Nemula neketiig iya wé, tigtu negaip da, enù ka endà netiigan da duu sa inangayan sa medoo salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Agulé duen sa etaw migtebow diyà kenagda, guwaen di, “Taa yu, hih. Dini dé diyà Dalesan i Nemula sa medoo etaw binilanggu yu, owoy egtulù da diyà sa medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Agulé, eglegkang sa ulu-ulu tegebantay owoy sa duma di anì angayen da sa medoo salu i Hésus. Dodoo endà egtegelen da duu kagda egsabà enù ka egkelimedangan da sa duma etaw egbuungen da kagda batu. ");
INSERT INTO mta_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Inuwit da sa medoo salu i Hésus diyà sa kenà sa medoo ulu-ulu nesetipon, owoy egpetigdegen da kagda diyà sa taengan da. Agulé eg-ikagi sa Tigtu Ulu-ulu Tegesimbà diyà sa medoo salu i Hésus, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hinawidan ké sa ketulù yu denu iya wé etaw eg-unutan yu. Dodoo endà egpangunutan yu duu sa kagi ké, huenan di netiigan dé sa langun etaw diyà Hélusalém sa igtulù yu. Mig-ikagi yu ma kami sa mig-imatay sa etaw eg-unutan yu. Huenan di pineangay ku kiyu dini.” ");
INSERT INTO mta_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Agulé, egsagbì Pidelu i owoy sa duma di salu i Hésus, guwaen da, “Apiya di pa eghawidan yu kami, endà sumabuh ké tumulù enù ka si Nemula sa egpangunutan ké. ");
INSERT INTO mta_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Sa Nemula sinaligan sa medoo tupù ta, kagdi sa mig-enaw si Hésus egoh di nematay. Dodoo inimatayan yu kagdi i egoh yu migtutuk kenagdi diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Agulé, binatun i Nemula kagdi i dutu langit dò owoy pinepenuu di denu kuwanan di enù ka kagdi sa Tigtu Datù ta owoy sa tegealuk kenita denu sa salà ta, enù ka ungayà di ekedan ta sa salà ta anì ipeuloy di sa salà ta, kita i tugod i Islaél. ");
INSERT INTO mta_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Egtulonen ké sa langun nebaelan i Hésus enù ka hinaa ké iya wé, owoy iya ma sa egpetuu sa kagi ké sa Metiengaw Suguy i Nemula ibegay di diyà sa langun etaw egpangunut diyà kenagdi.” ");
INSERT INTO mta_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Na, egoh sa medoo ulu-ulu diyà Dalesan i Nemula migdineg iya wé sagbì i Pidelu, tigtu da egbulit owoy ungayà da imatayan da sa medoo salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Dodoo duen dahiya sa etaw Palasiyu, si Gamaliél, sa tegetulù uledin igsugkow i Mosis, owoy netuuwan ma sa langun etaw diyà kenagdi. Egtigdeg anì mikagi, dodoo muna pelawà pinelaun di sa medoo salu i Hésus. ");
INSERT INTO mta_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Agulé guwaen di diyà sa medoo duma di nesetipon, “O medoo duma ku tugod i Islaél, tuliki yu sa kebael yu siini etaw. ");
INSERT INTO mta_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Egoh anay, duen sa maama si Tudas. Ungayà di pedatù, owoy epat gatus kéen sa kedoo etaw eg-unut kenagdi. Dodoo neimatayan, agulé nesepalak sa medoo etaw eg-unut kenagdi owoy endà duen ketebowon sa penemdem di. ");
INSERT INTO mta_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Duen ma sa sebaen maama, si Hudas tegeGaliliya. Egoh sa gubilenu migbilang sa kedoo etaw di, egkedatù hedem Hudas i owoy medoo ma sa etaw eg-unut kenagdi. Dodoo neimatayan ma, huenan di nesepalak ma sa medoo eg-unut kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na, ini sa eg-ikagiyen ku diyà keniyu. Mepion amuk endà pelihayen ta duu Pidelu i owoy sa medoo duma di. Pandayaen ta dé kagda, enù ka amuk beken si Nemula sa egpeangay kenagda, endà duen sa ketebowon sa egbaelan da. ");
INSERT INTO mta_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Dodoo amuk si Nemula sa egpeangay kenagda dini, endà metabanan ta duu enù ka mebaluy si Nemula polo sa mekuntelà ta.” ");
INSERT INTO mta_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na, neiyap sa medoo ulu-ulu sa kagi i Gamaliél. Agulé, pinedalem da dema sa medoo salu i Hésus, owoy igpetapes da ma kagda. Eghawidan da kagda anì endà dé tumulon da denu si Hésus. Hê, linengaan da dé kagda. ");
INSERT INTO mta_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Egoh sa medoo salu i Hésus miglaun, neanggan da temù enù ka iya sa penemdem da hinemilì i Nemula kagda anì mepelihay da danà sa kepigtuu da diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Agulé, eg-uman da doo egtulù uman agdaw diyà sa Dalesan i Nemula owoy diyà sa medoo liyu dalesan. Egtulon da sa Mepion Tegudon denu si Hésus sa Tigtu Datù sinugù i Nemula diyà tanà. ");
INSERT INTO mta_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Na, egkedoo sa etaw egpigtuu diyà si Hésus. Dodoo sebaen agdaw, egsesigbolowoy sa medoo Hudiyu egpigtuu eg-ikagi Geligu owoy sa medoo Hudiyu egpigtuu eg-ikagi Hibelu, enù ka guwaen sa etaw Geligu tukééy daa gaa sa pilak igbegay diyà sa medoo bayi balu da. ");
INSERT INTO mta_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Agulé, egsetiponen sa sepulù owoy duwa salu i Hésus sa langun etaw egpigtuu, owoy guwaen da, “Endà mepion di amuk sumabuh ké tumulù sa kagi i Nemula anì itukid ké sa pilak ibegay diyà sa medoo etaw pubeli. ");
INSERT INTO mta_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","O medoo duma ké, mepion amuk hemilien yu sa pitu maama diyà keniyu, sa mepion etaw linuhub sa Suguy i Nemula owoy milantek ma. Amuk hediya, kagda sa tumukid megay pilak diyà sa medoo etaw pubeli, ");
INSERT INTO mta_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","owoy kami sa umudes sumimbà owoy takà ké ma tumulù diyà sa medoo etaw.” ");
INSERT INTO mta_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Egoh sa langun etaw egpigtuu migdineg iya wé, egkeiyap da. Huenan di, eghemilien da Estiban i, enù ka mebagel sa kepigtuu di owoy linuhub sa Metiengaw Suguy i Nemula. Ini sa medoo duma eghemilien da, si Pilipi, owoy si Pelokolo, owoy si Nikanol, owoy si Timon, owoy si Palminas, owoy si Nikolas tegeAntiokiya egpangunut diyà sa adat Hudiyu apiya beken etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Agulé, pinetigdeg da sa pitu maama diyà sa taengan sa medoo salu i Hésus. Egsimbà sa medoo salu i Hésus egoh da egsabà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Agulé, egpekeseluh sa kagi i Nemula danà sa ketulù da. Egkedoo ma sa etaw egpigtuu diyà menuwa Hélusalém, owoy duen ma medoo tegesimbà diyà Dalesan i Nemula egpigtuu ma dé diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na, tigtu tinunungan i Nemula Estiban i, huenan di egpekebael medoo egkegaipan etaw owoy medoo panduan eghauwen sa medoo etaw. ");
INSERT INTO mta_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Dodoo duen ma medoo liyu etaw egsigbolow si Estiban. Kagda sa etaw egsimbà diyà sa simbaan pinengadanan da “Linengaan Udipen.” Kagda ma sa etaw Hudiyu tegeSilini owoy tegeAlihandeliya, owoy duen ma kedu uwang Silisiya owoy uwang Asiya. ");
INSERT INTO mta_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Dodoo endà megaga da duu egsigbolow Estiban i, enù ka tigtu milantek sa eg-ikagiyen di diyà kenagda danà sa Suguy i Nemula egtabang kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Agulé, eg-enggat da sa liyu etaw anì tipuwen da Estiban i, guwaen da, “Dinineg ké sa kesumbung di diyà si Nemula owoy diyà sa uledin igsugkow i Mosis egoh anay.” ");
INSERT INTO mta_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Huenan di, egpebuliten da sa medoo etaw owoy sa medoo kaunutan Hudiyu owoy sa medoo tegetulù uledin igsugkow i Mosis. Agulé, eg-angayen da egsigkem Estiban i, owoy eg-uwiten da dutu siedò medoo kaunutan Hudiyu diyà sa Dalesan i Nemula anì antangen da. ");
INSERT INTO mta_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Agulé, egtigdeg sa medoo etaw inenggat da egpebutbut denu sa inikagi i Estiban, owoy guwaen da, “Siini maama, egsumbungen di takà siini mapulù Dalesan i Nemula owoy sa uledin igsugkow i Mosis sa tupù ta egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Owoy dinineg ké ma sa inikagi di, pedaetan i Hésus tegeNasalét gaa siini dakel dalesan kenà ta egsimbà, owoy sambian di ma gaa sa adat ta igtulù i Mosis.” ");
INSERT INTO mta_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Agulé, eg-inengtengen sa medoo kaunutan Hudiyu Estiban i, owoy hinaa da nehalì sa palas di nekeiling sa egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Agulé, eg-igsaan sa Tigtu Ulu-ulu Tegesimbà Estiban i, guwaen di, “Tuu pa sa inikagi da?” ");
INSERT INTO mta_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Egsagbì Estiban i, guwaen di, “O medoo momò ku owoy medoo loyuk ku, dinegdineg yu, hih, sa eg-ikagiyen ku. Egoh anay egoh sa tupù ta si Ablaham mig-ugpà dutu Misopotamiya dò egoh di endà pa mig-edoh diyà menuwa Halan, migpehaa Nemula i diyà kenagdi kedu langit dò, ");
INSERT INTO mta_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","owoy mig-ikagi diyà kenagdi, guwaen di, ‘Legkà ka dé diyà sa malayan ko owoy sa menuwa ko. Angay ka diyà sa tanà itulù ku diyà keniko.’ ");
INSERT INTO mta_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Huenan di, miglegkà Ablaham i diyà sa menuwa di Kaldiya, owoy mig-angay eg-ugpà dutu Halan dò. Egoh sa emà di nematay, pineedoh i Nemula kagdi eg-angay dahini diyà sa tanà kenà ta eg-ugpà. ");
INSERT INTO mta_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Egoh iya, endà duen tanà igbegay i Nemula diyà si Ablaham, apiya tukééy. Dodoo migpasad Nemula i diyà kenagdi mugpà Ablaham i owoy sa medoo tugod di taman melugay diyà sa tanà igbegay di diyà kenagdi, apiya di pa endà pa duen sa anak di. ");
INSERT INTO mta_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ini sa kagi i Nemula diyà kenagdi egoh anay, guwaen di, ‘Mugpà daa sa tugod ko diyà sa sebaen ma tanà kenà da meudipen owoy mepasangan taman epat gatus gepalay. ");
INSERT INTO mta_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Dodoo pigtamayan ku ma sa etaw eg-udipen kenagda. Agulé, lumegkà dema sa tugod ko diyà siedò tanà, owoy mangay da mugpà dahini diyà siini tanà anì sumimbà da diyà kenak.’ Iya sa igpasad i Nemula diyà si Ablaham egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Agulé, sinugù i Nemula kagdi anì pekelaingen di sa ipat di owoy sa ipat sa langun tugod di maama anì metandaan sa igpasad i Nemula diyà kenagda. Huenan di, pinekelaing di sa anak di si Isak egoh di sakapadian dé miglesut. Hediya ma pinekelaing i Isak sa anak di si Hakob, owoy pinekelaing i Hakob ma sa sepulù owoy duwa anak di, sa medoo tupù ta. ");
INSERT INTO mta_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, nesina sa medoo tupù ta anak i Hakob sa hadi da, si Hosé. Huenan di, dinagang da Hosé i anì meudipen dutu Igiptu dò. Dodoo binuligan i Nemula kagdi, ");
INSERT INTO mta_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","huenan di netigkelan di sa kelikutan di. Tigtu milantek owoy mepion etaw ma, huenan di netuuwan si Datù Palo diyà kenagdi, owoy ginelal di kagdi gubilenu diyà sa langun tanà Igiptu owoy kagdi ma sa sinaligan di sa langun taman di. ");
INSERT INTO mta_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Agulé duen sa dakel bitil dutu Igiptu dò owoy diyà tanà Kanan ma. Nepasangan temù sa langun etaw owoy endà ma duen kaenen sa medoo tupù ta. ");
INSERT INTO mta_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Huenan di, egoh i Hakob neketiig duen kaenen dutu Igiptu dò, pineangay di sa anak di, sa tupù ta, egpebeli kaenen dutu. ");
INSERT INTO mta_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Agulé egoh da egsaup eg-angay Igiptu dò, migpekilala Hosé i diyà sa medoo kakay di, owoy igpekilala di ma sa medoo tigtu duma di diyà si Palo. ");
INSERT INTO mta_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Agulé igpeangay i Hosé sa emà di, si Hakob, owoy sa langun malayan da. Pitu pulù owoy lima sa kedoo da. ");
INSERT INTO mta_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Huenan di, mig-edoh Hakob i eg-angay eg-ugpà dutu Igiptu dò. Agulé neseinut-inut da nematay dahiya, si Hakob owoy sa medoo anak di. ");
INSERT INTO mta_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Inuwit da sa lawa da dutu menuwa Sikem dò, owoy iglebeng da dalem sa takub diyà sa tanà bineli i Ablaham diyà sa tugod i Hamol egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na, egoh di buyu meketuu sa igpasad i Nemula diyà si Ablaham egoh anay, migkedoo dé sa tupù ta dutu Igiptu dò. ");
INSERT INTO mta_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Egoh iya, duen sa sebaen Palo diyà Igiptu, owoy endà neketiig di denu si Hosé. ");
INSERT INTO mta_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inakalan di sa medoo tupù ta owoy pinelihay di kagda. Tinegel di egpitas diyà tanà sa anak da magtu miglesut anì mematay da. ");
INSERT INTO mta_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Iya ma sa egoh di miglesut Mosis i sa tigtu mepion batà. Inunungan sa lukes di taman telu gebulan diyà sa dalesan da. ");
INSERT INTO mta_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Dodoo egoh i Mosis tinangtang diyà sa ilis wayeg, hinaa sa anak i Palo bayi. Agulé, linomò di owoy inipat di lagà mendaa sa keipat di sa hagdi anak. ");
INSERT INTO mta_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Agulé, netulù Mosis i sa langun netiigan sa etaw Igiptu. Egoh di mipedu dé, tigtu milantek sa keikagi di owoy sa langun egbaelan di. ");
INSERT INTO mta_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Na, egoh i Mosis epat pulù gepalay dé, eg-angayen di egtelow sa medoo duma di tugod i Islaél. ");
INSERT INTO mta_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Dodoo hinaa di sa duma di pinelihay sa etaw tegeIgiptu. Agulé binuligan di owoy sinulian di, owoy inimatayan di sa etaw tegeIgiptu. ");
INSERT INTO mta_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Iya sa binaelan di enù ka guwaen di dò netiigan sa medoo duma di Hudiyu kagdi sa hinemilì i Nemula anì uwiten di kagda kedu diyà Igiptu. Dodoo endà netiigan da duu iya wé. ");
INSERT INTO mta_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Agulé egoh di umenaw simag, hinaa di sa duwa duma di tugod i Islaél egseginaluway da. Ungayà di antangen di kagda, huenan di mikagi, guwaen di, ‘O Akay, anan yu tugod i Islaél. Yoko egsebulitay ya.’ ");
INSERT INTO mta_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dodoo sa etaw egtibabà duma di, eghemagawan di Mosis i, owoy guwaen di, ‘Endà pineangay etaw kuna ya anì kumedatù ka owoy umantang kenami. ");
INSERT INTO mta_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Enù di ya, imatayan ko ma aken, iling sa kineimatay ko sa etaw tegeIgiptu egoh neagdaw?’ ");
INSERT INTO mta_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Egoh i Mosis migdineg iya wé, migpelaguy kedu diyà Igiptu owoy eg-angay eg-ugpà dutu tanà Midiyan dò. Migsawa dutu, owoy mig-anak duwa maama. ");
INSERT INTO mta_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Na, egoh di neuma epat pulù gepalay, dutu siedò melabel tanà mediyù dalesan medapag diyà sa getan Sinay Mosis i. Duen sa egsugùsuguen i Nemula migpehaa diyà kenagdi diyà sa tukééy kayu eglegleg. ");
INSERT INTO mta_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Egoh i Mosis mighaa iya wé, tigtu negaip. Egoh di mig-angay egtelow sa kayu eglegleg, dinineg di sa kagi i Datù Nemula kedu diyà sa apuy, ");
INSERT INTO mta_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","guwaen di, ‘Aken sa Nemula sinaligan sa medoo tupù ko egoh anay, si Ablaham owoy si Isak owoy si Hakob.’ Agulé egoh i Mosis migdineg iya wé, endà inuman di duu eg-inengteng enù ka nelimedangan temù owoy miglukub ma. ");
INSERT INTO mta_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Agulé mig-ikagi Nemula i diyà kenagdi, guwaen di, ‘Kedani ko dé sa talumpà ko anì adatan ko aken, enù ka egtigdeg ka diyà sa tanà kenà ku migpehaa diyà keniko. ");
INSERT INTO mta_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Netiigan ku dé tigtu egkepelihay sa medoo etaw hinemilì ku dutu Igiptu dò. Dinineg ku sa kesimbà da diyà kenak, huenan di alukan ku kagda. Na, kuna sa peangayen ku diyà Igiptu anì mealukan da,’ guwaen i Nemula diyà si Mosis egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na, egoh anay si Mosis sa inekedan sa medoo duma di tugod i Islaél, enù ka guwaen da, ‘Endà pineangay etaw kuna ya anì kumedatù ka owoy umantang kenami.’ Dodoo kagdi polo sa pineangay i Nemula diyà kenagda anì kumedatù owoy umaluk kenagda danà sa ketabang sa egsugùsuguen i Nemula migpehaa diyà kenagdi diyà sa tukééy kayu eglegleg. ");
INSERT INTO mta_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Huenan di, si Mosis sa mig-uwit sa medoo tupù ta egoh da miglegkà diyà tanà Igiptu, owoy binaelan di sa medoo panduan owoy sa medoo tandà egkegaipan etaw diyà Igiptu owoy diyà sa Melalegà Dagat, owoy diyà sa melabel tanà mediyù dalesan taman epat pulù gepalay. ");
INSERT INTO mta_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Mosis ma sa mig-ikagi diyà sa medoo tugod i Islaél, guwaen di, ‘Peangayen i Nemula sa sebaen tegesugkow di diyà keniyu, éhê mendaa sa kinepeangay di kenak. Kagdi ma sa tugod yu.’ ");
INSERT INTO mta_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Si Mosis ma sa mig-uwit sa medoo tugod i Islaél egoh da neselimud diyà sa melabel tanà mediyù dalesan. Kagdi ma sa inikagiyan sa egsugùsuguen i Nemula dutu Getan Sinay dò, owoy kagdi sa migsakem sa kagi i Nemula endà meelut di anì isugkow di diyà kenita. ");
INSERT INTO mta_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Dodoo tapay doo endà egpangunut sa medoo tupù ta diyà si Mosis. Eg-ekedan da polo enù ka ungayà da pelikù da Igiptu dò. ");
INSERT INTO mta_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Agulé egoh i Mosis dutu getan dò, migpegeni da diyà sa kakay i Mosis, si Alon, guwaen da, ‘Baeli ko diyà kenita sa egpenemulawen ta anì dumuen sa umuwit kenita, enù ka endà netiigan ké duu sa inangayan i Mosis, sa mig-uwit kenita kedu Igiptu dò.’ ");
INSERT INTO mta_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Agulé, binaelan da sa inetaw éhê palas nati sapì. Mig-imatay da hinagtay anì sumimbà da diyà iya wé binaelan da, owoy pinistawan da. ");
INSERT INTO mta_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Huenan di, ininiyugan i Nemula kagda, owoy pinandayà di sa kesimbà da diyà sa agdaw owoy sa bulan owoy sa bituen. Hediya ma sa kagi i Nemula igsulat sa tegesugkow di egoh anay, guwaen di, ‘O medoo tugod i Islaél, egoh yu mig-ipanaw diyà sa melabel tanà mediyù dalesan taman epat pulù gepalay, beken aken sa egsimbaan yu egoh yu mig-imatay hinagtay. ");
INSERT INTO mta_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Dodoo migsimbà yu polo diyà sa medoo inetaw binaelan yu. Takà yu eg-uwit sa éhê simbaan sa nemula yu si Molok, owoy eg-uwit yu ma sa éhê bituen sa nemula yu si Lipan. Huenan di, pigtamayan ku kiyu owoy ipeuwit ku kiyu dutu dibaluy siedò mediyù menuwa Babiloniya.’ ");
INSERT INTO mta_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na, egoh anay egoh sa tupù ta mig-ipanawpanaw diyà sa melabel tanà mediyù dalesan, eg-uwit-uwiten da sa dakel simbaan kemalig hinabengan ginis anì metandaan eg-ugpà Nemula i diyà kenagda. Igpebael i Nemula diyà kenagda iya wé kemalig iling sa igpehaa di diyà si Mosis egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Agulé, egoh i Mosis nematay, si Hosuwa sa migpesambì kenagdi eg-uwit sa medoo Hudiyu eg-angay diyà sa tanà igpasad i Nemula diyà kenagda. Sumalà dé sa inangayan da, takaan da eg-uwit sa simbaan kemalig. Tinabangan i Nemula kagda, owoy eghemagawan di sa medoo liyu etaw anì dumuen kenà sa tupù ta mugpà. Nelugay da egsimbà diyà iya wé kemalig taman sa egoh i Dabid migkedatù diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Netuuwan Nemula i diyà sa langun binaelan i Dabid. Huenan di, migpegeni diyà si Nemula amuk mebaluy kagdi sa mael sa dakel dalesan kenà da sumimbà diyà sa Nemula sinaligan i Hakob. ");
INSERT INTO mta_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dodoo sa anak di si Salomon polo sa migbael sa dakel Dalesan i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Na, tigtu mapulù Nemula i, huenan di endà mugpà di diyà sa dalesan binaelan ta, kita i etaw. Hediya ma sa igsulat sa tegesugkow i Nemula egoh anay, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Sa langit sa kenà ku egpenuu, owoy sa tanà sa kinadalan lisen ku, guwaen i Datù. Aken sa migpeduen sa langun taman diyà tanà. Huenan di, endà mebaluy di egbaelan yu sa dalesan ku kenà ku eg-ugpà.’ ” ");
INSERT INTO mta_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eg-uman Estiban i eg-ikagi diyà sa medoo ulu-ulu etaw Hudiyu, guwaen di, “Tigtu metegas sa ulu yu, enù ka endà egpigtuu yu diyà si Nemula owoy meked yu dumineg sa kagi di. Meilingan yu sa medoo tupù ta, enù ka takà yu eg-eked sa Metiengaw Suguy i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Pinelihay sa medoo tupù ta sa langun tegesugkow i Nemula egoh anay, enù ka inimatayan da sa medoo tegesugkow i Nemula migtulon denu sa metiengaw etaw tumebow sinugù i Nemula. Agulé egoh di migtebow, igpesigkem yu dé owoy inimatayan yu ma. ");
INSERT INTO mta_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Apiya di pa kiyu sa migsakem sa uledin i Nemula igsugkow sa egsugùsuguen di egoh anay, endà doo egpigtuu yu.” ");
INSERT INTO mta_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Na, egoh sa medoo ulu-ulu diyà Dalesan i Nemula migdineg sa inikagi i Estiban, tigtu egbulit da owoy egpekégeten da sa ngipen da danà sa kebulit da. ");
INSERT INTO mta_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Dodoo linuhub sa Metiengaw Suguy i Nemula Estiban i. Agulé egoh di eglengag dutu langit dò, eghauwen di sa senang i Nemula owoy si Hésus egtigdeg denu kuwanan i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Eg-ikagi Estiban i, guwaen di, “Haa yu. Hinaa ku sa langit neukaan, owoy hinaa ku sa Kakay Langun egtigdeg denu kuwanan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dodoo egsagpengen sa medoo etaw sa telinga da anì endà dinegen da duu sa kagi di. Egkagkag da danà da egbulit. Hê, egletu da egseulingutan da kagdi i. ");
INSERT INTO mta_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Agulé eg-agaken da diyà sa dibaluy menuwa, owoy egbuungen da kagdi batu anì imatayan da. Duen sa maama, si Saulo, egbantay sa kawal sinalidan sa medoo etaw egbuung batu. ");
INSERT INTO mta_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ligò da egbuung batu, egsimbà Estiban i, guwaen di, “O Hésus Datù ku, kuwa ko sa suguy ku enù ka buyu a dé egkematay.” ");
INSERT INTO mta_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Agulé egligkued owoy eg-umow, guwaen di, “O Datù, yaka egpigtamay duu kagda danà sa kebael da kenak.” Hê, egoh di mig-ikagi iya wé, nematay dé. ");
INSERT INTO mta_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Na, tigtu neiyap Saulo i egoh i Estiban neimatayan. Iglebeng sa medoo metiengaw etaw Estiban i, owoy tigtu egsinegawan da ma. Na, edung sa egoh i Estiban nematay, nepelihay temù sa medoo egpigtuu diyà si Hésus diyà Hélusalém, huenan di nesepalak da diyà sa medoo menuwa diyà uwang Hudiya owoy uwang Samaliya. Dodoo eg-ugpà pelà sa medoo salu i Hésus diyà Hélusalém. ");
INSERT INTO mta_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tigtu egpelihayen i Saulo sa medoo egpigtuu diyà si Hésus. Takà eggemow diyà sa medoo dalesan da anì sigkemen di kagda owoy egbilangguwen di ma, iling ka maama ataw ka bayi. ");
INSERT INTO mta_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, egoh sa medoo etaw egpigtuu nesepalak, egtulù da denu si Hésus diyà sa medoo etaw sumalà dé sa inangayan da. ");
INSERT INTO mta_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Mig-angay Pilipi i diyà sa dakel menuwa diyà uwang Samaliya, owoy egtegudon diyà sa medoo etaw dahiya, guwaen di, “Si Hésus sa Tigtu Datù sinugù i Nemula diyà tanà.” ");
INSERT INTO mta_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Na, egkeiyap sa langun etaw egdinegdineg diyà si Pilipi, enù ka dinineg da sa tegudon di owoy hinaa da sa medoo panduan binaelan di. ");
INSERT INTO mta_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Duen busaw nekelesing egoh i Pilipi migpelesut kenagda diyà sa medoo etaw, owoy nelikuan ma dé sa medoo pikat owoy sa medoo egtodel. ");
INSERT INTO mta_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Huenan di, neanggan temù sa medoo etaw dahiya. ");
INSERT INTO mta_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na, duen sa maama, si Simon, eg-ugpà diyà iya wé menuwa. Nelugay dé eggaipen di sa medoo etaw tegeSamaliya danà sa medoo balitmata binaelan di, enù ka duen gaa sa tunung di dodoo eg-akal. ");
INSERT INTO mta_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Egdinegdinegen sa medoo etaw sa kagi di, iling ka mapulù etaw ataw ka mepokò etaw, enù ka guwaen da dò duen sa dakel tunung i Nemula diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Huenan di, egsaligan da kagdi enù ka nelugay ginaip di kagda danà sa balitmata di. ");
INSERT INTO mta_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Dodoo, egoh da migpigtuu sa Mepion Tegudon igtulù i Pilipi denu sa kedatù i Nemula owoy si Hésus Kelistu, egpebautis da ma, iling ka maama ataw ka bayi. ");
INSERT INTO mta_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Egpigtuu ma Simon i. Agulé egoh di migpebautis, eg-unut-unut ma diyà si Pilipi, owoy tigtu egkegaip egoh di mighaa sa medoo panduan binaelan i Pilipi. ");
INSERT INTO mta_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na, egoh sa salu i Hésus diyà Hélusalém neketiig migpigtuu dé sa medoo etaw tegeSamaliya diyà sa kagi i Nemula, egpeangayen da Pidelu i owoy si Huwan dutu Samaliya dò anì mulig da kenagda. ");
INSERT INTO mta_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Egoh da migtebow dutu, egsimbà da anì mekesakem sa etaw egpigtuu tegeSamaliya sa Metiengaw Suguy i Nemula, ");
INSERT INTO mta_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","enù ka apiya di pa migpebautis da egoh da egpigtuu diyà si Datù Hésus, endà pa lumuhub sa Metiengaw Suguy i Nemula diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Agulé, egoh i Pidelu owoy si Huwan migsabà kenagda, linuhub dé sa Metiengaw Suguy i Nemula kagda. ");
INSERT INTO mta_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Egoh i Simon mighaa sa medoo etaw migsakem sa Metiengaw Suguy i Nemula danà sa salu i Hésus migsabà kenagda, ungayà di begayan di kagda pilak, ");
INSERT INTO mta_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","owoy guwaen di, “Begayi yu aken siini tunung anì mekesakem da ma sa Metiengaw Suguy i Nemula sa medoo etaw egsabaan ku.” ");
INSERT INTO mta_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Dodoo egsagbì Pidelu i, guwaen di, “Mepigtamayan ka owoy mekedan sa pilak ko, enù ka guwaen ko dò mebayadan ko sa ibegay i Nemula uloy. ");
INSERT INTO mta_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Endà mekeunut ka sa egbaelan ké, enù ka endà metiengaw sa pedu ko diyà sa kehaa i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Huenan di, ekedi ko dé sa salà ko, owoy simbà ka diyà si Datù anì ipeuloy di sa medaet penemdem ko. ");
INSERT INTO mta_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Netiigan ku tigtu egkesina ka, owoy neudipen ka pelà danà sa salà ko.” ");
INSERT INTO mta_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Agulé, egpegeni Simon i diyà si Pidelu owoy si Huwan, guwaen di, “Simbai yu aken diyà si Datù anì endà meketuu sa inikagi ko denu kenak.” ");
INSERT INTO mta_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Na, tinulon i Pidelu owoy si Huwan sa kagi i Datù owoy sa binaelan di hinaa da. Agulé, eglikù da Hélusalém dò, dodoo igtulù da ma sa Mepion Tegudon diyà sa medoo menuwa inukitan da diyà uwang Samaliya. ");
INSERT INTO mta_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na, duen sa egsugùsuguen i Nemula egpehaa diyà si Pilipi, owoy eg-ikagi, guwaen di, “Angay ka dé dutu siedò dalan kedu Hélusalém eg-angay dutu menuwa Gasa dò. Iya sa dalan eg-ukit diyà sa melabel tanà mediyù dalesan.” ");
INSERT INTO mta_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Agulé migpangunut Pilipi i owoy mig-angay dutu siedò dalan. Na, duen sa maama tegeItiyopiya miglikù kedu Hélusalém dò, sa keduwan di egsimbà. Dakel sa gelal di enù ka kagdi sa tegeipat pilak sa bayi booy diyà tanà Itiyopiya, kepengadan da si Kandasi. ");
INSERT INTO mta_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Miglikù iya wé maama kedu Hélusalém dò. Ligò di eg-edà sa kalisa di, egbasawen di sa libelu igsulat i Isayas sa tegesugkow i Nemula egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Agulé, eg-ikagi sa Metiengaw Suguy i Nemula diyà si Pilipi, guwaen di, “Lohot ka owoy peunut ka diyà sa kalisa.” ");
INSERT INTO mta_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Agulé egletu Pilipi i, owoy egdinegen di sa maama épê gelal egbasa diyà sa libelu igsulat i Isayas sa tegesugkow i Nemula egoh anay. Eg-igsà Pilipi i, guwaen di, “Netiigan ko pa sa egbasawen ko?” ");
INSERT INTO mta_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Egsagbì sa maama épê gelal, guwaen di, “Endà netiigan ku duu, enù ka endà duen etaw egtulù kenak.” Agulé, pineedà di Pilipi i diyà sa kalisa di. ");
INSERT INTO mta_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na, ini sa kagi i Nemula egbasawen sa maama épê gelal, guwaen di, “Kagdi lagà sa kebilibili endà mulit di amuk sapuen etaw, owoy lagà ma anak kebilibili endà mikagi di amuk guntingen etaw sa bulbul di, enù ka apiya di pa medaet sa egbaelan etaw diyà kenagdi, endà doo duen kagi di. ");
INSERT INTO mta_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Apiya di pa endà duen salà di, peumàumaan da doo owoy pigtamayan da. Endà duen tugod di, enù ka imatayan da kagdi.” ");
INSERT INTO mta_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Agulé, eg-igsà sa maama épê gelal diyà si Pilipi, guwaen di, “Ngadan di etaw tinulon sa tegesugkow i Nemula migsulat ini i, iling ka kagdi ataw ka sa sebaen ma etaw? Tuloni ko aken, hih.” ");
INSERT INTO mta_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Agulé, eg-edung Pilipi i egselepang iya wé kagi i Nemula igsulat i Isayas, owoy egtulonen di diyà kenagdi sa Mepion Tegudon denu si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Agulé egoh da eg-ipanaw, migtebow da diyà sa lawaꞌt wayeg. Eg-ikagi sa maama épê gelal, guwaen di, “Duen sa wayeg dini. Mebaluy pa amuk bautisan ko aken?” ");
INSERT INTO mta_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Egsagbì Pilipi i, guwaen di, “Mebaluy doo amuk tigtu ka dé egpigtuu.” Guwaen sa maama, “Egpigtuu a dé Anak i Nemula Hésus Kelistu i.” ");
INSERT INTO mta_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Agulé egpeugpaen di sa kalisa di. Eg-angay da dalem sa wayeg owoy egbautisan i Pilipi. ");
INSERT INTO mta_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Egoh da miglaun kedu diyà sa wayeg, kinedanan sa Suguy i Nemula Pilipi i. Endà dé hinaa sa maama épê gelal Pilipi i, dodoo mepion doo sa pedu di egoh di eg-uman eg-ipanaw. ");
INSERT INTO mta_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Agulé, hinaa polo Pilipi i dutu menuwa Asoto dò. Eglagbas dutu Sisaliya dò, dodoo egoh di eg-ipanaw, takà egtulù sa Mepion Tegudon diyà sa langun menuwa inukitan di. ");
INSERT INTO mta_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na, takà eglimedangen i Saulo sa medoo etaw egpigtuu diyà si Datù enù ka ungayà di imatayan di kagda. Mig-angay diyà sa Tigtu Ulu-ulu Tegesimbà, ");
INSERT INTO mta_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","owoy kinuwa di sa sulat uwiten di diyà sa medoo simbaan Hudiyu diyà menuwa Damasko anì mebaluy sigkemen di sa medoo etaw egpigtuu diyà si Datù, iling ka maama ataw ka bayi, anì agaken di kagda dutu Hélusalém dò anì bilangguwen di. ");
INSERT INTO mta_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Dodoo egoh i Saulo medapag diyà Damasko, petow dé nelegdawan sa dakel legdaw kedu langit dò. ");
INSERT INTO mta_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Agulé nekelagkeb diyà tanà, owoy dinineg di sa eg-ikagi kedu diyà langit, guwaen di, “O Saulo, maen di ya egpelihayen ko aken?” ");
INSERT INTO mta_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Eg-igsà Saulo i, guwaen di, “Ngadan ko ya etaw?” Guwaen di egsagbì, “Aken si Hésus sa egpelihayen ko. ");
INSERT INTO mta_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tigdeg ka dé, lagbas ka dutu Damasko dò kenà ko metulonon sa baelan ko.” ");
INSERT INTO mta_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Na, tigtu nelimedangan sa medoo duma i Saulo owoy neiyem da ma, enù ka uloy dé dinineg da sa eg-ikagi, endà duen etaw hinaa da. ");
INSERT INTO mta_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Agulé egtigdeg Saulo i, dodoo egoh di eglimata, endà dé eg-ilag di. Huenan di, egsabaan da sa belad di owoy eg-agaken da diyà Damasko. ");
INSERT INTO mta_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Telu agdaw sa lugay di endà eg-ilag, owoy endà ma nekekaen di owoy endà ma nekeinem di. ");
INSERT INTO mta_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Duen sa sebaen etaw egpigtuu eg-ugpà diyà Damasko, si Ananiyas. Egpehaa Datù i diyà kenagdi, owoy guwaen di, “O Ananiyas.” Egsagbì Ananiyas i, guwaen di, “O Datù, ngadan sa ungayà ko diyà kenak?” ");
INSERT INTO mta_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Guwaen i Datù diyà kenagdi, “Angay ka diyà sa dalan kepengadan da Metudà, owoy lagbet ko sa dalesan i Hudas enù ka iya sa kenà i Saulo tegeTalesu eg-ugpà. Egsimbà diyà kenak. ");
INSERT INTO mta_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Duen ma sa igpehaa ku diyà kenagdi sa egoh ko migtebow owoy egsabà kenagdi anì umilag dema.” ");
INSERT INTO mta_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Dodoo egsagbì Ananiyas i, guwaen di, “O Datù, medoo sa etaw migtulon diyà kenak denu kenagdi owoy denu sa medaet binaelan di diyà sa medoo etaw egpigtuu dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mig-angay ma dahini diyà Damasko owoy inuwit di sa sulat kedu sa medoo ulu-ulu tegesimbà diyà Hélusalém anì mebaluy sigkemen di sa langun etaw egsimbà diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Dodoo eg-ikagi Datù i diyà si Ananiyas, guwaen di, “Angay ka dutu, enù ka hinemilì ku kagdi i anì tumulon denu kenak diyà sa medoo etaw beken Hudiyu owoy diyà sa medoo datù owoy diyà keniyu i tugod i Islaél. ");
INSERT INTO mta_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Owoy ipetiig ku diyà kenagdi sa kelikutan mehaa di danà di egpangunut diyà kenak.” ");
INSERT INTO mta_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Agulé, eg-angay Ananiyas i diyà sa dalesan kenà i Saulo eg-ugpà. Egoh di miggemow, egsabaan di Saulo i owoy guwaen di, “O Akay, si Datù Hésus sa hinaa ko diyà dalan egoh ko mig-angay dini. Pineangay di aken diyà keniko anì umilag ka dema owoy anì lumuhub sa Metiengaw Suguy i Nemula diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hê, petow dé duen sa éhê enil sedà nekedan diyà sa mata i Saulo owoy mig-ilag dé. Agulé egpebautis dé. ");
INSERT INTO mta_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Egoh di migkaen, egkepion dé sa nanam di. Na, nelugaylugay eg-ugpà Saulo i diyà sa medoo etaw egpigtuu diyà Damasko. ");
INSERT INTO mta_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Agulé eg-angay diyà sa medoo simbaan Hudiyu, owoy itulù di diyà sa medoo etaw Anak i Nemula Hésus i. ");
INSERT INTO mta_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tigtu negaip sa langun etaw migdineg sa kagi di, owoy egseolomoy da, guwaen da, “Tuu ataw ka endà, kagdi sa takà egpelihay sa medoo etaw egpigtuu dutu Hélusalém dò? Mig-angay dini gaa anì sigkemen di sa etaw egpigtuu diyà si Hésus anì agaken di kagda diyà sa medoo ulu-ulu tegesimbà.” ");
INSERT INTO mta_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Dodoo egkebagel sa ketegudon i Saulo egoh di egtulù denu si Hésus sa Tigtu Datù sinugù i Nemula. Endà mekeatu sa medoo Hudiyu tegeDamasko kenagdi, enù ka tigtu mepion sa kagi di. ");
INSERT INTO mta_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Agulé nelugaylugay, duen etaw Hudiyu endà egpigtuu egseolomoy da denu sa keimatay da si Saulo. ");
INSERT INTO mta_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Agdaw owoy sigep, egbantayan da sa bengawan sa kutà menuwa Damasko anì imatayan da kagdi. Dodoo duen sa etaw migtulon diyà si Saulo sa ungayà da. ");
INSERT INTO mta_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Huenan di, egbuligan sa medoo etaw egpigtuu kagdi i. Hê, egoh di teliwadà sigep, egdalemen da kagdi diyà sa amayan alat owoy egtuntunen da kedu sa tatawan diyà sa kutà menuwa Damasko anì melaguy. ");
INSERT INTO mta_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na, egoh i Saulo migtebow dutu Hélusalém dò, ungayà di eg-unut sa medoo etaw egpigtuu dahiya. Dodoo egkelimedangan da enù ka guwaen da dò endà pa egpigtuu di. ");
INSERT INTO mta_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Dodoo eg-uwiten i Bilnabi Saulo i diyà sa medoo salu i Hésus, owoy egtulonen di diyà kenagda denu sa egoh i Datù migpehaa owoy mig-ikagi diyà si Saulo diyà sa dalan. Egtulonen di ma diyà kenagda mebagel sa ketegudon i Saulo denu si Hésus diyà Damasko. ");
INSERT INTO mta_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Agulé, eg-unut-unut Saulo i diyà sa medoo etaw tegeHélusalém egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mebagel ma sa ketegudon di enù ka pineangay i Datù kagdi i. Egtulù ma diyà sa medoo Hudiyu eg-ikagi Geligu, owoy egseolomoy da. Dodoo ungayà da polo imatayan da. ");
INSERT INTO mta_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Agulé egoh sa medoo duma di neketiig iya wé, eg-uwiten da dutu Sisaliya dò, owoy pineedà da diyà sa dakel kumpit mangay dutu Talesu dò. ");
INSERT INTO mta_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Huenan di, migkelanih dé sa keugpà sa medoo etaw egpigtuu diyà sa langun menuwa diyà uwang Hudiya owoy uwang Galiliya owoy uwang Samaliya. Migkebagel sa kepigtuu da owoy migkedoo da ma danà sa ketabang sa Metiengaw Suguy i Nemula kenagda, owoy egpangunut da ma dé diyà si Datù. ");
INSERT INTO mta_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, egtukiden i Pidelu eglengenan sa medoo menuwa etaw egpigtuu. Na, sebaen agdaw migtebow diyà sa menuwa Lida, ");
INSERT INTO mta_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","owoy duen sa maama pikat hinaa di, si Iniyas, takà daa eg-idegà taman walu gepalay. ");
INSERT INTO mta_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Eg-ikagi Pidelu i diyà kenagdi, guwaen di, “O Akay Iniyas, enaw ka dé, enù ka bulungan i Hésus Kelistu kuna. Dilin ko dé sa ikam ko.” Hê, petow dé mig-enaw Iniyas i. ");
INSERT INTO mta_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hinaa sa langun etaw tegeLida iya wé owoy sa medoo etaw diyà sugud Salon. Huenan di, tinuing da dé sa pedu da diyà si Datù. ");
INSERT INTO mta_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na diyà menuwa Hopi, duen sa bayi egpigtuu, si Tabita. Pinengadanan ma si Dolekas diyà sa kagi Geligu, owoy iya sa selepangan di, seladeng. Tigtu mepion etaw enù ka egbuligan di takà sa medoo etaw pubeli. ");
INSERT INTO mta_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Egoh iya, eglinadu Tabita i, hê nematay dé. Pinedigus da sa lawa di owoy itagù da diyà sa bilik di diatas. ");
INSERT INTO mta_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Egoh sa medoo etaw egpigtuu neketiig dutu Lida dò Pidelu i, sinugù da sa duwa etaw anì ipeangay da Pidelu i, enù ka medapag sa menuwa Lida diyà sa menuwa da. Egpegeni da diyà kenagdi, guwaen da, “O Akay, tétéél ka, hih. Angay ka Hopi dò.” ");
INSERT INTO mta_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Agulé, eg-unut Pidelu i diyà kenagda. Egoh da migtebow dutu, inuwit da kagdi diyà sa bilik diatas kenà sa medoo bayi balu egdelawit, owoy egkesetipon da diyà kenagdi anì ipehaa da sa medoo kawal owoy sa medoo ginis tinebil i Tabita egoh di endà pa nematay. ");
INSERT INTO mta_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Dodoo egpeliyuwen i Pidelu kagda. Agulé egligkued owoy egsimbà diyà si Nemula. Eg-isalu diyà sa nematay owoy guwaen di, “O Tabita, enaw ka dé.” Hê, eglimata dé Tabita i. Egoh di mighaa si Pidelu, mig-enaw dé egpenuu. ");
INSERT INTO mta_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Egsabaan i Pidelu sa belad di owoy egpetigdegen di. Agulé, eg-umowen i Pidelu sa medoo etaw egpigtuu owoy sa medoo bayi balu ma, owoy ipehaa di diyà kenagda Tabita i nehagtay dé. ");
INSERT INTO mta_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Miglalag sa egoh di mig-enaw diyà sa langun etaw diyà menuwa Hopi, huenan di egpigtuu dé sa medoo etaw diyà si Datù. ");
INSERT INTO mta_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Agulé, nelugaylugay eg-ugpà Pidelu i diyà menuwa Hopi diyà sa dalesan i Simon, sa tegegalebek kunul hinagtay. ");
INSERT INTO mta_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na, diyà menuwa Sisaliya, duen sa kapitan sundalu, si Kolniliyo. Kagdi sa ulu-ulu sa magatus sundalu, kepengadan da sa Umpungan tegeItaliya. ");
INSERT INTO mta_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Apiya beken etaw Hudiyu, metiengaw doo owoy egpigtuu ma diyà si Nemula lapeg sa malayan di. Egbegayan di ma pilak sa pubeli etaw Hudiyu enù ka eghiduwan di kagda, owoy takà egsimbà ma diyà si Nemula. ");
INSERT INTO mta_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na, sebaen agdaw egoh di alas telu mahapun, duen sa nehauwan i Kolniliyo. Tigtu hinaa di sa egsugùsuguen i Nemula migtebow diyà kenagdi, owoy guwaen di, “O Kolniliyo.” ");
INSERT INTO mta_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Hê, eg-inengtengen i Kolniliyo apiya di pa tigtu egkelimedangan. Egsagbì, guwaen di, “O Datù, ngadan sa ungayà ko diyà kenak?” Eg-ikagi sa egsugùsuguen i Nemula, guwaen di, “Dinineg i Nemula sa kesimbà ko diyà kenagdi. Netiigan di ma sa kehidu ko sa medoo etaw egkepasangan, owoy netuuwan ma. ");
INSERT INTO mta_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na, sugù ko sa etaw ko mangay Hopi dò anì angayen da Simon i pinengadanan da ma si Pidelu. ");
INSERT INTO mta_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Eg-ugpà dutu medapag dagat dò diyà sa dalesan sa sebaen Simon, sa tegegalebek kunul hinagtay.” ");
INSERT INTO mta_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Egoh sa egsugùsuguen i Nemula miglikù dutu langit dò, inumow i Kolniliyo sa duwa udipen tegegalebek diyà kenagdi owoy sa sebaen sundalu metiengaw kesaligan di. ");
INSERT INTO mta_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Agulé migtulon diyà kenagda denu sa hinaa di, owoy egpeangayen di kagda dutu menuwa Hopi dò. ");
INSERT INTO mta_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Agulé eg-ipanaw da dé. Egoh di nekebugsang sa umenaw simag, buyu da dumagpak diyà sa menuwa Hopi. Iya ma sa egoh i Pidelu eggemow diyà sa atep sa dalesan kenà di eg-ugpà anì eglebù egsimbà diyà si Nemula, enù ka mepatag sa atep iya wé dalesan. ");
INSERT INTO mta_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Egpeketues Pidelu i owoy ungayà di kumaen. Dodoo egoh da eglabung pelawà, duen sa ipehaa i Nemula diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Eghauwen di sa langit neukaan, owoy duen sa egketuntun kedu langit dò eg-angay diyà kenagdi éhê sa dakel kayab nesabaan diyà sa epat sulung di. ");
INSERT INTO mta_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Duen sa medoo balangan hinagtay owoy uled tanà owoy manuk tanà dalem sa kayab. ");
INSERT INTO mta_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Agulé, duen sa eg-ikagi diyà si Pidelu kedu langit dò, guwaen di, “O Pidelu, tigdeg ka dé owoy sumbalì ko sa duma dalem kayab anì mekesedà ka.” ");
INSERT INTO mta_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Dodoo egsagbì Pidelu i, guwaen di, “O Datù, meked a iya wé, anì endà meketipay a sa uledin igsugkow i Mosis denu sa kaenen melihi.” ");
INSERT INTO mta_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Duen dema sa eg-ikagi dinineg di, guwaen di, “Yaka eg-eked duu egkaen, enù ka pinepion i Nemula iya wé.” ");
INSERT INTO mta_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Taman telu gulê anan hediya iya wé binaelan di. Agulé nebatun iya wé kayab dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Egoh i Pidelu egpenemdem pelà denu sa selepangan sa hinaa di, migtebow sa medoo etaw sinugù i Kolniliyo, owoy eg-igsaen da sa kenà sa dalesan i Simon. Egoh da migtebow diyà sa dalesan di, ");
INSERT INTO mta_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","eg-umow da eg-igsà, guwaen da, “Dahini pa sa kenà i Simon Pidelu eg-ugpà?” ");
INSERT INTO mta_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Egoh i Pidelu pelà egpenemdem denu sa hinaa di, eg-ikagi sa Suguy i Nemula diyà kenagdi, guwaen di, “Taa ko, hih. Migtebow dé sa telu etaw eglagbet keniko. ");
INSERT INTO mta_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Penaug ka dé. Yaka egkesemek ka eg-unut kenagda, enù ka pineangay ku kagda diyà keniko.” ");
INSERT INTO mta_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Agulé, egpenaug Pidelu i owoy eg-ikagi diyà kenagda, guwaen di, “Aken sa maama eglagbeten yu. Ngadan sa ungayà yu diyà kenak?” ");
INSERT INTO mta_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Guwaen da egsagbì, “Si Kapitan Kolniliyo ulu-ulu sa magatus sundalu, kagdi sa migpeangay kenami dahini. Metiengaw etaw owoy egpigtuu ma diyà si Nemula owoy netuuwan ma sa medoo Hudiyu diyà kenagdi. Duen gaa sa egsugùsuguen i Nemula migsugù kenagdi anì ipeangay di kuna anì tumulù ka kenagdi.” ");
INSERT INTO mta_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Agulé, eg-ikagi Pidelu i diyà kenagda, guwaen di, “Tudug yu pelawà segdu dahini.” Hê, egoh di umenaw simag, eg-unut Pidelu i diyà kenagda, owoy eg-unut ma sa medoo Hudiyu egpigtuu kedu diyà menuwa Hopi. ");
INSERT INTO mta_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Egoh sa keduwa di agdaw, egtebow da dutu Sisaliya dò. Eg-angat-angatan i Kolniliyo kagda, owoy tapay dé sinetipon di sa medoo tigtu duma di owoy sa medoo loyuk di. ");
INSERT INTO mta_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Egoh i Pidelu migtebow dahiya, egtelabuk Kolniliyo i kenagdi owoy egligkued anì datuen di. ");
INSERT INTO mta_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Dodoo eg-ikagi Pidelu i, guwaen di, “Tigdeg ka dé. Aken sa etaw daa, beken a si Nemula. Yaka egdatù ya kenak.” Huenan di, egpetigdegen di Kolniliyo i. ");
INSERT INTO mta_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Agulé egseolomoy da, owoy eggemow da diyà sa dalesan kenà sa medoo etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Eg-ikagi Pidelu i diyà kenagda, guwaen di, “Netiigan yu doo endà mepion di diyà sa adat ké amuk eglengen sa etaw Hudiyu diyà sa etaw beken Hudiyu. Hediya ma, endà mepion di amuk dumuma sa etaw Hudiyu diyà sa etaw beken Hudiyu. Aken sa etaw Hudiyu, owoy kiyu sa etaw beken Hudiyu. Dodoo igpetiig i Nemula diyà kenak anì endà dé umeked a lumoyuk sa etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Huenan di, egoh ko migpeangay kenak, migpangunut a owoy mig-angay a dini. Na, Akay, ngadan sa pesuwan ko egpeangay kenak?” ");
INSERT INTO mta_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Egsagbì Kolniliyo i, guwaen di, “Egoh di telu dé agdaw alas telu mahapun, egsimbà a diyà sa dalesan ku. Petow dé migpehaa diyà kenak sa egsugùsuguen i Nemula migkawal mebulà, ");
INSERT INTO mta_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","owoy guwaen di diyà kenak, ‘O Kolniliyo, dinineg i Nemula sa kesimbà ko diyà kenagdi. Netiigan di ma sa kehidu ko sa medoo etaw egkepasangan. ");
INSERT INTO mta_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Sugù ko sa etaw ko mangay Hopi dò anì angayen da Simon i pinengadanan da ma si Pidelu. Eg-ugpà dutu medapag dagat dò diyà sa dalesan sa sebaen Simon, sa tegegalebek kunul hinagtay.’ ");
INSERT INTO mta_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Huenan di, medelamet a migpeangay keniko. Mepion enù ka dini ka dé. Na Akay, nesetipon ké langun anì dinegen ké sa kagi i Nemula isugkow ko diyà kenami.” ");
INSERT INTO mta_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Na, eg-edung Pidelu i egtulù, guwaen di, “Netiigan ku doo endà tuu di amuk iya daa sa eghiduwan i Nemula sa etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Dodoo egketuuwan ma diyà sa langun etaw egpangunut diyà kenagdi owoy sa egbael mepion, iling ka etaw Hudiyu ataw ka beken etaw Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Netiigan yu ma doo pineangay i Nemula Hésus i diyà kenami i tugod i Islaél anì tumulù kenita sa Mepion Tegudon denu sa melanih pedu ibegay di diyà sa langun etaw egpigtuu diyà si Hésus Kelistu, sa Datù ta langun. ");
INSERT INTO mta_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Netiigan yu ma doo sa binaelan di diyà tanà Hudiya, enù ka egoh i Huwan neubus migtulù denu sa kebautis di, eg-edung Hésus i egtulù diyà uwang Galiliya. ");
INSERT INTO mta_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Netiigan yu ma doo pineluhuban i Nemula Hésus i tegeNasalét sa Metiengaw Suguy di owoy tinunungan di kagdi. Sumalà dé sa inangayan di, egbaelan di sa mepion owoy egbulungan di ma sa medoo etaw kinudì i Satanas, enù ka egtabangan i Nemula kagdi. ");
INSERT INTO mta_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Hinaa ké sa langun binaelan di dutu Hélusalém dò owoy diyà sa medoo menuwa diyà uwang Hudiya. Agulé, inimatayan da kagdi danà da migtutuk diyà sa kayu igbugsud. ");
INSERT INTO mta_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dodoo inenaw i Nemula mendaa diyà sa ketelu di agdaw, owoy igpehaa di diyà kenami. ");
INSERT INTO mta_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Endà langun di etaw sa mighaa kenagdi, dodoo kami daa sa mighaa kenagdi sa hinemilì i Nemula anì tumulon ké denu kenagdi, owoy mig-unut ké kenagdi egkaen owoy eg-inem egoh di mig-enaw dé. ");
INSERT INTO mta_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Owoy sinugù di kami anì tumulù ké diyà sa medoo etaw sa Mepion Tegudon, owoy egtulonen ké si Hésus sa hinemilì i Nemula anì tepengan di sa langun etaw, iling ka nematay dé ataw ka nehagtay pelà, anì ipetiig di ma sa ketamanan da. ");
INSERT INTO mta_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Migsulat sa langun tegesugkow i Nemula egoh anay denu kenagdi, enù ka tinulon da sumalà dé sa etaw egpigtuu, ipeuloy i Nemula sa salà da danà i Hésus.” ");
INSERT INTO mta_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na, egoh i Pidelu eg-ikagi pelà, egtenà sa Metiengaw Suguy i Nemula diyà sa medoo etaw egdineg sa tegudon di. ");
INSERT INTO mta_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Tigtu negaip sa langun etaw Hudiyu egpigtuu mig-unut si Pidelu kedu Hopi dò, enù ka igpeluhub i Nemula ma sa Metiengaw Suguy di diyà sa etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Negaip da enù ka dinineg da sa medoo etaw beken Hudiyu eg-ikagi sa medoo balangan kagi endà netiigan da duu owoy eg-olò da ma si Nemula. Agulé, eg-ikagi Pidelu i diyà sa medoo duma di Hudiyu, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“O medoo loyuk ku, migtenà ma sa Metiengaw Suguy i Nemula diyà kenagda éhê mendaa sa kinetenà di diyà kenita. Endà dé mehawidan ta kagda egpebautis diyà wayeg.” ");
INSERT INTO mta_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Agulé, migsasà Pidelu i anì pebautis da enù ka egpigtuu da ma dé diyà si Hésus Kelistu. Agulé, egpegeni da diyà si Pidelu anì melugaylugay pelawà mugpà diyà kenagda. ");
INSERT INTO mta_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na, dinineg ma dé sa medoo salu i Hésus owoy sa medoo etaw egpigtuu diyà uwang Hudiya sa egoh sa etaw beken Hudiyu egpigtuu dé diyà sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Huenan di, egoh i Pidelu miglikù diyà Hélusalém, duen etaw Hudiyu egsigbolow kenagdi, enù ka ungayà da mekepangunut sa etaw beken Hudiyu diyà sa uledin igsugkow i Mosis. ");
INSERT INTO mta_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Egsigbolowen da, guwaen da, “Medaet iya wé binaelan ko, enù ka mig-ugpà ka gaa diyà sa dalesan etaw beken Hudiyu owoy mig-unut ka ma kenagda egkaen, apiya di pa endà pinekelaingan da ipat.” ");
INSERT INTO mta_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Huenan di, sinelepang i Pidelu diyà kenagda sa langun nebaelan di kedu diyà sa edungan di. ");
INSERT INTO mta_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Guwaen di, “Egoh ku egsimbà dutu Hopi dò, duen sa igpehaa i Nemula diyà kenak. Duen sa netuntun kedu langit dò mig-angay diyà kenak éhê sa dakel kayab nesabaan diyà sa epat sulung di. ");
INSERT INTO mta_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Eghahauwen ku dalem sa kayab, owoy hinaa ku sa medoo balangan hinagtay owoy uled tanà owoy manuk tanà. ");
INSERT INTO mta_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Agulé duen sa mig-ikagi diyà kenak, guwaen di, ‘O Pidelu, tigdeg ka dé owoy sumbalì ko sa duma dalem kayab anì mekesedà ka.’ ");
INSERT INTO mta_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Dodoo migsagbì a, guwaen ku, ‘O Datù, meked a kumaen iya wé anì endà meketipay a sa uledin igsugkow i Mosis denu sa kaenen melihi.’ ");
INSERT INTO mta_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Dodoo mig-ikagi dema diyà kenak, guwaen di, ‘Yaka eg-eked duu egkaen, enù ka pinepion i Nemula iya wé.’ ");
INSERT INTO mta_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Taman telu gulê anan hediya iya wé binaelan di. Agulé nebatun sa kayab dutu langit dò. ");
INSERT INTO mta_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Egoh sa kayab nebatun, dahiya dé sa telu etaw kedu Sisaliya dò migtebow diyà sa dalesan kenà ku eg-ugpà, enù ka eg-angayen da aken. ");
INSERT INTO mta_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Agulé mig-ikagi sa Suguy i Nemula diyà kenak, guwaen di, ‘Yaka egkesemek ka eg-unut kenagda.’ Agulé, duen sa enem etaw egpigtuu kedu diyà Hopi mig-unut kenak eg-angay Sisaliya dò, owoy miggemow ké diyà sa dalesan i Kolniliyo sa etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tinulon i Kolniliyo ma diyà kenami migpehaa sa egsugùsuguen i Nemula diyà kenagdi diyà sa dalesan di. Mig-ikagi gaa sa egsugùsuguen i Nemula, guwaen di, ‘Sugù ko sa etaw ko mangay Hopi dò anì angayen da Simon i pinengadanan da ma si Pidelu. ");
INSERT INTO mta_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Tuluen di kuna owoy sa medoo etaw eg-ugpà diyà sa dalesan ko anì mealukan yu langun denu sa salà yu.’ ");
INSERT INTO mta_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Agulé, egoh ku mig-edung egtulù kenagda, migtenà sa Metiengaw Suguy i Nemula diyà kenagda lagà mendaa sa kinetenà di diyà kenita egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Agulé netulengan ku sa kagi i Datù, guwaen di, ‘Egoh anay migbautis si Huwan sa medoo etaw diyà wayeg anì tandaan da sa kepigtuu da, dodoo iya sa ibautis i Nemula keniyu sa Metiengaw Suguy di lumuhub diyà keniyu.’ ");
INSERT INTO mta_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Huenan di, nesetepeng doo sa igbegay di diyà sa etaw beken Hudiyu owoy sa igbegay di diyà kenita i etaw Hudiyu egoh ta migpigtuu diyà si Datù Hésus Kelistu. Huenan di, endà mealang ku duu sa egbaelan i Nemula.” ");
INSERT INTO mta_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na, egoh da migdineg sa inikagi i Pidelu, endà dé egsigbolowen da duu, dodoo eg-oloen da Nemula i, guwaen da, “Apiya sa etaw beken Hudiyu, mebegayan i Nemula doo kagda sa lalù endà meelut di amuk eg-ekedan da sa salà da.” ");
INSERT INTO mta_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Na, edung sa egoh i Estiban nematay, tigtu nepelihay sa medoo etaw egpigtuu. Egoh da migpelaguy, nesepalak da diyà sa uwang Ponisiya owoy diyà sa pungul Sipeli owoy diyà sa menuwa Antiokiya diyà uwang Siliya. Egtulon da sa kagi i Nemula diyà sa medoo duma da Hudiyu daa. ");
INSERT INTO mta_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Dodoo duen etaw egpigtuu tegeSipeli owoy tegeSilini mig-angay diyà sa menuwa Antiokiya, owoy egtulonen da ma sa Mepion Tegudon denu si Datù Hésus diyà sa medoo etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Egtabangan i Nemula kagda, huenan di duen medoo etaw tegeAntiokiya migtuing sa pedu da owoy egpigtuu da dé diyà si Datù. ");
INSERT INTO mta_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na, egoh sa etaw tegeHélusalém egpigtuu neketiig iya wé, egpeangayen da Bilnabi i dutu Antiokiya dò. ");
INSERT INTO mta_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Mepion etaw Bilnabi i owoy mebagel sa kepigtuu di danà di linuhub sa Metiengaw Suguy i Nemula. Egoh di migtebow diyà Antiokiya, neanggan temù enù ka hinaa di sa egoh i Nemula tigtu egtabang kenagda. Agulé, egtulù diyà kenagda anì endà egkeduwa sa pedu da anì peelesen da sa kepigtuu da diyà si Datù. Egoh da migdineg sa kagi di, egkedoo ma dé sa etaw egpigtuu diyà si Datù. ");
INSERT INTO mta_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Agulé, eg-angay Bilnabi i diyà menuwa Talesu anì lagbeten di Saulo i. ");
INSERT INTO mta_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Egoh di mighaa kenagdi, inuwit di dutu Antiokiya dò kenà da eg-ugpà taman segepalay, owoy egtuluen da sa medoo etaw. Na, sa medoo etaw egpigtuu diyà Antiokiya, iya sa anay pinengadanan da Etaw i Kelistu. ");
INSERT INTO mta_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Na, egoh da pelà diyà Antiokiya, duen duma tegesugkow i Nemula migtebow kedu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Iya sa sebaen tegesugkow i Nemula diyà kenagda, si Agabu. Egtigdeg owoy pinetulon sa Metiengaw Suguy i Nemula kagdi denu sa dakel bitil tumebow diyà sa langun menuwa diyà tanà. Na, mig-ukit iya wé egoh i Keladiyo sa sulutan diyà Loma. ");
INSERT INTO mta_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Agulé, nesesebaen sa penemdem sa medoo etaw tegeAntiokiya egpigtuu anì mulig da sa medoo duma da egpigtuu dutu Hudiya dò. Ipeuloy sa uman sebaen etaw sa hagdi mekebegay. ");
INSERT INTO mta_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Egoh da migtipoh sa igtabang da, egpeangayen da Bilnabi i owoy si Saulo anì uwiten da diyà sa medoo kaunutan etaw egpigtuu dutu Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na egoh iya, eg-edung si Datù Hélod egpelihay sa medoo etaw egpigtuu diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Igpeimatay di Santiyago i kakay i Huwan egpetigbas sundang. ");
INSERT INTO mta_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Agulé, neanggan sa medoo Hudiyu endà egpigtuu. Egoh i Hélod neketiig neanggan da, igpesigkem di ma Pidelu i. Iya sa binaelan di egoh sa pista Hudiyu egoh da egkaen sa epan endà duen ipelenuk di. ");
INSERT INTO mta_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Egoh da migsigkem si Pidelu, egbilangguwen da owoy egbantayan sa sepulù owoy enem sundalu. Tig-epatay da egsesambìsambiay egbantay, enù ka ungayà i Hélod ipeimatay di Pidelu i amuk meubus sa pista da anì hauwen sa langun etaw. ");
INSERT INTO mta_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Dodoo egoh i Pidelu nebilanggu, tigtu da isimbà diyà si Nemula sa medoo etaw egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Na, egoh sa sigep egoh di umenaw simag sa atas i Hélod egpeimatay si Pidelu, egtudug Pidelu i teliwadà sa duwa etaw egbantay. Nesebalà sa belad di pinolot duwa sangkalì, owoy duen ma sa duwa sundalu egbantay bengawan sa bilangguwan. ");
INSERT INTO mta_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Petow dé nelegdawan sa dalem bilangguwan enù ka duen sa egsugùsuguen i Nemula egtigdeg dahiya. Egkugowen di Pidelu i anì enawen di, owoy guwaen di, “Téél ka. Enaw ka dé.” Hê, nelengà sa sangkalì diyà sa belad di. ");
INSERT INTO mta_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Agulé, eg-ikagi sa egsugùsuguen i Nemula diyà kenagdi, guwaen di, “Eles ko sa ginis ko owoy talumpà ka dé.” Egoh i Pidelu migpangunut, eg-ikagi dema sa egsugùsuguen i Nemula, guwaen di, “Kawal ka dé owoy unut ka kenak.” ");
INSERT INTO mta_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Huenan di, mig-unut Pidelu i diyà sa egsugùsuguen i Nemula, dodoo endà netiigan di duu amuk tuu sa egbaelan di, enù ka guwaen di dò tegeinep di daa. ");
INSERT INTO mta_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Egoh da migtalà diyà sa muna tegebantay owoy sa keduwa di, egtebow da diyà sa dakel pintù putow eg-angay diyà liyu sa bilangguwan. Petow dé neukaan peiges sa pintù, hê nekelaun da dé. Hê, egoh da eg-ipanaw diyà sa kalasada, petow dé nekedan sa egsugùsuguen i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Agulé, egoh i Pidelu neketiig sa nebaelan di, guwaen di, “Netiigan ku ini i. Pineangay i Datù sa egsugùsuguen di anì launen di aken kedu sa egkegaga i Hélod, anì endà meketuu di sa kepatay ku eg-angat-angatan sa medoo Hudiyu endà egpigtuu.” ");
INSERT INTO mta_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Egoh i Pidelu egpenemdem denu iya wé, mig-angay diyà sa dalesan i Maliya, sa inay i Huwan pinengadanan da si Malkos. Nesetipon dahiya sa medoo etaw anì isimbà da kagdi. ");
INSERT INTO mta_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Egoh di migtebow dahiya, egteguktuken di sa pintù diyà liyu sa dalesan. Agulé duen sa bayi udipen, si Loda, egtelenak kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Egoh di migdineg sa kagi i Pidelu, egkilalaen di kagdi owoy tigtu neanggan, dodoo endà eg-ukaan di duu enù ka migpedelamet polo egpelikù diatas anì tulonen di diyà sa medoo duma di migtebow dé Pidelu i diyà sa liyu sa dalesan. ");
INSERT INTO mta_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Dodoo guwaen da diyà kenagdi, “Egkelengleng ka kéen.” Dodoo takà eg-ikagi, guwaen di, “Tuu, dahiya Pidelu ya.” Huenan di, guwaen da, “Iya kéen sa egsugùsuguen i Nemula egtulik kenagdi.” ");
INSERT INTO mta_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Dodoo takà egteguktuk Pidelu i taman endà eg-ukaan da duu. Agulé, egoh da mighaa kenagdi, tigtu negaip da. ");
INSERT INTO mta_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Binegeng i Pidelu sa belad di anì endà egséléken da, owoy egtulonon di kagda denu sa kelengà i Nemula kenagdi kedu diyà sa bilangguwan. Guwaen di ma, “Tuloni ko si Santiyago owoy sa medoo duma ta egpigtuu.” Agulé, eglegkang Pidelu i eg-angay diyà sa sebaen ma dalesan. ");
INSERT INTO mta_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Egoh di umenaw simag, tigtu negaip sa medoo sundalu diyà sa bilangguwan enù ka endà netiigan da duu sa inangayan i Pidelu. ");
INSERT INTO mta_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Agulé, sinugù i Hélod anì lagbeten da Pidelu i, dodoo endà hinaa da duu. Sinugù di anì igsaan sa medoo tegebantay, dodoo endà netiigan da duu sa kenà i Pidelu. Huenan di, igpeimatay di kagda langun. Agulé, eglegkang Hélod i kedu diyà uwang Hudiya, owoy eg-angay eg-ugpà dutu Sisaliya dò. ");
INSERT INTO mta_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na sebaen agdaw, tigtu egbulitan i Hélod sa medoo etaw tegeTilo owoy tegeSidon. Huenan di, neseunut da eg-angay diyà kenagdi anì seantangay da, enù ka kagdi sa Datù eg-ipat sa tanà kenà da egkuwa kaenen. Egloyuken da Belasto i, sa etaw tegebulig si Hélod, anì tabangan di kagda. ");
INSERT INTO mta_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Egoh di neuma sa agdaw da umantang, egkawal Hélod i sa metolol kawal datù owoy egpenuu diyà sa bangkù sa datù, owoy eg-ikagi diyà sa medoo etaw nesetipon. ");
INSERT INTO mta_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Agulé eg-oloen da, guwaen da, “Beken uloy etaw daa ini i eg-ikagi, dodoo si Nemula dé polo.” ");
INSERT INTO mta_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Hê petow dé pinigtamayan sa egsugùsuguen i Nemula Hélod i, enù ka endà hinawidan di duu sa keolò da kenagdi. Agulé, nematay dé kinaen bitek. ");
INSERT INTO mta_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Na, nekeseluh uman sa kagi i Nemula, owoy egkedoo dé sa etaw egpigtuu. ");
INSERT INTO mta_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Agulé egoh i Bilnabi owoy si Saulo neubus da mighated pilak diyà menuwa Hélusalém, eglikù da dutu Antiokiya dò owoy pineunut da ma si Huwan Malkos. ");
INSERT INTO mta_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na, diyà sa umpungan i Hésus diyà Antiokiya, duen sa etaw tegetulon sa kagi i Nemula egtebowtebow owoy duen ma sa tegetulù sa kagi i Nemula. Langun da si Bilnabi, owoy si Simiyon pinengadanan da si Meitem, owoy si Lusiyo tegeSilini, owoy si Saulo, owoy si Manain sa nekeunut si Gubilenu Hélod migkedakel egoh da batà pelà. ");
INSERT INTO mta_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na, sebaen agdaw egpeulanen sa medoo etaw tegeAntiokiya egpigtuu sa kekaen da anì sumimbà da diyà si Nemula. Ligò da egsimbà, mig-ikagi sa Metiengaw Suguy i Nemula diyà kenagda, guwaen di, “Hemilì yu Bilnabi i owoy si Saulo, enù ka duen sa galebek ipebael ku diyà kenagda.” ");
INSERT INTO mta_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Agulé, egpeulanen da sa kekaen da anì isimbà da kagda diyà si Nemula owoy egsabaan da ma anì tandaan da kagda sa hinemilì i Nemula. Agulé egpeipanawen da kagda. ");
INSERT INTO mta_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Na, pineangay sa Metiengaw Suguy i Nemula Bilnabi i owoy si Saulo, huenan di eglagbas da diyà sa menuwa Silusiya owoy eg-edà da sa dakel kumpit eg-angay dutu pungul Sipeli dò. ");
INSERT INTO mta_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Egoh da migtebow diyà sa menuwa Salamis, egtulù da dahiya sa kagi i Nemula diyà sa simbaan Hudiyu. Mig-unut ma si Huwan Malkos anì egbuligan di kagda. ");
INSERT INTO mta_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Na, egoh da migtukid sa medoo menuwa diyà siedò pungul, migtebow da diyà sa menuwa Papos. Hinaa da dahiya sa etaw Hudiyu, si Balhésus, sa tegebael balitmata, owoy ubòubò kagdi gaa sa tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Egloyuken di sa gubilenu diyà siedò pungul, si Silgio Paulo. Tigtu milantek sa gubilenu, owoy igpeangay di Bilnabi i owoy si Saulo enù ka egkeiyap dumineg sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Dodoo egbogowen sa tegebael balitmata kagda, enù ka ungayà di endà migtuu sa gubilenu sa kagi i Nemula. Na, si Ilimas sa kepengadan da sa tegebael balitmata diyà sa kagi Geligu. ");
INSERT INTO mta_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Agulé, linuhub sa Metiengaw Suguy i Nemula Saulo i pinengadanan da si Pabelo. Eg-inengtengen di Ilimas i, ");
INSERT INTO mta_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","owoy guwaen di, “Kuna sa etaw i Satanas, enù ka egkuntelaen ko sa langun mepion owoy tegeakal ka etaw. Egpebutbuten ko hedem sa tuu kagi i Nemula anì endà pigtuuwen di etaw. ");
INSERT INTO mta_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na, melangap ka dé ini egoh di, enù ka pigtamayan i Nemula kuna. Endà umilag ka taman melugaylugay.” Hê petow dé linabunan sa mata di, owoy endà ma eg-ilag di. Huenan di, egpeakap-akap eglagbet sa etaw umagak kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Egoh sa gubilenu mighaa iya wé, egpigtuu dé enù ka tigtu netuuwan diyà sa ketulù i Pabelo denu si Datù. ");
INSERT INTO mta_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Agulé, mig-edà Pabelo i owoy sa medoo duma di diyà sa dakel kumpit diyà menuwa Papos eg-angay dutu menuwa Pilga dò diyà uwang Pampiliya. Dodoo egoh da migtebow dahiya, sinalidan i Huwan Malkos kagda enù ka miglikù Hélusalém dò. ");
INSERT INTO mta_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na, eglegkang Pabelo i owoy si Bilnabi diyà sa menuwa Pilga, owoy eg-angay da dutu Antiokiya dò diyà uwang Pisidiya. Agulé, egoh di neuma sa agdaw keetud etaw Hudiyu, eg-angay da dalem sa simbaan Hudiyu owoy egpenuu da ma. ");
INSERT INTO mta_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Egbasawen sa ulu-ulu simbaan sa kagi i Nemula igsulat i Mosis owoy sa igsulat sa medoo tegesugkow i Nemula. Agulé, igsasà sa ulu-ulu Pabelo i owoy si Bilnabi, guwaen di, “O Akay, meiyap ké amuk mikagi yu diyà sa medoo etaw nesetipon amuk duen sa itulù yu diyà kenami.” ");
INSERT INTO mta_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Agulé, egtigdeg Pabelo i owoy binegeng di sa belad di anì endà suméléken da. Guwaen di, “O medoo duma ku tugod i Islaél owoy langun yu etaw beken Hudiyu egsimbà diyà si Nemula, dinegdineg yu sa kagi ku. ");
INSERT INTO mta_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Si Nemula sa inunutan ta, kita i tugod i Islaél, kagdi sa mighemilì sa tupù ta egoh anay. Egoh da mig-ugpà pelawà dutu Igiptu dò, tinabangan di kagda owoy migkedoo da ma dutu. Inuwit i Nemula kagda kedu diyà Igiptu danà sa dakel egkegaga di, ");
INSERT INTO mta_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","owoy egbuligan di kagda taman epat pulù gepalay egoh da diyà sa melabel tanà mediyù dalesan, apiya di pa endà egpigtuuwen da duu kagdi i. ");
INSERT INTO mta_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Agulé igpeimatay i Nemula sa pitu balangan etaw diyà sa tanà Kanan, owoy igbegay di sa tanà diyà sa etaw hinemilì di. ");
INSERT INTO mta_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na, epat gatus owoy lima pulù gepalay sa lugay di egoh sa tupù ta mig-angay Igiptu dò taman sa egoh da migsakem sa tanà igbegay i Nemula. “Agulé ginelal i Nemula sa medoo ulu-ulu da nesetugodtugod taman sa egoh i Samuwél sa tegesugkow i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Agulé, pinegeni da anì dumuen sa datù da. Huenan di, ginelal i Nemula Saulo i, sa anak i Kis tugod i Bénhamin. Epat pulù gepalay sa lugay sa kedatù i Saulo. ");
INSERT INTO mta_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Agulé egoh i Nemula migkedan si Saulo, hinemilì di Dabid i anì egkedatù diyà kenagda. Guwaen i Nemula denu si Dabid, ‘Hinemilì ku dé Dabid i, sa anak i Hési. Netuuwan a diyà kenagdi enù ka egpangunutan di sa langun igsugù ku kenagdi.’ ");
INSERT INTO mta_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na, si Hésus sa sebaen tugod i Dabid. Kagdi sa pineangay i Nemula anì alukan di kita i tugod i Islaél, enù ka kagdi sa igpasad i Nemula diyà sa tupù ta egoh anay. ");
INSERT INTO mta_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Egoh i Hésus endà pa egtulù, egtegudon Huwan i diyà sa langun tugod i Islaél anì ekedan da sa salà da anì egpebautis da ma. ");
INSERT INTO mta_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Egoh di buyu dé neubus sa ketegudon i Huwan, guwaen di diyà sa medoo etaw, ‘Beken aken sa eg-angat-angatan yu, dodoo duen polo sa etaw tumebow mekesambì kenak sa tigtu eglowon diyà kenak. Huenan di memala a amuk aken sa egsugùsuguen di egkedan talumpà di daa.’ ");
INSERT INTO mta_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“O medoo duma ku tugod i Ablaham owoy langun yu etaw beken Hudiyu egsimbà diyà si Nemula, igpetiig dé i Nemula diyà kenita sa Mepion Tegudon denu sa kealuk di kenita. ");
INSERT INTO mta_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Dodoo sa medoo etaw dutu Hélusalém dò owoy sa ulu-ulu da, endà kinilala da duu Hésus i sa tegealuk etaw. Apiya di pa egbasawen da sa kagi i Nemula igsulat sa medoo tegesugkow di egoh anay diyà sa simbaan da uman agdaw keetud da, endà doo netiigan da duu. Dodoo neketuu dé sa kagi sa tegesugkow i Nemula danà da migpeimatay si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Apiya di pa endà duen salà di sa pesuwan da mimatay kenagdi, egtemù da doo egpegeni diyà si Gubilenu Pilatu anì ipeimatay di. ");
INSERT INTO mta_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Huenan di, neketuu dé sa langun kagi i Nemula igpesulat egoh anay denu kenagdi. Agulé, kinuwa da sa lawa di diyà sa kayu igbugsud owoy iglebeng da diyà sa batu tinosongon etaw. ");
INSERT INTO mta_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Dodoo inenaw i Nemula doo sa egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nelugaylugay takà migpehaa diyà sa medoo etaw mig-unut kenagdi mig-angay Hélusalém dò kedu uwang Galiliya. Egtulonon da kita i tugod i Islaél sa hinaa da diyà kenagdi. ");
INSERT INTO mta_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Huenan di, mig-angay ké dini anì tulonen ké diyà keniyu sa Mepion Tegudon denu si Hésus. Apiya di pa igpasad i Nemula diyà sa tupù ta egoh anay, ");
INSERT INTO mta_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","neketuu doo ini egoh di diyà kenita i tugod da, enù ka inenaw i Nemula Hésus i sa egoh di nematay. Iya sa selepangan sa kagi i Nemula igpesulat diyà sa keduwa Isalem, guwaen di, ‘Kuna sa Anak ku, owoy ipetiig ku ini egoh di aken sa emà ko.’ ");
INSERT INTO mta_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Na, si Hésus sa inenaw i Nemula owoy endà dé mematay di uman, enù ka iya sa kagi i Nemula igpesulat, guwaen di, ‘Begayan ku kiyu sa tigtu mepion igpasad ku diyà si Dabid.’ ");
INSERT INTO mta_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Duen ma sa kagi i Nemula igsulat i Dabid egoh anay, guwaen di, ‘Endà mebaluy di diyà keniko amuk meledak sa lawa sa etaw hinemilì ko.’ ");
INSERT INTO mta_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Na, netiigan ta migpangunut Dabid i diyà sa langun igsugù i Nemula taman egoh di nematay, agulé iglebeng da kagdi lagà mendaa sa tupù ta owoy neledak ma sa lawa di diyà lebeng. ");
INSERT INTO mta_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Dodoo si Hésus, endà neledak sa hagdi lawa, enù ka inenaw i Nemula egoh di nematay. ");
INSERT INTO mta_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“O medoo duma ku tugod i Islaél, ungayà ké metiigan yu ini i. Danà i Hésus, egtulonen ké diyà keniyu sa tegudon denu sa kepeuloy i Nemula sa salà ta. ");
INSERT INTO mta_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ipetiig ké diyà keniyu endà mekedan sa salà yu danà yu egpangunut diyà sa uledin igsugkow i Mosis, dodoo mekedan polo sa salà ta danà ta egpigtuu diyà si Hésus. ");
INSERT INTO mta_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Huenan di, tulik yu anì endà mepigtamayan yu lagà sa medoo etaw tinulon sa tegesugkow i Nemula, guwaen di, ");
INSERT INTO mta_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Taa yu, hih, kiyu i tegesumbung sa kagi i Nemula. Megaip yu amuk pigtamayan ku kiyu, enù ka apiya di pa duen sa egbaelan ku diyà keniyu ini egoh di, endà doo migtuu yu, apiya ipetumàmà sa etaw diyà keniyu.’” ");
INSERT INTO mta_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na, egoh i Pabelo owoy si Bilnabi egpenaug diyà sa simbaan Hudiyu, igsasà da kagda anì pelikù da amuk meuma sa sebaen agdaw keetud anì muman da tumulù sa kagi i Nemula. ");
INSERT INTO mta_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Agulé egoh da neseselab, eg-unut sa medoo etaw kenagda, sa medoo Hudiyu owoy etaw beken Hudiyu eg-unut sa adat Hudiyu. Egpebagelen da i Pabelo sa kepigtuu sa medoo etaw anì tigtu da egpigtuu diyà si Nemula sa egtabang kenagda. ");
INSERT INTO mta_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na, egoh di neuma dema sa agdaw keetud, tigtu medoo temù sa etaw tegeAntiokiya egkesetipon anì dumineg da sa kagi i Nemula itulù i Pabelo. ");
INSERT INTO mta_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Dodoo tigtu egkesina sa medoo etaw Hudiyu endà egpigtuu egoh da mighaa sa medoo etaw nesetipon. Huenan di, egsigbolowen da sa itulù i Pabelo owoy egpeumàumaan da ma kagdi. ");
INSERT INTO mta_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Dodoo endà nelimedangan Pabelo i owoy si Bilnabi eg-ikagi, guwaen da, “Kiyu i etaw Hudiyu sa nekehuna migdineg sa kagi i Nemula. Dodoo eg-eked yu egpigtuu iya wé, enù ka eg-ekedan yu sa lalù endà meelut di ibegay i Nemula. Huenan di, salidan ké kiyu anì tumegudon ké polo diyà sa medoo etaw beken Hudiyu. ");
INSERT INTO mta_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iya sa baelan ké enù ka duen sa igsugù i Datù Nemula diyà kenami, guwaen di, ‘Hinemilì ku kuna anì lagà ka sa palitaan lumegdaw diyà sa etaw beken Hudiyu, anì mealukan sa langun etaw diyà siini sinukub langit.’ ” ");
INSERT INTO mta_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na, egoh sa etaw beken Hudiyu migdineg iya wé, neanggan da temù owoy eg-oloen da Nemula i danà sa inikagi i Pabelo. Agulé, egpigtuu dé sa medoo etaw hinemilì i Nemula anì melalù da taman melugay. ");
INSERT INTO mta_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Na, nekeseluh dé sa kagi i Datù diyà sa medoo menuwa medapag diyà Antiokiya. ");
INSERT INTO mta_vpl VALUE