﻿USE sofia;
DROP TABLE IF EXISTS sofia.msy_vpl;
CREATE TABLE msy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES msy_vpl WRITE;
INSERT INTO msy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kar Krais Iesusɨn inaziba ko ovavibar eghaghanim. Iesus a Devitɨn ovavim. Ezɨ Devit Abrahamɨn ovavim. ");
INSERT INTO msy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Aisakɨn afeziam. Ezɨ Aisak, Jekopɨn afeziam. Ezɨ Jekop Juda ko an aveghbuabar afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ezɨ Juda, Peres ko Seran afeziam. Aningɨn amebam Tamar. Ezɨ Peres Hesronɨn afeziam, Ezɨ Hezron, Ramɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ezɨ Ram Aminadapɨn afeziam, Ezɨ Aminadap Nasonɨn afeziam; Ezɨ Nason Salmonɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ezɨ Salmon Boasɨn afeziam. An amebam Rahap. Ezɨ Boas Obetɨn afeziam, an amebam Rut. Ezɨ Obet Jesin afeziam, Ezɨ Jesi Atrivim Devitɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ezɨ Devit Solomonɨn afeziam, an amebam Urian amuim. ");
INSERT INTO msy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ezɨ Solomon Rehoboamɨn afeziam. Ezɨ Rehoboam Abiyan afeziam, Ezɨ Abiya Asan afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ezɨ Asa Jehosafatɨn afeziam. Ezɨ Jehosafat Jehoramɨn afeziam. Ezɨ Jehoram Usian afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ezɨ Usia Jotamɨn afeziam. Ezɨ Jotam Ahasɨn afeziam. Ezɨ Ahas Hesekian afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezɨ Hesekia Manasen afeziam. Ezɨ Manase Emonɨn afeziam. Ezɨ Emon Josaian afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ezɨ Josaia Jehoiakin ko an aveghbuar mabar afeziam. Dughiar kamɨn Israelba ghua Babilonɨn kalabusɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ezɨ me Babilonɨn kalabusɨn ghuezɨ, gɨn Jehoiakin Sealtielɨn afeziam. Ezɨ Sealtiel Serubabelɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ezɨ Serubabel Abiutɨn afeziam. Ezɨ Abiut Eliakimɨn afeziam. Ezɨ Eliakim Asorɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ezɨ Asor Sadokɨn afeziam. Ezɨ Sadok Akimɨn afeziam. Ezɨ Akim Eliutɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ezɨ Eliut Eleasarɨn afeziam. Ezɨ Eleasar Matanɨn afeziam. Ezɨ Matan Jekopɨn afeziam. ");
INSERT INTO msy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ezɨ Jekop Josepɨn afeziam, a Marian pam. Ezɨ Maria Iesus bate, ezɨ me ziar kam Krais a gatɨ. A Gumazir God Uam E Iniasa Mɨsevezim. ");
INSERT INTO msy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kamaghɨn Abrahamɨn dughiamɨn ikegha ghua Atrivim Devitɨn dughiamɨn tu, 14 plan ovaviba otifi. Ezɨ Devitɨn dughiamɨn ikegha ghua dughiar Israelba Babilonɨn nguibamɨn Kalabusɨn ikezim, 14 plan ovaviba otifi. Ezɨ dughiar me kalabusɨn ikezimɨn ikegha ghua God Uam E Iniasa Mɨsevezir Gumazim, Kraisɨn dughiamɨn tuzim, uaghan 14 plan ovaviba otifi. ");
INSERT INTO msy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Krais Iesus otozir eghaghanimra kara, a God Uam e Iniasa Mɨsevezir Gumazim. An amebam Maria, me Josepɨn ikiasa a ginaba. Egha aning tɨghar uaning inigh ikiasava amima, Maria navim asangi. Godɨn Duamra borim a gatɨ. ");
INSERT INTO msy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ezɨma Josep Godɨn damazim derazir gumazim an averara Maria ataghraghasa nɨghnɨsi. An azenimɨn Maria aghumsɨzim a danɨngan aghua. ");
INSERT INTO msy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Egha a kamaghɨn nɨghnɨgha itima Ekiamɨn enselɨn mam irebamɨn kamaghɨn a mɨgei, “Josep, nɨ Devitɨn ovavim, nɨ atiatingan markɨ. Nɨ Maria inigh an ikɨ. A navim asangizir borim, a Godɨn Duam da ize. ");
INSERT INTO msy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","An otarim bateghtɨma, eghtɨ a uan gumazamizibar arazir kuraba gɨn amadagh men akurvagham. Kamaghɨn nɨ ziam Iesus a datɨgh.” ");
INSERT INTO msy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Arazir kabanagh kamaghɨn otiva, egha Godɨn akam inigha izir gumazir mamɨn mɨgɨrɨgɨamɨn mɨraram otifi. ");
INSERT INTO msy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A kamagh mɨkeme, “Amizir gumazitam ko akuizir puvatɨzim navim asegh, otaritam bategham. Eghtɨ me ziar kam Emanuel a darɨgham, ziar kamɨn mɨngarim kara, ‘God e ko iti.’” ");
INSERT INTO msy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ezɨ Josep daguraguimɨn dɨkavigha, Ekiamɨn ensel irebamɨn aven a mɨkemezɨ moghɨn, ghua Maria inigha an iti. ");
INSERT INTO msy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A poroghamiba uari isava akuir arazitam Maria gamizir puvatɨgha, ghua an otarim bate. Ezɨ a ziam Iesus a isa a gatɨ. ");
INSERT INTO msy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Distrigh Judian aven itir nguibam Betlehemɨn Iesus bate. Dughiar kamɨn Herot, Atrivimɨn iti. Amebam Iesus batezɨma fofozir gumazir maba aruem anadi naghɨn ikegha Jerusalemɨn ize. ");
INSERT INTO msy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Egha me kamaghɨn azai, “Borir Judabar Atrivimɨn ikiamim, amebam a batezɨ a managh iti? E an gun mɨgeir mɨkovezim aruem anadi naghɨn an ganigha an ziam fasa izi.” ");
INSERT INTO msy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ezɨ Herot akar kam baregha an dɨghorim a bɨra. Ezɨ Jerusalemɨn itir darazi uaghan kamaghɨn ami. ");
INSERT INTO msy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Egha Herot ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumazibar diagha me akuvagha kamaghɨn men azai, “God Uam E Iniasa Mɨsevezir Gumazim, an amebam managh a batam?” ");
INSERT INTO msy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ezɨ me ghaze, “Judian Distrighɨn aven itir nguibam Betlehemɨn, an amebam a batam. E bizir kam kamaghɨn a gɨfo, Godɨn akam inigha izir gumazimɨn osizirim kamaghɨn iti, ");
INSERT INTO msy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nɨ Betlehem, nɨ Judan nguazimɨn aven iti. Nɨ Judabar nguibar ekiabar tongɨn uaghan ziam iti, nɨn aven atrivir ekiatam azenim giram, egh a nan gumazamiziba Israelbagh ativagham.’ ” ");
INSERT INTO msy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ezɨ Herot averara aruem anadi naghɨn izezir gumazibar diagha mɨkovezim otozir dughiam bagha men azai. A me faraghavɨra mɨkovezimɨn apizir dughiam gɨfogha, ");
INSERT INTO msy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","egha me isa Betlehemɨn me amadagha kamaghɨn me mɨgei, “Ia mangɨ borim bativsɨ deraghvɨra rui. Ia a batoghɨva ua na bagh mɨgɨrɨgɨam amadagh. Eghtɨ kɨ uaghan mangɨ, an ziam fam.” ");
INSERT INTO msy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Me Herot baregha zuima mɨkovezir me faragha aruem anadi naghɨn ganizim, men faragha ghua borim itir danganim batogha a gisɨrara iti. ");
INSERT INTO msy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Me mɨkovezimɨn ganigha bar akonge. ");
INSERT INTO msy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Egha me dɨpenimɨn aven ghua borim bato, a uan amebam Maria ko. Me tevibar pɨrigha avigha ghuaghira borimɨn ziam fe. Egha me uan mɨtariba kuigha bizir aghuir a bagha inigha izezibar an ekarim gami. Me gol ko mughuriar aghuim itir borem ko avir mɨgharir muguriar aghuim gamim da isava a ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ezɨ God irebamɨn me batogha Herot bagh ua mangan me anogoroke. Ezɨ me tuavir igharazimɨn uamategha uan nguibamɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Fofozir gumaziba ghuezɨma Ekiamɨn enselɨn mam irebamɨn Josep batogha a mɨgɨa ghaze, “Nɨ dɨkavigh borim iniva an amebam sara inighɨva ia arɨ Isipɨn mangɨ. Herot borim bagh ruiva amɨsueghtɨ an aremeghasa. Kamaghɨn amizɨ ia mangɨ maghɨra ikɨ mangɨtɨ, dughiar kɨ ua nɨ mɨkɨmamim.” ");
INSERT INTO msy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ezɨma Josep dɨkavigha borim isa an amebam inigha me dɨmagarir kamra Isipɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egha Josep Isipɨn ikia ghua, dughiar Herot ovengezim. Arazir kabanagh otiva Ekiamɨn akam inigha izir gumazir mamɨn akatorimɨn mɨkemezir mɨgɨrɨgɨabar mɨn otifi. A kamaghɨn mɨkeme, “Nan Otarim Isipɨn itima kɨ an diazɨma a ize.” ");
INSERT INTO msy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ezɨ Herot garima, fofozir gumazir aruem anadi naghɨn izeziba a gifara. Ezɨ Herot bar puv atara uan mɨdorozir gumaziba amadagha, mɨgɨrɨgɨar gavgavim me ganɨga, me amadima me ghua, Betlehem koma an boroghɨn itir nguibaba bar dar ghua borir otarir azenir pumuning ko an apengan itiba, me mɨsozima me ariaghɨre. Kar ana aruem anadi naghɨn izezir fofozir gumazibar mɨgɨrɨgɨamɨn gɨn ghua kamaghɨn ami. ");
INSERT INTO msy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Arazir kabanagh otiva Godɨn akam inigha izir gumazim Jeremaia mɨkemezɨ moghɨn, otifi. A ghaze, ");
INSERT INTO msy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Me Raman nguibamɨn tiarir mam barasi, azir akam ko tuatem. Reselɨn boriba ua itir puvatɨ. Kamaghɨra a uan ovengezir boriba bagha azi. An navir amɨrizim inian aghua.” ");
INSERT INTO msy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herot ovengezɨma, Josep Isipɨn itima, Ekiamɨn ensel irebamɨn Josep bato. ");
INSERT INTO msy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Egha kamaghɨn a mɨgei, “Borim mɨsoghasa amir darazi me ovenge. Kamaghɨn amizɨ, nɨ dɨkavigh borim koma an amebam inigh ua Israelɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ezɨ a dɨkavigha borim isa an amebam inigha me ua Israelɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Egha an orazima, Arkelaus uan afeziam Herotɨn danganim inigha Judian Atrivimɨn iti. Ezɨ Josep Judian Distrighɨn mangan atiatingi. Egha God da irebamɨn mɨgɨrɨgɨam inigha egha Galilin Distrighɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A ghua Galilin Distrighɨn nguibar mam, Nasaretɨn apera. Bizir kaba otiva Godɨn akam inigha izir gumazim mɨkemezɨ moghɨn otifi, a ghaze, “Me Nasaretian gumazim, a darɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dughiar kamnaghɨn Gumaziba Ruer Gumazim Jon izava, Judian gumaziba itir puvatɨzir danganimɨn ikia akam akuri. ");
INSERT INTO msy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Egha ghaze, “God Bizibagh Ativamin Dughiam, a roghɨra ize. Kamaghɨn amizɨ, ia navibagh iragh.” ");
INSERT INTO msy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Godɨn akam inigha izir gumazim Aisaia fomɨra Jonɨn gun mɨgɨa ghaze, “Gumazir tiarir mam gumaziba puvatɨzir danganimɨn dia ghaze, ‘Ia Ekiam baghɨva tuaviba azenɨva, dar kɨr.’” ");
INSERT INTO msy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon kemelɨn arɨziba ingarizir korotiaba aghuigha asɨzir inim uan ivariam ike. An odeziba ko ruarimɨn haniba api. ");
INSERT INTO msy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ezɨ gumazamiziba, me Jerusalemɨn nguibar ekiam ko Judian Distrigh ko Jordanɨn danganimɨn ikegha, bar a bagha zui. ");
INSERT INTO msy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Me iza uan arazir kurabar gun mɨgeima, Jon Jordan dɨpamɨn me rue. ");
INSERT INTO msy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Egha a gari, Farisiba ko Sadyusibar men avɨrim a gumaziba ruer danganimɨn izi. Ezɨ a kamaghɨn me mɨgei, “Ia kuruzir divir anababa, tina ia mɨkemezɨ, ia Godɨn anɨngagharir gɨn izamimɨn arɨ mangasa? ");
INSERT INTO msy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ia navim gɨrazir arazibar amu. ");
INSERT INTO msy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Egh ia pura uarigh nɨghnɨgh suam ‘E Abrahamɨn ovaviba.’ Kɨ ia mɨgei, God dagɨar kabara amightɨ da Abrahamɨn ovavibar mɨn otivighamin gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sobiam datɨrɨghɨn temer povibar iti, eghtɨ temer dagher ovɨzir aghuiba itir puvatɨziba, God bar da okeghɨva da isɨva avim mɨkɨnam. ");
INSERT INTO msy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ezɨ kɨ ia navibagh irazir arazim akakaghasa kɨ dɨpamɨn ia rue. Ezɨ nan gɨn izir gumazim, an gavgavim nan gavgavim gafira. Ezɨ kɨ an dagarir asuabar ateramin gavgaviba puvatɨ. Gumazir kam Godɨn Duam ko avimɨn ia ruam. ");
INSERT INTO msy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A witba mɨsevir savol an agharimɨn iti, eghtɨ a uan witba mɨsɨva dar daghebar arɨghɨva, witba mɨsevir dɨpenimɨn witɨn mɨseviba aviva, egh dar mɨseviba avir munger puvatɨzimɨn da akuntɨma, da isiam.” ");
INSERT INTO msy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ezɨ dughiar kam Iesus Galilin Distrigh ategha Jon a ruasa, Jordanɨn dɨpamɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ezɨ Jon an anogorogha ghaze, “Nɨ manmagh sua, uabɨ ruasa na bagha izi? Nɨ na rutɨ, kamaghɨn deragham!” ");
INSERT INTO msy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ezɨ Iesus an mɨgɨrɨgɨam ikaragha a mɨgɨa ghaze, “Markɨ. Nɨ datɨrɨghɨn kɨ nɨ mɨgei moghɨn nɨ damu. Ga arazir kamɨn, God ifongezir araziba dar gɨn tɨghtɨ, da otɨvam.” Ezɨ Jon an mɨgɨrɨgɨamɨn mɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ezɨ Iesus ruegha gɨvagha zuamɨra dɨpam ategha azenimɨn ize. Ezɨ overiam kuiaghrɨzɨ a garima, Godɨn Duam bunbamɨn mɨn mɨghegha izaghira a gisɨn apera. ");
INSERT INTO msy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ezɨ tiarir mam Godɨn Nguibamɨn ikia dɨa ghaze, “Kar nan Otarim, kɨ bar a gifonge. Kɨ a bagha bar akonge.” ");
INSERT INTO msy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dughiar kamɨn Godɨn Duam Iesus inigha ghua Satan a gifarasa danganir gumaziba itir puvatɨzimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ezɨ Iesus 40 plan arueba ko dɨmagaribar daghetam inizir puvatɨ. Ezɨ mɨtiriam an azi. ");
INSERT INTO msy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ezɨ gumazir ifavaribagh amim Satan iza a batogha kamaghɨn a mɨgei, “Nɨ guizbangɨra Godɨn Otarim, nɨ dagɨar kaba akar gavgavim dav kemeghtɨ da bretɨn rubuzibar mɨn otogh.” ");
INSERT INTO msy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ezɨ Iesus Satan ikaragha ghaze, “Godɨn Akɨnafarim kamaghɨn mɨgei, ‘Gumazamiziba daghebara damɨva dar gavgavimɨn ikian kogham. Puvatɨ. Me God mɨgeir mɨgɨrɨgɨaba bar dar gɨn mangɨva me ikɨrɨmɨrir aghuim iniam.’” ");
INSERT INTO msy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ezɨ Satan Iesus inigha Jerusalemɨn ghua a isa Godɨn Dɨpenimɨn pɨn mar anefa. ");
INSERT INTO msy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Egha Satan a mɨgei, “Nɨ oragh, Godɨn Akɨnafarim kamagh mɨgei, ‘A nɨ bagh uan enselba akar gavgavim me mɨkɨmtɨma me deraghvɨra nɨn ganam. Egh me uan dafaribar nɨ fueghtɨ, nɨ uan dagarim dagɨatamɨn aneseghan kogham.’ Kamaghɨn nɨ guizbangɨra Godɨn Otarim, nɨ kagh uabɨ ekunigh.” ");
INSERT INTO msy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ezɨ Iesus an akam ikaragha ghaze, “Godɨn Akɨnafarim ua kamaghɨn mɨgɨa ghaze, ‘Nɨ uan Ekiam God a gifarɨva, a gakaghontɨ, a nɨn nɨghnɨzimɨn gɨn mangan markɨ.’” ");
INSERT INTO msy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ezɨ Satan ua Iesus inigha ghua mɨghsɨar bar pɨn itir mamɨn ghua nguazir kamɨn kantriba bar, ko dar bizir aghuiba an akakagha ghaze, ");
INSERT INTO msy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Nɨ tevemning apɨrigh nan ziam feghtɨma, bizir kaba kɨ bar da nɨ danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ezɨ Iesus a mɨgɨa ghaze, “Satan nɨ na gitagh! Godɨn Akɨnafarim kamagh mɨgei, ‘Nɨ uan Ekiam God, nɨ an apengara ikɨ an ziamra fam.’” ");
INSERT INTO msy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ezɨ Satan Iesus ataghizɨ enselba iza an akura. ");
INSERT INTO msy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ezɨ Iesus orazi, me Jon Gumaziba Ruer Gumazim a isa kalabus gatɨ, ezɨ a uamategha Galilin Distrighɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Egha a Nasaretɨn nguibam ategha ghua Kaperneamɨn nguibamɨn iti. Nguibar kam dɨpar ekiam Galilin dadarimɨn Sebulun ko Naptalin nguazir asɨzimɨn iti. ");
INSERT INTO msy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Arazir kabanagh otiva fomɨra Godɨn akam inigha izir gumazim Aisaia mɨkemezɨ moghɨn otifi. A ghaze, ");
INSERT INTO msy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ia gumazamizir Sebulunɨn nguazim ko Naptalin nguazimɨn itiba, nguazir kam a tuavir ongarimɨn zuim boroghɨra itir danganim ko Jordanɨn dɨpar dadarir vongɨn itir danganim, a Galilin Distrighɨn nguazim. Danganir kam Kantrin Igharazibar Gumazir avɨriba uaghan an aven iti. ");
INSERT INTO msy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kar, gumazamizir arazir kurabar mɨtatemɨn aven itiba, me angazangarir ekiamɨn gani. Egha gumazamizir ovengamin mɨtatemɨn aven ikeziba, angazangarim me gisira.” ");
INSERT INTO msy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dughiar kamɨn Iesus ingarim foregha akam akura gumaziba me mɨgɨa ghaze, “God Bizibagh Ativamin Dughiam a roghɨra ize. Kamaghɨn amizɨ, ia navibagh iragh!” ");
INSERT INTO msy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ezɨ Iesus Galilin dɨpar dadarimɨn ghua gari aveghbuar mamning iti. Saimon, me “Pita” a garɨsi. A uan dozim Endru ko, aning iver ekiaba dɨpamɨn da kuri. Aning osiriba isa da amadir gumazimning. ");
INSERT INTO msy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ezɨ Iesus aning mɨgɨa ghaze, “Gua nan gɨn izɨtɨma kɨ guan akakaghtɨma, gua osiriba isi moghɨn gumaziba iniam.” ");
INSERT INTO msy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ezɨ aning an akam baraghavɨra, uan iveba ategha an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ezɨ Iesus mong sɨvagha ghua aveghbuar mamningɨn api. Jems, a Sebedin otarim, a uan dozim Jon ko iti. Aning uan afeziam Sebedi ko me botɨn mamɨn iti. Men iveba dɨghoraghrezɨ, me dar toribar kɨri. Ezɨma Iesus aning diazɨma, ");
INSERT INTO msy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","aning maghɨra uan afeziam ko bot ategha Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ezɨ Iesus Galilin Distrigh bar a garua me God ko mɨgeir dɨpenibar aven men sure gami. Egha a God Bizibagh Ativamin Dughiamɨn akar aghuim akura, men arɨmariaba akɨrava men mɨkarzibar itir bizir osɨmtɨziba a uaghan da gefi. ");
INSERT INTO msy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ezɨ an biarim Sirian Provins bar an ghu. Ezɨma gumazamizir arɨmariaba itiba, me bar me isa a bagha izi. Gumazir aria mɨzazir kuraba baraziba, ko duar kuraba apazaziba, ko gumazir arɨmariar inɨrɨzibagh amiba, ko gumazir agharapaniba ariaghreziba, me bar me inigha a bagha izi. Ezɨ Iesus men arɨmariaba bar da gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ezɨ gumazamizir bɨzir dafam, me a koma arui. Galilin itir darasi ko Distrigh Dekapolisɨn itir darazi ko Jerusalem ko Judian Distrigh, ko Jordanɨn vongɨn itir danganimɨn itiba me an gɨn arui. ");
INSERT INTO msy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesus gari avɨrir ekiam an gɨn izima a mɨghsɨar mamɨn anabogha, egha apera. Ezɨ an suren gumaziba a bagha izi. ");
INSERT INTO msy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ezɨ Iesus kamaghɨn uan suren gumazibar sure gamua ghaze, ");
INSERT INTO msy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ia Godɨn damazimɨn ia fo ia an bizibagh asa, ia God Bizibagh Ativamin Dughiamɨn aven mangam. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ia datɨrɨghɨn azia itir gumaziba, ia bar akuegham. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ia gumazir uan gavgaviba ko ziaba fer puvatɨziba, God nguazim bar ia danɨngam. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ia gumazir arazir aghuiba baghavɨra ikia egha mati gumazim mɨtiriam an azi, egha mati gumazim kuarim an pɨri, God ian mɨtiriam a gɨvagham. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ia gumazir apangkuvim igharazibar itiba, God ian apangkuvam. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ia gumazamizir navir averiar zueziba, ia Godɨn ganam. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ia gumazamizir adariba ko mɨdoroziba ageviba, me ‘Godɨn Boriba’ ia darɨgham. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ia gumazamizir arazir aghuibagh amiba, ezɨ me arazir kam bagha osɨmtɨziba ko mɨzaziba ia ganɨdi, God Bizibagh Ativamin Dughiam, a iananam. Kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Me ian gari ia na ko iti, ezɨ bizir kam bangɨn me paza arazir osɨmtɨziba ko mɨzaziba ia ganɨdi, egha mɨgɨrɨgɨar ifavarir avɨriba ia gasi, kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ivezir bar ekiam ia mɨzua Godɨn Nguibamɨn iti. Godɨn akam inigha izir gumazir ian faragha ghueziba, me uaghan kamaghɨra osɨmtɨziba ko mɨzaziba me ganɨngi. Kamaghɨn ia naviba deragh bar akongegh.” ");
INSERT INTO msy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ezɨ Iesus ua me mɨgɨa ghaze, “Ia gumazamiziba bar me bagha, amangsɨzimɨn mɨn iti. Ia uan isɨngtɨzim ateghtɨma e manmaghɨn a damutɨ a ua sɨngigham? Amangsɨzir kamaghɨn otiviba ingangariba puvatɨ. Me a isɨ nguazimɨn anekunigh a dɨkabɨnam. ");
INSERT INTO msy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ia mati nguazir kamɨn angazangarim. Ia kamagh nɨghnɨgh! Nguibar ekiar mam mɨghsɨamɨn ikɨ modoghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Egha gumazitam lam tam a gaborogha a isa mɨnetamɨn aven anetɨzir puvatɨ. An a isɨ dakozim dafaghtɨma, an angazangarim gumazir dɨpenimɨn itiba bar me gisiragham. ");
INSERT INTO msy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nɨn angazangarim kamaghɨra isɨghtɨma, gumaziba bar an ganam. Egh me ian arazir aghuir kabar ganɨva ian Afeziar uan Nguibamɨn itim, me an ziam fam.” ");
INSERT INTO msy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Egha Iesus ua mɨgɨa ghaze, “Ia kamaghɨn nɨghnɨghan markɨ, egh suam, kɨ Moses Osirizir Araziba ko Godɨn akam inigha izir gumazibar akaba batoghasa ize. Puvatɨ. Kɨ izɨ dar amutɨ dar dagheba guizɨn otivam. ");
INSERT INTO msy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kɨ bar guizbangɨra ia mɨgei, Moses Osirizir Arazibar akar muziaritam gɨvaghan kogham, mangɨ nguazim ko overiam gɨvaghamin dughiam otogham. Dar osizirir otevir muziariba ko ababanir me osiriziba, da kamaghɨra ikɨ mangɨ bizir otivamiba bar otivigham. ");
INSERT INTO msy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kamaghɨn amizɨ, gumazir manam Moses Osirizir Arazitamɨn kuragh egh suam, a pura bizim, egh kamaghɨra igharaz darazi men sure damuva, gumazir kamaghɨn amim, God Bizibagh Ativamin Dughiamɨn an ziam bar gɨn ikiam. Eghtɨma gumazir manam Moses Osirizir Arazibar gɨn mangɨva egh kamaghɨra ua igharaz darazir men sure damutɨ me an mɨn arazir kabar gɨn mangɨtɨ, gumazir kamaghɨn amizim, God Bizibagh Ativamin Dughiam, a ziar bar ekiam iniam. ");
INSERT INTO msy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kamaghɨn kɨ ia mɨgei, ia Godɨn ifongiamɨn gɨn tɨghan koghɨva ian arazir aghuiba Judan arazibagh fozir gumaziba ko Farisibar arazir aghuiba dagh afiraghan kogham, eghtɨ ia God Bizibagh Ativamin Dughiamɨn aven mangan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Egha Iesus ua kamaghɨn mɨgei, “Ia mɨgɨrɨgɨar ian ovaviba iniziba, ia da baregha gɨfa egha dagh fo, ia tav mɨsueghtɨma an aremeghan markɨ. Ian tav gumazitam mɨsueghtɨma an aremegham, a kotiamɨn otivam. ");
INSERT INTO msy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ezɨ kɨ kamaghɨn ia mɨgei, gumazir manam uan aveghbuamɨn atari, a kotiamɨn mangam. Egh gumazitam mɨgɨrɨgɨar kurabar uan aveghbuam mɨkɨm suam, a Kotiar Ekiamɨn otivam. Egh gumazitam gumazir mamɨn atar suam, a gumazir onganim, a helɨn avir ekiamɨn mangam. ");
INSERT INTO msy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Egh nɨ ofa damusɨ ofa gamir danganimɨn mangɨ, egh nɨ nɨghnɨgham, nɨ uan aveghbuam ko mɨgɨrɨgɨar osɨmtɨzim iti, ");
INSERT INTO msy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","egh nɨ uan ofaba ofa gamir danganimɨn dar atɨgh. Eghɨva uamategh mangɨ aveghbuam ko mɨgɨrɨgɨabar kɨrigh. Gua dar kɨrigh, egh nɨ datɨrɨghɨn mangɨ uan ofa isɨ God danɨng. ");
INSERT INTO msy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Egh nɨn apanim nɨ inigh kotiamɨn mangɨtɨ, nɨ a ko osɨmtɨzir kam akɨrsɨ tuavimɨn a mɨkɨm mangɨ. Puvatɨghtɨma, a nɨ inigh jasɨn damazimɨn mangam. Eghtɨ jas nɨ inigh polisɨn agharim datɨghtɨma, polis nɨ inigh kalabuziam datɨgham. ");
INSERT INTO msy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ezɨ kɨ guizbangɨra nɨ mɨgei, nɨ azenim giran kogham, ikɨ mangɨ nɨ ivezim bar anekɨrighamin dughiamɨn gɨn, azenim giram.” ");
INSERT INTO msy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Egha Iesus ua kamaghɨn mɨgei, “Ia oraki, me fomɨra ghaze, ia poroghamiba uari bakeir arazim, damuan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ezɨ kɨ kamaghɨn ia mɨgei, nɨ gumazitam nɨ amizir mamɨn gara paza a gɨnɨghnɨsi, nɨ poroghamiba uari bakeir arazim uan navir averiamɨn aven, a ko a gamigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Eghtɨ nɨn damazir guvimɨn itim nɨ gami, nɨ arazir kuram damightɨ, anesigh a makunigh. Kamaghɨn dera, nɨn mɨkarzitam dutughtɨ, nɨ arazir kuratam damighan kogham. Puvatɨghtɨma, me nɨn mɨkarzim bar a isɨva helɨn anekunigham. ");
INSERT INTO msy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eghtɨ nɨn dafarir guvim nɨ damutɨ nɨ arazir kuratam damightɨ, nɨ anetugh a makunigh. Kamaghɨn dera, nɨn mɨkarzitam dutugh deragham, egh nɨ arazir kuratam damuan kogham. Puvatɨghtɨma, me nɨn mɨkarzim bar a isɨ helɨn anekunigham.” ");
INSERT INTO msy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Egha Iesus ua mɨgɨa ghaze, “Me fomɨra kamaghɨn mɨgei, ‘Gumazir manam uan amuim ataghraghsɨ, an a bagh akɨnafarim osirigh egh anetegham.’ ");
INSERT INTO msy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ezɨ kɨ kamaghɨn ia mɨgei, Gumazir manam uan amuimɨn garima, a gumazir igharazitam ko akuiz puvatɨzɨ a pura anetaki, gumazir kam uan amuim gamima a poroghamiba uari bakeir arazim gami. Eghtɨ amizir kam gumazir igharazitamɨn ikiam, a poroghamiba uari bakeir arazim gami. Eghtɨ gumazitam amizir pam ataghizimɨn ikɨva, egh gumazir kam uaghan poroghamiba uari bakeir arazim gami.” ");
INSERT INTO msy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Egha Iesus ua kamaghɨn mɨgei, “Mɨgɨrɨgɨar mam ian ovaviba a inizɨ ia a baraki, a kara. ‘Ia ifarɨva Godɨn Nguibamɨn akakagh mɨkɨman markɨ. Egh ia Ekiamɨn damazimɨn mɨgeir akamɨn mɨrara mangɨ, arazir kam deragh a damu.’ ");
INSERT INTO msy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ezɨ kɨ ia mɨgei, uan mɨgɨrɨgɨaba gavgavim dar anɨngsɨ, bizir katamɨn akakagh mɨkɨman markɨ. Bar markiam. Ia Godɨn Nguibam akakagh egh mɨkɨm suam, ‘Bar guizbangɨra,’ ia kamaghɨn damuan markɨ. Bar markiam. Kar Godɨn Atrivir Dabirabim. ");
INSERT INTO msy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ia uan mɨgɨrɨgɨaba gavgavim dar anɨngsɨ, nguazir kam dɨponan markɨ. God nguazimɨn uan suemning arɨsi. Egh ia uan mɨgɨrɨgɨaba gavgavim dar anɨngsɨ, Jerusalem dɨponan markɨ. Jerusalem Atrivir Ekiamɨn nguibar ekiam. ");
INSERT INTO msy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Egh ia uan mɨgɨrɨgɨaba gavgavim dar anɨngsɨ uan dapanibar akakaghan markɨ. Ia fo, ian tav uan dapanir arɨzitam damutɨ a pigham, o ghurghurighan kogham. ");
INSERT INTO msy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ia pura kamaghɨn mɨkɨm, ‘Guizbangɨra’ o ‘Puvatɨ.’ A kamaghɨn dera. Ezɨ mɨgɨrɨgɨar igharazir isafuraziba, da Satanɨn otivaghirir mɨgɨrɨgɨaba.” ");
INSERT INTO msy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Egha Iesus ua kamaghɨn mɨgei, “Ia oraki, me fomɨra ghaze, ‘Tav igharaz tavɨn damazim a gasɨghasightɨ, eghtɨ me uaghan an damazim gasɨghasigham. Eghtɨ tav tavɨn ataritam asightɨ, me uaghan an ataritam asigham.’ ");
INSERT INTO msy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ezɨ kɨ kamaghɨn ia mɨgei, gumazim arazir kuratam ia damightɨma, ia a ikarvaghan markɨ. Egh gumazitam ian koviatam apezeghtɨ, ia koviar vuem sara a danɨngigh. ");
INSERT INTO msy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eghtɨ tav ian korotiar azenan azuim bagh ia isɨ kotiam datɨghtɨ, ia uaghan uan aven azuir korotiam sara a danɨngigh. ");
INSERT INTO msy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Eghtɨ tav uan biziba iniasa nɨ bagha gavgava ghaze, nɨ an biziba atera an aku tuavir asɨzitamɨn mangam, eghtɨ nɨ an aku tuavir asɨzir ruarir pumuningɨn angɨ. ");
INSERT INTO msy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Eghtɨ tav biziba bagh ian azangsɨghtɨ, ia a danɨngi. Eghtɨ gumazitam pura ia da biziba iniasa ian azai, ia akɨrim ragh a gasan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Egha Iesus mɨgɨa ghua ghaze, “Ia oraki, me fomɨra kamaghɨn mɨgei, ‘Ia uan namakabagh ifongegh, egh pazɨ uan apanibar amu.’ ");
INSERT INTO msy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ezɨ kɨ kamagh ia mɨgei, ia uan apanibagh ifongegh, egh me bagh Godɨn azang, eghtɨ God gumazir osɨmtɨziba ko mɨzaziba ia ganɨdibar, men apangkuvigham. ");
INSERT INTO msy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Arazir kam kamaghɨn ian akagham, ia guizbangɨra uan Afeziar uan Nguibamɨn itim, ia an boribara. Guizbangɨra, an aruem gamima, a gumazir kuraba ko aghuiba bar me gisɨsi. Egha an amozim gamima, a gumazir aghuiba ko gumazir arazir kurabagh amiba sara me gizi. ");
INSERT INTO msy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eghtɨ ia gumazir ia ifongezibagh ifueghɨva ia ivezir manatam iniam? Puvatɨ. Gumazir dagɨaba isiba uaghan arazir kabagh ami. ");
INSERT INTO msy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Egh ia dughiam isɨ uan adarazira anɨng, egh ian arazir manam igharaz darazir arazim gafiragham? Gumazir God gɨfozir puvatɨziba ti uaghan ia amir arazibagh ami! ");
INSERT INTO msy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kamaghɨn amizɨ, ia uan Afeziar uan Nguibamɨn itim, an arazir aghuibara dagh ami moghɨn, ia uaghan arazir aghuibar amu.” ");
INSERT INTO msy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Egha Iesus ua kamaghɨn mɨgei, “Ia deraghvɨra gan. Ia gumazamiziba gansɨ osamɨva, arazir aghuibar amuan markɨ. Ia kamagh damu, uan Afeziar uan Nguibamɨn itim da ivezitam inighan kogham. ");
INSERT INTO msy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Egh ia bizitam isɨ gumazir asaghasazitam danɨngsɨva, tav amadaghtɨma a mangɨ ian arazir aghuir kam an gun mɨkɨman markɨ, egh mati gumazir maba me God ko mɨgeir dɨpeniba ko tuavibar tuiva odava ami moghɨn. Ia men mɨn damuan markɨ. Kamagh amir darazi, me gumazamizibar damazibar uan araziba akakaghtɨma, me men ziaba fasa. Kɨ guizbangɨra ia mɨgei, me uan ivezim inigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ia asaghasazitamɨn akurvaghsɨ, ian agharir guvim arazir kam damutɨ, agharir ikɨriam arazir kam gɨfoghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eghtɨ ian akurvazir arazir kam averara ikɨtɨ, ian Afeziar bizir mogomebar garim, ian arazir aghuim ikaragham.” ");
INSERT INTO msy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Egha Iesus ua kamaghɨn mɨgei, “Ia God ko mɨkɨmsɨ, gumazir ifavariba ami moghɨn damuan markɨ. Me God ko mɨgeir dɨpeniba ko tuavir ekiabar akabar tuiva, God ko mɨkɨmasa bar akonge. Me odava, egha ghaze, gumazamizir avɨriba nan ganigh nan ziam fam. Kɨ guizbangɨra ia mɨgei, me uan ivezim inigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Egh ia God ko mɨkɨmsɨ, uan dɨpenir averiamɨn mangɨ tiam asaragh, egh modogh ia uan Afeziam ko mɨkɨm. Kamaghɨn, ian Afeziar bizir mogomebar garim, a ian ivezim ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ia God ko mɨkɨmsɨva mɨgɨrɨgɨar kɨnir avɨribar amuva, God gɨfozir puvatɨzir darazi ami moghɨn damuan markɨ. Me ghaze, me mɨgɨrɨgɨar avɨribar amuam, eghtɨ kamaghɨn God me baragham. ");
INSERT INTO msy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ia me ami moghɨn damuan markɨ. Guizbangɨra, bizir ia puvatɨziba, dughiar ia tɨghar uan Afeziam da bagh an azangsɨghamim, ana dagh fogha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Kamaghɨn amizɨ, ia kamaghɨn God ko mɨkɨm: ‘En Afeziar uan Nguibamɨn itim, nɨn ziam bar zue, ezɨ arazir kuraba an saghon iti. ");
INSERT INTO msy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Eghtɨ Dughiar Nɨ Bizibagh Ativamim, a izɨ. Eghtɨ nɨn Nguibamɨn itir darasi nɨn ifongiamɨn gɨn zui moghɨn, e uaghan nguazir kamɨn nɨn ifongiamɨn gɨn mangam. ");
INSERT INTO msy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Eghtɨ nɨ e datɨrɨghɨn damamin dagheba da isɨ e danɨng. ");
INSERT INTO msy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Eghtɨ me e gamir arazir kuraba e da gɨn amadi moghɨn, nɨ en arazir kuraba gɨn amang. ");
INSERT INTO msy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Egh e ateghtɨ, e osɨmtɨzibar aven ikɨtɨ bizitam en navim bɨraghtɨma, e arazir kuratam damuan kogham. Nɨ arazir kurabar gavgavim da e inigh.’ ");
INSERT INTO msy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Guizbangɨra, ia gumazamiziba ia gamir arazir kuraba gɨn amangtɨ, ian Afeziar uan Nguibamɨn itim, ian arazir kuraba gɨn amangam. ");
INSERT INTO msy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ia men arazir kuraba gɨn amangan koghtɨma, ian Afeziam uaghan ian arazir kuraba gɨn amangan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Egha Iesus ua mɨgɨa ghua ghaze, “Ia dagheba ataghrazir dughiamɨn ia gumazir ifavaribar mɨn uan guabagh ekuan markɨ. Gumazir ifavariba dagheba ataghrazir dughiamɨn, gumaziba men ganasa, me uan guaba ruer puvatɨgha pughpurighav arui. Me odava arazir kabagh ami. Kɨ guizbangɨra ia mɨgei, me uan ivezim inigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eghtɨ ia dagheba ataghrazir dughiamɨn, ia borem uari aghɨva uan guaba ru, ");
INSERT INTO msy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eghtɨ gumaziba ia dagheba ataghrazir arazir kam gɨfoghan kogham. Eghtɨ ian Afeziar danganir mogomemɨn itim, anarɨra ian ganigh fogham. Egh gɨn ian Afeziar bizir mogomebar garim, a ian ivezim ia danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Egha Iesus mɨgɨa ghua ghaze, “Ia nguazimɨn ikia uari bagh bizir aghuiba akumakum dar pozibav kɨnam markɨ. Nguazir kamɨn, barereba ko omebaba dar amɨtɨ, da mazɨva akughregham. Eghtɨ okɨmakɨar gumaziba bɨriba akar da okɨmam. ");
INSERT INTO msy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ia Godɨn Nguibamɨn uari bagh bizir aghuiba pozibav kɨn. Godɨn Nguibamɨn barereba ko omebaba bizibar aman koghtɨma, da mazigh, akughran kogham. Eghtɨ okɨmakɨar gumazitam bɨritam akarighɨva da okemeghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Danganir manam nɨn bizir aghuiba iti, danganir kam nɨn navir averiamɨn aven itir ifongiam, a uaghan ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Egha Iesus mɨgɨa ghua ghaze, “Damaziba, da lamɨn mɨn namnamɨn angazangarimɨn mɨn iti. Damazim deragham, angazangarim bar nɨn namnam gizɨvaghtɨ, nɨ arazir aghuibar amuam. ");
INSERT INTO msy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Eghtɨ nɨn damaziba ikuvigham, nɨn namnam bar mɨtarmeghtɨma, nɨ arazir kurabar amuam. Eghtɨ nɨn angazangarim mɨtarmegham, mɨtarmer kam bar pɨrigham.” ");
INSERT INTO msy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Egha Iesus mɨgɨa ghua ghaze, “Ingangarir gumazitam, ingangarir gumazir ekiar pumuning bagh ingaran kogham. A tavɨn aghuagh, tav gifuegham. O, a tav baghɨvɨra ikɨ, tav akɨrim a gasaragham. Ia God ko dagɨaba bagh uaghara ingaran kogham.” ");
INSERT INTO msy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Egha Iesus mɨgɨa ghua ghaze, “Kamaghɨn amizɨ, kɨ ia mɨgei, ia pamten uan ikɨrɨmɨrim gɨnɨghnɨghɨva, kamaghɨn azangan markɨ, e dagher manatamra damam, o e dɨpar manatamra damam? Egh ia pamten uan nivafɨzibagh nɨghnɨgh mɨkɨman markɨ, inir manatam uan nivafɨzim avam? Gumazimɨn ikɨrɨmɨrim ti daghebagh afira, ezɨ gumazimɨn namnam ti inibagh afira. ");
INSERT INTO msy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ia kuarazibar gari, da dagheba oparir puvatɨ, egha da dar pozibagh aghua da isa dagher dɨpenibar amadir puvatɨ. Ian Afeziar uan Nguibamɨn itim, dagheba me ganɨdi. Ezɨ ian dabirabim ti kuarazibar dabirabim gafirazir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Egh ian tav deraghvɨra ikɨsɨ nɨghnɨgh kamaghɨn a ti uan ikɨrɨmɨrim damutɨ a tong ruaragham? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ia tizim sua, pamten korotiabagh nɨghnɨsi? Ia akɨmarir aghuaribagh nɨghnɨgh. Da manmaghɨn otifi? Me ingangarir ekiatam gamir puvatɨ. Egha me korotiatam isamizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ezɨ kɨ ia mɨgei, fomɨra Atrivim Solomon bizir bar avɨriba ikiava an azuir adiariba bar dera, egha an korotiatam akɨmarir kabar mɨn otozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E fo, graziba pura biziba, da iti, gurumɨn gumazitam dar akoreghɨva da isɨva avitam mɨkɨnigham. Grazir kɨnir kabanagh God adiariba me gazui. Ia bizir kam gɨfogh, God uaghan adiariba ia danɨngam. Ia gumazamizir nɨghnɨzir gavgavir muziarim itiba! ");
INSERT INTO msy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kamaghɨn, ia pamten nɨghnɨgh mɨkɨman markɨ, ‘E dagher manatam ramegham? O, dɨpar manatam ramam? O, e inir manatam ikegham?’ ");
INSERT INTO msy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gumazir God gɨfozir puvatɨziba pamten bizir kabagh nɨghnɨsi. Ezɨ ian Afeziar uan Nguibamɨn itim fo, ia bizir puvatɨzir kaba, ia da iniam. ");
INSERT INTO msy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ezɨ bizir ia bar faragh damuamimra kara: Ia God Bizibagh Ativamin Dughiam baghɨvɨra nɨghnɨgh, egh God ifongezir arazir aghuibar amutɨ, a bizir kaba ko maba sara bar ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kamaghɨn amizɨ, ia pamten gurumɨzaraghan bagh dɨghorim isiva nɨghnɨghan markɨ. Gurum izamin dughiam, a mar uan bizibara nɨghnɨgh. Dughiar manamɨn otivir osɨmtɨziba, da anarɨra ikɨ. Aruer manamɨn otivamin biziba, mar an biziba.” ");
INSERT INTO msy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Egha Iesus ua kamaghɨn mɨgei, “God ia tuisɨgh ian kuraghan koghsɨ, kamaghɨn ia munen araziba tuisɨghan markɨ suam, men araziba ikufi. ");
INSERT INTO msy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ia me tuisɨgha men ikurvagha ami moghɨra, God kamaghɨra ia tuisɨgham. Egh ia men gara me gɨnɨghnɨzi moghɨra, God ia gɨnɨghnɨgham. ");
INSERT INTO msy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tizim bagha, mɨnezir bar muziarim nɨn aveghbuamɨn damazimɨn itima, nɨ ti an gara egha temer ararir ekiar nɨn damazimɨn itimɨn garir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ter ararir ekiam nɨn damazimɨn ikɨtɨ, nɨ manmaghɨn uan aveghbuam mɨkɨm suam, ‘Aveghbuam, kɨ nɨn damazimɨn itir mɨnezim asigham?’ ");
INSERT INTO msy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nɨ bar ifari! Nɨ faraghvɨra ter ararir nɨn damazimɨn itim asigh, egh deragh ganɨva mɨnezir nɨn aveghbuamɨn damazimɨn itim asigh. ");
INSERT INTO msy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ia God baghavɨra itir biziba inigh, afiabar anɨngan markɨ. Guizbangɨra, da ua raghrɨgh ia givigham. Egh ia uan manmaniar ikarɨzir aghuiba isɨ dabav kɨnan markɨ. Da pura da dɨkabɨnigham.” ");
INSERT INTO msy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ia God ko mɨkɨm, egh biziba bagh an azang, eghtɨ a da isɨ ia danɨngam. Egh ia biziba bagh ruiva, ia da bativam. Egh ia tiam gafughafughtɨ, God ia bagh tiam kuigham. ");
INSERT INTO msy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gumazir Godɨn azaiba, me biziba isi. Ezɨ gumazir biziba bagha ruim, a biziba batifi. Ezɨ gumazir itiam gafughafuzim, God a bagh akuigham. ");
INSERT INTO msy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Eghtɨ ia afeziaba, ian boritam bretba bagh ian azangtɨma, ia ti dagɨatam a danɨngam? Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Eghtɨ boritam osiriba bagh uan afeziamɨn azangtɨ, a ti kuruzitam a danɨngam? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","“Ia afeziar arazir kurabagh amiba, ia zurara bizir bar aghuiba uan boribagh anɨdi. Egh ia kamagh deraghvɨra fogh, guizbangɨra ian Afeziar uan Nguibamɨn itim bar akueghvɨra bizir aghuiba isɨ gumazir a ko mɨgeibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kamaghɨn, ia arazir aghuir igharaz darazi me ia damuasa ia ifongeziba, ia arazir kabara me damu. Mɨgɨrɨgɨar kaba, Moses Osirizir Araziba ko Godɨn akam inigha izir gumazibar osiziriba, dagh isɨn tu.” ");
INSERT INTO msy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Egha Iesus mɨgɨa ghua ghaze, “Ia tiar akar asuvazimɨn aven mangɨ. Tiar akar aroghezim nguibar ikuvtɨzimɨn zui. Ezɨ nguibar kamɨn zuir tuavim an aruegha bar ekefe. Ezɨ gumazamizir avɨrim an zui. ");
INSERT INTO msy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ezɨ nguibar aghuimɨn zuir tiar akam bar asufa, egha tuavir an zuim bar pɨri. Ezɨ gumazamizir vaghvaziba tuavir kam batogha an zui. Kamaghɨn amizɨ, ia tiar akar asuvazimɨn aven mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Egha Iesus mɨgɨa ghua ghaze, “Ia akar ifavarim akurir gumaziba bagh deravɨra gan. Me ia gifarsɨ mɨgɨrɨgɨar aghuibar amuam. Egha me guizbangɨra ia gasɨghasɨghasa izi. Me guizbangɨra afiar atiabar mɨn ikia, egha me ifara en damazibar sipsipbar mɨn sipsipbar arɨziba aghui. ");
INSERT INTO msy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ia men arazibar gan me gɨfogh, egh suam, me akar ifavarim akurir gumaziba. Gumaziba ter ataghataritamɨn wainɨn ovɨzitam kuarizir puvatɨ. Egha me ti fighɨn ovɨzitam kuarasa ghua, dɨkonir ataghatarimɨn, da isi? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ezɨ kamaghɨra temer aghuiba ovɨzir aghuiba bati, ezɨ temer kuraba ovɨzir kuraba bati. ");
INSERT INTO msy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Eghtɨ temer aghuitam ovɨzir kuratam bateghan kogham. Eghtɨ temer kuratam ovɨzir aghuitam bateghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Temer ovɨzir aghuiba batir puvatɨziba, me da oka da isa avim mɨkɨri. ");
INSERT INTO msy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kamaghɨn amizɨma, ia men arazibar gan fofogh suam, me akar ifavarim akurir gumaziba, o akar aghuim akurir gumaziba. ");
INSERT INTO msy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ia kamaghɨn nɨghnɨghan markɨ, gumazamizir ‘Ekiam, Ekiam’ na garɨziba, me bar moghɨra God Bizibagh Ativamin Dughiamɨn aven ikiam. Puvatɨ. Gumazir nan Afeziamɨn ifongiamɨn gɨn zuiba, merara God Bizibagh Ativamin Dughiamɨn aven ikiam. ");
INSERT INTO msy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Godɨn Kotɨn Dughiamɨn, gumazamizir avɨrim kamaghɨn mɨkɨmam, ‘Ekiam, Ekiam, e nɨn ziamɨn Godɨn akam akuri.’ Egh mɨkɨm suam, ‘E nɨn ziamɨn duar kuraba batoke,’ egh mɨkɨm suam, ‘E nɨn ziamɨn mirakelɨn bar avɨribagh ami.’ ");
INSERT INTO msy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Eghtɨ kɨ Dughiar kamɨn bighvɨra me mɨkɨm suam, ‘Kɨ tong ia gɨfozir puvatɨ. Ia gumazir arazir kurabagh amiba, ia na gitagh!’” ");
INSERT INTO msy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Egha Iesus mɨgɨa ghua ghaze, “Gumazir nan akam baragha an gɨn zuim, a mati gumazir mam fofozir aghuim ikia, egha uan dɨpenim ingara gavgavim a danɨngasa dagɨam gisɨn an ingari. ");
INSERT INTO msy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ezɨ amozim izima, aperiam otozɨma, amɨnir ekiam dɨkavigha dɨpenir kam givava a munamadi. Ezɨ dɨpenir kam dɨpɨriaghrɨzir puvatɨ. Dɨpenir kam me dagɨam gisɨn an ingari. Kamaghɨn amizɨ, a irɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ezɨ gumazir manam nan akam baregha an gɨn zuir puvatɨ, a mati gumazir onganimɨn mɨn gigimɨn uan dɨpenim okore. ");
INSERT INTO msy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ezɨ amozim izima aperiam otozɨma, amɨnir ekiam dɨpenir kam pamtem a givai. Bizir kaba dɨpenir kam gunabagha a munamadima, a irɨ. A guizbangɨra bar pazavɨra irɨ.” ");
INSERT INTO msy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iesus mɨgɨrɨgɨar kabav mɨkemegha gɨvazɨma, gumazamizir avɨrir ekiam dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Me fo, Iesus Judan arazibagh fozir gumaziba ami moghɨn mɨgeir puvatɨ. A gumazir ziar ekiam itir mamɨn mɨn men sure gami. ");
INSERT INTO msy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Egha Iesus mɨghsɨam ategha ghuaghirima avɨrir ekiam an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ezɨ gumazir lepa itir mam, Iesus bagha iza uan tevimning apɨrigha a mɨgɨa ghaze, “Ekiam, nɨ fueghɨva na damutɨ, kɨ Godɨn damazimɨn zuegh ua deragham.” ");
INSERT INTO msy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ezɨ Iesus uan agharim isa gumazir kam gatɨgha ghaze, “Kɨ ifonge. Nɨn mɨkarzim zuegh, egh ua deragh.” A kamaghɨn mɨgɨavɨra itima, gumazir kamɨn lepan arɨmariam zuamɨra anetaghizɨma gumazim ua dera. ");
INSERT INTO msy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ezɨ Iesus a mɨgɨa ghaze, “Nɨ oragh, nɨ batozir bizir kamɨn gun mɨkɨman markɨ. Nɨ mangɨ uan mɨkarzim isɨ ofa gamir gumazimɨn akagh, egh Moses fomɨra e mɨkemezɨ moghɨn, nɨ ua bagh Godɨn ofa damu. Eghtɨ gumaziba fogh suam, nɨn arɨmariam gɨfa.” ");
INSERT INTO msy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Egha Iesus ghua nguibar ekiam Kaperneamɨn aven ghu. Ezɨ 100 plan mɨdorozir gumazibar garir gumazir ekiam iza, Iesus gaghora ghaze, ");
INSERT INTO msy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Ekiam, nan ingangarir gumazim ariava muna dɨpenimɨn iti. An soroghafariba bar ariaghɨre, ezɨ a mɨzazir kuram barasi.” ");
INSERT INTO msy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ezɨ Iesus ghaze, “Kɨ mangɨ a damightɨ, a ua deragham.” ");
INSERT INTO msy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ezɨ mɨdorozir gumazir ekiam Iesusɨn akam ikaragha a mɨgɨa ghaze, “Ekiam, kɨ gumazir aghuir manam, nɨ nan dɨpenimɨn aven izam? Markɨ. Nɨ pura mɨkɨmtɨma, nan ingangarir gumazim deragham. ");
INSERT INTO msy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kɨ uabɨ mɨdorozir gumazir mabar apengan iti, egha uabɨ mabar garima, da nan apengan iti. Ezɨ kɨ me mɨgei, ‘Ia mangɨ,’ eghtɨ me mangam. O, kɨ me mɨkɨmam, ‘Ia izɨ.’ Eghtɨ me izam. Egh kɨ uan ingangarir gumazir mam mɨkɨm suam, nɨ ingangarir kam damu, eghtɨ an a damuam. Egha kɨ fo, nɨ mɨkɨmtɨ, nan ingangarir gumazim ua deragh.” ");
INSERT INTO msy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ezɨ Iesus mɨgɨrɨgɨar kam baregha, dɨgavir kuram gami. Egha ragha a ko izir gumazibav gɨa ghaze, “Kɨ bar guizbangɨra ia mɨgei, kɨ Israelɨn aven kamaghɨn nɨghnɨzir gavgavim itir gumazitamɨn ganizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Kɨ ia mɨgei, gumazamizir avɨrim uan nguibabar aruem anadir danganim ko aruem ghuaghiri danganim ategh, izɨ Abraham ko Aisak ko Jekop dukuagh, God Bizibagh Ativamin Dughiamɨn aven dakozimɨn daperagh damam. ");
INSERT INTO msy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Egh God faragh uan Nguibamɨn ikiasa mɨsevezir darazi, God me batuegh me isɨva danganir mɨtatem me akunigham. Eghtɨ me tuangɨva arangɨva atariba kuskugh danganir kamɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Egha Iesus 100 plan mɨdorozir gumazibar garir gumazir ekiam mɨgɨa ghaze, “Nɨ mangɨ. Bizir nɨ nɨghnɨzir gavgavim itim, a nɨ bagh otogham.” Dughiar kamra, gumazir kamɨn ingangarir gumazim ua dera. ");
INSERT INTO msy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ezɨ Iesus ghua Pitan dɨpenimɨn aven ghua garima, Pitan asamimɨn mɨkarzim an feima, an aria dakozim girɨghav iti. ");
INSERT INTO msy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ezɨ Iesus an dafarim suirazɨma, an arɨmariam maghɨram anetaghizɨma, a dɨkavigha Iesus bagha isai. ");
INSERT INTO msy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ezɨ aruem gevima, me gumazamizir avɨrir duar kuraba apazaziba inigha, Iesus bagha izi. Ezɨ Iesus duar kurar kabav gɨa me batozima, me an akamɨn gumazamiziba ataghrasi. Ezɨ Iesus arɨmariaba itir gumazamiziba bar men arɨmariaba agɨfa. ");
INSERT INTO msy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Godɨn akam inigha izezir gumazim Aisaia ghaze, “A uabɨ e bativir arɨmariaba ko mɨzaziba da batoghezɨ, da ghue.” Iesus Aisaian akam damightɨ, an otivasa, arazir kabagh ami. ");
INSERT INTO msy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Egha Iesus garima, avɨrir ekiam anekufa. Ezɨ a uan suren gumazibav gɨa ghaze, “E dɨpam giregh vongɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ezɨ Judan arazibagh fozir gumazir mam iza, kamaghɨn Iesus mɨgei, “Tisa, nɨ danganir manamɨn mangam, kɨ uaghan nɨ ko mangam.” ");
INSERT INTO msy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ezɨ Iesus a mɨgɨa ghaze, “Afiar atiaba nguazir toribar itima, kuaraziba mɨkonibar iti, ezɨ Gumazibar Otarim danganir dakuamiba puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ezɨ gumazir mam, a uaghan Iesusɨn suren gumazim, a kamaghɨn Iesus mɨgei, “Ekiam, nɨ faragh na amamangatɨghtɨma, kɨ mangɨ uan afeziam mozim dafaka.” ");
INSERT INTO msy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ezɨ Iesus a mɨgɨa ghaze, “Markɨ. Nɨ nan gɨn izɨ, gumazir ovengeziba uari uan gumazir kuabar afɨ.” ");
INSERT INTO msy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ezɨ Iesus botɨn anabozɨ, an suren gumaziba an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Me ghua ongarimɨn torimɨn amɨnir bar ekiam dɨkava ongarim gamima, a dɨpɨra kurim avasava ami. Ezɨ Iesus akuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ezɨ an suren gumaziba agaghuragha a mɨgei, “Ekiam, nɨ en akuragh, e arɨmɨghiregham!” ");
INSERT INTO msy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ezɨ a kamaghɨn me mɨgei, “Ian nɨghnɨzir gavgavim bar sufi. Ia tizim bagha atiati?” Egha a dɨkavigha amɨnim ko ongarim mɨgɨrɨgɨar gavgavim aning ganɨngizɨ, amɨnim gɨvazɨma, dɨpam uam amɨraghirɨ. ");
INSERT INTO msy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ezɨ an suren gumaziba nɨghnɨzir avɨribagh amua ghaze, “Kar gumazir manmaghɨn amizim? A mɨgeima, amɨnim ko dɨpavsɨzim an akam barasi!” ");
INSERT INTO msy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ezɨ Iesus ghua Galilin ongarir dadarimɨn vongɨn itimɨn oto. Kar Gadaran nguazir asɨzim. Egha iza gumazir pumuning duar kuraba apazimning bato. Aning matmatɨn tongɨn ikegha izi. Egha aning bar ikuvizɨma, gumazamiziba aningɨn atiatigha tuavir kam garuir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Egha aning pamten dia ghaze, “Nɨ Godɨn Otarim, nɨ tizim ga damuasa? Dughiam tɨgharɨ, nɨ kagh izɨ ga gasɨghasɨghasa?” ");
INSERT INTO msy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ezɨ dar bɨzir ekiar mam mong saghon apa iti. ");
INSERT INTO msy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ezɨ duar kurar kaba pamten Iesus gakaghora ghaze, “Nɨ e batosi, kamaghɨn nɨ e ateghtɨma, e mangɨ dar bɨzir munamɨn aven mangam.” ");
INSERT INTO msy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ezɨ Iesus me mɨgɨa ghaze, “Ia mangɨ.” Ezɨma duar kuraba gumazir kamning ategha ghua dabar aven ghue. Ezɨ dar bɨzir ekiar kam puv ara ghua davarir kurar mamɨn ghuaghira dɨpam apa bar ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ezɨ gumazir dabar gariba men ganigha ara ghue. Me ghua nguibar ekiamɨn otivigha bizir kabar gun gumazamizibagh eghari. Me uaghan gumazir duar kuraba apazazir pumuning bativizir bizibagh eghari. ");
INSERT INTO msy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kamaghɨn amizɨ, nguibar ekiar kamɨn itir gumazamiziba Iesus bagha izi. Me iza an gara a gakaghora ghaze, a men nguazim ategh danganir igharazitamɨn mangɨ. ");
INSERT INTO msy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ezɨ Iesus ua bot inigha uamategha ongarir dadarir vongɨn itimɨn ghua uan nguibamɨn oto. ");
INSERT INTO msy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ezɨ me soroghafariba aremezir gumazir mam inigha a bagha izi. Gumazir kam akuriamɨn iti. Ezɨ Iesus men garima, me nɨghnɨzir gavgavim itima, a kamaghɨn arɨmariar gumazir kam mɨgei, “Nan borim, nɨn navim bar amɨragh ikɨ. Kɨ nɨn arazir kuraba gɨn amada.” ");
INSERT INTO msy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ezɨ Judan arazibagh fozir gumazir maba Iesusɨn mɨgɨrɨgɨar kam baregha kamagh uariv gia ghaze, “Gumazir kam Godɨn danganim inigha kamaghɨn mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ezɨ Iesus men nɨghnɨzibagh fogha gɨvagha kamaghɨn me mɨgei, “Ia tizim bagha nɨghnɨzir kurar kaba uan navir averiabar dagh ami? ");
INSERT INTO msy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kɨ akar manam mɨkɨmam? Pura gumazir kɨnitam kamaghɨn a mɨkɨm suam, kɨ nɨn arazir kuraba gɨn amada. Egh uaghan gumazir kɨnitam kamaghɨn a mɨkɨman kogham, nɨ dɨkavigh uan akuriam inigh mangɨ, egh ua deragh. ");
INSERT INTO msy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Eghtɨ kɨ ia kamaghɨn foghasa kɨ ifonge, Gumazibar Otarim, a nguazir kamɨn arazir kuraba gɨn amangamin gavgavim iti.” Iesus kamaghɨn mɨkemegha soroghafariba aremezir gumazimɨn gara kamaghɨn a mɨgei, “Nɨ dɨkavigh uan akuriam inigh uan dɨpenimɨn mangɨ!” ");
INSERT INTO msy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ezɨ gumazir kam dɨkavigha uan dɨpenimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ezɨma gumazamiziba arazir kamɨn ganigha bar dɨgavir kuram gami. Egha me Godɨn ziam fa ghaze, “Godra gavgavir kam isa gumazibagh anɨdi.” ");
INSERT INTO msy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ezɨ Iesus danganir kam ategha ghua garima, gumazir mam dagɨaba isir dɨpenimɨn aperaghav iti. An ziam Matyu. Ezɨ Iesus a mɨgɨa ghaze, “Nɨ nan gɨn izɨ.” Ezɨma Matyu dɨkavigha an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ezɨ Iesus dɨpenimɨn ikiava apima, gumazir dagɨaba isiba ko gumazir arazir kurabagha amir avɨriba, me iza Iesus ko an suren gumaziba ko api. ");
INSERT INTO msy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ezɨ Farisiba kamaghɨn gara Iesusɨn suren gumazibar azai, “Ian Tisa, a tizim bagha dagɨaba isir gumaziba ko arazir kurabagh amir gumaziba koma api?” ");
INSERT INTO msy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ezɨ Iesus mɨgɨrɨgɨar kam baregha kamaghɨn me mɨgei, “Arɨmariaba puvatɨzir gumaziba, dokta bagha zuir puvatɨ. Gumazir arɨmariaba itibara, me dokta bagha zui. ");
INSERT INTO msy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ia mangɨ, Godɨn Akɨnafarir osizirim da fofozim inigh. Kɨ ia ofa gamir arazibagh ifongezir puvatɨ. Nan ifongiamra kara, ia arazir aghuibar gumazir igharazibar amu.” Egha Iesus ua me mɨgɨa ghaze, “Kɨ Godɨn damazimɨn derazir gumaziba bagha izezir puvatɨ. Kɨ gumazamizir arazir kurabagh amibar dɨmasa ize!” ");
INSERT INTO msy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ezɨ Jon Gumaziba Ruer Gumazimɨn suren gumaziba iza, kamaghɨn Iesusɨn azai, “Manmaghɨn amizɨ, e ko Farisiba, e God ko mɨkɨmasa dagheba ataghrazima, nɨn suren gumaziba dagheba ataghrazir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ezɨ Iesus kamaghɨn me mɨgei, “Ia nɨghnɨgh. Gumazitam amuimɨn ikɨsɨ damu, uan adarazi ko ikɨtɨma, me ti amughamugh, dagheba ataghraghan kogham. Puvatɨ. Me dagheba ataghrazir dughiam iti. Gumazitaba gɨn izɨ, gumazir kamɨn aku mangɨtɨ, a me ategham, eghtɨ dughiar kamɨn me dagheba ataghragham. ");
INSERT INTO msy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Gumazitam inir avɨzir igiatam inigha korotiar ghuritam porogha a isamizir puvatɨ. A kamagh damigh gɨn korotiar kam rueghtɨma, inir avɨzir korotiar bɨbɨzim apɨrizim akuvaghɨva korotiar ghurim bar anebigham. ");
INSERT INTO msy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Eghtɨ gumazitam wainɨn igiam inigh, a isɨva asɨzir inir mɨsevir ghuritam agurighan kogham. A kamaghɨn damightɨma, wainɨn dɨpam gɨn buva anangva asɨzir inir ghurir kam abightɨ, wainɨn dɨpam nguazim giregham. Eghtɨ wain ko asɨzir inim vɨrara ikuvigham. Kamaghɨn me wainɨn igiam isa asɨzir inir igiabaram azui, eghtɨ aning vɨrara deraghvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ezɨ Iesus Jonɨn suren gumaziba ko mɨgɨavɨra itima, gumazir dapanir ekiar mam iza Iesusɨn boroghɨn tevemning apɨrigha kamaghɨn a mɨgei, “Nan guivim datɨrɨghrama areme, ezɨ nɨ izɨ uan dafarim a datɨghtɨma a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ezɨ Iesus dɨkavigha an gɨn zuima, an suren gumaziba a ko zui. ");
INSERT INTO msy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ezɨma amizir mam, a 12 plan azenibar, zurara ghuzim bati. Amizir kam Iesusɨn gɨrakɨrangɨn iza an korotiar avɨzimɨn suira. ");
INSERT INTO msy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A kamaghɨn nɨghnɨgha ghaze, “Kɨ ti an korotiar avɨzimɨn suiraghtɨ, nan arɨmariam ti gɨvagham.” ");
INSERT INTO msy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ezɨ Iesus ragha an gara a mɨgɨa ghaze, “Nan guivim, nɨ navim bar amɨragh ikɨ. Nɨ nɨghnɨzir gavgavim nan iti, kamaghɨn, nɨn arɨmariam gɨfa.” Dughiar kamra, amizir kamɨn arɨmariam gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ezɨ Iesus ghua gumazir dapanir ekiar kamɨn dɨpenimɨn otogha gari, amiziba ko gumaziba azia iti. Gumazir maba sɨghabagh ivima, gumazamiziba azia nɨgɨnir ekiam gami. ");
INSERT INTO msy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ezɨ Iesus me batogha me mɨgɨa ghaze, “Ia dɨkavigh mangɨ. Guivim aremezir puvatɨ. An akui.” A kamaghɨn mɨgeima, me a dɨpofi. ");
INSERT INTO msy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","A me batoghezɨ, me azenan ghuezɨma, Iesus aven ghua guivimɨn dafarimɨn suirazɨma, a dɨkafi. ");
INSERT INTO msy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ezɨ Iesus amizir bizir kamɨn eghaghanim nguibaba bar dar ghu. ");
INSERT INTO msy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ezɨ Iesus danganir kam ategha zuima, gumazir damazir okavɨrɨzir pumuning an gɨn iza kamaghɨn an dei, “Nɨ Devitɨn Otarim, nɨ gan apangkufigh.” ");
INSERT INTO msy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","A ghua dɨpenimɨn aven ghuzɨma, gumazir kamning a bagha izima, a kamaghɨn aningɨn azai. “Gua bizir kɨ damuamin kam, gua nɨghnɨzir gavgavim an iti, o puvatɨ?” Ezɨ aning ghaze, “Are, Ekiam ga nɨghnɨzir gavgavim an iti.” ");
INSERT INTO msy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ezɨ Iesus uan dafarim isa aningɨn damazimning gatɨgha kamaghɨn mɨgei, “Gua nɨghnɨzir gavgavim iti. Kamaghɨn, gua ua gan.” ");
INSERT INTO msy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ezɨ aningɨn damaziba kuiaghrezɨ, aning ua gari. Ezɨ Iesus aningɨn anogorogha aningɨn mɨgɨa ghaze, “Gua tong bizir gua batozir kam tavɨn mɨkɨman markɨ.” ");
INSERT INTO msy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Puvatɨ. Aning ghua Iesus amizir arazir aghuir kamɨn gun bar distrighɨn kamɨn itir gumazamizibav keme. ");
INSERT INTO msy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gumazir kamning Iesus ategha zuima, gumazamiziba mɨgeir puvatɨzir gumazir mam inigha, Iesus bagha izi. Gumazir kam, duar kuraba a gapasa. ");
INSERT INTO msy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ezɨ Iesus an duar kuraba batoghezɨma, gumazir kam ua mɨgei. Ezɨ gumazamiziba dɨgavir kuram gamua ghaze, “Fomɨra, kantri Israelɨn aven, bizir kamagh garitam otozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ezɨ Farisiba ghaze, “A duar kurabar gumazir dapanimɨn gavgavimɨn duar kuraba batosi.” ");
INSERT INTO msy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ezɨ Iesus nguibar ekiaba ko nguibar doziba bar dagh arua, men God ko mɨgeir dɨpenibar aven ghua, gumazamizibar sure gami. A God Bizibagh Ativamin Dughiamɨn akam me mɨgɨa men arɨmariaba ko osɨmtɨzir men namnabar itiba bar da gefi. ");
INSERT INTO msy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","A gumazamizir avɨrir dafamɨn garima, men nɨghnɨziba tintinibar itima, me osɨmtɨzibar aven arua, mati sipsipba ghuaviba puvatɨzir moghɨn iti. Kamaghɨn amizɨ, a bar men apangkufi. ");
INSERT INTO msy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Egha a uan suren gumazibav gɨa ghaze, “Dagher bar avɨrim anigha gɨvagha azenimɨn iti. Ezɨ ingangarir gumazir da iniamin avɨriba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kamaghɨn, ia azenir kamɨn ghuavimɨn azangsɨghtɨ, a ingangarir gumaziba amangtɨma, me an azenimɨn mangɨ, dagheba iniam.” ");
INSERT INTO msy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ezɨ Iesus uan suren gumazir 12 plan diazɨ, me izima, a duar kuraba batoghɨva arɨmariar gumazamizibar itibar akɨramin gavgavim me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Aposelɨn 12 plan ziabara kara: Men faragha zuim, Saimon, an ziar mam Pita, ko an dozim Andru. Ko Jems, Sebedin otarim, ko an dozim Jon, ");
INSERT INTO msy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip ko Bartolomyu ko Tomas ko Matyu, a gumazir dagɨaba isim, ko Jems, an Alfiusɨn otarim, ko Tadius, ");
INSERT INTO msy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ko Saimon, a marazi ko me Selotɨn ikɨzimɨn iti, koma Judas Iskariot, gumazir Iesus isava, apanibagh anɨngizim. ");
INSERT INTO msy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ezɨ Iesus gumazir 12 plan kaba amaga akar kam me ganɨga ghaze, “Ia Kantrin Igharazibar Gumaziba bagh mangan markɨ. Egh Samarian nguibar ekiabar mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ia sipsipɨn ovengezir Israelɨn ikɨzimɨn itiba bagh mangɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ia mangɨ, akam akun suam, ‘God Bizibagh Ativamin Dughiam a roghɨra izegha gɨfa.’ ");
INSERT INTO msy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ia mangɨ gumazamizibar arɨmariaba agɨva; egh gumazir aremeziba me damutɨ me ua dɨkav, egh lepa itir gumazibar amutɨ me ua zuegh, egh duar kurar gumazamizibagh apazaziba da batogh. Bizir ia inizim ia purama a ini, ia a gɨvezezir puvatɨ. Kamaghɨra ia pura a isɨ gumazamizibar anɨng. Ia a bagh ivezitam inian kogham. ");
INSERT INTO msy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ia gol tam o silvan dagɨatam o kapan dagɨatam inigh mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ia daruamin dughiabar, ia biamɨtaritam inian markɨ. Egh ia siotiar pumuning, o dagarir asuatam o difizitam inigh mangan kogham. Bar puvatɨ. Guizbangɨra, ingangarir gumaziba, me damamin dagheba, me da isɨ me danɨng. ");
INSERT INTO msy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Egh ia nguibar ekiatamɨn mangam, o nguibar dozitamɨn angsɨva, ia deraghvɨra azangsɨgh fogh, gumazir manam an arazir aghuibagh amua egha bar dera. Egh ia gumazir kam ko ikɨ mangɨ, dughiar ia nguibar kam ategh mangamim. ");
INSERT INTO msy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Egh dɨpenir ia aven zuim, ia kamaghɨn an aven itir daraziv kɨm, ‘God deragh ia damuam.’ ");
INSERT INTO msy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Egh gumazamizir dɨpenir kamɨn itiba, ia gifueghɨva ia inightɨ, ia me ko ikɨ, egh ia Godɨn azaraghtɨ, ian navir amɨrɨzim me ko ikɨ. Me ian aghuaghtɨ, ia uan navir amɨrɨzir kam me da uam a inigh. ");
INSERT INTO msy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Egh gumazitam ia inigh uan dɨpenimɨn mangan aghuagh, egh ian akam baraghan koghtɨ, eghtɨ dughiar ia dɨpenir kam o nguibar kam ataghraghamim, ia uan dagaribar itir mɨneziba apɨsigh. ");
INSERT INTO msy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kɨ guizbangɨra ia mɨgei, Godɨn Kotɨn Dughiamɨn, God gumazamizibar arazir kuraba tuisɨghɨva, eghtɨ gumazamizir nguibar kamɨn itiba iniamin osɨmtɨzim, a Sodom ko Gomora uan arazir kuraba bagh inizimɨn osɨmtɨzim bar a gafiragham.” ");
INSERT INTO msy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ezɨ Iesus mɨgɨa ghua ghaze, “Ia oragh, kɨ sipsipbar mɨn ia isava afiar atiabar tongɨn ia amadi. Eghtɨ ia kuruzibar araziba iniva deravɨra bizibagh nɨghnɨgh ia gɨn dar amu. Egh ia kuarazir bunbabar arazibar amu, kamaghɨn ia arazir kuratam damusɨ nɨghnɨghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ia deraghvɨra uari bagh gan. Me ian suiragh, uan kaunselbar damazibar ia isɨ kotiam darɨghɨva, egh uan God ko mɨgeir dɨpenibar ia fozorogham. ");
INSERT INTO msy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Egh me nan ziam bangɨn, ia iniva gavmanba ko atrivibar damazibar mangam. Egh ia akar aghuimɨn gun gumazir ekiar kabav kɨm. Egh uaghan Kantrin Igharazibar Gumaziba, ia uaghan me mɨkɨm. ");
INSERT INTO msy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Egh me ia inigh kotiamɨn mangɨtɨma ia atiating kamaghɨn nɨghnɨghan markɨ, ‘E mɨgɨrɨgɨar manatam damuam? O, e manmaghɨn men akaba ikarvagham?’ Puvatɨ. God uabɨ dughiar kamɨn ia mɨkɨmamin akaba ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ia uari mɨkɨman kogham, puvatɨ. Ian Afeziamɨn Duamra, ian akatoribar aghu mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Gumaziba uan aveghbuaba isɨ kot darɨghɨva, egh me mɨsoghɨva arɨmɨghrɨsɨ me mɨkɨmam. Eghtɨ afeziaba kamaghɨra uan boribar amuam. Eghtɨ boriba uan afeziaba ko amebaba pazɨ me damuva, me mɨsoghtɨ, me arɨmɨghrɨsɨ, gumazibav kɨmam. ");
INSERT INTO msy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Eghtɨ gumaziba bar nan ziam bangɨn ian ikuvigham. Me bar paza ia damutɨ, eghtɨ gumazamizir gavgavigh ikɨ mangɨ dughiar abuananamɨn otoghamiba, God men akurvagham. ");
INSERT INTO msy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Egh gumazamiziba nguibar ekiar mamɨn pazɨ ia damutɨ, ia arɨ nguibar ekiar igharazimɨn angɨ. Kɨ guizbangɨra ia mɨgei, ia Israelɨn nguibar ekiar kabar aven damuamin ingangariba, da gɨvaghan koghtɨma Gumazibar Otarim uamategham. ");
INSERT INTO msy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Suren gumazitam uan tisa gafirazir puvatɨ, ezɨ ingangarir gumazitam uan gumazir ekiam gafiraghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eghtɨ suren gumazim uan tisan mɨn otoghɨva, egh deragham. Egh ingangarir gumazim uan ekiamɨn mɨn otoghɨva, a uaghan deragham. Me ziar kam Belsebul a isa dɨpenimɨn ghuavim gatɨ, ezɨ e kamaghɨn fo, me uaghan bar ziar kuraba da isɨva an adarazi darɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Egha Iesus mɨgɨa ghua ghaze, “Gumaziba pazɨ ia damutɨ, ia men atiatingan markɨ. Bizir mogomebar aven ikeziba, bar azenim giram. Eghtɨ mɨgɨrɨgɨar aven ikeziba, gumaziba bar dagh fogham. ");
INSERT INTO msy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kɨ mɨtatemɨn ia mɨkemezir akaba, ia angazangarimɨn dav kɨm. Egh sighsirir akar ia oraghiziba, ia mangɨ dɨpenir nogoribar tuiv dar gun gumazamizibav kɨm. ");
INSERT INTO msy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ia gumazir namnar kɨnibav sozibar atiatingan markɨ. Me ian duabav sueghan kogham. Puvatɨ. Ia Godram atiating. A namnam ko duam uaghara aning isɨva avimɨn aning gasɨghasɨghamin gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ia fo, gumaziba kuarazir dozir pumuning wan toean vɨrara aning givezegham. Ezɨ ian Afeziam deraghavɨra kuarazir kabar gari. Ian Afeziam ifueghan koghtɨma, kuarazir katam nguazim giran kogham. ");
INSERT INTO msy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Egha God uaghan ian dapanir arɨziba dar pone, egha a bar deraghavɨra ia gɨfo. ");
INSERT INTO msy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kamaghɨn amizɨma, ia atiatingan markɨ. Ia kuarazir dozir kabar mɨn itir puvatɨ. Ia Godɨn damazimɨn bar ekevegha dagh afira.” ");
INSERT INTO msy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ezɨ Iesus mɨgɨa ghua ghaze, “Gumazir manam gumazamizibar damazimɨn ghaze, a nan anav, eghtɨ kɨ uaghan uan Afeziar uan Nguibamɨn itimɨn damazimɨn mɨkɨm suam, gumazir kam a nan anav. ");
INSERT INTO msy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Eghtɨ gumazitam gumazamizibar damazimɨn mɨkɨm suam, a nan anav puvatɨ, eghtɨ kɨ uaghan uan Afeziar uan Nguibamɨn itimɨn damazimɨn mɨkɨm suam, gumazir kam nan anav puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ezɨ Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ia nɨghnɨgha ghaze, kɨ navir vamɨran arazim inigha, nguazir kamɨn ize. Ezɨ ia kamaghɨn nɨghnɨghan markɨ. Kɨ adariba ko mɨdoroziba gɨvasa izezir puvatɨ. Puvatɨ. Kɨ mɨdorozir sabam inigha ize. ");
INSERT INTO msy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kɨ bizir kam bagha ize, kɨ gumazim damutɨ, a uan afeziamɨn apanimɨn ikiam. Eghtɨ guivim uan amebamɨn apanimɨn ikiam, eghtɨ amizir pamɨn itim uan ivozir amebamɨn apanimɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Gumazimɨn anababa uari, an apanim ikɨva, an ikuvigham. ");
INSERT INTO msy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Gumazir manam uan afeziam ko amebam bar aning gifongegha, faragha aning arɨgha, egha na isa gɨn arɨgha, a guizbangɨra nan namakam puvatɨ. Egha gumazir manam uan otarim o guivim bar aning gifongegha, faragha aning arɨgha, egha na isa gɨn arɨsi, a nan namakam puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Egh gumazir manam uan ter ighuvir an ovengamim a gisaghpugha nan gɨn zuir puvatɨ, a nan namakam puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ezɨ gumazir manam deravɨra uan ikɨrɨmɨrim anekɨriva, gumazir kam gɨn ikian kogham. Eghtɨ gumazir manam na bagha nɨghnɨgha uan ikɨrɨmɨrim akɨrizir puvatɨ, a guizbangɨra ikɨrɨmɨrim bativam.” ");
INSERT INTO msy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ezɨ Iesus mɨgɨa ghua ghaze, “Gumazir manam ia inigha arazir aghuibar ia gami, a na inigha arazir aghuibar na gami. Egha gumazir na inizim, a Godɨn na amadazɨ kɨ izezim a ini. ");
INSERT INTO msy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eghtɨ gumazitam suam, kɨ Godɨn akam inigha izir gumazitamɨn akurvaghasa, egha Godɨn akam inigha izir gumazir kamɨn akua uan dɨpenimɨn ghua an akurvagha deragha a gami, God gumazir kam, bizir aghuir an akam inigha izir gumaziba isiba, God da isɨva a danɨngam. Eghtɨ gumazitam suam, kɨ gumazir aghuitamɨn akurvaghasa, egha gumazir aghuitam inigha uan dɨpenimɨn ghua deraghavɨra an akurvaki, God gumazir kam uaghan, bizir aghuir gumazir aghuiba isiba, God da isɨva a danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Eghtɨ tav suam, kɨ Iesusɨn suren gumazitamɨn akurvaghsɨ, egh pura dɨpar orangtɨzim a isɨva suren gumazir ziaba puvatɨzir katam a danigam, bar guizbangɨra kɨ ia mɨgei, God gumazir kam ivezir aghuim a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ezɨ Iesus akar kaba uan 12 plan suren gumazibagh ganiga, egha danganir kam ategha nguibar igharazibar ghua men sure gamua Godɨn akam me mɨkɨri. ");
INSERT INTO msy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon kalabusɨn ikia kamaghɨn God Ua Gumazamiziba Iniasa Mɨsevezir Gumazimɨn ingangariba baregha uan suren gumaziba a bagha me amada. ");
INSERT INTO msy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Egha me mɨgɨa ghaze, ia mangɨ kamaghɨn Iesusɨn azang, “Ti nɨrara, gumazir God faragha amangasa mɨkemezim? O, e ti ua gumazir igharazitam mɨzuamam?” ");
INSERT INTO msy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ezɨ Iesus men azangsɨziba ikaragha ghaze, “Ia mangɨ, bizir ia garava orazibar gun Jon mɨkɨm suam, ");
INSERT INTO msy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Gumazir damazir okavɨrɨziba ua gari, ezɨ gumazir suer amɨrɨziba uam arui. Ezɨ gumazir lepa itiba ua zuegha dera, ezɨ gumazir kuarir orazir puvatɨziba uam orasi. Ezɨ ovengezir gumaziba ua dɨkavima, ezɨ gumazir onganarazibagh amiba akar aghuim barasi.’ ");
INSERT INTO msy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Gumazir nan ganigha nɨghnɨzir gavgavim nan itim, an nɨghnɨzir gavgavim ikɨvɨra ikɨ, eghtɨ an navir averiam deraghtɨ a bar akuegham!” ");
INSERT INTO msy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ezɨ Jonɨn suren gumaziba an ategha ghuezɨma, Iesus an gun gumazamizibav gei, “Ia gumaziba itir puvatɨzir danganimɨn ghua tizimɨn ganasa ghue? Ia ti ghurunir amɨnim vaimɨn ganasa ghue? Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ia tizimra ganasa ghue? Ia ti gumazir korotiar aghuiba aghuizɨtamɨn ganasa ghue? Puvatɨ. Gumazir korotiar aghuiba azuiba, atrivibar dɨpenibar iti. ");
INSERT INTO msy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ezɨ ia tizimɨn ganasa ghue? Ia Godɨn akam inigha izir gumazitamɨn ganasa ghue? Bar guizbangɨra! Ki ia mɨgei, Godɨn akam inigha izir gumazir kam, a Godɨn akam inigha izir gumazir igharaziba, bar me gafira. ");
INSERT INTO msy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gumazir kam baghavɨra Godɨn Akɨnafarim mɨgɨa ghaze, ‘Ia oragh. Kɨ uan abuir gumazim amadaghtɨma, a faragh mangɨva nɨ bagh tuavim akɨram.’ ");
INSERT INTO msy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kɨ guizbangɨra ia mɨgei, Jon Gumazibar Ruer Gumazim, gumazir nguazimɨn itiba, bar me gafira. Ezɨ gumazir God Bizibagh Ativamin Dughiamɨn aven ikia ziaba bar puvatɨzim, a bar Jon gafira. ");
INSERT INTO msy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Jon Gumaziba Ruer Gumazimɨn dughiamɨn ikegha iza datɨrɨghɨn, gumazir kuraba God Bizibagh Ativamin Arazim iniasa puv ingara mɨsosi. Egha me mɨdorozir arazir anabar igharazibagh amua, egha osɨmtɨzir avɨriba a ganɨdi. ");
INSERT INTO msy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Godɨn akam inigha izir gumazibar osiziriba ko Moses Osirizir Araziba, da Godɨn akam akura iza Jon otozir dughiamɨn tu. ");
INSERT INTO msy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kamaghɨn amizɨ, ia dar akam baraghsɨ ifuegh, a baragh, ‘Godɨn akam inigha izir gumazim Elaiza izam,’ kar a Jon baghavɨra mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tina kuarimning iti, an oragh. ");
INSERT INTO msy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Eghtɨ kɨ datɨrɨghɨn itir gumazamizibar arazibar gun mɨkɨmsɨva akar isɨn zuir manam mɨkɨmam? Me boribar mɨn biziba amadir danganimɨn apiaghav ikia uarir dei, ");
INSERT INTO msy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘E ia bagha marvibagh ivima, ia ighian aghua. Ezɨ e ongerakar amɨrɨzibagh amima, ia azir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Datɨrɨghɨn itir gumaziba, borir kabar mɨn ami. Jon izava pamten apir puvatɨghava wainɨn dɨpaba apir puvatɨzɨma, me ghaze, ‘Duar kuraba a gapasa.’ ");
INSERT INTO msy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ezɨ Gumazibar Otarim izava dagheba ko wainɨn dɨpaba api. Ezɨ me ghaze, ‘Ia gan, a gumazir puv daghem ko wainɨn dɨpam apim. Egha a dagɨaba isir gumaziba ko gumazir arazir kurabagh amiba, a men roroabagh amua me ko iti.’ Me kamaghɨn mɨgeima, gumazamiziba men gara fo, Godɨn fofozim a guizbangɨra bizim.” ");
INSERT INTO msy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iesus nguibar ekiar mabar mirakelɨn avɨribagh amizɨ me uan navibagh irazir puvatɨ. Ezɨ Iesus dughiar kamɨn nguibar kabar gumazamizibar atara ghaze, ");
INSERT INTO msy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ia Korasinɨn nguibamɨn itir gumazamiziba, Iavzika! Ia kuram iniam. Ia Betsaidan nguibamɨn itir adarazi, Iavzika! Ia bar ikuvigham. Gumazitam Tairɨn nguibam ko Saidonɨn nguibamɨn ghua, mirakelɨn kɨ amiziba men tongɨn dagh amighai, Tair ko Saidonɨn itir darazi ti fomɨra navibagh iragha, egha azir adiariba aghuigha, averenim gapiava aguruava, egha uan arazir kamɨn uari akakagha ghaze, me uan arazir kuraba ataki. ");
INSERT INTO msy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ezɨ kɨ ia mɨgei, Godɨn Kotɨn Dughiamɨn, osɨmtɨzir ia iniamim, an osɨmtɨzir Tair ko Saidon iniamim gafiragham. ");
INSERT INTO msy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ezɨ ia Kaperneamɨn nguibamɨn itir darazi, ia ghaze, ia uari fegh Godɨn Nguibamɨn ikiam, a? Bar puvatɨ, God ia akunightɨ ia Helɨn avim magɨram. Ezɨ gumazitam ti Sodomɨn nguibamɨn ghua mirakelɨn kɨ ian tongɨn amizibagh amizɨ, kamaghɨn Sodom ti ikiavɨra ikiai. ");
INSERT INTO msy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ezɨ kɨ ia mɨgei, Godɨn Kotɨn Dughiamɨn, osɨmtɨzir ia iniamim, an osɨmtɨzir Sodom inizim gafiragham.” ");
INSERT INTO msy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Egha dughiar kamɨn Iesus kamaghɨn mɨgei, “Afeziam, nɨ nguazim ko overiam gativazir Ekiam! Nɨ fofozim ko nɨghnɨzir aghuiba itir gumaziba bizir kaba men modo, egha boribar mɨn itir gumazibar aka. Kamaghɨn kɨ nɨ mɨnabi. ");
INSERT INTO msy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Guizbangɨra Afeziam, nɨ uan ifongiamɨn kamaghɨn ami.” ");
INSERT INTO msy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Egha Iesus ua kamagh mɨgei, “Nan Afeziam biziba bar ada isa nan dafarim gatɨ. Ezɨ gumazitam Otarim gɨfozir puvatɨ. Afeziam uabɨra a gɨfo. Egha tav Afeziam gɨfozir puvatɨ. Otarim uabɨra, koma gumazir Otarim ifuegha Afeziam isava men akaziba, merara Afeziam gɨfo. ");
INSERT INTO msy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ia, gumazir ingangarir ekiabagh amua osɨmtɨzir avɨriba ateriba, ia bar moghɨra na bagh izɨ. Eghtɨ kɨ aghuvsazim ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ia na da fofozim iniva nan mɨgɨrɨgɨabar apengan ikɨ, egha mati temer ruarir me bulmakauningɨn tuemning gatɨzɨma aning uaning inigha ingangarim gami moghɨn, ia nan apengan ikɨ. Ia na gɨfo, kɨ uan navir averiamɨn aven uabɨ dɨkabɨragha, egha kɨ gumazibar asughasusi. Egh kɨ ia damutɨ ia aghuvsazim iniam. ");
INSERT INTO msy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ter ruarir kɨ ian tuebagh arɨzim, ia a gumuam, ezɨ bizir kɨ aterim an osemezir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Egha Iesus Sabatɨn dughiar mamɨn uan suren gumaziba ko, raizɨn mɨn garir dagher mam wit, an azenir ekiamɨn torimɨn zui. An suren gumaziba mɨtiriam men azima, me witɨn ovɨzir maba kuara da api. ");
INSERT INTO msy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ezɨ Farisiba men ganigha kamaghɨn Iesus mɨgei, “Nɨ gan, arazir nɨn suren gumaziba amim, en Judabar Araziba ghaze, me Sabatɨn dughiamɨn dar amuan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ezɨ Iesus me ikaragha ghaze, “Ia ti Devit fomɨra amizir arazimɨn eghaghanimɨn ganizir puvatɨ? Devit dughiar kamɨn uan adarazi ko mɨtiriam men azi, ");
INSERT INTO msy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ezɨ Devit Godɨn Averpenimɨn aven ghua me ofa damuasa atɨzir bret inigha uan adarazi ko me aneme. E fo, me bretɨn kam raman kogham. Puvatɨ, Moses Osirizir Araziba ghaze, ofa gamir gumazibara bretɨn kam ramam. ");
INSERT INTO msy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Egha ia ti Moses Osirizir Arazibar ganizir puvatɨ, a ghaze, ofa gamir gumaziba me Godɨn Dɨpenimɨn aven Sabatɨn me ingaram. Me ingara, egha Godɨn damazim arazir kuraba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ezɨ kɨ ia mɨgei, bizir Godɨn Dɨpenim gafirazim a kagh iti. ");
INSERT INTO msy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Egha Godɨn Akɨnafarimɨn aven itir mɨgɨrɨgɨar mam ghaze, ‘Kɨ apangkuvir arazim gifonge, kɨ ofan kɨnibagh ifongezir puvatɨ.’ Ia mɨgɨrɨgɨar kam gɨfogha, egha ia pura osɨmtɨziba gumazir aghuibagh arɨghan koghai. ");
INSERT INTO msy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ezɨ Gumazibar Otarim a Sabatɨn dughiamɨn Ekiam.” ");
INSERT INTO msy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Egha Iesus danganir kam ategha nguibar ekiar mamɨn ghua God ko mɨgeir dɨpenimɨn aven ghu. ");
INSERT INTO msy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ezɨ gumazir mam dɨpenir kamɨn aven iti, an dafarir mam bar ekone. Ezɨ gumazir maba Iesus akatam a gasasa, egha kamaghɨn an azai, “Moses Osirizir Araziba manmaghɨn mɨgei? E Sabatɨn dughiamɨn gumazibar arɨmariabar akɨram, o puvatɨgham?” ");
INSERT INTO msy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ezɨ Iesus kamaghɨn me mɨgei, “Ian tongɨn itir gumazitam, a sipsipɨn mam ikɨtɨma, egh Sabatɨn dughiamɨn sipsipɨn kam mozitamɨn magɨrɨghtima, eghtɨ a ti mangɨ uam anesigham, o? ");
INSERT INTO msy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E fo, gumazimɨn ikɨrɨmɨrim sipsipɨn ikɨrɨmɨrim bar a gafira! Kamaghɨn amizɨma, e fo Moses Osirizir Araziba en amamangatɨzɨ, e Sabatɨn dughiamɨn gumazibar akurvagham.” ");
INSERT INTO msy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Egha a gumazir kam mɨgei, “Nɨ uan dafarim onegh.” Ezɨ gumazim uan dafarim onezɨma an dafarim dafarir vuemɨn mɨn, ua dera. ");
INSERT INTO msy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ezɨ Farisiba dɨkavigha God ko mɨgeir dɨpenim ategha uari akuvagha Iesus mɨsoghasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Farisiba Iesus mɨsoghasa tuaviba burima, a men arazir kam gɨfoghava nguibar ekiar kam ategha ghu. Ezɨ gumazamizir avɨriba an gɨn zuima, a men arɨmariaba bar dar kɨrima, me ua dera. ");
INSERT INTO msy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ezɨ a men anogorogha ghaze, me an gun igharazibav kɨman markiam. ");
INSERT INTO msy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A Godɨn akam inigha izir gumazim Aisaian mɨgɨrɨgɨam damutɨ, an otivasa, egha a kamaghɨn ami. Aisaia kamaghɨn mɨkeme, ");
INSERT INTO msy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kar nan ingangarir gumazim, kɨ uabɨ anemɨsefe, egha kɨ bar a gɨfuegha, a bagha bar akonge. Kɨ uan Duam a datɨghtɨ, a Kantrin Igharazibar Gumaziba me mɨkɨm suam, dughiar kɨ men araziba tuisɨghamim otivam. ");
INSERT INTO msy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gumazir kam atar dagarvaghan kogham. Me tuavibar an tiarim baraghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Egh ighurunir gavgaviba puvatɨgha dɨpɨrasava amim, a bar dɨpɨrighan kogham, egha lamɨn pamtem isir puvatɨzim, an anemungeghan kogham. Egh kamaghɨra, a gavgaviba puvatɨzir gumazamizibar asughasugh deravɨra me damuam. A kamaghɨra damu mangɨ, arazir aghuiba dar amutɨma da bar azenim giramin dughiam otogham. ");
INSERT INTO msy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eghtɨ Kantrin Igharazibar Gumaziba nɨghnɨzir gavgavim an ikɨva uarir akurvaghsɨva a mɨzuam ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dughiar kamɨn me duar kuram apazazir gumazir mam inigha Iesus bagha ize. Gumazir kam mɨgeir puvatɨgha uaghan garir puvatɨ. Ezɨ Iesus gumazir kam a gamizɨma a deragha ua mɨgɨa egha uaghan gari. ");
INSERT INTO msy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ezɨ gumazamiziba dɨgavir kuram gamigha mɨgɨa ghaze, “Gumazir kam ti Devitɨn otarim, a?” ");
INSERT INTO msy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ezɨ Farisiba mɨgɨrɨgɨar kam baregha ghaze, “Gumazir kam, duar kurabar gumazir dapanim Belsebul, gavgavim a ganɨngizɨ, ezɨ a gavgavir kamɨn duar kuraba batosi.” ");
INSERT INTO msy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ezɨ Iesus men nɨghnɨzibagh fogha egha kamagh me mɨgei, “Kantrin tamɨn gumaziba uari tuiragh uarira uariv soghɨva, eghtɨ men dabirabim ikuvigham. Eghtɨ dɨpenir vamɨra itir darazi o nguibar vamɨra itir darazi uari tuiragh uarira uariv soghɨva, eghtɨ men dabirabim ikuvigham. ");
INSERT INTO msy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eghtɨ kamaghɨra e fo, Satan uabɨ uabɨ batoghɨva, an adarazi uari tuiraghɨva, egh a managh gavgavim inigh bizibagh ativam. ");
INSERT INTO msy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ia ghaze, kɨ Belsebul da gavgavim isa duar kuraba batosi. Ezɨ kamaghɨn, tina ian adarazir akurvazima, me duar kuraba batosi? Ian adarazi amir araziba, darara ian akagha ghaze, ia paza na mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Eghtɨ kɨ Godɨn Duamɨn gavgavim inighɨva duar kuraba batoghtɨ, eghtɨ bizir kam ian akaghtɨ, ia kamaghɨn fogh suam, God Bizibagh Ativamin Dughiam ia batogha gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Eghtɨ gumazir manam mangɨ pura gumazir gavgavitamɨn dɨpenimɨn aven mangɨva an biziba okemegham? Puvatɨgham. A faraghvɨra benibar gumazir gavgavir kam ikegham. A kamaghɨn a damigh gumazir kamɨn dɨpenimɨn aven mangɨ, an biziba okemegham. ");
INSERT INTO msy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Tina nan namakam puvatɨ, a nan apanim. Ezɨ gumazim nan akuragha gumazamiziba akumakuir puvatɨ, gumazir kam men gɨntɨzima me tintinibar zui. ");
INSERT INTO msy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Kamaghɨn amizɨ, kɨ ia mɨgei, gumazamiziba amir arazir kuraba ko me Godɨn ziam gasɨghasɨzir akaba, God bar da gɨn amadagham. Eghtɨ gumazitam Godɨn Duamɨn ziam gasɨghasɨghtɨ, God an arazir kurar kam gɨn amadaghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Eghtɨ gumazitam akar kuratam Gumazibar Otarim mɨkemeghtɨ, God an arazir kurar kam gɨn amadagham. Eghtɨ gumazitam Godɨn Duam akar kuratam a mɨkemeghtɨma, God dughiar kam ko gɨn izamin dughiamɨn, an arazir kurar kam, a gɨn amadaghan kogham. An arazir kurar kam an ikɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ezɨ Iesus mɨgɨa ghua ghaze, “Nɨ temer aghuim ikɨtɨma, an ovɨzir aghuiba uaghan ikiam. Egh nɨ temer kuram ikɨtɨma, an ovɨzir kuraba uaghan ikiam. ");
INSERT INTO msy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ia gumazir kuraba, ia kuruzir kurabar mɨn iti! Egh manmagh mɨgɨrɨgɨar aghuitam mɨkemegham? Puvatɨ. Ian navir averiabagh izɨvazir nɨghnɨziba dar amara ian akatoribar otifi. ");
INSERT INTO msy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Gumazir aghuim, an navir averiamɨn aven nɨghnɨzir aghuiba a gizɨfa, egha amara arazir aghuibagh ami. Gumazir kuram, an navir averiamɨn aven nɨghnɨzir kuraba a gizɨfa, egha amara arazir kurabagh ami. ");
INSERT INTO msy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ezɨ kɨ ia mɨgei, Godɨn Kotɨn Dughiamɨn, a pura men mɨgɨrɨgɨar nɨghnɨziba puvatɨziba bagh vaghvagh men azangsɨghɨva, me tuisɨgham. ");
INSERT INTO msy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","God gɨn nɨn mɨgɨrɨgɨabagh nɨghnɨghɨva, nɨ tuisɨgham, eghtɨ nɨn mɨgɨrɨgɨabara nɨ damutɨma, God gumazir aghuim o gumazir kuram nɨ darɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ezɨma Judabar arazibagh fozir gumazir maba ko Farisin maba kamaghɨn Iesus mɨgei, “Tisa, nɨ mirakelɨn arazitam damutɨ, an otoghtɨ e fogh suam, nɨ guizbangɨra Godɨn ingangarim gami.” ");
INSERT INTO msy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ezɨ Iesus me ikaragha ghaze, “Gumazamizir dughiar kamɨn itiba, me bar gumazamizir kuraba! Egha me guizbangɨra God baghavɨra itir puvatɨ. Me zurara mirakelɨn tamɨn ganasa. Me tamɨn ganighan kogham. Puvatɨ. God mirakelɨn arazir vamɨra men akagham. Godɨn akam inigha izir gumazim Jona batozir mirakelɨn kamra, me an ganam. ");
INSERT INTO msy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E fo, Jona arueba ko dɨmagarir pumuning ko mɨkezimɨn osirir ekiar mamɨn navir averiamɨn ike. Ezɨ kamaghɨra Gumazibar Otarim arueba ko dɨmagarir pumuning ko mɨkezimɨn nguazimɨn aven ikiam. ");
INSERT INTO msy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Eghtɨ God Kotɨn Dughiamɨn, Niniven gumazamiziba dɨkavigh ian arazir kurabar gun mɨkɨmam. Ia fo, Nineven adarazi Jona akunizir akam baregha navibagh ira. Ezɨ Gumazir datɨrɨghɨn ian tongɨn itir mam, a bar Jona gafira! ");
INSERT INTO msy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fomɨra Seban Atrivir Amizim nguazir kamɨn saghon ikegha Solomonɨn fofozir aghuimɨn akaba baraghasa ize. Ezɨ gumazir mam bar Solomon gafiragha ian tongɨn iti. Kamaghɨn, God gumazamizibar Kotim Damuamin Dughiamɨn, Seban Atrivir Amizim tugh datɨrɨghɨn itir gumazamizibar arazir kurabar gun mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ezɨ Iesus mɨgɨa ghua ghaze, “Duar kuram gumazir mam ategha dɨpaba puvatɨzir danganibar arua ikiamin danganiba buri, egha a tam batozir puvatɨgha, ");
INSERT INTO msy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","egha uabɨ mɨgɨa ghaze, ‘Kɨ uamategh faragha ikezir dɨpenimɨn mangam.’ Egha a uamategha ghua garima, me dɨpenim avizɨ, a bar zuezɨma an itir biziba bar deragha ikia egha pura iti. ");
INSERT INTO msy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Egh duar kurar kam mangɨ, 7 plan duar kurar a gafiragha arazir kurabagh amiba, men aku izam. Egh me mangɨ, dɨpenir kamɨn ikiam. Gumazir kam faragha paza ike, egh a datɨrɨghɨn bar paz ikiam, eghtɨ an dabirabim a faragha ikezir dabirabim bar a gafiragh bar ikuvigham. Arazir kamaghɨra amizim, gumazamizir kurar datɨrɨghɨn itiba uaghan me bativam, eghtɨ me bar pazɨ ikiam. Eghtɨ men dabirabim, faragha ikezir dabirabim bar a gafiragh bar ikuvigham.” ");
INSERT INTO msy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesus me mɨgɨavɨra itima, an amebam ko doziba iza dɨpenimɨn azenimɨn ikia a ko mɨkɨmasa. ");
INSERT INTO msy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ezɨ gumazir mam a mɨgɨa ghaze, “Nɨ gan, nɨn amebam ko doziba azenimɨn tuivighav ikia nɨ ko mɨkɨmasa.” ");
INSERT INTO msy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ezɨ Iesus gumazir kam ikaragha ghaze, “Tina nan amebam? Te nan doziba?” ");
INSERT INTO msy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Egha uan suren gumazibar akagha ghaze, “Ia gan! Nan amebam ko dozibara kara. ");
INSERT INTO msy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gumazamizir nan Afeziar uan Nguibamɨn itim ifongezir arazibar gɨn zuiba, me nan doziba ko nan amiziba ko nan amebam.” ");
INSERT INTO msy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aruer kamra Iesus dɨpenim ategha azenan ghu. Egha ghua dɨpar dadarimɨn aperaghav iti. ");
INSERT INTO msy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ezɨ gumazamizir avɨriba a bagha ize, egha men avɨrim bar ekefe. Kamaghɨn a kurir mamɨn bɨraghava apera. Ezɨma gumazamiziba dɨpar dadarimɨn tuivighav iti. ");
INSERT INTO msy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ezɨ Iesus akar isɨn zuir avɨribar me mɨgei. Egha kamaghɨn mɨgei, “Ia oragh. Gumazir mam witɨn ovɨziba inigha ghua uan azenimɨn da akurava arui. ");
INSERT INTO msy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A da akurima witɨn ovɨzir maba tuavimɨn irezɨma, kuaraziba iza da ame. ");
INSERT INTO msy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ezɨ maba dagɨabagh isɨn itir nguazir evarim gire. Nguazir kam mɨtemezir puvatɨ, ezɨ witɨn ovɨziba zuamɨra afuangi. ");
INSERT INTO msy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ezɨ dar biba bar nguazimɨn aven iraghuezir puvatɨ, ezɨ aruem anaga dagh isirazɨ, ezɨ da isia mɨsɨngi. ");
INSERT INTO msy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ezɨ witɨn ovɨzir maba benir dɨkoniba itir nguazim giregha, benibar tongɨn afuangizɨ, benir dɨkoniba aghuava beniba da ikiagharɨki. Ezɨ dar ovɨziba mɨsevezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ezɨ witɨn ovɨzir maba nguazir aghuim giregha dagheba mɨsefi. Maba 100 plan ovɨziba mɨsevima, maba 60 plan ovɨziba mɨsevima, maba 30 plan ovɨziba mɨsefi. ");
INSERT INTO msy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ezɨ Iesusɨn suren gumaziba gɨn iza kamaghɨn an azai, “Nɨ tizim bagha akar isɨn zuibar gumazamizibav gei?” ");
INSERT INTO msy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ezɨ a me ikaragha ghaze, “God fofozim ia ganɨngizɨma, ia God Bizibagh Ativamin Dughiamɨn akar mogomeba dagh fo. Ezɨ a fofozir kam me ganɨngizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Godɨn akabagh fozir gumazim, God uan akabar fofozir igharaziba a danɨngam, eghtɨ a Godɨn akar avɨribagh fogham. Eghtɨ Godɨn akabagh foghan aghuazir gumazim, an fofozir muziarim God a dama inigham. ");
INSERT INTO msy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Men damaziba gara, egha me bizitamɨn gari puvatɨ. Egha me oragha, me bizitamɨn mɨngarim bar anebɨghizir puvatɨ. Kɨ bizir kamɨn tugha akar isɨn zuibar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Godɨn akam inigha izir gumazim Aisaian mɨgɨrɨgɨaba gumazamizir kaba bagha guizbangɨra otifi. A kamaghɨn mɨkeme. ‘Gumazamizir kaba uan navir averiabar kua, ezɨ men kuariba oraghan aghua, ezɨ men damaziba kome. Me kamaghɨn amima, God ghaze, markɨ, men damaziba bizitamɨn ganighai, men kuariba oreghai. Ezɨ men naviba kuighrɨzɨma me mɨgɨrɨgɨabagh foghava egha navibagh iragha na bagha izima, kɨ ua me inigha me gamizɨma me deraghai. Me kamaghɨn damuan aghua, kamaghɨn me zurara oraghɨva, egh deragh bizitamɨn mɨngarim gɨfoghan kogham. Me zurara ganɨva, egh deragh bizitamɨn ganighan kogham.’ ");
INSERT INTO msy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ezɨ ia, ian damaziba bizibar gari, ezɨ ian kuariba akam barasi. Kamaghɨn ia bar akongegh! ");
INSERT INTO msy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kɨ guizbangɨra ia mɨgei, fomɨra Godɨn akam inigha izir gumazir avɨriba ko gumazir aghuir avɨriba, me ia datɨrɨghɨn garir bizibar ganamin ifongiar bar ekiam ikia, me dar ganizir puvatɨ. Egha ia datɨrɨghɨn orazir akar kaba, me da baraghan ifongiar bar ekiam ikia, me tam baraghizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ezɨ Iesus mɨgɨa ghua ghaze, “Ia datɨrɨghɨn oragh, gumazim witɨn ovɨziba akunizir akar isɨn zuimɨn mɨngarimra kara. ");
INSERT INTO msy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gumazir God Bizibagh Ativamin Dughiamɨn akam baragha anebɨzir puvatɨziba, me witɨn ovɨzir tuavim girezibar mɨn ami. Me Godɨn akam barazima, Satan zuamɨra izava me oraghizir akaba me dama, da ini. ");
INSERT INTO msy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ezɨ witɨn ovɨzir dagɨabagh isɨn itir nguazim gireziba, da gumaziba Godɨn akam baragha zuamɨra nɨghnɨzir gavgavim an ikia bar akonge. ");
INSERT INTO msy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ezɨ men biba puvatɨ, egha dughiar bar otevimra iti. Eghtɨ gumazitaba izɨ Godɨn akam bagh pazɨ me damuva osɨmtɨziba me darɨghtɨma, me zuamɨra God ategham. ");
INSERT INTO msy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ezɨ witɨn ovɨzir benir dɨkonibar tongɨn ireziba, kar gumaziba Godɨn akam baraghava, egha uaghan nguazir kamɨn osɨmtɨzibagh nɨghnɨgha, egha uaghan dagɨar avɨriba iniasa nɨghnɨsi. Ezɨ bizir kaba Godɨn akaba ikiagharɨghizɨma da mɨsevir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ezɨ witɨn ovɨzir nguazir aghuim gireziba, kar gumazir Godɨn akam baragha deragha anebɨgha a gɨfoziba. Gumazir kabanagh dagheba mɨsefi, maba 100 pla, maba 60 pla, maba 30 plan ovɨziba mɨsefi.” ");
INSERT INTO msy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Egha Iesus uam akar isɨn zuir mamɨn kamagh me mɨgei, “God Bizibagh Ativamin Dughiam mati gumazir mam witɨn ovɨzir aghuiba uan azenimɨn da akuni. ");
INSERT INTO msy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ezɨ gumazamiziba akuima gumazir witɨn ovɨziba akunizimɨn apanim iza ogher kuramɨn ovɨziba isa witbar tongɨn da akunigha ghu. ");
INSERT INTO msy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ezɨ witba gɨn aguigha mɨsɨvasava amima, me gari ogher kurar kam uaghan iti. ");
INSERT INTO msy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ezɨ azenir kamɨn ghuavimɨn ingangarir gumaziba ghua a mɨgɨa ghaze, ‘Gumazir ekiam, e ghaze nɨ witɨn ovɨzir aghuiba uan azenim mɨkɨni. Manmagh amizɨma, ogher kurar kam uaghan otifi?’ ");
INSERT INTO msy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ezɨ a me mɨgɨa ghaze, ‘Nan apanir mam arazir kam gami.’ Ezɨ an ingangarir gumaziba an azai, ‘Nɨ ifueghtɨma, e mangɨ ogher kam suagham?’ ");
INSERT INTO msy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ezɨ a ghaze, ‘Markɨ. Ia ogher kuraba asighsuva, uaghan witba asiam. Kamaghɨn da asian markɨ. ");
INSERT INTO msy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ia da ateghtɨma da mar witba ko aghung, mangɨ dagheba iniamin dughiamɨn otogh. Eghtɨ kɨ ingangarir kam damuamin gumaziba kamagh me mɨkɨmam, “Ia ogher kurar kam faragh anesɨva a dapongsɨva an ikɨzibar amu. Eghɨva ia witba iniva da akuvagh da isɨva nan dagher dɨpenim darɨgham.”’” ");
INSERT INTO msy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Egha Iesus akar isɨn zuir igharazir mamɨn me mɨgɨa ghaze, “God Bizibagh Ativamin Dughiam mati zuravarir me mastet arɨzimɨn ovɨzimɨn mɨn ami. Gumazir mam mastetɨn ovɨzim inigha ghua uan azenimɨn anekuni. ");
INSERT INTO msy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastetɨn ovɨzim dagher igharazibar ovɨzibar mɨn ekevezir puvatɨ. A bar sufi. Egha an aghuir dughiamɨn an azenimɨn itir zuravarir mabagh afiragham. A tememɨn mɨn aghungigham, eghtɨma kuaraziba izɨva an aguabar mɨkonibar ingaram.” ");
INSERT INTO msy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Egha Iesus akar isɨn zuir igharazir mam kamaghɨn me mɨgei, “God Bizibagh Ativamin Dughiam, a yisɨn mɨn ami. Amizir mam yisɨn muziarir mam inigha, flauan dramɨn ekiamɨn itim inigha, aning verevere. Ezɨ flauan kam gɨn bar bui.” ");
INSERT INTO msy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesus gumazamizibav geir mɨgɨrɨgɨaba, an akar isɨn zuibara da akuri. Egha a mɨgɨrɨgɨatam abigha me mɨkemezir puvatɨ, an akar isɨn zuibara me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Fomɨra Godɨn akam inigha izir gumazim kamagh mɨgɨa ghaze, “Kɨ akar isɨn zuibara ia mɨkɨmam. Bizir maba, nguazir kam otozir dughiamɨn da modogha iza datɨrɨghɨn tu, ezɨ kɨ bizir kabar eghaghanim damuasa.” Iesus akar kam damutɨ an otivasa, kamaghɨn an akar isɨn zuir kabagh ami. ");
INSERT INTO msy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Egha Iesus gumazamiziba ategha ghua dɨpenimɨn aven ghu. Ezɨ an suren gumaziba an gɨn iza ghaze, “Nɨ ogher kurabar akar isɨn zuimɨn mɨngarimɨn gun e mɨkɨmam, o?” ");
INSERT INTO msy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ezɨ Iesus me ikaragha kamaghɨn mɨgɨa ghaze, “Gumazir witɨn ovɨzir aghuiba akunizim, a Gumazibar Otarim. ");
INSERT INTO msy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Azenim, kar nguazir kam. Witɨn ovɨzir aghuiba, kar gumazamizir God Bizibagh Ativamin Dughiamɨn aven ikiamiba. Ogher kuraba, kar Satanɨn gumazamiziba. ");
INSERT INTO msy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Apanir ogher kuram akunizim, a Satan. Dagheba iniamin dughiam, kar nguazir kam gɨvamin dughiam. Ezɨ enselba, me dagheba iniamin ingangarir gumaziba. ");
INSERT INTO msy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Egha mati gumaziba ogher kuraba akuva dagh aboi, kamaghɨra enselba nguazir kam gɨvamin dughiamɨn, me kamaghɨn damuam. ");
INSERT INTO msy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gumazibar Otarim uan enselba amadaghtɨ, me God Bizibagh Ativamin Dughiamɨn aven itir gumazamiziba, men tongɨn itir gumazir arazir kurabagh amiba ko gumazir nɨghnɨzir gavgavibagh asɨghasɨziba, enselba bar me batuegham. ");
INSERT INTO msy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Egh me me isɨva, avir ekiam me kunigham. Eghtɨ me avir kamɨn ikɨva arangɨva atariba kuskugham. ");
INSERT INTO msy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Eghtɨ dughiar kamɨn gumazamizir aghuiba uan Afeziam Bizibagh Ativamin Nguibamɨn aven ikɨ, me aruemɨn mɨn sɨgham. Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Egha Iesus mɨgɨa ghua ghaze, “God Bizibagh Ativamin Dughiam mati, me bizir ivezir bar pɨn kozim isava azenimɨn nguazimɨn aven a modo. Ezɨ gumazir mam a bato, egha uam anevara. Egha bar akuegha, ghua uan biziba bar da amaga, dagɨaba inigha ghua, azenir kam itir nguazim givese.” ");
INSERT INTO msy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ezɨ Iesus mɨgɨa ghua ghaze, “God Bizibagh Ativamin Dughiam mati, dagɨar ingangarim gamir gumazir mam. Gumazir kam manmaniar bar aghuiba bagha ruiagha arui. ");
INSERT INTO msy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Egha ghua manmaniar bar aghuir ivezir bar pɨn kozir mam bato. Egha ghua uan biziba bar dagɨaba bagha da amada. Egha ghua manmaniar bar aghuir kam givese.” ");
INSERT INTO msy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Egha Iesus mɨgɨa ghua ghaze, “Akar isɨn zuir mam kamakɨn. God Bizibagh Ativamin Dughiam mati, me ivem akunizɨ a dɨpar averiamɨn ghuaghira, osirir guar avɨriba, dar akome. ");
INSERT INTO msy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ezɨ ivem izɨvazɨma, me a gekuigha dɨpar dadarim gatɨ. Egha me apiagha osirir aghuiba mɨsɨva da isava itaribav kɨri. Egha osirir kuraba me da makuri. ");
INSERT INTO msy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nguazir kam gɨvamin dughiam kamaghɨra. Enselba izɨva gumazir kuraba, gumazir aghuibar tongɨn me amɨsɨvam. ");
INSERT INTO msy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Egh me me isɨva, avir ekiamɨn me akunam. Eghtɨ me avir ekiar kamɨn ikɨ, arangɨva atariba kuskugham.” ");
INSERT INTO msy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Egha Iesus uan suren gumazibar azai, “Ia ti akar kamɨn mɨngarim gɨfo?” Ezɨ me ghaze, “Are.” ");
INSERT INTO msy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ezɨ a kamaghɨn me mɨgei, “Kamaghɨn amizɨ, gumazir manam Judan arazibagh fozir gumazimɨn ikia, egha gɨn God Bizibagh Ativamin Dughiamɨn akabar mɨngariba a dagh fo, egha a mati dɨpenir mamɨn ghuavimɨn mɨn ami. A uan dɨpenimɨn aven ghua bizir igiaba ko ghuriba bar da isava azenim garɨsi.” ");
INSERT INTO msy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iesus akar kaba akunigha gɨvagha danganir kam ategha ");
INSERT INTO msy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","uan nguibamɨn ghu. A ghua men God ko mɨgeir dɨpenimɨn aven ghugha, Godɨn akamɨn gumazamizibar sure gami. Ezɨ me an akam baragha dɨgavir kuram gami. Egha ghaze, “Gumazir kam managh fofozir kam ini? Egha a mirakelba manmaghɨn dagh ami? ");
INSERT INTO msy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E a gɨfo, a dɨpenibar ingarir gumazimɨn otarim, ezɨ Maria an amebam. Ezɨ Jems ko Josep ko Saimon ko Judas, me an doziba. ");
INSERT INTO msy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","An buaramiziba bar kagh e ko iti. Kamaghɨn a manmagh bizir kabanagh damutɨ, da otivam.” ");
INSERT INTO msy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Me kamagh mɨgɨa navir averiaba Iesusɨn ikufi. Ezɨ Iesus me mɨgɨa ghaze, “Godɨn akam inigha izir gumazim, nguibar igharazibar ziam otifi. Egha a uan nguibam ko uan dɨpenimɨn aven, a ziaba puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Me nɨghnɨzir gavgavim an itir puvatɨ, kamaghɨn amizɨ, a nguibar kamɨn mirakelɨn avɨribagh amizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","2","Dughiar kamɨn Galilin Distrighɨn Atrivim Herot, a Iesus amizir araziba baregha, kamaghɨn uan ingangarir gumazibav gei, “Gumazir kam ti, Gumaziba Ruer Gumazim Jon, an aremegha ua dɨkafi. Bizir kam bagha a mirakelbar amuamin gavgavim iti.” ");
INSERT INTO msy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herot fo, a faragha uan dozimɨn Filipɨn amuim Herodias inigha an iti. Ezɨ Jon bizir kam bagha Herot mɨgɨavɨra ikia ghaze, “Nɨ arazir kuram gamua uan dozimɨn amuim inigha an iti.” Ezɨ Herot bizir kam bagha Jonɨn suiragha a ikegha a isava kalabus gatɨ. ");
INSERT INTO msy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Egha a Jon mɨsueghtɨ an aremeghasava nɨghnɨsi. Egha a gumazamizibar atiatingi. A fo, me ghaze, Jon Godɨn akam inigha izir gumazim. ");
INSERT INTO msy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ezɨ aruer mamɨn gumazir maba iza Herotɨn gara, an amebam a batezir dughiam gɨnɨghnɨgha, a koma apa iti. Ezɨ Herodiasɨn guivim men guamɨn ighiam gami. Ezɨ Herot bar an ighiam bagha bar akonge. ");
INSERT INTO msy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Egha Herot overiam dafarim an akua kamaghɨn a mɨgei, “Bar guizbangɨra, nɨ bizitizim gifonge, kɨ a isɨva nɨ danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ezɨ Herodias nɨghnɨziba uan guivim ganɨngi, ezɨ guivim ghua kamaghɨn Herot mɨgei, “Nɨ Jon, Gumaziba Ruer Gumazimɨn dapanim isɨva itaritam dafagh a inigh izɨ na danɨngigh.” ");
INSERT INTO msy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Atrivim akar kam baregha bar oseme. Egha a fo, a uabɨ akar gavgavim gumazir a ko itibar damazimɨn a gamigha, bizir kamɨn aghumsɨzim inian aghua. Egha a mɨdorozir gumaziba akar gavgavim me ganɨngizɨma me guivim mɨkemezir moghɨn ami. ");
INSERT INTO msy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A gumazir mam amadazɨma, a ghua kalabusɨn mɨdorozir gumazibav geima, me Jonɨn fɨrim atu. ");
INSERT INTO msy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Egha Jonɨn dapanim itarir mam dafagha, guivim bagha a inigha iza a isava a ganɨngi. Ezɨ an a inigha ghua uan amebam ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ezɨ Jonɨn suren gumaziba iza an namnam inigha ghua anerefa. Me anerefagha egha ghua Iesus mɨkeme. ");
INSERT INTO msy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ezɨ Iesus orazi, me Jonɨn fɨrim atuzɨma an ovenge, ezɨma a nguibar kam ategha kurim inigha gumaziba itir puvatɨzir danganir mamɨn ghu. A uan suren gumaziba ko ghu. Ezɨ gumazamizir avɨrim orazima, a kagh ghu. Ezɨ me nguibar ekiam ategha, a buria uan suebar zui. ");
INSERT INTO msy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ezɨ Iesus ghua dɨpar dadarimɨn otogha garima, avɨrir bar dafam iti. Ezɨ a men apangkuva men areir gumazibar arɨmariaba agefi. ");
INSERT INTO msy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Aruem gevima, Iesusɨn suren gumaziba iza kamaghɨn a mɨgei, “Kar gumaziba itir puvatɨzir danganim, ezɨ amɨnim pɨrasava ami. Kamaghɨn nɨ gumazamiziba amadaghtɨ, me mangɨ nguibabar uari bagh daghebagh ivez.” ");
INSERT INTO msy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ezɨ Iesus uan suren gumaziba kamagh me mɨgei, “Me tizim bagh mangam? Ia uari daghetaba me danɨngigh.” ");
INSERT INTO msy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ezɨ me ghaze, “E dagher avɨriba itir puvatɨ. Kar 5 plan bretba ko osirir pumuningra.” ");
INSERT INTO msy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ezɨ a ghaze, “Ia bretɨn maba ko osirimning inigh izɨ.” ");
INSERT INTO msy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ezɨ Iesus gumazamizibav geima, me grazim gapia. Ezɨ a 5 plan bretba ko osirir pumuning inigha egha kogha overiamɨn gara Afeziam mɨnabi. Egha bretba bɨgha uan suren gumazibagh anɨngi. Ezɨ an suren gumaziba da isava gumazamizibagh anɨdi. ");
INSERT INTO msy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ezɨ gumazamizir kaba bar amegha, naviba bar izɨfa. Egha dagher naba itima, me da akuvagha 12 plan akɨrabagh aghui. ");
INSERT INTO msy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Gumazir amezibar dɨbobonim 5,000ɨn tu. Me amiziba ko boriba dɨponezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ezɨ Iesus uan suren gumaziba amaga me mɨgɨa ghaze, me faragh bot inigh dɨpamɨn vongɨn mangɨ. A uabɨ ikɨ gumazamiziba amadagham. ");
INSERT INTO msy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","A gumazamiziba amadagha, egha uabɨra ikia God ko mɨkɨmasa mɨghsɨamɨn ghuavanabo. Ezɨ amɨnim pɨrizɨma, Iesus uabɨra iti. ");
INSERT INTO msy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ezɨ bot dadarimɨn saghon ghuzɨma, amɨnim botɨn guamɨn dɨkavigha me gɨvaima ongarim men botɨn mɨsosi. ");
INSERT INTO msy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ezɨ amɨnim tiasasava amima, Iesus dɨpam gisɨn tugha uan suren gumaziba bagha zui. ");
INSERT INTO msy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Me garima, Iesus dɨpam gisɨn izima, me bar puv atiatiava agoi. Egha me ghaze, kar aser mam. Egha atiatiava arai. ");
INSERT INTO msy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ezɨ Iesus zuamɨra me mɨgɨa ghaze, “Ia gavgafigh, kar kɨrara. Ia atiatingan markɨ!” ");
INSERT INTO msy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ezɨ Pita an akam ikaragha kamaghɨn mɨgei, “Ekiam, guizbangɨra nɨrara, nɨ na mɨkemeghtɨ, kɨ dɨpam gisɨn nɨ bagh mangam.” ");
INSERT INTO msy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ezɨ Iesus ghaze, “Nɨ izɨ.” Ezɨ Pita bot ategha dɨpam gisɨn Iesus bagha zui. ");
INSERT INTO msy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","A ghua amɨnir gavgavimɨn gari, a bar ekevezɨma an atiatia dɨpamɨn aven ghuaghiri. Egha dei, “Ekiam, nɨ nan akuragh!” ");
INSERT INTO msy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ezɨ Iesus zuamɨra uan agharim amadagha Pitan suira. Egha kamaghɨn Pitan mɨgei, “Nɨn nɨghnɨzir gavgavim sufi. Nɨ tizim bagha okam nɨghnɨsi?” ");
INSERT INTO msy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Egha aning me gatɨn botɨn ghuavanabo, ezɨ amɨnim pura gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ezɨma botɨn itir gumaziba Iesusɨn ziam fa ghaze, “Bar guizbangɨra, nɨ Godɨn Otarim!” ");
INSERT INTO msy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ezɨ Iesus uan suren gumaziba ko dɨpamɨn vongɨn ghugha, ghua Genesaretɨn nguibamɨn otifi. ");
INSERT INTO msy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ezɨ kagh itir darazi Iesusɨn gara a gɨfo. Egha akam amadazɨ, a nguibar roghɨra itibar ghuzɨ, me arɨmariaba itir darazi bar me inigha Iesus bagha ize. ");
INSERT INTO msy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Egha me a gakaghora ghaze, a men asughtɨma, arɨmariaba itiba an korotiar avɨzibar suigham. Ezɨ gumazamizir an korotiam suiziba, men arɨmariaba gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dughiar kamɨn Farisin maba ko Judan arazibagh fozir gumazir maba Jerusalem ategha Iesus bagha ize. Egha me kamagh an azai, ");
INSERT INTO msy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Manmaghɨn amizɨ, nɨn suren gumaziba en ovaviba anɨngzir arazibar gɨn zuir puvatɨ? Egha me damasa uan dafariba ruer puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ezɨ Iesus men akam ikaragha kamagh me mɨgei, “Manmagh amigha ia Godɨn arazibar gɨn zuir puvatɨ, egha uan arazibar gɨn zui? ");
INSERT INTO msy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","E fo, God ghaze, ‘Ia uan afeziaba ko amebabar akaba baregh men apengan ikɨ’, egha ghaze, ‘Gumazitam akar kuratam uan afeziam ko amebam mɨkemeghtɨ, ia gumazir kam mɨsueghtɨ, an aremegh.’ ");
INSERT INTO msy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ezɨ ia kamaghɨn mɨgei, ‘Gumazitam uan amebam ko afeziamɨn akurvaghsɨ dagɨaba atɨgha, egha ua gɨn aningɨn akuraghan aghuagha, kamaghɨn aning mɨgei, “Kɨ guan akuraghasa atɨzir dagɨaba, gua markɨ. Kɨ da isɨ God danɨngam.” ’ A kamaghɨn mɨkɨmɨva, amebam ko afeziam gɨnɨghnɨgh deragh aningɨn akurvaghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ia kamaghɨn amuava, ian arazir kabar, ia Godɨn araziba ategha, uan ovavibar araziba faragha darɨsi. Egha Godɨn akam gamima, a mati pura bizim.” ");
INSERT INTO msy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ia uarira uarigh gifarir gumazibara! Godɨn akam inigha izezir gumazim Aisaia guizbangɨra ian arazibar gun kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Gumazamizir kaba, me uan akatoribar nan ziam fe, egha men naviba ko nɨghnɨziba bar saghon iti. ");
INSERT INTO msy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Me gumazibar akabar uari sure gamua uari gifara egha ghaze, kar Godɨn akam. Kamaghɨn amizɨ, me nan ziam guizbangɨra a fer puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Egha Iesus gumazamizibar diazɨma me a bagha izima a kamaghɨn me mɨgei, “Ia oragh, egh deragh nɨghnɨgh! ");
INSERT INTO msy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bizir gumazibar akatoribar ikegha ghuaghiriba, da me gamima, me Godɨn damazimɨn mɨzezir puvatɨ. Bizir navibar ikia akatoribar otiviba, da gumazibagh amima, me Godɨn damazimɨn mɨze.” ");
INSERT INTO msy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ezɨ gɨn an suren gumaziba iza kamaghɨn a mɨgɨa ghaze, “Nɨ ti kamaghɨn fos, Farisiba nɨ mɨkemezir mɨgɨrɨgɨam baregha men muriaba bar ikufi?” ");
INSERT INTO msy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ezɨ Iesus me ikaragha ghaze, “Nan afeziar uan Nguibamɨn itim, an azenim iti. Egha bizir a dɨkezir puvatɨziba, a biba sara da asiam. ");
INSERT INTO msy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ia gumazir kabagh nɨghnɨghan markɨ. Me damazir okavɨrɨziba, egha me tuavim isava gumazir igharazimɨn akakasi. Eghtɨ gumazir damazir okavɨrɨzim tuavim isava gumazir okavɨrɨzir mamɨn akakagh, egh aning vɨrara mangɨ mozimɨn magɨrɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ezɨ Pita Iesusɨn azai, “Nɨ gumazamiziba mɨkemezir akar isɨn zuimɨn mɨngarim e bagh anebightɨ, e a gɨfogham?” ");
INSERT INTO msy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ezɨ Iesus ghaze, “Manmagh ami, ia ti uaghan gumazir igharazibar mɨrara fozir puvatɨghavɨra iti.” ");
INSERT INTO msy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ia ti kamaghɨn fozir puvatɨ, bizir akatorimɨn aven zuiba ghua navimɨn zuima, muriam da batozima, ezɨ gumazim dagh avi. ");
INSERT INTO msy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ezɨ bizir akatoribar otiviba da nɨghnɨzimɨn ikegha ize. Egha da gumazibagh amima, me Godɨn damazimɨn mɨze. ");
INSERT INTO msy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kɨ gumazibar nɨghnɨzibar otivir bizir kabanagh mɨgei, nɨghnɨzir kuraba, ko gumaziba mɨsogharɨzir araziba, ko gumaziba ko amiziba tintinibar uari isava akuir araziba, ko poroghamiba uari bakeir araziba, ko okɨmakɨar araziba, ko kotiabar gumazibagh ifarir araziba, ko gumazibar ziabagh asɨghasɨzir araziba. ");
INSERT INTO msy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Arazir kaba gumazibagh amima, me Godɨn damazimɨn mɨze. Gumaziba dafariba ruer puvatɨgha api, arazir kam me gamima me Godɨn damazimɨn mɨzezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ezɨ Iesus nguibar kam ategha ghua nguibar ekiamning Taia ko Saidonɨn nguazimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ezɨ Kenanian amizir mam danganir kamɨn ikegha iza kamaghɨn dei, “Ekiam, nɨ Devitɨn Otarim, nɨ nan apangkuvigh! Duar kuram nan guivim gapazagha a gasɨghasɨsi.” ");
INSERT INTO msy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ezɨ Iesus mɨgɨrɨgɨatam a ikarvazir puvatɨ. Ezɨ an suren gumaziba a bagha iza a mɨgɨa ghaze, “Amizir kam dɨaghdiagha en gɨn izi. Nɨ anemadaghtɨ a mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ezɨ Iesus kamaghɨn me ikara, “God Israelbar akurvaghasavɨra na amada. Me sipsipba gumazir dar ganamiba puvatɨzɨ moghɨn iti.” ");
INSERT INTO msy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ezɨ amizir kam Iesusɨn boroghɨra iza, tevimning apɨrigha aviragha uan guam nguazim gatɨgha a mɨgɨa ghaze, “Ekiam, nɨ nan akuragh.” ");
INSERT INTO msy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ezɨ Iesus a ikaragha ghaze, “Kar arazir kuram, gumazimɨn boribar dagheba inigh afiabav kɨnam.” ");
INSERT INTO msy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ezɨ amizim ghaze, “Ekiam, nɨ guizbangɨra mɨgei. Ezɨ afiaba uaghan uan ghuavimɨn dakozimɨn apengan itir dagher muzemziariba api.” ");
INSERT INTO msy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ezɨ Iesus akar kam baregha kamagh amizim mɨgei, “Amizim, nɨn nɨghnɨzir gavgavim bar ekefe. Bizir nɨ bativasa nɨ ifongezim, a mar nɨ batif.” Ezɨma dughiar kamra an guivim ua dera. ");
INSERT INTO msy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ezɨ Iesus nguibar kam ategha Galilin dɨpar dadarimɨn zui. Egha ghua mɨghsɨar mamɨn anaboghava apera. Ezɨ avirir ekiam a bagha izi. ");
INSERT INTO msy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Egha suer kurabar ko, damazir okavɨrɨziba ko, soroghafarir ikɨzɨrɨziba ko, mɨgeir puvatɨziba ko, arɨmariar igharaziba uaghan, me da inigha iza Iesusɨn suemningɨn boroghɨn me arɨki. Ezɨ a bar men arɨmariaba batozima, me ua dera. ");
INSERT INTO msy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ezɨ gumazamiziba garima, mɨgeir puvatɨziba mɨgei, soroghafarir ikɨzɨrɨziba ua dera, suer kuraba uam arui, damazir okavɨrɨziba ua gari, ezɨ me nɨghnɨzir avɨribagh ami. Egha me Israelɨn Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ezɨ Iesus uan suren gumazibar diazɨ, me izima a kamaghɨn me mɨgei, “Gumazamizir kaba, me na ko aruer pumuning ko mɨkezimɨn ikia, egha dagheba puvatɨgha mɨtiriam men azi, kamaghɨn kɨ men apangkufi. Mɨtiriam men aghɨtɨ, kɨ me amangan aghua. Me mangɨ damaziba men isirtɨ, me tuavimɨn dagh iram.” ");
INSERT INTO msy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ezɨ an suren gumaziba a mɨgei, “Kar danganir gumaziba puvatɨzim. E managh bretɨn avɨriba inigh avɨrir ekiar kam danɨngam?” ");
INSERT INTO msy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ezɨ Iesus men azai, “Ia manmagh bretba iti?” Ezɨ me ghaze, “E 7 plan bretɨn rubuziba ko osirir dozir vaghvaziba iti.” ");
INSERT INTO msy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ezɨ Iesus gumazamizibav geima, me nguazim gapia. ");
INSERT INTO msy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ezɨ a 7 plan bretɨn rubuziba ko osiriba inigha God mɨnabagha da bɨaghsuegha da tuiragha uan suren gumazibagh anɨngi. Ezɨ suren gumaziba da isava gumazamizibagh anɨdi. ");
INSERT INTO msy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ezɨ me bar apa izɨfa. Ezɨ dagher naba itima, me da isava 7 plan akɨrabagh aghui. ");
INSERT INTO msy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Gumazir ameziba, men dɨbobonim 4,000ɨn tu. Me amiziba ko boriba dɨponezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ezɨ Iesus me amadazɨ, me zuima a bot inigha Magadan nguazimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ezɨ Farisiba ko Sadyusiba Iesus basamasa a bagha izi. Me iza ghaze, a mirakelɨn arazitam damightɨ, an otoghtɨ me kamaghɨn fogham, a guizbangɨra Godɨn ingangarim gami. ");
INSERT INTO msy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ezɨ a kamaghɨn men mɨgɨrɨgɨaba ikaragha ghaze, “Ia guaratɨzibar ghaze, overiam aghevezɨ, ezɨ gurumɨn dughiam deragham. ");
INSERT INTO msy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Egha mɨzarazibar ia ghaze, ghuariam korogha pɨzɨma, aruem aghevezɨ, ezɨ ia ghaze, amozim datɨrɨghɨn izɨtɨma, dughiam deraghan kogham. Guizbangɨra, ia overiamɨn otivir biziba deravɨra dagh fo. Egha ia dughiar kamɨn otivir arazibar gara da abɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gumazamizir dughiar kamɨn itiba, me bar gumazamizir kuraba! Egha me guizbangɨra God baghavɨra itir puvatɨ. Me zurara mirakelɨn tamɨn ganasa. Me tamɨn ganighan kogham. Puvatɨ. God mirakelɨn arazir vamɨra men akagham. Godɨn akam inigha izir gumazim Jona batozir mirakelɨn kamra, me an ganam.” Egha Iesus me ategha ghu. ");
INSERT INTO msy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ezɨ Iesus uan suren gumaziba ko ghua dɨpamɨn vongɨn otifi, egha gɨn gari, me bretɨn tam inian okɨnɨghnɨki. ");
INSERT INTO msy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ezɨ Iesus kamaghɨn me mɨgei, “Ia deragh uari bagh gan. Ia Farisiba ko Sadyusibar yis bagh deravɨra gan.” ");
INSERT INTO msy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ezɨ an suren gumaziba maghɨra uarira uariv gɨa ghaze, “E ti bretɨn tam inigha izezir puvatɨzɨ, ezɨ a kamaghɨn yisɨn bizimɨn e mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ezɨ Iesus me mɨgeir mɨgɨrɨgɨabagh fo, egha me mɨgɨa ghaze, “Ia gumazir nɨghnɨzir gavgavir muziariba itiba! Ia tizim bagha uarira uariv gɨa ghaze, e bretba puvatɨ? ");
INSERT INTO msy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ia ti fozir puvatɨ? Ia ti okɨnɨghnɨki, kɨ bretɨn 5 pla inigha gumazir 5,000 pla dagheba me ganɨngi. Me amezɨ, ezɨ ia akɨraba manmaghɨn dagh aghui, ia dagh nɨghnɨsi, o puvatɨ? ");
INSERT INTO msy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Egha ia ti fo, kɨ bretɨn 7 pla inigha gumazir 4,000 pla dagheba me ganɨngi. Ezɨ gɨn men dagher naba itima, ia akɨraba manmaghɨn dagh aghui? ");
INSERT INTO msy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ia manmaghɨn amigha bizir kam gɨfozir puvatɨ, kɨ bretbagh nɨghnɨgha ia mɨgeir puvatɨ? Kɨ ghaze, ia Farisiba ko Sadyusibar yis bagh deragh uari bagh gan.” ");
INSERT INTO msy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ezɨ me akar kam baregha fo, Iesus bret bagha amir yisɨn mɨgeir puvatɨ. Me fo, a Farisiba ko Sadyusiba sure gamir akabagh nɨghnɨgha, egha ghaze, ia akar kaba bagh deravɨra uari bagh gan. ");
INSERT INTO msy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ezɨ Iesus ghua Sisaria Filipain nguibamɨn boroghɨn itir danganimɨn ghu, egha dughiar kamɨn uan suren gumazibar azai, “Gumazamiziba manmaghɨn mɨgei, Gumazibar Otarim a tina?” ");
INSERT INTO msy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ezɨ me ghaze, “Marazi ghaze, nɨ Jon Gumaziba Ruer Gumazim, marazi ghaze nɨ Elaija, marazi ghaze nɨ Jeremaia, o nɨ ti Godɨn akam inigha izir gumazir mam.” ");
INSERT INTO msy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ezɨ Iesus men azai, “Ezɨ ia uari, ia manmaghɨn na dɨponam? Kɨ tina?” ");
INSERT INTO msy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ezɨ Saimon Pita a ikaragha ghaze, “Nɨ Krais, God Ua E Iniasa Mɨsevezir Gumazim. Nɨ Godɨn zurara ikiavɨra itimɨn Otarim.” ");
INSERT INTO msy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ezɨ Iesus a ikaragha kamaghɨn a mɨgɨa ghaze, “Saimon, Jonɨn otarim, nguazimɨn gumazitam mɨgɨrɨgɨar kam nɨn akazir pu. Puvatɨ. Nan Afeziar uan Nguibamɨn itimra, nɨn aka. Kamaghɨn nɨ bar akongegh. ");
INSERT INTO msy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ezɨ kɨ nɨ mɨgei, nɨ Pita. Egh dagɨar kam gisɨn kɨ uan siosɨn ingaram, eghtɨ Ovevemɨn Gavgavim an suiragh anepɨrighɨva a gasɨghasighan kogham. ");
INSERT INTO msy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eghtɨ kɨ God Bizibagh Ativamin Dughiamɨn kiba isɨva nɨn dafarim datɨgham. Eghtɨ bizir manam nɨ nguazimɨn a ikeghtɨ, eghtɨ God uan Nguibamɨn uaghan a ikegham. Eghtɨ nɨ nguazimɨn bizir manam a fɨrightɨ, eghtɨ God uan Nguibamɨn uaghan kamaghɨra a fɨrigham. ");
INSERT INTO msy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Egha Iesus pamten uan suren gumaziba anogorogha ghaze, me tong an gun tav mɨkɨm suam, a Gumazir God Uam E Iniasa Mɨsevezim.” ");
INSERT INTO msy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ezɨ dughiar kamɨn ikegha ghua, Iesus uan suren gumaziba bighavɨra me mɨgɨa ghaze, a Jerusalemɨn mangam, eghtɨ gumazir aruaba, ko ofa gamir gumazir ekiaba, koma Judabar arazibagh fozir gumaziba, a men dafarimɨn bar mɨzazir ekiaba koma osɨmtɨziba iniam. Eghtɨ me an aghuaghɨva a mɨsueghtɨma an aremegham. Egh dughiar mɨkezimɨn a ua dɨkavigham. ");
INSERT INTO msy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ezɨ Pita akar kam baregha Iesus inigha mɨriamɨn ghua kamaghɨn an atara a mɨgɨa ghaze, “Bar puvɨratɨgham. Arazir kaba nɨ bativan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ezɨ Iesus raghrɨgha kamaghɨn Pita mɨgei, “Satan, nɨ na gitagh! Nɨ nguazimɨn bizibagh nɨghnɨgha egha Godɨn bizibagh nɨghnɨzir puvatɨ, kamaghɨn nɨ nan tuavim apɨri.” ");
INSERT INTO msy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Egha Iesus kamaghɨn uan suren gumazibav gei, “Gumazitam nan gɨn izɨsɨ, a ifongezir biziba gɨn amadagh uan temer ighuvim gisaghpugh nan gɨn izɨ. ");
INSERT INTO msy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gumazir manam uan ikɨrɨmɨrim suiraghsɨ nɨghnɨghtɨ, an ikɨrɨmɨrim gɨvagham. Eghtɨ gumazir manam na bagh uan ikɨrɨmɨrim ateghɨva, uan ikɨrɨmɨrim iniam. ");
INSERT INTO msy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gumazitam nguazimɨn itir biziba bar da iniva, egh a gɨn oveghtɨ, bizir kaba manmaghɨn an akuragham? Bar puvatɨ. A ivezir manamɨn uan duam bagh anerenɨngam? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Guizbangɨra, Gumazibar Otarim uan enselba ko, uan Afeziamɨn angazangarir ekiam sara izam. Egh dughiar kamɨn ivezim isɨ gumazamiziba vaghvagh men araziba bagh me danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kɨ guizbangɨra ia mɨgei, ia kagh tuivighav itir darasi, ian tarazi oveghan kogham. Ia ikɨvɨra ikɨ gantɨma, Gumazibar Otarim, Atrivir Ekiamɨn mɨn otogh ua izam.” ");
INSERT INTO msy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ezɨ 6 plan arueba gɨvazɨma, Iesus Pita koma Jems uan dozim Jon, ko a me inigha, me mɨghsɨar ekiar mamɨn anabo, egha me uarira iti. ");
INSERT INTO msy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Egha me garavɨra itima, Iesusɨn mɨkarzim igharagha oto. Ezɨ an guam mati aruem a gisira, ezɨ an korotiaba ghurghurigha angazangarir mamɨn mɨn sira. ");
INSERT INTO msy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ezɨ Moses ko Elaija otogha Iesus ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ezɨ Pita kamaghɨn gara, egha Iesus mɨgɨa ghaze, “Ekiam, bar deragha e kagh iti! Nɨ ifueghtɨma, kɨ averpenir pumuning ko mɨkezimɨn ingaram. Nɨ bagh tam, Moses bagh tam, egh Elaija bagh tam.” ");
INSERT INTO msy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita mɨgɨavɨra itima, ghuariam angazangarimɨn mɨn isiragha me avara. Ezɨ ghuariar kamɨn aven me tiarir mam barazima a kamaghɨn mɨgei, “Kar nan Otarir kɨ bar ifongezim. Ia anarɨram oragh!” ");
INSERT INTO msy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Me kamaghɨn oragha, egha me bar puv atiatigha tevibar pɨrigha uan guaba nguazimɨn akuigha ireghav iti. ");
INSERT INTO msy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ezɨ Iesus me bagha iza men suigha kamaghɨn me mɨgei, “Ia dɨkafigh atiatingan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ezɨ me dɨkavigha ua tavɨn garir puvatɨ, Iesus uabɨra iti. ");
INSERT INTO msy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Egha me mɨghsɨam ategha ghuaghira a me mɨgɨa ghaze, “Ia irebamɨn mɨn ganizir bizim, bar an gun tav mɨkɨman markɨ. Egh ikɨ mangɨ Gumazibar Otarim ovegh ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Egha me an azai, “Manmagh sua Judan arazibagh fozir gumaziba ghaze, Elaija faragh izeghtɨ, God Ua e Iniasa Mɨsevezir Gumazim gɨn izam?” ");
INSERT INTO msy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ezɨ a me ikaragha ghaze, “Guizbangɨra Elaija faragh izeghɨva bizibar kɨram. ");
INSERT INTO msy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ezɨ kɨ ia mɨgei, Elaija izegha gɨfa. Ezɨ gumaziba a gɨfozir puvatɨ, egha uan nɨghnɨzibar gɨn ghua arazir kurabar a gami. Egh me kamaghɨra Gumazibar Otarim arazir kurabar a damutɨ, a mɨzazir kuram iniam.” ");
INSERT INTO msy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iesus kamagh mɨgeima me fo, a Jon Gumaziba Ruer gumazimɨn gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ezɨ Iesus uan suren gumazir pumuning ko mɨkezim inigha ghua gumazamizir avɨrir ekiam bato. Ezɨ gumazir mam iza Iesusɨn boroghɨn tevimning apɨrigha egha ghaze, ");
INSERT INTO msy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ekiam, nɨ nan otarimɨn apangkufigh. An dapanim abanganizɨ, a bar pazavɨra iti. Egha dughiar avɨriba an aviba ko dɨpabar ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kɨ a inigha nɨn suren gumazir maba bagha izezɨma me anekɨran ibura.” ");
INSERT INTO msy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ezɨ Iesus an akam ikaragha kamaghɨn mɨgei, “Oio, kɨ bar amɨra, ia dughiar kamɨn itir gumazamiziba, ian nɨghnɨzir gavgaviba puvatɨ, ian araziba koma nɨghnɨziba bar derazir puvatɨ. Kɨ dughiabar manmaghɨn ia ko ikiava egha ian osɨmtɨziba ateri? Nɨ uan otarim inigh kagh izɨ.” ");
INSERT INTO msy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ezɨ Iesus duar kuram batoghezɨ, duar kuram otarim ataghizɨma, an arɨmariam maghɨra gɨfa. ");
INSERT INTO msy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ezɨ Iesusɨn suren gumazibara gɨn iza kamaghɨn an azai, “Manmagh amizɨ, e duar kurar kam batoghava avenge?” ");
INSERT INTO msy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ezɨ a me mɨgɨa ghaze, “Ian nɨghnɨzir gavgavim bar sufi, ezɨ ia a batoghan ibura. Kɨ guizbangɨra ia mɨgei, ian nɨghnɨzir gavgavim zuravarim mastetɨn ovɨzitamɨn mɨn ikɨva, ia mɨghsɨar kam mɨkɨm suam, nɨ sɨvagh munagh mangɨ, eghtɨ a mangam. Ia nɨghnɨzir gavgavim ikɨ, ia guizbangɨra biziba bar dar amuam.” ");
INSERT INTO msy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ezɨ Iesus uan suren gumaziba ko ghua Galilin uari akuvaghava kamaghɨn me mɨgei, “Me Gumazibar Otarim isɨva gumazibar agharim datɨgham. ");
INSERT INTO msy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Eghtɨ me a mɨsueghtɨ an aremeghɨva, egh dughiar mɨkezimɨn a ua dɨkavigham.” Ezɨ an suren gumaziba akar kam baregha, naviba bar oseme. ");
INSERT INTO msy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ezɨ Iesus gɨn uan suren gumaziba ko ghua nguibar ekiam Kaperneamɨn otivigha itima, Godɨn Dɨpenimɨn takis isir gumaziba, Pita bagha iza kamaghɨn an azai, “Ian tisa ti uaghan Godɨn Dɨpenimɨn takis anɨdi, o?” ");
INSERT INTO msy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ezɨ Pita ghaze, “Are.” Egha dɨpenimɨn aven zuima, Iesus maghɨra an azai, “Saimon, nɨ manmaghɨn nɨghnɨsi? Nguazir kamɨn atriviba takisɨn avɨriba isa, egha me te da, takisba isi? Me uan adarazi da takisba isi, o me Kantrin igharazibar gumaziba da takisba isi?” ");
INSERT INTO msy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ezɨ Pita ghaze, “Me gumazir igharaziba da takisba isi.” Ezɨ Iesus a mɨgɨa ghaze, “Kamaghɨn amizɨma, men adarazi uari takisbar anɨngan kogham. ");
INSERT INTO msy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Eghtɨ me en ataran koghsɨva, nɨ mangɨ dɨpamɨn akezim akun. Egh osirir nɨ faraghvɨra guraghamim, a inigh an akam akarigh, egh dagɨatamɨn gantɨma a ikiam. Egh nɨ dagɨar kam inigh, egh ga uaning bagh a isɨva me danɨngigh.” ");
INSERT INTO msy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dughiar kamɨn Iesusɨn suren gumaziba iza kamaghɨn an azai, “Tina God Bizibagh Ativamin Dughiamɨn ziar ekiam iniam?” ");
INSERT INTO msy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ezɨ Iesus borir mamɨn dia, ezɨ a izima a men tongɨn anesara. ");
INSERT INTO msy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Egha a kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, ia uari gɨragh borir dozir kabar mɨn otoghan kogh, egh ia God Bizibagh Ativamin Dughiamɨn aven ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gumazir uabɨ dɨkabɨragha, egha borir dozir kamɨn mɨn itim, gumazir kam God Bizibagh Ativamin Dughiamɨn ziar ekiam ikiam. ");
INSERT INTO msy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Egh gumazitam na gɨnɨghnɨgh egh borir dozir kamagh garitam inigh an akuragham, kamaghɨn a na inigha nan akurvasi.” ");
INSERT INTO msy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ezɨ Iesus mɨgɨa ghua ghaze, “Tina nɨghnɨzir gavgavim nan itir borir katam damightɨ an arazir kuratam damightɨ, a helɨn mangɨva, a bar ivezir kuram inigham. Kamaghɨn dera, me dagɨar ekiam an fɨrim dafaghɨva ongarir konim mɨkɨnightɨ an aremegham. ");
INSERT INTO msy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Kɨ ghaze, gumazir nguazimɨn ikiava igharaz darazigh amima me arazir kurabagh amiba, mevzika! Me kuram iniam! Arazir kuraba guizbangɨra otifi, ezɨ arazir kurabagh amima da otivir gumazim, kɨ ghaze, Noka! Nɨ kuram iniam! ");
INSERT INTO msy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Eghtɨ nɨn dafarim o suem nɨ damutɨ, nɨ arazir kuratam damighɨva, anetugh a makunigh. Kamaghɨn dera, nɨ dafarir vamɨra ko suer vamɨra ikɨva zurara itir ikɨrɨmɨrir aghuimɨn aven mangam. Nɨ dafarir pumuning o suer pumuning ikɨtɨ me nɨ isɨva avir munger puvatɨzim mɨkɨnigham. ");
INSERT INTO msy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Egh nɨn damazim nɨ damutɨ nɨ arazir kuratam damighɨva, anesigh a makunigh. Kamaghɨn dera, nɨ damazir vamɨra ikɨ egh uaghan zurara itir ikɨrɨmɨrir aghuimɨn aven mangam. Nɨ damazir pumuning ikɨtɨma me nɨ isɨva helɨn avim mɨkɨnigham. ");
INSERT INTO msy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Ia deragh uari bagh gan! Ia borir dozir kabar tongɨn tav gɨnighnigh kamaghɨn mɨkɨman markɨ, a pura bizim. Puvatɨ. Kɨ ia mɨgei, men enselba zurara nan Afeziar uan Nguibamɨn itimɨn damazimɨn iti.” ");
INSERT INTO msy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ezɨ Iesus mɨgɨa ghua ghaze, “Ia manmaghɨn nɨghnɨsi? Gumazitam 100 plan sipsipba ikiam, eghtɨ vamɨra oveghtɨ, a ti manmaghɨn damuam? A ti a burian kogham, o? Puvatɨ. A 99 plan sipsipba mɨghsɨamɨn da ategh egh mangɨ ovengezir kam buriam. ");
INSERT INTO msy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kɨ guizbangɨra ia mɨgei, an a batogh egh bar akuegham. Egh an agoroger ekiar kam, an agoroger 99 plan ovengezir puvatɨzir kaba bagha itim, bar a gafiragham. ");
INSERT INTO msy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kamaghɨra ian Afeziar uan Nguibamɨn itim, borir katam ovengan an aghua.” ");
INSERT INTO msy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Egha Iesus mɨgɨa ghua ghaze, “Nɨn aveghbuam arazir kuram nɨ damightɨma, nɨ an bighan mangɨ egh gua uaningra ikɨva nɨ a ko gua bizir kam anekɨrigh. A nɨ baragham, eghtɨ nɨ ua uan aveghbuam inigham. ");
INSERT INTO msy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Eghtɨ a nɨ baraghan aghuagham, nɨ mangɨ gumazir igharazir mam, o gumazir igharazir pumuning, uam me inigh. Eghtɨ me nɨn gɨn mangɨ. E fo, Godɨn Akɨnafarim kamaghɨn mɨgei, ‘Nɨ gumazitamɨn arazir kuram an gun a mɨkɨmasa, gumazir pumuning ko mɨkezim gavgavim nɨn mɨgɨrɨgɨabar anɨngam.’ ");
INSERT INTO msy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Egh gumazir nɨ mɨgeir kam uaghan men akam baraghan aghuaghtɨma, nɨ an arazibar gun Siosɨn adarazi mɨkɨmam. Eghtɨ a uaghan me baraghan aghuaghtɨma, nɨ God gɨfozir puvatɨzir gumazim o dagɨaba isir gumazimɨn mɨn a damu. ");
INSERT INTO msy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ki guizbangɨra ia mɨgei, bizir manam ia nguazimɨn a ikeghtɨ, eghtɨ God uan Nguibamɨn uaghan a ikegham. Eghtɨ ia nguazimɨn bizir manam a fɨrightɨ, eghtɨ God uan Nguibamɨn uaghan kamaghɨra a fɨrigham. ");
INSERT INTO msy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Egha kɨ ua ia mɨgei, gua taning kagh nguazimɨn bizitam bagh nɨghnɨzir vamɨra ikia a iniasa a bagha God ko mɨgei, nan Afeziar uan Nguibamɨn itim a isɨva gua danɨngam. ");
INSERT INTO msy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Egh gumazir pumuning, o pumuning ko mɨkezim nan ziam uari akuvagh ikɨtɨ, kɨ uabɨ men tongɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ezɨ dughiar kamɨn Pita iza kamagh Iesusɨn azai, “Ekiam, kɨ manmaghɨn dughiabar arazir kurabar na gamizir gumazimɨn araziba gɨn amangam. Ti 7 plan dughiaba?” ");
INSERT INTO msy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ 7 plan dughiabar an arazir kuraba gɨn amanagasa nɨ mɨgeir puvatɨ. Nɨ zurazurara an arazir kuraba gɨn amang. ");
INSERT INTO msy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ia oragh. God Bizibagh Ativamin Dughiam mati, atrivir mam ko an ingangarir gumazibar eghaghanim. Atrivim uan dagɨaba isa uan ingangarir gumazibar dafarim gatɨgha ghaze, me gɨn ua da ikarvagham. Dughiar mam atrivim me a ikarvaghamin bizim akɨrasa. ");
INSERT INTO msy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","An adar kɨrir dughiam, me gumazir atrivim da 10 milien Kina inizimɨn akua izi. ");
INSERT INTO msy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ezɨ a dagɨar inizir kabar ikarvaghan ibura. Kamaghɨn atrivim me mɨgɨa ghaze, me gumazir kam inigh an amuiroghboriba sara dagɨaba bagh me amadagh, egh men ivezim inigh. Egh me ateghtɨ me gumazir igharazimɨn ingangarir gumazir kɨnibar mɨn ikɨ. Egh an biziba bar da amadagh, dagɨaba inigh egh a na da inizir biziba ikaragham. ");
INSERT INTO msy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ezɨ ingangarir gumazir kam kamaghɨn oragha atrivimɨn guamɨn irɨgha kamagh mɨgɨa a gakaghori, ‘Nɨ nan apangkuvigh, egh na mɨzuam. Eghtɨ kɨ nɨ da inizir biziba bar da ikarvagham.’ ");
INSERT INTO msy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ezɨ atrivim an apangkuvigha, a inizir biziba uaghan da gɨn amada. ");
INSERT INTO msy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ezɨ ingangarir gumazir kam atrivimɨn dɨpenim ategha ghua a ko ingaritav bato. A ko ingarir gumazir kam, faragha a da 10 Kina inigha a ikarazir puvatɨ. Ezɨ gumazir atrivim ko ikegha izir kam, maghɨrama an fɨrmɨn suigha anegoava kamaghɨn a mɨgei, ‘Nɨ na da inizir dagɨaba bar da ikaragh.’ ");
INSERT INTO msy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ezɨ gumazir kam an guamɨn irɨgha a gakaghora ghaze, ‘Nɨ nan apangkufigh, egh na mɨzuam. Eghtɨ kɨ nɨ da inizir biziba ua da ikarvagham.’ ");
INSERT INTO msy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ezɨ gumazir kam a baraghan aghua, egha a inigha ghua kalabus gatɨ, eghtɨ a ikɨ mangɨ dagɨar kaba ikaragham. ");
INSERT INTO msy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Ezɨ aning ko ingarir marazi, arazir kamɨn ganigha men naviba bar men ikufi. Egha me ghua atrivim batogha gumazir kam, a ko ingarir gumazim gamizir arazibar gun a mɨkeme. ");
INSERT INTO msy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ezɨ atrivim gumazir kamɨn diazɨma, a uam a bagha ghu. Ezɨ a kamaghɨn a mɨgɨa ghaze, ‘Nɨ bar ingangarir gumazir kuram! Nɨ faragha na gamuava araima, kɨ dagɨar nɨ iniziba bar da gɨn amada. ");
INSERT INTO msy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Kɨ nɨn apangkufi, kamaghɨn amizɨma, nɨ tizim bagha nɨ ko ingarir tavɨn apangkuvan aghua?’ ");
INSERT INTO msy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Egha atrivim atarava gumazir kam isava, mɨzaziba agasamin gumazibar dafarim gatɨ. Eghtɨ a kaghɨra ikɨ mangɨ, a biziba bar da ikarvaghamin dughiamɨn tugham. ");
INSERT INTO msy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Eghtɨ ia uan aveghbuabar arazir kurar me ia gamiba, ia guizbangɨra uan navir averiabar aven, da gɨn amangan koghtɨma, nan Afeziar uan Nguibamɨn itim uaghan kamaghɨra ia damuam.” ");
INSERT INTO msy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iesus mɨgɨrɨgɨar kaba a gɨvagha, egha Galilin Distrigh ataki, egha Judian Distrighɨn ghua Jordan dɨpamɨn vongɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ezɨ gumazamizir avɨrim an gɨn zui, ezɨ a danganir kamɨn men arɨmariaba agɨfa. ");
INSERT INTO msy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ezɨ Farisiba Iesus basamasa iza kamaghɨn an azai, “Nɨ manmaghɨn nɨghnɨsi? Gumazim uan ifongiamɨn gɨn ghua uan amuim puram anetaghraghɨsɨ damutɨ, Judan Araziba ti an amamangatɨgham, o ti puvatɨgham?” ");
INSERT INTO msy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ezɨ Iesus me ikaragha kamaghɨn men azai, “Ia ti Godɨn mɨgɨrɨgɨaba itir Akɨnafarimɨn ganizir puvatɨ? Akar kam ghaze, ‘God faraghavɨra bizibar ingara, gumazamizibar ingari egha me gamizɨ, me gumazim ko amizimɨn oto.’ ");
INSERT INTO msy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ezɨ God ghaze, ‘Kamaghɨn amizɨma, gumazim uan afeziam ko amebam ateghɨva a uan amuim ko aning uaningɨn porogham. Egh aning nivafɨzir vamɨram otogham.’ ");
INSERT INTO msy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","God kamaghɨn mɨkemezɨma, aning ua gumazir pumuning puvatɨ. Aning nivafɨzir vamɨra ikiam. Kamaghɨn amizɨma, God bizir pumuning isafuraghtɨma, gumazitam aning abighan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ezɨ Farisiba kamaghɨn a mɨgei, “Manmaghɨn amizɨma, Moses osira ghaze, gumazim amuim ataghraghsɨva, a bagh akɨnafarim osirigh a danɨngigh, egh amuim batueghtɨma a mangɨ?” ");
INSERT INTO msy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ezɨ Iesus kamaghɨn me mɨgɨa ghaze, “Ia gumazir akaba barazir puvatɨziba. Kamaghɨn amizɨma, Moses ian amamangatɨzɨma, ia uan amuiba ataghrasi. Faraghavɨra arazir kam puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ezɨ kɨ kamaghɨn ia mɨgei, gumazitamɨn amuim, a gumazir igharaziba tintinibar me isava akuir arazitam damighan koghtɨma, eghtɨ an a batuegh egh amizir igharazitam inigh an ikiam, gumazir kam poroghamiba uari bakeir arazim gami.” ");
INSERT INTO msy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ezɨ Iesusɨn suren gumaziba akar kam baregha egha kamaghɨn Iesus mɨgei, “Arazir kabanagh poroghamibar tongɨn ikɨtɨma, gumaziba amibar ikian markiam.” ");
INSERT INTO msy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ezɨ Iesus kamaghɨn me mɨgei, “Gumaziba ko amiziba bar akar kam inian kogham. Puvatɨ, God gavgavir kam isava gumazir vabaram anɨngi. Kamaghɨn me amuibar ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Guizbangɨra, marazi amebaba me batima, men nivafɨziba ikufi. Marazi, me me aghori, eghtɨ me boriba inian kogham. Marazi God Bizibagh Ativamin Dughiam gɨnɨghnɨgha amuiba ko pabar ikian aghua. Tina akar kam inisɨva a mar a ini.” ");
INSERT INTO msy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ezɨ dughiar kamɨn gumazamiziba boriba inigha Iesus bagha zui. Me ghaze, a dafarim me darɨgh egh me bagh God ko mɨkɨmam. Ezɨ an suren gumaziba, gumazamizir boriba isa izibar atari. ");
INSERT INTO msy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ezɨ Iesus kamaghɨn me mɨgei, “Nɨ tina God Bizibagh Ativamin Dughiamɨn aven ikɨsɨ, borir dozir kabar mɨn ikɨ. Kamaghɨn amizɨma borir doziba ateghtɨma, me na bagh izɨ, egh men anogoroghan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Egha Iesus dafarimning boribagh isɨn arigha, egha danganir kam ategha ghu. ");
INSERT INTO msy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ezɨ gumazir mam iza kamagh Iesusɨn azai, “Tisa, kɨ manmaghɨn damigh zurara itir ikɨrɨmɨrir aghuarim iniam?” ");
INSERT INTO msy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Nɨ tizim bagha arazir aghuiba bagha nan azai? Gumazir vamɨra, a dera. Egh nɨ zurara itir ikɨrɨmɨrir aghuim inisɨva, Godɨn akabar gɨn mangɨ” ");
INSERT INTO msy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ezɨ gumazir kam kamaghɨn Iesusɨn aza ghaze, “Nɨ Godɨn akar gavgavir manabav gei?” Ezɨ Iesus ghaze, “Ia gumazitam mɨsueghtɨ an aremeghan markɨ, ia poroghamiba uari bakeir arazim damuan markɨ, ia okɨman markɨ, egh ia pura gumazibagh ifarɨva, me isɨ kotiam darɨghan markɨ, ");
INSERT INTO msy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","egh ia uan amebaba ko afeziabar apengan ikɨ egh me baragh, egh ia uari gɨfongezɨ moghɨn gumazir igharazibagh ifonge.” ");
INSERT INTO msy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ezɨ gumazir igiar kam kamaghɨn Iesus mɨgei, “Akar kabanagh, kɨ bar dar gɨn zui. Kɨ ua tizim damuam?” ");
INSERT INTO msy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Nɨ bar deragh otivan ifueghɨva, egh mangɨ uan biziba bar da amadagh. Egh dar dagɨaba inigh egh da isɨva gumaziba ko amizir biziba puvatɨzibar anɨngigh. Nɨ kamaghɨn damigh, bizir bar aghuiba nɨ bagh Godɨn Nguibamɨn ikiam. Egh nɨ nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gumazir igiar kam, a bizir bar avɨriba ikia, kamaghɨn oregha navim bar an osemezɨ, a ghu. ");
INSERT INTO msy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ezɨ Iesus kamaghɨn uan suren gumazibav gei, “Bar guizbangɨra kɨ ia mɨgei, gumazir dagɨar avɨriba itiba, God Bizibagh Ativamin Dughiamɨn aven mangan iburagham. ");
INSERT INTO msy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Egha kɨ ua ia mɨgei, kamelɨn tam iniba isair dɨkonir torimɨn aven mangɨsɨ ingangarir dafam damigh aven mangam. Eghtɨ gumazir biziba avɨrasemeziba, me God Bizibagh Ativamin Dughiamɨn mangɨsɨ guizbangɨra bar iburagham!” ");
INSERT INTO msy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ezɨ an suren gumaziba akar kam baregha dɨgavir kuram gamigha ghaze, “Kamaghɨn damightɨma, tinara zurara itir ikɨrɨmɨrir aghuir kam iniam?” ");
INSERT INTO msy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ezɨ Iesus damazim meraram asaragha ghaze, “Bizir kaba gumazimɨn bar osemegham. Bizir kaba Godɨn osemezir puvatɨ. A biziba bar dagh ami.” ");
INSERT INTO msy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A kamagh mɨkemezɨ, Pita an akam ikaragha ghaze, “Nɨ ge, e uan biziba bar da ategha, nɨn gɨn ize. E tizitam iniam?” ");
INSERT INTO msy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ezɨ Iesus kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, God nguazim ko overiar igiam akɨramin dughiamɨn Gumazibar Otarim ziar bar ekiam iniam, egh atrivir dabirabim daperagham. Eghtɨ ia nan gɨn aruizir darazi, ia uaghan 12 plan atrivir dabirabibar dapiagh Israelian anabar 12 plan ganam. ");
INSERT INTO msy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Eghtɨ tina nan ziam bagh nɨghnɨgh, uan dɨpeniba ko aveghbuaba ko amiziba ko afeziam ko amebam ko boriba ko nguazim, da ateghtɨ, God gumazir kam ivezir bar aghuim a danɨngam. Ivezir kam, a nguazir kamɨn itir bizir kaba bar dagh afiragham. Eghtɨ a uaghan zurara itir ikɨrɨmɨrir aghuimɨn aven ikiam. ");
INSERT INTO msy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Eghtɨ dughiar kamɨn faragha itir darazi, me gɨn ikɨtɨma, eghtɨ gɨn itir darazi me faragh ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Egha Iesus ua kamaghɨn mɨgɨa ghaze, “Kɨ gumaziba faragh faragh ikiasa mɨgeir nɨghnɨzim kɨ kamaghɨn a mɨkɨmasa. God Bizibagh Ativamin Dughiam mati, gumazir mam wainɨn azenir ekiam iti. Egha a mɨzarazimra ghua wainɨn azenimɨn ingarasa ingangarir gumazir maba ini. ");
INSERT INTO msy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ezɨ gumazir kaba a ko akam akɨri, egha wan kina wan kina aruer vamɨra iniasa ifonge, ezɨ gumazir ekiam me amadazɨ me an wainɨn azenimɨn ingarasa ghue. ");
INSERT INTO msy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ezɨ gumazir ekiar kam 9 klok kamaghɨn ghua biziba amadir danganimɨn gumazir mabar gari, me iti. ");
INSERT INTO msy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ezɨ a kamaghɨn me mɨgei, ‘Ia uaghan mangɨ nan wainɨn azenimɨn ingar, eghtɨ kɨ ian ingangarimɨn mɨrara ia gɨvezam.’ ");
INSERT INTO msy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ezɨ me ingarasa ghue. Ezɨ gumazir ekiar kam 12 klok ko 3 kloghɨn ghua arazir kamram amua ua gumazir maba ini. ");
INSERT INTO msy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Egha 5 klok ko kamaghɨn ghua ua gumazir mabar gari, me pura tuivighav iti. Ezɨ a kamaghɨn men azai, ‘Ia manmaghɨn amigha aruer kamɨn pura iti.’ Ezɨ me a mɨgɨa ghaze, ");
INSERT INTO msy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Tav ingangaritam e ganɨngizir puvatɨ.’ Ezɨ gumazir ekiam me mɨgɨa ghaze, ‘Ia uaghan mangɨ nan wainɨn azenimɨn ingar.’ ");
INSERT INTO msy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ezɨ aruem gɨvazɨma gumazir ekiam uan ingangarir gumazibar garir gumazim kamaghɨn a mɨgɨa ghaze, ‘Nɨ ingangarir gumazibar diagh men ivezim me danɨng. Egh nɨ gumazir bar gɨn izezibar ikegh ivezim me danɨng, mangɨ faragha izezibar gɨfagh.’ ");
INSERT INTO msy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ezɨ gumazir 5 kloghɨn izeziba iza wan kina, wan kina isi. ");
INSERT INTO msy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ezɨ gɨn gumazir faraghavɨra ingariba iza nɨghnɨgha ghaze, me ti dagɨar ekiatam iniam. Puvatɨ, me uaghan wan kina wan kina ini. ");
INSERT INTO msy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Egha me dagɨar me inizibar gara wainɨn azenimɨn ghuavimɨn atara kamaghɨn a mɨgɨa ghaze, ");
INSERT INTO msy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Gumazir kaba bar gɨn izegha auan vamɨran ingari, ezɨ e mɨzaraghara izegha ingangarir ekiam gamima, aruem e gaponge. Ezɨ nɨ ivezir vamɨra bar e ganɨngi.’ ");
INSERT INTO msy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ezɨ azenimɨn ghuavim akar kam baregha kamaghɨn men mav mɨgei, ‘Namakam, kɨ arazir kuratam ia gamizir puvatɨ. Ia ti faragha, ia wan kina iniasa akam akɨri? ");
INSERT INTO msy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nɨ uan ivezim inigh mangɨ. Kɨ kamaghɨn ifonge, kɨ dagɨaba gumazir gɨn izezim gɨvezir moghɨra nɨ gɨvesi. ");
INSERT INTO msy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kar nan bizimra. Kɨ ti uan dagɨaba uan ifongiamɨn dar anɨngan kogham? Egha kɨ arazir bar aghuim gumazir kabagh amizɨma nɨ tizim bagha navir averiamɨn na baseme?’” ");
INSERT INTO msy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Egha Iesus ghaze, “Kamaghɨra gumazir gɨn izeziba faragh ikiam, eghtɨ faragha itiba me gɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Egha Iesus uan suren gumazir 12 pla ko Jerusalemɨn zui. Egha me ghua a me inigha danganir mɨriar mamɨn ghua me uarira ikiava, egha kamaghɨn a me mɨgɨa ghaze, ");
INSERT INTO msy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ia oragh, E nguibar ekiam Jerusalemɨn ghuavanadi. Eghtɨ gumazitam Gumazibar Otarim isɨva, Judan arazibagh fozir gumaziba koma ofa gamir gumazir ekiabar anɨngam. Eghtɨ me a isɨ kotiam datɨghɨva, egh a mɨsueghtɨ an aremeghsɨva me akabar kɨram, egh me kamaghɨn a mɨkɨm suam, Nɨ aremegham. ");
INSERT INTO msy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Egh me a inigh Kantrin Igharazibar Gumazibar dafaribar anɨngtɨ, eghtɨ gumazir kaba a dɨpovam, egh a ifozoroghɨva egh a isɨva temer ighuvim gafughtɨ an aremegham. Eghtɨ aruer mɨkezim gɨvaghtɨma, a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ezɨ Sebedin amuim uan otarimning ko Iesus bagha izi. Me izava aningɨn amebam itevimning apɨrigha, egha ua bagha bizitam damuasa an azai. ");
INSERT INTO msy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ezɨ Iesus an azara, “Nɨ tizim baka?” Ezɨ a ghaze, “Nɨ kamaghɨn na bagh damu, nɨ Atrivir Ekiamɨn otogh, egh nan otarimning ateghtɨ, tav nɨn agharir guvim dapitɨma, tav nɨn agharir ikɨriam daperagh.” ");
INSERT INTO msy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ezɨ Iesus akam baregha egha kamaghɨn a ikara, “Ia azangsɨzir bizir kam, ia an mɨngarim gɨfozir puvatɨ, egha ia a bagha nan azai. Gua ti kɨ ateramin osɨmtɨzim, uaghan an ateramin gavgavim iti?” Ezɨ aning ghaze, “Are, ga gavgavim iti.” ");
INSERT INTO msy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ezɨ Iesus kamaghɨn aning mɨgɨa ghaze, “Guizbangɨra, gua kɨ ateramin osɨmtɨzim, gua a iniam. Egha kɨ tav amɨseveghtɨ a nan ikɨriam ko guvimɨn dapiamin bizim, a nan bizim puvatɨ. Ezɨ danganir kabanang, nan Afeziam dar apiasa gumazir maba amɨsevegha, egha me bagha dar kɨrigha gɨfa.” ");
INSERT INTO msy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ezɨ suren gumazir 10 pla akar kam baregha aningɨn atari. ");
INSERT INTO msy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ezɨma Iesus men diazɨ, me izima a ghaze, “Ia fo, Kantrin Igharazibar atriviba pamten me gamima, me bar men apengan iti. Ezɨ men gumazir dapaniba uan akaba baraghasa puvɨra me abɨraghbɨrasi. ");
INSERT INTO msy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eghtɨ arazir kaba ian tongɨn ikian kogham. Gumazir manam ian tongɨn ekiamɨn ikɨsɨ, a ingangarir gumazimɨn mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Eghtɨ gumazir manam ian faragh mangɨsɨ, a bar ian ingangarir gumazir kɨnimɨn mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ezɨ kamaghɨra Gumazibar Otarim iza, gumazamizibar amutɨ me a bagh ingarasa, a izezir pu. Puvatɨ, a me bagh ingarasa ize. Egha a gumazamizir avɨriba bagh aremegh ua me givezegh me iniasa ize.” ");
INSERT INTO msy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ezɨ Iesus uan suren gumaziba ko Jerikon nguibar ekiam ategha zui. Ezɨ avɨrir ekiam an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ezɨ gumazir damazir kurar pumuning tuavir apɨnimɨn aperaghav iti. Egha aning orazima Iesus tuavir kamɨn izima, aning pamten kamaghɨn dei, “Nɨ Devitɨn Otarim, nɨ gan apangkufigh.” ");
INSERT INTO msy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ezɨ gumazamiziba aning barazi, aning deima, me pamten aningɨn anogorogha ghaze, gua uan akamning dukuagh. Me kamaghɨn aningɨn mɨgeima, aning tiarim akarava dia ghaze, “Ekiam, nɨ Devitɨn Otarim, nɨ gan apangkufigh.” ");
INSERT INTO msy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kamaghɨn amizɨma, Iesus tugha aningɨn dia ghaze, “Gua tizim gifonge, eghtɨ kɨ gua bagh a damuam?” ");
INSERT INTO msy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ezɨ aning a ikaragha ghaze, “Ekiam, nɨ gan damaziba kuightɨ, ga ua ganasa.” ");
INSERT INTO msy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ezɨ Iesus aningɨn apangkuvigha egha dafarim aningɨn damazibagh atɨzɨ, aningɨn damaziba maghɨra ua derazɨ, aning ua gari. Egha maghɨra Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Egha Iesus uan suren gumaziba ko me Jerusalemɨn boroghɨn izava Olivɨn Mɨghsɨamɨn iza Betfagen nguibamɨn oto. Egha Iesus uan suren gumazir pumuning amaga, ");
INSERT INTO msy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","kamaghɨn aning mɨgei, “Gua nguibar munagh itimɨn mangɨ, egh gua gantɨma, donkin mam me a ikezɨma a uan nguzir asem ko iti. Aningɨn benim fɨrigh na bagh aning inigh kagh izɨ. ");
INSERT INTO msy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eghtɨ gumazitam guan azangtɨma, gua a mɨkɨm suam, ‘Ekiam ingangarim aningɨn iti.’ Eghtɨ gumazir kam zuamɨra puram aning ateghtɨ, aning izam.” ");
INSERT INTO msy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Godɨn akam inigha izir gumazim Aisaia faragha mɨkemezir akaba otivasa, bizir kaba otifi. Akar kam kamakɨn, ");
INSERT INTO msy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nɨ akar kam isɨva Saionɨn nguibamɨn itir gumazamizibav keme. Ia gan, ian atrivimra mara, ia bagha izi! A gumazir kɨnir ziaba puvatɨzir mamɨn mɨn donkin mam gaperagha izi, kar donkin amebamɨn nguzir asem.” ");
INSERT INTO msy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ezɨ Iesusɨn suren gumazimning ghua a mɨkemezɨ moghɨn ami. ");
INSERT INTO msy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Egha aning donkin amebam nguzir asem sara aning inigha iza, egha uan korotiar azenan azuiba suegha donkiningɨn akɨrimning gisɨn atɨzɨ, Iesus korotiar kabagh isɨn apera. ");
INSERT INTO msy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ezɨ gumazamizir avɨriba uan korotiar azenimɨn azuiba suegha tuavim mughara zui. Ezɨ marazi temer aguaba oka da isa tuavir torim garɨsi. ");
INSERT INTO msy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ezɨ gumazamizir faragha zuiba ko Iesusɨn gɨn iziba, uan tiariba akara ghaze, “Hosana! Ia Devitɨn Otarimɨn ziam fɨ. An Ekiamɨn ziamɨn izir gumazim, eghtɨ God deravɨra a damu. Hosana! Ia Godɨn bar pɨn itimɨn ziam fɨ!” ");
INSERT INTO msy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ezɨ Iesus Jerusalemɨn aven ghuzɨ, an itir gumazamiziba dɨgavir kuram gamigha tintinibar uarir azai, ");
INSERT INTO msy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Kar gumazir manam?” Ezɨ Iesusɨn gɨn izezir darazi ghaze, “Kar Iesus, a Godɨn akam inigha izir gumazim. A Galilin Distrighɨn aven itir nguibam Nasaretian gumazim.” ");
INSERT INTO msy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ezɨ Iesus ghua Godɨn Dɨpenimɨn mɨriamɨn gumazibar garima, me biziba amadi, ezɨ a me batosi. Egha gumazir dagɨaba uarir ikarvazibar dakoziba, ko kuarazir bunbaba amadir gumazibar dabirabiba, da fava egha da ighavkɨri. ");
INSERT INTO msy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Egha a kamaghɨn me mɨgei, “Godɨn Akɨnafarim akar kam iti. ‘Nan dɨpenim, me ziar kam a darɨgham, Gumazamiziba God ko Mɨgeir Dɨpenim. Ezɨ ia a gamima, an okɨmakɨar gumazibar mogomer danganimɨn oto!’” ");
INSERT INTO msy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Egha a Godɨn Dɨpenimɨn aven itima, damazir okavɨrɨziba ko suer amɨrɨziba a bagha izima, a men arɨmariaba gefi. ");
INSERT INTO msy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ezɨ ofa gamir gumazir ekiaba koma Judabar arazibagh fozir gumaziba izava an amir arazir ivɨnbabar gari. Egha me orasi, boriba Godɨn Dɨpenimɨn mɨriamɨn ikia dia ghaze, “Hosana! Devitɨn Otarimɨn ziam fɨ.” Kamaghɨn amizɨ, me bizir kaba bagha atari. ");
INSERT INTO msy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Egha kamaghɨn Iesusɨn azai, “Nɨ boriba mɨgeir akaba barasi, o?” Ezɨ Iesus me ikaragha ghaze, “Are, ia ti Godɨn Akɨnafarimɨn ganizir puvatɨ? A ghaze, ‘Nɨ borir iririviba ko otem apavɨra itibagh amima, me deravɨra nɨn ziam fe.’” ");
INSERT INTO msy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Egha me ategha ghua Jerusalemɨn nguibam ategha Betanin nguibamɨn ghu, egha kagh akui. ");
INSERT INTO msy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Egha mɨzaraghara Iesus dɨkavigha ua Jerusalemɨn zui. A zuima, mɨtiriam an azi, ");
INSERT INTO msy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ezɨ a tuavir apɨnimɨn temer fighɨn mamɨn garima, a iti. Ezɨ a roghɨra ghua garima, fighɨn ovɨziba puvatɨ. A pura dafarir kɨniba iti. Ezɨ Iesus temer kam mɨgɨa ghaze, “Nɨ ua ban kogham. Bar puvatɨgham.” Ezɨ temem maghɨra mɨsɨngi. ");
INSERT INTO msy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ezɨ an suren gumaziba bizir kamɨn ganigha dɨgavir kuram gamigha, egha ghaze, “Temem manmaghɨn amigha zuamɨra mɨsɨngi?” ");
INSERT INTO msy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ezɨ Iesus kamaghɨn me ikaragha ghaze, “Kɨ guizbangɨra ia mɨgei, ia nɨghnɨzir gavgavim ikɨva, egh okam nɨghnɨghan kogh, egh ia, kɨ fighɨn temem gamizir arazim, ia uaghan a damuamin gavgavim ikiam. Egha anarɨra puvatɨ, ia uaghan mɨghsɨar kam mɨkɨm suam, ‘Nɨ dɨkavigh mangɨ, uabɨ isɨ ongarim mɨkɨnigh.’ Eghtɨ a ia mɨkemezir moghɨn otivam. ");
INSERT INTO msy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Egh ia nɨghnɨzir gavgavim ikɨva God ko mɨkɨmɨva, ia bizir manaba bagh Godɨn azangsɨgh, egh ia da iniam.” ");
INSERT INTO msy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Egha Iesus ghua Jerusalemɨn otogha Godɨn Dɨpenimɨn mɨriamɨn aven gumazamiziba Godɨn akam men sure gami. Ezɨ ofa gamir gumazir ekiaba ko Judabar arazibagh fozir gumaziba iza kamaghɨn an azai, “Nɨ gavgavir manamɨn amodoghɨn bizir kabagh ami? Ezɨ tina gavgavir kam nɨ ganɨngi?” ");
INSERT INTO msy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ezɨ Iesus me ikaragha ghaze, “Kɨ azangsɨzir mam ia damuasa. Ia deravɨra a ikaraghtɨma, kɨ ia mɨkɨmam, kɨ gavgavir manamɨn amodoghɨn bizir kabagh ami. ");
INSERT INTO msy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kɨ Jon bagha ian azai, tina gavgavim Jon ganɨngizɨ a gumaziba rue? A ti Godɨn Nguibamɨn gavgavir kam ini, o a ti gumaziba dama a ini?” Ezɨ me uarira uariv gɨa ghaze, “E suam, ‘An rurim Godɨn ize,’ eghtɨ a ua kamaghɨn en azaragham, ‘Ia manmaghɨn amigha nɨghnɨzir gavgavim Jon damuan aghua?’ ");
INSERT INTO msy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Eghtɨ e suam, ‘Jonɨn rurim gumazibar ize,’ e kamaghɨn gumazamizibar atiatingi. E fo, me bar Jon mɨgɨa ghaze, a Godɨn akam inigha izir gumazir mam.” ");
INSERT INTO msy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kamaghɨn amizɨ, me Iesus mɨgɨa ghaze, “E fozir puvatɨ.” Ezɨ Iesus kamaghɨn me mɨgɨa ghaze, “Kamaghɨra, kɨ uan gavgavim inizir tuavimɨn, gun ia mɨkemeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Egha Iesus uam ofa gamir gumazir ekiaba ko gumazir dapaniba kamaghɨn me mɨgei, “Ia manmaghɨn nɨghnɨsi? Gumazir mam otarir pumuning iti. Egha ghua kamagh otarir avebam mɨgei, ‘Otarim, nɨ datɨrɨghɨn mangɨ, wainɨn azenimɨn aven ingar.’ ");
INSERT INTO msy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ezɨ otarim ghaze, ‘Kɨ aghua.’ Egha ua gɨn, nɨghnɨzim gɨragha ghua ingari. ");
INSERT INTO msy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ezɨ afeziam ghua otarir dozim kamaghɨra an azara. Ezɨ otarim ghaze, ‘Kɨ mangɨ, ingaram.’ Egha gɨn ghuzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ezɨ ia manmaghɨn nɨghnɨsi, otarir kamningɨn manamra afeziamɨn akam baragha an gɨn zui?” Ezɨ me Iesus mɨgɨa ghaze, “Otarir avebam.” Ezɨ Iesus kamaghɨn me mɨgɨa ghaze, “Kɨ guizbangɨra ia mɨgei, gumazir dagɨaba isiba ko amizir arazir kurabagh amiba, me ia gafiragha faragha God Bizibagh Ativamin Dughiamɨn aven zui. ");
INSERT INTO msy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Guizbangɨra, Jon otogha arazir aghuimɨn tuavim ian aka, ezɨ ia nɨghnɨzir gavgavim an akamɨn ikian aghua. Ezɨ dagɨaba isir gumaziba ko amizir arazir kurabagh amiba, me nɨghnɨzir gavgaviba an iti. Ia bizir kamɨn ganigha uan nɨghnɨzibagh irazir puvatɨ, egha nɨghnɨzir gavgavim Jonɨn akamɨn itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Egha Iesus gumazir dapaniba ua kamagh me mɨgei, “Ia akar isɨn zuir kam baragh. Gumazir mam wainɨn azenimɨn ingarigha, egha an dɨvazim aghui. Egha wainɨn ovɨziba mɨrmɨramin itarim gukuigha azenir dɨpenimɨn ingari, eghtɨ ingangarir gumaziba an ikɨ azenimɨn ganam. Egha azenir kam isa gumazir mabar agharim gatɨgha ghaze, me gɨn wainɨn dɨpataba uam a ikaragham. Egha dɨkavigha nguibar saghon itimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ezɨ wainɨn temeba ber dughiam roghɨra izezɨma, gumazir kam uan ingangarir gumazir maba amadazɨma, me wainɨn ovɨzi taba iniasa ghue. ");
INSERT INTO msy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ezɨ azenimɨn garir gumaziba ingangarir gumazir kaba inigha, mam mɨsuegha, egha mam me a mɨsoghezɨma an areme, egha dagɨaba mam ginifi. ");
INSERT INTO msy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ezɨ azenimɨn ghuavim gɨn ua ingangarir gumazir igharaziba amangi. Me avɨraseme, egha men dɨbobonim faragha izezibagh afira. Ezɨ wainɨn azenimɨn garir gumazir kaba kamaghɨra uam azenimɨn ghuavimɨn ingangarir gumazibagh ami. ");
INSERT INTO msy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Kamaghɨn amizɨma, azenimɨn ghuavim abuan uan otarim amada. Afeziam ghaze, ‘Me nan otarimɨn akam baragh deragh a damuam.’ ");
INSERT INTO msy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Puvatɨ, gumazir kaba otarimɨn gari, a izima, me uarira uariv gei, ‘Gumazir kam izɨva uan afeziamɨn biziba bar da inigham. Aria. E a mɨsueghtɨ, an aremegham. Eghtɨ e uari bagh wainɨn azenim iniam.’ ");
INSERT INTO msy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kamaghɨn, me maghɨra an suigha, wainɨn azenimɨn azenan anekunigha, otarim mɨsoghezɨ an areme. ");
INSERT INTO msy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Eghtɨ wainɨn azenimɨn ghuavim izɨ manmaghɨn gumazir kabar amuam? Ia manmaghɨn nɨghnɨsi?” ");
INSERT INTO msy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ezɨ me a mɨgɨa ghaze, “A gumazir kurar kaba puv me mɨsueghtɨ me arɨmɨghregham. Eghtɨ an azenim isɨva gumazir igharazibar anigam, eghtɨ wainɨn ovɨziba iniamin dughiamɨn me a bagh pozim daghuigh a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ezɨ Iesus kamaghɨn men azai, “Ia Godɨn Akɨnafarimɨn aven itir osizirir kabar gani, o puvatɨ? Osizirir kaba kamaghɨn mɨgei, ‘Kar dɨpenir akɨnir ingangarir gumaziba aghuazim, a datɨrɨghɨn dɨpenim aterir guarim gava. Ekiam uabɨ arazir kam gamizɨma an oto. Ezɨ e an garima, a bar dera.’ ");
INSERT INTO msy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kamaghɨn, kɨ ia mɨgei, God Bizibagh Ativamin Dughiam, God ia dama a inigh a isɨva, gumazamizir dughiar kamɨn aven ikɨ arazir aghuibar amuamibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Eghtɨ gumazir manam dagɨar kam gisɨn irɨghɨva, an aghariba dɨpɨrighregham. Eghtɨ dagɨar kam gumazitam gisɨn irɨghɨva, bar anemɨsarigham.” ");
INSERT INTO msy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ofa gamir gumazir ekiaba ko Farisiba akar isɨn zuir kam baregha fo, Iesus akam isa, me gasara. ");
INSERT INTO msy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kamaghɨn amizɨ, me an suighasava amuava, egha gumazamizir avɨribar gara atiatingi. Me fo, gumazamiziba Iesusɨn mɨgɨa ghaze, a Godɨn akam inigha izir gumazir mam. ");
INSERT INTO msy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ezɨ Iesus uam akar isɨn zuir mamɨn gumazir dapanibagh amua kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“God Bizibagh Ativamin Dughiam mati, atrivir mamɨn otarim amuimɨn ikiasava amima, an a bagh isar ekiam gami. ");
INSERT INTO msy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Isar dughiam tɨghar otivam, a faraghavɨra gumazamizir mabav gɨa ghaze, ia izɨ. Dughiam otozɨma, a uan ingangarir gumaziba amadi, eghtɨ me mangɨ gighamizir gumazamizibar diaghtɨ, me izam. Puvatɨ, gumazamizir a gighamiziba, me izan aghua. ");
INSERT INTO msy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ezɨ a uan ingangarir gumazir maba amaga, kamaghɨn me mɨgei, ‘Ia mangɨ, gumazir kɨ gighamiziba kamagh me mɨkɨm, “Ia oragh. Kɨ dagheba tuegha gɨfa, nan kaun apuriba kɨ dav suegha, egha uaghan uan asɨzir ekiabav soke. Ezɨ isamɨn biziba bar gɨfa. Ia poroghamir isar ekiamɨn izɨ.” ’ ");
INSERT INTO msy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ezɨ ingangarir gumaziba ghua akar kamɨn gumazibav gei. Ezɨ me oraghan aghuagha tintinibar zui. Mav uan azenimɨn zui, mav uan dagɨar ingangarim bagha zui. ");
INSERT INTO msy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Marazi atrivimɨn ingangarir gumazibar suigha, puv me mɨsoghezɨ me ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Kamaghɨn amizɨ, atrivim puv atari, egha kamaghɨn uan mɨdorozir gumaziba amada. Ezɨ me ghua an ingangarir gumazibar mɨsogheziba, me mɨsogha bar me agɨvaghava, men nguibar ekiam gaborozɨ a isi. ");
INSERT INTO msy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Ezɨ atrivim uan ingangarir gumazibav gei, ‘Poroghamir isamɨn dagheba isigha gɨfa. Ezɨ gumazir kɨ gighamiziba, me gumazir kuraba, kamaghɨn me isamɨn ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kamaghɨn amizɨ, ia mangɨ tuavir akaba bar dar mangɨ, egh gumazir manaba ia me bativigh, egh ia men diaghtɨ, me poroghamir isar kamɨn izɨ.’ ");
INSERT INTO msy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A kamaghɨn mɨkemezɨma, an ingangarir gumaziba tuaviba bar dar ghuava gumazamiziba bar me akufa, gumazir aghuiba ko kuraba sara. Ezɨ me iza damasava apiazɨ dɨpenim bar izɨfa. ");
INSERT INTO msy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ezɨ gumazamiziba apiazɨma, atrivim men ganasa aven zui. Egha a ghua gumazir mamɨn garima, a isamɨn izasa adiariar aghuitam aruzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ezɨma atrivim an azai, ‘Namakam, manmaghɨn amizɨ, nɨ adiarir aghuitam aruzir puvatɨgha, puram aven ize?’ Ezɨ gumazim mɨkɨman asa. ");
INSERT INTO msy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kamaghɨn amizɨ, atrivim ingangarir gumazibav gɨa ghaze, ‘Ia an soroghafariba ikegh, a isɨva azenan mɨtatemɨn anekunigh. Danganir mɨtater kamɨn me puvɨra tuavara atariba kuskusi.’ ");
INSERT INTO msy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ia oragh. God gumazamizir avɨribar dei, egha vaghvazibara a me amɨsevima, me aven zui.” ");
INSERT INTO msy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ezɨ Farisiba ghua akabav suegha Iesusɨn suighasa tuaviba buri. Egha me ghaze, a bizitam a paza mɨkemegham, eghtɨ me an mɨgɨrɨgɨam baghavɨra an suigham. ");
INSERT INTO msy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Egha me uan suren gumazir maba ko Herotɨn gɨn zuir darazi amada, ezɨ me Iesus bagha ghua kamaghɨn a mɨgei, “Tisa, e fo nɨ guizbangɨra bizibav geir gumazim. Nɨ Godɨn Arazibar gumazibar sure gamuava guizbangɨra me mɨgei. Nɨ tavɨn nɨghnɨzimɨn gɨn zuir puvatɨ. Akar vamɨra nɨ gumazir ziaba itiba, ko gumazir kɨniba uaghara, me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kamaghɨn, nɨ deragh e mɨkɨm. Judan araziba manmaghɨn mɨgei? E dagɨaba isɨva Atrivim Sisar danɨngtɨma, arazir kam Godɨn damazimɨn dera, o puvatɨ? Nɨ manmaghɨn nɨghnɨsi?” ");
INSERT INTO msy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ezɨ Iesus men nɨghnɨzir kurar kam gɨfo, egha kamaghɨn me mɨgei, “Ia gumazir ifavaribagh amiba, ia tizim bagha na gifarasava ami? ");
INSERT INTO msy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ia gavman ganɨdir dagɨatam nan akagh.” Ezɨ me dagɨar mam inigha iza a ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ezɨ Iesus kamaghɨn men azai, “Kar tinan nedazim ko tinan ziam?” ");
INSERT INTO msy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ezɨ me ghaze, “Mar Sisarɨn nedazim ko an ziam.” Ezɨ a me mɨgɨa ghaze, “Kamaghɨra, ia Sisarɨn biziba Sisar danɨngɨva, egh Godɨn biziba isɨ, God danɨng.” ");
INSERT INTO msy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ezɨ me mɨgɨrɨgɨar kam baregha dɨgavir kuram gamigha, egha anetegha ghue. ");
INSERT INTO msy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ezɨ aruer kamra, Sadyusiba Iesus bagha ize. Sadyusiba ghaze, gumazir aremeziba ua dɨkavir puvatɨ. Egha me kamaghɨn Iesusɨn azai, ");
INSERT INTO msy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisa, Moses kamaghɨn mɨkeme, Gumazir manatam boriba puvatɨgh aremeghtɨ, an aveghbuatam an amuim inigh an ikɨtɨ, amizir kam boriba batɨ, eghtɨ an aveghbuamɨn ikɨzim kuvaremeghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ezɨ fomɨra aveghbuar 7 pla, en tongɨn ike. Men avebam amuimɨn ikiava boritam inizir puvatɨ, egha areme. Kamaghɨn amizɨ, an dozir mam an amuim inigha an iti. ");
INSERT INTO msy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ezɨ an dozir kam uaghan boritam inizir puvatɨgha areme. Ezɨ aningɨn dozir mɨkezim ko an gɨn iziba kamaghɨram ami. ");
INSERT INTO msy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Egha me bar aremegha gɨfa, ezɨ abuan amizir kam uaghan areme. ");
INSERT INTO msy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kamaghɨn nɨ e mɨkɨm, gumaziba ua dɨkavamin dughiamɨn, amizir kam tinan amuimra? Nɨ nɨghnɨgh, me bar an ike!” ");
INSERT INTO msy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ezɨ Iesus me ikarvagha kamaghɨn me mɨgei, “Ia Godɨn Akɨnafarimɨn itir akam gɨfozir puvatɨ, egha ia uaghan Godɨn gavgavim gɨfozir puvatɨ. Kamaghɨn, ia paza mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gumazamizir aremeziba ua dɨkavamin dughiamɨn, paba amuibar ikian kogham, uaghan me amuiba isɨ pabar arɨghan kogham. Me enselbar mɨn Godɨn Nguibamɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Ezɨ kɨ ua dɨkavamin dughiam bagh ian azangasa. Ia ti God ia mɨkemezir akar kamɨn ganizir puvatɨ, o? A ghaze, ");
INSERT INTO msy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kɨ Abraham ko Aisak ko Jekopɨn God.’ God gumazir nivafɨzir ariaghɨribar God puvatɨ, a gumazir duar angamra itibar God.” ");
INSERT INTO msy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ezɨma gumazamiziba an akar kam baregha dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisiba orazima, Iesusɨn mɨgɨrɨgɨaba Sadyusibagh amizɨma, me mɨkɨman ibura. Ezɨ me uari akuvagha a bagha izi. ");
INSERT INTO msy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me ko izir gumazir mam, a Judabar arazibagh fo. Egha a Iesus basamasa kamaghɨn an azai, ");
INSERT INTO msy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, Godɨn arazir manamra maba bar dagh afira egha faraghavɨra iti?” ");
INSERT INTO msy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Nɨ uan God, nɨn Ekiam, bar a gifongegh, egh nɨ uan navir averiam ko uan duam ko uan nɨghnɨzimɨn, uan God gifongegh. ");
INSERT INTO msy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kar arazir bar ekiam, egha a mabar a faraghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","An gɨrara itim, bar an mɨrara. A kamakɨn: nɨ uabɨra uabɨ gifongezɨ moghɨn, gumazamizir igharazibagh ifongegh. ");
INSERT INTO msy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses Osirizir Araziba ko Godɨn akam inigha izir gumazibar akaba, da bar arazir kamning gisɨn tu.” ");
INSERT INTO msy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisiba uari akuvagha ikiav itima, Iesus men azai, ");
INSERT INTO msy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ia God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim, manmaghɨn a gɨnɨghnɨsi? A tinan otarim?” Ezɨ me an mɨgɨa ghaze, “A Devitɨn Otarim.” ");
INSERT INTO msy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ezɨ Iesus kamaghɨn men azai, “Manmaghɨn amizɨ, Godɨn Duam nɨghnɨziba Devit ganɨdima, Devit gumazir kam ‘Ekiam’ a gatɨ, egha Devit kamaghɨn mɨgɨa ghaze, ");
INSERT INTO msy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Ekiam, nan Ekiam kamaghɨn a mɨgei, “Nɨ nan agharir guvim daperagh, egh na ko atrivimɨn ikiam. Egh mangɨ dughiar kɨ nɨn apaniba, me damightɨ me nɨn apengan ikiam.” ’ ");
INSERT INTO msy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eghtɨ ia nɨghnɨgh, Devit uabɨ gumazir kamɨn mɨgɨa ghaze, a nan Ekiam. Ezɨ manmaghɨn, gumazir kam ua Devitɨn Otarimɨn mɨn iti?” ");
INSERT INTO msy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ezɨ men tav bar Iesus ikarvaghan buraghburaki. Egha me aruer kamɨn ikegha ghua ua gɨn bizitam bagha an azangan atiati. ");
INSERT INTO msy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ezɨ Iesus gɨn gumazir avɨriba ko an suren gumazibagh eghari. ");
INSERT INTO msy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Egha kamaghɨn mɨgei, “Judan arazibagh fozir gumaziba ko Farisiba, me Mosesɨn danganim inigha me Moses Osirizir Araziba ia geghari. ");
INSERT INTO msy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kamaghɨn amizɨ, me ia mɨgeir akaba, ia da baragh dagh eghari moghɨn ia damu. Egh me amir araziba ia men gɨn mangɨ dar amuan markɨ. Me mɨgɨrɨgɨar bar avɨribagh amua egha uari dar gɨn zuir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Me kamaghɨn amua, mati me bizir bar osɨmtɨziba isava gumazibagh isaghpuima, ezɨ me da ateran buraghburasi. Egha me tong uan dafarpuzitamɨn men akurvaghan nɨghnɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Arazir me amiba, me uarir ganasa oda dagh ami. Me Godɨn Akar maba, uan daveriaba ko guaghafɨvibar da osirigha, egha dagh amizɨ, da bar ekefe, ezɨ me da azui. Egha korotiar apɨnir sazir bar ruariba, me da azui. Egha ghaze, e arazir kamɨn me uari akakagh suam, e guizbangɨra Godɨn akabar gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Egha isar ekiabar me danganir ziaba itiba isava, God ko mɨgeir dɨpenibar danganir faragha itibar apiaghiri. ");
INSERT INTO msy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Egh me biziba amadir danganibar mangɨtɨ, gumazamiziba ‘Tisaba’ me darɨgh, men ziaba fasa me bar akonge. ");
INSERT INTO msy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kɨ ghaze, gumazitam ia ‘Tisa’ a darɨghan markɨ. Bar markɨ. Ian tisan bar vamɨra, ia bar aveghdiariba. ");
INSERT INTO msy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Egh ia nguazimɨn kagh gumazitam ‘Afeziam’ a darɨghan markɨ. Ian Afeziar bar vamɨra, a uan Nguibamɨn iti. ");
INSERT INTO msy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Egh me ‘Gumazir Dapanim’ ian tav darɨghan markɨ. Ian Gumazir Dapanir vamɨra iti, a Gumazir God Uam E Iniasa Mɨsevezim. ");
INSERT INTO msy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ian gumazir ekiaba pura ian ingangarir gumazibar mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Te uarira uan ziaba fe, God me abɨraghtɨ, me apengan ikiam. Eghtɨ te apengan iti, God me feghtɨ me ziar ekiaba iniam.” ");
INSERT INTO msy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Egha Iesus ua kamaghɨn mɨgei, “Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika, ia bar ikuvigham! Ia ifavaribagh amir gumaziba! Ia God Bizibagh Ativamin Dughiamɨn tiam asarazɨ, gumazamiziba azenan iti. Egha ia uaghan aven mangan aghua. Ezɨ gumazamiziba aven mangasava amima ia men tuaviba apɨri. ");
INSERT INTO msy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika! Ia bar ikuvigham! Ia ifavaribagh amir gumaziba! Ia ongariba ko nguazir igharaziba bar dar ghua, suren gumazir vamɨra iniasa ruiagha arui. Eghtɨ ia gumazitam batogh Judabar arazibar a geghantɨ, eghtɨ a ian nɨghnɨzibar gɨn mangɨ, egh a bar ian mɨrara uaghan helɨn mangam. Ia a damightɨma, a bar ia gafiragh arazir kurabar amuam. ");
INSERT INTO msy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ia damazir okavɨrɨziba, egha ia gumazir igharaziba tuavim men akakaghasa! Iavzika, ia bar ikuvigham! Ia kamaghɨn gumazibar sure gamua ghaze, ‘Gumazir manam guizɨn mɨkɨmsɨva, Godɨn Dɨpenimɨn akakagh mɨkɨmtɨ, an araziba pura bizim. Egh gumazir kam guizɨn mɨkɨmsɨva, golɨn Godɨn Dɨpenimɨn aven itibar akakagh mɨkɨmtɨ, kar a guizbangɨra mɨgei, egha a mɨkemezir arazimɨn gɨn mangɨ, a damu.’ ");
INSERT INTO msy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ia gumazir onganir damazir okavɨrɨziba, tizim Godɨn damazimɨn ekefe? Ti gol, o ti Godɨn Dɨpenim? Ia fo, golɨn kam Godɨn Dɨpenimɨn aven iti, egha tuavir kamɨn golɨn kam Godɨn bizimɨn oto. ");
INSERT INTO msy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Egha ia uaghan kamaghɨn men sure gamua ghaze, ‘Gumazitam uan mɨgɨrɨgɨabar amutɨ da guizɨn otivsɨ, altan akakaghtɨ, an mɨgɨrɨgɨaba pura biziba. Eghtɨ gumazim altan itir ofabar akakagh mɨkɨmtɨ, kar a guizbangɨra mɨgei, egh a mɨkemezir mɨgɨrɨgɨabar gɨn mangɨ.’ ");
INSERT INTO msy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ia damazir okavɨrɨziba, bizir manam Godɨn damazimɨn ekefe, ti altan itir ofaba, o alta uabɨ? Ia fo, ofaba altan iti, egha tuavir kamɨn ofan kam Godɨn bizimɨn oto. ");
INSERT INTO msy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eghtɨ kamaghɨn, gumazim guizbangɨra mɨkɨmsɨva altan akakagh mɨkɨmtɨ, an mɨgɨrɨgɨaba alta ko altan ofaba vɨrara aningɨn akakasi. ");
INSERT INTO msy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Egh gumazim guizbangɨra mɨkɨmsɨva Godɨn Dɨpenimɨn akakagh mɨkɨmtɨ, an mɨgɨrɨgɨaba Godɨn Dɨpenim, ko Godɨn uan Dɨpenimɨn aven itim, vɨrara aningɨn akakasi. ");
INSERT INTO msy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Eghtɨ gumazitam guizbangɨra mɨkɨmsɨva Godɨn Nguibamɨn akakagh mɨkɨmtɨ, an mɨgɨrɨgɨaba Godɨn atrivir dabirabim, ko Godɨn uan atrivir dabirabim gaperazim, uaghara aningɨn akakasi. ");
INSERT INTO msy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika, ia bar ikuvigham! Ia ifavaribagh amir gumaziba! Ia isɨngtɨzim daghebagh anɨdir zuravarir 10 plan dafaribar aghava, egha dafarir vamɨra God ganɨdi. Egha Moses Osirizir Arazibar aven itir arazir ekiaba ataghrasi. Ia, gumazamiziba deragha me gamir arazim, ko arazir apangkuvim itiba, ko nɨghnɨzir gavgavim Godɨn itir arazim, ia da gɨn amadi. Ia faragh arazir ekiar kabar gɨn mangɨ dar amu, egh uaghan arazir dozir ia amiba sara, uaghan dar amu. ");
INSERT INTO msy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ia damazir okavɨrɨziba, egha gumazir igharaziba tuavim men akakaghasa! Ia mati, gumazim sibaba dɨparsɨzimɨn itima, a bar deravɨra gara da isa da makuri. Ezɨ asizir ekiam kamel, a dɨparsɨzimɨn aven itima, an an garir puvatɨgha, a tui. ");
INSERT INTO msy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika! Ia bar ikuvigham! Ia ifavaribagh amir gumaziba! Ia bar deraghavɨra kapba ko itaribar azeniba rue, ezɨ dar aven itir dagher kaba bar izɨfa. Ia, okɨmakɨar araziba ko uarira uarigh nɨghnɨzir arazibar tuavimɨn, dagher kaba ini. ");
INSERT INTO msy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ia Farisiba, ian damaziba okafi! Ia faraghvɨra kapbar averiaba ruegh, eghtɨ dar otɨghɨnaba uaghan zuegham. ");
INSERT INTO msy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika! Ia bar ikuvigham. Ia ifavaribagh amir gumaziba! Ia mati, me matmatiam penɨn ghurghurim a gaghui, ezɨ azenan matmatiamɨn ganganim bar dera. Ezɨ an aven gumazir kuabar aghariba ko bizir kuriba bar izɨfa. ");
INSERT INTO msy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ia uaghan kamaghɨn iti. Me azenan ian gara ghaze, ia gumazir aghuiba. Ezɨ ifavarir araziba ko arazir bar kuraba, guizbangɨra ian navir averiabagh izɨfa.” ");
INSERT INTO msy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Egha Iesus mɨgɨa ghua ghaze, “Ia Judan arazibagh fozir gumaziba ko Farisiba, Iavzika! Ia bar ikuvigham! Ia ifavaribagh amir gumaziba! Ia, fomɨra itir Godɨn akam inigha izir gumaziba, men moziba deraghvɨra dar kɨrmɨgha, egha gumazir arazir aghuibagh amizibar moziba deraghavɨra dar adiaribagh ami. ");
INSERT INTO msy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Egha kamagh uariv gei, ‘E ti uan inazibar dughiamɨn ikia, egha ti men akuragha Godɨn akam inigha izir gumazibav soghezir puvatɨghai.’ ");
INSERT INTO msy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","kamagh mɨgɨa uari akakagha ghaze, ‘E Godɨn akam inigha izir gumazibav soghezir gumazibar boriba!’ ");
INSERT INTO msy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aria, mangɨ, ia uan inaziba amuataghizir arazir kuraba, bar da gɨfagh! ");
INSERT INTO msy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ia kuruziba! Ia dabɨrɨzir anababa! God uan kotɨn aven ian araziba tuisɨghɨva, ia isɨ helɨn avir ekiamɨn ia amangam! Ia man tuavitamɨn angɨ, helɨn avim gitagham? Bar puvatɨgham! ");
INSERT INTO msy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Kamaghɨn amizɨma, ia oragh, kɨ ia bagha Godɨn akam inigha izir gumaziba, ko gumazir nɨghnɨzir aghuiba itiba, ko gumazir Godɨn Akɨnafarim itir arazibagh foziba, me amangam. Eghtɨ ia men tarazi mɨsoghtɨ me arɨmɨghiram, egh tarasi isɨva temer ighuvibagh afugham, egh tarazi ian God ko mɨgeir dɨpenibar aven benibar me fozorogham. Egh ia uan nguibar ekiabar me batogh men gɨn tɨghtɨ, me arɨ nguibar igharazibar mangam. ");
INSERT INTO msy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eghtɨma arazir aghuibagh amir gumaziba bar, me mɨsoghezir gumazibar ivezir kuram, ia a iniam. Gumazir aghuibav sozir arazir kam, gumazir aghuim Abelɨn dughiamɨn ikegha, iza Berekian otarim Sekaraian dughiamɨn tu. Gumazir kam, ia Godɨn Dɨpenim ko ofa gamir danganim tɨzimɨn ia a mɨsoghezɨ an areme, ezɨ iarara ivezir kuram uan arazir kuram bagh a iniam. ");
INSERT INTO msy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kɨ guizbangɨra ia mɨgei, arazir kurar kabar ivezir kuram, a datɨrɨghɨn itir gumazamiziba me bativam.” ");
INSERT INTO msy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Egha Iesus mɨgɨa ghua ghaze, “Oio, ia Jerusalemɨn adarazi, kɨ ian apangkufi! Ia Godɨn akam inigha izir gumazibav sozi me ariaghɨri, egha God ia bagha amadir gumaziba, ia dagɨaba isa, me ginivi, me ariaghɨri. Dughiar avɨribar kɨ ian boriba akuv me mughasa, mati tuarir amebam uan avɨzimingɨn nguziba avarazɨ moghɨn, kɨ ia damuasa. Ezɨ ia na bagh izan aghua. ");
INSERT INTO msy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ia oragh! Ian nguibam, God anetaki, ezɨ a nguibar soriam gava. ");
INSERT INTO msy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kɨ guizbangɨra ia mɨgei, ia ua nan ganan kogh, kamaghɨra ikɨ mangɨ dughiar ia suam, ‘God uan ziamɨn gumazir kam anemada! God deragh a damu!’” ");
INSERT INTO msy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Egha Iesus Godɨn Dɨpenimɨn mɨriam ategha azenan zuima, an suren gumaziba a bagha izi. Egha me Godɨn Dɨpenim an akakasi. ");
INSERT INTO msy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ezɨ an akar kamɨn me mɨgei, “Ia Dɨpenimɨn itir bizir aghuir kabar gari? Kɨ guizbangɨra ia mɨgei, dagɨar kaba, gumaziba bar da pueghtɨ da bar moghɨra dagh iregham. Eghtɨ tam tam gisɨn ikeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Egha Iesus ghua Olivɨn Mɨghsɨamɨn aperaghav itima, an suren gumaziba uarira iza kamaghɨn an azai, “Nɨ e mɨkɨm, bizir kaba dughiar manamɨn otivam? Arazir manamnagh faragh otoghtɨ, e fogh suam, ‘Nɨ ua izam,’ eghtɨ nguazir kam uaghan gɨvam?” ");
INSERT INTO msy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ezɨ Iesus me ikaragha kamaghɨn me mɨgei, “Ia uari bagh deraghvɨra gan, gumazitam izɨ ia gifaran markɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kamaghɨn amizɨ, gumazir bar avɨriba izɨ, nan ziam isɨva uari gasɨ suam, ‘Kɨrara, kɨ Gumazir God Gumazamiziba Ua Me Iniasa Mɨsevezim.’ Egh me gumazamizir avɨribagh ifaram. ");
INSERT INTO msy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Eghtɨ ia roghɨra itir mɨdorozir ekiabar nɨgɨniba baragh, egh saghon itir mɨdorozir ekiabar akaba baragham. Egh ia dɨgavir kuram damuan markɨ. Arazir kaba otivam, eghtɨ nguazir kam gɨvamin dughiam tɨghar izam. Eghtɨ ia roghɨra itir mɨdorozir ekiabar nɨgɨniba baragh, egh saghon itir mɨdorozir ekiabar akaba baragham. Egh ia dɨgavir kuram damuan markɨ. Arazir kaba otivam, eghtɨ nguazir kam gɨvamin dughiam zuamɨra otoghan kogham. ");
INSERT INTO msy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kantrin mamɨn itir darazi dɨkavigh kantrin igharazimɨn itir darazi ko mɨsogham. Eghtɨ atrivir mamɨn adarazi dɨkavigh atrivir igharazimɨn adarazi ko mɨsogham. Danganir mabar dagheba bar puvaratɨghtɨma, gumazamiziba mɨtiriamra ikiam. Eghtɨma mɨkɨmkɨziba uaghan otivam. ");
INSERT INTO msy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Osɨmtɨzir kaba mati, amizim otasa faraghavɨra mɨzazim barazi moghɨn. ");
INSERT INTO msy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Dughiar kamɨn me ian suighɨva osɨmtɨziba ia darɨghɨva ia mɨsoghtɨ, ia arɨmɨghiram. Eghtɨ gumazamiziba bar nan ziam bangɨn ian aghuagham. ");
INSERT INTO msy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Egh dughiar kamɨn gumazamizir avɨriba, me uan nɨghnɨzir gavgavir nan itim ategham. Egh pazɨ uarira uari damuva, uari isɨva apanibar agharim darɨgham. ");
INSERT INTO msy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Eghtɨ akar ifavarim akurir gumazir avɨriba otivigh, gumazamizir avɨribagh ifaram. ");
INSERT INTO msy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eghtɨ arazir kuraba bar izɨvaghtɨ, kamaghɨn gumaziba uarigh ifongezir arazim, gɨvagham. ");
INSERT INTO msy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eghtɨ tina arazir kabar tongɨn gavgavigh ikɨ, mangɨ dughiar nguazir kam gɨvaghamim otoghtɨ, God uam a iniam. ");
INSERT INTO msy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Eghtɨ God Bizibagh Ativamin Dughiamɨn akar aghuir kam, me a inigh a isɨva nguazimɨn itir gumazamiziba bar me mɨkɨmtɨma, me a baragham. Eghtɨma gɨn nguazir kam gɨvamin dughiam otivam.” ");
INSERT INTO msy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Egha Iesus mɨgɨa ghua kamagh mɨgei, “Ia gantɨma, bizir bar kurar God ifongezir puvatɨzim, Godɨn Dɨpenimɨn aven ikiam. Fomɨra Godɨn akam inigha izir gumazim Daniel bizir kamɨn gun mɨkeme. (Gumazir osizirir kamɨn garim, a deraghvɨra nɨghnɨgh egh a gɨfogh.) ");
INSERT INTO msy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Dughiar kamɨn Judian Distrighɨn itir gumazamiziba arɨ danganir mɨghsɨabar mangɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Egh gumazir manam dɨpenimɨn pɨn itir avughsazir danganimɨn ikegh, nguazimɨn magɨrɨ, egh uam aven mangɨ uan bizitam inisɨ nɨghnɨghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Egh gumazir manam azenir ekiamɨn ikegh, egh uamategh dɨpenimɨn mangɨ uan azenan azuir korotiam inian markɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ia naviba adair amiziba ko boriba oteba apir amebaba Iavzika! Dughiar izamin kaba bar ian ikuvigham! ");
INSERT INTO msy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ia amozimɨn dughiam ko Sabatɨn dughiatamɨn aran aghuaghɨva, uari bagh Ekiam ko mɨkɨm. ");
INSERT INTO msy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dughiar kamɨn osɨmtɨzir bar ekiam otivam, nguazim igiamra otozir dughiamɨn ikegha iza datɨrɨghɨn itir dughiamɨn tu, osɨmtɨzir kamaghɨn ititam fomɨra otozir puvatɨ, egh gɨn tam kamaghɨn uam otivan kogham. ");
INSERT INTO msy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Egha God uan gumazamizir mɨsevezibagh nɨghnɨgha, egha dughiar kurar kamɨn dughiar maba aghorezɨ, da mong otefe. A ti dar aghorezir puvatɨzɨ, gumazamiziba bar ariaghreghai. ");
INSERT INTO msy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Eghtɨ gumazitam dughiar kamɨn kamaghɨn ia mɨkɨmam, ‘Ia gan, God Gumazamiziba Ua Me Iniasa Mɨsevezir Gumazim, a kagh iti,’ o ‘a muna munagh iti,’ ia gumazir kamɨn akam baraghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gumazitaba izɨva ia gifar suam, ‘Kɨrara, God Gumazamiziba Ua Me Iniasa Mɨsevezir Gumazim,’ o ‘kɨ Godɨn akam inigha izir gumazir mam,’ egh me mirakelɨn bar ekiaba koma dɨgavir kuram gamir arazibar amutɨ da otivam. Me kamaghɨn ifonge, me gumazamiziba bar me gifaraghtɨ, me onganigham. Egh me gavgavim ikɨ, uaghan God ua bagha mɨsevezir gumazamiziba, me uaghan me gifarasa. Kamaghɨn me mirakelɨn kabar amuam. Egh dughiataba me me gifarsɨ damuva avegham. ");
INSERT INTO msy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ia oragh! Bizir kɨ faragha ia mɨkemeziba, da otivam. ");
INSERT INTO msy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kamaghɨn amizɨ, me ia mɨkɨm suam, ‘Ia gan. A muna gumaziba itir puvatɨzir danganimɨn iti,’ eghtɨ ia mangan markɨ. Egh me suam, ‘Ia gan. A kara, dɨpenir kamɨn aven modoghav iti,’ ia men akam baraghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ia fo, onɨmarim taghtagha, an angazangarim aruem anadi naghɨn ikegha nguazim bar anevaragha ghua aruem ghuaghiri naghɨn tu. Eghtɨ Gumazibar Otarim ua izamin arazim, uaghan kamaghɨram otivtɨ, nguazimɨn itir darazi bar an ganam. ");
INSERT INTO msy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Danganir manam gumazir kuam irɨghav iti, a gisɨrara isaba uari akufi, eghtɨ gumaziba fogham, kuar mam kagh iti. Kamaghɨra, Gumazibar Otarim izɨtɨma, gumaziba bar an ganam.” ");
INSERT INTO msy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Egha Iesus mɨgɨa ghua ghaze, “Osɨmtɨzir ekiar kaba otivigh gɨvaghtɨ, ‘Aruem mɨtategham, eghtɨ iakinim isiraghan kogham, eghtɨ mɨkoveziba overiamɨn asighɨram, overiamɨn itir bizir gavgaviba bar uarira uari sɨvaghsɨvagh, uan danganiba ataghragham.’ ");
INSERT INTO msy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Eghtɨ, Gumazibar Otarim izamin dughiam, an arazarazim overiamɨn otivtɨma, nguazimɨn itir nguibaba bar aziam. Dughiar kamɨn gumaziba gantɨ Gumazibar Otarim ghuariabagh isɨn ikɨ, uan gavgavir ekiam koma angazangarir ekiam sara izam. ");
INSERT INTO msy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Eghtɨ sɨgham bar pamten arangtɨ, a uan enselba amadaghtɨ, me mangɨ nguazim ko overiamɨn danganiba bar dar mangɨ, a ua bagha mɨsevezir gumazamiziba akuvam, egh enselba nguazimɨn oteviba bar, me akuvaghɨva, men aku a bagh izam.” ");
INSERT INTO msy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Temer fighɨn aguaba ua dɨz murtɨ, ia fogh suam, amozimɨn dughiam roghɨra ize. Ia temer fighɨn gan nɨghnɨzim iniam. ");
INSERT INTO msy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kamaghɨra ia bizir kabar gantɨ da otivtɨ, ia fogh suam, Gumazibar Otarim a ua izamin dughiam roghɨra ize. A tiar akamɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kɨ guizbangɨra ia mɨgei dughiar kamɨn itir gumazamizir kaba ikɨvɨra ikɨtɨ bizir kaba bar otivam. ");
INSERT INTO msy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Overiam ko nguazim givagham, eghtɨ nan mɨgɨrɨgɨatam gɨvaghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Egha Iesus mɨgɨa ghua ghaze, “Bizir kɨ ia mɨgeir kaba otivamin dughiam, tav a gɨfozir puvatɨ. Enselɨn Godɨn Nguibamɨn itiba ko Godɨn Otarim uaghan fozir puvatɨ. Afeziam bar uabɨra fo. ");
INSERT INTO msy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ezɨ bizir Noan dughiamɨn otiviziba, da uaghan Gumazibar Otarim izamin dughiamɨn otivam. ");
INSERT INTO msy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dɨpar ekiar nguazim bar anevarazim tɨghar izamin dughiamɨn, gumazamiziba apava, dɨpar onganiba apava, egha amuiba ko pabar iti. Me kamaghɨn amua ikiav itima, Noa kurimɨn aven ghu. ");
INSERT INTO msy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Me bizir me bativamin tam gɨfozir puvatɨ, egha pura ikiav itima, aperiar ekiam otogha bar me avaragha me avigha ghue. Gumazibar Otarim izamin dughiam, uaghan kamaghɨrama otivam. ");
INSERT INTO msy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gumazir pumuning azenimɨn ikɨtɨ, God tav inightɨ, tav ikiam. ");
INSERT INTO msy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Amizir pumuning bretbar amusɨ flaua mɨrmɨrɨva ikɨtɨ, God tav inightɨ, tav ikiam. ");
INSERT INTO msy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kamaghɨn amizɨ, ia deragh gan ikɨ. Ian Ekiam izamin dughiam, ia a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ia arazir kam gɨnɨghnɨgh. Gumazir manam, okɨmakɨar gumaziba dɨmagarimɨn izava an dɨpenim akarasava amima, a men dughiam gɨfogha, egha men arafa. Egha me ataghizɨ me an dɨpenim akarɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kamaghɨra, ia uaghan aravagh ikɨ gan. Guizbangɨra, dughiar ia Gumazibar Otarim mɨzuaman koghamim, a dughiar kamram otogham.” ");
INSERT INTO msy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ingangarir gumazir manamra nɨghnɨzir aghuiba ikia deravɨra uan ingangarim gami? An gumazir ekiam a damutɨ, a ingangarir gumazir igharazibar ganam. Egh dughiar an gumazir ekiam ifongezimɨn, a dagheba isɨ ingangarir gumazibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ingangarir gumazir kam ingara itima, an gumazir ekiam izava a batogha an ingangarir kamɨn garima, gumazir kamɨn navir averiam bar an dera. ");
INSERT INTO msy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ezɨ kɨ guizbangɨra ia mɨgei, ingangarir gumazir kamɨn ekiam a damightɨma, an an ingangarir gumazir mabar ekiamɨn ikɨva an biziba bar dar ganam. ");
INSERT INTO msy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Eghtɨ ingangarir gumazir kam guizbangɨra ikuvigh, egh kamaghɨn nɨghnɨgham, ‘Nan ekiam zuamɨra izeghan kogham.’ ");
INSERT INTO msy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Egha uaghan a ko ingarir darazi mɨsoghɨva, dɨpar onganibar amɨva, gumazir dɨpar onganiba apiba ko ikiam. ");
INSERT INTO msy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Eghtɨ an ekiam, dughiar an ingangarir gumazim a bagha garir puvatɨzimɨn, an otogham. A dughiar a fozir puvatɨzimɨn uamategham. ");
INSERT INTO msy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ingangarir gumazir kamɨn gumazir ekiam bar pazav, a damigh, ivezir bar kuram a danɨngam. Egh a isɨva ifavaribagh amir gumazibar tongɨn anetɨgham. Eghtɨ a danganir kamɨn ikɨva, arang atariba kuskugh ikɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Egha Iesus mɨgɨa ghua Gumazibar Otarim ua izamin dughiam mɨgei, “God Bizibagh Ativamin Dughiam mati, guivir igiar 10 plan eghaghanimɨn mɨn mangam. Gumazir mam igiamra amuimɨn ikiasa izi. Ezɨ guivir igiar maba uan lamba inigha tuavimɨn anapuasa zui. ");
INSERT INTO msy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Men 5 pla, nɨghnɨzir aghuiba itima, 5 pla nɨghnɨzir aghuiba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Egha 5 plan nɨghnɨzir aghuiba itir puvatɨziba, uan lamba isa, da bagha borer taba inizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ezɨ guivir igiar nɨghnɨzir aghuiba itiba, uan lamba isa, egha uaghan borem itir mɨsevir maba sara, ini. ");
INSERT INTO msy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ezɨma gumazir amuimɨn ikiamim zuamɨra izezir puvatɨ, ezɨ guivir kaba pariam men azima, me akui. ");
INSERT INTO msy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ezɨ dɨmagarir arɨzimɨn gumazir mam dia ghaze, ‘Gumazir amuimɨn ikiamim, a roghɨra izi. Ia izɨ, e mangɨ, tuavimɨn a batogh a ko izam.’ ");
INSERT INTO msy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ezɨ guivir igiar kaba dɨkavigha uan lambar kɨri. ");
INSERT INTO msy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ezɨ guivir nɨghnɨzir aghuiba puvatɨziba, nɨghnɨzir aghuim itibar aza ghaze, ‘En lamba mungasava ami. Kamaghɨn, ia borer taba e danɨng.’ ");
INSERT INTO msy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ezɨ nɨghnɨzir aghuim itir guiviba, me ikarvagha kamaghɨn mɨgɨa ghaze, ‘Puvatɨgham! Borem bar en tughatɨghan kogham. Ia mangɨ, borer amadir danganitamɨn uari bagh tabagh ivesegh.’ ");
INSERT INTO msy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ezɨ guivir nɨghnɨzir aghuiba puvatɨzir kaba ghuezɨma, gumazir amuimɨn ikiamim oto. Ezɨ guivir boreba itiba, a ko isar ekiam bagha dɨpenimɨn aven ghue. Ezɨ gumaziba tiam asara. ");
INSERT INTO msy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ezɨ gɨn guivir ghueziba uamategha iza kamagh mɨgei, ‘Ekiam! Ekiam, nɨ izɨ e bagh tiam kuigh.’ ");
INSERT INTO msy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ezɨ a me ikarvagha kamaghɨn mɨgei, ‘Kɨ guizbangɨra ia mɨgei, kɨ ia gɨfozir puvatɨ.’” ");
INSERT INTO msy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Egha Iesus ghaze, “Kamaghɨn, ia deraghavɨra gan. Ian Ekiam, aruem ko dughiar ia fozir puvatɨzimɨn, an otogham.” ");
INSERT INTO msy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “God Bizibagh Ativamin Dughiam mati, gumazir mam nguibar saghon itimɨn mangasava ami moghɨn. Gumazir kam uan ingangarir gumazibar diazɨ me izima, a uan biziba isɨ, me danightɨma, me a bagh dar ganam. ");
INSERT INTO msy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A gumazibar araziba ko gavgavibar gara, dagɨaba tuiragha da isa me ganɨngi. A mav 5,000 Kina a ganɨga, mav 2,000 Kina a ganɨga, mav 1,000 Kina a ganɨngi. A kamaghɨn amigha ghu. ");
INSERT INTO msy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","A ghuzɨma, gumazir 5,000 Kina inizim maghɨra an ingara, 5,000 Kinan mam dagh isɨn uam a ini. ");
INSERT INTO msy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ezɨ gumazir 2,000 Kina inizim kamaghɨra amua, uaghan 2,000 Kinan mam dagh isɨn uam a ini. ");
INSERT INTO msy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ezɨ gumazir 1,000 Kina inizim ghua mozim okoregha uan ekiamɨn dagiaba isava mozim gatɨgha egha da modo. ");
INSERT INTO msy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ezɨ gumazir ekiam dughiar ruarimɨn saghon ikegha uamategha ize. Egha uan ingangarir gumazibar ingangaribagh fofoghasa men dei. ");
INSERT INTO msy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ezɨ gumazir 5,000 Kina inizim, 5,000 Kinan mam a dibagha, a inigha iza kamaghɨn mɨgei, ‘Ekiam, nɨ 5,000 Kina na ganɨngi. Nɨ ge, kɨ dagɨar ingangarim gamua, 5,000 Kinan mam dagh isɨn uam a ini.’ ");
INSERT INTO msy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ezɨ an ekiam kamaghɨn a mɨgei, ‘Nɨ ingangarir gumazir aghuim, nɨ ingangarir aghuim gami. Nɨ bizir doziba deravɨra dar gari. Kamaghɨn amizɨma, nɨ ingangarir ekiabar ganasa, kɨ ifonge. Nɨ izɨ uan ekiamɨn isamɨn aven ikɨ, egh a ko bar akuegham.’ ");
INSERT INTO msy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ezɨ gumazir 2,000 Kina inizim iza kamaghɨn mɨgei, ‘Ekiam, nɨ 2,000 Kina na ganɨngi. Nɨ ge, kɨ dagɨar ingangarim gamua, 2,000 Kinan mam dagh isɨn uam a ini.’ ");
INSERT INTO msy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ezɨma an ekiam kamaghɨn a mɨgei, ‘Nɨ ingangarir gumazir aghuim, nɨ ingangarir aghuim gami. Nɨ bizir doziba deravɨra dar gari. Kamaghɨn amizɨma, nɨ ingangarir ekiabar ganasa, kɨ gifonge. Nɨ izɨ, uan ekiamɨn isamɨn aven ikɨ, egh a ko bar akuegham.’ ");
INSERT INTO msy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ezɨ gumazir 1,000 Kina inizim uaghan izava, egha kamaghɨn mɨgei, ‘Ekiam, kɨ fo, nɨ gumazir apangkuviba puvatɨzim. Nɨ gumazir igharaziba oparir azeniba, nɨ uaghan daghebagh tui. Egha gumazir igharazim dagher ovɨziba akurima, nɨ uaghan pura dar aghafi. ");
INSERT INTO msy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kamaghɨn amizɨ, kɨ atiatingi, egha nɨn 1,000 Kina inigha ghua nguazir mozim gatɨgha egha da modo. Nɨn dagɨabar kara.’ ");
INSERT INTO msy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ezɨ an ekiam a ikaragha kamaghɨn a mɨgei, ‘Nɨ ingangarir gumazir kuram! Nɨ gumazir amɨrɨzim. Nɨ na gɨfo, kɨ gumazir igharaziba oparir azenibar daghebagh tui. Egha uaghan gumazir igharazim dagher ovɨziba akurima, kɨ uaghan pura dar aghavam. ");
INSERT INTO msy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ezɨ nɨ tizim bagha nan dagɨaba isava, dagɨabar ingaribagh amir dɨpenitam gatɨzir puvatɨ? Eghtɨ kɨ ua izɨva, uan dagɨaba iniva dagɨar igharazitaba dagh isɨn da iniam. ");
INSERT INTO msy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kamaghɨn amizɨ, ia ada 1,000 Kina inigh, a isɨva 10,000 Kina itir gumazim danɨngigh. ");
INSERT INTO msy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Arazim kamaghɨn iti, gumazir biziba itiba, kɨ ua taba me danɨngam. Egh gumazir biziba puvatɨziba, bizir vaghvazir me itiba kɨ uaghan me dama, da inigham. ");
INSERT INTO msy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ezɨ ingangarir gumazir bar kurar kam, ia a isɨ, azenan itir danganir mɨtatemɨn anekunigh. Danganir kamɨn me puvɨra tuangɨva arang, atariba kuskugh ikiam.’” ");
INSERT INTO msy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Gumazibar Otarim, Atrivimɨn mɨn otogh uamategh uan enselba bar me ko izɨva, egh uan atrivir dabirabim daperagham. ");
INSERT INTO msy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eghtɨ nguazimɨn itir gumazamiziba bar izɨva an guamɨn uari akuvagham. Eghtɨ a me tuiragh, egh bɨzir pumuning damuam, mati sipsipbar garir gumazim sipsipba isava, bɨzir mamɨn me amaga, memeba bɨzir mamɨn me amadi. ");
INSERT INTO msy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","A sipsipba isɨ agharir guvimɨn da amang, egh memeba isɨ agharir ikɨriamɨn amangam. ");
INSERT INTO msy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Egh Atrivim kamaghɨn agharir guvimɨn itir gumazamizibav kɨmam, ‘Ia izɨ, nan Afeziam deragh ia damuasa ifonge! Ia izɨva, danganir Afeziam fomɨra ia bagha inabazim inigh, a nguazir kam otozir dughiamɨn a ia bagha danganir kam akɨri. ");
INSERT INTO msy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kɨ faragha mɨtiriam nan azima, ia dagheba na ganɨngi; ezɨ kuarim nan pɨrima, ia dɨpam na ganɨngi; ezɨ kɨ nguibar igharazimɨn gumazimɨn mɨn itima, ia na inigha uan dɨpenimɨn ghu; ");
INSERT INTO msy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ezɨ kɨ bibiamra itima, ia korotiaba na ganɨngi; ezɨ kɨ areima, ia nan akurvasi; ezɨ kɨ kalabusɨn itima ia iza nan gari. Kamaghɨn, ia aven izɨ.’ ");
INSERT INTO msy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Eghtɨ gumazamizir aghuiba kamaghɨn a ikaragham, ‘Ekiam, dughiar manamra, mɨtiriam nɨn azima, e dagheba nɨ ganɨngi? Ezɨ dughiar manam, kuarim nɨn pɨrima, e dɨpam nɨ ganɨngi? ");
INSERT INTO msy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ezɨ dughiar manam, nɨ nguibar gumazir igharazimɨn mɨn itima, e nɨ inigha uan dɨpenibar ghue? Ezɨ dughiar manam, nɨ bibiamra itima, e korotiaba nɨ ganɨngi? ");
INSERT INTO msy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ezɨ dughiar manam, nɨ areima, en nɨn akura, o nɨ kalabusɨn itima, e ghua nɨn gani?’ ");
INSERT INTO msy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Eghtɨ Atrivim me ikaragh kamaghɨn me mɨkɨmam, ‘Kɨ guizbangɨra ia mɨgei, arazir ia nan gumazamizir kɨnibagh amiba, ia dar na gami.’ ");
INSERT INTO msy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Egh Atrivim uan agharir ikɨriamɨn itir darazi kamaghɨn me mɨkɨmam, ‘Ia na gitagh! Ia Godɨn anɨngagharimɨn aven itir darasi! Ia mangɨ, avir munger puvatɨzimɨn mangɨ. Avir kam, me Satan uan enselba ko me bagha anetɨzɨma a iti. ");
INSERT INTO msy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kɨ faragha mɨtiriam nan azima, ia daghetam na ganɨngizir puvatɨ; ezɨ kuarim nan pɨrima, ia dɨpatam na ganɨngizir puvatɨ; ");
INSERT INTO msy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ezɨ kɨ nguibar igharazimɨn gumazimɨn mɨn itima, ia na inigha uan dɨpenibar ghuzir puvatɨ; ezɨ kɨ bibiamra itima, ia korotiatam na ganɨngizir puvatɨ; ezɨ kɨ areima, ia nan akurazir puvatɨ; ezɨ kɨ kalabusɨn itima, ia ghua nan ganizir puvatɨ. Kamaghɨn, ia na gitagh!’ ");
INSERT INTO msy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Eghtɨ me kamaghɨn a mɨkɨmam, ‘Ekiam, e dughiar manam nɨn gari, mɨtiriam nɨn azi, o kuarim nɨn pɨri, o nɨ nguibar igharazimɨn gumazimɨn mɨn ike, o nɨ bibiamra ike, o nɨ arei, o nɨ kalabusɨn iti, ezɨ e deravɨra nɨ gamizir puvatɨ?’ ");
INSERT INTO msy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Eghtɨ a me ikarvagh kamaghɨn me mɨkɨmam, ‘Kɨ guizbangɨra ia mɨgei, arazir ia gumazamizir kɨnibagh amizir puvatɨziba, ia uaghan arazir kabar na gamizir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Eghtɨ gumazamizir kamaghɨn amiziba mangɨ, ivezir kuram iniam, kar mɨzazir gɨvan koghamim. Eghtɨ gumazamizir aghuiba mangɨ, ikɨrɨmɨrir aghuir zurara itim iniam.” ");
INSERT INTO msy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesus mɨgɨrɨgɨar kaba da gɨfa, egha uan suren gumaziba kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ia fo, aruer pumuning gɨvaghtɨma, God Israelbagh Itazir Dughiamɨn isar ekiam otivam. Eghtɨ me Gumazibar Otarim isɨva apanibar agharim datɨghtɨma me a isɨva temer ighuvim gafugham.” ");
INSERT INTO msy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dughiar kamɨn, ofa gamir gumazir ekiaba koma Judan arazibagh fozir gumaziba ghua, ofa gamir gumazibar dapanimɨn dɨpenimɨn uari akufa. Gumazir kamɨn ziam Kaiafas. ");
INSERT INTO msy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Egha me arazir mogometamɨn Iesusɨn suiragh a mɨsueghtɨ an aremeghasa tuaviba buria, akabav sosi. ");
INSERT INTO msy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Egha me kamagh uariv gei, “E isar ekiamɨn dughiamɨn an suighan kogham. E damutɨ, gumazamizir isamɨn itiba men naviba osemegh, egh mɨdorozir dafatam damigham.” ");
INSERT INTO msy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ezɨ Iesus ghua Betanin nguibamɨn ikia, Saimonɨn dɨpenimɨn iti, Saimon faragha arɨmariam lepa an mɨkarzim gami. ");
INSERT INTO msy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Dughiar kamɨn Iesus dagher dakozimɨn aperaghav itima, amizir mam, borer mughuriar aghuim zuir mam, inigha izi. Borer aghuir kamɨn mɨsevim, me dagɨar ziam alabastan an ingari. Ezɨ borer kamɨn ivezim bar pɨn iti. Ezɨ amizir kam borer kam isava, Iesusɨn dapanim ginge. ");
INSERT INTO msy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ezɨ an suren gumaziba kamaghɨn an gara, navir averiaba ikufi. Egha me ghaze, “Tizim bagha kav borer mughuriar aghuim zuim pazava a gami? ");
INSERT INTO msy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","E anemaga dagɨar ekiatam inigha egha a isava asaghasazibagh anighai.” ");
INSERT INTO msy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ezɨ Iesus men mɨgɨrɨgɨabagh fogha kamaghɨn me mɨgei, “Ia tizim bagha osɨmtɨzim amizir kam garɨsi? Anetakigh! An arazir aghuim na gami. ");
INSERT INTO msy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Asaghasaziba zurara ia ko ikiam. Kɨrara, ia ko zurara ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ezɨ amizir kam nan namnam mozim bagh anekɨrasa, borer aghuir kam na ginge. ");
INSERT INTO msy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Kɨ guizbangɨra ia mɨgei, me nguazir kamɨn danganir manamɨn Godɨn akar aghuim akunɨva egh amizir kam amizir arazim uaghan a mɨkɨmɨva egh a gɨnɨghnɨghɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ezɨ dughiar kamɨn Judas Iskariot, a 12 plan suren gumazir mam, a ofa gamir gumazir ekiaba bagha ghu. ");
INSERT INTO msy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Egha a kamaghɨn men azai, “Kɨ Iesus isɨva ian dafaribar atɨghtɨ, ia tizim na danɨngam?” Ezɨ me 30 plan silvan dagɨar ovɨzir maba mega, da isa a ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ezɨ dughiar kamɨn ikegha ghua, Judas, Iesus men dafaribar arɨghasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ezɨ Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam, an faragha zuir dughiam otozɨ, ezɨ Iesusɨn suren gumaziba iza kamaghɨn a mɨgei, “Nɨ danganir manamɨn, e mangɨ, nɨ God Israelbagh Itazir Dughiamɨn isam ramɨsɨ, e bizibar akɨram?” ");
INSERT INTO msy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ezɨ a kamaghɨn me mɨgei, “Ia nguibar ekiamɨn aven mangɨ, egh gumazir kam bagh mangɨ kamaghɨn a mɨkɨm, ‘Tisa ghaze, nan dughiam roghɨra izegha gɨfa. Ezɨ kɨ uan suren gumaziba ko, God Israelbagh Itazir Dughiamɨn isam, e nɨn dɨpenimɨn daghebar amam.’” ");
INSERT INTO msy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ezɨ suren gumaziba Iesus mɨkemezɨ moghɨn ghua God Israelbagh Itazir Dughiam bagha dagheba ko bizibar kɨri. ");
INSERT INTO msy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ezɨ Iesus guaratɨghɨn dagher dakozimɨn uan 12 plan suren gumaziba ko api. ");
INSERT INTO msy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Egha me apava a kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, ian tav na isɨva gumazir nan apanim gamibar agharim darɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ezɨ an suren gumaziba akar kam baregha, naviba bar oseme. Egha me bar vaghvagha kamaghɨn an azangsɨgha kamaghɨn mɨgei, “Ekiam, ti narara, o?” ");
INSERT INTO msy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ezɨ a me ikarvagha kamaghɨn mɨgei, “Gumazir na isɨva apanibar agharim darɨghamim, a uaghan na ko bret isava itarir vamɨra daghuam. ");
INSERT INTO msy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ezɨ Gumazibar Otarim, Godɨn Akɨnafarim mɨkemezɨ moghɨn, an aremegham. Eghtɨ gumazir Gumazibar Otarim isava apanibar agharim gatɨzim, gumaka! A bar ikuvigham! Amebam a batezir puvatɨzɨma, a deraghai!” ");
INSERT INTO msy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ezɨ gumazir Iesus isɨva apanibar agharim darɨghamim, Judas kamaghɨn an azai, “Ekiam, nɨ ti na mɨgɨa, ma?” Ezɨ Iesus ghaze, “Nɨ mɨgei moghɨra!” ");
INSERT INTO msy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ezɨ Iesus uan suren gumaziba ko apa ikiava, a bretɨn mam inigha God mɨnabagha anebigha, a isa uan suren gumazibagh anɨngi. Egha kamaghɨn me mɨgei, “Kar nan nivafɨzim. Ia a inigh aneremɨ.” ");
INSERT INTO msy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ezɨ a wain apir itarir mam inigha God mɨnabagha, egha a isa me ganiga kamaghɨn mɨgei, “Ia bar wainɨn dɨpar kam aneremɨ. ");
INSERT INTO msy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Kar nan ghuzim, an Akar Dɨkɨrɨzir Gavgavim, a gavgavim a ganɨdi. A, gumazamizir avɨribar arazir kuraba gɨn amangasa, nan ghuzim me bagha ire. ");
INSERT INTO msy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kɨ guizbangɨra ia mɨgei, kɨ ua wainɨn ovɨzimɨn dɨpatam rameghan kogh, kamaghɨra ikɨ mangɨ Dughiar Afeziam Bizibagh Ativamimɨn otogham. Eghtɨ dughiar kam, kɨ ia ko wainɨn dɨpar igiam ramam.” ");
INSERT INTO msy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Egha me Godɨn ziam fer ighiar mam gamigha, dɨkavigha Olivɨn Mɨghsɨamɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Egha Iesus kamaghɨn uan suren gumazibav gɨa ghaze, “Ia dɨmagarir kamɨn na bativamin arazibar ganɨva ian nɨghnɨzir gavgavir nan itim gɨvaghtɨma, ia na ategh aregham. Egh Godɨn Akɨnafarim mɨkemezɨ moghɨn otivam, ‘Kɨ sipsipbar garir gumazim mɨsueghtɨma, sipsipba tintinimɨn aregham.’ ");
INSERT INTO msy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Egh kɨ aremegh ua dikavigh ian faragh Galilin Distrighɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ezɨ Pita an akam ikaragha kamaghɨn a mɨgɨa ghaze, “Me ti bar, nɨ bativamɨn arazibar ganɨva, nɨ ataghragh aram, eghtɨ kɨrara nɨ ateghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ guizbangɨra nɨ mɨgei, datɨrɨghɨn dɨmagarir kamɨn nɨ uabɨ dughiar pumuning ko mɨkezim nɨ suam, ‘Kɨ a gɨfozir puvatɨ,’ eghtɨ tuarim gɨn akam.” ");
INSERT INTO msy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ezɨ Pita a mɨgei, “Kɨ nɨ ko ovengsɨva ovengam, kɨ bar kamaghɨn mɨkemeghan kogham. Bar puvatɨgham!” Ezɨ suren gumaziba bar kamaghɨram a mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Egha Iesus uan suren gumaziba ko danganir ziam Getsemanin ghue. Egha kamaghɨn me mɨgei, “Ia kagh dapiagh ikɨ, eghtɨ kɨ munagh mangɨ God ko mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Egha Pita ko Sebedin otarimning inizɨma, me an gɨn ghu. Egha an navim bar a baseme, ezɨ a bar paza uabɨ barasi. ");
INSERT INTO msy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Egha kamaghɨn me mɨgei, “Nan navir averiam, osɨmtɨzim a iteragha ghuaghiri. Ezɨ kɨ aremeghasava ami. Ia kagh ikɨ, egh na ko gan.” ");
INSERT INTO msy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Egha a sɨvagha ghua irɨgha, uan guam isa nguazim gatɨgha egha kamaghɨn God ko mɨgei, “Nan Afeziam nɨ ifueghɨva, nɨ na da osɨmtɨzir kam inigh. Nɨ nan ifongiamɨn gɨn mangan markɨ. Puvatɨ, nɨ uan ifongiamra gɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Egha Iesus dɨkavigha suren gumazir 3 pla bagha ghua garima, me akuavɨra iti. Ezɨ a kamaghɨn Pitan azai, “Manmaghɨn ami? Ia na ko dughiar otevimɨn gan ikian kogham? ");
INSERT INTO msy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ia na bagh deravɨra gan, egh God ko mɨkɨm, eghtɨ osɨmtɨzitam ia damutɨ, ia ireghan kogham. Kɨ fo, ian navir averiaba ifonge, ezɨ nivafɨziba gavgaviba dar pu. Kamaghɨn pariam ian azi.” ");
INSERT INTO msy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Egha a uamategha ghua kamaghɨn Afeziam ko mɨgei, “Nan Afeziam, osɨmtɨzir kam na gitaghan koghtɨ, kɨ anetertɨma, kamaghɨn nɨ uan ifongiamɨn gɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Egha a uamategha suren gumaziba bagha iza gari, me akuavɨra iti. Pariam puv men azi. ");
INSERT INTO msy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ezɨ a me ategha dughiar mɨkezimɨn ghua, faragha Afeziam ko mɨkemezɨ moghɨn ua a ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Egha a gɨn iza suren gumaziba kamaghɨn me mɨgei, “Ia avughsava akuavɨra iti? Arazir kam atakigh! Dughiam oto. Ia gan, Gumazibar Otarim me a isɨva gumazir arazir kurabagh amibar dafarim darɨghasa. ");
INSERT INTO msy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ia dɨkavigh! E mangam! Ia gan. Gumazir na isɨva apanibar anɨngamim, a muna izi!” ");
INSERT INTO msy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesus kamaghɨn mɨgɨavɨra itima, Judas oto, a 12 plan suren gumazibar mav. Ezɨ gumazir avɨrir ekiam iza asianiba ko mɨdorozir sababa inigha Judas ko izi. Ofa gamir gumazir ekiaba ko gumazir dapaniba, me amadazɨ me Iesus bagha izi. ");
INSERT INTO msy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gumazir Iesus isɨ men dafaribar arɨghasava amim faragha ghaze, “Kɨ arazir kam ian akagham. Gumazir kɨ toramim, anarɨra Iesus. Ia an suiragh.” ");
INSERT INTO msy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Egha a Iesus bagha ghuavɨra ikia ghaze, “Tisa, dɨmagarir aghuim,” egha an tore. ");
INSERT INTO msy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Namakam, nɨ damuasa izezir bizim, nɨ zuamɨra a damu.” Ezɨ gumaziba izava Iesusɨn agharibagh iregha, pamtem an suiki. ");
INSERT INTO msy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ezɨ gumazir Iesus ko itir mam, uan mɨdorozir sabam asigha, ofa gamir gumazibar dapanimɨn ingangarir gumazimɨn kuarim atu, ezɨ kuarim dutuaghirɨ. ");
INSERT INTO msy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Nɨ ua uan sabam isɨ an mɨsevim darugh. Gumazir sababar igharazibav soziba, me sababaram arɨghiram. ");
INSERT INTO msy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Egha nɨ ti kamaghɨn fozir puvatɨ? Kɨ ifueghɨva uan Afeziamɨn azaraghtɨ, a mɨdorozir enselɨn avɨriba amadagham, men dɨbobonim 12 plan amibagh afira. Eghtɨ me izɨ nan akuragham. ");
INSERT INTO msy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Egh kɨ kamaghɨn damightɨma, Godɨn Akɨnafarim mɨkemezir mɨgɨrɨgɨaba otivan kogham. Godɨn Akɨnafarim na bativamin bizir kabav keme.” ");
INSERT INTO msy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Egha Iesus maghɨrama gumazir an suighasa izeziba kamaghɨn me mɨgɨa ghaze, “Kɨ okɨmakɨar gumazim puvatɨ. Ia tizim bagha nan suighasa mɨdorozir sababa koma asianiba atera izi? Kɨ zurara ia ko ikia, Godɨn Dɨpenimɨn mɨriamɨn aven gumazamizibar sure gami. Ezɨ ia nan suighan aghua. ");
INSERT INTO msy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ezɨ Godɨn Akɨnafarimɨn Osizirim mɨkemezɨ moghɨra ia kamaghɨn na gami.” Ezɨma Iesusɨn suren gumaziba bar aneteghava are. ");
INSERT INTO msy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ezɨ gumazir Iesusɨn suighiziba a inigha, ofa gamir gumazibar dapanim, Kaiafasɨn dɨpenimɨn ghue. Ezɨ Judan arazibagh fozir gumaziba ko gumazir dapaniba izava uari akuvagha iti. ");
INSERT INTO msy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ezɨ Pita mong tɨzim a gatɨgha Iesusɨn gɨn ghua bar ghua, ofa gamir gumazibar dapanimɨn dɨpenimɨn dɨvazimɨn aven ghu. Egha Godɨn Dɨpenimɨn garir polisba ko aperaghav iti. Egha a me Iesus gamir arazibar ganasa. ");
INSERT INTO msy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dughiar kam, ofa gamir gumazir ekiaba koma Judan kotɨn aven itir gumaziba bar, Iesus akar ifavaribar agasasa tuaviba buri. Me nɨghnɨgha ghaze, me an arazir kuratam batogh amɨsueghtɨ an aremegham. ");
INSERT INTO msy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Egha me tam batozir puvatɨ. Ezɨ gumazir avɨriba iza akar ifavariba isa Iesus gasi. Ezɨ gɨn gumazir pumuning iza, ");
INSERT INTO msy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kotɨn aven mɨgɨa ghaze, “Gumazir kam kamaghɨn mɨgei, ‘Kɨ Godɨn Dɨpenim akarigh, egh aruer pumuning ko mɨkezimɨn uam an ingarigham.’” ");
INSERT INTO msy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ezɨ ofa gamir gumazibar dapanim tugha kamaghɨn Iesusɨn azai, “Nɨ akatam ikarvaghan aghua? Me nɨ gasir akar kam, a guizbangɨra, o?” ");
INSERT INTO msy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ezɨ Iesus nɨmɨra ikia mɨgɨrɨgɨatam gamir puvatɨ. Ezɨ ofa gamir gumazibar dapanim a mɨgɨa ghaze, “Kɨ akar gavgavim nɨ ganɨdi, nɨ Godɨn zurara itimɨn ziamɨn akakagh, egh guizbangɨra e mɨkɨm. Nɨ ti, God Uam E Iniasa Mɨsevezir Gumazim, nɨ ti Godɨn Otarimra, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ezɨ Iesus kamaghɨn a mɨgɨa ghaze, “Are, nɨ mɨkemezɨ moghɨra. Egha kɨ ia mɨgei, nɨ gɨn gantɨ, Gumazibar Otarim gavgavim itir Godɨn agharir guvim daperagham, egh overiamɨn ghuariabagh isɨn izam.” ");
INSERT INTO msy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ezɨ ofa gamir gumazibar dapanim uan korotiam abigha kamaghɨn mɨgei, “A Godɨn ziam gasɨghasɨsi! E tizim bagh ua akar akurvaziba buriam? Markiam! Ia datɨrɨghɨn uari a barasi, a mɨgɨrɨgɨar kurabar Godɨn ziam gasɨghasɨsi! ");
INSERT INTO msy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ezɨ ia manmaghɨn a gɨnɨghnɨsi, e arazir manatamɨn a damuam?” Ezɨ me a ikarvagha ghaze, “An arazir kuram gami, kamaghɨn an ovengam.” ");
INSERT INTO msy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Egha me Iesusɨn guam giparava a mɨsogha, marazi dafariba onegha a mɨsosi. ");
INSERT INTO msy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Egha ghaze, “Nɨ, God Uam E Iniasa Mɨsevezir Gumazim! Nɨ Godɨn akam inigha izir gumazibar arazitam damuva, egh e mɨkɨm, ‘Kar gumazir manam nɨ mɨsosi?’” ");
INSERT INTO msy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ezɨ Pita dɨpenimɨn dɨvazimɨn aven an mɨriamɨn aperaghav iti. Ezɨ ingangarir amizir mam an boroghɨra iza ghaze, “Nɨ uaghan Galilin gumazim Iesus ko ike.” ");
INSERT INTO msy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ezɨ Pita uabɨn ghuara, ezɨ me bar an garima, a ghaze, “Nɨ mɨgeir akar kam, kɨ a gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Egha gɨn ghua dɨpenimɨn dɨvazimɨn itir tiar akar ekiamɨn ghua tughav iti. Ezɨ ingangarir amizir igharazir mam iza an ganigha, gumazamizir an boroghɨn itiba kamaghɨn me mɨgɨa ghaze, “Gumazir kam, a Nasaretɨn gumazim Iesus ko ike.” ");
INSERT INTO msy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ezɨ Pita ua uabɨn ghuaragha ghaze, “Bar guizbangɨra, kɨ Godɨn damazimɨn ia mɨgei, kɨ gumazir kam gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ezɨ gɨn gumazir roghɨra tuivighav itiba iza kamaghɨn Pita mɨgei, “Bar guizbangɨra, nɨ men mavɨra, nɨ men mɨrara mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ezɨ Pita ua bagha pamten mɨgɨa ghaze, “Bar guizbangɨra kɨ Godɨn damazimɨn ia mɨgei, kɨ gumazir kam gɨfozir puvatɨ. Kɨ ifartɨma, God na gasɨghasɨgh.” A kamaghɨn mɨkemegha gɨvazɨ, tuarim maghɨram ake. ");
INSERT INTO msy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ezɨ Pita Iesus mɨkemezir mɨgɨrɨgɨam ginɨrɨ, “Tuarim tɨghar akegham, eghtɨ nɨ faraghvɨra dughiar pumuning ko mɨkezim, na mɨkɨm suam, nɨ na gɨfozir puvatɨ.” Egha Pita azenimɨn ghua bar puvɨrama azi. ");
INSERT INTO msy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ezɨma amɨnim dutuzɨma ofa gamir gumazir ekiaba ko Judan gumazir dapaniba Iesus mɨsueghtɨma an aremighasa akabar kɨri. ");
INSERT INTO msy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Egha me gɨn senbar a ike, egha a inigha ghua Romɨn gavmanɨn gumazir ekiam Pailatɨn agharim gatɨ. ");
INSERT INTO msy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ezɨ Judas, gumazir Iesus isava apanibar agharim gatɨzim, a garima me paza Iesus gamuava a isa kotiam garɨgha, egha ghaze, an aremegham. Ezɨ Judas gara ghaze, kɨ uabɨ arazir kuram gami. Egha uan nɨghnɨzibagh ira. Egha dagɨar silvan 30 plan ofa gamir gumazir ekiaba ko Judan gumazir dapaniba a ganɨngiziba inigha ua me danɨngasa zui. ");
INSERT INTO msy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Egha ghua kamaghɨn mɨgei, “Kɨ Godɨn damazimɨn arazir kuram gami. Gumazir kɨ ian dafaribagh atɨzim, arazir kuratam gamizir puvatɨ. Ezɨ ia purama a mɨsueghtɨ an aremegham.” Ezɨ me an akam ikaragha kamaghɨn mɨgei, “Kar en bizim puvatɨ. Nɨn bizimra.” ");
INSERT INTO msy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ezɨ Judas dagɨar silvan kaba isa Godɨn Dɨpenimɨn mɨriamɨn aven da kunigha, egha ghua uabɨ aguragha areme. ");
INSERT INTO msy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ezɨ ofa gamir gumazir ekiaba, dagɨar silvan kaba inigha ghaze, “Dagɨar kaba, gumazir ghuzimɨn ivezim. E fo, Moses Osirizir Araziba ghaze, e da isɨ ofa gamir dagɨaba sara dar atɨghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Egha me akam mɨsuegha dagɨar kaba inigha ghua Mɨnebar Ingangarir Gumazimɨn Nguazim givese. Me ghaze, nguazir otevir kam, gumazir saghon izezibar afamin matmatiamɨn otogham. ");
INSERT INTO msy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kamaghɨn amizɨ, nguazir otevir kam, me ziar kam “Ghuzir Nguazim” a gatɨ. Ezɨ me dughiar kamɨn ikegha iza, datɨrɨghɨn, nguazir kam me ziar kamra a garɨgha iti. ");
INSERT INTO msy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kamaghɨn amizɨ, Godɨn akam inigha izir gumazim Jeremaia mɨkemezir akaba guizɨn otifi. A kamaghɨn mɨgɨa ghaze, “Me 30 plan silvan dagɨaba ini, kar Israelba gumazir kam givezasa atɨzir ivezim. ");
INSERT INTO msy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Egha Ekiam na mɨkemezɨ moghɨra, me dagɨar kabar Mɨnebar Ingarir Gumazimɨn Nguazim givese.” ");
INSERT INTO msy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ezɨ Iesus ghua gavmanɨn gumazir ekiam Pailatɨn damazimɨn tuzɨma Pailat kamaghɨn an azai, “Nɨ Judabar atrivim, o?” Ezɨ Iesus ghaze, “Are, nɨ mɨkemezɨ moghɨra.” ");
INSERT INTO msy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ezɨ ofa gamir gumazir ekiaba koma Judabar gumazir dapaniba akar avɨriba isava Iesus gasi. Ezɨ a men akatam ikarvazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kamaghɨn amizɨ, Pailat ua kamaghɨn an azai, “Nɨ me nɨ gasir akar avɨrir kaba, nɨ da barazi, o?” ");
INSERT INTO msy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ezɨ Iesus Pailatɨn akatam ikarvazir puvatɨ, ezɨ Pailat nɨghnɨzir avɨribagh ami. ");
INSERT INTO msy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Azeniba bar, Romɨn gavmanɨn gumazir ekiam arazir kam gami, a isar ekiar kamɨn dughiamɨn, a kalabusɨn itir gumazitam ateghtɨ, an azenimɨn mangam. Kalabusɨn itir gumazir manam gumazamiziba ifongezim, Pailat a isɨ me bagh anemadagham. ");
INSERT INTO msy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ezɨ dughiar kamɨn gumazir arazir kurabar ziam itir mam, a kalabusɨn iti. An ziam Barabas. ");
INSERT INTO msy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ezɨ gumazamizir avɨriba izava uari akufa, ezɨ Pailat kamaghɨn men azai, “Ia tina gifonge, eghtɨ kɨ ia bagh anetaghragham. Kɨ Barabas ataghragham, o Iesus, me a dɨbora ghaze, ‘Gumazir God Uam E Iniasa Mɨsevezim,’ kɨ anetaghragham?” ");
INSERT INTO msy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat fo, men naviba pura Iesusɨn ikuvigha egha a inigha kotiamɨn ize, egha kamaghɨn men azai. ");
INSERT INTO msy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Egha Pailat uaghan kotiabagh amir dabirabimɨn aperaghav itima, an amuim a bagha akam amaga mɨgɨa ghaze, “Kɨ dɨmangan irebamɨn arazir kuraba puvatɨzir gumazir kamɨn gani, egha bar oseme. Kamaghɨn, nɨ arazitam a damuan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ezɨ ofa gamir gumazir ekiaba koma Judabar gumazir dapaniba, gumazamizir avɨrimɨn navibagh iniva ghaze, me Pailatɨn azangtɨ, a Barabas ategh, egh Iesus mɨsueghtɨ, an aremegham. ");
INSERT INTO msy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ezɨ gavmanɨn gumazir ekiam ua men aza ghaze, “Ia gumazir manam gifonge, eghtɨ kɨ anetaghragham?” Ezɨ gumazamiziba dia ghaze, “E Barabas gifonge.” ");
INSERT INTO msy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ezɨ Pailat men azai, “Eghtɨ, Iesus me a dɨbora ghaze, ‘God Ua E Iniasa Mɨsevezir Gumazim,’ kɨ manmaghɨn a damuam?” Ezɨ me bar dia ghaze, “A isɨ ter ighuvim gafugh!” ");
INSERT INTO msy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ezɨ Pailat men azai, “Manmagh su? An arazir kurar manam gami?” Ezɨ me bar pamten dia ghaze, “A isɨ ter ighuvim gafugh!” ");
INSERT INTO msy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ezɨ Pailat datɨrɨghɨn fo, me an akatam bareghan kogham. Egha a gari, mɨdorozir ekiam otivasava ami. Egha dɨpam inigha men damazibar uan dafariba rua ghaze, “Gumazir kamɨn ovevem, a nan osɨmtɨzim puvatɨ. Kar ian bizimra.” ");
INSERT INTO msy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ezɨ gumazamiziba a ikarvagha ghaze, “An ovevemɨn osɨmtɨzim mar en ikɨ, egh en boribar ikɨ.” ");
INSERT INTO msy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kamaghɨn amizɨ, Pailat me bagha Barabas ataki. Egha mɨdorozir gumazibav geima, me benibar Iesus ifozoroke. Egha gɨn a isa mɨdorozir gumazibar agharim gatɨ, eghtɨ me a isɨ ter ighuvim gafugham. ");
INSERT INTO msy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ezɨ gavmanɨn gumazir ekiamɨn mɨdorozir gumaziba Iesus inigha, gavmanɨn dɨpenir ekiamɨn mɨriamɨn aven ghuezɨ, mɨdorozir gumaziba bar uari akuvazɨ, Iesus men tongɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Egha me an korotiaba suegha, korotiar aghevir ruarir mam isa a garu. ");
INSERT INTO msy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Egha me benir dɨkonibar atrivibar amianimɨn mɨn an ingari, egha a isa an dapanim garu. Egha difizir mam isava an agharir guvim gatɨzɨ, an an suira. Ezɨ me tevibar apɨra a dɨpova ghaze, “Judabar Atrivim, nɨrara atrivir ekiam!” ");
INSERT INTO msy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Egha me a giparava a suirazir difizim inigha an dapanim mɨsosi. ");
INSERT INTO msy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Me arazir kabar a gamua a dɨpovegha gɨvagha, a da korotiar me a agaghuiziba suegha, ua ananaba agaghui. Egha a isa ter ighuvim a gafughasa an akua zui. ");
INSERT INTO msy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ezɨ mɨdorozir gumaziba Iesus inigha, nguibar ekiam ategha ghua, me Sairinian nguibamɨn gumazir mam bato. An ziam Saimon. Egha me a gakaghorima, a Iesusɨn ter ighuvim gisaghpu. ");
INSERT INTO msy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Egha me ghua danganir mamɨn ziam Golgata, me an otifi. (Danganir kamɨn ziamɨn mɨngarim kamaghɨn, Dapanir Agharir Danganim.) ");
INSERT INTO msy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ezɨ me danganir kamɨn Iesus damasa me dɨpar anɨnganir mam wain sara a veregha, egha mam inigha Iesus ganɨdi. Ezɨ a muziarir mam inigha anetaki. ");
INSERT INTO msy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ezɨ mɨdorozir gumaziba Iesus isava ter ighuvim gafu. Egha an korotiaba tuiragh uari danɨngasa satu gikararai. ");
INSERT INTO msy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Egha danganir kamɨn apiagha anesavsuisi. ");
INSERT INTO msy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Me an dapanim gisɨn, an kotim gamizir mɨgɨrɨgɨam osiri. Me osirizir akam ghaze, “Kar Iesus, a Judabar Atrivim.” ");
INSERT INTO msy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Me gumazir okɨava mɨdorozibagh amizir pumuning, Iesusɨn boroghɨn uaghan aning agura. Me mav isa Iesusɨn agharir guvimɨn itir ter ighuvim gafu, egha mav isa agharir ikɨriamɨn itir ter ighuvim gafu. ");
INSERT INTO msy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ezɨ gumazamiziba mangɨ izegh gamua Iesus dɨpova, uan dapaniba roava a dɨpova ghaze, ");
INSERT INTO msy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nɨ, gumazir Godɨn Dɨpenim akarigh aruer pumuning ko mɨkezimɨn uam an ingarasa mɨkemezim! Nɨ uabɨ uabɨn akuragh! Egh nɨ guizbangɨra Godɨn Otarim, nɨ ter ighuvim ategh izighirɨ.” ");
INSERT INTO msy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ezɨ kamaghɨra ofa gamir gumazir ekiaba ko Judabar arazibagh fozir gumaziba ko Judabar gumazir dapaniba izava a dɨpova ghaze, ");
INSERT INTO msy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A gumazir igharazibar akurvasi, egha uabɨ uabɨn akurvaghan ibura. A Israelbar Atrivim, kamaghɨn a ter ighuvim ategh izighirɨ, eghtɨ e nɨghnɨzir gavgavim an ikiam. ");
INSERT INTO msy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A nɨghnɨzir gavgavim Godɨn ikia, egha ghaze, kɨ Godɨn Otarim. Eghtɨ God guizbangɨra ifongiam an ikɨva, datɨrɨghɨn an akuraghtɨ, e ganika!” ");
INSERT INTO msy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ezɨ kamaghɨra okɨmakɨar gumazir Iesus boroghɨn ter ighuvimningɨn guraghav itimning, uaghan akar kabar a dɨpova a mɨgei. ");
INSERT INTO msy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ezɨ aruem iza pazaghar torim gatima, mɨtatem nguazimɨn itir nguibaba bar da avaragha ghua, dughiam ghua 3 kloghɨn guaratɨzimɨn tu. ");
INSERT INTO msy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Egha dughiam 3 kloghɨn boroghɨra izima, Iesus pamten kamaghɨn dei, “Eli, Eli, lama sabaktani?” Akar kamɨn mɨngarim kamakɨn, “Nan God, nan God, nɨ tizim bagha na ataki?” ");
INSERT INTO msy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ezɨ gumazir an boroghɨn tuivighav itiba akar kam baregha ghaze, “Gumazir kam ti Elaijan dei.” ");
INSERT INTO msy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Egha men mav zuamɨra ivegha ghua dɨpamɨn suizir bizir mam inigha wainɨn afangtɨzim isava a gatɨ. Ezɨ wain a gizɨvazɨma, an a isa aghorir mam gatɨ. Egha aneremasa a isa Iesusɨn amadi. ");
INSERT INTO msy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ezɨ marazi mɨgɨa ghaze, “Ia tegh, e ganika, Elaija ti izɨva an akuragham, o puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ezɨ Iesus ua pamtem diagha uan duam suegha areme. ");
INSERT INTO msy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ezɨ dughiar kamra, Godɨn Dɨpenimɨn guraghav itir inir ekiam pɨn ikegha tongɨra bigha, ghuaghira vɨn otogha akuar pumuning irɨ. Ezɨ mɨkɨmkɨzim otozɨma, dagɨar ekiaba bɨaghire. ");
INSERT INTO msy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ezɨ matmatiaba kuaghɨrima, Godɨn gumazamizir avɨrir ariaghreziba ua dikavigha, ");
INSERT INTO msy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","egha uan moziba ataki. Eghtɨ gɨn Iesus dɨkavightɨma, me nguibar ekiam Jerusalemɨn aven mangam. Eghtɨ avɨrir ekiam men ganam. ");
INSERT INTO msy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ezɨ 100 plan mɨdorozir gumazibar garir gumazir ekiar mam, uan mɨdorozir gumaziba ko, me garima mɨkɨmkɨzim otozɨma, arazir kaba otivima, me bar puvɨram atiati. Egha me kamaghɨn mɨgei, “Bar guizbangɨra, gumazir kam Godɨn Otarimra.” ");
INSERT INTO msy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amizir avɨriba uaghan izegha iti. Me Galilin Distrigh ategha Iesusɨn akurvaghasa an gɨn ize. Amizir kaba mong saghon tuivighav ikia gari. ");
INSERT INTO msy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Men tongɨn, Makdalan nguibamɨn amizim Maria, ko Jems ko Josepɨn amebam Maria, ko Sebedin otarimningɨn amebam. ");
INSERT INTO msy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ezɨ amɨnim pɨrasava amima, Arimatean nguibar ekiamɨn gumazir mam izi. An ziam Josep, a dagɨar avɨriba itir gumazim. ");
INSERT INTO msy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","A uaghan Iesusɨn suren gumazir mam. Egha Pailat bagha ghua Iesusɨn kuam iniasa an azai. Ezɨ Pailat mɨdorozir gumazibav kemezɨ, me Iesusɨn kuam isa Josep ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ezɨ Josep a inigha inir ghurghurir aghuir mamɨn a rɨki. ");
INSERT INTO msy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Egha an kuam inigha ghua, a isa ua bagha okorezir mozir igiam gatɨ. Egha Josep dagɨar ekiar mam poghpuegha ghua mozimɨn akam gasaragha, anepɨri. A kamaghɨn amigha ghu. ");
INSERT INTO msy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ezɨ Maria, Makdalan nguibamɨn amizim, koma Marian igharazir mam, aning mozimɨn boroghɨn aperaghav ikia, an gara iti. ");
INSERT INTO msy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ezɨ Sabat bagha bizibar kɨrir dughiam gɨfa, ezɨ an gɨn izir dughiamɨn ofa gamir gumazir ekiaba ko Farisiba Pailat bagha ghue. ");
INSERT INTO msy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Me ghua kamaghɨn a mɨgei, “Gumazir ekiam, e gumazir ifavarir kam ikia mɨkemezir mɨgɨrɨgɨar mam ginɨrɨ. A ghaze, ‘Aruer pumuning ko mɨkezim gɨvaghtɨma kɨ ua dɨkavam.’ ");
INSERT INTO msy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kamaghɨn amizɨ, nɨ mɨkemeghtɨ, me mozim aruer pumuning ko mɨkezimɨn deragh anepɨrigh. Puvatɨghtɨma, an suren gumaziba an kuam okemegh, egh gumazamizibav kɨm suam, a ua dɨkafi. Eghtɨ an ifavarir akar kam, a faragha amizir ifavarir akam gafiragham.” ");
INSERT INTO msy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ezɨ Pailat kamaghɨn me mɨgei, “Ia mangɨ, mɨdorozir gumaziba inigh me mɨkɨmtɨma, me mozimɨn gan ikɨ. Egh ia mangɨ, mozim apɨrasa ifongezɨ moghɨn, ia damuva, egh bar anepɨrigh.” ");
INSERT INTO msy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ezɨ me ghua mozim apɨri. Egha ifevimɨn mɨn bizir mam mozir akam gighufa, egh me fogham, gumazitam dagɨam gɨraghan kogham. Egha mɨdorozir gumaziba ataghizɨma, me mozimɨn gara iti. ");
INSERT INTO msy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ezɨ Sabatɨn dughiam gɨvazɨma, Sanden bar mɨzaraghara aruem anadima, Makdalan amizim Maria, ko Marian igharazim uamategha mozimɨn ganasa izi. ");
INSERT INTO msy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ezɨ mɨkɨmkɨzir ekiam maghɨram oto. Ezɨ Godɨn enselɨn mam Godɨn Nguibam ategha izaghɨra, dagɨar Iesusɨn mozir akamɨn itim poghpuegha, mong mozir apɨnimɨn ghugha, egha dagɨam gaperaghav iti. ");
INSERT INTO msy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Enselɨn ganganim, mati onɨmarim taghtazi moghɨn gari, ezɨ an korotiaba bar ghurghuri. ");
INSERT INTO msy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ezɨ mɨdorozir gumaziba an atiatia, inɨgha egha aremezɨ moghɨn iti. ");
INSERT INTO msy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ezɨ ensel kamaghɨn amizir kamning mɨgei, “Gua atiatingan markɨ. Kɨ fo, gua me ter ighuvim gafuzir gumazim Iesus bagha gara izi. ");
INSERT INTO msy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A kagh itir puvatɨ. A faragha mɨkemezɨ moghɨn ua dɨkavigha gɨfa. Gua izɨ, a kagh irɨghav ikezir danganimɨn gan. ");
INSERT INTO msy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“Egh gua zuamɨra mangɨ, an suren gumazibav kɨm suam, a ua dɨkavigha gɨvagha mozimɨn itir puvatɨ. Ia oragh. A ia bativasa faragha Galilin zui. Ia mangɨ, munagh an ganam. Kɨ bizir kamɨn gun gua mɨkɨmasa ize.” ");
INSERT INTO msy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ezɨ amizimning puv atiatiava, egha uaghan bar akonge. Egha zuamɨra mozim ategha, ivegha Iesusɨn suren gumazibav kɨmasa zui. ");
INSERT INTO msy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ezɨ Iesus tuavimɨn maghɨra aning bato, egha ghaze, “Mɨzarazir aghuim.” Ezɨ aning an boroghɨn ghua, an dagarimning suiragha an ziam fe. ");
INSERT INTO msy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ezɨ Iesus kamaghɨn aning mɨgɨa ghaze, “Gua atiatingan markɨ. Gua mangɨ, nan aveghbuabav kɨm suam, me Galilin mangɨ egh munagh nan ganam.” ");
INSERT INTO msy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amizimning Iesusɨn suren gumaziba bagha zuima, mɨdorozir gumazir mozimɨn gara ikeziba Jerusalemɨn aven ghue. Egha otivizir araziba bar dar gun ofa gamir gumazir ekiabav keme. ");
INSERT INTO msy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ezɨ ofa gamir gumazir ekiaba, Judabar gumazir dapaniba inigha akar mam akɨri. Egha dagɨar avɨribar mɨdorozir gumazibagh ivezegha, ");
INSERT INTO msy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","egha me mɨgɨa ghaze, “Ia kamaghɨn mɨkɨm suam, e akuima, an suren gumaziba dɨmagarimɨn izava an kuam okemegha ghue. ");
INSERT INTO msy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Eghtɨ gavmanɨn gumazir ekiam akar kam bareghtɨma, e uari a ko mɨgɨrɨgɨam akɨram, eghtɨ ia osɨmtɨziba puvatɨgham.” ");
INSERT INTO msy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ezɨ mɨdorozir gumaziba dagɨar kaba inigha, gumazir ekiaba mɨkemezɨ moghɨn ami. Ezɨ akar kam ghua Judabar tongɨn bar ekefegha iza dughiar kamɨn, Judaba kamaghɨra mɨgɨavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ezɨ Iesusɨn suren gumazir 11 pla Galilin ghua, mɨghsɨar a me bativasa mɨkemezimɨn oto. ");
INSERT INTO msy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Egha me Iesusɨn garava an ziam fe, egha men marazi okam nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ezɨ Iesus men boroghɨra iza kamaghɨn me mɨgei, “God nguazim ko overiam gativamin gavgaviba bar na ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kamaghɨn amizɨ, ia nguazimɨn itir nguibaba bar dar mangɨ, gumazamiziba bar me damutɨ, me nan suren gumazamizibar otiv. Eghtɨ ia Afeziamɨn ziam ko, nan ziam, ko Godɨn Duamɨn ziamɨn me ru. ");
INSERT INTO msy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Egh kɨ ia mɨkemezir mɨgɨrɨgɨaba, ia bar da isɨva men sure damu, eghtɨ me dar gɨn mangɨ. Ia deravɨra fogh, kɨ ia ko ikɨvɨra ikɨ mangɨtɨ, nguazir kamɨn dughiam gɨvagham.”");
INSERT INTO msy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kar Godɨn Otarim Krais Iesusɨn akar aghuim. ");
INSERT INTO msy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","God fomɨra uan akam, an akam inigha izir gumazim Aisaia ganɨngi. An an osirizɨma, an akɨnafarimɨn iti. Akar kamra kara. “Ia oragh! Kɨ uan abuir gumazim amadaghtɨma, a faragh mangɨva nɨ bagh tuavim akɨram.” ");
INSERT INTO msy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Gumazir tiarir mam gumaziba puvatɨzir danganimɨn dia ghaze, ‘Ia Ekiam baghɨva tuaviba azenɨva, dar kɨr.’” ");
INSERT INTO msy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kamaghɨn amizɨma Jon izava gumaziba itir puvatɨzir danganimɨn ikiava gumaziba ruava kamaghɨn akam akuri, “Ia navibagh iraghtɨma kɨ ia rueghtɨma God ian arazir kuraba gɨn amadagham.” ");
INSERT INTO msy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","An akar kabav geima Judian Distrighɨn itir nguibaba koma Jerusalemɨn itir gumazamiziba me bar izava uan arazir kurabar gun mɨgeima a Jordanɨn dɨpamɨn me rue. ");
INSERT INTO msy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon, Gumaziba Ruer Gumazim, ana asɨzim kamelɨn arɨzibar ingarizir iniba ikeghava asɨzir inim uan ivariam ike. A inir kaba ikeghava odeziba ko ruarimɨn haniba api. ");
INSERT INTO msy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ezɨ an akam kamaghɨn mɨgei, “Nan gɨn izamin gumazim an gavgavim guizbangɨra nan gavgavim gafira. Kɨ an mɨngarir puvatɨ. Kɨ uaghan aviraghɨva an dagarir asuabar beniba fɨran gavgaviba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kɨ dɨpamɨn ia rue, eghtɨ a gɨn Godɨn Duamɨn ia ruam.” ");
INSERT INTO msy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dughiar kam Iesus Galilin Distrighɨn itir nguibam, Nasaret, ateghava Jon bagha izezɨma, a Jordanɨn dɨpamɨn a rue. ");
INSERT INTO msy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iesus dɨpamɨn aven ikegha azenan otivavɨra ikia garima overiam kuiaghirɨzɨma Godɨn Duam bunbamɨn mɨn mɨghegha a bagha izaghiri. ");
INSERT INTO msy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ezɨ tiarir mam Godɨn Nguibamɨn ikiava kamaghɨn dei, “Nɨ nan Otarim. Kɨ guizbangɨra nɨ gɨfueghava nɨ bagha bar akonge.” ");
INSERT INTO msy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ezɨ Godɨn Duam anemadazɨma a gumaziba itir puvatɨzir danganimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","A ghugha, 40 plan dughiabar danganir kamɨn itima, Satan a gifarasa a gakaghori. A ruarimɨn itir asɨziba ko ikia dar torimɨn itima, Godɨn enselba an garava an akurvasi. ");
INSERT INTO msy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ezɨ me Jon, Gumaziba Ruer Gumazim, inigha kalabus gatɨzɨma, Iesus gɨn Galilin ghugha Godɨn akar aghuim akuri. ");
INSERT INTO msy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A kamaghɨn mɨgei, “Dughiam otogha gɨfa. God Bizibagh Ativamin Dughiam roghɨra ize. Ia navibagh iraghɨva nɨghnɨzir gavgavim Godɨn akar aghuimɨn ikɨ.” ");
INSERT INTO msy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Dughiar mam Iesus Galilin dɨpar mɨriamɨn ghuava Saimon uan dozim Andru ko aningɨn garima, aning osiriba baghava uan iver ekiaba kuri. Aning osiriba isa dagh ivezir gumazimning. ");
INSERT INTO msy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ezɨ Iesus kamaghɨn aning mɨgei, “Gua nan gɨn izɨtɨma kɨ guan akakaghtɨma, gua osiriba isi moghɨn gumaziba iniam.” ");
INSERT INTO msy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aning an akam baraghavɨra uan iveba ategha an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ezɨ a mong sɨvagha ghuava, Sebedin otarim Jems uan dozim Jon ko aningɨn garima aning uan botɨn ikiava uan iver ekiabar kɨri. ");
INSERT INTO msy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","An aningɨn garavɨra aningɨn diazɨma, aning pura uan afeziam Sebedi koma an ingangarir gumaziba ataghizɨma me uan botɨn itima aning Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ezɨ Iesus ko an gɨn zuir darasi Kaperneamɨn ghue. Egha me zuima Sabat otozɨma, a God ko mɨgeir dɨpenimɨn aven ghugha, dɨpenir kamɨn aven itir gumazamiziba men sure gami. ");
INSERT INTO msy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A men sure gamima gumazamiziba bar an akam baregha dɨgavir kuram gami. An mɨgɨrɨgɨar kaba mati gavgavim itir gumazimɨn mɨgɨrɨgɨaba. An mɨgɨrɨgɨaba Judan arazibagh fozir gumazibar mɨgɨrɨgɨabar mɨn zuir puvatɨ. Ezɨ gumazamiziba dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A kamaghɨn me mɨgɨavɨra itima gumazir duar kuram apazazir mam izava God ko mɨgeir dɨpenimɨn aven izegha dei. ");
INSERT INTO msy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","A dia kamaghɨn mɨgei, “Nɨ manmaghɨn e damuasa, Nasaretɨn gumazim Iesus? Nɨ e gasɨghasɨghasa ize? Kɨ nɨ gɨfo, nɨ God amadazir gumazim, nɨ Godɨn damazimɨn zuezir gumazim.” ");
INSERT INTO msy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ezɨma Iesus akar gavgavimɨn kamaghɨn a mɨgei, “Nɨ nɨmɨra ikɨ, egh gumazir kam ategh azenan izegh.” ");
INSERT INTO msy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ezɨ duar kurar kam Iesus bareghava gumazir kam gunabagha aravɨram azenan ize. ");
INSERT INTO msy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ezɨ gumazamiziba bar bizir kamɨn ganigha guizbangɨra dɨgavir kuram gamigha uarira uarir azangsɨsi, “Kar manmaghɨn amizir bizim? A suren arazir igiam e gami. A gavgavim itir akabav gei. A uaghan akar gavgavimɨn duar kurabav geima da an akam barasi.” ");
INSERT INTO msy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","An amizir bizibar eghaghanim zuamɨra Galilin Distrigh bar a garui. ");
INSERT INTO msy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ezɨ Iesus gumazir maba ko God ko mɨgeir dɨpenim ateghava Jems ko Jon sara, me Saimon ko Andrun dɨpenimɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Me ghua garima Saimonɨn asamim ariava mɨkarzim fɨava dakozim girɨghav itima gumazir maba an gun Iesus mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Me a mɨkemezɨma, ezɨ an a bagha ghuava an agharimɨn suiragha a ghufe. Ezɨ an arɨmariam anetaghizɨma a dɨkavigha dagheba me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Guaratɨzir kamra, amɨnim pɨrizɨma me gumazamizir arɨmariar kuraba koma duar kuraba apazaziba bar me inigha Iesus bagha izi. ");
INSERT INTO msy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nguibar kamɨn itir gumazamiziba bar izava dɨpenir kamɨn tiar akamɨn uari akufa. ");
INSERT INTO msy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ezɨma Iesus arɨmariar guar avɨriba itir gumazamizir avɨriba men arɨmariabagh amima me ghuamaghe. A duar kurar avɨriba sarama otoghezɨma da gumazamiziba ategha azenan ize. Duar kuraba a gɨfo, a Godɨn Otarim. Ezɨ kamaghɨn a ghaze, ia kamaghɨn mɨkɨman markɨ suam, Kɨ Godɨn Otarim. Egha a men anogoroke. ");
INSERT INTO msy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Egha amɨmɨzaraghan amɨnim tɨghar itima, Iesus dɨkavigha dɨpenim ategha ghuava gumaziba itir puvatɨzir danganimɨn ghugha God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","A ghuzɨma Saimon uan roroaba ko a buriagharui. ");
INSERT INTO msy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Me ghuava an apighava kamaghɨn a mɨgei, “Gumazamiziba bar nɨ buria gari.” ");
INSERT INTO msy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ezɨ Iesus men akam ikaragha kamaghɨn mɨgei, “E nguibar igharazir roghɨra kagh itibar mangam. Kɨ uaghan munagh Godɨn akam akunam. Kɨ bizir kam bagha ize.” ");
INSERT INTO msy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A kamaghɨn mɨkemegha, egha Galilin Distrighɨn danganiba bar dagh aruava God ko mɨgeir dɨpenibar aven Godɨn akam akurava gumazamizibagh apazazir duar kuraba batosi. ");
INSERT INTO msy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ezɨ gumazir lepa itir mam Iesus bagha izava, an guamɨn aviraghava tevimning apɨrigha puvɨra a gaghori, “Nɨ fueghɨva na damutɨ, kɨ Godɨn damazimɨn zuegh ua deragham.” ");
INSERT INTO msy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesus kamaghɨn oregha, guizbangɨra bar an apangkufi. Egha uan agharim isa gumazir kam gatɨgha ghaze, “Kɨ ifonge. Nɨn mɨkarzim zuegh, egh ua deragh.” ");
INSERT INTO msy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iesus kamaghɨn mɨgɨavɨra itima, lepan arɨmariam zuamɨra gumazir kam ataghizɨma an mɨkarzim ua dera. ");
INSERT INTO msy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ezɨ Iesus gumazir kam amaga akar gavgavimɨn kamaghɨn a mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nɨ oragh. Nɨ bizir kamɨn gun gumazir igharazitam mɨkɨman markɨ. Nɨ mangɨ uan mɨkarzim ofa gamir gumazimɨn akagh. Moses fomɨra mɨkemezir arazim, nɨ arazir kamɨn gɨn mangɨva, uan arɨmariam gɨvazir bizim bagh Godɨn ofa damu. Nɨ damightɨma, me ganigh fogham, nɨn arɨmariam guizbangɨra gɨfa.” ");
INSERT INTO msy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ezɨma gumazir kam Iesus a mɨkemezɨ moghɨn damuan aghuaghava egha bizir kam bar me mɨgei. Kamaghɨn amizɨma maburan avɨrim Iesus akuvazɨma, kamaghɨn a nguibar ekiatamɨn aven azenaram aruir puvatɨ. A uabɨra itir danganimɨn itima, gumazamiziba a bagha tintinibar izavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ezɨ dughiar maba gɨvazɨma, Iesus uamategha Kaperneamɨn ghu. A ghuava dɨpenimɨn itima gumazamizir avɨriba a uamatengezir akam baraki. ");
INSERT INTO msy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Me akar kam baregha izezɨma dɨpenim bar izɨvazɨma an tiar akam sara izɨfa. Ezɨ Iesus Godɨn akam me mɨkɨri. ");
INSERT INTO msy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","An akam akurima, gumazir maba gumazir soroghafariba aremezir mam inigha a bagha izi. Gumazir pumuning ko pumuning akuriamɨn a gisaghpugha izi. ");
INSERT INTO msy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Me iza garima dɨpenimɨn tiar akam bar izɨvazɨma, kamaghɨn me Iesus bagh mangan ibura. Egha me gumazir kam inigha dɨpenir siriamɨn ghuavanabogha dɨpenir siriamɨn torim gamigha beniba akuriam dafegha anemadazɨma a Iesus bagha ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ezɨ Iesus gumazir kabar nɨghnɨzir gavgavimɨn ganigha kamaghɨn soroghafariba amɨrazir gumazim mɨgei, “Nan borim, nɨn arazir kuraba gɨfa.” ");
INSERT INTO msy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iesus kamaghɨn a mɨgeima, Judan arazibagh fozir gumaziba apiaghav ikiava uarira uan navir averiabar kamagh mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Gumazir kam tizim bagha kamaghɨn mɨgei? A Godɨn danganim iniasava ami! Gumazir kɨnitam gumazir igharazitamɨn arazir kuraba gɨn amadaghan kogham. God uabɨra.” ");
INSERT INTO msy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Me kamaghɨn nɨghnɨzima, Iesus zuamɨra uan navir averiamɨn men nɨghnɨzibagh fogha kamaghɨn me mɨgei, “Ia manmagh sua kamaghɨn nɨghnɨsi? ");
INSERT INTO msy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kɨ akar manam mɨkɨmam? Pura gumazir kɨnitam kamaghɨn mɨkɨm suam, kɨ nɨn arazir kuraba gɨn amada. Egh uaghan gumazir kɨnitam kamaghɨn mɨkɨman kogham, nɨ dɨkavigh uan akuriam inigh mangɨ, egh ua deragh. ");
INSERT INTO msy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɨ arazir kam damightɨma, ia ganigh fogham, Gumazibar Otarim a nguazir kamɨn arazir kuraba gɨn amangamin gavgavim iti.” Egha a kamaghɨn gumazir soroghafariba amɨrazim mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kɨ nɨ mɨgei, nɨ dɨkavigh uan akuriam inigh dɨpenimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Egha a mɨgɨavɨra itima me garima gumazir kam dɨkavighava uan akuriam inigha azenan ghu. Gumazamiziba bar an ganigha dɨgavir kuram gamigha Godɨn ziam fava kamaghɨn mɨgei, “E faragha bizir katamɨn ganizir puvatɨ!” ");
INSERT INTO msy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ezɨ Iesus ua Galilin dɨpar mɨriamɨn ghuaghiri. A ghuaghirima, gumazamizir avɨriba izava uari akuvazɨma, a men sure gami. ");
INSERT INTO msy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A men sure gamuava dɨpar mɨriamɨn ghuava Alfiusɨn otarim Livain garima, a gavman danɨngamin dagɨaba isir dɨpenimɨn aperaghav iti. Iesus an garava, kamaghɨn a mɨgei, “Nɨ nan gɨn izɨ.” Ezɨ Livai a baregha, dɨkavigha an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Egha gɨn Iesus Livain dɨpenimɨn ikiava uan suren gumaziba koma api. Dagɨaba isir gumazir avɨriba koma arazir kurabagh amir gumazir avɨriba, me uaghan me koma api. Gumazir kamaghɨn amir avɨriba, me uaghan Iesusɨn gɨn arui. ");
INSERT INTO msy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ezɨ me apa itima, Judan arazibagh fozir Farisin gumaziba me an ganigha, egha an suren gumazibar azangsɨsi, “A manmagh sua dagɨaba isir gumaziba ko arazir kurabagh amir gumaziba koma api?” ");
INSERT INTO msy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ezɨ Iesus men azangsɨzim baregha kamaghɨn me mɨgei, “Arɨmariaba puvatɨzir gumaziba, dokta bagha zuir puvatɨ. Gumazir arɨmariaba itibara, me dokta bagha zui. Kɨ Godɨn damazimɨn derazir gumaziba bagha izezir puvatɨ. Kɨ gumazamizir arazir kurabagh amibar dɨmasa ize!” ");
INSERT INTO msy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ezɨ dughiar mam Jonɨn suren gumaziba koma Farisin suren gumaziba me God ko mɨkɨmasa dagheba ataghrasi. Ezɨ Iesusɨn suren gumaziba dughiar kamɨn apima gumazir maba Iesus bagha izava kamaghɨn an azangsɨsi, “Kar manmaghɨn amizir arazim? Jonɨn suren gumaziba koma Farisin suren gumaziba me datɨrɨghɨn God ko mɨkɨmasa dagheba ataghrazima, nɨn suren gumaziba God ko mɨkɨmasa dagheba ataghrazir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ezɨ Iesus kamaghɨn men azara, “Gumazitam amuimɨn ikiasa isar ekiam gamuava gumazir mabar diazɨma me ize. A me ko ikɨtɨma, me manmaghɨn damuam, me dagheba ategham, o? puvatɨgham. A me ko ikɨtɨma me dagheba ataghraghan kogham. ");
INSERT INTO msy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Me dagheba ataghrazir dughiam iti. Dughiar kam izɨtɨma, gumazitaba amuimɨn ikiamin gumazimɨn suiragh mangɨtɨ me dughiar kam dagheba ataghragham. ");
INSERT INTO msy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Egh gumazitam inir avɨzir igiatam inigha korotiar ghuritam porogha a isamizir puvatɨ. A kamaghɨn damighɨva egh a rutɨma inir avɨzir igiam ekonegh korotiar ghurim gekuigh, anebightɨma an torim guizbangɨra bar ekevegham. ");
INSERT INTO msy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Eghtɨ gumazitam wainɨn igiam inighɨva, asɨzir inir mɨsevir ghurimɨn a ruighan kogham. A kamaghɨn damightɨma wain buva asɨzir inir mɨsevir ghurim bighɨva, wain ko asɨzir inim, aning vɨrara ikuvigham. A kamaghɨn damuan kogham. A wainɨn igiam inigh asɨzir inir mɨsevir igiamra ruigham.” ");
INSERT INTO msy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Egha Iesus Sabatɨn dughiar mamɨn, raizɨn mɨn garir dagher mam, wit, me an azenir ekiamɨn torimɨn zui. An suren gumaziba a ko ghuava witɨn ovɨziba kuara zui. ");
INSERT INTO msy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Me zuima Farisin maba men ganigha kamaghɨn Iesus mɨgei, “Nɨ gan. Me manmagh sua arazir kam gamuava Sabatɨn arazimɨn gɨn zuir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ezɨ Iesus me ikaragha kamaghɨn mɨgei, “Ia, Devit amizir bizim me an osirizɨma a iti, ia an ganizir puvatɨ? A uan gumaziba ko me mɨtiriam men azima a bizir kam gami. ");
INSERT INTO msy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A ghuava Godɨn Dɨpenimɨn aven ghugha God ganɨngizir bretba ame. A da apava, uaghan maba isa uan gumazibagh anɨngizɨma, me uaghan ame. Dughiar kam Abiatar, ofa gamir gumazibar dapanim itima, Devit dame. Judabar arazir kam iti. Bretɨn kaba ofa gamir gumazibara dapi, gumazir kɨniba puvatɨ. Ezɨ Devit, gumazir kɨnim, bretɨn kaba ame.” ");
INSERT INTO msy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Egha Iesus mɨgɨa ghua kamaghɨn me mɨgei, “God gumazibar akurvaghasa Sabat atɨ. A Sabat bagha gumaziba atɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ezɨ Gumazibar Otarim a Sabatɨn dughiamɨn Ekiam.” ");
INSERT INTO msy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","2","Egha dughiar igharazir mam Iesus God ko mɨgeir dɨpenimɨn ghuava, garima dafarim ekonezir gumazir mam gumazamizir avɨribar tongɨn dɨpenir kamɨn aven iti. A itima gumazir maba uaghan iti. Me, Iesus bizitam damightɨma, me akam agasasa bar deravɨra an gari. Me kamagh sua an gari. A Sabatɨn gumazir kamɨn akuragham, o? ");
INSERT INTO msy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Me bizir kam bagha an garavɨra itima, Iesus kamaghɨn dafarim ekonezir gumazim mɨgei, “Nɨ dɨkavigh izɨ bar en guamɨn tugh.” ");
INSERT INTO msy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Gumazim dɨkavigha tuzɨma, Iesus kamaghɨn men azara, “Arazir manam Sabatɨn arazim abɨki? E arazir aghuim damuam, o arazir kuram damuam, o gumazimɨn akuragham, o gumazim gasɨghasɨgham?” A kamaghɨn men azarazɨma, me bar nɨmɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","An damazimning bar gumazamizibagh aruava, navimɨn aven men atari. A men garima, men naviba gavgavigha apangkuvir nɨghnɨziba men puvatɨ. Kamaghɨn a bar osemegha gumazim kamaghɨn a mɨgei, “Nɨ uan dafarim onegh.” Ezɨ gumazir kam uan dafarim onezɨma, an dafarim ua dera. ");
INSERT INTO msy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ezɨ Farisiba ikia ganigha dɨpenim ategha azenan izegha Herotɨn gumaziba ko ikia Iesusɨn mɨsoghasa akabar kɨri. ");
INSERT INTO msy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ezɨ Iesus uan suren gumaziba koma Galilin dɨpamɨn ghuaghiri. A ghuaghirima gumazamizir avɨriba Galilin Distrighɨn ikegha an gɨn ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gumazamizir avɨriba Judian Distrigh koma Jerusalemɨn nguibam koma Idumean Distrigh ko Jordanɨn dɨpamɨn vongɨn itir danganiba koma Tair ko Saidonɨn nguibamning ikegha, me Iesus bagha ghuaghiri. Gumazamizir avɨrir kaba, me an amizir bizibar akam bareghava a bagha ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Me iraghuezɨma, Iesus gumazamizir avɨriba men akurazɨma, men arɨmariaba gɨfa. Arɨmariaba itir gumazamizir avɨriba uan arɨmariaba gɨvasa Iesusɨn boroghɨn uari akuvagha, Iesusɨn suighasa uari munamadi. Kamaghɨn amizɨma, Iesus uan suren gumazibav gɨa ghaze, “Ia botɨn tam inigh izɨ puram anetɨghtɨ a ikɨ. Eghtɨ gumazamiziba bar na akuvaghtɨma kɨ botɨn ghuavanangam.” ");
INSERT INTO msy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iesus me mɨgeima, duar kuraba apazazir gumazir maba izava, Iesusɨn garava duar kuraba zuamɨra me gamima me Iesusɨn guamɨn daighɨra kamaghɨn arai, “Nɨ Godɨn Otarim.” ");
INSERT INTO msy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Me kamaghɨn amima, an akar gavgavimɨn me mɨgɨa ghaze, “Ia kamaghɨn mɨkɨman markɨ, ‘Nɨ Godɨn Otarim.’” ");
INSERT INTO msy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ezɨ Iesus dɨpar mɨriamɨn ikegha dɨkavighava mɨghsɨamɨn ghuavanabogha uan ifongezir gumazibar diazɨma, me a bagha zui. ");
INSERT INTO msy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Me zuima a gumazir 12 pla mɨsevegha ziar kam, aposelba, me gatɨ. Eghtɨ me a ko ikɨtɨ, a gɨn me amadaghtɨ me mangɨ Godɨn akar aghuim akunam. ");
INSERT INTO msy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Egh a uan gavgavim me danɨngtɨma me uaghan duar kuraba batogham. ");
INSERT INTO msy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A mɨsevezir gumazir 12 plan ziabar kara. Saimon (Iesus gɨn ziar kam, Pita, a gatɨ), ");
INSERT INTO msy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedin otarimning Jems ko Jon (A ziar kam aning gatɨ, Boanerges. Ziar kamɨn mɨngarim kamaghɨn ghu, atara pamtem mɨgeir gumazimning), ");
INSERT INTO msy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru ko Filip, Bartolomyu, Matyu, Tomas, Alfiusɨn otarim Jems, Tadius, Saimon (a Selotiabar gumazir mam), ");
INSERT INTO msy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ko Judas Iskariot, gumazir Iesus isava, apanibagh anɨngizim. ");
INSERT INTO msy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Egha Iesus uamategha dɨpenimɨn aven ghugha itima gumazamizir avɨriba izava anekufa. Me bar anekuvazɨma kamaghɨn a uan suren gumaziba koma me daghebar aman ibura. Me damamin dughiaba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ezɨ gumazamizir maba kamaghɨn mɨgei, “An ongani.” Ezɨ Iesusɨn adarasi akar kam bareghava, a inigh mangasa izi. ");
INSERT INTO msy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ezɨ Judan arazibagh fozir gumazir maba Jerusalemɨn ikegha izaghrava kamaghɨn mɨgei, “Belsebul a gapasa. A duar kurabar gumazir dapanimɨn gavgavimɨn duar kuraba batosi.” ");
INSERT INTO msy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ezɨ Iesus me mɨgeir akam bareghava, egha kamaghɨn gumazamizibar diaghava akar isɨn zuir maba me mɨgei, “Satan manmaghɨn uabɨra uabɨ batuegham? ");
INSERT INTO msy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kantrin tam tongɨra uari abɨghɨva uarira uariv soghɨva kantrin kam ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kamaghɨn uaghan, dɨpenir vamɨran itir darasi me tongɨra uari abɨghɨva uarira uariv sogh dɨpenir kamɨn itir darasi ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kamaghɨra Satanɨn adarazi uarira uari abɨghɨva uariv mɨsoghtɨma an gavgavim bar gɨvaghɨva ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Eghtɨ gumazir manam puram aven mangɨ gumazir gavgavitamɨn dɨpenim akarighɨva an biziba okemegham? Puvatɨgham. A faraghvɨra benibar gumazir gavgavir kam ikegham. A kamaghɨn a damigh gumazir kamɨn dɨpenimɨn aven mangɨ, an biziba okemegham. ");
INSERT INTO msy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Kɨ guizbangɨra ia mɨgei, gumazamizibar arazir kuraba ko me Godɨn ziam gasɨghasɨzir akaba, God da gɨn amangamin tuavim iti. ");
INSERT INTO msy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Eghtɨ gumazitam Godɨn Duamɨn ziam gasɨghasightɨma God an arazir kurar kam, a gɨn amadaghan kogham. Egh gumazir kam aremeghtɨ, arazir kurar kam an ikɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Me faragha kamaghɨn a mɨgɨa ghaze, “Duar kurar mam a gapasa.” A bizir kam bagha, akar kabar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ezɨma Iesusɨn amebam ko doziba izava, a itir dɨpenimɨn tiar akamɨn tughava gumazir mam amadazɨma a Iesusɨn mɨkɨmasa aven zui. ");
INSERT INTO msy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Gumazamizir avɨriba a koma apiaghav ikiava kamaghɨn a mɨgei, “Nɨ oragh, nɨn amebam ko doziba me nɨ bagha izeghava azenan iti.” ");
INSERT INTO msy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Me a mɨkemezɨma a kamaghɨn men azara, “Tina nan amebam? Te nan doziba?” ");
INSERT INTO msy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A kamaghɨn men azaraghava, an okarigha apiaghav itir gumazamizibar garava, kamaghɨn me mɨgei, “Ia gan! Nan amebam ko dozibara kara. ");
INSERT INTO msy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Gumazamizir God ifongezir arazibar gɨn zuiba, me nan doziba ko nan amiziba ko nan amebam.” ");
INSERT INTO msy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Dughiar igharazir mam Iesus ua dɨpar mɨriamɨn ikiava, gumazamizir mabar sure gami. Me an akaba baraghasa anekuvagha guizbangɨra bar avɨraseme. Ezɨ a botɨn mamɨn bɨragha dɨpam gisɨn aperaghav iti. Gumazamizir kaba an boroghɨn dadarimɨn apiaghav iti. ");
INSERT INTO msy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","An akar isɨn zuir avɨribar men sure gamuava, kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ia oragh. Gumazir mam raizɨn mɨngarir daghem, wit, a inigha ghua uan azenimɨn da akuragharui. ");
INSERT INTO msy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","A da akurima witɨn ovɨzir maba tuavimɨn irezɨma, kuaraziba iza da ame. ");
INSERT INTO msy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ezɨ maba dagɨabagh isɨn itir nguazir evarim gire. Nguazir kam mɨtemezir puvatɨ, ezɨma witɨn ovɨziba zuamɨra afuangi. ");
INSERT INTO msy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ezɨ dar biba bar nguazimɨn aven iraghuezir puvatɨ, ezɨ aruem anaga dagh isirazɨ, ezɨ da isia mɨsɨngi. ");
INSERT INTO msy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ezɨ witɨn ovɨzir maba benir dɨkoniba itir nguazim giregha, benibar tongɨn afuangizɨ, benir dɨkoniba aghuava beniba da ikiagharɨki. Ezɨ dar ovɨziba mɨsevezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ezɨ witɨn ovɨzir maba nguazir aghuim giregha aghuava dagheba mɨsefi. Egha maba 30 pla mɨsevima maba 60 pla mɨsefe. Ezɨ maba ghua 100ɨn tu.” ");
INSERT INTO msy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iesus me mɨgɨa ghua kamaghɨn me mɨgei, “Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gumazamizir avɨriba bar ghuezɨ, ezɨ Iesus uabɨra itima, an 12 plan gumaziba koma an boroghɨn itir gumaziba, me an akar isɨn zuimɨn mɨngarim bagha an azara. ");
INSERT INTO msy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Me an azarazɨma a kamaghɨn me mɨgei, “God fofozim ia ganɨngizɨma, ia God Bizibagh Ativamin Dughiamɨn akar mogomeba dagh fo. Egha kɨ azenan itir gumazamiziba pura akar isɨn zuibar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kamaghɨn amizɨma ‘Me zurazurara ganɨva, me bizitam gɨfoghan kogham. Me uaghan zurazurara oraghɨva, me deraghvɨra akar mɨngaritam gɨfoghan kogham. Me amuava akar mɨngarim gɨfogha, uan navibagh irazɨ, God men arazir kuraba gɨn amadaghai.’” ");
INSERT INTO msy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","An akar kam me mɨgɨa ghua kamaghɨn mɨgei, “Ia witɨn akar isɨn zuir kamɨn mɨngarim gɨfozir puvatɨ? Ia manmaghɨn akar isɨn zuir igharazir tabagh fogham? ");
INSERT INTO msy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Akar isɨn zuimɨn aven itir gumazir kam a mati gumazir Godɨn akam kuragharuim ");
INSERT INTO msy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Gumazir maba tuavim girezir witɨn ovɨzibar mɨn ami. Me Godɨn akaba baraghizɨ Satan zuamɨra izava me oraghizir Godɨn akaba, me dama ada ini. ");
INSERT INTO msy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Gumazir maba dagɨaba itir nguazim girezir witɨn ovɨzibar mɨn ami. Me Godɨn akaba bareghava da bagha bar akonge. ");
INSERT INTO msy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Egha men biba iraghuezir puvatɨgha, egha uaghan dughiar ruarimɨn itir puvatɨ. Me itima osɨmtɨziba ko Godɨn gɨn zuir gumazibagh asɨghasɨzir araziba izima, me pura God ataki. ");
INSERT INTO msy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Gumazir maba benir dɨkoniba itir nguazim girezir witɨn ovɨzibar mɨn ami. Me Godɨn akaba baraki. ");
INSERT INTO msy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Me da bareghava me uaghan nguazir kamɨn osɨmtɨziba bagha nɨghnɨghava, dagɨar avɨriba iniasa ifavarir nɨghnɨzibagh amuava, nguazir kamɨn bizir avɨribar garava da bagha agoi. Bizir kabar nɨghnɨziba izava Godɨn akaba ikiagharɨzɨma da mɨsevir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ezɨ gumazir maba nguazir aghuim girezir witɨn ovɨzibar mɨn ami. Me Godɨn akaba baregha dar suiragha dar gɨn zui. Egha me mɨsefi. Maba 30 pla mɨsevima, maba 60 pla mɨsefi. Ezɨ maba ghua 100ɨn tu.” ");
INSERT INTO msy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Egha Iesus kamaghɨn me mɨgei, “Ian tina lam gaboroghava a inigha itarir ekiamɨn anevara? O an a inigha dakozimɨn apengan anetɨ? Puvatɨ! Ia a daborogh a inigh azenan an danganimra aneguragh. ");
INSERT INTO msy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kamaghɨra mogomer biziba da gɨn azenan otivigham. Eghtɨ bizir amigha aveziba da uaghan gɨn azenan otivigham. ");
INSERT INTO msy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Egha a mɨgɨa ghua kamaghɨn mɨgei, “Ia deraghvɨra akar kam baragh. Ia deraghvɨra a baraghɨva deragh fogh, eghtɨ God uan akabar fofozir avɨriba ia danɨngam. Godɨn akabagh fozir gumazitam a Godɨn akar igharaziba uaghan da baragham. Eghtɨ Godɨn akabagh foghan aghuazir gumazitam, an fofozir muziarim God a dama inigham. Ia Godɨn akam barazi moghɨn God uaghan kamaghɨn damuva, bizir avɨrir maba sara ia damuam.” ");
INSERT INTO msy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Egha Iesus mɨgɨa ghua kamaghɨn me mɨgei, “God Bizibagh Ativamin Dughiamɨn arazim kamakɨn. Gumazir mam dagher ovɨziba inigha nguazimɨn da kuri. ");
INSERT INTO msy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Gumazir kam da kunighava, dɨmagaribar akuava, aruebar dɨkavigha arui. An aruima dagher ovɨzir kaba da afuegha aghui. Dagher ovɨzir kaba manmaghɨn afuegha aghui? Gumazir kam fozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ezɨ nguazimra dagher ovɨzir kabagh amizɨma da aghua mɨsefe. Da faragha afuegha aghua ghua aghariba otivigha egha adava ghua akɨmariba otivigha mɨsefe. ");
INSERT INTO msy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Da mɨsevegha dagheba itima, gumazir kam sabam inighava dar akori. A fo, dagheba iti, ezɨ dar akoramin dughiam oto.” ");
INSERT INTO msy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Egha a ua kamaghɨn mɨgei, “E manmaghɨn God Bizibagh Ativamin Dughiamɨn arazim mɨkɨmam? O, e akar isɨn zuir manamɨn an mɨngarimɨn gun mɨkɨmam? ");
INSERT INTO msy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","A mastetɨn ovɨzimɨn mɨn gari. Mastetɨn zuravarir ovɨziba bar sufi. Temer igharazibar ovɨziba bar a gafiragha ekefe. ");
INSERT INTO msy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Gumazir mam anekunizɨma a gɨn aghua bar ekeveghava azenimɨn itir zuravariba bar dagh afiragha bar ekefe. An ekevegha an aguar ekiaba uari tuirazɨma kuaraziba izava an aguabar dughuazimɨn aven ikia mɨkonibar ingari.” ");
INSERT INTO msy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Egha Iesus men nɨghnɨziba tuzɨnaghara mɨn amir akar isɨn zuir avɨribar Godɨn akabar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","An akabar gumazamizibav gɨava zurara akar isɨn zuibar me mɨgei. Egha a uan suren gumaziba ko me uarira ikiava a bizibar mɨngariba abɨgha me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aruer kamɨn amɨnim pɨrasava amima Iesus kamaghɨn uan suren gumazibav gei, “E dɨpar kam atugh an vongɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A kamaghɨn me mɨgeima gumazamiziba dadarimɨn ikiavɨra iti. Ezɨ me Iesus aperaghav itir botɨn ghuavanabogha pul gamua vongɨn zui. Botɨn igharazir maba uaghan me ko vongɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Iesus uan suren gumaziba ko zuima, Maia! Amɨnir ekiam dɨkafi. Ezɨ dɨpavsɨziba izava bot gafirazɨ dɨpam botɨn aven ghuaghira, bot gizɨfa, ezɨ an atam dɨpamɨn aven magɨrasava ami. ");
INSERT INTO msy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Bot magɨrasava amima, Iesus botɨn kamɨn gɨrakɨrangɨn dapanir aghoghonir mam uan dapanimɨn aghorogha akui. Ezɨ an suren gumaziba a gaghuragha kamaghɨn a mɨgei, “Tisa, e gɨfa! Nɨ e bagha nɨghnɨsi, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ezɨ Iesus dɨkavigha tugha amɨnim batogha, egha dɨpavsɨzim kamaghɨn a mɨgei, “Gua amɨragh, egh nɨmɨra ikɨ!” A mɨgeima, amɨnim amɨrazɨma, dɨpam pura nɨmɨra irɨghav iti. ");
INSERT INTO msy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ezɨ Iesus kamaghɨn uan suren gumazibav gei, “Ia tizim bagha puv atiati? Ia nɨghnɨzir gavgavim otevegha kamaghɨra iti?” ");
INSERT INTO msy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ezɨ me bar atiatigha kamaghɨn uarira uariv gei, “Gumazir kam tinara? Amɨnim ko dɨpavsɨzim uaghan an akam barasi!” ");
INSERT INTO msy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ezɨ Iesus uan suren gumaziba koma dɨpam atugha vongɨn Gerasan danganimɨn oto. ");
INSERT INTO msy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Me otivigha, Iesus bot ategha dadarimɨn anadima gumazir duar kuram apazazir mam, a matmatiamɨn ikegha Iesus bativasa izi. ");
INSERT INTO msy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","A matmatiamɨn ikiava a gakui. Me dughiar avɨriba senbar an agharimning ikiava, ankavba an suemning gazui. Ezɨ a zurara senɨn kabar suighava dar aghora egha an suemning ikezir ankavbav sogha dar aghoragharɨsi. Kamaghɨn amizɨma gumazitam gumazir kamɨn suiragh a ikɨva avegham. Me uaghan senbar a ikeghtɨ da an suiraghan kogham. Egh gumazitam gavgavigh a ikeghan kogham. ");
INSERT INTO msy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","A dɨmagariba ko aruebar matmatiam ko mɨghsɨabar purama aruava pamtem arava dagɨabar uabɨ uan mɨkarzim aghori. ");
INSERT INTO msy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A saghon ikia Iesusɨn ganigha ivegha a bagha izava an guamɨn uan tevimning apɨri. ");
INSERT INTO msy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ezɨ Iesus kamaghɨn duar kuram mɨgei, “Nɨ duar kuram, nɨ gumazir kam ategh azenan izɨ.” Iesus kamaghɨn a mɨgeima, ezɨ gumazir kam pamtem arava kamaghɨn mɨgei, “Nɨ manmaghɨn na damuasa, Iesus biziba bar dar pɨn itir Godɨn Otarim. Kɨ Godɨn damazimɨn pamtem nɨn azangsɨsi, nɨ na gasɨghasɨghan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A kamaghɨn mɨgeima Iesus kamaghɨn a mɨgei, “Nɨ uan ziam dɨborogh.” Ezɨ duar kurar kam a ikaragha kamaghɨn a mɨgei, “E bar avɨraseme, kamaghɨn nan ziam Avɨriba.” ");
INSERT INTO msy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","A Iesus danganir igharazitam me amangan aghuagha Iesus vɨvɨgha a gakaghori. ");
INSERT INTO msy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dughiar kam, men boroghɨra itir mɨghsɨar mɨriamɨn dar avɨriba ikiava api. ");
INSERT INTO msy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ezɨ duar kurar kaba kamaghɨn Iesus mɨgɨava a gakaghori, “Nɨ e mɨkemegh e amadaghtɨma e mangɨva dar bɨzir munabagh apazaka.” ");
INSERT INTO msy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ezɨ a men amamangatɨzɨma duar kurar kaba gumazir kam ategha azenan izegha ghua dar bɨzim gapasa. Dar avɨrir kaba, dar dɨbobonim 2,000ɨn boroghɨn ghu. Ezɨ daba puv ivemara ghuaghira davarir kuram giraghueghava dɨpamɨn aven ghuegha dɨpam apava ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ezɨ dabar garir gumaziba daba batoghezir bizimɨn ganigha ghua nguibar ekiamɨn ghua danganir kamɨn itir nguibar dozibar ghua bizir otozir kamɨn gun mɨgei. Gumazamiziba bizir kamɨn ganasa dɨkavigha izi. ");
INSERT INTO msy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Me izava Iesus boroghɨn duar kuraba apazazir gumazimɨn garima, an nɨghnɨzim ua derazɨma, a uan korotiaba aghuighava aperaghav iti. Me an ganighava atiatingi. ");
INSERT INTO msy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ezɨ otozir bizir kamɨn ganizir gumazamiziba, me duar kuraba apazazir gumazimɨn bizir otozir kabar gumazir igharazibav gei. Me dar gun mɨgɨava ghuava uaghan daba batozir bizimɨn gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gumazamizir kaba bizir kam bareghava uan danganim ategh mangasa kamaghɨn me Iesus mɨgɨa a gaghori. ");
INSERT INTO msy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ezɨ Iesus danganir kam ategh mangasa botɨn bɨrima duar kuraba apazazir gumazim Iesus ko mangasa pamtem a gaghori. ");
INSERT INTO msy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ezɨ Iesus an anogoregha kamaghɨn a mɨgei, “Nɨ uamategh uan adarazi bagh dɨpenimɨn mangɨva Gumazir Ekiam nɨn akuragha nɨ gamizir bizibar gun me mɨkɨmɨva egh a uaghan bar nɨn apangkuvizir bizimɨn gun me mɨkɨm.” ");
INSERT INTO msy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gumazir kam a bareghava ghua Iesus an akurazir bizimɨn gun Dekapolisɨn Distrighɨn itir nguibabar ghua bar me mɨgei. Gumazamizir kaba a bareghava dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ezɨ Iesus bot inigha uamategha dɨpamɨn vongɨn ize. A izegha dɨpar dadarimɨn itima gumazamizir avɨriba izava anekufa. ");
INSERT INTO msy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Ezɨ God ko mɨgeir dɨpenimɨn bizibar garir gumazir mam, an ziam Jairus, a izava, Iesusɨn garava an guamɨn uabɨ ekunigha kamaghɨn puvɨram a gaghori, “Nan guivim aremeghasa an dɨghorimra isi. Nɨ izɨva uan dafarim a datɨghtɨ an arɨmariam gɨvagh ua ikiam.” ");
INSERT INTO msy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ezɨ kamaghɨn Iesus a ko zui. A zuima gumazamizir avɨriba bar anekuvaghava an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Me zuima men tongɨn ghuzim batir arɨmariar amizir mam uaghan me ko zui. Amizir kam, ghuzim batir arɨmariam an itima 12 plan azeniba gɨfa. ");
INSERT INTO msy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A fomɨra arɨmariam a gɨvasava doktaba bagha zuima, me an arɨmariam a gɨvazir puvatɨ. Ezɨ a mɨzazir kuram isi. A uan arɨmariam a gɨvasava pura uan dagɨabar me gɨvezima an dagɨaba bar gɨfa. Bizir kaba an arɨmariamɨn akurazir puvatɨ. An ekɨva ghuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","A Iesus amir bizibar akam baregha, a kamaghɨn nɨghnɨsi, “Kɨ puram an azenan itir korotiamra suiragh nan arɨmariam gɨvagham.” A kamaghɨn nɨghnɨghava egha damuasa. A gumazamizir avɨribar gɨn izava me munamaga izava Iesusɨn korotiamɨn suira. ");
INSERT INTO msy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Amizim an korotiamɨn suighavɨra, an ghuzir arɨmariam pura dutugha ghu. A uabɨ uabɨ baregha fo, an mɨkarzim ua dera. ");
INSERT INTO msy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","A kamaghɨn amimra, Iesus zuamɨra uabɨ uabɨ baregha a God gumazibar arɨmariaba gɨvaghasa a ganɨngizir gavgavim, an mɨkarzim ataghizɨ a fo, nan gavgavim ingari. Egha a ragha gumazamizibar garava men azara, “Tina nan korotiamɨn suira?” ");
INSERT INTO msy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ezɨ an suren gumaziba a ikaragha kamaghɨn a mɨgei, “Nɨ garima, gumazamizir avɨriba nɨ akufa. Ezɨ nɨ tizim bagha kamaghɨn azai, ‘Tina nan korotiamɨn suira?’” ");
INSERT INTO msy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Me kamaghɨn Iesus mɨgɨavɨra itima Iesus uan korotiamɨn suirazir gumazim gɨfoghasa raghrɨgha garagharui. ");
INSERT INTO msy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","A ruiavɨra itima, amizir kam a batozir bizim gɨfogha izava Iesusɨn guamɨn degiaghrɨgha, atiatia nɨghava guizbangɨra a batozir bizimɨn gun a mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ezɨ Iesus kamaghɨn a mɨgei, “Nan guivim, nɨ nɨghnɨzir gavgavim nan iti. Ezɨ nɨn arɨmariam gɨfa. Nɨ navir amɨrɨzimɨn mangɨ, eghtɨ nɨn arɨmariar kam ua nɨ damuan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iesus amizir kam mɨgɨavɨra itima gumazir maba God ko mɨgeir dɨpenimɨn bizibar garir gumazim, Jairusɨn dɨpenimɨn ikeghava ize. Me izegha kamaghɨn Jairus mɨgei, “Nɨn guivim areme. Nɨ osɨmtɨzim Tisa danɨngan markɨ.” ");
INSERT INTO msy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Me kamaghɨn mɨgeima Iesus me baregha kamaghɨn Jairus mɨgei, “Nɨ atiatingan markɨ. Nɨ pura nɨghnɨzir gavgavim nan ikɨ.” ");
INSERT INTO msy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","An gɨn aruir gumaziba a ko mangasa amima a men anogoregha, egha Pita, ko Jon an dozim Jems, merara inigha me zui. ");
INSERT INTO msy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Me ghua Jairusɨn dɨpenimɨn otivigha Iesus gumazamiziba barazima, me bar azia nɨgɨnir dafam gami. ");
INSERT INTO msy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","A me bagha aven ghua kamaghɨn me mɨgei, “Ia tizim bagha azia nɨgɨnir dafam gami? Borir kam aremezir puvatɨ. An akui.” ");
INSERT INTO msy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","A kamaghɨn me mɨgeima, me a dɨpovava an ingarava kava uariv gei, “E fo, a guizbangɨram areme.” Gumazamiziba kamaghɨn mɨgeima ezɨ a bar me batuegha guivimɨn afeziam ko amebam inigha an suren gumazir pumuning ko mɨkezim, merara a ko zui. A me inigha me guivimɨn kuam itir danganimɨn aven zui. ");
INSERT INTO msy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Me ghuegha a guivimɨn agharim suiragha kamaghɨn a mɨgei, “Talita kum!” (Akar kamɨn mɨngarim kamaghɨn iti, “Guivir dozim, kɨ nɨ mɨgei, nɨ dɨkafigh!”) ");
INSERT INTO msy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","An a mɨgeimrama, guivim dɨkavigha tughava arui. (An azenir 12 pla.) A dɨkavigha tugha aruima, me kamaghɨn guizbangɨra dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ezɨ an akar gavgavimɨn guizbangɨra me mɨgɨa ghaze, ia bizir kamɨn gun gumazir igharazitam mɨkɨmam markɨ. A kamaghɨn me mɨgɨava daghetam a danɨngasa me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Egha Iesus kagh tegha uan nguibamɨn ghuavanadima an suren gumaziba a ko zui. ");
INSERT INTO msy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ezɨ, Sabatɨn dughiam otozɨma a God ko mɨgeir dɨpenimɨn aven ghua, gumazamizibar sure gami. Gumazamizir avɨriba an akaba bareghava dɨgavir kuram gami. Me dɨgavir kuram gamigha azara, “Gumazir kam managh akar kaba ini? A managh nɨghnɨzir aghuiba ini? A uaghan managh mirakelbagh amir gavgavim ini? ");
INSERT INTO msy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","E fo, kar pura dɨpenibar ingarir gumazim. A Marian otarim, a Jems ko Josep, Judas, Saimon, a men avebamra. An buaramiziba e ko iti.” Kamaghɨn amizɨma me dɨbovir akabar a mɨgɨava navibar aven an atari. ");
INSERT INTO msy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ezɨ Iesus kamaghɨn me mɨgei, “Godɨn akam inigha izir gumazim, a nguibar igharazibar zuima, me an ziam fe. Ezɨ an nguibamɨn an adarasi, me an ziam fer puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kamaghɨn amizɨma a nguibar kamɨn mirakelɨn avɨribagh amizir puvatɨ. A pura dafarim arɨmariar gumazir vabara me garɨghizɨma, men arɨmariaba gɨfa. ");
INSERT INTO msy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Egha me nɨghnɨzir gavgavim an itir puvatɨzɨma, kamaghɨn a dɨgavir kuram gami. Iesus uan gavgavim suren gumazibar akazɨ, ezɨ me deragha a gɨfozir pu (Sapta 6:7-8:21) Egha Iesus nguibabagh aruava gumazamizibar sure gami. ");
INSERT INTO msy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iesus men sure gamuava, egha 12 plan aposelbar diazɨma, me a bagha izezɨma, a me akuvagha, me mɨgɨava me amada. Gumazir pumuning uaning inigha zui, ezɨ gumazir pumuning uaning inigha zui. A kamaghɨn amuava uaghan duar kuraba batozir gavgavim me ganigha me amada. ");
INSERT INTO msy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","A mɨgɨrɨgɨar kam me gamuava me amada, “Ia mangɨ, bizir taba uari bagh da inian markɨ. Ia bretɨn tam ko mɨtaritam inian markɨ. Ia dagɨatam suighan markɨ. Ia uan dagarir asuaba aghuva, ua siotɨn tam inian markɨ. Ia uan aghorir asadivibara suiragh mangɨ. ");
INSERT INTO msy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ia kamaghɨn damigh, mangɨva nguibatamɨn mangɨghtɨ me dɨpenitam ia danightɨ, ia dɨpenir kamra ikɨ, mangɨ dughiar ia nguibar kam ataghraghamim. ");
INSERT INTO msy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ia kamaghɨn damu mangɨ nguibatamɨn mangɨghtɨma, me ian aghuagh ia inigh uan dɨpenibar mangɨghan koghɨva, me uaghan ia mɨgeir akaba baraghan koghtɨma, ia kamaghɨn damu. Ia nguibar kam ategh mangɨsɨ uan dagarir mɨneziba apɨsigh, egh nguibar kam ategh mangɨ. Ia kamaghɨn damightɨ, me ganigh fogham, me arazir aghuim ia gamizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","A kamaghɨn me mɨkemeghava me amadazɨma me nguibabar ghua Godɨn akam akura ghaze, Ia uan navibagh iragh. ");
INSERT INTO msy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Me kamaghɨn me mɨgɨava, egha uaghan gumazir avɨribar duar kuraba batogha arɨmariar gumazir avɨriba boremɨn men dapaniba ingiava me gamima, me ua dera. ");
INSERT INTO msy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ezɨ Iesus bizir avɨribagh amizɨma an ziam otogha ekevezɨma, gumazir avɨriba a gɨfo. Ezɨ danganir kamɨn atrivim, Herot, a baraki. Me marazi kamagh mɨgei, “Jon Gumaziba Ruer Gumazim aremegha ua dɨkafi. Kamaghɨn a mirakelbar amuamin gavgavim iti.” ");
INSERT INTO msy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ezɨ me marazi kamagh mɨgei, “A Elaija.” Ezɨ marazi kamagh mɨgei, “Kar Godɨn akam inigha izir gumazir mam, a mati fomɨra ikezir Godɨn akam inigha izir gumazibar mɨn ami.” ");
INSERT INTO msy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Me akar kabav geima, Herot da baregha a fo, a fomɨra Jonɨn fɨrim atu. Kamaghɨn amizɨma a kamaghɨn mɨgei, “Kɨ fomɨra mɨkemezɨma, me gumazir mam Jon, Gumazibar Ruer Gumazimɨn fɨrim atuzɨma, a ua dɨkafi.” ");
INSERT INTO msy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herot kamaghɨn amigha a fo, a fomɨra uan dozim Filip da an amuim Herodias a ini. Ezɨ Jon zurara kamaghɨn a mɨgei, “Herot, na arazir kuram gamuava uan dozim da an amuim ini.” Jon kamagh mɨgeima, Herodias a bagha guizbangɨra navim isia, egha a Jon mɨsueghtɨ an aremeghasa a bagha puvɨra Herotɨn mɨgei. Ezɨ Herot Herodias ifongezir moghɨn damuan aghuaghava, a uan gumazir mabav kemezɨma me Jonɨn suiragha a inigha kalabus gatɨ. Herot fo, Jon Godɨn damazimɨn zuegha derazir gumazimra. Kamaghɨn amizɨma Herot an atiatiava, a inigha deragha an gari. Herot uaghan Jon mɨgeir akaba baragha nɨghnɨzir avɨribagh amuava, ana akaba baraghasa ifonge. ");
INSERT INTO msy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ezɨ Herodias datɨrɨghɨn Jon mɨsueghtɨ an aremeghasa tuavim bato. Herot an amebam a batezir dughiam otozɨ, a dughiar kam gɨnɨghnɨgha isar ekiam gami. Herodias Jonɨn mɨsoghamin dughiam datɨrɨghɨn oto. Herot isar kam gamuava, uan ingangarir ekiabar gari gumazir ekiaba, ko uan mɨdorozir gumazibar gari gumazir ekiaba, ko Galilin itir gumazir ekiaba, a men diazɨma me a ko damasa ize. ");
INSERT INTO msy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Me izegha isam apima Herodiasɨn guivim izava me apir danganimɨn ghugha men guamɨn ighiam gami. A ighiam gamima, Herot ko izegha apir gumaziba ighiamɨn ganigha guizbangɨra an ighiam gifongegha a bagha bar akonge. Me bar akuegha, egha Herot kamaghɨn guivir igiam mɨgei, “Nɨ bizir manam gifongegh nan azaragh. Eghtɨ kɨ bizir kam nɨ danigam.” ");
INSERT INTO msy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A kamaghɨn a mɨkemegha, akar dɨkɨrɨzir gavgavim kamaghɨn a mɨgei, “Kɨ guizbangɨra nɨ mɨgei, nɨ bizitam gifongegh, na mɨkɨm. Nɨ kɨ garir bizibagh ifongeghɨva, na mɨkɨm. Kɨ tongɨra da bighɨva, taba nɨ danigham.” ");
INSERT INTO msy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Guivir igiar kam akar kam baregha, azenan izegha ghua kamaghɨn uan amebam mɨgei, “Amebam, kɨ bizir tizim bagh azaragham?” Ezɨ an amebam kamaghɨn a mɨgei, “Jon, Gumaziba Ruer Gumazimɨn, dapanim.” ");
INSERT INTO msy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ezɨ guivir kam akar kam baregha, zuamɨra uamategha aven ghugha kamaghɨn Herot mɨgei, “Nɨ datɨrɨghɨra Jon, Gumaziba Ruer Gumazimɨn, dapanim itaritam datɨgh na danɨngigh.” ");
INSERT INTO msy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ezɨ Herot a bareghava navim bar oseme. A faragha akar dɨkɨrɨzir gavgavim mɨgeima a ko apir gumaziba a baraki. Kamaghɨn amizɨma, an an azangsɨzim pueghan kogham. ");
INSERT INTO msy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Egha Herot a baraghavɨra, akar gavgavim uan mɨdorozir gumazim mɨkemegha anemadazɨma a ghuava kalabusɨn aven iraghugha Jonɨn fɨrim atu. ");
INSERT INTO msy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A Jonɨn fɨrim atugha an dapanim inigha itarir mam gatɨgha a inigha izava guivir kam ganɨngizɨma anenigha ghua uan amebam ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ezɨ Jonɨn suren gumaziba an ovevem baregha izava an kuam inigha ghuava a mozim gatɨ. ");
INSERT INTO msy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ezɨ Iesusɨn aposelba ua izegha an boroghɨn uari akufa. Egha me aruava amizir biziba ko akar gumazibar sure gamizibar gun Iesus mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Dughiar kam gumazamizir avɨriba me bagha iza zuima, me damamin dughiaba puvatɨ. Ezɨ Iesus kamaghɨn me mɨgei, “Ia uarira na ko mangɨva gumaziba puvatɨzir danganimɨn mangɨva avughsam.” ");
INSERT INTO msy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A kamaghɨn me mɨgɨava egha me uarira bot inigha gumaziba itir puvatɨzir danganir mamɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Me zuima, gumazamizir avɨriba men ganigha me gɨfo. Ezɨ nguibabar itir gumazamiziba bar men faraghavɨra ivegha ghuava me zuir danganimɨn otifi. ");
INSERT INTO msy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ezɨ me ghuava dadarimɨn ghuegha Iesus gumazamizir avɨribar garima, me guizbangɨra bar avɨraseme. A men garima, me sipsipbar mɨn ami, me ghuaviba puvatɨ, me pura asaghasazibar mɨn arui. A kamaghɨn bar men apangkufi. Egha a bizir avɨriba men sure gami. ");
INSERT INTO msy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","A mɨgɨavɨra itima, amɨnim pɨrizɨma an suren gumaziba a bagha izava kamaghɨn a mɨgei, “Kar gumaziba itir puvatɨzir danganim, ezɨ amɨnim pɨri. ");
INSERT INTO msy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nɨ gumazamiziba amadaghtɨ, me mangɨ danganir kamɨn itir nguibaba ko roghɨra itir nguibar dozibar mangɨva me damɨsɨ uari bagh daghebagh ives.” ");
INSERT INTO msy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ezɨ a me ikaragha kamaghɨn mɨgei, “Ia uari daghetaba me danɨng.” Ezɨ me kamaghɨn a mɨgei, “Dagɨar e me bagh bretbagh ivezamim, a 200 Kinan tu. E da inigh, mangɨ, me bagh bretbagh ivezegh me danɨngasa, nɨ ifonge?” ");
INSERT INTO msy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ezɨ Iesus men azara, “Ia manmaghɨra bretba iti? Ia mangɨ ganigh.” A mɨkemezɨ, me ghua ganigha kamaghɨn a mɨgei, “E bretɨn 5 pla koma osirir pumuning kati.” ");
INSERT INTO msy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ezɨ Iesus me mɨkemezɨ me gumazamizibav geima, me uari uari tuiragha grazim gapia. ");
INSERT INTO msy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ezɨ me uari tuiragha apia, marazi 50, marazi 100ɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Me apiaghav itima, ezɨ Iesus bretɨn 5 pla inigha, osirir pumuning inigha, pɨn overiamɨn garava God mɨnabagha bretba abɨagharɨki. Egha uan suren gumazibav geima, me da isa, gumazamizibagh anɨdi. A uaghan osirimning sara bɨagharɨghizɨma, me da isa, me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ezɨ gumazamizir kaba bar amegha, naviba bar izɨfa. ");
INSERT INTO msy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Men naviba bar izɨvazɨma Iesusɨn suren gumaziba, dagher nar me ataghiziba, me da inigha akɨrar 12 pla gaghuizɨma, da bar izɨfa. ");
INSERT INTO msy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Dagheba amezir gumazibara, men avɨrim 5,000ɨn tu. ");
INSERT INTO msy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Gumazamiziba dagheba amezɨma, ezɨ Iesus kamaghɨn uan suren gumazibar ariragha ghaze, Ia botɨn bɨnighɨva faragh Betsaidan vongɨn nguibamɨn mangɨ. Kɨ uabɨra ikɨva gumazamiziba amadaghtɨma me ua uan nguibabar mangam. ");
INSERT INTO msy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A me amadazɨ, me ghuezɨma, ezɨ a God ko mɨkɨmasa mɨghsɨamɨn ghuavanabo. ");
INSERT INTO msy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dughiar kam amɨnim pɨrima, men bot dɨpamɨn tongɨn itima, Iesus uabɨra dadarimɨn iti. ");
INSERT INTO msy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A ikiava uan suren gumazibar garima, amɨnir gavgavim izava men bot gɨvai. Me pul gamua ingangarir dafam gamuava amɨnim ko uari adosi. Egha amɨnim tiasava amima, Iesus dɨpam gisɨn tugha me bagha zui. A mangɨ me gitagh mangasa. ");
INSERT INTO msy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ezɨ me an garima, a dɨpam gisɨn tugha zuima, me kamaghɨn nɨghnɨsi, “Kar ti asetam.” Me nɨghnɨzir kam gamuava, bar an ganigha puv atiatiava arai. Me araima, a zuamɨra kamaghɨn me mɨgei, “Ia gavgafigh, kar kɨrara. Ia atiatingan markɨ!” ");
INSERT INTO msy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","A kamaghɨn me mɨgɨava, me gatɨn botɨn aven ghuzɨma, amɨnim pura dutugha ghu. Ezɨ me bizir kam, Iesus 5,000ɨn gumaziba bretba me ganɨngizɨ, me damezɨ, me ganigha, kamaghɨn me tong bar fozir puvatɨ. Men nɨghnɨziba otefe. Egha bizir kabagh nɨghnɨghava guizbangɨra dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Egha Iesus uan suren gumaziba ko dɨpamɨn vongɨn ghugha, ghua Genesaretɨn nguibamɨn otivigha, bot ike. ");
INSERT INTO msy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Me bot ikegha dadarimɨn anadima, gumazamiziba Iesusɨn garavɨra a gɨfo. ");
INSERT INTO msy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Me a gɨfogha, egha gumazamiziba Iesus itir danganim baregha, ivegha danganir kam garuava uan arɨmariar gumaziba inigha me akuriabagh arigha me inigha Iesus bagha izi. ");
INSERT INTO msy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iesus nguibar ekiaba ko nguibar doziba ko ruarir nguibaba dar zui. A zuir nguibar kaba me arazir kamram ami, me arɨmariar gumaziba inigha izava nguibamɨn tongɨn da arɨgha, egha me a gakaghora ghaze, a men asughtɨma, arɨmariaba itiba an korotiar avɨzibar suigham. Ezɨ gumazamizir an korotiamɨn suiziba, men arɨmariaba gefi. ");
INSERT INTO msy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ezɨ Farisin gumazir maba ko Judan arazibagh fozir gumazir maba, me Jerusalemɨn ikegha, izaghrava, Iesus bagha izava anekufa. ");
INSERT INTO msy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Me iza ikia garima, Iesusɨn suren gumazir maba men ovavibar arazibar gɨn ghuava dafariba ruegha dagheba apir puvatɨ. Me pura dagheba api. ");
INSERT INTO msy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisin kaba koma Judan gumazamiziba bar, me uan ovavibar arazibar suighavɨra ikiava, me dafariba ruava api. Me pura daghebar aman kogham. ");
INSERT INTO msy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Me uaghan maketɨn inigha izir dagheba, me dar aman kogham. Me faragh da ruegh egh dar amam. Me uaghan uan ovavibar arazir avɨrir maba sara suiraghavɨra iti. Me pura dagheba isamigh dameghan kogham. Me faragh uan mɨneba ko itariba ko apir dakoziba, rueghɨva egh me dagheba isamam. ");
INSERT INTO msy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kamaghɨn, Farisiba ko Judan arazibagh fozir gumaziba, me Iesusɨn azara, “Manmaghɨn amizɨ nɨn suren gumaziba en ovavibar arazibar gɨn mangɨ dafariba ruan aghuagha, pura dagheba api?” ");
INSERT INTO msy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ezɨ Iesus me ikaragha kamaghɨn mɨgei, “Ia uarira uarigh ifarir gumazibara. Godɨn akam inigha izir gumazim Aisaia, a guizbangɨra ia amir arazibar gun mɨgɨava kamaghɨn osiri, ‘Gumazamizir kaba, me uan akatoribar nan ziam fe, egha men naviba ko nɨghnɨziba bar saghon iti. ");
INSERT INTO msy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Me gumazibar akabar uari sure gamua uari gifara egha ghaze, kar Godɨn akam. Kamaghɨn amizɨ, me nan ziam guizbangɨra a fer puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ia kamaghɨn amua, Godɨn akaba, ia da ategha, uan ovavibar araziba, dar suiragha gavgafi.” ");
INSERT INTO msy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A mɨgɨa ghua kamaghɨn me mɨgei, “Ia ghaze, ia arazir aghuim gamua Godɨn akaba ategha uan arazibar gɨn zui. Ian arazir kaba bar ikufi. ");
INSERT INTO msy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses fomɨra kamaghɨn mɨkeme, ‘Ia uan afeziaba ko amebabar akaba baregh men apengan ikɨva, egh gumazitam akar kuratam uan afeziam ko amebam mɨkemeghtɨ, ia gumazir kam mɨsueghtɨ, an aremegh.’ ");
INSERT INTO msy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ezɨ ia kamaghɨn mɨgei, ‘Gumazitam uan amebam ko afeziamɨn akurvaghsɨ dagɨaba atɨgha, egha ua gɨn aningɨn akuraghan aghuagha, kamaghɨn aning mɨgei, “Guan akuraghasa atɨzir dagɨaba, gua markɨ. Kɨ da isɨ God danɨngam.” ’ ");
INSERT INTO msy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ia kamaghɨn mɨgeima, gumazir kam bizitam uan amebam ko afeziamɨn akuravazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ia kamaghɨn amuava, uan ovaviba da inizir arazibar gɨn ghuava, da gumazir igharazibagh anɨdi. Ian arazir kabar, ia Godɨn araziba ategha, uan ovavibar araziba faragha darɨsi. Egha Godɨn akam gami a mati pura bizim. Ia amir bizir avɨrir maba uaghan iti.” ");
INSERT INTO msy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Egha Iesus ua uabɨn boroghɨn itir gumazamizibar diazɨma, me a bagha izima, a kamaghɨn me mɨgei, “Ia bar na baraghɨva egh nan akar kaba, deraghvɨra dagh fogh. ");
INSERT INTO msy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Bizitam azenan ikegha gumazimɨn navimɨn aven magirɨ an navir averiam damightɨ, a Godɨn damazimɨn mɨzeghan kogham. puvatɨ, gumazimɨn navimɨn aven ikegha azenan izezir biziba, an navir averiam damightɨma, a Godɨn damazimɨn mɨzegham.” ");
INSERT INTO msy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iesus akar kaba gumazamizir avɨribav kemegha, me ategha ghua dɨpenimɨn aven ghuzɨma, an suren gumaziba akar isɨn zuimɨn mɨngarim bagha an azara. ");
INSERT INTO msy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Ezɨ Iesus kamaghɨn me mɨgei, “Eee! Ia ongani? Ia uaghan akar kam deravɨra a gɨfozir puvatɨ? Ia bizir kam gɨfo? Daghetam guizbangɨra gumazimɨn navir averiamɨn magɨrɨgh ikeghan kogham. Da an navimɨn aven magɨrɨgh, egh an muriamɨn magɨrɨghtɨma a gɨn dar aviam. Kamaghɨn gumazim apir bizitam azenan ikegh an akam ko muriamɨn magɨrɨgh, an muriam damightɨma a Godɨn damazimɨn mɨzeghan kogham.” (Iesusɨn akar gavgavim kamaghɨn mɨgɨa ghaze, dagheba bar Godɨn damazimɨn bar zue. Ezɨ e dar amam.) ");
INSERT INTO msy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A mɨgɨa ghua kamaghɨn me mɨgei, “Gumazimɨn navimɨn aven ikegha azenan izezir biziba, an arazir kuraba, a gamima, an navim Godɨn damazimɨn mɨze. ");
INSERT INTO msy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Gumazimɨn navimɨn aven ikegha azenan izezir arazibar kara, nɨghnɨzir kuraba, gumazamiziba tintinba uari koma akui, biziba okei, gumazibav mɨsozi da ariaghɨri, ");
INSERT INTO msy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","poroghamiba uari bakei, mɨghɨvɨra bizibagh ifonge, gumazir igharazibagh asɨghasɨghasa nɨghnɨsi, ifavariba, aghumsɨziba puvatɨzir arazir kuraba, bizim bagha navim ikufi, gumazir igharazimɨn ziam gasɨghasɨsi, uabɨra uabɨ fe, arazir onganiba, ");
INSERT INTO msy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","arazir kurar kaba bar navimɨn aven ikegha azenan iza, gumazim gamima a Godɨn damazimɨn mɨze.” ");
INSERT INTO msy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Egha Iesus Genesaret ategha Tairɨn nguibar ekiamɨn danganimɨn ghu. A gumazamiziba a gɨfoghan an aghuagha, egha mogomebar ghua dɨpenir mamɨn aven ghugha egha modozir puvatɨ. Me bar fo, a dɨpenimɨn aven iti. ");
INSERT INTO msy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","A dɨpenir kamɨn itima, guivir duar kuram apazazimɨn amebam, a Iesus izezir darorim baregha, zuamɨra a bagha izava an dagarimning irɨ. ");
INSERT INTO msy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Amizir kam, an amebam Fonisian Distrighɨn a bate. Sirian danganir ekiamɨn aven itir distrigh. Ezɨ a Grighɨn akamɨn mɨgei. A duar kurar an guivim gapazazim batoghasa Iesus mɨgɨava a gakaghori. ");
INSERT INTO msy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ezɨ Iesus kamaghɨn a mɨgei, “E faragh boribar dagheba me danɨngtɨ, me damam. Arazir kuram, kɨ boribar dagheba inigh afiabav kɨnam.” ");
INSERT INTO msy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ezɨ amizim kamaghɨn Iesus mɨgei, “Gumazir Ekiam, kɨ fo, afiaba uaghan boribar dakozimɨn apengan irezir dagher muzuemziariba api.” ");
INSERT INTO msy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ezɨ Iesus kamaghɨn a mɨgei, “Nɨn mɨgɨrɨgɨam dera. Kamaghɨn nɨ uamateghɨva uan dɨpenimɨn mangɨ. Duar kurar kam nɨn guivim ategha azenan ize.” ");
INSERT INTO msy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ezɨ a uamategha uan dɨpenimɨn ghuava garima, an guivim uan dakozim girɨghav iti. Ezɨ an an ganigha fo, duar kurar kam an ategha azenan ghu. ");
INSERT INTO msy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ezɨ Iesus dɨkavigha Tairɨn danganim ategha, ghua Saidonɨn danganimɨn otogha ghua, Dikapolisɨn Distrighɨn otogha ghua, Galilin dɨpamɨn dadarim giraghu. ");
INSERT INTO msy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","A ghuzɨma, gumazir maba gumazir kuarir onganir mam inigha Iesus bagha izi. A uaghan mɨzem osemegha deravɨra mɨgeir puvatɨ. Me izegha dafarim a darɨghasa Iesus gakaghori. ");
INSERT INTO msy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ezɨ Iesus gumazir kam inigha gumazir avɨriba ategha aning uaningra mɨriamɨn ghugha, egha a uan akakazir dafarimning gumazimɨn kuarimning gatɨgha aning asigha, egha iparigha, an mɨzemɨn suira. ");
INSERT INTO msy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Egha Iesus pɨn overiamɨn garava, gumazir kam bagha navim bigha arava kamaghɨn mɨgei, “Efata!” (Akar kamɨn mɨngarim kamaghɨn ghu, “Kuighrɨgh!”) ");
INSERT INTO msy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iesus kamaghɨn mɨgɨavɨra itima, an kuarimning kuiaghirɨ. Ezɨ an mɨzem mɨghɨvghɨki. Ezɨ a deravɨra bizibav gei. ");
INSERT INTO msy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ezɨ Iesus akar gavgavimɨn bizir kamɨn gun mɨkɨman men anogoroke. A men anogoroghezɨma me ua puvɨrama bizir kamɨn gun mɨgɨavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Me akar kam mɨgeima, gumazamizir kaba a baregha guizbangɨra dɨgavir kuram gamigha kamaghɨn mɨgei, “Gumazir kam an amir biziba da bar dera. A kuarir onganibagh amima, me uam orasi. Egha, mɨzer osɨmtɨzibagh amima, me ua deravɨra bizibav gei.” ");
INSERT INTO msy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Dughiar kam gumazamizir avɨrir igharaziba uari akufa. Me damamin dagheba puvatɨ. Ezɨ kamaghɨn Iesus uan suren gumazibar diazɨ me a bagha izima a kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gumazamizir kaba, me na ko aruer pumuning ko mɨkezimɨn ikia, egha dagheba puvatɨgha mɨtiriam men azi, kamaghɨn kɨ men apangkufi. ");
INSERT INTO msy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Me marazi saghon kegha ize. Kamaghɨn kɨ me amadaghtɨ, me mɨtiriaba sara, uan nguibabar mangɨva damaziba men isirtɨma me iram.” ");
INSERT INTO msy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ezɨ an suren gumaziba an akam ikara, “E managh gumaziba itir puvatɨzir danganir kamɨn tina bretɨn avɨriba inigh me danɨngam?” ");
INSERT INTO msy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Me kamaghɨn mɨgeima Iesus kamaghɨn men azara, “Ia manmagh bretba iti?” Me a ikaragha kamaghɨn mɨgei, “7 pla.” ");
INSERT INTO msy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ezɨ Iesus nguazimɨn dapiasa gumazamizibav kemezɨ me apia. Ezɨ a 7 pla bretba inigha God mɨnabagha egha da bɨagharigha, gumazamizibar anɨngasa uan suren gumazibagh anɨngizɨma me me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ezɨ me uaghan osirir muziarir maba iti. Ezɨ a uaghan da bagha God mɨnabagha da me danɨngasa uan suren gumazibav gei. ");
INSERT INTO msy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Gumazamizir avɨriba me amegha bar izɨfa. Ezɨ gɨn suren gumaziba dagher nar me taghiziba, me da inigha 7 pla akɨrabagh aghuizɨma, da izɨfa. ");
INSERT INTO msy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Dughiar kamɨn itir gumazamizibar dɨbobonim 4,000ɨn boroghɨn ghu. Me amezɨma, a me amadazɨ, me uan nguibabar ghue. ");
INSERT INTO msy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Me zuima, a uan suren gumaziba koma botɨn bɨnigha, Daramanutan danganimɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ezɨ Farisiba izegha ifavarir azangsɨzibar Iesus gami. Eghtɨ, God gavgavim a danightɨ, a mirakelɨn arazitam damightɨ, me ganigh fogh suam, God guizbangɨra anemada. ");
INSERT INTO msy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ezɨ a men azangsɨzir ifavaribar amɨragha ghuariaba suegha, egha me mɨgei, “Ia datɨrɨghɨn itir gumazamizir kaba tizim bagha mirakelɨn arazim bagha nan azangsɨsi? Kɨ guizbangɨra ia mɨgei, God mirakelɨn arazitam ian akaghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Egha a me ategha uamategha botɨn bɨragha, egha dɨpamɨn vongɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Egha me ghuava Iesusɨn suren gumaziba bretba bakɨnɨghɨnigha ize. Me bretɨn vamɨra inizɨma a me ko botɨn iti. ");
INSERT INTO msy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ezɨ Iesus akar gavgavimɨn kamaghɨn me mɨgei, “Ia deragh uari bagh gan! Ia deravɨra Farisibar yis ko Herotɨn yis bagh deravɨra gan.” ");
INSERT INTO msy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iesus me mɨkemezɨma, me kamaghɨn uarira uariv gei, “E bret tam inigha izezir puvatɨzɨ, kamaghɨn amizɨma an e mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Me uarira uariv geima, Iesus men mɨgɨrɨgɨabagh fogha kamaghɨn men azara, “Ia tizim bagha ghaze, e bret tam inigha izezir puvatɨ? Eee, ia kɨ amir bizibar garava, fozir puvatɨ. Ia tɨghar deraghvɨra dagh fofogham? Ian nɨghnɨziba bar otefe. ");
INSERT INTO msy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ia damaziba ikia, garir puvatɨ? Ia kuariba ikia, orazir puvatɨ? Ia bizir kabagh nɨghnɨzir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ia, kɨ bretɨn 5 pla bɨagharigha ia ganɨngizɨma, ia 5,000ɨn gumazibagh anɨngizɨma, me da apa izɨvagha, ataghizir naba ia da akɨraba manmaghɨn aghui?” Me kamaghɨn a ikara, “E 12 pla akɨrabagh aghui.” ");
INSERT INTO msy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ezɨ a ua kamaghɨn me mɨgei, “Ezɨ kɨ bretɨn 7 pla bɨagharigha ia ganɨngizɨma, ia 4,000ɨn gumazamizibagh anɨngizɨma, me da apa izɨvazɨ ia dar naba akɨraba manmaghɨn aghui?” Me kamaghɨn a ikara, “E 7 pla akɨrabagh aghui.” ");
INSERT INTO msy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Me kamaghɨn a mɨgeima, a kamaghɨn me mɨgei, “Eee, ia tɨghar bizibagh fofogham.” ");
INSERT INTO msy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Egha me Betsaidan ghuezɨma, gumazir maba gumazir damazir kurar mam inigha, Iesus bagha izi. Me izegha dafarim a darɨghasava Iesus gakaghori. ");
INSERT INTO msy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ezɨ Iesus gumazir damazir kuramɨn agharimɨn suiragha, a inigha nguibam ategha azenan ghu. Aning azenan ghugha, egha Iesus gumazimɨn damazimning giparigha uan dafarimning a gisɨn atɨgha kamaghɨn an azara, “Nɨ bizitamɨn gari?” ");
INSERT INTO msy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ezɨ gumazir kam kogha garava kamaghɨn mɨgei, “Are, kɨ garima, gumaziba temebar mɨn garav arui.” ");
INSERT INTO msy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ezɨ Iesus ua uan dafarimning an damazimningɨn suirazɨma, gumazimɨn damazimning kuiaghrɨzɨma, a ua deragha bizibar gari. ");
INSERT INTO msy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ezɨ Iesus anemaga kamaghɨn mɨgei, “Nɨ ua nguibar kamɨn aven mangan markɨ. Nɨ uan dɨpenimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Egha Iesus uan suren gumaziba ko dɨkavigha Sisaria Filipain nguibar ekiamɨn boroghɨn itir nguibar dozibar zui. Me ghuava a tuavimɨn men azara, “Gumazamiziba tina na garɨsi?” ");
INSERT INTO msy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Me a ikaragha kamaghɨn mɨgei, “Marazi ghaze, nɨ Jon, Gumaziba Ruer Gumazim. Ezɨ marazi ghaze, nɨ Godɨn akam inigha izir gumazim Elaija. Ezɨ marazi ghaze, nɨ fomɨra ikezir Godɨn akam inigha izir gumazir mam.” ");
INSERT INTO msy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ezɨ Iesus kamaghɨn men azara, “Ezɨ ia? Ia tina na garɨsi?” Ezɨ Pita kamaghɨn a ikara, “Nɨ Krais, God Ua e Iniasa Mɨsevezir Gumazim.” ");
INSERT INTO msy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ezɨ Iesus akar gavgavimɨn kamaghɨn me mɨgei, “Ia nan gun gumazitam mɨkɨman markɨ suam, kɨ tina.” ");
INSERT INTO msy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Egha Iesus men sure gamuava kamaghɨn mɨgei, “Gumazibar Otarim bar mɨzazir ekiaba koma osɨmtɨziba iniam. Eghtɨma gumazir aruaba, koma ofa gamir gumazir ekiaba, koma Judan arazibagh fozir gumaziba, me an aghuaghɨva a mɨsueghtɨma an aremegham. Egh dughiar pumuning ko mɨkezim gɨvaghtɨ a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesus kamaghɨn uan ovevem aghurigha me mɨgeima, ezɨ Pita a inigha mɨriamɨn ghugha, an atarava kamaghɨn a mɨgei, “Nɨ kamaghɨn mɨkɨman markɨ.” ");
INSERT INTO msy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","A kamaghɨn mɨgeima, Iesus ragha uan suren gumazibar garava, Pitan atarava kamaghɨn a mɨgei, “Satan, nɨ na gitagh mangɨ! Nɨ nguazimɨn bizibagh nɨghnɨgha egha Godɨn bizibagh nɨghnɨzir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Egha Iesus gumazamiziba ko uan suren gumazibar, diazɨma, me a bagha izima, a kamaghɨn me mɨgei, “Gumazitam nan gɨn izɨsɨ, a ifongezir biziba gɨn amadagh uan temer ighuvim gisaghpugh nan gɨn izɨ. ");
INSERT INTO msy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Gumazir manam uan ikɨrɨmɨrimɨn suiraghsɨ nɨghnɨghtɨ, an ikɨrɨmɨrim gɨvagham. Eghtɨ gumazir manam akar aghuim ko na bagh uan ikɨrɨmɨrim ateghɨva, a uan ikɨrɨmɨrim iniam. ");
INSERT INTO msy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gumazitam nguazimɨn itir biziba bar da iniva, egh a gɨn oveghtɨ, bizir kaba manmaghɨn an akuragham? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A ivezir manam uan duam bagh anerenɨngam? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ezɨ datɨrɨghɨn itir gumazamiziba me God akɨrim ragha a gasaragha arazir kurabagh ami. Men tina nan ziam ko nan akar aghuimɨn gun mɨkɨman aghumsɨghtɨ gɨn Gumazibar Otarim uan afeziamɨn boroghɨn ikeghɨva Godɨn damazimɨn zuezir enselba koma Godɨn angazangarim sara izighirɨva, uaghan men aghumsɨgham.” ");
INSERT INTO msy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iesus mɨgɨa ghua kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, ia kagh tuivighav itir darasi, ian tarazi oveghan kogham. Ia ikɨvɨra ikɨ gantɨma, God Bizibagh Ativamin Dughiam gavgavim sara izighram.” ");
INSERT INTO msy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ezɨ dughiar 6 pla gɨvazɨma, Iesus Pita koma Jems ko Jon me inigha mɨghsɨar ekiamɨn ghuavanabogha, me uarira kagh iti. A kagh an mɨkarzim men damazimɨn igharaghav oto. ");
INSERT INTO msy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","An korotiabar angazangarir gavgavir kam guizbangɨra ghurghuri. Ghurghurir kam nguazimɨn gumazitam ruezir bizir ghurghuritam an mɨn garir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ezɨ me garima Elaija ko Moses otogha Iesus ko me uariv gei. ");
INSERT INTO msy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Me uariv gɨavɨra itima, Pita, Jems ko Jon me bar atiatigha, Pita mɨkɨmamin mɨgɨrɨgɨabagh asagha pura kamaghɨn Iesus mɨgei, “Tisa, bar deragha e kagh iti! E averpenir pumuning ko mɨkezimɨn ingaram. Nɨ bagh tam, Moses bagh tam, egh Elaija bagh tam.” ");
INSERT INTO msy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ezɨ ghuariam otogha me avarazɨma ezɨ tiarir mam ghuariamɨn tongɨn otogha kamaghɨn mɨgei, “Kar nan Otarir kɨ bar ifongezim. Ia anarɨram oragh!” ");
INSERT INTO msy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Egha zuamɨra me gara ua gumazitamɨn garir puvatɨ. Iesus uabɨra me ko iti. ");
INSERT INTO msy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Egha me uamategha mɨghsɨamɨn izaghrava Iesus bizir otozir me ganizimɨn gun gumazitam mɨkɨman bar men anogoroke. Kamaghɨra ikɨ mangɨ Gumazibar Otarim aremegh ua dɨkavigham. ");
INSERT INTO msy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Me ganizir bizir kam merara itima, ezɨ me aremegh ua dɨkavighamin mɨgɨrɨgɨar mɨngarim bagha uarira uariv gei. ");
INSERT INTO msy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Egha me an azara, “Manmagh sua Judan arazibagh fozir gumaziba ghaze, Elaija faragh izeghtɨ, God Ua e Iniasa Mɨsevezir Gumazim gɨn izam?” ");
INSERT INTO msy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ezɨ Iesus men azangsɨzim ikara, “Guizbangɨra Elaija faragh izeghɨva bizibar akɨram. Ezɨ tizim bagha fomɨra Godɨn Akɨnafarimɨn osizirim kamaghɨn iti, ‘Gumazibar Otarim osɨmtɨzir avɨribar aven mangɨtɨ me akɨrim a gasaragham?’ ");
INSERT INTO msy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ezɨ kɨ ia mɨgei, Elaija izegha gɨfa. Ezɨ gumazamiziba akɨnafarimɨn osizirir an gun mɨkemezimɨn mɨrara, me uan arazir me ifongezibar a gami.” ");
INSERT INTO msy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Egha me iza suren gumazir maba bativigha garima gumazamizir avɨrim me akuvazɨ Judan arazibagh fozir gumaziba me ko uariv gɨa uari adosi. ");
INSERT INTO msy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Me uari adozima gumazamiziba Iesusɨn garavɨra dɨgavir kuram gamigha dughiam a danɨngasa ivegha zui. ");
INSERT INTO msy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Egha a kamaghɨn men azara, “Ia tizim bagha me ko ia uari adosi?” ");
INSERT INTO msy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ezɨ gumazir mam gumazamizir avɨrimɨn torimɨn ikiava kamaghɨn mɨgei, “Tisa, kɨ uan otarim inigha nɨ bagha ize, duar kuram a gapazazɨma, a mɨgeir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Egha an a gamir dughiamɨn, an anekurima a daghira, pupuviba an akam mɨsevima an atariba uariv tivima a mɨkɨrvasi. Kɨ duar kuram batoghasa nɨn suren gumazibar azarazɨ me a batoghezir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ezɨ Iesus kamaghɨn mɨgei, “Oio! Kɨ bar amɨra, datɨrɨghɨn itir gumazamiziba nɨghnɨzir gavgaviba puvatɨ. Kɨ fomɨra ia ko itima, ia dazoghɨn bizitam gɨfogham? Kɨ dughiabar zurara ian osɨmtɨziba ateram? Otarim inigh na bagh izɨ.” ");
INSERT INTO msy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ezɨ me otarim Iesus bagha a inigha ize. Ezɨma duar kuram Iesusɨn apigha, maghɨra otarim gamima a nɨsi. A nguazim girɨgha poghpogha pupuviba an akam mɨsefi. ");
INSERT INTO msy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ezɨ Iesus otarimɨn afeziamɨn azara, “A man dughiamɨn duar kuram a gapasa?” Ezɨ afeziam kamaghɨn mɨgei, “An aghɨrimra itima an a gapasa. ");
INSERT INTO msy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","An a damightɨ an aremeghasa dughiar avɨribar anekurima an aviba ko dɨpabar ghuaghiri. Nɨ bizir kabar amuva, en apangkuvigh en akurvagh.” ");
INSERT INTO msy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ezɨ Iesus kamaghɨn mɨgei, “Nɨ uabɨ! Nɨ nɨghnɨzir gavgavim ikɨtɨ biziba bar deragham.” ");
INSERT INTO msy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ezɨ otarimɨn afeziam zuamɨra kamaghɨn diagha mɨgei, “Kɨ nɨghnɨzir gavgavim ikiava, an otefe. Ezɨ nɨ nan akuragh!” ");
INSERT INTO msy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Egha Iesus garima gumazamiziba ivemara men boroghɨn zuima a duar kuram batogha kamaghɨn a mɨgei, “Nɨ duar kurar gumazibagh ami me orazi puvatɨzim ko mɨgeir puvatɨzim, kɨ nɨ mɨgei, azenan izɨ egh uam aven mangan markɨ!” ");
INSERT INTO msy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ezɨ duar kam aregha pamtemɨn a gunabagha azenan ize. Ezɨ otarim gumazir kuamɨn mɨn gari, ezɨ me bar kamaghɨn mɨgei, “An areme.” ");
INSERT INTO msy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ezɨ Iesus an agharimɨn suiragha a ghufezɨ a dɨkavigha tu. ");
INSERT INTO msy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Egha Iesus dɨpenimɨn aven ghuzɨma an suren gumaziba mogomemɨn kamaghɨn an azara, “Manmagh amizɨ, e duar kurar kam batoghava avenge?” ");
INSERT INTO msy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ezɨ a kamaghɨn me ikara, “Duar kurar kamaghɨn amiba God ko mɨgeir arazimɨn gavgavimɨn azenan izi.” ");
INSERT INTO msy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Egha me danganir kam ategha Galilin Distrighɨn otogha zui. Me ghuava Iesus uan suren gumazibar sure gami. Bizir kamɨn Iesus me iti naghɨn gumazitam foghan an aghua. Me ghua, a kamaghɨn me mɨgei, “Me Gumazibar Otarim isɨva gumazibar dafarim darɨgham. Eghtɨ me a mɨsueghtɨ an ovegham. Eghtɨ dughiar pumuning ko mɨkezim gɨvaghtɨ a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ezɨ me mɨgɨrɨgɨar a mɨkemezim a gɨfozir puvatɨgha, egha a bagha an azangsɨghan atiatingi. ");
INSERT INTO msy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Egha me Kaperneamɨn izegha dɨpenimɨn aven ikia Iesus men azara, “Ia tuavimɨn tizim mɨgɨa uari batosi?” ");
INSERT INTO msy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Me tuavimɨn tinara ekiam, a mɨgɨrɨgɨam gamua uari batoke. Kamaghɨn me nɨmɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Egha Iesus aperaghav ikiava suren gumazir 12 plan diagha kamaghɨn mɨgei, “Tina faragh ikɨsɨ, a bar gɨn kegh egh gumaziba bar men ingarir gumazimɨn otogh.” ");
INSERT INTO msy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Egha a borir dozim inigha me uan tongɨn anefazɨ a tughav iti. Egha a uan agharimning a muigha kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Gumazitam na gɨnɨghnɨgh egh borir dozir kamagh garitam inigh an akuragham, kamaghɨn a na inigha nan akurvasi. Egha nɨ tina nan akurvasi, nɨ na gamir puvatɨ. Nɨ uaghan gumazir na amadazim gami.” ");
INSERT INTO msy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Egha Jon kamaghɨn a mɨgei, “Tisa, e garima gumazir mam duar kurabar nɨn ziamɨn da batosi. E fo, a en mav puvatɨ, ezɨma e an anogorosi.” ");
INSERT INTO msy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ezɨ Iesus kamaghɨn mɨgei, “An anogoroghan markɨ. Gumazitam nan ziamɨn mirakel damigh, egh dughiar igharazim akar kuraba na damighan kogham. ");
INSERT INTO msy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tina en apanim gami puvatɨ a enanav. ");
INSERT INTO msy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɨ guizbangɨra ia mɨgei, ia Gumazir God Uam E Iniasa Mɨsevezimɨn adarasi. Kamaghɨn tina nan ziamɨn dɨpatam ia daningɨva a guizbangɨra uan ivezim iniam.” ");
INSERT INTO msy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesus mɨgɨa ghua kamaghɨn mɨgei, “Eghɨva tina nɨghnɨzir gavgavim nan itir borir katam damightɨ an arazir kuratam damightɨ, a helɨn mangɨva, a bar ivezir kuram inigham. Kamaghɨn dera, me dagɨar ekiam an fɨrim dafaghɨva ongarim mɨkɨnightɨ an aremegham. ");
INSERT INTO msy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Egh nɨn agharim nɨ damightɨ na arazir kuratam damighɨva, anetugh. Kamaghɨn dera, nɨ agharir vamɨra ikɨva zurara itir ikɨrɨmɨrir aghuarimɨn aven mangam. Nɨ agharir pumuning vɨrara ikɨva helɨn mangam, nguibar avim mungemari puvatɨzim. ");
INSERT INTO msy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Egh nɨn suem nɨ damightɨ na arazir kuratam damighɨva, anetugh. Kamaghɨn dera, nɨ suer vamɨra ikɨva zurara itir ikɨrɨmɨrir aghuarimɨn aven mangam. Nɨ suer pumuning vɨrara ikɨtɨ me nɨ isɨva helɨn nɨ akunigham. ");
INSERT INTO msy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Egh nɨn damatuzim nɨ damutɨ na arazir kuratam damighɨva anesigh. Kamaghɨn dera, nɨ damazir vamɨra ikɨva God Bizibagh Ativamin Dughiamɨn aven mangam. Nɨ damazimning vɨrara ikɨtɨ, God nɨ isɨva helɨn nɨ akunigham. ");
INSERT INTO msy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Danganir kam ‘Apizir nguzir men mɨkarziba apiba gɨvaghan kogham. Ezɨ men mɨkarziba isir avim uaghan mungueghan kogham.’ ");
INSERT INTO msy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Gumaziba ofa God danɨngasa, me amangsɨzim ofa gamir daghebagh arɨgha avimɨn da tuava da isa, egha God ganɨdi. Amangsɨzim koma avim ofa gamir daghebagh amima da Godɨn damazimɨn zue. Kamaghɨra osɨmtɨziba gumazamiziba bativam. Egh me damutɨ, me Godɨn damazimɨn zuegham. ");
INSERT INTO msy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Amangsɨzim a dera, egh a uan sɨngtɨzim ateghtɨ, nɨ manmaghɨn a damightɨ a ua sɨngigham? Ia amangsɨzim inigh uari datɨgh, egh ia uari ko navir amɨrɨzimɨn ikɨ.” ");
INSERT INTO msy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Egha Iesus nguibar kam ategha ghua, Judian Distrighɨn ghua Jordanɨn dɨpamɨn vongɨn oto. An otozɨma, gumazamizir avɨriba ua izava, anekuvazɨma, a zurara ami moghɨn men sure gami. ");
INSERT INTO msy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A men sure gamima, Farisin maba izava a gifarava kamaghɨn an azara, “Nɨ e mɨkɨm, en arazim manmaghɨn mɨgei? Gumazim uan amuim ateghamin arazir kam deras, ti puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A men azangsɨzim ikaragha kamaghɨn men azara, “Moses arazir manam damuasa ia mɨkeme?” ");
INSERT INTO msy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ezɨ me kamaghɨn mɨgei, “Moses, gumazitam amuim ateghsɨ poroghamning uaning ataghraghamin akɨnafarir avɨzim osirigh amizim amadaghasa, an e mɨkeme.” ");
INSERT INTO msy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ezɨ Iesus kamaghɨn me ikara, “Ian naviba gavgafi, kamaghɨn amizɨma Moses ia bagha arazir kam osiri. ");
INSERT INTO msy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bar fomɨra God nguazir kam ko biziba bar dagh amuavɨra gumaziba ko amizibagh ami. ");
INSERT INTO msy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kamaghɨn amizɨma, gumazim uan afeziam ko amebam ateghɨva, a uan amuim ko aning uaningɨn porogham. ");
INSERT INTO msy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Egh aning nivafɨzir vamɨram otogham. Aning ua gumazir pumuning puvatɨ. Aning nivafɨzir vamɨra ikiam ");
INSERT INTO msy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kamaghɨn amizɨma God bizir pumuning isafuraghtɨma, gumazitam aning abighan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Egha me uamategha dɨpenimɨn aven ghua, Iesusɨn suren gumaziba bizir kam bagha an azara. ");
INSERT INTO msy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A me ikaragha kamaghɨn mɨgei, “Gumazitam uan amuim ategh amizir igharazimɨn ikɨva, gumazir kam uan amuim gasɨghasɨgha poroghamiba uari bakɨa uari isava akuir arazim gami. ");
INSERT INTO msy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ezɨ amizitam uan pam ategh gumazir igharazimɨn ikɨva, amizir kam poroghamiba uari bakɨa uari isava akuir arazim gami.” ");
INSERT INTO msy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ezɨ gumazamiziba borir doziba inigha Iesus bagha izi. Eghtɨ a uan dafarimning me gisɨn darɨghasa me izima, an suren gumaziba men atarava men anogorosi. ");
INSERT INTO msy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Me men atarima, Iesus men ganigha navim an ikuvizɨma, a kamaghɨn me mɨgei, “Nɨ tina God Bizibagh Ativamin Dughiamɨn aven ikɨsɨ, borir dozir kabar mɨn ikɨ. Kamaghɨn amizɨma borir doziba ateghtɨma, me na bagh izɨ. Men anogoroghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kɨ guizbangɨra ia mɨgei, gumazitam borir dozir kabar mɨn God Bizibagh Ativamin Dughiam inighan koghɨva, egh an aven mangan bar iburagham.” ");
INSERT INTO msy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A kamaghɨn me mɨkemegha, boriba vaghvagha me isa me musi. Egha dafarim vaghvagha me gisɨn arɨghava, God arazir aghuim me damuasa Godɨn mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Egha Iesus dɨkavigha zuima, gumazir mam ivegha izava, uan tevimning apɨrighava Iesusɨn guamɨn kamaghɨn a mɨgei, “Tisan Aghuim, kɨ manmaghɨn damigh zurara itir ikɨrɨmɨrir aghuarim iniam?” ");
INSERT INTO msy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ezɨ Iesus a ikaragha kamaghɨn a mɨgei, “Nɨ manmagh sua gumazir aghuim na garɨsi? Gumazir aghuitam itir puvatɨ. God uabɨra gumazir aghuarim. ");
INSERT INTO msy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nɨ God Moses ganɨngizir arazim gɨfo, ‘Nɨ gumazim mɨsueghtɨ an aremeghan markɨ, nɨ poroghamiba uari bakeir arazim damuam markɨ, nɨ gumazir igharazimɨn biziba okɨman markɨ, nɨ bizibagh ifaran markɨ, nɨ ua bagh biziba inisɨ gumazibagh ifaran markɨ, nɨ uan afeziam ko amebamɨn apengan ikɨ aningɨn akaba baragh.’” ");
INSERT INTO msy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ezɨ an a ikaragha kamagh mɨgei, “Tisa, kɨ fomɨram aghɨrimra ikiava arazir kabagh amua iza datɨrɨghɨn ikia kati.” ");
INSERT INTO msy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ezɨ Iesus gumazir kamɨn garava, a gifongegha kamaghɨn a mɨgei, “Nɨ bizir vamɨra nɨ tɨghar a damuam. Bizir nɨ itiba bar da amadaghɨva dagɨaba inigh, egh gumazir biziba puvatɨzibar anɨngigh. Egh nɨ Godɨn Nguibamɨn bizir aghuariba iniam. Egh, nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ezɨ gumazir kam akar kam baregha, an guam mɨsɨngi. A fo, a guizbangɨra bizir avɨriba itir gumazim. A kamaghɨn, an navim bar osemezɨ a ghu. ");
INSERT INTO msy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ezɨ Iesusɨn damaziba uan suren gumazibagh aruava, kamaghɨn me mɨgei, “Gumazir biziba avɨrasemeziba, me God Bizibagh Ativamin Dughiamɨn mangɨsɨ bar iburagham!” ");
INSERT INTO msy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","An suren gumaziba an akar kaba baregha, dɨgavir kuram gamizɨma, Iesus ua kamaghɨn me mɨgei, “Boriba, gumazim God Bizibagh Ativamin Dughiamɨn aven mangɨsɨ, a guizbangɨra bar iburagham. ");
INSERT INTO msy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelɨn tam iniba isair dɨkonir torimɨn aven mangɨsɨ ingangarir dafam damigh aven mangam. Eghtɨ gumazir biziba avɨrasemeziba, me God Bizibagh Ativamin Dughiamɨn aven mangɨsɨ guizbangɨra bar iburagham!” ");
INSERT INTO msy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","A me mɨgeima, me guizbangɨra dɨgavir kuram gamuava nɨghnɨzir avɨribagh amuava uarira uariv gei, “Kamaghɨn damightɨma, tinara zurara itir ikɨrɨmɨrir aghuir kam iniam?” ");
INSERT INTO msy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ezɨ Iesus men garava kamaghɨn me mɨgei, “Bizir kaba gumazimɨn bar osemegham. Bizir kaba Godɨn osemezir puvatɨ. A biziba bar dagh ami.” ");
INSERT INTO msy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ezɨ Pita kamaghɨn a mɨgei, “Nɨ ge, e uan biziba bar da ategha, nɨn gɨn ize.” ");
INSERT INTO msy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ezɨ Iesus kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, gumazitam nan akar aghuim ko na bagh, uan dɨpenim, o uan aveghbuaba, o uan buaramiziba, o uan afeziam ko amebam, o uan boriba, o uan azeniba ategh, ");
INSERT INTO msy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","egh gumazir kam datɨrɨghɨn nguazir kamɨn God guizbangɨra bizir a faragha itiba bar dagh afiragh a danɨngam. A dɨpenir avɨriba ko aveghbuaba ko buaramiziba ko amebaba ko borir avɨriba, ko azenir avɨriba a danɨngam. Eghtɨ Godɨn gɨn zuir gumazibagh asɨghasɨzir araziba a uaghan dar aven ikiam. Eghtɨma dughiar gɨn izamim zurara itir ikɨrɨmɨrir aghuarim an a danɨngam. ");
INSERT INTO msy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Datɨrɨghɨn dughiar kamɨn faragha itir gumazir avɨriba, me gɨn ikɨtɨma, datɨrɨghɨn gɨn itir gumazir avɨriba, me gɨn faragh mangam.” ");
INSERT INTO msy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Egha me Jerusalemɨn ghuavanagava Iesus farazɨma, an suren gumaziba an gɨn ghua nɨghnɨzir avɨribagh amima, me ko zuir gumazamiziba atiati. Ezɨ Iesus ua uan 12 plan suren gumaziba inigha me mɨriamɨn ghughava, a bativamin bizibar gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A kamaghɨn me mɨgei, “Ia oragh. E nguibar ekiam Jerusalemɨn ghuavanadi. Eghtɨ gumazitam Gumazibar Otarim isɨva, Judan arazibagh fozir gumaziba koma ofa gamir gumazir ekiabar anɨngam. Eghtɨ me a isɨ kot datɨghɨva, egh a mɨsueghtɨ an aremeghsɨva akabar akɨram, egh me kamaghɨn a mɨkɨm suam, An aremegham. Egh me a mɨsueghtɨ an aremeghsɨva, a inigh Kantrin Igharazibar Gumazibar dafaribar arɨgham. ");
INSERT INTO msy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Egh Kantrin Igharazibar Gumaziba, me dɨbovir akabar a mɨkɨmɨva, a giparɨva, a fozoroghɨva, egh a mɨsueghtɨ an aremegham. An aremeghtɨ, dughiar pumuning ko mɨkezim gɨvaghtɨ a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ezɨ Sebedin otarimning, Jems ko Jon, Iesus bagha izava kamaghɨn mɨgei, “Tisa, ga bizir mam bagha ifonge. Nɨ ga bagha a damuasa ga nɨn azai.” ");
INSERT INTO msy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ezɨ Iesus kamaghɨn aningɨn azara, “Kɨ manmaghɨn guan akurvagham?” ");
INSERT INTO msy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aning a ikaragha kamaghɨn mɨgei, “Nɨ atrivir ekiamɨn otoghɨva egh ga damightɨ gan tav nɨn agharir guvim daperaghtɨ, tav nɨn agharir kɨriam daperagham.” ");
INSERT INTO msy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ezɨ Iesus kamaghɨn mɨgei, “Gua azangsɨzir bizir kam, gua an mɨngarim gɨfozir puvatɨ, egha ia a bagha nan azai. Gua ti kɨ ateramin osɨmtɨzim, uaghan an ateramin gavgavim iti? O osɨmtɨzir dɨpar kɨ ruamim gua uaghan a guruam?” ");
INSERT INTO msy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ezɨ aning a ikara, “Are, ga gavgavim iti.” Ezɨ Iesus kamaghɨn aning mɨgei, “Guizbangɨra, gua kɨ ateramin osɨmtɨzim, gua a iniam, egh osɨmtɨzir dɨpar kɨ ruamim gua a guruam. ");
INSERT INTO msy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Egha gua nan agharir guvim ko kɨriam dapiasa azangsɨsi, kar nan bizim puvatɨ. Danganir kaba Godɨn bizimra. A danganir kabar dapiamin gumaziba, a me gɨfogha, me bagha danganir kabagh ami.” ");
INSERT INTO msy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ezɨ Jems ko Jon bizir kamɨn Iesus mɨgeima, 10 plan suren gumazir igharaziba a baregha, bizir kam bagha Jems ko Jonɨn atari. ");
INSERT INTO msy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ezɨ Iesus men diagha, me akuvagha kamaghɨn me mɨgei, “Ia fo, Kantrin Igharazibar atriviba pamten me gamima, me bar men apengan iti. Ezɨ men gumazir dapaniba uan akaba baraghasa puvɨra me abɨraghbɨrasi. ");
INSERT INTO msy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eghtɨ arazir kaba ian tongɨn ikian kogham. Gumazir manam ian tongɨn ekiamɨn ikɨsɨ, a ingangarir gumazimɨn mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Eghtɨ gumazir manam ian faragh mangɨsɨ, a bar ian ingangarir gumazir kɨnimɨn mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ezɨ kamaghɨra Gumazibar Otarim iza, gumazamizibar amutɨ me a bagh ingarasa, a izezir pu. Puvatɨ, a me bagh ingarasa ize. A gumazamizir avɨriba bagh ovegh ua me givezegh me iniasa ize.” ");
INSERT INTO msy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Egha Iesus uan suren gumaziba ko Jerikon izegha, egha gumazamizir avɨrim sara nguibar ekiam ataghrasi. Ezɨ gumazir damazir kurar mam, an ziam Bartimeus (Timeusɨn otarim), a tuavir mɨriamɨn aperaghav ikiava biziba bagha inge. ");
INSERT INTO msy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Egha an orazima Nasaretɨn gumazim Iesus uaghan iza zuima a dia ghaze, “Iesus Devitɨn Otarim, nan apangkufigh!” ");
INSERT INTO msy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ezɨ gumazamizir avɨriba dɨman an anogoregha egha nɨmɨra ikiasava a mɨgei. Ezɨ a pamtem diavɨra iti, “Devitɨn Otarim nan apangkufigh!” ");
INSERT INTO msy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ezɨ Iesus tugha kamaghɨn mɨgei, “An diagh.” Ezɨ me gumazir damazir kuramɨn diagha ghaze, “Nɨ uabɨn gavgafigh, egh dɨkafigh! Iesus nɨn dei.” ");
INSERT INTO msy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ezɨ a uan korotiar azenan azuim suegha anekunigha zuamɨra dɨkavigha Iesus bagha ize. ");
INSERT INTO msy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ezɨ Iesus an azara, “Kɨ nɨ bagh tizim damuasa nɨ ifonge?” Ezɨ gumazir damazir kuram kamaghɨn mɨgei, “Tisa, kɨ ganasa ifonge.” ");
INSERT INTO msy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ezɨ Iesus kamaghɨn a mɨgei, “Mangɨ. Nɨ nɨghnɨzir gavgavim Godɨn itima, a nɨ gamizɨ nɨ ua dera.” Ezɨ zuamɨra a ua gari. Egha a Iesusɨn gɨn tuavimɨn zui. ");
INSERT INTO msy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Egha Iesus uan suren gumaziba ko Jerusalemɨn boroghɨn izava Betfage ko Betanin boroghɨn Olivɨn mɨghsɨamɨn oto. Egha Iesus uan suren gumazir pumuning aning amaga, ");
INSERT INTO msy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kamaghɨn aning mɨgei, “Gua nguibar munagh itimɨn mangɨ, gua an mangɨva gantɨma donkin igiar mam, me a ikezɨma, a iti. Gumazitam dughiatamɨn a gaperaghava aruizir puvatɨ. Gua an benim fɨrighɨva a inigh kagh izɨ. ");
INSERT INTO msy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eghtɨ tav guan azang suam, ‘Gua tizim bagha donki fɨri?’ gua kamaghɨn a mɨkɨm, ‘Ekiam ingangarim an iti. A uam anemangam.’” ");
INSERT INTO msy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ezɨ aning ghua garima, me donki dɨpenir tiar akamɨn azenan tuavimɨn a ike. Ezɨ aning a fɨrima, ");
INSERT INTO msy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","gumazir maba tuivighav ikia aningɨn azara, “Gua tizim bagha donkin benim fɨri?” ");
INSERT INTO msy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ezɨ Iesus aning mɨkemezɨ moghon aning men akam ikara. Ezɨ gumaziba aningɨn amamangatɨzɨma aning zui. ");
INSERT INTO msy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Egha aning donki inigha Iesus bagha izeghava uan korotiar azenan azuiba suegha donki gisɨn da ghuani. Ezɨ Iesus a gisɨn apera. ");
INSERT INTO msy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ezɨ gumazamizir avɨriba uan korotiar azenan azuiba suegha tuavimɨn da ghuari. Ezɨ marazi ruarimɨn tev seviba aghoregha da arɨsi. ");
INSERT INTO msy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Egha faragha zuiba ko gɨn zuiba me diava ara kamaghɨn mɨgei, “Hosana! Ia Godɨn ziam fɨ! Gumazir kam Ekiamɨn ziam ko gavgavimɨn izi. God deravɨra a damu.” ");
INSERT INTO msy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“En ovavim Devit fomɨra en atrivimɨn ikezɨ moghɨn gumazir kam en atrivimɨn ikiasa izi. Eghtɨ God deravɨra a damu. Hosana! Biziba bar dar pɨn itir Godɨn ziam fɨ!” ");
INSERT INTO msy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ezɨ Iesus Jerusalemɨn aven ghugha ghua Godɨn Dɨpenir mɨriamɨn ghu. A ghugha biziba dar garava da asavsuisi. Ezɨ aruem gɨvazɨ a suren gumaziba ko me Betanin ghue. ");
INSERT INTO msy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Amɨmɨzaraghan Iesus uan suren gumaziba ko ua Betani ataghragha, Iesus mɨtiriam an azi. ");
INSERT INTO msy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A saghon garima temer fighɨn mam dafaribara iti. Ezɨ a roghɨra mangɨ foghasa a dagheba iti, o puvatɨ. Kar fighɨn temeba bamin dughiam puvatɨ. Ezɨ kamaghɨn a ghua ovɨzitamɨn apizir puvatɨ, dafarir kɨnbaram an iti. ");
INSERT INTO msy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Egha a kamaghɨn temem mɨgei, “Tav gɨn nɨn ovɨzitam rameghan kogham.” An a mɨkemezɨ, an suren gumaziba oraki. ");
INSERT INTO msy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Egha Iesus uan suren gumaziba ko Jerusalemɨn otivigha, Iesus Godɨn Dɨpenir mɨriamɨn ghuava gumazir asɨzir ofa gamibagh iveziba ko asɨzir ofa gamiba amadiba me batosi. Egha dagɨaba uari ikarvazir gumazibar dakoziba ko kuarazir bunbaba amadibar dabirabiba, da fava egha da ighagharɨsi. ");
INSERT INTO msy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Egha a tav bizir amaditam inigh Godɨn Dɨpenir mɨriamɨn aven izɨ mangan an anogoroke. ");
INSERT INTO msy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Egha a men sure gamuava kamaghɨn me mɨgei, “Mɨgɨrɨgɨar kam Godɨn Akɨnafarimɨn osizirimɨn iti, o puvatɨ? ‘Nan dɨpenimɨn ingangarimɨn mɨngarim kamakɨn, kar nguaziba bar men Gumazamiziba God ko Mɨgeir Dɨpenim.’ Ezɨ ia gumazir okeibar danganir mogomemɨn mɨn a gami.” ");
INSERT INTO msy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gumazamizir avɨrim bar an suren mɨgɨrɨgɨaba baregha dɨgavir kuram gami. Ezɨ kamaghɨn ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumaziba Iesusɨn atiatigha, egh me a mɨsueghtɨ an aremeghasa maghɨra tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ezɨ aruem gevima Iesus uan suren gumaziba ko me Jerusalemɨn nguibar ekiam ategha azenan zui. ");
INSERT INTO msy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Egha mɨzaraghara Iesus uan suren gumaziba ko ghua garima temer fighɨn biba sara mɨsɨngi. ");
INSERT INTO msy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ezɨ Pita nɨrɨgha Iesus mɨgei, “Tisa nɨ gan, temer fighɨn nɨ asɨghasɨghasa mɨkemezim, a mɨsɨngi!” ");
INSERT INTO msy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iesus an mɨgɨrɨgɨam ikaragha kamaghɨn me mɨgei, “Nɨghnɨzir gavgavim Godɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kɨ guizbangɨra ia mɨgei, tina mɨghsɨar kam mɨkɨm suam, ‘Mangɨ uabɨ fegh ongarim mɨkɨnigh,’ egh uan navir averiamɨn igharagh nɨghnɨghan kogh, egh nɨghnɨzir gavgavim a mɨkemezir bizimɨn ikɨ suam, ‘An otivam,’ eghtɨ bizir kam a bagh otogham. ");
INSERT INTO msy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kamaghɨn amizɨma kɨ ia mɨgei, ia bizir tizim bagh God ko mɨgeir dughiam an azangsɨgh, egh nɨghnɨzir gavgavim ikɨ suam, ‘Kɨ a inigha gɨfa,’ nɨ bizir kam inigham. ");
INSERT INTO msy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Egh nɨ tugh God ko mɨkɨmɨva egh osɨmtɨzim tinan iti, nɨ an arazir kuram gɨn amadagh, eghtɨ kamaghɨn nɨn Afeziar Ekiar uan nguibamɨn itim nɨn arazir kuraba gɨn amadagham.” ");
INSERT INTO msy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Egha Iesus uan suren gumaziba ko uamategha Jerusalemɨn otogha Iesus Godɨn Dɨpenimɨn mɨriamɨn aven aruima, ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumaziba ko Judan gumazir dapaniba a bagha ize. ");
INSERT INTO msy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Egha Iesusɨn azara, “Nɨ gavgavir manamɨn amodoghɨn bizir kabagh ami? Egha tina bizir kabar amuasa gavgavim nɨ ganɨngi?” ");
INSERT INTO msy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ezɨ Iesus me ikara, “Kɨ azangsɨzir mam ia damuasa ia na mɨkemeghtɨ kɨ gavgavir manamɨn bizir kabagha amimɨn gun ia mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jonɨn rurim—kar Godɨn bizim, o gumazibar bizim? Na mɨkemegh!” ");
INSERT INTO msy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ezɨ me uarira uariv kemegha ghaze, “E suam, ‘An rurim Godɨn ize,’ eghtɨma a kamaghɨn ua en azaragham, ‘Ia manmaghɨn amigha nɨghnɨzir gavgavim Jon damuan aghua?’ ");
INSERT INTO msy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Eghtɨ e suam, ‘An rurim gumazibar ize’....” (Gumazamiziba bar moghɨra fo, Jon a guizbangɨra Godɨn akam inigha izir gumazim, kamaghɨn me gumazamizibar atiatingi.) ");
INSERT INTO msy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Egha me Iesusɨn azangsɨzim ikaragha kamaghɨn mɨgei, “E fozir puvatɨ.” Ezɨ Iesus kamaghɨn mɨgei, “Kamaghɨra, kɨ uan gavgavim inizir tuavimɨn, gun ia mɨkemeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ezɨ Iesus akar isɨn zuibar Judan gumazir dapanibav gei, “Gumazir mam wainɨn azenim oparigha an dɨvazim aghui. Egha wainɨn ovɨziba mɨrmɨramin itarim gukuigha pɨn ikɨ wainɨn azenimɨn ganamin dɨpenimɨn ingari. Egha a wainɨn azenim isa wainɨn azenimɨn ganamin gumazir mabagh anɨngi (eghtɨ me gɨn wain taba uam a ikaragham). Egha saghon igharagha ghu. ");
INSERT INTO msy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ezɨ wainɨn ovɨziba kuaramin dughiam otozɨ, wainɨn azenir ghuavim ingangarir gumazir mam amadazɨ a wainɨn ovɨzir taba iniasa wainɨn azenimɨn garir gumaziba bagha ghu. ");
INSERT INTO msy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ezɨ me an suiragha, a mɨsuegha anemadazɨ a dafaribara uamatenge. ");
INSERT INTO msy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ezɨ a ingangarir gumazir igharazim amadazɨ me a mɨsogha an dapanim abigha aghumsɨzir arazibar a gami. ");
INSERT INTO msy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ezɨ a ua mɨkezim amada, ezɨ kam me a mɨsoghezɨ an areme. Ezɨ an avɨrir igharazir maba saram amangi; maba me pura me mɨsoke, maba me me mɨsoghezɨ me ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ezɨ bar abuananam iti anenemangasa, an otarir kamra, a bar ifongezim. A bar men gɨn anemagava kamaghɨn mɨgɨa ghaze, ‘Me nan otarir kamɨn akam baregh deragh a damuam.’ Egha anemadazɨ a ghu. ");
INSERT INTO msy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ezɨ wainɨn azenimɨn garir gumaziba kamaghɨn uariv gei, ‘Kar gɨn wainɨn azenir kam iniamin otarim. Aria, e uari inigh a mɨsueghtɨ an aremeka. Egh wainɨn azenir kam, e an ghuaviba ikegham.’ ");
INSERT INTO msy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Egha me an suiragha a mɨsoghezɨ an areme. Ezɨ me a isava wainɨn azenimɨn azenan anekuni. ");
INSERT INTO msy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ezɨ wainɨn azenimɨn ghuavim bar manmaghɨra damuam? A izɨva wainɨn azenimɨn garir gumazir kabav soghtɨma me arɨmɨghiram. Egh wainɨn azenim isɨva igharaz darazir aningam. ");
INSERT INTO msy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Ia Godɨn Akɨnafarir osizirir kamɨn ganiz, o puvatɨ? ‘Kar dɨpenir akɨnir ingangarir gumaziba aghuazim, a datɨrɨghɨn dɨpenim aterir guarim gava. Kar Ekiam arazir kam gami, ezɨ an en ganganimɨn bar dera.’” ");
INSERT INTO msy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ezɨ me fo an akar isɨn zuim me gasara, ezɨ kamaghɨn me an suiragh a iniasa tuaviba buri. Egha me an suighasa gumazamizibar atiatigha, anetegha ghue. ");
INSERT INTO msy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Egha gɨn Judan gumazir dapaniba Farisin maba ko Herotɨn gɨn zuir darasi amadazɨ, me Iesus bagha ize. Eghtɨ me Iesusɨn mɨgɨrɨgɨar otevitamɨn an suighasa. ");
INSERT INTO msy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Me izegha kamaghɨn mɨgei, “Tisa, e fo, nɨ zurara guizbangɨra mɨgɨava, mɨgɨrɨgɨar vamɨra gumazamiziba bar me ganɨdi. Gumazir ziaba itiba o gumazir kɨniba, nɨ akar vamɨra me mɨgɨava guizbangɨra Godɨn arazibar men sure gami. E Godɨn arazim gɨn mangɨva, gavmanɨn dagɨaba Sisar danɨngam o puvatɨgham? E ivezam, o ivezan kogham?” ");
INSERT INTO msy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ezɨ Iesus men ifavarim gɨfogha kamaghɨn men azara, “Ia tizim bagha na gifari? Dagɨatam na bagh a inigh izɨtɨ kɨ an ganika.” ");
INSERT INTO msy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ezɨ me dagɨam a bagha a inigha izezɨ a men azara, “Tinan nedazim ko ziamra kara?” Ezɨ me kamaghɨn Iesus ikara, “Sisarɨn nedazim.” ");
INSERT INTO msy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ezɨ Iesus kamaghɨn me mɨgei, “Kamaghɨra, ia Sisarɨn biziba Sisar danɨngɨva, Godɨn biziba isɨ, God danɨng.” Ezɨ me an ikarvazimɨn dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ezɨ Sadyusiba, me kamaghɨn nɨghnɨsi, gumazim aremegh ua dɨkavighan kogham. Egha me azangsɨzir mam sara Iesus bagha ize. ");
INSERT INTO msy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Me izegha kamaghɨn mɨgei, “Tisa, Moses fomɨra kamaghɨn e bagha osiri, gumazim ovegh uan amuim ategh egh boriba puvatɨghtɨ, an aveghbuam an amuir odiarimɨn ikɨva a bagh boriba iniam. ");
INSERT INTO msy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","21","Ezɨ dughiar mam 7 pla aveghbuaba iti. Avebam amuimɨn ikia boriba puvatɨgha aremezɨma, ua avebamra irim an ikia boriba puvatɨghava uaghan areme. Ezɨ mɨkezim kamaghɨram ami. ");
INSERT INTO msy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ezɨ 7 pla aveghbuar kaba bar me an ikia, boritaba inizir puvatɨgha ariaghɨre. Ezɨ abuan, amizim uaghan areme. ");
INSERT INTO msy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aveghbuar 7 pla an ike. Egh kamaghɨn ua dɨkavamin dughiam, tinarama an pam?” ");
INSERT INTO msy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ezɨ Iesus kamaghɨn me ikara, “Ia Godɨn Akɨnafarimɨn osizirim ko Godɨn gavgavim gɨfozir puvatɨ, kamaghɨn ia paza nɨghnɨgha mɨgei? ");
INSERT INTO msy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ariaghreziba dɨkavamin dughiam paba amuibar ikian kogham, uaghan me amuiba isɨ pabar arɨghan kogham. Me enselbar mɨn Godɨn Nguibamɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Ezɨ ariaghreziba ua dɨkavizir bizim bagha, ia Mosesɨn Akɨnafarimɨn aven temer isizimɨn eghaghanim ia an gani, o puvatɨ? Eghaghanir kamɨn, God kamaghɨn Moses mɨkeme, ‘Kɨ Abraham, ko Aisak ko Jekopɨn God.’ ");
INSERT INTO msy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God gumazibar nivafɨzir ariaghɨribar God puvatɨ, a gumazibar duar angamra itibar God. Ia bar paza nɨghnɨgha mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ezɨ Judan arazibagh fozir gumazir mam izima Sadyusiba Iesus ko uari adozima, a me barasi. An orazima Iesus ikarvazir aghuim me ganɨngizɨma, a Iesusɨn azara, “Godɨn arazir manamra maba bar dagh afiragha, faragha zui?” ");
INSERT INTO msy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ezɨ Iesus a ikara, “Arazir bar ekiamra kara: ‘Israel, ia oragh. Ekiam en God, Ekiam uabɨra. ");
INSERT INTO msy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ia uan Ekiam, ian God, uan navir averiam ko uan duam ko uan nɨghnɨzim ko uan gavgavim sara bar a gifongegh.’ ");
INSERT INTO msy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ezɨ arazir anarɨra irimra kara, ‘Nɨ uabɨ gifongezir moghɨn gumazamiziba bar me gifongegh.’ Ua arazitam kamningɨn mɨn ekevegha aning gafirazir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ezɨ gumazir kam kamaghɨn Iesus ikara, “Nɨ guizbangɨra mɨgɨa ghaze, God uabɨra, tav ua itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E uan navir averiam ko, uan nɨghnɨzim ko uan gavgavimɨn Ekiam gifongegh, egh uabɨ gifongezir moghɨn gumazamiziba bar me gifongegham. E arazir kamningɨn gɨn mangam, eghtɨ arazir kamning ofan me bar avimɨn tueba ko ofa damuamin biziba bar dagh afira.” ");
INSERT INTO msy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Iesus orazima a deravɨra mɨkemezɨ, Iesus a mɨgei, “Nɨ God biziba bar dagh ativagh dar ganamin dughiamɨn saghon itir puvatɨ.” Egha datɨrɨghɨn tav ua azangsɨzitam ua Iesus damuan atiatingi. ");
INSERT INTO msy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Egha Iesus Godɨn Dɨpenir mɨriamɨn gumazamizibar sure gamuava, men azara, “Manmagh amizɨ Judan arazibagh fozir gumaziba kamaghɨn mɨgɨa ghaze, Krais, God Uam E Iniasa Mɨsevezir Gumazim, a Devitɨn ovavim? ");
INSERT INTO msy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit uabɨ, Godɨn Duam nɨghnɨzir kam a ganɨngizɨ, a kamaghɨn mɨkeme, ‘Ekiam, nan Ekiam kamaghɨn a mɨgei, “Nan agharir guvim daperagh, egh na ko atrivimɨn ikiam. Egh mangɨ dughiar kɨ nɨn apanibar amightɨ me nɨn apengan ikiam.” ’ ");
INSERT INTO msy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Egha Devit uabɨ ‘Ekiam’ gumazir kam gatɨ. Ezɨ manmaghɨn amizɨ a ua Devitɨn Otarim?” Ezɨ gumazamizir avɨriba an mɨgɨrɨgɨaba baregha bar akonge. ");
INSERT INTO msy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ezɨ Iesus gumazamizibar sure gamua kamaghɨn mɨgei, “Ia Judan arazibagh fozir gumaziba bagh ganigh. Me korotiar ruaribar aghuigh darutɨ gumazamiziba me biziba amaga dagh ivezi naghɨn ziar ekiaba me danɨngasa, me bar ifonge. ");
INSERT INTO msy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Egh God ko mɨgeir dɨpenibar dabirabir aghuariba iniva, egh isar ekiabar dughiaba me danganir ziaba itiba iniasa bar ifonge. ");
INSERT INTO msy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Me amuir odiaribagh ifarava men dɨpeniba okɨa, ghaze e dera. Egha gumaziba men ziaba fasa, egha me God ko mɨgɨa mɨgɨrɨgɨar ruaribagh ami. Kamaghɨn amir gumaziba, men ivezir kuram gumazir arazir kurabagh amibar ivezim bar a gafiragham.” ");
INSERT INTO msy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Egha Iesus ghua dagɨaba arɨzir danganimɨn boroghɨn aperaghav ikiava gumazamizir avɨribar garima me uan dagɨaba isa Godɨn Dɨpenimɨn dagɨaba arɨzir danganimɨn a da arɨsi. Gumazamizir dagɨar avɨriba itiba dagɨar avɨriba arɨsi. ");
INSERT INTO msy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ezɨ biziba puvatɨzir amuir odiarim izava dagɨar muziarir pumuning atɨ, aning dagɨar rubuzir muziarir vamɨra an mɨn ghu. ");
INSERT INTO msy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ezɨ Iesus uan suren gumazibar diagha kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, biziba puvatɨzir amuir odiarir kam dagɨar muziarir pumuning dagɨaba arɨzir danganim gatɨ, ezɨ an dagɨar pumuning gumazir igharaziba arɨghɨzir dagɨabagh afira. ");
INSERT INTO msy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Me uan dagɨar avɨribar amodoghɨn dagɨar muziariba anɨngi. Ezɨma a uan dabirabir onganarazimɨn mɨrara dagɨar muziarir abuananam atɨ.” ");
INSERT INTO msy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Egha Iesus Godɨn Dɨpenim ategha azenan zuima, an suren gumazir mam a mɨgei, “Tisa! Nɨ gan, kar dagɨar bar ekiaba, me dar Godɨn Dɨpenimɨn ingarizɨma, an ganganim bar dera! Godɨn Dɨpenim koma dɨpenir dozir an mɨriamɨn itiba, da bar dɨpenir diriba!” ");
INSERT INTO msy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ezɨ Iesus kamaghɨn a ikara, “Nɨ dɨpenir dafar kabanaghɨn gari? Da bar ikuvigham. Egh dagɨar kaba, gumaziba bar da pueghtɨ da bar moghɨra dagh iregham. Eghtɨ tam tam gisɨn ikeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Egha Iesus Olivɨn mɨghsɨam gisɨn, Godɨn Dɨpenimɨn guam a mɨsuegha aperaghav itima, Pita, Jems, Jon ko Andru me uarira ikiava an azara, ");
INSERT INTO msy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“E mɨkemegh, dɨpeniba ikuvighamin bizim, a manadɨzoghɨn otivam? Eghtɨ arazir manam faragh otoghtɨma, e fogh suam bizir kaba otivamin dughiam roghɨra ize?” ");
INSERT INTO msy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ezɨ Iesus kamaghɨn me mɨgei, “Ia uari bagh deraghvɨra gan, gumazitam izɨ ia gifaran markɨ. ");
INSERT INTO msy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gumazir avɨriba nan ziamɨn izɨ, suam, ‘Kɨ Krais, God ua e iniasa mɨsevezir gumazim,’ egh gumazamizir avɨribagh ifaram. ");
INSERT INTO msy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Eghtɨ ia roghɨra itir mɨdorozir ekiabar nɨgɨniba baragh, egh saghon itir mɨdorozir ekiabar akaba baragham. Egh ia dɨgavir kuram damuan markɨ. Arazir kaba otivam, eghtɨ nguazir kam gɨvamin dughiam tɨghar izam. ");
INSERT INTO msy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kantrin mamɨn itir darazi dɨkavigh kantrin igharazimɨn itir darazi ko mɨsogham. Eghtɨ atrivir mamɨn adarazi dɨkavigh atrivir igharazimɨn adarazi ko mɨsogham. Danganir mabar dagheba bar puvatɨghtɨma, gumazamiziba mɨtiriamra ikiam. Eghtɨma mɨkɨmkɨziba uaghan otivam. Osɨmtɨzir kaba faragh otivightɨ nguazir kam gɨvamin dughiam tɨghar. Osɨmtɨzir kaba mati, amizim otasa faraghavɨra mɨzazim isi mokɨn. ");
INSERT INTO msy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ia deravɨra uari bagh gan. Gumazitaba ia isɨ nguibabar garir gumazibar anɨngam. Egh me God ko mɨgeir dɨpenibar ia mɨsogham. Egh ia na bangɨn atriviba ko gavmanɨn gumazir ekiabar damazibar tuiva, egh ka amizir biziba ia dar gun me mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eghtɨ Godɨn akar aghuim gumaziba faragh nguibaba bar dav kɨnigh. ");
INSERT INTO msy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eghtɨ gumazitaba dughiar manam ian suiragh ia inigh kotɨn mangɨtɨ, ia faragh mɨkɨmsɨ nɨghnɨghɨva osɨman markɨ. Pura mɨgɨrɨgɨar manam God kotɨn aven nɨ danightɨ, na mɨkɨm. Kar nɨ uabɨ mɨgeir puvatɨ, Godɨn Duam mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Aveghbuaba uarira uari isɨ apanibar anɨngtɨ me me mɨsoghtɨ me arɨmɨghiram. Eghtɨ afeziaba uan boriba uaghan kamaghɨra dar amuam. Boriba uan ameboghfeziabar akaba batoghɨva ovengamin arazibar me damutɨ, me arɨmɨghiram. ");
INSERT INTO msy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Eghtɨ gumazamiziba bar nan ziam bangɨn ian aghuagham. Egh tina tugh gavgavigh mangɨ ana aremeghamin dughiamɨn tughtɨ, God ikɨrɨmɨrir aghuarim gɨn a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ia gantɨ God bar aghuazir bizim an dɨpenimɨn ikiam. Kar a ikian koghamin danganim. A ikɨtɨ, God uan Dɨpenim ategham. (Nɨ tina osizirir kamɨn ganigh, deravɨra nɨghnɨghɨva a gɨfogh.) God bar aghuazir bizir kam, dughiar kamɨn otoghtɨ, Judian Distrighɨn aven itir darasi me zuamɨram arɨ mɨghsɨabar ghuavanangam. ");
INSERT INTO msy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tav dɨpenimɨn avughsir danganimɨn ikeghɨva dɨpenimɨn aven mangɨ uan bizitam inian markɨ. ");
INSERT INTO msy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tav azenir ekiamɨn ikeghɨva uamategh dɨpenimɨn mangɨ uan azenan azuir korotiam inian markɨ. ");
INSERT INTO msy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Naviba adair amiziba ko boriba oteba apir amebaba, mevzika; dughiar izamin kaba bar men ikuvigham! ");
INSERT INTO msy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","Dughiar izamin kaba, da osɨmtɨzir ekiabar dughiaba. God nguazim ko overiamɨn ingarizir dughiamɨn iza datɨrɨkɨn, egh ua kamaghɨn dughiatam otoghan kogham. Ezɨ kamaghɨn ia God ko mɨkɨm, eghtɨ osɨmtɨzir ekiar kaba amozimɨn dughiamɨn otivan markɨ. ");
INSERT INTO msy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Egha Ekiam uan mɨsevezir gumazamizibagh nɨghnɨgha, dughiar kurar kamɨn dughiar maba aghorezɨ da mong otefe. A ti dar aghorezir puvatɨzɨ gumazamiziba bar ariaghreghai. ");
INSERT INTO msy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Dughiar izamim tav ia mɨkɨm suam, ‘Ia gan, Kraisra kara! A God Ua E Iniasa Mɨsevezir Gumazimra,’ o, ‘Ia gan, Kraisra muna!’ an akam baraghan markɨ. ");
INSERT INTO msy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Gumazitaba izɨva ia gifar suam, ‘Kɨrara, God Gumazamiziba Ua Me Iniasa Mɨsevezir Gumazim,’ o ‘kɨ Godɨn akam inigha izir gumazir mam,’ egh me mirakelɨn bar ekiaba koma dɨgavir kuram gamir arazibar amutɨ da otivam. Me kamaghɨn ifonge, me gumazamizibagh ifaraghtɨ, me onganigham. Egh me gavgavim ikɨ, uaghan God ua bagha mɨsevezir gumazamiziba, me uaghan me gifarasa. Kamaghɨn me mirakelɨn kabar amuam. Egh dughiataba me me gifarsɨ damuva avegham. ");
INSERT INTO msy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kɨ gɨn otivamin biziba bar dar gun ia mɨkeme. Kamaghɨn ia deravɨra uari bagh gan.” ");
INSERT INTO msy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Osɨmtɨzir ekiar kabar dughiam gɨvaghtɨ, gɨn izamin dughiamɨn bizir kaba otivam. ‘Aruem mɨtategham, eghtɨ iakinim isiraghan kogham; ");
INSERT INTO msy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","eghtɨ mɨkoveziba overiamɨn asighɨram, eghtɨ overiamɨn itir bizir gavgaviba sɨvaghsɨvagh, uan danganiba ataghragham.’ ");
INSERT INTO msy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dughiar kamɨn gumaziba gantɨ Gumazibar Otarim gavgavir ekiam ko angazangarir ekiam sara ghuariamɨn tongɨn izam. ");
INSERT INTO msy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Egh a uan enselba amadaghtɨ me mangɨ nguazim ko overiamɨn danganiba bar ko nguazimɨn oteviba bar dar mangɨva God mɨsevezir gumazamiziba men aku a bagh izam.” ");
INSERT INTO msy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Temer fighɨn aguaba ua dɨz murtɨ, ia fogh suam, amozimɨn dughiam roghɨra ize. Ia temer fighɨn gan nɨghnɨzim iniam. ");
INSERT INTO msy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kamaghɨra ia bizir kabar gantɨ da otivtɨ, ia fogh suam, Gumazibar Otarim a ua izamin dughiam roghɨra ize. A tiar akamɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kɨ guizbangɨra ia mɨgei dughiar kamɨn itir gumazamizir kaba ikɨvɨra ikɨtɨ bizir kaba bar otivam. ");
INSERT INTO msy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Overiam ko nguazim gɨvagham, eghtɨ nan mɨgɨrɨgɨaba gɨvaghan kogham.” ");
INSERT INTO msy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Tav fozir puvatɨ, dughiar manamra kɨ ia mɨgeir bizir kaba otivam. Godɨn Nguibamɨn itir enselba ko Godɨn Otarim uaghan fozir puvatɨ. Afeziar Ekiam uabɨra fo. ");
INSERT INTO msy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Ia dughiar kamɨn izamin dughiam gɨfozir puvatɨ. Ia deravɨra uari bagh ganɨva mɨzuam. ");
INSERT INTO msy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Dughiar kam mati gumazim igharagha zui. A uan dɨpenim ategha ghua uan dɨpenim isa uan ingangarir gumazibar dafarim garighava dɨpenimɨn ingangariba me rome. A tiar akamɨn itir gumazimɨn mɨgɨa ghaze, nɨ deravɨra gan. ");
INSERT INTO msy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Dɨpenimɨn ghuavim izamin dughiam ia a gɨfozir puvatɨ, a bogarangra izam, o dɨmagarir arɨzimɨn izam, o tuariba akɨtɨ a izam, o amɨnim tiraghtɨ a izam, o? Kamaghɨn ia deravɨra gan. ");
INSERT INTO msy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Puvatɨghtɨma, a zuamɨram otogh ian gantɨ, ia dakuvɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Kɨ ia mɨgeir bizir kaba, kɨ gumazamiziba bar me mɨgei, ‘Ia deravɨra gan!’” ");
INSERT INTO msy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Dughiar kam, God Israelbagh Itazir Dughiam, koma Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam, dughiar pumuningra ikiavɨra itima, ofa gamir gumazir ekiaba, koma Judan arazibagh fozir gumaziba, arazir mogometamɨn Iesusɨn suiragh amɨsueghtɨ an aremeghasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Me kamaghɨn uariv gei, “E isamɨn dughiamɨn an suighan kogham. E damutɨ isamɨn itir gumazamiziba mɨdorozir ekiatam e damigham.” ");
INSERT INTO msy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Egha Iesus Betanin nguibamɨn ikiava lepa itir gumazim Saimonɨn dɨpenimɨn aven dagher dakozimɨn apava aperaghav iti. An apava aperaghav itima, amizir mam mughuriar aghuim zuir borer mam. An alabastan ingarizir mɨsevimɨn iti. An ziam nat, an ivezim bar pɨn iti. Amizir kam borer kam inigha Iesus bagha izegha borev sevim abigha borem Iesusɨn dapanim ginge. ");
INSERT INTO msy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ezɨ uaghan itir darasi me naviba isiava kamaghɨn uariv gɨavɨra iti, “Tizim bagha kav borer mughuriar aghuim zuim pazava a gami? ");
INSERT INTO msy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","An anemadagha dagɨar avɨriba inighai. An ivezim azenir vamɨran ivezim gafira. Eghtɨ an dagɨaba onganarazibagh amibar akuragham.” Egha me puv an atari, egha an anogorosi. ");
INSERT INTO msy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ezɨ Iesus kamaghɨn mɨgei, “Anetakigh. Ia tizim bagha osɨmtɨzim a garɨsi? Anetakigh! An arazir aghuim na gami. ");
INSERT INTO msy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Onganarazibagh amiba zurara ia ko ikiam. Ia dughiar manam men akurvaghsɨ, men akurvagh. Kɨ zurara ia ko ikian kogham. ");
INSERT INTO msy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kɨ aremeghtɨ a damuamin bizim, a na gami. A faragh mughuriar aghuim zuir borem nan mɨkarzim daghuightɨ me gɨn na mozim darɨgham. ");
INSERT INTO msy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kɨ guizbangɨra ia mɨgei, me nguazir kamɨn danganir manamɨn Godɨn akar aghuim akunɨva egh amizir kam amizir arazim uaghan a mɨkɨmɨva egh a gɨnɨghnɨghɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ezɨ Judas Iskariot 12 plan aposelɨn mam, a Iesus isɨva ofa gamir gumazir ekiabar dafarim darɨghasa me bagha ghu. ");
INSERT INTO msy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ezɨ me an akar kam baregha bar akonge, egha dagɨaba a danɨngasa akar gavgavim arkɨri. Ezɨ an an suiragh me danɨngasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yis Puvatɨzir Bretɨn Isam Damuamin Dughiabar faragha zuir dughiam, Judan gumaziba me arazir kam iti. Me faragh God Israelbagh Itazir Dughiam gɨnɨghnɨghɨva sipsipɨn igiam inigh God danighɨva an ofa damuam. Ezɨ Iesusɨn suren gumaziba an azara, “Nɨ danganir manamɨn, e mangɨ, nɨ God Israelbagh Itazir Dughiamɨn isam ramɨsɨ, e bizibar akɨram?” ");
INSERT INTO msy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ezɨ a uan suren gumazir pumuning amaga kamaghɨn aning mɨgei, “Gua nguibar ekiamɨn mangɨtɨ gumazitam dɨpar mɨnem ater izɨ gua batoghtɨ, gua an gɨn mangɨ. ");
INSERT INTO msy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dɨpenir an aven zuim gua an mangɨva an ghuavim mɨkɨm suam, ‘Tisa kamaghɨn azangsɨsi, “Nan danganir kɨ uan suren gumaziba ko Israelbagh Itazir Dughiamɨn isamar amamim mana?” ’ ");
INSERT INTO msy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eghtɨ a dɨpenimɨn aven pɨn itir danganir ekiam ian akagham. Danganir kam biziba bar ikia e baghavɨra mɨzuai. Eghtɨ ia danganir kam e uari bagh biziba bar dar akɨr.” ");
INSERT INTO msy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ezɨ an suren gumazimning me ategha nguibar ekiamɨn aven ghua garima biziba a mɨgɨrɨgɨamɨn mɨrara ghuzɨ, ezɨ aning maghɨra God Israelbagh Itazir Dughiam bagha dagheba ko bizibar kɨri. ");
INSERT INTO msy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ezɨ guaratɨzimɨn Iesus uan 12 plan suren gumaziba ko otifi. ");
INSERT INTO msy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Egha me dagher dakozimɨn apiaghav ikiava apava, Iesus kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, ian tav na isɨva gumazir nan apanim gamibar agharim darɨgham, a uaghan na ko ikiava api.” ");
INSERT INTO msy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Me an akam baregha, naviba bar oseme. Egha me bar vaghvagha an azangsɨgha kamaghɨn mɨgei, “Kɨrara markiama?” ");
INSERT INTO msy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ezɨ a me ikaragha kamaghɨn me mɨgei, “Ia 12 pla ian tavra. Gumazir na ko itarir vamɨra bret azuim. ");
INSERT INTO msy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ezɨ Gumazibar Otarim, Godɨn Akinafarim mɨkemezir moghɨn, an aremegham. Eghtɨ gumazir Gumazibar Otarim isava apanibar agharim gatɨzim, gumaka! A bar ikuvigham! Amebam a batezir puvatɨzɨ, deraghai!” ");
INSERT INTO msy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ezɨ Iesus uan suren gumaziba ko apa ikiava, a bretɨn mam inigha God mɨnabagha egha anebigha, a isa uan suren gumazibagh anɨngi. Egha kamaghɨn me mɨgei, “Kar nan nivafɨzim. Ia a inigh aneremɨ.” ");
INSERT INTO msy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Egha a wain apir itarim inigha egha God mɨnabagha me ganɨngizɨ, ezɨ me vaghvagha uarir guri. ");
INSERT INTO msy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Me wain apima a kamaghɨn me mɨgei, “Kar nan ghuzim, an Akar Dɨkɨrɨzir Gavgavim, a gavgavim a ganɨdi. A gumazamizir avɨriba bagha ire. ");
INSERT INTO msy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kɨ guizbangɨra ia mɨgei, Kɨ uam wainɨn ovɨzimɨn dɨpatam rameghan kogham, kamaghɨra ikɨ mangɨ Dughiar God Bizibagh Ativamimɨn otogham. Eghtɨ dughiar kam, kɨ wainɨn dɨpar igiam ramam.” ");
INSERT INTO msy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Egha me Godɨn ziam fer ighiar mam gamigha dɨkavigha Olivɨn Mɨghsɨamɨn ghue. ");
INSERT INTO msy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Egha Iesus kamaghɨn uan suren gumazibav gei, “Godɨn Akɨnafarimɨn osizirim kamaghɨn iti, ‘Kɨ sipsipbar garir gumazim a mɨsueghtɨ sipsipba tintinimɨn aregham.’ Kamaghɨn ia bar nɨghnɨzir gavgavim nan itim gɨvaghtɨma, ia na ategh aregham. ");
INSERT INTO msy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kɨ ia mɨgei, kɨ aremegh ua dikavigh ian faragh Galilin Distrighɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ezɨ Pita kamaghɨn mɨgei, “Me bar nɨ ateghtɨ kɨrara puvatɨgham.” ");
INSERT INTO msy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ guizbangɨra nɨ mɨgei, datɨrɨghɨn dɨmagarir kamɨn nɨ uabɨ dughiar pumuning ko mɨkezim nɨ suam, ‘Kɨ a gɨfozir puvatɨ,’ eghtɨ tuarim gɨn akazir pumuning damuam.” ");
INSERT INTO msy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ezɨ Pita akar gavgavimra amua ghaze, “Kɨ nɨ ko ovengsɨva ovengam, kɨ bar kamaghɨn mɨkemeghan kogham. Bar puvatɨgham!” Ezɨ suren gumaziba bar kamaghɨram a mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Egha Iesus uan suren gumaziba ko temer olivbar azenim, an ziam Getsemanin ghuegha, Iesus kamaghɨn me mɨgei, “Ia kagh dapiaghɨv kɨtɨ kɨ God ko mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Egha a Pita, Jems ko Jon me inigha ghu. Ezɨ atiatim puvɨram an anadima, a bar osemegha, ");
INSERT INTO msy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","kamaghɨn me mɨgei, “Nan navir averiam, osɨmtɨzim a iteragha ghuaghiri. Ezɨ kɨ aremeghasava ami. Ia kagh ikɨ, deravɨra gan.” ");
INSERT INTO msy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Egha a mong isɨvagha ghugha, egha uan guam moghɨn nguazim girɨgha kamaghɨn God ko mɨgɨa ghaze, tuavir igharazitam ikɨtɨma God dughiar kurar kam na dam a inigh. ");
INSERT INTO msy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A kamaghɨn God ko mɨgei, “O Ame, nan afeziam, bizitam bar nɨn osemezir puvatɨ. Kamaghɨn osɨmtɨzir kam, nɨ na dam a inigh. Kɨ ifongezir moghɨn puvatɨ, nɨ ifongezir moghɨra, nɨ damu.” ");
INSERT INTO msy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ezɨma a uamategha uan suren gumazir pumuning ko mɨkezimɨn bighan ghugha garima me akui. Ezɨ a kamaghɨn Pita mɨgei, “Saimon, nɨ akui? Nɨ tong na ko ikɨ ganɨva dughiar otevimɨn ikeghan kogham? ");
INSERT INTO msy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ia na bagh deravɨra gan, egh God ko mɨkɨm, eghtɨ osɨmtɨzitam ia damutɨ, ia ireghan kogham. Kɨ fo, ian navir averiaba ifonge, ezɨ nivafɨziba gavgaviba dar puvatɨ. Kamaghɨn pariam ian azi.” ");
INSERT INTO msy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Egha a uamategha ghugha faragha God ko mɨkemezɨ moghɨn ua a ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Egha a uamategha suren gumaziba bagha iza gari, me akuavɨra iti. Pariam puv men azi. Ezɨ a me gaghurazɨ, me a mɨkɨmamin akabagh asa. ");
INSERT INTO msy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ezɨ a dughiar mɨkezimɨn ghugha God ko mɨkemegha uamategha iza me mɨgei, “Ia avughsava akuavɨra iti? Arazir kam atakigh! Dughiam oto. Ia gan, Gumazibar Otarim me a isɨva gumazir arazir kurabagh amibar dafarim darɨghasa. ");
INSERT INTO msy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ia dɨkavigh! E mangam! Ia gan. Gumazir na isɨva apanibar anɨngamra muna izi!” ");
INSERT INTO msy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Egha Iesus Pita, Jems ko Jon mɨgɨavɨra itima, Judas, an suren gumazir 12 plan mam oto. Maburan avɨrim a ko mɨdorozir sababa ko asianiba inigha Iesus bagha izi. Ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumaziba ko Judan gumazir dapaniba, me me amangizɨ, me izi. ");
INSERT INTO msy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gumazir Iesus isɨ men dafaribar arɨghasava amim faragha ghaze, “Kɨ arazir kam ian akagham. Gumazir kɨ toramim, kar Iesusra. Ia an suiragh, egh deraghvɨra an ganɨva, egh a inigh mangɨ.” ");
INSERT INTO msy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ezɨ Judas Iesus bagha ghuavɨra ikia kamaghɨn mɨgei, “Tisa!” Eghava an tore. ");
INSERT INTO msy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ezɨ gumaziba izava Iesusɨn agharibagh iregha, pamtem an suiki. ");
INSERT INTO msy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ezɨma Iesusɨn boroghɨn itir gumazir mam uan mɨdorozir sabam asigha, ofa gamir gumazibar dapanimɨn ingangarir gumazimɨn kuarim atu, ezɨ an kuarim dutuaghirɨ. ");
INSERT INTO msy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ezɨ Iesus kamaghɨn mɨgei, “Kɨ okɨmakɨar gumazim puvatɨ. Ia tizim bagha nan suighasa mɨdorozir sababa koma asianiba atera izi? ");
INSERT INTO msy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kɨ zurara ia ko ikia, Godɨn Dɨpenimɨn mɨriamɨn aven sure gami. Ezɨ ia nan suighan aghua. Ezɨ Godɨn Akɨnafarimɨn osizirim mɨkemezir moghɨra ia kamaghɨn na gami.” ");
INSERT INTO msy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ezɨma Iesusɨn suren gumaziba bar aneteghava are. ");
INSERT INTO msy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ezɨ gumazir igiar mam bizitam aruzir puvatɨ, egha inir ghurghurir azenan itimra ikegha Iesusɨn gɨn zui. Ezɨ Iesusɨn apaniba an suirazɨma, ");
INSERT INTO msy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a uan azenan itir inir ghurghurim ategha bibiamrama arav ghu. ");
INSERT INTO msy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ezɨ Iesusɨn apaniba a inigha ofa gamir gumazibar dapanim bagha ghu. Ezɨ ofa gamir gumazir ekiaba ko Judan gumazir dapaniba, ko Judan arazibagh fozir gumaziba, me bar iza uari akufa. ");
INSERT INTO msy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ezɨ Pita mong tɨzim a gatɨgha Iesusɨn gɨn ghua bar ghua ofa gamir gumazibar dapanimɨn dɨpenimɨn dɨvazimɨn aven ghu. Egha kagh ganganir gumaziba koma aperaghav ikia avimɨn fɨi. ");
INSERT INTO msy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ofa gamir gumazir ekiaba koma Judan kotɨn aven itir gumaziba bar Iesusɨn mɨsueghtɨ an aremeghasa akar men akurvaziba buri, egha tam batozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gumazir avɨriba ifavarir mɨgɨrɨgɨabar Iesus gami, ezɨ men mɨgɨrɨgɨaba voroghɨra zuir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ezɨ marazi dɨkavigha ifavarir akar kamɨn a mɨgei, ");
INSERT INTO msy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“E orazima, a ghaze, ‘Kɨ Godɨn Dɨpenir gumaziba ingarizim anepɨrigh, egh dughiar pumuning ko mɨkezimɨn igharazitamɨn ingarigham. Godɨn Dɨpenir kɨ ingaramim gumaziba ingarizir puvatɨzim.’” ");
INSERT INTO msy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ezɨ mɨgɨrɨgɨar kaba uaghan guizbangɨra voroghɨra zuir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ezɨma ofa gamir gumazibar dapanim dɨkavigha men tongɨn tugha egha Iesusɨn azara, “Nɨ akatam ikarvaghan aghua? Me nɨ gasir akar kam, a guizbangɨra, o?” ");
INSERT INTO msy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ezɨ Iesus nɨmɨra ikia men mɨgɨrɨgɨatam ikarazir puvatɨ. Ezɨ ofa gamir gumazibar dapanim uam an azara, “Nɨ Krais, God Uam E Iniasa Mɨsevezir Gumazim? Nɨ gumazamiziba ziam fer Godɨn Otarim?” ");
INSERT INTO msy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ an Otarimra. Eghtɨ nɨ gantɨ, Gumazibar Otarim gavgavim itir Godɨn agharir guvim daperagh overiamɨn ghuariaba sara izam.” ");
INSERT INTO msy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ezɨ ofa gamir gumazibar dapanim uan korotiaba abighava azara, “E tizim bagh ua akar akurvaziba buriam? Markiam! ");
INSERT INTO msy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ia uari a barasi, a mɨgɨrɨgɨar kurabar Godɨn ziam gasɨghasɨsi. Ezɨ ia manmaghɨn nɨghnɨsi?” Ezɨ me bar akam a gasa, egha ghaze an aremegham. ");
INSERT INTO msy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Egha marazi a gipari. Egha me an damaziba avara, egha me uan agharibar a mɨsogha kamaghɨn mɨgei, “Nɨ mɨkɨm. Tinara nɨ mɨsosi?” Ezɨ ganganir gumaziba a inighava a mɨsoghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Dughiar kamra Pita dɨpenimɨn dɨvazimɨn aven vangɨnan itima, ofa gamir gumazibar dapanimɨn ingangarir guivir mam izi. ");
INSERT INTO msy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Egha Pitan garima an avimɨn fɨima, a dɨkɨravɨram an gari. Egha kamaghɨn mɨgei, “Nɨ uaghan Nasaretɨn gumazir kam, Iesus ko ike.” ");
INSERT INTO msy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ezɨ a uabɨn ghuaragha ghaze, “Kɨ nɨ mɨgeir bizir mam gɨfozir puvatɨ.” Egha dɨvazimɨn tiar akar ekiamɨn otivasa azenan ghu. Ezɨ tuarim ati. ");
INSERT INTO msy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ezɨ ingangarir guivir kam kagh an apigha tuivighav itir gumazamiziba ua me mɨgei, “Muna men mav.” ");
INSERT INTO msy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ezɨ a ua uabɨn ghuara. Ezɨ mong gɨn, an boroghɨn tuivighav itir darasi Pita mɨgei, “Nɨ Galilin gumazim, kamaghɨn guizbangɨra nɨ men mavɨra.” ");
INSERT INTO msy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ezɨ a pamtem mɨgɨa ghaze, Kɨ guizbangɨra mɨgei, kɨ ifaraghtɨma God na gasɨghasigham. Egha kamaghɨn me mɨgei, “Kɨ gumazir ia mɨgeir kam gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","A kamaghɨn mɨgɨavɨra itima tuarim uam ake. Ezɨ Pita Iesus a mɨkemezir mɨgɨrɨgɨam ginɨrɨ, “Nɨ faragh dughiar pumuning ko mɨkezimɨn suam, kɨ Iesus gɨfozir puvatɨ, eghtɨ tuarim gɨn dughiar pumuningɨn akegham.” Egha Pita nɨghnɨghava avegha bar puvɨrama azi. ");
INSERT INTO msy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Egha bar mɨzaraghara, ofa gamir gumazir ekiaba, ko Judan gumazir dapaniba, ko Judan arazibagh fozir gumaziba, ko Judan kotɨn aven itir gumazir igharaziba sara, me nɨghnɨzir mam bato. Egha me Iesusɨn dafariba ikegha an akua ghua Pailat ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ezɨ Pailat an azara, “Nɨ Judabar Atrivim, o?” Ezɨ Iesus a ikaragha kamaghɨn mɨgei, “Are, nɨ deraghavɨra mɨgei.” ");
INSERT INTO msy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ezɨ ofa gamir gumazir ekiaba bizir avɨribar a mɨgɨava, a gasi. ");
INSERT INTO msy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ezɨ Pailat uam an azara, “Nɨ mɨgɨrɨgɨar kaba ikarvagham, o puvatɨ? Nɨ orasi, me bizir avɨriba nɨ mɨgɨa nɨ gasi.” ");
INSERT INTO msy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ezɨ Iesus bar mɨgeir puvatɨzɨma, Pailat dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ezɨ Pailat amir arazim kamakɨn, azeniba bar isar ekiar kamɨn dughiam, me Pailatɨn mɨkɨmtɨma a kalabusɨn itir gumazir me ifongezim, aneteghtɨ, a mangam. ");
INSERT INTO msy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gumazir mam, an ziam Barabas, a gumazir gavman ko mɨsoziba me ko kalabusɨn iti. Me bizir kam bagha kalabusɨn iti. Me gavman ko uariv sogha gumazir mabav soghezɨ me ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ezɨ gumazamiziba Pailat iti naghɨn ghuavanabogha kalabusɨn itir gumazir me ifongezim ateghasa Pailatɨn azangsɨsi. Kar arazir Pailat zurara amim. ");
INSERT INTO msy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ezɨ Pailat men azara, “Kɨ Judabar Atrivim ategh ia bagh anemangasa, ia ifonge?” ");
INSERT INTO msy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat fo, ofa gamir gumazir ekiaba Iesus amir biziba bagha naviba ikuvava, a isa Pailatɨn dafarim gatɨ. ");
INSERT INTO msy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ezɨ ofa gamir gumazir ekiaba mɨgɨrɨgɨar navibagh iniviba gumazamizibagh anɨdi. Eghtɨ me Pailatɨn mɨkemeghtɨ a Iesusɨn anogoregh, egh Barabas ateghtɨ a me bagh izam. ");
INSERT INTO msy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ezɨ Pailat azara, “Gumazir ia Judabar atrivim arɨzim, kɨ manmaghɨn a damuam?” ");
INSERT INTO msy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ezɨ gumazamiziba pamtem dia kamaghɨn mɨgei, “A isɨ ter ighuvimɨn aneguragh!” ");
INSERT INTO msy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ezɨ Pailat men azara, “Manmagh su? An arazir kurar manam gami?” Ezɨ me bar pamtem dɨa mɨgei, “Ter ighuvimɨn aneguragh!” ");
INSERT INTO msy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","A me damutɨ men naviba deraghasa, Pailat Barabas ataki. Egha mɨdorozir gumazibav kemezɨ me benibar Iesus fozoroghezɨ Pailat ter ighuvimɨn aneguasa me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Egha mɨdorozir gumaziba Iesus inigha gavmanɨn dɨpenir ekiamɨn mɨriamɨn aven ghuaghira mɨdorozir gumaziba bar men diazɨ me iza uari akufa. ");
INSERT INTO msy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Egha me korotiar aghevir ruarim a garugha egha dɨkonir amianim arkɨrigha an dapanim garu. ");
INSERT INTO msy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Egha me maghɨra an diava a mɨgei, “Judabar Atrivim, nɨrara atrivir ekiam!” ");
INSERT INTO msy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Egha me aghorim an dapanim mɨsoghava, egha uaghan a giparavɨra iti. Egha me ifara uan tevir akuribagh isɨn ira mati me guizbangɨra an ziam fe moghɨn ami. ");
INSERT INTO msy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Me arazir kabar a gamua a dɨpovegha gɨvagha, a da korotiar me a agaghuiziba suegha, ananaba agaghui. Egha me a isa ter ighuvimɨn a gafughasa an akua zui. ");
INSERT INTO msy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sairinin gumazir mam Saimon, a Aleksander ko Rufusɨn afeziam, a nguibar igharazimɨn ikegha Jerusalemɨn aven zui. Ezɨ mɨdorozir gumaziba Iesus guamin ter ighuvim a terasa an suirazɨ, an aneteri. ");
INSERT INTO msy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Egha me ghua danganir mamɨn ziam Golgata, me an otifi. (Danganir kamɨn ziamɨn mɨngarim kamakɨn, Dapanir Agharir Danganim.) ");
INSERT INTO msy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Egha me wain ko mɨzaziba agevir dɨpam veregha Iesus ganɨdima an an aghua. ");
INSERT INTO msy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ezɨ aruem anabozɨ, me a isa ter ighuvimɨn aneguragha a gafu. Ezɨ mɨdorozir gumaziba an korotiaba tuiragh uari danɨngasa satu gikararai. Tina faragh otogh, korotiar manam iniam. ");
INSERT INTO msy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Egha me an gun mɨgeir akar kam osiri, “A Judabar atrivim.” Me ghaze, a bizir kam bagha kotɨn tughava areme. ");
INSERT INTO msy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Me gumazir okɨava mɨdorozibagh amizir pumuning, Iesusɨn boroghɨn uaghan aning agura. Me mav isa Iesusɨn agharir guvimɨn itir ter ighuvim gafu, egha mav isa agharir ikɨriamɨn itir ter ighuvim gafu. ");
INSERT INTO msy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ezɨ iza zui darasi me dɨbovibar a mɨgɨava uan dapaniba roava ghaze, “Ore! Nɨ, gumazir Godɨn Dɨpenim akarigh aruer pumuning ko mɨkezimɨn uam an ingarasa mɨkemezim, ");
INSERT INTO msy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","datɨrɨghɨn nɨ uabɨ uabɨn akuragh, ter ighuvim ategh izighirɨ!” ");
INSERT INTO msy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumaziba uaghan kamaghɨram a dɨpova uariv gei. Me kamaghɨn mɨgɨa ghaze, “A igharaz darazir akurvagha uabɨra uabɨn akurvaghan asa! ");
INSERT INTO msy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Gumazir kam, a ghaze, kɨ God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim ko Israelbar Atrivim, a ter ighuvim ategh izighirɨtɨma, e an ganigh nɨghnɨzir gavgavim an ikiam.” Gumazir okɨmakɨar an boroghɨn guraghav itimning uaghan mɨgɨrɨgɨar kurar avɨriba puvɨram a mɨgɨavɨra iti. ");
INSERT INTO msy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Aruem iza pazaghar torimɨn itima mɨtatem nguazimɨn itir nguibaba bar da avaragha, ghua dughiam 3 kloghɨn guaratɨzimɨn tu. ");
INSERT INTO msy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Egha dughiam 3 kloghɨn itima Iesus tiarir ekiamɨn pamtem kamaghɨn dei, “Eloi, Eloi, lama sabaktani?” Akar kamɨn mɨngarim kamakɨn, Nan God, nan God nɨ tizim bagha na ataki? ");
INSERT INTO msy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ezɨ roghɨra tuivighav itir darasi oregha ghaze, “Ia oragh, a Elaijan dei.” ");
INSERT INTO msy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ezɨ gumazir mam ivegha ghua dɨpamɨn suizir bizim isa wainɨn afangtɨzim garugha a isa aghorir mam gatɨgha, Iesus damasa an an amadi. Egha a ghaze, “Ia tegh, e ganika, Elaija ti izɨva an akuragham, o puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ezɨ Iesus pamtem diagha duam sue. ");
INSERT INTO msy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ezɨ Godɨn Dɨpenimɨn itir inir ekiar guraghav itim pɨn ikegha tongɨra bigha ghuaghira vɨn otogha akuar pumuning irɨ. ");
INSERT INTO msy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ezɨ mɨdorozir gumazir 100 plan garir gumazir dapanir mam, Iesusɨn boroghɨn tughav ikia orazi a pamtem diagha manmaghɨn aremezir arazimɨn ganigha ghaze, “Bar guizbangɨra, gumazir kam Godɨn Otarimra!” ");
INSERT INTO msy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ezɨ amizir maba mong saghon tuivighav ikia gari. Men tongɨn Makdalan nguibamɨn amizim Maria, ko Jemsɨn igiam ko Josepɨn amebam Maria, ko Salome. ");
INSERT INTO msy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amizir kaba Galilin ikegha Iesusɨn akurvagha egha an gɨn arui. Amizir avɨrir maba sara Iesus ko Jerusalemɨn anabogha uaghan iti. ");
INSERT INTO msy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Datɨrɨghɨn Sabat bagha bizibar kɨrir dughiam. (Eghtɨ guaratɨzim Sabat otogham.) Ezɨ kamaghɨn aruem gevima, Arimatean gumazim Josep, Judabar kotɨn aven itir gumazir aghuir me bar fozim. A uabɨ uaghan God Bizibagh Ativamin Dughiam bagha mɨzuai. An atiatir puvatɨgha Iesusɨn kuam iniasa ghua Pailatɨn azai. ");
INSERT INTO msy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ezɨ Pailat orazi, Iesus aremegha gɨvazɨ, a dɨgavir kuram gami. Egha a mɨdorozir gumazir 100 plan garir gumazim bagha akam amadazɨma a izima an an azara, “Iesus guizbangɨra aremezɨ, o?” ");
INSERT INTO msy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ezɨ an an mɨgɨrɨgɨam baregha a fo, Iesus guizbangɨram areme. Ezɨ a Iesusɨn kuam iniasa Josepɨn amamangatɨ. ");
INSERT INTO msy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","47","Ezɨ Josep inir ghurghurir aghuir mam givezegha izava Iesusɨn kuam adangi. Egha a righa ghua dagɨar torir me dutuzimɨn ghugha anerɨzima Makdalan amizim Maria ko Josepɨn amebam Maria, aning garima, Josep Iesusɨn kuam isa dagɨar torimɨn aven anetɨgha, dagɨar ekiar mam poghpuegha izava an akam dukua. ");
INSERT INTO msy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Egha Sabatɨn dughiam gɨvazɨma, Makdalan amizim Maria, Jemsɨn amebam Maria, ko Salome mangɨ Iesusɨn kuam daghuasa borer mughuriar aghuaribagh ivese. ");
INSERT INTO msy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","7 pla dughiabar faragha zuir dughiamɨn aruem anadima mɨzaraghara me dagɨar torir matmatiamɨn ghua uarira uariv gei, “Tina dagɨar torimɨn akam gasarazir dagɨam puegham?” ");
INSERT INTO msy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Egha me ghua garima dagɨar ekiar kam, me a poghpuegha ghu. ");
INSERT INTO msy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ezɨ me dagɨar torir akamɨn aven ghua garima gumazir igiar mam korotiar ghurghurir ruarim arugha agharir guvimɨn amadaghan aperaghav iti. Ezɨ me an ganigha bar aguaghfa. ");
INSERT INTO msy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ezɨ a kamaghɨn mɨgei, “Ia akongan markɨ. Ia Nasaretɨn gumazim Iesus bagha gari. A ter ighuvimɨn aremegha ua dɨkafi! A kagh itir puvatɨ. Ia kagh a irɨghav ikezir danganimɨn gan. ");
INSERT INTO msy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Egh ia mangɨ, Pita ko an suren gumazir igharazibav kemegh, ‘A ian faragh Galilin mangam. A mɨkemezir moghɨn ia munagh a bativam.’” ");
INSERT INTO msy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ezɨma me dɨgavir kuram gamigha aguava azenan ghuegha puv are. Me atiatingi, kamaghɨn me taraziv kemezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iesus 7 pla dughiabar faragha zuir dughiamɨn mɨzaraghara ua dɨkavigha Makdalan amizim Maria faragha uabɨ isava an aka. Amizir kamnaghra Iesus faragha duar kurar 7 pla an itiba batoke. ");
INSERT INTO msy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ezɨ gumazamizir Iesus ko aruava ikeziba, me a bagha bar osemegha puv azia itima, Maria ghugha Iesusɨn gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ezɨ me orazi, Iesus ua dɨkavigha uabɨ isa Makdalan Marian akazɨ, an an gani. Me kamaghɨn oregha nɨghnɨzir gavgavim amizir kamɨn akabar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Egha dughiar kamnaghra gɨn Iesus gumazir igharazimɨn mɨn otozɨ suren gumazir pumuning nguibar ekiamɨn azenan zuima an aning bato. ");
INSERT INTO msy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ezɨ aning uamategha iza bizir kamɨn gun maraziv kemezɨ, me uaghan nɨghnɨzir gavgavim aningɨn akabar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Egha gɨn 11 plan suren gumaziba apima Iesus uabɨ isa men aka. Egha a, me nɨghnɨzir gavgavim puvatɨzir bizim ko, me navir gavgavim ikia a ua dɨkavizɨ mɨgɨrɨgɨam marazi an ganigha mɨgeima me nɨghnɨzir gavgavim mɨgɨrɨgɨar kamɨn itir puvatɨ, ezɨ bizir kaba bagha Iesus me mɨgɨa men atari. ");
INSERT INTO msy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Egha a kamaghɨn me mɨgei, “Mangɨ nguazir kam bar a daruva nguazir kamɨn itir gumazamiziba bar akar aghuim me mɨkɨm. ");
INSERT INTO msy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Eghtɨ tina nɨghnɨzir gavgavim nan ikɨva, egh rueghtɨ, God an akuraghtɨ, a zurara God ko ikiam. Eghtɨ tina nɨghnɨzir gavgavim nan itir puvatɨ, a Godɨn kotɨn ikɨva ivezir kuram iniam. ");
INSERT INTO msy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Eghtɨ nɨghnɨzir gavgavim nan itiba, mirakelɨn arazir kaba uaghan me bativam: me nan ziam duar kuraba batoghɨva, me nguibabar akar fozir puvatɨzibav kɨmɨva, egh kuruziba uan dafaribar dar suigham. Egh me imezir dɨpar ariaghɨritamar ameghtɨ a tong men navibagh asɨghasighan kogham. Egh me uan dafariba isɨ arɨmariar gumazibar arɨghtɨ men arɨmariaba gɨvam.” ");
INSERT INTO msy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Egha Ekiam Iesus bizir kabar me mɨkemegha gɨvazɨma God a inigha uan nguibamɨn ghuavanabo. Ezɨma a Godɨn agharir guvimɨn amadaghan aperaghav iti. ");
INSERT INTO msy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ezɨma an suren gumaziba nguazir kamɨn danganiba bar dar ghuava akam akuri. Ezɨ Ekiam me ko ingara uan akam gavgavim a ganɨga mirakelɨn araziba sara akakasi, kamaghɨn gumazamiziba fo, akar kam guizbangɨra.");
INSERT INTO msy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Gumazir aruam, Tiofilus, nɨ fo, gumazir avɨriba God en tongɨn amizir bizibar ganigha, dar gun osirasava ami. E gumazir uari uan damaziba ganizibar akam baraki. Egha me faragha Godɨn akamɨn ingangarir gumazibar otivigha, egha an akam akuri. Kamaghɨn amizɨ, kɨ uaghan akar kam osirigh nɨ bagh anemangasa. Egha kɨ deraghavɨra dar mɨngaribagh foghasa ingara ghua dagh foghava, nɨ bagha bar deravɨrama da osiri. Nɨ dar gan fogh suam, bizir nɨ oraghizir kaba da guizɨn biziba. ");
INSERT INTO msy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Dughiar kamɨn Herot Judian atrivimɨn itima, Godɨn ofa gamir gumazir mamɨn ziam Sekaraia, an Abiyan adarazir gumazir mam. Ezɨma an amuim Elisabet, an Aronɨn ovavim. ");
INSERT INTO msy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Aning bar deraghavɨra Godɨn araziba koma an akam baragha dar gɨn zui. Ezɨma God aningɨn garima, aning an damazimɨn bar dera. ");
INSERT INTO msy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet furabagh ati, kamaghɨn amizɨma aning boriba puvatɨghava, dughiar ruarim pura ikia ghua bar ghuri. ");
INSERT INTO msy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ezɨ dughiar mamɨn ofa gamir gumaziba ingarima, Sekaraia uaghan ofa gamir gumazimɨn mɨn Godɨn damazimɨn ingari. ");
INSERT INTO msy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ezɨ me Godɨn Dɨpenimɨn ofa gamir gumazibar arazibar gɨntɨgha, gumazim amɨsɨvasa me dagɨabagh da kuri. Ezɨ God anemɨsefe. Eghtɨ Sekaraia Godɨn Dɨpenimɨn aven mangɨ mɨgharir mughuriar aghuim zuim dapongam. ");
INSERT INTO msy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ezɨma mɨgharir mughuriar aghuim zuim dapongamin dughiam otozɨma, gumazamizir Godɨn ziam feba, Godɨn Dɨpenimɨn mɨriamɨn uari akuvagha God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ezɨma Ekiamɨn Ensel a batogha, mɨgharir mughuriar aghuimɨn ofan danganimɨn agharir guvimɨn amadaghan tughav iti. ");
INSERT INTO msy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ezɨ Sekaraia an apigha dɨgavir kuram gamigha bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ezɨma ensel kamaghɨn a mɨgei, “Sekaraia, nɨ atiatingan markɨ, nɨ God ko mɨkemezir mɨgɨrɨgɨam, God a baraki. Ezɨma nɨn amuim Elisabet nɨ bagh otarim bategham. Eghtɨ nɨ ziar kam, Jon a datɨgh. ");
INSERT INTO msy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Egh nɨ bar akuegh navir amɨrɨzimɨn ikɨ. Eghtɨ a Godɨn damazimɨn ziar ekiam iniam, kamaghɨn gumazamizir avɨriba an otoghamin dughiamɨn bar akuegham. Eghtɨ a wain ko dɨpar onganibar aman kogham. Egh a uan amebamɨn navir averiamɨn aven ikɨvɨra ikɨtɨ, Godɨn Duam bar a gizɨvagham. ");
INSERT INTO msy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Egh a uam Israelɨn gumazamizir avɨriba inigh men Ekiam God bagh mangam. ");
INSERT INTO msy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Egh Elaijan itir Godɨn Duam ko gavgavir kamra Jon Ekiamɨn faragh mangɨva, afeziabar amutɨma me uan boriba ua dagh fueghɨva, akɨriba ragha God gasaraziba ua me damutɨma me ua nɨghnɨzir aghuibar gumazibar amuva, egh gumazibav kɨmtɨma me uari akɨrɨghasɨ Ekiam mɨzuam ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ezɨ Sekaraia enselɨn azara, “Kɨ ghurizɨ, nan amuim uaghan ghurigha gɨfa. Kamaghɨn amizɨ, kɨ manmaghɨn bizir kam guizbangɨra a gɨfogham?” ");
INSERT INTO msy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ezɨ ensel an akam ikara, “Kɨ Gebriel. Kɨ Godɨn damazimɨn tughav iti. God uabɨ na amadazɨma, kɨ akar aghuir kamɨn nɨ mɨkɨmasa ize. ");
INSERT INTO msy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nɨ nan akaba baregha nɨghnɨzir gavgavim dar itir puvatɨ. Ezɨ bizir kam bagh nɨ mɨkɨman kogh nɨmɨra ikiam, mamaghɨra ikɨtɨma bizir kaba otivamin dughiam otogham.” ");
INSERT INTO msy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ensel Sekaraia mɨgeima, gumaziba ko amiziba azenan ikia Sekaraia mɨzua ghuav amɨragha pura nɨghnɨsi, manmaghɨn amizim a dughiar ruarimɨn Godɨn Dɨpenimɨn aven iti? ");
INSERT INTO msy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ezɨ an azenan otoghava, me mɨkɨman asaghasaki. Ezɨ me fo, a ti Godɨn Dɨpenimɨn aven irebamɨn mɨn bizitamɨn gani. Egha an akamɨn me mɨgeir puvatɨgha dafaribara me mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eghava an ingangarir dughiam gɨvazɨma, a uan nguibamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ezɨma dughiar maba ghua gɨvazɨma an amuim Elisabet navim ada 5 plan iakinibar uabɨ modo. ");
INSERT INTO msy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Egha a kamaghɨn mɨgei, “Ekiam na bagha bizir kam gami. A nan apangkuvigha nan aghumsɨzim gumazamizibar damazimɨn anedangi.” ");
INSERT INTO msy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Egha Elisabetɨn navir adasem 6 plan iakinimɨn otozɨma, God ensel Gebriel Nasaretɨn anemada, Galilin Distrighɨn aven itir nguibam. ");
INSERT INTO msy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ezɨ ensel ghua, guivir igiar gumazitam koma akuizir puvatɨzim, an ziam Maria, me gumazim Josepɨn ikiasa a ginaba. Josep, an Atrivim Devitɨn ovavimra. ");
INSERT INTO msy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ensel a bagha ghuava kamaghɨn a mɨgei, “Dughiar aghuarim Maria. Ekiam nɨ gifongegha deravɨra nɨ gamua egha nɨ ko iti.” ");
INSERT INTO msy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ezɨ Maria an akam baregha dɨgavir kuram gamigha pura nɨghnɨsi, “Kar akar manmaghɨn amizim?” ");
INSERT INTO msy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ezɨ ensel kamaghɨn a mɨgɨa ghaze, “Maria, nɨ atiatingan markɨ, God bar nɨ gifuegha nɨ ko iti. ");
INSERT INTO msy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nɨ oragh, nɨ navim asegh otarim bateghɨva, ziar kam Iesus, a datɨgh. ");
INSERT INTO msy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A ziar ekiam ikɨtɨ, me suam, kar Godɨn bar pɨn itimɨn otarim. Eghtɨ God a damightɨ, a uan ovavim, Atrivim Devitɨn mɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eghtɨ a Jekopɨn adarazir atrivimɨn ikɨvɨra ikiam. Eghtɨ a bizibagh ativamin dughiar kam gɨvaghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ezɨma Maria kamaghɨn enselɨn azara, “Kɨ guivir igiar patamɨn itir puvatɨzim. Ezɨma bizir kam manmaghɨn na batogham?” ");
INSERT INTO msy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ezɨ ensel an akam ikaragha kamaghɨn mɨgei, “Godɨn Duam nɨ bagh izeghtɨ bar pɨn itir Godɨn gavgavim nɨ avaragham. Eghtɨ borim Godɨn damazimɨn zueghtɨ me Godɨn Otarim a darɨgham. ");
INSERT INTO msy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","37","Bizitam Godɨn aven kozir puvatɨ. Nɨn anabam Elisabet, a ghurigha, egha uaghan navim adai. Me ghaze, an navim asangan kogham, ezɨ an navir adasem datɨrɨghɨn iakinir 6 plan tu.” ");
INSERT INTO msy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ezɨ Maria kamaghɨn ensel ikara, “Kɨ Godɨn ingangarir amizim. Nɨ mɨkemezir moghɨra God bizibar na damu.” Ezɨ ensel anetegha ghu. ");
INSERT INTO msy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ezɨ dughiar kamɨn Maria uan biziba akɨrighava zuamɨra nguibar ekiar Judian Distrighɨn mɨghsɨamɨn itimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Egha a Sekaraian dɨpenimɨn aven ghugha dughiam Elisabet ganɨngi. ");
INSERT INTO msy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ezɨ Elisabet Marian tiarim barazima, an borim an navimɨn aven aguaghfa, ezɨma Elisabet Godɨn Duam a gizɨfa. ");
INSERT INTO msy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Eghava a pamtemɨn tiarim akarigha kamaghɨn mɨgei, “Nɨ amizibagh afirazɨ God bar bizir aghuim nɨ gami. Egh a uaghan bizir aghuim borir nɨ oteghamim gami. ");
INSERT INTO msy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ezɨ God tizim bagha deravɨra na gami, ezɨma nan Ekiamɨn amebam na bagh izi? ");
INSERT INTO msy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ezɨ kɨ nɨ barazi, nɨ dughiam na ganɨngizɨma borir na navir averiamɨn itim bar akuegha aguaghfa. ");
INSERT INTO msy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nɨ nɨghnɨzir gavgavim Godɨn iti, ezɨ Ekiam nɨ mɨkemezɨ moghɨn bizibar nɨ gami. Kamaghɨn nɨ bar akongegh.” ");
INSERT INTO msy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Ezɨ Maria kamaghɨn mɨgei, “Kɨ pura Ekiamɨn ingangarir amizim, kamaghɨn amizɨma a na ginɨrɨ. Kamaghɨn nan navim Ekiamɨn ziam fe. Ezɨ nan duam God bagha bar akonge, a nan akurvazim. God a bar gavgavigha bizir bar ekiabar na gami. Ezɨ an ziam bar zuegha dera. Kamaghɨn amizɨ, datɨrɨghɨn tugh mangɨ gumazamiziba na mɨkɨm suam, God deravɨra nɨ gami. ");
INSERT INTO msy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ezɨma a gumazamizir an atiatiava an apengan itibar apangkufi. A kamaghɨra datɨrɨghɨn itir gumazamizibar amu gɨn izamin gumaziba ko amizibar amu mamaghɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","A uan dafarimɨn bizir bar gavgavibagh ami. Gumazir uarira uan ziaba feba, a men agɨrazɨma me are. ");
INSERT INTO msy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","God atrivibar gavgavim dɨkabɨragha gumazir kɨniba fe. ");
INSERT INTO msy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A bizir aghuiba isava mɨtiriaba azibagh aniga, biziba bar izɨvaziba amangizɨma me pura ghue. ");
INSERT INTO msy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A uan ingangarir gumazim Israelɨn akura. Egha en ovavibagh amizir akar gavgavim gɨnɨghnɨghavɨra iti. Egha Abrahamɨn apangkuvigha, egh gɨn otivamin gumazibar apangkuvigh mamaghɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ezɨ Maria iakinir pumuning ko mɨkezimɨn Elisabet ko ikegha gɨn uamategh uan nguibamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ezɨma Elisabet otamin dughiam otozɨma, an otarim bate. ");
INSERT INTO msy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","An boroghɨra itir darasi koma an anababa kamaghɨn oraki, Ekiam an apangkuvigha bizir aghuim a gamizɨma, me a ko bar akonge. ");
INSERT INTO msy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ezɨ an 7 plan dughiaba gɨvazɨma, me borimɨn mɨkarzir mogomem aghorasa izi. Egha me an afeziamɨn ziam Sekaraia a darɨghasa. ");
INSERT INTO msy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ezɨma an amebam kamaghɨn me mɨgei, “Puvatɨ! E Jon a darɨgham.” ");
INSERT INTO msy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ezɨ me kamaghɨn a mɨgei, “Nɨn anabatam ziar katam itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Egha me dafarimra an afeziamɨn azangsɨsi, a ziar manatam uan otarim darɨgham. ");
INSERT INTO msy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Egha Sekaraia an ziam osirasa biziba bagha dafaribara men azangsɨsi. Egha kamaghɨn osiri, “An ziam Jon.” Ezɨma me kamaghɨn ganigha bar aguaghfa. ");
INSERT INTO msy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ezɨma an akam zuamɨra kuiaghrɨzɨma an mɨzem fɨriaghrɨzɨma, a maghɨra mɨgɨava Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ezɨma an boroghɨn itir darazi kamaghɨn ganigha, bar atiatingi. Ezɨma Judian Distrighɨn itir nguibar mɨghsɨabar itibar gumaziba bizir otivizir kaba baregha dar gun uariv gei. ");
INSERT INTO msy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ezɨ Ekiamɨn gavgavim borir kam ko iti. Ezɨma me bar moghɨra bizir kam baregha, a gɨnɨghnɨgha a bagha azangsɨsi, “Borir kam bar manmaghɨram otogham?” ");
INSERT INTO msy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ezɨma an afeziam Sekaraia Godɨn Duam a gizɨvazɨma, a Godɨn nɨghnɨzimɨn gun mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ekiam iza uan gumaziba ko amiziba ua me ini, kamaghɨn amizɨma, e an ziam fe, a Israelbar God. ");
INSERT INTO msy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God en akurvaghasa uan ingangarir gumazim Devitɨn adarazir aven gumazir bar gavgavim amɨsefe. ");
INSERT INTO msy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Godɨn akam inigha izir gumaziba bizir kamɨn gun fomɨra kamaghɨn me mɨkeme. ");
INSERT INTO msy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","An en apaniba koma en atara pazav e gamibar dam e iniasa ize. ");
INSERT INTO msy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Egh apangkuvim en ovavibar akakaghɨva, uan Akar Dɨkɨrɨzir Gavgavim nɨrɨgham, ");
INSERT INTO msy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","akar gavgavir en ovavim Abraham ganɨngizim. ");
INSERT INTO msy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Egh en apaniba dam e iniva, en amamangatɨghtɨma e an ingarsɨva atiatingan koghɨva, ");
INSERT INTO msy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","eghɨva e an damazimɨn arazir aghuir a ifongezibar gɨn mangam, eghtɨ a ifongezir arazir aghuir kaba en ikiam. ");
INSERT INTO msy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ezɨ nɨ nan borim, nɨ faragh mangɨ Ekiam bagh tuavim akɨr. Kamaghɨn amizim, me Godɨn bar pɨn itimɨn akam inigha izir gumazim nɨ darɨgham. ");
INSERT INTO msy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","Godɨn apangkuvim e ko itima, a uan gumazamiziba ua me iniamin fofozim me ganɨga, men arazir kuraba gɨn amadi. Ezɨma aruemɨn angazangarim Godɨn Nguibamɨn ikegh e bagh izighram. ");
INSERT INTO msy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Egh angazangarim mɨtarmemɨn ikiava aremeghasava amibagh feghɨva, egh navir amɨrɨzimɨn tuavim en suebar akagham.” ");
INSERT INTO msy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ezɨma Jon gɨn aghuiga gɨvazɨma an duam uaghan aghua gavgafi. Egha a Judian nguazir gumaziba puvatɨzimɨn iti. Egha ghua an azenim girɨgha Israelɨn gumazibar damazimɨn oto. ");
INSERT INTO msy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ezɨ dughiar kam Sisar Ogastus akar gavgavim amadagha ghaze, “Rom garir nguibabar gumazamiziba bar mangɨ uan ziaba osir.” ");
INSERT INTO msy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Dughiar kam Kwirinius, a Sirian gumazir dapanimɨn itima, ziaba osirir dughiar faragha zuir kam oto. ");
INSERT INTO msy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ezɨ gumazamiziba uan ziaba osirasa uan nguibabara zui. ");
INSERT INTO msy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ezɨ Josep uaghan Devitɨn anabar mam. Kamaghɨn a Galilin Distrighɨn itir nguibam Nasaret ategha, Judian Distrighɨn itir nguibam Betlehemɨn zui, kar Devitɨn nguibam. ");
INSERT INTO msy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A mangɨva uan amuir inabazim Maria ko aning uan ziamning osirasa. Dughiar kam Maria borimɨn navim adai. ");
INSERT INTO msy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Egha aning ghuava Betlehemɨn itima, Maria borim batamin dughiam oto. ");
INSERT INTO msy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ezɨ a uan otarir ivariam bate. Egha borim inir avɨzibar a nomke. Dughiar kam dɨpenir akuim izɨfa. Kamaghɨn amizɨ, aning borim isava bulmakauba apir danganimɨn anetɨ. ");
INSERT INTO msy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ezɨ sipsipbar garir gumazir maba nguibamɨn azenan ikiava, dɨmagaribar uan sipsipbar gara me geghufi. ");
INSERT INTO msy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ezɨ Ekiamɨn enselɨn mam pura me batozɨ, Ekiamɨn angazangarim me gisira. Ezɨ me bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ezɨ ensel kamaghɨn me mɨgei, “Ia atiatingan markɨ. Ia oragh! Kɨ akar aghuim inigha ia bagha izi. Akar aghuir gumazamiziba bar me damightɨ, me bar akongegham. ");
INSERT INTO msy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Datɨrɨghɨn Devitɨn nguibamɨn akurvazir gumazim ia bagha oto. A God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim, a en Ekiam. ");
INSERT INTO msy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ia mangɨ kamaghɨn ganigh fogh, ia gantɨma me borim inir avɨzibar a nomkeghɨva bulmakauba apir danganim datɨghtɨma a irɨghɨv ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ezɨ maghɨra, Godɨn nguibamɨn enselɨn avɨrir bar dafam otogha enselɨn kam ko me Godɨn ziam fa kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ia bizibar pɨn itir Godɨn ziam fɨ. Eghtɨ nguazimɨn itir gumaziba ko amizir God ifongeziba, me navir amɨrɨzimɨn ikɨ.” ");
INSERT INTO msy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ezɨ enselba sipsipbar garir gumaziba ategha Godɨn nguibamɨn ghuezɨma, ezɨ sipsipbar garir gumaziba uarira uariv gei, “Aria, e Betlehemɨn mangɨva Ekiam e mɨkemezir bizir otozimɨn ganika.” ");
INSERT INTO msy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Egha me zuamɨra ghuava Josep ko Marian api, egha borimɨn garima a bulmakauba apir danganim girɨghav iti. ");
INSERT INTO msy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Egha sipsipbar garir gumaziba borimɨn ganigha, egha ensel borimɨn gun me mɨkemezir akabar gun gumazir igharazibav gei. ");
INSERT INTO msy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ezɨ gumazamiziba sipsipbar garir gumazibar eghaghanim baregha dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ezɨ Maria bizir kaba uan navir averiam gatɨgha, egha dagh nɨghnɨghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ezɨ sipsipbar garir gumaziba uamatenge. Ensel me mɨkemezɨ me oraghizɨ moghɨn bizibar gari, da otifi. Kamaghɨn me bar akuegha Godɨn ziam fa zui. ");
INSERT INTO msy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ezɨ 7 plan dughiaba gɨvazɨma an mɨkarzir mogomem aghoramin dughiam otozɨ me ziam Iesus a gatɨ. Maria tɨghar navim asangam, ensel faragha a gatɨzir ziam. ");
INSERT INTO msy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ezɨ Moses Osirizir Arazibar mɨn amebam Godɨn damazimɨn zueghamin dughiam otozɨma, Maria ko Josep borim inigha Ekiam danɨngasa Jerusalemɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ekiam Moses ganɨngizir arazibar osizirim iti, borir otarir ivariaba me da isɨ ua Ekiam danɨngam. ");
INSERT INTO msy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ezɨ aning Ekiamɨn arazir osiriziba mɨkemezɨ moghɨn, aning ofa damuasa, kuarazir bunbar pumuning, o bunbamɨn mɨn gari kuarazir igiar pumuning inigha izi. ");
INSERT INTO msy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ezɨ Jerusalemɨn aven gumazir mam, an ziam Simeon, a Godɨn damazimɨn deragha God baghavɨra iti. A Israelɨn gumazamizibar osɨmtɨziba a gɨvamin dughiam bagha mɨzuai iti. ");
INSERT INTO msy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Godɨn Duam bizir kam azenarama an akagha gɨfa, a faragh Ekiamɨn Krais (Gumazir God Ua Gumazamiziba Iniasa Mɨsevezim), an an ganighɨva, gɨn aremegham. ");
INSERT INTO msy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kamaghɨn amizɨma Godɨn Duam nɨghnɨzim a ganɨngizɨma a Godɨn Dɨpenir avɨzimɨn zui. Ezɨ Josep ko Maria Iesus inighava aven iza Ekiamɨn arazir osirizim mɨkemezɨ moghɨn, a damuasa. ");
INSERT INTO msy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ezɨ Simeon Iesus inighava uan dafarimningɨn a ifiraghava Godɨn ziam fa kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“Ekiam, kɨ nɨn ingangarir gumazim. Eghtɨ nɨn akurvazimɨn angazangarim nɨ Kantrin Igharazibar Gumaziba me danɨngam. Egh ziar ekiam Israelbar anɨngam; me nɨn gumazamiziba. Ezɨ nɨ gumazamizibar damazibar me bagha akurvazir bizir kam gami. Ezɨ nɨ en akuragh ua e iniamin bizir kam, kɨ uan damazimɨn an ganigha gɨfa. Kamaghɨn amizɨ, nɨ fomɨra mɨkemezɨ moghɨn nɨ na ateghtɨ kɨ mangɨ, navir amɨrɨzimɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ezɨ borimɨn amebam ko afeziam Simeon an gun mɨkemezir mɨgɨrɨgɨaba baregha aning nɨghnɨzir avɨribagh ami. ");
INSERT INTO msy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ezɨ Simeon ghaze, God bizir aghuiba ia bagh a dar amu, egha Simeon an amebam Maria kamaghɨn a mɨgei, “Borir kam God a ginaba, eghtɨ Israelɨn avɨriba God bagh tugh gavgavigham. Eghtɨ avɨriba iregham. Eghtɨ gumazamiziba bizir an amibar ganɨva akar kurabar dav kɨmam. ");
INSERT INTO msy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kamaghɨn gumazir avɨribar nɨghnɨzir navimɨn aven itiba azenan otivam. Eghtɨ osɨmtɨzir ekiar mam uaghan nɨn mɨkarzimɨn otivam.” ");
INSERT INTO msy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ezɨ Godɨn akam inigha izir amizir mam iti, an ziam Ana, a Panuelɨn guivim, Aserɨn anabam. A faragha pamɨn itima aningɨn 7 plan azeniba, ezɨ an pam aremezɨma, ezɨ datɨrɨghɨn a bar ghuri. ");
INSERT INTO msy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Egha 84 plan azeniba, a odiarimɨn iti. A Godɨn Dɨpenim ataghrazir pu, egha dɨmagariba ko arueba Godɨn ziam fa, egha dagheba ataghragha God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Egha dughiar kamra a uaghan iza men mɨriamɨn tu. A biziba bagha God mɨnabi. Egha borir kamɨn gun gumazamizir avɨribav gei, me God ua Jerusalemɨn itir gumaziba ko amiziba iniamin dughiam mɨzuai. ");
INSERT INTO msy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Egha Josep ko Maria biziba bar Ekiamɨn arazir osirizim mɨkemezɨ moghɨn dagh amigha gɨvagha, egha uamategha Galilin Distrighɨn aven itir nguibam Nasaretɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ezɨ borim aghuiga mɨkarzimɨn gavgafi. Ezɨ fofozir aghuim bar a gizɨfa. Ezɨ bizir aghuiba God a bagha dagh ami. ");
INSERT INTO msy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Azeniba zurara Iesusɨn amebam ko afeziam, God Israelbagh Itazir Dughiamɨn Isam bagha Jerusalemɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ezɨ an azenir 12 plan otogha, arazim mɨrara me isam bagha zui. ");
INSERT INTO msy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Isam gɨvazɨma, an gɨn, an amebam ko afeziam uamategha nguibamɨn zuima, aningɨn otarim Iesus, a Jerusalemra itima aning a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Aning ghaze, a ti uan namakaba ko izi. Egha aruer kamɨn ghuavɨra iti. Egha aning maghɨra uan namakaba koma anababar torimɨn a bagha rui. ");
INSERT INTO msy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Egha aning an apizir puvatɨ, egha aning a bagh ruiasa uamategha Jerusalemɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dughiar mɨkezimɨn gɨn aning Godɨn Dɨpenimɨn avɨzimɨn an api. A tisabar torimɨn aperaghav iti, egha me baragha azangsɨzibar me gami. ");
INSERT INTO msy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gumazir kaba bar an fofozim ko akar ikarvazir kaba baragha egha dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ezɨ an amebam ko afeziam an apigha, egha dɨgavir kuram gami. Egha an amebam kamaghɨn a mɨgei, “Nan otarim, nɨ tizim bagha arazir kurar kamɨn ga gami? Ga nɨ bagha bar osemegha nɨ buri.” ");
INSERT INTO msy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ezɨ a kamaghɨn aningɨn azara, “Gua tizim bagha na buri? Gua ti fozir puvatɨ, kɨ uan Afeziamɨn Dɨpenimɨn aven ikiam?” ");
INSERT INTO msy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ezɨ an aningɨn mɨgeir bizimɨn mɨngarim aning a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Egha a aningɨn akam baregha aning ko Nasaretɨn uaghiri. Ezɨ an amebam bizir kaba baregha dagh nɨghnɨghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ezɨ Iesus fofozim ko mɨkarzim sarama aghui. Ezɨ an araziba God koma gumazibagh amima, me a gifonge. ");
INSERT INTO msy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Dughiar kam Taiberius Sisarɨn 15 plan azenimɨn Romɨn atrivimɨn itim oto. Ezɨ Pontius Pailat Judian Distrighɨn gavmanɨn gumazir dapanimɨn iti, Herot Galilin Distrighɨn gavmanɨn gumazir dapanimɨn iti. Ezɨ an aveghbuam Filip Iturian Distrigh ko Trakonitisɨn Distrighɨn gavmanɨn gumazir dapanimɨn ti, ezɨ Lisanias Abilenen Distrighɨn gavmanɨn gumazir dapanimɨn iti. ");
INSERT INTO msy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ezɨma Anas ko Kaiafas Godɨn ofa gamir gumazir dapanimningɨn iti. Dughiar kam Jon, Sekaraian otarim, gumaziba itir puvatɨzir danganimɨn itima, God uan mɨgɨrɨgɨam a ganɨngi. ");
INSERT INTO msy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ezɨ Jon Jordanɨn dɨpar mɨriamɨn aruava akam kura kamaghɨn mɨgei, “Ia uan navibagh iraghɨva rueghtɨ, God ian arazir kuraba gɨn amadagham.” ");
INSERT INTO msy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Godɨn akam inigha izir gumazim Aisaian akɨnafarimɨn osirizir mɨgɨrɨgɨabar mɨrara ghu, a kamaghɨn mɨgei, “Gumazir tiarir mam gumaziba puvatɨzir danganimɨn dia ghaze, ‘Ia Ekiam baghɨva tuaviba azenɨva, dar kɨr. ");
INSERT INTO msy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kukuniba apemɨva, mɨghsɨaba ko akɨribar amutɨ da magɨrɨ. Tuavir ighuagha aruiba dar amutɨ da voroghɨra ikɨ. Egh tuavir kurabar amutɨ da deragh. ");
INSERT INTO msy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Eghtɨ nguazir kamɨn gumazamiziba bar Godɨn akurvazimɨn ganam.’” ");
INSERT INTO msy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ezɨ Jon gumazamizir bɨzir ruasa a bagha izibav gei, “Ia kuruzir divir anababa! Tina ia mɨkemezɨ ia Godɨn adarimɨn arɨ mangasa? ");
INSERT INTO msy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ia navim girazir arazibara amu. Egh ia pura Abrahamɨn ovavibar uari arɨgh mɨkɨman markɨ. Kɨ ia mɨgei, God dagɨar kabara amightɨ da Abrahamɨn ovavibar mɨn otivighamin gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sobiam datɨrɨghɨn temer povibar iti, eghtɨ temer dagher ovɨzir aghuiba itir puvatɨziba, God bar da okeghɨva da isɨva avim mɨkɨnam.” ");
INSERT INTO msy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ezɨ gumazamiziba Jonɨn azara, “Ezɨ e manmaghɨra damuam?” ");
INSERT INTO msy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ezɨ Jon me ikara, “Gumazir korotiar aven azuir pumuning itim, tam isɨ gumazir puvatɨzim danɨngigh. Ezɨ dagheba itiba uaghan kamaghɨra damu.” ");
INSERT INTO msy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ezɨ gavmanɨn dagɨaba isir gumaziba uaghan ruasa ize. Egha me azangsɨgha ghaze, “Tisa, e manmaghɨra damuam?” ");
INSERT INTO msy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ezɨ a kamaghɨn me mɨgei, “Gumazibar dagɨabagh isɨn ua dagɨataba inian markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ezɨ mɨdorozir gumazir maba Jonɨn azara, “Ezɨ eia, e manmaghɨn damuam?” Ezɨ a me ikara, “Gumazamizibar dagɨaba okɨmsɨva akar ifavaribar me gasan markɨ. Ia uan ingangarimɨn ivezimra initɨ deragham.” ");
INSERT INTO msy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gumazamiziba bizir kabar garima men navir averiaba me ginivima me pura nɨghnɨgha ghaze, Jon ti God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim? ");
INSERT INTO msy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ezɨ Jon bar men nɨghnɨziba ikara, “Kɨ dɨpamɨn ia rue. Ezɨ gumazir mam gɨn izam, an gavgavim bar nan gavgavim gafira. An dagarir asuabar beniba kɨ da firan gavgaviba puvatɨ. A Godɨn Duam ko avimɨn ia ruam. ");
INSERT INTO msy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A witba mɨsevir savol an agharimɨn iti, eghtɨ a uan witba mɨsɨva dar daghebar arɨghɨva, witba mɨsevir dɨpenimɨn witɨn mɨseviba aviva, egh dar mɨseviba avir munger puvatɨzimɨn da akuntɨma, da isiam.” ");
INSERT INTO msy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Egha Jon mɨgɨrɨgɨar avɨrir maba sara me mɨgɨa men navibagh inifi. Egha kamaghɨn akar aghuim me mɨkɨri. ");
INSERT INTO msy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ezɨ dughiar kam Herot gavmanɨn gumazir dapanimɨn ti. A uan aveghbuam Filipɨn amuim Herodias koma akui, egha arazir kurar maba sarama ami. Ezɨ kamaghɨn Jon Herodias bagha Herotɨn guam gatɨgha a mɨkeme. ");
INSERT INTO msy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herot uan arazir kurar maba ko kam sara isɨn atɨghava, Jon kalabus gatɨghava an tiam asara. ");
INSERT INTO msy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon gumazamiziba ruer dughiam, Iesus uaghan, Jon a rue. Ezɨ Iesus uan afeziam God ko mɨgeima, overiam kuiaghrɨzɨ, ");
INSERT INTO msy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Godɨn Duam bunbamɨn nivafɨzim gavagha a bagha izaghiri. Ezɨ tiarir mam overiamɨn otogha kamaghɨn mɨgei, “Nɨ nan Otarim, Otarir kɨ ifongezim. Kɨ nɨ bagha bar akonge.” ");
INSERT INTO msy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Dughiar kam Iesus uabɨ 30 plan azeniba. Ezɨ a uan ingangarim maghɨram a gami. Gumaziba ko amiziba ghaze, Iesus Josepɨn otarimra. Ezɨ Josep Helin otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ezɨ Heli Matatɨn otarim. Ezɨ Matat Livain otarim. Ezɨ Livai Melkin otarim. Ezɨ Melki Janain otarim. Ezɨ Janai Josepɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ezɨ Josep Matatiasɨn otarim. Ezɨ Matatias Amosɨn otarim. Ezɨ Amos Nahumɨn otarim. Ezɨ Nahum Eslin otarim. Ezɨ Esli Nagain otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ezɨ Nagai Matɨn otarim. Ezɨ Mat Matatiasɨn otarim. Ezɨ Matatias Seminɨn otarim. Ezɨ Semin Josekɨn otarim. Ezɨ Josek Jodan otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ezɨ Joda Joananɨn otarim. Ezɨ Joanan Resean otarim. Ezɨ Resea Serubabelɨn otarim. Ezɨ Serubabel Sealtielɨn otarim. Ezɨ Sealtiel Nerin otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ezɨ Neri Melkin otarim. Ezɨ Melki Adin otarim. Ezɨ Adi Kosamɨn otarim. Ezɨ Kosam Elmadamɨn otarim. Ezɨ Elmadam Erɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ezɨ Er Josuan otarim. Ezɨ Josua Elieserɨn otarim. Ezɨ Elieser Jorimɨn otarim. Ezɨ Jorim Matatɨn otarim. Ezɨ Matat Livain otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ezɨ Livai Simeonɨn otarim. Ezɨ Simeon Judan otarim. Ezɨ Juda Josepɨn otarim. Ezɨ Josep Jonamɨn otarim. Ezɨ Jonam Eliakimɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ezɨ Eliakim Melean otarim. Ezɨ Melea Menan otarim. Ezɨ Mena Matatan otarim. Ezɨ Matata Natanɨn otarim. Ezɨ Natan Devitɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ezɨ Devit Jesin otarim. Ezɨ Jesi Obetɨn otarim. Ezɨ Obet Boasɨn otarim. Ezɨ Boas Salmonɨn otarim. Ezɨ Salmon Nasonɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ezɨ Nason Aminadapɨn otarim. Ezɨ Aminadap Atminɨn otarim. Ezɨ Atmin Arnin otarim. Ezɨ Arni Hesronɨn otarim. Ezɨ Hesron Peresɨn otarim. Ezɨ Peres Judan otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ezɨ Juda Jekopɨn otarim. Ezɨ Jekop Aisakɨn otarim. Ezɨ Aisak Abrahamɨn otarim. Ezɨ Abraham Teran otarim. Ezɨ Tera Nahorɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ezɨ Nahor Serukɨn otarim. Ezɨ Seruk Reun otarim. Ezɨ Reu Pelekɨn otarim. Ezɨ Pelek Eberɨn otarim. Ezɨ Eber Selan otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ezɨ Sela Kainanɨn otarim. Ezɨ Kainan Arpaksatɨn otarim. Ezɨ Arpaksat Siemɨn otarim. Ezɨ Siem Noan otarim. Ezɨ Noa Lamekɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ezɨ Lamek Metuselan otarim. Ezɨ Metusela Enokɨn otarim. Ezɨ Enok Jaretɨn otarim. Ezɨ Jaret Mahalalelɨn otarim. Ezɨ Mahalalel Kenanɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ezɨ Kenan Enosɨn otarim. Ezɨ Enos Setɨn otarim. Ezɨ Set Adamɨn otarim. Ezɨ Adam Godɨn otarim. ");
INSERT INTO msy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iesus, Godɨn Duam bar a gizɨvazɨma a Jordanɨn dɨpam ategha uamategha Galilin Distrighɨn zui. Ezɨma Godɨn Duam a inigha gumaziba itir puvatɨzir danganimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ezɨ Iesus danganir kamɨn 40 pla arueba ko dɨmagaribar itima, Satan bizibar a gifari. Iesus dughiar kabar daghetam amezir puvatɨ. Ezɨma dughiar kaba gɨvazɨma mɨtiriam an azi. ");
INSERT INTO msy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ezɨma Satan kamaghɨn a mɨgei, “Nɨ guizbangɨra Godɨn Otarim, nɨ dagɨar kam mɨkemeghtɨma a bretɨn mɨn otogh.” ");
INSERT INTO msy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ezɨ Iesus Satan ikaragha ghaze, “Godɨn Akɨnafarim kamaghɨn mɨgei, ‘Gumazamiziba daghebara damɨva dar gavgavimɨn ikian kogham.’” ");
INSERT INTO msy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ezɨ Satan Iesus inigha danganir bar pɨn itimɨn ghuavanaboghava, egha zuamɨra nguazir kamɨn nguibaba bar an aka. ");
INSERT INTO msy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Egha Satan kamaghɨn Iesus mɨgei, “Bizir kaba nan agharimɨn iti, kamaghɨn amizɨma kɨ tina danɨngsɨ fueghɨva, a danɨngam. Kamaghɨn kɨ nguibar kabar ganamin gavgavim ko, dar bizir aghuiba nɨ danɨngam. ");
INSERT INTO msy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Eghtɨ nɨ tevimning apɨrigh nan ziam fɨtɨ, bizir kaba bar nɨna.” ");
INSERT INTO msy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ezɨ Iesus kamaghɨn an akam ikara, “Godɨn Akɨnafarim kamaghɨn mɨgei, ‘Nɨ uan Ekiam God, nɨ an apengara ikɨ an ziamra fam.’” ");
INSERT INTO msy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ezɨma Satan Iesus inighava Jerusalemɨn ghughava a isava Godɨn Dɨpenim pɨn mar anefa. ");
INSERT INTO msy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Egha a kamaghɨn a mɨgei, “Godɨn Akɨnafarim kamaghɨn mɨgei, ‘A nɨ bagh uan enselbar mɨkemeghtɨma me deraghvɨra nɨn ganam, egh me uan dafaribar nɨ feghtɨma nɨ dagɨatam uan dagarim aseghan kogham!’ Kamaghɨn amizɨma nɨ guizbangɨra Godɨn Otarim, nɨ kagh ikɨ uabɨ ekunigh.” ");
INSERT INTO msy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ezɨ Iesus an akam ikara, “Godɨn Akɨnafarim kamaghɨn mɨgei, ‘Nɨ uan Ekiam God a gifar, a gakaghontɨ, a nɨn nɨghnɨzimɨn gɨn mangan markɨ.’” ");
INSERT INTO msy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ezɨ Satan ifavarir kaba bar Iesus gamigha gɨvagha anetaki. A Iesus ategha ghua dughiar igharazim bagha mɨzuai. ");
INSERT INTO msy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ezɨma Iesus Godɨn Duamɨn gavgavimɨn a uamategha Galilin Distrighɨn ghu. Ezɨma an akam bar moghɨra nguibabar ghu. ");
INSERT INTO msy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Egha a God ko mɨgeir dɨpenibar men sure gamima, me bar an ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ezɨ Iesus Nasaretɨn ghu, a ikiava aghungizɨ naghɨn. Egha Sabatɨn dughiamɨn a God ko mɨgeir dɨpenimɨn aven ghu, an arazir a zuraram amim. Egha tugha Godɨn Akɨnafarim dɨponasava ami. ");
INSERT INTO msy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ezɨ me Godɨn akam inigha izir gumazim Aisaian akɨnafarir rɨghizim a ganɨngi. Ezɨma Iesus akɨnafarir rɨghizir kam onegha, mɨgɨrɨgɨar kamɨn api. ");
INSERT INTO msy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“God akar aghuim gumazir onganarazibav kɨnasa na ginaba, ezɨ kamaghɨn amizɨma Ekiamɨn Duam nan iti. Egha uaghan akar kam kunasa na amada; akar kalabusɨn itiba ataghraghamim ko gumazir damazir kuraba ua ganamim. Egh osɨmtɨzibar apengan itiba kɨ ua me fɨrɨva egh suam, Ekiam gumazamizibagh ifongezir dughiam otogha gɨfa.” ");
INSERT INTO msy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ezɨma Iesus akɨnafarim uam a righava, egha a isava ingangarir gumazim ganigha, egha apera. Ezɨma me bar moghɨra God ko mɨgeir dɨpenimɨn aven pamtem an gari. ");
INSERT INTO msy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ezɨma a maghɨra kamaghɨn me mɨgei, “Datɨrɨghɨn Godɨn mɨgɨrɨgɨar ia oraghizim a guizbangram oto!” ");
INSERT INTO msy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ezɨ me an akabagh ifongeghava nɨghnɨzir avɨribar akar aghuir a mɨkemezibagh ami, egha me kamaghɨn azara, “Kar pura Josepɨn otarimra, o?” ");
INSERT INTO msy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ezɨ Iesus kamaghɨn me mɨgei, “Ia ti akar isɨn zuir kam na mɨkɨmam, ‘Dokta nɨ uabɨ uan mɨkarzim akɨrigh!’ Egh e oraghizir bizir nɨ Kaperneamɨn amiziba nɨ kagh uaghan uan nguibamɨn dar amu.” ");
INSERT INTO msy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Egha a mɨgɨa ghuavɨra ikiava kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, Godɨn akam inigha izir gumaziba, men adarazi me baraghan aghua. ");
INSERT INTO msy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kɨ guizbangɨra ia mɨgei, Elaijan dughiamɨn, amuir odiarir bar avɨrim Israelɨn iti. Ezɨ amozim izir puvatɨgha ghua azenir pumuning ko mɨkezim ko azenir akuamɨn oto. Ezɨ dagheba bar puvatɨzir dughiam bar nguibabar oto. ");
INSERT INTO msy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ezɨ God Israelɨn amizitam bagha Elaija amadazir puvatɨ. A Sidonɨn danganir aven itir nguibar mam, Sarefetɨn itir amuir odiarim baghavɨra anemada. ");
INSERT INTO msy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ezɨma Godɨn akam inigha izir gumazim Elisan dughiamɨn, lepan avɨrim Israelɨn ti. Ezɨ God men tav gamizɨma a zuegha derazir puvatɨ. Ezɨ Namanra, God a gamizɨma a zuegha dera, a Sirian gumazir mam.” ");
INSERT INTO msy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ezɨ gumazir God ko mɨgeir dɨpenimɨn aven itiba bar bizir kam bareghava men naviba Iesus bagha men isi. ");
INSERT INTO msy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Egha me dɨkavigha, Iesus batoghezɨma a nguibam ategha azenan ghuzɨma, me a inigha nguibam itir mɨghsɨar avarir konim anekunasa zui. ");
INSERT INTO msy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ezɨ a men tongɨn ghua munagh otogha ghu. ");
INSERT INTO msy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Egha Iesus Galilin Distrighɨn aven itir nguibam, Kaperneamɨn ghuaghiri. Egha Sabatɨn dughiamɨn, a gumaziba ko amizibar sure gami. ");
INSERT INTO msy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Egha an akaba gavgavim dar ti. Egha bizir kam bagha me an suren mɨgɨrɨgɨaba baraghava dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ezɨma gumazir duar kurar itir mam, a God ko mɨgeir dɨpenimɨn aven iti. Egha a pamtem dia kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iesus, Nasaretɨn gumazim, nɨ manmaghɨra e damuasa ize? Nɨ e gasɨghasɨghasa izi? Kɨ nɨ gɨfo, nɨ God amadazimra, nɨ Godɨn damazimɨn zuezir gumazim!” ");
INSERT INTO msy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ezɨma Iesus an atarava a mɨgei, “Nɨ nɨmɨra ikɨ! Eghɨva gumazim ateghɨva azenan izɨ!” Ezɨma duar kuram men damazibar gumazim akunigha azenimɨn izava duatam gumazim gatɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ezɨ me bar aguaghfagha egha uarira uariv gei. “Eei, kar mɨgɨrɨgɨar manam? A mɨgɨrɨgɨar gavgavimɨn duar kuraba batoghezɨma da azenan izi.” ");
INSERT INTO msy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ezɨma an amir bizir kaba, dar mɨgɨrɨgɨam bar nguibabar ghu. ");
INSERT INTO msy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Egha Iesus God ko mɨgeir dɨpenim ategha Saimonɨn dɨpenimɨn ghu. Ezɨ Saimonɨn asamim ariava mɨkarzim puvɨra feima, me an akuravaghasa Iesusɨn azai. ");
INSERT INTO msy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ezɨ Iesus amizimɨn mɨn tugha aviraghava akar gavgavimɨn an arɨmariam batoghezɨma arɨmariam ghu. Ezɨ amizim zuamɨra dɨkavighava me bagha daghebagh amuava me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ezɨ aruem ghuaghirima, gumazamiziba me gumazir arɨmariar anabar avɨriba itiba Iesus bagha me inigha ize. Ezɨ a vaghvagha uan dafariba me gisɨn arɨzima me ghuamazi. ");
INSERT INTO msy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ezɨ uaghan a duar kurabagh ami da gumaziba ataghragha azenan iza kamaghɨn dei, “Nɨ Godɨn Otarim!” Duar kuraba fo, kar God Gumazamiziba Ua Me Iniasa Mɨsevezir Gumazim. Kamaghɨn amizɨma Iesus mɨkɨman dar anogoroke. ");
INSERT INTO msy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ezɨ amɨnim tirazɨma Iesus danganir gumaziba puvatɨzimɨn ghu. Ezɨma gumazamiziba a buria ghuava a batogha, egha a me ategh mangan me an anogorosi. ");
INSERT INTO msy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ezɨma a kamaghɨn mɨgei, “God akar aghuim kunasa na amada. Kamaghɨn amizɨma kɨ nguibar igharazibar uaghan dar mangɨ God Bizibagh Ativamin Dughiamɨn akar aghuim akunam.” ");
INSERT INTO msy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Egha Judian Distrighɨn a God ko mɨgeir dɨpenibar akam akura ghuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Dughiar mamɨn Iesus Genesaretɨn dɨpar akarer mɨriamɨn tughav itima, gumaziba anekuvagha Godɨn akam barasi. ");
INSERT INTO msy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ezɨma a dɨpar mɨriamɨn garima osiriba isir gumazibar botɨn pumuning pura iti. Aningɨn ghuaviba uan iver ekiaba rue. ");
INSERT INTO msy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ezɨ Iesus botɨn mamɨn ghuavanabo, Saimonɨn bot. Egha an azaragha ghaze, nɨ tong a gɨsɨvaghtɨma a dɨpar mɨriam atakigh. Ezɨ a bot gaperaghav ikia gumaziba ko amizibar sure gami. ");
INSERT INTO msy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Egha Iesus mɨkemegha gɨvagha Saimonɨn mɨgei, “Bot gɨsɨvagh dɨpar konimɨn mangɨva iver ekiaba osiriba bagh da akunigh.” ");
INSERT INTO msy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ezɨ Saimon an akam ikara, “Ekiam, e dɨmagarir kamɨn ingara ghua bar osiritam inizir puvatɨ. Ezɨ nɨ mɨgeima kamaghɨn kɨ iver ekiaba akunam.” ");
INSERT INTO msy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ezɨ me Iesus mɨkemezɨ moghɨn amigha, egha me osirir bar avɨriba inizɨma men iver ekiaba maghɨra akarasava ami. ");
INSERT INTO msy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ezɨ me uan namakar botɨn igharazimɨn itiba me gikarizɨma me iza men akura, egha me iza botɨn pumuning uaghara aning gaghuizɨma aning bar izɨvagha osemegha maghɨra dɨpamɨn ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ezɨma Saimon Pita, ko a ko itir darasi, me osirir me inizir kabar ganigha kamaghɨn dɨgavir kuram gami. Saimonɨn roroamning Jems ko Jon, Sebedin otarimning. Aning Saimon ko ingarir gumazimning, aning uaghan dɨgavir kuram gami. Kamaghɨn amizɨma Saimon kamaghɨn ganigha, tevimning apɨrigha Iesusɨn suemningɨn boroghɨn irɨ. Egha ghaze, “Ekiam, kɨ gumazir arazir kurabagh amim! Kamaghɨn amizɨma nɨ na ategh mangɨ.” Ezɨ Iesus kamaghɨn Saimonɨn mɨgei, “Nɨ atiatingan markɨ, datɨrɨghɨn tugh mangɨ, nɨ gumaziba iniam.” ");
INSERT INTO msy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ezɨ me uan botba mɨkɨrvegha, dɨpar dadarimɨn ghuavanega, egha biziba bar da ategha Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ezɨma Iesus nguibar ekiar mamɨn itima, gumazir mam lepa bar anegɨrizɨma, a izava oto. Egha a Iesusɨn apighava ira uan guam nguazim mɨtuaghava kamaghɨn a mɨgei, “Ekiam, nɨ fueghɨva nɨ na damutɨ, kɨ Godɨn damazimɨn zuegh ua deragham.” ");
INSERT INTO msy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ezɨ Iesus uan agharim isa gumazir kam gatɨgha ghaze, “Kɨ ifonge. Nɨn mɨkarzim zuegh, egh ua deragh.” Ezɨma lepa zuamɨra anetaki. ");
INSERT INTO msy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Egha Iesus akar gavgavim a ganɨngi, “Tavɨn mɨkɨman markɨ. Egh mangɨ, uabɨ Godɨn ofa gamir gumazimɨn akagh, egh Moses mɨkemezɨ moghɨn, nɨ uabɨ zueghsɨ ofa damu. Eghtɨ gumazamiziba fogh suam, nɨn arɨmariam gɨfa.” ");
INSERT INTO msy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ezɨma Iesus amizir bizir kabar eghaghanim bar mar ghu. Kamaghɨn gumaziba ko amizir avɨrim a baraghɨva men arɨmariaba ua deraghasa izi. ");
INSERT INTO msy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ezɨ Iesus zurara me ataghragha ghua, gumazamiziba itir puvatɨzir danganimɨn ikia God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dughiar mamɨn Iesus gumaziba ko amizibar sure gami. Ezɨ Farisiba ko Judan arazibagh fozir gumaziba, me Galilin Distrigh ko Judian Distrighɨn itir nguibaba bar, ko Jerusalemɨn nguibamɨn ikegha izava apiaghav iti. Ezɨ Ekiamɨn gavgavim uaghan iti, kamaghɨn Iesus men arɨmariabar amutɨma da deragham. ");
INSERT INTO msy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ezɨ gumazir maba gumazir soroghafariba aremezim inighava akuriam gatɨghava a inigha dɨpenimɨn aven mangɨ Iesusɨn guamɨn anerɨghasa. ");
INSERT INTO msy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ezɨ gumazamiziba bar avɨraseme. Ezɨma me aven mangan iburaghava dɨpenir siriamɨn ghuavanabogha dɨpenir siriamɨn torim gamigha benibar an akuriam dafagha, nɨmɨra anetaghrazima a ghuaghira gumazamizir okuruamɨn tongɨn Iesusɨn guamɨn anetɨ. ");
INSERT INTO msy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ezɨma Iesus men nɨghnɨzir gavgavibar ganigha, egha kamaghɨn mɨgei, “Namakam, nɨn arazir kuraba kɨ da gɨn amada.” ");
INSERT INTO msy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ezɨma Farisiba ko Judan arazibagh fozir gumaziba maghɨra uan navir averiabar aven nɨghnɨsi, “Kar gumazir manam Godɨn danganim iniasa mɨgɨrɨgɨar kam gami? Gumazir kɨnitam arazir kuraba gɨn amangam, o puvatɨ? God uabɨra.” ");
INSERT INTO msy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ezɨ Iesus men nɨghnɨzibagh fogha, egha a men azara, “Ia tizim bagha bizir kabar uan navir averiabar dagh nɨghnɨsi? ");
INSERT INTO msy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kɨ akar manam mɨkɨmam? Pura gumazir kɨnitam kamaghɨn mɨkɨm suam, kɨ nɨn arazir kuraba gɨn amada. Egh uaghan gumazir kɨnitam kamaghɨn mɨkɨman kogham suam, nɨ dɨkavigh mangɨ, egh ua deragh. ");
INSERT INTO msy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kɨ arazir kam damightɨma, ia ganigh fogham, Gumazibar Otarim a nguazir kamɨn arazir kuraba gɨn amangamin gavgavim iti.” Egha kamaghɨn gumazir soroghafariba amɨrazim mɨgei, “Kɨ nɨ mɨgei, nɨ dɨkavigh uan akuriam inigh dɨpenimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ezɨma a zuamɨra men damazibar dɨkavigha, irɨghav ikezir akuriam inigha uan nguibamɨn ghuava Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ezɨ me bar dɨgavir kuram gamigha Godɨn ziam fe. Egha agorogem me gizɨvazɨ me kamaghɨn mɨgei, “E datɨrɨghɨn bizir bar igharagha garibar gari.” ");
INSERT INTO msy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Bizir kabar gɨn Iesus ghua garima gavmanɨn dagɨaba isir gumazir mam, an ziam Livai, a uan dagɨaba isir dɨpenim gaperaghav iti. Ezɨ Iesus kamaghɨn a mɨgei, “Nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ezɨ Livai dɨkavighava, biziba bar da ateghava an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Egha Livai isar ekiam Iesus bagha uan dɨpenimɨn aneru. Ezɨma dagɨaba isir gumazir avɨrim ko gumazir maba sara izava me koma api. ");
INSERT INTO msy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ezɨma Farisiba koma Judan arazibagh fozir gumazibar adarasi, me mɨgɨrɨgɨar mabar Iesusɨn suren gumazibagh ami, “Ia tizim bagha dagɨaba isir gumaziba ko arazir kurabagh amir gumaziba koma api?” ");
INSERT INTO msy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ezɨ Iesus men akam ikara, “Arɨmariaba puvatɨzir gumaziba, dokta bagha zuir puvatɨ. Gumazir arɨmariaba itibara, me dokta bagha zui. ");
INSERT INTO msy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kɨ Godɨn damazimɨn derazir gumaziba bagha izezir puvatɨ. Kɨ, gumazamizir arazir kurabagh amibar dɨmɨva men navibagh iraghasa, kɨ ize.” ");
INSERT INTO msy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ezɨ me kamaghɨn a mɨgei, “Jonɨn suren gumaziba, me zurara God ko mɨkɨmasa dagheba ataghrasi. Ezɨ Farisin suren gumaziba uakan. Ezɨ nɨnanaba apa mamaghɨra iti.” ");
INSERT INTO msy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ezɨ Iesus men akam ikara, “Gumazir amuimɨn ikiamim, a ia ko ikɨtɨ, ia a bagha izezir gumazibav kɨmtɨ me dagheba ategham, o puvatɨgham? ");
INSERT INTO msy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Egh dughiam izɨtɨma gumazir amuimɨn ikiamim me me dama a inigh mangɨtɨma, eghtɨ dughiar kabar me dagheba ategham.” ");
INSERT INTO msy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Egha Iesus akar isɨn zuir kamɨn me geghari, “Gumazitamɨn korotiar ghurim torim an ikɨtɨma, a korotiar igiatam abigh, egh inir avɨzir kam isɨ, korotiar ghurim a dukuagh a isaman markɨ. A kamaghɨn damuva, korotiar igiar kam arɨzigham. Egh uaghan inir avɨzir igiar korotiar ghurim dukuagha isamizim, korotiar ghurimɨn mɨn ganan kogham. ");
INSERT INTO msy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ezɨ gumazitam wainɨn igiam isava wainɨn mɨsevir ghuribagh ingezir puvatɨ. A kamaghɨn damightɨma, wainɨn igiam wainɨn mɨsevir ghuriba a bightɨma wain irɨtɨma wainɨn mɨseviba ikuvigham. ");
INSERT INTO msy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A kamaghɨn damuan kogham. Wainɨn igiam, wainɨn mɨsevir igiam gingam. ");
INSERT INTO msy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ezɨma gumazim wainɨn ghurim amegha, egha igiam gifongezir pu. Eghɨva a kamaghɨn mɨkɨm suam, ‘Ghurim a dera.’” ");
INSERT INTO msy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabatɨn mam, Iesus uan suren gumaziba ko raizɨn mɨn garir dagher mam wit, an kuriabagh aruava, egha an suren gumaziba witɨn asiziba ghuaza da kuava, dar tuziba api. ");
INSERT INTO msy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ezɨ Farisin maba kamaghɨn mɨgei, “Ia tizim sua arazir Sabatɨn amir puvatɨzim gami.” ");
INSERT INTO msy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ezɨ Iesus me ikara, “Ia ti Devit fomɨra amizir arazimɨn eghaghanimɨn ganizir puvatɨ? Devit dughiar kamɨn uan adarazi ko mɨtiriam men azi, ");
INSERT INTO msy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ezɨma Devit Godɨn Averpenimɨn aven ghua me ofa damuasa atɨzir bret inigha uan adarazi ko me aneme. Egha e fo, me bretɨn kam raman kogham.” ");
INSERT INTO msy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Egha Iesus me mɨgei, “Ezɨ Gumazibar Otarim a Sabatɨn dughiamɨn Ekiam.” ");
INSERT INTO msy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabatɨn dughiar igharazim Iesus God ko mɨgeir dɨpenimɨn aven ghugha men sure gami, ezɨ gumazir mam men tongɨn iti. An dafarir guvim ekonegha an areme. ");
INSERT INTO msy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farisin maba ko Judan arazibagh fozir gumaziba an arazitamɨn apigh akam agasasa, me bar deravɨra an gari. Me kamagh sua, a Sabatɨn arɨmariaba batogham, o? ");
INSERT INTO msy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kamaghɨn Iesus men nɨghnɨzibagh fogha egha gumazir dafarir ekonezim mɨgei, “Dɨkavigh men damazibar tughtɨma me bar nɨn ganika.” Ezɨ a dɨkavigha tughav iti. ");
INSERT INTO msy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ezɨ Iesus me mɨgɨa ghaze, “Kɨ ian azai, arazir manam Sabatɨn dera? E arazir aghuim damuam, o arazir kuram damuam, o gumazimɨn akuragham, o a gasɨghasɨgham?” ");
INSERT INTO msy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Egha a bar men ganigha egha gumazim mɨgei, “Nɨ uan dafarim onegh.” Ezɨ a uan dafarim onezɨma an dafarim bar moghɨra ua dera. ");
INSERT INTO msy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ezɨma me atara egha uarira uariv gɨa ghaze, e arazir tizitamɨn Iesus damuam. ");
INSERT INTO msy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Dughiar kabar dughiar mam Iesus God ko mɨkɨmasa mɨghsɨamɨn mɨn ghuavanabogha, egha God ko mɨgeima amɨnim a bangɨn tira. ");
INSERT INTO msy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Amɨnim tirazɨma, a uabɨn gɨn aruir gumazibar diazɨ me a da ghuezɨma ezɨ a 12 pla me amɨsefe. Egha maghɨra ziam aposelba me gatɨ: ");
INSERT INTO msy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saimon (Iesus Pita a gatɨ), ko an dozim Andru, Jems, Jon, Filip, Bartolomyu, ");
INSERT INTO msy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matyu, Tomas, Jems Alfiusɨn otarim, Saimon, a Selotiabar gumazir mam, ");
INSERT INTO msy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Jemsɨn otarim, ko Judas Iskariot, gumazir gɨn Iesus isava apanibagh anɨngizim. ");
INSERT INTO msy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Egha Iesus uan suren gumaziba ko ghuaghirava danganir zarimɨn tu. An gɨn aruir gumazamizir avɨrim iti. Ezɨ maburan avɨrir Jerusalem ko Tair koma Saidonɨn Ongarir dadarim, ko Judian aven itiba, bar Iesus baraghɨva men arɨmariaba ghuamaghasa me ize. Ezɨ gumazamizir duar kuraba asɨghasɨghiziba, da me ataki. ");
INSERT INTO msy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ezɨ gavgavim Iesus ategha azenan ghua gumaziba ko amiziba bar me gami me ghuamazi, ezɨ kamagh sua me bar moghɨra Iesusɨn mɨkarzimɨn suighasa. ");
INSERT INTO msy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ezɨ Iesus uan gɨn aruir gumazibar garava kamagh mɨgei, “Ia biziba puvatɨziba, ia God Bizibagh Ativamin Dughiamɨn aven iti, kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ia datɨrɨghɨn mɨtiriam aziba, ia gɨn izɨvagham, kamaghɨn ian naviba deragh. Ia datɨrɨghɨn azi darasi, ia gɨn akam, kamaghɨn ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Me ian gantɨ ia Gumazibar Otarimɨn gɨn mangɨtɨma, men naviba ia bagh bar kuvigham. Egh me ia batoghɨva paz ia damuva ian ziabagh asɨghasɨgham. Bizir kaba ia bativtɨ ian naviba deragh. ");
INSERT INTO msy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Men afeziaba fomɨra kamaghɨra Godɨn akam inigha izir gumazibagh amizɨ moghɨn me ia gami. Ia uaghan ivezir ekiam Godɨn nguibamɨn a iniam. Kamaghɨn dughiar kam otoghtɨ, ia bar akongeghɨva agoroguem sara pɨn uari akun. ");
INSERT INTO msy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ia bizir avɨriba itiba, datɨrɨghɨn ia navir aghuim inigha gɨfa, kamaghɨn ia ikuvigham. ");
INSERT INTO msy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ia dagher avɨriba itiba, ia gɨn mɨtiriam ian agham, kamaghɨn ia ikuvigham. Ia datɨrɨghɨn ati darasi, ia gɨn arangɨva temeribagh ruam, kamaghɨn ia ikuvigham. ");
INSERT INTO msy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Gumaziba mɨgɨrɨgɨar aghuibar ia damutɨ, eghtɨ ia bar kuvigham. Fomɨra men inaziba akam inigha izir gumazir ifariba mɨgɨrɨgɨar aghuiba me gami. Kamaghɨra gumaziba me bar mɨgɨrɨgɨar aghuiba ia damutɨ, kamaghɨn ia bar ikuvigham.” ");
INSERT INTO msy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ezɨ ian na barazir darasi, kɨ ia mɨgei, ia uan apanibagh ifongegh, arazir aghuiba ia gifongezir puvatɨziba me damu, ");
INSERT INTO msy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mɨgɨrɨgɨar aghuiba ia mɨgɨrɨgɨar kuraba ia gamibar amu, paza ia gamiba ia me bagh afeziam ko mɨkɨm. ");
INSERT INTO msy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Eghtɨ tav ian koviatam apezeghtɨ, ia koviar vuem sara a danɨngi. Eghtɨ tav ian korotiar azenan itim inightɨma, uaghan aven itir korotiam sara an taki. ");
INSERT INTO msy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Egh te biziba bagha ian azangsɨsi, ia da me danɨng. Egh te ian biziba ini, ua da bagh mɨkɨmɨva me dam ada inian markɨ. ");
INSERT INTO msy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ia arazir aghuir me ia damuamin ia ifongeziba, ia arazir kabara me damu. ");
INSERT INTO msy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Egh ia, ia gifongezibara fueghɨva, egh manmaghɨn arazir aghuitam damigham? Arazir kurabagh amiba uaghan kamaghɨram ami. Me me gifongezɨ daraziragh ifonge. ");
INSERT INTO msy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Egh ia deraghvɨra deragha ia gamir darazigh amua, egha kamaghɨn arazir aghuir manam ia gami? Gumazir arazir kurabagh amiba uaghan kamaghɨram ami. ");
INSERT INTO msy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Egh ia pura uan biziba me danɨng, egh nɨghnɨgh suam, me ti da ikarvagham, egh manmaghɨn arazir aghuitam damigham? Gumazir arazir kurabagh amiba me uaghan ghaze, kɨ gumazir kurar igharazim uan biziba a danɨngtɨ, eghtɨ a gɨn ua da ikarvagham. ");
INSERT INTO msy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ia uan apanibagh ifueghɨva, deravɨra me damuva, eghɨva biziba pura me danɨngɨva, uamategh da ikarvaziba inɨsɨ nɨghnɨghan markɨ. Ezɨ God arazir aghuiba gumazir arazir kurabagh amiba koma gumazir a mɨnabir puvatɨzibagh ami. Kamaghɨn amizɨ, gɨn ian ivezim bar ekeveghtɨma, ia Godɨn bar pɨn itimɨn boribar mɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Afeziamɨn apangkuvimɨn mɨrara, ia apangkuvim ikɨ.” ");
INSERT INTO msy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “God ia tuisɨgh ian kuraghan koghsɨ, kamaghɨn ia munen araziba tuisɨghan markɨ suam, men araziba ikufi. Ivezir kuram anɨngan markɨ, eghtɨ God ivezir kuram ia danigan kogham. Ia men arazir kuraba gɨn amadaghtɨ, God ian arazir kuraba gɨn amadagham. ");
INSERT INTO msy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ia danɨng, eghtɨ God ia danɨngam. Mɨnem bar deravɨra izɨvaghtɨma, a isɨ mɨkebabar amangɨva agasavkon, eghtɨ a irɨ magɨrɨ ian apozibar inibagh iram. God bizir izɨvɨrɨziba, ia ganɨdi moghɨn ia igharaz darazir anɨng.” ");
INSERT INTO msy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iesus uaghan akar isɨn zuir mam sara me mɨkeme; “Gumazir damazir kuram damazir kurar igharazitamɨn suiragh mangam, o? Aning vɨrara mozimɨn magɨrɨgham. ");
INSERT INTO msy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Suren gumazim, uan tisa gafirazir puvatɨ. Ezɨ suren gumazir bar deravɨra uan sure a gɨvazim, a uan tisan mɨrara ghu. ");
INSERT INTO msy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tizim bagha, mɨnezir bar muziarim nɨn aveghbuamɨn damazimɨn itima, nɨ ti an gara egha temer ararir ekiar nɨn damazimɨn itimɨn garir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ter ararir ekiam nɨn damazimɨn ikɨtɨ, nɨ manmagh uan aveghbuam mɨkɨm suam, ‘Aveghbuam, kɨ nɨn damazimɨn itir mɨnezim asigham?’ Nɨ bar ifari! Nɨ faraghvɨra ter ararir nɨn damazimɨn itim asigh, egh deragh ganɨva mɨnezir nɨn aveghbuamɨn damazimɨn itim asigh.” ");
INSERT INTO msy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Egha Iesus ghua kamaghɨn mɨgei, “Temer aghuitam ovɨzir kuram batezir puvatɨ, kamaghɨra temer kuratam ovɨzir aghuim batezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gumaziba temer ovɨzibar gara fogha ghaze, temer aghuim o temer kuram. Me fighɨn ovɨziba temer ataghatarimɨn da kuari pu. Egha me wainɨn ovɨziba temer ataghatarir muziarir kuramɨn da isir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Gumazimɨn navir averiamɨn ikezir biziba, an akatorim, dav gei. Kamaghɨn gumazir aghuim bizir aghuiba an navir averiamɨn ikegha otivaghiri. Ezɨ gumazir kuram bizir kuraba an navir averiamɨn ikegha otivaghiri.” ");
INSERT INTO msy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Egha Iesus ghua kamaghɨn mɨgei, “Ia tizim bagha ‘Ekiam’ na garɨsi, egh a kɨ mɨgeir biziba dagh amir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tina iza nan mɨgɨrɨgɨaba baragha dagh ami, kɨ an araziba ian akagham. ");
INSERT INTO msy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A mati gumazim dɨpenimɨn ingara, an okora bar vɨn ghuaghira dagɨam gisɨn ter akɨniba kuni. Dɨpenir kam me bar deravɨram an ingari. Kamaghɨn amizɨma aperiamɨn dughiam dɨpam dɨpenir kamɨn aven ghuzɨma a nuighnuizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ezɨ gumazir nan mɨgɨrɨgɨaba baragha dar gɨn zui puvatɨzim, mati gumazim uan dɨpenim nguazir kɨnim ko bizitam gisɨn an ingarizir puvatɨ. Eghtɨ dughiar dɨpam izamim a dɨpenir kam bɨraghtɨma, a irɨgh bar kuvigham.” ");
INSERT INTO msy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ezɨ Iesus bizir kabar gumaziba ko amizibav kemegha gɨvagha, Kaperneamɨn aven zui. ");
INSERT INTO msy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ezɨ 100 plan mɨdorozir gumazibar garir gumazir dapanir ekiam iti. An ingangarir gumazir a bar ifongezim, ariava aremeghasava ami. ");
INSERT INTO msy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ezɨ mɨdorozir gumazir dapanir kam Iesus amizir biziba baregha Judan gumazir aruar dapanir maba a baghava da amangi. ");
INSERT INTO msy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Ezɨ me Iesus bagha izeghava pamtem kamaghɨn a mɨgei, “Gumazir kam en gumazamiziba bar me gifonge. Egha e bagha God ko mɨgeir dɨpenimɨn ingari. Kamaghɨn gumazir kam an akurvazim baghava ami, nɨ an akuragh.” ");
INSERT INTO msy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ezɨ Iesus tagha me ko zui. A ghua dɨpenimɨn boroghɨn otozɨ, ezɨ mɨdorozir gumazir dapanir ekiam uan namakaba amangizɨ me kamaghɨn a mɨgei, “Ekiam, kɨ gumazir aghuir manam, nɨ nan dɨpenimɨn aven izam? Ezɨ nɨ izɨ nan dɨpenimɨn averiamɨn izan markɨ. Nɨ paz uabɨ damuan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Kamaghɨn kɨ uabɨ nɨ bagh mɨgɨrɨgɨam inigh izan kogham. Kɨ uabɨ mɨdorozir gumazir mabar apengan iti, egha uabɨ mabar garima, da nan apengan iti. Ezɨ kɨ me mɨgei, ‘Ia mangɨ,’ eghtɨ me mangam. O, kɨ me mɨkɨmam, ‘Ia izɨ.’ Eghtɨ me izam. Egh kɨ uan ingangarir gumazir mam mɨkɨm suam, nɨ ingangarir kam damu, eghtɨ an a damuam. Egha kɨ fo, nɨ mɨkɨmtɨ, nan ingangarir gumazim ua deragham.” ");
INSERT INTO msy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ezɨ Iesus kamaghɨn oregha, dɨgavir kuram gamigha, egha raghrɨgha gumazamizir a gɨn zuibav gei, “Kɨ ia mɨgei, kɨ Israelɨn aven kamaghɨn nɨghnɨzir gavgavim itir gumazitamɨn ganizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ezɨma gumazir amadaziba uamategha dɨpenimɨn ghuava ingangarir gumazimɨn garima a dera. ");
INSERT INTO msy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Egha gɨn Iesus nguibar ziam Nainɨn zui. Ezɨ an suren gumaziba ko gumazir avɨrim an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Egha a nguibar kamɨn tiar akar ekiar kamɨn boroghɨn ghua garima, gumazir maba gumazir kuam gisaghpugha nguibar ekiamɨn ikegha azenan izi. Gumazir aremezir kamnagh, an amizir pam aremezimɨn otarir vamɨra. Ezɨ nguibar ekiar kamɨn itir gumazir avɨrim amuir odiarir kam ko iti. ");
INSERT INTO msy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ezɨ Iesus an gara egha bar an apangkuvigha kamaghɨn a mɨgei, “Nɨ arangan markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ezɨ Iesus roghɨra ghua gumaziba isaghpughav itir kezɨn suira. Ezɨ a gisaghpughav itir gumaziba voroghɨra mɨtivighav iti. Ezɨ a kamaghɨn gumazir igiam a mɨgei, “Gumazir igiam, kɨ nɨ mɨgei, nɨ dɨkafigh.” ");
INSERT INTO msy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ezɨma gumazir aremezim dɨkavigha maghɨra mɨgeima, ezɨ Iesus uam a isava an amebam ganɨngi. ");
INSERT INTO msy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ezɨma me kamaghɨn ganigha bar dɨgavir kuram gamigha, Godɨn ziam fa, egha ghaze, “Godɨn akam inigha izir gumazir ekiar mam en tongɨn oto.” Egha me ghaze, “God uan gumaziba ko amizibar akurvaghasa ize.” ");
INSERT INTO msy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ezɨma Iesus amizir bizir kamɨn eghaghanim bar Judian Distrigh ko an boroghɨn itir nguibaba sara ghu. ");
INSERT INTO msy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ezɨ Jon, Gumaziba Ruer Gumazim, an suren gumaziba bizir kabar gun bar a mɨkeme. Ezɨ a uan suren gumazir pumuningɨn diaghava, ");
INSERT INTO msy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","egha Ekiam Iesusɨn azangsɨghasava aning amada, “Ti nɨrara, gumazir God faragha amangasa mɨkemezim? O, e ti ua gumazir igharazitam mɨzuamam?” ");
INSERT INTO msy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ezɨ gumazimning Iesus bagha izegha, kamaghɨn a mɨgei, “Jon, Gumaziba Ruer Gumazim nɨn azangsɨghasa ga amada, ‘Ti nɨrara, gumazir God faragha amangasa mɨkemezim? O, e ti ua gumazir igharazitam mɨzuamam?’” ");
INSERT INTO msy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ezɨ dughiar kamnaghra Iesus gumazamizir arɨmariaba itiba gamuavɨra itima, me ua dera. Ezɨ a duar kuraba batosi, egha gumazir damazir kurar avɨrim, a me gamima, me ua gari. ");
INSERT INTO msy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kamaghɨn amizɨ, Iesus Jonɨn abuir gumazimningɨn akam ikara, “Gua uamategh mangɨ bizir gua ganigha oraghizibar gun Jonɨn mɨkemegh! ‘Gumazir damazir okavɨrɨziba ua gari, ezɨ gumazir suer amɨrɨziba uam arui. Ezɨ gumazir lepa itiba ua zuegha dera, ezɨ gumazir kuarir orazir puvatɨziba uam orasi. Ezɨ ovengezir gumaziba ua dɨkavima, ezɨ gumazir onganarazibagh amiba akar aghuim barasi.’ ");
INSERT INTO msy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Gumazir nan ganigha nɨghnɨzir gavgavim nan itim, an nɨghnɨzir gavgavim ikɨvɨra ikɨ, eghtɨ an navir averiam deraghtɨ a bar akuegham!” ");
INSERT INTO msy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ezɨ Jonɨn abuir gumazimning uamategha ghuzɨma, ezɨ Iesus maghɨra Jonɨn gun gumaziba ko amizibav gɨa ghaze, “Ia tizimɨn ganasa gumaziba puvatɨzir danganimɨn ghue? Ia amɨnim vair ghurunimɨn ganasa ghuez ti? ");
INSERT INTO msy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ti puvatɨ, ezɨ ia tizimɨn ganasa ghue? Gumazir kurukazir aghuibagh amizim? Ti puvatɨ, gumazir korotiar ivezir ekiaba itiba aghua egha bizir aghuiba men mɨkarzibar itima, me atrivibar dɨpenibar iti. ");
INSERT INTO msy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ezɨ ia tizimɨn ganasa ghue? Ia Godɨn akam inigha izir gumazimɨn ganasa? Are. Kɨ ia mɨgei, Godɨn akam inigha izir gumazir kam Jon, a Godɨn akam inigha izir gumazir igharaziba bar dagh afira. ");
INSERT INTO msy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gumazir kam baghavɨra Godɨn Akɨnafarim mɨgɨa ghaze, ‘Ia oragh. Kɨ uan abuir gumazim amadaghtɨma, a faragh mangɨva nɨ bagh tuavim akɨram.’ ");
INSERT INTO msy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kɨ ia mɨgei, Jon nguazimɨn itir gumaziba bar me gafira, ezɨ tina borimɨn mɨn God Bizibagh Ativamin Dughiamɨn aven iti, a bar Jon gafira.” ");
INSERT INTO msy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Jon gumazamizir avɨriba ruava egha maghɨra dagɨaba isir gumaziba sara rue. Kamaghɨn me Iesusɨn akam baregha, egha fo Godɨn arazim, a bar guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ezɨ Farisiba koma Judan arazibagh fozir gumaziba, me Jonɨn rurim inizir puvatɨ. Kamaghɨn me akɨrim ragha God men akazir tuavir aghuim gasara.) ");
INSERT INTO msy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Egh kɨ gumazamizir datɨrɨghɨn itibar arazibav kɨmsɨva, egha akar isɨn zuir manam mɨkɨmam? Me manmaghɨra gari? ");
INSERT INTO msy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Me boribar mɨn gara biziba amadir danganibar apiav ikia uarir dei, ‘E ia bagha marvibagh ivima, ia ighian aghua. Ezɨ e ongerakar amɨrɨzibagh amima, ia azir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Egha Jon, Gumaziba Ruer Gumazim iza dagheba ko wainɨn dɨpaba apir puvatɨzɨ, ezɨ ia ghaze, ‘Duar kuraba a gapasa.’ ");
INSERT INTO msy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ezɨ Gumazibar Otarim izava dagheba ko wainɨn dɨpaba api. Ezɨ ia ghaze, ‘Ia gan, a gumazir puv daghem ko wainɨn dɨpam apim. Egha a dagɨaba isir gumaziba ko gumazir arazir kurabagh amiba, a men roroabagh amua me ko iti.’ ");
INSERT INTO msy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ezɨ gumazamizir Godɨn fofozim iniziba, me gara fo, Godɨn fofozim a guizbangɨra bizim.” ");
INSERT INTO msy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ezɨ Farisin gumazir mam uabɨ ko damasava Iesus bagha mɨkeme. Ezɨ kamaghɨn an a ko daperagh damasa an dɨpenimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ezɨ amizir arazir kurabagh amua nguibar kamɨn itim orazi, Iesus Farisin dɨpenimɨn ikiava api. Ezɨ amizir kam borer mughuriar aghuim zuim itir alabastan ingarizir mɨsevim inigha izi. ");
INSERT INTO msy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Egha a Iesusɨn dagarimning gɨn tughav ikia azima, ezɨ an teriba Iesusɨn dagarimning giri. Ezɨ a uan dapanir arɨzimɨn an dagarimning adizava an dagarimningɨn torava egha borem an dagarimning ginge. ");
INSERT INTO msy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ezɨ Farisin an diazim bizir kamɨn ganigha uabɨra uabɨ mɨgei, “Gumazir kam a Godɨn akam inigha izir guizbangɨra gumazim a fogh suam, kar amizir manam an suisi, kar amizir arazir kurabagh amim.” ");
INSERT INTO msy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ezɨ Iesus an akam ikaragha ghaze, “Saimon kɨ nɨ mɨkɨmamin bizir mam iti.” Ezɨ Saimon ghaze, “Tisa, na mɨkemegh.” ");
INSERT INTO msy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ezɨ Iesus kamaghɨn a mɨgei, “Gumazir pumuning gumazir mam da dagɨaba pura ada ini egh aning gɨn a da ikarvagham. Ezɨ mav a da 500ɨn dagɨaba ini, ezɨ mav a da 50 plan dagɨaba ini. ");
INSERT INTO msy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ezɨ aning uaghara an dagɨaba ikarvaghan ibura. Ezɨ a aning ikarvaghamin dagɨar kaba gɨn amada. Ezɨ nɨ nɨghnɨgh, aningɨn tina gumazir kam bar a gifuegham?” ");
INSERT INTO msy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ezɨ Saimon an akam ikara, “Kɨ kamaghɨn nɨghnɨsi, gumazir dagɨar avɨriba inigha ua da ikarvaghan iburazim.” Ezɨ Iesus kamaghɨn a mɨgei, “Nɨ deragha mɨgei.” ");
INSERT INTO msy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Egha a ragha amizimɨn garava kamaghɨn Saimonɨn mɨgei, “Nɨ amizir kamɨn gari? Kɨ nɨn dɨpenimɨn izezɨma, nɨ nan dagarimning bagha dɨpatam na ganɨngizir puvatɨ. Ezɨ amizim uan temeribar nan dagarimining ruegha, egha uan dapanir arɨzimɨn anedɨsi. ");
INSERT INTO msy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ezɨ nɨ nan torezir puvatɨ. Ezɨ amizir kam dughiar kɨ aven izezimɨn a nan dagarimningɨn tora mamaghɨra ikia iza datɨrɨkɨn. ");
INSERT INTO msy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ezɨ nɨ borem nan dapanim gingezir puvatɨ. Ezɨ amizir kam a borer mughuriar aghuim inigha nan dagarimning ginge. ");
INSERT INTO msy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A bar na gifonge, kamaghɨn amizɨ, God an arazir kurar avɨriba bar da gɨn amada. Kɨ ia mɨgei, tina God an arazir kurar muziarim gɨn amadaghtɨ, a kamaghɨn na gifongezir arazir muziarim ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ezɨma Iesus amizim mɨgei, “Nɨn arazir kuraba, kɨ da gɨn amada.” ");
INSERT INTO msy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ezɨ gumazir a ko ikiava apiba kamaghɨn oregha, maghɨra uarira uariv gei, “Kar gumazir manam uaghan arazir kuraba gɨn amadi?” ");
INSERT INTO msy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ezɨ Iesus kamaghɨn amizim mɨgei, “Nɨn nɨghnɨzir gavgavim nɨn akura. Eghtɨ nɨ navir amɨrɨzimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Egha bizir kabar gɨn, Iesus, nguibar ekiaba ko nguibar dozibagh arui, egha God Bizibagh Ativamin Dughiamɨn akam kuri. Ezɨma an gumazir 12 pla uaghan an gɨn arui. ");
INSERT INTO msy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ezɨ amizir maba uaghan, me fomɨra Iesus men arɨmariaba ko duar kuraba batoke: Maria, me Makdalan nguibamɨn amizim a garɨsi, Iesus fomɨra a gamizɨma, 7 plan duar kuraba aneteghava azenimɨn ize, ");
INSERT INTO msy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana ko Susana koma amizir avɨrir igharaziba uaghan a ko arui. (Joana, a Kusan amuim, a Herotɨn dɨpenir averiamɨn garir gumazir dapanim.) Amizir kaba uan bizibar Iesus ko an suren gumazibar akurvasi. ");
INSERT INTO msy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ezɨ gumazamizir avɨrim uan nguibaba ategha Iesus bagha izava uari akuvazɨma, an akar isɨn zuir kam mɨgei: ");
INSERT INTO msy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Azenir gumazir mam ghuava raizɨn mɨn garir daghem, wit, an ovɨziba inigha uan azenimɨn da akuri. Egha a da akura zuima, maba tuavim gira ghuzɨma gumaziba da dɨke. Ezɨ kuarazir pɨn itiba izaghira bar da ame. ");
INSERT INTO msy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ezɨma maba dagɨaba itir danganibagh iregha afuangi. Ezɨ dɨpaba nguazimɨn puvatɨ, kamaghɨn amizɨ witɨn kaba ua mɨsɨngigha ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ezɨma witɨn ovɨzir mabanang benir ataghataribar torim gire, egha benir ataghatariba sara aghuima da da ikiagharɨki. ");
INSERT INTO msy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ezɨma mabanang nguazir aghuim giregha, aghua dagher bar avɨriba iti, kamaghɨn da vaghvagha 100pla bar mɨsevegha iti.” An akar isɨn zuir kam me mɨkemegha, a pamtem kamaghɨn me mɨgei, “Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ezɨ Iesusɨn suren gumaziba akar isɨn zuir kamɨn mɨngarim baghava an azara. ");
INSERT INTO msy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ezɨma a mɨgɨa ghaze, “God fofozim ia ganɨngizɨma, ia God Bizibagh Ativamin Dughiamɨn akar mogomeba dagh fo. Ezɨ igharaz darazi kɨ akar isɨn zuibara me mɨgei, eghtɨma gariba me gan fofoghan kogham, ezɨ uaghan oraziba me akar mɨngaribagh foghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Egha Iesus ghua kamaghɨn mɨgei, “Kar akar isɨn zuir kamɨn mɨngarim. Witɨn ovɨzim a Godɨn akam. ");
INSERT INTO msy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ezɨ witɨn ovɨzir tuavim gireziba mati gumazamizir Godɨn akam baraghiziba, me a baraghizɨ ezɨ Satan iza men navir averiabar Godɨn akam batoke, eghtɨma me nɨghnɨzir gavgavim God damuan koghtɨ God ua me inian kogham. ");
INSERT INTO msy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ezɨma dagɨaba itir danganibagh irezir witɨn ovɨziba mati gumazamizir akam baregha bar akongeziba, egha me biba itir puvatɨ. Me dughiar otevimɨn nɨghnɨzir gavgavim Godɨn iti, ezɨma osɨmtɨzibar dughiam me God ataki. ");
INSERT INTO msy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ezɨma witɨn ovɨzir benir ataghataribar tongɨn ireziba mati gumazamizir akam baraghizibar mɨn ti. Egh me deragha tuavimɨn zuima nivafɨzibar agoroger osɨmtɨziba, ko dagɨar nɨghnɨzir osɨmtɨziba, koma nguazir kamɨn bizir ganganir agorogeba, me isima me dar aven ikia egha mɨsevir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ezɨma witɨn ovɨzir nguazir aghuim gireziba mati, gumazamizir akar aghuim baraghiziba, me a inigha uan navir averiabagh atɨgha adar suira egha gavgavigha ikia, men dagher aghuiba otifi.” ");
INSERT INTO msy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Gumazitam lam gaborogha mɨnemɨn aven a modogha egha a isa dakozimɨn apengan anefazir puvatɨ. Egh an a isɨva dakozim gisɨrarama anefagham, eghtɨma tina aven izɨva angazangarimɨn ganam. ");
INSERT INTO msy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kamaghɨra mogomer biziba da gɨn azenan otivigham. Eghtɨ bizir amigha aveziba da uaghan gɨn azenan otivigham. ");
INSERT INTO msy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ezɨ kamaghɨn amizɨma ia deraghvɨra akar kam baragh. Gumazitam Godɨn akabagh foghtɨ, God uan akabar fofozir igharaziba a danɨngam, eghtɨ a Godɨn akar avɨribagh fogham. Eghtɨ Godɨn akabagh foghan aghuazir gumazim, an fofozir muziarim God a dama inigham.” ");
INSERT INTO msy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ezɨ Iesusɨn amebam ko doziba an ganasa izi. Ezɨ gumazamiziba bar anekufa, kamaghɨn amizɨ, me an boroghɨra mangan ibura. ");
INSERT INTO msy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ezɨ mav Iesus mɨgɨa ghaze, “Nɨn amebam ko doziba muna azenan tuivighav ikia, egha nɨn ganasa.” ");
INSERT INTO msy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ezɨma an an akam ikara, “Tina Godɨn akam baragha an gɨn zui, me nan amebam ko doziba.” ");
INSERT INTO msy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ezɨ dughiar mam Iesus uan suren gumazibav gɨa ghaze, “Aria e dɨpamɨn vongɨn mangam.” Eghava me botɨn ghuavanega egha vongɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Egha me ghuava, Iesus pariam an azima an akui. Ezɨma amɨnir ekiam amozim sara dɨpamɨn oto, ezɨ dɨpam men bot bar a gizɨfa. Kamaghɨn me osɨmtɨzir ekiamɨn aven iti. ");
INSERT INTO msy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Egha suren gumaziba ghuava a gaghuragha a mɨgɨa ghaze, “Gumazir Ekiam, nɨ dɨkafigh! E ovengam!” Ezɨ a dɨkavighava amɨnim ko dɨpar puvɨra ingarim akar gavgavimɨn aning mɨgei. Ezɨma amɨnim ko dɨpam aremegha amɨraghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ezɨma a uan suren gumaziba kamaghɨn men azara, “Ian nɨghnɨzir gavgavim managh iti?” Ezɨ me atiatia, nɨghnɨzir avɨribagh amuava, uarira uarir azangsɨsi, “Gumazir kam, a tina? A mɨgeima amɨnim ko dɨpam, an akam barasi.” ");
INSERT INTO msy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Egha Iesus uan suren gumaziba ko botɨn ghuava Gerasan Distrighɨn otifi, Galilin dɨpamɨn vongɨn. ");
INSERT INTO msy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Egha Iesus bot ategha azenan izima, nguibar ekiar kamɨn itir gumazir duar kuraba apazazim a bato. A fomɨra iniba itir puvatɨghava dɨpenibar aven itir puvatɨ, a gumazir ovengezibar dagɨar mozir toribar aven iti. ");
INSERT INTO msy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Egha duar kurar kam dughiar avɨribar an suigha anekurima a daghiri. Egha uaghan an dafariba ko sueba me senbar da ike, egha an garir gumaziba an boroghɨra ikiava an gari, ezɨ duar kurar kam a gamima a uan senba aghorava ara ghua gumaziba itir puvatɨzɨ naghɨn iti. Ezɨ Iesus duar kuram batogha ghaze, nɨ gumazim ategh azenan izɨ. Ezɨ a Iesusɨn apigha, arava Iesusɨn dagaribar apengan irɨgha pamtem dɨa mɨgei, “Nɨ tizim na damuasa, Iesus, Godɨn bar pɨn itimɨn otarim? Ezɨ kɨ nɨn azangsɨsi nɨ arazir kuratam na damuam markɨ!” ");
INSERT INTO msy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ezɨ Iesus an azara, “Nɨn ziam tina?” Duar kurar avɨriba an aven ghuz. Ezɨ a kamaghɨn mɨgei, “Avɨriba.” ");
INSERT INTO msy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ezɨma duar kuraba Iesus kamaghɨn a gaghoravɨra iti, “Nɨ e batoegh e amadaghtɨma e torir mɨngariba puvatɨzir kamɨn mangan markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Dughiar kam dar bɨzir ekiar maba mɨghsɨar mɨriamɨn roghɨra ikiava api. Ezɨma duar kuraba Iesus gakaghora ghaze, “Nɨ en amamangatɨghtɨma e mangɨ dar munabar aven mangeka.” Ezɨma a me ataghizɨma me zui. ");
INSERT INTO msy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ezɨ duar kuraba gumazim ateghava azenan izeghava dabar aven ghue. Ezɨma dar bɨzir kam ara ghua davarir kuram giraghuegha dɨpam amegha ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ezɨma dabar garir gumaziba garima bizir kaba otivizɨma, me ara ghuava nguibar ekiamɨn bizir kabar gun mɨgeima nguibar azenan roghɨra itiba sarama orasi. ");
INSERT INTO msy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ezɨma gumazamiziba ganasa izi, bizir tizimrama oto? Egha me Iesus bagha iza, egha garima, gumazir duar kuraba ategha azenan izezim, a Iesusɨn dagarimɨn mɨn aperaghav iti. A korotiaba aghuizɨma an nɨghnɨzimra uam an izes. Kamaghɨn me atiatingi. ");
INSERT INTO msy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ezɨ ikia bizir kamɨn ganizir darasi gumaziba ko amizibagh eghari, me eghara ghaze, Iesus duar kuraba apazazir gumazim gamizɨ a ua dera. ");
INSERT INTO msy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ezɨ gumazamizir Gerasan Distrighɨn itiba puvɨra atiatiava, egha Iesusɨn azangsɨsi, “Nɨ e ategh danganir igharazimɨn mangɨ.” Ezɨ a botɨn ghuavanabogha uamategha zui. ");
INSERT INTO msy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ezɨma duar kuraba ataghizir gumazir kam Iesusɨn azangsɨgha uaghan an gɨn mangasa, ezɨ Iesus anemadagha, a mɨgɨa ghaze, ");
INSERT INTO msy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nɨ uamategh uan nguibamɨn mangɨ, egh God nɨ gamizir biziba bar me mɨkɨm.” Ezɨ gumazim uamategha ghua egha nguibam garuava Iesus a gamizir biziba bar dar gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Egha Iesus uamategha Galilin dɨpamɨn vongɨn izezɨma gumazamiziba a izɨ me bativasa me a bagha oragha a mɨzua iti. ");
INSERT INTO msy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ezɨma gumazir mam, an ziam Jairus, a God ko mɨgeir dɨpenimɨn gumazir dapanim. An guivir vamɨra an azenir 12 plan boroghɨra ghugha, aremeghasava ami. Kamaghɨn a iza Iesusɨn dagaribar apengan irɨ. Egha uan dɨpenimɨn mangasa Iesus gakaghori. Ezɨ Iesus ghuavɨra itima maburan avɨrim bar anekuvagha anedughadusi. ");
INSERT INTO msy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ezɨma amizir 12 plan azenimɨn ghuzim batir arɨmariam itir mam, gumazitam a damightɨma a deraghan kogham. Ezɨ a men tongɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Egha a Iesusɨn gɨn izava an korotiar avɨzimɨn suira, egha zuamɨra an ghuzir arɨmariam dutugha ghu. ");
INSERT INTO msy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ezɨ Iesus azara, “Tina nan suira?” Ezɨ me bar uarir tiragha Pita ghaze, “Gumazir Ekiam, gumazamiziba bar nɨ akuvagha nɨ adughadusi.” ");
INSERT INTO msy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ezɨ Iesus ghaze, “Kɨ kamaghɨn fo, gumazim nan suirazɨma gavgavim na ategha azenan ghu.” ");
INSERT INTO msy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ezɨma amizim uabɨra uabɨn gara fo, a modoghan kogham. Eghava atiatim sara iza Iesusɨn dagaribar apengan irɨ. Egha a gumaziba ko amizibar damazibar mɨgɨa ghaze, nan arɨmariam gɨvaghasa, kɨ Iesusɨn korotiamɨn suira, ezɨ nan arɨmariam zuamɨra gɨfa. ");
INSERT INTO msy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ezɨ Iesus a mɨgɨa ghaze, “Nan guivim, nɨ nɨghnɨzir gavgavim nɨ gamizɨma nɨ dera. Navir amɨrɨzimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Egha Iesus mɨgɨavɨra itima, gumazir mam God ko mɨgeir dɨpenimɨn garir gumazir dapanim, Jairusɨn dɨpenimɨn ikegha, Jairus bagha izi. Egha a Jairus mɨgei, “Nɨn guivim areme. Eghtɨ nɨ tisa ua ingangarim a danɨngan markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ezɨ Iesus kamaghɨn oregha, Jairus mɨgɨa ghaze, “Nɨ atiatingan markɨ. Pura nɨghnɨzir gavgavim ikɨ eghtɨma nɨn guivim ua deragham.” ");
INSERT INTO msy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eghava a Jairusɨn dɨpenimɨn otogha, egha a ua tavɨn amamangatɨghtɨma an an gɨn aven mangan an aghua, kerara a ko aven mangam, Pita, Jon, ko Jems koma guivimɨn amebam koma afeziam. ");
INSERT INTO msy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dughiar kam gumazamiziba bar uan evaribav mɨsogha azia iti. Ezɨ Iesus me mɨgɨa ghaze, “Azir akam atakigh. Guivim aremezɨ puvatɨ. An akui.” ");
INSERT INTO msy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Me fo, guivim aremezɨ, kamaghɨn me an ingaravati. ");
INSERT INTO msy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ezɨ Iesus guivimɨn dafarimɨn suiragha egha mɨgɨa ghaze, “Nan borim, nɨ dɨkafigh!” ");
INSERT INTO msy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ezɨma an duam uamategha izezɨma a zuamɨra dɨkavigha tu. Ezɨma Iesus me mɨgɨa ghaze, “Ia daghetam a danɨngigh.” ");
INSERT INTO msy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ezɨ an amebam koma afeziam bar aguaghfa. Ezɨma a kamaghɨn mɨgɨa aning abɨra, bizir otozir kam gua gumazitam mɨkɨman markɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Egha Iesus 12 plan suren gumazibar diaghava me akuvaghava, egha gavgavim koma gavgavir duar kuraba batogham koma arɨmariaba agɨvamim sara me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Egha me amadagha ghaze, ia God Bizibagh Ativamin Dughiamɨn akam kunigh, egh gumazibar arɨmariabar akɨrtɨma me ua deragham. ");
INSERT INTO msy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Egha a me mɨgei, “Ia mangɨsɨva bizitam inian markɨ, mɨtariba, dagheba, dagɨaba, koma siotɨn ia gɨn daghuamin tam inian markɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eghtɨ dɨpenir ia aven zuir manam, anarɨra ikɨ, mangɨva nguibar kam ategh mangɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eghtɨma gumaziba ia gɨfueghan koghtɨma, dughiar ia men nguibam ataghraghamim, ia uan dagaribar mɨneziba apɨsigh, eghtɨma me fogh suam, arazir me amizir kam, a derazir pu.” ");
INSERT INTO msy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ezɨma Iesusɨn suren gumaziba nguibabar ghuava, akar aghuim akurava egha arɨmariar gumazibar kɨrima me ghuamazi. ");
INSERT INTO msy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","8","Ezɨ Herot, gavmanɨn dapanim, a bizir Iesus amiba baraghizɨma da ghuavɨra iti. A fo, marazi ghaze, Jon aremegha ua dɨkafi, ezɨ marazi ghaze, Elaija oto, maba ghaze, Godɨn akam inigha izir gumazir mam fomɨra ikegha aremegha ua dɨkafi. Kamaghɨn amizɨma Herot bar nɨghnɨzir avɨribagh ami. ");
INSERT INTO msy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Egha Herot kamaghɨn mɨgei, “Kɨ Jonɨn fɨrim atu. Tina, bizir kabagh amima me dar gun mɨgei?” Egha a Iesusɨn ganasa. ");
INSERT INTO msy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ezɨma Iesusɨn aposelba uamategha izeghava, bizir me amizibar gun a mɨgei. Ezɨma a me inigha me uarira nguibar mam an ziam Betsaidan ghue. ");
INSERT INTO msy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ezɨ gumazir bɨzir avɨrim a gɨfoghava egha an gɨn zui. Ezɨ Iesus me gɨfueghava me isava, God Bizibagh Ativamin Dughiamɨn gun me mɨgɨava, eghava gumaziba ko amizibar arɨmariabar akɨri. ");
INSERT INTO msy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bar guaratɨzimɨn Iesusɨn 12 plan aposelba a bagha izeghava a mɨgei, “E gumaziba itir puvatɨzir danganimɨn iti. Egh, nɨ gumazamiziba me amadaghtɨ me mangɨ danganir kamɨn itir nguibaba ko nguibar roghɨra itibar mangɨva, egh dagheba koma dakuamin danganiba buri.” ");
INSERT INTO msy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ezɨ Iesus men akam ikara, “Ia uari daghetaba me danɨngigh.” Ezɨma me kamaghɨn mɨgei, “E bar bretɨn rubuzir 5 pla koma osirir pumuningra iti. Egh e ua mangɨ gumazir avɨrir kam bagh dagher tabagh ivezeghan koghtɨ, dagheba bar otevegham.” ");
INSERT INTO msy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Dughiar kam gumazibar dɨbobonim, 5,000 boroghɨn ghu.) Ezɨma Iesus kamaghɨn uan suren gumazibav gei, “Ia me mɨkɨmtɨma me 5 pla ten, 5 pla tenɨn, okuruabar dapighɨrɨ.” ");
INSERT INTO msy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Suren gumaziba kamaghɨram amizɨma, gumazamiziba bar apia. ");
INSERT INTO msy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ezɨ Iesus bretɨn rubuzir 5 pla koma osirir pumuning inigha kogha overiamɨn garava Afeziar Ekiam mɨnabagha, egha bretba ko osirimning apɨrighava gumaziba ko amizibar anɨngasa uan suren gumazibagh anɨngizɨ me me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ezɨma gumazamizir kaba bar amegha, naviba bar izɨfa. Ezɨma Iesusɨn suren gumaziba, dagher nar me ataghiziba, me da inigha 12 plan akɨrabagh aghuizɨma da bar izefe. ");
INSERT INTO msy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Dughiar mamɨn Iesus uabɨra Afeziam ko mɨgeima, an suren gumaziba a ko itima, ezɨma a men azara, “Gumazamiziba tina na garɨsi?” ");
INSERT INTO msy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ezɨma me an akam ikara, “Marazi ghaze, nɨ Jon Gumaziba Ruer Gumazim, ezɨ marazi ghaze, nɨ Elaija, ezɨma marazi ghaze, Godɨn akam inigha izir gumazir fomɨra itir mam aremegha ua dɨkafi.” ");
INSERT INTO msy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ezɨma Iesus azara, “Ezɨ ia? Ia uari ghaze kɨ tina?” Ezɨ Pita an akam ikara, “Nɨ Godɨn Krais, God Uam E Iniasa Mɨsevezir Gumazim.” ");
INSERT INTO msy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ezɨ Iesus mɨgɨrɨgɨar gavgavim suren gumaziba ganɨga ghaze, ia nan gun tav mɨkɨman markɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Egha kamaghɨn mɨgei, “Gumazibar Otarim bar mɨzazir ekiaba koma osɨmtɨziba iniam. Eghtɨma gumazir aruaba, koma ofa gamir gumazir ekiaba, koma Judan arazibagh fozir gumaziba, me an aghuaghɨva a mɨsueghtɨma an aremegham. Egh dughiar mɨkezimɨn a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Egha a bar moghɨra me mɨgei, “Gumazitam nan gɨn izɨsɨ, a ifongezir biziba gɨn amadagh uan temer ighuvim zurara a gisaghpugh nan gɨn izɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Gumazir manam uan ikɨrɨmɨrim suiraghsɨ nɨghnɨghtɨ, an ikɨrɨmɨrim gɨvagham. Eghtɨ gumazir manam na bagh uan ikɨrɨmɨrim ateghɨva, uan ikɨrɨmɨrim iniam. ");
INSERT INTO msy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gumazitam nguazimɨn itir biziba bar da iniva, egh a gɨn oveghtɨ, bizir kaba manmaghɨn an akuragham? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tina nan ziam ko nan akar aghuimɨn gun mɨkɨman aghumsɨghtɨ gɨn Gumazibar Otarim uan afeziamɨn boroghɨn ikeghɨva an Godɨn damazimɨn zuezir enselba koma Godɨn angazangarim sara izighirɨva, uaghan men aghumsɨgham. ");
INSERT INTO msy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kɨ guizbangɨra ia mɨgei, ia kagh tuivighav itir darasi, ian tarazi oveghan kogham. Ia ikɨvɨra ikɨ gantɨma, God Bizibagh Ativamin Dughiam otogham.” ");
INSERT INTO msy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ezɨ Iesus bizir kabav kemezɨ, 8 plan dughiaba gɨvazɨma, a gɨn Pita, Jon, koma Jems inigha me a ko ghua, God ko mɨkɨmasa mɨghsɨar mamɨn pɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ezɨma a God ko mɨgeima, an guamɨn ganganim ragha igharagha gari. Ezɨma an korotiaba bar ghurghurighava egha onɨmarimɨn mɨn taghtasi. ");
INSERT INTO msy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Gumazir pumuning, Moses koma Elaija, ");
INSERT INTO msy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","aning Afeziar Ekiamɨn angazangarimɨn aven ikiava, egha Iesus ko uariv gei. Me Iesus nguazir kam ataghragham koma bizir a Jerusalemɨn damuamin bizibav gei. ");
INSERT INTO msy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita uan namakamning ko dakuasava ami, egha me oseghava, egha Iesusɨn angazangarir gavgavimɨn ganigha egha uaghan gumazir pumuningɨn gari, aning a ko tughav iti. ");
INSERT INTO msy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ezɨma gumazimning ane ataghrazima Pita kamaghɨn Iesus mɨgei, “Tisa, bar deragha e kagh iti! E averpenir pumuning ko mɨkezimɨn ingaram. Nɨ bagh tam, Moses bagh tam, egh Elaija bagh tam.” (Pita akar kam mɨgɨava a uabɨ mɨgɨrɨgɨar a mɨkemezir kam gɨfozir puvatɨ.) ");
INSERT INTO msy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","A mɨgɨavɨra itima, ghuariar mam otogha me avara, ezɨma me ghuariamɨn aven ghuava bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ezɨ tiarir mam ghuariamɨm tongɨn otogha kamaghɨn mɨgɨa ghaze, “Kar nan Otarim, kɨ a ginaba. Ia anarɨram oragh!” ");
INSERT INTO msy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ezɨma tiarir kam mɨkemegha gɨvazɨma me Iesusɨn garima a uabɨra iti. Ezɨma Iesusɨn suren gumaziba bizir me ganizim me an gun gumazitam mɨkemezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Egha me amɨmɨzaraghɨn mɨghsɨam ategha izaghirima gumazamizir avɨrim a bato. ");
INSERT INTO msy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ezɨ gumazir mam men torimɨn ikia dei, “Tisa, kɨ nɨ gakaghori, nan otarir bar vamɨra iti, kamaghɨn nɨ an ganigh. ");
INSERT INTO msy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Duar kuram an aven ikiava a gamima a zuamɨra ara dei. Egha anekurima a nguazim gira puv nɨsi. Ezɨma pupuviba an akamɨn otifi. Duar kurar kam dughiar mabar an ikiava bar pazava a gamuava, egha anetaghrazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kɨ a batoghasa nɨn suren gumazibagh akaghori. Ezɨ me a damuan ibura.” ");
INSERT INTO msy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ezɨ Iesus kamaghɨn ikara, “Oio, kɨ bar amɨra, ia dughiar kamɨn itir gumazamiziba, ian nɨghnɨzir gavgaviba puvatɨ, ian araziba koma nɨghnɨziba bar derazir puvatɨ. Kɨ dughiabar manmaghɨn ia ko ikiava egha ian osɨmtɨziba ateri? Nɨ uan otarim inigh kagh izɨ.” ");
INSERT INTO msy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ezɨma otarim izavɨra itima, duar kuram an ekunizɨma a nguazim girɨghava uam aguava egha puv nɨsi. Ezɨma Iesus duar kuram a batoghezɨma a borim ataghizɨma a dera. Ezɨ Iesus a isava uam an afeziam ganɨngi. ");
INSERT INTO msy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ezɨma gumazamiziba bar Godɨn gavgavimɨn ganigha egha dɨgavir kuram gami. Me bar puv Iesus amizir bizibagh nɨghnɨzima, a uan suren gumazibav gei, ");
INSERT INTO msy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ia deraghvɨra na baraghtɨma, kɨ bizitam ia mɨkɨmasa. Me Gumazibar Otarim isɨva gumazir kurabar dafarim darɨgham.” ");
INSERT INTO msy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ezɨma me mɨgɨrɨgɨar kamɨn mɨngarim gɨfozir puvatɨ. A men modo, ezɨ kamaghɨn amizɨma me a gɨfozir puvatɨ. Egha an azangsɨghan atiatingi. ");
INSERT INTO msy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ezɨma Iesusɨn suren gumaziba uarira uari adoghadogha egha ghaze, tina men dapanimɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Me mɨgeima, Iesus men nɨghnɨzibagh fo, egha a borim inizɨma an an mɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Egha a kamaghɨn me mɨgei, “Gumazitam na gɨnɨghnɨgh egh borir dozir kamagh garitam inigh an akuragham, kamaghɨn a na inigha nan akurvasi. Egha tina nan akurvasi, a nan Afeziar na amadazimɨn akurvasi. Kamaghɨn amizɨ, tina ian tongɨn ziam puvatɨ, a ziar ekiam iniam.” ");
INSERT INTO msy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ezɨ Jon Iesus mɨgei, “Tisa, e garima gumazir mam duar kurabar nɨn ziamɨn da batosi. E fo, a en mav puvatɨ, ezɨma e an anogorosi.” ");
INSERT INTO msy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ezɨ Iesus kamaghɨn mɨgei, “Tina ian apanim gamir puvatɨ, a iananav. Eghtɨ, ia an anogoroghan markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ezɨma God Iesus inigh uan Nguibamɨn ghuavanangamin dughiam roghɨra izezɨma, Iesus Jerusalemɨn mangasa nɨghnɨzim gamigha iti. ");
INSERT INTO msy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Egha uan mɨgɨrɨgɨar gumazir maba amangizɨma me akam inigha faragha ghue. Me Samarian nguibar mamɨn a bagha bizibar akɨrasa ghue. ");
INSERT INTO msy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ezɨma gumazamizir nguibar kamɨn itiba fo, Iesus Jerusalemɨn zui, kamaghɨn amizɨma me Iesus inian aghua. ");
INSERT INTO msy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ezɨma suren gumazimning, Jems koma Jon bizir kabar ganigha, egha an azara, “Ekiam, nɨ ifueghtɨma e Godɨn Nguibamɨn itir avim bagh diaghtɨma a izighrɨva gumazibar isigham.” ");
INSERT INTO msy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ezɨma Iesus raghava aningɨn atari. ");
INSERT INTO msy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Egha me nguibar igharazimɨn ghue. ");
INSERT INTO msy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ezɨ Iesus uan suren gumaziba ko tuavimɨn zuima, gumazir mam Iesus mɨgei, “Nguibar manam nɨ an zui, kɨ nɨn gɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ezɨ Iesus a mɨgɨa ghaze, “Afiar atiaba nguazir toribar itima, kuaraziba mɨkonibar iti, ezɨ Gumazibar Otarim danganir dakuamiba puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Egha Iesus gumazir igharazim mɨgei, “Nan gɨn izɨ.” Ezɨma gumazim an akam ikara, “Ekiam, nɨ faragh na amamangatɨghtɨma, kɨ mangɨ uan afeziam mozim dafaka.” ");
INSERT INTO msy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ezɨ Iesus a mɨgei, “Markɨ. Gumazir ovengeziba uari uan gumazir kuabar afɨ. Egh nɨ mangɨva God Bizibagh Ativamin Dughiamɨn akam akunam.” ");
INSERT INTO msy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ezɨma ua gumazir mam Iesus mɨgei, “Ekiam, kɨ nɨn gɨn mangam. Egh nɨ faragh nan amamangatɨghtɨma kɨ mangɨva uan adarazir ganika.” ");
INSERT INTO msy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ezɨ Iesus a ikara, “Tav itazim kuazagh egh a gɨn ganan koghɨva, a God Bizibagh Ativamin Dughiamɨn aven ingaran kogham.” ");
INSERT INTO msy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Egha bizir kabar gɨn Ekiam 72 plan gumazir igharaziba mɨsevegha egha pumuning pumuning faragh nguibar ekiaba koma danganir a mangasa nɨghnɨzibar me amadi. ");
INSERT INTO msy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Egha a kamaghɨn me mɨgei, “Dagher bar avɨrim anigha gɨvagha azenimɨn iti. Ezɨ ingangarir gumazir da iniamin avɨriba puvatɨ. Kamaghɨn, ia azenir kamɨn ghuavimɨn azangsɨghtɨ, a ingangarir gumaziba amangtɨma, me an azenimɨn mangɨ, dagheba iniam. ");
INSERT INTO msy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ia mangɨ! Kɨ sipsipɨn nguziba afiar atiabar torimɨn iti moghɨn ia amadazɨ ia zui. ");
INSERT INTO msy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Eghɨva dagɨaba azuir mɨtarim ko beghiam ko dagarir asuaba inian markɨ. Eghtɨ gumazitam tuavimɨn ia batoghɨva dughiam ia danɨngtɨ, ia ikaraghan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Eghɨva ia dɨpenitamɨn aven mangɨ egh faragh kamaghɨn mɨkɨm suam, navir amɨrɨzim ia ko iti. ");
INSERT INTO msy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eghtɨ gumazir navir amɨrɨzim kagh ikɨtɨ, ia navir amɨrɨzim an ikɨ. puvatɨghtɨma ian navir amɨrɨzim ua ia bagh izegham. ");
INSERT INTO msy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","E fo, ingangarir gumazim uan ivezim isi, kamaghɨn ia dɨpenir kamɨn aven ikɨ, dagheba ko dɨpar tizir me ia ganɨdiba, ia dar amɨ. Eghɨva dɨpenir mamɨn ikegh mamɨn mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Eghɨva ia nguibar ekiamɨn aven mangɨghtɨma me ia inigh, egh me tizim ia ganɨngi, ia puram anemɨ. ");
INSERT INTO msy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Egh ia arɨmariar itibar amightɨma da deraghtɨma, kamaghɨn me mɨkemegh, God Bizibagh Ativamin Dughiam roghɨra ize. ");
INSERT INTO msy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Egh ia nguibar ekiatamɨn aven mangɨtɨma, me ia inighan koghtɨma, tuavir dozibar aven mangɨ egh mɨkɨm suam, ‘Ian nguibar ekiamɨn nguaziba en dagaribar poghezɨ, e a da dɨsi, eghtɨ ia kamaghɨn ganigh fogh suam, ia amizir arazir kam, a derazir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ezɨ kɨ ia mɨgei, Godɨn Kotɨn Dughiamɨn, osɨmtɨzir nguibar kam iniamim, an osɨmtɨzir Sodomɨn nguibam iniamim gafiragham.” ");
INSERT INTO msy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Egha Iesus ghua mɨgɨa uan 72 plan gumazibav gei, “Ia Korasinɨn nguibamɨn itir gumazamiziba, iavzika! Ia kuram iniam. Ia Betsaidan nguibamɨn itir adarazi, Iavzika! Ia bar ikuvigham. Gumazitam Tairɨn nguibam ko Saidonɨn nguibamɨn ghua, mirakelɨn kɨ amiziba men tongɨn dagh amighai, Tair ko Saidonɨn itir darazi ti fomɨra navibagh iragha, egha azir adiariba aghuigha, averenim gapiava agura, egha uan arazir kamɨn uari akakagha ghaze, me uan arazir kuraba ataki. ");
INSERT INTO msy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Godɨn Kotɨn Dughiamɨn, osɨmtɨzir ia iniamim, an osɨmtɨzir Tair ko Saidon iniamim gafiragham. ");
INSERT INTO msy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ezɨ ia Kaperneamɨn nguibamɨn itir darazi, ia ghaze, ia uari fegh Godɨn Nguibamɨn ikiam, a? Bar puvatɨ, God ia akunightɨ ia Helɨn avimɨn magɨram. ");
INSERT INTO msy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Tina ia barasi uaghan na barasi, tina ia barazir puvatɨ a uaghan na barazir puvatɨ. Egha tina na barazir puvatɨ, a nan Afeziar na amadazim uaghan a barazir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ezɨma 72 plan gumaziba ua iza bar akuegha kamaghɨn mɨgei, “Ekiam, e nɨn ziam dɨborima duar kuraba en akabar mɨrara zui.” ");
INSERT INTO msy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ezɨ a me ikara, “Kɨ Satanɨn garima a ira onɨmarimɨn mɨn Godɨn nguibamɨn tagha gɨfa. ");
INSERT INTO msy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ezɨma kɨ gavgavim ia ganigha gɨfa eghtɨ ia kuruziba ko tuighiakaba gisɨn daruva da dɨkɨva, egh uan apanibar gavgavim a gɨvagham. Eghtɨ me bizir kuratam ia damuan iburagham. ");
INSERT INTO msy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eghtɨ duar kuraba ian akam mɨrara ghuzir bizim gakongan markɨ. Ian ziaba Godɨn Nguibamɨn aven osirizir bizim baghɨva akong.” ");
INSERT INTO msy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ezɨ dughiar kamra, Godɨn Duam Iesus gamima a bar akongeghava mɨgei, “Afeziam, nɨ nguazim ko overiam gativazir Ekiam! Nɨ fofozim ko nɨghnɨzir aghuiba itir gumaziba bizir kaba men modo, egha boribar mɨn itir gumazibar aka. Kamaghɨn kɨ nɨ mɨnaba. Guizbangɨra Afeziam, nɨ uan ifongiamɨn kamaghɨn ami.” ");
INSERT INTO msy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Egha Iesus ua kamagh mɨgei, “Nan Afeziam biziba bar da isa nan dafarim gatɨ. Ezɨ gumazitam Otarim gɨfozir puvatɨ. Afeziam uabɨra a gɨfo. Egha tav Afeziam gɨfozir puvatɨ. Otarim uabɨra, koma gumazir Otarim ifuegha Afeziam isava men akaziba, merara Afeziam gɨfo.” ");
INSERT INTO msy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Egha a ragha uan suren gumazibar gara kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, fomɨra Godɨn akam inigha izir gumazir avɨriba ko gumazir aghuir avɨriba, me ia datɨrɨghɨn garir bizibar ganamin ifongiar bar ekiam ikia, me dar ganizir puvatɨ. Egha ia datɨrɨghɨn orazir akar kaba, me da baraghan ifongiar bar ekiam ikia, me tam baraghizir puvatɨ. Ezɨ ia, ian damaziba dar gari, kamaghɨn ia bar akongegh!” ");
INSERT INTO msy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ezɨ dughiar mam Judan arazibagh fozir gumazir mam dɨkavighava Iesus gifarasa purama an azara, “Tisa, kɨ manmaghɨn damighɨva zurazurara itir ikɨrɨmɨrir aghuarim iniam?” ");
INSERT INTO msy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ezɨ Iesus a ikara, “Akar manam Moses Osirizir Arazimɨn akamɨn aven iti? Nɨ manmaghɨn an gari?” ");
INSERT INTO msy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ezɨ an a ghaze, “Nɨ uan God, nɨn Ekiam, bar a gifongegh, egh nɨ uan navir averiam ko uan duam ko uaghan bar uan gavgavim ko uaghan bar uan nɨghnɨzimɨn, uan God gifongegh. Egh uaghan, nɨ uabɨra uabɨ gifongezɨ moghɨn, gumazamizir igharazibagh ifongegh.” ");
INSERT INTO msy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ezɨ Iesus an akam ikara, “Nɨ bar deragha mɨgei. Nɨ mamaghɨra damigh, zurara itir ikɨrɨmɨrir aghuarim iniam.” ");
INSERT INTO msy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ezɨ a gumazibar damazimɨn deraghasa, kamaghɨn a Iesusɨn azara, “Ezɨ tina nan namakaba?” ");
INSERT INTO msy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ezɨma Iesus an akam ikaragha ghaze, “Gumazim Jerusalem ateghava Jerikon uaghira, egha gumazir kuraba batozɨma, me an korotiaba sueghava, puvɨram a mɨsueghava are, egha anetaghizɨma a mɨkɨrɨgha irɨghav iti. ");
INSERT INTO msy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ezɨma ofa gamir gumazim tuavir kamra uaghira egha an gara a gitagha zui. ");
INSERT INTO msy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kamaghɨra Livain gumazim uaghan iza danganir kamnaghra an gara a gitagha zui. ");
INSERT INTO msy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ezɨma Samarian gumazir mam, iza danganir gumazir kam itimra izava, an apighava bar an apangkufi. ");
INSERT INTO msy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Egha an a bagha ghua wain ko borem an duaba ruegha egha da nomke. Egha a gumazim isa uan donki gisɨn anefagha, egha a inigha ghua daguir dɨpenir mamɨn aven ghugha egha deravɨram a gami. ");
INSERT INTO msy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Egha amɨmɨzaraghan a dagɨar pumuning dɨpenir ghuavim ganigha ghaze, ‘Deragh an gan eghtɨ dughiar kɨ uamategham, kɨ izɨ bizir tizir nɨ uam a gamiziba kɨ da ikaragham.’ ");
INSERT INTO msy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ezɨ nɨ manmaghɨn nɨghnɨsi, gumazir pumuning ko mɨkezir kabar manam gumazir kuraba mɨsoghezir gumazimɨn namakam?” ");
INSERT INTO msy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ezɨ Judan arazibagh fozir gumazim a ikara, “Gumazir an apangkuvizim.” Ezɨ Iesus a mɨgɨa ghaze, “Nɨ mangɨva kamaghɨra damu.” ");
INSERT INTO msy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Eghava Iesus uan suren gumaziba ko tuavimɨn izavɨra ikiava egha nguibamɨn oto. Ezɨ amizir mam, an ziam Marta an diazɨma an an dɨpenimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ezɨ an afumimɨn ziam Maria. A Iesusɨn dagarimɨn boroghɨra aperaghav ikiava a barazima a mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ezɨ Marta ingangarir avɨrim an nɨghnɨzimɨn izi, ezɨ an osɨmtɨzim sara dagher me damamibagh ami. Egha a Iesus bagha iza egha an azara, “Ekiam, nan afumim na ataghizɨma kɨ uabɨra ingangaribagh ami, ezɨ nɨ na gɨnɨghnɨsi, o? A mɨkemeghtɨma a nan akuragh!” ");
INSERT INTO msy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ezɨ Ekiam a ikara, “Marta, Marta, nɨ bizir avɨribagh nɨghnɨgha egha da bagha muriam nɨ dɨghori. ");
INSERT INTO msy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nɨ bizir vamɨra bagh nɨghnɨgh. Maria a bizir aghuimra mɨsefe. Ezɨ bizir kam gumazitam a dama a inigham kogham.” ");
INSERT INTO msy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Dughiar mam Iesus danganir mamɨn ikia God ko mɨgei. Egha a gɨvazɨma, an suren gumazir mam a mɨgei, “Ekiam, nɨ God ko mɨgeir arazibar en sure damu, mati Jon uan suren gumazibar sure gamizɨ moghɨn.” ");
INSERT INTO msy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Egha Iesus kamaghɨn me mɨgei, “Nɨ God ko mɨkɨmɨva, kamaghɨn mɨkɨm: ‘En Afeziam, nɨn ziam bar zue, ezɨ arazir kuraba an saghon iti. Eghtɨ Dughiar Nɨ Bizibagh Ativamim, a izɨ. ");
INSERT INTO msy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nɨ dughiaba meng en dagheba vaghvagh e danɨng, dughiar zurara apir dagheba e danɨngigh. ");
INSERT INTO msy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ezɨ tina arazir kurabar e gami, e men arazir kuraba gɨn amadi. Kamaghɨn amizɨ, nɨ en arazir kuraba gɨn amadagh. Egh e ateghtɨ, e osɨmtɨzibar aven ikɨtɨ bizitam en navim bɨraghtɨma, e arazir kuratam damighan kogham.’” ");
INSERT INTO msy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Ezɨma Iesus kamaghɨn uan suren gumazibav gei, “Ian tongɨn gumazitam namakatam ikɨva, egha dɨmagarir arɨzimɨn a bagh mangɨva, egh kamaghɨn a mɨkɨmam, ‘Namakam, nɨ daghetaba nan akuragh. Nan akar gumazim tuavimɨn iza na batozɨ, kɨ a danɨngamin dagheba puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Eghtɨ, gumazir dɨpenimɨn aven itim kamaghɨn an akam ikaragham, ‘Nɨ ingangarim na danɨngan markɨ. Kɨ tiar akam asaragha gɨfa, egha uan boriba koma akui. Kamaghɨn kɨ dɨkavighɨva bizitam nɨ danɨngan kogham.’ ");
INSERT INTO msy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ezɨ kɨ ia mɨgei, dɨpenir ghuavim dɨkavighɨva uan namakam puvatɨzir biziba bar a danɨngam. A bizir kaba uan namakam danɨngan ifongezir pu, egha an a ganɨngi. An namakam a dɨmvɨra ikian, an aghuagha egha dɨkavigha iza bizir a bar ifongeziba a ganɨngi.” ");
INSERT INTO msy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ia God ko mɨkɨm, egh biziba bagh an azang, eghtɨ a da isɨ ia danɨngam. Egh ia biziba bagh ruiva, ia da bativam. Egh ia tiam gafughafughtɨ, God ia bagh tiam kuigham. ");
INSERT INTO msy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gumazir Godɨn azaiba, me biziba isi. Ezɨ gumazir biziba bagha ruim, da batifi. Eghtɨ gumazir itiam gafughagham, God a bagh akuigham. ");
INSERT INTO msy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Egh ian boritam uan afeziam osiriba bagha an azangsɨghtɨma, eghtɨ a kuruzitam a danigam, o? ");
INSERT INTO msy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Egh borim tuarir aroriam bagh uan afeziamɨn azangsɨghtɨma, a tuighakam a danigam, o? ");
INSERT INTO msy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ia afeziar arazir kurabagh amiba, ia zurara bizir bar aghuiba uan boribagh anɨdi. Egha ia kamagh deraghvɨra fogh, guizbangɨra ian Afeziar uan Nguibamɨn itim bar akueghvɨra uan Duam isɨ gumazir a ko mɨgeibar anɨngam.” ");
INSERT INTO msy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ezɨ Iesus duar kurar gumazim gamima a mɨgeir puvatɨzim a batoke. Ezɨ duar kuram anetaghizɨ, gumazir mɨgeir puvatɨzim datɨrɨghɨn mɨgei. Ezɨma gumazamiziba dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ezɨ marazi ghaze, “A Belsebulɨn gavgavimɨn duar kuraba batosi, a duar kurabar gumazir dapanim.” ");
INSERT INTO msy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ezɨ marazi Iesus basamasa egha ghaze, “Nɨ Godɨn gavgavimɨn mirakelɨn arazitam damightɨ, an overiamɨn ikegh izighrɨtɨ, e an ganigh fogham.” ");
INSERT INTO msy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ezɨ Iesus men nɨghnɨzibagh fogha, egha me mɨgei, “Kantrin tamɨn gumaziba uari tuiragh uari uariv soghɨva egh men dabirabim ikuvigham. Eghtɨ dɨpenir vamɨran itir darazi uariv sogh, egh uari abigh egh men dabirabim ikuvigham. ");
INSERT INTO msy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ia ghaze, kɨ ti Satanɨn gavgavimɨn duar kuraba batosi. Kamaghɨn amizɨ, kɨ ian azaragha ghaze, Satan uan adarazi ko uari abigh uariv sogh, egh me manmaghɨn tugh gavgavigh bizibar ganamin gavgavim ikiam? ");
INSERT INTO msy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ia ghaze, kɨ Belsebul da gavgavim isa duar kuraba batosi. Ezɨ kamaghɨn, tina ian adarazir akurvazima, me duar kuraba batosi? Ian adarazi amir araziba, darara ian akagha ghaze, ia paza na mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Eghtɨ kɨ Godɨn gavgavim inighɨva duar kuraba batoghtɨ, eghtɨ bizir kam ian akaghtɨ, ia kamaghɨn fogh suam, God Bizibagh Ativamin Dughiam ia batogha gɨfa. ");
INSERT INTO msy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Eghtɨ gumazir gavgavitam mɨdorozir biziba bar da inigh egh uan dɨpenim bagh gantɨ an biziba bar deraghvɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Eghtɨ gumazitam bar gavgavigh a gafiragh a ko uaning mɨsogh, egh a gafiragh, egh an mɨdorozir bizir a gami a gavgavigha ikia mɨsoziba inigh, mangɨ da tuiragh a da isɨ gumazir igharazibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tina nan namakam puvatɨ, a nan apanim. Ezɨ gumazim nan akuragha gumazamiziba akumakuir puvatɨ, gumazir kam men gɨntɨzima me tintinibar zui.” ");
INSERT INTO msy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ezɨ Iesus mɨgɨa ghua ghaze, “Duar ikuratam gumazitam ategha dɨpaba puvatɨzir danganibar arua ikiamin danganiba buri, egha a tam batozir puvatɨgha, egha uabɨ mɨgɨa ghaze, ‘Kɨ uamategh faragha ikezir dɨpenimɨn mangam.’ ");
INSERT INTO msy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Egha a uamategha ghua garima, me dɨpenim avizɨ, a bar zuezɨma an itir biziba bar deragha iti. ");
INSERT INTO msy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Egh duar kurar kam mangɨ, 7 plan duar kurar a gafiragha arazir kurabagh amiba, men aku izam. Egh me mangɨ, dɨpenir kamɨn ikiam. Gumazir kam faragha paza ike, egh a datɨrɨghɨn bar pazavɨra ikiam, eghtɨ an dabirabim a faragha ikezir dabirabim bar a gafiragh bar ikuvigham.” ");
INSERT INTO msy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ezɨ Iesus bizir kabav gɨavɨra itima, amizim gumazamizibar torimɨn ikia dɨa mɨgei, “Amizir kam nɨ bategha oteba nɨ ganɨdi, a bar akongegh.” ");
INSERT INTO msy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ezɨ Iesus a ikara, “Ezɨ tina nan Afeziamɨn akam baragha egha an gɨn zui, a bar akongegh.” ");
INSERT INTO msy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ezɨma gumazamiziba otiva izavɨra itima, Iesus kamaghɨn me mɨgei, “Datɨrɨghɨn itir gumazamiziba bar ikufi. Me mirakelɨn arazir kɨ damightɨ me ganigh foghamim bagha azangsɨsi. Eghtɨ kɨ arazitam me danigan kogham. God Jona gamizir arazimɨn mɨn, me arazir kamɨn ganam. ");
INSERT INTO msy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kamaghɨn amizɨ, Jona nguibar ekiam, Niniven gumazamiziba arazim men aka, ezɨ kamaghɨra Gumazibar Otarim datɨrɨghɨn itir gumazamiziba arazim men akagham. ");
INSERT INTO msy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Fomɨra Seban Amizir Atrivimɨn nguazir kamɨn saghon ikegha Solomonɨn fofozir aghuimɨn akaba baraghasa ize. Ezɨ gumazir mam bar Solomon gafiragha ian tongɨn iti. Kamaghɨn amizɨ, Gumazamiziba Godɨn Kotiamɨn Tuivamin Dughiamɨn, Seban Amizir Atrivim tugh datɨrɨghɨn itir gumazamizibar arazir kurabar gun mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Eghtɨ Godɨn Kotɨn Dughiamɨn, Nineven gumazamiziba dɨkavigh ian arazir kurabar gun mɨkɨmam. Ia fo, Nineven adarazi Jona akunizir akam baregha navibagh ira. Ezɨ Gumazir datɨrɨghɨn ian tongɨn itir mam, a bar Jona gafira!” ");
INSERT INTO msy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ezɨ Iesus ghua kamaghɨn mɨgei, “Gumazitam lam gaborogha danganir mogometamɨn a modozir puvatɨ, o a isava itarir ekiamɨn aven amadazɨ pu. Puvatɨ, anesɨ an danganimram anefagham. Eghtɨ tina aven izɨ, an angazangarimɨn ganam. ");
INSERT INTO msy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Damaziba, da lamɨn mɨn namnamɨn angazangarimɨn mɨn iti. Egha damazim derazɨ, nɨn namnam angazangarim bar a gizɨfa. Eghtɨ nɨn damazim ikuvightɨma, nɨn namnam, mɨtatem anevaragham. ");
INSERT INTO msy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kamaghɨn amizɨ, nɨ ua bagh deravɨra gan, angazangarir nɨn itim, mɨtarmem an epazagham. ");
INSERT INTO msy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kamaghɨn amizɨ, angazangarim bar nɨn mɨkarzim gizɨvaghtɨ, eghtɨ mɨtarmem tong an epazaghan koghtɨ, nɨn mɨkarzim bar angazangarimɨn ikiam, mati lamɨn angazangarim nɨ gisirazɨ moghɨn.” ");
INSERT INTO msy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ezɨma Iesus mɨkemegha gɨvazɨma, Farisin mam Iesus ko damasava an gighamizɨma, ezɨ Iesus an dɨpenimɨn aven ghugha dagher dakozim gapera. ");
INSERT INTO msy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ezɨ Farisi garima, Iesus ruezir puvatɨgha a koma api. Ezɨ a kamaghɨn ganigha aguaghfa. ");
INSERT INTO msy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ezɨ Ekiam kamaghɨn a mɨgei, “Ia Farisiba, ia kapba ko itariba azenan da rua da zue, ezɨ ian aven navir averiaba bar kufi. Okɨmakɨam koma arazir kuraba, ia dagh ami. ");
INSERT INTO msy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ia bar gumazir onganiba! God azenan ingarizir biziba, a uaghan aven dar ingari? ");
INSERT INTO msy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Eghtɨ ia bizir itaribar aven itiba isɨva gumazir onganaraziba me danɨng, eghtɨ biziba bar ian zuegham. ");
INSERT INTO msy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ia Farisiba, ia ghaze, ia uan azenibar itir zuravariba tongɨra da tuiragh, egh akuaba isɨ God danɨng. Egha ia Godɨn arazir aghuim ko a gifongezir arazim ataghrasi. Egha ia arazir kabar amuasa gavgavigh, egh uaghan arazir maba ataghraghan kogham. Kamaghɨn amizɨ ia bar kuvigham! ");
INSERT INTO msy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ia zurara God ko mɨgeir dɨpenibar dabirabir danganir aghuariba iniasa bar ifonge. Egha uaghan maketɨn danganiba me dughiaba ia danɨngasa, ia bar ifonge. Kamaghɨn amizɨ, ia bar ikuvigham. ");
INSERT INTO msy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ia mati matmatiar me gan foghan koghamibar mɨn iti. Eghtɨ gumaziba me gisɨn daruam. Egh Godɨn damazimɨn zueghan kogham. Kamaghɨn amizɨ, ia bar kuvigham!” ");
INSERT INTO msy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ezɨ Judan arazibagh fozir gumazir mam a ikara, “Tisa, nɨ bizir kabav gɨa, uaghan e gasɨghasɨsi.” ");
INSERT INTO msy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ezɨ Iesus a ikara, “Ezɨ ia Judan arazibagh fozir gumaziba, ia gumazamiziba osɨmtɨziba me garɨzima me da ateran ibura. Ezɨma ia uari, uan dafaribar men akuragh bizitam aterir puvatɨ. Kamaghɨn amizɨ, ia bar kuvigham! ");
INSERT INTO msy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ian inazir afeziaba Godɨn akam inigha izir gumazibav soghezɨma me ariaghɨre. Ezɨ ia me bagha dagɨar mozir aghuiba okoregha men aghariba mozibagh arɨki. Kamaghɨn amizɨ ia bar ikuvigham! ");
INSERT INTO msy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ezɨ ia arazir kam gumazibar akakagha ghaze, ian inazir afeziaba amir arazir kam dera. Ezɨ me Godɨn akam inigha izir gumazibav soghezɨ da ariaghɨre, ezɨ ia me bagha mozibagh ami. ");
INSERT INTO msy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bizir kam bagha, Godɨn fofozim kamaghɨn mɨgei, ‘Kɨ me bagh nan akam inigha izir gumaziba koma aposelba amangam, eghtɨ men tarazi, me me mɨsoghtɨma, me arɨghɨram. Eghtɨma igharaziba, me arazir kurabar me damuam!’ ");
INSERT INTO msy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Fomɨra nguazir kam otozir dughiam, Godɨn akam inigha izir gumaziba, me me mɨsoghezɨ me arɨaghɨra, ezɨ arazir kam iza datɨrɨghɨn tu. Kamaghɨn amizɨma ia datɨrɨghɨn iti darasi, men ivezim iniam. ");
INSERT INTO msy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ezɨ modorozir arazir kam, an Abelɨn dughiamɨn tugha iza Sekaraian dughiam. Gumazir kam, Sekaraia, me ofan danganim ko Godɨn Dɨpenimɨn tɨzimɨn a mɨsoghezɨma an areme. Ezɨ kɨ ia mɨgei, arazir kurar kabar ivezim gumazir datɨrɨghɨn itiba bativam. ");
INSERT INTO msy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ia Judan arazibagh fozir gumaziba Godɨn fofozimɨn tiar akamɨn kiba inigha ghue. Ia uari aven ghuezir puvatɨ. Egha aven mangamin gumazibar tiar akam apɨri.” ");
INSERT INTO msy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Egha Iesus danganir kam ataghrazima, Judan arazibagh fozir gumaziba koma Farisiba, me akar kurabar a mɨgei. Egha azangsɨzir avɨribar a gami. ");
INSERT INTO msy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Egha an gari, a bizitam pazɨva a mɨkemeghtɨma, me an suigham. ");
INSERT INTO msy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ezɨ dughiar kamɨn gumazamizir bar avɨrim uari akuvaghav ikia uari dɨkabɨri. Ezɨ Iesus maghɨra uan suren gumaziba faragha dav gɨa ghaze, “Ia uari bagh gan. Farisiba mati, yis bretɨn aven ghughava a gamizɨma a bar buiz moghɨn ian aven mangɨ ia gasɨghasɨgham. Kamaghɨra ifavarir araziba uaghan bar ia gasɨghasigham. ");
INSERT INTO msy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bizir tizir mongeziba, da azenim giregham. Akar aven itiba, gumaziba dagh fogham. ");
INSERT INTO msy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ezɨ bizir ia amɨnir bɨrimɨn mɨkemeziba, me aruer angazangarimɨn da baragham. Ezɨma bizir tizir ia sighsirir akabar uan kuaribagh arɨgha dɨpenir averiabar uariv kemeziba, me dɨpenibagh isɨn tuiv dar gun mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Egha Iesus ghua kamaghɨn mɨgei, “Nan namakaba, kɨ ia mɨgei, ia gumazir namnar kɨnibav sozibar atiatingan markɨ. Egh me gɨn ua bizitam damighan kogham. ");
INSERT INTO msy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ezɨ, tinarama ia an atiatingam, kɨ ian akagham. Ia Godɨn atiating, a ian namnam gasɨghasighɨva, gɨn ia inigh helɨn avim mɨkɨnamin gavgavim iti. Ezɨ kɨ guizbangɨra ia mɨgei, ia Godɨn atiating. ");
INSERT INTO msy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ezɨ ia fo, gumazim kuarazir dozir 5 pla 2 toearama dagh ivese. Ezɨ God men tav bakɨnɨghnɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Egha God uaghan ian dapanir arɨziba dar pone, egha a bar deraghavɨra ia gɨfo. Kamaghɨn amizɨma, ia atiatingan markɨ. Ia kuarazir dozir kabar mɨn itir puvatɨ. Ia Godɨn damazimɨn bar ekefe, egha dagh afira.” ");
INSERT INTO msy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Egha Iesus ghua kamaghɨn mɨgei, “Kɨ ia mɨgei, Gumazir manam gumazamizibar damazimɨn ghaze, a nan anam, eghtɨ Gumazibar Otarim uaghan Godɨn enselbar damazibar mɨkɨm suam, gumazir kam a nan anam. ");
INSERT INTO msy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eghtɨ gumazitam gumazamizibar damazimɨn mɨkɨm suam, a nan anav puvatɨ, eghtɨ kɨ uaghan Godɨn enselbar damazibar mɨkɨm suam, gumazir kam nan anav puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Eghtɨ gumazitam akar kuratam Gumazibar Otarim mɨkemeghtɨ, God an arazir kurar kam gɨn amadagham. Eghtɨ gumazitam Godɨn Duam akar kuratam a mɨkemeghtɨma, God an arazir kurar kam, a gɨn amadaghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Me ia inigh God ko mɨgeir dɨpenibar mangam. Egh gavmanɨn gumazir ekiaba ko gumazir ziaba itibar damazibar mangɨtɨma, ia atiatingan markɨ. Egh suam, kɨ manmaghɨn ua bagh ganam, o manmaghɨn mɨkɨmam? ");
INSERT INTO msy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dughiar kamra Godɨn Duam nɨ mɨkemeghtɨma nɨ me mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ezɨ gumazir mam gumazamizibar torimɨn ikia kamaghɨn Iesus mɨgei, “Tisa, nan aveghbuam mɨkemeghtɨma a gan afeziam ga bagha taghizir bizitaba na bagh taba tuiragh.” ");
INSERT INTO msy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ezɨ Iesus a ikara, “Tinara guan osɨmtɨzibar kɨr guan biziba tuiraghasa, na mɨsefe?” ");
INSERT INTO msy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Egha a me mɨgei, “Ia uari bagh ganigh. Biziba bar dagh ifongezir arazir kaba bagh, uari bagh ganigh! Gumazimɨn dabirabim a bizir avɨrir a itir kaba saram otozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Eghava an akar isɨn zuir kamɨn me mɨgei, “Gumazir dagɨaba bar avɨrasemezir mam iti. Egha uan nguazimɨn dagher aghuir avɨriba isi. ");
INSERT INTO msy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ezɨ a kamaghɨn uabɨ gɨnɨghnɨsi, ‘Kɨ manmaghɨn damuam? Kɨ uan daghebar arɨghamin danganiba puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Egha a ghaze, ‘Kɨ kamaghɨn damuam. Kɨ uan dagher dɨpeniba kuarighɨva, dɨpenir ekiabara ingarigham. Egh dɨpenir ekiaba, kɨ uan maziaba ko dagheba ko biziba bar dar arɨgham. ");
INSERT INTO msy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Egh kɨ uabɨra uabɨ mɨkɨmam, “Nɨ dughiar avɨriba bagha ua bagha bizir aghuir avɨrim arɨki. Egh nɨ damɨva, wainɨn dɨpabar amɨva, egh dughiar aghuarim iniva, egh bar akuegh ikiam.” ’ ");
INSERT INTO msy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ezɨ God a mɨgɨa ghaze, ‘Nɨ gumazir onganim. Dɨmagarir kamra nɨn ikɨrɨmɨrim kɨ a inightɨ, naremegham. Eghtɨ tina nɨ ua bagh arɨghizir bizir kabanagh iniam?’ ");
INSERT INTO msy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Ezɨ tina ua bagh biziba puv dar pozim mɨkɨnɨva, egh a Godɨn damazimningɨn onganarazibar amutɨ, bizir kam a bativam.” ");
INSERT INTO msy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Egha Iesus uan suren gumaziba kamaghɨn me mɨgei, “Kamaghɨn amizɨ, kɨ ia mɨgei, ia pamten uan ikɨrɨmɨrim gɨnɨghnɨgh, egh kamaghɨn azangan markɨ, e dagher manatam ramam, o e dɨpar manatam ramam? Egh ia pamten uan nivafɨzibagh nɨghnɨgh mɨkɨman markɨ, e inir manatam uan nivafɨzim avam? ");
INSERT INTO msy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gumazimɨn ikɨrɨmɨrim, a daghebagh afira, ezɨ gumazimɨn namnam inibagh afira. ");
INSERT INTO msy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ia kotkotbar gan. Me dagheba opari puvatɨghava dagh eghuvir puvatɨ, me dagheba arɨzir dɨpeniba puvatɨ. Ezɨ God dagheba dagh anɨdi! Ezɨ ian dabirabim bar kuarazibagh afira. ");
INSERT INTO msy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Egh ian tav deraghvɨra ikɨsɨ nɨghnɨgh kamaghɨn a ti uan ikɨrɨmɨrim damutɨ a tong ruaragham? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nɨ bizir muziarir kam damuan iburagh, nɨ tizim bagha biziba bar a dagh nɨghnɨzir avɨribagh ami? ");
INSERT INTO msy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ia akɨmarir aghuaribagh nɨghnɨgh. Da manmaghɨn otifi? Me ingangarir ekiatam gamir puvatɨ. Egha me korotiatam isamizir puvatɨ. Ezɨ kɨ ia mɨgei, fomɨra Atrivim Solomon bizir bar avɨriba itima an azuir adiariba bar dera, egha an korotiatam akɨmarir kabar mɨn otozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","E fo, graziba pura biziba, da iti, gurumɨn gumazitam da akoreghɨva da isɨva avitam mɨkɨnigham. Grazir kɨnir kabanagh God adiariba me gazui. Ia bizir kam gɨfogh, God uaghan adiariba ia danɨngam. Ia gumazamizir nɨghnɨzir gavgavir muziarim itiba! ");
INSERT INTO msy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Egh ian nɨghnɨzim dagheba ko dɨpabara ikian markɨ. Egh ia pamtem dagh nɨghnɨghan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nguazir kamɨn gumaziba bizir kaba puv dagh nɨghnɨsi. Ezɨ ian Afeziam fo, ia da iniam. ");
INSERT INTO msy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eghtɨ ia faragh God atɨghtɨma, a ian Atrivimɨn ikɨtɨma, ia an gɨn mangɨ. Eghtɨ, a bizir kaba ia danɨngam.” ");
INSERT INTO msy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Egha Iesus ghua kamaghɨn mɨgei, “Ia sipsipɨn bɨzir muziarim, ian Afeziam ia damightɨ, ia Atrivimɨn otivasa a bar akonge. Kamaghɨn ia atiatingan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ia uan biziba amangɨva dagɨaba inigh, egh gumazir onganarazibar anɨng. Egh uari bagh dagɨaba azuir mɨtariba inigh dar arightɨma da dɨghorighɨran kogham. Ian bizir aghuir Godɨn Nguibamɨn itiba, da gɨvaghan kogham. Godɨn nguibamɨn okɨmakɨar gumaziba roghɨra izan kogham, eghtɨ barareba dagh asɨghasɨghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Danganir manam nɨn bizir aghuiba iti, danganir kam nɨn navir averiamɨn aven itir ifongiam, a uaghan ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Egha Iesus ghua kamaghɨn mɨgei, “Ia ingaramin korotiabar aghuighɨva otivamin bizim bagh ganɨva uan lamba ateghtɨma da isi, mamaghɨra ikɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Egh mati gumazim uan otarim amir ikɨzir isam bagha ghugha uamategh izasa, me a mɨzuai. Eghtɨ a uamategh izɨ tiam gafughtɨ me zuamɨram a bagh tiam kuigham. ");
INSERT INTO msy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ingarir gumazir kabar gumazir aruam uamategh izɨ men gantɨ, me a mɨzua gari. Kamaghɨn me bar akuegham. Kɨ guizbangɨra ia mɨgei, a dagheba, me danɨngsɨ, uabɨn kurukegham. Egh me mɨkemeghtɨ, me dakozim dapiaghtɨ a izɨ dagheba me danɨngam. ");
INSERT INTO msy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Egh men gumazir aruam dɨmagarir arɨzim, o amɨnim titɨm a uamategh izɨ men gantɨ me a bagh gan mɨzuam ikɨtɨ, kamaghɨn me bar akuegham. ");
INSERT INTO msy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ia arazir kam gɨnɨghnɨgh. Gumazir manam, okɨmakɨar gumaziba dɨmagarimɨn izava an dɨpenim akarasava amima, a men dughiam gɨfogha, egha men arafa. Egha me ataghizɨ me an dɨpenim akarizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kamaghɨra, ia uaghan aravagh ikɨ gan. Guizbangɨra, dughiar ia Gumazibar Otarim mɨzuaman koghamim, a dughiar kamram otogham.” ");
INSERT INTO msy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ezɨ Pita Iesusɨn azara, “Ekiam, nɨ akar isɨn zuir kamɨn erara mɨgei, o e bar moghɨra?” ");
INSERT INTO msy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ezɨ Ekiam an akam ikara, “Ingangarir gumazir manamra nɨghnɨzir aghuiba ikia deravɨra uan ingangarim gami? An gumazir ekiam a damutɨ, a ingangarir gumazir igharazibar ganam. Egh dughiar an gumazir ekiam ifongezimɨn, a dagheba isɨ ingangarir gumazibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ingangarir gumazir kam ingara itima, an gumazir ekiam izava a batogha an ingangarir kamɨn garima, gumazir kamɨn navir averiam bar an dera. ");
INSERT INTO msy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ezɨ kɨ guizbangɨra ia mɨgei, ingangarir gumazir kamɨn ekiam a damightɨma, an an ingangarir gumazir mabar ekiamɨn ikɨva an biziba bar dar ganam. ");
INSERT INTO msy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Egh ingangarir gumazibar dapanim uabɨra uabɨ mɨkɨmam, ‘Nan gumazir ekiam dughiar ruarimɨn ikegh izam.’ Egh a dɨkavigh ingangarir gumaziba ko ingangarir amizibav soghɨva, damɨva, wainɨn dɨpabar amɨva dapanim onganigham. ");
INSERT INTO msy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Eghtɨ an ekiam, dughiar an ingangarir gumazim a bagha garir puvatɨzimɨn, an otogham. A dughiar a fozir puvatɨzimɨn uamategham. Eghtɨma an ekiam bar anerghorarighɨva a inighɨva gumazir God gɨfozir puvatɨziba ko anetɨgham. ");
INSERT INTO msy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ingangarir gumazibar dapanim fo, an ekiam bizir tizim damuasava a mɨkeme, ezɨma an a gamizir puvatɨ. Eghtɨ an ekiam dughiar avɨribar a ifozoregham. ");
INSERT INTO msy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eghtɨ ingangarir gumazim an ekiam ifongezir arazibagh fozir puvatɨghɨva, egh a uabɨ mɨsoghamin arazibar amutɨ, an ekiam dughiar avɨribar a ifozoreghan kogham. Tina bar bizir avɨriba ini, a ua bizir avɨriba God danɨngam. Ezɨma tina God bizir avɨriba an dafarim garɨki, God uam a dam avɨriba inisɨva an azangsɨgham.” ");
INSERT INTO msy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Kɨ nguazim avim a darɨghasa izi. Ezɨ avim datɨrɨghɨra isiasa kɨ ifonge. ");
INSERT INTO msy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kɨ tɨghar rurir mam a iniam. A mati dɨpam gumazim avarazɨ moghɨn, osɨmtɨziba na bativam. Ezɨ kɨ a inizir puvatɨ. Kamaghɨn kɨ bar oseme, mangɨ dughiar kam otogham! ");
INSERT INTO msy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nɨ ghaze, kɨ navir amɨrɨzim inigha nguazir kamɨn izi? puvatɨ, kɨ ia mɨgei, kɨ gumazamiziba abɨghasa ize. ");
INSERT INTO msy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Datɨrɨghɨn tugh mangɨ 5 plan amuiroghboriba dɨpenir tamɨn ikɨv uari tuiragham, 3 pla pumuningɨn apanimɨn ikiam, eghtɨ, pumuning 3 plan apanimɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Me uari tuiragham, afeziam uan otarimɨn apanimɨn ikiam, eghtɨ otarim uan afeziamɨn apanimɨn ikiam. Amebam uan guivimɨn apanimɨn ikiam, eghtɨ guivim uan amebamɨn apanimɨn ikiam. Otarimɨn amuim uan pamɨn amebamɨn apanimɨn ikiam, eghtɨ, otarimɨn amebam uan otarimɨn amuimɨn apanimɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Egha Iesus gumazamizir avɨribav gei, “Ia gantɨ, ghuariam aruem magɨramin amadagham anangtɨma, ia zuamɨra suam, ‘Amozim izam,’ eghtɨma a izam. ");
INSERT INTO msy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Egh Sainain amɨnim vangtɨ, ia suam, aruem gan bar puvɨra isiam. Eghtɨ an otogham. ");
INSERT INTO msy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ifavarir gumaziba! Ia overiam ko nguazimɨn otivamin bizibar gun mɨkɨmasa fo. Manmaghɨn amizɨ, ia datɨrɨghɨn otivamin bizibagh fozir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ezɨ ia uari uarir azangsɨghan aghua, bizir tizim a dera. ");
INSERT INTO msy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Egh nɨn apanim nɨ inigh mejistretbar damazimɨn mangɨtɨma, nɨ a ko osɨmtɨzir kam akɨrsɨ tuavimɨn a mɨkɨm ganigh. Puvatɨghtɨma, a nɨ inigh jasɨn damazimɨn mangam. Eghtɨ jas nɨ inigh polisɨn dafarim datɨghtɨma polis nɨ isɨ kalabuziam datɨgham. ");
INSERT INTO msy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kɨ nɨ mɨgei, nɨ azenim girɨghan kogham, kamaghɨra ikɨ mangɨ nɨ ivezim bar anetɨgh azenim giram.” ");
INSERT INTO msy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ezɨ dughiar kamɨn gumazir maba ikiava Galilin gumazibar gun Iesus mɨgei, Pailatɨn mɨdorozir gumaziba me mɨsoghezɨma men ghuziba God bagha tuer asizibar ghuziba sara verevere. ");
INSERT INTO msy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ezɨ Iesus men akam ikara, “Galilin gumazir kaba kamaghɨn ariaghɨre. Kamaghɨn amizɨma ia ghaze men arazir kuraba Galilin gumazir igharaziba bar men arazir kurabagh afira? ");
INSERT INTO msy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ezɨ kɨ guizbangɨra ia mɨgei, bar puvatɨ! Egh ia navibagh iraghan koghɨva, ia uaghan bar arɨmɨghregham. ");
INSERT INTO msy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Egh ia uaghan bizir kam gɨnɨghnɨgh, 18 plan gumazir Siloamɨn dagɨar dɨpenim dɨpɨrigha me mɨsoghezɨma me ariaghɨre. Ezɨ ia ghaze, men arazir kuraba bar Jerusalem itir gumaziba men arazir kurabagh afira? ");
INSERT INTO msy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ezɨ kɨ guizbangɨra ia mɨgei, bar puvatɨ. Ezɨ ia navibagh iraghan koghɨva, ia uaghan bar arɨmɨghregham.” ");
INSERT INTO msy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ezɨ Iesus akar isɨn zuir kamɨn me mɨgei, “Gumazir mam temer figh uan wainɨn azenimɨn anekaragha egha ghuava ovɨziba bagha an gara tamɨn apizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Egha a wainɨn azenimɨn garir gumazim kamaghɨn a mɨgei, ‘Kɨ 3 plan azenibar arua izava fighɨn ovɨziba bagha garava avenge, da bar puvatɨ. An okegh! Manmagh sua a puram aghui?’ ");
INSERT INTO msy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ezɨma a kamaghɨn a mɨgei, ‘Ekiam aneteghtɨma, an azenir tam uam an ikɨtɨma, kɨ an povimɨn nguaziba a darɨghtɨma a dagher aghuiba iniam. ");
INSERT INTO msy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","An azenir munamɨn beghtɨ, deragham. Puvatɨghtɨma nɨ na mɨkemeghtɨma kɨ an okegham.’” ");
INSERT INTO msy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Egha Iesus Sabatɨn dughiamɨn God ko mɨgeir dɨpenir mamɨn sure gami. ");
INSERT INTO msy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ezɨma amizir mam 18 plan azenimɨn duar kuram an akɨragharim gamizɨma an aviraghavɨra ikiava bar uabɨ amɨnava avenge. ");
INSERT INTO msy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ezɨ Iesus an apighava an diazɨma an ada zuima, a kamaghɨn a mɨgei, “Amizim, nɨn arɨmariam nɨ ataki.” ");
INSERT INTO msy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Egha uan dafarimning a gisɨn atɨzɨma, a zuamɨra uabɨ amɨnegha tugha, Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iesus Sabatɨn amizim akɨrizɨma a dera, ezɨ bizir kam bagha God ko mɨgeir dɨpenimɨn garir gumazim atarava, egha a kamaghɨn gumazamizibav gei, “Ingangarir dughiar 6 pla iti, egh ia dughiar kabar izɨtɨma, a ian arɨmariaba akɨram. Egh Sabatɨn dughiamɨn ia izan markɨ.” ");
INSERT INTO msy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ezɨ Ekiam an akam ikara, “Ia uarira uari gifarir gumaziba! Ian tav Sabatɨn dughiamɨn uan bulmakau o donki fɨrigha a inigha ghua dɨpatam a ganɨdir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kamaghɨn amizɨ, amizir kam an Abrahamɨn ovavim, Satan 18 plan azenir kabar a ike. Ezɨ kamaghɨn amizɨma kɨ Sabatɨn dughiamɨn a fɨrightɨ a deragham.” ");
INSERT INTO msy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Egha a kamaghɨn mɨkemezɨma, an apaniba bar moghɨra aghumsɨki. Ezɨma gumaziba ko amiziba an amizir bizir aghuibar gara bar akonge. ");
INSERT INTO msy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Egha Iesus gumazamizibar azara, “God Bizibagh Ativamin Dughiam manmaghɨn gari? Ezɨ kɨ akar isɨn zuir manamɨn a mɨkɨmam? ");
INSERT INTO msy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A mastetɨn ovɨzim mɨngari. Ezɨ gumazim a inigha uan azenimɨn an ekarazɨma, an aghua ghuava temem gava. Ezɨma kuaraziba an aguabar mɨkonibagh ami.” ");
INSERT INTO msy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Eghava Iesus ua gumazamizibar azara, “Kɨ bizir manatamɨn God Bizibagh Ativamin Dughiamɨn akar isɨn zuim mɨkɨmam? ");
INSERT INTO msy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A yisɨn mɨn ami. Amizir mam yisɨn muziarir mam inigha, flauan dramɨn ekiamɨn itim inigha, aning verevere. Ezɨ flauan kam gɨn bar bui.” ");
INSERT INTO msy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Egha Iesus Jerusalemɨn ghuava nguibar ekiaba ko dozibar bar gumazamizibar sure gamua zui. ");
INSERT INTO msy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ezɨ mav an azara, “Ekiam, God gumazamizir vabara ua me iniam, o?” ");
INSERT INTO msy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Ezɨma a kamaghɨn me mɨgei, “Kɨ ia mɨgei, avɨriba tiar akar asuvɨrɨzir kamɨn aven mangɨva avegham. Ezɨ kamaghɨn amizɨma ia gavgavigh tiar akar asuvɨrɨzir kamɨn dɨrighɨva aven mangɨ. ");
INSERT INTO msy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eghtɨ dɨpenimɨn ghuavim dɨkavigh tiam asaraghtɨma. Ia azenan ikɨva tiam mɨsogh dɨmɨva avegh suam, ‘Ekiam, e bagh tiam kuigh.’ Eghtɨma a kamaghɨn ian akam ikaragham, ‘Kɨ ia gɨfozir puvatɨ. Ia managh izava otifi?’ ");
INSERT INTO msy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Eghtɨ ia kamaghɨn mɨkɨmam, ‘E nɨ ko dagheba ko dɨpaba ame. Ezɨma nɨ tuavibar en sure gami.’ ");
INSERT INTO msy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Eghtɨ a kamaghɨn ian akam ikaragham, ‘Kɨ ia gɨfozir puvatɨ. Ia managh izava otifi. Na gitagh, ia arazir kurabagh amiba!’ ");
INSERT INTO msy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Egh ia, Abraham ko Aisak ko Jekop ko Godɨn akam inigha izir gumaziba me God Bizibagh Ativamin Dughiamɨn aven ikɨtɨma ia men gan ikiam. Egh ia azenan ikɨva bizir kam bagh aziva atariba kuskugham. ");
INSERT INTO msy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Egh gumazamizir avɨriba nguazimɨn mɨkebaba bar dar ikegh izɨva God Bizibagh Ativamin Dughiamɨn isam bagh uan danganiba iniam. ");
INSERT INTO msy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ia oragh, gɨn itir gumaziba me faragham, eghtɨ gumazir faraziba me gɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ezɨ dughiar kamra Farisin maba Iesus bagha iza kamaghɨn a mɨgei, “Herot nɨ mɨsoghasa. Kamaghɨn amizɨma nɨ nguibar kam ategh igharagh mangɨ.” ");
INSERT INTO msy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ezɨ Iesus men akam ikara, “Mangɨ afiar ifarir mam mɨkemegh, ‘Nɨ oragh, kɨ datɨrɨghɨn ko gurumɨzaraghan duar kuraba batoghɨva egh gumazibar arɨmariaba akɨram. Egh kɨ zuerɨmɨn uan ingangarim a gɨvam.’ ");
INSERT INTO msy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ezɨ kɨ ia mɨgei, Godɨn akam inigha izir gumazitam Jerusalemɨn azenan aremeghan kogham. Ezɨ kɨ datɨrɨghɨn ko gurumɨzaraghan ko zuerɨmɨn mangvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Egha Iesus mɨgɨa ghua ghaze, “Oio, ia Jerusalemɨn adarazi, kɨ ian apangkufi! Ia Godɨn akam inigha izir gumaziba mɨsozi me ariaghiri, egha God ia bagha amadir gumaziba, ia dagɨaba isa, me ginivi, me ariaghiri. Dughiar avɨribar kɨ ian boriba akuv me mughasa, mati tuarir amebam uan avɨzimingɨn nguziba avarazɨ moghɨn, kɨ ia damuasa ifonge. Ezɨ ia na bagh izan aghua. ");
INSERT INTO msy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ia oragh! Ian nguibam, God anetaki. Ezɨ kɨ guizbangɨra ia mɨgei, ia ua nan ganan kogham kamaghɨra ikɨ mangɨ dughiar ia suam, ‘God uan ziamɨn gumazir kam anemada! God deragh a damu!’” ");
INSERT INTO msy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabatɨn mam Iesus ghua Farisibar gumazir ekiamɨn dɨpenimɨn api. Ezɨma dughiar kam gumazamiziba bar deravɨram an gari. ");
INSERT INTO msy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ezɨma an guamɨn gumazir mɨkarzim buizir mam iti. ");
INSERT INTO msy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ezɨ Iesus Farisiba ko Judan arazibagh fozir gumaziba men azara, “Moses osirizir araziba, da Sabatɨn gumazamizibar arɨmariaba ghuamaghasa amamangatɨzɨ, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ezɨ me nɨmɨra itima a gumazimɨn suiragha a gamizɨma a dera. Egha anemadazɨ a ghu. ");
INSERT INTO msy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ezɨ a men azara, “Ian tavɨn otaritam o bulmakaun tam Sabatɨn dughiam mozirpamɨn a gɨrɨghtɨma, eghtɨ nɨ zuamɨra a gekuigham, o puvatɨgham?” ");
INSERT INTO msy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ezɨ me mɨkɨmamin akabagh asa. ");
INSERT INTO msy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dughiar kam Iesus gari, gumazir gighamiziba me dabirabir danganir ekiaba dagher dakozimɨn da isi. Ezɨ Iesus akar isɨn zuir kamɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Gumazitam amuir ikɨzimɨn isam bagh diaghtɨ, nɨ mangɨ dabirabir danganir ekiar faragha itim dapian markɨ. Me, gumazir ziar ekiar nɨn ziam gafirazim, a bagha a ginaba. ");
INSERT INTO msy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Eghtɨ, isar ghuavir vɨrara guan diazim izɨ kamaghɨn nɨ mɨkɨmam, ‘Nɨ uan mɨsiam gumazir kam danɨngigh.’ Eghtɨ nɨ bar aghumsɨghɨva, danganir bar gɨn itim inigham. ");
INSERT INTO msy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kamaghɨn dughiar me nɨn diazim, nɨ danganir apengan itim inigh, eghtɨ isar ghuavim izɨ suam, ‘Roroam, danganir aghuir pɨn itimɨn mangɨ.’ Eghtɨ nɨ ziar aghuarim nɨ ko itir darazir tongɨn a iniam. ");
INSERT INTO msy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Te uarira uan ziaba fe, God me abɨraghtɨ, me apengan ikiam. Eghtɨ te apengan iti, God me feghtɨ me ziar ekiaba iniam.” ");
INSERT INTO msy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Egha Iesus ua isar ghuavim mɨgei, “Nɨ isam damuva, egh uan roroaba, aveghbuaba, o anababa, o nɨn namakar biziba bar avɨrasemeziba, me diaghan markɨ. Nɨ men diaghtɨ, me uamategh nɨn diaghtɨma, kamaghɨn nɨ uan ikarvazim uamategh a inigham. ");
INSERT INTO msy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ezɨ nɨ isam damuamin dughiam, nɨ onganarazibagh amiba, soroghafariba ikuviziba, suer kurar aruir puvatɨziba, ko damazir kurabar diagh. ");
INSERT INTO msy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Eghtɨ God arazir aghuim nɨ damigham. Gumazir kaba nɨn dagheba ikaraghan kogham. Kamaghɨn amizim, nɨ uan ikarvazim dughiar gumazir Godɨn damazimɨn deraziba ua dɨkavamin dughiamɨn a iniam.” ");
INSERT INTO msy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Egha Iesus ko dakozimɨn itir gumaziba men mav Iesusɨn akaba baregha, kamaghɨn Iesusɨn mɨgei, “Gumazir God Bizibagh Ativamin Dughiamɨn isar ekiam ramamim, a bar akongegham.” ");
INSERT INTO msy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ezɨ Iesus a ikara, “Dughiar mam gumazir mam isar ekiam bagh bizibar akɨrava gumazir avɨrimɨn dia. ");
INSERT INTO msy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Isam azuir dughiamɨn isar ghuavim a gighamiziba bagha uan ingangarir gumazim me mɨkɨmasa anemaga ghaze, ‘E biziba bar dar akɨrigha gɨfa, kamaghɨn amizɨma ia izɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ezɨma me bar moghɨra mangan aghuaghava uan dɨmdiam ava mɨgɨrɨgɨar ifavaribagh ami. Egha farazim kamaghɨn mɨgei, ‘Kɨ datɨrɨghɨra nguazim givese, egh mangɨva an ganasa. Noka, kɨ izan kogham.’ ");
INSERT INTO msy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ezɨ igharazim ghaze, ‘Kɨ 10 plan bulmakaubagh ivese, egha kɨ da ingangarim gatɨgha dar ganasa zui. Noka, kɨ izan kogham. Ga uaning, nɨ nan gun isar ghuavim mɨkemegh.’ ");
INSERT INTO msy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ezɨ kamaghɨra gumazir mɨkezim a mɨgei, ‘Kɨ amuim ini, kamaghɨn amizɨ kɨ izan kogham.’ ");
INSERT INTO msy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ezɨ ingangarir gumazim uamategha izava akar kabar gun uan ekiam mɨkeme. Ezɨ isar ghuavim atara kamaghɨn mɨgei, ‘Nɨ zuamɨra azenan mangɨva nguibar ekiamɨn itir tuavir ekiaba ko afeghtiabar mangɨva onganarazibagh amiba, ko soroghafariba ikuviziba, ko damazir kuraba, ko suer kurar aruir puvatɨziba, me inigh izɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ezɨ ingangarir gumazim kamaghɨn a mɨgei, ‘Ekiam, nɨ mɨkemezir moghɨn kɨ amigha gɨfa, ezɨ danganir maba ikiavɨra iti.’ ");
INSERT INTO msy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ezɨ isar ghuavim uan ingangarir gumazim kamaghɨn a mɨgei, ‘Nɨ mangɨ bar tuavir ekiaba ko tuavir dozibar itiba bar me mɨkɨmtɨ, me izɨ, eghtɨ nan dɨpenim izɨvaka. ");
INSERT INTO msy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ezɨ, kɨ nɨ mɨgei, gumazir kɨ faragha diaziba men tav isar kamɨn dagher tam rameghan kogham.’” ");
INSERT INTO msy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ezɨ gumazir bɨzir dafam Iesus koma arui. Ezɨ a ragha men gara kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tina na bagh izɨva, egha uan afeziam ko amebam, o amuim ko boriba, o aveghbuaba, o amezamebaba ko buaramiziba bar men aghuaghɨva, egha uaghan uan ikɨrɨmɨrim ateghan koghɨva, egh nan suren gumazimɨn otoghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Eghɨva tina uan ter ighuvim a gupugh, egh nan gɨn izan koghɨva, nan suren gumazimɨn otoghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ian tina dɨpenir ekiamɨn ingarasa, a ti faragh daperagh nɨghnighɨva, egh suam, kɨ dagɨaba manmaghɨra dɨpenir kam a gɨvagham? ");
INSERT INTO msy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Egh ian tina dɨpenir ekiamɨn ingarsɨ, faragh daperagh nɨghnɨgh suam, ‘Kɨ dagɨaba manmaghɨra dɨpenir kam a gɨvagham?’ Puvatɨghtɨma, a ghuriamra damighɨva, egh anegɨvaghan koghtɨma, me bar an ganɨva dɨbovir mɨgɨrɨgɨabar a damu, suam, ‘Gumazir kam dɨpenimɨn ingara bar anegɨvazir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O, kɨ kamaghɨn mɨkɨm suam, atrivir mam atrivir igharazim ko mɨdorozir ekiam damuasa. A ti faragh daperagh uabɨra uabɨn azangsɨgh suam, ‘Kɨ ti 10 tausen gumaziba ko mangɨ, na bagha izir atrivimɨn 20 tausen gumaziba gafiragham, o puvatɨgham?’ ");
INSERT INTO msy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A mɨsoghan buraghɨva, egh atrivim saghuiamɨra ikɨtɨma, an abuir gumaziba mangɨ suam, mɨdorozim markɨ. ");
INSERT INTO msy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ezɨ kamaghɨra, ian tina bizir a itiba bar moghɨra a da ateghan koghɨva, egh nan suren gumazimɨn otoghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Egha Iesus ghua kamaghɨn mɨgei, “Amangsɨzim a dera, egh a uan sɨngtɨzim ategh egh manmaghɨn ua uan sɨngtɨzim inigham? ");
INSERT INTO msy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","An obarir nguazim ko bulmakaubar buariba uaghan dar akuraghan kogham. Kamaghɨn amizɨ, me a makuni. Tina kuarimning iti, an oragh.” ");
INSERT INTO msy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ezɨ arazir kurabagh amir gumaziba ko dagɨaba isir gumaziba, me Iesus baraghasa anekuvagha iti. ");
INSERT INTO msy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ezɨ Farisiba ko Judan arazibagh fofozir gumaziba an atara a mɨgɨa ghaze, “Gumazir kam gumazir arazir kurabagh amiba ko mɨgɨa me koma api.” ");
INSERT INTO msy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ezɨ Iesus akar isɨn zuir kamɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ian tav 100 pla sipsipba ikɨtɨ tam oveghtɨma, a 99 pla ateghtɨ da puram azenan ikɨ damɨtɨ, eghtɨ a mangɨ ovengezim buri mangɨ, an apighɨvɨra gɨvagham? ");
INSERT INTO msy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Egh anan apighɨva bar akuegh a isi uan dɨpɨzim datɨgh a gisaghpugh ngun mangam. Egh a uan namakaba ko an boroghɨn itir darazir diagh me akuvagh, egh kamaghɨn mɨkɨmam, ‘Kɨ uan sipsipɨn ovengezim uam an api! Ia izɨ. E a givarvaram.’ ");
INSERT INTO msy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kɨ ia mɨgei, kamaghɨra enselba gumazir kuram bagha agoir agorogem bar 99 plan derazir gumazir kabagh afiragham. Gumazir kuram a navim girazɨ ezɨ 99 pla gumaziba me ghaze me dera egha navibagh irazir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Egh amizitam 10 pla wan Kina ikɨtɨ, tam oveghtɨma, a manmaghɨn damuam? A lam daborogh, egh dɨpenim aviva a buri mangɨ, an apighɨvɨra gɨvagham. ");
INSERT INTO msy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Egh an apigh, egh uan namakaba ko an boroghɨn itir darazir diagh me akuvagh kamaghɨn me mɨkɨmam, ‘Kɨ uan ovengezir wan Kina batogha gɨfa. Ia na ko e a givarvaram.’” ");
INSERT INTO msy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Egha Iesus ghua kamaghɨn mɨgei, “Kɨ ia mɨgei, gumazir arazir kurabagh amitam navim giraghtɨ, ia nguazimɨn a givarvara akongezɨ moghɨn Godɨn enselba Godɨn Nguibamɨn a givarvaram.” ");
INSERT INTO msy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Gumazir mam otarir pumuning iti. ");
INSERT INTO msy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ezɨ dozim kamaghɨn uan afeziam mɨgei, ‘Afeziam, nɨ ga bagha tuirazir biziba nananaba na danɨngigh.’ Ezɨ aningɨn afeziam uan biziba aning bagha da tuira. ");
INSERT INTO msy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ezɨ a mong gɨn uan biziba akuvagha da inigha saghon itir nguibar mamɨn ghu. Egha nguibar kamɨn ikiava pura tintinimɨn arazir kurabagh amima, an dagɨaba bar gɨfa. ");
INSERT INTO msy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ezɨ an dagɨaba bar gɨvazɨma, ezɨ nguibar a itir kam dagheba puvatɨzir dughiam oto. Ezɨ a ua bizitam itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kamaghɨn amizɨ, a ghua nguibar kamɨn itir gumazir mamɨn ingarasa a bato. Ezɨ a anemadazɨ a ghua an dabar gara dar akuagh api. ");
INSERT INTO msy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ezɨ gumazitam daghetam a ganɨngizɨ puvatɨ. Kamaghɨn amizɨ, a dabar gari da nguezibar mɨseviba api. Ezɨ a uaghan tabar amasa bar ifonge. ");
INSERT INTO msy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ezɨ datɨrɨghɨn nɨghnɨzir aghuarim an izima, a kamaghɨn mɨgei, ‘Nan afeziamɨn ingangarir gumaziba dagher avɨriba iti. Ezɨ kɨ kagh mɨtiriam bangɨn aremegham. ");
INSERT INTO msy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Kɨ ti uamategh uan afeziam bagh mangɨ kamaghɨn a mɨkɨmam, “Afeziam, kɨ arazir kuramɨn God ko nɨ gami. ");
INSERT INTO msy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kɨ datɨrɨghɨn gumazir aghuim puvatɨ. Eghtɨ nɨ borim na darɨghan markɨ. Nɨ na ateghtɨ kɨ pura nɨn ingangarir gumazimɨn mɨn ikiam.” ’ ");
INSERT INTO msy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Egha a dɨkavigha uan afeziam bagha zui. “Ezɨ a saghon izavɨra itima, an afeziam an apigha bar an apangkufi. Egha an a bagha ivegha ghua uan agharimningɨn a muigha an tori. ");
INSERT INTO msy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ezɨ an otarim kamaghɨn a mɨgei, ‘Kɨ arazir kuram God ko nɨ gami. Kɨ ua gumazir aghuim puvatɨ, nɨ borim na darɨghan markɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ezɨ an afeziam kamaghɨn uan ingangarir gumazibav gei, ‘Ia zuamɨra! Korotiar bar aghuir ruarim inigh izɨva a darugh. Egh ring an dafarim darugh, egh dagarir asuaba a daghuigh! ");
INSERT INTO msy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","24","Nan borim ovegha ua iti. Egha ovengezɨ e uam an api. Kamaghɨn ami, ia mangɨ bulmakaun nguzir mɨkarzim sara itim a inigh izɨva a mɨsuegh e anemɨva a givarvaram.’ Egha me a givarvara isam gami. ");
INSERT INTO msy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ezɨ dughiar kamɨn otarir ekiam azenibar ikegha izi. A dɨpenimɨn boroghɨn iza orazi, me ighiabagh amua izi ighiam gami. ");
INSERT INTO msy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ezɨ a uan afeziamɨn ingangarir gumazir mamɨn diagha an azara, ‘Marazi tizim gami?’ ");
INSERT INTO msy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ezɨ a an akam ikara, ‘Nɨn dozim uamategha ize. An aremezɨ puvatɨgha deravɨra ikiava uamatenge. Kamaghɨn, nɨn afeziam a bagha bulmakaun nguzir mɨkarzim sara itim mɨsoke.’ ");
INSERT INTO msy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Ezɨ an otarir ekiam atarava dɨpenimɨn aven mangan aghua. Ezɨ an afeziam azenan ghua aven mangasa a gakaghoravɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ezɨ a uan afeziamɨn akam ikara, ‘Nɨ gan! Kɨ azenir kabar kɨ pura ingangarir gumazir kɨnimɨn ikia pura nɨn ingara, egha nɨn akaba batozir puvatɨ. Ezɨ nɨ bar dughiatamɨn kɨ uan namakaba ko ikɨ bar akueghasa nɨ memen nguzitam na ganɨngizɨ puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ezɨ nɨn otarir kam arazir kurabagh amua amiziba ko ikia uan dagɨaba a gɨvagha izezɨ, nɨ bulmakaun nguzir mɨkarzim sara itim a bagha a mɨsoke!’ ");
INSERT INTO msy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ezɨ afeziam kamaghɨn a mɨgei, ‘Nan otarim, nɨ zurara na ko iti. Ezɨ nan biziba da nɨn biziba. ");
INSERT INTO msy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nɨn dozim ovegha ua dɨkafi. Egha an ovengezɨ e uam an api. Kamaghɨn amizɨ, e a bagh isam gamuava ivarvari.’” ");
INSERT INTO msy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Egha Iesus kamaghɨn uan suren gumazibav gei, “Dughiar mamɨn dagɨaba bar avɨrasemezir gumazir mam, an ingangarir gumazibar dapanim iti. An ingangarir gumaziba a mɨgɨa ghaze, ‘Nɨn gumazir dapanim nɨn dagɨaba pura da makuri.’ ");
INSERT INTO msy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ezɨma an an diazɨma an aven ghuzɨma an an azangsɨsi, ‘Nɨ bizir tizim gamizɨma kɨ nɨ baraki? Nɨ uan ingangarimɨn aven nɨ amizir bizibar gun mɨgeir akɨnafarim na danɨngigh. Ezɨ bizir kam bagh nɨ ua gumazir dapanimɨn ikian kogham.’ ");
INSERT INTO msy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ezɨma gumazibar dapanim uabɨra uabɨ mɨgei, ‘Nan gumazir ekiam, nan ingangarimɨn na gɨvazɨma, kɨ manmaghɨn damuam? Egha kɨ nguazim gɨkuamin gavgaviba puvatɨgha, biziba bagh azangsɨghan aghumsɨki. ");
INSERT INTO msy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ezɨ kɨ fo, kɨ manmaghɨn damuam, nan gumazir ekiam ingangarimɨn na gɨvaghtɨma, gumaziba na mɨkɨmtɨma kɨ men dɨpenibar mangam.’ ");
INSERT INTO msy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“A fo, gumazir maba pura gumazir ekiamɨn biziba da ini, me tɨghar an biziba ua da ikarvagham. Eghava a gumazir kaba vaghvagha men deima me aven zui. Eghava a faragha zuimɨn azara, ‘Nɨ manmaghɨn nan gumazir ekiam da biziba ini?’ ");
INSERT INTO msy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ezɨma a kamaghɨn mɨgɨa ghaze, ‘Kɨ 800 pla dram wel ini.’ Ezɨma gumazir dapanim kamaghɨn a mɨgɨa ghaze, ‘Nɨ uan akɨnafarim inigh zuamɨra daperagh 400ɨn an osirigh.’ ");
INSERT INTO msy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ezɨma a ua mavɨn azara, ‘Ezɨ nɨ manmaghɨn nan gumazir ekiam da biziba ini?’ Ezɨma a ghaze, ‘100 bek plaua.’ Ezɨma a kamaghɨn a mɨgei, ‘Nɨ uan akɨnafarim inighɨva 80 osirigh.’ ");
INSERT INTO msy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Nguazir kamɨn gumaziba me amir ingangariba me bar dagh fo. Egha angazangarimɨn itir gumaziba bar me gafira. Ezɨ kamaghɨn gumazir ekiam gumazir dapanim amizir arazim gɨfogha, egha gumazir dapanir kurar kamɨn ziam fe. A gumazir nɨghnɨzir aghuim itimɨn arazim gami. ");
INSERT INTO msy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Kɨ ia mɨgei, ia nguazir kamɨn dagɨar kuram gumazibar akuravagh me namakabar amu. Eghtɨ dughiar da gɨvamim otoghtɨma, God nɨ inightɨma nɨ mangɨ ikɨ mamaghɨra ikiamin nguibamɨn mangam. ");
INSERT INTO msy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Egh tina bizir doziba deraghavɨra dar gari, a uaghan bizir ekiaba deraghvɨra dar ganam. Egha tina deraghavɨra bizir dozibar garir puvatɨ, a uaghan bizir ekiaba deraghavɨra dar ganan kogham. ");
INSERT INTO msy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Egh ia nguazir kamɨn dagɨar kuram deragh an ganan koghtɨma, tina guizbangɨn biziba ia danɨngtɨma ia dar ganam? ");
INSERT INTO msy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Egh ia gumazir igharazimɨn biziba deraghvɨra dar ganan koghtɨma, tina ian biziba ia danɨngam? ");
INSERT INTO msy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ingangarir gumazitam ingangarir gumazir ekiar pumuning bagh ingaran kogham. A tavɨn aghuagh egh tav gifuegham, o a tav baghɨvɨra ikɨ egh tav akɨrim a gasaragham. Ia uaghara God ko dagɨaba bagh ingaran kogham.” ");
INSERT INTO msy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ezɨ Farisin dagɨaba bagha bar ikuvizɨba bizir kaba baregha Iesusɨn garav mɨnbaba sighsiravɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ezɨma a kamaghɨn me mɨgei, “Ia gumazamizibar damazibar bizibagh amua ghaze ia dera. Ezɨ God ian nɨghnɨzibagh fo. Ezɨ bizir gumazamiziba gari men damazibar bar deraziba, da Godɨn damazimɨn bar ikufi.” ");
INSERT INTO msy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Egha Iesus ghua kamaghɨn mɨgei, “Moses Osirizir Araziba koma Godɨn akam inigha izir gumazibar akam akura mamaghɨra ikia ghua Jonɨn dughiamɨn tu. Ezɨ dughiar kamɨn, Jon God Bizibagh Ativamin Dughiamɨn akar aghuim kuri. Ezɨ gumaziba ko amiziba bar moghɨra dughiar kamɨn aven mangasa uari ghasaghasagha uari munakuri. ");
INSERT INTO msy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nguazim koma overiam gɨvagham. Eghtɨ God osizirir arazibar akar otevitam, mɨseveghɨrɨghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ezɨ nɨ gumazir manam uan amuim ategha amizir igharazimɨn ikɨva mati, nɨ amizir munamɨn mɨkarzim okeme. Ezɨ nɨ gumazir manam nɨ amizir me ikegha taghizimɨn iti, nɨ uaghan amizimɨn mɨkarzim okeme.” ");
INSERT INTO msy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Dughiar mam, gumazir dagɨaba avɨrasemezir mam iti. Egha a korotiar bar aghuir aghevim arugha dagher aghuiba ikia zurara isabagh amua da apa mamaghɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ezɨma an tiar akamɨn, gumazir puv biziba bagha azangsɨzir mam, duaba bar a gizɨvazɨma a irɨghav iti, an ziam Lasarus. ");
INSERT INTO msy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Egh gumazir dagɨaba avɨrasemezir kamɨn dagher oteviba dakozimɨn apengan suaghiriba, a dar amasa gara iti. Ezɨma afiaba uaghan izava an duaba ozɨsi. ");
INSERT INTO msy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ezɨ gumazir puv biziba bagha azangsɨzim aremeghamin dughiam otozɨma, an areme. Ezɨma enselba a inigha ghua Abrahamɨn mɨn anetɨ. Ezɨma gumazir dagɨaba avɨrasemezim uaghan aremezɨma me anefa. ");
INSERT INTO msy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ezɨ a helɨn ikia mɨzazir kuram isi. Egha a kogha pɨn garava Abrahamɨn garima, a bar saghon itima Lasarus an mɨn iti. ");
INSERT INTO msy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Egha an Abrahamɨn dei, ‘Afeziam Abraham, nan apangkufigh. Kɨ mɨzazim isava avimɨn iti. Ezɨ bizir kam bagh Lasarus amadaghtɨma, a uan dafarir puzim dɨpam darugh nan mɨzem orangigh.’ ");
INSERT INTO msy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ezɨma Abraham an dɨmdiam ikara, ‘Otarim, nɨ bizir kam ginɨrɨ, nɨ angamra itir dughiamɨn, nɨ bizir aghuiba iti. Ezɨ Lasarus bizir kuraba iti. Ezɨma a datɨrɨghɨn kagh deraghavɨra itima nɨ mɨzazir kuram isi. ");
INSERT INTO msy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ezɨ ua bizir mam, ga ko no en tɨzimɨn ruzir konim e abɨki. Ezɨ te kagh ikegh nɨ bagh mangɨsɨ iburagham, o tina magh ikegh kagh izɨsɨ iburagham.’ ");
INSERT INTO msy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Ezɨ dagɨaba avɨrasemezir gumazim Abrahamɨn akam pamtemɨn a ikara, ‘Kɨ aveghbuar 5 pla iti. Kamaghɨn amizɨ, Afeziam, kɨ pamtemɨn nɨn azangsɨsi, Lasarus amadaghtɨma a nan afeziamɨn dɨpenimɨn mangɨ. Egh me mɨkemeghtɨ, me kɨ itir nguibar mɨzaziba isir kamɨn izan markɨ.’ ");
INSERT INTO msy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ezɨma Abraham an akam ikara, ‘Me Moses koma Godɨn akam inigha izir gumazibar osiziriba men iti. Ezɨ me men akaba baragh.’ ");
INSERT INTO msy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ezɨma an Abraham mɨgei, ‘Puvatɨ, Afeziam. Gumazir ovengezitam ua dɨkavigh me bagh mangɨtɨma, me navibagh iragham.’ ");
INSERT INTO msy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ezɨma Abraham kamaghɨn a mɨgei, ‘Me Moses koma Godɨn akam inigha izir gumazibar akaba baraghan koghtɨma, tav aremegh ua dɨkavigh izɨ, me mɨkɨmtɨma, me nɨghnɨzir gavgavimɨn an akabar ikian kogham.’” ");
INSERT INTO msy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Egha Iesus kamaghɨn uan suren gumazibav gei, “Bizir gumazamizibagh amima me arazir kurabagh amiba. da guizbangɨra izam. Ezɨ gumazir dagh ami da otivim, a bar kuvigham. ");
INSERT INTO msy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A ikɨva borir katam arazir kuratam an akagham, kamaghɨn ia a inighɨva dagɨam an fɨrim ikeghɨva a isɨ ongarim mɨkɨnightɨ, an aremeghtɨ, kamaghɨn deragham. ");
INSERT INTO msy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kamaghɨn amizɨma ia deravɨra uari bagh gan. “Eghɨva nɨn aveghbuam arazir kuratam damightɨma, nɨ pamtem a mɨkɨm suam, nɨ da atakigh. Eghtɨ a navim gɨraghtɨma, nɨ an arazir kuraba gɨn amada. ");
INSERT INTO msy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eghɨva a 7 plan dughiabar arazir kurabar nɨ damighɨva, egh 7 plan dughiabar uamategh nɨ bagh izɨ kamaghɨn mɨkɨmam, ‘Kɨ navim gɨra,’ nɨ an arazir kuraba da gɨn amadagh.” ");
INSERT INTO msy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ezɨ aposelba kamaghɨn Iesus mɨgei, “Nɨ en nɨghnɨzir gavgavim damightɨma an ekefegh!” ");
INSERT INTO msy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ezɨma a kamaghɨn me mɨgei, “Egh ian nɨghnɨzir gavgavim suvigh zuravarim mastetɨn ovɨzitamɨn mɨn ikɨtɨma, ia temer kam mɨkɨm suam, ‘Nɨ uabɨ asighɨva egh biba sara mangɨva ongarimɨn uabɨ ekaragh,’ eghtɨ a ian akam baragham.” ");
INSERT INTO msy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Egha Iesus mɨgɨa ghua kamaghɨn mɨgei, “Ian tav ingangarir gumazitam an azenimɨn ingari o sipsipbar gari. Ingangarir gumazim azenibar ikegh izɨtɨma, eghtɨ a suam, nɨ izɨ daperagh damɨ? Puvatɨ. Ia kamaghɨn mɨgeir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Gumazir dapanim kamaghɨn mɨkɨmam, nɨ na bagh dagheba isamigh uan inim kegh da tuigh faragh na danightɨ kɨ dar amam, eghtɨ nɨ gɨn damɨ. ");
INSERT INTO msy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","A ingangarir gumazim amizir bizir kaba bagha a mɨnabagham, o puvatɨgham? Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ezɨ ia uaghan, God damuasa ia mɨkemezir biziba bar dagh ami, egh suam, E pura ingangarir gumazir kuraba, ingangarir Ekiam e ganɨngiziba e pura dagh ami.” ");
INSERT INTO msy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ezɨ Iesus Jerusalemɨn ghuava, Samaria koma Galilin Distrighɨn tɨzimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ezɨ a nguibar mamɨn aven zuima, 10 pla lepa itir gumaziba a bato. Me mong saghon tuivighav ikiava, ");
INSERT INTO msy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","tiarir arozimɨn an dei, “Iesus, Gumazir Ekiam, en apangkufigh.” ");
INSERT INTO msy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ezɨma a men apighava, kamaghɨn me mɨgei, “Ia mangɨva, uari isɨva Godɨn ofa gamir gumazibar akagh.” Ezɨma me me bagha ghua tuavir arɨzimɨn men mɨkarziba zuegha dera ");
INSERT INTO msy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ezɨ men mav, uabɨn garima an arɨmariam gɨvazɨma a uamategha izava pamtemɨn Godɨn diava egha an ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Egha Iesusɨn suemningɨn apengan irɨghava uan guam nguazim mɨtuaghava, Iesus a gamizir bizim bagha a mɨnaba. A Samarian gumazimra. ");
INSERT INTO msy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ezɨ Iesus kamaghɨn azara, “Ezɨ kɨ 10 plan gumazir kaba akɨris ti, o puvatɨ? Ezɨ 9 pla managh iti? ");
INSERT INTO msy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ezɨ Judan gumazitam ua iza, a Godɨn ziam fe, o puvatɨ? Gumazir saghuiamɨn izezim uabɨra izava Godɨn ziam fe.” ");
INSERT INTO msy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Eghava a kamaghɨn a mɨgei, “Nɨ dɨkavigh mangɨ. Nɨn nɨghnɨzir gavgavim nɨ gamizɨma, nɨ dera.” ");
INSERT INTO msy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Dughiar mamɨn Farisin gumaziba Iesusɨn azara, “God Bizibagh Ativamin Dughiam mana dazoghɨn izam?” Ezɨma Iesus men akam ikara, “Ia orasi, God Bizibagh Ativamin Dughiamɨn arazaraziba ia uan damazibar an ganighan kogham. ");
INSERT INTO msy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Eghtɨ gumazitam kamaghɨn mɨkɨman kogham suam, ‘A kara,’ o ‘A muna.’ Ezɨ God Bizibagh Ativamin Dughiam, a ian navir averiamɨn aven iti.” ");
INSERT INTO msy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Egha Iesus uan suren gumazibav gei, “Dughiam izɨtɨma nɨ Gumazibar Otarim izamin dughiam a bagh gansɨ damuva avegham. ");
INSERT INTO msy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","24","Gumaziba ia mɨkɨmam, ‘Ara muna!’ o ‘Ara kara!’ Ezɨ ia fo, Gumazibar Otarim izamin dughiam an onɨmarimɨn mɨn taghtagham. Eghtɨma an angazangariba bar overiamɨn ruaghatevimning uagharam aningɨn tagham. Eghtɨ ia ivemarɨv men akaba gɨn mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Egh a faragh bizir avɨriba bagh mɨzazim inigham. Eghtɨma datɨrɨghɨn dughiar kamɨn itir gumaziba an aghuagham. ");
INSERT INTO msy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ezɨ bizir Noan dughiamɨn otiviziba, da uaghan kamaghɨn Gumazibar Otarim izamin dughiamɨn otivam. ");
INSERT INTO msy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Gumazamiziba dagheba ko dɨpaba apava, uarir ikiava mamaghɨra ikia ghua, Noa uan kurimɨn ghuavanabozir dughiam. Ezɨma aperiam izava bar me kuavareme. ");
INSERT INTO msy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Ezɨ Lotɨn dughiamɨn kamaghɨra, gumazamiziba dagheba ko dɨpaba apava, dagɨaba bagha biziba amagava, dagh ivezava, dagheba oparava dɨpenibar ingari. ");
INSERT INTO msy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ezɨ Lot Sodom ataghizir dughiamɨn, avim koma dagɨar isiba amozimɨn mɨn overiamɨn ikegha suaghira izaghɨra bar moghɨra me kuavareme. ");
INSERT INTO msy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Gumazibar Otarim azenimra izighramin dughiam biziba uaghan kamaghɨram otivam. ");
INSERT INTO msy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Eghtɨ dughiar kamɨn nɨ tina uan dɨpenimɨn avughsɨzir danganim ikɨva, egha uan biziba ataghizɨ da aven iti, nɨ da bagh magɨrɨ da inian markɨ. Kamaghɨra, tina azenibar iti, a bizir tam bagh nguibamɨn mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nɨ Lotɨn amuim gɨnɨghnɨgh! ");
INSERT INTO msy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ezɨma tina uan mɨkarzim geghufi, an aremegham. Ezɨ tina na bagha uan mɨkarzim anataki, a gɨn deraghvɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kɨ ia mɨgei, dɨmagarir kamɨn taning uaning inigh mɨsiar vamɨra dakutɨma, God tav inighɨva tav ategham. ");
INSERT INTO msy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Eghtɨ amizir pumuning uaning inigh maziaba rɨghrɨghtɨma, God tav inighɨva tav ategham.” ");
INSERT INTO msy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ezɨ me an azara, “Ekiam managhɨra?” Ezɨma a men akam ikara, “Gumazir kuaba managh iti naghɨn, taragiaba uari akuvagham.” ");
INSERT INTO msy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Egha Iesus akar isɨn zuir mamɨn uan suren gumazibav gei, egh men akaghtɨ, me zurara God ko mɨkɨm mamaghra ikiam. Egh amɨraghan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Egha a kamaghɨn mɨgei, “Nguibar ekiar mamɨn aven jasɨn mam iti, a Godɨn atiatir puvatɨ. Egha gumazibagh nɨghnɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ezɨ amuir odiarir mam uaghan nguibar ekiar kamɨn iti. Ezɨ gumazir mam pazava a gamua osɨmtɨziba a garɨsi. Ezɨ a jas bagha zurara izava a mɨgei, ‘Nɨ kotiamɨn nan akuragh.’ ");
INSERT INTO msy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Ezɨma dughiar avɨrir maba a bizitam gamizir puvatɨ. Eghava abuan a uabɨra uabɨ mɨgei, ‘Kɨ Godɨn atiatir puvatɨ. Egha kɨ gumazibagh nɨghnɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ezɨ amuir odiarir kam dughiar avɨribar na bagha izi. Kɨ bar amɨra. Kamaghɨn amizɨ, kɨ ua bagh zuamɨra an osɨmtɨzim akɨrigham, eghtɨ a ua izɨ na damutɨma kɨ bar amɨraghan kogham!’” ");
INSERT INTO msy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Egha Iesus mɨgɨa ghaze, “Ia jasɨn kuramɨn mɨgɨrɨgɨam baragh. ");
INSERT INTO msy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ezɨ Godɨn inabaziba, me dɨmagariba ko aruebar a bagha araima, a men osɨmtɨziba bagha iza a da akɨram, o puvatɨgham? A me ataghraghtɨ me pura mangam? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kɨ ia mɨgei, a men osɨmtɨzibar ganɨva, zuamɨra men akuragham. Kamaghɨn amizɨma, Gumazibar Otarim uamateghamin dughiamɨn, a gantɨ, nguazimɨn itir gumazamiziba nɨghnɨzir gavgavim an ikiam, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Gumazir mabara uarira uan ziaba fava egha igharaz daraziv gɨa ghaze, me derazir puvatɨ. Ezɨ Iesus kamagh amir gumaziba bagh akar isɨn zuir kam gami, ");
INSERT INTO msy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Gumazir pumuning God ko mɨkɨmasa Godɨn Dɨpenimɨn ghu, aningɨn mav Farisi, ezɨ mav dagɨaba isir gumazim. ");
INSERT INTO msy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ezɨ Farisin gumazim dɨkavigha tugha uabɨra ua bagha God kamaghɨn a mɨgei, ‘Kɨ nɨ mɨnaba, kɨ gumazir mabar mɨn amir puvatɨ. Me biziba okɨava, arazir kurabagh amuava egha martiar amiziba okɨa me koma akui. Egha kɨ uaghan dagɨaba isi gumazir kamɨn mɨn amir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kɨ wighɨn vamɨran dughiar pumuningɨn nɨ ko mɨkɨmasa dagheba ataghrasi. Egha bizir kɨ isiba, kɨ tongɨra da tuiragha uaghan nɨ ganɨdi.’ ");
INSERT INTO msy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ezɨ dagɨaba isir gumazim mong munamaghɨn tu. Egha a kogha overiamɨn gari puvatɨgha uan evarim mɨsogha kamaghɨn mɨgei, ‘Kɨ gumazir kuram, God nɨ nan apangkufigh!’ ");
INSERT INTO msy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kamaghɨn amizɨma kɨ guizbangɨra ia mɨgei, gumazir dagɨaba isir kam, a Godɨn damazimɨn deragha egha dɨpenimɨn ghu. Ezɨ igharazim puvatɨ. Te uarira uan ziaba fe, God me abɨraghtɨ, me apengan ikiam. Eghtɨ te apengan iti, God me feghtɨ me ziar ekiaba iniam.” ");
INSERT INTO msy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ezɨ gumazamiziba borir doziba Iesus dafarimning me darɨghasa, me inigha izi. Ezɨma an suren gumaziba kamaghɨn ganigha egha men atari. ");
INSERT INTO msy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ezɨ Iesus borir dozibar diazɨ me a bagha zuima a mɨgɨa ghaze, “Nɨ tina God Bizibagh Ativamin Dughiamɨn aven ikɨsɨ, borir dozir kabar mɨn ikɨ. Kamaghɨn amizɨma borir doziba ateghtɨma me na bagh izɨ, egh men anogoroghan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kɨ guizbangɨra ia mɨgei, gumazitam borir dozir kabar mɨn God Bizibagh Ativamin Dughiam inighan koghɨva, egh an aven mangan bar iburagham.” ");
INSERT INTO msy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ezɨ Judabar gumazir dapanir mam Iesusɨn azara, “Tisan Aghuim, kɨ manmaghɨn damigh zurara itir ikɨrɨmɨrir aghuarim iniam?” ");
INSERT INTO msy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ezɨ Iesus an akam ikara, “Nɨ manmagh sua gumazir aghuim na garɨsi? Gumazir aghuitam itir puvatɨ. God uabɨra gumazir aghuimra. ");
INSERT INTO msy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nɨ God Moses ganɨngizir arazim gɨfo, ‘Nɨ gumazim mɨsueghtɨ an aremeghan markɨ, nɨ poroghamiba uari bakeir arazim damuam markɨ, nɨ gumazir igharazimɨn biziba okɨman markɨ, nɨ bizibagh ifaran markɨ, nɨ ua bagh biziba inisɨ gumazibagh ifaran markɨ, nɨ uan afeziam ko amebamɨn apengan ikɨ aningɨn akaba baragh.’” ");
INSERT INTO msy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ezɨ a kamaghɨn Iesus mɨgei, “Kɨ fomɨram aghɨrimra ikiava arazir kabagh amua iza datɨrɨghɨn ikia kati.” ");
INSERT INTO msy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ezɨma Iesus kamaghɨn oregha, egha a mɨgei, “Nɨ bizir vamɨra nɨ tɨghar a damuam. Bizir nɨ itiba bar da amangighɨva dagɨaba inigh, egh gumazir biziba puvatɨzibar anɨngigh. Egh nɨ Godɨn Nguibamɨn bizir aghuariba iniam. Egh, nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","A biziba bar avɨraseme, kamaghɨn amizɨma, a Iesusɨn akam baregha bar oseme. ");
INSERT INTO msy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ezɨ Iesus an gara egha a mɨgɨa ghaze, “Gumazir biziba avɨrasemeziba, me God Bizibagh Ativamin Dughiamɨn mangɨsɨ bar iburagham! ");
INSERT INTO msy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelɨn tam iniba isair dɨkonir torimɨn aven mangɨsɨ ingangarir dafam damigh aven mangam. Eghtɨ gumazir biziba avɨrasemeziba, me God Bizibagh Ativamin Dughiamɨn mangɨsɨ guizbangɨra bar iburagham!” ");
INSERT INTO msy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ezɨ marazi kamaghɨn oregha an azara, “Kamaghɨn damightɨma, tinara zurara itir ikɨrɨmɨrir aghuir kam iniam?” ");
INSERT INTO msy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ezɨ Iesus me ikara, “Bizir kaba gumazimɨn bar osemegham. Bizir kaba Godɨn osemezir puvatɨ. A biziba bar dagh ami.” ");
INSERT INTO msy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ezɨ Pita a mɨgei, “Nɨ ge, e bizir e itiba bar da ategha, nɨn gɨn ize.” ");
INSERT INTO msy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ezɨ Iesus kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, gumazitam God Bizibagh Ativamin Dughiam bagha uan dɨpenim, o uan amuim, o aveghbuaba, o ameboghfeziaba, o boriba ataki, ");
INSERT INTO msy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","egh datɨrɨghɨn itir dughiar kamɨn God bizir avɨriba me faragha inizir bizibagh afiragh me danɨngam. Egh dughiar gɨn otivamim me zurara itir ikɨrɨmɨrir aghuarim iniam.” ");
INSERT INTO msy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Egha Iesus 12 plan suren gumaziba inighava me uarira ikiava a me mɨgei, “Ia oragh! E nguibar ekiam Jerusalemɨn ghuavanadi. Eghtɨ Godɨn akam inigha izir gumaziba, Gumazibar Otarimɨn gun mɨkemezir osizirir biziba bar, guizbangɨra otogham. ");
INSERT INTO msy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Eghtɨ me a isɨ Kantrin Igharazibar Gumazibar dafaribar arɨgham. Eghtɨ me a dɨpova a mɨkɨmam. Egh aghumsɨzir arazibar a damuam. Egh a giparɨva, eghɨva a ifozoregh egh a mɨsueghtɨ an aremegham. ");
INSERT INTO msy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Eghtɨ dughiar mɨkezim a ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ezɨma an suren gumaziba bizir katam gɨfozir puvatɨ, a bizir tizim mɨgei. Dar mɨngarim men monge, ezɨ me bar fozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Egha Iesus Jerikon boroghɨra izima, gumazir damazir kurar mam tuavir mɨriamɨn aperaghav ikia biziba bagha azangsɨsi. ");
INSERT INTO msy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Egha an orazima gumazamizir avɨrim iza zuima, a men azara, kar tizim. ");
INSERT INTO msy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ezɨ me a mɨgɨa ghaze, “Nasaretɨn gumazim Iesus iza zui.” ");
INSERT INTO msy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ezɨ a dia mɨgei, “Iesus, Devitɨn Otarim, nɨ nan apangkufigh!” ");
INSERT INTO msy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ezɨ faragha zuiba me an atarava egha a mɨgɨa ghaze, nɨ nɨmɨra ikɨ. Ezɨ a bar pamtem dia mɨgei, “Devitɨn ovavim, nɨ nan apangkufigh!” ");
INSERT INTO msy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ezɨ Iesus tugha akar gavgavim gumazibav gɨa ghaze, “Gumazir munam inigh na bagh izɨ.” Ezɨ a roghɨra izima, Iesus an azara, ");
INSERT INTO msy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kɨ tizim nɨ bagha a damuasa, nɨ ifonge?” Ezɨ an a ikara, “Ekiam, kɨ ganasa ifonge.” ");
INSERT INTO msy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ezɨ Iesus a mɨgɨa ghaze, “Nɨ gan. Nɨn nɨghnɨzir gavgavim nɨn akurazɨ, nɨ dera.” ");
INSERT INTO msy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ezɨ a zuamɨra gari. Egha Iesusɨn gɨn ghua Godɨn ziam fe. Ezɨma gumazamiziba an ganigha, me uaghan Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ezɨ Iesus Jerikon nguibamɨn ghuava, aneteghasa tuavimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gumazir mam nguibar kamɨn iti, an ziam Sakius. A dagɨaba isir gumazibar gumazir dapanim, a dagɨaba bar avɨraseme. ");
INSERT INTO msy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A Iesusɨn ganasa, a manmaghɨra garir gumazim. Sakius bar gumazir otevim, egha gumazamizir avɨrimɨn tongɨn iti. Egha kamaghɨn a Iesusɨn garir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A fo, Iesus tuavir kamra izam. Kamaghɨn amizɨ, a ivegha faragha ghua, Iesusɨn ganasa temer fighɨn ghuavanabo. ");
INSERT INTO msy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ezɨ Iesus danganir kamɨn oto. Egha kogha temer kam gisɨn gara, kamaghɨn Sakiusɨn mɨgei, “Sakius nɨ zuamɨra izighirɨ. Datɨrɨghɨn kɨ nɨn dɨpenimɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ezɨ a zuamɨra izaghrɨghava, bar akonge. Egha Iesus inigha uan dɨpenimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ezɨ gumaziba bar an ganigha, egha me kamaghɨn mɨgɨava ngavamadi, “A ghua gumazir kuramɨn dɨpenimɨn iti.” ");
INSERT INTO msy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Me dɨpenimɨn ikiava, Sakius tughava, kamaghɨn Ekiam mɨgei, “Ekiam, Nɨ oragh! Datɨrɨghɨn kɨ uan biziba bar da tuiragham. Egh taba kɨ gumazir biziba puvatɨzibar anɨngam. Egh kɨ gumazir tam gifaraghɨva, an bizitam okemeghɨva, kɨ datɨrɨghɨn uamategh bizir pumuning ko pumuning a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ezɨ Iesus kamaghɨn a mɨgei, “Gumazir kam a uaghan Abrahamɨn ovavim. Kamaghɨn amizɨ, datɨrɨghɨn God dɨpenir kamɨn gumazamiziba bar men akura. ");
INSERT INTO msy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gumazibar Otarim, gumazir ovengeziba bagha ruiava men akurvaghasa ize.” ");
INSERT INTO msy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Gumazamiziba ikia Iesus barazima, a mɨgei. A Jerusalemɨn boroghɨn itima, me ghaze, datɨrɨghɨra God Bizibagh Ativamin Dughiam otogham. Kamaghɨn amizɨma, an akar isɨn zuir mam me mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A kamaghɨn me mɨgei, “Gumazir aruar mam nguibar saghuiamɨn mangasa, eghtɨ me a damightɨma an atrivimɨn ikiam. A gɨn uamategh uan nguibamɨn izeghɨva, men ganam. ");
INSERT INTO msy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A mangasa, a uan ingangarir gumazir 10 plan diagha, 20 kina, 20 kina bar moghɨra me rome. Egha kamaghɨn me mɨgei, ‘Ia dagɨar kaba inighɨva uari bagh dagɨar ingangaribar amu ikɨtɨ, kɨ uamategham.’ ");
INSERT INTO msy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“An apengan itir gumaziba me bar navir kuram an iti. Kamaghɨn amizɨ, me akam inigha zuir gumaziba amadazɨma me nguibar gumazir aruam ghuzɨmɨn ghu. Me kamaghɨn mɨgei, ‘E gumazir kam en atrivimɨn otivan, e aghua.’ ");
INSERT INTO msy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ezɨ gumazir igharaziba gumazir aruar kam a gamizɨma an atrivimɨn otogha, egha gɨn uamatenge. A uamategha izegha, kamaghɨn me mɨgei, ‘Gumazir kɨ fomɨra dagɨaba anɨngiziba, men diagh. Kɨ foghasa me manmaghɨn nan dagɨabagh isɨn dagɨaba ini.’ ");
INSERT INTO msy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Ezɨma gumazir faragha zuim iza kamaghɨn mɨgei, ‘Ekiam, kɨ nɨn 20 kinan kamɨn dagɨar ingangarim gamighava a gisɨn 200 kina ini.’ ");
INSERT INTO msy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ezɨ atrivim kamaghɨn a mɨgei, ‘Nɨ nan ingangarir gumazir aghuim, egha nɨ ingangarir bar aghuim gami. Nɨ bar deraghvɨra bizir muziarim gami, kamaghɨn kɨ datɨrɨghɨn bizir ekiam nɨ danightɨma, nɨ nguibar ekiar 10 plan ganam.’ ");
INSERT INTO msy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ezɨma ingangarir gumazir igharazim iza mɨgei, ‘Ekiam, kɨ nɨn 20 kinan kamɨn dagɨar ingangarim gamigha datɨrɨghɨn a gisɨn 100 kina ini.’ ");
INSERT INTO msy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ezɨ atrivim a mɨgei, ‘Kɨ nɨ atɨghtɨ nɨ nguibar ekiar 5 plan ganam.’ ");
INSERT INTO msy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ezɨ ingangarir gumazir mɨkezim iza mɨgei, ‘Ekiam nɨn 20 kina ikia kati. Kɨ a isa inir avɨzimɨn a nomkezɨma, a kati. ");
INSERT INTO msy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kɨ nɨ gɨfo, nɨ gumazir atarim. Gumazir igharaziba amir biziba, nɨ pura da isi. Egha dagher me opariziba, nɨ uaghan pura da isi. Kamaghɨn kɨ nɨn atiati.’ ");
INSERT INTO msy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Ezɨma atrivim kamaghɨn ingangarir gumazim mɨgei, ‘Nɨ ingangarir gumazir kuram! Nɨn akamra kɨ nɨ tuisɨgham. Nɨ kamaghɨn na gɨnɨghnɨsi, kɨ ti gumazir atarim. Egha kɨ gumazir igharaziba amir biziba, kɨ ti pura da isi. Egha dagher me opariba, kɨ ti uaghan pura da isi? ");
INSERT INTO msy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Manmaghɨn amizɨma, nɨ nan dagɨaba benk gatɨzɨ puvatɨ, eghtɨ kɨ uamategh izɨva ua da iniva dagɨataba a gisɨn ua da iniam?’ ");
INSERT INTO msy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ezɨ a kamaghɨn an boroghɨn tuivighav itir gumazibav gei, ‘Ia ada 20 kina inighɨva gumazir 200 kina itim danɨngigh.’ ");
INSERT INTO msy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Me kamaghɨn a mɨgei, ‘Ekiam, a 200 kina inigha gɨfa.’ ");
INSERT INTO msy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Ezɨma a ghaze, ‘Kɨ ia mɨgei! Gumazitam bizir taba ikɨtɨ, kɨ avɨritaba uam a danigham. Eghtɨ gumazitam biziba puvatɨghɨva, eghtɨ bizir muziarim a itim, kɨ ada da inigham. ");
INSERT INTO msy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nan apaniba, kɨ men atrivimɨn ikian me nan aghua, ia me inigh kagh izɨva nan damazimɨn me mɨsueghtɨ me arɨmɨghregh.’” ");
INSERT INTO msy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iesus akar isɨn zuim gamigha gɨvagha, uan darorim gamua tuavir Jerusalemɨn ghuzim ghuavanadi. ");
INSERT INTO msy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iesus Betfage ko Betanin boroghɨn oto, mɨghsɨam Oliv gisɨn. Egha uan suren gumazir pumuning amaga, ");
INSERT INTO msy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kamaghɨn aningɨn mɨgei, “Gua nguibar munagh itimɨn mangɨ. Gua nguibar kamɨn mangɨ gantɨma donkin igiar mam me a ikezɨma, a iti. Gumazitam dughiatamɨn a gaperaghava aruizir puvatɨ. Gua an benim fɨrighɨva donki inigh kagh izɨ. ");
INSERT INTO msy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tav kamaghɨn guan azaragham, ‘Gua tizim bagha donkin kam fɨri?’, eghtɨ gua suam, ‘Ekiam ingangarim an iti.’” ");
INSERT INTO msy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Egha Iesus aning amadazɨma aning ghua garima, biziba bar moghɨra Iesus mɨkemezɨ moghɨn iti. ");
INSERT INTO msy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ezɨ aning donkin benim fɨrima, an ghuaviba aningɨn azara, “Gua tizim bagha donkin benim fɨri?” ");
INSERT INTO msy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ezɨma aning kamaghɨn a mɨgei, “Ekiam ingangarim an iti.” ");
INSERT INTO msy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Egha aning donki inigha Iesus bagha izi. Egha aning uan azenan azuir korotiar ruariba donki gisɨn da ghuani. Egha aning Iesusɨn akurazɨma a donki gisɨn apera. ");
INSERT INTO msy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","A donki gaperagha zuima, gumazamiziba uan korotiar ruariba suava tuavim mɨghuari. ");
INSERT INTO msy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","A iza danganir tuavir Olivɨn mɨghsɨamɨn ghuaghirimɨn boroghɨn izima, an gɨn aruir darazi me God amizir mirakelbar ganighava da bagha bar akongegha pamtem Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Me kamaghɨn araghasi, “God uan ziamɨn atrivim amada! God deravɨra a damu! Navir amɨrizim Godɨn Nguibamɨn iti. Ia Godɨn ziam fɨ!” ");
INSERT INTO msy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ezɨ Farisin marazi gumazamizir kabar tongɨn ikia, kamaghɨn Iesusɨn mɨgei, “Tisa, nɨ uan suren gumazibav kɨmtɨma, me nɨmɨra ikɨ! Me kamaghɨn mɨkɨman markɨ!” ");
INSERT INTO msy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ezɨ a kamaghɨn mɨgei, “Kɨ ia mɨgei, me nɨmɨra ikɨtɨma dagɨaba uari araghasam!” ");
INSERT INTO msy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iesus Jerusalemɨn boroghɨra iza, egha an gara a bagha azi. ");
INSERT INTO msy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Egha a kamaghɨn mɨgei, “Jerusalem, kɨ kamagh sua, nɨ amua datɨrɨghɨn navir amɨrizɨmɨn bizibagh foghai. Kamaghɨn amizɨ, a datɨrɨghɨn nɨn modo. ");
INSERT INTO msy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dughiam izɨtɨ, eghtɨ nɨn apaniba nguazir dɨvazim ingarightɨ, a nɨ arughtɨma, nɨ arɨmangɨghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Eghɨva nɨ Jerusalem me nɨn borir nɨn aven itiba sarama asɨghasigham. Nɨ Godɨn dughiar nɨn akuraghasa izezim, nɨ a gɨfozir puvatɨ. Bizir kam bagh dɨpenimɨn ingarizir dagɨatam, me aneteghtɨ, a tam gisɨn keghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Egha a Godɨn Dɨpenir avɨzimɨn aven ghuava, biziba amadiba me batosi. ");
INSERT INTO msy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A kamaghɨn mɨgei, “God fomɨra Aisaian akɨnafarimɨn aven kamaghɨn osiri, ‘Nan dɨpenim God ko mɨgeir dɨpenimra, ezɨ ia a gamizɨma, an okɨmakɨar gumaziba modir danganimɨn mɨn oto.’” ");
INSERT INTO msy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A zurara Godɨn Dɨpenimɨn aven men sure gami. Ezɨma ofa gamir gumazir ekiaba ko Judan arazibagh fozir gumaziba ko gumazir dapaniba, me a mɨsueghtɨ an aremeghasa. ");
INSERT INTO msy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ezɨ gumazamiziba a baraghasa bar ifongegha, bar an boroghɨn iti. Kamaghɨn amizɨ, an apaniba a mɨsoghan ibura. ");
INSERT INTO msy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Dughiar mamɨn Iesus Godɨn Dɨpenir avɨzimɨn aven ikiava, gumazamizibar sure gamuava akar aghuim akuri. Ezɨ ofa gamir gumazir ekiaba, koma Judan arazibagh fozir gumaziba, ko Judan gumazir aruaba, me izava anekufa. ");
INSERT INTO msy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Egha me kamaghɨn mɨgei, “E mɨkemegh, nɨ gavgavir manamɨn bizir kabagh ami? Tina gavgavir kam nɨ ganɨngi?” ");
INSERT INTO msy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Ezɨ Iesus kamaghɨn men akam ikara, “Kɨ uaghan azangsɨzitam ia damuasa. Ia na mɨkɨm, Jonɨn rurim, a Godɨn ize o gumazibar ize?” ");
INSERT INTO msy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ezɨ me uarira uariv gei, “E suam, ‘An rurim Godɨn ize,’ eghtɨ, a kamaghɨn mɨkɨm suam, ‘Ia manmaghɨn amigha ia nɨghnɨzir gavgavim Jon damuan aghua?’ ");
INSERT INTO msy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","E suam, ‘An rurim gumazibar ize,’ eghtɨ gumaziba dagɨabar e ginivightɨma, e arɨghregham. Me kamaghɨn fo Jon a Godɨn akam inigha izir gumazim.” ");
INSERT INTO msy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Egha me Iesus ikara, “E fozir puvatɨ, Jonɨn rurim manmaghɨn ize.” ");
INSERT INTO msy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ezɨ Iesus kamaghɨn mɨgei, “Kamaghɨra, kɨ uan gavgavim inizir tuavimɨn, gun ia mɨkemeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Egha Iesus mɨgɨavɨra ikia akar isɨn zuir kam gumazamizibav gei, “Gumazir mam wainɨn azenim oparigha, egha azenimɨn garir gumazir mabar dafarim garɨgha ghaze, me gɨn a givezam. Egha a ghua dughiar ruarimɨn saghon iti. ");
INSERT INTO msy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Egha wainɨn ovɨziba kuarir dughiamɨn a ingangarir gumazir mam amadagha ghaze, me wainɨn ovɨzir andɨzir taba a danɨngam. Ezɨ azenimɨn garir gumaziba a mɨsueghava anemadazɨma, a dafaribara uamatenge. ");
INSERT INTO msy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ezɨ a ingangarir gumazir igharazim amada, ezɨ me uaghan a mɨsuegha aghumsɨzir arazibar a gamigha, anemadazɨ a dafaribara uamatenge. ");
INSERT INTO msy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ezɨ a ua mɨkezim amadazɨ, me bar puv a mɨsuegha a isa azenim mɨkɨni. ");
INSERT INTO msy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ezɨ wainɨn azenir ghuavim uabɨra uabɨ mɨgei, ‘Kɨ manmaghɨn damuam? Kɨ uan otarir ifongezim amangam. Eghtɨ me ti a mɨsueghan kogham.’ ");
INSERT INTO msy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ezɨ wainɨn azenimɨn garir gumaziba otarir kamɨn ganigha, kamaghɨn uariv gɨa ghaze, ‘Kar otarir gɨn azenir kam iniamim. E a mɨsueghtɨ an aremeka. Eghtɨ wainɨn azenir kam enanam.’ ");
INSERT INTO msy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Egha me a isa azenim mɨkɨnigha a mɨsoghezɨma an areme.” Egha Iesus ghua kamaghɨn gumazamizibav gei, “Wainɨn azenir ghuavim manmaghɨra azenimɨn garir gumazir kabar amuam? ");
INSERT INTO msy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A izɨva azenimɨn garir gumazir kabav soghtɨ, me arɨmɨghiram. Eghtɨ a wainɨn azenim isɨva igharazibar anigam.” Ezɨ gumazamiziba bizir kam baregha mɨgei, “Bar puvatɨgham!” ");
INSERT INTO msy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ezɨ Iesus merara gara ghuava azara, “Ezɨ Godɨn Akɨnafarimɨn mɨgɨrɨgɨar otevir kam, an mɨngarim manmakɨn? ‘Kar dɨpenir akɨnir ingangarir gumaziba aghuazim, a datɨrɨghɨn dɨpenim aterir guarim gava?’ ");
INSERT INTO msy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nɨ tina temer guarir kam gisɨn irɨghɨva dɨpɨrigh irɨgham, eghtɨ a tina gisɨn irɨghtɨma gumazir kam bar mɨsarighregham.” ");
INSERT INTO msy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ezɨ Judan arazibagh fozir gumaziba, ko ofa gamir gumazir ekiaba Iesus bar kaghɨram an suighasa tuaviba buri. Me fo, an akar isɨn zuir kam me gasara, ezɨ me an suighan gumazamizibar atiati. ");
INSERT INTO msy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Egha me bar deravɨra a bagha garava, egha moga garir gumaziba amadazɨ, me ifara mati me guizɨn mɨgei. Me kamagh sua, me Iesusɨn mɨgɨrɨgɨar otevitamɨn an suiraghɨva, egh a isɨ Romɨn gavmanɨn gumazir ekiam danigam. ");
INSERT INTO msy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ezɨ moga garir gumazir kaba an azangsɨsi, “Tisa, e fo nɨ bizir aghuibav gɨava sure gamuava, ziabagh nɨghnɨzir puvatɨ. Nɨ gumazamiziba Godɨn arazibar mɨrara guizbangɨra men sure gami. ");
INSERT INTO msy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nɨ e mɨkɨm. E gavmanɨn dagɨaba Sisar danɨngam, o puvatɨgham?” ");
INSERT INTO msy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Ezɨ a men nɨghnɨzir ifavaribagh fogha, egha a me mɨgei, “Dagɨatam nan akagh. Tinan nedazim ko ziam an iti?” ");
INSERT INTO msy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ezɨ me kamaghɨn mɨgei, “Sisarɨn ziam koma nedazim an iti.” Ezɨ a me mɨgei, “Kamaghɨra ia Sisarɨn biziba Sisar danɨngɨva, Godɨn biziba isɨ, God danɨng.” ");
INSERT INTO msy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ezɨ me gumazamizibar tongɨn, a mɨkemezir mɨgɨrɨgɨaba bagha an suighan ibura. Egha me purama an mɨgɨrɨgɨabagh nɨghnɨghava nɨmɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadyusin maba azangsɨzir mam sara Iesus bagha ize. (Me kamaghɨn nɨghnɨsi, aremeziba ua dɨkavan kogham.) ");
INSERT INTO msy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Egha me Iesus kamaghɨn a mɨgei, “Tisa, Moses e bagha akɨnafarim osira ghaze, gumazitamɨn aveghbuam amuimɨn ikɨva boriba puvatɨghɨva aremeghtɨ, anarɨra irir aveghbuam an amuir odiarimɨn ikɨva a bagh boriba iniam. ");
INSERT INTO msy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ezɨ 7-plan aveghbuaba iti. Egha men mav faragha amuimɨn ikia boriba puvatɨgha areme. ");
INSERT INTO msy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Ezɨ anarɨra irim an ikia kamaghɨra, ezɨ mɨkezim kamaghɨra ghu. Kamaghɨra, 7 plan aveghbuaba bar ariaghregha, me boriba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Abuan amizir kam uaghan areme. ");
INSERT INTO msy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Fomɨra me bar amizir kamɨn ike. Kamaghɨn a ua dɨkavamin dughiamɨn, a tinan amuim gavagham?” ");
INSERT INTO msy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ezɨ Iesus men akam ikara, “Dughiar kamɨn gumaziba ko amiziba me poroghamibagh ami. ");
INSERT INTO msy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Eghtɨ gumazamizir God inabaziba, me uaghan dughiar izamim ko ua dɨkavamin dughiam, me poroghamibar amuan kogham. ");
INSERT INTO msy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","God me damightɨma, me ua dɨkavigham. Me ua dɨkavightɨ e fogh suam me Godɨn boribara, egh me enselbar mɨn ikiam. Kamaghɨn me uam arɨmɨghɨran koghɨva, egh kamaghɨn me poroghamibar amuan kogham. ");
INSERT INTO msy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ezɨ Moses uabɨ temer avimɨn eghaghanimɨn aven en aka, aremeziba ua dɨkavam. A kamaghɨn mɨgei, ‘Ekiam, Nɨ Abraham ko Aisak ko Jekopɨn God.’ ");
INSERT INTO msy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kamaghɨn e fo, God aremezibar God puvatɨ, a gumazir angamra itibar God. Ezɨma an damazimɨn an boriba bar angamra iti.” ");
INSERT INTO msy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ezɨ Judan arazibagh fozir gumazir maba kamaghɨn mɨgei, “Mar mɨgɨrɨgɨar aghuim, Tisa.” ");
INSERT INTO msy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Egha me uam an azangsɨghan atiati. ");
INSERT INTO msy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ezɨ Iesus gumazamiziba kamaghɨn me mɨgei, “Manmaghɨn amizɨ gumazamiziba ghaze, God Uam E Iniasa Mɨsevezir Gumazim Krais, a Devitɨn ovavim? ");
INSERT INTO msy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Devit uabɨ Ighiabar Akɨnafarimɨn aven mɨkeme, ‘Ekiam, nan Ekiam kamaghɨn a mɨgei, “Nan agharir guvimɨn amadaghan daperagh. ");
INSERT INTO msy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Egh mangɨ dughiar kɨ nɨn apaniba, me damutɨma me nɨn apengan ikiamim.” ’ ");
INSERT INTO msy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Egha Devit ‘Ekiam’ a gatɨ. Manmaghɨn amizɨ, a Devitɨn ovavim?” ");
INSERT INTO msy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ezɨ gumazamiziba orazima a uan suren gumaziba kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ia Judan arazibagh fozir gumaziba bagh gan. Me uari fava korotiar ruarir kaba aghuraruasa ifonge. Ezɨ gumazamiziba maketɨn danganimɨn men ziaba fasa me bar akonge. Egha God ko mɨgeir dɨpenir averiamɨn dabirabir aghuariba iniva, egha isar ekiabar dughiabar me danganir ziaba itiba iniasa bar ifonge. ");
INSERT INTO msy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Me amuir odiaribagh ifara, men dɨpeniba okɨa, ghaze e dera. Egha gumaziba men ziaba fasa, egha me God ko mɨgɨa mɨgɨrɨgɨar ruaribagh ami. Kamaghɨn amir gumaziba, men ivezir kuram gumazir arazir kurabagh amibar ivezim bar a gafiragham.” ");
INSERT INTO msy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ezɨ Iesus damazimning fegha garima dagɨaba itir gumaziba uan dagɨaba isa Godɨn Dɨpenimɨn dagɨaba arɨzir danganim garɨsi. ");
INSERT INTO msy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ezɨ a garima dagɨaba puvatɨzir amizir pam aremezir mam uaghan uan dagɨar muziarimning, atɨ. ");
INSERT INTO msy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ezɨ Iesus kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, biziba puvatɨzir amuir odiarir kam dagɨar muziarir pumuning dagɨaba arɨzir danganim gatɨ, ezɨ an dagɨar pumuning gumazir igharaziba arɨghɨzir dagɨabagh afira. ");
INSERT INTO msy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Me uan dagɨar avɨribar amodoghɨn dagɨar muziariba anɨngi. Ezɨma a uan dabirabir onganarazimɨn mɨrara dagɨar muziarir abuananamning atɨ.” ");
INSERT INTO msy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ezɨma an suren gumazir maba Godɨn Dɨpenimɨn garava kamaghɨn mɨgei, “Me dagɨar bar aghuibar an ingarighava, Afeziar Ekiam danɨngamin bizir aghuir maba an kuruke.” ");
INSERT INTO msy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ezɨ Iesus kamaghɨn mɨgei, “Ia datɨrɨghɨn garir bizir kabanagh, dughiam izɨtɨma dagɨar kaba, gumaziba bar da pueghtɨ da bar moghɨra daghregham. Eghtɨ tam tam gisɨn ikeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ezɨ me an azara, “Tisa, bizir kaba manadɨzoghɨn otivam? Eghtɨ arazir manam faragh otoghtɨma, e fogh suam, dughiar kam roghɨra ize?” ");
INSERT INTO msy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ezɨ Iesus kamaghɨn mɨgɨa ghaze, “Ia uari bagh deraghvɨra gan, ia men ifavariba baraghan markɨ. Gumazir avɨriba nan ziamɨn izɨva suam, ‘Kɨrara!’ ezɨ, ‘Dughiam roghɨra ize!’ Men gɨn mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Egh ia inogoviba ko adoghadozir mɨdorozir akaba baraghɨva, atiatingan markɨ. Bizir kabanagh faragh otivigham, eghtɨma nguazir kam gɨvamin dughiam datɨrɨghɨra otoghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Egha a kamaghɨn me mɨgei, “Nguibaba uarira uariv soghtɨma, dakoziba uarira uariv sogham. ");
INSERT INTO msy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Eghtɨ mɨkɨmkɨzir gavgaviba, koma dagheba otevir dughiaba koma arɨmariar gavgaviba nguibar tabar otivtɨma, atiatingamin biziba koma overiamɨn pɨn arazarazir ekiaba otivam. ");
INSERT INTO msy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Eghtɨ bizir kaba gɨn otivam, me faragh ian suiraghɨva arazir kurabar ia damuam. Me ia kotiam darɨghsɨ ia inighɨva God ko mɨgeir dɨpeniba koma kalabuziabar aven mangam. Eghtɨma ia nan gɨn zuir gumaziba me bizir kam bangɨn ia inighɨva atriviba koma gavmanɨn gumazir ekiabar damazimɨn mangam. ");
INSERT INTO msy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Eghtɨ kar dughiar aghuir ia nan akam me mɨkɨnamim. ");
INSERT INTO msy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Eghtɨ ia deraghvɨra nɨghnɨgh. Ia faragh me mɨkɨmsɨ akabagh nɨghnɨghan markɨ. ");
INSERT INTO msy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eghtɨ kɨ nɨghnɨzir aghuiba koma mɨgɨrɨgɨar aghuiba ia danɨngtɨma, ia mɨgɨrɨgɨar aghuibara damutɨma, ian apanitam ian akaba batoghɨva ia adoghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Eghtɨ ian ameboghfeziaba, ko aveghbuaba, ko anababa, ko namakaba merara, ia inighɨva gumazir kurabar dafaribar atɨghtɨ, me ian taraziv soghtɨ ia arɨmɨghregham. ");
INSERT INTO msy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Eghtɨ gumazamiziba bar nan ziam bangɨn ian aghuagham. ");
INSERT INTO msy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Egh me bar tong arazitam ia damuan kogham. Kamaghɨn ian dapanarɨzitam asighɨran kogham. ");
INSERT INTO msy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ia tugh gavgavighvɨra ikɨva, dabirabir bar aghuim iniam.” ");
INSERT INTO msy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Egha Iesus ghua kamaghɨn mɨgei, “Nɨ Jerusalemɨn nguibamɨn gantɨma mɨdorozir gumaziba izɨva a kontɨma, nɨ fogham a gasɨghasɨghamɨn dughiam roghɨra ize. ");
INSERT INTO msy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Egh gumazir Judian itiba arɨ mɨghsɨabar mangɨtɨma, Jerusalemɨn nguibamɨn itiba azenan mangɨtɨma, Jerusalemɨn azenan itir gumaziba uam an aven mangan markiam. ");
INSERT INTO msy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kar osɨmtɨzibar dughiam, God da isɨva Israelbar anɨngɨva, men arazir kuraba ikarvagham. A fomɨra osirizir moghɨn otogham. ");
INSERT INTO msy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aiee! Amizir naviba adaiba koma oteba boribagh anɨdiba dughiar izamiba bar men osemegham! Eghtɨma God gumazir kabar atartɨma, osɨmtɨzir ekiam nguazir kam bativam. ");
INSERT INTO msy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Eghtɨ mɨdorozir gumaziba mɨsozir sababar tarazigh inivtɨma me arighɨrɨtɨ, me tarazi suighɨva, me amangtɨma me nguibar Israelɨn azenan itibar mangam. Eghtɨ Kantrin Igharazibar Gumaziba Jerusalem bar pazɨva an itir bizibar amu mangɨ dughiar me Jerusalemɨn ganamin dughiam gɨvagham.” ");
INSERT INTO msy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Egha Iesus ghua kamaghɨn mɨgei, “Eghtɨ arazaraziba aruem ko iakinim ko mɨkoveziba bativam. Eghtɨ ongarim dɨpɨr tɨngaghɨvɨra ikɨtɨma nguazimɨn gumazamiziba bar atiatigh okam nɨghnɨgham. ");
INSERT INTO msy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eghtɨ overiamɨn biziba bar nɨgham, kamaghɨn gumaziba atiatingɨva damaziba men isirtɨma me daighirɨva, egh me otivamin biziba bagh mɨzuamɨva nɨghnɨgham. ");
INSERT INTO msy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Egh me dughiar kamɨn Gumazibar Borimɨn gantɨ, a ghuariamɨn tongɨn gavgavim ko angazangarir ekiam sara izam. ");
INSERT INTO msy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Eghtɨ bizir kabanagh otivighrɨtɨma ia dɨkavigh, uan dapaniba fegh gan! God ua ia iniamin dughiam roghɨra ize!” ");
INSERT INTO msy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Egha Iesus kamaghɨn akar isɨn zuimɨn me mɨgei, “Ia temer fighɨn ganɨva temer maba sara gan. ");
INSERT INTO msy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Temeba dafariba asitɨma ia fogham, aruem ganamin dughiam roghɨra ize. ");
INSERT INTO msy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kamaghɨra ia bizir kabar gan fogh suam, God Bizibagh Ativamin Dughiam roghɨra ize. ");
INSERT INTO msy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Kɨ guizbangɨra ia mɨgei dughiar kamɨn itir gumazamizir kaba ikɨvɨra ikɨtɨ bizir kaba bar otivam. ");
INSERT INTO msy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Overiam ko nguazim gɨvagham, eghtɨ nan mɨgɨrɨgɨaba gɨvaghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Egha Iesus ghua kamaghɨn mɨgei, “Ia uari bagh ganigh! Isaba ko, dɨpar onganiba ko nguazir kamɨn biziba, ia puv dagh nɨghnɨghtɨ, da ia dɨkabɨntɨ, dughiar otivamin kam puram otoghɨva, mati asɨzibar azuazimɨn mɨn ian suigham. ");
INSERT INTO msy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Eghtɨ dughiar kam nguibaba koma nguazir kamɨn gumaziba bar me bativam. ");
INSERT INTO msy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ia zurara uari bagh gan Afeziam ko mɨkɨmvɨra ikɨtɨma, a gavgavim ia danɨngtɨma ia bizir otivamin kabagh itavragham. Egh ia Gumazibar Otarimɨn damazimɨn tuivam.” ");
INSERT INTO msy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Egha dughiabar zurara Iesus, Godɨn Dɨpenimɨn aven men sure gamuava, guaratɨzibar Olivɨn mɨghsɨamɨn ghuava dɨmagaribar an iti. ");
INSERT INTO msy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ezɨ gumaziba bar Iesus baraghasa, mɨzarazibar Godɨn Dɨpenimɨn arui. ");
INSERT INTO msy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Datɨrɨghɨn Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam roghɨra izi. An ziam, God Israelbagh Itazir Dughiam. ");
INSERT INTO msy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ezɨ ofa gamir gumazir ekiaba, ko Judan arazibagh fozir gumaziba, me gumazibar atiatighava, kamaghɨn me Iesusɨn mɨsoghasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","4","Iesusɨn 12-plan gumazir mam Judas, an ziar mam Iskariot. Satan an navir averiamɨn ghu. Ezɨ a Iesus isava Godɨn Dɨpenimɨn garir gumazir ekiaba, ko ofa gamir gumazir ekiabar dafaribar arɨghasa ghua me koma mɨgɨrɨgɨabagh ami. ");
INSERT INTO msy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ezɨ me an mɨgɨrɨgɨam gifuegha ivezim a danɨngasa, akabar kɨri. ");
INSERT INTO msy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ezɨ Judas ivezim inian ifuegha Iesus isɨva men dafaribar arɨghasa tuaviba buri. A ghaze, Iesus uabɨra ikɨtɨ, an an suiragh men dafarim darɨgham. ");
INSERT INTO msy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam datɨrɨghɨn oto. Ezɨ dughiar kamɨn me God Israelbagh Itazir Dughiamɨn isam bagha sipsipɨn nguzim mɨsuegh anemɨ ikɨva, a gɨnɨghnɨghasa. ");
INSERT INTO msy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ezɨ Iesus Jon koma Pita amadagha kamaghɨn aning mɨgɨa ghaze, “Gua mangɨva e God Israelbagh Itazir Dughiamɨn isam ramamin daghebar kɨr.” ");
INSERT INTO msy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ezɨ aning an azara, “Ga managh a bagh danganim akɨram?” ");
INSERT INTO msy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ezɨ a kamaghɨn aning mɨgei, “Gua nguibar ekiamɨn aven mangɨtɨ, gumazitam maghɨra mɨner dɨpam ater izɨ gua batoghtɨma, gua an gɨn a zuir dɨpenimɨn mangɨ. ");
INSERT INTO msy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Egh dɨpenimɨn ghuavim mɨkɨm suam, ‘Tisa kamaghɨn mɨgɨa ghaze, “Nan danganir kɨ uan suren gumaziba ko God Israelbagh Itazir Dughiamɨn isam ramamim mana?” ’ ");
INSERT INTO msy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Eghtɨ a ghuriamɨn aven danganir bar ekiatam guan akagham, dakoziba koma dapiagh damamin dabirabiba ko biziba bar ikɨtɨ, gua magh bizibar kɨr.” ");
INSERT INTO msy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ezɨ aning ghua garima, biziba bar Iesus mɨkemezɨ moghɨrama otifi. Ezɨma aning God Israelbagh Itazir Dughiam bagha dagheba ko bizibar kɨri. ");
INSERT INTO msy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ezɨ damamin dughiam otozɨ, Iesus uan aposelba ko me dagher dakozimɨn mɨn apiaghav iti. ");
INSERT INTO msy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Egha a kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, kɨ ua God Israelbagh Itazir Dughiamɨn isamɨn dagher katam rameghan kogham. Kamaghɨra ikɨ mangɨ, God Bizibagh Ativamin Dughiamɨn otogham. Kamaghɨn amizɨma kɨ ia ko isar kam ramasa bar ifonge. Egh kɨ gɨn mɨzazim iniam.” ");
INSERT INTO msy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Egha Iesus wain apir itarim inighava Ekiam mɨnabagha kamaghɨn mɨgei, “Kɨ ia mɨgei, kɨ uam wainɨn ovɨzimɨn dɨpar katam raman kogham, kamaghɨra ikɨtɨma God Bizibagh Ativamin Dughiam otogham. Kamaghɨn, ia kagh a inigh ia uari danɨng.” ");
INSERT INTO msy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Egha a bret inigha, Ekiam mɨnabagha anebighava me ganɨga kamaghɨn me mɨgei, “Kar nan nivafɨzim, kɨ ia bagha anenɨngi. Ia anemɨ, na gɨnɨghnɨgh.” ");
INSERT INTO msy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Me amegha gɨvazɨma, ezɨ kamaghɨra a wainɨn apir itarim inighava kamaghɨn mɨgei, “Itarimɨn aven itir wainɨn kam, an Akar Dɨkɨrɨzir Gavgavir Igiam, kɨ uan ghuzimɨn a gamizɨma, a ia bagha iri. ");
INSERT INTO msy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Eghtɨ ia gan, dafarir na inighɨva gumazir kurabar dafarim darɨgham, a kara na ko dakozim gaperaghavtɨ. ");
INSERT INTO msy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eghtɨ Gumazibar Borim tuavir Afeziam faragha a bagh atɨzimɨn gɨn mangam. Ezɨ gumazir a inigha gumazir kurabar dafarim gatɨzim, gumaka, a bar ikuvigham.” ");
INSERT INTO msy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ezɨ me akar kam baregha uarira uarir azangsɨsi, “Tina bizir kam damuam?” ");
INSERT INTO msy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Egha aposelba uari adogha ghaze, tinara en faragham? ");
INSERT INTO msy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ezɨ Iesus kamaghɨn me mɨgei, “Kantrin Igharazir Gumazibar atriviba, me uan gavgaviba ko ziaba fava, arazir kuraba gumazibagh amuava, egha kamaghɨn mɨgei ‘E gumazibar akurvasi.’ ");
INSERT INTO msy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ia kamaghɨn damuan markɨ. Gumazir ian torimɨn ikia ian faragha zuim, a uabɨ apengan ikɨva, borimɨn mɨn uabɨ arɨgh. Ezɨ gumazir ian faragha zuim, ian ingangarir gumazimɨn mɨn ikɨ. ");
INSERT INTO msy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tinara ekefe, gumazir pura dagher dakozimɨn aperaghav itim o gumazir dagheba anɨdim? Gumazir pura dagher dakozimɨn aperaghav itim. Ezɨma kɨ ian torimɨn ikia mati ian ingangarir gumazim. ");
INSERT INTO msy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Kɨ osɨmtɨziba aterima ia na ko iti. ");
INSERT INTO msy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kamaghɨra nan afeziam Atrivimɨn mɨn na atɨzɨma, kɨ uaghan atrivibar mɨn ia arɨghasa. ");
INSERT INTO msy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Eghtɨ nan atrivir dughiamɨn aven ia na ko atrivimɨn dabirabir aghuaribar apiaghɨva Israelbar anabar 12 plan ganam.” ");
INSERT INTO msy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Egha Iesus kamaghɨn mɨgei, “Saimon, Saimon, Satan nɨn nɨghnɨzir gavgavim tuisɨgh a gɨfoghasa, Godɨn azara. ");
INSERT INTO msy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ezɨ kɨ nɨ bagha Afeziar Ekiam ko mɨkemegha gɨfa, nɨn nɨghnɨzir gavgavim irɨghan kogham. Egh nɨ uamategh na bagh izɨva, egh uan aveghbuaba gavgavim me danɨng.” ");
INSERT INTO msy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Egha Pita kamaghɨn mɨgɨa ghaze “Ekiam, kɨ nɨ ko kalabusɨn mangam o aremeghasa ifuegha iti.” ");
INSERT INTO msy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ezɨ Iesus kamaghɨn Pitan akam ikara, “Kɨ nɨ mɨgei, nɨ datɨrɨghɨn dughiar pumuning ko mɨkezimɨn mɨkɨm suam, nɨ na gɨfozir puvatɨ, eghtɨ tuarim maghɨrama akam.” ");
INSERT INTO msy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Egha Iesus men azara, “Kɨ dughiar kamɨn ia amadagha bizir kataba sara ia amadazɨr puvatɨ, dagɨaba azuir mɨtariba koma ruagha aruir mɨtariba koma dagarir asuaba. Ezɨ ia bizitamɨn otevez o puvatɨ?” Ezɨ me kamaghɨn mɨgɨa ghaze, “Puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ezɨ a kamaghɨn me mɨgei, “Eghtɨ ia datɨrɨghɨn uan dagɨar mɨtariba ikɨva, da inigh, egha ruagha aruir mɨtariba ikɨva, uaghan da inigh. Eghtɨ ia mɨdorozir sababa puvatɨghɨva, ia uan initam amadaghɨva tam givesegh. ");
INSERT INTO msy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kamaghɨn Godɨn Akɨnafarim ghaze, ‘Gumaziba an gara ghaze, a gumazir kuram.’ Kɨ ia mɨgei, bizir kaba na bativam. Are, Afeziar Ekiamɨn akɨnafarim osirizir moghɨn biziba na bativavɨra iti.” ");
INSERT INTO msy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ezɨ me mɨgei, “Ekiam, nɨ gan. E mɨdorozir sabar pumuning kagh iti.” Ezɨma a kamaghɨn me mɨgei, “A gɨfa.” ");
INSERT INTO msy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Egha Iesus nguibar ekiam, Jerusalem, ategha, Olivɨn mɨghsɨam bagha zui. A zurara ami moghɨn. Ezɨ an suren gumaziba an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Egha me danganir kamɨn otivigha a kamaghɨn me mɨgei, “Ia uari bagh God ko mɨkɨm. Eghtɨma osɨmtɨzir ekiar kam ia damutɨma, ia ireghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Egha a me ategha mong saghon ghua, mati gumazim dagɨam akuri moghɨn, egha a tevimning apɨrigha kamaghɨn God ko mɨgei, ");
INSERT INTO msy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Afeziam, nɨ ifueghava na da osɨmtɨzir kam inigh. Egh nan ifongiamɨn gɨn mangan markɨ. Nɨ uan ifongiamɨn gɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ezɨ ensel mam Godɨn Nguibamɨn ikegha izava gavgavim a ganɨdi. ");
INSERT INTO msy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ezɨ Iesus nɨghnɨghava bar oseme, egha a pamtem Afeziam ko mɨgei. Ezɨ an doriba otivaghira mati ghuzim nguazim giri. ");
INSERT INTO msy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","An Afeziam ko mɨkemegha, dɨkavighava uamategha uan suren gumaziba bagha zui. Egha a men garima, me bar osemeghava akuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ezɨ a me mɨgei, “Ia tizim bagha akui? Ia dɨkavighɨva Afeziam ko mɨkɨm. Eghtɨ osɨmtɨzir ekiam ia damutɨma, ia ireghan kogham.” ");
INSERT INTO msy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Egha Iesus mɨgɨavɨra itima maburan gumazir bɨzim oto. An 12 plan gumazir mam Judas men faragha iza tuavim men aka. A Iesusɨn boroghɨra izeghava an torasava ami. ");
INSERT INTO msy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ezɨ Iesus kamaghɨn an azara, “Judas kar nɨ Gumazibar Otarimɨn toreghɨva a inighɨva, gumazir kurabar dafarim darɨghasa?” ");
INSERT INTO msy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ezɨ suren gumaziba Iesus ko ikia garima arazim otivasava amima, me kamaghɨn mɨgei, “Ekiam, e uan mɨdorozir sababar me mɨsogham, o?” ");
INSERT INTO msy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ezɨ men mav mɨdorozir sabam inighava, ofa gamir gumazibar ekiamɨn ingangarir gumazir mam mɨsoghava, an kuarim bar anetuzɨ a irɨ. ");
INSERT INTO msy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ezɨ Iesus kamaghɨn mɨgei, “Arazir kam atakigh!” Egha an an kuarimɨn suirazɨ, a dera. ");
INSERT INTO msy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ezɨ ofa gamir gumazibar ekiaba, ko Godɨn Dɨpenimɨn garir gumazir ekiaba, ko Judan gumazir dapaniba me iza Iesusɨn suighasava amim, a kamaghɨn me mɨgei, “Ia mɨdorozir sababa ko asianiba inigha iza mati ia okɨmakɨar gumazim o mɨdorozir gumazim buri? ");
INSERT INTO msy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kɨ zurara ia ko Godɨn Dɨpenimɨn aven itima, ia dafarim na garɨzir puvatɨ. Ezɨ datɨrɨghɨn ian dughiam. Datɨrɨghɨn mɨtarmemɨn gavgavim oto.” ");
INSERT INTO msy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ezɨ Iesusɨn apaniba an suighava a inigha ofa gamir gumazibar dapanimɨn dɨpenimɨn zui. Ezɨma Pita men gɨn ghua mong gɨrara iti. ");
INSERT INTO msy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ezɨma me dɨpenimɨn dɨvazimɨn aven avim atɨghava apiaghav itima, Pita uaghan me koma aperaghav iti. ");
INSERT INTO msy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ezɨ ingangarir guivir mam avir angazangarimɨn an garima, a me koma aperaghav itima, a mɨghɨgha an garava kamaghɨn a mɨgei, “Gumazir kam a ko ike.” ");
INSERT INTO msy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ezɨma Pita kamaghɨn mɨgɨa ghaze, “Puvatɨ! Amizim, kɨ a gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A mong ikezɨma gɨn ua mav izava an apigha kamaghɨn a mɨgɨa ghaze, “Nɨ uaghan men mav.” Ezɨ Pita kamaghɨn mɨgei, “Ai! Kɨ bar puvatɨ!” ");
INSERT INTO msy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Dughiam mong ghugha gɨvazɨma, gumazir igharazim izava pamtem ghaze, “Guizbangɨra kav, a Galilin gumazimra. Kamaghɨn e guizbangɨra fo, a uaghan a ko ike.” ");
INSERT INTO msy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ezɨ Pita kamaghɨn mɨgɨa ghaze, “Aiee! Nɨ tizim mɨgei? Kɨ bar fozir puvatɨ!” Eghava a mɨgɨavɨra itima tuarim ake. ");
INSERT INTO msy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ezɨ Ekiam raghrɨghava mɨghɨgha Pitan garima, a mɨkemezir akabagh inɨrɨ, “Nɨ datɨrɨghɨn dughiar pumuning ko mɨkezimɨn mɨkɨm suam, ‘Nɨ na gɨfozir puvatɨ,’ eghtɨ tuarim maghɨrama akegham.” ");
INSERT INTO msy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Egha Pita inɨrɨghava azenimɨn ghua bar puvɨrama azi. ");
INSERT INTO msy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ezɨ gumazir Iesusɨn suighiziba dɨbovir akabar a mɨgɨava a mɨsosi. ");
INSERT INTO msy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Egha me inir avɨzimɨn an damazimning ikegha kamaghɨn a mɨgei, “Godɨn akam inigha izir gumazim, nɨ e mɨkɨm! Tina nɨ mɨsoke?” ");
INSERT INTO msy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Egha me akar kurar avɨrir maba saram a mɨkeme. ");
INSERT INTO msy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ezɨ amɨnim tirazɨma, Judan kotɨn aven itir gumazir aruaba (ofa gamir gumazir ekiaba, ko Judan arazibagh fozir gumaziba) me bar iza uari akuvaghav itima, me Iesus inighava men damazimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ezɨ me kamaghɨn mɨgei, “Nɨ e mɨkɨm, kar nɨ Krais, God Uam E Iniasa Mɨsevezir Gumazim, o ti puvatɨ?” Ezɨ, a kamaghɨn me mɨgɨa ghaze, “Kɨ ia mɨkemeghtɨma, ia nɨghnɨzir gavgavim nan ikian kogham. ");
INSERT INTO msy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Eghtɨ kɨ ian azaraghtɨma, ia na mɨkemeghan kogham. ");
INSERT INTO msy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eghtɨ datɨrɨghɨn ko gɨn izamin dughiaba, Gumazibar Otarim gavgaviba bar itir Godɨn agharir guvimɨn daperaghɨv ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ezɨ me bar an azara, “Kar nɨ Godɨn Otarim?” Ezɨma a me mɨgɨa ghaze, “Ia guizbangɨra mɨgei, kɨ an Otarimra.” ");
INSERT INTO msy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Egha me kamaghɨn mɨgɨa ghaze, “E tizim bagh uamategh gumaziba inightɨ me gumazir kamɨn arazibar gun e mɨkɨmam? A uabɨ bizir kam mɨkemezɨma e an akatorim baregha gɨfa.” ");
INSERT INTO msy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Egha gumazir bɨzim bar dɨkavigha Iesus inigha Pailat bagha zui. ");
INSERT INTO msy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Egha me dɨkavigha a gifara, kamaghɨn a mɨgɨa ghaze, “E gumazir kamɨn garima an en gavmanɨn ikura. Egha an e dagɨaba Sisar danɨngan bar en anogoregha, kamaghɨn mɨgɨa ghaze, a uabɨ atrivim ko God Uam E Iniasa Mɨsevezir Gumazim, Krais.” ");
INSERT INTO msy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ezɨ Pailat Iesusɨn azara, “Nɨ Judabar atrivim, o?” Ezɨ Iesus ghaze, “Are, mɨgɨrɨgɨar nɨ mɨgeim, a guizbangɨra.” ");
INSERT INTO msy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ezɨ Pailat kamaghɨn ofa gamir gumazir ekiaba koma gumazamizibav gɨa ghaze, “Kɨ gumazir kamɨn arazir kuratamɨn apizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ezɨ me bar gavgavigha kamaghɨn mɨgɨa ghaze, “A Galilin Provinsɨn ikegha nguibabagh aruava men sure gamua men navibagh inivava da fe. Egha datɨrɨghɨn a Judian Provinsɨn izegha kagh otogha kamaghɨn amuavɨra iti.” ");
INSERT INTO msy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ezɨ Pailat mɨgɨrɨgɨar kam baregha, kamaghɨn men azara, “Kar Galilin gumazim?” ");
INSERT INTO msy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Iesus Herot garir Provinsɨn ikezɨma, Pailat kamaghɨn foghava, anemadazɨ a Herot bagha ghu. Dughiar kamɨn Herot uaghan Jerusalemɨn iti. ");
INSERT INTO msy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herot fomɨra Iesusɨn ganasa ifuegha, an ganizir puvatɨgha, dughiar kamɨn an an ganigha, bar akonge. Egha Iesusɨn akaba baregha an mirakelɨn tamɨn ganasa. ");
INSERT INTO msy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Egha Herot azangsɨzir avɨravɨribar Iesus gamima, a bar an azangsɨzitam ikarazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ezɨ ofa gamir gumazir ekiaba, ko Judan arazibagh fozir gumaziba, me roghɨra tuivighava, an atarava, akaba pamtem a gasi. ");
INSERT INTO msy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Egha Herot uan mɨdorozir gumaziba ko an atarava dɨbovir akar kurabar a mɨgei. Egha me atrivimɨn inir aghuir mam inigha a gikegha, uam anemadazɨ, a Pailat bagha zui. ");
INSERT INTO msy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Fomɨra Herot Pailatɨn anɨngaghe, egha dughiar kam aning ua uaning ini. ");
INSERT INTO msy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ezɨ Pailat, ofa gamir gumazir ekiaba, ko gumazir dapanir ekiaba, ko gumazamiziba, men deima me bar uari akuvagha iti. ");
INSERT INTO msy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ezɨma a kamaghɨn mɨgei, “Ia gumazir kam inighava na bagha ize. Egha ia kamaghɨn mɨgei, ‘A gumazamizibav geima me gavmanɨn ikura.’ Ezɨ kɨ ian damazimɨn arazir kabanagh bagha an azangsɨki. Ia oragh! Kɨ gumazir kamɨn arazitam batozir puvatɨ. Ia purama a gifari. ");
INSERT INTO msy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ezɨ Herot uaghan nɨghnɨzir kam ikiava, gumazir kam e bagha uam anemada. Ia oraki! An arazir kuratam damighɨva, an ovengam. Gumazir kam arazir kuratam gamizir pu, an ovengan kogham. ");
INSERT INTO msy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Kamaghɨn, kɨ purama a fozoregh, an ateghtɨma a mangam.” ");
INSERT INTO msy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ezɨ amiziba ko gumaziba bar moghɨra tuai, “Gumazir mamɨn mɨsokegh! Egh Barabas ateghtɨ a e bagh izɨ!” ");
INSERT INTO msy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas a fomɨra Romɨn gavmanɨn ikuragha Jerusalemɨn nguibamɨn aven mɨdorozim fore. Ezɨ gumazir maba ariaghɨre. Ezɨ me a isa kalabus gatɨ.) ");
INSERT INTO msy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ezɨ Pailat Iesus ateghtɨ a mangasa ua me mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ezɨ me kamaghɨn tuai, “A mɨsokegh! A mɨsokegh! A isɨ ter ighuvim gafugh!” ");
INSERT INTO msy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ezɨ dughiar mɨkezim a kamaghɨn mɨgei, “Manmagh su? An arazir kurar manam gami? Kɨ an arazir kuratamɨn apizir puvatɨ. An arazir kuratam damighɨva an ovengam. Gumazir kam arazir kuratam gamizir puvatɨ. Kɨ purama a fozoreghɨva aneteghtɨ, a mangam.” ");
INSERT INTO msy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ezɨma me bar moghɨra gavgavigha dei, “Iesus isɨva ter ighuvim gafugh!” Ezɨ men dɨmdiaba bar Pailatɨn akam gafira. ");
INSERT INTO msy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ezɨma Pailat men akamɨn gɨn ghugha, Iesusɨn mɨgɨa ghaze, an ovengam. ");
INSERT INTO msy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Gumazamiziba me Pailatɨn deima a Barabas ataki. Gumazir kam a gavman ikuragha mɨdorozim forezɨma, gumazir maba ariaghɨre. Ezɨ me a isa kalabus gatɨ. Ezɨma Pailat gumazamizibar nɨghnɨzimɨn gɨn ghuava, Iesus isava mɨdorozir gumazibar dafarim gatɨ. ");
INSERT INTO msy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ezɨ mɨdorozir gumaziba Iesus inigha zuima, gumazir mam an ziam Saimon, a Sairinɨn gumazir mam. A Jerusalemɨn mangasa iza me gitavɨrazɨma, me an suira. Egha me ter ighuvim an dɨpɨzim gatɨgha a mɨgeima a Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ezɨma gumazir avɨrim an gɨn ghua, amiziba a bagha aziava azir akar ighiar amɨrɨzibagh ami. ");
INSERT INTO msy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ezɨma Iesus raghrɨgha kamaghɨn me mɨgɨa ghaze, “Ia Jerusalemɨn amiziba, ia na bagh arangan markɨ. Ia uari ko uan boriba bagh arang! ");
INSERT INTO msy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gɨn dughiatam otoghtɨma, me kamaghɨn mɨkɨm suam, ‘Amizir furabaghatiba ko amizir tɨghar boriba batamiba ko, amizir oteba boribagh anɨngizir puvatɨziba, me bar akuegham.’ ");
INSERT INTO msy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","‘Egh me dughiar kamɨn kamaghɨn mɨghsɨabav kɨmam, “Ia e gisɨn irɨghɨva, e mongegh!” ’ ");
INSERT INTO msy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Me datɨrɨghɨn arazir kamɨn temer angamtɨzim damighɨva arazir mana tamɨn temer mɨdiarɨm damuam?” ");
INSERT INTO msy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ezɨ mɨdorozir gumaziba gumazir kurar pumuning Iesus ko aningɨn mɨsueghtɨma me aremeghasa aning inigha izi. ");
INSERT INTO msy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Egha me ghua danganir mamɨn oto, an ziam Dapanir Agharim. Egha me danganir kam Iesus isava tememɨn anegura. Me uaghan gumazir kuramning agurazɨma, mam an guvimɨn itima, mam an kɨriamɨn iti. ");
INSERT INTO msy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ezɨ Iesus kamaghɨn mɨgei, “Afeziam, me amir biziba me dagh fozir puvatɨ. Nɨ men arazir kuraba gɨn amadagh.” Ezɨ mɨdorozir gumaziba Iesusɨn korotiaba iniasa satu gikararai. ");
INSERT INTO msy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ezɨ gumazamiziba an gara tuivighav itima, gumazir dapanir ekiaba uaghan an gara mɨnbaba sighsirava kamaghɨn a mɨgei. “A gumazir mabar akurvakis. Egh a guizbangɨra God Uam E Iniasa Mɨsevezir Gumazim, gumazir God inabazim, a uabɨ uabɨn akuragh.” ");
INSERT INTO msy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Ezɨ mɨdorozir gumaziba izava uaghan a dɨpovava, egha wainɨn dɨpar mɨsozim a ganigha kamaghɨn a mɨgei, “Nɨ guizbangɨra Judabar atrivir gumazim, nɨ uabɨ uabɨn akuragh!” ");
INSERT INTO msy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Egha mɨdorozir gumaziba osizirir mam Iesusɨn dapanim gisɨn anegura. An osiziriba kamaghɨn mɨgei, “Gumazir kam Judabar Atrivir Gumazim.” ");
INSERT INTO msy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ezɨ gumazir kurar mam ter ighuvimɨn guraghav ikia, atara kamaghɨn Iesusɨn mɨgei, “Nɨ guizbangɨra God Uam E Iniasa Mɨsevezir Gumazim, nɨ uabɨn akurvaghɨva ga sarama akuragh!” ");
INSERT INTO msy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ezɨ gumazir kurar igharazim atarava kamaghɨn mɨgei, “Nɨ ovengasava amuava, Godɨn atiati, o puvatɨ? ");
INSERT INTO msy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Me deragha ga gami, ga uan arazir kurabagh ipuri. Ezɨma gumazir kam arazir kuratam gamizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Egha gumazir kam kamaghɨn Iesus mɨgei, “Iesus, nɨ gɨn atrivimɨn ikiamin dughiam nɨ na ginɨrɨgh.” ");
INSERT INTO msy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ezɨma Iesus a mɨgei, “Kɨ guizbangɨra nɨ mɨgei, nɨ datɨrɨghɨn na ko Godɨn Nguibar Aghuarimɨn ikiam.” ");
INSERT INTO msy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ezɨ aruem dughiar kamɨn garir puvatɨ. Kamaghɨn amizɨ, mɨtatem 12 kloghɨn nguazim bar anevaragha ghua 3 kloghɨn tu. Ezɨma Godɨn Dɨpenimɨn itir inir ekiam tongɨra bɨki. ");
INSERT INTO msy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ezɨ Iesus pamtem kamaghɨn dei, “Afeziam, kɨ uan duam nɨn dafarim garɨsi.” A kamaghɨn mɨkemeghava uan duam sue. ");
INSERT INTO msy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ezɨ mɨdorozir gumazibar gumazir ekiam kamaghɨn ganighava Godɨn ziam fe. Egha kamaghɨn mɨgei, “Guizbangɨra, kar gumazir aghuim, a bizitam pazava a gamizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ezɨ gumazamizir iza itiba bizir kabanaghɨn gari da otivima, me azia, uan afarɨzibav mɨsogha, egha uan dɨpenibar zui. ");
INSERT INTO msy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ezɨma Iesus gɨfozir gumaziba, ko amizir an gɨn Galilin izeziba, me mong saghon tuivigha ikia, bizir kabar gari da otifi. ");
INSERT INTO msy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ezɨ gumazir mam, an ziam Josep, a Judian Provinsɨn nguibam Arimatean ikegha ize. A gumazir aghuim, a Godɨn damazimɨn derazir mam, a Kaunsel memban mam. Egha a men nɨghnɨziba ko arazibar gɨn mangan aghua. A God Bizibagh Ativamin Dughiam a baghavɨra muza iti. ");
INSERT INTO msy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Egha Josep Iesusɨn kuam iniasa ghua Pailatɨn azarazɨma, Pailat an amamangatɨ. ");
INSERT INTO msy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ezɨ a Iesusɨn kuam tememɨn anedegha, inir ghurghurimɨn a righa, a inigha ghuava dagɨar torir me fomɨra gumazir kuatam atɨzir puvatɨzim gatɨ. ");
INSERT INTO msy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kar dughiar bizibar kɨrim, ezɨ Sabatɨn dughiam roghɨra ize. ");
INSERT INTO msy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ezɨ amizir Iesusɨn gɨn Galilin izeziba, me Josepɨn gɨn ghua dagɨar torimɨn gari. Egha me uaghan garima, Josep manmaghɨn Iesusɨn kuam atɨ. ");
INSERT INTO msy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Egha me ganigha gɨvaghava, uamategha uan dɨpenibar ghuava bizir mughuriaba itiba ko boreba isa da arɨsi. Egha Godɨn osizirim mɨkemezɨ moghɨn, me Sabatɨn dughiamɨn avughsi. ");
INSERT INTO msy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ezɨ Sanden bar mɨzaraghara, amiziba borer mughuriar aghuir me arɨghɨziba, inighava dagɨar torimɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Egha me gari, me torim avarazir dagɨam, me a puegha ghu. ");
INSERT INTO msy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Egha me aven ghua Iesusɨn kuam bagha garava avenge. ");
INSERT INTO msy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Egha me kamaghɨn ganigha nɨghnɨzir avɨribagh amua tuivighav itima, gumazir pumuning zuamɨra aningɨn korotiaba onɨmarimɨn mɨn taghtagha men mɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ezɨ amiziba bar atiatigha avigha nguazimɨn gari, ezɨ gumazimning kamaghɨn me mɨgei, “Ia tizim bagha gumazir angamra itim gumazir ovengezibar danganimɨn a buri? ");
INSERT INTO msy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A kagh itir puvatɨ; a ua dɨkafi! A ia ko Galilin ikia ia mɨkemezir bizim, ia a gɨnɨghnɨgh, ");
INSERT INTO msy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Gumazibar Otarim, me a isɨ gumazir arazir kurabagh amibar dafarim datɨghtɨ, me a isɨ ter ighuvimɨn a guragham. Eghtɨ a dughiar mɨkezimɨn ua dɨkavigham.’” ");
INSERT INTO msy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ezɨ a mɨkemezir akaba me a dagh inɨrɨ. ");
INSERT INTO msy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Egha me mozim ategha uamategha ghua bizir kabar gun Iesusɨn suren gumazir 11 plan mɨgɨava igharaz darazi sara mɨkeme. ");
INSERT INTO msy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Amizir bizir kabar gun Iesusɨn 11 plan aposelba ko igharaz daraziv kemeziba. Makdalan nguibamɨn amizim Maria, ko Joana, ko Maria a Jemsɨn amebam, koma amizir igharazir maba uaghan me ko ikia bizir kabar gun aposelbav mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ezɨ me amizibav gɨa ghaze, me ti onganighama, egha kamaghɨn me nɨghnɨzir gavgavim men akabar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Egha Pita kamaghɨn oregha dɨkavigha ivegha mozimɨn ghu. Egha an aviragha, mozimɨn gara bizitamɨn apizir puvatɨgha inir ghurghuribara gari da ireghav iti. Egha a uamategha ghua nɨghnɨzir avɨribagh amua ghaze, kar manmaghɨn amizir bizim. ");
INSERT INTO msy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ezɨ dughiar kamra gumazir pumuning Emeusɨn nguibamɨn zui, Emeusɨn nguibamɨn ikegha Jerusalemɨn zuir tuavimɨn ruarim, a 11 kilomita. ");
INSERT INTO msy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ezɨ aning bizir otivizir kabar gun uaningra uaningɨn mɨgei. ");
INSERT INTO msy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Egha aning bizir kabav gɨa uaningɨn azangsɨzima, Iesus uabɨ otogha aning ko me zui. ");
INSERT INTO msy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ezɨ aning an garava egha deragha a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ezɨ an aningɨn azara, “Gua tizibar uaningɨn mɨgɨa tuavimɨn zui?” Ezɨ aning tughava an garava bar osemegha aziasava ami. ");
INSERT INTO msy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ezɨ aningɨn mav, an ziam Kliopas, an azara, “Jerusalemɨn izezir gumaziba bar bizir kam gɨfo. Ezɨ nɨ ti uabɨra dughiar gɨvazibar Jerusalemɨn bizir kabagh fozir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ezɨ Iesus aningɨn azara, “Bizir tiziba?” Ezɨ aning a ikaragha ghaze, “Ga Nasaretɨn Iesus bativizir bizibav gei. A Godɨn akam inigha izir gumazir mam, ezɨ an akaba ko ingangariba God ko gumaziba bar men damazimɨn bar gavgafi. ");
INSERT INTO msy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ezɨ en ofa gamir gumazir ekiaba ko en gumazir aruaba a isa gavmanɨn dafarim gatɨzɨ, me a mɨsoghezɨ an areme, ezɨ me ter ighuvimɨn a gura. ");
INSERT INTO msy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ezɨ e faragha nɨghnɨzir gavgavim kamaghɨn an iti, a God Ua Israelba Iniasa Mɨsevezir Gumazim. “Ezɨ mɨgɨrɨgɨar mam ua iti, bizir kaba otivigha gɨvazɨ, ezɨ datɨrɨghɨn an aremezir dughiar mɨkezim oto. ");
INSERT INTO msy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Ezɨ datɨrɨghɨn en amizir maba mɨzaraghara mozimɨn ghuegha an kuamɨn apizir puvatɨ. Egha iza e mɨkemezɨ, e bar aguaghfa. Egha me ghaze, e irebamɨn mɨn enselbar garima, me kamaghɨn e mɨgɨa ghaze, a ua dɨkafi. ");
INSERT INTO msy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ezɨ en marazi mozimɨn ghuegha amiziba mɨkemezɨ moghɨn bizibar gari da iti, ezɨ me an apizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ezɨ Iesus kamaghɨn aning mɨgei, “Gua gumazir onganimning! Gua Godɨn akam inigha izir gumazimɨn akaba nɨghnɨzir gavgavim koma navim zuamɨrama adar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ezɨ gua ti fozir puvatɨ? God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim, faragh mɨzaziba inigh egh gɨn Godɨn damazimɨn ziar ekiam iniam.” ");
INSERT INTO msy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Egha Iesus aning geghari. A faragha Moses osirizir akabav gɨa, ghua Godɨn akam inigha izir gumazibar akaba bar aning mɨgei. A Godɨn Akɨnafarimɨn itir akar an gun mɨkemeziba, dar mɨngariba bar aningɨn sure gami. ");
INSERT INTO msy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Egha me nguibar me ikiamimɨn boroghɨra ghuava, Iesus aning bada ghuavɨra itima, ");
INSERT INTO msy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","aning a mɨgɨa ghaze, “Aruem bar gɨvazɨma amɨnim pɨri. Nɨ ga ko dakuam.” Ezɨma a ghuava aning koma akui. ");
INSERT INTO msy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Egha Iesus damasa aning koma aperaghav ikia, bret inighava Afeziar Ekiam mɨnabagha, bret abigha aning ganɨdi. ");
INSERT INTO msy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ezɨ aning datɨrɨghɨn an garava a gɨfofozima, a pura puvatɨ. ");
INSERT INTO msy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ezɨma aning maghɨra uaningɨn mɨgei, “A tuavimɨn ga batogha Godɨn Akɨnafarimɨn akabar ga mɨgeima, gan navimning dɨkafi.” ");
INSERT INTO msy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Egha aning dɨkavigha zuamɨra ghua Jerusalemɨn uamategha ghua garima, 11 pla Iesusɨn suren gumaziba, me marazi ko me uari akuvagha itima, ");
INSERT INTO msy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","aning kamaghɨn me mɨgei, “Bar guizbangɨra! Iesus aremegha dɨkavigha ghua Saimon bato!” ");
INSERT INTO msy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ezɨ aning maghɨra tuavimɨn otivizir bizibar gun me mɨgɨava ghaze, a bret abɨghizɨma aning an ganighava a gɨfo. ");
INSERT INTO msy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iesusɨn suren gumazir 11 pla ko marazi, bizir kabar gun uariv geima, Iesus pura men tongɨn tughav ikia, a kamaghɨn me mɨgei, “Navir amɨrizim ia ko iti.” ");
INSERT INTO msy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ezɨ me bar atiatigha ghaze, me duamɨn gari. ");
INSERT INTO msy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ezɨ a kamaghɨn me mɨgei, “Ia tizim bagha atiatiava nɨghnɨzir avɨribagh ami? ");
INSERT INTO msy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ia kagh nan dafariba ko dagaribar gan. Egh ia fogh suam, kar kɨ Iesus uabɨ. Egh ia nan suigh ia fogh. Duam aghariba ko nivafɨziba puvatɨ. Ezɨ ia nan gari, kɨ da iti.” ");
INSERT INTO msy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A kamaghɨn mɨkemegha uan dafariba ko dagariba men akakasi. ");
INSERT INTO msy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Egha me bar akuegha tintinibar nɨghnɨgha, egha nɨghnɨzir gavgavim an itir puvatɨ. Ezɨ a men azara, “Ia damamin daghetam iti?” ");
INSERT INTO msy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ezɨ me osirir tuazimɨn akuam a ganɨngizɨma, ");
INSERT INTO msy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","a men damazibar a inighava anepi. ");
INSERT INTO msy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Egha a kamaghɨn me mɨgei, “Fomɨra Moses Osirizir Araziba, ko Godɨn akam inigha izir gumazibar osiziriba, ko Devitɨn ighiaba, da nan gun mɨkemezir biziba, da bar moghɨra guizɨn otivam. Kar bizir kɨ ia ko ikia ia mɨkemeziba.” ");
INSERT INTO msy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Egha a nɨghnɨzir aghuiba me ganɨngizɨma me Afeziar Ekiamɨn Akɨnafarimɨn akabar mɨngaribagh fo. ");
INSERT INTO msy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ezɨ a kamaghɨn me mɨgei, “Afeziar Ekiamɨn Akɨnafarim kamaghɨn mɨkeme, God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim, Krais, an aremegh dughiar pumuning ko mɨkezimɨn ikegh uamategh mozimɨn dɨkavigham. ");
INSERT INTO msy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Egh ia nan ziamɨn ia nan akam inigh mangam. Ia Jerusalem ikeghɨva nan akam inighɨva nguazimɨn mɨkebaba bar dar mangɨ. Ia gumazamizibav kɨmtɨ, me navibagh iraghtɨ kɨ men arazir kuraba gɨn amadagham. ");
INSERT INTO msy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ia uari uan damazibar bizir kabar ganizɨ moghɨn dar gun mɨkɨm. ");
INSERT INTO msy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ia oragh. Afeziam faragha akam akɨragha ghaze, a uan Duam isɨ ia danɨngam. Ezɨ kɨ a mɨkemezɨ moghɨn, ia bagh anemangam. Kamaghɨn ia nguibar ekiamɨn ikɨ. Egh mamaghɨra ikɨ mangɨ dughiar God ko itir gavgavim izighrɨtɨma ia a iniam.” ");
INSERT INTO msy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Egha Iesus uan suren gumaziba inigha ghuava Betanin boroghɨn itir danganimɨn tu. Egha a uan agharim ghufegha arazir aghuim me damuasava Godɨn azai. ");
INSERT INTO msy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","An arazir aghuim me damuasa Godɨn azavɨra itima, God a inigha uan Nguibamɨn ghuavanadi. ");
INSERT INTO msy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ezɨma me an ziam fa bar akuegha uamategha Jerusalemɨn zui. ");
INSERT INTO msy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Egha me Godɨn Dɨpenimɨn aven ikiava an ziam fa mamaghɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bar fomɨra fomɨra, biziba bar tɨghar otivamin dughiam, Akam iti. Akar kam God ko iti, egha a uabɨ God. ");
INSERT INTO msy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bar fomɨra fomɨra Akam God ko iti. ");
INSERT INTO msy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ezɨ Akar kamɨn, God biziba bar dar ingarizɨma, da otifi. Ezɨ bizitam tuavir igharazi tamɨn otozir puvatɨ. Akam uabɨ bizibagh amizɨma, da otifi. ");
INSERT INTO msy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Egha Akar kamra, a zurara itir ikɨrɨmɨrir aghuarimɨn mɨngarim. Ezɨ ikɨrɨmɨrir aghuarir kam, a uaghan gumazamiziba angazangarim me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ezɨ angazangarir kam a mɨtatemɨn isima, mɨtatem anevaraghava egha anemungezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ezɨ God gumazir mam amada, an ziam Jon. ");
INSERT INTO msy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","An akam akunasa ize. An angazangarir kamɨn akamɨn gun mɨkɨmtɨma, gumazamiziba bar moghɨra a baraghɨva egh nɨghnɨzir gavgavim an ikiam. A ingangarir kam damuasa ize. ");
INSERT INTO msy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Egha Jon uabɨ angazangarir kam puvatɨ. An angazangarir kamɨn akamɨn gun mɨkɨmasa ize. ");
INSERT INTO msy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ezɨ angazangarir kam guizbangɨn angazangarim. Egha nguazir kamɨn izegha gumazamiziba bar angazangarim me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Akam nguazir kamɨn iti. An gavgavimɨn, God nguazir kamɨn ingari, ezɨ nguazimɨn itir gumazamiziba a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","A uan nguibamra ghuzɨma an anababa an aghuagha a inizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ezɨ gumazamizir maba a ini, egha nɨghnɨzir gavgavim an ziamɨn iti. Kamaghɨn amizɨ, a me gamizɨma me Godɨn boribar mɨn otifi. ");
INSERT INTO msy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Me amebaba ko afeziabar ghuzibar otifi, o mɨkarzibar ifongiamɨn, o gumazimɨn ifongiamɨn Godɨn boribar otivizir puvatɨ. Bar puvatɨ. God uabɨ me gamizɨma me an boribar otifi. ");
INSERT INTO msy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Akam uabɨ gumazimɨn mɨn oto. A bar Godɨn Otarir vamɨra, ezɨ God a gamizɨ a Godɨn gavgavim ko angazangarim ini. Ezɨ God anemadazɨma an en tongɨn iti. Ezɨ e an gavgavim ko angazangarimɨn gani. Ezɨ apangkuvim ko guizɨn akam bar a gizɨfa. ");
INSERT INTO msy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ezɨ Jon gumazir kamɨn gun me mɨgei. Egha pamten dia ghaze, “A gumazir kam, kɨ faragha an gun ia mɨkemegha gɨfa. Kɨ kamaghɨn mɨgei, ‘Gumazir nan gɨn izim, a bar fomɨra iti, ezɨ nan amebam gɨn na bate. Kamaghɨn amizɨ, an gavgavim bar nan gavgavim gafira.’” ");
INSERT INTO msy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ezɨ apangkuvim bar a gizɨfa, ezɨ a uan apangkuvimɨn a dughiar avɨribar bar deravɨra e gami. ");
INSERT INTO msy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Guizbangɨra, Moses Osirizir Araziba, God e bagha da isa Moses ganɨngizɨ, ezɨ Moses e ganɨngi. Ezɨ God, Krais Iesusɨn aven apangkuvim ko guizbangɨn arazim en aka. ");
INSERT INTO msy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gumazitam bar Godɨn ganizir puvatɨ. Ezɨ kar Godɨn Otarir vamɨra, a uabɨ God, egha a bar Godɨn boroghɨra iti. A uabɨra God en aka. ");
INSERT INTO msy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ezɨ Judan gumazir aruaba, me ofa gamir gumazir maba ko Livain gumazir maba amadazɨ, me Jerusalem ategha Jon bagha iza kamaghɨn an azara, “Nɨ tinara?” ");
INSERT INTO msy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ezɨ Jon bighavɨra mɨgɨa akam modir puvatɨ. A kamaghɨn mɨgei, “Kɨ God Ua Gumazamiziba Iniasa Mɨsevezir Gumazim puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ezɨ me an azara, “Nɨ tinara? Nɨ ti Elaija, o?” Ezɨ a mɨgei, “Puvatɨ.” Ezɨ me mɨgei, “Nɨ ti Godɨn akam inigha izir gumazir kamra, e nɨ mɨzuai.” Ezɨ an akam ikara, “Puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kamaghɨn amizɨma, me uam an azara, “Nɨ bar tinara? E ikarvazir aghuitam inigh mangɨva gumazir e amadazɨbav kɨmam. Nɨ manmaghɨra uabɨ mɨgei?” ");
INSERT INTO msy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ezɨ Jon kamaghɨn mɨgei, “Kɨ gumazir kamɨn tiarim, kɨ gumaziba puvatɨzir danganimɨn ikia egha kamaghɨn dɨa mɨgei, ‘Ia Ekiam bagh tuavim akɨr.’” (Kar akar Godɨn akam inigha izir gumazim Aisaia fomɨra osirizim.) ");
INSERT INTO msy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gumazir kaba, Farisiba me amangizɨ me ize. ");
INSERT INTO msy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Egha me kamaghɨn Jon azara, “Nɨ Gumazir God Ua Gumazamiziba Iniasa Mɨsevezim puvatɨgh, egh nɨ Elaija puvatɨgh, egh nɨ Godɨn akam inigha izir gumazir kam puvatɨgha, egha nɨ tizim sua gumazamiziba rue?” ");
INSERT INTO msy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ezɨ Jon kamaghɨn men akam ikara, “Kɨ dɨpamɨn me rue. Ezɨ gumazir mam ian tongɨn iti, ia a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A gumazir kam, a nan gɨn izi. Kɨ an dagarir asuabar beniba fɨran ibura.” ");
INSERT INTO msy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jon Betanin nguibamɨn ikia akar kam me mɨkeme, nguibar kam Jordanɨn dɨpamɨn vongɨn iti. Danganir kamɨn Jon gumazamiziba rue. ");
INSERT INTO msy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ezɨ amɨmɨzarakan Jon Iesusɨn garima an a bagha izi. Ezɨ Jon kamaghɨn mɨgei. “Ia munagh gan! Munar Godɨn Sipsipɨn Nguzim. A nguazimɨn itir gumazamizibar arazir kuraba gɨn amadi! ");
INSERT INTO msy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A gumazir kam, kɨ fomɨra kamaghɨn an gun mɨkeme, ‘Gumazir nan gɨn izim, a bar fomɨra iti, ezɨ nan amebam gɨn na bate. Kamaghɨn amizɨ, an gavgavim bar nan gavgavim gafira.’ ");
INSERT INTO msy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kɨ uabɨ a gɨfozir puvatɨ, a tina. Kɨ gumazir kam aghurightɨma, Israelɨn gumazamiziba a gɨfoghasa, kamaghɨn kɨ iza dɨpamɨn gumazamiziba rue.” ");
INSERT INTO msy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ezɨ Jon ua kamaghɨn an gun mɨgei, “Kɨ garima Godɨn Duam kuarazir bunbamɨn mɨn Godɨn Nguibam ategha mɨghegha izaghira gumazir kam gisɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kɨ uabɨ a gɨfozir puvatɨ. God dɨpamɨn gumazamiziba ruasa na amadazɨ kɨ ize. A faragha kamaghɨn na mɨkeme, ‘Nɨ gantɨma, Godɨn Duam izighrɨghɨva, gumazitam gisɨn ikiam, a gumazir kamra, a Godɨn Duamɨn gumazamiziba ruam.’ ");
INSERT INTO msy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kɨ uabɨ bizir kamɨn ganigha egha an gun kamaghɨn ia mɨgei, gumazir kamra, a Godɨn Otarim.” ");
INSERT INTO msy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Egha amɨmɨzarakan Jon uan suren gumazir mamning ko ua danganir kamɨn tuivighav iti. ");
INSERT INTO msy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ezɨ a garima Iesus a gitavɨrazɨma, Jon aning mɨgei, “Gua gan! Kar Godɨn Sipsipɨn Nguzim!” ");
INSERT INTO msy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ezɨ suren gumazir kamning a barazima a kamaghɨn akar kam mɨkemezɨma, aning ghua Iesusɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ezɨ Iesus ikɨgha gara aningɨn azara, “Gua tizim buri?” Ezɨ aning an azara, “Rabi, nɨ dɨpenir manamɨn iti?” (Ziar kam “Rabi” an mɨngarim kamakɨn, “Tisa.”) ");
INSERT INTO msy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ezɨ Iesus kamaghɨn aning mɨgei, “Gua izɨ ganigh.” Ezɨ aning ghua dɨpenir a itimɨn gari. Dughiam, 4 kloghɨn guaratɨzim. Ezɨ dughiar kam aning a ko iti. ");
INSERT INTO msy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Egha Andru, a Iesusɨn gɨn zuir gumazir kamningɨn mav. A Saimon Pitan aveghbuam. ");
INSERT INTO msy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Egha Andru Iesus ategha maghɨra ghua uan aveghbuam Saimon batogha, egha kamaghɨn a mɨgei, “E Mesaian gani.” (Ziar kam “Mesaia” a kamakɨn, “Gumazir God Ua E Iniasa Mɨsevezim.”) ");
INSERT INTO msy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Egha Andru Saimon inigha Iesus bagha ghu. Ezɨ Iesus an gara egha mɨgei, “Nɨ Saimon, Jonɨn Otarim. Eghtɨ me gɨn ziam ‘Sifas’ nɨ darɨgh nɨ dɨponam.” (Ziar kam “Sifas,” a ziar kam “Pitan” mɨrara ghu. An mɨngarim kamakɨn, “Dagɨam.”) ");
INSERT INTO msy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Egha amɨmɨzarakan, Iesus Galilin Distrighɨn mangasa. Egha a ghua Filip batogha, kamaghɨn a mɨgei, “Nɨ nan gɨn izɨ!” ");
INSERT INTO msy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filip a Betsaidan nguibamɨn gumazir mam. Andru ko Pitan nguibam, Betsaida.) ");
INSERT INTO msy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ezɨ Filip ghua Nataniel batogha kamaghɨn a mɨgei, “E gumazir kamɨn ganigha gɨfa, Moses fomɨra Judabar Arazibar Akɨnafarimɨn osira gumazir kamɨn gun osiri. Ezɨ Godɨn akam inigha izir gumaziba uaghan gumazir kamɨn gun osiri. A Nasaretɨn nguibamɨn gumazim Iesus, a Josepɨn otarim.” ");
INSERT INTO msy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ezɨ Nataniel kamaghɨn an azara, “Ti akurvazir bizir aghuitam Nasaretɨn nguibamɨn otivam? Ti puvatɨgham!” Ezɨ Filip a mɨgei, “Nɨ izɨ ganigh.” ");
INSERT INTO msy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ezɨ Iesus garima Nataniel a bagha izi. Ezɨ a kamaghɨn mɨgei, “Ia ganigh. Gumazir izir kam, a guizbangɨra Israelɨn gumazim. Ezɨ ifavarir akatam ko ifavarir arazir tam an itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ezɨ Nataniel kamaghɨn Iesusɨn azara, “Nɨ manmaghɨn na gɨfo?” Ezɨ Iesus kamaghɨn an akam ikara, “Filip tɨghar nɨn dɨmamin dughiamɨn, nɨ temer fighɨn povimɨn itima, kɨ nɨn gani.” ");
INSERT INTO msy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ezɨ Nataniel akar kam baregha egha kamaghɨn a ikara, “Tisa, nɨ Godɨn Otarim! Nɨ Israelbar Atrivim!” ");
INSERT INTO msy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ kamaghɨn nɨ mɨgei, nɨ temer fighɨn povimɨn itima, kɨ nɨn gani. Ezɨ bizir muziarir kamɨn, nɨ nɨghnɨzir gavgavim nan iti. Nɨ gɨn bizir ekiabar gantɨ da bizir kam bar a gafiragham.” ");
INSERT INTO msy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Egha Iesus ua kamaghɨn me mɨgei, “Kɨ guizbangɨra ia mɨgei, ia gɨn Godɨn Nguibamɨn gantɨ a kuighrɨgham, eghtɨ ia Godɨn enselbar gantɨ da Gumazibar Otarim bagh ghuavanangɨva, ua izighram.” ");
INSERT INTO msy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dughiar pumuning gɨvazɨma, gumazir mam Kanan nguibamɨn ikia amizimɨn ikiasa, ezɨ amuimɨn ikiamin isam oto. Kanan nguibam a Galilin Distrighɨn aven iti. Dughiar kam Iesusɨn amebam uaghan iti. ");
INSERT INTO msy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ezɨ me uaghan Iesus uan suren gumaziba ko men diazɨma me uaghan amuimɨn ikiamin isar kamɨn ghuegha iti. ");
INSERT INTO msy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ezɨ wainɨn dɨpam gɨvazɨma, Iesusɨn amebam kamaghɨn a mɨgei, “Me ua wainɨn dɨpaba puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ezɨ Iesus kamaghɨn a mɨgei, “Amebam, kar nɨn bizim, a nan bizim puvatɨ. Nan dughiam a tɨgharɨ.” ");
INSERT INTO msy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ezɨ an amebam ingangarir gumazibav gei, “A bizitam damusɨ ia mɨkɨmtɨ, ia a damu.” ");
INSERT INTO msy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ezɨ dɨpenir kamɨn 6 plan dagɨar mɨner ekiaba iti, da ekevegha egha vaghvagha 100 litan dɨpaba dar iti. Judaba uan rurir arazibar gɨn ghua dɨpar kabagh rue. ");
INSERT INTO msy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ezɨ Iesus kamaghɨn ingangarir gumazibav gei, “Ia mɨner kabar dɨpaba tuigh.” Ezɨ me da tuizɨma da bar izevegha akabagh imara. ");
INSERT INTO msy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ezɨ a kamaghɨn me mɨgei, “Ia datɨrɨghɨn mɨner nguzim inigh dɨpatam tuighɨva a inighɨva gumazir isamɨn faragha zuim bagh mangɨ.” Ezɨ ingangarir gumaziba maba inigha zui. ");
INSERT INTO msy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ezɨ dɨpar kam wainɨn dɨpamɨn otogha gɨfa, ezɨ gumazir isamɨn faragha zuim anepava a barasi, egha a fozir puvatɨ, me managh wainɨn dɨpar kam ini. Ezɨ ingangarir gumazir dɨpam tuiziba, merara fo. Kamaghɨn amizɨ, isamɨn faragha zuir gumazim a gumazir amuimɨn ikiasava amim, an dia, ");
INSERT INTO msy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","egha kamaghɨn a mɨgei, “Gumaziba bar wainɨn dɨpar aghuim faragha me ganɨdi. Ezɨ gumaziba wainɨn avɨrim amegha gɨvazɨma, me gɨn wainɨn dɨpar mong afangizim anɨdi. Ezɨ no, nɨ wainɨn dɨpar aghuimɨn anogoregha, egha datɨrɨghɨra nɨ a inigha izi!” ");
INSERT INTO msy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kar mirakelɨn arazir faragha zuir Iesus amizim. A Galilin Distrighɨn aven itir nguibam Kanan, mirakelɨn arazir kam gami. Ezɨ mirakelɨn kamɨn, Iesus bar uan gavgavir ekiam aka. Ezɨ an suren gumaziba an ganigha egha nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ezɨ bizir kabar gɨn, Iesus uan amebam ko aveghbuaba ko an suren gumaziba, me Kanan ategha Kaperneamɨn nguibamɨn ghuaghiri. Egha me dughiar mabar nguibar kamɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ezɨ Israel bagh Itazir Dughiamɨn Isam otivasa roghɨra izima, ezɨ bizir kam bagha Iesus Jerusalemɨn nguibar ekiamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Egha a Godɨn Dɨpenimɨn avɨzimɨn aven ghua bizibar garima, gumaziba dagɨaba iniasa bulmakauba ko sipsipba ko kuaraziba amadi. Ezɨ a garima dagɨaba uari ikarvazir gumaziba apiaghav iti. ");
INSERT INTO msy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ezɨ Iesus beniba inigha bɨzimɨn mɨn a da ike. Egha a gumaziba ko men sipsipba ko bulmakauba bar me batoke, ezɨ me Godɨn Dɨpenimɨn avɨzim ategha zui. Ezɨ a dagɨaba uari ikarvazir gumazibar dakoziba akuri da ira dagɨaba akɨziragha tintinibar zui. ");
INSERT INTO msy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ezɨ a kamaghɨn gumazir dagɨaba bagha kuaraziba amadiba pamten me mɨgei, “Ia kuaraziba inigh mangɨ! Ia nan Afeziamɨn dɨpenim biziba amadir danganimɨn mɨn a damuan markɨ.” ");
INSERT INTO msy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ezɨ an suren gumaziba an amizir arazir kamɨn ganigha, egha me Godɨn Akɨnafarimɨn itir akar mam ginɨrɨ. Akar kam a kamakɨn, “Nan navir averiam bar nɨn dɨpenim gɨfuegha egha a baghavɨra iti.” ");
INSERT INTO msy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ezɨ Judan gumazir aruaba Iesus amizir arazir kamɨn ganigha, egha me kamaghɨn an azara, “Nɨ mirakelɨn arazir manam damigh en akagh suam, nɨ gavgavim ikia gatɨrɨghɨn arazir kam gami?” ");
INSERT INTO msy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ezɨ Iesus kamaghɨn men akam ikara, “Ia Godɨn dɨpenir kam apɨrightɨ, eghtɨ kɨ dughiar pumuning ko mɨkezimɨn uam an ingarightɨma a tugham.” ");
INSERT INTO msy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ezɨ Judaba kamaghɨn mɨgei, “Me 46 plan azenibar Godɨn Dɨpenir kamɨn ingari. Eghtɨ nɨ ti dughiar pumuning ko mɨkezimɨn a ingarightɨ a tugham, o?” ");
INSERT INTO msy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ezɨ Iesus mɨgeir Godɨn dɨpenir kam, an mɨkarzimra. ");
INSERT INTO msy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ezɨ God gɨn mozimɨn a gamizɨma a ua dɨkafi, ezɨ an suren gumaziba ua akar a fomɨra mɨkemezir kam ginɨrɨ. Egha akar Godɨn Akɨnafarimɨn itim ko akar Iesus mɨkemezir kam nɨghnɨzir gavgavim dar iti. ");
INSERT INTO msy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ezɨ Iesus Israel bagh Itazir Dughiamɨn Isamɨn Jerusalemɨn itima, gumazamizir avɨrim mirakelɨn arazarazir Iesus amizibar gani. Kamaghɨn amizɨma me nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ezɨ Iesus, a bar men araziba ko nɨghnɨzibagh fo. Kamaghɨn, a nɨghnɨzir gavgavim men itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","A uabɨ gumazibar navir averiabar aven itir nɨghnɨzibagh fogha gɨfa. A fofozitamɨn otevezir puvatɨ, eghtɨ gumazitam gumazibar arazibar gun a mɨkɨman kogham. ");
INSERT INTO msy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Gumazir mam iti, an ziam Nikodemus, a Farisin mam, egha a Judabar gumazir aruar mam. ");
INSERT INTO msy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Dɨmagarir mam gumazir kam Iesus bagha izegha kamaghɨn a mɨgei, “Tisa, e fo, God tisan mɨn nɨ amadazɨma nɨ ize. E fo, God gumazitam ko ikian koghtɨma, eghtɨ gumazir kam mirakelɨn nɨ amir kaba, a tam damuva avegham.” ");
INSERT INTO msy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ bar guizbangɨra nɨ mɨgei. Gumazitam ua gumazir igiamɨn otoghan koghɨva, a God Bizibagh Ativamin Dughiamɨn aven ikian kogham.” ");
INSERT INTO msy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ezɨ Nikodemus an azara, “Manmaghɨra gumazim ghurigha gɨvagha egha ua igiam gava? A ti uamategh uan amebamɨn navir averiamɨn mangɨtɨ an amebam uam a bategham?” ");
INSERT INTO msy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ezɨ Iesus kamaghɨn a ikara, “Kɨ guizbangɨra nɨ mɨgei, gumazitam dɨpam ko Godɨn Duamɨn ua gumazir igiamɨn otoghan kogh, egh a God Bizibagh Ativamin Dughiamɨn aven ikian kogham. ");
INSERT INTO msy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nguazir kamɨn itir amiziba boriba batima, borir igiaba otifi. Ezɨ Godɨn Duam gumazimɨn duam gamima, a gumazir igiamɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nɨ akar kɨ nɨ mɨkemezimɨn nɨ dɨgavir kuram damuan markɨ, ‘Ia ua igiabar otifigh.’ ");
INSERT INTO msy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Amɨnim a uan ifongiamɨn gɨn tɨgha egha pura tintinibar vua zui. Nɨ an nɨgɨnim barasi, egha nɨ fozir puvatɨ, a managh iza egha ua managh zui. Kamaghɨra, Godɨn Duam gumaziba bar me gamima me igiabar otifi.” ");
INSERT INTO msy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ezɨ Nikodemus kamaghɨn an azara, “Bizir nɨ mɨgeir kam, a manmaghɨn otogham?” ");
INSERT INTO msy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ezɨ Iesus kamaghɨn an akam ikara, “Manmaghɨn ami? Nɨ Israelbar tongɨn itir tisan ekiam, egha nɨ ti bizir kabagh fozir puvatɨ, o? ");
INSERT INTO msy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kɨ guizbangɨra nɨ mɨgei, e fozir bizim e a mɨgei. Egha e bizir e ganizimɨn gun mɨgei. Ezɨ ia, e mɨkemezir akam akɨrim ragha a gasara. ");
INSERT INTO msy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kɨ nguazir kamɨn bizibar ia mɨkeme, ezɨ ia nɨghnɨzir gavgavim dar itir puvatɨ. Eghtɨ kamaghɨn kɨ Godɨn Nguibamɨn bizibar ia mɨkɨmtɨ, ia manmaghɨn nɨghnɨzir gavgavim dar ikiam? ");
INSERT INTO msy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gumazir igharazitam Godɨn Nguibamɨn ghuavanabozir pu. Puvatɨ. Gumazibar Otarim uabɨra Godɨn Nguibam ategha zaghirɨ. ");
INSERT INTO msy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Fomɨra Moses gumaziba puvatɨzir danganimɨn ikia kuruzimɨn nedazir aghorimɨn itim a ghufe, eghtɨ kamaghɨra me Gumazibar Otarim ghufam. ");
INSERT INTO msy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","God kamagh sua, gumazir nɨghnɨzir gavgavim Gumazibar Otarimɨn itiba, me bar zurara itir ikɨrɨmɨrir aghuarim iniam. Bizir kam bagh me Gumazibar Otarim ghufam. ");
INSERT INTO msy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“God Otarir bar vamɨra iti. Egha God nguazimɨn itir gumazamiziba, bar me gifonge. A kamagh sua, gumazamiziba bar nɨghnɨzir gavgavim an Otarimɨn ikɨva ovengan koghɨva, zurara itir ikɨrɨmɨrir aghuarim iniam. Bizir kam bagha an Otarir bar vamɨran kam me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God uan Otarim nguazimɨn gumazamizibar jasɨn mɨn me tuisɨghasa anemadazir puvatɨ. A men akurvaghasa anemada. ");
INSERT INTO msy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Gumazim nɨghnɨzir gavgavim Otarimɨn ti, a kotiaba puvatɨ. Ezɨ gumazim nɨghnɨzir gavgavim an ikian aghua, a kotɨn ikia bar ovegha gɨfa. A nɨghnɨzir gavgavim Godɨn Otarir vamɨran kamɨn itir puvatɨ, kamaghɨn an ovegha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ezɨ Godɨn kotiamɨn mɨngarimɨn arazim kamakɨn, Godɨn angazangarim nguazimɨn izegha gɨfa. Ezɨ gumazamiziba, me amir araziba bar ikufi, kamaghɨn amizɨ me mɨtatem bagha bar ifonge, me angazangarimɨn aghua. ");
INSERT INTO msy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Gumazir arazir kurabagh amiba bar, angazangarimɨn apaniba. Men arazir kuraba azenim giran me aghua, kamaghɨn amizɨ me angazangarimɨn izir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ezɨ gumazir guizbangɨn arazim gamim, a Godɨn angazangarimɨn izi. A kamaghɨn ifonge, Godɨn angazangarim deravɨra kamaghɨn gumazamizir igharazibar akagham, a Godɨn gavgavimɨn uan ingangarim gami. Ezɨ kamaghɨn gumazir kam Godɨn angazangarimɨn aven izi.” ");
INSERT INTO msy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ezɨ bizir kabar gɨn Iesus uan suren gumaziba ko me Judian Distrighɨn zui. A me ko danganir kam ikia gumazamiziba rue. ");
INSERT INTO msy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon Ainonɨn nguibamɨn ikia gumazamiziba rue, Salimɨn nguibamɨn boroghɨra. Dɨpar avɨrim danganir kamɨn ti, ezɨ gumazamizir avɨrim rurim iniasa izi. ");
INSERT INTO msy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Dughiar kam Herot Jon tɨghar a isɨ kalabus darɨgham.) ");
INSERT INTO msy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ezɨ akavdorozir mam Jonɨn suren gumaziba ko Judan gumazir mamɨn tongɨn oto. Me uari adogha ghaze, e rurir arazir manamɨn gɨn mangɨ, Godɨn damazim zuegham? ");
INSERT INTO msy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Egha suren gumaziba Jon bagha ghuegha kamaghɨn a mɨgei, “Tisa, gumazir kam fomɨra nɨ ko Jordanɨn dɨpamɨn vongɨn ike, ezɨ nɨ an gun mɨkeme, gumazir kam datɨrɨghɨn gumazamiziba ruema, gumazamiziba bar a bagha zui.” ");
INSERT INTO msy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ezɨ Jon kamaghɨn ikara, “Godɨn uan Nguibamɨn itim, bizitam gumazim danigan koghtɨ, an a inighan kogham. ");
INSERT INTO msy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kɨ fomɨra akar kam ia mɨkeme, ezɨ ia uari a baraki, ‘Kɨ God Ua E Iniasa Mɨsevezir Gumazim puvatɨ. God na amadazɨma kɨ an faragha ize.’ ");
INSERT INTO msy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gumazitam amizitamɨn ikiam, eghtɨ amizir kam a gumazir kamɨn amuim. Ezɨ gumazir kamɨn namakam, a tugha gumazir amuimɨn itimɨn akam baraghasa bar akonge. Ezɨ kamaghɨra agorogem nan navir averiam bar a gizɨfa. ");
INSERT INTO msy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","An ziam bar ekevegh mamaghɨra ikɨtɨ, eghtɨ nan ziam bar magɨrɨgh. ");
INSERT INTO msy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Gumazir Godɨn Nguibamɨn pɨn ikegha izezim, a bar bizibagh isɨn iti. Ezɨ nguazir kamɨn gumazim, a nguazir kamɨn bizibagh amua egha nguazir kamɨn bizibav gei. Ezɨ gumazir Godɨn Nguibamɨn izezim a bar bizibar isɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","A bizir a ganiziba ko oraghizibar gun mɨgei. Ezɨ gumazitam a mɨkemezir akar katam inigha nɨghnɨzir gavgavim an itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ezɨ gumazim an akam inigha nɨghnɨzir gavgavim an ikia, egha tuavir kamɨn kamaghɨn men aka, God a guizɨn akam mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gumazir God amadazir kam, God uan Duam isa bar a ganɨngi. Kamaghɨn amizɨ, a Godɨn akam akuri. ");
INSERT INTO msy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afeziam uan Otarim bar a gifonge, egha biziba bar an agharim gatɨzɨ a bar dagh atifa. ");
INSERT INTO msy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Gumazim nɨghnɨzir gavgavim Otarimɨn ti, a zurara itir ikɨrɨmɨrir aghuarim iti. Ezɨ gumazim Otarimɨn akamɨn gɨn zuir puvatɨ, a zurara itir ikɨrɨmɨrir aghuarim inian kogham, Godɨn anɨngagharim an ikɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ezɨ Farisiba kamaghɨn oraki, Iesus gumazamizir avɨriba rue ezɨ gumazamizir kaba an suren gumazibar otifi. Ezɨ men dɨbobonim Jonɨn suren gumazibar dɨbobonim gafira. ");
INSERT INTO msy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Guizbangɨra, Iesus uabɨ gumazamiziba ruer puvatɨ. An suren gumaziba me rue.) ");
INSERT INTO msy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iesus kamaghɨn fo, Farisiba orazima gumazir avɨriba an suren gumazamizibar otifi, kamaghɨn a Judian Distrigh ategha uamategha Galilin Distrighɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ezɨ tuavir a zuir kam, a Samarian Distrigh abigha ghu. ");
INSERT INTO msy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Egha a ghua Samarian Distrighɨn aven itir nguibar mamɨn oto, an ziam Sikar. Ezɨ Sikarɨn nguibam, a nguazir Jekop uan otarim Josep ganɨngizimɨn boroghɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jekop fomɨra kuizir mozir dɨpam iti, a nguibar kamɨn ti. Ezɨ Iesus iza ghua bar amɨra. Egha a mozir dɨpar kamɨn boroghɨn apera. Ezɨ dughiam an aruer arɨzimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ezɨ Samarian amizir mam, a dɨpam tuasa izi, ezɨ Iesus kamaghɨn a mɨgei, “Nɨ dɨpatam na danɨngam, o?” ");
INSERT INTO msy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Dughiar kamɨn Iesusɨn suren gumaziba daghebagh ivezasa nguibamɨn ghu.) ");
INSERT INTO msy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ezɨ Samarian amizim a mɨgei, “Nɨ Judan gumazim ezɨ kɨ Samarian amizim. Manmagh sua, nɨ dɨpam ramasa na mɨgei?” (Amizir kam fo, Judaba me Samarian gumazamiziba ko itir puvatɨ, kamaghɨn an akar kam Iesus mɨgei.) ");
INSERT INTO msy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ezɨ Iesus kamaghɨn amizim ikara, “Nɨ, God gumazamizibagh anɨngizir bizir aghuim gɨfoghɨva, egh gumazir dɨpam bagha nɨ mɨgeir kam gɨfoghɨva, egh nɨ an azaraghtɨ, a dɨpar ikɨrɨmɨrir zurara itim anɨdim nɨ danigam.” ");
INSERT INTO msy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ezɨ amizim a mɨgei, “Gumazir ekiam, nɨ mɨneba pu. Mozir dɨpar kam bar kone. Eghtɨ dɨpar ikɨrɨmɨrir zurara itim anɨdim, nɨ managh a inigham? ");
INSERT INTO msy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","En ovavim Jekop mozir dɨpar kam e ganɨngi. Egha a uabɨ uan boriba ko bulmakauba ko an asɨziba, me bar mozir dɨpar kam ame. Ezɨ nɨ ghaze, nɨ ti Jekop gafira, o?” ");
INSERT INTO msy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ezɨ Iesus kamaghɨn an akam ikara, “Gumaziba bar dɨpar kam ramegh, men kuariba ua pɨram. ");
INSERT INTO msy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ezɨ gumazitam kɨ danɨngamin dɨpar kam ramegham, an kuarim dughiatamɨn uam an pɨran kogham. Puvatɨ. Dɨpar kɨ danɨngamin kam, a dɨpar nguazimɨn averiamɨn ikiava otivi moghɨra, an navir averiamɨn otivam. Egh dɨpar ikɨrɨmɨrir zurara itim anɨdir kam otiv mamaghɨra ikɨva, egh zurara itir ikɨrɨmɨrir aghuarim a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ezɨ amizim kamaghɨn Iesus mɨgei, “Gumazir ekiam, dɨpar kam na danɨng. Eghtɨ nan kuarim gɨn ua pɨran kogham, eghtɨ kɨ ua kagh izɨ dɨpam tuan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ezɨ Iesus kamaghɨn a mɨgei, “Nɨ mangɨ uan pamɨn diaghɨva egh gua kagh izɨ.” ");
INSERT INTO msy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ezɨ amizim a ikara, “Kɨ paba puvatɨ.” Ezɨ Iesus a mɨgei, “Are, nɨ deragha mɨgei, nɨ paba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Guizbangɨra, nɨ faragha 5 pla paba iti. Ezɨ gumazir nɨ datɨrɨghɨn itim, a guizbangɨra nɨn pam puvatɨ. Nɨn akar kam a bar guizbangɨra.” ");
INSERT INTO msy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ezɨ amizim a mɨgei, “Gumazir Ekiam, kɨ datɨrɨghɨn fo, nɨ Godɨn akam inigha izir gumazir mam. ");
INSERT INTO msy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","En ovaviba me mɨghsɨar kamɨn uari akuva, egha Godɨn ziam fe. Ezɨ ia Judaba ghaze, danganir gumaziba mangɨva Godɨn ziam fam, a Jerusalemɨn iti.” ");
INSERT INTO msy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ezɨ Iesus kamaghɨn a mɨgei, “Amizim, nɨ nɨghnɨzir gavgavim nan ikɨ. Dughiatam otoghtɨma ia mɨghsɨar kamɨn Afeziamɨn ziam fan koghɨva, egh uaghan Jerusalemɨn nguibamɨn an ziam fan kogham. ");
INSERT INTO msy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ia Samariaba ia fozir puvatɨzir God, ia an ziam fe. Ezɨ e Judaba e fozir God, e an ziam fe. E fo, Godɨn gumazamizibar akurvazir ingangarim, a faragh Judabar agharimɨn ikegh egh gɨn gumazamizir igharaziba bagh mangam. ");
INSERT INTO msy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ezɨ dughiar otivamim, an otogha gɨfa, ezɨ gumazamiziba bar guizbangɨra Afeziamɨn ziam fasa, me an Duamɨn gavgavim ko guizbangɨn arazimɨn an ziam fam. Ezɨ Afeziam, gumazamizir kamaghɨn amiba, me an ziam fasa a bar ifonge. ");
INSERT INTO msy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God, a Duam. Ezɨ gumazir an ziam feba, me Godɨn Duamɨn gavgavim ko guizbangɨn arazimɨn an ziam fe.” ");
INSERT INTO msy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ezɨ amizim kamaghɨn Iesus mɨgei, “Kɨ fo, Mesaia a izam (a God Ua E Iniasa Mɨsevezir Gumazim.) A izamin dughiam, a biziba bar e mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ezɨ Iesus kamaghɨn a mɨgei, “Kar kɨrara, datɨrɨghɨn nɨ ko mɨgei.” ");
INSERT INTO msy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ezɨ Iesus kamaghɨn mɨgeima, dughiar kamɨn an suren gumaziba uamategha izi. Me an garima an amizir mam ko uaning mɨgeima, ezɨ me okam nɨghnɨsi. Egha tav kamaghɨn amizimɨn azarazir puvatɨ, “Nɨ tizim iniasa?” Egha tav Iesusɨn azarazir puvatɨ, “Nɨ tizim sua amizir kam ko mɨgei?” ");
INSERT INTO msy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ezɨ amizir kam uan mɨnem ataki, egha uamategha nguibamɨn ghu. Egha kamaghɨn gumazamizibav gei, ");
INSERT INTO msy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ia izɨ gumazir mamɨn ganigh. Kɨ fomɨra amizir araziba, a bar dar na mɨkeme. Ka ti gumazir kamra, God Ua E Iniasa Mɨsevezir Gumazim?” ");
INSERT INTO msy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Egha me nguibam ategha, Iesus bagha izi. ");
INSERT INTO msy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ezɨ dughiar kamɨn, Iesusɨn suren gumaziba agakaghora kamaghɨn a mɨgei, “Tisa, nɨ damɨ.” ");
INSERT INTO msy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ezɨ a kamaghɨn me mɨgei, “Dagher kɨ damamim, ia a gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ezɨ an suren gumaziba uarira kamaghɨn uariv gei, “Gumazitam ti a bagha dagheba inigha iza a ganɨngi?” ");
INSERT INTO msy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ezɨ Iesus kamaghɨn me mɨgei, “Nan daghemra kara, kɨ Godɨn ifongiamɨn gɨn zui, a gumazir na amadazɨ kɨ izezim. Ezɨ kɨ a na ganɨngizir ingangarim, a gɨvagham. ");
INSERT INTO msy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ia kamaghɨn mɨgei, ‘4 plan iakiniba gɨvaghtɨ, e dar gɨn azenibar aghoram.’ Ezɨ kɨ ia mɨgei, ia tintinibar ganɨva egh deravɨra azenibar gan. Dagheba aghuigha gɨfa, ezɨ azenibar aghoramin dughiam otogha gɨfa! ");
INSERT INTO msy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Gumazir dagheba isim, a datɨrɨghɨn uan ivezim isi, egha zurara itir ikɨrɨmɨrir aghuarim bagha dagheba akufi. Kamaghɨn amizɨma, gumazir dagheba oparim ko gumazir dagheba isim aning vɨrara bar akuegham. ");
INSERT INTO msy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Akar kam a guizbangɨra, ‘Gumazir mam azenim opari, ezɨ gumazir igharazim an dagheba isi.’ ");
INSERT INTO msy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kɨ, ia faragha ingarizir puvatɨzir azenimɨn dagheba iniasa, kɨ ia amada. Gumazir igharaziba azenir kamɨn ingari, ezɨ ia ghua me uan gavgavimɨn oparizir otivizir dagheba isi.” ");
INSERT INTO msy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Amizir kam faragha ghaze, “Gumazir kam, kɨ fomɨra amizir araziba, a bar dar na mɨkeme.” Ezɨ nguibar kamɨn itir Samarian gumazamizir avɨriba, me an akam baregha egha kamaghɨn nɨghnɨzir gavgavim Iesusɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Egha Samariaba a bagha ize, egha me uarir gan ikiasa agakaghoravɨra iti. Ezɨ a dughiar pumuningɨn me ko iti. ");
INSERT INTO msy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ezɨ gumazamizir igharazir avɨrir maba, me uaghan Iesusɨn akam baregha nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Egha me kamaghɨn amizim mɨgei, “E nɨn akamra baregha nɨghnɨzir gavgavim gumazir kamɨn itir pu. Puvatɨ. E uari an akam baraki, egha e fo, gumazir kamra, a guizbangɨra nguazir kamɨn itir gumazamizibar Akurvazir Gumazim. Kamaghɨn e nɨghnɨzir gavgavim an iti.” ");
INSERT INTO msy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ezɨ Iesus dughiar pumuningɨn Samarian adarazi ko ikegha gɨvagha, egha nguibar kam ategha Galilin Distrighɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Iesus uabɨ mɨgɨrɨgɨar kam gami, “Godɨn akam inigha izir gumazim, a uan nguibamra ziaba puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilin Distrighɨn itir gumazamiziba, me uaghan Israel bagh Itazir Dughiamɨn Isam bagha Jerusalemɨn nguibamɨn ghue, ezɨ Iesus dughiar kamɨn mirakelɨn avɨribagh amizɨma me dar gani. Ezɨ kamaghɨn Iesus datɨrɨghɨn uamategha ghua Galilin otozɨma, ezɨ Galilin gumazamiziba bar akuegha a ini. ");
INSERT INTO msy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ezɨ Iesus ua Kanan nguibamɨn ghu, a Galilin Distrighɨn aven itir nguibam. A faragha nguibar kamɨn dɨpam girazɨma a wainɨn dɨpamɨn oto. Ezɨ dughiar kamɨn atrivimɨn ingangarir gumazir mam, a Kanan nguibamɨn iti. Ezɨ an otarim arɨa, Kaperneamɨn nguibamɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ezɨ gumazir kam akam kamaghɨn a baraki, Iesus Judian Distrigh ategha Galilin Distrighɨn ize. Ezɨma a Iesus bagha ghua agakaghora ghaze, “Nɨ Kaperneamɨn nguibamɨn magɨrɨ, egh nan otarim damightɨ, a ua deraka. Nan otarim bar ovengasava ami.” ");
INSERT INTO msy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ezɨ Iesus kamaghɨn a mɨgei, “Ia mirakelba ko dɨgavir kuram gamir arazibar ganan koghɨva, ia nɨghnɨzir gavgavim nan ikian kogham.” ");
INSERT INTO msy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ezɨ ingangarir gumazir kam kamaghɨn a mɨgei, “Gumazir Ekiam, nɨ zuamɨra izighirɨ. puvatɨghtɨma, nan otarim aremegham.” ");
INSERT INTO msy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ezɨ Iesus a mɨgei, “Nɨ mangɨ, nɨn otarim angamra ikiam.” Ezɨ gumazir kam nɨghnɨzir gavgavim Iesusɨn akamɨn ikiava, egha a ghu. ");
INSERT INTO msy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Egha gumazir kam tuavimɨn ghuavɨra itima, an ingangarir gumaziba iza tuavimɨn a bato, egha me kamaghɨn a mɨgei, “Nɨn otarim an angamra iti!” ");
INSERT INTO msy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ezɨ a men azara, dughiar manamra borim mong dera. Ezɨ me ghaze, “Boghɨnaron 1 kloghɨn aruer arɨzimɨn, an arɨmariam gɨvazɨ mɨkarzim orangi.” ");
INSERT INTO msy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ezɨ afeziam fo, boghɨnaron dughiar kamra Iesus a mɨkeme, “Nɨn otarim an angamra ikiam.” Kamaghɨn amizɨ, a nɨghnɨzir gavgavim Iesusɨn itima, an adarazi uaghan nɨghnɨzir gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Kar dughiar namba 2, Iesus Judian Distrigh ategha ua iza Galilin Distrighɨn ikiava mirakelɨn mam uam a gami. ");
INSERT INTO msy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Dughiar maba gɨvazɨ, Judabar isar ekiam otozɨma, ezɨ Iesus isam bagha Jerusalemɨn nguibar ekiamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ezɨ Jerusalemɨn mozir dɨpar ekiar mam iti, ezɨ Hibrun akam me Betesda, a garɨsi. A Sipsipba Aven Zuir Tiar Akar Ekiamɨn boroghɨra iti. Ezɨ mozir dɨpar kamɨn mɨriam azuarir 5 pla iti. ");
INSERT INTO msy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ezɨ azuarir kaba arɨmariar gumazamizir avɨrim dar iti, damazir okavɨrɨziba ko suer kuraba, ko soroghafariba amɨraziba. ");
INSERT INTO msy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gumazir mam an azuarir mamɨn iti, an suemning bar amɨrazɨma a 38 plan azenibar arɨmariar kam an iti. ");
INSERT INTO msy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ezɨ Iesus gumazir kamɨn garima a irɨghav iti, ezɨ a fo, a fomɨram arɨa iti. Ezɨ Iesus an azara, “Nɨ ua deraghasa nɨ ifonge?” ");
INSERT INTO msy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ezɨ arɨmariar gumazim kamaghɨn Iesusɨn akam ikara, “Gumazir ekiam, kɨ akurvazir gumaziba puvatɨ. Dɨpam sɨrvamadir dughiam, gumazitam na inigha ghua mozir dɨpamɨn averiam gatɨzir puvatɨ. Kɨ uabɨ mangasa ifonge, ezɨ gumazir igharaziba faragha ghuaghira egha na gafisi.” ");
INSERT INTO msy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ezɨ Iesus kamaghɨn a mɨgei, “Nɨ dɨkavighɨva uan daguivsiaba inigh, daru mangɨ.” ");
INSERT INTO msy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ezɨ gumazir kamɨn suemning zuamɨra ua dera. Ezɨ a uan daguivsiaba inigha egha zui. Ezɨ dughiar kam a Sabatɨn dughiam, ");
INSERT INTO msy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ezɨ Judaba me gumazir kamɨn ganigha egha kamaghɨn a mɨgei, “Datɨrɨghɨn Sabatɨn dughiam. Moses Osirizir Araziba, da ghaze, nɨ Sabatɨn dughiamɨn uan daguivsiaba ater daruan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ezɨ a kamaghɨn men akam ikara, “Gumazir na gamizɨma kɨ derazim, a kamaghɨn na mɨgei, ‘Nɨ dɨkavighɨva uan daguivsiaba inigh, daru mangɨ.’” ");
INSERT INTO msy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ezɨ me an azara, “Gumazir manamra, nɨ mɨgɨa ghaze, ‘Nɨ dɨkavighɨva uan daguivsiaba inigh, daru mangɨ.’” ");
INSERT INTO msy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ezɨ gumazir ua derazir kam a fozir puvatɨ, tinara a mɨkeme. Dughiar kam gumazamizir avɨrim nguibar kamɨn iti, ezɨ Iesus men tongɨn suiaghrɨgha ghu. Kamaghɨn amizɨma, gumazir kam fozir puvatɨ, tina an akura. ");
INSERT INTO msy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ezɨ gɨn Iesus Godɨn dɨpenimɨn mɨriamɨn aven ghua an garima a iti. Ezɨ Iesus a mɨgei, “Nɨ oragh. Nɨ datɨrɨghɨn ua dera. Nɨ uam arazir kuratam damuan markɨ. Nɨ oraghan koghtɨ, osɨmtɨzir bar ekiatam nɨ batogham.” ");
INSERT INTO msy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ezɨ gumazir kam ghua kamaghɨn Judabav gei, “Gumazir na gamizɨ kɨ derazim, a Iesusra.” ");
INSERT INTO msy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iesus Sabatɨn dughiamɨn bizir kabagh ami, bizir kamɨn Judaba osɨmtɨziba Iesus garɨgha ghaze, an en apanim. ");
INSERT INTO msy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ezɨ Iesus kamaghɨn men akam ikara, “Nan Afeziam a zurara ingara iza datɨrɨkɨn. Ezɨ kɨ uaghan kɨ ingari.” ");
INSERT INTO msy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ezɨ Judaba me akar kam baregha me fo, Iesus Sabatɨn dughiamɨn Arazimɨn gɨn zuir puvatɨ, egha a uaghan ghaze, God guizbangɨra nan Afeziamra. Akar kamɨn, a uabɨ uabɨ gamigha egha Godɨn mɨn oto. Kamaghɨn amizɨ, Judaba Iesus mɨsueghtɨ an aremeghasa me bar ifonge. ");
INSERT INTO msy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ezɨ Iesus Judabar akam ikara, “Kɨ guizbangɨra ia mɨgei, Otarim bizitam a uan nɨghnɨzimɨn a damighan kogham. Puvatɨ. An Afeziamɨn gari, an amir biziba darara a dagh ami. Egha bizir Afeziam amiba, Otarim uaghan dagh ami. ");
INSERT INTO msy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afeziam bar Otarim gifonge, egha bizir a uabɨ amiba, a bar ada isa uan Otarimɨn aka. Afeziam kamagh sua, a ia damutɨ ia dɨgavir kuram damuam, kamaghɨn a ingangarir ekiar igharaziba sara uaghan uan Otarimɨn akagham, da ingangarir an amigha gɨvazibagh afiragham. ");
INSERT INTO msy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afeziam gumazir ariaghrezibagh amima me ua dɨkavima an angamra itir ikɨrɨmɨrim me ganɨdi. Ezɨ kamaghɨra Otarim uaghan gumazir a mɨseveziba angamra itir ikɨrɨmɨrim me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Afeziam kotɨn gumazitamɨn araziba tuisɨzir puvatɨ. Egha gumazibar araziba tuisɨghamin ingangarim, an a isa Otarim ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Afeziam kamagh sua, gumaziba bar Afeziamɨn ziam fe moghɨn, me Otarimɨn ziam fam, kamaghɨn a gumaziba tuisɨghamin ingangarim isa Otarim ganɨngi. Gumazim Otarimɨn ziam fer puvatɨ, an Afeziar Otarim amadazimɨn ziam fer puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Kɨ guizbangɨra ia mɨgei, gumazim nan akam baragha, egha nɨghnɨzir gavgavim Afeziar na amadazimɨn ikiava, egha a zurara itir ikɨrɨmɨrir aghuarim iti. A kotiaba puvatɨ. An ovevem ategha, egha datɨrɨghɨn an angamra iti. ");
INSERT INTO msy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Kɨ guizbangɨra ia mɨgei, dughiar otivamim, a datɨrɨghɨn otogha gɨfa. Ezɨ gumazir ariaghreziba me Godɨn Otarimɨn akam baragham. Gumazamizir a baraghiziba, me angamra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afeziam, a uabɨ ikɨrɨmɨrir zurara itim anɨngamin gavgavim iti. Kamaghɨra a uan Otarim gamizɨ, a uaghan ikɨrɨmɨrir zurara itim anɨngamin gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A Gumazibar Otarim, kamaghɨn amizɨma Afeziam gumazibar araziba tuisɨghamin gavgavim a ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ia nan akar kam inigh egh dɨgavir kuram damuan markɨ. Dughiam otivasava amima gumazir ariaghreziba, me bar Otarimɨn akam baragham. ");
INSERT INTO msy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Egh me bar moziba ategh azenimɨn izam. Gumazamizir arazir aghuibagh amiziba, me ua dɨkavighɨva egh zurara angamra ikiam. Eghtɨ gumazamizir arazir kurabagh amiziba, me ua dɨkavighɨva kotiamɨn ikiam, eghtɨ kɨ kamaghɨn me mɨkɨmam, me bar helɨn mangɨva ivezir kuram iniam.” ");
INSERT INTO msy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Egha Iesus kamaghɨn mɨgei, “Kɨ uabɨ uan nɨghnɨzimɨn gɨn mangɨ bizitam damighan kogham. Kɨ akar Afeziam da inizimɨn gɨn ghua, egha gumazamizibar araziba tuisɨsi. Kɨ uabɨ uan ifongiamɨn gɨn zuir puvatɨ. Kɨ Afeziamɨn ifongiamɨn gɨn zui, anemadazɨma kɨ ize. Kamaghɨn amizɨ, kɨ gumazamizibar araziba deravɨra da tuisɨsi, ezɨ nan kotiam a bar guizbangɨra ghua egha bar dera. ");
INSERT INTO msy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Eghtɨ kɨ uabɨ ua bagh uan ingangariba ko arazibar gun mɨkɨmtɨma eghtɨ gumaziba nɨghnɨzir gavgavim kɨ gun mɨgeir akar kamɨn ikian markɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ezɨ igharazitav a iti, egha a uaghan nan araziba ko nan ingangaribar gun mɨgei. Ezɨ kɨ fo, a kon gun mɨgeir akam guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Iarara fomɨra gumazir maba amangizɨ me Jon bagha ghuezɨ a nan gun mɨkeme, ezɨ an akam guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kɨ uabɨ, kɨ gumazitamɨn akam nan akam gavgavim a danɨngasa nɨghnɨzir puvatɨ. Egha kɨ God ian akurvaghasa, kɨ ifonge. Kamaghɨn amizɨ, kɨ Jonɨn akamɨn gun ia mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon a lamɨn mɨn ikia isia angazangarim gumazamizibagh anɨdi. Ezɨ dughiar otevimɨn ia an akam iniasa ifongezɨ ezɨ Jonɨn angazangarim ia gisiragha ia gamima ia bar akonge. ");
INSERT INTO msy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ezɨ nan gun mɨgeir akar mam iti, a Jonɨn akam gafira, akar kam datɨrɨghɨn a nan gun ia mɨgei. Afeziam, kɨ ingangarir kam damuva egh anegɨvasa, na ganɨngi. Ezɨ ingangarir kɨ amir kaba, da bar deraghavɨra nan gun gumazamizibav mɨgei, Afeziam na amadazɨ kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ezɨ Afeziar na amadazɨ kɨ izezim, a uabɨ nan gun mɨgei. Ezɨ ia tong an akam barazir puvatɨ. Egha ia dughiatam an guamɨn ganizir puvatɨ. Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ia Afeziam amadazir gumazir kamɨn akam nɨghnɨzir gavgavim an itir puvatɨ. Ian arazir kaba ian gun mɨgei, Afeziamɨn akam uaghan ian navir averiabar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ia ghaze, akar Godɨn Akɨnafarimɨn itim, a zurara itir ikɨrɨmɨrir aghuarim ia ganɨdi. Kamaghɨn amizɨma ia akar Godɨn Akɨnafarimɨn itibar gara da tuisɨsi. Ezɨ Godɨn Akɨnafarim uaghan nan gun mɨgei! ");
INSERT INTO msy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ezɨ ia na bagh izɨ zurara itir ikɨrɨmɨrir aghuarim inian aghua. ");
INSERT INTO msy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kɨ gumaziba da ziar ekiam iniasa, egha mɨgɨrɨgɨar kabagh amir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ezɨ kɨ ia gɨfo. Ian navir averiabar, ia guizbangɨra God gifongezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kɨ uan Afeziamɨn ziamɨn ize, ezɨ ia nan akam baraghan aghua. Eghtɨ gumazitam uabɨ uan ziamɨn izeghtɨ, ia an akam zuamɨram a baregham. ");
INSERT INTO msy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ia uan adarazira me da ziar ekiaba isi. Ezɨ God uabɨra ziar ekiam anɨdima, ia a inian aghua. Egh ia arazir kabar amuva, egh ia manmaghɨn nɨghnɨzir gavgavim nan ikiam? Bar puvatɨgham! ");
INSERT INTO msy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ia kamaghɨn nɨghnɨghan markɨ, kɨ Afeziamɨn damazimɨn akam ia gasam. Puvatɨ. Gumazir akam ia gasamim, a Moses uabɨ, a gumazir kam ia ghaze, a ian akuragham. ");
INSERT INTO msy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ezɨ akar Moses osiriziba, da nan gun mɨgei. Kamaghɨn, ia Mosesɨn akam nɨghnɨzir gavgavim an ikɨva, egh uaghan nɨghnɨzir gavgavim nan akamɨn ikiam. Kamaghɨn amizɨ, ia guizbangɨra nɨghnɨzir gavgavim Mosesɨn akam ko nan akamɨn itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ezɨ kamaghɨn ia nɨghnɨzir gavgavim Moses osirizir akabar itir puvatɨ, egh ia manmaghɨn nɨghnɨzir gavgavim na akamɨn ikiam?” ");
INSERT INTO msy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ezɨ bizir kabar gɨn Iesus Galilin Dɨpamɨn dadarir vuemɨn ghu, dɨpamɨn ziar mam Taiberias. ");
INSERT INTO msy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gumazamizir avɨrim faraghavɨra an garima a mirakelɨn arazarazibar arɨmariar gumazibagh amima me ua dera. Kamaghɨn amizɨma me datɨrɨghɨn an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ezɨ Iesus mɨghsɨamɨn ghuavanabogha, egha uan suren gumaziba ko aperaghav iti. ");
INSERT INTO msy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ezɨ dughiar kamɨn Israelbagh Itazir Dughiamɨn Isam otivasa roghɨra izi. ");
INSERT INTO msy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ezɨ Iesus garagharua egha garima gumazamizir avɨrir ekiam a bagha izi. Ezɨ a kamaghɨn Filipɨn azara, “E managh gumazamizir kaba bagh daghebagh ivezegh me danɨngam?” ");
INSERT INTO msy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ezɨ Iesus Filipɨn nɨghnɨzir gavgavim, gavgavim a danɨngasava, akar kam puram a gami. Iesus uabɨ bizir a damuamim gɨfo.) ");
INSERT INTO msy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ezɨ Filip a ikara, “E 200 kina inigh bret givezeghtɨ, da bar gumazamizibar tughatɨghan kogham, me vaghvagh bretɨn akuar muziariba ini dar amam.” ");
INSERT INTO msy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ezɨ Iesusɨn suren gumazibar mav, an ziam Andru, a Saimon Pitan aveghbuam, a kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Otarir mam a kagh iti, a bretɨn me balin daghemɨn ingarizir 5 pla, ko osirir pumuning iti. Ezɨ gumazamizir avɨrir ekiam iti. Kamaghɨn bretɨn ko osirir kamning, da manmaghɨn en akuragham?” ");
INSERT INTO msy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ezɨ Iesus kamaghɨn mɨgei, “Ia gumazamizibav mɨkɨmtɨma me dapiagh.” (Grazir avɨrim danganir kamɨn iti.) Ezɨ gumazamiziba apia. Egha men tongɨn, 5000ɨn gumaziba iti. ");
INSERT INTO msy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Me apiaghav itima, ezɨ Iesus bretɨn kam inigha God mɨnabagha egha gumazamizibagh anɨdi. A uaghan osirir pumuning kamaghɨra aning gami. A me ganɨdi, ezɨ me uan ifongiamɨn amegha tughatɨ. ");
INSERT INTO msy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Me amegha naviba bar izɨvazɨma Iesus kamaghɨn uan suren gumazibav gei, “Ia dagher nar ikiavɨra itiba bar da akumakumigh. Taba pura ikian markɨ.” ");
INSERT INTO msy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gumaziba, 5 plan bretɨn me balin daghem ingariziba, me da amegha gɨvazɨma bretɨn naba iti. Ezɨ suren gumaziba bretɨn nar muziarir itiba akumakumigha egha 12 plan akɨrabagh aghuizɨ da izɨfa. ");
INSERT INTO msy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ezɨ gumazamiziba mirakelɨn arazarazir Iesus amizir kamɨn ganigha, kamaghɨn mɨgei, “Bar guizbangɨra kar Godɨn akam inigha izir gumazim, God nguazir kamɨn anemangasa mɨkeme!” ");
INSERT INTO msy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ezɨ Iesus akar kam baregha egha a fo, me izɨva an suiraghɨva, egh a damightɨ a men atrivimɨn ikiam. Kamaghɨn amizɨma a danganir kam ategha egha uabɨra uamategha mɨghsɨamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ezɨ guaratɨzir kamɨn Iesusɨn suren gumaziba dɨpamɨn ghuaghiri. ");
INSERT INTO msy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Egha me botɨn mam inigha egha dɨpam abigha Kaperneamɨn nguibam bagha zui. Iesus tɨghar me bativam, ezɨ amɨnim pɨrigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ezɨ amɨnir dafam oto, egha ongarim givaima an ekiabar dɨkafi ");
INSERT INTO msy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ezɨ me 5 o 6 plan kilomitan ghua pul gamua ghuava, egha me garima Iesus dɨpam gisɨn arua ghuava botɨn boroghɨra zui. Ezɨ me bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ezɨ Iesus kamaghɨn me mɨgei “Kar kɨrara izi. Ia atiatingan markɨ.” ");
INSERT INTO msy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ezɨ me a inigh botɨn aven izasa bar ifonge, ezɨ bot zuamɨra danganim me zuimɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Amɨmɨzarakan, gumazamizir dɨpamɨn vongɨn ikiavɨra ikeziba, me fo, botɨn vamɨra boghɨnaron ike, egha Iesus uan suren gumaziba ko botɨn kamɨn ghuzir puvatɨ. Suren gumazibara botɨn kamɨn ghue. ");
INSERT INTO msy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ezɨ Taiberiasɨn nguibamɨn botɨn maba, da danganir kam boroghɨra izi, danganir Ekiam Godɨn mɨnabagha egha bret gumazir avɨribagh anɨngizɨ me amezim. ");
INSERT INTO msy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ezɨ gumazamiziba me kamaghɨn ganigha fo, Iesus itir puvatɨzɨma, an suren gumaziba uaghan itir puvatɨ. Kamaghɨn amizɨ, me botɨn kabar ghuavanega, egha Iesus buriasa Kaperneamɨn nguibamɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ezɨ gumazamiziba dɨpamɨn vongɨn Iesus batogha gɨfa, egha me kamaghɨn a mɨgei, “Tisa, nɨ manadɨzoghɨn kagh ize?” ");
INSERT INTO msy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ezɨ Iesus kamaghɨn akam ikara, “Bar guizbangɨra kɨ ia mɨgei, ia mirakelɨn arazarazir ia ganiziba dagh nɨghnɨgha iza na buri, o? Puvatɨ. Kɨ ghaze, ia dagher kɨ ia ganɨngizir kam amegha egha ian naviba bar izefe, ezɨ bizir kam bagha ia na buri. ");
INSERT INTO msy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ia dagher kuraghriba bagh ingar da inian markɨ. Ia dagher zurara ikia mamaghɨra itim bagh ingarɨva a inigh, kar dagher zurara itir ikɨrɨmɨrir aghuarim anɨdim. Afeziam God kamaghɨn ian aka, Gumazibar Otarim, a uabɨn torogha gavgavim a ganɨngi. Kamaghɨn amizɨ, dagher kam, Gumazibar Otarim a ia danɨngam.” ");
INSERT INTO msy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ezɨ me an azara, “E manmaghɨn damighɨva egh e Godɨn ingangarim damuam?” ");
INSERT INTO msy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ezɨ Iesus kamaghɨn men akam ikara, “Godɨn ingangarim kamakɨn. Ia gumazir God amadazir kam, ia nɨghnɨzir gavgavim an ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ezɨ me an azara, “Nɨ mirakelɨn arazarazir manam damightɨ e ganighɨva egh nɨghnɨzir gavgavim nɨn ikiam? Nɨ tizim damigham? ");
INSERT INTO msy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","En ovaviba dagher mam an ziam mana, me gumaziba itir puvatɨzir danganimɨn ikia aneme. Godɨn Akɨnafarimɨn itir akam mɨkemezɨ moghɨn, ‘A Godɨn Nguibamɨn daghem me ganɨngizɨma me aneme.’” ");
INSERT INTO msy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ezɨ Iesus me mɨgei, “Kɨ guizbangɨra ia mɨgei, ka Moses Godɨn Nguibamɨn daghem ia ganɨngizir pu. Puvatɨ. Ka nan Afeziam a guizbangɨn Uan Nguibamɨn daghem ia ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Dagher God e ganɨngizir kam, a Godɨn Nguibam ategha izaghirɨ, a nguazir kamɨn itir gumazamiziba gamima me ikɨrɨmɨrir aghuarim iti.” ");
INSERT INTO msy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ezɨ me an azara, “Ekiam, nɨ dagher kam zurara e danɨngvɨra ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ezɨ Iesus kamaghɨn me mɨgei, “Kɨ uabɨ, dagher ikɨrɨmɨrir zurara itim anɨdim. Gumazir na bagha izim, a ua mɨtiriam an aghan kogham. Ezɨ gumazir nɨghnɨzir gavgavim nan itim, a dɨpam ramɨsɨ kuarim uam an pɨran kogham. ");
INSERT INTO msy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kɨ ia mɨkeme, ia nan ganigha gɨfa, egha ia nɨghnɨzir gavgavim itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ezɨ gumazamizir Afeziam na ganɨngiziba, me bar na bagh izam. Egh gumazir na bagh izamim, kɨ a batueghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kɨ uan ifongiamɨn gɨn mangasa Godɨn Nguibam ategha izaghirɨzir puvatɨ. Kɨ Afeziar na amadazimɨn ifongiamɨn gɨn mangasa kɨ izaghirɨ. ");
INSERT INTO msy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ezɨ Afeziar na amadazimɨn ifongiam, a kamakɨn, kɨ gumazamizir a na ganɨngizitam ateghan kogham. Puvatɨ. Kɨ Godɨn Kotɨn Dughiamɨn me damightɨ me bar ua dɨkavigham. ");
INSERT INTO msy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nan Afeziamɨn ifongiam kamakɨn, gumaziba bar Otarimɨn ganighɨva egh nɨghnɨzir gavgavim an ikɨva, me zurara itir ikɨrɨmɨrir aghuarim iniam. Eghtɨ Godɨn Kotɨn Dughiam otoghtɨ kɨ me damightɨ me ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ezɨ Judaba akar kam baraki, “Kɨ uabɨ kɨ dagher kam, Godɨn Nguibam ategha egha izaghirɨ,” egha me atarava egha uarigh imobi. ");
INSERT INTO msy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Me ghaze, “Gumazir kam a Iesus, Josepɨn otarim. E an afeziam ko amebam gɨfo. Ezɨ manmagh sua a ghaze, ‘Kɨ Godɨn Nguibam ategha, egha kɨ zaghirɨ?’” ");
INSERT INTO msy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ezɨ Iesus kamaghɨn men akam ikara, “Ia atara egha uarigh imobir arazir kam atakigh. ");
INSERT INTO msy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gumazitam uabɨ uan ifongiamɨn na bagh izeghan kogham. Puvatɨ. Afeziar na amadazim, an nɨghnɨzim feghɨva egh a inigh na bagh izam. Eghtɨ Godɨn Kotɨn Dughiam kɨ mozimɨn a damightɨ a ua dɨkavighɨva angamra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Akar kam kamaghɨn Godɨn akam inigha izir gumazibar Akɨnafarimɨn iti, ‘God bar gumazamizibar sure damuam.’ Ezɨ kamaghɨn gumazamiziba Afeziamɨn akam baregha egha Afeziam da fofozim isa, me na bagha izi. ");
INSERT INTO msy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Gumazitam Afeziamɨn ganizir puvatɨ. Gumazir Afeziam ko ikegha izezir kam, a uabɨra Afeziamɨn gani. ");
INSERT INTO msy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kɨ guizbangɨra ia mɨgei, gumazir nɨghnɨzir gavgavim nan itim, a zurara itir ikɨrɨmɨrir aghuarim iti. ");
INSERT INTO msy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kɨ uabɨ, kɨ dagher ikɨrɨmɨrir zurara itim anɨdim. ");
INSERT INTO msy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ian ovavir kaba me, dagher ziam mana, me gumaziba itir puvatɨzir danganimɨn ikia aneme, egha ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ezɨ dagher kam Godɨn Nguibam ategha izaghirɨ, gumazamiziba anemɨva, egh me aremeghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kɨ uabɨ dagher kam, ikɨrɨmɨrir zurara itim anɨdim, Godɨn Nguibam ategha egha zaghirɨ. Eghtɨ gumazitam dagher kamra ameghɨva, a zurara itir ikɨrɨmɨrir aghuarim iniam. Dagher kɨ a danɨngamim, a nan nivafɨzim. Kɨ kamagh sua, nguazimɨn gumazamiziba me angamra ikiam, kamaghɨn kɨ me bagh uan nivafɨzim anenigham.” ");
INSERT INTO msy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ezɨ Judaba akar kam baregha egha me uari tongɨn uarir atara ghaze, “Gumazir kam manmaghɨn uan nivafɨzim e danightɨ e anemam?” ");
INSERT INTO msy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ezɨ Iesus kamaghɨn me mɨgei, “Bar guizbangɨra kɨ ia mɨgei, ia Gumazibar Otarimɨn nivafɨzim rameghan koghɨva, egh an ghuzim rameghan koghɨva, egh ia angamra itir ikɨrɨmɨrim ian ikian kogham. ");
INSERT INTO msy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","55","Nan nivafɨzim a guizɨn daghem, ezɨ nan ghuzim a guizɨn apir bizim. Kamaghɨn ami, gumazim nan nivafɨzim apava egha nan ghuzim api, a zurara itir ikɨrɨmɨrir aghuarim iti. Eghtɨ Godɨn Kotɨn Dughiamɨn kɨ a damightɨ a ua mozimɨn dɨkavigham. ");
INSERT INTO msy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ezɨ gumazim nan nivafɨzim apava egha nan ghuzim api, a nan poroghav iti, ezɨ kɨ an poroghav iti. ");
INSERT INTO msy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Afeziar ikɨrɨmɨrir angamra itim anɨdim, a na amadazɨma kɨ ize, ezɨ kɨ Afeziamɨn gavgavimɨn angamra iti. Ezɨ kamaghɨra gumazim nan nivafɨzim api, a nan gavgavimɨn ikɨrɨmɨrir angamra itim iniam. ");
INSERT INTO msy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Dagher kamra, a Godɨn Nguibam ategha izaghirɨ. Egha dagher kam, a dagher ian ovaviba fomɨram anemegha gɨn ariaghrezimɨn mɨn garir pu. Puvatɨ. Gumazir dagher kam apim, a zurara itir ikɨrɨmɨrir aghuarim iniam.” ");
INSERT INTO msy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iesus Kaperneamɨn nguibamɨn itir God ko mɨgeir dɨpenimɨn aven ikia, egha a gumazamizibar sure gamua akar kam me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ezɨ suren gumaziba Iesusɨn akar kam baregha, egha men avɨrim kamaghɨn mɨgɨa ghaze, “Akar kam e gamima e nɨghnɨzir avɨribagh ami. Tina akar kam baragham?” ");
INSERT INTO msy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ezɨ Iesus uan navir averiamɨn aven kamaghɨn fo, an suren gumaziba puvɨra akar a mɨkemezim mɨgɨa imobi. Ezɨ a men azara, “Akar kam ti ian nɨghnɨzir gavgaviba gasɨghasɨsi, o? ");
INSERT INTO msy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Egh ia Gumazibar Otarimɨn ganightɨ, a nguibar a fomɨra ikezimɨn ua ghuavanaboghtɨ, eghtɨ ia manmaghɨn nɨghnɨgham? ");
INSERT INTO msy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godɨn Duam uabɨ, angamra itir ikɨrɨmɨrim gumazamizibagh anɨdi. Gumazimɨn gavgavim tong ian akuraghan kogham. Akar kɨ ia mɨkemezir kaba, da Godɨn Duamɨn bizim, da angamra itir ikɨrɨmɨrim ia ganɨdi. ");
INSERT INTO msy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ezɨ gumazir ian tongɨn itir maba, me nɨghnɨzir gavgaviba nan itir puvatɨ.” (Iesus fomɨra iza datɨrɨghɨn, a nɨghnɨzir gavgavim itir puvatɨzir gumazibagh fo. Egha a gumazir a isɨ apanibar dafarim darɨghamin kam gɨfo.) ");
INSERT INTO msy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Egha Iesus ua me mɨgei, “Me nɨghnɨzir gavgavim nan itir puvatɨ, ezɨ bizir kam bagha, kɨ ia mɨkeme, ‘Afeziam gavgavim gumazitam danigan koghtɨ, kamaghɨn gumazir kam na bagh izeghan kogham.’” ");
INSERT INTO msy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iesus akar kamɨn gun mɨkemegha gɨvazɨma, an suren gumazir avɨrim anetegha ua ghue, egha uam a ko aruir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ezɨ Iesus kamaghɨn 12 plan suren gumazibar azara, “Ezɨ ia? Ia ti uaghan na ategh mangasa?” ");
INSERT INTO msy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ezɨ Saimon Pita an akam ikara, “Ekiam, e tina bagh mangam? Nɨn akabara, da zurara itir ikɨrɨmɨrir aghuarim anɨdi. ");
INSERT INTO msy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ezɨ e nɨghnɨzir gavgavim ikiava, egha deravɨra kamaghɨn fo, nɨ gumazir Godɨn damazimɨn bar zuegha arazir kuram nɨn puvatɨzim, God ua bagha nɨ ginaba.” ");
INSERT INTO msy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ezɨ Iesus kamaghɨn men akam ikara, “Manmaghɨn ami? Kɨ uabɨ ia 12 plan suren gumaziba mɨsefe. Ezɨ ian tongɨn itir mav, a duar kuram.” ");
INSERT INTO msy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","A Judasɨn mɨgei, a Saimon Iskariotɨn otarim, a 12 plan suren gumazibar mav. Iesus fo, Judas gɨn a isɨ apanibar dafarim datɨghtɨ me a mɨsueghtɨ, an aremegham. ");
INSERT INTO msy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dughiar maba gɨvazɨma, Iesus Galilin Distrighɨn aven arui. A fo, Judaba a mɨsueghtɨma an aremeghasa egha a bagha mɨzuai. Kamaghɨn amizɨma, a ua Judian Distrighɨn mangan aghua. ");
INSERT INTO msy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ezɨ Judabar Averpenibar Isar Ekiamɨn Dughiam otivasa roghɨra izi. ");
INSERT INTO msy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ezɨ an doziba kamaghɨn a mɨgɨa ghaze, “Nɨ danganir kam ateghɨva egh Judian Distrighɨn mangɨ. Eghtɨ nɨn suren gumaziba ingangarir nɨ amibar ganam. ");
INSERT INTO msy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Egh gumazitam gumazamiziba bar a gɨfoghsɨ, a modogh ingangarim damuan kogham. Egh nɨ bizir kabar amuava, kamaghɨn nɨ uabɨ isɨ gumaziba bar men akagham.” ");
INSERT INTO msy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(An doziba uaghan nɨghnɨzir gavgavim an itir puvatɨ, egha akar kam mɨkeme.) ");
INSERT INTO msy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ezɨ Iesus kamaghɨn men akam ikara, “Nan dughiam a tɨghar izam. Ezɨ dughiaba bar, ian dughiar aghuiba. ");
INSERT INTO msy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ezɨ nguazir kamɨn itir gumazamiziba me ian apanim damuan kogham. Ezɨ kɨ men arazir kurar me amibar gun mɨgei. Kamaghɨn amizɨ, me nan apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ia uarira isamɨn dughiar kam bagh Jerusalemɨn mangɨ. Eghtɨ kɨ, nan dughiam tɨghar izam, kamaghɨn, kɨ isamɨn dughiamɨn mangɨghan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","A kamaghɨn me mɨkemegha, egha a Galilin Distrighɨn ikiavɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ezɨ an doziba ghuegha gɨvazɨma, Iesus uaghan gɨn zui. An azenara zuir puvatɨ, a mogomebar zui, ezɨ gumazamiziba a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ezɨ isar ekiamɨn dughiamɨn, Judabar gumazir ekiaba a bagha garagharui, egha mɨgei, “Gumazir kam managh iti?” ");
INSERT INTO msy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ezɨ gumazamiziba uarir tongɨn a bagha sighsirakaba uariv gei. Marazi ghaze, “A gumazir bar aghuim.” Ezɨ marazi ghaze, “Puvatɨ, a gumazamizibagh ifari.” ");
INSERT INTO msy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Egha me Judabar gumazir ekiabar atiati. Kamaghɨn amizɨ tav an araziba azenara dav geir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ezɨ isamɨn dughiar kamɨn tongɨn, Iesus Godɨn dɨpenimɨn mɨriamɨn aven ghugha egha gumazamizibar sure gami. ");
INSERT INTO msy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judaba an akar kam barasi, egha me nɨghnɨzir avɨribagh amua egha mɨgei, “Manmagh amizɨ gumazir kam fofozir kaba iti? A suren ghuzir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ezɨ Iesus kamaghɨn men akam ikara, “Kɨ ia ganɨngizir akar kam, kar nan akam puvatɨ, kar Godɨn akam, a na amadazɨma kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ezɨ gumazitam Godɨn akam bar an gɨn mangasa ifonge, an akar kɨ mɨkemezir kamɨn mɨngarim bar a gɨfogham. Egh a fogham, akar kam Godɨn ize, o a pura nan nɨghnɨzimɨn ize. ");
INSERT INTO msy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gumazir pura uan nɨghnɨzimɨn mɨgeim, a uabɨ uan ziam fasa ifonge. Ezɨ gumazim a gumazir anemadazimɨn ziam fasa ifonge, gumazir kam a guizɨn akabara mɨgei, egha a bizitam gifarir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Fomɨra Moses Godɨn Araziba osirigha ia ganɨngi. Egha gumazitam ian tongɨn ikia Moses Osirizir Arazibar gɨn zuir puvatɨ. Ia tizim bagh na mɨsueghtɨ kɨ aremegham?” ");
INSERT INTO msy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ezɨ gumazamiziba an akam kamaghɨn a ikara, “Ti duar kuratam nɨ gapasa! Gumazir manamra nɨ mɨsueghtɨ na aremegham?” ");
INSERT INTO msy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ezɨ Iesus kamaghɨn men akam ikara, “Kɨ mirakelɨn ingangarir vamɨra a gami, ezɨ ia bar nɨghnɨzir avɨribagh ami. ");
INSERT INTO msy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ezɨ ia nɨghnɨgh, Moses mɨkarzir mogomem aghorir arazim ia ganɨngi, ezɨ ia Sabatɨn dughiabar uaghan otaribar mɨkarzir mogomebar ghori. (Guizbangɨra, Moses uabɨ arazir kam atɨzir puvatɨ. Arazir kam ian ovavibar oto.) ");
INSERT INTO msy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ia Moses Osirizir Araziba deragh a dar gɨn mangɨsɨ, egh ia Sabatɨn dughiamɨn otaribar mɨkarzibar ghoram. Ezɨ kɨ gumazir mam Sabatɨn dughiamɨn a gamizɨma a ua bar dera, ezɨ manmagh sua ia nan anɨngaghe? ");
INSERT INTO msy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ia pura damazir kɨnibar bizibar ganɨva, da tuisɨghan markɨ. Ia guizɨn arazimɨn araziba deravɨra da tuisɨgh.” ");
INSERT INTO msy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ezɨ Jerusalemɨn gumazamizir maba Iesus amizir bizibar ganigha egha mɨgei, “Manmaghɨn ami? Kar gumazir kamra, en gumazir ekiaba a mɨsueghtɨma an aremeghasa, me ifonge. ");
INSERT INTO msy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A kara, an azenara mɨgei, ezɨ me mɨgɨrɨgɨatam a gamir puvatɨ. Me ti fo, a gumazir kam, God Ua E Iniasa Mɨsevezir Gumazim? ");
INSERT INTO msy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ezɨ e gumazir kamɨn nguibam gɨfo. Eghtɨ God Ua E Iniasa Mɨsevezir Gumazim otoghtɨ, gumazitam an nguibam gɨfoghan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ezɨ Iesus Godɨn Dɨpenimɨn ikia egha akam gumazamizibav kɨri. Egha a kamaghɨn dei, “Ia ghaze, ia ti bar na gɨfo, egha ia nan nguibar kɨ izezim gɨfos, o? Ezɨ, kɨ uabɨ uan ifongiamɨn izezir puvatɨ. Afeziar na amadazim, an akam bar guizbangɨra. Ezɨ ia a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ezɨ kɨ a gɨfo. Kɨ a ko itima, a na amadazɨma ezɨ kɨ ize.” ");
INSERT INTO msy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Me akar kam baregha egha a isɨ kalabus darɨghasa. Ezɨ an dughiam tɨghar, kamaghɨn amizɨ, gumazitam an suirazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ezɨ gumazamizir avɨrim me nɨghnɨzir gavgavim an ikia, egha me mɨgei, “Gumazir God Ua E Iniasa Mɨsevezim otoghɨva, a mirakelɨn avɨribar amutɨ da mirakelɨn gumazir kam amibagh afiragham ti?” ");
INSERT INTO msy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ezɨ Farisiba me gumaziba barazima me sighsirakaba Iesus amizir bizibav gei. Kamaghɨn amizɨ, me ko, Godɨn ofa gamir gumazir ekiaba, me plisɨn gumaziba amadazɨma me Iesusɨn suighasa izi. ");
INSERT INTO msy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ezɨ Iesus mɨgei, “Dughiar bar oveghevezimɨn kɨ ia ko ikiam, egh kɨ uamategh Afeziar na amadazim bagh mangam. ");
INSERT INTO msy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Eghtɨ ia nguibar kɨ ikiamimɨn mangɨghan kogham. Kamaghɨn ia na buriam, egh nan apighan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ezɨ Judaba uarir tongɨn uarira uariv mɨgɨa ghaze, “A managh mangɨtɨ eghtɨ e an ganighan kogham? A ti en gumazamizir kantri Grighɨn itiba bagh mangɨgham, egh Grighɨn gumazamizibar sure damuam, o? ");
INSERT INTO msy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A ghaze, ‘Ia na buriva, egh ia nan apighan kogham.’ Egha ghaze, ‘Ia nguibar kɨ ikiamim ia an mangɨgham kogham.’ Ezɨ akar kamɨn mɨngarim manmakɨn?” ");
INSERT INTO msy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ezɨ isar ekiamɨn dughiar abuananam, a dughiar bar ekiam. Ezɨ dughiar kamɨn Iesus tugha egha pamten diagha kamaghɨn mɨgei, “Gumazitam kuarim an pɨri, a na bagh izɨ egh dɨpam ramam. ");
INSERT INTO msy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Akar Godɨn Akɨnafarimɨn itim kamaghɨn mɨgei, ‘Gumazir nɨghnɨzir gavgavim nan itim, a dɨpar ikɨrɨmɨrir zurara itim anɨdim, an navir averiam gizɨvaghɨva, egh fasfagh iram.’” ");
INSERT INTO msy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iesus Godɨn Duam mɨgei, gumazir nɨghnɨzir gavgavim an itiba, me a iniam. Ezɨ dughiar kamɨn Iesus ziar ekiam tɨghar a iniam, kamakɨn Godɨn Duam tɨghar izam. ");
INSERT INTO msy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ezɨ gumazir maba akar a mɨkemeziba baregha egha me mɨgei, “Bar guizbangɨra, gumazir kam a Godɨn akam inigha izir gumazim, God nguazim anemangasa mɨkeme.” ");
INSERT INTO msy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ezɨ marazi ghaze, “A Gumazir God Uam E Iniasa Mɨsevezim.” Ezɨ marazi ghaze, “Puvatɨ, Gumazir God Uam E Iniasa Mɨsevezir kam, a Galilin otoghan kogham. Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Godɨn Akɨnafarim kamaghɨn mɨkeme, Gumazir God Uam E Iniasa Mɨsevezir kam Atrivim Devitɨn anabamɨn otogham, eghtɨ an amebam Betlehemɨn nguibamɨn a bategham, nguibar kam Atrivim Devit fomɨra an ike.” ");
INSERT INTO msy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kamaghɨn amizɨ, gumazamiziba nɨghnɨzir avɨriba Iesusɨn ikia, egha uarira uari abɨki. ");
INSERT INTO msy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Marazi a isɨ kalabus darɨghasa ifonge, ezɨ gumazitam an suirazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ezɨ Godɨn Dɨpenimɨn garir plisba uamategha Godɨn ofa gamir gumazir ekiaba ko Farisiba bagha ghu. Ezɨ me kamaghɨn me azara, “Manmagh amizɨma ia Iesusɨn akua izir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ezɨ plisɨn gumaziba kamaghɨn me akam ikara, “Gumazitam faragha gumazir kam mɨkemezɨ moghɨn mɨgeir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ezɨ Farisiba kamaghɨn men akam ikara, “A ti uaghan ia gifara? ");
INSERT INTO msy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","E gumazir dapaniba ko Farisiba, ia ti en tongɨn gumazitamɨn garima a nɨghnɨzir gavgavim an iti, o? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nɨghnɨzir gavgavim an itir darasi, ka gumazamizir Moses Osirizir Arazibagh fozir puvatɨziba. God ghaze, me ovengam.” ");
INSERT INTO msy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ezɨ Nikodemus, a gumazir kam faragha Iesus bagha ghu, a Farisin mav, a kamaghɨn me mɨgei, ");
INSERT INTO msy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“En Arazir Moses Osiriziba ti ghaze, e pura gumazitam kotɨn aven a mɨkɨm suam, nɨ aremegham? Puvatɨ. E faragh an akam baregham, egh an amizir bizim deravɨra a gɨfogham.” ");
INSERT INTO msy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ezɨ me kamaghɨn an akam ikara, “Nɨ ti uaghan Galilin gumazitam, o? Nɨ Godɨn Akɨnafarimɨn itir akaba nɨ bar deravɨra dar gan, egh nɨ uaghan kamaghɨn fogham, Godɨn akam inigha izir gumazitam Galilin Distrighɨn otoghan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ezɨ gumazamiziba bar uan ");
INSERT INTO msy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ezɨ Iesus Olivɨn mɨghsɨamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ezɨ amɨnim tirazɨ, ezɨ bar mɨzaraghara a ua Godɨn Dɨpenimɨn mɨriamɨn aven ghu. Ezɨ gumazamiziba bar a bagha izi. Ezɨ an aperaghav ikia men sure gami. ");
INSERT INTO msy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ezɨ Judan arazibagh fozir gumaziba ko Farisiba me pam itir amizir mam, me an garima a gumazir igharazim ko akui, ezɨ me an akua ghua egha a gamima a gumazamizibar damazimɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Egha me kamaghɨn Iesus mɨgei, “Tisa, pam itir amizir kam, a gumazir igharazim ko akuima, me an gani. ");
INSERT INTO msy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ezɨ Moses Osirizir Araziba kamaghɨn mɨgei, e dagɨaba fɨva kamaghɨn amir amizim mɨkɨntɨma an aremegham. Ezɨ nɨ manmaghɨn mɨgei.” ");
INSERT INTO msy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Me ghaze, an akatam mɨkemeghtɨ, me akar kam bagh akam a gasam. Egha me a gifarasa mɨgɨrɨgɨar kam gami. Ezɨ Iesus aviragha uan dafarpuzimɨn nguazim osiri. ");
INSERT INTO msy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ezɨ me an azangsɨghavɨra iti, ezɨ Iesus tugha egha kamaghɨn me mɨgei, “Gumazir manam ian tongɨn arazir kuratam gamizir puvatɨ, a faragh dagɨam amizir kam mɨkɨnigh.” ");
INSERT INTO msy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ezɨ a uam aviragha nguazimɨn osiri. ");
INSERT INTO msy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Me akar kam baregha, egha me bar vaghvagha danganir kam ataghragha zui. Gumazir ghuriba me faragha zui, ezɨ marazi men gɨn zui. Ezɨ Iesus uabɨra aviragha ikia iti, ezɨ amizim an damazimɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ezɨ Iesus tugha egha kamaghɨn amizimɨn azai, “Amizim, gumazir kaba managh ghue? Gumazir akam nɨ gasamiba ti puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ezɨ amizim mɨgei, “Ekiam, ua gumaziba puvatɨ.” Ezɨ Iesus a mɨgei, “Kɨ uaghan akam nɨ gasir puvatɨ. Nɨ mangɨ, egh gɨn uam arazir kuratam damuan markɨ.” ");
INSERT INTO msy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Egha Iesus ua gumazamizibav gɨa ghaze, “Kɨ uabɨ, kɨ gumazir angazangarim nguazir kamɨn itir gumazamizibagh anɨdim. Gumazim nan gɨn izɨ, a mɨtatemɨn daruan kogham. Puvatɨ. An angazangarir gumazamizibagh amima me angamra itim, an an aven ikiam.” ");
INSERT INTO msy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ezɨ Farisiba akar kam baregha egha kamaghɨn Iesus mɨgei, “Nɨ uabɨ uan ingangariba ko arazibar gun mɨgei. Kamaghɨn gumaziba nɨn akar nɨ mɨkemezim nɨghnɨzir gavgavim an ikian kogham. Nɨn akam, a pura bizim.” ");
INSERT INTO msy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ezɨ Iesus men akam kamaghɨn a ikara, “Guizbangɨra, kɨ uabɨ uan arazibar gun mɨgei. Ezɨ kɨ nguibar kɨ dɨkavigha izezim kɨ a gɨfo, egha kɨ danganir kɨ uamategh mangamim, kɨ a gɨfo. Kamaghɨn amizɨ, gumaziba nan akam nɨghnɨzir gavgavim an ikɨ. Ezɨ ia nan nguibam gɨfozir puvatɨ. Egha danganir kɨ gɨn mangamim, uaghan ia a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ia gumaziba nguazir kamɨn arazibar me tuisɨsi. Kɨ gumazitamɨn araziba tuisɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Eghtɨ kɨ gumazitamɨn araziba tuisɨghtɨ, gumaziba nan akar kɨ mɨkemezim nɨghnɨzir gavgavim an ikiam. Kɨ uabɨra a tuisɨzir puvatɨ. Afeziar na amadazim, a na ko ingari, kamaghɨn nan tuisɨzir arazim bar guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ian Arazir Moses Osiriziba, akam kamaghɨn iti, gumazir pumuning akar otevir vamɨra mɨkɨmam, eghtɨ aningɨn akam a guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kɨ uabɨ kɨ uan araziba ko ingangaribar gun mɨgei, ezɨ Afeziar na amadazim, a uaghan nan ingangariba ko arazibar gun mɨgei.” ");
INSERT INTO msy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ezɨ Farisiba kamaghɨn an azara, “Nɨn Afeziar nɨ mɨgeir kam, a managh iti?” Ezɨ Iesus kamaghɨn me ikara, “Ia guizbangɨra na gɨfozir puvatɨ. Egha ia nan Afeziam gɨfozir puvatɨ. Ia na gɨfoghɨva egh uaghan nan Afeziam gɨfogham.” ");
INSERT INTO msy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iesus Godɨn Dɨpenimɨn ikia dagɨaba arɨzir danganimɨn boroghɨra gumazamizibar sure gami. Ezɨ an dughiam tɨgharɨ, kamaghɨn amizɨ gumazitam an suirazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Egha Iesus ua gumazamizibav gɨa ghaze, “Kɨ zui. Ia na buriva nan apighan kogham. Ian arazir kuraba ikɨvɨra ikiam, eghtɨ ia aremegham. Egh ia kɨ mangamin danganim, ia an mangan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ezɨ Judan gumazir aruaba akar kam baregha egha me uarira kamaghɨn uariv gei, “Manmagh sua a ghaze, ‘Ia danganir kɨ zuimɨn mangan kogham?’ A ti uabɨra uabɨ mɨsueghɨva aremegham?” ");
INSERT INTO msy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ezɨ Iesus kamaghɨn me mɨgei, “Ia nguazimɨn vɨn itir darasi. Ezɨ ko, kɨ pɨn iti tav. Ia nguazir kamɨn adarasi. Ezɨ kɨ nguazir kamɨn gumazim puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kamaghɨn ami, kɨ ia mɨkemegha gɨfa, ian arazir kuraba ikɨvɨra ikiam, eghtɨ ia aremegham. Ia kamaghɨn nɨghnɨzir gavgavim nan ikian kogh egh mɨkɨm suam, Kɨ Uabɨ Kɨ Kamaghɨn Iti, eghtɨ ian arazir kuraba ikɨvɨra ikɨtɨ ia arɨmɨghiram.” ");
INSERT INTO msy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ezɨ me an azara, “Nɨ tina?” Ezɨ Iesus me ikara, “Kɨ tina, kɨ faraghavɨra ia mɨkemegha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kɨ ian araziba bagha akar avɨriba kɨ ia mɨkɨmasa iti. Egh uaghan kɨ ian arazir kuraba jasɨn mɨn da tuisɨghasa. Ezɨ gumazir na amadazim, an araziba bar guizbangɨra. Ezɨ akar a na mɨkemezɨ kɨ oraghiziba, kɨ bar dar gun nguazimɨn gumazamizibav gei.” ");
INSERT INTO msy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Me kamaghɨn fozir puvatɨ, Iesus uan Afeziamɨn gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kamaghɨn amizɨ, a kamaghɨn me mɨgei, “Ia Gumazibar Otarim fɨva ter ighuvimɨn aneguragh, egh ia kamaghɨn fogh, Kɨ Uabɨ Kɨ Kamaghɨn Iti. Egh kamaghɨn fogh, kɨ uabɨ uan nɨghnɨzimɨn gɨn ghua bizitam gamir pu. Puvatɨ. Kɨ akar Afeziam na mɨkemeziba, darara gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Afeziar na amadazɨ kɨ izezim, a na ko ikiavɨra iti. Kɨ zurara bizir a ifongezibagh ami, kamaghɨn a na ataghizɨma kɨ uabɨra itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ezɨ gumazamiziba orazima Iesus akar kam mɨkeme, ezɨ men avɨrim nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ezɨ Iesus kamaghɨn Judan nɨghnɨzir gavgavim an itibav gɨa ghaze, “Ia nan akamɨn suiragh gavgavigh egh ia guizbangɨra nan suren gumazibar otogham. ");
INSERT INTO msy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Egh ia guizɨn akam gɨfogham, eghtɨ guizɨn akam ia damutɨ ia fɨrighrɨgham.” ");
INSERT INTO msy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ezɨ me kamaghɨn an akam ikara, “E Abrahamɨn ovaviba. E dughiatamɨn pura gumazitamɨn ingangarir gumazir kɨnibar ikezir puvatɨ. Ezɨ manmagh sua nɨ ghaze, ‘Ia fɨrighrɨgham’?” ");
INSERT INTO msy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ezɨ Iesus kamaghɨn men akam ikara, “Bar guizbangɨra kɨ ia mɨgei, gumazir arazir kurabagh amiba, me bar arazir kuramɨn ingangarir gumazir kɨnibar mɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ingangarir gumazir kɨniba me zurara anababa ko itir pu. Puvatɨ. Otarimra zurara anabamɨn aven iti. ");
INSERT INTO msy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eghtɨ kamaghɨn Otarim ia damutɨ, ia fɨrighrɨghɨva, egh ia guizbangɨra fɨrighrɨgham. ");
INSERT INTO msy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kɨ fo, ia Abrahamɨn ovaviba. Egha ia nan akam baraghan aghua, kamaghɨn amizɨma, ia na mɨsoghasava ami. ");
INSERT INTO msy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kɨ nan Afeziam nan akazir akabar gun mɨgei. Ezɨ ia uan afeziam da inizir araziba ia dagh ami.” ");
INSERT INTO msy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ezɨ Judaba Iesusɨn akam ikara, “En afeziam, an Abraham.” Ezɨ Iesus me mɨgei, “Ia Abrahamɨn boriba, kamaghɨn ia an mɨrara arazir an amizibar amuam. ");
INSERT INTO msy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kɨ, guizɨn akar God nan sure gamiziba, kɨ bar dar gun ia mɨgei. Ezɨ datɨrɨghɨn ia na mɨsoghasa ifonge. Kar Abrahamɨn arazim puvatɨ! ");
INSERT INTO msy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ia uan afeziamɨn arazim gami.” Ezɨ me a mɨgei, “En amebaba pura ikia e batezir pu. Puvatɨ. E afeziar vamɨra iti, a God.” ");
INSERT INTO msy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ezɨ Iesus kamaghɨn me mɨgei, “Ezɨ kɨ God ko ikegha ize. Kɨ uabɨ uan ifongiamɨn izezir pu. Puvatɨ. God na amadazɨ ezɨ ikɨ ize. Kamaghɨn God guizbangɨra ian Afeziamra, eghtɨ ia na gɨfuegham. ");
INSERT INTO msy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ezɨ manmaghɨn amizɨ ia deravɨra nan akam gɨfozir puvatɨ? Ia nan akam baraghan aghua, egha bizir kam bangɨn ia deravɨra nan akam gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ia uan afeziam Satanɨn boriba. Egha ia uan afeziamɨn ifongiamɨn gɨn mangasa bar gavgafi. A fomɨra ikia gumazibav sosi ezɨ me ariaghiri. Ezɨ guizbangɨn arazim an itir puvatɨ, kamaghɨn a guizbangɨn arazibar gɨn zuir puvatɨ. An akar ifavaribagh ami, kar an akamra. An akar ifavaribagh amir gumazim, egha guizbangɨra akar ifavaribar afeziam. ");
INSERT INTO msy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ezɨ ko, kɨ guizɨn akam akuri, ezɨ kamaghɨn ia nan akam nɨghnɨzir gavgavim an itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ia ghaze, kɨ ti arazir kuram gami? Ia kamaghɨn nɨghnɨghɨva, ia nan arazir kuram azenim datɨgh. Ezɨ kɨ guizɨn akam akuri, ezɨ manmagh sua ia nan akam nɨghnɨzir gavgavim an itir puvatɨ? ");
INSERT INTO msy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Godɨn boriba Godɨn akaba bar da barasi. Ezɨ ia Godɨn boriba puvatɨ, kamaghɨn ia an akam barazir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ezɨ Judaba an akam ikara, “E ghaze, nɨ Samarian gumazir mam, ezɨ duar kuram nɨ gapasa. Ezɨ e nɨn azai, bizir kam ti guizbangɨra, o?” ");
INSERT INTO msy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ezɨ Iesus kamaghɨn akam ikara, “Duar kuram na gapazazir pu. Puvatɨ. Kɨ uan Afeziamɨn ziamra fe, ezɨ ia nan ziam dɨkabɨri. ");
INSERT INTO msy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kɨ uabɨ uan ziam fer puvatɨ. Ezɨ gumazir mam nan ziam fasa iti, egha a jas. ");
INSERT INTO msy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kɨ guizbangɨra ia mɨgei, gumazir nan akamɨn gɨn zuim, an aremeghan kogham. Bar puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ezɨ bizir kamɨn Judaba kamaghɨn Iesus mɨgei, “E datɨrɨghɨn fo, duar kuram nɨ gapasa. Abraham aremegha gɨfa, ezɨ Godɨn akam inigha izir gumaziba uaghan ariaghregha gɨfa. Ezɨ nɨ ghaze, gumazir nan akamɨn gɨn zuim, an aremeghan kogham? ");
INSERT INTO msy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Manmaghɨn ami? En ovavim Abraham aremegha gɨfa! Nɨ ti Abraham gafira, o? Ezɨ Godɨn akam inigha izir gumaziba uaghan ariaghɨre. Ezɨ nɨ uabɨ ghaze, nɨ bar tinara?” ");
INSERT INTO msy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ezɨ Iesus kamaghɨn akam ikara, “Kɨ uabɨ uan ziam fɨtɨ, eghtɨ nan ziam pura bizim. Ezɨ nan Afeziam, a nan ziam fe. Ezɨ ia kamaghɨn mɨgei, a ian God. ");
INSERT INTO msy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Egha ia a gɨfozir puvatɨ. Ezɨ ko, kɨ a gɨfo. Egh kɨ suam, ‘Kɨ a gɨfozir puvatɨ,’ egh kɨ ian mɨn gumazir ifavarimɨn otogham. Kɨ a gɨfogha gɨvagha, egha kɨ deravɨra an akamɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Ian afeziam Abraham, a nan dughiar kɨ izamimɨn ganasa, a bar akonge. Ezɨ an an ganigha gɨvagha, egha an navim bar dera.” ");
INSERT INTO msy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ezɨ Judaba akar kam baregha egha kamaghɨn Iesus mɨgei, “Nɨ 50 plan azeniba puvatɨ. Nɨ ti Abrahamɨn ganis, o?” ");
INSERT INTO msy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ezɨ Iesus me mɨgei, “Kɨ guizbangɨra ia mɨgei, Abraham tɨghar otivam, kɨ fomɨra, Kɨ Iti.” ");
INSERT INTO msy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ezɨ me a ginivasa dagɨaba isi. Ezɨ Iesus uabɨ modogha egha Godɨn Dɨpenimɨn mɨriam ategha azenan ghu. ");
INSERT INTO msy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Egha Iesus ghuavigha gumazir damazir okavɨzir mamɨn api. An damazimning okavizɨ amebam a bate. ");
INSERT INTO msy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ezɨ Iesusɨn suren gumaziba an azara. “Tisa, tina arazir kuram gami, gumazir kam o an amebam ko afeziam, ezɨ kamaghɨn an damaziba okavizɨ amebam a bate?” ");
INSERT INTO msy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ezɨ Iesus kamaghɨn akam ikara, “Gumazir kam arazir kuram gamizir puvatɨ, egha an amebam ko afeziam uaghan arazir kuratam gamizir puvatɨ. God kamagh sua, bizir gumazir kamɨn otozim, gumazamiziba an ganɨva fogham, Godɨn ingangarim azenara men oto. Kamaghɨn an damaziba okavizɨ amebam a bate. ");
INSERT INTO msy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ezɨ datɨrɨghɨn aruem ikiavɨra itima, e gumazir na amadazɨ kɨ izezim an ingangarim damuam. Amɨnim pɨrasava roghɨra izi, ezɨ gumaziba ingangaritam damighan kogham. ");
INSERT INTO msy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dughiar kɨ nguazir kamɨn itim, kɨ gumazir angazangarim nguazimɨn itir gumazamizibagh anɨdim.” ");
INSERT INTO msy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iesus kamaghɨn mɨkemegha egha nguazim giparigha egha nguazim sara veregha, egha gumazimɨn damazim gatɨ. ");
INSERT INTO msy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Egha Iesus kamaghɨn a mɨgei, “Nɨ mangɨva Siloamɨn mozir dɨpam guruegh.” (Ziar kam Siloam, an mɨngarim kamaghɨn ghu, “Amada.”) Ezɨ gumazir damazir okavɨrɨzim ghua rue. Egha uamategha iza, biziba bar deravɨra dar gari. ");
INSERT INTO msy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Gumazir kam faragha dagɨaba uabɨ danɨngasa gumazamizibagh inge, ezɨ gumazamizir avɨriba an gani. Datɨrɨghɨn men marazi ko an boroghɨn itir darazi, me ghaze, “Gumazir kamra, a faragha apiav ikia dagɨaba bagha gumazibagh inge?” ");
INSERT INTO msy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Egha marazi ghaze, “Are, gumazir kamra.” Ezɨ marazi ghaze, “Puvatɨ. A gumazir kamɨn mɨrara gara, egha a ighara.” Ezɨ gumazir kam uabɨ ghaze, “Kar kɨrara.” ");
INSERT INTO msy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ezɨ me an azara, “Manmaghɨn amizɨma nɨn damazimning dera?” ");
INSERT INTO msy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ezɨ a kamaghɨn men akam ikara, “Gumazir kam an ziam Iesus, a nguazim ko dɨpam veregha nan damazimning gatɨ. Egha na mɨgei, ‘Nɨ Siloamɨn mozir dɨpamɨn mangɨgh egh ruegh.’ Ezɨ kɨ ghua ruezɨma nan damazimning dera, ezɨ kɨ deravɨra bizibar gari.” ");
INSERT INTO msy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ezɨ me an azara, “Gumazir kam managh iti?” Ezɨ a mɨgei, “Kɨ fozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Egha me gumazir faragha damaziba okavɨzir kam me a inigha Farisiba bagha zui. ");
INSERT INTO msy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ezɨ dughiar Iesus nguazir beghneazimɨn ingarigha gumazimɨn damazimning gamizɨ a garim, kar Sabatɨn dughiam. ");
INSERT INTO msy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ezɨ kamaghɨn Farisiba uam an azai, “Nɨn damazimning manmaghɨn amigha dera?” Ezɨ a kamaghɨn me mɨgei, “A nguazir beghneazim isa nan damazimning gatɨzɨ, ezɨ kɨ rue, egha kɨ biziba deravɨra dar gari.” ");
INSERT INTO msy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ezɨ Farisin maba ghaze, “Gumazir kam a Sabatɨn dughiamɨn arazibar gɨn zuir puvatɨ. Kamaghɨn e fo, God gumazir kam amadazɨ puvatɨ.” Ezɨ marazi ghaze, “Manmagh amizɨ gumazir arazir kuram itim mirakelɨn kabar amigham.” Egha me uari abɨki. ");
INSERT INTO msy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Egha Farisiba ua faragha gumazir damaziba okavɨzir kamɨn azangsɨsi, “Nɨ ghaze, gumazir kam nɨn damazimning akɨri, ezɨ kamaghɨn nɨ manmaghɨn nɨghnɨsi, a gumazir manmaghɨra garim?” Ezɨ gumazir kam kamaghɨn me akam ikara, “A Godɨn akam inigha izir gumazir mam.” ");
INSERT INTO msy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bar guizbangɨra, faragha gumazir kamɨn damazimning okafi, egha datɨrɨghɨn an damazimning kuiaghirɨ. Ezɨ Judan gumazir aruaba bizir kam nɨghnɨzir gavgavim an ikian aghua. Egha kamaghɨn me gumazir kamɨn amebam ko afeziamɨn diagha ghaze, gua izɨ. ");
INSERT INTO msy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ezɨ aning izima me kamaghɨn aningɨn azai, “Ka ti guan borimra? Dughiar amebam a batezim, an damazimning okavigha iti, gua kamaghɨn mɨkeme, o? Ezɨ manmagh amizɨma a datɨrɨghɨn gari?” ");
INSERT INTO msy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ezɨ an amebam ko afeziam kamaghɨn men akam ikara, “Ga fo, kar gan borim. Ezɨ dughiar amebam a batezim, an damazimning okavigha iti, ga uaghan a gɨfo. ");
INSERT INTO msy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ezɨ datɨrɨghɨn an damazimning manmaghɨn kuiaghirɨ, ga uaghan fozir puvatɨ. Ezɨ tina an damazimning kui, ga uaghan fozir puvatɨ. Ia an azaragh. An asegha gɨfa. A uabɨ ua bagh mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","An amebam ko afeziam Judabar atiatigha, egha kamaghɨn mɨgɨrɨgɨar kam gami. Me fo, Judaba faragha kamaghɨn akam mɨsoke, gumazitam kamaghɨn mɨkɨm suam, “Iesus a Gumazir God Uam E Iniasa Mɨsevezir kam,” eghtɨ me an anogoreghtɨ a ua God ko mɨgeir dɨpenimɨn aven ikian kogham. ");
INSERT INTO msy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ezɨ kamaghɨn gumazir kamɨn amebam ko afeziam ghaze, “An asegha gɨfa. Ia an azangsɨgh.” ");
INSERT INTO msy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Egha gɨn me ua gumazir faragha damaziba okavɨzim dia, egha a mɨgɨa ghaze, “Nɨ Godɨn damazimɨn guizɨn akam mɨkɨmsɨ egh akar dɨkɨrɨzim damigh. E fo, gumazir nɨ mɨkemezir kam, an arazir kurabagh amir gumazim.” ");
INSERT INTO msy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Egha a kamaghɨn akam ikara, “An arazir kurabagh amir gumazim o puvatɨ, kɨ kamaghɨn fozir puvatɨ. Egha bizir vamɨra, kɨ a gɨfo, kɨ faragha damazimning okafi, egha datɨrɨghɨn nan damazimning kuiaghirɨ.” ");
INSERT INTO msy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ezɨ me uam an azara, “A manmaghɨn nɨ gami? A manmaghɨn nɨn damazimning akɨri?” ");
INSERT INTO msy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ezɨ a kamaghɨn men akam ikara, “Kɨ ia mɨkemegha gɨfa, ezɨ ia oraghan aghua. Ia manmagh sua dughiar avɨribar oraghasa? Ia ti uaghan an suren gumazibar otivasa, o?” ");
INSERT INTO msy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ezɨ Farisiba dɨbovibar kamaghɨn gumazir kam mɨgei, “Nɨrara an suren gumazim. E Mosesɨn suren gumaziba. ");
INSERT INTO msy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","E kamaghɨn fo, God akam Moses ganɨngi. Ezɨ gumazir kam, e fozir puvatɨ, a nguibar manamɨn oto.” ");
INSERT INTO msy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ezɨ gumazir faragha damaziba okavɨzir kam, a kamaghɨn men akam ikara, “Ia akar bar igharazim mɨgeima, kɨ dɨgavir kuram gami! Gumazir nan damazimning akɨrizir kam, ia ghaze ia gɨfozir puvatɨ, a nguibar manamɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","E fo, God gumazir arazir kurabagh amiba barazir puvatɨ. Gumazitam Godɨn ziam fɨva egh an ifongiamɨn gɨn mangɨtɨ, eghtɨ God a baragham. ");
INSERT INTO msy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bar fomɨra iza datɨrɨkɨn, gumazitamɨn damazimning okavizɨ amebam a batezɨ, ezɨ gɨn gumazir mam an damazimning akɨrizɨ, e eghaghanir katam e a baraghizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","God gumazir kam amadaghan koghai, a bizitam damighan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Farisiba me akar kam baregha egha kamaghɨn an akam ikara, “Manmagh ami? Arazir kuram bar nɨ avara, dughiar nɨn amebam nɨ batezimɨn tugha egha iza datɨrɨkɨn. Ezɨ nɨ ti en sure damuasa, o?” Egha me a batoghezɨma a zui. ");
INSERT INTO msy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iesus orazima me gumazir kam batoke, ezɨ a ghua a buri. Egha a batogha kamaghɨn a mɨgei, “Nɨ Gumazibar Otarim nɨghnɨzir gavgavim an ti, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ezɨ a kamaghɨn an akam ikara, “Gumazir Ekiam, Gumazibar Otarir kam a tina? Kɨ nɨghnɨzir gavgavim an ikɨsɨ, kamaghɨn nɨ na mɨkɨm, a tina.” ");
INSERT INTO msy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ezɨ Iesus a mɨgei, “Nɨ an ganigha gɨfa. A gumazir datɨrɨghɨn nɨ ko mɨgeim.” ");
INSERT INTO msy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ezɨ gumazir kam mɨgei, “Ekiam, kɨ nɨghnɨzir gavgavim iti.” Egha Iesusɨn guamɨn tevimning apɨrigha an ziam fe. ");
INSERT INTO msy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ezɨ Iesus ghaze, “Kɨ gumazamizibar araziba tuisɨghasa kɨ ize. Kɨ kamagh sua, gumazir damaziba okavigha itiba me ganam, ezɨ gumazir gariba, men damaziba okavigham. Bizir kam bagha, kɨ nguazir kamɨn ize.” ");
INSERT INTO msy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisin maba me Iesusɨn boroghɨra ikia akar kam baraki. Egha an azara, “Nɨ kamaghɨn e mɨkɨmasa, e ti uaghan damaziba okafi, o?” ");
INSERT INTO msy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ezɨ Iesus kamaghɨn me mɨgei, “Ian damaziba okavizɨ, ia arazir kurabar osɨmtɨziba puvatɨghai. Egha ia ghaze, ‘En damaziba gari.’ Kamaghɨn amizɨma ian arazir kurabar osɨmtɨzim ikiavɨra iti.” ");
INSERT INTO msy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Egha Iesus ua kamaghɨn mɨgei, “Bar guizbangɨra kɨ ia mɨgei, gumazim sipsipbar dɨvazimɨn tiar akamɨn aven zuir puvatɨgha, egha tuavir igharazimɨn dɨvazimɨn ikiavkɨnigha egha aven ghua, a mati okɨmakɨar gumazim egha gumazir igharaz darazir biziba isim. ");
INSERT INTO msy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ezɨ gumazir tiar akamɨn aven zuim, a sipsipbagh eghuvir gumazim. ");
INSERT INTO msy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tiar akamɨn garir gumazim a gumazir kam bagha tiam kui. Ezɨ sipsipba an tiarim barasi. Ezɨ a vaghvagha uabɨ uan sipsipbar ziabar diava egha men akua azenan zui. ");
INSERT INTO msy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","A uan sipsipbar akua azenan ghugha, egha a uabɨ men faragha zui. Ezɨ sipsipba an tiarim barasi. Kamaghɨn me an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Me gumazir igharazibar gɨn zuir puvatɨ. Me gumazir igharazibar tiaribagh fozir puvatɨ. Kamaghɨn ami, gumazir igharazim men dɨmtɨ, sipsipba an aregham.” ");
INSERT INTO msy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iesus akar isɨn zuimɨn me mɨkeme, ezɨ me akar kamɨn mɨngarim, me a gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kamaghɨn amizɨ, Iesus ua kamaghɨn me mɨgei, “Kɨ bar guizbangɨra ia mɨgei, kɨ uabɨ, kɨ sipsipba aven zuir tiar akam. ");
INSERT INTO msy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Gumazir nan faragha izeziba, me bar okɨmakɨar gumaziba egha gumazibar biziba isir gumaziba. Ezɨ sipsipba me barazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kɨ uabɨ kɨ tiar akam. Ezɨ gumazitam na bagh izɨva egh dɨvazimɨn aven mangɨghtɨ, God an akurvagham. Eghtɨ an aven mangɨghɨva egh azenan izam, egh daruva dagheba iniam. ");
INSERT INTO msy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Okɨmakɨar gumazim, a sipsipba okɨmɨva me mɨsoghtɨma me arɨmɨghiram, egh me gasɨghasɨghasa izi. A bizir igharazitam damuasa izir puvatɨ. Ezɨ ko, kɨ ia angamra itir ikɨrɨmɨrim iniasa, kɨ ize, eghtɨ ikɨrɨmɨrir aghuarim guizbangɨra ia gizɨvagham. ");
INSERT INTO msy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Kɨ uabɨ kɨ sipsipbagh eghuvir gumazir aghuim. Egha sipsipbagh eghuvir gumazir aghuim, a uan sipsipbar akurvaghsɨ me bagh aremegham. ");
INSERT INTO msy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ezɨ gumazir dagɨar ingangarimra amim, a guizbangɨra sipsipbagh eghuvir gumazim puvatɨ, a sipsipbar ghuavim puvatɨ. Egha a sipsipbar garima afiar atiar mam izima, a sipsipba ategh arɨmangɨgham. Eghtɨ afiar atiam sipsipbar amɨva egh men agɨntɨghtɨ me tintinibar mangegham. ");
INSERT INTO msy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Gumazir kam uan ivezim iniasavɨra ingara iti. A guizbangɨra sipsipbagh nɨghnɨzir puvatɨ. Kamaghɨn, a sipsipba ategh arɨmangɨgham. ");
INSERT INTO msy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Kɨ uabɨ kɨ sipsipbagh eghuvir gumazir aghuim. Afeziam na gɨfozɨma, kɨ Afeziam gɨfozɨ moghɨra kɨ uan sipsipbagh fo, ezɨ nan sipsipba na gɨfo. Ezɨ kɨ sipsipbar akurvaghsɨ, me bagh aremegham. ");
INSERT INTO msy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Kɨ sipsipɨn maba uaghan iti, da dɨvazir kamɨn sipsipba puvatɨ. Ezɨ kɨ sipsipɨn kaba uaghan men aku izam, eghtɨ me nan tiarim baragham. Eghɨva me bar sipsipɨn okuruar vamɨra ikɨtɨ, eghtɨ sipsipbagh eghuvir gumazir vamɨra bar me geghuvam. ");
INSERT INTO msy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Kɨ kamagh sua, kɨ ua dɨkavigh angamra ikiam, kamaghɨn kɨ aremeghasa ifonge. Kamaghɨn ami, Afeziam bar na gifonge. ");
INSERT INTO msy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gumazitam na mɨsueghtɨ kɨ aremeghan kogham. Puvatɨ. Kɨ uabɨ nan ifongiamɨn kɨ aremegham. Kɨ oveghamin gavgavim ikia, egha uaghan ua dɨkavamin gavgavim iti. Nan Afeziam kamaghɨn damuasa na mɨkeme.” ");
INSERT INTO msy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judaba akar kam baregha egha ua uari tuiragha okoroar pumuning iti. ");
INSERT INTO msy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Egha gumazir avɨriba ghaze, “Duar kuram a gapasa, ezɨ an ongani. Manmagh sua ia an akam barasi?” ");
INSERT INTO msy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ezɨ marazi ghaze, “Akar kam, a duar kuram gapazazir gumazimɨn akam puvatɨ. Eghtɨ duar kuram manmaghɨn gumazir damazim okavɨzim akɨrigham?” ");
INSERT INTO msy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ezɨ dughiar kamɨn, isar ekiamɨn dughiam Jerusalemɨn oto. Kar dughiar me fomɨra Godɨn Dɨpenim gɨnɨghnɨgha ghaze, dɨpenir kam a God baghavɨra itir dɨpenim. Ezɨ datɨrɨghɨn me dughiar kam ginɨghnɨsi. An orangtɨzimɨn dughiamɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ezɨ Iesus Godɨn Dɨpenimɨn ikia Solomonɨn Azuarimɨn aven arui. ");
INSERT INTO msy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ezɨ Judaba iza anekuvagha egha kamaghɨn an azara, “Dughiar manamra nɨ deravɨra e mɨkɨmam, nɨ bar tinara? Nɨ gumazir kamra, God Uam E Iniasa Mɨsevezir Gumazim, egh nɨ deravɨra e mɨkɨm.” ");
INSERT INTO msy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ezɨ Iesus kamaghɨn men akam ikara, “Kɨ ia mɨkemegha gɨfa, ezɨ ia nɨghnɨzir gavgavim nan ikian aghua. Kɨ ingangariba bar uan Afeziamɨn ziamɨn dagh ami, ezɨ ingangarir kaba nan gun mɨgɨa ian akakasi, kɨ tinara. ");
INSERT INTO msy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Egha ia nan sipsipba puvatɨ, kamaghɨn amizɨma ia nɨghnɨzir gavgavim nan itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nan sipsipba nan tiarim barasi, ezɨ kɨ me gɨfozɨ, me nan gɨn izi. ");
INSERT INTO msy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kɨ zurara itir ikɨrɨmɨrir aghuarim me ganɨdi, eghtɨ me ovengan kogham. Bar puvatɨ. Eghtɨ gumazitam nan dafarimɨn me batueghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nan Afeziam me isa na ganɨngi. Egha an gavgavim bar ekevegha, bizir igharazibar gavgaviba, bar dagh afira. Kamaghɨn amizɨ gumazitam an dafarimɨn me batueghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ezɨ kɨ uan Afeziam ko, ga gumazir vamɨran mɨn iti.” ");
INSERT INTO msy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judaba akar kam baregha egha me ua a ginivasa dagɨaba isi. ");
INSERT INTO msy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ezɨ Iesus kamaghɨn me mɨgei, “Nan Afeziam na mɨkemezɨ, kɨ ingangarir aghuir avɨribagh amima ia dar gani. Egha, ia ingangarir kabar manamra nɨghnɨgha egha dagɨaba na ginivasa?” ");
INSERT INTO msy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ezɨ Judaba kamaghɨn an akam ikara, “E ingangarir aghuitam gɨnɨghnɨgha egha dagɨaba fɨ nɨ mɨkɨnasa, puvatɨ. Nɨ Godɨn danganim iniasa, kamaghɨn e dagɨaba nɨ mɨkɨnasa. Nɨ pura gumazir kɨnim, egha nɨ kamaghɨn mɨgɨa ghaze, nɨ uabɨ nɨ God.” ");
INSERT INTO msy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ezɨ Iesus kamaghɨn men akam ikara, “Ian Arazir Moses Osirizimɨn aven, akar kam iti, ‘God ghaze, “Iarara godba.” ’ ");
INSERT INTO msy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Fomɨra God akar kamɨn gun gumazibav keme, egha me mɨgɨa ghaze, me godba. Ezɨ e fo, Godɨn Akɨnafarimɨn itir akam zurara ikɨvɨra ikɨva, igharagha otoghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ezɨ ko, Afeziam uabɨ na mɨsefe, egha na amadazɨma kɨ nguazimɨn ize. Egha kɨ ghaze, ‘Kɨ Godɨn Otarim,’ ezɨ manmagh sua ia ghaze, ‘Nɨ Godɨn danganim iniasa?’ ");
INSERT INTO msy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Kɨ uan Afeziamɨn ingangarim damuan koghtɨ, eghtɨ ia nɨghnɨzir gavgavim nan akamɨn ikian markɨ. ");
INSERT INTO msy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ezɨ kɨ an ingangarim gami. Ezɨ ia nan akam nɨghnɨzir gavgavim an ikian aghuaghɨva, egh ia nɨghnɨzir gavgavim nan ingangarir kɨ amibar ikɨ. Eghtɨ ia deravɨra fofoziba ko nɨghnɨziba kamaghɨn da ini, Afeziam nan aven iti, ezɨ kɨ Afeziamɨn aven iti.” ");
INSERT INTO msy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Egha me uam an suighasava amima, ezɨ a men tongɨn suiaghrɨgha ghu. ");
INSERT INTO msy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Egha Iesus uamategha ghua Jordanɨn dɨpam abigha vongɨn ghu. Egha ghua danganir Jon fomɨra gumaziba ruezimɨn oto, egha a danganir kamɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ezɨ gumazamizir avɨriba a bagha izi. Egha me ghaze, “Guizbangɨra, Jon gavgavim uan akam danɨngasa mirakelɨn arazitam gamizir puvatɨ. Egha akar Jon gumazir kamɨn gun mɨkemeziba, da bar guizbangɨra.” ");
INSERT INTO msy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ezɨ dughiar Iesus danganir kamɨn itim, gumazamizir avɨriba nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gumazir mam Lasarus, an arei. A Betanin nguibamɨn gumazim. Betanin nguibam, Maria uan avenamebam Marta aning itir nguibam. ");
INSERT INTO msy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Marian kamra, a mughuriar aghuim zuir borem isa Ekiamɨn dagarimning ginge, egha uan dapanir arɨzibar anedɨsi. Datɨrɨghɨn an dozim Lasarus arei.) ");
INSERT INTO msy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ezɨ an amizimning Iesus bagha akam amada, “Ekiam, gumazir nɨ bar ifongezim, an arei.” ");
INSERT INTO msy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ezɨ Iesus oregha, egha kamaghɨn mɨgei, “Kar gumazim aremegh bar gɨvaghamin arɨmariam puvatɨ. Kar gumazamizibar amutɨ me Godɨn gavgavimɨn ganɨva egh ziar ekiam a danɨngam. Ezɨ tuavir kamra, Godɨn Otarim uaghan ziar ekiam iniam.” ");
INSERT INTO msy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iesus bar Marta ko an afumim ko Lasarus, me gifonge. ");
INSERT INTO msy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ezɨ a Lasarusɨn arɨmariamɨn akam baregha, egha ua dughiar pumuningɨn nguibar a itir kamɨn ikiavɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Egha a gɨn suren gumazibav gei, “E uamategh Judian Distrighɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ezɨ suren gumaziba a mɨgɨa ghaze, “Tisa, boghɨmra Judian Distrighɨn itir gumaziba, me dagɨaba fɨ nɨ mɨkɨnasava ami. Ezɨ nɨ uamategh Judian Distrighɨn mangasa, a?” ");
INSERT INTO msy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Egha Iesus kamaghɨn men akam ikara, “Dughiar vamɨra aruem ti 12 plan auan gari, o? Gumazim aruemɨn aruava, nguazir kamɨn angazangarimɨn garava, kamaghɨn an asaghpora irir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ezɨ gumazim dɨmagarimɨn aruava, a ganamin angazangariba puvatɨ, kamaghɨn an asaghpor irɨgham.” ");
INSERT INTO msy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iesus kamaghɨn mɨgɨa, egha gɨn ua me mɨgei, “En roroam Lasarus an akui. Ezɨ kɨ mangɨva a damightɨ a dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ezɨ suren gumaziba akar kam baregha egha kamaghɨn mɨgei, “Ekiam, a dakuighɨva, an arɨmariam gɨvagham.” ");
INSERT INTO msy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Suren gumaziba me kamaghɨn fozir puvatɨ, Iesus ghaze, Lasarus aremegha gɨfa. Me ghaze, Iesus Lasarusɨn mɨgɨa ghaze, a puram akui. ");
INSERT INTO msy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ezɨ datɨrɨghɨn Iesus deravɨra kamaghɨn me mɨgɨa ghaze, “Lasarus an aremegha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ezɨ kɨ ia ginɨghnɨsi, egha kɨ fo, bizir kam ia damutɨ, ia nɨghnɨzir gavgavim ikiam. Kamaghɨn, kɨ a ko dughiar kamɨn ikezir puvatɨgha, egha kɨ bar akonge. Egh datɨrɨghɨn, e a bagh mangam.” ");
INSERT INTO msy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iesus mɨkemegha gɨvazɨma, ezɨ Tomas an ziar mam Fufuzim, a kamaghɨn suren gumazir igharazibav gei, “E uaghan uan Tisa ko mangɨva, egh a ko ovengam.” ");
INSERT INTO msy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ezɨ Iesus uan suren gumaziba ko ghuava Betanin nguibamɨn boroghɨn zui, egha kamaghɨn oraki, Lasarus 4 plan dughiabar mozimɨn ike. ");
INSERT INTO msy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanin nguibam a Jerusalemɨn boroghɨn iti, tuavimɨn ruarim a 3 plan kilomitan tu. ");
INSERT INTO msy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ezɨ Judian gumazamizir avɨriba iza Marta ko Marian gara iti. Aningɨn dozimɨn ovevem bagha, me aningɨn akurvaghamin mɨgɨrɨgɨar tabav kɨmtɨ aningɨn navimning deraghasa, me ize. ");
INSERT INTO msy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ezɨ Marta orazima Iesus izi, ezɨ a Maria ataghizɨ a dɨpenimɨn itima a ghua tuavimɨn Iesus bato. ");
INSERT INTO msy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Egha Marta kamaghɨn Iesus mɨgei, “Ekiam, nɨ kagh ikezɨ, nan dozim aremeghan koghai! ");
INSERT INTO msy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ezɨ kɨ uaghan fo, nɨ datɨrɨghɨn bizitam bagh Godɨn azaraghtɨ a nɨ danigam.” ");
INSERT INTO msy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ezɨ Iesus a mɨgei, “Nɨn dozim ua dɨkavigham.” ");
INSERT INTO msy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ezɨ Marta a mɨgei, “Kɨ fo, a nguazim gɨvaghamin dughiamɨn dɨkavigham, dughiar gumazamiziba bar dɨkavamim.” ");
INSERT INTO msy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ezɨ Iesus a mɨgei, “Kɨ uabɨ, kɨ gumazir gumazamizibagh amima me ua dɨkavim, egha kɨ uabɨ, kɨ gumazir ikɨrɨmɨrir zurara itim anɨdim. Gumazitam, nɨghnɨzir gavgavim nan ikɨva aremeghɨva, an angamra ikɨvɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ezɨ gumaziba bar angamra ikia egha nɨghnɨzir gavgavim nan iti, me aremeghan kogham. Puvatɨ. Me angamra ikɨ mamaghɨra ikiam. Nɨ nɨghnɨzir gavgavim akar kabar iti, o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ezɨ Marta kamaghɨn Iesus mɨgei, “Are, Ekiam! Kɨ nɨghnɨzir gavgavim ikia fo, nɨ Godɨn Otarim. Nɨ gumazir kam God nguazimɨn nɨ amangasa mɨkeme, Gumazir God Uam E Iniasa Mɨsevezim.” ");
INSERT INTO msy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta kamaghɨn mɨkemegha, egha ghua uan avenamebam Marian dia. Egha nɨmɨra Marian kuarim gatɨgha kamaghɨn a mɨgei, “Tisa a ize, egha nɨ bagha azai.” ");
INSERT INTO msy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ezɨ Maria kamaghɨn oregha, egha zuamɨra dɨkavigha Iesus bagha ghu. ");
INSERT INTO msy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Iesus tɨghar nguibamɨn otivam. A danganir Marta faragha a batozɨ naghɨra iti.) ");
INSERT INTO msy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ezɨ Judaba Marian apangkuvigha egha a ko dɨpenim iti, egha an garima a zuamɨra dɨkavigha azenan ghu. Ezɨ me an gɨn zui. Me ghaze, a ti aziasa mozimɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ezɨ Maria ghua Iesus itir danganir kamɨn oto, egha Iesus bato. Egha a Iesusɨn suemningɨn boroghɨra tevimning apɨrigha, egha kamaghɨn a mɨgei, “Ekiam, nɨ ti kagh ikezɨ, nan dozim aremeghan koghai.” ");
INSERT INTO msy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ezɨ Iesus Marian garima an azi. Egha a Judan Marian gɨn izezibar garima me uaghan azi. Egha a bar men apangkuvigha egha uaghan aziasava ami. ");
INSERT INTO msy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Egha a me mɨgei, “Ia managh anefa?” Ezɨ me a mɨgei, “Ekiam, nɨ izɨ ganigh.” ");
INSERT INTO msy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ezɨ Iesus azia teriba iri. ");
INSERT INTO msy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ezɨ Judaba an ganigha egha kamaghɨn uariv gei, “Munagh gan. A gumazir kam bar a gifonge.” ");
INSERT INTO msy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Egha marazi ghaze, “A gumazir damaziba okaviziba akɨrizɨma me ua gari. Egh a gumazir kamɨn akurazɨ an aremeghan koghai. A ti manmagh sua an akuraghan aghua?” ");
INSERT INTO msy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ezɨ Iesus ua bar oseme, egha a ghua mozimɨn oto. Mozir kam a dagɨar mozim me mɨghsɨamɨn an ingari. Ezɨ dagɨar ekiar mam an tiar akam avara. ");
INSERT INTO msy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ezɨ Iesus ghaze, “Ia dagɨam puegh munagh amadagh.” Ezɨ Marta, a gumazir aremezimɨn amizim, a kamaghɨn Iesus mɨgei, “Ekiam, an kuam 4 plan dughiabar mozimɨn ike. An mughuriar kuram otivam.” ");
INSERT INTO msy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ezɨ Iesus a mɨgei, “Kɨ faragha nɨ mɨkemegha gɨfa, nɨ nɨghnɨzir gavgavim ikɨva, egh nɨ Godɨn gavgavir ekiamɨn ganam.” ");
INSERT INTO msy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Egha me dagɨam puegha munagh amadazɨ, Iesus kogha overiamɨn gara egha kamaghɨn mɨgei, “Afeziam, nɨ na barasi, kamaghɨn amizɨma kɨ nɨ mɨnaba. ");
INSERT INTO msy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kɨ fo, nɨ zurara na barasi. Ezɨ kɨ gumazir kagh tuivighav itibagh nɨghnɨgha, egha kamaghɨn ifonge, me kamaghɨn fogh suam, nɨ na amadazɨ kɨ ize. Kamaghɨn kɨ akar kam gami.” ");
INSERT INTO msy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Iesus mɨkemegha gɨvagha, egha a pamtem dɨa ghaze, “Lasarus, nɨ azenan izɨ.” ");
INSERT INTO msy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ezɨ Lasarus ua dɨkavigha egha azenan ize. An sueba ko aghariba ko guam, me inimɨn da nomke. Ezɨ Iesus kamaghɨn me mɨgei, “Ia inim adegh, egh an ateghtɨ, a daru.” ");
INSERT INTO msy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ezɨ Judan gumazamizir iza Maria ko itiba, men avɨrim Iesus amizir bizir kamɨn ganigha egha kamaghɨn nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ezɨ men marazi Farisiba bagha ghuegha bizir Iesus amizir kamɨn me mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kamaghɨn amizɨ, ofa gamir gumazir ekiaba ko Farisiba, me Judan kotɨn aven itir gumaziba bar men diagha iza uari akuvagha egha kamaghɨn me mɨgei, “E manmaghɨn damuam? Gumazir kam mirakelɨn avɨrim gami! ");
INSERT INTO msy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","E kamaghɨn aneteghtɨ an arazir kam damuvɨra ikɨtɨ, eghtɨ gumazamiziba bar nɨghnɨzir gavgavim an ikiam. Eghtɨ Romɨn gumazir ekiaba izɨva en Godɨn Dɨpenim ko en adarasi saram asɨghasigham.” ");
INSERT INTO msy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ezɨ men tongɨn gumazir mam, an ziam Kaiafas, an azenir kamɨn ofa gamir gumazir ekiabar dapanim. A kamaghɨn me mɨgei, “Ia fofoziba bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ia ti arazitam gɨfozir puvatɨ, a ian akurvagham. Puvatɨghtɨma, en adarazi bar ovegham.” ");
INSERT INTO msy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafas uabɨ uan nɨghnɨzimɨn akar kam mɨkemezir puvatɨ. A azenir kamɨn ofa gamir gumazir ekiabar dapanimɨn iti. Egha an arazir Godɨn akam inigha izimɨn mɨrara mɨgɨa ghaze, Iesus a Judabar akurvaghsɨ aremegham. ");
INSERT INTO msy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ezɨ Iesus Judabar akurvaghsɨvɨra aremeghan kogham. Puvatɨ. A Godɨn borir tintinibar itiba bagh aremegh me akuvaghtɨ me vamiran otogham. ");
INSERT INTO msy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ezɨ dughiar kamɨn ghuava gumazir aruaba Iesus mɨsueghtɨma an aremeghasa tuaviba buria egha akabar kɨri. ");
INSERT INTO msy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kamaghɨn amizɨ Iesus Judabar tongɨn uabɨ azenim gatɨgha aruir puvatɨ. Egha a nguibar kam ategha egha a ghua gumaziba itir puvatɨzir danganim boroghɨra itir nguibar mamɨn iti. Nguibar kam, an ziam Efraim. Ezɨ a uan suren gumaziba ko, me nguibar kamɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ezɨ God Israelbagh Itazir Dughiamɨn isar ekiam roghɨra ize. Kamaghɨn tintinimɨn nguibabar gumazamiziba Jerusalemɨn ghua, Godɨn damazimɨn uari zuasa ghue. ");
INSERT INTO msy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Egha me Iesus bagha ruiavɨra iti. Me Godɨn Dɨpenimɨn mɨriamɨn aven tuivighav ikia, egha me uarir tongɨn kamaghɨn uarir azangsɨsi, “Ia manmaghɨn nɨghnɨsi? A ti izɨ isar ekiamɨn dughiamɨn ganam, o puvatɨgham?” ");
INSERT INTO msy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ezɨ gumazir aruaba ko Farisiba me gumazamizibav kemegha gɨfa, gumazitam danganir Iesus itim gɨfogh, egh me mɨkemegh. Eghtɨ me an suiragh kalabus darɨghasa. ");
INSERT INTO msy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ezɨ 6 plan dughiaba ikiavɨra itima, ezɨ God Israelbagh Itazir Dughiamɨn isar ekiam otivasa. Ezɨ dughiar kamɨn Iesus Betanin nguibamɨn ghu. Betani a Lasarusɨn nguibam, a gumazir Iesus mozimɨn a gamizɨma a ua dɨkavizim. ");
INSERT INTO msy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ezɨ me nguibar kamɨn Iesusɨn ziam fasa dagheba isai. Ezɨ Marta dagheba tui. Ezɨ Lasarus, a gumazir Iesus ko dakozimɨn apiaghav ikia apibar mav. ");
INSERT INTO msy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ezɨ Maria, mughuriar aghuim zuir borem, a mɨsevir mamɨn ikia bar izɨvagha, egha a bar dɨkɨrigha egha an ivezim bar pɨn ko. Egha an a inigha iza Iesusɨn dagarimning ginge, egha uan dapanir arɨzimɨn anedɨsi. Ezɨ borer kamɨn mughuriar aghuim dɨpenim bar akoro. ");
INSERT INTO msy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ezɨ an suren gumazir mam, a Judas Iskariot, a gumazir kam a gɨn Iesus isa apanibar agharim gatɨ, a kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Manmagh sua e borer kam isa 300 silvan dagɨaba bagh anemangan aghua, eghtɨ e an dagɨaba inighɨva gumazir onganarazibar anɨngam?” ");
INSERT INTO msy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas onganarazir gumazibagh nɨghnɨzir puvatɨ, egha a kamaghɨn mɨgei. Puvatɨ. An okɨmakɨar gumazim. Egha Iesusɨn adarazir dagɨabar mɨtarim an gara iti, egha dughiar maba a da okei. ");
INSERT INTO msy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ezɨ Iesus akar kam baregha egha kamaghɨn mɨgei, “Amizir kam atakigh! Eghtɨ a bizir an amizir kamɨn nɨghnɨzim ikɨvɨra ikɨ mangɨ dughiar kɨ aremeghtɨ me na mozim datɨgham. ");
INSERT INTO msy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gumazir onganaraziba ia ko ikɨvɨra ikiam. Eghtɨ ko, kɨ ia ko zurara ikɨvɨra ikian kogham.” ");
INSERT INTO msy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ezɨ Judan avɨrir ekiam oregha me fo, Iesus Betanin nguibamɨn iti. Ezɨ me a bagha izi. Me Iesusɨn ganasavɨra izir puvatɨ. Me fo, Iesus faragha Lasarus mozimɨn a gamizɨma a ua dɨkafi. Ezɨ me uaghan Lasarusɨn ganasa. ");
INSERT INTO msy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kamaghɨn ofa gamir gumazir ekiaba uaghan Lasarus mɨsueghtɨ an aremeghasa akam mɨsosi. ");
INSERT INTO msy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Me fo, Judan avɨriba Iesus Lasarus gamizir bizim ginɨghnɨsi, egha me ofa gamir gumazir ekiaba ategha akɨrim ragha me gasara, egha me nɨghnɨzir gavgavim Iesusɨn iti. Bizir kam bagha me Lasarus mɨsoghasava ami. ");
INSERT INTO msy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ezɨ gumazamizir avɨriba God Israelbagh Itazir Dughiamɨn isar ekiamɨn ganasa iza Jerusalemɨn iti. Boghɨnaronra Iesus Lasarusɨn dɨpenimɨn ame. Ezɨ datɨrɨghɨn gumazamiziba kamaghɨn oraki, Iesus roghɨra iza Jerusalemɨn otivasa. ");
INSERT INTO msy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ezɨ me uan agharibar okavir aghuabar suigha ghua tuavimɨn Iesus bativasa, egha me kamaghɨn dei, “Godɨn ziam fɨ! Gumazir Ekiamɨn ziamɨn izir kam, God deravɨra a damu. A Israelbar Atrivim!” ");
INSERT INTO msy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Egha Iesus donkin mam inigha egha a gaperagha zui. Godɨn Akɨnafarim bizir kamɨn gun mɨgei, ");
INSERT INTO msy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ia Saionɨn nguibamɨn gumazamiziba, ia atiatingan markɨ. Ia gan. Ian Atrivim a izi. A donkin igiam gaperagha izi.” ");
INSERT INTO msy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","An suren gumaziba, me dughiar kam akar kamɨn mɨngarim gɨfozir puvatɨ. Egha gɨn God ziar ekiam isa Iesus ganigha gɨvazɨma, ezɨ me akar Godɨn Akɨnafarimɨn itim ginɨrɨgha egha me fo, a Iesusra mɨgei. Egha me ua bizir gumaziba Iesus gamizim gɨnɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lasarus aremegha egha mozimɨn itir dughiam, gumazamizir avɨrim Iesus ko ikia egha Iesusɨn garima, a Lasarus mozimɨn an diagha a gamizɨma a ua dɨkafi. Ezɨ datɨrɨghɨn gumazamizir kaba, Iesus amizir bizir kamɨn gun mɨgɨavɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ezɨ gumazamiziba orazima a mirakelɨn kam gami, ezɨ kamaghɨn me ghua tuavimɨn a bato. ");
INSERT INTO msy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ezɨ Farisiba ganigha, egha me uarir tongɨn kamaghɨn uariv gei, “Ia an gan! Bizir e damuamin kam, a datɨrɨghɨn otoghan kogham. Gumazamiziba bar ghua an gɨn zui.” ");
INSERT INTO msy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ezɨ dughiar kamɨn, gumazamiziba isar ekiamɨn Godɨn ziam fasa Jerusalemɨn ghuavanabo, ezɨ men tongɨn, Grighɨn marazi uaghan iti. ");
INSERT INTO msy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Egha Grighɨn gumazir kaba Filip bagha ize. (Filip a Betsaidan nguibamɨn gumazim, a Galilin Distrighɨn iti.) Egha me kamaghɨn a mɨgei, “Gumazir ekiam, e Iesusɨn ganasa ifonge.” ");
INSERT INTO msy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ezɨ Filip ghua Andru mɨkeme. Egha Andru, Filip ko aning ghua Iesus mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ezɨ Iesus kamaghɨn aningɨn akam ikara, “Dughiar Gumaziba Otarim ziar ekiam iniamim, an otogha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kɨ guizbangɨra ia mɨgei, witɨn ovɨzitam nguazim girɨgh egh aremeghan koghɨva, a uabɨra ikiam. Egh an aremegh, a uam aghungɨva egh witɨn ovɨzir avɨriba mɨsɨvam. ");
INSERT INTO msy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Gumazir uabɨra uan mɨkarzim gifongezim, an aremegham. Ezɨ gumazir nguazir kamɨn ikia uabɨ uan mɨkarzim aghuazim, an angamra itir ikɨrɨmɨrimɨn suiragh mangɨ zurara ikɨvɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ezɨ gumazir nan ingangarim damuasa ifongezim, a nan gɨn izɨ. Egh nguibar kɨ itim, nan ingangarir gumazim uaghan na ko ikiam. Ezɨ gumazir nan ingangarim gamim, Afeziam ziar ekiam a danɨngam.” ");
INSERT INTO msy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ezɨ Iesus ua kamaghɨn mɨgei, “Datɨrɨghɨn nan navim bar osemegha nɨghnɨzir avɨriba iti. Egha kɨ manmagh mɨkɨmam? Kɨ ti kamagh mɨkɨmam, ‘Afeziam, nɨ bizir na bativamim batokegh?’ Puvatɨ. Kɨ kamaghɨn mɨkɨman kogham. Osɨmtɨzir dughiar kamɨn otivim, a na bativam. Bizir kam bagha kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Afeziam nɨ uan ziam damutɨ, an ekefegh!” Iesus mɨkemegha gɨvazɨma, ezɨ tiarir mam Godɨn Nguibamɨn zaghira ghaze, “Kɨ uan ziam gamizɨma an ekevegha gɨfa, eghtɨ kɨ ua kamaghɨn damuam.” ");
INSERT INTO msy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ezɨ gumazamizir roghɨra tughav itiba, me tiarir kam baraki, egha me kamaghɨn mɨgei, “Ararim dagara!” Ezɨ marazi ghaze, “Enselɨn mam a mɨgei!” ");
INSERT INTO msy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ezɨ Iesus kamaghɨn akam ikara, “Akar ia datɨrɨghɨn oraghazir kam, a nan akurvaghasa izezir puvatɨ. A ian akurvaghasa ize. ");
INSERT INTO msy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Datɨrɨghɨn God nguazir kamɨn gumazamizibar araziba tuisɨgham. Egh nguazir kam gativazir gumazir dapanim Satan a batuegham. ");
INSERT INTO msy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Datɨrɨghɨn kɨ nguazimɨn iti, ezɨ gɨn me na fegh ter ighuvimɨn na aguragham, eghtɨ dughiar kamɨn kɨ gumazamiziba bar me damutɨ me na bagh izam.” ");
INSERT INTO msy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Iesus mɨgɨrɨgɨar kam gamua egha arazir an ovengamimɨn gun mɨgei.) ");
INSERT INTO msy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ezɨ gumazamiziba kamaghɨn an akam ikara, “E kamaghɨn Moses Osirizir Arazibar akam baraki, God Uam E Iniasa Mɨsevezir Gumazim otogh, egh a ikɨ mamaghɨra ikiam. Egha manmagh sua nɨ ghaze, ‘Me Gumazibar Otarim fegh ter ighuvimɨn aneguragham?’ Gumazibar Otarir kam, a bar tinara?” ");
INSERT INTO msy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ezɨ Iesus kamaghɨn me mɨgei, “Dughiar ovezimɨn angazangarim ian tongɨn ikiam. Datɨrɨghɨn angazangarim ian ikiavɨra iti, ezɨ ia angazangarimɨn aven daru. Puvatɨghtɨ, mɨtatem ia avaragham. E fo, gumazim mɨtatemɨn arui, a fozir puvatɨ, a managh zui. ");
INSERT INTO msy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Angazangarim datɨrɨghɨn ia ko ikiavɨra iti, eghtɨ ia nɨghnɨzir gavgavim angazangarimɨn ikɨ. Kamaghɨn ia angazangarimɨn gumazamizibar mɨn otivigham.” Iesus gumazamiziba ko mɨkemegha gɨvagha, egha me ategha ghua men modo. ");
INSERT INTO msy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Me an garima a mirakelɨn avɨrim gami. Ezɨ me nɨghnɨzir gavgavim an itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","God kamagh sua, an akam inigha izir gumazim Aisaian akam guizbangɨra otogham. Aisaia kamaghɨn mɨkeme, “Ekiam, tina en akam nɨghnɨzir gavgavim an iti? Egha tina Ekiamɨn garima, a uan gavgavim an aka?” ");
INSERT INTO msy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kamaghɨn amizɨ me nɨghnɨzir gavgavim Iesusɨn ikian aghua. Ezɨ bizir kamɨn mɨngarim, Aisaia uaghan akar igharazim an osiri. A kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“God kamagh sua, me bizitamɨn ganan koghɨva, egh me naviba akamɨn mɨngarim gɨfoghan kogham. Egh me navibagh iragh egh ua na bagh izɨtɨ, kɨ me damightɨ me ua deraghan kogham. Kamaghɨn God men damazibagh amizɨ da okafi, ezɨ me gari puvatɨ. Egha men nɨghnɨzibagh amizɨ me ongani.” ");
INSERT INTO msy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia Iesusɨn angazangarim ko gavgavimɨn ganigha, kamaghɨn an an gurara mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Guizbangɨra, gumazir dapanir avɨrim uaghan nɨghnɨzir gavgavim Iesusɨn iti. Egha me Farisibar atiatigha, egha uan nɨghnɨzir gavgavimɨn gun mɨgeir puvatɨ. Me atiatigha ghaze, Farisiba men anogoreghtɨ me ua God ko mɨgeir dɨpenimɨn aven ikian kogham. ");
INSERT INTO msy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gumaziba men ziaba fasa me bar ifonge, egha God men ziaba fasa me ifongezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ezɨ Iesus kamaghɨn diagha ghaze, “Gumazir nɨghnɨzir gavgavim nan itim, a nɨghnɨzir gavgavim narara itir puvatɨ. A nɨghnɨzir gavgavim Afeziar na amadazɨ kɨ izezim uaghan an iti. ");
INSERT INTO msy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ezɨ gumazir nan garim, a uaghan Afeziar na amadazɨ kɨ izezimɨn gari. ");
INSERT INTO msy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kɨ kamagh sua, gumazir nɨghnɨzir gavgavim nan itiba, me bar mɨtatemɨn ikian kogham. Bizir kam bagha kɨ angazangarimɨn mɨn nguazir kamɨn ize. ");
INSERT INTO msy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Gumazitam nan akam baregha egha nan gɨn zuir puvatɨ, kɨ jasɨn mɨn a tuisɨghan kogham. Kɨ nguazimɨn gumazamizibar jasɨn ikiasa izezir puvatɨ. Kɨ men akurvaghasa ize. ");
INSERT INTO msy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ezɨ gumazim akɨrim na gasara egha nan akam inizir puvatɨ, a kot iti, eghtɨ jas a tuisɨgham. Akar kɨ mɨkemezim, a nguazim gɨvaghamin dughiamɨn an an araziba tuisɨgham. ");
INSERT INTO msy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kɨ uabɨ uan nɨghnɨzimɨn mɨgeir puvatɨ. Afeziam na amadazɨ kɨ ize. A uabɨ akaba bar na mɨkeme, ezɨ kɨ dar gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ezɨ kɨ fo, Afeziamɨn akam a gumazamizibagh amima, eghtɨ gɨn me zurara itir ikɨrɨmɨrir aghuarim iniam. Kamaghɨn ami, akar kɨ mɨkemezir kaba bar, kɨ Afeziam na mɨkemezɨ moghɨn kɨ dagh ami.” ");
INSERT INTO msy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Dughiar kam, God Israelbagh Itazir Dughiam a gurumɨzaraghan otivam. Ezɨ Iesus fo, a mangamin dughiam otozɨ, a nguazir kam ategh uan Afeziam bagh mangasava ami. A uan gumazamizir nguazir kamɨn itiba a fomɨra bar me gifonge, egha me gɨfueghavɨra ikia ghua an areme. ");
INSERT INTO msy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ezɨ guaratɨzir kamɨn me apa iti. Satan faragha nɨghnɨzir Iesus isɨ apanibar agharim darɨghamim isa Judasɨn navim gatɨgha gɨfa. Judas, a Saimon Iskariotɨn otarim. ");
INSERT INTO msy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iesus kamaghɨn fo, Afeziam bizibar amuamin gavgavim bar a isa a ganɨngi. A uaghan kamaghɨn fo, God anemadazɨ a ize, egh a ua God bagh mangam. ");
INSERT INTO msy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kamaghɨn amizɨma Iesus dagher dakozim ategha dɨkafi, egha uan korotiar ruarim suegha, egha taulɨn mam inigha uan ivariam ike. ");
INSERT INTO msy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Egha dɨpam itarir mam ginge, egha maghɨra uan suren gumazibar dagariba ruegha, egha taulɨn a uan ivariam amɨghɨrizimɨn da adɨsi. ");
INSERT INTO msy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Egha a Saimon Pita bagha ize. Ezɨ Pita an azara, “Ekiam, nɨrara nan dagariba ruam?” ");
INSERT INTO msy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ezɨ Iesus kamaghɨn an akam ikara, “Bizir kɨ amim, nɨ datɨrɨghɨn a gɨfozir puvatɨ. Egh nɨ gɨn a gɨfogham.” ");
INSERT INTO msy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ezɨ Pita a mɨgei, “Nɨ nan dagariba ruan markɨ. Bar markɨ!” Ezɨ Iesus kamaghɨn akam ikara, “Kɨ nɨn dagariba rueghan koghtɨma, eghtɨ nɨ na ko ikian kogham.” ");
INSERT INTO msy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ezɨ Saimon Pita a mɨgei, “Ekiam, nɨ kamaghɨn nan dagaribara ruan markɨ. Nɨ nan dagariba ko dafariba ko dapanim sara, bar da ruam!” ");
INSERT INTO msy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ezɨ Iesus a mɨgei, “Gumazir ruegha gɨvazim, a zue, a ua ruan markɨ. A pura dagaribara ruegh egh bar zuegham. Ezɨ ia bar moghɨra zuegha gɨvagha iti. Ezɨ ian gumazir vamɨra, a zuezir pu.” ");
INSERT INTO msy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Iesus gumazir a isɨ apanibar agharim darɨghamim, an a gɨfogha gɨfa. Kamaghɨn a ghaze, “Ia bar moghɨra zuezɨ, ezɨ ian vavɨra zuezir puvatɨ.”) ");
INSERT INTO msy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iesus men dagariba ruegha gɨvagha, egha uan korotiar ruarim uam anerugha egha ua ghua uan dapiamin danganim gapera. Egha kamaghɨn men azai, “Ia, kɨ ia bagha amizir bizir kamɨn mɨngarim gɨfo, o? ");
INSERT INTO msy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ia ‘Tisa’ na garɨgha egha ‘Ekiam’ na garɨsi. Guizbangɨra, kɨ Tisa egha kɨ ian Ekiam. Egha bar deragha ia kamaghɨn mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kɨ, ian Ekiam ko ian Tisa, egha kɨ ian dagariba rues. Ezɨ ia uaghan uarira uarir dagariba ruegh. ");
INSERT INTO msy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kɨ arazim ian akazɨ, ezɨ ia uaghan arazir kɨ datɨrɨghɨn ia gamizir kamra damu. ");
INSERT INTO msy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kɨ guizbangɨra ia mɨgei, ingangarir gumazir kɨnitam uan Ekiam gafirazir puvatɨ. Ezɨ akam inigha izir gumazitam, a gumazir anemadazir a ghuzim gafirazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ezɨ datɨrɨghɨn ia arazir kɨ amizir kamɨn mɨngarim gɨfogha gɨfa, kamaghɨn ia deraghvɨra an gɨn mangɨva, egh ia bar akuegham. ");
INSERT INTO msy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kɨ bar ia mɨgeir puvatɨ. Kɨ gumazir kɨ ua bagha mɨsevezibagh fo. Egha kɨ kamaghɨn fo, akar Godɨn Akɨnafarimɨn itim, a guizbangɨram otivam. Akar kam kamakɨn ‘Gumazir na ko dagheba apim, nan apanimɨn oto.’ ");
INSERT INTO msy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Bizir kam tɨghar otivam, ezɨ kɨ datɨrɨghɨn ia mɨkemegha gɨfa. Eghtɨ kamaghɨn a gɨn otoghamin dughiam, ia kamaghɨn nɨghnɨzir gavgavim ikɨ fogh, Kɨ Uabɨ Kɨ Kamaghɨn Iti. ");
INSERT INTO msy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kɨ guizbangɨra ia mɨgei, gumazir manam ingangarir gumazir kɨ amadazim inigh, egha deravɨra a gami, gumazir kam na inigha egha deravɨra na gami. Egha gumazir na inizim, a Godɨn na amadazɨ kɨ izezim a ini.” ");
INSERT INTO msy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iesus mɨkemegha gɨfa, ezɨ an navim bar a baseme. Egha bighavɨra kamaghɨn mɨgei, “Kɨ guizbangɨra ia mɨgei, ian tav na isɨva gumazir nan apanim gamibar agharim darɨgham.” ");
INSERT INTO msy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A kamaghɨn mɨkemezɨ, an suren gumaziba vaghvagha uari uarir gari. Me fozir puvatɨ, Iesus tina mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Egha suren gumazibar mav, gumazir Iesus bar ifongezim, a bar Iesusɨn boroghɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ezɨ Saimon Pita benim akuigha egha a mɨgei, “Nɨ an azaragh, a tina mɨgei?” ");
INSERT INTO msy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ezɨ suren gumazir kam uan dapanim isa Iesusɨn afarɨzim boroghɨram atɨgha, egha kamaghɨn an azara, “Ekiam, nɨ tina mɨgei?” ");
INSERT INTO msy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ dagher otevir kam inigh egh dɨparsɨzim darugh, egh gumazitam danɨngam. A gumazir kamra, kɨ a mɨgei.” Egha a dagher otevim isa dɨparsɨzim garu, egha Judas ganɨngi, a Saimon Iskariotɨn otarim. ");
INSERT INTO msy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ezɨ Judas dagher kam inigha gɨvazɨma, ezɨ dughiar kamra Satan an navir averiamɨn aven ghua a gapasa. Ezɨ Iesus kamaghɨn a mɨgei, “Bizir nɨ damuasa ifongezim, nɨ zuamɨra a damigh!” ");
INSERT INTO msy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gumazir dakozimɨn apiaghav itiba, me bar akar Iesus Judasɨn mɨkemezir kam baregha, egha me akamɨn mɨngarim gɨfozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas dagɨabar mɨtarimɨn gari. Ezɨ marazi ghaze, Iesus ti isar ekiam bagha bizibagh ivezasa a mɨkeme, o a mangɨ biziba gumazir onganarazibar anɨngam. ");
INSERT INTO msy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ezɨ Judas dagher otevir kam inigha gɨvagha, egha zuamɨra azenan ghu. Ezɨ amɨnim pɨrizɨ mɨtatem otogha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas azenan ghugha gɨvazɨma, ezɨ Iesus mɨgei, “Datɨrɨghɨn Gumazibar Otarimɨn ziar ekiam azenan oto. Ezɨ God uan Otarim isa gumazamizibar akazɨ Otarim me damutɨ me fogham, God ziar bar ekiam iti. ");
INSERT INTO msy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Eghtɨ God uabɨ uan Otarim isɨ gumazamizibar akaghtɨ me fogham, Gumazibar Otarim ziar ekiam iti. Egh God zuamɨra a damigham. ");
INSERT INTO msy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nan boriba, dughiar otevimra kɨ ia ko ikiam. Eghtɨ ia na buriam. Kɨ Judabav mɨkemezɨ moghɨn, akar kamra kɨ ua ia mɨgei, ia danganir kɨ mangamim, ia an mangan kogham. ");
INSERT INTO msy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ezɨ datɨrɨghɨn kɨ arazir igiam ia ganɨdi, a kamakɨn, ia uari uarigh ifongegh. Kɨ bar ia gifonge, ezɨ kamaghɨra ia uari uarigh ifongegh. ");
INSERT INTO msy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ia uari uarigh ifongeghtɨ, gumaziba bar arazir kamɨn ganigh fogh suam, ia nan suren gumaziba.” ");
INSERT INTO msy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ezɨ Saimon Pita kamaghɨn Iesusɨn azara, “Ekiam, nɨ managh mangam?” Ezɨ Iesus kamaghɨn an akam ikara, “Nguibar kɨ mangamim, nɨ datɨrɨghɨn nan gɨn an mangɨghan kogham. Egh nɨ gɨn nan gɨn izam.” ");
INSERT INTO msy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ezɨ Pita an azara, “Ekiam, manmagh amizɨma kɨ datɨrɨghɨn nɨn gɨn mangɨghan kogham? Kɨ nɨ bagh aremeghasa ifonge.” ");
INSERT INTO msy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ezɨ Iesus kamaghɨn an akam ikara, “Nɨ ghaze, nɨ ti na bagh aremegham? Kɨ guizbangɨra nɨ mɨgei, tuarim tɨghar akegham, eghtɨ nɨ dughiar pumuningɨn ko mɨkezimɨn kamaghɨn mɨkɨmam, nɨ na gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ezɨ Iesus ua kamaghɨn uan suren gumazibav gei, “Ia nɨghnɨzir avɨribar amuva osɨman markɨ. Ia nɨghnɨzir gavgavim Godɨn ikɨva, egh uaghan nɨghnɨzir gavgavim nan ikɨ. ");
INSERT INTO msy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nan Afeziamɨn dɨpenimɨn danganir avɨriba iti, ezɨ kɨ mangɨva ia bagh danganibar kɨram. Bizir kam guizbangɨra puvatɨzɨ, ezɨ kɨ ia mɨkemeghan koghai. ");
INSERT INTO msy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kɨ mangɨva ia bagh danganim akɨrighɨva, egh ua izɨ ia inigh mangɨtɨ ia na ko ikiam. Egh nguibar kɨ ikiamim, ia uaghan na ko an ikiam. ");
INSERT INTO msy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ezɨ ia nguibar kɨ zuim, ia an tuavim gɨfogha gɨfa.” ");
INSERT INTO msy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ezɨ Tomas a mɨgei, “Ekiam, e fozir pu, nɨ managh zui, kamaghɨn e manmaghɨn tuavir nɨ zuim gɨfogham?” ");
INSERT INTO msy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ uabɨ kɨ tuavim, egha kɨ guizɨn akamɨn mɨngarim, egha kɨ ikɨrɨmɨrir aghuimɨn mɨngarim. Ezɨ gumazitam tuavir igharazimɨn Afeziam bagh mangɨgham kogham. Puvatɨ. Kɨrara kɨ Afeziam bagha zuir tuavim. ");
INSERT INTO msy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eghtɨ ia na gɨfoghɨva, egh uaghan nan Afeziam gɨfogham. Ezɨ datɨrɨghɨn tugha ghua, ia nan Afeziam gɨfofogha, egha an gari.” ");
INSERT INTO msy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ezɨ Filip ghaze, “Ekiam, nɨ Afeziam en akagh, eghtɨ e uan damazibar an ganika, eghtɨ e ua nɨn azangan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ezɨ Iesus a mɨgei, “Filip, dughiar ruarimɨn kɨ ia ko iti, ezɨ ia ti na gɨfozir puvatɨ? Gumazim nan gari, an Afeziamɨn gari. Ezɨ manmagh sua nɨ ghaze, ‘Nɨ Afeziam en akagh’? ");
INSERT INTO msy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, nɨ ti nɨghnɨzir gavgavim ikɨ fogh suam, kɨ Afeziamɨn aven itima Afeziam nan aven iti? Akar kɨ ia mɨgeiba, kɨ uan nɨghnɨzimɨn dav geir puvatɨ. Afeziar nan aven itim, a uabɨ uan ingangarim gami. ");
INSERT INTO msy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ia nɨghnɨzir gavgavim akar kamɨn ikɨ, kɨ Afeziamɨn aven iti, ezɨ Afeziam nan aven iti. Puvatɨghtɨ, ia nan ingangarir kɨ amibagh nɨghnɨgh, eghtɨ ingangarir kaba ian nɨghnɨzir gavgavibar amutɨ da gavgavigham. ");
INSERT INTO msy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kɨ bar guizbangɨra ia mɨgei, gumazir nɨghnɨzir gavgavim nan itim, a uaghan kɨ amir ingangarir kabar amuam. Kɨ uan Afeziam bagh mangam, kamaghɨn amizɨ, ingangarir ekiar gumazir kam damuamiba, da ingangarir kɨ amibagh afiragham. ");
INSERT INTO msy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Kɨ kamagh sua, Afeziam ziar ekiam uan Otarimɨn ingangarimɨn a iniam. Kamaghɨn ia nan ziamɨn biziba bagha azaraghtɨ, kɨ dar amuam. ");
INSERT INTO msy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ia nan ziamɨn bizitam bagh nan azangsɨghtɨ, kɨ a damuam.” ");
INSERT INTO msy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Egha Iesus ua kamaghɨn mɨgei, “Ia bar na gifueghɨva, egh ia deravɨra nan akaba baragh dar gɨn mangam. ");
INSERT INTO msy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Eghtɨ kɨ Afeziamɨn azangsɨghtɨ, a gavgavim ia danɨngamin Akurvazir mam ia bagh anemangam. Eghtɨ a ia ko ikɨ mamaghɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ezɨ Akurvazir kam a Godɨn Duam, a guizɨn akam mɨgeir Duam. Ezɨ nguazir kamɨn gumazamiziba me an ganighan koghɨva, egh a gɨfoghan kogham, kamaghɨn me a inighan kogham. Ezɨ iarara, a ia ko iti, egh a ian navir averiabar aven ikiam. Kamaghɨn ia a gɨfo. ");
INSERT INTO msy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kɨ ia ateghtɨ ia uarira ikian kogham, mati borim amebam ko afeziam puvatɨzɨ moghɨn. Puvatɨ. Kɨ ua ia bagh izam. ");
INSERT INTO msy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Dughiar ovezimɨn nguazimɨn gumazamiziba ua nan ganan kogham. Eghtɨ ia nan ganam. Kɨ angamra iti, eghtɨ kamaghɨn ia uaghan angamra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ezɨ dughiar kamɨn ia kamaghɨn fogham, kɨ uan Afeziamɨn aven iti, ezɨ ia nan aven iti, mati kɨ ian aven iti moghɨn. ");
INSERT INTO msy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ezɨ tina nan akam baragha egha an gɨn zui, gumazir kam a bar na gifonge. Egha gumazir na gifongezim, nan Afeziam a gifuegham. Eghtɨ kɨ uaghan a gɨfuegham, egh kɨ uabɨ isɨva an akagham.” ");
INSERT INTO msy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iesus kamaghɨn mɨkeme, ezɨ Judasɨn igharazim (a Judas Iskariot puvatɨ) a kamaghɨn Iesusɨn azara, “Ekiam, manmagh su nɨ uabɨ isɨva en akaghasa, egha nɨ uabɨ isɨva nguazimɨn gumazamizibar akaghan aghua?” ");
INSERT INTO msy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ezɨ Iesus kamaghɨn an akam ikara, “Gumazitam na gifueghɨva, egh deraghvɨra nan akamɨn gɨn mangam. Eghtɨ nan Afeziam bar gumazir kam gifuegham. Eghtɨ ga izɨva a ko ikɨ mamaghɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gumazim na gifongezir puvatɨ, a deravɨra nan akamɨn gɨn zuir puvatɨ. Ezɨ akar ia oraghizir kam, ka nan akam puvatɨ. Kar Afeziamɨn akam, a na amadazɨ ezɨ kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Dughiar kɨ ia ko ikiavɨra itim, kɨ bizir kabar gun ia mɨkeme. ");
INSERT INTO msy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ezɨ Gavgavim ia Danɨngamin Akurvazir Gumazim, a Godɨn Duam. Ezɨ nan ziamɨn, Afeziam anemadaghtɨ a izam. A biziba bar ian sure damuam. Eghtɨ akar kɨ ia mɨkemeziba, a ian sure damutɨ ia uam a dagh nɨghnɨgham. ");
INSERT INTO msy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Kɨ ia ataghraghasa, egha kɨ navir amɨrɨzim ia ganɨdi. Ezɨ nan navir amɨrɨzir kɨ ia ganɨdim, a nguazimɨn gumaziba anɨdi moghɨn puvatɨ. Kamaghɨn amizɨma, ia nɨghnɨzir avɨribar amuva egh osɨman markɨ, egh atiatingan markɨ. ");
INSERT INTO msy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ezɨ ia akar kɨ ia ganɨngizir kam baregha gɨfa, ‘Kɨ ia ategha egha kɨ zui, egh kɨ ua ia bagh izam.’ Egh ia bar na gifueghtɨ, eghtɨ akar kam ia damutɨ ia bar akuegham. Afeziamɨn gavgavim bar ekevegha egha nan gavgavim gafira, kamaghɨn, kɨ uan Afeziam bagha zui. ");
INSERT INTO msy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kɨ kamagh sua, bizir kam gɨn otoghtɨ, eghtɨ ia an ganigh nɨghnɨzir gavgavim nan ikɨ. Kamaghɨn kɨ datɨrɨghɨn bizir kam tɨghar otivamin dughiamɨn, kɨ an gun ia mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Nguazir kam gativazir gumazir dapanim, a na gativamin gavgaviba puvatɨ. Egha a datɨrɨghɨn izi. Kamaghɨn amizɨ, kɨ ua mɨgɨrɨgɨar avɨriba ia mɨkɨman kogham. ");
INSERT INTO msy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kɨ kamagh sua, nguazimɨn gumazamiziba kamaghɨn fogh, kɨ bar Afeziam gifonge, egha kɨ bizir Afeziam na mɨkemezibara dagh ami. Ia dɨkavigh, danganir kam ategh, e mangam.” ");
INSERT INTO msy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ezɨ Iesus ua kamaghɨn mɨgei, “Kɨ uabɨ kɨ guizbangɨra wainɨn ikarzimɨn mɨn iti. Ezɨ nan Afeziam a wainɨn azenimɨn ghuavim. ");
INSERT INTO msy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ezɨ nan agharir ber puvatɨziba, Afeziam vaghavagha dar ghora da makuri. Egha agharir ovɨziba itiba, Afeziam vaghavagha a dar ghora da otefi. A ghaze, da zuegh ikɨva, egh gɨn da bɨva ovɨzir avɨriba ikiam, kamaghɨn a dar ghori. ");
INSERT INTO msy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ia zuegha gɨfa. Akar kam kɨ ia ganɨdi, a ia gamima ia zue. ");
INSERT INTO msy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ia nan porogh, eghtɨ kɨ ian porogham. Ezɨ wainɨn ikarzimɨn agharim, a ikarzimɨn poroghan koghɨva, egh a ban kogham. Kamaghɨra, ia nan poroghan kogh, ia uaghan ban kogham. ");
INSERT INTO msy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Kɨ uabɨ kɨ wainɨn ikarzim, ezɨ ia wainɨn aghariba. Ezɨ gumazim nan porozɨ, ezɨ kɨ an poro, a zurara bava ovɨzir avɨriba iti. Ezɨ ia na ategh, ia bizir tam damighan kogham. ");
INSERT INTO msy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Eghtɨ gumazitam nan poroghan kogh, egh a mati wainɨn ikarzimɨn agharim me a makunizɨ a mɨsɨngi. Egha me agharir kaba akuva da isava avim mɨkɨra egha dagh aboi. ");
INSERT INTO msy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Ia nan porogh ikɨtɨ, nan akam ian aven ikiam, eghtɨ ia uan ifongiamɨn bizitam bagh azangam, eghtɨ biziba ia mɨkemezɨ moghɨn otivam. ");
INSERT INTO msy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Egh ia bɨva ovɨzir avɨriba ikɨ, egh kamaghɨn ia nan suren gumazibar mɨn ikiam. Eghtɨ tuavir kamɨn nan Afeziam ziar ekiam iniam. ");
INSERT INTO msy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Afeziam bar na gifonge, ezɨ arazir kamra kɨ ia gifonge. Egh ia nan poroghtɨ kɨ ia gifuegh mamaghɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kɨ uan Afeziamɨn araziba ko akabar gɨn zui, egha an porozɨ a na gifongezɨ moghɨn, ia uaghan nan araziba ko akabar gɨn mangɨva egh nan poroghtɨ kɨ ia gifuegh mamaghɨra ikiam. ");
INSERT INTO msy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nan navir agorogem ian ikiasa kɨ ifonge. Ezɨ agoroger kam bar ian navir averiabagh izɨvagham. Kamaghɨn amizɨ kɨ mɨgɨrɨgɨar kam ia mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kɨ ia mɨkemezir arazimra kara: kɨ bar ia gifongezɨ moghɨn, arazir kamra ia uari uarigh ifongegh. ");
INSERT INTO msy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gumazitam uan namakam a gifuegh egh a bagh aremegham, ezɨ an arazir uarira uari ifongezim, a gumazamizir igharazibagh ifongezir araziba bar dagh afira. ");
INSERT INTO msy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ezɨ kɨ ia mɨkemezɨ moghɨn ia ami, egha ia nan namakabar iti. ");
INSERT INTO msy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","E fo, ingangarir gumazim bizir an gumazir ekiam amiba, a dagh fozir puvatɨ. Kamaghɨn amizɨ kɨ ua ‘ingangarir gumaziba’ ia dɨborir puvatɨ. Akaba bar kɨ uan Afeziam da, da baregha egha kɨ ia mɨkemegha gɨfa. Kamaghɨn amizɨ, kɨ ‘namakaba’ ia garɨsi. ");
INSERT INTO msy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Ia uari ko ikiasa na mɨsevezir pu. Puvatɨ. Ia nan adarazir ikiasa kɨ ia mɨsefe. Ezɨ kɨ ingangarim ia ganɨdi, eghtɨ ia mangɨva egh bɨva dagher avɨriba ikɨ, eghtɨ ian dagheba ikɨvɨra ikiam. Kamaghɨn ia bizitam uari danɨngsɨ nan ziamɨn Afeziamɨn azaraghtɨ, a ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Kar nan arazim, kɨ ia ganɨdi: Ia uari uarigh ifongegh.” ");
INSERT INTO msy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Egha Iesus ua kamaghɨn mɨgei, “Nguazimɨn gumaziba ian apanim damutɨ, eghtɨ ia okɨnɨghnɨghan markɨ, me faragha uaghan nan apanimɨn ike. ");
INSERT INTO msy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ezɨ ia nguazir kamɨn gumazibar mɨn ikezɨ, nguazimɨn gumaziba uan adarazigh ifongezɨ moghɨn, me ia gifueghai. Ezɨ ia nguazir kamɨn gumaziba puvatɨ. Kɨ ia mɨsevegha gɨfa, ezɨ ia nguazir kamɨn araziba ategham. Kamaghɨn amizɨma nguazimɨn gumazamiziba ian aghuagha ian apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ia akar kɨ ia mɨkemeziba deraghvɨra da gɨnɨghnɨgh, ingangarir gumazim uan gumazir ekiam gafirazir puvatɨ. Kamaghɨra me paza na gami, eghtɨ me uaghan pazɨ ia damuam. Egh me na akam baragham, egh me uaghan ian akam baragham. ");
INSERT INTO msy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Egha me Afeziam gɨfozir puvatɨ, a na amadazɨ kɨ izes. Ezɨ ia nan adarasi, kamaghɨn, me arazir kurar kaba bar dar ia damuam. ");
INSERT INTO msy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ezɨ kɨ ti izeghan kogha egha akam me ganizir puvatɨzɨ, me arazir kurabar osɨmtɨziba puvatɨghai. Ezɨ datɨrɨghɨn me uan arazir kurabar mongan tuaviba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ezɨ gumazitam nan aghuagha nan apanim gami, a uaghan nan Afeziamɨn aghuagha an apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kɨ men tongɨn ikia mirakelbagh ami, da gumazir igharazi tam faragha amizir puvatɨzir ingangariba. Ezɨ kɨ men tongɨn mirakelɨn kabagh amizir puvatɨzɨ, me arazir kurabar osɨmtɨziba puvatɨghai. Ezɨ datɨrɨghɨn me mirakelɨn kɨ amizibar ganigha gɨfa, egha me na ko Afeziam sara, gan aghuagha gan apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Osizirir mam, Judan Arazibar aven iti, a kamaghɨn mɨgei, ‘Gumaziba pura nan apanim gami.’ Ezɨ akar kam guizbangɨra otivasa, kamaghɨn me nan apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Godɨn Duar Gavgavim ia Danɨngamim, a izam. An Afeziam ko iti, ezɨ kɨ ia bagh anemangam. A guizbangɨra mɨgeir Duam, egha an Afeziam ko ikegh izam. Egh a izɨva deravɨra nan araziba ko ingangaribar gun mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Kɨ faragh ingangarim gamima, ia na ko ikia iza datɨrɨghɨn. Kamaghɨn, ia uaghan nan gun mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ezɨ kɨ kamagh sua, ia uan nɨghnɨzir gavgavim ataghraghan markɨ, kamaghɨn kɨ bizir kam ia mɨkeme. ");
INSERT INTO msy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Me ian anogoreghtɨ ia ua God ko mɨgeir dɨpenibar aven ikian kogham. Eghtɨ gɨn dughiam otogham, gumaziba ia mɨsueghtɨ ia aremegham, egh me suam, me Godɨn ingangarir aghuim gami. ");
INSERT INTO msy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Egha me Afeziam gɨfozir puvatɨ, egha na gɨfozir puvatɨ. Kamaghɨn me arazir kabar amuam. ");
INSERT INTO msy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kɨ kamagh sua, gumaziba gɨn arazir kabar ia damutɨ, eghtɨ ia akar kɨ ia mɨkemezir kam gɨnɨghnɨgham. Kamaghɨn, kɨ datɨrɨghɨn bizir otivamin kaba, dar gun ia mɨkemegha gɨfa.” Egha Iesus kamaghɨn mɨgei, “Kɨ faragha uabɨ ia ko iti, kamaghɨn kɨ bizir kabar gun ia mɨkemezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Egha datɨrɨghɨn Afeziar na amadazɨ ezɨ kɨ izezim, kɨ a bagha zui. Ezɨ ian tav nan azarazir puvatɨ, ‘Nɨ managh zui?’ ");
INSERT INTO msy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kɨ akar kam ia mɨkeme, ezɨ datɨrɨghɨn ian naviba bar oseme. ");
INSERT INTO msy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ezɨ kɨ guizbangɨra ia mɨgei, kɨ ia ategha zui, kar ian akurvaghamim. Kɨ fo, kɨ mangɨghan koghtɨ, Godɨn Duar Gavgavim ia Danɨngamim, a ia bagh izeghan kogham. Egh kɨ mangɨghɨva, kɨ ia bagh anemadagham. ");
INSERT INTO msy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Eghtɨ a izɨva nguazir kamɨn gumazibar amutɨ me arazir kuramɨn mɨngarim ko arazir aghuimɨn mɨngarim ko Godɨn kotiamɨn mɨngarim, me dagh fogham ");
INSERT INTO msy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Arazir kuramɨn mɨngarim, a kamakɨn, me nɨghnɨzir gavgavim na itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Arazir aghuimɨn mɨngarim, a kamakɨn, kɨ Afeziam bagh mangɨghtɨ, ia ua nan ganighan kogham. ");
INSERT INTO msy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Godɨn kotiamɨn mɨngarim, a kamakɨn, nguazir kam gativazir gumazir dapanim, God kotiamɨn aven a tuisɨgha gɨfa egha ghaze, a ivezir kuram inigh aremegham. ");
INSERT INTO msy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Kɨ ia mɨkɨmamin akar avɨriba iti, ezɨ datɨrɨghɨn ian nɨghnɨziba bar izɨfa, eghtɨ ia bar da bareghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ezɨ Godɨn Duam, a guizɨn akam mɨgeir Duam, a izɨva, ian nɨghnɨzibar amutɨ ia guizɨn akaba bar dagh fogham. A uabɨ uan nɨghnɨzimɨn akatam mɨkemeghan kogham. Puvatɨ. Akar an oraghizim, akar kamra an an gun mɨkɨmam. Egh a bizir gɨn otivamibar gun ia mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A nan akam inighɨva egh an gun ia mɨkɨmam. Egh arazir kamɨn a nan ziar ekiam ko nan gavgavim, ian akagham. ");
INSERT INTO msy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Afeziamɨn biziba da bar nan biziba. Kamaghɨn amizɨ kɨ kamaghɨn ia mɨkeme, an Duam nan akam inighɨva egh an gun ia mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Egha Iesus ua kamaghɨn mɨgei, “Dughiar bar ovezimɨn ia ua nan ganighan kogham. Egh dughiar bar otevimɨn gɨn ia ua nan apigham.” ");
INSERT INTO msy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ezɨ suren gumazir maba uarira uarir tongɨn uariv gei, “Kar akar manamɨn mɨngarim an a gami? A ghaze, ‘Dughiar bar ovezimɨn ia nan ganighan kogham. Egh ua dughiar otevimɨn gɨn ia ua nan apigham.’ Egha uaghan ghaze, ‘Bizir kamɨn mɨngarim, a kamakɨn, kɨ Afeziam bagha zui.’” ");
INSERT INTO msy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Egha me mɨgɨa ghuavɨra iti, “Dughiar ovezir a mɨkemezir kam, a bizir tizim? E akar a mɨkemezir kamɨn mɨngarim gɨfozir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ezɨ Iesus fo, me an azangsɨghasa, ezɨ a me mɨgei, “Ia ti tintinibar akar kɨ mɨkemezir kamɨn mɨngarim bagha azangsɨsi? Kɨ kamaghɨn mɨgei, ‘Dughiar ovezimɨn ia nan ganighan kogham. Egh gɨn dughiar otevimɨn ia uan nan apigham.’ Ia ti bizir kam bagha azai, o? ");
INSERT INTO msy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kɨ bar guizbangɨra ia mɨgei, ia puvɨram aziva arangam. Eghtɨ nguazimɨn gumazamiziba bar akuegham. Ian naviba osemegham. Eghtɨ ian navir osɨmtɨzir kam iraghrɨghtɨma navir agorogem otogham. ");
INSERT INTO msy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Amizim borim batasava amuava, a fo, an mɨzazim iniamin dughiam otogha gɨfa. Kamaghɨn an oseme. Egha an otegha gɨvagha, a ua mɨzazir kam gɨnɨghnɨzir puvatɨ. An borim nguazimɨn otogha gɨfa, kamaghɨn amizɨ a bar akonge. ");
INSERT INTO msy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ezɨ kamaghɨra, ia datɨrɨghɨn naviba oseme. Eghtɨ kɨ ua ian gantɨ, ian naviba bar akuegham. Eghtɨ tav ian agoroger kam adeghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eghtɨ dughiar kamɨn ia ua bizitam bagh nan azaraghan kogham. Kɨ guizbangɨra ia mɨgei, ia bizitam bagh nan ziamɨn Afeziamɨn azaraghtɨma eghtɨ a ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ia faragha bizitam nan ziamɨn azarazir puvatɨ. Ia azangsɨghɨva, egh ia iniam, eghtɨ agorogem bar ian navibagh izɨvagham.” ");
INSERT INTO msy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Egha Iesus ua kamaghɨn mɨgei, “Kɨ akar isɨn zuimɨn akar kabar ia gami. Kɨ gɨn ua akar isɨn zuitam ia mɨkemeghan kogham. Puvatɨ. Kɨ deravɨra ia mɨkɨmɨva, egh Afeziamɨn ia mɨkɨmam. ");
INSERT INTO msy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Egh dughiar kamɨn ia nan ziamɨn azangsɨgham. Ezɨ kɨ kamaghɨn mɨgeir puvatɨ, kɨ ia bagh Afeziamɨn ko mɨkɨmam. Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Afeziam a uabɨ ia gifonge. Ia a gifongegha ia nɨghnɨzir gavgavim nan ikia egha fo, kɨ Afeziam ko ikegha ize. Kamaghɨn a ia gifonge. ");
INSERT INTO msy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Guizbangɨra, kɨ fomɨra Afeziam ko ikegha, egha kɨ an ategha nguazimɨn ize. Egh datɨrɨghɨn kɨ ua nguazim ategh, egh kɨ ua Afeziam bagh mangam.” ");
INSERT INTO msy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ezɨ an suren gumaziba kamaghɨn mɨgei, “Are, nɨ datɨrɨghɨn deravɨra mɨgei, nɨ datɨrɨghɨn akar isɨn zuibav geir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ezɨ e datɨrɨghɨn fo, nɨ biziba bar dagh fo. Gumazitam bizir mam nɨn azangsɨghasava amima, nɨ an nɨghnɨzibagh fogha gɨfa. Nɨ an azangsɨzim bagha mɨzuai puvatɨ, nɨ fogha gɨfa. Kamaghɨn amizɨ, e nɨghnɨzir gavgavim ikia ghaze, nɨ God ko ikegha egha nɨ ize.” ");
INSERT INTO msy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ezɨ Iesus kamaghɨn men akam ikara, “Ia datɨrɨghɨn nɨghnɨzir gavgavim iti, o? ");
INSERT INTO msy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ia oragh. Dughiam a roghɨra izi, egha a izegha gɨfa, eghtɨ me vaghvagh ian agɨntɨghtɨ ia tintinibar uan nguibabar mangam. Egh ia na ateghtɨ kɨ uabɨra ikiam. Ezɨ Afeziam na ko iti, kamaghɨn kɨ bar uabɨra ikeghan kogham. ");
INSERT INTO msy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ia nan poroghɨv ikɨva egh ia navir amɨrɨzim ikiasa kɨ ifonge. Kamagh sua kɨ akar kam ia mɨkeme. Eghtɨ ia nguazir kamɨn ikɨtɨ, osɨmtɨziba ia bativam. Egh ian naviba gavgavigh ikɨ! Kɨ nguazir kamɨn gavgavim dɨkabɨragha egha anegɨfa!” ");
INSERT INTO msy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ezɨ Iesus suren gumazibav kemegha gɨvagha, egha kogha overiamɨn gara, egha kamaghɨn mɨgei, “Afeziam, dughiam izegha gɨfa. Eghtɨ nɨn Otarim ziar ekiam nɨ danɨngsɨ, kamaghɨn nɨ datɨrɨghɨn ziar ekiam uan Otarim danɨngigh. ");
INSERT INTO msy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Kamaghɨn ami, nɨ gavgavim a ganigha gɨfa. Nɨ kamaghɨn ifonge, a ikɨrɨmɨrir aghuim gumazir nɨ a ganɨngiziba, bar me danɨngam. Kar zurara itir ikɨrɨmɨrir aghuarim. Bizir kam bagha, nɨ gumazamiziba bar men dapanimɨn ikiasa anemɨsefe. ");
INSERT INTO msy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ezɨ zurara itir ikɨrɨmɨrir aghuarim, a kamakɨn: Gumazir ikɨrɨmɨrir aghuarir kam iniziba, me nɨ gɨfo, nɨ uabɨra nɨ guizbangɨn God. Egha me Krais Iesus gɨfo, nɨ anemadazɨ a ize. ");
INSERT INTO msy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Kɨ nɨn ziar ekiam ko gavgavim nguazir kamɨn gumazamizibar akagha gɨfa. Egha kɨ, ingangarir kɨ damuasa nɨ na ganɨngizir kam, kɨ a gamigha gɨfa. ");
INSERT INTO msy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Afeziam, fomɨra nguazim tɨghar otivam, kɨ nɨ ko ikia nan ziam ekefe. Ezɨ datɨrɨghɨn nɨ uan damazimɨn, nɨ ua ziar ekiam na danɨngasa, kɨ ifonge. ");
INSERT INTO msy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kɨ nɨn ziar ekiam isa nguazir kamɨn gumazir nɨ na ganɨngizibar aka. Me nɨn gumazamiziba, ezɨ nɨ me na ganigha gɨfa. Ezɨ me deravɨra nɨn akam baragha an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Egha me datɨrɨghɨn fo, bizir nɨ na ganɨngiziba, da bar nɨrara ize. ");
INSERT INTO msy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ezɨ akar nɨ na ganɨngiziba, kɨ bar da isa me ganɨngi. Ezɨ me da ini, egha me guizbangɨra kamaghɨn fo, kɨ fomɨra nɨ ko ikegha, egha kɨ ize. Egha me nɨghnɨzir gavgavim ikia kamaghɨn fo, nɨ na amadazɨ ezɨ kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Kɨ me bagha nɨ ko mɨgei. Kɨ bar nguazimɨn gumazamiziba bagha nɨ ko mɨgeir pu. Kɨ fo, gumazamizir nɨ na ganɨngizir kaba, me nɨn adarasi. Kamaghɨn amizɨ, kɨ me bagha nɨ ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ezɨ nan gumazamiziba, me nɨn adarasi. Ezɨ nɨn gumazamiziba, me nan adarasi. Ezɨ gumazamiziba nan gumazamizir kabar gari, me nan ziar ekiam gɨfo. ");
INSERT INTO msy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Kɨ datɨrɨghɨn nɨ bagh izam, egh kɨ ua nguazimɨn ikian kogham. Ezɨ me nguazimɨn ikiavɨra iti. Ezɨ Afeziam, nɨ bar zue ezɨ tav nɨn mɨn itir puvatɨ! Kɨ kamagh sua, me uari inigh navir vamɨra ikɨ, mati nɨ na ko, ga uaning inigha iti moghɨn. Bizir kam bagha, nɨ uan ziamɨn gavgavimɨn deravɨra men gan. Kar ziar nɨ na ganɨngizim. ");
INSERT INTO msy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ezɨ dughiar kɨ me ko itiba, kɨ nɨn ziamɨn gavgavimɨn men gari. Kar ziar nɨ na ganɨngizim. Kɨ bar deravɨra men garima men tav ovengezir puvatɨ. Ezɨ gumazir ovengamim, a uabɨram ovengam. Kɨ kamagh sua, nɨn Akɨnafarimɨn itir akam guizbangɨra otivam, kamaghɨn gumazir kam ovengam. ");
INSERT INTO msy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Kɨ datɨrɨghɨn nɨ bagha izi. Kɨ kamaghɨn ifonge, nan agorogem men navibagh izɨvagh ikiam. Kamaghɨn, dughiar kɨ nguazimɨn itim, kɨ akar kabav mɨkeme. ");
INSERT INTO msy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","“Nɨn akam, kɨ me ganigha gɨfa. Kɨ nguazir kamɨn gumazim puvatɨ. Ezɨ kamaghɨra, nan gumazamiziba me nguazir kamɨn gumazamiziba puvatɨ. Kamaghɨn amizɨma, nguazir kamɨn gumazamiziba men aghuagha men apanim gami. ");
INSERT INTO msy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kɨ, nɨ nguazir kamɨn me inigh azenan mangasa nɨn azangsɨzir pu. Puvatɨ. Kɨ, nɨ men ganasa, kɨ nɨn azai, eghtɨ Gumazir Kuram pazɨ me damuan kogham. ");
INSERT INTO msy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kɨ uabɨ kɨ nguazir kamɨn gumazim puvatɨ. Ezɨ kamaghɨra, me nguazir kamɨn gumazamiziba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ezɨ nɨn akam a bar guizbangɨra. Ezɨ kɨ, nɨ uan akam damutɨ a men navir averiabar ingarasa, kɨ ifonge. Eghtɨ nɨ me damutɨ me uari isɨ nɨ danɨngam ");
INSERT INTO msy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nɨ fomɨra na amadazɨ ezɨ kɨ izegha nguazir kamɨn gumazamizibar tongɨn iti. Ezɨ kamaghɨra nɨ gumazir na ganɨngiziba, kɨ me amadagha ghaze, me nguazir kamɨn gumazamizibar tongɨn ikiam. ");
INSERT INTO msy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Kɨ kamaghɨn ifonge, me bar guizbangɨra uari isɨ nɨ danɨngam. Bizir kam bagha kɨ men akurvaghasa, kɨ bar uabɨ isa nɨ ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Kɨ gumazir kabara bagha God ko mɨgeir puvatɨ. Kɨ, gumazamizir men akam baragh egh nɨghnɨzir gavgavim nan ikiamiba, kɨ uaghan me bagha God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Egha gumazir kaba bar navir vamɨra ikiasa kɨ ifonge. Afeziam, nɨ nan aven itima kɨ nɨn aven iti, ezɨ kamaghɨra me gan aven ikiasa kɨ ifonge. Eghtɨ nguazimɨn gumazamiziba nɨghnɨzir gavgavim ikɨ egh fogh suam, nɨ na amadazɨ ezɨ kɨ ize. Kamaghɨn kɨ ghaze, me bar navir vamɨra ikɨ. ");
INSERT INTO msy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Kɨ ghaze, nɨ na ko, ga navir vamɨra iti moghɨn, kamaghɨra me navir vamɨra ikiam. Bizir kam bagha, nɨ ziar ekiar na ganɨngizim, kɨ ziar ekiar kamra isa me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kɨ kamagh sua, nguazimɨn gumazamiziba fogh suam, nɨ na amadazɨ ezɨ kɨ ize. Egh fogh suam, nɨ na gifongezɨ moghɨra nɨ nan adarazigh ifonge. Kamaghɨn kɨ men aven iti, ezɨ nɨ nan aven iti, ezɨ arazir kamɨn me guizbangɨra navir vamɨra ikiasa kɨ ifonge. ");
INSERT INTO msy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Afeziam, gumazamizir nɨ na ganɨngiziba, me na ko nguibar kɨ itimɨn ikiasa kɨ ifonge. Me nan angazangarir ekiam ko nan gavgavimɨn ganasa kɨ ifonge. Dughiar nguazim tɨghar otivam, nɨ na gifonge, egha nɨ angazangarir kam ko gavgavim na ganɨngi. ");
INSERT INTO msy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Nɨ Arazir Aghuibara Amir Afeziam, nguazimɨn gumazamiziba nɨ gɨfozir puvatɨ. Ezɨ kɨ nɨ gɨfo. Ezɨ nan adarasi, me fo, nɨ na amadazɨ ezɨ kɨ ize. ");
INSERT INTO msy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kɨ kamaghɨn ifonge, me igharazigh ifongezir arazim inigham, nɨ na gifongezɨ moghɨn. Eghtɨ kɨ uaghan men aven ikiam. Kamaghɨn kɨ nɨ isa men aka, egh kɨ kamaghɨn damu mamaghɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ezɨ Iesus kamaghɨn God ko mɨkemegha gɨvagha, egha uan suren gumaziba ko me ghua Kidronɨn zarim girɨgha vongɨn ghu. Ezɨ dɨpar kamɨn vongɨn azenir mam iti, ezɨ Iesus uan suren gumaziba ko me azenir kamɨn aven ghue. ");
INSERT INTO msy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Dughiar avɨribar Iesus uan suren gumaziba azenir kamɨn me batifi. Kamaghɨn Judas, a Iesus isɨ gumazir apanibar agharim darɨghamim, a uaghan azenir kam gɨfo. ");
INSERT INTO msy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Egha Judas, a Romɨn mɨdorozir gumaziba ko, ofa gamir gumazir ekiaba ko Farisiba amadazir plisɨn maba, a me inigha danganir kamɨn ghue. Egha me adenir aviba ko lamba ko mɨdorozir biziba sara suigha zui. ");
INSERT INTO msy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ezɨ Iesus bizir a bativamiba a bar dagh fo. Egha a sɨvagha men boroghɨra ghua egha kamaghɨn me azai, “Ia tina buri?” ");
INSERT INTO msy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ezɨ me kamaghɨn an akam ikara, “E Nasaretɨn gumazim Iesus buriasa izi.” Ezɨ Iesus me mɨgei, “Kar kɨrara.” Dughiar kam Judas, a gumazir Iesus isa me ganɨdim, a me ko tughav iti. ");
INSERT INTO msy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Me Iesus barazi a mɨgei, “Kar kɨrara,” egha me ua sɨvagha ghua nguazim gire. ");
INSERT INTO msy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ezɨ Iesus ua men azara, “Ia tina buri?” Ezɨ me ghaze, “Nasaretɨn gumazim Iesus.” ");
INSERT INTO msy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ezɨ Iesus kamaghɨn men akam ikara, “Kɨ ia mɨkemegha gɨfa, kar kɨrara. Kamaghɨn ia na buriva, gumazir kaba ateghtɨ me mangɨ.” ");
INSERT INTO msy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A kamagh sua an akar fomɨra mɨkemezim, an daghem otogham, “Ezɨ gumazir nɨ na ganɨngiziba, men tav ovengezir puvatɨ.” Kamaghɨn an arazir kam gami. ");
INSERT INTO msy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ezɨ Saimon Pita mɨdorozir sabar mam inigha ize, egha uan sabam a mɨkɨrɨgha egha ofa gamir gumazir ekiabar dapanimɨn ingangarir gumazim mɨsuegha, egha an kuarir guvimɨn itim atu, ezɨ a irɨ. Ingangarir gumazir kamɨn ziam, Malkus. ");
INSERT INTO msy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ezɨ Iesus Pita mɨgei, “Nɨ sabam inigh ua an nodozim darugh. Manmagh ami? Nɨ ghaze, kɨ ti Afeziam na ganɨngizir osɨmtɨzir kam inian kogham, o?” ");
INSERT INTO msy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ezɨ Romɨn mɨdorozir gumaziba ko men gumazir ekiam, ko Judan plisɨn gumaziba, me Iesusɨn suighava egha benimɨn a ike. ");
INSERT INTO msy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Egha faraghava a inigha Anas bagha ghu. Anas a Kaiafasɨn ivozir afeziam. Kaiafas a azenir kamɨn ofa gamir gumazir ekiabar dapanim. ");
INSERT INTO msy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Egha Kaiafas, Judaba kamaghɨn me mɨkemezir gumazim, “Kamaghɨn a dera, gumazir vamɨra gumazamizibar danganim inigh egh aremegham.” ");
INSERT INTO msy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ezɨ Saimon Pita ko suren gumazir igharazir mam, aning Iesusɨn gɨn zui. Ofa gamir gumazir ekiabar dapanim, a suren gumazir kam gɨfo, ezɨ kamaghɨn a Iesusɨn gɨn ghua ofa gamir gumazir ekiabar dapanimɨn dɨpenimɨn dɨvazimɨn aven ghu. ");
INSERT INTO msy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ezɨ Pita azenan ikia tiar akamɨn boroghɨra tughav iti. Ezɨ suren gumazir igharazim, a ghua amizir tiar akamɨn garim mɨkemegha, egha Pita inigha aven zui. ");
INSERT INTO msy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ezɨ amizir tiar akamɨn garim a kamaghɨn Pitan azara, “Nɨ ti uaghan gumazir kamɨn suren gumazim?” Ezɨ Pita ghaze, “Puvatɨ. Kɨ an suren gumazim pu.” ");
INSERT INTO msy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ezɨ danganim bar orangi. Kamaghɨn amizɨ ingangarir gumaziba ko plisɨn gumaziba me avir mam atɨ. Egha me avimɨn fɨava an mɨn tuivighav iti. Ezɨ Pita uaghan me ko tughav ikia egha avimɨn fɨa iti. ");
INSERT INTO msy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ezɨ dughiar kamɨn ofa gamir gumazir ekiabar dapanim, a Iesusɨn suren gumaziba ko akar a men sure gamizim bagha, a Iesusɨn azangsɨsi. ");
INSERT INTO msy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ gumazamiziba azenara me mɨkeme. Egha kɨ zurara God ko mɨgeir dɨpeniba ko Godɨn Dɨpenimɨn aven gumazamizibar sure gami. Kar danganir Judaba bar uari akuviba. Kɨ modogha akatam mɨkemezir pu. ");
INSERT INTO msy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ezɨ manmagh amizɨ nɨ nan azangsɨsi? Nɨ gumazir akar kam baraghizibar azangsɨgh. Me kɨ mɨkemezir akam gɨfo.” ");
INSERT INTO msy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Iesus kamaghɨn mɨgeima ezɨ plisɨn gumazir mam tughav ikia, egha an an guam a mɨsuegha kamaghɨn mɨgei, “Nɨ kamaghɨn ofa gamir gumazir ekiabar dapanimɨn akam ikara, kar ti arazir aghuim, o?” ");
INSERT INTO msy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ akar kuratam mɨkemeghtɨ, eghtɨ nɨ deravɨra akar kɨ mɨkemezim an gun mɨkɨm. Eghtɨ kɨ mɨgɨrɨgɨar aghuim damightɨ, ezɨ nɨ tizim bagha na apese?” ");
INSERT INTO msy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ezɨ Anas Iesus isa ofa gamir gumazir ekiabar dapanim Kaiafas bagha anemada. Egha me Iesus ikezir benim fɨrizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pita tughav ikia egha avimɨn fɨi. Ezɨ me kamaghɨn an azara, “Nɨ ti uaghan an suren gumazir mam?” Ezɨ a mɨgei, “Puvatɨ. Kɨ an suren gumazim puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ezɨ ofa gamir gumazir ekiabar dapanimɨn ingangarir gumazir mam iti, a Pita kuarim atuzir gumazimɨn adarazir mav. A ghaze, “Kɨ ti nɨn gani, nɨ Iesus ko azenimɨn aven ikes?” ");
INSERT INTO msy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ezɨ Pita ua mɨgei, “Puvatɨ.” Ezɨ dughiar kamra tuarim ake. ");
INSERT INTO msy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Egha Judaba Iesus inigha Kaiafasɨn dɨpenim ategha an akua gavmanɨn dapanir ekiamɨn dɨpenimɨn zui. Ka bar mɨzaraghara. Egha me ghaze, “E Godɨn damazimɨn mɨzeghɨva, egh e God Israelbagh Itazir Dughiamɨn isar ekiamɨn asɨzim rameghan kogham.” Kamaghɨn amizɨ, me uari gavman dapanir ekiamɨn dɨpenimɨn aven ghuzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Me azenan iti, ezɨ Pailat me bagha izi, egha kamaghɨn men azara, “Ia akar manam gumazir kam gasarazɨ, a kotɨn iti?” ");
INSERT INTO msy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ezɨ me kamaghɨn an akam ikara, “An arazir kuram gamir puvatɨzɨ, e nɨ bagha a inigha izeghan koghai.” ");
INSERT INTO msy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ezɨ Pailat kamaghɨn me mɨgei, “Kamaghɨn, ia a inigh mangɨva uan Arazibagh isɨn a tuisɨgh.” Ezɨ Judaba kamaghɨn akam ikara, “E gumazir tam puram a mɨsueghtɨ an aremeghan kogham.” ");
INSERT INTO msy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Iesus fomɨra uan ovengamin arazim mɨgei. A kamagh sua, an akar kam guizbangɨra otivam, ezɨ kamaghɨn Pailat ko Judaba kamaghɨn uariv gei, ezɨ bizir kam oto.) ");
INSERT INTO msy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ezɨ Pailat uamategha gavmanɨn dɨpenimɨn aven ghua, egha Iesusɨn diazɨma a izi. Ezɨ a kamaghɨn an azara, “Nɨ Judabar Atrivim, o?” ");
INSERT INTO msy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ezɨ Iesus kamaghɨn an akam ikara, “Nɨ uabɨ nɨghnɨgha egha nɨ akar kam gami, o gumazir igharazitam nan gun nɨ mɨkeme?” ");
INSERT INTO msy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ezɨ Pailat kamaghɨn an akam ikara, “Manmaghɨn ami? Nɨ ghaze, kɨ Judan mav, o? Nɨ uan adarazi ko ofa gamir gumazir ekiaba, me nɨn akua na bagha ize. Nɨ bizir tizim gami?” ");
INSERT INTO msy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ nguazir kamɨn atrivim puvatɨ. Kɨ nguazir kamɨn atrivimɨn ikiai, kamaghɨn nan ingangarir gumaziba na bagha mɨsoghai, egha tav na isa Judabar agharim gatɨghan koghai. Ezɨ kɨ nguazir kamɨn atrivibar mɨn ingarir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ezɨ Pailat an azara, “Ezɨ nɨ guizbangɨra atrivir mam, o?” Ezɨ Iesus kamaghɨn akam ikara, “Atrivimɨn mɨgɨrɨgɨar kam, kar nɨn akamra. Amebam na batezɨ ezɨ kɨ nguazir kamɨn ingangarir vamɨra damuasa ize. Ingangarir kam kamakɨn: kɨ guizɨn akam akunam. Egha gumazir guizɨn akamɨn gɨn mangamiba, me nan akam barasi.” ");
INSERT INTO msy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ezɨ Pailat an azara, “Guizɨn akam, a bar bizir tizimra?” Pailat mɨkemegha gɨvagha egha ua Judaba bagha azenan ghu. Egha kamaghɨn me mɨgei, “Kɨ an arazir kuratam batozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Egha ia, arazir kɨ gɨn zuir kam, ia a gɨfo. Ezɨ azeniba bar, God Israelbagh Itazir Dughiamɨn, kɨ ian arazimɨn gɨn ghua gumazir vamɨra kalabusɨn a isa azenim gatɨ. Ia ifueghtɨ kɨ Judabar atrivir kam fɨrigh ia bagh anemangam, o?” ");
INSERT INTO msy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ezɨ me kamaghɨn dɨa ghaze, “Mam puvatɨ! Nɨ Barabasra a fɨrigh!” (Barabas, a gumazir okeim egha uaghan mɨsosi.) ");
INSERT INTO msy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ezɨ Pailat me mɨkemezɨ me Iesus inigha a ifozorosi. ");
INSERT INTO msy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ezɨ mɨdorozir gumaziba dɨkoniba itir beniba inigha egha atrivimɨn dapanir asuamɨn mɨn an ingarigha, an dapanim garu. Egha me korotiar aghevir mam a garu. ");
INSERT INTO msy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Egha me an boroghɨra izegha a mɨgei, “Judabar Atrivim, nɨrara atrivir ekiam!” Egha me kamaghɨn mɨgɨava an guam apezavɨra iti. ");
INSERT INTO msy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ezɨ Pailat ua azenan ghugha kamaghɨn gumazamizibav gei, “Ia oragh. Kɨ a inigh ia bagh azenan izam, eghtɨ ia fogham, kɨ an arazir kuratamɨn apizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ezɨ Iesus azenan zui. Ezɨ dapanir asuar me benir dɨkoniba itimɨn ingarizim, an an dapanimɨn ikiavɨra iti. Ezɨ korotiar aghevir kam, a uaghan an ikiavɨra iti. Ezɨ Pailat me mɨgei, “Ia gan, gumazir kam a kara.” ");
INSERT INTO msy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ezɨ ofa gamir gumazir ekiaba ko plisɨn gumaziba an ganigha kamaghɨn dei, “Ter ighuvimɨn a gafugh! Ter ighuvimɨn a gafugh!” Ezɨ Pailat kamaghɨn me mɨgei, “Ia uari a inighɨva egh ter ighuvimɨn a gafugh. Kɨ uabɨ, kɨ an arazir kuratamɨn apizir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ezɨ Judaba kamaghɨn an akam ikara, “A uabɨ ghaze ‘Kɨ Godɨn Otarim.’ Ezɨ en Arazibar Osizirir mam iti, ezɨ arazir kam kamaghɨn mɨgei, gumazir kamagh mɨgeim, an aremegham.” ");
INSERT INTO msy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ezɨ Pailat akar kam baregha egha bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Egha a ua ghua gavmanɨn dɨpenimɨn aven ghugha, egha kamaghɨn Iesusɨn azai, “Nɨ nguibar manamɨn ikegha ize?” Ezɨ Iesus an akar kam ikarazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ezɨ Pailat a mɨgei, “Manmaghɨn amizɨ nɨ nan akam ikarvaghan aghua? Kɨ nɨ fɨrighamin gavgavim iti, egha uaghan nɨ isɨv temer ighuvim gafughamin gavgavim iti. Ezɨ nɨ ti bizir kam gɨfozir puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ezɨ Iesus kamaghɨn an akam ikara, “Godɨn pɨn itim, a gavgavim nɨ ganɨngizir puvatɨghai, nɨ na dɨkabɨnamin gavgaviba puvatɨgham. Ezɨ gumazir na isa nɨn agharim gatɨzim, an arazir kuramɨn osɨmtɨzim, a nɨn arazir kuramɨn osɨmtɨzim, bar a gafira.” ");
INSERT INTO msy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailat akar kam baregha egha Iesus ateghtɨ a mangasa tuaviba buri. Ezɨ Judaba kamaghɨn dei, “Nɨ gumazir kam ateghtɨ a mangɨtɨ, nɨ Sisarɨn namakam puvatɨ. Guizbangɨra, gumazim uabɨra uabɨ mɨgɨa ghaze, an atrivim, egha a Sisarɨn apanim.” ");
INSERT INTO msy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat akar kam baregha, egha Iesusɨn akua azenan ghu. Egha a jasɨn dabirabim gaperaghav iti, danganir kam me “Dagɨar Azuarim” a garɨsi. (Hibrun akam me ghaze, “Gabata”). ");
INSERT INTO msy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ezɨ dughiar kam a dughiar me God Israelbagh Itazir Dughiamɨn isam bagha daghebar amuva bizibar kɨram. Kar aruer arɨzim. Ezɨ Pailat Judabav gei, “Ia ganigh! Ian Atrivim kara.” ");
INSERT INTO msy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Egha me kamaghɨn dei, “A batokegh! A batueghtɨ a mangɨ! Ter ighuvimɨn a gafugh!” Ezɨ Pailat men azara, “Ia ifonge, kɨ ian Atrivim isɨ ter ighuvimɨn a gafugham?” Ezɨ ofa gamir gumazir ekiaba kamaghɨn akam ikara, “E atrivir igharaziba puvatɨ. Sisar bar uabɨra!” ");
INSERT INTO msy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kamaghɨn amizɨ Pailat Iesus inigha, me ter ighuvimɨn a gafughasa, a men agharim gatɨ. Ezɨ me Iesus inigha zui. ");
INSERT INTO msy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ezɨ a uabɨ uan ter ighuvim gupugha, egha nguibar ekiam ategha egha danganir mamɨn zui, an ziam “Dapanir Agharir Danganim.” (Ezɨ Hibrun akam me ghaze “Golgota.”) ");
INSERT INTO msy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ezɨ danganir kamɨn me a isa ter ighuvimɨn anegura. Egha me gumazir igharazir pumuning a ko, aning agura, mam vongɨn itima, mam vongɨn iti. Ezɨ Iesus aningɨn torimɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ezɨ Pailat uaghan me mɨgeima me ziar mam osirigha ter ighuvim gatɨ. Ziar kam a kamakɨn, “Nasaretɨn Gumazim Iesus, Judabar Atrivim.” ");
INSERT INTO msy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Me ziar kam, Hibrun akam ko Romɨn akam ko Grighɨn akamɨn, men akabar an osiri. Danganir me Iesus ter ighuvimɨn anegurazim, a nguibar ekiam boroghɨra iti, kamaghɨn amizɨ Judan avɨrim izava osizirir kamɨn gara egha a dɨbori. ");
INSERT INTO msy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ezɨ ofa gamir gumazir ekiaba kamaghɨn Pailat mɨgei, “Nɨ kamaghɨn osiran markɨ, ‘Judan Atrivim.’ Bar markɨ. Nɨ ziam kamaghɨn an osirigh, ‘Gumazir kam ghaze, kɨ Judabar Atrivim.’” ");
INSERT INTO msy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ezɨ Pailat men akam ikara, “Markɨ. Akar kɨ osirigha gɨvazim, a kamaghɨra ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Mɨdorozir gumaziba ter ighuvimɨn Iesus gafugha gɨvagha, egha gɨn me an korotiaba inigha egha 4 plan akuabar uari rome. Egha me akuar vamɨra vamɨra isi. Egha me uaghan an korotiar ruarim sara ini, egha mɨdorozir gumaziba kamaghɨn gari, me inir akuar avɨriba inigha korotiar ruarir kam isamizir pu. Puvatɨ. Me inir vamiram an ingari, egha me a isamizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Egha mɨdorozir gumaziba kamaghɨn uarira uariv gei, “E korotiar ruarir kam abighan kogham. Puvatɨ. E satu gikararangɨva gumazir a iniamim gɨfogham.” Godɨn Akɨnafarimɨn itir akar mam kamaghɨn mɨgei, “Me nan korotiaba tuiragh, egh uari danɨngam. Egh me satu gikararangɨva gumazim amɨseveghtɨ a nan korotiar ruarim iniam.” Ezɨ akar kam guizbangɨra otoghasa, kamaghɨn arazir kamra mɨdorozir gumaziba a gami. ");
INSERT INTO msy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ezɨ Iesusɨn amebam ko, an amebamɨn afumim ko, Klopasɨn amuim Maria ko, Makdalan nguibamɨn amizim Maria, me bar an ter ighuvimɨn boroghɨra tuivighav iti ");
INSERT INTO msy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ezɨ Iesus garima an amebam ko suren gumazir a bar ifongezim, aning roghɨra tughav iti. Ezɨ a kamaghɨn uan amebam mɨgei, “Amizim, gumazir kam datɨrɨghɨn, a nɨn otarim.” ");
INSERT INTO msy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ezɨ a kamaghɨn suren gumazir kam mɨgei, “Amizir kam, a datɨrɨghɨn nɨn amebam.” Ezɨ dughiar kamɨn ghua, suren gumazir kam Maria inigha uan dɨpenimɨn ghugha egha an gara uan amebamɨn mɨn a gami. ");
INSERT INTO msy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ezɨ Iesus fo, an ingangariba datɨrɨghɨn bar gɨfa. Egha a kamaghɨn mɨgei, “Nan kuarim nan pɨri.” Godɨn Akɨnafarimɨn itir akar mam guizbangɨra otivasa, kamaghɨn an akar kam gami. ");
INSERT INTO msy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ezɨ mɨner mam wainɨn afangtɨzim an ikia roghɨra iti. Egha me dɨpamɨn suizir bizim inigha egha wainɨn dɨpam garu. Ezɨ wain a gizɨvazɨma, me a isa hisopɨn aghorim gikegha a isa Iesusɨn akam darɨghasa an amadi. ");
INSERT INTO msy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ezɨ Iesus wainɨn kam amegha gɨvagha, egha mɨgei, “A datɨrɨghɨn gɨfa.” Egha a dapanim aviragha egha uan duam sue. ");
INSERT INTO msy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kar dughiar me Sabat bagha bizibar akɨrim. Sabatɨn dughiar kam, a dughiar bar ekiam. Kamaghɨn amizɨma Judaba me gumazir kuaba dughiar kam temer ighuvibar ikian me aghua. Egha me Pailat kamaghɨn an azangsɨgha ghaze, a men amamangatɨghtɨ me temer ighuvibar itir gumazibar suer agharibav sogh da apɨrightɨ, me zuamɨram aremeghtɨ me men kuaba adegh izighram. ");
INSERT INTO msy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ezɨ mɨdorozir gumaziba ghua gumazir Iesus ko guraghav itir mamɨn suer agharimning mɨsogha aning apɨrigha, egha ghua gumazir igharazim uaghan an suer agharimning mɨsogha aning apɨri. ");
INSERT INTO msy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Egha me iza Iesusɨn garima an aremegha gɨfa. Kamaghɨn amizɨma me an suer agharimning apɨrizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ezɨ mɨdorozir gumazir mam afuzim inigha Iesusɨn ivim bɨra. Ezɨ ghuzim ko dɨpam zuamɨra ire. ");
INSERT INTO msy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Kɨ, Jon, kɨ gumazir bizir kamɨn ganizim, kɨ kamaghɨn ifonge, ia bizir kam gɨfoghɨva nɨghnɨzir gavgavim an ikiam. Kamaghɨn kɨ an gun ia mɨgei. Akar kɨ gun mɨgeir kam, a guizbangɨra. Kɨ uabɨ fo, kɨ guizbangɨra mɨgei.) ");
INSERT INTO msy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Godɨn Akɨnafarimɨn itir akar mam, a kamakɨn, “Me an agharitam apɨrighan kogham.” God kamagh sua, akar kam guizbangɨram otogham, ezɨ kamaghɨn bizir kam oto. ");
INSERT INTO msy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ezɨ akar igharazir mam Godɨn Akɨnafarimɨn iti, a kamakɨn, “Me, gumazir afuzimɨn ruazir kam bagh ganam.” ");
INSERT INTO msy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ezɨ gɨn Arimatean nguibamɨn gumazim Josep ghua Iesusɨn kuam iniasa Pailatɨn azangsɨsi. Josep a Iesusɨn suren gumazir mam, egha a Judabar atiatigha, egha uan nɨghnɨzir gavgavim modo. Ezɨ Pailat an amamangatɨzɨ, a ghuava Iesusɨn kuam ini. ");
INSERT INTO msy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ezɨ Nikodemus, gumazir faragha dɨmagarimɨn Iesusɨn ganizim, a uaghan ize. Egha borer mughuriar aghuir maba inigha ize, me temer pumuningɨn borem inigha aning veregha, egha borer kam gami. Ezɨ borer kamɨn osɨmtɨzim 30 plan kilogramɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ezɨ Josep ko Nikodemus aning Iesusɨn kuam inigha borer kam an kuam gaghui. Egha inir aghuimɨn an mɨkarzim nomke, Judaba uan gumazir oveaghuezibagh ami moghɨn. ");
INSERT INTO msy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ezɨ mɨdorozir gumaziba Iesus ter ighuvimɨn anegurazir danganir kamɨn boroghɨra, azenir mam iti. Egha azenir kamɨn mozir igiar mam iti, me dagɨar torim atugha, egha me faragha gumazitamɨn kuatam a gatɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kar dughiar Judaba Sabatɨn dughiam bagh bizibar kɨramim, ezɨ mozir kam, a Iesus aremezir danganim boroghɨra iti. Kamaghɨn amizɨ, aning Iesusɨn kuam inigha ghua mozir kamɨn anetɨ. ");
INSERT INTO msy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ezɨ Sanden bar mɨzaraghara, amɨnim mɨtateghavɨra iti, ezɨ Makdalan nguibamɨn amizim Maria, a mozimɨn ghu. Egha a garima mozimɨn tiar akam gasarazir dagɨam ua itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ezɨ a, Saimon Pita ko suren gumazir igharazir kam, a gumazir Iesus bar ifongezim, an aning bagha ivegha ghu. Egha Maria kamaghɨn aningɨn mɨgei, “Me Ekiamɨn kuam mozimɨn a inigha ghu, ezɨ e fozir puvatɨ, me managh anetɨ.” ");
INSERT INTO msy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ezɨ Pita ko suren gumazir igharazir kam, aning nguibam ategha egha mozimɨn zui. ");
INSERT INTO msy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Aning vɨrara ivegha ghua, suren gumazir igharazir kam Pita gafiragha, egha faragha mozimɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Egha an aviragha mozimɨn aven gari, egha inir aghuir me Iesusɨn kuam avarazir kabar gara egha an aven ghuzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ezɨ Saimon Pita an gɨn ghua, mozimɨn averiamɨn ghu. Egha a inir aghuir kabar garima da iti. ");
INSERT INTO msy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Egha a inir igharazir mamɨn garima a uaghan iti, a inir me Iesusɨn dapanimɨn ikezim. Inir kam a inir igharaziba ko itir puvatɨ. Saimon ghaze, me ti a righa egha igharagha anetɨ. ");
INSERT INTO msy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ezɨ suren gumazir igharazir faragha mozimɨn otozim, a uaghan aven ghu. Egha a bizir kabar ganigha egha nɨghnɨzir gavgavim iti. ");
INSERT INTO msy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Guizbangɨra, Godɨn Akɨnafarimɨn itir akam ghaze, Iesus mozimɨn ua dɨkavigham. Ezɨ dughiar kamɨn aning akar kam tɨghar deraghvɨra a gɨfogham.) ");
INSERT INTO msy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Egha suren gumazimning uamategha dɨpenimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ezɨ Maria mozimɨn azenan tughav ikia azi. Egha an aziavɨra ikia egha aviragha mozimɨn averiamɨn gari. ");
INSERT INTO msy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Egha a enselɨn pumuningɨn garima, aning korotiar ghurghurimning aru. Egha aning danganir Iesusɨn kuam faragha ikezimɨn aperaghav iti. Egha mam an dapanim ikezir naghɨn apera ezɨ mam an suemning ikezir naghɨn apera. ");
INSERT INTO msy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Egha aning kamaghɨn Marian azai, “Amizim, nɨ manmagh suava azi?” Ezɨ a kamaghɨn aningɨn mɨgei, “Me nan Ekiamɨn kuam inigha ghu, ezɨ kɨ fozir puvatɨ, me managh anetɨ.” ");
INSERT INTO msy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","A kamaghɨn mɨgɨava, ragha garima, Iesus tughav iti. Ezɨ Maria fozir puvatɨ, ka Iesus. ");
INSERT INTO msy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ezɨ Iesus kamaghɨn an azara, “Amizim, nɨ manmagh suava azi? Nɨ tina buri?” Ezɨ Maria ghaze, kar ti azenimɨn garir gumazim, egha a kamaghɨn Iesus mɨgei, “Gumazir aruam, nɨ an kuam inigha ghu, egh danganir nɨ an atɨzimɨn gun na mɨkemegh. Eghtɨ kɨ mangɨva a iniam.” ");
INSERT INTO msy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ezɨ Iesus kamaghɨn a mɨgei, “Maria!” Ezɨ Maria ragha kamaghɨn Hibrun akamɨn a mɨgei, “Rabonai.” Akar kamɨn mɨngarim a kamakɨn, “Tisa.” ");
INSERT INTO msy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ezɨ Iesus kamaghɨn a mɨgei, “Kɨ tɨghar uan Afeziam bagh mavanangam, kamaghɨn nɨ nan suiraghvɨra ikian markɨ. Egh nɨ nan aveghbuaba bagh mangɨva egh kamaghɨn me mɨkɨm, kon Afeziam, ko men Afeziam, kɨ a bagha uamategha ghuavanadi. A nan God, ko uaghan men God.” ");
INSERT INTO msy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ezɨ Makdalan Maria ghua suren gumaziba kamaghɨn me mɨgei, “Kɨ Ekiamɨn ganigha gɨfa.” Egha an akar Iesus a mɨkemezimɨn gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ezɨ Sanden guaratɨzimɨn amɨnim pɨrigha gɨfa. Ezɨ suren gumaziba me Judabar atiatingi, egha dɨpenir me itim, me pamten an tiar akaba ase, eghtɨ azenan itir gumazitam aven izan kogham. Ezɨ Iesus iza pura suren gumazibar tongɨn tughav iti. Egha a kamaghɨn me mɨgei, “Ian naviba amɨragh ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","A kamaghɨn mɨgɨa, uan duar torir dafarimningɨn itimning ko duar ivir vuemɨn itim, men aka. Ezɨ suren gumaziba Ekiamɨn ganigha me bar akonge. ");
INSERT INTO msy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ezɨ Iesus ua me mɨgei, “Ian naviba amɨragh ikɨ. Afeziam na amadazɨ ezɨ kɨ ize. Ezɨ kamaghɨra kɨ ia amadima ia zui.” ");
INSERT INTO msy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","A kamaghɨn mɨgɨa, egha uan amɨnim men a giveragha men amada, egha kamaghɨn me mɨgei, “Ia Godɨn Duam uan navir averiabar a inigh. ");
INSERT INTO msy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Egh ia gumazamizibar arazir kuraba gɨn amadagham, eghtɨ God uaghan men arazir kuraba gɨn amadaghtɨ, da ua puvatɨgham. Eghtɨ ia men arazir kuraba gɨn amadaghan koghtɨ, men arazir kuraba ikɨvɨra ikiam.” ");
INSERT INTO msy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Dughiar Iesus uan suren gumaziba batozim, men 12 plan suren gumazibar mav, a me ko itir puvatɨ. Kar Tomas, an ziar mam Fufuzim. ");
INSERT INTO msy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ezɨ suren gumazir igharaziba kamaghɨn Tomas mɨgei, “E Ekiamɨn ganigha gɨfa.” Ezɨ Tomas kamaghɨn me mɨgei, “Kɨ an duar torir me an dafarimning gafuzimingɨn ganighan koghɨva, egh kɨ uan dafarpuzim an duar torimning datɨghan koghɨva, egh kɨ uan dafarim an ivir vuemɨn itir duam datɨghan koghɨva, egh kɨ nɨghnɨzir gavgavim ikian kogham. Bar puvatɨgham.” ");
INSERT INTO msy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ezɨ 7 plan dughiaba gɨvazɨma, suren gumaziba ua dɨpenimɨn aven iti, ezɨ Tomas me ko aven iti. Me tiar akaba bar pamten da asegha gɨfa. Ezɨ Iesus iza men tongɨn tughav iti. Egha me mɨgei, “Ian naviba amɨragh ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Egha a kamaghɨn Tomas mɨgei, “Nɨ uan dafarpuzimɨn kagh suiragh, egh nɨ nan dafarimningɨn ganigh. Egh nɨ uan agharim amadagh uan dafarim nan ivir vuemɨn itir duam datɨgh. Nɨ nɨghnɨzir pumuning ikian markɨ. Nɨ nɨghnɨzir gavgavim nan ikɨ.” ");
INSERT INTO msy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ezɨ Tomas kamaghɨn an akam ikara, “Nɨ nan Ekiam. Nɨ nan God.” ");
INSERT INTO msy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ezɨ Iesus kamaghɨn a mɨgei, “Nɨ nan ganigha gɨfa, egha nɨ nɨghnɨzir gavgavim nan iti, o? Gumazir na ganizir puvatɨziba, me nɨghnɨzir gavgavim ikɨva, egh gumazir kaba bar akuegham.” ");
INSERT INTO msy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iesus mirakelɨn avɨrir maba uaghan suren gumazibar damazimɨn dagh ami. Ezɨ kɨ bar Akɨnafarir kamɨn da osirizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Egha, akar kɨ osirizir kam, kɨ ia nɨghnɨzir gavgavim Iesusɨn ikiasa, kɨ an osiri. A Gumazir God Uam E Iniasa Mɨsevezim, a Godɨn Otarim. Eghtɨ ia nɨghnɨzir gavgavim an ikɨva, egh ia an ziamɨn zurara itir ikɨrɨmɨrir aghuarim iniam. Kɨ kamagh sua, akɨnafarir kam an osiri. ");
INSERT INTO msy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ezɨ dughiar maba gɨvazɨma Iesus ua uan suren gumaziba Galilin dɨpamɨn boroghɨra uabɨ isa men aka. Galilin dɨpamɨn ziar mam Taiberiasɨn dɨpam. Bizir kam kamaghɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Dughiar kam Saimon Pita ko Tomas (an ziar mam Fufuzim), ko Nataniel (an nguibam, Kanan nguibar Galilin Distrighɨn aven itim), ko Sebedin otarir pumuning, ko Iesusɨn suren gumazir igharazir pumuning, me bar uari inigha iti. ");
INSERT INTO msy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Egha Saimon Pita kamaghɨn me mɨgei, “Kɨ osiriba burisɨ mangam.” Ezɨ me ghaze, “E nɨ ko mangam.” Egha me dɨkavigha botɨn mamɨn ghuavanabogha egha me zui. Ezɨ dɨmagarir kamɨn me osirir taba inizir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ezɨ aruem anangasa ovɨrima, me gumazir mamɨn garima a dɨpamɨn dadarimɨn tughav iti. Ezɨ suren gumaziba kamaghɨn fozir pu, kar Iesus. ");
INSERT INTO msy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ezɨ Iesus kamaghɨn men azara, “Otariba, ia osiritaba iniz, o?” Ezɨ me kamaghɨn a ikara, “Bar puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ezɨ a me mɨgei, “Ia ivem inigh, agharir guvir botɨn amadaghan itimɨn anekunigh, egh ia osiritaba inigham.” Kamaghɨn me ivem akunizɨ a iraghu, ezɨ me osirir bar avɨriba inigha, egha ua ivem gekuigha anagav avenge. ");
INSERT INTO msy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ezɨ suren gumazir Iesus bar ifongezim, a kamaghɨn Pita mɨgei, “Kar Ekiamra.” Pita faragha ingarasava uan korotiar aruzim sue. Egha a kamaghɨn oraki, “Kar Ekiamra,” egha korotiam uam anerugha uabɨ ikegha egha dɨpam uabɨ akunigha egha dɨpamɨn ghua dadarimɨn oto. ");
INSERT INTO msy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ezɨ suren gumazir igharaziba me botɨn zui, egha me ivem osiriba sara anemɨkɨrɨgha zui. Me dɨpar dadarimɨn boroghɨn 100 mitan mɨn iti. ");
INSERT INTO msy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ezɨ me iza dadarimɨn otogha gɨvagha, egha me avir mamɨn garima osiri maba avim gisɨn iti. Ezɨ bretɨn maba sara iti. ");
INSERT INTO msy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ezɨ Iesus kamaghɨn me mɨgei, “Osirir ia datɨrɨghɨn iniziba, ia taba inigh izɨ.” ");
INSERT INTO msy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ezɨ Saimon Pita botɨn ghuavanabogha egha ivem a mɨkɨrɨgha dɨpar dadarimɨn ghu. Ezɨ osirir ekiabara ivem gizɨfa, da bar moghɨra, 153 plan osiriba. Egha osiriba bar avɨraseme, ezɨ ivem dutuaghrɨzir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ezɨ Iesus kamaghɨn me mɨgei, “Ia izɨ damɨ.” Ezɨ suren gumaziba atiatigha men tav an azarazir puvatɨ, “Nɨ tina?” Me fo, kar Ekiamra. ");
INSERT INTO msy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Egha Iesus avim boroghɨra ghua egha bret inigha me ganɨdi. Egha osiriba sara inigha uaghan me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Dughiar Iesus mozimɨn dɨkavizimɨn gɨn, kar an namba 3ɨn dughiam a uabɨ isa uan suren gumazibar aka. ");
INSERT INTO msy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iesus uan suren gumaziba ko amegha gɨvazɨma, Iesus kamaghɨn Saimon Pitan azai, “Saimon, Jonɨn otarim, nɨ ti bar na gifonge, egha nɨ na gifongezir arazir kam, a gumazir kaba na gifongezir arazibagh afira?” Ezɨ Pita ghaze, “Are, Ekiam, nɨ fo, kɨ nɨ gifonge.” Ezɨ Iesus a mɨgei, “Nɨ nan gumazamiziba sipsipɨn nguzibar mɨn men akuragh deraghvɨra men gan.” ");
INSERT INTO msy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ezɨ Iesus uam an azara, “Saimon, Jonɨn otarim, nɨ ti na gifonge?” Ezɨ Pita a ikara, “Are, Ekiam, nɨ fo, kɨ nɨ gifonge.” Ezɨ Iesus a mɨgei, “Nɨ nan gumazamiziba sipsipbar mɨn men akuragh deraghvɨra men gan.” ");
INSERT INTO msy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Egha dughiar mɨkezimɨn uam an azara, “Saimon, Jonɨn otarim, nɨ ti na gifonge?” Ezɨ Pita Iesus baseme, a dughiar mɨkezim uam an azara ghaze, nɨ ti na gifonge? Ezɨ a kamaghɨn Iesus mɨgei, “Ekiam, nɨ bar bizibagh fo. Nɨ fo, kɨ nɨ gifonge.” Ezɨ Iesus kamaghɨn a mɨgei, “Nɨ nan gumazamiziba sipsipbar mɨn men akuragh deraghvɨra men gan. ");
INSERT INTO msy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kɨ guizbangɨra nɨ mɨgei, nɨ fomɨra igiamra ikia, nɨ uabɨ letiam uan ivariam ikegha egha danganir nɨ mangasa ifongezibagh arui. Ezɨ nɨ ghurighamin dughiam, nɨ uan agharimning feghtɨ, eghtɨ gumazir igharazim nɨ gikegh nɨ inighɨva danganir nɨ mangasa ifongezir puvatɨzimɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Iesus mɨgɨrɨgɨar kam mɨgɨa kamaghɨn Pitan aka, a tuavir manamɨn aremegh ziar ekiam God danɨngam.) Egha a kamaghɨn Pita mɨgei, “Nɨ nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ezɨ Pita ragha suren gumazir Iesus bar ifongezir kamɨn garima, an aningɨn gɨn izi. Suren gumaziba faragha Iesus koma apava, gumazir kam uan dapanim isa Iesusɨn afarɨzim boroghɨra anetɨgha, egha kamaghɨn an azai, Ekiam, tina nɨ isɨ apanibar agharim darɨgham? ");
INSERT INTO msy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ezɨ Pita an ganigha kamaghɨn Iesus azara, “Ekiam, gumazir kam, bizir tizim a batogham?” ");
INSERT INTO msy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ezɨ Iesus kamaghɨn an akam ikara, “Kɨ ifueghtɨ a ikɨvɨra ikɨ mangɨ dughiar kɨ uamategh izamim otogham, kar nɨn bizim pu. Nɨ nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kamaghɨn amizɨma, akar kam tintinibar arui, ezɨ gumazamiziba kamaghɨn nɨghnɨgha ghaze, “Suren gumazir kam an aremeghan kogham.” Ezɨ Iesus guizbangɨra kamaghɨn mɨkemezir puvatɨ, an aremeghan kogham. Puvatɨ. A ghaze, “Kɨ ifueghtɨ a ikɨvɨra ikɨ mangɨ dughiar kɨ uamategh izamim otogham, kar nɨn bizim pu.” ");
INSERT INTO msy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kar suren gumazir kamra, a datɨrɨghɨn bizir kabar gun mɨkemegha, egha an akar kaba osiri. E datɨrɨghɨn fo, akar a gun mɨkemezir kaba, da guizbangɨra. ");
INSERT INTO msy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ezɨ bizir avɨrir igharazir maba Iesus uaghan dagh amizɨ, da iti. Ezɨ me ti vaghvagha bizir kaba akɨnafaribar da osirighai, nguazir kamɨn akɨnafarir kabar arɨghamin danganiba bar puvatɨgham.");
INSERT INTO msy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Tiofilus, kɨ akɨnafarir kam nɨ bagha an osiri. Nan akɨnafarir faragha zuimɨn, kɨ Iesus amizir biziba bar, ko a gumazamizibar sure gamiziba bar, da osiri. Dughiar kamɨn Iesus dɨkavigha uan ingangarim gamua mamaghɨra ikia, ghua a Godɨn Nguibamɨn ghuavanabozir dughiamɨn tuzir biziba, kɨ da osiri. A tɨghar Godɨn Nguibamɨn mangasa, aposelba mɨsevegha egha Godɨn Duamɨn gavgavimɨn ingangarir akabar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A faragha mɨzaziba inigha aremegha egha ua dɨkafi. Egha a tɨghar Godɨn Nguibamɨn mangasava, a uabɨ isa uan aposelbar aka. Egha a bizir avɨribar men akazɨ, me bar foz, a ua dɨkavigha iti. 40 plan dughiaba, dughiar kamɨn aven dughiar avɨriba a uabɨ men akakaghava God Bizibagh Ativir Arazimɨn gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Dughiar mam a me ko ikiava, apava mɨgɨrɨgɨar gavgavir kam me ganɨngi, “Ia Jerusalemɨn nguibar ekiam ategh mangan markɨ. Bizir aghuarir nan Afeziam ia danɨngasa akam akɨrizim a izam. Ia a barazi, kɨ an gun ia mɨkeme. Ia a bagh ikɨ. ");
INSERT INTO msy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon dɨpamɨn gumazamiziba rue, ezɨ gurumra ia Godɨn Duamɨn ruegham.” ");
INSERT INTO msy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ezɨ me uari akuvazir dughiamɨn, me an azara, “Ekiam, nɨ dughiar kam atrivim Israel danightɨma, a ua Israelɨn nguazimɨn ganam, o?” ");
INSERT INTO msy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ezɨ Iesus kamaghɨn me mɨgei, “Biziba otivamin dughiaba, nan afeziam uabɨ uan gavgavimɨn da atɨ. Ezɨ ia tizim bagh dughiar an atɨzir kam gɨfoghasa. Kar ian bizim pu. ");
INSERT INTO msy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eghtɨ Godɨn Duam ia gisɨn izɨghɨrɨghtɨ, ia an gavgavim iniam; eghtɨ ia bizir ia ganigha foziba, Jerusalemɨn nguibamɨn aven ko, Judian danganiba bar moghɨra ko, Samarian Distrigh ko, nguazir kamɨn oteviba bar, me geghanam.” ");
INSERT INTO msy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ezɨ Iesus kamaghɨn mɨkemegha, egha an aposelba garavɨra itima God anesiarafazɨma a Godɨn Nguibamɨn ghuavanabo. Ezɨ ghuariam me gari naghɨn a modo. ");
INSERT INTO msy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A ghuavanadima me kogha overiamɨn garavɨra itima, gumazimning korotiar ghurghurimning arughava bemɨra men mɨn tu. ");
INSERT INTO msy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Egha aning kamaghɨn me mɨgei, “Galilin gumaziba, ia tizim bagha kagh tuivighav ikia pɨn overiamɨn gari? Gumazir kam Iesus, God a inizɨma a ia ategha uan Nguibamɨn ghu. Ia an ganizɨma a Godɨn Nguibamɨn ghuzɨ moghɨn, kamaghɨra a uamategham.” ");
INSERT INTO msy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Egha Iesusɨn aposelba Olivɨn Mɨghsɨam ateghava ua Jerusalemɨn zui. Olivɨn Mɨghsɨar kam Jerusalemɨn roghɨra ikiava an ruarim kilomitan vamɨran mɨrara ghu. ");
INSERT INTO msy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Egha me otivighava, ghuriar pɨn itir me zurara itimɨn ghuavanabo. Men ziabara kara: Pita, Jon, Jems ko Andru, Filip ko Tomas, Batolomyu ko Matyu, Jems, Alfiusɨn otarim, ko Saimon a Selotiabar gumazir mam, ko Judas, a Jemsɨn otarim. ");
INSERT INTO msy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Egha me zurara navir vamɨra ikia uari inigha God ko mɨgei, amizir maba ko Maria, Iesusɨn amebam, koma an doziba sara. ");
INSERT INTO msy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dughiar kabar aven Pita nɨghnɨzir gavgavim Iesusɨn itir darasi tongɨn tugha, (men avɨrimɨn dɨbobonim 120) ");
INSERT INTO msy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","egha kamaghɨn mɨgei, “Nan adarasi, Godɨn Duam fomɨra Devit gamizɨ, an akar mam mɨkeme. Ezɨ akar kam Godɨn Akɨnafarimɨn aven iti. Akar kam a Judasɨn mɨgei. Judas, a gumazir Iesus isa gumazir an suirazibar akazim. Akar kam datɨrɨghɨn otogha gɨfa, Devit mɨkemezir moghɨra. ");
INSERT INTO msy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas fomɨra en gumazir mamra, egha uaghan ingangarir e amir kam gami.” ");
INSERT INTO msy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ivezir a uan arazir kuramɨn inizim, Judas nguazir mam givese. Egha nguazir kamɨn a uabɨ ekunigha aremegha an mɨkarzim afoaraghɨrɨ, ezɨ an muriaba bar azenim gire. ");
INSERT INTO msy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kamaghɨn amizɨ, Jerusalemɨn itir darasi bar moghɨra bizir kam baraki, egha me nguazir kam uan akamɨn ziar kam a gatɨ, Akeldama. An mɨngarim kamaghɨn, ghuzir nguazim.) ");
INSERT INTO msy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Egha Pita ghua kamaghɨn mɨgɨa ghaze, “Ezɨ Godɨn Akɨnafarimɨn itir Ighiabar aven osizirir kam iti, ‘An danganim pura ikɨ, tav an danganir kamɨn ikian markɨ.’ Egha a uaghan ghaze, ‘A gumazir dapanim, eghtɨ igharaz tav an danganim ini.’ ");
INSERT INTO msy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Ezɨ kamaghɨn, e gumazir zurara e ko ikia uaghan Iesus ko aruizir gumazitam a mɨsɨvam. ");
INSERT INTO msy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Dughiar Jon gumaziba ruezim ko Iesus faragha ingangarim igiamra a gamir dughiam ikegha, ghua dughiar God Iesus inizɨ an e ategha ghuavanabozir dughiamɨn tu. E dughiar kaba bar e ko ikezir gumazitam a mɨsɨvam. Gumazir kam Iesusɨn garima, a ua dɨkafi. An e ko mɨgɨrɨgɨar kamɨn gun akam akunam.” ");
INSERT INTO msy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Egha me gumazir pumuningɨn ziamning dɨboro, Josep, an ziar mam Barsabas (an ziar igharazir mam Jastus) ko Matias. ");
INSERT INTO msy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Egha me God ko mɨgei, “Ekiam, nɨ gumazibar navir averiaba bar dagh fo. Nɨ en akagh, nɨ aningɨn tav amɨseveghtɨma, an aposelɨn ingangarim bagh Judasɨn dangamin iniam. Ingangarir kam Judas anetegha uan danganir ikiamimɨn ghu.” ");
INSERT INTO msy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Egha me dagɨaba aningɨn ziamning osirigha torim gatɨgha aning givazvasi. Ezɨ dagɨar Matiasɨn ziam gisɨn itim faragha azenim girɨ. Ezɨ me Matias isa, uaghan 11 pla aposelbar tongɨn anetɨ. ");
INSERT INTO msy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ezɨ Pentikosɨn Dughiar Ekiam otozɨma, nɨghnɨzir gavgavim Iesusɨn itir darasi, me bar moghɨra uari akuvagha danganir vamɨran iti. ");
INSERT INTO msy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ezɨma zuamɨra nɨgɨnir mam Godɨn Nguibamɨn ikeghava zaghira mati amɨnir gavgavim izi. Egha dɨpenir me apiaghav itim bar a gizɨvagha a noke. ");
INSERT INTO msy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Egha me garima bizir mam mati avir mɨzariaba bɨaghɨrava vaghvagha men dapanir siriabagh apiaghiri. ");
INSERT INTO msy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ezɨ Godɨn Duam bar moghɨra me gizɨvaghava, gavgavim me ganɨga me gamima, me nguibar igharazibar akabav gei. ");
INSERT INTO msy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ezɨ Judan gumazamizir Godɨn apengan itir maba, me uan nguazimɨn itir kantriba bar dar ikegha izegha datɨrɨghɨn Jerusalemɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Egha me nɨgɨnir kam baregha iza bar uari akuvaghav ikiava, me vaghvagha orazima gumazamiziba men nguibabar akabav gei. Ezɨ kamaghɨn me osemegha okam nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Egha me dɨgavir kuram gamighava azangsɨsi, “Gumazamizir mɨgeir kaba, me bar Galilin gumazamizibara! ");
INSERT INTO msy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ezɨma manmaghɨn amizima e vaghvagha me barazima me en nguibabar akabav gei? ");
INSERT INTO msy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","E marazi, Partian kantri ko Midian kantri ko Elamɨn kantribar ize. Ezɨ marazi Mesopotemian Distrighɨn izezir gumaziba. Ezɨ marazi Judian Distrigh ko Kapadosian Provins ko Pontusɨn Provins koma Esian Provinsɨn ize. ");
INSERT INTO msy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ezɨ maba Frigian Distrigh ko Pampilian Provinsɨn ize. Ezɨ marazi Isipɨn kantri, ko Libian Distrighɨn aven itir danganim a nguibar ekiam Sairinin boroghɨra itiba ize. Ezɨ marazi Judan gumazir Romɨn nguibamɨn ikegha izeziba. ");
INSERT INTO msy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","E bar moghɨra, Judaba ko Kantrin Igharazibar Gumaziba, me Judan arazibagh amuava dar gɨn ghua, egha me uaghan, mati en marasi. Ezɨma en marazi Kritian arighatɨzim koma Arebian Distrighɨn gumaziba, e vaghvagha me barazima me en nguibabar akabar God amizir bizir ekiabar gun mɨgei!” ");
INSERT INTO msy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Egha Judan gumaziba dɨgavir kuram gamighava pura okam nɨghnɨghava uarir azangsɨsi, “Kar bizir tizim?” ");
INSERT INTO msy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ezɨma Judan gumazir maba dɨbovir akabar mɨgɨa ghaze, “Me wainɨn dɨpar avɨriba amegha ongani.” ");
INSERT INTO msy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ezɨ Pita 11 plan aposelba ko tughav ikia, egha a gumazamiziba pamtem kamaghɨn me mɨgei, “Ia Judaba koma Jerusalemɨn itir gumazamiziba, ia bar deraghvɨram na baragh. Kɨ bizir otozir kamɨn gun ia mɨkemeghtɨma, ia a gɨfogham. ");
INSERT INTO msy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gumazir kaba wainɨn dɨpamɨn onganizir puvatɨ. Ia fo, kar 9 kloghɨn mɨzarazimra. ");
INSERT INTO msy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bizir otozir kam, kar Godɨn akam inigha izir gumazim Joel fomɨra mɨkemezir moghɨn, ");
INSERT INTO msy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God kamaghɨn mɨgɨa ghaze, Dughiar gɨn izamibar kɨ uan Duam gumazamiziba bar me danɨngam. Eghtɨma ian otariba ko guiviba Godɨn akam inigha izir gumazibar mɨn mɨkɨmtɨma, ian gumazir igiaba irebabar mɨn bizibar gantɨma, ian gumazir ghuriba irebabar ganam. ");
INSERT INTO msy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eghtɨ nan ingangarir gumazamiziba, kɨ uaghan uan Duam dughiar kabar me danɨngam, eghtɨma me Godɨn akam inigha izir gumazibar akabav kɨmam. ");
INSERT INTO msy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eghtɨ kɨ pɨn overiamɨn dɨgavir kuram gamir arazibar akakagh, egh nguazimɨn mirakelɨn arazibar amuam. Eghtɨ ghuzim ko avim ko muturir dafam otogham. ");
INSERT INTO msy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Eghtɨma aruem mɨtarmeghtɨ, iakinim ghuzimɨn mɨn otogham. Bizir kaba faragh otivightɨ, gɨn Ekiam Izamin Dughiam otivam. Dughiar kam Ekiam uan gavgavim ko angazangarim sara izam. ");
INSERT INTO msy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ezɨ Ekiamɨn ziamɨn deir darasi, a ua me inigham.’ ");
INSERT INTO msy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Israelɨn gumazamiziba, ia mɨgɨrɨgɨar kam baragh. Nasaretɨn Iesus, God ia baghava anemadagha gavgavim a ganɨngizɨma, ezɨma a ian aven ingangarir gavgavir ekiaba koma mirakelɨn gavgavibar ian tongɨn bizibagh amizɨma, da otivizɨma ia dar ganigha uari fo. ");
INSERT INTO msy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","God uan ifongiamɨn gɨn ghua ia bagha fomɨra nɨghnɨzir mam gamigha, uan otarim isava ian agharim gatɨ. Ezɨma ia gumazir kurabar agharimɨn, ia a isava ter ighuvim gatɨghava a gafuzɨ, an areme. ");
INSERT INTO msy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ovevem bar Iesusɨn suiraghan kogham. Kamaghɨn, God a gamizɨ a dɨkavigha ovevemɨn osɨmtɨzim ataki. ");
INSERT INTO msy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Devitɨn Ighiabar Akɨnafarim kamaghɨn mɨkeme, ‘Kɨ Ekiamɨn garima a zurara bar nan boroghɨn ikiavɨra iti. A gavgavim na ganɨdi. Eghtɨ bizitam na damutɨ, kɨ akongɨva atiatiatingan kogham. ");
INSERT INTO msy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Ezɨma nɨ na ateghtɨma kɨ ariaghrezibar tongɨn mozimɨn aven ikian kogham. Egh nɨ ua bagha inabazir gumazim aneteghtɨma an nivafɨzim kurighan kogham. Kamaghɨn nan navim derazɨ kɨ mɨgɨrɨgɨar aghuibagh ami. God na damuamin bizir aghuiba, kɨ da bagha mɨzuai. ");
INSERT INTO msy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nɨ, ikɨrɨmɨrir aghuarim iniamin tuavim, a nan akagha gɨfa. Nɨ na ateghtɨ kɨ nɨ ko ikiam, egh nɨ na damutɨ, kɨ bar akuegham.’ ");
INSERT INTO msy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nan adarasi, kɨ guizbangɨra ia mɨgei, en ovavim Devit aremezɨma me anefa. Ezɨma an dagɨar mozim datɨrɨghɨn e ko ikia kati. ");
INSERT INTO msy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Egha, Devit a Godɨn akam inigha izir gumazir mam, egha a fo, God mɨgɨrɨgɨar gavgavim a ganiga ghaze, ‘Nɨn atrivir danganimɨn kɨ nɨn ovavitam afagham.’ ");
INSERT INTO msy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","God gɨn damuamin bizim, Devit a gɨfo, a Gumazir God Uam E Iniasa Mɨsevezim, Krais, an aremegh ua dɨkavamin bizim mɨgei. Egha ghaze, God aneteghtɨma an ariaghrezibar tongɨn mozimɨn aven ikian kogham. Egh an nivafɨzim kurighan kogham. ");
INSERT INTO msy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ezɨ gumazir kam Iesus, God a gamizɨma a ua dɨkafi. Ezɨ e uari uan damazibar an ganigha, egha mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ezɨma a ghuavanaga uan Afeziam Godɨn agharir guvim gaperaghav ikia a da pɨn gavgavim isi. Ezɨ an Afeziam a mɨkemezir moghɨn God uan Duam Iesus ganɨngi. Ezɨ datɨrɨghɨn ia oragha garir bizir kaba, Iesus uabɨ dagh ami. ");
INSERT INTO msy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devit Iesusɨn mɨn Godɨn Nguibamɨn ghuzir puvatɨ. Egha a kamaghɨn mɨgei, ‘Ekiam kamaghɨn nan Ekiamɨn mɨgɨa ghaze, “Nɨ kagh nan agharir guvimɨn daperagh. ");
INSERT INTO msy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Mamaghɨra ikɨtɨma kɨ nɨn apaniba dɨkabɨraghtɨ me nɨn apengan ikiam.” ’ ");
INSERT INTO msy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Ezɨ kamaghɨn amizɨ, ia Israelba ia bar bizir kam gɨfo, ia mɨsuegha ter ighuvimɨn gurazir Iesusɨn kam, datɨrɨghɨn God a gamizɨ an Ekiamɨn oto, a Krais, God Uam E Iniasa Mɨsevezir Gumazim.” ");
INSERT INTO msy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Egha gumazamiziba Pitan akam barasi, a men navibagh kuizɨ, me kamaghɨn Pita koma aposelɨn igharazibav gei, “En aveghbuaba, e manmaghɨn damuam?” ");
INSERT INTO msy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ezɨ Pita kamaghɨn me mɨgei, “Ia bar navibagh iragh Krais Iesusɨn ziamɨn rueghtɨ a ian arazir kuraba gɨn amangtɨ, God uan Duam ia danɨngam. ");
INSERT INTO msy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God fomɨra akam akɨrigha ghaze, a uan Duam ia danigam, ia koma, ian boriba koma, ian saghon itir darasi, me bar. God, en Ekiam, gumazamizir a men diaziba, a uan Duam me danɨngam.” ");
INSERT INTO msy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Egha Pita mɨgɨrɨgɨar avɨribar me gamuava akar gavgavir maba sara me mɨkeme, “Ia uari uarir akuragh, eghtɨ God dughiar kamɨn gumazamizir kurar kabagh asɨghasɨghɨva uaghan ia gasɨgasɨghan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ezɨma gumazamizir avɨriba an akam baregha a gifuegha, egha rue. Ezɨ dughiar kamnagh God ua 3,000ɨn gumazamizir maba ua me inizɨma me Kraisɨn adarazir aven ize. ");
INSERT INTO msy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Egha Kraisɨn adarasi me aposelbar mɨgɨrɨgɨaba baragha, bizibar uarir akurvagha, egha uari isava apava, God ko mɨkɨmasa bar ifonge. ");
INSERT INTO msy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ezɨ aposelba dɨgavir kuram gamir arazir avɨriba ko mirakelɨn avɨribagh ami. Kamaghɨn gumazir avɨriba dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Eghava nɨghnɨzir gavgavim Iesusɨn itir darasi, navir vamɨra iti. Egha men bizir men itiba, me uarira akurvasi. ");
INSERT INTO msy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Egha me uan nguaziba ko biziba amaga dar dagɨaba isava egha dagheba otevezibar akurvasi. ");
INSERT INTO msy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zurara dughiaba me Godɨn Dɨpenimɨn avɨzim uari akufi. Egha dɨpeniba roa vaghvagha dagh arua, uari isava apava, bar akongegha, men naviba bar dera. ");
INSERT INTO msy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Egha Godɨn ziam fema, ezɨ gumazir igharaziba bar me bagha bar akonge. Ezɨma Ekiam zurara dughiabar gumazamizir igiabar akurvaghavɨra iti. Kamaghɨn me bar avɨraseme. ");
INSERT INTO msy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Dughiar mam aruem 3 kloghɨn tu, kar Judaba God ko mɨgeir dughiam. Dughiar kamra Pita ko Jon Godɨn Dɨpenimɨn zui. ");
INSERT INTO msy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ezɨ gumazir navimɨn averara suem ikuvizir mam iti. Ezɨ gumaziba anetera ghua Godɨn Dɨpenimɨn tiar akar mamɨn anerɨsi. Tiar akar kamɨn ziam, Aghuim. A kagh ikiava dagɨaba bagha gumazamizir Godɨn Dɨpenimɨn aven zuiba me ginge. ");
INSERT INTO msy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ezɨ a gari Pita ko Jon aven mangasa izima a dagɨaba bagha aning ginge. ");
INSERT INTO msy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ezɨ Pita bar anarɨra gari, ezɨ Jon uakan. Egha Pita ghaze, “Nɨ kagh gan ganigh!” ");
INSERT INTO msy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ezɨ gumazim bizitam iniasa nɨghnɨgha, aningra gari. ");
INSERT INTO msy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ezɨ Pita kamaghɨn mɨgei, “Kɨ dagɨaba puvatɨ. Kɨ itir bizim, kɨ nɨ danɨngasa. Eghtɨ, Nasaretɨn gumazim Krais Iesus, an ziamɨn, nɨ daru!” ");
INSERT INTO msy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Egha Pita an agharir guvimɨn suiraghava, a ghufe. Ezɨ an duiavaniba ko dagariba zuamɨra gavgafi. ");
INSERT INTO msy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ezɨ a dɨkava uabɨ ekunigha maghɨram arui. Egha a Pita ko Jon sarama Godɨn Dɨpenir avɨzibar aven ghuava, aruava, egha pɨn uabɨ ekurava, eghava Godɨn ziam fe. ");
INSERT INTO msy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ezɨma gumazamiziba bar an garima an aruava Godɨn ziam fema, ");
INSERT INTO msy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ezɨ me an ganigha a gɨfogha ghaze, gumazir kamra Godɨn Dɨpenimɨn tiar akar ziam, tiar akar Aghuimɨn apiav ikiava, dagɨaba bagha gumazamizibagh inge. Egha me dɨgavir kuram gamigha pura nɨghnɨsi, manmaghɨn amizir bizim kav bato. ");
INSERT INTO msy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ezɨ gumazamiziba akar kam baregha, egha dɨgavir kuram gamigha, ivemara ghua gumazir kamɨn gari. Ezɨ me an garima a Pita ko Jonɨn suiragha, Godɨn Dɨpenir azuarimɨn tughav iti. Dɨpenir azuarir kamɨn ziam, Solomonɨn Azuarim. ");
INSERT INTO msy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ezɨ Pita kamaghɨn ganigha, me mɨgei, “Israelɨn gumazamiziba, tizim bagha bizir kam ia gamizɨma ia dɨgavir kuram gami? Ia tizim bagha pamtem gan gara ghaze, ga ti uan gavgavibar tuavim, o ga Godɨn damazimɨn deravɨra itir tuavimɨn, ga gumazir kam gamizɨma an arui? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak ko Jekopɨn God, en ovavibar God, a uan ingangarir gumazim Iesus bar a pɨrafa. Ia an aremeghasa a isava apanibar dafarim gatɨ. Egha dughiar Pailat anetaghraghasa mɨgeim, ia kamaghɨn mɨgei, ‘E tong a gifongezir puvatɨ!’ Egha akɨrim a gasara. ");
INSERT INTO msy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ia Godɨn damazimɨn zuegha derazir gumazimɨn aghuaghava, egha gumazir kuram uari bagh anetaghraghasa Pailat mɨgei. A gumazibav soghezɨ me aremezir gumazim. ");
INSERT INTO msy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ia gamizɨ ia angamra itir gumazim, ia a mɨsoghezɨ an aremezɨ God a gamizɨ a ua dɨkafi. Ga uaning bizir kamɨn ganighava a gɨfoghava an gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ga Iesusɨn ziamɨn nɨghnɨzir gavgavim iti. Ezɨ Iesusɨn ziamɨn gumazir ia ganigha fozir kam, a gavgavim ini. Iesusra gan nɨghnɨzir gavgavir kam gamizɨma, ezɨ nɨghnɨzir gavgavir kamra gumazir kam gamizɨma, a bar dera, ia datɨrɨghɨn uari an gari. ");
INSERT INTO msy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ezɨ nan adarasi, kɨ kamaghɨn fo, ia amizir arazim ia a gɨfozir puvatɨ, ian gumazir dapaniba sara. ");
INSERT INTO msy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ezɨ God fomɨra an akam inigha izir gumaziba bar me mɨkemezɨma, me mɨgɨa ghaze, a God Uam E Iniasa Mɨsevezir Gumazim, Krais, mɨzazim iniam. Ezɨ God uan mɨgɨrɨgɨabagh amizɨ moghɨn dar dagheba otifi. ");
INSERT INTO msy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","“Ia kamaghɨn ifueghtɨma, God ian arazir kuraba angarightɨ dughiar kabar Godɨn Duam izɨva ian duaba avughsɨzim ko navir amɨrizim, ia danightɨ, God ia bagh Iesus uam anemangam, a Gumazir God Uam E Iniasa Mɨsevezim, a ia bagha anemɨsefe. Ia bizir kabagh nɨghnɨgh da inisɨ, ia uan navibagh iraghɨva uamategh God bagh izɨ. ");
INSERT INTO msy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","God fomɨra uan akam inigha izir gumazir zuezibav kemezɨma, me ghaze, ‘Iesus datɨrɨghɨn Godɨn nguibam ikɨ, mangɨ dughiar God bizibar amutɨ da bar igiabar otivam.’ Eghtɨ God mɨkemezir moghɨn, biziba bar otivam. ");
INSERT INTO msy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ezɨ akar dɨkɨrɨzir kam God fomɨra Moses mɨkemezɨ, a kamaghɨn mɨgei, ‘Ekiam ian God, a nan mɨn ia bagh akam inigha izir gumazitam, ian tongɨn ian gumazitamra mɨsevegham. Ia, bizir tizir a mɨgeiba, ia bar da baragh egh dar amu. ");
INSERT INTO msy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","A barazir puvatɨziba God me gasɨghasigham. Eghtɨ me ua Godɨn adarazi ko ikian kogham.’ ");
INSERT INTO msy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Godɨn akam inigha izir gumaziba bar, Samuelɨn tugha izi, me bar mɨgɨa dughiar kabar gun mɨkeme. ");
INSERT INTO msy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","“God fomɨra uan akam inigha izir gumaziba akar gavgavim me ganɨngizɨma, ezɨ ia men boriba mɨn ikɨ, egh akar gavgavir kabanang uaghan iana. God fomɨra Akar Dɨkɨrɨzir Gavgavir ian ovaviba ko ingarizɨma, ezɨ ia men boriba mɨn ikɨ, egh akar gavgavir dɨkɨrɨzir kam, a uaghan iana. God kamaghɨn Abraham mɨkemezɨ moghɨn, ‘Kɨ kamaghɨn damuam, nɨn ovavibar borimɨn tuavimɨn, kɨ nguazir kamɨn itir nguibaba bar deravɨra me damuam.’ ");
INSERT INTO msy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","God kamaghɨn ifonge, ia vaghvagh uan arazir kuraba ateghtɨ, kamaghɨn a deravɨra ia damuam. Egha bizir kam bagha a uan ingangarir gumazim a mɨsevegha ia bagha faragha anemada.” ");
INSERT INTO msy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita ko Jon gumazamizibav gɨavɨra itima, ofa gamir gumaziba ko Godɨn Dɨpenimɨn garir gumazibar ekiam ko Sadyusiba, me izava aning bato. ");
INSERT INTO msy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Egha me fo, Pita ko Jon Iesus aremegha ua dɨkavizir bizir kamɨn gun gumazamizibav gei. Kamaghɨn amizɨma gumazir dapanibar naviba aning bagha bar ikufi. ");
INSERT INTO msy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Egha me Pita ko Jonɨn agharimning suiraghava aning kot darɨghasava amima, amɨnim pɨri. Kamaghɨn, me aning sel gatɨzɨ aning ikia ghua amɨmɨzaraghan. ");
INSERT INTO msy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ezɨ gumazamizir avɨriba akar kam baregha nɨghnɨzir gavgavimɨn an iti. Egha Kraisɨn adarazir dɨbobonim bar ekevegha ghua 5,000ɨn boroghɨn tu. ");
INSERT INTO msy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Egha amɨmɨzaraghan Judan gumazir ekiaba ko gumazir dapaniba ko Judan arazibagh fozir gumaziba, me Jerusalemɨn uari akuvaghav iti. ");
INSERT INTO msy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas, ofa gamir gumazibar dapanim, a uaghan iti, ezɨma Kaiafas ko Jon koma Aleksanda koma ofa gamir gumazibar dapanimɨn adarazir gumazir igharaziba, me uaghan iti. ");
INSERT INTO msy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Egha me mɨkemezɨ, gumaziba Pita ko Jon inighava men damazibar izezɨ, me maghɨram aningɨn azangsɨsi, “Gua gavgavir manam inigha, egha tinan ziamɨn gua bizir kabagh ami?” ");
INSERT INTO msy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ezɨma Godɨn Duam Pita gizɨvazɨma, a kamaghɨn me mɨgei, “Judan gumazir ekiaba ko gumazir dapaniba! ");
INSERT INTO msy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ia ti gumazir suer kurar ga akurazir kam bagha gan azangsɨghasa, egha ia ti uaghan foghasa, gumazir kam a manmaghɨn dera. ");
INSERT INTO msy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Eghtɨ ia koma Israelɨn itir darasi bar moghɨra, ia bizir kam gɨfogh! Kar Nasaretɨn gumazim Krais Iesusɨn ziamɨn gumazir ian damazibar tughav itim a ua dera. Gumazir kam a Iesus, ia a inigha ter ighuvim gafuzɨ, an aremezɨ God a gamizɨ a ua dɨkafi. ");
INSERT INTO msy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ezɨma Iesus, ‘Kar dɨpenir akɨnir ingangarir gumaziba aghuazim, a datɨrɨghɨn dɨpenim aterir guarim gava.’ ");
INSERT INTO msy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nguazir kamɨn gumazitam en akuraghan kogham, bar puvatɨ. Iesusɨn ziamra e akurvazir aghuim iniam. A uabɨra, en akurvazir gumazim.” ");
INSERT INTO msy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Egha me Pita ko Jonɨn garima aning bar gavgavighav atiatir puvatɨghava me mɨgeima, me aningɨn ganighava fo, aning sure gamizir puvatɨ. Aning pura gumazir kɨnimning. Egha me aningɨn gara dɨgavir kuram gamigha ghaze, gumazir kamning Iesus koma arui. ");
INSERT INTO msy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Egha me gumazir faragha suer ikuvizimɨn gari, a Jon ko Pita, aning ko tughav itima, me bizitam mɨkɨman asa. ");
INSERT INTO msy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kamaghɨn me akar gavgavimram aning ganɨngizɨma aning Judan kotɨn dɨpenim ategha zuima, me aning bagha akam mɨsosi. ");
INSERT INTO msy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Egha me uarir azangsɨsi, “E manmaghɨn gumazir kamning damuam? Jerusalemɨn itir gumaziba, me fo, aning mirakelɨn bar ekiam gami. Eghtɨ e kamaghɨn mɨkɨman kogham, bizir kam guizbangɨra otozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ezɨ e kamaghɨn aghua, gumazamizir igharaziba bizir kam baraghan kogham. Egh e akar bar gavgavimra aning danightɨma aning ua Iesusɨn ziamɨn gun bar tav mɨkɨman kogham.” ");
INSERT INTO msy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Egha me ua aningɨn diazɨma aning aven ghuzɨma me akar gavgavimɨn aningɨn mɨgɨa ghaze, gua uamateghɨva Iesusɨn ziamɨn gun mɨkɨmɨva egh gumazitabar sure damuan bar markɨ. ");
INSERT INTO msy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","20","Ezɨma Pita ko Jon men akam ikaragha mɨgei, “Ga uaning ganighava oraghizir biziba ga dar ghuangsɨghan kogham, ga dar gun mɨkɨmvɨra ikiam. Ia uari nɨghnɨgh, arazir manam Godɨn damazimɨn dera, ga Godɨn akam baragham, o ga ian akam baragham?” ");
INSERT INTO msy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Gumazir Pita ko Jon Godɨn gavgavimɨn amizir derazim, a 40 plan azenibagh afira. Kamaghɨn gumazamiziba uari bizir kabar gari da otivizɨma, me Godɨn ziam fe. Kamaghɨn amizɨma, gumazir dapaniba ivezir kuram aning danɨngasa pura nɨghnɨsi, me manmaghɨn aning damuam. Egha me atiatir mɨgɨrɨgɨaba ko mɨgɨrɨgɨar gavgavibar maba uam aning gamighava aning amadazɨma aning zui. ");
INSERT INTO msy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ezɨma Judan kotɨn aven itir gumaziba Pita ko Jon ataghizɨma aning azenim girɨgha uamategha uan adarazi bagha ghu. Egha aning ofa gamir gumazir ekiaba ko gumazir dapaniba aningɨn mɨkemezir akabar gun uan adarasi bar me mɨkeme. ");
INSERT INTO msy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ezɨ me kamaghɨn oreghava uari akuvaghava God ko mɨgei. Me kamaghɨn mɨgei, “En Ekiar en garim, nɨ overiam ko nguazimɨn ingarighava, ongarim sara ingari, egha dar itir biziba sara, bar dar ingari. ");
INSERT INTO msy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fomɨra nɨn Duam akar mam en ovavim Devit, a nɨn ingangarir gumazim, nɨ akar kam a ganɨngi. Ezɨ Devit kamaghɨn mɨkeme, ‘Ezɨma Kantrin Igharazibar Gumaziba tizim baghava atari? Egha me tizim bagha arazir kurabar amuasava akabav sosi? ");
INSERT INTO msy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ezɨma nguibabar atriviba me God mɨsoghasava ami. Ezɨma gumazir dapanir ekiaba uari inigha Ekiam mɨsoghasa. Egha uaghan God Uam E Iniasa Mɨsevezir Gumazim mɨsoghasa.’ ");
INSERT INTO msy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Bar guizbangɨra, Herot ko Pontius Pailat, Israelɨn gumaziba, Kantrin Igharazibar Gumaziba sara, me Jerusalemɨn nguibamɨn uari akuvaghava arazir kurabar Godɨn ingangarir gumazir zuezim, Iesus damuasava akabav sosi. A nɨ fomɨra uan ingangarim bagha inabazir gumazim. ");
INSERT INTO msy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Me nɨn gavgavim ko nɨn nɨghnɨzimɨn gɨn zui, nɨ fomɨram otivasa mɨkemezir biziba. ");
INSERT INTO msy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eghtɨ, Ekiam, me atiatir akar e ganɨngizibagh nɨghnɨgh. Egh en akuraghtɨma e tugh gavgavigh atiatingan kogh nɨn akam kunam. ");
INSERT INTO msy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Egh nɨ uan agharim arɨmariar gumazibar arɨghtɨma me deragham. Egh nɨ mirakelɨn avɨribar bizibar amutɨma da Iesusɨn ziamɨn otivam, a nɨn ingangarir gumazir zuezim.” ");
INSERT INTO msy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Egha me Afeziam ko mɨkemegha gɨvazɨma, danganir me itim ivazvazima, me bar moghɨra Godɨn Duam me gizɨvazɨma, me atiatir puvatɨgha Godɨn akam kuri. ");
INSERT INTO msy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Egha nɨghnɨzir gavgavim Iesusɨn itir darasi, me bar navir vamɨra ko nɨghnɨzir vamɨra iti. Men tav uabɨra uan bizitam gamir puvatɨ, me uari inighava biziba bar moghɨra dagh ami. ");
INSERT INTO msy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Egha aposelba Iesus aremegha ua dɨkavizir bizir kamɨn gun gumazamiziba, Godɨn gavgavimɨn amodoghɨn me mɨgei. Ezɨ Godɨn apangkuvir ekiamra me ko iti. ");
INSERT INTO msy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Kamaghɨn men tav bizitamɨn otevezir puvatɨ. Ezɨma gumazir nguaziba ko dɨpeniba itiba, me da amaga dar dagɨaba isa izava, aposelbagh anɨdima, me da isava gumazir biziba puvatɨzibar akurvasi. ");
INSERT INTO msy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Gumazir mam Josep, a Livan gumazim. Ezɨ aposelba Barnabas a garɨsi. An mɨngarim kamaghɨn ghu, gumazibar akurvagha gavgavim me ganɨdir gumazim. Barnabas Saiprusɨn nguibar arighatɨzimɨn ize. ");
INSERT INTO msy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A uan nguazir mam amadagha, an dagɨaba inighava aposelbagh anɨngi. ");
INSERT INTO msy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gumazir mam Ananaias, an amuim Safaira, aning uaghara fuegha uan nguazir mam amadagha an ivezim ini. ");
INSERT INTO msy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Egha aning uaghara bar fogha, Ananaias dagɨar maba ua bagha dar suira. Egha naba inigha aposelbagh ifaragha me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ezɨ Pita kamaghɨn Ananaias mɨgei, “Nɨ manmagh sua, Satan ataghizɨma a nɨn navim gizɨvazɨ, nɨ Godɨn Duam gifari? Egha nguazir ivezimɨn dagɨar maba nɨ ua bagha dar suira? ");
INSERT INTO msy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kar nɨn nguazim, nɨ uabɨ ifuegha anemada. An ivezimɨn dagɨaba uaghan nɨn dagɨabara. Nɨ manmaghɨn nɨghnɨgha an dagɨar kabar e gifari? Nɨ gumazibagh ifari puvatɨ, nɨ God gifari.” ");
INSERT INTO msy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ezɨ Ananaias kamaghɨn oregha degiaghrɨgha areme. Ezɨ gumazamiziba bizir kam baregha atiatir ekiam me ini. ");
INSERT INTO msy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ezɨ gumazir igiaba izava an kuam nomkegha a inigha azenan ghuava a mozim gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ezɨ kloghɨn auan pumuning ko mɨkezim gɨvazɨ, an amuim fozir puvatɨgha aven izi. ");
INSERT INTO msy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ezɨ Pita an azara, “Nɨ na mɨkɨm, kar nguazir ivezim, nɨ Ananaias ko gua a ini?” Ezɨ a kamaghɨn mɨgɨa ghaze, “Are, bar an ivezimra.” ");
INSERT INTO msy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ezɨ Pita kamaghɨn a mɨgei, “Gua manmagh sua vɨrara fuegha Godɨn Duam gifari? Nɨ gan! Gumazir nɨn pam mozim gatɨziba, me tiar akamɨn iti. Egh me uaghan nɨn kuam inigh azenan mangam.” ");
INSERT INTO msy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ezɨ Pita mɨgɨavɨra itima, Safaira an suemningɨn irɨghava areme. Ezɨ gumazir igiaba aven iza garima an aremezɨ me a inigha azenan ghugha an pamɨn mozimɨn mɨriamɨn anefa. ");
INSERT INTO msy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ezɨma atiatir ekiam Kraisɨn adarazi bar me batozɨ, gumazir bizir kaba baraghiziba uaghan bar atiatingi. ");
INSERT INTO msy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Aposelba mirakelɨn avɨriba ko dɨgavir kuram gamir bizir avɨriba, gumazamizibar tongɨn dagh ami. Ezɨ nɨghnɨzir gavgavim Iesusɨn itir gumazamiziba, me Solomonɨn Azuarimɨn zurara uari akufi. ");
INSERT INTO msy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gumazir igharaziba, me ko poghasa tong nɨghnɨzir puvatɨ. Me men ziaba fava egha fo, me arazir aghuim gami. ");
INSERT INTO msy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Marazi me ko poghan aghua, ezɨ avɨrim nɨghnɨzir gavgavim Ekiamɨn ikia men aven zuima, men dɨbobonim bar ghuavanabo. ");
INSERT INTO msy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ezɨ kamaghɨn gumaziba arɨmariar gumaziba inigha men mɨsiaba ko akuriaba sara me atera izava tuavimɨn mɨriamɨn me arɨsi. Me kamaghɨn nɨghnɨzir gavgavim iti, Pitan nedazim me gisɨn mangɨtɨ me ua deragham. ");
INSERT INTO msy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ezɨ uaghan Jerusalem torim gatɨzir nguibar dozibar gumazir avɨrim, me uan arɨmariar gumazamiziba inigha ize. Egha uaghan uan gumazamizir duar kuraba apazaziba inigha izezɨma, me bar moghɨra ghuamaghegha dera. ");
INSERT INTO msy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ezɨ ofa gamir gumazibar dapanim ko an akurvazir darasi, kar Sadyusibar aven itir gumaziba. Me aposelba amir biziba bagha navim ikufi. ");
INSERT INTO msy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Egha Sadyusiba men suiragha kalabuziar ekiam gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Me kalabusɨn itima, dɨmangan Ekiamɨn ensel tiaba kuigha me inigha azenan ize. ");
INSERT INTO msy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Egha ensel kamaghɨn mɨgei, “Ia mangɨ, Godɨn Dɨpenir mɨriamɨn avɨzibar tuiva ikɨrɨmɨrir igiar kamɨn mɨgɨrɨgɨaba bar, ia gumazamizibav kɨm.” ");
INSERT INTO msy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ezɨ amɨnim itima aposelba, ensel me mɨkemezɨ moghɨn Godɨn Dɨpenir mɨriamɨn aven ghua, gumazamizibar sure gami. Ezɨ ofa gamir gumazibar dapanim uan akurvaziba ko iza, Judan kotɨn aven itir gumazibar diazɨ, me ghua uari akufa. Israelɨn gumazir dapaniba bar uari akufa. Egha me aposelba inigh izasa kalabusɨn dɨpenimɨn akam anemada. ");
INSERT INTO msy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ezɨ polisɨn maba ghua kalabusɨn dɨpenimɨn otogha garima me kagh puvatɨzɨ, me uamategha izava bizir kamɨn gun mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“E kalabusɨn dɨpenimɨn garima me deravɨra an tiam asarazɨ kalabusɨn dɨpenimɨn garir gumaziba an tiar akamɨn tuivighav iti. Ezɨ e tiaba kuigha garima, tav aven itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ezɨ me ghua bizir kamɨn gun mɨkemezɨ, Godɨn Dɨpenimɨn garir gumazibar dapanim ko ofa gamir gumazir ekiaba pura nɨghnɨsi, bizir tizitam uam otogham? ");
INSERT INTO msy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ezɨ gumazir mam iza ghaze, “Ia oragh! Gumazir ia kalabus gatɨziba Godɨn Dɨpenir mɨriamɨn tughav ikia gumazamizibar sure gami.” ");
INSERT INTO msy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kamaghɨn amizɨma Godɨn Dɨpenimɨn garir gumazibar dapanim uan gumazir a ko ingariba, me ko ghua aposelba inigha izi. Me kamaghɨn atiati, gumazamiziba dagɨabar me ginivigham, egha me pura nɨmɨra me inigha izi. ");
INSERT INTO msy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ezɨ Godɨn Dɨpenimɨn garir gumaziba, me aposelba inigha izegha me mɨgeima, me Judan kotɨn aven itir gumazibar damazimɨn tuifi. Ezɨ ofa gamir gumazibar dapanim me kotɨn iitir bizim bagha men azangsɨsi. ");
INSERT INTO msy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ezɨ ofa gamir gumazibar dapanim kamaghɨn me mɨgei, “E akar gavgavim ia ganɨga ghaze, ia Iesusɨn ziamɨn gumazamizibar sure damuan markɨ! Ezɨ ia orazir puvatɨgha men sure gamima ian suren mɨgɨrɨgɨaba Jerusalem bar a garui. Egha mɨgɨa ghaze, e Iesus mɨsoghezɨ an areme.” ");
INSERT INTO msy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ezɨ Pita aposelɨn igharaziba ko, me kamaghɨn mɨgei, “E God baragham, e gumaziba baraghan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iarara Iesus mɨsuegha ter ighuvimɨn an gurazɨma an areme. Ezɨ en ovavabar God Iesus fezɨ a ua dɨkafi. ");
INSERT INTO msy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ezɨ God a isa uan agharir guvimɨn anetɨzɨma, an Atrivimɨn Otarim ko gumazibar Akurvaghamin Gumazimɨn ikiam. Egha a Israelbar amutɨ me navibagh iraghtɨ God men arazir kuraba gɨn amadagham. ");
INSERT INTO msy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","E God amizir bizir kabar gun mɨgeir gumaziba, ezɨ Godɨn Duam uakan. A baragha an gɨn zuiba, God uan Duam me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Egha Judan kotɨn aven itir gumaziba kamaghɨn aposelbar akam baregha men naviba me bagha bar ikufi. Egha me mɨsueghtɨ me aremeghasa nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ezɨ Farisin gumazir mam Gamaliel, Judan arazimɨn sure gamir gumazir me bar ifongezim. A Judan kotɨn aven dɨkavigha tugha, ghaze, aposelba tong azenan ikegh. ");
INSERT INTO msy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Egha a mɨgɨrɨgɨar kabagh ami, “Israelɨn gumaziba, ia arazitam gumazir kabar amusɨ deravɨra nɨghnɨgh. ");
INSERT INTO msy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Boghɨmra Teudas otogha kamaghɨn uabɨ mɨgɨa ghaze, kɨ gumazir dapanir mam, ezɨ 400ɨn boroghɨra ghuzir gumaziba an gɨn ghue. Ezɨ gavman a mɨsoghezɨ, an areme. Ezɨ an gɨn zuir darazi bar uari aghamsɨki. Ezɨ me amizir bizir kam dagheba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ezɨ an gɨn, gavman gumaziba dɨborir dughiam, Galilin gumazir mam Judas oto. Egha, a gumazir bɨzir mamɨn faragha ghuava me gavman ko mɨsosi. A uaghan aremezɨ an gɨn zuir darasi, me uari aghamsɨki. ");
INSERT INTO msy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kamaghɨn amizɨma datɨrɨghɨn, bizir kamnagh kɨ kamaghɨn ia mɨkɨmasa. Bizitam gumazir kabar amuan markɨ! Me ateghtɨ me mar mangɨ! Ia pura gan, men ingangarim gumazitam gisɨn tughɨva, degeghirɨgham. ");
INSERT INTO msy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Egh me Godɨn tugh bizim damutɨ, ia men anogoroghan kogham. Ia fogh suam, ia God ko mɨsosi.” ");
INSERT INTO msy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ezɨ me Gamalielɨn nɨghnɨzimɨn gɨn ghue. Egha aposelbar diazɨ, me aven ghuezɨ me pura me fozoroke. Egha Iesusɨn ziamɨn bizibav kɨman men anogoregha me ataghizɨ me ghue. ");
INSERT INTO msy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Egha me ghaze, God e bagha bar akongegha en amamangatɨzɨ, e Iesusɨn ziamɨn osɨmtɨziba ini. Egha kamaghɨn me Judan kotɨn aven itir gumaziba ataghragha bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Egha dughiaba zurara me Godɨn Dɨpenimɨn mɨriaba ko dɨpenibar akar aghuim gumazamiziba sure gamuavɨra iti. Egha akam me mɨkɨra ghaze, Iesus a Krais, God Uam E Iniasa Mɨsevezir Gumazim. ");
INSERT INTO msy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Dughiar kabanang Iesusɨn suren gumazamizibar dɨbobonim bar ghuavanadi. Ezɨ suren gumazir maba Grighɨn akam a mɨgei, ezɨ marazi Aramɨn akam mɨgei. Ezɨ Grighba me ghaze, “Dughiar avɨriba ia zurara gumazamizir dagheba puvatɨzibar akurvasi, egha ia en amuir odiaribar akurvazir puvatɨ.” Bizir kam bagha me atari. ");
INSERT INTO msy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ezɨ aposelɨn 12 pla, me suren gumaziba bar men diazɨma me iza uari akuvazɨma, me kamaghɨn me mɨgei, “E Godɨn akam akurir ingangarim ateghɨva dagher ingangarim damuam, kamaghɨn a derazir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kamaghɨn amizɨma, en adarasi, ia uarir tongɨn 7 plan gumaziba mɨsefegh. Men araziba, gumaziba ko amizibar damazibar bar deragha, egh Godɨn Duam me gizɨvazɨ, me uaghan fofozir aghuarim iti. Eghtɨma e me isɨva ingangarir kam datɨghtɨma me an ganam. ");
INSERT INTO msy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Eghtɨ e uari ingangarir kamning damuam, God ko mɨkɨmɨva, Godɨn akar aghuim gumazamizibar sure damuam.” ");
INSERT INTO msy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ezɨ gumazamiziba akar kam baregha bar a gifonge. Egha me Stiven amɨsefe, a gumazir bar nɨghnɨzir gavgavim itim, ezɨ Godɨn Duam bar a gizɨfa. Ezɨ me Filip, Prokorus, Nikanor, Timon, Parmenas ko Nikolas me amɨsefe. Nikolas an Antioghɨn gumazim, a Judan gumazim puvatɨ, a faragha Judan arazibagh amuava dar gɨn zui. Egha a datɨrɨghɨn Kraisɨn gɨn zui. ");
INSERT INTO msy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ezɨ me gumazir kaba inigha aposelbar damazimɨn ghuzɨma me dafariba men dapanibagh isɨn atɨgha me bagha God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ezɨ Godɨn akam bar moghɨra ekevegha bar nguibabar ghue. Ezɨ Jerusalemɨn itir suren gumazibar dɨbobonim zuamɨram ekefe. Ezɨma ofa gamir gumazir avɨrim Godɨn akam baregha nɨghnɨzir gavgavim an ikia uaghan an gɨn zui. ");
INSERT INTO msy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ezɨ God guizbangɨra Stiven akuragha, egha apangkuvim ko gavgavim a ganɨngizɨma, a dɨgavir kuram gamir araziba ko mirakelɨn araziba gumazamizibar torimɨn a dagh amima a da otifi. ");
INSERT INTO msy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Egha marazi dɨkavigha Stiven ko me akamɨn mɨgɨrɨgɨabar uari adosi. Me Judan God ko mɨgeir dɨpenir mamɨn gumaziba, dɨpenir kamɨn ziam, Friman. Me Sairinin nguibamɨn gumaziba, ko Aleksandrian nguibamɨn gumaziba, ko Silisian Provins ko Esian Provinsɨn gumaziba. Me Stiven ko uari adosi. ");
INSERT INTO msy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ezɨ Godɨn Duam fofozir aghuim isava Stiven ganɨngi. Kamaghɨn amizɨ, Judan gumaziba an akaba ko mɨkɨman ibura. ");
INSERT INTO msy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ezɨ me mogava, gumazir mabagh ifarasa me abɨra ghaze, ia kamaghɨn mɨkɨm, “E orazima Stiven mɨgɨrɨgɨar kurabar Moses ko God gami.” ");
INSERT INTO msy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ezɨ arazir kamɨn me gumazamiziba, gumazir dapaniba ko Judan arazibagh fozir gumazibar navibagh amima da dɨkafi. Ezɨ me Stiven bagha ghughava an suiragha a inigha Judan kotɨn aven itir gumazibar damazimɨn ghue. ");
INSERT INTO msy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Egha me mɨgɨrɨgɨar ifavarir tabar a damuasa gumazir maba ini. Gumazir kaba kamaghɨn mɨgei, “Gumazir kam zurara akar kuraba Godɨn Dɨpenim ko Judan arazibagh asi. ");
INSERT INTO msy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","E orazima a kamaghɨn mɨgei, ‘Gumazir kam Nasaretɨn gumazim, Iesus, a Godɨn Dɨpenir kam apɨrighɨva a gasɨghasɨgh, egh arazir Moses fomɨra e ganɨngiziba otɨvkɨnigham.’” ");
INSERT INTO msy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ezɨ Judan kotɨn aven itir gumaziba bar moghɨra apiaghav ikiava damaziba bar pamtem Stiven gari. Egha me garima an guam mati enselɨn mɨn taghtasi. ");
INSERT INTO msy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ezɨ ofa gamir gumazir dapanim Stivenɨn azara, “Me nɨ gasir akar kaba, da guizbangɨra, o?” ");
INSERT INTO msy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ezɨ Stiven me ikara, “Nan aveghbuaba ko nan afeziaba ia na baragh! En ovavim Abraham, a tɨghar Haranɨn mangam, a Mesopotemian kantri ikiavɨra itima angazangarim itir God, a bato. ");
INSERT INTO msy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Egha a mɨgɨa ghaze, ‘Nɨ uan adarazi koma uan nguazim ategh egh nguazir kɨ nɨn akaghamimɨn mangɨ.’ ");
INSERT INTO msy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Ezɨma Abraham Kaldian nguazim ategha Haranɨn nguazimɨn ikiasa zui. Ezɨ an afeziamɨn ovevemɨn gɨn God nguazir ia datɨrɨghɨn itir kamɨn anemada. ");
INSERT INTO msy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God tong nguazir otevitam atugha a uan adarazi ko, me ganɨngizir puvatɨ. God a ko akam akɨra ghaze, a ko an ovavir gɨn izamiba nguazir kamɨn ikiam. Ezɨ dughiar kamɨn Abraham uabɨ boriba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Egha God kamaghɨn Abrahamɨn mɨgei, ‘Nɨn ovaviba igharazir darazir kantrin ikiam. Eghtɨ me 400 plan azenibar pura men ingangarir gumazibar otivightɨ me paz me damuam. ");
INSERT INTO msy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Eghtɨ kɨ gɨn men arazir kurar me gamim kɨ a ikaragham. Eghtɨ gɨn me kantrin kam ategh azenan izegh, egh danganir kamɨn nan ziam fam.’ ");
INSERT INTO msy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Egha God mɨkarzir mogomem aghorimɨn Akar Dɨkɨrɨzir Gavgavim Abraham koma a gami. Ezɨ Abraham, Aisakɨn afeziamɨn oto, egha amebam a batezɨ, 8 plan dughiabar gɨn Abraham Aisakɨn mɨkarzir mogomem atu. Egha gɨn Aisak Jekopɨn afeziamɨn oto. Ezɨ Jekop en inazir 12 plan afeziam. ");
INSERT INTO msy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","“Ezɨ en inaziba navir averiabar Josepɨn ikuvigha Isipɨn nguibamɨn ingarir gumazimɨn ikiasava anemada. Ezɨ God a ko ikia an osɨmtɨziba a gɨvagha egha an akura. God Josep fofozir bar aghuiba a ganɨngizɨma an arazir aghuarim akakasi, ezɨ Isipbar atrivim bar a gifongeghava egha a gamizɨ a Isipɨn gumazir dapanir ekiamɨn iti. Egha an dɨpenimɨn biziba sara gari. ");
INSERT INTO msy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ezɨ gɨn dagheba otevezir dughiam Isipɨn nguibaba bar ko Kenanɨn nguaziba bar me batifi. Ezɨ gumazamiziba osɨmtɨzir ekiam isi. En inaziba uaghan dagheba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ezɨ Jekop orazima dagheba Isipɨn itima, ezɨ a uan otariba, en inaziba amadazɨma me darorir farazim gamua zui. ");
INSERT INTO msy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ezɨ me darorir gɨn zuimɨn ua zuima Josep uan aveghbuabagh eghara ghaze, ‘Kɨ Josep.’ Ezɨ gɨn atrivim uaghan Josepɨn adarazigh fo. ");
INSERT INTO msy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Egha bizir kamɨn gɨn, Josep uan afeziam Jekop koma an adarazi 75 plan bar me bagha izamin akam amada. ");
INSERT INTO msy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ezɨ Jekop Isipɨn nguibamɨn iraghu. Egha kagh a ko en inaziba ariaghɨre. ");
INSERT INTO msy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ezɨ me men kuaba inigha uamategha Sekemɨn nguibamɨn ua izegha me dagɨar torir mozim garɨki, Abraham fomɨra Sekemɨn nguibamɨn Hamorɨn otariba da ivezezir mozim. ");
INSERT INTO msy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ezɨ God Abraham ko dɨkɨrɨzir akar gavgavim guizbangrama otivasava roghɨra izima, ezɨ en gumazamizir Isipɨn itiba bar avɨraseme. ");
INSERT INTO msy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ezɨ gɨn atrivir igharazim, a Josep tong a gɨfozir puvatɨgha, Isipɨn atrivimɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Egha an en gumazamizibagh ifara arazir kurabar en inazibagh ami. Eghtɨ me uan borir iririviba puram azenan datɨghtɨ, me ariaghrasa a me gakaghori. ");
INSERT INTO msy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Ezɨ dughiar kamɨn Mosesɨn amebam a bate, a Godɨn damazimɨn bar derazir borim. An iakinir pumuning ko mɨkezimɨn uan afeziamɨn dɨpenimɨn iti, me an gari. ");
INSERT INTO msy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Egha gɨn me a inigha azenan anetɨzɨma, atrivimɨn guivim a inigha ghua uan borimɨn mɨrarama an gari. ");
INSERT INTO msy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ezɨ Moses Isipbar fofozir ekiar aghuim inigha egha an araziba ko an mɨgɨrɨgɨaba bar gavgafi. ");
INSERT INTO msy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Egha Moses 40 plan azenibar anetuzɨma, ezɨ a uan adarazi Israelbar ganasa nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Egha a men mavɨn garima Isipɨn mav a mɨsogha bar pazava a gami. Ezɨ a ghua an akuragha, egha a Isipɨn gumazim arazir kuram ikarvagha, a mɨsoghezɨ an areme. ");
INSERT INTO msy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Egha Moses kamaghɨn nɨghnɨsi, an adarazi kamaghɨn fogh suam, God men akurvaghasa nan aven ingari. Ezɨ me bar fozir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Egha amɨmɨzaraghan Moses garima Israelɨn gumazimningra uaning mɨsosi. Ezɨ aning uaning gɨfueghasa a navir amɨrɨzimɨn aning mɨgei, ‘Maning, gua orakigh, gua avetinganing, egha gua tizim bagha kaghɨra uaning mɨsosi?’ ");
INSERT INTO msy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ezɨ gumazir igharazitav sozim, Moses a dugha ghua, egha ghaze, ‘Tina nɨ amɨsevezɨ nɨ en gumazir dapanim ko jasɨn ikiava en gari? ");
INSERT INTO msy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Nɨ boghɨnaron Isipɨn gumazir mɨsoghezɨ an aremezɨ moghɨn, datɨrɨghɨn na mɨsueghtɨ kɨ aremeghasa?’ ");
INSERT INTO msy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ezɨ Moses kamaghɨn oregha Isip ategha ara ghua Midian nguazir igharazimɨn ikia egha borir otarir pumuning ini. ");
INSERT INTO msy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Egha 40 plan azenibar gɨn, Moses nguazir gumaziba puvatɨzimɨn itima, God enselɨn mam a bagha anemada. Enselɨn kam Sainain mɨghsɨamɨn boroghɨn avivzariar tememɨn isi naghɨn purama a bato. ");
INSERT INTO msy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ezɨ a bizir kamɨn ganigha dɨgavir kuram gami. Egha bar roghɨra mangɨ deragh ganasava ami, egha Ekiamɨn tiarim barasi, ");
INSERT INTO msy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kɨ nɨn inazibar God, Abrahamɨn God ko Aisak ko Jekop.’ Ezɨ Moses nɨgha egha ganan atiatingi. ");
INSERT INTO msy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ezɨ Ekiam a mɨgei, ‘Nɨ tughav iti naghɨn, a nan nguazir kɨ a anogoroghezim. Kamaghɨn, nɨ uan dagarir asuaba suegh. ");
INSERT INTO msy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kɨ uan gumazamizibar arazir bar kurar me Isipɨn me gamibar gani. Egha kɨ men arareba baregha, egha men osɨmtɨziba gɨvasa izaghiri. Nɨ izɨ, kɨ ua Isipɨn nɨ amangam.’ ");
INSERT INTO msy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mosesɨn kamra Israelba an aghuagha ghaze, ‘Tina nɨ amɨsevezɨ nɨ en gumazir dapanim ko jasɨn ikiava en gari?’ Ezɨ kar anarɨra, gumazir God uabɨ men gumazir dapanimɨn ikɨ egh ua me iniasava amadazim. E fo, God Moses bagha enselɨn mam amadazɨ ensel temer isim aven otozɨ Moses an gara God amadazir akam ini. ");
INSERT INTO msy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ezɨ a me inigha Isip ateghasava egha mirakelɨn avɨribagh ami. A Isipɨn ko Retsin, dagh ami. Egha gumaziba puvatɨzir danganimɨn a 40 plan azenibar dagh ami. ");
INSERT INTO msy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Egha kar Mosesɨn kamra, a Israelbav gɨa ghaze, ‘God ian tongɨn akam inigh izir gumazitam nan mɨn anemɨsevegham.’ ");
INSERT INTO msy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ezɨ Israelba gumaziba puvatɨzir danganimɨn uari akuvagha itima a men aven iti, a Sainaian mɨghsɨamɨn ghuavanabozɨ ensel a mɨkeme. Ezɨ an akar angamra itim e danɨngasa, a inis. ");
INSERT INTO msy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ezɨ en inaziba Mosesɨn akaba baraghan aghua. Egha me an mɨgɨrɨgɨaba batosi. Egha men navir averiabar aven me uamategh Isipɨn mangasa. ");
INSERT INTO msy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Egha me Aronɨn mɨgei, ‘E fozir puvatɨ, gumazir e inigha Isipɨn azenan izezim, Moses, bizir tizim a bato. Egh, nɨ e bagh marvir guabar ingarightɨma da en faragh mangam.’ ");
INSERT INTO msy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Egha dughiar kamɨn marvir guam me bulmakaun nguzimɨn mɨrarama an ingari. Egha me an ofa gamua egha me uan dafaribar ingarizir bizim bagha isava ighiabagh amua bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ezɨ God akɨrim ragha me gasaragha, egha me ataghizɨ me overiamɨn mɨkovezibar ziaba fe. Akam inigha izir gumazibar akɨnafarimɨn akam an mɨrara ghu. ‘Ia Israelɨn gumaziba, mar ia 40 plan azenibar gumaziba puvatɨzir danganimɨn ikia nan ofa gami? Bar puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ia asem Molekɨn marvir guamɨn aver dɨpenim ia aneteri, egha uaghan asem Refanɨn mɨkovezir nedazim ateragha arui. Kar asemningɨn, ia aningɨn arazibar gɨn mangasa aningɨn ingari. Kamaghɨn amizɨma, kɨ ian nguazimɨn ia batoegh, egh ia amadaghtɨ ia mangɨ Babilonɨn nguazimɨn vongɨn ikiam.’ ");
INSERT INTO msy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ezɨma en inaziba gumaziba puvatɨzir danganimɨn itima Godɨn Averpenim me ko iti. Dɨpenir kamɨn aven me fo, God me ko iti. God Moses mɨkemegha an akazim moghɨra, Israelbav kemezɨ me an ingari. ");
INSERT INTO msy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ezɨ en inaziba Averpenim inigha, egha anetera egha Josuan gɨn izi. Me ghua nguibar igharazimɨn nguazim, God men damazibar me batoghezɨ, me a ini. Averpenir kam me ko ikiavɨra itima Devitɨn dughiam oto. ");
INSERT INTO msy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ezɨ Devit Godɨn damazimɨn derazɨ God deravɨram a gami. Egha a kamaghɨn Godɨn azara, ‘Kɨ Jekopɨn God bagh dɨpenimɨn ingaram, o?’ Ezɨ God ghaze, ‘Puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ezɨ gɨn Solomonra a bagha dɨpenimɨn ingari. ");
INSERT INTO msy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ezɨ Godɨn bar pɨn itim dɨpenir gumaziba ingaribar itir puvatɨ. Godɨn akam inigha izir gumazim kamaghɨn mɨkeme, ");
INSERT INTO msy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘God ghaze, overiam a nan atrivir dabirabim. Ezɨ nguazim kɨ uan suebar asir danganim. Dɨpenir manmagh garim, nɨ na bagha an ingarasa? Ezɨ kɨ avughsamin danganim managh iti? ");
INSERT INTO msy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ezɨ bizir kaba bar, kɨ dar ingari.’” ");
INSERT INTO msy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Egha Stiven maghɨra Judan kotɨn gumazibav gei, “Ia bar orazir puvatɨzir darasi! Egha ian naviba ko nɨghnɨziba mati, God gɨfozir puvatɨzir gumaziba! Ia uan inazibar mɨrarama ami! Ia uaghan Godɨn Duam zurara a batosi! ");
INSERT INTO msy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ian inaziba osɨmtɨziba Godɨn akam inigha izir gumaziba bar moghɨra me garɨki. Ezɨ me fomɨra Godɨn damazimɨn derazir gumazimɨn izirimɨn gun mɨgeima, ian inaziba me mɨsozi me ariaghɨre. Egha datɨrɨghɨn ia a isa gumazir kurabar dafaribagh atɨgha egha a mɨsoghezɨ an areme. ");
INSERT INTO msy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ia enselbar dafaribar Moses Osirizir Araziba inigha, egha a dar gɨn zuir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ezɨ me kamaghɨn oregha, men navir averiaba a bagha bar ikuvigha egha a bagha uan ataribagh ivi. ");
INSERT INTO msy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ezɨ Godɨn Duam Stiven gizɨvazɨma, a kogha Godɨn Nguibamɨn Godɨn angazangarir gavgavimɨn gari, ezɨ Iesus Godɨn agharir guvimɨn tughav iti. ");
INSERT INTO msy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ezɨ a kamaghɨn mɨgei, “Ia Gan! Kɨ Godɨn Nguibamɨn garima, a kuiaghrɨzɨma Gumazibar Otarim Godɨn agharir guvimɨn tughav iti.” ");
INSERT INTO msy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ezɨ me kamaghɨn oregha pamtem diava ara, egha dafaribar uan kuaribav kongegha, egha ivemara a bagha zui. ");
INSERT INTO msy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Egha a kurugha nguibar ekiamɨn azenan ghugha, egha maghɨrama dagɨabar a ginifi. Egha akam a gasir darasi uan azenan azuir korotiaba suegha egha gumazir igiam, an ziam Solɨn dagarimningɨn a da arɨsi. ");
INSERT INTO msy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Egha me dagɨabar a ginivavɨra itima, Stiven God ko mɨgei, “Ekiam Iesus, nan duam inigh.” ");
INSERT INTO msy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Egha a uan tevimning apɨrigha irɨgha egha pamtem dei, “Ekiam, men arazir kurar kam gɨnɨghnɨghan markɨ, a gɨn amadagh.” A kamaghɨn mɨkemegha, ");
INSERT INTO msy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ezɨ Sol uaghan ikia bizir kamɨn ganigha ghaze, a dera. Dughiar kam me Stiven mɨsoghezɨma an areme. Ezɨma me Jerusalemɨn itir Kraisɨn adarasi pazavɨra me mɨsoghava, egha arazir kurabar me gami. Kamaghɨn amizɨma, Kraisɨn adarasi bar ara Judian Distrigh ko Samarian Distrighɨn ghue. Ezɨma aposelbara Jerusalemɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ezɨ gumazir God baghavɨra itiba, me Stivenɨn kuam isava mozim gatɨgha a bagha puvɨra azi. ");
INSERT INTO msy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ezɨma Sol Kraisɨn adarasi me gasɨghasɨghavɨra ikiava, egha men dɨpenibar vaghvagha dar ghuava gumazamiziba sara me isava me kurvagha kalabus garɨsi. ");
INSERT INTO msy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ezɨ gumazamizir areziba, me akar aghuim nguibar me itibar anekuri. ");
INSERT INTO msy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ezɨ Filip Samarian Distrighɨn aven itir nguibar mamɨn ghua, God Uam E Iniasa Mɨsevezir Gumazim, Kraisɨn akam kuri. ");
INSERT INTO msy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ezɨ gumazamizir okuruaba an akaba baragha, egha a mirakelɨn arazibagh amima da otifi, ezɨma me kuariba arigha bar deravɨra a barasi. ");
INSERT INTO msy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ezɨ me Filipɨn garima a duar kurar gumazamizibagh apazaziba batozima, da pamtem diava arava me ataghraghava azenan izi. Ezɨ gumazir avɨribar agharir amɨrɨziba ko suer kuvtɨziba uaghan ua dera. ");
INSERT INTO msy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kamaghɨn amizɨma, nguibar kamɨn amiziba ko gumaziba bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gumazir mam an ziam Saimon, a fomɨra Samarian nguibamɨn ikia mirakelɨn ifavarir kuraba dagh amima, Samarian gumazamiziba an ganigha nɨghnɨzir avɨribagh ami. A kamaghɨn mɨgei, “Kɨ gumazir ekiam.” ");
INSERT INTO msy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ezɨma gumazir ekiaba ko gumazamizir kɨniba, me Saimonɨn akam baraghasa ifonge. Egha me kamaghɨn mɨgei, “Kar aser gavgavim, an ziam Gavgavir Bar Ekiam, a Saimonɨn iti.” ");
INSERT INTO msy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A dughiar avɨribar mirakel ifavarir kurabagh amima da otivima me dar garava, nɨghnɨzir avɨribagh ami. Bizir kam bagha, me an akam baraghasa ifongegha an gɨn arui. ");
INSERT INTO msy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Egha datɨrɨghɨn Filip, a God Bizibagh Ativir Arazimɨn akar aghuim ko Krais Iesusɨn ziam sara akuri. Kamaghɨn amizɨma, gumazamiziba nɨghnɨzir gavgavim Filipɨn akamɨn ikiava, me rue. ");
INSERT INTO msy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ezɨ Saimon uaghan nɨghnɨzir gavgavim ikiava egha rue. Egha Saimon Filipɨn gɨn arua garima, Filip arazarazir ekiaba ko mirakelbagh amima da otivima, a dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ezɨ Jerusalemɨn itir aposelba orazima, Samarian gumazamiziba Godɨn akam inigha gɨvazɨ, kamaghɨn me Pita ko Jon amadazɨma aning me bagha ghu. ");
INSERT INTO msy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samarian gumazamiziba, me Iesusɨn ziamɨn ruegha, me Godɨn Duam inizir puvatɨ. Kamaghɨn amizɨma Pita ko Jon ghuava otogha me Godɨn Duam iniasava aning me bagha God ko mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ezɨma aning God ko mɨkemegha, uan aghariba fegha me gisɨn atɨzɨma me Godɨn Duam isi. ");
INSERT INTO msy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ezɨ Saimon garima, aposelning uan aghariba fegha me gisɨn atɨzɨma me Godɨn Duam isi. Ezɨma a dagɨaba inigha aning ganɨga, kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Gua gavgavir kam uaghan na danɨngigh. Eghtɨ kɨ uan agharim fegh tav gisɨn datɨghtɨma, a Godɨn Duam iniam.” ");
INSERT INTO msy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ezɨ Pita kamaghɨn Saimon mɨkeme, “Nɨ ghaze, nɨ dagɨaba ga danɨngigh, egh tuavir kamɨn God anɨngizir bizir aghuim givezam. Bar puvatɨ! Bizir kam bagh nɨ uan dagɨaba sara helɨn mangam. ");
INSERT INTO msy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nɨn navir averiam Godɨn damazimɨn derazir puvatɨ. Kamaghɨn amizɨma, nɨ Godɨn ingangarimɨn aven ikian kogham. ");
INSERT INTO msy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Kɨ nɨn garima, nɨ navim ikufi, egha uaghan arazir kuraba nɨn ike. Kamaghɨn navim gɨragh arazir kuraba da ateghɨva, Ekiam ko mɨkɨm. Eghtɨ a ti nɨghnɨzir kurar nɨn navir averiamɨn itiba gɨn amadagham.” ");
INSERT INTO msy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ezɨma Saimon an akam ikara, “Gua na bagh Ekiam ko mɨkɨmtɨma, bizir gua mɨkemeziba na bativan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ezɨ Pita ko Jon Ekiam aningɨn akurvaghizir bizibar gun mɨgɨava, an akam akuri. Egha aning uamategha Jerusalemɨn ghuava, akar aghuim Samarian Distrighɨn nguibar avɨribar an akura zui. ");
INSERT INTO msy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ezɨ Ekiamɨn ensel Filipɨn mɨgei, “Nɨ Sautɨn tuavimɨn mangɨ, a Jerusalem ategha ghuaghira Gazan nguibamɨn oto. Tuavir kam gumaziba puvatɨzir danganimɨn iti.” ");
INSERT INTO msy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ezɨma, a maghɨra zui, a tuavir arɨzimɨn Itiopian gumazir mam bato. Ezɨ a gumazir dapanim, a Itiopian atrivir amizim Kandasɨn dagɨabar garir gumazim. Gumazir kam Jerusalemɨn ghugha Godɨn ziam fegha uamategha izi. Egha a karis gaperagha, Godɨn akam inigha izir gumazim, Aisaian akɨnafarimɨn gari. ");
INSERT INTO msy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ezɨ Godɨn Duam Filip mɨgei, “Nɨ mangɨva karisɨn munamɨn boroghɨn ikɨ.” ");
INSERT INTO msy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ezɨ Filip ivegha ghuava karisɨn boroghɨn ghugha Itiopian gumazim barasi, a Aisaia, Godɨn akam inigha izir gumazimɨn akɨnafarimɨn gari. Ezɨ Filip an azara, “Nɨ garir bizir kam nɨ a gɨfo?” ");
INSERT INTO msy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ezɨ Itiopian gumazim a ikara, “Kɨ manmaghɨn fogham? Tav na geghanɨghtɨma, kɨ fogham.” Egha a Filip mɨgɨa ghaze, “Nɨ izɨvanang na ko daperagh.” ");
INSERT INTO msy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","33","Itiopian gumazim Godɨn Akɨnafarimɨn itir akar kabar gari, “A mati sipsipɨn mɨn me a mɨsoghasava, a inigha ghu. Sipsipɨn nguziba, me dar arɨziba aghorasava amima da pura nɨmɨra iti. Kamaghɨra gumazir kam, me a mɨsoghasava amima, a pura nɨmɨra ikia bizitam mɨgeir puvatɨ. Ezɨ me bar a dɨkabɨragha, egha deraghavɨra an kotiam gamizir puvatɨ. Kamaghɨn amizɨma, a boriba puvatɨ, ezɨ tina an gun me geghanam? Me an ikɨrɨmɨrim a gɨvazɨma, ezɨma a ua nguazimɨn itir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Egha Itiopian gumazim Filipɨn azara, “Nɨ na mɨkemegh, ga uaning, Godɨn akam inigha izir gumazim, a tinan gun mɨgei? A uabɨ mɨgei, o igharazitav mɨgei?” ");
INSERT INTO msy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ezɨ Filip dɨkavigha Godɨn Akɨnafarimɨn aven akar kamra an mɨngarimɨn mɨgɨa ghua, egha Iesusɨn akar aghuimɨn gun a mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ezɨ me tuavimɨn ghuava, dɨpar mam bato. Egha Itiopian gumazim kamaghɨn mɨgei, “Nɨ gan, dɨpam kara. Kɨ datɨrɨghɨra ruasa, bizir tizitam ua nan suigham?” ");
INSERT INTO msy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Egha Itiopian gumazim karisɨn suizir gumazim mɨgeima, a karis gamizɨma a tu. Ezɨma Filip ko Itiopian gumazim dɨpamɨn aven iraghughzɨ, Filip a rue. ");
INSERT INTO msy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ezɨ me dɨpamɨn ikegha azenan izezɨma, Ekiamɨn Duam zuamɨra Filip inigha ghu. Ezɨ Itiopian gumazim ua Filip bagha garava avenge, egha tuavimɨn ghuava bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ezɨma Filip gari, a Azotuzɨn nguibamɨn oto. Egha a ghuava, nguibaba bar dar akar aghuim akura ghua Sesarian oto. ");
INSERT INTO msy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Egha dughiar kam Sol Iesusɨn suren gumazibagh asɨghasɨghɨva, egh me mɨsoghtɨma me arɨghirasa, mɨgɨrɨgɨar gavgavim gamuavɨra iti. Kamaghɨn amizɨ, an ofa gamir gumazibar dapanir ekiam bagha ghua kamaghɨn azai, “Nɨ Damaskusɨn itir God ko mɨgeir dɨpenibar garir gumazir dapaniba bagh akɨnafariba osir suam, ‘Sol, gumazitam o amizitam, Iesusɨn Tuavimɨn gɨn mangɨtɨ, an an apigh, an suiraghɨva mangɨva kalabusɨn gumazimɨn mɨn a ikɨrarighɨva, Jerusalemɨn mangam.’” ");
INSERT INTO msy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ezɨ a Damaskusɨn nguibamɨn boroghɨn izima overiamɨn angazangarir gavgavim a gisira. ");
INSERT INTO msy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ezɨ a irɨgha nguazim girɨgha egha orazi, tiarir mam kamaghɨn a mɨgei, “Sol, Sol, nɨ tizim bagha na gasɨghasɨsi?” ");
INSERT INTO msy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ezɨ Sol azara, “Ekiam, nɨ tina?” Ezɨ a kamaghɨn a mɨgei, “Kɨ Iesus, nɨ na gasɨghasɨsi. ");
INSERT INTO msy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Egh nɨ dɨkavigh, nguibamɨn mangɨ. Egh mɨgɨrɨgɨar nɨ manmaghɨn damuamim, gumazir mam tɨghar nɨ mɨkɨmam.” ");
INSERT INTO msy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ezɨ gumazir Sol koma zuiba, me pura gumazimɨn mɨgɨrɨgɨar kɨnim baregha egha gumazitamɨn garir puvatɨ. Kamaghɨn amizɨ me mɨgɨrɨgɨaba puvatɨgha pura iti. ");
INSERT INTO msy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ezɨ Sol ua dɨkavigha, egha uan damazimning kuigha, egha a bizitamɨn garir puvatɨ. Ezɨ a koma aruir gumaziba an agharimningɨn suiragha a inigha me Damaskusɨn zui. ");
INSERT INTO msy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A Damaskusɨn itima an damatuzimning dughiar pumuning ko mɨkezimɨn ikuvighavɨra itima, a daghetam ko dɨpatam amezir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Dughiar kam Damaskusɨn aven Iesusɨn suren gumazir mam iti, an ziam Ananaias. Ezɨ Ekiam irebamɨn mɨn bizimɨn garimɨn aven an dei, egha ghaze, “Ananaias!” Ezɨ an a ikara, “Ekiam, kɨ kati.” ");
INSERT INTO msy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ezɨ Ekiam a mɨgɨa ghaze, “Gumazir mam, an ziam Sol, a Tarsusɨn gumazim. A na ko mɨgɨa iti. Kamaghɨn amizɨ, nɨ dɨkavigh, tuavir kam mangɨ, an ziam Voroghɨra Zui. Nɨ Judasɨn dɨpenimɨn mangɨ Sol bagh azaragh. ");
INSERT INTO msy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol irebamɨn mɨn bizimɨn garima, gumazimɨn ziam Ananaias, a iza agharim a gisɨn atɨgha an damazimning gamizɨma, aning ua deraghasa.” ");
INSERT INTO msy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ezɨ Ananaias a ikara, “Ekiam, kɨ orazima, gumazir avɨriba gumazir kamɨn gun mɨgei, me ghaze, a nɨn gumazir Jerusalemɨn aven itiba paza me gami. ");
INSERT INTO msy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ezɨ ofa gamir gumazibar dapaniba akar gavgavim an amamangatɨzɨ a ize. Egh tina nɨn ziamɨn nɨ ko mɨgeiba, a men suighɨva kalabus darɨgham.” ");
INSERT INTO msy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ezɨma Ekiam kamaghɨn Ananaias mɨgei, “Nɨ mangɨ! Gumazir kam, mar kɨ inabazir ingangarir gumazim. A nan ziam ater Kantrin Igharazibar Gumaziba ko men atriviba koma Israelɨn gumaziba bagh mangam. ");
INSERT INTO msy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eghtɨ a mɨzaziba ko osɨmtɨzir nan ziamɨn iniamiba, kɨ da an akagham.” ");
INSERT INTO msy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ezɨ Ananaias dɨpenimɨn ghua an aven ghu. Egha uan dafarimning Sol gisɨn atɨgha, egha ghaze, “Nan aveghbuam, Sol, nɨ kagh izima Ekiam Iesus tuavimɨn nɨ bato. Nɨ ua gantɨ, Godɨn Duam nɨ gizɨvaghasa, kamaghɨn amizɨ a na amadazɨ kɨ ize.” ");
INSERT INTO msy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ezɨ bar zuamɨrama, osirir naziamɨn mɨn garir bizim Solɨn damazimningɨn ikegha kuiaghirɨ. Ezɨ a datɨrɨghɨn ua gari. Ezɨ a dɨkavizɨma me Iesusɨn ziamɨn a rue. ");
INSERT INTO msy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ezɨ a dagher maba amegha gɨn ua uan gavgavim ini. Egha Sol Iesusɨn suren gumaziba ko mong dughiar mabar Damaskusɨn ike. ");
INSERT INTO msy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Egha Sol Iesusɨn suren gumaziba ko Damaskusɨn ikia maghɨra God ko mɨgeir dɨpenibar akam kura ghaze, Iesus a Godɨn Otarim. ");
INSERT INTO msy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ezɨ Solɨn mɨgɨrɨgɨam baraghizɨ darasi, me dɨgavir kuram gamighava azai, “Kar ti gumazir kamnaghra, a Jerusalemɨn ikia Iesusɨn ziar kamɨn deir gumazamiziba, men suigha me gasɨghasɨsi? Egh a ti me inigh mangɨ kalabusɨn gumazibar mɨn me ikɨrarɨgh ofa gamir gumazibar dapanibar dafarim darɨghasa, egha a kagh ize?” ");
INSERT INTO msy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ezɨ Solɨn akar a kuri kabanangɨn gavgavim bar ghuanabozɨ a mɨgɨrɨgɨam bar deravɨrama anebɨghizɨ, Judan gumazir Damaskusɨn itiba fo, Iesus a Gumazir God Uam E Iniasa Mɨsevezim, Krais. ");
INSERT INTO msy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ezɨ dughiar avɨriba ghuezɨma, ezɨ Judaba Sol mɨsueghtɨ an aremeghasa tuaviba buri. ");
INSERT INTO msy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Egha me a mɨsoghasava amua arueba ko dɨmagariba zurazurara a bagha nguibar ekiamɨn tiar akabar gari, ezɨ Sol men nɨghnɨzir kurar kam gɨfo. ");
INSERT INTO msy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ezɨ an gɨn aruir gumaziba, me dɨmagarimɨn a mɨkemezɨ an akɨrar ekiam gaperazɨma, me dagɨar dɨvazir torir mamɨn anetaghizɨma a ghuaghira nguibar ekiamɨn dɨvazimɨn azenan irɨ. ");
INSERT INTO msy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ezɨ Sol Jerusalemɨn izegha, egha Iesusɨn suren gumaziba uaghan men aven angasa ami. Ezɨ me nɨghnɨzir gavgavim kamaghɨn an itir puvatɨ, a Iesusɨn suren gumazim, egha me bar an atiatingi. ");
INSERT INTO msy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ezɨ Barnabas a inigha an gun aposelbav kɨmasa zui. Egha a me mɨgei, Sol tuavimɨn ghua Ekiamɨn gani. Ezɨ Ekiam a mɨkeme, egha Damaskusɨn tavɨn atiatingizir puvatɨgha, Iesusɨn ziamɨn akam akuri. ");
INSERT INTO msy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ezɨ Sol Jerusalemɨn deravɨra me koma aruava me ko ikia, egha atiatir puvatɨgha Iesusɨn ziamɨn akam kura ghuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Egha a Judan Grighɨn akam mɨgeir gumaziba ko me uariv gɨa uari adosi, ezɨ me a mɨsueghtɨ an aremeghasava ami. ");
INSERT INTO msy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ezɨ Kraisɨn adarasi kamaghɨn oregha fogha, egha a inigha Sesarian nguibamɨn ghuaghira, egha a isa Tarsusɨn nguibamɨn anemada. ");
INSERT INTO msy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ezɨ Judian Distrigh ko Galilin Distrigh ko Samarian Distrighɨn aven itir Kraisɨn adarasi, dughiar kamɨn navir amɨrɨzimɨn ikia deravɨra itima, Godɨn Duam gavgavim me ganɨdi. Ezɨ Kraisɨn adarazir dɨbobonim ghuavanadi. Gumazamiziba Godɨn atiatiava an apengan iti. ");
INSERT INTO msy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ezɨ Pita nguibaba bar dagh aruigha, egha Lidan nguibamɨn itir Godɨn gumazamizibar ganasa zui. ");
INSERT INTO msy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Egha nguibar kamɨn gumazir mam bato, an ziam Ainias. An soroghafariba amɨrazɨma, ezɨ a 8 plan azenibar mɨsiamra iti. ");
INSERT INTO msy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ezɨ Pita kamaghɨn a mɨgei, “Ainias, Krais Iesus nɨ gamizɨ, nɨ dera. Nɨ dɨkavigh uan akuriam apɨrigh.” Ezɨ Ainias zuamɨra dɨkafi. ");
INSERT INTO msy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ezɨ Lidan nguibam ko Saronɨn danganir voroghɨra irɨghav itimɨn itir gumazamiziba, me an ganigha uan navibagh iragha Iesus bagha ize. ");
INSERT INTO msy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ezɨ Jopan nguibamɨn suren amizir mam iti, an ziam Tabita, Grighɨn akamɨn an ziam Dorkas, a zurarama arazir aghuibagh amuava gumazir onganaraziba akurvasi. ");
INSERT INTO msy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ezɨ dughiar mamɨn arɨmariam a inizɨma an areme. Ezɨ me an kuam ruegha a isava ghuriar pɨn itimɨn anetɨ. ");
INSERT INTO msy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopan nguibam Lidan nguibam boroghɨra iti, kamaghɨn suren gumaziba kamaghɨn orazima, Pita Lidan itima, ezɨ me gumazir pumuning a mɨkɨmasa aning amadazɨma aning zui. Ezɨ aning ghua a mɨgɨa ghaze, “E uari, nɨ zuamɨra datɨrɨghɨra ga ko izɨ!” ");
INSERT INTO msy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ezɨ Pita aning ko ghuava otogha egha maghɨra ghuriar pɨn itimɨn ghuavanabo. Ezɨ amizir odiarir pura itiba an mɨriamɨn tuivighav ikiava, aziava egha uan korotiaba ko korotiar azenan azuir Dorkas me ko angamra ikia me bagha ingariziba an akakasi. ");
INSERT INTO msy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ezɨ Pita gumazamiziba bar me amangizɨ me azenan ghue. Ezɨ a uan tevimning apɨrigha God ko mɨgei. Egha a raghrɨghava amizir aremezim garava ghaze, “Tabita, nɨ dɨkafigh.” Ezɨ a uan damazimning kuigha egha Pitan apigha, egha dɨkavigha apera. ");
INSERT INTO msy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ezɨ Pita an akuragha a fezɨ a dɨkavigha tu. Ezɨ a nɨghnɨzir gavgavim God baghavɨra itir gumazamizir odiaribar diagha men akazɨ me gari, an angamra iti. ");
INSERT INTO msy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ezɨ Jopan itir gumazamiziba bizir kamɨn eghaghanim baregha men avɨriba nɨghnɨzir gavgavim Ekiamɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ezɨ Pita dughiar mabar Jopan itir gumazir asɨzir inibar bizibar ingarir mam, an ziam Saimon, a ko ike. ");
INSERT INTO msy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gumazir mam Sesarian nguibamɨn iti, an ziam Kornilius. A Romɨn mɨdorozir gumazir 100 plan garir gumazim. A uaghan men mav, me Italin Kantrin Mɨdorozir Gumaziba. ");
INSERT INTO msy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kornilius a God ifongezir arazibagh amir gumazim, a uan adarazi ko me Godɨn apengan iti. Egha a uaghan Judan gumazamizir onganarazibar akurvagha, egha zurara God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Dughiar mamɨn 3 kloghɨn guaratɨzimɨn Kornilius bar deravɨra garima Godɨn ensel irebamɨn mɨn bizimɨn aven iza kamaghɨn a mɨgei, “Kornilius!” ");
INSERT INTO msy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ezɨma Kornilius atiatia dɨkɨravɨram an gara, kamaghɨn an azara, “Ekiam, bizir itizim?” Ezɨma ensel an azangsɨzim ikara, “God nɨn mɨgɨrɨgɨaba baragha, ingangarir nɨ gumazamizir onganarazibagh amir biziba, an a dagh ifuegha egha dagh nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Egh nɨ datɨrɨghɨn gumazitaba Jopan me amadaghtɨma, me mangɨ gumazir kam an ziam Saimon, me uaghan Pita a garɨsi, a batogh a inigh izɨ. ");
INSERT INTO msy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A Saimon ko iti, asɨzir inibar bizibar ingarir gumazim. An dɨpenim ongarir mɨriamɨn iti.” ");
INSERT INTO msy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Egha enselɨn Kornilius mɨkemezim anetegha ghuzɨma, a uan ingangarir gumazimning koma mɨdorozir gumazir bar God gifongezim uaghan a ko itimɨn diazɨma me a bagha izi. ");
INSERT INTO msy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ezɨma a bizir otivizir kaba, dar gun bar me mɨkemegha, me amadazɨma me Jopan ghue. ");
INSERT INTO msy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ezɨ amɨmɨzaraghan aruer arɨzimɨn Kornilius amadazir gumaziba ghuava Jopan nguibar ekiamɨn boroghɨn otivima, dughiar kamra Pita dɨpenimɨn avughsir danganimɨn ikia God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Egha Pita mɨtiriam an azima, a daghetam ramasa, ezɨ me daghebagh amuavɨra itima, a irebamɨn mɨn bizir mamɨn gari. ");
INSERT INTO msy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Egha a pɨn garima overiam kuiaghrɨzɨma, bizir mam inir avɨzir dafamɨn mɨn gari. Bizir kam, me an ruaghatevir 4 plan suirazɨma, a nguazimɨn izaghiri. ");
INSERT INTO msy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Egha an aven, asɨziba bar—asɨzir soroghafariba ikia aruiba, ko nguazim davaragha aruir asɨziba, ko pɨn itir kuaraziba iti. ");
INSERT INTO msy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ezɨ tiarir mam kamaghɨn a mɨgei, “Pita, nɨ dɨkavigh, dav suegh dar amɨ.” ");
INSERT INTO msy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ezɨ Pita kamaghɨn a ikara “Ekiam bar puvatɨgham! Kɨ fomɨram Godɨn damazimɨn bizir mɨzɨrɨzitam amezir puvatɨ.” ");
INSERT INTO msy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ezɨ tiarim uam a mɨgei, “Bizir God amizir zueziba, nɨ uam mɨzɨrɨzibar dar ponan markɨ.” ");
INSERT INTO msy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ezɨ bizir kamnagh dughiar pumuning ko mɨkezimɨn Pita bato. Ezɨma inir avɨzir ekiar kam zuamɨra uamategha overiamɨn ghuavanabo. ");
INSERT INTO msy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita irebamɨn mɨn ganizir bizir kamɨn mɨngarim ginɨghnɨghavɨra itima, Kornilius amadazir gumaziba otifi. Egha me Saimonɨn dɨpenim bagha azangsɨsi, an dɨpenim managh iti. Egha me datɨrɨghɨn izava an tiar akamɨn otifi. ");
INSERT INTO msy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Egha me diava azangsɨsi, “Saimon, an ziar mam Pita, a kagh iti o puvatɨ?” ");
INSERT INTO msy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita irebamɨn mɨn ganizir bizim ginɨghnɨghavɨra itima, Godɨn Duam a mɨgei, “Saimon, gumazir pumuning ko mɨkezim nɨ buria gharui. ");
INSERT INTO msy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kɨ me amadazɨma me nɨ bagha izi. Kamaghɨn, nɨ me ko mangɨsɨ nɨghnɨzir avɨribar amuan markɨ. Nɨ dɨkavigh vangɨnan magɨrɨ.” ");
INSERT INTO msy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ezɨ Pita vangɨnan iraghugha me mɨgei, “Kar kɨrara, ia na buri. Ia tizim bagha izi?” ");
INSERT INTO msy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ezɨ gumaziba an akam ikara, “Kornilius 100 plan mɨdorozir gumazibar garir gumazim nɨ bagha e amadazɨma e ize. A Godɨn damazimɨn deragha an apengan itir gumazim. Judan gumazamiziba bar a gifongegha an ziam fe. Ezɨma Godɨn enselɨn mam a mɨgɨa ghaze, nɨ Pita bagh akam amadaghtɨ a nɨn dɨpenimɨn izegh mɨgɨrɨgɨatabar amutɨ nɨ da baragh.” ");
INSERT INTO msy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Egha Pita me mɨgeima, me dɨpenimɨn aven ghu. Me akuigha amɨmɨzaraghan nɨghnɨzir gavgavim Iesusɨn itir gumazir maba sara, Jopan ikeghava uaghan me ko Sisarian zui. ");
INSERT INTO msy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Me akuigha ua dɨkavigha ghua, me Sesarian oto. Ezɨ Kornilius me mɨzua iti. A uan roroaba ko uan adarasi diagha, me akuvagha me ko iti. ");
INSERT INTO msy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pita dɨpenimɨn aven zuima, Kornilius a batoghava, an guamɨn uan tevir akurimning pɨrighav aperaghav an ziam fe. ");
INSERT INTO msy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ezɨ Pita an suiraghav a fe, egha ghaze, “Nɨ dɨkavigh tugh. Kɨ pura gumazir kɨnim.” ");
INSERT INTO msy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita a mɨgɨavɨra dɨpenimɨn aven ghua garima, gumazamizir avɨriba uari akuvaghav iti. ");
INSERT INTO msy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ezɨma a me mɨgei, “Ia bar fo, e Judaba en arazim. E Kantrin Igharazibar Gumazibar boroghɨra mangan kogh me ko ikian kogham. Ezɨ God kamaghɨn na mɨgɨa ghaze, kɨ gumazitam Godɨn damazimɨn mɨzɨrɨzim a darɨghan kogham. ");
INSERT INTO msy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ezɨ ia na bagha akam amadazɨma kɨ aghuazir puvatɨgha, egha kagh ize. Egha kɨ ian azangsɨsi, ia tizim bagha na bagha akam amada?” ");
INSERT INTO msy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ezɨ Kornilius an akam ikara, “Dughiar pumuning ko pumuning gɨvazɨma, kɨ 3 kloghɨn guaratɨzimɨn uan dɨpenimɨn aven ikia God ko mɨgei. Ezɨ gumazir mam korotiar ghurghurim arugha bemɨra nan guamɨn mɨtɨghav iti. ");
INSERT INTO msy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Egha ghaze, ‘Kornilius, God nɨn mɨgɨrɨgɨam baraki, egha arazir nɨ gumazamizir onganarazibagh amir biziba, an adagh nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eghtɨ Saimon, an ziar mam Pita, a bagh gumazitam amadaghtɨma, a Jopan mangɨva a inigh izɨ. A Saimon asɨzir inibar bizibar ingarir gumazimɨn dɨpenimɨn akuima, anan gara iti. Dɨpenir kam ongarir mɨriamɨn iti.’ ");
INSERT INTO msy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kamaghɨn amizima kɨ nɨ bagha zuamɨram akam amada. Ezɨ nɨ deragha izi. Egha e datɨrɨghɨn bar iza Godɨn damazimɨn iti. God nɨ mɨkemezir akaba, nɨ dav kɨmtɨma e bar da baragham.” ");
INSERT INTO msy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ezɨ Pita Korneliusɨn dɨpenimɨn aven itir darasiv gei, “Bar guizbangɨra, kɨ datɨrɨghɨn fos. God gumazir vabara ifuegha merara garir puvatɨ, a bar gumazibagh ifonge. ");
INSERT INTO msy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nguibaba bar dar itir gumazamizir an apengan ikia, arazir aghuibagh amiba, a me gifonge. ");
INSERT INTO msy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kar God Israelɨn gumazamiziba bagha amadazir akam. A kamaghɨn mɨgei, Krais Iesus a bar moghɨra en Ekiam. Egha an e gamima, e God ko navir amɨrɨzimɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ia uari fo, bizir manaba kantri Israelɨn nguibaba bar da batifi. Bizir kaba Distrigh Galilin dɨkafi. Da, Jon gumaziba ruasa akam kuragha aruigha gɨvazɨma, da gɨn otifi. ");
INSERT INTO msy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ia fo, God Nasaretɨn gumazim Iesus, uan Duam ko gavgavim a ganɨngi. Egha God a ko itima, kamaghɨn amizɨ a nguibabagh arua gumazamizibar akurvasi. Egha Satanɨn apengan itir gumazamizibagh ami me ua dera. ");
INSERT INTO msy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“E uari uan damazibar an garima, an en nguibar Judan aven itiba ko Jerusalemɨn nguibamɨn bizir avɨribagh ami. Ezɨ me a mɨsuegha ter ighuvimɨn anegurazɨma an areme. ");
INSERT INTO msy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ezɨ dughiar pumuning ko mɨkezim gɨvazɨma God a gamima a ua dɨkafi. Ezɨ God a isava gumazamizibar aka. ");
INSERT INTO msy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Egha a bar Judaba bar me bativizir pu. Puvatɨ. An e gumazir God mɨseveziba, erara an gari. An aremegha ua dɨkavizir dughiamɨn gɨn, an e ko ikiava dagheba ko dɨpaba ame. ");
INSERT INTO msy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iesus an akam gun gumazamizibav kɨmasava e mɨkeme. A ghaze, e kamaghɨn me mɨkɨm suam, God gumazir kam, Iesus anemɨsevezɨma, anarɨra en kotiaba baragham, ovia ghueziba ko angamra itiba sara. ");
INSERT INTO msy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Godɨn akam inigha izir gumaziba bar, me Iesusɨn guizɨn akar kam kuni. Egha ghaze, gumazitam nɨghnɨzir gavgavim Iesusɨn ziamɨn ikɨtɨ, God Iesusɨn ziamɨn tuavimɨn an arazir kuraba gɨn amadagham.” ");
INSERT INTO msy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita akam kuravɨra itima, gumazamiziba a baragha itima, Godɨn Duam bar me gisɨn izaghiri. ");
INSERT INTO msy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Judan gumazir nɨghnɨzir gavgavim itiba, Pita ko ize. Egha me orazima me nguibar igharazibar akabar Godɨn ziam fe. Kamaghɨn me dɨgavir kuram gamigha kamaghɨn mɨgɨa ghaze, “Munagh gan! God uan Duam bizir aghuarimɨn mɨn Kantrin Igharazibar Gumaziba uaghan me ganɨngi.” ");
INSERT INTO msy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ezɨ Pita kamaghɨn mɨgɨa ghaze, “Gumazamizir kaba, me en mɨn Godɨn Duam inis. Ezɨ tina, e dɨpamɨn me ruam en anegorosi?” ");
INSERT INTO msy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ezɨma Pita kamaghɨn gumazir kabav gei, “Ia Krais Iesusɨn ziamɨn me ruam.” Ezɨ me ruegha gɨvagha, egha uari ko dughiar tabar ikiasava Pita mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ezɨ aposelba ko Judian nguibabar aven itir darasi, me kamaghɨn oraki, Kantrin Igharazibar Gumaziba uaghan Godɨn akam ini. ");
INSERT INTO msy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Ezɨ kamaghɨn Pita uamategha Jerusalemɨn ghuavanabo. Ezɨ gumazir uan mɨkarzir mogomebar iniba aghoregha nɨghnɨzir gavgavim Iesusɨn itiba, me Pitan atara egha ghaze, “Nɨ ghua uan mɨkarzir mogomebar iniba aghorezir puvatɨzibar gumazibar dɨpenibar ghua egha me koma api.” ");
INSERT INTO msy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ezɨ Pita maghɨra bizir a batoziba bar deravɨra dar gun me mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kɨ Jopan nguibar ekiamɨn ikia God ko mɨgei. Egha irebamɨn mɨn bizimɨn garima, bizim mati inir avɨzir dafam, me an ruaghatevir 4 plan suirazɨma, an overiam ategha izaghira kɨ iti naghɨn asara. ");
INSERT INTO msy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ezɨ kɨ an aven garima, asɨzir soroghafariba ikia nguazimɨn itiba, ko asɨzir atiar maba, ko nguazimɨn davaragha aruir asɨziba, ko pɨn itir kuaraziba iti. ");
INSERT INTO msy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ezɨ kɨ orazi, tiarir mam na mɨgei, ‘Pita, dɨkavigh, asɨzitam mɨsuegh anemɨ.’ ");
INSERT INTO msy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ezɨ kɨ a ikara, ‘Ekiam! Bar puvatɨgham! Nan akam Godɨn damazimɨn bizir mɨzɨrɨzir katam bar anemezir puvatɨ.’ ");
INSERT INTO msy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ezɨ tiarim ua Godɨn Nguibamɨn mɨgei, ‘Bizir God amizir zueziba, nɨ uam mɨzɨrɨzibar dar ponan markɨ.’ ");
INSERT INTO msy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ezɨ dughiar pumuning ko mɨkezimɨn bizir kam amigha eghava ua ekuighava overiamɨn ghuavanabo. ");
INSERT INTO msy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Ezɨ dughiar kamra gumazir pumuning ko mɨkezim, me na bagha Sisarian nguibamɨn me amadazɨma me iza dɨpenir kɨ itimɨn oto. ");
INSERT INTO msy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ezɨ Godɨn Duam na mɨgɨa ghaze, nɨ me ko mangɨsɨva nɨghnɨzir avɨribar amuan markɨ. Ezɨ 6 plan aveghbuaba uaghan na ko zui. Egha e gumazir na bagha akam amadazimɨn dɨpenimɨn aven ghue. ");
INSERT INTO msy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ezɨ an e mɨgɨa ghaze, enselɨn mam an dɨpenimɨn aven a batogha egha ghaze, nɨ gumazitaba amangɨghtɨ, me Jopan nguibamɨn mangɨ, Saimon, an ziar mam Pita, a batogh. ");
INSERT INTO msy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Eghtɨ a Godɨn akam inigh izɨ, nɨ mɨkɨmtɨ, eghtɨ tuavir kamɨn nɨ ko nɨn dɨpenimɨn itir gumazamiziba bar, Ekiam uaghan ua me iniam. ");
INSERT INTO msy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ezɨ kɨ maghɨra mɨgeima Godɨn Duam me gisɨn izaghiri, mati bar faraghavɨra an e gisɨn izaghirɨzɨ moghɨn. ");
INSERT INTO msy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ezɨ kɨ Ekiam mɨkemezir mɨgɨrɨgɨam ginɨrɨ, ‘Jon dɨpamɨn ia rue, eghtɨ kɨ Godɨn Duamɨn ia ruam.’ ");
INSERT INTO msy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","E fo, e faragha nɨghnɨzir gavgavim Ekiam Krais Iesusɨn itima, Godra uan Duam bizir aghuimɨn mɨn e ganɨngi. Egha kamaghɨra datɨrɨghɨn God Kantrin Igharazibar Gumaziba uaghan uan Duam, bizir aghuimɨn mɨn me ganɨngi. Kamaghɨn amizɨma kɨ tina, kɨ God me ko ingaramin ingangarimɨn anogoregham?” ");
INSERT INTO msy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ezɨ nɨghnɨzir gavgavim Iesusɨn itir gumaziba kamaghɨn oregha, egha uam ataramin nɨghnɨziba puvatɨgha Ekiamɨn ziam fa, ghaze, “A dera, God uaghan Kantrin Igharazibar Gumaziba amamangatɨghtɨma me uaghan navibagh iragh egh ikɨrɨmɨrir zurara itim iniam.” ");
INSERT INTO msy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Me Stivenɨn mɨsoghezɨ an aremezir dughiamɨn, me arazir kuram uaghan nɨghnɨzir gavgavim Iesusɨn itir igharazibagh amizɨ, me tintinibar arava, egha saghon Fonisian Distrigh ko Saiprusɨn arighatɨzim koma Antioghɨn nguibar ekiamɨn ghua Godɨn akam Judan gumazibara me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ezɨ men marazi uaghan Saiprusɨn arighatɨzim ko Sairinin nguibar ekiamɨn ikegha ize, egha Antioghɨn ghuegha Ekiam Iesusɨn akar aghuimɨn gun Grighɨn gumazibav gei. ");
INSERT INTO msy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ezɨ Ekiamɨn gavgavim me ko iti. Ezɨ gumazamizir bar avɨrim nɨghnɨzir gavgavim Ekiamɨn ikia egha uan navibagh iragha Ekiam bagha ize. ");
INSERT INTO msy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ezɨ Jerusalemɨn itir Kraisɨn adarasi bizir kamɨn eghaghanim baregha, egha me Barnabas amadazɨma an Antioghɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ezɨ an otogha gari, God men apangkuvigha, men akurvagha arazir aghuibar me gamizɨ Barnabas bar akonge. Egha me uan navir averiabar aven guizbangɨra Ekiam ko ikiamin mɨgɨrɨgɨabar a bar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","A bar gumazir aghuim, Godɨn Duam a gizɨvazɨ Godɨn nɨghnɨzir gavgavim an iti. Ezɨ gumazamizir bar avɨrim Ekiam bagha ize. ");
INSERT INTO msy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","26","Ezɨ Barnabas Sol buriasa Tarsusɨn zui. Egha an apigha, a inigha Antioghɨn ize. Egha azenir vamɨra Barnabas ko Sol uaning inigha Kraisɨn adarazi koma uari akufa. Egha gumazamizir bar avɨriba men sure gami. Ezɨ Antiokra suren gumaziba faragha ziar kam, Kraisɨn gɨn zuir darazi, me a ini. ");
INSERT INTO msy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ezɨ dughiar kamnang, Godɨn akam inigha izir gumazir maba Jerusalemɨn ikegha Antioghɨn izaghiri. ");
INSERT INTO msy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ezɨ men mav, an ziam Agabus, a dɨkavigha tugha egha Godɨn Duamɨn gavgavimɨn ghaze, Romɨn nguaziba bar dagheba otevegham. (Sisar Klodius, atrivimɨn itir dughiamɨn bizir kam oto.) ");
INSERT INTO msy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ezɨ suren gumaziba akam mɨsuegha egha me vaghvagh uan dabirabimɨn mɨn dagɨaba anɨngɨva, Judian itir darazir akurvaghsɨ a da amangasa. ");
INSERT INTO msy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Egha kar me kamaghɨn ami, me uan dagɨaba isava, Barnabas koma Sol ganɨngizɨ, aning ghua men gumazir aruabagh anɨngi. ");
INSERT INTO msy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Dughiar kamɨn Atrivim Herot Kraisɨn adarazir marazir suigha me gasɨghasɨghasa. ");
INSERT INTO msy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Egha a mɨgeima, me Jonɨn aveghbuam Jems mɨdorozir sabamɨn a mɨsoghezɨma, an areme. ");
INSERT INTO msy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ezɨ Herot garima, an amizir arazir kam, Judaba a gifonge, kamaghɨn amizɨma, a uaghan Pita isa kalabus gatɨ. Herot Yis puvatɨzir Bretɨn Isamin Dughiamɨn bizir kam gami. ");
INSERT INTO msy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A Pitan suiraghava a isa kalabus gatɨ. Egha a isa mɨdorozir gumazir 4 plan okuruabar agharim gatɨ. Ezɨ me dughiaba isa vaghvagha an gari. Egha 4 plan okuruar kabanang, me dar vaghvagha 4 plan gumaziba inizɨma me an gari. Herot, God Israelbagh Itazir Dughiamɨn Isar Ekiar kam gɨvaghtɨma, a Pita isɨ gumazamizir avɨribar damazimɨn a kot darɨghasa. ");
INSERT INTO msy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ezɨ Pita kalabusɨn dɨpenimɨn aven itima Kraisɨn adarasi uan navir averiabar a bagha puvɨra God ko mɨgɨavɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Egha Herot Pita inigh kot bagh mangasa dughiar mam dɨboro. Ezɨ dɨmagarir kamɨn, amɨnim tɨghar tiam, me senɨn pumuningɨn a ikezɨma a mɨdorozir gumazir pumuningɨn tongɨn akui. Ezɨ mɨdorozir gumazir igharazir maba kalabuziar dɨpenimɨn a bagha gara tiar akamɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ezɨ zuamɨra Ekiamɨn ensel otozɨma, an angazangarim kalabuziar dɨpenimɨn aven sira. Egha ensel Pitan ivim a mɨsuegha a gaghura kamaghɨn mɨgei, “Nɨ zuamɨra dɨkafigh!” Ezɨma senɨn an agharimning gikezimning fɨriaghrɨgha nguazim girɨ. ");
INSERT INTO msy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ezɨ ensel a mɨgei, “Korotiam arughɨva, egh dagarir asuabar aghuigh.” Ezɨ Pita kamaghɨn amigha gɨvazɨ ensel a mɨgei, “Nɨ uan korotiar ruarim arugh nan gɨn izɨ.” ");
INSERT INTO msy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ezɨ Pita kalabuziar dɨpenim ategha, enselɨn gɨn azenan ghu. Egha a bizir kabagh fozir puvatɨzɨma, ensel dagh amima, da guizbangɨram otifi. Pitan nɨghnɨzim ghaze, a irebamɨn mɨn bizimɨn gari. ");
INSERT INTO msy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Aning ghuava, kalabusɨn dɨpenimɨn garir gumazir pumuning gitagha, ghua kalabusɨn zuir ainɨn tiar akar nguibar ekiamɨn zuimɨn oto. Aning an otozɨ, tiam uabɨ kuiaghrɨzɨma, aning azenan ghua tuavir mamɨn zui. Aning mong saghon ghuava, ensel zuamɨrama Pita ategha ghu. ");
INSERT INTO msy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ezɨ Pitan nɨghnɨzim ua izima, a kamaghɨn mɨgei, “Kɨ datɨrɨghɨn guizbangɨra fo, Ekiam uan ensel amadazɨma a ize. Egha a Herotɨn agharim da nan akura, egha Judaba na damuasa nɨghnɨzir bizir kuraba sara nan akura.” ");
INSERT INTO msy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ezɨ Pita bizir kabagh foghava, Jonɨn amebam Marian dɨpenimɨn ghu. Jonɨn ziar mam Mak. Ezɨ gumazamizir avɨrim uari akuvagha dɨpenir kamɨn ikiava God ko mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ezɨ Pita azenan ikiava dɨvazimɨn tiar akar azenan itim gafughafuzima, ingangarir amizimɨn ziam Roda, a bagha tiam kuasa izi. ");
INSERT INTO msy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Egha a Pitan tiarim baregha, bar akuegha, tiam kuizir puvatɨgha uamategha ivegha aven ghugha, kamaghɨn gumazamizibav gɨa ghaze, “Pita muna iza tiar akamɨn iti!” ");
INSERT INTO msy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ezɨ me kamaghɨn a mɨgei, “Nɨ onganis ti.” Ezɨ a bar gavgavigha kamaghɨn mɨgei, “Puvatɨ. Guizbangɨra a iti.” Ezɨ me a mɨgɨa ghaze, “Nɨ ti an enselɨn gani.” ");
INSERT INTO msy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ezɨ Pita tiam gafughafuzima, me izava tiam kuigha an apigha, dɨgavir kuram gami. ");
INSERT INTO msy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ezɨ Pita uan dafarimɨn me aminivazɨma, me aghumra iti. Ezɨ an Ekiam kalabuziar dɨpenimɨn aven a inigha azenan anetɨzir arazibagh eghari. Egha a kamaghɨn mɨgei, “Ia bizir kabar gun Jems koma aveghbuaba sara mɨkemegh.” Egha Pita me ategha danganir igharazimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Egha amɨnim tirazɨma, mɨdorozir gumaziba Pita bagh garava avenge. Egha bar dɨgavir kuram gamigha uarira uarir azangsɨgha ghaze, “Pita managh ghu?” ");
INSERT INTO msy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ezɨ Pita itir puvatɨzɨma, Herot a gumazibav kemezɨma me Pita buriasa ghue. Egha me tong bar an apizir puvatɨ. Kamaghɨn amizɨma an mɨdorozir gumazir Pitan ganiziba, Herot me isa kot gatɨgha egha ghaze, me aremegham. Egha Herot gɨn Judian danganim ategha, Sesarian nguibar ekiamɨn ikiasa uaghirɨ. ");
INSERT INTO msy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Egha Herot adarim Tair koma Saidonian gumazamizibar iti. Me Herot garir nguibar ekiamɨn uan dagheba isi, kamaghɨn amizɨ, me datɨrɨghɨn uari akuvaghav izav an ganasa. Me faraghav Blastus ko uari mɨkemezɨ a me ko navir amɨrɨzim inis. Blastus, an Atrivim Herot akuir danganimɨn garir gumazim. Ezɨma, me gɨn Herot men apangkuvigh adarir kam a gɨvaghasa, me Herotɨn ganasa zui ");
INSERT INTO msy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herot dughiar atɨzimɨn uan atrivir korotiaba arughava, egha uan atrivimɨn dabirabim gaperaghava, gumazamizibav gei. ");
INSERT INTO msy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ezɨ me pamtem diava ghaze, “Kar gumazitam mɨgeir puvatɨ. Kar godɨn mam mɨgei.” ");
INSERT INTO msy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herot Godɨn ziam fer puvatɨ, kamaghɨn amizɨma Ekiamɨn ensel zuamɨra a mɨsoghezɨma a irɨ. Ezɨma muriamɨn itir apiziba angamra anepa zuima, an areme. ");
INSERT INTO msy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ezɨma Godɨn akam nguibaba bar dar ghua bar ekevegha ghuavɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ezɨ Barnabas koma Sol aning uan ingangarim Jerusalemɨn anegɨvagha, uamategha Antioghɨn ghu. Jon, an ziar mam Mak, aning a inighava a sara ghu. ");
INSERT INTO msy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioghɨn itir Kraisɨn adarasi, men marazi iti, Godɨn akam inigha izir gumaziba ko tisaba. Men ziaba Barnabas, ko Simeon (an ziar mam Niger,) Sairinɨn Lusius, koma Manain (a Atrivim Herotɨn roroam, a Herot koma aghungi) ko Sol. ");
INSERT INTO msy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ezɨma dughiar mamɨn Kraisɨn adarasi, me Godɨn apengan ikiava uari isava God ganighava, egha God ko mɨkɨmasa dagheba ta. Ezɨ Godɨn Duam kamaghɨn me mɨgei, “Kɨ Barnabas ko Sol uan ingangarim bagha aningɨn dia. Ia ingangarir kam bagh aning amɨseveghtɨma, aning nan ingangarim bagh mangɨ.” ");
INSERT INTO msy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kamaghɨn me God ko mɨkɨmasava dagheba tagha, God ko mɨgei. Egha uan aghariba isava Barnabas ko Sol gisɨn atɨghava, aning amadazɨma aning zui. ");
INSERT INTO msy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ezɨma Godɨn Duam Barnabas ko Sol amadazɨma, aning Selusian nguibar ekiamɨn ghugha, ua kurim inigha Saiprusɨn arighatɨzimɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Egha me Salamisɨn otivigha Godɨn akam Judabar God ko mɨgeir dɨpenibar akam akuri. Jon Mak aning ko ghua egha aningɨn akura. ");
INSERT INTO msy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Egha me Saiprusɨn nguibar arighatɨzim a garua ghuava Pafosɨn nguibar ekiamɨn oto. Egha me Judan kukunir gumazir mam bato. A Godɨn akam inigha izir ifavarir gumazim, an ziam Bar-Iesus. ");
INSERT INTO msy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A Sergius Paulus, gavmanɨn dapanim a ko iti. Sergius Paulus, a gumazir nɨghnɨzim koma fofozir aghuiba iti. Ezɨ a Godɨn akam baraghasava, kamaghɨn a Pol koma Barnabasɨn diazɨma aning ize. ");
INSERT INTO msy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Me kukunir gumazir kam Grighɨn akamɨn ziar kam Elimas me a gatɨ, an mɨngarim kukunir gumazim. Egha Elimas, a gavmanɨn gumazim Sergius Paulus, a Iesus nɨghnɨzir gavgavim an ikian an aghua. Kamaghɨn, a Barnabas ko Solɨn ingangarim pazɨva a damuasa. ");
INSERT INTO msy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ezɨma Sol, an ziar mam Pol, Godɨn Duam a gizɨvazɨma, ezɨ a dɨkɨravɨra Elimasɨn garava kamaghɨn mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nɨ Satanɨn borim. Egha nɨ arazir aghuaribar apanimɨn iti. Egha ifavarir araziba ko arazir kuraba bar nɨ gizɨfa. Egha nɨ tizim baghavɨra Ekiamɨn arazir aghuibagh asɨghasɨsi? Nɨ ti arazir kuraba ataghraghan aghua? ");
INSERT INTO msy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Datɨrɨghɨn Ekiam nɨn apanim damuva uan gavgavimɨn nɨn damazimning okavigham. Eghtɨma, nɨ aruer angazangarimɨn ganan kogh dughiatabar ikegham.” Ezɨma zuamɨra ghuariam an damazimning korozɨma amɨnim an pɨri. Egha a tavɨn agharimɨn suiraghasa pura ruiava asaghinifi. ");
INSERT INTO msy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Egha gavmanɨn gumazir dapanim Ekiamɨn akam bareghava dɨgavir kuram gami. A bizir otivizir kabar ganighava egha kamaghɨn nɨghnɨzir gavgavim Ekiamɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ezɨ Pol, a ko aruir gumaziba sara, me kurim Pafosɨn me inigha ghua Pergan nguibamɨn otifi. A Pamfilian Provinsɨn aven iti. Ezɨ Jon Mak kagh me ategha uamategha Jerusalemɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ezɨ me Pergan nguibamɨn dɨkavigha ghua Antioghɨn nguibamɨn otifi, a Pisidian Distrighɨn aven iti. Egha, Judaba avughsa Godɨn ziam fer dughiamɨn, me God ko mɨgeir dɨpenimɨn aven ghueghava apiaghav iti. ");
INSERT INTO msy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ezɨ God ko mɨgeir dɨpenimɨn garir gumazir dapanir ekiaba, me Moses Osirizir Araziba ko Godɨn akam inigha izir gumazibar akaba dar bora me mɨgei. Me dar ponegha gɨvaghava, me Pol ko Barnabasɨn akam mɨgɨa ghaze, “Aveghbuaba, ia akurvazir mɨgɨrɨgɨatam gumazir kabav mɨkɨmsɨva, ia me mɨkɨm.” ");
INSERT INTO msy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ezɨ Pol dɨkavighava, uan dafarimɨn me aminiva, kamaghɨn mɨgɨa ghaze, “Ia Israelɨn gumaziba ko Kantrin Igharazibar Gumaziba, Godɨn apengan ikiava uari isava God ganɨdi, ia na baragh! ");
INSERT INTO msy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dughiar kamɨn me Israelɨn ikiava, Israelbar God en ovaviba amɨseveghava, gumazibagh amim me bar avɨraseme. Eghava a uan gavgavimɨn Isipɨn me inighava azenim gatɨ. Fomɨra Israelɨn gumazamizibar God en ovaviba amɨsevezɨma, kamaghɨn me an gumazamizibara. Egha gɨn me uan nguibam ategha ghua Isipɨn kantrin ghue. Egha dughiar kamɨn God me gamima men dɨbobonim bar pɨn ghua, me bar avɨraseme. Ezɨma gɨn God uan gavgavimɨn Isipɨn me inighava azenim gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Egha a 40 pla azenimɨn gumaziba puvatɨzir danganim me ko ikiava, men osɨmtɨziba aterava men akurvasi. ");
INSERT INTO msy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Eghava Kenanɨn nguazimɨn, God 7 plan gumazamizir bɨzim gasɨghasɨghava, men nguazim uan gumaziba ko amizibagh anɨngi. Ezɨma me dar ghuaviba ikiangi. ");
INSERT INTO msy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Bizir kaba 450 azenimɨn aven otifi. “Egha bizir kabar gɨn God Israelbar ganasa gumazir dapaniba amɨsefe, mamaghɨra ikia ghua Godɨn akam inigha izir gumazim Samuelɨn dughiamɨn tu. ");
INSERT INTO msy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","“Ezɨ me atrivim bagha Godɨn azangsɨsi. Ezɨma a Sol me ganɨngi, Kisɨn otarim, Benjaminɨn adarasi, a 40 plan azenibar men gari. ");
INSERT INTO msy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ezɨ God Sol agɨvaghava, Devit amɨsevezɨma an an danganim inighava atrivimɨn oto. Ezɨma a Devitɨn gun me mɨgei, ‘Kɨ Devitɨn gani, Jesin otarim, gumazir kɨ bar ifongezim, a bar bizir kɨ ifongezibar amuam.’ ");
INSERT INTO msy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“God fomɨra akam akɨrɨzir moghɨn, God gumazir mam amadazɨ a Israelɨn ize. A Iesus, Devitɨn ovavir mam, en Akurvazir Gumazim. ");
INSERT INTO msy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","“Iesus tɨghar izamin dughiamɨn, Jon faragha izava navibagh iraghamin akam ko rurumɨn akamɨn Israelɨn gumazibav gei. ");
INSERT INTO msy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jonɨn ingangarir dughiam gɨvasava amima, a kamaghɨn me mɨgei, ‘Ia ghaze, kɨ tina? Kɨ gumazir ia mɨzuaim puvatɨ. A nan gɨn izi. Kɨ an dagarir asuabar beniba fɨran kogham. Kɨ gumazir kɨnim.’ ");
INSERT INTO msy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Aveghbuaba, ia Abrahamɨn igiaba, koma ia God gɨfuegha an apengan itir Kantrin Igharazibar Gumaziba, e bagha, God uam e iniasava mɨgɨrɨgɨar kam amadazɨma a ize. ");
INSERT INTO msy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalemɨn gumazamiziba koma gumazir dapanir ekiaba, me kamaghɨn fozir puvatɨ, Iesus en Akurvazir Gumazim. Egha me zurara Sabatɨn dughiamɨn Godɨn akam inigha izir gumazimɨn akaba dɨbora, egha deragha dagh fozir puvatɨ. Egha ghaze gumazir kam aremegham. Kamaghɨn amizɨma, Godɨn akam inigha izir gumazimɨn akaba guizbangɨra otos. ");
INSERT INTO msy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Egha me a mɨsueghtɨma an aremeghan mɨgɨrɨgɨar otevir aghuitam batozir puvatɨ. Ezɨ me kamaghɨn Pailat pamten a mɨgɨa ghaze, nɨ mɨdorozir gumazibav kemeghtɨ me a mɨsoghtɨ an aremegham. ");
INSERT INTO msy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Me fomɨrama Godɨn akam inigha izir gumaziba mɨkemezɨ moghɨn ami. Egha me ter ighuvimɨn anedeghava a inigha dagɨar torim gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ezɨma God a gamizɨma a ua dɨkafi. ");
INSERT INTO msy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A koma Galilin ikiava Jerusalemɨn zuir gumazamiziba dughiar avɨribar an gani. Ezɨ datɨrɨghɨn gumazir uari an ganizir kaba, me an gun Judan gumazamizibav gei. ");
INSERT INTO msy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“E akar aghuim kamaghɨn ia mɨgei. God fomɨra en ovaviba bagha amizir akam akɨra ghaze, a gumazir uam e iniamim amadagham. ");
INSERT INTO msy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Datɨrɨghɨn a Iesus a gamizɨma a matmatɨn ua dɨkafi. E men boriba, kamaghɨn amizɨma an e bagha uan akar dɨkɨrɨzir kam gamizɨma a guizbangɨra oto. Ighiamɨn Akɨnafarir Namba 2, kamaghɨn a mɨgei, ‘Nɨ nan otarim; ezɨ datɨrɨghɨn kɨ nɨn afeziamɨn otos.’ ");
INSERT INTO msy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E fo, God a gamizɨma a ua matmatɨn dɨkafi. Ezɨ a ua matmatɨn mangɨ kurighan kogham. God bizir kamɨn kamaghɨn mɨkeme, ‘Kɨ guizbangɨra deraghvɨra ia damuva, bizir aghuiba ia danɨngam, kɨ fomɨra Atrivim Devit akar dɨkɨrɨzibar a mɨkemezɨ moghɨn. Ezɨ bizir kam kɨ mɨkemezɨ moghɨn guizbangɨram otivam.’ ");
INSERT INTO msy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ezɨ akar igharazir mam uaghan Godɨn Akɨnafarimɨn iti. A kamaghɨn mɨgei, ‘Nɨ uan ingangarim bagha mɨsevezir gumazim ateghtɨma, a matmatɨn ikɨ kurighan kogham.’ ");
INSERT INTO msy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“E fo, dughiar kamɨn Devit nguazimɨn ikiava, a Godɨn nɨghnɨzimɨn gɨn zui. Egha a gɨn aremezɨma, me an kuam inigha ghua an ovaviba afir naghɨn anefa. Ezɨma an kuam kuri. ");
INSERT INTO msy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","38","Ezɨ gumazir God amizɨ a ua matmatɨn dɨkavizir kamnang, an kuam kurizir puvatɨ. Nan adarasi, kamaghɨn amizɨma, e ua mɨgei, ia akar kam gɨfogh, gumazir kam Iesus ian arazir kuraba gɨn amangasa ize. ");
INSERT INTO msy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses Osirizir Araziba ian akuragh ian arazir kuraba gɨn amadaghan koghtɨ, ia Godɨn damazimɨn deragham. Puvatɨ. Gumazir kam Iesusɨn ingangarimɨn, God gumazir nɨghnɨzir gavgaviba itiba bar, men akuragha men arazir kuraba bar, da gɨn amagava, me gamima me an damazimɨn dera. ");
INSERT INTO msy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ia uari bagha gan, Godɨn akam inigha izir gumaziba fomɨra mɨkemezir moghɨn, bizitam ia batoghan kogham: ");
INSERT INTO msy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kɨ ian dughiamɨn bizir igharazitam damightɨma a ia batogham. Eghtɨma gumazitam ia mɨkɨmtɨma ia nɨghnɨzir gavgavim an ikian kogham. Kamaghɨn, ia gumazir dɨbovir akar kurabagh amiba, ia gan, ia dɨgavir kuram damigh ikuvigham.’” ");
INSERT INTO msy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Egha Pol ko Barnabas Judabar God ko mɨgeir dɨpenim ataghrazima, gumazamiziba kamaghɨn aningɨn mɨgei, “Gua Sabatɨn munamɨn dughiamɨn uamategh izɨva bizir kabar mɨgɨrɨgɨar tabar uam e mɨkɨm.” ");
INSERT INTO msy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Egha me bar God ko mɨgeir dɨpenim ateghava azenan ghue. Ezɨ Judan avɨrim ko gumazir igharaziba, me Judan araziba bar dar gɨn zuir gumaziba, me Pol koma Barnabasɨn gɨn zui. Ezɨma aning me mɨgɨava, men nɨghnɨziba fa ghaze, ia Godɨn nɨghnɨzimɨn gɨn mangɨva an apangkuvimɨn apengan ikɨ. ");
INSERT INTO msy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ezɨ Sabatɨn dughiar igharazim otozɨ, nguibar ekiar kamɨn itir gumazamizir avɨrim bar iza uari akuvaghava Ekiamɨn akam barasi. ");
INSERT INTO msy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ezɨ Judaba gumazamizir okuruar kamɨn ganigha, men naviba bar ikufi. Ezɨma me Polɨn akaba kurakuraghava a mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kamaghɨn amizɨma Pol ko Barnabas atiatir puvatɨgha, akar bar gavgavimɨn me mɨgei, “Ia Judaba, ga faragha Godɨn akamɨn ia mɨkeme. Ezɨ ia akɨrim ragha akar kam gasara. Egha ghaze, e ikɨrɨmɨrir aghuir zurara itim inian kogham. Kamaghɨn amizɨma, ia oragh, ga uam akar kamɨn ia mɨkɨman kogham. Ga Kantrin Igharazibar Gumazibav kɨmam. ");
INSERT INTO msy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ekiam bizir kam bagha kamaghɨn e mɨkeme: ‘Nɨ nguazir kamɨn itir gumazamiziba bar men akuraghtɨma kɨ ua me iniasa, bizir kam bagh, kɨ nɨ amɨsevezɨma, nɨ tuavim Kantrin Igharazibar Gumazibar aka.’” ");
INSERT INTO msy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ezɨ Kantrin Igharazibar Gumaziba, me akar kam baregha, bar akuegha ghaze, akar kam bar dera. Ezɨ gumazamizir God ikɨrɨmɨrir aghuir zurara ikiam bagha mɨseveziba, me bar nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ezɨ Ekiamɨn akam bar nguibaba bar dar ghu. ");
INSERT INTO msy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amizir maba God gifueghava an apengan ikiava ziar ekiaba iti, ezɨ gumazir iziaba itir maba, me uaghan nguibar ekiar kamɨn iti. Judaba men navibagh inivima, me osɨmtɨziba Pol ko Barnabas garɨsi. Egha me uan distrighɨn aning batoke. ");
INSERT INTO msy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kamaghɨn amizɨma, Pol ko Barnabas, uan dagarimningɨn itir nguaziba apɨsi, eghtɨma gumazamiziba fogh suam, men arazir kam osɨmtɨzim me ganɨngi. Ezɨma, Pol ko Barnabas Antiok ategha Aikoniam nguibamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Kamaghɨn amizɨ Antioghɨn itir Kraisɨn suren gumaziba, Godɨn Duam bar me gizɨvazɨma me bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Egha Pol ko Barnabas Antioghɨn ikiav amizir arazibara, aning izava Aikoniamɨn Judaba God ko mɨgeir dɨpenibar dagh ami. Egha kagh aning bar deraghvɨra akam akurima, Judan avɨriba ko Kantrin Igharazibar Gumazir avɨriba nɨghnɨzir gavgavim Iesusɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Egha Judan marazi nɨghnɨzir gavgavim men akabar ikian aghuagha Kantrin Igharazibar Gumazibar nɨghnɨzibagh asɨghasɨghava men navibagh inivima, me nɨghnɨzir kurabar nɨghnɨzir gavgavim Iesusɨn itir darazigh ami. ");
INSERT INTO msy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Egha Pol ko Barnabas dughiar ruarimɨn Aikoniamɨn ikiava, Ekiamɨn apangkuvimɨn akam mɨkɨmasava atiatir puvatɨ. Ezɨma Ekiam gavgavim aning ganɨngizɨma, aning mirakelba ko dɨgavir kuram gamir bizibagh amima, da otifi. Ezɨ kamaghɨn Ekiam gumazamizibar akakagha ghaze, akar aning me mɨgeir kaba, da guizɨn akaba. ");
INSERT INTO msy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ezɨ nguibar ekiar kamɨn itir gumazamiziba uari abɨki, marazi Judabar gɨn zuima, marazi aposelning bagha zui. ");
INSERT INTO msy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Egha gɨn Judaba ko Kantrin Igharazibar Gumaziba, me uan gumazir dapanir ekiaba ko, me nɨghnɨgha tuaviba buria mɨgɨa ghaze, me Pol ko Barnabas aremeghasa, me arazir kurabar aning damuasa ifonge. Egha me dagɨabar aning ginivasava ami. ");
INSERT INTO msy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ezɨma Pol ko Barnabas kamaghɨn oreghava arava Listra ko Derben ghu, aning Likonian Distrighɨn nguibar ekiamning. Egha uaghan nguibar aningɨn boroghɨra itiba sara ghu. ");
INSERT INTO msy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Egha aning kagh akar aghuim akuravɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Egha Listran nguibar ekiamɨn aven gumazir mam, an dagarimning ikuvighava an amɨrazɨma an aruir puvatɨghava aperaghavɨra iti. An amebam a batezɨma a kamaghɨra gari. ");
INSERT INTO msy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A Pol barazima an akam akuri. Ezɨma Pol dɨkɨravɨram an gara egha kamaghɨn fo, gumazir kam nɨghnɨzir gavgavim iti, a deragham. ");
INSERT INTO msy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Egha Pol kamaghɨn pamtemɨn dia, “Nɨ dɨkavigh mɨtɨgh!” Ezɨ gumazir kam uabɨ ekunigha mɨtɨgha maghɨram arui. ");
INSERT INTO msy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Egha gumazamizir avɨrir kam Pol amizir bizir kamɨn ganigha, pamtemɨn Likonian akamɨn dia mɨgei, “Aseba gumazibar mɨn otivigha e baghava izaghire!” ");
INSERT INTO msy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Egha Barnabas, me asem Sus a gatɨ. Pol a mɨgɨrɨgɨabar faragha zuir gumazim, kamaghɨn me asem Hermes a gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Asem Susɨn dɨpenim, a Listran nguibar ekiamɨn mɨn azenan iti. Ezɨ Susɨn ofa gamir gumazim, a ko gumazir avɨriba, me Pol ko Barnabas bagha asɨzibav sueghɨva aningɨn ofa damuasa. Kamaghɨn, a bulmakaun apuriba ko akɨmarir bɨzizɨba inigha Listran nguibar ekiamɨn tiar akamɨn ize. ");
INSERT INTO msy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Egha aposelning Pol ko Barnabas, aning bizir kaba baregha, aning uan korotiaba abɨagharigha, ivegha gumaziba itir okuruamɨn aven ghua pamtem dia mɨgei, ");
INSERT INTO msy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Maia! Gumaziba, ia tizim bagha arazir kam gami? Ga uaghan ian mɨn gari, pura gumazir kɨnimning. Ga kamagh sua akar aghuir kam ia mɨgei. Ia pura bizir kɨnir kabar ziaba fan markɨ. Egh ia uari isɨva Ekiam danɨng, angamra itir God. A Godɨn overiam ko nguazim ko ongarim gamizim, egha bizir dar itiba sara bar. ");
INSERT INTO msy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Fomɨra, God nguibaba bar, me ataghizɨma me pura uan nɨghnɨzibar arua bizibagh ami. ");
INSERT INTO msy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Egha a ian modozir puvatɨ, eghtɨ gumaziba a gɨfoghan kogham. puvatɨ. A zuraram arazir aghuibar ia gamuava, amozim ia ganɨga, dagher aghuir avɨriba ia ganɨga egha dagher aghuibagh ami da otifi. Egha ia gamima ian naviba deragha bar akonge.” ");
INSERT INTO msy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Aning bizir kabar pamten me mɨgɨa, uaningɨn ofa damuan men anogoroghavɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ezɨ gɨn Judan gumazir maba Antiok ko Aikoniamɨn ikegha Listran izegha, me gumazibar nɨghnɨzibagh ekuigha me gamizɨ, me Polɨn apanibar otifi. Egha me dagɨabar Pol ginivigha an ganigha ghaze, an aremes. Egha anemɨkɨrɨgha Listran nguibar ekiamɨn azenan ghu. ");
INSERT INTO msy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ezɨ gɨn suren gumaziba izava anekuvazɨ, a dɨkavigha uamategha Listran nguibar ekiamɨn ghu. Egha dughiar igharazimɨn a ko Barnabas ghua Derben zui. ");
INSERT INTO msy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Egha Pol ko Barnabas Derben nguibar ekiamɨn ikiava akar aghuim akurava gumazamizir avɨribagh amima, me suren gumazibar otifi. Egha aning uamategha Listra ko Aikoniam ko Antioghɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Egha aning gavgavim suren gumazibagh anɨghava akurvazir mɨgɨrɨgɨabar me gamua ghaze, ia uan nɨghnɨzir gavgavibar tuivigh gavgafigh. Aning kamaghɨn me mɨgɨa ghaze, “Gumazamizir God Ativaziba, e uaghan men avɨrir kamɨn aven mangɨsɨ, e faragh osɨmtɨzir avɨribar aven mangɨgham.” ");
INSERT INTO msy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Egha Pol ko Barnabas Kraisɨn adarazi itir nguibaba bagha vaghvagha Godɨn ingangarir gumazir aruaba amɨsefe. Godɨn ingangarir gumazir aruar kaba uan nɨghnɨzir gavgaviba Ekiam gatɨs. Ezɨ aning me bagha dagheba taghragha Ekiam ko mɨkemegha bar me isava Ekiamɨn agharim gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Egha Pol ko Barnabas Pisidian Distrighɨn ghugha gɨn iza Pamfilian Provinsɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Egha aning Pergan nguibamɨn akar aghuim akunigha gɨvagha Atalian nguibam uaghirɨ. ");
INSERT INTO msy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Egha aning Atalian ikegha kurim inigha uamategha Antioghɨn nguibamɨn ghu. Nguibar kamra, aning kagh faragha ikezɨ, Antioghɨn itir Kraisɨn adarasi aning isava Godɨn agharim ganɨnga ghaze, Godɨn apangkuvim aning ko ikɨtɨ aning ingangarir kam damuam. Ezɨ aning ingangarir kam gamua iza datɨrɨghɨn anegɨfa. Egha aning uamategha Antioghɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Egha aning Antioghɨn otogha, Kraisɨn adarazir diazɨma me uari akuvazɨma aning bizir God aningɨn agharimningɨn amizibar gun bar me mɨgei. Egha uaghan God Kantrin Igharazibar Gumaziba bagha nɨghnɨzir gavgavimɨn tiam kuizir akam me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Egha aning kagh dughiar ruarimɨn suren gumaziba ko ike. ");
INSERT INTO msy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ezɨ Judian Distrighɨn gumazir maba Antioghɨn izegha Kraisɨn adarazir sure gamua ghaze, “Ia Moses sure gamizir arazimɨn moghɨn ua mɨkarzir mogomeba aghoran koghtɨ, God guizbangɨra ua ia inighan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ezɨ kamaghɨn Pol ko Barnabas maburan odorozim me koma a gami. Kamaghɨn amizɨ Kraisɨn adarasi Pol ko Barnabas ko nɨghnɨzir gavgavim Iesusɨn itir gumazir maba sara me amɨsevegha ghaze, me Jerusalemɨn mangɨ bizir kam bagh aposelba ko Godɨn ingangarir gumazir aruabav kɨmasa. ");
INSERT INTO msy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Egha Kraisɨn adarasi me amadazɨma me zui. Me Fonisian Distrigh ko Samarian moghɨn ghua egha Kantrin Igharazibar Gumaziba uan navibagh irazir bizimɨn gun me mɨgei. Ezɨ Kraisɨn adarasi bar mɨgɨrɨgɨar kam baregha bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ezɨ Pol ko Barnabas ko Godɨn ingangarir gumazir aruaba, me Jerusalemɨn otivizɨ, aposelba ko Kraisɨn adarazi ko men gumazir dapaniba bar akuegha me ini. Ezɨ Pol ko Barnabas God aningɨn agharimɨn amizir biziba. aning dar gun me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ezɨ nɨghnɨzir gavgavim Iesusɨn itir gumazir maba, me fomɨra Farisibar mɨn ikia, me dɨkavigha kamaghɨn mɨgei, “Kantrin Igharazibar Gumaziba uaghan Moses Osirizir Arazibar gɨn mangɨva uan mɨkarzir mogomebar aghor.” ");
INSERT INTO msy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ezɨ aposelba ko Godɨn ingangarir gumazir aruaba akar kam akɨrasa uari akufa. ");
INSERT INTO msy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Dughiar ruarimɨn me bizir kam mɨgɨa ghua, egha Pita dɨkavigha me mɨgei, “Nan adarasi, ia fo dughiar maba gɨvazɨ God kamaghɨn ifonge, Kantrin Igharazibar Gumaziba nan akar torimɨn akar aghuimɨn mɨgɨrɨgɨam bareghɨva nɨghnɨzir gavgavim Iesusɨn ikiam. Egha a ian tongɨn na mɨsefe. ");
INSERT INTO msy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","E fo, God gumazamizibar navir averiabagh fo. Egha a uan Duam me ganɨngi. An e gamizɨ moghɨra, me gami. Egha tuavir kamɨn a kamaghɨn en aka, a me gifuegha ua me ini. ");
INSERT INTO msy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Godɨn damazimɨn Judaba ko Kantrin Igharazibar Gumaziba, e bar magh ghue. Kantrin Igharazibar Gumaziba nɨghnɨzir gavgavim Iesusɨn itima, God men nɨghnɨzir gavgavimɨn tuavimɨn, men navibagh amizɨ me an damazimɨn dera ");
INSERT INTO msy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ezɨ kamaghɨn ia tizim bagh God damightɨ, a ian nɨghnɨzibar gɨn mangam? Egha osɨmtɨzir faragha en ovaviba ateran iburaziba ko osɨmtɨzir e uaghan datɨrɨghɨn ateran iburaziba, da isava nɨghnɨzir gavgavim Iesusɨn itir darazigh arɨsi. ");
INSERT INTO msy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Kamaghɨn puvatɨ. En nɨghnɨzir gavgavim ghaze, en Ekiam Iesusɨn apangkuvimɨn, God uam e inizir moghɨra me ini.” ");
INSERT INTO msy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ezɨ gumazir uari akuvaziba bar nɨmɨra ikia Barnabas ko Pol barasi. Ezɨma aning mirakelɨn arazaraziba ko dɨgavir kuram gamir bizibar gun me mɨgei. Egha aning ghaze, God aningɨn agharibar arazir kaba Kantrin Igharazibar Gumazibar tongɨn, dar ingari. ");
INSERT INTO msy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aning mɨkemegha gɨvazɨ Jems kamaghɨn mɨgei, “Nan adarasi, ia na baragh. ");
INSERT INTO msy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon kamaghɨn e geghara ghaze, kar faragha zuir dughiam, God Kantrin Igharazibar Gumaziba uan apangkuvim men akagha, men tongɨn gumazir maba ua bagha me inigha me gamizɨ, me an gumazamizibar otifi. ");
INSERT INTO msy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Godɨn akam inigha izir gumazibar mɨgɨrɨgɨamɨn mɨrara ghu. Me fomɨra kamaghɨn osiri, men mɨgɨrɨgɨamɨn osizirimra kara, ");
INSERT INTO msy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘God kamaghɨn mɨgei, Devitɨn ovaviba asizir inibar amizir dɨpenimɨn mɨn degiaghɨrɨ. Egh kɨ gɨn uamategh izɨ, an ingarightɨ a tugham. An bizir ikuviziba kɨ ua dar ingarigham, egh kɨ a damightɨ a ua deragham. ");
INSERT INTO msy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Eghtɨ gumazamizir ikiavɨra itir naba God bagh ruiam. Kantrin Igharazibar Gumazir nan ziamɨn itiba bar uaghan na buriam. ");
INSERT INTO msy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ekiam kamaghɨn mɨkeme. A bizir kaba fomɨra gumazamizibar akazɨ me dagh fo.’” ");
INSERT INTO msy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Egha Jems ghua kamagh mɨgei, “Nan nɨghnɨzimra kara, Kantrin Igharazibar Gumaziba, me navibagh iragha God bagha zui. Eghtɨ e men tuaviba apɨran kogham. ");
INSERT INTO msy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","E pura me bagh osir kamagh me mɨkɨm suam, ia me marvir guabagh anɨdir daghebar amɨ, egh ia Godɨn damazimɨn mɨzegham. Ia dagher kabar aman markɨ. Ia uari isava akuir arazir kurabar amuan markɨ. Egha asɨzir me benibar fɨribav kɨrima ariaghɨriba, dar ghuziba darara iti. Ia dar aman markɨ. Egh ia ghuzitam raman markɨ. ");
INSERT INTO msy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","E fo, Moses osirizir arazir kamnagh fomɨra iza datɨrɨghɨn, me an akam nguibar ekiabar aven bar anekurava, egha Sabatba zurara God ko mɨgeir dɨpenibar aven a dɨbori.” ");
INSERT INTO msy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Egha aposelba ko Godɨn ingangarir gumazir aruaba ko Jerusalemɨn itir Kraisɨn adarazi bar me mɨkemegha uari tongɨn gumazir maba mɨsevegha me amadazɨ me Pol ko Barnabas ko Antioghɨn zui. Me gumazir dapanir pumuning uaghan aning amɨsefe: Sailas ko Judas, an ziar mam Barsabas. Gumazir kamning Kraisɨn adarazir faragha zui. ");
INSERT INTO msy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Egha me akɨnafarir kam me koma anemada: E, aposelba ko Godɨn ingangarir gumazir aruaba, e ian adarasi. Ia Kantrin Igharazimɨn itir nɨghnɨzir gavgavim Iesusɨn itir darazi, ia Antioghɨn nguibar ekiam ko Sirian Provins ko Silisian itiba. Akɨnafarir kam ia bagha izi. Dughiar aghuim. ");
INSERT INTO msy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","E kamaghɨn oraki, en tongɨn marazi, en azarazir puvatɨgha ghua ia mɨgɨa ian nɨghnɨzibagh asɨghasɨki. Me ia gifarazɨ ia okam nɨghnɨsi. ");
INSERT INTO msy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kamaghɨn e bar navir vamɨra inigha gumazir maba ko en namakar aghuimning Barnabas ko Pol a mɨsevegha me amada. ");
INSERT INTO msy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Gumazir kamning, aning en Ekiam Krais Iesusɨn ziam bagha nguazir kamɨn ikɨrɨmɨrim ategha egha uaningɨn sa. ");
INSERT INTO msy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kamaghɨn amizɨ, Judas ko Sailas akamɨn uaghan ia mɨkɨmasa, e kamaghɨn aning amada. ");
INSERT INTO msy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","E Godɨn Duam ko navir vamɨra ikia kamaghɨn nɨghnɨgha ghaze, e osɨmtɨzitam ua ia darɨghan kogham. Bizir e ia mɨkemeziba, darara ia dar gɨn mangɨ. ");
INSERT INTO msy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ia me marvir guabagh anɨdir daghebar aman markɨ, egh asɨzibar ghuzibar aman markɨ, egh me beniba fɨribav kɨrima ariaghɨrir asizibar aman markɨ, egh uari isava akuir arazir kurabar amuan markɨ. Ia bizir kaba ategh deragham. En akam kamaghɨra tu. ");
INSERT INTO msy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Egha Jerusalem itir Kraisɨn Adarasi gumazir kaba amadazɨ, me Jerusalem ategha Antioghɨn iraghuegha Kraisɨn adarazi akuvagha akɨnafarim me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ezɨ Antioghɨn itir Kraisɨn adarazi akɨnafarir kam barazima, a gavgavim me ganiga men navibagh ami da dera. Ezɨ me bizir kam bagha bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas ko Sailas aning uaghan Godɨn akam inigha izir gumazimning. Egha aning mɨgɨrɨgɨar avɨribagh ami. Kamaghɨn aning gavgavim Kraisɨn adarazi ganɨga mɨgɨrɨgɨar akurvazir avɨriba me gami. ");
INSERT INTO msy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ezɨ me dughiar maba mong Antioghɨn me ko ike. Ezɨ gɨn Kraisɨn adarazi navir amɨrɨzim sara me amadazɨ, me Jerusalemɨn uamategha gumazir me amangiziba bagha zui. ");
INSERT INTO msy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ezɨ Pol ko Barnabas Antioghɨn ikiava avɨrir maba ko gumazamizibar sure gamua Ekiamɨn akam akuri. ");
INSERT INTO msy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ezɨ dughiar maba gɨvazɨ gɨn Pol kamaghɨn Barnabas mɨgei, “Ga uamategh nguibar ekiar ga bar Ekiamɨn akam akunizibar mangɨva, ga uan adarazir ganam, me manmaghɨn iti.” ");
INSERT INTO msy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ezɨ Barnabas kamaghɨn nɨghnɨsi, a Jon, an ziar mam Mak, an a inightɨma, a aningɨn gɨn mangam. ");
INSERT INTO msy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jon Mak Pamfilian purama aning ataki, egha aning ko ingangarim a gɨvazir puvatɨ. Kamaghɨn an aning ko mangan Pol aghua. ");
INSERT INTO msy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Egha aning odorozir dafam gamigha kamaghɨn aning uaning abɨki. Ezɨ Barnabas ko Mak kurim inigha arighatɨzim Saiprusɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ezɨ Pol Sailas amɨsefe. Ezɨ Kraisɨn adarazi uari akuvagha aning isa Godɨn agharim gatɨgha kamagh mɨgei, “Godɨn akurvazim gua ko ikɨ.” Ezɨ aning ghu. ");
INSERT INTO msy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Egha aning Sirian Provins ko Silisian moghɨn ghua Pol gavgavim Kraisɨn adarazigh anɨdi. ");
INSERT INTO msy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Egha Pol ghua Derben otogha ghua Listran oto. Ezɨ kagh suren gumazir mamɨn ziam Timoti, a iti. An amebam Judan amizim, a Kraisɨn mav. Ezɨma an afeziam Grighɨn gumazim. ");
INSERT INTO msy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra ko Aikoniamɨn itir en adarasi kamaghɨn a mɨgɨa ghaze, Timoti gumazir bar aghuim. ");
INSERT INTO msy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ezɨ Pol a inightɨma, an a ko mangasa ifonge. Judaba danganir kamɨn iti. Egha me bar foz, an afeziam Grighɨn gumazim. Kamagh sua Pol Timotin mɨkarzir mogomem atu. ");
INSERT INTO msy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Egha me nguibar ekiabagh arui. Akar aposelba ko Godɨn ingangarir gumazir aruaba Jerusalemɨn mɨkemegha amamangatɨzim, gumaziba da baragh, dar gɨn mangasa, me me mɨgɨa gharui. ");
INSERT INTO msy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kamaghɨn amizɨma Kraisɨn adarasi, men nɨghnɨzir gavgaviba gavgafi. Ezɨ men dɨbobonim dughiaba bar pɨn ghuavanadi. ");
INSERT INTO msy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ezɨ Godɨn Duam Pol, ko an gɨn aruir darazi, me Esian Provinsɨn akar aghuim kunan men anogoroke. Kamaghɨn amizɨ, Pol, Sailas, ko Timoti, me Frigian Distrighɨn nguibar ekiam ko Galesian Distrighɨn moghɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Egha me Misian Distrigh ko Bitinian Provins suizimningɨn otogha Bitinian Provinsɨn aven mangasava amima, Iesusɨn Duam men anegoroke. ");
INSERT INTO msy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ezɨ me kamaghɨn Misian Distrighɨn mɨriam gatɨgha, Troasɨn ira ghue. ");
INSERT INTO msy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ezɨ dɨmangan Pol irebamɨn mɨn bizimɨn garima, Masedonian Provinsɨn gumazim tughav ikiava agakaghora, egha ghaze, “Ia Masedonian izɨva en akuragh.” ");
INSERT INTO msy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol irebamɨn mɨn bizir kamɨn ganigha, e zuamɨra bizibar kɨrighava Masedonian mangasa tuavibar kɨri. E foz, God akar aghuim me mɨkɨnasav en dia. ");
INSERT INTO msy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Egha e Troasɨn kurim inigha Samotres baghavɨra zui. Egha amɨmɨzaraghan Neapolis bagha zui. ");
INSERT INTO msy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Egha e kagh dɨkavighava ghua Filipain otifi. Romba fomɨra izava apiazir nguibar ekiam. A Masedonian Distrighɨn nguibar faragha zuir mam. Eghava e kagh dughiar mabar ike. ");
INSERT INTO msy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ezɨ Sabatɨn dughiamɨn, e nguibar ekiamɨn tiar akamɨn azenan ghua dɨpamɨn uaghiri. E ghaze, God ko mɨkɨmamin danganitam ti kagh ikiama? Ezɨ e kagh amizir mabar garima me uari akuvagha itima, e me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Amizir e barazir kabanagh, mavɨn ziam Lidia, a faragha Taiatarian nguibar ekiamɨn ikiava izegha inir pɨghagheviba amadi. A zurara Godɨn ziam fer amizim. Ekiam an navim kuizɨma a Polɨn mɨgɨrɨgɨaba barasi. ");
INSERT INTO msy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Egha a ko an gara dɨpenir vamɨran itir darazi, e me ruegha gɨvazɨma, a uan dɨpenimɨn mangasa en gighami. A kamaghɨn mɨgɨa ghaze, “Ia suam, kɨ guizbangɨra nɨghnɨzir gavgavim Ekiamɨn ikɨtɨ, ia izɨ nan dɨpenimɨn ikɨ.” Egha a kamaghɨn e mɨgɨa bar e gakaghone. ");
INSERT INTO msy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Dughiar mamɨn e God ko mɨgeir danganimɨn zuima, ingangarir amizir igiam, duar kuram a gapazazɨ, an e bato. Duar kuram a gapazazɨma a gɨn otivamin bizibagh fogha dar gun mɨgei. Ezɨ kamaghɨn an garir gumaziba an amir ingangarir kamɨn dagɨar avɨriba isi. ");
INSERT INTO msy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ezɨ guivir kam, Pol ko bar en gɨn iza kamaghɨn dia mɨgei, “Gumazir kaba Godɨn bar pɨn itimɨn ingangarir gumaziba. Me God ian akurvaghamin tuavimɨn gun ia mɨgei.” ");
INSERT INTO msy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","A dughiar avɨribar kamaghɨn ami. Ezɨ Pol an amɨrɨgha raghrɨgha kamaghɨn duar kuram mɨgei, “Kɨ Krais Iesusɨn ziamɨn nɨ mɨgei, nɨ azenim girɨgh!” Ezɨ maghɨra duar kuram anetaki. ");
INSERT INTO msy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ezɨ an garir gumaziba fo, men dagɨaba isir tuavim pɨri. Kamaghɨn amizɨma me Pol ko Sailasɨn suiragha aning amɨkɨrɨgha gumazir dapanir ekiaba bagha danganir ekiamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Egha me aningɨn akua jas bagha ghugha kamaghɨn mɨgei, “Kar Judan gumazimning. Aning en nguibar ekiamɨn itir gumazamizibar navibagh inivima osɨmtɨzir avɨriba otifi. ");
INSERT INTO msy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Egha aning gumazamiziba, Romɨn kantri men anogoroghezir arazibar gɨn mangasa, me mɨgei.” ");
INSERT INTO msy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ezɨ gumazamiziba me iza uari akuvagha uaghan me akabar Pol ko Sailas gasi. Ezɨ jas mɨdorozir gumaziba mɨgɨa ghaze, ia aningɨn korotiaba suegh aning mɨsogh. ");
INSERT INTO msy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Me Pol ko Sailas puv aning mɨsuegha gɨvagha, aning isa kalabus gatɨ. Egha deraghɨva aning ganamin akar gavgavim isava, kalabusɨn garir gumazim ganɨngi. ");
INSERT INTO msy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ezɨma kalabusɨn dɨpenimɨn garir gumazim jasɨn akam baregha, egha aning isa selɨn danganir bar aven itim gatɨgha, aning sueba pamtem temem sara da ike. ");
INSERT INTO msy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ezɨ dɨmagarir arɨzimɨn Pol ko Sailas God ko mɨgɨava ighiabagh ami. Ezɨma kalabusɨn itir gumazir maba aning barasi. ");
INSERT INTO msy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ezɨ zuamɨra mɨkɨmkɨzir dafar mam otogha, kalabusɨn dɨpenimɨn dagɨar mɨngarir gavgavim anɨdibagh inoba. Ezɨ kalabusɨn tiar akaba zuamɨra kuiaghire. Ezɨ me kalabuziaba ikezir senba bar fɨriaghire. ");
INSERT INTO msy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ezɨ kalabusɨn dɨpenimɨn garir gumazim osegha dɨkavigha kalabusɨn dɨpenimɨn tiar akabar garima da bar kuiaghire, an nɨghnɨzim ghaze gumazir kalabusɨn itiba bar are. Kamaghɨn a uan bainat asigha egha uabɨ uabɨ bɨragh aremeghasa. ");
INSERT INTO msy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ezɨ Pol pamtemɨn dia, “Nɨ pazɨ uabɨ damuan markɨ! E bar ka iti.” ");
INSERT INTO msy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ezɨ kalabusɨn garir gumazim angazangariba bagha dei, egha ivegha ghua Pol ko Sailas itir danganimɨn ghua atiatia puvɨra nɨgha, egha aningɨn suebar irɨ. ");
INSERT INTO msy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Egha an aning inigha azenan otogha aningɨn azangsɨsi, “Aruamning, kɨ tizim damightɨma God nan akuragham?” ");
INSERT INTO msy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ezɨ aning a ikara, “Nɨ nɨghnɨzir gavgavim Ekiam Iesusɨn ikɨ, eghtɨ a nɨn akuragham, nɨ ko itir darasi sara.” ");
INSERT INTO msy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ezɨ aning Ekiamɨn akam a mɨgɨava egha uaghan a ko itir darazi bar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Dɨmagarir kamra, gumazir dapanir kam aning inigha egha aning duaba rue. Egha aning zuamɨra a koma uan adarazi Iesusɨn ziamɨn bar me rue. ");
INSERT INTO msy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ezɨ kalabusɨn gumazir dapanim Pol ko Sailas inigha uan dɨpenimɨn aven ghua, egha dagheba aning ganɨdi. A uan adarazi ko nɨghnɨzir gavgavim Godɨn iti. Kamaghɨn amizɨ, me bar akonge. ");
INSERT INTO msy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ezɨ amɨnim tirazɨma, jasba gavmanɨn gumaziba amadazɨma me iza kamaghɨn kalabuziar dapanim mɨgei, “Jasba kamaghɨn mɨgei, ‘Nɨ Pol ko Sailas ateghtɨma aning mangɨ.’” ");
INSERT INTO msy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ezɨ kalabuziar dapanim kamaghɨn Pol mɨgei, “Jasba nɨ ko Sailas ataghraghasa na mɨkeme. Ezɨma gua datɨrɨghɨn mangɨ. Gua navir amɨrɨzimɨn mangɨ.” ");
INSERT INTO msy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ezɨ Pol gavmanɨn gumazibav gei, “Ga Romɨn gumazimning. Me ga isa kot gatɨzir puvatɨgha gumazir avɨribar damazimɨn pura ga mɨsogha, ga isa kalabusɨn ga amada. Ezɨ me datɨrɨghɨn nɨmɨra ga amangasa? Puvatɨ! Me uari izɨva gan aku mangam.” ");
INSERT INTO msy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ezɨ gavmanɨn gumaziba akar kabar gun jasbav keme. Ezɨ me orazi Pol ko Sailas Romɨn gumazimning. Ezɨ me atiatingi. ");
INSERT INTO msy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kamaghɨn amizɨma, jasba kalabusɨn dɨpenimɨn ghu. Egha kamaghɨn aning mɨgɨa ghaze, gua ataran markɨ. Egha me aningɨn akua azenan ghuava, aningɨn azangsɨsi, “Gua nguibar ekiar kam ategh mangɨ.” ");
INSERT INTO msy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ezɨ aning kalabusɨn dɨpenim ategha Lidian dɨpenimɨn ghu. Egha Kraisɨn adarazir ganigha, akar maba me mɨgɨava, gavgavim me ganɨdi. Egha aning ghu. ");
INSERT INTO msy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol ko an gɨn aruir gumaziba, me Amfipolis ko Apolonian nguibamning ategha ghuavɨra ikia Tesalonikan nguibamɨn oto. Tesalonikan nguibamɨn aven, Judabar dɨpenir God ko mɨgeir mam iti. ");
INSERT INTO msy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Egha Pol God ko mɨgeir dɨpenimɨn aven ghu. Kar a zuraram amir arazim. Egha Sabatɨn pumuning ko mɨkezimɨn Godɨn Akɨnafarimɨn itir osiziriba me geghara me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","An osiziriba men akakagha dar mɨngaribav gɨa ghaze, “Krais mɨzazim inigh aremegh ua dɨkavamin mɨgɨrɨgɨam, a guizbangɨra.” Egha kamaghɨn mɨgei, “Iesusɨn kɨ akam akurir kamnagh, a Gumazir God Ua Gumazamiziba Iniasa Mɨsevezim, a Krais.” ");
INSERT INTO msy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ezɨ Judan gumazir maba oregha nɨghnɨzir gavgavim akar kabar ikiava Pol ko Sailasɨn nɨghnɨzimɨn gɨn zui. Ezɨ uaghan Godɨn atiatir Grighɨn gumazir avɨrim ko ziaba itir amizir avɨriba sara. ");
INSERT INTO msy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gumazir avɨrim Pol ko Sailasɨn nɨghnɨzimɨn gɨn zuima, Judaba kamaghɨn naviba bar ikufi. Egha puram aruir gumazir kurar maba akumakumigha gumazir bɨzir dafam gami. Egha ghua nguibar ekiamɨn aven arua pamtem atarava araghasi. Me Pol ko Sailas inigh avɨrir torim bagh mangasa, egha me aning buriasa ivemara Jesonɨn dɨpenimɨn aven ghue. ");
INSERT INTO msy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Egha me aningɨn apizir puvatɨgha, Jeson ko Kraisɨn marazi kurɨvegha nguibar ekiamɨn garir gumazir dapaniba bagha me inigha ghu. Egha kamaghɨn dei, “Gumazir kaba osɨmtɨzim nguazir kamɨn nguibaba bar dagh arɨgha iza datɨrɨghɨn kagh oto. ");
INSERT INTO msy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ezɨ Jeson me inigha uan dɨpenim gatɨ. Gumazir kaba bar moghɨra Sisar osirizir arazibar gɨn mangan aghua. Egha kamagh mɨgei, Atrivir ekiar igharazim uaghan iti, an ziam Iesus.” ");
INSERT INTO msy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ezɨ gumazamizir avɨrir uari akuvaziba ko nguibar ekiamɨn garir gumazir dapaniba, me men akar kam baragha dɨgavir kuram gamigha diava arai. ");
INSERT INTO msy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Egha nguibar ekiamɨn garir gumazir dapaniba, me Jeson ko an adaraziv kemezɨ, me sel givese. Ezɨ me me ataghizɨ, me zui. ");
INSERT INTO msy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ezɨ amɨnim pɨrima, Kraisɨn adarazi zuamɨra aning amadazɨ aning Berian nguibamɨn ghu. Aning ghua otivavɨra Judabar dɨpenir God ko mɨgeimɨn aven ghu. ");
INSERT INTO msy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berian Judaba, men araziba ko men nɨghnɨziba bar dera. Me Polɨn mɨgɨrɨgɨaba baraghasa bar ifonge. Egha me Polɨn mɨgɨrɨgɨabar mɨngariba abɨgh bar dagh fofoghasa zurara Godɨn Akamɨn Osiziribar gari. Me kamaghɨn foghasa, Polɨn mɨgɨrɨgɨaba, da guizɨn mɨgɨrɨgɨaba, o? Kamaghɨn, me Tesalonikan itir Judabar arazibagh afira. ");
INSERT INTO msy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ezɨ Judan avɨriba nɨghnɨzir gavgavim Polɨn mɨgɨrɨgɨabar iti. Ezɨ uaghan Grighɨn amizir ziaba itir maba ko Grighɨn gumazir avɨriba sara. ");
INSERT INTO msy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ezɨ Judan gumazir Tesalonikan itiba orazi, Pol Berian ikia Godɨn akam akuri. Ezɨ me uaghan Berian otivigha gumazamizir kabar nɨghnɨzim gasɨghasɨgha men navibagh inifi. ");
INSERT INTO msy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ezɨ Kraisɨn adarazi zuamɨra Pol amadazɨ an ongarir mɨriamɨn ghu. Sailas ko Timoti Berian ikiavɨra iti. ");
INSERT INTO msy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ezɨ Polɨn akua zuir gumaziba, ghua Atensɨn anetɨ. Ezɨ Pol, Sailas ko Timoti zuamɨra a bativasa, egha aning bagha akam isa me ganɨngi. ");
INSERT INTO msy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Egha Pol Atensɨn ikia Sailas ko Timoti bagha mɨzuai. Egha a gari, Atensɨn nguibar ekiamɨn aven marvir guaba bar izɨfa. Ezɨ kamaghɨn Polɨn muriam bar ikufi. ");
INSERT INTO msy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Egha a bizir kam bagha God ko mɨgeir dɨpenibar aven a Judaba ko Grighɨn Godɨn atiatia itir gumaziba sara mɨgei. Egha uaghan bizibagh ivezir danganimɨn zurara gumazir pura iza otivibav gei. ");
INSERT INTO msy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ezɨ Epikurian ko Stoikɨn gumazir fofoziba Pol ko me uari adosi. Marazi kamagh mɨgei, “Onganir mam tizibav gei?” Ezɨ marazi kamagh mɨgei, “A ti aser igharazibar akam akuri.” Pol Iesus ko a ua dɨkavizir bizimɨn akar aghuim akurima, kamaghɨn me mɨgɨrɨgɨar kabar a gami. ");
INSERT INTO msy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","20","Egha me a inigha Atensɨn garir gumazir dapanibar tongɨn ghua me mɨghsɨamɨn Areopagus uari akuvagha iti. Egha me kamaghɨn Pol mɨgei, “Nɨ nɨghnɨzir e fomɨra tong oraghizir puvatɨzibav gei. E dar mɨngarim gɨfoghasa ifonge. Kamaghɨn e foghasa, kar nɨghnɨzir igiar manam, nɨ an gumazibar sure gami. Nɨ e mɨkɨm.” ");
INSERT INTO msy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Atensɨn gumaziba ko Atensɨn azenan itir gumazir iza itiba, zurara pura ikiava nɨghnɨzir igiar otozir kamnaghra a mɨgɨava a barasi.) ");
INSERT INTO msy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ezɨ Pol Areopagusɨn tongɨn tugha kamagh mɨgei, “Ia Atensɨn gumaziba! Kɨ ian gari, ia godɨn mɨn asebar gɨn mangasa bar gavgafi. ");
INSERT INTO msy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kɨ arua bar deravɨra bizir ia ziaba febar ganis, egha kɨ uaghan ofa gamir danganir mamɨn gari, ziar kam an iti: e fozir puvatɨzir godɨn ofa gamir danganim. Ezɨ datɨrɨghɨn kɨ, godɨn ia fozir puvatɨgha egha gɨn zuim, kɨ an akam ia mɨkɨmasa. ");
INSERT INTO msy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Godɨn mam iti, a nguazir kam ko an itir biziba bar dar ingari, anarɨra overiam ko nguazimɨn Ekiam. Egha God gumazir dafaribar ingarir dɨpenibar itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Godɨn kam a uabɨ ikɨrɨmɨrim ko biziba bar gumazamizibagh anɨngi. Egha a bizitamɨn otevezir puvatɨ. Kamaghɨn e uan dafaribar an akurvagh bizitam damighan kogham. ");
INSERT INTO msy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ezɨ God gumazir vamɨra an ingari, egha an ovavir kamɨn a gumaziba bar men ingari. Egha me isa nguazimɨn danganiba bar dagh arɨki. Egha a uabɨ me ikiamin ikɨrɨmɨrimɨn dughiaba arɨki. Egha danganir me itiba a me bagha nguazir mɨtaghniaba arɨki. ");
INSERT INTO msy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God kamaghɨn ifonge, gumazamiziba a buriva, ti a bagh suighsuighɨva a gɨfogham, kamaghɨn a bizir kabagh ami. Guizbangɨra God e vaghvagha en saghon itir puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Anarɨra e gamima, e ikiava, aruava egha ikɨrɨmɨrim isi.’ Ezɨ ian fofozir gumazir mabara kamaghɨn mɨkeme, ‘E Godɨn boribara.’ ");
INSERT INTO msy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Kamaghɨn amizɨ, e guizbangɨra an ovavibar ikiava, egh kamaghɨn nɨghnɨghan kogh suam, God ti gol o silva o dagɨar nedaziba. Egh e kamaghɨn nɨghnɨghan kogh suam, a mati e gumaziba uari uan dafariba ko uan nɨghnɨzibar ingarizir marvir guaba. ");
INSERT INTO msy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Fomɨra gumazamiziba God gɨfozir puvatɨzɨ, egha me fozir puvatɨgha amizir biziba God dagh nɨghnɨzir puvatɨ. Egha datɨrɨghɨn God mɨgɨrɨgɨar gavgavim anɨga ghaze, gumazamizir managh managh nguazir kamɨn itiba, me bar uan navibagh iragh. ");
INSERT INTO msy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","God gumazamizibar arazir kuraba bagh me tuisɨghamin dughiam akɨrigha gɨfa. An arazir aghuimɨn mɨrara, a inabazir gumazim nguazir kamɨn gumazamiziba tuisɨgham. Gumazir kam aremezɨ God a gamizɨma a ua dɨkafi. Bizir kamɨn God e tuisɨghamin ingangarim gumazamiziba bar men akazɨ, me fo, a guizbangɨra otogham.” ");
INSERT INTO msy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Egha me ua dɨkavamin mɨgɨrɨgɨam baregha, marazi a dɨpofi. Ezɨ marazi kamagh mɨgei, “Nɨ dughiatam ua bizir kam mɨkɨmtɨ, e nɨ baraghasa.” ");
INSERT INTO msy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ezɨma Pol me ategha ghu. ");
INSERT INTO msy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ezɨ gumazir maba Polɨn nɨghnɨzimɨn gɨn ghua nɨghnɨzir gavgavim an mɨgɨrɨgɨabar iti. Men tongɨn Dionisius, a Areopagus kaunselɨn aven itir gumazir mam. Ezɨ uaghan amizir mam, an ziam Damaris, ko gumazamizir igharazir maba uakan. ");
INSERT INTO msy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bizir kabar gɨn, Pol Atens ategha Korinɨn nguibamɨn ghu. ");
INSERT INTO msy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Egha kagh Judan gumazir mam bato, an ziam Akwila. An nguibam Provins Pontusɨn aven iti. A uan amuim Prisila ko, aning mong fomɨra kantri Italian ike, ezɨ Sisar Klodius Judabav gɨa ghaze, me Romɨn nguibar ekiam ategh igharagh mangɨ. Kamaghɨn amizɨ, aning Italia ategha Korinɨn ize. Ezɨ Pol aning ganasa zui. ");
INSERT INTO msy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pol uaghan aning mɨrara, selɨn dɨpenibar ingari. Kamaghɨn amizɨ, an aningɨn ganasa ghugha, aning ko ikia egha me ko ingari. ");
INSERT INTO msy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabatɨn dughiabar, Pol zurara Judaba God ko mɨgeir dɨpenibar ghuava me ko uariv gei. A Judaba ko Grighba, men nɨghnɨzibar amutɨma, me nɨghnɨzir gavgavim Iesusɨn ikiasa me gakaghori. ");
INSERT INTO msy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ezɨ Sailas ko Timoti Masedonia ategha izaghirizɨ, Pol dughiaba bar zurara Godɨn akar aghuim akuri. An akar gavgavim kamaghɨn Judaba deravɨra me geghari, Iesus a Krais, Gumazir God Uam E Iniasa Mɨsevezim. ");
INSERT INTO msy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ezɨ Judaba Polɨn akam baraghan aghuaghava, mɨgɨrɨgɨar kuraba a ganɨdi. Ezɨ a kamaghɨn amighava, uan korotiamɨn mɨneziba pɨzigha, egha kamaghɨn me mɨgei, “Kamaghɨn ia Godɨn saghon ikɨ oveghtɨ, mar ian osɨmtɨzimra. Ezɨ kɨ uabɨ osɨmtɨziba puvatɨ. Datɨrɨghɨn kɨ Godɨn akar aghuim Kantrin Igharazibar Gumaziba me mɨkɨnam.” ");
INSERT INTO msy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ezɨ Pol God ko mɨgeir dɨpenim ategha Titius Jastusɨn dɨpenimɨn ghu. Gumazir kam zurara Godɨn ziam fe. An dɨpenim a Judaba God ko mɨgeir dɨpenimɨn boroghɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus, Judabar God ko mɨgeir dɨpenibar garir gumazir dapanir ekiam. Ezɨ a uan adarasi ko me nɨghnɨzir gavgavim Ekiamɨn iti. Ezɨ Korinɨn gumazamizir avɨrim Polɨn akam baregha egha nɨghnɨzir gavgavim Iesusɨn ikia egha rue. ");
INSERT INTO msy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ezɨ dɨmagarir mamɨn Ekiam irebamɨn mɨn bizimɨn Polɨn mɨkeme, “Nɨ atiatingan markɨ; nɨ mɨkɨmvɨra ikɨ; nɨmɨra ikian markɨ. ");
INSERT INTO msy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Kɨ nɨ ko iti, nan gumazamizir avɨriba nguibar ekiar kamɨn iti. Kamaghɨn tav pazɨ nɨ damighan koghan, egh nɨ mɨsueghan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ezɨ Pol azenir vamɨra koma akuamɨn ikiava, Godɨn akar aghuim men sure gami. ");
INSERT INTO msy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galio, Akaian Provinsɨn gavmanɨn gumazir dapanimɨn itima, Judan gumaziba bar dɨkavigha Polɨn apanimɨn ikiava a isa kot gatɨ. ");
INSERT INTO msy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Egha me ghaze, “Gumazir kam, a gumazamizibav gɨa ghaze, ‘Ia Moses Osirizir Araziba riaghriaghɨva, arazir igharazimɨn Godɨn ziam fɨ.’” ");
INSERT INTO msy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol bar men akam ikarvaghasava amima, ezɨ Galio Judabav gei, “Ia Judaba, gumazir kam Rom osirizir araziba abigham, o an arazir kuratam damightɨma, eghtɨma kɨ ian akam baregham. ");
INSERT INTO msy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ezɨ ia mɨgɨrɨgɨar arazaraziba ko ziaba ko ian araziba, dagh nɨghnɨgha na bagha izi. Markiam. Ia uari dar kɨrmɨgh. Kɨ bizir kabar kotiaba bareghan kogham.” ");
INSERT INTO msy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kamaghɨn a me amadazɨma me kot ategha azenan ize. ");
INSERT INTO msy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ezɨ Korinɨn gumaziba, maghɨra Sostenesɨn suira, a Judabar dɨpenir God ko mɨgeimɨn garir gumazir dapanim, egha kotɨn danganim boroghɨra a mɨsosi. Ezɨ Galio bizir me amizir kam gunuira. ");
INSERT INTO msy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol dughiar mabar Korinɨn ikeghava, egha Kraisɨn adarasi ategha kurim ghuavanabogha Sirian Distrighɨn ghu. Prisila koma Akwila a ko zui. Dughiar a tɨghar kurimɨn mangamim, a Senkrian ikia God ko akar dɨkɨrɨzir mam gami. Kamaghɨn a uan dapanir arɨzim gise. ");
INSERT INTO msy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ezɨ me Efesus otivigha, Pol Prisila koma Akwila kagh aning ataki. Egha a uabɨ Judabar dɨpenir God ko mɨgeimɨn ghua me ko uariv gei. ");
INSERT INTO msy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ezɨ me dughiar tabar uarir gan ikiasava a mɨgeima, a ghaze, Puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ezɨ a me ataghragha, egha an akar dɨkɨrɨzim gamua me mɨgei, “God ifueghtɨma, kɨ ua ia bagh izam.” Egha kurim inigha Efesus ategha ghu. ");
INSERT INTO msy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ezɨ a Sisarian otogha, egha Jerusalemɨn itir Kraisɨn adarazi getiasa ghuavanabo. Egha gɨn Antioghɨn nguibamɨn ghuaghirɨ. ");
INSERT INTO msy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Egha Pol dughiar mabar Antioghɨn ikegha, egha a Distrigh Galesia ko Frigian itir nguibaba bar dagh aruava, men nɨghnɨzir gavgavir Iesusɨn itiba gavgavim me ganɨdi. ");
INSERT INTO msy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Judan gumazir mam, an ziam Apolos, an Aleksandrian gumazim. A izava Efesusɨn nguibamɨn iti. A bar deravɨra mɨgɨava egha a Godɨn Akɨnafarimɨn Osiziriba bar dagh fo. ");
INSERT INTO msy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Me Ekiamɨn tuavimɨn a geghani, ezɨ a gumazamizibar sure damuasa an navim bar a dɨkafi. A bar deravɨra Iesus amizir bizibar me mɨgei. Egha a Jonɨn rurimra fo. ");
INSERT INTO msy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Egha Apolos Judabar God ko mɨgeir dɨpenim ghugha, egha atiati puvatɨgha Godɨn akam akuri. Ezɨ Prisila ko Akwila a baregha a inigha uan dɨpenimɨn ghugha Godɨn tuavim a geghanizɨ, a deravɨra Godɨn tuavim gɨfos. ");
INSERT INTO msy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ezɨ Apolos Akaian mangasava amima, Efesusɨn itir Kraisɨn adarazi, gavgavim a ganɨdi, egha a iniasava Akaian suren gumaziba bagha akɨnafarim osiri. Dughiar kam Apolos Akaian otogha, egha nɨghnɨzir gavgavim Godɨn itir darasi akurvazir ekiam me gami. God men apangkuvifi, kamaghɨn amizɨ me nɨghnɨzir gavgavim Godɨn iti. ");
INSERT INTO msy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos bar gavgavigha gumazamizibar damazibar akam akuri, egha men akaba ikarvagha, egha Judabar akar kurar me mɨgeiba dɨkabɨri. A Godɨn Akɨnafarimɨn itir akam akuri, eghtɨ me fogh suam, Iesus a God Uam E Iniasa Mɨsevezir Gumazim, Krais. ");
INSERT INTO msy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Dughiar kam Apolos Korinɨn ikiavɨra itima, Pol mɨghsɨabar itir nguibabagh arua ghua iza Efesusɨn oto. Egha a kagh suren gumazir maba bato. ");
INSERT INTO msy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Egha men azara, “Ia faraghavɨra nɨghnɨzir gavgavim Iesusɨn itima, Godɨn Duam ia gizɨvazɨ, o puvatɨ?” Ezɨ me ghaze, “Puvatɨ, e uaghan tong oraghizir puvatɨ, Godɨn Duam iti.” ");
INSERT INTO msy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ezɨ Pol men azara, “Ia rurir manamra ini?” Ezɨ me ikara ghaze, “Jonɨn rurim.” ");
INSERT INTO msy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ezɨ Pol ghaze, “Jonɨn rurim a navim girazir rurim. Jon gumazamizibav gɨa ghaze, ia nɨghnɨzir gavgavim nan gɨn izamin gumazimɨn ikɨ, a Iesus.” ");
INSERT INTO msy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ezɨ me kamaghɨn oraghizɨ, Pol Ekiam Iesusɨn ziamɨn me rue. ");
INSERT INTO msy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ezɨ Pol uan agharimning me gisɨn atɨzɨ, Godɨn Duam me bagha izegha me avara. Ezɨ me nguibar igharazibar akabav gei. Egha Godɨn akam inigha izir gumazibar mɨn Godɨn akam mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Me bar moghɨra men dɨbobonim 12 pla. ");
INSERT INTO msy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ezɨ Pol iakinir pumuning ko mɨkezimɨn, a God ko mɨgeir dɨpenimɨn aven, gumazamiziba akar gavgavibar me mɨgɨa atiatir puvatɨ. A God Bizibagh Ativir Arazimɨn mɨgɨrɨgɨamɨn gun me mɨgɨa men nɨghnɨziba iraghasa me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ezɨ marazir naviba gavgavizɨ, me nɨghnɨzir gavgavim Polɨn akabar ikian aghuagha, egha gumazibar damazibar azenara mɨgɨrɨgɨar kurabar Godɨn Tuavim gami. Ezɨ Pol me ategha nɨghnɨzir gavgavim Iesusɨn itir darazi inigha ghu. Egha dughiaba zurara Tiranusɨn suren dɨpenimɨn bizibar me mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol azenir pumuningɨn aven arazir kam gamima, kamaghɨn Judaba ko Grighɨn Esian Provinsɨn itiba, me bar Ekiamɨn akam baraki. ");
INSERT INTO msy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Egha God mirakel bar gavgavir igiaba Polɨn dafariba dagh ami. ");
INSERT INTO msy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ezɨ uaghan inir avɨzir doriba adiziba ko, inir avɨzir maba, me da Polɨn mɨkarzimɨn poghezɨma, me da isa ghuava arɨmariabagh arɨzi da ghuamazima, duar kuraba me ataghrasi. ");
INSERT INTO msy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ezɨ Judan gumazir maba nguibabagh arua duar kuraba batosi. Me Ekiam Iesusɨn ziamɨn duar kurar gumazibar aven itiba batoghasa. Me kamaghɨn mɨgei, “Iesusɨn Pol akam akurimɨn ziamɨn, kɨ pamtem nɨ mɨgei, ‘Nɨ azenan izɨ.’” ");
INSERT INTO msy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ezɨ Skeva, a Judan ofa gamir gumazir dapanir mam. An otarir 7 pla, arazir kam gami. ");
INSERT INTO msy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ezɨ dughiar mam, duar kurar mam kamaghɨn me mɨgei, “Iesus, kɨ a gɨfo, egha Pol kɨ a gɨfo, ezɨ ia taia?” ");
INSERT INTO msy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ezɨ gumazir duar kuram apazazir kam, uabɨ fegha me mɨkɨnigha puv me mɨsuagharɨki. A mɨzazir kuram me gasima me ghuzibagh rua bibiabara dɨpenim ategha arava azenan ghue. ");
INSERT INTO msy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ezɨ Judaba ko Grighɨn gumazir Efesusɨn itiba bizir kam baregha bar atiatingi. Ezɨ Ekiam Iesus an ziam, gumaziba bar a pɨrafa. ");
INSERT INTO msy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Faragha nɨghnɨzir gavgavim Iesusɨn itiba datɨrɨghɨn iza gumazibar damazimɨn uan arazir kurabar gun mɨgei. ");
INSERT INTO msy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ezɨ gumazamizir avɨrir imeziba ko mirakel kurabagh amiba, me uan akɨnafarir mirakel kuraba itiba a da inigha iza, gumazamizibar damazimɨn da tue. Me akɨnafarir kabar ivezim dɨborima, 50,000ɨn silvan dagɨabar tu. ");
INSERT INTO msy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Kamaghɨn amizɨ, Ekiamɨn mɨgɨrɨgɨam nguibaba bar dar zui. Ezɨ gumazamizir avɨrim nɨghnɨzir gavgavim Ekiamɨn mɨgɨrɨgɨamɨn itima a pamtem men navibar aven ingari. ");
INSERT INTO msy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Bizir kaba otivigha gɨvazɨ, Pol Godɨn Duamɨn gɨn Masedonian Provins ko Akaian Provins moghɨn mangɨ, Jerusalemɨn otivasa. Egha ghaze, “Kɨ nguibar kamɨn ikeghɨva, gɨn uaghan Romɨn nguibar ekiamɨn mangam.” ");
INSERT INTO msy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Egha an akurvazir gumazimning, Timoti ko Erastus, an aning isa Masedonian aning amada. Egha a uabɨ mong Esian Provinsɨn ike. ");
INSERT INTO msy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Dughiar kamra gumazir maba Ekiamɨn Tuavimɨn adarir mɨgɨrɨgɨar dafam gami. ");
INSERT INTO msy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ezɨ gumazir mam, an ziam Demitrius. A silvan bizibar ingarir gumazim. A dagɨaba iniasa, aser amizim Artemisɨn dɨpenimɨn mɨn, a dɨpenir dozibar ingarigha, silvan dagh ami. Gumazir avɨriba Demitrius ko ingara dagɨar avɨriba isi. ");
INSERT INTO msy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Egha a ko an ingangarir gumaziba ko men ingangarimɨn mɨn amir ingangarir igharazibagh amir gumaziba, men dia. Egha kamaghɨn mɨgei, “Maia, ia fo. E dagɨar ingangarir kam gamua dagɨar dafam isi. ");
INSERT INTO msy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ia garava orasi, gumazir kam Pol, gumazamizir avɨrim an akaba bangɨn ira dar gɨn zui. Efesusɨn kaghɨra puvatɨ, Esian Provins bar. A gumazibar nɨghnɨzibagh ami, da tuavir igharazibar zui. A kamaghɨn mɨgɨa ghaze, gumaziba amir marvir guaba, da guizbangɨra godba puvatɨ. ");
INSERT INTO msy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Polɨn akar kam en dagɨar ingangarimɨn ziar aghuim gasɨghasigham. Bizir kamra puvatɨ, uaghan gumazamizibar nɨghnɨzimɨn, Artemisɨn dɨpenim pura bizir kɨnim gavagham. Eghtɨ Artemis uabɨ, me Esian Provins ko nguazir kam bar moghɨra ua godɨn mɨn an ganan kogham. An marvir guam pura bizir kɨnim gavagham!” ");
INSERT INTO msy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ezɨ me oregha atara maghɨra pamtem mɨgɨa ghaze, “Aser amizim Artemis, an Efesusɨn bar Ekiam!” ");
INSERT INTO msy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ezɨ mong gɨn nguibar kamɨn itir gumazamiziba bar nɨgɨnir dafam gami. Egha me bar, Gaius ko Aristarkusɨn suiragha aning a mɨkɨrɨghava, voroghɨra uari akuvir danganir ekiamɨn zuamɨra ivemara ghue. Aning, Masedonian gumazir Pol koma aruimning. ");
INSERT INTO msy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol uabɨ gumazamizir okuruamɨn tongɨn mangasa nɨghnɨsi. Ezɨ Kraisɨn adarazi an anogorosi. ");
INSERT INTO msy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ezɨ uaghan Efesusɨn gavmanɨn gumazir maba, me Polɨn namakaba, me a bagha akam amaga pamtem a gakaghora ghaze, a danganir ekiar gumazamiziba uari akuvimɨn mangan markɨ. ");
INSERT INTO msy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ezɨ uari akuvazir gumazamiziba me okam nɨghnɨsi, marazi bizir mam mɨgɨa dei, ezɨ marazi bizir igharazim mɨgɨa dei. Gumazir avɨrim fozir puvatɨ, me tizim bagha iza uari akufa. ");
INSERT INTO msy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ezɨ Judaba, me gumazir mam Aleksander tɨvazɨ, a ghua faraghavɨra tu. Ezɨ marazi ghaze, Aleksander ti osɨmtɨzi