﻿USE sofia;
DROP TABLE IF EXISTS sofia.msy2020_vpl;
CREATE TABLE msy2020_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES msy2020_vpl WRITE;
INSERT INTO msy2020_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bar faraghavɨra God overiam ko nguazimɨn ingarigha aningɨn itir biziba bar dagh amizɨma, da otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Faragha zuir dughiar kam, nguazim e datɨrɨghɨn iti moghɨn garir pu. Puvatɨ. A bar pura ikia egha an ganganim ighara. Mɨtater dafam ongarir ekiaba avarazɨma, Godɨn Duam pura dɨpam gisɨn arui. ");
INSERT INTO msy2020_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ezɨ God kamaghɨn mɨgei, “Angazangarim otogh.” Ezɨ angazangarim oto. ");
INSERT INTO msy2020_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ezɨ God angazangarimɨn gari, a derazɨma, a bar akonge. Egha mɨtatem ko angazangarim tuira. ");
INSERT INTO msy2020_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Egha angazangarim ziar kam, “Aruem,” a gatɨ. Egha mɨtatem ziar kam, “Dɨmagarim,” a gatɨ. Ezɨ amɨnim pɨrigha ua tirazɨma, kar dughiar bar faraghavɨra zuim. ");
INSERT INTO msy2020_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Egha gɨn God kamaghɨn mɨgei, “Avavetam otogh dɨpam avɨnightɨ, dɨpam akuar pumuningɨn ikɨ.” Ezɨ avaver kam oto. God avaver kam gamizɨma, a dɨpar pɨn itim ko apengan itim abɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Egha God avaver kamɨn ziam, “Overiam,” a gatɨ. Ezɨ amɨnim pɨrigha ua tirazɨma, kar dughiar namba 2. ");
INSERT INTO msy2020_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Egha gɨn God kamaghɨn mɨgei, “Dɨpar overiamɨn apengan itim sɨvagh mangɨ danganir vamɨran uabɨ akuvaghtɨ, nguazir mɨsɨngizim otogh.” Ezɨ nguazir mɨsɨngizim oto. ");
INSERT INTO msy2020_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ezɨ God nguazir mɨsɨngizir kam ziam, “Nguazim,” a gatɨ. Egha dɨpar danganir igharazimɨn uari akuvaziba, a ziam, “Ongariba,” dagh atɨ. Egha God bizir kabar gari da bar derazɨma, a bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Egha gɨn God kamaghɨn mɨgei, “Nguazim, temer guar avɨriba ko nguazimɨn aver beniba ko dagheba a gisɨn aghung.” Ezɨ bizir kaba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ezɨ temer ber guar avɨriba ko benir nguazimɨn aveba ko dagher apiba bar nguazimɨn vaghvagha aghui moghɨn aghua, egha da be moghɨn be. Ezɨ God bizir kabar garima da derazɨma, a bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ezɨ amɨnim pɨrigha ua tirazɨma, kar dughiar namba 3. ");
INSERT INTO msy2020_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Egha gɨn God kamaghɨn mɨgei, “Angazangariba overiamɨn otifigh, aruem ko dɨmagarim abɨkigh. Eghtɨ dughiaba ko azeniba ikɨtɨ, me angazangarir kabar ganɨva dughiabagh fogham. ");
INSERT INTO msy2020_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Eghtɨ angazangarir kaba otivigh angazangarim nguazim danɨngam.” Ezɨ angazangariba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Egha God angazangarir ekiar pumuning gamizɨma aning oto. Angazangarir ekiam, an aruem, egha isiragha gara aruemɨn angazangarim anɨdi. Ezɨ dozim, a iakɨnim, a isiragha dɨmagarimɨn angazangarim anɨdi. Egha God mɨkovezibagh amizɨ da otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Egha God nguazim angazangarim a danɨngasa, angazangarir kaba overiamɨn da arɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Egha aruem isiragh ganamin dughiam atɨgha, uaghan dɨmagarim otivamin dughiam atɨ, eghtɨ aruem ko dɨmagarim deravɨra uaning abɨgham. Ezɨ God bizir kabar gari da derazɨma, a bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ezɨ amɨnim pɨrigha ua tirazɨma, kar dughiar namba 4. ");
INSERT INTO msy2020_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Egha gɨn God kamaghɨn mɨgei, “Ongarimɨn aven, bizir angamɨra itir avɨriba an ikɨva a gizɨvagham. Eghtɨ kuaraziba otivigh overiamɨn pɨn tintinibar mɨghɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ezɨ God ongarimɨn osirir dafaba ko kuruzir dafabar ingarizɨ da otifi, ongarimɨn itir bizir guar avɨriba, ko kuarazir guar avɨriba uaghan, vaghvagha gari moghɨra gari. Ezɨ God bizir kabar gari da derazɨma, a bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Egha bizir kaba deraghasa, God mɨgɨrɨgɨar aghuir kam dagh ami, “Ia ongarimɨn itir bizir guar avɨriba, ia avɨrasemegh, ongarim bar a gizɨfagh. Eghtɨ ia kuaraziba, ia nguazimɨn bar avɨrasemegh.” ");
INSERT INTO msy2020_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ezɨ amɨnim pɨrigha ua tirazɨma kar dughiar namba 5. ");
INSERT INTO msy2020_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Egha gɨn God kamaghɨn mɨgei, “Nguazim bizir angamɨra itir guar avɨribar amutɨ da vaghvagha gari moghɨram an otiv. Egh nguibamɨn itir asɨziba ko, ruarimɨn itir asɨzir ekiaba ko doziba sara damutɨ da otiv.” Ezɨ asɨziba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God nguibamɨn asɨzir guar avɨriba ko ruarimɨn asɨzir ekiaba ko dozibar ingarizɨ, da vaghvagha gari moghɨra otifi. Ezɨ God bizir kabar gari da derazɨma, a bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Egha God kamaghɨn mɨgɨa ghaze, “Datɨrɨghɨn e gumaziba ko amizibar ingarightɨ me en mɨrara ganam. Egh e me atɨghtɨ, me en mɨn ikɨ, ongarimɨn itir osiriba ko, overiamɨn itir kuaraziba ko, asɨzir guar avɨriba ko nguazimɨn itir biziba bar, me dar gan dagh ativagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Egha God gumazamizibar ingarizɨ, me Godɨn mɨrara gari. God me gamizɨma, me an nedazimɨn mɨn oto. A me gamizɨma, men marazi gumazibar mɨn otivizɨ, marazi amizibar mɨn otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ezɨ God me deraghasa, mɨgɨrɨgɨar aghuim me gamua kamaghɨn mɨgei, “Ia avɨrasemegh mangɨ nguazir oteviba bar dar apiagh egh bizir nguazimɨn itiba bar dar gan. Kɨ osiriba ko, kuaraziba ko, nguazimɨn itir asɨzir guar avɨriba ian dafarim darɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Egha God mɨgɨa ghaze, “Kɨ nguazir kamɨn itir dagheba batamin temeba, ko nguazimɨn aven otivir dagher avɨriba, kɨ bar da ia ganɨdi. Eghtɨ ia bizir kabar dagheba iniam. ");
INSERT INTO msy2020_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Egha ter afarir gariba kɨ daghebar mɨn, da isa angamɨra itir asɨziba bar, dagh anɨdi, eghtɨ da dar amam. Kar, nguibamɨn itir asɨziba ko ruarimɨn itir asɨzir ekiaba ko doziba ko, overiamɨn itir kuaraziba bar.” Ezɨ bizir kaba God mɨkemezɨ moghɨrama otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ezɨ God bizir kaba bar dar gari da bar derazɨma, a bar akonge. Ezɨ amɨnim pɨrigha ua tirazɨma, kar dughiar namba 6. ");
INSERT INTO msy2020_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ezɨ arazir kamra, God overiam ko nguazim ko aningɨn itir bizir avɨribar ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ezɨ aruer namba 7ɨn, God garima an ingangariba bar gɨvazɨ, a dughiar kamɨn avughse. ");
INSERT INTO msy2020_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ezɨ God dughiar namba 7 gɨnɨghnɨgha deragh a damuasa ghaze, kar an dughiamra. Egha akar gavgavim arɨgha dughiar namba 7ɨn anogorogha ghaze, a biziba bar dar ingari, egha dughiar kamɨn avughse, ezɨ kamaghɨn wighɨn vamɨran vaghvagha dar namba 7ɨn dughiaba, kar an dughiar ekiaba. ");
INSERT INTO msy2020_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ezɨ arazir God overiam ko nguazim ko biziba bar dagh amizɨ da otivizir eghaghanir kam, a kamaghɨra ghu. Dughiar kam, Ikiavɨra Itir Godɨn Gavgavim overiam ko nguazim gamizɨma aning otozɨma, ");
INSERT INTO msy2020_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","an amozim amadazɨma a izir puvatɨ. Ezɨ nguazimɨn azenimɨn ingaramin gumazamiziba puvatɨ. Kamaghɨn, graziba ko temeba tɨghar nguazimɨn otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ezɨ guizbangɨra amozim izir puvatɨzɨ, dɨpam nguazimɨn averiamɨn ikiava otiva iza nguazim bar a gizɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Egha gɨn Ikiavɨra Itir Godɨn Gavgavim nguazim inigha gumazir mamɨn ingari. Egha uan ikɨrɨmɨrir angamɨra itim anɨdir amɨnim isa, gumazimɨn atinimɨn a giverezɨma, an an aven ghu, ezɨ gumazim angamɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Egha Ikiavɨra Itir Godɨn Gavgavim azenir mam aruem anadi naghɨn an ingarizɨ a Idenɨn nguazimɨn iti. Egha azenir kamɨn gumazir kam atɨzɨma, a iti. ");
INSERT INTO msy2020_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ezɨ Ikiavɨra Itir Godɨn Gavgavim temer guar avɨribagha amizɨ da nguazimɨn otivigha, dar ovɨziba daghemɨn bar dera. Temer kabar ganganim bar moghɨra dera. Azenir kamɨn torimra temer mam iti, a ikɨrɨmɨrir zurara itim anɨdir temem. Ezɨ temer igharazir mam uaghan iti, kar temer nɨghnɨzir aghuim anɨngtɨ gumazamiziba arazir aghuim ko arazir kuram gɨfoghamim. ");
INSERT INTO msy2020_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ezɨ faner mam dɨpam Idenɨn Azenim danɨngasava oto. Dɨpar kam 4plan aguabar bɨaghire. ");
INSERT INTO msy2020_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Ezɨ faner faragha zuimɨn ziam Pison, a kantri Havilan aven dɨpɨragharui. Kantri Havila golɨn bar aghuim iti. Egha temer borer mughuriar aghuim zuir mam iti. Egha a dagɨar aghuir mam itima, an ivezim bar pɨn iti. Me kamagh a dɨbori, kanilian. ");
INSERT INTO msy2020_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ezɨ faner namba 2ɨn ziam Gihon, a kantri Kusɨn ghua an aven dɨpɨragharui. ");
INSERT INTO msy2020_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ezɨ namba 3ɨn fanemɨn ziam Taigris, an aruem anadi naghɨn kantri Asirian aven iti. Ezɨ namba 4ɨn fanemɨn ziam a Yufretis. ");
INSERT INTO msy2020_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ezɨ Ikiavɨra Itir Godɨn Gavgavim kamaghɨn ifonge, gumazir a ingarizir kam Idenɨn Azenimɨn ikɨ an ingar an ganam. Kamaghɨn, ana isa azenir kamɨn anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Egha Ikiavɨra Itir Godɨn Gavgavim kamaghɨn gumazim mɨgɨa ghaze, “Nɨ azenir kamɨn itir temeba bar dar ovɨzibar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Egh nɨ, temer fofozir arazir aghuim ko arazir kuram anɨdim, an ovɨzim aman bar markɨ. Nɨ anemegh, zuamɨram ovegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Egha Ikiavɨra Itir Godɨn Gavgavim mɨgɨa ghaze, “Gumazir kam uabɨra iti, kamaghɨn derazir puvatɨ. Kɨ a bagh roroatamɨn ingarightɨ an an mɨn ikɨ an akurvagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Egha Ikiavɨra Itir Godɨn Gavgavim nguazim inigha, ruarimɨn itir asɨziba ko overiamɨn itir kuaraziba bar dar ingari. Egha kamaghɨn foghasa, gumazir kam ziar manaba asɨziba ko kuaraziba vaghvagh dar arɨgham. Kamaghɨn, an asɨziba ko kuaraziba gumazim bagha da inigha zui. Ezɨ gumazim ziaba isa asɨziba ko kuaraziba vaghvagha me garɨghizɨ, dar ziaba kamaghɨra iti. Gumazim asɨzir nguibamɨn itiba ko, ruarimɨn itiba ko, kuarazir overiamɨn itiba, ziaba vaghvagha dagh arɨsi. Ezɨ guizbangɨra asɨzir kabar tongɨn, tam Adamɨn akuraghamin roroatam bar itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kamaghɨn Ikiavɨra Itir Godɨn Gavgavim gumazim gamizɨ, an akuava ongani. Egha gumazim akuavɨra itima, a gumazimɨn ivir agharir mam inigha an danganimɨn uam an inim a dukua. ");
INSERT INTO msy2020_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Egha Ikiavɨra Itir Godɨn Gavgavim agharir a gumazimɨn inizimɨn amizir mamɨn ingari, egha gɨn amizim inigha gumazim bagha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ezɨ gumazim amizimɨn ganigha mɨgɨa ghaze: “Ame! Datɨrɨghɨn, kar guizbangɨra nan roroam. An agharim, kar nan agharim, ezɨ an tuzim, kar nan tuzim. Ikiavɨra Itir Godɨn Gavgavim nan agharimɨn an ingarizɨ, kɨ datɨrɨghɨn kamagh a dɨponam, ‘Amizim.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kamaghɨn, gumazim uan ameboghfeziaba ategh mangɨ, uan amuim ko aning uaningɨn porogham. Egh aning inivafɨzir vamɨram otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ezɨ gumazim uan amuim ko, aning bibiamra ikia, egha aghumsɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ikiavɨra Itir Godɨn Gavgavim asɨziba bar adar ingari, ezɨ kuruzimra, an akar asuiba ko akar ifavaribagh amuava, arazir kamɨn asɨzir igharaziba bar dagh afira. Egha kuruzim kamaghɨn amizimɨn azara, “God ti azenir kamɨn itir iter ovɨziba bar dar aman guan anogoroke?” ");
INSERT INTO msy2020_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ezɨ amizim kamaghɨn an akam ikaragha ghaze, “Ga azenir kamɨn itir ter ovɨzibar amam. ");
INSERT INTO msy2020_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ezɨ iter bar vamɨran azenimɨn torimɨn tughav itimra, Ikiavɨra Itir Godɨn Gavgavim, an ovɨzitam aman bar gan anogoroke. A kamaghɨn ga mɨgɨa ghaze, ‘Gua bar iter kamɨn ovɨzitam aman markɨ, egh uaghan an suighan markɨ. Gua kamagh damigh ovegham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ezɨ kuruzim kamaghɨn amizim mɨgei, “Puvatɨ. Gua oveghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Gua iter kamɨn ovɨzim amegh, guan damaziba kuighirɨghtɨma gua arazir aghuiba ko arazir kurabagh foghfogh, egh Godɨn mɨraram otogham. God bizir kam gɨfogha iter kamɨn ovɨzim aman guan anogoroke.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ezɨ amizim iter kamɨn ovɨzimɨn gari, an ganganim bar deragha damamin dagher aghuiba an iti. Ezɨ amizim kamaghɨn nɨghnɨsi, “Kamaghɨn deragham, kɨ iter kamɨn ovɨzim amegh egh fofozir aghuir kaba iniam.” Kamaghɨn, amizim iter kamɨn ovɨzir mam inigha aneme. Dughiar kam an pam a ko iti, ezɨ amizim temer ovɨzir maba isa uan pam ganɨngizɨ, an pam uaghan da ame. ");
INSERT INTO msy2020_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ezɨ aningɨn damazimning kuaghirezɨma aning uaningɨn gari, aning bibiamra iti. Kamaghɨn aning fighɨn iter afariba isa inibar mɨn da isamigha, uan mɨkarzimning avara. ");
INSERT INTO msy2020_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ezɨ guaratɨzir orangtɨzimɨn, aning orazima Ikiavɨra Itir Godɨn Gavgavim, an azenir kamɨn arua izi, ezɨ aning temebar tongɨn modo. ");
INSERT INTO msy2020_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ezɨ Ikiavɨra Itir Godɨn Gavgavim gumazimɨn dɨa ghaze, “Nɨ managh iti?” ");
INSERT INTO msy2020_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ezɨ gumazim an akam ikaragha kamaghɨn mɨgei, “Kɨ bibiamra iti. Kɨ nɨ barazi, nɨ azenir kamɨn arua izi, kamaghɨn kɨ atiatigha modo.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ezɨ God an azara, “Nɨ manmaghɨra fo, nɨ bibiamra iti? Tina nɨ mɨkeme? Nɨ, iter ovɨzir kɨ gua daman anogoroghezir kam, nɨ ti an ovɨzitam anemeghama?” ");
INSERT INTO msy2020_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ezɨ gumazim a ikaragha kamaghɨn mɨgei, “Amizir nan roroamɨn mɨn ikiamin nɨ na ganɨngizim, anarɨra iter kamɨn ovɨzir mam na ganɨngizɨ, kɨ aneme.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ezɨ Ikiavɨra Itir Godɨn Gavgavim kamagh amizimɨn azara, “Nɨ manmaghsuavɨra bizir kam gami?” Ezɨ amizim an akam ikaragha ghaze, “Kuruzim na gifarazɨ, kɨ iter kamɨn ovɨzir kam ame.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ezɨ Ikiavɨra Itir Godɨn Gavgavim kamaghɨn kuruzim mɨgei, “Nɨ arazir kurar kam a gamizɨ, kɨ datɨrɨghɨn nɨ abɨnamin akar gavgavim iti. Nɨ osɨmtɨzir bar ekiam ikiam. Osɨmtɨzir nɨ iniamim, an osɨmtɨzir asɨzir igharaziba iniamim gafiragham. Egh nɨ zurara uan navimɨn nguazimɨn davarva, nguazimɨn mɨnezibar amɨ ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Egh kɨ nɨ damightɨ nɨ amizimɨn apanimɨn ikɨtɨ, amizim nɨ apanimɨn ikiam. Eghtɨ kɨ nɨn ovavir boribar amightɨ, me amizimɨn ovavir boribar apanimɨn ikiam. Egh an ovavir borir mam nɨn dapanim dɨkaragham, eghtɨ nɨ an dagarir gɨnkevim giviam.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ezɨ God kamaghɨn amizim mɨgei, “Nɨ navim asangamin dughiamɨn, kɨ osɨmtɨzim nɨ danɨngam. Egh nɨ borim batamin dughiam, nɨ mɨzazir dafamra iniam. Egh nɨ uan pam gifueghɨvɨra ikɨtɨ, a nɨ gativagh nɨn ganvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Egha God kamaghɨn Adam mɨgei, “Nɨ uan amuimɨn akam baregha, temer ovɨzir nɨ daman kɨ nɨn anogoroghezim ame. Kamaghɨn nɨ amizir arazir kam bangɨn, kɨ datɨrɨghɨn nguazim gasɨghasightɨ, dagheba deragh an otivan kogham. Egh nɨ zurara nguazir kamɨn ikiamin dughiamɨn, nɨ dagheba deragh otivsɨ, ingangarir dafabara nguazimɨn dar amuam. ");
INSERT INTO msy2020_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","19","Eghtɨ benir ataghatariba ko benir kuraba otiv, nɨn azenimɨn aghung anevaragham. Egh nɨ dagheba inisɨ, ingangarir ekiabar amutɨ, doriba nɨn agham. Egh nɨ zurara kamaghɨra puvɨra ingar mangɨ, ovegh uamategh nguazimɨn mangam. Guizbangɨra, kɨ nguazimɨn nɨn ingari, ezɨ nɨ uamategh nguazimɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ezɨ gumazim kamaghɨn nɨghnɨsi, an amuim, gumazamiziba bar men ovavir amizimɨn otogham. Kamaghɨn, a ziam, “Iv,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ezɨ gɨn Ikiavɨra Itir Godɨn Gavgavim asɨzimɨn inim inigha korotiamningɨn ingari, egha Adam uan amuim ko aning ganɨngizɨ, aning da aghui. ");
INSERT INTO msy2020_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Egha gɨn Ikiavɨra Itir Godɨn Gavgavim ghaze, “Gumazim arazir aghuim ko arazir kuramɨn fofozim ikia, en mɨraram oto. Egh e aneteghtɨ a temer ikɨrɨmɨrir zurara itim anɨdim boroghɨn mangan kogham. E fo, a temer kamɨn ovɨzitam ramegh ikɨrɨmɨrir zurara itir kam ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kamaghɨn Ikiavɨra Itir Godɨn Gavgavim, gumazim Idenɨn Azenimɨn a batoke. Egha God nguazir an ingarizimra anemadazɨma, an azenimɨn ingarasa zui. ");
INSERT INTO msy2020_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Egha God gumazim ko amizim batuegha, enselɨn bar gavgaviba amɨsefe, eghtɨ me Idenɨn Azenimɨn aruem anadi naghɨn tuivigh an ganam. Egha uaghan mɨdorozir sabam atɨ. Sabar kam, angazangarim ikia avir mɨzariar gavgavimɨn mɨn pamtem isia, danganibar bar uabɨ gɨghavkɨra gari. Dughiabar zurara enselɨn kaba ko mɨdorozir sabar kam azenir kamɨn gara iti, eghtɨ gumazitam temer ikɨrɨmɨrir angamɨra itim anɨdir kamɨn boroghɨn mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ezɨ Adam uan amuim Iv ko akuizɨma, amizim navim asangi. Egha amizim otarir mam bategha ghaze, “Ikiavɨra Itir God nan akurazɨma, kɨ otarir kam ini.” Kamaghɨn an otarir kam ziam, “Kein,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Egha gɨn a Keinɨn dozim Abel bate. Ezɨ aning ekevegha Abel sipsipbar garir gumazim, ezɨ Kein azenibar ingarir gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Egha gɨn Kein uan azenimɨn dagheba asigha, maba inigha Ikiavɨra Itir Godɨn ofa damuasa zui. ");
INSERT INTO msy2020_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ezɨ Abel sipsipɨn nguzir mɨkarzim sara itir aghuir mam ini. Sipsipɨn nguzir kam, kar amebam faraghavɨrama otezir sipsipɨn nguzim. Ezɨ Abel a mɨsuegha Ikiavɨra Itir Godɨn ofa gami. Ezɨ Ikiavɨra Itir God Abel ko an ofa bagha bar ifonge, ");
INSERT INTO msy2020_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","egha Kein ko an ofa gifongezir puvatɨ. Ezɨ Kein puv atarava an guam ikuvigha igharagha gari. ");
INSERT INTO msy2020_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ezɨ Ikiavɨra Itir God kamagh Kein mɨgei, “Nɨ tizim bagha atari? Egha manmaghsua nɨ puv atarava guam ikuvigha igharagha gari? ");
INSERT INTO msy2020_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Nɨ arazir aghuim damightɨ, kɨ nɨn ofa gifongeghtɨ, nɨ bar akuegham. Egh nɨ arazir kuram damightɨ, arazir kuram nɨ gasɨghasɨghasa, nɨ mɨzuai. Egha arazir kuram nɨ abɨnasa bar ifonge. Kamaghɨra nɨ uaghan gavgavigh anebɨn.” ");
INSERT INTO msy2020_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Egha gɨn Kein uan dozim Abel mɨkemezɨma, an a ko aning tuzim itir danganimɨn zui. Egha aning ghua tuzim itir danganimɨn ikiava, Kein uan dozim mɨsoghezɨma, an areme. ");
INSERT INTO msy2020_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ezɨ gɨn Ikiavɨra Itir God kamaghɨn Keinɨn azara, “Nɨn dozim Abel mana?” Ezɨ Kein ghaze, “Kɨ fozir puvatɨ. Kɨ uan dozim geghuva an garir gumazim puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ezɨ Ikiavɨra Itir God kamaghɨn Kein mɨgei, “Manmaghɨn amizɨ nɨ arazir kurar kam gami? Nɨn dozimɨn ghuzim nguazim giregha gɨfa, ezɨ kɨ ghuzir kamɨn ararem barazi, a uan osɨmtɨzim ikarvaghasava nan arai. ");
INSERT INTO msy2020_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ezɨ kɨ datɨrɨghɨn nɨ abɨnamin akar gavgavir mam kamaghɨn nɨn iti. Nɨ uan dozim mɨsoghezɨ, an areme. Ezɨ arazir kamɨn nɨ nguazim gamizɨma, an an ghuzim ame. Kamaghɨn kɨ datɨrɨghɨn nguazim nɨn anogoroke eghtɨ nɨ uam azenibar ingaran koghtɨ, dagheba nɨ bagh an otivan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Egh nɨ otuegh azenibar ingarvɨra ikɨtɨ, nguazim uan ovimɨn suiraghtɨ nɨn dagheba deragh aghungan kogham. Egh nɨ uabɨ, nguibaba nɨn puvatɨghtɨma, nɨ gumazir guraghav itimɨn mɨn pura ituramɨ nguazir kamɨn danganiba bar dar aruam.” ");
INSERT INTO msy2020_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ezɨ Kein mɨgɨrɨgɨar kam baregha kamagh Ikiavɨra Itir God mɨgei, “Osɨmtɨzir nɨ na ganɨdir kam a bar ekefe, kɨ manmaghɨn aneteram? ");
INSERT INTO msy2020_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Nɨ na mɨgɨa ghaze, kɨ bar azenitamɨn ingaran kogh, egh nɨn guamɨn bar saghon ikiam. Egh gumazir guraghav itimɨn mɨn nguazir kamɨn danganiba bar dar aruam. Kamaghɨn kɨ atiati, tarazi ua na batogh na mɨsueghtɨ, kɨ aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ezɨ Ikiavɨra Itir God kamaghɨn Kein mɨgei, “Bizitam kamaghɨn otoghan kogham. Gumazitam nɨ mɨsueghtɨ na aremeghtɨ, kɨ 7plan gumazibar nɨn ovevem ikaragham.” Egha Ikiavɨra Itir God ababanir mam Kein gatɨ, eghtɨ gumazitam a batogh ababanir kamɨn apigh, a mɨsueghtɨ an oveghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ezɨ Kein Ikiavɨra Itir God ategha, ghua nguazir otevir me kamagh dɨborim, “Aruavɨra Iti,” an an iti. Nguazir kam Idenɨn Azenimɨn aruem anadi naghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ezɨ Kein uan amuim ko akuizɨ, amizim navim asegha borir mam bate, an ziam Enok. Egha gɨn Kein nguibar ekiar mamɨn ingarigha, uan borimɨn ziam Enok isa nguibar ekiar kam gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Egha gɨn Enok otarir mam iti, an ziam Irat. Ezɨ Irat otarir mam iti, an ziam Mehujael. Ezɨ Mehujael otarir mam iti, an ziam Metusael. Ezɨ Metusael otarir mam iti, an ziam Lamek. ");
INSERT INTO msy2020_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ezɨ Lamek amuir pumuningɨn iti. Mavɨn ziam Ada, ezɨ mavɨn ziam Sila. ");
INSERT INTO msy2020_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ezɨ Ada Jabal bate, ezɨ Jabal a gumazir purirpenibar ikia bulmakaubar garir gumazibar ovavim. ");
INSERT INTO msy2020_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ezɨ Jabal dozir mam iti, an ziam Jubal. Jubal, a gitabav sogha marvibagh ivir gumazibar ovavim. ");
INSERT INTO msy2020_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Ezɨ gɨn Sila Tubalkein bate. Ezɨ Tubalkein bras ko ainɨn bizir guar avɨribar ingarir gumazim. Ezɨ Tubalkein buaramizir mam iti, an ziam Nama. ");
INSERT INTO msy2020_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Egha dughiar mam Lamek kamaghɨn uan amuimning mɨgei: “Ada ko Sila, gua nan akam baragh. Kɨ Lamek, gua nan amuimning, gua deravɨra nan akam baragh. Gumazir mam na mɨsozima, kɨ a mɨsoghezɨma an areme. Ezɨ gumazir igiar mam na guam apezezɨ, kɨ a mɨsoghezɨma an areme. ");
INSERT INTO msy2020_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Gumazitam Kein mɨsueghtɨ an aremegham, God 7plan gumaziba an ovevem ikarvagh me mɨsueghtɨ me arɨmɨghiregham. Eghtɨ gumazitam na mɨsueghtɨ kɨ aremeghtɨ, 77plan gumaziba ovegh na ikaragham.” ");
INSERT INTO msy2020_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Egha Adam uan amuim uam a koma akuizɨ, an otarim bate. Ezɨ amizim ghaze, “Kein Abel mɨsoghezɨ an areme. Kamaghɨn God Abelɨn danganim iniasa borir igharazim na ganɨngi.” Kamaghɨn a borir kam ziam, “Set,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ezɨ gɨn Set otarir mam ikia, ziam, “Enos,” a gatɨ. Dughiar kamra gumazamiziba Ikiavɨra Itir Godɨn ziam dɨbora, egha an ziam fa ghuavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Adamɨn eghaghanim kamaghɨra ghu. God gumazamizibar ingarizɨma me an mɨrara gari. A me gamizɨma, men marazi gumazibar mɨn otivizɨ, marazi amizibar mɨn otifi. A men ingarigha gɨvagha, deravɨra me damuamin akar aghuim me ganɨngi. Egha ziam me gatɨgha ghaze, “Gumazamiziba.” Ezɨ Adamɨn ovavir boribar ziaba kamaghɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam 130plan azeniba iti, ezɨ an otarim otogha, bar uan afeziam mɨrara gari. Ezɨ a ziam, “Set,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Set otogha gɨvazɨma, Adam uam 800plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ezɨ 930plan azeniba gɨvazɨma, Adam areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ezɨ Set 105plan azeniba itima, an otarim Enos oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enos otogha gɨvazɨma, Set uam 807plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ezɨ 912plan azeniba gɨvazɨma, Set areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ezɨ Enos 90plan azeniba itima, an otarim Kenan oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan otozɨma, Enos uam 815plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ezɨ 905plan azeniba gɨvazɨma, Enos areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Egha Kenan azenir 70pla itima, an otarim Mahalalel oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel otogha gɨvazɨma, Kenan uam 840plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ezɨ 910plan azeniba gɨvazɨma, Kenan areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ezɨ Mahalalel 65plan azeniba itima, an otarim Jaret oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jaret otozɨma, Mahalalel uam 830plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ezɨ 895plan azeniba gɨvazɨma, Mahalalel areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ezɨ Jaret 162plan azeniba itima, an otarim Enok oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok otozɨma, Jaret uam 800plan azenibar ikia, dar aven otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ezɨ 962plan azeniba gɨvazɨma, Jaret areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ezɨ Enok 65plan azeniba itima, an otarim Metusela oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela otogha gɨvazɨma, Enok uam 300plan azenibar ikia, dar aven dughiaba bar Godɨn boroghɨra ikia a ko roroam gamigha, otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok 365plan azeniba bar adar ike. ");
INSERT INTO msy2020_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok Godɨn boroghɨn ikia, egha a ko roroam gami. Ezɨ God a inigha uan Nguibam ghuavanabozɨ an aremezir puvatɨ. Ezɨ gumazamiziba a buriava, an apizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ezɨ Metusela 187plan azeniba itima, an otarim Lamek oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek otogha gɨvazɨma, Metusela ua 782plan azenibar ikia, egha otariba ko guivir igharaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ezɨ 969plan azeniba gɨvazɨma, Metusela areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ezɨ Lamek 182plan azeniba itima, an otarim oto. ");
INSERT INTO msy2020_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ezɨ Lamek ghaze, “Fomɨra Ikiavɨra Itir God nguazir kam gasɨghasɨgha ghaze, dagheba deragh an otivan kogham. Eghtɨ kamaghɨn e ingangarir dafabar amutɨ, dagheba deragh otivam. Eghtɨ otarir kam nguazim damutɨ dagheba deragh otivtɨ e tong avughsɨ, egh puvɨra ingaran kogham.” Kamaghɨn, Lamek ziam Noa, uan otarim gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noa otogha gɨvazɨma, Lamek ua 595plan azenibar ikia, dar aven otariba ko guivir maba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ezɨ 777plan azeniba gɨvazɨma, Lamek areme. ");
INSERT INTO msy2020_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ezɨ Noa 500plan azeniba itima, an otarir 3pla oto, men ziaba, Siem, Ham, ko Jafet. ");
INSERT INTO msy2020_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ezɨ datɨrɨghɨn gumazamizir avɨriba otiva nguazim gizɨvagha, guiviba bate. ");
INSERT INTO msy2020_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ezɨ Godɨn otariba gari, gumazamizibar guivir igiaba, men mɨkarzibar ganganiba bar men dera. Ezɨ me uan ifongiamɨn gɨn ghua, me isa men iti. ");
INSERT INTO msy2020_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ezɨ God ghaze, “Gumazamiziba angamɨra ikiasa kɨ uan Duam me gatɨ. Ezɨ men mɨkarziba nguazir kamɨn biziba, kamaghɨn kɨ uan Duamɨn amamangatɨghtɨ, a me ko dughiar ruarimɨn ikian kogham. Datɨrɨghɨn me 120plan azenibara ikegh egh ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ezɨ dughiar kamɨn ikegha gɨn zuir dughiamɨn, gumazir bar dafar maba nguazimɨn ike. Gumazir kaba, kar gumazamizibar guivir igiaba Godɨn otariba ko akuizɨ otivizir boriba. Me ingangarir igharagha garibar amuamin gavgavim ikia egha dughiar kamɨn ziar ekiaba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ezɨ Ikiavɨra Itir God, nguazim bar an itir gumazamizibar gari, men arazir kuraba bar ikufi. Gumazamiziba dughiaba bar, uan navir averiamɨn aven arazir kuraba baghavɨra nɨghnɨgha dagh ifongeghavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ezɨ Ikiavɨra Itir God men arazir kurabagh nɨghnɨgha bar osemegha ikia navim bighiaghirɨgha, ghaze, mevzika, kɨ ti nguazimɨn itir gumazamizibar ingarizir puvatɨzɨ deraghai. ");
INSERT INTO msy2020_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Egha Ikiavɨra Itir God ghaze, “Kɨ ingarizir bizir kaba bagha osemegha nan navim bɨki. Kamaghɨn, kɨ guizbangɨra gumazamizir kɨ ingarizibagh asɨghasɨghtɨ, men tav ua nguazimɨn ikian kogham. Eghtɨ kɨ asɨzir nguibamɨn itiba ko ruarimɨn itiba, ko kuaraziba bar, kɨ uaghan dagh asɨghasigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ezɨ Noa uabɨra, Ikiavɨra Itir Godɨn damazimɨn deravɨrama oto, ezɨ a bar a gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Eghaghanir kam, a Noan eghaghanim. An otarir 3pla iti, men ziabar kara: Siem, Ham ko Jafet. Noa Godɨn damazimɨn bar gumazir aghuim, egha gumazamizibar damazibar dera. Egha a dughiaba bar Godɨn boroghɨn ikiava a ko roroam gami. ");
INSERT INTO msy2020_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ezɨ God gumazamizir igharazibar gari, men araziba bar ikufi. Nguazir oteviba bar, mɨdorozir arazim ko orazir puvatɨzir arazim ghuavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God garima arazir kuram bar nguazim avara. Ezɨ a gari gumazamizir aghuaritam itir pu. Puvatɨ. Gumazamiziba bar arazir kurabaram amua iti. ");
INSERT INTO msy2020_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kamaghɨn, God kamaghɨn Noa mɨgɨa ghaze, “Gumazamiziba bar uariv soghava orazir puvatɨzir arazim gami, ezɨ nguazir kam arazir kuram bar a gizɨfa. Kamaghɨn, kɨ nguazir kam sara, me gasɨghasɨghasa. Kɨ gumazamiziba bar me agɨvaghtɨ, me ua ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kamaghɨn, nɨ temer aghuiba abighɨva ua bagh kurir tamɨn ingarigh. Egh an averimɨn danganitabar ingarighva koltan an averiam ko azenim aghefegh. ");
INSERT INTO msy2020_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Nɨ kurir kam kamaghɨn an ingar: An ruarim 130 mitan tughtɨ, an baravim 22 mitan tugh, eghtɨ an siriam 13 mitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Egh nɨ an siriamɨn ingartɨ, an siriam bar izighirɨ an mɨriam avan markɨ. Nɨ kurir siriam ko mɨriamɨn tongɨra toritam ateghtɨ, aruer angazangarim kurimɨn aven mangɨ. Egh nɨ ghuriar 3pla kurimɨn aven dar ingarigh, tam vazimɨn, tam arɨghara, egh tam pɨn. Egh tiar akam an mɨriamɨn an ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Nɨ oragh! Kɨ aperiar ekiam damightɨ a nguazimɨn otogh, nguazimɨn itir bizir angamɨra itiba bar dar amightɨ da bar moghɨrama ovengam. ");
INSERT INTO msy2020_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Eghtɨ kɨ nɨ ko, uan Akar Dɨkɨrɨzir Gavgavim akɨrightɨ, nɨ deragh ikiam. Nɨ uan amuim ko, uan otariba ko men amuiba, ia kurir kamɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Egh nɨ asɨziba vaghvagh pumuning pumuningɨn me ini, amebar mam ko apurir mam. Egh me ovengan koghsɨ da inigh kurimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Nɨ kuarazir igharagha gariba vaghvagh, dar pumuning pumuning, ko asɨzir muziariba ko ekiar igharagha gariba vaghvagh, dar pumuning pumuning inigh. Egh da ovengan koghsɨ, nɨ da inigh kurimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Egh nɨ uan amuiroghboriba ko asɨzibagh nɨghnigh, dagher guar avɨriba bar da isɨ kurim darɨkigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ezɨ Noa God a mɨkemezɨ moghɨra bizir kaba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Egha Ikiavɨra Itir God kamaghɨn Noa mɨgei, “Kɨ nɨn gari, nɨrara nguazimɨn gumazamizibar tongɨn nan damazimɨn dera. Kamaghɨn, nɨ uan amuim ko, nɨn otariba uan amuiba ko, ia bar kurimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Egh nɨ asɨzir nan damazimɨn zuezir igharagha gariba vaghvagh, 7plan amebaba ko 7plan apuriba inigh. Egh asɨzir nan damazimɨn zuezir puvatɨzir igharagha gariba, nɨ vaghvagh amebam ko apurimra inigh, kurimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kamaghɨra nɨ kuarazir igharagha garibar 7plan amebaba ko apuriba ini. Nɨ kamaghɨn damightɨ da arɨmɨghireghan koghtɨ, dar nguziba gɨn nguazimɨn otivigh bar avɨrasemegham. ");
INSERT INTO msy2020_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Eghtɨ dughiar 7pla gɨvaghtɨ, kɨ amozim nguazimɨn anemadaghtɨ, a 40plan arueba ko dɨmagaribar arigh mamaghɨra ikiam. Eghtɨ bizir kɨ ingarizɨ angamɨra itiba, kɨ dagh asɨghasɨghtɨ, da bar arɨmɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ezɨ Noa God a mɨkemezɨ moghɨra, biziba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa 600plan azeniba itima, aperiar kam oto. ");
INSERT INTO msy2020_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Dughiar kam, Noa uan amuim ko, an otariba uan amuiba ko, aperiam otogh me gasɨghasɨghan koghasa, me kurimɨn aven ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Ezɨ God Noa mɨkemezɨ moghɨra, asɨzir Godɨn damazimɨn zueziba ko, asɨzir mɨzɨrɨziba ko, kuaraziba ko, asɨzir muziariba, asɨzir igharagha gariba bar, da vaghvagha apurir mam ko amebar mam, pumuning pumuningɨn Noa bagha iza, ghua kurimɨn ghuavanangi. ");
INSERT INTO msy2020_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Dughiar 7pla gɨvazɨma, aperiar ekiam otogha nguazim gizefi. ");
INSERT INTO msy2020_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Dughiar kam Noa 600plan azeniba iti, ezɨ azenir kamɨn iakɨnir namba 2ɨn, dughiar namba 17ɨn, nguazim akam akarizɨma, dɨpar nguazimɨn averiamɨn itir ekiam akariaghɨrɨgha zuamɨram anabo. Ezɨ amozim izaghira mati me dɨpam fusfusi. ");
INSERT INTO msy2020_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ezɨ amozir ekiam 40plan arueba ko dɨmagaribar izaghira mamaghɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ezɨ Amozim arɨghizir dughiamra, Noa, uan amuim ko, an otarir 3pla, Siem, Ham, Jafet, uan amuiba ko, me kurimɨn aven ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ezɨ nguibamɨn asɨzir guar avɨriba bar, ko ruarimɨn asɨzir ekiaba ko dozir guar avɨriba, ko kuaraziba bar vaghvagha Noan adarazi ko kurimɨn aven ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ezɨ God mɨkemezɨ moghɨn, bizir angamɨra itiba, da vaghvagha apurir mam ko amebar mam, pumuning pumuningɨn Noa bagha iza, a ko kurimɨn aven zui. Noa aven ghugha gɨvazɨma, Ikiavɨra Itir God tiam asara. ");
INSERT INTO msy2020_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ezɨ 40plan aruebar dɨpam izɨvavɨra ikia, kurim asirafa. Ezɨ kurim nguazim ategha pɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ezɨ dɨpam nguazim gisɨn sɨvaghsɨvagha ghuavanadima kurim a gisɨn deravɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ezɨ nguazim gisɨn dɨpam sɨvaghsɨvagha ghuavanagavɨra ikia mɨghsɨar overiamɨn apengan itiba bar ada ave. ");
INSERT INTO msy2020_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Egha abuan dɨpam nguazim bar anevaragha, sɨvagha pɨn ghua overiamɨn apengan itir mɨghsɨar ekiaba bar dagh afiragha 7 mitan tu. ");
INSERT INTO msy2020_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ezɨ nguazimɨn angamɨra itir bizir kaba, kuaraziba ko, nguibamɨn asɨziba, ruarimɨn asɨzir ekiaba ko doziba ko gumazamiziba, me bar ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ezɨ nguazimɨn itir bizir angamɨra itiba bar ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ezɨ nguazimɨn itir bizir kaba bar, gumazamiziba, nguibamɨn itir asɨziba, ruarimɨn itir asɨziba, ko kuaraziba, Ikiavɨra Itir God bar me kuavareme. Ezɨ Noa ko bizir kurimɨn aven itiba merara angamɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ezɨ dɨpam bar ekevegha nguazim bar anevaragha ghua 150plan dughiabar ike. ");
INSERT INTO msy2020_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ezɨ dughiar kamɨn God Noa ko asɨzir a ko kurimɨn itiba gɨn amadazir puvatɨ, a me gɨnɨghnɨghavɨra ikiava amɨnim amadazɨ a dɨpam gisɨn ivaima dɨpam sɨvagha uaghiri. ");
INSERT INTO msy2020_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ezɨ dɨpar nguazimɨn averiamɨn izim uam anadir puvatɨ. Ezɨ overiamɨn amozim izir tuaviba pɨrizɨ, amozim ua izaghirir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ezɨ dɨpam ghuaghira ghua, 150plan dughiaba gɨvazɨma dɨpam daka uaghiravɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ezɨ iakɨnir namba 7ɨn dughiar namba 17ɨn kurim Araratɨn Mɨghsɨabar itir danganimɨn mɨghsɨar mamɨn apera. ");
INSERT INTO msy2020_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ezɨ dɨpam, daka uaghiravɨra ikia ghua iakɨnir namba 10ɨn dughiar namba 1ɨn tuzɨ, dughiar kamra mɨghsɨabar ghuaba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Ezɨ 40plan dughiaba gɨvazɨma, Noa kurimɨn windua kuigha, kuarazir ziam kotkot amadazɨma, a ghugha ua izezir puvatɨ. A mɨgha aruavɨra ikiav itima dɨpam dakezɨ nguazim mɨsɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ezɨ Noa foghasa, nguazim mɨsɨngis, o puvatɨ. Egha kamaghɨn, kuarazir ziam bunbam amadazɨma, a zui. ");
INSERT INTO msy2020_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ezɨ dɨpam nguazim avaragha ikiavɨra itima, kuarazir bunbam dapian danganibagh asa, kamakɨn dɨpam mong pɨn ikiavɨra iti. Ezɨ a uamategha kurimɨn ghuzɨ, Noa dafarim amadagha uam a inigha aven ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ezɨ 7plan dughiaba gɨvazɨma, Noa ua kuarazir bunbam amada. ");
INSERT INTO msy2020_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ezɨ dughiar kamɨn bar guaratɨzimɨn kuarazir bunbam uamategha a bagha izi. Egha uan akamɨn olivɨn temer dafarir igiar mam iviragha izi. Ezɨ Noa kamaghɨn fo, dɨpam dakegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Egha a 7plan dughiabar uam orarkegha kuarazir bunbam uam anemada. Ezɨ kuarazir bunbam ua izezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ezɨ Noa dughiar kamɨn 601plan azeniba iti, ezɨ iakɨnir namba 1, an dughiar namba 1 otozɨ dɨpam mɨdɨi. Ezɨ a kurimɨn siriam mɨkɨnizir avavem asigha azenan danganiba bar deravɨra dar gari, nguazim mɨsɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Egha ghua iakɨnir namba 2ɨn, namba 27ɨn dughiam otozɨ, nguazim bar mɨsɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ezɨ God Noa mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nɨ, uan amuim ko, nɨn otariba uan amuiba ko, ia kurim ategh magɨrɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Egh angamɨra itir asɨziba bar, kuaraziba ko asɨzir ruarim ko nguibamɨn itiba, nɨ bar moghɨra da inigh magɨrɨ. Eghtɨ da bar otɨv arogh avɨrasemeghɨva nguazir kam bar an angɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ezɨ Noa uan amuim ko an otariba, uan amuiba ko uaghiri. ");
INSERT INTO msy2020_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ezɨ kuaraziba ko asɨzir avɨrir guar magh gariba vaghvagha uari uari abɨgha uari akuva egha azenan izi. ");
INSERT INTO msy2020_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Egha Noa Ikiavɨra Itir Godɨn ziam fasa ofa damuamin danganir mamɨn ingari. Egha Godɨn damazimɨn zuezir asɨzir guar avɨriba, dar vamɨra vamɨra inigha, kuarazir Godɨn damazimɨn zueziba dar vamɨra vamɨra inigha dav suegha God bagha ofa gami. Egha da tuezɨ da bar isigha mɨghɨri. ");
INSERT INTO msy2020_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ezɨ Ikiavɨra Itir God Noa amizir mughuriar aghuim zuir ofa bagha bar ifuegha ghaze, “Kɨ ua gumazamizibar arazir kuraba bagh nguazim gasɨghasɨghan kogham. Guizbangɨra, gumazamiziba boribar mɨn ikia ghua asangizir dughiamɨn, me bar arazir kuram damuamin nɨghnɨziba iti. Ezɨ bizir kam bagha, kɨ biziba bar dagh asɨghasɨki. Egh kɨ dughiar kamɨn amizir arazir kamɨn mɨrara, uamategh angamɨra itir biziba bar dagh asɨghasɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Eghtɨ nguazim ikɨvɨra ikɨtɨ dughiar kaba uaghan otivɨra ikiam, dughiar dagheba opariba ko dagheba iniamba, dughiar orangtɨziba ko fefeba, dughiar amoziba iziba ko arueba gariba ko dɨmagariba ko arueba. Dughiar kaba gɨvaghan kogh mangɨ nguazim gɨvamin dughiam otogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dughiar kamɨn, God arazir aghuim Noa uan otariba ko, me damuasa kamaghɨn me mɨgɨa ghaze, “Ia borir avɨriba batɨtɨ, ian adarazi nguazir kam bar a gizɨvaka. ");
INSERT INTO msy2020_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Eghtɨ ruarimɨn itir asɨzir muziariba ko ekiaba, ko kuaraziba, ko osiriba bar moghɨra ian atiatightɨ, ia me gativagh men ganam. ");
INSERT INTO msy2020_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kɨ faragha ia damasa zuravaribara daghebar mɨn ia ganɨngi. Egha datɨrɨghɨn nguibamɨn asɨziba, ko ruarimɨn itir asɨziba, ko zuravariba sara bar da isa ia ganɨngi eghtɨ, ia bar dar amam. ");
INSERT INTO msy2020_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Guizbangɨra, ghuzim ivemara ikɨrɨmɨrir angamɨra itim anɨdi. Kamaghɨn, ia ghuziba ikiavɨra itir asɨzitam aman markɨ. Ia asɨzim mɨsueghtɨ, an ghuzim faragh bar iregh gɨvaghtɨma, ia gɨn anemɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Eghtɨ tina gumazimɨn ghuzim damutɨ, a ireghtɨ an aremegham, eghtɨ kɨ gumazir kamɨn arazir kuram ikarvagham. Guizbangɨra, asɨzitam o gumazitam gumazir mam mɨsueghtɨ an aremegham, kɨ uaghan osɨmtɨzir kuram a danightɨ an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kɨ God, kɨ uabɨ gumazimɨn ingarizɨma a nan mɨrara gari. Kamaghɨn gumazir manam igharazitav mɨsoghezɨ an areme, egh a uabɨ gumazibar dafaribar ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Egha God ua kamaghɨn mɨgei, “Eghtɨ iarara, ia borir avɨriba batɨtɨ, ian boriba bar avɨrasemegh nguazimɨn otɨvarogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Egha God Noa ko an otaribav gɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ia oragh! Kɨ datɨrɨghɨn ia ko, ian borir gɨn otivamiba ko Akar Dɨkɨrɨzir Gavgavim gami. ");
INSERT INTO msy2020_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Egha uaghan bizir angamɨra ia ko kurimɨn ikezir kaba, kuaraziba, nguibamɨn asɨziba ko, ruarimɨn asɨzir ia ko itiba, da bar, kɨ me ko Akar Dɨkɨrɨzir Gavgavir kam gami. ");
INSERT INTO msy2020_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kɨ datɨrɨghɨn ia koma Akar Dɨkɨrɨzir Gavgavim gamigha kamaghɨn mɨgɨa ghaze, Guizbangɨra, kɨ datɨrɨghɨn uam aperiar ekiatam damightɨ a izɨ bizir angamɨra itibagh asɨghasighan kogham. Eghtɨ aperiar ekiatam nguazir kam ua bar gasɨghasɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Egha God ghaze, “Kɨ arazir kam akaghtɨ, ia ganigh fogh suam, kɨ Akar Dɨkɨrɨzir Gavgavim ia ko, bizir angamɨra ia ko itiba, ko ian gɨn otivamin boriba, kɨ ia bagha bar a gamigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ezɨ arazir kam kamakɨn, kɨ ababanim ian akagha, overiamɨn pɨn ekianim atɨ. Kar nan ababanim, a ghaze, Akar Dɨkɨrɨzir Gavgavir kɨ nguazimɨn itir biziba bagha amizim, a ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Eghtɨ kɨ amozim amadaghtɨ a izeghtɨ an gɨn ghuariar ekiaba ikɨvɨra ikɨtɨ, dughiar kamɨn ekianim overiamɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Eghtɨ kɨ an ganigh uan Akar Dɨkɨrɨzir Gavgavir, bizir angamɨra itiba ko ia bagha amizim a gɨnɨghnɨghvɨra ikiam. Eghtɨ bizitam ua kamaghɨn otivan kogham, aperiatam uam nguazimɨn angamɨra itir bizibagh asɨghasighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Egh kɨ pɨn ekianimɨn ganɨva, nguazimɨn angamɨra itir biziba ko amizir Akar Dɨkɨrɨzir Gavgavir kam gɨnɨghnɨghvɨra ikɨtɨ, a ikɨ mamaghɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Egha God Noa mɨgei, “Ekianir kam, kar nan ababanim, kɨ nguazimɨn angamɨra itir biziba bagha Akar Dɨkɨrɨzir Gavgavim gamigha aneka.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kar Noan otarir 3plan a ko kurimɨn ikegha azenan izezibar ziaba: Siem, Ham ko, Jafet. Ezɨ Hamɨn otarimɨn ziam, Kenan. ");
INSERT INTO msy2020_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ezɨ Noan otarir 3plan kabanang, me datɨrɨghɨn nguazim gizɨvazir gumazamiziba bar men ovaviba. ");
INSERT INTO msy2020_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ezɨ aperiar ekiamɨn gɨn Noa azenim oparir gumazimɨn mɨn otogha faraghavɨra wainɨn azenir mam opari. ");
INSERT INTO msy2020_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Egha dughiar mamɨn a wainɨn dɨpar onganir maba amegha ongani. Ezɨ an iniba paghirezɨma a bibiamra uan purirpenim girɨghav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ezɨ Kenanɨn afeziam Ham, ghua uan bibiamra itir afeziamɨn ganigha uam azenan ghua uan aveghbuamning mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ezɨ Siem ko Jafet inir mam inigha an onegha uan dɨpɨzimning gatɨ. Egha aning purirpenim akɨrim ragha a gasaragha nɨmɨra itimra ghua uan afeziamɨn mɨkarzim avara. Aning uan guamning igharagha mɨsuegha uan afeziamɨn mɨkarzim avara. Egha uan afeziamɨn mɨkarzir mogomemɨn ganizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ezɨ Noan nɨghnɨzim derazɨ a ua dɨkavigha an otarir abuananam Ham, an mɨkarzir mogomemɨn ganizir bizim baraki. ");
INSERT INTO msy2020_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Egha a ghaze, “Osɨmtɨzir ekiam Kenan ko ikɨtɨ, a uan aveghbuabar ingangarir gumazimɨn bar men apengan ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Egha Noa ua kamaghɨn mɨgei, “E Ikiavɨra Itir Godɨn ziam fam, a Siemɨn God. Egha kɨ kamaghɨn Godɨn azai, Kenan pura Siemɨn ingangarir gumazimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Eghtɨ God Jafetɨn adarazir amightɨ me avɨrasemegh, Siemɨn adarazi ko deragh dapiam. Eghtɨ Kenan pura Jafetɨn ingangarir gumazimɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Aperiar ekiam gɨvazɨma, Noa uam 350plan azenibar ike. ");
INSERT INTO msy2020_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Egha 950pla azeniba ikiava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kar Noan otaribar eghaghanim. Men ziabar kara: Siem, Ham, ko Jafet. Ezɨ aperiar ekiamɨn gɨn men ovavir borir avɨribar otifi. Ezɨ Noan ovavir boribar ziaba kamaghɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Kar Jafetɨn otaribar ziabar kara: Gomer, Magok, Madai, Javan, Tubal, Mesek, ko Tiras. ");
INSERT INTO msy2020_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ezɨ Gomerɨn otaribar ziabar kara: Askenas, Rifat, ko Togarma. ");
INSERT INTO msy2020_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ezɨ Javanɨn otaribar ziabar kara: Elisa, Tarsis, ko Saiprusɨn gumaziba, ko Dodania. ");
INSERT INTO msy2020_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ezɨ gumazir kaba, gɨn ongarir mɨriam ko arighatɨzibagh apiazir darazir ovaviba. Kar Jafetɨn ovavir boriba. Egha me uan dakozibar vaghvagha uan nguazibarama apiagha, uari uan ikɨzibara akabav gei. ");
INSERT INTO msy2020_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ezɨ Hamɨn otaribar ziabar kara: Kus, Isip, Libia ko Kenan. ");
INSERT INTO msy2020_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ezɨ Kusɨn otaribar ziabar kara: Seba, Havila, Sapta, Rama ko Sapteka. Ezɨ Rama otarir pumuningra iti: Seba ko Dedan. ");
INSERT INTO msy2020_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Ezɨ Kus otarir mam iti, an ziam Nimrot. Nimrot a nguazir kamɨn bar faraghavɨra otozir gumazir bar gavgavim. ");
INSERT INTO msy2020_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ezɨ Ikiavɨra Itir God gavgavim isa Nimrot ganɨngizɨma an asɨziba burir fofozir ekiam iti. Kamaghɨn gumazamiziba ziar ekiam munav danɨngasa, kamaghɨn mɨgei, “Gumazir kam a Nimrotɨn mɨraram ami. Ikiavɨra Itir God gavgavim Nimrot ganɨngizɨma, ana asɨziba buriamin fofozir ekiar aghuim iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ezɨ Nimrot nguibar ekiar 3plan gari, Babel, Erek, ko Akat. Nguibar ekiar 3plan kaba Babilonian nguazimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Egha Nimrot Babilon ategha Asirian amadaghan ghua nguibar ekiar kabar ingari, Ninive, Rehobotir, Kala, ");
INSERT INTO msy2020_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ko Resen. Resen, a Ninive ko Kalan nguibamningɨn tizimɨn iti. Ezɨ Kalan nguibam a nguibar bar ekiam. ");
INSERT INTO msy2020_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Isip a ikɨzir kabar ovavim: Lidia, Anam, Lehap, Naptu, ");
INSERT INTO msy2020_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ko Patrus, Kaslu, ko Krit. Ezɨ Filistian ikɨzimɨn adarasi, me Kritɨn Arighatɨzimɨn itir darazir aven otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ezɨ Saidon a Kenanɨn otarir ivariam. Ezɨ igharaz darazi uaghan Kenanɨn ovavir boriba, ezɨ men adarazir kara: Hitia, ");
INSERT INTO msy2020_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusia, Amoria, Girgasia ko, ");
INSERT INTO msy2020_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivia, Arkaia, Sinia, ");
INSERT INTO msy2020_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvatia, Semaria ko Hamatia. Gɨn Kenanɨn adarazir danganiba bar a dar ghuava tintinibar apia. ");
INSERT INTO msy2020_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Egha Kenania inigha apiazir nguazir kam Saidonɨn nguibamɨn ikegha ghua Gerarɨn nguibamɨn tu, kar Gasan nguibamɨn amadakan. Ezɨ men mɨtaghniam ghua aruem anadi naghɨn nguibar kabar tu, Sodom ko Gomora ko Atma ko Seboim, kar Lasan nguibamɨn amadakan. ");
INSERT INTO msy2020_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Gumazamizir kaba bar, me Hamɨn ovavir boriba. Egha me uan dakozibar vaghvagha uan nguazibarama apiagha, uari uan nguibabara akabav gei. ");
INSERT INTO msy2020_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ezɨ Siem a Jafetɨn avebam. Egha uaghan boriba iti, egha Siem a Eberɨn boribar ovavir afeziam. ");
INSERT INTO msy2020_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siemɨn otaribar ziabar kara: Elam, Asur, Arpaksat, Lidia ko Aram. ");
INSERT INTO msy2020_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ezɨ Aramɨn otaribar ziabar kara: Us, Hul, Geter ko Mas. ");
INSERT INTO msy2020_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ezɨ Arpaksat, a Selan afeziam, ezɨ Sela, a Eberɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ezɨ Eber an otarir pumuning iti. Mamɨn ziam Pelek. Pelek itir dughiamɨn nguazimɨn itir gumazamiziba tintinimɨn bɨaghire. Kamaghɨn me ziar kam, “Pelek,” a gatɨ. Ziar kamɨn mɨngarim kamakɨn, “Bar bɨaghire.” Ezɨ Pelekɨn dozimɨn ziam Joktan. ");
INSERT INTO msy2020_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ezɨ Joktanɨn otaribar ziabar kara: Almodat, Selep, Hasarmavet, Jera ko, ");
INSERT INTO msy2020_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usal, Dikla ko, ");
INSERT INTO msy2020_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba ko, ");
INSERT INTO msy2020_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, ko Jobap. Gumazir kaba bar, me Joktanɨn otariba. ");
INSERT INTO msy2020_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ezɨ Joktanɨn boriba Mesan nguibamɨn ikegha ghua aruem anadi naghɨn Sefarɨn nguibar mɨghsɨabar tu. ");
INSERT INTO msy2020_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kar Siemɨn ovavir boriba. Egha me uan dakozibar vaghvagha uan nguazibarama apiagha, uari uan ikɨzibar akabav gei. ");
INSERT INTO msy2020_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Gumazir ziaba itir kaba, kar Noan otariba ko an otaribar otariba ko men ovavir boriba. Aperiar ekiamɨn gɨn, gumazamizir kabar ikɨziba nguazim gizɨvagha aneroke. ");
INSERT INTO msy2020_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Fomɨra nguazimɨn gumazamiziba bar akar vamɨra ikia, egha mɨgɨrɨgɨar otevir vabaram ami. ");
INSERT INTO msy2020_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Egha me aruem anadi naghɨn ikegha, puram arua ghua iza Babilonɨn nguazir zarimɨn apia. ");
INSERT INTO msy2020_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Egha me uarira uariv gei, “Aria, ia izɨ, e bar moghɨra nguazitaba inigh da tueghtɨ da brighbar mɨn otivika.” Egha me dɨpenibar ingaramin brighbagh ami. Egha me brighɨn kabagh amizɨ da uarir isavsuighamin koltaba uaghan iti. ");
INSERT INTO msy2020_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Egha me ghaze, “E datɨrɨghɨn uari uari bagh nguibar ekiatamɨn ingaram, egh an aven tauan bar ruaritam asaraghtɨ, an ruarim mangɨ overiamɨn suiragham. Egh kamagh, e uari abɨgh mangɨ tintinibar nguazimɨn nguibar igharazibar ikian kogham. E kamaghɨn damutɨ, gumazamiziba bar ziar bar ekiam e danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ezɨ Ikiavɨra Itir God, nguibar ekiar kam ko tauan gumazamiziba an aven ingarizimɨn ganasa izaghiri. ");
INSERT INTO msy2020_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Egha uan Nguibamɨn ikia ghaze, “Gumazamizir kaba me akar vamɨram mɨgɨa egha uari inigha nɨghnɨzir vamɨra iti. Egha nguibar dafar kamɨn ingari. Me kamaghɨn uan nɨghnɨzimɨn gɨn mangɨ, bizir avɨribar amuam. ");
INSERT INTO msy2020_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kamagh, e ua magɨrɨ akar me mɨgeim abɨghɨrarightɨ, me uan akar mɨngaribagh foghan koghɨva uariv kɨman kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Egha Ikiavɨra Itir God me gamizɨ, me tintinibar nguaziba bar adar ghue. Egha nguibar ekiar kam uam a ingari puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dughiar kam, Ikiavɨra Itir God gumazamizir kabar akar me mɨgeiba abɨagharɨghizɨ, me tintinibar nguazimɨn danganiba bar adar ghue. Kamaghɨn me nguibar ekiar kam dɨbora ghaze, “Babel.” ");
INSERT INTO msy2020_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Kar Siemɨn ovavir boribar ziaba. Aperiar ekiam otozɨ azenir pumuningɨn gɨn, me Siemɨn azeniba medi da 100ɨn oto. Ezɨ an Arpaksatɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Egha gɨn Siem 500plan azeniba ikia, dar aven otariba ko guivir igharaziba inigha areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ezɨ Arpaksat 35pla azeniba ikiava Selan afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Egha gɨn Arpaksat 403plan azeniba ikia dar aven, otariba ko guivir igharaziba inigha areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ezɨ Sela 30pla azeniba ikiava Eberɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Egha gɨn Sela 403pla azenibar ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ezɨ Eber 34pla azeniba ikiava Pelekɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Egha gɨn Eber 430pla azenibar ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ezɨ Pelek 30pla azeniba ikiava Reun afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Egha gɨn Pelek 209pla azeniba ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ezɨ Reu 32pla azeniba ikiava Serukɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Egha gɨn Reu 207pla azeniba ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ezɨ Seruk 30pla azeniba ikia Nahorɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Egha gɨn Seruk 200pla azeniba ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ezɨ Nahor 29pla azeniba ikia Teran afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Egha gɨn Nahor 119pla azeniba ikia, dar aven otariba ko guivir igharaziba inighava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ezɨ Tera 70pla azeniba ikiava Abram, Nahor ko Haranɨn afeziamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ezɨ kar Teran ovavir boribar ziaba. Tera a Abram, Nahor ko Haranɨn afeziam. Ezɨ Haran a Lotɨn afeziam. ");
INSERT INTO msy2020_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ezɨ Haran uan nguibam Urɨn ikiava areme. Ur a Kaldiabar nguazir asɨzimɨn iti. Ezɨ dughiar kam, an afeziam Tera angamɨra ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ezɨ Abram Sarain iti, ezɨ Nahor Haranɨn guivim Milkan iti. Egha uaghan Haran Iskan afeziam. ");
INSERT INTO msy2020_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ezɨ Sarai boriba batir puvatɨgha, boritam itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ezɨ Tera uan adarazi inigha, Kaldiabar nguazimɨn itir nguibam Ur, an ategha Kenanɨn nguazimɨn zui. Teran gɨn zuir adarazir ziabar kara: an otarim Abram, ko an asamim Sarai, ko an igiam Lot, ezɨ Haran a Lotɨn afeziam. Me ghua Haranɨn nguibamɨn otivigha egha nguibar kamɨn apera. ");
INSERT INTO msy2020_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Egha Tera 205pla azeniba ikiava nguibar kamɨn areme. ");
INSERT INTO msy2020_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Dughiar mam, Ikiavɨra Itir God Abram mɨgɨa ghaze, “Nɨ uan nguazim, ko uan adarasi, ko uan afeziamɨn ikɨzim ategh nguazir kɨ nɨn akaghamimɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Eghtɨ kɨ nɨn ovavir boribar amightɨ, me bar avɨrasemegh, mangɨva gɨn ikɨzir gavgavir mam otogham. Egh kɨ deravɨra nɨ damu nɨ damightɨ nɨn ziam bar ekevegham. Eghtɨ nɨ bangɨn kɨ gumazamiziba deravɨra me damuamin tuavim ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Eghtɨ gumazamizir deravɨra nɨ gamiba, kɨ deravɨra me damuam. Eghtɨ nɨ gasɨghasɨzir gumazamiziba kɨ uabɨ me gasɨghasigham. Nɨ bangɨn kɨ nguazir kamɨn itir ikɨziba bar dar gumazamiziba bar deragh me damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ezɨ Abram Haranɨn nguibam ategha Ikiavɨra Itir God a mɨkemezɨ moghɨn, a zui. Ezɨ Lot a ko uaghan zui. Dughiar kamɨn Abram 75plan azeniba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram uan amuim Sarai, ko uan dozimɨn otarim Lot inigha, me uaghara zui. Abram faragha Haranɨn nguibamɨn ikia egha bizir avɨriba ko ingangarir gumaziba ko amizir avɨriba ini. Egha a Kenanɨn zuir dughiamɨn a bizir kaba bar da inigha zui. Egha me Kenanɨn otivigha gɨvagha, ");
INSERT INTO msy2020_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram uan adarazi ko nguazir kamɨn ghua Sekemɨn nguibamɨn oto. Nguibar kamɨn temer ekiar mam ikia Moren danganimɨn amadaghan iti. Ezɨ dughiar kamɨn Kenania Kenanɨn nguazimɨn ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ezɨ Ikiavɨra Itir God Abram batogha a mɨgei, “Kɨ nguazir kam nɨn ovavir boribar anɨngam.” Kamaghɨn Abram Ikiavɨra Itir God a batozɨ naghɨra, an ziam fasa ofa gamir dakozimɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Egha gɨn Abram dɨkavigha ghua, aruem anadi naghɨn itir mɨghsɨar Betelɨn boroghɨn itimɨn ghu. Mɨghsɨar kam Betelɨn nguibam ko Ain nguibamɨn tizimɨn iti. Ezɨ Betel an aruem uaghiri naghɨn itima, Ai an aruem anadi naghɨn iti. Ezɨ danganir kamɨn Abram uan purirpenibar ingarigha, Ikiavɨra Itir Godɨn ziam fasa, ofa gamir dakozimɨn ingarigha, an ziam dɨbora a fe. ");
INSERT INTO msy2020_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Egha gɨn Abram uan adarazi ko danganir kam ategha sautɨn amadaghan zui. Egha me purirpenibar ingara ghua Negevɨn danganimɨn oto, a gumazamiziba puvatɨzir danganim. ");
INSERT INTO msy2020_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Dughiar mam mɨtiriar ekiam otozɨ, danganir kam dagheba bar puvatɨ. Kamaghɨn, Abram uan adarazi ko me ghua nguibar igharazibar gumazamizibar mɨn pura ikia, kantri Isipɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Egha me kantri Isipɨn boroghɨra iza, Abram uan amuim Sarai mɨgɨa ghaze, “Nɨ orakigh. Kɨ fo, nɨ amizir dirir bar deragha ganganir aghuim gamim. ");
INSERT INTO msy2020_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isipɨn gumaziba nɨn ganigh, ti nɨ gakuegham. Egh me kamaghɨn fogham, nɨ nan amuim, egh me na mɨsueghtɨ kɨ aremeghtɨ, nɨ ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nɨ kamaghɨn mɨkɨmtɨ deragham, nɨ nan amizim. Egh nɨ kamaghɨn damightɨ, me arazir aghuimɨn na damu, na mɨsueghtɨ kɨ aremeghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ezɨ Abram kantri Isipɨn otozɨ, Isipɨn gumaziba a mɨkemezɨ moghɨra, an amuimɨn garima an ganganim bar dera. ");
INSERT INTO msy2020_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ezɨ atrivimɨn ingangarir gumaziba Sarain gari, a bar derazɨ, me ghua atrivim kamaghɨn a mɨgei, “Amizir bar dirir mam izegha iti.” Egha me ghua Sarai inigha atrivimɨn dɨpenimɨn ize. ");
INSERT INTO msy2020_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Ezɨ atrivim Sarain ganigha mɨghɨgha a gakongegha, kamaghɨn bar deravɨram Abram gami. Egha sipsipba, memeba, bulmakauba, donkin apuriba, donkin amebaba, kamelba, ingangarir gumaziba ko ingangarir amizir bar avɨriba, isa Abram ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Egha atrivim Abramɨn amuim Sarai inigha ua bagha an amuim gami, kamaghɨn Ikiavɨra Itir God Isipɨn atrivim ko an dɨpenimɨn itir darazi bagha arɨmariar guar avɨriba amangi. ");
INSERT INTO msy2020_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ezɨ atrivim Abramɨn diazɨma a izima a kamaghɨn a mɨgɨa ghaze, “Nɨ manmaghsua arazir kam na gami? Egha kamaghɨn na mɨkemezɨ puvatɨ, Sarai nɨn amuim. ");
INSERT INTO msy2020_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nɨ na mɨgɨa ghaze nɨn amizim, ezɨ kamaghɨn kɨ uan amuimɨn mɨn a ini. Nɨ manmaghsuavɨra arazir kam gami? Kamaghɨn nɨ uan amuim inigh, gua mangɨ!” ");
INSERT INTO msy2020_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ezɨ atrivim uan ingangarir gumazibav mɨkemezɨ, me Abram uan amuim ko, an biziba sara Isipɨn bar me batoke. ");
INSERT INTO msy2020_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Dughiar kamɨn Abram bizir bar avɨriba iti. A sipsipba, memeba, bulmakauba, gol ko silva bar avɨraseme. Egha a kantri Isip ategha Negevɨn danganimɨn amadaghan zui. A uan amuim ko uan biziba bar da inizɨ, Lot uaghan a ko zui. ");
INSERT INTO msy2020_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Egha gɨn Abram uan adarazi ko Negev ategha Notɨn amadaghan zui. Egha me purirpenibar ingara ghua Betelɨn nguibamɨn oto. Danganir kamra Abraham fomɨram purirpenibar ingara ofa gamir dakozimɨn ingari. A Betel ko Ain nguibamningɨn tizimɨn iti. A danganir kamɨn otogha Ikiavɨra Itir Godɨn ziam dɨbora a fe. ");
INSERT INTO msy2020_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ezɨ Lot uaghan Abram koma arua, sipsipba, memeba, bulmakauba ikia, uaghan ingangarir gumazamizir avɨriba a ko ikia purirpenibar iti. ");
INSERT INTO msy2020_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abram ko Lot uaghara bizir avɨriba iti, ezɨ kamaghɨn nguazim aningɨn sufi. Ezɨ aning uaning ko ikiava avenge. ");
INSERT INTO msy2020_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ezɨ adarim Abram ko Lotɨn sipsipba ko memebar garir ingangarir gumazibar tongɨn oto. Dughiar kam Kenanɨn adarazi ko Peresɨn adarazi danganir kamɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ezɨ Abram Lot mɨgei, “Ga ikɨzir vamɨra. Ga uaningɨn atari derazir puvatɨ, ezɨ gan ingangarir gumaziba uaghan uarir atari derazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Guizbangɨra, nguazir ekiam rughara iti. Ga uaning abɨgham. Egh nɨ uabɨ ua bagh danganitam ginabagh, na ategh an angɨ. Nɨ agharir guvimɨn mangɨtɨ, kɨ kɨriamɨn mangam. Maghsuegh nɨ agharir kɨriamɨn mangɨtɨ, kɨ guvimɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Ezɨ Lot tugha gari. Egha Jordanɨn Faner zarimɨn itir danganiba bar dar gara ghua Soarɨn nguibamɨn tu. Nguazir otevir kam dɨpar avɨriba ikia bar dera. Egha mati Ikiavɨra Itir Godɨn azenir bar aghuimɨn mɨn garava, uaghan kantri Isipɨn mɨn gari. Dughiar kam, Ikiavɨra Itir God tɨghar Sodomɨn nguibam ko Gomoran nguibam gasɨghasɨgham. ");
INSERT INTO msy2020_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ezɨ Lot nguazir otevir Jordanɨn Faner zarimɨn itiba bar ada iniasa mɨgei. Egha Abram ataghizɨma an aruem anadi naghɨn ghu. Egha aning uam uaning ko itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Egha Abram Kenanɨn nguazimɨn apera. Ezɨ Lot ghua nguibar ekiar Jordanɨn Faner zarimɨn itibar tongɨn apera. Egha Sodomɨn nguibar ekiam boroghɨn purirpenibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ezɨ nguibar ekiar kam Sodom, an gumazamiziba, men araziba bar ikufi. Ezɨ me Ikiavɨra Itir Godɨn damazimɨn arazir bar kurabagh ami. ");
INSERT INTO msy2020_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ezɨ Lot ghuzɨma, Ikiavɨra Itir God Abram mɨgɨa ghaze, “Nɨ kagh tugh egh danganir kaba bar dar gan. Nɨ aruem anadi naghɨn ganɨva aruem uaghiri naghɨn ganɨva, not ko saut vɨraram aningɨn gan. ");
INSERT INTO msy2020_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nguazir nɨ datɨrɨghɨn garir kaba bar, kɨ da isɨ nɨ ko nɨn ovavir boribar anɨngam. Eghtɨ nguazir kaba ia dar afeziaba ikegh mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Eghtɨ kɨ nɨn boribar amightɨ me nguazir mɨnemniamɨn mɨn bar avɨrasemegham. Eghtɨ gumazitam nguazir mɨnemniaba mengeghɨva nɨn ovavir boriba mengam. ");
INSERT INTO msy2020_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kɨ nguazir kaba bar da isa nɨ ganɨdi. Kamaghɨn, nɨ datɨrɨghɨn dɨkavigh mangɨ nguazir kaba bar dar ganigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kamaghɨn, Abram danganir kam ategha ghua Hebronɨn nguibam boroghɨn oto. Egha a Mamren temer ekiabar boroghɨn, purirpenibar ingarigha, me kagh apia. Egha Ikiavɨra Itir God bagha ofa gamir dakozim, danganir kamɨn an ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","9","Dughiar kamɨn, Kedorlaomer Elamɨn nguibamɨn atrivimɨn ikia egha uaghan nguibar kaba ko dar atrivibar gari. Bera a Sodomɨn nguibar ekiamɨn atrivimɨn iti, Birsa a Gomoran nguibar ekiamɨn atrivimɨn iti, Sinap an Atman nguibar ekiamɨn atrivimɨn iti, Semeber an Seboimɨn nguibar ekiamɨn atrivimɨn iti, ezɨ Belan nguibam uaghan an apengan iti. Ezɨ Belan ziar mam Soar. A 12plan azenibar me gativagha men gari, ezɨ namba 13ɨn azenimɨn me Kedorlaomerɨn akam batoke. Ezɨ namba 14ɨn azenimɨn Kedorlaomer uan namakar 3plan dia: Amrafel a Babilonɨn kantrin atrivim, Ariok a Elasarɨn kantrin atrivim, Tidal a Goimɨn adarazir atrivim. Egha me 4plan atrivir kaba, uan mɨdorozir gumaziba ko ghua Asterot Karnaimɨn nguibamɨn otogha, Refaimɨn adarazi ko uariv sogha me abɨra. Egha me Hamɨn nguibar ekiamɨn otogha Susia ko mɨsogha me abɨra. Egha me Kiriataimɨn boroghɨn danganir zarimɨn otogha Emia ko mɨsogha me abɨra. Egha me ghua Seirɨn Mɨghsɨabar otogha, Horia ko mɨsogha men agɨntɨgha ghua El Paranɨn nguibar mɨriamɨn gumazamiziba puvatɨzir danganimɨn me ataki. Egha gɨn uamategha iza Kadesɨn nguibar ekiamɨn otifi. Kadesɨn ziar ghurim, En Mispat. Me Amalekian nguazim gisɨn me ko mɨsogha me abɨni. Egha me Hasason Tamarɨn nguibar ekiamɨn otivigha Amoria, ko mɨsogha me abɨni. Egha me mɨdorozir kam gamigha me abɨnigha gɨvagha, Kedorlaomer uan namakar 3pla ko ghua 5plan nguibar kabar atriviba ko mɨsosi, Sodom, Gomora, Atma, Seboim ko Bela. Ezɨ 5plan atrivir kaba, uan mɨdorozir gumaziba ko me Sidimɨn danganir zarimɨn uari akuvagha iti. Egha me Kedorlaomer ko an namakar 3pla ko mɨsoghasa uari akɨri. Ezɨ 5plan atrivir kabanangɨn mɨdorozir gumaziba 4plan atrivibar mɨdorozir gumaziba ko uariv sosi. ");
INSERT INTO msy2020_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ezɨ Sidimɨn danganir zarim koltaba iniamin torir avɨriba iti. Ezɨ Sodomɨn atrivim ko Gomoran atrivim mɨdorozimɨn arasava amua puvatɨ, aning koltan torimning giraghu. Ezɨ atrivir 3plan igharaziba ara ghua mɨghsɨabar ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ezɨ Kedorlaomer mɨdorozim gamua me abɨra. Egha me Sodom ko Gomoran itir biziba bar ada inigha egha men dagheba sara inigha ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ezɨ Lot, Abramɨn dozimɨn otarim, a Sodomɨn itima, me uaghan a inigha an biziba sara inigha ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ezɨ gumazir mam mɨdorozimɨn ara ghua Hibrun gumazim Abram batogha mɨdorozimɨn otivizir biziba bar a geghani. Dughiar kam, Abram Mamren temer ekiabar boroghɨn ikiavɨra iti. Mamre, a Amorian adarazir gumazir mam, a dozir pumuning iti, Eskol ko Aner. Gumazir 3plan kaba, kar Abramɨn namakaba. ");
INSERT INTO msy2020_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ezɨ Abram orazi, apaniba an dozimɨn otarim Lot inigha ghu. Ezɨ kamaghɨn a ko iti darasi, a men mɨdorozir gumazir bar gavgavibar dia, ezɨ men dɨbobonim 318ɨn tu. Ezɨ me 4plan atrivir kabar gɨn ghua Danɨn nguibar ekiamɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Egha danganir kamɨn Abram uan mɨdorozir gumaziba tuira. Egha 4plan atrivir kaba ko dɨmagarimɨn mɨsogha me abɨni. Egha notɨn amadaghan Damaskusɨn nguibar ekiamɨn men agɨragha ghua, Hoban nguibar ekiamɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Egha atrivir kaba inigha ghuezir biziba ua bar ada ini. Egha Abram uan dozimɨn otarim Lot uam a inigha, bar an biziba ko amiziba ko gumazamizir igharaziba inigha uamategha ize. ");
INSERT INTO msy2020_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ezɨ Abram, Kedorlaomer uan namakaba ko, me mɨsogha me abɨni. Egha a uamategha izima, Sodomɨn atrivim ghua danganir zarir me kamagh dɨborim, “Save,” an a bato. Ezɨ an ziar mam kamakɨn: Atrivibar Danganir Zarimra. ");
INSERT INTO msy2020_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ezɨ Melkisedek, a Salemɨn nguibamɨn atrivim, a Godɨn Bar Pɨn Itimɨn Ofa Gamir Gumazim, a bret ko wain inigha Abram bagha izi. ");
INSERT INTO msy2020_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Egha bizir bar aghuimɨn Abram gamua kamaghɨn mɨgɨa ghaze, “Godɨn Bar Pɨn Itim overiam ko nguazimɨn ingari, a bar deragh nɨ damu. ");
INSERT INTO msy2020_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Guizbangɨra, nɨ apaniba ko uariv sozi, Godɨn Bar Pɨn Itim nɨn akurazɨ, nɨ me abɨni, kamaghɨn, e an ziam fam.” Ezɨ bizir Abram iniziba bar, a 10plan akuabar da abigha 10ɨn vamɨra isa Melkisedek ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ezɨ gɨn Sodomɨn atrivim kamagh Abram mɨgei, “Nɨ mɨdorozimɨn inizir biziba nɨ bar adar suikigh. Egh nan gumazamizibara ua me ateghtɨ, me na bagh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ezɨ Abram ghaze, “Ikiavɨra Itir God, Godɨn Bar Pɨn Itim, overiam ko nguazimɨn ingarizim, kɨ an ziamɨn pamten kamagh mɨkɨmasa, ");
INSERT INTO msy2020_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kɨ tong bar nɨn bizir muziaritam inighan kogham, iniba isair tretba o dagarir asuabar beniba. Eghtɨ nɨ kamaghɨn mɨkɨman kogham, ‘Kɨ uabɨ Abram gamizɨ a bizir bar avɨrim iti.’ ");
INSERT INTO msy2020_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kɨ uabɨ kɨ bizitam inian kogham. Bizir nan mɨdorozir gumaziba ameziba kɨ darara iniam. Eghtɨ nan namakar 3pla, Aner, Eskol ko Mamre, me uari bagh naba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ezɨ bizir kabar gɨn, Ikiavɨra Itir God irebamɨn mɨn bizimɨn aven akam isa Abram ganɨga egha ghaze: “Abram nɨ atiatingan markɨ. Kɨ nɨn oramɨn mɨn ikiam, eghtɨ nɨ nan apazangɨn deravɨra ikiam. Eghtɨ kɨ nɨ damightɨ nɨn ziam bar pɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ezɨ Abram an akam ikaragha ghaze, “O Ikiavɨra Itir God, nan Ekiam, kɨ uabɨ boriba puvatɨ, nɨ manmaghɨn na damightɨ kɨ ziar ekiam iniam? Kɨ oveghtɨ nan biziba iniamin gumazim an ziam Elieser, a Damaskusian gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nɨ boritam na ganɨngizir puvatɨ, ezɨ nan dɨpenimɨn otozir ingangarir gumazir kam, a nan danganim inigh nan biziba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ezɨ Ikiavɨra Itir God Abram kamagh a mɨgɨa ghaze, “Ingangarir gumazir kam nɨn biziba inian kogham. Nɨn borir nɨn otoghamɨra nɨn danganim inigh, egh nɨn biziba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Egha Ikiavɨra Itir God Abram inigha azenan ghua a mɨgɨa ghaze, “Nɨ kogh overiamɨn mɨkovezibar gan. Nɨ bar da mengam? Ti puvatɨ. Guizbangɨra, nɨn ovavir boriba bar avɨrasemegh mɨkovezibar dɨbobonimɨn mɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ezɨ Abram nɨghnɨzir gavgavim Ikiavɨra Itir Godɨn itima an a dɨbora ghaze, a nan damazimɨn dera. ");
INSERT INTO msy2020_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Egha ana mɨgɨa ghaze, “Kɨrara kɨ Ikiavɨra Itir God. Nɨ Kaldian danganimɨn itir nguibam Urɨn itima, kɨ nɨn diagha nɨ inigha iza nguazir kam nɨ ganɨngi, eghtɨ nɨ an afeziamɨn ikegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ezɨ Abram ghaze, “O Ikiavɨra Itir God, nan Ekiam, kɨ manmagh fogh suam, kɨ nguazir kam guizbangɨra a iniam?” ");
INSERT INTO msy2020_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ezɨ Ikiavɨra Itir God ghaze, “Nɨ bizir kaba inigh izɨ na danɨngigh: bulmakaun amebar azenir 3pla itim ko, memen amebar azenir 3pla itim ko, sipsipɨn apurir vamɨran azenir 3pla itim ko, kuarazir muziarir me bunbam arɨzir pumuning, nɨ bar da inigh na bagh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ezɨ Abram bizir kaba bar ada inigha Ikiavɨra Itir God bagha izi. Egha asɨzir kaba vaghvagha da abɨagharɨgha akuar pumuningɨn dagh ami, egha dar akuabar bɨzir pumuningɨn dar bora da arɨki. Egha kuarazimning rughɨrama aning atɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ezɨ kuarazir isar maba izaghira asɨzir kabar amasava amima, Abram men agɨra. ");
INSERT INTO msy2020_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ezɨ aruem bar uaghirima Abram bar akuava ongani. Egha garima mɨtater ekiam anevarazɨma a bar atiatingi. ");
INSERT INTO msy2020_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ezɨ Ikiavɨra Itir God kamagh Abram mɨgɨa ghaze, “Nɨ bizir kam gɨfogh, nɨn ovavir boriba mangɨ kantrin igharazimɨn aven nguibar igharazimɨn gumazamizibar mɨn ikiam. Egh pura men ingangarir gumazibar mɨn ikiam. Eghtɨ kantrin kamɨn gumazamiziba 400plan azenibar pazɨ me damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Eghtɨ kɨ osɨmtɨzir ekiam isɨ kamagh pazɨ me damuamin gumazibar anɨngam. Eghtɨ nɨn ovavir boriba bizir bar avɨrim inigh egh kantrin kam ategh azenan izam. ");
INSERT INTO msy2020_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Eghtɨ nɨ uabɨ bar navir amɨrizimɨn ikɨ mangɨ aseghɨva aremegham, eghtɨ me nɨ afagham. ");
INSERT INTO msy2020_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Eghtɨ nɨn ovavir boriba ua zuamɨra nguazir kamɨn izeghan kogham. Nɨn adarazi mangɨ namba 4ɨn ovavir boriba otivigh egh uamategh nguazir kamɨn izam. Ezɨ Amorɨn iti darazi datɨrɨghɨn arazir kurar avɨritabagh amir puvatɨ. Me gɨn arazir kuratabar amutɨ, kɨ mɨzazim me gasegh egh nguazir kamɨn me batuegham. Eghtɨ nɨn ovavir boriba uamategh izam.” ");
INSERT INTO msy2020_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ezɨ aruem uaghirima mɨtatem otogha gɨfa, ezɨ bizir pumuning oto: nguazir mɨner avim isim ko adenir avim. Ezɨ avivgharim mɨner kamɨn anagava otifi. Ezɨ bizir kamning, asɨzir Abram akuar pumuningɨn bɨagharigha bɨzimɨn arɨghizir kabar tongɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ezɨ dughiar kamra Ikiavɨra Itir God Akar Dɨkɨrɨzir Gavgavim Abram koma a gamua ghaze, “Kɨ nguazir kaba isɨ nɨn ovavir boribar anɨngam. Eghtɨ men nguazimɨn mɨtaghniam Isipɨn kantrin dɨpar mɨriamɨn ikegh mangɨ Yufretisɨn Faner ekiamɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Eghtɨ me Kinian nguazim, Kenasian nguazim, Katmonian nguazim ko, ");
INSERT INTO msy2020_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitian nguazim, Peresian nguazim Refaimian nguazim ko, ");
INSERT INTO msy2020_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorian nguazim, Kenanian nguazim, Girgasian nguazim ko, Jebusian nguazim, me bar men nguazir kaba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ezɨ dughiar kamɨn Abramɨn amuim Sarai, a boriba puvatɨ. Ezɨ Isipɨn kantrin amizir mam a ko iti. A Sarain ingangarir amizim, an ziam Hagar. ");
INSERT INTO msy2020_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ezɨ Sarai Abram mɨgɨa ghaze, “Nɨ orakigh, Ikiavɨra Itir God boritam batan nan anogoroke, ezɨ kɨ boritam batan kogham. Ezɨ kɨ nɨn azangsɨsi nɨ mangɨ nan ingangarir amizim ko dakuightɨ, a ti na bagh boritam batam.” Ezɨ Abram Sarain nɨghnɨzim mɨrara ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ezɨ Sarai uan ingangarir amizim Hagar isa Abramɨn amuimɨn mɨn a ganɨngi. Dughiar kamɨn Abram Kenanɨn nguazimɨn itima 10plan azeniba gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ezɨ Abram Hagar koma akuizɨ, Hagar navim asangi. Dughiar kamɨn Hagar uabɨra uabɨ gɨfo a navim asangi, egha uabɨ pɨrafa Sarain akaba barazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ezɨ Sarai kamagh Abram mɨgei, “Hagar nan akaba barazir puvatɨ, kar nɨn osɨmtɨzimra. Guizbangɨra kɨ uabɨ a isa nɨn amuimɨn mɨn nɨ ganɨngi. Ezɨ datɨrɨghɨn a uabɨ gɨfo a navim asangi, egha uabɨ pɨrafa, egha nan akaba barazir puvatɨ. Ezɨ Ikiavɨra Itir God uabɨ nɨ Abram, ko nan mɨgɨrɨgɨaba tuisɨghasa kɨ ifonge.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ezɨ Abram kamaghɨn Sarain akam ikaragha ghaze, “Nɨ oragh Hagar pura nɨn ingangarir amizir kɨnim. Nɨ a gativazɨ, a pura nɨn apengan iti. Nɨghnɨzir manam nɨ a damusɨ, puram a damu.” Ezɨ Sarai Hagarɨn apanimɨn ikia arazir kurabar a gami, ezɨ Hagar arav ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Egha a gumazamiziba puvatɨzir danganimɨn ghua, egha Surɨn nguibamɨn zuir tuavimɨn itir dɨpar atuimɨn otogha avughsi, ezɨ Ikiavɨra Itir Godɨn enselɨn mam a bato. ");
INSERT INTO msy2020_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Egha ensel kamaghɨn a mɨgei, “Hagar, Sarain ingangarir amizim. Nɨ managh ikegha izi, egha managhɨra zui?” Ezɨ Hagar a ikaragha ghaze, “Kɨ Sarai ategha an ari.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ezɨ ensel a mɨgɨa ghaze, “Nɨ uamategh Sarai bagh mangɨ egh an akaba baragh.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Egha ensel ua kamagh a mɨgɨa ghaze, “Kɨ nɨn ovavir boribar amightɨ me bar avɨrasemegham, eghtɨ gumazitam men dɨbobonim mengɨva avegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Egha Ikiavɨra Itir Godɨn ensel ua mɨgei: “Nɨ orakigh. Nɨ borim batamin dughiam, a roghɨra izi. Guizbangɨra, nɨ osɨmtɨzim iti, ezɨ Ikiavɨra Itir God nɨn osɨmtɨzim baraki. Kamaghɨn, nɨ otarim bategh ziam Ismael a datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Eghtɨ nɨn otarim, donkin atiamɨn mɨn ikiam. A gumazamiziba bar, me ko mɨsoghtɨ me an apanim damuam. Egh a uan adarazi ko deragh daperaghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ezɨ gɨn Hagar kamaghɨn nɨghnɨsi, “Ame! Guizbangɨra, kar Ikiavɨra Itir God, a uan akam na ganɨngi. Ezɨ Godɨn nan garim, kɨ uabɨ an ganigha egha angamɨra ikiavɨra iti!” Kamaghɨn a ziar kam Ikiavɨra Itir God ganɨngi, “Biziba Bar Dar Garir God.” ");
INSERT INTO msy2020_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ezɨ bizir kam bagha gumazamiziba mozir dɨpar kam dɨbora ghaze, “Godɨn Zurara Ikia Nan Garim.” Mozir dɨpar kam Kadesɨn nguibam ko Beretɨn nguibamɨn tizimɨn ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ezɨ Hagar Abramɨn otarim batezɨ, Abram ziam, “Ismael,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ezɨ Hagar Ismael batamin dughiam, Abram 86plan azeniba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ezɨ Abram gɨn azenir 99pla anetuzɨma, Ikiavɨra Itir God a batogha a mɨgɨa ghaze, “Kɨ Gavgaviba Bar Itir God. Nɨ zurara nan akam baragh, nan apengan ikɨva nan damazimɨn deragh arazir aghuibar amu. ");
INSERT INTO msy2020_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kɨ uan Akar Dɨkɨrɨzir Gavgavim nɨ koma a damu, egh ovavir borir bar avɨrim nɨ danɨngam, eghtɨ me bar avɨrasemegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ezɨ Abram ua tevimning apɨrigha guam nguazim girɨzɨ, God a mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nɨ oragh. Kɨ nɨ ko Akar Dɨkɨrɨzir Gavgavir kam gamigha kamaghɨn mɨgei. Nɨ kantrin bar avɨrimɨn gumazamizibar ovavimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Eghtɨ nɨn ziam datɨrɨghɨn uam Abram puvatɨgham. Guizbangɨra, kɨ nɨ damightɨ, nɨ kantrin avɨribar gumazamizibar ovavimɨn otogham. Ezɨ kamaghɨn, datɨrɨghɨn nɨn ziam, Abraham. ");
INSERT INTO msy2020_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Eghtɨ kɨ nɨn ovavir boribar amightɨ me bar avɨrasemegh mangɨ kantrin gavgavitabar otivam. Egh men tarazi atrivibar otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Egh kɨ nɨ ko nɨn ovavir borir gɨn otivamiba ko Akar Dɨkɨrɨzir Gavgavim akɨram. Eghtɨ Akar Dɨkɨrɨzir Gavgavir kam gavgavigh mamaghɨra ikiam. Akar Dɨkɨrɨzir Gavgavir kam kamakɨn, kɨ nɨn God, egha nɨn ovavir boriba uaghan, kɨ men God. ");
INSERT INTO msy2020_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ezɨ Kenanɨn nguazir nɨ datɨrɨghɨn puram aperaghav itir kam, kar igharaz darazir nguazim. Eghtɨ kɨ nɨ ko nɨn ovavir borir gɨn otivamiba, kɨ Kenanɨn nguaziba bar da isɨ, ia danɨngam. Eghtɨ nguazir kam, a ian nguazimɨn ikɨ mamaghɨra ikiam. Eghtɨ kɨ nɨn ovavir boribar Godɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ezɨ God Abraham mɨgɨa ghaze, “Nɨ ko nɨn ovavir borir gɨn izamiba, ia bar nan Akar Dɨkɨrɨzir Gavgavimɨn gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Egh ia nan Akar Dɨkɨrɨzir Gavgavimɨn gɨn mangɨsɨ arazir kam damu. Ia uan adarazir tongɨn uan gumazibar mɨkarzir mogomebar iniba bar dar ghoregh. ");
INSERT INTO msy2020_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Ian otarir iririviba 8plan dughiaba otoghtɨ ia dughiar kamra me mɨkarzir mogomebar iniba aghoregh. Egh ia uan ingangarir gumazibar mɨkarzir mogomeba uaghan dar ghoregh, egh ian ingangarir amiziba otezir otariba, ko ia igharaz darazi da ivezezir ingarir gumaziba ia uaghan dar aghoregh. Ian gumaziba ko otariba bar kamaghɨn damuvɨra ikiam. Eghtɨ arazir kam, a nan ababanimɨn mɨn ikiam, egh a ian akagh suam, kɨ ia ko Akar Dɨkɨrɨzir Gavgavir kam gami. ");
INSERT INTO msy2020_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ia uan gumazibar mɨkarzir mogomeba bar dar ghoregh. Eghtɨ dɨghorezir arazir kamɨn duar kurim ian mɨkarzibar ikɨtɨ, gumazamiziba bar fogh suam, Akar Dɨkɨrɨzir Gavgavir kɨ ia ko amizir kam a zurara ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Egh me tavɨn mɨkarzir mogomemɨn inim atughan koghtɨ, gumazir kam kɨ ia koma amizir Akar Dɨkɨrɨzir Gavgavir kam abɨki. Eghtɨ me a batueghtɨ, a uan adarazir aven ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Egha God Abraham mɨgɨa ghaze, “Datɨrɨghɨn ikegh mangɨ nɨ uam uan amuim ziam Sarai, a darɨghan markɨ. Datɨrɨkɨn, an ziam Sara. ");
INSERT INTO msy2020_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kɨ deragh Sara damutɨ, a nɨ bagh otarim batam. Kɨ Sara deragh a damutɨ, a kantrin avɨribar gumazamizibar inaghamimɨn otivam, eghtɨ men tarazi atrivibar ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Ezɨ Abraham tevimning apɨrigha guam nguazim girɨ. Egha averara uan nɨghnɨzimɨn kamagh aka ghaze, “Gumazir azenir 100pla itim ti boritam afangam? Ezɨ Sara azenir 90pla iti, a ti boritam batam?” ");
INSERT INTO msy2020_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Egha Abraham God mɨgɨa ghaze, “Kamaghɨn deragham, nɨ Ismaelrama eghuva deragh an gan.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ezɨ God ghaze, “Nɨ mamagh mɨkɨman markɨ. Nɨn amuim Sara navim asegh egh otaritam bateghtɨ, nɨ ziam Aisak a datɨgh. Eghtɨ kɨ Akar Dɨkɨrɨzir Gavgavim a ko an ovavir borir gɨn otivamiba koma a damuam. Eghtɨ Akar Dɨkɨrɨzir Gavgavir kam zurara ikɨ mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ezɨ kɨ Ismael deragh an ganasa nɨ nan azangsɨsi. Kɨ deragh a damu, egh borir avɨriba a danɨngam, egh an boribar amightɨ me bar avɨrasemegham. Egh a 12plan gumazir dapanir kabar afeziamɨn otogham. Eghtɨ kɨ an adarazir amightɨ me ikɨzir gavgavimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Eghtɨ kɨ uan Akar Dɨkɨrɨzir Gavgavim Aisak ko a damuam, borir Sara dughiar kamran azenir munamɨn otamim.” ");
INSERT INTO msy2020_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Egha God akar kam gamigha gɨvagha Abraham ategha ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ezɨ dughiar kamra, Abraham Godɨn akamɨn gɨn ghua, uan adarazir gumazibar mɨkarzir mogomebar iniba bar ada aghore. Egha uan otarim Ismaelɨn mɨkarzir mogomemɨn inim aghora, egha ingangarir gumazir kɨnir men amebaba Abrahamɨn dɨpenimɨn otezibar mɨkarzir mogomebar inibar aghora, egha ingangarir gumazir a igharaz darazi dam ivesezibar mɨkarzir mogomebar inibar aghore. ");
INSERT INTO msy2020_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Dughiar kam Abraham uabɨ 99pla azeniba gɨfa, ezɨ an otarim Ismael 13pla azeniba itima, me aningɨn mɨkarzir mogomemning inimning atu. ");
INSERT INTO msy2020_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Dughiar God akam Abraham ganɨngizimra, Abraham uan otarim Ismael ko, me aningɨn mɨkarzir mogomemningɨn inimning atu. ");
INSERT INTO msy2020_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Egha uaghan Abrahamɨn dɨpenimɨn aven itir gumaziba bar, ingangarir gumaziba ko, gumazir me Kantrin Igharazibar Gumazamiziba da ivezeziba sara, me bar men mɨkarzir mogomebar iniba aghore. ");
INSERT INTO msy2020_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Egha gɨn Ikiavɨra Itir God Mamren nguibamɨn temer ekiabar apengan Abraham bato. Aruer mamɨn aruem bar puvɨra isima, Abraham uan purirpenimɨn tiar akamɨn aperaghav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Egha a kogha gumazir 3plan gari me tuivighav iti. A men ganigha uan purirpenim ategha zuamɨra ivegha me bagha ghu. Egha tevimning apɨrigha aviragha guam nguazim girɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Egha kamaghɨn mɨgei, “O nan gumazir ekiam, kɨ ian ingangarir gumazim. Ia nan dɨpenimɨn izasa kɨ bar ifonge. Ia nan dɨpenim gitagh pura mangan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kɨ tav mɨkemeghtɨ a dɨpatam inigh izɨtɨ, ia uan dagariba ruegham. Eghtɨ ia temer ekiar kamɨn povimɨn avughsam. ");
INSERT INTO msy2020_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Eghtɨ kɨ dagheba ia danightɨ ia gavgavim uari danigh egh ua mangɨ. Kɨrara, ian ingangarir gumazim, ia nan dɨpenimɨn izezɨ, kɨ ian akurvaghasa.” Ezɨ me kamaghɨn mɨgei, “A dera, nɨ mɨgei moghɨn damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ezɨ Abraham zuamɨra purirpenimɨn aven ghua kamagh Sara mɨgei, “Nɨ plauan beghɨn ekiar aghuitam inigh egh zuamɨram a giragh bretba tuegh.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Egha Abraham uan bulmakauba bagha ivegha ghua mɨkarzim sara itir mam inigha ize. Egha a isa uan ingangarir gumazim ganɨngizɨ a zuamɨrama a mɨsuegha aneghoregha a isami. ");
INSERT INTO msy2020_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ezɨ asɨzim isigha gɨvazɨma, Abraham asɨzir kam ko, bulmakaun otereborɨm ko, bulmakaun otereborɨmɨn ingarizir sis sara inigha ghua gumazir 3plan kabar afa. A me ganɨngizɨ me da apima, a men boroghɨn tememɨn apengan tughav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Egha me amegha gɨvagha, Abrahamɨn azara, “Nɨn amuim Sara, a managh iti?” Ezɨ Abraham ghaze, “A purirpenimɨn aven iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ezɨ men mav, a uabɨ Ikiavɨra Itir God, a kamaghɨn mɨgei, “Azenir gɨrakɨrangɨn itimɨn iakɨnir kamran kɨ uamategham, eghtɨ nɨn amuim Sara otaritam ikiam.” Ezɨ Sara purirpenimɨn tiar akamra ikia gumazir kamɨn akɨrangɨn, ikia akar kam baraki. ");
INSERT INTO msy2020_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Dughiar kam Abraham ko Sara vɨrara ghurigha gɨfa. Ezɨ Saran dughiar a boritam batamim, a gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Egha a uabɨra uabɨn ingarava ati. Egha uabɨra uabɨ mɨgɨa ghaze, “Kɨ ghurigha gɨfa, ezɨ nan mɨkarzim apunapuni. Ezɨ nan gumazir ekiam uaghan ghuri. Kɨ manmaghɨn boritam iniamin agoroger kam ikiam?” ");
INSERT INTO msy2020_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ezɨ Ikiavɨra Itir God kamaghɨn Abrahamɨn azara, “Sara manmaghsua aka ghaze, kɨ ghurigha gɨfa, egh ua boritam batamin tuaviba puvatɨ? ");
INSERT INTO msy2020_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Abraham, nɨ orakigh, Ikiavɨra Itir God bizitam damusɨ iburaghan kogham. Azenir munamɨn iakɨnir kamran, dughiar kɨ dɨborozimɨn kɨ uamategham. Eghtɨ dughiar kamra Sara otarim ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ezɨ Sara atiatigha ifara ghaze, “Kɨ akezir puvatɨ.” Ezɨ a ghaze, “Nɨ guizbangɨram ake.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ezɨ gumazir kaba dɨkavigha zui. Ezɨ Abraham dɨkavigha mangamin tuavimɨn men akaghasa. Egha me ghua danganir mamɨn tuivigha, gara uaghira Sodomɨn nguibamɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ezɨ Ikiavɨra Itir God kamaghɨn nɨghnɨsi, “Bizir kɨ damuamin kam, kɨ Abrahamɨn ghuangsɨghan aghua. ");
INSERT INTO msy2020_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Guizbangɨra, an ovavir boriba bar avɨrasemegh kantrin gavgavimɨn otogham. Eghtɨ Abraham bangɨn kɨ nguazir kamɨn itir ikɨziba bar dar gumazamiziba bar deragh me damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kɨ kamaghɨn ifonge, Abraham uan boriba ko uan ovavir boribar sure damightɨ me Ikiavɨra Itir Godɨn akamɨn gɨn mangam. Egh me arazir aghuiba ko arazir nan damazimɨn derazibara darara gɨn mangam. Kamaghɨn, kɨ ua bagha Abraham ginaba. Egh gɨn kɨ uan akar dɨkɨrɨzimɨn gɨn mangɨ, Abraham deravɨram a damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Egha Ikiavɨra Itir God Abraham mɨgɨa ghaze, “Arazir bar kurar Sodom ko Gomoran otivibar eghaghanir bar avɨriba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kamaghɨn kɨ magɨrɨ gumazir arazir kabagh amibar ganigham. Egh kɨ fogham, eghaghanir kɨ oregha fogha gɨvazir kaba, da ti guizbangɨra, o puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Egha gɨn gumazir pumuning dɨkavigha Sodomɨn ghu. Ezɨ Ikiavɨra Itir God Abraham ko tughav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ezɨ Abraham sɨvagha an boroghɨn ghua an azara, “Nɨ ti gumazir aghuiba ko kuraba sarama asɨghasɨgham? ");
INSERT INTO msy2020_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ti 50pla gumazir aghuiba nguibar kamɨn ikɨtɨ, nɨ igharaziba sara me gasɨghasɨgham? Nɨ ti 50plan gumazir aghuir kabagh nɨghnigh nguibar kam ateghtɨ a ikɨtɨ, nɨ a gasɨghasɨghan kogham? ");
INSERT INTO msy2020_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nɨ gumazir aghuiba ko kuraba sarama asɨghasɨgham, kar arazir aghuim puvatɨ. Nɨ gumazir aghuiba ko kuraba, arazir vamɨran me damuan markɨ. Nɨ nguaziba bar dar garir Jas, egh nɨ arazir aghuibara damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ezɨ Ikiavɨra Itir God kamaghɨn an akam ikaragha ghaze, “Kɨ Sodomɨn nguibamɨn itir gumazir aghuir 50plan gantɨ me ikɨtɨ, kɨ gumazamiziba bar me ateghtɨ me ikiam. Eghtɨ gumazir aghuir kaba, me ovengan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ezɨ Abraham ua kamaghɨn mɨgei, “Ekiam, kɨ bizir avɨribav kɨmtɨ, nɨ nan ataran markɨ. Kɨ pura gumazir kɨnim, egh bizitam mɨkɨman kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Eghtɨ gumazir aghuir 50pla puvatɨghtɨ, 45plara ikɨtɨ, nɨ nguibam bar a gasɨghasɨgham, o puvatɨgham?” Ezɨ Ekiam ghaze, “Kɨ 45plan gumazir aghuibar ganigh egh nguibam gasɨghasɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ezɨ Abraham ua mɨgei, “Eghtɨ gumazir aghuir 40pla ikɨtɨ manmaghɨn damuam?” Ezɨ Ekiam ghaze, “Kɨ gumazir aghuir 40plan ganigh egh nguibam gasɨghasighan kogham, eghtɨ gumazir aghuir kaba ovengan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ezɨ Abraham kamaghɨn mɨgei, “Ekiam, kɨ ua bizitam mɨkɨmasa. Nɨ ataran markɨ. Eghtɨ 30pla ikɨtɨ manmakɨn?” Ezɨ Ekiam kamaghɨn mɨgɨa ghaze, “Kɨ 30plan gumazir aghuibar ganigh egh nguibam gasɨghasighan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ezɨ Abraham ua ghaze, “Ekiam, nɨ nan mɨgɨrɨgɨar avɨrir kaba bagh nan ataran markɨ. Eghtɨ gumazir aghuir 20pla ikɨtɨ manmakɨn?” Ezɨ Ekiam ghaze, “Kɨ gumazir aghuir 20plan ganigh, egh kɨ nguibam gasɨghasighan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ezɨ Abraham ua ghaze, “Ekiam, kɨ akatam ua nɨ mɨkɨmasa. Nɨ nan ataran markɨ. Eghtɨ gumazir aghuir 10pla ikɨtɨ, manmakɨn?” Ezɨ Ekiam ghaze, “Kɨ gumazir aghuir 10plan ganigh egh nguibam gasɨghasighan kogham. Eghtɨ gumazir aghuir kaba ovengan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ezɨ Ikiavɨra Itir God Abraham ko uaning mɨkemegha gɨvagha ghu. Ezɨ Abraham uamategha uan dɨpenimɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ezɨ Lot guaratɨghɨn Sodomɨn nguibamɨn uari akuvir tiar akamɨn aperaghav iti. Ezɨ enselɨn Ikiavɨra Itir God ko ghua Abrahamɨn ganizimning, datɨrɨghɨn iza Sodomɨn nguibam oto. Ezɨ Lot aningɨn garima aning izima a dɨkavigha aning bagha zui. Egha tevimning apɨrigha aviragha guam nguazim girɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Egha ghaze, “Gumazir Ekiamning, kɨ guan ingangarir gumazim, ezɨ gua nan dɨpenimɨn izi. Gua uan dagariba faragh da ruegh, egh dɨmangan nan dɨpenim daku. Egh amɨnim tiraghtɨ gua dɨkavigh mangɨ.” Ezɨ aning an akam ikaragha ghaze, “Puvatɨ. Ga me uari akuvir danganir kam dakuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ezɨ Lot mɨghɨghavɨra aning mɨgeima, aning gɨn a ko dɨpenimɨn ghu. Ezɨ Lot uan ingangarir gumazibav kemezɨma me bretɨn yis puvatɨziba tuegha aning bagha dagher aghuibagh ami. Ezɨ aning api. ");
INSERT INTO msy2020_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ezɨ aning tɨghar mɨsiabar mangasava amima, Sodomɨn gumaziba iza dɨpenim avɨni. Nguibamɨn itir gumazir igiaba ko ghuriba bar moghɨra izi. ");
INSERT INTO msy2020_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Egha me Lotɨn dɨa ghaze, “Gumazir iza nɨn dɨpenim gakuimning mana? Aning amadaghtɨ aning azenan izɨtɨ, e poroghamiba uari ko akuava amir arazir kurabar aning damuasa.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ezɨ Lot azenan ghua tiam deragha anesara. ");
INSERT INTO msy2020_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Egha me mɨgɨa ghaze, “Nan aveghbuaba, ia oragh. Ia arazir kurar kam damuan markɨ! ");
INSERT INTO msy2020_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kɨ guivir pumuning iti, aning gumazitam koma akuizir puvatɨ. Kɨ aning inigh egh ia bagh azenan izam, eghtɨ ia uan ifongiam aningɨn anegɨfagh. Eghtɨ gumazir nan dɨpenim gakuimning kɨ deragh aningɨn ganam. Kamaghɨn ia arazir kuratam bar aning damuan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ezɨ Sodomia mɨgɨrɨgɨar kam baregha ghaze, “Gumazir kam, a nguibar igharazimɨn gumazim, egha a en araziba tuisɨghasava ami. Nɨ e gitagh. Nɨ e gitaghan koghtɨ, e arazir kurabar aning damuam. Egh e uaghan mɨzazitam nɨ gaseghtɨ nɨ fogham, nɨn mɨzazim, aningɨn mɨzazim gafiragham.” Egha me ua Lotɨn suiragha a munasaragha egha tiam akarasa. ");
INSERT INTO msy2020_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ezɨ gumazir dɨpenimɨn aven itimning dafarim azenan anemadagha Lotɨn suiragha, uam a inigha aven izegha tiam asara. ");
INSERT INTO msy2020_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Egha aning azenan itir gumazibagh amizɨ, men damaziba pɨrizɨma, me ua dɨpenimɨn tiar akamɨn garir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ezɨ gumazir kamning kamagh Lotɨn azara, “Nɨn tarazi uam nguibar kamɨn aven iti? Nɨ uan boriba ko uan amereba ko nɨn adarazi kagh iti, nɨ bar me inigh egh nguibar kam atakigh. ");
INSERT INTO msy2020_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ga nguibar kam gasɨghasigham. Nguibar kamɨn aven, bar eghaghanir bar kurar igharagha gariba otivizɨ, Ikiavɨra Itir God da baregha gɨfa. Kamaghɨn, a ga amadazɨma ga nguibar kam gasɨghasɨghasa izi.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ezɨ Lot gumazir an guivimningɨn ikiasa me inabazimning bagha ghu. Egha aning mɨgɨa ghaze, “Ikiavɨra Itir God nguibar kam kuvarɨmasa, kamaghɨn gua dɨkavigh nguibar kam bemɨram anetakigh.” Ezɨ aning ghaze, a ti pura ikarara mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ezɨ amɨnim tiragha gɨvazɨ enselning Lotɨn avɨgha ghaze, “Atamra. Nɨ uan amuim ko guivimning inigh, egh nguibar kam atakigh. Nɨ suighsuigh gumazamizir kaba sara ovegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ezɨ Lot nɨghnɨzir avɨribagh ami. Ezɨ guizbangɨra, Ikiavɨra Itir God Lotɨn apangkufi. Kamaghɨn amizɨ, enselning a ko, an amuim ko guivimning dafaribar suigha egha nguibar kam ategha azenan ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Egha aning me inigha azenan ghugha gɨvagha, kamaghɨn me mɨgei, “Ia zuamɨram arɨmangegh, puvatɨghtɨ ia uaghan ovegham. Ia uamategh ragh gɨn ganan markɨ. Egh ia danganir zarir munamɨn dapiagh avughsan markɨ. Ia ovengan aghuaghsɨ, egh arɨ mɨghsɨabar ghuavanang.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ezɨ Lot ghaze, “Ekiam, kɨ nɨ na mɨgei moghɨn damuva avegham. ");
INSERT INTO msy2020_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nɨ na barakigh. Nɨ bar nan apangkuvigha ingangarir aghuim nan akurvaghasava a gami. Ezɨ mɨghsɨaba bar saghon mar iti, ezɨ kɨ zuamɨra da bagh mangɨva avegham. Kɨ mangɨvɨra ikɨtɨ, nguibam ikuvightɨ kɨ uaghan mɨzazim inigh ovegham. ");
INSERT INTO msy2020_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nɨ nguibar muziarir munamɨn gari a munagh iti. A roghɨra iti, ezɨ kɨ zuamɨra an angɨgham. A nguibar dozim. Nɨ na ateghtɨ kɨ nguibar kamɨn manɨgh egh osɨmtɨzir kam gitagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ezɨ ensel ghaze, “A dera. Kɨ nguibar nɨ mangasa mɨgeir mam gasɨghasɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Aria, nɨ atamra mangɨ. Kɨ bizitam damuan kogh mangɨ, dughiar ia mangɨ nguibar kamɨn otoghamim.” Ezɨ Lot ghaze, nguibar kam bar sufi, ezɨ me gɨn nguibar kam, Soar a garɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ezɨ aruem tɨghar maghɨn anagavɨra itima, Lot Soarɨn nguibamɨn otogha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ezɨ bar zuamɨra Ikiavɨra Itir God dagɨar isiba ko avim amadazɨ, da amozimɨn mɨn overiamɨn ikia Sodom ko Gomora giri. ");
INSERT INTO msy2020_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Egha a nguibamning vɨraram aning gasɨghasɨgha danganir zarir aning itim sarama asɨghasɨki. Egha gumazamizir nguibar kamningɨn itibagh asɨghasɨgha egha nguazir kamɨn itir aghuir biziba sara bar dagh asɨghasɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ezɨ Lotɨn amuim an gɨn iza, egha ua ragha gɨn gara, egha maghɨra solɨn mɨn otogha dɨpenir akɨnimɨn mɨn asaraghav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ezɨ amɨmzaraghan bar mɨzaraghara Abraham ghua danganir a faragha Ikiavɨra Itir God ko tughav ikia mɨkemezimɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Egha a Sodom ko Gomora, ko danganir zarir aning itir kam bagha gari, egha gari avir ekiamɨn mɨgharim nguazimɨn ikegha overiamɨn ghuavanadi. ");
INSERT INTO msy2020_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","God nguibar nguazir zarir kamɨn itiba bar adagh asɨghasɨki. Egha an Abraham gɨnɨghnɨgha, nguibar Lot itim gasɨghasɨgha, Lot gamizɨ an osɨmtɨzir kam gita. ");
INSERT INTO msy2020_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ezɨ Lot Soarɨn nguibamɨn ikian atiatigha uan guivimning inigha mɨghsɨabar ghuavanabo. Egha me dagɨar torir mamɨn aven iti. ");
INSERT INTO msy2020_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Egha an guivir ekiam kamagh uan afumim mɨgei, “Gan afeziam ghurigha gɨfa. Ezɨ nguazir kamɨn danganiba bar gumaziba puvatɨ. Ezɨ gumazamiziba faragha uarir iti moghɨn tina gan ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aria, ga uan afeziam wain taba a danightɨ an onganightɨ, ga a ko dakuightɨ, a boriba ga danɨngam. Eghtɨ gan afeziamɨn adarazi ikɨvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Egha dɨmangan aning wain isa uan afeziam ganɨngizɨ an ongani. Ezɨ guivir ekiam a koma akui. Aningɨn afeziam wain amegha bar onganigha fozir puvatɨzɨ guivim a koma akui. ");
INSERT INTO msy2020_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Egha amɨmzaraghan guivir ekiam uan afumim mɨgɨa ghaze, “Kɨ bogɨran dɨmangan afeziam koma akuigha gɨfa. Ga datɨrɨghɨn dɨmangan afeziam wainɨn taba uam a danɨngam. Eghtɨ nɨ kɨ amizɨ moghɨn nɨ a ko daku, eghtɨ a boritaba ga danightɨ gan afeziamɨn adarazi ikɨ mangɨvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Egha dɨmagarir kamɨn aning uan afeziam wain a ganɨngizɨ a uam ongani, ezɨ guivir dozim a koma akui. Afeziam faragha wain amegha onganigha fozir puvatɨzɨ moghɨra guivir dozim a koma akui. ");
INSERT INTO msy2020_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Egha tuavir kamɨn Lotɨn guivimning afeziam dam boriba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ezɨ guivir ekiam otarir mam bategha ziam, “Moap,” a gatɨ, ezɨ gɨn a Moapian ovavimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ezɨ guivir dozim uaghan otarim bategha ziam, “Benami,” a gatɨ, ezɨ gɨn an Amonian ovavimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","2","Dughiar kamɨn Abraham Mamren nguibam ategha ghua Negevɨn danganimɨn amadaghan, Kades ko Surɨn nguibar tɨzimningɨn apera. Egha gɨn a uan amuim Sara ko ghua Gerarɨn nguibar ekiamɨn apera. Egha Gerarɨn gumazamizibav gɨa ghaze, “Sara nan amizim.” Ezɨ Gerarɨn atrivim Abimelek, uan ingangarir gumaziba amangizɨ me ghua Sara inigha a bagha izi. ");
INSERT INTO msy2020_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ezɨ dɨmangan God Abimelek irebamɨn a mɨgɨa ghaze, “Nɨ tizim bagha pam itir amizim ini. Kamagh amizɨ nɨ ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Dughiar kam Abimelek tɨghar maghɨn Sara ko dakuam, egha kamaghɨn mɨgɨa ghaze, “Ekiam, gumazitam osɨmtɨzitam damighan koghtɨ, nɨ an ikɨzim ko me gasɨghasigham? ");
INSERT INTO msy2020_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham uabɨ na mɨgɨa ghaze, Sara nan amizim. Ezɨ Sara ghaze, Abraham nan tuebam. Ezɨ kɨ amizir kam inigha ghaze, kɨ arazir aghuimɨn a ini. Egha kɨ osɨmtɨziba puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ezɨ God irebamɨn a ikaragha ghaze, “Are, kɨ fo, nɨ nɨghnɨzir aghuarim ikia kamagh ami. Ezɨ kɨ uabɨ nɨn amamangatɨzir puvatɨzɨ, nɨ a koma akuizir puvatɨgha nan damazimɨn arazir kuram gamizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Gumazir kam, nan akam inigha izir gumazim, ezɨ nɨ datɨrɨghɨn amizim amadaghtɨ, a ua uan pam bagh mangɨ. Eghtɨ a nɨ bagh na ko mɨkɨmtɨ, nɨ oveghan kogham. Egh nɨ amizim amadaghtɨ a ua mangɨghan koghtɨ, nɨ uan gumazamiziba ko bar arɨmɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ezɨ amɨmzaraghan Abimelek uan ingangaribar garir gumazibar diagha, bizir Ekiam a mɨkemeziba bar me mɨkeme. Ezɨ me bar atiatingi. ");
INSERT INTO msy2020_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ezɨ Abimelek Abrahamɨn diagha an azara, “Nɨ bar arazir manmaghɨram amizimɨn e gami? Kɨ arazir kurar manamra nɨ gamizɨ, nɨ na ko kɨ ativagha garir darasi, e gamizɨ osɨmtɨzir arazir kam e bato? Arazir nɨ e gamizir kam, a bar derazir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Egha Abimelek ua kamaghɨn mɨgɨa ghaze, “Nɨ nɨghnɨzir manamra ikia egha kamagh ami?” ");
INSERT INTO msy2020_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ezɨ Abraham a ikaragha ghaze, “Nan nɨghnɨzimra kara, kɨ ghaze nguibar kamɨn gumaziba Godɨn atiatir puvatɨ. Me ti nan amuim inisɨ na mɨsueghtɨ kɨ aremegham. ");
INSERT INTO msy2020_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Egha kɨ ghaze, guizbangɨra Sara nan amizim. Ga afeziar vamɨra ikia, egha amebamning ighara. Egha gɨn a nan amuimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kɨ uan afeziamɨn dɨpenimɨn ikiavɨra iti, God nguazir igharazibar mangasa nan deir dughiamɨn, kɨ Sara mɨgɨa ghaze, ‘Nɨ arazir aghuimɨn na damusɨ, egh ga danganir manabar mangɨ, nɨ gumazamiziba kamagh me mɨkɨm suam, Abraham nan tuebam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ezɨ Abimelek ua Sara isa Abraham ganɨngi. Egha puram sipsipba, bulmakauba, ingangarir gumaziba ko amiziba Abraham ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Egha Abraham mɨgɨa ghaze, “Nɨ gan, nguazir kabanang da bar nana. Nɨ tam dapisɨ ifuegh egh tam daperagh.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Egha kamagh Sara mɨgei, “Kɨ 1,000 silvan dagɨar kaba isa osɨmtɨzir nɨ batozim akɨrasa, nɨn tuebam ganɨdi. Eghtɨ nɨ ko iti darazi kamaghɨn fogh suam, nɨ osɨmtɨzitam gamizir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ezɨ Abimelek Abrahamɨn amuim Sara gamizir arazir kam bangɨn, God an adarazir amizibar naviba apuizɨ, me boriba batir puvatɨ. Ezɨ Abraham God ko mɨgeima, God Abimelek gamizɨ, a ua dera. Ezɨ Abimelekɨn amuim ko puram an ingangarir amiziba ua boriba bati. ");
INSERT INTO msy2020_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ezɨ Ikiavɨra Itir God Sara mɨkemezɨ moghɨn deragha a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ezɨ Abraham bar ghurizir dughiamɨn, Sara otarim bate. A God inabazir dughiamrama, otarim bate. ");
INSERT INTO msy2020_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ezɨ Abraham kamaghɨn uan otarim ziam, “Aisak,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Sara Aisak batezɨ, 8plan dughiam otozɨ, Abraham Godɨn mɨgɨrɨgɨamɨn gɨn ghua borimɨn mɨkarzir mogomemɨn inim atu. ");
INSERT INTO msy2020_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ezɨ Abraham 100plan azenibar otozɨma, Sara Aisak bate. ");
INSERT INTO msy2020_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Egha Sara kamaghɨn mɨgei, “God arazir aghuim na gamizɨ kɨ bar akuegha ati. Eghtɨ gumazamiziba gɨn bizir kam baregh, na ko bar akuegh akam.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ezɨ Sara ua ghaze, “Gumazitam ti faragha Abraham kamaghɨn a mɨkemeghai, ‘Nɨn amuim Sara navim asegh boritam bategh, egh oteba a danɨngam?’ Ezɨ a ghurigha gɨvazɨ kɨ an otarim bate.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ezɨ borim ekevegha gɨvagha otem ataghizɨ dughiar kamɨn, Abraham maburan isam gami. ");
INSERT INTO msy2020_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hagar, Isipian amizim, a faragha Abrahamɨn ikia otarir mam bate. Ezɨ dughiar mamɨn Sarai otarir igharazir kamɨn gari, a Aisak ko ikararagha arui. ");
INSERT INTO msy2020_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ezɨ an Abraham mɨgɨa ghaze, “Nɨ ingangarir amizir kɨnim uan otarim ko aning batokegh. Ingangarir amizimɨn borim nɨn bizitaba inian kogham. Bizir kaba da bar nan borim Aisakɨn biziba.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ezɨ Ismael uaghan Abrahamɨn borim, ezɨ mɨgɨrɨgɨar otevir kam Abraham gamizɨ a bar oseme. ");
INSERT INTO msy2020_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ezɨ God Abraham mɨgɨa ghaze, “Nɨ ingangarir amizim Hagar uan borim ko aning bagh osɨman markɨ. Nɨ Saran akam baragh, an gɨn mangɨ. Aisakrama nɨn ovavir boriba otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Eghtɨ ingangarir amizimɨn borim, a uaghan nɨn borim. Kamaghɨn, kɨ uaghan an ovavir boribar amightɨ me avɨrasemegh kantrin gavgavimɨn otogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ezɨ amɨmzaraghan bar mɨzaraghara, Abraham dagheba inigha egha memen inir me dɨpam tuasa isamizim ini. Egha an dɨpam tuigha, da isa Hagarɨn dɨpɨzim gatɨ. Egha a borim isa a ganigha aning amadazɨ aning zui. Ezɨ Hagar Berseban nguibamɨn amadaghan gumazamiziba puvatɨzir danganim bar a garui. ");
INSERT INTO msy2020_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ezɨ dɨpam gɨvazɨma Hagar uan borim isa tevsevimɨn apengan anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Egha a borimɨn gantɨ an ovengan aghuagha ghua mong saghon aperaghav iti. Egha azia iti. ");
INSERT INTO msy2020_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ezɨ God borimɨn ararem baraki, ezɨ an ensel Godɨn nguibamɨn ikia Hagarɨn diagha a mɨgɨa ghaze, “Hagar, manmaghɨn ami? Nɨ atiatingan markɨ. God nɨn borimɨn ararem baregha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Nɨ dɨkavigh mangɨ borimɨn agharimɨn suiragh a fegh, egh a inigh. Kɨ an ovavir boribar amightɨ, me bar avɨrasemegh ikɨzir gavgavimɨn otogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ezɨ God Hagarɨn damaziba kuizɨ, a mozir par mamɨn api. Ezɨ a ghua memen inimɨn dɨpam tui. Egha dɨpam isa borim ganɨngizɨ an anepi. ");
INSERT INTO msy2020_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ezɨ God borim ko itima an ekefe. A gumazamiziba puvatɨzir danganimɨn ikiava ekevegha, barir pimɨn asir fofozir bar ekiam iti. ");
INSERT INTO msy2020_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Egha gɨn a Paranɨn gumazamiziba puvatɨzir danganimɨn itima, an amebam a bagha Isipian amizir mam ini. ");
INSERT INTO msy2020_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Dughiar kamɨn Abimelek ko an mɨdorozir gumazibar faragha zuir gumazim Fikol, Abraham bagha ghua Abimelek kamaghɨn a mɨgei, “Kɨ gari, bizir nɨ amiba, God nɨ ko ikia deraghavɨra nɨ gami. ");
INSERT INTO msy2020_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Egh nɨ Godɨn damazimɨn na ko akam akɨrigh, egh nɨ ifavarir arazim na ko, nan boriba, ko nan ovavir boribar amuan markɨ, kɨ arazir aghuimra nɨ gami. Kamaghɨra nɨ arazir aghuimɨn na damu egh kantrin nɨ datɨrɨghɨn itir kam saram uaghan a damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ezɨ Abraham ghaze, “Kɨ nɨ mɨkemezir moghɨn kɨ akam akɨri.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ezɨ Abraham uan mozir dɨpar Abimelekɨn ingangarir gumaziba inizim bagha, Abimelek ko mɨgɨrɨgɨam iti. ");
INSERT INTO msy2020_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ezɨ Abimelek ghaze, “Kɨ mamaghɨn fozir puvatɨ. Nɨ fomɨra na mɨkemezir puvatɨ. Kɨ datɨrɨghɨra mamagh orasi.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ezɨ Abraham sipsipba, memeba, ko bulmakauba Abimelek ganigha aning akar dɨkɨrɨzir gavgavim gami. ");
INSERT INTO msy2020_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Egha Abraham uan sipsipbar tongɨn sipsipɨn nguzir amebar igiar 7pla inigha munagh ada arɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ezɨ Abimelek an azara, “Nɨ tizim bagha mamagh ami?” ");
INSERT INTO msy2020_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ezɨ Abraham ghaze, “Nɨ na dam, sipsipɨn nguzir amebar 7pla inigh. Egh arazir kamɨn kamagh akagham, kar kɨ uabɨ kuizir mozir pam.” ");
INSERT INTO msy2020_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Egha aning danganir kamɨn akam akɨri. Ezɨ danganir kam, me ziam, “Berseba,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Egha aning Berseban akar gavgavim akɨrigha gɨvagha, Abimelek ko an mɨdorozir gumazibar faragha zuir gumazim Fikol uamategha Filistian danganimɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ezɨ Abraham Berseban temer mam akara, egha Ikiavɨra Itir Godɨn ziam fe, a Godɨn zurazurara ikiavɨra itim. ");
INSERT INTO msy2020_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Egha Abraham dughiar bar ruarimɨn, kantrin igharazimɨn gumazimɨn mɨn Filistiabar nguazimɨn ike. ");
INSERT INTO msy2020_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Egha gɨn dughiar mam God Abrahamɨn nɨghnɨzir gavgavim gɨfoghasa a guizbangɨra gavgaviz, ti puvatɨ? Kamaghɨn an an dɨa ghaze, “Abraham!” Ezɨ Abraham ghaze, “Kɨ kati.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ezɨ God a mɨgɨa ghaze, “Nɨ otarir vamɨra iti Aisak, ezɨ nɨ bar a gifonge. Nɨ borir kam inigh egh Morian nguazimɨn anɨngtɨ kɨ mɨghsɨatam nɨn akagham. Egh mɨghsɨar kamɨn nɨ Aisak isɨ ofan bar isi mɨghɨramimɨn mɨn na danɨngigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Egha bar mɨzaraghara Abraham donki inigha Aisak ko uan ingangarir gumazir pumuning ini. Egha ofan bar isia mɨghɨrizim damuasa dazibar kuegha danganir God a mɨkemezimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Egha namba 3ɨn aruemɨn Abraham danganir kamɨn gari a saghon ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ezɨ a kamagh ingangarir gumazimning mɨgei, “Gua donki ko kagh ikɨ. Kɨ borim ko mangɨ ga munagh Godɨn ziam fam. Egh ga gɨn gua bagh uamategham.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Egha Abraham dazir ofan bar isi mɨghɨramim damuamiba Aisak ganɨngizɨ, ana dagh isaghpu. Ezɨ Abraham sabam ko avim suiragha, aning zui. ");
INSERT INTO msy2020_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aning tɨghar maghɨn ghua Aisak kamaghɨn an azara, “Afeziam.” Ezɨ Abraham ghaze, “Nan borim, manmaghɨn ami?” Ezɨ Aisak an azara, “Afeziam, kɨ gari daziba ko avir ofan bar isi mɨghɨramim damuamim iti, ezɨ sipsipɨn ofa damuamim mana?” ");
INSERT INTO msy2020_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ezɨ Abraham a ikaragha ghaze, “Nan borim, God uabɨ ofan bar isi mɨghɨramim damuamin sipsipɨn nguzim, ga danɨngam.” Egha aning zui. ");
INSERT INTO msy2020_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Egha aning danganir God mɨkemezimɨn otogha gɨvagha, Abraham ofa gamir dakozimɨn ingarigha daziba a gisɨn da arɨki. Egha uan otarim Aisak benimɨn a ike. Egha a isa ofa gamir dakozimɨn dazibagh isɨn anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Egha Abraham afuam inigha borim bɨraghtɨ an aremeghasava ami. ");
INSERT INTO msy2020_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ezɨ Ikiavɨra Itir Godɨn ensel, a Godɨn Nguibamɨn ikia dɨa ghaze, “Abraham! Abraham!” Ezɨ Abraham a ikaragha ghaze, “Kɨ kati.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ezɨ ensel a mɨgɨa ghaze, “Nɨ uan borim mɨsueghtɨ an aremeghan markɨ. Egh arazitamɨn a damuan markɨ. Nɨ bar borir vamɨra ikia egha an anogoroghezir puvatɨ. Nɨ a isɨ God danɨngasavɨram ami. Kamaghɨn kɨ fo, nɨ gumazir Godɨn atiatiava an apengan itim.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ezɨ Abraham kogha sipsipɨn apurir mamɨn gari, an kom tevsevir mamɨn suirazɨma a iti. Ezɨ a ghua sipsipɨn kam inigha, a mɨsuegha a isa ofan bar isi mɨghɨramim damuasa a gaboro. Sipsipɨn apurir kam Aisakɨn danganim inizɨ Aisak iti. ");
INSERT INTO msy2020_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ezɨ Abraham danganir kam ziar kam a gatɨ, “Ikiavɨra Itir God Anɨngi.” Ezɨ iza datɨrɨghɨn gumaziba ghaze, “Ikiavɨra Itir Godɨn uan mɨghsɨam gisɨn biziba e danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ezɨ Ikiavɨra Itir Godɨn ensel Abraham uam an dɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Kɨ Ikiavɨra Itir God, guizbangɨra uabɨ uan ziam dɨbora ghaze, nɨ bar borir kamra ikia, egha an anogoroghezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kamaghɨn kɨ guizbangɨra nɨ mɨgei, kɨ deragh nɨ damuva, nɨn ovavir boribar amightɨ me bar avɨrasemegham. Eghtɨ men dɨbobonim, mɨkoveziba ko gigimɨn dɨbobonimɨn mɨn otivigham. Eghtɨ nɨn ovavir boriba uan apaniba abɨnigh, egh men nguibaba iniam. ");
INSERT INTO msy2020_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Guizbangɨra, nɨ nan akam baregha an gɨn ghu, kamaghɨn amizɨ, nɨn ovavir boriba bangɨn kɨ nguazir kamɨn itir ikɨzibar gumazamiziba, bar deravɨra me damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ezɨ Abraham Aisak inigha uamategha uan ingangarir gumazimning bagha ghu. Egha me ua Berseban ghugha Abraham bar moghɨra Berseban apera. ");
INSERT INTO msy2020_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Egha gɨn Abraham kamagh oraki, Milka otarir maba bate. Ezɨ Abramɨn dozim Nahor an amuim Milka. ");
INSERT INTO msy2020_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Otarir kabar ziabar kara: Us, an otarir ivariam, ko Bus, ko Kemuel (Kemuel gɨn Aramɨn afeziamɨn oto) ko, ");
INSERT INTO msy2020_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Pildas, Jitlap ko Betuel. ");
INSERT INTO msy2020_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ezɨ Betuel a Rebekan afeziam. Milka Nahorɨn dughiamɨn otarir 8pla bate, ezɨ Nahor, an Abrahamɨn dozim. ");
INSERT INTO msy2020_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ezɨ Nahorɨn amuir dozim, an ziam Reuma, a Teba, Gaham, Tahas ko Maka bate. ");
INSERT INTO msy2020_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ezɨ dughiar kamɨn Sara 127plan azeniba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Egha nguibar ziam Kiriat Arban ikiava areme, nguibar kam an ziar mam Hebron, a Kenanɨn nguazimɨn iti. Ezɨ Abraham bar an apangkuvigha a baghava azi. ");
INSERT INTO msy2020_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Egha a Saran kuam ataghizɨ a itima, a ghua Hitian adaraziv gɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Kɨ kantrin igharazimɨn gumazim, egha iza ian tongɨn apera. Nan amuim aremegha gɨvazɨma kɨ ia dam nguazir asɨzitam givezegh egh a mozim darɨghasa.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ezɨ Hitian gumaziba kamaghɨn mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Gumazir ekiam, nɨ orakigh. Nɨ gumazir dapanir bar aghuim. Nɨ uan amuim en dagɨar mozir aghuitamɨn anefɨ. En gumazitam nɨn anogoroghan kogham. Nɨ uabɨ danganir aghuitam ginabaghtɨ, nguazimɨn afeziam pura nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ezɨ Abraham dɨkavigha tugha uan guam Hitian gumazamizibav suegha dapanim aviragha, ");
INSERT INTO msy2020_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","egha kamaghɨn mɨgei, “Kɨ uan amuimɨn kuam isɨ nguibar kamɨn a mozim darɨghsɨ ia nan amamangatɨgh, egh ia na bagh Soharɨn otarim Efronɨn azaragh, ");
INSERT INTO msy2020_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","eghtɨ a dagɨar torir me kamagh dɨborim, Makpela na danɨngam. An Efronɨn nguazir mɨriamɨn ti. Ia a mɨkemeghtɨ a dagɨar torir kam na danɨngightɨ, ian damazibar kɨ ivezim bar a danɨngam, eghtɨ dagɨar torir kam, kɨ an ghuavim ikegham, eghtɨ a kɨ uan adarazir kuabar afamin danganimɨn mɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ezɨ Efron uabɨ nguibar ekiamɨn danganir uari akuvimɨn, Hitian tongɨn aperaghav iti. Ezɨ Hitian gumaziba ikia orazi, Efron kamaghɨn Abrahamɨn akam ikaragha ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Puvatɨ, gumazir ekiam. Nɨ nan akam barakigh. Nɨ torir kam givezan kogham. Kɨ nguazir dagɨar torim itir kam, a isɨ pura nɨ danɨngam. Nan adarazir damazimɨn kɨ datɨrɨghɨn nguazim nɨ danightɨ, nɨ uan amuim afam.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ezɨ Abraham ua gumazibar damazimɨn guam avira. ");
INSERT INTO msy2020_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Egha men damazimɨn a Efron mɨgɨa ghaze, “Efron, kɨ kamaghsua nɨ deravɨra kuarim atɨgh nan mɨgɨrɨgɨam baragh. Kɨ datɨrɨghɨn nɨn nguazir otevir kam givezam. Nɨ nan dagɨaba initɨ, kɨ uan amuim nguazir kamɨn a mozim darɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ezɨ Efron Abrahamɨn akam ikaragha ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gumazir ekiam, nɨ oragh. Nguazir kamɨn ivezim a 400 silvan dagɨabara. Ezɨ markɨ, kar gan bizim, a pura bizim. Nɨ pura nguazim inigh uan amuimɨn kuam afɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ezɨ Abraham akar kam gifongegha, gumazir biziba amaga dagh ivezibar mɨrara, deragha 400plan silvan dagɨaba mengegha, nguazimɨn ivezir kamra isa, Hitian gumazibar damazimɨn nguazim giveza Efron ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Egha arazir kamɨn Abraham Efronɨn nguazir Makpelan itim ini, a Mamren nguibamɨn boroghɨn iti. A nguazim ko, dagɨar torim ko, temer nguazir kamɨn itiba a bar moghɨra da ini. ");
INSERT INTO msy2020_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ezɨ Hitian gumazir mɨgɨrɨgɨar kam baragha itiba, me bar kamagh fo, nguazir kam Abraham a ini. ");
INSERT INTO msy2020_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Egha a nguazim inigha gɨvagha, uan amuim Sara, an kuam isa dagɨar mozir Makpelan nguazimɨn itimɨn a mozim gatɨ. Makpela a Mamren nguibamɨn boroghɨn iti. Egha Kenanɨn nguazimɨn iti. Mamren ziar igharazim, a Hebron. ");
INSERT INTO msy2020_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ezɨ Hitian nguazir otevir kamɨn itir dagɨar mozim, an Abrahamɨn adarazir kuabar afamin danganimɨn mɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham datɨrɨghɨn ghurigha gɨfa. Ezɨ Abraham amir biziba, Ikiavɨra Itir God a uabɨ dagh ami, da bar deraghavɨram otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Dughiar mam, Abraham uan ingangarir gumazimɨn diazɨ a izi. Ingangarir gumazir kam fomɨram a ko ikia an biziba datɨrɨghɨn bar dar gari. Ezɨ Abraham a mɨgɨa ghaze, “Nɨ uan dafarim nan buarakɨrimɨn apengan amadagh egh akar gavgavim na koma anekɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Nɨ Ikiavɨra Itir Godɨn ziamɨn guizbangɨra mɨkɨm, a Godɨn Uan Nguibam ko nguazim gativazim. Egh nɨ Kenanɨn aven nguazir kɨ itir kamɨn, nan otarim bagh guivitam ginaman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Puvatɨ, nɨ nan bighara mangɨ egh nan adarazir tongɨn a bagh amizitam batogh, eghtɨ amizim izɨ nan otarim, Aisakɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ezɨ ingangarir gumazim kamaghɨn mɨgei, “Eghtɨ amizir kam uan nguibam ataghɨraghan aghuaghtɨ, kɨ manmaghɨra damuam? Egh kɨ ti nɨn otarim inigh ua nɨn adarazir bighan mangɨgham?” ");
INSERT INTO msy2020_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ezɨ Abraham a ikaragha ghaze, “Bar puvatɨ! Nɨ nan otarim inigh uamategh nan bighan mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Kɨ fomɨra uan adarazir nguazimɨn ikia uan afeziamɨn dɨpenimɨn iti, ezɨ Ikiavɨra Itir God, a Godɨn Uan Nguibam gativazim, a na inigha kagh ize. Egha an akar dɨkɨrɨzir gavgavim na koma a gamua ghaze, a nguazir kam nan ovavir boribar anɨngam. Ezɨ kɨ fo, a uan ensel amadaghtɨ a nɨn faragh nan adarazi bagh mangɨ, nɨn akurvaghtɨ, nɨ nan otarim bagh amizitam iniam. ");
INSERT INTO msy2020_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Eghtɨ amizim nɨ ko izan aghuagham, eghtɨ akar ga dɨkɨrɨzir kam ua nɨn suighan kogham. Eghtɨ nɨ nan otarim inigh nan nguibamɨn mangan bar markiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ezɨ ingangarir gumazim uan gumazir ekiam Abraham a mɨkemezir biziba bar dar amuasa, uan dafarim isa an buarakɨrimɨn apengan anemadagha, akar dɨkɨrɨzir gavgavim a koma a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ezɨ ingangarir gumazim Abrahamɨn 10plan kamelba ko bizir aghuir avɨriba ini. Egha biziba bar da inigha egha Aramɨn nguazimɨn ghua Nahorɨn nguibamɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","An otogha gɨvagha kamelbagh amizɨ me mozir dɨpamɨn nguibamɨn azenan teviba apɨrigha apiaghav iti. Kar guaratɨzim, kar amiziba iza dɨpaba tuir dughiam. ");
INSERT INTO msy2020_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ezɨ a kamagh God ko mɨgɨa ghaze, “O Ikiavɨra Itir God, nɨ nan gumazir ekiam Abrahamɨn God. Nɨ nan gumazir ekiamɨn apangkuvigh, egh datɨrɨghɨn nan ingangarim damightɨ, a guizbangɨram otogh. ");
INSERT INTO msy2020_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kɨ mozir par kamɨn boroghɨn tughav iti, ezɨ amizir igiaba dɨpaba tusɨ izam. ");
INSERT INTO msy2020_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ezɨ kɨ kamaghɨn nɨn azai, kɨ amizir igiatam mɨkɨm suam, ‘Ai, kɨ dɨpatam amasa, nɨ ti nan akuragh uan dɨpɨzimɨn mɨner dɨpam asigh a inigh izighirɨ.’ Eghtɨ a suam, ‘Are, nɨ damɨ, eghtɨ kɨ dɨpam uaghan nɨn kamelbar anɨngam.’ Eghtɨ, tuavir kamra, kɨ fogham, amizir kamra nɨ uan ingangarir gumazim Aisak bagha a ginaba. Eghtɨ bizir kaba otivightɨ kɨ fogham, nɨ nan gumazir ekiam Abraham bar an apangkufi.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ezɨ ingangarir gumazim God ko mɨgɨavɨra itima, Rebeka izava oto. A mɨner dɨpam uan dɨpɨzim dafa. Rebeka a Betuelɨn guivim. Ezɨ Betuel a Nahor ko Milkan otarim. Ezɨ Nahor ana Abrahamɨn dozim. ");
INSERT INTO msy2020_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Amizir igiam Rebeka, an ganganiba bar deragha tɨghar gumazitam ko dakuam. Egha mozir pam giraghugha uan mɨner pam tuigha uamategha anadi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ezɨ ingangarir gumazim a bagha ivegha ghua kamaghɨn a mɨgei, “Ai, nɨ nan akuragh uan mɨnemɨn dɨpar muziaritam na danɨngam?” ");
INSERT INTO msy2020_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ezɨ Rebeka ghaze, “Gumazir ekiam, nɨ dɨpam ramɨ.” Egha a zuamɨra mɨner dɨpam uan agharimɨn an suiragha izaghira an taghizɨ a dɨpam api. ");
INSERT INTO msy2020_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Egha an amegha bar izɨvazɨma Rebeka a mɨgɨa ghaze, “Kɨ nɨn kamelba dɨpam uaghan me danightɨ me damɨ izɨvagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Egha a zuamɨra mɨner pam, asɨziba dɨpam apir dagɨar danganimɨn a inge. Egha a ivegha uamategha dɨpam tuasa ghu. A kamaghɨram amua ghuavti kamelba bar dɨpam ame. ");
INSERT INTO msy2020_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ezɨ ingangarir gumazim mɨgeir puvatɨ. A pura damazibar an gari. Egha foghasa, Ikiavɨra Itir God uan ingangarim damightɨ a guizbangɨram otivasa, o ti puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ezɨ kamelba dɨpam amegha gɨvazɨ, ingangarir gumazim ghua ring golɨn atinibagh azuim isa Rebekan atinim garu. Egha daveriar golɨn pumuning Rebekan agharimning garu. Ringɨn kamɨn osɨmtɨzim a 5 gremɨn tu, ezɨ daveriar kamningɨn osɨmtɨzim 100 gremɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Egha ingangarir gumazim ghaze, “Nɨ na mɨkɨm, nɨ tinan guivim? Egha nɨ manmagh nɨghnɨsi, nɨn adarazir dɨpenim danganitam ikɨtɨ, kɨ uan adarazi ko datɨrɨghɨn dɨmangan an dakuam?” ");
INSERT INTO msy2020_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ezɨ Rebeka a ikaragha kamaghɨn mɨgei, “Kɨ Betuelɨn guivim, ezɨ Betuel a Nahor ko Milkan otarim. ");
INSERT INTO msy2020_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Are, e kamelba damamin dagher avɨriba iti. Egha dɨpenimɨn danganir mam iti. Ia izɨ mangɨ a daku.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ezɨ Abrahamɨn ingangarir gumazim teviba apɨrigha guam aviragha Ikiavɨra Itir Godɨn ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Egha kamaghɨn mɨgei, “Kɨ uan gumazir ekiam Abraham, an Godɨn ziam fasa, a Ikiavɨra Itir God. A nan gumazir ekiamɨn apangkuvigha egha a mɨkemezɨ moghɨra deraghavɨrama a gami. Guizbangɨra, Ikiavɨra Itir God na inigha iza nan gumazir ekiamran adarazir dɨpenim gatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ezɨ amizir igiam ivegha ghua uan amebamɨn dɨpenimɨn itir darazi bizir otivir kabar gun bar me mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ezɨ Rebekan tuebam Laban, ring golɨn an atinimɨn itim ko, daveriar an agharimningɨn itimning dar gari. Egha an orazi, Rebeka gumazir kam mɨkemezir biziba bar dagh eghari. Kamaghɨn a ivegha azenan ghua Abrahamɨn ingangarir gumazim bagha ivegha zui. Egha gumazir kamɨn gari a mozir dɨpamɨn boroghɨn uan kamelba ko tughav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ezɨ Laban kamaghɨn mɨgei, “Gumazir ekiam, Ikiavɨra Itir God bar deragha nɨ gamigha gɨfa. Nɨ izɨ e dɨpenimɨn mangam. Nɨ kagh ikian markɨ. Kɨ nɨn mɨsiam akɨrigha gɨfa, egha uaghan nɨn kamelba bagha danganim akɨri.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ezɨ Abrahamɨn ingangarir gumazim dɨpenimɨn aven ghu. Ezɨ Laban uan ingangarir gumazibav kemezɨ, me kamelba atera izezir bizibagh eghuvigha egha dadaba ko dagheba kamelbagh anɨdi. Egha a me mɨkemezɨ me dɨpam tuigha iza Abrahamɨn ingangarir gumazim uan adarazi ko me ganɨngizɨ me uan dagariba rue. ");
INSERT INTO msy2020_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ezɨ me gɨn dagheba inigha izi, ezɨ Abrahamɨn ingangarir gumazim kamaghɨn mɨgei, “Kɨ zuamɨra dameghan kogham. Kɨ faragh uan mɨgɨrɨgɨabar amigham.” Ezɨ Laban ghaze, “A dera. Nɨ mɨkɨm.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ezɨ ingangarir gumazim ghaze, “Kɨ Abrahamɨn ingangarir gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ikiavɨra Itir God nan gumazir ekiam bar deragha a gamizɨ, a biziba bar avɨraseme. A bizir bar avɨrir kaba Abraham ganɨngi, sipsipba, memeba, bulmakauba, silva ko gol, ko ingangarir amiziba ko gumaziba, kamelba ko donkiba. ");
INSERT INTO msy2020_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ezɨ an amuim Sara bar ghurigha egha otarim bate. Ezɨ nan gumazir ekiam biziba bar ada isa otarir kam ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","38","Egha pamten na mɨgɨa ghaze, ‘Nɨ nan otarim bagh Kenanɨn, nguazir kɨ itir kamɨn nan otarim bagh guivitam ginaman markɨ. Markiam, nɨ nan afeziamɨn adarazir bighan mangɨ egh nan otarim bagh amizitam ginabagh.’ Nan gumazir ekiam mɨgɨrɨgɨar kam gamua, egha na gamizɨ kɨ an mɨgɨrɨgɨar kamɨn gɨn mangasa a ko akam akɨrigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ezɨ kɨ uan gumazir ekiam mɨgei, ‘Eghtɨ amizir kam na ko izan aghuaghtɨ, kɨ manmaghɨn damuam?’ ");
INSERT INTO msy2020_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ezɨ a ghaze, ‘Kɨ gumazir Ikiavɨra Itir Godɨn akabar gɨn zuim, eghtɨ a uan ensel nɨn faragh anemadaghtɨ a mangɨ ingangariba bar dar amightɨ da bar nɨn deragham. Eghtɨ nɨ nan otarimɨn amuim nan afeziamɨn adarazir bighan a inigh izam. ");
INSERT INTO msy2020_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eghtɨ tuavir vamɨra otoghtɨ, kamaghɨn akar ga dɨkɨrɨzir kam ua nɨn suighan kogham. Nɨ men bighan mangɨtɨ, nan afeziamɨn adarazi kamagh mɨkɨm suam, amizim nɨ ko izan kogham, egh me an anogoregham, me kamaghɨn damutɨ, akar nɨ na ko dɨkɨrɨzir kam, osɨmtɨzim nɨ danɨngan kogham.’ ");
INSERT INTO msy2020_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ezɨ datɨrɨghɨn guaratɨghɨn, kɨ iza mozir pamɨn otogha kamagh God ko mɨgei, ‘O Ikiavɨra Itir God, nan gumazir ekiamɨn God, nɨ datɨrɨghɨn na bagh ingangarir kam damightɨ a guizɨn otogh. ");
INSERT INTO msy2020_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ezɨ kɨ datɨrɨghɨn mozir pamɨn boroghɨn iti. Eghtɨ amizir igiatam dɨpam tuigh izɨtɨ, kɨ a mɨkɨm suam, “Ai, nɨ uan mɨnemɨn dɨpar muziaritam na danightɨ, kɨ anemeka.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Eghtɨ a kamagh mɨkɨmam, “Nɨ dameghtɨ, kɨ dɨpam isɨ uaghan nɨn kamelbar anɨngam,” eghtɨ nan ifongiam kar ti amizir kamra nɨ nan gumazir ekiamɨn otarim bagha a ginaba.’ ");
INSERT INTO msy2020_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Kɨ God ko mɨgɨavɨra itima Rebeka izava oto. A mɨnem uan dɨpɨzim dafagha dɨpam tuasa mozir pamɨn uaghiri. A izima, kɨ a mɨgɨa ghaze, ‘Ai, nɨ dɨpar muziaritam na danɨngigh.’ ");
INSERT INTO msy2020_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Ezɨ a zuamɨra mɨner pam dafarimɨn an suiragha izaghirɨgha ghaze, ‘Gumazir ekiam, nɨ dɨpam amɨ. Eghtɨ kɨ dɨpam uaghan a isɨ nɨn kamelbar anɨngam.’ Ezɨ kɨ dɨpam amegha gɨvazɨma, a dɨpam isa nan kamelbagh anɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ezɨ kɨ an azara, ‘Nɨ tinan guivim?’ “Ezɨ a ghaze, ‘Kɨ Betuelɨn guivim, Betuel a Nahor ko Milkan otarim.’ Ezɨ kɨ ring an atinim gatɨgha egha daveriaba an agharimning garu. ");
INSERT INTO msy2020_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Egha kɨ tevimning apɨrigha guam aviragha Ikiavɨra Itir Godɨn ziam fe, a nan gumazir ekiam Abrahamɨn God. A na inigha iza nan gumazir ekiam Abrahamɨn aveghbuamɨn dɨpenimrama oto. Eghtɨ kɨ guizbangɨra an igiar guivim inightɨ a mangɨ nan gumazir ekiamɨn otarimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Egha kɨ ian azai, ia bizir aghuitam ko arazir aghuimɨn nan gumazir ekiam damusɨ, egh guizbangɨra deragh na mɨkɨm? Egh ia aghuagh, egh uaghan na mɨkɨmtɨ, kɨ bizitam damusɨ ua nɨghnɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ezɨ Laban ko Betuel kamaghɨn an akam ikaragha ghaze, “Ikiavɨra Itir God uabɨ bizir kam gamizɨ, ezɨ e mɨgɨrɨgɨaba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka iti. Nɨ a inigh egh gua mangɨ. Ikiavɨra Itir God nɨ mɨkemezɨ moghɨn, Rebeka nɨn gumazir ekiamɨn otarimɨn ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ezɨ Abrahamɨn ingangarir gumazim men akam baregha gɨfa, egha Ikiavɨra Itir Godɨn damazimɨn tevimning apɨrigha, aviragha guam nguazim girɨgha an ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Egha bizir gol ko silvan ingarizir dɨgɨrir igharagha gariba inigha da isa Rebeka ganɨdi. Egha bizir aghuir iveziba bar pɨn kozir avɨriba isa, an tuebam ko amebam ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ezɨ mɨgɨrɨgɨaba gɨvazɨma, Abrahamɨn ingangarir gumazim uan adarazi ko dagheba ko dɨpaba amegha, me akui. Egha mɨzaraghara me dɨkavigha Abrahamɨn ingangarir gumazim kamaghɨn mɨgei, “Ia na amadaghtɨ, kɨ uamategh uan gumazir ekiam bagh mangasa.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ezɨ Rebekan amebam ko an tuebam kamaghɨn mɨgei, “Nɨ amizir igiam amamangatɨghtɨ a tong e ko aruer 10plan ikegh, gɨn mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ezɨ Abrahamɨn ingangarir gumazim kamaghɨn mɨgei, “Ia nan anogoroghan markɨ. Ikiavɨra Itir God na bagha ingangarim gamizɨ, a deragha otogha gɨfa. Kamaghɨn, ia na amadaghtɨ, kɨ uamategh uan gumazir ekiam bagh mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ezɨ me ghaze, “E amizir igiamɨn diagh egh an azaragh, an ifongiam gɨfoka.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Egha me Rebekan diazɨ a izima, me an azara, “Nɨ gumazir kam ko mangasa ifonge?” Ezɨ a ghaze, “Are, kɨ mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ezɨ me Rebeka ko amizir a ko ikia an garim amadazɨ aning Abrahamɨn ingangarir gumazim, ko izezir darasi, me ko zui. ");
INSERT INTO msy2020_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ezɨ me Rebeka akar bar aghuimɨn a mɨgɨa ghaze: “En buaramizim, nɨ gumazamizir bar avɨravɨrimɨn amebamɨn otivam. Eghtɨ nɨn ovavir boriba uan apaniba abɨnigh, men nguibaba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ezɨ Rebeka uan ingangarir amiziba ko dɨkavigha kamelbagh apiagha Abrahamɨn ingangarir gumazimɨn gɨn zui. Egha me maghɨra zui. ");
INSERT INTO msy2020_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisak faragha mozir pamɨn boroghɨn iti, mozir par me kamagh dɨborim, “Godɨn Zurara Ikia Nan Garim.” Egha dughiar kam a mozir pam ategha iza Negevɨn danganimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Egha guaratɨzir kamɨn a bizibagh nɨghnɨghasa, tuzimɨn arua ghua, kogha kamelbar gari da saghon izi. ");
INSERT INTO msy2020_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ezɨ Rebeka Aisakɨn apigha kamel ategha izaghiri. ");
INSERT INTO msy2020_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Egha kamagh Abrahamɨn ingangarir gumazimɨn azara, “Munar gumazitam e bagha izi, a tina?” Ezɨ ingangarir gumazim ghaze, “Mar nan gumazir ekiam.” Ezɨ Rebeka uan dapanimɨn inim inigha izaghira uan guam avara. ");
INSERT INTO msy2020_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ezɨ ingangarir gumazim bizir an amizibar gun bar Aisak geghari. ");
INSERT INTO msy2020_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ezɨ Aisak Rebeka inigha uan amebam Saran purirpenimɨn ghu, egha Rebekan ti. Egha Aisak Rebeka bar a gifonge. A faragha uan amebamɨn ovevem bagha bar osemegha iti. Ezɨ datɨrɨghɨn an navir averiam uamategha dera. ");
INSERT INTO msy2020_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ezɨ Abraham amuir dozimɨn iti, an ziam Ketura. ");
INSERT INTO msy2020_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ezɨ amizir kam, Simran, Joksan, Midian, Isbak ko Sua bate. ");
INSERT INTO msy2020_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ezɨ Joksan, a Seba ko Dedanɨn afeziamɨn oto. Ezɨ Dedan, a Asuria, Letusia ko, Leumian ovavir inazimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ezɨ Midianɨn otaribar ziabar kara: Efa, Efer, Hanok, Abida ko Elda. Ka bar Keturan igiavotariba. ");
INSERT INTO msy2020_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ezɨ Abraham uabɨ bar uan biziba isa Aisak ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Egha an angamɨra ikiavɨra itir dughiamɨn, a bizir aghuiba isa uan amuir dozimningɨn boribagh anɨngi. Egha me amadazɨ, me an otarim Aisak ategha saghon ghua aruem anadi naghɨn ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Dughiar kamɨn Abraham 175plan azeniba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","A bar ghurigha, uan nguazimɨn ikɨrɨmɨrim bar a gakuegha ovengezɨ, an duam ghua an adarazir duaba ghua itir nguibamɨn me ko iti. ");
INSERT INTO msy2020_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ezɨ an otarimning, Aisak ko Ismael iza Mamren nguibamɨn boroghɨn dagɨar mozir me Makpela arɨzimɨn anefa. Nguazir kam, a Hitian gumazim Soharɨn otarim Efronɨn nguazim. ");
INSERT INTO msy2020_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abraham faragha Hitian adarazir gumazim dam nguazir otevir kam givese. Nguazir kamɨn Abraham faragha uan amuim Sara mozim gatɨ. Ezɨ datɨrɨghɨn Aisak ko Ismael, Abraham isa nguazir kamran a mozim gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ezɨ Abrahamɨn ovevemɨn gɨn, God bar deraghvɨra an otarim Aisak gami. Dughiar kam, Aisak mozirpar mamɨn boroghɨn iti, mozirpar me kamagh dɨborim, “Godɨn Zurara Ikia Nan Garim.” ");
INSERT INTO msy2020_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ezɨ kar Ismaelɨn ovavir boribar ziaba. Ismael a Abrahamɨn otarim, Hagar a bate. Ezɨ Hagar Isipian amizim, a Saran ingangarir amizim. ");
INSERT INTO msy2020_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismaelɨn otariba, men faragha otozimɨn ghua abuananamɨn ziaba: Ismaelɨn otarir ivariamɨn ziam Nebaiot, ezɨ an gɨrara iriba, Kedar, Atbel, ko Mipsam, ");
INSERT INTO msy2020_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ko Misma, Duma, ko Masa, ");
INSERT INTO msy2020_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ko Hadat, Tema, Jetur, Nafis, ko Kedema. ");
INSERT INTO msy2020_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kar Ismaelɨn otaribar ziaba. Ezɨ me ziar kabara inigha me itir nguibaba ko nguazir otevir me itibar ziaba dagh arɨki. Eghtɨ gɨn 12plan gumazir kaba, 12plan anababar otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ezɨ Ismael 137plan azeniba ikia egha aremezɨ, an duam ghua an adarazir duaba ghua itir nguibamɨn me ko iti. ");
INSERT INTO msy2020_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ezɨ Ismaelɨn ovavir boriba Havilan nguazim ko Surɨn nguibamɨn tizimɨn itir nguazir otevimɨn apia. Sur a Asirian zuir tuavimɨn iti, Isipɨn boroghɨn. Ezɨ me deragha Abrahamɨn ovavir igharaziba ko deragha apiazir puvatɨgha, me ko apanim gami. ");
INSERT INTO msy2020_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kar Abrahamɨn otarim Aisakɨn eghaghanim. ");
INSERT INTO msy2020_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ezɨ Aisak 40plan azeniba ikia egha Rebekan iti. Ezɨ Rebeka a Betuelɨn guivim, Betuel a Mesopotemian amadaghan Aramian adarazir gumazir mam. Rebeka ana Aramian adarazir gumazim Labanɨn buaramizim. ");
INSERT INTO msy2020_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ezɨ Aisakɨn amuim boriba puvatɨ, ezɨ Aisak Ikiavɨra Itir God ko mɨgɨa ghaze, nɨ na baregh nan amuimɨn akuraghtɨ a boritam iniam. Ezɨ Ikiavɨra Itir God, Aisakɨn mɨgɨrɨgɨam baraghizɨ, Rebeka navim adai. ");
INSERT INTO msy2020_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ezɨ otarir fufuzimning Rebekan navir averiamɨn ikia uaning adosi. Ezɨ Rebeka ghaze, “Tizim baghavɨra bizir kam na bato?” A bizir kamɨn mɨngarim gɨfoghasa, egha Ikiavɨra Itir God ko mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ezɨ Ikiavɨra Itir God Rebeka mɨgɨa ghaze, “Kantrin pumuningɨn gumazamiziba nɨn navimɨn aven ti. Ezɨ otarir nɨ otamin kamning, aning uaning batogh mangɨ tavɨn gavgavim tav gafiragham. Eghtɨ otarir faragha irɨzim, otarir gɨn irɨzimɨn ingangarir gumazimɨn mɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ezɨ dughiar Rebeka otamim otozɨ, ana otarir fufuzimning bate. ");
INSERT INTO msy2020_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ezɨ faragha irɨzimɨn mɨkarzim aghevegha arɨzɨvatari. Ezɨ me ziam, “Iso,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ezɨ Ison amebam a batir dughiamɨn an dozim an dagarir gɨnkevimɨn suiragha azenan ize. Kamaghɨn amizɨ me ziam, “Jekop,” a gatɨ. Dughiar kam Aisak 60plan azeniba itima aningɨn amebam aning bate. ");
INSERT INTO msy2020_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Egha otarir kamning ekevegha Iso asɨziba burir fofozir ekiam iti. Egha ruaribar aruasa bar ifonge. Ezɨ Jekop gumazir nɨmɨra itim, egha nguibamra ti. ");
INSERT INTO msy2020_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ezɨ Iso asɨzibav sogha da inigha iza Aisak ganɨdima an ada apava, bar Iso gifonge. Ezɨ Rebeka Jekop gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ezɨ dughiar mamɨn Jekop nguezibar dɨparsɨzim isai. Ezɨ Iso ruarimɨn ikegha ngun izi. ");
INSERT INTO msy2020_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Egha mɨtiriam puv ana aghezɨma a kamagh Jekop mɨgei, “Mɨtiriam puv nan azi. Nɨ dɨparsɨzir aghevir nɨ isamizir matam na danɨngigh.” Kamaghɨn me gɨn “Iso,” ziar igharazim, “Idom,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ezɨ Jekop an akam ikaragha ghaze, “Nɨ faragh nɨ otarir ivariamɨn mɨn itir danganir kam, na danɨngightɨ, kɨ gɨn dɨparsɨzir kam nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezɨ Iso ghaze, “A dera. Kɨ ovengamin dughiam roghɨra ize, ezɨ kɨ otarir ivariamɨn itir danganim a manmaghɨn nan akurvagham?” ");
INSERT INTO msy2020_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ezɨ Jekop ghaze, “Nɨ faragh Godɨn akakagh guizbangɨra na mɨkɨm suam, nɨ uan danganim na danɨngam.” Ezɨ Iso guizbangɨra mɨgɨa, egha uan danganir an otarir ivariamɨn itim isa Jekop ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ezɨ Jekop bret ko nguezibar dɨparsɨzir a isamizim isa a ganɨngi. Ezɨ Iso anemegha gɨvagha pura dɨkavigha ghu. Ezɨ arazir kam kamagh an aka, an otarir ivariamɨn itir danganim pura bizimɨn mɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ezɨ dughiar kamɨn Kenanɨn nguazimɨn mɨtiriar ekiam otozɨ dagheba bar otefe, ezɨ mɨtiriar kam mɨtiriar faragha Abrahamɨn dughiamɨn otozim ko magh ghu. Ezɨ Aisak dɨkavigha Gerarɨn atrivim Abimelek bagha ghu, a Gerarɨn nguibar ekiamɨn ikia Filistiabar atrivimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ezɨ Ikiavɨra Itir God Aisak batogha a mɨgɨa ghaze, “Nɨ Isipɨn mangan markɨ. Nɨ kaghɨra ikɨtɨ, kɨ danganir nɨ ikiamimɨn gun nɨ mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Nɨ nguazir kam pura guraghav itir gumazimɨn mɨn a daperaghtɨ, kɨ nɨ ko ikɨ egh deragh nɨ damuam. Egh kɨ nguazir kaba bar nɨ ko nɨn ovavir boribar anɨngam, eghtɨ akar dɨkɨrɨzir gavgavir kɨ nɨn afeziam Abraham koma amizim, a guizbangɨn otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Egh kɨ nɨn ovavir boribar amightɨ, me bar avɨrasemegh men avɨrim mɨkovezibar mɨn ganam. Eghtɨ kɨ nguazir kaba bar me danɨngam. Kamaghɨn amizɨ, nɨn ovavir boriba bangɨn kɨ nguazir kamɨn itir nguibabar gumazamiziba bar deravɨra me damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Guizbangɨra, Abraham nan akam baregha, uaghan nan Akar Gavgaviba ko arazir kɨ ifongeziba ko nan Arazir a ganɨngizir maba sara gɨn ghuzir bizir kam bagh, kɨ deravɨra me damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ezɨ Aisak Gerarɨn nguibamɨn ti. ");
INSERT INTO msy2020_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ezɨ nguibar kamɨn gumaziba an amuim bagha an azai, ezɨ a ghaze, “Kar nan amizim.” An atiatigha, kamaghɨn mɨgeir puvatɨ, “Kar nan amuim.” An nɨghnɨzim kamaghɨn iti, “Rebekan ganganiba bar derazɨ, gumazir kaba a inisɨ nɨghnɨgh, egh a bagh na mɨsueghtɨ kɨ aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Egha Aisak mong dughiar ruarimɨn ike, ezɨ dughiar mamɨn Abimelek, Filistiabar atrivim uan dɨpenimɨn winduan gari, Aisak uan amuim Rebeka gifongegha a muigha a ko ikararai. ");
INSERT INTO msy2020_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ezɨ Abimelek Aisakɨn diagha a mɨgɨa ghaze, “Kar ti nɨn amuim! Ezɨ nɨ manmaghsuavɨra ghaze, ‘Kar nan amizim?’ ” Ezɨ Aisak a ikaragha ghaze, “Kɨ nɨghnɨzir kam iti, kɨ suam, a nan amuim, eghtɨ gumaziba a bagh na mɨsueghtɨ kɨ aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ezɨ Abimelek ua ghaze, “Nɨ arazir manamrama e gami? En gumazitam nɨn amuim ko akuizɨ, e osɨmtɨzir ekiamɨn ikeghai! Guizbangɨra an a ko dakuightɨ, osɨmtɨzir kamɨn mɨngarim a nɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Egha gɨn Abimelek akar gavgavim gumazamizibav gɨa ghaze, “Gumazitam gumazir kam o an amuim arazir kuratamɨn a damigh, egh ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ezɨ Aisak azenir ekiamɨn ingarigha dagheba opari. Ezɨ Ikiavɨra Itir God an akuragha deragha a gami. Kamaghɨn an azenimɨn dagheba bar avɨraseme. ");
INSERT INTO msy2020_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","A bizir avɨrim ikia egha gumazir ekiam gava. ");
INSERT INTO msy2020_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","A sipsipba, bulmakauba ko ingangarir gumazir avɨriba iti, ezɨ Filistiaba naviba an ikufi. ");
INSERT INTO msy2020_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Egha me nguaziba inigha Abrahamɨn ingangarir gumaziba fomɨra kuizir mozir paba apeme. ");
INSERT INTO msy2020_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ezɨ gɨn Abimelek Aisak mɨgɨa ghaze, “Nɨ en kantri ategh mangɨ. Nɨ datɨrɨghɨn gavgavir ekiam iti, ezɨ e nɨn apengan iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kamaghɨn amizɨ, Aisak nguibar kam ategha ghua Gerarɨn danganir zarimɨn apera. ");
INSERT INTO msy2020_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abraham faragha mozir paba danganir kamɨn dagh kui. Ezɨ an aremezɨ dughiamɨn gɨn Filistian gumaziba mozir par kaba apeme. Ezɨ datɨrɨghɨn Aisak mozir par kaba uam adagh kuigha, ziar an afeziam faragha dagh anɨngiziba ua dagh arɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ezɨ dughiar mamɨn Aisakɨn ingangarir gumaziba, danganir zarir kamɨn mozir par mam gɨkuizɨ dɨpar aghuim oto. ");
INSERT INTO msy2020_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ezɨ Gerarɨn bulmakaubar garir gumaziba, Aisakɨn bulmakaubar garir gumaziba adogha ghaze, “Kar en mozir pam.” Ezɨ Aisak nɨghnɨgha ghaze, gumazir kaba a ko uari adoghodoke, kamaghɨn a mozir par kam dɨbora ghaze, “Uari Adoghodosi.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ezɨ Aisakɨn ingangarir gumaziba mozir par igharazim gɨkui, ezɨ me mozir par kam bagha uaghan uari adosi. Ezɨ Aisak mozir par kam ziam, “Apanim gamir arazim,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Egha gɨn Aisak danganir kam ategha egha mozir par igharazim gɨkui. Ezɨ dughiar kamɨn gumaziba uam a bagha uari adozir puvatɨ. Ezɨ Aisak ghaze, “Ikiavɨra Itir God deragha e gami, eghtɨ e datɨrɨghɨn nguazir kamɨn deragh daperagh egh bizir avɨriba kagh ikiam.” Egha a mozir pam ziar kam a gatɨ, “Dabirabim derazir danganim.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Egha gɨn Aisak nguibar kam ategha ghua Berseban nguibamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ezɨ dɨmagarir kamɨn Ikiavɨra Itir God a batogha ghaze, “Kɨ nɨn afeziam Abrahamɨn God. Kɨ nɨ ko iti, kamaghɨn nɨ atiatingan markɨ. Kɨ uan ingangarir gumazim Abraham, bar a gifonge, kamaghɨn kɨ deragh nɨ damu, egh nɨn ovavir boribar amutɨ me bar avɨrasemegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ezɨ Aisak ofa gamir dakozim, danganir kamɨn an ingarigha Ikiavɨra Itir Godɨn ziam fe. Egha gɨn a danganir kamɨn uan purirpenibar nguibam aghuizɨ an ingangarir gumaziba mozir par mam gɨkui. ");
INSERT INTO msy2020_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ezɨ dughiar kam Abimelek Gerarɨn nguibam ategha Aisak bagha ize. Ezɨ Ahusat, a gumazir nɨghnɨziba Abimelek ganɨdim, ko Fikol Abimelekɨn mɨdorozir gumazibar faragha zuir gumazim, aning a ko ize. ");
INSERT INTO msy2020_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ezɨ Aisak men azara, “Ia manmaghsua na bagha izi? Ia fomɨra nan atarigha uan nguazimɨn na batoke?” ");
INSERT INTO msy2020_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ezɨ me a ikaragha ghaze, “E datɨrɨghɨn kamagh fogha gɨfa, Ikiavɨra Itir God nɨ ko ti. Egha en ifongiam, e bar moghɨra pɨn akagh guizbangɨra mɨkɨm egh akam akɨram. Eghtɨ akar dɨkɨrɨzir gavgavir kamɨn aven mɨgɨrɨgɨar kam ikiam, ");
INSERT INTO msy2020_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","nɨ pazɨ e damuan markɨ. Nɨ fo, e fomɨra arazir kuratam nɨ gamizir puvatɨ. E arazir aghuibara nɨ gami. Nɨ en nguazim ataghɨrazir dughiam, e nɨn amamangatɨzɨ, nɨ navir amɨrizim sara ghu. E datɨrɨghɨn gari, Ikiavɨra Itir God bar deravɨra nɨ gami.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ezɨ Aisak me bagha isar ekiam gamizɨ, me dagheba apa egha dɨpaba api. ");
INSERT INTO msy2020_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Egha amɨmzaraghan me dɨkavigha akar gavgavim akɨra ghaze, men dabirabim Aisak ko deragham. Ezɨ Aisak ghaze, “Ia navir amɨrizim sara mangɨ.” Ezɨ me anetegha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ezɨ dughiar kamra Aisakɨn ingangarir gumaziba iza kamaghɨn a mɨgei, “E mozir par mam gɨkuizɨ dɨpam a gizɨvagha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ezɨ Aisak mozir par kam ziam, “Siba,” a gatɨ. Egha iza datɨrɨghɨn me nguibar kam Berseba a garɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ezɨ Iso 40plan azeniba ikia Juditɨn iti. An afeziam, Beri, a Hitian gumazir mam. Egha Iso uaghan Basematɨn iti. An afeziam Elon, a Hitian gumazir mam. ");
INSERT INTO msy2020_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ezɨ amizir kamning amir araziba, Rebeka ko Aisak gamizɨ, aningɨn navimning ikuvigha bar oseme. ");
INSERT INTO msy2020_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ezɨ dughiar kamɨn Aisak ghurigha an damaziba ikufi. Ezɨ a uan otarir ekiam Ison diazɨ a izima an a mɨgɨa ghaze, “Nan otarim.” Ezɨ Iso a ikaragha ghaze, “Kɨ kati.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ezɨ Aisak ghaze, “Nɨ nan gan, kɨ bar ghurigha ovengamin dughiam bar roghɨra ize. ");
INSERT INTO msy2020_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kamaghɨn nɨ uan asɨziba burir barir pim ko bariba inigh ruarimɨn mangɨ, egh na bagh asɨzitam batogh a mɨsokegh. ");
INSERT INTO msy2020_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Egh na bagh asɨzim isamigh dagher aghuir kɨ ifongezim inigh na bagh izɨ. Eghtɨ kɨ anemegh deravɨra nɨ damigh egh gɨn ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ezɨ dughiar kamɨn Aisak Iso mɨgeima Rebeka oraki. Ezɨ Iso asɨzibar amuasa ghuzɨ, ");
INSERT INTO msy2020_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka kamagh Jekop mɨgei, “Kɨ datɨrɨghɨrama orazi, nɨn afeziam kamagh Iso mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","nɨ na bagh asɨzitam inigh izɨ na bagh a isamigh. Eghtɨ kɨ aneremeghɨva, Ikiavɨra Itir Godɨn damazimɨn deragh nɨ damighvɨrama, egh gɨn ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Egha Rebeka maghɨra kamaghɨn mɨgei, “Nan otarim, nɨ na baregh egh bizir kɨ nɨ mɨkɨmamim na damu. ");
INSERT INTO msy2020_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Nɨ mangɨ memen igiar pumuning inigh izɨ, eghtɨ kɨ aning isamighɨva nɨn afeziam bar ifongezɨ moghɨn a bagh dagher aghuiba isamam. ");
INSERT INTO msy2020_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Eghtɨ nɨ a inigh uan afeziam bagh mangɨtɨ an anemam, egh deragh nɨ damighvɨrama, gɨn ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ezɨ Jekop kamagh uan amebam mɨgei, “Nɨ kamagh fo Iso a gumazir arɨzɨvatarim, ezɨ nan mɨkarzim arɨzɨvatarizir pu. ");
INSERT INTO msy2020_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nan afeziam nan suighsuigh egh fogham, kɨ a gifari, egh a deravɨra na damuan fɨrɨn, a ua na gasɨghasigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ezɨ an amebam ghaze, “Nan otarim, nɨ, kɨ nɨ mɨgei moghɨn damu. Egh mangɨ na bagh memening inigh. Bizir nɨ gasɨghasɨghamba, da nɨ giran kogham, da na giram, nɨ puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ezɨ a ghua aning inigha egha iza uan amebam ganɨngi, ezɨ Rebeka an afeziam damasa bar ifongezɨ moghɨrama a dagheba isai. ");
INSERT INTO msy2020_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekan otarir ekiam Iso, a faragha uan korotiar aghuiba isa amebamɨn purirpenim gatɨzɨ da iti. Ezɨ datɨrɨghɨn Rebeka da inigha uan otarir dozim Jekop gaghui. ");
INSERT INTO msy2020_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Egha a memen igiabar arɨziba an agharibagh arigha, an tuemɨn danganir arɨziba puvatɨzibagh aghui. ");
INSERT INTO msy2020_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Egha Rebeka dagher isɨngtɨzir kaba ko bretɨn tueziba isa Jekop ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ezɨ Jekop uan afeziam bagha ghuava an dɨa ghaze, “Afeziam!” Ezɨ an a ikaragha ghaze, “Nɨ otarim manam, Iso o Jekop?” ");
INSERT INTO msy2020_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jekop a ikaragha ghaze, “Kɨ nɨn otarir ivariam Iso. Kɨ nɨ mɨkemezɨ moghɨrama amigha gɨfa. Ezɨ nɨ dɨkavigh kɨ nɨ bagha inigha izezir asɨzim amegh egh deragh na damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ezɨ Aisak ghaze, “Nan otarim, nɨ manmaghɨra zuamɨra asɨzir kam bato?” Ezɨ Jekop ghaze, “Ikiavɨra Itir God, nɨn God nan akurazɨ kɨ a bato.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ezɨ Aisak a mɨgɨa ghaze, “Nɨ nan boroghɨn izɨtɨ, kɨ nɨn suighsuigh foka, nɨ guizbangɨra Iso, o puvatɨ?” ");
INSERT INTO msy2020_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ezɨ Jekop sɨvagha uan afeziamɨn boroghɨn ghu, ezɨ an an suigha ghaze, “Nɨn tiarim a Jekopɨn tiarimɨn mɨrara mɨgei, ezɨ nɨn aghariba kɨ dar suigha dar barazi, da mati Ison aghariba.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ezɨ an aghariba Ison agharibar mɨn arɨzɨvatari, ezɨ Aisak kamaghɨn fozir pu, kar Jekop. Kamaghɨn amizɨ a deragha a damuasa, ");
INSERT INTO msy2020_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","egha uam an azara, “Nɨ guizbangɨra Iso, o puvatɨ?” Ezɨ Jekop a ikaragha ghaze, “Are, kɨrara.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ezɨ Aisak ghaze, “Nɨ na bagh asɨzitaba inigh izɨ. Kɨ damegh gɨvagh egh arazir aghuimɨn nɨ damuam.” Ezɨ Jekop asɨziba a ganigha egha wainɨn dɨpar maba sarama a ganɨngizɨ an api. ");
INSERT INTO msy2020_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ezɨ an afeziam a mɨgɨa ghaze, “Nan otarim, nɨ nan boroghɨn izɨ nan toregh.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ezɨ an an torima Aisak an korotiabar mughuriam baregha deravɨrama a gami. Egha ghaze: “Aia, nan otarimɨn mughuriam mati dagher azenimɨn mughuriam! Azenir kam deraghasa Ikiavɨra Itir God deraghavɨram a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kɨ Godɨn azai, a dɨmagaribar ghuariabar dɨpabar amutɨ da izighirɨ nɨn azenibagh izɨtɨ da aghung dagher avɨriba ikɨ. Kɨ an azai, a wit ko wainɨn avɨriba nɨ danɨng. ");
INSERT INTO msy2020_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kɨ kamaghɨn Godɨn azai, nguazimɨn itir gumazamiziba nɨn ingangarir gumazibar mɨn ikiam, eghtɨ kantrin mabar gumazamiziba nɨn apengan ikiam. Eghtɨ nɨ uan aveghbuaba me gativagh men ganam. Eghtɨ nɨn amebamɨn ovavir boriba nɨn apengan ikiam. Eghtɨ gumazir paza nɨ damuasa Godɨn azangsɨziba, kɨ kamaghɨn Godɨn azai, eghtɨ a me gasɨghasigham. Eghtɨ gumazir deragh nɨ damusɨ nɨ bagha Godɨn azangsɨziba, kɨ kamaghɨn Godɨn azai, a uaghan deraghvɨram me damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ezɨ Aisak deragha Jekop gamizɨ, a zuima, dughiar kamra an avebam Iso asɨzibagh amigha uamategha izi. ");
INSERT INTO msy2020_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Egha a uaghan dagher isɨngtɨzir mabagh amigha uan afeziam bagha da inigha izi. Egha ghaze, “Afeziam, nɨ dɨkavigh daperagh asɨzir kɨ nɨ bagha inigha izir katabar ameghɨva, deraghvɨra na damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ezɨ Aisak an azara, “Nɨ tina?” Ezɨ a ghaze, “Kɨ nɨn otarir ivariam Iso.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Ezɨ Aisak dɨgavir kuram gamigha an mɨkarzim nɨgha, an azara, “Ezɨ kar ti tinara faragha asɨzir mam mɨsuegha na bagha a inigha ize? Ezɨ kɨ anemegha gɨvazɨ nɨ oto. Ezɨ kɨ deragha a gamigha gɨfa, eghtɨ da a ko ikɨ mamaghɨra ikiam!” ");
INSERT INTO msy2020_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ezɨ Iso kamaghɨn oregha, a bar puvɨram azia ghaze, “Afeziam, uaghan deragh na damigh!” ");
INSERT INTO msy2020_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ezɨ Aisak a ikaragha ghaze, “Nɨn dozim iza na gifarazɨ kɨ deraghavɨram a gami.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezɨ Iso ghaze, “A faragha na gifaragha, datɨrɨghɨn ua na gifara. Ezɨ an ziam Jekop. Ziar kam Jekop an amir arazibar mɨrara ghu. A faragha kɨ otarir ivariamɨn mɨn itir danganim na dama a ini, egha datɨrɨghɨn nɨ gifarazɨ nɨ deragha a gami. Ezɨ Afeziam, manmaghɨn ami, nɨ deraghvɨra na damuamin bizitam ua ikɨtɨ, nɨ a inigh na danɨngigh?” ");
INSERT INTO msy2020_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ezɨ Aisak a ikaragha ghaze, “A nɨ gativaghamin gavgavim kɨ a ganigha gɨfa, egha kɨ ghaze, nɨn adarazi bar an ingangarir gumazibar ikiam. Egha kɨ witɨn avɨriba ko wainɨn avɨriba a ganigha gɨfa. Ezɨ nan otarim, kɨ datɨrɨghɨn nɨ bagh damuamin biziba bar puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezɨ Iso uan afeziam mɨgɨavɨra ikia ghaze, “Nɨ ti bizir aghuir vamɨra iti? Nɨ God ko mɨkɨmtɨ, a uaghan deragh na damigh.” A kamagh mɨgɨa egha bar puvɨrama azi. ");
INSERT INTO msy2020_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ezɨ Aisak a mɨgɨa ghaze: “Nɨn nguibam, nguazir dagher aghuiba itibar saghon ikiam. Eghtɨ dɨmagaribar ghuariar dɨpaba nɨn azenibagh iran kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Egh nɨ uan mɨdorozir sabamɨn amodoghɨn mɨsogh daghebar amɨ, egh dabirabir aghuim buriam. Egh nɨ uan dozimɨn apebamɨn ikiam. Egh gɨn nɨ uabɨ abigh egh an apengan ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso fo, Jekop ifarazɨ, Aisak deragha a gami. Ezɨ bizir kamɨn Iso osemegha Jekopɨn apanimɨn iti. Egha nɨmɨra ghaze, “Nan afeziam ovengamin dughiam roghɨra izi. An oveghtɨ e anefaghɨva, an ikegh gɨvaghɨva, kɨ Jekop mɨsueghtɨ an aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ezɨ Rebeka Ison mɨgɨrɨgɨar kam baregha, Jekop bagha akam amadagha ghaze, “Nɨ orakigh, nɨn avebam Iso bar nɨn osemegha ikarvagham tuavim buria, nɨ mɨsueghtɨ nɨ aremeghasa nɨghnɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kamagh amizɨ, nan otarim, nɨ kɨ nɨ mɨgei moghɨra nɨ bizibar amu. Nɨ zuamɨra dɨkavigh nan tuebam Labanɨn bighan Haranɨn nguibamɨn mangɨ, ");
INSERT INTO msy2020_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","egh a ko ikɨ mangɨtɨ nɨn avebamɨn navim mar amɨragh. ");
INSERT INTO msy2020_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Eghtɨ a nɨ a gamizir bizir kam gɨn amadaka. Eghtɨ gɨn kɨ gumazitam amadaghtɨ a nɨ bagh izɨ ua nɨ inigh izam. Guizbangɨra, nan otarimning dughiar vamɨran ovengan kɨ aghua.” ");
INSERT INTO msy2020_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ezɨ Rebeka Aisak mɨgɨa ghaze, “Kɨ Hitian amizir Ison itir kamningɨn aghua. Egh kɨ ti oveghtɨ Jekop uaghan Hitian amizir roghɨra itir katamɨn ikɨtɨ deragham.” ");
INSERT INTO msy2020_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ezɨ Aisak Jekopɨn diagha ghaze, “God nɨ ko mangɨ deragh nɨ damu.” Egha Aisak akar gavgavim a ganɨga ghaze, “Nɨ Kenanian amizitamɨn ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nɨ datɨrɨghɨra dɨkavigh Mesopotemian nguazimɨn mangɨ, kar nɨn amebamɨn afeziam Betuelɨn nguibam. Egh uan amebamɨn tuebam Labanɨn guivitamɨn ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Eghtɨ Gavgaviba Bar Itir God deraghvɨra nɨ damu, egh borir avɨriba nɨ danɨngtɨ, nɨ kantrin avɨribar gumazamizibar inazir afeziamɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Eghtɨ God deravɨra nɨ ko nɨn ovavir boribar amu, mati a faragha Abraham gamizɨ mokɨn. Nɨ fo, nguazir nɨ aperaghav itir kam, nɨ mati nguibar igharazimɨn gumazimɨn mɨn an ikia an apera. Nguazir kam God fomɨra Abraham ganɨngi. Egh God uabɨ gɨn a isɨ nɨ danightɨ, nɨ a iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Egha Aisak kamagh mɨgɨa, Jekop amadazɨma a Laban bagha Mesopotemian ghu. Laban an Aramian gumazim, a Betuelɨn otarim. Ezɨ Laban Rebekan tuebam, Rebeka a Iso ko Jekopɨn amebam. ");
INSERT INTO msy2020_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezɨ Iso kamaghɨn fo, Aisak Jekop deravɨrama a gamigha egha anemadazɨma a Mesopotemian amizitamɨn ikiasa zui. A uaghan kamagh oraki, Aisak deravɨrama a gamua a mɨgɨa ghaze, a Kenanian amizitamɨn ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Egha a uaghan kamaghɨn fo, Jekop uan afeziam ko amebamɨn akaba baregha dar gɨn ghua Mesopotemian ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Egha Iso uaghan kamaghɨn fo, an afeziam Kenanian amizibar gari, me bar an damazimɨn derazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ezɨ Iso, Abrahamɨn otarim Ismael bagha ghua an guivim Mahalat inigha an iti. Ezɨ Mahalat ana Nebaiotɨn buaramizim, egha a Ison amuir mɨkezimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ezɨ dughiar kamɨn Jekop Berseban nguibam ategha egha Haranɨn nguibamɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","A zuima amɨnim pɨrizɨma a danganir mam gakui. Egha dagɨar mam inigha uan dapanimɨn aghoroghava akui. ");
INSERT INTO msy2020_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Egha an akua irebamɨn adidiar mamɨn gari. An otevir mam nguazimɨn itima an otevir mam overiamɨn iti. Ezɨ Godɨn enselba an ghuavanaga izaghiri. ");
INSERT INTO msy2020_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ezɨ Ikiavɨra Itir God an boroghɨn tughav iti. Egha a kamaghɨn mɨgei, “Kɨ Ikiavɨra Itir God, nɨn inazir afeziam Abraham ko Aisakɨn God. Kɨ nguazir nɨ irɨghav itir kam nɨ ko nɨn ovavir boribar anɨngam. ");
INSERT INTO msy2020_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eghtɨ nɨn ovavir boriba nguazir mɨnemniabar mɨn bar avɨrasemegham. Egh men nguazir, aruem anadi naghɨn ko, aruem uaghiri naghɨn ko, not ko, sautɨn itiba, me bar adagh isɨvagham. Eghtɨ nɨ ko nɨn ovavir boriba bangɨn, kɨ nguazimɨn itir kantribar gumazamiziba, bar deraghvɨra me damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Nɨ oragh, kɨ nɨ ko ikiam, eghtɨ nɨ managh mangam, kɨ nɨ geghuv, egh ua nɨ inigh nguazir kamɨn izam. Kɨ nɨ ateghan kogham, egh mangɨ bizir kɨ nɨ mɨkemeziba kɨ bar dar amigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ezɨ Jekop osegha dɨkavigha ghaze, “Bar guizbangɨra, Ikiavɨra Itir God danganir kamɨn iti, ezɨ kɨ bizir kam gɨfozir puvatɨ!” ");
INSERT INTO msy2020_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Egha an atiatigha ghaze, “Kɨ danganir kam bar an atiatingi. Kar Godɨn Dɨpenim. Kar Godɨn Nguibamɨn tiar akam!” ");
INSERT INTO msy2020_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Egha a bar mɨzaraghara dɨkavigha dagɨar a dapanimɨn aghorogha akuizim inigha anesara. Eghtɨ an ababanimɨn mɨn ikɨtɨ, gɨn a zurara an gan egh inɨrɨgham. Egha olivɨn borem a gingegha a isa God ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Egha danganir kam ziam, “Betel,” a gatɨ. (Me faragha danganir kamɨn itir nguibam dɨborogha ghaze, Lus.) ");
INSERT INTO msy2020_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ezɨ Jekop bar guizbangɨra mɨgɨa, God ko akar gavgavim akɨra ghaze, “Nɨ na ko ikɨ egh tuavir ruarir kɨ mangamin kamɨn na geghuv, egh dagheba ko korotiaba na danɨng, ");
INSERT INTO msy2020_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","egh nɨ deragh na geghuvtɨ kɨ uamategh uan afeziamɨn nguibamɨn mangɨ deragh otogham, eghtɨ nɨ Ikiavɨra Itir God, nɨ guizbangɨra nan God. ");
INSERT INTO msy2020_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Eghtɨ danganir kɨ dagɨam asarazir kam, a danganir e Godɨn ziam famin dɨpenimɨn mɨn ikiam, eghtɨ bizir kɨ itiba bar, kɨ 10plan akuabar da abigh egh 10ɨn vamɨra isɨ nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ezɨ Jekop ghuavɨra ikia ghua aruem anadi naghɨn itir gumazamizibar nguazimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Egha a tugha pura tintinibar gara ghua gari, sipsipɨn okoruar 3pla mozir par mamɨn mɨriamɨn ireghav iti. Ezɨ mozir par kam, sipsipɨn kaba anepi. Ezɨ dagɨar baravir mam mozir par kamɨn akam dukuaghav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Eghtɨ sipsipba bar mozir par kamɨn izeghtɨ, dar garir gumaziba dagɨar kam poegh dɨpam me danigh gɨvagh, dagɨam uam a puegh izɨ uam a dukuagham. ");
INSERT INTO msy2020_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ezɨ Jekop sipsipbar garir gumazibar azara, “Namakaba, ia nguibar manamɨn gumaziba?” Ezɨ me kamaghɨn a ikaragha ghaze, “E Haranɨn nguibamɨn gumaziba.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ezɨ a men azara, “Nahorɨn igiar borim, an ziam Laban, ia a gɨfo?” Ezɨ me ghaze, “Are, e a gɨfo.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ezɨ a men azara, “A deragha iti?” Ezɨ me ghaze, “A deragha iti. Nɨ gan, an guivim Resel uan sipsipba ko izi.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ezɨ Jekop ghaze, “Aruer ekiam ikiavɨra iti, ezɨ sipsipba inigh aven mangamin dughiam tɨgharɨ. Kamaghɨn ti deragham? Ia sipsipba dɨpam dar anigh egh da amadaghtɨ da mangɨ ua grazibar amɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ezɨ me ghaze, “E kamaghɨn damuan kogham, e ikɨ sipsipɨn okoruaba bagh mɨzuamtɨ da bar izeghtɨ, e dagɨam poeghtɨ, mozir pamɨn akam kuighirɨghtɨ, e dɨpam sipsipbar anɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ezɨ Jekop me ko mɨgɨavɨra itima, Resel uan afeziamɨn sipsipba ko izava oto. Resel, a sipsipbagh eghuvir amizim. ");
INSERT INTO msy2020_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ezɨ Jekop Reselɨn gari. An an amebamɨn tuebamɨn guivim, egha a Labanɨn sipsipbar ganigha, mozir pamɨn ghugha dagɨam poegha mozir pamɨn akam kui. Egha dɨpam uan amebamɨn tuebamɨn sipsipbagh anɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Egha Jekop Reselɨn toregha, maghɨram azi. ");
INSERT INTO msy2020_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Egha a mɨgɨa ghaze, “Kɨ nɨn afeziamɨn buaramizim Rebekan otarim.” Ezɨ Resel uan afeziam bagha ivegha ghua bizir kabar gun a mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ezɨ Laban orazi an buaramizimɨn otarim Jekop izima, a ivegha ghua a muigha, an toregha a inigha dɨpenimɨn ghu. Ezɨ Jekop bizir otiviziba bar dar gun Laban mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ezɨ Laban ghaze, “Bar guizbangɨra, ga anabar vamɨra.” Ezɨ Jekop a ko iakɨnir vamɨran bar an ike. ");
INSERT INTO msy2020_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ezɨ Laban Jekop mɨgɨa ghaze, “Nɨ guizbangɨra nan adarazir mav, ezɨ nɨ pura nan ingaran kɨ aghua. Nɨ manmaghɨn dagɨabagh ifonge?” ");
INSERT INTO msy2020_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban guivir pumuning iti, guivir ekiamɨn ziam Lea, ezɨ dozimɨn ziam Resel. ");
INSERT INTO msy2020_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea damazir aghuiba iti, ezɨ Resel Lea gafiragha an ganganiba bar dera. ");
INSERT INTO msy2020_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ezɨ Jekop Resel bar a gifuegha ghaze, “Kɨ 7plan azenibar nɨn ingarightɨ, nɨ Resel na danightɨ kɨ an ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ezɨ Laban ghaze, “Kamaghɨn deragham, kɨ a isɨ nɨ danɨngam eghtɨ gumazir igharazitam a inian kogham. Eghtɨ nɨ na ko ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ezɨ Jekop Resel iniasa 7plan azenibar ingari. A Resel bar a gifonge, kamaghɨn amizɨ, a 7plan azenir kabagh nɨghnɨzi da pura bizim. ");
INSERT INTO msy2020_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ezɨ 7plan azenir kaba gɨvazɨma Jekop kamagh Laban mɨgei, “Dughiam oto, nɨ uan guivim na danightɨ kɨ an ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ezɨ Laban amuir ikɨzimɨn isar ekiam gamigha, gumazamizir avɨribar diazɨ me ize. ");
INSERT INTO msy2020_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ezɨ dɨmagarir kamɨn, Laban Lea inigha Reselɨn danganim isa, Jekop bagha ghuzɨ, a dɨmangan poroghamiba uari koma akua amir arazimɨn a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ezɨ Laban ingangarir amizir mam an ziam, Silpa isa Lea ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ezɨ amɨnim dutuzɨ, Jekop a koma akuir amizir kamɨn gari, a Resel puvatɨ, kar Lea. Ezɨ a ghua Laban mɨgɨa ghaze, “Nɨ manmaghsua kamagh na gami? Kɨ Resel iniasa nɨn ingari. Ezɨ nɨ manmaghsua na gifara?” ");
INSERT INTO msy2020_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Ezɨ Laban ghaze, “En arazim kamaghɨn iti, guivir ekiam faragh pamɨn ikɨtɨ, gɨn guivir dozim pamɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Nɨ orarkɨtɨ amuir ikɨzimɨn isamɨn wigh mangɨ gɨvaghtɨ, kɨ Resel uaghan nɨ danɨngam. Eghtɨ nɨ 7plan azenir igharazibar ua ingarigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ezɨ Jekop an akam gifuegha, amuimɨn ikɨzir isamɨn dughiam ghua gɨvazɨ, Laban uan guivim Resel isa a ganɨngizɨ an an amuimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Egha Laban uan ingangarir amizir igharazir mam Bilha, isa uan guivim Resel ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ezɨ Jekop Resel koma akua, egha bar moghɨrama a gifonge, egha mong deragha Lea gifongezir puvatɨ. Egha Jekop, Laban ko 7plan azenir igharazibar ua ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ezɨ Ikiavɨra Itir God gari, Jekop deragha Lea gifongezir puvatɨ. Ezɨ a Lean akurazɨma a navim adai, ezɨ Resel navim adair puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ezɨ Lea navim asegha otarir mam bate. Egha a ghaze, “Ikiavɨra Itir God nan osɨmtɨzim gɨfogha gɨfa, ezɨ datɨrɨghɨn nan pam na gifuegham.” Egha otarim ziam “Ruben,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Egha gɨn a ua navim asegha otarir igharazim bate. Egha ghaze, “Ikiavɨra Itir God orasi, Jekop deragha na gifongezir pu, kamaghɨn, an otarir igharazim na ganɨngi.” Egha otarim ziam “Simeon,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Egha Lea ua navim asegha otarir mam bate. Egha ghaze, “Kɨ uan pam bagha otarir 3pla bategha gɨfa, kamaghɨn amizɨ, a datɨrɨghɨn bar moghɨra na gifuegh, na ko porogh egh zurara na ko ikiam.” Egha otarir kam ziam, “Livai,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Egha Lea ua navim asegha otarir igharazir mam uam a bate. Egha ghaze, “Kɨ dughiar kamɨn Ikiavɨra Itir Godɨn ziam fam.” Egha Lea otarim ziam, “Juda,” a gatɨ. Egha Lea dughiar kamɨn ua boritam batir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ezɨ Resel uabɨn gari, a boriba batir puvatɨ, egha uan avenamebamɨn gari a boriba batima, an navim ikufi. Ezɨ a Jekop mɨgɨa ghaze, “Nɨ boriba na danɨng. Puvatɨghtɨ, kɨ aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ezɨ Jekop Reselɨn atara ghaze, “God uabɨ nɨ navim asangan nɨn anogoroghezɨ, nɨ boriba isir puvatɨ. Kɨ Godɨn danganim inigh boriba nɨ danɨngan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ezɨ Resel ghaze, “Nan ingangarir amizim Bilha kara. Nɨ a ko dakuightɨ a boritam na bagh a inika. Eghtɨ tuavir kamɨn kɨ an apengan boribar amebamɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Egha Resel ingangarir amizim Bilha, inigha uan pam Jekop, an amuimɨn mɨn a ganɨngizɨ, an a koma akui, ");
INSERT INTO msy2020_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ezɨ Bilha navim asegha Jekop bagha otarir mam bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ezɨ Resel kamaghɨn mɨgɨa ghaze, “God nan nɨghnɨziba tuisigha gɨvagha egha nan arazim gifonge. Egha nan azangsɨzim baregha otarir mam na ganɨngi.” Egha Resel otarim ziam, “Dan,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ezɨ Bilha ua navim asegha Jekop bagha otarir mam uam a bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ezɨ Resel ghaze, “Kɨ uan avenamebam ko mɨgɨrɨgɨaba uaning adogha ghua kɨ datɨrɨghɨn a gafiragha gɨfa.” Egha borim ziam, “Naptali,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ezɨ Lea uabɨn gari, a ua boritaba inian kogham, egha uan ingangarir amizim Silpa inigha, a isa uan pam Jekop an amuimɨn mɨn a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ezɨ Silpa Jekop bagha otarir mam bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ezɨ Lea ghaze, “Kɨ bar angavsɨghɨn kamaghɨn amigha egha dera.” Egha ziam, “Gat,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ezɨ Silpa Jekop bagha borir igharazir mam uam a bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ezɨ Lea ghaze, “Kɨ bar akonge, eghtɨ amiziba bar na mɨkɨm suam, kɨ bar akongezir amizim.” Egha otarir kam ziam, “Aser,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ezɨ wit aghoramin dughiam otozɨ, Ruben witɨn azenimɨn ghua gari, tevsevir mam iti. Ezɨ amiziba an ovɨziba isa akavsiar arazim gamua da api, ezɨ an gavgavim men akurvazi, me boriba bati. Ezɨ Ruben dar ovɨziba inigha ghua uan amebam Lea ganɨngi. Ezɨ Resel Lea mɨgɨa ghaze, “Kɨ gari nɨn otarim tevsevir ovɨzir kaba inigha ize. Nɨ taba na danɨngigh?” ");
INSERT INTO msy2020_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ezɨ Lea a ikaragha ghaze, “Nɨ nan pam inigha gɨvagha, datɨrɨghɨn nan otarim inigha izezir tevsevir ovɨziba iniasa.” Ezɨ Resel ghaze, “Nɨ tevsevir ovɨzitaba na danigh, datɨrɨghɨn dɨmangan Jekop ko dakuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ezɨ guaratɨzimɨn, Jekop azenibar ikegha izima, Lea ghua tuavimɨn a batogha egha ghaze, “Kɨ tevsevir ovɨzir nan otarim inigha izeziba isa nɨ givezegha gɨfa. Kamaghɨn, nɨ dɨmangan na ko dakuam.” Ezɨ Jekop dɨmangan Lea koma akui. ");
INSERT INTO msy2020_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ezɨ God Lean azangsɨzim baraki, ezɨ a navim asegha otarir namba 5 Jekop bagha a bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ezɨ Lea ghaze, “Kɨ uan ingangarir amizim uan pam ganɨngizɨ, God ivezir aghuimɨn na gami.” Egha borir kam ziam, “Isakar,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ezɨ Lea ua navim asegha Jekop bagha otarir namba 6 bate. ");
INSERT INTO msy2020_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Egha a ghaze, “God bizir bar aghuim na ganɨngi. Kɨ uan pam bagha borir 6pla bategha gɨfa, eghtɨ datɨrɨghɨn a ziar ekiam na danɨngam.” Egha borim ziam, “Sebulun,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Egha gɨn Lea guivir mam bategha ziam, “Daina,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ezɨ God Resel gɨnɨghnɨsi. Egha Reselɨn azangsɨzim baregha an navir averiam akɨri, eghtɨ a boritam batam. ");
INSERT INTO msy2020_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ezɨ Resel navim asegha otarir mam bate. Egha ghaze, “God nan osɨmtɨzim akɨrizɨma kɨ uam aghumsɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ezɨ nan ifongiam Ikiavɨra Itir God ua otaritam na danɨngam.” Egha borir kam ziam, “Josep,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Resel Josep bategha gɨvazɨ Jekop kamagh Laban mɨgei, “Kɨ amizir kaba ko boribagh ivezasa ingangarir ekiabagh amigha gɨfa. Nɨ na ateghtɨ, kɨ ua uan nguibamɨn mangam. Nɨ fo, nɨn ingangariba kɨ bar deraghavɨram a dagh amigha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ezɨ Laban a mɨgɨa ghaze, “Ga uaning inigha iti. Egh nɨ teghtɨ kɨ nɨ mɨkemeka, kɨ kamaghɨn uan aseba ko ingara egha men azaragha fo, nɨ na ko itir bizimɨn, Ikiavɨra Itir God bar deravɨra na gami.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Egha Laban ua kamaghɨn mɨgei, “Nɨ manmaghɨn ivezim inisɨ deragh na mɨkɨmtɨ kɨ nɨ givezam.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ezɨ Jekop ghaze, “Nɨ uabɨ kɨ amizir ingangaribagh fo. Nɨ uabɨ fo, kɨ nɨn sipsipba ko asɨzir igharaziba sara eghuvi da bar avɨraseme. ");
INSERT INTO msy2020_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nɨ fomɨra sipsipɨn avɨriba itir puvatɨ. Da bar avɨrasemezir puvatɨ. Ezɨ kɨ datɨrɨghɨn nɨ ko iti, nɨn sipsipba bar avɨraseme. Ezɨ Ikiavɨra Itir God na ko ikia, nan ingangaribar nan akurvagha nɨn ingangariba deragha dagh ami. Ezɨ datɨrɨghɨn kɨ kamaghsua, nan biziba igharagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ezɨ Laban kamaghɨn Jekopɨn azara, “Kɨ bizir tizim nɨn ingangarimɨn ivezimɨn mɨn nɨ danɨngam?” Ezɨ Jekop ghaze, “Kɨ dagɨaba inian aghua. Nɨ nan nɨghnɨzim gifueghtɨ kɨ nɨn sipsipbagh eghuvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Egh kɨ datɨrɨghɨn mangɨ deragh nɨn sipsipba ko memebar ganigham. Egh kɨ sipsipɨn nguzir pɨziba ko, sipsipɨn ekiar mɨkarzir dighdiriba itiba ko, memen mɨkarzir dighdiriba, kɨ uan ivezim bagh ada iniam. ");
INSERT INTO msy2020_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Egh nɨ gɨn uabɨ ifongegh dughiatamɨn izɨ, nan memeba ko sipsipbar gan, dar taba pighan kogham o dighdiriba dar ikian koghtɨ, nɨ fogh suam, kɨ uan akamɨn gɨn ghuzir puvatɨgha ada okeme.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ezɨ Laban ghaze, “A ti deragham, e nɨ mɨgei moghɨra damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Egha dughiar kamra, Laban memen dighdiriba ko, sipsipɨn nguzir pɨziba bar da ini. Egha uan otaribav kemezɨ, me da inigha ghua danganir igharazimɨn da arɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ezɨ Laban uaghan me ko zui. Me aruer 3plan memen kaba ko, sipsipba ko, saghon ghua danganir mamɨn iti. Ezɨ Jekop Labanɨn sipsipba ko memen mabagh eghufi. ");
INSERT INTO msy2020_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Egha gɨn Jekop temebar aguaba inigha, vaghvagha dar inir maba afoghafogha da afɨrizɨ, da ghurghuri. Ezɨ maba iniba sara iti. ");
INSERT INTO msy2020_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Egha a temer aguar kaba isa asɨziba dɨpaba apir itarir ekiamɨn boroghɨn ada arɨsi. Eghtɨ memeba ko sipsipɨn amebaba dɨpamɨn izɨ dɨpam amɨva dar ganam. A fo, memeba ko sipsipba zurara iza dɨpam apa egha dar apuriba amebabagh azɨghazɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Egha dar apuriba dar amebaba temer aguar kabar boroghɨn me gazɨghazɨsi, ezɨ gɨn amebaba nguzir mɨkarzir dighdiriba itiba bati. ");
INSERT INTO msy2020_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ezɨ gɨn Jekop uan sipsipɨn nguziba isa danganir igharazim garɨki. Egha Labanɨn sipsipba ko memebagh amizɨ, da an sipsipba ko memen dighdiribar itir danganimɨn gari. Egha tuavir kamɨn, a ua bagha sipsip ko memen nguzir dighdirir avɨriba isi. Egha dagh amizɨ da Labanɨn sipsipba ko memeba ko itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ezɨ sipsipba ko memen aghuir gavgaviba uari gazɨghazɨghasava ami, a temer aguar kaba isa me dɨpaba apir itarir ekiamɨn boroghɨn da arɨsi. Ezɨ me ter aguar kabar gara egha uari gazɨghazɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ezɨ sipsip ko memen gavgaviba puvatɨziba uari gazɨghazɨzima a temer aguaba arɨzir puvatɨ. A kamagh ami sipsipba ko memen amɨraghmɨraziba, da Labanɨn naba. Ezɨ sipsipba ko memen gavgaviba, da Jekopɨn naba. ");
INSERT INTO msy2020_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jekop kamagh amigha bizir bar avɨrim iti. A sipsipɨn avɨriba, memeba, ingangarir gumaziba, ingangarir amiziba, donkiba ko kamelɨn avɨriba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Egha Jekop orazi, Labanɨn otariba kamaghɨn mɨgɨa ghaze, “Jekop en afeziamɨn biziba bar ada inigha, gumazir bizir avɨriba itimɨn mɨn iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ezɨ Jekop gari, Laban fomɨra a gifongezɨ moghɨn datɨrɨghɨn amir puvatɨ, egha uan arazibagh ira. ");
INSERT INTO msy2020_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ezɨ Ikiavɨra Itir God kamaghɨn Jekop mɨgei, “Nɨ uamategh uan afeziam ko nɨn adarazir nguibamɨn mangɨ. Eghtɨ kɨ nɨ ko ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ezɨ Jekop Resel ko Lea bagha akam amada, eghtɨ aning izɨ danganir an sipsipba itimɨn an ganam. ");
INSERT INTO msy2020_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ezɨ aning izezɨ Jekop kamagh aning mɨgei, “Kɨ gari guan afeziam fomɨra na gifongezir moghɨn ua na gami puvatɨ. Ezɨ nan afeziamɨn God a na ko iti. ");
INSERT INTO msy2020_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Gua vɨrara fo, kɨ guan afeziam bagha uan gavgaviba sara ingari, ");
INSERT INTO msy2020_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ezɨ a dughiar avɨribar na gifara nan ivezim giraghɨrasi. Ezɨ God na gasɨghasɨghasa an amamangatɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Laban faragha na mɨgɨa ghaze, kɨ sipsipba ko memen dighdiriba, bar uan ivezimɨn mɨn da iniam. Ezɨ memeba ko sipsipɨn kaba bar, nguzir dighdiribarama ote. Ezɨ a gɨn ghaze, kɨ meme ko sipsipɨn dighdirir ruariba itibara uan ivezimɨn mɨn da iniam. Ezɨ memeba ko sipsipba bar nguzir dighdirir ruaribarama ote. ");
INSERT INTO msy2020_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kamaghɨn, guan afeziamɨn memeba ko sipsipba, God ada isa na ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ezɨ memeba uari gazɨghazir dughiamɨn, kɨ irebamɨn gari, memen apurir dighdirir igharagha gariba, darara memen amebabagh azɨghazɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ezɨ Godɨn ensel irebamɨn nan dɨa ghaze, ‘Jekop.’ Ezɨ kɨ ghaze, ‘Kɨ kati.’ ");
INSERT INTO msy2020_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ezɨ a ghaze, ‘Nɨ gan. Memen apurir dighdirir igharagha gariba, darara memen amebabagh azɨghazɨsi. Kɨ Laban nɨ gamizir bizibar ganigha gɨvagha, egha bizir kam kamagh a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kɨrara, kɨ Godɨn kamnang Betelɨn nguibamɨn nɨ bato, danganir kamɨn, nɨ nan ziam fasa dagɨam asaragha borem a ginge. Egha guizbangɨra mɨgɨa na ko akar gavgavim akɨri. Ezɨ nɨ datɨrɨghɨra dɨkavigh uan biziba akɨrigh, egh nguibar kam ategh uamategh uan nguibamɨn mangɨ.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ezɨ Resel ko Lea akar kam baregha kamaghɨn a ikaragha ghaze, “Gan afeziam ga danɨngamin bizitam ua itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Gan afeziam kantrin igharazibar amizibar mɨn ga gami. A ga amadagha gan ivezim inigha, dagɨar kaba bar ada makuni. ");
INSERT INTO msy2020_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ezɨ bizir avɨrir God gan afeziam da inigha nɨ ganɨngiziba, mar ga ko gan boribar biziba. Egh God nɨ mɨkemezɨ moghɨra nɨ damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ezɨ Jekop dɨkavigha uan amuiroghboriba inigha kamelbagh afe. ");
INSERT INTO msy2020_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Egha uan sipsipba ko, memeba ko bizir igharazir a Mesopotemian iniziba sara me amangizɨma da men faragha ghue. Egha me bar Haranɨn nguibam ategha uamategha an afeziam, Aisak bagha Kenanɨn nguazimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Me mangasava amir dughiamɨn, Laban uan sipsipɨn arɨzibagh isasa ghu. Ezɨ Resel modogha uan afeziamɨn dɨpenimɨn garir asebar marvir guaba okeme. ");
INSERT INTO msy2020_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jekop arɨ mangasa, ifara deragha Aramian gumazim Laban mɨkemezir pu. Puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A modogha uan biziba bar da inigha zui. A Labanɨn nguibam ategha Yufretisɨn Fanem atugha, Gileatɨn mɨghsɨaba itir danganimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ezɨ dughiar pumuning gɨvazɨ dughiar mɨkezimɨn, gumaziba Laban mɨgɨa ghaze, Jekop arav ghugha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ezɨ Laban uan adarazi inigha men gɨn zui. Egha 7plan aruebar ghuavɨra ikia Gileatɨn mɨghsɨabar itir danganimɨn Jekop bato. ");
INSERT INTO msy2020_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ezɨ dɨmangan God irebamɨn otogha Aramian gumazim Laban mɨgɨa ghaze, “Nɨ Jekop, mɨgɨrɨgɨar kuratam o aghuitamɨn bar a damuan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Dughiar kam Jekop Gileatɨn mɨghsɨamɨn danganim uan purirpenibar ingarigha dar iti, ezɨ Laban uan adarazi ko kagh otogha uaghan Gileatɨn mɨghsɨamɨn danganim uan purirpenibar ingarigha dar iti. ");
INSERT INTO msy2020_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Egha Laban Jekop bagha ghua a mɨgɨa ghaze, “Nɨ manmaghsua nan guivimning, kalabuziar amizimningɨn mɨn aning inigha zui? ");
INSERT INTO msy2020_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nɨ manmaghsuavɨra na mɨkɨman aghuagha modogha nɨmɨram arav ghu? Nɨ izasa na mɨkemezɨ, kɨ uan adaraziv kemezɨ me ia bagha buaba ko gitabav soghezɨ ia bar akueghavɨra izeghai. ");
INSERT INTO msy2020_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Egha nɨ na ataghizɨ kɨ uan guivimning ko uan igiabar toregha dafarim me mɨkɨnizir puvatɨ. Kar nɨ bar arazir kuram na gami. ");
INSERT INTO msy2020_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kɨ arazir kuratam nɨ damuamin gavgavim iti, ezɨ nɨn afeziamɨn God dɨmangan nan anogorogha ghaze, ‘Nɨ Jekop mɨgɨrɨgɨar kuratam o aghuitamɨn a damuan bar markɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kɨ fo, nɨ uan nguibamɨn mangasa bar ifuegha na ataki. Egha nɨ tizim bagha nan dɨpenimɨn garir asebar marvir guaba okeme?” ");
INSERT INTO msy2020_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ezɨ Jekop a ikaragha ghaze, “Nɨ ua na dam uan guivimning inian kɨ atiatigha, kamaghɨn kɨ modogha arav ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nɨ uabɨ e getiva en gan, en tina nɨn marvir guaba inigha ara ize, nɨ a mɨsueghtɨ an aremegh. Kagh en adarazir damazibar nɨ biziba bar da buriva dar gan, egh bizir tizim a nɨn nanam, nɨ uamategh a inigh.” Jekop kamaghɨn fozir puvatɨ, Resel uan afeziamɨn asebar marvir guaba okeme. ");
INSERT INTO msy2020_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ezɨ Laban Jekopɨn purirpenimɨn aven ghugha biziba ghavkɨra dar gari. Egha gɨn Lean purirpenimɨn ghugha da buri. Egha a ingangarir amizimningɨn purirpenimningɨn aven ghugha marvir guaba bagha garava avenge. Egha men purirpeniba ategha Reselɨn purirpenimɨn aven ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Resel faraghavɨra uan afeziamɨn marvir guaba inigha, pilon a kamel gisɨn arɨgha apiaghirimɨn aven amadagha, pilon kam gisɨn apera. Ezɨ Laban purirpenimɨn aven ruiavɨra ikia ghua, egha uan marvir guabar apizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ezɨ Resel uan afeziam mɨgɨa ghaze, “Nan ekiam, kɨ, amiziba e uan arɨmariam gami, egha dɨkavan ibura, ezɨ nɨ nan apangkuvigh nan ataran markɨ.” Ezɨ a ruia ghua marvir guabar apizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ezɨ Jekopɨn muriam bar ikuvizɨ a Labanɨn atara ghaze, “Ai, kɨ nɨn bizir tizimra pazava a gamizɨ nɨ osemegha nan agɨragha izi? Kɨ arazir kurar manatam nɨ gami? ");
INSERT INTO msy2020_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nan biziba, nɨ bar da ghavkɨnigha dar ganigha gɨfa, egha nɨ uan bizir manamra gari a iti? Nɨ uan bizitamɨn gantɨ a ikɨtɨ, nɨ uan adarazi ko nan adarazir damazibar azenim datɨghtɨ, me vɨrara gan mɨgɨrɨgɨaba tuisɨgham. Egh fogh suam, tina guizɨn mɨgei, ezɨ tina ifari. ");
INSERT INTO msy2020_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Kɨ 20plan azenibar nɨ ko iti. Ezɨ nɨn sipsipɨn amebaba ko memen amebaba deravɨram oti. Ezɨ kɨ nɨn sipsipɨn apurir tam amezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ezɨ asɨzir atiaba nɨn sipsipba ko memebav sozi da ariaghiri, ezɨ kɨ tam inigha ghua nɨn akazir puvatɨ. Kɨ uabɨ sipsipba ko memen ariaghɨriba ikarvasi. Egha nɨ zurara uan bizir ovengeziba ikarvaghasa mɨgei. Egha uaghan arueba ko dɨmagaribar gumaziba okɨava atera zuir sipsipba ko memeba, nɨ uaghan da ikarvaghasa na mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Dughiar avɨriba aruem na mɨkarzim gaboi. Ezɨ dɨmagaribar ghuariaba na giri, ezɨ kɨ arugharugha egha deravɨram akuir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kɨ 14plan azenibar nɨn guivimning inigh aningɨn ikiasa ingari, egha kɨ 6plan azenibar nɨn sipsipba ko memen taba iniasa ingari. Kɨ 20plan azeniba bar, nɨ ko ikia egha nɨn ingari. Ezɨ nɨ nan ivezim dughiar avɨribar a giraghɨragha na ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Eghtɨ nan inazim Abrahamɨn God, a Godɨn nan afeziam Aisak an ziam fem. A na ko ikian koghtɨ, nɨ ti pura na amadazɨ kɨ uamategha ghughai. Ezɨ puvatɨ, God nan itir osɨmtɨzim ko kɨ amir ingangaribar gani, egha kamaghɨn a dɨmangan akar gavgavim nɨ ganɨngi.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ezɨ Laban a ikaragha ghaze, “Amizir kamning, kar nan guivimning, ezɨ aningɨn boriba uaghan nana. Ezɨ sipsipba ko memeba, da uaghan nana. Ezɨ bizir kagh itiba bar nananabara. Ezɨ kɨ bizir tizim damighvɨra uan guivimning ko, aningɨn boriba ko men anogorogham? ");
INSERT INTO msy2020_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kamaghɨn ga datɨrɨghɨn akar dɨkɨrɨzir gavgavim damuam. Egh bizitam atɨgh an gan akar ga dɨkɨrɨzir kam gɨnɨghnɨghvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Egha Jekop dagɨar ruarir mam inigha ababanimɨn mɨn anesara. ");
INSERT INTO msy2020_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Egha uan adaraziv kemezɨ me dagɨar maba inigha an boroghɨn deravɨra dar pozim mɨkɨni. Egha Laban ko Jekop aning uan adarazi ko, me dagɨar pozir kamɨn boroghɨn dagheba api. ");
INSERT INTO msy2020_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Egha Laban dagɨar pozir kam, ziam “Jegar Sahaduta,” a gatɨ, ezɨ Jekop ziam, “Galet,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Egha Laban Jekop mɨgɨa ghaze, “Dagɨar pozir kam, gan akar dɨkɨrɨzir gavgavir kamɨn ababanimɨn mɨn ikiam.” Ezɨ kamaghɨn danganir dagɨar pozim itir kam, an ziam Galet. ");
INSERT INTO msy2020_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Egha Laban uaghan ghaze, “Dughiar ga ua uaning inigh ikian koghamim, Ikiavɨra Itir God gan araziba deraghvɨra dar ganam.” Kamaghɨn danganir kam, me ziar igharazir mam uaghan a dɨbora ghaze Mispa. ");
INSERT INTO msy2020_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Egha Laban ua ghaze, “Nɨ nan guivimning pazɨ aning damu, o amizir igharazibar ikiam, egh nɨ deraghvɨra nɨghnigh, gumazitam gan gari, o gan gari puvatɨ, God bar uabɨra ga amir arazibagh fo.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Egha Laban ua Jekop mɨgɨa ghaze, “Nɨ dagɨar pozir kam ko dagɨar ruarir ababanimɨn mɨn kɨ asarazir kamɨn gan, aning gan tɨzimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dagɨar pozir kam ko dagɨar ruarir kam, aning gan akar dɨkɨrɨzimɨn ababanimɨn mɨn ikɨ nɨghnɨzim ga danɨngam. Eghtɨ nɨ a gitagh nan bighan izɨ na mɨsoghan kogham, eghtɨ kɨ a gitagh nɨn bighan mangɨ nɨ mɨsoghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Egha Laban me uan inazibar Godɨn ziam dɨborogha kamaghɨn mɨgei, “Abraham ko Nahorɨn God uabɨ, ga tuisɨgham.” Ezɨ Jekop, uan afeziam Aisak fer Godɨn ziam dɨbora, guizbangɨra mɨgɨa ghaze, an akar dɨkɨrɨzir gavgavir kamɨn gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Egha Jekop mɨghsɨar kamɨn asɨzir mam mɨsuegha an ofa gamigha gɨvagha uan adarazir diazɨma me iza an ofa gamizir asɨzir kamɨn tuziba ko dagheba saram api. Me amegha gɨvagha, dɨmangan mɨghsɨamram akui. ");
INSERT INTO msy2020_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Egha bar mɨzaraghara Laban uan guivimning ko uan igiar boribar toregha me ataghɨraghamin akar aghuiba me mɨgei. Egha me ategha uamategha uan nguibamɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ezɨ Jekop uan adarazi ko dɨkavigha zuima, Godɨn enselɨn maba me bato. ");
INSERT INTO msy2020_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","A men ganigha ghaze, “Ame. Danganir kam kar Godɨn danganim!” Egha danganir kam ziam, “Mahanaim,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Egha Jekop gumazir maba amadazɨ, me Iso mɨkɨmasa zui. Iso faragha Seirɨn nguazimɨn ghua apera, an ziar mam Idom. ");
INSERT INTO msy2020_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Egha mɨgɨrɨgɨar otevir kam damuasa me mɨkeme, “Gumazir ekiam Iso, kɨ nɨn ingangarir gumazim Jekop, nɨ bagha kamagh akam amadagha ghaze, kɨ bar dughiar ruarimɨn Laban ko ikegha gɨvagha egha datɨrɨghɨn uamateghasa. ");
INSERT INTO msy2020_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kɨ bulmakauba, donkiba, sipsipba, memeba, pura ingangarir gumaziba ko amiziba iti. Ezɨ nan gumazir ekiam, kɨ nɨn azai, nɨ navim na danɨngigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ezɨ gumazir akam inigha ghuezir kaba uamategha izegha, Jekop mɨgɨa ghaze, “E nɨn mɨgɨrɨgɨaba inigha nɨn avebam Iso, bagha ghu, ezɨ a tuavimɨn nɨ bativasa izi. Ezɨ 400plan gumaziba a ko izi.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ezɨ Jekop mɨgɨrɨgɨar kam baregha puvɨram atiatigha nɨghnɨzir avɨribagh ami. Egha uan gumazamiziba, sipsipba, memeba, bulmakauba, ko kamelba isa okoruar pumuningɨn me abɨki, egha danganir pumuningɨn me arɨki. ");
INSERT INTO msy2020_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","A kamaghɨn nɨghnɨsi, “Iso izɨ faragha itir darazigh asɨghasɨghtɨ, igharaz darazi aregham.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Egha Jekop kamaghɨn God mɨgei, “Nɨ nan inazim Abrahamɨn God, nɨ nan afeziam Aisakɨn God, O Ikiavɨra Itir God, nɨ nan azangsɨzim baragh. Nɨ faragha na mɨgɨa ghaze, kɨ uamategh uan nguibamɨn mangɨghtɨ nɨ deravɨra na damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Guizbangɨra, kɨ nɨn ingangarir gumazim, kɨ gumazir aghuim puvatɨ, ezɨ nɨ nan apangkuvigha egha nɨ mɨkemezɨ moghɨra deragha na gami. Kɨ Laban ko ikɨsɨ mangasa Jordanɨn Fanem atugha bizitam suiragha ghuzir puvatɨ, kɨ pura fidizir kɨnim suiragha ghu. Egha datɨrɨghɨn kɨ gumazamizir okoruar pumuning ko izi. ");
INSERT INTO msy2020_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kɨ kamaghsua nɨn azangsɨsi, nɨ deragh nan akuragh nan gantɨ, nan avebam Iso izɨ na ko mɨsoghan kogham. Kɨ kamaghɨn atiatigha ghaze, Iso ti izɨ e ko en amuiroghboriba sara mɨsogh bar e kuavaremegham. ");
INSERT INTO msy2020_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nɨ faragha na mɨgɨa ghaze, kɨ bar deravɨra nɨ damu ovavir borir avɨriba nɨ danɨngam. Eghtɨ men dɨbobonim ongarimɨn gigimɨn mɨn bar avɨrasemeghtɨ gumazitam da mengɨva avegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Egha Jekop dɨmangan akuima amɨnim tirazɨma, an asɨzir maba isa bizir aghuibar mɨn uan avebam Iso danɨngasa da amɨsefe. ");
INSERT INTO msy2020_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","A 200plan memen amebaba ko 20plan apuriba, sipsipɨn amebar 200pla ko 20plan apuriba, ");
INSERT INTO msy2020_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30plan kamelɨn amebar nguziba itiba, 40plan bulmakaun amebaba ko apurir 10pla, 20plan donkin amebaba ko apurir 10pla amɨsefe. ");
INSERT INTO msy2020_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Egha a vaghvagha asɨzir okoruar kabar ganasa ingangarir gumaziba amɨsevegha me mɨgɨa ghaze, “Ia nan faraghɨvɨra mangɨ. Egh ia asɨzir okoruar kabar gantɨ da mangɨva uarir boroghɨra mangan markɨ, danganir tizitaba, dar okoruabar tizibar arɨgh mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Egha a faragha zuir ingangarir gumazim mɨgɨa ghaze, “Nɨ mangɨtɨ, nan avebam Iso, tuavimɨn nɨn apigh kamagh nɨn azaragham, ‘Nɨ tinan ingangarir gumazim? Egha nɨ managh zui? Ezɨ asɨzir kaba, kar tinan naba?’ ");
INSERT INTO msy2020_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Eghtɨ nɨ kamaghɨn an akam ikaragh, ‘Asɨzir kaba, kar nɨn ingangarir gumazim, Jekopɨn naba. Nɨ Jekopɨn gumazir ekiamɨn mɨn itima, a bizir kaba bizir aghuibar mɨn nɨ bagha da amadazɨ da izi. Ezɨ Jekop uabɨ gɨn izi.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Egha Jekop mɨgɨrɨgɨar otevir kamra isa ingangarir gumazir namba 2, ko namba 3, ko ingangarir gumazir asɨziba bar adar gariba, vɨrara me mɨkeme. A ghaze, “Ia mangɨ Iso batogh, egh akar kamram a mɨkɨm. ");
INSERT INTO msy2020_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Egh ua kamagh deragh a mɨkɨm suam, ‘Nɨn ingangarir gumazim Jekop, en gɨrara izi.’ ” Jekop kamagh nɨghnɨsi, “Kɨ ti arazir kamɨn uan avebamɨn nɨghnɨzim giraghtɨ a na koma ataran kogham. Eghtɨ kɨ mangɨ a bativamin dughiamɨn a na ko navir aghuim ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Egha a bizir aghuiba amangizɨ da faragha ghue, ezɨ a uabɨ dɨmagarimɨn danganir me itimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ezɨ dɨmagarir arɨzir kamra Jekop dɨkavigha, egh uan amuir pumuning ko, uan amuir dozir pumuning ko, 11plan boriba inigha Jabokɨn dɨpam atugha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","A me inigha dɨpamɨn vongɨn ghua, egha uamategha ghugha uan ingangarir gumazibav kemezɨ, me an biziba inigha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ezɨ a uabɨra iti. Ezɨ gumazir mam dɨmangan otogha a ko, aning uaning mɨsoghav ikia ghuav itima amɨnim tira. ");
INSERT INTO msy2020_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Aning uaning mɨsogha ghua gumazir kam gari, Jekop anebɨra. Ezɨ gumazim Jekopɨn ruriar agharim mɨsoghezɨ, an ruriar agharim asiaghirɨzɨ, an suem an amɨra. ");
INSERT INTO msy2020_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Aning uaning mɨsogha ikia gumazir kam Jekop mɨgɨa ghaze, “Amɨnim tiasa bar gefi. Eghtɨ nɨ na ateghtɨ kɨ mangam.” Ezɨ Jekop an akam ikaragha ghaze, “Nɨ faragh God mɨkɨmtɨ a deragh na damutɨ, kɨ gɨn nɨ ateghtɨ nɨ mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ezɨ gumazir kam kamagh Jekopɨn azara, “Nɨn ziam tina?” Ezɨ Jekop a ikaragha ghaze, “Nan ziam Jekop.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ezɨ gumazir kam ghaze, “Datɨrɨghɨn nɨn ziam ua Jekop puvatɨ. Nɨ God ko gumaziba, me mɨsogha me abɨni. Kamaghɨn nɨn ziar igiam Israel.” ");
INSERT INTO msy2020_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ezɨ Jekop a mɨgɨa ghaze, “Nɨ datɨrɨghɨn uan ziamɨn gun na mɨkɨm.” Ezɨ an akam ikaragha ghaze, “Nɨ tizimsua, nan ziam bagha nan azangsɨsi?” Egha a God mɨkeme, eghtɨ a deragh Jekop damuam. ");
INSERT INTO msy2020_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ezɨ gɨn Jekop kamaghɨn mɨgɨa ghaze, “Kɨ Godɨn guamɨn ganigha gɨfa, egha aremezir puvatɨ.” Egha danganir kam ziam, “Peniel,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ezɨ aruem anabogha gɨvazɨma Jekop Peniel ataki. Egha an ruriar agharir asiaghirɨzir kam bangɨn an daroriba an ikufi. ");
INSERT INTO msy2020_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Israelia bar fo, fomɨra gumazir kam Jekopɨn ruriar agharim mɨsoke. Kamaghɨn me bar fomɨra iza datɨrɨghɨn, me asɨzibar ruriar agharibar itir asɨzir tuziba apir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Dughiar kamɨn Jekop kogha Ison gari, a uan gumazir 400pla ko izi. Ezɨ a uan boriba bar me mɨgɨa ghaze, ia mangɨ uan amebaba ko tuifigh. ");
INSERT INTO msy2020_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Egha a faragh mangasa amuir dozimning uan boriba ko me mɨkeme. Eghtɨ Lea uan boriba ko men gɨrara mangam. Ezɨ a Resel ko Josep mɨkemezɨ aning men gɨn ti. ");
INSERT INTO msy2020_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ezɨ Jekop uabɨ men faraghavɨra ikia zui. Egha Ison boroghɨn mangasava amua 7plan dughiabar tevimning apɨra guam nguazim girava egha dɨkava an boroghɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezɨ Iso dɨkavigha ivegha iza uan dozimɨn suiragha a muiaghɨrɨgha an tori. Egha aning uagharama azi. ");
INSERT INTO msy2020_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Egha Iso amiziba ko boribar gara egha Jekopɨn azara, “Kar te nɨ ko iti?” Ezɨ Jekop an akam ikaragha ghaze, “Kɨ nɨn ingangarir gumazim. Kar God deragha na gamigha egha borir kaba na ganɨngi.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ezɨ an amuir dozimning uan boriba ko iza Ison damazimɨn uan teviba apɨrigha avigha iraghu. ");
INSERT INTO msy2020_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ezɨ Lea uan boriba ko uaghan iza teviba apɨrigha avigha iraghu. Ezɨ Josep Resel ko abuan iza teviba apɨrigha avigha iraghu. ");
INSERT INTO msy2020_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezɨ Iso ghaze, “Gumazir sipsipba ko asɨzir maba sara inigha faragha zuiba kɨ me bato. Ezɨ kar, nɨ bizir mɨngarir tizim gata da amada?” Ezɨ Jekop a ikaragha ghaze, “O gumazir ekiam, mar nɨ bizir mabar gan na gifueghasa, kɨ da amada.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezɨ Iso ghaze, “Nan dozim, kɨ biziba bar avɨraseme. Nɨ uan biziba ua da inigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ezɨ Jekop ghaze, “Puvatɨ, nɨ uan navir averiamɨn na gifuegh egh nan bizibar suiragh. Nɨ na gifonge, ezɨ kamaghɨn, kɨ nɨn guamɨn gara mati kɨ Godɨn guamɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Kɨ kamaghɨn ifonge, bizir aghuir kɨ nɨ ganɨdir kaba, nɨ na dama da ini. Guizbangɨra God nan apangkuva arazir bar aghuimɨn na gamigha egha bizir bar avɨrim na gamizɨ, kɨ biziba bar avɨraseme.” Egha a bizir kaba iniasa bar a gakaghonezɨma, Iso a dama da ini. ");
INSERT INTO msy2020_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Egha Iso ghaze, “Ia dɨkav e mangam. Kɨ ia ko, e uaghara mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ezɨ Jekop a mɨgɨa ghaze, “Nan ekiam, nɨ gan boriba gavgavizir puvatɨ. Ezɨ kɨ sipsipba ko bulmakauba ko asɨzir igharaziba uan nguziba ko otem apavɨra itibagh nɨghnɨsi. E aruer vamɨran bar me inigh mangɨvɨra ikɨtɨ me bar arɨmɨghiregham. ");
INSERT INTO msy2020_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nan ekiam, nɨ mar en faragh mangɨtɨ, kɨ aghumra asɨziba ko uan boriba inigh nɨn gɨn izam. Egh gɨn Idomɨn nguazimɨn nɨ bativam.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ezɨ Iso ghaze, “Kamaghɨn kɨ uan ingangarir gumazitaba nɨ bagh me ategham.” Ezɨ Jekop ghaze, “Nan ekiam, nɨ bar na gifonge. Ezɨ markɨ, nan ingangarir gumaziba iti, me e ko e mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ezɨ dughiar kamran Iso uamategha Idomɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ezɨ Jekop ghua Sukotɨn nguibamɨn ghu. Egha ua bagha dɨpenimɨn ingarigha egha asɨziba bagha purirpenibar ingari. Kamaghɨn a nguibar kam ziam, “Sukot,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Egha Jekop Mesopotemian nguazim ategha, uamategh Kenanɨn nguazimɨn ize, egha Sekemɨn nguibam deragha an ghughava, Sekemɨn nguibar ekiamɨn boroghɨn purirpenibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hamor a Sekemɨn afeziam, Jekop an adarazi dama nguazim givese, nguazir kamɨn a uan purirpenibar ingari. Nguazir otevir kamɨn ivezim a 100 silvan dagɨaba. ");
INSERT INTO msy2020_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Egha Jekop ofa gamir dakozir mam danganir kamɨn an ingarigha, ofa gamir dakozir kam dɨbora ghaze, “El, a Israelɨn God.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dughiar mam Daina, Jekop ko Lean guivim Sekemɨn nguibamɨn itir amizibar ganasa zui. ");
INSERT INTO msy2020_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ezɨ Hamor, a Hivian adarazir gumazim, a Kenanɨn nguazimɨn itir gumazir dapanim. Ezɨ an otarim Sekem, Dainan ganigha an suiragha arazir kurabar a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem, a Jekopɨn guivim Dainan gari, an ganganiba bar an derazɨma, a bar a gifuegha anepezepera mɨgɨrɨgɨar otevir bar isɨngtɨzibar a gamuavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Egha gɨn uan afeziam mɨgɨa ghaze, “Afeziam, nɨ na bagh amizir kam inightɨ, kɨ an ikiasa.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ezɨ Jekop kamaghɨn oraki, Sekem arazir kuramɨn an guivim Daina a gami. Dughiar kamɨn an otariba bar saghon ghuegha dadaba itir danganimɨn ikia sipsipba ko asɨzibar gara iti. Kamaghɨn a bizitam damuan iburagha pura me mɨzua iti. ");
INSERT INTO msy2020_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Ezɨ Sekemɨn afeziam Hamor Jekop ko mɨkɨmasa ize. ");
INSERT INTO msy2020_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Egha aning uaning mɨgɨavɨra itima, Jekopɨn otariba uamategha ize. Me kamaghɨn oregha gɨfa, Sekem men buaramizim arazir kurabar a gami, ezɨ men naviba ikuvizɨ me puvɨram atari. Arazir Sekem Jekopɨn guivim gamizir kam, Israelian damazimɨn bar arazir kuram. Guizbangɨra, Israelian nɨghnɨzimɨn nɨ arazir katam damuan bar markiam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ezɨ Hamor kamaghɨn Jekop mɨgei, “Nan otarim bar moghɨram nɨn guivim gifonge, ezɨ kɨ nɨn azai, an an ikiami, o? ");
INSERT INTO msy2020_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kɨ ghaze, e uari ko deragh dapiagh egh e ian guivibar ikɨtɨ, ia en guivibar ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Egh ia e ko kantrin kamɨn ikiam. Egh nguazir asɨzir manam gifuegh ian ikɨ, egh dagɨar ingangaribar amu nguazim givezeghtɨ a iana.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ezɨ Sekem uan afeziam ko izegha, kamaghɨn Dainan afeziam ko an tuebabav gei, “Ia nan azangsɨzimɨn amamangatɨgham, eghtɨ bizir ia ifongeziba kɨ da ia danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Egh ia amizir kamɨn ivezim dɨborogh na mɨkɨm, egh bizir aghuir manmagh gariba uari danɨngɨsɨ na mɨkemegh. Egh ia ivezim manmaghɨrama anetɨgham, kɨ a isɨ ia danɨngam. Nan nɨghnɨzir ekiam, ia amizim na danightɨ kɨ an ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ezɨ Jekopɨn otariba arazir kurar Sekem men buaramizim Daina gamizim ginɨrɨ. Egha me Sekem uan afeziam Hamor ko, aning gifarasa, ");
INSERT INTO msy2020_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","egha me a mɨgɨa ghaze, “E uan buaramizimɨn amamangatɨghtɨ a gumazir me an mɨkarzir mogomemɨn inim atuzir puvatɨzitamɨn ikian kogham. E kamaghɨn damigh, aghumsɨzir ekiam inigham. ");
INSERT INTO msy2020_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Kamaghɨn amizɨ ia faragh bizir kam damigh. Ia uan gumazibar mɨkarzir mogomebar iniba vaghvagh bar adar ghoregh, egh ia en mɨn ikiam. Egh gɨn, nɨ en buaramizimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Egh ia kamagh damightɨ, e uan guiviba ian taghɨraghtɨ ia men ikɨtɨ e uaghan ian guivibar ikiam. Eghtɨ e ia ko ikɨ egh gumazamizir vabara ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Egh ia e bareghan kogh uan mɨkarzir mogomebar iniba aghoreghan koghtɨ, e uan buaramizim inigh egh nguibar kam ataghɨragham.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ezɨ Hamor uan otarim Sekem ko men mɨgɨrɨgɨar kam gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ezɨ Sekem Jekopɨn guivim bar a gifonge, kamaghɨn a bar zuamɨra bizir me mɨkemezir kabagh ami. Sekemɨn afeziamɨn adarasi, fomɨra iza datɨrɨghɨn ziar bar ekiam Sekem ganɨga bar a gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ezɨ Hamor uan otarim Sekem ko ghua, nguibar ekiamɨn dɨvazimɨn tiar akamɨn uari akuvir danganimɨn ghugha, nguibamɨn itir gumazir igharazibav gei. Egha ghaze, ");
INSERT INTO msy2020_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Gumazamizir kaba me gumazamizir bar aghuiba e ko dapiasa. E nguazir bar ekiam iti. E me ateghtɨ me en nguazimɨn ikɨ, uan ifongiamɨn dagɨar ingangaribar amuam. Egh e men guivibar ikɨtɨ me en guivibar ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Egha me arazir kam bagha gavgafi. E uan gumazibar mɨkarzir mogomebar iniba aghoregh egh e men mɨn ikiam. E kamagh damightɨ, me e ko vɨrara ikɨsɨ ifuegham. ");
INSERT INTO msy2020_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Eghtɨ men sipsip ko bulmakau ko asɨzir igharaziba, uaghan enanaba. Ezɨ bizir ekiar bar vamɨran me mɨgeir kam e damightɨ, me e ko vɨrara ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ezɨ nguibar ekiamɨn itir gumaziba bar, Hamor ko Sekemɨn akamɨn amamangatɨgha, me uan mɨkarzir mogomebar iniba aghore. ");
INSERT INTO msy2020_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ezɨ dughiar 3pla gɨvazɨ, gumaziba uari aghorezir duaba isiavɨra iti. Ezɨ Simeon ko Livai, Dainan tuebamningra mɨdorozir sababa inigha nguibar ekiamɨn aven zui. Ezɨ gumazitam aningɨn anogoroghezir puvatɨ. Ezɨ aning nguibar ekiamɨn itir gumaziba bar me mɨsoghezɨ me ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Egha aning uaghan Hamor uan otarim Sekem ko aning mɨsoghezɨ aning areme. Ezɨ aning Sekemɨn dɨpenimɨn aven ghua Daina inigha ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Dughiar kamɨn Simeon ko Livai me mɨsuegha gɨvazɨma, Jekopɨn otarir igharaziba nguibar ekiamɨn aven ghua bizir aghuir avɨriba, me Daina gamizir arazim ikarvagha da okeme. ");
INSERT INTO msy2020_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Egha me uaghan sipsipba, bulmakauba ko donkiba ini. Egha me bizir nguibamɨn aven itiba ko azenan itiba sara bar ada ini. ");
INSERT INTO msy2020_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Egha me bizir iveziba bar pɨn koziba inigha egha kalabuziabar mɨn amiziba ko boriba bar me inigha, dɨpenibar aven itir biziba bar ada akumakumigha da inigha ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ezɨ gɨn Jekop, Simeon ko Livai mɨgɨa ghaze, “Gua osɨmtɨzir ekiam na gatɨ. Ikɨzir kamning, Kenania ko Peresia, aningɨn adarazi nguazir kamɨn iti, me nan gan suam kɨ gumazir bar kuram. Kɨ gumazamizir avɨriba puvatɨ. Eghtɨ ikɨzir kamningɨn gumaziba uari akuvagh na mɨsoghtɨ kɨ uan amuiroghboriba ko bar gɨvagham.” ");
INSERT INTO msy2020_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ezɨ aning kamaghɨn mɨgei, “Kamaghɨn e manmaghɨn damuam? E ti uan buaramizim pura men teghtɨ, me arazir kurabar a damightɨ, a tuavimɨn amizimɨn mɨn ikiasa, a?” ");
INSERT INTO msy2020_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ezɨ God Jekop mɨgɨa ghaze, “Nɨ dɨkavigh Betelɨn mangɨ egh magh ikɨ. Egh na bagh ofa damuamin danganitamɨn ingarigh. Kɨ God, nɨ uan avebam Ison arir dughiamɨn kɨ nɨ bato.” ");
INSERT INTO msy2020_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ezɨ Jekop uan amuiroghboriba ko gumazamizir a ko itibav gɨa ghaze, “Ia uan asebar marvir guaba bar da batokegh. Egh arazir Godɨn damazimɨn zuezibar amu, egh korotiar zuruzibara aghu. ");
INSERT INTO msy2020_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Egh e nguibar kam ategh Betelɨn mangam. Eghtɨ kɨ God bagh ofa damuamin danganitamɨn ingaram. Godɨn kam, kɨ osɨmtɨzibar aven itir dughiamɨn, a nan akura. Ezɨ kɨ managh zui, a na ko zurara iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ezɨ me bar moghɨra uan asebar marvir guaba isa Jekop ganɨngi. Egha uaghan uan ringɨn uan kuaribagh arɨziba sarama a ganɨngi. Ezɨ Jekop Sekemɨn nguibamɨn boroghɨra temer okɨn apengan, mozim gɨkuigha egha bar ada isa mozim gaghui. ");
INSERT INTO msy2020_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Egha Jekop uan adarazi ko dɨkavigha zui. Me zuima God Sekemɨn boroghɨn itir nguibabar gumazamizibagh amizɨ, me bar atiatingi. Egha Jekopɨn adarazir agɨntɨghɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ezɨ Jekop uan adarazi ko ghua Kenanɨn nguazimɨn, Lusɨn nguibamɨn otifi. Lus, a Betelɨn nguibamɨn ziar ghurim. ");
INSERT INTO msy2020_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Egha Jekop ofa gamir dakozir mamɨn ingarigha, danganir kam ziam a gatɨgha ghaze, “Betelɨn God.” Jekop nɨghnɨsi, danganir kamɨn a fomɨra uan avebam Ison arima God a bato. ");
INSERT INTO msy2020_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ezɨ dughiar kam Rebekan ingangarir amizim Debora areme, amizir kam fomɨra Rebeka aghɨrimra itima, an an gari. Ezɨ me dughiar kamɨn ikiava, sautɨn amadaghan Betelɨn nguibamɨn boroghɨn temer ekiamɨn apengan anefa. Egha me temer kam ziam a gatɨgha ghaze, “Azirakam Gamir Temem.” ");
INSERT INTO msy2020_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Egha dughiar kamɨn Jekop Mesopotemia ategha ua Kenanɨn nguazimɨn izezɨ, God uam a batogha arazir bar aghuibar a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Egha God a mɨgɨa ghaze, “Datɨrɨghɨn nɨn ziam Jekop. Ezɨ me ua Jekop nɨ darɨghan kogham. Puvatɨ. Me ziam Israel nɨ darɨgham.” Kamaghɨn God ziam, “Israel,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Egha God a mɨgɨa ghaze, “Kɨ Gavgaviba Bar Itir God. Nɨ bar borir avɨriba batam. Eghtɨ gɨn ikɨzir mam ko, ikɨzir igharazir avɨrir maba nɨn otivam. Eghtɨ nɨ uaghan atrivir mabar, inazir afeziamɨn otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Eghtɨ kɨ nguazir faragha Abraham ko Aisak ganɨngizim, kɨ nɨ danɨngam. Egh uaghan nɨn ovavir boribar anɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","God mɨkemegha gɨvagha danganir a Jekop ko mɨgeir kam ategha ghuavanabo. ");
INSERT INTO msy2020_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ezɨ Jekop dagɨar bar ruarir mam isa danganir God a ko mɨkemezir kamɨn ababanim gamuava anesara. Egha wain ko, olivɨn borem ofan mɨn aning isa dagɨar kam ginge. ");
INSERT INTO msy2020_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Egha God a ko mɨkemezir danganir kam a ziam, “Betel,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Egha Jekop uan adarazi ko Betel ategha Efratan nguibamɨn zui. Egha me ghuavɨra itima Resel otamin dughiam oto. Ezɨ a bar mɨzazir bar ekiam isi. ");
INSERT INTO msy2020_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","A bar mɨzazir ekiam isima, amizir a ko itim, kamaghɨn a mɨgei, “Nɨ atiatingan markɨ. Kar otarir igharazir mam.” ");
INSERT INTO msy2020_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ezɨ Resel ovengasa abuan dɨghorim ingara egha, otarim ziam, “Benoni,” a gatɨ. Ezɨ an afeziam gɨn ziam, “Benjamin,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ezɨ Resel aremezɨ me Efratan nguibamɨn zuir tuavir mɨriamɨn a mozim gatɨ. Kar Betlehemɨn nguibamɨn ziar ghurim. ");
INSERT INTO msy2020_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ezɨ Jekop danganir kamɨn dagɨam isa Reselɨn mozimɨn ababanim gamua anefa. Ezɨ dagɨar kam datɨrɨghɨn ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ezɨ Israel ghuavɨra ikia Ederɨn taua ategha mong sɨvagha ghua purirpenibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("GN35_22a","002_35_22a","GEN","35","22a","22a","Israel kagh ikiavɨra itima, Ruben ghua uan afeziamɨn amuir dozim Bilha koma akui. Ezɨ Israel Ruben amizir bizir kam baraki. ");
INSERT INTO msy2020_vpl VALUES ("GN35_22b","002_35_22b","GEN","35","22b","22b","Jekop a 12plan otariba iti. ");
INSERT INTO msy2020_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Kar Lean otariba, Ruben a Jekopɨn otarir ivariam, ko Simeon, Livai, Juda, Isakar ko Sebulun. ");
INSERT INTO msy2020_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ezɨ Resel otarir pumuning iti, Josep ko Benjamin. ");
INSERT INTO msy2020_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ezɨ Bilha, Reselɨn ingangarir amizim otarir pumuning iti, Dan ko Naptali. ");
INSERT INTO msy2020_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ezɨ Silpa, Lean ingangarir amizim otarir pumuning iti, Gat ko Aser. Jekop Mesopotemian ikia otarir kaba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Egha Jekop uan afeziam Aisak bagha Mamren nguibamɨn ghu, Hebronɨn nguibamɨn boroghɨn an ziar mam Kiriat Arba. Kar Abraham ko Aisak faragha ikezir nguibam. ");
INSERT INTO msy2020_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ezɨ Aisak 180plan azeniba ikia, ");
INSERT INTO msy2020_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","bar ghurigha ovengezɨ, an duam ghua, an adarazir duaba ghua itir nguibamɨn me ko iti. Ezɨ an otarimning Iso ko Jekop an suiragha anefa. ");
INSERT INTO msy2020_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Kar Ison ovavir boribar ziaba, an ziar igharazim Idom: ");
INSERT INTO msy2020_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso a Kenanian amizibar iti. Ezɨ Hitian gumazim Elon, an guivim Ada, Ison iti. Ezɨ Anan guivim Oholibama, uaghan an iti. Anan afeziam Sibeon, a Hivian gumazir mam. ");
INSERT INTO msy2020_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Egha a uaghan Ismaelɨn guivim Basematɨn iti. Ezɨ Basemat a Nebaiotɨn buaramizim. ");
INSERT INTO msy2020_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ezɨ Ada Elifas bate, ezɨ Basemat Ruel bate. ");
INSERT INTO msy2020_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Ezɨ Oholibama Jeus, Jalam, ko Kora bate. Dughiar kamɨn Iso Kenanɨn nguazimɨn ikiavɨra ikiava borir kaba ini. ");
INSERT INTO msy2020_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Egha gɨn Iso uan amuiba, ko otariba, ko guiviba ko, gumazamizir an adarazi ko itiba ko, asɨziba ko, an bizir Kenanɨn nguazimɨn itiba bar ada inigha, uan dozim Jekopɨn saghon ghua nguazir igharazimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iso uan dozim ataghɨrazir bizim kamakɨn, nguazir aning itir kam aningɨn tughatɨghan kogham. Aningɨn asɨziba bar avɨrasemezɨ aning uaning ko ikian iburaghburaki. ");
INSERT INTO msy2020_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kamaghɨn, Iso ghua Seirɨn Mɨghsɨabar nguibamɨn apera. Idom, kar Ison ziar igharazim. ");
INSERT INTO msy2020_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ezɨ Ison boribar ziabar kara: Iso uabɨ, a Idomian afeziam, me Seirɨn Mɨghsɨabar iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso uabɨ an otariba, Elifas a Adan otarim, ezɨ Ruel a Basematɨn otarim. ");
INSERT INTO msy2020_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ezɨ Elifasɨn otariba, Teman, Omar, Sefo, Gatam, ko Kenas. ");
INSERT INTO msy2020_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ezɨ Ison otarim Elifas, an amuir dozim Timna, an Amalek bate. Kar Ison amuim Adan ovavir boriba. ");
INSERT INTO msy2020_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ezɨ Ruelɨn otariba, Nahat, Sera, Sama ko Misa. Kar Ison amuir mam Basematɨn otariba. ");
INSERT INTO msy2020_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ezɨ Ison amuir igharazim Oholibama, a Jeus, Jalam ko Kora bate. Oholibaman amebam Ana, ezɨ Sibeon Anan afeziam. ");
INSERT INTO msy2020_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Ezɨ Ison otarir uan adarazir gumazir dapanibar itibar ziabar kara: Elifas a Ison otarir ivariam, an otaribar kara, Teman, Omar, Sefo, Kenas, Kora, Gatam, ko Amalek, me gumazir dapanibar otivigha uan adarazi Idomɨn nguazimɨn men gari. Kar Ison amuim Ada, an ovavir boribar otariba. ");
INSERT INTO msy2020_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ezɨ Ruelɨn adarasi, Nahat, Sera, Sama ko Misa, me uan adarazir gumazir dapanibar otivigha Idomɨn nguazimɨn men gari. Kar Ison amuim Basemat, an ovavir boriba. ");
INSERT INTO msy2020_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ezɨ Ison amuim Oholibaman adarasi, Jeus, Jalam ko Kora, me gumazir dapanibar iti. Ezɨ Anan guivim Oholibama gumazir dapanir kaba bate. ");
INSERT INTO msy2020_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ezɨ gumazir kaba me Ison ovavir boriba, Ison ziar mam Idom. Me uan dakozibar gumazir dapanibar iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seir, a Horian gumazir mam, a Idomɨn nguazimɨn iti. Kar Seirɨn otaribar ziaba: Ezɨ an otariba, Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO msy2020_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser ko Disan. Ezɨ kar Seirɨn otariba, me uan adarazir dakozibar dapanibar ikia Idomɨn nguazimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ezɨ Lotanɨn otarimning, Hori ko Heman. Ezɨ Lotanɨn buaramizim, a Timna. ");
INSERT INTO msy2020_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ezɨ Sobalɨn otariba, Alvan, Manahat, Ebal, Sefo, ko Onam. ");
INSERT INTO msy2020_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ezɨ Sibeonɨn otarimning, Aia ko Ana. Anan kamra, a faragha uan afeziam Sibeonɨn donkiba gumazamiziba puvatɨzir danganimɨn dar gara, egha dɨpar atuir bar puvɨra feibar gani. ");
INSERT INTO msy2020_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ezɨ Anan borimning, Dison ko Oholibama. Ezɨ Oholibama Anan guivim. ");
INSERT INTO msy2020_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ezɨ Disonɨn otariba, Hemdan, Esban, Itran, ko Keran. ");
INSERT INTO msy2020_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezɨ Eserɨn otariba, Bilhan, Savan, ko Akan. ");
INSERT INTO msy2020_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ezɨ Disanɨn otarimning, Us ko Aran. ");
INSERT INTO msy2020_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ezɨ Idomɨn nguazimɨn aven, Horɨn adarazir dakozibar gumazir dapanibar ziaba, Lotan, Sobal, Sibeon, Ana, Dison, Eser ko Disan. ");
INSERT INTO msy2020_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Dughiar kamɨn Israelia atriviba puvatɨzɨ, gumazir kaba Idomɨn kantrin atrivibar ike: ");
INSERT INTO msy2020_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ezɨ Beorɨn otarim Bela, Idomɨn kantrin faraghavɨram atrivimɨn iti. A Dinhaban nguibar ekiamɨn atrivimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Egha Bela aremezɨ, Seran otarim Jobap an danganim inigha atrivimɨn iti. Sera, a Bosran nguibamɨn gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Egha Jobap aremezɨ, Temanian nguazimɨn gumazim Husam, an danganim inigha atrivimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Egha Husam aremezɨ, Bedatɨn otarim Hadat an danganim inigha atrivimɨn iti. Egha Hadat Moapɨn nguazimɨn ghua Midianɨn gumaziba ko mɨsogha mɨdorozimɨn me abɨra. Egha Hadat Avitɨn nguibar ekiamɨn atrivimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Egha Hadat aremezɨ, Masrekan nguibamɨn gumazim, an ziam Samla, an danganim inigha atrivimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Egha Samla aremezɨ, Saul an danganim inigha atrivimɨn oto. Saul, a Rehobotian gumazir mam. Rehobot, a Yufretisɨn Fanemɨn mɨriamɨn itir nguibam. ");
INSERT INTO msy2020_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ezɨ Saul aremezɨ, Akborɨn otarim Balhanan an danganim inigha atrivimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Egha Balhanan aremezɨ, Hadar an danganim inigha atrivimɨn oto. Egha Paun nguibamɨn atrivimɨn iti. Ezɨ an amuim Mehetabel, a Matretɨn guivim. Ezɨ Mehetabelɨn inazim Mesahap. ");
INSERT INTO msy2020_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ezɨ Idomian anababar gumazir dapanibar ziabar kara: Timna, Alva, Jetet, Oholibama, Ela, Pinon, Kenas, Teman, Mipsar, Makdiel, ko Iram. Gumazir kaba me Idomian gumazir dapaniba. Ezɨ Idom kar Ison ziar igharazim, ezɨ Iso Idomian inazir afeziam. Ezɨ gumazir dapanir kaba vaghvagha uan nguibabar ikia, egha uan adarazir gativa men gari. ");
INSERT INTO msy2020_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekop Kenanɨn nguazimɨn iti, kar nguazir an afeziam Aisak fomɨra ikezim. ");
INSERT INTO msy2020_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ezɨ Jekop ko an ovavir boribar eghaghanimra kara. Josep a gumazir bar igiam, egha 17pla azeniba iti. Egha a sipsipba ko memeba uan aveghbuaba ko dar gari. Kar Bilha ko Silpan otariba, aning an afeziamɨn amuimning. Ezɨ Josepɨn aveghbuaba amir arazir kuraba a zurara dar gun uan afeziam mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ezɨ Jekop, an ziar mam Israel. Israel bar ghurizir dughiam an amuim Josep bate. Ezɨ bizir kam bagha, a uan otarir igharazibar tongɨn Josep bar a gifonge. Egha dughiar mam Jekop, Josep bagha korotiar agharir ruarir dirir mamɨn ingarigha a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ezɨ aveghbuaba gari afeziam bar Josep gifuegha, deragha me gifongezir puvatɨ. Kamaghɨn, aveghbuaba Josep bar a baseme, egha bar an aghuagha, mɨgɨrɨgɨar aghuibar a gamir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Egha dughiar mamɨn Josep irebamɨn ganigha, aveghbuabagh eghari. Ezɨ me a baregha men naviba bar moghɨra an ikufi. ");
INSERT INTO msy2020_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ezɨ Josep kamaghɨn mɨgei, “Ia nan irebam baragh. ");
INSERT INTO msy2020_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","E bar moghɨra dagher azenimɨn aven ikia, egha witɨn ikɨziba ikia da arɨsi. Ezɨ nan witɨn ikɨzim voroghɨra tughav iti. Ezɨ ian witɨn ikɨziba nan witɨn ikɨzim gighuigha tuivighav ikia, dar dapaniba avigha ghuaghira nan witɨn ikɨzim mɨtifi.” ");
INSERT INTO msy2020_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ezɨ an aveghbuaba oregha kamaghɨn Josep mɨgei, “Nɨ ghaze, nɨ en atrivimɨn otogh egh e gativagham?” Egha kamaghɨn, Josep zurara uan irebabagh egharima, an aveghbuabar naviba an derazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Egha gɨn Josep ua irebar mamɨn ganigha uan aveghbuabagh eghari. Egha kamaghɨn mɨgei, “Kɨ ua irebar mamɨn gani. Egha nan irebamɨn aven, kɨ aruem ko iakɨnim ko mɨkovezir 11plan garima, da nan guamɨn uan dapaniba avingi.” ");
INSERT INTO msy2020_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A irebar kamɨn uan afeziam ko uan aveghbuabagh eghanigha gɨvazɨ, an afeziam an atara kamaghɨn a mɨgei, “Kar irebar manmagh amizim? Nɨ ti ghaze, kɨ ko nɨn amebam ko nɨn aveghbuaba, e bar izɨ nɨn guamɨn tevibar pɨrigh dapaniba avigham?” ");
INSERT INTO msy2020_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ezɨ Josepɨn aveghbuaba naviba bar a baseme, ezɨ afeziam Josepɨn irebamning puvɨram aning gɨnɨghnɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ezɨ dughiar mamɨn Josepɨn aveghbuaba uan afeziamɨn sipsipbar ganasa Sekemɨn nguibamɨn ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ezɨ Israel kamaghɨn Josep mɨgei, “Nɨn aveghbuaba sipsipbar gara Sekemɨn nguibamɨn iti. Ezɨ nɨ mangɨ men ganasa kɨ ifonge.” Ezɨ Josep kamaghɨn an akam ikaragha ghaze, “Are, Afeziam. Kɨ mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ezɨ afeziam kamaghɨn a mɨgei, “Nɨ mangɨ uan aveghbuabar ganigh fogh suam, me deraghavɨra ti, o puvatɨ? Egh uaghan sipsipbar ganigh fogh, da dera, o puvatɨ? Nɨ men ganigh, egh uamategh izɨ na mɨkemegh.” Ezɨ dughiar kamɨn Israelɨn adarasi, Hebronɨn danganir zarimɨn iti. Ezɨ Josep Sekemɨn nguibamɨn otogha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Egha danganir kam garua uan aveghbuaba bagha rui. Ezɨ gumazir mam an ganigha kamaghɨn an azara, “Nɨ bizir tizim buri?” ");
INSERT INTO msy2020_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ezɨ Josep kamaghɨn mɨgei, “Kɨ uan aveghbuaba bagha rui. Nɨ danganir me ikia uan sipsipbar garim, an gun na mɨkɨmam o?” ");
INSERT INTO msy2020_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ezɨ gumazir kam a mɨgɨa ghaze, “Me danganir kam ataki. Egha kɨ orazi, me Dotan nguibamɨn mangasa mɨkeme.” Ezɨ Josep uan aveghbuabar gɨn ghua Dotan nguibamɨn me bato. ");
INSERT INTO msy2020_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Egha a saghon ghuavɨra itima, an aveghbuaba an apigha, a mɨsueghtɨ an aremeghasa akam mɨsosi. ");
INSERT INTO msy2020_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Egha me uarir tongɨn uarira kamaghɨn uariv gɨa ghaze, “Ia munagh gan, gumazir irebabar garim izi. ");
INSERT INTO msy2020_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Aria, e a mɨsueghtɨ an aremeghtɨ, e an kuam inigh mozir kabar tam mɨkɨnika. Egh e gɨn suam, ‘Asɨzir atiar mam a mɨsoghezɨ an areme.’ Egh e ganam, an irebamning manmaghɨn otivam!” ");
INSERT INTO msy2020_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ezɨ Ruben me barasi, me mɨgɨrɨgɨar kam gamizɨ, a Josepɨn akurvaghasa. Egha ghaze, “E a mɨsueghtɨ an aremeghan markiam. ");
INSERT INTO msy2020_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","E uari an ikɨrɨmɨrim agɨvaghan kogham. A inigh gumazamiziba puvatɨzir danganimɨn itir mozir kam mɨkɨnigh.” Guizbangɨra Ruben kamaghɨn nɨghnɨsi, a Josep uam a inigh an aku uam afeziam bagh mangasa, akar kam mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ezɨ Josep uan aveghbuaba batozɨma, me pamten an suiragha, a gekuava an korotiar agharir ruarir dirir an afeziam a ganɨngizim sue. ");
INSERT INTO msy2020_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Egha me a inigha ghua mozir dɨpar mɨsɨngizir mam mɨkɨni. ");
INSERT INTO msy2020_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Egha gɨn me apiaghava api. Me apa ikia garima, Ismaelian gumaziba uan kamelba ko izi. Gumazir kaba, Gileatɨn nguazimɨn ikegha iza, Isipɨn kantrin zui. Egh me mangɨ bizir bar pɨn koziba dagɨaba bagh da mangasa, bizir kabanang, temebar eboriba, ko mɨkarzibagh azuir bizir guar avɨriba, ko mughuriar aghuim zuir boreba. ");
INSERT INTO msy2020_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ezɨ Juda kamaghɨn uan aveghbuabav gɨa ghaze, “E uan aveghbuam mɨsueghtɨ an aremeghtɨ, bizir e amizir kam modoghtɨ, arazir kam manmaghɨn en akuragham? ");
INSERT INTO msy2020_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kamaghɨn e ti Ismaelɨn adarazi bagh anemadaghtɨ, me pura ingangarir gumazir kɨnimɨn mɨn a givezegham. Guizbangɨra, an en aveghbuamra egha ghuzir vamɨra, kamaghɨn e uari a gasɨghasɨghan kogham.” Ezɨ an aveghbuaba akar kam gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Egha an aveghbuaba mɨgɨavɨra itima, Midian gumazir dagɨaba bagha ingarir maba iza Josepɨn garima, a mozimɨn iti. Ezɨ aveghbuaba a gekuizɨ an anabozɨ, me pura ingangarir gumazir kɨnimɨn mɨn Ismaelian gumazibar anemada. Ezɨ Ismaelian gumaziba 20 silvan dagɨaba Midianian gumazibagh anigha, Josep inigha Isipɨn kantrin zui. ");
INSERT INTO msy2020_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ezɨ gɨn Ruben ua ghua mozimɨn garima, Josep mozimɨn itir puvatɨ. Ezɨ a dɨgavir kuram gamigha nɨghnɨgha avegha uan korotiam abɨki, ");
INSERT INTO msy2020_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","egha uamategha uan aveghbuaba bagha ghua kamaghɨn me mɨgei, “Josep mozimɨn itir puvatɨ. Ezɨ kɨ manmaghɨn damuam?” ");
INSERT INTO msy2020_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ezɨ an aveghbuaba memen mam mɨsuegha, me Josepɨn korotiar agharir ruarir dirim isa an ghuzim garugha uam a ini. ");
INSERT INTO msy2020_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Egha me an korotiar dirim inigha afeziam bagha ghugha, an akaghava a mɨgei, “Nɨ kagh ganigh, korotiar dirir kam a danganir mamɨn iti e an api. Ka ti nɨn borir tamɨn korotiam, o puvatɨ?” ");
INSERT INTO msy2020_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ezɨ afeziam korotiar dirir kamɨn ganigha fogha kamaghɨn mɨgei, “Are, kar Josepɨn korotiam. Laionɨn tam ti nan otarim mɨsoghezɨ an aremezɨ, a ti bar anemeghama.” ");
INSERT INTO msy2020_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ezɨ Jekop uan borim bar an apangkuvigha, uan korotiam abigha, azir korotiar mam aru. Egha dughiar ruarimɨn uan borim bagha azia iti. ");
INSERT INTO msy2020_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ezɨ an otariba ko guiviba, iza an navim damutɨ a ua deraghasa mɨgɨrɨgɨabar a mɨgei. Ezɨ a bar aghuagha kamaghɨn mɨgei, “Kɨ a bagh arang mamaghɨra ikɨ mangɨ, Gumazamizir Oveaghuezibar Nguibamɨn magɨrɨgh a batogham.” Egha Jekop aziavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ezɨ Midianian gumazir kaba Josep inigha ghua Isipɨn kantrin otogha, pura ingangarir gumazir kɨnimɨn mɨn a isa dagɨaba bagha Potifan anemada. A Isipɨn atrivimɨn ingangarir gumazir mam. Potifar, a Isipɨn atrivimɨn dɨpenir ekiamɨn garava, mɨdorozir gumazibar faragha zuir gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ezɨ dughiar kamɨn Juda uan aveghbuaba ategha ghua Adulamɨn nguibamɨn gumazim, an ziam Hira, a ko iti. ");
INSERT INTO msy2020_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Egha Kenanɨn nguazimɨn gumazim, an ziam Sua, an an guivimɨn gani. Egha an amizir kamɨn ikia egha aning iti. ");
INSERT INTO msy2020_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ezɨ amizim navim asegha otarir mam batezɨ, Juda ziam, “Er,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Egha gɨn amizim navim asegha uam otarir mam bategha uabɨ ziam, “Onan,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ezɨ amizim ua navim asegha uam otarir mam bategha ziam, “Sela,” a gatɨ. Dughiar kam Juda Kesipɨn nguibamɨn itima an amuim Sela bate. ");
INSERT INTO msy2020_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ezɨ boriba aghua ghua bar ekevezɨma, Juda uan otarir ivariam Er bagha amizir mam ini. Ezɨ amizir kamɨn ziam Tamar. ");
INSERT INTO msy2020_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ezɨ Erɨn araziba Ikiavɨra Itir Godɨn damazimɨn bar derazir puvatɨ, kamaghɨn God a mɨsoghezɨ an areme. ");
INSERT INTO msy2020_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ezɨ Juda kamagh Onan mɨgei, “Nɨ uan avebamɨn amuim ko daku. Nɨn avebam ovegha boriba puvatɨ. En arazim kamakɨn, nɨ uan avebamɨn amuim inighɨva an ikɨ, egh a bagh boriba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ezɨ Onan pura borir igharaziba batɨtɨ, me an avebamɨn ziamɨn ikɨ bizibar amuan an aghua. Egha amizir kam koma akua, uan dɨpam pura nguazim ginge. A kamaghɨn nɨghnɨsi, a kamaghɨn damu uan avebam bagh boritam inighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ezɨ Onan amir arazir kam, a Ikiavɨra Itir Godɨn damazimɨn bar ikufi. Kamaghɨn, God uaghan a mɨsoghezɨ an areme. ");
INSERT INTO msy2020_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ezɨ gɨn Juda uan ivozir amizim Tamar mɨgɨa ghaze, “Nɨn pam areme. Kamaghɨn, nɨ uamategh uan afeziamɨn dɨpenimɨn mangɨ, egh magh ikɨtɨ nan otarim Sela an ekeveka.” Juda kamagh nɨghnɨgha atiatigha mɨgɨrɨgɨar kam gami, Sela uan avebamningɨn mɨn ovegham. Ezɨ Tamar ua uan afeziamɨn dɨpenimɨn ghugha iti. ");
INSERT INTO msy2020_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ezɨ dughiar ruarim ghua gɨvazɨma, Judan amuim a Suan guivim, a uaghan ovenge. Juda uan amuimɨn buabem agɨvagha, gumazir an sipsipbar arɨziba ghoribar ganasa Timnan nguibamɨn ghu. Ezɨ an namakam, Adulamɨn nguibamɨn gumazim Hira, a ko ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ezɨ gumazir mam kamagh Tamar mɨgei, “Nɨn ivozir afeziam sipsipbar arɨziba aghorasa Timnan nguibamɨn ghu.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ezɨ Tamar kamaghɨn fo, Sela ekevegha gɨfa, ezɨ aning uaningɨn ikiamin mɨgɨrɨgɨaba me dar kɨrɨzir puvatɨ. Kamaghɨn a korotiar uan pam guba ikia aruzim sue. Egha inir avɨzir mam inigha uan guam avaragha, ghua Enaimɨn nguibamɨn zuir tuavir akamɨn aperaghav iti, nguibar kam Timnan nguibamɨn zuir tuavimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ezɨ amizir kam inir avɨzim uan guam dukuagha aperaghav itima, Juda iza an gara kamaghɨn nɨghnɨsi, kar ti gumaziba isa me koma akuir amizim. ");
INSERT INTO msy2020_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Egha a tuavir mɨriamɨn an boroghɨn ghua a mɨgɨa ghaze, “Aria, kɨ nɨ ko dakuasa.” Dughiar kam, Juda kamaghɨn fozir puvatɨ, kar an ivozir amizim. Ezɨ amizim ghaze, “Bizir tizim nɨ na danɨngam?” ");
INSERT INTO msy2020_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ezɨ Juda ghaze, “Nan memeba iti. Kɨ memen igiatam nɨ bagh anemadaghtɨ a izam.” Ezɨ amizim ghaze, “A dera, nɨ faragh na ko dɨkɨrɨzir akam bagh, ababanimɨn mɨn bizitam na danɨngigh, egh gɨn meme na danightɨ kɨ nɨn bizim isɨ uam nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ezɨ Juda kamaghɨn mɨgei, “Kɨ bizir tizim, akar dɨkɨrɨzimɨn ababanim damu, nɨ danɨngam?” Ezɨ amizim ghaze, “Bizir kamning na danɨngigh, ringɨn nɨn ziamɨn ababanim itim, ko an benir nɨ uan fɨrim gikezir kam sara. Egh uan darorir fidizir nɨ suirazɨ kam saram na danɨngigh.” Ezɨ Juda bizir kaba bar da isa amizim ganigha, a koma akui. Egha navim a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Egha aning akuigha gɨvagha Tamar dɨkavigha ghu. Egha uan guam avarazir inir kam adegha, ua buaber korotiam arugha ua uan pam gubai. ");
INSERT INTO msy2020_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Egha gɨn Juda memen igiar mam isa Hira ganigha anemadagha ghaze, a mangɨ meme a danɨngigh, a da biziba ua da iniam. Ezɨ a ghua amizir kam buria egha an apizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kamaghɨn a danganir kamɨn itir gumazibar azangsɨsi, “Enaimɨn tuavimɨn apiaghirir amizir gumaziba isa me koma akuim, a managh iti?” Ezɨ me ghaze, “Amizir gumaziba koma akuitam kagh itir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ezɨ Hira uamategha Juda bagha ghugha ghaze, “Kɨ an apizir puvatɨ. Ezɨ nguibamɨn gumaziba ghaze, Amizir gumaziba isa akuitam munagh itir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ezɨ Juda kamaghɨn mɨgei, “Markɨ, aneteghtɨ a bizir kabar suiragh. Nɨ uam amizir kam burian markɨ, kamaghɨn, gumazamiziba gan ingarvakegham. Guizbangɨra, kɨ uan akar dɨkɨrɨzimɨn gɨn ghua a bagha memen igiar kam amada, ezɨ nɨ an apizir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ezɨ iakɨnir 3pla ghua gɨvazɨma me iza kamaghɨn Juda mɨgei, “Nɨn ivozir amizim Tamar gumaziba isa me koma akuir arazim gamigha, datɨrɨghɨn navim asangi.” Ezɨ Juda kamaghɨn mɨgɨa ghaze, “Ia a inigh mangɨ avimɨn a tuaghtɨ a isiva aremegh!” ");
INSERT INTO msy2020_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Egha me a inigha zuir dughiam, Tamar bizir Juda a ganɨngiziba isa da amaga, egh akar kam sarama a bagha anemada, “Bizir kabar afeziam, a na koma akuizɨ, kɨ navim asangi. Nɨ kagh bizir kaba deragh adar ganigh. Benim ko, ziar an ababanim itir ring ko, darorir fidizim. Kar tinan biziba?” ");
INSERT INTO msy2020_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ezɨ Juda ganigha fogha kamaghɨn mɨgei, “Guizbangɨra, amizir kam nan otarim Selan ikiam. Ezɨ puvatɨ, kɨ aning uaningɨn ikiamin bizim akɨrizir puvatɨ. Kamaghɨn, kɨrara, kɨ arazir kuram gami, ezɨ amizir kam puvatɨ.” Egha Juda uam a koma akuir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ezɨ Tamar borim batamin dughiam me kamagh an gari, borir fufuzimning an navimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ezɨ Tamar otamin dughiam, borir mamɨn agharim faragha oto. Ezɨ amizir Tamarɨn akuraghtɨ an otamin kam, a borimɨn agharimɨn suiragha benir aghevir mam an agharim ike. Egha ghaze, “Borir kam faragha ize.” ");
INSERT INTO msy2020_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ezɨ borim ua uan agharim gekuigha aven ghu, ezɨ an dozim faragha oto. Ezɨ amizir kam ghaze, “Manmaghɨn ami? Nɨ avebam gitagha faragha ize?” Ezɨ me ziam, “Peres,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ezɨ gɨn an avebar benir aghevim itim oto. Ezɨ me ziam, “Sera,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ezɨ Ismaelɨn adarazi Josep inigha Isipɨn kantrin ghuzɨ, Potifar ingangarir gumazir kɨnimɨn mɨn a givese. Potifar a Isipɨn gumazir mam. Atrivimɨn ingangaribar faragha zuir ingangarir gumaziba, a men mav. A uaghan atrivimɨn dɨpenimɨn garir mɨdorozir gumaziba, a men faragha zuir gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ezɨ Josep, gumazir ekiam Potifarɨn dɨpenimɨn aven iti. Ezɨ Ikiavɨra Itir God Josep ko iti, ezɨ an amir biziba bar, deravɨram otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ezɨ Potifar gari, Ikiavɨra Itir God Josep ko itima an amir biziba, da deragha otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Ezɨ a Josep bagha bar ifuegha a gamizɨma an an ingangarir gumazimɨn oto. Ezɨ a uan dɨpenim ko biziba bar dar ganamin ingangarim a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ezɨ Josep Potifarɨn dɨpenimɨn gara itir dughiar kamɨn, Ikiavɨra Itir God bar deragha Potifarɨn adarazigh ami. Egha Josep bangɨn, Ikiavɨra Itir God Potifarɨn dɨpenimɨn aven itir biziba ko dagher azeniba bar deragha dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kamaghɨn Potifar Josep atɨzɨ, an an biziba bar dar gari. Egha a uabɨ bizir avɨribagh nɨghnɨzir puvatɨ, a uabɨ dagher manabara a dar amasa dagh nɨghnɨsi. Dughiar kamɨn Josep mɨkarzim sarama aghuigha gavgavigha ganganiba bar dera. ");
INSERT INTO msy2020_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ezɨ dughiar ruarim puvatɨzɨ, Potifarɨn amuim an ganigha a gifuegha a mɨgɨa ghaze, “Nɨ izɨ, na ko daku.” ");
INSERT INTO msy2020_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ezɨ Josep aghuagha kamaghɨn a mɨgei, “Nan gumazir aruam, dɨpenir kamɨn biziba bar dar ganasa na mɨsevegha, bizitam bagha ua nɨghnɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ezɨ dɨpenir kamɨn aven a na ko gan gavgaviba magh ghue, ingangarir gumazir igharazitam na gafirazir puvatɨ. A dɨpenir kamɨn aven bizitam damuasa nan anogoroghezir puvatɨ. Nɨ an amuim, a nɨ ko dakuasa na mɨkemezir puvatɨ. Kɨ bar manamaghsu arazir bar kurar kam damuam? Egh kɨ kamagh damigh, Godɨn damazimɨn bar ikuvigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Egha dughiabar zurara amizim Josep ko dakuasa an azangsɨghavɨra iti. Ezɨ Josep an akam barazi puvatɨgha, a koma akuizir puvatɨgha an boroghɨn ghuzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Egha dughiar mamɨn Josep dɨpenimɨn aven ghugha, ingangarim damuasava ami. Ezɨ ingangarir gumazitam itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ezɨ Potifarɨn amuim Josepɨn saketɨn suira, egha kamaghɨn mɨgei, “Nɨ izɨ na ko daku.” Ezɨ Josep uan saket ategha arava azenan ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ezɨ amizim Josepɨn gari, a saket ategha arav ghu, ");
INSERT INTO msy2020_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ezɨ a ingangarir gumazibar diagha ghaze, “Ia gan. Nan pam Hibruian gumazir kam inigha en dɨpenimɨn izezɨ, a datɨrɨghɨn aghumsɨzir dafam e danɨngasa. A kɨ akuir danganimɨn aven izegha na ko dakuasa nan azangsɨgha pamtem na gakaghori. Ezɨ kamaghɨn kɨ pamten dei. ");
INSERT INTO msy2020_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ezɨ an orazi kɨ deima, a uan saket nan mɨriamɨn anetegha zuamɨrama arava azenan ghu.” ");
INSERT INTO msy2020_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Egha Potifarɨn amuim Josepɨn saketɨn suira. A ikɨtɨ an pam izɨ dɨpenimɨn otoghtɨ, an an akagham. ");
INSERT INTO msy2020_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ezɨ an pam otozɨ, an eghaghanir kamrama a geghara ghaze, “Hibruian ingangarir gumazir kɨnir kam, nɨ a inigha gan dɨpenimɨn izezɨ, a iza kɨ akui naghɨn iza, na ko daku arazir kuramɨn na damigh aghumsɨzir dafam na danɨngasa, na gaghori. ");
INSERT INTO msy2020_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ezɨ kɨ bar pamten diazɨ, a uan saket nan tegha arava azenan ghu.” ");
INSERT INTO msy2020_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ezɨ Potifar uan amuimɨn eghaghanir kaba baregha bar puvɨrama atari. ");
INSERT INTO msy2020_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Egha mɨdorozir gumazibav kemezɨ me Josepɨn suiragha a isa kalabus gatɨ. Kar atrivimɨn kalabuziaba itir dɨpenim. ");
INSERT INTO msy2020_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ezɨ Ikiavɨra Itir God Josep ko ikiavɨra ikia, bar an apangkuvighavɨra iti. Egha a gumazir kalabusɨn dɨpenimɨn garim gamizɨ, a uaghan Josep gifonge. ");
INSERT INTO msy2020_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Egha gumazir kam kalabuziar gumazibar ganasa Josep amɨsefe. Ezɨ Josep kalabusɨn dɨpenimɨn itir ingangariba bar dar gari. ");
INSERT INTO msy2020_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Egha Ikiavɨra Itir God Josep ko ikia an akurvasi, ezɨ bizir an amiba, da bar deravɨra zui. Ezɨ gumazir kalabuziar dɨpenimɨn garim, ingangarir a damuasa Josep mɨkemeziba, a da bagha ua nɨghnɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Egha mong dughiar ruarimɨn ikegha, gumazir atrivimɨn dɨpenimɨn wainɨn garim, ko atrivimɨn bretɨn ingarir gumazir dapanim, aning Isipɨn atrivim bar ifongezir puvatɨzir arazir kuram gami. ");
INSERT INTO msy2020_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ezɨ Isipɨn atrivim uan ingangarir gumazir kamning adarim aningɨn iti, ");
INSERT INTO msy2020_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","egha aning isa kalabus gatɨ. Kalabusɨn dɨpenir kam, kar atrivimɨn mɨdorozir gumazibar garir gumazir dapanimɨn dɨpenim. Ezɨ kalabusɨn dɨpenir kamra me faragha Josep isava a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ezɨ mɨdorozir gumazibar dapanim aningɨn akurvaghasa Josep ginaba. Ezɨ aning bar dughiar ruarimɨn kalabusɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Egha dɨmagarir mam, gumazir atrivimɨn wain ko bretɨn garimning, aning irebamningɨn gani. Ezɨ irebamning uaghara ghuzir puvatɨgha, magh garir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ezɨ mɨzarazimɨn Josep ghua aningɨn garima, aning bar oseme. ");
INSERT INTO msy2020_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ezɨ a kamagh aningɨn azara, “Bizir tizim gua gamima, guan navimning bar oseme?” ");
INSERT INTO msy2020_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ezɨ aning kamaghɨn Josepɨn akam ikaragha ghaze, “Ga irebamningɨn gani. Ezɨ gumazir gan irebamningɨn mɨngarim abɨghamba puvatɨ.” Ezɨ Josep kamaghɨn aning mɨgei, “God uabɨra a irebabar mɨngaribar en akakasi. Ezɨ gua uan irebamningɨn gun na mɨkɨm.” ");
INSERT INTO msy2020_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ezɨ atrivimɨn wainɨn garir gumazim uan irebamɨn gun Josep mɨgɨa ghaze, “Nan irebamɨn, kɨ wainɨn ikarɨzimɨn gani. ");
INSERT INTO msy2020_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ezɨ ikarɨzir kam agharir 3pla iti. Ezɨ an dafariba zuamɨra murima, an akɨmariba zuamɨrama otifi, ezɨ wainɨn ovɨziba otivigha bar moghɨrama ani. ");
INSERT INTO msy2020_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kɨ Isipɨn atrivimɨn kavɨn suiraghav ikia, wainɨn ovɨzir kaba inigha uan dafarir mamɨn da munubi, ezɨ dar dɨpam kap giraghuezɨ, kɨ a isa atrivim ganɨngi.” ");
INSERT INTO msy2020_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ezɨ Josep ghaze, “Nɨn irebamɨn mɨngarim kamakɨn. Ikarɨzir agharir 3pla, da dughiar 3plan ababanim. ");
INSERT INTO msy2020_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dughiar 3pla gɨvaghtɨ atrivim ua nɨ inigh mangam. Egh ua nɨ isɨ nɨn ingangarim darɨgham. Eghtɨ nɨ fomɨra wainɨn kap a ganɨga ingarizɨ moghɨn, nɨ uam a danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Egh nɨ mangɨ nɨn dabirabim deraghtɨ, nɨ na ginɨrɨgh. Kɨ nɨn azai, nɨ nan apangkuvigh nan akuragh nan ziamɨn gun atrivim mɨkɨmtɨ, kɨ kalabus ateka. ");
INSERT INTO msy2020_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Guizbangɨra, bar faraghɨvɨra gumazir maba Hibruian nguazimɨn na okemegha na inigha kagh ize. Ezɨ kɨ Isipɨn kagh ikia, bizitam pazava a gamizir puvatɨ. Ezɨ me pura na isa kalabus gatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ezɨ gumazir bretɨn ingarim, a wainɨn garir gumazimɨn irebamɨn mɨngarim barasi. Ezɨ a derazɨma, a kamaghɨn Josep mɨgei, “Kɨ uaghan irebar mamɨn gani. Nan irebam kamakɨn. Kɨ akɨrar 3pla uan dapanim dafagha zui. Ezɨ bretba akɨrar kabagh izɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ezɨ akɨrar pɨn itim atrivim ifongezir bretba ko bisketba ko bizir igharagha gariba a gizɨfa. Ezɨ kuaraziba iza bizir kaba api.” ");
INSERT INTO msy2020_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ezɨ Josep kamaghɨn mɨgei, “Irebar kamɨn mɨngarim kamaghɨn ghu, akɨrar 3plan da dughiar 3plan ababanim. ");
INSERT INTO msy2020_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Eghtɨ dughiar 3pla tɨghar gɨvtɨ, atrivim kalabusɨn nɨ inigh azenan mangɨ, egh mɨdorozir gumazibav kemeghtɨ, me nɨn fɨrim atugham. Egh me nɨ isɨ ter akɨnitamɨn nɨn kuam aguraghtɨ, kuaraziba izɨ nɨn namnamra amam.” ");
INSERT INTO msy2020_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ezɨ namba 3ɨn dughiam Isipɨn atrivim uan ingangarir gumaziba bagha isar ekiam gami, me isar kamɨn ikɨ amebam a batezir dughiam gɨnɨghnɨgham. Ezɨ a gumazir wainɨn ingarim ko bretɨn ingarim inigha uan ingangarir gumazibar guamɨn aning asara. ");
INSERT INTO msy2020_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Egha wainɨn garir gumazim mɨkemezɨ a ua uan ingangarim bagha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Egh atrivim mɨdorozir gumazibav kemezɨ, me gumazir bretɨn ingarim isa temer akɨnimɨn anegura. Ezɨ guizbangɨra Josep aningɨn irebabar gun mɨkemezɨ moghɨra bizir kaba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ezɨ gumazir atrivimɨn wainɨn garir kam ua Josep gɨnɨghnɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ezɨ azenir pumuning ghua gɨvazɨma, Isipɨn atrivim irebamɨn gani. A irebamɨn uabɨn gari, a Nailɨn Fanem boroghɨn tughav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A garima, 7plan bulmakaun mɨkarziba sara itir ekiaba dɨpamɨn anagava otifi. Egha graziba dɨpar mɨriamɨn da api. ");
INSERT INTO msy2020_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ezɨ gɨn 7plan igharaziba dɨpamɨn ikegha anagava otifi. Egha me bar aghariba gunigha mɨkarziba eromotuegha men ganganiba bar ikufi. Ezɨ bulmakaun aghariba guizir kaba mɨkarziba sara itir kabar boroghɨn tuivighav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ezɨ aghariba guizir bulmakaun kaba, mɨkarziba sara itiba apava da tuizɨ da iraghue. Egha atrivim irebar kamɨn ganigha gɨvagha ose. ");
INSERT INTO msy2020_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Egha a uam akua irebar mamɨn gani. Ezɨ irebar a ua ganizir kam, a gari 7plan raizɨn dapaniba raizɨn agharir vamɨra gata mɨsefe. Ezɨ dapanir kaba ekevegha raizɨn ovɨzir bar avɨriba dar ikia, anizɨ dar aghoramin dughiam roghɨra ize. ");
INSERT INTO msy2020_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ezɨ gɨn 7plan raizɨn dapanir igharaziba otifi. Amɨnir mam danganir mɨsɨngizimɨn otogha iza dagh apongezɨ da isigha bar sufi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Egha raizɨn dapanir suvizir kuraba, da raizɨn dapanir ekiar aghuiba apa da tuavaremezɨ da bar iraghue. Ezɨ atrivim uam osegha dɨkavigha fo, kar pura irebamra. ");
INSERT INTO msy2020_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Egha mɨzaraghara a nɨghnɨzir avɨribagh amua, egha Isipɨn fofozir gumaziba ko kukunir gumaziba, men diazɨ me izima, a uan irebar pumuningɨn me mɨgeima, irebar kamningɨn mɨngarimning abɨghamin gumaziba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ezɨ gɨn gumazir atrivimɨn dɨpenimɨn wainɨn garim kamaghɨn a mɨgei, “Datɨrɨghɨn kɨ uan arazir kurar amizir mamɨn gun mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nɨ fomɨra uan ingangarir gumazimning ko adarim ikia, egha kɨ ko nɨn bretɨn ingarir gumazibar dapanim, ga amadazɨ, ga ghua kalabusɨn ikia, nɨn mɨdorozir gumazibar dapanimɨn dɨpenimɨn ike. ");
INSERT INTO msy2020_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Egha dɨmagarir mamɨn ga uaghara irebamningɨn gani. Ezɨ gan irebamningɨn mɨngarimning, uaning oghara. ");
INSERT INTO msy2020_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ezɨ Hibruian gumazir igiar mam uaghan ga ko iti. A mɨdorozir gumazir kabar dapanimɨn ingangarir gumazir kɨnim. Ezɨ ga uan irebamningɨn gun a mɨkeme. Ezɨ a gan irebamningɨn mɨngariba abigha ga mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ezɨ biziba da guizɨn a mɨkemezɨ moghɨrama otifi. Ezɨ kɨ uamategha uan ingangarim ini. Ezɨ gumazir bretɨn ingarim, me tememɨn anegura.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ezɨ Isipɨn atrivim akar kam baregha uan ingangarir gumazibav keme, eghtɨ me mangɨ Josep inigh izam. Ezɨ me zuamɨra kalabusɨn dɨpenimɨn ghugha a inigha ize. Ezɨ Josep uan ghuamasɨzim gisegha korotiar aghuiba aghuizɨ, me a inigha atrivim bagha ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ezɨ atrivim kamagh Josep mɨgei, “Kɨ irebamɨn gani, ezɨ gumazir an mɨngarim abɨghamba puvatɨ. Ezɨ gumazamiziba ghaze, nɨ a baregh an mɨngarim abɨghamin fofozim iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ezɨ Josep kamaghɨn an akam ikaragha ghaze, “Kɨ uabɨ fofoziba puvatɨ, ezɨ Godra nɨn irebamɨn mɨngarim deragh anebightɨ, nɨ a baragh bar akuegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Egha atrivim ghaze, “Kɨ kamaghɨn irebamɨn gani. Kɨ Nailɨn faner mɨriamɨn tughav iti, ");
INSERT INTO msy2020_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","egha gari bulmakaun 7plan mɨkarziba sara itiba dɨpamɨn ikegha anagav otifi. Egha dɨpar mɨriamɨn graziba api. ");
INSERT INTO msy2020_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ezɨ gɨn bulmakaun 7plan igharaziba anagav otifi. Egha me aghariba gunigha, mɨkarziba eromotuegha ganganiba bar ikufi. Kɨ Isipɨn aven bar bulmakaun kamaghɨn garitamɨn ganizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ezɨ bulmakaun agharir kaba, bulmakaun mɨkarziba sara itir kaba apa da tuavaremezɨ da bar iraghue. ");
INSERT INTO msy2020_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Me amegha gɨvagha egha men ganganim mati me amezir puvatɨ. Ezɨ kɨ maghɨra osegha dɨkafi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Egha gɨn kɨ uam akua ua irebar mamɨn gari. Kɨ gari, 7plan raizɨn dapaniba raizɨn agharir vamɨra gata mɨsefe. Ezɨ dapanir kaba ekevegha raizɨn ovɨzir bar avɨriba ikia egha anizɨ, dughiar dar aghoramim roghɨra ize. ");
INSERT INTO msy2020_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ezɨ gɨn 7plan raizɨn dapanir igharaziba otifi. Amɨnir mam danganir mɨsɨngizimɨn otogha iza dagh apongezɨ da isigha, bar sufi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Egha raizɨn dapanir suvizir kuraba, raizɨn dapanir ekiar aghuiba apa da tuavaremezɨ da bar iraghue. Ezɨ kɨ osegha dɨkavigha, kukunir gumazir bizibar gariba kɨ uan irebamɨn gun me mɨgei, ezɨ nan irebar kɨ ganizir kamningɨn mɨngarim abɨghamin gumaziba puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ezɨ Josep kamaghɨn mɨgei, “Nɨn irebamningɨn mɨngarimning uaghara ghu. God damuamin bizim, a nɨn akakasi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Guizbangɨra, 7plan bulmakaun mɨkarziba sara itir kaba, da 7plan azenibar ababanim gami. Ezɨ 7plan raizɨn dapanir aghuiba, da uaghan 7plan azeniba. Egha da bizir vamɨram akakasi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ezɨ gɨn otivizir 7plan bulmakaun aghariba guniziba, ko raizɨn dapanir 7plan kaba, amɨnir puvɨra feim iza dagh apongezɨ, dar dagheba gɨn otivizir puvatɨ, da 7plan azenibar dagheba puvatɨghamin ababanim aka. ");
INSERT INTO msy2020_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kɨ faragha nɨ mɨkemegha gɨfa, God damuasava amir bizim, a nɨ mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Guizbangɨra, 7plan azeniba Isipɨn kantrin aven dagheba bar izɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Eghtɨ gɨn 7plan azenibar dagheba puvatɨzir dughiam otoghtɨ, Isipia ua dagheba avɨrasamezir dughiabagh nɨghnɨghan kogham. Eghtɨ mɨtiriam aghamin dughiar bar ekiam, kantrin kamɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Eghtɨ mɨtiriam aghamin dughiar gɨn izamin kam bar ikuvigham, kamaghɨn gumazamiziba dughiar me dagheba avɨrasemezir kam bar a gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ezɨ God bizir kam damuasa nɨghnɨzim akɨrigha gɨfa. Kamaghɨn a mɨngarir vamɨra itir irebar kamning nɨn aka. A uaghan kamaghɨn nɨn akagha ghaze, bizir a damuamin kam, a zuamɨram otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Eghtɨ nɨ datɨrɨghɨn Isipɨn kantrin ganamin fofozim ko nɨghnɨzir aghuim itir gumazitam atɨghtɨ, a Isipɨn kantrin aven ingangariba bar dagh ativagh dar ganam. ");
INSERT INTO msy2020_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Egh nɨ gumazir dapanir taba uaghan, me amɨsefegh. Eghtɨ gumazir dapanir kaba, 7plan azenibar vaghvagh dagheba izɨvazir dughiam, me gumazamizibav kɨmtɨ, me uan azenibar dagheba isɨ 5plan pozibar arigh, dar pozitam takisɨn mɨn a inigh gavman bagh anenɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Eghtɨ gumazir dapaniba azenir aghuir kabar, dagher kaba inigh da akufagh. Egh me nɨn ziam ko gavgavimɨn apengan ingarɨva raizɨbagh eghuvagh, da isɨ dagher dɨpenir ekiar nguibar ekiabar itibar amangigh deraghvɨra dar gan. ");
INSERT INTO msy2020_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Eghtɨ gɨn dagheba puvatɨzir 7plan azeniba Isipɨn kantrin otoghtɨ, gumazamiziba dagher gumazir dapaniba pozibav kɨnizir kaba iniam. Tuavir kamɨn gumazamiziba dagheba oteveghamin dughiamɨn, me ovengan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ezɨ Isipɨn atrivim uan ingangarir gumaziba ko Josepɨn akam baregha bar an gakonge. ");
INSERT INTO msy2020_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Egha atrivim uan gumazir dapaniba kamaghɨn me mɨgei, “Godɨn Duam gumazir kamɨn aven iti. Ezɨ ingangarir kam damuamin gumazitam an mɨn itir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Egha atrivim kamaghɨn Josep mɨgei, “God uabɨ bizir kaba aka, ezɨ ua gumazitam nɨn mɨn nɨghnɨzir aghuitam ko fofozir aghuitam itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ezɨ kɨ uan kantri bagh nɨ amɨseveghtɨ, nɨ nan kantrin gumazir dapanimɨn ikiam. Eghtɨ nan gumazamiziba nɨn akam baragham. Kɨ uabɨ atrivimra, egh nan ziam uabɨra nɨn ziam gafiragham.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Egha atrivim kamaghɨn Josep mɨgei, “Nɨ oragh, kɨ datɨrɨghɨn Isip bar an ganamin gumazir dapanimɨn ikiasa nɨ amɨsefe.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Egha atrivim uan dafarimɨn ring suegha Josep garu. Ezɨ ringɨn kam atrivimɨn ababanim an iti. Egha atrivim uaghan korotiar aghuir mam a garugha gol sen an fɨrimɨn da. ");
INSERT INTO msy2020_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Egha Josep ataghizɨ an atrivimɨn karisɨn namba 2ɨn arui. Ezɨ ingangarir gumaziba an faragha ghua kamaghɨn dɨa ghaze, “Gumazir ekiam izi! Tuavim gitagh!” Egha kamaghɨn atrivim Josep gamizɨ a Isipɨn kantrin nguibaba bar dar gumazir dapanimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ezɨ atrivim kamaghɨn Josep mɨgei, “Kɨ atrivim. Egha kɨ mɨgei, Isipɨn gumazitam uan ifongiamɨn gɨn mangɨ bizitam puram a damighan kogham. Bar puvatɨgham. A faragh nɨn azaragham.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Egha atrivim ziam Safenat Panea Josep gatɨ. Egha amuir mam a ganɨngi. Ezɨ amizir kamɨn ziam Asenat, a Potiferan guivim, Potifera a Heliopolisɨn nguibamɨn itir Isipɨn aseba bagha ofa gamir gumazir mam. Egha Josep Isipɨn kantrin aven itir nguibaba bar dagh aruigha dar gani. ");
INSERT INTO msy2020_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Josep 30plan azeniba ikia Isipɨn atrivimɨn ingangarim gami. Egha Josep atrivim ategha Isipɨn kantrin itir nguibaba bar dagh arui. ");
INSERT INTO msy2020_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ezɨ 7plan azenir aghuibar, Isipɨn aven dagher bar avɨriba otifi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ezɨ 7plan azenir kabar, Josep dagher avɨribagh kuva da arɨsi. Nguibar ekiaba vaghvagha, a men azenibar dagheba isa, dagher dɨpenibar da akuva da arɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Egha raiziaba, a da isa dagher dɨpenir bar ekiar avɨribar da arɨzi, da ongarimɨn gigimɨn mɨn ghuzɨ, Josep datɨrɨghɨn ua mengan iburagha uaghan da osirizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ezɨ dagheba tɨghar oteveghamin dughiamɨn, Josepɨn amuim Asenat, an otarir pumuning bate. Asenat a Potiferan guivim. Potifera, a Heliopolisɨn nguibamɨn itir ofa gamir gumazim. ");
INSERT INTO msy2020_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ezɨ Josep kamaghɨn mɨgei, “God nan akurazɨ kɨ uan afeziamɨn adarazi gɨn amadagha, uaghan uan osɨmtɨziba gɨn amada.” Egha kamaghɨn a uan otarir ivariam, ziam “Manase,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Egha a uaghan ghaze, “God borim danganir kɨ osɨmtɨziba itimɨn na ganɨngi.” Egha uan otarir dozim, ziam “Efraim,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ezɨ Isipɨn kantrin aven 7plan azenir aghuir kaba gɨvazɨ, ");
INSERT INTO msy2020_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Josep mɨkemezɨ moghɨn, azenir dagheba puvatɨzir kaba otifi. Dughiar kamɨn mɨtiriar ekiar kam kantrin igharaziba uaghan me batifi. Ezɨ Isipɨn kantrin aven dagheba bar nguibabar iti. ");
INSERT INTO msy2020_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ezɨ gɨn, dagheba otevezir arazir kam bar Isipɨn nguibabar otivima, gumazamiziba atrivim mɨgɨava arai, eghtɨ a dagheba me danɨngam. Ezɨ atrivim Isipɨn gumazamizibav gɨa ghaze, “Ia mangɨ Josep batoghtɨ, a mɨkemezɨ moghɨn damu.” ");
INSERT INTO msy2020_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ezɨ Isipɨn aven mɨtiriam bar ekevezɨ, Josep dagher dɨpenir ekiaba kuizɨ, Isipɨn gumazamiziba iza daghebagh ivesi. ");
INSERT INTO msy2020_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ezɨ mɨtiriar bar ekiam kantriba bar paza me gami. Ezɨ kamaghɨn kantriba bar dar gumazamiziba Josep bagha iza a da daghebagh ivesi. ");
INSERT INTO msy2020_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ezɨ Jekop kamaghɨn orazi, Isipɨn witba iti, ezɨ a uan otaribav gɨa ghaze, “Manmaghɨn amizɨ ia pura onganir ganganibagh amua purama apiaghav iti? ");
INSERT INTO msy2020_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Kɨ akar mam kamaghɨn a baraki, Isipɨn kantrin aven me witba iti. Ia mangɨ e uari bagh tabagh ivesegh, puvatɨghtɨ e daghem bagh arɨmɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ezɨ Josepɨn aveghbuar 10pla Kenanɨn nguazim ategha witbagh ivezasa Isipɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ezɨ Jekop Josepɨn dozimra Benjamin amadazɨ a men gɨn ghuzir puvatɨ. Jekop kamaghɨn atiatingi, a mangɨ tuavimɨn osɨmtɨzitam batogham. ");
INSERT INTO msy2020_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Mɨtiriar ekiar kam uaghan Kenanɨn nguazimɨn oto, kamaghɨn Kenanɨn gumaziba witbagh ivezasa Isipɨn zui, ezɨ Jekopɨn otariba uaghan me ko tuavimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Dughiar kamɨn Josep a Isipɨn gavmanɨn gumazir dapanimɨn iti, ezɨ danganiba bar dar gumaziba ghua ada witbagh ivesi. Ezɨ Josepɨn aveghbuaba ghua a batogha, an suebar boroghɨn teviba apɨrigha guaba nguazim gire. ");
INSERT INTO msy2020_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ezɨ Josep uan aveghbuabar ganigha me gɨfogha, mati me gɨfozir puvatɨzɨ moghɨn me mɨgei. Egha a pamten me mɨgɨa ghaze, “Ia managh ikegha ize?” Ezɨ me kamaghɨn a ikaragha ghaze, “E Kenanɨn nguazimɨn ikegha izegha, daghebagh ivezasa.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ezɨ Josep uan aveghbuabar gara me gɨfozɨ me a gɨfozir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Egha a fomɨra irebamɨn gari an aveghbuaba a bagha teviba apɨrizir bizir kam uam a gɨnɨghnɨgha kamaghɨn mɨgei, “Ia moga garir gumazibar mɨn en ganasa ize. Ia izɨ kamaghɨn gan foghasa, en kantrin danganir manabara gavgavizir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ezɨ me an akam kamaghɨn a ikaragha ghaze, “Puvatɨ, gumazir ekiam. E nɨn ingangarir gumaziba, e nɨ da daghebagh ivezasa ize. ");
INSERT INTO msy2020_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","E bar moghɨra gumazir mamɨn boriba. E moga garir gumaziba puvatɨ. E gumazir guizbangɨra mɨgeiba.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ezɨ Josep kamaghɨn mɨgei, “Puvatɨ. Ia izɨ ganigh foghfoghasa, nan kantrin danganir manaba gavgavizir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ezɨ me ghaze, “Gumazir ekiam, e 12plan aveghdiariba. E Kenanɨn nguazimɨn gumazir vamɨran boriba. Ezɨ en dozir bar abuananam, datɨrɨghɨn uan afeziam ko iti. Ezɨ en aveghbuar mam, an ovenge.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Ezɨ Josep ua kamaghɨn me mɨgei, “Kɨ ia mɨkemegha gɨfa, ia moga garir gumaziba. ");
INSERT INTO msy2020_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Kɨ ifavarir arazim gɨfoghasa, egha Isipɨn atrivimɨn ziamɨn gavgavimɨn guizbangɨra kamaghɨn ia mɨgei, ian dozir bar abuananam izɨ nan guamɨn tughan koghtɨ, ia ua uan nguibamɨn mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Egh ia uan tav amadaghtɨ a mangɨ ian dozim inigh izɨ. Eghtɨ ian tarazi kalabusra ikɨ mangɨtɨ e deragh fogham, ian akam a guizbangɨra o puvatɨ. Puvatɨghtɨma kɨ Isipɨn atrivimɨn ziamɨn guizbangɨra kamagh mɨkɨmasa, ia moga garir gumaziba.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Egha Josep mɨkemegha gɨvagha 3plan dughiabar me isa kalabus gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Egha dughiar namba 3ɨn Josep kamaghɨn me mɨgei, “Kɨ Godɨn apengan itir gumazim, ia nan akam baregh an gɨn mangɨ egh ia deragham. ");
INSERT INTO msy2020_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Egh ia guizbangɨra mɨgeir gumaziba ikɨva, tav uabɨra kalabusɨn dɨpenir ia ikezimɨn ikɨ. Eghtɨ ia igharaz darazi witɨn ivezeziba inigh uan bighan mangɨ uan adarazir anɨng, mɨtiriam men azi. ");
INSERT INTO msy2020_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Egh ia uan dozir abuananam inigh na bagh izɨtɨ kɨ fogham, ia guizbangɨra mɨgei. Ia kamaghɨn damigh egh ovengan kogham.” Ezɨ me Josepɨn mɨgɨrɨgɨam gakuegha ghaze, Are. ");
INSERT INTO msy2020_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Egha Josepɨn aveghbuaba a ko ikiavɨra ikia, uarira uariv gɨa ghaze, “Bar guizbangɨra, e uan aveghbuam pazava a gamigha egha osɨmtɨzir kam iti. E an gari an en diava arava uabɨn akurvaghasa en gari, ezɨ e an akam baraghizir puvatɨ. Kamaghɨn osɨmtɨzir datɨrɨghɨn e batozir kam, en arazir kurar kam ikara.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ezɨ Ruben kamaghɨn mɨgei, “Kɨ ia mɨkemegha gɨfa, ia arazir kuratamɨn otarir kam pazɨva a damuan markɨ, ezɨ ia nan akam baraghizir puvatɨ. Ezɨ osɨmtɨzir datɨrɨghɨn e batozir kam, kar an ovevemɨn ikarvazim.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ezɨ Josepɨn aveghbuaba Hibrun akam mɨgɨa mɨgɨrɨgɨar kabagh amua ghaze Josep men mɨgɨrɨgɨar kaba baraghizir puvatɨ. Guizbangɨra, a faragha zurara me ko mɨgɨa Isipian akamɨn me mɨgeima, gumazir igharazim an akam gɨgha Hibrun akam an aveghbuabav gei. ");
INSERT INTO msy2020_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Egha Josep datɨrɨghɨn men akaba baregha me ategha ghuava azi. Ana azigha gɨvagha uamategha iza me ko mɨgei. Egha a Simeonɨn suighasa ingangarir gumazibav kemezɨ, me an suira. Egha benir gavgavim inigha an aveghbuabar damazimɨn a ike. ");
INSERT INTO msy2020_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Egha gɨn Josep ingangarir gumazibav kemezɨ, me witba isa vaghvagha men mɨtaribagh aghuigha, uaghan men dagɨaba vaghvagha men mɨtaribagh aghui. Egha uaghan, ingangarir gumaziba me tuavimɨn damamin dagheba uaghan me ganɨngi. Egha Josep mɨkemezɨ moghɨra ingangarir gumaziba ami. ");
INSERT INTO msy2020_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ezɨ an aveghbuaba witɨn mɨtariba isa donkibar afegha me zui. ");
INSERT INTO msy2020_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Egha danganir mamɨn otivigha dɨmangan dakuasava anekɨra, men mav uan donki dagheba a danɨngasa uan mɨtarim fɨri. Egha uan dagɨabar gari, da mɨtarir akamra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Egha kamaghɨn a uan aveghbuabar dia, “Ia gan! Dagɨar kɨ me ganɨngiziba, me uam nan dagɨaba na ganɨngi. Me da na mɨtarim garu.” Ezɨ men dɨghoriba me ginivima me agoa bar atiatigha, uarira uarir azangsɨgha ghaze, “God man arazimrama e gami?” ");
INSERT INTO msy2020_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Egha aveghbuaba Kenanɨn nguazimɨn otogha, uan afeziam Jekop, bizir me bativizibar gun bar a mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Me kamaghɨn mɨgei, “Isipɨn ingangaribar garir gumazir ekiam, pamten e mɨgɨa akam e gasa ghaze, e gumazir moga gariba. ");
INSERT INTO msy2020_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ezɨ e an akam ikaragha ghaze, ‘E guizbangɨra mɨgeir gumaziba. E gumazir moga gariba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","E 12plan aveghbuaba. E gumazir vamɨran otariba. Ezɨ aveghbuar mam ovengezɨ, bar en dozim afeziam ko Kenanɨn nguazimɨn iti.’ ");
INSERT INTO msy2020_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Egha gavmanɨn ingangaribar garir gumazir ekiam ua kamaghɨn e mɨgɨa ghaze, ‘Kɨ deragh fogh suam ia guizbangɨra mɨgei. Eghtɨ kɨ kamaghɨn damuam, ian tav na ko ikɨtɨ, igharaz darazi witba inigh uan adarazi bagh mangɨ, uan adarazir akuragh, me mɨtiriamra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Egh ia uan dozir bar igiamɨn aku na bagh izɨ. Eghtɨ kɨ fogh suam ia moga garir gumaziba puvatɨ, ia gumazir guizbangɨra mɨgeiba. Eghtɨ kɨ ian aveghbuam ia danightɨ, ia uan ifongiamɨn kantrin kamɨn mangɨ izegh damu dagɨar ingangaribar amu.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Egha gɨn aveghbuaba uan witɨn mɨtariba ingegha gari, men dagɨar mɨtariba vaghvagha men mɨtaribar iti. Ezɨ afeziam uaghan ganigha, me dɨgavir kuram gamigha atiatigha bar oseme. ");
INSERT INTO msy2020_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ezɨ Jekop kamaghɨn me mɨgei, “Iarara kam gamima, nan otarir pumuning ovenge. Faragha Josep ovengezɨ datɨrɨghɨn Simeon ovenge. Egha datɨrɨghɨn ia uaghan Benjamin inigh nan saghon mangasa?” ");
INSERT INTO msy2020_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ezɨ Ruben afeziam mɨgɨa ghaze, “Kɨ Benjamin inigh izeghan koghtɨ, nɨ nan otarir pumuning mɨsueghtɨ aning aremegh. Nɨ nan amamangatɨghtɨ, a nan dafarimɨn ikeghtɨ, kɨ uam an aku izam.” ");
INSERT INTO msy2020_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ezɨ Jekop kamaghɨn mɨgei, “Nan otarir kam ia ko mangan kogham. An avebam ovengezɨ, a uabɨra iti. Kɨ ghurigha gɨfa. A mangɨ tuavimɨn osɨmtɨzitam batoghtɨ, ia na damightɨ nan nɨghnɨziba ikuvigham, eghtɨ kɨ aremegh Gumazamizir Oveaghuezibar Nguibamɨn magɨram.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Dughiar kamɨn Kenanɨn nguazimɨn aven mɨtiriar aghazir kam ghua bar ekefe. ");
INSERT INTO msy2020_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ezɨ Jekopɨn adarasi, an ziar mam Israel, me dagher faragha Isipɨn iniziba da gɨfa, ezɨ Israel kamaghɨn uan boribav gei, “Ia uamategh Isipɨn mangɨ e uari bagh daghebagh ives.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ezɨ Juda kamaghɨn afeziam mɨgei, “Afeziam, e nɨ mɨkemegha gɨfa. Isipɨn gavmanɨn garir gumazim, akar gavgavim e ganɨngi. A kamaghɨn e mɨkemegha gɨfa, en dozim e ko mangan koghtɨ, a uam en ganan aghuagham. ");
INSERT INTO msy2020_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Egh nɨ en dozimɨn amamangatɨghtɨ, an e ko mangɨtɨ, e mangɨ nɨ bagh daghebagh ivezam. ");
INSERT INTO msy2020_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Isipɨn gavmanɨn garir gumazir ekiam mɨkemegha gɨfa, en dozim uaghan e ko mangɨghan koghtɨ, a uam en ganan aghuagham. Eghtɨ nɨ en gɨn anemangan aghuaghtɨ e mangan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ezɨ afeziam Israel kamaghɨn mɨgei, “Ia manmaghsuavɨra Isipɨn gavmanɨn garir gumazim mɨgɨa ghaze, ia dozir mam iti? Ia bar osɨmtɨzir ekiam na ganɨdi.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ezɨ me a ikaragha ghaze, “Gumazim uaghan azangsɨzir avɨribar e gami. An en adarazi bagha en azangsɨsi. Egha ghaze, ‘Ian afeziam ikiavɨra iti, o an areme? Ia aveghbuatam ua iti, o puvatɨ?’ A kamaghɨn azangsɨzima e a mɨkeme. Egha e kamaghɨn fozir pu, an en dozim e a inigh mangasa an en azangsɨsi.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ezɨ Juda uan afeziam Israel kamaghɨn a mɨgei, “Nɨ Benjamin ateghtɨ, a na ko izɨ, e mangam. Eghtɨ nɨ ko en boriba uaghara, e bar moghɨra daghem bagh ovengan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kɨ uabɨ, kɨ a geghuva an ganam. Egh kɨ uamategh nɨ bagh a inigh izeghan koghtɨ, osɨmtɨzir ekiar kam nan ikɨtɨ, nan arazir kurar kam na ko ikɨ mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Guizbangɨra, nɨ en anogoroghezir puvatɨzɨ, e ti dughiar pumuningɨn ghuegha izeghai.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ezɨ Israel kamaghɨn me mɨgei, “Tuaviba ua puvatɨghtɨ, ia kamaghɨn damu. Ia nguazir kamɨn bizir aghuiba inigh uan akɨrabar aghuighɨva, da inigh mangɨ Isipɨn gavmanɨn garir gumazir dapanim bizir aghuibar mɨn a danɨngigh. Bizir aghuir kaba ia da ini, hani, mɨkarzibagh azuir bizir guar avɨriba, mughuriar aghuim zuir boreba, temebar eboriba, ko temer iamorir ovɨzibar mɨn gari, me pistasio ko amonɨn dar bori. ");
INSERT INTO msy2020_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ia ua dagɨar me isa ian mɨtaribagh aghuiziba inigh mangɨ. Egh ia dagɨar ia faragha inigha ghueziba, ia dagh isɨn dagɨataba ua dar arɨkigh. Me ti okɨnɨghnigha da aghui. ");
INSERT INTO msy2020_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Egh ia uan dozim inigh dɨkavigh egh zuamɨra gumazir kam bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kɨ God ko mɨkɨmamin mɨgɨrɨgɨam kara, Gavgaviba Bar Itir God, gumazir kamɨn nɨghnɨzimɨn akuraghtɨ a ian apangkufigh. Egh a ian aveghbuar igharazim ko Benjamin amadaghtɨ aning na bagh izɨ. God ifongeghtɨ nan boriba bar ovengeghtɨ, a dera kɨ pura ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ezɨ aveghbuaba bizir aghuiba inigha, dagɨar igharaziba inigha, me faragha inigha ghueziba isafuragha bar moghɨra da inigha zui. Egha me uaghan Benjamin inigha zui. Me ghua Isipɨn otogha ghua Josepɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ezɨ Josep gari, Benjamin uaghan me ko izima, a uan dɨpenimɨn garir gumazim mɨgɨa ghaze, “Nɨ gumazir kaba inigh nan dɨpenimɨn mangɨ. Egh bulmakaun tam mɨsuegh a isam. Gumazir kaba aruer arɨzimɨn na ko damam.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ezɨ ingangarir gumazim Josep mɨkemezɨ moghɨn amigha, me inigha Josepɨn dɨpenimɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ezɨ aveghbuaba dɨpenimɨn ghuava, atiatigha ghaze, “Me dagɨar faragha en mɨtaribagh aghuizɨ e inigha izeziba, me ti dagh nɨghnɨghama. Egha bizir mɨngarir kam bagha e inigha dɨpenimɨn zui. Me ti en suigh e damightɨ e pura men ingangarir gumazibar otivigham. Egh me uaghan en donkiba inigham.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Egha me Josepɨn dɨpenimɨn ingarir gumazimɨn gari, a dɨpenimɨn tiar akamɨn tughav itima, me ghua kamaghɨn a mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Gumazir ekiam, nɨ orakigh. Dughiar faragha ghuzim, e kagh izegha daghebagh ivese. ");
INSERT INTO msy2020_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Egha e ia ategha ghua tuavimɨn danganir mam akɨrigha dɨmagarimɨn dakuasava an iti. Egha bar moghɨra uan mɨtariba kuigha dar gari, daghebagh ivezezɨ dagɨaba, uam en mɨtarir akabar iti. Ezɨ e datɨrɨghɨn ua dagɨar kabar akua izi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Egha e dagɨar igharazir maba daghebagh ivezasa uaghan da inigha izi. E fozir pu, tinara dagɨar kaba en mɨtaribagh aghui.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ezɨ ingangarir gumazim men akam baregha kamaghɨn me mɨgei, “Ia atiating nɨghnɨzir avɨribar amuan markɨ. Ian God, a uaghan ian afeziamɨn God, a uabɨ ian dagɨaba isa ian mɨtaribagh aghui. Ezɨ kɨ uabɨ, dagɨar ia daghebagh ivezeziba, kɨ da inigha gɨfa.” Egha a ghua Simeon inigha iza me ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Egha gɨn ingangarir gumazim me inigha Josepɨn dɨpenimɨn aven ghu. Egha dɨpar me uan dagariba ruamim, me ganigha, dagheba isa men donkibagh anɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Egha aveghbuaba orazi, Josep izɨ me ko dughiar arɨzimɨn damam, ezɨ me uan bizir aghuir a danɨngamba akɨrmɨsi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ezɨ Josep dɨpenimɨn izezɨ, me bizir aghuir kaba inigha ghuava a ganɨdi. Egha teviba apɨrigha Josepɨn guamɨn avigha guaba isa nguazimɨn bɨri. ");
INSERT INTO msy2020_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ezɨ Josep dughiam me ganɨga ghaze, “Dughiar aghuim, ia deravɨra iti?” Egha gɨn kamagh men azara, “Ian afeziar ghurir ia faragha na mɨkemezim, a manmaghɨram amua iti? A deraghavɨra iti o?” ");
INSERT INTO msy2020_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ezɨ me a ikaragha ghaze, “Gumazir ekiam, en afeziam nɨn ingangarir gumazim, a deraghvɨra iti.” Egha me uam an ziam fasa an guamɨn dapaniba avingi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ezɨ Josep garima, an dozimra, Benjamin itima, a kamaghɨn mɨgei, “Ia faragha uan dozir bar abuananamɨn gun na mɨkeme, ezɨ gumazir kam kar ian dozimra, o?” Egha a kamagh Benjamin mɨgei, “Nan gumazir igiam, God deravɨra nɨ damu nɨn apangkufigh.” ");
INSERT INTO msy2020_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Egha Josep uan dozim bar an apangkuvigha, bar aziasava ami. Egha zuamɨra dɨkavigha akuir danganimɨn aven ghughava, azi. ");
INSERT INTO msy2020_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Egha gɨn a uan guam rue. Egha a gavgavim inigha uamategha me bagha iza ingangarir gumazim mɨgɨa ghaze, nɨ mangɨ dagheba tuigh dagher dakozim dafegh. ");
INSERT INTO msy2020_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Egha me Josep baghavɨra dagheba dagher dakozir igharazim dafegha, an aveghbuaba bagha igharazim dafe. Isipia Hibrun adarazi koma apir puvatɨ. Arazir kam men damazibar bar derazir puvatɨ, kamaghɨn, Isipian Josep ko itiba, me dagher dakozir igharazim gapera. ");
INSERT INTO msy2020_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ezɨ Josep uan ingangarir gumazibav gɨa ghaze, aveghbuaba vaghvagh, dabirabibar dapighirɨ. An ifongiam, aveghbuaba uan otɨrmɨrimɨn azenibar gɨn mangɨ dapighiram, otarir ivariamɨn ikegh mangɨ bar dozimɨn tugh. Ezɨ aveghbuaba iza uan dabirabir kabar apiagha gara, dɨgavir kuram gamigha pura uarir gari. ");
INSERT INTO msy2020_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ezɨ ingangarir gumaziba aveghbuaba bagha Josepɨn dagher dakozimɨn dagheba tuigha me ganɨngi. Egha Benjamin bagha bar dagher ekiam tui, mati 5plan gumaziba damamin dagheba isa a ganɨngi. Ezɨ me Josep ko amegha wainɨn dɨpar onganiba apa egha bar akuegha egha ongani. ");
INSERT INTO msy2020_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Egha me amegha gɨvazɨma Josep uan dɨpenimɨn garir gumazim mɨgɨa ghaze, “Nɨ gumazir kabar mɨtariba dagheba dar aghutɨ da mangɨ bar izefegh. Egh men dagɨaba men mɨtariba vaghvagh dar akabar aven dar aghuigh. ");
INSERT INTO msy2020_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Egh nan silvan kap isɨ, gumazir bar igiar munamɨn mɨtarim darugh, egh dagɨar a witbagh ivezasa inigha izeziba sara an mɨtarim darugh.” Ezɨ ingangarir gumazim Josep mɨkemezɨ moghɨrama ami. ");
INSERT INTO msy2020_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ezɨ bar mɨzaraghara Josepɨn ingangarir gumazim, aveghbuaba uan donkiba ko me amadazɨ, me zui. ");
INSERT INTO msy2020_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ezɨ aveghbuaba nguibar ekiam ategha, tɨghar saghon mangam, ezɨ Josep uan ingangarir gumazir an dɨpenimɨn garim mɨgɨa ghaze, “Nɨ dɨkavigh gumazir kabar gɨn mangɨ, me batogh, kamaghɨn men azaragh, ‘E arazir aghuimɨn ia gami. Ezɨ manmaghɨn amizɨ ia arazir kuramɨn e gami? ");
INSERT INTO msy2020_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kavɨn ia inizir kam, kar nan gumazir ekiam dɨpaba apir kap. Egha uaghan, a bizir mogomeba bagha asebar azangsɨgha, kavɨn kamra a kukunir gumazibar mɨn, bizir mogomebagh fofosi. Ia bar arazir kuram gami.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ezɨ Josepɨn ingangarir gumazim aveghbuabar gɨn ghua, me batogha Josepɨn akabar gun me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ezɨ me an akam ikaragha ghaze, “Gumazir ekiam, nɨ manmaghsuavɨra akar kamaghɨn amizimɨn e mɨgei? E nɨ mɨgeir arazir matam bar a damighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nɨ fo, e faragha Kenanɨn nguazim ategha izegha datɨrɨghɨn uamategha iza ian gari. E dagɨar en mɨtarir akabar itiba ua da inigha ize. Ezɨ manmaghsua nɨ ghaze, e nɨn gumazir ekiamɨn dɨpenimɨn an silva ko golba okɨmam? ");
INSERT INTO msy2020_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Gumazir ekiam, nɨ gan en tav kavɨn kamɨn suiraghtɨ, nɨ a mɨsueghtɨ an aremegh. Eghtɨ e pura nɨn ingangarir gumazir kɨnibar ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ezɨ ingangarir gumazim me ikaragha ghaze, “Ian akam, a guizbangɨra. Eghtɨ kɨ gumazir kavɨn suirazir kamɨn apightɨ, anarɨra nan ingangarir gumazir kɨnimɨn ikiam. Eghtɨ ia tarazi mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ezɨ me vaghvagha zuamɨra uan mɨtariba isa nguazim dafegha da kui. ");
INSERT INTO msy2020_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ezɨ Josepɨn ingangarir gumazim men mɨtaribar averiabar gari, egha men avebamɨn mɨtarim faragha an gara, ghua bar men dozimɨn tu. Egha Benjaminɨn mɨtarimɨn kavɨn kamɨn api. ");
INSERT INTO msy2020_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ezɨ aveghbuaba gari, kavɨn kam Benjaminɨn mɨtarimɨn itima, me atiatighava uan osɨmtɨzim akakagha uan korotiaba abɨsi. Egha uan mɨtariba donkibagh afegha uamategha nguibar ekiamɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ezɨ Juda uan aveghbuaba ko ua Josepɨn dɨpenimɨn otogha an gari, a ikiavɨra iti. Ezɨ me bar atiatigha pura Josepɨn damazimɨn nguazim gire. ");
INSERT INTO msy2020_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ezɨ Josep kamaghɨn me mɨgei, “Ia arazir manmaghɨrama amizim gami? Ia ti kamaghɨn fozir puvatɨ, kɨ aseba ko ingara bizir mogomebagh fofozir fofozim iti?” ");
INSERT INTO msy2020_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ezɨ Juda kamaghɨn mɨgei, “Gumazir ekiam, e nɨ mɨkɨmamin mɨgɨrɨgɨaba puvatɨ. E kamaghɨn mɨkɨman kogham, e bizitam pazava a gamizir puvatɨ. God en arazir kuram akagha gɨfa. Ezɨ gumazir ekiam, gumazir nɨn kap inizir kam, a uabɨra nɨn ingangarir gumazir kɨnimɨn ikian kogham. Bar puvatɨ. E bar moghɨra.” ");
INSERT INTO msy2020_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ezɨ Josep kamaghɨn mɨgei, “Bar puvatɨ. Kɨ ia ateghtɨ ia mamaghɨn damuan kogham. Gumazir nan kap okemezir kamra, a uabɨra nan ingangarir gumazir kɨnimɨn ikiam. Ia igharaziba navir amɨrizim inigh egh uamategh afeziam bagh mangɨ. Kɨ mɨgɨrɨgɨaba ian puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ezɨ Juda Josepɨn boroghɨn ghua kamaghɨn mɨgei, “Gumazir ekiam, nɨ uan ingangarir gumazimɨn akam barakigh. Kɨ gumazir kɨnim, ezɨ nɨ gumazir bar ekiam, egha Isipɨn atrivimɨn mɨn iti. Egh nɨ nan apangkuvigh nan ataran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Gumazir ekiam, nɨ faragha kamaghɨn en azara, ‘Ia afeziam ko dozitam iti, o puvatɨ?’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ezɨ e ghaze, ‘Are, gumazir ekiam, e afeziam iti, a bar ghuri. Ezɨ en dozir bar vamɨra uaghan iti. En afeziam ghurigha gɨvazɨma, an amebam a bate. Amebar kam otarir pumuningrama ote, ezɨ guizɨn otarir kamɨn avebam areme. Ezɨ a bar uabɨra iti, kamaghɨn en afeziam bar a gifonge.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ezɨ gumazir ekiam, nɨ kamaghɨn e mɨkeme, ‘Ian dozim Benjamin izɨtɨ, kɨ an ganika.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ezɨ gumazir ekiam, e kamaghɨn nɨn akam ikaragha ghaze, ‘Borir kam afeziam ateghan kogham. An afeziam ateghtɨ, afeziam aremegham.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Egha nɨ gɨn uaghan kamaghɨn uan ingangarir gumazibav gei, ‘Ian aveghbuar dozim ian gɨn izeghan koghtɨma, ia ua nan damazim izan markɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ezɨ gumazir ekiam, e uamategha afeziam bagha ghugha, nɨn akar kamɨn gun a mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ezɨ gɨn afeziam ghaze, ‘Ia uamategh mangɨ, e uari bagh daghebagh ivesegh.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ezɨ e ghaze, ‘E mangɨghan kogham. Aveghbuar dozim e ko mangɨghan koghtɨma, gumazir ekiar kam guizbangɨra bar uam en ganan aghuagham. Eghtɨ en dozim e ko izɨtɨ, e mangam.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ezɨ en afeziam kamaghɨn e mɨkeme, ‘Ia fo, nan amuir kam otarir pumuning bate. ");
INSERT INTO msy2020_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ezɨ mam ovengezɨ kɨ uam an garir puvatɨ. Kɨ ghaze, asɨzir laionɨn tam ti a mɨsuegha aneghoraghsuezɨ, an areme. ");
INSERT INTO msy2020_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kɨ ghurigha gɨfa, ezɨ ia datɨrɨghɨn uaghan otarir kam inigh nan saghon mangasa. Kamaghɨn osɨmtɨzitam tuavimɨn a batoghtɨ, ia osɨmtɨzir dafam na danightɨ, kɨ aremegh Gumazamizir Oveaghuezibar Nguibamɨn magɨram.’ ");
INSERT INTO msy2020_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Gumazir ekiam, en afeziam nɨn ingangarir gumazim, kamaghɨn e ua uan afeziam bagh mangɨtɨ, afeziam gantɨ otarir kam e ko mangan koghtɨ, an nɨghnɨziba ikuvightɨ an aremegh Gumazamizir Oveaghuezibar Nguibamɨn magɨram. Guizbangɨra, otarir kam bar afeziamɨn dɨghorim. Ezɨ en afeziam a bar ghuri. Ezɨ otarir kam e ko uamategh mangɨghan koghtɨ, kamaghɨn e osɨmtɨzir ekiam afeziam danightɨ, an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Egha uaghan, kɨ akar dɨkɨrɨzir gavgavim afeziam kamaghɨn a ganɨga ghaze, kɨ otarir kamɨn aku uam a bagh mangan koghɨva, kamaghɨn kɨ arazir kuram damigham, eghtɨ osɨmtɨzir kam an damazimɨn nan ikɨ kamaghɨra ikɨ mangɨ, kɨ aremeghamin dughiam otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Kamaghɨn, gumazir ekiam, ga uaning, nɨ nan amamangatɨghtɨ, kɨ otarir kamɨn danganim inigh kagh ikɨ, egh pura nɨn ingangarir gumazir kɨnimɨn ikiam. Ga uaning, nɨ aneteghtɨ, a uan aveghbuaba ko mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Guizbangɨra, otarir kam na ko mangɨghan koghtɨ, kɨ uamategh afeziam bagh mangɨghan kogham. Eghtɨ osɨmtɨzir nan afeziam bativamin kam, kɨ an ganan bar aghua.” ");
INSERT INTO msy2020_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ezɨ Josep oregha bar apangkuvir ekiam ikia, egha kamaghɨn an aziasava ami. Kamaghɨn, a uan ingangarir gumazibar diagha ghaze, “Ia bar moghɨra azenimɨn mangɨ.” Eghtɨ a uabɨra uan aveghbuaba ko ikiam. Egha a kamaghɨn me mɨgɨa ghaze, “Kɨ Josep. Kɨ ian aveghbuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Egha Josep pamtemɨn azi, ezɨ Isipia a baraki. Egha ghua atrivimɨn dɨpenimɨn itir darazi bizir kamɨn gun me mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ezɨ Josep kamaghɨn uan aveghbuabav gei, “Kɨ Josep. Nan afeziam deraghavɨra iti, o?” Ezɨ an aveghbuaba bar dɨgavir kuram gamua bar atiatigha egha mɨgɨrɨgɨatam damuan asa. ");
INSERT INTO msy2020_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Egha Josep ua kamaghɨn mɨgɨa ghaze, “Kɨ kamaghɨn ian azai, ia bar nan boroghɨra izɨ.” Ezɨ me an boroghɨra ghuezɨ, a kamaghɨn me mɨgei, “Kɨ Josep. Kɨ ian aveghbuam. Ia fomɨra na ataghizɨma dagɨar gumaziba na isa ingangarir gumazir kɨnimɨn mɨn na givezegha, na inigha Isipɨn ize. ");
INSERT INTO msy2020_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ezɨ ia datɨrɨghɨn uari basɨman markɨ, egh ia na gamizir arazir kurar kam bagh naviba uarir ikuvan bar markɨ. Guizbangɨra, God uabɨ ian akurvaghasa, faragha na amadazɨ kɨ ian faragha ize, eghtɨ ia aremeghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ezɨ datɨrɨghɨn nguazir kamɨn dagheba otevir azenir pumuning otogha gɨfa. Eghtɨ 5plan azeniba ikɨvɨra ikɨtɨ gumaziba azenibar ingaran koghɨva dagheba inian kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God arazir aghuir bar igharazir kamɨn ua ia iniasava amigha ian akurvaghasa ifonge, eghtɨ ia ikɨvɨra ikɨtɨ, ian ovavir boriba otivigh nguazir kamɨn ikiam. Ezɨ kamaghsua, a ian faragha na amada. ");
INSERT INTO msy2020_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Bar guizbangɨra, ia na amadazɨ kɨ nguibar kamɨn izezir puvatɨ. Bar puvatɨ. God uabɨ na amadazɨ, kɨ ize. Egha a na gamizɨ, kɨ mati Isipɨn kantrin atrivimɨn afeziamɨn oto. Kɨ an dɨpenimɨn gumazamiziba bar a dagh ativagha dar gara, egha Isipɨn kantrin nguaziba bar dagh ativazir gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Datɨrɨghɨn ia zuamɨra uamategh nan afeziam bagh mangɨgh kamaghɨn a mɨkɨm, ‘Kɨ Josep, nɨn borim, kɨ akar kam nɨ ganɨdi. God na gamizɨma, kɨ Isipɨn kantrin nguaziba bar, dar gumazir dapanimɨn oto. Kamaghɨn, nɨ suighsuighan markɨ, nɨ zuamɨra na bagh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Egh nɨ nan boroghɨra Gosenɨn Distrighɨn nguibam daperagham. Nɨ ko nɨn boriba, ko nɨn ovavir boriba bar, ian sipsipba, memeba, bulmakauba, ko ian biziba bar, ia bar Gosenɨn Distrighɨn daperagh. ");
INSERT INTO msy2020_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Mɨtiriar ekiar kam, a tong uam 5plan azenibar ua ikegham, eghtɨ nɨ uan amuiroghboriba ko, asɨziba, mɨtiriaba sara ikian kɨ aghua. Kamaghɨn nɨ izɨ Gosenɨn Distrighɨn daperaghtɨ, kɨ nɨ gativagh nɨn ganam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ezɨ Josep kamaghɨn aveghbuabav gei, “Ia bar moghɨra na gɨfogh. Kɨ gumazir igharazim ia mɨgeir pu. Bar puvatɨ. Kar kɨ Josepra. Benjamin, nɨ bar nan dozimra, nɨ uaghan na gɨfogh. ");
INSERT INTO msy2020_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Egh ia uamategh mangɨva nan afeziam kamaghɨram a mɨkɨm, kɨ datɨrɨghɨn Isipɨn kantrin aven ziar ekiam iti. Egh uaghan bizir ia bar ganiziba sara a mɨkɨm. Egh ia zuamɨra mangɨgh an aku izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ezɨ Josep kamaghɨn mɨkemegha gɨvagha, uan dozim Benjamin muigha an suiragha azi. Ezɨ Benjamin uaghan a muigha an suiraghava azi. ");
INSERT INTO msy2020_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Egha Josep bar vaghvagha uan aveghbuaba suigha azia egha men tori. Ezɨ datɨrɨghɨn aveghbuaba Josep ko mɨkɨmamin nɨghnɨzim inigha a ko mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ezɨ Isipɨn atrivim kamaghɨn akam baregha fo, Josepɨn aveghbuaba iza an gara iti. Ezɨ atrivim uan gumazir ekiaba ko me bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Egha atrivim kamaghɨn Josep mɨgei, “Nɨ uan aveghbuabav kemegh, me uan biziba isɨ donkibagh isɨn dafegh, egh uamategh Kenanɨn nguazimɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Egh me uan afeziam ko uan amuiroghboriba inigh uamategh na bagh izɨ. Eghtɨ kɨ me bagh Isipɨn nguazir bar aghuitam ginabagh me danɨngam. Eghtɨ nguazir kam dagher avɨriba an otivtɨ, me dar amam. ");
INSERT INTO msy2020_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Egh nɨ uaghan me mɨkɨmtɨ, me Isipɨn kantrin karisbara inigh mangɨgh uan amuiroghboriba inigh izam. Egh nɨ me mɨkemeghtɨ, me uan afeziam inightɨ a uaghan me ko izɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Egh me Kenanɨn nguazimɨn taghizir bizibagh nɨghnɨghan markɨ. Guizbangɨra, kɨ Isipɨn kantrin bizir bar aghuir avɨriba me danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ezɨ Jekopɨn otariba atrivim mɨkemezɨ moghɨn ami. Ezɨ Josep atrivimɨn akamɨn gɨn ghua karisɨn maba isa me ganɨngi. Egha uaghan dagher me tuavimɨn damamiba isa me ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Egha a korotiaba isa vaghvagha bar aveghbuabagh anɨngi. Egha Benjaminra, a 5plan korotiaba ko 300 silvan dagɨaba isa a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ezɨ Josep Isipɨn kantrin bizir aghuir avɨriba inigha, donkin apurir 10pla garɨgha me amadazɨ, me an afeziam bagha zui. Egha a witba ko bretba ko dagher maba sara inigha 10plan donkin amebabagh arɨgha me amadazɨ, me uan afeziam tuavimɨn an akuraghasa a bagha zui. ");
INSERT INTO msy2020_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Egha Josep uan aveghbuaba amaga kamaghɨn me mɨgei, “Ia mangɨ tuavir arɨzimɨn uarira uarir ataran markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ezɨ aveghbuaba Isipɨn kantri ategha ghua Kenanɨn nguazimɨn uan afeziam Jekop bato. ");
INSERT INTO msy2020_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Egha me kamaghɨn uan afeziam mɨgei, “Josep aremezir pu. Puvatɨ. A ikiavɨra ikia datɨrɨghɨn bar Isipɨn kantrin nguazibagh ativagha dar gari.” Ezɨ Jekop akar kam baregha dɨgavir kuram gamigha, nɨghnɨzir gavgavim an itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ezɨ me bizir Josep mɨkemeziba bar dar gun a mɨkeme. Ezɨ Jekop karisɨn Josep amadazibar gari, da Jekop inigh Isipɨn kantrin mangam. Ezɨ an nɨghnɨziba ua dera. ");
INSERT INTO msy2020_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ezɨ Jekop kamaghɨn mɨgei, “Bar guizbangɨra, kɨ datɨrɨghɨn fo, nan otarim Josep angamɨra ikiavɨra iti. Ezɨ kɨ zuamɨra dɨkavigh Isipɨn mangɨgh an ganigh egh gɨn ovengam.” ");
INSERT INTO msy2020_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ezɨ Jekop uan biziba bar da akuvagha dɨkavigha uan adarazi ko, me tuavimɨn ghua Isipɨn kantrin zui. Egha me iza Berseban nguibamɨn otivigha, Jekop uan afeziam Aisakɨn God bagha ofabagh ami. ");
INSERT INTO msy2020_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ezɨ dɨmagarimɨn God irebamɨn mɨn bizimɨn aven Jekop batogha, kamaghɨn an diagha ghaze, “Jekop! Jekop!” Ezɨ Jekop kamaghɨn mɨgei, “Are, kɨ kati.” ");
INSERT INTO msy2020_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ezɨ God kamaghɨn mɨgei, “Kɨ God. Kɨ nɨn afeziamɨn God. Nɨ Isipɨn kantrin mangɨsɨva atiatingan markɨ. Eghtɨ kɨ nɨn ovavir boribar amutɨ da bar avɨrasemegh, ikɨzir gavgavimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Egh kɨ nɨ ko Isipɨn mangɨva, gɨn ua nɨn ovavir boribar aku izam. Eghtɨ dughiar nɨ ovengamim, Josep uabɨ nɨ isɨ mozim darɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ezɨ Jekop Berseba ataki. An otariba uan afeziam, ko men amuiroghboriba isa, Isipɨn atrivim me inigh mangasava amadazir karisbagh atɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Egha me uaghan bulmakauba ko bizir me Kenanɨn nguazimɨn inizir maba sara inigha zui, egha Jekop uan adarazi ko, me bar Isipɨn kantrin zui. ");
INSERT INTO msy2020_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ezɨ Jekopɨn otariba ko guiviba ko an igiaba, me bar Jekop ko zui. ");
INSERT INTO msy2020_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ezɨ Jekopɨn adarazi a ko Isipɨn kantrin ghueziba, men ziabar kara: Ruben, kar Jekopɨn otarir ivariam. ");
INSERT INTO msy2020_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ezɨ Rubenɨn otaribar kara, Hanok, Palu, Hesron ko Karmi. ");
INSERT INTO msy2020_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ezɨ Simeonɨn otariba kara, Jemuel, Jamin, Ohat, Jakin, Sohar ko Saul. Ezɨ Saulɨn amebam, a Kenanian amizim. ");
INSERT INTO msy2020_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ezɨ Livain otaribar kara: Gerson, Kohat, ko Merari. ");
INSERT INTO msy2020_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ezɨ Judan otaribar kara: Er, Onan, Sela, Peres, ko Sera. Egha Er ko Onan, aning Kenanɨn nguazimɨn ikiavɨra itir dughiamɨn ovenge. Ezɨ Peresɨn otaribar kara: Hesron ko Hamul. ");
INSERT INTO msy2020_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ezɨ Isakarɨn otaribar kara: Tola, Puva, Iop, Simron. ");
INSERT INTO msy2020_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ezɨ Sebulunɨn otaribar kara: Seret, Elon, ko Jalel. ");
INSERT INTO msy2020_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ezɨ Ruben, Simeon, Livai, Juda, Isakar ko Sebulun, kar Jekopɨn amuim Lean otariba. Lea, me Mesopotemian nguazimɨn ikiavɨra ikia, borir kaba bate. Egha Lea uaghan guivir mam bate, an ziam Daina. Ezɨ Lean boriba ko an ovavir boribar dɨbobonim, a 33ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ezɨ Gatɨn otaribar kara: Sifion, Hagi, Suni, Esbon, Eri, Arodi, ko Areli. ");
INSERT INTO msy2020_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ezɨ Aserɨn otaribar kara: Imna, Isva, Isvi, Beria. Ezɨ men amizim, Sera. Ezɨ Berian otarimning kara: Heber ko Malkiel. ");
INSERT INTO msy2020_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ezɨ gumazamizir kaba, me Jekop ko Silpan boriba ko ovaviba. Labanɨn ingangarir amizim Silpa, ana isa uan guivim Lea ganɨngi. Ezɨ men dɨbobonim 16ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ezɨ Jekopɨn amuim Resel, an otarimningɨn ziamning kara: Josep ko Benjamin. ");
INSERT INTO msy2020_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ezɨ Josep Isipɨn kantrin ikiava Asenat inigha an iti, a Potiferan guivim. Potifera, a Heliopolisɨn nguibamɨn ikia, egha asebar ofa gamir gumazir mam. Ezɨ Asenat, Josep bagha otarir pumuning bate, ezɨ aningɨn ziamning kara: Manase ko Efraim. ");
INSERT INTO msy2020_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ezɨ Benjaminɨn otaribar kara: Bela, Beker, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim ko Art. ");
INSERT INTO msy2020_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ezɨ gumazir kaba, me Jekop ko Reselɨn boriba ko ovavir boriba. Egha men dɨbobonim, me 14plara. ");
INSERT INTO msy2020_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ezɨ Danɨn borimra kara, an ziam Husim. ");
INSERT INTO msy2020_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ezɨ Naptalin otariba kara: Jasel, Guni, Jeser, ko Silem. ");
INSERT INTO msy2020_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ezɨ gumazamizir kaba, kar Jekop ko Bilhan boriba ko ovavir boriba. Ezɨ Bilha, a ingangarir amizim. Laban a isa uan guivim Resel ganɨngi. Ezɨ men dɨbobonim, me 7plara. ");
INSERT INTO msy2020_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ezɨ Jekopɨn boriba ko an igiar boribar me Isipɨn ghue, men dɨbobonim, me 66pla. Egha dɨbobonir kam Jekopɨn otaribar amuiba sara inizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ezɨ Josepɨn amuim Isipɨn kantrin otarir pumuning bate. Kamaghɨn, dughiar Jekopɨn adarazi ghua Isipɨn itim, men dɨbobonim bar moghɨra ghua, 70plan tu. ");
INSERT INTO msy2020_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ezɨ Jekop Josep bagha Juda amada, a faragh mangɨva Josep inigh izam, egh Gosenɨn Distrighɨn afeziam bativam. Ezɨ Jekopɨn adarazi Gosenɨn Distrighɨn otivizɨma, ");
INSERT INTO msy2020_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Josep uan ingangarir gumazibav geima, me an karis akɨrizɨ, a uan afeziam bativasa Gosenɨn Distrighɨn ghu. Egha an afeziamɨn apigha ghua a muigha an suiragha bar dughiar ruarimɨn azi. ");
INSERT INTO msy2020_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Egha Jekop kamaghɨn Josep mɨgei, “Kɨ nɨn ganigha gɨvagha fo, nɨ ikiavɨra iti. Kamaghɨn, kɨ datɨrɨghɨn aremeghasa ifonge.” ");
INSERT INTO msy2020_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Egha Josep uan aveghbuaba ko an afeziamɨn adarazi kamaghɨn me mɨgei, “Kɨ datɨrɨghɨn mangɨ kamaghɨn atrivim mɨkɨmam, ‘Nan aveghbuaba ko nan afeziamɨn adarasi, me Kenanɨn nguazim ategha izava otivigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Egha gumazir kaba, me sipsipbar garir gumaziba. Egha me uan sipsipba, bulmakauba ko uan biziba sara inigha ize.’ ");
INSERT INTO msy2020_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kɨ kamaghɨn atrivim mɨkemeghtɨma, gɨn atrivim ian diagh ia amir ingangarim bagh ian azangam. ");
INSERT INTO msy2020_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Eghtɨ ia kamaghɨn an akam ikaragh, ‘Gumazir ekiam, e gumazir sipsipba ko bulmakaubar gariba. Egha e fomɨra aghɨribar mɨn ikia ingangarir kam gamua iza datɨrɨkɨn, en afeziaba fomɨra uaghan kamaghɨram ami.’ Egh ia kamaghɨn atrivim mɨkemeghtɨ, a ia ateghtɨ ia Gosenɨn Distrighɨn dapiagham. Guizbangɨra, Isipia me sipsipbar garir gumaziba bar me gifongezir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ezɨ Josep ghua atrivim kamaghɨn a mɨgei, “Nan afeziam ko nan aveghbuaba Kenanɨn nguazim ategha izava otivigha gɨfa. Me uan sipsipba, bulmakauba, ko men biziba, me bar da inigha ize. Egha me datɨrɨghɨn Gosenɨn Distrighɨn iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ezɨ Josep uan aveghbuar 5plan diazɨ me iza atrivimɨn guamɨn tuifi. ");
INSERT INTO msy2020_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ezɨ atrivim kamaghɨn men azai, “Ia ingangarir manabagh ami?” Ezɨ me kamaghɨn an akam ikaragha ghaze, “Gumazir ekiam, e sipsipbar gari, en afeziaba fomɨra amizɨ mokɨn. ");
INSERT INTO msy2020_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ezɨ mɨtiriar ekiam azir dughiam Kenanɨn nguazimɨn otozɨ, en sipsipba apir graziba puvatɨ. Kamaghɨn, e dughiar otevimɨn kantrin kamɨn ikiam. Egha e nɨn ingangarir gumaziba, e kamaghɨn nɨn azai, nɨ en amamangatɨghtɨ, e Gosenɨn Distrighɨn dapiagh ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ezɨ atrivim kamaghɨn Josep mɨgei, “Nɨn afeziam ko aveghbuaba nɨ ko ikiasava otivigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Kamaghɨn, nɨ Isipɨn kantrin aven, nguazir oteviba bar dar tongɨn, nguazir otevir bar aghuitam gɨnɨghnɨghɨva me mɨkemeghtɨ, me a dapiagh. Nɨ ifueghtɨ, me Gosenɨn Distrighɨn ikiam. Egh uaghan, nɨ men tongɨn, gumazir bulmakaubar ganamin fofozim iti tabagh fogh, egh ingangarim me danightɨ me nan bulmakaubar ganam.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ezɨ Josep uan afeziam inigha atrivim bagha zui. Ezɨ Jekop deraghavɨra dughiar aghuim atrivim ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ezɨ atrivim kamaghɨn an azara, “Nɨn azeniba datɨrɨghɨn manmaghɨra?” ");
INSERT INTO msy2020_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ezɨ Jekop an azangsɨzim ikaragha ghaze, “Kɨ nguazir kamɨn aruava 130plan azenibar an ikia iza datɨrɨkɨn. A dughiar bar ruarim puvatɨ, egha kɨ uaghan osɨmtɨzir avɨriba batifi. Nan inaziba dughiar ruarimɨn nguazir kamɨn ike, ezɨ men azeniba nan azenibagh afira.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ezɨ Jekop deraghavɨra dughiar aghuim atrivim ganigha, egha ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ezɨ gɨn Josep atrivim mɨkemezɨ moghɨram amigha, uan afeziam ko uan aveghbuabar akurazɨma, me Isipɨn kantrin apia. A Ramesesɨn nguibar ekiamɨn boroghɨn nguazim isa me ganɨngi. Nguazir otevir kam, a Isipɨn kantrin nguazir igharaziba bar dagh afira. ");
INSERT INTO msy2020_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Egha Josep dagheba isa uan afeziam ko, an aveghbuabar amuiroghboribagh anɨdi. Egha vaghvagha men boribar dɨbobonimɨn mɨrara ghua dagheba me ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dughiar kamɨn mɨtiriar bar ekiam otozɨ, dagheba bar nguazir otevibar puvatɨ. Ezɨ dughiar mɨtiriam azir kam Isipɨn kantri ko Kenanɨn nguazim bar aning gasɨghasɨzima, gumazamiziba bar osɨmtɨzim isi. ");
INSERT INTO msy2020_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ezɨ Isipian gumazamiziba ko Kenanian gumazamiziba, Josep faragha atɨzir witbagh iveza, ghuavti men dagɨaba bar gɨfa. Ezɨ Josep dagɨar kaba inigha da isa atrivimɨn dagɨar dɨpenim gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ezɨ Isipɨn kantrin dagɨaba ko Kenanɨn adarazir dagɨaba gɨvazɨma, Isipia bar Josep bagha ghuegha, kamaghɨn a mɨgei, “Nɨ dagheba e danɨng! Puvatɨghtɨ, mɨtiriam bar e akuatɨghtɨ, en nɨn damazimɨn ireghɨva arɨmɨghiregham. En dagɨaba bar gɨfa, kamaghɨn nɨ en akuragh.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ezɨ Josep kamaghɨn mɨgei, “Ian dagɨaba bar gɨvaghtɨma, ia uan asɨziba inigh izɨ na danɨngtɨ, kɨ ivezimɨn mɨn da inigh, dagheba ia danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ezɨ me hoziaba, sipsipba, memeba, bulmakauba, ko donkiba, da inigha Josep bagha zui. Ezɨ a dagher me ganɨngiziba, dar ivezimɨn mɨn bizir kaba isi. Me kamaghɨram amua ghuavɨra iti azenir kam gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Egha azenir gɨn izimɨn, me ua Josep bagha ghua egha kamaghɨn mɨgei, “Gumazir ekiam, e uan osɨmtɨziba nɨn mongan kogham. Nɨ en dagɨaba ko asɨziba sara bar da inigha gɨfa. Ezɨ e ua nɨ danɨngamin biziba puvatɨ. E ko en nguaziba, darara ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nɨ e ateghtɨ, e nɨn damazimɨn mɨtiriamɨn aremeghan kogham. Eghtɨ en nguazim pura ikɨ ikuvighan kogham. Kamaghɨn, atrivim dagheba e danɨngtɨ, e an ingangarir gumazamizir kɨnibar mɨn ikiam. Eghtɨ atrivim uaghan en nguazim iniam. Kamaghɨn, e uari, nɨ oparir dagher ovɨziba e danɨng, eghtɨ e deragh ikɨva ovengan koghtɨ, en nguazim ikuvighan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Mɨtiriar ekiam azir dughiar kam, bar ikuvigha ghuavɨra itima, Isipia bar uan nguaziba isa Josep ganɨngizɨ, an atrivim bagha dagh ivese. Ezɨ Isipɨn kantrin nguaziba, atrivim bar da ini. ");
INSERT INTO msy2020_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ezɨ Josep gumazamizibagh amima, me Isipɨn kantrin aven vong ko vong sara ingangarir gumazamizir kɨnibar mɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ezɨ asebar ofa gamir gumazibar nguazibara, Josep dagh ivezezir puvatɨ. Atrivim zurara dagɨabar me givesi. Kamaghɨn, me uan nguaziba amangizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ezɨ Josep kamaghɨn gumazamizibav gei, “Ia oragh. Kɨ datɨrɨghɨn ia ko ian nguaziba sara ia givezegha gɨfa, ezɨ ia atrivimɨn ingangarir gumazamizir kɨnibar mɨn iti. Ezɨ ian nguaziba, da bar atrivimɨn nguaziba. Ezɨ kar ia oparamin dagher ovɨziba. Ezɨ ia da inigh mangɨ dagher azenibar da oparigh. ");
INSERT INTO msy2020_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Eghtɨ gɨn azenibar dagheba asiamin dughiam otoghtɨ, ia da isɨ, 5plan pozibav kɨnigh. Egh ia pozitam atrivim danɨngigh, eghtɨ 4plan poziba iana. Egh ia taba oparɨsɨ dar arigh, taba ia uan amuiroghboriba ko, dar amɨ.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ezɨ gumazamiziba kamaghɨn mɨgei, “Gumazir ekiam, nɨ bar en akurazɨ, kamaghɨn e deraghvɨra ikiam. E bar nɨ mɨnaba, nɨ e ataghizɨ, e atrivimɨn ingangarir gumazir kɨnibar mɨn iti.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ezɨ Josep Isipɨn kantrin mɨgɨrɨgɨar gavgavim kamaghɨn anetɨgha ghaze, “Dagher azenibar itiba, ia da iniamin dughiamɨn, da bigh 5plan pozibav kɨnigh, egh pozir tam atrivim danɨngigh.” Arazir kam a kamaghɨra ikia iza datɨrɨghɨn iti. Ezɨ asebar ofa gamir gumazibar nguaziba, darara atrivimɨn nguazibar mɨn itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ezɨ Israelia Isipɨn kantrin aven, Gosenɨn Distrighɨn apiagha, danganir kamɨn nguazim ini. Egha me borir avɨrim batava bar avɨraseme. ");
INSERT INTO msy2020_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ezɨ Jekop uabɨ 17plan azenibar Isipɨn kantrin apera, egha a 147plan azeniba ikiava areme. ");
INSERT INTO msy2020_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A fo, a gurumram ovengam, egha a uan otarim Josepɨn diazɨ, a ize. Ezɨ a kamaghɨn a mɨgei, “Nɨ guizbangɨra bar na gifuegh, uan dafarim isɨ nan buarakɨrimɨn apengan amadagh, akar dɨkɨrɨzir gavgavim damigh suam, nɨ bar arazir aghuimɨn na damuam. Nɨ Isipɨn kantrin narafan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Eghtɨ kɨ aremeghtɨ nɨ nan kuam inigh Isipɨn kantri ategh mangɨ, nan inazir afeziabar kuabar afezir danganimɨn narafagh.” Ezɨ Josep kamaghɨn an akam ikaragha ghaze, “Kɨ nɨ mɨkemezɨ moghɨn damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ezɨ Jekop ua kamaghɨn mɨgei, “Nɨ Godɨn akagh bar guizbangɨra mɨkɨm suam, nɨ guizbangɨra bizir kam damuam.” Ezɨ Josep Godɨn akagha ghaze, kɨ guizbangɨra bizir kam damuam. Ezɨ Jekop, Josep bagha bar akongegha, aviragha ghuaghira uan dapanim isa dakozim gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ezɨ gɨn me kamaghɨn Josep mɨgɨa ghaze, “Nɨn afeziam arei.” Ezɨ Josep dɨkavigha uan otarir pumuning Manase ko Efraim, aning inigha uan afeziam Jekopɨn ganasa zui. ");
INSERT INTO msy2020_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ezɨ gumaziba kamaghɨn Jekop mɨgei, “Nɨn otarim Josep nɨn ganasa izegha gɨfa.” Ezɨ Jekop mong gavgavigha dakozimɨn dɨkavigha apera. ");
INSERT INTO msy2020_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Egha Jekop kamaghɨn Josep mɨgei, “Gavgaviba Bar Itir God, Lusɨn nguibamɨn, na bato, a Kenanɨn nguazimɨn itir nguibam. Egha a deraghvɨra na damuasa akar aghuim na mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Egha a kamaghɨn mɨkeme, ‘Kɨ borir avɨriba nɨ danɨngam, eghtɨ nɨn ovavir boriba bar avɨrasemeghtɨ, nɨ kantrin avɨribar gumazamizibar inazir afeziamɨn otogham. Eghtɨ kɨ nguazir kam isɨ, nɨn ovavir boribar anɨngtɨ, a men nguazimɨn ikɨ mamaghɨra ikiam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Egha Jekop ua kamaghɨn mɨgei, “Kɨ tɨghar Isipɨn kantrin nɨ bativamin dughiam, nɨn amuim otarir pumuning bate. Ezɨ borir kamning, bar nan borimningra ikiam. Efraim ko Manase bar nan borimningɨn mɨn ikiam, mati Ruben ko Simeonɨn mɨn. ");
INSERT INTO msy2020_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Eghtɨ nɨn borir, Efraim ko Manasen gɨn otivighamba, me bar nɨna. Eghtɨ gɨn me nguazim tuiragh vaghvagh me danɨngamin dughiamɨn, borir kaba me Efraim ko Manasen adarazir aven ikiam, kar men aveghbuar ekiamning. ");
INSERT INTO msy2020_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Kɨ fomɨra Mesopotemian nguazim ategha uamategha Kenanɨn nguazimɨn izima, nɨn amebam Resel areme. An aremezir dughiamɨn, e mong Efratan nguibamɨn saghon iti. Egha kɨ Efratan zuir tuavimɨn mɨriamɨn anefa. Efrata, kar Betlehemɨn ziar ghurim. Ezɨ kɨ Resel bar an apangkuvigha bar oseme. Kamaghɨn, kɨ nɨn otarimning bagha akar aghuir kam mɨgei.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ezɨ Jekop Josepɨn borimning ganigha kamaghɨn aning bagha azara, “Kar tinan borimning?” ");
INSERT INTO msy2020_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ezɨ Josep ghaze, “Kar nan otarimning, kɨ Isipɨn kantrin itir dughiamɨn, God aning na ganɨngi.” Ezɨ Jekop ghaze, “Nɨ aning inigh nan boroghɨn izɨtɨ, kɨ bizir aghuiba aning danɨngam, egh God ko mɨkɨmtɨ a deraghvɨram aning damuam.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Dughiar kamɨn Jekop bar ghuri, ezɨ an damaziba deragha bizibar garir puvatɨ. Kamaghɨn, Josep borimningɨn akua iza Jekopɨn boroghɨra tuzɨ, Jekop aningɨn toregha aning muki. ");
INSERT INTO msy2020_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Egha Jekop kamaghɨn Josep mɨgei, “Kɨ fomɨra ghaze, kɨ nɨn guamɨn ganighan kogham. Ezɨ datɨrɨghɨn God na ataghizɨ kɨ nɨ ko nɨn borimning sara, bar moghɨra ian gari.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ezɨ Josep borimning Jekopɨn apozimɨn aning ini. Egha gɨn Josep ziar ekiam Jekop danɨngasa, aviragha ghuaghira guam Jekopɨn boroghɨra nguazim girɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Egha Josep kamaghɨn ifonge, Manase Jekopɨn agharir guvimɨn tughɨv ikiam, eghtɨ Efraim Jekopɨn agharir ikiriam tughɨv ikiam. Kamaghɨn a Manase agharir ikiriamɨn an suiragha, Efraim agharir guvimɨn an suira, egha aning inigha Jekopɨn boroghɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Jekop fo, Manase, an otarir ivariam. Ezɨ puvatɨ, a uan agharimning ighuvagha, agharir guvim isa otarir dozim Efraimɨn dapanim gatɨ. Egha agharir ikiriam isa otarir ivariam Manasen dapanim gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ezɨ Jekop deraghvɨra Josep damuasa kamaghɨn Godɨn azaragha ghaze, “God, nan inazim Abraham ko nan afeziam Aisak, aning bar nɨn apengan ike. Ezɨ nɨ bar deravɨra nan gari, dughiar amebam na batezimɨn iza datɨrɨkɨn. ");
INSERT INTO msy2020_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Egha nɨ enselɨn mamɨn mɨn na bato, egha kɨ ikuvasava amima, nɨ nan akura. Ezɨ kɨ datɨrɨghɨn nɨn azai, nɨ deravɨra borir kamning damu. Egh nɨ aningɨn ovavir boribar amutɨ, me nguazir kamɨn bar avɨrasemegham. Eghtɨ aning bangɨn, gumazamiziba nan ziam ko, Abraham ko Aisakɨn ziamning sara okɨnɨghnɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Josep uan afeziamɨn garima, an agharir guvim isa Efraimɨn dapanim gisɨn arɨzima, a kamaghɨn nɨghnɨgha ghaze, arazir kam derazir puvatɨ. Kamaghɨn, a uan afeziamɨn agharir guvimɨn suiragha, Manasen dapanim gisɨn darɨghasava ami. ");
INSERT INTO msy2020_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Egha a kamaghɨn afeziam mɨgei, “Afeziam, nɨ kamaghɨn damuan markɨ. Otarir kam, an otarir ivariam. Ezɨ nɨ uan agharir guvim an dapanim gisɨn datɨgh.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ezɨ afeziam aghuagha, kamaghɨn Josep mɨgei, “Nan otarim, kɨ fo. Manasen adarazi uaghan bar avɨrasemegham. Eghtɨ an dozimɨn adarazi bar moghɨra bar avɨrasemegh, egh Manasen adarazigh afiragham. Egh me kantrin avɨribar gumazamizibar mɨn bar avɨrasemegham.” ");
INSERT INTO msy2020_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ezɨ dughiar kamɨn Jekop deraghavɨra aning damuasa bizir aghuiba isa aning ganɨga, kamaghɨn Josep mɨgei, “Gɨn izamin dughiamɨn, Israelia, God deraghvɨra igharaz darazi damusɨ an azangsɨgh, nɨn borimningɨn ziamning dɨponɨva mɨkɨm suam, God deravɨra Efraim ko Manase gamizɨ moghɨn, a deravɨra ia damuam.” Ezɨ arazir kamɨn Jekop Efraim faragha anetɨgha, Manase gɨn anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Egha Jekop kamaghɨn Josep mɨgei, “Nɨ oragh, kɨ ovengasava ami. Eghtɨ God ia ko ikiam, egh ua ia inigh uamategh ian inazibar nguazimɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Guizbangɨra, Sekemɨn nguazimɨn itir mɨghsɨar apɨrazim, a bar nguazir otevir aghuim. Ezɨ kɨ fomɨra uan mɨdorozir sabam ko pimɨn suiragha, Amoria ko mɨsuegha nguazir kam ini. Kɨ nguazir otevir kam, nɨrara danɨngam. Kɨ nɨn aveghbuabar anɨngan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Egha Jekop uan boribar diazɨ, me izima, a kamaghɨn me mɨgei, “Ia nan boroghɨra izɨtɨ, kɨ bizir gɨn ia bativamibar gun ia mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Kɨ Jekop ian afeziam, nan ziar mam Israel, ia nan boriba, ia bar izɨ nan boroghɨn uari akuvagh, deraghvɨra uan kuariba arigh na baragh. ");
INSERT INTO msy2020_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, nan borir ivariam, kɨ gumazir igiamra ikia nɨ bate. Ezɨ nɨ bar ekevegha bar gavgavigha nan borir igharazibagh afira. ");
INSERT INTO msy2020_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Egha nɨn araziba mati aperiam ivemari moghɨn bar gavgavigha ongani, ezɨ gumazitam nɨ gativaghan kogham. Nɨ uan afeziamɨn amuir dozim koma akuigha, bar arazir kuram gamigha aghumsɨzir ekiam na ganɨngi. Kamaghɨn, nɨ ua faragh ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Ezɨ Simeon ko Livai, aning aveghbuamning. Aning uaning inigha mɨdorozir biziba isa igharaz darazi paza me gami. ");
INSERT INTO msy2020_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Egha aning atarava gumazibav sozima, me ariaghiri. Egha aning pura ikia uan ifongiar kuramɨn gɨn ghua bulmakaubar suer duiar agɨribar aghori. Kamaghɨn, kɨ aning ko navir vamɨra ikian kogham. Ezɨ bizir kɨ aning damuasa nɨghnɨgha akam akɨriziba, kɨ dar gɨn mangan aghua. ");
INSERT INTO msy2020_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Aningɨn adariba bar gavgafi, ezɨ aningɨn anɨngagharim bar kufi, kamaghɨn aningɨn anɨngagharir kam aning gasɨghasɨgham. Eghtɨ kɨ aning damightɨ, aningɨn ovavir boriba tintinibar Israelian gumazamizir igharazibar tongɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, nɨn aveghbuaba nɨn ziam fam. Egh nɨ uan apanibar fɨribar suigh me abɨntɨ, nɨn aveghbuaba nɨn guamɨn uan dapaniba avigh, ziar ekiam nɨ danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ezɨ Juda, nan otarim, nɨ mati laionɨn igiar mam. An asɨzibav sogha da apa, ghua bar gavgafi. Egha nɨmɨra apiav ikia uabɨ akunasavɨra gara iti, ezɨ gumazamiziba a dɨpovan atiatingi. ");
INSERT INTO msy2020_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Egha an atrivimɨn aghorimɨn suiraghtɨ, an an gavgavir ekiam akaghtɨ, a ikɨ mamaghɨra ikiam. Egh an ovavir boribar atrivimɨn mɨn ikɨ mangɨtɨ, gumazamiziba bar a bagh bizir aghuiba inigh a bagh izamin dughiam otogham. Egh a kantriba bar dagh ativagham. ");
INSERT INTO msy2020_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Egha a wainɨn ikarɨzir bar aghuir avɨriba iti. Egha a uan donkin amebamɨn nguzim ikiasa, pura wainɨn ikarɨzir kabar a iti. Egha a wainɨn ovɨziba mɨrmɨra, wainɨn dɨpar avɨribagh ami, eghtɨ gumazamiziba dar amɨ da gɨvaghan kogham. Ezɨ a wainɨn dɨpar maba isa uan korotiaba rue. ");
INSERT INTO msy2020_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Egha a wainɨn dɨpar avɨriba apava, kamaghɨn an damazimning aghefe. Ezɨ a bulmakaun oter eborir avɨriba apava, kamaghɨn an atariba bar ghurghuri. ");
INSERT INTO msy2020_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Ezɨ Sebulun ongarimɨn boroghɨra ikiam, ezɨ an ongarir dadarim, kuriba ikiamin danganir aghuim ikiam. Eghtɨ an nguazimɨn ababanim bar mangɨ Saidonɨn nguibamɨn nguazim bɨragham. ");
INSERT INTO msy2020_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar a donkin bar gavgavim. Egha a pura mɨtarir biziba ateribar tongɨn irav iti. ");
INSERT INTO msy2020_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A uan nguazimɨn garima a ikiamin danganir bar aghuim, egha a bar pura ingari. Egha gɨn a pura ingangarir gumazir kɨnimɨn mɨn ingangarir bar ekiam gami. ");
INSERT INTO msy2020_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Ezɨ Dan, a gumazir dapanir ekiamɨn mɨn ikɨva, uan gumazamizibagh ativagh ikɨtɨ, me Israelian anabar igharazibar mɨn otivam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Egh Dan kuruzir kurar mamɨn mɨn tuavir mɨriabar ikɨ mɨzuamam. Eghtɨ hoziaba ivemarɨ tuavimɨn izɨtɨ, a uabɨ fegh kunigh men suebagh inivtɨ, gumazir hoziabagh apiaziba me daighiregham. ");
INSERT INTO msy2020_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“O Ikiavɨra Itir God, nɨ nan akurvaghasa kɨ nɨ mɨzuai iti. ");
INSERT INTO msy2020_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gat, okɨmakɨar gumaziba izɨ nɨ mɨsogham. Eghtɨ nɨ men mɨdoroziba ikarvagh me batueghtɨ me mangam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser, nɨn nguazim dagher avɨriba ikiam. Nɨ dagher isɨngtɨzir atrivim bar ifongeziba tuam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali nɨ mati, memen atiam uan ifongiamɨn gɨn zui. Egha nguzir diriba bati. ");
INSERT INTO msy2020_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josep nɨ mati wainɨn ikarɨzir aghuim, a dɨpar atuir mamɨn boroghɨn otogha aghua ovɨziba bati. Egha an aghariba ruarigha dɨvazim avara. ");
INSERT INTO msy2020_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ezɨ gumazir pibar asa mɨsoziba, me pamten a gasavɨra iti. Me a gaseghtɨ an aremeghasa me pazava a gami. ");
INSERT INTO msy2020_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ezɨ Josep uan pimɨn benim fɨrizir puvatɨ. Godɨn Bar Gavgavim Itim, a Jekopɨn God, a gavgavim isa Josep ganɨngi, ezɨ Josepɨn agharim amɨrazir puvatɨ. Ezɨ Godɨn kam, a Israelian Garir gumazim, egha a mati Israelia Modir Dagɨar Gavgavim. ");
INSERT INTO msy2020_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kar nɨn afeziamɨn God, kar Godɨn Gavgaviba Bar Itim. Egha a uabɨra deravɨra nɨ gamua, bizir aghuir avɨriba nɨ ganɨdi. Egh overiam damutɨ, amozir avɨrim nɨ gizam. Egh a dɨpar avɨrim damutɨ, da nguazimɨn otivam. Eghtɨ a nɨn adarazir amizibar amutɨ, me borir avɨriba batam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ezɨ kɨ nɨn afeziam, kɨ bizir aghuir avɨriba nɨ ganɨdi. Eghtɨ bizir aghuir kɨ nɨ danɨngamin kaba, nɨ da iniam, da otiv avɨrasemegh, mɨghsɨar dafaba avegham. Egh da bar nan inaziba fomɨra inizir bizir aghuibagh afiragham. Eghtɨ Josep, bizir kaba da bar nɨ bativam, nɨ gumazir kam, uan aveghbuabar tongɨn gumazir ekiamɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Ezɨ Benjamin mati afiar atiar ekiar mam, an asɨzibav sozima da ariaghiri. Egha asɨzir mɨsogheziba a mɨzarazibar ada api. Egha guaratɨzibar a inizir biziba tuisɨsi.” ");
INSERT INTO msy2020_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ezɨ aveghbuar kaba, kar Israelian 12plan anababa. Ezɨ men afeziam aremeghasa amuava, vaghvagh akar aghuim me ganɨdima, akar kam men arazibar mɨrara ghu. ");
INSERT INTO msy2020_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ezɨ Jekop akar aghuiba anigha gɨvaghava, kamaghɨn uan boribav gei, “Kɨran oveghangɨn, kɨ oveaghuezibar nguibamɨn mangɨ uan inazir afeziaba ko ikiam, kar gumazir ovengezibar nguibam. Eghtɨ ia na isɨ nan inaziba ko dagɨar mozimɨn narafagh. Dagɨar mozir kam, a Efronɨn nguazimɨn iti. Efron, a Hitian gumazir mam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Mozir kam Makpelan nguazimɨn iti, a Kenanɨn nguazimɨn ikia, Mamren nguibamɨn boroghɨra iti. Abraham Efron dam nguazir otevir kam givese, eghtɨ a uan adarazir kuabar afamin danganimɨn mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ezɨ mozir kamɨn, me Abraham uan amuim Sara ko aning afagha, uaghan Aisak uan amuim Rebeka ko, aning afa. Ezɨ kɨ Lea uaghan mozir kamɨn anefa. ");
INSERT INTO msy2020_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Dagɨar mozir kam itir nguazim, Abraham Hitian adarazi dam a givese.” ");
INSERT INTO msy2020_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Egha Jekop akar kabav mɨkemegha gɨvagha, uan suemning amɨkɨrɨgha dakozim gisɨn atɨ. Egha an areme, ezɨ an duam ghua uan adarazi ko me oveaghuezibar nguibamɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ezɨ Josep kamaghɨn uan afeziamɨn garima, an aremezɨ, a uan afeziam gisɨn irɨgha a muigha bar an apangkuvigha azia uan afeziamɨn tori. ");
INSERT INTO msy2020_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Egha gɨn Josep doktabav geima, me marasinba ko borer igharagha gariba, an afeziamɨn mɨkarzim gaghui. Eghtɨ, an mɨkarzim ikuvighan kogham. Ezɨ doktaba Josep mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Isipian kuabagh amir arazimra kara, me marasin kuamɨn mɨkarzim daghu mangɨ 40plan dughiabar tugham. Kamaghɨn me ingangarir kam 40plan dughiabar Jekopɨn kuam gami. Ezɨ Isipia Jekop bagha azia ghua 70plan dughiabar tu. ");
INSERT INTO msy2020_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ezɨ aghuimazim ko azirakam gɨvazɨma, Josep atrivimɨn gumazir dapanibav gɨa ghaze, “E uari, ia na gifueghɨva, ia nan akam inigh atrivim bagh mangɨ. Akar kam kamakɨn, ");
INSERT INTO msy2020_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Atrivim, nan afeziam aremeghasava amua, a na gamizɨ, kɨ akar dɨkɨrɨzim gamua ghaze, kɨ an kuam inigh mangɨva dagɨar mozir a uabɨ okorezim, a Kenanɨn nguazimɨn iti, kɨ an anefam. Kamaghɨn, nɨ nan amamangatɨghtɨ, kɨ uan afeziamɨn kuam inigh mangɨ anefagh egh gɨn kɨ ua izam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ezɨ atrivim Josepɨn akam baregha kamaghɨn a ikaragha ghaze, “Nɨ uan afeziam ko akar dɨkɨrɨzir amizir kamɨn gɨn mangɨ, egh an kuam inigh mangɨva anefagh.” ");
INSERT INTO msy2020_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ezɨ Josep uan afeziam mozimɨn anefasa zui. Ezɨ atrivimɨn gumazir dapaniba, ko an dɨpenimɨn gumazir ekiaba, ko Isipian gumazir aruaba, me bar Josepɨn gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ezɨ Josepɨn adarazi, ko an aveghbuaba, ko an afeziamɨn adarasi, me bar ghue. Ezɨ borir doziba ko, sipsipba, memeba ko bulmakauba, darara Gosenɨn Distrighɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ezɨ karisba ko gumazir hoziabagh apiaziba, me uaghan Josep ko zui. Guizbangɨra, gumazir bar avɨrim ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Egha me ghua Atatɨn nguibamɨn otifi, Jordanɨn Fanemɨn aruem anadi nakɨn. Kar me witɨn iniba kua dar dagheba isir danganim. Ezɨ Josep aghuimazir arazim gamua azia ghua 7plan dughiaba gɨfa. Dughiar kam, me bar, azirakar dafam gamua pamtemɨn azi. ");
INSERT INTO msy2020_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ezɨ Kenania, me Atatɨn itir gumazamizir kabar gari, me aghuimazimɨn ikiava azima, me kamaghɨn mɨgei, “Isipia aghuimazimɨn ikia azirakar ekiam gami.” Kamaghɨn me danganir kam dɨbora ghaze, “Abel Misraim.” Ezɨ danganir kam, a Jordanɨn Fanemɨn, aruem anadi naghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ezɨ Jekopɨn boriba an akamɨn gɨn ghua a mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ezɨ me an kuam inigha Kenanɨn nguazimɨn ghugha, Makpelan nguazimɨn itir dagɨar mozimɨn anefa, a Mamren nguibamɨn boroghɨn iti. Abraham fomɨra Efron da nguazir kam givese, a Hitian mav, eghtɨ nguazir kam, an adarazir kuabar afamin danganimɨn mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ezɨ Josep uan afeziam afagha gɨvagha, uan aveghbuaba ko, a ko ghuezir darasi, me uamategha Isipɨn ghue. ");
INSERT INTO msy2020_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ezɨ men afeziam aremezɨ, Josepɨn aveghbuaba gɨn kamaghɨn mɨgei, “Manmaghɨn ami? Josep ti en ataravɨra ikiama, egha arazir kurar e a gamiziba ikarvaghasa?” ");
INSERT INTO msy2020_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kamaghɨn, me Josep bagha akam amada. Akar kam kamakɨn, “En afeziam tɨghar ovengamin dughiamɨn, an akar mamɨn e mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","An akar kam nɨ danɨngasa e mɨkeme, ‘Josep, nɨn aveghbuaba arazir bar kuraba nɨ gamua, bar pazavɨra nɨ gami. Ezɨ kɨ nɨn azai, ga uaning, nɨ men arazir kurar kaba, gɨn amadagh.’ Ezɨ e datɨrɨghɨn, en afeziamɨn Godɨn ingangarir gumaziba, e nɨn azai, e uari, nɨ en arazir kurar ekiar kam, a gɨn amadagh.” Ezɨ Josep akar kam baregha azia iti. ");
INSERT INTO msy2020_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Egha gɨn Josepɨn aveghbuaba ghuava an gara egha uan guaba avigha ghuaghira Josepɨn suemningɨn boroghɨn nguazim giregha, kamaghɨn a mɨgei, “E pura nɨn ingangarir gumazir kɨnibar otifi.” ");
INSERT INTO msy2020_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ezɨ Josep kamaghɨn me mɨgei, “Ia atiatingan markɨ. Kɨ Godɨn danganim inighɨva, ia kotiam darɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Bar guizbangɨra, ia na gasɨghasɨghasa akam mɨsoke. Ezɨ kɨ fo, God ian amamangatɨzɨ, ia arazir kam gami. Guizbangɨra, God gumazamizir avɨribar akurvaghasa ifonge, eghtɨ me ikuvighan kogham. Ezɨ ia God amizir ingangarir kam gɨfogha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kamaghɨn, ia atiatingan markɨ. Kɨ ia ko ian boribar ganam.” Josep akar bar aghuir kamɨn uan aveghbuaba mɨkemegha men navibagh amima, me navir amɨrizim ini. ");
INSERT INTO msy2020_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Egha Josep Isipɨn kantrin uan afeziamɨn adarazi ko iti. Egha a 110plan azenibar bar moghɨra nguazir kamɨn ike. ");
INSERT INTO msy2020_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Egha Efraimɨn boriba ko an igiabar boribar gani. Ezɨ Makirɨn boriba otivizɨ, me uaghan men akua Josep bagha ghuzɨma, a men suiragha me isa uan apozim dafa. Makir, a Manasen borim. ");
INSERT INTO msy2020_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Egha gɨn Josep kamaghɨn uan aveghbuabav gɨa ghaze, “Kɨran oveghangɨn, kɨ aremegham. Eghtɨ God ian ganam, egh gɨn ian aku kantrin kam ategh mangam. Ia fo, a fomɨra Abraham, Aisak ko Jekop nguazir mam me danɨngasa akar dɨkɨrɨzir gavgavim gami. Egh a gɨn ia inigh nguazir kamra, an mangam.” ");
INSERT INTO msy2020_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ezɨ gɨn Josep kamaghɨn Israelɨn otaribav gɨa ghaze, “Ia kamaghɨn na ko akam akɨrigh, dughiar God ia bagh izamim, ia danganir kamɨn nan aghariba inigh mangɨ.” Egha Josep uan aveghbuabagh amima, me guizbangɨra pɨn akagha mɨkeme, me an akar kamɨn gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ezɨ Josep 110plan azenibar ikegha an areme. Ezɨ Isipian doktaba marasin ko borer avɨribar an mɨkarzim gaghui, eghtɨ an mɨkarzim ikuvighan kogham. Ezɨ me an kuam isa boksiar mam gatɨ, egha Isipɨn kantrin itir danganir mam gatɨ.");
INSERT INTO msy2020_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Jekopɨn otariba an gɨn Isipɨn kantrin ghu, me uan adarazi sara, men ziabar kara: ");
INSERT INTO msy2020_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","4","Ruben, Simeon, Livai, Juda, Isakar, Sebulun, Benjamin, Dan, Naptali, Gat ko Aser. ");
INSERT INTO msy2020_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Josep men faraghavɨra ghugha Isipɨn iti. Gumazamizir kaba me Jekopɨn otivizir ovavir boriba. Me bar men dɨbobonim 70ɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Dughiar maba gɨvazɨma, Josep, ko an aveghbuaba bar, ko gumazamizir dughiar mɨtaghniar kamɨn ikeziba, me bar ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ezɨ Israelɨn gumazamiziba borir avɨrim batima, men avɨrim bar ekevegha bar avɨrasemegha gavgavigha Isipɨn kantri bar a gizɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Azenir avɨribar gɨn, atrivir igiar mam Isipɨn kantrin atrivimɨn oto. Atrivir kam Josep gɨfozir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Egha a uan gumazamizibav gɨa ghaze, “Israelian gumazamiziba bar avɨraseme, ezɨ men avɨrim ko gavgavim bar en avɨrim ko gavgavim gafira. ");
INSERT INTO msy2020_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Eghtɨ mɨdorozim otoghtɨ, me ti en apaniba ko uari akuvagh e ko mɨsoghɨva, en kantri ategh aregham. Kamaghɨn amizɨ, e tuavitam batogh me damightɨ, me otɨv arogh avɨrasemeghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kamaghɨn Isipian atrivim uan apengan ingarir gumaziba ko, me ingangarimɨn ganamin gumazir maba mɨsevegha, ingangarim me ganɨngi. Men ingangarir kam, a kamakɨn, me puvɨra Israelia abɨn me damutɨ, me bar osɨmtɨzir dafaba sara ingangarir ekiabar amuam. Me Israelia gamima me nguibar ekiar pumuningɨn ingari, Pitomɨn nguibam ko Ramesesɨn nguibamning, kar nguibar ekiar atrivimɨn daghebar arɨghamimning. ");
INSERT INTO msy2020_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isipia bar pazavɨra Israelia gamima, me uaghan bar avɨrasemegha Isip gizefi. Me kamaghɨn me gamua ghuavɨra iti me puvɨra ingarava, boriba bata ghuavɨra iti. Kamaghɨn amizɨ, Isipia men atiatia bar men aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Isipia me gamima, me puvɨra ingarava, osɨmtɨzir ekiaba ateri, Isipia tong men apangkuvir pu. Bar puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Egha Isipia puvɨra me abɨra me gamima, me brighbar ingara dɨpenibar ingarava uaghan azenibar obarir ingangaribagh ami. Ezɨ ikɨrɨmɨrim bar men asɨghasɨki. ");
INSERT INTO msy2020_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ezɨ Isipɨn atrivim, Sifra ko Puan dia, aning Hibrun amizir otasava amibar, akurvazir amizimning. Egha an akar gavgavim aning ganɨga, ghaze, ");
INSERT INTO msy2020_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Gua Hibrun amizir otasava amibar akurvaghɨva gan, amizim otarim bateghtɨ, gua a mɨsueghtɨ an aremegh. A borir guivim bateghtɨ, gua aneteghtɨ a ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ezɨ amizir kamning Godɨn atiatiava Isipɨn atrivim aning mɨkemezɨ moghɨn amir puvatɨ, egha otariba ataghɨrazima me iti. ");
INSERT INTO msy2020_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ezɨ Isipɨn atrivim aningɨn diagha aningɨn azara, “Gua tizim bagha otariba ataghizɨma me iti?” ");
INSERT INTO msy2020_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ezɨ amizimning kamaghɨn atrivim mɨgei, “Hibrun amiziba Isipian amizibar mɨn amir puvatɨ, me amizir gavgaviba. Me otɨsɨ, me bar zuamɨra otegham, kamaghɨn amizɨ, ga tɨghar maghɨn mangɨtɨ me otegh gɨvagham.” ");
INSERT INTO msy2020_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Amizir kamning Godɨn atiati, kamaghɨn amizɨ God deragha aning gamima aning uaghan uaning bagha boriba bati. Kamaghɨn Israelɨn gumazamiziba bar otava arogha ghuavɨra ikia gavgafi. ");
INSERT INTO msy2020_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ezɨ gɨn atrivim kamaghɨn Isipɨn gumazamiziba bar me mɨgei, “Ia Hibrun otarir iririviba isɨ, Nailɨn Fanemɨn me akunigh. Egh guivir iririviba ateghtɨ, me ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Dughiar kamɨn Livain ovavir borir gumazir mam, a Livain ovavir borir amizir mamɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Gɨn amizir kam navim asegha otarir mam bate. Egha an an garima, an ganganim bar dera, kamaghɨn amizɨ a 3plan iakɨnibar a modi. ");
INSERT INTO msy2020_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","An amebam uam a mongan asaghava, akɨrar me ighurunibar mɨn garir grazir aghuibar ingarizir mam inigha, koltan an toriba apɨri. Eghtɨ dɨpam aven mangan kogham. Egha borim aven anetɨgha ghua Nailɨn Faner mɨriamɨn grazibar tongɨn dɨpam gisɨn anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ezɨ borimɨn amezemebam mong saghuiamɨn tugha modogha an gari, bizir tizitam a bativam. ");
INSERT INTO msy2020_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ezɨ atrivimɨn guivim ruasa fanemɨn uaghirima, an ingangarir amiziba an gɨn ghua dɨpar mɨriamɨn arui. Ezɨ atrivimɨn guivim amuaviava akɨrar kam grazibar tongɨn an apigha, a iniasa ingangarir amizir mam amada. ");
INSERT INTO msy2020_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Egha atrivimɨn guivim akɨrar kamɨn asuam kuigha otarimɨn garima, an araima, an an apangkufi. Egha kamaghɨn mɨgei, “Kar Hibrubar borir mam.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ezɨ an amezemebam izava an azai, “Kɨ mangɨva Hibrun amizitam mɨkemeghtɨ, a nɨ bagh oteba a danɨngam?” ");
INSERT INTO msy2020_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ezɨ atrivimɨn guivim kamaghɨn mɨgei, “Aria, nɨ mɨgei moghɨn damu.” Ezɨ guivim ghua borimɨn amebamra inigha ize. ");
INSERT INTO msy2020_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ezɨ atrivimɨn guivim amizir kam kamaghɨn a mɨgɨa ghaze, “Nɨ borir kam inigh na bagh a damu oteba a danɨngtɨ, kɨ nɨ givezam.” Ezɨ amizir kam borim inigha a bagha a gamua oteba a ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Gɨn borir kam ekevezɨma, an amebam a inigha atrivimɨn guivim bagha ghu. Ezɨ atrivimɨn guivim, otarir kam, mati an otozir borimɨn mɨrara ua bagha a gami. Egha a kamaghɨn uabɨ mɨgei, “Kɨ dɨpamɨn a isava azenim gatɨ. Kamaghɨn, kɨ ziam, Moses, a darɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ezɨ gɨn Moses aghuigha gumazim aragha gɨvagha, atrivimɨn dɨpenimɨn azenan ghua Hibrubar ganasa zui, kar an akar gumazamiziba. A ghua men garima, Isipia ingangarir osɨmtɨzibar amuasa puv me abɨri. A uaghan garima, Isipian mav Hibrun mav mɨsosi, kar an akar gumazir mam. ");
INSERT INTO msy2020_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ezɨ Moses tintinibar garima, tav itir puvatɨzɨ, a Isipɨn gumazir kam mɨsuegha an kuam gigimɨn aven a modo. ");
INSERT INTO msy2020_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Egha an amɨmzaraghan uamategha ghua garima, Hibrun gumazimning uaning mɨsosi. Ezɨ a mɨdorozim forezir gumazim mɨgei, “Nɨ tizim bagha uan akar gumazim mɨsosi?” ");
INSERT INTO msy2020_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ezɨ gumazir kam a ikaragha ghaze, “Tina nɨ amɨsevezɨ nɨ en gumazir dapanim ko jasɨn ikiava en gari? Nɨ Isipian gumazim mɨsoghezɨ an aremezɨ moghɨn, nɨ na mɨsueghtɨ kɨ aremeghasa, a?” Ezɨ Moses kamaghɨn oregha atiatigha, kamaghɨn nɨghnɨsi, “Kɨ amizir bizir kam, gumazamiziba a gɨfo.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ezɨ Isipɨn atrivim gɨn Moses amizir bizir kam baregha, Moses mɨsueghtɨ an aremeghasava ami. Ezɨ kamaghɨn Moses atrivimɨn ara ghua, Midianɨn nguazimɨn oto. Egha mozir dɨpar mamɨn mɨriamɨn aperaghav iti. ");
INSERT INTO msy2020_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midianɨn nguazimɨn, ofa gamir gumazir mam, an ziam Jetro. A 7pla guiviba iti. Ezɨ dughiar kam, an guiviba iza mozir pam tuigha uan afeziamɨn sipsipba ko memebar anɨngasa, itarir bar ekiam gingasava ami. ");
INSERT INTO msy2020_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ezɨ sipsipbar garir gumazir maba iza Jetron guiviba, me batosi. Ezɨ Moses guivibar akuragha gumazir kaba munamadagha, dɨpam tuigha Jetron sipsipba ko memebagh anɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ezɨ me uamategha zuima men afeziam men azara, “Manmagh amizɨ ia zuamɨra uamatenge?” ");
INSERT INTO msy2020_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ezɨ me kamaghɨn a mɨgei, “Isipɨn gumazir mam en akuragha sipsipbar garir gumaziba munamada. Egha dɨpam tuigha en sipsipba ko memebagh anɨngi.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ezɨ afeziam men azara, “Gumazir kam managh iti? Ia tizim bagha anetegha ize? Ia mangɨva a mɨkemeghtɨ a izɨva, e ko damɨ.” Ezɨ me ghua Moses inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ezɨ Moses Jetro ko ikiasa ifonge. Ezɨ Jetro uan guivim Sipora, Mosesɨn ikiasava a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ezɨ Sipora otarim batezɨ, Moses kamaghɨn mɨgei, “Kɨ nguibar igharazimɨn gumazimɨn mɨn iza ia ko iti, kamaghɨn kɨ ziam Gersom a gatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Dughiar ruarim gɨvazɨma, Isipɨn atrivim areme. Ezɨ Isipia Israelia me gativagha men gari, me puvɨra ingara osɨmtɨzir kaba isavɨra ikiava, akurvazim bagha pamtemɨn arai, “O God, en akuragh.” Ezɨ men ararem God bagha ghuavanabo. ");
INSERT INTO msy2020_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ezɨ God men ararem baregha Abraham ko, Aisak ko, Jekop ko, amizir Akar Dɨkɨrɨzir Gavgavim ginɨrɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Kamaghɨn God, Israelɨn gumazamizibar garima men ikɨrɨmɨrim bar ikufi, ezɨ a men apangkuvigha, men akurvaghasa nɨghnɨsi. ");
INSERT INTO msy2020_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Dughiar mamɨn Moses uan amerem Jetron sipsipba ko memebagh eghuva, da inigha gumazamiziba puvatɨzir danganir mamɨn ghua, a ifagha vongɨn ghua Horepɨn oto, kar God baghavɨra itir mɨghsɨam. Horepɨn Mɨghsɨamɨn ziar igharazim, Sainai. ");
INSERT INTO msy2020_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ezɨ Ikiavɨra Itir Godɨn ensel temer otevir mamɨn aguabar tongɨn avir mɨzariabar aven, puram a bato. Ezɨ Moses temer otevir kamɨn gari, avim isia daforofozima, temem isir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ezɨ Moses aguaghfagha ghaze, “Kar bizir igharazim! Tizim bagha temer kam isir puvatɨ? Kɨ roghɨra mangɨ an ganigham.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ikiavɨra Itir God, Mosesɨn gari a roghɨra izima, God tememɨn aguabar tongɨn ikia an dia, “Moses! Moses!” Ezɨ Moses a ikara, “Kɨ kati.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ezɨ God ghaze, “Nɨ roghɨra izan markɨ! Nguazir nɨ isɨn tughav tir kam, kar anogoroghezir nguazim, a nan nguazimra. Kamaghɨn nɨ uan dagarir asuaba suegh.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Egha God ua kamaghɨn mɨgei, “Kɨ nɨn afeziamɨn God. Egha uaghan nɨn inazir afeziaba, Abraham, Aisak ko Jekopɨn God.” Ezɨ Moses Godɨn akam baregha, an ganan atiatigha uan guam avara. ");
INSERT INTO msy2020_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ezɨ Ikiavɨra Itir God kamaghɨn a mɨgei, “Kɨ guizbangɨra gari, nan gumazamiziba Isipɨn kantrin ikia, men ikɨrɨmɨrim bar ikufi. Egha kɨ me barazi, me ingangarimɨn garir gumazir kurabar atiatia, nan akurvazim bagha arai. Ezɨ kɨ bar men osɨmtɨzibagh fogha men apangkufi. ");
INSERT INTO msy2020_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Egh kɨ Isipian dafarim da ua me inigh men akuraghasa izaghiri. Egh Isipian nguazimɨn men aku, nguazir ekiar aghuimɨn mangam, nguazir kam a bar derazɨ, biziba an ikiava bar deraghavɨram aghui. Nguazir kam, Kenania, Hitia, Amoria, Peresia, Hivia ko Jebusia, datɨrɨghɨn a gapiaghav iti. ");
INSERT INTO msy2020_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ezɨ nan gumazamiziba, kɨ men ararem baregha, Isipia pazavɨra me gamir arazibar ganigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kamaghɨn amizɨ, kɨ nɨ amadi. Eghtɨ nɨ Isipian atrivim bagh mangɨtɨ a nɨn amamangatɨghtɨ, nɨ nan gumazamiziba inigh Isipɨn kantri ateghɨva azenan izam.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ezɨ Moses kamaghɨn God mɨgei, “Kɨ gavgaviba ko ziaba puvatɨzir gumazim. Guizbangɨra, kɨ atrivim bagh mangɨva Israelia inigh Isip ategh azenan izan iburaghburaki.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ezɨ God a ikara, “Kɨ nɨ ko ikiam. Nɨ gumazamiziba inigh Isipɨn azenan izɨva mɨghsɨar kamɨn nan ziam fam. Bizir kam nɨ damightɨ nɨ fogham, kɨ nɨ amada.” ");
INSERT INTO msy2020_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ezɨ Moses kamaghɨn a ikaragha ghaze, “Kɨ Israelia bagh mangɨ me mɨkɨm suam, ‘Ian ovavibar God ia bagha na amada,’ eghtɨ me nan azaragham, ‘An ziam tina?’ Eghtɨ kɨ manmaghɨn me mɨkɨmam?” ");
INSERT INTO msy2020_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ezɨ God Moses mɨgɨa ghaze, “Kɨrara, Kɨ Uabɨ Kɨ Kamaghɨra Iti. Nɨ kamaghɨn me mɨkɨm, ‘Kɨrara Kɨ Uabɨ, kar Godɨn ziam, egha a ia bagha na amada.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Egha God ua kamaghɨn Moses mɨgei, “Nɨ kamaghɨn Israelian gumazamizibav kɨm, ‘Ikiavɨra Itir God, a ian inazir afeziabar God, an Abraham ko Aisak ko Jekopɨn God, a na amadazɨ, kɨ ia bagha izi.’ Ziar kam, Ikiavɨra Itir God, a zurazurara nan ziam, ezɨ gɨn otivamin boriba ziar kamra na dɨpon. ");
INSERT INTO msy2020_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Nɨ mangɨva Israelɨn gumazir dapaniba akuvagh me mɨkɨm suam, ‘Ikiavɨra Itir God, a ian ovaviba, Abraham, Aisak ko Jekopɨn God, a na batogha, kamaghɨn mɨgei: Kɨ ian garima, Isipia pazavɨra ia gami. ");
INSERT INTO msy2020_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kɨ ia inigh Isipɨn kantrin azenan mangasa mɨkemegha gɨfa, kantrin kam me pazavɨra ia gami. Egh kɨ ia inigh nguazir aghuimɨn mangam. Nguazir kam a bar derazɨ, biziba an ikiava bar deraghavɨram aghui. Nguazir kam, Kenania, Hitia, Amoria, Peresia, Hivia ko Jebusia datɨrɨghɨn a gapiagha iti.’ ");
INSERT INTO msy2020_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Eghtɨ Israelɨn gumazir dapaniba nɨ baraghtɨ, nɨ me inigh Isipɨn atrivim bagh mangɨva kamaghɨn a mɨkɨm, ‘Ikiavɨra Itir God, a Hibruian God, a iza e bato. Nɨ datɨrɨghɨn en amamangatɨghtɨ, e 3plan aruebar mangɨ gumazamiziba puvatɨzir danganimɨn mangɨghɨva, Ikiavɨra Itir God, en God, e an ofa damuam.’ ");
INSERT INTO msy2020_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Kɨ kamaghɨn fo, Isipɨn atrivim ian amamangatɨghan kogh mangɨ, a gantɨ nan gavgavim an gavgavim gafiragham. Eghtɨ a dughiar kamɨn ian amamangatɨghtɨ, ia mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kɨ uan gavgavimɨn Isipia gasɨghasɨgh, mirakelɨn igharagha garir avɨribar amuam. Bizir kabar gɨn, a ia ateghtɨ, ia mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Kɨ Isipia damutɨ me ia gifuegham, eghtɨ ia mangamin dughiamɨn, ia dafarir kɨnibar mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Israelian amiziba bar vaghvagh mangɨ, uarir boroghɨra itir Isipian amizibar dɨpenibar mangɨ, egh uaghan pura amizir uan adarazir dɨpenibar aven akuiba, korotiaba ko gol ko silvan kurkaziba bagh men azangsɨgh. Eghtɨ gɨn Israelia bizir kabar uan otariba ko guivibar kurkiam. Tuavir kamɨn ia Isipian bizir aghuiba pura da inigh mangam.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ezɨ Moses God ikaragha ghaze, “Israelian gumazir dapaniba nɨghnɨzir gavgavim nan ikian kogh, bizir kɨ me mɨgeiba baraghan kogh, egh suam, ‘Nɨ na batozir puvatɨ,’ eghtɨ kɨ manmaghɨn damuam?” ");
INSERT INTO msy2020_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ezɨ Ikiavɨra Itir God a mɨgɨa ghaze, “Nɨ tizim uan dafarimɨn an suiraghav iti?” Ezɨ Moses ghaze, “Aghorir asadivim.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ezɨ Ikiavɨra Itir God ghaze, “Nɨ nguazimɨn anekunigh.” Ezɨ Moses anekunizɨma, a kuruzimɨn mɨn otozɨ, Moses an degiaghirɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ezɨ Ikiavɨra Itir God ghaze, “Nɨ uan dafarim amadagh an ipemɨn suiragh.” Ezɨ Moses uan dafarim amadagha an ipemɨn suirazɨma, a uam aghorir asadivimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ezɨ Ikiavɨra Itir God ghaze, “Nɨ kamaghɨn damightɨ Israelia nɨghnɨzir gavgavim ikɨ kamaghɨn fogham, Ikiavɨra Itir God, a men ovavibar God, an Abraham ko Aisak ko Jekopɨn God, a nɨ bato.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Egha Ikiavɨra Itir God ua kamaghɨn a mɨgei, “Nɨ uan dafarim uan evarim gisɨn korotiamɨn aven amadagh.” Ezɨ Moses uan dafarim uan evarim gisɨn korotiamɨn aven amadaghava uam anesi, ezɨ arɨmariam lepa an dafarim bato, egha a ghuariamɨn mɨn ghurghuri. ");
INSERT INTO msy2020_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ezɨ Ikiavɨra Itir God kamaghɨn a mɨgei, “Nɨ uan dafarim ua uan evarim gisɨn korotiamɨn aven anemadagh.” Ezɨ Moses God mɨkemezɨ moghɨn ami, egha a ua uan dafarim asizɨ, an dafarim ua deragha an mɨkarzimɨn mɨrara gari. ");
INSERT INTO msy2020_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ezɨ Ikiavɨra Itir God kamaghɨn a mɨgei, “Me nɨghnɨzir gavgavim nɨn ikian kogh, egh mirakelɨn nɨ faraghava amizimɨn ganigh nɨghnɨzir gavgavim an ikian koghtɨ, mirakelɨn kamnang me damightɨ, me nɨghnɨzir gavgavim ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Egh me mirakelɨn arazir kamningɨn ganigh, egh nɨghnɨzir gavgavim ikian kogh, egh nɨn akam baraghan koghtɨ, nɨ Nailɨn Fanemɨn mangɨ dɨpatam tuigh nguazim gingegh. Eghtɨ dɨpar nɨ nguazim gingezim, ghuzimɨn otogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ezɨ Moses Ikiavɨra Itir God mɨgɨa ghaze, “Markɨ, Ekiam. Nɨ na amangan markɨ. Kɨ fomɨra iza datɨrɨghɨn deragha bizibav geir puvatɨ. Ezɨ nɨ datɨrɨghɨn na mɨgeima, kɨ bizibav geir gumazimɨn mɨn otozir puvatɨ. Kɨ asoghosogha bizibav gɨa, egha uaghan nɨmɨra bizibav gei. Egha kɨ mɨkɨmamin nɨghnɨzitam zuamɨra a ginɨrɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ezɨ Ikiavɨra Itir God a mɨgɨa ghaze, “Tina gumazimɨn akamɨn ingari? Tina a gamima, an kuariba a bangani, o a mɨgeir puvatɨ? Tina a gamima, a gari, o an damaziba an okafi? Kar kɨrara, kɨ Ikiavɨra Itir God, kɨ bizir kabagh ami da otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ezɨ nɨ mangɨ. Kɨ nɨn akuraghtɨ, nɨ mɨkɨmam. Kɨ nɨ mɨkɨmtɨ, nɨ mɨkɨmam.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ezɨ Moses ghaze, “Ekiam, ga uaning, markɨ. Nɨ ti gumazir igharazitam amadagh.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ezɨ Ikiavɨra Itir God atara Moses bagha navim an isi, egha kamaghɨn mɨgɨa ghaze, “Nɨ manmaghɨn uan avebam Aron gɨnɨghnɨsi? A Livain adarazir gumazim. Kɨ fo, a deraghvɨra bizibav gei. Ezɨ a datɨrɨghɨn nɨ bagha izi. A nɨn ganigh, an navim deragham. ");
INSERT INTO msy2020_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Eghtɨ gɨn nɨ a geghanɨva a mɨkɨmamin bizibar a mɨkɨm. Kɨ guan akuraghtɨ, gua mɨkɨmam. Egh bizir manaba, kɨ gua mɨkɨmtɨ, gua fofozim inigh dar amuam. ");
INSERT INTO msy2020_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","A nɨn bizibav kɨmamin gumazim, egh a nɨ bagh gumazamizibav kɨmam. Egh an nɨghnɨzimɨn a nɨn akatorimɨn mɨn ikiam. Egha an damazimɨn, nɨ mati an godɨn mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Egh nɨ uan dafarimɨn aghorir asadivir kamɨn suiragh mangɨ. Egh nɨ gɨn aghorir asadivir kamɨn mirakelbar amuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ezɨ Moses uamategha uan amerem Jetro bagha ghugha a mɨgɨa ghaze, “Ga uaning, nɨ na teghtɨ kɨ uamategh Isipɨn mangɨgh uan adarazir ganika, me ti ikiavɨra ikiama?” Ezɨ, Jetro an amamangatɨgha a mɨgɨa ghaze, “Aria, nɨ navir averiar amɨrizim sara mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ezɨ Moses Midianra ikiavɨra itima, Ikiavɨra Itir God a mɨgɨa ghaze, “Isipian gumazir nɨ mɨsoghasava amiba, me ariaghire. Kamaghɨn, nɨ uamategh Isipɨn mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ezɨ Moses uan amuim ko otarir pumuning donki dafagha, asadivir aghorir God iniasa a mɨkemezir kam, uan dafarimɨn an suiragha, dɨkavigha Isipɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Egha Ikiavɨra Itir God ua Moses kamaghɨn a mɨgei, “Nɨ uamategh Isipɨn mangɨghɨva, atrivimɨn damazimɨn mirakelbar amu. Kɨ mirakelbar amuamin gavgavim nɨ ganɨngi. Egh kɨ atrivimɨn navim damightɨ a gavgavigham, eghtɨ a Israelian amamangatɨghtɨ, me mangɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Eghtɨ nɨ kamaghɨn atrivim mɨkɨm suam, ‘Ikiavɨra Itir God kamaghɨn nɨ mɨgei, “Israel nan otarir ivariam. ");
INSERT INTO msy2020_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ezɨ kɨ nɨ mɨgei, Nɨ nan otarim ateghtɨ a mangɨva nan ofa damuam. Egh nɨ an anogoreghtɨ, a mangɨghan koghtɨ, kamaghɨn, kɨ nɨn otarir ivariam mɨsueghtɨ an aremegham.” ’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ezɨ Moses uan amuiroghboriba ko Isipɨn zuima, amɨnim pɨrima me tuavir arɨzimɨn avughsazir danganir mamɨn iti. Ezɨ Ikiavɨra Itir God Moses batogha a mɨsueghtɨ an aremeghasava ami. ");
INSERT INTO msy2020_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ezɨ Mosesɨn amuim Sipora dagɨar ghumtɨzir mam inigha uan otarimɨn mɨkarzir mogomemɨn inim atugha, Mosesɨn dagarimning gatɨgha, kamaghɨn a mɨgei, “Ghuzir kam bangɨn, nɨ datɨrɨghɨn na ko ga poroghamimning.” ");
INSERT INTO msy2020_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Dughiar kam Sipora mɨkarzir mogomemɨn inim aghorir arazim gɨnɨghnɨgha egha ghaze, “Ghuzir kam bangɨn, ga poroghamimningɨn oto.” Ezɨ Ikiavɨra Itir God kamaghɨn ganigha Moses ataghizɨ a ikia egha, aremezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ezɨ Ikiavɨra Itir God Aron mɨgɨa ghaze, “Nɨ gumazamiziba puvatɨzir danganimɨn mangɨva Moses batogh.” Ezɨ Aron dɨkavigha ghua Godɨn mɨghsɨamɨn otogha, Moses batogha an tore. ");
INSERT INTO msy2020_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Ezɨ Moses bar Aron kamaghɨn a geghara ghaze, God akaba na ganɨngigha egha Isipɨn mangɨva dar gun mɨkɨmasa na amada. Egha God mirakelba nan akagha ghaze, kɨ mangɨ Isipɨn dar amuam. ");
INSERT INTO msy2020_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Egha gɨn Moses ko Aron Isipɨn otogha Israelian gumazir dapaniba bar me akufa. ");
INSERT INTO msy2020_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ezɨ Aron Ikiavɨra Itir God Moses mɨkemezir biziba bar dar gun me mɨgɨa, egha uaghan mirakelba gumazamizibar damazimɨn dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ezɨ me nɨghnɨzir gavgavim iti. Me kamaghɨn oraki, Ikiavɨra Itir God me bagha iza men garima, Isipia pazavɨra me gamima, a me bagha nɨghnɨgha men apangkufi. Kamaghɨn, me teviba apɨrigha, dapaniba avigha nguazimɨn gara an ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Egha Moses ko Aron Isipɨn atrivim bagha ghugha kamaghɨn a mɨgei, “Ikiavɨra Itir God, a Israelian God ghaze, ‘Nɨ nan gumazamiziba ateghtɨ me mangɨ, egh isatam gumazamiziba puvatɨzir danganimɨn a damuva nan ziam fam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ezɨ atrivim ghaze, “Ikiavɨra Itir God, a tina? Kɨ tizim bagh a baregh Israelia ateghtɨ me mangam? Kɨ Ikiavɨra Itir God gɨfozir puvatɨ, kamaghɨn kɨ Israelia ateghtɨ me mangɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ezɨ Moses ko Aron ghaze, “Hibruian God, a izava e bato. Kamaghɨn, e uari nɨ en amamangatɨghtɨ, e aruer 3plan gumazamiziba puvatɨzir danganimɨn mangɨ, Ikiavɨra Itir God, e uan Godɨn ofa damuam. E kamaghɨn damighan koghtɨ, an arɨmariar kuram o mɨdorozir ekiamɨn e damigh e mɨsueghtɨ e arɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ezɨ atrivim Moses ko Aron mɨgɨa ghaze, “Gua manmagh nɨghnigha gumazamiziba men ingangarimɨn men anogorosi? Gua uan ingangarim bagh uamategh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Gua gan, Isipɨn aven Israelia bar avɨraseme, ezɨ gua ingangarim damuan men anogorosi.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","7","Egha dughiar kamra, Isipian gumazir kurar ingangaribar gariba ko, Israelian gumazir men apengan ingariba, atrivim me mɨgei, “Ia ami moghɨn grazir mɨdiarir brighbar ingariba isɨ Israelian danɨngan markɨ. Me uari mangɨ graziba iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ia me mɨkɨmtɨ, me brighbar ingartɨ, dar dɨbobonim faragha iti moghɨra kamaghɨra ikɨ. Dɨbobonir kam isɨvagh magɨran markɨ. Bar markɨ. Me amɨragha egha ghaze, e ateghtɨ e gumazamiziba puvatɨzir danganimɨn mangɨgh uan Godɨn ofa damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ia ingangarir avɨriba me danɨng, egh me damutɨ, me bar puvɨram ingar, egh ifavarir mɨgɨrɨgɨar kaba baraghamin dughiaba puvatɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ezɨ Isipian ingangarimɨn garir gumazir kuraba ko men apengan itir ingangarimɨn garir gumaziba azenan ghua kamaghɨn Israelia mɨgei, “Atrivim ghaze, ‘E ua graziba ia danɨngan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ia uan gavgavibar tintinibar mangɨ graziba iniva, brighɨn avɨribar ingartɨ dar dɨbobonim faragha ikezɨ moghɨra ikɨ.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kamaghɨn Israelian gumazamiziba graziba buriasa tintinibar ghua, Isipɨn nguibamɨn danganibar grazir otevir muziariba buri. ");
INSERT INTO msy2020_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ezɨ ingangarimɨn garir gumazir kuraba men avɨgha ghaze, “E faragha graziba ia ganɨngizɨ ia brighbar ingarizɨ moghɨra, datɨrɨghɨn dughiaba bar kamaghɨra ingar.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Isipian ingangarimɨn garir gumazir kuraba faragha Israelian gumazir maba, men apengan ingangarimɨn garir gumaziba me amɨsefe. Egha datɨrɨghɨn me me bagha ghua, puv me mɨsogha me mɨgɨa ghaze, “Manmaghsuavɨra ia datɨrɨghɨn ingarizir brighɨn dɨbobonim, ia faragha ingarizɨ dɨbobonimɨn mɨn otozir puvatɨ?” ");
INSERT INTO msy2020_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ezɨ Israelian ingangaribar garir gumaziba ghua uari bagha atrivim mɨgɨa ghaze, “Nɨ manmaghsua kamaghɨn e nɨn ingangarir gumaziba e gami? ");
INSERT INTO msy2020_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Me graziba e ganɨngizir puvatɨgha, brighbar ingarasa puram e mɨgei. Egha datɨrɨghɨn e mɨsosi. Kar en osɨmtɨzim puvatɨ. Ia Isipia, kar ian osɨmtɨzimra.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ezɨ atrivim kamaghɨn me mɨgei, “Ia puram amɨragha ingangarimɨn aghua! Egha ghaze, ‘Nɨ en amamangatɨghtɨ, e mangɨ Ikiavɨra Itir God bagh ofa damuam.’ ");
INSERT INTO msy2020_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ia datɨrɨghɨra uamategh uan ingangarim damusɨ mangɨ! Me grazitaba ia danighan kogham. Eghtɨ ia brighɨn dɨbobonir me ia mɨkemezir kam, ia dar ingarightɨ da otifigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Ezɨ Israelian ingangarimɨn garir gumazir me mɨseveziba orazi, atrivim brighɨn dɨbobonim otevegh izighiran an anogoroke. Ezɨ me fo, datɨrɨghɨn osɨmtɨzir dafam me bato. ");
INSERT INTO msy2020_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Egha me atrivimɨn danganim ategha ghua Moses ko Aron bato. Aning me mɨzua iti. ");
INSERT INTO msy2020_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Egha ingangarimɨn garir gumaziba kamaghɨn aning mɨgei, “Gua e gamizɨ datɨrɨghɨn e mati atrivim ko an gumazir dapanibar atinimɨn mughuriam atɨ. Egha me e mɨsoghtɨ e ovengamin tuavim akɨrigha gɨfa. Kamaghɨn amizɨ, Ikiavɨra Itir God guan arazir kamɨn ganigha gɨfa, egh guan arazir kamɨn ivezir kuram gua danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ezɨ Moses uam Ikiavɨra Itir God bagha ghua kamaghɨn a mɨgei, “Ekiam, nɨ manmaghsua uan gumazamiziba arazir kurar kamɨn me gami? Egha nɨ tizim baghavɨra na amadazɨma, kɨ kagh ize? ");
INSERT INTO msy2020_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kɨ nɨn akaba inigha ghua atrivim mɨkemezir dughiamɨn ikegha iza datɨrɨghɨn, atrivim arazir kurabar me gami. Ezɨ nɨ men akurvaghasa bizitam gamizir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ezɨ Ikiavɨra Itir God Moses mɨgei, “Nɨ datɨrɨghɨn mangɨ bizir kɨ atrivim damuamimɨn ganam. Kɨ uan gavgavimɨn a damightɨ, a nan gumazamiziba ateghtɨ me mangam. Guizbangɨra, kɨ uan gavgavimɨn pamten ingar, pamten a mɨkɨmtɨ a uan kantrin me batueghtɨ, me mangam.” ");
INSERT INTO msy2020_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Egha God kamaghɨn Moses mɨgɨa ghaze, “Kɨ uabɨ kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Azenir bar faragha ghua gɨvazibar, kɨ Abraham ko Aisak ko Jekop, me batifi. Ezɨ me fo, kɨ Gavgaviba Bar Itir God. Egha kɨ uan ziam Ikiavɨra Itir God, an gun me mɨkemezir puvatɨ. Me ziar kam gɨfozir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Egha kɨ uaghan uan Akar Dɨkɨrɨzir Gavgavim me ko anekɨrigha ghaze, kɨ Kenanian nguazim me danɨngam. Nguazir me itir kam, kar men nguazim puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Isipia datɨrɨghɨn Israelia gamizɨ, me ingangarir gumazir kɨnibar ikia, tuava ararer dafam gami. Ezɨ kɨ men ararem baregha, uan Akar Dɨkɨrɨzir Gavgavim ginɨrɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nɨ nan akam isɨ Israelia me danɨng, ‘Kɨ uabɨ, kɨ Ikiavɨra Itir God. Kɨ Isipian dafarim da ia iniva osɨmtɨzir me ia garɨziba da ia inigh, egh ia damightɨ ia fɨrighɨregham. Egh kɨ uan gavgavimɨn ivezir kuram me danɨng, egh ian akuragh ua ia iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Egh kɨ ia damightɨ ia nan gumazamizibar ikɨtɨ, kɨ ian Godɨn mɨn ikiam. Egh kɨ gɨn ia damightɨ ia Isipian ingangarir arazimɨn fɨrighɨregh, dughiar kamɨn ia fogh suam, kɨ Ikiavɨra Itir God, ian God. ");
INSERT INTO msy2020_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kɨ ia inigh mangɨ nguazir kamɨn otogham, nguazir kam, kɨ faragha Abraham, Aisak ko Jekop, me ko akam akɨrizir nguazim. Kɨ ia danightɨ, a ian nguazimɨn mɨn ikiam. Kɨ Ikiavɨra Itir God, kɨ mɨkemegha gɨfa.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ezɨ Moses akar kamɨn Israelia mɨkeme. Ezɨ men ingangarir mɨzazim men nɨghnɨziba abɨni. Kamaghɨn amizɨma, me Mosesɨn akam barazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ezɨ gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ mangɨ Isipɨn atrivim mɨkemeghtɨ, a Israelia ateghtɨ me an kantri ategh mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ezɨ Moses kamaghɨn an akam ikaragha ghaze, “Israelia nan akam barazir puvatɨ. Ezɨ atrivim manmaghɨn na baragham? Na mɨzem na basemezɨ, kɨ deragha bizibav geir puvatɨ. Egh kɨ manmaghɨn deragh atrivim mɨkɨmam?” ");
INSERT INTO msy2020_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ezɨ Ikiavɨra Itir God, Moses ko Aron Israelia inigh Isipɨn azenan mangasa, akar gavgavim aning ganigha aning amadazɨ, aning Israelia mɨkɨm egh Isipɨn atrivim mɨkɨmasa zui. ");
INSERT INTO msy2020_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ezɨ Ruben a Jekopɨn otarir ivariam, an otarir 4pla bate, Hanok, Palu, Hesron, ko Karmi. 4plan otarir kaba, me vaghvagha uan ikɨzibar inazir afeziabar otifi. Ezɨ men ikɨziba vaghvagha men ziaba ini. ");
INSERT INTO msy2020_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ezɨ Simeon otarir 6pla iti, Jemuel, Jamin, Ohat, Jakin, Sohar, ko Saul, kar Kenanian amizimɨn otariba. Otarir kaba, me vaghvagha uan ikɨzibar inazir afeziabar otifi. Ezɨ men ikɨziba vaghvagha men ziaba ini. ");
INSERT INTO msy2020_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ezɨ Livai otarir 3pla iti, Gerson, Kohat, ko Merari. Otarir kaba, me vaghvagha uan ikɨzibar inazir afeziabar otifi. Ezɨ men ikɨziba vaghvagha men ziaba ini. Ezɨ Livai azenir 137plan ikegha areme. ");
INSERT INTO msy2020_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ezɨ Gerson otarir pumuning iti, Lipni, ko Simei. Ezɨ gɨn aning vaghvagha uan ikɨzimningɨn dapanimningɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ezɨ Kohat otarir 4pla iti, Amram, Ishar, Hebron, ko Usiel. Egha Kohat azenir 133plan ikegha areme. ");
INSERT INTO msy2020_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ezɨ Merari otarir pumuning iti, Mali ko Musi. Gumazir kaba bar, men ovavir boriba sara, me Livain anabamɨn aven itir adarasi. ");
INSERT INTO msy2020_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ezɨ Amram uan afeziamɨn buaramizim Jokebetɨn itima, an a bagha Aron ko Moses bate. Ezɨ Amram azenir 137plan ikegha areme. ");
INSERT INTO msy2020_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ezɨ Ishar otarir 3pla iti, Kora, Nefek, ko Sikri. ");
INSERT INTO msy2020_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ezɨ Usiel otarir 3pla iti, Misael, Elsafan, ko Sitri. ");
INSERT INTO msy2020_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ezɨ Aron Eliseban iti, an Aminadapɨn guivim, egha Nasonɨn buaramizim. Egha an a bagha Nadap, Abihu, Eleasar, ko Itamar bate. ");
INSERT INTO msy2020_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ezɨ Kora otarir 3pla iti, Asir, Elkana, ko Abiasap. Me Koran ikɨzimɨn inaziba. ");
INSERT INTO msy2020_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ezɨ Eleasar, Aronɨn otarim, a Putielɨn guivimɨn itima, an a bagha Finias bate. Gumazir kaba bar, me Livain anabamɨn ikɨzibar dapaniba, me vaghvagha uan ikɨzibar amodoghɨn, me men ziaba osiri. ");
INSERT INTO msy2020_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ezɨ Aron ko Moses aningra, Ikiavɨra Itir God kamaghɨn aning mɨgei, “Gua Israelian anababa bar, dar ikɨziba vaghvagh me inigh, egh Isipɨn azenan mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ezɨ gumazir kamningra, Moses ko Aron, aning Israelian amamangatɨghtɨ me fɨrighɨreghasa Isipɨn atrivim mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ezɨ Moses Isipɨn kantrin itima, Ikiavɨra Itir God kamaghɨn a mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Kɨ Ikiavɨra Itir God. Ezɨ, akar kɨ nɨ mɨgeiba, nɨ bar dar gun Isipɨn atrivim mɨkɨm.” ");
INSERT INTO msy2020_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ezɨ Moses a ikara, “Nɨ fo, nan mɨzem na basemezɨ, kɨ deragha bizibav geir puvatɨ. Kamaghɨn atrivim manmaghɨn na baragham?” ");
INSERT INTO msy2020_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ezɨ Ikiavɨra Itir God Moses mɨgei, “Kɨ nɨ damightɨ, nɨ atrivimɨn damazimɨn Godɨn mɨn otogham. Eghtɨ nɨn avebam Aron Godɨn akam inigha izir gumazimɨn mɨn otoghɨva, nɨn akaba isɨ dar gun atrivim mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Eghtɨ akar gavgavir kɨ nɨ mɨgeiba, nɨ bar dar gun Aron mɨkemegh. Eghtɨ a kamaghɨn atrivim mɨkɨm suam, a Israelia ateghtɨ, me an kantri ategham. ");
INSERT INTO msy2020_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Eghtɨ kɨ atrivimɨn navim damightɨ, a gavgavigham. Guizbangɨra, kɨ Isipɨn kantrin mirakelba ko dɨgavir kuram gamir arazarazir avɨribar amutɨ da otivam, ");
INSERT INTO msy2020_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","eghtɨ atrivim dar gan, egh nɨn akam baraghan kogham. Egh kɨ uan gavgavimɨn Isipia ivezir bar kuram me danɨngam. Egh nan gumazamiziba Israelia, men anababa bar, kɨ me inigh Isipɨn kantrin azenan mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Kɨ uan gavgavimɨn Isipia ivezir kuram me danigh, egh Israelia inigh Isipɨn kantrin azenan mangam, eghtɨ dughiar kamɨn Isipia fogh suam, kɨ Ikiavɨra Itir God.” ");
INSERT INTO msy2020_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Egha Moses ko Aron, Ikiavɨra Itir God akar gavgavim aning mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Dughiar aning atrivim ko mɨkemezir kam, Moses 80plan azeniba iti, ezɨ Aron 83plan azeniba iti. ");
INSERT INTO msy2020_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Ikiavɨra Itir God kamagh Moses ko Aron mɨgei, “Atrivim kamaghɨn guan azaragham, gua dɨgavir kuram gamir arazitabar amu, eghtɨ nɨ Aron kamagh a mɨkɨm suam, ‘Nɨ uan asadivir aghorim isɨ atrivimɨn damazimɨn anekunigh.’ Egh a kamaghɨn damightɨ, asadivir aghorim kuruzimɨn otogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Egha Moses ko Aron atrivimɨn bighan ghua, Ikiavɨra Itir Godɨn akar gavgavim mɨkemezɨ moghɨram ami. Egha Aron uan asadivir aghorim atrivim ko an ingangarir gumazibar damazimɨn anekunizɨ, a kuruzimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ezɨ atrivim uan fofozir gumaziba ko imezibagh amir gumazibar diazɨ me ize. Isipian imezibagh amir gumazir kaba, uan mogomer akavsiaba inigha uaghan kamaghɨra dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Egha me vaghvagha uan asadivir aghoriba akurima, da kuruzibar otifi. Ezɨ Aronɨn asadivir aghorim iza menaba tuvareme. ");
INSERT INTO msy2020_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ezɨ atrivim bizir kamɨn ganigha an navim gavgafi. Ikiavɨra Itir God mɨkemezɨ moghɨn, atrivim Moses ko Aron baraghizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ezɨ Ikiavɨra Itir God Moses mɨgei, “Atrivimɨn navim bar gavgavizɨ, a gumazamiziba ateghtɨ me mangan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","A gurum mɨzaraghara Nailɨn Fanemɨn mangɨtɨ, nɨ mangɨ a batogh. Nɨ uan asadivir aghorir kuruzimɨn otozim, uan dafarimɨn an suiragh mangɨ dɨpar mɨriamɨn a mɨzuam. ");
INSERT INTO msy2020_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Egh nɨ kamaghɨn atrivim mɨkɨm, ‘Ikiavɨra Itir God, Hibruian God, nɨ mɨkɨmasa na amadagha ghaze, “Nɨ nan gumazamizibar amamangatɨghtɨ, me nan ziam fɨsɨ, gumazamiziba puvatɨzir danganimɨn mangɨ.” Ezɨ nɨ an akam baraghizir puvatɨgha iza datɨrɨkɨn. ");
INSERT INTO msy2020_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ezɨ Ikiavɨra Itir God datɨrɨghɨn kamaghɨn mɨgei, “Nɨ bizir kɨ damuamibar ganigh fogh suam, kɨrara Ikiavɨra Itir God.” Nɨ gan, kɨ uan dafarimɨn suirazir asadivir aghorir kamɨn dɨpam mɨsueghtɨ, dɨpaba bar ragh ghuzimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Eghtɨ osiriba bar arɨmɨghireghtɨ, Nailɨn Fanem kurigh mɨghuaghtɨ, Isipia an dɨpamra aman iburagham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Egha Ikiavɨra Itir God Moses uam a mɨgei, “Nɨ Aron mɨkemeghtɨ, a uan asadivir aghorim isɨ, uan agharim amadagh Isipɨn dɨpabar akaghkagh, faneba, daghuriba, ko dɨpar akareba, mozir dɨpaba dagh isɨn akakaghtɨ, dɨpaba bar ghuzimram otogham. Egh Isipɨn nguazim bar ghuzimra ikɨva, uaghan iter itariba ko dagɨar mɨneba sara izevegham.” ");
INSERT INTO msy2020_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ezɨ Moses ko Aron Ikiavɨra Itir God, akar gavgavim mɨkemezɨ moghɨram ami. Egha aning ghua atrivim ko an ingangarir gumazibar damazimɨn, Aron uan asadivir aghorim fegha, Nailɨn Fanem mɨsoke. Ezɨ dɨpaba bar ragha ghuzimɨn otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ezɨ osirir dɨpamɨn itiba bar ariaghirezɨ, dɨpam puvɨra mughuasi. Ezɨ Isipian gumazamiziba an dɨpatam raman ibura. Ezɨ ghuzim bar Isipɨn danganibar iti. ");
INSERT INTO msy2020_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ezɨ atrivimɨn imezibagh amir gumaziba, uan mogomer akavsiaba inigha uaghan kamaghɨra dagh ami. Ezɨ atrivimɨn navim bar gavgafi. Ezɨ Ikiavɨra Itir God mɨkemezɨ moghɨra, atrivim Moses ko Aron baraghan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Egha atrivim bizir kam mɨghɨgha a gɨnɨghnɨzir puvatɨgha, ragha uamategha uan dɨpenir ekiamɨn aven ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ezɨ Isipia Nailɨn Fanemɨn dɨpam raman ibura, kamaghɨn amizɨ, me Nailɨn Faner mɨriamɨn dɨpabara amasa mozibagh tui. ");
INSERT INTO msy2020_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ikiavɨra Itir God dɨpam mɨsoghezɨma, dɨpam ikuvigha ikia ghua 7plan arueba gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Egha Ikiavɨra Itir God Moses mɨgei, “Nɨ mangɨ atrivim mɨkɨm suam, ‘Ikiavɨra Itir God ghaze, “Nan gumazamiziba ateghtɨ me mangɨ, egh nan ziam fam.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Egh nɨ aghuaghtɨ, kɨ pazɨ nɨ damutɨ mɨtiviba nɨn kantrin nguazim bar anevaragham. ");
INSERT INTO msy2020_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Eghtɨ Nailɨn Fanem mɨtiviba a gizɨvagh, egh anetegh mangɨ, nɨn dɨpenir ekiamɨn mangam. Egh nɨ akuir mɨsiam ko, nɨn dakozim ko, nɨn ingangarir gumazibar dɨpeniba ko, nɨn gumazamizibar dɨpeniba ko, nɨn bretba tuer danganiba ko, bretbar ingarir mɨneba, mɨtiviba bar dar mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Egh da uari akunɨva, nɨ ko nɨn gumazamiziba, ko nɨn ingangarir gumaziba, da bar ian ghuavanangam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Egha Ikiavɨra Itir God Moses mɨgei, “Nɨ Aron mɨkemeghtɨ, a uan agharir asadivir aghorimɨn suirazim amadagh. Egh Isipɨn Faneba ko daghuriba ko dɨpar akarebagh isɨn a ghufegh, mɨtivibar amightɨ, da dɨpam ategh anang Isipɨn nguazim bar anevaragh.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ezɨ Aron uan agharim isa anemadagha dɨpabagh isɨn a ghufezɨ, mɨtiviba azenan iza nguazim gizɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ezɨ imezibagh amir gumaziba uan mogomer akavsiaba inigha uaghan kamaghɨra dagh amizɨ, mɨtiviba nguazimɨn otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Egha atrivim Moses ko Aronɨn dɨagha aning mɨgei, “Gua Ikiavɨra Itir God mɨkemeghtɨ, a mɨtiviba e dama da batokegh. Eghtɨ kɨ nɨn gumazamiziba ateghtɨ, me mangɨ Ikiavɨra Itir God bagh ofa damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ezɨ Moses a ikara, “Kɨ nɨ bagha God ko mɨkɨmasa bar akonge. Nɨ dughiatam ginabaghtɨ, kɨ nɨ ko nɨn ingangarir gumaziba, ko nɨn gumazamiziba, ia bagh God ko mɨkɨmam. Eghtɨ mɨtiviba ia ategh, tam ua ikian kogham. Da Nailɨn Fanemra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ezɨ atrivim ghaze, “Nɨ gurumɨn na bagh God ko mɨkɨmam.” Ezɨ Moses a mɨgei, “Nɨ nan azarazɨ moghɨn, kɨ damuam. Eghtɨ nɨ fogh suam, godɨn tam Ikiavɨra Itir God, en Godɨn mɨn itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Eghtɨ nɨ uabɨ, ko nɨn dɨpeniba, nɨn ingangarir gumaziba, ko nɨn gumazamiziba, mɨtiviba bar ia ategh mangɨ Nailɨn Fanemra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Egha Moses ko Aron atrivim ategha ghugha, Moses pamten Ikiavɨra Itir God ko mɨgɨa ghaze, a mɨtivir a faragha atrivim bagha amadaziba, a da batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ezɨ Ikiavɨra Itir God Moses an azarazɨ moghɨn ami, ezɨ mɨtivir dɨpenibar itiba, ko mɨtivir dɨpenir dɨvazibar aven itiba, ko mɨtivir azenibar itiba, da bar tintinibar ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ezɨ Isipɨn gumazamiziba dar kuaba akuvagha pozir avɨribav kɨni. Ezɨ da kurima, dar mughuriam Isipɨn nguazim bar anevara. ");
INSERT INTO msy2020_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ezɨ atrivim gari, mɨtiviba ariaghirezɨ, Ikiavɨra Itir God mɨkemezɨ moghɨn, an navim ua gavgavizɨ, a Moses ko Aron baraghan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Egha Ikiavɨra Itir God Moses mɨgei, “Nɨ Aron mɨkemeghtɨ, a uan asadivir aghorim isɨ nguazim mɨsueghtɨ, Isipɨn nguazimɨn itir mɨneziba bar ragh itibar otifigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Egha aning kamaghɨn amigha, Aron uan asadivir aghorimɨn nguazim mɨsoghezɨ, Isipɨn itir nguazir mɨneziba bar, ragha itibar otivigha, gumazamiziba ko asɨziba avara. ");
INSERT INTO msy2020_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ezɨ imezibagh amir gumaziba uaghan uan mogomer akavsiaba inigha, itibar amightɨ da otivasa, ezɨ men imeziba ingarir puvatɨ. Ezɨ itiba bar danganibar ikia, gumazamiziba ko asɨziba avara. ");
INSERT INTO msy2020_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ezɨ imezibagh amir gumaziba, atrivim kamaghɨn a mɨgei, “God uabɨ bizir kam gami!” Ezɨ atrivimɨn navim gavgavizɨ, Ikiavɨra Itir God mɨkemezɨ moghɨn, a Moses ko Aron baraghan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Gurum mɨzaraghara atrivim dɨpamɨn mangɨtɨ, nɨ mangɨ a batogh a mɨkɨm suam, ‘Ikiavɨra Itir God kamaghɨn mɨgei, Nɨ nan gumazamiziba ateghtɨ me mangɨ, egh nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Nɨ oragh, nɨ aghuaghtɨ, kɨ berezir avɨriba amadaghtɨ da izɨ, nɨ uabɨ ko, nɨn ingangarir gumaziba, nɨn gumazamiziba ko, ian dɨpeniba bar ia bagh izam. Egh Isipɨn dɨpeniba bar bereziba izɨvaghva, nguazir ia apiaghav itiba bar da avaragham. ");
INSERT INTO msy2020_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Eghtɨ dughiar kamɨn, kɨ Gosenɨn Distrighɨn ganam, egh aneteghtɨ, berezitam an ikian kogham. Distrighɨn kam, nan gumazamiziba an iti. Kɨ kamaghɨn damightɨ nɨ fogh suam, kɨ Ikiavɨra Itir God, kɨ nguazir kamɨn ingara iti. ");
INSERT INTO msy2020_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Egh kɨ uan gumazamiziba ko nɨn gumazamiziba tuiragh, egh uan gumazamizibar akurvagh, nɨn gumazamizibar akurvaghan kogham. Nɨ gan, gurumzaraghan arazir kam otivam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Ezɨ Ikiavɨra Itir God arazir kam gami. Egha berezir avɨrim amadazɨ, da atrivimɨn dɨpenir ekiam ko, an ingangarir gumazibar dɨpenibagh izɨfa. Egha Isipɨn nguazim, bereziba bar anevarazɨ, a bar ikufi. ");
INSERT INTO msy2020_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Egha atrivim Moses ko Aronɨn dɨagha aning mɨgei, “Ia mangɨ, kantrin kamɨn averiamra, ofa isɨ uan God danɨng.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ezɨ Moses kamaghɨn a ikaragha ghaze, “E kantrin kamɨn aven, uan Godɨn ofa damightɨ, a deraghan kogham. Guizbangɨra, e asɨzir Isipia ofa gamir puvatɨziba, e da isɨ Ikiavɨra Itir God en Godɨn ofa damightɨ, me asɨzir kabar ganigh naviba en ikuvigh, en atarɨva, egh dagɨaba e ginivightɨ, e arɨmɨghiregham. Kamaghɨn, e kagh ofa damuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Egh Ikiavɨra Itir God, en God, akar gavgavim e mɨkemezɨ moghɨn, e aruer 3plan mangɨ gumazamiziba puvatɨzir danganimɨn mangɨ ofa damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ezɨ atrivim ghaze, “Kɨ ia ateghtɨ, ia mangɨ gumazamiziba puvatɨzir danganimɨn mangɨ, Ikiavɨra Itir God ian Godɨn ofa damu, egh bar saghon mangan kogham. Aria, gua na bagh God ko mɨkɨm.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ezɨ Moses kamaghɨn a ikaragha ghaze, “Kɨ nɨ ategh mangɨ, dughiar kamra kɨ nɨ bagh Ikiavɨra Itir God ko mɨkemeghtɨ, gurumɨn bereziba mangɨ, nɨ ko nɨn ingangarir gumaziba ko nɨn gumazamiziba ategham. Nɨ orakigh, nɨ ua e gifaran markɨ, egh kamaghɨn mɨkɨman kogh suam, en gumazamiziba mangɨ uan Ikiavɨra Itir Godɨn ofa damuan kogham. Bar markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Egha Moses atrivim ategha ghugha Ikiavɨra Itir God ko mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ezɨ Moses an azarazɨ moghɨra, Ikiavɨra Itir God ami. Ezɨ bereziba atrivimɨn ingangarir gumaziba ko an gumazamiziba, bar me ategha ghuezɨ, tam ua bar itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ezɨ dughiar kam atrivimɨn navim ua gavgavizɨ, a gumazamiziba ateghtɨ me mangan an aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ mangɨva atrivim kamaghɨn a mɨkɨm suam, ‘Ikiavɨra Itir God, a Hibruian God, a ghaze: Nɨ nan gumazamiziba ateghtɨ me mangɨ nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Egh nɨ men anogoregh ua me amangan aghuaghtɨ, kɨ pazɨ nɨ damuva, arɨmariar kuram nɨn asɨzibar amadagham. Eghtɨ nɨn hoziaba, donkiba, kamelba, bulmakauba, sipsipba, ko memeba a inigham. ");
INSERT INTO msy2020_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kɨrara Ikiavɨra Itir God, kɨ Israelian asɨziba ko Isipian asɨziba tuiraghtɨ Israelian asɨzitam aremeghan kogham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ezɨ Ikiavɨra Itir God dughiam dɨbora ghaze, “Kɨ gurumɨn arazir kam damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ezɨ amɨnim tirazɨma, Ikiavɨra Itir God mɨkemezɨ moghɨn ami, ezɨ Isipian asɨziba ariaghirezɨ, Israelian asɨzitam aremezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ezɨ atrivim uan gumazir maba amadagha men azara, “Israelian asɨziba deragha iti, o puvatɨ?” Ezɨ gumazir kaba uamategha kamaghɨn a mɨgei, “Are, da bar deraghvɨra iti. Tam aremezir puvatɨ.” Ezɨ an navim ua gavgavizɨ, a gumazamiziba ateghtɨ me mangan an aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Egha Ikiavɨra Itir God Moses ko Aron mɨgɨa ghaze, “Gua brighba tuer dɨpenimɨn mangɨ, egh uan dafarimningɨn averenir taba inighɨva, atrivimɨn bighan mangɨva, Moses atrivimɨn damazimɨn averenir kaba akunightɨ, da pɨn mavanang. ");
INSERT INTO msy2020_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Egh averenir kaba iregh mɨnezir muziaribar otivigh mɨghɨ Isipɨn nguazim bar anevaragham. Egh da gumazamiziba ko asɨzibagh ireghtɨ, okaba men mɨkarzibar otivigh bɨghiregh duar ekiabar otivigham.” ");
INSERT INTO msy2020_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Egha aning avereniba inigha ghua atrivimɨn damazimɨn tugha, Moses pɨn avereniba kuni. Ezɨ avereniba okabagh amizɨ, da otivigha, bɨaghirezɨ duar ekiaba gumazamiziba ko asɨzibar otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ezɨ Isipian gumazamiziba bar moghɨra, okaba me batifi, ezɨ imezibagh amir gumaziba uakan. Kamaghɨn amizɨma, me Mosesɨn damazimɨn izan ibura. ");
INSERT INTO msy2020_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ezɨ Ikiavɨra Itir God mɨkemezɨ moghɨn, an atrivim gamizɨ, an navim gavgafi, ezɨ a Moses ko Aron baraghan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Egha Ikiavɨra Itir God gɨn ua Moses kamaghɨn a mɨgei, “Nɨ gurum mɨzaraghara dɨkavigh mangɨ, atrivim batogh kamaghɨn a mɨkɨm, ‘Hibruian God, a Ikiavɨra Itir God, a ghaze, “Nɨ nan gumazamiziba ateghtɨ me mangɨva, nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Puvatɨghtɨ nɨrara, kɨ datɨrɨghɨn ivezir kuram nɨ danɨng, egh nɨn ingangarir gumaziba ko nɨn gumazamiziba uaghan me damuam. Eghtɨ nɨ fogh suam, nguaziba bar nan mɨn godɨn tam o gumazitam ua itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kɨ faragha uan gavgavimɨn paza nɨ gamua, nɨ gasɨghasighai, egh arɨmariar kuram nɨ ko nɨn gumazamiziba gasɨghasɨghizɨ, ia ti bar geveghai. ");
INSERT INTO msy2020_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kɨ kamaghsua ifonge, kɨ uan gavgavim isɨ ian akagham, eghtɨ nguazir kamɨn danganiba bar, dar gumazamiziba nan ziar ekiam geghanam. Kamaghɨn amizɨ, kɨ ia ataghizɨ ia ikiavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Egha nɨ uabɨ uan ziam favɨra ikia nan gumazamiziba dɨkabɨragha, mangasa men amamangarɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Nɨ oragh. Gurumɨn dughiar kamra, kɨ maburan amozir ofɨzir dagɨabar mɨn garibar amightɨ da izighiram. Fomɨra fomɨra Isipɨn kantri nguibar igiamɨn ikegha iza datɨrɨkɨn, me amozir ofɨzir ekiar dagɨar kabar mɨn gari tamɨn ganizir puvatɨ. Amozir ofɨzir kaba bar ikuvigh, faragha izezir amozir ofɨziba, bar dagh afiragham. ");
INSERT INTO msy2020_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ezɨ datɨrɨghɨn nɨ gumazamiziba mɨgɨrɨgɨar gavgavim me mɨkɨm suam, me uan bulmakauba ko bizir azenan itiba inigh dɨpenibar aven dar arɨgh. Eghtɨ kɨ amozir ofɨzir ekiar dagɨabar mɨn gariba amightɨ, da irɨva, gumazamiziba ko asɨzir azenan ikiavɨra itibagh irɨtɨ, da arɨmɨghiram.” ’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ezɨ atrivimɨn ingangarir gumazir maba, Ikiavɨra Itir Godɨn mɨgɨrɨgɨam baregha atiatigha, me uan ingangarir gumazir kɨniba ko asɨziba inigha dɨpenibar aven ada arɨki. ");
INSERT INTO msy2020_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ezɨ marazi Ikiavɨra Itir Godɨn mɨgɨrɨgɨar gavgavim baraghan aghuagha, uan ingangarir gumazir kɨniba ko asɨziba ataghizɨ da azenan iti. ");
INSERT INTO msy2020_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ezɨ Ikiavɨra Itir God datɨrɨkɨn kamaghɨn Moses mɨgei, “Nɨ uan dafarim ghufegh overiamɨn amadaghtɨ, amozir ofɨzir ekiar dagɨabar mɨn gariba izɨ, bar Isipɨn nguazim ko, gumazamiziba, asɨziba, ko azenibar aghuir dagheba sara, dagh izam.” ");
INSERT INTO msy2020_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Egha Moses uan asadivir aghorim ghufegha overiamɨn amadazɨ, Ikiavɨra Itir God overiam gamizɨ, ararim dagarvaghavɨra iti, ezɨ onɨmarim taghtagha ghua nguazimɨn izaghira nguazim gasavɨra itima, amozir ofɨzir ekiar dagɨabar mɨn gariba ira Isipɨn nguazimɨn bar a girava a mɨsosi. Ikiavɨra Itir God bizir kurar kaba amadi. ");
INSERT INTO msy2020_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ezɨ amozir ofɨzir ekiar dagɨabar mɨn gariba bar osemegha izavɨra itima, onɨmarim avimɨn mɨn isia, amozir dagɨabar mɨn garibar tongɨn taghtagha tintinibar danganibar zui. Ezɨ fomɨra fomɨra Isip kantrin otozir dughiamra ikegha iza datɨrɨkɨn, an amozir kurar katamɨn ganizir puvatɨ. Bar puvatɨ. Amozir ofɨzir kaba bar ikuvigha, faragha izezir amozir ofɨziba bar dagh afira. ");
INSERT INTO msy2020_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ezɨ amozir ofɨzir ekiar dagɨabar mɨn gariba, Isipɨn nguaziba ko gumazamiziba, asɨziba, ko dɨpenibar azenan itir biziba bar dagh ira dagh asɨghasɨki. Egha men obariba, ko temer gumazamiziba ovɨziba iniasa opariziba, a vaghvagha da apɨragharɨki. ");
INSERT INTO msy2020_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosenɨn Distrighɨn itir danganir Israelia itir kamra, amozir ofɨzir ekiar dagɨabar mɨn gariba, a gizezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Egha atrivim Moses ko Aron bagha akam amadazɨ aning izezɨ, a ghaze, “Dughiar kam kɨ arazir kuram gami. Ikiavɨra Itir God arazir aghuibaram ami, ezɨ kɨ uan gumazamiziba ko e arazir kuram gami. ");
INSERT INTO msy2020_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ararir kurar dagarvazir kaba, ko amozir ofɨzir ekiar dagɨabar mɨn garir kaba e bar dar amɨra. Kamaghɨn amizɨ, nɨ Ikiavɨra Itir God mɨkɨm! Eghtɨ kɨ ian amamangatɨghtɨ, ia mangam. Ia ua kagh ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ezɨ Moses kamaghɨn a mɨgei, “Kɨ nguibar ekiar kam ategh, egh dughiar kamra kɨ uan dafarimning fegh, Ikiavɨra Itir God ko mɨkɨmam. Eghtɨ arariba ko amozir ofɨzir ekiar dagɨabar mɨn gariba gɨvagham. Eghtɨ nɨ fogh suam, nguazir kam, a Ikiavɨra Itir Godɨn bizim. ");
INSERT INTO msy2020_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ezɨ kɨ fo, nɨ ko nɨn ingangarir gumaziba Ikiavɨra Itir Godɨn Gavgavim, an atiatir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","32","Ezɨ temer otevir me dar inibar tretbar ingariba, ko baliba bar ikufi. Dughiar kam baliba aghoramin dughiam, ezɨ temer kabar akɨmariba mɨsevegha moneghavɨra iti. Ezɨ witba biabara ikia kamaghɨn, da deraghavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moses atrivim ategha, nguibar ekiamɨn azenan ghugha, dafarimning fegha, Ikiavɨra Itir God ko mɨgei. Ezɨ arariba ko amozir ofɨzir ekiar dagɨabar mɨn gariba gɨvazɨ, amozim ua izir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ezɨ atrivim garima arariba ko amozir ofɨzir ekiar dagɨabar mɨn gariba gɨfa. Ezɨ a uan ingangarir gumaziba ko, men naviba gavgavizɨ, me uam arazir kuram gami. ");
INSERT INTO msy2020_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Bar guizbangɨra, Ikiavɨra Itir God faragha Moses mɨkemezɨ moghɨn, atrivimɨn navim gavgavizɨ, a Israelia ateghtɨ me mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Egha Ikiavɨra Itir God ua Moses mɨgei, “Nɨ mangɨ atrivimɨn gan. Kɨ kamaghsua ifonge, kɨ ua dɨgavir kuram gamir arazaraziba Isipian tongɨn dar amuam. Kamaghɨn kɨ atrivim ko an ingangarir gumaziba, me gamizɨma, men naviba gavgafi. ");
INSERT INTO msy2020_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Kɨ kamaghɨn ifonge, ia gɨn uan boriba ko igiar boriba, me mɨkɨm suam, kɨ dɨgavir kuram gamir arazarazir kabagh amigha, tuavir kamɨn kɨ Isipia gamizɨma, me bar onganigha aghumsɨki. Kɨ kamaghɨn damightɨ, ia bar fogh suam, kɨ uabɨ kɨ Ikiavɨra Itir God.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Egha Moses ko Aron atrivimɨn bighan ghugha, a mɨgɨa ghaze, “Ikiavɨra Itir God, a Hibruian God, a ghaze, ‘Dughiar ruarimɨn iza datɨrɨkɨn, nɨ nan akam batoke. Nɨ uabɨ abɨragh nan apengan izan aghua, a? Nɨ nan gumazamizibar amamangatɨghtɨ me mangɨ, nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nɨ men amamangarɨghan aghuaghtɨ, gurumzaraghan kɨ odeziba amadaghtɨ, da nɨn kantri gizɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Egh da bar avɨrasemegh, bar nguazim avaraghtɨ, nɨ nguazimɨn ganan kogham. Da bizir, amozir ofɨzir ekiar dagɨabar mɨn gariba, asɨghasɨghizir puvatɨziba bar da amegham. Me dagheba ko temer ian azenibar itiba sara, bar dar amɨ da gɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Egh da nɨn dɨpenir ekiaba ko nɨn ingangarir gumazibar dɨpeniba ko nɨn gumazamizibar dɨpeniba bar dagh izɨvagham. Nɨn afeziaba ko inaziba, bizir kurar katam, fomɨra iza datɨrɨghɨn, an ganizir puvatɨ, bizir kam bar ikuvigham.’ ” Egha Moses atrivim mɨkemegha ua ragha azenan ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ezɨ atrivimɨn ingangarir gumaziba kamaghɨn a mɨgei, “Dughiar ruarimɨn ikegha iza datɨrɨghɨn otogha, nɨ ua manmaghɨn dughiaba gumazir kam ateghtɨ an e gifarɨva osɨmtɨziba e danɨngam a? Nɨ Israelian gumazamiziba ateghtɨ me mangɨ, egh uan Ikiavɨra Itir Godɨn ziam fam. Nɨ ti gara fos ti? Isip bar ikufi.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ezɨ gumazir maba ghua ua Moses ko Aron inigha atrivim bagha ize. Ezɨ an aning mɨgei, “Ia mangɨ, Ikiavɨra Itir God ian God, an ziam fɨ. Kɨ foghasa, terara mangam?” ");
INSERT INTO msy2020_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ezɨ Moses a ikaragha ghaze, “E bar mangam, en boriba ko en gumazamizir ghuriba, en otariba ko guiviba, en sipsipba bar, memeba bar, ko bulmakauba bar. Guizbangɨra, e isar ekiam damuva, Ikiavɨra Itir Godɨn ziam fam.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ezɨ atrivim, Ikiavɨra Itir Godɨn ziam dɨbora akar gavgavim pamtemɨn mɨgɨa ghaze, “Kɨ ia ateghtɨ ia uan amiziba ko boriba inigh mangan kogham! Bar puvatɨgham! Kɨ kamaghɨn fo, ia arazir kuramɨn e damuasa. ");
INSERT INTO msy2020_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Bar puvatɨgham! Gumazibara mangɨ Ikiavɨra Itir Godɨn ziam fam. Ia guizbangɨra kamaghsua ifonge.” Atrivim kamaghɨn mɨkemezɨ, an ingangarir gumaziba aning batoke. ");
INSERT INTO msy2020_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ uan dafarim ghufegh Isipɨn nguazim gisɨn anemadaghtɨ, odeziba izɨ. Egh da izɨva, bizir amozir ofɨzir ekiar dagɨabar mɨn gariba mɨsoghezir puvatɨziba, odeziba izɨ bar dar amegham.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Egha Moses uan asadivir aghorim ghufegha Isipɨn kantri gisɨn anemada. Ezɨ Ikiavɨra Itir God amɨnim gamizɨma, an aruem anadi naghɨn ikegha iza, nguazim gisɨn vavɨra ikia ghua aruem ko dɨmagarim, ghua gɨfa. Ezɨ amɨnim tirazɨma, me garima, odeziba otivigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Egha odeziba bar avɨrasemegha iza Isipɨn danganiba bar da avara. Ezɨ fomɨra Isipia kamaghɨn odezir avɨrir okoruar kamaghɨn garir tabar ganizir puvatɨ, egh me gɨn ua dar ganighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Odeziba nguazim bar anevarazɨ, nguazim bar pɨghizɨ, da amozir dagɨaba faragha irava asɨghasɨghizir puvatɨzir biziba ko, azenibar otivir biziba ko iter ovɨziba, odeziba bar da ame. Ezɨ temer dafarir gariba ko graziba ua Isipɨn kantri itir puvatɨ. Da bar gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ezɨ atrivim zuamɨra Moses ko Aron bagha akam amadazɨ, aning izezɨ, an aning mɨgei, “Kɨ arazir kuram Ikiavɨra Itir God, ian God a gami, egha uaghan gua gami. ");
INSERT INTO msy2020_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kɨ kamaghɨn ifonge, gua dughiar kamra ua nan arazir kuram gɨn amadagh. Ezɨ Ikiavɨra Itir God, guan God, gua a ko mɨkemeghtɨ, a bizir kurar na gasɨghasɨghasava amir kam na dama a inigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ezɨ aning atrivim ategha ghua, Moses Ikiavɨra Itir God ko mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ezɨ Ikiavɨra Itir God amɨnim giragha a gamizɨ, aruem ghuaghiri naghɨn amɨnir gavgavim otogha, odezibagh ivaragha Ongarir Aghevimɨn amadaghan ghu. Ezɨ odezitam ua Isipɨn itir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ezɨ Ikiavɨra Itir God uam atrivim gamizɨ, an navim gavgavizɨ, a Israelia ateghtɨ me mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ezɨ gɨn Ikiavɨra Itir God ua Moses mɨgɨa ghaze, “Nɨ uan dafarim ghufegh overiamɨn amadaghtɨ, mɨtarmer ekiam izɨ Isipɨn nguazim avaragh. Guizbangɨra, mɨtarmer kam an ganganim bar ighara. Nɨ an suighsɨ an suiragham, a bizir mamɨn mɨn mɨtemegha osemegha gavgafi.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ezɨ Moses uan dafarim ghufegha overiamɨn amadazɨ, mɨtarmer bar ekiam Isip avaragha ghua dughiar 3plan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Ezɨ Isipian gumazamiziba uarir ganan ibura, egha dughiar kamɨn tav uan dɨpenim ataghizir puvatɨ. Ezɨ Israelia iti naghɨn mɨtarmeba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ezɨ atrivim ua Mosesɨn diazɨ, a izezɨ, an a mɨgei, “Ia mangɨ, Ikiavɨra Itir Godɨn ziam fɨ. Ian amiziba ko boriba ia ko mangam. Eghtɨ ian bulmakauba, ko sipsipba Isipɨn ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ezɨ Moses kamaghɨn an akam ikaragha ghaze, “Puvatɨ. E kamaghsua, nɨ e ateghtɨ e asɨzitaba inigh, dav suegh, da tueghtɨ da bar isi mɨghɨrigham. Egh arazir kamɨn Ikiavɨra Itir God, en God, e an ofa damuam. Kamaghɨn, nɨ en amamangatɨghtɨ, e asɨziba inigh mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","E bar uan asɨziba inigh da sara mangam. E mangɨ ofa damuamin dakozimɨn otivigh, Ikiavɨra Itir God, a en God, e a bagh ofa damusɨ tabav sogham. Kamaghɨn, e uan asɨzitam ateghtɨ a ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ezɨ Ikiavɨra Itir God atrivimɨn navim gamizɨ, a bar gavgavigha, men amamangatɨghtɨ me mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ezɨ atrivim Moses mɨgɨa ghaze, “Nɨ na gitagh! Kɨ ua nɨn ganan aghua. Nɨ kamaghɨn fogh, nɨ ua izɨ na batoghtɨ, dughiar kamra kɨ nɨ mɨsueghtɨ nɨ aremegham.” ");
INSERT INTO msy2020_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ezɨ Moses oregha ghaze, “A dera, kɨ nɨ mɨgei moghɨra damuam. Kɨ ua izɨ nɨn ganan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ezɨ Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, “Kɨ ua ivezir kurar abuananam Isipian atrivim ko an gumazamizibar anɨngam. Eghtɨ ivezir kurar kam otoghtɨ, a ia amadaghtɨ ia mangam. Egh a navir amɨrizim sara ian amamatɨghan kogham. Puvatɨgham. A zuamɨra navir kuram sara nguibar kamɨn ia batueghtɨ ia bar mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nɨ datɨrɨghɨn Israelian gumazamizibav kemeghtɨ, men gumaziba ko amiziba vaghvagh mangɨ, Isipɨn men boroghɨn tibar bighan mangɨ, men azangsɨghtɨ, me kuritir bizir aghuir me gol ko, silvan ingariziba ko, bizir golɨn ingarizir igharaziba sara me danɨng.” ");
INSERT INTO msy2020_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Me kamaghɨn amima, Ikiavɨra Itir God Isipian damazimɨn ziar ekiam me ganɨdima, me golba ko silvaba Israelia ganɨngi. Guizbangɨra, Isipɨn atrivimɨn ingangarir gumaziba ko an gumazamiziba, Mosesɨn gara ghaze, a gumazir ziar ekiam itim. Kamaghɨn amizɨma, me arazir kam gami. ");
INSERT INTO msy2020_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ezɨ Moses kamaghɨn atrivim mɨgei, “Nɨ Ikiavɨra Itir Godɨn akam barakigh, ‘Kɨ dɨmagarir arɨzimɨn Isipɨn danganiba bar dar aruam. ");
INSERT INTO msy2020_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Eghtɨ Isipian otarir ivariaba vaghvagh arɨmɨghiram. Atrivim, nɨn otarir ivariar nɨn danganim inigh atrivim ikiamim, faragha aremegham. Eghtɨ otarir ivariaba bar arɨghirɨ mangɨ, ingangarir amizir kɨnir wit mɨrmɨriba, men otarir ivariaba uaghan arɨghiram. Eghtɨ bulmakaun apurir faragha otoziba, uaghan bar arɨghiram. Isipian otarir ivariaba bar aremegham. ");
INSERT INTO msy2020_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Eghtɨ Isipian gumazamiziba bar naviba osemegh, pamten azi ararer ekiam damuam. Fomɨra ararer ekiar kamagh garitam Isipɨn otozir puvatɨ, egh tam gɨn uam kamagh otivan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Eghtɨ kɨ arazir kuratamɨn Israelian gumazamiziba ko men asɨzibar amighan koghtɨ, me bar nɨmɨra ikɨtɨ, men tongɨn afiatam gumazitam ko asɨzitam dapuran koghtɨ nɨ fogh suam, Ikiavɨra Itir God, a Isipia ko Israelia tuisigha, arazir kurar a Isipia gamizimɨn mɨn, a Israelia damighan kogham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Egha Moses kamaghɨn a mɨgei, “Atrivim, nɨn ingangarir gumaziba bar na bagh izɨ nan guamɨn tevibar pɨrɨva, pamten kamaghɨn mɨkɨmam, nɨ mangɨ uan gumazamiziba sara inigh mangɨ. Eghtɨ kɨ mangam. Arazir kaba otivightɨ, kɨ gɨn Isip ategham.” Egha Moses navim isia anɨngagha atrivim ategha azenan ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ikiavɨra Itir God faragha kamaghɨn Moses mɨgei, “Atrivim nɨn akam bareghan kogham. Kamaghɨn, kɨ ua Isipɨn dɨgavir kuram gamir arazir avɨritabar amuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ezɨ Moses ko Aron atrivimɨn damazimɨn dɨgavir kuram gamir arazir avɨribagh ami. Ezɨ God atrivimɨn navim gamizɨ a gavgavigh Israelia ateghtɨ, me an kantri ategh mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ezɨ Moses ko Aron Isipɨn kantrin ikiavɨra itima, Ikiavɨra Itir God kamaghɨn aning mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Iakɨnir kam, a ian azenibar faragha zuir iakɨnimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nɨ Israelian gumazamiziba kamaghɨn me mɨkɨm, iakɨnir kamɨn aruer namba 10, gumazamiziba bar vaghvagh uan adarazi bagh sipsipɨn igiatam ko memen igiatam, amɨsefegh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Egh dɨpenir vamɨran itir adarasi avɨrasemeghan koghɨva, me uarir boroghɨn itir daraziv mɨkemeghtɨ, me izɨ asɨzir kam tuiragh uari danɨng aneremɨ. Me deraghvɨra nɨghnigh, asɨzir kam deragh gumaziba ko, amiziba ko, boribar tuiraghtɨ, me asɨzir tuzir kam agɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Egh nɨ ua bagh vaghvagh sipsipɨn apuritam o memen apuritam amɨseveghtɨ, an azenir vamɨra ikɨtɨ, duatam an mɨkarzimɨn ikian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Egh me asɨzir kaba uari bagh deraghvɨra dar gan mangɨ iakɨnir kamɨn aruer 14ɨn otogh. Eghtɨ dughiar kamra, an guaratɨzimɨn, Israelian gumazamiziba bar uan asɨzir kabav sueghtɨ, da arɨghiregh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Egh me asɨzimɨn ghuzitaba inigh, uan dɨpenimɨn tiar akabar mɨriabagh asezir tememning daghuigh, dɨpenir kamɨn aven me ikɨ asɨzibar amam. Egh uaghan tiar akam gisɨn itir ter ighuvim aghefegh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Egh dɨmagarir kamɨn me sipsip o memen tuzim avimɨn a tuagh, egh ia asɨzir tuzir kam yis puvatɨzir bret ko zuravarir mɨsozim sara aneremɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Egh ia asɨzir tuzir angamtɨzim, ko tuzir mɨnemɨn avighizitam aman markɨ. Ia avimɨn dar dapaniba, ko sueba ko dafariba, ko navir averimɨn itir biziba sara, ia bar da tuegh, dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Egh ia asɨzir otevitaba ateghtɨ da ikɨ amɨmzaraghan ikian markɨ. Da ikɨtɨ amɨnim tiraghtɨ, ia dar naba tueghtɨ da bar isi mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Egh ia asɨzir kabar amɨsɨ kamaghɨn damu. Ia iniba ikegh dagarir asuabar aghuigh, asadivir aghoribar suigh zuamɨra dar amɨ. Isar ekiar kam, a Ikiavɨra Itir God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Eghtɨ dɨmagarir kamra, kɨ Isipɨn danganiba bar dar mangɨ, gumazamizibar otarir ivariaba ko asɨzibar apurir ivariaba, kɨ dav soghtɨ me bar arɨmɨghiregham. Eghtɨ Isipɨn aseba bar, kɨ ivezir kuraba me danɨngam. Guizbangɨra, kɨ uabɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ghuzir ia uan dɨpeniba aghevezir kaba, da ababanimɨn mɨn ikiam. Eghtɨ kɨ Isipian gumazamiziba pazɨ me damuva ivezir kuram me danɨngam. Kɨ ghuzimɨn ganigh, ian dɨpenibagh itagham. Egh kɨ ia ateghtɨ, ivezir kurar kam ia batoghan kogham. Eghtɨ ia deraghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Eghtɨ ia dughiar kam gɨnɨghnɨghavɨra ikɨtɨ, a ian dughiar ekiamɨn mɨn ikiam. Kɨ dughiar kam ginabaghtɨ, a nan ziam feir isar ekiamɨn mɨn ikiam. Eghtɨ ia Ikiavɨra Itir God amir arazir kam gɨnɨghnɨgham. Eghtɨ ian gɨn otivamin adarasi, bizir a damuasa ia mɨkemezimɨn gɨn mangɨ Ikiavɨra Itir God bagh isar kam damuvɨra ikɨtɨ, a ikɨ mamaghɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia faraghɨvɨra uan dɨpenibar yisba batokegh. Egh ia 7plan dughiabar, yis puvatɨzir bret amɨ. Gumazitam 7plan dughiar kabar aven, dar dughiatam yis itir bret ameghtɨ, ia Israelian gumazamizibar tongɨn a batokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Egh faragha zuir dughiam ko namba 7ɨn dughiam, ia uari akuvagh Godɨn ziam fer arazim damu. Egh ia ingangarir igharazibar amuan markɨ. Ia uari bagh daghebara tu. ");
INSERT INTO msy2020_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ezɨ 7plan dughiabar faragha zuir dughiamra, kɨ ian anababa Isipɨn kantrin me inigha azenan ghu. Ezɨ azeniba bar dughiar ekiar kamɨn, kar Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam, dughiar kam, a bizir kam gɨnɨghnɨghamin dughiamɨn mɨn ikiam. Eghtɨ ian gɨn otivamin adarasi, bizir a damuasa ia mɨkemezimɨn gɨn mangɨ, Ikiavɨra Itir God bagh isar kam damuvɨra ikɨtɨ, a ikɨ mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","“Egh ia iakɨnir faragha zuiba bar, dar dughiar 14ɨn guaratɨzibar, yis puvatɨzir bret amɨ mangɨ, egh dughiar 21ɨn otogh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Egh 7plan dughiar kabar aven, yis ian dɨpenibar ikian markɨ. Eghtɨ ian gumazitam, o kantrin igharazimɨn gumazir ia ko ititam, a yis itir bret ameghtɨ, ia Israelian gumazamizibar tongɨn a batokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ia oragh. Ia tintinimɨn managh iti, ia yis itir bret raman markɨ. Ia yis puvatɨzir bret amɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Egha Moses Israelian gumazir dapanibar diazɨ me izezɨ, a kamaghɨn me mɨgei, “Ia vaghvagh mangɨ sipsipɨn igiatam o memen igiatam amɨsefegh, uan adarazi bagh dav suegh, God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isam damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Egh ia ghuzim itarir ekiam gingegh, hisopɨn ter aguar muziaritam inigh, a isɨ ghuzim itir itarir ekiam darugh. Egh ghuzir muziarim inigh uan dɨpenibar tiar akabar mɨriamɨn tughav itir tememning daghuigh, egh tiar akam gisɨn itir ter ighuvim aghefegh. Egh ia bar dɨpenimɨn aven ikɨ, tav azenan mangan markɨ mangɨ, mɨzarazimɨn otogh. ");
INSERT INTO msy2020_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Gɨn Ikiavɨra Itir God, Isipian otarir ivariabav sueghtɨ me arɨmɨghirɨsɨ Isipɨn danganiba bar dar mangam. A ian tiar akabar ghuzimɨn ganigh, ia ateghtɨ gumazibagh asɨghasɨghamin ensel aven mangɨ ian otarir ivariabav sueghtɨ, me arɨmɨghireghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Eghtɨ ia uan boriba ko, bizir a damuasa e mɨkemeziba zurara azenibar dar amuvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ia mangɨ nguazir Ikiavɨra Itir God ia danɨngasa mɨkemegha, akar dɨkɨrɨzim gamizimɨn dapiaghɨva, God Israelia Gitazir Dughiam gɨnɨghnɨghɨva isar kam damu. ");
INSERT INTO msy2020_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Eghtɨ gɨn ian boriba kamaghɨn ian azangsɨgham, ‘Kar manmaghɨn amizir isar kam?’ ");
INSERT INTO msy2020_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Eghtɨ ia kamaghɨn me mɨkɨmam, ‘Isar kam, e Ikiavɨra Itir Godɨn ofa gamua, God Israelia Gitazir Dughiam gɨnɨghnɨsi. A fomɨra Isipian otarir ivariabav soghezɨ me ariaghire. Egha a Israelia en dɨpeniba gitavɨragha, en otarir ivariaba ataghizɨ me deravɨra iti. Ezɨ e datɨrɨghɨn dughiar kam gɨnɨghnɨsi.’ ” Ezɨ gumazamiziba akar kam baregha dapaniba avigha Godɨn ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Egha me gɨn dɨkavigha ghua Ikiavɨra Itir God damuasa Moses ko Aron mɨkemezir biziba, me dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ezɨ dɨmagarir arɨzimɨn Ikiavɨra Itir God, Isipian otarir ivariabav suagharɨsi. A faragha atrivimɨn otarir ivariam mɨsuegha, ghua otarir ivariar igharazibav sogha ghuavɨra ikia ghua kalabuziar gumazibar, otarir ivariaba sara mɨsoke. Egha uaghan bulmakaubar apurir ivariabav soke. ");
INSERT INTO msy2020_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ezɨ dɨmagarir kamra, atrivim ko, an ingangarir gumaziba, ko Isipia bar dɨkavigha garima, men otarir ivariaba ariaghiregha gɨfa. Men dɨpeniba bar moghɨra vaghvagha, men otarir ivariaba ariaghire. Kamaghɨn amizɨ, Isipɨn danganiba bar, gumazamiziba azirakar ekiam gami. ");
INSERT INTO msy2020_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ezɨ dɨmagarir kamra atrivim Moses ko Aronɨn diagha kamaghɨn mɨgei, “Ia bar dɨkavigh mangɨ. Gua ko Israelian gumazamiziba bar, ia zuamɨra mangɨ, nan gumazamizibagh itagh. Ia mangɨ, ia nan azarazɨ moghɨn, mangɨ Ikiavɨra Itir Godɨn ziam fɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Egh ia uan sipsipba, memeba, bulmakauba inigh, ia nan azarazɨ moghɨn, da inigh bar Isip ategh mangɨ. Egh na bagh God ko mɨkɨmtɨ, a deragh na damu.” ");
INSERT INTO msy2020_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ezɨ Isipia Israelian gumazamizibar avɨgha ghaze, “Ia zuamɨram Isip ategh mangɨ. Ia zuamɨra e gitaghan koghtɨ, e bar arɨmɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ezɨ Israelia plauan me tɨghar yis sara vereghamiba, da inigha, itarir ekiabagh arɨki. Egha me itarir ekiaba inibar da noegha, dɨpɨzibar da atera zui. ");
INSERT INTO msy2020_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israelia Moses mɨkemezɨ moghɨn, me Isipia bagha ghua kuritir bizir aghuir me gol ko, silvan ingariziba ko, korotiaba bagha uaghan men azai. ");
INSERT INTO msy2020_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ezɨ Ikiavɨra Itir God Isipian damazimɨn ziar ekiam Israelia ganɨdi. Ezɨ Isipia bizir Israelia ifongeziba me ganɨdi. Ezɨ tuavir kamɨn Israelia, Isipian bizir aghuiba, puram ada inigha ghue. ");
INSERT INTO msy2020_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israelian gumazamiziba dɨkavigha Ramesesɨn nguibam ategha ghua nguibar ekiam Sukotɨn danganimɨn zui. Gumazir 600,000plan, uan suebar arua zuir kaba, me gumazibara. Me amiziba ko boriba mengezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ezɨ gumazamizir igharazir avɨrir maba, ko bulmakauba, sipsipba ko memen avɨrir maba uaghan me ko zui. ");
INSERT INTO msy2020_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Me tuavimɨn ghua Isipɨn inizir plaua yis puvatɨzimɨn bret tue. Isipian gumaziba men avɨghavɨra iti, me dagheba akɨramin dughiaba puvatɨ. Kamaghɨn, me yis isa plaua gatɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israelia 430plan azenibar Isipɨn kantrin ike. ");
INSERT INTO msy2020_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ezɨ aruer kamra, men 430plan azenimɨn aruer abuananam, Ikiavɨra Itir Godɨn gumazamiziba Isip ategha azenan zui. ");
INSERT INTO msy2020_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ezɨ dɨmagarir kamra Ikiavɨra Itir God Israelia deraghvɨra men gara, egha Isipɨn kantrin me inigha azenan ize. Egh zurara azenir gɨn izamibar, men gɨn otivighamin adarasi, me dɨmagarir kamra angamɨra ikɨ ganɨva, Ikiavɨra Itir God gɨnɨghnɨghɨva, an ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ikiavɨra Itir God kamaghɨn Moses ko Aron mɨgei, “Ia God Israelia Gitazir Dughiamɨn isamɨn arazibagh nɨghnɨgh kamaghɨn damu. Kantrin Igharazibar Gumazamiziba, isar kamɨn daghetamra aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","45","Eghtɨ gumazir dughiar otevimɨn ia ko itiba, ko gumazir dagɨaba bagha ingara itiba, me isar kamɨn daghetam aman kogham. Ezɨ gumazir ia ivezezɨ me ingangarir gumazir kɨnibar mɨn itima, ia men mɨkarzir mogomebar inibar aghore, merara uaghan ia ko isar kamɨn daghetam amam. ");
INSERT INTO msy2020_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Egh gumazamiziba, dɨpenir me aven ikia asɨziba tuezim, me dɨpenir kamɨn averara ikɨ, egh asɨzir tuzibar amɨ. Me daghetaba inigh azenan mangan markɨ. Egh uaghan me asɨzir agharibar amɨ dar pɨran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israelian gumazamiziba bar isar kamɨn aven ikɨ damɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Eghtɨ gumazir uan mɨkarzir mogomemɨn inim atuzir puvatɨzim, daman kogham. Kantri igharazimɨn gumazim iza ian kantrin aven iti, a God Israelia Gitazir Dughiamɨn isam ia ko a damusɨ, ia an mɨkarzir mogomemɨn inim atugh. Egh uaghan gumazir an ikɨzimɨn itiba sara, men mɨkarzir mogomebar iniba aghoregh. Eghtɨ a ian gumazimɨn mɨn ikɨ, ian adarazi ko damɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ezɨ arazir kabara Israelian gumazamiziba, ko gumazir kantrin igharazibar ikegha iza ia ko itiba, uaghara arazir kabar gɨn mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Ezɨ Israelia, me Ikiavɨra Itir God Moses ko Aron mɨkemezɨ moghɨrama ami. ");
INSERT INTO msy2020_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ezɨ dughiar kamra Ikiavɨra Itir God, Israelian anababar aven vaghvagha bar me inigha Isipɨn kantrin azenan ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Ia bar uan otarir ivariaba na danightɨ, me na baghvɨra ikiam. Israelia, ian otarir ivariaba, ko asɨzir apurir ivariaba, bar nana.” ");
INSERT INTO msy2020_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ezɨ Moses kamaghɨn gumazamizibav gei, “Ia faragha Isipɨn kantrin ikia, ingangarir gumazir kɨnibar mɨn itima, Ikiavɨra Itir God uan gavgavimɨn ia inigha azenan ize. Kamaghɨn amizɨ, ia zurara dughiabar, dughiar kam ko an amizir arazir kam gɨnɨghnɨgh, yis itir bret tam aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ia Isip ataghizir dughiar kamɨn faragha zuir iakɨnim, an ziam, Abip. ");
INSERT INTO msy2020_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ezɨ Ikiavɨra Itir God ian inazir afeziaba ko akam akɨrigha ghaze, a nguazim isɨ ia danɨngam. Nguazir kam, Kenania, Hitia, Amoria, Hivia ko Jebusia datɨrɨghɨn a gapiaghav iti. Nguazir kam a bar derazɨ, biziba an ikiava bar deraghavɨram aghui. Ikiavɨra Itir God ia inigh nguazir kamɨn mangɨghtɨ, gɨn izamin azenibar iakɨnir kamra, ia Yis Puvatɨzir Bretɨn Isam damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Egh ia yis puvatɨzir bret 7plan arueba anemɨ, mangɨva namba 7ɨn aruemɨn tugh. Eghtɨ namba 7ɨn aruem otoghtɨ, ia Ikiavɨra Itir Godɨn ziam fɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Egh 7plan aruer kaba, gumazamiziba yis puvatɨzir bretra damɨ. Egh ia bretɨn yis itim ko yis tam ateghtɨ, a ian nguibatamɨn aven ikian markɨ. Guizbangɨra, yis ian kantrin aven ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Eghtɨ dughiar ekiar kam otoghtɨ, ia uan otariba kamaghɨn me mɨkɨm, ‘Ikiavɨra Itir God Isipɨn kantrin aven e bagha bizir ekiabagh amigha, en adarazi inigha azenan ize. Ezɨ e datɨrɨghɨn isar ekiam gamua, bizir kaba bar dagh nɨghnɨsi.’ ");
INSERT INTO msy2020_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Guizbangɨra, Ikiavɨra Itir God uan gavgavimɨn pamtem ingara, e inigha Isipɨn kantrin azenan ize. Eghtɨ isamɨn arazir kam ian dafariba ko guabar, osizirimɨn mɨn ikɨ. Eghtɨ a ia bagh arazir an amizimɨn ababanimɨn mɨn ikɨ. Egh a ia damightɨ ia kamaghɨn nɨghnɨgh suam, e Ikiavɨra Itir Godɨn akar gavgavibar gun mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Egh azeniba bar, ia isar a damuasa mɨkemezir kam, an dughiamra a damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Egha Moses kamaghɨn mɨgei, “Ikiavɨra Itir God ia inigh Kenanian nguazimɨn mangam. A nguazir kam bagha, faragha ia ko ian ovaviba ko akam akɨri. Egh nguazir kam ia danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","A ia danigh gɨvaghtɨ, ia uan otarir ivariaba Ikiavɨra Itir God danɨngam. Eghtɨ ian asɨzir apurir ivariaba uaghan, da Godɨn anaba. ");
INSERT INTO msy2020_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ia sipsipɨn nguzir tam isɨ ofa damu, egh tuavir kamɨn ia donkin apurir ivariam givezegh ua a iniam. Ia donkin apurir ivariam givezan aghuagh, ia an gurim apɨrigh. Egh ia uan otarir ivariaba vaghvagha ua me givezegh me iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Egh gɨn izamin dughiaba ian otariba kamaghɨn ian azangsɨgh suam, ‘Kar manmaghɨn amizir arazim?’ Eghtɨ ia kamaghɨn me mɨkɨm suam, ‘E ingangarir gumazir kɨnibar mɨn Isipɨn kantrin ingara itima, Ikiavɨra Itir God uan gavgavimɨn pamten ingara, e inigha azenan ize. ");
INSERT INTO msy2020_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ezɨ faragha Isipɨn atrivimɨn navim gavgavizɨ, an e ateghtɨ e mangan an aghua. Ezɨ Ikiavɨra Itir God Isipian otarir ivariaba, ko men asɨzir apurir ivariabav soghezɨ da ariaghire. Ezɨ e datɨrɨkɨn asɨzir apurir ivariaba bar da inigha, Ikiavɨra Itir God bagha dar ofa gami. Egha e uan otarir ivariabagh ivezegha ua me ini.’ ");
INSERT INTO msy2020_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ia arazir kam damuva, Ikiavɨra Itir God gɨnɨghnɨgh suam, a uan gavgavimɨn Isipɨn kantrin e inigha azenan ize. Eghtɨ arazir kam, ian dafariba ko guabar osizirimɨn mɨn ikɨ. Egh arazir kam ia bagh, ababanimɨn mɨn ikɨva ian nɨghnɨzibar amutɨ da dɨkavam.” ");
INSERT INTO msy2020_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Atrivim Israelian gumazamiziba ataghizɨ me zuir dughiamɨn, God kamaghɨn nɨghnɨgha ghaze, “Israelia tuavir otevimɨn mangɨ igharaz darazir gantɨ, me me mɨsoghsɨ damutɨ, me uan nɨghnɨzibagh iragh, uamategh Isipɨn mangɨsɨ nɨghnɨgham. Ezɨ Israelia kamaghɨn damuan kɨ ifongezir puvatɨ.” Kamaghɨn, God tuavir otevimɨn me inigha Filistian kantrin ongarir dadarimɨn zuir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ezɨ kamaghɨn, God Israelia inigha ghuanaga gumazamiziba puvatɨzir danganimɨn ghua Ongarir Aghevimɨn oto. Egha me mɨdorozim gamir biziba inigha da sara zui. ");
INSERT INTO msy2020_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Bar fomɨra, Josep kamaghɨn Israelia mɨkeme, “Bar gɨn God Isipɨn ua ia inigh ian akurvagham. Eghtɨ dughiar kamɨn ia nan aghariba inigh da sara mangɨ.” Ezɨ Israelia akar dɨkɨrɨzim gamizɨ moghɨn, Moses Josepɨn aghariba inigha zui. ");
INSERT INTO msy2020_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Egha Israelia dɨkavigha Sukotɨn danganim ategha ghua Etamɨn nguibamɨn oto, me gumazamiziba puvatɨzir danganimɨn mɨriamɨn otoghava apia. ");
INSERT INTO msy2020_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Egha aruebar, Ikiavɨra Itir God ghuariar ruarir ekiamɨn aven ikia, men faragha ghua tuavim men akakasi. Egha dɨmagaribar ana avir mɨzariar ruarir ekiamɨn aven ikia, me gisɨrara ikia men faragha ghua angazangarim me ganɨdi. Ezɨ bizir kam bangɨn, me arueba ko dɨmagariba sara arua zui. ");
INSERT INTO msy2020_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ezɨ aruebar zurara ghuariar ruarir ekiar kam men faragha zui, egha dɨmagaribar avir mɨzariar ruarir ekiar kam men faragha zui. Aning uan danganimning ataghɨrazir puvatɨgha kamaghɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Ezɨ Ikiavɨra Itir God, kamaghɨn Moses mɨgei, “Nɨ Israelia mɨkemeghtɨ, me uamategh mangɨ ongarir mɨriamɨn Pihahirotɨn nguibamɨn dapiagh. Nguibar kam, a Mikdolɨn nguibam ko Ongarir Aghevimɨn tizimɨn ikia, Balsefonɨn nguibamɨn boroghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Eghtɨ Isipɨn atrivim men darorim gɨnɨghnɨgh, kamaghɨn mɨkɨm suam, ‘Israelia ti onganigha gumazamiziba puvatɨzir danganim puram a garuama. Me danganir kam ategh mangamin tuaviba puvatɨgham.’ ");
INSERT INTO msy2020_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kɨ atrivim damightɨ an navim gavgavightɨ, a ian agɨragham. Eghtɨ kɨ a ko an mɨdorozir gumaziba, me dɨkabɨragh me abɨragham. Egh bizir kam bangɨn kɨ ziar ekiam iniam. Eghtɨ Isipia fogh suam, Kɨrara, kɨ Ikiavɨra Itir God.” Ezɨ Israelia Ikiavɨra Itir Godɨn akam baregha, uamategha ghua Pihahirotɨn nguibamɨn boroghɨn apia. ");
INSERT INTO msy2020_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ezɨ gumazir maba Isipɨn atrivim mɨgɨa ghaze, “Israelia ara ghue.” Ezɨ a ko an ingangarir gumazibar nɨghnɨzibagh iragha ghaze, “Manmagh amizɨ, e Israelia ataghizɨ me ghue? Me datɨrɨghɨn uam en ingangaribar amuan kogham. Guizbangɨra, e pazava amigha gɨfa!” ");
INSERT INTO msy2020_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Egha me mɨkemegha gɨvagha, atrivim uan mɨdorozir karisba ko, mɨdorozir gumaziba ini. ");
INSERT INTO msy2020_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Egha uaghan a 600plan karisɨn mɨdorozim gamir aghuariba, ko Isipɨn mɨdorozir karisɨn igharaziba sara inigha, karisbar garir gumazir dapaniba inigha, me dɨkavigha Israelian gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Israelia fo, me Isipia dɨkabɨnigha me abɨnigha, bar akongegha zui. Ikiavɨra Itir God, Isipɨn atrivim gamizɨ, an navim gavgavizɨ, a zuamɨra dɨkavigha men gɨntɨghasa zui. ");
INSERT INTO msy2020_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Isipian mɨdorozir gumaziba, uan karisba ko bar zui, marazi hoziabagh apiagha zui, ezɨ marazi uan suebar ghua, bar Israelian agɨntɨgha zui. Egha me bar ghua Israelia apiagha itir danganimɨn otifi. Danganir kam, an Ongarir Aghevimɨn mɨriamɨn ikia, Pihahirotɨn boroghɨn iti, ezɨ Balsefon an akɨrangɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ezɨ Isipɨn atrivim uan mɨdorozir gumaziba ko, Israelian boroghɨn zuima, Israelia men api. Egha me bar puvɨra atiatigha, uarir akurvaghasa Ikiavɨra Itir Godɨn dei. ");
INSERT INTO msy2020_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Me kamaghɨn Moses mɨgei, “Nɨ tizim bagha e inigha gumazamiziba puvatɨzir danganir kamɨn ize? Nɨ ghaze, Isipɨn kantrin moziba okoramin danganiba puvatɨ. Kamaghɨn e ti arɨmɨghirasa, nɨ e inigha kagh ize? Nɨ manmaghɨn e gamua, e inigha Isip ategha azenan ize? ");
INSERT INTO msy2020_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","E Isip ataghɨraghasava amir dughiam, e kamaghɨn nɨ mɨkeme, ‘Arazir kurar kaba e bativam.’ E nɨ mɨgɨa ghaze, nɨ e ateghtɨ e Isipɨn ikɨva, ingangarir gumazir kɨnibar mɨn ikɨtɨ deragham. Puvatɨghtɨ, e gumazamiziba puvatɨzir danganimɨn arɨmɨghiram.” ");
INSERT INTO msy2020_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses kamaghɨn me ikaragha ghaze, “Ia atiatingan markɨ, ia tuivigh gavgafigh. Ia datɨrɨghɨn, Ikiavɨra Itir Godɨn gavgavimɨn ganightɨ, a ian akuragh ua ia inian. Ia datɨrɨkɨn Isipian gari, ia ua men ganan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ia orakigh, Ikiavɨra Itir God ian akurvaghsɨ me ko mɨsogham. Ia uari bizitam damuan markɨ. Ia nɨmɨra ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ikiavɨra Itir God, kamagh Moses mɨgei, “Nɨ tizim bagha nan ingarava aravɨra iti? Nɨ Israelia mɨkemeghtɨ, me mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Eghtɨ nɨ uan asadivir aghorim ghufegh, ongarim gisɨn amadagh. Eghtɨ ongarim bigh akuar pumuning irɨghtɨ, Israelia nguazir dakɨrtɨzimɨn mangɨ vongɨn otifigh. ");
INSERT INTO msy2020_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Eghtɨ kɨ Isipia damightɨ men naviba gavgavightɨ, me ian gɨn ongarim biaghirɨzir tuavimɨn mangam. Eghtɨ kɨ atrivim ko, an karisba ko, mɨdorozir gumazir hoziabagh apiaziba, ko mɨdorozir gumaziba bar me dɨkabɨragham. Egh kɨ me gamizir arazir kam bagh, ziar ekiam iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Kɨ Isipia dɨkabɨragh me abɨraghtɨ me fogh suam, Kɨrara, kɨ Ikiavɨra Itir God.” ");
INSERT INTO msy2020_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ezɨ Godɨn enselɨn zurara Israelian mɨdorozir gumazibar faragha zuim, a sɨvagha ghua men akɨrangɨn tu. Ezɨ ghuariar ruarir ekiar zurara men faragha zuim, a uaghan isɨvagha ghua men akɨrangɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Dɨmagarir kamɨn, ghuariar ruarir ekiar kam Israelia ko, Isipian tɨzimɨn tughav iti. Ghuariar ruarir kam Isipia itir danganim gamizɨ, a bar mɨtatangi. Egha Israelia itir danganim angazangarim a ganɨngi. Kamaghɨn, dɨmagarir kamɨn Isipia ko Israelia uarir boroghɨn mangan ibura. ");
INSERT INTO msy2020_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses uan agharim ghufegha, ongarim gisɨn anemada. Ezɨ dɨmagarimɨn Ikiavɨra Itir God, amɨnir gavgavim gamizɨ, an aruem anadi naghɨn oto. Egha dɨmagarir kamɨn amɨnim ongarim gɨva ghuavti amɨnim tira. Ezɨ ongarim tongɨra biaghirɨgha, akuar pumuningɨn irɨgha nguazir dakɨrtɨzimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Egha dɨvazimningɨn mɨn vong ko vongɨn akuvagha itima, Israelia aningɨn tongɨn nguazir dakɨrtɨzimɨn ghua vongɨn otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ezɨ Isipɨn mɨdorozir gumaziba Israelian agɨragha, men gɨn ghua ongarimɨn tongɨra ghu. Men hoziaba ko, karisba ko, gumazir hoziabagh apiziba, da bar zui. ");
INSERT INTO msy2020_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ezɨ Ikiavɨra Itir God, aviv zariamɨn mɨn ghuariar ruarir kamɨn aven iti. Ezɨ amɨnim tiasa amima, a Isipian mɨdorozir gumaziba, men nɨghnɨzibagh irazɨma, me tintinibar nɨghnɨgha atiatia arasava ami. ");
INSERT INTO msy2020_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ikiavɨra Itir God, karisbagh amizɨ, nguazim dar wilbar suighizɨ, da pamten ivemarir puvatɨ. Ezɨ Isipia uarira uariv gei, “Ia oragh, E zuamɨrama arɨ mangeka! Ikiavɨra Itir God, Israelian akuragha e mɨsosi.” ");
INSERT INTO msy2020_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ezɨ Ikiavɨra Itir God, kamagh Moses mɨgei, “Nɨ uan agharim ghufegh, ongarim gisɨn anemadaghtɨ, dɨpam ua izɨ Isipian mɨdorozir gumaziba, ko men karisba ko gumazir hoziabagh apiaziba, bar me avaragh.” ");
INSERT INTO msy2020_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ezɨ Moses agharim ghufegha ongarim gisɨn anemada. Amɨnim tirazɨma, ongarim ua iza faragha ikezɨ moghɨn uan danganimɨn iti. Dughiar kamra, Isipia arɨ mangasa amuavɨra itima, Ikiavɨra Itir God, bar me avigha ongarim mɨkɨni. ");
INSERT INTO msy2020_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ezɨ ongarim uamategha ize. Egha gumazir atrivimɨn hoziabagh apiaziba ko, mɨdorozir gumazir Israelian gɨn ongarir torimɨn ghueziba, bar me avara. Ezɨ men tav mɨseveaghɨrɨzir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ongarim dɨvazim mɨn, vong ko vongɨn akuvagha itima, Israelia nguazir dakɨrtɨzimɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Dughiar kamɨn, Ikiavɨra Itir God, Isipian dafarimɨn Israelia, ua men akura. Ezɨ Israelia, Isipian kuabar garima, da ongarir dadarimɨn ireghav iti. ");
INSERT INTO msy2020_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israelian gumazamiziba garima, Ikiavɨra Itir God, uan gavgavir ekiamɨn pamtem ingara, Isipia dɨkabɨragha me abɨra. Ezɨ me bar atiatigha, Ikiavɨra Itir God, nɨghnɨzir gavgavim an iti. Egha an ingangarir gumazim Moses, me uaghan nɨghnɨzir gavgavim an iti. ");
INSERT INTO msy2020_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Dughiar kam Moses Israelian gumazamiziba ko, Ikiavɨra Itir God bagha ighiar kam kamaghɨn a bange: “Ikiavɨra Itir God, a mɨdorozir ekiam abɨra, ezɨ kɨ datɨrɨghɨn a bagh onger akam bangam. Guizbangɨra, a hoziaba ko gumazir hoziabagh isɨn apiaziba me avigha ongarim mɨkɨni. An apaniba abɨra, ezɨ an ziam bar pɨn iti! ");
INSERT INTO msy2020_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ikiavɨra Itir God uabɨ na gamizɨma, kɨ gavgavigha, onger akam bangava an ziam fe. A zurara ua na isi, ezɨ kɨ an ziam fasa. A nan God, egha nan akurvazim. Kamaghɨn amizɨ, kɨ an ziar ekiam fasa. Nan afeziamɨn God, kɨ an ziar ekiam fɨ, a isɨ bar pɨn anerɨgh ighiam damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ikiavɨra Itir God, a bar mɨdorozir gumazir gavgavim. Ziar kam, Ikiavɨra Itir God, kar an ziam. ");
INSERT INTO msy2020_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","A Isipian mɨdorozir gumaziba ko men karisɨn mɨdorozim gamiba, a me avigha me isa ongarim mɨkɨni. Ezɨ men mɨdorozir gumazir dapaniba, ongarim amegha Ongarir Aghevimɨn aven ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ongarim bar me avarazɨma, me dagɨabar mɨn ongarir dɨkɨnim giraghue. ");
INSERT INTO msy2020_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ikiavɨra Itir God, nɨn agharir guvim bar gavgavir ekiam iti, nɨ uan apaniba dɨkaragha bar me mɨrmɨri. ");
INSERT INTO msy2020_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nɨ uan gavgavir ekiamɨn uan apaniba abɨra, egha nɨ uan navir anɨngazim avimɨn mɨn otogha men isia, mati avim grazir mɨdiaribar isi. ");
INSERT INTO msy2020_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nɨ amɨnir ekiam gamizɨ a dɨkavigha, ongarim gamizɨma, a buigha pɨn anabo. Egha voroghɨra dɨvazimɨn mɨn tughav iti. Ezɨ ongarir apebamɨn itim, bar pamtemɨn ingara gavgafi. ");
INSERT INTO msy2020_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Apaniba ghaze, ‘E men agɨntɨgh men suigham. Egh men bizir aghuariba inigh da tuisɨgh uan adarazir anɨngam. Egh e bizir manam inisɨ e puram a iniam. E sabar mɨsozim asigh, uan gavgavimɨn me gasɨghasɨgham.’ ");
INSERT INTO msy2020_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ikiavɨra Itir God, nɨ uan amɨnim dughiar vamɨran a giverazɨma, ongarim Isipia avara. Ezɨ me dagɨamɨn mɨn ongarir bar puvɨra ingarim giraghue. ");
INSERT INTO msy2020_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","O Ikiavɨra Itir God, ua godɨn manam ikia nɨn mɨn gavgafi? Tav ua itir puvatɨ. Nɨ atrivir ekiam, egha arazir aghuibaram ami. Nɨ bar pɨn kozɨ, e nɨn atiati. Tina nɨn mɨn iti? Tav ua itir puvatɨ. Nɨrara dɨgavir kuram gamir arazibagh ami, egha ingangarir ekiabagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nɨ uan agharir guvim a ghufegha anemadazɨ, nguazim akam akarigha apaniba tuavareme. ");
INSERT INTO msy2020_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nɨ bar uan gumazamiziba men apangkuvigha men akuragha me inigha, men faragha ghua me inigha zui. Nɨ uan gavgavimɨn men darorimɨn faragha ghua, danganir aghuarir nɨ uabɨ itimra, nɨ men akua a bagha zui. ");
INSERT INTO msy2020_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kantrin Igharazibar Gumazamiziba arazir nɨ amizim baregha, pamten nɨghava atiati. Ezɨ Filistiaba uaghan aguava bar puvɨrama atiati. ");
INSERT INTO msy2020_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Idomɨn kantrin faragha zuir gumazibar nɨghnɨziba, tintinibar nɨghnɨgha onganizɨ moghɨn ami. Moapɨn gumazir dapaniba puvɨra nɨghava agoi. Kenanian gumazamiziba atiatia, uan gavgavim ategha puram amɨragha uaghiri. ");
INSERT INTO msy2020_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Me nɨn gavgavir ekiamɨn gara, atiatir ekiam ko nɨrɨzir bar ekiam me avarazɨ, me pura ikia bizitam damuan ibura. Me pura dagɨabar mɨn dapiagh ikɨtɨ, e nɨn gumazamiziba me gitavɨragh mangam. O Ikiavɨra Itir God, nɨn gumazamizir nɨ me givezegha ua me iniziba, me guizbangɨra kantrin kabagh itagh bar mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Ikiavɨra Itir God, nɨ en aku mangɨtɨ, e nɨn mɨghsɨamɨn deraghvɨra dapiagham. O Ekiam, danganir kamɨn, nɨ uabɨ uan dɨpenimɨn ingaram. Dɨpenir nɨ itir kamɨn, gumazamiziba izɨ nɨn ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ikiavɨra Itir God, an atrivimɨn mɨn ikɨ mamaghɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Israelia nguazir dakɨrtɨzimɨn Ongarir Aghevimɨn tongɨn ghua otogha gɨfa. Ezɨ Isipɨn atrivimɨn mɨdorozir gumaziba ko, hoziaba ko gumazir karisbagh isɨn apiaziba, me Israelian gɨn zui. Ezɨ Ikiavɨra Itir God ongarim gamizɨ, a uamategha iza me avara. ");
INSERT INTO msy2020_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Gɨn Godɨn akam inigha izir amizim Miriam, an Aronɨn amezemebam, a buar mam uan dafarimɨn an suira. Amiziba bar moghɨra uan buaba inigha, Miriamɨn gɨn zui. Egha me buabav sogha onger akabagh amua ighiam gizi. ");
INSERT INTO msy2020_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam me bagha kamaghɨn ighiam bange: “Ikiavɨra Itir God gumazir hoziabagh apiaziba, ko hoziaba sara bar me avigha ongarim mɨkɨnigha, apaniba abɨnigha ziar ekiam ini. Kamaghɨn, ia a bagh onger akam bangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ezɨ gɨn Moses Israelian akua Ongarir Aghevim ategha, Surɨn gumazamiziba puvatɨzir danganimɨn zui. Me gumazamiziba puvatɨzir danganim, aruer 3plan an arua ghua, dɨpatamɨn apizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Egha me gɨn ghua Maran danganimɨn otivigha dɨpar mam bato. Dɨpar kam akatorimɨn aven mɨsosi, ezɨ me anereman ibura. Dɨpar kamɨn ziam, Mara, an mɨngarim, bizim akamɨn aven anɨnganigha mɨsosi. ");
INSERT INTO msy2020_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ezɨ gumazamiziba atara mɨgɨrɨgɨar avɨribar Moses gamua, kamaghɨn an azangsɨsi, “E managh dɨpatam amegham?” ");
INSERT INTO msy2020_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moses Ikiavɨra Itir Godɨn dia mɨghɨgha a ko mɨgeima, Ikiavɨra Itir God ter otevir mam an aka. Ezɨ Moses a inigha dɨpamɨn anekuni, ezɨ dɨpam ua derazɨ, me aneremam. Ezɨ God danganir kamɨn arazir a ifongeziba ko bizir a damuasa mɨkemeziba me ganɨdi, egh a men gan me gɨfoghasa, me dar gɨn mangam, o ti puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ezɨ God me mɨgei, “Ia deragh nan akam baragh. Kɨrara Ikiavɨra Itir God, ian God, ia arazir nan damazimɨn deraziba, ia dar amu. Egh ia nan Akar Gavgaviba ko arazir kɨ ifongeziba bar dar gɨn mangɨ. Ia kamaghɨn damutɨ, kɨ pazɨ ia damuan koghɨva, arɨmariar kurar kɨ Isipɨn gumazamizibagh anɨngiziba ia danɨngan kogham. Guizbangɨra, kɨ ian Ikiavɨra Itir God. Kɨ ian arɨmariaba akɨrizɨ ia ghuamazi.” ");
INSERT INTO msy2020_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Egha gɨn Israelia ghua Elimɨn nguibamɨn otifi. Elim, a dɨpar nguazimɨn aven anagava otiva uaghirir 12pla ikia, 70plan temer detba iti. Ezɨ Israelia purirpeniba, nguazimɨn aven ivemarir dɨpabar boroghɨn dar ingarigha kagh apia. ");
INSERT INTO msy2020_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Israelian gumazamiziba Elimɨn danganim ategha, ghua Senɨn gumazamiziba puvatɨzir danganimɨn otifi. Danganir kam ana Elim ko Sainain Mɨghsɨamɨn tongɨra iti. Me otivizir dughiar kamran gɨn me Isipɨn kantri ategha ghue. Egha namba 2ɨn iakɨnim, an namba 15ɨn dughiamɨn, me gumazamiziba puvatɨzir danganir kamɨn otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Egha me danganir kamɨn ikia Moses ko Aronɨn atara, mɨgɨrɨgɨar avɨribar aning gami. ");
INSERT INTO msy2020_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Me kamaghɨn aning mɨgei, “Kamaghɨn deraghai, Ikiavɨra Itir God, Isipra e mɨsueghtɨ e arɨmɨghiregh. E Isipɨn kantrin ikia dagher guar igharagha gariba uan ifongiabar da api. E mɨtiriaba sara ikɨ aremeghasa gua ifonge. Egha e inigha gumazamiziba puvatɨzir danganir kamɨn ize.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ezɨ Ikiavɨra Itir God Moses mɨgɨa ghaze, “Kɨ ia bagh bret overiamɨn anemadaghtɨ, an amozimɨn mɨn magɨrɨtɨ ia a iniam. Gumazamiziba dughiaba vaghvagh mangɨ dughiar vamɨra baghɨvɨra dagheba ini. Kɨ arazir kamɨn me damu gan fogh suam, me ti nan akamɨn gɨn mangam, o puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ezɨ dughiar namba 6ɨn, me dughiar pumuning bagh dagheba inigh dar arɨkigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Ezɨ Moses ko Aron kamaghɨn Israelian gumazamizibav gei, “Guaratɨzimɨn ia kamaghɨn fogh suam, Ikiavɨra Itir God uabɨ Isipɨn kantrin ia inigha azenan ize. ");
INSERT INTO msy2020_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ia an atara mɨgɨrɨgɨar avɨribar a gami, ezɨ an oregha gɨfa. Ia mɨzarazimɨn Ikiavɨra Itir Godɨn gavgavim ko angazangarimɨn ganam. Ga pura gumazir kɨnimning. Ia manmaghsua gan atara mɨgei?” ");
INSERT INTO msy2020_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Egha Moses ua mɨgei, “Ikiavɨra Itir God uabɨ guaratɨzimɨn asɨzir tuziba ia danightɨ ia dar amam. Egh a mɨzarazibar bret ia danightɨ, ia uan ifongiabar a iniam. An orazi ia puram a mɨgei. Kamaghɨn amizɨ, a dagheba ia danɨngam. Ezɨ ga pura bizimning. Ia gan atara ga mɨgeir puvatɨ. Ia Ikiavɨra Itir Godra an atara a mɨgei.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Egha Moses Aron mɨgɨa ghaze, “Ikiavɨra Itir God, bar gumazamizibar adarir mɨgɨrɨgɨaba baraki. Kamaghɨn amizɨ nɨ me mɨkemeghtɨ, me izɨ Ikiavɨra Itir Godɨn damazimɨn tuifigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Ezɨ Aron me mɨgɨavɨra itima, me kogha gumazamiziba puvatɨzir danganir gigim gisɨn garima, Godɨn angazangarim zuamɨra ghuariar mamɨn aven oto. ");
INSERT INTO msy2020_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kɨ Israelian adarir mɨgɨrɨgɨam baraki. Kamaghɨn amizɨ, nɨ me mɨkemeghtɨ, me guaratɨzibar asɨzir tuzibar amam. Egh me mɨzarazibar uan ifongiamɨn bretbar amam. Me dagher kam inigh gɨvagh, me fogh suam, Kɨ Ikiavɨra Itir God, kɨ uabɨ men God.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Guaratɨzir kamɨn kuarazir muziarir bɨzim, mɨgha iza me itir danganim bar a gizɨfa. Ezɨ mɨzarazimɨn, ghuariar dɨpam ira, danganir men itim bar a gire. ");
INSERT INTO msy2020_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ezɨ ghuariar dɨpam iregha mɨsɨngigha gɨvazɨ, me bizir muziarir avɨribar gari da nguazimɨn iti, egha da mati terafariba mɨsigha tintinibar mɨsaraghire. ");
INSERT INTO msy2020_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ezɨ Israelia bizir kabar ganigha, dagh gɨfozir puvatɨ. Egha me kamaghɨn uarira uarir azai, “Kar bizir tizim?” Ezɨ Moses me mɨgei, “Kar bret, Ikiavɨra Itir God, ia damasa a ia ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Egha Ikiavɨra Itir God, akar gavgavim ia ganigha ghaze, ‘Ia vaghvagh uari bagh iniva uan adarazi sara me bagh inigh. Ia vaghvagh da iniva uan gumazamiziba ko boriba bagh vaghvagh mɨner muziaribar aghuigh.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Egha Israelia God mɨkemezɨ moghɨn me ami. Ezɨ marazi bar uari bagha avɨriba inizɨ, marazi uari bagha muziaribara ini. ");
INSERT INTO msy2020_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Egha gɨn me dagher kabar garima, gumazamizir dagher avɨriba iniziba, men mɨneba izevezir puvatɨ. Ezɨ gumazamizir dagher avɨriba inizir puvatɨziba, men dagheba otevezir puvatɨ. Me da apa izevegha mɨtiriam men azir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ezɨ Moses me mɨgɨa ghaze, “Ia gurum bagh dagher na taba ataghɨraghan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ezɨ gumazamizir maba Mosesɨn akam baraghizir puvatɨgha, dagher nar maba amɨmzaraghan bagha da arɨki. Ezɨ amɨmzaraghan dagher kaba apiziba dagh izɨvazɨma, da puvɨra mughasi. Ezɨ Moses men atari. ");
INSERT INTO msy2020_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ezɨ zurara mɨzarazibar gumazamiziba, me ifongezɨ moghɨn, uari bagha dagheba isi. Ezɨ aruem anadir dughiamɨn, dagher me isir puvatɨziba nguazimɨn ikia, dɨpamɨn mɨn otiva puram amera gefi. ");
INSERT INTO msy2020_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ezɨ aruer namba 6ɨn, me dughiar pumuning bagha dagheba ini. Gumazir vamɨra mɨner dozir pumuning pumuning gaghuizɨ, aning izɨvafa. Ezɨ Israelian gumazir dapaniba iza bizir kamɨn gun Moses mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ezɨ Moses kamaghɨn me mɨgei, “Ikiavɨra Itir God kamaghɨn mɨgei, gurum mɨzaraghan avughsamin dughiam. Kar Ikiavɨra Itir Godɨn ziam famin dughiam. Egha uaghan kar Ikiavɨra Itir Godɨn dughiamra. Ia datɨrɨghɨn dagher nar manaba avimɨn da tuasa, ia da tu, egh dagher nar manaba ia mɨnemɨn da isamasa, ia da isam. Eghtɨ nar itir kaba ia gurum mɨzaraghan bagh bar ada atɨgh.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ezɨ me Mosesɨn akam baregha dagher maba tue. Egha dagher nar maba tuezir puvatɨ. Me amɨmzaraghan bagha da atɨzɨ da iti. Ezɨ dagher kaba kurizir puvatɨzɨ apiziba dagh amizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ezɨ amɨmzaraghan Moses kamaghɨn mɨgɨa ghaze, “Kar Ikiavɨra Itir Godɨn dughiam, dughiar e avughsɨva, Ikiavɨra Itir Godɨn ziam famim. Ia dughiar kamɨn nguibamɨn azenan mangɨ dagheba burian kogham. Kamagh amizɨ, dagher nar itir kaba, ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ia wighɨn vamɨran 6plan aruebar, dagher kaba ini. Egh namba 7ɨn aruem, kar avughsamin dughiam. Kamaghɨn amizɨ, dughiar kamɨn dagher tam nguazimɨn ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ezɨ dughiar namba 7ɨn, gumazamizir maba ghua dagheba iniasa zui. Egha me dagher tabar garir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ezɨ Ikiavɨra Itir God Moses mɨgɨa ghaze, “Ia manadɨzoghɨn nan akaba barazir puvatɨzir arazim ategh, nan Akar Gavgavibar gɨntɨgham? ");
INSERT INTO msy2020_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ia deraghvɨram oragh! Kɨ Ikiavɨra Itir God, kɨ avughsamin dughiar kam ia danɨngam. Kamaghɨn amizɨ, kɨ aruer namba 6ɨn, dughiar pumuningɨn damamin dagheba ia danɨngam. Egh aruer namba 7ɨn gumazamiziba bar danganir me itiba ataghɨraghan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kamaghɨn amizɨ, me dughiar namba 7ɨn ingangarir tam gamir puvatɨ. Me avughsi. ");
INSERT INTO msy2020_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ezɨ Israelian gumazamiziba dagher kam kamaghɨn a dɨbora ghaze, “Mana.” Hibrun akamɨn Manan kamɨn ganganim, temer ovɨzir muziarimɨn mɨn gara egha ghurghuri. Egha an isɨngtɨzim, mati bisketɨn me hani sara ingarizim. ");
INSERT INTO msy2020_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Ezɨ Moses kamaghɨn me mɨgɨa ghaze, “Ikiavɨra Itir God kamaghɨn mɨgei, ‘E mɨner tam inigh, an manabar aghuam. Eghtɨ an en gɨn otivamin ovavir boriba bagh ikiam. Me gɨn an gan suam, kar Ikiavɨra Itir God e ganɨngizir daghem. A Isipɨn kantrin e inigha azenan iza gumazamiziba puvatɨzir danganimɨn e atɨzir dughiam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Egha Moses Aron mɨgɨa ghaze, “Nɨ nguazir mɨner tam inigh, manan tabar aghuigh. Egh mɨnem isɨ Ikiavɨra Itir Godɨn damazimɨn anetɨgh. Eghtɨ borir gɨn otivighamiba, a gɨfogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Ezɨ Aron manan dagher mɨner kam isa, gɨn izamin dughiam bagha, Akar Dɨkɨrɨzir Gavgavir Boksiam boroghɨn anetɨ, ezɨ Aron Ikiavɨra Itir God Moses mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ezɨ Israelia manan dagher kam apa ghua 40plan azenibar tu. Ezɨ 40plan azeniba gɨvazɨma me ghua Kenanian kantrin otivigha, kantrin kam gapiagha uari bagha azenibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Dughiar kamɨn Israelia bizibar osɨmtɨzibagh fofoghamin skelɨn pumuning iti. Omer ko Epah, mam mɨner dozir vamɨran mɨn iti. Mam 10plan mɨner dozibar mɨn iti.) ");
INSERT INTO msy2020_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ezɨ Israelian gumazamiziba bar Ikiavɨra Itir Godɨn akamɨn gɨn ghua, dɨkavigha Senɨn gumazamiziba puvatɨzir danganim ategha zui. Egh dughiar manamɨn Ikiavɨra Itir God mɨkemeghtɨ, me dɨkavighɨva danganir me itir kam ategh sɨvaghsɨvagh mangɨ danganir igharazir mam dapiagham. Me kamaghɨra apiaghira ghua, gɨn me ghua Refidimɨn danganimɨn otogha, purirpenibar ingarigha apia. Ezɨ danganir kam dɨpar damamiba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ezɨ gumazamiziba Mosesɨn atara ghaze, “Nɨ e damamin dɨpatam e danɨngigh.” Ezɨ a men akam ikaragha ghaze, “Ia tizim bagha nan atari? Ia masa Ikiavɨra Itir Godɨn Araziba tuisɨgha, an gavgavim bagha azai? Ia ti nɨghnɨzir gavgavim an itir puvatɨ?” ");
INSERT INTO msy2020_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ezɨ gumazamiziba dɨpam bagha kuariba bar me mɨsɨngizɨ, me mɨgɨrɨgɨar avɨribar Moses gimoba ghuavɨra iti. Egha me kamaghɨn a mɨgei, “Nɨ tizim bagha Isipɨn kantrin aven e inigha azenan ize? Nɨ ti kamaghɨn ifonge, e uan boriba ko asɨziba, e damamin dɨpaba puvatɨgh, kagh arɨghiregham, a?” ");
INSERT INTO msy2020_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Ezɨ Moses pamten kamaghɨn Ikiavɨra Itir God ko mɨgei, “Gumazamizir kaba dagɨabar na ginivigh, na mɨsueghtɨ kɨ aremeghasa. Ezɨ kɨ manmagh me damuam?” ");
INSERT INTO msy2020_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ Israelian gumazir dapanitaba inigh, ia daru gumazamizibar faragh mangɨ. Ia darusɨva, asadivir aghorir nɨ faragha Nailɨn Fanem mɨsoghezim sara inigh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kɨ Horepɨn Mɨghsɨamɨn dagɨatam gisɨn tugh ikiam, kar Sainain Mɨghsɨam. Nɨ roghɨra izɨva, asadivir aghorir kamɨn dagɨam mɨsokegh. Eghtɨ dɨpam an otogh azenan fasfagh irɨtɨ, gumazamiziba anemam.” Ezɨ Israelian gumazir dapaniba gari, Moses kamaghɨn amizɨ, dɨpam otogha izaghiri. ");
INSERT INTO msy2020_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ezɨ me danganir kam kamaghɨn a dɨbori, “Masa,” an mɨngarim kamakɨn, “Tuighsɨzir Arazim,” ko “Meriba,” an mɨngarim, “Adarim.” Me kamaghɨn nɨghnɨsi, Israelia atara ghaze, “Ikiavɨra Itir God, e ko iti, o puvatɨ.” Arazir kamɨn, me Ikiavɨra Itir Godɨn Araziba tuisɨgha an gavgavim bagha azangsɨsi. ");
INSERT INTO msy2020_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Egha gɨn Amalekia iza Refidimɨn danganimɨn Israelia ko mɨsosi. ");
INSERT INTO msy2020_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ezɨ Moses kamaghɨn Josua mɨgei, “Nɨ e bagh gumazitaba amɨseveghtɨ, me gurumɨn mangɨ Amalekia ko mɨsogh. Eghtɨ kɨ mangɨ mɨghsɨar dozir munamɨn tugh, Godɨn gavgavim itir asadivir aghorimɨn suiragham.” ");
INSERT INTO msy2020_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ezɨ Josua, Moses a mɨkemezɨ moghɨra, gumazir maba inigha ghua Amalekia ko mɨsosi. Ezɨ Moses, Aron ko Hur sara, me mɨghsɨar dozimɨn uanabo. ");
INSERT INTO msy2020_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Egha Moses uan agharimning feghavɨra itima, Israelian mɨdorozir gumaziba, Amalekia gafigha ghuavɨra iti. Ezɨ Moses uan agharimning ataghizɨ aning uaghirima, Amalekia Israelia gafiragha ghuavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ezɨ gɨn Mosesɨn agharimning a girima, a uam aning ghufan ibura. Ezɨ Aron ko Hur dagɨar mam inigha anefazɨ, Moses a gapera. Ezɨ aning Mosesɨn boroghɨn vong ko vongɨn tugha, an agharimning suiragha aning gifueghavɨra ikia, kamaghɨra ikiavɨra itima, aruem ghuaghirɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ezɨ Josua uan adarazi ko Amalekian mɨdorozir gumaziba abɨnigha, bar me gasɨghasɨki. ");
INSERT INTO msy2020_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ezɨ gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ akar kam akɨnafaritamɨn an osirightɨ, gumazamiziba a gɨnɨghnɨgh. Akar kam kamakɨn, ‘Kɨ Ikiavɨra Itir God, kɨ Amalekia bar me agɨvagham. Eghtɨ gumazamiziba ua me gɨnɨghnɨghan kogham.’ Nɨ akar kam Josua bagh a dɨpontɨ, an a barakigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ikiavɨra Itir God mɨkemegha gɨvazɨma, Moses ofa gamir dakozir mamɨn ingari. Ezɨ ofa gamir dakozir kamɨn ziam mati nir avɨzir ekiam me an osirigha a ghufezɨ a ghaze, “Ikiavɨra Itir God, nan akurazɨ kɨ uan apaniba abɨra.” ");
INSERT INTO msy2020_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Ezɨ Moses ghaze, “Ia Ikiavɨra Itir Godɨn inir avɨzim ghufegh bar pɨn an suiragh. Guizbangɨra, Ikiavɨra Itir God, zurara Amalekia ko mɨsogh kamaghɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro, a Midianian ofa gamir gumazim, a Mosesɨn amerem. A bizir God Israelia ko Moses bagha amizibar eghaghanim baregha, uaghan dughiar Ikiavɨra Itir God uan gumazamiziba, Israelia, me inigha Isip ategha izezir eghaghanim baraki. ");
INSERT INTO msy2020_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kamaghɨn amizɨ, Jetro Mosesɨn ganasa ize. Moses faragha uan amuim Sipora amadazɨ, a uan afeziam Jetro bagha ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ezɨ datɨrɨghɨn, Sipora ko Mosesɨn otarir pumuningɨn ko Jetro, me izava otifi. An otarimningɨn ziamning, Gersom ko Elieser. Moses faragha ghaze, “Kɨ kantrin igharazimɨn gumazim, egha kantrin igharazimɨn iti.” Egha a uan otarir ivariam ziam, “Gersom,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Egha a gɨn kamaghɨn mɨgei, “Nan afeziamɨn God nan akurazɨ, Isipɨn atrivim na mɨsoghezɨ kɨ aremezir puvatɨ.” Egha uan otarir dozim, a “Elieser,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Ezɨ Jetro, Mosesɨn amuim ko an otarir pumuningɨn akua me iza gumazamiziba puvatɨzir danganim iza, Godɨn mɨghsɨamɨn boroghɨra izava otifi. Kar Moses purirpenibar ingarigha dar ikezir danganim. ");
INSERT INTO msy2020_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Egha Jetro kamaghɨn Moses bagha akam amada, “Kɨ nɨn amerem Jetro, kɨ nɨn amuim ko nɨn otarimning, e nɨ bagha ize.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ezɨ Moses akar kam baregha, ghua tuavimɨn Jetro bato. Egha Moses aviragha gɨn ghua an tori. Egha aning uan ikɨrɨmɨrim bagha uaningɨn azangsɨgha, me gɨn Mosesɨn purirpenimɨn aven ghue. ");
INSERT INTO msy2020_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Egha Moses uan amerem bizir avɨribar a geghara ghaze, Ikiavɨra Itir God Israelian akurvaghasa, Isipɨn atrivim ko Isipɨn gumazamizibagh amizɨ, arazarazir avɨriba otifi. Egha a ghaze, me tuavimɨn zuima, bizir kuraba ko osɨmtɨziba me bativima, Ikiavɨra Itir God men akura. ");
INSERT INTO msy2020_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Ezɨ Jetro akar kam baregha fo, Ikiavɨra Itir God bizir aghuaribar Israelia gamigha, Isipian dafarimɨn ua me ini. Ezɨ Jetro akar kam baregha bar akonge. ");
INSERT INTO msy2020_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Egha kamaghɨn mɨgei, “Ga Ikiavɨra Itir Godɨn ziam fe. A Isipɨn atrivim ko an gumazamizibar dafarimɨn ia inigha ian akurazɨ, ia kalabusɨn ingangarir kurar kam ataki. ");
INSERT INTO msy2020_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ezɨ kɨ datɨrɨghɨn fo, Ekiam bar godɨn igharazibagh afiragha kamaghɨn ami. Isipia akaba batoghava paza ia gamima, Ikiavɨra Itir God ian akura. Ezɨ kɨ datɨrɨghɨn fo, Ikiavɨra Itir God bar gavgavizɨ, an gavgavim godɨn igharazibar gavgavibagh afira.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Egha Jetro ofan bar isia mɨghɨrizir mam, inigha God ganɨdi. Egha uaghan ofan igharaziba God ganɨngi. Ezɨ Aron ko Israelian gumazir dapaniba iza, Godɨn damazimɨn Mosesɨn amerem koma api. ");
INSERT INTO msy2020_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ezɨ Dughiar igharazimɨn, Moses amɨmzaraghan jasɨn mɨn aperagha Israelian gumazamizibar osɨmtɨziba tuisɨsi. Ezɨ gumazamizir avɨriba Moses bagha mɨzarazimɨn izavɨra ikia, ghua guaratɨzimɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ezɨ Jetro, Moses gumazamizibar akurvazir araziba, bar dar gara, egha kamaghɨn Moses mɨgei, “Maning, gua uaningra ingangarir avɨribar gumazamizibar akurvaghasa dagh ami. Nɨ uabɨra ingangarir kam damuan markɨ. Nɨ gan, nɨ osɨmtɨziba akɨra aperaghavɨra iti gumazamiziba mɨzaraghara iza nɨ ko mɨkɨmasa, nɨ mɨzua tuivighav ikia, ghua aruem gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ezɨ Moses a mɨgei, “Gumazamiziba bizir God damuasa ifongezibagh fofoghasa, na bagha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Gumazitamning bizir mam bagh uaningɨn atarigh, aning na bagh izeghtɨ, kɨ aningɨn mɨgɨrɨgɨam baregh aningɨn osɨmtɨzim akɨram. Egh kɨ arazir God ifongeziba ko Godɨn akabar men sure damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ezɨ Jetro kamaghɨn a mɨgei, “Nan amerem, nɨ ingangarir kam damuamin tuavir aghuimɨn zuir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ingangarir kam bar nɨn ekefe. Nɨ uabɨra a damu mangɨtɨ nɨn mɨkarzim nɨn amɨragham. Eghtɨ gumazamiziba uaghan men mɨkarziba men amɨragham. ");
INSERT INTO msy2020_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nɨ datɨrɨghɨn nan akam baraghtɨ, kɨ tuavir aghuarir mam nɨ mɨkɨmam. Eghtɨ God nɨ ko ikiam. Arazir kam deragham, nɨ gumazamiziba bagh Godɨn damazimɨn abuir gumazimɨn mɨn ikɨ. Egh men mɨgɨrɨgɨar me uari adoziba, nɨ da inigh a bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Egh nɨ arazir God ifongeziba ko Godɨn akabar men sure damuva, tuavir me gɨn mangamimɨn me mɨkɨmɨva, arazir me zurara damuamimɨn men sure damu. ");
INSERT INTO msy2020_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Egh nɨ uaghan fofozir gumazir aghuitaba mɨseveghtɨ, me gumazamizibar dapanibar ikiam. Eghtɨ tarazi 1,000plan gumazamizibar gantɨma, tarazi 100plan gumazamizibar gantɨma, tarazi 50plan gantɨma, tarazi 10plan ganam. Gumazir kaba uari abɨnigh guizbangɨra Godɨn atiatingɨva an apengan ikɨ, egh gumazir e nɨghnɨzir gavgavim men itibar, mɨn ikɨ. Gumazamiziba dagɨaba me danɨng, me gekutɨ, me arazir kurabar amuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Eghtɨ gumazir kaba jasbar mɨn ikɨ, gumazamizibar osɨmtɨziba tuisɨgham. Egh me uari osɨmtɨzir muziariba tuisɨgham. Egh osɨmtɨzir ekiaba, me da inigh nɨ bagh izɨtɨ, nɨ da tuisɨgham. Egh me nɨn akuragh ingangarir kamɨn osɨmtɨzim inightɨ, ingangarim nɨn osemeghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kɨ bizir God nɨ damuasa a ifongeziba kɨ dar gun nɨ mɨkeme, nɨ dar amu. Nɨ nan akamɨn gɨn mangɨ, eghtɨ ingangarir kam nɨ damightɨ, nɨn mɨkarzim nɨn amɨraghan kogham. Eghtɨ ia gumazamizibar osɨmtɨziba ko akabar kɨrightɨ, me navir amɨriziba ikɨ, egh uamategh uan purirpenibar mangam.” ");
INSERT INTO msy2020_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Ezɨ Moses, Jetron akar aghuir kam baregha kamaghɨn ami. ");
INSERT INTO msy2020_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Egha a Israelian tongɨn fofozir gumazir aghuariba mɨsevegha me atɨzɨ, me gumazamizibar gumazir dapanibar mɨn iti. Ezɨ men marazi 1,000plan gumazamizibar garima, marazi 100plan gumazamizibar garima, marazi 50plan garima, marazi 10plan gari. ");
INSERT INTO msy2020_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Egha me zurara jasbar mɨn osɨmtɨzibar tuisɨghamin ingangarim gami. Me uari araziba ko osɨmtɨzir muziariba tuisɨsi, egha osɨmtɨzir ekiaba, Moses bagha da amadi. Ezɨ a uabɨ da tuisɨgha dar kɨri. ");
INSERT INTO msy2020_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ezɨ bizir kabar gɨn, Moses uan amerem Jetron dafarimɨn suirazɨ, Jetro uamategha uan nguibamɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ezɨ Israelia Refidimɨn danganim ategha zui. Me ghua Sainain gumazamiziba puvatɨzir danganimɨn otifi. Me otivizir dughiar kamra, a iakɨnir me Isipɨn kantri ataghizimɨn gɨn ghua, iakɨnir pumuning gɨvazɨ, iakɨnir namba 3 otozɨ, me an aruer namba 1ɨn Sainain otifi. Egha me Sainain Mɨghsɨamɨn boroghɨn purirpenibar ingarigha apia. ");
INSERT INTO msy2020_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ezɨ Moses God ko mɨkɨmasa mɨghsɨamɨn ghuanadi. Ezɨ Ikiavɨra Itir God mɨghsɨamɨn ikia Mosesɨn dɨagha ghaze, “Nɨ Israelia mɨgɨrɨgɨar kaba me danɨngam, me Jekopɨn ovavir boriba. ");
INSERT INTO msy2020_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Kɨ Isipɨn amizir biziba, ia uari dar ganigha gɨfa. Egha ia nan gari kɨ ia ini, mati kuarazir bagam uan nguzim uan avɨzimɨn a isi moghɨn, kɨ ua bagha ia inigha iza danganir kamɨn izezɨ, ia datɨrɨghɨn na ko iti. ");
INSERT INTO msy2020_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Egh ia datɨrɨghɨn nan Akar Dɨkɨrɨzir Gavgavimɨn suiragh gavgavigh, nan akabar gɨn mangɨ, nan gumazamizibar otogham. Nguazir kamɨn danganiba bar, ko gumazamiziba bar, me nan adarazira, eghtɨ kɨ men tongɨn iarara ua bagh ia mɨsevegham, eghtɨ ia nan gumazamizibara ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Egh ia na baghavɨra itir gumazamizibara ikɨ, egh ofa gamir gumazibar mɨn ikɨ, Kantrin Igharazibar Gumazamiziba bagh abuir gumazimɨn ingangarim damuam. Egh ia bar guizbangɨra nan gumazamizibara ikɨva na baghvɨra ikiam.” Egha Ikiavɨra Itir God mɨgɨrɨgɨar kaba gumazamizibar anɨngasa Moses mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ezɨ Moses mɨghsɨam ategha ghua Israelian gumazir dapaniba akuvagha, akar Ikiavɨra Itir God a mɨkemeziba, bar dar gun me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ezɨ gumazamiziba bar moghɨra kamaghɨn mɨgei, “Bizir Ikiavɨra Itir God e mɨkemeziba, e bar dar amuam.” Ezɨ Moses ghua gumazamizibar akabar gun Ikiavɨra Itir God mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ oragh. Kɨ ghuariar mɨtiar pɨzimɨn aven kɨ ia bagh izɨva, nɨ ko mɨkɨmam. Dughiar kamɨn gumazamiziba oraghtɨ, kɨ nɨ ko mɨkɨmam. Eghtɨ me datɨrɨghɨn ikegh mangɨ, me zurara nɨn mɨgɨrɨgɨaba nɨghnɨzir gavgavim dar ikiam.” Ezɨ Moses gumazamizibar akabar gun, Ikiavɨra Itir God mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ezɨ Ikiavɨra Itir God Moses mɨgei, “Nɨ mangɨ gumazamizibav kɨm suam, me datɨrɨghɨn ikegh mangɨ gurumɨn, me uari na danɨngɨsɨ uan nɨghnɨziba ko araziba akɨrigh, bar zuegh. Egh me uan korotiaba ruegh, nan ziam fɨsɨ uari akɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Me uari akɨrigh tugh gavgavigh ikɨ mangɨ aruer namba 3ɨn otogh. Dughiar kam, kɨ Sainain Mɨghsɨamɨn izighirɨ gumazamiziba bar, men damazimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Egh nɨ mɨghsɨam bagh mɨtaghniam atɨgh. Eghtɨ gumazamiziba mɨtaghniar kamɨn vongɨn mangan markɨ. Nɨ deraghvɨra me mɨkɨm, me deraghvɨra ganigh, me mɨtaghniar kamɨn ikiavkɨnigh vongɨn mangɨ, mɨghsɨamɨn mavanangan kogham. Guizbangɨra me mɨghsɨamɨn boroghɨra mangan kɨ anogoroke. Gumazitam mɨtaghniamɨn ikiavkɨnightɨ, me a mɨsueghtɨ an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Egh me dafaribar an suiragh a mɨsueghtɨ an aremeghan markɨ. Me dagɨabar a ginifigh, o afuzitamɨn a bɨragh. Gumazitam, o asɨzitam mɨtaghniamɨn ikiavkɨnightɨ, ia arazir kam bagh a mɨsueghtɨ an aremegh. Ia dughiar vamɨran, ia mɨghsɨamɨn anang. Ia sɨgham baraghamin dughiam, ia mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ezɨ Moses mɨghsɨam ategha uaghirɨgha gumazamizibav mɨkeme. Ezɨ me an akam baregha, me uari God danɨngasa uan nɨghnɨziba ko araziba akɨrigha, egha zue. Me uan korotiaba ruegha Godɨn ziam fer arazim damuasa uari akɨraghasi. ");
INSERT INTO msy2020_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ezɨ Moses me mɨgei, “Ia zuerim bagh uari akɨr tugh gavgavigh ikɨ. Egh datɨrɨghɨn ikegh mangɨ zuerimɨn, ia amiziba ko dakuan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ezɨ dughiar namba 3ɨn mɨzarazimɨn arariba dagarvazi onɨmariba taghtazima, ghuariar mɨtiar pɨzir mam izaghira mɨghsɨam avara. Ezɨ me sɨghar ararer gavgavir mam baraki. Egha gumazamizir danganir kamɨn itiba, bar atiatigha nɨsi. ");
INSERT INTO msy2020_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ezɨ Moses gumazamiziba inigha, me itir danganimɨn azenan ghua men faragha ghua God bativasa zui. Me mɨghsɨamɨn boroghɨn ghua, an apengan zarimɨn tuifi. ");
INSERT INTO msy2020_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ezɨ Ikiavɨra Itir God avimɨn aven ikia, egha izaghira Sainain Mɨghsɨamɨn iti, ezɨ mɨgharir ekiam mɨghsɨam bar anevara. Mɨgharir kam ghuavanaga, mati avir ekiamɨn mɨgharim ghuavanadi. Ezɨ mɨkɨmkɨzir ekiam mɨghsɨamɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ezɨ sɨghamɨn ararem bar ekevegha pamtem ara ghuavɨra iti. Ezɨ Moses God mɨgei. Ezɨ God a ikarvazi, an tiarim mati ararim dagarvasi. ");
INSERT INTO msy2020_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ikiavɨra Itir God izaghira Sainain Mɨghsɨamɨn orazimɨn ikia, egha Mosesɨn dei. Ezɨ Moses ghuavanadi. ");
INSERT INTO msy2020_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ezɨ Ikiavɨra Itir God kamaghɨn a mɨgei, “Nɨ magɨrɨ, mɨgɨrɨgɨar gavgavim gumazamizibar anɨngightɨ me mɨtaghniar kamɨn ikiavkɨnigh izɨ nan ganan markɨ. Me kamaghɨn damigh, men avɨriba arɨghiregham. ");
INSERT INTO msy2020_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Nan boroghɨn izir ofa gamir gumaziba, me uaghan uari na danɨngɨsɨ, uari akɨrigh nan damazimɨn zuegham. Puvatɨghtɨ, kɨ ivezir kuram me danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Egha Moses Ikiavɨra Itir God kamaghɨn a mɨgei, “Nɨ akar gavgavim e ganɨngi, kamaghɨn gumazamiziba mɨghsɨamɨn mangan kogham. E mɨtaghniam arɨgha mɨghsɨamɨn apɨnim ighuigha, e kamaghɨn fo, mɨghsɨar kam, a nɨn mɨghsɨamra, egha ana anogoroke.” ");
INSERT INTO msy2020_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ezɨ Ikiavɨra Itir God a ikaragha ghaze, “Nɨ magɨrɨ, Aron inightɨ a nɨ ko uamategh anang. Eghtɨ ofa gamir gumaziba ko, gumazamiziba bar mɨtaghniar kamɨn ikiavkɨnigh na bagh mɨghsɨamɨn anangan markɨ. Me kamaghɨn damightɨ, kɨ ivezir kuram me danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ezɨ Moses akar kam baregha gumazamizibar bighan iraghugha, Ikiavɨra Itir God mɨkemezir mɨgɨrɨgɨaba bar me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ezɨ God kamaghɨn mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Kɨ uabɨ, kɨ Ikiavɨra Itir God, ian God. Kɨrara Isipɨn kantrin ia inigha ian akua azenan ize. Kar danganir ia ingangarir gumazamizir kɨnibar ikezim. ");
INSERT INTO msy2020_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ia bar narara gɨn mangɨ nan ziamra fam. Egh ia asetamɨn gɨn mangan bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ia uari bagh marvir guatam an ingaran markɨ. Ia overiamɨn itir bizitam, ko nguazimɨn itir bizitam ko dɨpamɨn aven itir biziba, ia bizir kabar gan, dar mɨn marvir guatamɨn ingaran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ia asetam ko marvir guatamɨn itevibar pɨrɨva an ziam fan markɨ. Guizbangɨra, kɨ Ikiavɨra Itir God, kɨ ian God. Egh godɨn ifavaritamɨn amamangatɨghtɨ, a nan danganim inian kogham. Bar puvatɨ. Gumazamizir nan aghuaziba, me osɨmtɨzim iti, ezɨ kɨ ivezir kuram me ko men ikɨzim danɨng mangɨvɨra ikɨtɨ, men ikɨzimɨn igiar boriba ko azɨziba otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ezɨ gumazamizir bar na gifongeziba, me nan Akar Gavgavibar gɨn zui. Kɨ bar ian ovavir boriba men apangkuvigh kamaghɨra ikɨ mangɨ, men 1,000ɨn ovavir borir gɨn izamibar otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nan ziam, Ikiavɨra Itir God, ian God, ia puram a dɨponan markɨ. Guizbangɨra, gumazamizir pura nan ziam dɨboriba, Ikiavɨra Itir God kamaghɨn me mɨkɨman kogham, pura bizim, me osɨmtɨziba pu. Bar puvatɨ, a ivezir kuram me danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ia Sabatɨn dughiam deragh a gɨnɨghnɨgh mɨkɨm suam, a dughiar kɨ ua bagha inabazimra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ia wighɨn vamɨra, 6plan aruebar aven ingangariba bar dar amuam. ");
INSERT INTO msy2020_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ezɨ namba 7ɨn dughiam, kar Ikiavɨra Itir God, ian Godɨn dughiamra. Kar dughiar ia avughsamim. Egh Sabatɨn dughiam, ia bar ingangaribar amuan markɨ. Ia uan otariba, guiviba, ingangarir gumaziba, ingangarir amiziba, asɨziba, ko ikɨzir igharazibar gumazamizir iza ian nguibamɨn itiba, ia bar ingangaribar amuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Guizbangɨra, Ikiavɨra Itir God 6plan aruebar nguazim ko overiam, ongarimɨn ko dar itir biziba bar adar ingari. Egha namba 7ɨn aruem an avughse. Kamaghɨn amizɨ, Ikiavɨra Itir God, Sabatɨn dughiam deraghavɨra a gɨnɨghnɨgha an anogorogha a gamizɨma, an a baghvɨra ikiamin dughiamɨn oto. Kar Godɨn dughiamra. ");
INSERT INTO msy2020_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Egh ia vaghvagh uan afeziam ko amebamɨn apengan ikɨ, men akabar gɨn mangɨ. Ia kamaghɨn damighɨva, ia dughiar ruarimɨn nguazir kamɨn ikiam, kar nguazir Ikiavɨra Itir God, ian God a isa ia ganɨdim. ");
INSERT INTO msy2020_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Egh ia gumazamizir igharazibav soghtɨ me arɨmɨghiran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Egh ia poroghamiba uari bakɨa uari ko akuir arazim damuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Egh ia biziba okɨman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Egh ia ifavarir akabav kɨmɨva gumazamizir igharazitamɨn ziam gasɨghasɨghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Egh ia gumazir igharazitamɨn dɨpenim bagh navim dɨkavan markɨ. Egh an amuim bagh navim dɨkavan markɨ. Egh an ingangarir gumazim, ingangarir amizim, bulmakau, donki, ko an bizir igharaziba bar, da bagh navim dɨkavan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ezɨ gumazamiziba gara orazima, ararim pamtem dagarvazima, sɨgham araima, onɨmarim taghtazima, mɨgharir ekiam mɨghsɨam avara. Ezɨ me bar atiatigha puvɨra nɨsi. Kamaghɨn amizɨ, me sɨvagha ghua mɨghsɨamɨn saghon tuifi. ");
INSERT INTO msy2020_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Egha me kamaghɨn Moses mɨgei, “Nɨ uabɨ e mɨkɨmtɨ e nɨ baragham. God e mɨkɨmtɨ, e arɨmɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Ezɨ Moses me mɨgei, “Ia atiatingan markɨ. God kamaghsua ifonge, ia bar an atiatigh an apengan ikɨ, egh arazir kurabar amuan kogham. Kamaghɨn a iza ian navir averiabagh foghasa, da guizbangɨra a baghavɨra iti, o puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Egha gumazamiziba saghon tuivighavɨra itima, Moses uabɨra ghua God aven itir ghuariar pɨzimɨn boroghɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ kamaghɨn Israelia akar kabar me mɨkɨm suam, ‘Ia uari ganigha kamaghɨn fo, kɨ Uan Nguibamɨn ikia, ia ko mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ia orakigh. Ia gol ko silvan asebar marvir guabar ingar, dar ziaba fan markɨ. Kɨ uabɨra, ia bar nan ziamra fam. ");
INSERT INTO msy2020_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ia nguazitaba inigh na bagh ofa gamir dakozimɨn ingar. Egh ofa gamir dakozir kamnang gisɨn, ia sipsipba ko bulmakauba ofan mɨn da isɨ na danɨngigh, ofan taba, kar ia da tueghtɨ da bar isi mɨghɨrighamin ofaba. Eghtɨ taba, kar ia gumazamiziba na ko navir vamɨran ikiasava amir ofaba. Egh ia danganir kɨ inabazibar kamaghɨn nan ziam fɨtɨ, kɨ izɨ deragh ia damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ia ofa gamir dagɨar dakozimɨn ingar, egh dagɨar gumaziba dɨghoreziba inian markɨ. Guizbangɨra, ia ofa gamir dakozimɨn ingarsɨ, dagɨar tuizimɨn dagɨar ekiatam amɨneghtɨ, arazir kamɨn dagɨar kam nan damazimɨn zueghan koghtɨ, nan ingangarim bar deraghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ia ofa gamir dakozimɨn ingarightɨ a pɨn ikɨtɨ, ia adɨrɨziamɨn ingarigh mavanang, egh arazir kamɨn ofa damuan markɨ. Bar markɨ. Ia kamaghɨn damigh, adɨrɨziamɨn mavanangtɨ, me ti ian mɨkarzir mogomebar ganigham. Arazir kam derazir puvatɨ.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Egha Ikiavɨra Itir God kamaghɨn mɨgei, “Nɨ Israelia damuamin arazibar gun me mɨkɨm: ");
INSERT INTO msy2020_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ia Hibruian gumazitam ingangarir gumazir kɨnitamɨn mɨn a givezeghtɨ, a ian ingangaribar amu mangɨ, 6plan azenibar tugh. Egh namba 7ɨn azenimɨn ia aneteghtɨ a mangɨ. Egh a dagɨar taba ia danɨngan markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","A faragha odiarimɨn ikia nɨn ingangarir gumazimɨn oto, egh a gɨn mangɨsɨ, a uabɨra mangɨ. A faraghavɨra amuimɨn ikia nɨn ingangarir gumazimɨn oto, egh dughiar a nɨ ateghamim, a uan amuim inigh a sara mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Egh an gumazir dapanim amizim a danightɨ, a boriba bateghtɨ, amizir kam uan boriba ko, me uan gumazir dapanim ko ikiam. Eghtɨ gumazimra fɨrighɨrɨgh mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Egh ingangarir gumazim suam, ‘Kɨ uan gumazir dapanim gifongegha, uan amuim ko boribagh ifongegha, me ataghɨraghan aghua,’ ");
INSERT INTO msy2020_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","eghtɨ an gumazir dapanim a inigh Godɨn Dɨpenimɨn mangɨ. Egh ingangarir gumazim tiar akam o temer tiar akamɨn mɨriamɨn asaraghav itimɨn boroghɨn tughɨv ikɨ. Eghtɨ an gumazir dapanim dɨkonir tam inigh, egh an kuarim okoregham. Arazir kamɨn a gumazir dapanir kamɨn ingangarir gumazir kɨnimra ikɨ mangɨtɨ, an ovevemɨn dughiam otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Egh gumazitam uan guivim ingangarir amizir kɨnimɨn mɨn anemadaghtɨ, gumazir dapanim a givezeghtɨ, gɨn namba 6ɨn azenim gɨvaghtɨ, an aneteghtɨ a ingangarim ateghan kogham. Ia ingangarir gumazibagh ami moghɨn, ingangarir amizibar amuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Gumazim ingangarir amizitam givezegh, uan amuir dozimɨn mɨn an ikɨsɨ, ua gɨn uan amuir dozir kamɨn aghuaghɨva, uam an afeziamɨn teghtɨ a uam a givezegham. Gumazir kam arazir aghuimɨn amizir kam gamizir puvatɨ. Kamaghɨn a kantrin igharazitamɨn gumaziba bagh anemangɨtɨ me a givezan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Egh gumazir kam uan otarim gɨnɨghnɨgh ingangarir amizir kɨnir kam a danɨngɨsɨ, a deraghvɨra uan guivimɨn mɨn a damu. ");
INSERT INTO msy2020_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Egh gumazir dapanim amizir igharazimɨn ikɨsɨ, a ingangarir amizir a faragha ikezir kam, deragh a damu. A faraghavɨra a gami moghɨn, dagheba ko korotiaba a danɨng, egh a ko dakuvɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","An arazir 3plan kabar amuan kogh, egh pura amizir kam ateghtɨ a mangɨ. Gumazim uabɨ givesɨ a mɨkɨman markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Gumazitam pamten gumazitam mɨsueghtɨ, an aremeghtɨ, ia gumazir kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Eghtɨ a gumazir kam mɨsueghtɨ an aremeghan nɨghnɨzim ikian koghtɨ, Godra gumazir kam ateghtɨ an an agharimɨn pazɨ a damutɨma an aremegham, eghtɨ gumazir a mɨsoghezim an arɨ mangɨ nguibar kɨ ia bagha mɨsevezimɨn mangɨgh, egh a deraghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Eghtɨ gumazitam gumazir igharazim bagh navim ikuvigh, a mɨsueghtɨ ana aremeghsɨ nɨghnɨgham, ia a mɨsueghtɨ an aremegh. An arɨ mangɨ nan ofa gamir dakozimɨn ikɨtɨ, ia a inigh danganir igharazitamɨn mangɨgh, a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Egh gumazitam uan afeziam ko amebam mɨsuegham, ia a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Eghtɨ tav gumazitam okemegh, a damightɨ an an ingangarir gumazir kɨnimɨn mɨn ikiam, o gumazir igharazim ateghtɨ an a givezegham, ia gumazir arazir kam gamizim mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Eghtɨ gumazitam uan afeziam ko amebam pazɨva aningɨn atarɨva aningɨn ziamning gasɨghasightɨ, ia gumazir kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Ezɨ gumazitamning uaningɨn atarɨva, egh tav dafarim medagh, tav mɨsuegham, o dagɨatamɨn tav bɨragh, a mɨsueghtɨ an aremeghan koghtɨ, ia gumazir kamɨn arazir kuram ikarvaghan markɨ. Eghtɨ gumazir osɨmtɨzir ekiam inizir kam, a dakozimɨn ikɨ, egh gɨn a dɨkavigh asadivir aghorimɨn suiragh daruam. Eghtɨ gumazir a mɨsoghezir kam dagɨar taba a givezam. Eghtɨ dagɨar kaba gumazir kamɨn ingangarim ataghizir dughiabagh ivezam. Gumazir a mɨsoghezir kam a geghuv mangɨ dughiar a ua deraghamim otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ezɨ gumazitam aghorim inigh uan ingangarir gumazim o ingangarir amizir kɨnim mɨsueghtɨ, ingangarir gumazim o amizim dughiar kamra bizir kam bagh aremeghtɨ, ia ivezir kuram gumazir dapanir kam a danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Eghtɨ gumazim o amizir kam dughiar vamɨra o pumuningɨn ikegh gɨn aremeghtɨ, ia an gumazir dapanim ivezir kuram a danɨngan markɨ. Guizbangɨra, ingangarir gumazim, kar an gumazir dapanimɨn bizimra, eghtɨ ovengezir gumazim datɨrɨghɨn an ingangarim damuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Eghtɨ gumazitaba uariv soghɨva amizir navim asangizim mɨsueghtɨ, a borir kuam bateghtɨ, amebam deraghtɨ, gumazir amizim mɨsoghezir kam, an pam ifongezɨ moghɨn gumazir kam dagɨabar uan osɨmtɨzim akɨram. Eghtɨ araziba tuisɨzir gumazim dagɨar kabar amamangatɨghtɨ, gɨn amizir kamɨn pam da iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Eghtɨ amizim osɨmtɨzim inightɨ, ia bizir kam ikaragh osɨmtɨzim gumazir a mɨsoghezim datɨgh. Amizim aremeghtɨ, ia gumazir kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Egh an damazim, atarim, agharim, o suem ikuvightɨ, ia kamaghɨra da ikarvagh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Eghtɨ gumazim amizir kam avimɨn an mɨkarzim daboroghtɨ, ia an mɨkarzim daborogh. Eghtɨ an an mɨkarzim gasɨghasɨghtɨ duam otoghtɨ, ia kamaghɨra a ikaragh. Egh a benimɨn a mɨsueghtɨ, kamaghɨra ia benimɨn a ikaragh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Egh gumazitam uan ingangarir gumazim o ingangarir amizim damazim mɨsueghtɨ a ikuvightɨ, a ua an ingangarir gumazim o amizimɨn mɨn ikian kogham. Gumazir kam aneteghtɨ a mangɨ. Kar damazir asɨghasɨzir ivezim. ");
INSERT INTO msy2020_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Egh a ingangarir gumazim o amizim mɨsoghɨva an atarim asigh, egh aneteghtɨ a mangɨ. Kar atarimɨn ivezim.” ");
INSERT INTO msy2020_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ikiavɨra Itir God kamaghɨn mɨgei, “Bulmakaun tam uan komɨn gumazitam o amizitam bɨraghtɨ an aremeghtɨ, ia bulmakaun kam mɨsueghtɨ an aremegh. Eghtɨ ia an tuzim aman markɨ. Eghtɨ bulmakaun ghuavim, an osɨmtɨzim inian kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Bulmakaun kam gumazamizibagh inivɨra ikɨtɨ, gumazamiziba pamtemɨn an ghuavim mɨkɨmtɨ, an ghuavim a isɨva dɨvazimɨn anetɨghan koghtɨ, bulmakau tav mɨsueghtɨ an aremegham, eghtɨ ia kamaghɨn damu. Ia bulmakaun kam ko an ghuavim, aning mɨsueghtɨ, aning aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Eghtɨ gumazir araziba tuisɨzim amamangatɨgh dagɨabar ivezir dɨbobonim dɨboroghtɨ, gumazir kam gumazir aremezim bagh an adarazi me givezam. Arazir kamɨn bulmakaun kam arazir kuram givezegh, uaghan a uabɨ angamɨra ikɨsɨ a uabɨ givezam. A kamaghɨn damigh an ovengeghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Bulmakaun tam, otaritam o guivitam mɨsueghtɨ an aremeghtɨ, ia arazir kamra gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Egh bulmakaun tam ingangarir gumazim o ingangarir amizir kɨnitam mɨsueghtɨ an aremeghtɨ, bulmakaun kamɨn ghuavim, 30plan silvan dagɨaba isɨ ingangarir gumazimɨn gumazir dapanim danɨngam. Egh ia dagɨabar bulmakaun kam ginivightɨ, an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Egh gumazitam nguazimɨn itir mozim avarazir biziba angarigh, o mozim gɨkuigh, egh anevaraghan koghtɨ, bulmakaun tam o donkin tam izɨ mozir kamɨn magɨrɨgh aremegham, ");
INSERT INTO msy2020_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","eghtɨ gumazir mozim gukuizim asɨzimɨn ghuavim givezam. Egh a uabɨ asɨzir kamɨn kuam iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Eghtɨ gumazitamɨn bulmakau gumazir igharazimɨn bulmakau mɨsueghtɨ an aremeghtɨ, aning gumazir igharazitamɨn amamangatɨghtɨ, a bulmakaun angamɨra itir kam givesegh. Egh aning dagɨar kaba ko bulmakaun aremezimɨn asɨziba uaning tuiragh, uaning danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Eghtɨ gumazamiziba fogh suam, bulmakaun kam an asɨzibav sozir bulmakau. An ghuavim deragh dɨvazimɨn aven a geghuvan koghɨva, a bulmakaun angamɨra itim isɨ gumazir igharazim danɨngam. Egh a uabɨ bulmakaun aremezimɨn asɨzim iniam.” ");
INSERT INTO msy2020_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Gumazitam bulmakaun tam o sipsip tam okemegh a mɨsueghtɨ an aremegham, o anemadaghtɨ me a givezegham, eghtɨ ia a damightɨ, a 5plan bulmakaubar bulmakaun kam ikaragham, o a 4plan sipsipbar sipsipɨn kam ikaragham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Kamaghɨn a deraghvɨra da ikarvagham. A ikarvaghamin bulmakauba o sipsipba puvatɨghtɨ, ia aneteghtɨ, gumazir igharazitam ingangarir gumazir kɨnimɨn mɨn a givezeghtɨ, ia dagɨar kaba inigh asɨzir an okemezir kam ikarvagham. Egh an okemezir bulmakau o donki o sipsip an dafarimɨn ikɨvɨra ikɨtɨ, a pumuningɨn ivezim uam a gisɨn aning inigh uan okɨmakɨam ikarvagham. “Okɨmakɨar gumazim dɨmagarimɨn dɨpenimɨn tiar akamɨn aven mangɨsɨ damutɨ, dɨpenimɨn ghuavim an suiragh, a mɨsueghtɨ an aremegham, eghtɨ gumazir kam osɨmtɨziba puvatɨgham. An aruemɨn a mɨsueghɨva egh osɨmtɨzim ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Gumazitam uan bulmakauba ateghtɨ da mangɨ an nguazim ko an wainɨn azenimɨn tintinibar daru damɨva, mɨtaghniamɨn ikiavkɨnigh gumazir igharazimɨn azenimɨn daghebar ameghtɨ, bulmakaubar ghuavim uan azenimɨn dagher aghuariba da ikarvagham. Egh uaghan wainɨn ovɨziba gumazir kam ikarvagh a danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Gumazitam uan dadam daboroghtɨ avim isi bar ekevegh mangɨ, mɨtaghniamɨn ikiavkɨnigh gumazir igharazimɨn witɨn azenim, o witɨn me dɨghora pozim mɨkɨnizibar isightɨ, gumazir avim atɨzir kam, bizir isizir kaba bar da ikarvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Gumazitam dagɨataba o bizir igharazitaba isɨ uan namakam danightɨ a dar gan ikɨtɨ, okɨmakɨar gumazitam bizir kaba okemegham, gɨn me okɨmakɨar gumazimɨn suiraghtɨ, okɨmakɨar gumazir kam bizir pumuning pumuningɨn dagɨaba ko bizir an okemeziba ikarvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","“Egh me okɨmakɨar gumazim inighan koghtɨ, ia gumazir bizibar garim inigh na bagh izɨ anetɨghtɨ, a nan damazimɨn mɨtɨgh. Egh a kamaghɨn mɨkɨm suam, ‘Kɨ guizbangɨra, bizir kaba okemezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Egh dughiaba zurara gumazitam uan namakam ko bizir kabagh nɨghnɨgh uaning adogham. Aning bulmakauba, donkiba, sipsipba, korotiaba o bizir igharazibagh nɨghnɨgh, uaning mɨkɨmɨva tav suam, ‘Kar nan bizimra,’ eghtɨ ia aning inigh izɨtɨ aning nan damazimɨn tughtɨ kɨ aning baragh suam, kav ifari. Eghtɨ gumazir ifarir kam bizir pumuning pumuning ikarvagh namakam danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Eghtɨ gumazitam donki, bulmakau, sipsip, ko asɨzir igharazitam, a isɨ uan namakatam danɨngightɨ ana bagh a damuam. Eghtɨ asɨzir kam osɨmtɨzitam a batogham, o an ovegham, o apaniba uariv sogh mɨdorozimɨn tongɨn asɨzir kam modogh a inigh mangɨghtɨ, gumazitam an ganighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Egh aning na bagh izɨ nan damazimɨn mɨtɨgh, egh namakar asɨzimɨn garim Ikiavɨra Itir Godɨn ziam a dɨpon suam, ‘Bar guizbangɨra, kɨ nɨn asɨzitam gasɨghasɨghizir puvatɨgha, tam okemezir puvatɨ.’ Eghtɨ asɨzimɨn ghuavim an mɨgɨrɨgɨam baregh ifuegham. Eghtɨ an namakar kam asɨzir ovengezir kam ikarvaghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Eghtɨ okɨmakɨar gumazitam asɨzir kam okemeghtɨ, namakar kam, an asɨzim ikarvagh ivezim asɨzir ghuavim danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Asɨzir atiatam asɨzir kam mɨsueghtɨ, namakam asɨzir tuzir dughoraghirezir tam o agharir tam inigh namakamɨn akagham. Eghtɨ ana asɨzir kam ikarvaghsɨ dagɨatabar anɨngan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Gumazitam uan bulmakau ateghtɨ an namakam ingangarim bagh a inightɨ, egh dughiar bulmakaun ghuavim itir puvatɨzimɨn, bulmakaun kam osɨmtɨzim batogham o ana aremeghtɨ, gumazir kam asɨzimɨn ghuavim givezam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Eghtɨ bulmakaun ghuavim uan namakam ko ikɨtɨ, bulmakau osɨmtɨzim batoghtɨ namakam a givezan kogham. Egh namakam faragh dagɨar akuatam ingangarim bagh bulmakau inightɨ, bulmakau osɨmtɨzim batoghtɨ an a givezan kogham. Guizbangɨra, dagɨar a faragha anɨngizim ana givezegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ezɨ Ikiavɨra Itir God ua kamaghɨn mɨgei, “Gumazitam guivir igiamɨn garima, a gumaziba ko akuizir puvatɨzɨ, me gumazitam bagha a ginabazir puvatɨ, gumazir kam a inigh a gakaghonegh a ko dakuighɨva, gumazir kam an ikɨsɨ ivezim isɨ guivimɨn afeziam givezeghɨva, amizir kamɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Eghtɨ guivir kamɨn afeziam gumazir kamɨn aghuaghtɨ, gumazir kam uabɨ dagɨaba isɨ amizimɨn afeziam givezam. Ivezir kamɨn dɨbobonim, a ivezir amizim gumazitam ko akuizir puvatɨzimɨn mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ia imezibagh amir amizibav sueghtɨ me arɨmɨghiregh. ");
INSERT INTO msy2020_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Gumazitam, amizim ko akuir arazim, asɨzir amebatam ko a damightɨ, ia a mɨsueghtɨ an aremegh. Amizitam, gumazim ko akuir arazim, asɨzir apurim ko a damightɨ, ia a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Eghtɨ tav asem bagh ofa damigh egh an ziam feghtɨ, ia a mɨsueghtɨ an aremegh. Ia Ikiavɨra Itir God baghvɨra ofa damu, egh an ziamra fɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Ia kantrin igharazimɨn gumazir ia ko ititam pazɨva a damuan markɨ, egh osɨmtɨzim a darɨghan kogham. Ia fo, ia faragha an mɨn kamaghɨra Isipɨn kantrin ike. ");
INSERT INTO msy2020_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ia pazɨva amizir pam aremezim damuan markɨ, egh uaghan borir afeziam aremezim pazɨva a damuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ia pazɨ me damutɨ, me akurvazim bagh na bagh arangtɨ, kɨ men dɨmdiam baragham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Egh kɨ navim ikuvigh, gumazir kurabar amightɨ, me izɨ ia mɨsoghtɨ, ia arɨmɨghiregham. Kamaghɨn, ia uaghan amuiba paba puvatɨgham, eghtɨ ian boriba afeziaba puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Nan gumazamizir dagɨaba ko biziba bar puvatɨziba, men tav ia da dagɨataba inightɨ ia me danɨng nɨghnɨgh suam, a gɨn ua ia ikarvagham. Ia gumazir dagɨar ingangaribagh amibar mɨn, gumazir kaba da, dagɨar kaba ua da iniva, dagɨataba uam a gisɨn darɨghan markɨ, Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Gumazir tam ian dagɨaba inigh uan korotiar azenimɨn azuim isɨ ia danɨng mɨkɨm suam, korotiar kam kamaghɨn ian aka, a gɨn dagɨar kaba ua da ikaragham. Eghtɨ ia uam an korotiar azenan azuim, dughiar kamra aruem tɨghar magɨram, ia uam a danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Guizbangɨra, a bar korotiar azenimɨn azuir kamra iti. Egh dɨmagarimɨn a fefem a danɨngtɨ, an arugharughan kogham. Eghtɨ nɨ korotiar azenimɨn azuir ruarimɨn suiraghtɨ, a bizir tizimɨn uan mɨkarzim avaragh dakuam? Kɨ gumazamiziba bar men apangkufi. Kamaghɨn, gumazir kam uabɨn akurvaghsɨ na mɨkɨmtɨ, kɨ an mɨgɨrɨgɨam baragham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Ia God, akar kuraba a mɨkɨman kogham. Egh ia akar kuratam uan gumazir dapanitam mɨkɨman kogh, an ziam gasɨghasɨghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ia uan witɨn faragha zuiba, ko wainɨn dɨpar faragha zuiba, ko olivɨn borer faragha zuiba, ia nan anogoroghan markɨ. Egh ia da inigh ofan mɨn nan ziam fɨsɨ na danɨng. Egh ia uan otarir ivariaba na danɨng. ");
INSERT INTO msy2020_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ia uaghan uan bulmakaun faragha otiviziba ko sipsipɨn faragha otiviziba na bagh ofa damu. Bulmakaun nguzim ko sipsipɨn nguzim 7plan aruebar uan amebam ko ikeghtɨ, namba 8ɨn dughiam, ia a mɨsueghɨva na bagh ofa damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Guizbangɨra, ia nan gumazamizibara. Kamaghɨn amizɨ, asɨzir atiatam mɨsogha dughoraghsuezir asɨzim, ia an tuzitam aman markɨ. Ia an tuziba isɨ afiabar anɨng.” ");
INSERT INTO msy2020_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Moses Ikiavɨra Itir Godɨn akam kamaghɨn anekuri, “Nɨ bizir otozitam baraghizɨ, a guizɨn akam puvatɨ, nɨ bizir kam tintinibar a mɨkɨman markɨ. Gumazitam arazir kuratam damightɨ, osɨmtɨzim an ikɨtɨ, nɨ kotɨn aven akar ifavaribav kɨmɨva an akurvaghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Gumazir avɨriba arazir kurabar amutɨ, nɨ men arazibar gɨn mangan markɨ. Eghtɨ gumazir avɨriba kotiamɨn mangɨva, kotiam gifaramin mɨgɨrɨgɨabav kɨmtɨ, nɨ men arazir kabar gɨn mangan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Gumazitaba gumazir biziba puvatɨzim kotiam datɨghtɨ, a uabɨn akurvaghsɨ nɨ inightɨ, nɨ gumazir biziba puvatɨzimɨn akurvaghsɨ ifavarir mɨgɨrɨgɨabav kɨman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Eghtɨ nɨn apanimɨn donki o bulmakau dɨvazim ategh pura darutɨ, nɨ an ganigh, uam a inigh gumazir kam bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nɨ gumazir ian aghuazimɨn donkin gantɨ, a bizir osɨmtɨziba ater irɨghɨv ikɨtɨ, nɨ gumazir kamɨn akuragh uam an donki ghufegh. Nɨ aneteghtɨ a nguazimɨn irɨghɨv ikian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Gumazir biziba puvatɨzitam kotiamɨn mangɨtɨ, ia kotiamɨn aven a gifarɨva a dɨkabɨnan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Nɨ mɨgɨrɨgɨar ifavaribar gumazim gasɨva a isɨ kotiam darɨghan markɨ. Egh gumazir aghuarim arazir kuratam damighan koghtɨ, ia isɨ kotiam datɨghɨva, nɨ puram a mɨsueghtɨ an aremeghan markɨ. Guizbangɨra, gumazir arazir kurar kam gamim, an osɨmtɨzim ikɨvɨra ikɨtɨ kɨ a isɨ kotiam datɨghtɨ, an ovengam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Gumazitam ia apezeper kotiam gifarɨsɨva dagɨaba ia danɨngtɨ, ia dagɨar kaba inian markɨ. Guizbangɨra, arazir kam gumazir dapanibar damaziba apɨrizɨ me deravɨra nɨghnɨzir puvatɨ. Egha arazir kam uaghan gumazir aghuarir osɨmtɨziba puvatɨzibar kotiam gasɨghasɨsi. ");
INSERT INTO msy2020_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Kantrin igharazibar gumazamizir ia ko itiba ia pazɨ me damuan markɨ. Guizbangɨra, ia uari faragha uan kantri ategha Isipɨn kantrin ikegha, Kantrin Igharazibar Gumazamizibar navir averiabagh fogha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ezɨ Moses Ikiavɨra Itir Godɨn akam isa Israelia mɨgei, “Ia azenibar dagheba oparɨva, dagheba iniamin dughiamɨn da asi pozibav kɨn, mangɨ 6plan azenibar otifigh. ");
INSERT INTO msy2020_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Eghtɨ namba 7ɨn azenimɨn ia nguazim ateghtɨ an avughsɨ pura ikɨ. Egh ia an otivir dagheba inian markɨ. Nɨ uaghan arazir kamra wainɨn azenim ko olivɨn azenim damu. Eghtɨ biziba puvatɨzir gumazamizibara, azenir kabar dagheba iniam. Egh gumazir biziba puvatɨziba, me dagher naba ateghtɨma, asɨzir atiaba dagher kabar amɨ da gɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Eghtɨ wikba bar nɨ 6plan dughiabar uan ingangaribar amu, egh namba 7ɨn dughiam nɨ ingaran markɨ. Nɨ avughsɨ. Eghtɨ arazir kamɨn nɨn donki, bulmakau, ko ingangarir gumazir an amebam nɨn dɨpenimɨn a batezim, ko Kantrin Igharazibar Gumazamizir nɨ ko itiba, me bar avughsɨ, egh deraghvɨra ua gavgavir igiam iniam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Nɨ deraghvɨra oreghɨva nan akar kɨ nɨ ganɨngizibar gɨn mangɨ. Egh ia asebar ziaba dɨponan markɨ. Egh me ko mɨkɨman markɨ. Bar markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ezɨ Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia azeniba vaghvagh dar dughiar 3plan na bagh isam damu nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Kɨ Akar Gavgavimɨn ia mɨkemezɨ moghɨn, ia Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam a damuva, uari akuvagh nan ziam fɨ. Egh dughiar kɨ Abipɨn iakɨnimɨn inabazimɨn, ia 7plan dughiabar, yis puvatɨzir bretra amɨ. Ia fo, iakɨnir kamra ia Isipɨn kantri ataki. Egh ia na bagh izɨsɨ dafarir kɨnibar izan markɨ. Ia izɨ nan ziam fɨsɨ, na bagh ofan taba inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Egh uaghan ia Azenibar Dagher Igiaba Asiamin Dughiamɨn ia na bagh isam damu. Dughiar ia witɨn faragha aniba iniamim, isar ekiar kam otogham. “Egh ia Averpenibar Ikɨ Dagher Abuananaba Asiamin Dughiam, ia na bagh isam damu. Ia iakɨnir iter ovɨziba anir dughiamɨn, ia dagher abuananaba asigh dar pozibav kɨnigh, egh isar kam damu. ");
INSERT INTO msy2020_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Egh azeniba vaghvagh, dughiar 3plan kaba, ian gumazamiziba bar izɨ, egh ia nan ziam fɨsɨ, nan damazimɨn otogh, kɨ Ikiavɨra Itir Godɨn ian Ekiam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Egh ia asɨzim isɨ na bagh ofa damuva, egh an ghuzim isɨ na danɨngɨsɨ, ia Bret Yis itim sara ofa damuan markɨ. Ia asɨzir ofa damuamimɨn oviba bar da tuegh. Egh ia oviba ateghtɨ da ikɨ mangɨ amɨmzaraghan otivan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ia dagher faragha asiba, dar dagher bar aghuibara, ia da inigh nan Dɨpenimɨn mangɨ ofan mɨn, kɨ Ikiavɨra Itir God, ian God, da na danɨng. “Egh ia memen nguzitam isɨ mɨnem darugh, an amebamɨn oter eborim sara anevighan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ezɨ Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia oragh. Kɨ enselɨn mam amadaghtɨ a tuavimɨn ia ko mangɨ ia geghuv, ian aku mangɨ kantrin kɨ ia bagha dɨkɨrɨzimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ia deragh an akam baragh, egh an gɨn mangɨ. Egh ia an akam batoghan kogham. Guizbangɨra, nan gavgavim a ko iti, eghtɨ a gumazamizir an akaba batozibar arazir kuraba gɨn amangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ia an akamɨn gɨn mangɨgh, egh bizir kɨ mɨkemezibar amightɨ, kɨ ian apanibar apanimɨn mɨn otogh me mɨsogham. Eghtɨ gumazir ia adogha ia batoziba, kɨ me adogh me batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Eghtɨ nan ensel ian faragh mangɨva, ia inigh Amorian nguazimɨn aven mangɨ, egh Hitia, Peresia, Kenania, Hivia, ko Jebusia, men nguaziba bar dar aven mangam. Egh kɨ bar me kuavaremegham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ia teviba pɨrigh men asebar ziaba fan markɨ. Egh ia men asebar ziaba fer araziba inian kogham. Egh ia men asebar marvir guaba da kuntɨ da irɨtɨ, ia dagh asɨghasɨgh. Egh guarir akɨnir men ofa gamir dakozibar tuivav itiba, da a bɨghɨva da mɨsarɨrarɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Egh ia nan ziamra fɨ, kɨrara Ikiavɨra Itir God, ian God. Ia kamaghɨn damutɨ, kɨ bar deraghvɨra ia damuva, dagheba ko dɨpaba ia danɨngɨva, ia dam arɨmariaba batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Egh kɨ amiziba ateghtɨ me deraghvɨra boriba batam. Egh kɨ amizir paba itibar, naviba apɨran kogham. Eghtɨ me bar boriba batam. Ia zuamɨra ovengan kogham. Puvatɨ. Kɨ ia ateghtɨ, ia dughiar ruarimɨn nguazir kamɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Egh kɨ ian faragh mangɨ, egh atiatir ekiam ian apanibar atɨgh, me damutɨ me akong tintinibar nɨghnɨgh onganigham. Eghtɨ kɨ me damightɨ me ian aregham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Egh kɨ gumazibagh ivir apariba amadaghtɨ da ian faragh mangɨ Hivia, Kenania ko Hitia givi me batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Kɨ azenir vamɨran me batueghan kogham. Kɨ kamaghɨn damightɨ, nguazim pura ikɨtɨ asɨzir atiaba avɨrasemegh an ikɨ, ia gasɨghasɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Kɨ ian apaniba nɨmɨra nɨmɨra me batogh mangɨ, dughiar ia avɨrasemeghamim, ia nguazir kam bar a inigham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Eghtɨ kɨ ian mɨtaghniaba arɨghtɨ ian nguazimɨn mɨtaghniam, Akaban Dɨpamɨn boroghɨn itir Ongarir Aghevimɨn ikegh mangɨ, Mediterenianɨn Ongarir Ekiamɨn tugham. Egh gumazamiziba puvatɨzir danganimɨn ikegh mangɨ, Yufretisɨn Fanemɨn tugham. Egh kɨ gavgavim ia danɨngtɨ nguazir kamɨn itir gumazamiziba, ia me gafiragham. Eghtɨ ia kantrin kamɨn aven mangɨ, me batueghtɨ me mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ia me ko akar dɨkɨrɨzir gavgavitam damuan markɨ, egh uaghan men aseba ko akar dɨkɨrɨzir gavgavitam damuan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Egh ia me ateghtɨ, me ian kantrin ikian markɨ. Puvatɨghtɨ me ia damightɨ ia arazir kuram na damigham. Egh ia men asebar ziaba feghtɨ, arazir kam azuazimɨn mɨn ia mɨsueghtɨ ia irɨ bar gevegham.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Kɨ kamaghsua, Nɨ, Aron, Nadap, Abihu, ko Israelian gumazir 70plan gumazir dapaniba, ia mɨghsɨamɨn anang na bagh izɨ. Egh ia tong saghon ikɨva, tevimning apɨrigh guam nguazimɨn anebɨragh nan ziam fɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Eghtɨ Moses uabɨra, Ikiavɨra Itir God bagh izɨ. Gumazir dapanir igharaziba nan boroghɨn izan markɨ. Eghtɨ gumazamiziba Moses ko anangan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Ezɨ Moses ghua Ikiavɨra Itir Godɨn mɨgɨrɨgɨaba ko arazir e gɨn mangɨ damuamiba, bar gumazamizibav mɨkeme. Ezɨ me oregha bar kamaghɨn mɨgei, “Bizir Ikiavɨra Itir God damuasa e mɨkemeziba bar, e dar amuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Egha Moses Ikiavɨra Itir Godɨn akaba akɨnafarir mamɨn bar a da osiri. Egha amɨmzaraghan a dɨkavigha ofa gamir dakozim mɨghsɨamɨn apɨnimɨn a gami. Egha ofa gamir dakozir kamɨn boroghɨn, a 12plan dagɨar ruariba ase, da Israelian 12plan anababar ababanim gami. ");
INSERT INTO msy2020_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Egha a Israelian gumazir igiar maba amadazɨ, me ghua ofaba Ikiavɨra Itir God ganɨdi. Ezɨ ofan maba, da asɨzir me avimɨn tuazɨ bar isigha mɨghɨriziba, ezɨ maba da bulmakaun apurir igiaba, gumazamiziba God ko navir vamɨran ikiasava amir ofaba. ");
INSERT INTO msy2020_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ezɨ me a gamigha gɨvazɨma, Moses bulmakaubar ghuziba inigha, ghuziba tuiragha maba isa itarir ekiabagh arɨsi. Egha ghuzir nar ikiavɨra itiba an ada isa ofa gamir dakozimɨn da kavamadi. ");
INSERT INTO msy2020_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Egha an akɨnafarir Akar Dɨkɨrɨzir Gavgavim aven itim, inigha gumazamiziba bagha a dɨbori. Ezɨ me a baregha, me bar kamaghɨn mɨgei, “Bizir Ikiavɨra Itir God e mɨkemeziba, e bar dar amuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Egha Moses ghuzim inigha, gumazamizibagh isɨn a kavamadi. Egha kamaghɨn me mɨgei, “Ghuzir kamra, Ikiavɨra Itir God, Akar Dɨkɨrɨzir Gavgavir kam, ia koma a gami, ezɨ ghuzir kam gavgavim a ganɨdi. Ezɨ Akar Dɨkɨrɨzir Gavgavir kam, arazir God ia ganɨngiziba, a dagh isɨn tu.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Egha gɨn Moses, Aron, Nadap, Abihu, ko Israelian gumazir dapanir 70pla, me mɨghsɨamɨn ghuavanadi. ");
INSERT INTO msy2020_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Egha me Israelian Godɨn gari. Ezɨ an dagarimningɨn apengan bluplan bizir ekiam ikia dagɨar azuarimɨn mɨn gara, egha overiam taghtazi moghɨn angazangari. ");
INSERT INTO msy2020_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Guizbangɨra, me Godɨn gari, ezɨ a me gasɨghasɨghizir puvatɨ. Ezɨ dughiar kam me danganir kamɨn ikia uari inigha apiagha dagheba ko dɨpaba api. ");
INSERT INTO msy2020_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ezɨ gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ na bagh mɨghsɨamɨn anangɨva, nan boroghɨn tugh. Kɨ Osirizir Arazir maba ko, Akar Gavgaviba isa dagɨar akuamningɨn da osiri. Kɨ kamaghsua, nɨ Osirizir Arazir kaba gumazamizibagh eghan men sure damu, kamaghɨn kɨ dagɨar akuar kamning nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ezɨ Moses uan ingangarir gumazim Josua ko uaning akɨrigha, Moses Godɨn mɨghsɨamɨn ghuavanadi. ");
INSERT INTO msy2020_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moses faragha Israelian gumazir dapaniba kamaghɨn me mɨgei, “Ia kaghɨra dapiagh ikɨ, egh ga mɨzuam ikɨtɨ, ga uamategh izam. Aron ko Hur ia ko ikiam. Gumazitaba osɨmtɨziba gumazir igharazibar ikɨva, aning bagh mangɨtɨ, aning da akɨram.” ");
INSERT INTO msy2020_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ezɨ Moses mɨkemegha gɨvagha, Sainain Mɨghsɨamɨn ghuavanadi. Ezɨ ghuariar ekiam mɨghsɨam avara. ");
INSERT INTO msy2020_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Ezɨ Ikiavɨra Itir Godɨn angazangarim mɨghsɨamɨn izaghiri. Ezɨ Israelia Ikiavɨra Itir Godɨn angazangarir kamɨn garima, men damazimɨn avir ekiam mɨghsɨam gisɨn isia iti. Ezɨ ghuariam 6plan dughiabar mɨghsɨam avara. Ezɨ namba 7ɨn dughiam, Ikiavɨra Itir God ghuariamɨn tongɨn ikia Mosesɨn dia. ");
INSERT INTO msy2020_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ezɨ Moses ghuariamɨn aven ghugha, mɨghsɨamɨn bar pɨn ghuavanadi. Egha mɨghsɨamɨn ikia ghua 40plan dughiaba ko dɨmagaribar tu. ");
INSERT INTO msy2020_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Nɨ Israelia mɨkemeghtɨ, me biziba inigh ofan mɨn na danɨng. Gumazamizir uan biziba na danɨngasa naviba dɨkaviba, me da nɨ danɨng. ");
INSERT INTO msy2020_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Eghtɨ nɨ bizir kaba me dama da inigh. Gol, silva, bras ko, ");
INSERT INTO msy2020_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","sipsipɨn arɨzibar ingarizir tretɨn bluplaba, pɨghagheviba, agheviba ko, inir ghurghurir aghuariba, ko inir me memen arɨzibar ingariziba ko, ");
INSERT INTO msy2020_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","sipsipɨn apurimɨn inir me penɨn aghevimɨn aghuiziba ko, ongarimɨn itir asɨzir ekiabar iniba ko, akasɨn temeba ko, ");
INSERT INTO msy2020_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lambagh arɨgha dagh aboir olivɨn borem ko, pauran mughuriar aghuim zuir me olivɨn borem sara verezir God ua bagha inabazir bizibagh ingem, ko pauran mughuriar aghuim gamiba. ");
INSERT INTO msy2020_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Egh dagɨar pɨzir aghuariba ko, dagɨar aghuir ivezim bar pɨn kozir igharaziba inigh, da ofa gamir gumazibar dapanimɨn korotiar otevir azenan itimɨn kurkegh, egh an forivtarir inir an evarimɨn poroghav itim gituigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Egh nɨ gumazamizibav kemeghtɨ, me na bagh Purirpenitamɨn ingarightɨ, kɨ men tongɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Egh ia Purirpenir kamɨn ingarightɨ, bizir an azenan itiba ko aven ikiamiba bar nedazir kɨ nɨ danɨngamimɨn mɨrara ganam.” ");
INSERT INTO msy2020_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Nɨ gumazamizibav kemeghtɨ me akasɨn temer araribar Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn ingarightɨ, an ruarim 110 sentimitan tughtɨ, an arozim 66 sentimitan tughtɨ, an tuirivim 66 sentimitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Eghtɨ ia golɨn aghuarim isɨ an averiam ko azenimɨn poghɨva a nokegh. Egh golɨn ruari tamɨn Boksiamɨn apɨnimɨn mɨriam bar an poghɨva a ikɨraruigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Egh ia Boksiam darugh anetersɨ gol ringɨn 4plan ingarigh, egh a tuivamin suer 4plan boroghɨn gol ringɨn 4pla arigh, egh 4plan suebagh ikegh. Egh pumuning isɨ Boksiamɨn vongɨn aning ikegh, pumuning vongɨn aning ikegh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Egh ia Boksiam atersɨ akasɨn iter otevir pumuning inigh, egh deragh aning akɨrigh. Egh ia golrama aning poghɨva aning nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Egh ia Boksiam atersɨ iter otevir kamning isɨ, tam vongɨn an ringning darugh, egh tam vongɨn an ringning darugh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Eghtɨ iter otevir kamning zurara ringbar ikɨ kamaghɨra ikɨ. Ia aning asian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Eghtɨ kɨ gɨn Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuamning isɨ nɨ danightɨ nɨ aning isɨ Boksiamɨn aven aning atɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Egh ia Boksiamɨn asuam golɨn aghuarimɨn an ingarightɨ, an ruarim 110 sentimitan tughtɨ, an arozim 66 sentimitan tugh. Danganir kam, kar gumazamizibar arazir kuraba gɨn amangamin danganim. ");
INSERT INTO msy2020_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Egh ia golɨn taba inigh, haman dav suegh, egh enselɨn bar gavgavir pumuningɨn nedazimningɨn ingarigh. Eghtɨ enselning Boksiamɨn asuam gisɨn tughɨv ikɨ, tav vongɨn ikɨtɨ, tav vongɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Eghtɨ tam Boksiamɨn asuamɨn agharir guvimɨn tughtɨ, tam agharir kɨriamɨn tugh. Ia golɨn tam inigh, egh enselɨn bar gavgavir kamningɨn nedazim ko Boksiamɨn asuam danganir kamran dar ingarigh. Eghtɨ da bizir vamɨran mɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Eghtɨ enselɨn bar gavgavir pumuningɨn nedazim arazir kuraba gɨn amadir danganimɨn tughɨv ikiam, eghtɨ aningɨn guamning uaningɨn akuigh aviragh Boksiamɨn gan. Eghtɨ aningɨn avɨzimning kuighirɨgh ikɨ, Boksiamɨn asuam avaragham. ");
INSERT INTO msy2020_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Eghtɨ kɨ Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuar kamning nɨ danightɨ, nɨ aning isɨ Boksiamɨn aven aning atɨgh, egh Boksiamɨn asuam dukuagh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Eghtɨ kɨ danganir arazir kuraba gɨn amadir kamɨn, enselɨn bar gavgavimningɨn nedazimningɨn tongɨn Boksiamɨn asuam gisɨn nɨ bativam. Egh kɨ uan Akar Gavgaviba nɨ danɨngam. Eghtɨ nɨ nan Akar Gavgaviba Israelia danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ezɨ Ikiavɨra Itir God kamaghɨn mɨgei, “Ia akasɨn tememɨn dakozir tamɨn ingarigh, eghtɨ an ruarim 88 sentimitan tughtɨ, an arozim 44 sentimitan tugh, eghtɨ an tuirivim 66 sentimitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","25","Egh ia dakozir kam golɨn aghuarimɨn an poghɨva a nokegh, egh golɨn ruaritamɨn an mɨriamɨn poghɨva bar a ikɨraruigh. Ia golɨn ruarir kam damightɨ a tong fɨgh anabogh, egh dakozimɨn apɨniba bar da inigh, eghtɨ an tuirivim 8 sentimitan tugh. Eghtɨ ia golɨn ruarir kamɨn, an mɨriamɨn golɨn igharazitamɨn an adiarim damigh golɨn ruarir kam bar an poghɨva a ikɨraruigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","27","Egh ia gol ringɨn 4plan ingarigh dakozimɨn mɨkebabar suebar boroghɨn da ikegh. Eghtɨ 4plan gol ringɨn kaba dakozimɨn apɨnimɨn boroghɨra ikiam. Da akasɨn temer dakozim ateramningɨn suigham. ");
INSERT INTO msy2020_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Egh ia akasɨn iter otevir pumuning isɨ dakozim atersɨ deragh aning akɨrigh, egh golrama aningɨn poghɨva aning nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Egh ia, ofa damuamin wain fusfughamin itarir ekiaba ko doziba, kapba, ko botolba, ia golɨn aghuimra bizir kabar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Egh ia zurara bretɨn na danɨngamim, a isɨ dakozir kam datɨghtɨ, a nan damazimɨn ikɨvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ezɨ Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia golɨn aghuarim inigh lamɨn aghorimɨn ingarigh. Egh haman golɨn kam mɨsuegh egh lamɨn aghorim asamin mɨngarimɨn ingarigh, egh lambar agharibar ingarighɨva, dar afamin danganibar boroghɨn, akɨmarir tɨghar onamiba ko onezibar ingarigh. Egh biziba bar dar arightɨ da bizir vamɨran mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Eghtɨ lamba afamin aghorir kam 6plan aghariba ikɨ, eghtɨ 3pla vongɨn ikɨtɨ, 3pla vongɨn ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Eghtɨ lamba afamin aghorir kam, 6plan aghariba vaghvagh akɨmarir 3pla ikɨ, eghtɨ da lamɨn kabar apengan ikiam. Eghtɨ lamɨn aghariba bar kamaghɨra ganam. Eghtɨ akɨmaribar ganganiba amonɨn tememɨn akɨmaribar mɨn ganam. ");
INSERT INTO msy2020_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Eghtɨ lamɨn aghorim uabɨ kamaghɨn ganam, ia akɨmarir 4pla ingarightɨ da amonɨn tememɨn akɨmaribar mɨn, taba tɨghar onamibar mɨn gantɨ, taba onezibar mɨn gan. ");
INSERT INTO msy2020_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Egh agharir pumuning uaningɨn akuizɨ naghɨn ia akɨmarir dafarir muziarir kabar ingarigh. Egh agharir igharaziba uaghan kamaghɨra dar amu. ");
INSERT INTO msy2020_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Egh ia hama inigh golɨn aghuir kam mɨsuegh, egh bizir kabar amightɨ da bizir vamɨran mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Egh ia 7plan lambar ingarigh, da isɨ dar agharibar arɨkigh. Egh deravɨra da aseghtɨ, dar angazangarim siragh deragh nan Purirpenimɨn averiam gisiragh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Egh golɨn aghuariba inigh, egh akamimɨn mɨn avimɨn suizir bizitabar ingarigh egh uaghan itaribar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ia 35 kilogremɨn golɨn aghuariba inigh, egh lamba afamin aghorim ko, lamba ko, an ingangarir bizir kaba, bar dar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Egh nɨ deraghvɨra dar ganigh, egh nedazir kɨ mɨghsɨar kamɨn nɨn akazimɨn gɨn mangɨva, ia bizir kabar ingarigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia na bagh Purirpenir tam 10plan inir ghurghurir aghuibar an ingarigh. Nir kaba ia tretɨn bluplaba ko, pɨghagheviba ko, agheviba inigh enselɨn bar gavgavibar nedaziba isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Egh 10plan inir kabar ingarightɨ dar oteviba bar voroghɨra mangɨ. Eghtɨ dar ruariba 12 mitan tughtɨ, dar aroziba 2 mitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Egh da arueghsɨ, ia 5plan iniba dar akuigh ua da isamigh. Egh 5plan mabar akuigh ua kamaghɨra da isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Egh bluplan tretɨn rɨghizir kuzir taba, inimning uaningɨn sasuighsɨ aningɨn mɨriamningɨn da isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Egh 50plan tretɨn irɨghizir kuziba, inir faragha itimɨn mɨriam gituigh, egh 50plan tretɨn irɨghizir kuziba namba 2ɨn inim kamaghɨra da a gituightɨ, dar kuziba voroghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Egh ia 50plan golɨn akezibar ingarightɨ, da inir ruarir kamningɨn kuziba isafuragh da ikeghtɨ, aning Purirpenir vamɨran otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Egh gɨn ia memen arɨzibar inir 11plan ingarightɨ, da Purirpenim avamin inir ekiar vamɨran otogh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Eghtɨ inir kaba vaghvagh dar ruariba 13 mitan tughtɨ, dar aroziba 2 mitan tugh. Eghtɨ dar ababanim voroghɨra mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Egh da arueghsɨ me 5plan iniba uari isafuragh da isamightɨ, da inir ekiar vamɨran otogham. Egh 6pla iniba isafuragh da isamightɨ da inir ekiar vamɨran otogham. Egh namba 2ɨn inir isamizir kam, an namba 6ɨn inir otevir kam an otevim remegh Purirpenimɨn tiam avaragh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Egh 50plan tretɨn irɨghizir kuziba, inir faragha itimɨn mɨriam gituigh, egh 50pla tretɨn irɨghizir kuziba inir namba 2ɨn mɨriamɨn dagh ituigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Egh 50plan brasɨn akezibar ingarigh, egh akeziba isɨ tretɨn irɨghizir kuzir kabar aghuigh, egh inir kamning uaning isafuraghtɨ inir ekiar vamɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Eghtɨ inir ruarir kamɨn 1 mitan pura itimɨn, ia Purirpenimɨn gɨrakɨrangɨn aneguraghtɨ a magɨrɨ nguazim girɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Eghtɨ inir Purirpenim avamim, an ruarim, aven itir inimɨn ruarim gafiragh 50 sentimita vong ko vongɨn ikiam. Eghtɨ inir nar pura ikiamim Purirpenir kam bar anevaragh magɨrɨ nguazim girɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Egh ia Purirpenim avɨsɨ sipsipɨn apuribar inir me penɨn aghevimɨn aghuizimɨn inimɨn ingarigh. Egh a gisɨn darɨghsɨ ongarimɨn asɨzir ekiamɨn inim inimɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Egh ia akasɨn temebar Purirpenimɨn bɨrir agharibar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Eghtɨ bɨrir agharibar ruarim 4 mitan tugh, eghtɨ iter otevir agharibagh iniva ghueziba, 66 sentimitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Egh ia iter akɨnir pumuning mɨngarimning akɨrigh, egh silvan boksiamning gisɨn aning asaragh. Egh ia Purirpenimɨn bɨrir aghariba bar kamaghɨra dar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Egh ia sautɨn amadaghan Purirpenimɨn 20plan bɨrir agharibar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Egh ia silva inigh 40pla boksiar torir muziariba itibar ingarigh, egh bɨrir aghariba dagh asam. Eghtɨ boksiar pumuning bɨrir agharir vamɨran apebamɨn ikiam, egh bɨrir agharimɨn povim gavgavim a danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Egh ia kamaghɨra uaghan notɨn amadaghan bɨrir agharibar ingarigh. Egh 20pla bɨrir agharibar ingarigh, egh bɨrir agharibar poviba gavgavim dar anɨngsɨ, ia 40plan silvan boksiabar ingarigh. Egh silvan boksiar pumuning gisɨn bɨrir aghariba vaghvagh da asɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Egh 6plan bɨrir aghariba Purirpenimɨn gɨrakɨrangɨn aruem ghuaghiri naghɨn dar ingarigh, ");
INSERT INTO msy2020_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","egh bɨrir agharir pumuning Purirpenimɨn gɨrakɨrangɨn itir mɨkebamningɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Eghtɨ mɨkebamningɨn itir bɨrir agharimning vɨn uaningɨn akuigh mavanang bar pɨn otogh. Egh bɨrir agharir kamning uaning inigh ghuanang ringɨn vamɨran aven mangɨ voroghɨra ikɨ. Egh mɨkebar igharazim kamaghɨra a damu. ");
INSERT INTO msy2020_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Eghtɨ gɨrakɨrangɨn 8plan bɨrir aghariba ikiam, eghtɨ 16plan silvan boksiaba da bɨrir agharibar povibar suigham, eghtɨ boksiar pumuning, bɨrir aghariba vaghvagh dar tuivam. ");
INSERT INTO msy2020_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Egh ia akasɨn temer ruariba inigh, egh dar ighuvir ruaribar ingarigh. Egh notɨn itir bɨrir aghariba bagh 5plan ighuvibar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Egh sautɨn itir bɨrir aghariba bagh 5plan ighuvibar ingarigh, egh aruem uaghiri naghɨn itir bɨrir aghariba bagh 5plan ighuvibar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","29","Egh ia ringbar ingarigh vaghvagh bɨrir agharibar tongɨra dar arɨkigh, egh gɨn ighuvir ruarir kaba isɨ ringbar aghu mangɨ, Purirpenimɨn mɨkebar mamɨn ikegh mangɨ mamɨn tugh. Egh ia bɨrir aghariba ko ringba ko ighuvir ruariba, golra bar da nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Egh ia gɨn Purirpenir kam asaraghtɨ, a nedazir kɨ mɨghsɨamɨn nɨn akazimɨn mɨrara ganam. ");
INSERT INTO msy2020_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Egh ia inir aghuarir ekiatamɨn ingarigh, egh Purirpenimɨn aven aneguragh. Ia inir kam, tretɨn blupla ko, pɨghaghevim ko aghevir me sipsipɨn arɨzimɨn ingarizimɨn a isamigh. Egh ia deraghvɨra enselɨn bar gavgavibar nedazibar arɨgh da isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Egh ia akasɨn temeba inigh, inir ekiar kam gusɨ 4plan dɨpenir akɨnibar ingarigh. Egh dɨpenir akɨnir kaba golɨn dar poghɨva da nokegh. Egh golɨn akeziba ingarigh nir kamɨn suighsɨ dɨpenir akɨnibar dar arɨkigh. Egh 4plan silvan boksiabar ingarigh, egh dɨpenir akɨnir kaba boksiabagh asegh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Egh inir kam inigh dɨpenir akɨnibar itir akezibar guightɨ, nir kam, a Purirpenim avarazir nir ekiar uaning sasuirazɨ naghɨn apengan ikɨ. Egh dagɨar akuar Akar Dɨkɨrɨzir Gavgavim itimningɨn Boksiam, inir kamɨn gɨrakɨrangɨn aven anetɨgh. Eghtɨ inir kam Purirpenimɨn aven, dɨvazimɨn mɨn Anogoroghezir Danganim ko, Bar Anogoroghezir Danganim abigh ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Egh golɨn asuam inigh mangɨ danganir Bar Anogoroghezir Danganimɨn Boksiam dukuagh. Eghtɨ Boksiamɨn asuar kam, kar arazir kuraba gɨn amangamin danganim. ");
INSERT INTO msy2020_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Egh ia bretba arɨghamin dakozim isɨ notɨn amadaghan Purirpenimɨn aven inimɨn boroghɨn anetɨgh. Egh lamba afamin aghorim isɨ sautɨn amadaghan inimɨn boroghɨn anesaragh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Egh ia Purirpenimɨn tiar akamɨn gusɨ, inir ghurghurir aghuitamɨn ingarigh, tiar akamɨn a guraghtɨ a tiar akamɨn mɨn ikɨ. Ia tretɨn sipsipɨn arɨzibar ingarizir blupla ko, pɨghaghevim ko, aghevimɨn an kurkegh da isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Egh akasɨn temeba inigh tiar akam bagh 5plan dɨpenir akɨnibar ingarigh, egh golɨn dar poghɨva da nokegh. Egh 5plan brasɨn boksiar toriba itibar ingarigh egh dɨpenir akɨniba dagh asam. Egh inir kam agusɨ golɨn akeziba isɨ dɨpenir akɨnibagh ikegh, egh inir kam guragh.” ");
INSERT INTO msy2020_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia akasɨn temeba inigh, egh asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn ingarigh. Eghtɨ an arozim ko an ruarimɨn ababanim, aning vɨrara 2 mita, 20 sentimitan tugh. Eghtɨ an tuirivimɨn ababanim 1 mita 30 sentimitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Temer akasɨn ofa gamir dakozimɨn ingarizimra, ia bulmakaun kombar mɨn garir bizibar ingarightɨ, da ofa gamir dakozimɨn mɨkebabar vaghvagh dar ikɨ, egh ofa gamir dakozim brasɨn an poghɨva a nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ofan dakozimɨn ofan ingangarim damusɨ ia bizir kabar ingar, savolɨn muziariba, itarir ekiaba, pokba, ko avim ateramin itariba, ko averenim iniamin itaribar ingarigh. Bizir kaba bar ia brasɨn dar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","5","Egh ia bras uaia inigh abizimɨn mɨn garir bizimɨn ingarigh. Egh ofa gamir dakozimɨn aven anetɨgh. Egh ia brasɨn ringɨn 4plan ingarigh. Egh da isɨ ofa gamir dakozimɨn abizimɨn mɨkebabar arɨkigh. Egh brasɨn ruaritam inigh ofa gamir dakozimɨn averiamɨn tongɨram anetɨgh a ikɨraruigh. Egh uaia brasɨn abizimɨn mɨriaba isɨ, brasɨn ruarir kamɨn apengan aneguragh. Eghtɨ abizimɨn mɨn ganamin bizir kam, ofa gamir dakozimɨn averiamɨn tongɨra daperagham. ");
INSERT INTO msy2020_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Egh ia akasɨn iter otevir pumuning inigh, egh aning akɨrigh brasɨn aning poghɨva aning nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Egh ia ofa gamir dakozim atersɨ akasɨn temer kamning isɨ ringɨn an mɨriamningɨn itibar aghuigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ia temer arariba inigh ofa gamir dakozim boksiamɨn mɨn an ingarigh, egh boksiamɨn dɨkɨnimɨn ingaran markɨ. Ia aneteghtɨ an dɨkɨnim pura torim ikɨ. Ia nedazir kɨ mɨghsɨamɨn nɨn akazimɨn mɨrarama an ingarigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ezɨ Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia inir ghurghurir aghuimɨn ingarigh, Purirpenim avɨnsɨ dɨvazir azenan itimɨn ingarigh. Ia inir ruarir kam sautɨn amadaghan itir dɨvazim bagh an ingarightɨ, a 44 mitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Egh ia inir kam gusɨ, 20plan dɨpenir akɨniba brasɨn dar ingarigh, egh dɨpenir akɨnir kaba isɨ 20plan brasɨn boksiabagh asegh. Egh inir kam guamin akeziba ko dɨvazimɨn agharir ighuviba silvan dar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Egh kamaghɨra notɨn amadaghan itir dɨvazimɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Egh dɨvazir aruem ghuaghiri naghɨn itim, ia inir ruarir tamɨn ingarightɨ, a 22 mitan tugh. Egh 10plan dɨpenir akɨniba ko, 10plan brasɨn boksiar dɨpenir akɨniba asamibar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Eghtɨ dɨvazir aruem anadi naghɨn itim, an ababanim 22 mitan tugh. Eghtɨ dɨvazir kam tiar akam an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Tiar akamɨn mɨriamningɨn ia dɨpenir akɨniba asɨsɨ brasɨn boksiabar ingarigh. 3pla vongɨn ikɨtɨ 3pla vongɨn ikɨ. Brasɨn boksiabagh asɨsɨ, ia dɨpenir akɨnibar ingarigh. 3pla vongɨn da asegh, egh 3pla vongɨn da asegh. Egh tiar akamningɨn mɨriamningɨn gusɨ nir pumuningɨn ingarigh. Aningɨn arozimning vɨrara 6 mita 60 sentimitan tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Egh dɨvazimɨn tiar akam bagh ia inir ghurghurir aghuaritam, tretɨn blupla ko, pɨghaghevim, ko aghevir me sipsipɨn arɨzimɨn ingariziba isamɨva an kurkeghtɨ, a dɨvazimɨn tiar akam avam. Eghtɨ an arozim 9 mitan tugh. Egh ia 4plan dɨpenir akɨniba isɨ 4plan brasɨn boksiabagh asegh, egh inir kam isɨ dɨpenir akɨnir kabar da guigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ingangarim kamaghɨn mangam: ia silvan agharir ighuvir kabar ingarigh, dɨvazir kamɨn dɨpenir akɨnibar pueghtɨ da bar uarir suikigh. Egh silvan akezibar ingarigh egh dɨpenir akɨnibar arightɨ da silvan agharir ighuvibar suigham. Egh bras inigh dɨpenir akɨniba asamin boksiabar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Eghtɨ dɨvazir kam, an ruarim 44 mitan tughtɨ an arozim 22 mitan tugh, eghtɨ an tuirivim 2 mita 20 sentimitan tugh. Ia inir ghurghurir aghuarir tam inigh dɨvazir kamɨn ingarigh. Egh ia bras taba inigh dɨvazimɨn dɨpenir akɨnibagh asamin boksiabar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ia brasra inigh Purirpenimɨn ingangaribar amuamin bizibar ingarigh. Egh Purirpenim gavgavim a danɨngamin afughafughamiba ko an dɨvazim gavgavim a danɨngamin afughafughamiba, uaghan brasɨn dar ingarigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ Israelian gumazamizibav kemeghtɨ me olivɨn borer aghuariba inigh izɨtɨ, lamɨn kabagh isɨ ikɨ mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Eghtɨ Aron uan otariba ko lamɨn kaba inigh, na bativamin Purirpenimɨn aven mangɨ. Egh Akar Dɨkɨrɨzir Gavgavimɨn Boksiam modozir inimɨn azenan dar arɨkigh. Egh dughiabar zurara me borem lambar arɨgh, eghtɨ da danganir kɨ Ikiavɨra Itir God itimɨn, guaratɨzibar isi mangɨ mɨzarazibar otiv. Egh ia Israelia, uan borir gɨn otivamiba ko, arazir kɨ damuasa ia mɨkemezir kamɨn suiragh gavgavigh ikɨ mamaghɨra ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Egha Ikiavɨra Itir God mɨgɨavɨra ikia kamaghɨn mɨgei, “Moses nɨ uamategh mangɨgh egh dughiar kamɨn uan avebam Aron ko an otarir kaba, Nadap, Abihu, Eleasar, ko Itamar, men diaghtɨ me izɨ. Egh nɨ Israelian tongɨn me amɨsevegh me damightɨ me nan ofa gamir gumazibar mɨn ikɨ nan ingangaribar amu. ");
INSERT INTO msy2020_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Egh Aron bagh, ofa gamir gumazimɨn korotiar aghuarimɨn ingarigh, egh an kurkeghtɨ, an ganganim igharagh otogh, egh Israelian damazimɨn ziar ekiam ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kɨ kamaghɨn ifonge, Aron, nan ofa gamir gumazimɨn otogh, nan ingangarim damuam. Kamaghɨn, nɨ gumazir kɨ korotiaba ko bizir igharazibar ingaramin fofozim me ganɨngizibar diagh me mɨkemeghtɨ, me Aron darugh nan ofa damuamin korotiamɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Egh me mɨkemeghtɨ me forivtarir nir an evarimɨn poroghav itimɨn ingarigh, korotiar otevir azenan itimɨn ingarigh, korotiar ruarir azenan itimɨn ingarigh, korotiar ruarir aven itir me tretbar kurkezimɨn ingarigh, inir dapanir asuar ruarimɨn ingarigh, egh inir ruarir ivariamɨn ikezimɨn ingarigh. Me Aron uan otariba ko me bagh, ofa gamir gumazibar korotiar aghuariba isamigh, eghtɨ me ofa gamir gumazibar mɨn nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Egh ingangarir gumaziba tretɨn blupla, ko pɨghaghevim, ko tretɨn aghevir me sipsipɨn arɨzimɨn ingarizim, ko gol tret, ko inir ghurghurir aghuariba inigh korotiar kabar ingar. ");
INSERT INTO msy2020_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Egh me korotiar otevir azenan itimɨn ingarsɨ, tretɨn blupla, pɨghaghevim ko, tretɨn aghevir me sipsipɨn arɨzimɨn ingarizim ko, gol tret ko inir ghurghurir aghuir kam kurkazir aghuibar a isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Egh inir sazir pumuning korotiamɨn suighsɨ a gisɨn aning isamightɨ, aning dɨpɨzimning gisɨn anang mangɨ akɨrimɨn inir otevir vongɨn itimɨn suiragh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Egh me gol tret, ko tretɨn blupla, pɨghaghevim, tretɨn aghevir me sipsipɨn arɨzibar ingarizim ko inir ghurghurir aghuarim inigh, egh inir ivariam gikamim adiarir aghuariba a darɨgh an ingarigh. Egh inir ivariam gikamim isɨ korotiar otevir azenan itir kamɨn mɨriamɨn porogh a isamigh, eghtɨ bizir pumuning datɨrɨghɨn bizir vamɨran mɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Egh dagɨar pɨzir aghuarir pumuning inigh, egh Jekopɨn otarir 12plan ziaba aningɨn dar ghorɨva da osirigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ia kamaghɨn damu, otarir ivariamɨn ziam faragh anetɨgh mangɨ namba 12ɨn otarimɨn tugh. Egh 6plan ziaba isɨ dagɨar tam darɨgh, egh 6pla isɨ dagɨar igharazim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Nɨ ingangarir kam isɨ gumazir dagɨaba aghoramin fofozim itim danɨngigh, eghtɨ a Jekopɨn otaribar ziaba isɨ dagɨar kamningɨn dar ghoregh. Egh ia dagɨamningɨn suighsɨ golɨn kurkazir pumuningɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Egh dagɨar kamning isɨ korotiar otevir azenan itimɨn dɨpɨzimningɨn itir inir sazimning gisɨn aning isamigh, eghtɨ aning Israelɨn 12plan anababar ababanimɨn mɨn ikiam. Eghtɨ Aron uan dɨpɨzimningɨn men ziaba atertɨ, kɨ Ikiavɨra Itir God dar gan uan gumazamiziba zurara me gɨnɨghnɨghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Ia dagɨamningɨn suighamin golɨn kurkazir kamningɨn ingarigh. Egh golɨn aghuarim inigh tretɨn mɨn ikarɨzibagh irighɨva, egh da isɨ da nuavigh golɨn benir pumuningɨn ingarigh. Egh benir kamning inigh dagɨamning suighamin golɨn kurkazir kamningɨn porogh.” ");
INSERT INTO msy2020_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia ofa gamir gumazibar dapanimɨn evarim gikɨsɨ forivtarir initamɨn ingarigh. Kar Godɨn ifongiam gɨfofoghamin bizim. Egh ia kamaghɨra korotiar otevir azenimɨn itimɨn ingarizimɨn mɨrara, gol tret, ko tretɨn blupla, pɨghaghevim, ko tretɨn aghevir me sipsipɨn arɨzibar ingarizim ko inir ghurghurir aghuarim inigh, egh forivtarir inir muziarir kam bar deragh an ingarigh, egh kamaghɨrama an kurkegh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ia forivtarir inir muziarir kamɨn ingarightɨ, an inimɨn ruarim 44 sentimitan tughtɨ an arozim 22 sentimitan tugh. Egh deraghvɨra tongɨra a remeghtɨ, a forivtarimɨn mɨn otoghtɨ, an otevibar ababaniba voroghɨra mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","21","Egh ia 12plan dagɨar ivezim bar pɨn koziba isɨ, dagɨar kaba bar da vaghvagh Jekopɨn otaribar ziaba osirigh, eghtɨ dagɨaba vaghvagh an anababar ababanimɨn mɨn ikiam. Ia golɨn taba inigh dagɨabar suizir golɨn kurkazibar ingarigh, egha dagɨaba vaghvagh da afegh egh forivtarir inimɨn azenan da ikegh. Egh ia dagɨar kaba isɨ, 4plan abiar ruaribar forivtarir inir kamɨn azenan da ikegh. Egh faragha itir abiamɨn dagɨar me kamaghɨn dɨboriba, rubi, topas, ko ganet, da ikegh. Egh abiar an gɨrara itimɨn dagɨar emeral, sapaia, ko daimon ikegh. Egh abiar mɨkezimɨn, dagɨar terkois, aget, ko ametisɨn dagɨaba ikegh. Egh namba 4ɨn abiamɨn, berilɨn dagɨam ko, dagɨar pɨzir aghuarim ko jaspan dagɨam ikegh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Egh ia golɨn aghuarim inigh egh tretɨn mɨn ikarɨzibagh irigh da nuavigh egh benir pumuningɨn ingarigh, eghtɨ aning forivtarir inir evarimɨn guraghav itimɨn suigham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","24","Egh gol ringɨn pumuningɨn ingarigh, egh aning isɨ evarimɨn ikiamin forivtarir inimɨn mɨkebar pɨn itimningɨn aning ikegh. Egh golɨn benimning isɨ, aningɨn otevimning, forivtarir inimɨn itir gol ringɨn kamning gikegh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ia golɨn benir otevir igharazimning isɨ, dɨpɨzimningɨn itir dagɨamningɨn suizir golɨn kurkazimning gikegh. Egh tuavir kamɨn forivtarir nir kam isɨ, korotiar otevir azenan itim gikegh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Egh ia ua gol ringɨn pumuningɨn ingarigh, egh aning isɨ evarimɨn itir forivtarir inir otevimɨn mɨkebamningɨn vɨn aning ikegh. Ringɨn kamning datɨrɨghɨn korotiar otevir azenan itimɨn boroghɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Egh ia gol ringɨn pumuning uam aningɨn ingarigh, egh aning isɨ korotiar otevir ivariamɨn amadaghan itimɨn, azenan aning porogh aning isamigh. Egh aning ikeghtɨ, aningɨn otevimning dɨpɨzimningɨn ikegha izighirɨ inir ruarir ivariam gikezimɨn tugh. Egh ivariam gikezir inir me deraghavɨra kurkezir kam an boroghɨn, gol ringning isamigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Egh benir sazir blupla inigh, evarimɨn ikiamin forivtarir inimɨn ringning isɨ, korotiar otevir azenan itimɨn ringning gikegh, eghtɨ evarimɨn itir forivtarir inim, korotiar otevir azenan itimɨn suiragh gavgavightɨ, evarimɨn ikiamin forivtarir inim ighuamangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Egh Aron Anogoroghezir Danganir kamɨn aven mangamin dughiar kamɨn, a forivtarir inir Israelian ovavibar ziaba aven itim inigh uan evarimɨn boroghɨn uan evarim gikegh. Kar Godɨn ifongiam gɨfoghamin bizim. Eghtɨ kɨ Ikiavɨra Itir God kamaghɨn ganigh, egh kɨ uan gumazamiziba zurara me gɨnɨghnɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Egh dagɨar Godɨn ifongiam gɨfofoghamin kamning isɨ, forivtarir inir an evarimɨn itim darugh, eghtɨ aning an evarim gisɨrara ikiam. Eghtɨ Aron Anogoroghezir Danganimɨn mangɨ, kɨ Ikiavɨra Itir Godɨn damazimɨn tuivsɨ, a dagɨar kamning inigh aning sara mangɨ. Egh Israelia Godɨn ifongiam gɨfoghsɨ, Aron dagɨar kamning uan forivtarir inim darugh, uan evarim gisɨrara aning ater Ikiavɨra Itir Godɨn damazimɨn tuivam.” ");
INSERT INTO msy2020_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia korotiar ruarir azenan itimɨn ingarightɨ a korotiar otevir azenan itimɨn apengan ikiam. Ia inir bluplan kɨnir, me sipsipɨn arɨzimɨn ingarizimɨn an ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Egh ia korotiar kam torim a datɨgh, eghtɨ ofa gamir gumazim uan dapanim aghuam. Egh inir avɨzir muziarir tam isɨ torir kam mɨdorozir korotiam isamizɨ moghɨn a ighuigh a isamigh, eghtɨ an torimɨn apɨniba gavgavightɨ torim bigh ekevegh mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Egh ia tretɨn blupla ko pɨghaghevim ko tretɨn aghevir me sipsipɨn arɨzimɨn irɨghizim inigh, egh iter pomigranetɨn ovɨzibar mɨn bizitaba isamigh. Egh ofa gamir gumazibar dapanimɨn korotiar ruarir azenan itimɨn vɨn bizir kaba isamigh egh golɨn ingarizir beloba vaghvagh pomigranetɨn ovɨzibar tizibar da isamightɨ, da ituighɨv ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Eghtɨ Aron korotiar kam arugh ofa gamir gumazimɨn ingangarim damuam. Egh a, kɨ Ikiavɨra Itir God, nan damazimɨn boroghɨn Anogoroghezir Danganimɨn aven izegh egh uam azenan mangamin dughiam, gumazamiziba belobar ararem baragham. A kamaghɨn damighan kogh, egh aremegham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Egh ia golɨn akuar aghuaritam inigh, medelɨn tamɨn ingarigh, egh akam kamaghɨn a gisɨn an osirigh, ‘Kar Ikiavɨra Itir Godɨn Gumazimra.’ ");
INSERT INTO msy2020_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Egh ia bluplan benim inigh gol medelɨn kam nir dapanir asuar ruarimɨn guam gitusɨ an ingarigh, eghtɨ an ofa gamir gumazibar dapanir asuamɨn guam gitoroghɨv ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aron zurara inir dapanir asuar medel itir kam uan dapanim darɨgh. Eghtɨ kamaghɨn kɨ Ikiavɨra Itir God, kɨ ofan Israelia na ganɨdiba kɨ da inisɨ ifuegham. Egh me ofa gamir arazitaba pueghtɨ, Aron men arazir kurabar osɨmtɨzim ateram. ");
INSERT INTO msy2020_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Egh ia tretɨn ghurghurir aghuariba inigh, egh korotiar ruarir aven itimɨn ingarigh, egh tretbar kurkazimɨn an ingarigh. Egh Aronɨn dapanim darɨghsɨ inir ghurghurir aghuarim inigh, egh inir dapanir asuar ruarimɨn ingarigh. Egh inir ghurghurir aghuarim inigh inir ruarir ivariam gitim an ingarigh, egh kurkazir aghuibar an ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Egh ia Aronɨn otariba bagh korotiar ruarir aven itiba ko inir ruarir ivariamɨn ikeziba ko inir dapanir asuar otevibar ingarigh. Eghtɨ me deraghvɨra kurkeghtɨ men ganganim igharagh otogh gumazamizibar damazibar ziar ekiaba ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Eghtɨ Moses, nɨ korotiar kaba isɨ uan avebam Aron uan otariba ko me daghuam. Egh olivɨn borem me gingegh, egh me amɨseveghtɨ me ofa gamir gumazibar otogh, egh nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Egh me bagh inir aghuarim inigh, egh me bagh trausiziar oteviba isamightɨ me korotiar ruarimɨn apengan dar aghuightɨ, men mɨkarzir mogomebar iniba azenan otivan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Eghtɨ Aron uan otariba ko, me Anogoroghezir Danganimɨn aven ofa gamir gumazimɨn ingangarim damusɨ, ofa gamir dakozimɨn boroghɨn mangɨva, me trausiziar kabar aghuigh, egh dughiar igharazibar me na bativamin Purirpenimɨn aven mangɨsɨ me kamaghɨra damuam. Egh me kamaghɨn damighan kogh me osɨmtɨzim ikɨtɨ, kɨ me mɨsueghtɨ me arɨmɨghiregham. Eghtɨ Aron uan igiar borir gɨn otivamiba ko, me zurazurara Akar Gavgavir kɨ damuasa me mɨkemezibar gɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Kɨ datɨrɨkɨn Aron uan otariba ko bizir nɨ me damuamim nɨ mɨkɨmasa, nɨ me amɨseveghtɨ me nan ofa gamir gumazibar otivsɨ, bizitam gasɨghasɨghizir puvatɨzir bulmakaun apurir igiatam ko sipsipɨn apurir tamning inigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Egh witɨn plauan bar derazitaba inigh, egh yis isɨ plaua darɨghan markɨ. Egh plauan kaba inigh bretɨn ingarigh. Egh plauan taba ua da inigh olivɨn borem sara da veregh bretɨn ingarigh. Egh plauan taba inigh bisketbar ingarigh olivɨn borem dar aghuigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Egh bretɨn kam ko bisketba isɨ akɨram daghuigh, egh nɨ ofa damuamin dughiamɨn nɨ bulmakaun apurim ko sipsipɨn apurir pumuning sara na danɨng. ");
INSERT INTO msy2020_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Egh nɨ Aron uan otariba ko me inigh na bativamin Purirpenimɨn tiar akamɨn izɨ, egh dɨpamɨn me ruegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Nɨ me ruegh gɨvagh, egh ofa gamir gumazimɨn korotiar kaba isɨ Aron daghuigh: korotiar ruarir aven itim, korotiar ruarir azenan itim, korotiar otevir azenimɨn itim, ko evarimɨn itir forivtarir inim, ko inir ruarir ivariam gitim, a gikegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Egh inir dapanir asuar ruarim an dapanim gighuigh. Egh gol medel isɨ an inir dapanir asuar ruarim a gitorogh. Medelɨn kam, akar kam an ikiam, ‘Kar Ikiavɨra Itir Godɨn Gumazimra.’ ");
INSERT INTO msy2020_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Nɨ gumaziba amɨsevi me ofa gamir gumazibar otivir olivɨn borem, an dapanim gingɨva anemɨsefegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","9","“Egh nɨ Aron amɨsevegh gɨvagh, egh an otariba inigh izɨ korotiar ruarir aven azuiba me daghuigh, egh inir ruariba men ivariabagh ikegh, egh inir dapanir asuar oteviba men dapanibagh ikegh. Egh nɨ kamaghɨn damigh Aron uan otariba ko me amɨseveghtɨ, me ofa gamir gumazibar otivigham. Eghtɨ, gumazir kaba uan ovavir boriba ko zurara ofa gamir gumazibar ingangarim damu, bizir kɨ damuasa mɨkemezibar amu mamaghɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Egh nɨ bulmakaun ofa damuamim inigh na bativamin Purirpenimɨn tiar akamɨn izɨtɨ, Aron uan otariba ko dafariba isɨ an dapanim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Eghtɨ nɨ nan damazimɨn, na bativamin Purirpenimɨn tiar akamɨn boroghɨn bulmakaun kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Egh nɨ uan dafarir puzimɨn bulmakaun ghuzitaba inigh, egh ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar arɨkigh. Egh ghuzir nar itiba bar da inigh ofa gamir dakozimɨn mɨngarimɨn da ingegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Egh gɨn muriam avarazir oviba bar da inigh, egh beramɨn akuar aghuarim inigh ovɨzir pumuning ko ovir aningɨn itiba inigh, egh na bagh ofa gami moghɨn ofa gamir dakozimɨn bar da tuegh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Egh bulmakaun tuzim ko inim ko an muriamɨn aven itir buariba inigh mangɨ gumazamiziba puvatɨzɨ naghɨn azenan da tuegh. Eghtɨ bulmakaun kam a ofa gamir gumazibar arazir kuraba gɨn amangamin ofa. ");
INSERT INTO msy2020_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Egh nɨ sipsipɨn apurir kamningɨn tam ofa bagh a inigh. Eghtɨ Aron uan otariba ko dafariba isɨ sipsipɨn kamɨn dapanim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Eghtɨ nɨ sipsipɨn kam mɨsueghtɨ an aremeghtɨ, nɨ an ghuzim inigh ofa gamir dakozimɨn 4plan mɨriaba bar a kavamangigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Egh nɨ sipsipɨn kam aghoraghsuegh, an soroghafariba ko muriam ruegh, asɨzir otevir kaba ko sipsipɨn dapanim sara bar ada isɨ ofa gamir dakozim gisɨn dar arɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Egh ofan bar isia mɨghɨrimɨn ofa gamir dakozimɨn bar da tueghtɨ da mɨghɨrigh. Eghtɨ kɨ Ikiavɨra Itir God, kɨ avim bar isir ofan kamɨn mughuriar aghuarim bar a gakuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Egh nɨ sipsipɨn namba 2 inightɨ, Aron uan otariba ko uan dafariba isɨ an dapanim gisɨn datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Egh nɨ sipsipɨn kam mɨsuegh, an ghuzir muziarim inigh, Aron uan otariba ko, men kuarir guvimɨn itir kuarir amɨraziba, ko men dafarir puzir amebar agharir guvimɨn itiba, ko dagarir puzir amebar suer agharir guvimɨn itiba, ghuzim dar aghuigh. Egh sipsipɨn ghuzir ikiavɨra itim inigh mangɨ ofa gamir dakozimɨn, an 4plan mɨriabar ghuzim kavamangigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Egh gɨn nɨ ghuzir ofa gamir dakozimɨn mɨriamɨn itim ko, olivɨn borer ofa gamir gumazim amɨsevim aning veregh, Aron ko an otariba ko men korotiaba sara kavamangigh. Egh nɨ kamaghɨn damightɨ, Aron uan otariba ko men korotiaba, da bar kɨ ua baghavɨra dagh inaba. ");
INSERT INTO msy2020_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Egh nɨ namba 2ɨn sipsipɨn kam aghoregh, an oviba ko an puer ekiar ovim itim ko, ovir muriam avarazim, ko beramɨn akuar aghuarim, ko ovɨzimning ko aningɨn itir oviba, ko agharir guvimɨn itir buaragharim inigh, bar dar ofa damu. Kar ofa gamir gumaziba amɨsevir ofa. ");
INSERT INTO msy2020_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nɨ uaghan mangɨ nan damazimɨn itir bretɨn yis puvatɨzibar itir akɨramɨn itiba, nɨ bretba vaghvagh kamaghɨn bretba ini: bretɨn me olivɨn boremɨn tuezir tam ko, olivɨn boremɨn tuezir puvatɨzir tam, ko bisketɨn vamɨra. ");
INSERT INTO msy2020_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Egh dagher kaba isɨ Aron uan otariba ko men dafaribar arightɨ, me ofan kam suiragh a fɨ a damutɨ, a Godɨn damazimɨn ighuavamangam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Eghtɨ nɨ gɨn dagher men dafarimɨn itiba inigh, egh ofan bar isia mɨghɨribagh amir dakozimɨn ofaba tue naghɨn da tueghtɨ avim bar dar isigh. Eghtɨ kɨ Ikiavɨra Itir God, kɨ ofan mughuriar aghuarir kam bagh bar akuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Egh nɨ sipsipɨn namba 2ɨn kamɨn evarir tuzim uan dafarimɨn an suiragh a fɨ a damutɨ, a Godɨn damazimɨn ighuavamangɨ. Egh nɨ asɨzir kam anemɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Aron ofa gamir gumazimɨn otivsɨ, nɨ sipsipɨn evarir tuzim uan dafarimɨn an suiragh a fegh a damutɨ a nan damazimɨn ighuavamangɨ. Egh Aronɨn otariba bagh sipsipɨn buarakɨrir agharir guvimɨn itim inigh uan dafarimɨn an suiragh a fegh a damutɨ a nan damazimɨn ighuavamangɨ. Arazir kamɨn, nɨ ofa gamir gumazibar ikɨsɨ me amɨsefegh. Egh gɨn ia asɨzir tuzir kam isɨ ofa gamir gumazibar anɨngightɨ, me aneremɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Egh dughiaba Israelia zurara na ko navir vamɨra ikɨsɨ, asɨzir evarimɨn itim ko buaragharim inigh, kɨ Ikiavɨra Itir God na danɨng. Eghtɨ kɨ ofa gamir gumazibar anɨngightɨ, me aneremam. Bizir kɨ damuasa mɨkemezir kam ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Eghtɨ gɨn Aron aremeghtɨ, me an ofa gamir gumazimɨn korotiar aghuarim isɨ an otaribar anɨngigh. Eghtɨ Aronɨn ikɨzimɨn adarazi ofa gamir gumazibar otivsɨ, me korotiar kam arughtɨ, me me amɨsɨva borem me gingam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Eghtɨ Aronɨn ikɨzimɨn gumazitam an danganim inigh ofa gamir gumazibar dapanimɨn otivsɨ, egh a faragh korotiar kabar aghuigh na bativamin Purirpenimɨn aven mangɨva Anogoroghezir Danganimɨn aven nan ingangarim damu mangɨ 7plan dughiabar tugham. ");
INSERT INTO msy2020_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Dughiar nɨ Aron ko an otariba mɨsɨvamim, nɨ sipsipɨn tuzir nɨ ofa gamizim inigh, na baghavɨra itir Purirpenim avɨnizir dɨvazimɨn aven a isɨ mɨnem darugh anevikigh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Eghtɨ Aron ko an otariba, sipsipɨn tuzir kam ko bretɨn akɨramɨn ikiavɨra itim inigh, egh na bativamin Purirpenimɨn tiar akamɨn aneremɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Me ofa gamir gumaziba amɨsɨvamin dughiamɨn, me uan arazir kuraba gɨn amangasa ofa gamua tuezir dagher kaba me dar amɨ. Dagher kaba na baghavɨra ikiava bar anogoroke. Kamaghɨn amizɨ, ofa gamir gumazibara dagher kabar amam, eghtɨ gumazamizir kɨniba bar puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Egh asɨzir tuzitaba ko bretɨn ikɨ mangɨtɨ amɨnim tiraghamba, ia dar aman markɨ. Asɨzir tuzir kamagh amizim na baghavɨra ikia bar anogoroke, kamagh me avimɨn a tuaghtɨ a bar isɨ mɨghɨrigh puvatɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Egh kɨ nɨ mɨkemezɨ moghɨn, nɨ Aron uan otariba ko me amɨsɨvɨsɨ, ingangarir kam damu mangɨtɨ, namba 7ɨn dughiam otogh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Dughiabar zurara nɨ arazir kuraba gɨn amangɨsɨ, bulmakaun vamɨran ofan mɨn ofa damu. Eghtɨ ofan kam ofa gamir dakozim damightɨ a nan damazim bar zuegham. Egh olivɨn borem isɨ ofa gamir dakozimɨn a fugh, anemɨseveghtɨ a nan ofa gamir dakozimra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Egh nɨ kamaghɨn ofa gamir dakozim damu mangɨ namba 7ɨn dughiamɨn tugh. Eghtɨ ofa gamir dakozim, a bar nan bizim, egh bar anogoregham. Egh gumazitam o bizitam ofa gamir dakozir kam seregham, a uaghan na baghvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia dughiaba vaghvagh sipsipɨn nguzir azenir vamɨra itir pumuning inigh, egh ofa gamir dakozimɨn dar ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ia mɨzarazimɨn sipsipɨn kamningɨn tam isɨ an ofa damu. Egh bar guaratɨzimɨn, ia tamɨn ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Egh ia witɨn ingarizir 1 kilogrem plauan aghuitam inigh, 1 lita olivɨn borem sara aning veregh, egh sipsipɨn faragha ofa gamir kam ko ofa damu. Egh uaghan 1 lita wainɨn dɨpam inigh, ofan mɨn afugh. ");
INSERT INTO msy2020_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Egh ia guaratɨzimɨn sipsipɨn igharazim inigh, an ofa damu. Egh ia mɨzarazimɨn amizir ofan mɨrara ofa damu, egh ia wit tuamin ofa ko, wainɨn dɨpamɨn ofa inigh, ofa damu. Eghtɨ dagher ia ofan mɨn avimɨn tuezɨ mɨghɨrizir kam, kɨ Ikiavɨra Itir God, kɨ ofan kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Eghtɨ ofan bar isia mɨghɨrir kam, ian gɨn otivamin ovavir boriba zurara dughiabar na bativamin Purirpenimɨn tiar akamɨn ofa damu, eghtɨ kɨ an ganam. Eghtɨ kɨ uan gumazamiziba danganir kamɨn ia bativam. Kɨ danganir kamra nɨ ko mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Eghtɨ nan angazangarir ekiam ko gavgavim Purirpenimɨn otiv, egh danganir kam damightɨ, a nan danganimɨn mɨn otogham. Eghtɨ kɨ danganir kamɨn Israelian gumazamiziba bativam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Egh kɨ, na bativamin Purirpenim ko ofa gamir dakozim amɨseveghtɨ, aning nan bizimningɨn mɨn ikiam. Eghtɨ kɨ Aron uan otariba ko me amɨseveghtɨ, me ofa gamir gumazibar mɨn nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Eghtɨ kɨ Israelia ian tongɨn ikɨ, egh ian Godɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Eghtɨ ia deraghvɨra fogham, kɨrara kɨ Ikiavɨra Itir God, kɨ ian God, egha kɨrara Isipɨn kantrin ia inigha ian akua ize. Ezɨ kamaghɨn kɨ ian tongɨn ikiam. Kɨ Ikiavɨra Itir God, egha kɨ uabɨ kɨ ian God.” ");
INSERT INTO msy2020_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Egha Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia akasɨn temem inigh ofa gamir dakozir tamɨn ingarigh. Dakozir kam, ia pauran aghuarim tuaghtɨ a mɨgharir mughuriar aghuim otivam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Eghtɨ ofa gamir dakozimɨn ruarim 45 sentimitan tugh, eghtɨ an arozim an ruarimɨn mɨrara mangɨ 45 sentimitan tugh, eghtɨ an tuirivim 90 sentimitan tugh. Egh temer akasɨn ofa gamir dakozimɨn ingarizimra, ia bulmakaun kombar mɨn garir bizibar ingarightɨ, da ofa gamir dakozimɨn mɨkebaba vaghvagh dar ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Egh an 4plan mɨriaba, ko an siriam, ko an komba, ia golɨn aghuarimɨn dar puegh da nokegh. Egh golɨn ruarim isɨ ofa gamir dakozimɨn mɨriabar arɨghɨva dagh ighuigh. ");
INSERT INTO msy2020_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Egh gol ringɨn pumuningɨn ingarigh, tam isɨ vongɨn a ikegh, egh vongɨn tam ikegh. Ia ringɨn kamning isɨ golɨn ruarir an mɨriabar ikeghamimɨn apengan aning ikegh. Ringɨn kamning ofa gamir dakozim atersɨ tememning aning daghuam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ia akasɨn iter pumuning inigh ofa gamir dakozim atersɨ aning akɨrigh, egh golɨn aning nokegh. ");
INSERT INTO msy2020_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Egh ofa gamir dakozir kam isɨ, inir ekiar Akar Dɨkɨrɨzir Gavgavimɨn Boksiam modozimɨn azenan anetɨgh. Boksiar kam gisɨn arazir kuraba gɨn amadir danganim iti. Eghtɨ danganir arazir kuraba gɨn amadir kamɨn, kɨ ia bativam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Egh zurara mɨzarazibar Aron izɨva lamba akɨrmɨgh, egh dughiar kamra pauran mughuriar aghuim zuim ofa gamir dakozir kamɨn da tu, egh mɨgharir mughuriar aghuim zuim damutɨ an otivam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Egh a guaratɨzibar lamba akɨrmɨgh, egh pauran mughuriar aghuim zuimɨn ofa damu. Egh ofan kam, kɨ Ikiavɨra Itir God, na bagh a damu, egh zurara gɨn izamin dughiabar kamaghɨra damu. ");
INSERT INTO msy2020_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ia pauran mughuriar aghuir igharazitabar ofan bar isia mɨghɨrim dakozir kamɨn da tuan markɨ, asɨziba tuan markɨ, witba tuan markɨ, wain inian markɨ, bizir kaba kɨ ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Egh azeniba bar dughiar vamɨra, Aron ofa gamir dakozir kam nan damazimɨn zueghsɨ, ingangarim damuam. Ingangarir kam kamakɨn: Asɨzir ian arazir kuraba gɨn amangasa ofa gamim, Aron an ghuzitam inigh, ofa gamir dakozir kamɨn kombar arɨkigh. Ia arazir kam zurara azenibar a damu. Ofa gamir dakozir bar zuezir kam, kɨ Ikiavɨra Itir God, kar nan bizimra.” ");
INSERT INTO msy2020_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","12","Egha gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ Israelian gumazibar ziaba akɨnafarimɨn da osiramin dughiam, gumaziba bar vaghvagh uan ikɨrɨmɨrim uam a inisɨ dagɨar taba na danɨng. Puvatɨghtɨ, arɨmariar ekiar kuram otogh, dughiar kamɨn me gasɨghasigham. ");
INSERT INTO msy2020_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Eghtɨ gumazir me ziaba iniziba, me bar 5 kinan silvan dagɨaba isɨ ofan mɨn na danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Egh me 20plan azenibar ikegha ghuavanadir gumazibar ziaba iniam, eghtɨ me bar dagɨar kaba na danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Eghtɨ dagɨaba itir gumaziba avɨribar anɨngan markɨ, eghtɨ dagɨaba puvatɨzir gumaziba dagɨar muziaribar anɨngan markɨ. Me bar 5 kina na danɨng, egh me uan arazir kuraba gɨn amangamin ivezimɨn mɨn a givesegh, egh me aremeghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Eghtɨ nɨ dagɨar kam isɨ na bativamin Purirpenimɨn ganamin ingarim damu. Eghtɨ kɨ Ikiavɨra Itir God, dagɨar kabar gan fogh suam, ‘Kar me uan arazir kuraba gɨn amangamin ivezim, kamaghɨn kɨ Israelian gumazamiziba bakɨnɨghnɨghan kogham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","18","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, “Ia brasɨn taba inigh soroghafariba ruer itarir ekiatam ko anefamin dakozimɨn ingarigh. Egh dakozim isɨ ofa gamir dakozim ko na bativamin Purirpenimɨn tɨzimɨn anetɨgh. Egh itarir ekiam dakozimɨn pɨn anefagh, egh dɨpam itarir ekiam gingegh. ");
INSERT INTO msy2020_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Eghtɨ Aron uan otariba ko, me uan soroghafariba ruam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Egh me na bativamin Purirpenimɨn aven mangɨsɨ, o ofaba isia mɨghɨri naghɨn dakozimɨn ofa damusɨ, me uan soroghafariba rueghtɨ kɨ me mɨsueghtɨ me aremeghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bar guizbangɨra, me uan soroghafariba ruegh, egh me aremeghan kogham. Me ko, men otarir gɨn otivamiba, me zurara bizir kɨ damuasa mɨkemezibar gɨn mangɨvɨra ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","23","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, “Ia bizir aghuarir mughuriar aghuim itiba, da inigh: Mean sanda, an osɨmtɨzim 6 kilogrem, ko sinamonɨn pauran mughuriar aghuim zuim, an osɨmtɨzim 3 kilogrem, ko abuar mughuriar aghuim zuim, an osɨmtɨzim 3 kilogrem. ");
INSERT INTO msy2020_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","25","Egh pauran me iter kasian inimɨn ingarizim, an osɨmtɨzim 6 kilogrem, a inigh. Egh 4 lita olivɨn borem inigh, bizir kaba bar dagh ingegh. Egha mati gumazir fofozir bar aghuim ikia deravɨra sandaba verezɨ moghɨn, nɨ deraghvɨra da vereghtɨ sandan aghuim otogham. Borer kam, an ingangarim kamakɨn: me bizim o gumazim na bagh anemɨsɨvɨsɨ, borer kam isɨ a gingegh. ");
INSERT INTO msy2020_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“Egh nɨ borer aghuarir kam isɨ na bativamin Purirpenim gingegh, egh Akar Dɨkɨrɨzir Gavgavimɨn Boksiam gingegh, ");
INSERT INTO msy2020_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","egh bretba arɨghamin dakozim ko an ingarir bizibagh ingegh, egh lamba afamin aghorim, ko an ingarir biziba sara, dagh ingegh, egh pauran mughuriar aghuim tuamin ofa gamir dakozim gingegh, ");
INSERT INTO msy2020_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","egh asɨziba da bar isia mɨghɨrir ofa gamir dakozim ko, an ingangarir bizibagh ingegh, egh soroghafariba ruamin itarir ekiam ko anefamin dakozim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Egh nɨ bizir kaba mɨseveghtɨ da bar nan biziba, egh bar anogoregham. Eghtɨ gumazitam o bizitam a seregham, egh a uaghan na baghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Eghtɨ gɨn Aron ko an otariba, me amɨsɨvɨsɨ, ia borer kam inigh muziaritam me gingegh. Eghtɨ me nan ofa gamir gumazibar otogh nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Eghtɨ nɨ kamaghɨn Israelian gumazamizibav kɨm, ‘Ia ko ian adarazir gɨn izamiba, ia olivɨn borer kam inigh na baghvɨra ikiamin biziba amɨsɨvam. ");
INSERT INTO msy2020_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Egh ia gumazir kɨnibar ingan markɨ. Egh ia uaghan borer kamaghɨra garir tam uari bagh an ingaran markɨ. Kar Godɨn bizimra, kɨ ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Eghtɨ gumazir borer kam isɨ pura gumazir kɨnitam gingeghamim, ko gumazir borer kamaghɨra garibar ingariba, gumazir kamaghɨn amir kaba, nan gumazamizibar ikɨzimɨn aven ikian kogham.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Egha Ikiavɨra Itir God ua Moses kamaghɨn a mɨgei, “Ia mɨgharir mughuriar aghuim zuimɨn pauran ingarsɨ, pauran mughuriar aghuim zuir igharagha garitaba inigh, eghtɨ pauran kabar osɨmtɨziba voroghɨra mangɨ. Pauran kabanang: mean paura, ko pauran me zoghuabar mɨn garir bizimɨn ingarizim, ko galbanumɨn akɨmarimɨn eborir gavgavimɨn, ko pauran me iter balsamɨn eborimɨn ingarizim, bar da inigh, ");
INSERT INTO msy2020_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","egh deraghvɨra da vereghtɨ, mati gumazir fofozir aghuim itim, pauran mughuriar aghuimɨn ingari. Egh amangsɨzir muziaritam atɨghtɨ, paura deravɨram otogham. Egh a bar nan bizimra, kɨ ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Egh deraghvɨra pauran kamɨn taba mɨrmɨrightɨ, an averenimɨn mɨn guizɨn pauran otogh. Eghtɨ a inigh na bativamin Purirpenimɨn aven nan damazimɨn mangɨ, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn boroghɨn anetɨgh. Eghtɨ pauran mughuriar aghuim zuir kam, a nan bizimra, kɨ ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Eghtɨ ia pauran kamaghɨn gari tam uari bagh an ingaran markɨ. Kar kɨ Ikiavɨra Itir God, nan bizimra, kɨ ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Eghtɨ gumazitam sandan mughuriar aghuim baraghsɨ ifueghɨva, a kamaghɨra garir bizitamɨn ingarigh, egh a nan gumazamizibar ikɨzimɨn aven ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ikiavɨra Itir God Judan anabamɨn gumazim Besalel amɨsevegha gɨfa, a Urin otarim, egha a Hurɨn igiar borim. ");
INSERT INTO msy2020_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","4","Kɨ uan Duamɨn gavgavim a ganɨngi. Egha kɨ gol, silva, ko brasɨn bizir aghuir igharazibar ingaramin fofozir aghuim ko ingangarir aghuibar amuamin nɨghnɨzim a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Egha kɨ dagɨar ivezim bar pɨn koziba aghorɨva, temebar dirir guar avɨribar aghor, egh Purirpenim asɨngamin ingangarir avɨribar fofozir aghuiba a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Egha kɨ uaghan Ahisamakɨn otarim Oholiap amɨsevegha gɨfa, me Danɨn anabamɨn adarasi, eghtɨ a uaghan Besalel ko ingaram. Egha kɨ uaghan fofozir ekiam gumazir igharazibagh anɨngi, eghtɨ kɨ nɨ mɨkemezir biziba, me bar dar ingaram. ");
INSERT INTO msy2020_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Egh me na bativamin Purirpenimɨn ingar, egh Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn ingar, egh Boksiamɨn asuam, kar arazir kuraba gɨn amadir danganim, an ingar, egh Purirpenimɨn biziba bar dar ingaram. ");
INSERT INTO msy2020_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Egh me bretba arɨghamin dakozim ko an ingarir biziba bar dar ingar, egh lamba afamin aghorim ko lam ko an ingaramin biziba bar dar ingar. Me golɨn aghuarimra lamba afamin aghorir kamɨn ingarigh. Egh me uaghan pauran mughuriar aghuim tuamin ofa gamir dakozimɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Egh me asɨziba bar isia mɨghɨrir ofa gamir dakozim ko, ofan ingangarim gamir biziba bar dar ingar. Egh me soroghafariba ruer itarir ekiam ko anefamin dakozimɨn ingar. ");
INSERT INTO msy2020_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Egh me Aron uan otariba ko, me bagh ofa gamir gumazibar korotiar aghuaribara isamightɨ me dar aghuigh, egh ofa gamir gumazimɨn ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Egh olivɨn borer kɨ ua bagha mɨsevezir bizibagh ingemɨn ingar, egh pauran mughuriar aghuim zuim Anogoroghezir Danganim bagh an ingarigh. Eghtɨ me ingarir bizir kaba, kɨ nɨ mɨkemez moghɨra me dar amu.” ");
INSERT INTO msy2020_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","13","Egha Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Sabatɨn dughiam, kar dughiar avughsamim. Kamaghɨn ia zurara Sabatɨn dughiamɨn avughsɨ. Sabatɨn dughiam, an ababanimɨn mɨn kɨ ia ganɨdi, a datɨrɨghɨn ko ian adarazir dughiar gɨn izamibar ababanimɨn mɨn ikiam. Ababanir kam ian akaghtɨ ia fogh suam, kɨ Ikiavɨra Itir God, kɨ ia gamizɨ ia nan gumazamizibar mɨrara iti. ");
INSERT INTO msy2020_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ezɨ dughiar avughsamin kam, kar kɨ Ikiavɨra Itir God, nan dughiamra, kamaghɨn ia an avughsɨ. Gumazitam dughiar kamɨn ingangaritam damightɨ, ia a mɨsueghtɨ an aremegh. Gumazir kamaghɨn ami, nan gumazamizibar ikɨzimɨn aven ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ia wighɨn vamɨran an 6plan dughiabar ingangaribar amu, namba 7ɨn dughiam, kar nan dughiamra, kar nan avughsazir dughiar ekiam. Egh gumazir dughiar kamɨn ingangaribagh amiba, me bar me mɨsueghtɨ, me arɨmɨghiregh. ");
INSERT INTO msy2020_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kar Akar Dɨkɨrɨzir Gavgavir ia gɨn mangasa akam akɨrizim, kamaghɨn, ia Israelia dughiar kamɨn avughsɨ ikɨvɨra ikɨ mangɨtɨ ian gɨn izamin adarazi kamaghɨra damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kɨ Ikiavɨra Itir God, kɨ overiam ko nguazim 6plan dughiabar aningɨn ingari, egha dughiar namba 7ɨn, kɨ ingangariba bar da ategha avughsi. Ezɨ dughiar kam, a na ko ia Israelian tizimɨn Akar Dɨkɨrɨzir Gavgavim gamima, an ababanimɨn mɨn oto.” ");
INSERT INTO msy2020_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Egha Ikiavɨra Itir God, Moses ko Sainain Mɨghsɨamɨn mɨkemegha gɨvagha, egha God uabɨ dagɨar akuar pumuning isa Moses ganɨngi. God uabɨ uan dafarir puzimɨn Akar Gavgaviba aningɨn da osiri. ");
INSERT INTO msy2020_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Egha Moses dughiar ruarimɨn mɨghsɨamɨn ikia zuamɨra izezir puvatɨ. Ezɨ gumazamiziba uari akuvagha iza kamaghɨn Aron mɨgei, “E fozir puvatɨ, bizir tizimra Moses bato, gumazir kam Isipɨn kantrin e inigha en akua ize. Kamaghɨn amizɨ nɨ dɨkavigh, e bagh godɨn tabar ingarightɨ, da en faragh mangɨva e inigh tuavimɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ezɨ Aron me mɨgei, “Ia uan amuiba ko, otariba ko guivibar kuaribar guizir golɨn ringba, da suegh da inigh na bagh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Egha Aron kamaghɨn mɨkemezɨ, gumazamiziba bar uan kuaribar golɨn ringba asigha da inigha a bagha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ezɨ a kuaribar guizir gol ringɨn kaba inigha, da tuezɨ da isigha ameregha dɨpam ara. Ezɨ an a isa mozir me bulmakaun nguzimɨn nedazimɨn mɨn nguazimɨn kuizimɨn, a fugha bulmakaun nguzimɨn ingari. Egha afuam inigha deraghavɨra anerkɨri. Ezɨ gɨn gumazamiziba kamaghɨn mɨgei, “Israelia, ia oragh. Kar en godba. Da Isipɨn kantrin e inigha, en akua azenan ize.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ezɨ Aron kamaghɨn ganigha ofa gamir dakozim bulmakaun boroghɨn an ingarigha ghaze, “E gurumzaraghan isar ekiam ko ighiam damu, egh Ikiavɨra Itir God ziar ekiam a danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Egha amɨmzaraghan bar mɨzaraghara, gumazamiziba dɨkavigha iza ofan asɨziba tue da bar isia mɨghɨrir ofabagh ami. Egha me uaghan God ko navir vamɨran ikiamin ofaba inigha iza ofa gami. Egha gɨn apiagha dagheba ko dɨpaba amegha, gɨn dɨkavigha ghua ighiar kurabagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ zuamɨra magɨrɨ. Gumazamizir nɨ Isipɨn inigha izeziba, me arazir kurar avɨribagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Me tuavir me gɨn mangamin kɨ me mɨkemezim, me zuamɨra anetegha, golɨn bulmakaun nguzimɨn ingarigha, an ziam fa an ofa gami. Egha me ghaze, ‘Israelia, ia oragh, kar en godba. Da Isipɨn kantrin e inigha, en akua ize.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Gumazamizir kaba, kɨ men ganigha me gɨfo. Me gumazamizir akaba batoziba. ");
INSERT INTO msy2020_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kɨ me bagh navim isi bar men anɨngaghegham. Egh kɨ bar me gasɨghasigham. Eghtɨ nɨ nan anogoroghan kogham, bar markɨ. Egh gɨn kɨ nɨ ko nɨn boribar adarazir amightɨ, me ikɨzir gavgavir mamɨn otogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ezɨ Moses, a uan Godɨn Ikiavɨra Itim, pamtem kamaghɨn a gakaghori, “O Ikiavɨra Itir God, nɨ manmaghɨn amua, navim isia nɨn anɨngagharim nɨn gumazamiziba bagha pamtem dɨkafi? Nɨ uabɨ gumazamizir kaba Isipɨn kantrin uan gavgavir ekiamɨn me inigha azenan ize. ");
INSERT INTO msy2020_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Egh nɨ kamaghɨn me damightɨ, Isipia ua suam, ‘God uan gumazamiziba paza me gɨnɨghnɨsi. Egha a Isipɨn me inigha, danganir mɨghsɨabar me gasɨghasɨghasa me inigha iza bar me mɨsoghezɨ me ariaghire.’ O Ikiavɨra Itir God, nɨ kamaghɨn damuan markɨ. Nɨ uan anɨngagharir nɨghnɨzim abɨragh, egh uan gumazamizibagh asɨghasɨghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nɨ uan ingangarir gumazir kabagh inɨrɨgh, Abraham, Aisak, ko Jekop. Egh me koma amizir akar dɨkɨrɨzir kam gɨnɨghnɨgh. Nɨ kamaghɨn akar dɨkɨrɨzim me ko a gamua ghaze, ‘Kɨ bar guizbangɨra mɨgei, kɨ overiamɨn mɨkovezibar mɨn borir avɨriba ia danɨngam. Egh nguazir kɨ ia danɨngasa akam akɨrigha gɨvazim, kɨ a isɨ ian ovavir boribar anɨngam. Eghtɨ me zurara nguazir kamɨn ikɨ mamaghɨra ikiam.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ezɨ Ikiavɨra Itir God, Mosesɨn azangsɨzim baregha uan nɨghnɨzim giragha, uan anɨngagharir ekiam ategha, uan gumazamiziba gasɨghasɨghizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Egha Moses dagɨar akuar God Akar Gavgaviba osirizir kamning inigha, mɨghsɨam ategha izaghiri. God aningɨn vong ko vongɨn akaba osiri. ");
INSERT INTO msy2020_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","God uabɨ dagɨar kamningɨn ingarigha, uan Akar Gavgaviba aningɨn dar aghora da osiri. ");
INSERT INTO msy2020_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ezɨ Josua Moses ko ikia orazi, gumazamiziba tintinibar dei. Ezɨ a kamaghɨn Moses mɨgei, “Ai Moses! Gumazamiziba itir danganimɨn aven, kɨ inogovir nɨgɨnim barasi!” ");
INSERT INTO msy2020_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ezɨ Moses ghaze, “Mamaghɨn puvatɨ. Kar gumaziba inogovimɨn apaniba abɨnizir dɨmdiam puvatɨ. Ezɨ apaniba me abɨrazir ararem puvatɨ. Kɨ onger akar tiaribaram orasi.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ezɨ Moses me itir danganimɨn boroghɨra izegha, golɨn bulmakaun nguzim ko gumazamizibar garima, me ighiam gizi. Ezɨ a bar anɨngaghe. Egha dagɨar an aterir kamning, isa mɨghsɨamɨn apemɨn aning akunizɨ, aning bar mɨsaraghire. ");
INSERT INTO msy2020_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Egha Moses bulmakaun nguzir me ingarizir kam inigha avimɨn a tuazɨ a isi. Egha anebigha, a mɨrmɨrizɨ a pauran kɨnimɨn oto. Egha golɨn pauran kam dɨpam mɨkɨni. A tintinibar dɨpamɨn anekunigha gɨvagha, Israelia abɨraghbɨrazɨma me dɨpar kam api. ");
INSERT INTO msy2020_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Egha an Aron mɨgei, “Gumazamizir kaba arazir manamra nɨ gamizɨ, nɨ me gamizɨma, me arazir bar kurar kam gami?” ");
INSERT INTO msy2020_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ezɨ Aron a ikaragha ghaze, “Gumazir ekiam, nɨ nan anɨngaghan markɨ. Gumazamizir kaba nɨ fomɨra me gɨfo. Me arazir kuram damuasa bar kufi. ");
INSERT INTO msy2020_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Me kamaghɨn na mɨgɨa ghaze, ‘Gumazir kam Moses, gumazir Isipɨn e inigha en akua azenan izezim, e fozir puvatɨ, bizir tizim a bato. Kamaghɨn nɨ e bagh godɨn tabar ingarightɨ da en faragh mangɨ en aku tuavimɨn mangam.’ ");
INSERT INTO msy2020_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ezɨ kɨ men akam baregha, gumazamizibav gɨa ghaze, ‘Ia te golɨn ringba iti, ia da asigh.’ Ezɨ me golɨn uari garɨghiziba inigh da na ganɨngi. Me da na ganɨngizɨ, kɨ da isa avim mɨkɨni. Ezɨ bulmakaun nguzir kam a purama oto!” ");
INSERT INTO msy2020_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Egha Moses fo, Aron gumazamizibar amamangatɨzɨ, me tintinibar arazir kurar igharagha garir avɨribagh ami. Moses nɨghnɨsi, me kamaghɨn damutɨ men apaniba men ganigh, men ziam gasɨghasɨgh men ingarɨva akɨtɨ, me bar aghumsigham. ");
INSERT INTO msy2020_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Egha a ghua me itir danganimɨn dɨvazimɨn tiar akamɨn tugha kamaghɨn dɨa mɨgei, “Tina Ikiavɨra Itir Godɨn gɨn mangɨsɨ na bagh izɨ.” Ezɨ Livain anabamɨn adarazi iza an boroghɨn tuifi. ");
INSERT INTO msy2020_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ezɨ a kamaghɨn me mɨgei, “Ikiavɨra Itir God, Israelian God, a kamaghɨn mɨgei, ‘Ia bar uan mɨdorozir sababa inigh danganir e itir kam bar an otevibar mangɨ, gumazamizir ian boroghɨn ikiava marvir guamɨn gɨn zuiba, kar ian aveghbuaba, namakaba, ko ian boroghɨn itir darasi, ia bar me mɨsueghtɨ me arɨmɨghiregh.’ ” ");
INSERT INTO msy2020_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ezɨ Livaiba Moses mɨkemezɨ moghɨrama ami. Egha dughiar kamra me 3,000 gumazamizibav soghezɨ me ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Egha Moses kamaghɨn Livaibav gei, “Ia datɨrɨghɨn uari uan boriba, ko aveghbuabav soghezɨ me ariaghire. Ezɨ arazir kamɨn, Ikiavɨra Itir God uan ingangarim damuasa ia mɨsefe. Egha datɨrɨghɨn deragha ia gami.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Egha amɨmzaraghan Moses gumazamizibav gɨa ghaze, “Arazir kurar ia amizir kam, a bar ikufi. Ezɨ kɨ datɨrɨghɨn uamategh mɨghsɨamɨn mavanang Ikiavɨra Itir God bativam, egh a ian arazir kuraba gɨn amangɨsɨ kɨ an azangsɨgh ganigham.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Egha Moses mɨghsɨamɨn ghuavanabogha kamaghɨn Ikiavɨra Itir God mɨgei, “Nɨ nan apangkufigh nan azangsɨzim baragh. Gumazamizir kaba bar arazir kurar ekiam gami! Me marvir guar maba golɨn uari bagha dar ingarigha, dar ziaba fe. ");
INSERT INTO msy2020_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ezɨ kɨ datɨrɨghɨn nɨn azai, nɨ ifongegh men arazir kuraba gɨn amadagh. Egh nɨ aghuaghɨva nan ziamra, akɨnafarir nɨ uan gumazamizibar ziaba osirizimɨn anengarigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Puvatɨgham. Kɨ gumazamizir arazir kuram gamizibara, men ziaba angaram. ");
INSERT INTO msy2020_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Aria, nɨ mangɨ, gumazamiziba inigh danganir kɨ nɨ mɨkemezir kamɨn mangɨ. Nɨ oragh. Nan ensel ia inigh ian faragh tuavimɨn mangam. Eghtɨ gɨn kɨ izɨ ivezir kuram gumazamizir arazir kuram gamiziba, kɨ me ikaragham.” ");
INSERT INTO msy2020_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Guizbangɨra, gumazamiziba uari bagh bulmakaun nguzimɨn ingarasa bar Aron gakaghone. Kamagh amizɨ, Ikiavɨra Itir God gɨn men arazir kuram ikaragha arɨmariar kurar mam amadazɨ a me bagha ize. ");
INSERT INTO msy2020_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ ko nɨ Isipɨn inigha izezir gumazamiziba, ia danganir kam ategh, nguazir kɨ ia danɨngasa akam akɨrizimɨn mangɨ. Kɨ fomɨra kamaghɨn Abraham, Aisak, ko Jekop mɨgɨa ghaze, ‘Kɨ nguazir kam, ian ovavir borir gɨn otivamibar anɨngasa mɨkeme.’ ");
INSERT INTO msy2020_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Kɨ enselɨn tam amadaghtɨ, a nɨn faragh mangɨ, Kenania, Amoria, Hitia, Peresia, Hivia, ko Jebusia, me batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Eghtɨ ia mavanang nguazir aghuir kamɨn ikiam, biziba an ikiava bar deraghavɨram aghui. Ia gumazamizir akaba batoziba, kamaghɨn kɨ ia ko mangan kogham. Kɨ ia ko mangɨvigh tuavimɨn ia gasɨghasigham.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ezɨ gumazamiziba Akar Gavgavir kam baregha, men naviba bɨghizɨ me uan adiarir aghuibar kuritir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ezɨ Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Ia gumazamizir akaba batoziba. Kɨ ia ko dughiar otevimɨn mangɨvigh, bar ia gasɨghasigham. Ia orakigh, ia uan namnabagh arɨghizir adiarir aghuiba bar da surarɨkigh, eghtɨ kɨ deraghvɨra nɨghnigh arazitam ia damusɨ nɨghnɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Israelia Sainain Mɨghsɨam itir dughiamɨn, me uarir kuritir adiarir aghuiba bar da suagharigha, Sainain Mɨghsɨam ategha zuir dughiamɨn, me ua dar kuritir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Egha dughiabar zurara Israelia ghua danganir manamɨn ikia uan purirpeniba asima, Moses purirpenir mam isa mong men saghon ghua anesara. Egha kamaghɨn dɨpenir kam dɨbori, “God bativamin Purirpenim.” Eghtɨ tina Ikiavɨra Itir Godɨn nɨghnɨzim gɨfoghfoghsɨ, a Purirpenir kamɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moses God bativamin Purirpenimɨn aven mangamin dughiamɨn, gumazamiziba bar dɨkavigh uan purirpenibar tiar akabar tuivighav ikia garima, Moses an aven zui. ");
INSERT INTO msy2020_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moses aven ghugha gɨvazɨ, ghuariar ruarir ekiam iza Purirpenimɨn tiar akamɨn tughav iti. Ezɨ Ikiavɨra Itir God ghuariar kamɨn aven ikia Moses ko mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Gumazamiziba uan purirpenibar tiar akabar tuivigh ikɨ gantɨma, ghuariar ruarir ekiar kam God bativamin Purirpenimɨn boroghɨn tughɨv ikiam, eghtɨ me dapaniba avigh, Godɨn ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ikiavɨra Itir God Moses ko mɨgɨa, mati gumazim uan roroam ko mɨgei. Moses uamategha danganir gumazamiziba itimɨn izɨtɨ, Josua Purirpenimɨn averara ikiam. Josua, a Mosesɨn ingangarir gumazir igiam, a Nunɨn otarim. A God bativamin Purirpenim ataghɨrazir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moses kamaghɨn Ikiavɨra Itir God mɨgei, “Guizbangɨra, nɨ gumazamizir kaba inigh nguazir kamɨn mangasa na mɨkeme. Egha nɨ gumazir nan gɨn mangɨ nan akurvaghamin tamɨn gun na mɨkemezir puvatɨ. Nɨ ghaze, ‘Kɨ bar deragha nɨ gɨfogha, bar nɨ gifonge.’ ");
INSERT INTO msy2020_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kamaghɨn, nɨ guizɨn na gifongegh, uan nɨghnɨziba na mɨkemeghtɨ, kɨ deravɨra nɨ gɨfoghɨva arazir nɨ ifongezibar amuvɨra ikiam. Egh nɨ uaghan gumazamizir nɨ ua bagha inabazir kaba gɨn amangan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ezɨ Ikiavɨra Itir God ghaze, “Kɨ nɨ ko mangɨ navir amɨrizim nɨ danɨngtɨ, nɨ avughsam.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ezɨ Moses ua Ikiavɨra Itir God mɨgɨa ghaze, “Nɨ uabɨ e ko mangan aghuaghɨva, danganir kam ataghɨraghsɨ e mɨkɨman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Nɨ e ko mangan koghtɨ, gumazir igharaziba manmaghɨn fogh suam, nɨ na ko uan gumazamizibagh ifonge? Nɨ uabɨ e ko mangɨtɨ, gumazamizir igharaziba kamaghɨn fogh suam, e gumazamizir igharazibar tongɨn e bar ighara. Bar guizbangɨra, e bar nɨn gumazamizibara.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Kɨ deragha nɨ gɨfogha bar nɨ gifonge. Kamaghɨn, kɨ nɨ mɨkemezɨ moghɨra damuam.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ezɨ Moses kamaghɨn Ikiavɨra Itir God mɨgei, “Kɨ nɨn azangsɨsi, nɨ uan guamɨn angazangarir ekiam nan akaghasa kɨ ifonge.” ");
INSERT INTO msy2020_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ezɨ Ikiavɨra Itir God kamaghɨn Mosesɨn akam ikaragha ghaze, “Kɨ nɨn guamɨn uan arazir aghuim akagham. Egh kɨ uan ziamɨn gun nɨ mɨkɨmtɨ, nɨ fogham, nan ziam, Ikiavɨra Itir God. Kɨ gumazamizitabar kuarkuvighsɨ, kɨ men kuarkuvam. Kɨ gumazamizitabar apangkuvsɨ, kɨ men apangkuvam. ");
INSERT INTO msy2020_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Guizbangɨra, gumazitam nan guamɨn ganighɨva, an aremegham. Kamaghɨn, nɨ nan guamɨn ganighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nɨ gan! Dagɨar ekiar mam nan boroghɨn iti. Nɨ dagɨar ekiar kam gisɨn tugh. ");
INSERT INTO msy2020_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Eghtɨ nan guamɨn angazangarir ekiam nɨn boroghɨn izɨtɨ, kɨ nɨ isɨ dagɨar torimɨn aven nɨ atɨgh, uan dafarimɨn nɨ avaragh, egh mangɨ nɨ gitagham. ");
INSERT INTO msy2020_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Egh kɨ gɨn ua uan dafarim inightɨ nɨ nan akɨrir kɨnimɨn ganam. Egh nan guamɨn ganighan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Egha gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ dagɨar akuar pumuning uam aning atughɨva aning akɨrigh. Aning, dagɨar nɨ faragha kunizɨ bɨaghirezimningɨn mɨn gan. Eghtɨ kɨ akar faragha osiriziba uam aningɨn da osiram. ");
INSERT INTO msy2020_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nɨ dagɨar akuar kamning akɨrigh, gurumɨn bar mɨzaraghara Sainain Mɨghsɨamɨn anang bar an orazimɨn na batogh. ");
INSERT INTO msy2020_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Eghtɨ gumazitam nɨ ko izan markɨ. Kɨ gumazitam mɨghsɨar kamɨn danganir katamɨn an ganan aghua. Eghtɨ sipsipba ko bulmakauba uaghan izɨ mɨghsɨam boroghɨn grazibar aman markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ezɨ Moses Ikiavɨra Itir God a mɨkemezɨ moghɨn amua, a faragha inigha izezir dagɨar akuamningɨn mɨrara garir dagɨar akuamning atu. Egha bar mɨzaraghara uan dafarimɨn dagɨar akuamning atera Sainain Mɨghsɨamɨn ghuavanadi. ");
INSERT INTO msy2020_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ezɨ Ikiavɨra Itir God ghuariamɨn ikia izaghira Moses ko tughav ikia, egha uabɨ uan ziam dɨbora ghaze, kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Egha a Mosesɨn boroghɨn ghua an guam gitavɨragha kamaghɨn diagha ghaze, “Kɨ Ikiavɨra Itir God, kɨ Ikiavɨra Itir God. Kɨrara, kuarkuvir arazim ko apangkuvir arazimɨn mɨngarim. Egha zuamɨra anɨngazir puvatɨ. Egha zurara gumazamizibar apangkuva, zurara uan mɨgɨrɨgɨabar gɨn ghua guizɨn arazibagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Kɨ zurara uan gumazamizir avɨriba bar men apangkuvigh mangɨvɨra ikɨtɨ, men igiav otariba otivigh ikɨ kamaghɨra ikiam. Egha kɨ men arazir kuraba ko arazir akaba batoziba ko, igharagha garir bizir kurar avɨriba gɨn amadi. Egha kɨ garima, arazir kurabagh amir gumazamiziba, me osɨmtɨzim itima, kɨ ivezir kuram me ganɨdi. Egh men boribar borir gɨn otivamiba kɨ ivezir kuram me danɨng, mangɨtɨ men igiav otaribar boriba otivigham.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","God mɨkemegha gɨvazɨ, Moses zuamɨra tevimning apɨrigha dapanim aviragha guam nguazim gatɨgha Godɨn ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Egha kamaghɨn mɨgei, “O Ekiam, kɨ nɨn azai, nɨ bar guizbangɨra na gifuegh, egh nɨ e ko mangɨ. Guizbangɨra, gumazamizir kaba akaba barazir puvatɨ. Ezɨ nan ifongiam kamakɨn, nɨ en arazir kuraba ko igharagha garir bizir kuraba gɨn amadagh. Egh e damightɨ e nɨn gumazamizibara ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Datɨrɨghɨn kɨ Akar Dɨkɨrɨzir Gavgavim ia Israelia ko uam anekɨrasa. Kɨ nɨn gumazamizibar damazibar dɨgavir kuram gamir arazibar amuam. Arazir kaba, kɨ Kantrin Igharazibar Gumazamizibar damazibar faragha dagh amizir puvatɨ. Kantrin igharazibar gumazamizir ia men tongɨn itiba, me arazir kɨ Ikiavɨra Itir God damuamin kabar gan, egh dɨgavir kuram damuva akongɨva atiatingam. ");
INSERT INTO msy2020_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Eghtɨ ia nan Akar Gavgavir kɨ datɨrɨghɨn ia danɨngamiba bar, ia dar gɨn mangɨ. Eghtɨ kɨ ian faragh mangɨ, egh Amoria, Kenania, Hitia, Peresia, Hivia ko, Jebusia batuegham. ");
INSERT INTO msy2020_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Egh ia deraghvɨra ganigh, kantrin ia mangamin kamɨn gumazamiziba, ia me ko bizitam bagh akar dɨkɨrɨzir gavgavitam akɨran bar markɨ. Me azuazimɨn mɨn me ia damigh, egh ia gekuightɨ, ia iregh, bar ikuvigham. ");
INSERT INTO msy2020_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Ia men asebar ziaba fer bizir kabagh asɨghasɨkigh. Ia ofa gamir dakoziba ko, dagɨar guarir dɨghoriba itiba akunightɨ, da bar bɨghirɨ akuabagh iregh. Egh temer guarir aser amizim Aseran nedazim itiba bar da okeghtɨ da iregh. ");
INSERT INTO msy2020_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Kɨ uabɨra, kɨ Ikiavɨra Itir God, ia nan ziamra fɨ. Egh aser ifavariba nan danganim inian kɨ bar aghua. Egh ia asebar ziaba fan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Egh ia kantrin kamɨn gumazamiziba ko bizitam bagh akar dɨkɨrɨzir gavgavitam akɨran markɨ. Me tuavimɨn amizimɨn arazimɨn mɨn amua, asebar ziaba fe. Egh ia me ko akam akɨrightɨ, me uari ko ikɨsɨ ia mɨkɨmam, eghtɨ ia men asɨzir me asebar ofa gamizitabar amegham. ");
INSERT INTO msy2020_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Eghtɨ ameboghfeziaba uan otarir igiaba Israelɨn azenan itir amizir igiabar ikɨsɨ me ginamtɨ, amizir kaba me inigh mangɨtɨ, me na ategh asebar ziaba fam. Nan damazimɨn arazir kam mati gumazamiziba, uari isa tintinibar akuir arazim. ");
INSERT INTO msy2020_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Ia ainɨn mɨn garir bizitaba inigh asebar marvir guabar ingar, egh dar ziaba fan bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Egh ia Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam bakɨnɨghnɨghan markɨ. Abipɨn iakɨnim otozɨ ia Isipɨn kantri ataki. Ezɨ kɨ ia mɨkemezɨ moghɨn, ia zurara azeniba bar iakɨnir kamɨn, wighɨn vamɨran yis puvatɨzir bret amam. ");
INSERT INTO msy2020_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Eghtɨ ian otarir ivariaba, ko bulmakau ko sipsipba, dar nguzir apurir faragha otiviziba bar, kar kɨ ua bagha inabazir biziba. ");
INSERT INTO msy2020_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Egh ia donkin nguzir apurir faragha otozitam ua a inisɨ, ia sipsipɨn nguzim isɨ ofa damu, eghtɨ tuavir kamɨn ia donkin kam givezegh ua a inigham. Ia donkin kam givezan aghuagh, egh ia an gurim apɨrigh. Egh ia uan otarir ivariaba vaghvagh me givezegh ua me iniam. “Ia nan ziam fɨsɨ izɨ, dafarir kɨnibar izan markɨ, ia bizitam suiragh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Egh wikba bar ia 6plan dughiabara ingangaribar amu, egh ia namba 7ɨn dughiamɨn ingangaritam damuan bar markɨ. Azenimɨn ingarir dughiam ko dagheba asir dughiam, ia Sabatɨn dughiamɨn vɨrara aningɨn ingaran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Egh ia Azenibar Dagher Igiaba Asiamin Dughiamɨn Isar Ekiam gɨnɨghnɨgh. Ia witɨn faragha aniba iniamin dughiam, isar ekiar kam damuam. Egh gɨn ia Ruarpenibar Ikɨ Dagher Abuananaba Asiamin Dughiam, ia ua a bagh isam damu. Iakɨnir ia temer ovɨziba iniamim, isar ekiar kam otogham. ");
INSERT INTO msy2020_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Egh ia azeniba vaghvagh dar dughiar 3plan, ian gumazamiziba bar izɨ, egh nan ziam fɨsɨ nan damazimɨn otogh, kɨ Ikiavɨra Itir Godɨn Gavgavim, Israelian God. ");
INSERT INTO msy2020_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Eghtɨ gɨn kɨ gumazamizir datɨrɨghɨn ian nguazimɨn itiba batuegh, ian nguazimɨn mɨtaghniam damightɨ a mangɨ ekevegham. Egh azeniba bar dar 3plan dughiabar, ia nan ziam fɨsɨ izɨva nan damazimɨn otogh, eghtɨ apaniba ian nguazim inisɨ ifueghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Egh ia asɨzim isɨ na bagh an ofa damuva, an ghuzim isɨ na danɨngɨsɨ, yis itir bret sara ofa damuan markɨ. Egh ia God Israelia Gitazir Dughiam gɨnɨghnɨghsɨ asɨziba isɨ ofa damutɨ, dar naba ikɨ mangɨ amɨmzaraghan otivan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ia dagher faragha asiba, dar dagher bar aghuibara, ia da inigh nan Dɨpenimɨn mangɨ ofan mɨn, kɨ Ikiavɨra Itir God, ian God, da na danɨng. “Egh ia memen nguzitam isɨ mɨnem darugh, an amebamɨn oter eborim sara anevighan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Guizbangɨra, kɨ nɨ ko Israelia ia bagha Akar Dɨkɨrɨzir Gavgavim gami, ezɨ akar kɨ mɨgeiba ghua akar kamra inifi. Kamaghɨn amizɨ, nɨ akar kaba akɨnafarir tamɨn da osirigh.” ");
INSERT INTO msy2020_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ezɨ Moses 40plan dughiabar Ikiavɨra Itir God ko mɨghsɨamɨn ikia, egha daghetam ko dɨpatam bar anemezir puvatɨ. Ezɨ Ikiavɨra Itir God Akar Dɨkɨrɨzir Gavgavimɨn akaba, dagɨar akuar Moses inigha ghuzɨmningɨn ada osiri. Akar kaba, da 10plan Akar Gavgaviba. ");
INSERT INTO msy2020_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ezɨ Moses mɨghsɨam ategha ua izir dughiamɨn, a dagɨar akuar 10plan Akar Gavgaviba itimning inigha izi. A Ikiavɨra Itir God ko mɨkemezɨ, an guam bar angazangarir ekiam iti. Ezɨ a kamaghɨn fozir puvatɨ, an guam kamaghɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ezɨ Aron gumazamiziba ko Mosesɨn guamɨn angazangarimɨn ganigha, atiatigha, an boroghɨn mangan aghua. ");
INSERT INTO msy2020_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ezɨ Moses men diazɨ, Aron ko Israelian gumazir dapaniba a bagha zuima a me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ezɨ gɨn Israelian gumazamiziba bar a bagha zuima, an Akar Gavgavir Ikiavɨra Itir God Sainai mɨghsɨamɨn a ganɨngiziba, bar dar gun me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Egha a me mɨkemegha gɨvagha, inim inigha bar uan guam avara. ");
INSERT INTO msy2020_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Moses Ikiavɨra Itir God ko mɨkɨmasa Purirpenimɨn aven zuir dughiam, a inim adegh ikɨ mangɨ uam azenan izam. An azenan izava Ikiavɨra Itir God a mɨkemezɨ biziba bar dar gun gumazamizibav gei. ");
INSERT INTO msy2020_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ezɨ gumazamiziba an guamɨn garima an angazangarim iti. Moses me mɨkemegh gɨvagh, ua uan guam avaragham. Egh a ua mangɨ Ikiavɨra Itir God ko mɨkɨmamin dughiam a ua inim adegham. ");
INSERT INTO msy2020_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Egha Moses Israelian gumazamiziba bar men diazɨ me izezɨ a kamaghɨn me mɨgei, “Ikiavɨra Itir God kamagh mɨgɨa ghaze, ia nan Akar Gavgavir kabar gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ia ingangariba bar adar amu mangɨ 6plan dughiamran tugh. Egh namba 7ɨn dughiam ia avughsɨ. Kɨ Ikiavɨra Itir God, kar nan dughiar kɨ avughsim. Gumazim o amizitam dughiar kamɨn ingangaritam damightɨ, ia a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ia uan dɨpenibar aven avim arɨghsɨ, o ia uaghan ingangarir muziarir kamagh garibar amusɨ, Sabatɨn dughiamɨn dar amuan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Egha gɨn Moses kamaghɨn Israelia bar me mɨgei, “Ikiavɨra Itir God Akar Gavgavim ia ganɨga ghaze: ");
INSERT INTO msy2020_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ia datɨrɨghɨn bizitaba isɨ ofan mɨn Ikiavɨra Itir God danɨngam. Gumazamizir uan navimɨn aven biziba bar a danɨngasa nɨghnɨziba, me bizir kaba a danɨng: gol, silva, bras ko, ");
INSERT INTO msy2020_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","sipsipɨn arɨzibar ingarizir tretɨn bluplaba, pɨghagheviba, agheviba ko, inir ghurghurir aghuariba, ko inir me memen arɨzibar ingariziba ko, ");
INSERT INTO msy2020_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","sipsipɨn apurimɨn inir me penɨn aghevimɨn aghuiziba ko, ongarimɨn itir asɨzir ekiabar iniba ko, akasɨn temeba ko, ");
INSERT INTO msy2020_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lambagh arɨgha dagh aboir olivɨn borem ko, pauran mughuriar aghuim zuir me olivɨn borem sara verezir God ua bagha inabazir bizibagh ingem, ko pauran mughuriar aghuim gamiba. ");
INSERT INTO msy2020_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Egh dagɨar pɨzir aghuariba ko dagɨar aghuir ivezim bar pɨn kozir igharaziba inigh, da ofa gamir gumazibar dapanimɨn korotiar otevir azenan itimɨn kurkegh, egh an forivtarir inir an evarimɨn poroghav itim gituigh. Bizir kaba, me bar da inigh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Egha Moses ua kamaghɨn mɨgei, “Ian tongɨn gumaziba bar bizir kabar ingaramin fofoziba iti, me bar izɨ bizir Ikiavɨra Itir God ia mɨkemezibar ingar. ");
INSERT INTO msy2020_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Me Purirpenimɨn ingarighɨva, egh anevamin biziba, ko akeziba, ko bɨrir aghariba, ko agharir ighuvir gavgavim Purirpenim danɨngamiba ko, dɨpenir akɨniba ko, boksiar me bɨrir aghariba asamiba, me bar dar ingar. ");
INSERT INTO msy2020_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Egh me Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn ingarigh, egh temer aneteramimningɨn ingarigh, egh gol inigh an asuamɨn ingarigh, kar arazir kuraba gɨn amangamin danganim, ko Bar Anogoroghezir Danganim modir nir ekiamɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Egh ia bretba arɨzir dakozim ko an ingangarim gamir bizibar ingarigh, egh dakozim ateramin tememning akɨrigh, egh Godɨn damazimɨn darɨghamin bretba tuagh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Egh me lambar afamin aghorim, ko lamba, ko an ingangarim gamir biziba sara ingar. Egh me lamba ko angazangarim anɨngamin olivɨn borem sara ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Egh me pauran mughuriar aghuim tuamin ofa gamir dakozim ko anetersɨ itemningɨn ingarigh. Egh biziba mɨsɨv ingiamin olivɨn borem ko pauran mughuriar aghuimɨn ingarigh. Egh me Purirpenimɨn tiar akamɨn guamin inir ekiamɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Egh me asɨziba da bar isia mɨghɨrir ofa gamir dakozimɨn ingarigh, egh a bagh brasɨn ingarizir abizimɨn mɨn garir bizimɨn ko an ingarir bizibar ingarigh. Egh me ofa gamir dakozim ateramin itemningɨn ingarigh. Egh me soroghafariba ruamin itarir ekiatam ko anefamin dakozimɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Egh me Purirpenimɨn dɨvazim avɨnsɨ inibar ingarɨva, egh dɨvazimɨn dɨpenir akɨniba, ko boksiar akɨniba asamiba, bar dar ingarigh. Egh me dɨvazimɨn tiar akamɨn guamin ini tamɨn ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Egh me Purirpenim ko an dɨvazim gavgavim aning danɨngamin beniba ko afughafughamiba, dar ingarigh. ");
INSERT INTO msy2020_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Aron a ofa gamir gumazim, a uan otariba ko, me bagh korotiar aghuaribara isamightɨ me dar aghuigh, egh ofa gamir gumazimɨn ingangarim damuam. Kar, me daghuigh Anogoroghezir Danganimɨn aven mangamin korotiaba.” ");
INSERT INTO msy2020_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ezɨ Israelian gumazamiziba Moses ategha zui. ");
INSERT INTO msy2020_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ezɨ an akaba men avɨribar navibagh ami da dɨkavima, me a mɨkemezɨ moghɨn damuasa ifonge. Ezɨ gumazamiziba bizir guar avɨriba inigha izi: me God bativamin Purirpenimɨn ingaramin biziba ko, an ziam famin biziba ko, ofa gamir gumazibar korotiar aghuaribar ingaramin biziba, me bar da isa ofabar mɨn Ikiavɨra Itir God ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Ezɨ gumazamizir kamaghɨn damuasa ifongeziba, uarir kuritir bizir igharagha garir kaba inigha izi. Bizir aghuir kabanang: kuarimɨn ringba, dafarimɨn ringba, fɨrimɨn ikezir ringba, ko golɨn aghuir dirir igharagha gariba itiba. Gumazamiziba bizir kaba isa, dar suiragha da fegha dagh amizɨ, da Godɨn damazimɨn ighuavamadir ofabar mɨn da isa Ikiavɨra Itir God ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ezɨ gumazamizir maba, me bizir kaba ikiava, me vaghvagha da inigha izi, tretɨn bluplaba, ko pɨghagheviba, agheviba ko, inir ghurghurir aghuariba, ko inir me memen arɨzimɨn ingarizim ko, sipsipɨn apurimɨn inir me penɨn aghevimɨn aghuizim ko, ongarimɨn itir asɨzir ekiabar iniba. ");
INSERT INTO msy2020_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ezɨ gumazamizir silva ko bras itiba, me ofan mɨn da isa Ikiavɨra Itir God bagha izi. Ezɨ gumazir akasɨn temeba itiba me Purirpenim ko bizir igharazibar ingarasa da inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ezɨ amizir tretbagh irɨgha foziba, me sipsipɨn arɨziba isa tretɨn bluplaba, ko tretɨn pɨghagheviba, ko tretɨn aghevibagh irɨsi. Egha me inir ghurghurir aghuibar ingarasa tretɨn ghurghuribagh irigha, dar ingari. Egha me tretɨn kaba inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Egha me uaghan memen arɨzimɨn tretɨn ingaran fofozim ko ifongiam ikia, egha dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Ezɨ gumazir dapaniba dagɨar pɨzir aghuiba ko dagɨar aghuir ivezim bar pɨn kozir igharaziba inigha izi. Me da isɨ ofa gamir gumazibar dapanimɨn korotiar otevir azenimɨn itim ko, forivtarir nir an evarimɨn itim darɨgham. ");
INSERT INTO msy2020_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Egha me, olivɨn borer me lambagh inge da isir borem, ko biziba mɨsɨv dagh ingamin borem, ko pauran mughuriar aghuim, dar ingarasa, egha pauran igharagha gariba ko olivɨn boreba da inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ezɨ Israelian gumazamiziba bar biziba Ikiavɨra Itir God danɨngasa uan ifongiamɨn gɨn ghua me da inigha an ingangarim damuasa, a Moses mɨkemezɨ moghɨn da inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Ezɨ Moses Israelia mɨgei, “Ikiavɨra Itir God Judan anabamɨn gumazim Besalel amɨsevegha gɨfa, a Urin otarim, egha a Hurɨn igiar borim. ");
INSERT INTO msy2020_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Egha Ikiavɨra Itir God uabɨ uan Duamɨn gavgavim a ganɨngizɨ, a fofozir aghuim ko ingangarir aghuibar amuamin nɨghnɨzim iti. ");
INSERT INTO msy2020_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Egha a gol, silva, ko brasɨn bizir aghuir igharazibar ingaramin fofozir aghuim ko nɨghnɨzir aghuim a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Egha a dagɨar ivezir bar pɨn koziba aghorɨva temebar dirir guar avɨriba aghor, egh Purirpenim asɨngamin ingangarir avɨribar fofozir aghuiba a ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Egha Ikiavɨra Itir God fofozir aghuarim isa Besalel ko Oholiap ganɨngi. Oholiap, a Ahisamakɨn otarim, a Danɨn anabamɨn gumazir mam. Aning ingangarim damuamin gumazir igharaziba sure damuamin fofozim iti. ");
INSERT INTO msy2020_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ikiavɨra Itir God gumazir kamning ingangarir guar avɨribar amuamin fofozir aghuim aning ganɨngi, ezɨ aning dagɨabar nedaziba aghora egha dirir avɨriba aghora, egha inir ghurghurir aghuiba isava tretɨn blupla ko, tretɨn pɨghaghevim ko, tretɨn aghevir me sipsipɨn arɨzimɨn ingarizim nuavigha, dar kurke. Egha aning bizir me damuasa nɨghnɨzir kabar fofozim ikia egha bizir kaba bar dar ingari.” ");
INSERT INTO msy2020_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Egha Moses ghua kamaghɨn mɨgɨa ghaze, “Ikiavɨra Itir God Besalel ko Oholiap ko fofozim itir gumazir igharazibar dei. Gumazir kaba, Ikiavɨra Itir God ingangaribar amuamin fofozim me ganɨngi. Ikiavɨra Itir God mɨkemezɨ moghɨn, me Godɨn Purirpenim ko an bizibar ingaram.” ");
INSERT INTO msy2020_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ezɨ gɨn Moses Besalel ko, Oholiap, ko gumazir Ikiavɨra Itir God fofozir aghuim anɨngiziba bar men dia. Ezɨ gumazir ingangarim damuasa bar ifongeziba, me izima Moses ingangarim damuasa me mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Egha Israelia Godɨn Purirpenimɨn ingarasa akuvazir biziba, Moses bar da isa gumazir kabagh anɨngi. Egha Israelian gumazamiziba zurara mɨzarazibar uan ifongiabar gɨn ghua ofan mɨn biziba God danɨngasa da isa izavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ezɨ Purirpenimɨn ingarir gumaziba bizir kabar gari, da avɨrasemezɨ, me uan ingangariba ategha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Egha me kamaghɨn Moses mɨgei, “Gumazamiziba bizir bar avɨriba inigha izi. Ikiavɨra Itir God e mɨkemezɨ bizir e ingangarim damu anegɨvamiba, da bar iti. Eghtɨ bizir avɨrim pura ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ezɨ Moses akam amadazɨ a bar gumazamiziba bagha me itir danganibar ghua ghaze, “Ia gumazamiziba, Godɨn Purirpenimɨn ingarsɨ ua bizitaba inigh izan markɨ.” Ezɨ me akar kam baregha, ua bizitaba inigha izir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ezɨ bizir gumazamiziba inigha Purirpenimɨn ingarasa izegha gɨvaziba, da bar ingangarir kaba agɨvaghtɨ, dar naba pura ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Egha ingangarir gumazir fofozim itiba Godɨn Purirpenimɨn ingari. Egha me 10plan inir ghurghurir aghuaribar an ingari. Nir kaba me tretɨn bluplaba ko, pɨghagheviba ko, agheviba inigha enselɨn bar gavgavibar nedaziba inir kabar da isami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Egha me 10plan inir kabar ingarizɨ, dar oteviba bar voroghɨra ghue. Ezɨ dar ruariba 12 mitan tuzɨ, dar aroziba 2 mitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Egha da arueghasa me 5plan iniba da uarir akuigha uam ada isami, egha 5plan mabar akuigha ua kamaghɨra da isami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Egha aning isafuraghasa, me bluplan tretɨn irɨghizir kuzir kabar inimningɨn mɨriamningɨn da isami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Egha me 50plan tretɨn irɨghizir kuziba inir faragha itimɨn mɨriam gɨtui, egha 50plan tretɨn irɨghizir kuziba namba 2ɨn inim kamaghɨra a gituizɨ da voroghɨra ghue. ");
INSERT INTO msy2020_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Egha me 50plan golɨn akezibar ingarigha, inir ruarir kamningɨn kuziba isafuragha aning ikezɨ, aning Purirpenir vamɨram oto. ");
INSERT INTO msy2020_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Me memen arɨzibar 11pla inibar ingarizɨ, da Purirpenim avamin nir ekiar vamɨram oto. ");
INSERT INTO msy2020_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ezɨ inir kaba vaghvagha dar ruariba 13 mitan tu. Ezɨ dar aroziba 2 mitan tu. Ezɨ dar ababanim voroghɨra ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Egha da arueghasa me 5plan iniba uari isafuragha da isamizɨ, da inir ekiar vamɨran oto. Egha 6plan iniba uarir isafuragha da isamizɨ, da inir ekiar vamɨran oto. ");
INSERT INTO msy2020_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Egha me 50plan tretɨn irɨghizir kuziba inigha inir faragha itimɨn mɨriam gituigha, 50pla tretɨn irɨghizir kuziba inigha inir namba 2ɨn mɨriam gɨtui. ");
INSERT INTO msy2020_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Egha 50plan brasɨn akezir ingariziba, da tretɨn irɨghizir kuzibar aghuam. Eghtɨ inir kamning uaning isafuraghtɨ inir ekiar vamɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Egha me Purirpenim avasa, sipsipɨn apuribar inir me penɨn aghevimɨn aghuizimɨn inimɨn ingari. Egha a gisɨn darɨghasa ongarimɨn itir asɨzir ekiamɨn inim inimɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Egha me akasɨn temebar Purirpenimɨn bɨrir agharibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ezɨ bɨrir agharibar ruarim 4 mitan tuzɨ, iter otevir agharibagh iniva ghueziba, 66 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","24","Egha me iter akɨnir pumuningɨn mɨngarimning akɨrigha, silvan boksiamning gisɨn aning asara. Egha me Purirpenimɨn bɨrir aghariba bar kamaghɨra dar ingari. Egha me sautɨn amadaghan Purirpenimɨn 20plan bɨrir agharibar ingari. Egha me silva inigha 40plan boksiar torir muziariba itibar ingarigha, egha bɨrir aghariba dagh ase. Ezɨ boksiar pumuning bɨrir agharir vamɨran apebamɨn ti, egha bɨrir agharimɨn povim gavgavim a ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","26","Egha me kamaghɨra uaghan notɨn amadaghan bɨrir agharibar ingarigha, 20pla bɨrir agharibar ingari, egha me bɨrir agharibar poviba gavgavim dar anɨngasa, 40plan silvan boksiabar ingari. Egh silvan boksiar pumuning gisɨn bɨrir aghariba vaghvagh da ase. ");
INSERT INTO msy2020_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Egha me 6plan bɨrir aghariba Purirpenimɨn gɨrakɨrangɨn aruem ghuaghiri naghɨn dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Egha me bɨrir agharir pumuning Purirpenimɨn gɨrakɨrangɨn itir mɨkebamningɨn aningɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Me mɨkebamningɨn itir bɨrir agharimning vɨn uaningɨn akuigha ghuavanaga bar pɨn oto. Egha bɨrir agharir kamning uaning inigha uanaga ringɨn vamɨran aven ghua voroghɨra iti. Egha mɨkebar ighirazim me kamaghɨram a gami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ezɨ gɨrakɨrangɨn 8plan bɨrir aghariba itima, 16plan silvan boksiaba da bɨrir agharibar povibar suisi, ezɨ boksiar pumuning, bɨrir aghariba vaghvagha dar tuifi. ");
INSERT INTO msy2020_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Egha me akasɨn temer ruariba inigha, dar ighuvir ruaribar ingari. Egha notɨn itir bɨrir aghariba bagha 5plan ighuvibar ingari. Egha sautɨn itir bɨrir aghariba bagha 5plan ighuvibar ingarigha, aruem uaghiri naghɨn itir bɨrir aghariba bagha 5plan ighuvibar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","34","Egha me ringbar ingarigha vaghvagha bɨrir agharibar tongɨra da arɨgha, egha gɨn ighuvir ruarir kaba isa ringbagh aghua ghua, Purirpenimɨn mɨkebar mamɨn ikegha ghua mamɨn tu. Egha me bɨrir aghariba ko ringba ko ighuvir ruariba, golra bar da noke. ");
INSERT INTO msy2020_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Egha me inir ghurghurir ruarir ekiar mamɨn ingarigha, Purirpenimɨn aven anegura. Me inir kam, tretɨn blupla ko, pɨghaghevim ko, aghevir me sipsipɨn arɨzimɨn ingarizimɨn a isami. Egha me deravɨra enselɨn bar gavgavibar nedaziba an kurka da isami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Egha me akasɨn temeba inigha, inir ekiar kam guasa 4plan dɨpenir akɨnibar ingari. Egha me dɨpenir akɨnir kaba golɨn da noke. Egha golɨn akezibar ingarigha nir kamɨn suighasa dɨpenir akɨnibar da arɨki. Egha me 4plan silvan bokisiabar ingarigha, egha dɨpenir akɨnir kaba asasa dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Egha me Purirpenimɨn tiar akamɨn mɨn ikiasa, inir ghurghurir aghuarimɨn ingari. Me tretɨn sipsipɨn arɨzibar ingarizir blupla ko, pɨghaghevim ko, aghevimɨn an kurkegha da isami. ");
INSERT INTO msy2020_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Egha me 5plan dɨpenir akɨnibar ingarigha, inim guasa akeziba dagh itui. Egha me gol inigha dar dapanibagh aghui, egha dɨpenir akɨnibagh inivamin ighuviba saram aghui. Egha me 5plan brasɨn boksiar toriba itibar ingarigha dɨpenir akɨniba asasa dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ezɨ Besalel ingangarir gumaziba ko me akasɨn temer arariba isa, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn ingari, ezɨ an ruarim 110 sentimitan tu, ezɨ an arozim 66 sentimitan tu, ezɨ an tuirivim 66 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Egha me golɨn aghuarim isa Boksiamɨn averiam ko azenimɨn poghava a noke. Egha golɨn ruarir mamɨn an apɨnimɨn azenan bar an pogha a ikiagharui. ");
INSERT INTO msy2020_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Egha me Boksiam darugh aneterasa gol ringɨn 4plan ingarigha, a tuivamin suer 4plan boroghɨn gol ringɨn 4pla arɨki, egha 4plan suebagh ike, pumuning isa Boksiamɨn vongɨn aning ikegha pumuning vongɨn aning ike. ");
INSERT INTO msy2020_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Egha me Boksiam aterasa akasɨn iter otevir pumuning inigha, deragha aning akɨrigha, golrama aning pogha aning noke. ");
INSERT INTO msy2020_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Egha me Boksiam aterasa iter otevir kamning isava, mam vongɨn an ringning garugha, mam vongɨn an ringning garu. ");
INSERT INTO msy2020_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Egha me Boksiamɨn asuam golɨn aghuarimɨn an ingari. An ruarim 110 sentimitan tu, ezɨ an arozim 66 sentimitan tu. Danganir kam, kar gumazamizibar arazir kuraba gɨn amadir danganim. ");
INSERT INTO msy2020_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Egha me golɨn maba inigha haman dav mɨsuegha enselɨn bar gavgavir pumuningɨn nedazimningɨn ingari. Ezɨ enselning Boksiamɨn asuam gisɨn tughav ikia, mav vongɨn iti, mav vongɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ezɨ mam agharir guvimɨn tughav itima mam agharir kɨriamɨn tughav iti. Me golɨn mam inigha, enselɨn bar gavgavir kamningɨn nedazimning ko Boksiamɨn asuamɨn danganir kamran dar ingarizɨ, da bizir vamɨran mɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ezɨ enselɨn bar gavgavir pumuningɨn nedazim arazir kuraba gɨn amadir danganimɨn tughav iti, ezɨ aningɨn guamning uaningɨn akuigha aviragha Boksiamɨn gari, ezɨ aningɨn avɨzimning kuiaghirɨgha ikia, Boksiamɨn asuam avara. ");
INSERT INTO msy2020_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Egha me akasɨn tememɨn dakozir mamɨn ingari, ezɨ an ruarim 88 sentimitan tu, ezɨ an arozim 44 sentimitan tuzɨ, an tuirivim 66 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","12","Egha me dakozir kam golɨn aghuarimɨn an puegha a noke, egha golɨn ruarir mamɨn an mɨriamɨn pogha bar a ikiagharui. Egha me golɨn ruarir kam gamizɨ a mong fɨgha anabogha, dakozimɨn apɨniba bar da inigha, an tuirivim 8 sentimitan tu. Ezɨ me golɨn ruarir kamɨn, an mɨriamɨn golɨn igharazir mamɨn adiarim gamigha an puegha golɨn ruarir kam bar a ikiagharɨki. ");
INSERT INTO msy2020_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","14","Egha me gol ringɨn 4plan ingarigha dakozimɨn mɨkebabar suebar boroghɨn da ike. Ezɨ 4plan gol ringɨn kaba dakozimɨn apɨnimɨn boroghɨra iti. Da akasɨn temer dakozim ateramningɨn suigham. ");
INSERT INTO msy2020_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Egha me akasɨn iter otevir pumuning isa dakozim aterasa deragha aning akɨrigha, golrama aningɨn pogha aning noke. ");
INSERT INTO msy2020_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Egha me dakozim gisɨn dafasa itarir ekiaba golɨn aghuimra dar ingari. Kar ofa damu wain fusfughamin itarir ekiaba ko, doziba, kapba ko, botolba. ");
INSERT INTO msy2020_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Egha me golɨn aghuarim inigha lamɨn aghorimɨn ingari. Egha haman golɨn kam mɨsuegha lamɨn aghorim asamin danganimɨn ingarigha, lambar aghariba ingarigha dar afamin danganibar boroghɨn, akɨmarir tɨghar onamiba ko onezibar ingari. Egha biziba bar dar ingarizɨ da bizir vamɨran mɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Ezɨ lamba afamin aghorir kam, 6plan aghariba iti, egha 3pla vongɨn itima, 3pla vongɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ezɨ lamba afamin aghorir kam, 6plan aghariba vaghvagha akɨmarir 3pla iti, egha da lamɨn kabar apengan iti. Ezɨ lamɨn aghariba bar kamaghɨra gari. Ezɨ akɨmaribar ganganiba amonɨn tememɨn akɨmaribar mɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Ezɨ lamɨn aghorim uabɨ kamaghɨn gari, me akɨmarir 4plan ingarizɨ, da amonɨn tememɨn akɨmaribar mɨn, dar maba tɨghar onezibar mɨn gari, ezɨ maba onezibar mɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Egh agharir pumuning uaningɨn akuizɨ naghɨn, me akɨmarir dafarir muziarir kabar ingari. Egha agharir igharaziba uaghan kamaghɨra dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Me hama inigha golɨn aghuir kam mɨsuegha, bizir kabagh amizɨ da bizir vamɨran mɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Me golɨn aghuariba inigha, 7plan lambar ingarigha, akamimɨn mɨn garir avimɨn suizir bizir mabar ingarigha, egha uaghan itaribar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Me 35 kilogremɨn golɨn aghuariba inigha, lamba afamin aghorim ko lamba ko an ingangarir biziba bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Egha me akasɨn temem inigha pauran mughuriar aghuim tuamin ofa gamir dakozimɨn ingari. Ezɨ ofa gamir dakozir kamɨn ruarim 45 sentimitan tuzɨ, an arozim an ruarim mɨrara ghua 45 sentimitan tu, ezɨ an tuirivim 90 sentimitan tu. Temer akasɨn ofa gamir dakozimɨn ingarizimra, me bulmakaun kombar mɨn garir bizibar ingarizɨ, da ofa gamir dakozimɨn mɨkebabar vaghvagha dar iti. ");
INSERT INTO msy2020_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Egha me an 4plan mɨriaba ko an siriam ko an komba golɨn aghuarimɨn dar puegha da noke, egha golɨn ruarim isa ofa gamir dakozimɨn mɨriabagh atɨgha a ikiagharui. ");
INSERT INTO msy2020_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Egha me gol ringɨn pumuningɨn ingarigha, mam isa vongɨn a ikegha, vongɨn mam ike. Me ringɨn kamning golɨn ruarir me an mɨriabar ikezimɨn apengan aning ike. Ringɨn kamning me ofa gamir dakozim atersɨ tememning aning daghuam. ");
INSERT INTO msy2020_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Me akasɨn iter pumuning inigha ofa gamir dakozim aterasa aning akɨrigha, golɨn aning noke. ");
INSERT INTO msy2020_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Egha me pauran mughuriar aghuim ko olivɨn borem deravɨra da verezɨ, borer mughuriar aghuim oto, mati sanda. Olivɨn borer kam, an ingangarim kamakɨn: me bizim o gumazim Ikiavɨra Itir God bagh anemɨsɨvɨsɨ, borer kam a gingam. Me uaghan pauran mughuriar aghuim zuir mabar ingari, mati gumazir fofozir aghuim itim deravɨra da verezɨ, sandan aghuim oto. ");
INSERT INTO msy2020_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Egha Besalel ko ingangarir gumazir igharaziba, akasɨn temeba inigha, asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn ingari. Ezɨ an arozim ko an ruarimɨn ababanim vɨrara 2 mita 20 sentimitan tu. Ezɨ an tuirivimɨn ababanim 1 mita 30 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Egha temer akasɨn ofa gamir dakozimɨn ingarizimra, me bulmakaun kombar mɨn garir bizibar ingarizɨ, da ofa gamir dakozimɨn mɨkebabar vaghvagha dar iti, egha ofa gamir dakozim me brasɨn an pogha a noke. ");
INSERT INTO msy2020_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ofan dakozimɨn ofan ingangarim damuasa me bizir kabar ingari, savolɨn muziariba, itarir ekiaba, pokba ko, itarir avim ateramin ko averenim iniamin itarim ko avim ateramin itariba, ko averenim iniamin itaribar ingari. Bizir kaba bar me brasɨn dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","5","Egha me bras uaia inigha abizimɨn mɨn garir bizimɨn ingari. Egha ofa gamir dakozimɨn aven anetɨ. Egha me brasɨn ringɨn 4plan ingari. Egha da isa ofa gamir dakozimɨn, abizimɨn mɨkebabar da arɨki. Kar ringɨn tememning arugh boksiam ateramiba. Egha brasɨn ruarim inigha ofa gamir dakozimɨn averiamɨn tongɨram anetɨgha a ikiagharui. Egh uaia brasɨn abizimɨn mɨriaba isa brasɨn ruarir kamɨn apengan anegura. Ezɨ abizimɨn mɨn garir bizir kam, ofa gamir dakozimɨn averiamɨn tongɨram apera. ");
INSERT INTO msy2020_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Egha me akasɨn iter otevir pumuning inigha, aning akɨrigha brasɨn aning puegha aning noke. ");
INSERT INTO msy2020_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Me ofa gamir dakozim aterasa akasɨn temer kamning isa ringɨn an mɨriamningɨn itibagh aghui. Me temer arariba inigha ofa gamir dakozim boksiamɨn mɨn an ingari, egha boksiamɨn dɨkɨnimɨn ingarizir puvatɨ. Me anetaghizɨma an dɨkɨnim pura torim iti. ");
INSERT INTO msy2020_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Ezɨ amiziba zurara God bativamin Purirpenimɨn tiar akamɨn boroghɨn Godɨn ingangarim gami, egha merara uan brasba isa Besalel ganɨngi. Brasɨn kaba, da ganganir me uan guabar garibar mɨn gari. Ezɨ ingangarir gumaziba brasɨn kaba inigha, egha soroghafariba ruer itarir ekiamɨn ingari, egha itarir kam afasa dakozimɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Egha me inir ghurghurir aghuimɨn ingarigha, Purirpenim avɨnasa dɨvazir azenan itimɨn ingari. Me inir ruarir kam sautɨn amadaghan itir dɨvazim bagha an ingarizɨ a 44 mitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Egha me inir kam guasa 20plan dɨpenir akɨniba brasɨn dar ingarigha, egha dɨpenir akɨnir kaba 20plan brasɨn boksiabagh asasa dar ingari. Egha inir kam guamin akeziba ko dɨvazimɨn agharir ighuviba silvan dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Egha kamaghɨra notɨn amadaghan itir dɨvazimɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Ezɨ dɨvazir aruem ghuaghiri naghɨn itim, me inir ruarir mamɨn ingarizɨ, a 22 mitan tu. Egha 10plan dɨpenir akɨniba ko, 10plan brasɨn boksiar dɨpenir akɨniba asamibar ingari. Egha inir kam guamin akeziba ko dɨvazimɨn agharir ighuviba silvan dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ezɨ dɨvazir aruem anadi naghɨn itim, an ababanim 22 mitan tu. Ezɨ dɨvazir kam tiar akam an iti. ");
INSERT INTO msy2020_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Tiar akamɨn mɨriamningɨn me dɨpenir akɨniba asasa brasɨn boksiabar ingarizɨ, 3pla vongɨn itima, 3pla vongɨn ti. Egha tiar akamningɨn mɨriamningɨn guasa nir pumuningɨn ingari. Aningɨn arozimning vɨrara 6 mita 60 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Me dɨvaziba bar dar guasa inir ghurghurir bar aghuaribar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Me bras inigha, dɨpenir akɨniba asamin boksiabar ingari. Egha me silva inigha dɨpenir akɨnibar dapanibar puegha da noke. Egha me silvan ighuvibar ingari. Egha me silvan akezibar dɨpenir akɨniba ko silvan agharir ighuvibar suighasa dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Egha dɨvazimɨn tiar akam bagha, me inir ghurghurir aghuarim ko tretɨn blupla ko, pɨghaghevim, ko aghevir me sipsipɨn arɨzimɨn ingariziba isamigha inir kamɨn kurke. Ezɨ inir kamɨn arozim 9 mitan tu. Ezɨ an tuirivim 2 mita 20 sentimitan tu, egha a dɨvazimɨn iniba ko voroghɨra ghu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Me inir kaba guasa dɨpenir akɨnir 4pla ko, da asamin brasɨn boksiar 4plan ingari. Ezɨ akeziba ko, dɨpenir akɨnibar dapaniba, ko agharir ighuvir dɨpenir akɨnir uarir akuighamba, me bar silvara dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Egha me Purirpenim gavgavim a danɨngamin afughafughamiba ko an dɨvazim gavgavim a danɨngamin afughafughamiba, me brasɨn dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Egha me Ikiavɨra Itir Godɨn Purirpenimɨn ingarasa inigha izezir gol, silva, ko bras menge. Purirpenir kam, me Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuamning a darɨgham. Moses uabɨ Livain adaraziv kemezɨ me biziba bar da mega da osirigha fo, bizir manabara iti. Ezɨ ofa gamir gumazim Aron, an otarim Itamar ingangarir kamɨn faragha zui. ");
INSERT INTO msy2020_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Besalel a Urin otarim, ezɨ Uri a Hurɨn otarim, me Judan anabamɨn gumaziba. Ezɨ Besalel, Ikiavɨra Itir God Moses mɨkemezɨ moghɨn biziba bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ezɨ Oholiap, an Ahisamakɨn otarim, egha Danɨn anabamɨn mav. An akaba dagɨabar da osira da aghori fofozim fomɨra iti, egha a bizir igharaziba uaghan dar ingara fo. Egha a tretɨn blupla, pɨghaghevim ko, aghevir me sipsipɨn arɨzimɨn ingarizim, ko inir ghurghurir aghuariba, an a da isa dar kurka fo. ");
INSERT INTO msy2020_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ezɨ me, golɨn gumazamiziba Godɨn damazimɨn fegha ighuavamadir ofan mɨn Godɨn Purirpenimɨn ingarasa inigha izeziba medi, ezɨ dar osɨmtɨzim ghua 998 kilogremɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Ezɨ me silva medima, an osɨmtɨzim ghua 3,430 kilogremɨn tu. Gumazir ziaba akɨnafarimɨn itiba silvan kaba amadazɨma da ize. Ezɨ gumazir 20plan azenibar tugha ghuavanadiba, me vaghvagha 5 kina silvan dagɨaba arɨki, ezɨ gumazir kaba bar men dɨbobonim 603,550. ");
INSERT INTO msy2020_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ezɨ me 3,400 kilogrem silva inigha, Godɨn Purirpenimɨn bɨrir aghariba gavgavim dar anɨngasa boksiabar ingari. Egha me Bar Anogoroghezir Danganim avamin inim guasa, dɨpenir akɨnibagh asamin boksiabar ingari. Ezɨ boksiar kaba da bar moghɨra 100pla. Ezɨ boksiaba vaghvagha dar osɨmtɨzim 34 kilogremɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ezɨ silvan nar ikiavɨra itibar osɨmtɨzim 30 kilogremɨn tu. Ezɨ me da isa akeziba ko agharir ighuvibar ingarava, egha da isa bɨrir aghariba uarir akuighasa dar ingari. Egha me uaghan dɨpenir akɨnibar dapaniba, silvan da ave. ");
INSERT INTO msy2020_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ezɨ brasɨn me ofan mɨn Ikiavɨra Itir God ganɨngizimɨn osɨmtɨzim a 2,425 kilogremɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ezɨ me brasɨn kam inigha God bativamin Purirpenimɨn tiar akamɨn akɨnibagh asamin boksiabar ingari. Egha brasɨn ofa gamir dakozim ko, an abizimɨn mɨn garir bizim ko, bizir ofan ingangarim damuamiba, me bar brasɨn dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Me uaghan boksiar igharazibar ingari, kar dɨvazimɨn tiar akamɨn dɨpenir akɨniba asamin boksiaba ko, dɨvazir bar Purirpenim gighuizimɨn dɨpenir akɨnibagh asamin boksiaba. Egha me uaghan, Purirpenim gavgavim a danɨngamin afughafughamiba ko dɨvazir a gighuizim gavgavim a danɨngamin afughafughamiba, bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Egha me tretɨn blupla ko, pɨghaghevim ko aghevir me sipsipɨn arɨzibar ingariziba inigha, ofa gamir gumazibar korotiar aghuibar ingarigha dar kurke, eghtɨ me Anogoroghezir Danganimɨn mangɨ ingangaribar amusɨ dar aghuam. Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me Aron darugh ofa damuamin korotiamɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","3","Egha me korotiar otevimɨn ingarasa, haman gol mɨsoghezɨ, an akɨnafarimɨn mɨn evari, ezɨ me a inigha aneghorezɨ a gol tretɨn mɨn oto. Ezɨ me inir ghurghurir aghuarim inigha, gol tret ko, tretɨn blupla, pɨghaghevim ko, tretɨn aghevir me sipsipɨn arɨzimɨn ingarizim, me inir kam kurkazir aghuibar a isami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Egha me inir sazir pumuning korotiamɨn suighasa a gisɨn aning isami, eghtɨ aning dɨpɨzimning gisɨn anang mangɨ akɨrimɨn inir otevir vongɨn itimɨn suigham. ");
INSERT INTO msy2020_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ezɨ me gol tret, ko tretɨn blupla, pɨghaghevim, ko tretɨn aghevir me sipsipɨn arɨzibar ingarizim ko inir ghurghurir aghuarim inigha, egha inir ivariam gikamim adiarir aghuariba a garɨgha an ingari. Egh inir ivariam gikamim isa korotiar otevir azenan itir kamɨn mɨriamɨn porogha a isami, ezɨ bizir pumuning datɨrɨghɨn bizir vamɨran mɨn iti. Egha me Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, tretɨn kaba inigha inir kam isami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Egha me dagɨar pɨzir aghuarir pumuning inigh, Jekopɨn otarir 12plan ziaba aningɨn dar ghora da osiri. Egha me gol inigha dagɨamningɨn suighasa, golɨn kurkazir pumuningɨn ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Egha me dagɨar kamning isa, korotiar otevir azenan itim, an dɨpɨzimningɨn itir inir sazimning dukuagha aning isami, ezɨ aning Israelɨn 12plan anababar ababanimɨn mɨn iti. Me God Moses mɨkemezɨ moghɨra dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Egha me ofa gamir gumazibar dapanimɨn evarim gikiasa forivtarir inimɨn ingari. Egha me kamaghɨra korotiar otevir azenimɨn itimɨn ingarizimɨn mɨrara, gol tret, ko tretɨn blupla, ko pɨghaghevim, ko tretɨn aghevir me sipsipɨn arɨzibar ingarizim ko inir ghurghurir aghuarim inigha, forivtarir inir muziarir kam bar deragha an ingarigha kamaghɨrama an kurke. ");
INSERT INTO msy2020_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Me forivtarir inir muziarir kamɨn ingarizɨ, an ruarim 44 sentimitan tuzɨ an arozim 22 sentimitan tu. Egha deravɨra tongɨra a remezɨ, a forivtarimɨn mɨn oto, ezɨ an otevibar ababaniba voroghɨra ghu, da bar 22 sentimitan tu. ");
INSERT INTO msy2020_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","14","Egha me dagɨar ivezim bar pɨn koziba isa, 12plan dagɨar kaba bar da vaghvagha Jekopɨn otaribar ziaba aghora da osiri, ezɨ dagɨaba vaghvagha 12plan anababar ababanimɨn mɨn iti. Me golɨn maba inigha dagɨabar suizir golɨn kurkazibar ingari, egha dagɨaba vaghvagha da afegha egha forivtarir inimɨn azenan da ike. Me 4plan abiar ruaribagh atɨgha forivtarir inir kam gike. Egha faragha itir abiamɨn, dagɨar me kamaghɨn dɨboriba, rubi, topas, ko ganet, da ike. Egha abiar an gɨrara itimɨn, dagɨar emeral, sapaia, ko daimon ike. Egha abiar mɨkezimɨn, dagɨar terkois, aget, ko ametis ike. Egha namba 4ɨn abiamɨn, dagɨar beril ko, dagɨar pɨzir aghuarim ko jaspan dagɨam ike. ");
INSERT INTO msy2020_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Egha me golɨn aghuarim inigha tretɨn mɨn ikarɨzibagh irigha da nuavigha benir pumuningɨn ingarizɨ, aning forivtarir inir evarimɨn guraghav itimɨn suigham. ");
INSERT INTO msy2020_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","17","Egha me dagɨamningɨn suighasa golɨn kurukazir pumuning, ko gol ringɨn pumuningɨn ingarigha, ringɨn kamning isa evarimɨn itir forivtarir inimɨn mɨkebar pɨn itimningɨn aning gike. Egha me golɨn benimning isa, aningɨn otevimning, forivtarir inimɨn itir gol ringɨn kamning gike. ");
INSERT INTO msy2020_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Egha me golɨn benir otevir igharazimning isa dɨpɨzimningɨn itir dagɨamningɨn suizir golɨn kurkazimning gike. Egha tuavir kamɨn forivtarir inir kam, korotiar otevir azenan itim a gike. ");
INSERT INTO msy2020_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Egha me ua gol ringɨn pumuningɨn ingarigha, aning isa evarimɨn itir forivtarir inimɨn mɨkebar vɨn itimningɨn aning gike. Ringɨn kamning datɨrɨghɨn korotiar otevir azenan itimɨn boroghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Egha me gol ringɨn pumuning uam aningɨn ingarigha, aning isa korotiar otevir azenan itimɨn dɨpɨzimningɨn vɨn korotiar otevimɨn aning isami. Aning datɨrɨghɨn, inir ruarir me deravɨra kurkezimɨn pɨn, inimning uaningɨn akuizir danganimɨn boroghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Egha me benir sazir blupla inigha, evarimɨn itir forivtarir inimɨn ringning isa korotiar otevir azenan itimɨn ringning gike, ezɨ evarimɨn itir forivtarir inim, korotiar otevir azenimɨn itimɨn suiragha gavgafi, ezɨ forivtarir inim suaghirir puvatɨ. Me Ikiavɨra Itir God Moses mɨkemezɨ moghɨrama ami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Egha me korotiar ruarir azenan itimɨn ingarizɨ, a korotiar otevir azenan itimɨn apengan iti. Me inir bluplan kɨnim, sipsipɨn arɨzimɨn ingarizimɨn an ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Egha me korotiar kam torim a gatɨ, eghtɨ ofa gamir gumazim uan dapanim aghuam. Me inir avɨzir muziarir mam isa torir kam mɨdorozir korotiam isamizɨ moghɨn a ighuigha a isami, eghtɨ an torimɨn apɨniba gavgavightɨ torim bigh ekevegh mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","26","Me tretɨn blupla ko pɨghaghevim ko tretɨn aghevir me sipsipɨn arɨzimɨn irɨghizim inigha, iter pomigranetɨn ovɨzibar mɨn biziba isami. Egha ofa gamir gumazibar dapanimɨn korotiar ruarir azenan itimɨn vɨn bizir kaba isami. Egha golɨn aghuimɨn ingarizir beloba vaghvagh pomigranetɨn ovɨzibar tizibar da isamizɨ, da ituighav iti. Eghtɨ ofa gamir gumazibar dapanimɨn korotiar kam arugh ofa gamir gumazimɨn ingangarim damuam. Me Ikiavɨra Itir God Moses mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","29","Egha me Aron ko an otariba bagha inir ghurghurir aghuariba inigha korotiar ruarir aven azuiba isami. Egha Aronɨn dapanim darɨghasa inir ghurghurir aghuarim inigha, dapanir asuar ruarimɨn ingari. Egha Aronɨn otariba bagha inir ghurghurir aghuariba dapanir asuar otevibar ingari. Egha me inir ghurghurir aghuarim inigha, me bagha trausiziar oteviba isami. Egha inir ghurghurir aghuarim inigha, inir ghurghurir aghuarir ruarir ivariam gitimɨn ingarigha, egha tretɨn sipsipɨn arɨzibar irɨghizir blupla ko, pɨghaghevim ko, aghevim isa kurkazir aghuibar an da isami. Me Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me biziba bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Egha me Ikiavɨra Itir God ua bagha mɨsevir ofa gamir gumazibar dapanim bagha, golɨn akuar aghuarir mam inigha medelɨn mamɨn ingari. Egha me akam kamaghɨn a gisɨn an osiri, “Kar Ikiavɨra Itir Godɨn Gumazimra.” ");
INSERT INTO msy2020_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Egha me bluplan benim inigha, gol medelɨn kam inir dapanir asuar ruarimɨn an guam gituasa an ingari. Eghtɨ an ofa gamir gumazibar dapanimɨn dapanir asuamɨn guam gitoroghɨv ikɨ. Me Ikiavɨra Itir God Moses mɨkemezɨ moghɨrama ami. ");
INSERT INTO msy2020_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Egha me dughiar kamɨn God bativamin Purirpenimɨn ingangariba, bar da gɨfa. Egha Israelia Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me biziba bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Egha me bizir kaba bar da inigha Moses bagha zui: Purirpenir kam ko, an biziba bar, an akeziba, dɨvazir aghariba, agharir ighuviba, dɨpenir akɨniba ko, boksiar dɨvazir aghariba ko akɨnibagh asamiba, ");
INSERT INTO msy2020_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ko Purirpenim avamin avaver ekiar me sipsipɨn apuribar nir me aghevimɨn aghuizim, ko avaver ekiar me ongarimɨn itir asɨzir ekiabar inibar ingarizim, ko Bar Anogoroghezir Danganim modir inir ekiam, ");
INSERT INTO msy2020_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ko Akar Dɨkɨrɨzir Gavgavimɨn Boksiam, ko an asuam, kar arazir kuraba gɨn amadir danganim, ko boksiar kam aterasa iter pumuning, ");
INSERT INTO msy2020_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ko bretba arɨzir dakozim, ko an ingangarim gamir biziba, ko Godɨn damazimɨn arɨzir bretba, ");
INSERT INTO msy2020_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ko golɨn aghuarimɨn ingarizir lambar afamin aghorim, ko an lamɨn me danganibar afeziba, ko an ingangarim gamir biziba, ko angazangarim anɨngamin olivɨn borem, ");
INSERT INTO msy2020_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ko golɨn ingarizir ofa gamir dakozim, ko biziba mɨsɨv ingiamin olivɨn borem, ko pauran mughuriar aghuim, ko Purirpenimɨn tiar akamɨn guamin inir ekiam, ");
INSERT INTO msy2020_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ko brasɨn ingarizir ofa gamir dakozim, ko dakozir kam bagh brasɨn ingarizir abizimɨn mɨn garir bizim, ko ofa gamir dakozim ateramin itemning, ko ofa gamir dakozimɨn ingarir biziba, ko soroghafaribar ruer itarir ekiam, ko anefamin dakozim, me bar da inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Egha uaghan, me Purirpenimɨn dɨvazim avɨnasa iniba, ko dɨvazimɨn dɨpenir akɨniba, ko boksiar akɨniba asamiba, ko dɨvazimɨn tiar akamɨn guamin inim, ko gavgavim dɨvazim danɨngamin beniba ko afughafughamiba, me God bativamin Purirpenimɨn aven ingangarim damuasa bizir kaba bar da inigha izi. ");
INSERT INTO msy2020_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Aron, a ofa gamir gumazim, a uan otariba ko, me bagh korotiar aghuaribara isamigha da inigha izi. Eghtɨ me gɨn dar aghuigh, egh ofa gamir gumazimɨn ingangarim damuam. Kar, me daghuigh Anogoroghezir Danganimɨn aven mangamin korotiaba. ");
INSERT INTO msy2020_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ezɨ Israelia Ikiavɨra Itir God ingarasa Moses mɨkemezir biziba, me bar dar ingari. ");
INSERT INTO msy2020_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ezɨ Moses deraghavɨra bizir me ingarizibar gari, egha a fo, Ikiavɨra Itir God, mɨkemezɨ moghɨra me biziba bar dar ingari. Egha a dar ganigha gɨvagha, deraghvɨra me damuasa, kamaghɨn mɨgei, “Ikiavɨra Itir God, bar deraghvɨra ia damu.” ");
INSERT INTO msy2020_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Egha Ikiavɨra Itir God Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Nɨ orakigh. Ia iakɨnir namba 1 an dughiar namba 1, ia na bativamin Purirpenim asaragh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Egh ia nan Akar Dɨkɨrɨzir Gavgavimɨn Boksiar dagɨar akuar pumuning aven itir kam inigh, Purirpenimɨn aven anetɨgh, egh boksiam mongsɨ inir ekiam aguragh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Egh bretba arɨzir dakozim inigh aven mangɨ anetɨgh, an biziba a gisɨn dar arɨkigh. Egh lambar afamin aghorim inigh izɨ anesaragh, egh lamba isɨ an agharibar arɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Egh golɨn ofa gamir dakozir me pauran mughuriar aghuim tuamim, a isɨ Akar Dɨkɨrɨzir Gavgavimɨn Boksiar dagɨar akuar pumuning aven itir kamɨn, boroghɨn anetɨgh. Eghtɨ inir ekiar Boksiam modim aning abightɨ an azenan ikɨ. Egh Purirpenimɨn tiar akamɨn itir inir ekiam aguragh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Egh ia asɨziba bar isia mɨghɨrir ofa gamir dakozim isɨ, na bativamin Purirpenimɨn tiar akar azenan itimɨn anetɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Egh na bativamin Purirpenim ko ofa gamir dakozir kamɨn tongɨra, soroghafariba ruer itarir ekiam atɨgh, egh dɨpam a datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Egh ia dɨvazimɨn mɨn inir ekiam aguraghtɨ a Purirpenim bar a gighuigham. Egh dɨvazimɨn tiar akamɨn inir ekiam aguragh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Egh gɨn ia biziba mɨsɨv ingiamin olivɨn borem inigh, egh Purirpenim ko an aven itir biziba bar dagh ingegh. Egh ia dagh ingeghtɨ, da bar nan bizibar mɨn ikɨ, bar na baghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Egh ia borem isɨ, asɨziba bar isia mɨghɨrir ofa gamir dakozim ko an ingarir biziba bar dagh ingeghtɨ, ofa gamir dakozim na baghvɨra ikɨ, bar anogoregham. ");
INSERT INTO msy2020_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Egh kamaghɨra soroghafariba ruer itarir ekiam ko anefamin dakozim damigh, eghtɨ bizir kaba uaghan na baghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Egh gɨn nɨ Aron uan otariba ko me inigh izɨ, na bativamin Purirpenimɨn tiar akamɨn me ruegh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","“Egh ofa gamir gumazibar korotiar aghuariba Aron daghuigh, egh biziba mɨsɨv dagh ingiamin borem isɨ a gingegh anemɨseveghtɨ, a ofa gamir gumazimɨn mɨn nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Egh nɨ an otariba inigh roghɨra izɨ, ofa gamir gumazibar korotiar ruarir aven itiba inigh, me daghuigh. ");
INSERT INTO msy2020_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Egh nɨ men afeziam amɨsevezɨ moghɨn, nɨ borem me gingɨ egh me amɨseveghtɨ me na bagh ofa gamir ingangarim damu. Nɨ borem me gingegh me amɨseveghtɨ, gɨn me uari uan adarazi ko ofa gamir ingangarim damu mamaghɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ezɨ Moses Ikiavɨra Itir God a mɨkemezɨ moghɨra a biziba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Dughiar me Isip ataghizimɨn gɨn, azenir an gɨn zuimɨn, iakɨnir faragha zuim, an dughiar namba 1ɨn, dughiar kamra me Godɨn Purirpenim asara. ");
INSERT INTO msy2020_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Dughiar kamɨn Moses Purirpenimɨn asara. A boksiaba isa, nguazimɨn da arigha, dɨvazir aghariba isa boksiabagh ase, egha dɨvazimɨn agharir ighuviba da ikia, egha inir ekiam guasa dɨpenir akɨniba asi. ");
INSERT INTO msy2020_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me nir ekiam Purirpenimɨn agharim gisɨn anetɨgha, Purirpenim aver sipsipɨn apuriba ko ongarimɨn asɨzir ekiabar inir igharazir pumuning uam anevara. ");
INSERT INTO msy2020_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Egha me dagɨar akuar God uan Akar Gavgaviba osirizimning inigha, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn aning atɨ. Egha me aneteramin temer pumuning inigha Boksiamɨn ringbagh arugha, Boksiamɨn asuam isa Boksiam dukua. Ezɨ Boksiar asuar kam, kar arazir kuraba gɨn amadir danganim. ");
INSERT INTO msy2020_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Egha me Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, Boksiam Purirpenim gatɨgha, inim agurazɨ a Boksiam modo. ");
INSERT INTO msy2020_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Egha me bretba arɨzir dakozim isa, God bativamin Purirpenimɨn, notɨn amadaghan Anogoroghezir Danganimɨn aven anefa. ");
INSERT INTO msy2020_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me bret inigha Ikiavɨra Itir Godɨn damazimɨn dakozim gisɨn deraghavɨram anetɨ. ");
INSERT INTO msy2020_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Egha lambar afamin aghorim inigha, God bativamin Purirpenimɨn, sautɨn amadaghan, bretba arɨzir dakozimɨn vongɨn anesara. ");
INSERT INTO msy2020_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me lamba isa dar agharibagh arɨki. Egha Ikiavɨra Itir Godɨn damazimɨn dagh aboi. ");
INSERT INTO msy2020_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Egha me golɨn ingarizir ofa gamir dakozim isa God bativamin Purirpenimɨn aven, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn boroghɨn nir ekiamɨn azenan anefa. Ezɨ inir ekiam aning abigha guraghav ikia Boksiam modo. ");
INSERT INTO msy2020_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me ofa gamir dakozir kamɨn pauran mughuriar aghuim tuezɨma, mɨgharir mughuriar aghuim zuim otifi. ");
INSERT INTO msy2020_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Egha me inir ekiam Purirpenimɨn tiar akamɨn anegura. ");
INSERT INTO msy2020_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Egha Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me gɨn asɨziba bar isia mɨghɨrir ofa gamir dakozim isa, God bativamin Purirpenimɨn tiar akamɨn boroghɨn azenan anetɨ. Egha ofa gamir dakozir kamɨn, Moses dughiar kamra ofan mɨn asɨziba tue da bar isia mɨghɨri. Egha uaghan witɨn plaua inigha ofan mɨn da tue. ");
INSERT INTO msy2020_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Egha me soroghafariba ruer itarir ekiam isa, ofa gamir dakozir asɨziba tue da bar isia mɨghɨrim ko, God bativamin Purirpenimɨn tiar akamɨn tɨzimɨn anefagha, dɨpam a ginge. ");
INSERT INTO msy2020_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ezɨ Moses, Aron ko an otariba, me uan soroghafariba dɨpar kamɨn da rue. ");
INSERT INTO msy2020_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Guizbangɨra, me God bativamin Purirpenimɨn aven mangasa, o me ofa gamir dakozimɨn mangɨsɨ, me zurara faragha uan soroghafariba rue. Me amir araziba, Ikiavɨra Itir God Moses mɨkemezɨ moghɨra, me dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Egha me inir ekiaba isa, Purirpenim ko asɨziba bar isia mɨghɨrir ofa gamir dakozim avɨnigha a gighuigha, dɨvazimɨn tiar akamɨn inim agura. Egha Moses gumaziba ko, me bizir kaba bar dagh ami, ezɨ Purirpenimɨn ingangariba bar gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Egha ingangariba bar gɨvazɨ, ghuariam maghɨra iza God bativamin Purirpenim avarazɨ, Ikiavɨra Itir Godɨn angazangarir ekiam Purirpenim bar a gizɨfa. ");
INSERT INTO msy2020_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Bar guizbangɨra, Ikiavɨra Itir Godɨn ghuariam bar Purirpenim avarazɨma an angazangarim a gizɨvazɨma, kamaghɨn Moses God bativamin Purirpenimɨn aven mangan ibura. ");
INSERT INTO msy2020_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israelian tuavir daroriba, me kamaghɨn ami: ghuariar ekiar kam Godɨn Purirpenim ategh pɨn sɨvaghsɨvagh mangɨtɨ, me an ganigh, egh dɨkavigh biziba inigh an gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Egh me ganam, ghuariam Godɨn Purirpenim gisɨn ikɨvɨra ikɨtɨ, me danganir kam ateghan kogham. Puvatɨgham, me ikɨvɨra ikɨ mangɨ ghuariam sɨvaghsɨvagh mangɨtɨ, me mangam. ");
INSERT INTO msy2020_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Guizbangɨra, Israelian tuavimɨn daroribar, ghuariar Ikiavɨra Itir God aven itim, an aruebar Purirpenim gisɨn iti. Ezɨ me aruebar ghuariamɨn gari, egha dɨmagaribar me garima, an avimɨn mɨn isia ghuariamɨn aven iti. Ghuariar kam kamaghɨra ikia me ko ghua Ikiavɨra Itir God me danɨngamin kantrin oto.");
INSERT INTO msy2020_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","2","Ikiavɨra Itir God, uabɨ bativamin Purirpenimɨn ikia, Israelia mɨkɨmasa Mosesɨn diazɨ a izi, ezɨ a kamaghɨn a mɨgei, “Ian gumazitam Ikiavɨra Itir God bagh, ofan tam inigh mangɨsɨ, a uan bulmakaun tam, o sipsipɨn tam, o memen tam inigh mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Egha Moses ua kamaghɨn mɨgei, “Gumazitam izɨ ofan bar isia mɨghɨrim damusɨ, a uan bulmakaun okoruamɨn tongɨn bulmakaun apurir tam iniam, kar bulmakaun bar aghuir duaba an mɨkarzim gasɨghasɨghizir puvatɨzitam, a inigh mangɨ, Ikiavɨra Itir Godɨn navim an deraghsɨ, a bulmakaun kam inigh God bativamin Purirpenimɨn tiar akamɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Egh ofan bar isia mɨghɨrim damusɨ uan dafarim isɨ, bulmakaun kamɨn dapanim gisɨn anetɨgh, eghtɨ Godɨn navim gumazir kamɨn deraghtɨ, an ofan kam inighɨva an arazir kuraba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Egh a Ikiavɨra Itir Godɨn damazimɨn, bulmakaun kam mɨsueghtɨ, Aronɨn otariba, me ofa gamir gumaziba, me bulmakaun ghuziba isɨ, God bativamin Purirpenimɨn tiar akamɨn boroghɨn itir ofa gamir dakozimɨn mɨriar 4plan da kavamang. Egh kamaghɨra me ghuzir kamɨn Ikiavɨra Itir God bagh ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Eghtɨ gɨn gumazir kam, ofan bar isia mɨghɨrimɨn bulmakaun kamɨn inim adegh, an tuziba aghorarɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","9","Egh asɨzimɨn muriam ko suemning, a deraghvɨra da ruegh. Eghtɨ ofa gamir gumazim Aron, an ovavir boriba izɨ, daziba ofan bar isia mɨghɨrimɨn dakozim darigh, egh dar aborogh. Egh me dapanim ko ovim ko asɨzir oteviba bar da isɨ deraghvɨra avim darightɨ, avim dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ Ikiavɨra Itir God ofan asɨzir kamɨn mughuriam baregh, a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Eghtɨ gumazitam ofan bar isia mɨghɨrim damusɨ, a uan asɨzibar okoruamɨn tongɨn sipsip o memen tam inigh, a sipsipɨn apurim o memen apurir bar aghuir duaba an mɨkarzim gasɨghasɨghizir puvatɨzitam inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Egh Ikiavɨra Itir Godɨn damazimɨn an ofa gamir dakozimɨn boroghɨn danganir notɨn amadaghan iti naghɨn, asɨzim mɨsueghtɨ an aremegh. Eghtɨ Aronɨn otariba, me ofa gamir gumaziba, me izɨ asɨzir ghuziba inigh, ofa gamir dakozimɨn 4plan mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","13","Eghtɨ gumazir kam, asɨzim aghorarigh, egh an muriam ko suemning deragh aning ruegh. Eghtɨ ofa gamir gumazitam daziba ofa gamir dakozim darigh, dar aborogh, egh asɨzimɨn dapanim ko ovim, ko asɨzir naba ofa gamir dakozimɨn avimɨn deraghvɨra dar arɨkigh. Egh ofa gamir gumazim, ofan bar isia mɨghɨrir kam isɨ Ikiavɨra Itir God danɨngam, eghtɨ avim dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ Ikiavɨra Itir God ofan asɨzir kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Eghtɨ gumazitam Ikiavɨra Itir God bagh kuarazimɨn ofan bar isia mɨghɨrizim damusɨ, a kuarazir me kamaghɨn dɨborim, bunbam a inigh ofa gamir gumazim bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Eghtɨ ofa gamir gumazim kuarazir bunbam inigh ofa gamir dakozimɨn mangɨ, egh an fɨrim ruivightɨ an aremegh. Egh a bunbamɨn dapanim asigh, egh ofa gamir dakozimɨn a tuaghtɨ avim an isi mangɨtɨ a bar mɨghɨrightɨ, averenir kɨnim otogh. Egh a bunbam ruivightɨ an ghuzim ofa gamir dakozimɨn mɨriam girɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Egh a bunbamɨn arɨziba asigh, an forivtarir dagheba itim isɨ, aruem anadi naghɨn, danganir me ofa gamir dakozimɨn avereniba arɨzi naghɨn anetɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Egh gɨn ofa gamir gumazim bunbamɨn avɨzimningɨn suiragh, an namnam abɨkigh, egh an avɨzimning bar aning asian markɨ. Egh aneteghtɨ, avim bar an isi mangɨtɨ a bar mɨghɨrigh, averenir kɨnimɨn otogh. A kamaghɨn damutɨ, Ikiavɨra Itir God ofan bar isi mɨghɨramimɨn kuarazir kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Egha God Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Gumazitam witɨn ovɨzibar Ikiavɨra Itir Godɨn ofa damusɨ, a witɨn iniba amɨsevegh dar dagheba inigh faragh plauan aghuimɨn ingarigh, egh a inigh izɨ. Egh a olivɨn borem ko mɨgharir mughuriar aghuim zuim itir pauran me iter balsamɨn eborimɨn ingarizim isɨ plauan kam gisɨn aning ingegh, ");
INSERT INTO msy2020_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","egh a inigh Aronɨn adarazir ofa gamir gumaziba bagh mangɨ. Eghtɨ ofa gamir gumazitam uan dafarim plauan kam darugh, egh a plauan muziaritam, ko mɨgharir mughuriar aghuim zuim itir pauran me iter balsamɨn eborimɨn ingarizim, aningɨn dafarir izɨvɨrɨzim inigh ofa gamir dakozimɨn a tuaghtɨ, avim an isi mangɨtɨ a bar mɨghɨrightɨ, averenir kɨnim otogham. Plauan muziarir gumazim Ikiavɨra Itir Godɨn ofa gamizir kam, bar plauan namɨn danganim iniam. Eghtɨ Ikiavɨra Itir God, wit tuer ofan kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Eghtɨ plauan nam, an ofa gamir gumazibar daghem. Plauan kaba, gumaziba da inigha iza Ikiavɨra Itir God bagha ofa gami. Kamaghɨn amizɨ, da bar zuegha Godɨn bizibara, eghtɨ gumazir kɨniba da inian kogham. Ofa gamir gumazibara, da iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Eghtɨ ia bret, bretba tuer danganimɨn aven a tuagh an nam inigh, Ikiavɨra Itir Godɨn ofa damusɨ, ia yis sara veregh an damuan markɨ. Ia plaua inigh olivɨn borem sara a veregh, egh ia bretɨn damigh an ofa damu. Kamaghɨn, ia bretɨn damuan aghuaghɨva, ia bretɨn baravim damigh, egh olivɨn borem a daghuigh. ");
INSERT INTO msy2020_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Egh ia ofa bagh ainɨn baravim gisɨn plaua tusɨ, ia plauan aghuir yis bar puvatɨzim inigh. Egh ia faragh olivɨn borem sara a veregh, egh a tu. ");
INSERT INTO msy2020_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ia plauan kam bar a nguemsɨrigh, borem a gingegh Ikiavɨra Itir God bagh ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Egh ia ofa damuamin bretɨn ingar mɨner ekiamɨn a tuagh, plauan bar aghuir yis puvatɨzim inigh, faragh olivɨn borem sara a veregh a tuagh. ");
INSERT INTO msy2020_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","A isigh gɨvaghtɨ, ia bretɨn kam inigh ofa gamir gumazitam danightɨ, a Ikiavɨra Itir Godɨn ofa damusɨ a inigh ofa gamir dakozimɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Egh gɨn ofa gamir gumazim bretɨn akuar muziaritam inightɨ, bretɨn Ikiavɨra Itir Godɨn ofa gamizir kam, bar bretɨn namɨn danganim inigham. Eghtɨ a ofa gamir dakozimɨn a tuaghtɨ avim a isi mangɨtɨ a bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ Ikiavɨra Itir God, wit tuer ofan kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ezɨ bretɨn akuar naba, da ofa gamir gumazibar dagheba. Bretɨn kaba, gumaziba da inigha iza Ikiavɨra Itir God bagha ofa gami. Kamaghɨn amizɨ, da bar zuegha Godɨn bizibara, eghtɨ gumazir kɨniba da inian kogham. Ofa gamir gumazibara, da iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Ia yis isɨ, bret ko plaua datɨgh a veregh a inigh Ikiavɨra Itir God bagh mangan markɨ. Guizbangɨra, ia yis o hani isɨ ofa datɨgh a tuaghtɨ, a bar mɨghɨrightɨ, ia Ikiavɨra Itir God danɨngan bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","“Ia witɨn akuar faragh azenimɨn mɨseveziba inigh, yis ko hani dar atɨgh Ikiavɨra Itir God bagh mangɨtɨ, deragham. Ezɨ ofan yis o hani itim, ia ofa gamir dakozimɨn a tuan markɨ, eghtɨ an mughuriar aghuim Ikiavɨra Itir Godɨn mangan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Amangsɨzim, an Akar Dɨkɨrɨzir Gavgavir ia God ko amizimɨn ababanim gami, kamaghɨn amizɨ, ia amangsɨzim isɨ wit tuer ofaba bar dar arɨkigh. Egh ia amangsɨzim ofan tam darɨghsɨ okɨnɨghnɨghan markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Ia azenimɨn faragha witɨn ovɨzir mɨsevezir akuaba inigh, egh Ikiavɨra Itir Godɨn ofa damusɨ, ia faragh bretba tuer danganimɨn aven da tusɨ, da nguemsɨrigh, egh da inigh Ikiavɨra Itir God bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Ezɨ wit tuer ofan kam, ia olivɨn borem ko, mɨgharir mughuriar aghuim zuim itir pauran, me iter balsamɨn eborimɨn ingarizim isɨ witɨn nguemsɨrɨzir kam gisɨn aning ingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Eghtɨ ofa gamir gumazim, witɨn kamɨn muziaritam ko, olivɨn borem ko mɨgharir mughuriar aghuim zuim itir pauran me iter balsamɨn eborimɨn ingarizim, bar ada inigh, ofa gamir dakozimɨn avimɨn da tueghtɨ dar mughuriam otivam. Witɨn nguemsɨrɨzir muziarir gumazim Ikiavɨra Itir Godɨn ofa gamizir kam, bar witɨn namɨn danganim iniam. Eghtɨ Ikiavɨra Itir God, wit tuer ofan kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Egha God Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Gumazitam, Ikiavɨra Itir God ko navir vamɨran ikiamin ofa damusɨ, a bulmakaun ofa damusɨ ifongegh, kamaghɨn a bulmakaun apurim o bulmakaun amebar bar aghuir, duatam an mɨkarzim gasɨghasɨghizir puvatɨzir tam inigh, Ikiavɨra Itir Godɨn damazimɨn izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Gumazir kam uan bulmakau inigh God bativamin Purirpenimɨn tiar akamɨn mangɨ, egh uan dafarim isɨ faragh bulmakaun dapanim datɨgh, egh a mɨsueghtɨ an aremegh. Eghtɨ Aronɨn adarazir ofa gamir gumaziba, me bulmakaun kamɨn ghuziba inigh, ofa gamir dakozimɨn 4plan mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Eghtɨ gumazir kam God ko navir vamɨra ikiamin ofa bagh, bulmakaun akuar taba inigh Ikiavɨra Itir God danightɨ, ofa gamir gumaziba ofan mɨn avimɨn da tuegh. Bulmakaun akuar kaba dar kara. An navim ko muriaba avarazir oviba bar ada inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Egh an ogɨagharimɨn itir ovɨzimning, ko aningɨn ovim sara, ko beramɨn akuar aghuim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","“Eghtɨ Aronɨn adarazir ofa gamir gumaziba, bizir kaba ko ofan bar isia mɨghɨriba inigh, ofa gamir dakozimɨn da tueghtɨ, avim bar dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogham. Eghtɨ Ikiavɨra Itir God ofan asɨzir kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Eghtɨ gumazitam Ikiavɨra Itir God ko navir vamɨran ikiamin ofa damusɨ, a uan sipsip ko memebar okoruabar tongɨn asɨzir apurim o asɨzir amebam inigh, kar sipsip o memen bar aghuir duaba an mɨkarzimɨn puvatɨzim. ");
INSERT INTO msy2020_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Egh gumazir kam sipsipɨn tamɨn ofa damusɨ, kamaghɨn ana inigh Ikiavɨra Itir Godɨn damazimɨn izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Egh a uan dafarim isɨ sipsipɨn kamɨn dapanim gisɨn datɨgh, egh a God bativamin Purirpenimɨn tiar akamɨn boroghɨra sipsip mɨsueghtɨ an aremegh. Eghtɨ ofa gamir gumaziba asɨzir kamɨn ghuziba isɨ, ofa gamir dakozimɨn 4plan mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Eghtɨ gumazir kam, God ko navir vamɨra ikiamin ofa bagh, sipsipɨn asɨzir akuar taba inigh Ikiavɨra Itir God danɨngtɨ, ofa gamir gumaziba ofan mɨn da tuam. Sipsipɨn ovir kaba bar, kar an navim ko muriam avarazir oviba, ko an puer mɨngarir akɨragharimɨn boroghɨra itir ovir bar ekiam itiba inigh. Egh an oviba itir puer mɨngarir akɨragharimɨn boroghɨra itim atugh, an ovir kaba bar da inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Egh an ogɨagharimɨn itir ovɨzimning, ko aningɨn ovim sara, ko beramɨn akuar aghuim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Eghtɨ ofa gamir gumazim bizir kaba isɨ, Ikiavɨra Itir God bagh daghemɨn ofan mɨn, ofa gamir dakozim gisɨn avimɨn da tu mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Eghtɨ gumazitam memen ofa damusɨ, an a inigh Ikiavɨra Itir Godɨn damazimɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Egh a uan dafarim isɨ memen dapanim gisɨn datɨgh, egh God bativamin Purirpenimɨn tiar akamɨn boroghɨn a mɨsueghtɨ an aremegh. Eghtɨ Aronɨn adarazir ofa gamir gumaziba an ghuziba isɨ ofa gamir dakozimɨn 4plan mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Eghtɨ gumazir kam memen ovir mɨsaziaba inigh Ikiavɨra Itir God danɨngtɨ, ofa gamir gumaziba ofan mɨn da tuam. An an navim ko muriam avarazir oviba bar da inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Egh an ovɨzir pumuning, ko aningɨn ovim sara inigh, memen beramɨn akuar aghuim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Eghtɨ ofa gamir gumazim bizir kaba isɨ, Ikiavɨra Itir God bagh daghemɨn ofan mɨn, ofa gamir dakozimɨn da tueghtɨ, avim dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ oviba bar, da Ikiavɨra Itir Godɨn bizibara. ");
INSERT INTO msy2020_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ia Israelia, ian tav asɨzir ovim, o ghuzir tabar aman markɨ. Bar markiam. Ia ko ian ovavir borir gɨn otivamiba arazir kamɨn gɨntɨgh mamaghɨra ikɨ. Egh ia mangɨ managh ikɨ, ia arazir kamɨn gɨn mangɨvɨra ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","2","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Gumazitam o amizitam deragha fozir puvatɨgha, arazir kuram gamua Ikiavɨra Itir Godɨn Akar Gavgavir e mɨkemezir tam abighɨva, kamaghɨn, a ofan kabar amu.” ");
INSERT INTO msy2020_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Egha Moses ua kamaghɨn mɨgei, “Ofa gamir gumazibar dapanim arazir kuram damightɨ, an arazir kurar kam gumazamizibar amutɨ, me bar osɨmtɨzim ikiam. Kamaghɨn, a bulmakaun apurir bar aghuir duaba an mɨkarzimɨn puvatɨzir tam inigh. Egh uan arazir kuraba gɨn amangɨsɨ, Ikiavɨra Itir God bagh arazir kuraba gɨn amadir ofa damigh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","A bulmakaun kam inigh God bativamin Purirpenimɨn itiar akamɨn mangɨgh, dafarim an dapanim gisɨn datɨgh, egh Ikiavɨra Itir Godɨn damazimɨn a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Egh ofa gamir gumazibar dapanim bulmakaun ghuzitam inigh, God bativamin Purirpenimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Egh nir ekiar Bar Anogoroghezir Danganim modozimɨn boroghɨn mangɨ, uan dafar puzir tam isɨ ghuzim darugh, egh ghuzir muziarim isɨ, Ikiavɨra Itir Godɨn damazimɨn, inir ekiamɨn a gasɨvamang. A 7plan dughiabar kamaghɨn damu. ");
INSERT INTO msy2020_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Egh a pauran mughuriar aghuim tuamin ofa gamir dakozim iti naghɨn mangɨ, God bativamin Purirpenimɨn aven Ikiavɨra Itir Godɨn damazimɨn tughɨv ikɨ. Egh a ghuzitaba isɨ ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar aghuigh. Egh a bulmakaun ghuzir nar ikiavɨra itir kaba, inigh asɨziba bar isia mɨghɨrir ofa gamir dakozir azenan itimɨn mangɨ, God bativamin Purirpenimɨn tiar akamɨn boroghɨn tughɨv ikɨ. Egh da isɨ ofa gamir dakozir kamɨn mɨngarim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","“Egh arazir kuraba gɨn amadir ofan kam bagh, a bulmakaun kamɨn navim ko muriaba avarazir oviba bar ada inigh, ");
INSERT INTO msy2020_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","egh an ovɨzir pumuning ko, aningɨn ovim sara inigh, egh an beramɨn akuar aghuim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Egh ofa gamir gumazibar dapanim, ovir mɨsaziar kaba bar isia mɨghɨrir ofa gamir dakozimɨn da tueghtɨ da bar isigh mɨghɨrigham, eghtɨ averenir kɨnimra ikiam. An ofan arazir kam mati, me God ko navir vamɨran ikiamin ofa, me bulmakaun oviba inigha ofa gami. ");
INSERT INTO msy2020_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","Egh a bulmakaun apurir kamɨn asɨzir naba inigh, an inim ko tuziba ko dapanim, suemning ko dafarimning, muriam ko buariba, bar ada inigh, nguibar me itimɨn azenan mangɨva, me avimɨn avereniba inger danganimɨn, Godɨn damazimɨn zuezir danganimɨn mangɨ. Egh averenir pozim gisɨn daziba arigh avim daborogh asɨzir nar kaba tueghtɨ da bar isightɨ averenir kɨnim otogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Israelian gumazamiziba deraghvɨra foghan koghɨva, Ikiavɨra Itir Godɨn Akar Gavgavir me mɨkemezir mam abigh, kamaghɨn me arazir kuram gami. Me fozir puvatɨ, me arazir kuram gami, egha guizbangɨra me uan arazir kamɨn me osɨmtɨzim iti. ");
INSERT INTO msy2020_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Me gɨn uan arazir kuram gɨfogh, egh a gɨn amangɨsɨ, me uan asɨzibar tongɨn bulmakaun igiar apurir tam inigh an ofa damu. Me arazir kuraba gɨn amadir ofan kam inigh God bativamin Purirpenimɨn izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Eghtɨ Ikiavɨra Itir Godɨn damazimɨn Israelian gumazir dapaniba uan dafariba isɨ, bulmakaun apurir kamɨn dapanim datɨgh, egh me a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Eghtɨ ofa gamir gumazibar dapanim bulmakaun apurir kamɨn ghuzitaba inigh, God bativamin Purirpenimɨn aven mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Egh nir ekiar Bar Anogoroghezir Danganim modozimɨn boroghɨn mangɨ, uan dafar puzir tam isɨ ghuzim darugh, egh ghuzir muziarim isɨ Ikiavɨra Itir Godɨn damazimɨn, inir ekiam gasɨvamang. A 7plan dughiabar kamaghɨn damu. ");
INSERT INTO msy2020_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Egh a pauran mughuriar aghuim tuamin ofa gamir dakozir Purirpenimɨn aven iti naghɨn mangɨ, egh God bativamin Purirpenimɨn aven Ikiavɨra Itir Godɨn damazimɨn tughɨv ikɨ. Egh a ofa gamir dakozir kamɨn ghuzitaba isɨ, bulmakaun kombar mɨn garir biziba bar dar aghuigh. Egh bulmakaun ghuzir nar ikiavɨra itir kaba, a da inigh asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mangɨ, God bativamin Purirpenimɨn tiar akamɨn boroghɨn tughɨv ikɨ. Egh da isɨ ofa gamir dakozir kamɨn mɨngarim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Egh gɨn a bulmakaun oviba bar da inigh asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn da tueghtɨ da bar isigh mɨghɨrightɨ, averenir kɨnimra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ofa gamir gumazibar dapanim, uabɨ uan arazir kuraba gɨn amadir ofa gami moghɨn, a kamaghɨra bulmakaun kam damigh. Ezɨ kamaghɨra ofa gamir gumazibar dapanim, gumazamizibar arazir kuraba gɨn amangɨsɨ ofa damutɨ, God men arazir kuraba gɨn amangam. ");
INSERT INTO msy2020_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Eghtɨ a gɨn bulmakaun asɨzir naba bar ada inigh, nguibar me itimɨn azenan mangɨgh avimɨn bar ada tuegh, mati a uabɨ uan arazir kuraba gɨn amangasa bulmakaun ofa gami. Bulmakaun kam, gumazamiziba bar men arazir kuraba gɨn amadir ofa.” ");
INSERT INTO msy2020_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Gumazir dapanitam deraghvɨra foghan koghɨva, Ikiavɨra Itir Godɨn Akar Gavgavir e mɨkemezir tam abigh, kamaghɨn an arazir kuram gami. A fozir puvatɨ, an arazir kuram gami, egha guizbangɨra a uan arazir kamɨn an osɨmtɨzim iti. ");
INSERT INTO msy2020_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","A gɨn uan arazir kurar kam gɨfogh, egh a gɨn amangɨsɨ, memen apurir aghuitam inigh, duatam an mɨkarzimɨn ikian markɨ, egh ana inigh ofa bagh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Egh Ikiavɨra Itir Godɨn damazimɨn a dafarim isɨ memen dapanim gisɨn datɨgh, egh danganir me ofan bar isia mɨghɨribar asɨzibav sozimra tugh, memen kam mɨsueghtɨ an aremegh. Memen kam, an arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Eghtɨ ofa gamir gumazim, arazir kuraba gɨn amadir ofan kam bagh, uan dafarir puzir tam isɨ memen ghuzim darugh, egh ghuzir muziaritam isɨ asɨziba da bar isia mɨghɨrir ofa gamir dakozimɨn, ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar aghuigh. Egh ghuzir naba isɨ asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mɨngarim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Egh a memen oviba ofa gamir dakozimɨn, da tueghtɨ da bar isigh mɨghɨrightɨ, averenir kɨnim otogh. Ofa gamir gumazim arazir kamra damu, mati me God ko navir vamɨran ikiamin ofabar mɨn me meme mɨsogha an oviba isa ofa gami. Ezɨ kamaghɨra, ofa gamir gumazim, gumazir dapanir kamɨn arazir kuraba gɨn amangɨsɨ ofa damu, eghtɨ God an arazir kuraba gɨn amangam.” ");
INSERT INTO msy2020_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Ikiavɨra Itir God, Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Gumazir kɨnitam o amizir kɨnitam deraghvɨra foghan koghɨva, egh Ikiavɨra Itir Godɨn Akar Gavgavir e mɨkemezir tam abigh, kamaghɨn an arazir kuram gamizɨ, arazir kurar kamɨn osɨmtɨzim an iti. ");
INSERT INTO msy2020_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Egh a gɨn bizir kam gɨfogh, egh uan arazir kuram gɨn amangɨsɨ ofa damuam. A memen amebar aghuir duaba an mɨkarzimɨn puvatɨzimra inigh, egh uan arazir kurar an amizim bagh ofa damusɨ a inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Egh a uan dafarim isɨ memen dapanim gisɨn datɨgh, danganir me ofan bar isia mɨghɨribar asɨzibav sozi naghɨra tugh, a mɨsueghtɨ an aremegh. Memen kam, an arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Eghtɨ ofa gamir gumazim uan dafarir puzir tam isɨ memen ghuzim darugh, egh ghuzir muziarir taba isɨ asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mangɨ, ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar aghuigh. Egh a ghuzir nar ikiavɨra itim inigh, asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mɨngarim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Egh a memen oviba bar da inigh, ofa gamir dakozimɨn da tuegh. Ofa gamir gumazim arazir kamra damu, mati me God ko navir vamɨran ikiamin ofabar mɨn me meme mɨsogha an oviba isa ofa gami. Egh oviba ofa gamir dakozimɨn da tu mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ Ikiavɨra Itir God, ofan kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. Kamaghɨra, ofa gamir gumazim, gumazir kɨnir kamɨn arazir kuraba gɨn amangɨsɨ ofa damutɨ, God an arazir kuraba gɨn amangam. ");
INSERT INTO msy2020_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Eghtɨ gumazitam uan arazir kuraba gɨn amangɨsɨ sipsipɨn ofa damusɨ, a sipsipɨn amebar aghuir duaba an mɨkarzimɨn puvatɨzimra inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Egh a uan dafarim isɨ sipsipɨn dapanim gisɨn datɨgh, danganir me ofan bar isia mɨghɨribar asɨzibav sozi naghɨn tugh, a mɨsueghtɨ an aremegh. Sipsipɨn kam, an arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Eghtɨ ofa gamir gumazim, asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mangɨ, uan dafarir puzir tam isɨ sipsipɨn ghuzim darugh, egh ghuzir muziarir taba isɨ ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar aghuigh. Egh a ghuzir nar ikiavɨra itim inigh, egh asɨziba bar isia mɨghɨrir ofa gamir dakozimɨn mɨngarim gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Egh a sipsipɨn oviba bar da inigh ofa gamir dakozimɨn da tuegh. Ofa gamir gumazim arazir kamra, mati arazir me God ko navir vamɨran ikiamin ofabagh amibar mɨn, a sipsipɨn kamɨn oviba inigh ofa damu. An an oviba tueghtɨ da bar isigh mɨghɨrightɨ, averenir kɨnim otogham. Kamaghɨra, ofa gamir gumazim, gumazir kɨnir kamɨn arazir kuraba gɨn amangɨsɨ ofa damu, eghtɨ God an arazir kuraba gɨn amangam.” ");
INSERT INTO msy2020_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Gumazitam gumazir igharazimɨn garima, a bizim gami, o a gumazir igharazim barazima, a bizim mɨkeme, ezɨ gɨn jas, kotɨn aven bizir kamɨn gun mɨkɨmasa an diagha an azangsɨsi. Ezɨ gumazir kam kotɨn aven bizir a fozir kamɨn gun mɨkemezir puvatɨ. Kamaghɨn an arazir kuram Godɨn damazimɨn a gamigha osɨmtɨzim iti. ");
INSERT INTO msy2020_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Eghtɨ gumazitam deragh nɨghnighan kogh, God mɨkemezir bizir mɨzezir tamɨn porogham, gumazir kam a Godɨn damazimɨn mɨze. A mati asɨzir atiar aremezir kuam, o nguibamɨn asɨzir kuar Godɨn damazimɨn mɨzezim, o asɨzir davaragha aruir Godɨn damazimɨn mɨzezim. Asɨzir kam ti aremezɨ, an kuam pura nguazim girɨghav iti. Ezɨ gumazir kam deragha ganizir puvatɨgha iza, asɨzimɨn porogha Godɨn damazimɨn mɨze. Egh gɨn a uan arazir kurar an amizibagh foghtɨ, arazir kurabar osɨmtɨzim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Eghtɨ gumazitam deragh nɨghnighan kogh, egh Godɨn damazimɨn bizir mɨzezir gumazim o amizimɨn mɨkarzimɨn itimɨn porogh, gumazir kam Godɨn damazimɨn mɨzegham. Egh gɨn a uan arazir kurar an amizibagh fogham, eghtɨ arazir kurabar osɨmtɨzim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Eghtɨ gumazitam deragh nɨghnighan kogh, bizitam damusɨ guizbangɨra pura pɨn akakagh mɨkɨmam, a kamaghɨn Godɨn damazimɨn arazir kuram gami. Egh gɨn a uan arazir kurar an amizim gɨfoghtɨ, an arazir kuramɨn osɨmtɨzim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Gumazitam arazir kurar kamaghɨn garitam gami, an osɨmtɨzim inigha gɨfa, egh a uan osɨmtɨzimɨn gun mɨkemegh. ");
INSERT INTO msy2020_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Egh a uan arazir kuramɨn osɨmtɨzim agɨvsɨ sipsipɨn amebatam o memen amebatam isɨ ofan mɨn Ikiavɨra Itir God bagh a inigh izɨ. Eghtɨ ofa gamir gumazim, gumazir kamɨn arazir kuram gɨn amangɨsɨ, asɨzir kamɨn ofa damutɨ, God an arazir kuram gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Arazir kuramɨn osɨmtɨzim itir gumazim, onganarazim damu sipsip ko meme givezamin dagɨaba otevegh, a kuarazir bunbar pumuning inigh uan osɨmtɨzim agɨvsɨ Ikiavɨra Itir God bagh izɨ. Eghtɨ bunbar tam, arazir kuraba gɨn amadir ofan otogham, eghtɨ bunbar igharazim, ofan bar isia mɨghɨrimɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Gumazir kam aning inigh ofa gamir gumazim bagh mangɨtɨ, a kuarazir bunbar tam inigh arazir kuraba gɨn amadir ofa damu. Ofa gamir gumazim bunbamɨn fɨrim ruivightɨ an aremeghtɨ, an an dapanim asian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Egh a ghuzir muziarim inigh ofa gamir dakozimɨn mɨriamɨn a kavamang, bunbamɨn fɨrim ruivightɨ an ghuzir naba bar ofa gamir dakozimɨn mɨngarim giram. Kuarazir bunbar kam, an arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Egh gɨn a bunbar igharazimɨn, bar isia mɨghɨrir ofa damu. A ofan kamɨn arazimɨn gɨn mangɨ. Egh kamaghɨra ofa gamir gumazim, gumazir kamɨn arazir kuraba gɨn amangɨsɨ a bagh ofa damu, eghtɨ God an arazir kuraba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Gumazir osɨmtɨzim itim, bar dagɨabagh asaghɨva kuarazimning givezan iburagh, a 1 kilogrem plauan aghuitam inigh izɨ. Egh, a witɨn ovɨzim tuer ofan mɨn amizɨ moghɨn, an olivɨn borem ko, mɨgharir mughuriar aghuim zuim itir pauran me iter balsamɨn eborimɨn ingarizim isɨ a gingan markɨ. Puvatɨ, plauan kam, kar arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Egh a ofa inigh ofa gamir gumazim bagh mangɨ, eghtɨ ofa gamir gumazim, uan dafarim isɨ plauan kam darugh, plauan dafarir izɨvɨrɨzim inigh ofan igharaziba sara ofa gamir dakozimɨn a tuaghtɨ, avim an isi mangɨtɨ a bar mɨghɨrightɨ, averenir kɨnim otogham. Plauan muziarir kam, gumazir Ikiavɨra Itir Godɨn ofa gamizir kam, plauan nam bar an danganim ini. Kar arazir kuraba gɨn amadir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Tuavir kamra ofa gamir gumazim, gumazir kamɨn arazir kuram bagh ofa damightɨ, God an arazir kuraba gɨn amadagham. Eghtɨ ikiavɨra itir plauan naba, ofa gamir gumaziba da inigh dar amam, mati witɨn ovɨzir nar me ofa bagha tueba.” ");
INSERT INTO msy2020_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, ");
INSERT INTO msy2020_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Gumazitam o amizitam deragha fozir puvatɨgha, Ikiavɨra Itir God danɨngamin biziba bakɨnɨghnigh, egha an arazir kuram gami. Egh gumazir kam Ikiavɨra Itir Godɨn ofa damu, bizir kam ikarvagh uan osɨmtɨzim agɨvagham. Ofa gamir gumazim a mɨkemeghtɨ, a uan asɨzibar okoruabar tongɨn sipsipɨn apurir bar aghuir duaba an mɨkarzimɨn puvatɨzitam inigh izɨ. Ofa gamir gumazim, sipsipɨn gumazim inigha izezir kamɨn ivezimɨn dɨbobonim atɨgham. Kar osɨmtɨzim agevir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Eghtɨ dagɨar a isa Ikiavɨra Itir God ganɨngizir puvatɨzir kaba, a datɨrɨghɨn a danɨng, egh ua dagɨataba isɨ dagh isɨn datɨgh. A pura 5plan biziba ini, kamaghɨn a 6plan biziba, bizir kaba ikaragham. Egh da isɨ ofa gamir gumazim danɨngigh. Eghtɨ ofa gamir gumazim, sipsipɨn kam inigh, gumazir kamɨn osɨmtɨzim agɨvamin ofa damu, eghtɨ God an arazir kuraba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Gumazitam o amizitam deragh nɨghnighan kogh, Ikiavɨra Itir Godɨn Akar Gavgavitam abigham, kamaghɨn an arazir kuram gamigha Godɨn damazimɨn osɨmtɨzim iti, egh ivezir kuram iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Kamaghɨn amizɨ, a uan asɨzibar okoruabar tongɨn sipsipɨn apurir bar aghuir duaba an mɨkarzimɨn puvatɨzitam inigh, ofan mɨn ofa gamir gumazim bagh mangɨ, egh uan arazir kurabar osɨmtɨziba akɨr da agɨfagh. Eghtɨ ofa gamir gumazim sipsipɨn gumazim inigha izezir kamɨn ivezim dɨborogh a datɨgh. Eghtɨ gumazim sipsipɨn kamagh garitam, ofa gamir gumazim bagh a inigh izɨtɨ, a gumazir kamɨn osɨmtɨzim agevir ofa damightɨ, God an arazir kuraba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Sipsipɨn kam, Ikiavɨra Itir Godɨn damazimɨn, an osɨmtɨzim agevir ofa.” ");
INSERT INTO msy2020_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, ");
INSERT INTO msy2020_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Gumazitam o amizitam uan namakamɨn bizim puram a inigha, uam a ikarvaghasa akar dɨkɨrɨzim gamigha, gɨn bizir kam uam a danɨngan aghua, kamaghɨn a deraghavɨra Ikiavɨra Itir Godɨn gɨn zuir puvatɨ, egha an arazir kuram gami. A namakamɨn bizim okeme, o namakam gifaragha an bizibagh etui, ");
INSERT INTO msy2020_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","o a bizitamɨn garima, gumazir igharazim an ovenge, ezɨ a ifara ghaze, bar guizbangɨra, kɨ an ganizir puvatɨ, kamaghɨn, an arazir kuram gami. ");
INSERT INTO msy2020_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","Gumazir arazir kabagh amim, a Godɨn damazimɨn osɨmtɨzim inigha gɨfa. Egh gɨn a uan osɨmtɨzim gɨfogh, egh an oker arazim ko ifavarir arazimɨn inizir bizir kaba, a ua da ikaragh. A uan osɨmtɨziba agɨvsɨ ofa damuamin dughiamɨn, a bizir kaba ikarvagh da isɨ dar ghuavim danɨngigh. A faragha 5plan biziba ini, egh a 6plan biziba uam a da ikaragh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","A sipsipɨn apuritam inigh ofa gamir gumazim bagh mangɨ, uan arazir kurabar osɨmtɨzim agevir ofan mɨn Ikiavɨra Itir Godɨn ofa damu. Ofa gamir gumazim a mɨkemeghtɨ, a uan asɨzibar tongɨn sipsipɨn apurir bar aghuir duaba an mɨkarzimɨn puvatɨzitam, inigh izɨ. Ofa gamir gumazim sipsipɨn gumazim inigha izezir kamɨn ivezimɨn dɨbobonim atɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Egh ofa gamir gumazim, a gumazir arazir kuram gamizibagh amizimɨn osɨmtɨziba agɨvsɨ Ikiavɨra Itir Godɨn damazimɨn ofa damutɨ, God an arazir kuraba gɨn amadagham.” ");
INSERT INTO msy2020_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Ikiavɨra Itir God kamaghɨn Moses mɨkeme: ");
INSERT INTO msy2020_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Nɨ ofan bar isia mɨghɨribar arazibar gun Aron ko an otaribav mɨkemegh. Me ofan kam ofa gamir dakozimɨn a tuagh, egh aneteghtɨ, avim an isi dɨmangan ikɨ mangɨtɨ amɨnim tiragh. Dɨmangan avim isi mamaghɨra ikɨ, egh mungeghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Eghtɨ gɨn, ofa gamir gumazim, korotiar ruarir me inir aghuimɨn ingarizim arugh, egh gɨn trausiziar otevir me nir aghuimɨn ingarizim isɨ aven anerugh, egh gɨn an ofa gamir dakozimɨn mangɨ, ofan bar isi mɨghɨramimɨn averenim inigh, averenir kam ofan ovim an iti. Egh ofa gamir dakozimɨn boroghɨn nguazimɨn a ingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Egh a gɨn uan korotiam suegh korotiar igharazibar aghuigh, averenir kam inigh men dɨpeniba itir danganimɨn azenan mangɨ, nan damazimɨn danganir zuezimɨn anetɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Eghtɨ ofa gamir dakozimɨn avim isi mamaghɨra ikɨ, egh mungan markɨ. Egh mɨzarazibar zurara, ofa gamir gumazim dazibar avim darɨgh mamaghɨra ikɨ. Egh an asɨzir bar isia mɨghɨriba inigh, da isɨ avimɨn deragh dar arigh da tueghtɨ, da bar isigh mɨghɨrightɨ averenir kɨnim otogham. Egh a God ko navir vamɨran ikiamin ofan oviba inigh, avir kamɨn da tueghtɨ da bar isigh mɨghɨrightɨ averenir kɨnim otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Avim zurara ofa gamir dakozimɨn isi mamaghɨra ikɨ. Ia avim ateghtɨ a mungeghan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Wit tuamin ofabar arazim kamakɨn. Aronɨn adarazir ofa gamir gumazitam ofan wit tuamin kam isɨ nan damazimɨn ofa gamir dakozimɨn boroghɨn mangɨ, nan akagh na danɨngam. Kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Egh ofan kam bagh, ofa gamir gumazim uan dafarim isɨ plauan kam darugh, egh dafarir zɨvɨrizimɨn an plaua inigh, an itir borer muziaritam, ko mɨgharir mughuriar aghuim zuir pauran me iter balsamɨn eborimɨn ingarizim bar a inigh. Egh a bizir kaba bar, da isɨ ofa gamir dakozimɨn da tueghtɨ, avim dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogham. Plauan muziarir gumazim Ikiavɨra Itir Godɨn ofa gamizir kam, bar plauan namɨn danganim inigham. Eghtɨ Ikiavɨra Itir God, witɨn ofa tuamin kamɨn mughuriam bareghɨva, a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Eghtɨ ofa gamir gumaziba plauan nar ikiavɨra itibar amɨ. Me plaua inigh yis puvatɨzir bretɨn ingarigh, egh God bativamin Purirpenim avɨnizir dɨvazimɨn aven anemɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Kar ofan dagher nar me iniamba. Plauan kam, kɨ ofa gamir gumaziba bagha anemɨsefe. Plauan kam, a bar nan bizimra, mati arazir kuraba gɨn amadir ofaba ko gumazamizibar osɨmtɨziba agevir ofaba, da nan biziba. Kamaghɨn amizɨ, me yis sara bretɨn kam veregh a tuan markɨ. Me puram a tuam. ");
INSERT INTO msy2020_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aronɨn ovavir boribar tongɨn gumazibara, me vaghvagh bretɨn kam amam. Israelia Ikiavɨra Itir God bagh ofan bar isia mɨghɨrir dagher kaba, merara, da iniam. Egh gɨn izamin dughiabar zurara, Aronɨn ovavir boriba, ofan nar kaba ini mamaghɨra ikiam. Eghtɨ gumazitam, o bizitam ofan nar kabar poroghɨva, a nan bizimram otogh egh bar anogoregham.” ");
INSERT INTO msy2020_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Aronɨn adarazir ofa gamir gumaziba, me igiamra ofa gamir ingangarim isir dughiamɨn ofan tam damigh. Egh me ofa gamir dughiamɨn gumazitam amɨseveghtɨ, a na bagh ofabar amu. A plauan tam inightɨ, an osɨmtɨzim 1 kilogremɨn tugh, a mati me dughiabar zurara wit tuer ofan ababanimra inigh. A plauan kamɨn akuatam isɨ mɨzarazimɨn ofa damigh, egh aruem magɨrɨtɨ, an akuar namɨn ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","An olivɨn borem sara bar deragh plauan kam ko a veregh, egh ofa bagh amir ainɨn baravim gisɨn plaua tuagh. Egh gɨn anebɨghɨrarigh na danɨng, kɨ Ikiavɨra Itir God. Eghtɨ kɨ ofan kamɨn mughuriam baregh, a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Eghtɨ gɨn izamin dughiamɨn, me Aronɨn ovavir boribar gumazibar tongɨn, ofa gamir gumazim amɨseveghtɨ, an Aronɨn danganim inigh ofa gamir gumazibar dapanimɨn otogh, egh a Ikiavɨra Itir God bagh ofan kamaghɨra garim damuam. Ofan kam, a nan bizimra, kamaghɨn, a ofa ateghtɨ a bar isi mɨghɨrightɨ, averenir kɨnim otogh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Ofa gamir gumaziba witɨn ofan kamɨn muziarir tabar aman markɨ. Puvatɨ. Me aneteghtɨ a bar isɨ mɨghɨrigh.” ");
INSERT INTO msy2020_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Nɨ ofan arazir kuraba gɨn amadir arazibar gun Aron ko an otaribav kemegh. Arazir kam a kamakɨn. Me arazir kuraba gɨn amangɨsɨ, nan damazimɨn asɨzim mɨsuegh ofa damu. Me ofan bar isia mɨghɨribar, asɨziba mɨsozir danganimɨn asɨzim mɨsueghtɨ an aremegh. Ka bar nan ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ofa gamir gumazim, asɨzir kam isɨ arazir kuraba gɨn amadir ofa damu, egh a uabɨ God bativamin Purirpenim avɨnizir dɨvazimɨn aven asɨzir tuzir kam amam, kar danganir na baghavɨra itim. ");
INSERT INTO msy2020_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Eghtɨ gumazitam, ofan kamɨn asɨzir tuzimɨn porogh, egh a nan bizimram otoghɨva, bar anogoregham. Eghtɨ asɨzimɨn ghuzim inim o bizitam gireghtɨ, ia nan Purirpenim avɨnizir dɨvazimɨn aven a ruegh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ofa gamir gumazim, ofan kam nguazir mɨnemɨn anevigh, a gɨn mɨner kam abɨkigh. A brasɨn mɨnemɨn anevighɨva, dɨpamɨn deragh a ruva a isegh. ");
INSERT INTO msy2020_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ofan kamaghɨn garim, a nan bizimra. Kamaghɨn amizɨ, ofa gamir gumazibar adarazir gumazitam ifongegh, a ofan kamɨn asɨzir tuzim amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Eghtɨ ofa gamir gumazibar dapanim, ofan kamɨn ghuzitaba inigh, na bativamin Purirpenimɨn aven mangɨgh, arazir kuraba gɨn amangamin ingangarim damutɨ ofa gamir gumaziba ofan asɨzir tuzir kam aman markɨ. Me asɨzir tuziba avimɨn bar da tu mangɨtɨ da mɨghɨrightɨ, averenir kɨnim otogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ezɨ Ikiavɨra Itir God, Israelia mɨkɨmasa kamaghɨn Moses mɨkeme: “Osɨmtɨziba agevir ofan kaba, da bar Godɨn bizibara. Ofan kabar Araziba kamakɨn. ");
INSERT INTO msy2020_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Me ofan bar isia mɨghɨriba bagha asɨzibav sozir danganimɨn, me osɨmtɨzim agevir ofa bagh sipsip mɨsueghtɨ, an aremegh. Eghtɨ me sipsipɨn kamɨn ghuziba isɨ ofa gamir dakozimɨn 4plan mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Gumazir ofan kam damuamim, a sipsipɨn oviba, ko an puer mɨngarimɨn boroghɨra itir ovir bar ekiam itiba, ko a navim ko muriam avarazir oviba inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Egh an ovɨzimning ko oviba sara inigh, egh uaghan sipsipɨn beramɨn akuar aghuim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Egh ofa gamir gumazim, ofa gamir dakozimɨn da tueghtɨ, avim dar isi mangɨtɨ da bar mɨghɨrightɨ, averenir kɨnim otogham, mati me ofa isa Ikiavɨra Itir God ganɨdi moghɨn damu. Kar ofan osɨmtɨzim agevir ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ofa gamir gumazibar adarazir gumazitam, asɨzir tuzir kam amɨsɨ ifuegh anemɨ. Kar Godɨn ofa, an ofa gamir gumaziba bagha a ginaba. Kamaghɨn amizɨ, me Godɨn Purirpenim avɨnizir dɨvazimɨn aven anemɨ, kar Godɨn danganimra. ");
INSERT INTO msy2020_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Arazir kuraba gɨn amadir ofa, ko osɨmtɨzim agevir ofa, aning ofan arazir vamɨra iti. Kamaghɨn amizɨ, ofa gamir gumazim, ofan kamagh garir kamning damuva, a uabɨ, ua bagh ofan kamɨn asɨzir tuzim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ofa gamir gumazim bar isia mɨghɨrir ofa damuva, a ua bagh asɨzimɨn inim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Egha kamaghɨra, ofa gamir gumazim, witɨn ofan me bretba tuer danganimɨn tueziba, ko witɨn ofan me nguazir mɨnemɨn tueziba, ko witɨn ofan me ainɨn baravimɨn tueziba bar, a ua bagh da inigh dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Witɨn ofan igharazir me tuezir puvatɨziba, maba me olivɨn boremɨn sara da vere, maba me plauan ofan kɨnibagh ami, da bar Aronɨn adarazir ofa gamir gumazibar biziba. Me da tuiragh dɨbobonir vamɨran gɨn mangɨ vaghvagh Aronɨn adarazir ofa gamir gumazibar anɨng.” ");
INSERT INTO msy2020_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Egha Ikiavɨra Itir God, Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Ikiavɨra Itir God ko navir vamɨran ikiamin ofan arazim kamakɨn. ");
INSERT INTO msy2020_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Gumazitam God mɨnabɨ a ko navir vamɨra ikiamin ofan kam damusɨ ifongegh, an asɨzir ofan God mɨnabim inigh, egh uaghan yis puvatɨzir bretɨn taba sara ofa damu. Bretɨn kabar kara: plauan me olivɨn borem sara veregha ingarizir bretba, ko me olivɨn boremɨn aghuizir bisketba, ko olivɨn borer ekiam avarazir bretba, da inigh ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Egh a uaghan bretɨn rubuzir yis itir taba inigh, egh God ko navir vamɨran ikiamin ofan kam sara damuva a mɨnabɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","A bretɨn kaba vaghvagh dar akuatam inigh, Ikiavɨra Itir God danɨngigh. Bretɨn kaba, ofa gamir gumazimɨn dagheba. Ofa gamir gumazir kam, a God ko navir vamɨran ikiamin ofan asɨzimɨn ghuziba inigh, ofa gamir dakozimɨn mɨriabar da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Eghtɨ gumazir God mɨnabɨva a ko navir vamɨran ikiamin ofa gamim, ofa gamir dughiar kamra, an asɨzir tuzir naba bar dar amegh. An asɨzir tuziba ateghtɨ, da ikɨ mangɨ dughiar igharazimɨn otivan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Eghtɨ gumazitam, uan akar dɨkɨrɨzir God koma amizim akɨramin ofa damusɨ, o a uan ifongiamɨn gɨn mangɨ ofa damu, o God ko navir vamɨran ikiamin ofa damu, egh gumazir kam ofa gamir dughiamɨn, an asɨzir kamɨn tuzir tabar amɨ, egh amɨmzaraghan uaghan tuzir nabar ameghtɨ, kamaghɨn deragham. ");
INSERT INTO msy2020_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Egh me dughiar namba 2ɨn, da gɨvaghan koghtɨ, asɨzir tuzir naba ikɨvɨra ikɨtɨ, me dughiar namba 3ɨn avimɨn bar da tueghtɨ, da bar moghɨra isi mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Me dughiar namba 3ɨn asɨzir tuzir katam ameghtɨ, God gumazir kamɨn ofan kam inighan kogham. Ofan kam, a Godɨn damazimɨn deraghan kogh, egh pura mangɨgh gumazir kamɨn akurvaghan kogham. Eghtɨ God suam, nɨn ofan kam bar mɨzegha kurizɨ kɨ bar an aghua. Eghtɨ gumazir manam asɨzir tuzir kam amɨva, an osɨmtɨzim ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Eghtɨ God ko navir vamɨran ikiamin ofan asɨzir tuzim, bizir mɨzɨrɨzitamɨn porogham, a Godɨn damazimɨn zueghan kogham. Eghtɨ me asɨzir tuzir kam aman markɨ. Me asɨzir tuzir kam avimɨn a tuaghtɨ a bar isi mɨghɨrigh. “Gumazamizir Godɨn damazimɨn zueziba, merara God ko navir vamɨran ikiamin ofan asɨzir tuzim amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Eghtɨ ian tav Godɨn damazimɨn zueghan kogh, egh Ikiavɨra Itir God ko navir vamɨran ikiamin ofan asɨzir tuzim ameghtɨ, me a batueghtɨ, a Ikiavɨra Itir Godɨn gumazamizibar ikɨzimɨn aven ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Eghtɨ ian tav uaghan, bizir Godɨn damazimɨn mɨzezir tamɨn suiragham, ka ti asɨzir zuezir puvatɨzitam, o bizir mɨzegha gumazamizibar mɨkarzibar itiba, o asɨzir mɨzɨrɨzir kɨ aghuaziba, dar suiragh, egh gumazir kam gɨn ofan asɨzir tuzir kam ameghtɨ, me a batueghtɨ a Ikiavɨra Itir Godɨn gumazamizibar ikɨzimɨn ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","23","Ikiavɨra Itir God, Israelia mɨkɨmasa kamaghɨn Moses mɨkeme, “Ia bulmakaun oviba ko sipsipɨn oviba, ko memen oviba, dar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ia bulmakaun uabɨ aremezim o asɨzir atiam mɨsoghezɨ aremezim, ia an ovim aman markɨ. Egh ia ingangarir igharazitam damusɨ an ovim inightɨ deragham. ");
INSERT INTO msy2020_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Eghtɨ gumazitam, me Ikiavɨra Itir Godɨn ofa gamizir asɨzimɨn ovitam ameghtɨ, me a batueghtɨ, a ua Ikiavɨra Itir Godɨn gumazamizibar ikɨzimɨn aven ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ia Israelia, ia managh iti, ia ghuziba sara asɨziba ko, ghuziba sara kuarazibar aman markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Gumazitam o amizitam, Akar Gavgavir ghuzibar aman koghamin kam abightɨ, me a batueghtɨ, a ua Ikiavɨra Itir Godɨn gumazamizibar ikɨzimɨn aven ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","29","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Ian tongɨn itir gumazitam, God ko navir vamɨran ikiamin ofa damusɨ asɨzim inigh izɨ, an asɨzir otevitam Ikiavɨra Itir God baghvɨra anemɨsefegh. ");
INSERT INTO msy2020_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Gumazir kam uabɨ asɨzir otevir kam inigh izɨ, avimɨn Ikiavɨra Itir Godɨn ofa damu. Ikiavɨra Itir Godɨn asɨzir otevir kaba kamakɨn, asɨzir ovim ko an amagapamɨn itir tuzim. Eghtɨ ofa gamir gumazim kamaghɨn Ikiavɨra Itir Godɨn ofa damu. A uan dafarimningɨn amagapamɨn itir asɨzir tuzimɨn suiragh a fegh a damutɨ a Godɨn damazimɨn ighuavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Ofa gamir gumazim ofa gamir dakozimɨn ovim tuaghtɨ, avim an isi mangɨtɨ a bar mɨghɨrigh, averenir kɨnim otogham. Eghtɨ Aronɨn adarazir ofa gamir gumaziba uari damɨsɨ, an amagapamɨn itir tuzim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Eghtɨ asɨzir kamɨn agharir guvimɨn amadaghan itir buaragharim, gumazim a isɨ ofa gamir gumazim danɨngigh. Asɨzir kam, a God ko navir vamɨran ikiamin ofa. ");
INSERT INTO msy2020_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Kamaghɨn Aronɨn adarazir tongɨn ofa gamir gumazim, a ghuzim ko ovimɨn ofa gami, ezɨ asɨzir buaragharim, kar an bizim. ");
INSERT INTO msy2020_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ikiavɨra Itir Godɨn damazimɨn fegha ighuavamadir amagapar tuzim, ko asɨzir kamɨn agharir guvimɨn amadaghan itir buaragharim, Ikiavɨra Itir God, Israelian gumazamizibar ofabar tongɨn aning inigha, ofa gamir gumazibagh anɨngi, kar Aron ko an ovavir boriba. Egh gɨn otivamin dughiabar zurara, ofa gamir gumaziba ofan otevir kaba iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Gumazamiziba Ikiavɨra Itir God bagh avimɨn ofan amibar tongɨn, Ikiavɨra Itir God, asɨzir tuzir otevir kamning, ginabagha ghaze, Aron ko an ovavir boriba, dughiar a me gamizɨ, me an ofa gamir gumazibar otozimɨn ikegh, zurara mangɨ, me asɨzir tuzir otevir kamning iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Dughiar kamra, Ikiavɨra Itir God Israelia mɨgɨa ghaze, me ofan asɨzir tuzir otevir kamning isɨ ofa gamir gumazibar anɨng. Egh me arazir kam zurara an gɨn mangɨvɨra ikɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Akar Gavgavir kaba bar, kar ofan bar isia mɨghɨriba ko, wit tuer ofaba ko, arazir kuraba gɨn amadir ofaba ko, osɨmtɨziba agevir ofaba ko, gumaziba mɨsevima me ofa gamir gumazibar otivir ofaba ko, God ko navir vamɨran ikiamin ofaba. ");
INSERT INTO msy2020_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Israelia gumazamiziba puvatɨzir danganimɨn itir dughiamɨn, Ikiavɨra Itir God, Akar Gavgavir kaba Sainain Mɨghsɨamɨn da isa Moses ganɨngi. Dughiar kamɨn, Ikiavɨra Itir God, Akar Gavgaviba Israelia ganɨga ghaze, me uan ofaba inigh a bagh izam. ");
INSERT INTO msy2020_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","“Nɨ Aron ko an otariba sara inigh na bativamin Purirpenimɨn tiar akamɨn mangɨ. Egh ofa gamir gumazimɨn korotiaba ko ingangarir kam bagh me amɨsɨvamin olivɨn borem inigh. Egh arazir kuraba gɨn amangɨsɨ bulmakaun apurir tam ko sipsipɨn apurimning ko yis puvatɨzir bretɨn akɨrar izɨvazir tam, bizir kaba sara inigh God bativamin Purirpenimɨn mangɨ. Egh gumazamiziba bar men diaghtɨ, me Purirpenimɨn tiar akamɨn izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Ezɨ Moses Ikiavɨra Itir Godɨn Akar Gavgavim baregha an gɨn zui. Ezɨ gumazamiziba bar iza God bativamin Purirpenimɨn tiar akamɨn uari akufa. ");
INSERT INTO msy2020_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ezɨ a kamaghɨn me mɨgɨa ghaze, “Bizir kɨ datɨrɨghɨn damuamin kam, Ikiavɨra Itir God a damuasa na mɨkeme.” ");
INSERT INTO msy2020_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Egha Moses Aron ko an otariba inigha iza gumazamizibar damazimɨn tugha, me gamizɨ me dɨpamɨn uari rue. ");
INSERT INTO msy2020_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","A faraghavɨra ofa gamir gumazimɨn korotiar ruarir aven azuim isa Aron garugha, inir ruarir ivariam gitim isa an ivariam gike. Egha Moses korotiar ruarir azenan itim a garu. Egha a korotiar otevir azenan azuim a garugha anemɨghɨnasa inir sazir kurkazir aghuiba itim isa an ivariam gike. ");
INSERT INTO msy2020_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Egha forivtarir inim isa Aronɨn evarim gike, egha Godɨn ifongiam gɨfofoghamin dagɨamning isa forivtarir inir an evarimɨn itim garu. ");
INSERT INTO msy2020_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Egha inir dapanir asuar ruarim Aronɨn dapanim gighui. Egha gol medel isa an inir dapanir asuar ruarim gitoro. Medalɨn kam, kamaghɨn men aka, kar Ikiavɨra Itir Godɨn gumazimra. Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, Moses arazir kaba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Egha Moses, olivɨn borer God baghvɨra ikiamin bizibagh inger kam, inigha ghua, Ikiavɨra Itir Godɨn Purirpenim ginga, bizir an aven itiba sara bar dagh inge. Egha arazir kamɨn a bizir kaba amɨsevezɨ, da bar Ikiavɨra Itir Godɨn bizibara. ");
INSERT INTO msy2020_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Egha a olivɨn borer nam inigha ghua, 7plan dughiabar ofa gamir dakozim ko ofa gamir dakozimɨn biziba, ko soroghafariba ruer itarir ekiam ko anefamin dakozim, a bar boremɨn da kavamangi. Egha arazir kamɨn Moses bizir kaba amɨsevezɨ, da Ikiavɨra Itir Godɨn bizibar otifi. ");
INSERT INTO msy2020_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Egha Moses borer muziarim isa Aronɨn dapanim ginge, ezɨ arazir kamɨn an Aron amɨsevezɨ, a Ikiavɨra Itir Godɨn ofa gamir gumazimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Egha Moses, Aronɨn otariba inigha iza ofa gamir gumazibar korotiar ruarir aven azuiba isa me gaghua, inir ruarir ivariam gitim isa men ivariabagh ikegha, men dapanir asuabar inir ruariba isa men dapanibagh ighuigha da ifefe. Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, Moses arazir kaba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ezɨ bizir kam gɨvazɨ, Moses arazir kuraba gɨn amadir ofa damuamin bulmakaun apurimɨn akua izezɨ, Aron uan otariba ko uan dafariba isa bulmakaun dapanim gisɨn da arɨki. ");
INSERT INTO msy2020_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moses bulmakaun kam mɨsuegha, an ghuzir maba ini. Egha uan dafarir puzim isa ghuzim garugha, ghuzir muziariba isa ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dagh arɨki. Egha arazir kamɨn a ofa gamir dakozim gamima, a Godɨn damazimɨn zue. Ezɨ Moses ghuzir ikiavɨra itiba inigha, ofa gamir dakozimɨn mɨngarim ginge, kar arazir kuraba gɨn amangamin arazim. Egha arazir kamɨn, an ofa gamir dakozim God bagha anemɨsevezɨ, a Godɨn bizimram oto. ");
INSERT INTO msy2020_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Egha Moses bulmakaun navim ko muriaba avarazir oviba bar ada inigha, an ovɨzir pumuning ko, aningɨn ovim sara inigha, an beramɨn akuar aghuim inigha bar ofa gamir dakozimɨn da tuezɨ, avim bar dar isia ghua mɨghɨrizɨ, averenir kɨnimɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Egha a bulmakaun kamɨn ikiavɨra itir asɨzir naba, kar an iniba, tuziba, ko buariba, a bar da inigha, nguibar me itimɨn azenan ghua avim gaborogha bar da tue, Ikiavɨra Itir God mɨkemezɨ moghɨn, Moses ami. ");
INSERT INTO msy2020_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Egha Moses sipsipɨn apurir kamningɨn mam inigha izi. Kar ofan bar isia mɨghɨrim damuamin sipsip. Ezɨ Aron uan otariba ko me uan dafariba isa sipsipɨn dapanim gisɨn da arɨki. ");
INSERT INTO msy2020_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Ezɨ Moses sipsipɨn kam mɨsuegha, an ghuziba inigha ofa gamir dakozimɨn 4plan mɨriabar da kavamangi. ");
INSERT INTO msy2020_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","21","Egha a sipsip aghoragharigha, an muriaba ko an suemning deraghavɨra da rue. A gɨn sipsipɨn dapanim ko ovim ko an asɨzir otevir maba sara inigha, bar da isa ofa gamir dakozim gatɨgha bar ada tuezɨ, avim bar dar isia ghua mɨghɨrizɨ, averenir kɨnim oto. Ikiavɨra Itir God a mɨkemezɨ moghɨra, Moses ami. Sipsipɨn kam, kar bar isia mɨghɨrir ofa. Ikiavɨra Itir God an mughuriam baregh, a gifuegh, egh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Ezɨ Moses sipsipɨn apurir igharazim inigha izi, sipsipɨn kam, ofan me gumazibar amutɨ me ofa gamir gumazibar otivamim. Ezɨ Aron uan otariba ko uan dafariba isa sipsipɨn kamɨn dapanim garɨki. ");
INSERT INTO msy2020_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Ezɨ Moses sipsip mɨsuegha an ghuzir muziarim inigha, Aronɨn kuarir guvimɨn itir kuarir amɨrazim, ko an dafarir puzir amebar agharir guvimɨn itim, ko dagarir puzir amebar suer agharir guvimɨn itim, dagh aghui. ");
INSERT INTO msy2020_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Egha Moses Aronɨn otariba inigha iza, ghuzir muziariba isa, men kuarir guvibar amadaghan itir kuarir apebar amɨraziba, ko men dafarir puzir amebar dafarir guvimɨn itiba ko dagarir puzir amebar suer guvimɨn itibagh aghui. Egha sipsipɨn ghuzir ikiavɨra itiba bar ada inigha ghua, ofa gamir dakozimɨn 4plan mɨriabar da kavamangi. ");
INSERT INTO msy2020_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Egha sipsipɨn oviba ini. Kar an navim ko muriam avarazir oviba, ko an puer mɨngarimɨn itir ovir bar ekiam ini. Egha an an ovɨzir pumuning ko, aningɨn ovim sara inigha, sipsipɨn beramɨn akuar aghuim inigha, sipsipɨn buaragharir agharir guvimɨn itim ini. ");
INSERT INTO msy2020_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Egha Moses ghua, Godɨn damazimɨn itir yis puvatɨzir bret bar izɨvazir akɨrar kam bagha ghua, bretɨn ruzir me yis sara tuazir puvatɨzir mam, ko plauan me olivɨn borem sara veregha ingarizir bretɨn ruzir mam, ko olivɨn borer ekiam avarazir bisketɨn mam ini. Egha a bretɨn kaba isa sipsipɨn oviba ko buaghagharir agharir guvimɨn itim gisɨn atɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Egha gɨn dagher kaba isa Aron uan otariba ko men dafaribagh atɨzɨ, me ofan kamɨn suiragha a fegha a gamizɨ, a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi. ");
INSERT INTO msy2020_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Ezɨ Moses ua dagher kaba me da da inigha, da isa ofa gamir dakozimɨn asɨzir ofan bar isia mɨghɨrizim gisɨn atɨzɨ, avim bizir kaba bar dar isizɨ, da bar mɨghɨrizɨ averenir kɨnim oto. Ofan kam, a gumazibar amutɨ me ofa gamir gumazibar otivamin ofa. Ezɨ Ikiavɨra Itir God an mughuriam gifuegha navim an dera. ");
INSERT INTO msy2020_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Ezɨ datɨrɨghɨn Moses sipsipɨn kamɨn uan dafarimningɨn an amagapamɨn itir asɨzir tuzimɨn suiragha a fegha a gamizɨ, a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi. Ezɨ me gumazibar amutɨ me ofa gamir gumazibar otivamin ofan sipsipɨn apurimɨn akuar kam, kar Moses uabɨ damamin asɨzir tuzim. Moses Ikiavɨra Itir God a mɨkemezɨ moghɨra bizibagh ami. ");
INSERT INTO msy2020_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Egha Moses biziba mɨsevir olivɨn borer muziarir maba inigha, ghuzir an ofa gamir dakozimɨn mɨriam gingezir maba sara ini. Egha ghuzim, ko borem isa, Aron ko an korotiaba sara, da kavamangi. Egha an otariba ko men korotiaba sara, da kavamangi. Egha arazir kamɨn Moses, Aron ko an otaribagh amizɨ, me ko men korotiaba Ikiavɨra Itir Godɨn bizibara. ");
INSERT INTO msy2020_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ezɨ Moses ghua kamaghɨn Aron ko an otaribav gɨa ghaze, “Ia asɨzir tuzir kam inigh God bativamin Purirpenimɨn tiar akamɨn mangɨ, egh anevigh bretɨn akɨramɨn itim sara damɨ. God ia mɨkemezɨ moghɨra, Iarara dar amɨ. Akɨrar bret itir kam, me an aven bret isa gumazibagh ami me ofa gamir gumazibar otivasa ofa gami. ");
INSERT INTO msy2020_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Egh ia damegh izɨvagh, asɨzir tuzir naba ko bretɨn naba ikɨvɨra ikɨtɨ, ia avimɨn da tueghtɨ da bar isi mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Egh ia 7plan aruebar God bativamin Purirpenimɨn tiar akamɨn azenan mangan markɨ. Ia kamaghɨra ikɨ mangɨ, ian dughiar ofa gamir gumaziba mɨsevir kam gɨvagham. Guizbangɨra, arazir gumazim gamima an ofa gamir gumazibar otivamin dughiam, a 7plan arueba. ");
INSERT INTO msy2020_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ikiavɨra Itir God uabɨ, Akar Gavgavim e mɨkemegha ghaze, Ia uan arazir kuraba gɨn amangɨsɨ, arazir kaba bar dar amu. Ezɨ datɨrɨghɨn ia dagh amigha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ia arueba ko dɨmagaribar God bativamin Purirpenimɨn tiar akamɨn ikɨ mangɨ 7plan dughiabar tugh, egh ia Ikiavɨra Itir God mɨkemezɨ moghɨn bizibar amu. Egh ia dar amuan kogh, ia arɨmɨghiregham. Ikiavɨra Itir God kamaghɨn na mɨkeme.” ");
INSERT INTO msy2020_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Mosesɨn mɨgɨrɨgɨabar aven, Ikiavɨra Itir God bizir kabar Aron ko an otaribav keme. Ezɨ me kamaghɨra dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Moses Aron uan otariba ko, me isa ofa gamir ingangarim bagha me atɨgha gɨfa. Ezɨ dughiar namba 8 otozɨma, Moses dɨkavigha Aron ko an otariba ko Israelian gumazir dapanibar diazɨ, me iza uari akufa. ");
INSERT INTO msy2020_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Me uari akuvagha itima, a kamaghɨn Aron mɨgei, “Bulmakaun nguzir igiar apuritam, arazir kuraba gɨn amadir ofa damusɨ a inigh. Egh sipsipɨn apurir aghuir duaba an mɨkarzimɨn puvatɨzitam, ofan bar isia mɨghɨrim damusɨ a inigh izɨ. Egh nɨ Ikiavɨra Itir Godɨn damazimɨn aningɨn ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Egh nɨ kamaghɨn Israelian gumazamizibav kemegh, ‘Ia arazir kuraba gɨn amadir ofa damusɨ memen apuritam inigh. Egh ofan bar isi mɨghɨramibar amusɨ, bulmakaun azenir vamɨra ititam ko sipsipɨn apurir azenir vamɨra ititam inigh, na bagh ofa damu. Ia asɨzir aghuibara inigh, duatam men mɨkarzibar ikian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Egh uaghan ia ofan God ko navir vamɨra ikiamim damusɨ, bulmakaun tam ko sipsipɨn apuritam inigh. Ia, asɨzir kamning ko wit tuer ofan ia olivɨn borem sara verezim, ia aning inigh Ikiavɨra Itir Godɨn ofa damu. Dughiar kamra, Ikiavɨra Itir God ian damazimɨn otogham, kamaghɨn amizɨ, ia ofan kabar amu.’ ” ");
INSERT INTO msy2020_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ezɨ Aron ko gumazir kaba, me ghua bizir Moses me mɨkemeziba inigha, God bativamin Purirpenimɨn boroghɨn ize. Ezɨ Israelian gumazamiziba bar, Ikiavɨra Itir Godɨn ziam fasa iza an damazimɨn uari akuvagha tuivighav iti. ");
INSERT INTO msy2020_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Ezɨ Moses kamaghɨn me mɨgei, “Ikiavɨra Itir God ghaze, ia ofan kabar amutɨ, Ikiavɨra Itir Godɨn angazangarir bar gavgavim ia bativam.” ");
INSERT INTO msy2020_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Egha Moses kamaghɨn Aron mɨgɨa ghaze, “Nɨ ofa gamir dakozimɨn boroghɨn mangɨ, egh ofan arazir kuraba gɨn amangamim ko nɨn ofan bar isi mɨghɨrighamim sara damu. Nɨ ua bagh kamaghɨn damutɨ God nɨn arazir kuraba gɨn amangɨva, gumazamizibar arazir kuraba sara gɨn amangam. Egh gɨn, Ikiavɨra Itir God mɨkemezɨ moghɨn, gumazamiziba isa izir ofaba, nɨ me bagh ofa damutɨ God men arazir kuraba gɨn amangam.” ");
INSERT INTO msy2020_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ezɨ Aron ofa gamir dakozimɨn boroghɨn ghugha, bulmakaun apurir igiar kam mɨsuegha, uabɨ uan arazir kuraba gɨn amangasa ofa gami. ");
INSERT INTO msy2020_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ezɨ Aronɨn otariba a bagha asɨzir ghuziba inigha iza a ganɨngizɨ, a uan dafarir puzim isa ghuzim garugha, ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir bizibagh arigha, ghuzir naba an ofa gamir dakozimɨn mɨngarim ginge. ");
INSERT INTO msy2020_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Egha gɨn Aron, arazir kuraba gɨn amadir ofan kamɨn asɨzir oviba bar ada inigha, ovɨzimning ko beramɨn akuar aghuim ini. Egha a bar da ofa gamir dakozimɨn da tuezɨ avim bar dar isia zuima da bar mɨghɨrizɨ, averenir kɨnim oto. Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, Aron ami. ");
INSERT INTO msy2020_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Egha an asɨzir tuziba ko iniba inigha, nguibar me itimɨn azenan ghua da tuezɨ, avim bar dar isizɨ da gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Egha gɨn Aron ghua, ofan bar isia mɨghɨrizim damuasa sipsipɨn apurir kam mɨsoke. Ezɨ an otariba asɨzir ghuzir kaba inigha iza a ganɨngizɨ, an ofa gamir dakozimɨn 4plan mɨriabar da kavamangi. ");
INSERT INTO msy2020_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ezɨ otariba asɨzir dapanim ko asɨzir otevir maba sara vaghvagha da inigha iza a ganɨngi. Ezɨ a bar ofa gamir dakozimɨn da tuezɨ avim bar dar isia mɨghɨrizɨ, averenir kɨnim oto. ");
INSERT INTO msy2020_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ezɨ an asɨzir kamɨn muriaba ko an suemning sara ruegha, bar ada isa ofan bar isia mɨghɨrizir kamɨn mabagh isɨn da arɨki, ezɨ avim bar dar isi da mɨghɨrizɨ, averenir kɨnim oto. ");
INSERT INTO msy2020_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Egha Aron gɨn gumazamizibar ofaba inigha, Ikiavɨra Itir God bagha ofa gami. A gumazamizibar ofabar amu men arazir kuraba gɨn amangamimɨn meme inigha, a mɨsuegha an ofa gami. Mati a faragha ua bagha uan arazir kuraba gɨn amangamin asɨzimɨn ofa gamizɨ mokɨn. ");
INSERT INTO msy2020_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","17","Egha an asɨzir gumazamiziba ofan bar isia mɨghɨrizim bagha inigha izezir kamningɨn mamɨn ofa gami. An amir ofan kam, arazir me zurara mɨzarazibar ofa damuamibar gɨn zui. Egha a plaua inigha witɨn ofa damuasa a tue. A uan dafarir zɨvɨrizimɨn plauan mabar suigha, ofa gamir dakozimɨn da tuezɨ avim bar dar isia zuima da bar mɨghɨrizɨ, averenir kɨnim oto. ");
INSERT INTO msy2020_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Egha gɨn, Aron bulmakau ko sipsipɨn apurir gumazamiziba God ko navir vamɨran ikiamin ofa bagha inigha izezimning mɨsoke. Ezɨ an otariba asɨzir kamningɨn ghuziba inigha a ganɨngizɨ, an ofa gamir dakozimɨn 4plan mɨriabar da kavamangi. ");
INSERT INTO msy2020_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Egha Aron bulmakau ko sipsipɨn apurimɨn oviba bar ada ini, kar an puer mɨngarim boroghɨra itir ovir bar ekiam, ko navim ko muriaba avarazir oviba, ko ovɨzir pumuning, aningɨn ovim ko beramɨn akuar aghuim, a bar da ini. ");
INSERT INTO msy2020_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Egha me ovir kaba isa asɨzimningɨn amagapamning gatɨgha, bar da inigha ofa gamir dakozimɨn ghu. Asɨzir oviba bar, Aron ofa gamir dakozimɨn da tuezɨ avim bar dar isia zuima da bar mɨghɨrizɨ, averenir kɨnim oto. ");
INSERT INTO msy2020_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Egha a uan dafarimɨn bulmakau ko sipsipɨn amagapamning ko agharir guvimɨn amadaghan itir buaragharimningɨn suiragha da fegha dagh amizɨ, da Ikiavɨra Itir Godɨn damazimɨn ighuavamadi. A Moses mɨkemezɨ moghɨn ami. ");
INSERT INTO msy2020_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aron ofan kaba bar dagh amigha gɨvagha, uan agharimning ghufegha, gumazamizibav gɨa ghaze, God deraghvɨra ia damu. Egha ofa gamir dakozim ategha izaghirɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Egha Moses ko Aron, God bativamin Purirpenimɨn aven ghu. Egha aning azenan izir dughiamɨn, aning ghaze, God deraghvɨra bar gumazamizibar amuam. Ezɨ Ikiavɨra Itir Godɨn angazangarir bar ekiam, azenim girɨzɨ gumazamiziba bar an gani. ");
INSERT INTO msy2020_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ezɨ zuamɨra Ikiavɨra Itir God avim amadazɨ, an ofa gamir dakozimɨn izaghirɨ. Egha avim ofan bar isia mɨghɨrim ko asɨzir oviba sara bar adar isi. Ezɨ gumazamiziba bar bizir kamɨn ganigha nguazim giregha, guaba nguazim mɨsuegha, pamtemɨn dia Ikiavɨra Itir Godɨn ziam fe. ");
INSERT INTO msy2020_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ezɨ dughiar kamɨn Aronɨn otaribar mamning Nadap ko Abihu, aning pauran mughuriar aghuim zuim tuasa uan itariba ini. Egha aning avir mɨkɨam ko pauran mughuriar aghuim zuim isa itarim gatɨgha, avir kam inigha ofan mɨn Ikiavɨra Itir God bagha ghu. Me fo, Ikiavɨra Itir God kamaghɨn garir avim inigh izasa mɨkemezir puvatɨ. Kamaghɨn amizɨ, bizir kam a Ikiavɨra Itir Godɨn bizim puvatɨ, ezɨ an an aghua. ");
INSERT INTO msy2020_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Egha Ikiavɨra Itir God, zuamɨram avim amadazɨ, a iza Ikiavɨra Itir Godɨn damazimɨn bar aningɨn isizɨ, aning areme. ");
INSERT INTO msy2020_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Ezɨ Moses kamaghɨn Aron mɨgei, “Ikiavɨra Itir God, fomɨra kamaghɨn ikiangsɨgha ia mɨkeme, ‘Gumazir nan boroghɨn iza nan ingangarim gamiba, me bar nan apengan ikɨ deragh na damuva kamaghɨn fogh suam, kɨ guizbangɨra Ikiavɨra Itir Godɨn bar zuezim. Eghtɨ kɨ uan gavgavim ko angazangarim gumazamizibar akagham. Eghtɨ me nan ziam fam.’ ” Ezɨ Aron akar kam baregha mɨkɨman ibura. ");
INSERT INTO msy2020_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Ezɨ Moses dɨkavigha, Aronɨn ghurir afeziar dozim Usiel, an otarimning, Misael ko Elsafan, aningɨn diazɨ, aning ize. Ezɨ Moses kamaghɨn aning mɨgei, “Gua roghɨra kagh izɨva, uan avebamningɨn kuamning inigh, egh Ikiavɨra Itir Godɨn Purirpenim ategh, saghon mangɨ danganir e itimɨn azenan mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ezɨ aning Moses mɨkemezɨ moghɨn ghua, gumazir kuamning inigha danganir me itimɨn azenan ghu. Aning gumazir ovengezir kuamningɨn korotiaba suezir pu. Puvatɨ, Misael ko Elsafan, aningɨn korotiabar suigha aning amɨkɨrɨgha azenan zui. ");
INSERT INTO msy2020_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ezɨ Moses datɨrɨghɨn, Aron ko an otarir igharazir pumuning, Eleasar ko Itamar, akaba me ganɨdi. A kamaghɨn me mɨgei, “Ia apangkuvir arazimɨn gɨn mangɨ gumazir aremezir kamning damuan markɨ. Ia dughiaba zurara uan dapanir arɨziba batoghvɨra ikɨ. Ia da ateghtɨ da pura ikian markɨ. Ia uan apangkuvimɨn ababanim bagh, korotiaba abɨghan markɨ. Ia apangkuvir arazimɨn gɨn mangɨtɨ, Ikiavɨra Itir God ia mɨsueghtɨ, ia arɨmɨghiregham. Eghtɨ e Israelian gumazamiziba, Ikiavɨra Itir God bar puvɨram en ataram. Eghtɨ Israelian igharaz darasi, kar ian marazira, merara Ikiavɨra Itir God amadazir avimɨn aremezir gumazimning bagh aziam. ");
INSERT INTO msy2020_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Eghtɨ ia God bativamin Purirpenimɨn tiar akam ataghɨraghan markɨ, ia tong ikegh. Ia fo, kɨ Ikiavɨra Itir Godɨn bizimra ikiasa olivɨn borem ia gaghuizɨ, ia Ikiavɨra Itir Godɨn adarazira. Kamaghɨn amizɨ, ia Ikiavɨra Itir Godɨn Purirpenimɨn azenan mangegh, ia arɨghiregham.” Ezɨ me Mosesɨn akam baregha, a mɨkemezɨ moghɨn ami. ");
INSERT INTO msy2020_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ikiavɨra Itir God kamaghɨn Aron mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Nɨ uan otariba ko, ia wainɨn dɨpar onganiba amegh, nan damazimɨn, na bativamin Purirpenimɨn aven mangan markɨ. Bar markiam. Ia aven mangɨva, ia arɨmɨghiregham. Ia ko ian ovavir borir gɨn otivamiba, arazir kamɨn gɨntɨgh mamaghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ia deraghvɨra biziba tuisɨgh, bizir manam a nan bizim, ezɨ bizir manam, a gumazamizir kɨnibar bizim. Ezɨ dar tongɨn bizir manaba nan damazimɨn zuezɨ, manaba mɨze. ");
INSERT INTO msy2020_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Egh ia, arazir Ikiavɨra Itir God ifongeziba, a Moses mɨkemezɨ a da isa Israelia ganɨngizir kaba, ia bar dar Israelian gumazamizibar sure damu.” ");
INSERT INTO msy2020_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Ezɨ Moses kamaghɨn Aron uan otarir ikiavɨra itir pumuning Eleasar ko Itamar mɨgei, “Ia Ikiavɨra Itir God bagh wit tuamin ofan nar ikiavɨra itiba inigh. Plauan kam, ia a isɨ yis puvatɨzir bretɨn ingarigh. Ofan kam, a bar Godɨn bizimra, a ia ganɨngi. Kamaghɨn amizɨ, ia ofa gamir dakozimɨn boroghɨn bretɨn kam amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ikiavɨra Itir God bizir kamɨn na mɨkemegha gɨfa. Kamaghɨn amizɨ, wit tuer ofan nar kaba bar, da ia ko ian otaribar biziba. Ia gumazamizir Ikiavɨra Itir God bagha wit tuer ofa gamiba, dar tongɨn plauan kaba ini. Egh ia Ikiavɨra Itir Godɨn Purirpenim avɨnizir dɨvazimɨn aven bretɨn kam amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","15","Eghtɨ Israelian gumazamiziba, God ko navir vamɨra ikiamin ofa damusɨ, asɨzimɨn amagapamɨn itir tuzim ko buaragharim ko oviba sara inigh izɨ. Eghtɨ ia ofa gamir gumaziba, ia amagapamɨn itir tuzimɨn suiragh da fegh dar amutɨ da Ikiavɨra Itir Godɨn damazimɨn ighuavamang. Egh ia gɨn ofa gamir dakozimɨn oviba tuegh. Egh ofan kamɨn asɨzir tuzibar tongɨn, ia amagapam ko buaragharim inigh. Eghtɨ ia ko ian adarazir, guiviba ko otariba uaghara, asɨzir tuzir kamning isɨ danganir Godɨn damazimɨn zuezir tamɨn mangɨ, aning amɨ. Ikiavɨra Itir God ofan kabar asɨzir otevir kamning isa, ia ko ian boribagh anɨngi. Egh zurazurara asɨzir otevir kamning, aning ia ko ian ovavir boribar asɨzir akuamning. Ikiavɨra Itir God kamaghɨn mɨkemegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Egha gɨn Moses ghua arazir kuraba gɨn amadir ofa damuamin meme bagha azaragha ghaze, “Ofa gamir gumaziba manmaghɨn memen ofa damu arazir kuraba gɨn amangamim gami?” Ezɨ me a mɨgei, “E avimɨn a tuazɨ a isigha gɨfa.” Ezɨ Moses akar kam baregha, Aronɨn otarir pumuning Eleasar ko Itamarɨn atari. Egha a ghaze, ");
INSERT INTO msy2020_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Manmagh amizɨ ia Ikiavɨra Itir Godɨn Purirpenim avɨnizir dɨvazimɨn aven, arazir kuraba gɨn amadir ofan kamɨn asɨzir tuzim aman aghua? Kar ofan Ikiavɨra Itir God ua baghavɨra mɨsevezim, egha a ia ganɨngi, ia gumazamizibar osɨmtɨziba akɨrɨva, men arazir kuraba gɨn amangɨsɨ anemam. ");
INSERT INTO msy2020_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ia ofan kamɨn ghuzim inigha purirpenimɨn Anogoroghezir Danganimɨn aven ghuzir puvatɨ. Egha manmagh amizɨ, kɨ ia mɨkemezɨ moghɨn ia Purirpenimɨn aven asɨzir tuzir kam amezir puvatɨ?” ");
INSERT INTO msy2020_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ezɨ Aron kamaghɨn Moses mɨgei, “Nɨ oragh. Datɨrɨghɨra, gumazamiziba uan arazir kuraba gɨn amadir ofa ko ofan bar isia mɨghɨrim isa Ikiavɨra Itir God ganɨdi. Ezɨ kɨrara, datɨrɨghɨn bizir kurar kaba na bativigha gɨfa. Nan gumazir pumuning areme. Kamaghɨn amizɨ, kɨ datɨrɨghɨra arazir kuraba gɨn amadir ofan asɨzir tuzim amam, eghtɨ Ikiavɨra Itir God ti bizir kam gakuegham, o? Kɨ ghaze, ti puvatɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ezɨ Moses kamaghɨn oregha ghaze, Aronɨn akam a dera. Ezɨ an navim an amɨra. ");
INSERT INTO msy2020_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","2","Ikiavɨra Itir God Israelia mɨkɨmasa kamaghɨn Moses ko Aron mɨkeme, “Ia, nguazir kamɨn itir asɨzibar tongɨn, asɨzir kabara, ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Asɨzir kabanang: Dar soroghafariba puzir pumuning ikia, aning uaning tuiragha iti, egha da bulmakaubar mɨn graziba api, ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","Egh ia kamelba ko ivarareba ko ighɨaba, ia dar aman markɨ. Da bulmakaubar mɨn graziba apir asɨziba, egha dar soroghafariba puzir pumuning ikia, uaning tuiragha itir puvatɨ. Kamaghɨn amizɨ, ia kamaghɨn fogh suam, da nan damazimɨn zuezir puvatɨ. Kɨ dar aman ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Egh ia dabar aman markɨ. Dar soroghafariba puzir pumuning iti, egha uaning tuiragha ikia, bulmakaubar mɨn graziba apir puvatɨ. Kamaghɨn amizɨ ia fogh, daba da nan damazimɨn mɨze. ");
INSERT INTO msy2020_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Kamaghɨn amizɨ, ia asɨzir kabar aman markɨ. Egh ia dar gantɨ da arɨghirɨtɨ, ia dar kuabar suighan markɨ. Bar markiam. Da nan damazimɨn zuezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Egh ongarimɨn osiriba ko dɨpamɨn osiribar tongɨn, osiriba naziaba ko sighiaba uaghara ikɨtɨ ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ezɨ osiriba ko bizir muziarir ongarim ko tintinibar dɨpabar itiba, da naziaba ko sighiaba uaghara puvatɨghtɨ, ia fogh, da bizir bar kuraba. ");
INSERT INTO msy2020_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Kamaghɨn amizɨ, ia dar aman kogh, egh dar kuabar suighan markɨ. Kɨ bar anogoroke. Da bizir bar kuraba. ");
INSERT INTO msy2020_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ia uam oragh, angamɨra itir bizir dɨpabar ititam, a naziaba ko sighiaba puvatɨghtɨ, ia anereman markɨ. Ia bizir kabar aghuagh da atakigh. ");
INSERT INTO msy2020_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","19","“Egh ia kuarazibar tongɨn kuarazir kamagh garibar aman markɨ. Ia kamaghɨn mɨkɨm suam, da bizir bar kurar kɨ aghuaziba. Kuarazir kaba, taragiaba, mɨghɨaba, isaba, kotkotba, poneba, ongarimɨn kuaraziba, beniba, dɨpamɨn mughamiziba, aghunabar ekiaba ko, kina aghunababa. Ia kuarazir kabar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Ezɨ apizir suemning ko dafarimning ko avɨziba itiba, da bizir kuraba, kɨ dar anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Eghtɨ apizibar tongɨn apizir soroghafariba ikia arua uari akuriba, ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kamaghɨn amizɨ, odezir ekiaba ko doziba, ia bar dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ezɨ apizir sueba ko dafariba ko avɨziba itiba, ia kamaghɨn fogh suam, da bizir bar kuraba. Kɨ dar anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","25","“Asɨzir maba uaghan, ia damutɨ, ia nan damazimɨn mɨzegham. Eghtɨ gumazitam asɨzir kabar kuabar suiragh, o aneter danganitamɨn mangam, gumazir kam nan damazimɨn mɨzegham. Gumazir asɨzir kamɨn suiraghamim, a uan korotiaba ruegh, egh a nan damazimɨn mɨzegh ikɨ mangɨ guaratɨzimɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Asɨziba, dar soroghafariba puzir pumuning ikiava, uaning tuirazir puvatɨgha, bulmakaun mɨn graziba apir puvatɨ, ia kamaghɨn fogh suam, asɨzir kaba, da bizir aghuiba puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Ezɨ asɨzir soroghafarir puziba puvatɨziba, da bar, asɨzir aghuiba puvatɨ. Egh ia asɨzir katamɨn kuamɨn suiraghɨva, ia nan damazimɨn mɨzegham. Egh ia kamaghɨra ikɨ mangɨ guaratɨzimɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Eghtɨ gumazitam asɨzir kuar kam inigh danganir igharazimɨn mangɨgham, a uan korotiaba ruegh, nan damazimɨn mɨzeghvɨra ikɨ mangɨtɨ aruem magɨrɨgham. Asɨzir kaba ia gamima ia mɨze. ");
INSERT INTO msy2020_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“Asɨzir kaba uaghan markiam, kɨ da ian anogoroke. Kar iriaba, ko kuarziba ko iper guar avɨriba. ");
INSERT INTO msy2020_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Kɨ asɨzir kaba ian anogoroke. Eghtɨ ia dar kuabar suighɨva, nan damazimɨn mɨzeghvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Eghtɨ asɨzir katam aremegh, bizitam gisɨn irɨgham, bizir kam uaghan nan damazimɨn mɨzegham. An kuam irɨ, bizir me temebar ingarizir tam o initam o bulmakaun inimɨn ingarizir initam o mɨtaritam, o ingangarir manam itir bizitam, a bizir katam gisɨn irɨgham, a nan damazimɨn bar mɨzegham. Eghtɨ ia a isɨ dɨpamɨn a rueghtɨ, bizir kam nan damazimɨn mɨzeghvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Eghtɨ asɨzir mɨzezir kamɨn mɨkarzim nguazir mɨnem girɨghtɨ, bizir mɨner kamɨn itiba bar mɨzegham. Kamaghɨn, ia mɨner kam abɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Eghtɨ daghetaba roghɨra ikɨtɨ, mɨner kamɨn dɨpam dagher kabagh ireghtɨ, dagher kaba nan damazimɨn uaghan mɨzegham. Ezɨ dɨpar mɨner kamɨn itim, a ikuvigha mɨzegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Eghtɨ asɨzir kam bizitam girɨgham, bizir kam nan damazimɨn a mɨzegham. Eghtɨ mɨner kam, o bretba tuer danganir me nguazimɨn ingarizir kam, ia uaghan anebɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Egh asɨzir kam mozir dɨpar pura nguazimɨn otivim girɨgham, o tengɨn dɨpam girɨgham, eghtɨ dɨpam nan damazimɨn mɨzeghan kogham. Puvatɨ. Ezɨ bizir manam asɨzir kamɨn mɨkarzimɨn poro, a mɨzegha ikufi. ");
INSERT INTO msy2020_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Eghtɨ asɨzir katam aremegh an kuam dagher anabar oparibagh isɨn irɨ, a deragham. Dagher anabar kam, a mɨzezir puvatɨ, a zueghavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ezɨ dagher anabar kam dɨpamɨn aven itima, asɨzir kamɨn kuam a girɨ, dagher anabar kaba nan damazimɨn mɨze. ");
INSERT INTO msy2020_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Ia asɨzir kɨ damasa ia mɨkemezibagh nɨghnɨgh. Egh asɨzir kabar tam puram aremeghtɨ, gumazitam o amizitam an suiragham, gumazir kam o amizir kam, nan damazimɨn mɨzegham. Egh a kamaghɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Eghtɨ gumazitam asɨzir kamɨn tuzitam ame, o asɨzir kamɨn kuam ateri, a uan korotiaba ruegh. Egh a mɨzeghvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Eghtɨ ia asɨzir muziariba ko apizir nguazimɨn aruibar aman markɨ. Ia kamaghɨn nɨghnɨgh, da bizir bar kuraba. ");
INSERT INTO msy2020_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Egh asɨzir uan navibar nguazim davariba, ko soroghafaribar aruir asɨziba, ko asɨzir suer avɨravɨriba itiba, da bizir aghuiba puvatɨ. Eghtɨ ia dar aman markɨ. Kɨ dar ian anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ia asɨzir kabar tam aman markɨ. Kɨ bar dar aghua. Egh ia tam amegh, ia nan damazimɨn mɨzegham. Eghtɨ kɨ dar aghuazɨ moghɨn, kɨ bar ian aghuagham. ");
INSERT INTO msy2020_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kɨ Ikiavɨra Itir God, ian God, egha kɨ bar zue. Eghtɨ ia uari isɨ na danigh, nan gumazamizibar ikɨvɨra ikɨ, egh arazir kuraba ategh, arazir aghuibar gɨn mangɨ nan mɨn zueghvɨra ikɨ. Ia kɨ aghuazir asɨzir mɨzɨrɨzibar amɨva, nan damazimɨn mɨzeghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kɨ Ikiavɨra Itir God. Kɨ ian Godɨn ikiasa Isipɨn kantrin aven ia inigha azenan ize. Kɨ uabɨ bar zuezɨ nan araziba bar dera. Kamaghɨn amizɨ, ia zuegh ikɨ nan arazir aghuibar gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ezɨ Akar Gavgavir ia datɨrɨghɨn inizir kam, an asɨziba ko, kuaraziba ko, bizir ongarimɨn aven itiba ko, apizir nguazimɨn davaribav gei. ");
INSERT INTO msy2020_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Kamaghɨn amizɨ, ia deraghvɨra biziba tuisɨgh, bizir manam a zue, ezɨ bizir manam a nan damazimɨn zuezir puvatɨ. Egh ia angamɨra itir bizir ia damamiba ko ia daman koghamiba, ia deraghvɨra dagh fogh.” ");
INSERT INTO msy2020_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Nɨ kamaghɨn Israelian gumazamizibav mɨkemegh: Amizitam navim asegh, otarim bategham, a nan damazimɨn mɨzeghvɨra ikɨ mangɨ 7plan aruebar tugham, mati a uan iakɨnibav sozir dughiam. ");
INSERT INTO msy2020_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Eghtɨ 7plan arueba gɨvaghtɨ, namba 8ɨn aruem otoghtɨ, me otarir kamɨn mɨkarzir mogomemɨn inim atugham. ");
INSERT INTO msy2020_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Amizim borim bategha ghuzir avɨrim makuri. Kamaghɨn amizɨ, a nan damazimɨn mɨzegh, 33plan aruebar ikeghɨva gɨn ua zuegham. Dughiar a mɨzeghvɨra ikiamimɨn, a bizir kɨ ua baghavɨra mɨsevezir tamɨn suighan kogham. Egh a nan Purirpenim avɨnizir dɨvazimɨn aven mangan kogh, mangɨ a ua zueghamin dughiamɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Amizim borir guivim bategh, a 14plan aruebar mɨzeghvɨra ikiam, mati a uan iakɨnibav sozir dughiam. A uan ghuzir avɨrim makuni, kamaghɨn amizɨ a nan damazimɨn mɨzegh, ua 66plan aruebar ikeghɨva, gɨn ua zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Egh amebam ua zueghɨva, a uan otarir iririvim o guivir iririvim gɨnɨghnɨgh, ofan bar isia mɨghɨrim bagh, sipsipɨn igiar azenir vamɨra itim inigh, egh uaghan ofan arazir kuraba gɨn amangamim bagh, kuarazir bunbam inigh. An ofan kamning isɨ ofa gamir gumazim bagh God bativamin Purirpenimɨn tiar akamɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Eghtɨ ofa gamir gumazim amizir kamɨn kuarazim ko sipsip inigh na bagh ofa damutɨ, amizim ua zuegham. Eghtɨ ghuzir kam amizim damutɨ a ua mɨzeghan kogham. A datɨrɨghɨn nan damazimɨn zuegha gɨfa. Amizim otarim o guivim bategh, an arazir kamra damu. ");
INSERT INTO msy2020_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Amizitam sipsip givezamin dagɨaba otevegh, a kuarazir bunbar igiar pumuning o osɨrvar igiar pumuning inigh izɨ. Eghtɨ ofa gamir gumazim kuarazir tamɨn, ofan bar isia mɨghɨrim damu, egh kuarazir igharazimɨn, an arazir kuraba gɨn amadir ofa damu. Eghtɨ ofa gamir gumazim kuarazir kamningɨn ofa damightɨ, amizim ua nan damazimɨn zuegham.” ");
INSERT INTO msy2020_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ikiavɨra Itir God, kamaghɨn Moses ko Aron mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Gumazitam o amizitam, duatam o okatam o mɨkarzir ghuarir ghurghuritam, an mɨkarzimɨn otogham, egh bizir kamɨn ganganim mati lepan arɨmariam o arɨmariar ekiar igharaziba otivasava ami, eghtɨ me a inigh ofa gamir gumazim Aron bagh mangɨ, o an otarir uaghan ofa gamiba, men tav bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Eghtɨ ofa gamir gumazim deraghvɨra duar kamɨn ganigh fogh suam, an duar kurimɨn aven itir arɨziba ghurghurigha gɨfa, ezɨ duam bar an mɨkarzimɨn aven ghu, kar lepan arɨmariamra o arɨmariar ekiar igharazim. Eghtɨ ofa gamir gumazim an ganigh gɨvagh, kamaghɨn mɨkɨmam, ‘Gumazir kam, a Godɨn damazimɨn zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Eghtɨ duam ghurghurightɨ, ofa gamir gumazim duamɨn gantɨ, a mɨkarzimɨn inimɨn aven mangɨghan kogh, egh arɨzir ghurghuriba puvatɨghtɨ, ofa gamir gumazim, gumazir kam mɨkɨm suam, a uabɨra dɨpenitamɨn ikɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Eghtɨ namba 7ɨn aruemɨn, ofa gamir gumazim, ua gumazir kamɨn duamɨn gan a tuisɨgh, eghtɨ duamɨn ganganim kamaghɨra ikɨ ekeveghan koghtɨ, a ua gumazim ateghtɨ a 7plan aruebar uabɨra ua ikegh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Eghtɨ 7plan aruer kaba gɨvaghtɨ, ofa gamir gumazim uam an gantɨ, duar kam mɨsigh, egh ekeveghan koghtɨ, a fogh suam, gumazir kam pura duar kɨnim iti. Egh ofa gamir gumazim a mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zue. Nɨ uan korotiaba ruegh, zueghɨva mangɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Eghtɨ bizir kamɨn gɨn, duam ua isitɨ, gumazim ua mangɨ ofa gamir gumazim batogh uabɨ an akagh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Eghtɨ ofa gamir gumazim deraghvɨra gumazir kamɨn duamɨn gantɨ, duar kam ekeveghtɨ, a fogh suam, gumazir kam lepan arɨmariar kurar ekiam iti. Eghtɨ ofa gamir gumazim kamaghɨn a mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Eghtɨ gumazitam duar gavgavim ikɨtɨ, me an aku ofa gamir gumazim bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Eghtɨ ofa gamir gumazim deragh gumazimɨn duamɨn ganigh. Eghtɨ duar kam ghurghurigh, arɨzibar amutɨ da ghurghurigh aven emigh mɨzazim a gasam, ");
INSERT INTO msy2020_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","gumazir kam lepan arɨmariam an iti. Eghtɨ ofa gamir gumazim kamaghɨn gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ Ofa gamir gumazim fogha gɨfa, gumazir kam a mɨzezir puvatɨ, kamaghɨn amizɨ, a pura gumazim ateghtɨ, a uabɨra uan dɨpenimɨn ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","13","Eghtɨ arɨmariar kam bar ekevegh mangɨ gumazir kamɨn mɨkarzim bar anevaraghtɨ, ofa gamir gumazim ua gumazimɨn mɨkarzim bar deraghvɨram an ganɨva a tuisɨgham. Egh a gumazimɨn gantɨ, arɨmariar kam bar an mɨkarzim inightɨ, an mɨkarzim bar ghurghurightɨ a fogham, arɨmariar kam gɨvasava ami, eghtɨ a kamaghɨn gumazim mɨkɨmam, ‘Nɨ Godɨn damazimɨn zue.’ Ezɨ kamaghɨn, gumazir kam a zuegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Eghtɨ gɨn, duaba bigh tuzir aven itiba azenan otivightɨ, gumazir kam zueghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Eghtɨ ofa gamir gumazim uam an duabar gantɨ, da bightɨ, a gumazir kam mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ Gumazim duaba ikia egha da bɨghizɨ dar tuziba duar toribar otivtɨ, kamaghɨn a nan damazimɨn zuezir puvatɨ. Kamagh garir duam, a bar arɨmariar kuram. ");
INSERT INTO msy2020_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Egh gɨn duam mɨsightɨ, nir ghurghurim otoghtɨ, gumazir kam ua ofa gamir gumazim bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Eghtɨ ofa gamir gumazim deragh gumazir kamɨn duamɨn gantɨ, an duam mɨsɨngightɨ an inim ghurghurigham, kamaghɨn gumazir kam nan damazimɨn zuegham. Eghtɨ ofa gamir gumazim kamaghɨn a mɨkɨm, ‘Nɨ Godɨn damazimɨn zuegha gɨfa.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Eghtɨ gumazitam okam an mɨkarzimɨn ikɨ, egh mɨsightɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","egh gɨn okam ikezir danganimɨn, an mɨkarzim fɨgh ghurghurigham, o an mɨkarzim aghevegh ghurghurightɨ, kamaghɨn gumazir kam ofa gamir gumazim bagh mangɨ uabɨ isɨ an akagh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Eghtɨ ofa gamir gumazim, gumazir kamɨn okar duamɨn danganim deragh an ganigh. Duam tong an inivafɨzimɨn aven mangɨghtɨ, an inimɨn arɨziba ghurghurigham, eghtɨ ofa gamir gumazim kamaghɨn gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ Lepan arɨmariar kam okar mɨsɨngizir kamɨn danganimɨn otozim, a bizir bar kuram. ");
INSERT INTO msy2020_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Egh ofa gamir gumazim an gantɨ, arɨziba ghurghurighan koghtɨ, duam tong an inivafɨzimɨn aven mangɨghan kogh, egh a tong deragh deraghtɨ, ofa gamir gumazim anetɨghtɨ a uabɨra ikɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Eghtɨ 7plan aruer kabar gɨn duar kam ikɨvɨra ikɨ ekeveghtɨ, ofa gamir gumazim fogh suam, an arɨmariar bar kuram, egh kamaghɨn gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Eghtɨ duar mɨkarzimɨn itimɨn ganganim kamaghɨra ikia, egha ekevir puvatɨ, kar okar kamɨn duar kurim. Kamaghɨn, ofa gamir gumazim kamaghɨn gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zue.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Eghtɨ avim gumazitamɨn inivafɨzimɨn isightɨ, an duam ghurghurigham, o a ghurghurigh aghevegham, ");
INSERT INTO msy2020_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","eghtɨ ofa gamir gumazim duar kam deragh an ganigh. A gantɨ, duar kurir kamɨn arɨziba ghurghurightɨ, duam guizbangɨra mɨkarzimɨn aven mangɨtɨ, ofa gamir gumazim fogham, duar kam, a lepan arɨmariar bar kuram. Egh a gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ofa gamir gumazim an gantɨ, arɨzir duamɨn danganimɨn otiviba ghurghurighan koghtɨ, duam an inivafɨzimɨn aven mangan kogh, egh mɨsɨng damutɨ, kamaghɨn ofa gamir gumazim aneteghtɨ a uabɨra ikɨ mangɨ 7plan dughiabar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ofa gamir gumazim namba 7ɨn dughiamɨn deraghvɨra uam an duamɨn gantɨ, duar kam ikɨvɨra ikɨ ekeveghtɨ, a fogh suam, kar arɨmariar bar kuram. Eghtɨ ofa gamir gumazim kamaghɨn a mɨkɨm suam, ‘Nɨ Godɨn damazimɨn mɨze.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Eghtɨ duar kam pura danganir kamɨn kamaghɨra ikɨ, ekɨvan koghtɨ, kar pura avim isizir duar kurimɨn danganim. Kamaghɨn, ofa gamir gumazim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zue.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Eghtɨ gumazitam o amizitam, duar muziariba an dapanim o an aghozim batoghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ofa gamir gumazim duar muziarir kaba deragh dar gantɨ, duar muziariba inivafɨzim okor bar aven mangɨtɨ, arɨzir avɨriba duar muziarir kabar danganibar puvatɨgh, egh arɨziba aghevegh iangurightɨ, ofa gamir gumazim fogham, duar kaba da arɨmariar bar kuram. Egh an a mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ Kar dapaniba ko aghozibar otivir zɨghzɨzir arɨmariam. ");
INSERT INTO msy2020_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ofa gamir gumazim deravɨra an duar muziaribar gantɨ, duar muziariba inivafɨzim okor bar aven mangan koghtɨ, arɨzir pɨzir aghuiba duam itir danganimɨn deragha otivighan koghtɨ, a gumazim o amizim ateghtɨ a uabɨra ikɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Egh namba 7ɨn aruemɨn, ofa gamir gumazim ua deraghvɨra gumazim o amizir kamɨn mɨkarzir inimɨn ganightɨ, zɨghzɨzir arɨmariar kam kamaghɨra ikɨva ekɨvan koghtɨ, zɨghzɨzir arɨmariar kam an mɨkarzir inim okoregha aven ghuzir puvatɨ, eghtɨ danganir kamɨn arɨziba aghevegh iangurighan koghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","kamaghɨn gumazim o amizim uan dapanir arɨziba o kuar arɨzibagh isegh, egh a duar muziariba itir danganim gisan markɨ. Eghtɨ ofa gamir gumazim, anetɨghtɨ a uabɨra ikɨ mangɨ 7plan dughiabar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Dughiar namba 7ɨn, ofa gamir gumazim, deraghvɨra gumazim o amizir kamɨn duar muziaribar ganigh, da kamaghɨra iti, o da ekefe. Egh ofa gamir gumazim kamaghɨn fogh suam, duar muziariba mɨkarzir inim okoregha aven ghuezir puvatɨ, a kamaghɨn gumazim o amizimɨn mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zue.’ Eghtɨ gumazim o amizir kam uan korotiaba ruegh, egh a zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Gumazim o amizim zueghamin dughiamɨn gɨn duar muziariba otivigh ekɨvtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ofa gamir gumazim ua deraghvɨra gumazim o amizir kamɨn inivafɨzimɨn gan. An duaba ekeveghtɨ, ofa gamir gumazim fogh suam, gumazim o amizir kam a zuezir puvatɨ. A ua arɨzir aghevir ianguriba bagh ruian kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Eghtɨ ofa gamir gumazimɨn damazimɨn, duar muziarir kaba kamaghɨra ikɨ, egh ekɨvan koghtɨ, arɨzir pɨzir aghuiba duar muziariba itir danganibar otivightɨ, ofa gamir gumazim fogh suam, zɨghzɨzir arɨmariar kam mɨsɨngasava ami. Egh a gumazim o amizim mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuegha gɨfa.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Egh gumazitam o amizitam, ghuarir ghurghurir dafoziba an mɨkarzir inimɨn otoghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ofa gamir gumazim deragh mɨkarzir nir ghurghurir kabar gan, da ghurghurigh taghtaghan koghtɨ a fogh suam, da ghuarir kɨniba mɨkarzimɨn otifi. Kamaghɨn, gumazir kam nan damazimɨn zue. ");
INSERT INTO msy2020_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Eghtɨ gumazimɨn dapanir arɨziba asighiregh, onarim mɨsegh, a Godɨn damazimɨn mɨzezir puvatɨ. A zue. ");
INSERT INTO msy2020_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Egh an mɨnedevimɨn itir arɨziba asighiregh, onarim mɨsegh, a Godɨn damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Eghtɨ ghuarim an dapanir gɨnkevimɨn itir onarim o mɨnedevimɨn itir onarimɨn otoghtɨ, duabar ganganim aghevegh ghurghurightɨ, ofa gamir gumazim fogh suam, ghuarir kam a lepan arɨmariar bar kuram. ");
INSERT INTO msy2020_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Egh ofa gamir gumazir kam deragh ghuarir kamɨn ganightɨ, ghuarir kamɨn duamɨn ganganim aghevegh ghurghurigh, mati gumazim lepan duar arɨmariam an mɨkarzimɨn inimɨn iti, ");
INSERT INTO msy2020_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","a kamaghɨn fogh suam, gumazir ghuarir an dapanimɨn itir kam, a lepan arɨmariar bar kuram. Kamaghɨn, ofa gamir gumazim kamaghɨn a mɨkɨm suam, ‘Nɨ Godɨn damazimɨn zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Eghtɨ gumazitam duar kurar kamagh garitam ikɨ, a korotiar bɨbɨzibar aghuigh, uan dapanir arɨzim batoghan kogh, egh dafarimɨn uan akam avaragh, egh pamten kamaghɨn dɨm mɨkɨm, ‘Kɨ zuezir puvatɨ. Kɨ zuezir puvatɨ.’ ");
INSERT INTO msy2020_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Gumazir arɨmariar kamagh garim ikɨvɨra ikɨva, nan damazimɨn zueghan kogham. A uan namakaba ategh danganir me itimɨn azenan uabɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","48","Ikiavɨra Itir God kamaghɨn Moses ko Aron mɨgei, “Dughiar mabar, bizir inibagh amima da ikuviba, kar lepan arɨmariamɨn mɨn inir kabar aven itiba. Da, korotiaba ko, nir avɨzir me sipsipɨn arɨzibar ingariziba ko, nir tretɨn aghuibar ingariziba ko, bulmakaun iniba ko, korotiar me asɨzibar inimɨn ingariziba, da dar otifi. ");
INSERT INTO msy2020_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Egh nir kam, arɨmariar kurar kam an aven ikɨtɨ, garim o aghevim an otoghtɨ, me nir kam inigh mangɨ ofa gamir gumazimɨn akagh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Eghtɨ ofa gamir gumazim a inigh deragh an ganigh, egh arɨmariar kurar kam itir bizir kam isɨ danganir igharazitam datɨghtɨ, a uabɨra ikɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","A namba 7ɨn aruemɨn deraghvɨra uam an gantɨ, arɨmariar kurar kam, a korotiam o inimɨn bar ekeveghtɨ, a fogh suam, kar lepan arɨmariam. Ezɨ korotiar kam o nir kam, a nan damazimɨn zuezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kamaghɨn amizɨ, ofa gamir gumazim korotiar kam avimɨn a tuaghtɨ, a bar isigh. Bizir kam lepan arɨmariamɨn mɨn a bato, eghtɨ a bar isi mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Eghtɨ ofa gamir gumazim deraghvɨra korotiar kamɨn gantɨ, a kamaghɨra ikɨtɨ, arɨmariar kuram korotiar kam bar a inighan kogham, ");
INSERT INTO msy2020_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","eghtɨ a me mɨkemeghtɨ me korotiar kam ruegh egh anetɨghtɨ, a ikɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Eghtɨ ofa gamir gumazim gɨn deraghvɨra uam arɨmariar bar kurar kamɨn gantɨ, a korotiamɨn avɨzir manamɨn aven, o azenan otoghtɨ, arɨmariar kurar kamɨn ganganim kamaghɨra gantɨ, an ganganim garim o aghevim ikɨvɨra ikɨtɨ, a fogh suam, a nan damazimɨn zuezir puvatɨ. Arɨmariar kurar kam ti ekeves, o puvatɨ, kar pura bizim, ofa gamir gumazim an ekɨvamin arazim gɨnɨghnɨghan kogham. A fogha gɨfa, a nan damazimɨn zuezir puvatɨ. Kamaghɨn, ofa gamir gumazim, korotiam avimɨn a tuaghtɨ a bar isi mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“Me a rueghtɨ, gɨn ofa gamir gumazim deraghvɨra uam an ganigh, bizir lepan arɨmariamɨn mɨn garim gɨvaghtɨ, a korotiar avɨzir kam abɨkigh o asɨzimɨn mɨkarzir nir kam, a ikuvizɨ naghɨra anetugh a makunigh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Eghtɨ gɨn, arɨmariar kurar kam, ua korotiar kamɨn otivtɨ, kamaghɨn korotiar kamɨn ghuavim avimɨn a tuaghtɨ, a isi bar mɨghɨrigh. ");
INSERT INTO msy2020_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Egh a korotiam o asɨzimɨn mɨkarzimɨn inim ruer dughiamɨn, lepan arɨmariamɨn mɨn itir puvatɨ, an ghuavim ua namba 2ɨn dughiamɨn a rueghtɨ, korotiar kam nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Arɨmariar bar kuramɨn mɨn itir bizir inibagh amima da ikuvim, Akar Gavgavir kam an gun mɨgei. Mati korotiaba ko, nir avɨzir me sipsipɨn arɨziba ko, nir tretɨn aghuibar ingariziba ko, bulmakaun iniba ko, korotiar me asɨzibar inibar ingariziba. Akar Gavgavir kam ghaze, korotiar kaba, da zue, o da nan damazimɨn zuezir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ikiavɨra Itir God, kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Gumazir manam lepan mɨn garir arɨmariar kuram an iti, kar Arazir Moses Osirizim. An arɨmariam gɨvaghamin dughiamɨn, a nan damazimɨn zueghsɨ, me a inigh ofa gamir gumazim bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Eghtɨ ofa gamir gumazim a inigh danganir me itimɨn azenan mangɨ, egh deragh an mɨkarzimɨn ganigh. Eghtɨ lepan mɨn garir arɨmariam guizbangɨra bar gɨvaghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ofa gamir gumazim me mɨkemeghtɨ, me nan damazimɨn kuarazir angamɨra ikia zuezir pumuning, ko sidan temer otevitam, ko benir aghevir tam, ko temer hisopɨn aguatam, da inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Eghtɨ ofa gamir gumazim me mɨkemeghtɨ, me nguazir mɨnetam inigh daghurir aghuitamɨn mangɨ dɨpar igiar dɨkɨriatam tuigh, a inigh izɨ. Egh me gɨn kuarazir kamningɨn tam inigh, mɨnem gisɨn an suiragh a mɨsueghtɨ, an ghuzim mɨnemɨn magɨrɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Eghtɨ ofa gamir gumazim kuarazir igharazim ko temer sidan otevir kam, ko benir aghevir kam, ko hisopɨn aguam isɨ ghuzim itir dɨpam darugh, zuamɨram anesigh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Egh gumazir kam nan damazimɨn zueghsɨ, me 7plan dughiabar dɨpar ghuzim itim a gisɨn a kavamang. Egh ofa gamir gumazim kamaghɨn a mɨkɨm, ‘Nɨ datɨrɨghɨn Godɨn damazimɨn zuegha gɨfa.’ Egh ofa gamir gumazim kuarazir angamɨra itim inigh, nguibamɨn azenan mangɨ, egh dadaba itir danganimɨn aneteghtɨ a mɨghegh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Gumazim zueghsɨ a uan korotiam ruva, dapanir arɨziba ko uan mɨkarzimɨn arɨziba bar dagh isegh uabɨ ruegh. A kamaghɨn damigh, nan damazimɨn zuegh, egh nguibamɨn aven mangɨ, egh 7plan aruebar a uan purirpenimɨn azenan ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Egh aruer namba 7ɨn, gumazir kam ua, uan dapanir arɨziba bar dagh isɨva, ghuamasɨziba ko sevanir arɨziba, ko namnamɨn arɨzir maba sara isegh, egh a uabɨ ruva uan korotiam sara ruegh, egh nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Egh namba 8ɨn dughiamɨn, a sipsipɨn apurir pumuning ko sipsipɨn amebar azenir vamɨra itim inigh. Da bar deragh egh duatam dar mɨkarzibar ikian kogham. Egh a wit tuamin ofan mɨn, a 3 kilogremɨn plauan aghuiba ko olivɨn borem sara da veregh da inigh. Egh olivɨn borer itarir pumuning gingegh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Egh a sipsipba ko plaua ko olivɨn borem inigh na bativamin Purirpenimɨn izɨ. Eghtɨ ofa gamir gumazitam an akuraghtɨ a zuegham. Ofa gamir gumazim, gumazir kam ko ofan kaba sara a inigh, na bativamin Purirpenimɨn tiar akamɨn izɨ, nan damazimɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Egh datɨrɨghɨn ofa gamir gumazim sipsipɨn apurir kamningɨn tam inigh olivɨn borem sara ofa damu, mati an osɨmtɨzim agevir ofa. A faragh bizir kaba dafarimɨn dar suiragh da fegh dar amutɨ da nan damazimɨn ighuavamangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ofa gamir gumazim sipsipɨn kam isɨ, ofan bar isia mɨghɨriba ko, arazir kuraba gɨn amadir ofaba bagha me bulmakaubav sozir danganimɨn mangɨ a mɨsueghtɨ an aremegh. Guizbangɨra, osɨmtɨzim agevir ofaba, da arazir kuraba gɨn amadir ofabar mɨrara ghu. Kar nan bizimra, ezɨ kɨ God, kɨ a isa ofa gamir gumazibagh anɨngi. Kamaghɨn amizɨ, ofa gamir gumazim kamaghɨn damuam. ");
INSERT INTO msy2020_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Egh gɨn ofa gamir gumazim sipsipɨn ghuzir taba inigh, gumazimɨn kuarir guvimɨn itir kuarir apebamɨn amɨrazim datɨgh, egh an agharir guvimɨn amadaghan itir dafarir puzir amebam ko gumazir kamɨn dagarir amebar agharir guvimɨn amadaghan itim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Egh ofa gamir gumazim olivɨn boremɨn taba inigh uan dafarir kɨriam gingegh, egh borer kam dafarimɨn an suiragh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Egh a uan agharir guvimɨn amadaghan itir dafarir puzir bizibar akakazim isɨ, uan dafarir kɨriamɨn itir borer kam darugh, egh 7plan dughiabar Ikiavɨra Itir Godɨn damazimɨn a kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Egh gɨn ofa gamir gumazim borer an dafarimɨn ikiavɨra itir taba inigh, gumazir zueghamimɨn kuarir guvimɨn itir kuarir apebamɨn amɨrazim datɨgh, egh uaghan olivɨn borem isɨ gumazir kamɨn agharir guvimɨn amadaghan itir dafarir puzir amebam ko gumazir kamɨn dagarir amebar agharir guvimɨn amadaghan itim datɨgh, danganir kaba, a faragha ghuziba dagh arɨki. ");
INSERT INTO msy2020_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Egh borer nar ofa gamir gumazimɨn dafarimɨn ikiavɨra itiba, gumazir kamɨn dapanim gingegh. Arazir kamɨn a gumazim damightɨ, a nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Egh ofa gamir gumazim ofan arazir kuraba gɨn amangamin asɨzimɨn ofa damutɨ, gumazim nan damazimɨn zuegham. Egh a gɨn, ofan bar isia mɨghɨrim damusɨ, asɨzim mɨsogham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Egh an asɨzir kam, wit tuer ofa sara, ofa gamir dakozimɨn ofa damu. Egh arazir kamɨn ofa gamir gumazim, gumazir kamɨn arazir kuraba gɨn amangɨsɨ ofa damutɨ, gumazim nan damazimɨn bar zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Eghtɨ gumazim uabɨ zueghsɨ bizir ofa damuamibagh ivezamin dagɨaba puvatɨgh, a sipsipɨn nguzir apurir vamɨrara inigh. Sipsipɨn kam a gumazimɨn osɨmtɨzim agevir ofa. Eghtɨ gɨn ofa gamir gumazim an suiragh a fegh a damutɨ a nan damazimɨn ighuavamangɨ. Gumazir kam, 1 kilogrem plauan aghuim uaghan a inigh, olivɨn borem sara a veregh wit tuer ofa damu. Egh a olivɨn borer aghuir itarir pumuning vɨraram aningɨn suiragh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","A dagɨaba otevegh sipsipbagh ivezan iburagh, a kuarazir bunbar pumuning inigh ofa damusɨ izɨ. Egh kuarazir tam arazir kuraba gɨn amadir ofa damuva, egh kuarazir igharazim, bar isia mɨghɨrir ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Namba 8ɨn aruemɨn, gumazir kam uabɨ zueghsɨ, bizir kaba bar ada inigh nan damazimɨn ofa gamir gumazim bagh na bativamin Purirpenimɨn tiar akamɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Eghtɨ ofa gamir gumazim osɨmtɨzim agevir ofa bagh sipsipɨn nguzir kam ko olivɨn borem inigh, dafarimɨn an suiragh a fegh a damutɨ a nan damazimɨn ighuavamangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Egh ofa gamir gumazim osɨmtɨzim agevir ofa bagh sipsipɨn nguzir kam mɨsuegh, egh ofan ghuzir taba inigh, gumazir uabɨ zusɨ damuamin gumazir kamɨn kuarir guvimɨn itir kuarir apebamɨn amɨrazim datɨgh, egh an agharir guvimɨn amadaghan itir dafarir puzir amebam ko gumazir kamɨn dagarir amebar agharir guvimɨn amadaghan itim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Egh ofa gamir gumazim olivɨn borer taba inigh uan dafarir kɨriam gingegh, egh borer kam dafarimɨn an suiragh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Egh a uan agharir guvimɨn amadaghan itir dafarir puzir akakazim isɨ, uan dafarir kɨriamɨn itir borer kam darugh, egh 7plan dughiabar Ikiavɨra Itir Godɨn damazimɨn a kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Egh gɨn ofa gamir gumazim borer an dafarimɨn ikiavɨra itir taba inigh, gumazir zueghamimɨn kuarir guvimɨn itir kuarir apebamɨn amɨrazim datɨgh, egh uaghan olivɨn borem isɨ gumazir kamɨn agharir guvimɨn amadaghan itir dafarir puzir amebam ko gumazir kamɨn dagarir amebar agharir guvimɨn amadaghan itim datɨgh, danganir kaba, a faragha ghuziba dagh arɨki. ");
INSERT INTO msy2020_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Egh borer nar ofa gamir gumazimɨn dafarimɨn ikiavɨra itiba, gumazir kamɨn dapanim gingegh. Egh arazir kamɨn a gumazim damightɨ, a nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Egh ofa gamir gumazim, gumazir kam kuarazir bunbar ofa damuasa inigha izezimning, an aning inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","A kuarazir tam, arazir kuraba gɨn amadir ofa damu, egh igharazim an ofan bar isia mɨghɨrim damu. Egh a uaghan wit tuer ofa ko kuarazir bunbar kamning sara ofa damu. Arazir kamɨn ofa gamir gumazim, gumazir nan damazimɨn zueghamin kamɨn arazir kuraba gɨn amangɨsɨ ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Arazir kam, gumazir uan lepan mɨn garir arɨmariam agɨvsɨ, egh dagɨaba otevegh, ofan asɨzibagh ivezan iburagham, an arazir kamɨn gɨn mangɨva, nan damazimɨn zuegham.” ");
INSERT INTO msy2020_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ikiavɨra Itir God, kamaghɨn Moses ko Aron mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ia gɨn Kenanɨn nguazimɨn mangegh an ikiam, nguazir kɨ ia danɨngamin kam, a ian nguazimra ikiam. Egh dughiar ia Kenanɨn ikiamim, kɨ ti lepan mɨn garir arɨmariar kuram damightɨ, a dɨpenir tabar amutɨ da ikuvigham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Eghtɨ dɨpenir ghuavim mangɨ ofa gamir gumazim kamaghɨn a mɨkɨmam, ‘Kɨ asɨghasɨzir mam arɨmariar kuramɨn mɨn an gari an nan dɨpenimɨn otogha nan dɨpenim gasɨghasɨsi.’ ");
INSERT INTO msy2020_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Eghtɨ ofa gamir gumazim kamaghɨn oreghɨva, gumazim mɨkɨmtɨ, a dɨpenimɨn aven itir biziba bar da ater azenan mangam. Eghtɨ gumazim kamaghɨn damighan koghtɨ, ofa gamir gumazim izɨ kamaghɨn a mɨkɨmam, ‘Bizir dɨpenimɨn aven ikiavɨra itir kaba bar Godɨn damazimɨn ikuvigha mɨze, ezɨ a dar anogoroke.’ Eghtɨ gumazim biziba bar da inigh azenan mangɨtɨ, ofa gamir gumazim aven mangɨ dɨpenimɨn ganam. ");
INSERT INTO msy2020_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","A bar deraghvɨra bizir dɨpenimɨn bɨribagh ami da ikuvimɨn ganam. Egh a gantɨma, bizir gariba ko agheviba torir muziariba bɨribar arɨghtɨ a suam, bizir kam bar bɨribar aven ghu, ");
INSERT INTO msy2020_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","egh ofa gamir gumazim azenan mangɨgh kamaghɨn mɨkɨm suam, ‘Dɨpenir kam, a 7plan dughiabar pura ikiam.’ ");
INSERT INTO msy2020_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Egh dughiar namba 7ɨn, ofa gamir gumazim ua izɨ dɨpenim getiv an ganam. Eghtɨ asɨghasɨzir kam bɨrimɨn otogh bar ekeveghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ofa gamir gumazim me mɨkemeghtɨ, me bizir kurar kam itir dagɨaba asigh, egh nguibamɨn azenan mangɨ danganir me ghua bizir mɨzɨrɨzir nan damazimɨn zuezir puvatɨziba makuri naghɨn, da makunigh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Me dar amigh gɨvagh, nguazir mɨsɨngizir dagɨar dɨpenimɨn aven bɨriba bar da avarazim angarigh. Egh da inigh nguibamɨn azenan mangɨ, danganir bizir kuraba akurir naghɨra da kunigh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Egh me dagɨar igiaba inigh dagɨar kabar danganibar arɨgh, ua bɨrir kabar ingarigh. Egh nguazir kumkuar igiam inigh dɨpenimɨn bɨriba ua dar aghu da avegh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Eghtɨ me ingangarir kam damightɨ, an gɨn asɨghasɨzir kam ua bɨrimɨn otoghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ofa gamir gumazim ua dɨpenimɨn mangɨ, egh deraghvɨra a getiv an ganigh. Asɨghasɨzir kam otogh bar ekevegh dɨpenim damightɨ a ikuvigh, egh dɨpenir kam a nan damazimɨn mɨzegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Kamaghɨn amizɨ, me dɨpenir kam apɨrigh dagɨaba ko temeba bar ada angarigh. Egh me da inigh nguibamɨn azenan mangɨ, danganir me nan damazimɨn zuezir puvatɨzir biziba makuri naghɨn da makunigh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Egh dɨpenir mɨzezir kam, gumazitam an aven mangɨ, a nan damazimɨn mɨzeghɨva kamaghɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Eghtɨ gumazitam dɨpenir kamɨn aven damɨ, o an aven dakuam, kamaghɨn a uan korotiaba ruegh. ");
INSERT INTO msy2020_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Eghtɨ ofa gamir gumazim ua izɨ dɨpenimɨn gantɨ, an bɨriba deragham, eghtɨ asɨghasɨzir kam uam a batoghan koghtɨ, a kamaghɨn me mɨkɨmam, ‘Dɨpenir kam a Godɨn damazimɨn zue.’ A fo, bizir lepan arɨmariar kuramɨn mɨn garir dɨpenibagh asɨghasɨzir kam, a ua itir puvatɨ. Asɨghasɨzir kam, a gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Arazir dɨpenim gamima a ua nan damazimɨn zuezim, a kamakɨn. Ofa gamir gumazim me mɨkemeghtɨ, me nan damazimɨn kuarazir angamɨra ikia zuezir pumuning, ko sidan temer otevir tam, ko benir aghevir tam, ko temer hisopɨn aguatam, inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Eghtɨ ofa gamir gumazim me mɨkemeghtɨ, me nguazir mɨnetam inigh daghurir aghuitamɨn mangɨ dɨpar igiar dɨkɨriam tuigh, a inigh izɨ. Egh gɨn ofa gamir gumazim kuarazir kamningɨn tam inigh, mɨnem gisɨn an suiragh a mɨsueghtɨ an ghuzim mɨnemɨn magɨrɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Eghtɨ ofa gamir gumazim kuarazir angamɨra itir igharazim ko temer sidan otevir kam, ko benir aghevir kam, ko hisopɨn aguam da isɨ ghuzim itir dɨpam darugh, egh zuamɨra da asigh. Egh gɨn 7plan dughiabar dɨpar ghuzim itim dɨpenimɨn a kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ofa gamir gumazim kamaghɨn damutɨ dɨpenim nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Egh ofa gamir gumazim kuarazir angamɨra itim inigh, nguibamɨn azenan mangɨ, egh dadaba itir danganimɨn aneteghtɨ a mɨghegh mangɨ. Kar dɨpenimɨn mɨzɨrɨziba agevir arazim, eghtɨ dɨpenim nan damazimɨn ua zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","56","“Arazir kaba, da gumazamizir arɨmariar kuraba itiba ko gumazamizir duar muziariba itiba ko, okaba ko duar mɨkarzimɨn otiviba, ko asɨghasɨzir korotiaba ko dɨpenibagh amima da nan damazimɨn mɨzeziba, da bizir mɨzɨrɨzir kabanangɨn ia mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Akar Gavgavir kaba, da ian akaghtɨ ia fogh suam, bizir manaba nan damazimɨn zue, ezɨ bizir manaba zuezir puvatɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ikiavɨra Itir God kamaghɨn Moses ko Aron mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Nɨ Israelian gumazamiziba kamaghɨn me mɨkɨm suam: “Gumazitam, an mɨkarzir mogomem duam a batoghtɨ ghuzir mɨtɨzim an azenan otivtɨ, egh ghuzir mɨtɨzir kam a damutɨ, a nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Egh duamɨn ghuzir mɨtɨzir kam, an mɨkarzir mogomemɨn akamɨn otivam, o bizir kam gavgavigh dɨpam ivemarir tuavim apɨrightɨ, gumazir kam nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Eghtɨ danganir an apiaghiriba o akuiba, da bar mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","Tina gumazir kamɨn mɨsiamɨn suiragham, o an apiaghiri bizitam daperagh, kamaghɨn a uan korotiaba ru, egh dɨpamɨn uabɨ ruegh, egh nan damazimɨn mɨzegh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Eghtɨ gumazir manam o amizim uan dafarim isɨ gumazir duar kam itimɨn mɨkarzimɨn suiragh, a uan korotiaba ru egh uabɨ ruegh, egh mɨzegh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Eghtɨ gumazir duar kam itim, a gumazir nan damazimɨn zuezim giparightɨ, gumazir kam uaghan mɨzegh, uan korotiam ru, egh uabɨ ruegh mɨzegh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Eghtɨ gumazir duar kam itim, an hoziam gisɨn itir dabirabim daperagham, eghtɨ bizir kam uaghan mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Eghtɨ gumazitam uan dafarimɨn gumazir kam aperazir dabirabimɨn suiragham, a uaghan mɨzegh, ikɨ mangɨtɨ aruem magɨrɨgham. Eghtɨ gumazitam gumazir bizir an gaperaghav ikezim inigh aneter mangam, a uaghan uan korotiam ru egh uabɨ ruegh, egh a mɨzegh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Eghtɨ gumazir duar kam itim faragh uan dafariba rueghan kogh, egh gumazir igharazimɨn suiraghtɨ, gumazir igharazir kam uan korotiam ruegh egh dɨpamɨn bar uabɨ ruegh, egh a mɨzeghɨva ikɨvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Eghtɨ gumazir duar kam itim, nguazir mɨner tamɨn suiraghtɨ, kamaghɨn, me mɨner kam abɨkigh. Egh a uan dafarimɨn temer itarimɨn suiraghtɨ, kamaghɨn, me itarir kam deragh dɨpamɨn a ruegh. ");
INSERT INTO msy2020_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Eghtɨ gumazir kamɨn duar mɨtɨzir dɨpaba itim gɨvaghtɨ, a 7plan dughiabar ikegh zuegham. Egh a mangɨ uan korotiam ruegh, egh dɨpar aghuim guruegh, egh nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Eghtɨ namba 8ɨn dughiam otoghtɨ, a kuarazir bunbar pumuning inigh mangɨ God bativamin Purirpenimɨn tiar akamɨn Ikiavɨra Itir Godɨn damazimɨn tughɨva, kuarazir bunbar pumuning isɨ ofa gamir gumazim danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Eghtɨ ofa gamir gumazim, kuarazir kamningɨn tam isɨ arazir kuraba gɨn amadir ofa damu, egh kuarazir igharazim isɨ ofan bar isia mɨghɨrim damu. Arazir kamɨn, a gumazir kamɨn akuraghtɨ, an mɨzɨrɨzim gɨvaghtɨ, gumazim ua Ikiavɨra Itir Godɨn damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Eghtɨ gumazitam, dɨpam puram an mɨkarzir mogomemɨn otivtɨ, a mɨzegham, a uan mɨkarzim bar dɨpamɨn a ruegh, egh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Eghtɨ dɨpar kam an korotiam o inim o asɨzibar inibar ingarizir bizitam gireghtɨ, a dɨpamɨn a ruegh, eghtɨ bizir kam mɨzegh ikɨvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Gumazim amizim ko dakuigh, egh aning mɨzegham. Aning uaning ko akuigha gɨvazir dughiamɨn, aning mangɨ dɨpamɨn ruegh, egh aning mɨzɨrɨzim sara mɨzeghvɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Amizim uan iakɨnibav sozir dughiamɨn, a mɨzɨrɨzim sara ikɨ mangɨtɨ 7plan arueba gevegham. Eghtɨ gumazitam o amizitam an suiragh, a mɨzɨrɨzim sara kamaghɨra ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Eghtɨ dakozir an akuim ko an apiaghirir biziba, da bar mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","Gumazitam o amizitam dafarim isɨ an dakozim o bizir an apiav ikezibar suiragh, a mɨzegham. Egh a uan korotiam ruegh egh dɨpamɨn bar uabɨ ruegh, egh a mɨzegh ikɨ mangɨtɨ aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Eghtɨ gumazitam, amizir uan iakɨnibav sozir dughiamɨn a ko dakutɨ, amizir kamɨn mɨzɨrɨziba an ikɨ mangɨ 7plan dughiabar tugham. Eghtɨ dakozir manam gumazim a dakuam, a uaghan mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Amizitam uan iakɨnibav sozir dughiam batozir puvatɨgha pura dughiar igharazir mabar ghuzim bati, o an iakɨnibav sozir dughiam ikiavɨra itima a ghuzim bata dughiar ruarimɨn ghuavɨra iti, kamaghɨn a mɨzɨrɨzim sara ikɨ mangɨtɨ, ghuzim bar gɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Egh a dughiar kamɨn dakozir manam gakui, o dabirabir manam gaperaghav ike, bizir kaba uaghan mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Eghtɨ gumazitam o amizitam bizir an apiav kezitamɨn suiragham, a uaghan mɨzegham. A uan korotiaba ruegh, egh dɨpamɨn bar uabɨ ruegh. Egh a mɨzɨrɨzim sara ikɨ mangɨtɨ, aruem magɨrɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Amizimɨn ghuzim gɨvaghtɨ, a 7plan dughiabar ikegh nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Eghtɨ namba 8ɨn dughiam otoghtɨ, a kuarazir bunbar pumuning inigh izɨ, egh mangɨ na bativamin Purirpenimɨn tiar akamɨn ofa gamir gumazim danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Eghtɨ ofa gamir gumazim, kuarazir kamningɨn tam isɨ arazir kuraba gɨn amadir ofa damu, egh kuarazir igharazim isɨ ofan bar isia mɨghɨrim damu. Eghtɨ arazir kamɨn, an amizir kamɨn akuraghtɨ, an mɨzɨrɨzim gɨvaghtɨ, a ua Ikiavɨra Itir Godɨn damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Gua kamaghɨra, Akar Gavgavir kamra Israelia danɨngigh. Me nan damazimɨn mɨzegha itir dughiamɨn, me uari bagh deraghvɨra gan. Me uan mɨzɨrɨziba bar dar saghon ikɨ. Nan Purirpenim men tongɨn iti, eghtɨ me mɨzɨrɨziba sara ikɨva, an aven mangan markɨ. Puvatɨghtɨ me nan Purirpenim damutɨ a mɨzegham. Me kamaghɨn damutɨ, kɨ me mɨsueghtɨ me arɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Akar Gavgavir kaba, gumazim o amizimɨn mɨkarzim duaba a batifi, ezɨ gumazim amizim ko akuima an dɨpam an mɨkarzim gire, bizir kam aning gamima aning nan damazimɨn mɨze, kar an Akar Gavgaviba. ");
INSERT INTO msy2020_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Egha Akar Gavgavir kaba, amizibar iakɨnir arɨmariam mɨgei. Egha a gumazitam ko amizitam ghuzir mɨtɨzim men mɨkarzir mogomem bato, Akar Gavgavir kam me mɨgei. Egha uaghan gumazir amizir mɨzɨrɨzim sara itim koma akuim mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aronɨn otarir pumuning faragha, Ikiavɨra Itir Godɨn akam batuegha, a bagh ofa damuasa an boroghɨn zui. Ezɨ an aning mɨsoghezɨ aning aremegha gɨfa, ezɨ gɨn Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","“Nɨ uan avebam Aron mɨkemegh. A zurara nan purirpenimɨn aven nir ekiamɨn akɨrangɨn Danganir Bar Anogoroghezimɨn pura mangɨva, Akar Dɨkɨrɨzir Gavgavimɨn Boksiar asuamɨn guamɨn tuivan markɨ. Kɨ ghuariar mamɨn tongɨn ikɨ, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn asuam gisɨn ikiam, kar arazir kuraba gɨn amadir danganim. Kamaghɨn amizɨ, kɨ uabɨ dughiam atɨghtɨ, an an aven mangɨ. A pura danganir kamɨn aven mangɨghtɨ, kɨ a mɨsueghtɨ an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aron Danganir Bar Anogoroghezimɨn aven mangɨsɨ, a faragh arazir kuraba gɨn amadir ofa bagh bulmakaun apurir igiatam inigh, egh ofan bar isia mɨghɨrim bagh sipsipɨn apuritam inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","“Aron faragh deraghvɨra dɨpamɨn uabɨ ruegh, egh gɨn korotiar kabar aghu, kar korotiar kɨ uabɨ ofa gamir gumaziba bagha mɨseveziba, ezɨ da bar zue. Korotiar kaba bar, me deraghavɨra nir ghurghurir aghuimɨn dar ingari. Aron ruegh gɨvagh, egh ofa gamir gumazimɨn korotiar ruarir azenan itim arugh, egh an aven azuir trausiziar otevim arugh. Egh inir ruarim isɨ uan ivariam gikegh, egh inir dapanir asuar ruarim uan dapanim gighuigh a ikegh. ");
INSERT INTO msy2020_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Eghtɨ Israelian gumazamiziba ofan arazir kuraba gɨn amadir ofa bagh, memen apurir pumuning inigh, egh ofan bar isia mɨghɨrim bagh sipsipɨn apurir vamɨra inigh izɨ Aron danightɨ, a da iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Egh Aron uabɨ inizir bulmakaun apurir kamɨn ofa damu, egh uan arazir kuraba ko an adarazir arazir kuraba gɨn amang. ");
INSERT INTO msy2020_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“Egh a gɨn memen apurir kamning inigh mangɨ Ikiavɨra Itir God bativamin Purirpenimɨn tiar akamɨn izɨ nan damazimɨn tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Egh a dagɨar pumuning inigh, mamɨn osizirim kamaghɨn mɨgei, ‘Kar Ikiavɨra Itir Godɨn ofa’ ezɨ igharazimɨn osizirim kamaghɨn mɨgei, ‘Kar Asaselɨn ofa.’ Egh a dagɨar pumuning modogh, egh vaghvagh aningɨn akakagham, Ikiavɨra Itir God bagh memen tam amɨsevegh, egh tam asem Asasel bagh anemɨsefegh. ");
INSERT INTO msy2020_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Egh Aron memen Ikiavɨra Itir God bagha mɨsevezir kam inigh, egh ofan mɨn gumazamizibar arazir kuraba gɨn amadir ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Egh an asem Asasel bagha inabazir memen kam mɨsoghan markɨ. Aron a inigh nan damazimɨn izɨ. Egh a memen kam, asem Asasel bagh gumazamiziba puvatɨzir danganimɨn anemadagh. Eghtɨ memen kam gumazamizibar arazir kuraba ater mangam. ");
INSERT INTO msy2020_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aron ofan kabagh amua arazir kuraba gɨn amadir dughiamɨn, an arazir kamɨn gɨn mangɨ. A faragh bulmakaun kam inigh egh an aku izɨ, a mɨsuegh uan arazir kuraba ko an adarazir arazir kuraba gɨn amadir ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","13","Egh a gɨn mɨnetam inigh, Ikiavɨra Itir Godɨn damazimɨn itir ofa gamir dakozimɨn mangɨ, egh avir mɨkɨar isia itiba mɨnem daghuigh, da inigh inir ekiamɨn gɨrakɨrangɨn itir Danganir Bar Anogoroghezimɨn mangɨ. Egh a Ikiavɨra Itir Godɨn damazimɨn dafarir pumuning pauran mughuriar aghuim zuim a daghuigh, a isɨ avir kam datɨghtɨ, pauran kamɨn mɨgharim, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn asuam avaragham, kar arazir kuraba gɨn amadir danganim. Mɨgharir gavgavir kam ikɨtɨ, kamaghɨn Aron uabɨ, arazir kuraba gɨn amadir danganimɨn ganan kogham. An an ganightɨ, kɨ a mɨsueghtɨ an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Egh a bulmakaun apurimɨn ghuzitaba inigh, uan dafarir puzim a darugh Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn pɨn arazir kuraba gɨn amadir danganimɨn guamɨn a kavamang. Egh 7plan dughiabar kamaghɨra ua ghuzir taba uan dafarir puzimɨn da inigh, Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn guamɨn da kavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Egh gɨn a gumazamizibar arazir kuraba gɨn amadir ofa bagh memen kam mɨsuegham. Egh a memen ghuziba inigh, purirpenimɨn aven inir ekiamɨn gɨrakɨrangɨn Bar Anogoroghezir Danganimɨn mangɨ, egh ghuzir muziarir taba Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn asuamɨn pɨn itir arazir kuraba gɨn amangamin danganim, a gisɨn da kavamangam. Egh taba isɨ Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn guamɨn da kavamang, mati a faragha bulmakaun ghuzibagh amizɨ mokɨn. ");
INSERT INTO msy2020_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Egh arazir kamɨn a Bar Anogoroghezir Danganim damightɨ, a nan damazimɨn zuegham. Guizbangɨra, Israelian gumazamiziba arazir mɨzɨrɨzibagh amua nan akaba batuegha, arazir kurar avɨribagh ami, ezɨ arazir kam Bar Anogoroghezir Danganim gamima, a mɨze. Na bativamin Purirpenim men tongɨn iti, ezɨ men arazir kurar kaba da Purirpenimɨn bizibagh amima, da bar nan damazimɨn mɨze. Kamaghɨn amizɨ, Aron ghuzitaba inigh, na bativamin Purirpenimɨn danganir igharazibar kamaghɨra dar amigh. Mati a faragha Bar Anogoroghezir Danganim gamizɨ mokɨn. Arazir kamra, a Purirpenim damutɨ a ua zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aron ofan kam damuva, uan arazir kuraba ko an adarazi ko Israelian gumazamiziba sara bar da gɨn amadagham. A Bar Anogoroghezir Danganimɨn aven mangɨtɨ, gumazir igharazitam na bativamin Purirpenimɨn aven mangan kogham, egh kamaghɨra ikɨ mangɨtɨ Aron uam azenan izegham. Kɨ bar men anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","19","Egh gɨn Aron Bar Anogoroghezir Danganim ategh azenan mangɨ, egh ofan bar isia mɨghɨrir ofa gamir dakozimɨn mangɨ. Israelian arazir kuraba ofa gamir dakozir kam gamima, a nan damazimɨn mɨze. Kamaghɨn amizɨ, Aron ofa gamir dakozir kam damightɨ a zueghsɨ, a bulmakaun kam ko meme vɨrara, aningɨn ghuzir muziarir taba inigh, egh ofa gamir dakozimɨn mɨkebabar itir bulmakaun kombar mɨn garir biziba bar dar arɨkigh. Egh dafarir puzim ghuzim darugh 7plan dughiabar ofa gamir dakozimɨn a kavamang. Arazir kamɨn a ofa gamir dakozim damightɨ a zuegham. Egh a ofa gamir dakozim ateghtɨ, a nan ingangarim baghvɨra ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Aron Bar Anogoroghezir Danganim ko na bativamin Purirpenim ko ofa gamir dakozim damutɨ, da zueghamin ingangarir kam agɨvagh, egh a memen asem Asasel bagha mɨsevezir kam inigh, Ikiavɨra Itir God bagh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Eghtɨ memen angamɨra itim, a uan dafarimning isɨ an dapanim gisɨn datɨgh, egh Israelian gumazamizibar arazir mɨzɨrɨziba, ko akam batozir araziba ko men arazir kurar avɨriba bar dar gun mɨkemegh. Egh arazir kamɨn an arazir kuraba isa memen dapanim gatɨ. Egh gɨn a meme isɨ gumazir a mɨsevezimɨn dafarim datɨghtɨ, gumazir kam meme inigh gumazamiziba puvatɨzir danganimɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Egh danganir kamɨn aneteghtɨ, memen kam Israelian arazir kurabar osɨmtɨzim inigh da aterɨva gumazamiziba puvatɨzir danganimɨn mangɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Eghtɨ ingangarir kam gɨvaghtɨ, Aron na bativamin Purirpenimɨn aven mangɨgh, ofa gamir gumazimɨn korotiar an arugha Bar Anogoroghezir Danganimɨn aven ghuzim suegh. Egh a korotiar kam ateghtɨ, a Purirpenimɨn aven ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Egh a mangɨ Purirpenimɨn dɨvazimɨn aven dɨpamɨn bar uabɨ ruegh, egh ua uan ofa gamir gumazimɨn korotiar igharazibar aghuigh. A gɨn azenan izegh, ofan bar isia mɨghɨrir pumuning damigh, a ua bagh ofan tam damigh, egh ofan igharazim gumazamiziba bagh a damigh. Ofan kamningɨn, a uan arazir kuraba ko gumazamizibar arazir kuaba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Egh a men arazir kuraba gɨn amangɨsɨ ofa gamizir asɨzimɨn ovim isɨ ofa gamir dakozimɨn a tuaghtɨ, avim bar an isi mangɨtɨ, a bar mɨghɨrightɨ, averenir kɨnim otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Eghtɨ gumazir faragha meme inigha gumazamiziba puvatɨzir danganimɨn ghugha anetaghizɨ a ghuzɨm, a faragh uan korotiaba ruva, dɨpamɨn uan mɨkarzim sara ruegh, egh gɨn, a ua danganir me itimɨn aven izam. ");
INSERT INTO msy2020_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Me bulmakaun apurim, ko memen ofan arazir kuraba gɨn amadim, ofa gamir gumazim faragha aningɨn ghuziba inigha, uan arazir kuraba ko gumazamizibar arazir kuraba sara gɨn amangasa, Bar Anogoroghezir Danganimɨn aven ghu. Egh gɨn me asɨzir kamningɨn kuamning inigh nguibamɨn azenan mangam. Egh me aningɨn iniba ko tuziba ko buariba tueghtɨ, avim aning bar isi mɨghɨrigh mangɨtɨ, averenir kɨnim otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Egh gɨn gumazir aning tuazir kam, uan korotiaba ruegh, egh dɨpamɨn uan mɨkarzim bar a rueghɨva, a gɨn, ua danganir me itimɨn aven izam.” ");
INSERT INTO msy2020_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia Akar Gavgavir kam zurara an gɨn mangɨ. Iakɨnir namba 7, an dughiar namba 10ɨn, ia Israelia ko ikɨzir igharazibar gumazamizir ian tongɨn itiba bar, ia dagheba ko agoroger araziba atakigh, egh ia ingangariba ategh avughsɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Arazir kamɨn mɨngarim kamakɨn: Dughiar kamra, ofa gamir gumazim ofa damuva ian arazir kuraba gɨn amangam, eghtɨ ia Ikiavɨra Itir Godɨn damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Dughiar kam, kar nan dughiar ekiamra. Eghtɨ ia agoroger araziba dughiar kamɨn da ategh avughsɨ. Ia ingaran markɨ. Bar markɨ. Egh ia zurara arazir kamɨn gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ofa gamir gumazir manam ia anemɨsefe, eghtɨ an afeziamɨn danganim inigh ofa gamir gumazibar dapanimɨn otogh, egh a uabɨra gumazamizibar arazir kuraba gɨn amangamin ingangarir kam damuam. A faragh ofa gamir gumazimɨn korotiar ghurghurir aghuim arugh. ");
INSERT INTO msy2020_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Egh gɨn arazir kuraba gɨn amangɨsɨ ofa damu, eghtɨ Bar Anogoroghezir Danganim ko, God bativamin Purirpenim ko, ofa gamir dakozim ko, ofa gamir gumaziba ko, Israelian gumazamiziba bar, me nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Me arazir kaba zurara dar gɨn mangɨvɨra ikɨ. Ofa gamir gumazibar dapanim, ofan kaba azeniba vaghvagh dar amu, Israelian gumazamizibar arazir kuraba gɨn amang, egh me damutɨ me nan damazimɨn zuegham.” Ikiavɨra Itir God akar kaba Moses ganɨngi, ezɨ Moses bar adar gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","2","Ikiavɨra Itir God, akam Aron ko an otariba ko Israelian gumazamizibav kɨmasa akam Moses mɨkeme. Ikiavɨra Itir God kamaghɨn mɨgei: “Kɨ Akar Gavgavir kaba ia ganɨdi. ");
INSERT INTO msy2020_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ia Israelian gumazamiziba ofa damusɨ ifuegh, bulmakaun tam, o sipsip, o memen tam danganir ia itimɨn aven o azenan a mɨsuegh, ");
INSERT INTO msy2020_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","egh a inigh Ikiavɨra Itir God bativamin Purirpenimɨn tiar akamɨn izɨ ofan mɨn na danɨngan aghuagh, ia mati gumazim gumazir igharazim mɨsoghezɨ an areme, egh ia nan damazimɨn osɨmtɨzim ikiam. Kamaghɨn amizɨ, kɨ uan gumazamizibar tongɨn ia batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Akar kamɨn mɨngarim kamakɨn: Ia Israelia fomɨra asɨzibav sogha danganir ia itimɨn azenan ofa gami, ezɨ datɨrɨghɨn ia asɨziba inigh ofa gamir gumaziba bagh mangɨ, na bativamin Purirpenimɨn tiar akamɨn ofa damu, egh na ko navir vamɨran ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Eghtɨ ofa gamir gumazim asɨzimɨn ghuziba inigh, ofa gamir dakozir God bativamin Purirpenimɨn tiar akamɨn boroghɨn itim, an mɨriabar da kavamang. Egh an ofa bagh asɨzir ovim ofa gamir dakozimɨn a tuaghtɨ a bar mɨghɨrightɨ, averenir kɨnim otogh. Eghtɨ Ikiavɨra Itir God, ofan tuer kamɨn mughuriam baregh, egh a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ia Israelia uam aseba bagh asɨzibar ofabar amuan markɨ. Ia faragha kamaghɨn amua, na tegha asebar gɨn ghue. Eghtɨ ian gɨn otivamin adarazi zurara asɨziba inigh ofa bagh nan Purirpenimɨn izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","9","“Egh nɨ kamaghɨn me mɨkɨm, Israelian gumazitam o ikɨzir igharazibar gumazir ian tongɨn ititam, a ofan bar isia mɨghɨribar amusɨ, o a ofan igharazim na bagh a damusɨ, kamaghɨn an asɨzim inigh izɨ na bativamin Purirpenimɨn tiar akamɨn ofa damu. Puvatɨghtɨma, kɨ Ikiavɨra Itir God, kɨ uan gumazamizibar tongɨn a batuegham.” ");
INSERT INTO msy2020_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Ia asɨzim mɨsoghezɨ an aremezir dughiamɨn, ia an fɨrim atugh, egh aneguraghtɨ an ghuzim bar iregh. Eghtɨ ia Israelian gumazitam o ikɨzir igharazibar gumazir ian tongɨn iti tam, ghuzim itir asɨzitam ameghtɨ, kɨ Ikiavɨra Itir God, kɨ an apanim damigh, egh uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ghuzim an angamɨra itir ikɨrɨmɨrim gumaziba ko asɨziba bar me ganɨdi. Ezɨ kɨ kamaghɨn ia mɨgei, ofa gamir gumazim ghuzim isɨ ofa gamir dakozimɨn ofan mɨn a gingegh, gumazamizibar arazir kuraba gɨn amangam. Ghuzim an angamɨra itir ikɨrɨmɨrimɨn mɨngarim. Ghuzimra gumazamizibar arazir kuraba gɨn amadi. ");
INSERT INTO msy2020_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ezɨ kɨ Israelia ia mɨgei, ian tav o ikɨzir igharazibar gumazir ian tongɨn ititam, asɨzir ghuzim itim aman markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Eghtɨ Israelian tav o ikɨzir igharazibar gumazir ian tongɨn ititam, an asɨziba buriva, kɨ damasa ian anogoroghezir puvatɨzir memen atiatam, o kuarazir tam mɨsuegh, egh an ghuzim nguazim gingegh anevaragh. ");
INSERT INTO msy2020_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kamaghɨn ami, gumazamiziba ko asɨzibar angamɨra itir ikɨrɨmɨrim, a ghuzimɨn aven iti. Ezɨ bizir kam bagha kɨ Israelia ia mɨgɨa ghaze, ia asɨzir ghuziba itibar aman markɨ. Eghtɨ gumazim ghuzim itir asɨzim ameghtɨ, kɨ uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Kamaghɨn amizɨ, asɨzitam puram areme, o asɨzir atiam asɨzir tam mɨsoghezɨ an areme, eghtɨ gɨn Israelian gumazitam o ian amizitam o ikɨzir igharazimɨn gumazir ian tongɨn ititam, asɨzir kamɨn tuzim amegham, a nan damazimɨn mɨzegham. Kamaghɨn amizɨ, a uan korotiaba ruva, egh uaghan dɨpamɨn uabɨ ruegh. Egh a mɨzɨrɨziba sara ikɨ mangɨtɨ aruem magɨrɨghtɨ, a ua zuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Egh a uan korotiaba ruva mɨkarzim rueghan kogh, mar an osɨmtɨzim, a mar uan arazir kuramɨn osɨmtɨzim ater.” ");
INSERT INTO msy2020_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","2","Ikiavɨra Itir God, uan akam isɨ Israelia danɨngasa kamaghɨn Moses mɨgei, “Kɨ Ikiavɨra Itir God, ian God. ");
INSERT INTO msy2020_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Guizbangɨra, ia kantri Isipɨn ike, egh ia Isipian arazibar gɨn mangan markɨ. Kɨ datɨrɨghɨn ia inigh Kenanɨn nguazimɨn mangam, eghtɨ ia Kenanian araziba, ia dar amuan markɨ. Ia men arazibar gɨn mangan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ia oragh. Ia arazir kɨ ifongezibar gɨn mangɨ, egh bizir kɨ damuasa ia mɨkemezibar amu. Kɨ Ikiavɨra Itir God, ian God, kɨ akar kamɨn ia mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ia bizir kɨ damuasa ia mɨkemeziba ko arazir kɨ ifongezibar gɨn mangɨ. Gumazamiziba Moses Osirizir Araziba mɨgei moghɨn damu egh dughiaba zurara dar amutɨ, arazir kaba me damutɨ, me ikɨvɨra ikiam. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨgei, nɨ uan ikɨzimɨn amizitam bagh navim dɨkav a ko ikararangan markɨ, egh a ko dakuan markɨ. Arazir kam bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nɨ bar uan amebam ko dakuan markɨ. Nɨ kamaghɨn damu, nɨ aghumsɨzim bar uan afeziam danigham. Nɨ uan amebam ko dakuan bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Nɨ uan afeziamɨn amuir dozim ko dakuan markiam. Nɨ kamaghɨn damigham, nɨ uan afeziam damutɨ, a bar aghumsigham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Nɨ uan buaramizim ko dakuan markɨ, a nɨn afeziam ko amuir igharazim otezir guivim, o a nɨn amebam ko par igharazim otezir guivim, nɨ a ko dakuan markɨ. Kar nɨn amebam nɨn afeziamɨn dɨpenimɨn ikia otezir guivim, o nɨn amebam dɨpenir igharazimɨn ikia otezir guivim, a uaghan nɨn buaramizim, kamaghɨn amizɨ nɨ a ko dakuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Nɨ uan otarimɨn guivim, o nɨn guivimɨn guivim ko dakuan markɨ. Arazir kam nɨ damutɨ nɨ bar aghumsigham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nɨ uan afeziamɨn amuir igharazimɨn guivim ko dakuan markɨ, kar nɨn afeziamɨn borim, a uaghan nɨn buaramizim. Nɨ an ikian bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Nɨn afeziam ko an buaramizim, aning ghuzir vamɨra. Kamaghɨn amizɨ, nɨ a ko dakuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Nɨn amebamɨn afumim o an avenemebam, kar nɨn amebamɨn ghuzimra. Kamaghɨn amizɨ, nɨ a ko dakuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Nɨn afeziamɨn aveghbuamɨn amuim, a nɨn amebar dozim. Kamaghɨn amizɨ, nɨ a ko dakuan markɨ. Nɨ a ko dakuigh afeziamɨn dozim damutɨ, a bar aghumsigham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Nɨ uan otarimɨn amuim ko dakuan markɨ. A nɨn amuim puvatɨ, kamaghɨn nɨ a ko dakuan bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Nɨ uan aveghbuamɨn amuim ko dakuan bar markɨ. Nɨ a ko dakuightɨ, nɨn aveghbuam bar aghumsigham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Amizitam fomɨra gumazir igharazimɨn ikia guivim bate, ezɨ gɨn nɨ amizir kamɨn iti, egh nɨ an guivim sara aning ko dakuan markɨ. Egh nɨ uan amuimɨn guivimɨn guivitam ko dakuan markɨ. Nɨ uaghan uan amuimɨn otarimɨn guivitam ko dakuan markɨ. Amizir kaba, me nɨn amuimɨn anababa, egha nɨn adarasi. Kamaghɨn amizɨ, nɨ arazir kuramɨn me damigham, nɨ arazir aghumsɨzir bar ekiam damigham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Nɨn amuim ikiavɨra itir dughiamɨn, nɨ an afumimɨn ikian markɨ. Nɨ kamaghɨn damuva, aning damutɨ, aning uaningɨn ataram. ");
INSERT INTO msy2020_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Amizir uan iakɨnibav sozim, a zuezir puvatɨ. Kamaghɨn, nɨ a bagh navim dɨkav a ko ikararang a ko dakuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nɨ uan namakamɨn amuim ko dakuan markɨ. Nɨ a ko kamaghɨn damuva, nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Ia oragh. Kɨ Ikiavɨra Itir God, ian God. Kɨ Akar Gavgavir kam ia ganɨdi, ia uan boriba isɨ asem Molekɨn ofa damusɨ uan boribav sogh avimɨn da tuan markɨ. Kɨ bar ian anogoroke. Ia kamaghɨn damuva, nan ziam dɨkabɨragham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Ia gumaziba, gumazir igharazitam ko dakuan markɨ, mati gumazim amizim ko akui mokɨn. Arazir kam, a bar kufi, ezɨ kɨ bar an aghua. ");
INSERT INTO msy2020_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ia gumaziba, asɨzir amebaba ko dakuan markɨ. Eghtɨ amiziba, asɨzir apuritam ateghtɨ, an a ko dakuan markɨ. Arazir kam ia damutɨ ia nan damazimɨn bar mɨzegham. Arazir kam, en arazir aghuim otavkɨra aghumsɨzir bar ekiam itim gami. ");
INSERT INTO msy2020_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Ia arazir kurar kabar amuan markɨ. Ia dar amu, egh ia nan damazimɨn mɨzegham. Ikɨzir igharazibar gumazamizir Kenanɨn nguazimɨn itiba, me arazir kabagh amua nan damazimɨn mɨze. Kamaghɨn amizɨ, kɨ datɨrɨghɨn me batosi, eghtɨ ia men nguazim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Men arazir kurar kabara nguazir kam gamima a nan damazimɨn mɨze. Kamaghɨn amizɨ, kɨ ivezir kuram isa men nguazim ganɨdi. Egh ikɨzir igharazibar gumazamiziba, kɨ me batuegham, mati nguazim men misi, eghtɨ me ua Kenanɨn nguazimɨn ikian kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Eghtɨ ia Israelian gumazamiziba ko ikɨzir igharazibar gumazamizir ian tongɨn itiba, ia arazir kɨ ifongeziba ko bizir kɨ damuasa ia mɨkemeziba bar dar gɨn mangɨ. Ia God gɨfozir puvatɨzir ikɨzir igharazibar arazibar amuan markɨ. Men arazir kuraba bar kuri, ezɨ kɨ bar dar aghua. ");
INSERT INTO msy2020_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ia fo, gumazamizir faragha nguazir kamɨn itiba, me arazir kurar kabagh ami. Kar arazir kurar bar kuriziba, ezɨ kɨ bar dar aghua. Bizir kam bangɨn, nguazim nan damazimɨn mɨzegha iti. ");
INSERT INTO msy2020_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ezɨ ia uaghan kamaghɨn damigham, ia nguazir kam damutɨ, a mɨzegham. Ia kamaghɨn damutɨ, nguazir kam ian migh ia batuegham, mati nguazim faragha ikɨzir igharazibar gumazamiziba batoghezɨ mokɨn. ");
INSERT INTO msy2020_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Eghtɨ Israelian amizim o gumazir manam, kɨ bar aghuazir arazir bar kurir kabar amutɨ, kɨ uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“Ia Akar Gavgavir kɨ ia ganɨdir kamɨn gɨn mangɨ. Gumazamizir ian faragha ghua nguazir kamɨn ikia amizir arazir bar kurir kɨ bar aghuaziba, ia dar amuan markɨ. Ia kamaghɨn damigham, ia nan damazimɨn mɨzegham. Ia oragh. Kɨ Ikiavɨra Itir God, ian God, kɨ mɨkemegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","Ikiavɨra Itir God, kamaghɨn Israelia mɨkɨmasa Moses mɨkeme: “Kɨ, Ikiavɨra Itir God, ian God, kɨ arazir kurabar saghon ikiava, bar zue. Kamaghɨn, ia uaghan nan mɨn arazir kurabar saghon ikɨ, bar zuegh, egh nan gumazamizibara ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ia vaghvagh uan amebaba ko afeziabar apengan ikɨva, egh men akabar gɨn mangɨ. Ia Sabatɨn dughiamɨn ingaran markɨ. Ia avughsɨ ikɨ. Kɨ Ikiavɨra Itir God, kɨ ian God, kɨ kamaghɨn mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ia na ategh marvir guar kɨnibar ziaba fan markɨ. Egh ia uari bagh ain isɨ nedazibar ingar, egh dar ziaba fan markɨ. Kɨ bar anogoroke. Kɨ Ikiavɨra Itir God, ian God. Kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Ia na ko navir vamɨra ikiamin ofa damusɨ, ia arazir kɨ ia ganɨdir kamɨn gɨn mangɨ, ofan kam damu. Egh ia kamaghɨn damutɨ, kɨ ian ofa gifuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ia asɨzim mɨsoghezir dughiamra ofan asɨzir tuzibar amɨ, o amɨmzaraghan dar amɨ. Eghtɨ asɨzir tuzir naba dughiar mɨkezimɨn ikɨvɨra ikɨtɨ, ia da tueghtɨ da bar isi mangɨ averenir kɨnimɨn otogh. ");
INSERT INTO msy2020_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Eghtɨ gumazitam dughiar mɨkezimɨn asɨzir kam amɨtɨ, arazir kam nan damazimɨn bar deraghan koghtɨ, kɨ uaghan bar an ofan kamɨn aghuagham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Gumazitam dughiar mɨkezimɨn asɨzir tuzir kam ame, a bizir bar zuezir me na ganɨngizim gamima, a ikufi. Ezɨ a uabɨ uan arazir kuramɨn osɨmtɨzim ikɨ ivezir kuram iniam. Kamaghɨn amizɨ, kɨ uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Dughiar ia uan azeniba aghorimɨn, ia dagher azenimɨn dazighiamɨn tughav itim asian markɨ. Egh ia azenibar tongɨn dagheba asi, egh taba ategh, egh ua mangɨ da asian markɨ. Ia da ateghtɨ da mamaghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Dughiar ia wainɨn ovɨzir anɨdiziba inigha gɨvazimɨn, ia uamategh mangɨ wainɨn azenimɨn wainɨn ovɨzir ia faragha ganizir puvatɨziba inian markɨ. Egh ia wainɨn ovɨzir nguazim gireghav itiba inian markɨ. Ia dagher kaba, onganaraziba ko ikɨzir igharazibar gumazamizir ian tongɨn itiba bagh da ateghtɨ, me da iniam. Kɨ Ikiavɨra Itir God, kɨ ian God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Ia gumazir igharazimɨn biziba okɨman markɨ. Egh ia gumazir igharazim gifar, an biziba inian markɨ. Egh ia bar gumazir igharazim mɨkɨmɨva a gifaran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Egha ia gumazir igharazim ko akam akɨra, nan ziam dɨbora gavgavim uan akar dɨkɨrɨzim ganɨdi, kamaghɨn ia pura gumazir kam ko akam akɨr, egh a gifaran markɨ. Egh ia uan akar dɨkɨrɨzimɨn gɨn mangan koghɨva, ia nan ziam dɨkabɨri. Kɨ Ikiavɨra Itir God, ian God, kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Ia pazɨ gumazir igharazim damuva, egh an biziba okɨman markɨ. Ia dagɨaba bagh ingangarim gumazitam danigh, egh ia an ingangarimɨn ivezimɨn dughiar a ingarizir kamɨn ivezim a danɨngigh. Ia ivezimɨn suiragh ikɨ gurumzaraghan a danɨngan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ia gumazamizir kuarir onganiba, akar kurabar kamaghɨn me mɨkɨman markɨ suam, God ia gasɨghasigham. Ia damazir okavɨrɨziba men tuaviba apɨr ighuvibar arɨgh, me damutɨ me iran markɨ. Kɨ Ikiavɨra Itir God, ian God. Ia nan atiating. ");
INSERT INTO msy2020_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Ia kotiam barazir dughiamɨn, ia deraghvɨra kotiam tuisɨgh. Egh ia deraghvɨra kotiam akɨrigh. Ia onganarazir gumazamizibar akurvaghan markɨ, me kotiam puram a gafiragham. Egh ia gumazamizir ziaba ko gavgaviba itibar atiating men akurvaghtɨ, me pura kotiam gafiraghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ia namakaba ko daruva egh gɨrakɨrangɨn gumazir igharazim mɨkɨman markɨ. Me gumazitam osɨmtɨzir ekiam bagh a isɨ kotiam datɨghtɨ, ia kotɨn an akurvaghamin gavgavim ikɨ, ia an akuragh. Ia uan akabar kuaghtɨ, kot suam, a mɨsueghtɨ an aremegh, kar bizir bar kuram. Ia an akuraghasa, kɨ ifonge. Kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Nɨ uan navir averiamɨn aven uan namakam dughiar ruarimɨn navim an ikuvigh ikian markɨ. Nɨ a ko akam akɨrigh, egh osɨmtɨzir kam agɨfagh. Puvatɨghtɨma, nɨ an arazim gɨnɨghnɨghvɨra ikɨva, nɨ ti uaghan, an amizir arazir kam damigham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nɨn namakatam arazir kuratam nɨ damightɨ, nɨ an arazim ikarvaghan markɨ, egh nɨ an ataran markɨ. Nɨ uabɨra uabɨ gifongezɨ moghɨn, nɨ gumazamizir igharazibagh ifongegh. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Ia nan arazir kɨ ifongezir kabar gɨn mangɨ. Egh ia asɨzir igharagha garimning ateghtɨ, aning uaning ko dakuva nguziba batan markɨ. Egh ia dagher anabar igharagha garir pumuning azenir vamɨran da oparan markɨ. Egh ia pura nir me tretɨn kɨnimɨn isamizim ko tretɨn me sipsipɨn arɨzimɨn isamizim, aning isafuragha korotiar ingarizim aghuan markɨ. Kar arazir anogorogheziba. ");
INSERT INTO msy2020_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Ezɨ gumazitam ingangarir amizir kɨnitam ikɨ, egh a gumazir igharazim bagh amizir kam amangasa akam akɨri, ezɨ gumazim a givezezir puvatɨ. Eghtɨ gumazir amizir kamɨn garim, amizir kam ko dakutɨ, ia aning inigh kotiamɨn mangɨ. Egh ia aning mɨsueghtɨ, aning aremeghan markɨ. Guizbangɨra, amizir kam a gumazir an garimɨn ingangarir amizir kɨnim. ");
INSERT INTO msy2020_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Eghtɨ gumazir kam sipsipɨn apuritam inigh na bativamin Purirpenimɨn tiar akamɨn mangɨ. A sipsipɨn kam isɨ uan osɨmtɨzim agevir ofan mɨn Ikiavɨra Itir God bagh ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Eghtɨ ofa gamir gumazim, Ikiavɨra Itir Godɨn damazimɨn osɨmtɨzim agevir ofa damuva gumazir kamɨn arazir kuraba gɨn amangam. Eghtɨ kɨ an ganigh an arazir kuraba gɨn amadagham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Ia Kenanɨn nguazimɨn mangamin dughiamɨn, ia temer bava ovɨziba itiba opar, egh ia temer kabar ovɨzibar aman kogh mangɨtɨ 3plan azeniba gɨvagham, da nan damazimɨn zuezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Egh namba 4ɨn azenimɨn ia temer katabar dagheba bar na danɨngigh, kɨ Ikiavɨra Itir God. Kar ababanir ia na mɨnabɨ, egh bar akuegh nan ziam famim. ");
INSERT INTO msy2020_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Egh namba 5ɨn azenimɨn ia dar ovɨzibar amɨ. Egh ia nan akar kamɨn gɨn mangɨtɨ, ian temeba bɨva ovɨzir avɨriba ikiam. Ia oragh, kɨ Ikiavɨra Itir God, ian God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Ia asɨzir tuzir ghuzim itibar aman markɨ. Egh ia imezibagh amir araziba ko kukunir araziba, ia dar amuan markɨ. Da nan gavgavimɨn izezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","28","Ia gumazim o amizir aremezim gɨnɨghnɨgh dapanir arɨzir ian kuaribar boroghɨn itiba apɨran markɨ, egh uan ghuamasɨzibagh isɨ da otɨvan markɨ. Egh ia uaghan uarir akurvaghsɨ, gumazim o amizir aremezim gɨnɨghnɨgh, uan mɨkarzibar ghor, dɨghoribar amuan markɨ. Kɨ Ikiavɨra Itir God, ia arazir kabar amuan, kɨ anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Ia asebar ziaba fer arazibar amusɨ, uan guivibar amutɨ, me tuavimɨn amizibar mɨn aghumsɨzir arazim damuva poroghamiba uari isava akuir arazim damuan markɨ. Ia kamaghɨn damuva na ategh asebar apengan ikiam, mati tuavimɨn amizir tintinimɨn gumaziba koma akuim. Eghtɨ arazir kuram ian nguazim bar a gizɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Ia Sabatɨn dughiamɨn ingaran markɨ. Egh ia Purirpenir gumazamiziba iza nan ziam fer kam, bar a gifongegh. Kɨ Ikiavɨra Itir God, kɨ ia mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Egh ia nɨghnɨzir aghuim inisɨ, mangɨ ariaghirezir gumazamizibar duaba ko mɨgeir gumazimɨn azaraghtɨ, me duar kurabar nɨghnɨzim ia danɨngan markɨ. Ia kamaghɨn damu, ia nan damazimɨn bar mɨzegham. Kɨ Ikiavɨra Itir God, ian God, kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ia gumazamizir ghuribar apengan ikɨ, egh deraghvɨra me damu. Egh ia nan atiating nan apengan ikɨ. Kɨ Ikiavɨra Itir God, ian God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Ia ikɨzir igharazibar gumazamizir ian nguazimɨn itiba pazɨ me damuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ia ikɨzir igharazibar gumazamizir ian tongɨn itiba arazir aghuibar me damu, mati ia uan adarazi Israelia gami mokɨn. Egh ia uari gifongezɨ moghɨn ia bar me gifongegh. Ia fomɨra Isipɨn kantrin ike, kamaghɨn ia gumazamizir uan nguibaba ataghɨragha ghua kantrin igharazibar itir arazim, ia a gɨfo. Ia deraghvɨra gumazir ia ko itir kabar amu. Kɨ Ikiavɨra Itir God, ian God, kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Ia bizibar ababanibagh amuva, dar osɨmtɨzim ko ruaribagh fofogh da tuisɨgh, egh da mengtɨ gumazir igharaziba dagh ivezam, ia arazir kamɨn, me gifaran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Puvatɨ. Ia deraghvɨra dar abanɨva da tuisɨgh, egh deraghvɨra biziba meng. Kɨ Ikiavɨra Itir God, ian God, kɨ Isipɨn kantrin ia inigha ian akua azenan ize. ");
INSERT INTO msy2020_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kamaghɨn amizɨ, arazir kɨ ifongeziba ko bizir kɨ damuasa ia mɨkemezir kaba bar, ia dar gɨn mangɨ. Kɨ Ikiavɨra Itir God, kɨ ia mɨkemegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","2","Ikiavɨra Itir God, Israelian gumazamizibav kɨmasa kamaghɨn Moses mɨgei: “Israelian tav o ikɨzir igharazibar gumazamizir Israelɨn kantrin aven itibar tav, uan borim isɨ asem Molek bagh ofan mɨn a danɨngtɨ, ia gumazir kam mɨsueghtɨ an aremegh. Nguazir kamɨn gumazamiziba bar dɨkavigh dagɨaba isɨ gumazir kam ginivightɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Gumazim borim isa Molek ganɨdir arazir kam, nan Purirpenim gamima a mɨzegha bar nan ziar ekiam dɨkabɨra. Kamaghɨn amizɨ, kɨ gumazir kamɨn apanim damuva uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nguazir kamɨn gumazamiziba gumazir kamɨn arazir kurar kamɨn ganɨva mɨkɨm suam, kar pura bizim, egh a mɨsueghtɨ an aremeghan koghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","kamaghɨn kɨ uabɨ an apanim damuva an adarazi sara, ko gumazamizir akɨrim na gasaragha asem Molekɨn ziam feba bar, kɨ men apanim damuam. Kɨ uan gumazamizibar tongɨn me batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Eghtɨ gumazitam na tegh, kukunir gumaziba ko, ariaghirezir gumazibar duaba ko mɨgeiba bagh mangɨ, a mati tuavimɨn amizim tintinibar arua gumazir igharaziba koma akui. Kamaghɨn, kɨ gumazir kamɨn apanim damuva uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ia bar zuegh ikɨ, egh arazir aghuir voroghɨra itir kɨ ifongezibar aven daru. Kɨ Ikiavɨra Itir God, ian God, kɨ kamaghɨn mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kɨ Ikiavɨra Itir God, kɨ ua bagha ia mɨsevezɨ ia bar nan gumazamizir aghuibar otifi. Kamaghɨn amizɨ, arazir kɨ ifongeziba, ia bar dar gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Egh gumazim o amizim uan afeziam o amebam akar kuramɨn a mɨgɨa ghaze, God nɨ gasɨghasigham, eghtɨ ia gumazir kam o amizir kam mɨsueghtɨ an aremegh. Gumazim o amizir akar kam mɨkemezim, a uan osɨmtɨzim bangɨn aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Eghtɨ gumazitam uan namakamɨn amuim ko dakuightɨ, kamaghɨn ia gumazir kam ko amizir kam mɨsueghtɨ aning aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Eghtɨ gumazim uan afeziamɨn amuim ko dakuigh, egh an arazir kuramɨn uan afeziam damuva aghumsɨzim a danɨngam. Kamaghɨn, ia gumazir kam ko amizir kam mɨsueghtɨ, aning aremegh. Aning uaning arazir kuram damigh osɨmtɨzim ikiam, egh bizir kam bagh aning aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Eghtɨ gumazitam uan otarimɨn amuim ko dakuightɨ, ia aning mɨsueghtɨ aning aremegh. Aning en arazir aghuim oteghavkɨnigha arazir kuram gami, egh aning uan osɨmtɨzim bangɨn aning aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Eghtɨ gumazitam gumazir igharazim ko dakuigh, mati gumazim amizim ko akui moghɨn, egh aning amizir arazir bar kurar kɨ aghuazim damigh, bar osɨmtɨzir ekiam ikiam. Kamaghɨn ia aning mɨsueghtɨ aning aremegh. Aning uan osɨmtɨzim bangɨn aning aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Eghtɨ gumazitam uan amuimɨn ikɨ, egh uaghan an amuimɨn amebam isafuragh uaghara aningɨn ikɨtɨ, ia bar me isɨ avimɨn me daboroghtɨ me isigh. Me osɨmtɨzir bar ekiam gami. Guizbangɨra, kamaghɨn amir gumazamiziba ateghtɨ, me ian tongɨn ikian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Eghtɨ gumazitam asɨzitam ko arazir kuram damigham, mati gumazim amizim koma akui moghɨn, eghtɨ ia uaghara aning mɨsueghtɨ aning aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Eghtɨ amizitam asɨzitam bagh mangɨ, a ko arazir kuram damigham, mati amizim gumazim koma akui moghɨn, eghtɨ ia aning mɨsueghtɨ aning aremegh. Aning uan osɨmtɨzim bangɨn aning aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Eghtɨ gumazitam uan buaramizim ko dakuam, kar an afeziamɨn guivim, o an amebamɨn guivim, egh aning bibiamra ikɨ uaningɨn ganɨva, kamaghɨn aning arazir bar kuram damigham. Kamaghɨn amizɨ, ia gumazamizibar damazimɨn bar aningɨn atarɨva, aning batueghtɨ, aning ua ia ko ikian kogham. Gumazir kam uabɨ uan buaramizim koma akui, kar aghumsɨzir arazim, kamaghɨn, a uan arazir kuramɨn osɨmtɨzim ateram. ");
INSERT INTO msy2020_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Eghtɨ gumazim, amizir uan iakɨnibav sozir dughiamɨn itim inigh, a ko dakuam, aning bar arazir mɨzɨrɨzim nan damazimɨn a damuam. Eghtɨ ia nan gumazamizibar tongɨn aning batokegh. ");
INSERT INTO msy2020_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Gumazitam uan amebar dozim o afeziamɨn buaramizim ko dakuva, an arazir kuramɨn uan anabam damigh aghumsɨzim a danɨngam. Aning amizir arazir kurar kam bangɨn osɨmtɨzim ateram. ");
INSERT INTO msy2020_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Eghtɨ gumazitam uan afeziar dozimɨn amuim ko dakuigham, gumazir kam aghumsɨzim afeziar dozim danɨngam. Egh aning amizir arazir kurar kamɨn osɨmtɨzim ateram. Gumazir kam amizitamɨn ikɨ boriba batan kogham, eghtɨ an afeziar dozimɨn amuim uaghan boriba batan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Eghtɨ gumazitam uan aveghbuamɨn amuim a dam a inigh an ikɨ, a nan damazimɨn arazir bar mɨzɨrɨzim damuva aghumsɨzim uan aveghbuam danɨngam. Kamaghɨn amizɨ, gumazir kam ko amizir kam boriba batan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Ia nan arazir kɨ ifongeziba ko bizir kɨ damuasa ia mɨkemeziba, bar dar gɨn mangɨ. Ia kamaghɨn damutɨ, nguazir kɨ datɨrɨghɨn ian akua zuir kam, a ian aghuagh ia batueghan kogham, mati gumazim dagher kuramɨn mizi mokɨn. Ia deraghvɨram an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Ia Kenanɨn nguazimɨn itir ikɨzibar arazibar gɨn mangan markɨ. Me bizir kurar kabagh ami, ezɨ kɨ bar men aghua. Kɨ datɨrɨghɨn ikɨzir kaba batueghtɨ, ia men nguazim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Kɨ ia mɨkemegha gɨfa, nguazir kam a bar dera, ezɨ dagher avɨrim an ikia, deraghavɨram aghui. Kɨ a isɨ ia danɨngightɨ, a ian nguazimram otogham. Kɨ Ikiavɨra Itir God, kɨ ikɨzir igharazibar tongɨn ia ini, eghtɨ ia bar igharaghvɨra ikɨ, nan gumazamizibaram otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kamaghɨn amizɨ, ia deraghvɨra asɨziba ko kuaraziba tuisɨgh, asɨziba ko kuarazir manaba zue, ia dar amɨ. Ezɨ asɨziba ko kuarazir manaba mɨzeghtɨ, ia dar aman markɨ. Kɨ asɨziba ko kuaraziba ko apizir zuezir puvatɨzir kabar gun ia mɨkeme. Ia dar amɨva, ia arazir bar kurir kɨ aghuazibar amuam. Ia asɨzir kabar amɨva nan damazimɨn bar mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ia arazir kuraba ategh zuegh ikɨ, nan arazir bar aghuibar gɨn mangɨ. Kɨ Ikiavɨra Itir God, kɨ uabɨ bar zue, egha kɨ ikɨzir igharazibar tongɨn ua baghavɨra ia ini. ");
INSERT INTO msy2020_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Eghtɨ kukunir gumaziba, ko ariaghirezir gumazamizibar duaba ko mɨgeiba, ia bar dagɨaba isɨ me ginivightɨ me arɨmɨghiregh. Me uan osɨmtɨzim bangɨn arɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ikiavɨra Itir God, Aronɨn adarazir ofa gamir gumazibav kɨmasa kamaghɨn Moses mɨgei: “Ian adarazir tav aremeghtɨ, ia gumazir aremezim bagh aghuimazir arazim damuan markɨ. Arazir kam ia gamima, ia nan damazimɨn mɨze. ");
INSERT INTO msy2020_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Eghtɨ bar gumazimɨn adarazir aven iti tav aremegham, kar an amebam, o afeziam, o otarim, o guivim, o aveghbuam, ");
INSERT INTO msy2020_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o guizɨn an buaramizir pam puvatɨgha afeziamɨn dɨpenimɨn ikia aremezim, a me bagh aghuimazir arazim damuam. A kamaghɨn fogh, an aghuimazir arazir kam damutɨ, a nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Eghtɨ ofa gamir gumazimɨn ivozim aremegham, eghtɨ ofa gamir gumazim an aghuimazir arazim damuan markɨ. Kamaghɨn a nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Eghtɨ ia ofa gamir gumaziba, aghuimazir arazimɨn gɨn mangɨva, uan dapanir arɨzir akuatabagh isan markɨ. Egh ghuamasɨzibar mɨriabagh isan markɨ. Egh aghuimazir arazim bagh tintinibar uan mɨkarzibar ghoran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ia ofa gamir gumaziba kɨ ua bagha ia mɨsefe. Kɨ ian God, kamaghɨn ia nan ziam dɨkabɨnan markɨ. Ia nan ofa damuamin ingangarim iti, ezɨ avim isir ofan kaba, ia daghebar mɨn na ganɨdi. Kamaghɨn amizɨ, ia arazir kurar kaba akɨrim ragh dagh asaragh, egh na ko daru. ");
INSERT INTO msy2020_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ia nan ofa gamir gumazibara. Kamaghɨn amizɨ, ia tuavimɨn amizir gumaziba isava akuim, o amizir gumazir igharazim ko akuim, o amizir an pam anetaghizim, ia an poghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Gumazamiziba fogh suam, ia ofabar dagheba na ganɨdi, kamaghɨn, ia bar nan ofa gamir gumazibara. Kɨ uabɨ Ikiavɨra Itir God. Kɨ Godɨn bar zuegha arazir aghuibaram amim. Egha kɨ uan gumazamizibagh amima, me zuegha arazir aghuibaram ami. ");
INSERT INTO msy2020_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Eghtɨ ia ofa gamir gumazitamɨn guivitam, tuavimɨn amizimɨn ikɨva, arazir mɨzɨrɨzibar gɨn mangɨva, aghumsɨzir ekiam uan afeziam danɨngam. Kamaghɨn, gumazamiziba avimɨn a daboroghtɨ a isigh aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Ofa gamir gumazibar dapanim, uan ingangarimɨn ziar ekiam ini. Me borem an dapanim gingezir dughiamɨn, me ofa gamir gumazibar korotiamra, a daghuasa anemɨsefe. Eghtɨ an adarazir tav aremeghtɨ, a uan dapanir arɨzim ateghtɨ a pura ikian markɨ, a deraghvɨram a batogh. Egh a uan korotiam abɨghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ofa gamir gumazibar dapanim, gumazimɨn kuam itir danganimɨn boroghɨn mangan markɨ. A kamaghɨn damuva, nan damazimɨn mɨzegham. An afeziam o amebam aremeghtɨ, an aghuimazir dughiamɨn uabɨ damu mɨzeghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Kamaghɨn, an Anogoroghezir Danganim ategh gumazir kuaba itir danganimɨn boroghɨn mangan markɨ. A kamaghɨn damu nan Purirpenim damutɨ a nan damazimɨn mɨzegham. Ia borer kɨ ia ganɨngizir kam a gingegha gɨvagha, anemɨsevezɨ a ofa gamir gumazibar dapanimɨn oto. Kamaghɨn, a gumazimɨn kuam itir danganimɨn boroghɨn mangan markɨ. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn ia mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Ofa gamir gumazibar dapanim, amizir gumazir igharazitam ko akuizir puvatɨzir tamɨn ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","An amizir pam aremezim, o amizir pam taghizimɨn ikian markɨ. A tuavimɨn amizir gumaziba isava akuim, o amizir gumazir igharazim arazir kuramɨn a gamua a ko akuizimɨn ikian markɨ. Kar amizir anogorogheziba. An ofa gamir gumazibar anabamɨn amizir gumazitam ko akuizir puvatɨzir tamra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Egh a nan akar kamɨn gɨn mangan koghtɨ, an boriba nan damazimɨn mɨzegham. Kɨ Ikiavɨra Itir God, kɨ ua baghvɨra anemɨsevegha, a isa ofa gamir gumazibar dapanimɨn ingangarir kam damuasa anetɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Nɨ kamaghɨn Aron mɨkemegh: Nɨn adarazir gumazitam datɨrɨghɨn o gɨn izamin dughiamɨn otoghtɨ, an mɨkarzim duatam ikɨ ikuvightɨ, gumazir kam na bagh daghebar ofabar amuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Gumazir mɨkarziba ikuviziba, me nan boroghɨn izɨ na bagh ofabar amuan markɨ. Kɨ gumazir kamagh garibav gei: damazir okaviziba, o suer kuraba, o guar kuraba, o amebamɨn navimɨn averara sueba ko aghariba otevegha ikɨzɨrɨghiziba, ");
INSERT INTO msy2020_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o gumazir suer kuraba, o gumazir agharir kuraba, ");
INSERT INTO msy2020_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o gumazir akɨrir fɨghtɨziba, o gumazir bar oteviba, o gumazir damazir kuraba, o gumazir mɨkarzir kuraba, o gumazir turiaba ikuviziba. ");
INSERT INTO msy2020_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Guizbangɨra, nɨn anabamɨn tavɨn mɨkarzim duatam ikia ikufi, gumazir kam, na bagh izɨ daghebar ofabar amuan markɨ. Kɨ bar anogoroke. ");
INSERT INTO msy2020_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Egh an asɨziba ko bizir ia ofan mɨn na ganɨngizibar amam. Kɨ ofa gamir gumaziba damasa ia ganɨngizir ofaba, a bar da iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Egh a Bar Anogoroghezir Danganim modir nir ekiam iti naghɨn ko ofa gamir dakozimɨn boroghɨn mangan markɨ. Kɨ uabɨ Ikiavɨra Itir God, kɨ uan ingangarimra damuasa me amɨsefe. Kamaghɨn amizɨ, an adar boroghɨn izɨ, egh a bizir bar zuezir kabar amutɨ da nan damazimɨn mɨzegham.” ");
INSERT INTO msy2020_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ezɨ Moses akar kamɨn gun Aron uan otariba, ko Israelian gumazamiziba bar me mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Nɨ kamaghɨn Aron uan otariba ko me mɨkɨm. Ia deraghvɨra nɨghnɨgh, Israelian gumazamizibar ofaba, da nan bizibara. Kamagh amizɨ, ia deraghvɨra ofan kabar gan. Puvatɨghtɨ, ia nan ziar ekiam dɨkabɨragham. Kɨrara, kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Nɨ kamaghɨn me mɨkɨm. Ia ofa gamir gumaziba, ian adarazir tav nan damazimɨn mɨzegh, a Israelia na ganɨdir ofabar boroghɨn izan markɨ. Egh a roghɨra mangɨtɨ, kɨ uan damazimɨn a batueghtɨ an ofa gamir gumazimɨn ingangarim damuan kogham. Ia zurara arazir kamɨn gɨn mangɨvɨra ikɨ. Kɨ Ikiavɨra Itir God, kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","5","“Eghtɨ Aronɨn adarazir ofa gamir gumazitam, lepan arɨmariam ikɨ, o mɨkarzir mogomem duam a batoghtɨ ghuzir mɨtɨzim an azenan otivtɨ, ghuzir mɨtɨzir kam a damutɨ, a nan damazimɨn mɨzegham. Egh a nan ofabar aman kogh mangɨ, a ua deraghamin dughiamɨn tugham. Egh a uaghan gumazir aremezimɨn kuamɨn poroghav itir bizitamɨn suiragham, o dɨpam an mɨkarzir mogomemɨn otivam, o a dafarir tamɨn asɨzir mɨzezir tamɨn suiragham, a gumazir nan damazimɨn zuezir puvatɨzim, ezɨ arazir kam bangɨn, an ofabar aman kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ofa gamir gumazir nan damazimɨn mɨzezir manam, a kamaghɨra ikɨ mangɨtɨ aruem magɨrɨgham. Egh a faragh dɨpamɨn deragh uabɨ ruegh, egh a ofan asɨzir me na ganɨdibar amam. Egh a rueghan kogh, a daman kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Aruem magɨrɨ gɨvaghtɨ, a ua zuegh nan ofabar amam. Kɨ uabɨ, uan ofabar dagheba isa ia bagha da atɨ, kar ofa gamir gumazibar dagheba. ");
INSERT INTO msy2020_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","A puram aremezir asɨzim ko asɨzir atiam mɨsoghezɨ aremezimɨn tuzitam aman markɨ. Ana anemegham, a nan damazimɨn mɨzegham. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ia ofa gamir gumaziba, Akar Gavgavir kɨ ia ganɨngiziba bar adar gɨn mangɨ. Ia nan akam batuegh, ia arazir kuram damigh, osɨmtɨzim ikɨtɨ, kɨ ia mɨsueghtɨ ia arɨghiregham. Kɨ Ikiavɨra Itir God, kɨ ua bagha ia ofa gamir gumaziba amɨsefe, egha kɨ mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Ofa gamir gumazibar adarazir gumazim o amizim, merara gumazamiziba na ganɨdir ofabar amam. Igharazitav daman kogham. Gumazir dughiar otevimɨn ofa gamir gumazim ko itim, o an ingangarir gumazim, me uaghan daman kogham. Bar markiam. ");
INSERT INTO msy2020_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Eghtɨ ofa gamir gumazimɨn ingangarir gumazamizir kɨnir a ivezeziba, ko borir amebam ofa gamir gumazir kamɨn dɨpenimɨn ikia oteziba, me ofa gamir gumaziba apir daghebar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Eghtɨ ofa gamir gumazitamɨn guivim, ofa gamir gumazibar ikɨzimɨn azenan itir gumazir kɨnitam ko poroghɨv ikɨ, kamaghɨn a nan ofabar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Eghtɨ guivir kamɨn pam aremeghtɨ a pura ikiam, o an pam aneteghtɨ, a pura ikɨva, boriba puvatɨgh, uamategh uan afeziamɨn dɨpenimɨn mangɨ, kamaghɨn, an ofa gamir gumazibar daghebar amɨ, kar dagher an afeziam inigh izamiba. Eghtɨ gumazim o amizim ofa gamir gumazibar adarazir aven itir puvatɨ, a daman markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Egh gumazitam ofa gamir gumazibar adarazir mav puvatɨ, egh deragh nɨghnighan kogh nan ofan nataba amegh, kamaghɨn a dagher kaba ikarvagh ofa gamir gumazim danɨngigh. A 5plan dagher naba inigh, kamaghɨn a 6plan dagheba isɨ da ikarvagham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ia ofa gamir gumaziba deraghvɨra gan, gumazamizir kɨniba nan ofan kabar aman bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Kɨ Ikiavɨra Itir God, kɨ ua bagha ofan kaba mɨsefe, egha dar anogoroke. Kamagh amizɨ, ia ofa gamir gumaziba, gumazir kɨnitamɨn amamangatɨghtɨ a ofan kabar aman bar markɨ. Gumazir kaba dar amɨva, osɨmtɨzim ikiam, egh ua dagheba ikarvagh da isɨ ofa gamir gumazim danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ikiavɨra Itir God kamaghɨn Moses mɨkeme, ");
INSERT INTO msy2020_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Nɨ akar kam isɨ Aron uan otariba ko Israelian gumazamizibav mɨkemegh. Ia Israelian gumazitam, o ikɨzir igharazibar gumazamizir Israelɨn kantrin ititam, an asɨzir tam isɨ ofan bar isia mɨghɨrim bagh an aku izam, kar ofan a uan akar dɨkɨrɨzim na ko amizim akɨrasa, o a uan ifongiamɨn gɨn ghua ofa damuasa, ");
INSERT INTO msy2020_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","a bulmakaun apurim o sipsipɨn apuritam o memen apurir tam inigh izɨ. Ia duaba mɨkarzimɨn itir asɨzitamɨn ofa damuan markɨ. Ia kamaghɨn damightɨ, kɨ a gifueghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ia deraghvɨram oragh. Ia asɨzir mɨkarzim ikuvizɨ tamɨn ofa damutɨ, kɨ a gifueghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Gumazim, Ikiavɨra Itir God ko navir vamɨra ikiamin ofa damuam, kar ofan a uan akar dɨkɨrɨzir na ko amizim akɨrasa, o a uan ifongiamɨn gɨn mangɨ ofa damuasa, a bulmakau o sipsipɨn duaba an mɨkarzimɨn puvatɨzitam inigh izɨ. A kamaghɨn damightɨ, kɨ an ofa gifuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ia asɨzir damazir okavɨrɨziba, o asɨzir suer kuraba itiba, o asɨzir mɨkarzim ikuviziba, o asɨzir duar ekiaba itiba, o asɨzir tuar kɨniba, o asɨzir duar kuriba itiba isɨ, nan ofa damuan markɨ. Ia asɨzir katam nan ofa gamir dakozimɨn avimɨn an ofa damuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Egh ia uari ofan tam uan ifongiamɨn a damusɨ, bulmakau o sipsipɨn soroghafariba otevezitam o ikɨzɨrɨzir tam iniam, a dera. Egh ia akar na ko dɨkɨrɨzir tam akɨrsɨ, asɨzir katam isɨ nan ofa damuan markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Eghtɨ asɨzir katamɨn turiam ikufi, o me an oke, o anebɨki, o me an turiar ovɨzim amɨsefe, asɨzir kam ia na bagh ofa damuan markɨ. Ia asɨzir kamaghɨn gariba, uan nguazimɨn aven Ikiavɨra Itir Godɨn ofa damuan markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Egh ia ikɨzir igharazimɨn gumazimɨn dafarimɨn asɨzir katam inigh ofa damuan markɨ. Asɨzir kamagh gariba, dar mɨkarziba ikuvigha, nan damazimɨn derazir puvatɨ. Ezɨ kɨ ofan kamaghɨn garibar aghua. Kɨ bar dar aghua.” ");
INSERT INTO msy2020_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Bulmakau ko sipsip ko memeba otamin dughiamɨn, dar nguziba 7plan aruebar amebam ko ikegham. Eghtɨ namba 8ɨn aruemɨn ikegh mangɨ, ia da inigh avimɨn ofa damusɨ ofa gamir dakozimɨn mangɨ, eghtɨ kɨ ian ofa gifuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Eghtɨ ia bulmakaun amebam, o sipsipɨn amebam, o memen amebam, uan nguzim ko, ia aruer vamɨra uaghara aning mɨsuegh aningɨn ofa damuan markɨ. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kɨ Ikiavɨra Itir God, ia na mɨnabir ofan tam damusɨ, ia ofan arazibar gɨn mangɨtɨ, kɨ ian ofa gifuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ia aruer manamɨn ofa gami, ia aruer kamra ofan asɨzir tuzibar amegh. Ia da ateghtɨ da ikɨ mangɨ amɨmzaraghan otoghan markɨ. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn ia mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ia oragh. Ia deraghvɨra nan Akar Gavgavibar gɨn mangɨ. Kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ia nan ziar bar zuezim dɨkabɨnan markɨ. Ia Israelian gumazamiziba kamaghɨn fogh suam, kɨ Godɨn bar zuezimra. Kɨ uabɨ Ikiavɨra Itir God, kɨ ua bagha ia mɨsevezɨ, ia bar nan gumazamizir aghuibaram otifi. ");
INSERT INTO msy2020_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Kɨ ian Godɨn ikiasa, kamaghɨn, kɨ fomɨra Isipɨn kantrin aven, ia isa ian akua azenan ize. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn ami.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Nɨ kamaghɨn Israelian gumazamizibav mɨkemegh: Kar dughiar ekiar ia nan ziam fasa kɨ inabaziba. Ia uari akuvagh dughiar kabar nan ziam fam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Ia 6plan aruebar ingangaribar amu. Egh aruer namba 7, kar Sabatɨn dughiam, avughsazir dughiar kamɨn ia ingaran markɨ. Ia uari akuvagh nan ziam fɨ. Egh ia danganir manamɨn iti, ia na bagh Sabatɨn dughiam amɨsefegh, kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Kɨ datɨrɨghɨn ia bagha mɨsevezir dughiabar gun ia mɨkɨmasa. Egh azenibar zurara ia dughiar kabar uari akuv nan ziam fɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ikiavɨra Itir God kamaghɨn mɨkeme, “Ia, God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isam damuam. Dughiar kam, azeniba vaghvagha, dar iakɨnir faragha zuim, an namba 14ɨn aruemɨn guaratɨzimɨn, ia uari akuvagh nan ziam fɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Ezɨ iakɨnir kamɨn namba 15ɨn aruemɨn, kar Yis Puvatɨzir Bretɨn Isam Damuamin Dughiam. Egh ia yis puvatɨzir bretɨn kam amɨ mangɨ 7plan aruebar tugh. ");
INSERT INTO msy2020_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Eghtɨ aruer kabar faragha zuir aruemɨn, ia uari akuvagh nan ziam fɨva, uan ingangaribar amuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ia asɨziba ko dagheba isɨ avimɨn Ikiavɨra Itir God bagh ofa damu mangɨ 7plan aruebar tugh. Egh namba 7 aruemɨn ia ua uari akuvagh nan ziam fɨ. Dughiar kamɨn, ia uan ingangaribar amuan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Nɨ Israelian gumazamiziba kamaghɨn me mɨkemegh: Dughiar ia mangɨ nguazir kɨ ia danɨngamimɨn ikiamimɨn, ia witɨn ian azenibar itir aniziba inigh, egh zurara azeniba bar, witɨn ikɨzir ia faragha ikeziba, ia da ater ofa gamir gumaziba bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Eghtɨ ofa gamir gumazim witɨn ikɨzir kamɨn suiragh a fegh a damutɨ, a nan damazimɨn ighuavamang, eghtɨ kɨ ia gifuegham. Ofa gamir gumazim, Sabatɨn gɨn otivamin aruemɨn, an ofan kam damu. ");
INSERT INTO msy2020_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Eghtɨ ia witɨn ofabar amuamin dughiamɨn, ia sipsipɨn nguzir azenir vamɨra itimɨn ofa damu, a bar deragh duaba an mɨkarzimɨn puvatɨgham. Eghtɨ sipsipɨn kam, an ofan bar isia mɨghɨrim. ");
INSERT INTO msy2020_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Egh ia plauan nar aghuim inigh, an osɨmtɨzim 2 kilogrem, egh olivɨn borem ko a veregh witɨn ofa tu. Ia ofan isia bar mɨghɨrim sara an ofa damu, eghtɨ kɨ Ikiavɨra Itir God, kɨ ofan tuamin kamɨn mughuriar aghuim baregh, egh a gifuegh navir aghuim an ikiam. Egh uaghan, ia 1 lita wainɨn dɨpam inigh ofan kamning sara ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Ia witɨn ikɨzir faragha ikezir kam, ia uan God bagh a inigh izeghan koghɨva, ia witɨn igiar faragha azenimɨn inizir kam aman markɨ. Puvatɨ. Ia faragh witɨn ikɨzir faragha ikezir kam inigh izegh, egh gɨn ia witɨn igiam amɨ. Ia witɨn ovɨzir isizir puvatɨziba, ko witɨn ovɨzir ia avimɨn tuamiba, ko bretɨn ia ingarigh tuamiba, ia dar amɨ. Ia ofan arazir kɨ ifongezir kamɨn gɨn mangɨtɨ, ian ovavir gɨn otivamiba, me uaghan dar gɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, “Ia na bagha witɨn ikɨziba atera izir aruemɨn gɨn, 7plan wighba mengegh. ");
INSERT INTO msy2020_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Egh namba 7 wigh gɨvaghtɨ, aruer namba 50 otoghtɨ, ia ua witɨn igiamɨn ofan igharazim na danɨng. ");
INSERT INTO msy2020_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ian avitoriba vaghvagh bretɨn rubuzir pumuning inigh izɨ na danɨngigh, kar witɨn faragha anibar ofa. Ia bretɨn rubuzimningɨn ingarsɨ bretɨn rubuzir tam bagh, plauan aghuir 2 kilogremɨn itim inighɨva, yis koma a veregh, egh bretɨn rubuzir igharazim uaghan kamaghɨra an ingarigh, aning tuagh. Egh bretɨn rubuzir kamning inigh izɨ, Ikiavɨra Itir God bagh ofa damu. Ia aningɨn suiragh aning fɨ aning damutɨ, aning Ikiavɨra Itir Godɨn damazimɨn ighuavamang. ");
INSERT INTO msy2020_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ia bizir kaba sara bretɨn kamɨn ofa damu. Ia 7plan sipsipɨn nguzir azenir vamɨra itiba, ko bulmakaun apurir igiar tam, ko sipsipɨn apurir pumuning inigh izɨ. Ia asɨzir duaba mɨkarzibar itiba inian markɨ. Asɨzir aghuibara inigh. Egh ia ofan bar isia mɨghɨrim na bagh a damu. Egh ia zuraram ami moghɨn, witɨn taba ko wain sara, ofan kam datɨgh. Ofan kam avim an isi mangɨ a bar mɨghɨrightɨ, averenir kɨnimɨn otogh. Eghtɨ Ikiavɨra Itir God, ofan kamɨn mughuriar aghuim baregh, a gifuegh navir aghuim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ia memen apuritam inigh arazir kuraba gɨn amadir ofa damu, egh sipsipɨn apurir igiar azenir vamɨra itir pumuning inigh, God ko navir vamɨran ikiamin ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Eghtɨ ofa gamir gumazim witɨn faragha anibar ofan mɨn, bretɨn kam ko sipsipɨn nguzimningɨn suiragh da fɨ da dar amutɨ, da nan damazimɨn ighuavamangɨ. Bizir kaba nan bizibara. Eghtɨ kɨ da inigh ofa gamir gumazibar anɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ia ofan kam gamir dughiamɨn ia uari akuvagh, nan ziar ekiam fɨ, egh ia uan ingangaribar amuan markɨ. Ian ovaviba gɨn otivigh managh ikɨ, me bar zurara arazir kamɨn gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Dughiar ia uan azeniba aghorimɨn, ia dagher azenimɨn dazighiamɨn tughav itim asian markɨ. Egh ia azenibar tongɨn dagheba asi, egh taba ateghɨva, ua mangɨ da asian markɨ. Ia da ateghtɨ da mamaghɨra ikɨtɨ, onganarazir gumazamiziba ko ikɨzir igharazibar gumazamizir ian tongɨn itiba, me da iniam. Kɨ Ikiavɨra Itir God, kɨ ian God, kɨ kamaghɨn mɨkeme.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Nɨ kamaghɨn Israelian gumazamizibav kemegh. Namba 7ɨn iakɨnim, an aruer faragha zuimɨn ia avughsɨ. Kar ian dughiar ekiar mam, egh ia sɨghabagh ivi uari akuv, egh Ikiavɨra Itir God mɨnabɨva an ziam fɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Dughiar kamɨn ia uan ingangaribar amuan markɨ. Ia ofa gamir dakozimɨn mangɨ, egh avimɨn nan ofa damu.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Egha Ikiavɨra Itir God Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Namba 7ɨn iakɨnim, an namba 10ɨn aruem, kar Gumazamizibar Arazir Kuraba Gɨn Amadir Dughiar Ekiam. Egh dughiar kamɨn ia dagheba ko agoroger araziba atakigh. Ia uari akuvagh nan ziam fɨ na mɨnabɨva na bagh avimɨn tuamin ofan tam inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Aruer kamɨn, God Gumazamizibar Arazir Kuraba Gɨn Amadir Dughiar Ekiam. Ofa gamir gumazim, ia bagh arazir kuraba gɨn amadir ofa damutɨ, kɨ Ikiavɨra Itir God, ian God, kɨ ian arazir kuraba bar da gɨn amadagham. Kamaghɨn amizɨ, ia aruer kamɨn ingaran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Eghtɨ gumazitam aruer kamɨn daghebar amɨva uan agorogeba abɨraghan koghtɨ, kɨ uan gumazamizibar tongɨn a batuegham. ");
INSERT INTO msy2020_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Eghtɨ gumazitam ingangaritam aruer kamɨn a damutɨ, kɨ uabɨ uan gumazamizibar tongɨn a mɨsueghtɨ, an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Ia oragh. Kɨ ua mɨgei, ia ingangaritam aruer kamɨn a damuan markɨ. Ia arazir kɨ ifongezir kam zurara an gɨn mangɨ. Eghtɨ ian ovavir gɨn otivigh managh ikiamiba, me uaghan an gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ia dughiar ekiar kamɨn deraghvɨra avughsɨ. Iakɨnir kam, an aruer namba 9ɨn, aruem uaghirir dughiamɨn ikegh mangɨtɨ, aruer namba 10ɨn aruem ghuaghiri dughiam otoghtɨ, dughiar kam bar moghɨra, ia an dagheba ko agoroger biziba bar da atakigh.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Ikiavɨra Itir God akar kam Israelia danɨngasa kamaghɨn Moses mɨkeme: “Iakɨnir namba 7, an aruer namba 15ɨn, kar Averpenibar Ikiamin Dughiar Ekiam. Dughiar kamɨn, gumazamiziba temer aguabar averpenibar ingaram, egh 7plan aruebar dar ikɨ Ikiavɨra Itir God gɨnɨghnɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Egh wighɨn kamɨn faragha zuir aruemɨn, ia nan ziam fɨsɨ uari akuv, egh ia uan ingangaribar amuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Egh ia wighɨn kamɨn arueba bar ia Ikiavɨra Itir God bagh ofa damuam. Egh namba 8ɨn aruemɨn, ia ua Ikiavɨra Itir God gɨnɨghnɨgh an ziam fɨsɨ uari akuv, egh an ofan avimɨn tuamiba inigh izɨ dar ofa damu. Aruer namba 8, kar Ikiavɨra Itir Godɨn ziam famin dughiam, kamaghɨn amizɨ ia uan ingangaribar amuan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Aruer kaba, kar nan dughiar ekiabara, kɨ Ikiavɨra Itir God. Ia nan ziam fɨsɨ uari akuv, avimɨn na bagh ofabar amu. Ia ofan bar isia mɨghɨriba, ko wit tuer ofa, ko wain ingamin ofa, ko ofan igharazir maba, ia ofan kaba vaghvagh dar aruebara dar amu. ");
INSERT INTO msy2020_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ia dughiar ekiar kabar gɨn mangɨ, egh uaghan nan Sabatɨn dughiabar gɨn mangɨ. Egh uaghan bizir ia zurara na ganɨdiba, ko akar dɨkɨrɨziba akɨramin ofaba, ko ofan ia uari uan ifongiabar gɨn mangɨ na danɨngamiba, ia bar da isɨ na danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ezɨ namba 7ɨn iakɨnimɨn, an dughiar namba 15ɨn, ia faragh dagher faragha aniziba inigh gɨvagh, egh ia Ikiavɨra Itir Godɨn dughiar ekiar kam damuam, an aruer namba 15ɨn ikegh, 7plan aruebar mangam. Dughiar kabar, ia averpenibar ikɨva na gɨnɨghnɨgham. Dughiar ekiar kamɨn aruer faragha zuim ko namba 8 aruemɨn, ia bar avughsɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Aruer faragha zuimɨn ia temer ovɨzir ia apibar dagher bar aghuitaba inigh. Ia temer detɨn aguaba ko temer dafarir avɨriba itibar aguaba inigh. Egh ia nan damazimɨn 7plan aruebar bar akongegh. Kɨ Ikiavɨra Itir God, ian God. ");
INSERT INTO msy2020_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Egh azeniba bar dar namba 7ɨn iakɨnimɨn, ia 7plan dughiar kaba na bagh da mɨsevegh, dughiar ekiar kam damuam. Ian ovaviba gɨn otivigh zurara arazir kabar gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ia Israelian gumazamiziba bar, 7plan aruebar averpenir muziaribar ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ia kamaghɨn damutɨ, ian ovavir borir gɨn otivamiba ganigh fogham, kɨ Isipɨn kantrin ia inigha ian akua azenan ize, egha dughiar kamɨn kɨ ia gamima, ia averpenir muziaribar iti. Kɨ Ikiavɨra Itir God, ian God, kɨ mɨkemegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Moses akar kam baregha, Ikiavɨra Itir Godɨn ziam famin dughiar ekiar a inabazibar gun Israelian gumazamizibav gei. ");
INSERT INTO msy2020_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei: ");
INSERT INTO msy2020_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Nɨ kamaghɨn Israelia mɨkemegh. Me lamɨn nan Purirpenimɨn itiba bagh olivɨn borer bar aghuim inigh izɨ. Eghtɨ ofa gamir gumaziba dɨmagaribar zurara lamɨn kabar apongtɨ da isi mamaghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Lamɨn kaba, Aron guaratɨzibar dar apong, eghtɨ dɨmagariba bar lamba isi mamaghɨra ikɨtɨ amɨnim tiragham. Lamɨn kaba, God bativamin Purirpenimɨn aven ikɨ inir ekiar Akar Dɨkɨrɨzir Gavgavimɨn Boksiam modozimɨn azenan tuivigh ikɨ nan damazimɨn isiam. ");
INSERT INTO msy2020_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Lamɨn kaba, da aghorir me golɨn aghuarimɨn ingarizim gisɨn ikɨtɨ, Aron deragh dar gantɨ, dar angazangariba mungeghan kogham, egh da Ikiavɨra Itir Godɨn damazimɨn isɨvɨra ikɨtɨ, kɨ dar ganam.” ");
INSERT INTO msy2020_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Ikiavɨra Itir God kamagh Moses mɨgei, “Ia 12 kilogrem plauan aghuiba iniva, 12plan bretɨn rubuzibar ingarigh. Ia vaghvagh bretɨn rubuzimɨn ingarsɨ, plauan osɨmtɨzir 1 kilogremɨn itim inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Egh gɨn ia bretɨn kaba isɨ, dakozir bar zuezir me golɨn aghuarimɨn an pogha a noghezir kamɨn, pozir pumuningɨn dar arɨkigh, eghtɨ 6pla vongɨn ikɨtɨ 6pla vongɨn ikɨ, egh Ikiavɨra Itir Godɨn damazimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Egh ia pauran mughuriar aghuim zuim isɨ bretɨn pozir kamningɨn boroghɨn dar arɨkigh, egh gɨn Ikiavɨra Itir God bagh avimɨn pauran kamɨn nan ofa damu, a bretɨn kabar danganim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Egh Sabatɨn dughiabar zurara ofa gamir gumazim bretɨn kam dakozim datɨghtɨ, a Ikiavɨra Itir Godɨn damazimɨn ikiam. Israelia arazir kamra gɨn mangɨ. Kar Akar Dɨkɨrɨzir Gavgavir mam, kɨ me koma a gami, eghtɨ a zurara ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Kar dagher gumazamiziba Ikiavɨra Itir God bagha avimɨn ofa gamiziba, da bar nan bizibara. Eghtɨ kɨ da isɨ Aronɨn ovavir boribar anɨngam. Kamaghɨn, bretɨn kam datɨrɨghɨn ko gɨn izamin dughiabar, an Aronɨn adarazir bret, ezɨ me bretɨn kam nan Purirpenim avɨnizir dɨvazimɨn aven aneremɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Dughiar mam, gumazir mam iti, an afeziam Isipian gumazim, an amebam Israelian amizim. Amebamɨn ziam Selomit, Selomit a Dibrin guivim, a Danɨn anabamɨn adarazir mav. Egha Selomitɨn otarir kam, a me itir danganimɨn ikia, egha Israelian gumazir mam ko mɨsosi. Aning uaning mɨsogha ghua, Selomitɨn otarim Ikiavɨra Itir Godɨn ziam dɨbora akar kuram mɨgɨa an ziam gasɨghasɨzima, me a baraki. Kamaghɨn amizɨ, me a inigha Moses bagha ghu. ");
INSERT INTO msy2020_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ezɨ Moses a isa gumazir mabagh anɨngizɨ, me kalabuzɨn mɨn a ikegha a geghuva ikia, egha Ikiavɨra Itir God mɨzuai, a manmaghɨn gumazir kam mɨkɨmtɨ, me arazir manatamɨn a damuam. ");
INSERT INTO msy2020_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Nɨ gumazir kam inigh danganir ia itimɨn azenan mangɨ. Eghtɨ gumazir a na mɨkemezir akar kuraba baraghiziba, me bar uan dafariba an dapanim darɨkigh. Me kamaghɨn damightɨ, gumazamiziba fogham, gumazir kam arazir kuram gamigha osɨmtɨzim iti. Eghtɨ gumazamiziba bar dagɨaba fɨva a mɨkɨntɨ an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Eghtɨ gɨn nɨ Israelia mɨkɨm suam: Gumazitam akar kuramɨn na mɨkemegham, an arazir kuram gamigha gɨfa, egh a uan arazir kuramɨn osɨmtɨzim ateram. ");
INSERT INTO msy2020_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Gumazitam akar kuratam mɨkɨmɨva Ikiavɨra Itir Godɨn ziam dɨponam, kamaghɨn an aremegham. A Israelian gumazimra, o ikɨzir igharazimɨn gumazamizir ian tongɨn ititam, gumazir nan ziam gasɨghasɨghamin manatam, gumazamiziba bar uari akuvagh dagɨaba fɨva gumazir kam mɨkɨnightɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Eghtɨ gumazitam gumazim o amizim mɨsueghtɨ an aremegham, eghtɨ ia uaghan a mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Eghtɨ gumazitam gumazir igharazimɨn bulmakaun mɨsueghtɨ an aremegham, a bulmakaun igharazitamɨn a ikaragh. Osɨmtɨzir kabanang akɨramin arazim a kamakɨn, gumazitam gumazir igharazimɨn asɨzim mɨsoghezɨ an areme, an asɨzir kamaghɨn garimra an asɨzim ikaragh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Eghtɨ gumazitam gumazir igharazimɨn mɨkarzim gasɨghasigham, eghtɨ ia arazir kamram a ikaragh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","A gumazir igharazimɨn agharim apɨrightɨ, ia uaghan an agharim apɨrigh. A gumazir igharazimɨn damazim gasɨghasɨghtɨ, ia uaghan an damazim gasɨghasɨkigh. A gumazir igharazimɨn atariba apɨrightɨ, ia uaghan an atariba apɨrigh. Gumazir manam bizim gamua, gumazir igharazim gasɨghasɨki, eghtɨ ia arazir kamra uam a ikaragh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Gumazim gumazir igharazimɨn asɨzim mɨsueghtɨ an aremegham, eghtɨ an asɨzir kamagh garimra a ikaragh. Eghtɨ gumazitam gumazir igharazim mɨsoghtɨ an aremegham, eghtɨ ia gumazir kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Kɨ Israelia ia ko ikɨzir igharazibar gumazamizir ian tongɨn itiba sara ia bagha Arazir kam atɨ. Kɨ Ikiavɨra Itir God, kɨ ian God, kɨ ia mɨkemegha gɨfa.” ");
INSERT INTO msy2020_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moses akar kabar gun Israelia mɨkemegha gɨfa. Ezɨ gɨn me gumazir akar kuramɨn Ikiavɨra Itir Godɨn mɨkemezir kam inigha danganir me itimɨn azenan ghu. Egha me dagɨabar a ginivizɨ an areme. Ezɨ arazir kamɨn, Israelia Akar Gavgavir Ikiavɨra Itir God Moses ganɨngizimɨn gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","2","Moses Sainain Mɨghsɨamɨn ikiavɨra itima, Ikiavɨra Itir God akar kam Israelia mɨkɨmasa a ganɨngi: “Ia gɨn nguazir kɨ ia danɨngasa mɨkemezir kamɨn mangɨ an otivigh, egh zurara namba 7ɨn azenimɨn, ia nguazir kamɨn dagheba oparan markɨ. Ia nguazim ateghtɨ, a pura ikɨ. Ia Sabatɨn dughiabar avughsi moghɨn, nguazim uaghan avughsam. Ia kamaghɨn damuva mɨkɨm suam, namba 7ɨn azenim, a Ikiavɨra Itir Godɨn azenimra, kamaghɨn nguazim avughsi. ");
INSERT INTO msy2020_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ia 6plan azenibar, dagheba uan nguazimɨn da opar, egh wainɨn ikarɨzibar agharibar ghorɨva azenibar dagheba iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Egh ia namba 7ɨn azenimɨn, ia nguazim ateghtɨ, an avughsɨ. Egh ia azenir kam na bagh a anemɨseveghtɨ a Ikiavɨra Itir Godɨn Sabatɨn azenimɨn ikiam. Kamagh amizɨ, ia azenir kamɨn dagheba oparan markɨ, egh ia uan wainɨn ikarɨzibar aghariba aghoran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Eghtɨ witɨn taba puram otivigham, ia dar ovɨziba inighɨva dagher dɨpenimɨn dar arɨghan markɨ. Egh wainɨn ovɨziba pura dar agharibar otivightɨ, ia da inigh wainɨn ingaran markɨ. Bar markiam. Azenir kamɨn nguazim deraghvɨram avughsam, kamaghɨn, ia aneteghtɨ a pura ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Eghtɨ azenir kamɨn dagheba pura ian nguazimɨn otivtɨ, ia dar amɨ. Ia da isɨ dagher dɨpenimɨn dar arɨghan markɨ, egh wainbar amuan markɨ. Ia ko, ingangarir gumazir kɨniba ko ingangarir amizir kɨniba, ko ingangarir gumazir igharaziba, ko ikɨzir igharazibar gumazamizir ian tongɨn itiba, ia bar dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Egh bulmakauba, sipsipba, memeba, ko asɨzir atiaba sara ia dar amɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia 7plan dughiabar, 7plan azeniba meng mangɨ, kamaghɨra damu mangɨ 49plan azenibar otogh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Egh ia azenir 49ɨn, an namba 7ɨn iakɨnim, an dughiar namba 10ɨn, ia gumazitaba ameghtɨ me ian nguibaba bar dar mangɨ sɨghabagh ivi. Kar Dughiar Ekiar Gumazamizibar Arazir Kuraba Gɨn Amadim. ");
INSERT INTO msy2020_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Namba 50ɨn azenimɨn ia datɨrɨghɨn sɨghabagh iviamin dughiamɨn ikegh mangɨ azenir vamɨran tugham, ia a damutɨ, a nan azenimra ikɨ. Eghtɨ ia gumazamizibav mɨkɨm suam, me azenir kamɨn fɨrighɨreghtɨ men osɨmtɨziba gɨvaghtɨ me deraghvɨra ikiam. Azenir kamɨn, gumazir gumazir igharazibar nguazibagh ivezeziba, me vaghvagh ua nguazir kaba isɨ dar guizɨn ghuavibar anɨngigh, o men adarazir anɨngigh. Eghtɨ ingangarir gumazamizir kɨniba, me vaghvagh ingangarir kam ategh, ua uan adarazi baghvɨra mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Guizbangɨra, namba 50ɨn azenimɨn, gumazamiziba deraghvɨra dapiagh avughsɨ bar akuegham. Egh azenir kamɨn ia uan nguazibar dagheba oparan markɨ, egh ia witɨn puram otivibar ghor da akuvan markɨ. Egh ia wainɨn dɨpabar ingarsɨ, wainɨn ovɨziba inian markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Azenir kam, ia deraghvɨra dapiagh avughsɨ bar akongegh bar a gɨnɨghnɨgh, kar bar nan azenimra. Egh ia pura nguazimɨn otivir daghebara damɨ. Ia dagher igharazibar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Eghtɨ azenir kamɨn gumazir nguaziba isa igharaz darazir da amangiziba, ia ua me dama uan nguaziba iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","15","Kamaghɨn, ia nguazim isa gumazir igharazimɨn amadazɨ, o a da nguazim givese, egh ia uarigh ifaran kogham. Ia nɨghnɨgh, azeniba manmaghɨn ikiavɨra iti, eghtɨ bar akongamin azenim otoghtɨ ia ua bizir kaba ikarvagham, egh manmaghɨn dughiabar an oparɨva dagheba iniam. Ia bar deraghvɨra nguazir kamɨn dagheba iniamin azenir ikiavɨra itibar ivezim givesegh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Eghtɨ azenir avɨriba ikɨvɨra ikɨtɨ, dar nguazimɨn ivezim mavanang. Eghtɨ azenibar dɨbobonim oteveghtɨ, nguazimɨn ivezim magɨrɨ. Guizbangɨra, a guizɨn nguazim givezezir pu. Puvatɨ, a nguazir kamɨn otivir daghebagh ivese. A nguazir an agharimɨn ikiavɨra itir kamɨn azeniba mengɨva, an azenir kabar nguazir kamɨn otivir daghebagh ivezam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ia uari uan namakatam gifaran bar markɨ. Ia uan Godɨn atiating, egh arazir aghuibara damu. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkeme.” ");
INSERT INTO msy2020_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia deraghvɨra arazir kɨ ifongeziba ko bizir kɨ damuasa ia mɨkemezibar suiragh dar gɨn mangɨ, egh ia deraghvɨra nguazir kɨ ia danɨngamin kamɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Eghtɨ dagher avɨrim nguazimɨn otivtɨ, ia zurara dagher avɨribar amɨ mamaghɨra ikiam. Egh ia bar deraghvɨra nguazir kamɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Egh ia ua kamaghɨn mɨkɨm suam, ‘Namba 7ɨn azenimɨn e dagheba oparan kogham, egh dagher aniziba inigh da akuvan kogham. Egh e kamaghɨn damuan kogh, e azenir kamɨn tizim amam?’ ");
INSERT INTO msy2020_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Markɨ, ia mɨghɨn nɨghnɨghan markɨ. Kɨ Ikiavɨra Itir God, kɨ namba 6ɨn azenimɨn bar deragh nguazim damightɨ, dagher avɨriba otivtɨma ia damɨ mangɨ 3plan azenibar tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Egh ia namba 8ɨn azenimɨn dagheba opar, egh ia namba 6ɨn azenibar inizir daghebar amɨvɨra ikiam. Egh ia dagheba ikɨvɨra ikɨ mangɨ, ia dagher igiaba iniamin dughiam otogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Gumazir igharazitam ia da nguazim givezegh, dughiar ruarimɨn an suighan markɨ. Kar guizbangɨra ian nguazim puvatɨ. Kar Ikiavɨra Itir Godɨn nguazim, ezɨ kɨ Israelia ian taghizɨ ia an iti, mati gumazamiziba nguibar igharaziba ataghizɨ me men nguazibar iti. ");
INSERT INTO msy2020_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","“Eghtɨ ian gumazitam, ian namakar igharazitam da nguazim givesɨ, a deraghvɨra fogh, eghtɨ gɨn nguazir kamɨn guizɨn ghuavim ua nguazim givesɨ, a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Eghtɨ ian gumazitam bar biziba puvatɨgh, dagɨaba bagh gumazir igharazim ateghtɨ, an an nguazim givezeghtɨ, an anabar gumazim an akuragh a givesɨ pura ikɨ, egh nguazir kam uam a givezegh uam a danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Eghtɨ gumazir kamɨn akuragh uam a givezamin anabamɨn gumazamiziba puvatɨghtɨ, a uabɨ gɨn dagɨar avɨriba itir dughiam, a ua nguazir kam givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","A biziba ua da ikarvaghamin azenim gɨfoghsɨ, an azeniba meng, da manmaghɨn ikiavɨra iti. Egh an azenir kamɨn dagher nguazir kamɨn otivamiba bar dar ivezimɨn dɨbobonim manmaghɨn otogham. Egh a dagɨaba inigh dagher kaba bagh, gumazir fomɨram an nguazim givezezim a danigh, ua nguazir kam iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Egh an dagɨaba oteveghtɨ, a nguazir kam uam a givezeghan kogham, kamaghɨn gumazir fomɨram an nguazim givezezim, nguazim an dafarimɨn ikɨ mangɨtɨ azenir ua biziba ikarvaghamim otogham. Eghtɨ azenir kam otoghamin dughiamɨn, gumazir nguazir kam givezezim, a ua nguazir kam isɨ an ghuavimra danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Eghtɨ gumazitam nguibar ekiam avɨnizir dɨvazimɨn aven uan dɨpenim anemadazɨ, gumazir igharazim a givese, ezɨ dɨpenimɨn ghuavim ua uan dɨpenim givezamin azenir vamɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Eghtɨ azenir vamɨra mangɨgh gɨvaghtɨ, a ua dɨpenir kam givezeghan kogham, a datɨrɨghɨn uam ivezamin tuaviba puvatɨ. Bar puvatɨ. Eghtɨ datɨrɨghɨn dɨpenir kam, a gumazir a givezamin dɨpenim, ko an ovavir borir gɨn otivamiba, a gɨn men dɨpenimɨn ikiam. Egh azenir biziba ua da ikarvaghamin dughiamɨn, a uam a danɨngan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Eghtɨ nguibar dozir dɨvaziba puvatɨziba, dar aven itir dɨpeniba, ia kamaghɨn nɨghnɨgh suam, da mati nguazir dagheba oparim. Kamaghɨn, dɨpenibar ghuaviba ua dɨpenir kabagh ivezam. Eghtɨ azenir ua biziba ikarvaghamimɨn, gumazir dagh ivezeziba, ua da isɨ guizɨn dɨpenir ghuavibar anɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Eghtɨ Livain anabamɨn adarazi arazir kamɨn gɨn mangan markɨ. Me, dɨvazim avɨnizir nguibar ekiamɨn itir dɨpenim uam a givesɨ, me a givesegh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Egh Livain anabamɨn tav uan dɨpenim amadagh, egh uam a givezan aghuaghtɨ, gumazir dɨpenir kam givezezim, azenir biziba ua da ikarvaghamimɨn, a ua dɨpenim isɨ Livain gumazir kam danɨngigh. Guizbangɨra, kɨ Israelian anabar igharaziba bagha nguazibagh inamigha me ganɨngi. Ezɨ Livain anabam puvatɨ. Kɨ Israelian anabar igharazibar nguazibar tongɨn, nguibar ekiar maba isa Livaibagh anɨngi. Kamaghɨn amizɨ, dɨpenir Livain nguibar ekiamɨn itiba, da dughiabar zurara Livain dɨpenibara. ");
INSERT INTO msy2020_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Egha uaghan, nguazir Livain anabamɨn nguibar ekiabar mɨriamɨn boroghɨn itiba, gumazir igharaziba dagh ivezan markɨ. Kar Livaibar nguazibara.” ");
INSERT INTO msy2020_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ian namakabar tav, onganarazibagh amir gumazimɨn mɨn ikɨva, bizibagh ivezamin dagɨaba puvatɨghtɨ, ia uari an akurvagh, mati ia ikɨzir igharazibar gumazamizir ian tongɨn itibagh ami moghɨn, an akurvagh. Kamaghɨn, ian namakar kam ia ko ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","37","Egh a pura ia da dagɨaba inigh, egh ua dagɨar iniziba ikarvaghsɨ, ia ua dagɨatam dagh isɨn darɨghan markɨ. Eghtɨ a daghebagh iveztɨ, ia ua dagɨataba daghebar ivezim gisɨn darɨghan markɨ. Ia Godram atiating, egh uan namakaba ateghtɨ me ian tongɨn ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kɨ, Ikiavɨra Itir God, ian God, kɨ kamaghɨn ia mɨkemegha gɨfa. Kɨ ian Godɨn ikiasa, egha kamaghɨn, kɨ Isipɨn kantrin ia inigha ian akua azenan iza, Kenanɨn nguazim ia danɨngasava ami.” ");
INSERT INTO msy2020_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Gumazitam onganarazibar amuva, ia ateghtɨ ia ingangarir gumazir kɨnimɨn mɨn a givezegh, egh pazɨ a damutɨ a ingangarir gumazir kɨnimɨn mɨn ian apengan ikɨ ingaran markɨ, mati ikɨzir igharazibar ingangarir gumazir kɨnibar mɨn ia bagha ingari. ");
INSERT INTO msy2020_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","A mati gumazir dagɨaba bagha ingarimɨn mɨn ia ko ikɨ, egh ian ingangaribar amu mangɨtɨ azenir ua biziba ikarvaghamim otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Egh azenir kamɨn a uan amuim ko boriba sara, me fɨrighɨregh ia ategh ua uan adarazi bagh mangɨ, uan inazir afeziabar nguazimɨn ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Bizir kamɨn mɨngarim kamakɨn. Fomɨra ia Israelia, kantri Isipɨn ingangarir gumazamizir kɨnibar itima, kɨ ia inigha azenan izezɨ ia bar Isip ataki. Kamaghɨn amizɨ, ia nan ingangarir gumazamizibar mɨn otifi. Kamaghɨn, ia uan namakabagh ivezeghtɨ, me dughiabar zurara ingangarir gumazamizir kɨnibar mɨn ikian kogham. Bar markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Kamaghɨn amizɨ, ia uan namakar ia ivezeziba, puvɨra me abɨn me damutɨ, me bar osɨmtɨzir dafaba sara ingangarir ekiabar amuan markɨ. Ia nan atiating, kɨ ian God, egh ia deraghvɨram me damu. ");
INSERT INTO msy2020_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Egh ia ingangarir gumazamizir kɨniba inisɨ, ikɨzir igharazir ian boroghɨn itiba da me inigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Egh ia uaghan ikɨzir igharazibar gumazamizir ian tongɨn ikia boriba bateziba, ia ingangarir gumazamizir kɨniba, me da dagh ivezam. Ia deragh me givezeghtɨ, me guizbangɨra ian ingangarir gumazamizir kɨnibar mɨn otifigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Eghtɨ ia gɨn arɨmɨghireghtɨ, ian ovavir boriba ingangarir gumazamizir kɨnir kaba inightɨ, me zurara ian ovavir boribar ingangaribar amu mangɨvɨra ikiam. Me iananaba. Eghtɨ ian namakabara, ian ingangarir gumazamizir kɨnibar otivightɨ, ia paza me damu me gativan markɨ. Ia deraghvɨra me damu. ");
INSERT INTO msy2020_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Eghtɨ ikɨzir igharazibar gumazamizir ian tongɨn itibar tav, dagɨaba bar izɨvagham, eghtɨ ia Israelia, ian tav onganarazibagh amir gumazimɨn mɨn otoghɨva, a ikɨzir igharazimɨn gumazir kam ateghtɨ an a givezeghtɨ, an an ingangarir gumazir kɨnimɨn mɨn ikiam, o gumazir kamɨn tavɨn ingangarir gumazimɨn mɨn otogham. ");
INSERT INTO msy2020_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Israelian gumazir kam kamaghɨn damigham, eghtɨ ia uam a givezeghtɨ, kamaghɨn deragham. An aveghbuatam, ");
INSERT INTO msy2020_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","o an afeziar dozim, o namakatam o anabatam, uam a givezeghtɨ deragham. Eghtɨ a uabɨ dagɨataba inigh, uabɨ uabɨ givezegh, egh ingangarir kurar kam atakigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Gumazir kam, ikɨzir igharazimɨn gumazir a givezezim ko deraghvɨra nɨghnɨgh uaning kɨmɨva fogh suam, azenir ikiavɨra itiba me da meng mangɨ azenir ua biziba ikarvaghamimɨn tugham. Eghtɨ gumazir, ingangarir gumazir kam givezezim suam, gumazir azenir kabar ingarir dagɨabar ivezimɨn dɨbobonim manmakɨn. Eghtɨ gumazir kam uabɨ, o an anabatam ivezir kamaghɨn garimra uam a givesegh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Eghtɨ azenir avɨriba ikɨvɨra ikɨtɨ, gumazir kam dagɨar bar ekiamɨn ua gumazir a givezezir kam danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Eghtɨ azenir avɨriba ikian koghtɨ, azenir biziba ua da ikarvaghamim otoghtɨ, a dagɨar muziarim isɨ ua gumazir kam danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Eghtɨ ikɨzir igharazimɨn gumazir kam kamaghɨn ingangarir gumazim gɨnɨghnɨgh suam, a mati azenibar vaghvagha a ko ikia dagɨaba bagha ingarir gumazim, egh a puv a mɨkɨmɨva, anebɨn pazɨ a damuan markɨ. An an asughasugh nɨmɨram a damu. ");
INSERT INTO msy2020_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Eghtɨ me arazir kabar gɨn mangɨ, ua gumazir kam givezan kogham. Eghtɨ azenir biziba ua da ikarvaghamim otoghtɨ, gumazir a givezezim aneteghtɨ, a fɨrighɨrɨgh mangɨva uan amuim ko boriba sara deraghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","“Kɨ Ikiavɨra Itir God, ian God, kɨ Isipɨn kantrin ia inigha azenan ize. Kamaghɨn, ia Israelia, ia nan ingangarir gumazamizibar mɨn iti. Kamaghɨn amizɨ, ia uan tav ateghtɨ, a dughiabar zurara ingangarir gumazir kɨnimɨn ikian markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ikiavɨra Itir God kamaghɨn mɨgei, “Ia temer oteviba inigh dar asebar nedazibar ghoran markɨ, ia guarir akɨnitam inigh uan nguazimɨn anesaragham, o dagɨatam inigh dɨghoriba a darightɨ da ian asebar marvir guabar mɨn gantɨ, ia marvir guar kabar ziaba fan markɨ, da gavgaviba pu. Puvatɨ. Kɨ Ikiavɨra Itir God, ian God, ia nan ziamra fɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kɨ ia bagha mɨsevezir Sabatɨn dughiabar, ia ingaran markɨ. Ia puram avughsɨ. Egh ia bar nan Purirpenim gifongegh a baghvɨra ikɨ. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn ia mɨkemegha gɨfa. ");
INSERT INTO msy2020_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Egh ia nan arazir kɨ ifongezibar gɨn mangɨ, nan Akar Gavgaviba baragh, egh dar amu, ");
INSERT INTO msy2020_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","eghtɨ kɨ amozim damutɨ, a uan izir dughiamra izam. Eghtɨ kɨ ian daghebar amutɨ, da deraghvɨra ian nguazimɨn otivtɨ, temeba bɨva ovɨzir avɨriba ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ia dagher bar avɨriba ikɨva, egh witɨn andɨziba ini mangɨ, ia wainɨn ovɨzir anɨdiziba iniamimɨn dughiamɨn tugham. Egh ia wainɨn ovɨziba ini mangɨ, dughiar ia dagheba oparamimɨn tugham. Ia damɨva naviba bar izevegham. Egh ia deraghvɨra uan nguazim dapiagham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Eghtɨ kɨ navir amɨrizim ia danightɨ ia deraghvɨra dapiagh, egh dakuamin dughiamɨn, ia bizitamɨn atiatingan kogham. Kɨ asɨzir atiar mɨsoziba ian nguazimɨn da batueghtɨ apaniba nguazir kamɨn ia mɨsoghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Eghtɨ ia apanibav sogh me abɨntɨ, men avɨrim ian damazimɨn arɨghiram. ");
INSERT INTO msy2020_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Ian 5plan mɨdorozir gumaziba 100plan apaniba abɨnigham. Eghtɨ ian 100plan mɨdorozir gumaziba 10,000plan apaniba abɨnigham. Guizbangɨra, ian apaniba bar ian damazimɨn arɨghiregham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Eghtɨ kɨ deraghvɨra ia damuva borir avɨriba ia danɨng, egh ia damutɨ, ia bar avɨrasemegham. Eghtɨ Akar Dɨkɨrɨzir Gavgavir kɨ fomɨra ia ko amizir kam, kɨ gavgavim a danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Eghtɨ azenir gɨvazimɨn dagheba, da ikɨvɨra ikɨ mangɨ azenir igharazim batogham. Eghtɨ dagher naba ikɨvɨra ikɨtɨ, ia dagher igiar andɨziba iniva, ghuriba makunigh, egh dagher igiaba dar danganim darɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Eghtɨ kɨ ian tongɨn ikɨvɨra ikɨ, akɨrim ragh ia gasaraghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Kɨ ian tongɨn daruva ian Godɨn ikiam. Eghtɨ ia nan gumazamizibar ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Kɨ uabɨ Ikiavɨra Itir God, kɨ ian God. Ia fomɨra Isipɨn kantrin aven ingangarir gumazamizir kɨnibar ikezɨ, kɨ ian osɨmtɨzim agɨvagha ian akua azenan ize. Kɨ ia isa kalabus gatɨzir gumazibar gavgaviba abɨghizɨ, ia kalabus ategha bar akongegha ize.” ");
INSERT INTO msy2020_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Ikiavɨra Itir God ua kamaghɨn mɨgei, “Ia nan akaba baraghan aghuagh, egh nan Akar Gavgavir kabar gɨn mangan koghtɨ, kɨ ivezir kuram ia danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Ia akɨrim ragh nan arazir kɨ ifongezibagh asaragh, nan bizir kɨ damuasa ia mɨkemezibar aghuaghɨva, nan Akar Gavgaviba baraghan koghɨva, egh nan Akar Dɨkɨrɨzir Gavgavir kɨ ia ko amizir kam abightɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","kamaghɨn kɨ bizitamɨn ia damuam. Kɨ zuamɨra ia damightɨ, ia bar ikuvigh bar atiatigham. Kɨ ia damutɨ, ia arɨmariar bar ekiaba iniva, ian mɨkarziba puv fengtɨ, ian damaziba okavightɨ, ian mɨkarziba nɨmɨra su magɨrɨ mangɨ bar ikuvigham. Ia azenibar dagheba opar, egh ia dar daghebar aman kogham. Apanibara, da ini dar amam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Egh kɨ uabɨ ian apanim damuam. Kɨ gumazir igharaziba amadaghtɨ, me izɨ ia mɨsogh ia dɨkabɨnam. Eghtɨ gumazir kaba ia gativagham. Apaniba tɨghar ia bagh izɨ ia gɨntɨghamin dughiamɨn, ia puram atiating aregham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Bizir kurar kabar gɨn, ia nan akam baraghan aghuavɨra ikɨtɨ, kɨ ian arazir kuraba bagh osɨmtɨzir avɨrim ia darɨghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Egh kɨ ian ifaghatir arazimɨn gavgavim bar anebɨragham. Kɨ amozimɨn tɨvaghtɨ a ian nguazim gizan kogham, eghtɨ nguazim bar mɨsigh ainɨn mɨn gavgavigham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Eghtɨ dagheba ian nguazimɨn otivan koghtɨ, ian temeba ban kogham. Kamaghɨn, ia kamaghɨn fogh suam, ian ingangarir ekiam pura mangɨ gɨvagham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Osɨmtɨzir kaba ia bativtɨ, ia oraghan koghtɨ, kɨ ian arazir kurar kabagh nɨghnɨgh, egh kɨ osɨmtɨziba ia darɨghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","“Egh kɨ asɨzir atiaba ian tongɨn da amangtɨ, da ian boriba ko bulmakaubav soghtɨ da arɨmɨghiram. Eghtɨ gumazir avɨriba ikian kogh nguibamɨn tuavibar aruan koghtɨ, gumazamizir vabara ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Osɨmtɨzir kaba ia bativightɨ, ia uan nɨghnɨzibagh iraghan aghuagh, nan akaba baraghan koghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","kɨ ian arazir kurabagh nɨghnɨgh, ua dughiar bar avɨribar ua ia ikaragh, ivezir bar kuram ia danɨng, egh bar puvɨra ia damuam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ia nan Akar Dɨkɨrɨzir Gavgavim abightɨ, kɨ apaniba amadaghtɨ me ia mɨsogham. Eghtɨ ia ti mangɨ nguibar ekiar dɨvazir gavgaviba itibar aven mangɨtɨ, kɨ arɨmariar kurar ekiaba ia bagh da amangɨtɨ, gumazamizir avɨrim arɨmɨghiregham. Eghtɨ ia ikuvamin dughiamɨn, kɨ ia isɨ apanibar dafarim darɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Egh kɨ ian daghebar tɨvaghtɨ, ia daghebar oteveghtɨ ian amiziba dagher avɨriba avimɨn da tuan kogham. Eghtɨ bretba tuer danganimɨn avir vamɨra, 10plan amiziba uan dagheba tuam. Eghtɨ ia bar bretɨn muziariba ini dar amɨtɨ mɨtiriam ian aghɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Eghtɨ kɨ bizir kabar amutɨ, ia akɨrim na gasaraghvɨra ikɨva, egh ua nan akaba batoghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","kɨ bar anɨngaghegh, ian arazir kuraba bangɨn, dughiar bar avɨribar osɨmtɨzir bar ekiaba ua ia darɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mɨtiriam puvɨra ian aghɨtɨ, ia uari uan otariba ko guivibav sogh dar amam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Eghtɨ kɨ uan navir averiamɨn aven ian anɨngaghegh, ia mɨghsɨamɨn pɨn ingarizir danganir asebar ziaba febagh asɨghasɨgh, ian ofan mɨgharir mughuriar aghuim zuibagh amir ofa gamir dakoziba apɨrigham. Egh kɨ ia mɨsuegh ian kuaba isɨ marvir guar kɨ asɨghasɨghizir kabagh isɨn da kunigham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kɨ ian nguibar ekiaba ko dɨpenir ia asebar ziaba febagh asɨghasɨgh, ian ofabagh ifueghan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Egh kɨ ian nguazim bar a gasɨghasightɨ, ian apaniba nguazir kam inigh a dapiagh an gantɨ, a ikuvightɨ, me dɨgavir kuram damigham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kɨ apaniba amadaghtɨ, me ia mɨsogh ia batueghtɨ ia tintinibar kantrin igharazibar mangegham. Eghtɨ ian nguazim uaghan gumazamiziba puvatɨgh pura ikiam, eghtɨ nguibar ekiaba ikuvigh ikiam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","“Eghtɨ ia apanibar kantrin ikiamin dughiamɨn, ian nguazir kam pura avughsɨ ikiam. Ia fomɨra nguazir kamɨn ikia egha nguazim ataghizɨ, a zurara namba 7ɨn azenibar avughsir puvatɨ, mati kɨ ia mɨkemezɨ mokɨn. Egh nguazim pura ikiamin dughiamɨn, a deraghvɨram avughsam, egh nguazim dughiar kam bagh bar akongegham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","37","Eghtɨ ian varazira mɨdorozimɨn arɨmɨghireghan kogh, egh mangɨ apanibar kantrin ikiam. Eghtɨ kɨ ia damutɨ ia bar puvɨram atiating, egh ia oraghtɨ, amɨnim temer dafaribagh ivangtɨ, da tɨngaghɨtɨ, ia da baregh puram atiating aregham, mati apaniba gumazibar agɨntɨzima me ari. Eghtɨ apaniba ian gɨntɨghan kogham, ia puram arɨ mangɨ tintinibar uarir ghuanang daghiram. Eghtɨ apaniba ti ia ko mɨsoghtɨ, ia me ko mɨsoghamin gavgaviba puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kamaghɨn, ia ikɨzir igharazibar tongɨn ikɨva apanibar nguazimɨn arɨghiregham, kar mati men nguazim ia tui. ");
INSERT INTO msy2020_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ia ko ian inazir afeziaba amizir arazir kuraba bangɨn, ia osɨmtɨzim ikiam, kamaghɨn amizɨ, ian ikɨvɨra ikiamin varazira, apanibar nguazimɨn ikɨvɨra ikɨ, egha bar kuvaremeghsɨ damuam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Eghtɨ gɨn ian ikɨvɨra ikiamin varazira, me uan arazir kurabagh nɨghnɨgh dar gun na mɨkɨmam. Egh me kamaghɨn mɨkɨm suam, ‘E uan inazir afeziaba ko arazir kuram gami. E nɨ barazir puvatɨgha nɨn akaba batoke.’ ");
INSERT INTO msy2020_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Guizbangɨra, ia akɨrim ragha na gasarazɨ, kɨ osɨmtɨzim ia ganigha, ian apanibar nguazimɨn ia amada. Eghtɨ ian adarazi uan arazir akaba batozim ateghɨva, uari abɨnigh, egh uan arazir kurabar ivezir kuram inigh gɨvaghtɨ, ");
INSERT INTO msy2020_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","kɨ ua uan Akar Dɨkɨrɨzir Gavgavim ko nguazir kam ginɨrɨgham. Akar Dɨkɨrɨzir Gavgavir kam, kɨ Abraham, Aisak, Jekop ko a gamua ghaze, kɨ nguazir kam isɨ men ovavir boribar anɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ia faragh nguazir kam ateghtɨ, a pura dughiar ruarimɨn avughsɨ. Ia faragha nguazir kamɨn ikia egha nguazim ataghizɨ, a zurara namba 7ɨn azenibar avughsir puvatɨ. Eghtɨ nguazim pura ikiamin dughiamɨn, a deraghvɨram avughsɨ bar akuegham. Ia faragha akɨrim ragha bizir kɨ damuasa ia mɨkemezibagh asaragha, nan arazir kɨ ifongeziba bar dar aghua. Bizir kam bangɨn, ia osɨmtɨzim ater egh ivezir kuram iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Egh ia apanibar nguazimɨn ikɨtɨ, kɨ bar ia ateghan kogh, bar ia gasɨghasɨghan kogham. Bar puvatɨ. Kɨ fo, kɨ kamaghɨn damightɨ, Akar Dɨkɨrɨzir Gavgavir kɨ ia ko amizir kam, a gɨvagham. Kɨ Ikiavɨra Itir God, ian God, kɨ arazir katam damighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Egh kɨ ia gɨnɨghnɨgh egh Akar Dɨkɨrɨzir Gavgavir kɨ ian inazir afeziaba ko amizim uam a ginɨrɨgham. Kar gumazir kɨ fomɨra Isipɨn kantrin inigha men akua azenan izeziba. Ezɨ ikɨzir igharazibar gumazamiziba nan gavgavir ekiamɨn gani. Kɨ ian Godɨn ikiasa, kamaghɨn amizɨ, kɨ ua bagha ia inigha ize. Kɨ Ikiavɨra Itir God.” ");
INSERT INTO msy2020_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ikiavɨra Itir God, bizir a damuasa Israelia mɨkemezir kaba, ko arazir a ifongeziba, ko an Arazir kaba, a Sainain Mɨghsɨamɨn bar da isa Moses ganɨngi. Egha ghaze, Israelia bar dar gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","2","Ikiavɨra Itir God, Israelia mɨkɨmasa kamaghɨn Moses mɨgei, “Gumazitam uabɨ isɨ na danɨngɨsɨ, o gumazamizir igharazitam isɨ na danɨngasa akar dɨkɨrɨzim na koma a gami, a uan akar dɨkɨrɨzimɨn gɨn mangɨsɨ, a dagɨataba isɨ ofa gamir gumazim danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Gumazamiziba uarigh ivezamin dagɨar dɨbobonim kamakɨn. Gumazir 20plan azenibar ikegh mangɨ 60plan azenibar tughamim, me 500 kinan a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Egh amizir 20plan azenibar ikegh mangɨ 60plan azenibar tughamim, me 300 kinan a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Egh otarir 5plan azenibar ikegh mangɨ 20plan azenibar tughamim, me 200 kinan a givezam. Eghtɨ amizir 5plan azenibar ikegh mangɨ 20plan azenibar tughamim, me 100 kinan a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Egh otarir iakɨnir vamɨran ikegh mangɨ 5plan azenibar tughamim, me 50 kinan, a givezam. Eghtɨ borir guivir iakɨnir vamɨran ikegh mangɨ 5plan azenibar tughamim, me 30 kinan a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Eghtɨ gumazir 60plan azenibagh afirazim, me 150 kinan a givezam. Eghtɨ amizir 60plan azenibagh afirazim, me 100 kinan a givezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“Eghtɨ gumazir akar dɨkɨrɨzim gamizim, a uabɨ uabɨ givezamin dagɨaba, o uan namakam givezamin dagɨaba puvatɨgh, gumazir kam ofa gamir gumazim bagh mangɨ. Eghtɨ ofa gamir gumazim ivezir kam gisɨvagh magɨrɨ gumazir kam damuamin ababanimɨn tughtɨ, gumazir kam ivezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Eghtɨ gumazim asɨzitam isɨ, kɨ Ikiavɨra Itir Godɨn ofa damusɨ akar dɨkɨrɨzim damigh, an asɨzir kɨ ia mɨkemezir katamɨn ofa damu. Guizbangɨra, ia ofa damuamin asɨziba, da bar nan bizibara. ");
INSERT INTO msy2020_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Gumazir kam asɨzir aghuir kam ategh kuratamɨn ofa damuan markɨ. An asɨzir kuram inigh, aghuimɨn danganimɨn ofa damuan markɨ. A tam isɨ tamɨn danganim datɨghtɨ, asɨzir kamning vɨrara nana. ");
INSERT INTO msy2020_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Egh a nan damazimɨn mɨzezir asɨzitam na danɨngɨsɨ akar dɨkɨrɨzim damigh, egh asɨzir kamɨn nan ofa damuan kogham, kamaghɨn an asɨzim inigh ofa gamir gumazim bagh mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Eghtɨ ofa gamir gumazim an ganam, a deraz o a ikufi, egh an ivezimɨn ababanim dɨponam. Eghtɨ ivezir kam kamaghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Eghtɨ gumazir kam uam asɨzir kam givesɨ, a ua dagɨataba inigh egh ofa gamir gumazim dɨborozir dagɨaba sara inigh izɨ. Ofa gamir gumazim 5 kina dɨboroghtɨ, a 6 kinan ivezam. O, ofa gamir gumazim 10 kina dɨboroghtɨ, a 12 kinan ivezam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Eghtɨ gumazitam uan dɨpenim isɨ Ikiavɨra Itir God danɨngtɨ, ofa gamir gumazim dɨpenir kamɨn ganam, a deraz, o a ikufi, egh ofa gamir gumazim ivezimɨn ababanim dɨboroghtɨ, ivezir kam kamaghɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Eghtɨ gumazir uan dɨpenim isa Ikiavɨra Itir God ganɨngizim, a gɨn uam a givezeghtɨ, kamaghɨn a dɨpenimɨn ivezim ko ua dagɨataba sara a danɨngigh. Ofa gamir gumazim dɨpenir ivezim 100 kinan anetɨghtɨ, gumazir kam 120 kinan ivezam. A dagɨar kaba isɨ ofa gamir gumazim danigh, egh a ua uan dɨpenim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Eghtɨ gumazitam, uan inazir afeziabar dafarim da nguazir otevitam inigh, egh gɨn a uan nguazir otevir kam isɨ na danɨngtɨ, ofa gamir gumazim nguazir kam tuisɨgh, me manmaghɨn balin ovɨziba nguazir kamɨn da oparam. Egh me ti 20 kilogrem balin ovɨziba oparam, eghtɨ nguazimɨn ivezim, a 100 kinan tugham. ");
INSERT INTO msy2020_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Gumazir kam, azenir ua biziba ikarvaghamimɨn gɨn nguazir kam na danightɨ ivezim kamaghɨra ikɨ, egh a gɨghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Egh an azenir ua biziba ikarvaghamimɨn gɨn, azenir tabar gɨn, a na danɨngam, eghtɨ ofa gamir gumazim gɨn izamin azenir ua biziba ikarvaghamim bativsɨ, azenir ikiavɨra itiba mengegh, egh a nguazir kamɨn ivezim gisɨvagh magɨrɨgh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Eghtɨ gumazir uan nguazim na ganɨngizir kam, a ua nguazim givesɨ, a dagɨabar uam a givezam. Eghtɨ ofa gamir gumazim 100 kinan ivesɨ a mɨkɨmtɨ, a 120 kinan ua ivezam. A dagɨar kaba isɨ ofa gamir gumazim danigh, egh ua uan nguazim iniam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","A faragh na da ua nguazir kam givezeghan kogh, egh nguazir kam isɨ gumazir igharazimɨn amadagh, egh a gɨn uabɨ uam a givezan kogham. ");
INSERT INTO msy2020_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Eghtɨ azenir ua biziba ikarvaghamim otoghtɨ, gumazir nguazir kam givezezim, a isɨ na danɨngigh. Eghtɨ nguazir kam, a nan nguazimra ikɨ mamaghɨra ikiam. A na baghvɨra ikiam. Eghtɨ kɨ nguazir kam isɨ ofa gamir gumazibara, me danɨngam. ");
INSERT INTO msy2020_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Eghtɨ gumazitam nguazir otevitam ikiam, kar nguazir an inazir afeziaba a ganɨngizir puvatɨzim, a faragha gumazir igharazim dama a givese, egh a nguazir kam inigh Ikiavɨra Itir God danɨngasa. ");
INSERT INTO msy2020_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Eghtɨ ofa gamir gumazim, azenir ua biziba ikarvaghamim bativsɨ, an azenir ikiavɨra itiba meng. Egh an azenir kaba bagh nguazir kamɨn ivezimɨn ababanim atɨghtɨ, aruer kamra gumazim nguazir kamɨn dagɨaba isɨ ofan gumazim danɨngam. Eghtɨ dagɨar kaba, da Ikiavɨra Itir Godɨn dagɨabara. ");
INSERT INTO msy2020_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Eghtɨ azenir ua biziba ikarvaghamimɨn, gumazir kam nguazir kam uam a isɨ an guizɨn ghuavim danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Eghtɨ ia bizir kabar osɨmtɨzim ko ivezim bar deraghvɨra dar pon. ");
INSERT INTO msy2020_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Asɨzir nguzir ivariaba da bar nana, kamagh amizɨ, ia ofan tam na danɨngɨsɨ, asɨzir nguzir ivariaba inian markɨ. Bulmakaun nguzir ivariam, o sipsipɨn nguzir ivariam, da bar nana. ");
INSERT INTO msy2020_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Eghtɨ asɨzir nguzir ivariar kam nan damazimɨn zueghan koghtɨ, ia uam a givesegh. Eghtɨ ofa gamir gumazim an ivezim 10 kinan anetɨghtɨ, ia 12 kina a danɨngigh. Eghtɨ gumazir kam uam asɨzir kam givezeghan koghtɨ, ofa gamir gumazim, gumazir igharazitamɨn anemadaghtɨ, an ofa gamir gumazim dɨborozir ivezimɨn a givesegh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Eghtɨ gumazitam Ikiavɨra Itir God baghavɨra ikiamin bizitam amɨsevegh, egh ingangarir igharazim damuan an anogorogham, egh a gumazir igharazir tamɨn anemadaghtɨ an a givezan markɨ, egh a uaghan uabɨ ofa gamir gumaziba da, dagh ivezan markɨ. A gumazitam o, amizitam o, asɨzitam o, a uan inazir afeziaba da inizir nguazir otevitam, bizir kaba da bar Ikiavɨra Itir Godɨn bizibara. A bar da amangan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ia oragh. A na bagha gumazim o amizim amɨsefe, a uam a givezan markɨ. Bar markɨ. Ia gumazim o amizir kam mɨsueghtɨ an aremegh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Ezɨ nguazimɨn otivir dagher kaba, witɨn ovɨziba, o temer ovɨziba, ia da tuiragh 10plan pozibar amigh, egh pozitam na danɨngigh, kɨ Ikiavɨra Itir God. Egh a pozir kam aman markɨ. Kar nan bizimra. ");
INSERT INTO msy2020_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Eghtɨ gumazitam nan dagher pozim uam a givesɨ a givesegh. Eghtɨ dagher kabar ivezim 5 kina, eghtɨ a 6 kinan dagh ivezegh ofa gamir gumazim danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ian 10plan bulmakauba o 10plan sipsipbar tongɨn, dar vamɨra vamɨra, a nana. Ia asɨziba bar bɨzimɨn dar atɨgh, egh bar da mengegh, eghtɨ 10plan asɨzibar tongɨn, dar namba 10ɨn asɨziba, da nana, kɨ Ikiavɨra Itir God. ");
INSERT INTO msy2020_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ezɨ asɨzir namba 10 a dera, o a ikufi, ia igharazitam an danganim darɨghan markɨ. Eghtɨ ia asɨzir igharazitam an danganim datɨghtɨ, namba 10ɨn asɨzim ko an danganim inizim, aning nana, ezɨ ia uam aning givezan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Akar Gavgavir kaba, Ikiavɨra Itir God Sainain Mɨghsɨamɨn Moses ganɨngi. Egha ghaze, Israelia bar adar gɨn mangam.");
INSERT INTO msy2020_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israelia, kantri Isip ataghizɨ, azenir namba 2 otozɨ, an iakɨnir namba 2ɨn, an aruer faragha zuimɨn, Ikiavɨra Itir God, Sainain gumazamiziba puvatɨzir danganimɨn uabɨ bativamin Purirpenimɨn aven Moses ko mɨgei. ");
INSERT INTO msy2020_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","A kamaghɨn mɨgei, “Nɨ Aron ko gua mangɨ, Israelia bar men ziaba inigh. Gua gumazibar ziaba vaghvagh dagh fogh da osirigh me mengegh. Egh Israelian anababar ikɨziba vaghvagh bar dar ziaba osirigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Kar gumazir 20plan azenibar itiba, ko 20plan azenibagh afiraziba, me mɨdorozim damuamin gavgaviba iti. Gua, bar men ziaba ko men ikɨziba osirigh da mengegh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Egh gua uaningɨn akurvaghsɨ vaghvagh anababar aven, gua gumazir dapanir vamɨra vamɨra mɨsefegh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Gumazir guan akuragh ingangarir kam damuamin mabar ziabar kara: Rubenɨn anabamɨn adarazir gumazim, Sedeurɨn otarim Elisur, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Egh Simeonɨn anabamɨn adarazir gumazim Surisadai, an otarim Selumiel, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Egh Judan anabamɨn adarazir gumazim Aminadap, an otarim Nason, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Egh Isakarɨn anabamɨn adarazir gumazim Suar, an otarim Netanel, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Egh Sebulunɨn anabamɨn adarazir gumazim Helon, an otarim Eliap, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Egh Josepɨn otarir pumuningɨn ovavir boribar tongɨn, Efraimɨn anabamɨn adarazir gumazim Amihut, an otarim Elisama, gua a inigh. Egh Manasen anabamɨn adarazir gumazim Pedasur, an otarim Gamaliel, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Egh Benjaminɨn anabamɨn adarazir gumazim Gideoni, an otarim Abidan, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Egh Danɨn anabamɨn adarazir gumazim Amisadai, an otarim Ahieser, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Egh Aserɨn anabamɨn adarazir gumazim Okran, an otarim Pagiel, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Egh Gatɨn anabamɨn adarazir gumazim Duel, an otarim Eliasap, gua a inigh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Egh Naptalin anabamɨn adarazir gumazim Enan, an otarim Ahira, gua a inigh.” ");
INSERT INTO msy2020_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ezɨ Moses ko Aron, Israelian tongɨn men anababa vaghvagha men gumazir dapanir kaba ini. ");
INSERT INTO msy2020_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","God men ziabar borogha me amɨsevezɨ, aning deraghavɨra me ini. ");
INSERT INTO msy2020_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Egha aning 12plan gumazir dapanir kaba ko, Israelia bar me akuvasa men dei. Ezɨ iakɨnir namba 2ɨn, an aruer faragha zuimɨn, Israelia bar uari akuvazɨ, me gumazamizibar ziaba ko men anababa ko men ikɨzibar ziaba ko dɨboboniba osiri. Gumazir 20plan azeniba itiba ko 20plan azenibagh afiraziba, me bar men ziaba vaghvagha da osira me medi. ");
INSERT INTO msy2020_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ikiavɨra Itir God me mɨkemezɨ moghɨn, me ami. Israelia Sainain gumazamiziba puvatɨzir danganimɨn itima, Moses gumazamizibar ziaba ko men dɨboboniba osiri. ");
INSERT INTO msy2020_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","Gumazir 20plan azeniba itiba, ko 20plan azenibagh afiraziba, me mɨdorozim damuan tughatɨ. Moses ko Aron gumazir kaba vaghvagha men ziaba ko anababa ko men ikɨzibar ziaba ko men apengan itibar ziaba osiri. Me Jekopɨn otarir ivariam Rubenɨn ikegha izaghirɨ. Ezɨ men dɨboboniba da, bar kamakɨn: Rubenɨn anabamɨn gumazibar dɨbobonim, 46,500ɨn tu. Ezɨ Simeonɨn anabamɨn gumazibar dɨbobonim, 59,300ɨn tu. Ezɨ Gatɨn anabamɨn gumazibar dɨbobonim, 45,650ɨn tu. Ezɨ Judan anabamɨn gumazibar dɨbobonim, 74,600ɨn tu. Ezɨ Isakarɨn anabamɨn gumazibar dɨbobonim, 54,400ɨn tu. Ezɨ Sebulunɨn anabamɨn gumazibar dɨbobonim, 57,400ɨn tu. Ezɨ Josepɨn otarir mam Efraim, an anabamɨn gumazibar dɨbobonim, 40,500ɨn tu. Ezɨ Josepɨn otarir igharazim Manase, an anabamɨn gumazibar dɨbobonim, 32,200ɨn tu. Ezɨ Benjaminɨn anabamɨn gumazibar dɨbobonim, 35,400ɨn tu. Ezɨ Danɨn anabamɨn gumazibar dɨbobonim, 62,700ɨn tu. Ezɨ Aserɨn anabamɨn gumazibar dɨbobonim, 41,500ɨn tu. Ezɨ Naptalin anabamɨn gumazibar dɨbobonim, 53,400ɨn tu. Ezɨ men gumazibar dɨboboniba bar moghɨra, 603,550ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Egha Livain anabamɨn gumaziba, me me mengezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ikiavɨra Itir God faragha Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Nɨ Israelian gumazir mɨdorozim damuamiba mengɨva, Livain anabamɨn gumaziba mengan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Nɨ Livaiba amɨseveghtɨ, me nan Purirpenim ko an aven itir bizibagh eghuv dar ganɨva, an ingangaribar faragh mangɨ dar amu. Purirpenir kam, me Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuamning a darɨgham. Egh dughiar ia tuavimɨn zuimɨn me Purirpenim ko an itir biziba ateram. Egh nan Purirpenimɨn mɨriabar uan purirpenibar ingarɨva anekɨarugh. ");
INSERT INTO msy2020_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Dughiar manamɨn ia danganir igiamɨn mangɨsɨ, Livaiba nan Purirpenim angarigh mangɨ danganir igharazimɨn uam anesaragh. Eghtɨ gumazir kɨnitam Purirpenimɨn boroghɨn izɨva, an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israelian gumazamizir igharaziba, ia uan anababa ko ikɨ, uan purirpeniba asɨ uan danganibara ikɨ uan ababanim itir fleghba aseghtɨ da ghuanang. ");
INSERT INTO msy2020_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Eghtɨ Livain anabamɨn adarazi uan purirpeniba nan Purirpenimɨn mɨriaba bar da asegh, egh deraghvɨra a geghuv an gan. Puvatɨghtɨ, gumazir kɨnitam nan Purirpenim boroghɨn izi na damightɨ kɨ bar anɨngaghegh, Israelia bar ia gasɨghasigham. Purirpenir kam, Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuamning an aven ikiam.” ");
INSERT INTO msy2020_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ezɨ Moses bizir kabar gun Israelia mɨkemezɨ, me Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, biziba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ikiavɨra Itir God Moses ko Aron akar kaba aning ganɨngi: ");
INSERT INTO msy2020_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israelia uan purirpenibar ikiamin danganiba aghuva, gumaziba vaghvagh uan anababar ziaba itir fleghɨn boroghɨn uan adarazi ko dapiam, eghtɨ God bativamin Purirpenim, danganir kamɨn tongɨra ikiam. Men purirpeniba tong Godɨn Purirpenimɨn saghon ikɨ, eghtɨ dar tiar akaba an amadaghan mɨtuagh ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","9","“Aruem anadi naghɨn amadaghan, anabar 3pla, Judan anabamɨn ababanim itir fleghɨn boroghɨn, uan ikɨziba ko uan gumazir dapaniba ko ikɨ. Aminadapɨn otarim Nason, a Judan anabamɨn gumazir dapanim, ezɨ Judan anabam 74,600plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Judan anabamɨn adarazir mɨriamɨn, Isakarɨn anabamɨn adarazi ikɨ. Ezɨ Suarɨn otarim Netanel, a Isakarɨn anabamɨn gumazir dapanim, ezɨ Isakarɨn anabam 54,400plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Isakarɨn anabamɨn adarazir mɨriamɨn, Sebulunɨn anabamɨn adarazi ikɨ. Ezɨ Helonɨn otarim Eliap, a Sebulunɨn anabamɨn gumazir dapanim. Ezɨ Sebulunɨn anabam 57,400plan gumaziba iti, me mɨdorozim damuan tughatɨ. Anabar 3plan kaba bar moghɨra, men dɨbobonim 186,400plan gumaziba iti. Dughiar Israelia tuavimɨn mangamim, 3plan anabar kabar adarazi faragh mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","“Eghtɨ sautɨn amadaghan, anabar 3pla, Rubenɨn anabamɨn ababanim itir fleghɨn boroghɨn iti, me uan ikɨziba ko uan gumazir dapaniba ko ikɨ. Sedeurɨn otarim Elisur, a Rubenɨn anabamɨn gumazir dapanim, ezɨ Rubenɨn anabam, 46,500plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Rubenɨn anabamɨn adarazir mɨriamɨn, Simeonɨn anabamɨn adarazi ikɨ. Ezɨ Surisadain otarim Selumiel, a Simeonɨn anabamɨn gumazir dapanim, ezɨ Simeonɨn anabam, 59,300plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Simeonɨn anabamɨn adarazir mɨriamɨn, Gatɨn anabamɨn adarazi ikɨ. Ezɨ Ruelɨn otarim Eliasap, a Gatɨn anabamɨn gumazir dapanim, ezɨ Gatɨn anabam 45,650plan gumaziba iti, me mɨdorozim damuan tughatɨ. Anabar 3plan kaba bar moghɨra, men dɨbobonim 151,450plan gumaziba. Dughiar Israelia tuavimɨn mangamim, 3plan anabar kabar adarasi, faragha zuir anabar 3plan adarazir gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Me tuavimɨn mangamin dughiamɨn, Judan anabamɨn adarazi faragh mangam, eghtɨ anabar igharaziba, me danganir me ikezibar mɨrara, vaghvagh uan ababaniba itir fleghbar suigh men gɨrara mangam. Me dapiamin danganiba, me uarir gɨn zui moghɨra dar ingar. Eghtɨ Livain anabamɨn adarazi na bativamin Purirpenim ater bar men tongɨra ikɨ mangam. Eghtɨ 6plan anababar adarazi Livaibar faragh mangam, eghtɨ 6plan anababar adarazi Livaibar gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","“Eghtɨ aruem uaghiri naghɨn, anabar 3pla, Efraimɨn anabamɨn ababanim itir fleghɨn boroghɨn, me uan ikɨziba ko uan gumazir dapaniba ko ikɨ. Amihutɨn otarim Elisama, a Efraimɨn anabamɨn gumazir dapanim, ezɨ Efraimɨn anabam, 40,500plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Efraimɨn anabamɨn adarazir mɨriamɨn, Manasen anabamɨn adarazi ikɨ. Ezɨ Pedasurɨn otarim Gamaliel, a Manasen anabamɨn gumazir dapanim, ezɨ Manasen anabam 32,200plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Manasen anabamɨn adarazir mɨriamɨn, Benjaminɨn anabamɨn adarazi ikɨ. Ezɨ Gideonin otarim Abidan, a Benjaminɨn anabamɨn gumazir dapanim, ezɨ Benjaminɨn anabam, 35,400plan gumaziba iti, me mɨdorozim damuan tughatɨ. Anabar 3plan kaba bar moghɨra, men dɨbobonim, 108,100plan gumaziba. Dughiar Israelia tuavimɨn mangamimɨn, 3plan anabar kabar adarasi, me Livaibar gɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","“Eghtɨ notɨn amadaghan, anabar 3pla, Danɨn anabamɨn ababanim itir fleghɨn boroghɨn iti, me uan ikɨziba ko uan gumazir dapaniba ko ikɨ. Amisadain otarim Ahieser, a Danɨn anabamɨn gumazir dapanim, ezɨ Danɨn anabam, 62,700plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Danɨn anabamɨn adarazir mɨriamɨn, Aserɨn anabamɨn adarazi ikɨ. Ezɨ Okranɨn otarim Pagiel, an Aserɨn anabamɨn gumazir dapanim, ezɨ Aserɨn anabam 41,500plan gumaziba iti, me mɨdorozim damuan tughatɨ. Ezɨ Aserɨn anabamɨn adarazir mɨriamɨn, Naptalin anabamɨn adarazi ikɨ. Ezɨ Enanɨn otarim Ahira, a Naptalin anabamɨn gumazir dapanimɨn iti, ezɨ Naptalin anabam, 53,400plan gumaziba iti, me mɨdorozim damuan tughatɨ. Anabar 3plan kaba bar moghɨra, men dɨbobonim, 157,600plan gumaziba. Dughiar Israelia tuavimɨn mangamim, 3plan anabar kabar adarasi, me bar abuan mangam. Anabar kaba vaghvagh uan fleghbar suigh bar gɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Me Israelian anababa ko men ikɨziba ko men purirpeniba itir danganibar gɨn ghua men ziaba osira me medima, men dɨbobonim bar moghɨra 603,550plan gumaziba. ");
INSERT INTO msy2020_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Moses, Ikiavɨra Itir Godɨn Akar Gavgavim baregha, Livain anabamɨn adarasi, a Israelɨn anabar igharaziba ko me mengezir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kamaghɨn, Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, Israelia biziba bar dagh ami. Anababa vaghvagha uan fleghbar boroghɨn uan purirpenibar danganiba azui. Egha dughiar Israelia tuavimɨn mangamim, me bar vaghvagha uan anababa ko uan ikɨziba ko zui. ");
INSERT INTO msy2020_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ikiavɨra Itir God, Sainain Mɨghsɨamɨn Moses ko mɨgeir dughiamɨn, Aron ko Mosesɨn ikɨzim kamakɨn. ");
INSERT INTO msy2020_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aron otarir 4pla iti, Nadap, an otarir ivariam, ezɨ an gɨn, Abihu, Eleasar ko Itamar. ");
INSERT INTO msy2020_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Aronɨn otarir kaba, me ofa gamir gumazibar ikiasa, Moses olivɨn borem isa men dapanibagh inga me amɨsevegha Ikiavɨra Itir Godɨn ofa damuamin ingangarim me ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Israelia, Sainain gumazamiziba puvatɨzir danganimɨn itima, Nadap ko Abihu ofa gamir gumazibar ingangarim gamua Ikiavɨra Itir God ifongezir puvatɨzir avimɨn, an damazimɨn ofa gami. Kamaghɨn amizɨ, aning areme. Nadap ko Abihu, boriba puvatɨgha areme. Ezɨ kamaghɨn, Eleasar ko Itamar aningɨn danganim inigha ofa gamir gumazimningɨn otogha, Ikiavɨra Itir Godɨn ofa gami. Aningɨn afeziam Aron ikiavɨra itima, aning ingangarir kam gamua izi. ");
INSERT INTO msy2020_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Nɨ Livain anabamɨn adarazi inigh men aku izɨ ofa gamir gumazim Aronɨn damazimɨn izegh, me amɨseveghtɨ, me an ingangarir gumazibar otivigham. ");
INSERT INTO msy2020_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Me Aron ko Israelian gumazamiziba bar men akurvagh nan Purirpenimɨn ingangarim damuam. Me na bativamin Purirpenimɨn guamɨn, na bagh ingangaribar amuam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Me Israelian danganim inigh, na bativamin Purirpenimɨn aven itir biziba bar deraghvɨra dar ganɨva dagh ativagham. Me arazir kamɨn, Purirpenimɨn ingangaribar amuam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Nɨ Livaiba isɨ Aron ko an ovavir boribar anɨngigh. Kɨ Israelian tongɨn Aron ko an otaribar akurvaghasa Livaibav sefe. ");
INSERT INTO msy2020_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Nɨ Aron ko an ovavir boriba, ofa gamir ingangarim bagh me amɨseveghtɨ, merara ingangarir kam damuva ofa gamir gumazibar mɨn ikɨ. Eghtɨ gumazir kɨnitam, nan bizir bar zuruzibar boroghɨn izɨsɨ damutɨ, ia a mɨsueghtɨ an aremegh.” ");
INSERT INTO msy2020_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","13","“Ia oragh! Kɨ datɨrɨghɨn ua bagh Israelian gumazamizibar tongɨn Livaiba amɨseveghtɨ, me na baghvɨra ikiam. Ia fo, kɨ faragha Isipian otarir ivariaba bar me mɨsoghezir dughiamra, kɨ Israelian otarir ivariaba bar ua bagha dagh inaba, kar gumazamizibar otarir ivariaba ko asɨzibar nguzir ivariaba sara. Kamaghɨn amizɨ, ian otarir ivariaba bar nana. Egha kɨ datɨrɨghɨn otarir ivariabar danganim iniasa Livaibagh inaba. Me datɨrɨghɨn nan ingangarir gumazibar mɨn ikɨ na baghvɨra ikiam. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkeme.” ");
INSERT INTO msy2020_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Egha Ikiavɨra Itir God, Sainain gumazamiziba puvatɨzir danganimɨn ua kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Nɨ Livain anabamɨn adarazi ko men ikɨziba bar me mengegh. Nɨ gumaziba bar vaghvagh, kar otarir iakɨnir vamɨra itibar ikegh mangɨ gumazir ghuribar tugh, nɨ bar me mengegh men ziaba osirigh.” ");
INSERT INTO msy2020_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ezɨ Moses Ikiavɨra Itir Godɨn Akar Gavgavim baregha, an gɨn ghua bar me menge. ");
INSERT INTO msy2020_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Fomɨra, Livai otarir 3pla iti, men ziabar kara: Gerson, Kohat, ko Merari. ");
INSERT INTO msy2020_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ezɨ Gersonɨn otarimningɨn ziamning kara, Lipni ko Simei, aning gɨn uan ikɨzimɨn afeziamningɨn oto. ");
INSERT INTO msy2020_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Ezɨ Kohatɨn otaribar ziabar kara: Amram, Ishar, Hebron ko Usiel, me gɨn uan ikɨzibar afeziabar otifi. ");
INSERT INTO msy2020_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Ezɨ Merarin otarimningɨn ziamning kara, Mali ko Musi, aning gɨn uan ikɨzimningɨn afeziamningɨn oto. Livain anabamɨn adarasi, men ikɨzibar ziaba, uan inazir afeziabar ziar kabar gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ezɨ Gersonɨn adarasi, ikɨzir pumuning iti, kar Lipnin ikɨzim ko Simein ikɨzim. ");
INSERT INTO msy2020_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Men gumaziba bar, kar men otarir iakɨnir vamɨra itibar ikegha ghua gumazir ghuribar tuzɨba, men dɨbobonim, 7,500ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gersonɨn ikɨzimɨn adarasi, aruem uaghiri naghɨn Purirpenimɨn akɨrangɨn uan purirpeniba asam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ezɨ Gersonɨn ikɨzimɨn gumazir dapanim, a Laelɨn otarim Eliasap. ");
INSERT INTO msy2020_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","26","Gersonɨn ikɨzimɨn gumaziba, me ingangarir kaba iti. Me God bativamin Purirpenimɨn iniba bar dar ganam, dar kara: an aven itir bɨribar inir duiba bar, ko azenan anevamin inir ekiaba, ko an tiar akamɨn inim ko, Purirpenim ko ofa gamir dakozim avɨnizir dɨvazimɨn iniba, ko dɨvazimɨn azenan zuir tiar akamɨn iniba, ko inir kaba duir beniba. Me bizir kaba bar dar ganamin ingangarim iti. ");
INSERT INTO msy2020_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ezɨ Kohatɨn ikɨzimɨn adarasi, ikɨzir 4pla iti. Kar Amramɨn ikɨzim, ko Isharɨn ikɨzim, ko Hebronɨn ikɨzim, ko Usielɨn ikɨzim. ");
INSERT INTO msy2020_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Men gumaziba bar, kar men otarir iakɨnir vamɨra itibar ikegha ghua gumazir ghuribar tuzɨba, men dɨbobonim, 8,300ɨn tu. Me Purirpenimɨn ganamin ingangarir maba iti. ");
INSERT INTO msy2020_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohatɨn ikɨzimɨn adarasi, Purirpenimɨn sautɨn amadaghan uan purirpeniba asam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ezɨ men gumazir dapanim, Usielɨn otarim Elisafan. ");
INSERT INTO msy2020_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ingangarir me damuamimra kara, me Akar Dɨkɨrɨzir Gavgavimɨn Boksiam, ko dakozim, ko lamɨn agharim, ko ofa gamir dakozir pumuning, ko Anogoroghezir Danganimɨn itariba ko bizir igharaziba, ko Bar Anogoroghezir Danganim modir inim, me bizir kaba bar dar ganamin ingangarim iti. ");
INSERT INTO msy2020_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ezɨ Livaiba bar, men gumazir dapanim Eleasar, a ofa gamir gumazim Aronɨn otarim. A Godɨn Purirpenimɨn aven ingangarim gamir gumazibagh, ativagha men gari. ");
INSERT INTO msy2020_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Ezɨ Merarin ikɨzimɨn adarasi, me ikɨzir pumuning iti, Malin ikɨzim, ko Musin ikɨzim. ");
INSERT INTO msy2020_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Men gumaziba bar, kar men otarir iakɨnir vamɨran itibar ikegha ghua gumazir ghuribar tuzɨba, men dɨbobonim, 6,200ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merarin ikɨzimɨn adarazir gumazir dapanim, Abihailɨn otarim Suriel. Egh me Purirpenimɨn notɨn amadaghan uan purirpeniba asam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","37","Merarin ikɨzimɨn adarasi, me ingangarir kaba iti. Me, Purirpenimɨn bɨrir aghariba, ko an bɨribar ighuvir ruariba, ko an dɨpenir akɨniba, ko boksiar bɨrir agharibar poviba gavgavim dagh anɨdiba, ko dar bizir muziariba sara, ko Purirpenim avɨnizir dɨvazir ekiamɨn dɨpenir akɨniba, ko dɨpenir akɨnir kabar poviba gavgavim dagh anɨdir boksiaba, ko dɨvazimɨn suizir afughafuziba ko beniba, me bizir kaba bar dar ganamin ingangarim iti. ");
INSERT INTO msy2020_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Egh Moses ko Aron uan otariba ko, God bativamin Purirpenimɨn guamɨn, aruem anadi naghɨn uan purirpeniba asam. Me Anogoroghezir Danganimɨn aven ingangaribar ganamin ingangarim iti. Me Israelia bar men akurvaghasa kamaghɨn ami. Eghtɨ gumazir kɨnitam danganir kamɨn boroghɨn izɨtɨ, me a mɨsueghtɨ, an aremegham. ");
INSERT INTO msy2020_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ikiavɨra Itir God, Moses ko Aron Akar Gavgavim aning ganɨngizɨ moghɨn, aning an gɨn ghua Livain anabamɨn gumaziba ko me itir ikɨziba bar men ziaba osiri. Aning men otarir iakɨnir vamɨran itibar ikegha ghua gumazir ghuribar tuzɨba, bar me menge, ezɨ men dɨbobonim 22,000ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ezɨ Ikiavɨra Itir God Moses mɨgɨa ghaze, “Nɨ Israelian otarir ivariabar ziaba bar da osirigh. Nɨ otarir iakɨnir vamɨran itibar ikegh men ziaba meng mangɨ gumazir ghuribar tugh. ");
INSERT INTO msy2020_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kɨ Ikiavɨra Itir God, kɨ Israelian otarir ivariaba iniamin danganim, kɨ Livaiba iniam. Egh kɨ uaghan Israelian asɨzir ivariaba iniamin danganim, kar bulmakauba, ko sipsipba, ko memen ivariaba, kɨ uaghan Livaibar asɨzir ivariaba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kamaghɨn amizɨ, Moses Ikiavɨra Itir God mɨkemezɨ moghɨn ami. A Israelian otarir ivariaba bar me mengegha men ziaba osiri. ");
INSERT INTO msy2020_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ezɨ men otarir ivariaba bar, kar otarir iakɨnir vamɨran itibar ikegha ghua men gumazir ghuribar tu, men dɨbobonim 22,273ɨn tu. ");
INSERT INTO msy2020_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Egha Ikiavɨra Itir God ua kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Nɨ datɨrɨghɨn Israelian borir ivariabar danganim inisɨ, Livaiba na danɨngigh. Eghtɨ Livaiba nan gumazamizibara ikiam. Egh men asɨziba, Israelian asɨzir ivariabar danganim inisɨ me na danɨngigh. Kɨ Ikiavɨra Itir God, kɨ kamaghɨn mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Israelian otarir ivariabar dɨbobonim, mong pɨn iti, ezɨ Livaibar gumazibar dɨbobonim, a 273plan gumazibagh afira, Kamagh, 273plan gumazir kaba, ia nan dafarim dama ua me givezeghɨva ua me iniam. ");
INSERT INTO msy2020_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ezɨ ua gumazir vamɨra, iniamin ivezim, a 50 kina. Kamaghɨn amizɨ, ia ua 273plan gumazir kaba vaghvagh me givesɨ, me bagh vaghvagh 50 kina 50 kina inigh na bagh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Egh dagɨar kaba, nɨ Aron ko an otaribar anɨngigh, egh ua gumazir kaba iniam.” ");
INSERT INTO msy2020_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","51","Moses Ikiavɨra Itir Godɨn Akar Gavgavir kam baregha an gɨn ghu. A 13,650 kina, otarir ivariar kabar dafarim dama da inigha ghua, ua me iniamin ivezimɨn mɨn Aron ko an otaribagh anɨngi. ");
INSERT INTO msy2020_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ezɨ Ikiavɨra Itir God Moses ko Aron mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Gua Kohatɨn ikɨzimɨn adarasi, men gumaziba ko ikɨzir me aven itiba, men ziaba osirigh me mengegh. Kohatɨn ikɨzim, a Livain anabamɨn ikɨzibar ikɨzir mam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Gumazir 30plan azeniba itibar ikegh mangɨ 50plan azeniba itibar tugh, gua ingangarim bagh men ziaba osirigh me mengegh. Gumazir kaba, God bativamin Purirpenimɨn ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Men ingangarim kamakɨn, me God bativamin Purirpenimɨn bizir bar zuruzibar ganam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“Israelia danganir mam ategh mangɨsɨ, Aron uan otariba ko Purirpenimɨn aven mangɨ, Akar Dɨkɨrɨzir Gavgavimɨn Boksiam modir inir aghuarir ekiam adegh a inigh an onegh Boksiam avaragh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Egh ongarimɨn itir asɨzir ekiabar inir aghuitamra inigh anevaragh, bluplan initam uam anevaragh. Egh Boksiam atersɨ an iter otevir pumuning isɨ, tam vongɨn itir Boksiamɨn ringning darugh, egh tam vongɨn itir ringning darugh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Egh me inir bluplan tam isɨ dakozir nan damazimɨn ikiavɨra itim gisɨn a ghuaragh. Egh itariba, ko mɨneba, ko ababa, wainɨn dɨpam ingiamin ofa bagh itarir koniba isɨ, dakozir kam dafagh. Me zurara bretɨn na ganɨdim, me dakozir kam darɨgh, eghtɨ a nan damazimɨn ikɨvɨra ikɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Egh bizir kaba bar moghɨra, inir aghevitamɨn da avegh. Egh ongarimɨn itir asɨzir ekiabar inir aghuitamra isɨ bizir kaba bar da avegh. Egh dakozir kam atersɨ, me an iter otevimning isɨ, tam vongɨn itir dakozimɨn ringning darugh, egh tam vongɨn itir ringning darugh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Egh me inir bluplan tam inigh, lamɨn aghorim ko an lamba, ko akamimɨn mɨn avimɨn suizir biziba, ko an itariba, ko olivɨn boreba itir mɨneba, ko an itir bizir igharaziba, bar moghɨra da avegh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Egh a ko an itir bizir kaba bar, ongarimɨn itir asɨzir ekiabar inir aghuitamɨn da rɨkigh. Egh anetersɨ, nogorim a datɨgh a ikegh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Egh inir bluplan tam isɨ, golɨn ingarizir ofa gamir dakozim avaragh, egh ongarimɨn itir asɨzir ekiabar inir aghuitam a gisɨn uam anevaragh, egh anetersɨ, aneteramin iter otevimning an gol ringbar aghuigh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Egh Anogoroghezir Danganimɨn aven Godɨn ingangarim damuamin biziba bar da akuvagh inir bluplan tamɨn aven da rɨkigh, egh ongarimɨn itir asɨzir ekiabar inir aghuitam bar da nomkegh, egh da atersɨ nogorim a datɨgh a ikegh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Egh ofa gamir dakozir ekiamɨn averenim rueghɨva, inir pɨghaghevitamɨn anevaragh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Egh ofa gamir dakozimɨn Godɨn ingangarim damuamin biziba bar da isɨ, ofa gamir dakozimɨn pɨn dar arɨkigh. Bizir kaba, itarir ekiaba, ko fokba, ko savolɨn muziariba, ko itarir avim ateramiba, ko averenim iniamin itariba. Egh ongarimɨn itir asɨzir ekiabar inir aghuitam isɨ ofa gamir dakozim avaragh. Egh anetersɨ, an iter otevimning isɨ, an gol ringbar aghuigh. ");
INSERT INTO msy2020_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Israelia dɨkavigh danganir igharazimɨn mangɨsɨ damutɨ, Aron uan otariba ko Purirpenimɨn aven itir biziba bar da noeghtɨ, Kohatɨn adarazi izɨ bizir kaba ateram. Arazir kamɨn, me bizir bar zuruzibar suighan kogham. Puvatɨghtɨ, me arɨghiregham. Kohatɨn adarasi, God bativamin Purirpenimɨn biziba ateramin ingangarir kam iti. ");
INSERT INTO msy2020_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Ofa gamir gumazim Aronɨn otarim Eleasar, Purirpenim ko an aven itir bizibar ganam. Egh lambar boreba, ko mɨgharir mughuriar aghuim zuir paura, ko wit tuamin ofan me zuraram amiba, ko olivɨn borer me ofa gamir gumazibagh inga me amɨsɨvamiba, a bizir kabar ganam.” ");
INSERT INTO msy2020_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ikiavɨra Itir God Moses ko Aron mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“Gua oragh. Livain anabamɨn adarazir tongɨn itir Kohatɨn ikɨzimɨn gumaziba, me nan bizir zuruzir kabar boroghɨn izɨtɨ, gua bar deraghvɨra men gan. Bar guizbangɨra, Kohatɨn ikɨzimɨn adarazi arazir kuratam damightɨ, kɨ me mɨsueghtɨ me arɨmɨghiregham. Kamaghɨn, Aron uan otariba ko, men ikɨzim faragh Purirpenimɨn aven mangɨ, bizir me damuamiba deraghvɨra vaghvagh men akakagh, me ateramin bizibar me mɨkɨm. ");
INSERT INTO msy2020_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Egh ofa gamir gumaziba Purirpenimɨn aven nan bizir zuruziba nogha da aver dughiamɨn, Kohatɨn ikɨzimɨn adarazi Purirpenimɨn aven mangɨ bizir kabar ganan kogham. Me dar ganamin dughiamra, me maghɨram arɨghiregham.” ");
INSERT INTO msy2020_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Nɨ Gersonɨn ikɨzimɨn adarasi, men gumaziba ko ikɨzir me aven itiba, men ziaba osirigh me mengegh. Gersonɨn ikɨzim, a Livain anabamɨn ikɨzibar ikɨzir mam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Gumazir 30plan azeniba itibar ikegha ghua 50plan azenibar tuzɨba, gua ingangarim bagh men ziaba osirigh me mengegh. Gumazir kaba, God bativamin Purirpenimɨn ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Men ingangarim kamakɨn, me God bativamin Purirpenimɨn bizir kaba ateram. ");
INSERT INTO msy2020_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Me Purirpenimɨn bɨrimɨn mɨn duir inir aghuir ekiaba, ko God bativamin Purirpenim aver inir me ongarimɨn itir asɨzir ekiabar inibar ingariziba, ko God bativamin Purirpenimɨn aven zuir tiar akamɨn inir ekiaba, me bar da ateram. ");
INSERT INTO msy2020_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Egh Purirpenim ko ofa gamir dakozim avɨnizir dɨvazimɨn inir ekiaba, ko dɨvazimɨn azenan zuir tiar akamɨn iniba, ko inir kaba duir beniba ko dar bizir igharaziba, me bar dar ganam. Gersonɨn ikɨzim, me bizir kabar ganɨva dar kɨr da ateramin ingangarim iti. ");
INSERT INTO msy2020_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aron uan otariba ko, Gersonɨn adarazir ganɨva me vaghvagh damuamin biziba ko ateramin biziba ko damuamin ingangarir igharazibar me mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gersonɨn adarasi, God bativamin Purirpenimɨn ingangarir kaba iti. Eghtɨ ofa gamir gumazim Aronɨn otarim Itamar, men ingangarir kabar ganamin gumazir dapanim.” ");
INSERT INTO msy2020_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Egha Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ Merarin ikɨzimɨn adarasi, men gumaziba ko ikɨzir me aven itiba, men ziaba osirigh me mengegh. Merarin ikɨzim, a Livain anabamɨn ikɨzibar ikɨzir mam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Gumazir 30plan azeniba itibar ikegha ghua 50plan azenibar tuzɨba, gua ingangarim bagh men ziaba osirigh me mengegh. Gumazir kaba, God bativamin Purirpenimɨn ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","32","Ia danganir igharazimɨn mangamin dughiamɨn, Merarin ikɨzimɨn adarasi, me na bativamin Purirpenimɨn ingangarir kaba iti. Me, Purirpenimɨn bɨrir aghariba, ko an bɨribar ighuvir ruariba, ko an dɨpenir akɨniba, ko boksiar bɨrir agharibar poviba gavgavim dagh anɨdiba, ko dar bizir muziariba sara, ko Purirpenim avɨnizir dɨvazir ekiamɨn dɨpenir akɨniba, ko dɨpenir akɨnir kabar poviba gavgavim dagh anɨdir boksiaba, ko dɨvazimɨn suirazir afughafuziba ko beniba, me bizir kaba bar da ateramim ingangarim iti. Nɨ Merarin ikɨzimɨn adarazi vaghvagh ateramin bizibar me mɨkɨm. ");
INSERT INTO msy2020_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merarin ikɨzimɨn adarasi, God bativamin Purirpenimɨn ingangarir kabar amuam. Eghtɨ ofa gamir gumazim Aronɨn otarim Itamar, men ingangarir kabar ganamin gumazir dapanim.” ");
INSERT INTO msy2020_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","Kamaghɨn, Moses ko Aron ko Israelian gumazir dapaniba Ikiavɨra Itir Godɨn akamɨn gɨn ghua, Livain anabamɨn adarazir ziaba osirigha me menge. Kar, Kohatɨn ikɨzimɨn adarazi ko Gersonɨn ikɨzimɨn adarazi ko Merarin ikɨzimɨn adarasi. Men gumaziba ko ikɨzir me aven itiba, me men ziaba osirigha me menge. Gumazir 30plan azeniba itibar ikegha ghua 50plan azeniba itibar tuzɨba, me God bativamin Purirpenimɨn ingangarim bagha men ziaba osirigha me menge. Men dɨbonibar kara, Kohatɨn ikɨzimɨn gumazibar dɨbobonim 2,750plan gumaziba, ezɨ Gersonɨn ikɨzimɨn gumazibar dɨbobonim 2,630plan gumaziba, ezɨ Merarin ikɨzimɨn gumazibar dɨbobonim 3,200plan gumaziba. Ikɨzir 3plan kaba bar moghɨra, men dɨbobonim, 8,580plan gumaziba. ");
INSERT INTO msy2020_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ikiavɨra Itir God, Moses mɨkemezɨ moghɨra, me gumaziba menge. Egha ingangarir me vaghvagh damuamiba ko ateramin biziba, Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, me me ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Nɨ Israelian gumazamizibav kemeghtɨ, me danganir itimɨn gumazir kaba batueghtɨ, me mangɨ azenan ikɨ. Kar, gumazamizir lepan mɨn garir arɨmariar kuram itiba, ko gumazamizir mɨkarzir mogomeba duaba da bativima, ghuzir mɨtiziba dar azenan otifi, ko amizir uan iakɨnibav soziba, ko gumazamizir ariaghirezibar kuabar suigha Godɨn damazimɨn mɨzeziba. ");
INSERT INTO msy2020_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Ia gumazamizir kaba uaghara me amangightɨ, me danganir ia itimɨn azenan mangɨ. Ia kamaghɨn damutɨ, danganir kɨ uan gumazamizibar tongɨn itim, a nan damazimɨn mɨzeghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Kamaghɨn amizɨ, Israelia, gumazamizir Godɨn damazimɨn mɨzeziba azenan me amadima, me azenan zui. Me Ikiavɨra Itir God Moses mɨkemezɨ moghɨram ami. ");
INSERT INTO msy2020_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ezɨ Ikiavɨra Itir God Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Nɨ akar kaba Israelian gumazamizibar anɨngigh: Gumazitam o amizitam akɨrim ragh Ikiavɨra Itir God gasaragh, arazir kuratam gumazir igharazitam damightɨ, osɨmtɨzim an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Kamaghɨn, a uan arazir kuramɨn gun mɨkemegh, egh ivezim bar anetɨgh gumazir an arazir kuramɨn a gamizim danɨngigh. Ivezir a ikarvaghamim, 500plan dagɨabar ikɨtɨ, nɨ uam a gisɨn dagɨatabar atɨgh 600plan dagɨaba a danɨngigh. ");
INSERT INTO msy2020_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Gumazir ivezir kam iniamim aremeghtɨ, an tav ikian kogh ivezir kam inighan koghtɨ, gumazir arazir kuram gamizim, ivezir kam inigh Ikiavɨra Itir God bagh mangɨtɨ, ofa gamir gumaziba a iniam. Egh ivezir kam gisɨn, a sipsipɨn apuritam isɨ ofa gamir gumazim danightɨ, ofa gamir gumazim an arazir kuraba gɨn amangamin ofa damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Israelia Ikiavɨra Itir Godɨn ofa damusɨ, bizir aghuitaba inigh izɨ ofa gamir gumazim danightɨ, bizir kaba an bizibara. ");
INSERT INTO msy2020_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Gumazamiziba God bagha inigha izir ofan manaba, kar bizir me ofa gamir gumazim ganɨdiba, a ua bagh da iniam.” ");
INSERT INTO msy2020_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Egha Ikiavɨra Itir God Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","14","“Nɨ akar kaba Israelian gumazamizibar anɨngigh: Gumazitam kamagh nɨghnɨgh suam, an amuim ti akɨrim a gasaragha gumazir igharazim ko akui, egha Godɨn damazimɨn mɨze. Gumazir kam a fozir puvatɨ, guizbangɨra, o puvatɨ. Amuim ti modogha arazir kam gami. Guizbangɨra, tav an ganizir puvatɨgha, a gasir akamɨn tuaviba puvatɨ. Kamaghɨn pam navir kuram uan amuimɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Egh arazir kamɨn, gumazim uan amuim inigh ofa gamir gumazim bagh mangɨ. A uaghan ofa damusɨ 1 kilogrem plauan balin ingarizim inigh mangam. Ofan kamɨn mɨngarimra kara, pam ti uan amuim bagha nɨghnɨzir avɨriba ikia navir kuram an iti, eghtɨ me fogham amuim guizbangɨra arazir kuram gamiz, o puvatɨ. Kamaghɨn, gumazir kam olivɨn borem isɨ plauan kam gingan markɨ. Egh uaghan, a mɨgharir mughuriar aghuim zuim itir pauran me iter balsamɨn eborimɨn ingarizim a darɨghan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Eghtɨ ofa gamir gumazim, amizim inigh izɨtɨ, a ofa gamir dakozimɨn boroghɨn izɨ Ikiavɨra Itir Godɨn damazimɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Eghtɨ ofa gamir gumazim, dɨpar me na ganɨngizitam isɨ, nguazir mɨner tam gingegh, egh Ikiavɨra Itir Godɨn Purirpenimɨn apengan itir nguazir mɨnezitaba inigh dɨpar kam mɨkɨnigh, eghtɨ arazir kamɨn dɨpar kam puv mɨsogham. ");
INSERT INTO msy2020_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Amizir kam nan damazimɨn tughɨv ikiamin dughiamɨn, ofa gamir gumazim amizimɨn dapanir arɨzim fɨrightɨ a ruaragh pura ikiam. Eghtɨ ofa gamir gumazim, ofa damuamin plaua isɨva amizimɨn dafarim datɨgh. Egh ofa gamir gumazim uan dafarimɨn dɨpar mɨsozi kamɨn itir nguazir mɨnemɨn suiragh. E fo, dɨpar mɨsozir kam, amizir guizbangɨra arazir kurabagh amibagh asɨghasɨsi. ");
INSERT INTO msy2020_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Ofa gamir gumazim amizim mɨkɨmtɨ, amizim amamangatɨghtɨ, ofa gamir gumazim suam, ‘Nɨ fo, dughiar nɨ uan pamɨn itimɨn, nɨ gumazitam koma arazir kuratam gamizir puvatɨ, eghtɨ dɨpar mɨsozir kam guizbangɨra nɨ gasɨghasighan kogham. ");
INSERT INTO msy2020_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ezɨ nɨ uan pamɨn itir dughiamɨn, nɨ uan pam ategha guizbangɨra gumazir igharazim ko arazir kuram gamigha Godɨn damazimɨn mɨze, eghtɨ dɨpar mɨsozir kam nɨn ingarɨva nɨ gasɨghasigham.’ ");
INSERT INTO msy2020_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Eghtɨ ofa gamir gumazim uam akar kurar kam amizim mɨkɨmam, ‘Nɨ guizbangɨra arazir kuram gami, eghtɨ Ikiavɨra Itir God nɨn gumazamizibar tongɨn nɨn ziam gasɨghasigham, egh nɨn borivtarim damightɨ, an ekonamightɨ, nɨn navim buigham. ");
INSERT INTO msy2020_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Dɨpar mɨsozir kam nɨn navimɨn aven mangɨ an ingartɨ, a buva nɨn mɨkarzir mogomem damightɨ a ikuvigham.’ Eghtɨ amizim suam, ‘Aria, guizbangɨra. Ikiavɨra Itir God mɨkemezɨ moghɨn damu.’ ");
INSERT INTO msy2020_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Eghtɨ ofa gamir gumazim asɨghasɨghamin akar kam osirigh, egh dɨpatam inigh akar osirizir kam rutɨ a mɨner dɨpar mɨsozim magɨram. ");
INSERT INTO msy2020_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Egh gɨn an amizim mɨkemeghtɨ, an anemeghtɨ, dɨpar mɨsozir kam an navir averiamɨn aven magɨram. ");
INSERT INTO msy2020_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Ofa gamir gumazim, amizim suirazir ofan plauan kam a dama a inigh, an suiragh Ikiavɨra Itir Godɨn damazimɨn a fegh a damutɨ, a ighuamangɨ. Egh a inigh ofa gamir dakozimɨn mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Egh uan dafarim isɨ plauan kam darugh, egh a plauan muziaritam inigh ofa gamir dakozimɨn a tuaghtɨ, avim an isi mangɨtɨ a bar mɨghɨrightɨ, averenir kɨnim otogham. Plauan muziarir kam, a bar plauan namɨn danganim inigham. A kamaghɨn damigh gɨn amizim mɨkemeghtɨ, a dɨpar mɨsozir kam amam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Amizim guizbangɨra poroghamiba uari bakeir arazim damighɨva Godɨn damazimɨn mɨzeghtɨ, dɨpar mɨsozir kam an aven mangɨva, mɨzazim a danɨngɨva, an borivtaribar amightɨ, da ekonamigh, navim buva an mɨkarzir mogomem ikuvigham. Eghtɨ Ikiavɨra Itir God an gumazamizibar tongɨn an ziam gasɨghasigham. ");
INSERT INTO msy2020_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Eghtɨ amizir kam, guizbangɨra arazir kuram damighan koghɨva, a Godɨn damazim deraghvɨra ikɨvɨra ikɨtɨ, dɨpar mɨsozir kam a gasɨghasɨghan koghtɨ, bizir kurar kam a batoghan kogham. Eghtɨ a boriba batamin gavgavim ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Akar Gavgavir kamɨn mɨngarim kamakɨn. Gumazitam uan amuim mɨkɨm suam, a ti arazir kuram gami. Egh a nɨghnɨzir avɨriba ikɨ egh navir kuram an ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","O, gumazim pura akar kɨnim uan amuir aghuim gasɨ, navir kuram pura an ikɨtɨ, me amizim mɨkemeghtɨ, an ofa gamir dakozimɨn boroghɨn tughtɨ, ofa gamir gumazim guizɨn akam gɨfoghsɨ arazir kam damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Eghtɨ amizim guizbangɨra arazir kurar kam gami, an an ivezir kuram iniva osɨmtɨziba ateram. Amizim guizbangɨra osɨmtɨzim damightɨ, an pam akam a gasir arazir kamɨn osɨmtɨzim an ikian kogham.” ");
INSERT INTO msy2020_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Nɨ Israelian gumazamiziba kamaghɨn me mɨkɨm: Gumazitam o amizitam uabɨ isɨ Ikiavɨra Itir God danɨngɨva a baghvɨra ikɨsɨ, a ko akam akɨrigh, ");
INSERT INTO msy2020_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","egh a wainɨn dɨpam ko dɨpar gavgavibar aman markɨ. Egh wainɨn ovɨzibar dɨpaba ko wainɨn ovɨziba ko wainɨn ovɨzir mɨdiaribar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A uabɨ isa na ganɨga Akar Gavgavim gamizir dughiamɨn ikegh mangɨ dughiar a na baghvɨra ikiamim gɨvaghamim otogham, a wainɨn dɨpatam, o wainɨn ovɨziba, o wainɨn ovɨzibar inibar aman markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Egh dughiar a uan akar dɨkɨrɨzimɨn gɨn ghua uabɨ isa na ganɨdimɨn, a uan dapanir arɨzibagh isɨ da otɨvan markɨ. A nan gumazimra. Egh an akar dɨkɨrɨzir gavgavir kamɨn apengan ikɨ, dughiabar zurara uan dapanir arɨzim ko ghuamasɨziba ateghtɨ da aghung. ");
INSERT INTO msy2020_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","A dapanir arɨzir ruarim sara itir arazir kam, gumazamizibar akagha ghaze, a God baghavɨra itir gumazimra. Kamaghɨn amizɨ, a uabɨ nan damazimɨn mɨzeghan koghsɨ gumazitamɨn kuamɨn boroghɨn mangan kogham. Guizbangɨra an afeziam, o amebam, o aveghbuaba o buaramiziba arɨmɨghireghtɨ, a men kuabar boroghɨn mangan kogham. A kamaghɨn damigh, nan damazimɨn mɨzegham. ");
INSERT INTO msy2020_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Dughiar a uan akar dɨkɨrɨzimɨn gɨn ghua na baghavɨra itimɨn, a Ikiavɨra Itir Godɨn gumazimra. ");
INSERT INTO msy2020_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Gumazitam an boroghɨn puram aremeghtɨ, bizir kam an dapanir arɨzir na ganɨngizim damutɨ, a nan damazimɨn mɨzegham. Kamaghɨn amizɨ, gumazir kam 7plan arueba orarkegh gɨn uan dapanim gisegh, egh ua nan damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Egh namba 8ɨn aruemɨn, a kuarazir bunbar pumuning o osɨrvar pumuning inigh ofa gamir gumazim bagh God bativamin Purirpenimɨn tiar akamɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Eghtɨ ofa gamir gumazim aning inigh, tam arazir kuraba gɨn amadir ofa damu. Egh tam ofan bar isia mɨghɨrim damu. Gumazir kam, gumazir kuamɨn boroghɨn ikegha osɨmtɨzim ikia a nan damazimɨn mɨze. Kamaghɨn, ofan kamning a damightɨ a nan damazimɨn ua zuegham. Aruer kamra, gumazir kam ua uan dapanir arɨzim na danɨngtɨ, a nan bizimram otogham. ");
INSERT INTO msy2020_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Aruer a Ikiavɨra Itir God baghavɨra ikiasa akam akɨrizibar dɨbobonim, a bar ua dar amuam. Dar dɨbobonim, aruer kamɨn ikegh mangɨva, aruer kabar dɨbobonim gɨvagham. A uan akar dɨkɨrɨzimɨn gɨn zuir aruer faragha ghueziba, da pura ghue. Guizbangɨra, an dapanarɨzim nan damazimɨn mɨze. Kamaghɨn, an azenir vamɨra itir sipsipɨn apurir igiatam inigh osɨmtɨziba agɨvamin ofan mɨn na bagh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Na baghvɨra ikiasa akar dɨkɨrɨzim gamizir gumazim, bizir a damuasa mɨkemezibar amigh gɨvagh, egh na bativamin Purirpenimɨn mangɨ an tiar akamɨn boroghɨn tugham. ");
INSERT INTO msy2020_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Egh a 3plan ofaba Ikiavɨra Itir God bagh dar amuam. An ofan bar isia mɨghɨrim bagh azenir vamɨra itir sipsipɨn nguzir apuritam, ko arazir kuraba gɨn amadir ofa bagh azenir vamɨra itir sipsipɨn amebatam, ko God ko navir vamɨra ikiamin ofa bagh sipsipɨn apuritam, a bar da inigh na bagh izam. Kar, asɨzir duaba dar mɨkarzibar itir puvatɨziba. ");
INSERT INTO msy2020_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Egh uaghan yis puvatɨzir bretba itir akɨram, kar plauan aghuim ko olivɨn borem sara veregha ingarizir bretba, ko yis puvatɨzir bisketɨn olivɨn boremɨn aghuiziba, egh uaghan wit tuamin ofa ko wainɨn dɨpabar ofa damuamiba sara inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Eghtɨ ofa gamir gumazim bizir kaba bar da isɨ, Ikiavɨra Itir God danɨngɨva, arazir kuraba gɨn amadir ofa ko ofan bar isia mɨghɨrim damu. ");
INSERT INTO msy2020_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Egh sipsipɨn apurim mɨsuegh akɨramɨn itir bretɨn yis puvatɨziba sara, Ikiavɨra Itir God ko navir vamɨran ikiamin ofa damuam. Egh wit tuamin ofa ko wainɨn dɨpabar ofa uaghan dar ofa damu. ");
INSERT INTO msy2020_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Eghtɨ God bativamin Purirpenimɨn tiar akamɨn boroghɨn, gumazir God bagha akar dɨkɨrɨzim gamizim, a uan dapanir arɨzibagh isegh, da inigh mangɨ God ko navir vamɨran ikiamin ofan apengan itir avim datɨghtɨ, da isigh. ");
INSERT INTO msy2020_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Gumazir kamɨn dapanir arɨziba isigh gɨvaghtɨ, gɨn ofa gamir gumazim, sipsipɨn apurimɨn aniavir agharimɨn tuzir me mɨnemɨn avigha gɨvazim, ko akɨramɨn itir yis puvatɨzir bret tam, ko yis puvatɨzir bisketɨn tam inigh, gumazir kamɨn dafarim datɨgh. ");
INSERT INTO msy2020_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Egh ofa gamir gumazim dar suiragh da fɨ dar amutɨ, da Ikiavɨra Itir Godɨn damazimɨn ighuavamangɨ. Kar ofa gamir gumazimɨn ofan zuruziba. Eghtɨ uaghan na ganɨngizir sipsipɨn evarim ko buaragharim, da ofa gamir gumazimɨn biziba. Eghtɨ gɨn God bagha akar dɨkɨrɨzim gamizir gumazim, wainɨn dɨpam amɨsɨ anemɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Arazir kabar mɨngarim kamakɨn. Gumazitam o amizitam uabɨ isɨ na danɨngɨsɨ, akam akɨrigh, egh me ofa damuamin arazir kabar gɨn mangɨ. Eghtɨ gumazitam bizir igharazitaba uaghan da na danɨngɨsɨ, akar dɨkɨrɨzim damigh, a guizbangɨra akar dɨkɨrɨzir kamɨn gɨn mangɨ a damu.” ");
INSERT INTO msy2020_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Nɨ, Aron uan otariba ko, nan arazir kɨ deragh Israelia damuamim, an gun me mɨkemegh. Eghtɨ me kamaghɨn Israelia mɨkɨm: ");
INSERT INTO msy2020_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘Ikiavɨra Itir God, deraghvɨra ia damuva, egh deraghvɨra ian ganam. ");
INSERT INTO msy2020_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ikiavɨra Itir God, ian apangkuv egh, mati an guamɨn angazangarim ia gisirazɨ moghɨn, deraghvɨra ian ganam. ");
INSERT INTO msy2020_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Egh Ikiavɨra Itir God, navir aghuim ian ikɨ, egh navir amɨrizim ko dabirabir aghuim ia danɨngam.’ ");
INSERT INTO msy2020_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Eghtɨ arazir kamɨn me nan ziam dɨponɨva nan azangsɨgh suam, Ikiavɨra Itir God, nɨ deraghvɨra Israelia damu. Eghtɨ kɨ bar deraghvɨra me damuam.” ");
INSERT INTO msy2020_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moses Ikiavɨra Itir Godɨn Purirpenim asaragha gɨfa. Egha aruer kamra, a olivɨn borem isa Purirpenim ko an aven itir biziba, ko ofa gamir dakozim ko an biziba bar, dagh ingegha, da isa God ganɨngizɨ, da God baghavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","3","Ezɨ Israelian anababar gumazir dapaniba, kar gumazir dapanir faragha gumazamizibar ziaba osirigha me mengeziba, me uan ofaba inigha Ikiavɨra Itir God bagha izi. Me 6plan karisba ko 12plan bulmakauba inigha Ikiavɨra Itir Godɨn Purirpenimɨn boroghɨn izi. Gumazir dapaniba vaghvagha bulmakaun vamɨra inigha ize. Egha gumazir dapanir pumuning uaning inigha karisɨn vamɨra inigha ize. Me bar da inigha iza ofa damuasa da arɨki. ");
INSERT INTO msy2020_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","5","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ ofan kaba, me dama da inigh na bativamin Purirpenimɨn ingangarim bagh, da isɨ Livain ikɨziba vaghvagh uan ingangariba bagh biziba atersɨ, da tuiragh me danɨng.” ");
INSERT INTO msy2020_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ezɨ Moses bulmakauba ko karisba isa Livaibagh anɨngi. ");
INSERT INTO msy2020_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","A karisɨn pumuning ko bulmakaun 4pla isa Gersonɨn ikɨzim ganɨngi, eghtɨ me dar ingangaribar amuam. ");
INSERT INTO msy2020_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Egha 4plan karisba ko 8plan bulmakauba Merarin ikɨzim ganɨngi, eghtɨ me dar ingangaribar amuam. Aronɨn otarim Itamar, me damuamin ingangaribar faragh mangɨ men ganam. ");
INSERT INTO msy2020_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Moses fo, Kohatɨn ikɨzim, me damuamin ingangarim, me Godɨn bizir zuruziba uan dɨpɨzibar da ateram. Kamaghɨn amizɨ, a karis ko bulmakaun tam me ganɨngizir puvatɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Me olivɨn borem isa ofa gamir dakozim gingegha God ganɨdima, an an bizimra otozir dughiamɨn, gumazir dapaniba uaghan uan ofaba inigha ofa gamir dakozimɨn boroghɨn izegha ofabar amuasava ami. ");
INSERT INTO msy2020_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Nɨ kamaghɨn 12plan gumazir dapanibav kɨm suam: Gumazir dapaniba vaghvagh aruebar vaghvagh uan ofaba isɨ God danɨng mangɨtɨ 12plan arueba gɨvagham. Me bar kamaghɨra ofa gamir dakozimɨn God danɨngɨsɨ, ofaba inigh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Ezɨ gumazir dapaniba vaghvagha, uan ofaba aruebar vaghvagha God bagha da isa izi. Ezɨ aruer namba 1ɨn, Judan anabamɨn gumazir dapanim Nason, an Aminadapɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 2ɨn Isakarɨn anabamɨn gumazir dapanim Netanel, a Suarɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 3ɨn, Sebulunɨn anabamɨn gumazir dapanim Eliap, a Helonɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 4ɨn, Rubenɨn anabamɨn gumazir dapanim Elisur, a Sedeurɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 5ɨn, Simeonɨn anabamɨn gumazir dapanim Selumiel, a Surisadain otarim, a uan ofa inigha izi. Ezɨ aruer namba 6ɨn, Gatɨn anabamɨn gumazir dapanim Eliasap, a Duelɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 7ɨn, Efraimɨn anabamɨn gumazir dapanim Elisama, a Amihutɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 8ɨn, Manasen anabamɨn gumazir dapanim Gamaliel, a Pedasurɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 9ɨn, Benjaminɨn anabamɨn gumazir dapanim Abidan, a Gideonɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 10ɨn, Danɨn anabamɨn gumazir dapanim Ahieser, a Amisadain otarim, a uan ofa inigha izi. Ezɨ aruer namba 11ɨn, Aserɨn anabamɨn gumazir dapanim Pagiel, a Okranɨn otarim, a uan ofa inigha izi. Ezɨ aruer namba 12ɨn, Naptalin anabamɨn gumazir dapanim Ahira, a Enanɨn otarim, a uan ofa inigha izi. Me bar moghɨra vaghvagha ofan magh ghuezir kaba inigha ize. Dar kara: silvan itarir ekiar vamɨra, an osɨmtɨzim 1 kilogrem ko akuam, ko silvan itarir dozir mam, an osɨmtɨzim 800 grem, aning inigha ize. Me itarir kamning uaghara plauan aghuim ko olivɨn borem sara veregh wit tuamin ofabar amuamim aning gatɨ. Egha me vaghvagha golɨn itariba inigha ize, dar osɨmtɨzim 110 grem. Itarir kaba, pauran mughuriar aghuim zuim bar dagh izɨfa. Egha me vaghvagha bulmakaun apurir igiar mam, ko sipsipɨn apurir mam, ko sipsipɨn nguzir azenir vamɨra itim inigha, ofan bar isia mɨghɨrim damuasa da inigha ize. Egha me vaghvagha arazir kuraba gɨn amadir ofan mɨn memen apurir mam inigha ize. Egha God ko navir vamɨran ikiamin ofabar amuasa bulmakaun apurir pumuning, ko sipsipɨn apurir 5pla, ko memen apurir 5pla, ko azenir vamɨra itir sipsipɨn nguzir 5pla, me bar ada inigha ize. ");
INSERT INTO msy2020_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","85","Gumazir dapanir 12plan kaba, ofa gamir dakozim God baghvɨra a danɨngasa, inigha izezir ofa damuamin biziba, ofa gamir gumaziba bar moghɨra da mengezɨ, dar dɨbobonim kamaghɨn ghu: 12plan silvan itarir ekiaba ko 12plan silvan itarir doziba. Dar osɨmtɨzim bar moghɨra, 28 kilogrem. ");
INSERT INTO msy2020_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Egha me 12plan golɨn itariba inigha ize. Dar osɨmtɨzim, bar moghɨra 1,320 grem. Ezɨ pauran mughuriar aghuim zuim dagh izɨfa. ");
INSERT INTO msy2020_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Egha me 12plan bulmakaun apuriba, ko 12plan sipsipɨn apuriba, ko 12plan sipsipɨn nguzir azenir vamɨra itiba, ofan bar isia mɨghɨribar amuasa da inigha ize. Egha uaghan da sara wit tuamin ofaba isa asɨzir kaba koma ofa gami. Egha uaghan arazir kuraba gɨn amadir ofabar mɨn, me 12plan memen apuriba inigha ize. ");
INSERT INTO msy2020_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Egha God ko navir vamɨran ikiamin ofa damuasa, 24plan bulmakaun apuriba, ko 60plan sipsipɨn apuriba, ko 60plan memen apuriba, ko 60plan sipsipɨn nguzir azenir vamɨra itiba, me bar moghɨra da inigha ize. Me faraghavɨra ofa gamir dakozim gamizɨ, a Ikiavɨra Itir God baghavɨra itir bizimɨn oto, egha gɨn me ofan avɨrir kaba bar dagh ami. ");
INSERT INTO msy2020_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ezɨ Moses Ikiavɨra Itir God ko mɨkɨmasa, a bativamin Purirpenimɨn aven ghu. Egha Ikiavɨra Itir Godɨn tiarim barazima, an Akar Dɨkɨrɨzir Gavgavimɨn Boksiamɨn asuam gisɨn itir enselɨn bar gavgavimningɨn tongɨra otogha Moses mɨgei. Boksiar kamɨn asuam, kar arazir kuraba gɨn amangamin danganim. ");
INSERT INTO msy2020_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Egha Ikiavɨra Itir God Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Nɨ Aron mɨkɨm suam: Nɨ 7plan lamba isɨ, lamɨn aghorim itir agharibar dar danganibar deraghvɨra da aseghtɨ, dar angazangarim lamɨn aghorimɨn guamɨn itir danganimɨn isiva angazangar.” ");
INSERT INTO msy2020_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Ezɨ Aron, Ikiavɨra Itir God Moses mɨkemezɨ moghɨn, lamba isa lamɨn aghorimɨn itir agharibar dar danganibar da afe, eghtɨ dar angazangarim lamɨn aghorimɨn guamɨn itir danganir kamɨn isiva angazangar. ");
INSERT INTO msy2020_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Ikiavɨra Itir God faragha Moses mɨkemezɨ moghɨn, me lamɨn aghorim kamaghɨn an ingari. Me hama isa golɨn aghuarim mɨsuegha lamɨn aghorimɨn ingara, an mɨngarimɨn ikegha an ingara uanaga, an pɨn itir agharibar itir akɨmaribar tu. ");
INSERT INTO msy2020_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Nɨ Israelian gumazamizibar tongɨn Livaibar diaghtɨ me izɨtɨ, nɨ me damightɨ, me nan damazimɨn zuegh. ");
INSERT INTO msy2020_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Me nan damazimɨn zueghsɨ, nɨ kamaghɨn damu. Nɨ dɨpar nan damazimɨn zueghamin taba isɨ, arazir kuraba gɨn amadir ofan mɨn, me gisɨn da kavamang. Egh me damutɨ, me uan mɨkarzimɨn itir arɨziba bar dagh isegh, uan korotiaba rueghɨva uari zuegh. ");
INSERT INTO msy2020_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Egh me bulmakaun apurir igiatam, ko wit tuamin ofa bagh, plauan aghuim ko olivɨn borem sara vereghɨva a inigh izɨ. Egh bulmakaun apurir igiar igharazitam, arazir kuraba gɨn amadir ofa damusɨ a inigh izɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Egh nɨ Israelian gumazamiziba bar me akuvagh, Livaibav kemeghtɨ, me izɨ na bativamin Purirpenimɨn guamɨn tuifigh. ");
INSERT INTO msy2020_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Livaiba nan damazimɨn ikɨvɨra ikɨtɨ, Israelian gumazamiziba uan dafariba isɨ, Livaibar dapanibagh isɨn dar arɨkigh. ");
INSERT INTO msy2020_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Eghtɨ Aron Israelian tongɨn Livaiba isɨ na danɨngigh, mati ia uan dafarimɨn ofan suiragha a fegha a gamizɨ, a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi. Arazir kamɨn, me Livaibar amightɨ, me nan ingangarim damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Eghtɨ Livaiba uan dafariba isɨ bulmakaun apurir kamningɨn dapanimning gisɨn dar arighɨva, aningɨn tam arazir kuraba gɨn amadir ofa damu, egh igharazim ofan bar isia mɨghɨrizim damu. Ofan kamning, Livaibar arazir kuraba gɨn amadaghtɨ me Godɨn damazimɨn zuegham. ");
INSERT INTO msy2020_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Mati ia uan dafarimningɨn ofan suiragha a fegha a gami a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi moghɨn, ia Livaiba isɨ na danɨngigh, eghtɨ me Aron ko an otaribar akuragh men ingangaribar amuam. ");
INSERT INTO msy2020_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Arazir kamɨn, nɨ Livaibar amightɨ, me Israelian gumazamizibar mɨn ikian kogham, me bar nan adarazira. ");
INSERT INTO msy2020_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Mati nɨ uan dafarimningɨn ofan suiragh a fegh a damutɨ a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi moghɨn, nɨ Livaibar amightɨ, me zuegh gɨvaghtɨ, nɨ me isɨ na danɨngigh. Kamaghɨn me na bativamin Purirpenimɨn aven ingaram. ");
INSERT INTO msy2020_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israelia bar men tongɨn, kɨ ua bagha Livaiba amɨsefe. Kɨ me gamizɨ, me Israelian otarir ivariaba bar, men danganim ini, ezɨ Livaiba bar nan adarazira. ");
INSERT INTO msy2020_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Bar guizbangɨra, kɨ Isipian otarir ivariabav mɨsoghezir dughiamɨn, kɨ Israelian otarir ivariaba ko sipsipba ko bulmakaun nguzir ivariaba, kɨ ua bagha me amɨsefe. Kamaghɨn amizɨ, me bar nan bizibara. ");
INSERT INTO msy2020_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Datɨrɨghɨn, kɨ Livaiba inigha me gamizɨ, me Israelian otarir ivariaba bar, men danganim ini. ");
INSERT INTO msy2020_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ezɨ kɨ Livaiba isa Aron uan otariba ko men agharim garɨsi. Eghtɨ me men akurvagh Israelia bagh na bativamin Purirpenimɨn ingar, an ganɨva ofabar amuva men arazir kuraba gɨn amangɨtɨ, me Godɨn damazimɨn zuegham. Me ian danganim inigha gɨfa. Kamaghɨn amizɨ, ian tav Anogoroghezir Danganimɨn boroghɨn mangan markɨ. Guizbangɨra, gumazir kɨnitaba danganir kamɨn boroghɨn mangɨtɨ, arazir bar kuraba me bativ, me gasɨghasɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Kamaghɨn amizɨ, Moses, ko Aron, Israelian gumazamiziba ko, me bar Livaiba isa God ganɨdi, mati Ikiavɨra Itir God Moses mɨkemezɨ mokɨn. ");
INSERT INTO msy2020_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Livaiba uari akɨrmigha uan arazir kuraba ategha uan korotiaba ruegha Ikiavɨra Itir Godɨn damazimɨn zue. Ezɨ Aron, mati a uan dafarimningɨn ofan suiragha a fegha a gamizɨ, a Ikiavɨra Itir Godɨn damazimɨn ighuavamadi moghɨn, a men arazir kuraba gɨn amangasa ofa gamigha, me isa God ganɨngi. ");
INSERT INTO msy2020_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ikiavɨra Itir God Livaiba bagha Moses mɨkemezɨ moghɨra, gumazamiziba biziba bar dagh ami. Kamaghɨn, Livaiba, Aron uan otariba ko men apengan ikia, God bativamin Purirpenimɨn ingangarim gami. ");
INSERT INTO msy2020_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Livaibar gumazir 25plan azenibar ikegha ghuavanadiba, me God bativamin Purirpenimɨn aven ingaram. ");
INSERT INTO msy2020_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Egh me 50plan azenibar otoghɨva, me Purirpenimɨn ingangariba ategh, avughsam. ");
INSERT INTO msy2020_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Egh gɨn, me pura uan aveghbuar na bativamin Purirpenimɨn aven uan ingangaribagh amibar akurvagham. Egh, me uari ua ingaran markɨ. Nɨ akar kam Livaibav kemeghtɨ, me kamaghɨn damu.” ");
INSERT INTO msy2020_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israelia Isipɨn kantri ategha Sainain gumazamiziba puvatɨzir danganimɨn itima, azenir namba 2 otozɨ an iakɨnir namba 1ɨn aven, Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","3","“Ia iakɨnir kam, an aruer namba 14ɨn guaratɨzimɨn, Israelian gumazamiziba, God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isar kamɨn, bizir kɨ damuasa ia mɨkemeziba ko arazir kɨ ifongeziba bar deravɨra dar gɨn mangɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kamagh amizɨ, Moses gumazamizibav kemezɨ, me God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isam damusɨ, an arazarazibar gɨn mangɨva isam damuam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Me Sainain gumazamiziba puvatɨzir danganimɨn ikia iakɨnir faragha zuimɨn, an aruer 14ɨn, guaratɨzimɨn, me isar ekiar kam gami. Me Ikiavɨra Itir God damuasa Moses mɨkemezɨ moghɨn ami. ");
INSERT INTO msy2020_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Isar kamɨn dughiamɨn, gumazir maba, gumazir aremezimɨn kuar mamɨn suiragha Godɨn damazimɨn mɨze. Me fo, me God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isam damuan kogham. Egha me Moses ko Aron bagha ghua kamaghɨn aning mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“E gumazir aremezimɨn kuamɨn suigha, Godɨn damazimɨn mɨze. E manmaghsu Israelian tongɨn, inabazir dughiar ekiar kamɨn Ikiavɨra Itir God bagh ofa damuan kogham?” ");
INSERT INTO msy2020_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Ezɨ Moses kamaghɨn me ikaragha ghaze, “Ia tong orarkegh, kɨ ia bagh Ikiavɨra Itir Godɨn azaragh fogham, a manmaghɨn e mɨkɨmam.” ");
INSERT INTO msy2020_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ezɨ Ikiavɨra Itir God, Israelian gumazamizibav mɨkɨmasa, kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ian tav, o ian ovavir boriba aremezir gumazir kuatamɨn suiragha nan damazimɨn mɨze, o ian tav tuavir ruaritamɨn ghua bar saghon iti, egh a gɨn isar kam damusɨ, iakɨnir akɨrangɨn itimɨn a damu. ");
INSERT INTO msy2020_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","12","Egh me namba 2ɨn iakɨnimɨn, an namba 14ɨn aruemɨn, an guaratɨzimɨn isam damuam. Me God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isar kamɨn araziba bar dar gɨn mangɨ. Me isam damusɨ, sipsipɨn asɨzir tuzim, ko yis puvatɨzir bret, ko zuravarir mɨsoziba sara damɨ. Egh me asɨzir tuzitam ateghtɨ a ikɨ mangɨ amɨmzaraghan otivan markɨ. Egh asɨzir kamɨn agharitam apɨran markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Eghtɨ gumazamizir nan damazimɨn zueziba, ko gumazamizir tuavir ruarimɨn ghua saghon itir danganimɨn itir puvatɨziba, me God Israelia Gitazir Dughiam Gɨnɨghnɨzir Isar kam damuan aghuaghɨva, me nan gumazamizibar ikian kogham. Me Israelian tongɨn ikian kogham. Bar guizbangɨra, ofan dughiamɨn, me ofa inigha Ikiavɨra Itir God ganɨngizir puvatɨ. Kamaghɨn amizɨ, me uari uan arazir kurabar ivezir kuram iniam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kantrin igharazitamɨn gumazamiziba ian tongɨn ikɨva, God Israelia Gitazir Dughiam Gɨnɨghnɨghamin Isar kam damusɨ, me arazir God ifongeziba bar deraghvɨra dar gɨn mangɨ. Arazir kamra, ia Israelia ko Kantrin Igharazibar Gumazamizir ian tongɨn itiba uaghara, arazir kam damu.” ");
INSERT INTO msy2020_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Moses Purirpenim asaragha bar ingangariba agɨvazɨ, ghuariar mam maghɨra iza God bativamin Purirpenim avara. Kar, Purirpenir Ikiavɨra Itir Godɨn Akar Dɨkɨrɨzir Gavgavimɨn Boksiam itim. Ezɨ zurara guaratɨzibar ikegh mangɨ amɨnim tir dughiam, ghuariar kam, avimɨn mɨn gari. ");
INSERT INTO msy2020_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Dughiabar zurara ghuariam Purirpenim ave. Gumazamiziba aruebar garima, ghuariam iti. Ezɨ dɨmagaribar me garima, an avimɨn mɨn isia ghuariamɨn aven iti. ");
INSERT INTO msy2020_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Israelian tuavir daroriba, me kamaghɨn ami: ghuariar ekiar kam Godɨn Purirpenim ategh pɨn sɨvaghsɨvagh mangɨtɨ, me an ganigh, egh dɨkavigh biziba inigh an gɨn mangam. Egh ghuariam izaghira itir danganimra ikɨtɨ, me ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ikiavɨra Itir God mɨkemeghtɨ, Israelian gumazamiziba danganir me itim ategham. An Akar Gavgavim me mɨkemeghtɨ, me ua danganir igiam aghuam. Eghtɨ ghuariar kam Purirpenimɨn pɨn ikɨvɨra ikɨtɨ, me danganir kamɨn ikɨvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ghuariar kam dughiar ruarimɨn Purirpenimɨn pɨn ikɨvɨra ikɨtɨ, Israelia Ikiavɨra Itir Godɨn akam baregh igharagh mangan kogham. ");
INSERT INTO msy2020_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Dughiar mabar, ghuariam Purirpenim gisɨn dughiar otevimra ikɨva dɨkavigh pɨn mangɨtɨ, me mangam. Ghuariam dughiar ruarim, o dughiar otevimɨn ikɨtɨ, me fo, Ikiavɨra Itir God Akar Gavgavim me danɨngasava ami. Ghuariam manmaghɨn ami, me puram an gɨn mangɨ, danganir me itim ategh mangam, o me ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Dughiar mabar ghuariam ikɨtɨ amɨnim pɨrightɨ, me ikɨ mangɨ amɨmzaraghan ghuariam dɨkavtɨ, me uaghan dɨkavigh danganir kam ategham. ");
INSERT INTO msy2020_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Dughiar mabar aruer pumuning, o iakɨnir vamɨra, o azenir vamɨra, o dughiaba manmaghɨn ruaragham, ghuariam Purirpenim gisɨn ikɨvɨra ikiam, eghtɨ me uaghan danganir kamɨn ikɨvɨra ikiam. Dughiar manamɨn ghuariam dɨkafi, me uaghan dɨkavigh mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ikiavɨra Itir God me mɨgeir dughiabar, me a baragha, ikiamin danganiba aghua iti. Ikiavɨra Itir God me mɨgeir dughiamɨn, me biziba isa danganiba ataghɨragha igharagha zui. Arazir kamɨn, Ikiavɨra Itir God Akar Gavgaviba isa Moses ganɨdima, a me mɨgeima, me an akamɨn gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ikiavɨra Itir God Moses mɨgɨa ghaze, ");
INSERT INTO msy2020_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ia silvan taba inigh, haman dav sueghɨva, sɨghar pumuningɨn ingarigh. Egh gɨn dughiar gumazamiziba uari akuvamim, o dughiar ia danganim ategh igharagh mangamimɨn, ia aning giviam. ");
INSERT INTO msy2020_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ia dughiar ruarimɨn sɨghamning uaghara aning givitɨ, gumazamiziba bar izɨ na bativamin Purirpenimɨn tiar akamɨn uari akufagh. ");
INSERT INTO msy2020_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ia sɨghar vamɨra givitɨ, Israelian anababar gumazir dapanibara izɨ nɨ ko uari akufagh. ");
INSERT INTO msy2020_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ia sɨghar vamɨra pamtemɨn dughiar otevimɨn a givitɨ, aruem anadi naghɨn itir anababa, dɨkavigh danganir me itim ategh mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ia namba 2ɨn dughiamɨn, sɨghar vamɨra pamtem dughiar otevimɨn a givitɨ, sautɨn amadaghan itir anababa dɨkavigh mangam. Sɨghar ararem otoghtɨ, me fogh suam, kar mangamin dughiam, egh dɨkavigh mangam. ");
INSERT INTO msy2020_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Eghtɨ Israelia bar izɨ uari akuvamin dughiam bagh, ia dughiar bar ruarimɨn sɨghar pumuning giviam. ");
INSERT INTO msy2020_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aronɨn otaribara, me ofa gamir gumaziba, me sɨghamning giviamin ingangarim damuam. Ia ko ian ovavir borir gɨn otivamiba, ia sɨghamning giviamin arazir kamɨn gɨn mangɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Apaniba izɨ ian nguazimɨn ia mɨsoghsɨ damutɨ, ia faragh sɨgham givitɨ, gumaziba zuamɨra dɨkavigh mangɨ apaniba ko mɨsogham. Ia kamaghɨn damutɨ, kɨ Ikiavɨra Itir God, ian God, kɨ ia gɨnɨghnɨgh ian akuragh ian apaniba abɨraghtɨ ia deraghvɨra ikiam. ");
INSERT INTO msy2020_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Egh uaghan, ia bar akueghamin dughiar ekiaba, kar ia Godɨn ziam famin dughiaba, ko iakɨnir igiaba otivir isaba, ko ian dughiar ekiar igharazibar, ia sɨgham givighɨva, uan ofan bar isia mɨghɨriba, ko God ko navir vamɨra ikiamin ofabar amuam. Eghtɨ kɨ ia gɨnɨghnɨgh ian akurvagham. Kɨ Ikiavɨra Itir God, ian God.” ");
INSERT INTO msy2020_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Israelian gumazamiziba Isip ategha azenan ize, ezɨ gɨn azenir namba 2 otozɨ, an iakɨnir namba 2ɨn aven, an aruer namba 20ɨn, ghuariam uan danganir Godɨn Purirpenim gisɨn itim ategha dɨkavigha zui. Purirpenir kam, me faragha Akar Dɨkɨrɨzir Gavgavim itir dagɨar akuamning a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ezɨ Israelia kamaghɨn ganigha, dɨkavigha Sainain gumazamiziba puvatɨzir danganim ategha, ghuariamɨn gɨn ghuavɨra ikia ghua garima, Paranɨn gumazamiziba puvatɨzir danganimɨn ghuariam an tu. ");
INSERT INTO msy2020_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Dughiar kam, a faragha zuir dughiar Ikiavɨra Itir God Moses mɨkemezɨ, Moses dɨkavigh mangasa Israelia mɨkemezɨ me dɨkavigha zui. ");
INSERT INTO msy2020_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Egha me zuir dughiamɨn, me uan ikɨzibar uarigh arigha uan fleghbar suigha zui. Judan anabamɨn ikɨzir 3pla faragha zui. Ezɨ Aminadapɨn otarim Nason, a Judan anabamɨn gumazir dapanim, egha uaghan 3plan ikɨzir kabar gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ezɨ Suarɨn otarim Netanel, a Isakarɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Ezɨ Helonɨn otarim Eliap, a Sebulunɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Ezɨ ofa gamir gumaziba Purirpenim ko an biziba adegha deraghavɨra da ike. Ezɨ Gersonɨn ikɨzimɨn adarasi, ko Merarin ikɨzimɨn adarasi, me Purirpenimɨn biziba atera faragha zuir Judan anabamɨn ikɨzir 3plan kabar gɨn zui. ");
INSERT INTO msy2020_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ezɨ men gɨn Rubenɨn anabamɨn ikɨzir 3plan adarazi me uan fleghɨn suiragha men gɨn zui. Sedeurɨn otarim Elisur, a 3plan ikɨzir kabar gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ezɨ Surisadain otarim Selumiel, a Simeonɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ezɨ Duelɨn otarim Eliasap, a Gatɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ezɨ Livain anabamɨn Kohatɨn ikɨzimɨn adarasi, Anogoroghezir Danganimɨn biziba ko Bar Anogoroghezir Danganimɨn biziba atera men gɨn zui. Livaibar ikɨzir igharazimning faragha ghua danganir igiar me ikiamimɨn otivigha Purirpenim asaragha gɨfa. Ezɨ Kohatɨn ikɨzimɨn adarazi men gɨn ghua danganir igiar me ikiamimɨn otifi. Egha me bizir me ateriba isa ofa gamir gumazibagh anɨngizɨ, me da isa Godɨn Purirpenim garɨsi. ");
INSERT INTO msy2020_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ezɨ Efraimɨn anabamɨn ikɨzir 3pla, uan fleghɨn suiragha Kohatɨn ikɨzimɨn gɨn zui. Ezɨ Amihutɨn otarim Elisama, a 3plan ikɨzir kabar gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ezɨ Pedasurɨn otarim Gamaliel, a Manasen anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ezɨ Gideonin otarim Abidan, a Benjaminɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ezɨ bar gɨn, Danɨn anabamɨn ikɨzir 3pla, me uan fleghɨn suiragha zui. Ezɨ Amisadain otarim Ahieser, a 3plan ikɨzir kabar gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ezɨ Okranɨn otarim Pagiel, an Aserɨn anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ezɨ Enanɨn otarim Ahira, a Naptalin anabamɨn gumazir dapanim. ");
INSERT INTO msy2020_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Dughiabar zurara, Israelia mangasa, me kamaghɨra uari afi. ");
INSERT INTO msy2020_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Me mangasava amima, Moses uan amerem Hobap, a kantri Midianɨn gumazim Ruelɨn otarim, kamaghɨn a mɨgei, “E datɨrɨghɨn danganir aghuir mamɨn mangam. Kar, danganir Ikiavɨra Itir God fomɨra e danɨngasa akar dɨkɨrɨzim gamizim. Ga uaning, nɨ e ko mangam. Eghtɨ e deraghvɨra nɨn ganam. Bar guizbangɨra, Ikiavɨra Itir God e ko akam akɨra ghaze, a bar deraghvɨra e damuam.” ");
INSERT INTO msy2020_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ezɨ Hobap a ikaragha ghaze, “Puvatɨ. Kɨ mangan aghua. Kɨ uamategh uan nguibam ko uan adarazi bagh mangam.” ");
INSERT INTO msy2020_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ezɨ Moses kamaghɨn a mɨgei, “O nan amerem, nɨ e ataghɨraghan markɨ. Danganir Gumazamiziba puvatɨzir e ikiamin kaba, nɨ bar dagh fo. Kamaghɨn amizɨ, nɨ e ko mangɨ tuavim en akakagham. ");
INSERT INTO msy2020_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Nɨ e ko izɨtɨ, Ikiavɨra Itir God e danɨngamin bizir aghuir manaba, e uaghan taba nɨ danɨngam.” ");
INSERT INTO msy2020_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Gumazamiziba dɨkavigha, Ikiavɨra Itir Godɨn mɨghsɨam ategha zuima, 3plan arueba gɨfa. Livaiba Ikiavɨra Itir Godɨn Akar Dɨkɨrɨzir Gavgavimɨn Boksiam atera faragha ghua, egha danganir me avughsamim bagha gari. ");
INSERT INTO msy2020_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Me zuir aruebar, Ikiavɨra Itir Godɨn ghuariam zurara me gisɨn ikia zui. ");
INSERT INTO msy2020_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Me Akar Dɨkɨrɨzir Gavgavimɨn Boksiam inigha mangasava amir dughiabar, Moses zurara kamaghɨn mɨgei, “O Ikiavɨra Itir God, nɨ dɨkavigh mangɨ uan apaniba ko mɨsogh me batokegh. Egh gumazir nɨ gifongezir puvatɨziba, nɨ me damightɨ, me tintinibar aregh.” ");
INSERT INTO msy2020_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Me avughsasa Akar Dɨkɨrɨzir Gavgavimɨn Boksiam arɨzir dughiabar, Moses zurara kamaghɨn mɨgei, “O Ikiavɨra Itir God, nɨ Israelian tausenɨn avɨrir pozim bagh uamategh izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Gumazamiziba osɨmtɨzir me bativiba bangɨn puvɨra Ikiavɨra Itir God gimobava an dei. Ezɨ Ikiavɨra Itir God me baregha, men atara an navim me bagha puv an isima, an avim me mɨkɨni. Ezɨ me iti naghɨn mɨtaghniabar boroghɨn, avim bar dar isi. ");
INSERT INTO msy2020_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Ezɨ gumazamiziba uarir akurvaghasa Mosesɨn deima, Moses Ikiavɨra Itir God ko mɨgeima, avim munge. ");
INSERT INTO msy2020_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Danganir kam, me kamaghɨn a dɨbori, Tabera. Ziar kamɨn mɨngarim kamakɨn, “Avim Isir Danganim.” Ziar kamɨn nɨghnɨzim kamaghɨn zui, danganir kamɨn, Ikiavɨra Itir Godɨn avim men tongɨn isi. ");
INSERT INTO msy2020_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ikɨzir igharazibar gumazamizir maba uaghan Israelia ko zui. Me asɨzitabar amasa men aguiaba puv men ingari. Ezɨ Israelia uaghan imoba atara bizir kam bagha ara ghaze, “Oio! E asɨzir tabar ameka! ");
INSERT INTO msy2020_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","E fomɨra Isipɨn kantrin ikiava osirir avɨriba puvɨram ada api, egha dagh ivezir puvatɨ. Egha e zurara, kukambaba ko melonba, ko anianba, ko galikba apavɨra iti. ");
INSERT INTO msy2020_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ezɨ datɨrɨghɨn en gavgaviba bar gɨfa. E damamin bizitam ua itir puvatɨ. Dughiabar zurara, e manan dagher kamram apa ghua bar an amɨra. E bar uarir apangkufi!” ");
INSERT INTO msy2020_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manan dagher kamɨn ganganim, mati temer ovɨzir muziarim, egha ghurghurigha iangurungi. ");
INSERT INTO msy2020_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Me itir danganimɨn manan dagheba, dɨmagaribar ghuariam sara iri. Amɨmzaraghan gumazamiziba dɨkavigh daru da akumakum dagɨabar da mɨrmɨram, o itarir ekiamɨn aven temer otevimɨn dav soghtɨma, da plaua gavagham. Ezɨ dar maba me mɨnebar da avigha, dar maba inigha bisketbar ingari. Me da apima, dar isɨngtɨzim, mati bisketɨn me olivɨn borem sara ingariziba. ");
INSERT INTO msy2020_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Gumazamiziba uan ikɨziba ko, uan purirpenibar tiar akabar boroghɨn tuivighav ikia imobava araima, Moses men dɨmdiaba barasi. Ezɨ Ikiavɨra Itir God atara me bagha an navim puvɨra an isi. Kamaghɨn amizɨ, Mosesɨn navim bar a basemezɨ, a kamaghɨn Ikiavɨra Itir God mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","“Nɨ manmaghsua paza na gami? Nɨ manmaghsua na gakongezir puvatɨ? Nɨ manmaghsua gumazamizir kabar ganamin ingangarim na ganɨngi? ");
INSERT INTO msy2020_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Kɨ men ingarizir puvatɨgha me batezir puvatɨ. Kɨ men amebam puvatɨ. Tizim bagha, nɨ me isa nan dafarimning gatɨgha ghaze, kɨ men amebamɨn mɨn me ater otem me danɨngɨva, me inigh bar mangɨ nguazir nɨ men inazir afeziabar anɨngasa akar dɨkɨrɨzim gamizɨ naghɨn otogham? ");
INSERT INTO msy2020_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Gumazamizir kaba arava asɨziba bagha nan azai. Kɨ managh me bagh asɨzir avɨriba iniam? Kɨ bar iburaghburaki. ");
INSERT INTO msy2020_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Kɨ uabɨra manmaghɨn gumazamizir avɨrir kabar amuam? Kɨ osɨmtɨzir ekiar kam ateran bar iburaghburaki. ");
INSERT INTO msy2020_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nɨ kamaghɨn na damusɨ, nɨ nan apangkuvigh na mɨsueghtɨ, kɨ aremegh, uam osɨmtɨzir kam ateran kogham.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ezɨ Ikiavɨra Itir God, kamaghɨn Moses mɨgei, “Nɨ 70plan Israelian gumazir aruaba inigh na bagh izɨ. Gumazir kaba, nɨ uabɨ me gɨfogha gɨvagha ghaze, me guizbangɨra gumazir dapaniba, egha gumazamizibar damazimɨn me ziar ekiaba iti, gumazir kaba, nɨ me inigh izɨ. Nɨ me inigh na bagh na bativamin Purirpenimɨn izɨtɨ, me nɨ ko uari akuvagh tuifigh. ");
INSERT INTO msy2020_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Eghtɨ kɨ izighirɨ nɨ ko mɨkɨm, egh Duar kɨ nɨ ganɨngizir kam da gavgavitaba inigh, me darɨgham. Eghtɨ me uaghan nɨn akuragh gumazamizir kabar osɨmtɨzitaba ateram, eghtɨ nɨ uabɨra da ateran kogham. ");
INSERT INTO msy2020_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Nɨ gumazamizibav kɨm suam: Ia gurum mɨzaragh bagh uari akɨrigh Godɨn damazimɨn zuegh, egh damamin asɨziba iniam. Ia asɨziba bagha arair ararem, Ikiavɨra Itir God a baregha gɨfa. Ia ghaze, ‘E asɨzitabar ameka! E faragha deragha Isipɨn iti.’ Ia oragh, Ikiavɨra tir God datɨrɨghɨn damamin asɨziba ia danɨngtɨ, ia dar amɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Ia aruer vamɨra, o pumuning, o 5pla, o 10pla, o 20plan aruebar asɨzibar aman kogham. Bar puvatɨgham. ");
INSERT INTO msy2020_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ia iakɨnir vamɨran arueba bar, ia asɨzibar amɨ mangɨ egh dar aghuagh mighsɨ damuam. Ikiavɨra Itir God ia ko itima ia akɨrim ragha a gasara, egha ara ghaze, ‘E bar tizim bagha Isip ategha ize?’ Ia kamaghɨn mɨkemezɨ, bizir kam bangɨn, arazir kam ia bativam.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ezɨ Moses Ikiavɨra Itir God ikaragha ghaze, “Ame! Kɨ 600,000ɨn gumazibara gari. Ezɨ nɨ ghaze, nɨ iakɨnir vamɨran asɨziba me danɨngtɨ me dar amam? Asɨzir kaba, da managh iti? ");
INSERT INTO msy2020_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","E bulmakauba ko sipsipba bar dav sueghtɨ, asɨzir kaba ti men tughatɨghan kogham. Eghtɨ ongarimɨn itir osiriba bar, ti men tughatɨghan kogham.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ezɨ Ikiavɨra Itir God Moses ikaragha ghaze, “Kɨ ti gavgaviba puvatɨghama? Nɨ kɨran oveghangɨn ganigh fogham, nan mɨgɨrɨgɨam ti daghem otogham, o puvatɨgham.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Ezɨ Moses dɨkavigha azenan ghua, Ikiavɨra Itir God mɨkemezir bizibar gun gumazamizibav keme. Egha 70plan gumazir dapanibav sevegha me gamizɨ, me uari akuvagha Purirpenim ekɨarugha itima, Moses aven ghu. ");
INSERT INTO msy2020_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ezɨ Ikiavɨra Itir God, ghuariamɨn tongɨn izaghira Moses ko mɨgɨa, a ganɨngizir Godɨn Duar an itir kamɨn gavgavir maba abigha da isa 70plan gumazir dapanir kabagh arɨki. Ezɨ Godɨn Duam me ko itima, me maghɨra dughiar otevimɨn akam inigha izir gumazibar mɨn akam akuri. ");
INSERT INTO msy2020_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ezɨ gumazir dapanir 70plan kabar aven itir gumazir pumuning, Eldat ko Medat, aning me itir danganir kamɨn ikiavɨra iti. Aning gumazir dapanir igharaziba ko Purirpenimɨn ghuzir puvatɨ. Aning danganir me itimra itima, Ikiavɨra Itir God, uan Duam aning gatɨzɨ, aning maghɨra akam inigh izir gumazimɨn mɨn akam akuri. ");
INSERT INTO msy2020_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ezɨ gumazir igiar mam ivegha ghua kamaghɨn Moses mɨgɨa ghaze, Eldat ko Medat danganir ia itimra an aven ikia, akam inigha izir gumazibar mɨn akam akuri. ");
INSERT INTO msy2020_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Ezɨ Nunɨn otarim Josua, a igiamra ikia, Mosesɨn akurvagha izi. A kamaghɨn Moses mɨgei, “Nan gumazir ekiam, nɨ mangɨ aningɨn anogoreghtɨ aning bizitam mɨkɨman markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ezɨ Moses a ikaragha ghaze, “Gumazitam ti nan danganim inian nɨ aghua? Nan ifongiam kamakɨn, Ikiavɨra Itir God, uan Duam isɨ bar uan gumazamizibar anightɨ, me akam inigha izir gumazibar mɨn akam akunam!” ");
INSERT INTO msy2020_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Egha Moses 70plan gumazir dapaniba ko uamategha, danganir me itimɨn ghue. ");
INSERT INTO msy2020_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ezɨ Ikiavɨra Itir God amɨnim gamizɨ, an ongarimɨn dɨkavigha ivava, kuarazir avɨriba inigha izima da mɨgha iza, Israelia itir danganimɨn boroghɨn ira bar a gizɨvagha tintinimɨn danganiba bar dagh izɨfa. Da bar vazimra 1 mitan nguazim gisɨrara mɨghagha arua, tintinibar danganir me itim gira, azenan danganir me ekɨaruzim sara ira ghua, aruer vamɨran darorimɨn mɨtaghniamɨn mɨn ghu. ");
INSERT INTO msy2020_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ezɨ gumazamiziba aruer vamɨra ko dɨmagarim sara puvɨra ingarava kuarazir bar avɨriba isa zuima, aruer pumuning gɨfa. Gumazamiziba kuarazir bar avɨriba ini, ezɨ dar osɨmtɨzim 1,000 kilogremɨn tu. Ezɨ gumazamizir avɨrim kuarazir bar avɨriba inizɨ dar osɨmtɨzim 1,000 kilogrem gafira. Egha me da apuzasa dar ghora pura nguazim garɨsi, eghtɨ aruem dar gantɨ da mɨsɨngam. ");
INSERT INTO msy2020_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Me kuarazir tuziba apavɨra itima, Ikiavɨra Itir God men anɨngaghegha, me bagha navim puv isia arɨmariar kurar mam amadazɨ, gumazamizir avɨrim ariaghire. ");
INSERT INTO msy2020_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Danganir kamɨn, me gumazamizibar kuaba afegha, a dɨbora ghaze, Kibrot Hatava. Ziar kamɨn mɨngarim kamakɨn, “Asɨziba bagha puvɨra arair gumazamizibar kuaba afezir danganim.” ");
INSERT INTO msy2020_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Egha gɨn Israelia danganir kam ategha ghua, Haserotɨn danganim aghuigha an iti. ");
INSERT INTO msy2020_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moses a kantri Itiopian amizir mamɨn iti. Ezɨ Israelia Haserotɨn danganimɨn itir dughiamɨn, Aron ko Miriam, aning an amuim bangɨn pazava a mɨkeme. ");
INSERT INTO msy2020_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Aning kamaghɨn a mɨgei, “Moses ti ghaze, Ikiavɨra Itir God anarɨra mɨgei. Puvatɨ, a uaghan ga mɨgei.” Ezɨ Ikiavɨra Itir God aningɨn imobir kam baraki. ");
INSERT INTO msy2020_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Guizbangɨra, Moses, a uabɨ abɨrir gumazim, nguazimɨn itir gumazitam an mɨn uabɨ abɨrir puvatɨ.) ");
INSERT INTO msy2020_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Egha zuamɨra Ikiavɨra Itir God kamaghɨn Moses, ko Aron ko Miriam mɨgei, “Ia na bativamin Purirpenimɨn tiar akamɨn izɨ.” Ezɨ me ghue. ");
INSERT INTO msy2020_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ezɨ Ikiavɨra Itir God ghuariar ruarir ekiamɨn aven ikia izaghira Purirpenimɨn tiar akamɨn tugha dei, “Aron ko Miriam, gua kagh izɨ.” Ezɨ aning oregha sɨvagha roghɨra ghu. ");
INSERT INTO msy2020_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ezɨ Ikiavɨra Itir God kamaghɨn aning mɨgei, “Gua oraghtɨ kɨ datɨrɨghɨn gua mɨkɨmam. Kɨ Ikiavɨra Itir God. Ian tongɨn akam inigha izir gumazitam ikɨtɨ, kɨ irebamɨn mɨn garir bizibar aven, uabɨ isɨ an akaghɨva bizibar gun an mɨkɨmam. Egh kɨ irebabar aven a ko mɨkɨmam. ");
INSERT INTO msy2020_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ezɨ nan ingangarir gumazim Moses, a bar ighara. Kɨ garima, a nan gumazamizibar tongɨn nɨghnɨzir gavgavim nan ikia deravɨra nan gɨn izi. Kɨ uan gumazamizibar ganamin ingangarim a ganɨngizɨ, a bar deraghavɨra men gari. ");
INSERT INTO msy2020_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ga roroamningɨn mɨn guizbangɨra uan guamningɨn gara, uaning ko mɨgei. Kɨ akar mogomeba ko akar isɨn zuibar a ko mɨgeir puvatɨ. Kɨ bighavɨra bizibar a mɨgei. Ezɨ a uaghan nan nedazimɨn gari. Kamaghɨn amizɨ, gua manmaghsua nan ingangarir gumazim akam a gasi?” ");
INSERT INTO msy2020_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Egha Ikiavɨra Itir God aning bagha navim bar ikuvigha aningɨn atara, aning ategha ghu. ");
INSERT INTO msy2020_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ezɨ Godɨn ghuariam Purirpenim ategha ghuzɨ, lepan arɨmariam maghɨra, Miriamɨn mɨkarzimɨn otogha bar ghurghuri. Ezɨ Aron raghɨrɨgha an garima, lepan arɨmariam an mɨkarzim bar anevarazɨ, ");
INSERT INTO msy2020_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","a Moses mɨgei, “Aruam, ga uaning, nɨ gan apangkuvigh, egh gan arazir kurar onganir kam bangɨn ivezir kuram ga danɨngan markɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Nɨ aneteghtɨ, a mati borim aremezɨ, amebam an kuam batezɨ moghɨn ganan markɨ. Nɨ an amamangatɨghtɨ, arɨmariar kurar kam bar an mɨkarzim damutɨ an mɨkarzir vuem ikuvigh puvatɨghan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Ezɨ Moses Ikiavɨra Itir Godɨn dɨa ghaze, “O God, kɨ kamaghsua, nɨ Miriamɨn mɨkarzim damightɨ, a ua deragh.” ");
INSERT INTO msy2020_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ezɨ Ikiavɨra Itir God a ikaragha ghaze, “An afeziam ti an guam giparightɨ, an aghumsɨzim aterɨva danganir e itimɨn azenan ikɨ mangɨtɨ, 7plan arueba gɨvagham. Kamaghɨn, nɨ aneteghtɨ an azenan ikɨ mangɨtɨ, wighɨn vamɨra gɨvaghtɨ, gɨn nɨ a inigh ua danganir ia itimɨn aven izɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kamaghɨn amizɨ, me Miriam batoghezɨ, a Israelian gumazamizibar danganir me itimɨn azenan itima, Israelian gumazamiziba ua tamoghɨn ghuezir puvatɨ. Me ikiavɨra itima 7plan arueba gɨvazɨ, me ua Miriam inigha uamategha me itir danganimɨn aven ize. ");
INSERT INTO msy2020_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Egha gɨn, me dɨkavigha Haserot ategha ghua, Paranɨn gumazamiziba puvatɨzir danganimɨn otogha, danganim aghuigha an iti. ");
INSERT INTO msy2020_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, ");
INSERT INTO msy2020_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Nɨ 12plan anababa bar dar vaghvagh, dar gumazir dapanir vamɨra vamɨra mɨsefegh. Egh nɨ 12plan gumazibar amangightɨ, me moga garir gumazibar mɨn mangɨ Kenanɨn nguazir kɨ ia danɨngamim getigh.” ");
INSERT INTO msy2020_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ezɨ Moses Ikiavɨra Itir Godɨn akam baregha, Israelian 12plan gumazir dapaniba amangizɨ, me Paranɨn gumazamiziba puvatɨzir danganimɨn dɨkavigha moga garir gumazibar mɨn Kenanɨn nguazim getiasa zui. ");
INSERT INTO msy2020_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Men ziabar kara: Sakurɨn otarim Samua, a Rubenɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Horin otarim Safat, a Simeonɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Jefunen otarim Kalep, a Judan anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Josepɨn otarim Igal, a Isakarɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Nunɨn otarim Josua, a Efraimɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Rafun otarim Palti, a Benjaminɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sodin otarim Gadiel, a Sebulunɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Susin otarim Gadi, a Manasen anabamɨn mav. (Manase, a Josepɨn otarimningɨn mav.) ");
INSERT INTO msy2020_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Gemalin otarim Amiel, a Danɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Maikelɨn otarim Setur, a Aserɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Vopsin otarim Nabi, a Naptalin anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Makin otarim Guel, a Gatɨn anabamɨn mav. ");
INSERT INTO msy2020_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Gumazir dapanir kaba, Moses moga garir gumazibar mɨn, Kenanɨn nguazimɨn getiasa me amangi. Egha Nunɨn otarim Hosia, Moses an ziam giragha, “Josua,” a gatɨ. ");
INSERT INTO msy2020_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moses moga garir gumazibar mɨn me amangasa kamaghɨn me mɨgei, “Ia mangɨ Negevɨn Distrighɨn aven mangɨva, anetegh mɨghsɨaba itir danganimɨn otogh. ");
INSERT INTO msy2020_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Egh ia deraghvɨra mongegh ganigh fogham, nguazim manmaghɨn gari, ezɨ an gumazamiziba avɨrasemez, o puvatɨ? Egha me gavgaviba iti, o puvatɨ? ");
INSERT INTO msy2020_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ia nguazim asavsuigh, a gɨfogham, a deraz, o a ikufi. Ia uaghan an nguibabar gan da asavsuigh, da dɨvazir bar gavgaviba iti, o da pura iti? ");
INSERT INTO msy2020_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Egh deraghvɨra nguazim getigh a gɨfogh, me dagheba oparan a deraz, o puvatɨ? Ezɨ temer manmaghɨn gariba aghui, egha uaghan ruaritaba iti, o puvatɨ? Kar wainɨn ovɨziba faragha anir dughiam, kamaghɨn, ia ter ovɨzitaba sara inigh izɨ. Ia pura izan markɨ. Ia atiatingan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kamaghɨn amizɨ, 12plan gumazir kaba moga garir gumazibar mɨn Kenanɨn nguazim getiasa ghue. Me Sautɨn amadaghan Senɨn gumazamiziba puvatɨzir danganimɨn otogha ghua nguibar ekiam Rehopɨn oto, a notɨn amadaghan ikia Hamatɨn nguibar ekiamɨn zuir tuavir akamɨn boroghɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Me sautɨn itir gumazamiziba puvatɨzir danganimɨn aven ghua Negevɨn Distrighɨn otogha ghua, Hebronɨn nguibar ekiamɨn oto. Dughiar kam, gumazir bar dafar ruarim Anak, an ovavir boriba iti, men ziabar kara: Ahiman, Sesai, ko Talmai, me Hebronɨn nguibar ekiamɨn iti. (Hebronɨn nguibar ekiam, gumazir maba fomɨra an ingari, ezɨ 7plan azeniba gɨvazɨ, Isipia nguibar ekiam Soanɨn ingari.) ");
INSERT INTO msy2020_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ezɨ gumazir dapanir kaba ghua, Eskolɨn danganir zarimɨn otogha ghua wainɨn ikarɨzimɨn aguar mam atu. Wainɨn aguar kam, wainɨn ovɨziba bar izɨvagha bar osemezɨ, gumazir vamɨra aneteran ibura. Me nogorimɨn a ikegha gumazir pumuning aneteri. Egha me uaghan fighɨn ovɨziba ko pomigranetɨn ovɨzir maba sara ini. ");
INSERT INTO msy2020_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kamaghɨn amizɨ, me danganir zarir kam, ziam “Eskol,” a gatɨ. An mɨngarim kamakɨn, wainɨn aguar ovɨziba bar izɨvazim. ");
INSERT INTO msy2020_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","26","Me Kenanɨn nguazim 40plan aruebar moga a getia gara anesavsuigha, uamategha Kadesɨn nguibar ekiamɨn ghu. Kades, a Paranɨn gumazamiziba puvatɨzir danganimɨn iti. Egha me Moses, ko Aron ko Israelian gumazamiziba, bizir me ganizibar me geghari. Egha temer ovɨzir kaba men akakagha ghaze, ia kagh temer ovɨzir kabar gan. ");
INSERT INTO msy2020_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Egha me kamaghɨn Moses mɨgei, “Nguazir, nɨ etiasa e amadazir kam, e an ganigha gɨfa. Nguazir kam a bar dera, ezɨ biziba an ikiava bar deragha aghui. Nɨ ge, e an dagher maba inigha ize. ");
INSERT INTO msy2020_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Egha nguazir kamɨn itir gumazamiziba, bar gavgafi. Ezɨ men nguibaba bar ekevegha da avɨnizir dɨvaziba bar gavgafi. E uaghan Anakɨn ovavir boribar gani, me gumazir bar dafar ruariba. ");
INSERT INTO msy2020_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ezɨ Amalekia sautɨn amadaghan itir Negevɨn Distrighɨn iti. Ezɨ, Hitia, ko Jebusia, ko Amoria mɨghsɨabar itir danganibar iti. Ezɨ Kenanian Mediterenianɨn Ongarir Ekiamɨn dadarimɨn iti. Ezɨ men marazi Jordanɨn Fanemɨn mɨriamɨn iti.” ");
INSERT INTO msy2020_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ezɨ Israelia, gumazir dapanir kabar akam baregha me atiati. Egha Mosesɨn damazimɨn mɨgɨavɨra iti. Ezɨ Kalep dɨkavigha me gamizɨ, me nɨmɨra itima, a kamaghɨn me mɨgei, “E zuamɨra dɨkavigh mangɨ me mɨsogh men nguazim inika. E gavgaviba iti, e me abɨnigham.” ");
INSERT INTO msy2020_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ezɨ gumazir igharazir Kalep ko ghueziba kamaghɨn me mɨgei, “Bar puvatɨ. Gumazir kaba, men gavgaviba bar en gavgavibagh afira. Kamaghɨn amizɨ, e mangɨ me ko mɨsoghan iburaghburegham.” ");
INSERT INTO msy2020_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Egha me ganizir bizibar ghuangsɨgha ifara ghaze, “Nguazir kam derazir puvatɨ. A biziba puvatɨ. An dagheba deragh aghungan kogham. Ezɨ gumazamiziba bar dagheba puvatɨzɨ, mɨtiriaba men a izi. Ezɨ gumazir e ganiziba bar, me maburan gumazir ruariba. ");
INSERT INTO msy2020_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Bar guizbangɨra, Anakɨn ovavir boriba bar ruarigha ekefe. E uarir gari, e bar suvigha pura gumazir kɨniba, egha odezibar mɨn gari. E fo, me ti en gantɨ, e bar suvigh odezibar mɨn ganam.” ");
INSERT INTO msy2020_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Israelian gumazamiziba, 12plan gumazir dapanibar eghaghaniba baregha, dɨmagarir kamɨn pamten tiariba akara aziava ara ghuav itima, amɨnim tira. ");
INSERT INTO msy2020_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Egha dɨkavigha ghua imoba mɨgɨrɨgɨar avɨribar Moses ko Aron gamua ghaze, “E Isipɨn kantrin ikiava aremezɨ, deraghai o, e gumazamiziba puvatɨzir danganir kamɨn ikia ariaghirezɨ, deraghai! ");
INSERT INTO msy2020_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Tizim bagha, Ikiavɨra Itir God e inigha Kenanɨn zui? Me en taraziv sueghtɨ, e arɨmɨghiregham. Me ti en amuiba ko boriba inightɨ, me men ingangarir gumazamizir kɨnibar mɨn otivigham. E ti uamategh Isipɨn mangɨtɨ deragham.” ");
INSERT INTO msy2020_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Egha me uariv gɨa ghaze, “E uari bagh gumazir dapanitam amɨseveghtɨ, an e inigh uamategh Isipɨn mangam.” ");
INSERT INTO msy2020_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ezɨ Moses ko Aron, gumazamiziba bar men damazimɨn nguazim girɨgha, guamning nguazim mɨtua. ");
INSERT INTO msy2020_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ezɨ Nunɨn otarim Josua, ko Jefunen otarim Kalep, aning moga garir gumazibar tongɨn gumazir mamning, aning bar osemegha uan korotiaba abɨagharɨki. ");
INSERT INTO msy2020_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Egha aning kamaghɨn gumazamizibav gei, “Ga uaning nguazir kam bar a garua an gani, a bar dera. ");
INSERT INTO msy2020_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ikiavɨra Itir God, e bagha bar akongegha, guizbangɨra e inigh nguazir kamɨn aven mangɨ a isɨ e danɨngam. Kar nguazir bar aghuim, ezɨ dagheba an ikiava bar deraghavɨram aghui. ");
INSERT INTO msy2020_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ia deravɨram oragh! Ia Ikiavɨra Itir Godɨn akaba batoghan markɨ! Egh ia gumazamizir nguazir kamɨn itibar atiatingan markɨ. Me pura bizibar mɨn, e me mɨsoghɨrarigham, mati gumazim asɨzir tuzim apa a tuavaremezɨ a bar iraghu. Men garir aseba, men akuraghan kogham. Ikiavɨra Itir God, e ko ikɨ me abɨragham. Kamaghɨn amizɨ, ia men atiatingan markɨ.” ");
INSERT INTO msy2020_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ezɨ Israelian gumazamiziba bar, Josua ko Kalepɨn akam nɨghnɨzir gavgavim an itir puvatɨgha, dagɨabar aning ginivightɨ, aning aremeghasa. Egha gumazamiziba maghɨra garima, Ikiavɨra Itir Godɨn angazangarir bar gavgavim zuamɨra izaghira a bativamin Purirpenim gisɨn iti. ");
INSERT INTO msy2020_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ezɨ Ikiavɨra Itir God kamaghɨn Moses mɨgei, “Kɨ mirakelɨn ekiar avɨribar gumazamizir kaba bagha dagh ami. Ezɨ me nan akam barazir puvatɨgha, nɨghnɨzir gavgavim nan itir puvatɨ. Me dughiar bar ruarimɨn, bar nan aghua. Kɨ bar men amɨragha men atari. ");
INSERT INTO msy2020_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kamaghɨn, kɨ arɨmariar ekiar kuratam amadaghtɨ, a me gasɨghasɨgham. Kɨ nɨ damightɨ nɨn ovavir boriba, ikɨzir ekiamɨn otogh bar gavgavigham. Eghtɨ men gavgavim bar Israelian gavgavim gafiragham.” ");
INSERT INTO msy2020_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ezɨ Moses kamaghɨn Ikiavɨra Itir God ikaragha ghaze, “O Ikiavɨra Itir God, nɨ uabɨ, uan gavgavir ekiamɨn gumazamizir kaba Isipɨn kantrin me inigha azenan ize. Nɨ me gasɨghasightɨ, Isipia bizir kamɨn akam baregham. ");
INSERT INTO msy2020_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Egh me Kenania mɨkemegham. Nɨ fo, Kenania kamaghɨn oraki, nɨ Ikiavɨra Itir God, nɨ e ko ikia uabɨ isa en akakazima, e nɨn boroghɨn ikia nɨn gari