﻿USE sofia;
DROP TABLE IF EXISTS sofia.msmNT_vpl;
CREATE TABLE msmNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES msmNT_vpl WRITE;
INSERT INTO msmNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Seini to napuunan ni Jesu-Cristo no Kaliwat ni David dow ni Abraham. ");
INSERT INTO msmNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Si Abraham amoy ni Isaac. Si Isaac amoy ni Jacob. Si Jacob amoy ni Juda dow to mgo suun din. ");
INSERT INTO msmNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Si Juda amoy ni Fares dow ni Zera, si Tamar to inoy dan. Si Fares amoy ni Esrom. Si Esrom amoy ni Aram. ");
INSERT INTO msmNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Si Aram amoy ni Aminadab. Si Aminadab amoy ni Naason. Si Naason amoy ni Salmon. ");
INSERT INTO msmNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Si Salmon amoy ni Boos, si Rahab to inoy din. Si Boos amoy ni Obed, si Ruth to inoy din. Si Obed amoy ni Isai. ");
INSERT INTO msmNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Si Isai amoy ni Hari David. Si David amoy ni Salomon. To inoy din, asawa ni Urias notoduon no naasawa on isab ni David. ");
INSERT INTO msmNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Si Salomon amoy ni Roboam. Si Roboam amoy ni Abias. Si Abias amoy ni Asa. ");
INSERT INTO msmNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Si Asa amoy ni Josafat. Si Josafat amoy ni Joram. Si Joram amoy ni Usias. ");
INSERT INTO msmNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Si Usias amoy ni Jotam. Si Jotam amoy ni Acas. Si Acas amoy ni Ezequias. ");
INSERT INTO msmNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Si Ezequias amoy ni Manases. Si Manases amoy ni Amon. Si Amon amoy ni Josias. ");
INSERT INTO msmNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Si Josias amoy ni Jeconias dow mgo suun din. Sikan to panahon no pigbihag to mgo Hibru aw daeha diya to Babilonia. ");
INSERT INTO msmNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tapus sikandan daeha diya to Babilonia, mey anak ni Jeconias, si Salatiel. Si Salatiel amoy ni Sorobabel. ");
INSERT INTO msmNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Si Sorobabel amoy ni Abiud. Si Abiud amoy ni Eliaquim. Si Eliaquim amoy ni Asor. ");
INSERT INTO msmNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Si Asor amoy ni Sadoc. Si Sadoc amoy ni Aquim. Si Aquim amoy ni Eliud. ");
INSERT INTO msmNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Si Eliud amoy ni Eleasar. Si Eleasar amoy ni Matan. Si Matan amoy ni Jacob. ");
INSERT INTO msmNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Si Jacob amoy ni Jose. Si Jose bana ni Maria no inoy ni Jesus no og-ilingon to Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Na, sugud ki Abraham pailing diya ki Hari David, meyduon sampuyu-tag-upat no ka kaliwatan. Sugud ki David kotob no bihagon to mgo Hibru diya to Babilonia, meyduon isab sampuyu-tag-upat no ka kaliwatan. Sugud duon kotob no i-anak si Cristo, meyduon manda sampuyu-tag-upat no ka kaliwatan. ");
INSERT INTO msmNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nailing to seini to pagkaotow ni Jesu-Cristo. Si Maria no inoy din asawahon ni Jose. Di no wada pad sikandan kaminyo, namaan on si Maria no nabodos sikandin pinaagi to gahom to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na, si Jose matinumanon yagboy to mgo balaod to Diyus, di kona sikandin ogkaliyag no masikawan si Maria. Kaling mighona-hona sikandin no og-ojowan din si Maria no kona ogkamaanan to duma. ");
INSERT INTO msmNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Anoy man no mighona-hona pad si Jose to sikan, pigpatagainop sikandin to anghil to Ginuu no mig-ikagi, “Jose no kaliwat ni Hari David, kona ka ogduwa-duwa to pag-asawa ki Maria, su sikan pagkabodos din pigbootan to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yukos to ig-anak din, aw Jesus to ihingadan nu kandin su ogyuwason din to kaotawan din to mgo sae dan.” ");
INSERT INTO msmNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nailing to sikan agun matuman to diya impatag-an to Diyus to otow no kibali ba-ba din no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Meyduon daega no wada buling no ogkabodos, aw yukos to ig-anak din. Sikan bata oghingadanan to Emmanuel, no ko ita pa, to Diyus duma ita.” ");
INSERT INTO msmNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pagkabuyat ni Jose, pigtuman din sikan insugu to diya anghil to Ginuu. Pig-asawa din si Maria, ");
INSERT INTO msmNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","di wada din dajun hulidi. Pigtagad din no muanak on. Na, anoy man no i-anak on sikan bata, Jesus to inngadan ni Jose. ");
INSERT INTO msmNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Si Jesus duon i-anak to yunsud to Betlehem no sakup to Judea no iyan mighari si Herodes duon. Na, meyduon maalamon no mgo otow no migtidow duon to siyudad to Jerusalem no ogkaamu ogsabut to kalihokan to mgo bituon. Napuun sikandan diya to madiyu no banwa no diya dapit to silatan. ");
INSERT INTO msmNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nangusip sikandan dow andei to diya ing-anak no ogkahinang no hari to mgo Hibru. Su kagi dan, “Migsilat on to bituon no katagahanan no ing-anak on sikandin, kaling mig-andini koy su ogsimbahon noy.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pagdinog ni Hari Herodes to sikan, hilabi nasamuk to ginhawa din dow to ginhawa to tibo mgo taga-Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kaling dajun din himuna to tibo yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow mgo maistru to tinuuhan aw usipa, “Andei kun man ig-anak to diya Insaad no Manyuyuwas no ogpaharion to Diyus to kaotawan din?” ");
INSERT INTO msmNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Migtabak sikandan, “Diya to yunsud to Betlehem no sakup to seini Judea. Su mey man nayugoy da ipasuyat to Diyus to otow no kibali ba-ba din no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘To mgo kayunsudan duon to Judea, ogyabow to kabantug to Betlehem. Su duon ogkapuun sikan panguyu no ogdumaya to kaotawan ku no mgo kaliwat ni Israel.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pagdinog ni Herodes to sikan, inyunus din dajun impadokat sikan maalamon no mgo otow aw pak usipa dow kagan-u yagboy silat to diya bituon. ");
INSERT INTO msmNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tapus to sikan, pigsugu din sikandan diya to Betlehem. Kagi din, “Deyjawa now pamanghaa sikan no bataa. Na, ko makitaan now on, nangoni a su og-andiya a isab to pagsimba kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Na, migpanow sikandan. No duon on sikandan to pangindaenan, migtukhow sikandan hilabi su pigkita dan on isab sikan bituon no pigkita dan to diya una no pagsilat. Pig-unug dan sikan bituon kotob no migsigkon duon to yongod to bayoy no nabotangan to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dajun sikandan sed. Pagkita dan to sikan bata duma si Maria no inoy din, migyuhud sikandan aw simbaha dan sikan bata. Tapus to sikan, pigbutwa dan to mahalon no mgo daya dan aw ibogoy kandin. Meyduon buyawan dow mangkahomut no og-ilingon to insensu dow mira. ");
INSERT INTO msmNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na, pag-uli dan on, wadad sikandan baja diya ki Herodes su pigbahog sikandan to Diyus pinaagi to tagainop. Diya nasi baja to yain no dayan. ");
INSERT INTO msmNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Anoy man no nalius on to diya mgo taga-silatan, pigpatagainop si Jose to anghil to Ginuu no mig-iling, “Bangun ka. Daeha sikan bata dow inoy din, aw yaguy kow pailing diya to Ehipto. Pakamonang kow duon kotob no nangonan ku sikuna, su sikan bata igpapamangha ni Herodes su ogpahimatajan.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dajun bangun si Jose aw daeha sikan bata dow inoy din aw doyom pailing diya to Ehipto. ");
INSERT INTO msmNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Duon sikandan patilon kotob no namatoy si Herodes. Na, pagkamatoy din on, natuman to diya impasuyat to Diyus to otow no kibali ba-ba din no pig-iling, “To anak ku ogpayuwason ku to Ehipto.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ajaw ka to pagyangoti ni Herodes no mamaanan din on no pigtuntu sikandin to diya mgo taga-silatan! Dajun din isugu no himatajan to tibo mgo bata no yukos kotob to daduwa no tuig to idad duon to Betlehem dow to dani no mgo yunsud. Iyan pig-indanan din to kagi to diya mgo taga-silatan no usipon din dow kagan-u silat to diya bituon. ");
INSERT INTO msmNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Na, natuman to diya sinuyat ni Jeremias no kibali ba-ba to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ogdinogon duon to yunsud to Rama to tiniyahu. Ogdegmatoy si Raquel su patoy on man to mgo anak din. Konad ogkahupoy to kaguul din.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Anoy man no namatoy on si Herodes, si Jose no diya to Ehipto pigpatagainop on isab to anghil to Ginuu ");
INSERT INTO msmNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","no mig-iling, “Bangun ka. Daeha sikan bata dow inoy din aw uli kow on diya to Israel, su patoy on to diya ogpahimatoy to sikan bata.” ");
INSERT INTO msmNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dajun bangun onsi Jose aw uli diya to Israel. ");
INSERT INTO msmNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Di pagkamaan din no si Arquelao no anak ni Herodes iyan on mighari duon to prubinsya to Judea, nahaedok sikandin andiya. Pigpatagainop on isab sikandin dow nokoy to oghinangon din. Kaling diyad nasi sikandan deg to prubinsya to Galilea no sakup isab to Israel, ");
INSERT INTO msmNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","aw duon sikandan ugpa to yunsud to Nazaret. Na, natuman to diya impasuyat to Diyus to otow no kibali ba-ba din no pig-iling, “Ogkatawag sikandin no taga-Nazaret.” ");
INSERT INTO msmNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Anoy man no migyaboy on to mgo katuigan, meyduon magbawtismuhay no iyan ngadan si Juan no migwali diya to matahay no banwa no sakup to prubinsya to Judea. ");
INSERT INTO msmNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mig-iling sikandin, “Sosoy kow aw talikudi now on to mgo sae now su madani on to paghari to Diyus ita.” ");
INSERT INTO msmNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Si Juan to diya intag-an ni Isaias no kibali ba-ba to Diyus no pig-iling, “Meyduon ogbansagon diya to matahay no banwa no og-iling, ‘Hinaata now to dayan to Ginuu! Andama to ginhawa now to pagtidow din!’” ");
INSERT INTO msmNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","To kabo ni Juan hinaboyan no bubue to kamel, aw to bagkos din kindae to mananap. Iyan koonon din to taengas dow doga. ");
INSERT INTO msmNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mahan-in hilabi to mgo otow no naman-andiya kandin no napuun diya to Jerusalem dow duma no mgo kayunsudan no sakup to Judea. Aw to duma duon kapuun to dani to Jordan no wohig. ");
INSERT INTO msmNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pig-angkon dan to mgo sae dan aw pabawtismu ki Juan duon to Jordan. ");
INSERT INTO msmNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Meyduon isab mgo inila to tinuuhan to mgo Hibru no og-ilingon to Pariseo dow Saduseo no mig-andiya kandin su ogpabawtismu. Di pagkita ni Juan kandan, mig-ikagi sikandin, “Sikiyu no angod to hayas no mgo malimbungon, nokoy no mig-andini kow man? Nailing buwa to boot now no ogpakalikoy kow to kaboyu to Diyus ko mabawtismuhan kow. ");
INSERT INTO msmNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Di ko tinood pa no migsosey kow aw pigtalikudan now on to mgo sae now, ogkakitaan podom no madojow on to pamatasan now. ");
INSERT INTO msmNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kona kow ognalig su bantug kaliwat kow ni Abraham no kona kow on ogkastiguhon to Diyus. Su inggad ngani seini mgo batu ogkahinang to Diyus no mgo kaliwat ni Abraham. ");
INSERT INTO msmNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ko madoot to mgo hinang now, ogkaangod kow to kaju no puli nanda oggobaon aw ogsangabon su kona ogbogas to madojow.” ");
INSERT INTO msmNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Dajun din ikagihi sikan tibo mgo otow duon, “Ogbawtismuhan ku sikiyu to wohig pagpakiyaya no migsosey kow on aw pigtalikudan now to mgo sae now. Di meyduon ogpakasunu kanay no ogpamawtismu isab. Yabow pad yagboy kanay su ngani man to pagdaya to sapatus din, di kona a og-angajan. Iyan igbawtismu din to Ispiritu Santu dow kaeju. ");
INSERT INTO msmNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","To pagsapimpin din to mgo otow no mangkadojow dow mangkadoot ogkaangod to otow no og-ohut to trigu. Igbudiga din to trigu, di to ohut ogsangabon din to kaeju no wada pagkaposok.” ");
INSERT INTO msmNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","To diya no panahon, miglikat si Jesus to Galilea aw andiya to Jordan no wohig su ogpabawtismu isab ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Di migbalibad si Juan. Kagi din, “Nokoy no siak man to ogpabawtismuhon nu ikow, no sikuna man podom to angay no ogbawtismu kanay?” ");
INSERT INTO msmNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Di mig-ikagi si Jesus, “Sigi on, su kinahangyan no tumanon ta to tibo insugu to Diyus.” Dajun bawtismuhi ni Juan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Paghaw-as ni Jesus duon to wohig, naabri dajun to yangit. Pigkita din to Ispiritu Santu no angod to salapati no migkonsad aw taphun duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Meyduon isab kagi likat diya to yangit no mig-iling, “Anak ku sikan no pinadajag dow ingkalipay ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dajun paandiyaa si Jesus to Ispiritu Santu to matahay no banwa agun tintalon ni Satanas. ");
INSERT INTO msmNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Kap-atan no aedow dow kap-atan no kadukiloman no wada koon-koon si Jesus. Tapus to sikan, pigbontas sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na, migtidow si Satanas aw tintala din si Jesus. Kagi din, “Oho kun, ko tinood no Anak ka to Diyus, hinanga seini mgo batu no koonon.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Di mig-ikagi si Jesus, “Pig-iling duon to Kasuyatan, ‘Kona no koonon da to ogpakabuhi to otow, di hasta isab to tibo kagi to Diyus.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tapus to sikan, pigdaya si Jesus ni Satanas diya to siyudad to Jerusalem aw patindoga duon to matikang hilabi no bahin to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Kagi din, “Oho kun, ko tinood no Anak ka to Diyus, kawas ka diya to pasak. Su pig-iling duon to Kasuyatan, ‘Ogsuguon to Diyus to mgo anghil din to pagbantoy ikow. Ogtamukon ka dan agun inggad to kobong nu kona ogpakaigu to batu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Di mig-ikagi si Jesus, “Pig-iling isab duon to Kasuyatan, ‘Kona nu ogpangantihan to Ginuu no Diyus nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pigdaya manda si Jesus ni Satanas diya to matikang hilabi no bubungan aw ihindu kandin to tibo banwa kani to babow to kalibutan hasta to mgo kadojawan duon. ");
INSERT INTO msmNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kagi ni Satanas, “Aha ka to suja. Igbogoy ku ikow tibo sikan ko muyuhud ka aw simba kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kagi ni Jesus, “Yaguy ka Satanas! Su pig-iling duon to Kasuyatan, ‘Iyan da simbaha to Ginuu no Diyus nu. Sikandin da to tumana.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Dajun ojowi sikandin ni Satanas aw atimana to mgo anghil no naman-anduon kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na, impadakop ni Herodes si Juan aw prisuha. Pagkamaan ni Jesus to sikan, mig-uli sikandin diya to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wadad on sikandin ugpa duon to yunsud to Nazaret su migbalhin on duon to Capernaum no nakapahigad to danow duon to banwa to Zabulon dow Neftali. ");
INSERT INTO msmNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Duon to sikan, natuman to diya intag-an ni Isaias no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Iyan ognangonon din sikan banwa to Zabulon dow Neftali no nakabotang duon to bajaanan pailing diya to dagat, dow diya to dihipag to Jordan no wohig. Iyan isab ognangonon din to kona no mgo Hibru no mig-ugpa duon to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mig-iling sikandin, “Nadigyoman to hona-hona to sikan no mgo otow aw naangod to patoy su wada sikandan kiyaya to Diyus. Di diya to umaabut no panahon, ogkita sikandan to masiga yagboy no kaawang, su meyduon ogtidow no ogtang-ow kandan.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na, sugud to diya no panahon, migwali si Jesus no mig-iling, “Sosey kow aw talikudi now on to mgo sae now su madani on to paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Songo aedow, migyadgad si Jesus duon to higad to danow to Galilea. Duon din katae-i to daduwa no migsusuun no mgo mangisdaay no namukut. Iyan ngadan dan si Simon no pighingadanan isab ki Pedro dow si Andres. ");
INSERT INTO msmNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kagi ni Jesus kandan, “Duma kow on kanay su oghinangon ku sikiyu no mgo inanad. Su kotob kuntoon, isda to nasakup to pukut now. Di sugud kuntoon, otow on to igpasakup ku iyu agun mahinang no mgo sakup ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Duon-dajun pig-ojowan dan to mgo pukut dan aw duma on ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Anoy man no diyad on si Jesus to uunahan, natae-an din to yain no migsusuun no migtapid to mgo pukut dan duon to bangka duma to amoy dan no si Sebedeo. Iyan ngadan dan si Santiago dow si Juan. Pigsabi sikandan ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Duon-dajun piglikatan dan sikan bangka dow amoy dan aw duma isab ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pigyogob-yogob ni Jesus to mgo kayunsudan duon to Galilea. Nang-anad sikandin duon to mgo simbahan to mgo Hibru, aw iwali din sikan Madojow no Nawnangonon bahin to paghari to Diyus. Nangkaulian din isab to mgo otow no migbati to yain-yain no mgo sakit. ");
INSERT INTO msmNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nabantug si Jesus duon to tibuuk prubinsya to Siria, kaling pigdaya duon kandin to tibo no migbati to yain-yain no mgo sakit yakip to mgo pukajon, to nangkaparalays dow to pigpangsamuk to mangkadoot no ispiritu. Tibo sikandan pigpang-ulian ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Mahan-in yagboy to mgo otow no migduma kandin. Duon sikandan kapuun to mgo yunsud no sakup to Galilea dow Judea yakip to siyudad to Jerusalem. Mahan-in isab to nangkapuun diya to dihipag to Jordan yakip sikan banwa no og-ilingon to Decapolis. ");
INSERT INTO msmNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pagkita ni Jesus to sikan mahan-in no mgo otow, miggamat sikandin to bubungan aw ingkud duon. To mgo inanad din migduguk, ");
INSERT INTO msmNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","aw pigpang-anad din sikandan. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Madojow to diya og-angkon no wada ogkahimu dan ko kona sikandan tabangan to Diyus, su ogkasakup sikandan duon to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Madojow to diya ogsakit hilabi to ginhawa, su oghupajon sikandan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Madojow to diya ogpaobos, su ogkaangkon dan seini kalibutan diya to umaabut no panahon. ");
INSERT INTO msmNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Madojow to diya og-awos yagboy ogtuman to pagboot to Diyus, su ogkatuman sikan og-awoson dan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Madojow to diya ogkae-at to duma, su ogkae-atan sikandan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Madojow to diya ogtibuyus to ginhawa dan duon to Diyus, su ogkitaon dan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Madojow to diya ogpaningkamot agun ogdojow to rilasyun to mgo otow, su ogkatawag sikandan no mgo anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Madojow to diya ogpaantuson tongod to pagtuman dan to Diyus, su ogkasakup sikandan duon to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Madojow kow ko doot-dooton kow aw paantuson aw hapoyan tongod kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tukhow kow yagboy ko mahitabu sikan, su maaslag to igbayos iyu diya to yangit. Su angod isab to sikan to pagpaantusa to mgo otow no kibali ba-ba to Diyus to diya una. ");
INSERT INTO msmNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Sikiyu no mgo sakup ku,” kagi ni Jesus, “angod kow to asin no igkadojow to tibo kaotawan. Di ko pananglitan mutab-as on to asin, og-amonuhon to pagpabalik to lami? Igtimbag on puli aw oggiok-giokan to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Angod kow isab to lamparahan su ogkatang-awan now to tibo kaotawan. Na, ko meyduon yunsud duon to bubungan, kona igkahobong sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wada isab otow no ogpadokot to soga no ogtakyuban to gantangan sikan ogsogaan din. Nasi no igbotang din duon to untudanan agun tibo ogkatang-awan duon to sed to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Angod isab to sikan, pasigaha to lamparahan now, no ko ita pa, ipakita to madojow no pamatasan now agun masaja to Diyus no Amoy now diya to yangit ko maaha kow to duma. ");
INSERT INTO msmNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Kona kow oghona-hona no iyan ing-andini ku to kalibutan su oggawangon ku to diya mgo balaod no impabaja to Diyus ki Moises dow to sinuyat to diya kibali mgo ba-ba din. Di iyan nasi ing-andini ku su ogtumanon ku sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Indani now seini. Kotob no kona pad magawang to yangit dow pasak, wada ogkagawang duon to sikan mgo balaod to Diyus, inggad songo litra da ubin songo kudlit. Su ogkatuman sikan tibo. ");
INSERT INTO msmNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kaling to otow no ogyapas to inggad maintok da to sikan mgo sugu aw i-anad din no kona ogtumanon, ogkatawag sikandin to pinakaobos duon to sikan ogharian to Diyus. Di to otow no ogtuman to sikan mgo sugu aw i-anad diya to duma, ogkatawag sikandin no yabow duon to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ligdongi now seini. To pagtuman now to Diyus kinahangyan no ogyabow pad duon to pagtuman kandin to mgo maistru to tinuuhan dow mgo Pariseo. Su ko kona, kona kow yagboy ogkasakup duon to sikan ogharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Migpadajun si Jesus to pag-ikagi, “Pigdinog now on to ing-anad to diya una no pig-iling, ‘Kona kow oghimatoy. Inggad hintawa no oghimatoy to otow, angay sikandin no ogkastiguhon.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Di seini to ig-anad ku kuntoon. Inggad puli ogkaboyu to otow to duma, angay on sikandin ogkastiguhon. Aw to otow no ogpamuang-buang to duma ogkadaya on diya to yabow no husajan. To otow isab no ogtamay to duma pinaagi to pag-iling, ‘Wada pues nu,’ igkaimpernu din on sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Kaling inggad diya kad on to haladanan su meyduon ighalad nu to Diyus, ko madomdoman nu no nakasae ka to duma, ");
INSERT INTO msmNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ojowi naa sikan. Unaha andiyaa sikan otow no nasae-an nu, aw pag-uli ka ayha ka halad diya to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ko iriklamu ka to songo otow, kona kow pad ogtidow diya to husajan, pag-uli kad kandin. Su ko duon kow on to husajan, unu ko paatubangon ka to huwis aw idata ka diya to pulis agun ipaprisu. ");
INSERT INTO msmNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na, kona ka yagboy ogpakayuwas duon kotob no mabajadan nu to tibo ogpabajadan ikow. ");
INSERT INTO msmNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Pigdinog now on to ing-anad to diya una no pig-iling, ‘Kona kow ogpanghonay.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Di seini to ig-anad ku kuntoon. Inggad puli da yongyongan dow ongod-ongodon to yukos to bohi, kibali nahilabotan din on. ");
INSERT INTO msmNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kaling ko sikan mata nu iyan ogpakaamung to pagpakasae nu, yugita aw itimbag. Inggad sobuuk nanda to mata nu basta kona isugba diya to impernu to tibuuk yawa nu. ");
INSERT INTO msmNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ko sikan boyad nu ogdae isab ikow to pagpakasae, tampoda sikan aw itimbag. Tapat pad ko pupue ka, basta kona isugba diya to impernu to tibuuk yawa nu. ");
INSERT INTO msmNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Pigdinog now on to ing-anad to diya una no pig-iling, ‘Ko meyduon otow no ogpagbiya to asawa, bogajan din to kalig-onan to pagbiya.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Di seini to ig-anad ku kuntoon. Madoot ko ojowan to otow to asawa din no wada panghonay, su ko mubabana sikan asawa to yain, kibali nakapanghonay. To otow isab no og-asawa to bohi no inojowan to bana, kibali nakapanghonay.” ");
INSERT INTO msmNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Kagi ni Jesus, “Pigdinog now on isab to ing-anad to diya una no pig-iling, ‘Ko meyduon igsaad now, kona ogkahimu no kona now tumanon. Tumana yagboy sikan insaad now to Ginuu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Di seini to ig-anad ku kuntoon. Ko meyduon og-ikagihon now, kona kow ogpanapa. Ajaw igpanapa to yangit, su ingkudanan sikan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ajaw isab igpanapa to pasak, su untudanan sikan to kobong din. Ajaw igpanapa to Jerusalem, su siyudad sikan to Diyus no Yabow no Hari. ");
INSERT INTO msmNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ajaw isab igpanapa to uyu now, su kona now ogkabootan to bubue now ko muputi ubin muitom, inggad songo soyag da. ");
INSERT INTO msmNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Igu on ko muiling kow to ‘hoo’ ko ujun kow, di ko kona, na, ilinga puli to ‘kona.’ Madoot ko tawajan now sikan to sapa, su ogkapuun on sikan ki Satanas. ");
INSERT INTO msmNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Pigdinog now on to ing-anad to diya una no pig-iling, ‘To otow no ogpakabuta to yain no otow, ogbutahon isab. Aw to otow no ogpakatipu to ngipon to yain no otow, ogtipuan isab.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Di seini to ig-anad ku kuntoon. Kona kow ogbayos to otow no ogdoot iyu. Ko pananglitan meyduon ogsampalu to kalintuu no pisngi nu, ipasampalu isab to kawae. ");
INSERT INTO msmNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ko iriklamu ka aw iyan igpabajad to kabo nu, ibogoy sikan yakip to mahalon no ilisan nu. ");
INSERT INTO msmNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ko meyduon ogpogos ikow to pagdae to tagudaya din to songo kilumitru, daduwaha no kilumitru to igdae nu to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","To ogpamuju bogaji, aw to ogbes pabesa. ");
INSERT INTO msmNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Pigdinog now on to ing-anad to diya una no pig-iling, ‘Higugmaa to mgo kadumahan now aw domoti to mgo kuntra now.’ ");
INSERT INTO msmNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Di seini to ig-anad ku kuntoon. Higugmaa to mgo kuntra now. Pangamuju kow to Diyus no kae-atan din to diya ogpaantus iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Na, ko tumanon now sikan, ogkakiyaya no anak kow to Diyus no Amoy now diya to yangit. Su ogpasogahan din to uma to tibo mgo otow, matarong ko kona. Ogpaudanan din isab to uma to tibo mgo otow, madoot ko madojow. ");
INSERT INTO msmNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Na sikiyu, ko iyan da higugmaon now to mighigugma iyu, nokoy pad man to ogkaiman now to Diyus? Su ngani man sikan matuntuhon no mgo magsukutay to buhis, di oghigugma to diya oghigugma kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ko iyan da liparahon now to mgo kadumahan now, nokoy pad man to igkasaja iyu? Su ngani man sikan mgo otow no wada Diyus, di oglipara to mgo kadumahan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kaling paningkamoti now to pagsunud to batasan to Diyus no Amoy now no diya to yangit no wada yagboy sae.” ");
INSERT INTO msmNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Migpadajun si Jesus to pag-ikagi, “Aha kow no kona kow ogpakita-kita ko ogtuman kow to Diyus. Su ko ilingon now to sikan, kona kow ogbayosan to Diyus no Amoy now diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Kaling ko ogtabang kow to mgo pubri, kona kow ogpagsunud to diya mgo otow no kunungkun diyusnon. Igpakita dan ko ogbogoy diya to simbahan aw duon to mgo karsada agun sajaon sikandan to mgo otow. Di seini da. Manno nadawat dan on to pagsaja to mgo otow, wadad bayos no ogkadawat dan no ogkapuun to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Di sikiyu, ko ogtabang kow to mgo pubri, kona now igmaan inggad to yagboy now no amigu ");
INSERT INTO msmNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","agun no kona matagahan no migbogoy kow. Su inggad wada otow no ogkita iyu, to Amoy now no Diyus ogkita, aw sikandin to ogbayos iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ko og-ampu kow,” kagi ni Jesus, “kona kow ogpagsunud to diya mgo otow no kunungkun diyusnon. Ogtindog sikandan no og-ampu duon to simbahan aw duon to mgo karsada agun kitaon sikandan to mgo otow. Di indani seini. Manno nadawat dan on to pagsaja to mgo otow, wadad bayos no ogkadawat dan no ogkapuun to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Di sikiyu, ko og-ampu kow, sed kow to sinabong aw sirahi, na, ampu kow diya to Diyus no Amoy now no kona ogkitaon. Su inggad wada otow no ogkita iyu, to Amoy now ogkita, aw sikandin to ogbayos iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ko og-ampu kow, kona kow ogpagsunud to mgo otow no wada Diyus. Ogkailing to boot dan no ogdinogon sikandan ko habaon dan to pag-ampu, kaling ogbalik-balikon dan to mgo kagi no wada pues. ");
INSERT INTO msmNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kona kow ogpagsunud to sikan, su to Diyus no Amoy now tahan on namaan to pigkinahangyan now, inggad wada kow pad hangyu kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ilinga now nasi to seini ko og-ampu kow: Amoy noy no diya to yangit, tahudon ka podom yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Muhari ka podom to tibo kaotawan, aw matuman to pagboot nu kani to babow to pasak angod to pagkatuman to pagboot nu diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bogaji koy to pagkoon noy kuntoon no aedow. ");
INSERT INTO msmNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pasayluha koy to mgo sae noy, su pigpasaylu noy on to namakasae kanami. ");
INSERT INTO msmNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tabangi koy agun kona koy matintal, aw saganga kanami to gahom ni Satanas. ");
INSERT INTO msmNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na,” kagi ni Jesus, “ko ogpasaylu kow to otow no nakasae iyu, ogpasayluhon kow isab to Diyus no Amoy now diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Di ko kona kow ogpasaylu to duma, kona kow isab ogpasayluhon to Diyus no Amoy now diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ko ogpuasa kow, kona kow ogpagsunud to diya mgo otow no kunungkun diyusnon. Ogpaguul-guul sikandan, kona ogpangiyam-us, kona isab ogpanudlay agun matagahan to mgo otow no migpuasa sikandan. Di indani seini. Manno nadawat dan on to pagsaja to mgo otow, wadad bayos no ogkadawat dan no ogkapuun to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Di sikiyu, ko ogpuasa kow, pangiyam-us kow aw panudlay ");
INSERT INTO msmNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","agun wada ogkamaan no migpuasa kow. Na, inggad kona mataga to duma, nataga to Amoy now no Diyus, aw sikandin to ogbayos iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Kona kow oghimun to mgo katigajunan kani to babow to kalibutan, su ginona ogkotkoton aw ogkaelingan dow ogkakawat. ");
INSERT INTO msmNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nasi no tumana yagboy to Diyus agun ko makaandiya kow to yangit, meyduon ogkapaabut now no bayos. Sikan no kadatu now diya to yangit kona ogkakotkot, kona ogkaelingan, kona isab ogkakawat. ");
INSERT INTO msmNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Na, inggad andei igbotang to kadatu now, dini to pasak ko diya to yangit, duon isab to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ko kona no katigajunan to og-awoson now, maagkap to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Di ko hakog kow aw iyan og-awoson now to mgo katigajunan, na, mabog-at to ginhawa now. Kaling kona now ogpayabihon to mgo katigajunan dini to pasak, su ko sikan to payabihon now, kadootan now yagboy sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wada otow no ogpakatuman to daduwa no ka agayon. Su ogkahitabu no sobuuk to ogpayabihon din, aw ogtamajon din sikan ikaduwa. Angod isab to sikan, ko iyan pinakaagayon now to saepi, to Diyus kona now ogkaagayon. Su kona now ogkadongan to pagtuman to Diyus dow saepi. ");
INSERT INTO msmNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Kaling,” kagi ni Jesus, “paminogi now seini. Kona kow ogkalimuut to ogkakoon dow ogkainom hasta to ogkakabo now no ogkinahangyanon to seini kinabuhi. Su to kinabuhi now yabow pad duon to pagkoon, aw to yawa now yabow pad to kabo. ");
INSERT INTO msmNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ahaa now suja migyajang-yajang no mgo manuk-manuk. Kona sikandan og-odok aw kona isab og-ani. Kona sikandan ogbudiga to ogkakoon dan, di to Diyus no Amoy now diya to yangit iyan ogtubung kandan. Na, sikiyu pad man to kona din atimanon no yabow pad to mgo manuk-manuk! ");
INSERT INTO msmNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hintawa man iyu to ogpakasugpat to kinabuhi din inggad majopot da pinaagi to pagkalimuut? ");
INSERT INTO msmNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Aw nokoy no ogkalimuut kow man to ogkaboon now? Ahaa now suja mgo buyak no puli oggiti. Kona sikan ogkaunag to pagtrabahu, kona isab oghabey to mgo panapton. ");
INSERT INTO msmNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Di seini da. Inggad si Hari Salomon to diya una no yagboy sapian, wada kabo din no ogpakaangod to kadojow to suja mgo buyak. ");
INSERT INTO msmNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Na, ko maangod to sikan to pagpabuyak to Diyus to mgo bagnot no madali da ogyanos aw ogkatutung, sikiyu pad man to kona din kaboan no yabow pad to mgo bagnot! Pagkaintok to pagsalig now to Diyus! ");
INSERT INTO msmNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kaling kona kow ogkalimuut. Kona kow og-iling, ‘Nokoy man buwa to ogkakoon dow ogkainom hasta ogkakabo ta?’ ");
INSERT INTO msmNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Su iyan da ogkalimuut to sikan to diya mgo otow no wada Diyus. Di sikiyu, kona kow ogkalimuut, su to Diyus no Amoy now diya to yangit namaan to pigkinahangyan now. ");
INSERT INTO msmNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Di unaha pahari-a to Diyus to kinabuhi now aw kinabuhi-a to matarong no iyan ogkaliyagan din, na, igbogoy din iyu to tibo no ogkinahangyanon now. ");
INSERT INTO msmNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kaling kona kow ogkalimuut to mangkalisod no og-abut iyu kasem. Hona-honaon now da sikan ko muabut on. Ajaw ogdugangi to mgo prublima now kuntoon.” ");
INSERT INTO msmNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Migpadajun si Jesus to pagpang-anad. Kagi din, “Kona kow on ogpanghukum to duma su unu ko sikiyu nasi to hukuman to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aw to kabog-at no ighukum now to duma angod isab to kabog-at to ighukum iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Nokoy no oghukum ka man to otow no mae-puling da to sae no sikuna man to mae-trusu to sae no nakabaebag duon to mata nu? Nokoy no kona man no sikan to ogliparahon nu? ");
INSERT INTO msmNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Og-amonuhon nu man to pag-ikagi no ogkuhigon nu sikan maintok no puling to duma, no mae-trusu man to ikow no puling? ");
INSERT INTO msmNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Kunungkun mangkatarong! Gawanga naa sikan mae-trusu no puling nu agun mapajag to pag-aha nu ayha kuhiga sikan maintok no puling to duma.” ");
INSERT INTO msmNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dajun ipananglit ni Jesus to mgo otow no kona ogkaliyag ogpaminog to kagi to Diyus. Kagi din, “Ajaw igbogoy to kaning Diyus diya to idu, su ginona kow ogkagaton. Kona now isab igtimbag to mgo perlas duon to babuy, su ginona ogkagiok-giokan. ");
INSERT INTO msmNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pamuju kow to Diyus,” kagi ni Jesus, “su ogbogajan kow. Pamangha kow su ogpakakita kow. Panuktuk kow su og-abrihan kow. ");
INSERT INTO msmNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Su inggad hintawa no ogpamuju ogpakadawat, to ogpamangha ogpakakita, aw to ogpanuktuk og-abrihan. ");
INSERT INTO msmNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sikiyu no mgo ginikanan, ko mamuju to anak now to pan, kona no iyan igbogoy now to batu. ");
INSERT INTO msmNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aw ko mamuju to anak now to isda, kona no iyan igbogoy now to hayas. ");
INSERT INTO msmNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ogbogoy kow to kadojawan diya to mgo anak now inggad man-u to kadoot now. Iyan on man kona mubogoy to kadojawan to Amoy now no diya to yangit to tibo no ogpamuju kandin! ");
INSERT INTO msmNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Hinanga diya to duma to ogkaliyagan now no iyan oghinangon dan duon iyu. Seini to igpasabut to tibo mgo balaod no impabaja to Diyus ki Moises dow to sinuyat to diya kibali mgo ba-ba din. ");
INSERT INTO msmNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mayow-ag sikan yawanganan pailing diya to impernu, aw mahaewoy ogbajaan sikan no dayan, kaling mahan-in to ogbaja duon. Di sikiyu, duon kow nasi mubaja to sikan malig-ot no yawanganan. ");
INSERT INTO msmNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pipilahon da to ogpakabatuk to dayan duon no ogpadeg diya to kinabuhi no wada katapusan, su malig-ot sikan yawanganan aw to dayan malisod ogbajaan. ");
INSERT INTO msmNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Bantoy kow su unu ko madaya kow to mgo otow no kunungkun kibali ba-ba sikandan to Diyus. Ogpamadojow-dojow sikandan, di to matuud, madoot to tuud dan iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Di ogkakiyayahan now sikandan tongod to mgo hinang dan, angod to kaju no ogkiyayahon tongod to bogas. Pananglit, to sampinit kona ogbogas to matam-is. ");
INSERT INTO msmNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","To mgo kaju isab no wada sakit, madojow to bogas. Aw to kaju no mey sakit, madoot to bogas. ");
INSERT INTO msmNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","To madojow no kaju kona ogpakabogas to madoot, aw to madoot no kaju kona ogpakabogas to madojow. ");
INSERT INTO msmNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na, inggad nokoy no kaju no kona ogbogas to madojow oggobaon aw ogsangabon. ");
INSERT INTO msmNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kaling ko mapaniidan now to mgo hinang to sikan no mgo otawa no ognangonon ku, ogkiyayahan now no kona sikandan no tinood no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Meyduon mgo otow no og-angkon no Magboboot a dan, di kona sikandan tibo ogkasakup duon to gingharian to Diyus. Su iyan da ogkasakup to diya ogtuman to pagboot to Amoy ku diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ko muabut on to Aedow to Paghukum, mahan-in to ogpakawkae-at kanay no og-iling, ‘Aduy, Magboboot noy, sadangay paseda koy su mignawnangon koy man to kagi to Diyus isip mgo sinugu nu. Ngadan nu to impang-abug noy to mangkadoot no ispiritu, aw piggamit noy isab no manghinang koy to mahan-in no mgo milagru.’ ");
INSERT INTO msmNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Di og-ikagihan ku sikandan, ‘Eh, wada yabot ku iyu. Hala, yaguy kow kani, sikiyu no madoot to mgo hinang.’” ");
INSERT INTO msmNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kagi ni Jesus, “To otow no ogdinog to kagi ku aw ogtuman, ogkaangod sikandin to maalamon no otow no mighinang to bayoy no intugdok duon to batu. ");
INSERT INTO msmNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na, pag-udan dow paggoob aw paghaposa to sikan bayoy to maagbot no kaemag, wada kaamonu su madigon yagboy to pagkatugdok. ");
INSERT INTO msmNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Di to otow no ogdinog to kagi ku aw kona ogtuman, ogkaangod sikandin to omaw no mighinang to bayoy duon to danggoy. ");
INSERT INTO msmNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na, pag-udan dow paggoob aw paghaposa to maagbot no kaemag sikan no bayoy, ato! Nawasa yagboy!” ");
INSERT INTO msmNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pagkatapus to pagpang-anad ni Jesus, hilabi natingaya to tibo mgo otow no naminog kandin, ");
INSERT INTO msmNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","su to pagpang-anad din kona no angod to pagpang-anad to mgo maistru to tinuuhan, su sikan ki Jesus migdae to katongod. ");
INSERT INTO msmNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pagtogbang ni Jesus to sikan bubungan, mahan-in to mgo otow no migduma kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na, meyduon otow no pigsangla no migduguk ki Jesus aw yuhud duon to atubangan din aw ikagi, “Sir, ko pagboot nu, ogkaulian a.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dajun dampaa ni Jesus sikan otow. Kagi din, “Ogbootan ku no maulian ka.” Duon-dajun naulian sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kagi ni Jesus, “Wada ognangonan nu no inggad hintawa to seini. Nasi no andiya ka to magdudumaya to tinuuhan ta aw paaha ka. Pagkatapus, bogoy ka to halad no insugu ni Moises to diya una agun mamatuud no naulian kad.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Dajun andiya si Jesus to yunsud to Capernaum. Pagtidow din, meyduon kapitan to sundayu no taga-Roma no migpakimayuuy kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Sir,” kagi din, “meyduon suguonon ku diya to bayoy no maagbot yagboy to ogbation. Konad sikandin ogpakahisu.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Kagi ni Jesus, “Na, og-andiya ki su ogpadojawon ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Di mig-ikagi sikan kapitan, “Eh, kona ka Sir, su kona a og-angajan no ogpaponhik ikow diya to bayoy ku. Inggad puli nu ikagihon no maulian sikan suguonon ku, ogkatuman sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Su naanad ad to sugu, su inggad siak meyduon yabow ku. Meyduon isab obos ku no mgo sundayu. Ogpakasugu a man ngani to sundayu ku to, ‘Andiya ka.’ Na, ogtuman sikandin. Ko paandinihon ku kanay to duma, og-andini. To suguonon ku isab ogtuman dajun ko ogsuguon ku. Na, ogtumanon man ngani to inggad nokoy no igsugu ku, sikunad man to kona tumanon ko musugu ka!” ");
INSERT INTO msmNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Pagdinog ni Jesus to kagi to sikan kapitan, natingaya yagboy sikandin. Kaling pig-ikagihan din to mgo otow no migduma kandin, “Disti on ko migkita a to pagtuu no angod to kadigon to seini, inggad pad kani to mgo kaliwat ni Israel! ");
INSERT INTO msmNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Indani seini. Diya to umaabut no panahon, mahan-in to mgo otow no ogpagsayu to sikan mgo minuna ta no si Abraham, si Isaac dow si Jacob to pagkoon diya to gingharian to Diyus. Ogkapuun sikandan diya to yain-yain no mgo tribu kani to babow to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Di mahan-in kow no mgo Hibru no iyan podom igyakip duon no nasi igtimbag duon to kadigyoman diya to yuwas su wada kow tuu kanay. Ogpakadegmatoy to mgo otow duon.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dajun ikagihi ni Jesus sikan kapitan, “Na, uli kad. Natuman on sikan hangyu nu tongod to pagtuu nu kanay.” Sikan yagboy no uras naulian sikan suguonon. ");
INSERT INTO msmNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pag-andiya ni Jesus to bayoy ni Pedro, pigkita din to ugangan ni Pedro no mighibat su pighingyow. ");
INSERT INTO msmNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Puli din da pigdampa to boyad to sikan bujag, dajun naulian. Na, migbangun sikandin aw honati din si Jesus to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na, anoy man no migsayop on to soga, pigpandaya duon ki Jesus to mahan-in no mgo otow no pigsamuk to mangkadoot no ispiritu. Pigpang-abug din sikan to sugu din da puli. Pigpangdojow din isab to tibo masakiton duon. ");
INSERT INTO msmNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Sikan pighinang din iyan katumanan to diya intag-an ni Isaias no kibali ba-ba to Diyus no pig-iling, “Ogpanggawangon din to mgo sakit ta.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Na, songo aedow, pagkita ni Jesus to mahan-in no mgo otow no miglibong kandin, pig-ikagihan din to mgo inanad din, “Ogyopa kinow to seini danow.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Na, meyduon maistru to tinuuhan no migduguk ki Jesus. “Sir,” kagi din pa, “ogduma a ikow inggad andei ka mudeg.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Di mig-ikagi si Jesus, “Madojow pad to milo su meyduon ogkaugpaan. Madojow pad isab to manuk-manuk su meyduon oghapunan. Di ogkalisodan ka ko muduma-duma ka kanay no Anak to Otow, su wada makopot no kaugpa ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sobuuk isab to sikan namanduma ki Jesus mig-ikagi, “Sir, og-uli a pad su igyobong ku to amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Di mig-ikagi si Jesus, “Duma ka kanay kuntoon. Pabay-ani sikan patoy no igyobong to duma no angod isab to mgo patoy.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Dajun sakoy si Jesus dow mgo inanad din to bangka aw tukud sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wada kayugoy, puli nakatokow mighodos to maagbot hilabi no kaemag, aw madani on ogkaponu sikan bangka to limason tongod to maagbot no bayod. Di si Jesus nalipodong. ");
INSERT INTO msmNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dajun sikandin pukawa to mgo inanad din aw ikagihi, “Ginuu, tabang ka man! Ogyogdang kid kay!” ");
INSERT INTO msmNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kagi ni Jesus, “Nokoy no ogkahaedok kow man? Andeid man to pagsalig now?” Dajun sikandin bangun aw sapadi to kaemag dow mgo bayod. Na, mig-ondang dajun. ");
INSERT INTO msmNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Natingaya yagboy sikan mgo duma ni Jesus. “Nokoy man buwa otawa seini,” kagi dan, “no inggad kaemag dow bayod ogpasapad kandin?” ");
INSERT INTO msmNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pagtidow onni Jesus diya to dihipag, migduung sikandan duon to banwa no sakup to yunsud to Gadara. Duon tagbuha si Jesus to daduwa no ka otow no napuun diya to siminteryu. Kahaedokanan yagboy sikandan su pigpadamaan to mangkadoot no ispiritu, kaling wada mabuyut no otow no ogbaja to sikan no dayan. ");
INSERT INTO msmNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pigbansagonan dan si Jesus, “Sikuna no Anak to Diyus, nokoy man to yabot nu kanami? Nokoy man, ogkastiguhon koy nud no kona pad man podom no panahon?” ");
INSERT INTO msmNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Na, kona da no madiyu duon, meyduon mahan-in no mgo babuy no nandungae. ");
INSERT INTO msmNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Sikan mangkadoot no ispiritu nangamuju ki Jesus, “Ko abugon koy nu, paseda koy dutun to suja mgo babuy.” ");
INSERT INTO msmNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Na hala,” kagi ni Jesus. “Sed kow dutun.” Na, nokoy ka man no pigyagujan dan sikan mgo otow aw sed duon to mgo babuy. Dajun pamanlinaguy sikan tibo mgo babuy no namanyus-ug duon to pangpang aw kangkatabug diya to wohig. ");
INSERT INTO msmNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dajun namanlinaguy sikan namanbantoy to babuy pailing diya to yunsud. Ingnangon dan to tibo nahitabu dow to nadeygan to sikan daduwa no ka otow no pigpadamaan. ");
INSERT INTO msmNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Dajun anduona si Jesus to tibo mgo taga-yunsud aw hangyu-a no yagujan din sikan banwa dan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Migyopa on isab si Jesus to sikan danow aw uli diya to yunsud din. ");
INSERT INTO msmNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na, meyduon migtidow no mgo otow no migyayahung to duma dan no naparalays. Pagkita ni Jesus no migtuu yagboy sikandan no ogkaulian din sikan masakiton, pig-ikagihan din sikan otow no naparalays, “Yagi, digona to ginhawa nu su pigpasaylu on to mgo sae nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na, meyduon isab mgo maistru to tinuuhan duon. Ginhawa dan, “Eh, seini no otawa ogpasipaya to Diyus su og-angkon no ogpakapasaylu sikandin to sae.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Di namaanan ni Jesus to hona-hona dan, kaling mig-ikagi sikandin, “Kadoot on man to hona-hona now! ");
INSERT INTO msmNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Andei man to mahaewoy, ko muiling a, ‘Pigpasaylu on to mgo sae nu,’ ubin ko muiling a, ‘Tindog ka aw panow’? ");
INSERT INTO msmNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, igpakita ku iyu no siak no Anak to Otow meyduon katongod kani to babow to kalibutan to pagpasaylu to sae.” Dajun din ikagihi sikan naparalays, “Tindog ka! Daeha sikan pighibatan nu aw uli kad on.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dajun bangun sikan otow aw uli. ");
INSERT INTO msmNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pagkita to mgo otow to sikan, sakot to kahaedok dow katingaya, pigsaja dan to Diyus, su pigbogajan din to otow to katongod no angod to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pagpadajun ni Jesus to pagpanow, nabajaan din to otow no iyan ngadan si Mateo. Mig-ingkud sikandin duon to sukutanan to buhis su magsukutay man sikandin. Kagi ni Jesus, “Yagi, duma kad kanay su oghinangon ku sikuna no inanad.” Dajun tindog si Mateo aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na, pigpakoon si Jesus dow mgo inanad din duon to bayoy ni Mateo. Mahan-in to migpagsayu kandan no magsukutay to buhis dow duma no mgo otow no og-ilingon to makasasaya. ");
INSERT INTO msmNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pagkita to mgo Pariseo to sikan, pig-usip dan to mgo inanad ni Jesus, “Nokoy no ogpagsayu man sikan maistru now to sikan matuntuhon no mgo magsukutay to buhis dow duma no mgo makasasaya?” ");
INSERT INTO msmNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pagdinog ni Jesus to kagi dan, sikandin to migtabak no impabaja to pananglitan. Kagi din, “To otow no wada sakit kona ogkinahangyan to duktur. Masakiton da to ogkinahangyan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Na, pangintaga kow dow nokoy to igpasabut to sikan kagi to Diyus no pig-iling, ‘Kona no iyan og-awoson ku to mgo mananap no ogtutungon no ighalad now kanay. Iyan nasi og-awoson ku no mukae-at kow to duma.’ Kona no iyan ing-andini ku to pagkabig to mgo otow no oghona-hona no matarong sikandan. Di iyan pig-andini ku to mgo makasasaya.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Na, to mgo inanad ni Juan no Magbawtismuhay mig-andiya ki Jesus. Kagi dan, “Sikami dow to mgo Pariseo ogtuman to pagpuasa, di to mgo inanad nu kona man ogtuman to sikan. Nokoy man?” ");
INSERT INTO msmNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Migtabak si Jesus, “Ko pananglitan meyduon kumbiti, nokoy man, ogkaguul buwa to kadumahan to sikan bag-u kaminyo no yukos ko duma dan pad sikandin? Kona gajod! Di mey panahon no ogpuduton sikandin duon kandan, aw iyan pad pagpuasa to sikan piglikatan.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Impananglit isab ni Jesus to wada pagkahiujun to bag-u no impang-anad din dow to tahan no impang-anad to mgo Hibru. Kagi din, “Wada otow no ogtapak to bag-u no panapton duon to tahan no kabo. Su ko labahan sikan, ogkoyo sikan bag-u no panapton, aw ogyow-ag sikan higbit. ");
INSERT INTO msmNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Angod isab to inomon no ogsobu pad no igtagu duon to sedanan no kindae. Wada otow no ogtagu to seini duon to tahan no sedanan, su maliskog on aw madali ogbotu. Ginona ogkauyakan sikan inomon dow sedanan. Nasi no igtagu to bag-u no inomon duon to bag-u no sedanan su mayunoy pad agun wada ogkauyakan.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Dugaja pad mig-ikagi si Jesus, meyduon migtidow no panguyu to simbahan to mgo Hibru. Migyuhud sikandin duon to atubangan ni Jesus aw ikagi, “Adoy Sir, bag-u pad kabigtawi to anak ku no bohi. Sadangay dali ka aw dampaa sikandin agun mabuhi.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Dajun tindog si Jesus aw duma kandin. Migduma isab to mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na, duon to pangindaenan, meyduon bohi no migyayangosa sed on to sampuyu-tag-duwa no tuig. Migpadani sikandin duon to talikudan ni Jesus aw tudi-a sikan migjawing-jawing duon to sidsid to kabo din ");
INSERT INTO msmNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","su ginhawa din, “Inggad puli a da makatudi to kabo ni Jesus, ogkaulian a.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dajun patibilik si Jesus aw kitaa din sikan bohi. “Iya,” kagi din, “digona to ginhawa nu. To pagsalig nu kanay iyan nakadojow ikow.” Duon-dajun naulian sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na, pagtidow ni Jesus duon to bayoy to diya panguyu to simbahan, pigkita din to mgo otow no namendag dow to kahan-inan no namandegmatoy. ");
INSERT INTO msmNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Dajun sugu si Jesus, “Yaguy kow su wada kamatoy sikan bata, nalipodong puli.” Di pigngingisihan dan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Anoy man no nakayuwas on sikan mgo otow, migsed si Jesus duon to pigkotangan to sikan bata aw tagoni to boyad. Dajun bangun sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na, to pagbanhaw ni Jesus to sikan bata nabantug diya to tibo nakalibong no kayunsudan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Paglikat ni Jesus, meyduon daduwa no ka buta no migyupug kandin. Nanawag sikandan to maagbot, “O Kaliwat ni Hari David, sadangay kae-ati koy.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na, pagsed ni Jesus to bayoy, migpadani sikan mgo buta. Dajun usip si Jesus, “Ogtuu kow no ogkaulian ku sikiyu?” Kagi dan, “Hoo Sir.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dajun dampaa ni Jesus sikan mgo mata dan. Kagi din, “Ogkatuman sikan pigtuuhan now.” ");
INSERT INTO msmNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Duon-dajun migkita sikandan, di pigbahog ni Jesus no wada ognangonan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Di pagpanow dan on, nasi on sikandan naosoyan to pagnawnangon to sikan pighinang ni Jesus. Kaling nabantug sikandin duon to tibo nakalibong no kayunsudan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Oompok pad to sikan daduwa no ka otow, meyduon isab pigdaya duon ki Jesus no pigpoha to madoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pagkaabug ni Jesus to sikan ispiritu, nakaikagi on sikan otow. Natingaya yagboy to mgo otow duon. Kagi dan, “Iyan-iyan pad yagboy no pagkakita ta to angod to seini kani ita no mgo kaliwat ni Israel!” ");
INSERT INTO msmNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Di to mgo Pariseo mig-iling, “Kae! Ogpakaabug sikandin to mangkadoot no ispiritu su pigbogajan man to gahom ni Satanas no panguyu dan!” ");
INSERT INTO msmNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na, pigyogob-yogob ni Jesus to kayunsudan dow kabaryuhan. Nang-anad sikandin duon to mgo simbahan to mgo Hibru, aw iwali din to Madojow no Nawnangonon bahin to paghari to Diyus. Pinangdojow din isab to mgo otow to inggad nokoy no pigbati dan. ");
INSERT INTO msmNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pagkita din to sikan mahan-in no kaotawan, pigkae-atan din hilabi su mahan-in to ogkalimuutan dan aw wada ogkaimanan. Angod sikandan to mgo karneru no wada og-atiman. ");
INSERT INTO msmNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Dajun ikagihi ni Jesus to mgo inanad din, “Mahan-in to ogkaliyag podom ogpaminog to Madojow no Nawnangonon. Angod sikandan to mayow-ag no uma no anihonon on, di minus to mag-anihay. ");
INSERT INTO msmNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pangamuju kow to Diyus no iyan tag-iya to sikan uma no musugu sikandin to duma no mag-anihay, no ko ita pa, dugang no mgo otow no ogpakabulig to pagnawnangon to sikan Madojow no Nawnangonon.” ");
INSERT INTO msmNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pigtawag ni Jesus sikan mgo inanad din no sampuyu-tag-duwa aw bogaji to katongod to pag-abug to mangkadoot no ispiritu dow to pagpangdojow to tibo mgo sakit. ");
INSERT INTO msmNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Seini to mgo ngadan to sikan sampuyu-tag-duwa no og-ilingon isab to mgo apustulis: una, si Simon no pigngadanan isab ki Pedro dow si Andres no suun din, dajun si Santiago dow si Juan no mgo anak ni Sebedeo, ");
INSERT INTO msmNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","si Felipe dow si Bartolome, si Mateo no magsukutay to buhis dow si Tomas, si Santiago no anak ni Alfeo dow si Tadeo, ");
INSERT INTO msmNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","si Simon no maunungon hilabi to tribu dan, dow si Judas Iscariote no iyan ogyuib ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pagkahimun to sikan sampuyu-tag-duwa no mgo inanad ni Jesus, pigpak tugun din sikandan su ogsuguon din. Kagi din, “Kona kow og-andiya to mgo otow no kona no mgo Hibru. Kona kow isab og-andiya to mgo kayunsudan no sakup to Samaria. ");
INSERT INTO msmNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Diya kow nasi deg to angod ta no mgo kaliwat ni Israel, su naangod sikandan to nangkayagak no karneru. ");
INSERT INTO msmNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ko muandiya kow, walihi sikandan no madani on to paghari to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pangdojawa now to mgo masakiton aw banhawa to mgo patoy. Pang-ulii now to pigpangsangla aw abuga to mangkadoot no ispiritu no migsamuk to mgo otow. Di kona now sikandan ogsukutan to bajad su puli da imbogoy iyu sikan no gahom. ");
INSERT INTO msmNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kona kow ogdae to saepi inggad sinsilyu da. ");
INSERT INTO msmNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kona kow isab ogdae to puju ubin ogkailisan now no kabo dow sapatus. Inggad agos kona kow ogdae, su to otow no ogtrabahu angay no bogajan to kinahangyanon din. ");
INSERT INTO msmNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ko mutidow kow duon to inggad andei no yunsud ubin baryu, pamangha kow to otow no madojow to batasan no ogkapaabutan now. Pakamonang kow duon kotob no mupanow kow on. ");
INSERT INTO msmNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ko mutidow kow duon to songo bayoy, ikagihi now, ‘Madojawan kow podom to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na, ko mudawat sikandan iyu, ogkadawat dan sikan pig-ikagi now no panalangin. Di ko kona kow dawaton, ogsibog da sikan duon iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ko wada ogdawat iyu duon to songo bayoy ubin yunsud aw wada ogpaminog iyu, padpada to abug to sapatus now ko lumikat kow pagpakiyaya no kona kow on ogkasukutan ko kastiguhon sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ligdongi now seini. Duon to Aedow to Paghukum, ko mabog-at on man to kastigu no igpahamtang to Diyus to mgo taga-Sodoma dow taga-Gomora no nahilabihan to kadoot to diya una, iyan on man to mgo otow no kona ogpaminog iyu!” ");
INSERT INTO msmNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Migpadajun si Jesus to pag-ikagi, “Ogsuguon ku sikiyu diya to madoot no mgo otow. Ogkaangod kow to mgo nati no karneru no ogkalibongan to mangongoon. Kaling pakaalistu kow, di kinahangyan isab no wada igkasawoy iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bantoy kow su ogpaatubangon kow duon to mgo husajan, dajun ogbun-ugon kow duon. ");
INSERT INTO msmNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ogpaatubangon kow isab diya to mgo gubernadur dow hari tongod to pagtuu now kanay. Na, sikan on to panahon no ogpakalugar kow to pagpasabut kandan to Madojow no Nawnangonon, hasta diya isab to mgo sakup dan no kona no Hibru. ");
INSERT INTO msmNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Na, ko paatubangon kow diya to husajan, kona kow ogkalimuut to og-ikagihon now, su duon to sikan no panahon, ogpahona-honaon kow to madojow no igtabak. ");
INSERT INTO msmNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Su to og-ikagihon now kona no iyu no kagi, di kaning Ispiritu to Diyus no Amoy now no igpabaja iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Duon isab to sikan no panahon,” kagi ni Jesus, “meyduon mgo otow no ogyuib to suun dan no ogtuu kanay agun hukuman to kamatajon. Meyduon isab mgo amoy no angod to sikan to oghinangon duon to anak dan. Ogpakayangub ngani to mgo anak to pagpahimatoy to ginikanan. ");
INSERT INTO msmNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ogkuntrahon kow to tibo kaotawan tongod to pagtuu now kanay. Di to otow no kona yagboy ogyobad to pagtuu, ogkayuwas. ");
INSERT INTO msmNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ko paantuson kow duon to songo banwa, yaguy kow diya to yain no banwa. Tinood yagboy no kona now pad ogkayogob to pagpang-anad duon to tibo kayunsudan ta no mgo kaliwat ni Israel, siak no Anak to Otow ogpauli on. ");
INSERT INTO msmNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Na, to inanad kona ogpakayabow to maistru din. To suguonon isab kona ogpakayabow to agayon din. ");
INSERT INTO msmNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Igu on to inanad ko makaangod to maistru din, aw igu on isab to suguonon ko makaangod to agayon din. Na, ko siak no agayon now oghingadanan to mgo otow ki Satanas, iyan on man sikiyu no mgo sakup ku! ");
INSERT INTO msmNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Kona kow ogkahaedok to mgo otow no ogsupak iyu. Su wada tinakyuban no kona ogkaukisan, wada isab inghobong no kona ogkabutwa. ");
INSERT INTO msmNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","To diya pigpang-ikagi ku no sikiyu da to migdinog, ipangnawnangon now on. To diya inghagas ku iyu, ibandilyu now on. ");
INSERT INTO msmNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kona kow ogkahaedok to otow no oghimatoy to yawa now, su kona dan ogkaamonu to umagad now. Iyan nasi mahaedokan now to Diyus, su sikandin to ogpakatimbag to yawa dow umagad now diya to impernu. ");
INSERT INTO msmNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Di domdoma now no ogbantajan kow to Diyus. Su inggad to maja no kona da ogkaman-u ko bolihon, wada inggad sobuuk kandan no ogkaamonu ko kona no pagboot to Amoy now no Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Di sikiyu yabow no kona ogkalingawan to Diyus, su ngani man to bubue now di tibo din nabilang! ");
INSERT INTO msmNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kaling kona kow ogkahaedok su ngani sikan mgo manuk-manuk ogbantajan din, sikiyu on man to kona din bantajan! ");
INSERT INTO msmNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Inggad hintawa no og-angkon kanay duon to atubangan to otow, og-angkonon ku isab duon to atubangan to Amoy ku diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Di inggad hintawa no oglidung kanay duon to atubangan to otow, iglidung ku isab duon to atubangan to Amoy ku diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Basi ko mighona-hona kow no iyan ing-andini ku to kalibutan agun ogdojow to rilasyun to mgo otow. Kona kay no iyan tuud ku sikan, su to pag-andini ku ogkasinupakay nasi sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Angod pananglit to seini: To inoy dow amoy no ogtuu kanay ogsupakon to mgo anak dan no kona ogtuu. Ogsinupakay isab to patae-ugangan su meyduon ogtuu kanay, meyduon kona. ");
INSERT INTO msmNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iyan ogkuntra to otow to sakup da to pamilya din. ");
INSERT INTO msmNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ko minus da to gugma to otow kanay su iyan yabow to gugma din to amoy dow inoy din, kona og-angajan no ogpasakup kanay. Ko minus da isab to gugma kanay to inggad hintawa su iyan yabow to gugma din to anak din, kona isab og-angajan ogpasakup kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inggad hintawa no kona ogtiang to krus din aw unung kanay, kona sikandin og-angajan ogpasakup kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","To otow no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay inggad igkamatoy din, nasi ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Inggad hintawa no ogdawat iyu, kibali siak to ogdawaton. Aw to ogdawat kanay kibali ogdawat isab to sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inggad hintawa no ogdawat to otow no kibali ba-ba to Diyus tongod to sikan pagkasinugu din ogbayosan sibu to igbayos to sikan kibali ba-ba to Diyus. Inggad hintawa isab no ogdawat to diyusnon no otow tongod to pagkadiyusnon din ogbayosan sibu to igbayos to sikan diyusnon no otow. ");
INSERT INTO msmNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aw ogbayosan yagboy to Diyus to diya ogpainom to inggad songo basu da no wohig to obos no sakup ku su sakup ku man sikan namuju.” ");
INSERT INTO msmNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tapus tuguna ni Jesus sikan sampuyu-tag-duwa no mgo inanad din, migpanow sikandin aw pang-anad dow pangwali to mgo otow duon to kadanihan no mgo yunsud. ");
INSERT INTO msmNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na, si Juan no Magbawtismuhay no diya to prisuhan nakadinog to nangkahinang ni Jesu-Cristo. Kaling pigsugu din to mgo inanad din ");
INSERT INTO msmNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","to pag-usip ki Jesus dow sikandin iyan to diya ogpaabuton dan ubin ko meyduon pad yain. ");
INSERT INTO msmNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Migtabak si Jesus, “Pauli kow diya ki Juan aw nangoni to pigdinog dow pigkita now kani. ");
INSERT INTO msmNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ikagihi now no nakakita on to mgo buta, nakapanow on to mgo pulid, naulian on to pigpangsangla, nakadinog on to mgo bongey, nabanhaw on to mgo patoy, aw to mgo pubri nakadinog on to Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Madojow to mgo otow no kona ogduwa-duwa to pagtuu kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Paglikat on to sikan mgo sinugu ni Juan, pig-ikagihan ni Jesus to mgo otow no nahimun duon, “No umandiya kow ki Juan diya to matahay no banwa, nokoy man to pigpamangha now? Otow buwa no ogkaisab-isab to hona-hona angod to tigbow no ogkawkaemagon? Kona. ");
INSERT INTO msmNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Na, nokoy naan? Otow buwa no nangabo to mahalon? Kona isab. Su to ogpangabo to mahalon diya da ogkitaon to palasyu. ");
INSERT INTO msmNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Na, nokoy man yagboy to ing-andiya now? Otow no kibali ba-ba to Diyus? Sikan iyan, di si Juan yabow pad to diya duma no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Su sikandin to diya suguonon no ognangonon to Diyus duon to Kasuyatan no pig-iling, ‘Meyduon suguonon ku no ogpaunahon ku ikow agun mahinaat din to mgo otow to pagtidow nu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Na, ligdongi now seini,” kagi ni Jesus, “wada pad on yagboy otow no yabow ki Juan no Magbawtismuhay. Di duon to ogharian to Diyus, inggad to kinaobosan no otow yabow pad ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","“To diya una no wada pad si Juan, to paghari to Diyus intag-an ni Moises dow to tibo duma no kibali ba-ba to Diyus. Na, sugud no muwali si Juan hangtod kuntoon, hinggawan migbukyad to gingharian to Diyus, aw migdodongan to mgo otow to pagdagha agun makased duon. ");
INSERT INTO msmNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ko ogtuu kow pa to pig-ikagi to diya una no kibali mgo ba-ba to Diyus, ogpakasabut kow podom no si Juan mismu to diya og-ilingon no si Elias no ogtidow. ");
INSERT INTO msmNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na, sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Na,” kagi ni Jesus, “nokoy man to ogkaangodan to mgo otow kuntoon? Angod sikandan to balingag no mgo bata duon to usibaanan. Ogsabihon sikandan to mgo duma dan no og-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Piglisagan noy sikiyu, di wada kow sinajow. Migdegmatoy koy isab, di wada kow tiniyahu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Angod sikandan to sikan mgo bata su ngani si Juan no ogpuasa aw kona og-inom to inomon, di oghapoyan dan no piggahoman to madoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Hasta siak no Anak to Otow no migpagduma-duma to pagkoon dow pag-inom, pigsawoy a dan isab. Og-ilingon a no yogodon dow palahobog dow duma to mgo magsukutay to buhis hasta duma no makasasaya. Di inggad sikan on, ogkamaanan no hustu to impang-anad ku dow to impang-anad ni Juan, su ogkitaon sikan duon to kinabuhi to mgo otow no ogtuman to pagboot to Diyus angod kanay dow ki Juan.” ");
INSERT INTO msmNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Dajun ipanagda ni Jesus to naman-ugpa duon to mgo yunsud no iyan yabi no pighinangan din to milagru, su wada sikandan sosey aw wada dan talikudi to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kagi din, “Alaot kow no mgo taga-Corasin dow taga-Betsaida! Madojow pad to taga-Tiro dow taga-Sidon, su ko sikandan pa to migkita to diya mgo milagru no pighinang ku duon iyu, nayugoy da podom sikandan talikud to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Indani now seini. Duon to Aedow to Paghukum, ko mabog-at on man to kastigu no igpahamtang to mgo taga-Tiro dow taga-Sidon, iyan on man sikiyu no mgo taga-Corasin dow taga-Betsaida! ");
INSERT INTO msmNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Sikiyu isab no mgo taga-Capernaum, ogkaliyag kow no og-abuton now suja taba to yangit, di nasi no igyon-ok kow diya to kinadidayoman to pasak. Madojow pad to mgo taga-Sodoma, su ko sikandan pa to migkita to diya mgo milagru no pighinang ku duon iyu, migsosey on podom sikandan aw pigtalikudan dan on to mgo sae dan, aw to diya yunsud dan dugaja pad podom kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Indani now seini. Duon to Aedow to Paghukum, ko mabog-at on man to kastigu no igpahamtang to mgo taga-Sodoma, iyan on man sikiyu no taga-Capernaum!” ");
INSERT INTO msmNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pagkatapus to sikan, mig-ampu si Jesus, “Amoy ku no Magboboot to yangit dow pasak, ogpasalamat a ikow su sikan inlidung nu to idukadu no mgo otow dow to yabow to naamuhan impakita nud nasi diya to obos no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nailing to sikan su iyan man pagboot nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dajun ikagihi ni Jesus sikan mgo otow, “To tibo panabut insalig kanay to Diyus no Amoy ku. Wada yain no namaan kanay, sikandin da. Wada isab yain no namaan kandin, siak da dow to mgo otow no igpakiyaya ku kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na, sikiyu tibo no pigboyajan dow nabog-atan, andini kow kanay su ogpapahuwajon ku sikiyu. ");
INSERT INTO msmNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pasakup kow aw paanad kow kanay agun ogkahimotang to ginhawa now, su madojow a. ");
INSERT INTO msmNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kona kow ogkabog-atan su kona no malisod to igpahinang ku iyu.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anoy man no Aedow on no Tigpahuway, nakabaja si Jesus dow mgo inanad din duon to mgo uma. Pigpamontas to mgo inanad din, kaling nangotu sikandan to mgo uhoy to trigu aw kitopa dan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Pagkita to mgo Pariseo to sikan, migsagman sikandan. Kagi dan ki Jesus, “Aduy, nakayapas on kay suja mgo inanad nu to Aedow no Tigpahuway!” ");
INSERT INTO msmNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Kagi ni Jesus, “Ajaw now og-ilinga no wada kow makabasa to pighinang ni Hari David to diya una no bontason sikandin dow mgo duma din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Migsed sikandin duon to bayoy to Diyus aw koon to pan no inghalad to Diyus aw pakoona to mgo duma din. Na, ojow pa to balaod, iyan da ogpakakoon to sikan to mgo magdudumaya to tinuuhan ta. ");
INSERT INTO msmNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ajaw now isab og-ilinga no wada kow makabasa to sikan balaod no ogpatrabahuon to mgo magdudumaya to tinuuhan ta inggad Aedow no Tigpahuway. Di kona isab sikandan ogpakasae to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ligdongi now seini. Yabow iyan sikan Bayoy to Diyus, di mey on kani iyu no yabow pad to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Meyduon sinuyat no kagi to Diyus no pig-iling, ‘Kona no iyan og-awoson ku to mgo mananap no ogtutungon no ighalad now kanay. Iyan nasi og-awoson ku no mukae-at kow to duma.’ Na, ko makasabut kow pa to sikan, kona kow podom ogpakahukum to seini wada mgo sae. ");
INSERT INTO msmNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Su siak no Anak to Otow iyan meyduon katongod to pagboot to Aedow no Tigpahuway.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Migpadajun si Jesus diya to simbahan dan aw sed. ");
INSERT INTO msmNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na, mey otow duon no pawing to dibayuy no boyad. Mey isab mgo otow duon no namangha to igkariklamu dan kuntra ki Jesus. Kaling pig-usip dan sikandin, “Igtugut buwa to balaod to tinuuhan ta to pagpangdojow to otow duon to Aedow no Tigpahuway?” ");
INSERT INTO msmNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Migtabak si Jesus, “Nokoy man, ko mey karneru now no mauyug duon to yugi duon to Aedow no Tigpahuway, kona now buwa ogbatunon? ");
INSERT INTO msmNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Na, ko mahal on man to karneru, iyan on man to otow! Kaling ko ogtabang ki to otow duon to Aedow no Tigpahuway, kona ki ogpakayapas to balaod.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Dajun ikagihi ni Jesus sikan pawing, “Kotonga sikan boyad nu.” Pagkotonga din, dajun naulian aw naangod on to sikan dibayuy no boyad. ");
INSERT INTO msmNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Di to mgo Pariseo migyuwas su ogsasabutan dan dow og-amonuhon to pagpahimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Di namaanan ni Jesus to planu to mgo Pariseo, kaling pigyagujan din sikan no banwa. Mahan-in to migduma kandin, aw pinangdojow din to tibo mgo masakiton duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Di pigbahog din no kona dan sikandin ignawnangon ");
INSERT INTO msmNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","agun no matuman to diya impasuyat ki Isaias no kibali ba-ba to Diyus. Insuyat din to kagi to Diyus bahin ki Jesus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Seini to pinili no Suguonon ku. Pinadajag dow ingkalipay ku yagboy sikandin. Oggahoman ku sikandin to Ispiritu ku, aw ignawnangon din to tibo mgo tribu to pagboot ku. ");
INSERT INTO msmNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Kona sikandin ogpagyalis aw ogbansagon. Kona isab og-ikagi to maagbot duon to karsada. ");
INSERT INTO msmNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ogdigonon din to mgo otow no magobu to pagtuu. Ogdasigon din to ogkangkabahawan hangtod no padaogon din to matarong no mgo tuud ku. ");
INSERT INTO msmNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Sikandin to og-imanan to tibo mgo tribu.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Na, meyduon otow no pigbuta dow pigpoha to madoot no ispiritu. Pigdaya sikandin diya ki Jesus aw pigdojow din, dajun nakakita sikan otow aw nakaikagi. ");
INSERT INTO msmNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hilabi naboyong to tibo mgo otow no migkita to sikan. Mig-iling sikandan, “Aduy, iyan on kay buwa sikan ogpaabuton no Kaliwat ni David no ogpaharion to Diyus ita!” ");
INSERT INTO msmNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Di naman-iling to mgo Pariseo no migdinog to sikan, “Kae! Ogpakaabug sikandin to mangkadoot no ispiritu su pigbogajan man to gahom ni Satanas no panguyu dan!” ");
INSERT INTO msmNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Namaanan ni Jesus to hona-hona dan, kaling pig-ikagihan din sikandan, “Ko pananglit og-uunoy oggera to mgo sakup to songo nasyun, ogkabongkag sikan no nasyun. Sikan isab to ogkadeygan ko meyduon yunsud ubin panimayoy no og-uunoy ogbubuyow-buyow to mgo sakup. ");
INSERT INTO msmNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko unajon pa abugon ni Satanas to mgo sakup din no mangkadoot no ispiritu, migpasabut no sikandin da to mig-amung-amung to kaugalingon din. Na, ko pananglitan ilingon din to sikan, kona oghangtod to pagmandu din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Aw siak, ko iyan pa ig-abug ku to gahom ni Satanas, sikan isab mgo sakup now no ogpang-abug to mangkadoot no ispiritu, ki Satanas naan no gahom to ig-abug dan? Sikandan mismu iyan kistigus no nasajop kow. ");
INSERT INTO msmNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Di ko iyan ig-abug ku to Ispiritu Santu, ogkamaanan now no dinid on iyu to paghari to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Iyan da ogkaabug to mangkadoot no ispiritu ko unahon daogon si Satanas no agayon dan. Angod pananglit to seini. Wada ogpakased to bayoy to madoson no otow to pag-agow to katigajunan din ko kona sikandin mauna madaog aw gapusa.” (Migpasabut si Jesus no nadaog din on iyan si Satanas, kaling ogpakaabug sikandin to mangkadoot no ispiritu.) ");
INSERT INTO msmNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kagi isab ni Jesus, “Inggad hintawa no kona ogpadapit kanay iyan ogsupak kanay. To otow isab no kona ogbulig kanay to paghimun iyan ogpasuwoy to mgo otow no ogpadani podom kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ligdongi now seini. Inggad nokoy no sae ogkapasaylu da, inggad to pagpasipaya to Amoy no Diyus. Di to otow no ogyangub ogpasipaya to Ispiritu Santu kona yagboy ogkapasaylu. ");
INSERT INTO msmNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Inggad hintawa no ogpasipaya kanay no Anak to Otow ogkapasaylu da, di to otow no ogpasipaya to Ispiritu Santu kona yagboy ogkapasaylu kuntoon dow hangtod to wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Na, to og-ikagihon to otow ogpakiyaya dow nokoy sikandin otawa, angod to bogas to kaju no ogpakiyaya dow nokoy kajuha. Su to madojow no kaju ogbogas to madojow, aw to kaju no meyduon sakit ogbogas to madoot. ");
INSERT INTO msmNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Na, sikiyu no angod to mgo hayas, og-amonuhon now man to pag-ikagi to madojow no madoot kow man? Su inggad nokoy to ogkahona-honaan to otow iyan isab ogyogwa duon to ba-ba din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","To madojow no otow madojow to hona-hona, kaling madojow to ogkaikagi din. Di to madoot no otow madoot to hona-hona, kaling madoot to ogkaikagi din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Indani now seini. Ko muabut to Aedow to Paghukum, ogsukutan to mgo otow to tibo nangkaikagi dan no wada mgo pues. ");
INSERT INTO msmNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Duon to mgo kagi now ogkamaanan dow nokoy to hukum iyu, ko sae-an kow ubin ko kona.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tapus to sikan, meyduon mgo Pariseo dow mgo maistru to tinuuhan no mighangyu ki Jesus. Kagi dan, “Sir, pakitaa koy kun to milagru pagpakiyaya no Diyus to migpadae ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kagi ni Jesus kandan, “Pagkadoot now no mgo otow kuntoon! Migpadiyu kow to Diyus, kimbusna ogpamangha kow to milagru! Di iyan da igkapakita iyu to angod to nahitabu ki Jonas no kibali ba-ba to Diyus to diya una. ");
INSERT INTO msmNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Su to diya pagyam-oda kandin to maaslag no isda, tatoyu no aedow din duon to gotok ayha sikandin yupada. Angod isab kanay no Anak to Otow, og-abutan a to tatoyu no aedow duon to didayom to pasak ayha a ogkabanhaw. ");
INSERT INTO msmNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na, ko muabut to Aedow to Paghukum, ogbasuyon kow to mgo taga-Ninibe su pagwalihi kandan ni Jonas, migsosey sikandan aw talikudi to mgo sae dan. Di kuntoon meyduon kani iyu no yabow pad on ki Jonas, di wada kow paminog to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ogbasuyon kow isab to diya rayna to Seba duon to Aedow to Paghukum. Su inggad madiyu, di migpaahot sikandin to pagpanow agun makapaminog to maalamon no kagi ni Hari Salomon. Di kuntoon meyduon kani iyu no yabow pad on ki Salomon, di wada kow paminog to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pananglit meyduon madoot no ispiritu no naabug duon to otow no pigsedan din. Migpaligbut sikan ispiritu duon to matahay no mgo banwa to pagpamangha to ogkaugpaan din. Di anoy man no wada nakitaan din, ");
INSERT INTO msmNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","mighona-hona sikandin no ogpauli diya to una no pig-ugpaan din. Na, pagbalik din on duon to sikan otow, naaha din no angod on to bayoy no sinilhigan no wadad mig-ugpa dow madojow on to pagkatapid. ");
INSERT INTO msmNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Dajun sikandin pandokat to pitu no mgo angod din no yabow pad to kadoot aw sed isab duon to sikan otow. Na, ko malisod on man to kabotang to sikan no otow to diya una, iyan on man kuntoon! Angod to sikan to kadootan no og-abut iyu no madoot no mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","No mig-ikagi pad si Jesus duon to nahimun no kaotawan, meyduon mignangon kandin no migtidow to inoy dow mgo suun din no yukos. Ogpayuwason sikandin su meyduon tuud dan. ");
INSERT INTO msmNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kagi ni Jesus, “Hoo iyan, di ognangonan ku sikiyu dow hintawa to pig-isip ku no inoy dow mgo suun yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Dajun din ihindu to mgo inanad din aw ikagi, “Seini to inoy ku dow mgo suun ku. ");
INSERT INTO msmNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Su inggad hintawa no ogtuman to pagboot to Amoy ku diya to yangit og-isipon ku no iyan inoy dow suun no mgo yukos dow bohi.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","To diya da no aedow, migyuwas si Jesus to bayoy aw ingkud duon to higad to danow. ");
INSERT INTO msmNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hilabi mahan-in to mgo otow no nahimun duon, kaling mig-ingkud sikandin duon to bangka su og-anadon din sikan mgo otow no namanindog duon to higad. ");
INSERT INTO msmNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mahan-in to impang-anad din no impabaja to pananglitan. Kagi din, “Meyduon mag-uuma no mig-odok to binhi. ");
INSERT INTO msmNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pagsabud din, meyduon mgo binhi no duon kodog to dayan aw pigpanubug to mgo manuk-manuk. ");
INSERT INTO msmNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Meyduon isab binhi no duon kodog to batuhon no pasak. Madali giti su manipis da to pasak. ");
INSERT INTO msmNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Di pagsogahi, migyanos sikan mgo tanom aw kagangu su mababow da to dalid. ");
INSERT INTO msmNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Meyduon isab binhi no duon kodog to pasak no tahan mey dalid to sampinit. Dongan to pagtubu to sikan mgo tanom, nanalingsing isab sikan mgo sampinit hangtod no pigyam-od sikan mgo tanom. ");
INSERT INTO msmNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Di to duma no mgo binhi duon kodog to madojow no pasak. Sikan to miggiti aw migbogas. Duon to sikan, meyduon kasarangan da to abut, meyduon madogi to abut aw meyduon isab hilabi mig- but. ");
INSERT INTO msmNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na,” kagi ni Jesus, “sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Migpadani to mgo inanad ni Jesus aw usip, “Nokoy no igpabaja nu man to pananglitan ko ogpang-anad ka kandan?” ");
INSERT INTO msmNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Migtabak si Jesus, “Pigpasabut kow to paghari to Diyus no wada din ipasabut to diya una. Di to duma no mgo otow wada din pasabuta. ");
INSERT INTO msmNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Su ogdugangan to Diyus to pagsabut to otow no ogdawat to igpasabut kandin agun mahan-in on to ogkasabutan din. Di to otow no kona ogdawat to igpasabut kandin to Diyus, oggawangon pad inggad to maintok no nasabutan din on. ");
INSERT INTO msmNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaling igpabaja ku to pananglitan to pag-anad kandan su inggad og-aha sikandan, kona ogkita. Inggad ogpaminog, kona yagboy ogpakadinog aw kona ogpakasabut. ");
INSERT INTO msmNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Natuman duon kandan to diya pig-ikagi to Diyus no impabaja ki Isaias no pig-iling, ‘Kanunoy sikandan ogpakadinog di kona ogpakasabut, kanunoy og-aha di kona yagboy ogpakakita. ");
INSERT INTO msmNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nailing to sikan su pigkubayan on to mgo hona-hona dan. Ogpamabongey-bongey aw ogpamabuta-buta sikandan agun kona makasabut, su unu ko makakita sikandan aw makadinog dow makasabut aw atubang kanay agun mayuwas ku sikandan.’ ");
INSERT INTO msmNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Di sikiyu,” kagi ni Jesus, “madojow kow su ogkiyaya kow to ogkitaon now, aw ogpakasabut kow to ogdinogon now. ");
INSERT INTO msmNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Su mahan-in to otow to diya una no kibali ba-ba to Diyus dow duma no diyusnon no mgo otow no mig-awos podom no makakita to sikan pigkita now kuntoon, di wada sikandan kita. Mig-awos isab podom sikandan no makadinog to sikan nadinog now kuntoon, di wada sikandan dinog. ");
INSERT INTO msmNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Na, paminog kow su ogpasabuton ku sikiyu to diya pananglitan to otow no mig-odok. ");
INSERT INTO msmNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Meyduon mgo otow no ogdinog to nawnangonon to paghari to Diyus, di kona ogpakasabut. Angod sikandan to diya dayan no nasabudan to binhi su og-agawon ni Satanas sikan kagi to Diyus duon to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sikan batuhon no pasak no nasabudan to binhi igkapananglit to mgo otow no ogdinog to kagi to Diyus no ogtukhow aw ogdawat dajun. ");
INSERT INTO msmNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Di kona no hogot to pagtuu dan, kaling kona ogyugoy sikan. Su ko abuton sikandan to mgo kalisod dow mgo antusonon tongod to pagdawat dan to kagi to Diyus, og-ojowan dan dajun to pagtuu dan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sikan isab sampiniton no pasak no nasabudan to binhi igkapananglit to mgo otow no ogdinog to kagi to Diyus, di ogkawili sikandan to mgo kalimuutanan kani to kalibutan dow to pagpadatu. Kaling ogkaangod sikandan to mgo tanom no wada bogas. ");
INSERT INTO msmNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Di sikan madojow no pasak igkapananglit to mgo otow no ogdinog to kagi to Diyus aw ogpakasabut. Na, sikan pigdinog dan ogpamogas duon to kinabuhi dan. To duma, kasarangan da to bogas. To duma madogi, aw mey isab hilabi madogi.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Migpananglit on isab si Jesus. Kagi din, “To ogharian to Diyus ogkaangod to seini. Meyduon otow no mig-odok to madojow no binhi duon to uma din. ");
INSERT INTO msmNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Di pagkadukilom no tibo on nalipodong, pig-anduon to kuntra din sikan uma aw sabudi to binhi to bagnot, dajun panow. ");
INSERT INTO msmNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Migdodongan to paggiti sikan madojow no tanom dow sikan bagnot. Di pag-iswak on to sikan tanom, nakiyayahan sikan mgo bagnot su wada pamogas. ");
INSERT INTO msmNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","To mgo trabahanti to sikan tag-uma mig-andiya kandin aw ikagi, ‘Sir, madojow man to diya ing-odok nu no binhi duon to uma nu. Andei man buwa kapuun sikan mgo bagnot?’ ");
INSERT INTO msmNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Migtabak sikan tag-uma, ‘Trabahu sikan to kuntra ku.’ Mig-usip isab to mgo trabahanti din, ‘Ogpandutduton noy?’ ");
INSERT INTO msmNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Ajaw naa,’ kagi to sikan tag-uma, ‘su unu ko mayakip sikan mgo tanom. ");
INSERT INTO msmNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Pakamonangi naa, su ko tig-ani on, og-ikagihan ku to mgo mag-anihay no himunon dan sikan mgo bagnot dow bogkoton aw sangaba. Pagkatapus, igpaani ku aw igpadiwit duon to tambubung ku.’” ");
INSERT INTO msmNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kagi isab ni Jesus, “To pag-uswag to sikan ogharian to Diyus igkapananglit to binhi no maintok hilabi no igtanom to otow duon to uma din. ");
INSERT INTO msmNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kinaintokan iyan sikan, di oggiti aw ogyabow to katikang duon to duma no mgo tanom. Ogkaangod to kaju no oghapunan to mgo manuk-manuk sikan mgo sanga.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kagi isab ni Jesus, “To pag-uswag to sikan ogharian to Diyus ogkaangod isab to patubu no insakot to bohi duon to madogi no arina, aw migtubu sikan tibo minasa.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tibo sikan no pigpang-ikagi ni Jesus to kaotawan impabaja din to pananglitan. Wada ing-anad din kandan no wada ipabaja to pananglitan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Duon to sikan, natuman to diya impaikagi to Diyus to otow no kibali ba-ba din no pig-iling, “Igpabaja ku to pananglitan to igpang-anad ku kandan. Igpasabut ku kandan to namakahobong sugud pad to paghinang to kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tapus to sikan, piglikatan ni Jesus sikan mahan-in no mgo otow aw sed duon to bayoy. Dajun padani to mgo inanad din. Kagi dan, “Hiluwasi koy kun to diya pananglitan nu to mgo bagnot duon to uma.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kagi ni Jesus, “Siak no Anak to Otow iyan sikan otow no mig-odok to madojow no binhi. ");
INSERT INTO msmNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sikan uma impananglit to seini kalibutan. Sikan madojow no binhi impananglit to mgo otow no ogpahari to Diyus. Sikan mgo bagnot impananglit to mgo sakup ni Satanas. ");
INSERT INTO msmNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sikan kuntra no migsabud to binhi to bagnot impananglit ki Satanas. Sikan tig-ani impananglit to katapusan to kalibutan, aw sikan mag-anihay impananglit to mgo anghil. ");
INSERT INTO msmNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Na, sikan paghimun dow pagsangab to sikan mgo bagnot impananglit to ogkahitabu to katapusan to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Su siak no Anak to Otow ogsugu to mgo anghil ku to paggawang to tibo namanintal dow namanhinang to madoot duon to sikan ogharian ku. Oghimunon dan sikan no mgo otow ");
INSERT INTO msmNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","aw itimbag diya to kaeju. Ogpakadegmatoy to mgo otow duon aw ogkagot to ngipon dan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Di to mgo otow no pig-isip to Diyus no wadad sae ogkaangod to kasiga to soga diya to yangit ko diyad on sikandan to gingharian to Amoy dan no Diyus. Na, sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“To paghari to Diyus ogkaangod to mahalon hilabi no antik no nayugoy da iyobong duon to pasak. Pagkakita-i to sikan to songo otow, hilabi sikandin migtukhow. Dajun din iyobong manda dow uli aw ibaligja to tibo katigajunan din, aw to halin imboli to sikan pasak. ");
INSERT INTO msmNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“To paghari to Diyus ogkaangod isab to seini. Meyduon nigusyanti no namangha to madojow hilabi no mgo perlas no ogkaboli din. ");
INSERT INTO msmNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na, pagkita din to sobuuk no mahalon yagboy dow madojow og-ahaon, mig-uli sikandin. Imbaligja din to tibo katigajunan din, aw to halin imboli to sikan perlas. ");
INSERT INTO msmNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“To paghari to Diyus angod isab to seini. Meyduon mayow-ag no pukut no intuntun duon to danow no nakapudut to yain-yain no mgo isda. ");
INSERT INTO msmNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","No mahan-in on to isda no nasakup, piggujud to mgo mangisdaay diya to higad aw pagbugti-a to mgo isda. To mangkadojow intagu duon to ayat, aw to mangkadoot intimbag puli. ");
INSERT INTO msmNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Angod to sikan to ogkahitabu to katapusan to kalibutan, su ogsapimpinon to mgo anghil to mgo otow no pig-isip to Diyus no wadad sae dow to mangkadoot. ");
INSERT INTO msmNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Igtimbag dan sikan mangkadoot diya to kaeju. Ogpakadegmatoy to mgo otow duon aw ogkagot to ngipon dan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Na,” mig-usip si Jesus, “nasabut now on tibo seini ing-anad ku iyu?” “Hoo,” kagi dan. ");
INSERT INTO msmNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kagi ni Jesus, “Na, ko meyduon maistru to tinuuhan ta no migtuu on to impang-anad ku bahin to paghari to Diyus, igkapananglit sikandin to otow no mahan-in to bag-u dow tahan no mgo botang duon to budiga no ogkagamit din. Su kona no iyan da igkaanad din to tahan, di igkaanad din isab to bag-u.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tapus makaikagi si Jesus to sikan mgo pananglitan, piglikatan din sikan banwa ");
INSERT INTO msmNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aw uli diya to yunsud din dow pang-anad duon to simbahan. Natingaya hilabi to mgo otow no migdinog kandin. Kagi dan, “Eh, sei no otawa, andei man buwa kapuun to kaalam din? Naamonu no ogpakahinang man sikandin to mgo milagru? ");
INSERT INTO msmNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Namaanan ta man no anak sikandin to diya pandoy, aw iyan inoy din si Maria. Suun sikandin ni Santiago, ni Jose, ni Simon dow ni Judas. ");
INSERT INTO msmNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Dini man ngani ugpa ita to mgo atoboy din. Na, andei man kapuun sikan nangkaamuhan din?” ");
INSERT INTO msmNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kaling nadootan sikandan ki Jesus. Di pig-ikagihan sikandan ni Jesus, “To otow no kibali ba-ba to Diyus ogtahudon duon to inggad andei, di wada ogtahud kandin duon to yunsud ubin pamilya din.” ");
INSERT INTO msmNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kaling wada hinang si Jesus to mahan-in no mgo milagru duon, su wada sikandan tuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na, to diya no panahon, si Herodes no gubernadur to Galilea nakadinog to nangkahinang ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kaling pig-ikagihan din to mgo upisyalis din, “Sikan oghingadanan ki Jesus iyan si mina Juan no Magbawtismuhay no nabanhaw, kaling ogpakahinang to mgo milagru!” ");
INSERT INTO msmNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Naikagi ni Herodes sikan su to diya una, impadakop din si Juan aw ipaprisu no ginapus tongod to pagsukat din ki Herodes no mig-agow ki Herodias no asawa to suun din no si Felipe. Pigbalik-balik ni Juan to pag-ikagi no nakayapas si Herodes to balaod to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kaling ogpahimatajan din podom si Juan, di nahaedok sikandin to kaotawan su migtuu sikandan no si Juan, kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anoy man no aedow on to kainanakan ni Herodes, migsajow to daega no anak ni Herodias duon to atubangan to mgo imbitadu. Nasajaan yagboy si Herodes to sikan, ");
INSERT INTO msmNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kaling pigsaadan din duma to sapa no ogbogajan din sikan daega to inggad nokoy no ogbujuon din. ");
INSERT INTO msmNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na, sikan daega pigsambagan to inoy, kaling mig-ikagi, “Iyan ogbujuon ku kuntoon dajun to uyu ni Juan no Magbawtismuhay no igbotang duon to bandihadu.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hilabi migdoot to ginhawa ni Herodes, di tongod to sikan saad no pigsapaan din duon to atubangan to mgo imbitadu, wada sikandin makabalibad. Kaling migsugu no tumanon sikan pighangyu to sikan daega. ");
INSERT INTO msmNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dajun tampoda to liog ni Juan diya to prisuhan. ");
INSERT INTO msmNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","To uyu din imbotang duon to bandihadu aw daeha dow ibogoy to sikan daega. Pigdawat din sikan aw daeha diya to inoy din. ");
INSERT INTO msmNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Sikan yawa ni Juan pigpudut to mgo inanad din aw iyobong. Dajun sikandan andiya ki Jesus aw nangoni to nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pagdinog ni Jesus to kamatajon ni Juan, migpapaawoy sikandin no migsakoy to bangka su ogpahilit. Di pagkamaan to kaotawan no taga-yain-yain no yunsud to ogdeygan ni Jesus, migliput sikandan su ogyupug kandin diya to dibayuy no higad. ");
INSERT INTO msmNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kaling pagduung ni Jesus, pigkita din on sikan mahan-in hilabi no mgo otow. Pigkae-atan din sikandan aw pigpangdojow din to nangkasakit duon. ");
INSERT INTO msmNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Anoy man no mahapun on, to mgo inanad ni Jesus migduguk kandin aw ikagi, “Mahapun on kay to kani, wada da man ogkapudutan to pagkoon kani to hilit. Madojow ko papanawon tad seini mgo otow diya to mgo baryu agun makaboli to pagkoon dan.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Di kagi ni Jesus, “Kona sikandan ogpapanawon. Sikiyu to mupakoon kandan.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kagi to mgo inanad, “Eh, lima da kay no buuk to pan dow daduwa da isab no ka isda to pagkoon ta kani.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Daeha dini,” kagi ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dajun din pamaingkuda sikan mgo otow duon to bagnot. Pigdawat din sikan lima no buuk no pan dow daduwa no ka isda aw yanghag diya to yangit to pagpasalamat to Diyus. Dajun din panibaga sikan pan aw ibogoy diya to mgo inanad din agun ipamogoy diya to kaotawan. Mighan-in yagboy sikan pan dow isda, ");
INSERT INTO msmNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","kaling nakakoon sikandan tibo kotob no nangkahantoy. Tapus to pagkoon, pigpanghimun to mgo inanad to nasama, aw kaponu to sampuyu-tag-duwa no ka ayat! ");
INSERT INTO msmNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mgo lima no libu to mgo yukos to nakakoon wada yabot to kabujagan dow kabataan. ");
INSERT INTO msmNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dajun pasakaja ni Jesus to mgo inanad din to bangka. Ogpaunahon sikandan diya to dihipag to danow su ogpalikaton din pad to mgo otow no nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pagkalius on to sikan mgo otow, migpapaawoy si Jesus no miggamat to bubungan su og-ampu. No madukilom on, duon pad gihapun sikandin, ");
INSERT INTO msmNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","di sikan pigsakajan to mgo inanad nakapatonga on to danow. Natuwae-tuwae sikan tongod to mangkaaslag no bayod, su nasugang dan to kaemag. ");
INSERT INTO msmNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Anoy man no kaadlawon on, migpanow si Jesus duon to babow to wohig no migyupug kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Di no kitaon dan sikandin no migpababow duon to wohig, pigdaitan sikandan aw namangiyak, “Aduy! Umagad!” ");
INSERT INTO msmNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Di dajun migtawag si Jesus, “Digona to ginhawa now su siak seini. Kona kow ogkahaedok.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dajun ikagi si Pedro, “Ginuu, ko sikuna yagboy sikan, papanawa a duon to babow to wohig pailing duon ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Kagi ni Jesus, “Na hala, andini ka.” Dajun patibi si Pedro duon to balili to bangka aw panow duon to babow to wohig padeg diya ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Di pagpaniid din no maagbot hilabi to kaemag, nahaedok sikandin aw ogyogdang podom. Dajun sikandin makapanabi, “Ginuu, tabangi a!” ");
INSERT INTO msmNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Duon-dajun pigtagonan ni Jesus to boyad din aw ikagihi, “Maintok pad naan to pagsalig nu kanay. Nokoy no ogduwa-duwa ka pad man?” ");
INSERT INTO msmNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pagkasakoy dan on to bangka, mig-ondang to kaemag. ");
INSERT INTO msmNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dajun simbaha si Jesus to sikan namanakoy no mig-iling, “Tinood yagboy no Anak ka to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na, pagtidow dan diya to dihipag, migduung sikandan diya to banwa no Genesaret. ");
INSERT INTO msmNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pigkiyaya si Jesus to mgo otow duon, kaling impapudut dan to tibo nangkasakit duon to nakalibong no mgo banwa aw daeha diya ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Migpangamuju sikandan no ko mahimu, inggad puli patudion to jawing-jawing duon to sidsid to kabo din. Na, naulian to tibo no nakatudi to kabo ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na, meyduon naman-andiya ki Jesus no mgo Pariseo dow mgo maistru to tinuuhan no napuun diya to Jerusalem. Mig-usip sikandan, ");
INSERT INTO msmNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nokoy no ogyapas man to mgo inanad nu to tumanon no nabuyatan ta? Su ogkoon sikandan no kona ogpanghugas to boyad dan to paagi no ing-anad to mgo minuna ta.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mig-iling si Jesus, “Na, sikiyu naan, nokoy no ogyapas kow man to sugu to Diyus agun iyan matuman now to iyu no mgo tumanon? ");
INSERT INTO msmNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Su to sugu to Diyus pig-iling, ‘Tahuda to amoy dow inoy nu.’ Insugu din isab no inggad hintawa no ogpasipaya to ginikanan oghimatajan. ");
INSERT INTO msmNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Di sikiyu, yahi to ing-anad now. Su inggad meyduon podom igkatabang to otow to ginikanan din, di ogpabalibadon now nasi sikandin to pag-iling, ‘Meyduon podom bobogoy ku iyu, di impaabin kud nasi to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Duon to sikan, klaru yagboy no pinakawada now sikan sugu to Diyus to pagtahud to ginikanan agun iyan matuman sikan iyu no tumanon. ");
INSERT INTO msmNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kunungkun mangkatarong! Tinood yagboy to diya kagi to Diyus no sinuyat ni Isaias bahin iyu no pig-iling din, ");
INSERT INTO msmNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Seini no mgo otow og-iling to pigtahud a dan, di kotob da to tumuy to dila dan, su wada a ibotang duon to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wada pues to pagsimba dan kanay, su iyan da igpang-anad dan to tumanon no pig-otawan.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pighimun ni Jesus to kaotawan aw ikagihi, “Paminogi now seini og-ikagihon ku aw panginsabuti now. ");
INSERT INTO msmNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kona no iyan ogpakaligsom to otow to igsungit duon to ba-ba din, di sikan madoot no ogyogwa duon to ba-ba din iyan ogpakaligsom.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dajun padani ki Jesus to mgo inanad din aw usip, “Wada ka kamaan no nadootan to mgo Pariseo to sikan pig-ikagi nu?” ");
INSERT INTO msmNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Migtabak si Jesus, “Angod sikandan to bagnot no wada itanom to Amoy ku no diya to yangit no puli ogpandutduton. ");
INSERT INTO msmNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pabay-ani sikan mgo Pariseo. Angod isab sikandan to mgo buta no ogpikit to angod dan no buta. Ogkauyug sikandan tibo duon to yugi.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kagi ni Pedro, “Hiluwasi koy kun to diya pananglitan nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mig-iling si Jesus, “Sikiyu isab, wada kow pad naan makasabut? ");
INSERT INTO msmNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","To ogkoonon to otow diya ogdeg to gotok, aw tapus to sikan, oggawas da to yawa. ");
INSERT INTO msmNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Di to ogyogwa duon to ba-ba din duon ogkapuun to ginhawa din. Sikan to ogpakaligsom kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Su to ginhawa to otow iyan ogkapuunan to madoot no mgo hona-hona, paghimatoy, paghinang to kayaw-ajan, pagpangawat, pagkistigus to gayu dow pagbuung to dongog to duma. ");
INSERT INTO msmNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sikan to ogpakaligsom to otow. Kona no iyan igkaligsomi to otow ko kona ogpanghugas to boyad ko ogkoon.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Dajun panow si Jesus aw andiya to banwa no sakup to mgo siyudad to Tiro dow Sidon. ");
INSERT INTO msmNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na, meyduon bohi no taga-duon no kona no Hibru su sakup sikandin to tribu to Canaan. Mig-anduon sikandin ki Jesus aw ikagi to maagbot, “Sir, Kaliwat ni Hari David, sadangay kae-ati a su to anak ku no bohi kanunoy ogsamukon to madoot no ispiritu no hilabi ogpaantus kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Di wada iikagi si Jesus. Dajun padani to mgo inanad din aw ikagi, “Masamuk sikan bohi no ogduma-duma ita. Payagujon ta buwa.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Dajun ikagi si Jesus, “Iyan da impaandini kanay to mgo kaliwat ni Israel, su angod sikandan to nayagak no mgo karneru.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Di sikan bohi nasi on migyuhud duon to atubangan ni Jesus aw pakimayuuy no mig-iling, “Sir, tabangi a man.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mig-iling si Jesus, “Kona no madojow ko agawon to koonon to mgo bata agun igtimbag diya to mgo idu.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“Iyan man iyan Sir,” kagi to sikan bohi, “di ngani man to idu, di ogpakapanginamut to mgo timu no ogkatanak ko ogkoon to mgo agayon dan.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Dajun ikagi si Jesus, “Pagkahogot to pagtuu nu, Iya! Na, ogtumanon ku sikan hangyu nu.” Duon-dajun migdojow to anak to sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Dajun panow si Jesus aw pauli diya to higad to danow to Galilea. Miggamat sikandin to bubungan aw ingkud duon. ");
INSERT INTO msmNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mahan-in hilabi to mgo otow no naman-anduon kandin no namandaya to mgo pulid, mgo buta, mgo pogkot, mgo poha, dow duma pad no mgo otow no mey sakit. Imbotang dan duon to atubangan ni Jesus aw pigpandojow din. ");
INSERT INTO msmNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pagkita to mgo otow to sikan, naboyong yagboy sikandan aw sajaa dan to Diyus to mgo kaliwat ni Israel. Su to mgo poha nakaikagi on aw to mgo pogkot migdojow on. To mgo pulid nakapanow on aw to mgo buta migkita on. ");
INSERT INTO msmNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dajun himuna ni Jesus to mgo inanad din aw ikagihi, “Ogkae-at a to seini mgo otow su tatoyu on no aedow dan kani aw wadad on ogkakoon dan. Kona ku sikandan ogpapanawon no ogbontason su unu ko hanipon duon to pangindaenan.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dajun usip to mgo inanad, “Na, andei ki kay ogpudut to pagkoon no igu igkapakoon to seini mahan-in no mgo otow kani to hilit?” ");
INSERT INTO msmNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Dajun usip si Jesus, “Pila no buuk to pan duon iyu?” Kagi dan, “Pitu, dow pila ubag no buuk no isda.” ");
INSERT INTO msmNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Dajun pamaingkuda ni Jesus sikan mgo otow duon to pasak. ");
INSERT INTO msmNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pigdawat din sikan pitu no buuk no pan dow sikan mgo isda aw pasalamat to Diyus. Dajun din panibaga sikan aw ibogoy diya to mgo inanad din agun ipamogoy diya to kaotawan. Mighan-in yagboy sikan pan dow isda, ");
INSERT INTO msmNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","kaling nakakoon sikandan tibo kotob no nangkahantoy. Tapus to pagkoon, pigpanghimun to mgo inanad to nasama, aw kaponu to pitu no ka baeknan! ");
INSERT INTO msmNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Upat no libu to mgo yukos no nakakoon wada yabot to kabujagan dow kabataan. ");
INSERT INTO msmNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tapus to sikan, pigpalikat ni Jesus sikan mgo otow. Dajun sikandin sakoy dow to mgo inanad din to bangka aw andiya to Magadan. ");
INSERT INTO msmNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na, meyduon mgo Pariseo dow Saduseo no mig-anduon ki Jesus su og-antihan dan. Pighangyu dan no mupakita sikandin to milagru no ogpakiyaya no Diyus to migpadae kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Di mig-iling si Jesus, “Ko ogyayahag to yangit to mahapun, og-iling kow to ogsoga kasem. ");
INSERT INTO msmNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ko ogyayahag to silatan aw ogkikibey to masem, og-iling kow to og-udan. Ogpakasabut kow to kadodoyog to panahon, di kona kow naan ogpakasabut to sikan ogpakiyaya to ogkangkahitabu kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pagkadoot now no mgo otow kuntoon! Migpadiyu kow to Diyus. Ogpamangha kow to milagru, di iyan da igkapakita iyu to angod to nahitabu ki Jonas.” Dajun ojowi ni Jesus sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Dajun yopa to danow si Jesus dow mgo inanad din, di nalingow to mgo inanad to pagdae to pan no ogbaawon dan podom. ");
INSERT INTO msmNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kagi ni Jesus, “Likoy kow to patubu to mgo Pariseo dow Saduseo.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Di to mgo inanad ni Jesus wada makasabut no kona no patubu to pan to ognangonon din, kaling mighahagas sikandan, “Basi naikagi din sikan su wada ki makadae to pan.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Namaanan ni Jesus to pighahagasan dan, kaling nangusip sikandin, “Nokoy no oghisgut kow man to pagkalingow now to pagdae to pan? E-ay, maintok pad naan to pagsalig now kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Wada kow gihapun makasabut? Angod to nalingawan now on to diya pagpakoon ku to lima no libu no mgo otow to lima da no buuk no pan. Pila man no ayat to diya nahimun now no sama? ");
INSERT INTO msmNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aw to diya pagpakoon ku to upat no libu no mgo otow to pitu da no buuk no pan, nalingawan now on isab to diya? Pila man no baeknan to diya nahimun now no sama? ");
INSERT INTO msmNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Di ogkaboyong a no wada kow makasabut no kona no pan to ognangonon ku ganina. Iyan impasabut ku no mulikoy kow to patubu to mgo Pariseo dow Saduseo.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Na, bali man no nakasabut to mgo inanad ni Jesus no kona no patubu to pan to ogpalikajan kandan, di sikan igpang-anad to mgo Pariseo dow Saduseo. ");
INSERT INTO msmNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pagtidow ni Jesus dow mgo inanad din duon to banwa no sakup to yunsud to Cesarea Filipo, pig-usip din sikandan, “Nokoy man to hona-hona to mgo otow kanay no Anak to Otow? Hintawa a kun man?” ");
INSERT INTO msmNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Migtabak to mgo inanad din, “Meyduon og-iling no si Juan ka no Magbawtismuhay. Meyduon isab og-iling no si Elias ka. To duma og-iling no si Jeremias ka ubin duma no otow no kibali ba-ba to Diyus to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Na sikiyu,” kagi ni Jesus, “nokoy man to ogkaikagi now bahin kanay? Hintawa a man?” ");
INSERT INTO msmNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Si Simon Pedro to migtabak, “Sikuna to diya Insaad no Manyuyuwas no Anak to buhi no Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kagi ni Jesus, “Madojow ka Pedro no anak ni Jonas, su kona no otow to migpasabut ikow to sikan, di to Diyus no Amoy ku diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na, indani seini. Sikuna si Pedro, no ko ita pa, batu. Na, kani to seini batu ogtukudon ku to simbahan ku no iyan igpasabut to ginsakupan ku. Kona sikandan ogkadaog to gahom to kamatajon. ");
INSERT INTO msmNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Igsalig ku ikow to mgo liyabi to gingharian to Diyus. To ig-ojow nu kani to babow to kalibutan iyan isab ig-ojow to Diyus. Aw to igtugut nu iyan isab igtugut to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Dajun bahoga ni Jesus to mgo inanad din no wada ognangonan dan no sikandin to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Duon sugud si Jesus to pagpasabut to mgo inanad to mgo antusonon din. Kagi din, “Kinahangyan no og-andiya a to siyudad to Jerusalem. Mahan-in to igpaantus kanay to inila no angod ta no mgo Hibru dow to yabow no mgo magdudumaya to tinuuhan ta hasta to mgo maistru to tinuuhan. Kinahangyan no himatajan a, di ogbanhawon a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pagdinog ni Pedro to sikan, impadiyu-diyu din si Jesus aw sapadi. “Hamug nu, Ginuu!” kagi din. “Kona gajod sikan ogkahitabu ikow!” ");
INSERT INTO msmNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Dajun atubanga ni Jesus si Pedro aw ikagihi, “Yaguji a Satanas! Ogtintalon a nu su pig-otawan to hona-hona nu, kona no kaning Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Dajun ikagihi ni Jesus to mgo inanad din, “Inggad hintawa no ogkaliyag ogpasakup kanay, kinahangyan no ojowan din to kagustuhon din aw tiang to krus din aw unung kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Su to otow no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay inggad igkamatoy din nasi ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Inggad pananglit maangkon to otow to tibo kadatu kani to kalibutan, nokoy man to pues din to sikan ko magawangan sikandin to kinabuhi aw makastigu to wada katapusan? Su wada yagboy inggad nokoy no yabow to kamahal kay to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Su siak no Anak to Otow, ogpauli a da dini to kalibutan. Ogkasul-uban a to kasiga dow gahom to Diyus no Amoy ku, aw ogduma to mgo anghil ku. Duon to sikan no panahon, ogbayosan ku to kada sobuuk pinasikad to nangkahinang din. ");
INSERT INTO msmNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ligdongi now seini. Meyduon duma kani iyu no monang da ogkamatoy ko siak no Anak to Otow maaha dan on no og-andini agun oghari.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na, pagyaboy to onom no aedow, pigduma ni Jesus si Pedro, si Santiago dow si Juan no suun ni Santiago. Migpapaawoy sikandan to paggamat to matikang no bubungan. ");
INSERT INTO msmNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","No duon on sikandan, pigkita dan no naisab si Jesus aw migsiga angod to sikan soga diya to yangit. To kabo din isab ogpakasilow yagboy to kaputi. ");
INSERT INTO msmNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na, puli nakatokow pigkita dan si Moises dow si Elias no migpaggilaung ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Dajun ikagi si Pedro, “Ginuu, madojow su kani ki. Ko maliyag ka, oghinang a to tatoyu no ka hoyunganan. Sobuuk to ikow, sobuuk to ki Moises dow sobuuk to ki Elias.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Dugaja pad mig-ikagi si Pedro, natuntun duon kandan to masiga no gabun. Meyduon kagi no napuun duon to sikan gabun no mig-iling, “Anak ku seini no pinadajag dow ingkalipay ku. Paminog kow kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pagdinog to mgo inanad to sikan, namakayangkob sikandan su pigdaitan. ");
INSERT INTO msmNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Di pigduguk ni Jesus aw dampaa. “Bangun kow,” kagi din. “Kona kow ogkahaedok.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pagyanghag dan, iyan nanda pigkita dan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na, pagtogbang dan to sikan bubungan, pigbahog sikandan ni Jesus no wada ognangonan dan to sikan pigkita dan kotob no sikandin no Anak to Otow kona pad mabanhaw. ");
INSERT INTO msmNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Dajun usip to mgo inanad, “Nokoy naan no nang-anad man to mgo maistru to tinuuhan ta no ayha ogyogwa to diya Insaad no Manyuyuwas ko una pad ogpauli si Elias dini to kalibutan?” ");
INSERT INTO msmNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Kagi ni Jesus, “Tinood iyan no og-andini si Elias su oghinaaton din to tibo. ");
INSERT INTO msmNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Di seini da. Mig-andinid sikandin di wada kiyayaha to mgo otow. Nasi no pigpaantus dan kotob to naliyagan dan. Angod isab to sikan to oghinangon dan kanay no Anak to Otow.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Na, bali man no nakasabut sikan mgo inanad no si Juan naan no Magbawtismuhay to ognangonon din. ");
INSERT INTO msmNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pagtidow onni Jesus diya to kaotawan, meyduon otow no migduguk kandin aw yuhud ");
INSERT INTO msmNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","no mig-iling, “Adoy Sir, sadangay kae-ati to anak ku no ogpukajon. Nadoot-doot yagboy sikandin su kanunoy ogpatisugba duon to kaeju dow ogpatibegbog diya to wohig. ");
INSERT INTO msmNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pigdae ku sikandin kani to mgo inanad nu, di wada dan kaulii.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kagi ni Jesus, “E-ay, sikiyu no mgo otow kuntoon, pagkabaliku now! Wada pagsalig now to Diyus. Andei man ogkakotob to pagpagduma ku iyu? Kagan-u man ogkatapus to pag-antus ku iyu? Na, daeha dini sikan bata.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Pagtidow to sikan bata duon, pig-abug ni Jesus sikan madoot no ispiritu. Na, migdojow dajun sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tapus to sikan, mig-anduon ki Jesus to mgo inanad din no sikandan da aw usip, “Nokoy no wada noy man kaabug to diya madoot no ispiritu?” ");
INSERT INTO msmNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Migtabak si Jesus, “Wada now kaabug su kuyang to pagtuu now. Su ligdongi now seini. Ko mey pagtuu now to Diyus inggad mae-binhi da to mustasa, ogkahimuan now to inggad nokoy. Ogpakasugu kow ngani to suja bubungan, ‘Kabalhin ka dutun,’ na, ogkabalhin iyan.” ");
INSERT INTO msmNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anoy man no mighihimun si Jesus dow mgo inanad din diya to Galilea, pig-ikagihan din sikandan, “Siak no Anak to Otow igdata diya to mgo otow ");
INSERT INTO msmNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","no oghimatoy kanay. Di ogbanhawon a da duon to ikatoyu no aedow.” Sikan no kagi ni Jesus ingkaguul yagboy to mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pagtidow onni Jesus duon to Capernaum, meyduon migsukut to saepi no igbogoy diya to Bayoy to Diyus. Pig-usip dan si Pedro, “Ogbogoy buwa to agayon now to saepi duon to Bayoy to Diyus?” ");
INSERT INTO msmNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Gobay,” kagi ni Pedro. Pagpauli ni Pedro diya to bayoy, nakauna si Jesus to pag-ikagi, “Simon, nokoy man to hona-hona nu to seini? Hintawa man to ogsukutan to buhis to mgo hari kani to babow to kalibutan? To mgo anak dan ubin mgo hangilid?” ");
INSERT INTO msmNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Migtabak si Pedro, “Mgo hangilid.” “Na,” kagi ni Jesus, “kona naan ogpabajadon to mgo anak dan. ");
INSERT INTO msmNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Di kona no madojow ko madootan sikandan ita. Kaling andiya ka to danow aw pamingwit ka. Wangata to ba-ba to una no isda no ogkabingwitan nu su meyduon saepi duon. Puduta sikan aw ibajad to sikan ogsukuton dan ita no daduwa.” ");
INSERT INTO msmNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","To diya no panahon, to mgo inanad ni Jesus mig-anduon kandin aw usip, “Hintawa man to ogyabow duon to sikan ogharian to Diyus?” ");
INSERT INTO msmNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Dajun sabi si Jesus to bata aw patindoga duon to kabaknaan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Kagi ni Jesus, “Paminog kow. Ko kona now isabon to kinaiya now aw kaangod to bata, kona kow gajod ogkasakup duon to ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaling inggad hintawa no ogpaobos angod to seini bata iyan ogyabow duon to ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inggad hintawa isab no ogdawat to sakup ku no angod to seini bata su sakup ku man sikan ogdawaton, kibali siak to pigdawat.” ");
INSERT INTO msmNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“To otow no ogpakaamung to pagpakasae to obos no sakup ku no angod to seini bata, mabog-at yagboy to kastigu no igpahamtang kandin. Tapat pad ko pigteybatuhan sikandin to mae-gatung no galingan no batu aw tabuga diya to dagat agun wada ogpakasae tongod kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ay, kae-at to kaotawan su og-abuton sikandan to mgo pagtintal! Sikan to ingkaanat kani to kalibutan, di alaot sikan ogpanintal. ");
INSERT INTO msmNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ko sikan boyad ubin kobong nu iyan ogpakaamung to pagpakasae nu, tampoda aw itimbag. Inggad pupue ka basta maangkon nu to kinabuhi no wada katapusan kuntra ko daduwa to boyad dow kobong nu no igsugba ka diya to kaeju no wada pagkaposok. ");
INSERT INTO msmNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ko sikan mata nu iyan ogpakaamung to pagpakasae nu, yugita aw itimbag. Inggad sobuuk nanda to mata nu basta ogpakaangkon ka to kinabuhi no wada katapusan kuntra ko daduwa to mata nu no igsugba ka diya to kaeju no impernu.” ");
INSERT INTO msmNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Migpadajun si Jesus to pag-ikagi, “Bantoy kow no kona kow ogtamay to inggad sobuuk no obos no sakup ku. Su ognangonan ku sikiyu no to mgo anghil dan duma kanunoy to Amoy ku diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ko pananglitan mey otow no meyduon songo gatus no karneru aw makasuwoy to sobuuk, nokoy buwa to oghinangon din? Og-ojowan din sikan kasiaman-mey-siam no nanabsab duon to bubungan su ogpamanghaon din sikan sobuuk no nakasuwoy. ");
INSERT INTO msmNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na, ko makitaan din, yabow to kalipay din to sikan sobuuk kay to diya kasiaman-mey-siam no wada makasuwoy. ");
INSERT INTO msmNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","To Diyus no Amoy now isab diya to yangit kona ogkaliyag no meyduon inggad sobuuk da no kinaobosan no otow no ogkayuwat kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Kagi isab ni Jesus, “Ko meyduon angod nu no magtutuu no makasae ikow, anduona sikandin aw ikagihi to sae din, di sikiyu da no daduwa. Ko mupaghusoy sikandin ikow, ogkauli to madojow no rilasyun. ");
INSERT INTO msmNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Di ko kona sikandin maminog ikow, paduma ka to sobuuk ubin daduwa no ka otow agun no matuman to kagi to Diyus duon to Kasuyatan no pig-iling, ‘Ko meyduon kasu, kinahangyan no kistigusan sikan to daduwa ubin tatoyu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Na, ko kona pad sikandin maminog, inangon sikan duon to ogkahimun no magtutuu. Ko kona gihapun sikandin mupaghusoy, na, kona kow on ogpagduma kandin. Nasi no ipag-angod now on to makasasaya no wada Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Indani seini. Inggad nokoy to ig-ojow now kani to babow to kalibutan iyan isab ig-ojow to Diyus. Aw to igtugut now iyan isab igtugut to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Tinood yagboy no ko meyduon daduwa iyu kani to babow to pasak no og-uujun to paghangyu to Diyus no Amoy ku diya to yangit to inggad nokoy, ogtumanon din. ");
INSERT INTO msmNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Inggad daduwa da ubin tatoyu no ka otow to ogkahimun tongod kanay, duma a dan duon.” ");
INSERT INTO msmNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dajun padani si Pedro ki Jesus aw usip, “Ginuu, kapila ku man ogpasayluhon to duma ku no ogpakasae kanay? Kapitu?” ");
INSERT INTO msmNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kagi ni Jesus, “Kona no kapitu da, di pitu no ka kapituan. ");
INSERT INTO msmNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Su to paghari to Diyus angod to seini. Meyduon hari no nanukut to utang to mgo suguonon din. ");
INSERT INTO msmNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iyan una no impadokat din to suguonon din no libu-libu to utang. ");
INSERT INTO msmNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na, manno kona sikandin ogpakabajad, migsugu sikan hari no ibaligja sikan suguonon yakip to asawa dow mgo anak din hasta tibo katigajunan dan aw paudipon sikandan agun mabajadan sikan utang. ");
INSERT INTO msmNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Di sikan otow migyuhud duon to atubangan to sikan hari aw pakimayuuy. Kagi din, ‘Sir, ajaw a naa ubag og-apuraha. Ogpamangha a pad agun makabajad a to tibo utang ku ikow.’ ");
INSERT INTO msmNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaling pigpapas to sikan hari to utang to sikan otow su pigkae-atan din, dajun din papanawa. ");
INSERT INTO msmNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Di pagyuwas to sikan suguonon, meyduon ingkatagbu din no angod din no nakautang kandin to maintok da. Dajun din gujuda dow pityoka aw ikagihi, ‘Bajad ka dajun to utang nu kanay!’ ");
INSERT INTO msmNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Dajun yuhud sikan otow aw pakimayuuy. Kagi din, ‘Ajaw a naa ubag og-apuraha. Ogpamangha a pad agun makabajad a ikow.’ ");
INSERT INTO msmNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Di wada din kae-ati sikan nakautang kandin, nasi no impaprisu din kotob no makabajad. ");
INSERT INTO msmNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pagkita to angod din no mgo suguonon to sikan nahitabu, nadootan hilabi sikandan. Dajun pamang-andiya to hari aw inangon sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Dajun ipadokat to hari sikan suguonon din aw ikagihi, ‘Pagkadoot nu! Pigpapas ku tibo to diya utang nu kanay su migpakimayuuy ka. ");
INSERT INTO msmNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na, nokoy no wada nu man isab kae-ati sikan angod nu no nakautang ikow?’ ");
INSERT INTO msmNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hilabi naboyu sikan hari, kaling migsugu no prisuhon sikan otow aw sakiton kotob no makabajad to tibo utang din. ");
INSERT INTO msmNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Na,” kagi ni Jesus, “angod isab to sikan to oghinangon iyu to Amoy ku diya to yangit ko kona kow ogpasaylu to bug-us no ginhawa to angod now no ogpakasae iyu.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na, tapus ikaanad ni Jesus sikan, miglikat sikandin to prubinsya to Galilea aw baja duon to dihipag to Jordan no wohig su og-andiya to prubinsya to Judea. ");
INSERT INTO msmNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mahan-in to mgo otow no migduma kandin, aw pigpang-ulian din to ogbation dan. ");
INSERT INTO msmNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Meyduon mgo Pariseo no mig-anduon ki Jesus su ogtogkadon dan. Mig-usip sikandan, “Igtugut to tinuuhan ta no ojowan to asawa to inggad nokoy da no ogkaamungan?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kagi ni Jesus, “Ajaw og-ilinga no wada kow makabasa duon to Kasuyatan to Diyus no to diya sinugdanan pighinang din to yukos dow bohi. ");
INSERT INTO msmNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mig-iling isab to Diyus, ‘Kaling man, ogyuwat to yukos to amoy dow inoy din aw ogpagsaboka to asawa din.’ ");
INSERT INTO msmNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Su sikandan no daduwa nasobuuk on man. Kaling man, sikan pigsaboka to Diyus kona ogpagbiyaon.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Dajun ikagi sikan mgo Pariseo, “Na, su kona man naan igtugut sikan, nokoy no mig-iling man si Moises no ogkahimu to otow to pag-ojow to asawa din basta bogajan din to kalig-onan to pagbiya?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Migtabak si Jesus, “Pigtugutan kow ni Moises tongod to kadoson to uyu now. Di sugud pad to sinugdanan, kona podom no sikan to planu to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Di seini da. To otow no og-ojow to asawa din no wada panghonay aw ogpangasawa to yain, kibali ogpakapanghonay sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kagi to mgo inanad ni Jesus, “Na, ko angod man to sikan to pagminyoan, tapat pad ko konad muminyo to otow.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Di mig-iling si Jesus, “Sikan pig-ikagi now no kona ogminyo, kona ogkadawat sikan to tibo. Iyan da ogpakadawat to sikan to diya tahan on pigpili to Diyus no kona ogminyo. ");
INSERT INTO msmNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Meyduon mgo otow no kona ogminyo su ingkabata dan no kona ogpakaminyo. To duma kona ogminyo su pigbakitan. Meyduon isab kona ogminyo agun no matibuyus to pagpang-anad dan bahin to paghari to Diyus. Inggad hintawa no ogpakatuman to seini, tumanon din.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na, mey mgo otow no migdaya to mgo anak dan duon ki Jesus agun sampoyongan din aw ampuan. Pagkita to mgo inanad ni Jesus, pigsapadan dan, ");
INSERT INTO msmNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","di mig-ikagi si Jesus, “Tuguti sikan mgo bata to pag-andini kanay. Kona now ogpogongan su iyan ogkaharian to Diyus to mgo otow no angod kandan.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dajun din sampoyongi sikan mgo bata aw dajun panow. ");
INSERT INTO msmNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na, meyduon otow no migduguk ki Jesus aw usip, “Sir, nokoy man to madojow no oghinangon ku agun maangkon ku to kinabuhi no wada katapusan?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kagi ni Jesus, “Hona-honaa sikan pig-ikagi nu no madojow a. Namaanan ta no Diyus da on to ogkailing no madojow. Na, ko ogkaliyag ka to kinabuhi no wada katapusan, tumana to mgo balaod din.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kagi to sikan otow, “Andei man to mgo balaod no ognangonon nu?” Kagi ni Jesus, “Kona ka oghimatoy to otow, kona ka ogpanghonay, kona ka ogpangawat, kona ka ogpangistigus to gayu, ");
INSERT INTO msmNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tahuda to amoy dow inoy nu, aw higugmaa to isigkaotow nu angod to paghigugma to kaugalingon nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kagi to sikan otow, “Natuman kud sikan tibo. Nokoy pad man to kuyang ku?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Kagi ni Jesus, “Ko maliyag ka no wadad kuyang to pagtuman nu to Diyus, ibaligja to mgo katigajunan nu aw to halin ipamogoy to mgo pubri. Na, meyduon ogkapaabut nu no bayos diya to yangit. Dajun ka pauli dini aw duma kad kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pagdinog to sikan otow to igpahinang ni Jesus kandin, migpanow sikandin no migsakit to ginhawa su madogi man yagboy to katigajunan din. ");
INSERT INTO msmNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Dajun ikagihi ni Jesus to mgo inanad din, “Tinood no malisod to sapian to pagpasakup to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Indani now seini. Ko malisod on man to kamel to pagyawang to yugi to dagum, iyan on man to sapian no otow ko kona malisodan to pagpasakup to sikan ogharian to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pagdinog to mgo inanad to sikan, hilabi sikandan naboyong, kaling namakaikagi, “Hintawa da man naan to ogkayuwas?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Migyongyong si Jesus kandan aw ikagi, “Kona seini ogkahimuan to otow, di tibo ogkahimuan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Dajun ikagi si Pedro, “Na sikami naan, pig-ojowan noy on to tibo su ogduma koy on ikow. Nokoy on man to igbayos kanami?” ");
INSERT INTO msmNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kagi ni Jesus, “Ligdongi now seini. Ko mabag-u on seini kalibutan, siak no Anak to Otow og-ingkud duon to trunu ku, aw ogkitaon to kasilow to pagka-Diyus ku. Sikan no panahon, sikiyu no migduma kanay og-ingkud isab duon to sampuyu-tag-duwa no mgo trunu to pagmandu to duma now no mgo kaliwat to diya sampuyu-tag-duwa no mgo anak ni Israel. ");
INSERT INTO msmNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inggad hintawa no og-ojow to bayoy din, mgo suun din no yukos dow bohi, amoy dow inoy din, mgo anak din ubin uma din tongod kanay, ogkadawat din to yabow pad yagboy duon to sikan ogpang-ojowan din. Ogbogajan isab sikandin to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Di mahan-in to mgo otow no yabow kuntoon no igpaobos. Mahan-in isab to obos no ogpayabawon.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kagi ni Jesus, “To paghari to Diyus angod isab to seini. Meyduon tag-iya to uma no pigtanoman to ubas. Songo aedow, migsoyom sikandin pagpamangha to mgo otow no ogpatrabahuon duon to sikan uma din. ");
INSERT INTO msmNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Migsasabut sikandan no ogbajadan din to nabatasan no suhue to songo aedow. Dajun paandiyaa sikandan to uma aw patrabahu-a. ");
INSERT INTO msmNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pagkaalas nuybe on, mig-andiya sikandin to merkadu aw migkita to mgo otow no migtitindogay no wada trabahu. ");
INSERT INTO msmNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kagi din, ‘Trabahu kow diya to uma ku. Ogsuhuyan ku sikiyu to hustu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dajun sikandan panow. Meyduon pigpatrabahu din no maugtu on aw pagkaalas tres isab. ");
INSERT INTO msmNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Anoy man no mgo alas singku on to kahapunon, meyduon isab pigkita din no mgo otow no wada trabahu. Pig-usip din sikandan, ‘Nokoy no magkahapun kow man og-uugpa?’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Migtabak sikandan, ‘Wada man ogpatrabahu kanami.’ Kagi to sikan tag-uma, ‘Trabahu kow isab diya to uma ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Anoy man no ogsayop on to soga, pig-ikagihan to sikan tag-uma to sinaligan din, ‘Tawaga sikan mgo otow no migtrabahu aw suhuyi. Unahi sikan nangkahudi ayha sikan namakauna.’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Na, to mgo otow no migsugud to pagtrabahu no mahapun on pigsuhuyan to songo aedow no trabahu. ");
INSERT INTO msmNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kaling sikan una no namantrabahu mig-iman no yabow to kandan suhue, di pigsuhuyan isab sikandan to songo aedow no trabahu. ");
INSERT INTO msmNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pagkadawat dan to suhue, pigbagutbutan dan sikan tag-uma. ");
INSERT INTO msmNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kagi dan, ‘Sikami no nahapunan no naboyad to soga to pagpaningkamot to trabahu impag-angod to pagsuhue to suja mgo otow no songo uras da to pagtrabahu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Di to sobuuk kandan pig-ikagihan to sikan tag-uma, ‘Yagi, wada ku man sikuna tuntuha. Migsasabut ki no ogbogajan ka to nabatasan no suhue to songo aedow no trabahu. ");
INSERT INTO msmNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na, dawata sikan suhue nu aw uli kad. Ogkaliyag a no sikan nangkahudi mabogajan to angod to nadawat nu. ");
INSERT INTO msmNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nokoy man, kona a ogpakaboot to saepi ku? Basi migsilag ka su bootan a!’ ");
INSERT INTO msmNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Kaling,” kagi ni Jesus, “mey panahon no to ogkahudi kuntoon ogpakauna, aw to ogpakauna kuntoon iyan nasi ogkahudi.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na, pagpadodoyog ni Jesus diya to Jerusalem, pighimun din sikan sampuyu-tag-duwa no mgo inanad din aw ikagihi, ");
INSERT INTO msmNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Oho, ogpatideg kinow on diya to Jerusalem. Ko diya kid on, siak no Anak to Otow igdata diya to mgo maistru to tinuuhan ta dow to yabow no mgo magdudumaya to tinuuhan. Oghukuman a dan to kamatajon ");
INSERT INTO msmNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aw igdata isab diya to mgo otow no kona no Hibru no wada tahud to Diyus. Ogpanyapdosan a dan aw hinanga no kangisihanan. Tapus to sikan, igyansang a dan duon to krus, di ogbanhawon a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Na, to asawa ni Sebedeo mig-anduon ki Jesus duma sikan daduwa no mgo anak din no mgo inanad ni Jesus. Migyuhud sikandin su meyduon oghangyuon din. ");
INSERT INTO msmNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kagi ni Jesus, “Honda, nokoy man to tuud nu?” Migtabak sikan bohi, “Ko mahimu, pasoingon nu ikow seini mgo anak ku ko muhari kad, sobuuk duon to kalintuu nu aw sobuuk duon to kawae.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Dajun ikagihi ni Jesus sikan daduwa no mgo inanad din, “Wada kow kamaan to sikan pighangyu now. Og-usipon ku sikiyu, ogpakaaguwanta kow buwa to mgo antusonon no ogkabajaan ku?” “Hoo,” kagi dan. ");
INSERT INTO msmNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Kagi ni Jesus, “Tinood man iyan no ogpakabaja kow to mangkalisod no ogbajaan ku, di bahin to pagsoing kanay, kona no siak to ogpakaboot dow hintawa to ogpaingkudon duon to kalintuu dow kawae ku. Iyan da ogpakasoing kanay to diya pighinaatan to Amoy ku to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pagdinog to sikan sampuyu no mgo inanad to hangyu to sikan daduwa no migsusuun, naboyu sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kaling pighimun sikandan ni Jesus aw ikagihi, “Namaan kow on to batasan to mgo otow no ogmandu to yain-yain no mgo tribu. Ogpamayabi-yabi sikandan to mgo sakup dan aw daog-daoga. ");
INSERT INTO msmNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Di kona kow ogpag-angod kandan. Nasi no inggad hintawa iyu no ogkaliyag ogyabow, mupaobos nasi sikandin aw alagad to duma. ");
INSERT INTO msmNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","To otow isab no ogkaliyag no mahinang no panguyu, mupaobos nasi sikandin angod to udipon aw alagad to duma ");
INSERT INTO msmNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","angod to pighinang ku iyu. Su ngani a man no Anak to Otow, di wada a andini agun alagadon. Nasi no iyan ing-andini ku to pag-alagad to duma aw agun mamatoy a to pagyokat to mahan-in no mgo otow no nangkaudipon to sae.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Anoy man no oglikat on si Jesus dow mgo inanad din to siyudad to Jerico, mahan-in to mgo otow no migduma kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na, meyduon daduwa no ka buta no mig-iingkud duon to kilid to dayan. Pagkadinog dan no ogbaja si Jesus, nanawag sikandan to maagbot, “Sir, Kaliwat ni Hari David, sadangay kae-ati koy!” ");
INSERT INTO msmNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pigsapadan sikandan to mahan-in no mgo otow agun ogpahonok, di nasi dan pigpak agbotan to pagtawag, “Sir, Kaliwat ni Hari David, sadangay kae-ati koy!” ");
INSERT INTO msmNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Dajun sigkon si Jesus to pagpanow aw sabiha sikan mgo buta. Kagi din, “Nokoy man to igpahinang now kanay?” ");
INSERT INTO msmNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Sir,” kagi dan, “ogkaliyag koy podom no ogkita koy on.” ");
INSERT INTO msmNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Migkae-at si Jesus kandan aw dampaa din to mgo mata dan. Duon-dajun migkita sikandan aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","No madani on sikandan to Jerusalem, naatubangan dan on to baryu to Betpahe no duon to bugdangan to Kaulibuhan no bubungan. Dajun sugu si Jesus to daduwa no mgo inanad din ");
INSERT INTO msmNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aw ikagihi, “Andutun kow to suja baryu. Ko mutidow kow duon, ogkita kow dajun to inhikot no asnu no mey nati. Hubada aw tujuka dini kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ko meyduon musagman iyu, ilingi now no ogkinahangyanon seini to Ginuu. Na, igpapudut dajun iyu sikan.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nailing to sikan agun matuman to pig-ikagi to diya kibali ba-ba to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Nangoni to mgo taga-Jerusalem, ‘Oho, ogtidow on suja hari now. Mapaobsanon sikandin no ogsakoy to nati no asnu.’” ");
INSERT INTO msmNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dajun panow sikan mgo inanad aw tumana sikan insugu ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Pigtujuk dan sikan asnu dow nati aw ihanig to ing-apid dan no kabo duon to talikudan to sikan. Dajun sakoy si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mahan-in hilabi to mgo otow no migbukyad isab to ing-apid dan no kabo aw ihanig duon to ogbajaan din. Aw to duma namanagkas to mgo dodohunan aw ihanig isab duon to dayan. ");
INSERT INTO msmNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","To mgo otow no migduma ki Jesus no duon to unahan dow duon to hudihan namanguliya, “Sajaon ta seini Kaliwat ni Hari David! Sajaon seini pigpaandini ita to Diyus! Sajaon yagboy to Diyus diya to yangit!” ");
INSERT INTO msmNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pagtidow ni Jesus diya to Jerusalem, naguliyang to tibo mgo otow duon aw migpauusipay, “Hintawa man sikan?” ");
INSERT INTO msmNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To mgo otow no migduma ki Jesus migtabak, “Si Jesus seini no kibali ba-ba to Diyus. Taga-Nazaret sikandin no sakup to Galilea.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pag-andiya ni Jesus to Bayoy to Diyus, meyduon pigkita din no namoli aw namaligja duon. Dajun din sikandan abuga. Aw pamaliskada din to mgo lamisa to mgo magsinsilyuhay to saepi dow mgo ingkudanan to sikan namaligja to salapati no ighalad. ");
INSERT INTO msmNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kagi ni Jesus kandan, “Meyduon impasuyat to Diyus no pig-iling, ‘To bayoy ku og-ilingon to ampuanan,’ di pighinang now no kampu to mgo tulisan!” ");
INSERT INTO msmNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","To mgo buta dow mgo pulid naman-andiya ki Jesus duon to Bayoy to Diyus, aw pigpangdojow din sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Di to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan nangaboyu no kitaon dan sikan mgo milagru ni Jesus dow sikan mgo bata duon to Bayoy to Diyus no namanguliya, “Sajaon ta seini Kaliwat ni Hari David!” ");
INSERT INTO msmNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kaling pig-usip dan si Jesus, “Nakadinog ka to kagi to sikan mgo bata?” Kagi ni Jesus, “Hoo, pigdinog ku. Di ajaw og-ilinga no wada now kabasa duon to Kasuyatan to Diyus sikan pig-iling, ‘Inggad to mangkaintok no mgo bata pig-anad nu to pagsaja ikow, Ginuu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Dajun panow si Jesus aw yuwas to siyudad su duon sikandin oghibat to Betania. ");
INSERT INTO msmNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pagkabukas, migsoyom si Jesus migpauli diya to Jerusalem. Duon pad to pangindaenan, pigbontas on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pagkita din to kaju no igera duon to kilid to dayan, pig-anduon din di wada pigkita din no bogas, mgo dohun da. Dajun din tubadi sikan igera, “Sugud kuntoon, kona kad ogpakabogas.” Na, nokoy ka man no migyanos dajun sikan igera. ");
INSERT INTO msmNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pagkita to mgo inanad ni Jesus to sikan, naboyong sikandan aw nakaikagi, “Naamonu man buwa no nadali yanos sei igera?” ");
INSERT INTO msmNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Kagi ni Jesus, “Indani now seini. Ko kona no duwa-duwa to pagtuu now to Diyus, ogpakahinang kow isab to sei pighinang ku to sikan igera. Aw kona no sikan da, su inggad suja bubungan ogsugut iyu ko suguon now, ‘Kayukat ka duon aw patiagdang ka dutun to dagat.’ ");
INSERT INTO msmNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ko ogsalig kow to Diyus, ogkadawat now to inggad nokoy no ogbujuon now no igpabaja to pag-ampu.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Migpauli si Jesus duon to Bayoy to Diyus aw pang-anad. Wada kayugoy mig-anduon kandin to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to inila no mgo duma dan aw usip, “Nokoy man to katongod nu to pagpanghinang to diya? Hintawa man to migbogoy ikow to sikan no katongod?” ");
INSERT INTO msmNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kagi ni Jesus, “Meyduon isab ig-usip ku iyu. Ko tabakon a now, ognangonan ku sikiyu dow nokoy to katongod ku to pagpanghinang to diya. ");
INSERT INTO msmNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na, to diya pagpamawtismu ni Juan, hintawa man to migbogoy kandin to sikan no katongod? Diyus ko otow?” Dajun sikandan sasabut dow og-amonuhon dan to pagtabak. Kagi dan, “Ko muiling ki no Diyus to migbogoy ki Juan to katongod, ogsukatan ki din dow nokoy no wada ki tuu ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aw ko muiling ki no pig-otawan to katongod din, ogkahaedok ki to kaotawan su migtuu man sikandan tibo no si Juan kibali ba-ba to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kaling iyan da intabak dan ki Jesus to, “Indoy, wada koy kamaan.” “Na,” kagi ni Jesus, “kona ku isab sikiyu ognangonan dow nokoy to katongod ku to pagpanghinang to diya.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kagi isab ni Jesus, “Nokoy man to hona-hona now to seini pananglitan ku? Mey otow no daduwa to anak no yukos. Kagi din to sikan panganoy, ‘Utu, trabahu ka kuntoon diya to uma.’ ");
INSERT INTO msmNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Migbalibad sikan panganoy, di pagkatogon-togon, naisab da to hona-hona din aw tumana din to insugu kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pigsugu isab sikan hadi to pagtrabahu diya to uma. Mighoo sikandin di wada tuman. ");
INSERT INTO msmNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na,” kagi ni Jesus, “hintawa man to sikan daduwa to migtuman to sugu to amoy dan?” Migtabak sikandan, “Sikan panganoy.” Kagi ni Jesus, “Ligdongi now seini. Inggad to matuntuhon no mgo magsukutay to buhis dow mgo buring ogpakauna iyu no mgo yabow to tinuuhan, su mahan-in on sikandan no migpasakup to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Su mig-andini si Juan no Magbawtismuhay aw anada kow dow og-amonuhon agun isipon to Diyus no wadad sae now, di wada kow tuu kandin. Di to mgo magsukutay to buhis dow mgo buring iyan nasi migtuu. Aw inggad pigkita now no migtuu sikandan, wada now gihapun isaba to hona-hona now aw tuu.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Paminog kow,” kagi ni Jesus, “su mey pad duma no pananglitan ku. Meyduon otow no migtanom to ubas duon to uma din. Piglibong din to kural aw hinangi to pogaanan to bogas to ubas dow turi no bantajanan. Tapus to sikan, pigpasaupan din aw panow diya to madiyu. ");
INSERT INTO msmNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Anoy man no oggunuon on to mgo ubas, migsugu sikan tag-iya to mgo suguonon din to pagpudut to kabahinan din. ");
INSERT INTO msmNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Di sikan mgo sinugu din ginona pigdakop to sikan mgo saup. To sobuuk pigbukbuk, to sobuuk pighimatajan, aw to sobuuk pigbatu dan isab kotob no namatoy. ");
INSERT INTO msmNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dajun sugu sikan tag-iya to mahan-in pad no mgo suguonon, di angod da to nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","To katapusan, iyan pigsugu to anak din su ginhawa din, ‘Ogtahudon dan man yagboy seini anak ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Di pagkita kandin to sikan mgo saup, mig-iling sikandan, ‘Suja anak to ogpakairinsya to seini ubasan ko mamatoy to amoy din. Na, oghimatajan ta isab agun ita on seini.’ ");
INSERT INTO msmNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dajun dan dakopa aw gujuda diya to yuwas to ubasan aw himataji. ");
INSERT INTO msmNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Na,” kagi ni Jesus, “ko mutidow sikan tag-iya, og-amonuhon din man sikan mgo saup?” ");
INSERT INTO msmNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Migtabak sikandan, “Makalilisang no kamatajon to igpahamtang din to sikan madoot no mgo otow. Pagkatapus, ogpasaupan din sikan ubasan to mgo otow no ogkasaligan agun bahinan sikandin ko tigbobogas on.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kagi ni Jesus, “Ajaw og-ilinga no wada kow makabasa to Kasuyatan to Diyus no pig-iling, ‘Sikan batu no pig-ojowan to mgo pandoy su nailing to boot dan no wada pues iyan nasi indigon to bayoy. Trabahu sikan to Ginuu aw igkatingaya ta yagboy.’ ");
INSERT INTO msmNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Kaling og-iling a iyu no kona kow on ogsakupon to Diyus duon to sikan ogharian din, nasi no iyan ogsakupon din to mgo otow no ogtuman yagboy kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pagdinog to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow mgo Pariseo to sikan mgo pananglitan ni Jesus, nasabutan dan no sikandan to pig-igu. ");
INSERT INTO msmNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kaling ogdakopon dan podom di nahaedok sikandan to mgo otow no naminog kandin, su migtuu sikandan no si Jesus, kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nang-anad si Jesus to duma no pananglitan. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“To paghari to Diyus ogkaangod to seini. Meyduon hari no mighinaat to kumbiti su ogminyo to anak din. ");
INSERT INTO msmNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pigsugu din to mgo suguonon to pagsuna to diya mgo inimbita din, di sikan mgo inimbita migbalibad. ");
INSERT INTO msmNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Dajun sugu-a to sikan hari to duma no mgo suguonon aw ikagihi, ‘Nangoni sikan mgo inimbita ku no naandam on to tibo. Namatansa on to mgo baka dow pinataba no mgo nati aw nayutu on. Kaling paandinihon on sikandan.’ ");
INSERT INTO msmNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Di sikan mgo inimbita wada pamanlipara. Nasi sikandan migpanow. Mey mig-andiya to uma, aw mey mig-atiman to nigusyu din. ");
INSERT INTO msmNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","To mgo duma namandakop to sikan mgo suguonon to hari aw paantusa ayha himataji. ");
INSERT INTO msmNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pagkataga to sikan hari, hilabi sikandin naboyu. Kaling impapuu to mgo sundayu din sikan namanhimatoy to mgo suguonon aw ipasangab to yunsud dan. ");
INSERT INTO msmNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tapus to sikan, pig-ikagihan to sikan hari to mgo suguonon din, ‘Nabotad on seini kumbiti, di to diya mgo inimbita ku kona no angajan og-andini. ");
INSERT INTO msmNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Na, andiya kow to karsada aw imbitaha to inggad hintawa no mabaekan now.’ ");
INSERT INTO msmNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dajun andiya sikan mgo suguonon to karsada aw pandaeha to tibo mgo otow no nabaekan dan no mangkadojow dow mangkadoot to batasan. Na, naponu to mgo otow sikan bayoy no pigkumbitihan. ");
INSERT INTO msmNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Di pagsed to sikan hari su og-abi-abihon din sikan mgo imbitadu, meyduon pigkita din no wada sul-ub to diya kabo no igpasul-ub to og-agpot to kumbitihan. ");
INSERT INTO msmNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kagi to sikan hari, ‘Yagi, pig-amonu nu man to pagsed kani no wada nu man kabo-a to diya angay kani to kumbitihan?’ Di wada ingkatabak to sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dajun sugu-a to sikan hari to mgo suguonon din, ‘Gapusa to boyad dow kobong din aw ibegbog diya to kadigyoman diya to yuwas. Ogpakadegmatoy to mgo otow duon aw ogkagot to ngipon dan.’ ");
INSERT INTO msmNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Na, mahan-in to mgo otow no ogtawagon to Diyus, di pipilahon da to ogkahinang no mgo sakup din.” ");
INSERT INTO msmNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dajun panow to mgo Pariseo su ogplanu dow og-amonuhon dan to pagbitik ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Migsugu sikandan to pila no mgo sakup dan dow sakup to partidu ni Hari Herodes diya ki Jesus. Kagi dan, “Sir, namaan koy no matinod-anon ka, aw matuud yagboy to igpang-anad nu bahin to pagtuman to Diyus. Inggad hintawa to igpag-atubang nu, pinag-angod nu to pagpang-anad kandan su wada ogpayabihon nu. ");
INSERT INTO msmNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Na, nokoy man to hona-hona nu to seini? Kona buwa no supak to tinuuhan ta to pagbajad to buhis diya to hari to Roma?” ");
INSERT INTO msmNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Di namaan si Jesus no madoot to tuud dan kaling mig-ikagi sikandin, “Kunungkun mgo diyusnon! Nokoy no og-antihan a now man? ");
INSERT INTO msmNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Na, ipakita kanay to saepi no babajaday to buhis.” Dajun dan itadwoy kandin to saepi. ");
INSERT INTO msmNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mig-usip si Jesus, “Hintawa man bayhu dow ngadan to nakabotang kani to seini?” ");
INSERT INTO msmNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kagi dan, “Kaning hari to Roma.” Kagi ni Jesus, “Na, ibogoy to hari to kaning hari, aw ibogoy isab to Diyus to kaning Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pagdinog dan to sikan, hilabi sikandan natingaya aw dajun panow. ");
INSERT INTO msmNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sikan no aedow meyduon isab mgo Saduseo no mig-anduon ki Jesus su ogpangusip. Na, sikan no mgo otawa naman-iling no kona ogkabanhaw to mgo patoy. Kagi dan ki Jesus, ");
INSERT INTO msmNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sir, mig-iling to balaod no imbilin ni Moises no ko mamatoy to otow no ogkabilin to asawa no wada pad anak, kinahangyan asawahon to suun din sikan bohi agun meyduon ogkailing no liwat to diya namatoy. ");
INSERT INTO msmNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Na, igpananglit ta to pitu no migsusuun no mgo yukos kani kanami. Naminyo sikan panganoy, di wada pad anak dan, namatoy on sikandin. Kaling pig-asawa to hadi din sikan bohi no nabayu, ");
INSERT INTO msmNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","di namatoy isab sikandin no wada pad anak. Angod isab to nahitabu to sikan ikatoyu. Na, yaktod no pagkaikagi, sikan pitu no migsusuun tibo nakaasawa to sikan bohi aw tibo sikandan namatoy no wada anak. ");
INSERT INTO msmNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","To katapusan, namatoy isab sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Na, ojow nu pa, ogbanhawon to mgo patoy. Ko matuman on sikan, hintawa man yagboy to sikan pitu to ogkatawag no tag-asawa to sikan bohi, su tibo man sikandan nakaasawa kandin?” ");
INSERT INTO msmNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Migtabak si Jesus, “Pagkasajop now yagboy! Su wada kow makasabut to Kasuyatan to Diyus dow to gahom din. ");
INSERT INTO msmNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Su ko banhawon on to mgo patoy, wadad on og-inasawahay, su ogkaangod on man sikandan to mgo anghil diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Na, sikiyu no kona ogtuu no ogkabanhaw to mgo patoy, ajaw og-ilinga no wada kow makabasa to kagi to Diyus iyu duon to Kasuyatan din no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Siak no Diyus iyan ogsimbahon ni Abraham, ni Isaac dow ni Jacob.’ Migpasabut no inggad nayugoy da kamatoy sikan no mgo otow, buhi gihapun sikandan diya to yangit su ogpadajun man to pagsimba to Diyus. Su to mgo patoy konad ogsimba to Diyus, mgo buhi da.” ");
INSERT INTO msmNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pagdinog to kaotawan to sikan no pagpang-anad ni Jesus, naboyong yagboy sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pagkamaan to mgo Pariseo no wada ingkatabak to sikan mgo Saduseo ki Jesus, mighihimun dajun sikandan aw andiya isab ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sobuuk kandan no maistru to tinuuhan mig-anti ki Jesus, ");
INSERT INTO msmNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Sir, duon to sikan tibo mgo balaod to Diyus, andei man to pinakaimpurtanti?” ");
INSERT INTO msmNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Migtabak si Jesus, “Seini: ‘Higugmaa to Ginuu no Diyus nu to bug-us no ginhawa dow hona-hona nu aw tibuuk no kinabuhi nu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sikan to pinakaimpurtanti no sugu. ");
INSERT INTO msmNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","To ikaduwa no pinakaimpurtanti ogpakaangod to sikan su pig-iling, ‘Higugmaa to isigkaotow nu angod to paghigugma to kaugalingon nu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Migsikad duon to sikan daduwa no mgo sugu to tibo mgo balaod no impabaja ki Moises dow to tibo impang-anad to diya kibali mgo ba-ba to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pig-ikagihan ni Jesus sikan mgo Pariseo no nahimun, ");
INSERT INTO msmNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Og-usip a iyu bahin to diya Insaad no Manyuyuwas. Hintawa man sikandin no kaliwat?” Kagi dan, “Kaliwat ni Hari David.” ");
INSERT INTO msmNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","“Na,” kagi ni Jesus, “ko mailing to sikan, nokoy no mig-iling man si David no Ginuu din sikan Insaad no Manyuyuwas? Su si David no minanduan to Ispiritu Santu iyan man yagboy mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘To Ginuu no Agayon ku pig-ikagihan to Diyus, Ingkud ka kani to kalintuu no takidingan ku kotob no daogon ku yagboy to mgo kuntra nu aw makayuhud duon to atubangan nu.’” ");
INSERT INTO msmNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Kagi ni Jesus, “Manno Agayon to intawag ni David to sikan Insaad no Manyuyuwas, nokoy no ogkailing man no kaliwat puli sikandin ni David?” ");
INSERT INTO msmNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Di wada nakatabak kandin. Aw sugud to diya no aedow, wadad nakayangub to pagpangusip kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dajun ikagihi ni Jesus to mgo inanad din dow sikan mahan-in no mgo otow no nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kagi din, “To mgo maistru to tinuuhan ta dow mgo Pariseo iyan sinaligan to pagpang-anad to mgo balaod to Diyus no imbilin ita ni Moises. ");
INSERT INTO msmNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kaling tumana to inggad nokoy no ig-anad dan iyu. Di kona kow ogpagsunud to mgo hinang dan, su to pamatasan dan kona ogpakasibu to sikan igpang-anad dan. ");
INSERT INTO msmNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ogpabog-atan dan to mgo otow to mgo sugu no mangkalisod ogtumanon. Angod sikandan to otow no ogpogos to duma to pagbaba to mabog-at, di sikandan, puli igkayoy to mgo boyad dan. ");
INSERT INTO msmNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“To tibo mgo hinang dan pagpakita-kita puli to kaotawan. Ogyow-agon dan sikan sedanan to mgo kagi to Diyus no igbogkot duon to goja dow bokton dan. Oghabaon dan isab to mgo jawing-jawing duon to mgo kabo dan agun ilingon no diyusnon yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ko duon sikandan to pagkoonan ubin simbahan, ogkaliyag sikandan og-ingkud duon to ingkudanan no ighinaat to mgo inila. ");
INSERT INTO msmNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ogtukhow sikandan ko tawagon to maistru aw ko pakitaon to pagtahud duon to karsada. ");
INSERT INTO msmNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Di sikiyu, kona kow ogpatawag to maistru, su migsusuun kow tibo aw sobuuk da to Maistru now. ");
INSERT INTO msmNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kona kow isab ogpakiamay to inggad hintawa kani to babow to pasak, su sobuuk da to Amoy now, sikan da Diyus diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kona kow isab ogpatawag to agayon su siak no Insaad no Manyuyuwas iyan da Agayon now. ");
INSERT INTO msmNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inggad hintawa iyu no ogkaliyag ogyabow, mupaobos nasi sikandin aw alagad to duma. ");
INSERT INTO msmNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Su to otow no ogpayabow nasi igpaobos, di to ogpaobos nasi ogpayabawon.” ");
INSERT INTO msmNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Su ogbaebagan now to mgo otow no ogpasakup podom duon to ogharian to Diyus. Iyan ogkaangodan now to otow no kona ogkaliyag ogsed to bayoy, aw kona now isab ogpasedon to duma no ogkaliyag ogsed. ");
INSERT INTO msmNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Ogpaahot kow to pagpanow to madiyu agun masakup now to inggad sobuuk da no otow. Aw ko masakup now on, ogyabow pad duon iyu to pagkaimpernu din tongod to ig-anad now kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Alaot kow su angod kow to mgo buta no ogpikit to duma no otow. Su og-iling kow no ko ogsaad to otow aw igsapa din seini Bayoy to Diyus, ogkahimu inggad kona din tumanon sikan. Di og-iling kow isab no ko iyan igsapa din sikan buyawan kani to Bayoy to Diyus, tumanon din yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Pagkayangog now! Andei man to yabow, sikan buyawan ko seini Bayoy to Diyus no iyan nakabalaan to sikan buyawan? ");
INSERT INTO msmNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Og-iling kow isab no ko ogsaad to otow aw igsapa din sikan haladanan, ogkahimu inggad kona din tumanon sikan. Di ojow now pa, ko iyan igsapa din sikan halad no nakabotang duon, tumanon din yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pagkabuta now! Andei man to yabow, sikan halad ko sikan haladanan no iyan nakabalaan to sikan halad? ");
INSERT INTO msmNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kaling man ko ipanapa to otow sikan haladanan, ogkayakip sikan tibo nakabotang duon. ");
INSERT INTO msmNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ko ipanapa isab to otow seini Bayoy to Diyus, ogkayakip isab to Diyus no mig-ugpa kani. ");
INSERT INTO msmNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aw ko ipanapa to otow to yangit, kibali igpanapa din to trunu to Diyus yakip on isab to Diyus no mig-ingkud duon. ");
INSERT INTO msmNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Su ogtuman kow iyan to pagbogoy to Diyus to ikasampuyu no bahin to pinangitaan now inggad to mgo aanagay. Di ogpabay-anan now to pinakaimpurtanti no impang-anad duon to mgo balaod to Diyus no iyan to hustisya, to pagkae-at, dow to pagkamatinumanon. Madojow hinuun to pagbogoy to ikasampuyu no bahin to pinangitaan now, di ajaw ogpabay-ani sikan yabow no impurtanti. ");
INSERT INTO msmNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mgo buta kow no ogpikit to duma no otow! Ogpaningkamotan now to pagtuman to mgo tumanon no kona da hilabi no impurtanti, di sikan pinakaimpurtanti ogpabay-anan now. Angod kow to ogsagey to inomon agun kona kow makainom to yamut-yamut, di iyan nasi ogkayam-od now to kamel! ");
INSERT INTO msmNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Ogkaangod kow to tasa dow kalduhan no iyan da nahugasan to yuwas di maligsom duon to sed. Su ogtuman kow to mgo tumanon to tinuuhan ta, di iyan da nakased duon to hona-hona now to kayupig dow kahakog. ");
INSERT INTO msmNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mgo buta kow yagboy no mgo Pariseo! Unaha deyjawa to hona-hona now agun ogdojow isab to mgo hinang now. ");
INSERT INTO msmNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Su angod kow to mgo yobong no pigpinturahan to maputi. Madojow iyan og-ahaon to yuwas di duon to sed, bokog to patoy no otow dow duma no mangkaligsom. ");
INSERT INTO msmNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Su ko og-ahaon kow to otow, angod to matarong kow, di iyan da nakased to hona-hona now to pagpatitinood dow kadoot. ");
INSERT INTO msmNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Alaot kow no mgo maistru to tinuuhan ta dow mgo Pariseo no kunungkun mgo diyusnon! Oghinangan now to mangkadojow no pinajag to mgo yobong to diya kibali mgo ba-ba to Diyus, aw ogbuyak-buyakan now to mgo yobong to diya diyusnon no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Og-iling kow no ko duma kow pa podom to mgo kaaw-apuan now, kona kow og-ibak to pagpanghimatoy dan to diya kibali mgo ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Di duon to sikan, kibali og-angkon kow no mgo kaliwat kow to diya nanghimatoy kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Na hala, padajuna now aw tapusa to trabahu to diya mgo kaaw-apuan now! ");
INSERT INTO msmNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Sikiyu no angod to mgo hayas, kona kow yagboy ogpakalikoy to kastigu diya to impernu. ");
INSERT INTO msmNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kaling mey pad mgo otow no ogpaandinihon ku iyu. Meyduon kibali mgo ba-ba to Diyus, meyduon maalamon no mgo otow, aw mey duma no ogpang-anad to kagi din. Di ogpaantuson now sikandan. Ogpanghimatajan now to duma, aw to duma igpanyansang now duon to krus. Meyduon isab ogpanyapdosan now duon to mgo simbahan now aw ogyupug-yupugon inggad andei ogdeg. ");
INSERT INTO msmNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sikan iyan to oghinangon now agun no sikiyu to ogsukutan to kamatajon to diya tibo diyusnon no mgo otow sugud ki Abel kotob ki Zacarias no anak ni Beraquias no duon himataji to pagtongaan to seini Bayoy to Diyus dow sikan haladanan. ");
INSERT INTO msmNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Indani now seini. Sikiyu no mgo otow kuntoon iyan ogsukutan to pagpanghimatoy dan to diya matarong no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Ay, sikiyu no taga-Jerusalem! Ogpanghimatajan now to kibali mgo ba-ba to Diyus. Ogbatuhon now to ogpaandinihon din iyu kotob no mangkamatoy. Kona no kapila ku da podom sikiyu oghagokonon angod to mangunsuy no oghimun to mgo unsuy din su ogyokboan, di mig-ojow kow. ");
INSERT INTO msmNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaling og-ojowan kow to Diyus aw ogmingaw on seini ugpaanan now. ");
INSERT INTO msmNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Su ognangonan ku sikiyu no ko malius ad, kona a now on isab ogkitaon kotob to aedow no ogpakailing kow, ‘Sajaon ta seini pigpaandini to Ginuu no Diyus!’ ” ");
INSERT INTO msmNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Anoy man no migyuwas on si Jesus to Bayoy to Diyus su ogpanow, migduguk to mgo inanad din aw ikagihi sikandin, “Kadojow og-ahaon seini Bayoy to Diyus hasta seini nakalibong!” ");
INSERT INTO msmNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kagi ni Jesus, “Hoo, madojow iyan, di ligdongi now seini. Meyduon aedow no wada inggad sobuuk to sikan no mgo batu no inghinang to seini no ogkabilin duon to nabotangan, su ogtompagon tibo.” ");
INSERT INTO msmNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na, miggamat sikandan diya to Kaulibuhan no bubungan. Anoy man no nakaingkud on si Jesus, migduguk to mgo inanad din no sikandan da aw ikagi, “Nangoni koy kun dow kagan-u ogkatuman sikan ognangonon nu. Nokoy man to ogkakiyayahan noy no madani kad on ogpauli aw ogkatapus on to kalibutan?” ");
INSERT INTO msmNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Dajun sugud si Jesus to pag-anad kandan. Kagi din, “Bantoy kow no kona kow malimbungan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Su mahan-in to gayuon no ogyogwa no ogdae to ngadan ku. Og-angkon no sikandan kun to diya Insaad no Manyuyuwas, aw mahan-in to ogpamasuwajon dan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ogpakadinog kow to gera duon to dani now aw diya isab to kadiyuan, di kona kow ogkahaedok. Kinahangyan no mahitabu sikan, di kona pad no iyan katapusan to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ogpagigirahay to mgo nasyun dow mgo gingharian. Mahan-in to mgo banwa no og-abuton to maagbot no bontas dow tiyog. ");
INSERT INTO msmNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Di sikan tibo no mgo kalisod, sinugdanan pad puli, angod to bohi no og-anak no bag-u pad oghajodan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ogkuntrahon kow to tibo tongod to pagtuu now kanay. Ogdakopon kow aw idata duon to sikan ogpaantus dow oghimatoy iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Duon to sikan no panahon, mahan-in to ogtalikud to pagtuu dan kanay, dajun dan ogyuiban to duma dan no mgo sakup ku aw ogkuntrahon dan yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mahan-in to ogyogwa no kunungkun kibali ba-ba to Diyus, aw mahan-in to ogpamasuwajon dan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tongod to ogdugang pad no kadoot to kaotawan, mahan-in to ogkangkabahawan to gugma dan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Di to otow no kona ogyobad to pagtuu kanay hangtod to katapusan, sikandin to ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ig-una igpatangkap seini Madojow no Nawnangonon to paghari to Diyus agun ogkadinog to tibo mgo tribu kani to babow to kalibutan, ayha on og-abut to katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Migpadajun si Jesus to pag-ikagi, “Si Daniel no kibali ba-ba to Diyus to diya una mig-iling no meyduon pinakamaligsom no ogkuntrahon yagboy to Diyus no ogpandodoot. (Sikiyu no ogbasa to seini, panginsabuti now.) Na, ko kitaon now on sikan duon to Bayoy to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","to tibo otow kani to Judea mupakajabag pailing diya to kabubunganan aw hobong. ");
INSERT INTO msmNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","To otow no diya to yuwas to bayoy, ajaw on ogpaulia to pagpudut to inggad nokoy da. ");
INSERT INTO msmNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","To otow no diya to uma ajaw on isab ogpaulia to pagpudut to kabo din. ");
INSERT INTO msmNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kae-at to mgo magkabodos dow manggianak to sikan no panahon! ");
INSERT INTO msmNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kaling ampu kow no sikan no ogkahitabu kona makatapu to tinghagsiy ubin Aedow no Tigpahuway, su ogkalisodan kow yagboy to pagyaguy. ");
INSERT INTO msmNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Su to mgo antusonon to sikan no panahon pinakamalisod yagboy. Wada pad nakaangod to sikan to kalisod sugud no hinangon to kalibutan, aw wadad on ogpakaangod to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ko kona minusan to Diyus sikan no panahon, wada inggad sobuuk no otow no ogkabilin no buhi. Di tongod to inabin din no mgo otow, ogminusan din sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Duon to sikan no panahon ko mey og-ikagi iyu, ‘Oho, seinid to diya Insaad no Manyuyuwas’ ubin umiling no ‘Sujad sikandin,’ kona kow ogtuu. ");
INSERT INTO msmNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Su meyduon ogpamanyogwa no ogpatuu-tuu no sikandan kun to diya Insaad no Manyuyuwas, aw to duma ogpatuu-tuu no kibali ba-ba sikandan to Diyus. Ogpakita ngani sikandan to mgo milagru dow duma no mgo kabeynganan pagmatuud no sinugu sikandan to Diyus agun no ko mahimu pa, pamasuwajon dan inggad to mgo otow no inabin on to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na, ajaw now ogkalingawi no pigpatahanan kud sikiyu. ");
INSERT INTO msmNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kaling,” kagi ni Jesus, “ko meyduon og-iling, ‘Oho, dutun on sikandin to hilit,’ kona kow og-andiya. Aw ko meyduon og-iling, ‘Oho, duon sikandin to sed,’ kona kow isab ogtuu. ");
INSERT INTO msmNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Di siak no Anak to Otow, ko mupauli a dini to kalibutan, ogkamaanan to tibo su ogkaangod to kilat no oghinggawan ogkibyat aw ogkitaon diya to inggad andei.” ");
INSERT INTO msmNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Dajun ikagi si Jesus to ikagihonon, “Inggad andei to meyduon patoy, diya isab ogkatap-ung to mgo uwak. ");
INSERT INTO msmNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ko maliwas on sikan kahaedokanan no mgo hitabu,” kagi ni Jesus, “konad ogsiga to soga, aw to buyan konad isab ogkitaon. To mgo bituon ogkangkauyug, aw ogkangkahojong to tibo diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tapus to sikan, meyduon ogkitaon diya to yangit no ogpakiyaya no ogpauli ad on no Anak no Otow, kaling ogpakadegmatoy to tibo mgo tribu dini to pasak. Ogkonsad a dajun no ogsakoy to mgo panganud, aw ogkitaon dan to kasilow to pagka-Diyus ku. ");
INSERT INTO msmNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Dajun ogpatanugon to trumpita to maagbot, aw ogsuguon ku to mgo anghil ku to paghimun to inabin ku no mgo otow likat to pig-ugpaan dan diya to inggad andei no suyuk to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Na, paminog kow,” kagi ni Jesus, “su igpananglit ku to kaju no igera. Ko musugud on sikan to pagpanalingsing, ogkamaanan now no madani on ogguyabung. ");
INSERT INTO msmNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Angod isab to sikan, ko maaha now no ogkatuman on tibo sikan ognangonon ku, ogkamaanan now no madani ad ogpauli dini. ");
INSERT INTO msmNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ligdongi now seini. Kona pad ogkangkamatoy to tibo mgo otow kuntoon, ogkatuman on sikan tibo. ");
INSERT INTO msmNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","To yangit dow pasak ogkangkagawang da, di to kagi ku ogpabilin yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Wada namaan dow nokoy aedawa ubin urasa ogkatuman seini pig-ikagi ku, ngani man to mgo anghil diya to yangit aw siak no Anak to Amoy ku no Diyus di wada kataga, su sikandin da to namaan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ko mupauli ad on no Anak no Otow, iyan ogkaangodan to diya panahon ni Noe. ");
INSERT INTO msmNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Su no wada pad on ugubi to kalibutan, migpadajun puli to kaotawan to pagkoon, pag-inom dow pag-inasawahay kotob to aedow no migsed onsi Noe duon to sikan sakajan no og-ilingon to arka. ");
INSERT INTO msmNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wada dan kahona-hona-i dow nokoy to ogkahitabu hangtod no nasaaban sikandan to pag-ugub to kalibutan aw kangkatabug. Sikan to ogkaangodan ko siak no Anak to Otow mupauli on. ");
INSERT INTO msmNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Na, sikan no panahon,” kagi ni Jesus, “ogpagbugtion to tibo mgo otow su meyduon sakup ku, meyduon isab kona. Ko pananglitan meyduon daduwa no ka yukos no ogpamantrabahu diya to uma, sobuuk ogpuduton aw sobuuk ogbilinon. ");
INSERT INTO msmNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Angod isab ko meyduon daduwa no ka bohi no ogbubulig to paggaling, sobuuk ogpuduton aw sobuuk ogbilinon. ");
INSERT INTO msmNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaling pakaalistu kow, su kona now ogkatagahan to pagtidow ku no Ginuu now. ");
INSERT INTO msmNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Di seini da. Ko pananglitan ogkamaanan pa to tag-bayoy to igtidow to kawatan, ogpak bantoy sikandin agun kona makawat to mgo katigajunan din. ");
INSERT INTO msmNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kaling mangandam kow isab su siak no Anak to Otow, ogpauli a to panahon no kona now ogkatagahan.” ");
INSERT INTO msmNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kagi ni Jesus, “To suguonon no matinumanon dow ogkasaligan iyan ogsaligan to agayon to pagdumaya to panimayoy din ko mey panow din. Sikandin to ogbahin-bahin to pagkoon to angod din no mgo suguonon. ");
INSERT INTO msmNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Madojow sikan suguonon ko matuman din to insugu kandin, su ko makauli to agayon din ");
INSERT INTO msmNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ogkabogajan sikandin to katongod to pagdumaya to tibo katigajunan. ");
INSERT INTO msmNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Di ko madoot sikan suguonon, ogpakailing sikandin to, ‘Mayugoy pad buwa og-uli to kani agayon ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Dajun din ogpanaeposon to angod din no mgo suguonon aw iyan da hinang din to ogkoon dow og-inom duma to mgo barkada din. ");
INSERT INTO msmNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Na, ogkatokawan sikandin to pagtidow to agayon din ");
INSERT INTO msmNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","aw ogpahamtangan to wada ogpakaangod to kabog-at no kastigu. Dajun ogpaagpoton sikandin duon to mgo otow no ogpamatitinood duon to sikan banwa no ogpakadegmatoy to mgo otow aw ogkagot to ngipon dan.” ");
INSERT INTO msmNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kagi ni Jesus, “Ko musugud on to Diyus to paghari, ogkaangod to seini. Meyduon sampuyu no mgo daega no og-agpot to kumbiti. Yogob sikandan to soga no migpanow su ogduma to sikan banahon diya to kumbitihan. ");
INSERT INTO msmNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lima to sikan mgo daega maalamon, di to lima tongop to isip. ");
INSERT INTO msmNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sikan mgo tongop wada pamandae to yana no igdugang dan ko maimotan sikan soga dan. ");
INSERT INTO msmNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Di sikan maalamon namandae. ");
INSERT INTO msmNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na, su nayugoy man tidow sikan banahon, nalilipodong sikandan tibo, aw monok on no nangkalipodong on. ");
INSERT INTO msmNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Anoy man no tonga on to kadukiloman, mey nanawag no mig-iling, ‘Seinid on sei banahon! Dali kow su ogduma ki!’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dajun makabuyat tibo sikan mgo daega aw hinaata to mgo soga dan. ");
INSERT INTO msmNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kagi to sikan mgo tongop, ‘Bogaji koy man to yana now su ogkaposok on seini mgo soga noy.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Di migtabak sikan mgo maalamon, ‘Eh kona, su unu ko ma-aeng-aengan kinow tibo. Andiya kow nasi to tindahan aw boli kow.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Dajun panow sikan mgo tongop su ogboli to yana. Pagkalius dan on, migtidow sikan banahon. Sikan mgo daega no andam to pagtagbu kandin nakaduma duon to bayoy no ogkumbitihan, dajun sirahi. ");
INSERT INTO msmNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Wada kayugoy migtidow to diya duma no mgo daega aw panabi, ‘Sir, abrihi koy man!’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Di sikan banahon migtabak, ‘Eh, wada yabot ku iyu.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Kaling,” kagi ni Jesus, “pakaalistu kow su kona now ogkatagahan dow nokoy aedawa ubin urasa to igpauli ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Kagi isab ni Jesus, “Ko mupauli a, to paghari to Diyus ogkaangod isab to seini. Meyduon otow no og-andiya to madiyu, kaling pighimun din to mgo suguonon din aw isalig kandan to saepi din. ");
INSERT INTO msmNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","To pagbogoy din kandan to saepi impasikad to abilidad dan. To sobuuk pigsaligan din to lima no libu, to sobuuk daduwa no libu aw sikan sobuuk songo libu da. Dajun panow sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sikan pigsaligan to lima no libu, ingnigusyu din dajun aw nakaganansya to lima no libu. ");
INSERT INTO msmNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Sikan pigsaligan to daduwa no libu nakaganansya isab to daduwa no libu. ");
INSERT INTO msmNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Di sikan pigsaligan to songo libu, ginona din inyobong duon to pasak sikan saepi to agayon din. ");
INSERT INTO msmNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Anoy man no nayugoy on, mig-uli sikan agayon. Dajun din usipa sikan mgo suguonon dow pig-amonu dan to diya saepi. ");
INSERT INTO msmNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sikan pigsaligan to lima no libu migduguk aw daeha sikan ganansya din. Kagi din, ‘Sir, pigsaligan a nu to lima no libu. Oho, lima no libu seini ganansya ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Kagi to sikan agayon, ‘Madojow sikan pighinang nu! Mabakas ka no suguonon aw ogkasaligan. Kuntoon, su ogkasaligan ka to maintok, ogsaligan ku sikuna to madogi. Na, andini ka aw apil ka to kalipay ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Migduguk isab sikan pigsaligan to daduwa no libu. ‘Sir,’ kagi din, ‘pigsaligan a nu to daduwa no libu. Oho, daduwa no libu seini ganansya ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Kagi to sikan agayon din, ‘Madojow sikan pighinang nu! Mabakas ka no suguonon aw ogkasaligan. Kuntoon, su ogkasaligan ka to maintok, ogsaligan ku sikuna to madogi. Na, andini ka aw apil ka to kalipay ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Na, sikan pigsaligan to songo libu migduguk aw ikagi, ‘Sir, namaan a no mayupigon ka. Og-ani ka man ngani to wada nu kaunagi to pag-odok, aw ogpamudut ka to wada nu itanom. ");
INSERT INTO msmNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nahaedok a ikow, kaling inyobong ku puli seini saepi nu. Oho, seini da.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Kagi to sikan agayon, ‘Adoy, kahukawon nud man! Wada pues nu no suguonon! Mig-iling ka no og-ani a to wada ku kaunagi aw ogpamudut a to wada ku itanom. ");
INSERT INTO msmNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Na, ko sikan to pighona-hona nu, nokoy no wada nu man ibangku sikan saepi ku agun ogtubu aw madogi to ogkadawat ku ko muuli a?’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Dajun din ikagihi to yain no suguonon, ‘Puduta sikan songo libu duon kandin aw ibogoy to sikan meyduon sampuyu no libu. ");
INSERT INTO msmNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Su to ogkasaligan ogdugangan agun ogdogi to kandin. Di to kona ogkasaligan, oghawion da inggad to maintok no insalig kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na, seini wada pues no suguonon itimbag diya to kadigyoman diya to yuwas. Ogpakadegmatoy to mgo otow duon aw ogkagot to ngipon dan.’” ");
INSERT INTO msmNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kagi ni Jesus, “Ko siak no Anak to Otow mupauli on, ogkitaon to kasilow to pagka-Diyus ku, aw ogdumahan a to tibo mgo anghil. Og-ingkud a duon to trunu ku to paghari. ");
INSERT INTO msmNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Oghimunon to kaotawan to tibo mgo tribu duon to atubangan ku, aw ogpagbugtion ku sikandan angod to mgo karneru dow mgo kanding no ogpagbugtion to magbantajay. ");
INSERT INTO msmNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","To mgo otow no impananglit to karneru igpakalintuu ku, aw sikan og-ilingon to kanding igpakawae ku. ");
INSERT INTO msmNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Na, siak no hari, og-ikagihan ku sikan mgo otow no impakalintuu ku, ‘Sikiyu no pigmadojawan to Diyus no Amoy ku, sed kow kani to seini gingharian ku, su tahan on seini ing-andam iyu sugud to sinugdanan to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Su no bontason a, pigpakoon a now, aw no uhawon a, pigpainom a now. No makayampot a duon iyu, pig-abi-abi a now duon to bayoy now, ");
INSERT INTO msmNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","aw pagkinahangyan ku to kabo, pigkaboan a now. No masakit a, pig-atiman a now, aw no maprisu a, pigyouy a now.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Og-usip sikan mgo otow no nadawat on to Diyus, ‘Ginuu, kagan-u koy man kita ikow no pigbontas dow pig-uhaw no pigpakoon dow pigpainom noy? ");
INSERT INTO msmNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kagan-u noy man sikuna abi-abiha duon to bayoy noy no makayampot ka, aw kagan-u ka isab panginahangyan to kabo no pigkaboan noy sikuna? ");
INSERT INTO msmNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kagan-u noy man sikuna youja su nasakit ka dow naprisu?’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Na, siakon no hari ogtabak, ‘Paminogi seini. Inggad nokoy no intabang now to obos da no mgo suun ku, kibali siak to pigtabangan now.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tapus to sikan, og-ikagihan ku sikan mgo otow no impakawae ku, ‘Yaguy kow kani, sikiyu no ogpahamtangan to kastigu. Andiya kow to sikan kaeju no wada pagkaposok no tahan on ing-andam ki Satanas dow sikan angod din no mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Su no bontason a, wada a now pakoona, aw no uhawon a, wada a now painoma. ");
INSERT INTO msmNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","No makayampot a duon iyu, wada a now abi-abiha duon to bayoy now. Pagkinahangyan ku to kabo, wada a now kabo-i. No masakit a aw maprisu, wada a now youja.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Og-usip isab sikandan, ‘Ginuu, kagan-u koy man kita ikow no pigbontas ubin pig-uhaw ubin migyampot diya kanami ubin wada kabo ubin nasakit ubin naprisu no wada noy sikuna tabangi?’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Na ogtabak a, ‘Ligdongi now seini. Ko wada now tabangi to obos da no mgo suun ku, kibali siak to wada now tabangi.’ ");
INSERT INTO msmNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tapus to sikan, ogpakaandiya sikandan to kastiguhanan no wada katapusan. Di sikan mgo otow no nadawat to Diyus ogbogajan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tapus ikaanad ni Jesus sikan tibo, pig-ikagihan din to mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Namaan kow on no Pista to Pagyaboy kun-isa. Duon to sikan no aedow, siak no Anak to Otow igdata diya to mgo otow no ogyansang kanay duon to krus.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na, to yabow no mgo magdudumaya to tinuuhan to mgo Hibru namanhimun duon to bayoy ni Caifas no panguyu dan hasta to inila no mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Migplanu sikandan dow og-amonuhon dan to pagdakop ki Jesus no wada ogkamaan su ogpahimatajan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Di kagi dan, “Kona ta igtapu to pista su basi magubut to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na, migbisita si Jesus diya to Betania duon to bayoy ni Simon no pigsangla di naulian on. ");
INSERT INTO msmNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Anoy man no namangoon on sikandan, meyduon bohi no migtidow no migdae to pahomut no mahal hilabi no intagu duon to mahalon no butilya. Migduguk sikandin ki Jesus aw ihudhud sikan pahomut duon to uyu din. ");
INSERT INTO msmNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pagkita to mgo inanad ni Jesus to sikan, naboyu sikandan. Kagi dan, “Abee! Nokoy no pig-uyakan man sikan pahomut? ");
INSERT INTO msmNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tapat pad ko imbaligja sikan to mahal no prisyu aw to halin ipamogoy to mgo pubri.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Namaanan ni Jesus sikan pighisgutan dan, kaling pig-ikagihan din sikandan, “Nokoy no ogsamukon now man seini bohi no madojow man seini pighinang din kanay? ");
INSERT INTO msmNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","To mgo pubri kanunoy now igpagduma, di siakon, kona a ogkayugoy dini iyu. ");
INSERT INTO msmNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Seini pagpahomut din kanay, angod to pighinaat din on to pagyobong kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Indani now seini,” kagi ni Jesus. “Inggad andei ignawnangon to Madojow no Nawnangonon kani to tibuuk kalibutan, ogkahisgutan isab seini pighinang din aw ogkahandom sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tapus to sikan, si Judas Iscariote no sobuuk to sikan sampuyu-tag-duwa no mgo inanad ni Jesus mig-andiya to yabow no mgo magdudumaya to tinuuhan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Kagi din, “Man-u man to igbogoy now kanay ko idata ku iyu si Jesus?” Dajun dan bilangi si Judas to katluan no buuk no saepi. ");
INSERT INTO msmNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tapus to sikan, nanginlugar sikandin to pagdata ki Jesus duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Anoy man no mig-abut on to una no aedow to Pista to Pan no Wada Patubu, to mgo inanad mig-usip ki Jesus, “Andei koy nu man ogpahikajon to panihapun ta to seini Pista to Pagyaboy?” ");
INSERT INTO msmNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Kagi ni Jesus, “Andiya kow to diya otow no ognangonon ku duon to siyudad. Nangoni sikandin no siak no maistru now ogpagsayu iyu no mgo inanad ku, su ogtumanon ta to Pista to Pagyaboy duon to bayoy din. Su kona ad ogyugoy kani to seini kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dajun tumana to sikan mgo inanad ni Jesus to sugu din aw hikaja to panihapun dan to pista. ");
INSERT INTO msmNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Anoy man no madukilom on, migdudunga to pagkoon si Jesus dow sikan mgo inanad din no sampuyu-tag-duwa. ");
INSERT INTO msmNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Pagkoon dan on, mig-ikagi si Jesus, “Oho, paminog kow. Sobuuk iyu kani ogyuib kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Migsakit yagboy to ginhawa dan aw kada sobuuk mig-usip, “Ginuu, kona no siak?” ");
INSERT INTO msmNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Migtabak si Jesus, “Sobuuk iyu no migpagsayu kanay to pagkoon iyan ogyuib kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Siak no Anak to Otow, oghimatajan a su tahan on nasuyat duon to Kasuyatan to Diyus. Di alaot yagboy sikan ogyuib kanay! Tapat pad ko inyandan sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Dajun usip si Judas no iyan ogyuib ki Jesus, “Kona no siak Sir?” Kagi ni Jesus, “Natuyanan nud iyan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","No migkoon pad sikandan, migdawat si Jesus to pan aw pasalamat sikandin to Diyus. Dajun din tibaga dow itadwoy kandan aw ikagi, “Yawa ku seini. Dawata now aw koona.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dajun dawat sikandin to tasa aw pasalamat isab to Diyus. Dajun din itadwoy kandan aw ikagi, “Masig-inom kow to seini. ");
INSERT INTO msmNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yangosa ku seini no igdigon to kasabutan no oghinangon to Diyus iyu. Igpaawas seini agun mapasaylu to mgo sae to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Indani now seini. Iyan nanda sei to pag-inom ku to gita to ubas dini. Ayha a da og-inom to sikan bag-u no inomon ko muinom a duma iyu diya to gingharian to Diyus no Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dajun sikandan pamanganta to pagsaja to Diyus aw panow pailing diya to Kaulibuhan no bubungan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pig-ikagihan ni Jesus to mgo inanad din, “Kuntoon no kadukiloman og-ojowan a now tibo, su meyduon sinuyat no kagi to Diyus no pig-iling, ‘Ogpahimatajan ku to magbantajay, aw ogkasusuwoy to mgo karneru no pigbantajan din.’ ");
INSERT INTO msmNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Di ko mabanhaw ad, og-una a iyu diya to Galilea.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Dajun ikagi si Pedro, “Inggad ojowan ka to seini tibo mgo duma ku, kona ku yagboy sikuna og-ojowan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kagi ni Jesus, “Indani seini. Kona pad ogtagauk to manuk gaja, iglidung a nud to katatoyu.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Di mig-iling si Pedro, “Kagan-u ku man sikuna ilidung, inggad pad i-unung a ikow ko himatajan ka!” Sikan isab to pig-ikagi to tibo mgo inanad. ");
INSERT INTO msmNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na, migpadajun onsi Jesus duon to sikan banwa no og-ilingon to Getsemane. Pagtidow dan duon, pig-ikagihan din to mgo inanad din, “Kani kow da ingkud su og-ampu a dutun.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Di pigduma din si Pedro dow sikan daduwa no mgo anak ni Sebedeo. Na, migsugud to hilabi no kaguul dow kasamuk to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Kagi ni Jesus, “Ahay, angod to igkamatoy ku to kani no kaguul ku! Pakamonang kow kani di kona kow oglipodong.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dajun andiya sikandin to unahan dow patiyangkob aw ampu. Kagi din, “Amoy ku, ko mahimu, ajaw a ogpabajaa to sikan no mgo antusonon. Di to pagboot nu iyan matuman, kona no sikan kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pagpauli din duon to mgo inanad din, pigkita din no nalipodong on sikandan. Dajun din pukawa no mig-iling, “Sadangay pad man iyu Pedro. Kona now ogkapogongan to lipodongon now inggad songo uras da? ");
INSERT INTO msmNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kona kow on oglipodong. Ampu kow nasi agun kona kow matintal. Ogtuman kow iyan podom, di mayotoy to yawa now.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Dajun isab panow si Jesus aw ampu. Kagi din, “Amoy ku, ko kinahangyan on man yagboy no ogbaja a to sikan no mgo antusonon, na, tumana to pagboot nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","To ikaduwa no pagpauli ni Jesus duon to mgo inanad din, pigkita din no nalipodong on isab sikandan su angod to ogpikpikon to mata dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Dajun panow si Jesus aw ampu to ikatoyu angod to diya una no pag-ampu din. ");
INSERT INTO msmNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pagkatapus, migpauli si Jesus duon kandan aw ikagihi, “Nalipodong kow pad gihapun? Oho, uras on no siak no Anak to Otow igdata on diya to mgo makasasaya. ");
INSERT INTO msmNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na, bangun kow on su seinid on to ogyuib kanay. Ogtagbuhon ta.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","No mig-ikagi pad si Jesus, migtidow si Judas no sobuuk to sikan sampuyu-tag-duwa no mgo inanad din. Mahan-in to mgo duma din no sangkap to ispada dow taepos. Pigsugu sikandan to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to inila no mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na, tahan on pigsabutan to oghinangon ni Judas agun makiyaya dan si Jesus. Kagi din, “Hadokan ku ngani, iyan kay. Na, dakopa sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kaling pigduguk din dajun si Jesus aw ikagihi, “Honda Sir!” Dajun din hadoki. ");
INSERT INTO msmNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kagi ni Jesus kandin, “Yagi, padajuna to tuud nu.” Dajun padani sikan duma no mgo otow aw dakopa si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dajun huyabut to ispada to sobuuk no duma ni Jesus aw tigbasa to suguonon to sikan kinayabawan no magdudumaya aw kasagping to talinga. ");
INSERT INTO msmNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Di kagi ni Jesus, “Isug-ub sikan ispada nu. Su to otow no ogpanigbas ogkamatoy isab to tigbas. ");
INSERT INTO msmNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Basi wada ka kamaan no ogpakadangop a to Diyus no Amoy ku, aw ogsuguon din dajun to linibu no mgo anghil to pagyuwas kanay. ");
INSERT INTO msmNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Di ko mailing to sikan, og-amonuhon man to pagkatuman to sikan impasuyat to Diyus no pig-iling no ogkahitabu seini?” ");
INSERT INTO msmNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dajun ikagihi ni Jesus sikan mgo otow, “Nokoy man, tulisan a no migdae kow man to mgo ispada dow mgo taepos to pagdakop kanay? Nokoy no wada a now man dakopa no mang-anad a duon to Bayoy to Diyus kada aedow? ");
INSERT INTO msmNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Di nailing to seini agun matuman to tibo no impasuyat to Diyus to diya kibali mgo ba-ba din.” Dajun yaguji si Jesus to mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dajun daeha si Jesus to sikan namandakop kandin diya to bayoy ni Caifas no kinayabawan no magdudumaya to tinuuhan to mgo Hibru. Tahan on nahimun duon to mgo maistru to tinuuhan dow inila no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Migpatiyupug si Pedro ki Jesus di migpadiyu da. Pagtidow din, migpadajun sikandin duon to pawa aw pag-agpot to mgo magbantajay no naman-ingkud su ogsayapan din to ogkadeygan ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sikan yabow no mgo magdudumaya to tinuuhan dow to duma dan no mgo maghusajay no nahimun duon namangha yagboy to ogpamangkistigus to gayu kuntra ki Jesus agun no mapahimatajan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mahan-in to mgo gayuon no namangistigus, di wada nakitaan dan no angay no igkamatoy din. Pagkahina-hina, meyduon daduwa no ka kistigus no mig-atubang ");
INSERT INTO msmNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","aw ikagi, “Pigdinog noy seini no otawa no mig-iling no ogkagoba din sikan Bayoy to Diyus aw og-isabon din oghinangon sed to tatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dajun tindog sikan kinayabawan no magdudumaya aw usipa si Jesus, “Nokoy man to ogkaikagi nu to sikan ingkistigus dan? Kona ka ogtabak?” ");
INSERT INTO msmNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Di migpapahonok si Jesus. Mig-ikagi isab sikan kinayabawan no magdudumaya, “Panapa ka tongod to ngadan to buhi no Diyus no tinood to og-ikagihon nu kanami. Na, nangoni koy dow sikuna iyan to diya ogpaabuton no Anak to Diyus no ogpaharion din.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Migtabak si Jesus, “Naikagi nud. Di seini da. Sugud kuntoon, ogkamaan kow no ogpasidonggan a no Anak to Otow su ogpaingkudon a duon to kalintuu no takidingan to Gamhanan no Diyus. Og-abut isab to panahon no ogkitaon a now no ogkonsad likat to yangit no ogsakoy to panganud.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dajun higbita to sikan kinayabawan no magdudumaya to kabo din tongod to kaboyu aw ikagi, “Ayiih! Pagpasipaya sikan to Diyus! Set ki pad man ogpamangha to kistigus no sikiyu on man yagboy to migdinog to pagpasipaya din to Diyus! ");
INSERT INTO msmNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Na, nokoy man to iyu?” Migtabak sikandan, “Angay sikandin oghimatajan.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dajun dan ilobi to bayhu ni Jesus aw sumbaga. To duma migsampalu kandin ");
INSERT INTO msmNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aw ikagihi, “Sikuna no Insaad no Manyuyuwas, tag-ana dow hintawa to migsampalu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mig-iingkud pad si Pedro duon to pawa no dugukon sikandin to suguonon no bohi aw ikagihi, “Aduy, duma ka isab ni Jesus no taga-Galilea!” ");
INSERT INTO msmNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Di miglidung si Pedro duon to atubangan to tibo. Kagi din, “Eh, wada kalibutan ku to sikan pig-ikagi nu.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Dajun panow si Pedro pailing duon to yawanganan. Mey yain no bohi duon no migkita kandin aw ikagihi din to mgo otow duon, “Seini no otawa duma ni Jesus no taga-Nazaret.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Di miglidung isab si Pedro aw nanapa no wada yagboy sikandin kiyaya to sikan no otow. ");
INSERT INTO msmNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Wada kayugoy, pigduguk si Pedro to sikan namanindog duon aw ikagihi, “Tinood iyan no duma ka dan, su to inikagihan nu ogpakiyaya no taga-Galilea ka.” ");
INSERT INTO msmNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dajun nanapa si Pedro to maagbot aw iling, “Wada a yagboy kiyaya to diya no otawa!” Duon-dajun migtagauk to manuk, ");
INSERT INTO msmNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","aw kadomdomi ni Pedro to diya kagi ni Jesus no pig-iling, “Kona pad ogtagauk to manuk, iglidung a nud to katatoyu.” Dajun panow si Pedro aw ngog-ngog tongod to hilabi no kasakit to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Saju pad to masem, mighihimun on isab tibo sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to inila no mgo duma dan aw planu dow og-amonuhon dan to pagpahimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dajun dan gapusa si Jesus aw daeha diya ki Gubernadur Pilato. ");
INSERT INTO msmNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na, si Judas no migyuib ki Jesus, pagkamaan din no pighukuman on si Jesus to kamatajon, migbasul sikandin. Dajun din i-uli sikan katluan no buuk no saepi duon to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow inila no mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kagi din, “Nakasae a yagboy su imbaligja ku to otow no wada sae.” Mig-iling sikandan, “Wadad yabot noy to sikan. Ikow on sikan no prublima.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Dajun itimbag ni Judas sikan saepi duon to Bayoy to Diyus dow panow aw hikoti to liog din aw patibitoy. ");
INSERT INTO msmNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pagpuduta to sikan yabow no mgo magdudumaya to sikan saepi, mig-iling sikandan, “Ogpakayapas ki to balaod to tinuuhan ta ko isakot seini duon to saepi no kaning Diyus, su insuhue seini to pagpahimatoy to otow.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kaling pig-uujunan dan no igboli sikan no saepi to pasak to maghinangay to kudon su oghinangon no yobonganan to mgo yampot. ");
INSERT INTO msmNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Hangtod kuntoon pighingadanan sikan to, “Pasak no Pigbajadan to Yangosa.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Duon to sikan, natuman to diya sinuyat ni Jeremias no kibali ba-ba to Diyus no pig-iling, “Ogpuduton dan sikan katluan no buuk no saepi no iyan ogkaujunan to mgo kaliwat ni Israel no igsuhue to sikan ogyuib kandin ");
INSERT INTO msmNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","aw igboli dan to pasak to maghinangay to kudon. Sikan to insugu to Diyus kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na, pag-atubang ni Jesus ki Gubernadur Pilato, pig-usip sikandin, “Sikuna iyan to hari to mgo Hibru?” Kagi ni Jesus, “Naikagi nud.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Di no iriklamu si Jesus to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow inila no mgo duma dan, wada sikandin tabak. ");
INSERT INTO msmNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kaling mig-ikagi si Pilato, “Mahan-in to inriklamu dan kuntra ikow. Kona ka ogpanagang?” ");
INSERT INTO msmNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Di wada yagboy inggad songo riklamu no pigtabak ni Jesus, kaling natingaya yagboy sikan gubernadur. ");
INSERT INTO msmNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na, kada Pista to Pagyaboy, nabatasan to sikan gubernadur no ogpasabukan din to songo prisu no iyan ogpilion to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","To diya no panahon meyduon bantugan no prisu no iyan ngadan si Barabas. ");
INSERT INTO msmNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kaling nangusip si Pilato to sikan mahan-in no mgo otow no nahimun, “Hintawa man to ogkaliyagan now no ogpasabukan ku, si Barabas ko si Jesus no og-ilingon to Insaad no Manyuyuwas?” ");
INSERT INTO msmNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ing-usip din sikan su namaanan din no indata kandin si Jesus to mgo panguyu to tinuuhan su migsilag sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","No mig-ingkud pad si Pilato duon to husajan, mig-abut to tugun to asawa din no pig-iling, “Kona ka ogpangindaehig to kamatajon to sikan otow no wada sae, su natagainop ku sikandin ganina madukilom, aw yagboy nasamuk to ginhawa ku.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Na, to kaotawan pighonghongan to diya yabow no mgo magdudumaya to tinuuhan dow inila no mgo Hibru agun si Barabas to sabukan, aw si Jesus himatajan. ");
INSERT INTO msmNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kaling pag-usip on isab ni Pilato dow hintawa to sikan daduwa to ogpasabukan dan, iyan intabak dan, “Si Barabas!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Kagi ni Pilato, “Og-amonuhon kud man naan si Jesus no og-ilingon to Insaad no Manyuyuwas?” Tibo sikandan mig-iling, “Himataji! Iyansang duon to krus!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mig-usip si Pilato, “Manya man? Nokoy man to sae din?” Di nasi mig-agbot to pagkinuliya dan no mig-iling, “Himataji! Iyansang duon to krus!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nasabut ni Pilato no wadad pues to pag-ikagi din su ogkagubut on to mgo otow. Kaling migpudut sikandin to wohig aw panghugas to boyad din duon to atubangan to mgo otow. Kagi din, “Ogpanghugas a pagpakiyaya no wada yabot ku to kamatajon to seini no otow. Sikiyu to yabotan to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Migtabak sikan tibo mgo otow, “Sikami dow mgo kaliwat noy to tadtadan to sikan!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Dajun pasabuki ni Pilato si Barabas. Di si Jesus pigpanyapdosan aw idata duon to sikan ogpamanyansang kandin duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Dajun daeha si Jesus to mgo sundayu ni Gubernadur Pilato duon to sed to bayoy din. Dajun dan himuna to tibo angod dan no mgo sundayu aw lilibongi si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pighukasan dan sikandin aw sul-ubi to mayogdog no kapa. ");
INSERT INTO msmNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mighinang isab sikandan to kuruna no dugihon no gawod aw ikuruna kandin. Meyduon isab tinampod no tigbow no pigpatagonan kandin duon to kalintuu no boyad din no kunungkun bastun to hari. Dajun sikandan yuhud-yuhud duon to atubangan din aw ngingisi. Kagi dan, “Mabuhi ka, hari to mgo Hibru!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tapus to sikan, pigpang-iloban dan si Jesus aw pinokpoka to sikan bastun din. ");
INSERT INTO msmNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pagtakahi dan to pag-inusiba ki Jesus, pighukasan dan sikandin to sikan mayogdog no kapa aw sul-ubi to kandin no kabo. Dajun dan daeha diya to yuwas su igyansang duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na, duon to pangindaenan meyduon ingkatagbu dan no taga-Cirene no iyan ngadan si Simon. Pigpogos dan sikandin to pagtiang to sikan krus no ogyansangan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Pagtidow dan duon to sikan banwa no og-ilingon to Golgota, no ko ita pa, Boboungon, ");
INSERT INTO msmNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","pigbogajan dan si Jesus to inomon no pigsakotan to mapoit. Di pagkatimtim din, wada din inoma. ");
INSERT INTO msmNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Dajun dan iyansang duon to krus aw lindoga. Tapus to sikan, pigbabahin dan to mgo kabo ni Jesus pinaagi to ripa. ");
INSERT INTO msmNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Dajun ingkud sikan mgo sundayu su ogbantoy kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Duon to babow to uyu ni Jesus intaud dan to sinuyat no riklamu kuntra kandin no pig-iling, “Si Jesus seini no Hari to mgo Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Meyduon isab daduwa no ka ribeldi no inyansang to mgo krus duon to magdibayuy ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","To mgo otow no namangyaboy duon migpajango-jango to pagsujan-sujan kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Awu!” kagi dan. “Kagi nu oggobaon nu sikan Bayoy to Diyus aw og-isabon nu oghinangon sed to tatoyu da no aedow. Oho, ko tinood no Anak ka to Diyus, yudus ka duon!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Angod isab to sikan to pagsujan-sujan to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow mgo maistru to tinuuhan hasta to duma no inila no mgo Hibru. Kagi dan, ");
INSERT INTO msmNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nakayuwas kun sikandin to duma, di kona din man naan ogkayuwas to kaugalingon din. Oho, hari ta man buwa sikandin no mgo kaliwat ni Israel, payudusa duon agun makatuu ki. ");
INSERT INTO msmNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kagi din Anak sikandin to Diyus dow iyan ogsaligan din. Na, ko og-oyogon sikandin to Diyus, ipayuwas sikandin!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Angod isab to sikan to pagtamay ki Jesus to sikan mgo ribeldi no inyansang isab duon to mgo krus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Anoy man no maugtu on, migdigyom to kalibutan hangtod no alas tres to kahapunon. ");
INSERT INTO msmNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na, pagkaalas tres on, migtawag si Jesus to maagbot no mig-iling, “Eli, eli, lama sabaktani?” no ko ita pa, “Diyus ku, Diyus ku, nokoy no pig-ojowan a nu?” ");
INSERT INTO msmNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Di to mgo otow no migtindog duon naman-iling, “Ogpatabang sikandin ki Elias.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na, sobuuk kandan miglinaguy dajun aw pudut to ogpasoyopan din to suka. Dajun din ihikot duon to tumuy to tinampod no tigbow aw itadwoy diya to ba-ba ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Di to duma mig-iling, “Og-ahaon ta iyan dow og-andini si Elias to pagyuwas kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nangiyak on isab si Jesus aw dajun kabigtawi. ");
INSERT INTO msmNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dajun kahigbit sikan madamey no panapton no yopon to sikan Pinakabalaan no Sinabong duon to Bayoy to Diyus likat diya to diatas pailing duon to obos. Migtiyog isab to maagbot aw nangkatibag to mgo gatung. ");
INSERT INTO msmNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nangkaabri isab to mgo yobong, aw mahan-in to patoy no diyusnon no nabanhaw ");
INSERT INTO msmNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","aw pamanyogwa duon to yobong. Na, pagkabanhaw on ni Jesus, sikan duma no nabanhaw naman-andiya to siyudad to Jerusalem, aw mahan-in to migkita kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na, sikan kapitan dow mgo sundayu din no namanbantoy ki Jesus pigdaitan tongod to tiyog dow sikan duma no mgo hitabu. Kaling nakaikagi sikandan, “Tinood naan no Anak seini to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Mahan-in isab to mgo bohi no migsayap ki Jesus, di migpadiyu da. Sikandan to diya migduma-duma kandin likat to Galilea pailing diya to Jerusalem to pag-alagad kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Yakip duon si Maria Magdalena dow to sangay din no inoy ni Santiago dow ni Jose hasta to asawa ni Sebedeo. ");
INSERT INTO msmNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Anoy man no mahapun on, meyduon migtidow no sapian no otow no taga-Arimatea no iyan ngadan si Jose. Songo inanad isab sikandin ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Mig-andiya si Jose ki Pilato aw hangyu no sikandin to ogyobong ki Jesus. Na, mig-ujun si Pilato. ");
INSERT INTO msmNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Dajun puduta ni Jose sikan yawa ni Jesus aw libodi to bag-u no madojow no panapton ");
INSERT INTO msmNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","aw ibotang duon to yobonganan no bag-u din pad ipabangbang duon to batu. Pigyoponan din sikan yobong to piglipid no gatung aw dajun panow. ");
INSERT INTO msmNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Si Maria Magdalena dow sikan sangay din naman-ingkud no mig-atubang to sikan yobong. ");
INSERT INTO msmNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pagkabukas no iyan Aedow no Tigpahuway to mgo Hibru, sikan yabow no mgo magdudumaya to tinuuhan dan dow mgo Pariseo mig-andiya ki Pilato. ");
INSERT INTO msmNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kagi dan, “Sir, nadomdoman noy no wada pad kamatoy to diya gayuon no otow, mig-iling no ogkabanhaw da sikandin duon to ikatoyu no aedow. ");
INSERT INTO msmNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kaling madojow ko ipadigon nu sikan yobong din kotob to ikatoyu no aedow, su unu ko kawaton to yawa din to sikan mgo inanad din agun igkanawnangon dan no nabanhaw on sikandin. Na, ogdugang pad to paglimbung dan to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Na hala,” kagi ni Pilato. “Daya kow to mgo sundayu aw ipadigon sikan yobong kotob to ogkahimu now.” ");
INSERT INTO msmNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Dajun sikandan andiya aw indani sikan inyopon agun matagahan dan ko meyduon oghilabot to sikan. Pagkatapus, pigpabantajan dan. ");
INSERT INTO msmNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pagyaboy to Aedow no Tigpahuway, aw ogkabukas-bukas on to aedow to Duminggu, si Maria Magdalena dow sikan sangay din migpadodoyog duon to pigyobongan ki Jesus su ogyoujon dan. ");
INSERT INTO msmNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","No wada pad sikandan tidow, migtiyog to maagbot aw migkonsad to anghil to Ginuu aw ligada sikan gatung no inyopon aw ingkud duon. ");
INSERT INTO msmNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","To bayhu din angod to kasiga to kilat, dow to kabo din angod to kaputi to gapas. ");
INSERT INTO msmNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Migpamidpid sikan namanbantoy tongod to haedok dan to sikan anghil aw katuad aw kaangod to mgo patoy. ");
INSERT INTO msmNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Dajun ikagihi to anghil sikan mgo bohi, “Kona kow ogkahaedok. Namaan a no ogpamangha kow ki Jesus no inyansang duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wadad kani su nabanhaw on. Natuman on to diya pig-ikagi din iyu. Dini kow, ahaa now seini pigbotangan kandin. ");
INSERT INTO msmNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Na, panow kow dajun diya to mgo inanad din aw nangoni no nabanhaw on si Jesus dow og-una diya to Galilea. Ogkitaon dan sikandin diya. Indani now seini pig-ikagi ku iyu.” ");
INSERT INTO msmNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na, sakot to kahaedok dow kalipay, migpanow sikan mgo bohi. Miglinaguy sikandan su ognangonan dan to mgo inanad ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Duon pad to pangindaenan, puli nakatokow ingkatagbu dan si Jesus. Kagi din, “Honda.” Dajun padani sikan mgo bohi aw tagoni to mgo kobong din dow simbaha dan. ");
INSERT INTO msmNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kagi ni Jesus, “Kona kow ogkahaedok. Andiya kow to mgo suun ku aw nangoni no umandiya sikandan to Galilea su ogkitaon a dan diya.” ");
INSERT INTO msmNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na, pagkalius to sikan mgo bohi duon to yobong, to duma no mgo sundayu no migbantoy mig-anduon to Jerusalem. Pignangonan dan to yabow no mgo magdudumaya to tinuuhan to mgo Hibru to tibo nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Migsasabut sikan yabow no mgo magdudumaya dow to inila no mgo Hibru. Dajun dan bogaji sikan mgo sundayu to madogi no saepi ");
INSERT INTO msmNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aw ikagihi, “Umiling kow no pigkawat to yawa ni Jesus to mgo inanad din no malipodong kow ganina madukilom. ");
INSERT INTO msmNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na, ko makadinog to gubernadur no nalipodong kow no migbantoy, kona kow ogkahaedok. Sikami on to ogkaamu kandin agun kona kow kastiguhon.” ");
INSERT INTO msmNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Dajun dawata to mgo sundayu sikan saepi aw inawnangon sikan impaikagi kandan. Sikan no isturya impatangkap diya to mgo Hibru hangtod kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sikan sampuyu-tag-isa no mgo inanad ni Jesus mig-andiya to Galilea duon to sikan bubungan no ogpaandiyaan ni Jesus kandan. ");
INSERT INTO msmNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Pagkita dan kandin, pigsimba dan, di to duma migduwa-duwa dow si Jesus yagboy sikan. ");
INSERT INTO msmNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Dajun padani si Jesus kandan aw ikagi, “Imbogoy kanay to tibo katongod diya to yangit dow dini to pasak. ");
INSERT INTO msmNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kaling ogsuguon ku sikiyu diya to tibo mgo tribu agun hinangon now sikandan no mgo inanad ku. Bawtismuhi sikandan to ngadan to Amoy, to Anak dow to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Anada sikandan to pagtuman to tibo insugu ku iyu. Na, ajaw now ogkalingawi no ogduma-duma a iyu kotob no kona pad matapus to kalibutan.”");
INSERT INTO msmNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Seini to sinugdanan to Madojow no Nawnangonon bahin ki Jesu-Cristo no Anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Meyduon pig-ikagi to Diyus kandin no impasuyat din ki Isaias no kibali ba-ba din no pig-iling, “Meyduon ogpaunahon ku ikow agun no mahinaat to mgo otow to pagtidow nu. ");
INSERT INTO msmNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ogdinogon sikandin no ogbansagon diya to matahay no banwa no og-iling, ‘Hinaata now to dayan to Ginuu! Andama to ginhawa now to pagtidow din!’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Natuman sikan intag-an ni Isaias su migtidow si Juan no Magbawtismuhay diya to matahay no banwa. Pigwalihan din to mgo otow no ogkahimun duon. Kagi din, “Sosey kow on. Talikudi now on to mgo sae now aw pabawtismu kow. Na, ogkapasaylu to mgo sae now.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mahan-in hilabi to mgo otow no naman-andiya ki Juan no napuun diya to prubinsya to Judea yakip to siyudad to Jerusalem. Pig-angkon dan to sae dan aw pabawtismu ki Juan duon to Jordan no wohig. ");
INSERT INTO msmNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na, to kabo ni Juan, hinaboyan no bubue to kamel, aw to bagkos din kindae to mananap. Iyan koonon din to taengas dow doga. ");
INSERT INTO msmNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Seini to kanunoy din pig-ikagi, “Meyduon ogpakasunu no yabow pad yagboy kanay. Su ngani man to paghukas to sapatus din, di kona a og-angajan. ");
INSERT INTO msmNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Wohig to igbawtismu ku iyu, di sikandin, iyan igbawtismu iyu to Ispiritu Santu.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Duon to sikan no panahon, natuman to diya intag-an ni Juan su migtidow si Jesus no napuun diya to yunsud to Nazaret no sakup to Galilea. Migpabawtismu sikandin ki Juan duon to Jordan no wohig. ");
INSERT INTO msmNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Anoy man no mighaw-as on sikandin, pigkita din no naabri to yangit, aw migkonsad to Ispiritu Santu no angod to salapati dow migtaphun duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Meyduon isab kagi no napuun diya to yangit no mig-iling, “Sikuna to pinadajag no Anak ku no ingkalipay ku yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dajun paandiyaa si Jesus to Ispiritu Santu to matahay no banwa no iyan da mig-ugpa ");
INSERT INTO msmNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","to mgo kadlaganon. Migpakamonang sikandin duon sed to kap-atan no aedow aw pigtintal ni Satanas. Di pig-atiman sikandin to mgo anghil. ");
INSERT INTO msmNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Anoy man no prisuhon on si Juan, migpauli si Jesus diya to prubinsya to Galilea aw inawnangon sikan Madojow no Nawnangonon to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kagi din, “Madani on ogkatuman to paghari to Diyus dini iyu. Na, sosey kow on aw talikudi now to mgo sae now, aw tuuhi seini Madojow no Nawnangonon.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Songo aedow, migyadgad si Jesus duon to higad to danow to Galilea. Duon din katae-i to daduwa no migsusuun no mgo mangisdaay no namukut. Iyan ngadan dan si Simon dow si Andres. ");
INSERT INTO msmNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Kagi ni Jesus, “Duma kow on kanay su oghinangon ku sikiyu no inanad. Su hangtod kuntoon, isda to nasakup to pukut now. Di sugud kuntoon, otow on to igpasakup ku iyu agun mahinang sikandan no mgo sakup ku.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Duon-dajun pig-ojowan dan to mgo pukut dan aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Anoy man no diyad on si Jesus to uunahan, natae-an din to yain no migsusuun no migtapid to mgo pukut duon to bangka duma to amoy dan no si Sebedeo. Iyan ngadan dan si Santiago dow si Juan. ");
INSERT INTO msmNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Duon-dajun pigsabi sikandan ni Jesus. Dajun dan likati to amoy dan dow mgo sinuhuyan no duon pad to sakajan, aw duma sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Dajun andiya onsi Jesus to yunsud to Capernaum. Pagka-Aedow on no Tigpahuway to mgo Hibru, migsed si Jesus duon to simbahan dan aw pang-anad. ");
INSERT INTO msmNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pagdinog to kaotawan kandin, hilabi sikandan natingaya su to pagpang-anad din kona no angod to pagpang-anad to mgo maistru to tinuuhan, su sikan ki Jesus migdae to katongod. ");
INSERT INTO msmNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na, mey otow duon to simbahan no pigsamuk to madoot no ispiritu no migbansagon, ");
INSERT INTO msmNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Sikuna Jesus no taga-Nazaret, nokoy no oghilabot ka kanami? Basi kay mig-andini ka su ogyagyagon koy nu. Namaan a dow hintawa ka. Sikuna sikan Balaan no pigpaandini to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Di pigsapadan sikandin ni Jesus, “Pahagtong ka! Yogwa ka duon.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Dajun payukub sikan ispiritu duon to sikan otow aw yaguy dongan to nangiyak to maagbot. ");
INSERT INTO msmNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hilabi naboyong to mgo otow duon aw nakapauusipay, “Aduy! Nokoy man buwa sei? Wada ki pad disti makadinog to angod to seini no pagpang-anad no migdae to katongod! Su inggad to mangkadoot no ispiritu ogtuman to sugu din.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Migtangkap dajun to kabantug ni Jesus diya to tibuuk prubinsya to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pagyuwas ni Jesus to sikan simbahan, mig-andiya sikandin to bayoy ni Simon dow ni Andres duma si Santiago dow si Juan. ");
INSERT INTO msmNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pagtidow dan, naikagihan si Jesus no mighibat to ugangan ni Simon su pighingyow. ");
INSERT INTO msmNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Dajun duguk si Jesus aw tagoni to boyad to sikan bujag aw pabanguna. Duon-dajun naulian sikandin aw honati din onsi Jesus to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Anoy man no migsayop on to soga, pigdae duon ki Jesus to tibo masakiton hasta to pigpangsamuk to mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nahimun to tibo taga-yunsud duon to yuwas to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pinang-ulian ni Jesus to mahan-in no mgo otow no migbati to yain-yain no sakit. Mahan-in isab to pinang-abug din no mangkadoot no ispiritu no migsamuk to mgo otow. Sikan no mgo ispiritu wada din paikagiha su yagboy dan namaanan dow hintawa si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaadlawon pad migbangun on si Jesus aw pahilit su og-ampu. ");
INSERT INTO msmNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na, pagkamaan onni Simon no wadad si Jesus, pigpamangha dan. ");
INSERT INTO msmNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pagkakita-i dan kandin, mig-iling sikandan, “Seini ka da man naan! Namangha ikow to tibo mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Di mig-ikagi si Jesus, “Og-andiya kinow pad to duma no mgo yunsud duon to kadanihan su igwali ku pad isab to Madojow no Nawnangonon diya, su sikan to ing-andini ku.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kaling pigyogob-yogob din to mgo kayunsudan duon to Galilea. Migwali sikandin duon to mgo simbahan to mgo Hibru. Pinang-abug din isab to mangkadoot no ispiritu no migsamuk to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na, meyduon otow no pigsangla no mig-anduon ki Jesus aw pakimayuuy. Migyuhud sikandin duon to atubangan din aw ikagi, “Ko pagboot nu, ogkaulian a.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pigkae-atan ni Jesus sikan otow aw dampaa din no mig-iling, “Ogbootan ku no maulian ka.” ");
INSERT INTO msmNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Duon-dajun naulian sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Tapus to sikan, pigbahog sikandin ni Jesus, “Wada ognangonan nu no inggad hintawa. Nasi no andiya ka to magdudumaya to tinuuhan ta aw paaha ka. Pagkatapus, bogoy ka to halad no insugu ni Moises to diya una agun mamatuud no naulian kad.” Dajun sikandin papanawa ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Di sikan otow naosoyan nasi to pagnawnangon to nahitabu kandin. Kaling migtangkap to nawnangonon bahin ki Jesus hangtod no konad on sikandin ogpakapakita diya to mgo yunsud. Duon da sikandin pakamonang to hilit. Di mahan-in gihapun to mgo otow no ogpamang-andiya kandin no ogkapuun diya to inggad andei no banwa. ");
INSERT INTO msmNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Anoy man no napilaan on, migpauli si Jesus diya to Capernaum. Pagkamaan to mgo otow no mig-uli on sikandin, ");
INSERT INTO msmNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","mahan-in to nahimun duon, kaling migdasok sikandan duon to sed to bayoy. Aw inggad ngani to pertahan pighootan to otow. Na, pagnawnangon ni Jesus to kagi to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","meyduon migtidow no upat no ka otow no migyayahung to duma dan no naparalays. ");
INSERT INTO msmNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tongod to sikan migdasok no mgo otow, wada sikandan makapadani ki Jesus, kaling namonhik sikandan diya to diatas aw gawanga dan to songo bahin to atop duon to yongod ni Jesus. Dajun tuntuna sikan otow no inyuwan duon to hibatanan din. ");
INSERT INTO msmNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pagkita ni Jesus no hogot to pagtuu dan, pig-ikagihan din sikan otow no naparalays, “Yagi, pigpasaylu on to mgo sae nu.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Na, meyduon mgo maistru to tinuuhan no naman-ingkud duon. Pagdinog dan to sikan pig-ikagi ni Jesus, nailing to ginhawa dan, ");
INSERT INTO msmNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Eh, nokoy no migyangub man seini no otawa to pag-ikagi to sikan? Ogpasipaya sikandin to Diyus, su Diyus da man to ogpakapasaylu to sae.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Di nasabutan ni Jesus to hona-hona dan, kaling pig-ikagihan din sikandan, “Nokoy no mighona-hona kow man to sikan? ");
INSERT INTO msmNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Andei man to mahaewoy, ko muiling a, ‘Pigpasaylu on to mgo sae nu,’ ubin ko muiling a, ‘Tindog ka. Daeha sikan pighibatan nu aw panow kad’? ");
INSERT INTO msmNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na, kuntoon igpakita ku iyu no siak no Anak to Otow meyduon katongod kani to babow to kalibutan to pagpasaylu to sae.” Dajun din ikagihi sikan naparalays, ");
INSERT INTO msmNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tindog ka. Daeha sikan pighibatan nu aw uli kad on.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dajun bangun sikan otow. Pigdawat din sikan pighibatan din aw panow. Natingaya hilabi to tibo mgo otow duon. Dajun dan sajaa to Diyus no mig-iling, “Disti on ko migkita ki to angod to sikan!” ");
INSERT INTO msmNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mig-andiya manda si Jesus to higad to danow. Mahan-in to nahimun no otow duon kandin, aw pigpang-anad din. ");
INSERT INTO msmNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pagpanow on ni Jesus, nabajaan din si Levi no anak ni Alfeo. Mig-ingkud sikandin duon to sukutanan to buhis su magsukutay man sikandin. Kagi ni Jesus, “Yagi, duma kad kanay su oghinangon ku sikuna no inanad.” Dajun tindog si Levi aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na, pigpakoon si Jesus dow mgo inanad din diya to bayoy ni Levi. Mahan-in to migpagsayu kandan no magsukutay to buhis dow duma no mgo otow no og-ilingon to makasasaya, su mahan-in to angod kandan no migduma-duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na, meyduon mgo maistru to tinuuhan no sakup to punduk to Pariseo no migkita ki Jesus no migpagsayu to sikan no mgo otow. Kaling pig-usip dan to mgo inanad ni Jesus, “Nokoy no ogpagsayu man sikan maistru now to sikan matuntuhon no mgo magsukutay to buhis dow duma no mgo makasasaya?” ");
INSERT INTO msmNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pagdinog ni Jesus to kagi dan, sikandin to migtabak no impabaja to pananglitan. Kagi din, “To otow no wada sakit kona ogkinahangyan to duktur. Masakiton da to ogkinahangyan. Angod isab kanay no mig-andini to kalibutan. Kona no iyan ing-andini ku to pagkabig to mgo otow no mighona-hona no matarong sikandan. Di iyan pig-andini ku to mgo makasasaya.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Songo aedow meyduon naman-andiya ki Jesus no nangusip, su nakapaniid sikandan no migpuasa to mgo inanad ni Juan no Magbawtismuhay dow to mgo Pariseo. Kagi dan, “To mgo inanad to mgo Pariseo dow ni Juan ogtuman to pagpuasa. Na, nokoy no kona man ogpuasa to mgo inanad nu?” ");
INSERT INTO msmNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Migtabak si Jesus, “Ko pananglit meyduon kumbiti, nokoy man, ogpuasa buwa to kadumahan to sikan bag-u kaminyo no yukos ko duma dan pad sikandin? Kona gajod! ");
INSERT INTO msmNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Di mey da panahon no ogpuduton sikandin duon kandan, aw iyan pad pagpuasa dan.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Impananglit isab ni Jesus to wada pagkahiujun to impang-anad din dow to impang-anad to mgo Hibru. Kagi din, “Wada otow no ogtapak to bag-u no panapton duon to tahan no kabo. Su ko labahan, ogkoyo sikan bag-u no panapton aw ogyow-ag sikan higbit. ");
INSERT INTO msmNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Angod isab to inomon no ogsobu pad no igtagu duon to sedanan no kindae. Wada otow no ogtagu to seini duon to tahan no sedanan su maliskog on aw madali ogbotu. Ginona ogkauyakan sikan inomon dow sedanan. Nasi no igtagu to bag-u no inomon duon to bag-u no sedanan.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Songo Aedow no Tigpahuway, nakabaja si Jesus dow mgo inanad din duon to mgo uma. Nangotu to mgo inanad din to uhoy to trigu aw kitopa dan. ");
INSERT INTO msmNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Dajun sagman to mgo Pariseo. Kagi dan ki Jesus, “Aha ka to suja mgo inanad nu. Nokoy no ogyapas man sikandan to Aedow no Tigpahuway?” ");
INSERT INTO msmNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Migtabak si Jesus, “Ajaw now og-ilinga no wada kow makabasa to pighinang ni Hari David to diya una no bontason sikandin dow to mgo duma din. ");
INSERT INTO msmNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Migsed sikandin duon to bayoy to Diyus aw koon to pan no inghalad to Diyus aw pakoona isab to mgo duma din. Nahitabu sikan to diya panahon no si Abiatar to kinayabawan no magdudumaya to tinuuhan ta. Na, mig-iling to balaod no iyan da ogpakakoon to sikan to mgo magdudumaya. Di manno kinahangyanon man yagboy, wadad sapadi si David.” ");
INSERT INTO msmNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Migpadajun si Jesus to pag-ikagi, “Pigyain to Diyus to Aedow no Tigpahuway su kadojawan sikan to mgo otow. Ogtuman ki iyan to sikan, di kona no iyan inghinanga ita agun ogtuman ki. ");
INSERT INTO msmNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kaling inggad ngani to Aedow no Tigpahuway, siak no Anak to Otow iyan ogboot.” ");
INSERT INTO msmNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pag-andiya isab ni Jesus to simbahan to mgo Hibru, mey otow duon no napawing to dibayuy no boyad. ");
INSERT INTO msmNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mey isab mgo otow duon no naniid ki Jesus, su ko padojawon din sikan otow duon to Aedow no Tigpahuway, meyduon igkariklamu dan kuntra kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pig-ikagihan ni Jesus sikan pawing, “Yagi, tindog ka duon to kabaknaan.” ");
INSERT INTO msmNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Dajun usipa ni Jesus to nahimun no mgo otow, “Andei man to intugut to balaod to tinuuhan ta no oghinangon duon to Aedow no Tigpahuway, madojow ko madoot? Pagyuwas to kinabuhi ubin paghimatoy?” Di nakapapahonok sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Naboyu si Jesus no nang-aha-aha to kaotawan, aw naguul isab tongod to kadoson to uyu dan. Dajun din ikagihi sikan pawing, “Kotonga sikan boyad nu.” Pagkotonga din, dajun sikandin naulian. ");
INSERT INTO msmNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na, migyuwas to mgo Pariseo aw pagsabut sikandan to mgo sakup to partidu ni Hari Herodes dow og-amonuhon dan to pagpahimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na, mig-andiya si Jesus dow mgo inanad din to higad to danow. Mahan-in to migduma kandan no taga-Galilea. ");
INSERT INTO msmNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aw inggad to mgo otow diya to kadiyuan, pagdinog dan to mgo milagru no ogpanghinangon din, mig-anduon isab ki Jesus. Meyduon napuun diya to mgo prubinsya to Judea dow Idumea dow napuun diya to siyudad to Jerusalem hasta diya to dihipag to Jordan. Meyduon isab napuun diya to mgo siyudad to Tiro dow Sidon hasta to nakalibong no mgo banwa. ");
INSERT INTO msmNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Anoy man no mahan-in on to mgo otow, pig-ikagihan ni Jesus to mgo inanad din no hinaaton dan to bangka no ogkaingkudan din su unu ko dadasokan sikandin to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Su mahan-in on to nangkaulian din, kaling migdadasok to mgo masakiton agun makatudi kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pagkakita-i ki Jesus to mgo otow no pigsedan to mangkadoot no ispiritu, namanyuhud sikandan duon to atubangan din aw pamangiyak no mig-iling, “Sikuna iyan to Anak to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Di pigbahog din sikan mgo ispiritu no kona dan sikandin ignawnangon. ");
INSERT INTO msmNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na, miggamat si Jesus to bubungan aw panuguni din to diya ogkaliyagan din no ogpaanduonon kandin. Pagkahimun dan on, ");
INSERT INTO msmNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","migpili si Jesus to sampuyu-tag-duwa no iyan ogduma-dumahon din. Ogsuguon din isab sikandan to pagwali ");
INSERT INTO msmNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","aw ogbogajan to katongod to pag-abug to mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Seini to nangkapili din: si Simon no pighingadanan din isab ki Pedro ");
INSERT INTO msmNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","dow to mgo anak ni Sebedeo no si Santiago dow si Juan. Seini migsusuun pigngadanan din isab to Boanerges, no ko ita pa, yugung. ");
INSERT INTO msmNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pigpili din isab si Andres, si Felipe, si Bartolome, si Mateo, si Tomas, si Santiago no anak ni Alfeo, si Tadeo dow si Simon no maunungon hilabi to tribu dan. ");
INSERT INTO msmNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Pigpili din isab si Judas Iscariote no iyan ogyuib kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na, anoy man no mig-uli on si Jesus dow mgo inanad din, migdasok on isab to mgo otow duon kandin, kaling wadad sikandan makalugar to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na, pagkamaan to pamilya din to sikan, migpanow sikandan su ogdokaton dan. Su meyduon naman-iling no nagawangan on si Jesus to boot. ");
INSERT INTO msmNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Meyduon isab mgo maistru to tinuuhan no napuun diya to siyudad to Jerusalem no mig-iling, “Kae! Ogpakaabug sikandin to mangkadoot no ispiritu su pigbogajan man to gahom ni Satanas no panguyu dan!” ");
INSERT INTO msmNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kaling pigpaduguk ni Jesus sikan mgo otow duon kandin aw ikagihi, “Og-amonuhon man ni Satanas to pag-abug to kaugalingon din? ");
INSERT INTO msmNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Su ko pananglit og-uunoy oggera to mgo sakup to songo nasyun, ogkabongkag sikan no nasyun. ");
INSERT INTO msmNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Sikan isab to ogkadeygan ko meyduon panimayoy no og-uunoy ogbubuyow-buyow to mgo sakup. ");
INSERT INTO msmNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Na, ko pananglit abugon ni Satanas to mgo sakup din, migpasabut no sikandin da to mig-amung-amung to kaugalingon din aw kona oghangtod to pagmandu din. ");
INSERT INTO msmNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iyan da ogkaabug to mangkadoot no ispiritu ko unahon daogon si Satanas no agayon dan. Angod pananglit to seini: Wada ogpakased to bayoy to madoson no otow to pag-agow to katigajunan din ko kona sikandin mauna madaog aw gapusa.” (Migpasabut si Jesus no nadaog din on iyan si Satanas, kaling ogpakaabug sikandin to mangkadoot no ispiritu.) ");
INSERT INTO msmNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ligdongi now seini,” kagi ni Jesus. “Inggad nokoy no sae ogpasayluhon to Diyus, inggad to pagpasipaya to Amoy no Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Di to otow no ogyangub ogpasipaya to Ispiritu Santu kona yagboy ogkapasaylu hangtod to wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Pig-ikagi ni Jesus sikan su anoy Ispiritu Santu to miggahom kandin, mig-iling sikandan no iyan miggahom kandin to madoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pagtidow to inoy ni Jesus dow mgo suun din no yukos, diya da sikandan to yuwas to bayoy, aw pigpasuguan dan si Jesus no payuwason naa. ");
INSERT INTO msmNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na, si Jesus nalibongan to mahan-in no mgo otow no naman-ingkud. Pagnangoni kandin, ");
INSERT INTO msmNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","mig-iling si Jesus, “Hoo iyan, di ognangonan ku sikiyu dow hintawa to pig-isip ku no inoy dow mgo suun yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nanlingi-lingi sikandin duon to sikan naman-ingkud no nakalibong kandin aw ikagi, “Seini to inoy dow mgo suun ku. ");
INSERT INTO msmNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Su inggad hintawa no ogtuman to pagboot to Diyus iyan og-isipon ku no inoy dow mgo suun no yukos dow bohi.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na, migpang-anad si Jesus duon to higad to danow. Hilabi mahan-in to mgo otow no nahimun duon, kaling mig-ingkud sikandin duon to bangka no nakapadiyu-diyu to higad su ogpang-anadon din sikan mgo otow duon. ");
INSERT INTO msmNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mahan-in to impang-anad din no impabaja to pananglitan. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Paminog kow. Meyduon mag-uuma no mig-odok to binhi. ");
INSERT INTO msmNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Pagsabud din, meyduon mgo binhi no duon kodog to dayan aw pigpanubug to mgo manuk-manuk. ");
INSERT INTO msmNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Meyduon isab binhi no duon kodog to batuhon no pasak. Madali giti su manipis da to pasak. ");
INSERT INTO msmNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Di pagsogahi, migyanos sikan mgo tanom aw kagangu su mababow da to dalid. ");
INSERT INTO msmNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Meyduon isab binhi no duon kodog to pasak no tahan mey dalid to sampinit. Dongan to pagtubu to sikan mgo tanom, nanalingsing isab sikan mgo sampinit hangtod no pigyam-od sikan mgo tanom, kaling wada makabogas. ");
INSERT INTO msmNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Di to duma no mgo binhi duon kodog to madojow no pasak. Miggiti aw migsingin hangtod no nanguhoy. Meyduon kasarangan da to abut, meyduon madogi to abut aw meyduon isab hilabi mig- but. ");
INSERT INTO msmNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na,” kagi ni Jesus, “sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pagkalius on to kahan-inan, migduguk ki Jesus to diya sampuyu-tag-duwa no pinili din yakip to duma no mgo inanad aw pangusip bahin to diya mgo pananglitan din. ");
INSERT INTO msmNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kagi ni Jesus, “Pigpasabut kow on to paghari to Diyus no wada din ipasabut to diya una. Di to diya kona ku no mgo sakup igpabaja ku to pananglitan ko ogpang-anadon ku sikandan ");
INSERT INTO msmNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","agun no ‘Inggad og-aha sikandan, kona ogkita. Inggad ogdinog, kona ogpakasabut su unu ko makasabut aw atubang kanay agun mapasaylu sikandan to Diyus.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mig-usip si Jesus kandan, “Wada kow naan makasabut to diya pananglitan ku? Na, ko wada, og-amonuhon now man to pagsabut to duma no mgo pananglitan? ");
INSERT INTO msmNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","To diya pagsabud to binhi ogkaangod to pagnawnangon to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Meyduon mgo otow no ogkaangod to sikan dayan no nasabudan to binhi, su ko mudinog sikandan to kagi to Diyus, og-agawon dajun ni Satanas duon to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Meyduon isab mgo otow no ogkaangod to sikan batuhon no pasak no nasabudan to binhi, su ko mudinog sikandan to kagi to Diyus, dajun ogtukhow to pagdawat to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Di kona no hogot to pagtuu dan, kaling kona ogyugoy. Su ko abuton sikandan to mgo kalisod dow mgo antusonon tongod to pagdawat dan to kagi to Diyus, og-ojowan dan dajun to pagtuu dan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Meyduon isab mgo otow no ogkaangod to sikan sampiniton no pasak no nasabudan to binhi. Ogdinog sikandan to kagi to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","di ogkawili to mgo kalimuutanan kani to kalibutan dow to pagpadatu hasta to duma no mgo og-awoson to kinabuhi. Kaling ogkaangod sikandan to tanom no wada bogas. ");
INSERT INTO msmNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Di sikan madojow no pasak ogkaangod to mgo otow no ogdinog to kagi to Diyus aw ogdawat. Na, sikan pigdinog dan ogpamogas duon to kinabuhi dan. To duma, kasarangan da to bogas. To duma madogi, aw meyduon isab hilabi madogi.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Migpananglit isab si Jesus. Kagi din, “Ko meyduon ogpadokot to soga, kona ogkahimu no takyuban to gantangan. Kona isab igbotang duon to sayad to katri. Nasi no igbotang duon to untudanan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Angod isab to sikan, to tibo no inghobong ogkabutwa da, aw to wada pad kasabuti ogkasabutan da. ");
INSERT INTO msmNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na,” kagi ni Jesus, “sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Migpadajun sikandin to pag-ikagi, “Paomot kow to pagpaminog to og-ikagihon ku agun madogi to ogkasabutan now, aw ogdugangan pad to Diyus sikan pagsabut now. ");
INSERT INTO msmNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Su ogdugangan din to pagsabut to otow no ogdawat to igpasabut kandin. Di to otow no kona ogdawat to igpasabut kandin to Diyus, oggawangon da inggad to maintok no nasabutan din.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Migpadajun si Jesus to pag-ikagi, “To pag-uswag to sikan ogharian to Diyus ogkaangod to binhi no ig-odok to otow diya to uma din. ");
INSERT INTO msmNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tapus to pag-odok, ogpalingaw-lingawan din aw ogpadajun to inaedow-aedow no trabahu, aw sikan tanom din oggiti aw ogtulin. Di kona din ogkatagahan dow ogkaamonu to pagtubu to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","To pasak iyan ogpagiti aw ogpatulin to tanom. Ogpandagum sikan, ogtulin, ogsingin dow ogpanguhoy. ");
INSERT INTO msmNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko mahinug on to mgo uhoy, og-anihon on.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kagi ni Jesus, “Nokoy pad man to ogkaangodan to sikan ogharian to Diyus? ");
INSERT INTO msmNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ogkaangod to maintok hilabi no binhi no igtanom duon to pasak. ");
INSERT INTO msmNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kinaintokan iyan sikan, di ko mutulin on, ogyabow to katikang duon to duma no mgo tanom. Og-aslag to mgo sanga aw oghapunan to mgo manuk-manuk.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mahan-in pad to pananglitan no angod to sikan no ing-anad ni Jesus kotob da to ogkasabutan to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wada ing-anad din kandan no wada ipabaja to pananglitan. Di ko awoy si Jesus dow mgo inanad din, oghiluwason din sikan mgo pananglitan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Anoy man no masakyop on to diya no aedow, pig-ikagihan ni Jesus to mgo inanad din, “Ogyopa kinow to seini danow.” ");
INSERT INTO msmNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Piglikatan to mgo inanad sikan mgo otow no migdasok duon to higad aw sakoy duon to sikan bangka no tahan pig-ingkudan ni Jesus aw tukud sikandan. To duma migsakoy to yain no sakajan aw duma kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wada kayugoy, puli nakatokow mighodos to maagbot hilabi no kaemag, aw katogob sikan bangka to limason tongod to maagbot no mgo bayod. ");
INSERT INTO msmNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Di si Jesus nalipodong duon to ulin no mig-uy-an. Dajun sikandin pukawa to mgo inanad din aw ikagihi, “Sir, nokoy no ogpalingow-lingow ka man? Ogyogdang kid kay!” ");
INSERT INTO msmNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Dajun buyat si Jesus aw sapadi sikan kaemag. Pigsugu din isab to mgo bayod, “Yonong kow!” Duon-dajun mig-ondang to kaemag aw miglinow to tibo. ");
INSERT INTO msmNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Dajun ikagihi ni Jesus to mgo inanad din, “Nokoy no nahaedok kow man? Andeid man to pagsalig now?” ");
INSERT INTO msmNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hilabi nahaedok dow natingaya sikan mgo inanad, kaling nakapauusipay sikandan, “Nokoy man buwa otawa seini no inggad kaemag dow bayod ogpasapad kandin?” ");
INSERT INTO msmNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pagtidow onni Jesus diya to dihipag, migduung sikandan duon to banwa no sakup to Gerasa. ");
INSERT INTO msmNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Paghaw-as ni Jesus, pigtagbu sikandin to otow no pigpadamaan to mangkadoot no ispiritu. Diya sikandin kapuun to siminteryu ");
INSERT INTO msmNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","no pig-ugpaan din. Konad on ogkagapus inggad ogkadinahan. ");
INSERT INTO msmNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Su kanunoy on piggapus to mgo boyad dow kobong din, di puli din ogpamigtawon to mgo kadina dow pusas. Wada ogpakatagon kandin su hilabi madoson. ");
INSERT INTO msmNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aedow dow madukilom oghipanow sikandin diya to mgo yobong dow kabubunganan aw ogpinangiyak. Ogpali-palian din to kaugalingon din to mgo batu. ");
INSERT INTO msmNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Madiyu pad sikan otow, pigkita din on si Jesus. Miglinaguy sikandin aw tagbuha si Jesus dow yuhud duon to atubangan din. ");
INSERT INTO msmNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Dajun ikagihi ni Jesus sikan ispiritu, “Sikuna no madoot no ispiritu, yaguji seini otow!” Dajun pangiyak sikan ispiritu to maagbot no mig-iling, “Sikuna no Anak to Diyus no Yabow to Tibo, nokoy man to yabot nu kanay? Oghangyuon ku sikuna tongod to ngadan to Diyus no kona a nu ogkastiguhon.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Dajun usip si Jesus, “Hintawa to ngadan nu?” Migtabak sikandin, “Si Linibu to ngadan ku, su hilabi koy mahan-in.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Migpak hangyu sikan mgo ispiritu ki Jesus no kona sikandan ogpayagujon duon to sikan no banwa. ");
INSERT INTO msmNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na, duon to daligdigan to bubungan meyduon mgo daduwa no libu no babuy no nandungae. ");
INSERT INTO msmNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nangamuju sikan mgo ispiritu ki Jesus, “Paseda koy on puli dutun to suja mgo babuy.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pagtugut ni Jesus, pigyagujan dan sikan otow aw sed duon to sikan mgo babuy. Dajun pamanlinaguy sikan mgo babuy no namanyus-ug duon to pangpang aw kangkatabug diya to wohig. ");
INSERT INTO msmNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dajun namanlinaguy sikan namanbantoy to babuy diya to yunsud dow kaumahan aw inangon dan to nahitabu. Dajun anduon to kaotawan su ogsusihon dan. ");
INSERT INTO msmNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pagtidow dan duon ki Jesus, iyan pigkita dan sikan otow no pigyagujan on to linibu no mangkadoot no ispiritu. Mig-iingkud sikandin duon no nakapangabo on aw madojow on to boot. Kaling hilabi nahaedok sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","To namakakita to diya no hitabu mignangon to pagyaguji to sikan otow to mangkadoot no ispiritu hasta isab bahin to diya mgo babuy. ");
INSERT INTO msmNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Dajun dan hangyu-a si Jesus no yagujan din sikan banwa dan. ");
INSERT INTO msmNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Na, anoy man no ogsakoy on si Jesus to bangka, nangamuju sikan otow no pigyagujan to mangkadoot no ispiritu no padumahon sikandin ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Di wada tugut si Jesus. Kagi din, “Uli kad nasi aw nangoni to mgo kadumahan nu dow man-u to kayuuy dow tabang to Ginuu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dajun panow sikan otow aw nawnangon duon to tibo banwa no Decapolis dow man-u to pagtabang kandin ni Jesus. Yagboy nangkatingaya to tibo no namakadinog to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Migpauli onsi Jesus diya to dihipag to sikan danow. No duon on sikandan to higad, nahimun duon ki Jesus to mahan-in hilabi no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na, meyduon migtidow no otow no iyan ngadan si Jairo no panguyu to simbahan to mgo Hibru. Pagkita din ki Jesus, migyuhud sikandin duon to atubangan din ");
INSERT INTO msmNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aw pakimayuuy. Kagi din, “Pakamatajon on to anak ku no bohi no pinadajag ku. Sadangay dumahi a aw dampaa sikandin agun maulian.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Dajun duma si Jesus kandin. Migduma isab to mahan-in no mgo otow no migdasok duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na, duon to sikan no mgo otow meyduon bohi no migyayangosa sed on to sampuyu-tag-duwa no tuig. ");
INSERT INTO msmNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nakaaw-andeid sikandin to pagpatambae, aw mahan-in on to pig-antus din no mgo pagtambae kandin. Nagastu on to tibo katigajunan din di wada gihapun kaulii, nasi on naagbotan. ");
INSERT INTO msmNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na, pagkadinog din bahin ki Jesus, mig-anduon sikandin aw nanliot-liot duon to sikan migdasok no kaotawan kotob no migtidow duon to talikudan ni Jesus. Dajun din tudi-a to kabo ni Jesus ");
INSERT INTO msmNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","su nailing to ginhawa din, “Inggad puli a da makatudi to sikan kabo din, ogkaulian a yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Duon-dajun migtigpok to pagyangosa din, aw pigbati din no naulian on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na, dongan to pagtudi-a ki Jesus to sikan bohi dow pagtigpok to yangosa din, namaan si Jesus no meyduon gahom no migyogwa duon kandin. Kaling migpatibilik sikandin aw pangusip, “Hintawa man to migtudi to kabo ku?” ");
INSERT INTO msmNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Migtabak to mgo inanad din, “Agayon, nokoy no og-usip ka man dow hintawa to migtudi ikow no mahan-in man hilabi seini mgo otow no migdasok kani ikow?” ");
INSERT INTO msmNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Di nang-aha-aha gihapun si Jesus agun mamaanan din dow hintawa to migtudi to kabo din. ");
INSERT INTO msmNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Na, manno namaan sikan bohi no naulian on sikandin, namidpid no migpadani ki Jesus. Migyuhud duon to atubangan din aw inangon to tibo nahitabu kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Dajun ikagihi ni Jesus sikan bohi, “Iya, to pagsalig nu kanay iyan nakadojow ikow. Na, panow kad on no mahusoy to ginhawa, su wadad on to diya sakit nu.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","No mig-ikagi pad si Jesus, mey namantidow no napuun diya to bayoy to sikan panguyu to simbahan. Pig-ikagihan dan sikandin, “Bog-atad to ginhawa nu su nabigtawan on to anak nu. Wadad on pues ko mupadajun pad sikan maistru.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Di si Jesus wada lipara to kagi dan. Nasi no pig-ikagihan din sikan panguyu, “Kona ka ogkahaedok. Salig ka kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wada yain no pigpaduma ni Jesus, si Pedro da dow sikan migsusuun no si Santiago dow si Juan. Dajun sikandan panow. ");
INSERT INTO msmNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Pagtidow dan duon to bayoy to sikan panguyu, iyan pigkita ni Jesus to mahan-in no mgo otow no angod to pigguligow. Meyduon namaniyahu dow namandegmatoy to maagbot. ");
INSERT INTO msmNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dajun sed si Jesus aw ikagihi sikandan, “Nokoy no ogsasamuk kow man aw pamandegmatoy? Wada kamatoy sikan bata, nalipodong puli.” ");
INSERT INTO msmNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dajun dan ngingisihi si Jesus. Di pigpayuwas din sikandan tibo. Iyan da pigpaduma din to mgo ginikanan to sikan patoy hasta sikan mgo duma din. Dajun sikandan sed duon to pigkotangan to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pigtagonan ni Jesus to boyad din aw ikagihi, “Talita kumi!” no ko ita pa, “Igi, bangun ka!” ");
INSERT INTO msmNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Duon-dajun nakabangun sikan bata aw nakahihipanow. Natingaya hilabi to mgo ginikanan din to sikan. (Sikan bata sampuyu-tag-duwa to idad.) ");
INSERT INTO msmNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pigbahog ni Jesus sikan ginikanan no wada yagboy ognangonan dan. Pig-igda din isab no pakoonon sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Piglikatan ni Jesus sikan no banwa duma to mgo inanad din aw uli diya to yunsud no pigtulinan din. ");
INSERT INTO msmNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","No Aedow on no Tigpahuway, nang-anad si Jesus duon to simbahan dan. Natingaya to mahan-in no mgo otow no naminog kandin, kaling migpauusipay sikandan, “Andei man buwa kapuun to nangkaamuhan dow kaalam to seini no otawa? Naamonu buwa no ogpakahinang man sikandin to mgo milagru? ");
INSERT INTO msmNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kona buwa no sikandin to diya pandoy no anak ni Maria, aw suun sikandin ni Santiago, ni Jose, ni Judas dow ni Simon? Dini man ngani ugpa ita to mgo atoboy din.” Kaling nadootan sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Dajun ikagihi ni Jesus sikan mgo otow, “To otow no kibali ba-ba to Diyus ogtahudon duon to inggad andei, di wada ogtahud kandin duon to yunsud din dow kadumahan hasta pamilya din.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Kaling wada nahinang din no mgo milagru duon, gawas to pila no nadampa din no mgo masakiton no nangkaulian. ");
INSERT INTO msmNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Natingaya si Jesus su to mgo taga-Nazaret wada tuu kandin. Dajun sikandin andiya to yain-yain no mgo baryu aw pang-anad. ");
INSERT INTO msmNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pighimun ni Jesus sikan sampuyu-tag-duwa no mgo inanad din su ogsuguon din sikandan to tinag-daduwa diya to kayunsudan. Pigbogajan din to katongod to pag-abug to mangkadoot no ispiritu ");
INSERT INTO msmNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","aw tuguna, “Ko mupanow kow, iyan da daehon now to agos. Kona kow ogbabaaw, kona kow ogbaba to puju, aw kona kow ogdae to saepi. ");
INSERT INTO msmNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Manapatus kow di kona kow ogdae to ilisan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ko mutidow kow on duon to inggad andei no yunsud, pakamonang kow duon to bayoy no ogpaabutan now kotob no mupanow kow on. ");
INSERT INTO msmNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko wada ogdawat iyu duon to inggad andei no banwa aw wada ogpaminog iyu, na, yaguji now sikan no banwa. Padpada to abug to sapatus now ko mupanow kow pagpakiyaya no kona kow on ogkasukutan ko kastiguhon sikandan.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Dajun panow sikan mgo inanad ni Jesus aw wali no kinahangyan musosey to mgo otow aw talikudi to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pigpang-abug dan to mangkadoot no ispiritu no migsamuk to mahan-in no mgo otow. Mahan-in isab to mgo masakiton no pighidhid dan to yana aw nangkaulian. ");
INSERT INTO msmNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nakadinog si Hari Herodes Antipas to nangkahinang ni Jesus su nabantug on sikandin. Di wada kaaangod to hona-hona to mgo otow. Meyduon naman-iling, “Si Jesus iyan si Juan no Magbawtismuhay no nabanhaw, kaling ogpakahinang to milagru.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Meyduon isab naman-iling, “Si Jesus iyan si Elias.” Mey pad duma no naman-iling, “Angod sikandin to diya mgo otow no kibali ba-ba to Diyus to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Di si Hari Herodes, pagdinog din bahin ki Jesus, mig-iling sikandin, “Adoy, ogkaamonu buwa ko nabanhaw da si Juan no pigpatampodan kud man to liog!” ");
INSERT INTO msmNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Naikagi din sikan su to diya una, impadakop din si Juan aw ipaprisu no ginapus tongod to pagsukat din ki Herodes. Su pig-agow ni Herodes si Herodias no asawa to suun din no si Felipe. ");
INSERT INTO msmNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tongod to kanunoy din pagsawoy ki Herodes, pigdomotan si Juan ni Herodias. Kaling ogpahimatajan din podom, di wada sikandin makahimu ");
INSERT INTO msmNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","su nahaedok si Herodes ki Juan, su namaanan din no matarong si Juan dow diyusnon. Kaling wada din itugut no mahimatajan sikandin. Naliyag isab si Herodes naminog to mgo kagi ni Juan inggad nakasamuk sikan to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na, pag-abut to aedow to kainanakan ni Herodes, migbangkiti sikandin. Iyan pig-imbita din to mgo upisyalis din dow to mgo yabow to sundayu hasta to inila no mgo taga-Galilea. Bali man no nakalugar si Herodias to pagpahimatoy ki Juan ");
INSERT INTO msmNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","su to anak din no daega mig-anduon aw sajow. Nasajaan yagboy si Herodes dow mgo imbitadu din, kaling nakailing si Herodes, “Pamuju ka kanay to inggad nokoy no ogkaliyagan nu su igbogoy ku ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Migpanapa pad sikandin aw iling, “Inggad nokoy to ogbujuon nu, igbogoy ku gajod ikow, inggad katonga to seini gingharian ku.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dajun yuwas sikan daega aw usipa to inoy din, “Inay, nokoy man to ogbujuon ku?” Migtabak to inoy, “Pamuju-a to uyu ni Juan no Magbawtismuhay.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Migdinali sikan daega to pagsed aw ikagihi sikan hari, “Iyan ogbujuon ku kuntoon dajun to uyu ni Juan no Magbawtismuhay no igbotang duon to bandihadu.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hilabi migdoot to ginhawa ni Herodes, di tongod to sikan saad no pigsapaan din duon to atubangan to mgo imbitadu, wada sikandin makabalibad. ");
INSERT INTO msmNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dajun din sugu-a to sundayu din no tampodon to liog ni Juan aw daehon to uyu din. Na, dajun sikandin andiya to prisuhan aw tampoda to liog ni Juan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Imbotang din sikan uyu duon to bandihadu dow daeha din aw ibogoy to sikan daega. Dajun din dawata aw ibogoy diya to inoy din. ");
INSERT INTO msmNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pagdinog to mgo inanad ni Juan to nahitabu, pigpudut dan to patoy no yawa din aw iyobong. ");
INSERT INTO msmNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pagpauli to diya sampuyu-tag-duwa no mgo apustulis, ingnangon dan ki Jesus to tibo nahinang dow impang-anad dan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na, mahan-in hilabi to mgo otow no ogkasinokoli da to pagtidow dow pagyuwas, kaling wadad lugar onni Jesus inggad ngani to pagkoon. Kagi ni Jesus to mgo inanad din, “Ogpahilit kinow naa no itanow da agun makapahuway kow.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Dajun sikandan sakoy to bangka aw likat padeg diya to hilit. ");
INSERT INTO msmNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Di pigkita sikandan to mahan-in no mgo otow no taga-yain-yain no mgo baryu no migkiyaya kandan. Namanlinaguy sikan mgo otow no namanliput, aw una sikandan no nakatidow duon to ogduungan onni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Paghaw-as ni Jesus, pigkita din sikan mahan-in hilabi no mgo otow. Pigkae-atan din su angod sikandan to mgo karneru no wada og-atiman. Kaling migsugud sikandin to pag-anad kandan, aw mahan-in to impang-anad din. ");
INSERT INTO msmNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Anoy man no mahapun on, to mgo inanad ni Jesus migduguk kandin aw ikagi, “Mahapun on kay to kani, wada da man ogkapudutan to pagkoon kani to hilit. ");
INSERT INTO msmNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Madojow ko papanawon ta seini mgo otow diya to kaumahan dow kabaryuhan agun makaboli to pagkoon dan.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Di kagi ni Jesus, “Sikiyu to mupakoon kandan.” “Aw atu!” kagi dan. “Ogpabolihon koy nu to libu-libu no ka pisus no bali to pagkoon?” ");
INSERT INTO msmNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mig-ikagi si Jesus, “Ahaa now kun dow pila no buuk to pan kani.” Tapus dan ahaa, pig-ikagihan dan si Jesus, “Lima da no buuk to pan dow daduwa no ka isda.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dajun sugu-a ni Jesus to mgo inanad no ipagrupu-grupu to mgo otow aw pamaingkuda duon to pasak no mayunhow pad to bagnot. ");
INSERT INTO msmNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Kaling naman-ingkud sikandan to tinag-kalim-an dow tinag-gatus to kada grupu. ");
INSERT INTO msmNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pigdawat ni Jesus sikan lima no buuk no pan dow daduwa no ka isda aw yanghag diya to yangit to pagpasalamat to Diyus. Dajun din panibaga sikan pan aw ibogoy diya to mgo inanad din agun ipamogoy diya to kaotawan. Pigpanibag din isab sikan isda aw payogobi sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mighan-in yagboy sikan pan dow isda, kaling nakakoon sikandan tibo kotob no nangkahantoy. ");
INSERT INTO msmNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pagkatapus to pagkoon, pigpanghimun to mgo inanad to nasama, aw kaponu to sampuyu-tag-duwa no ka ayat! ");
INSERT INTO msmNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lima no libu sikandan no nakakoon ko mgo yukos da to bilangon. ");
INSERT INTO msmNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dajun pasakaja ni Jesus to mgo inanad din to bangka. Ogpaunahon din sikandan diya to yunsud to Betsaida su ogpalikaton din pad to mgo otow no nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pagkalius on to sikan mgo otow, miggamat si Jesus to bubungan su og-ampu. ");
INSERT INTO msmNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","No madukilom on, naawoy si Jesus duon to bubungan, di sikan pigsakajan to mgo inanad din nakapatonga on to danow. ");
INSERT INTO msmNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pagpanghanow-hanow ni Jesus, pigkita din no nalisodan sikandan to paggaud su nasugang dan to kaemag. Na, anoy man no kaadlawon on, pigyupug sikandan ni Jesus no migpanow duon to babow to wohig. Angod kunu to ogpayaboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Di pagkita dan kandin no migpanow duon to babow to wohig, pigdaitan sikandan tibo aw namakapangiyak su nailing to boot dan no umagad. Di dajun migtawag si Jesus, “Digona to ginhawa now su siak seini. Kona kow ogkahaedok.” ");
INSERT INTO msmNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Dajun sikandin sakoy aw pagtibo kandan. Dongan to pagsakoy din, migsigkon to kaemag. Hilabi naboyong to mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","su inggad pigkita dan on to pagpahan-in din to diya pan, wada dan pad kasabuti to gahom din su nadigyoman to hona-hona dan. ");
INSERT INTO msmNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Na, pagtidow dan diya to dihipag, migduung sikandan duon to banwa to Genesaret. ");
INSERT INTO msmNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Pigkiyaya si Jesus to mgo otow duon, ");
INSERT INTO msmNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","kaling namanlinaguy sikandan diya to mgo kabaryuhan dow pandokata to mgo masakiton aw yayahungi diya ki Jesus. Inggad andei dan ogdinogon si Jesus, diya dan isab ogdaehon to mgo masakiton. ");
INSERT INTO msmNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Inggad andei sikandin ogdeg, ko diya to kabaryuhan dow kaumahan hasta kayunsudan, igbotang to mgo masakiton duon to oghihimunan to mgo otow. Ogpangamuju sikandan ki Jesus no patudion din to inggad jawing-jawing da duon to sidsid to kabo din. Na, naulian to tibo no nakatudi to kabo ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na, mey naman-andiya ki Jesus no mgo Pariseo dow mgo maistru to tinuuhan no napuun diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Napaniidan dan to duma no mgo inanad ni Jesus no migkoon no wada panghugas to boyad. ");
INSERT INTO msmNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Su to mgo Hibru, yabi to mgo Pariseo, kona ogkoon ko kona makapanghugas to mgo boyad to paagi no ing-anad to mgo minuna dan. ");
INSERT INTO msmNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hasta ko ogkapuun sikandan diya to merkadu, ogpanghugas su iyan tumanon dan ayha ogkoon. Aw mahan-in pad to nabatasan dan no ogtumanon angod pananglit to paghugas to mgo tasa, mgo tibud, dow mgo son-adan. ");
INSERT INTO msmNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tongod to sikan, pig-usip si Jesus to sikan mgo Pariseo dow mgo maistru to tinuuhan, “Nokoy no kona man ogtuman to mgo inanad nu to mgo tumanon no nabuyatan ta? Su ogkoon sikandan no kona ogpanghugas to mgo boyad.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pigtabak sikandan ni Jesus, “Kunungkun mangkatarong! Tinood yagboy to diya kagi to Diyus no sinuyat ni Isaias no kibali ba-ba din bahin iyu no pig-iling din, ‘Seini no mgo otow og-iling to pigtahud a dan, di kotob da to tumuy to dila dan su wada a ibotang duon to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wada pues to pagsimba dan kanay, su iyan da igpang-anad dan to tumanon no pig-otawan.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kagi ni Jesus, “Pig-ojowan now to mgo sugu to Diyus aw ilisi to tumanon no pig-otawan. ");
INSERT INTO msmNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Mapandoy gajod to pagkasalikway now to kasuguan to Diyus agun iyan nasi matuman to iyu no tumanon. ");
INSERT INTO msmNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Angod pananglit to diya sugu to Diyus no impabaja ki Moises no pig-iling, ‘Tahuda to amoy dow inoy nu.’ Insugu din isab no inggad hintawa no ogpasipaya to ginikanan oghimatajan. ");
INSERT INTO msmNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Di sikiyu, yahi to ing-anad now. Su inggad meyduon podom igkatabang to otow to ginikanan din, ogpabalibadon now sikandan to pag-iling, ‘Meyduon podom bobogoy ku iyu di impaabin kud nasi to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Duon to sikan, napogongan now on sikandin to pagtabang to ginikanan din, ");
INSERT INTO msmNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","aw pinakawada now to kagi to Diyus tongod to sikan kabilin now no tumanon. Mahan-in pad isab to duma no oghinangon now no angod to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pighimun isab ni Jesus to kaotawan aw ikagihi, “Paminog kow tibo to seini og-ikagihon ku aw panginsabuti now. ");
INSERT INTO msmNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Inggad nokoy no ogkoonon to otow kona no iyan ogpakaligsom kandin. Iyan da ogpakaligsom sikan ogkapuun duon to ginhawa din.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","No likatan on ni Jesus to kaotawan aw makased on duon to bayoy, nangusip to mgo inanad dow nokoy to igpasabut to diya pig-ikagi din. ");
INSERT INTO msmNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kagi ni Jesus, “Sikiyu isab, wada kow naan makasabut? To ogkoonon to otow kona no iyan ogpakaligsom kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Su diya da ogdeg to gotok, aw tapus to sikan ogyuwas da to yawa din. Kona sikan ogpakaandiya to ginhawa din.” Duon to sikan, impasabut ni Jesus no wadad pagkoon no ing-ojow to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Migpadajun si Jesus to pag-ikagi, “Iyan nasi ogpakaligsom to otow sikan ogkapuun duon to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Su duon ogkapuun to madoot no mgo hona-hona, paghinang to kayaw-ajan, pagpangawat, paghimatoy, ");
INSERT INTO msmNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pagkahakog, pagkayawan-on, paglimbung, pagpatujang, pagsilag, pagbuung to dongog to duma, pagpagarbu dow pagpabuang-buang. ");
INSERT INTO msmNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Seini mangkadoot no hinang duon ogkapuun to ginhawa to otow, aw iyan ogpakaligsom kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Dajun panow si Jesus aw andiya to banwa no sakup to siyudad to Tiro. Pagtidow din, duon sikandin paabut to songo bayoy. Gustu din no wada ogkamaan no duon on sikandin, di natagahan da. ");
INSERT INTO msmNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Na, duon to sikan no banwa meyduon bohi no kona no Hibru. Diya sikandin i-anak to Fenicia no sakup to Siria, aw Grigu to inikagihan din. Meyduon anak din no bohi no pigsamuk to madoot no ispiritu. Na, pagkamaan to sikan bohi no duon on si Jesus, dajun sikandin mig-anduon aw yuhud duon to atubangan din aw pangamuju no abugon din sikan ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Di kagi ni Jesus, “To mgo anak iyan una no ogpakoonon, su madoot ko agawon to koonon dan agun itimbag diya to mgo idu.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Iyan man iyan Sir,” kagi to sikan bohi, “di ngani man to idu di ogpakapanginamut to mgo timu no ogkatanak to mgo bata no ogpamangoon.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“Na,” kagi ni Jesus, “uli kad on. Tongod to sikan kagi nu, pigyagujan on to madoot no ispiritu sikan anak nu.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Dajun uli sikan bohi. Pagtidow din diya to bayoy, pigkita din sikan anak din no mighibat pad, di pigyagujan on iyan to madoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pagpauli on ni Jesus likat to banwa no sakup to siyudad to Tiro, migbaja sikandin duon to Sidon aw duon to danow to Galilea padeg diya to banwa to Decapolis. ");
INSERT INTO msmNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na, meyduon mgo otow no migdae duon ki Jesus to otow no bongey dow poha aw hangyu no dampaon din. ");
INSERT INTO msmNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Impadiyu ni Jesus sikan bongey to sikan mgo otow no nahimun aw yugyuga to tudyu din to mgo talinga to sikan bongey. Tapus to sikan, pigdopuhan ni Jesus to tudyu din to yawoy aw tudi-a to dila to sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Dajun yanghag si Jesus diya to yangit aw ginhawa to mahaba aw ikagihi sikan otow, “Maabri kow.” ");
INSERT INTO msmNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Duon-dajun migdinog sikan otow aw matul-id on to pag-ikagi din. ");
INSERT INTO msmNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pigbahog ni Jesus sikan mgo otow no wada ognangonan dan to sikan pighinang din, di nasi sikandan naosoyan to pagnawnangon. ");
INSERT INTO msmNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yagboy natingaya to tibo aw nakaikagi, “Aduy! Madojow to tibo mgo hinang to sikan otow. Inggad to bongey ogpadinogon din, aw to poha ogpaikagihon.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pagyaboy to pila no aedow, meyduon isab mahan-in hilabi no mgo otow no nahimun duon ki Jesus. Anoy man no wadad on pagkoon dan, pighimun ni Jesus to mgo inanad din aw ikagihi, ");
INSERT INTO msmNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ogkae-at a to seini mgo otow su tatoyu on no aedow sikandan kani aw wadad ogkakoon dan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ko papanawon ku no ogpamontason, basi hanipon duon to pangindaenan, su to duma madiyu to og-ulian.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Dajun usip to mgo inanad, “Eh, og-amonuhon ta man to pagpakoon to seini mahan-in no mgo otow kani to hilit?” ");
INSERT INTO msmNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Dajun usip si Jesus, “Pila no buuk to pan duon iyu?” Kagi dan, “Pitu.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Dajun pamaingkuda ni Jesus sikan mgo otow duon to pasak. Pigdawat din sikan pitu no buuk no pan aw pasalamat to Diyus. Dajun din panibaga aw ibogoy diya to mgo inanad din agun ipamogoy diya to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Meyduon isab pila no buuk no mangkaintok no isda. Migpasalamat si Jesus to sikan aw isugu din to mgo inanad no ipanadwoy isab diya to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mighan-in yagboy sikan pan dow isda, kaling nakakoon sikandan tibo kotob no nangkahantoy. Tapus to pagkoon, pigpanghimun to mgo inanad to nasama, aw kaponu to pitu no ka baeknan! ");
INSERT INTO msmNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Mgo upat no libu sikandan no nakakoon ko mgo yukos da to bilangon. Tapus papanawa ni Jesus to mgo otow, ");
INSERT INTO msmNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","nanakajan sikandin duma to mgo inanad din su og-andiya to banwa to Dalmanuta. ");
INSERT INTO msmNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Meyduon mgo Pariseo no mig-anduon ki Jesus aw pagyalis kandin su og-antihan dan. Mighangyu sikandan no ipakita din to milagru no ogpakiyaya no Diyus to migpadae kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pagdinog ni Jesus to hangyu dan, nakaginhawa sikandin to mahaba aw iling, “Ay, sikiyu no mgo otow kuntoon, nokoy no ogpamangha kow pad man to milagru? Wada yagboy igkapakita iyu.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Dajun ojowi onni Jesus sikan mgo otow. Nanakajan sikandan aw yopa. ");
INSERT INTO msmNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Na, paglikat dan, to mgo inanad ni Jesus nalingow to pagdae to pan no ogbaawon dan podom, gawas to sobuuk no nabilin duon to sakajan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pigpatahanan sikandan ni Jesus, kagi din, “Likoy kow to patubu to mgo Pariseo dow sikan ki Herodes.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Di to mgo inanad ni Jesus wada makasabut no kona no patubu to pan to ognangonon din, kaling mighahagas sikandan, “Basi naikagi din sikan su wada ki makadae to pan.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Namaanan ni Jesus to pighahagasan dan, kaling nangusip sikandin, “Nokoy no oghisgut kow man to pagkalingow now to pagdae to pan? Wada kow pad naan makasabut? Nokoy man, nadigyoman kay buwa to hona-hona now? ");
INSERT INTO msmNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mey mata now, di angod to kona kow ogkita. Mey talinga now, di angod to kona kow ogdinog. Nalingawan now on buwa to diya pighinang ku? ");
INSERT INTO msmNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","To diya panibagon ku to lima no buuk no pan no impakoon ku to diya lima no libu no mgo otow, pila man no ayat to nahimun now no sama?” “Sampuyu-tag-duwa,” kagi dan pa. ");
INSERT INTO msmNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mig-usip isab si Jesus, “To diya isab pitu no buuk no pan no impakoon ku to upat no libu no mgo otow, pila no baeknan to nahimun now no sama?” “Pitu,” kagi dan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Na,” kagi ni Jesus, “wada kow gihapun makasabut?” ");
INSERT INTO msmNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pagtidow onni Jesus diya to Betsaida, meyduon mgo otow no migdae to buta duon kandin aw hangyu no dampaon din. ");
INSERT INTO msmNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pigpikit ni Jesus sikan otow diya to yuwas to yunsud. Dajun din dopuhi to yawoy to mata to sikan buta aw dampaa aw usipa dow mey ogkitaon din. ");
INSERT INTO msmNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Migtonggak sikan otow aw pang-aha-aha. Kagi din, “Ogkita a to mgo otow no angod to ogpamanow-panow no kaju.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pig-isab ni Jesus pigdampa to mata to sikan otow. Pagbuyata to mata din, mapajag on to pag-aha din. ");
INSERT INTO msmNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tapus to sikan, pig-ikagihan ni Jesus sikan otow, “Uli kad, di kona ka oghapit duon to yunsud.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mig-andiya onsi Jesus to mgo baryu no sakup to yunsud to Cesarea Filipo. Duon to pangindaenan pig-usip din to mgo inanad din, “To paghona-hona to mgo otow, hintawa a kun man?” ");
INSERT INTO msmNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Migtabak sikandan, “Meyduon og-iling no si Juan ka no Magbawtismuhay, meyduon isab og-iling no si Elias ka. To duma og-iling no sobuuk ka to diya kibali mgo ba-ba to Diyus to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Na sikiyu,” kagi ni Jesus, “nokoy man to ogkaikagi now bahin kanay? Hintawa a man?” Si Pedro to migtabak, “Sikuna to diya Insaad no Manyuyuwas no ogpaharion to Diyus to kaotawan din.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na, pigbahog sikandan ni Jesus no wada ognangonan dan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Dajun sugud si Jesus to paghisgut duon to mgo inanad din bahin to ogkadeygan din, “Kinahangyan no siak no Anak to Otow og-antus yagboy. Ogtalikudan a to yabow no mgo magdudumaya to tinuuhan ta dow to mgo maistru to tinuuhan hasta to inila no angod ta no mgo Hibru. Kinahangyan no himatajan a, di ogkabanhaw a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wada lipod-lipod to paghisgut din to ogkahitabu. Pagdinog ni Pedro to sikan, impadiyu-diyu din si Jesus aw ikagihi, “Kona ka og-ikagi to angod!” ");
INSERT INTO msmNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Piglingi ni Jesus to duma no mgo inanad din aw ipanagda si Pedro. Kagi din, “Yaguji a Satanas, su pig-otawan to hona-hona nu, kona no kaning Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Dajun sabiha ni Jesus to kaotawan hasta to mgo inanad din aw ikagihi, “Inggad hintawa no ogpasakup kanay, kinahangyan ojowan din to kagustuhon din aw tiang to krus din aw unung kanay. ");
INSERT INTO msmNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Su to otow no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay aw ognawnangon to Madojow no Nawnangonon inggad igkamatoy din nasi ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inggad pananglit maangkon to otow to tibo kadatu kani to kalibutan, nokoy man to pues din to sikan ko magawangan sikandin to kinabuhi aw makastigu to wada katapusan? ");
INSERT INTO msmNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Su wada yagboy inggad nokoy no yabow to kamahal kay to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","To mgo otow kuntoon, mgo makasasaya no migtalikud to Diyus. Na, ko igkasikow a dan, igkasikow ku isab sikandan ko mupauli a dini no ogkasul-uban to kasilow to Diyus no Amoy ku aw ogdumahan a to mgo anghil din.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Migpadajun si Jesus to pag-ikagi, “Ligdongi now seini. Meyduon duma kani iyu no monang da ogkangkamatoy ko maaha dan no ogsugud on to gamhanan no paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pagyaboy to onom no aedow, pigpaduma ni Jesus si Pedro, si Santiago dow si Juan. Migpapaawoy sikandan to paggamat to matikang no bubungan. No duon on sikandan, pigkita dan no naisab si Jesus, ");
INSERT INTO msmNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","aw inggad to kabo din ogpakasilow yagboy to kaputi. Wada maglabahay kani to babow to kalibutan no ogpakapaputi to angod to diya no kaputi. ");
INSERT INTO msmNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na, puli nakatokow pigkita dan si Elias dow si Moises no migpaggilaung ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dajun ikagihi ni Pedro si Jesus, “Sir, madojow su kani ki. Oghinang koy to tatoyu no ka hoyunganan, sobuuk to ikow, sobuuk to ki Moises dow sobuuk to ki Elias.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Di angod to pigdaham-daham si Pedro su pigkobaan sikandin dow to mgo duma din. ");
INSERT INTO msmNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na, meyduon gabun no natuntun duon kandan, aw meyduon pigdinog dan no kagi no napuun duon to sikan gabun no mig-iling, “Anak ku seini no pinadajag. Paminog kow kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Dajun sikandan palingap-lingap, di iyan nanda pigkita dan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Pagtogbang dan on likat to sikan bubungan, pigbahog sikandan ni Jesus no kona dan ignangon sikan pigkita dan kotob no sikandin no Anak to Otow kona pad mabanhaw. ");
INSERT INTO msmNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kaling pighipidan dan duon to ginhawa dan sikan nahitabu, di migpauusipay sikandan no tatoyu dow nokoy to igpasabut to sikan pig-ikagi din no ogkabanhaw sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pig-usip dan si Jesus, “Nokoy naan no nang-anad man to mgo maistru to tinuuhan ta no ayha ogyogwa to diya Insaad no Manyuyuwas ko una pad ogpauli si Elias dini to kalibutan?” ");
INSERT INTO msmNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Migtabak si Jesus, “Tinood iyan no og-una si Elias to paghinaat to mgo otow to pagtidow ku. Na, su tinood sikan, nokoy man to hona-hona now to diya pig-iling duon to Kasuyatan no ogpaantuson a no Anak to Otow dow og-ojowan? ");
INSERT INTO msmNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Di seini da. Mig-andinid on si Elias, di pigpaantus dan isab kotob to naliyagan dan, su nasuyat isab sikan duon to Kasuyatan.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pagkayogsad ni Jesus dow mgo duma din, pigkita dan no piglilibongan sikan duma no mgo inanad to mahan-in hilabi no kaotawan, aw mey mgo maistru to tinuuhan no migpagdibati kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pagkita to sikan tibo mgo otow ki Jesus, hilabi sikandan naboyong aw miglinaguy to pagtagbu kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dajun usip si Jesus, “Nokoy man to duon ogdibatihan now?” ");
INSERT INTO msmNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sobuuk to sikan mahan-in no mgo otow migtabak, “Sir, pigdae ku to anak ku dini ikow agun padojawon nu, su pigsamuk to madoot no ispiritu no nakapapoha kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ko ogpadamaan sikandin, ogpakayapdos duon to pasak, ogbubuya to ba-ba, ogkagot to ngipon aw ogliskog sikandin. Pighangyu ku to mgo inanad nu no abugon dan sikan madoot no ispiritu, di wada dan kahimu-i.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Dajun ikagihi ni Jesus sikan mgo otow, “E-ay, sikiyu no mgo otow kuntoon, wada pagsalig now to Diyus. Andei man ogkakotob to pagduma-duma ku iyu? Kagan-u man ogkatapus seini pag-antus ku iyu? Na, daeha dini sikan bata.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dajun dan daeha sikan bata duon ki Jesus. Pagkita to sikan madoot no ispiritu ki Jesus, pigpadamaan din dajun sikan bata. Nakayapdos sikandin aw kababalikid no migbubuya to ba-ba. ");
INSERT INTO msmNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Dajun usipa ni Jesus sikan amoy, “Napilaan on man to pagkailing din?” Migtabak sikan amoy, “Wotey! Sugud da no maintok pad. ");
INSERT INTO msmNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kona no kapila da sikandin isugba to sikan ispiritu duon to kaeju aw itimbag duon to wohig su oghimatajan. Na, ko mahimuan nu, sadangay kae-ati aw tabangi koy.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Kagi ni Jesus, “Nokoy no og-iling ka man to, ‘ko mahimuan nu’? Wada inggad nokoy no kona ogkahimuan to Diyus to pagtabang to otow no ogsalig kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Dajun ikagi sikan amoy to maagbot, “Migsalig a ikow di kuyang pad. Dugangi seini pagsalig ku.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na, pagkita ni Jesus no migdinali to kaotawan to pagduguk, pigsugu din dajun sikan madoot no ispiritu, “Sikuna no ispiritu no ogpamongey aw ogpamoha to otow, yaguji seini bata aw kona kad yagboy ogpauli.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Dajun pangiyak sikan madoot no ispiritu aw padama-i din sikan bata ayha din yaguji. Pagsibogid to sikan bata, angod to nagawangan to ginhawa, kaling nakailing to mahan-in no mgo otow, “Aduy, patoy on kay buwa!” ");
INSERT INTO msmNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Di pigtagonan ni Jesus to boyad din aw pabanguna, dajun sikandin nakatindog. ");
INSERT INTO msmNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Anoy man no migsed on si Jesus duon to bayoy aw wadad on to diya mgo otow, nangusip to mgo inanad din, “Nokoy no wada noy man kaabug to diya madoot no ispiritu?” ");
INSERT INTO msmNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Migtabak si Jesus, “To madoot no ispiritu no angod to diya ogkaabug pinaagi da to pag-ampu.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na, migpanow onsi Jesus aw andiya to prubinsya to Galilea. Ogkaliyag si Jesus no wada ogkamaan dow andei sikandin, ");
INSERT INTO msmNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","su iyan da og-anadon din sikan mgo inanad. Kagi din, “Siak no Anak to Otow igdata diya to mgo otow no oghimatoy kanay. Di ogkabanhaw a da to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Di wada dan kasabuti sikan pig-ikagi din, aw nataha sikandan to pag-usip. ");
INSERT INTO msmNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Migtidow onsi Jesus duon to yunsud to Capernaum. No diyad on sikandan to bayoy, pig-usip din to mgo inanad, “Nokoy man to diya pigyayalisan now ganina duon to pangindaenan?” ");
INSERT INTO msmNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Di nasikow sikandan tabak su iyan man pigyayalisan dan dow hintawa to yabow duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dajun ingkud si Jesus aw papadaniha sikan sampuyu-tag-duwa no mgo inanad. Kagi din, “Inggad hintawa no ogkaliyag ogyabow, kinahangyan no mupaobos aw alagad to tibo.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Dajun pudut si Jesus to bata aw patindoga duon to kabaknaan dan. Piggogey din aw ikagihi to mgo inanad, ");
INSERT INTO msmNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Inggad hintawa no ogdawat to obos no sakup ku no angod to seini bata, kibali siak to ogdawaton. Aw to otow no ogdawat kanay kibali ogdawat to sikan migpaandini kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mig-ikagi si Juan ki Jesus, “Sir, migkita koy to otow no nang-abug to mangkadoot no ispiritu no iyan piggamit to ngadan nu. Di manno kona ta sikandin no sakup, pigsapadan noy.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kagi ni Jesus, “Wada now podom sapadi, su inggad hintawa no oggamit to ngadan ku to paghinang to milagru kona dajun ogpakadoot-doot kanay. ");
INSERT INTO msmNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Su inggad hintawa no kona ogsupak ita ogkatawag no duma ta. ");
INSERT INTO msmNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ligdongi now seini,” kagi ni Jesus. “To otow no ogpainom iyu to inggad songo basu da no wohig su migpasakup kow kanay no Insaad no Manyuyuwas, ogbayosan sikandin to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Migpadajun si Jesus to pag-ikagi, “To otow no ogpakaamung to pagpakasae to obos no sakup ku, mabog-at yagboy to kastigu no igpahamtang kandin. Tapat pad ko pigteybatuhan sikandin to mae-gatung no galingan no batu aw itimbag diya to dagat agun wada ogpakasae tongod kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ko sikan boyad nu iyan ogpakaamung to pagpakasae nu, tampoda. Inggad pupue ka basta maangkon nu to kinabuhi no wada katapusan kuntra ko daduwa to boyad nu no igsugba ka diya to impernu, duon to sikan kaeju no wada pagkaposok. ");
INSERT INTO msmNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ko sikan kobong nu iyan ogpakaamung to pagpakasae nu, tampoda. Inggad sobuuk nanda to kobong nu basta maangkon nu to kinabuhi no wada katapusan kuntra ko daduwa to kobong nu no igsugba ka diya to impernu. ");
INSERT INTO msmNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ko sikan mata nu iyan ogpakaamung to pagpakasae nu, yugita. Inggad sobuuk nanda to mata nu basta masakup ka duon to gingharian to Diyus, kuntra ko daduwa to mata nu no igsugba ka diya to impernu. ");
INSERT INTO msmNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Su to pag-antus to mgo otow duon wada yagboy katapusan. Su to mgo iyas duon no ogkotkot to yawa dan kona yagboy ogkamatoy, aw to kaeju wada pagkaposok. ");
INSERT INTO msmNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","To tibo mgo otow no ogpakaanduon ogdoot yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Na,” kagi ni Jesus, “madojow to asin. Di ko pananglitan mutab-as sikan, og-amonuhon pad to pagpabalik to lami? Kaling paningkamoti no meyduon kagana to rilasyun now, aw tagoni now kanunoy to kalinow.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Piglikatan ni Jesus sikan no banwa aw baja duon to dihipag to Jordan no wohig su og-andiya to prubinsya to Judea. Mahan-in to mgo otow no nahimun duon kandin, aw pigpang-anad din sikandan su iyan nabatasan din. ");
INSERT INTO msmNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Meyduon isab mgo Pariseo no mig-anduon ki Jesus su ogtogkadon dan. Mig-usip sikandan, “Igtugut to tinuuhan ta no ojowan to asawa?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Migtabak si Jesus, “Nokoy man to insugu ni Moises bahin to sikan?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Kagi dan, “Intugut din basta bogajan sikan asawa to kalig-onan to pagbiya.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Di mig-ikagi si Jesus, “Pigtugutan kow ni Moises tongod to kadoson to uyu now. ");
INSERT INTO msmNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Di diya to sinugdanan no hinangon to Diyus to otow, pighinang din to yukos dow bohi. ");
INSERT INTO msmNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kaling man, ogyuwat to yukos to amoy dow inoy din aw ogpagsaboka to asawa din ");
INSERT INTO msmNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","su sikandan no daduwa ogkasaboka on man. ");
INSERT INTO msmNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kaling man sikan pigsaboka to Diyus kona ogpagbiyaon.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","No diyad on sikandan to sed to bayoy, mig-usip isab to mgo inanad ki Jesus bahin to pagbibiya. ");
INSERT INTO msmNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Migtabak si Jesus, “To otow no og-ojow to asawa din aw ogpangasawa to yain, ogpakasae sikandin to sikan una no asawa din, su kibali nakapanghonay sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","To bohi isab no og-ojow to bana din aw babana to yain, kibali nakapanghonay.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mey mgo otow no migdae to mgo anak dan duon ki Jesus agun sampoyongan. Di pigsapadan sikandan to mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Pagkita ni Jesus to sikan, naboyu sikandin aw ikagihi to mgo inanad, “Tuguti sikan mgo bata to pag-andini kanay. Kona now ogpogongan su iyan ogkaharian to Diyus to mgo otow no angod kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Indani now seini,” kagi din. “Inggad hintawa no kona ogdawat to paghari to Diyus angod to dinawatan to bata kona yagboy ogkasakup duon.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Dajun din tinagsabokaha to paggiba sikan mgo bata aw sampoyongi dow panghinaut no madojawan sikandan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Anoy man no oglikat on si Jesus, mey otow no miglinaguy diya kandin aw yuhud duon to atubangan din. Kagi din, “Sir, madojow ka no otow. Nokoy man to oghinangon ku agun no maangkon ku to kinabuhi no wada katapusan?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Kagi ni Jesus, “Hona-honaa to igpasabut to sikan og-ilingon nu no madojow a. Su namaanan ta no Diyus da on to madojow. ");
INSERT INTO msmNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Namaanan nud isab to mgo balaod din no pig-iling, ‘Kona ka oghimatoy to otow, kona ka ogpanghonay, kona ka ogpangawat, kona ka ogpangistigus to gayu, kona ka ogpanlimbung aw tahuda to amoy dow inoy nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Sir,” kagi to sikan otow, “Pigtuman kud sikan tibo sugud pad to pagkabata ku.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pigyongyongan ni Jesus sikan otow dae to gugma aw ikagihi, “Sobuuk pad to kuyang nu. Ibaligja to mgo katigajunan nu aw to halin ipamogoy to mgo pubri. Na, meyduon ogkapaabut nu no bayos diya to yangit. Dajun ka pauli dini aw duma kad kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pagdinog to sikan otow to kagi ni Jesus, naguul sikandin aw migpanow no migsakit to ginhawa su sapian yagboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Dajun lingi-a ni Jesus to mgo inanad din aw ikagihi, “Pagkalisod yagboy to sapian to pagpasakup to sikan ogharian to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","To mgo inanad ni Jesus naboyong yagboy to sikan pig-ikagi din, di migpadajun sikandin to pag-ikagi, “Mgo anak, pagkalisod yagboy to pagpasakup to sikan ogharian to Diyus! ");
INSERT INTO msmNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ko malisod on man to kamel to pagyawang duon to yugi to dagum, iyan on man to sapian no otow ko kona malisodan to pagpasakup to sikan ogharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pagdinog to mgo inanad to sikan, migdugang pad yagboy to pagkaboyong dan aw migpauusipay, “Hintawa da man naan to ogkayuwas?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Di pigyongyongan sikandan ni Jesus aw ikagihi, “Kona seini ogkahimuan to otow, di to Diyus, ogkahimuan din to tibo.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Dajun ikagi si Pedro, “Na, sikami naan, pig-ojowan noy on to tibo su ogduma koy on ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Kagi ni Jesus, “Hoo iyan, di ligdongi now seini. Inggad hintawa no og-ojow to bayoy din, mgo suun no yukos dow bohi, inoy dow amoy, mgo anak din ubin uma tongod kanay dow tongod to Madojow no Nawnangonon, ");
INSERT INTO msmNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ogbayosan sikandin to Diyus. Inggad kuntoon no kani pad sikandin to kalibutan, ogkadawat din to yabow pad yagboy no mgo bayoy, mgo suun no bohi dow yukos, mgo inoy, mgo anak dow mgo uma. Ogbogajan isab sikandin to kinabuhi no wada katapusan diya to umaabut no panahon. Di ko dini pad to kalibutan, ogbaja isab sikandin to mgo pag-antus. ");
INSERT INTO msmNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Di mahan-in to mgo otow no yabow kuntoon no igpaobos. Mahan-in isab to obos no ogpayabawon.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na, anoy man no duon on si Jesus to pangindaenan duma to mgo inanad din pailing diya to Jerusalem, mig-una-una sikandin. Kaling naboyong to mgo inanad din, aw nangkahaedok to duma no mgo otow duon to hudihan din. Pigpapadani ni Jesus sikan sampuyu-tag-duwa no mgo inanad din su ognangonan din sikandan to ogkadeygan din. ");
INSERT INTO msmNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Oho,” kagi din, “ogpailing kinow on diya to Jerusalem. Ko diya kid on, siak no Anak to Otow igdata diya to yabow no mgo magdudumaya to tinuuhan ta. Oghukuman a dan to kamatajon aw igdata a diya to mgo otow no kona no mgo Hibru no wada tahud to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oghinangon a dan no kangisihanan. Og-iloban a aw panyapdosi, dow tapus to sikan, oghimatajan a. Di ogkabanhaw a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na, si Santiago dow si Juan no mgo anak ni Sebedeo migpadani ki Jesus aw ikagi, “Sir, meyduon podom oghangyuon noy ikow.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Kagi ni Jesus, “Nokoy man podom sikan?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kagi dan, “Oghangyu koy podom ikow no sikami to soingon nu duon to gingharian nu, sobuuk duon to kalintuu nu aw sobuuk isab duon to kawae nu.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Di mig-ikagi si Jesus, “Wada kow kamaan to sikan pighangyu now. Og-usipon ku sikiyu, ogpakaaguwanta kow buwa to mgo antusonon no ogbajaan ku?” ");
INSERT INTO msmNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Migtabak sikandan, “Hoo.” Kagi ni Jesus, “Tinood man iyan no ogpakabaja kow to mangkalisod no ogbajaan ku, ");
INSERT INTO msmNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","di bahin to pagsoing kanay, kona no siak to ogpakaboot dow hintawa to ogpaingkudon duon to kalintuu dow kawae ku. Iyan da ogpakasoing kanay to diya pighinaatan to Diyus to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pagdinog to sikan sampuyu no mgo inanad to sikan hangyu ni Santiago dow ni Juan, naboyu sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kaling pighimun ni Jesus to tibo mgo inanad din aw ikagihi, “Namaan kow to batasan to sikan og-isipon no mgo magmamandu to yain-yain no mgo tribu. Ogpamayabi-yabi sikandan to mgo sakup dan aw ogdaog-daogon. ");
INSERT INTO msmNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Di kona kow ogpag-angod kandan. Nasi no inggad hintawa iyu no ogkaliyag ogyabow, mupaobos nasi sikandin aw alagad to duma. ");
INSERT INTO msmNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","To otow isab no ogkaliyag no mahinang no panguyu, mupaobos nasi sikandin angod to udipon aw alagad to duma. ");
INSERT INTO msmNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Su ngani a man no Anak to Otow, di wada a andini agun alagadon. Nasi no iyan ing-andini ku to pag-alagad to duma dow agun mamatoy a to pagyokat to mahan-in no mgo otow no naudipon to sae.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Migtidow si Jesus dow mgo inanad din diya to yunsud to Jerico, aw paglikat dan, mahan-in yagboy to mgo otow no migduma kandan. Na, meyduon migpalimus no buta no mig-iingkud duon to kilid to dayan. Iyan ngadan din si Bartimeo no anak ni Timeo. ");
INSERT INTO msmNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pagdinog din no migbaja si Jesus no taga-Nazaret, nanawag sikandin to maagbot, “Jesus no Kaliwat ni Hari David, sadangay kae-ati a!” ");
INSERT INTO msmNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pigsapadan sikandin to mahan-in no mgo otow agun ogpahonok, di nasi din pigpak agbotan to pagtawag, “Kaliwat ni Hari David, sadangay kae-ati a!” ");
INSERT INTO msmNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Dajun sigkon si Jesus to pagpanow aw ipasabi sikan buta. Dajun dan sabiha aw ikagihi, “Na, tukhow kad. Tindog ka su impasabi ka.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Hinggawan sikandin migtindog aw iwakli sikan aapid din no kabo dow andiya ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Mig-usip si Jesus, “Nokoy man to igpahinang nu kanay?” Migtabak sikan buta, “Sir, ogkaliyag a podom no ogkita ad on.” ");
INSERT INTO msmNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Na,” kagi ni Jesus, “panow kad su to pagsalig nu kanay iyan nakadojow ikow.” Duon-dajun migkita sikan otow aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","No madani on sikandan to Jerusalem, ogkaaha dan on to mgo yunsud to Betpahe dow Betania duon to bugdangan to Kaulibuhan no bubungan. Dajun sugu si Jesus to daduwa no mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Andutun kow to suja baryu. Pagtidow now duon, ogkita kow dajun to inhikot no nati no asnu no wada pad disti kasakaji. Hubada aw tujuka dini kanay. ");
INSERT INTO msmNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ko meyduon ogsagman iyu, ilingi now no ogkinahangyanon seini to Ginuu, di madali da ig-uli.” ");
INSERT INTO msmNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dajun panow sikan daduwa. Pagtidow dan, pigkita dan iyan sikan nati no asnu no inhikot duon to pertahan to bayoy duon to kilid to karsada. Anoy man no oghubadon dan on, ");
INSERT INTO msmNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","mey mgo otow no migsagman kandan. Kagi pa, “Nokoy no oghubadon now man sikan nati?” ");
INSERT INTO msmNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iyan intabak dan to intugun ni Jesus, kaling pigtugutan dajun sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Dajun dan tujuka sikan nati diya ki Jesus. Inhanig dan to pig-apid dan no kabo duon to talikudan to nati aw dajun sakoy si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mahan-in to mgo otow no migbukyad isab to ing-apid dan no mgo kabo aw ihanig to ogbajaan din. To duma namanagkas to mgo dodohunan diya to mgo uma aw ihanig dan isab. ");
INSERT INTO msmNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Namanguliya sikan tibo mgo otow no migduma ki Jesus duon to unahan dow duon to hudihan, “Sajaon ta to Diyus! Sajaon seini pigpaandini din ita! ");
INSERT INTO msmNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kadojow gajod to ogpaabuton ta no paghari to seini Kaliwat ni Hari David no minuna ta! Sajaon yagboy to Diyus diya to yangit!” ");
INSERT INTO msmNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pagtidow ni Jesus diya to Jerusalem, migpadajun sikandin duon to Bayoy to Diyus aw panhiling-hilinga din to tibo duon. Dajun yuwas sikandin dow sikan sampuyu-tag-duwa no mgo inanad din aw pauli diya to baryu to Betania su mahapun on. ");
INSERT INTO msmNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pagkabukas, miglikat sikandan to Betania su ogpauli diya to Jerusalem. Duon pad sikandan to pangindaenan, pigbontas on si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na, diya to kadiyuan migkita sikandin to kaju no igera no madabu to dohun. Pig-anduon din su og-ahaon dow mey bogas. Di dohun da to pigkita din su kona pad no tigbobogas. ");
INSERT INTO msmNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Dajun tubadi ni Jesus sikan igera, “Sugud kuntoon, kona kad on ogpakabogas.” Na, pigdinog to mgo inanad din sikan pig-ikagi din. ");
INSERT INTO msmNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pagtidow dan diya to Jerusalem, mig-isab si Jesus mig-andiya to Bayoy to Diyus aw pang-abuga din to mgo otow no namoli aw namaligja duon. Aw pamaliskada din to mgo lamisa to mgo magsinsilyuhay to saepi dow mgo ingkudanan to diya namaligja to salapati no ighalad. ");
INSERT INTO msmNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wada otow no pigtugutan din to pagpanyaktod duon to pawa to sikan Bayoy to Diyus no ogdae to inggad nokoy da. ");
INSERT INTO msmNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Dajun din pang-anada to mgo otow duon. Kagi din, “Meyduon impasuyat to Diyus no pig-iling, ‘To bayoy ku og-ilingon to ampuanan to mgo sakup to yain-yain no mgo nasyun.’ Di pighinang now no kampu to mgo tulisan!” ");
INSERT INTO msmNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sikan no hitabu pigdinog to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan. Kaling mighona-hona sikandan dow og-amonuhon dan agun mahimatajan si Jesus su nahaedok sikandan kandin, su to tibo mgo otow naliyag to pagpang-anad din. ");
INSERT INTO msmNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Anoy man no madidigyomay on, migyuwas si Jesus to siyudad dow mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pagkabukas, no ogpauli on si Jesus dow mgo inanad din diya to siyudad, pigkita dan no patoy on sikan igera no pigtubadan ni Jesus yakip to mgo dalid. ");
INSERT INTO msmNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na, pagkadomdom ni Pedro to diya tubad ni Jesus to sikan igera, mig-ikagi sikandin, “Sir, aha ka. Patoy on suja igera no pigtubadan nu gabii!” ");
INSERT INTO msmNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Kagi ni Jesus, “Saligi to Diyus ");
INSERT INTO msmNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","aw ligdongi now seini. Ko mey otow no ogsugu to suja bubungan, ‘Kayukat ka duon aw patiagdang ka dutun to dagat,’ ogkatuman sikan basta wada pagduwa-duwa to pagtuu din. ");
INSERT INTO msmNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Angod isab to sikan, inggad nokoy to ogbujuon now to Diyus, tuuhi no imbogoy din on iyu. Su ko mutuu kow, ogkadawat now yagboy to ogbujuon now. ");
INSERT INTO msmNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na, ko og-ampu kow di mey otow no ogpakadoot to ginhawa now, unaha sikandin pasayluha ayha kow ampu. Na, ogpasayluhon kow isab to Diyus no Amoy now diya to yangit.” ");
INSERT INTO msmNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na, migtidow on isab onsi Jesus diya to Jerusalem. No mighihipanow si Jesus duon to Bayoy to Diyus, migduguk to yabow no mgo magdudumaya to tinuuhan dan, mgo maistru to tinuuhan dow duma no inila no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Kagi dan, “Nokoy man to katongod nu to pagpanghinang to diya? Hintawa man to migbogoy ikow to sikan no katongod?” ");
INSERT INTO msmNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Migtabak si Jesus, “Meyduon isab ig-usip ku iyu. Ko tabakon a now, ognangonan ku sikiyu dow nokoy to katongod ku to pagpanghinang to diya. ");
INSERT INTO msmNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Na, to diya pagpamawtismu ni Juan, hintawa man to migbogoy kandin to sikan no katongod? Diyus ko otow? Nangoni a.” ");
INSERT INTO msmNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dajun sikandan sasabut dow og-amonuhon dan to pagtabak. Kagi dan, “Ko muiling ki no Diyus to migbogoy ki Juan to katongod, ogsukatan ki din dow nokoy no wada ki tuu ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aw ko muiling ki no pig-otawan to katongod din, adoy!” Nahaedok sikandan to kaotawan su tibo man migtuu no si Juan kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kaling iyan da intabak dan ki Jesus to, “Indoy, wada koy kamaan.” “Na,” kagi ni Jesus, “kona ku isab sikiyu ognangonan dow andei kapuun to katongod ku to pagpanghinang to diya.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dajun ikagi si Jesus to pananglitan duon to mgo otow no nahimun, “Meyduon otow no migtanom to ubas duon to uma din. Piglibong din to kural aw hinangi to pogaanan to bogas to ubas dow turi no bantajanan. Tapus to sikan, pigpasaupan din aw panow diya to madiyu. ");
INSERT INTO msmNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Anoy man no oggunuon on to mgo ubas, migsugu sikan tag-iya to suguonon din to pagpudut to kabahinan din. ");
INSERT INTO msmNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Di pagtidow to sikan sinugu, dajun sikandin bukbuka to sikan mgo saup aw pabalika no ampan dae. ");
INSERT INTO msmNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dajun isab sugu sikan tag-iya to yain no suguonon, di pigpapakuy sikandin aw pakasikawi. ");
INSERT INTO msmNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tapus to sikan, yain isab no suguonon to pigsugu to sikan tag-iya, di pighimatajan dan. Mahan-in pad to duma no pigsugu to sikan tag-iya, di meyduon pigbukbuk dan, aw to duma pigpanghimatajan. ");
INSERT INTO msmNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Na, iyan nanda wada kasugu to pinadajag din no anak. Sikandin to katapusan no pigsugu su ginhawa din, ‘Ogtahudon dan man yagboy seini anak ku.’ ");
INSERT INTO msmNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Di pagkita kandin to sikan mgo saup, mig-iling sikandan, ‘Suja anak to ogpakairinsya to seini ubasan ko mamatoy to amoy din. Na, oghimatajan ta isab agun ita on seini.’ ");
INSERT INTO msmNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dajun dan himataji aw itimbag diya to yuwas to ubasan. ");
INSERT INTO msmNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Na,” kagi ni Jesus, “to paghona-hona now, og-amonu man sikan tag-iya? Og-andiyaon din sikan mgo saup aw panghimataji. Pagkatapus, ogpasaupan din sikan ubasan to yain no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ajaw og-ilinga no wada kow makabasa to Kasuyatan to Diyus no pig-iling, ‘Sikan batu no pig-ojowan to mgo pandoy su nailing to boot dan no wada pues iyan nasi indigon to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Trabahu sikan to Ginuu aw igkatingaya ta yagboy.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pagdinog to sikan mgo inila to tinuuhan to pananglitan ni Jesus, nasabutan dan no sikandan to pig-igu. Kaling ogdakopon dan podom sikandin, di nahaedok sikandan to mgo otow no naminog kandin. Dajun panow sikan mgo inila. ");
INSERT INTO msmNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wada kayugoy, pigsugu dan diya ki Jesus to mgo Pariseo hasta to mgo sakup to partidu ni Hari Herodes agun no mabitik dan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pigduguk dan si Jesus. “Sir,” kagi dan, “namaan koy no matinod-anon ka aw matuud yagboy to impang-anad nu bahin to pagtuman to Diyus. Inggad hintawa to igpag-atubang nu, pinag-angod nu to pagpang-anad kandan su wada ogpayabihon nu. Na,” kagi dan, “meyduon ig-usip noy ikow. Kona buwa no supak to tinuuhan ta to pagbajad to buhis diya to hari to Roma? Ogbajad ki ko kona?” ");
INSERT INTO msmNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Di namaan si Jesus no madoot to tuud dan, kaling pig-ikagihan din sikandan, “Nokoy no og-antihan a now man? Mey saepi now duon? Aha ki.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dajun dan tadwaji si Jesus to saepi. Mig-usip si Jesus, “Hintawa man bayhu dow ngadan to nakabotang kani?” Migtabak sikandan, “Kaning hari to Roma.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Na,” kagi ni Jesus, “ibogoy diya to hari to kaning hari, aw ibogoy isab diya to Diyus to kaning Diyus.” Hilabi sikandan naboyong to sikan pagtabak din. ");
INSERT INTO msmNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tapus to sikan, meyduon isab mgo Saduseo no mig-anduon ki Jesus su ogpangusip. Na, sikan no mgo otowa naman-iling no kona ogkabanhaw to mgo patoy. ");
INSERT INTO msmNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Kagi dan, “Sir, mig-iling to balaod no imbilin ni Moises ita no ko mamatoy to otow no ogkabilin to asawa no wada pad anak, kinahangyan asawahon to suun din sikan bohi agun meyduon ogkailing no liwat to diya namatoy. ");
INSERT INTO msmNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Na, igpananglit ta to pitu no migsusuun no mgo yukos. Naminyo sikan panganoy, di wada pad anak dan, namatoy on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sikan migsunu naminyo to sikan bayu aw namatoy isab no wada anak. Angod da isab to nahitabu to sikan ikatoyu no suun. ");
INSERT INTO msmNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na, yaktod no pagkaikagi, sikan pitu no migsusuun tibo nakaasawa to sikan bohi aw tibo sikandan namatoy no wada anak. To katapusan namatoy isab sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Na, ojow nu pa, ogbanhawon to mgo patoy. Ko matuman on sikan, hintawa man yagboy to sikan pitu to ogkatawag no tag-asawa to sikan bohi, su tibo man sikandan nakaasawa kandin?” ");
INSERT INTO msmNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Migtabak si Jesus, “Pagkasajop now yagboy! Su wada kow makasabut to Kasuyatan to Diyus dow to gahom din. ");
INSERT INTO msmNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Su ko banhawon on to mgo patoy, wadad on og-inasawahay, su ogkaangod on man sikandan to mgo anghil diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na, sikiyu no kona ogtuu no ogkabanhaw to mgo patoy, ajaw og-ilinga no wada kow makabasa to sinuyat ni Moises bahin to diya masagkop no kaju no duon sikandin ikagihi to Diyus no mig-iling, ‘Siak to Diyus no iyan ogsimbahon ni Abraham, ni Isaac dow ni Jacob.’ ");
INSERT INTO msmNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Migpasabut no inggad nayugoy da kamatoy sikan no mgo otow, buhi sikandan diya to yangit aw ogpadajun to pagsimba to Diyus. Su to mgo patoy konad ogsimba to Diyus, mgo buhi da. Kaling nasajop kow yagboy,” kagi ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Meyduon maistru to tinuuhan no nakaanduon dow migdinog to pagbitik podom ki Jesus. Pagpaniid din no madojow to pagkatabak ni Jesus to sikan mgo Saduseo, migpadani sikandin aw usip, “Duon to sikan tibo mgo balaod to Diyus, andei man to pinakaimpurtanti?” ");
INSERT INTO msmNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Migtabak si Jesus, “Sikan pinakaimpurtanti no sugu pig-iling, ‘Sikiyu no mgo kaliwat ni Israel, paminog kow. To Ginuu no Diyus ta sobuuk da. ");
INSERT INTO msmNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Higugmaon now sikandin to bug-us no ginhawa dow hona-hona now aw tibuuk no kinabuhi dow doson now.’ ");
INSERT INTO msmNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aw seini to ikaduwa no pinakaimpurtanti no sugu: ‘Higugmaa to isigkaotow now angod to paghigugma to kaugalingon now.’ Wada inggad nokoy no sugu no ogyabow pad to seini daduwa.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kagi to sikan maistru, “Madojow to pagkatabak nu Sir. Matuud iyan to pig-ikagi nu no sobuuk da to Diyus aw wadad on yain. ");
INSERT INTO msmNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tinood isab to pig-ikagi nu no kinahangyan higugmaon ta sikandin to bug-us no ginhawa dow hona-hona dow doson ta, aw kinahangyan higugmaon ta to isigkaotow ta angod to paghigugma to kaugalingon ta. Sikan daduwa no mgo sugu yabow no impurtanti kay to paghalad to ogtutungon no mgo mananap dow to duma no igbogoy diya to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pagdinog ni Jesus to sikan madojow no pagkaikagi to sikan maistru, mig-iling sikandin, “Madani kad ogkasakup to sikan ogharian to Diyus.” Tapus to sikan, wadad on migyangub to pagpangusip ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","No mang-anad si Jesus duon to Bayoy to Diyus, mig-ikagi sikandin, “Nang-anad to mgo maistru to tinuuhan ta bahin to diya Insaad no Manyuyuwas. Na, nokoy no og-iling man sikandan no kaliwat puli sikandin ni Hari David ");
INSERT INTO msmNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","no si David no manduan to Ispiritu Santu iyan man yagboy mig-iling, ‘To Ginuu no Agayon ku pig-ikagihan to Diyus, Ingkud ka kani to kalintuu no takidingan ku kotob no daogon ku yagboy to mgo kuntra nu aw makayuhud duon to atubangan nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kagi ni Jesus, “Manno Agayon to intawag ni David to sikan Insaad no Manyuyuwas, nokoy no ogkailing man no kaliwat puli sikandin ni David?” Tibo nalipay to kaotawan to pagpaminog ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Duon to pagpang-anad ni Jesus, mig-ikagi sikandin, “Bantoy kow to mgo maistru to tinuuhan ta. Ogganahan sikandan ogpangabo to mahaba aw pakita-kita, aw ogtukhow ko pakitaon to pagtahud duon to karsada. ");
INSERT INTO msmNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ko duon sikandan to pagkoonan dow ko diya isab to simbahan, ogkaliyag sikandan og-ingkud duon to ingkudanan no ighinaat to mgo inila. ");
INSERT INTO msmNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Di ogpangyupig sikandan to bayu no mgo bohi agun maagow to katigajunan dan, aw sikan madoot no hinang dan ogtakyuban to mahaba no mgo pag-ampu. Kaling kahaedokanan yagboy to kastigu no igpahamtang kandan.” ");
INSERT INTO msmNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","No duon pad si Jesus to Bayoy to Diyus, mig-iingkud sikandin duon to naatubangan to taguanan to halad, aw pigsayapan din to mgo otow no namanhalad duon. Mahan-in to mgo sapian no nang-uyug to madogi no saepi duon. ");
INSERT INTO msmNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Monok on no meyduon bohi no bayu no pubri hilabi no iyan da ingkauyug to daduwa no mangkaintok no saepi. ");
INSERT INTO msmNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Dajun sabiha ni Jesus to mgo inanad din aw ikagihi, “Oho, to tibo mighalad, iyan yabow to halad to suja pubri no bohi. ");
INSERT INTO msmNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Su tibo sikandan migbogoy to subra dan, di suja bohi no ogkalisod-lisod, imbogoy din to tibo ogkabuhian din.” ");
INSERT INTO msmNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Anoy man no migyuwas on si Jesus duon to Bayoy to Diyus, mig-ikagi to sobuuk no inanad din, “Atu! Aha ka Sir, kadojow no og-ahaon seini Bayoy to Diyus hasta seini nakalibong. Tag-mae-gatung sikan tinibtiban no mgo batu no inghinang!” ");
INSERT INTO msmNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Kagi ni Jesus, “Seini natingaehan nu ogkagoba da. Su meyduon panahon no wada inggad sobuuk to sikan no mgo batu no ogkabilin duon to nabotangan, su ogtompagon tibo.” ");
INSERT INTO msmNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na, miggamat sikandan diya to Kaulibuhan no bubungan no dihipag to sikan Bayoy to Diyus. Anoy man no nakaingkud on si Jesus, migpadani si Pedro, si Santiago, si Juan dow si Andres no sikandan da aw usip ki Jesus, ");
INSERT INTO msmNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nangoni koy kun dow kagan-u ogkatuman sikan ognangonon nu. Nokoy man to ogkakiyayahan noy ko madani on ogkahitabu sikan tibo?” ");
INSERT INTO msmNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Dajun sugud si Jesus to pag-anad kandan. Kagi din, “Bantoy kow no kona kow malimbungan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Su mahan-in to gayuon no ogyogwa no ogdae to ngadan ku. Og-angkon no sikandan kun to diya Insaad no Manyuyuwas, aw mahan-in to ogpamasuwajon dan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ko makadinog kow to gera duon to dani now aw diya isab to kadiyuan, kona kow ogkahaedok. Kinahangyan no mahitabu sikan, di kona pad no iyan katapusan to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Su ogpagigirahay to mgo nasyun dow mgo gingharian. Mahan-in to mgo banwa no og-abuton to maagbot no tiyog dow bontas. Di sikan no mgo kalisod, sinugdanan pad puli, angod to bohi no og-anak no bag-u pad oghajodan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Bantoy kow,” kagi ni Jesus, “su ogpaatubangon kow duon to mgo husajan, dajun ogbun-ugon kow duon. Ogpaatubangon kow isab diya to mgo gubernadur dow hari tongod to pagtuu now kanay. Na, sikan on to panahon no ogpakalugar kow to pagpasabut kandan to Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Su kona pad og-abut to katapusan to kalibutan, kinahangyan no tibo mgo nasyun nangonan to sikan Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Na, ko pandakopon kow aw paatubangon diya to husajan, kona kow ogkalimuut to og-ikagihon now. Su duon to sikan no panahon, ogpahona-honaon kow to madojow no igtabak. Su to og-ikagihon now kona no iyu no kagi, di kaning Ispiritu Santu no igpabaja iyu. ");
INSERT INTO msmNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Duon to sikan no panahon,” kagi ni Jesus, “meyduon mgo otow no ogyuib to suun dan no ogtuu kanay agun hukuman to kamatajon. Meyduon isab mgo amoy no angod to sikan to oghinangon duon to mgo anak dan. Ogpakayangub ngani to mgo anak to pagpahimatoy to mgo ginikanan dan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ogkuntrahon kow to tibo kaotawan tongod to pagtuu now kanay. Di to otow no kona yagboy ogyobad to pagtuu, ogkayuwas.” ");
INSERT INTO msmNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Migpadajun si Jesus to pag-ikagi, “Na, meyduon pinakamaligsom no ogpandodoot no ogkuntrahon yagboy to Diyus. (Sikiyu no ogbasa to seini, panginsabuti now.) Na, ko kitaon now sikan duon to lugar no kona no angay kandin, mupakajabag on to tibo mgo otow kani to Judea pailing diya to kabubunganan aw hobong. ");
INSERT INTO msmNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","To otow no diya to yuwas to bayoy, ajaw on ogpaulia to pagpudut to inggad nokoy da. ");
INSERT INTO msmNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","To otow no diya to uma ajaw on isab ogpaulia to pagpudut to kabo din. ");
INSERT INTO msmNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kae-at to mgo magkabodos dow manggianak to sikan no panahon! ");
INSERT INTO msmNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kaling ampu kow no sikan no ogkahitabu kona makatapu to tinghagsiy, su ogkalisodan kow to pagyaguy, ");
INSERT INTO msmNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","su to mgo antusonon to sikan no panahon pinakamalisod. Wada pad nakaangod to sikan to kalisod sugud no hinangon to Diyus to kalibutan hangtod kuntoon, aw wadad on ogpakaangod to sikan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko kona minusan to Diyus sikan no panahon, wada inggad sobuuk no otow no ogkabilin no buhi. Di tongod to inabin din no mgo otow, pigbootan din no ogminusan sikan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Duon to sikan no panahon ko mey og-ikagi iyu, ‘Oho, seinid to diya Insaad no Manyuyuwas,’ ubin, ‘Sujad sikandin,’ kona kow ogtuu. ");
INSERT INTO msmNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Su mey ogpamanyogwa no ogpatuu-tuu no sikandan kun to diya Insaad no Manyuyuwas, aw to duma ogpatuu-tuu no kibali ba-ba sikandan to Diyus. Ogpakita ngani sikandan to mgo milagru dow duma no mgo kabeynganan pagmatuud no sinugu sikandan to Diyus agun no ko mahimu pa, pamasuwajon dan inggad to mgo otow no inabin on to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kaling,” kagi ni Jesus, “pakaalistu kow su pigpatahanan kud sikiyu.” ");
INSERT INTO msmNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Na duon to sikan no mgo aedow,” kagi ni Jesus, “ko maliwas on sikan kahaedokanan no mgo hitabu, konad on ogsiga to soga aw to buyan isab konad ogkitaon. ");
INSERT INTO msmNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","To mgo bituon ogkangkauyug, aw ogkahojong to tibo diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Dajun a ogkonsad no Anak to Otow no ogkaputus to mgo panganud, aw ogkitaon to mgo otow to pagkagamhanan ku dow to kasilow to pagka-Diyus ku. ");
INSERT INTO msmNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ogsuguon ku dajun to mgo anghil ku to paghimun to inabin ku no mgo otow likat to pig-ugpaan dan inggad andei no suyuk to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Paminog kow su igpananglit ku to kaju no igera. Ko musugud on sikan to pagpanalingsing, ogkamaanan now no madani on ogguyabung. ");
INSERT INTO msmNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Angod isab to sikan, ko maaha now no ogkatuman on to diya ognangonon ku, ogkamaanan now no madani ad ogpauli dini. ");
INSERT INTO msmNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ligdongi now seini. Kona pad ogkangkamatoy to tibo mgo otow kuntoon, ogkatuman on sikan tibo. ");
INSERT INTO msmNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","To yangit dow pasak ogkagawang da, di to kagi ku ogpabilin yagboy. ");
INSERT INTO msmNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Wada namaan dow nokoy aedawa ubin nokoy urasa ogkatuman seini pig-ikagi ku, ngani to mgo anghil diya to yangit aw inggad ngani siak no Anak to Amoy ku no Diyus, su sikandin da to namaan. ");
INSERT INTO msmNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kaling bantoy kow. Pakaalistu kow su kona ogkamaanan to pagpauli ku. ");
INSERT INTO msmNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Angod pananglit to otow no ogpanow no wada terminu to pag-uli. Kona pad sikandin oglikat, igsalig sikan bayoy din to mgo suguonon din. Kada sobuuk ogbogajan to oghinangon, aw sikan ogbantoy duon to pertahan ogtesonon din to pagbantoy. ");
INSERT INTO msmNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Sikiyu isab, pakaalistu kow su kona now ogkamaanan to pagtidow ku no Agayon now, ko masakyop, ko matayod on to kadukiloman ubin ko kaadlawon dow ko ogkabukas on. ");
INSERT INTO msmNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Bantoy kow su unu ko matokawan kow to pagtidow ku aw masakpanan ku sikiyu no nangkalipodong. ");
INSERT INTO msmNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Seini igsugu ku iyu kuntoon, igsugu ku isab to tibo kaotawan. Pakaalistu kow yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Anoy man no daduwa nanda no aedow og-abut on to Pista to Pagyaboy dow to Pan no wada Patubu, naningkamot to pagsigmot ki Jesus to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan. Iyan tuud dan to pagpahimatoy kandin no wada ogkamaan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kagi dan, “Kona ta igtapu to pista su unu ko magubut to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na, migbisita si Jesus diya to Betania duon to bayoy ni Simon no pigsangla di naulian on. Anoy man no namangoon on sikandan, meyduon bohi no migtidow no migdae to pahomut no mahal hilabi su hininang to pudu nardu. Intagu seini duon to mahalon no butilya. Piggopik din to ba-ba to sikan butilya aw ihudhud sikan pahomut duon to uyu ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Di meyduon pila no ka otow duon no nadootan. Mig-iling sikandan, “Abee! Nokoy no pig-uyakan man kan pahomut? ");
INSERT INTO msmNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tapat pad ko imbaligja sikan, aw to linibu no halin ipamogoy to mgo pubri.” Hilabi sikandan naboyu to sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Di mig-ikagi si Jesus, “Pabay-ani sikandin. Nokoy no ogsamukon now man no madojow man seini pighinang din kanay? ");
INSERT INTO msmNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","To mgo pubri kanunoy now igpagduma, aw ogkatabangan now inggad kagan-u to gustu now. Di siakon, kona a ogkayugoy dini iyu. ");
INSERT INTO msmNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Pighinang to seini bohi kotob to ogkaabut din. Seini pagpahomut din kanay, angod to pighinaat din on to pagyobong kanay. ");
INSERT INTO msmNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ligdongi now seini,” kagi ni Jesus. “Inggad andei ignawnangon to Madojow no Nawnangonon kani to tibuuk kalibutan, ogkahisgutan isab seini pighinang din aw ogkahandom sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na, si Judas Iscariote no sobuuk to sikan sampuyu-tag-duwa no mgo inanad ni Jesus mig-andiya to yabow no mgo magdudumaya to tinuuhan dan su ig-unoy din igdata si Jesus kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pagdinog dan to kagi din, hilabi sikandan migtukhow aw saad no ogsuhuyan sikandin. Tapus to sikan, nanginlugar si Judas to pagdata ki Jesus duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na, mig-abut to una no aedow to pista to mgo Hibru no og-ilingon to Pan no Wada Patubu. Sikan to aedow no oghalad sikandan to nati no karneru dow igpahinongod to Pista to Pagyaboy. To mgo inanad ni Jesus mig-usip kandin, “Andei koy nu man ogpahikajon to panihapun ta to pista?” ");
INSERT INTO msmNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Dajun sugu-a ni Jesus to daduwa to sikan mgo inanad din. Kagi din, “Andiya kow to Jerusalem. Pagtidow now duon, ogkatagbu kow to yukos no ogdae to tibud no pigsedan to wohig. Patiduma kow kandin ");
INSERT INTO msmNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","diya to bayoy no og-andiyaan din, aw ikagihi sikan tag-bayoy, ‘Pigpaandini koy to Agayon noy su og-usip dow andei sikandin ogkoon to panihapun to Pista to Pagyaboy duma koy no mgo inanad din.’ ");
INSERT INTO msmNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Dajun din ighindu iyu to mayow-ag no koonanan diya to ikaduwa no andana no tahan on pighinaat. Duon kow hikoy to panihapun ta.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Dajun panow sikan daduwa no mgo inanad din aw andiya to Jerusalem. Nakitaan dan tibo to diya pig-ikagi ni Jesus. Dajun dan hikaja to pagkoon dan to pista. ");
INSERT INTO msmNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Anoy man no madukilom on, mig-anduon to bayoy si Jesus dow sikan sampuyu-tag-duwa no mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","No namangoon on sikandan, mig-ikagi si Jesus, “Oho, paminog kow. Sobuuk iyu kani no impagsayu ku ogyuib kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Migsakit yagboy to ginhawa dan, aw kada sobuuk mig-usip ki Jesus, “Kona no siak?” ");
INSERT INTO msmNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kagi ni Jesus, “Sobuuk iyu kani no sampuyu-tag-duwa no migpagsayu kanay kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Siak no Anak to Otow, oghimatajan a su tahan on nasuyat duon to Kasuyatan to Diyus. Di alaot yagboy sikan ogyuib kanay! Tapat pad ko inyandan sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","No migkoon pad sikandan, migdawat si Jesus to pan aw pasalamat sikandin to Diyus. Dajun din tibaga aw itadwoy kandan dow ikagi, “Yawa ku seini. Koona now.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dajun dawat si Jesus to tasa aw pasalamat isab to Diyus. Intadwoy din kandan, aw tibo sikandan naman-inom duon. ");
INSERT INTO msmNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kagi ni Jesus, “Yangosa ku seini no igdigon to kasabutan no oghinangon to Diyus iyu. Igpaawas seini agun no mapasaylu to sae to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Indani now seini. Iyan nanda sei to pag-inom ku to gita to ubas dini. Ayha a da og-inom to sikan bag-u no inomon ko muinom a duma iyu diya to gingharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dajun sikandan pamanganta to pagsaja to Diyus aw panow pailing diya to Kaulibuhan no bubungan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Pig-ikagihan ni Jesus to mgo inanad din, “Og-ojowan a now tibo su meyduon sinuyat no kagi to Diyus no pig-iling, ‘Ogpahimatajan ku to magbantajay, aw ogkasusuwoy to mgo karneru no pigbantajan din.’ ");
INSERT INTO msmNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Di ko mabanhaw ad, og-una a iyu diya to Galilea.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Dajun ikagi si Pedro, “Inggad ojowan ka to tibo, kona ku yagboy sikuna og-ojowan.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kagi ni Jesus, “Indani seini. Kona pad ogtagauk to manuk to kadaduwa gaja, iglidung a nud to katatoyu.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Di migpakamayogot si Pedro no mig-iling, “Kagan-u ku man sikuna ilidung, inggad pad i-unung a ikow ko himatajan ka!” Sikan isab to pig-ikagi dan tibo. ");
INSERT INTO msmNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na, migtidow si Jesus dow mgo inanad din duon to sikan banwa no og-ilingon to Getsemane. Dajun ikagi si Jesus, “Kani kow da ingkud su og-ampu a dutun.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Di pigduma din si Pedro, si Santiago dow si Juan diya to unahan, aw dajun sugud to hilabi no kaguul dow kasamuk to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Kagi ni Jesus, “Ahay, angod to igkamatoy ku to kani kaguul ku! Pakamonang kow kani di kona kow oglipodong.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dajun andiya sikandin to unahan aw patiyangkob duon to pasak aw ampu no ko mahimu, konad podom sikandin pabajaon to sikan mgo antusonon no madani on og-abut kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Amoy ku,” kagi din, “wada inggad nokoy no kona nu ogkahimuan. Ko mahimu, ajaw a ogpabajaa to sikan mgo antusonon. Di to pagboot nu iyan matuman, kona no sikan kanay.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na, pagpauli ni Jesus duon to sikan tatoyu no mgo inanad din, pigkita din no nalipodong on sikandan. Dajun din pukawa aw ikagihi si Simon Pedro, “Sadangay pad man Simon. Kona nu ogkapogongan to lipodongon nu inggad songo uras da? ");
INSERT INTO msmNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kona kow on oglipodong. Ampu kow nasi agun no kona kow matintal. Ogtuman kow iyan podom, di mayotoy to yawa now.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Migpanow on isab si Jesus aw ampu angod to diya una no pag-ampu din. ");
INSERT INTO msmNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pagpauli din duon to mgo inanad, pigkita din no nalipodong gihapun su angod to ogpikpikon to mata dan. Pagkabuyat dan, wada ingkaikagi dan kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","No ikatoyu on no pagpauli ni Jesus duon kandan, mig-ikagi sikandin, “Nalipodong kow pad gihapun? Igu on. Uras on no siak no Anak to Otow igdata on diya to mgo makasasaya. ");
INSERT INTO msmNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na, bangun kow on su seinid on to ogyuib kanay. Ogtagbuhon ta.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","No mig-ikagi pad si Jesus, migtidow si Judas no sobuuk to sikan sampuyu-tag-duwa no mgo inanad din. Mahan-in to mgo duma din no sangkap to mgo ispada dow mgo taepos. Pigsugu sikandan to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan hasta to inila no mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na, tahan dan on pigsabutan to oghinangon ni Judas agun makiyaya dan si Jesus. Kagi din, “Hadokan ku ngani, iyan kay. Dakopa now dajun aw dedeyjawa now to pagbantoy ko daehon now.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na, dajun din duguka si Jesus aw ikagihi, “Sir,” aw hadoki. ");
INSERT INTO msmNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dajun dan dakopa si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Di sobuuk to diya namanindog duon to dani mighuyabut to ispada din aw tigbasa to suguonon to sikan kinayabawan no magdudumaya, aw kasagpingi to talinga. ");
INSERT INTO msmNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Dajun ikagihi ni Jesus sikan namandakop kandin, “Nokoy man, tulisan a no migdae kow man to mgo ispada dow mgo taepos to pagdakop kanay? ");
INSERT INTO msmNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nokoy no wada a now dakopa no duma ku man sikiyu duon to Bayoy to Diyus no mang-anad a kada aedow? Di nailing to seini agun matuman to intag-an duon to Kasuyatan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Dajun yaguji si Jesus to tibo mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na, meyduon batan-on no yukos no migyupug ki Jesus no migkikimbut. Pigdakop dan podom sikandin, ");
INSERT INTO msmNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","di iyan da natagonan sikan pigkimbut din aw nakalinaguy no nakapahawae-hawae. ");
INSERT INTO msmNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dajun dan daeha si Jesus diya to bayoy to sikan kinayabawan no magdudumaya to tinuuhan dan no mgo Hibru. Nahimun isab duon to duma no yabow no mgo magdudumaya dow mgo maistru to tinuuhan hasta to duma no inila no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Migyupug si Pedro ki Jesus di migpadiyu da. Pagtidow din, nakased sikandin duon to pawa aw agpot to mgo magbantajay no naman-ingkud no nanghinadang duon to kaeju. ");
INSERT INTO msmNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na, sikan yabow no mgo magdudumaya hasta to duma no mgo maghusajay no nahimun duon namangha yagboy to ogpamangistigus kuntra ki Jesus agun mapahimatajan dan. Di wada nakitaan dan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mahan-in hinuun to migkistigus to mgo ginayu kuntra ki Jesus, di wada hiangod to mgo kagi dan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pagkahina-hina meyduon yain no mgo otow no namangistigus isab to ginayu. ");
INSERT INTO msmNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Kagi dan, “Pigdinog noy no mig-iling si Jesus, ‘Oggobaon ku seini Bayoy to Diyus no hininang to otow, aw sed to tatoyu no aedow oghinangon ku to yain no Bayoy to Diyus no kona og-otawan to paghinang.’” ");
INSERT INTO msmNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Di wada gihapun hiangod to mgo pagkistigus dan. ");
INSERT INTO msmNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dajun tindog sikan kinayabawan no magdudumaya duon to kabaknaan to sikan naman-ingkud aw usipa si Jesus, “Nokoy man to ogkaikagi nu to sikan ingkistigus dan? Kona ka ogtabak?” ");
INSERT INTO msmNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Di wada ikagi si Jesus. Mig-usip manda sikan kinayabawan no magdudumaya, “Sikuna iyan to Anak to Diyus no Yabow to Tibo? Sikuna buwa to diya Insaad no Manyuyuwas?” ");
INSERT INTO msmNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Kagi ni Jesus, “Siak iyan. Aw ogkitaon a now no Anak to Otow no og-ingkud duon to kalintuu no takidingan to Gamhanan no Diyus agun pasidonggan a. Ogkitaon a now isab no ogkonsad likat diya to yangit duma to mgo panganud.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dajun higbita to sikan kinayabawan no magdudumaya to kabo din tongod to kaboyu din aw ikagi, “Set ki pad man ogpamangha to kistigus ");
INSERT INTO msmNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","no sikiyu on man yagboy to migdinog to pagpasipaya din to Diyus! Na, nokoy man to iyu?” Tibo sikandan mighukum no angajan yagboy si Jesus ogpahamtangan to kamatajon. ");
INSERT INTO msmNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dajun ilob-ilobi si Jesus to duma to sikan mgo otow. Pigsampongan dan isab to mata din aw panumbaga no mig-iling, “Tag-ana dow hintawa to migsumbag ikow.” Pigpanampalu isab sikandin to mgo magbantajay. ");
INSERT INTO msmNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Duon pad si Pedro to pawa, meyduon nakabaja duon no bohi no suguonon to sikan kinayabawan no magdudumaya. ");
INSERT INTO msmNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pagkita din ki Pedro no nanghinadang, pigyongyongan din aw ikagihi, “Aduy, duma ka isab to diya taga-Nazaret no si Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Di miglidung si Pedro, “Eh, wada kalibutan ku to sikan pig-ikagi nu.” Dajun panow si Pedro padeg diya to yawanganan dongan to migtagauk to manuk. ");
INSERT INTO msmNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pagkita isab kandin to sikan suguonon no bohi, pig-ikagihan to sikan bohi to mgo otow no namanindog duon, “Seini no otow, sobuuk kandan.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Di miglidung on isab si Pedro. Anoy man no nahina-hina on, pig-ikagihan si Pedro to mgo otow no namanindog duon, “Duma ka iyan to sikan no mgo otow su taga-Galilea ka man isab.” ");
INSERT INTO msmNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Di nanapa si Pedro to maagbot aw iling, “Wada a yagboy kiyaya to diya no otawa!” ");
INSERT INTO msmNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Duon-dajun migtagauk to manuk to ikaduwa, aw kadomdomi ni Pedro to diya kagi ni Jesus kandin no mig-iling, “Kona pad ogtagauk to manuk to kadaduwa, iglidung a nud to katatoyu.” Dajun ngog-ngog si Pedro. ");
INSERT INTO msmNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Saju to kamaseman, mighihimun on isab sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru, mgo maistru to tinuuhan dow to inila no mgo duma dan. Seini tibo no mgo maghusajay namansasabut to oghinangon dan. Dajun dan gapusa si Jesus aw daeha diya ki Gubernadur Pilato. ");
INSERT INTO msmNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pagtidow dan, pig-usip ni Pilato si Jesus, “Sikuna iyan to hari to mgo Hibru?” Migtabak si Jesus, “Naikagi nud.” ");
INSERT INTO msmNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mahan-in to inriklamu kuntra kandin to sikan yabow no mgo magdudumaya. ");
INSERT INTO msmNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kaling mig-usip manda si Pilato, “Mahan-in to mgo riklamu dan kuntra ikow. Nokoy man, kona ka ogtabak?” ");
INSERT INTO msmNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Di wada yagboy intabak ni Jesus, kaling natingaya si Pilato. ");
INSERT INTO msmNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","8","Na, mahan-in to mgo otow no mig-andiya ki Pilato su oghangyu no ogsabuk sikandin to sobuuk no prisu. Su kada Pista to Pagyaboy, nabatasan to sikan gubernadur no ogsabukan din to sobuuk no prisu no iyan ogpilion to kaotawan. To diya no panahon, nakatapu no mey mgo ribeldi no nangkaprisu su migpag-atu to gubernu aw nakamatoy to mgo otow. To sobuuk kandan pigngadanan ki Barabas. ");
INSERT INTO msmNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Kaling mig-usip si Pilato, “Ogkaliyag kow no iyan ogsabukan ku seini og-ilingon to hari to mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ing-usip din sikan su namaanan din no indata kandin si Jesus to sikan yabow no mgo magdudumaya su migsilag sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Di to kaotawan pighonghongan to sikan yabow no mgo magdudumaya agun iyan nasi pasabukan dan si Barabas. ");
INSERT INTO msmNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Dajun usipa ni Pilato to kaotawan, “Og-amonuhon kud man naan seini og-ilingon now to hari to mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Migtabak sikandan no namanguliya, “Himataji! Iyansang duon to krus!” ");
INSERT INTO msmNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mig-usip si Pilato, “Manya man? Nokoy man to sae din?” Di nasi mig-agbot to pagkinuliya dan no mig-iling, “Himataji! Iyansang duon to krus!” ");
INSERT INTO msmNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na, manno gustu ni Pilato no malipay to kaotawan, iyan pigpasabukan din si Barabas. Di si Jesus pigpanyapdosan aw idata duon to sikan ogpamanyansang kandin duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dajun daeha si Jesus to mgo sundayu duon to pawa to bayoy to gubernadur aw himuna dan to tibo angod dan no mgo sundayu. ");
INSERT INTO msmNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pigsul-uban dan sikandin to mayogdog no kapa. Mighinang isab sikandan to kuruna no dugihon no gawod aw ikuruna kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kagi dan, “Mabuhi ka, hari to mgo Hibru!” ");
INSERT INTO msmNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pigpinokpok dan aw pang-ilobi dow linuhud-yuhud duon to atubangan din. ");
INSERT INTO msmNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tapus dan hinanga sikandin no kangisihanan, pighukasan dan si Jesus to sikan mayogdog no kapa aw sul-ubi to kandin no kabo. Dajun dan daeha diya to yuwas su igyansang duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na, duon to pangindaenan, sikan namanhatod ki Jesus nakatagbu to otow no taga-Cirene no napuun diya to hilit. Iyan ngadan din si Simon, aw iyan mgo anak din si Alejandro dow si Rufo. Dajun dan pogosa si Simon to pagtiang to sikan krus no ogyansangan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Pigdae dan si Jesus duon to sikan banwa no og-ilingon to Golgota, no ko ita pa, banwa to Boboungon. ");
INSERT INTO msmNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Pagtidow dan duon, pigtagajan si Jesus to inomon no sinakotan to sikan mapoit no og-ilingon to mira, di wada din dawata. ");
INSERT INTO msmNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dajun dan sikandin iyansang duon to krus. To mgo kabo din pigbabahin to mgo sundayu pinaagi to ripa. ");
INSERT INTO msmNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuybe to masem no iyansang si Jesus duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","To riklamu kuntra kandin pig-iling to pagkasuyat, “Hari seini to mgo Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Duon to magdibayuy ni Jesus meyduon daduwa no ka ribeldi no impanyansang isab duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","To mgo otow no namanyaboy duon migpajango-jango to pagsujan-sujan kandin. Kagi dan, “Awu! Kagi nu oggobaon nu sikan Bayoy to Diyus aw og-isabon nu oghinangon sed to tatoyu da no aedow. ");
INSERT INTO msmNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Na, ko angod to sikan to gahom nu, yuwasa to kaugalingon nu. Yudus ka duon!” ");
INSERT INTO msmNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Angod isab to sikan to pagsujan-sujan ki Jesus to sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow mgo maistru to tinuuhan. Kagi dan, “Nayuwas din kun to duma, di kona din man naan ogkayuwas to kaugalingon din. ");
INSERT INTO msmNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Oho, Manyuyuwas man buwa sikandin no hari to mgo kaliwat ni Israel, payudusa duon agun makatuu ki!” Hasta sikan daduwa no duma ni Jesus no inyansang duon to krus migtamay isab kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Anoy man no maugtu on, migdigyom to kalibutan hangtod to alas tres to kahapunon. ");
INSERT INTO msmNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na, pagkaalas tres on, migtawag si Jesus to maagbot, “Eloi, eloi, lama sabaktani?” no ko ita pa, “Diyus ku, Diyus ku, nokoy no pig-ojowan a nu?” ");
INSERT INTO msmNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Di to duma no mgo otow no migtindog duon naman-iling, “Paminog kow. Ogpatabang sikandin ki Elias.” ");
INSERT INTO msmNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na, sobuuk kandan miglinaguy aw pudut to ogpasoyopan din to suka. Dajun din ihikot duon to tumuy to tinampod no tigbow aw itadwoy duon to ba-ba ni Jesus. Kagi to sikan otow, “Og-ahaon ta iyan dow og-andini si Elias to pagpudut kandin.” ");
INSERT INTO msmNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Dajun pangiyak si Jesus to maagbot aw kabigtawi. ");
INSERT INTO msmNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Dongan to sikan, nahigbit sikan madamey no panapton no yopon to sikan Pinakabalaan no Sinabong duon to Bayoy to Diyus likat to diatas pailing duon to obos. ");
INSERT INTO msmNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na, pagkita to sikan kapitan to mgo sundayu no migtindog duon to atubangan ni Jesus dow naamonu to pagkamatoy din, nakailing sikandin, “Tinood naan no Anak seini to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Meyduon isab mgo bohi no migsayap ki Jesus di migpadiyu da. Duon si Maria Magdalena dow si Salome, yakip si Maria no inoy ni Jose dow ni Santiago no batan-on. ");
INSERT INTO msmNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Seini no mgo bohi namanduma-duma aw alagad ki Jesus no diya pad sikandin to Galilea. Mahan-in pad to duma no mgo bohi duon no namanduma ki Jesus no umandiya sikandin to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na sikan no aedow to igpangandam to mgo Hibru, su ko musayop on to soga, og-ilingon dan no Aedow on no Tigpahuway. Kaling, no madani on ogsayop to soga, ");
INSERT INTO msmNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","meyduon otow no taga-Arimatea no migtidow no iyan ngadan si Jose. Tinahud sikandin no sakup to husajan, aw migtatagad sikandin to paghari to Diyus. Na, to diya no mahapun, migpangimbubuyut sikandin to pag-andiya ki Pilato aw hangyu no sikandin to ogyobong ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naboyong si Pilato no madinog din no nabigtawan on si Jesus, kaling impatawag din sikan kapitan aw usipa dow tinood iyan. ");
INSERT INTO msmNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pag-iling to sikan kapitan no patoy on iyan si Jesus, intugut ni Pilato no puduton ni Jose. ");
INSERT INTO msmNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Dajun boli si Jose to madojow no panapton, aw pagkapudut din to yawa ni Jesus duon to krus, piglibodan din to sikan panapton. Dajun din ibotang duon to yobonganan no imbangbang duon to batu aw yoponi din to piglipid no gatung. ");
INSERT INTO msmNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Si Maria Magdalena dow to sangay din no inoy ni Jose namanyupug kandin aw nakaindan to sikan pigyobongan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Anoy man no masakyop on to diya Aedow no Tigpahuway, migduduma si Maria Magdalena dow si Salome hasta si Maria no inoy ni Santiago. Migboli sikandan to igpahomut dan to yawa ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pagkamasem on to Duminggu no bag-u pad ogsilat to soga, mig-andiya sikandan to pigyobongan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Duon pad to pangindaenan, mighihimanu sikandan dow hintawa to oggawang to sikan piglipid no gatung no inyopon. ");
INSERT INTO msmNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Di pagtonggak dan no tumidow on sikandan, pigkita dan no naligad on naan sikan gatung. ");
INSERT INTO msmNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Pagsed dan, pigkogaan sikandan su mey pigkita dan no batan-on no otow no mig-iingkud duon dapit to kalintuu no nangabo to maputi. ");
INSERT INTO msmNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kagi din, “Kona kow ogkahaedok. Namaan a no ogpamangha kow ki Jesus no taga-Nazaret no inyansang duon to krus. Wadad kani su nabanhaw on. Ahaa now seini pigbotangan kandin. ");
INSERT INTO msmNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Na, panow kow aw nangoni to mgo inanad din, yabi si Pedro, no og-una si Jesus diya to Galilea. Ogkitaon dan sikandin diya, su sikan to pig-ikagi din kandan to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pigkobaan pad sikan mgo bohi dow migpamidpid no migyuwas to yobong aw pakajabag linaguy. Wada pig-ikagihan dan to inggad nokoy, su nahaedok sikandan. ");
INSERT INTO msmNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na, pagkabanhaw ni Jesus no kaadlawon to Duminggu, iyan una no pigyogwa din si Maria Magdalena no iyan pigpayagujan din to pitu no mangkadoot no ispiritu to diya una. ");
INSERT INTO msmNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tapus din kitaa si Jesus, pig-andiya ni Maria to duma no mgo sakup ni Jesus no dugaja pad migmey-og dow tiyahu su ognangonan din no nabanhaw on si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pagdinog dan to kagi ni Maria no pigkita din si Jesus no nabanhaw on, wada sikandan tuu. ");
INSERT INTO msmNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pagkahina-hina, migpakita si Jesus to daduwa kandan no naman-andiya to kahilitan, di wada dan dajun kiyayaha su naisab on to hitsura din. ");
INSERT INTO msmNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pagkiyayaha dan on, migpauli sikandan diya to Jerusalem aw nangoni dan to duma no mgo inanad ni Jesus. Di wada gihapun tuu. ");
INSERT INTO msmNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Migpakita isab si Jesus to sikan sampuyu-tag-isa no mgo inanad din no namangoon. Pigsawoy din sikandan tongod to kadoson to uyu dan su wada dan tuuhi to kagi to diya namakakita no nabanhaw on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Dajun sugu-a sikandan ni Jesus, “Andiyaa now to tibo kaotawan kani to tibuuk kalibutan aw inawnangon to Madojow no Nawnangonon bahin kanay. ");
INSERT INTO msmNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inggad hintawa no ogtuu dow ogpabawtismu, ogkayuwas. Di inggad hintawa no kona ogtuu, ogpahamtangan to kastigu. ");
INSERT INTO msmNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","To mgo otow no ogtuu kanay ogpakahinang to mgo milagru angod to pag-abug to mangkadoot no ispiritu pinaagi to gahom to ngadan ku dow to pag-ikagi to inikagihan no wada dan kaanadi. ");
INSERT INTO msmNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inggad makatagon sikandan to hayas aw ko makainom to ogpakahilu, kona sikandan ogkaamonu. Ogkaulian isab to mgo masakiton no ogdampaon dan.” ");
INSERT INTO msmNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tapus kaikagihi ni Ginuung Jesus to mgo inanad din, nabatun sikandin diya to yangit aw pasidonggi no migsoing duon to kalintuu no takidingan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Dajun panow to mgo inanad ni Jesus aw inawnangon to Madojow no Nawnangonon diya to inggad andei no banwa. Pigbuligan sikandan to Ginuu, aw pigmatuud din sikan mgo kagi dan pinaagi to mgo milagru.");
INSERT INTO msmNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kumusta ka Sir Teofilo. Mahan-in to mgo otow no naningkamot to pagsuyat to mgo hitabu kani ita to diya panahon ni Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Insuyat dan to ingnawnangon to diya mgo otow no yagboy nakakita to sikan no mgo hitabu likat pad to sinugdanan. Sikan namakakita to mgo hinang ni Jesus mignawnangon isab to seini Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na siak, pighona-hona ku no angay ku seini ogsuyaton ikow to madojow no pagkahan-oy, su yagboy kud man nasusi likat pad to sinugdanan ");
INSERT INTO msmNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","agun mamaanan nu no tinood yagboy to diya ing-anad ikow. ");
INSERT INTO msmNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","To diya panahon no si Herodes to mighari to prubinsya to Judea, meyduon otow no iyan ngadan si Zacarias no mey katongdanan duon to Bayoy to Diyus. Sakup sikandin to panon ni Abias no kaliwat ni Aaron no una no magdudumaya to tinuuhan to mgo Hibru. Iyan asawa din si Elisabet no kaliwat da isab ni Aaron. ");
INSERT INTO msmNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nasajaan to Diyus su matarong sikandan no mag-asawa aw matinumanon to kasuguan din dow mgo tumanon. ");
INSERT INTO msmNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Di puli on sikandan nangkamanigaon no wada panganak si Elisabet. ");
INSERT INTO msmNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Na, pag-abut to panahon no iyan ogtuman onsi Zacarias duon to Bayoy to Diyus, naripahan sikandin no iyan ogsed su ogtutung to insensu. Su igpabaja to ripa dow hintawa to sikan mgo magdudumaya to ogtuman to sikan. ");
INSERT INTO msmNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tagaod to migtutung si Zacarias to insensu, naman-ampu to kaotawan diya to yuwas. ");
INSERT INTO msmNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Puli nakatokow, meyduon anghil to Ginuu no migyogwa duon ki Zacarias. Migtindog sikan anghil duon dapit to kalintuu to sikan tutunganan to insensu. ");
INSERT INTO msmNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pagkita ni Zacarias to sikan anghil, pigkobaan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Di kagi to sikan anghil, “Kona ka ogkahaedok Zacarias. Pigdinog to Diyus to pag-ampu now. Si Elisabet no asawa nu ogpanganak to yukos. Juan to ihingadan nu kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ko i-anak on sikan no bata, ogkalipay kow hasta to kaotawan ");
INSERT INTO msmNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","su ogkadongganon sikandin duon to atubangan to Ginuu. Kona sikandin og-inom to maisog no inomon. Sugud pad to pagkaotow din, oggahoman on to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mahan-in to angod now no mgo kaliwat ni Israel no ogpabalikon din diya to Ginuu no Diyus dan. ");
INSERT INTO msmNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Og-unahan din to Ginuu aw oggahoman sikandin to Ispiritu Santu angod ki Elias no kibali ba-ba to Diyus to diya una. Ogpapag-ulion din to mgo amoy dow mgo anak. Aw to mgo otow no masinupakon ogpabalikon din to pagkamatarong agun mahinaat to kaotawan to pagtidow to Ginuu.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Dajun usipa ni Zacarias sikan anghil, “Og-amonuhon ku man to pagkiyaya no tinood sikan pig-ikagi nu no manigaon ad man, hasta bujag on isab to asawa ku?” ");
INSERT INTO msmNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Migtabak sikan anghil, “Siak si Gabriel no suguonon to Diyus. Pigpaandini a din to pagnawnangon ikow to seini madojow no nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Di sikuna, su wada nu man tuuhi to kagi ku, ogkapoha ka kotob no matuman on sikan pig-ikagi ku ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na, to mgo otow no migtatagad diya to yuwas nangkaboyong dow nokoy no nayugoy si Zacarias diya to sed. ");
INSERT INTO msmNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pagyuwas din, konad on sikandin ogpakaikagi. Puli nanda ogsingyas, kaling nakasabut to mgo otow no meyduon impakita kandin to Diyus duon to sed. ");
INSERT INTO msmNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Anoy man no tapus on to pagtuman onni Zacarias duon to Bayoy to Diyus, mig-uli sikandin diya to banwa din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wada kayugoy, nangidam si Elisabet no asawa din. Migpakamonang sikandin duon to bayoy sed to lima no buyan. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Pigtabangan a yagboy to Ginuu. Kona ad ogkatamay to mgo otow su ogpanganak a da naan.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anoy man no ikaonom on no buyan to pagkabodos ni Elisabet, pigsugu to Diyus sikan anghil no si Gabriel diya to yunsud to Nazaret no sakup to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Su meyduon igpaikagi din duon to daega no iyan ngadan si Maria. Asawahon sikandin ni Jose no kaliwat ni Hari David. ");
INSERT INTO msmNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pagyogwa to sikan anghil, mig-ikagi sikandin, “Iya, lipay ka su pigmarojawan ka yagboy to Diyus. Duma sikandin ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Naboyong si Maria dow nokoy to igpasabut to pig-ikagi to sikan anghil. ");
INSERT INTO msmNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Di mig-iling sikan anghil, “Kona ka ogkahaedok Maria, su nalipay to Diyus ikow. ");
INSERT INTO msmNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Su ogkabodos ka aw og-anak ka to yukos. Jesus to ihingadan nu kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yabow yagboy sikandin aw ogkatawag no Anak to Diyus no Yabow to Tibo. Igbogoy kandin to Ginuu no Diyus to pagkahari ni David no minuna din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ogmanduan din to kaliwatan ni Jacob hangtod to wada katapusan. Wada pagkatapus to paghari din.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mig-usip si Maria, “Og-amonuhon man to pagkatuman to sikan no daega a pad man yagboy?” ");
INSERT INTO msmNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Migtabak sikan anghil, “Ogkonsadan ka to Ispiritu Santu aw oggahoman ka to Diyus no Yabow to Tibo. Kaling man sikan balaan no bata ogkatawag no Anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aw ngani man si Elisabet no parenti nu no nabujag on no wada panganak, di ikaonom on no buyan to pagkabodos din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Su wada malisod no kona ogkahimuan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Kagi ni Maria, “Suguonon a to Ginuu ku. Matuman podom sikan pig-ikagi nu kanay.” Dajun likat sikan anghil. ");
INSERT INTO msmNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wada kayugoy migdali si Maria to pag-andiya ki Elisabet no mig-ugpa diya to songo yunsud duon to kabubunganan no sakup to Judea. ");
INSERT INTO msmNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pagtidow din duon to bayoy onni Zacarias, pigpangumusta din si Elisabet. ");
INSERT INTO msmNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Pagdinog ni Elisabet to pangumusta ni Maria, mighisu to maagbot sikan bata duon to sed to gotok din. Dajun piggahoman si Elisabet to Ispiritu Santu ");
INSERT INTO msmNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","aw makaikagi sikandin to maagbot, “To tibo mgo bohi, sikuna to pigmadojawan to Diyus. Ogmadojawan din isab sikan bata no ig-anak nu. ");
INSERT INTO msmNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hintawa a man no pig-andinihan nu no inoy to Ginuu ku? ");
INSERT INTO msmNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Su pagdinog ku to pangumusta nu, mighisu to maagbot seini bata kani to sed to gotok ku tongod to kalipay. ");
INSERT INTO msmNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Madojow ka su migtuu ka man no ogkatuman to diya kagi to Ginuu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dajun ikagi si Maria, “Ogsajaon ku to Ginuu ku. ");
INSERT INTO msmNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Malipajon a tongod to Diyus no Manyuyuwas ku, ");
INSERT INTO msmNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","su pigkayuujan a din no obos no suguonon din. Sugud kuntoon, to tibo mgo otow og-iling no madojow a ");
INSERT INTO msmNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","su kabeynganan yagboy to pigpanghinang kanay to Gamhanan no Diyus. Balaan yagboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ogkayuujan din to mgo otow no ogtahud yagboy kandin to diya una dow kuntoon aw hangtod to wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Impakita din to pagkagamhanan din. Pigpagsuwoy-suwoy din to mgo otow no mapayabi-yabihon. ");
INSERT INTO msmNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","To mgo magmamandu pigpanggawangan din to katongod, di to mgo mapaobsanon pigpayabow din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","To pigpamontas pighantoy din, di to mgo sapian pigpanggawangan din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Pigtabangan din to mgo kaliwat ni Israel no suguonon din. Wada din kalingawi to saad din to pagkayuuy ki Abraham dow to mgo kaliwat din hangtod to wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tatoyu no buyan to pag-ugpa ni Maria duon ki Elisabet ayha sikandin uli. ");
INSERT INTO msmNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na, pag-anak ni Elisabet, yukos iyan to ing-anak din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pagdinog to mgo sumbayoy dow kasuunan din no mig-anak on sikandin, migduyug sikandan to kalipay din, su pigkayuujan yagboy si Elisabet to Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Anoy man no wayu on no aedow sikan bata, namanhimun sikandan su ogtulion aw oghingadanan sikandin. Igsangay podom sikandin ki Zacarias no amoy din, ");
INSERT INTO msmNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","di wada sugut si Elisabet. Kagi din, “Kona ogkahimu. Si Juan da to ighingadan to seini bata.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kagi dan ki Elisabet, “Di wada pad parenti now no angod to sikan no ngadan.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pigsingyasan dan sikan amoy dow hintawa to ighingadan din to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dajun pamuju si Zacarias to ogkasuyatan aw suyat, “Juan to ihingadan kandin.” Kaling yagboy natingaya sikan tibo mgo otow no nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Duon-dajun nakaikagi si Zacarias, aw pigsaja din to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","To mgo sumbayoy dan hilabi naboyong to sikan milagru no pighinang to Diyus, aw migtangkap to nawnangonon bahin to sikan diya to kabubunganan to prubinsya to Judea. ");
INSERT INTO msmNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Sikan nadinog to mgo otow pighipidan duon to ginhawa dan. Kagi dan, “Nokoy man buwa to ogkadeygan to sikan no bataa?” Su mapajag no piggahoman sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na, si Zacarias no amoy to sikan bata piggahoman to Ispiritu Santu. Dajun din naikagi to impaikagi kandin to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sajaon to Ginuu no Diyus ta no mgo kaliwat ni Israel, su mig-andini sikandin to pagyuwas to kaotawan din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Igbogoy din ita to gamhanan no Manyuyuwas no kaliwat ni Hari David no suguonon din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Impabaja to Diyus to kagi din to mgo otow no kibali ba-ba din to diya una ");
INSERT INTO msmNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","no pig-iling no ogyuwason ki din to mgo kuntra ta. ");
INSERT INTO msmNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pigkayuujan din to mgo kaaw-apuan ta. Wada din kalingawi to kasabutan din kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Insaad din ki Abraham no minuna ta duma to sapa ");
INSERT INTO msmNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","no ogtabangan ki din agun kona ki madaog-daog to mgo kuntra ta aw kona ki mahaedok to pagtuman kandin ");
INSERT INTO msmNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","no matarong ki kanunoy aw wada sae duon to atubangan din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na, sikuna no bata, og-ilingon ka to kibali ba-ba to Diyus no Yabow to Tibo, su og-una-una ka to Ginuu agun mahinaat nu to kaotawan to pagtidow din. ");
INSERT INTO msmNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ogmaanon nu to angod ta no mgo Hibru no ogkayuwas sikandan ko pasayluhon to mgo sae dan ");
INSERT INTO msmNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","pinaagi to kae-at to Diyus ita. Sikan no pagyuwas din ita iyan ogkaangodan to bag-u ogsilat no soga. ");
INSERT INTO msmNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ogtang-awan din to mgo otow no mig-ugpa duon to kadigyoman no wadad on pag-iman su nasakup sikandan to kamatajon. Sikandin to oghindu ita to dayan no og-unugon ta agun no mahiuli kinow dow to Diyus aw malinow to ginhawa ta.” ");
INSERT INTO msmNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na, migtulin sikan anak ni Zacarias no maalamon dow madojow to kinaiya. Pagtulin din on, migpapaawoy sikandin diya to matahay no banwa kotob to panahon no og-atubangon din on to angod din no mgo kaliwat ni Israel. ");
INSERT INTO msmNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","To diya no panahon, migsugu si Hari Augusto no ipanglista to mgo ngadan to tibo ginsakupan din. ");
INSERT INTO msmNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Seini to una no pagpanglista no si Cirenio to gubernadur to Siria. ");
INSERT INTO msmNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaling kada sobuuk mig-andiya to yunsud no napuunan din su ogpalista. ");
INSERT INTO msmNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na, si Jose no mig-ugpa diya to Nazaret no sakup to Galilea mig-andiya to Betlehem no yunsud ni Hari David no sakup to Judea, su kaliwat man sikandin ni David. ");
INSERT INTO msmNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pigduma din si Maria no magkabodos on no pig-asawa din di wada pad hulidi. ");
INSERT INTO msmNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kabuyanan on ni Maria no diyad sikandan to Betlehem. ");
INSERT INTO msmNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ing-anak din to yukos no panganoy din. Pigtongos din to panapton aw pahibata duon to bohuganan to mgo buhi su wadad man lugar duon to paabutanan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na, duon to dani to Betlehem meyduon namanbantoy to mgo karneru to sikan no kadukiloman. ");
INSERT INTO msmNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Puli nakatokow meyduon anghil to Ginuu no migyogwa duon kandan, aw katang-awi sikandan to kasiga to Ginuu. Pigdaitan sikandan, ");
INSERT INTO msmNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","di mig-ikagi sikan anghil, “Kona kow ogkahaedok, su meyduon madojow no ignangon ku iyu no igkalipay to tibo kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ing-anak kuntoon duon to yunsud ni David to Manyuyuwas now. Sikandin to Ginuu no ogpaharion to Diyus to kaotawan din! ");
INSERT INTO msmNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ogkamaanan now no matuud seini pig-ikagi ku, su ogkitaon now sikan bata no pigtongos to panapton aw pahibata duon to bohuganan to mgo buhi.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Puli nakatokow nahimun to mahan-in hilabi no mgo anghil no napuun to yangit no migsaja to Diyus. Mig-iling sikandan, ");
INSERT INTO msmNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ogkasaja to Diyus diya to yangit. Aw duon to pasak, igbogoy din to kalinow to mgo otow no ogmadojawan din.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pagkalius on to sikan mgo anghil pailing diya to yangit, migpaiikagihay sikan mgo magbantajay to karneru, “Og-andiya kinow on to Betlehem, su og-ahaon ta sikan impamaan to Ginuu ita.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Dajun sikandan padagas diya to Betlehem. Pagtidow dan, nakitaan dan si Maria, si Jose dow sikan bata no pigpahibat duon to bohuganan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pagkatapus, ingnawnangon dan to diya pig-ikagi to anghil bahin to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Natingaya to tibo mgo otow no nakadinog to sikan kagi dan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","20","Naman-uli sikan mgo magbantajay to karneru no namansaja to Diyus tongod to sikan pigkita dan aw pigdinog no angod da to pig-ikagi to diya anghil. Di si Maria, puli din pighipidan sikan tibo duon to ginhawa din, aw kanunoy din pigdomdom. ");
INSERT INTO msmNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Anoy man no nawayuhan on no aedow to pag-anak ki Jesus, pigtuman to mgo ginikanan din to tumanon to pagtuli. Pigngadanan dan sikandin ki Jesus, su sikan to pig-ikagi to diya anghil no wada pad sikandin ipangidam. ");
INSERT INTO msmNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Na, no panahon on no ogtumanon to paghinlu to nanganak no insugu to balaod ni Moises, mig-andiya onsi Jose to Bayoy to Diyus diya to siyudad to Jerusalem. Oghalad sikandan duon su nasuyat duon to sikan balaod to Ginuu no pig-iling, “Ihalad now to Diyus to songo paris no limukon ubin songo paris no salapati no maintok pad.” Pigdaya dan sikan bata su igpaabin dan to Diyus, su pigsuyat isab duon to balaod to Ginuu no pig-iling, “To bata no yukos no panganoy, igpaabin to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na, meyduon matarong no otow no diyusnon diya to Jerusalem no iyan ngadan si Simeon. Migpaabut sikandin to kayuwasan to mgo kaliwat ni Israel, aw pigdumahan sikandin to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tahan on sikandin pigpasabut to Ispiritu Santu no ayha sikandin ogkamatoy ko maaha din on to diya Insaad no Manyuyuwas no ogpaandinihon to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na, si Simeon no pigmanduan to Ispiritu Santu migsed duon to Bayoy to Diyus. Pagdaeha to sikan bata no si Jesus to mgo ginikanan din no ogtuman to mgo tumanon, ");
INSERT INTO msmNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","pigsakupu ni Simeon sikan bata. Dajun din sajaa to Diyus. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kuntoon Ginuu ku no Magboboot to tibo, inggad mamatoy ad, su natuman on seini insaad nu kanay. ");
INSERT INTO msmNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Naaha kud seini Manyuyuwas ");
INSERT INTO msmNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","no pighinaat nu no maaha to tibo kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Sikandin to soga no ogtang-ow to mgo otow no kona no Hibru. Aw ogbajawon koy isab no mgo Hibru no kaotawan nu, su seini Manyuyuwas iyan kasiga noy.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Natingaya to ginikanan ni Jesus to sikan pig-ikagi ni Simeon bahin to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Dajun ampu si Simeon no madojawan sikandan to Diyus. Pagkatapus, pig-ikagihan din si Maria, “Pigbootan to Diyus no seini no bata iyan ogpakailing to pagkabahin ta no mgo kaliwat ni Israel. To ogpasakup kandin, ogkayuwas. Di to ogsupak, ogkastiguhon to Diyus. Ogkakiyayahan no pigsugu sikandin to Diyus, di mahan-in to ogsupak kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kaling ogyagbasan to ginhawa nu to kaguul angod to mahait no ispada. Aw pinaagi kandin ogkamaanan to hona-hona to mahan-in no mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na, duon to Jerusalem meyduon isab bujag no kawayuan on mey-upat no tuig to idad no kibali ba-ba to Diyus. Iyan ngadan din si Ana no anak ni Panuel no kaliwat ni Aser. Pitu da no tuig to kaminyoon din, ");
INSERT INTO msmNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","nabayu on sikandin. Migpakamonang on duon to Bayoy to Diyus. Aedow dow madukilom ogsimba dow og-ampu aw ogpuasa. ");
INSERT INTO msmNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na, sikan no uras no duon pad onsi Jose to Bayoy to Diyus, migduguk si Ana. Migpasalamat sikandin to Diyus aw ingnawnangon din sikan bata duon to mgo otow no migtatagad to pagyuwas to Diyus kandan no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pagkatapus on to tibo tumanon no insugu to balaod to Ginuu, mig-uli si Jose dow si Maria diya to yunsud dan no Nazaret no sakup to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na, migtulin sikan bata no madoson dow maalamon, aw pinadajag sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Kada tuig og-andiya to mgo ginikanan ni Jesus to siyudad to Jerusalem su ogtambung to Pista to Pagyaboy. Na, pag-idad ni Jesus to sampuyu-tag-duwa, pigpaduma dan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Anoy man no natapus on to pista, mig-uli to mgo ginikanan ni Jesus no wada kamaan no migpabilin da naan sikandin diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nailing to boot dan no nakaduma si Jesus to kahan-inan no kadumahan dan no naman-uli, kaling migpadajun sikandan to pagpanow. Di pagkahapun to sikan no aedow no wada dan kitaa si Jesus, migsugud sikandan to pagpamangha kandin diya to mgo kadumahan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anoy man no wada dan kakita-i, migpauli sikandan diya to Jerusalem su diya dan ogpamanghaon. ");
INSERT INTO msmNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na, duon to ikatoyu no aedow, bali no nakitaan dan si Jesus no mig-ingkud duon to Bayoy to Diyus no migpagsakot to mgo maistru to tinuuhan. Naminog si Jesus kandan aw nangusip. ");
INSERT INTO msmNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tibo to migdinog kandin natingaya to pagpanabut dow pagpanabak din. ");
INSERT INTO msmNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Natingaya isab to mgo ginikanan ni Jesus no makitaan dan sikandin. Kagi to inoy din, “Aduy Utu, nokoy no nakayangub ka man to paghinang to angod to seini kanami? Siak dow to amoy nu yagboy on nalimuut ikow. Nakaaw-andei koy on to pagpamangha!” ");
INSERT INTO msmNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kagi ni Jesus, “Nokoy no ogpamanghaon a now man? Wada kow kamaan no kinahangyan no dini a to bayoy to Amoy ku?” ");
INSERT INTO msmNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Di wada dan kasabuti to kahuyugan to sikan kagi din. ");
INSERT INTO msmNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na, migduma si Jesus to mgo ginikanan din diya to Nazaret, aw masinuguton sikandin kandan. Di sikan tibo puli pighipidan ni Maria duon to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Migtulin si Jesus no migdugang to kaalam din, aw to Diyus dow mgo otow nasajaan kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Duon to ikasampuyu-tag-lima no tuig to paghari ni Tiberio, meyduon insugu to Diyus to sikan anak ni Zacarias no si Juan no duon ugpa to matahay no banwa. Na to diya no panahon, si Poncio Pilato iyan gubernadur to Judea, aw si Herodes to gubernadur to Galilea. Si Felipe no suun ni Herodes iyan gubernadur to Iturea dow Trakonite. Si Lisanias to gubernadur to Abilena. Si Anas dow si Caifas to kinayabawan no mgo magdudumaya to tinuuhan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Na, tapus sugua to Diyus si Juan, pigyogob-yogob din to kayunsudan no dakit to Jordan no wohig to pagpangwali. Kagi din, “Sosey kow. Talikudi now on to mgo sae now aw pabawtismu kow. Na, ogkapasaylu to mgo sae now.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sikan no pighinang ni Juan tahan da insuyat ni Isaias no kibali ba-ba to Diyus no pig-iling, “Duon to matahay no banwa meyduon ogbansagon no og-iling, ‘Hinaata now to dayan to Ginuu! Hawani now to ogbajaan din. ");
INSERT INTO msmNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tambakan to mgo anggob, aw tompagon to mgo bubungan. To baliku no dayan tul-idon, aw to nanduku-duku no dayan patagon. ");
INSERT INTO msmNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na, igpakita to Diyus to tibo kaotawan sikan Manyuyuwas no ogpaandinihon din.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mahan-in to mgo otow no og-andiya ki Juan su ogpabawtismu. Di pig-ikagihan din sikandan, “Sikiyu no angod to hayas no mgo malimbungon, nokoy no mig-andini kow man? Nailing buwa to boot now no ogpakalikoy kow to kaboyu to Diyus ko mabawtismuhan kow. ");
INSERT INTO msmNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ko tinood no migsosey kow on aw migtalikud kow to mgo sae now, ipakita sikan duon to pamatasan now. Kona kow ognalig no kaliwat kow ni Abraham no kona kow ogkastiguhon to Diyus. Su inggad ngani seini mgo batu ogkahinang to Diyus no mgo kaliwat ni Abraham. ");
INSERT INTO msmNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ko madoot to mgo hinang now, ogkaangod kow to kaju no puli nanda oggobaon aw ogsangabon su kona ogbogas to madojow.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dajun usip ki Juan sikan mgo otow, “Na, ko mailing to sikan, nokoy man to madojow no oghinangon noy?” ");
INSERT INTO msmNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Migtabak si Juan, “Ko pananglit daduwa to kabo now, ibogoy to sobuuk diya to wada kabo. Ko meyduon pagkoon now, bogaji now to diya wada ogkoonon.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Meyduon isab mgo magsukutay to buhis no naman-anduon su ogpabawtismu. Mig-usip sikandan, “Sir, nokoy man to madojow no oghinangon noy?” ");
INSERT INTO msmNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kagi ni Juan, “Kona now ogpasubrahan to pagpanukut to mgo otow. Iyan da tumanon now to igsugu to yabow now.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nangusip isab to mgo sundayu, “Na sikami, nokoy man to oghinangon noy?” Migtabak si Juan, “Kona kow ogpanghinaedok aw panghapey to mgo otow agun makasaepi kow. Mahustuhan kow on to suhue now.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Na, to kaotawan migtatagad to diya Insaad no Manyuyuwas, kaling nailing to hona-hona dan no basi iyan on si Juan. ");
INSERT INTO msmNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Di mig-iling si Juan, “Meyduon ogpakasunu no yabow pad yagboy kanay. Su ngani man to paghukas to sapatus din, di kona a og-angajan. Siak ogbawtismu iyu to wohig. Di sikan ognangonon ku, iyan igbawtismu din to Ispiritu Santu dow kaeju. ");
INSERT INTO msmNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Su ko sapimpinon din to otow no mangkadojow dow mangkadoot, ogkaangod to otow no og-ohut to trigu. Igbudiga din to trigu, di to ohut ogsangabon duon to kaeju no konad ogkaposok.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Mahan-in pad to duma no mgo kagi ni Juan no ingnongnong din to kaotawan aw pasabuta sikandan to Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Migpangaboyu isab sikandin ki Gubernadur Herodes tongod to madoot no mgo hinang din, yabi to pag-agow ki Herodias no asawa to suun din. ");
INSERT INTO msmNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Di migdugang yagboy to sae ni Herodes no ipaprisu din si Juan. ");
INSERT INTO msmNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Di no wada pad kaprisu si Juan, mahan-in pad to mgo otow no pigbawtismuhan din. Si Jesus migpabawtismu isab kandin. Pagkatapus, no mig-ampu pad si Jesus, naabri to yangit. ");
INSERT INTO msmNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dajun migkonsad duon kandin to Ispiritu Santu no angod to salapati aw taphun duon kandin. Meyduon isab kagi likat to yangit no mig-iling, “Sikuna to anak ku no pinadajag no ingkalipay ku yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Mgo katluan on no tuig to idad ni Jesus to pagsugud din to trabahu din. Nailing to boot to mgo otow no anak sikandin ni Jose. Si Jose anak ni Heli. ");
INSERT INTO msmNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Si Heli anak ni Matat. Si Matat anak ni Levi. Si Levi anak ni Melqui. Si Melqui anak ni Jana. Si Jana anak ni Jose. ");
INSERT INTO msmNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Si Jose anak ni Matatias. Si Matatias anak ni Amos. Si Amos anak ni Nahum. Si Nahum anak ni Esli. Si Esli anak ni Nagai. ");
INSERT INTO msmNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Si Nagai anak ni Maat. Si Maat anak ni Matatias. Si Matatias anak ni Semei. Si Semei anak ni Jose. Si Jose anak ni Juda. ");
INSERT INTO msmNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Si Juda anak ni Joanan. Si Joanan anak ni Resa. Si Resa anak ni Sorobabel. Si Sorobabel anak ni Salatiel. Si Salatiel anak ni Neri. ");
INSERT INTO msmNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Si Neri anak ni Melqui. Si Melqui anak ni Adi. Si Adi anak ni Cosam. Si Cosam anak ni Elmodam. Si Elmodam anak ni Er. ");
INSERT INTO msmNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Si Er anak ni Josue. Si Josue anak ni Eliezer. Si Eliezer anak ni Jorim. Si Jorim anak ni Matat. Si Matat anak ni Levi. ");
INSERT INTO msmNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Si Levi anak ni Simeon. Si Simeon anak ni Juda. Si Juda anak ni Jose. Si Jose anak ni Jonan. Si Jonan anak ni Eliaquim. ");
INSERT INTO msmNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Si Eliaquim anak ni Melea. Si Melea anak ni Mainan. Si Mainan anak ni Matata. Si Matata anak ni Natan. Si Natan anak ni David. ");
INSERT INTO msmNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Si David anak ni Isai. Si Isai anak ni Obed. Si Obed anak ni Boos. Si Boos anak ni Salmon. Si Salmon anak ni Naason. ");
INSERT INTO msmNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Si Naason anak ni Aminadab. Si Aminadab anak ni Admin. Si Admin anak ni Arni. Si Arni anak ni Hezron. Si Hezron anak ni Fares. Si Fares anak ni Juda. ");
INSERT INTO msmNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Si Juda anak ni Jacob. Si Jacob anak ni Isaac. Si Isaac anak ni Abraham. Si Abraham anak ni Tare. Si Tare anak ni Nahor. ");
INSERT INTO msmNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Si Nahor anak ni Serug. Si Serug anak ni Ragau. Si Ragau anak ni Peleg. Si Peleg anak ni Eber. Si Eber anak ni Sala. ");
INSERT INTO msmNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Si Sala anak ni Cainan. Si Cainan anak ni Arfaxad. Si Arfaxad anak ni Sem. Si Sem anak ni Noe. Si Noe anak ni Lamec. ");
INSERT INTO msmNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Si Lamec anak ni Matusela. Si Matusela anak ni Enoc. Si Enoc anak ni Jared. Si Jared anak ni Mahalaleel. Si Mahalaleel anak ni Cainan. ");
INSERT INTO msmNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Si Cainan anak ni Enos. Si Enos anak ni Set. Si Set anak ni Adan. Si Adan anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na, si Jesus no togob to Ispiritu Santu miglikat diya to Jordan no wohig aw pigpaandiya to Ispiritu Santu to matahay no banwa. ");
INSERT INTO msmNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Duon sikandin tintala ni Satanas sed to kap-atan no aedow. Wada sikandin koon-koon to diya no panahon, kaling pagkatapus, pigbontas sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Dajun ikagihi si Jesus ni Satanas, “Oho kun, ko tinood no Anak ka to Diyus, hinanga seini batu no koonon.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Di mig-ikagi si Jesus, “Pig-iling duon to Kasuyatan, ‘Kona no koonon da to ogpakabuhi to otow.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Pagkatapus, pigdaya sikandin ni Satanas diya to matikang hilabi no banwa. Songo pagpilok da, ingkahindu din on ki Jesus to mgo banwa duon to tibuuk kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Kagi ni Satanas, “Aha ka to suja. Siak to pigpaboot to sikan tibo, aw igbogoy ku diya to inggad hintawa no ogkaliyagan ku ogbogajan. Na, ko musimba ka kanay, igbogoy kud ikow to katongod to pagmandu to sikan tibo, aw hona-honaa dow man-u to pagkadongganon nu!” ");
INSERT INTO msmNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Di mig-ikagi si Jesus, “Pig-iling duon to Kasuyatan, ‘Simbaha to Ginuu no Diyus nu. Sikandin da to tumana.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Pigdaya manda si Jesus ni Satanas diya to siyudad to Jerusalem aw patindoga duon to matikang hilabi no bahin to Bayoy to Diyus. Kagi ni Satanas, “Na, ko tinood no Anak ka to Diyus, kawas ka diya to pasak. ");
INSERT INTO msmNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Su pig-iling duon to Kasuyatan, ‘Ogsuguon to Diyus to mgo anghil din to pagbantoy ikow. ");
INSERT INTO msmNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ogtamukon ka dan agun inggad to kobong nu kona ogpakaigu to batu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Di mig-ikagi si Jesus, “Pig-iling isab duon to Kasuyatan, ‘Kona nu ogpangantihan to Ginuu no Diyus nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Na, su wada katintal si Jesus, migyaguy si Satanas. Di mighona-hona sikandin no meyduon da aedow no og-isabon din ogtintalon si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na, si Jesus no piggahoman to Ispiritu Santu mig-uli diya to prubinsya to Galilea. To kabantug din migtangkap diya to mgo banwa no nasakup duon. ");
INSERT INTO msmNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nang-anad sikandin duon to mgo simbahan to mgo Hibru, aw nasaja sikandin to tibo kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Na, migtidow si Jesus diya to yunsud no Nazaret no pigtulinan din. No Aedow on no Tigpahuway, mig-andiya sikandin to simbahan su iyan man nabatasan din. Migtindog sikandin duon to atubangan to mgo otow su ogbasa to Kasuyatan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Intadwoy kandin to sinuyat ni Isaias no kibali ba-ba to Diyus to diya una agun basahon din duon to kaotawan. Pigbukyad din aw nakitaan din sikan pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Piggahoman a to Ispiritu to Ginuu su pigbogajan a din to katongod to pagnawnangon to Madojow no Nawnangonon diya to mgo pubri. Pigpaandini a din agun makayuwas to nangkaprisu, agun makakita to mgo buta, agun isab matabangan to mgo dinaog-daog. ");
INSERT INTO msmNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ognawnangonan ku isab to kaotawan no andam on to Diyus to pagyuwas kandan.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pagkatapus ni Jesus to pagbasa to Kasuyatan, pigyukut din aw i-uli duon to sikan pangabaga. Dajun sikandin ingkud su ogpang-anad. Iyan da mata to sikan tibo nahimun si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kagi din, “To pigdinog now kuntoon iyan katumanan to seini Kasuyatan.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pagdinog dan to kagi din, namakasaja sikandan ki Jesus su angod to pigpanodosan to madojow no pagkaikagi din. Kaling natingaya dow migpauusipay sikandan, “Eh, kona no anak man ni Jose seini no otawa?” ");
INSERT INTO msmNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kagi ni Jesus kandan, “Basi kay ikagihan a now to diya ikagihonon no pig-iling, ‘Sikuna no duktur, dukturi to kaugalingon nu no yawa. Hinanga dini to yunsud nu to nadinog noy no pighinang nu diya to Capernaum.’ ");
INSERT INTO msmNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Di seini da. To otow no kibali ba-ba to Diyus kona ogdawaton duon to yunsud din. ");
INSERT INTO msmNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Meyduon duma no pananglitan ku. To diya panahon ni Elias no kibali ba-ba to Diyus, migguyabung to tatoyu no tuig tonga. Pig-abut to mgo otow to makalilisang no bontas. Mahan-in to bayu no mgo bohi kani to Israel no nalisodan yagboy, ");
INSERT INTO msmNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","di iyan da pigpatabangan to Diyus ki Elias to bohi no taga-Sarepta no sakup to Sidon. ");
INSERT INTO msmNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","To diya isab panahon ni Eliseo no kibali ba-ba to Diyus, mahan-in kani to Israel no pigsangla, di si Naaman da no taga-Siria to naulian.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pagdinog to sikan mgo otow no nahimun duon to simbahan to kagi ni Jesus, naboyu yagboy sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pigpayuwas dan si Jesus duon to yunsud aw daeha pailing diya to peputukan to bubungan no nahimotangan to sikan yunsud su ig-uyug dan podom diya to aba. ");
INSERT INTO msmNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Di nasi on sikandin nanliot-liot to kahan-inan to kaotawan aw panow. ");
INSERT INTO msmNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tapus to sikan, migtogbang si Jesus diya to yunsud to Capernaum no sakup to Galilea. No Aedow on no Tigpahuway, nang-anad sikandin duon to simbahan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Hilabi sikandan natingaya su to pagpang-anad ni Jesus migdae to katongod. ");
INSERT INTO msmNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na, meyduon otow duon to simbahan no pigsamuk to madoot no ispiritu. Nakabansagon sikandin to maagbot no mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Sikuna, Jesus no taga-Nazaret, nokoy no oghilabot ka kanami? Basi kay mig-andini ka su ogyagyagon koy nu. Namaan a dow hintawa ka. Sikuna sikan Balaan no pigpaandini to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Di pigsapadan ni Jesus sikan madoot no ispiritu, “Pahagtong ka! Yogwa ka duon!” Paglihok to sikan madoot no ispiritu su ogyuwas, nakayapdos sikan otow duon to atubangan to kaotawan, di wada kaamonu. ");
INSERT INTO msmNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Natingaya to tibo mgo otow duon aw namakaikagi, “Nokoy man seini no pagpang-anad? Su mey gahom dow katongod din inggad ngani to pag-abug to mangkadoot no ispiritu!” ");
INSERT INTO msmNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dajun migtangkap to nawnangonon bahin ki Jesus duon to nakalibong no mgo banwa. ");
INSERT INTO msmNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dajun likat onsi Jesus duon to simbahan aw andiya to bayoy ni Simon. Pagtidow dan duon, pighangyu si Jesus no tabangan din to ugangan ni Simon no pigbogsangan to hingyow. ");
INSERT INTO msmNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Migpadani si Jesus aw domoyi sikan bujag no mighibat aw sugu no magawang sikan hingyow. Duon-dajun naulian sikan bujag. Migbangun sikandin aw honati din onsi Jesus to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Anoy man no migsayop on to soga, pigpandaya duon ki Jesus to tibo mgo otow no yain-yain to mgo sakit. Puli din da sikandan pigpandampa, dajun nangkaulian. ");
INSERT INTO msmNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pigpang-abug din isab to mangkadoot no ispiritu no migsamuk to mahan-in no mgo otow. Pagyogwa dan on, namangiyak sikandan no mig-iling, “Sikuna, Anak ka to Diyus!” Di pigsapadan ni Jesus sikan mgo ispiritu su namaan man sikandan no sikandin to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pagkamasem, migpahilit si Jesus. Di pigpamangha sikandin to mgo otow no kona ogkaliyag no ojowan din sikan banwa dan. ");
INSERT INTO msmNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Di mig-iling si Jesus, “Igwali ku pad to Madojow no Nawnangonon bahin to paghari to Diyus diya to duma no mgo kayunsudan, su sikan to impaandini kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Dajun sikandin andiya to kayunsudan no sakup to Judea aw wali duon to mgo simbahan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Songo aedow migpang-anad si Jesus diya to higad to danow to Galilea. Mig-aagow to mgo otow to pagpadani kandin agun makapaminog to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Duon kakita-i ni Jesus to daduwa no ka bangka no pigdohik to mgo mangisdaay no migwaswas to mgo pukut dan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Dajun sakoy si Jesus duon to sikan sakajan no ki Simon no pighingadanan isab ki Pedro, aw hangyu-a sikandin no ituyud agun makapadiyu-diyu to higad. Dajun ingkud si Jesus aw pang-anad. ");
INSERT INTO msmNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Pagkatapus to pagpang-anad ni Jesus, pig-ikagihan din si Simon, “Andiya kow to kadayoman aw ituntun sikan mgo pukut now agun makapudut kow to isda.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Kagi ni Simon, “Agayon, puli koy on nabukasan to pagpamukut, ampan napukutan noy. Di manno migsugu ka, ig-isab ku igtuntun seini mgo pukut.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na, paghaw-as dan to mgo pukut, ato! hilabi mahan-in to isda no napukutan dan hangtod no ogkahigbit on podom sikan mgo pukut. ");
INSERT INTO msmNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dajun dan kamaja sikan mgo duma dan no diya to yain no bangka su ogpabulig. Migduguk sikan mgo duma dan aw bubuligi to pagbatun to sikan mgo pukut. Naponu yagboy to isda sikan daduwa no ka bangka hangtod no madani on ogyogdang. ");
INSERT INTO msmNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pagkita ni Simon to sikan, migyuhud sikandin duon to atubangan ni Jesus aw makaikagi, “Ginuu, padiyu ka kanay, su makasasaya a.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nakaikagi si Simon to sikan su natingaya sikandin to sikan mahan-in yagboy no isda no napukutan dan. Sikan isab to pigbati to mgo duma din duon to sakajan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Natingaya isab sikan mgo duma dan duon to sikan yain no bangka no si Santiago dow si Juan no mgo anak ni Sebedeo. Dajun ikagihi ni Jesus si Simon, “Kona ka ogkahaedok. Hangtod kuntoon isda to nasakup to pukut nu. Di kuntoon, otow on to igpasakup ku ikow agun ogkahinang sikandan no mgo sakup ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tapus dan dohika sikan mgo sakajan diya to higad, pig-ojowan dan to tibo aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Duon to songo yunsud no pig-andiyaan ni Jesus, meyduon otow no pigtangkapan on to yawa din to sangla. Pagkita din ki Jesus, migyuhud sikandin duon to atubangan din aw pakimayuuy, “Sir, ko pagboot nu, ogkaulian a.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dajun dampaa ni Jesus sikan otow. Kagi din, “Ogbootan ku no maulian ka.” Duon-dajun naulian sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Dajun ikagi si Jesus, “Wada inggad hintawa no ognangonan nu to seini. Nasi no andiya ka to magdudumaya to tinuuhan ta aw pahiling-hiling ka. Pagkatapus, bogoy ka to halad no insugu ni Moises agun mamatuud no naulian kad.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Di nasi on migtangkap to nawnangonon bahin ki Jesus diya to kadiyuan. Kaling mahan-in to ogpamang-andiya ki Jesus agun makapaminog to kagi din aw mangkaulian to mgo sakit dan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Di si Jesus kanunoy migpahilit su diya sikandin og-ampu. ");
INSERT INTO msmNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","No mang-anad si Jesus duon to songo bayoy, nalibongan sikandin to naman-ingkud no mgo Pariseo dow mgo maistru to tinuuhan. Diya sikandan kapuun to kayunsudan to Galilea dow Judea hasta diya to siyudad to Jerusalem. Duon ki Jesus to gahom to Diyus to pagpangdojow to mgo masakiton. ");
INSERT INTO msmNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na, meyduon mgo otow no migtidow no namanyayahung to duma dan no naparalays. Ogsed podom sikandan agun ikabotang sikan otow duon to atubangan ni Jesus, ");
INSERT INTO msmNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","di wada kahimu su migdasok to mgo otow duon to bayoy. Kaling pigdaya dan sikan otow diya to atop. Piggawang dan to songo bahin to atop aw tuntuna sikan otow duon to atubangan ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Pagkita ni Jesus no hogot to pagtuu dan, pig-ikagihan din sikan otow no naparalays, “Yagi, pigpasaylu on to mgo sae nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pagdinog to sikan mgo maistru to tinuuhan dow mgo Pariseo to kagi ni Jesus, nailing to ginhawa dan, “Eh, seini no otawa ogpasipaya to Diyus su og-angkon no ogpakapasaylu sikandin to sae. Di wada yain no ogpakapasaylu to sae, Diyus da yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Di namaanan ni Jesus to hona-hona dan. Kaling pig-ikagihan din sikandan, “Nokoy no mighona-hona kow man to sikan? ");
INSERT INTO msmNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Andei man to mahaewoy, ko muiling a, ‘Pigpasaylu to mgo sae nu,’ ubin ko muiling a, ‘Tindog ka aw panow’? ");
INSERT INTO msmNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Di igpakita ku iyu no siak no Anak to Otow meyduon katongod kani to babow to kalibutan to pagpasaylu to sae.” Dajun ikagihi ni Jesus sikan otow, “Tindog ka. Yukuta aw daeha sikan pighibatan nu, aw uli kad on.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dajun tindog sikan otow duon to atubangan to sikan nahimun. Pigdawat din sikan pighibatan din aw uli no migsaja to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Na, sakot to kahaedok dow katingaya, pigsaja dan to Diyus. Kagi dan, “Ato! Kabeynganan yagboy to naaha ta kuntoon!” ");
INSERT INTO msmNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tapus to sikan, migpanow si Jesus aw nakayaboy to sukutanan to buhis. Pigkita din to magsukutay to buhis no mig-ingkud duon no iyan ngadan si Levi. Kagi ni Jesus, “Yagi, duma kad kanay su oghinangon ku sikuna no inanad.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Dajun ojowi ni Levi to tibo aw duma ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na, pigpakoon ni Levi si Jesus to bangkiti duon to bayoy din. Mahan-in to mgo magsukutay to buhis dow duma no mgo otow no migpagsayu ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Di to mgo inanad ni Jesus pigsagman to mgo Pariseo dow mgo maistru to tinuuhan. Mig-iling sikandan, “Nokoy no ogpagsayu kow man to sikan matuntuhon no mgo magsukutay to buhis dow duma no mgo makasasaya?” ");
INSERT INTO msmNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Si Jesus to migtabak kandan no impabaja to pananglitan. Kagi din, “To otow no wada sakit kona ogkinahangyan to duktur. Masakiton da to ogkinahangyan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Angod isab kanay no mig-andini to kalibutan. Kona no iyan ing-andini ku to pagkabig to mgo otow no mighona-hona no matarong sikandan. Di iyan ing-andini ku agun no musosey to mgo makasasaya aw talikudan to sae dan.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kagi to sikan mgo inila to tinuuhan, “To mgo inanad to mgo Pariseo dow to ki Juan no Magbawtismuhay kanunoy ogtuman to pagpuasa dow pag-ampu. Di to mgo inanad nu ogkoon dow og-inom inggad nokoy aedawa.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Kagi ni Jesus, “Ko pananglitan meyduon kumbiti, nokoy man, ogpuasa buwa to kadumahan to sikan bag-u kaminyo ko duma dan pad sikandin? Kona gajod! ");
INSERT INTO msmNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Di mey panahon no ogpuduton sikandin duon kandan, aw iyan pad pagpuasa to sikan piglikatan.” ");
INSERT INTO msmNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Impananglit isab ni Jesus to wada pagkahiujun to bag-u no impang-anad din dow sikan tahan no impang-anad to mgo Hibru. Kagi din, “Wada otow no ogtabas to bag-u no kabo aw itapak duon to tahan, su ogkauyakan sikan bag-u. Aw kona no oghiangay sikan tahan no kabo dow sikan bag-u no igtapak. ");
INSERT INTO msmNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kona ta isab igtagu to inomon no ogsobu pad on duon to tahan no sedanan no kindae, su madali ogbotu. Ogkauyakan gajod sikan inomon hasta sedanan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nasi no igtagu ta to bag-u no inomon duon to bag-u no sedanan. ");
INSERT INTO msmNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Wada isab ogkaliyag og-inom to bag-u no inomon ko makainom on to tahan su og-iling sikandin, ‘Madojow gajod sikan tahan.’” ");
INSERT INTO msmNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Songo Aedow no Tigpahuway, nakabaja si Jesus dow mgo inanad din duon to mgo uma. Nangotu to mgo inanad din to mgo uhoy to trigu. Pigkusu dan aw kitopa. ");
INSERT INTO msmNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Di pigsagman sikandan to mgo Pariseo. Kagi dan, “Hoy, nokoy no ogyapas kow man to Aedow no Tigpahuway?” ");
INSERT INTO msmNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Si Jesus to migtabak. Kagi din, “Ajaw now og-ilinga no wada kow makabasa to pighinang ni Hari David to diya una no bontason sikandin dow mgo duma din. ");
INSERT INTO msmNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Migsed sikandin duon to bayoy to Diyus aw pudut to pan no inghalad to Diyus. Pigkoon din aw bogaji to mgo duma din. Na, ojow pa to mgo balaod to tinuuhan ta, iyan da ogpakakoon to sikan to mgo magdudumaya to tinuuhan ta. Di manno kinahangyanon yagboy, wadad sapadi si David. ");
INSERT INTO msmNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na, siak no Anak to Otow iyan meyduon katongod to pagboot to Aedow no Tigpahuway.” ");
INSERT INTO msmNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Duon to yain no Aedow no Tigpahuway, migsed si Jesus duon to simbahan aw pang-anad. Mey otow duon no pawing to kalintuu no boyad. ");
INSERT INTO msmNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pigpaniidan yagboy si Jesus to mgo maistru to tinuuhan dow mgo Pariseo, su ko padojawon din sikan otow duon to sikan no aedow, meyduon igkariklamu dan kuntra kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Di namaanan ni Jesus to hona-hona dan. Pig-ikagihan din sikan pawing, “Yagi, tindog ka duon to kabaknaan.” Dajun tindog sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dajun usipa ni Jesus to nahimun no mgo otow, “Andei man to intugut to balaod to tinuuhan ta no oghinangon duon to Aedow no Tigpahuway, madojow ko madoot? Pagyuwas to kinabuhi ubin paghimatoy?” ");
INSERT INTO msmNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Migpan-aha-aha si Jesus to mgo otow no nakalibong. Dajun din ikagihi sikan pawing, “Kotonga sikan boyad nu.” Pagtuman din to sugu ni Jesus, dajun sikandin naulian. ");
INSERT INTO msmNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nangkaboyu yagboy sikan namanguntra ki Jesus aw sasabut dow og-amonuhon dan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Songo aedow miggamat si Jesus to bubungan su og-ampu, aw nabukasan sikandin duon. ");
INSERT INTO msmNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Pagkabukas on, pighimun din to mgo inanad din aw pili to sampuyu-tag-duwa no og-ilingon din to apustulis. ");
INSERT INTO msmNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Seini to mgo ngadan dan: si Simon no pighingadanan isab ni Jesus ki Pedro dow to suun din no si Andres, si Santiago dow si Juan, si Felipe dow si Bartolome, ");
INSERT INTO msmNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","si Mateo dow si Tomas, si Santiago no anak ni Alfeo dow si Simon no maunungon hilabi to tribu dan. ");
INSERT INTO msmNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Pigpili din isab si Judas no anak ni Santiago dow si Judas Iscariote no iyan ogyuib kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Anoy man no nakatogbang on sikandan, migtindog si Jesus duon to patag. Nahimun duon kandin to mahan-in no mgo sakup din. Mahan-in isab to mgo otow no migduguk no diya kapuun to prubinsya to Judea dow to siyudad to Jerusalem. To duma diya isab kapuun to mgo siyudad to Tiro dow Sidon no nakapahigad to dagat, hasta diya to nakalibong no mgo banwa. ");
INSERT INTO msmNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mig-anduon sikandan agun makapaminog to igpang-anad ni Jesus, agun isab mudojow to mgo sakit dan. Aw inggad to mangkadoot no ispiritu no migsamuk to mgo otow pigpang-abug din. ");
INSERT INTO msmNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Naningkamot sikan mgo otow no makatudi kandin, su meyduon gahom no ogyogwa likat to yawa din no ogpakauli to masakiton. ");
INSERT INTO msmNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dajun anada ni Jesus to mgo inanad din. Kagi din, “Igkadojow now no mgo pubri, su ogkasakup kow duon to sikan ogharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Igkadojow now no pigbontas kuntoon su diya to kayugajan oghantajon kow da. Igkadojow now no ogtiyahu kuntoon, su diya to kayugajan ogpakangisi kow da. ");
INSERT INTO msmNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Igkadojow now ko kuntrahon kow aw likajan hasta tamajon aw ilingon to madoot tongod kanay no Anak to Otow. ");
INSERT INTO msmNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Su sikan isab to pighinang to mgo kaaw-apuan dan to diya mgo otow no kibali ba-ba to Diyus. Na, ko mahitabu on sikan, linaksu kow tongod to kalipay su maaslag to igbayos iyu diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Di sikiyu no mgo sapian, hayahay kow iyan kuntoon, di alaot kow su diya to kayugajan, wadad ogkaiman now no kadojawan. ");
INSERT INTO msmNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sikiyu no nahantoy kuntoon, alaot kow su diya to kayugajan, kanunoy kow on ogbontason. Sikiyu no ogngisi kuntoon, alaot kow su diya to kayugajan kanunoy kow ogmey-og dow ogtiniyahu. ");
INSERT INTO msmNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Alaot kow ko sajaan kow to kaotawan, su pigsaja isab to kaaw-apuan dan to mgo otow to diya una no kunungkun kibali mgo ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Di seini da. Higugmaa to mgo kuntra now. Dedeyjawa to ogdomot iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pangamuju kow to Diyus no kae-atan din to mgo otow no ogpanungajow dow ogyupig iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ko meyduon ogsampalu ikow, ipasampalu isab to dibayuy no pisngi nu. Ko meyduon og-agow to kabo nu, ajaw ogpogongi to pagpudut to mahalon no ilisan nu. ");
INSERT INTO msmNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","To ogpamuju, bogaji. To puli ogpudut to katigajunan nu, kona nud on oghawion. ");
INSERT INTO msmNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hinanga diya to duma to ogkaliyagan now no iyan oghinangon duon iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ko iyan da higugmaon now to otow no oghigugma iyu, nokoy pad man to ogkaiman now to Diyus? Su ngani man to mgo makasasaya, di oghigugma to diya oghigugma kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ko iyan da ogmadojawan now to otow no ogpagmadojow iyu, nokoy man to ogkaiman now to Diyus? Su ngani man to mgo makasasaya, di ogmadojawon dan to mgo duma dan no ogpagmadojow kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko iyan da pautangon now to otow no ogpakabajad, nokoy pad man to ogkaiman now to Diyus? Su ngani man to mgo makasasaya, di ogpautang to duma dan no makasasaya no ogpakabajad. ");
INSERT INTO msmNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Di sikiyu, higugmaa to mgo kuntra now. Dedeyjawa sikandan aw pautanga inggad kona makabajad. Na, ko tumanon now sikan, ogkakiyaya no anak kow to Diyus no Yabow to Tibo. Maaslag yagboy to igbayos din iyu. Su ngani man to mgo otow no madoot to batasan no kona ogpasalamat kandin, di angod da to kayuuy to Diyus kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kaling mukae-at kow angod to pagkae-at to Diyus no Amoy now no diya to yangit.” ");
INSERT INTO msmNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Migpadajun si Jesus to pag-ikagi, “Kona kow ogpanawoy to duma su unu ko sikiyu nasi to sawajon to Diyus. Kona kow ogpanghukum to duma su unu ko sikiyu nasi to hukuman to Diyus. Pasaylu kow to otow no ogpakasae iyu agun pasayluhon kow to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bogaji to duma no ogpanginahangyan, aw ogbayosan kow to Diyus. Igpananglit ta to bogas no igtagu duon to saku. Og-unahon ta ogdasokon aw pagkatapus, dugangan dow pautuhan. Su ko man-u to igbogoy now iyan da ogsukudan to ogkadawat now.” ");
INSERT INTO msmNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mig-usip si Jesus pinaagi to pananglitan, “Mighona-hona kow no to buta ogpakapikit to angod din no buta? Kona, su ogkauyug sikandan tibo duon to yugi! ");
INSERT INTO msmNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","To inanad kona ogpakayabow to maistru din. Di ko maamuhan din on to tibo natagahan to maistru din, ogpakatopong on sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Mig-iling isab si Jesus, “Sikuna no oghukum to duma, nokoy no oghukum ka man to otow no mae-puling da to sae no sikuna man to mae-trusu to sae no nakabaebag duon to mata nu? Nokoy no kona man no sikan to ogliparahon nu? Og-amonuhon nu man to pag-ikagi no ogkuhigon nu sikan maintok no puling to duma, no mae-trusu man to ikow no puling? Kunungkun mangkatarong! Gawanga naa sikan mae-trusu no puling nu agun mapajag to pag-aha nu, ayha kuhiga sikan maintok no puling to duma. ");
INSERT INTO msmNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Wada madojow no kaju no ogbogas to madoot. Wada isab madoot no kaju no ogbogas to madojow. ");
INSERT INTO msmNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Inggad nokoy no kaju, to bogas din ogpakiyaya dow nokoy kajuha, ko madojow ubin madoot. Aw to sampinit kona ogbogas to matam-is. ");
INSERT INTO msmNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ogkakiyayahan isab to otow pinaagi to pagpang-iikagi din. To madojow no otow madojow to hona-hona, kaling madojow to ogkaikagi din. Di to madoot no otow, madoot to hona-hona, kaling madoot to ogkaikagi din. Su inggad nokoy to ogkahona-honaan to otow iyan isab ogyogwa duon to ba-ba din. ");
INSERT INTO msmNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nokoy no og-angkon kow man no siak to Magboboot now ko kona now ogtumanon to og-ikagihon ku iyu? ");
INSERT INTO msmNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","To otow no og-andini kanay no ogdinog aw ogtuman to kagi ku ");
INSERT INTO msmNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ogkaangod to otow no migtugdok to bayoy. Migkabut sikandin hangtod no pigtidow din to batu no pigpasikadan to bayoy. Na, pagdusu to sigoy, nadaghaan sikan bayoy to wohig di wada gajod kaamonu su madigon man to pagkatugdok. ");
INSERT INTO msmNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Di to otow no ogdinog to kagi ku no kona ogtuman ogkaangod to otow no migtugdok to bayoy duon to pasak no wada hinangi to pasikadanan. Na, pagdusu to sigoy, nadaghaan to wohig. Aw ato! Maagbot yagboy to pagkawasa!” ");
INSERT INTO msmNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Pagkatapus ni Jesus to pagpang-anad, mig-andiya sikandin to Capernaum. ");
INSERT INTO msmNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Duon to sikan no yunsud meyduon kapitan to mgo sundayu no taga-Roma. Meyduon suguonon din no pighilabi din no pakamatajon on. ");
INSERT INTO msmNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pagkadinog to sikan kapitan bahin ki Jesus, pigsugu din to inila no mgo Hibru to paghangyu ki Jesus aw pagdokat kandin agun padojawon din sikan suguonon. ");
INSERT INTO msmNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pagtidow dan duon ki Jesus, migpakimayuuy sikandan no naman-iling, “Sadangay duma ka kanami aw padojawa to suguonon to sikan migsugu kanami. Angajan sikandin no tabangan nu ");
INSERT INTO msmNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","su pighigugma ki din no mgo Hibru. Pigpahinangan koy din man ngani to simbahan.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dajun duma si Jesus kandan. Di no makadani on sikandan to bayoy, pigsugu to sikan kapitan to mgo duma din to pagtagbu ki Jesus aw paikagihi, “Sir, kona kad ogpatidow dini kanay su kona a no angay no ogpaponhik ikow dini to bayoy ku. ");
INSERT INTO msmNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kaling wada ad tagbu su pighona-hona ku no kona a ngani og-angajan ogpadani ikow. Di inggad puli nu ikagihon no maulian seini suguonon ku, ogkatuman sikan. ");
INSERT INTO msmNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Su naanad ad to sugu, su inggad siak meyduon yabow ku. Meyduon isab obos ku no mgo sundayu. Ogpakasugu a man ngani to sundayu ku to, ‘Andiya ka.’ Na, ogtuman sikandin. Ko paandinihon ku kanay to duma, og-andini. To suguonon ku isab ogtuman dajun ko suguon ku. Na, ogtumanon man ngani to inggad nokoy no igsugu ku, sikunad man to kona tumanon ko musugu ka.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pagkadinog ni Jesus to kagi to sikan kapitan, natingaya yagboy sikandin. Piglingi din to mgo otow no migduma kandin aw ikagihi, “Disti on ko migkita a to pagtuu no angod to kadigon to sikan, inggad pad kani to mgo kaliwat ni Israel!” ");
INSERT INTO msmNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na, pagpauli to sikan mgo sinugu diya to bayoy, pigkita dan no naulian on sikan suguonon. ");
INSERT INTO msmNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wada kayugoy mig-andiya si Jesus to yunsud to Nain dinumahan to mgo inanad din hasta to panon to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Anoy man no madani on sikandan duon to yawanganan pailing diya to yunsud, iyan yagboy pagyuwas to mgo otow no ogyobong to minatoy. Sikan minatoy sobuukon no anak no yukos to sikan bohi no bayu no pigdumahan to mahan-in no mgo taga-yunsud. ");
INSERT INTO msmNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pagkita to Ginuu to sikan bayu, pigkae-atan din yagboy aw ikagihi din, “Sigkon kad to ogtiyahu.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Migpadani si Jesus aw tagoni sikan pigpahibatan to sikan minatoy. Migsigkon sikan namanyayahung, aw ikagi si Jesus, “Utu, bangun ka.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dajun nakabangun sikan minatoy aw nakaikagi. Dajun sikandin ibogoy ni Jesus diya to inoy. ");
INSERT INTO msmNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Natingaya hilabi sikandan tibo aw pigsaja dan to Diyus no mig-iling, “Pigpaandini to Diyus ita seini gamhanan yagboy no otow to pagtabang to kaotawan din.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Migtangkap to nawnangonon bahin ki Jesus diya to tibuuk Judea dow diya to nakalibong no mgo banwa. ");
INSERT INTO msmNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Na, si Juan no Magbawtismuhay no diya to prisuhan pignangonan to mgo inanad din bahin to sikan pinanghinang ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pagkadinog ni Juan to sikan, pigsugu din to daduwa no mgo inanad din diya ki Jesus no Ginuu su igpausip din dow sikandin to diya ogpaabuton dan ubin ko meyduon pad yain. ");
INSERT INTO msmNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Pagtidow to sikan mgo sinugu ni Juan duon ki Jesus, pigkita dan to mgo otow no naulian on to yain-yain no mgo sakit. Meyduon isab pigpangsamuk to mangkadoot no ispiritu dow mgo buta no pinang-ulian ni Jesus. Dajun padani sikan daduwa no mgo inanad ni Juan aw ikagihi si Jesus, “Sir, pigsugu koy ni Juan dini ikow su igpausip ka dow sikuna to diya ogpaabuton noy ubin ko meyduon pad yain.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Dajun tabak si Jesus, “Pauli kow diya ki Juan aw nangoni to pigkita dow pigdinog now kani. Ikagihi now no nakakita on to mgo buta, nakapanow on to mgo pulid, naulian on to pigpangsangla, aw nakadinog on to mgo bongey. Nabanhaw on to mgo patoy, aw to mgo pubri nakadinog on to Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Madojow to otow no kona ogduwa-duwa to pagtuu kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Paglikat on to sikan mgo sinugu ni Juan, pig-ikagihan ni Jesus sikan mgo otow no nahimun duon, “No umandiya kow ki Juan diya to matahay no banwa, nokoy man to pigpamangha now? Otow buwa no ogkaisab-isab to hona-hona angod to tigbow no ogkawkaemagon? Kona. ");
INSERT INTO msmNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Na, nokoy naan? Otow buwa no nangabo to mahalon? Kona. Su to mgo otow no ogpangabo to mahalon diya da ogkitaon to palasyu. ");
INSERT INTO msmNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Na, nokoy man yagboy to ing-andiya now? Otow buwa no kibali ba-ba to Diyus? Sikan iyan, di si Juan yabow pad to diya duma no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Su sikandin to diya suguonon no ognangonon to Diyus duon to Kasuyatan no pig-iling, ‘Meyduon suguonon ku no ogpaunahon ku ikow agun mahinaat din to mgo otow to pagtidow nu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ligdongi now seini,” kagi ni Jesus. “Wada pad on yagboy otow no yabow ki Juan. Di duon to ogharian to Diyus, inggad to kinaobosan no otow yabow pad ki Juan.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Na, sikan mgo otow no naminog ki Jesus, yakip to mgo magsukutay to buhis, migpabawtismu sikandan ki Juan to diya una su pig-angkon dan no tinood to diya impaikagi to Diyus ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Di to mgo Pariseo dow mgo maistru to tinuuhan, pig-ojowan dan to pagboot to Diyus kandan, kaling wada sikandan pabawtismu. ");
INSERT INTO msmNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Na,” kagi ni Jesus, “nokoy man to ogkaangodan to mgo otow kuntoon? ");
INSERT INTO msmNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Angod sikandan to balingag no mgo bata duon to usibaanan. Ogsabihon sikandan to mgo duma dan no og-iling, ‘Piglisagan noy sikiyu, di wada kow sinajow. Migdegmatoy koy isab, di wada kow tiniyahu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Angod kow to sikan mgo bata su ngani si Juan no Magbawtismuhay no ogpuasa aw kona og-inom to inomon, oghapoyan now no piggahoman to madoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Hasta siak no Anak to Otow no migduma-duma iyu to pagkoon dow pag-inom, pigsawoy a now isab. Og-ilingon a no yogodon dow palahobog dow duma to mgo magsukutay to buhis hasta duma no makasasaya. ");
INSERT INTO msmNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Di inggad sikan on, ogkamaanan no hustu to impang-anad ku dow to impang-anad ni Juan, su ogkitaon sikan duon to kinabuhi to mgo otow no ogtuu.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Meyduon songo Pariseo no iyan ngadan si Simon no mig-imbita ki Jesus to pagkoon. Pagtidow ni Jesus duon to bayoy din, migdudunga sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na, duon to sikan no yunsud meyduon bohi no makasasaya. Pagkamaan din no migkoon si Jesus duon to bayoy to sikan Pariseo, mig-anduon sikandin no migdae to pahomut no intagu duon to mahalon no butilya. ");
INSERT INTO msmNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pagtidow din duon, migtindog sikandin duon to dani to nabotangan to kobong ni Jesus. Migtiyahu sikandin hangtod no nabasa to yuha din sikan mgo kobong ni Jesus. Dajun din pahidi to bubue din aw pinaulii to paghadok to kobong ni Jesus aw hudhudi to pahomut. ");
INSERT INTO msmNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Pagkita to sikan Pariseo no mig-imbita ki Jesus to pighinang to sikan bohi, nailing to ginhawa din, “Ko tinood pa no kibali ba-ba to Diyus seini no otawa, ogkatagahan din podom no makasasaya seini bohi no migtagon kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Di namaanan da ni Jesus to hona-hona ni Simon. Kaling mig-iling sikandin, “Meyduon ignangon ku ikow.” Kagi ni Simon, “Ikagihi a Sir.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Migpananglit si Jesus, “Meyduon songo otow no migpautang to saepi diya to daduwa no ka otow. Sikan sobuuk nakautang to lima no gatus, aw sikan sobuuk, kalim-an da. ");
INSERT INTO msmNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Di wada sikandan makabajad. Kaling pigpapas din on sikan mgo utang dan. Na, hintawa man yagboy to sikan daduwa to oghigugma to sikan nautangan?” ");
INSERT INTO msmNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Migtabak si Simon, “Sikan buwa nakautang to madogi.” Kagi ni Jesus, “Hustu to pagkatabak nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dajun din lingi-a sikan bohi, di si Simon to pig-ikagihan din, “Ahaa seini bohi. Pig-imbita a nu dini to bayoy nu, di wada a nu bogaji to wohig no ighugas to kobong ku no iyan nabatasan ta. Di seini bohi, pighugasan din to kobong ku to yuha din aw pahidi to bubue din. ");
INSERT INTO msmNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Sikuna, wada a nu man kumustaha to hadok no iyan nabatasan ta. Di seini bohi, wada din sigkoni to paghadok to kobong ku sugud to pagtidow ku. ");
INSERT INTO msmNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wada nu isab hinakihi to uyu ku no iyan nabatasan ta, di sikandin, pigpahomutan din to kobong ku. ");
INSERT INTO msmNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kaling inggad man-u to kadogi to sae din, ogkapasaylu sikandin su yabow man to gugma din kanay. Di to otow no maintok da to sae no napasaylu, maintok da isab to gugma.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Dajun pig-ikagihan ni Jesus sikan bohi, “Pigpasaylu on to mgo sae nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","To mgo otow no migpagdunga kandin to pagkoon namakailing duon to ginhawa dan, “Hintawa man otawa seini no ogpatugu ogpasaylu to mgo sae?” ");
INSERT INTO msmNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Di pig-ikagihan ni Jesus sikan bohi, “To pagtuu nu kanay iyan nakayuwas ikow. Na, uli kad no mahusoy to ginhawa.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wada kayugoy mig-andiya si Jesus to kayunsudan dow kabaryuhan to Galilea duma sikan sampuyu-tag-duwa no mgo inanad din. Mignawnangon sikandin to sikan Madojow no Nawnangonon bahin to paghari to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Mahan-in to mgo bohi no migduma-duma kandan no mig-atiman ki Jesus dow to mgo inanad din ginamit to kaugalingon dan no saepi. Meyduon mgo bohi duon no nangkasakit no nadojow ni Jesus, aw to duma pig-abugan din to mangkadoot no ispiritu. Yakip duon si Juana, si Susana dow si Maria Magdalena. Si Maria to diya pig-abugan ni Jesus to pitu no ka madoot no ispiritu. Si Juana to asawa ni Cusa no sinaligan ni Gubernadur Herodes. ");
INSERT INTO msmNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Songo aedow mighagudhud duon ki Jesus to mahan-in no mgo otow likat to mgo kayunsudan. Pig-anad din sikandan no impabaja to pananglitan. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Meyduon mag-uuma no mig-odok to binhi. Pagsabud din, meyduon mgo binhi no duon kodog to dayan aw kagiok-gioki to mgo otow, aw to duma pigpanubug to mgo manuk-manuk. ");
INSERT INTO msmNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Meyduon isab binhi no duon kodog to batuhon no pasak. Paggiti to sikan, dajun da migyanos su matahay sikan pasak. ");
INSERT INTO msmNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Meyduon isab binhi no duon kodog to pasak no tahan mey dalid to sampinit. Dongan to pagtubu to sikan mgo tanom, nanalingsing isab sikan mgo sampinit hangtod no pigyam-od sikan mgo tanom. ");
INSERT INTO msmNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Di to duma no mgo binhi duon kodog to madojow no pasak. Miggiti sikan aw pamogas dow hilabi mig- but.” Dajun ikagi si Jesus to maagbot, “Sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tapus to pag-ikagi ni Jesus, nangusip to mgo inanad din, “Nokoy man to igpasabut to diya pananglitan nu?” ");
INSERT INTO msmNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kagi ni Jesus, “To paghari to Diyus no wada din ipasabut to diya una impasabut on iyu. Di to duma no mgo otow igpabaja ku to pananglitan agun no ‘Inggad og-aha sikandan, kona ogpakakita. Inggad ogdinog, kona ogpakasabut.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kagi ni Jesus, “Kuntoon igpasabut ku iyu sikan pananglitan. Sikan binhi no ing-odok ogkaangod to kagi to Diyus no ignawnangon diya to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sikan dayan no nasabudan to binhi ogkaangod to mgo otow no ogdinog to kagi to Diyus, di og-agawon da ni Satanas sikan kagi duon to ginhawa dan su unu ko makatuu sikandan aw mayuwas. ");
INSERT INTO msmNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sikan batuhon no pasak no nasabudan to binhi ogkaangod to mgo otow no ogtukhow no ogdawat to kagi to Diyus no ogdinogon dan. Di kona no hogot to pagtuu dan, kaling kona ogyugoy. Su ko abuton sikandan to mgo panganti, og-ojowan dan dajun to pagtuu dan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sikan isab sampiniton no pasak no nasabudan to binhi ogkaangod to mgo otow no ogdinog to kagi to Diyus, di ogkawili sikandan to mgo kalimuutanan dow pagpadatu hasta to kalipajanan to kinabuhi. Kaling kona ogsangkod to pagtuu dan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Di sikan madojow no pasak ogkaangod to madojow no mgo otow no ogdinog dow ogdawat to kagi to Diyus aw tumana. Ogpadajunon dan to pagtuu dan hangtod no ogbogas to madogi sikan kagi to Diyus duon to kinabuhi dan.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Migpadajun si Jesus to pag-ikagi, “Wada otow no ogtakyuban to gantangan sikan ogsogaan din. Kona din isab igbotang duon to sayad to katri. Di nasi no igbotang duon to untudanan agun tibo ogkatang-awan duon to sed to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na, ko malisig on to mgo aedow, tibo to wada kasabuti kuntoon ogkatagahan dow ogkakitaan da. ");
INSERT INTO msmNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kaling kinahangyan maminog kow, su ogdugangan to Diyus to pagsabut to otow no ogdawat to igpasabut kandin. Di to otow no kona ogdawat to igpasabut kandin to Diyus oggawangon pad inggad sikan maintok no pagsabut no pig-isip din no duon on kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Songo aedow migtidow to inoy ni Jesus dow mgo suun no yukos, di wada sikandan makapadani su migdadasok to mgo otow duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na, mey mignangon kandin no migtidow to inoy dow mgo suun din, aw ogpayuwason sikandin su meyduon tuud dan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kagi ni Jesus, “Hoo iyan, di iyan og-isipon ku no inoy dow suun yagboy to otow no ogpaminog to kagi to Diyus aw tumana.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Songo aedow pig-ikagihan ni Jesus to mgo inanad din, “Ogyopa kinow to seini danow.” Dajun sikandan pamansakoy aw tukud. ");
INSERT INTO msmNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na, anoy man no nahina-hina on to pagpanow dan, nalipodong si Jesus. Puli nakatokow mighodos to maagbot hilabi no kaemag, aw katogob sikan bangka to limason tongod to maagbot no bayod. ");
INSERT INTO msmNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dajun pukawa si Jesus to mgo inanad din aw ikagihi, “Agayon, ogyogdang kid kay!” Dajun buyat si Jesus aw sapadi to kaemag dow mgo bayod. Dajun mig-ondang to kaemag, migyonong on to wohig aw miglinow on to panahon. ");
INSERT INTO msmNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kagi ni Jesus, “Andeid man to pagsalig now?” Natingaya yagboy to mgo inanad din aw nahaedok. Migpauusipay sikandan, “Nokoy man buwa otawa seini no inggad kaemag dow bayod ogpasapad kandin?” ");
INSERT INTO msmNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Migtidow onsi Jesus duon to banwa no sakup to Gerasa duon to dihipag to danow to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Paghaw-as ni Jesus, meyduon otow no taga-duon no migduguk kandin no pigsedan to mangkadoot no ispiritu. Nayugoy on sikandin to wada pangabo aw diyad ugpa to siminteryu. ");
INSERT INTO msmNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Kanunoy on sikandin pigpadamaan. Inggad oggapuson to kadina to boyad dow kobong din aw bantaji, ogkangkabigtow sikan gapus din. Dajun sikandin ogdaehon to sikan mangkadoot no ispiritu diya to hilit. Na, pigsugu ni Jesus sikan mangkadoot no ispiritu no yagujan dan sikan otow. Dajun yuhud sikan otow duon to atubangan ni Jesus aw bansagon to sobuuk no ispiritu no migsed duon kandin, “Jesus no Anak to Diyus no Yabow to Tibo, nokoy man to yabot nu kanay? Sadangay ajaw a ogkastiguha.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dajun usipa ni Jesus sikan ispiritu, “Hintawa to ngadan nu?” Migtabak sikandin, “Si Linibu to ngadan ku.” Pig-iling din to sikan su mahan-in yagboy sikandan no migsed to sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Dajun sikandan nangamuju no kona og-abugon pailing diya to banwa no kastiguhanan no wada kinotoban to kadayom. ");
INSERT INTO msmNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Na, duon to daligdigan to bubungan meyduon mahan-in hilabi no mgo babuy no nandungae. Nangamuju sikan mgo ispiritu ki Jesus no pasedon sikandan duon to sikan mgo babuy. Na, pagtugut ni Jesus, ");
INSERT INTO msmNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","pigyagujan dan sikan otow aw sed duon to sikan mgo babuy. Dajun pamanlinaguy sikan mgo babuy no namanyus-ug duon to pangpang aw kangkatabug diya to wohig. ");
INSERT INTO msmNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pagkita to sikan namanbantoy to babuy to nahitabu, namanlinaguy sikandan pailing diya to yunsud dow kaumahan aw inangon to nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dajun anduon to kaotawan su ogsusihon dan. Pagtidow dan duon ki Jesus, pigkita dan sikan otow no pigyagujan on to mangkadoot no ispiritu. Mig-ingkud on sikandin duon to atubangan ni Jesus no nakapangabo on aw madojow on to boot. Kaling nangkahaedok sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sikan namakakita to diya no hitabu mignangon to pagyaguji to sikan otow to mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Dajun hangyu-a si Jesus to tibo mgo taga-duon no yagujan din sikandan su nahaedok sikandan. Kaling nanakajan onsi Jesus su og-uli diya to banwa dan. ");
INSERT INTO msmNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na, nangamuju sikan otow no pigyagujan to mangkadoot no ispiritu no padumahon sikandin ni Jesus. Di wada tugut si Jesus. Kagi din, ");
INSERT INTO msmNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Uli kad nasi aw nawnangon ka dow man-u to pagtabang to Diyus ikow.” Dajun panow sikan otow diya to yunsud aw inawnangon to pagtabang ni Jesus kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pagpauli ni Jesus diya to Galilea, nahinangop to mgo otow to pagdawat kandin su pigpaabut dan man sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Meyduon isab migtidow no panguyu to simbahan to mgo Hibru no iyan ngadan si Jairo. Migyuhud sikandin duon to atubangan ni Jesus aw pangamuju. Kagi din, “Sadangay duma ka diya to bayoy ku, ");
INSERT INTO msmNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","su pakamatajon on to iiyanon no anak ku no bohi no sampuyu-tag-duwa no tuig to idad.” Dajun duma si Jesus kandin. Na, pagpanow din on, mahan-in to mgo otow no migdadasok duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na, duon to sikan no mgo otow meyduon bohi no migyayangosa sed on to sampuyu-tag-duwa no tuig. Wada inggad hintawa no nakauli kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Dajun padani sikan bohi duon to talikudan ni Jesus aw tudi-a sikan migjawing-jawing duon to sidsid to kabo din. Duon-dajun migtigpok to pagyangosa din. ");
INSERT INTO msmNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dajun usip si Jesus, “Hintawa man to migtudi kanay?” Di tibo nangindoy. Kagi pa ni Pedro, “Agayon, mahan-in seini mgo otow no migdadasok ikow!” ");
INSERT INTO msmNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Di mig-ikagi si Jesus, “Meyduon iyan migtudi kanay, su migbati a no meyduon gahom no migyogwa kani to yawa ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Na, pagkamaan to sikan bohi no kona ogkalidung sikan pighinang din, namidpid sikandin no migpadani ki Jesus aw yuhud duon to atubangan din. Duon to nahimun no mgo otow, ingnangon din dow nokoy no pigtudi din to kabo ni Jesus hasta to kalit no pagkaulii din. ");
INSERT INTO msmNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Dajun ikagihi ni Jesus sikan bohi, “Iya, to pagsalig nu kanay iyan nakadojow ikow. Na, uli kad on no mahusoy to ginhawa.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","No mig-ikagi pad si Jesus to sikan bohi, meyduon migtidow no napuun diya to bayoy to sikan panguyu to simbahan no mig-ikagi, “Bog-atad to ginhawa nu su nabigtawan on sikan anak nu. Wadad on pues ko mupadajun pad seini maistru.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pagdinog ni Jesus to sikan, pig-ikagihan din si Jairo, “Kona ka ogkahaedok. Salig ka puli kanay su ogkabuhi da sikan anak nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pagtidow ni Jesus diya to bayoy ni Jairo, iyan da pigpased din si Pedro, si Juan, si Santiago dow to ginikanan to sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Namaniyahu to tibo mgo otow duon aw pamandegmatoy. Di mig-ikagi si Jesus, “Sigkon kow on to ogdegmatoy su wada kamatoy sikan bata, nalipodong puli.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pigngingisihan dan si Jesus su namaanan dan man no patoy on iyan sikan bata. ");
INSERT INTO msmNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Di pigdawat ni Jesus to boyad to sikan bata aw ikagihi, “Igi, bangun ka.” ");
INSERT INTO msmNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dajun makaginhawa sikan bata aw bangun, aw igda si Jesus no bogajan to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Hilabi natingaya to ginikanan to sikan bata, di pigbahog sikandan ni Jesus no wada ognangonan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Songo aedow pighimun ni Jesus to mgo inanad din no sampuyu-tag-duwa su ogsuguon din to pagnawnangon to Madojow no Nawnangonon to paghari to Diyus. Pigbogajan din sikandan to gahom dow katongod to pag-abug to mangkadoot no ispiritu dow to pagpang-uli to mgo masakiton. ");
INSERT INTO msmNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kagi din, “Kona kow ogdaya to inggad nokoy no ogkagamit duon to panow now, inggad agos, inggad puju, inggad baaw, inggad saepi. Kona kow isab ogdaya to ilisan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ko ogsed kow to yunsud, pakamonang kow duon to bayoy no ogpaabutan now kotob no mupanow kow on. ");
INSERT INTO msmNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Di ko kona kow dawaton duon to sikan no yunsud, yaguji now aw padpada to abug to sapatus now pagpakiyaya no kona kow on ogkasukutan ko kastiguhon sikandan.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Dajun likat to mgo inanad ni Jesus aw yogob-yogoba dan to kayunsudan to pagnawnangon to Madojow no Nawnangonon. Pinang-ulian dan isab to mgo masakiton duon to kada banwa no pig-andiyaan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pagkadinog ni Gubernadur Herodes to nangkahinang ni Jesus, nalibod sikandin su yain-yain to hona-hona to mgo otow. Meyduon naman-iling no si Jesus iyan si Juan no Magbawtismuhay no nabanhaw. ");
INSERT INTO msmNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Meyduon isab naman-iling no sikandin si Elias ubin duma no otow to diya una no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Di si Herodes mig-iling, “Si Juan pigpatampodan kud on man to liog. Na, hintawa man naan sikan ognangonon dan?” Kaling naningkamot si Herodes no makitaan din si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Anoy man no nakapauli on to mgo apustulis duon ki Jesus, ingnangon dan kandin to nangkahinang dan. Dajun sikandan dumaha ni Jesus diya to yunsud to Betsaida no sikandan da. ");
INSERT INTO msmNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Di pagkamaan to kaotawan, migyupug sikandan. Nahinangop si Jesus to pagdawat kandan. Ing-anad din kandan to paghari to Diyus, aw pigpandojow din to nangkasakit duon. ");
INSERT INTO msmNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Anoy man no mahapun on, sikan sampuyu-tag-duwa no mgo inanad ni Jesus migduguk kandin aw ikagi, “Mahapun on kay to kani. Madojow ko paandiyaon ta seini mgo otow to kabaryuhan dow kaumahan agun mamangha to pagkoon dow ogkahibatan dan, su dini ki man to hilit.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Di kagi ni Jesus, “Sikiyu to mupakoon kandan.” Kagi dan, “Eh, lima da kay no buuk to pan noy dow daduwa da isab no ka isda, gawas ko pabolihon koy nu to igu no ogkakoon to seini mahan-in hilabi no mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Su ko mgo yukos da to bilangon, mgo lima no libu sikandan no nahimun duon. Dajun ikagihi ni Jesus to mgo inanad din, “Pamaingkuda to mgo otow to tinag-kalim-an to kada grupu.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pigtuman dan to sugu din aw naman-ingkud to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pigdawat ni Jesus sikan lima no buuk no pan dow daduwa no ka isda aw yanghag diya to yangit to pagpasalamat to Diyus. Dajun din panibaga sikan pan dow isda aw ibogoy diya to mgo inanad din agun ipamogoy diya to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mighan-in yagboy sikan pan dow isda, kaling nakakoon sikandan tibo kotob no nangkahantoy. Tapus to pagkoon, pigpanghimun to mgo inanad to nasama no pinanibag no pan dow isda, aw kaponu to sampuyu-tag-duwa no ayat! ");
INSERT INTO msmNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Songo aedow migpapaawoy si Jesus no mig-ampu, di to mgo inanad din duon da to kadanihan. Tapus to pag-ampu, pig-usip ni Jesus to mgo inanad din, “Nokoy man to hona-hona to mgo otow bahin kanay? Hintawa a kun man?” ");
INSERT INTO msmNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Migtabak sikandan, “Meyduon og-iling no si Juan ka no Magbawtismuhay. Meyduon isab og-iling no si Elias ka. To duma og-iling no sobuuk ka to diya kibali mgo ba-ba to Diyus to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kagi ni Jesus, “Na sikiyu, nokoy man to ogkaikagi now bahin kanay? Hintawa a man?” Dajun migtabak si Pedro, “Sikuna to diya Insaad no Manyuyuwas no pigpaandini to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na, pigbahog sikandan ni Jesus no wada ognangonan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mig-ikagi isab si Jesus, “Kinahangyan no siak no Anak to Otow og-antus yagboy. Ogtalikudan a to inila no angod ta no mgo Hibru dow to yabow no mgo magdudumaya to tinuuhan ta hasta to mgo maistru to tinuuhan. Kinahangyan no himatajan a, di ogbanhawon a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Dajun ikagihi ni Jesus sikan tibo kaotawan no nahimun, “Inggad hintawa no ogkaliyag ogpasakup kanay, kinahangyan no ojowan din to mgo kagustuhon din aw tiang to krus din kada aedow aw unung kanay. ");
INSERT INTO msmNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","To otow no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay inggad igkamatoy din nasi ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Inggad pananglit maangkon to otow to tibo kadatu kani to kalibutan, nokoy man to pues din to sikan ko magawangan sikandin to kinabuhi aw makastigu to wada katapusan? ");
INSERT INTO msmNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Su siak no Anak to Otow, ko igkasikow a to inggad hintawa, hasta to igpang-anad ku igkasikow din, igkasikow ku isab sikandin ko mupauli a dini no ogkasul-uban to kasilow ku dow to kasilow to Diyus no Amoy ku hasta to mgo anghil. ");
INSERT INTO msmNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Di meyduon duma kani iyu no monang da ogkamatoy ko maaha dan on to paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pagyaboy to wayu no aedow, pigpaduma ni Jesus si Pedro, si Juan dow si Santiago diya to bubungan su og-ampu sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pag-ampu ni Jesus, naisab sikandin, aw to kabo din ogpakasilow yagboy to kaputi. ");
INSERT INTO msmNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Puli nakatokow meyduon daduwa no ka otow no masilow isab no migpag-isturya ki Jesus. Sikandan si Moises dow si Elias, aw iyan pig-iisturyahan dan to kamatajon ni Jesus no madani din on ogtumanon diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nalipodong si Pedro dow to mgo duma din di pagbuyat dan, pigkita dan sikan kasilow ni Jesus dow sikan daduwa no ka otow no migtindog duon to dani din. ");
INSERT INTO msmNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","No oglikat on sikan mgo otow, nakaikagi si Pedro ki Jesus, “Sir, madojow su nakaandini ki. Oghinang koy to tatoyu no ka hoyunganan, sobuuk to ikow, sobuuk to ki Moises dow sobuuk to ki Elias.” Di angod to pigdaham-daham si Pedro. ");
INSERT INTO msmNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","No mig-ikagi pad sikandin, meyduon gabun no natuntun duon kandan. Nangkahaedok sikan tatoyu no matongos to sikan gabun, ");
INSERT INTO msmNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","aw meyduon pigdinog dan no kagi no napuun duon no mig-iling, “Anak ku seini no pigbootan ku to pagtuman to pagboot ku. Paminog kow kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tapus ikagihi sikan tatoyu no mgo inanad, pigboyong dan dajun sikan daduwa no ka otow. Iyan nanda nabilin duon to atubangan dan si Jesus. Na, sikan pigkita dan pighipidan duon to mgo hona-hona dan. Wada inggad hintawa no pignangonan dan to sikan no panahon. ");
INSERT INTO msmNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pagkabukas, no mutogbang on si Jesus dow mgo duma din to sikan bubungan, pigtagbu sikandan to mahan-in no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Meyduon yukos duon no migsabi ki Jesus to maagbot, “Sir, sadangay ahaa seini sobuukon no anak ku ");
INSERT INTO msmNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","no ogpadamaan to madoot no ispiritu. Hinggawan sikandin ogpakapangiyak aw ogkabidbid to yawa din dow ogbubuya to ba-ba. Ogkabun-ug yagboy sikandin su halus konad ogtakasan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nangamuju a to mgo inanad nu no abugon dan podom, di wada dan kahimu-i.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mig-ikagi si Jesus, “E-ay, sikiyu no mgo otow kuntoon, pagkabaliku now! Wada pagsalig now to Diyus. Andei man ogkakotob to pagduma ku iyu? Kagan-u man ogkatapus seini pag-antus ku iyu?” Dajun din ikagihi sikan amoy, “Daeha dini sikan anak nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pagpatideg to sikan bata diya ki Jesus, miglihok sikan madoot no ispiritu no migpadama kandin. Di pagsapadi ni Jesus to sikan ispiritu, migdojow sikan bata. Dajun ibogoy ni Jesus diya to amoy. ");
INSERT INTO msmNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nangkaboyong yagboy to tibo mgo otow to gahom to Diyus. No dugaja pad natingaya to kaotawan to sikan nahinang ni Jesus, pig-ikagihan din to mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Domdoma now seini og-ikagihon ku. Siak no Anak to Otow igdata diya to mgo otow no oghimatoy kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Di wada dan kasabuti sikan kagi din su wada sikandan pasabuta to Diyus. Nataha isab sikandan to pag-usip. ");
INSERT INTO msmNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Songo aedow migyayalis to mgo inanad ni Jesus dow hintawa to yabow duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Di namaanan ni Jesus to mgo hona-hona dan. Kaling migpudut sikandin to bata aw patindoga duon to dani din ");
INSERT INTO msmNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dow ikagihi sikandan, “Inggad hintawa no ogdawat to bata no angod to seini tongod kanay, kibali siak to ogdawaton. Aw to ogdawat kanay kibali ogdawat isab to sikan migpaandini kanay. Su to kinaobosan kani iyu iyan nasi yabow.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Mig-ikagi si Juan ki Jesus, “Agayon, migkita koy to otow no nang-abug to mangkadoot no ispiritu no iyan piggamit to ngadan nu. Di manno kona ta sikandin no sakup, pigsapadan noy.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Mig-iling si Jesus, “Wada now podom sapadi, su inggad hintawa no kona ogsupak ita ogkatawag no duma ta.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Anoy man no madani on ogbatunon si Jesus diya to yangit, pighogot din to planu to pag-andiya to siyudad to Jerusalem. Andam on to ginhawa din to inggad nokoy no ogkahitabu kandin diya. ");
INSERT INTO msmNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Kaling meyduon pigpauna din diya to songo baryu no sakup to Samaria agun mahinaat dan to paghapit din duon. ");
INSERT INTO msmNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Di to mgo taga-duon wada tugut no oghapit si Jesus duon kandan su diya man sikandin ogdeg to Jerusalem no siyudad to mgo Hibru. Su migdinomotay to mgo taga-Samaria dow mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pagkamaan ni Santiago dow ni Juan no kona sikandan ogpahapiton duon to sikan no baryu, naboyu sikandan. Kagi dan ki Jesus, “Ginuu, gustu nu no ogsugu koy to kaeju no oglikat to yangit agun mapuu sikandan?” ");
INSERT INTO msmNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Di pig-atubang sikandan ni Jesus aw sapadi. ");
INSERT INTO msmNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dajun sikandan panow pailing diya to yain no baryu. ");
INSERT INTO msmNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pagpanow on onni Jesus, meyduon otow no ogduma podom. Kagi din ki Jesus, “Ogduma a ikow inggad andei ka mudeg.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Di mig-ikagi si Jesus, “Madojow pad to milo su meyduon ogkaugpaan. Madojow pad isab to manuk-manuk su meyduon ogkahapunan. Di ogkalisodan ka ko muduma ka kanay no Anak to Otow, su wada makopot no kaugpa ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Meyduon yain no otow no pig-ikagihan ni Jesus, “Duma ka kanay.” Di kagi din, “Sir, og-uli a pad su igyobong ku to amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Di mig-iling si Jesus, “Duma ka kanay kuntoon. Pabay-ani sikan patoy no igyobong to duma no angod isab to mgo patoy. Di sikuna, panow ka aw inawnangon to paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Meyduon pad yain no mig-ikagi ki Jesus, “Ogduma a ikow Sir, di kona naa kuntoon su ogpanumaid a pad to pamilya ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Di mig-ikagi si Jesus kandin, “To otow no ogyangan to pagsunud kanay ogkaangod to mag-uuma no ogpakatagon on to daru di oglingi-lingi pad diya to hudihan. Sikan no otow kona og-angajan to pagnawnangon to paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dajun isab pili to Ginuu to kapituan-mey-daduwa no mgo otow no pigparis-paris din aw paunaha diya to mgo baryu dow mgo banwa no og-andiyaan din. ");
INSERT INTO msmNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kagi ni Jesus kandan, “Mahan-in to ogkaliyag podom ogpaminog to Madojow no Nawnangonon. Angod sikandan to mayow-ag no uma no anihonon on, di minus to mag-anihay. Pangamuju kow to Diyus no iyan tag-iya to sikan uma no musugu sikandin to duma no mag-anihay, no ko ita pa, dugang no mgo otow no ogpakabulig to pagnawnangon to sikan Madojow no Nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Panow kow, di bantoy kow su ogkaangod kow to nati no karneru no ogkalibongan to mgo mangongoon. ");
INSERT INTO msmNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kona kow ogdae to saepi ubin puju ubin sapatus no og-ilisan. Kona kow isab ogsigkon duon to dayan inggad meyduon ogpag-isturya iyu agun kona kow mayangan. ");
INSERT INTO msmNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Inggad hintawa no bayoy to ogkaponhikan now, iyan unahon now to pagpanalangin, umiling kow, ‘Madojawan podom to Diyus seini no panimayoy.’ ");
INSERT INTO msmNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ko meyduon otow duon to sikan no bayoy no og-angajan to sikan no panalangin, ogkadawat din sikan. Di ko wada, ogsibog da sikan duon iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kona kow ogpapangaelin. Nasi pakamonang kow duon to bayoy no ogpaabutan now. Koon dow inom kow to inggad nokoy no ighonat iyu, su to otow no ogtrabahu angajan no ogsuhuyan. ");
INSERT INTO msmNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ko dawaton kow duon to songo yunsud, koon dow inom kow to inggad nokoy no ighonat iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pangdojawa now to mgo masakiton duon aw nangoni now no to paghari to Diyus madani on ogkatuman duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Di ko kona kow dawaton duon to songo yunsud, tindog kow diya to karsada aw umiling kow, ");
INSERT INTO msmNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aha kow. Inggad to abug no migdokot kani to sapatus noy ogpadpadon noy pagpakiyaya no kona koy on ogsukutan ko kastiguhon kow. Di kona kow ogkalingow no madani on ogkatuman to paghari to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Indani now seini. Duon to Aedow to Paghukum, ko mabog-at on man to kastigu no igpahamtang to mgo taga-Sodoma no nahilabihan to kadoot, iyan on man to mgo otow no kona ogpaminog iyu!” ");
INSERT INTO msmNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Migpadajun si Jesus to pag-ikagi, “Alaot kow no mgo taga-Corasin dow taga-Betsaida! Madojow pad to taga-Tiro dow taga-Sidon, su ko sikandan pa to migkita to diya mgo milagru no pighinang ku duon iyu, nayugoy da podom sikandan ojow to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Indani now seini. Duon to Aedow to Paghukum, ko mabog-at on man to kastigu no igpahamtang to mgo taga-Tiro dow taga-Sidon, iyan on man sikiyu no mgo taga-Corasin dow taga-Betsaida! ");
INSERT INTO msmNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Sikiyu isab no mgo taga-Capernaum, ogkaliyag kow no og-abuton now suja taba to yangit, di nasi no igyon-ok kow diya to kinadidayoman to pasak.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pig-ikagihan isab ni Jesus sikan ogsuguon din, “Inggad hintawa no ogpaminog iyu kibali siak to ogpaminogon, aw to otow no kona ogdawat iyu kibali siak to kona ogdawaton. Sikan kona ogdawat kanay kibali kona isab ogdawat to sikan migpaandini kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anoy man no migpauli on sikan kapituan-mey-daduwa no ka otow diya ki Jesus, malipajon sikandan no mig-ikagi, “Ginuu, inggad to mangkadoot no ispiritu migsugut kanami no gamiton noy to ngadan nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Kagi ni Jesus, “Nasaepan ku si Satanas no nauyug likat to yangit no angod to kilat. ");
INSERT INTO msmNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Na, pigbogajan ku sikiyu to gahom agun no inggad makatikhon kow to hayas dow salipit-sipit, wada ogkaamonuhan now. Ogkadaog now isab to gahom ni Satanas no kuntra ta. ");
INSERT INTO msmNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Di ajaw kow oglipay su ogsugut iyu to mangkadoot no ispiritu. Nasi no iyan ikalipay now su to mgo ngadan now ingkasuyat on duon to listahan diya to yangit.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","To diya no panahon, piglipay si Jesus to Ispiritu Santu. Kagi din, “Amoy ku no Magboboot to yangit dow pasak, ogpasalamat a ikow su sikan inlidung nu to idukadu no mgo otow dow to yabow to naamuhan impasabut nud nasi diya to obos no mgo otow. Nailing to sikan su iyan man pagboot nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dajun ikagihi ni Jesus sikan mgo otow, “To tibo panabut insalig kanay to Diyus no Amoy ku. Wada yain no namaan kanay, sikandin da. Wada isab yain no namaan kandin, siak da dow to mgo otow no gustu ku no mukiyaya kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Dajun atubanga ni Jesus to mgo inanad din aw ikagihi no sikandan da, “Madojow kow su migkita kow on to diya og-awoson no ogkitaon to mgo hari to diya una dow to diya mgo otow no kibali ba-ba to Diyus, di wada dan kakita-i. Mig-awos isab podom sikandan no makadinog to sikan nadinog now kuntoon, di wada dan kadinogi.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Songo aedow meyduon maistru to tinuuhan no migtogkad ki Jesus. Kagi din, “Sir, nokoy man to oghinangon ku agun maangkon ku to kinabuhi no wada katapusan?” ");
INSERT INTO msmNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Migtabak si Jesus, “Nokoy man to nasuyat duon to mgo balaod to Diyus? Nokoy man to pagsabut nu to sikan?” ");
INSERT INTO msmNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Migtabak sikan maistru to tinuuhan, “Pig-iling duon, ‘Higugmaa to Ginuu no Diyus nu to bug-us no ginhawa dow hona-hona nu hasta to tibuuk no kinabuhi dow doson nu. Higugmaa isab to isigkaotow nu angod to paghigugma to kaugalingon nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Mig-ikagi si Jesus kandin, “Hustu to pagkatabak nu. Ko tumanon nu sikan, ogkaangkon nu to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Di pig-usip din si Jesus, “Hintawa man naan sikan isigkaotow ku no oghigugmaon ku?” Ing-usip din sikan agun makailing to mgo otow no sikandin to hustu. ");
INSERT INTO msmNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Migtabak si Jesus pinaagi to pananglitan, “Meyduon otow no migtogbang likat to siyudad to Jerusalem pailing diya to Jerico. Duon to dayan pigbanganan sikandin to mgo tulisan. Pighukasan dan to kabo dow papakuja aw ojowi no pakamatajon. ");
INSERT INTO msmNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pagkahina-hina, meyduon magdudumaya to tinuuhan ta no mgo Hibru no nakabaja duon. Pagkita din to sikan otow no nakahibat duon to kilid to dayan, diya sikandin baja to dibayuy no kilid aw puli din yabaji. ");
INSERT INTO msmNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nakabaja isab to pangabaga duon to Bayoy to Diyus no kaliwat ni Levi. Pagkita din to sikan otow, diya sikandin baja to dibayuy no kilid to dayan aw yabaji din isab. ");
INSERT INTO msmNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tapus to sikan, meyduon nakabaja duon no taga-Samaria. Na, to mgo taga-Samaria dow to mgo Hibru migdinomotay, di pagkita din to sikan Hibru no nakahibat duon to dayan, pigkae-atan din. ");
INSERT INTO msmNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pig-anduon din aw tambaya to yana dow inomon to mgo pali to sikan otow aw pamogkota. Dajun din iyuwan duon to asnu din aw daeha diya to paabutanan dow atimana. ");
INSERT INTO msmNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pagkabukas, pigbogajan din to saepi sikan migdumaya to paabutanan aw ikagihi, ‘Dedeyjawa to pag-atiman kandin. Ko ugaling musubra to ogkagastu nu, ogbajadan ku sikuna ko makapauli a dini.’ ");
INSERT INTO msmNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Na,” kagi ni Jesus, “to paghona-hona nu, hintawa to sikan tatoyu to madojow no isigkaotow to sikan pigtulis?” ");
INSERT INTO msmNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Sikan maistru to tinuuhan migtabak, “Sikan migkae-at kandin.” Kagi ni Jesus, “Sikan iyan. Na, sunuda sikan pighinang din.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Migpadajun onsi Jesus to pagpanow hangtod no migtidow to baryu no pig-ugpaan to migsusuun no si Marta dow si Maria. Pagkita ni Marta ki Jesus, pigpapadajun din duon to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mig-ingkud si Maria duon to atubangan ni Jesus su ogpaminog to mgo kagi din. ");
INSERT INTO msmNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Di si Marta wada kahimotang to paghikoy to ighonat to bisita dan. Dajun sikandin padani ki Jesus aw ikagi, “Ginuu, wada ka kita kanay no naatsa-atsa on to mgo lihokonon kani to bayoy? Pabuligi a kun to sikan suun ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Di pig-ikagihan nasi si Marta to Ginuu, “Eh Marta, mahan-in to ogpakaatsa-atsa ikow no mgo hinangonon. ");
INSERT INTO msmNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Di sobuuk da yagboy to impurtanti. Sikan to pigpili ni Maria, aw kona sikan ogkaagow kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Songo aedow mig-ampu si Jesus. Pagkatapus din on, mig-ikagi to sobuuk no inanad din, “Ginuu, anada koy to pag-ampu. Su to mgo inanad ni Juan no Magbawtismuhay pigpang-anad din to pag-ampu.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Mig-ikagi si Jesus kandan, “Ko og-ampu kow, ilingon now to seini: Amoy noy, tahudon ka podom yagboy. Muhari ka podom to tibo kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bogaji koy to pagkoon noy kada aedow, ");
INSERT INTO msmNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","aw pasayluha koy to mgo sae noy su ogpasayluhon noy to tibo ogpakasae kanami. Tabangi koy isab agun kona koy matintal.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mig-ikagi isab si Jesus kandan, “Meyduon pananglitan ku bahin to pag-ampu. Meyduon otow no mig-andiya to bayoy to yagi din no tonga on to kadukiloman aw tawag, ‘Yagi, pautanga a to bogas nu ");
INSERT INTO msmNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","su pigtidow a to kiyaya ku no napuun diya to madiyu. Di wada igkahonat ku kandin.’ ");
INSERT INTO msmNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kagi to sikan yagi din no diya to sed, ‘Ajaw ad ogsamuka, yagi, su siradu on to pertahan. Kona ad ogpakabangun to pagbogoy ikow su mighibat ad on hasta to mgo anak ku.’ ");
INSERT INTO msmNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Inggad migyayagi sikandan, wada sikandin bangun to pagbogoy to pigkinahangyan to sikan duma din. Di manno wada kasikow sikan sobuuk aw wada takas to pagpamuju, napogos sikan tag-bayoy to pagbangun aw bogaji kotob to pigkinahangyan din. ");
INSERT INTO msmNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Paminog kow,” kagi ni Jesus. “Pamuju kow to Diyus aw ogbogajan kow. Pamangha kow aw ogpakakita kow. Panuktuk kow aw ogpasedon kow. ");
INSERT INTO msmNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Su inggad hintawa no ogpamuju ogpakadawat, to ogpamangha ogpakakita, aw to ogpanuktuk ogpasedon. ");
INSERT INTO msmNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Sikiyu no mgo ginikanan, ko mamuju to anak now to isda, kona no iyan igbogoy now to hayas. ");
INSERT INTO msmNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ko ogpamuju to atoyug, kona no iyan igbogoy now to salipit-sipit. ");
INSERT INTO msmNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ogbogoy kow to kadojawan diya to mgo anak now, inggad man-u to kadoot now. Iyan on man kona mubogoy to Diyus no Amoy now no yangitnon to Ispiritu Santu ko pamujuon now sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Songo aedow meyduon pig-abug ni Jesus no madoot no ispiritu no iyan nakailing to pagkapoha to songo otow. Pagyaguy to sikan ispiritu, nakaikagi on sikan poha, kaling nangkatingaya to nahimun no mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Di meyduon naman-iling, “Kae! Ogpakaabug sikandin to mangkadoot no ispiritu su pigbogajan to gahom ni Satanas no panguyu dan!” ");
INSERT INTO msmNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Meyduon isab mgo otow no mig-anti ki Jesus. Mighangyu sikandan no ipakita din to milagru no ogpakiyaya no to Diyus iyan migpadae kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Di namaanan ni Jesus to hona-hona dan, kaling pig-ikagihan din, “Ko pananglit og-uunoy oggera to mgo sakup to songo nasyun, ogkabongkag sikan no nasyun. Angod to sikan to ogkadeygan ko meyduon panimayoy no og-uunoy ogbubuyow-buyow to mgo sakup duon. ");
INSERT INTO msmNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Angod da isab ki Satanas. Ko amung-amungon din to sakup din no mgo ispiritu, kona oghangtod to pagmandu din. Naikagi ku seini su pighapoyan a now no to gahom ni Satanas iyan kun ig-abug ku to mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na, ko iyan pa ig-abug ku to gahom ni Satanas, sikan isab mgo sakup now no ogpang-abug to mangkadoot no ispiritu, ki Satanas naan no gahom to ig-abug dan? Sikandan mismu iyan ogmatuud no nasajop kow. ");
INSERT INTO msmNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Di ko iyan ig-abug ku to gahom to Diyus, ogkamaanan now no oghari on to Diyus dini iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pananglit meyduon madoson no otow no migbantoy to bayoy din, wada kaagow to katigajunan din su sangkap sikandin to armas. ");
INSERT INTO msmNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Di songo aedow, meyduon yabow to kadoson no migsulung kandin aw kadaog. Dajun pamuduta to mgo panganiban hasta duma no katigajunan din aw bahin-bahina diya to mgo kadumahan din.” Migpasabut si Jesus no nadaog din on iyan si Satanas, kaling ogpakaabug sikandin to mangkadoot no ispiritu. ");
INSERT INTO msmNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na,” kagi ni Jesus, “inggad hintawa no kona ogpadapit kanay iyan ogsupak kanay. To otow isab no kona ogbulig kanay to paghimun iyan ogpasuwoy to mgo otow no ogpadani podom kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Dajun pananglit on isab si Jesus, “Meyduon madoot no ispiritu no naabug duon to otow no pigsedan din. Migpaligbut sikan ispiritu duon to matahay no mgo banwa to pagpamangha to ogkaugpaan din. Di anoy man no wada nakitaan din, mighona-hona sikandin no ogpauli diya to una no pig-ugpaan din. ");
INSERT INTO msmNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na, pagpauli din on duon to sikan otow, naaha din no angod on to bayoy no sinilhigan no wadad mig-ugpa aw madojow on to pagkatapid. ");
INSERT INTO msmNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Dajun sikandin pandokat to pitu no mgo angod din no yabow pad to kadoot aw isab sed duon to sikan otow. Na, ko malisod on man to kabotang to sikan otow to diya una, iyan on man kuntoon!” ");
INSERT INTO msmNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","No mig-ikagi pad si Jesus, meyduon bohi duon no mig-ikagi to maagbot, “Madojow to inoy no mig-anak aw migpadudu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Kagi ni Jesus, “Hoo iyan, di yabi no madojow to mgo otow no ogpaminog to kagi to Diyus aw tumana.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Paghagudhud on to kaotawan duon ki Jesus, pig-ikagihan din sikandan, “Pagkadoot to mgo otow kuntoon! Ogpamangha sikandan to milagru no ogpakiyaya no Diyus iyan to migpadae kanay. Di iyan da igkapakita kandan to angod to nahitabu ki Jonas to diya una. ");
INSERT INTO msmNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Su to diya nahitabu ki Jonas migpakiyaya to mgo taga-Ninibe no pigsugu sikandin to Diyus. Dow to ogkahitabu isab kanay no Anak to Otow iyan ogpakiyaya to mgo otow kuntoon no pigsugu a to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na, ko muabut on to Aedow to Paghukum, ogbasuyon kow to diya rayna to Seba. Su inggad madiyu, di migpaahot sikandin to pagpanow agun makapaminog to maalamon no kagi ni Hari Salomon. Di kuntoon meyduon dini iyu no yabow pad on ki Salomon, di wada kow paminog to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ogbasuyon kow isab to mgo taga-Ninibe duon to Aedow no Paghukum su pagwalihi kandan ni Jonas, migsosey sikandan aw talikudi to mgo sae dan. Di kuntoon, mey kani iyu no yabow pad on ki Jonas, di wada kow paminog to kagi din.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kagi ni Jesus, “Wada otow no ogtakyuban to gantangan sikan ogsogaan din. Kona din isab ighobong. Di nasi no igbotang duon to untudanan agun tibo ogkatang-awan duon to sed to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","To mata now iyan ogkaangodan to lamparahan no ogtang-ow to yawa now. Ko mating-ow to pag-aha now, ogkatang-awan to tibuuk no yawa now. Di ko madoot to mata now, ogkadigyoman to tibuuk no yawa now. ");
INSERT INTO msmNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kaling pakatigpod kow agun kona masajop to panghona-hona now. Nailing buwa to boot now no natang-awan kow on, di nadigyoman kow pad naan! ");
INSERT INTO msmNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Di ko wada kadigyom duon iyu, ogkatang-awan yagboy to yawa now, angod to soga no ogtang-ow iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pagkatapus ni Jesus to pag-ikagi, meyduon Pariseo no mig-imbita kandin to pagkoon diya to bayoy din. Pagtidow ni Jesus, migdunga sikandin ");
INSERT INTO msmNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","no wada panghugas to boyad no iyan tumanon to mgo Hibru. Kaling natingaya sikan Pariseo. ");
INSERT INTO msmNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Di mig-ikagi to Ginuu, “Sikiyu no mgo Pariseo, ogkaangod kow to tasa dow kalduhan no iyan da nahugasan to yuwas, di maligsom duon to sed. Su ogtuman kow iyan to mgo tumanon to tinuuhan ta, di iyan da nakased duon to hona-hona now to kahakog dow kadoot. ");
INSERT INTO msmNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mgo yangog kow yagboy! Wada kow naan kamaan no to Diyus no mighinang to yawa to otow iyan isab mighinang to hona-hona no nakased duon? ");
INSERT INTO msmNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Di seini da. Unaha deyjawa to hona-hona now agun ogpakapamogoy kow to mgo pubri, na, ogkalimpyu kow yagboy. ");
INSERT INTO msmNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Di alaot kow no mgo Pariseo su ogtuman kow iyan to pagbogoy to Diyus to ikasampuyu no bahin to pinangitaan now inggad to kinaminusan no mgo gulajon dow aanagay, di ogpabay-anan now to hustisya dow to paghigugma now to Diyus. Madojow man hinuun to pagbogoy to ikasampuyu no bahin to pinangitaan now, di ajaw ogpabay-ani sikan yabow no impurtanti. ");
INSERT INTO msmNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Alaot kow no mgo Pariseo, su duon to simbahan iyan ogkaliyagan now to ingkudanan no kaning inila, aw ogtukhow kow ko pakitaon to pagtahud duon to karsada. ");
INSERT INTO msmNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Alaot kow su angod kow to mgo yobong no wada indan no ogkagiok-giokan to mgo otow. Su sikiyu to ogkapuunan to kadoot to kaotawan, di wada dan kamaani.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Meyduon maistru to tinuuhan no mig-ikagi ki Jesus, “Sir, pigpasikawan koy nu isab tongod to sikan pigpang-ikagi nu bahin to mgo Pariseo.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kagi ni Jesus, “Alaot kow isab no mgo maistru to tinuuhan ta su ogpabog-atan now to mgo otow to mgo sugu no mangkalisod ogtumanon. Di sikiyu, puli now igkayoy to mgo boyad now. ");
INSERT INTO msmNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Alaot kow su oghinangan now to mangkadojow no pinajag to mgo yobong to diya kibali mgo ba-ba to Diyus no pigpanghimatajan to mgo kaaw-apuan now. Duon to sikan, ogkakiyaya no ogpakaujun kow to diya pigpanghinang dan. ");
INSERT INTO msmNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kaling to Diyus no maalamon yagboy nakailing, ‘Meyduon pad ogsuguon ku diya to mgo Hibru no oghinangon ku no kibali ba-ba ku dow duma no mgo suguonon. Di meyduon ogpanghimatajan dan, aw ogpaantuson dan isab to duma.’ ");
INSERT INTO msmNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sikan to oghinangon now agun no sikiyu kuntoon iyan ogsukutan to kamatajon to diya tibo mgo otow no kibali ba-ba to Diyus sugud pad to sinugdanan to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sikan iyan. Sikiyu to ogsukutan to kamatajon to diya tibo kibali mgo ba-ba to Diyus sugud ki Abel kotob ki Zacarias no duon himataji to pagtongaan to Bayoy to Diyus dow sikan haladanan. ");
INSERT INTO msmNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Alaot kow no mgo maistru to tinuuhan ta su ogyobogon now to hona-hona to mgo otow bahin to kagi to Diyus. Iyan ogkaangodan now to otow no kona ogkaliyag ogsed to bayoy, aw pighipidan din to liyabi agun wada duma no ogpakased.” ");
INSERT INTO msmNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pagkalius ni Jesus duon, to mgo Pariseo dow to mgo maistru to tinuuhan migsugud to pagsupak yagboy kandin. Kanunoy dan pigpangusip-usip si Jesus ");
INSERT INTO msmNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","agun mabitik sikandin ko masajop to tabak din. ");
INSERT INTO msmNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Duon to sikan no panahon, mighagudhud duon ki Jesus to linibu no kaotawan no migdadasok hangtod no ogkangkagiok-giokan to duma dan. Iyan una no pig-ikagihan ni Jesus to mgo inanad din. Kagi din, “Likaji now to patubu to mgo Pariseo, no ko ita pa, sikan pagpamatitinood dan. ");
INSERT INTO msmNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Di og-abut da to panahon no ogkaukisan to tinakyuban, aw ogkabutwa to inghobong. ");
INSERT INTO msmNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","To diya pigpang-ikagi now no wada katagahi, ogkatagahan da diya to kayugajan. To diya inghagas now duon to bayoy now igkabandilyu on. ");
INSERT INTO msmNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mgo hinilabi ku, paminogi now seini. Kona kow ogkahaedok to otow no oghimatoy iyu, su iyan da ogkahimatajan dan to yawa now. Di konad sikandan ogpakaamonu iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Iyan nasi mahaedokan now to Diyus, su ko sikandin to muhimatoy iyu, meyduon isab katongod din to pagbegbog iyu diya to impernu. ");
INSERT INTO msmNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Di domdoma no ogbantajan kow to Diyus. Su inggad to maja no kona da ogkaman-u ko bolihon, wada inggad sobuuk kandan no ogkalingawan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kaling kona kow ogkahaedok su ngani sikan mgo manuk-manuk ogbantajan din, sikiyu on man to kona din bantajan! Ngani man to bubue now di tibo din nabilang. ");
INSERT INTO msmNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ligdongi now seini. Inggad hintawa no og-angkon kanay duon to atubangan to mgo otow, siak no Anak to Otow og-angkon isab kandin duon to atubangan to mgo anghil to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Di ko ilidung a to otow duon to atubangan to mgo otow, iglidung ku isab sikandin duon to atubangan to mgo anghil to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Inggad hintawa no ogpasipaya kanay no Anak to Otow ogkapasaylu da, di to otow no ogpasipaya to Ispiritu Santu kona yagboy ogkapasaylu. ");
INSERT INTO msmNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Na, ko paatubangon kow to mgo panguyu to simbahan ubin to mgo upisyalis to gubernu su mgo sakup ku sikiyu, kona kow ogkalimuut to og-ikagihon now. ");
INSERT INTO msmNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Su duon to sikan no panahon, to Ispiritu Santu iyan og-anad iyu to og-ikagihon now.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na, mey otow duon no mig-ikagi ki Jesus, “Sir, sugu-a to suun ku no bahinan a din to mgo kabilin to amoy noy.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Di si Jesus mig-ikagi kandin, “Eh, wada kay migbogoy kanay to katongod to paghusoy iyu dow to pagbahin to mgo katigajunan now. Kona no sikan to ing-andini ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Dajun ikagihi ni Jesus to mgo otow, “Bantoy kow no kona kow oghinakog, su to matuud no kinabuhi kona ogkakitaan duon to mgo katigajunan, inggad man-u to pagkadatu to otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Dajun sikandan ikagihi ni Jesus to pananglitan, “Meyduon sapian no otow no pig-abutan to mgo tanom. ");
INSERT INTO msmNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mighona-hona sikandin, ‘Og-amonuhon kud man buwa seini mgo abut ku no kona ogkaigu kani to mgo kamalig ku? ");
INSERT INTO msmNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na,’ kagi din, ‘ogwasahon ku sikan tibo aw oghinang a to mangkayow-ag agun tibo ogpakased to mgo abut ku hasta to duma no mgo katigajunan ku. ");
INSERT INTO msmNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na, tapus maani to mgo tanom ku, ogpahayahay ad su seini no abut ku kona ogkaimot inggad pila pad no tuig. Iyan da oghinangon ku to ogkoon dow og-inom aw ogkinalipay.’ ");
INSERT INTO msmNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Di to Diyus mig-ikagi kandin, ‘Sikuna no yangog, kuntoon yagboy no kadukiloman oghawion ku to kinabuhi nu. Na, yain on to ogpanag-iya to sikan ing-andam nu ikow.’ ");
INSERT INTO msmNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Angod to sikan to ogkadeygan to otow no oghimun to katigajunan dini to kalibutan di wada bayos no ogkadawat din no ogkapuun to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Dajun ikagihi ni Jesus to mgo inanad din, “Kaling paminogi now seini. Kona kow ogkalimuut to ogkoonon dow ogkaboon now no ogkinahangyanon to seini kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Su to kinabuhi ta yabow pad duon to pagkoon, aw to yawa ta yabow pad to kabo. ");
INSERT INTO msmNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Hona-honaa to mgo manuk-manuk no kona og-odok aw kona isab og-ani. Wada tambubung dan. Di to Diyus iyan ogtubung kandan. Na, sikiyu pad man to kona din atimanon no yabow pad to mgo manuk-manuk! ");
INSERT INTO msmNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hintawa man iyu to ogpakasugpat to kinabuhi din inggad majopot da pinaagi to pagkalimuut? ");
INSERT INTO msmNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Na, su kona kow man ogpakahimu to angod da to sikan no kaintok pinaagi to pagkalimuut, wada pues to pagkalimuut bahin to inggad nokoy no prublima now. ");
INSERT INTO msmNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Hona-honaa now isab to mgo buyak no puli oggiti. Kona sikan ogkaunag to pagtrabahu aw kona isab oghabey to mgo panapton. Di seini da. Inggad si Hari Solomon to diya una no yagboy sapian, wada kabo din no ogpakaangod to kadojow to sikan mgo buyak. ");
INSERT INTO msmNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Na, ko maangod to sikan to pagpabuyak to Diyus to mgo bagnot no madali da ogyanos aw ogkatutung, sikiyu pad man to kona din kaboan no yabow pad to mgo bagnot! Pagkaintok to pagsalig now to Diyus! ");
INSERT INTO msmNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kona kow isab ogkalimuut to ogkakoon dow ogkainom now, ");
INSERT INTO msmNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","su to Diyus no Amoy now diya to yangit namaan to pigkinahangyan now. Iyan da ogkalimuut to sikan to diya mgo otow no wada Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Di sikiyu, unaha pahari-a to Diyus to kinabuhi now, na, igbogoy din iyu to ogkinahangyanon now. ");
INSERT INTO msmNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kaling sikiyu no mgo binantajan ku, kona kow ogkahaedok inggad pipilahon kow da, su to Diyus no Amoy now ogkalipay to pagbogoy iyu to katongod to pagmandu duon to sikan ogharian din. ");
INSERT INTO msmNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Baligja kow to katigajunan now, aw bogaji to diya ogkangkalisod-lisod. Na, meyduon bayos now diya to yangit no kona ogkagawang, su wada kawatan dow mangotkotay diya. ");
INSERT INTO msmNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Su inggad andei ibotang to kadatu now, dini to pasak ko diya to yangit, diya isab to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Iyan podom maangodan now to mgo suguonon no andam on to paglihok. Nakapangabo on aw masiga to mgo soga dan ");
INSERT INTO msmNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","su ogtatagad to agayon dan no ogkapuun diya to kumbitihan. Pagtawag din, alistu sikandan no og-abri to pertahan aw paseda sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Madojow to diya alistu no mgo suguonon no ogkaabutan to agayon no mgo alistu, yabi ko matayod on to kadukiloman ubin kaadlawon on. Su sikan on agayon to ogsul-ub to kabo no kaning suguonon aw padungaa sikandan duon to koonanan aw honati to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Aw pananglit meyduon tag-bayoy no ogkamaan dow nokoy urasa to igtidow to kawatan, ogpak bantoy sikandin agun kona makawat to mgo katigajunan din. ");
INSERT INTO msmNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kaling mangandam kow isab su siak no Anak to Otow, ogpauli a to panahon no kona now ogkatagahan.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Dajun pangusip si Pedro, “Ginuu, hintawa man to pig-ikagihan nu to sikan no pananglitan, sikami ko tibo seini nahimun kani?” ");
INSERT INTO msmNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Migtabak to Ginuu, “To suguonon no matinumanon dow ogkasaligan iyan ogsaligan to agayon to pagdumaya to panimayoy din ko mey panow din. Sikandin to ogbahin-bahin to pagkoon to angod din no mgo suguonon. ");
INSERT INTO msmNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ko matuman to sikan suguonon to insugu kandin, ogtukhow sikandin ko makauli to agayon din, ");
INSERT INTO msmNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","su ogkabogajan to katongod to pagdumaya to tibo katigajunan. ");
INSERT INTO msmNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Di ko madoot sikan suguonon, ogpakailing sikandin, ‘Mayugoy pad buwa ogpakauli to kani agayon ku.’ Dajun din ogpanaeposon to angod din no suguonon no mgo yukos dow bohi. Iyan da hinang din to ogkoon dow ogtinghingow. ");
INSERT INTO msmNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Na, puli ogpakatokow ogtidow sikan agayon aw ogpahamtangan sikan suguonon to wadad ogpakaangod to kabog-at no kastigu. Dajun sikandin ogpaagpoton to sikan wada pamanuu to Diyus diya to banwa no wada pagkatapus to pag-antus. ");
INSERT INTO msmNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ko meyduon suguonon no namaan to sugu to agayon din di puli ogpalingog-lingog, mabog-at to kastigu no igpahamtang kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Di to suguonon no wada kamaan to sugu to agayon din aw nakasae to wada din tuuda, maagkap da to kastigu no igpahamtang kandin. To otow no nabogajan to madogi, madogi isab to ogsukuton kandin, aw to otow no pigsaligan to maaslag no katongdanan, maaslag isab to ogsukuton kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Mig-andini a su ogsangabon ku seini kalibutan. Gustu ku podom no masangab on. ");
INSERT INTO msmNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Di meyduon pad antusonon ku, aw kona a ogkahimotang kotob no kona pad matuman sikan. ");
INSERT INTO msmNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Basi ko mighona-hona kow no iyan ing-andini ku to kalibutan agun ogdojow to rilasyun to mgo otow. Kona. Iyan nasi ing-andini ku agun ogkasusuwoy sikandan, su meyduon ogtuu kanay, meyduon isab kona. ");
INSERT INTO msmNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sugud kuntoon, ogkabahin-bahin to pamilya. ");
INSERT INTO msmNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Su inggad man ngani mgo ginikanan dow mgo anak ogkasinupakay hasta isab to patae-ugangan.” ");
INSERT INTO msmNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Migpadajun si Jesus to pag-ikagi to mgo otow, “Ko ogkita kow no ogkikibey diya to sayopan, dajun kow og-iling, ‘Og-udan kay gaja.’ Na, og-udan iyan. ");
INSERT INTO msmNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kani isab to seini banwa ta, ko oghodos to kaemag likat to baebagan, og-iling kow, ‘Ogguyabung kay.’ Na, ogguyabung iyan. ");
INSERT INTO msmNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kunungkun ogkangkamaan! Ogpakasabut kow to kadodoyog to panahon, di kona kow ogpakasabut dow nokoy to ogkahitabu kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nokoy no kona kow man ogpakahona-hona dow nokoy to madojow no oghinangon? ");
INSERT INTO msmNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ko pananglitan iriklamu ka to songo otow, kona kow pad ogtidow diya to husajan, pag-uli kad kandin. Su ko kona kow mahiuli, basi paatubangon ka to huwis aw idata ka diya to pulis agun prisuhon. ");
INSERT INTO msmNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na, kona ka ogpakayuwas kotob no mabajadan nu to tibo ogpabajadan ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","To diya no panahon, mey mgo otow no mig-anduon ki Jesus. Pignangonan dan sikandin no meyduon pigpahimatajan ni Gubernadur Pilato no mgo taga-Galilea no muhalad sikandan to ogtutungon no mananap diya to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pagdinog ni Jesus to sikan, kagi din, “Mighona-hona kow buwa no iyan impanghimataji to sikan mgo otow su yabow sikandan no makasasaya kay to duma no mgo taga-Galilea? ");
INSERT INTO msmNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kona gajod! Ligdongi now seini. Ko kona kow musosey aw kona now talikudan to mgo sae now, alaot kow isab su ogkastiguhon kow to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nakadinog kow isab to diya sampuyu-tag-wayu no mgo otow no nangkamatoy su natuadan to turi diya to Siloe. Mighona-hona kow buwa no yabow pad sikandan no makasasaya kay to duma no mgo taga-Jerusalem? ");
INSERT INTO msmNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kona gajod! Paminogi now seini. Ko kona kow musosey aw kona now talikudan to mgo sae now, alaot kow isab su ogkastiguhon kow to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Dajun ikagi si Jesus to pananglitan, “Meyduon otow no migtanom to kaju no igera duon to uma din. Pagtulin on to sikan, mig-andiya sikan otow su oggunu podom to bogas, di wada nakitaan din. Pigpinaulian din to pag-aha, di wada gihapun bogas. ");
INSERT INTO msmNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hangtod no songo aedow, pig-ikagihan din sikan saup din, ‘Tatoyu on no tuig to pag-inandini ku su mig-iman a no migbogas on sikan igera, di wada gihapun. Na, gobaa su wada pues. Binuli on ogkauyakan sikan pasak no nabotangan.’ ");
INSERT INTO msmNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Di sikan saup mig-ikagi, ‘Sir, pakamonangi naa sei sed to songo tuig. Ogbongkagon ku pad to pasak duon to nakalibong to kapun-an aw dupuka dow og-abunuhan ku pad. ");
INSERT INTO msmNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Madojow ko mubogas to suja ogsunu no tuig, di ko kona, oggobaon kud on.’” ");
INSERT INTO msmNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Songo Aedow no Tigpahuway, nang-anad si Jesus duon to songo simbahan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na, mey bohi duon no nabugkung su pigsamuk to madoot no ispiritu. Sampuyu on tag-wayu no tuig to pagkabugkung din, aw konad sikandin ogpakapatul-id, inggad maintok da. ");
INSERT INTO msmNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pagkita ni Jesus kandin, pig-ikagihan din, “Manay, andini ka kanay.” Pagkadani din, mig-iling si Jesus, “Naulian kad on.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Dajun din dampaa sikan bohi, aw duon-dajun nakatindog sikandin no matul-id on, aw sajaa din to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Di hilabi naboyu to panguyu to sikan simbahan su pigdojow ni Jesus sikan bohi duon to Aedow no Tigpahuway. Kaling pig-ikagihan din to mgo otow duon, “Meyduon onom no aedow kada simana no intugut ita to pagtrabahu. Na, ko gustu now no maulian kow, andini kow to sikan no mgo aedow, kona no duon to Aedow no Tigpahuway.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Dajun sikandin ikagihi to Ginuu, “Kunungkun matinumanon to tinuuhan! Na sikiyu, wada kow yapas to Aedow no Tigpahuway? Su oghubadon now man ngani to hikot to buhi now duon to Aedow no Tigpahuway aw painoma diya to wohig. ");
INSERT INTO msmNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iyan pad man kona hubadan kuntoon no Aedow no Tigphuway seini bohi no kaliwat ni Abraham no kibali piggapus ni Satanas sed on to sampuyu-tag-wayu no tuig!” ");
INSERT INTO msmNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Pagdinog to mgo kuntra ni Jesus to sikan pig-ikagi din, hilabi sikandan nasikow. Di to kahan-inan no nahimun duon migtukhow tongod to mangkadojow no pinanghinang ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pig-ikagihan isab ni Jesus sikan mgo otow, “Nokoy man to ogkaangodan to pag-uswag to sikan ogharian to Diyus? ");
INSERT INTO msmNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ogkaangod sikan to maintok hilabi no binhi no igtanom to otow diya to uma. Paggiti to sikan, ogtulin hangtod no ogpakaangod to katikang to kaju, aw to mgo sanga ogkahapunan to mgo manuk-manuk.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Migpadajun si Jesus to pag-ikagi, “Nokoy pad man to ogkaangodan to pag-uswag to sikan ogharian to Diyus? ");
INSERT INTO msmNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ogkaangod sikan to patubu no insakot to bohi duon to madogi no arina, aw migtubu sikan tibo minasa.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Migpadajun si Jesus to pagpanow padeg diya to siyudad to Jerusalem. Duon to kayunsudan dow kabaryuhan no ogkabajaan din, ogpanghapit-hapit sikandin su ogpang-anad to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Meyduon otow no nangusip ki Jesus, “Sir, nokoy man, matagsa da to mgo otow no ogkayuwas?” Migtabak si Jesus, ");
INSERT INTO msmNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“To gingharian to Diyus ogkaangod to bayoy no malig-ot to pertahan. Paningkamot kow no wada pagyangan to pagsed agun masakup kow duon. Su og-abut to aedow no ogsirahan to Diyus sikan bayoy din. Kayugajan mahan-in to ogsed podom, di konad ogpasedon. Ko kona kow makased duon, ogpakatitindog kow diya to yuwas aw panabi, ‘Sir, sadangay abrihi koy.’ Di iyan da igtabak iyu to sikan tag-bayoy, ‘Eh, wada yabot ku iyu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dajun kow ogpakausip, ‘Kona ka ogkadomdom no migpagsayu koy man ikow to pagkoon dow to pag-inom? Pigpang-anad koy nu isab diya to banwa noy.’ ");
INSERT INTO msmNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Di sikan tag-bayoy ogtabak gihapun, ‘Wada yagboy yabot ku iyu. Hala, yaguy kow kani, sikiyu no madoot to mgo hinang.’ ");
INSERT INTO msmNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na, ko muabut sikan no panahon, ogpakadegmatoy kow aw ogpangagot to ngipon now. Su ogkitaon now to diya mgo minuna now no si Abraham, si Isaac, dow si Jacob no diyad on to gingharian to Diyus yakip to tibo mgo otow no kibali ba-ba to Diyus to diya una. Di kona kow ogpakaagpot kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Meyduon isab kona no mgo Hibru no ogkapuun diya to yain-yain no mgo banwa kani to babow to kalibutan no ogpagsayu to bangkiti duon to gingharian to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Meyduon mgo mapaobsanon no iyan nasi ogpayabawon to sikan no panahon. Meyduon isab mgo otow no yabow kuntoon no ogkaobos.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","To diya no panahon, meyduon mgo Pariseo no mig-anduon ki Jesus aw ikagi, “Yaguy ka kani su ogpahimatajan ka ni Gubernadur Herodes.” ");
INSERT INTO msmNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pig-ikagihan sikandan ni Jesus, “Andiya kow to sikan malditu no otow aw nangoni no meyduon pad oghinangon ku kani. Ogpangabug a pad to mangkadoot no ispiritu aw ogpandojawon ku pad to mgo masakiton, di kona da ogkayugoy su madani on ogkatapus seini hinang ku. ");
INSERT INTO msmNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Di kinahangyan no ogpadajun a kotob no makatidow a diya to siyudad to Jerusalem, su to otow no kibali ba-ba to Diyus diya da oghimatajan. ");
INSERT INTO msmNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Ay, sikiyu no taga-Jerusalem! Ogpanghimatajan now to kibali mgo ba-ba to Diyus. Ogbatuhon now to ogpaandinihon din iyu kotob no mangkamatoy. Kona no kapila ku da podom sikiyu oghagokonon angod to mangunsuy no oghimun to mgo unsuy din su ogyokboan, di mig-ojow kow. ");
INSERT INTO msmNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaling og-ojowan kow to Diyus. Su ognangonan ku sikiyu no ko malius ad, kona a now on og-isabon ogkitaon kotob to aedow no ogpakailing kow, ‘Sajaon ta seini pigpaandini to Ginuu no Diyus.’” ");
INSERT INTO msmNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Songo Aedow no Tigpahuway, pig-imbita si Jesus to songo inila no Pariseo to pagkoon diya to bayoy din. Pagtidow ni Jesus, sikan Pariseo dow mgo duma din naniid yagboy kandin ");
INSERT INTO msmNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","su mey otow duon no nanghopong. ");
INSERT INTO msmNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pig-usip ni Jesus sikan mgo Pariseo dow mgo maistru to tinuuhan, “Ojow pa to balaod to tinuuhan ta, ogpakasae ki buwa ko mey otow no maulian ta to sakit duon to Aedow no Tigpahuway?” ");
INSERT INTO msmNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Di nakapapahonok puli sikandan. Dajun dawata ni Jesus sikan masakiton aw naulian. Dajun din paulia. ");
INSERT INTO msmNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pig-usip on isab sikandan ni Jesus, “Ko meyduon anak ubin baka now no mauyug duon to yugi duon to Aedow no Tigpahuway, kona now dajun ogbatunon?” ");
INSERT INTO msmNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Di wada ingkatabak dan. ");
INSERT INTO msmNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","No duon pad si Jesus to sikan bangkiti, napaniidan din no namili to mgo imbitadu to madojow no mgo ingkudanan no ing-andam to mgo inila. Kaling pigsambagan din sikandan, ");
INSERT INTO msmNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ko imbitahon ka to kumbitihan, kona ka og-angkon to ingkudanan no ing-andam to mgo inila su unu ko meyduon otow no yabow pad ikow no pig-imbita. ");
INSERT INTO msmNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Su ko kitaon to tag-iya to kumbitihan no iyan pig-angkon nu to ingkudanan no ing-andam to inila, ogduguk sikandin aw ikagihi ka, ‘Yagi, seini to paingkuda kani.’ Hilabi ka ogkasikow su duon kad on ogpakaingkud to kinakilidan no ingkudanan. ");
INSERT INTO msmNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kaling ko imbitahon ka diya to kumbitihan, madojow ko iyan pilion nu to kinakilidan no ingkudanan. Su ko kitaon to tag-iya no duon ka, og-ikagihan ka din, ‘Yagi, dini ka. Kani ka ingkud to seini madojow no ingkudanan.’ Na ogkapasidonggan ka duon to atubangan to tibo no nahimun. ");
INSERT INTO msmNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Su to otow no ogpayabow nasi igpaobos, di to ogpaobos nasi ogpayabawon.” ");
INSERT INTO msmNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dajun ikagihi ni Jesus sikan mig-imbita kandin, “Ko meyduon og-imbitahon nu to pagkoon, kona no iyan og-imbitahon to mgo amigu nu, kasuunan nu dow sapian no mgo sumbayoy nu, su ogpakabayos sikandan ikow. ");
INSERT INTO msmNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Di ko ogpakoon ka, iyan imbitaha to mgo pubri, mgo pupue, mgo piang, mgo buta dow duma no mgo aju-aju. ");
INSERT INTO msmNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ko sikan to hinangon nu, igkadojow nu su inggad kona sikandan makabayos ikow, to Diyus iyan ogbayos ikow ko banhawon din on to mgo sakup din.” ");
INSERT INTO msmNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Songo otow no migpagsayu kandan no migdinog to kagi ni Jesus nakailing, “Pagkadojow to mgo otow no ogpakaagpot to bangkiti duon to gingharian to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Di pig-ikagihan sikandin ni Jesus, “Igpananglit ku to otow no mig-andam to bangkiti, aw mahan-in hilabi to inimbita din. ");
INSERT INTO msmNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Anoy man no mig-abut on to aedow to bangkiti, pigsugu din to suguonon din to pagsuna to mgo inimbita din. ");
INSERT INTO msmNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Di sikan mgo inimbita migbalibad tibo. Sikan una mig-ikagi, ‘Bag-u a pad makaboli to pasak. Kinahangyan og-andiya a su og-ahaon ku. Ipamuju a nu to pasaylu to sikan mig-imbita kanay.’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sikan ikaduwa mig-iling, ‘Bag-u a pad makaboli to sampuyu no buuk no baka, kaling ig-anti ku igdaru. Ipamuju a nu to pasaylu to sikan mig-imbita kanay.’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Meyduon isab mig-iling, ‘Kona a ogpakaagpot su bag-u a pad kaminyo.’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","No mayogob on to sikan suguonon to pagpangsuna, mig-uli sikandin diya to agayon din aw nangoni to nadeygan to pagsuna din. Hilabi naboyu sikan agayon, kaling pig-isab din pigsugu sikan suguonon din, ‘Dali ka, pamanghaa duon to tibuuk yunsud, inggad diya to kakilidan, aw daeha dini to mgo pubri, mgo pupue, mgo buta dow mgo piang.’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dajun panow sikan suguonon aw tumana to sugu to agayon din. Pagpauli din, mig-ikagi sikandin, ‘Agayon, natuman kud to sugu nu, di mahan-in pad to bakanti kani to bayoy nu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kagi to sikan agayon, ‘Panow ka diya to kadayanan dow mgo kasuyukan aw pamanghaa to duma no mgo otow. Pogosa sikandan to pag-andini agun maponu seini bayoy ku. ");
INSERT INTO msmNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Di sikan mgo otow no una no pig-imbita ku, wada inggad sobuuk no ogpakahilamit to seini bangkiti ku.’” ");
INSERT INTO msmNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Migpanow si Jesus no pigdumahan to mahan-in no mgo otow. Duon to dayan, pig-atubang din sikandan aw ikagihi, ");
INSERT INTO msmNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“To kinabuhi to otow no ogpasakup kanay kona no mahaewoy. Kinahangyan to gugma din kanay ogyabow pad duon to paghigugma din to amoy dow inoy din, asawa dow mgo anak din hasta to mgo kasuunan din, aw inggad pad to kaugalingon din no kinabuhi. Ko kona din matuman sikan, kona sikandin ogkatawag no inanad ku. ");
INSERT INTO msmNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","To otow no kona ogtiang to krus din aw unung kanay kona ogkahinang no inanad ku. ");
INSERT INTO msmNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sikan ogsunud kanay, unahon din hona-honaon to mgo kalisod no ogkabajaan din. Igpananglit ku to otow no oghinang to mayow-ag no bayoy. Kona pad ogsugud, og-unahon din og-ongod-ongodon to ogkagastu no saepi agun maaha din dow meyduon igu no saepi din to pagtapus to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Su ko ginona malibuuk to bayoy aw ogkaimot on to saepi din, ogngingisihan sikandin to mgo yumayaboy. ");
INSERT INTO msmNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Og-iling sikandan, ‘Ogpatugu oghinang to bayoy no kona ogkatapus!’ ");
INSERT INTO msmNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Angod isab to hari no ogpaggera to yain no hari. Ko pananglit sampuyu no libu to sundayu din, kinahangyan unahon din hona-honaon dow ogkagomos-gomosan dan sikan kaewaan no libu no sundayu to sikan kuntra din. ");
INSERT INTO msmNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko mahona-honaan din no kona sikandin ogpakadaog, meyduon ogsuguon din to pagpaghusoy ko madiyu pad sikan kuntra. ");
INSERT INTO msmNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Sikiyu isab,” kagi ni Jesus, “kinahangyan unahon now hona-honaon dow og-unung kow kanay, su iyan da angay no ogkatawag no inanad ku to otow no wada og-oyogon no inggad nokoy no katigajunan.” ");
INSERT INTO msmNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Impag-angod ni Jesus to mgo sakup din to asin. Kagi din, “Madojow to asin. Di ko pananglit mutab-as on sikan, og-amonuhon to pagpabalik to lami? ");
INSERT INTO msmNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Wadad pues, inggad i-abunu to pasak. Puli on igtimbag. Na, sikiyu no ogpakadinog to seini, ibotang yagboy duon to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nahimun duon ki Jesus to mgo magsukutay to buhis dow duma no mgo makasasaya su ogpaminog to pagpang-anad din. ");
INSERT INTO msmNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Di pigbagutbut si Jesus to mgo Pariseo dow mgo maistru to tinuuhan. Kagi dan, “Sikan no otawa ogpagduma to mgo makasasaya aw ogpagsayu kandan to pagkoon.” ");
INSERT INTO msmNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pagkadinog ni Jesus to sikan pig-ikagi dan, mig-iling sikandin, ");
INSERT INTO msmNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Pananglit sobuuk iyu meyduon songo gatus no karneru duon to sabsabanan aw kayagak to sobuuk, og-amonu man sikan tag-iya? Og-ojowan din sikan kasiaman-mey-siam duon to sabsabanan su ogpamanghaon din sikan sobuuk no nayagak kotob no makitaan. ");
INSERT INTO msmNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na, ko makitaan din on, hilabi sikandin ogkalipay. Ogdawaton din sikan dow tianga aw uli. ");
INSERT INTO msmNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pagtidow din diya to bayoy, ogsabihon din to mgo yagi dow sumbayoy din, ‘Dini kow, ogkinalipay kinow su nakitaan kud seini karneru ku no nayagak.’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na,” kagi ni Jesus, “ko meyduon isab makasasaya no ogsosey dow ogtalikud to mgo sae din, aw iyan on atubangon to Diyus, yabow to kalipay diya to yangit tongod kandin kay to diya kasiaman-mey-siam no nailing to boot dan no matarong on sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Meyduon pad pananglitan ku,” kagi ni Jesus. “Meyduon bohi no mighipid to sampuyu no buuk no saepi no inoyog din. Ko mayagakan sikan to sobuuk, nokoy man to oghinangon din? Ogsoga sikandin aw ogsilhigan to bayoy din dow pak pamanghaa kotob no makitaan. ");
INSERT INTO msmNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na, ko makitaan din on, ogsabihon din to mgo ajo din dow sumbayoy, ‘Dini kow. Ogkinalipay kinow su nakitaan kud seini saepi ku no nayagak.’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na,” kagi ni Jesus, “ogkinalipay isab to mgo anghil to Diyus ko meyduon makasasaya no ogsosey dow ogtalikud to mgo sae din aw atubangad to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Migpadajun si Jesus to pag-ikagi to yain no pananglitan, “Meyduon otow no daduwa to anak no yukos. ");
INSERT INTO msmNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sikan hadi mig-ikagi, ‘Itay, ibogoy on kanay kuntoon to kabilin ku to seini katigajunan nu.’ Dajun bahina to sikan amoy to katigajunan din aw ibogoy to bahin to kada sobuuk to sikan daduwa no ka anak din. ");
INSERT INTO msmNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wada kayugoy, imbaligja to sikan hadi to kabahinan din aw panow diya to madiyu no banwa aw uyak-uyaki sikan saepi din to wada pues no pagkinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Anoy man no naimot on to saepi din, nakatapu sikan to makalilisang no bontas duon to sikan no banwa, aw hilabi sikandin nalisod-lisod. ");
INSERT INTO msmNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nokoy to pighinang din, mig-andiya sikandin to songo otow no taga-duon aw nakatrabahu no magbohugay to mgo babuy diya to uma. ");
INSERT INTO msmNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tongod to hilabi no kabontas, ogkoon on podom sikandin to sikan bogas to kaju no bobohug to babuy, di wada migbogoy kandin to inggad maintok no ogkakoon. ");
INSERT INTO msmNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","To katapusan, nakahona-hona sikandin to madojow. Nailing to ginhawa din, ‘Diya to amoy ku, inggad to mgo sinuhuyan ogpanubra to pagkoon, di siakon kani, madani ad ogkamatoy to bontas. ");
INSERT INTO msmNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Iyan da madojow ko og-uli a diya to amoy ku aw ikagihi, “Itay, nakasae a yagboy to Diyus hasta ikow. ");
INSERT INTO msmNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kona ad no angay ogtawagon no anak nu. Isipa ad puli no sobuuk to sikan mgo sinuhuyan nu.”’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Dajun sikandin uli diya to amoy din. Madiyu pad sikan anak, pigkita on to amoy din aw pigkae-atan sikandin. Miglinaguy sikan amoy aw tagbuha sikan anak din dow gogoya aw panghadoki. ");
INSERT INTO msmNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Itay,’ kagi to sikan anak, ‘nakasae a yagboy to Diyus hasta ikow. Kona ad no angay ogtawagon no anak nu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Di wadad sikandin makapadajun to pag-ikagi su pigtawag to amoy din to mgo suguonon aw sugu-a, ‘Dali kow, daeha dini to pinakamadojow no kabo aw kabo-i now sikandin. Singsingi now aw sapatusi. ");
INSERT INTO msmNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tapus to sikan, puduta now to duon pinataba no nati no baka aw matansaha. Ogkoon kinow dow ogkinalipay ");
INSERT INTO msmNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","su angod to patoy on seini anak ku, di nabuhi da. Angod sikandin to nayagak, di nakitaan da.’ Duon migsugud sikandan to pagkinalipay. ");
INSERT INTO msmNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Na, sikan kakoy diya pad to uma no makatidow sikan hadi din. No pagpadodoyog din on duon to bayoy, iyan pigdinog din to sunata dow sinajawon to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pigtawag din to sobuuk no suguonon to amoy din aw usipa, ‘Nokoy man to duon?’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Migtabak sikan suguonon, ‘Nakauli on to hadi nu no wada naamonuhan. Kaling migpamatansa to amoy nu to sikan pinataba no nati.’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hilabi naboyu sikan kakoy, kaling wada sikandin sed. Dajun yuwas sikan amoy aw ajum-ajuma sikan anak din. ");
INSERT INTO msmNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Di sikan kakoy mig-ikagi, ‘Oho, sed to mahan-in on no katuigan, angod a to udipon no mig-atiman to katigajunan nu. Wada pigbalibad ku no inggad sobuuk no sugu nu. Di wada disti imbogoy nu kanay inggad sobuuk da no kanding agun makakinalipay a dow to mgo yagi ku. ");
INSERT INTO msmNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Di pagkauli to sikan anak nu no mig-uyak-uyak to mgo katigajunan nu tongod to pagpamuring din, pigpamatansahan nu sikandin to pinataba no nati.’ ");
INSERT INTO msmNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Di sikan amoy mig-iling, ‘Utu, duma ku sikuna kanunoy, aw to tibo mgo katigajunan ku, sikuna to tag-iya. ");
INSERT INTO msmNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Di angay no ogkinalipay ki kuntoon su angod to namatoy sikan hadi nu, di nabuhi da. Angod sikandin to nayagak, di nakitaan da.’” ");
INSERT INTO msmNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kagi ni Jesus to mgo inanad din, “Igpananglit ku to sapian no otow dow to sinaligan din. Meyduon nakanangon to sikan sapian no pig-uyak-uyakan to saepi din to sikan sinaligan din. ");
INSERT INTO msmNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Kaling pigtawag din sikan sinaligan aw ikagihi, ‘Nakadinog a no pig-uyak-uyakan nu to saepi ku. Na, ibogoy on kanay to mgo listahan to pagdumaya nu su oggawangan kud sikuna to katongdanan.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ginhawa to sikan sinaligan, ‘Og-amonu ad man kuntoon no ogkagawangan ad on to trabahu? Wada a kaanad to mabog-at no trabahu, aw ogkasikow a ogpalimus. ");
INSERT INTO msmNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ah, seini to oghinangon ku agun meyduon da ogdawat kanay diya to bayoy dan ko wadad on trabahu ku.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Dajun din tinagsabokaha to pagtawag to tibo namakautang to agayon din. Pig-usip din sikan una, ‘Pila man to nautang nu to agayon ku?’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Migtabak sikan otow, ‘Songo gatus no taru no yana.’ ‘Seini to risibu to utang nu,’ kagi to sikan sinaligan. ‘Ingkud ka dajun, aw kalim-an da no taru to isuyat.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Pig-usip din isab to yain no nakautang, ‘Pila man to nautang nu to agayon ku?’ Migtabak sikan otow, ‘Lima no gatus no saku no trigu.’ ‘Seini to risibu to utang nu,’ kagi to sikan sinaligan. ‘Upat da no gatus no saku to isuyat.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Pagkamaan to sikan agayon no natuntu sikandin, dajun nakailing, ‘Inggad pigtuntu ad to sikan no otawa, ogsajaon ku gihapun su ogkaamu ogpayusut. Nangandam sikandin to ogkabuhian din diya to umaabut no panahon.’ Su,” kagi ni Jesus, “to mgo otow no wada Diyus yabow pad no ogkaamu ogpadayan to kadojawan dan kay to mgo otow no sakup on to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kaling gastuha to saepi now to pagpamogas-pogas to angod now no otow kuntoon, agun ko mamatoy kow on aw konad on ogpuyus to saepi now, malipajon to pag-abi-abi iyu diya to ugpaanan no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","To otow no ogkasaligan to maintok ogkasaligan isab to madogi. Di to otow no kona ogkasaligan to maintok kona isab ogkasaligan to madogi. ");
INSERT INTO msmNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kaling ko kona kow ogkasaligan to mgo katigajunan no kalibutanon, og-amonuhon isab to pagsalig iyu to kadatu diya to yangit? ");
INSERT INTO msmNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Aw ko kona kow ogkasaligan to katigajunan to duma, hintawa man to ogbogoy to kaugalingon now no katigajunan? ");
INSERT INTO msmNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wada otow no ogpakatuman to daduwa no ka agayon,” kagi ni Jesus. “Su ogkahitabu no sobuuk to ogpayabihon din, aw ogtamajon din sikan sobuuk. Angod isab to sikan, ko iyan pinakaagayon now to saepi, to Diyus kona now ogkaagayon. Su kona now ogkadongan to pagtuman to Diyus dow saepi.” ");
INSERT INTO msmNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mey mgo Pariseo duon no naminog to kagi ni Jesus. Na, sikan no mgo otawa pakisaepi. Pagkadinog dan no nang-anad si Jesus bahin to saepi, pigngingisihan dan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Di kagi ni Jesus, “Ogpamatarong-tarong kow duon to atubangan to mgo otow, di tibo da namaanan to Diyus to nakased to hona-hona now. Sikan igkasaja to mgo otow iyu, maligsom hilabi to pag-aha to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“To diya una no wada pad si Juan, iyan ing-anad to mgo balaod no imbilin ni Moises dow to sinuyat to duma din no mgo kibali ba-ba to Diyus. Na, pagtidow on ni Juan no Magbawtismuhay, ing-anad din on sikan Madojow no Nawnangonon bahin to paghari to Diyus. Aw kuntoon, ogdodongan to mgo otow to pagdagha agun makased duon. ");
INSERT INTO msmNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Di inggad pad sikan on, kona ogkagawang to diya mgo balaod. Mahaewoy pad ogkagawang to yangit dow pasak, di wada yagboy ogkagawang duon to sikan no mgo balaod, inggad songo kudlit da.” ");
INSERT INTO msmNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Migpadajun si Jesus to pag-ikagi, “Ko meyduon otow no ogpagbiya to asawa aw pangasawa to yain, kibali nakapanghonay sikandin. To otow isab no og-asawa to bohi no inojowan to bana, kibali nakapanghonay.” ");
INSERT INTO msmNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kagi isab ni Jesus, “Meyduon sapian no otow no mahalon to mgo kabo aw hayahay to kabotang. ");
INSERT INTO msmNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Meyduon isab pubri no iyan ngadan si Lazaro no naligub to ugud. Ogdinaehon sikandin duon to yawanganan to bayoy to sikan sapian ");
INSERT INTO msmNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","su unu ko meyduon da mayuuy to pagbogoy kandin to inggad mgo timu da no ogkauyug duon to sayad to lamisa to sikan sapian. Aw to mgo ugud din ogpandilaan to mgo idu. ");
INSERT INTO msmNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Anoy man no namatoy on sikan pubri, pigdaya to umagad din to mgo anghil diya to madojow no banwa no pigbotangan ki Abraham. Namatoy isab sikan sapian aw iyobong. ");
INSERT INTO msmNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Di to umagad din diya makadeg to banwa to mgo makasasaya, aw makalilisang to pag-antus din. Pagyanghag din, pigkita din si Abraham diya to kadiyuan dow si Lazaro duon to takidingan din. ");
INSERT INTO msmNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Dajun sikandin tawag ki Abraham, ‘Adoy apu Abraham, sadangay kae-ati a! Paandiniha si Lazaro agun patagduan din to wohig seini dila ku su makalilisang to pag-antus ku kani to seini kaeju.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Di migtabak si Abraham, ‘Domdoma no to diya buhi ka pad hayahay ka, di si Lazaro kanunoy mig-antus. Kuntoon, sikunad to og-antus aw sikandin on to hayahay. ");
INSERT INTO msmNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Wada pad yabot to sikan, meyduon madayom hilabi no anggob no mig-eyt ita agun wada ogpakaandiyan iyu likat dini kanami. Wada isab ogpakaandini no ogkapuun diyan iyu.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“‘Apu,’ kagi to sikan sapian, ‘ko ugaling sikan man, sadangay paandiyaa si Lazaro to bayoy to amoy ku ");
INSERT INTO msmNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","su meyduon pad lima no mgo suun ku no yukos. Papatahani sikandan agun kona makaandini to seini makalilisang no banwa.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kagi ni Abraham, ‘To mgo sinuyat ni Moises dow to duma no kibali ba-ba to Diyus kanunoy on pigbasa diya kandan. Sikan on to paminogan dan.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Eh, apu Abraham,’ kagi to sikan sapian, ‘kona dan ogpaminogon sikan. Di ko maandiyaan to otow no ogkabanhaw, ogsosey sikandan aw ogtalikudan dan gajod to mgo sae dan.’ ");
INSERT INTO msmNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kagi ni Abraham, ‘Ko kona sikandan maminog to kagi ni Moises dow to duma no kibali ba-ba to Diyus, kona isab sikandan ogkadaya, inggad pad andiyaan to otow no ogkabanhaw.’” ");
INSERT INTO msmNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Dajun ikagihi ni Jesus to mgo inanad din, “Kani to kalibutan kona ogkagawang to mgo pagtintal, di alaot sikan ogpamanintal. ");
INSERT INTO msmNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tapat pad ko pigteybatuhan sikandan to tag-mae-gatung no galingan no batu aw ibegbog diya to dagat agun wada inggad sobuuk no obos no sakup ku no ogpakasae tongod kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaling bantoy kow. “Ko makasae to angod now no magtutuu, sapadi. Ko mamuju sikandin to pasaylu, pasayluha. ");
INSERT INTO msmNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Inggad makasae sikandin iyu to kapitu sed to songo aedow aw kapitu isab mamuju to pasaylu, pasayluha sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dajun ikagi to mgo apustulis, “Ginuu, dugangi seini pagtuu noy su maintok da.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Kagi ni Jesus, “Ko meyduon pagtuu now, inggad mae-binhi da to mustasa, ogpakasugu kow to suja kaju, ‘Kadutdut ka aw makatanom ka dutun to dagat.’ Na, ogsugut sikan iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kagi ni Jesus, “Pananglit sobuuk iyu meyduon suguonon no og-uli likat to uma no migdaru ubin migbantoy to mgo buhi, nokoy man to og-ikagihon nu kandin? Kona nu og-ikagihan to, ‘Yagi, ingkud ka aw una kad koon.’ ");
INSERT INTO msmNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nasi no ogsugu ka, ‘Ilis ka. Hikaja to panihapun ku aw atimana a no ogkoon. Papahudi kad to ikow.’ ");
INSERT INTO msmNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Su,” kagi ni Jesus, “to suguonon no ogtuman to insugu kandin kona no angajan ogpasalamatan su katongdanan din man to pagtuman to sugu. ");
INSERT INTO msmNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sikiyu isab, tapus kow makatuman to sugu to Diyus, umiling kow, ‘Kona koy no angajan ogsajaon su puli koy migtuman to katongdanan noy.’” ");
INSERT INTO msmNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Migpadajun si Jesus to pagpanow pailing diya to siyudad to Jerusalem. Duon sikandin baja to pag-eytan to mgo prubinsya to Samaria dow Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pagtidow din duon to songo baryu, meyduon sampuyu no ka otow no pigsangla no migpadodoyog duon kandin. Tongod to sakit dan, wada sikandan padani ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Puli nanabi to maagbot, “Jesus, Agayon! Sadangay kae-ati koy!” ");
INSERT INTO msmNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pagkita ni Jesus kandan, pig-ikagihan din, “Na, andiya kow dajun to mgo magdudumaya to tinuuhan ta aw pahiling-hiling kow agun makitaan dan no naulian kow on.” Na, duon pad to pangindaenan, nangkaulian on sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pag-aha to sikan sobuuk no naulian on sikandin, migpauli diya ki Jesus aw sajaa din to Diyus to maagbot. ");
INSERT INTO msmNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Migyuhud sikandin duon to atubangan ni Jesus aw pasalamat. Kona sikandin no Hibru, taga-Samaria. ");
INSERT INTO msmNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kagi ni Jesus, “Sampuyu no ka otow to nangkaulian. Na, andeid man to diya siam? ");
INSERT INTO msmNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nokoy no iyan man nasi migpauli to pagpasalamat to Diyus seini taga-Samaria?” ");
INSERT INTO msmNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Dajun ikagihi ni Jesus sikan otow no naulian, “Na, tindog. Panow kad on. To pagtuu nu iyan nakadojow ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Songo panahon, meyduon mgo Pariseo no nangusip ki Jesus dow kagan-u ogsugud to Diyus to paghari.” Migtabak si Jesus, “Wada ogkitaon to otow no ogpakiyaya no ogsugud on to Diyus to paghari. ");
INSERT INTO msmNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wada isab ogpakailing to, ‘Oho, to gingharian kani da to seini!’ ubin, ‘Sujad on to gingharian to Diyus!’ Su mighari on sikandin dini iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Pig-ikagihan ni Jesus to mgo inanad din, “Meyduon da panahon no og-awoson now no siak no Anak to Otow ogpauli agun makakita kow inggad songo aedow da to paghari ku to tibuuk kalibutan, di kona pad. ");
INSERT INTO msmNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Meyduon og-iling iyu, ‘Oho, suja da sikandin!’ ubin, ‘Seini da!’ di kona kow og-andiya. ");
INSERT INTO msmNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Su siak no Anak to Otow, ko mupauli a dini to kalibutan ogkamaanan to tibo su ogkaangod to kilat no hinggawan ogkibyat aw ogkitaon diya to inggad andei. ");
INSERT INTO msmNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Di kona pad ogkatuman sikan, kinahangyan mahan-in pad to ogkabajaan ku no mgo antusonon, aw og-ojowan a to mgo otow kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ko mupauli ad no Anak to Otow, iyan ogkaangodan to diya panahon ni Noe. ");
INSERT INTO msmNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Su iyan da nadomdoman to kaotawan to pagkoon, pag-inom dow pag-inasawahay kotob to aedow no migsed onsi Noe duon to sikan sakajan no og-ilingon to arka. Na, puli nakatokow mig-ugub, aw kangkatabug sikandan tibo. ");
INSERT INTO msmNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ko mupauli a, iyan isab ogkaangodan to diya panahon ni Lot, su iyan da nadomdoman to kaotawan to pagkoon dow pag-inom, pagpamoli dow pagpamaligja, pagpananom dow pagpanghinang to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Di oompok pad ni Lot no muyuwas sikandin to siyudad to Sodoma, pigpaudan to Diyus to kaeju dow asupri likat to yangit aw puuha to mgo otow duon. ");
INSERT INTO msmNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na, ko siak no Anak to Otow mupauli dini to kalibutan, ogkaangod to diya no mgo panahon ni Noe dow ni Lot, su ogkatokawan to mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Migpadajun si Jesus to pagpang-anad, “Ko muabut sikan no panahon, to otow no diya to yuwas to bayoy din ajaw on ogpaulia to pagpudut to mgo botang din. To otow no diya to uma ajaw on isab ogpaulia to pagpudut to inggad nokoy da. ");
INSERT INTO msmNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Domdoma now to nadeygan to diya asawa ni Lot. ");
INSERT INTO msmNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Su to otow no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay inggad igkamatoy din nasi ogbogajan to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ko muabut sikan no panahon, ogpagbugtion to tibo mgo otow su meyduon sakup ku, meyduon isab kona. Na, ko pananglitan meyduon daduwa no ka otow no oghuhulid to paglipodong, to sobuuk ogpuduton aw to sobuuk ogbilinon. ");
INSERT INTO msmNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Angod isab ko meyduon daduwa no ka bohi no ogbubulig to paggaling, to sobuuk ogpuduton aw to sobuuk ogbilinon. ");
INSERT INTO msmNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","To mgo inanad nangusip ki Jesus, “Agayon, andei man ogkahitabu sikan pighisgutan nu?” Pigtabak sikandan ni Jesus pinaagi to pananglitan, “Inggad andei no meyduon patoy, diya isab ogkatap-ung to mgo uwak.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pig-ikagihan ni Jesus to mgo inanad din to pananglitan su og-anadon din sikandan no kinahangyan to kanunoy no pag-ampu inggad kona dajun madawat to ogpamujuon. ");
INSERT INTO msmNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kagi ni Jesus, “Duon to songo yunsud meyduon huwis no wada pagkahaedok to Diyus dow wada pagkae-at to angod din no otow. ");
INSERT INTO msmNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Meyduon bohi no bayu duon to sikan no banwa no migbalik-balik duon to sikan huwis su oghangyu no tabangan sikandin su pigdaog-daog to songo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Di migmaojow sikan huwis to pagtabang kandin. Anoy man no nayugoy on to pagbalik-balik to sikan bayu, ginhawa to sikan huwis, ‘Inggad wada pagkahaedok ku to Diyus aw wada pagkae-at ku to angod ku no mgo otow, ");
INSERT INTO msmNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","igtugut ku to hangyu to sikan bayu su pigtakahan ad to pagbalik-balik din to pagpatabang kanay.’” ");
INSERT INTO msmNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","To Ginuu migpadajun to pag-ikagi, “Hona-honaa now to pighinang to sikan kona no matarong no huwis. ");
INSERT INTO msmNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Su ko pigtabangan din sikan bayu, Diyus pad man to kona mutabang iyu no mgo inabin din no ogpatabang kandin aedow dow madukilom. Mighona-hona kow buwa no ogyangan to Diyus to pagtabang iyu? ");
INSERT INTO msmNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kona gajod. Ogbogajan kow din dajun to hustisya. Di diya to mahudi no mgo aedow, ko siak no Anak to Otow mupauli dini to pasak, indoy dow meyduon mgo otow no angod to sikan to pagtuu no kona ogtakahan to pag-ampu.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pigpananglitanan isab ni Jesus to diya mgo otow no migtamay to duma su migsalig no ogkadawat sikandan to Diyus tongod to katarong dan. ");
INSERT INTO msmNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Kagi din, “Meyduon daduwa no ka otow no mig-andiya to Bayoy to Diyus su og-ampu. To sobuuk Pariseo aw sikan sobuuk matuntuhon no magsukutay to buhis. ");
INSERT INTO msmNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sikan Pariseo migtindog agun makitaan to mgo otow aw ampu to kaugalingon din, ‘Ogpasalamat a ikow, Diyus ku, su kona a no angod to duma no mgo otow. Kona a no hakog, kona a no malimbungon, kona a ogpanghonay, kona a isab no angod to kadoot to suja magsukutay to buhis. ");
INSERT INTO msmNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ogtuman a to tibo tumanon noy no mgo Hibru, ogpuasa a to tag-daduwa no aedow to kada simana aw ogbogoy a isab to ikasampuyu no bahin to tibo pinangitaan ku.’ ");
INSERT INTO msmNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Di sikan magsukutay to buhis migpakilid da no wada ngani yanghag diya to yangit su ogkailing to ginhawa din no kona yagboy sikandin no angay. Iyan da kandin to ogdabu to dagaeha din aw ampu no mig-iling, ‘Diyus ku, mayuuy ka kanay no makasasaya!’” ");
INSERT INTO msmNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mig-ikagi si Jesus, “Indani seini. Sikan magsukutay to buhis mig-uli no iyan pigdawat to Diyus, di sikan Pariseo, wada. Su to otow no ogpayabow nasi igpaobos, di to ogpaobos nasi ogpayabawon.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Songo aedow meyduon mgo otow no namandaya to mgo bata duon ki Jesus agun sampoyongan din aw ampuan. Pagkita to mgo inanad ni Jesus, pigsapadan dan, ");
INSERT INTO msmNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","di pigsabi ni Jesus sikan mgo bata aw ikagihi to mgo inanad din, “Tuguti sikan mgo bata to pag-andini kanay. Kona now ogpogongan su iyan ogkaharian to Diyus to mgo otow no angod kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Su inggad hintawa no kona ogdawat to paghari to Diyus angod to dinawatan to bata kona yagboy ogkasakup duon.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Songo aedow pig-ikagihan si Jesus to maistru to tinuuhan, “Sir, madojow ka no otow. Nokoy man to madojow no oghinangon ku agun maangkon ku to kinabuhi no wada katapusan?” ");
INSERT INTO msmNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kagi ni Jesus, “Hona-honaa to igpasabut to sikan og-ilingon nu no madojow a. Su namaanan ta no Diyus da on to madojow. ");
INSERT INTO msmNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Namaanan nud isab to mgo balaod din no pig-iling, ‘Kona ka ogpanghonay, kona ka oghimatoy to otow, kona ka ogpangawat, kona ka ogpangistigus to gayu, aw tahuda to amoy dow inoy nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kagi to sikan otow, “Pigtuman kud sikan tibo sugud pad to pagkabata ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Di mig-ikagi si Jesus, “Sobuuk pad to kuyang nu. Ibaligja to tibo katigajunan nu, aw to halin ipamogoy to mgo pubri. Na meyduon ogkapaabut nu no bayos diya to yangit. Dajun ka pauli dini aw duma kad kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pagdinog to sikan otow to kagi ni Jesus, migsakit to ginhawa din su hilabi sikandin sapian. ");
INSERT INTO msmNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Pagkita ni Jesus no naguul sikan otow, mig-ikagi sikandin, “Pagkalisod to sapian no otow to pagpasakup to sikan ogharian to Diyus! ");
INSERT INTO msmNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ko malisod on man to kamel to pagyawang to yugi to dagum, iyan on man to sapian no otow ko kona malisodan to pagpasakup to sikan ogharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dajun ikagi sikan mgo otow, “Hintawa da man naan to ogkayuwas?” ");
INSERT INTO msmNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Migtabak si Jesus, “Sikan kona ogkahimuan to otow, ogkahimuan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Mig-ikagi si Pedro, “Na sikami naan, pig-ojowan noy on to tibo su ogduma koy on ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Kagi ni Jesus, “Ligdongi now seini. Inggad hintawa no og-ojow to bayoy din, asawa, mgo suun, mgo ginikanan ubin mgo anak din agun igkanawnangon din to paghari to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","yabow to igbayos kandin. Kani to babow to kalibutan ogkadawat din to yabi pad duon to sikan pinang-ojowan din, aw diya to umaabut no panahon, ogbogajan sikandin to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pigpapadani ni Jesus to mgo inanad din aw ikagihi, “Oho, ogpailing kinow on diya to Jerusalem. Ko diya kid on, ogkatuman to diya sinuyat to kibali mgo ba-ba to Diyus bahin kanay no Anak to Otow. ");
INSERT INTO msmNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Igdata a diya to mgo otow no kona no Hibru no wada tahud to Diyus. Oghinangon a dan no kangisihanan dow pakasikawi aw ilobi. ");
INSERT INTO msmNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ogpanyapdosan a dan aw himataji, di ogkabanhaw a da duon to ikatoyu no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Di to mgo inanad ni Jesus wada makasabut to sikan pig-ikagi din, su to kahuyugan inghobong kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Anoy man no madani on si Jesus to yunsud to Jerico, meyduon buta no mig-iingkud duon to kilid to dayan su ogpalimus to ogpamanyaboy. ");
INSERT INTO msmNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pagkadinog din to sasamuk to mahan-in no mgo otow no migyaboy, mig-usip sikandin, “Nokoy man to kani?” ");
INSERT INTO msmNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kagi to sikan mgo otow, “Si Jesus no taga-Nazaret ogbaja kani.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Dajun tawag sikan buta to maagbot, “Jesus no Kaliwat ni Hari David, sadangay kae-ati a!” ");
INSERT INTO msmNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Di pigsapadan sikandin to mgo otow no diya to unahan ni Jesus agun ogpahonok. Di nasi din pigpak agbotan to pagtawag, “Jesus no Kaliwat ni Hari David, sadangay kae-ati a!” ");
INSERT INTO msmNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Dajun sigkon si Jesus to pagpanow aw sugu, “Daeha sikandin dini kanay.” No makadani on sikan buta, mig-usip si Jesus, ");
INSERT INTO msmNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nokoy man to igpahinang nu kanay?” Migtabak sikan otow, “Sir, ogkaliyag a podom no ogkita ad on.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Dajun ikagihi sikandin ni Jesus, “Ogkita kad. To pagsalig nu kanay iyan nakadojow ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Duon-dajun migkita sikan otow. Dajun sikandin duma ki Jesus aw sajaa din to Diyus. Migsaja isab to tibo mgo otow no migkita to sikan nadojow on no buta. ");
INSERT INTO msmNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tapus to sikan, migsed si Jesus duon to yunsud to Jerico su duon man makabaja to dayan no og-unugon din. ");
INSERT INTO msmNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na, mey otow duon no iyan ngadan si Saqueo no panguyu to mgo magsukutay to buhis duon to sikan no yunsud. Hilabi sikandin sapian. ");
INSERT INTO msmNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pagyaboy ni Jesus no piglilibongan to mahan-in hilabi no mgo otow, og-aha podom si Saqueo kandin, di nayoponan to mgo otow su masagkop sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kaling miglinaguy diya to unahan aw pamonhik to kaju no sikumuru agun kitaon din si Jesus ko muyaboy duon. ");
INSERT INTO msmNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na, pagtidow ni Jesus duon to sikan kaju no pigponhikan ni Saqueo, migyanghag sikandin aw ikagi, “Saqueo, dali-dali ka pagyudus, su kinahangyan no diya a ogpaabut to bayoy nu kuntoon.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Duon-dajun migyudus si Saqueo aw dumaha si Jesus diya to bayoy din. Malipajon sikandin no mig-abi-abi ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pagkita to mgo otow to sikan, migbagutbut sikandan, “Abee! Nokoy no ogpaabut man si Jesus duon to sikan makasasaya?” ");
INSERT INTO msmNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Duon to sed to bayoy, migtindog si Saqueo aw ikagi ki Jesus, “Oho Ginuu, igbogoy kud to katonga to katigajunan ku diya to mgo pubri. Aw ko meyduon natuntu ku, og-ulian ku to upat no ka yupi.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kagi ni Jesus kandin, “Kuntoon napasaylu ka dow to panimayoy nu su ogkasabutan no tinood yagboy to pagtuu now to Diyus angod to pagtuu ni Abraham no minuna ta. ");
INSERT INTO msmNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Su siak no Anak to Otow, iyan ing-andini ku to babow to kalibutan to pagpamangha dow pagyuwas to mgo makasasaya.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nailing to boot to sikan mgo otow no naminog ki Jesus no ogsugud on sikandin to paghari ko makatidow sikandin diya to Jerusalem no kona da no madiyu to yunsud dan no Jerico. ");
INSERT INTO msmNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kaling pig-ikagihan sikandan ni Jesus to pananglitan, “Meyduon inila no otow no mig-andiya to yabow no hari diya to madiyu no banwa agun mahinang sikandin no hari duon to sikan banwa din. ");
INSERT INTO msmNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Di wada pad sikandin makalikat, pigtawag din to sampuyu no mgo suguonon din aw saligi to saepi din. Pig-ikagihan din sikandan, ‘Sikiyu on to ogpaigu to pagpatubu to seini kotob no makauli a.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Dajun panow sikan otow. Di to mgo sakup din migkuntra kandin. Kaling impayupug dan agun nangonan sikan yabow no hari no kona sikandan ogkaliyag no ogharian din. ");
INSERT INTO msmNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Di wada paminog sikan yabow no hari. Nasi din on pigbogajan sikan otow to katongdanan to pagkahari. Pag-uli din, impatawag din sikan mgo suguonon no pigsaligan din to saepi agun matagahan din dow man-u to pigtubuan. ");
INSERT INTO msmNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Migduguk sikan una no suguonon aw ikagi, ‘Agayon, to diya saepi no insalig nu kanay migtubu to sampuyu no ka yupi.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kagi to sikan hari, ‘Madojow sikan pighinang nu! Mabakas ka no suguonon. Kuntoon su ogkasaligan ka to inggad maintok da, ogpamanduon ku sikuna to sampuyu no ka siyudad.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Sikan ikaduwa no suguonon migduguk aw ikagi, ‘Agayon, migtubu to diya saepi nu to lima no ka yupi.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mig-ikagi sikan hari, ‘Ogpamanduon ku sikuna to lima no ka siyudad.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mig-anduon sikan ikatoyu no suguonon aw ikagi, ‘Agayon, seini da to diya saepi no insalig nu kanay. Pigputus ku to panapton aw hipidi. ");
INSERT INTO msmNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nahaedok a ikow su mayupigon ka. Ogpamudut ka ngani to kona no ikow, aw og-ani ka to wada nu kaunagi to pag-odok.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kagi to sikan agayon, ‘Wada pues nu no suguonon! Sikan kagi nu ogsibog da duon ikow. Mighona-hona ka man naan no mayupigon a dow ogpamudut to kona no kanay aw ogpang-ani a to wada ku kaunagi. ");
INSERT INTO msmNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na, ko sikan to pighona-hona nu, nokoy no wada nu man ibangku sikan saepi ku agun ogtubu aw madogi to ogkadawat ku ko muuli a?’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Dajun ikagihi to sikan hari to mgo otow no namanindog duon, ‘Puduta sikan saepi duon kandin aw ibogoy to sikan nakapatubu to saepi din to kasampuyu yupi-a.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Eh agayon,’ kagi dan, ‘madogi on to saepi din.’ ");
INSERT INTO msmNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kagi to sikan hari, ‘Hoo iyan, su to ogkasaligan ogdugangan, di to kona ogkasaligan, oghawion da inggad to maintok no insalig kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Na, daeha dini sikan mgo otow no kona ogkaliyag no harian ku sikandan. Himataji kani to atubangan ku.’” ");
INSERT INTO msmNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tapus ikagiha ni Jesus sikan, migpadajun sikandin diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","No duon on sikandin to dani to mgo baryu to Betpahe dow Betania no duon to bugdangan to Kaulibuhan no bubungan, pigsugu ni Jesus to daduwa no mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Andutun kow to suja baryu. Pagtidow now duon, ogkita kow to inhikot no nati no asnu no wada pad disti kasakaji. Hubada aw tujuka dini kanay. ");
INSERT INTO msmNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko meyduon musagman iyu, ilingi now no ogkinahangyanon seini to Ginuu.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Dajun panow sikan daduwa, aw pigkita dan sikan ognangonon ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Anoy man no hubadon dan to diya nati, migsagman sikan mgo tag-iya, “Nokoy no oghubadon now man sikan nati?” ");
INSERT INTO msmNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Migtabak to mgo inanad, “Ogkinahangyanon seini to Ginuu.” Dajun sikandan pigtugutan to mgo tag-iya. ");
INSERT INTO msmNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pagtujuk dan to sikan nati diya ki Jesus, inhanig dan to pig-apid dan no mgo kabo duon to talikudan to sikan nati aw pasakaja dan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pagpanow on to sikan nati no pigsakajan ni Jesus, ko andei sikandin malisig, diya isab ogkalisig to mgo otow no ogbukyad to ing-apid dan no kabo su ighanig to ogbajaan din. ");
INSERT INTO msmNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","No madani on sikandan to Jerusalem, duon to sikan igpatogbang duon to Kaulibuhan no bubungan, migsugud sikan panon to mgo inanad din to pagsaja to Diyus. Malipajon sikandan no migkinuliya tongod to diya pigkita dan no mgo milagru no pighinang ni Jesus. Mig-iling sikandan, ");
INSERT INTO msmNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Sajaon ta seini hari no pigpaandini ita to Ginuu no Diyus. Sajaon tanow to Diyus diya to yangit su kuntoon pigtidow kid to kalinow din.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Di to mgo Pariseo no nakasakot duon mig-ikagi ki Jesus, “Sapadi sikan mgo sakup nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kagi ni Jesus, “Inggad sapadan ku sikandan, seini mgo batu iyan ogkinuliya to pagsaja kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","No madani on si Jesus to Jerusalem, migtiyahu sikandin no kitaon din sikan siyudad su nayuuy yagboy sikandin to mgo taga-duon. ");
INSERT INTO msmNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Mig-iling si Jesus, “Ay, ko namaan kow pa podom to madojow no oghinangon agun makaangkon kow to kalinow! Di hangtod kuntoon to mgo kaisipan now angod to pigyoponan agun kona kow makasabut. ");
INSERT INTO msmNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Su meyduon aedow no og-abuton kow to kasamuk. Kona kow on ogpakayuwas to sikan siyudad su ogbanganan kow to mgo kuntra now aw oglibongan kow. ");
INSERT INTO msmNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Oggobaon dan sikan siyudad now aw panghimataji kow. Ogwaka-wakahon to mgo batu no inghinang to mgo bayoy hangtod no wada ogkabilin, su wada now kiyayaha no kuntoon to panahon no mig-andini to Diyus to pagyuwas podom iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pagtidow ni Jesus diya to Jerusalem, migpadajun sikandin diya to Bayoy to Diyus. Pagkita din to mgo otow no namaligja duon, pig-abug din aw ikagihi, ");
INSERT INTO msmNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","“Meyduon impasuyat to Diyus no pig-iling, ‘Seini Bayoy to Diyus og-ilingon to ampuanan,’ di pighinang now no kampu to mgo tulisan!” ");
INSERT INTO msmNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kada aedow nang-anad si Jesus duon to Bayoy to Diyus. Di to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan hasta to inila no mgo duma dan mighona-hona dow og-amonuhon dan agun mahimatajan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Di wada dan dajun katuman sikan su to tibo mgo kagi ni Jesus pigpaminogan yagboy to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Songo aedow no mang-anad si Jesus duon to Bayoy to Diyus aw ipasabut din to Madojow no Nawnangonon, pigduguk sikandin to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow mgo maistru to tinuuhan hasta to inila no mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Pig-usip dan si Jesus, “Nokoy man to katongod nu to pagpanghinang to diya? Hintawa man to migbogoy ikow to sikan no katongod?” ");
INSERT INTO msmNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Migtabak si Jesus, “Meyduon isab ig-usip ku iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","To diya pagpamawtismu ni Juan, hintawa man to migbogoy kandin to sikan no katongod? Diyus ko otow? ");
INSERT INTO msmNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dajun sasabut sikandan dow og-amonuhon dan to pagtabak. Kagi dan, “Ko muiling ki no Diyus to migbogoy ki Juan to katongod, ogsukatan ki dow nokoy no wada ki tuu ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aw ko muiling ki no pig-otawan to katongod din, ogbatuhon ki to tibo mgo otow hangtod no mangkamatoy ki, su migtuu sikandan no si Juan, kibali ba-ba to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kaling iyan da intabak dan ki Jesus to, “Indoy, wada koy kamaan.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","“Na,” kagi ni Jesus, “kona ku isab sikiyu ognangonan dow nokoy to katongod ku to pagpanghinang to diya.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dajun nangoni ni Jesus to mgo otow to pananglitan, “Meyduon otow no migtanom to ubas duon to uma din. Dajun din pasaupi aw panow diya to madiyu no banwa aw nayugoy sikandin diya. ");
INSERT INTO msmNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Anoy man no oggunuon on to mgo ubas, migsugu sikan tag-iya to suguonon din to pagpudut to kabahinan din. Di pagtidow to sikan sinugu, pigbukbuk sikandin to sikan mgo saup aw pabalika no ampan daya. ");
INSERT INTO msmNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dajun isab sugu-a to sikan tag-iya to yain no suguonon, di pigbukbuk gihapun sikandin aw pakasikawi aw pabalika no ampan daya. ");
INSERT INTO msmNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pigsugu to sikan agayon to ikatoyu no suguonon din. Di pigpalian sikandin aw itimbag diya to yuwas. ");
INSERT INTO msmNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na, ginhawa to sikan tag-iya, ‘Og-amonu ad man buwa? Ogsuguon ku seini pinadajag no anak ku. Ogtahudon dan buwa sikandin.’ ");
INSERT INTO msmNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Di pagkita kandin to sikan mgo saup, mig-iling sikandan, ‘Suja anak to ogpakairinsya to seini ubasan ko mamatoy to amoy din. Na, oghimatajan ta isab agun ita on seini.’ ");
INSERT INTO msmNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kaling pagtidow to sikan anak to tag-iya, piggujud dan diya to yuwas to ubasan aw himataji.” Dajun pangusip si Jesus, “Na, to paghona-hona now, og-amonu man sikan tag-iya? ");
INSERT INTO msmNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Og-andiyaon din sikan mgo saup aw panghimataji. Pagkatapus, ogpasaupan din sikan ubasan to mgo otow no ogkasaligan.” Pagkadinog to mgo otow to sikan pananglitan ni Jesus, mig-ikagi sikandan, “Hamug nu!” ");
INSERT INTO msmNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Di pig-aha ni Jesus sikan mgo otow aw ikagihi, “Wada kow buwa makasabut to sikan pig-iling duon to Kasuyatan to Diyus, ‘Sikan batu no pig-ojowan to mgo pandoy su nailing to boot dan no wada pues iyan nasi indigon to bayoy.’ ");
INSERT INTO msmNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inggad hintawa no ogkauyug duon to sikan no batu ogkadupuk. Di to otow no ogkauyugan to sikan, ogkadupuk-dupuk.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pagdinog to mgo maistru to tinuuhan dow to yabow no mgo magdudumaya to tinuuhan to sikan pananglitan ni Jesus, nasabutan dan no sikandan to pig-igu. Kaling dajun dan podom ogdakopon si Jesus, di nahaedok sikandan to mgo otow duon no naminog kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Sugud to sikan no panahon, pigpak bantajan dan si Jesus. Migsuhue sikandan to mgo otow no ogpatitinood agun mabitik dan si Jesus aw ikadata diya to gubernadur no taga-Roma, su sikandin to meyduon katongod to paghukum. ");
INSERT INTO msmNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pig-ikagihan dan si Jesus, “Sir, namaan koy no hustu to mgo kagi dow pagpang-anad nu. Inggad hintawa to igpag-atubang nu, pinag-angod nu to pagpang-anad kandan bahin to pagtuman to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na, meyduon ig-usip noy ikow. Kona buwa no supak to tinuuhan ta to pagbajad to buhis diya to hari to Roma?” ");
INSERT INTO msmNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Di namaanan ni Jesus no ogpaligason dan sikandin, kaling mig-ikagi, ");
INSERT INTO msmNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Aha ki kun to saepi no babajaday to buhis. Na, hintawa man bayhu dow ngadan to nakabotang kani?” ");
INSERT INTO msmNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Migtabak sikandan, “Kaning hari to Roma.” Kagi ni Jesus, “Na, ibogoy diya to hari to kaning hari, aw ibogoy isab diya to Diyus to kaning Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Di sikan ogbitik podom ki Jesus wada nahimu duon to atubangan to kaotawan, kaling nakapapahonok sikandan su naboyong to pagkatabak din. ");
INSERT INTO msmNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Meyduon isab mgo Saduseo no mig-anduon ki Jesus su ogpangusip. Na, sikan no mgo otawa naman-iling no kona ogkabanhaw to mgo patoy. ");
INSERT INTO msmNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Kagi dan, “Sir, mig-iling to balaod no imbilin ni Moises no ko mamatoy to otow no ogkabilin to asawa no wada pad anak, kinahangyan asawahon to suun din sikan bohi agun meyduon ogkailing no liwat to diya namatoy. ");
INSERT INTO msmNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Na, igpananglit ta to pitu no migsusuun no yukos. Naminyo sikan panganoy, di wada pad anak dan, namatoy on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kaling pig-asawa to hadi din sikan bohi, di angod isab to nahitabu kandin ");
INSERT INTO msmNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","hasta sikan ikatoyu. Na, yaktod no pagkaikagi, sikan pitu no migsusuun tibo nakaasawa to sikan bohi aw tibo sikandan namatoy no wada anak. ");
INSERT INTO msmNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","To katapusan, namatoy isab sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Na, ojow nu pa, ogbanhawon to mgo patoy. Ko matuman on sikan, hintawa man yagboy to sikan pitu to ogkatawag no tag-asawa to sikan bohi, su tibo man sikandan nakaasawa kandin?” ");
INSERT INTO msmNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Migtabak si Jesus, “Dini to babow to kalibutan, batasan to bohi dow yukos to pag-inasawahay. ");
INSERT INTO msmNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Di to mgo otow no og-isipon to Diyus no angajan ogbanhawon aw angajan ogpaugpaon duma kandin konad on og-inasawahay ");
INSERT INTO msmNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","su konad on ogkamatoy. Ogkaangod on sikandan to mgo anghil. Duon isab to sikan no panahon, og-ilingon sikandan no mgo anak to Diyus su pigbanhaw din man. ");
INSERT INTO msmNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Inggad ngani si Moises migmatuud no ogbanhawon to mgo patoy. Su duon to sinuyat din bahin to diya masagkop no kaju, mighisgut sikandin bahin to Ginuu no Diyus no iyan ogsimbahon ni Abraham, ni Isaac dow ni Jacob. ");
INSERT INTO msmNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Migpasabut no inggad nayugoy da kamatoy sikan no mgo otow, buhi sikandan diya to yangit aw ogpadajun to pagsimba to Diyus. Su to mgo patoy konad ogsimba to Diyus, mgo buhi da. Su pig-isip to Diyus no buhi to tibo mgo otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na, meyduon mgo maistru to tinuuhan no mig-ikagi ki Jesus, “Sir, madojow to pagkatabak nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tapus to sikan, wadad migyangub to pagpangusip ki Jesus to inggad nokoy da. ");
INSERT INTO msmNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tapus to sikan, pig-ikagihan ni Jesus to kaotawan, “Og-usip a iyu bahin to diya Insaad no Manyuyuwas. Nokoy no og-iling man to mgo otow no kaliwat puli sikandin ni Hari David ");
INSERT INTO msmNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","no si David iyan man yagboy migsuyat duon to libru to mgo Salmo no pig-iling, ‘To Ginuu no Agayon ku pig-ikagihan to Diyus, Ingkud ka kani to kalintuu no takidingan ku ");
INSERT INTO msmNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kotob no daogon ku yagboy to mgo kuntra nu aw makayuhud duon to atubangan nu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kagi ni Jesus, “Manno Agayon to intawag ni David to sikan Insaad no Manyuyuwas, nokoy no ogkailing man no kaliwat puli sikandin ni David?” ");
INSERT INTO msmNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","No naminog pad to mgo otow to mgo kagi ni Jesus, pig-ikagihan din to mgo inanad din, ");
INSERT INTO msmNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Bantoy kow to mgo maistru to tinuuhan ta. Ogganahan sikandan ogpangabo to mahaba dow ogpakita-kita, aw ogtukhow ko pakitaon to pagtahud duon to karsada. Ko duon sikandan to mgo simbahan aw ko diya isab to mgo bangkiti, ogkaliyag sikandan og-ingkud duon to ingkudanan no ighinaat to mgo inila. ");
INSERT INTO msmNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ogpangyupig sikandan to bayu no mgo bohi agun maagow to katigajunan dan. Sikan madoot no hinang dan ogtakyuban dan to mahaba no mgo pag-ampu. Kaling kahaedokanan yagboy to kastigu no igpahamtang kandan.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","No duon pad si Jesus to Bayoy to Diyus, pigsayapan din to mgo sapian no og-uyug to saepi duon to taguanan to mgo halad. ");
INSERT INTO msmNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Monok on, mey isab pigkita din no pubri hilabi no bayu no bohi no iyan da ingkauyug to daduwa no mangkaintok no saepi. ");
INSERT INTO msmNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kagi ni Jesus, “Oho, to tibo mighalad, iyan yabow to halad suja pubri no bohi. ");
INSERT INTO msmNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Su tibo sikandan migbogoy to subra dan, di suja bohi no miglisod, imbogoy din to tibo ogkabuhian din.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pagkahina-hina meyduon mgo inanad ni Jesus no namanhisgut bahin to sikan madojow no mgo batu no inghinang to sikan Bayoy to Diyus dow sikan mangkadojow no namakabotang duon no imbogoy diya to Diyus. Di mig-ikagi si Jesus, ");
INSERT INTO msmNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Meyduon panahon no ogkagoba seini Bayoy to Diyus no ogkitaon now. Wada inggad sobuuk to sikan no mgo batu no inghinang to seini no ogkabilin duon to nabotangan, su ogtompagon tibo.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Dajun usip ki Jesus to mgo inanad din, “Sir, kagan-u man ogkatuman sikan ognangonon nu? Nokoy man to ogkakiyayahan noy no madani on ogkahitabu sikan?” ");
INSERT INTO msmNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Migtabak si Jesus, “Bantoy kow no kona kow malimbungan, su mahan-in to gayuon no ogyogwa no ogdae to ngadan ku. Og-angkon no sikandan kun to diya Insaad no Manyuyuwas aw og-iling isab, ‘Madani on to katapusan.’ Di kona kow ogpasakup kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ko makadinog kow to gera dow mgo kagubut diya to yain-yain no mgo banwa, kona kow ogkahaedok. Kinahangyan no matuman sikan, di kona pad no iyan to katapusan to kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Migpadajun si Jesus to pag-ikagi, “Ogpagigirahay to mgo nasyun dow mgo gingharian. ");
INSERT INTO msmNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mahan-in to mgo banwa no ogtiyogon to maagbot aw og-abuton to makalilisang no bontas dow sakit. Ogkahaedok isab to mgo otow su ogpakakita to mgo kabeynganan diya to yangit no ogpakiyaya no madani on to katapusan. ");
INSERT INTO msmNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Di kona pad ogkatuman sikan, ogdakopon kow aw daeha diya to mgo simbahan su oghukuman. Ogpaantuson, ogprisuhon, aw ogpaatubangon kow to mgo hari dow mgo gubernadur tongod to pagtuu now kanay. ");
INSERT INTO msmNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ko mahitabu sikan, ogpakalugar kow to pagnawnangon kandan bahin kanay. ");
INSERT INTO msmNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Di patahani to ginhawa now no kona kow ogkalimuut to igtabak now. ");
INSERT INTO msmNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Su siak to ogbogoy iyu to kaalam dow angay no mgo ikagihonon no igkatabak now no wada yagboy kuntra no ogpakayalis. ");
INSERT INTO msmNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ogyuib iyu inggad to mgo ginikanan now, mgo kasuunan dow mgo amigu now no kona ogtuu kanay, aw to duma iyu ogpanghimatajan. ");
INSERT INTO msmNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ogkuntrahon kow to tibo tongod to pagtuu now kanay, ");
INSERT INTO msmNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","di inggad songo yogas no bubue duon to uyu now wada ogkagawang. ");
INSERT INTO msmNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kaling hogota now to pagtuu kanay agun mabogajan kow to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Migpadajun si Jesus to pag-ikagi, “Ko libutan on seini siyudad to Jerusalem to mgo sundayu, ogkasabutan now no ogkagoba on seini. ");
INSERT INTO msmNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na, ko makitaan now sikan, sikiyu no mig-ugpa kani to Judea pakajabag kow pailing diya to kabubunganan aw hobong. To mgo otow kani to Jerusalem mupakajabag isab, aw to mgo otow diya to uma ajaw on ogpauli-a dini to siyudad. ");
INSERT INTO msmNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Su sikan to panahon no ogkatuman on to tibo kastigu no nasuyat duon to Kasuyatan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kae-at to mgo magkabodos dow mgo manggianak to sikan no aedow. Hilabi ogkalisod-lisod to mgo taga-kani su og-abuton on sikandan to yangot to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Meyduon ogkangkamatoy diya to gerahan, aw to duma ogbihagon aw daeha diya to inggad andei no mgo banwa. Pagkatapus, seini siyudad to Jerusalem oggiok-giokan to mgo otow no wada Diyus kotob to panahon no igtugut kandan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Diya to mahudi no mgo aedow meyduon mgo kabeynganan no ogkitaon duon to soga dow to buyan hasta mgo bituon. Kani isab to pasak, ogdaitan to kaotawan aw ogkatarantar ko makadinog sikandan to dadaguuk to dagat hasta to mgo bayod no tag-magabubungan no ogkangkayukut. ");
INSERT INTO msmNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ogpangyotoy dow ogkalipong to mgo otow tongod to haedok dan no ogpanagad to ogkangkahitabu to pasak, su ogkangkahojong to tibo diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na, dajun a ogkonsad no Anak to Otow no ogkaputus to panganud, aw ogkitaon dan to kasilow to pagka-Diyus ku. ");
INSERT INTO msmNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kaling,” kagi ni Jesus, “ko musugud on to pagkatuman sikan ognangonon ku, tindog aw yanghag kow diya to yangit aw lipay kow su konad ogkayugoy, ogyuwason kow on to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Dajun ikagihi ni Jesus to mgo inanad din to pananglitan, “Domdoma now to mgo kakajuhan, yabi to kaju no igera. ");
INSERT INTO msmNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Su ko makitaan ta no ogpanalingsing on, ogkamaanan ta no madani on ogguyabung. ");
INSERT INTO msmNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Angod isab to sikan, ko makitaan now no ogkatuman on sikan ognangonon ku, ogkamaanan now no madani on ogkatuman to paghari to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ligdongi now seini. Kona pad ogkangkamatoy to tibo mgo otow kuntoon, ogkatuman on sikan tibo. ");
INSERT INTO msmNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","To yangit dow pasak ogkagawang da, di to kagi ku ogpabilin yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mig-ikagi isab si Jesus, “Bantoy kow no kona kow ogkawili to pagpatujang dow paghobog-hobog dow pagkalimuut bahin to mgo prublima to kinabuhi, su unu ko matokawan kow to pagtidow ku. ");
INSERT INTO msmNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Su pag-abut to sikan no aedow, to tibo otow ogkaangod to ogkalit-agan no manuk. ");
INSERT INTO msmNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kaling pakaalistu kow aw ampu kow kanunoy agun maantus now to mgo kalisod no og-abut iyu, na, kona kow ogkasikow ko paatubangon kow kanay no Anak to Otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Na, kada aedow og-inandiya si Jesus to Bayoy to Diyus su ogpang-anad to sikan mahan-in no mgo otow no masem pad ogkangkahimun agun ogpaminog kandin. Kada madukilom, og-andiya sikandin to Kaulibuhan no bubungan su diya oglipodong. ");
INSERT INTO msmNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na, madani on to pista to mgo Hibru no og-ilingon to Pan no Wada Patubu. Og-ilingon isab sikan to Pista to Pagyaboy. ");
INSERT INTO msmNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","To diya no panahon, to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan migplanu dow og-amonuhon to pagpahimatoy ki Jesus no kona mamaanan, su nahaedok sikandan to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sikan isab no panahon, migsed si Satanas duon ki Judas no pighingadanan isab ki Iscariote. Sobuuk sikandin to sikan sampuyu-tag-duwa no mgo inanad ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Dajun andiya si Judas to yabow no mgo magdudumaya to tinuuhan dow to mgo panguyu to magbantajay duon to Bayoy to Diyus su ogpagsabut dow og-amonuhon din to pagdata ki Jesus diya kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pagdinog dan to kagi ni Judas, hilabi sikandan migtukhow aw saad no ogsuhuyan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tapus makaujun si Judas, nanginlugar sikandin to pagdata ki Jesus diya kandan no kona ogkamaanan to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na, mig-abut to una no aedow to sikan pista to mgo Hibru no og-ilingon to Pan no Wada Patubu. Sikan to aedow no oghalad sikandan to nati no karneru aw igpahinongod to Pista to Pagyaboy. ");
INSERT INTO msmNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pig-ikagihan ni Jesus si Pedro dow si Juan, “Andiya kow to Jerusalem aw hikaja now to ogkapanihapun ta to pista.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Mig-usip sikandan, “Andei koy nu man ogpahikajon?” ");
INSERT INTO msmNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Migtabak si Jesus, “Ko makased kow on duon to siyudad, ogkatagbu kow to yukos no ogdaya to tibud no pigsedan to wohig. Patiduma kow kandin diya to bayoy no og-andiyaan din. ");
INSERT INTO msmNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pagtidow now duon, ikagihi sikan tag-bayoy, ‘Pigpaandini koy to Agayon noy su og-usip dow andei sikandin ogkoon to panihapun to Pista to Pagyaboy duma koy no mgo inanad din.’ ");
INSERT INTO msmNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Dajun din ighindu iyu to mayow-ag no koonanan diya to ikaduwa no andana no tahan on pighinaat. Duon kow hikoy to panihapun ta.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Dajun panow si Pedro dow si Juan, aw kakita-i dan tibo to diya pig-ikagi ni Jesus. Dajun dan hikaja to panihapun dan to pista. ");
INSERT INTO msmNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Anoy man no tingpanihapun on, migdudunga si Jesus dow to mgo apustulis din. ");
INSERT INTO msmNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kagi din kandan, “Pig-awos ku yagboy no ayha a makabaja to pag-antus, ko makapagsayu a pad iyu to pagkoon kuntoon no Pista to Pagyaboy. ");
INSERT INTO msmNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Su iyan nanda sei to pagkoon ku to seini no pagkoonan kotob no matuman on to kahuyugan to seini no pista diya to gingharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Dajun dawata ni Jesus to tasa aw pasalamati to Diyus. Pagkatapus, mig-ikagi sikandin, “O, masig-inom kow to seini, ");
INSERT INTO msmNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","su iyan nanda seini to pag-inom ku to gita to ubas kotob no matuman on yagboy to paghari to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","No makainom on sikandan, migdawat si Jesus to pan aw isab pasalamat. Dajun din tibaga aw itadwoy kandan dow ikagi, “Yawa ku seini no ighalad tongod iyu. Ilingon now to seini to paghandom kanay.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pagtakas dan to pagkoon, pigdawat isab ni Jesus to tasa aw ikagi, “Seini inomon iyan igpasabut to bag-u no kasabutan no oghinangon to Diyus iyu no ogdigonon pinaagi to yangosa ku no igpaawas tongod iyu. ");
INSERT INTO msmNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","“Siak no Anak to Otow, ogkamatoy a su iyan man planu to Diyus. Sobuuk iyu no duma ku kani ogyuib kanay, di alaot yagboy sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Dajun pauusipay to mgo inanad ni Jesus dow hintawa buwa sikan ognangonon din no ogyuib kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na, migyayalis to mgo inanad dow hintawa kandan to og-ilingon no yabow. ");
INSERT INTO msmNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Di kagi ni Jesus, “To mgo hari dow duma no mgo yabow to yain-yain no mgo tribu ogpamayabi-yabi to mgo sakup dan, di gustu dan no og-ilingon gihapun no mgo matinabangon. ");
INSERT INTO msmNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Di kona kow ogpag-angod kandan. Nasi ko hintawa to yabow iyu iyan mupaobos. Aw to agayon, isipon din no suguonon sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hintawa man to yabow, sikan oghonatan to pagkoon ko sikan oghonat? Sikan oghonatan. Di siak no panguyu now iyan nasi og-alagad iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","29","Migpadajun si Jesus to pag-ikagi, “To Diyus no Amoy ku diya to yangit migbogoy kanay to katongod to paghari. Aw sikiyu no mig-unung kanay no duon a to mgo kalisod ogbogajan ku isab to katongod to pagmandu. ");
INSERT INTO msmNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Su duon to gingharian ku ogpayogoban kow to trunu no og-ingkudan now to pagmandu to duma now no mgo kaliwat to diya sampuyu-tag-duwa no mgo anak ni Israel. Ogpakapagsayu kow isab kanay to pagkoon dow pag-inom duon to lamisa ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tapus to sikan, pig-ikagihan ni Jesus si Simon Pedro, “Simon, paminog ka. Pigtugutan to Diyus si Satanas to pag-anti iyu su og-ahaon ni Satanas dow meyduon duma iyu no ogkaangod to apa no ogyajap ko tahopon. ");
INSERT INTO msmNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Di ing-ampu ku sikuna agun no kona magoba to pagtuu nu. Iyan isab pag-ampu ku no ko makapauli ka da to madigon no pagtuu, digonon nu isab to pagtuu to mgo duma nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Dajun ikagi si Pedro, “Ginuu, kona ku yagboy sikuna og-ojowan inggad pad prisuhon ubin himatajan ka.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kagi ni Jesus, “Pedro, indani seini. Kona pad ogtagauk to manuk gaja, iglidung a nud to katatoyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Dajun ikagihi ni Jesus to tibo inanad din, “To diya una no suguon ku sikiyu, wada ku sikiyu padaeha to saepi, puju dow ilisan no sapatus. Na, nokoy man to nakuyang iyu?” Kagi dan, “Wada.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kagi ni Jesus, “Di sugud kuntoon, dawdaya kow on ko meyduon puju dow saepi now. Ko wada ispada now su wada igkaboli, baligja kow to kabo now aw iboli to ispada. ");
INSERT INTO msmNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Su kinahangyan matuman sikan pig-iling duon to Kasuyatan to Diyus bahin kanay, ‘Og-isipon sikandin no makasasaya.’ Madani on sikan ogkatuman.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","To mgo inanad mig-ikagi ki Jesus, “Aha ka Ginuu. Mey on ispada ta no daduwa no buuk.” Kagi ni Jesus, “Hustu on.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Dajun panow si Jesus duma to mgo inanad din pailing diya to Kaulibuhan no bubungan su nabatasan din man. ");
INSERT INTO msmNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pagtidow dan diya, mig-ikagi si Jesus, “Ampu kow agun kona kow matintal.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Dajun andiya si Jesus to unahan dow yuhud aw ampu no mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Amoy ku, ko pagboot nu, ajaw a ogpabajaa to sikan no mgo antusonon. Di to pagboot nu iyan matuman, kona no sikan kanay.  ");
INSERT INTO msmNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","No mig-ampu pad si Jesus, meyduon anghil no napuun diya to yangit no mig-anduon kandin aw digona to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na, migyabi on to pag-ampu din tongod to hilabi no kaguul no pigbati din. To mgo huyas din sahian ka da to mgo tinagdu to yangosa no ogkangkatanak duon to pasak. ");
INSERT INTO msmNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","No makaampu on si Jesus, migpauli sikandin duon to mgo inanad din, aw pigkita din no nalipodong on sikandan su pigyotajan tongod to kaguul. ");
INSERT INTO msmNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dajun din pukawa no mig-iling, “Aduy, nokoy no nalipodong kow man? Bangun kow aw ampu agun kona kow matintal.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","No mig-ikagi pad si Jesus, migtidow to mahan-in no mgo otow. Iyan nanguyu kandan si Judas no sobuuk to sikan sampuyu-tag-duwa no mgo inanad din. Dajun duguk si Judas ki Jesus su oghadokan. ");
INSERT INTO msmNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Di kagi ni Jesus, “Nokoy man Judas, igpabaja nu naan to hadok to pagyuib nu kanay no Anak to Otow? ");
INSERT INTO msmNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pagsabut to mgo inanad ni Jesus to ogkahitabu, pig-usip dan si Jesus, “Ginuu, ogpanigbason noy on?” ");
INSERT INTO msmNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Duon-dajun sobuuk to sikan mgo inanad ni Jesus migtigbas to suguonon to sikan kinayabawan no magdudumaya to tinuuhan, di iyan da naigu to kalintuu no talinga aw kasagping. ");
INSERT INTO msmNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Di kagi ni Jesus, “Ajaw!” Dajun din dampaa sikan talinga aw kaulii. ");
INSERT INTO msmNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dajun din ikagihi sikan yabow no mgo magdudumaya dow to mgo panguyu to magbantajay duon to Bayoy to Diyus hasta to duma no inila no mgo Hibru no ogdakop kandin. Mig-iling si Jesus, “Nokoy man, tulisan a no migdae kow man to mgo ispada dow mgo taepos to pagdakop kanay? ");
INSERT INTO msmNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nokoy no wada a now dakopa duon to Bayoy to Diyus no duma ku man sikiyu kada aedow? Di pigtagadan now to kadigyom su iyan man ogboot iyu si Satanas no panguyu to kadigyoman. ");
INSERT INTO msmNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dajun dakopa si Jesus aw daeha diya to bayoy to sikan kinayabawan no magdudumaya to tinuuhan to mgo Hibru. Migyupug si Pedro di migpadiyu da. ");
INSERT INTO msmNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pagtidow dan, migbuhi sikandan to kaeju duon to pawa aw ingkud su ogpanghinadang. Migpagsakot si Pedro kandan, ");
INSERT INTO msmNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","di pigkita sikandin to suguonon no bohi su natang-awan man to kaeju. Pigpak yongyongan din si Pedro aw ikagi, “Duma isab seini ni Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Di miglidung si Pedro no mig-iling, “Igi, wada a kay makakiyaya kandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wada kayugoy, pigkita on isab si Pedro to yain no otow no mig-iling, “Duma ka dan isab.” Di mig-iling si Pedro, “Eh, kona!” ");
INSERT INTO msmNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pagyaboy to songo uras, meyduon yain no otow no mig-iling, “Tinood iyan no duma ni Jesus seini no otawa, su taga-Galilea man sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Di mig-ikagi on isab si Pedro, “Wada yagboy kalibutan ku to sikan pigpang-ikagi nu.” No mig-ikagi pad si Pedro, migtagauk dajun to manuk. ");
INSERT INTO msmNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Dajun lingi si Jesus aw pak yongyongi si Pedro. Aw kadomdomi din to diya kagi to Ginuu kandin no pig-iling, “Kona pad ogtagauk to manuk gaja, iglidung a nud to katatoyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Dajun panow si Pedro aw ngog-ngog tongod to hilabi no pagsakit to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Na, pighinang si Jesus no kangisihanan to mgo otow no migbantoy kandin aw susumbaga. ");
INSERT INTO msmNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pigsampongan dan isab to mata din dow sampaluha aw ikagi, “Tag-ana dow hintawa to migsampalu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mahan-in pad to kagi dan no pagtamay ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pagkamasem on, namanhihimun to yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan hasta to inila no mgo duma dan. Dajun daeha si Jesus aw paatubanga kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kagi dan ki Jesus, “Nangoni koy dow sikuna iyan to diya Insaad no Manyuyuwas.” Migtabak si Jesus, “Inggad nangonan ku sikiyu no siak iyan, di kona kow man ogtuu. ");
INSERT INTO msmNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ko usipon ku isab sikiyu, kona kow isab ogtabak. ");
INSERT INTO msmNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Di seini da. Sugud kuntoon, ogpasidonggan ad no Anak to Otow su ogpaingkudon a duon to kalintuu no takidingan to Gamhanan no Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dajun dan usipa si Jesus, “To boot nu igpasabut no sikuna iyan to Anak to Diyus?” Migtabak si Jesus, “Naikagi now on.” ");
INSERT INTO msmNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Na,” kagi dan, “set ki pad man ogpamangha to kistigus no sikitad on man yagboy to migdinog to kagi din.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Dajun tindog to tibo nahimun duon aw daeha dan si Jesus diya ki Gubernadur Pilato. ");
INSERT INTO msmNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pagtidow dan diya to bayoy din, inriklamu dan si Jesus. Kagi dan, “Nasakpanan noy seini no otawa no migpasuwoy to angod noy no mgo Hibru. Ogpogongan din sikandan to pagbajad to buhis diya to hari to Roma, aw pigpatuu din sikandan no sikandin kun to diya Insaad no Manyuyuwas no ogpaharion to Diyus to kaotawan din.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pig-usip ni Gubernadur Pilato si Jesus, “Sikuna iyan to hari to mgo Hibru?” Migtabak si Jesus, “Naikagi nud.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Dajun ikagihi ni Pilato sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to kaotawan, “Wada nakitaan ku no sae to seini no otow.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Di migdugang on nasi to kaagbot to kagi dan no mig-iling, “Pigsamuk din to duma noy no mgo Hibru pinaagi to pagpang-anad din sugud diya to Galilea hangtod dini ita.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Dajun usip si Pilato, “Taga-Galilea naan sikandin?” ");
INSERT INTO msmNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na, pagkamaan din no taga-Galilea si Jesus, impahatod din diya ki Herodes Antipas no gubernadur to Galilea, su duon si Herodes to Jerusalem to sikan no panahon. ");
INSERT INTO msmNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nayugoy da podom ogpagkita si Herodes ki Jesus su mahan-in on to nadinogan din bahin kandin. Kaling hilabi sikandin migtukhow no kitaon din si Jesus su mig-iman no ogpakita si Jesus to milagru. ");
INSERT INTO msmNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mahan-in to impangusip ni Herodes ki Jesus, di wada sikandin tabak. ");
INSERT INTO msmNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Dajun tindog sikan yabow no mgo magdudumaya to tinuuhan to mgo Hibru dow to mgo maistru to tinuuhan, aw maagbot hilabi to pagriklamu dan kuntra ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pagkatapus, pigtamay si Jesus aw pakasikawi ni Herodes dow to mgo sundayu din. Pigkaboan dan si Jesus to kapa no kaning hari aw i-uli dan sikandin diya ki Pilato. ");
INSERT INTO msmNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na, si Herodes dow si Pilato nayugoy da no migkuntrahan, di duon to sikan no aedow nahiuli sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","No ikabalik on si Jesus diya ki Pilato, pighimun ni Pilato sikan yabow no mgo magdudumaya to tinuuhan dow to duma no mgo inila hasta to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Kagi din, “No daehon now seini otow dini kanay, pig-ikagihan a now no pigpasuwoy din to kaotawan to balaod to gubernu. Di pag-imbistiga ku kandin kani to atubangan now, wada nakitaan ku no ogkapasikadan to mgo riklamu now kuntra kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Wada isab nakitaan ni Herodes, su imbalik din man dini kanay. Na, manno wada hinang din no angay din igkamatoy, ");
INSERT INTO msmNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ogpalinapdosan ku puli aw pasabuki.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pagdinog to mgo otow to kagi ni Pilato, migdodongan sikandan to pagkuliya, “Himataji sikandin! Iyan sabuki si Barabas!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Na, si Barabas naprisu su mig-ibak to kagubut duon to Jerusalem aw nakamatoy isab to otow. ");
INSERT INTO msmNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pig-ikagihan on isab ni Pilato to mgo otow su iyan podom naliyagan din no si Jesus to ogsabukan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Di migkinuliya gihapun sikandan, “Himataji! Iyansang duon to krus!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mig-ikagi si Pilato kandan to ikatoyu, “Nokoy man to sae din? Wada nakitaan ku no angay din igkamatoy. Na, puli ku ogpalinapdosan aw pasabuki.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Di nasi on mig-agbot to kinuliya to mgo otow agun mapogos si Pilato to pagpayansang ki Jesus duon to krus. Na, bali man no nadaog si Pilato to pagboot dan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kaling intugut din sikan kagustuhon dan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dajun din pasabuki si Barabas no naprisu tongod to pagtinggubut dow paghimatoy to otow. Di si Jesus indata duon to sikan mgo otow agun matuman to pagboot dan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Dajun daeha si Jesus to mgo sundayu su igyansang duon to krus. Pagpanow dan, ingkatagbu dan to otow no taga-Cirene no iyan ngadan si Simon no napuun diya to hilit. Pigpogos dan sikandin to pagtiang to sikan krus aw pasunu-a ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na, duon to pangindaenan, mahan-in yagboy to mgo otow no migduma kandin yakip to mgo bohi no namaniyahu aw pamandegmatoy tongod kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Piglingi ni Jesus sikan mgo bohi aw ikagihi, “Sikiyu no mgo bohi no taga-Jerusalem, kona a now ogtiyahuan. Iyan nasi tiyahuan now to iyu no kabotang dow to mgo anak now. ");
INSERT INTO msmNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Su meyduon panahon no og-abuton kow to makalilisang no mgo pag-antus aw ogpakailing kow, ‘Madojow to mgo bohi no wada panganak aw wada ogtagaudaon.’ ");
INSERT INTO msmNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Duon to sikan no panahon, ogpakailing to mgo otow, ‘Katompag kow no mgo bubungan aw tambuni koy!’ ");
INSERT INTO msmNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Su ko pigpaantus a no angod to kaju no buhi su wada sae ku, iyan on man to sae-an no mgo otow no iyan ogkaangodan to gangu no kaju!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pigdaya dan isab to daduwa no ka ribeldi su igdongan dan to paghimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pagtidow dan duon to sikan banwa no og-ilingon to Boboungon, inyansang dan si Jesus duon to krus aw lindoga. Inyansang dan isab sikan daduwa no ka otow duon to mgo krus aw lindoga duon to magdibayuy ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Dajun ampu si Jesus no mig-iling, “Amoy ku, pasayluha sikandan su wada dan kamaani seini pighinang dan.” To mgo kabo ni Jesus pigbabahin to mgo sundayu pinaagi to ripa. ");
INSERT INTO msmNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","To duma no mgo otow puli migsayap ki Jesus, di sikan inila no mgo Hibru migsujan-sujan kandin no mig-iling, “Nakayuwas kun sikandin to duma. Na, ipayuwas to kandin kaugalingon ko sikandin iyan to diya Insaad no Manyuyuwas!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sikan mgo sundayu migsujan-sujan isab kandin. Pigduguk dan si Jesus su ogpainomon to suka ");
INSERT INTO msmNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","aw ikagihi, “Ko tinood no hari ka to mgo Hibru, yuwasa to kaugalingon nu.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pig-iling dan to sikan su meyduon sinuyat duon to babow to uyu ni Jesus no pig-iling, “Hari seini to mgo Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sobuuk to sikan mgo ribeldi no inyansang duon migsujan-sujan isab ki Jesus no mig-iling, “Ko sikuna iyan to diya Insaad no Manyuyuwas, yuwasa to kaugalingon nu aw iyakip koy!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Di pigsapadan sikandin to sikan angod din no mig-iling, “Inggad ogkamatoy kad on, kona ka gihapun ogkahaedok to Diyus. Tibo ki ogkamatoy. ");
INSERT INTO msmNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ita no daduwa, angajan ki no ogkastiguhon su ogkabayosan ki to nangkahinang ta. Di seini no otow wada sae.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Dajun sikandin ikagi, “Jesus, sadangay domdoma a ko mupauli kad on to paghari.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Kagi ni Jesus, “Kuntoon mismu no aedow ogpakaduma ka kanay diya to yangit.” ");
INSERT INTO msmNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pagkaugtu, migdigyom to kalibutan hangtod to alas tres to kahapunon. ");
INSERT INTO msmNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sikan isab no uras, natonga to pagkahigbit sikan madamey no panapton no yopon to sikan Pinakabalaan no Sinabong duon to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dajun tawag si Jesus to maagbot, “Amoy ku, igdata kud ikow to umagad ku.” Dajun sikandin kabigtawi. ");
INSERT INTO msmNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pagkita to sikan kapitan to mgo sundayu to nahitabu, migsaja sikandin to Diyus. Kagi din, “Tinood iyan no wada sae to seini no otow!” ");
INSERT INTO msmNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","To mgo otow isab no namansayap duon, pagkita dan to nahitabu, naman-uli sikandan no puli ogpamakadabu to dagaeha su migsakit yagboy to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Di to mgo amigu ni Jesus migpadiyu da no migsayap, yakip to mgo kabujagan no namanduma-duma kandin sugud pad diya to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Na, meyduon otow no iyan ngadan si Jose no taga-Arimatea no sakup to Judea. Madojow sikandin dow matarong no otow no migtatagad to paghari to Diyus. Sakup sikandin to husajan, di wada din ujuni to hukum to diya mgo angod din to pagpahimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na, pagkabigtawid on ni Jesus, mig-andiya si Jose ki Pilato aw hangyu no sikandin to ogyobong ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tapus makaujun si Pilato, pigpudut ni Jose sikan yawa ni Jesus duon to krus. Piglibodan din to madojow no panapton aw ibotang duon to yobonganan no intugib duon to batu no wada pad disti kayobongi. ");
INSERT INTO msmNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pagyobong din ki Jesus, madani on ogsugud to Aedow no Tigpahuway, su mahapun on to Bernis no iyan igpangandam to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sikan mgo bohi no migduma-duma ki Jesus likat diya to Galilea migyupug ki Jose. Pigkita dan to pagyobong ki Jesus aw pig-indanan dan sikan yobonganan. ");
INSERT INTO msmNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Dajun sikandan uli aw hinaat to ighapyas dow igpahomut dan to yawa ni Jesus. Tapus to sikan, migpakamonang sikandan agun matuman to balaod bahin to Aedow no Tigpahuway. ");
INSERT INTO msmNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pagka-Duminggu, migsoyom sikan mgo bohi diya to pigyobongan ki Jesus no namandae to diya pighinaat dan no mgo pahomut. ");
INSERT INTO msmNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Pagtidow dan duon, pigkita dan no naligad on to diya piglipid no gatung no inyopon. ");
INSERT INTO msmNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Dajun sikandan sed, di wada dan kakita-i to yawa ni Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","No dugaja pad natingaya sikan mgo bohi, puli nakatokow pigkita dan to daduwa no ka otow no namanindog duon to topad dan no nangabo to ogpakasilow no kaputi. ");
INSERT INTO msmNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pigdaitan sikan mgo bohi aw namakadumuk. Dajun ikagi sikan daduwa no ka otow, “Nokoy no ogpamanghaon now man to otow no buhi kani to seini yobonganan to patoy? ");
INSERT INTO msmNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wadad si Jesus kani su nabanhaw on. Domdoma now to diya pig-ikagi din iyu no duma now pad sikandin diya to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mig-iling no kinahangyan idata sikandin no Anak to Otow diya to mgo makasasaya agun igyansang duon to krus. Di duon to ikatoyu no aedow ogbanhawon da.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pagdinog to sikan mgo bohi to kagi to sikan mgo anghil, nadomdoman dan to diya pig-ikagi ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Dajun sikandan pauli duon to sikan sampuyu-tag-isa no mgo inanad ni Jesus dow to tibo mgo duma dan aw inawnangon dan to tibo no pigkita dan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iyan mignawnangon diya to mgo apustulis si Maria Magdalena, si Juana, si Maria no inoy ni Santiago, dow duma pad no mgo bohi. ");
INSERT INTO msmNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Di to mgo apustulis wada tuu to kagi to sikan mgo bohi, su nailing to boot dan no mgo kagi puli sikan no wada sibli. ");
INSERT INTO msmNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Di si Pedro dajun miglinaguy pailing diya to yobong ni Jesus. Pagtidow din, mig-obo sikandin aw linghag, di iyan da pigkita din sikan panapton no inlibod to yawa ni Jesus. Dajun uli si Pedro no naboyong dow nokoy to nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Duon to iyan da no aedow, meyduon daduwa no mgo sakup ni Jesus no mig-andiya to baryu to Emmaus, mgo sampuyu-tag-isa no kilumitru likat to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iyan da pighisgutan dan sikan bag-u pad no mgo hitabu. ");
INSERT INTO msmNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Monok on, meyduon migduguk aw pagduma kandan. Si Jesus sikan, ");
INSERT INTO msmNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","di angod to pigsampongan to mata dan su wada dan kiyayaha. ");
INSERT INTO msmNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Dajun usip si Jesus kandan, “Nokoy man to duon oghisgutan now?” Migsigkon sikan daduwa to pagpanow, aw ogkaaha duon to bayhu dan no naguul sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sobuuk kandan no iyan ngadan si Cleopas mig-ikagi, “Sikuna da kay buwa to mig-ugpa diya to Jerusalem no wada kamaan to sikan bag-u no nangkahitabu diya.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Mig-usip si Jesus, “Nokoy man to nahitabu?” Migtabak sikandan, “To nahitabu ki Jesus no taga-Nazaret. Namaanan noy no kibali ba-ba sikandin to Diyus, su piggahoman to Diyus to tibo pigpang-ikagi dow pigpanghinang din duon to atubangan to Diyus dow otow. ");
INSERT INTO msmNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Di indata sikandin diya ki Pilato to sikan yabow no mgo magdudumaya to tinuuhan dow duma no mgo inila agun hukuman to kamatajon, aw iyansang sikandin duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mig-iman koy on podom no sikandin to diya ogpaabuton noy no ogyuwas ita no mgo kaliwat ni Israel, di tatoyu on no aedow to paghimatoy dan kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na ganina, meyduon nadinog noy no nakapatingaya kanami. Mey mgo duma noy no mgo bohi no migsoyom diya to pigyobongan kandin. ");
INSERT INTO msmNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Di pigboyong dan sikandin. Dajun sikandan pauli aw nangoni koy no mey pigkita dan no mgo anghil no mig-iling no nabanhaw si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dajun andiya isab to duma noy no mgo yukos, aw pigkita dan no tinood to pig-ikagi to diya mgo bohi su wada dan isab sikandin kitaa.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Dajun ikagi si Jesus, “Abee, kayugoy now on man igpakasabut dow igtuu to tibo mgo sinuyat to diya kibali mgo ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Og-usip a iyu, wada kow kamaan no kinahangyan og-antus to diya Insaad no Manyuyuwas, aw tapus to sikan, ogkapasidonggan sikandin?” ");
INSERT INTO msmNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dajun ipasabut ni Jesus kandan to diya impanag-an bahin kandin duon to Kasuyatan to Diyus sugud to diya mgo sinuyat ni Moises dow to duma no kibali ba-ba to Diyus. Di sikan daduwa no ka otow no impagduma ni Jesus wada kamaan no si Jesus naan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Anoy man no madani on to baryu no ogdeygan to sikan daduwa, angod to ogpadajun si Jesus to panow din. ");
INSERT INTO msmNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Di pigpak hinggat dan, kagi dan, “Yagi, mahapun on kay, ogkadukiloman kad. Kani kinow on oghibat.” Dajun duma si Jesus kandan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Anoy man no tingpanihapun on, migpagdunga si Jesus kandan duon to lamisa. Migdawat sikandin to pan aw pasalamat to Diyus, dajun panibaga. Aw pagpamogoy din kandan, ");
INSERT INTO msmNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","pigkiyaya dan dajun si Jesus, su to mata dan angod to nagawangan to sampong. Pagkakiyayahi dan, puli migjopot to pilok dan su pigboyong dan on si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kagi dan, “Gin-anow naan migdojow to ginhawa ta no hiluwasan ki din to Kasuyatan to Diyus no duon ki pad to pangindaenan.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Duon-dajun migtindog sikandan aw pauli diya to Jerusalem. Nakitaan dan sikan sampuyu-tag-isa no mgo inanad dow duma no mgo sakup ni Jesus no tahan on nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ognangon podom sikan daduwa, di naunahan sikandan to sikan nahimun no mig-iling, “Nabanhaw da naan to Ginuu su migpakita ki Pedro!” ");
INSERT INTO msmNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dajun inangon to sikan daduwa to nahitabu kandan duon to pangindaenan yakip to pagkiyaya dan ki Jesus no panibagon din to diya pan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","No wada pad sikandan makatapus to pag-ikagi, migpakita si Jesus to sikan nangkahimun aw ikagihi, “Mahusoy podom to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Di pigdaitan sikandan su nailing to boot dan no umagad sikan pigkita dan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kagi ni Jesus, “Nokoy no nahaedok kow man? Nokoy no ogduwa-duwa kow isab? ");
INSERT INTO msmNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ahaa now seini mgo boyad dow kobong ku no pigyagbasan to yansang agun mamaanan now no si Jesus a yagboy. Dampaa a now su to umagad wada yawa. Di oho, meyduon yawa ku.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Dajun din ipakita kandan to mgo boyad dow kobong din. ");
INSERT INTO msmNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Di tongod to hilabi no kalipay dow katingaya, angod to kona sikandan ogpakatuu no si Jesus sikan pigkita dan. Kaling mig-usip si Jesus, “Wada pagkoon now kani?” ");
INSERT INTO msmNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Dajun dan bogaji to hinayub no isda. ");
INSERT INTO msmNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pigdawat din aw koona duon to atubangan dan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tapus to sikan, mig-ikagi si Jesus, “Natuman on to diya pig-ikagi ku iyu no migduduma kinow pad. Pig-iling ku no kinahangyan no matuman to impanag-an bahin kanay duon to mgo sinuyat ni Moises dow to duma no mgo kibali ba-ba to Diyus hasta duon to mgo Salmo.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dajun ipasabut ni Jesus kandan to diya impamasuyat to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kagi din, “Ojow pa to Kasuyatan, kinahangyan og-antus dow ogkamatoy to diya Insaad no Manyuyuwas, di ogbanhawon da duon to ikatoyu no aedow. ");
INSERT INTO msmNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kinahangyan isab no nangonan to tibo mgo tribu sugud kani to Jerusalem. Ikagihan sikandan no ogpasayluhon sikandan to Diyus tongod kanay ko musosey sikandan aw talikud to mgo sae dan dow iyan on atubangon dan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sikiyu to migkita to sikan tibo, aw sikiyu isab to ognawnangon diya to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Di pakamonang kow naa kani to Jerusalem kotob no konsadan kow to sikan gahom no ogkapuun diya to yangit no insaad to Amoy ku iyu.” ");
INSERT INTO msmNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pigpaduma ni Jesus to mgo inanad din diya to baryu to Betania. Dajun din bajawa to mgo boyad din aw panalangini sikandan. ");
INSERT INTO msmNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","No dugaja din pad sikandan pigpanalanginan, nabatun si Jesus diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Pagkalius din on, sikan mgo sakup din namanimba kandin, aw malipajon no migpauli diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kada aedow og-inandiya sikandan to Bayoy to Diyus su ogsajaon dan to Diyus.");
INSERT INTO msmNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Diya to sinugdanan no wada pad kahinang seini kalibutan, sikan og-ilingon to Kagi tahan on duon. Duma sikandin to Diyus, aw Diyus yagboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Sugud pad to sinugdanan, tahan on sikandin duma to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pighinang to tibo pinaagi kandin. Wada nahinang no wada ipabaja kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sikandin to napuunan to kinabuhi no ogkaangod to kaawang no ogtang-ow to otow. ");
INSERT INTO msmNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sikan no kaawang ogsiga duon to kadigyoman, aw sikan no kadigyom wada makadaog to sikan no kaawang. ");
INSERT INTO msmNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Na, meyduon otow no pigpaandini to Diyus no iyan ngadan si Juan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Pigsugu sikandin to pagnawnangon bahin to sikan og-ilingon to Kaawang agun no makatuu to tibo otow pinaagi to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kona no si Juan sikan og-ilingon to Kaawang, di sikandin to pigsugu to Diyus to pagnawnangon bahin to sikan no Kaawang. ");
INSERT INTO msmNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sikan matuud no Kaawang no og-ilingon isab to Kagi mig-andinid on to kalibutan agun matang-awan to tibo kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mig-andini sikandin to seini kalibutan no pighinang din, di wada sikandin kiyayaha to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Inggad duon to banwa din, wada sikandin dawata to kaotawan din. ");
INSERT INTO msmNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Di to diya migdawat dow migtuu kandin pigbogajan din to katongod to pagkahinang no mgo anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","To pagkahinang dan no mgo anak to Diyus kona no angod to pag-anak to otow tongod to hingawos dow pagboot to otow, di tongod to pagboot to Diyus. Su to Diyus iyan nahinang no Amoy dan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Sikan og-ilingon to Kagi migpakaotow aw mig-agpot dini ita. Makawkayuujon sikandin aw tinood no bayhu to Diyus no impakita dini ita. Naaha noy to pagka-Diyus din isip sobuukon no Anak no napuun to Diyus no Amoy. ");
INSERT INTO msmNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sikandin to diya pighisgutan ni Juan no Magbawtismuhay no imbansagon din to pag-ikagi, “Seini to diya otow no ognangonon ku no ogpakasunu kanay. Di to matuud, yabow pad yagboy sikandin kanay, su no wada a pad i-anak, tahan on sikandin duon.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Wada kinotoban to sikan no kayuuy din ita, kaling kona ogkabigtow to mgo kadojawan no igbogoy din ita tibo. ");
INSERT INTO msmNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","To diya una, to mgo balaod no imbogoy to Diyus ita impabaja ki Moises, di kuntoon impabaja ki Jesu-Cristo to kadojow dow kayuuy din ita hasta to pagpasabut ita to kinaiya din. ");
INSERT INTO msmNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wada pad otow no nakakita to Diyus. Di sikan sobuukon no Anak din no kanunoy duma kandin iyan migpakiyaya kandin dini ita. ");
INSERT INTO msmNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Meyduon mgo magdudumaya to tinuuhan to mgo Hibru dow duma no mgo kaliwat ni Levi no mig-andiya ki Juan. Pigsugu sikandan to inila no mgo Hibru diya to Jerusalem to pag-usip dow mig-angkon si Juan no sikandin to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pagdinog ni Juan to usip dan, wada lipod-lipod din to pagtabak. Kagi din, “Kona no siak to diya Insaad no Manyuyuwas.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Dajun sikandan usip ki Juan, “Na, hintawa ka man naan? Sikuna buwa si Elias no kibali ba-ba to Diyus to diya una?” Migtabak si Juan, “Kona isab.” Mig-usip isab sikandan, “Sikuna kay buwa to diya duma no ogpaabuton noy no kibali ba-ba to Diyus?” Di migtabak si Juan, “Kona.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Na,” kagi dan, “ikagihi koy dow hintawa ka yagboy agun no meyduon igkanangon noy to sikan namansugu kanami. Nokoy man to ogkaikagi nu bahin to katongdanan nu?” ");
INSERT INTO msmNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Dajun tabak si Juan, “Siakon to diya intag-an ni Isaias no kibali ba-ba to Diyus to diya una no mig-iling, ‘Meyduon ogbansagon diya to matahay no banwa no og-iling, Hinaata to dayan to Ginuu!’ ” ");
INSERT INTO msmNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Na, sikan mgo otow no pigsugu to mgo Pariseo ");
INSERT INTO msmNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","to pag-usip ki Juan naman-iling, “Na, ko kona no sikuna to diya Insaad no Manyuyuwas aw kona ka isab no si Elias ubin sikan duma no kibali ba-ba to Diyus no ogpaabuton noy, nokoy man to katongod nu to pagpamawtismu?” ");
INSERT INTO msmNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Migtabak si Juan, “Tinood no ogpamawtismu a, di pinaagi da to wohig. Di meyduon ogpakasunu no yabow pad yagboy kanay. Su ngani man to paghukas to sapatus din, di kona a og-angajan. Duon on sikandin iyu, di wada now kiyayaha.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nahitabu sikan diya to baryu to Betania no dihipag to Jordan no wohig no duon pamawtismu si Juan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pagkabukas, pigkita ni Juan si Jesus no ogpadodoyog duon kandin. Dajun ikagihi ni Juan to kaotawan, “Aha kow! Sujad on to diya otow no angod to nati no karneru no pigpaandini to Diyus su iglimpas to kaotawan agun magawang to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sikandin to diya pig-iling ku, ‘Meyduon ogpakasunu kanay no yabow pad kanay, su no wada a pad i-anak, tahan on sikandin duon.’ ");
INSERT INTO msmNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ngani a man, di wada a kiyaya kandin to diya una. Di mig-andini a gihapun to pagpamawtismu to wohig agun no sikiyu no mgo kaliwat ni Israel makakiyaya kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Wada a iyan kiyaya kandin, di sikan migsugu kanay to pagpamawtismu to wohig mig-iling, ‘Sikan ogkitaon nu no ogkonsadan to Ispiritu ku aw ogpakamonang duon, sikandin to ogpamawtismu to Ispiritu Santu.’ Na, pigkita ku man iyan to Ispiritu Santu no angod to salapati no migkonsad likat to yangit aw pakamonang duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kaling su pigkita kud sikan,” kagi ni Juan, “kona ad on ogduwa-duwa to pagnangon iyu no si Jesus yagboy iyan Anak to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pagkabukas, duon on isab si Juan to dihipag to Jordan no wohig duma to daduwa no mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Pagkita din ki Jesus no migyaboy, nakaikagi si Juan, “Aha kow! Sujad on to diya otow no angod to nati no karneru no imbogoy to Diyus no lilimpasay!” ");
INSERT INTO msmNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Pagdinog to sikan daduwa no mgo inanad ni Juan to sikan kagi din, dajun yupug sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Paglingi ni Jesus, pigkita din sikandan no migyupug kandin aw usipa, “Nokoy man to tuud now?” Migtabak sikandan, “Rabi,” (no ko ita pa, Maistru) “andei ka man ugpa?” ");
INSERT INTO msmNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Migtabak si Jesus, “Ogduduma kinow diya agun ogkaaha now.” Dajun duma sikandan ki Jesus diya to pig-ugpaan din. Alas kuwatru on to kahapunon to diya, aw migpakamonang sikandan duon kandin to sikan no aedawa. ");
INSERT INTO msmNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Si Andres sobuuk to sikan daduwa no migdinog to kagi ni Juan aw migyupug ki Jesus. Dajun din pamanghaa to suun din no si Simon aw ikagihi, “Nakitaan noy on to diya Insaad no Manyuyuwas!” ");
INSERT INTO msmNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Dajun din dumaha diya ki Jesus. Pagkita ni Jesus ki Simon, pigyongyongan din aw ikagihi, “Sikuna si Simon no anak ni Juan. Di oghingadanan ku sikuna ki Cefas.” (To ngadan no Cefas angod da to kahuyugan to ngadan no Pedro, no ko ita pa, batu.) ");
INSERT INTO msmNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Pagkasunu no aedow, mig-andiya si Jesus to prubinsya to Galilea. Nakitaan din si Felipe no taga-Betsaida no iyan isab yunsud ni Andres dow ni Pedro aw ikagihi, “Yagi, duma kad on kanay su oghinangon ku sikuna no inanad.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dajun pamanghaa ni Felipe si Natanael aw ikagihi, “Nakitaan noy on to diya otow no intag-an duon to mgo sinuyat ni Moises dow to duma no kibali ba-ba to Diyus! Si Jesus to ngadan din. Taga-Nazaret sikandin no anak ni Jose.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Eh,” kagi ni Natanael, “wada kay buwa kadojawan no ogkapuun diya to Nazaret.” Kagi ni Felipe, “Ogduduma ki agun makakita ka.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pagkita ni Jesus ki Natanael no ogpadodoyog duon kandin, mig-iling sikandin, “Suja to tinood yagboy no kaliwat ni Israel no wada paglimbung.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mig-usip si Natanael, “Pig-amonu nu man to pagkamaan kanay?” Migtabak si Jesus, “Wada ka pad hinggata ni Felipe, pigkita kud sikuna duon to yongod to kaju no igera.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Sir,” kagi ni Natanael, “sikuna yagboy to Anak to Diyus. Sikuna to Hari noy no mgo kaliwat ni Israel.” ");
INSERT INTO msmNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mig-ikagi si Jesus, “Migtuu ka su mig-ikagi a no nakitaan ku sikuna duon to yongod to igera. Diya to umaabut no panahon, yabow pad to mgo milagru no ogkakitaan nu. ");
INSERT INTO msmNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Su ligdongi now seini. Og-abut to panahon no ogkitaon now to yangit no ogkaabri dow to mgo anghil to Diyus no ogponhik dow ogpon-ug no ogbaja kanay no Anak to Otow.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Duon to ikatoyu no aedow, meyduon kumbiti diya to yunsud to Cana no sakup to Galilea. Pig-imbita si Jesus dow to mgo inanad din. Duon isab to inoy din. ");
INSERT INTO msmNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na, pigkabusan on to inomon, kaling pigduguk si Jesus to inoy din aw ikagihi, “Pigkabusan on kay sikandan to inomon.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kagi ni Jesus, “Kona a nu ogsuguon su wada pad abut to panahon ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Dajun ikagihi to inoy ni Jesus sikan mgo suguonon, “Inggad nokoy to isugu din iyu, tumana.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na, duon to dani dan meyduon onom no ka tadjow no batu no oggamiton to pagtuman to tumanon to pagpanghugas. Kada tadjow ogkasedan to songo gatus no litru no wohig. ");
INSERT INTO msmNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pigsugu ni Jesus to mgo suguonon, “Ponu-a to wohig sikan mgo tadjow.” Dajun dan ponu-a kotob no nanami-sami. ");
INSERT INTO msmNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","“Na,” kagi ni Jesus, “sayuk kow duon aw daehi sikan otow no migdumaya to seini kumbiti.” Dajun dan tumana sikan sugu ni Jesus ");
INSERT INTO msmNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","aw tagaji sikan migdumaya to kumbiti. Wada sikandin kamaan dow andei kapuun sikan no inomon. Iyan da namaan sikan mgo suguonon no migponu to sikan mgo tadjow. Pagkatimtim din to sikan wohig no nahinang on no inomon, pigsabi din sikan bana ");
INSERT INTO msmNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aw ikagihi, “Iyan nabatasan ta no ig-una igtagoy to madojow no inomon aw ko makainom on to mgo imbitadu, iyan on igtagoy to minus no klasi. Di sikuna, kuntoon nu pad ipanagoy to pinakamadojow no inomon.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Seini milagru no pighinang ni Jesus diya to Cana no sakup to Galilea, una no pagpakita din to pagka-Diyus din, aw migdugang to pagtuu to mgo inanad din. ");
INSERT INTO msmNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tapus to sikan, mig-andiya si Jesus to yunsud to Capernaum duma to inoy dow mgo suun din hasta to mgo inanad din. Migpakamonang sikandan duon sed to pila da no aedow. ");
INSERT INTO msmNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","No madani on to pista to mgo Hibru no og-ilingon to Pista to Pagyaboy, mig-andiya si Jesus to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Pagtidow din duon, pigkita din duon to pawa to Bayoy to Diyus to mgo mamaligjaay to mgo baka, karneru, dow salapati hasta to mgo magsinsilyuhay to saepi no naman-ingkud duon to mgo lamisa dan. ");
INSERT INTO msmNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Dajun hinang si Jesus to yatus no pisi aw abuga to tibo mgo baka dow karneru diya to yuwas. Pigpanjabu din to saepi to sikan mgo magsinsilyuhay aw pamaliskada din to mgo lamisa dan. ");
INSERT INTO msmNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Dajun din ipanagda to mgo mamaligjaay to salapati, “Panggawanga now sikan kani. Kona now oghinangon no merkadu seini Bayoy to Amoy ku!” ");
INSERT INTO msmNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pagkita to mgo inanad ni Jesus to sikan pighinang din, nadomdoman dan to diya pig-iling duon to Kasuyatan to Diyus, “To pagmahal ku to bayoy nu, Diyus ku, iyan ogpakailing to kamatajon ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Di to inila no mgo Hibru mig-usip ki Jesus, “Nokoy man to milagru no igkapakita nu kanami no ogmatuud to katongod nu to paghinang to sikan?” ");
INSERT INTO msmNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","“Seini,” kagi ni Jesus. “Wasaha now seini pig-ugpaan to Diyus, aw sed to tatoyu no aedow ogbag-uhon ku da.” ");
INSERT INTO msmNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Kagi to sikan inila no mgo Hibru, “Eh, kap-atan kay mey onom no tuig to paghinang to seini Bayoy to Diyus, tapus og-isabon nu ogtukudon sed to tatoyu da no aedow?” ");
INSERT INTO msmNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Di wada sikandan makasabut no sikan yawa ni Jesus iyan pighisgutan din. ");
INSERT INTO msmNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Inggad to mgo inanad ni Jesus, ayha da makasabut no mabanhaw on sikandin. Iyan pad pagkadomdom dan to diya mgo kagi din, aw nakatuu sikandan to diya nasuyat duon to Kasuyatan no pig-ikagi ni Jesus bahin to kaugalingon din. ");
INSERT INTO msmNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","No duon pad si Jesus to siyudad to Jerusalem to diya panahon to Pista to Pagyaboy, mahan-in to mgo otow no migtuu kandin su pigkita dan man to mgo milagru no pigpanghinang din. ");
INSERT INTO msmNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Di si Jesus wada salig kandan su namaanan din to kinaiya to otow. ");
INSERT INTO msmNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Inggad wada ognangon kandin, tahan din namaanan dow nokoy to sed to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Na, meyduon Pariseo no iyan ngadan si Nicodemo no sakup isab to husajan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Songo kadukiloman migdoyom sikandin diya ki Jesus aw ikagi, “Sir, namaanan noy no pigpaandini ka to Diyus to pagpang-anad kanami. Su wada ogpakahinang to mgo milagru no angod to pighinang nu ko kona sikandin gahoman to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Mig-ikagi si Jesus, “Indani seini. To otow no kona ogkaisab ogkaotow kona ogkasakup duon to sikan ogharian to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nakaikagi si Nicodemo, “Og-amonuhon man to pagkaotow pag-isab ko manigaon on to otow? Su konad sikandin ogpakased to gotok to inoy din aw i-anak manda.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Migtabak si Jesus, “Paminog ka. Kona ogkasakup to otow duon to sikan ogharian to Diyus ko kona sikandin ig-anak pinaagi to wohig dow pinaagi to gahom to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sikan ig-anak to otow, otow isab, aw sikan ig-anak pinaagi to Ispiritu Santu, ispiritu isab. ");
INSERT INTO msmNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kona nu igkaboyong sikan pig-ikagi ku no kinahangyan maisab kow maotow. ");
INSERT INTO msmNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Igpananglit ku to kaemag. Oghodos sikan inggad andei ogdeg. Ogkadinog to kagaskas, di kona ogkatagahan dow andei ogkapuun dow andei ogdeg. Ogkaangod to sikan to pagkaotow pag-isab pinaagi to Ispiritu Santu, su kona ta ogkitaon aw kona ta ogkabootan. Iyan da ogkitaon ta to bag-u no kinaiya to mgo otow no ogkaisab ogkaotow.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Mig-usip si Nicodemo, “Ajaw naa kun. Og-amonuhon man to pagkatuman to sikan pig-ikagi nu?” ");
INSERT INTO msmNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Migtabak si Jesus, “Eh, maistru ka man podom to angod ta no mgo kaliwat ni Israel. Wada nu naan kasabuti to pig-ikagi ku? ");
INSERT INTO msmNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Paminogi yagboy seini. Ognangonan noy sikiyu to namaanan noy, aw ogkistigus koy to pigkita noy, di kona now man ogtuuhan. ");
INSERT INTO msmNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ko kona kow ogtuu to diya pig-ikagi ku bahin to kalibutanon no kadodoyog, yabi on no kona kow ogtuu ko mang-anad a bahin to mgo yangitnon. ");
INSERT INTO msmNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hintawa man to nakaandiya to yangit? Siakon da no Anak to Otow, su diya a man kapuun.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Migpadajun si Jesus to pag-ikagi ki Nicodemo no mig-iling, “To ogkahitabu kanay ogkaangod to diya hayas-hayas no intaud ni Moises to kaju aw lindoga to diya panahon no makapanow-panow to mgo kaaw-apuan ta diya to matahay no banwa. Su siak isab no Anak to Otow igtaud duon to krus aw lindoga ");
INSERT INTO msmNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agun to tibo no ogsalig kanay ogkabogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Su pighigugma hilabi to Diyus to tibo kaotawan, kaling pigpaandini din sikan sobuukon no Anak din. Inggad hintawa no ogtuu dow ogsalig kandin konad on ogkastiguhon tongod to mgo sae din di ogbogajan nasi to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Su to pagpaandini to Diyus to Anak din to kalibutan, kona no iyan tuud din to pagkastigu to mgo otow, di agun no yuwason din sikandan pinaagi to sikan pigpaandini din. ");
INSERT INTO msmNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inggad hintawa no ogtuu dow ogsalig to Anak to Diyus kona ogkastiguhon to Diyus, di inggad hintawa no kona ogsalig kandin tahan on pighukuman to kastigu su wada sikandin tuu to sikan sobuukon no Anak to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Iyan igkastiguha kandin su wada din dawata sikan og-ilingon to Kaawang no mig-andini to kalibutan, su iyan nasi naliyagan din to kadigyom, su madoot to mgo hinang din. ");
INSERT INTO msmNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Kona yagboy sikandin ogkaliyag to kaawang su ogkatang-awan man to madoot no mgo hinang din. Sikan to kinaiya to tibo mgo otow no ogkuntra to kaawang. ");
INSERT INTO msmNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Di to mgo otow no ogtuman to matuud og-anduon to kaawang agun mamaanan no Diyus to napuunan to mangkadojow no oghinangon dan.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pagkatapus to sikan, mig-andiya si Jesus dow mgo inanad din to kahilitan to prubinsya to Judea. Migpakamonang sikandan duon aw pamawtismu. ");
INSERT INTO msmNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Duon to iyan da no panahon, migpadajun si Juan to pagpamawtismu su wada pad sikandin kaprisu to diya. Duon sikandin to banwa no Enon no madani to yunsud to Salim su abunda man to wohig duon, aw mahan-in to og-andiya kandin su ogpabawtismu. ");
INSERT INTO msmNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Na, songo aedow migyayalis to mgo inanad ni Juan dow to sobuuk no angod dan no Hibru bahin to hustu no paagi to pagtuman dan to tumanon to paghugas. ");
INSERT INTO msmNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Dajun sikandan andiya ki Juan aw ikagihi, “Sir, to diya otow no pighisgutan nu no diya ki pad to dihipag to Jordan migsugud on to pagpamawtismu, aw tibo on ogpaman-andiya kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Kagi ni Juan, “Wada otow no ogpakatagon to inggad nokoy ko kona no Diyus to ogbogoy. ");
INSERT INTO msmNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Domdoma now to diya pig-ikagi ku iyu no kona no siakon to diya Insaad no Manyuyuwas. Pigpauna a puli kandin agun no mahinaat ku to pagtidow din. ");
INSERT INTO msmNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Siakon, sahian ka da to yagi to banahon no iyan ogsaligan to kumbiti. Inggad kona no sikandin to ogpakaasawa to sikan no bohi, di ogtukhow sikandin ko ogdinogon din no ogkalipay sikan bana to sikan asawa din. Kaling ogkalipay a hilabi kuntoon su mahan-in on to ogpasakup ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Su kinahangyan no muyabow sikandin, aw siak ogkaobos. ");
INSERT INTO msmNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Na, to mgo otow dini to kalibutan, kinalibutanon ko og-ikagi su sikan da to namaanan dan. Di sikan napuun diya to yangit, yabow sikandin to tibo. ");
INSERT INTO msmNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ignawnangon din to pigkita dow pigdinog din diya to yangit, di matagsa da to ogtuu to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Di inggad hintawa no ogtuu to sikan, ogpakakistigus sikandin no matuud yagboy to kagi to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","su mgo kagi man yagboy to Diyus to ignawnangon ni Jesus no pigpaandini din. Su bug-us no imbogoy kandin to gahom to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","To Amoy no Diyus mighigugma to Anak din no si Jesus, aw insalig duon kandin to pagmandu to tibo. ");
INSERT INTO msmNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Inggad hintawa no ogtuu dow ogsalig to Anak to Diyus ogbogajan to kinabuhi no wada katapusan. Di inggad hintawa no og-ojow to Anak to Diyus kona ogkabogajan to sikan no kinabuhi di nasi no ogkastiguhon sikandin to Diyus to wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Duon to sikan no panahon, nakadinog to mgo Pariseo no mahan-in kun to nangkakabig aw pigbawtismuhan ni Jesus kay to ki Juan. ");
INSERT INTO msmNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Di to tinood, wada pangunoy si Jesus to pagbawtismu, mgo inanad din da.) ");
INSERT INTO msmNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pagkamaan ni Jesus no migdinog to mgo Pariseo to sikan, miglikat sikandin dow mgo duma din to prubinsya to Judea su og-uli diya to prubinsya to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na, kinahangyan ogbajaan dan to prubinsya to Samaria, ");
INSERT INTO msmNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","aw migtidow sikandan duon to yunsud no Sikar. Duon to dani to sikan yunsud meyduon pasak no imbogoy ni Jacob to anak din no si Jose to diya una no panahon ");
INSERT INTO msmNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","no meyduon atabay no impakabut ni Jacob. Mig-ingkud si Jesus duon su pigboyajan sikandin to panow, di to mgo inanad din migpadajun diya to yunsud to pagboli to ogkakoon dan su maugtu on to diya. No migtagad pad si Jesus duon, meyduon migtidow no taga-Samaria no bohi no ogsayuk. Kagi ni Jesus kandin, “Iya, painoma a kun to wohig.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pagdinog to sikan bohi to hangyu ni Jesus, natingaya hilabi sikandin su to mgo Hibru kona ogpag-isturya to mgo taga-Samaria. Kaling mig-ikagi sikan bohi, “Nokoy no ogpamuju ka man kanay to wohig no Hibru ka man, aw siakon, bohi a no taga-Samaria?” ");
INSERT INTO msmNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Dajun tabak si Jesus, “Ko namaan ka pa to igkabogoy to Diyus ikow, aw ko namaan ka pa dow hintawa a yagboy no namuju ikow to wohig, sikuna podom nasi to ogpamuju kanay. Su ko mamuju ka pa kanay, ogkabogajan ka to wohig no ogpakabogoy to kinabuhi.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kagi to sikan bohi, “Sir, wada sasayuk nu, aw madayom seini atabay. Andei ka man ogpudut to sikan wohig no ogpakabogoy to kinabuhi? ");
INSERT INTO msmNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Si Jacob no minuna ta iyan migpakabut to seini atabay. Naiguan on sikandin dow mgo anak din hasta to mgo buhi dan to inomonon no wohig. Na, kona buwa no yabow ka pad ki Jacob no migbilin kanami to seini kadojawan?” ");
INSERT INTO msmNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Migtabak si Jesus, “To og-uhawon no otow no og-inom to seini og-uhawon da, ");
INSERT INTO msmNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","di to otow no og-inom to wohig no igpainom ku kandin konad on og-uhawon. Su sikan igbogoy ku kandin no wohig ogkahinang no tubud no og-ugwak duon to ginhawa din, aw sikan to ogkapuunan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","“Sir!” kagi to sikan bohi, “bogaji a man to sikan no wohig agun no kona ad manda og-uhawon aw kona ad makasinayuk kani.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“Na,” kagi ni Jesus, “dokata to bana nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mig-ikagi sikan bohi, “Wada bana ku.” Kagi ni Jesus, “Hustu iyan no wada bana nu, ");
INSERT INTO msmNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","su lima on to nakaasawa ikow, aw sikan duma nu no yukos kuntoon kona nu no bana.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Dajun ikagi sikan bohi, “Aw, manag-anay ka naan Sir! ");
INSERT INTO msmNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aha ka to suja bubungan. Duon simba to mgo kaaw-apuan noy. Di sikiyu no mgo Hibru og-iling no diya da ogsimbahon to Diyus to siyudad to Jerusalem.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Mig-iling si Jesus, “Sikiyu no mgo taga-Samaria wada kamaan to sikan pigsimba now. Di sikami no mgo Hibru, namaan koy yagboy to sikan pigsimba noy, su to Manyuyuwas duon ogkapuun to mgo Hibru. Paminog ka Iya. Og-abut to panahon no konad ogsimbahon to Amoy no Diyus dutun to suja bubungan aw konad isab no diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Su sikan pigpaabut no panahon mig-abut on, no to tinood no mgo magsisimba to Diyus no Amoy ogsimba kandin pinaagi to Ispiritu Santu pinasikad to matuud no pagka-Diyus din. Sikan da to pagsimba no ogkaliyagan din. ");
INSERT INTO msmNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","To Diyus ispiritu, kaling to otow no ogsimba kandin kinahangyan no igpabaja sikan to Ispiritu Santu pinasikad to matuud no pagka-Diyus din.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kagi to sikan bohi, “Namaan a no mey panahon no og-abut sikan Insaad no Manyuyuwas, aw ig-ikagi din ita to tibo.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mig-ikagi si Jesus, “Siakon no migpag-isturya ikow iyan sikan ognangonon nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na, pagpauli to mgo inanad din likat to yunsud, pigkita dan si Jesus no migpag-isturya to bohi. Hilabi sikandan natingaya, di wada inggad sobuuk no nakausip to sikan bohi dow nokoy to tuud din. Wada isab nakausip ki Jesus dow nokoy no migpag-isturya sikandin to sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Dajun ojowi to sikan bohi to sasayuk din aw pauli diya to yunsud aw ikagihi to mgo otow, ");
INSERT INTO msmNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Duma kow kanay su ighindu ku iyu to otow no nakatag-an to tibo mgo hinang ku! Basi sikandin to diya Insaad no Manyuyuwas!” ");
INSERT INTO msmNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Dajun sikandan yuwas to yunsud aw anduon ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Di no diya pad sikan bohi to yunsud, pig-igda podom si Jesus to mgo inanad din to pagkoon, kagi dan, “Sir, koon kad.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Di mig-ikagi si Jesus, “Meyduon pagkoon ku no wada now kamaani.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kagi to mgo inanad, “Meyduon kay buwa migdaya kandin to pagkoon.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Di kagi ni Jesus, “Iyan kibali pagkoon ku to pagtuman to pagboot to sikan migpaandini kanay aw to pagtapus to igpahinang din. ");
INSERT INTO msmNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Meyduon ikagihonon now no pig-iling, ‘Upat pad no buyan ayha ki ogpakaani.’ Di ko siak to paikagihon now, tig-ani on kuntoon. Su ahaa now to kaotawan. Angod sikandan to mgo tanom no anihonon on, su seinid to panahon no ogpasakup on podom sikandan kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ogbayosan to Diyus sikan kibali og-ani, aw to diya mgo otow no ogkaani dan ogbogajan to kinabuhi no wada katapusan. Na, to diya migtanom dow to diya og-ani, tibo sikandan ogtukhow. ");
INSERT INTO msmNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kaling ogkatuman sikan ikagihonon no pig-iling, ‘Meyduon ogtanom aw yain to og-ani.’ ");
INSERT INTO msmNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Pigpaani ku sikiyu to sikan wada now kaunagi, aw kuntoon sikiyu on to ogpahimuyus to trabahu to yain no otow.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Mahan-in to mgo taga-Samaria no migtuu ki Jesus duon to sikan no yunsud tongod to kagi to sikan bohi no pig-iling, “Natag-anan din to tibo mgo hinang ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pagtidow dan duon ki Jesus, pighangyu dan sikandin no mupakamonang pad duon kandan. Kaling migpakamonang onsi Jesus duon sed to daduwa no aedow. ");
INSERT INTO msmNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pagdinog to mgo taga-yunsud to kagi ni Jesus, migdugang pad to kahan-in to mgo otow no migtuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Aw pig-ikagihan dan sikan bohi, “To diya una migtuu koy ki Jesus tongod to pig-ikagi nu bahin kandin. Di kuntoon sikami on mismu to migdinog to kagi din, kaling namaan koy on no sikandin to Manyuyuwas to tibo kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pagyaboy on to daduwa no aedow, miglikat onsi Jesus su og-andiya to prubinsya to Galilea ");
INSERT INTO msmNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","inggad nakaikagi on sikandin no to otow no kibali ba-ba to Diyus kona ogtahudon duon to banwa din. ");
INSERT INTO msmNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pagtidow ni Jesus dow to mgo inanad din diya to Galilea, nahinangop to mgo taga-Galilea to pagdawat kandin su mahan-in man sikandan no nakaaha to tibo mgo hinang ni Jesus duon to Pista to Pagyaboy diya to siyudad to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Dajun pauli si Jesus diya to yunsud to Cana no duon din hinanga no inomon to diya wohig. Na, duon to yain no yunsud no og-ilingon to Capernaum meyduon upisyal to gubernu no nasakit to anak din no yukos. ");
INSERT INTO msmNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pagkadinog din no migtidow on si Jesus duon to Galilea no napuun diya to Judea, migpanow sikandin su ogdokaton din si Jesus aw ogdumahon diya to Capernaum agun no maulian din sikan bata no pakamatajon on. ");
INSERT INTO msmNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Pagpangamuju to sikan upisyal, nakaikagi si Jesus, “Ay, sikiyu no mgo otow, kona kow yagboy ogtuu kanay ko kona kow makakita to mgo milagru dow duma no mgo kabeynganan.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Sir,” kagi to sikan upisyal, “sadangay duma ka kanay kuntoon no buhi pad sikan anak ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Na,” kagi ni Jesus, “uli kad su migdojow on sikan anak nu.” Migtuu sikan upsiyal to kagi ni Jesus aw dajun panow. ");
INSERT INTO msmNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","No diya pad sikandin to pangindaenan, migtagbu to mgo suguonon din aw nangoni, “Naulian on to bata nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Dajun mig-usip sikan upisyal dow nokoy urasa to pagkaulii din. Migtabak sikandan, “Nabahaw sikandin gabii ala una to kahapunon.” ");
INSERT INTO msmNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Na, namaanan to sikan upisyal no naulian naan sikan bata to diya yagboy no uras no muikagi si Jesus no ogkaulian sikandin. Tongod to sikan, migtuu ki Jesus sikan upisyal hasta pamilya din. ");
INSERT INTO msmNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ikaduwa sikan no milagru no pighinang ni Jesus no mupauli sikandin to Galilea no napuun diya to Judea. ");
INSERT INTO msmNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pagkayugoy-yugoy on, mig-andiya on isab si Jesus to siyudad to Jerusalem su ogtambung to pista dan no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na, duon to sikan siyudad meyduon padigusanan no og-ilingon to Betsata to Hibru no inikagihan. Madani sikan duon to yawanganan no og-ilingon to Yawanganan to mgo Karneru. Duon to kilid to sikan wohig meyduon lima no ka hoyunganan ");
INSERT INTO msmNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","no pighibatan to mahan-in no mgo masakiton yakip to mgo buta, mgo pulid dow mgo pogkot. ");
INSERT INTO msmNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na, mey otow duon no nasakit sed on katluan-mey-wayu no tuig. ");
INSERT INTO msmNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pagkita ni Jesus kandin dow pagkamaani din no nayugoy da sikan no sakit, mig-usip sikandin, “Manuy, ogkaliyag ka no maulian ka?” ");
INSERT INTO msmNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Migtabak sikan masakiton, “Sir, wada duma ku no oghonat kanay pailing diya to wohig ko oglibwak on. Ogpaningkamot a podom to pag-anduon, di kona a pad ogpakaabut, mey on ogpakauna kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kagi ni Jesus, “Na, tindog ka. Daeha sikan hikam nu aw panow kad.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Dajun naulian sikan otow. Pigdae din sikan hikam din aw panow. Aedow to diya no Tigpahuway. ");
INSERT INTO msmNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Na, pagpanow to sikan otow, migsagman to inila no mgo Hibru, “Hoy, nokoy no migdawdaya ka man to hikam? Nakayapas ka to balaod su Aedow man kuntoon no Tigpahuway.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Di migtabak sikan otow, “Sikan nakauli kanay iyan mig-iling, ‘Daeha sikan hikam nu aw panow kad.’” ");
INSERT INTO msmNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Dajun usip sikan mgo inila, “Hintawa man otawa sikan migsugu ikow to pagdae to hikam nu aw to pagpanow?” ");
INSERT INTO msmNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Di sikan otow no naulian wada kamaan dow hintawa sikan nakauli kandin, su mahan-in to mgo otow no migdadasok aw puli on pigboyong si Jesus duon. ");
INSERT INTO msmNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pagkahina-hina, pigkita ni Jesus duon to Bayoy to Diyus sikan otow no naulian. Dajun din ikagihi, “Oho, naulian kad on. Na, kona kad ogpadajun to pagpakasae su unu ko ogdugang pad to kadoot to ogkahitabu ikow.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dajun panow sikan otow aw nangoni to inila no mgo Hibru no si Jesus naan to nakauli kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kaling sugud to diya no panahon, naningkamot to inila no mgo Hibru to pagdoot ki Jesus su mayapason kun sikandin to Aedow no Tigpahuway. ");
INSERT INTO msmNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Di pig-ikagihan sikandan ni Jesus, “To Amoy ku kona yagboy ogsigkon to pagtrabahu agun no matabangan to mgo otow, aw siak isab ogpadajun to pagtrabahu.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tongod to sikan pig-ikagi ni Jesus, migdugang pad to pagpaningkamot to sikan mgo inila to pagpahimatoy kandin, kona no tongod da to pagyapas din kun to Aedow no Tigpahuway di su migpagsokod isab sikandin to Diyus, su mig-iling no Amoy din to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kagi ni Jesus kandan, “Indani now seini. Wada ogkahimu ku to kanay kaugalingon no pagboot, su inggad nokoy no ogkitaon ku no oghinangon to Amoy ku iyan da isab oghinangon ku no Anak din. ");
INSERT INTO msmNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pighigugma a yagboy to Amoy ku, kaling igpakita din kanay to tibo oghinangon din. Di yabow pad to igpakita din kanay diya to umaabut no panahon agun ogkatingaya kow. ");
INSERT INTO msmNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Su ogbanhawon to Amoy ku to mgo patoy aw ogbogajan to kinabuhi. Siak isab no anak din, ogbogajan ku to kinabuhi to inggad hintawa no ogkaliyagan ku ogbogajan. ");
INSERT INTO msmNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aw to Amoy ku kona no iyan oghukum su imbogoy din on kanay sikan no katongod ");
INSERT INTO msmNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","agun no mapasidonggan a to tibo kaotawan angod to pagpasidongog dan kandin. Inggad hintawa no kona ogtahud kanay no Anak kibali kona ogtahud to Amoy ku no migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ligdongi now seini. Inggad hintawa no ogpaminog to kagi ku aw tuu to Diyus no migpaandini kanay mey on kinabuhi no wada katapusan. Konad on ogkastiguhon su nakayopa on likat to kamatajon pailing diya to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Paminog kow to seini. Sikan pigpaabut no panahon mig-abut on, no sikan nangkasakup pad to kamatajon ogdinog to kagi ku no Anak to Diyus aw ogkabuhi da. ");
INSERT INTO msmNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","To Amoy ku iyan ogkapuunan to kinabuhi no wada katapusan, aw angod da isab kanay no Anak din su pigbogajan a din to katongod to pagbogoy to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pigbogajan a din isab to katongod to paghukum su sikan to katongdanan ku isip Anak to Otow. ");
INSERT INTO msmNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Kona kow ogkatingaya to seini ingnangon ku iyu, su mey aedow no to tibo nangkamatoy ogdinog to pagsabi ku kandan, ");
INSERT INTO msmNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","aw ogbanhawon da sikandan tibo. To diya madojow to mgo hinang ogbanhawon agun ogkabogajan to kinabuhi no wada katapusan, di to diya madoot to mgo hinang ogbanhawon agun pahamtangan to kastigu. ");
INSERT INTO msmNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Wada ogkahimuan ku to kanay kaugalingon no pagboot. Ko muhukum a, matarong sikan no paghukum su kona ku ogtumanon to kaugalingon ku no pagboot ko kona no pagboot to sikan migpaandini kanay. Su ing-anad din kanay to hustu no paghukum. ");
INSERT INTO msmNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ko siak da to ogkistigus bahin to kanay kaugalingon, kona a ogkatuuhan. ");
INSERT INTO msmNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Di meyduon yain no ogmatuud to og-ikagihon ku. To Amoy ku iyan kistigus ku, aw namaan a no ogkatuuhan to pagkistigus din. ");
INSERT INTO msmNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Meyduon pad isab sobuuk no migkistigus bahin kanay. Su to diya pagsugu now to mgo sakup now diya ki Juan no Magbawtismuhay, mig-ikagi sikandin to matuud bahin kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Kona a hinuun ogsalig to pagkistigus to otow. Puli ku igpadomdom iyu to diya agun no mayuwas kow. ");
INSERT INTO msmNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Angod sikandin to maintok no soga no migtang-ow iyu, aw nalipay kow to diya ing-anad din sed to majopot da no panahon. ");
INSERT INTO msmNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Di meyduon yabow pad ki Juan no ogkistigus bahin kanay. Su to impamahinang kanay to Amoy ku iyan ogpakiyaya no Diyus yagboy to migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hasta mismu to Amoy ku no migpaandini kanay migkistigus isab. Di wada kow kita kandin aw wada kow makadinog to tingog din. ");
INSERT INTO msmNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Namaan a no wada now ibotang duon to ginhawa now to kagi din su wada kow man tuu kanay no pigpaandini din. ");
INSERT INTO msmNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ogpaomot kow iyan to pagsiksik to Kasuyatan to Diyus, su nailing to boot now no ogpakaangkon kow to kinabuhi no wada katapusan pinaagi to sikan. Siak to pighisgutan duon, ");
INSERT INTO msmNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","di ogmaojow kow gihapun ogpasakup kanay agun igkabogoy ku podom iyu sikan ogkaliyagan now no kinabuhi.” ");
INSERT INTO msmNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Migpadajun si Jesus to pag-ikagi to sikan inila no mgo Hibru, “Wada a kinahangyan no sajaon a to mgo otow ");
INSERT INTO msmNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","su namaan a iyu. Wada now ibotang to Diyus duon to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","To Amoy ku no Diyus iyan yagboy migpaandini kanay, di wada a now gihapun dawata. Di ko mey yain no ogpatuu-tuu no yabow sikandin, iyan nasi ogdawaton now. ");
INSERT INTO msmNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Og-amonuhon now man to pagtuu dow pagsalig to Diyus ko iyan da gustu now no sajaon kow to mgo duma now? Iyan wada now paningkamoti no masaja kow to sikan sobuukon no Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Di kona kow oghona-hona no siak to ogriklamu iyu duon to atubangan to Diyus. Si Moises no pigsaligan now iyan ogriklamu iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Su ko tinood pa no migtuu kow kandin, ogtuu kow isab podom kanay, su bahin man kanay to diya pigsuyat din no pigtagonan now. ");
INSERT INTO msmNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Di manno wada now tuuhi to diya sinuyat ni Moises, og-amonuhon now man to pagtuu to kagi ku iyu?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Songo aedow, migyopa onsi Jesus to danow to Galilea no og-ilingon isab to danow to Tiberias. ");
INSERT INTO msmNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mahan-in hilabi to mgo otow no migliput su ogyupug kandin diya to dibayuy no higad, su naaha dan to mgo milagru no nangkahinang din duon to mgo otow no nangkasakit. ");
INSERT INTO msmNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pagduung onni Jesus, miggamat sikandan to bubungan aw paman-ingkud duon. ");
INSERT INTO msmNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na, to diya no panahon, madani on to Pista to Pagyaboy. ");
INSERT INTO msmNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pagtonggak ni Jesus, naaha din sikan mahan-in hilabi no mgo otow no ogpadodoyog duon kandin. Dajun din ikagihi si Felipe, “Andei ki man ogpakaboli to igpakoon ta to suja mgo otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pig-iling ni Jesus to sikan su ogtogkadon din si Felipe. Di tahan din on namaanan dow nokoy to oghinangon din. ");
INSERT INTO msmNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Migtabak si Felipe, “Inggad pad kay libu-libu to iboli ta to pan, kona sikandan ogyogoban inggad tag-songo pingu da.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Na, si Andres no songo inanad ni Jesus no suun ni Simon Pedro mig-ikagi ki Jesus, ");
INSERT INTO msmNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Meyduon bata kani no migdae to lima no buuk no pan dow daduwa no ka isda. Di og-amonu man seini to sikan linibu no mgo otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Dajun ikagihi ni Jesus to mgo inanad din, “Pamaingkuda sikan mgo otow.” Na, naman-ingkud sikandan duon to sikan mayow-ag no kabagnotan. Lima no libu sikandan duon ko mgo yukos da to bilangon. ");
INSERT INTO msmNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Pigdawat ni Jesus sikan pan aw pasalamat sikandin to Diyus. Dajun din panibaga aw ipabogoy duon to sikan mgo otow. Pigpanibag din isab sikan isda aw nabogajan sikandan kotob to gustu dan su migdogi hilabi sikan pan dow isda. ");
INSERT INTO msmNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Pagkahantoy dan on tibo, pig-ikagihan ni Jesus to mgo inanad din, “Na, himuna now to mgo sama agun wada ogkauyakan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Dajun dan panghimuna to sama no pan, aw kaponu to sampuyu-tag-duwa no ayat! ");
INSERT INTO msmNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pagkita to sikan mgo otow to milagru no pighinang ni Jesus, nakaikagi sikandan, “Seini naan to diya gamhanan no otow no ogpaandinihon to Diyus!” ");
INSERT INTO msmNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pagkamaan ni Jesus no ogpogoson dan sikandin no oghinangon no hari dan, migpapaawoy sikandin diya to kabubunganan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","No mahapun on, migtogbang to mgo inanad ni Jesus duon to higad to danow. ");
INSERT INTO msmNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pagkadukilom on no wada pad tidow si Jesus, puli on sikandan migsakoy to bangka aw likat padeg diya to yunsud to Capernaum. ");
INSERT INTO msmNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Di wada kayugoy mig-aslag to mgo bayod tongod to kaagbot to kaemag. ");
INSERT INTO msmNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Na, anoy man no makagaud on sikandan to mgo lima no kilumitru, pigkita dan si Jesus no ogpadodoyog duon kandan no migpanow duon to babow to wohig. Hilabi sikandan pigdaitan, ");
INSERT INTO msmNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","di dajun migtawag si Jesus, “Kona kow ogkahaedok su siak seini.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nalipay sikandan no migpasakoy ki Jesus. Pagkasakoy din on, dajun sikandan nakatidow diya to ogdeygan dan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Pagkabukas, duon pad to dihipag to danow sikan mgo otow no pigpakoon ni Jesus tapus din pasalamati to diya pan. Migtagad sikandan ki Jesus su nadomdoman dan no wada sikandin makasakoy duma to mgo inanad din, aw wadad yain no bangka no ogkasakajan din. Wada kayugoy meyduon mgo sakajan likat to yunsud to Tiberias no migduung duon to dani dan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na, pagkamaan dan no wadad si Jesus duon hasta to mgo inanad din, migsakoy sikandan to sikan mgo sakajan no bag-u duung. Migyopa sikandan pailing diya to yunsud to Capernaum su diya dan ogpamanghaon si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pagtidow to sikan mgo otow diya to Capernaum, natae-an dan si Jesus aw usipa dan, “Sir, kagan-u ka pad man makaandini?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Dajun tabak si Jesus, “To tinood, iyan igpamanghaa now kanay kuntoon su nahantoy kow to diya impakoon ku iyu. Di wada now yagboy sabuta to diya milagru no pighinang ku gabii. ");
INSERT INTO msmNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kona now ogpayabihon to pagpamangha to koonon no ogkadunut da. Iyan nasi paningkamotan now to koonon no kona ogkadunut no ogkapuunan to kinabuhi no wada katapusan. Siak no Anak to Otow iyan ogbogoy iyu to sikan no koonon su pigbogajan a to Amoy ku no Diyus to katongod.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Dajun dan ikagihi si Jesus, “Nokoy man to ogpaningkamotan noy agun makatuman koy to kagustuhon to Diyus?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Pigtabak sikandan ni Jesus, “Seini to igpahinang iyu to Diyus. Kinahangyan no mutuu kow kanay no pigpaandini din.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Mig-usip isab sikandan, “Nokoy man to milagru no igpakita nu kanami agun makatuu koy ikow? Su notoduon no diya to mgo kaaw-apuan ta to matahay no banwa no pinanguyuhan ni Moises, namangoon sikandan to sikan og-ilingon to mana. Su pig-iling duon to Kasuyatan to Diyus, ‘Pigbogajan din sikandan to koonon no napuun to yangit.’ Na, sikuna,” kagi dan ki Jesus, “nokoy man to oghinangon nu no ogpakaangod to diya?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Kagi ni Jesus, “Paminogi a now su matuud yagboy seini ig-ikagi ku iyu. Kona no si Moises to migbogoy to mgo kaaw-apuan ta to diya koonon no napuun diya to yangit. Diyus to migbogoy. Aw sikandin to ogbogoy iyu kuntoon to tinood no koonon no ogkapuun diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Su sikan og-ilingon to koonon no imbogoy to Diyus iyan sikan napuun diya to yangit no ogbogoy to kinabuhi diya to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pagkadinog to mgo otow to sikan pig-ikagi ni Jesus, mighangyu sikandan, “Sir, bogaji koy to sikan no koonon kada aedow.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Kagi ni Jesus, “Siakon sikan koonon no ogkapuunan to kinabuhi no wada katapusan. Inggad hintawa no ogpasakup kanay konad on ogbontason. Inggad hintawa no ogtuu dow ogsalig kanay konad on og-uhawon. ");
INSERT INTO msmNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Di pignangonan kud sikiyu no inggad nakakita kow on kanay, wada a now gihapun tuuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","To tibo kaotawan no igsalig to Amoy ku kanay og-andini kanay. Aw inggad hintawa no ogpasakup kanay kona ku ogbalibadon. ");
INSERT INTO msmNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Su wada a andini to pagtuman to kanay pagboot. Iyan ing-andini ku likat to yangit to pagtuman to pagboot to Amoy ku no iyan migsugu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","40","Iyan pagboot din no bantajan ku to tibo kaotawan no insalig din kanay agun wada ogkayagak, aw ogbanhawon ku sikandan diya to katapusan no aedow. Su ogkaliyag sikandin no to tibo ogpaminog aw ogtuu kanay ogbogajan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pagdinog to inila no mgo Hibru to sikan pig-ikagi ni Jesus no sikandin to koonon no napuun diya to yangit, migbagutbut sikandan ");
INSERT INTO msmNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","aw pauusipay, “Eh, kona no si Jesus man seini no anak ni Jose? Kiyaya ta man to amoy dow inoy din. Na, nokoy no ogpatugu man to pag-angkon no diya sikandin kapuun to yangit?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kagi ni Jesus kandan, “Kona kow on ogbagutbut. ");
INSERT INTO msmNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wada ogpakapasakup kanay ko kona unahon tawagon to Amoy ku no migpaandini kanay. Aw to ogpasakup kanay ogbanhawon ku diya to katapusan no aedow. ");
INSERT INTO msmNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Meyduon sinuyat to otow no kibali ba-ba to Diyus no pig-iling, ‘Tibo sikandan og-anadon to Diyus.’ Na, inggad hintawa no ogpaminog to Amoy ku no Diyus dow ogpaanad kandin, sikandin to og-andini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kona no iyan igpasabut ku no meyduon nakakita to Diyus no Amoy ku, su wada yagboy nakakita kandin ko kona no siak da no diya kapuun kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Indani now seini. To otow no ogtuu dow ogsalig kanay meyduon kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Siakon sikan koonon no ogkapuunan to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","To mgo kaaw-apuan ta migkoon to mana no makapanow-panow sikandan diya to matahay no banwa. Di namatoy gihapun sikandan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Di yahi seini no koonon kuntoon no napuun diya to yangit, su to otow no ogkoon to seini ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Siakon sikan koonon no napuun diya to yangit no iyan ogkapuunan to kinabuhi. Inggad hintawa no ogkoon to sikan, wada katapusan to kinabuhi din. Sikan no koonon, yawa ku no igbogoy ku agun ogkabogajan to kaotawan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dajun yayalis sikan inila no mgo Hibru. Kagi dan, “Og-amonuhon man to sikan no otowa to pagbogoy ita to yawa din agun koonon ta?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kaling pig-ikagihan sikandan ni Jesus, “Paminogi a now su matuud yagboy seini ig-ikagi ku iyu bahin kanay no Anak to Otow. Ko kona kow mukoon to yawa ku aw ko kona kow isab muinom to yangosa ku, kona kow ogpakaangkon to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inggad hintawa no ogkoon to yawa ku dow og-inom to yangosa ku ogbogajan to kinabuhi no wada katapusan, aw ogbanhawon ku sikandin diya to katapusan no aedow. ");
INSERT INTO msmNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Su to yawa ku iyan matuud no koonon, aw to yangosa ku iyan matuud no inomon su ogpakabogoy to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inggad hintawa no ogkoon to yawa ku aw og-inom to yangosa ku ogpakamonang dini kanay, aw siak ogpakamonang duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ogkabuhi a tongod to Amoy ku no migpaandini kanay su sikandin to ogkapuunan to kinabuhi. Ogkaangod isab to sikan to otow no ogkoon kanay su ogkabuhi tongod kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Seini koonon no napuun diya to yangit no pighisgutan ku kona no angod to diya pigkoon to mgo kaaw-apuan ta, su namatoy gihapun sikandan. Di inggad hintawa no ogkoon to seini no koonon ogbogajan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sikan to ing-anad ni Jesus duon to simbahan to mgo Hibru diya to yunsud to Capernaum. ");
INSERT INTO msmNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pagdinog to mgo sumusunud ni Jesus to sikan ing-anad din, mahan-in sikandan no migbagutbut. Kagi dan, “Subra on sikan no pagpang-anad din. Konad on ogkatuuhan.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Namaanan ni Jesus no migbagutbut sikandan, kaling pig-usip din, “Nadootan kow naan to diya? ");
INSERT INTO msmNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Na, ogkaamonu man buwa ko kitaon a now no Anak to Otow no ogbatunon diya to yangit no napuunan ku? ");
INSERT INTO msmNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","To Ispiritu Santu iyan ogpakabogoy to kinabuhi no wada katapusan. Kona sikan ogkahimu pinaagi to ogkaunagan to otow. Sikan ing-anad ku iyu duon kapuun to Ispiritu Santu, kaling sikandin to ogpakabogoy iyu to kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Di to duma iyu kona ogtuu kanay.” Pig-ikagi ni Jesus sikan su tahan din on namaanan likat pad to sinugdanan to diya kona ogtuu kandin aw to diya ogyuib kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Migpadajun si Jesus to pag-ikagi, “Kaling pignangonan ku sikiyu no wada ogpakapasakup kanay ko kona sikandin tugutan to Amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na, sugud to diya no panahon, mahan-in to mgo sumusunud ni Jesus no migtalikud on kandin aw wadad on duma. ");
INSERT INTO msmNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Paglikat dan on, pig-ikagihan ni Jesus sikan sampuyu-tag-duwa no mgo inanad din, “Na sikiyu, ogtalikud kow isab kanay?” ");
INSERT INTO msmNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Si Simon Pedro to migtabak, “Ginuu, hintawa pad on man to ogkapasakupan noy no duon da man ikow to mgo kagi no ogpakabogoy to kinabuhi no wada katapusan? ");
INSERT INTO msmNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Migtuu koy ikow, aw namaan koy no sikuna da yagboy to diya Balaan no pigpaandini to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Kagi ni Jesus, “Pigpili ku sikiyu no sampuyu-tag-duwa, di sobuuk iyu, sakup ni Satanas.” ");
INSERT INTO msmNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Sikan no kagi ni Jesus, iyan pig-igu din si Judas no anak ni Simon Iscariote. Su sobuuk iyan si Judas to sikan sampuyu-tag-duwa no mgo inanad ni Jesus, di og-abut to panahon no ogyuiban din si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tapus to sikan, migpadajun si Jesus to pagpanow pailing diya to yain-yain no mgo yunsud duon to prubinsya to Galilea. Wada sikandin andiya to prubinsya to Judea su to inila no mgo Hibru oghimatoy podom kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","No madani on to pista to mgo Hibru no og-ilingon to Pista to mgo Pipinajag, ");
INSERT INTO msmNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","to mgo suun ni Jesus mig-ikagi kandin, “Madojow podom ko ojowan nu seini no banwa aw andiya ka to Judea agun makaaha to mgo sumusunud nu to mgo milagru no oghinangon nu. ");
INSERT INTO msmNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Su ko ogkaliyag to otow no mabantugan, kona din ighobong to oghinangon din. Kaling ko oghinang ka to mgo milagru, madojow podom ko ipakita nu diya to atubangan to tibo.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Pig-ikagi dan sikan su sikandan ngani no mgo suun ni Jesus wada man tuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kaling pig-ikagihan sikandan ni Jesus, “Wada pad abut to panahon ku. Di sikiyu, ogpakaandiya kow inggad kagan-u ");
INSERT INTO msmNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","su kona kow man ogkuntrahon to kaotawan. Di siakon, ogkuntrahon a dan su ogkaukisan ku to madoot no mgo hinang dan. ");
INSERT INTO msmNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Na, una kow on diya to Jerusalem aw pamista kow. Kona a pad og-andiya su wada pad abut to panahon ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kaling migpakamonang naa sikandin duon to Galilea. ");
INSERT INTO msmNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Di pagkalius to mgo suun din no ogpamista, mig-andiya isab si Jesus, di wada sikandin pakita. ");
INSERT INTO msmNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Diya to pista, migbabangan ki Jesus to inila no mgo Hibru. Kagi dan, “Andei man buwa to diya no otawa?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","To kaotawan isab namanhahagas bahin ki Jesus. Mey naman-iling, “Madojow sikandin no otow.” Mey duma no naman-iling, “Kona, su ogpanlimbung sikandin to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Di mananoy da to paggigilaung dan bahin ki Jesus su nahaedok sikandan to inila no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pagpanonga-tonga on to pista, bali man no migyogwa si Jesus diya to Bayoy to Diyus aw pang-anad to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hilabi natingaya to inila no mgo Hibru. Kagi dan, “Andei man buwa kapuun sikan kaalam din no obos da man podom to gradu din?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Migtabak si Jesus, “Seini igpang-anad ku kona no kanay, di diya kapuun to sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inggad hintawa no ogkaliyag ogtuman to pagboot to Diyus ogkamaan no napuun yagboy to Diyus seini impang-anad ku, aw kona no kanay puli. ");
INSERT INTO msmNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","To otow no ogpang-ikagi to ogkapuun to kandin panghona-hona ogpayabow-yabow puli. Di to otow no ogpaningkamot to pagpasidongog to sikan migsugu kandin, ogkamaanan ta no ogkatuuhan aw kona sikandin no gayuon. ");
INSERT INTO msmNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sikiyu to pigbogajan ni Moises to mgo balaod to Diyus, di wada sobuuk iyu no nakatuman to sikan. Na, nokoy no gustu kow man oghimatoy kanay?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sikan mgo otow no nahimun migtabak, “Pigbuang ka kay buwa to madoot no ispiritu. Hintawa man to oghimatoy ikow?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kagi ni Jesus, “Sobuuk da to pighinang ku no milagru to diya una duon to Aedow no Tigpahuway, di nadootan kow on. ");
INSERT INTO msmNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Di sikiyu meyduon isab oghinangon now duon to sikan no aedow. Su migsugu si Moises no tulion to mgo anak now no yukos duon to ikawayu no aedow likat to pag-anak. (Di to tinood, tahan on sikan sugud pad to kaaw-apuan din.) Kaling ogtumanon now sikan no tumanon inggad makatapu to Aedow no Tigpahuway. ");
INSERT INTO msmNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Na, ko igpatuli now to mgo anak now inggad duon to Aedow no Tigpahuway agun kona mayapas sikan balaod ni Moises, nokoy no naboyu kow man kanay su nadojow ku to diya masakiton duon to Aedow no Tigpahuway? ");
INSERT INTO msmNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Kona kow dajun oghukum to duma now pinasikad to una no ogkaaha now. Di nasi no susihon now to matuud.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Na, migpaiikagihay to duma no mgo taga-Jerusalem, “Sikandin kay kunu to diya otow no oghimatajan podom to mgo inila ta. ");
INSERT INTO msmNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Na, nokoy no kona dan man sikandin ogsapadan no ogpang-ikagi kani to atubangan to kaotawan? Basi kay namaan sikandan no sikandin to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Di kona buwa no iyan, su ko muabut sikan Insaad no Manyuyuwas, wada ogkataga dow taga-andei sikandin. Di sikan no otowa, namaanan ta dow taga-andei.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pagdinog ni Jesus to sikan, mig-ikagi sikandin to maagbot duon to pawa to Bayoy to Diyus, “Tutuu iyan no pigkiyaya a now aw namaanan now dow taga-andei a. Di wada now kamaani dow andei a yagboy kapuun. To pag-andini ku kona no kanay no pagboot su meyduon migsugu kanay, aw tinood yagboy sikandin. Wada kow kiyaya kandin ");
INSERT INTO msmNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","di siak, migkiyaya a su diya a kapuun, aw sikandin to migsugu kanay to pag-andini.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pag-ikagi ni Jesus to sikan, ogdakopon podom sikandin to inila no mgo Hibru, di wada dan katoodi su wada pad abut to panahon din. ");
INSERT INTO msmNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Di mahan-in to mgo otow duon no migtuu dow migsalig ki Jesus. Kagi dan, “Seini iyan to diya Insaad no Manyuyuwas, su wada otow no ogpakahinang to milagru no ogyabow to sikan nangkahinang din.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pagdinog to duma no mgo Pariseo to sikan pighahagasan to mgo otow bahin ki Jesus, sikandan dow to yabow no mgo magdudumaya to tinuuhan to mgo Hibru migsugu to mgo magbantajay duon to Bayoy to Diyus to pagdakop ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kaling pig-ikagihan ni Jesus to kaotawan no nahimun duon, “Konad ogkayugoy to pagpagduma ku iyu, su og-uli ad diya to sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ogpamanghaon a now, di kona a now on ogkakitaan. Kona kow isab ogpakaduma diya to ogdeygan ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","36","Dajun pauusipay to inila no mgo Hibru, “Nokoy man buwa to igpasabut to sikan pig-ikagi din no ogpamanghaon ta sikandin di kona tad ogkakitaan, aw kona ki ogpakaduma diya to ogdeygan din? Na, andeid man buwa ogdeg sikan no otawa no kona tad man ogkakitaan? Basi og-andiya to madiyu no mgo banwa no pig-ugpaan to mgo kadumahan ta no namanyampot. Basi ogpang-anadon din to mgo taga-diya no kona no Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Duon to katapusan no aedow to sikan pista no iyan yabi no mahinongdanon no aedow, migtindog si Jesus aw ikagi to maagbot, “Inggad hintawa iyu no og-uhawon, umandini kanay su ogpainomon ku. ");
INSERT INTO msmNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Su ojow pa to Kasuyatan to Diyus, to otow no ogtuu dow ogsalig kanay, angod to mey wohig no ogpakabuhi no og-ugwak duon to ginhawa din.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Sikan wohig no ognangonon ni Jesus, impananglit din to Ispiritu Santu no igkabogoy to tibo kaotawan no ogtuu kandin. Di to diya no panahon, wada pad ibogoy to Ispiritu Santu duon kandan su wada pad man batuna si Jesus diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pagdinog to mgo otow to sikan impang-anad ni Jesus, to duma mig-iling, “Sikandin naan to diya kibali ba-ba to Diyus no pigpaabut ta.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mey isab duma no mig-iling, “Sikandin to diya Insaad no Manyuyuwas.” Di mey pad duma no mig-iling, “Kona ta ogkailing no sikandin to diya Insaad no Manyuyuwas, su taga-Galilea man sikandin. ");
INSERT INTO msmNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Su ojow pa to Kasuyatan to Diyus, sikan Insaad no Manyuyuwas ogkailing no kaliwat ni Hari David, aw duon sikandin ogkapuun to Betlehem su taga-duon man si David.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kaling nabahin to mgo otow bahin ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","To duma isab gustu podom no ogdakopon sikandin, di wada inggad sobuuk no nakahilabot kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na, pagpauli to diya mgo magbantajay no pigsugu to pagdakop ki Jesus, pig-usip sikandan to diya mgo Pariseo dow yabow no mgo magdudumaya to tinuuhan no migsugu kandan, “Nokoy no wada now man sikandin kadaya?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Migtabak sikan mgo magbantajay, “Disti on ko mey nang-anad no angod to pagpang-anad to sikan no otow.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Eh,” kagi to sikan mgo Pariseo, “hasta isab sikiyu nalimbungan din? ");
INSERT INTO msmNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oho, sikami no mgo Pariseo dow duma no inila no mgo Hibru, wada inggad sobuuk kanami no migtuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Iyan da namanuu kandin to mgo otow no wada yagboy makasabut to sikan mgo balaod to tinuuhan ta. Kastiguhonon sikandan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na, sobuuk kandan si Nicodemo no iyan migdoyom diya ki Jesus. Pig-ikagihan din to mgo duma din, ");
INSERT INTO msmNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ojow pa to sikan mgo balaod ta, ogkahimu buwa to paghukum to otow no kona og-unahon og-usipon agun mamaanan yagboy dow nokoy to nahinang din?” ");
INSERT INTO msmNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Kagi to sikan angod din no mgo Pariseo, “Abee, taga-Galilea ka naan isab? Ko siksikon nu to Kasuyatan to Diyus, ogkamaanan nu no wada yagboy taga-Galilea no ogkahinang no kibali ba-ba to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Dajun likat sikandan tibo aw paman-uli, ");
INSERT INTO msmNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","di si Jesus mig-andiya to Kaulibuhan no bubungan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Pagkabukas, migpauli sikandin duon to Bayoy to Diyus, aw mahan-in hilabi to mgo otow no mighagudhud duon kandin. Dajun sikandin ingkud aw pang-anad kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Pagpang-anad din on, mey mgo maistru to tinuuhan dow mgo Pariseo no mig-anduon no migdae to bohi no nasakpanan dan no nanghonay. Pigpaatubang dan sikandin to sikan nangkahimun ");
INSERT INTO msmNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aw ikagihi dan si Jesus, “Sir, seini no bohi nasakpanan no nanghonay. ");
INSERT INTO msmNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ojow pa to balaod no imbilin ni Moises ita, to bohi no angod to seini kinahangyan batuhon kotob no mamatoy. Na sikuna, nokoy man to ikow?” ");
INSERT INTO msmNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ing-usip dan sikan su ogbitikon dan podom sikandin agun no meyduon igkariklamu dan kuntra kandin. Di puli migpatiobo si Jesus aw isuyat to tudyu din duon to pasak. ");
INSERT INTO msmNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","No wada dan sigkoni to pagpangusip kandin, migtindog si Jesus aw ikagi, “Ko hintawa kani iyu to wada sae, paunaha to pagbatu kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na, mig-isab migpatiobo si Jesus aw isuyat to tudyu din duon to pasak. ");
INSERT INTO msmNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pagdinog to sikan inila no mgo Hibru to sikan pig-ikagi ni Jesus, dajun sikandan tinagsaboka to pagpakukujunus to pagpanow. Iyan mig-una to kinamanigaonan duon kandan, aw migpatisunu to mgo duma kotob no iyan nanda nabilin si Jesus dow sikan bohi. ");
INSERT INTO msmNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Dajun tindog si Jesus aw usipa din sikan bohi, “Andeid man to kani mgo otow no mighukum ikow?” ");
INSERT INTO msmNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Migtabak sikan bohi, “Wadad Sir.” Kagi ni Jesus, “Na, kona a isab oghukum ikow. Uli kad on, di kona kad on oghinang to sae.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tapus to sikan, pig-ikagihan ni Jesus to mgo otow, “Siakon to kaawang no ogtang-ow to kaotawan dini to kalibutan. Inggad hintawa no ogpasakup kanay, wadad on sikandin ugpa duon to kadigyoman, su ogkatang-awan on to sikan kaawang no ogpakabogoy to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Di to mgo Pariseo migpagyalis kandin. Kagi dan, “Kona ogkatuuhan sikan pig-ikagi nu su sikuna da to ogkistigus to ikow no kaugalingon.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Migtabak si Jesus, “Inggad ogkistigus a to kanay no kaugalingon, tinood gihapun sikan pig-ikagi ku su namaan a dow taga-andei a dow andei a ogdeg. Di sikiyu, wada kow kamaan to sikan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ko oghukum kow, puli now og-otawan. Siakon, wada oghukuman ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Di ko pananglit muhukum a, hustu to hukum ku su kona no siak da to oghukum su duma ku sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Su ojow pa to sikan balaod no pigtagonan now, ko maaangod to pagkistigus to daduwa no ka otow, ogkatuuhan sikan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na, tuuhi now isab no tutuu to ing-anad ku su daduwa to mgo kistigus ku, siakon dow Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Dajun usip to inila no mgo Hibru, “Andei man sikan amoy nu?” Migtabak si Jesus, “Wada kow yagboy kiyaya kanay aw wada kow isab kiyaya to Amoy ku. Su ko pigkiyaya a now pa, ogkakiyayahan now isab podom to Amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sikan to pig-ikagi ni Jesus no mang-anad sikandin diya to Bayoy to Diyus duon to dani to taguanan to halad. Mahan-in to ogpamandakop podom ki Jesus to sikan no panahon, di wada dan katoodi su wada pad abut to panahon din. ");
INSERT INTO msmNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Migpadajun si Jesus to pagpang-anad to mgo otow no nahimun duon. Kagi din, “Madani ad on ogpanow. Inggad pamanghaon a now, kona a now ogkitaon su kona kow ogpakaduma diya to ogdeygan ku. Puli kow on ogkamatoy, kona ogkapasaylu to mgo sae now.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Dajun pauusipay sikan inila no mgo Hibru, “Nokoy man to igpasabut to sikan pig-iling din no kona ki ogpakaduma diya to ogdeygan din? Og-ogot kay buwa sikandin!” ");
INSERT INTO msmNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kagi ni Jesus, “Sakup kow to seini pasak, di siakon, sakup a to yangit. Kona ogkaaangod to panghona-hona ta. ");
INSERT INTO msmNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kaling pig-ikagihan kud on sikiyu no puli kow on ogkamatoy, kona ogkapasaylu to mgo sae now. Sikan to ogkadeygan now ko kona kow ogtuu to sikan tibo pig-ikagi ku bahin to kaugalingon ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nangusip sikandan ki Jesus, “Na, hintawa ka man yagboy?” Migtabak si Jesus, “Siakon to diya kanunoy kud ingnangon iyu sugud pad to sinugdanan to pagpang-anad ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Bahin iyu, mahan-in pad podom to igkahukum ku, di iyan da ignawnangon ku diya to kaotawan to nadinog ku duon to sikan migpaandini kanay. Aw matuud yagboy to tibo no og-ikagihon din.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Di sikan mgo otow duon wada makasabut no iyan ognangonon ni Jesus to Amoy din no Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kaling pig-ikagihan sikandan ni Jesus, “Ko siak no Anak to Otow itaud now on duon to krus aw lindoga, bali man no ogkamaan kow on no tutuu yagboy to tibo pig-ikagi ku bahin to kaugalingon ku. Ogkamaanan now isab no wada ogbugtungan ku no hinang, su iyan da igpang-anad ku to insugu to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sikandin to migsugu kanay, aw kona a din og-ojowan. Kanunoy a din ogduma-dumahan su ogtumanon ku to ogkaliyagan din.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","No mig-ikagi pad si Jesus, mahan-in on to migtuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Dajun ikagihi ni Jesus to diya namanuu kandin, “Ko mupadajun kow to pagtuman to ing-anad ku, ogkahinang kow no matuud no mgo inanad ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ogkamaan kow isab to matuud bahin to Diyus, aw pinaagi to sikan, ogkayuwas kow to pagkaudipon.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Eh,” kagi dan, “nokoy no og-iling ka man no ogkayuwas koy? Wada koy kay kaudipon to inggad hintawa su mgo kaliwat koy man ni Abraham.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Migtabak si Jesus, “Indani now seini. Naudipon to tibo mgo otow no ogpadajun to pagpakasae, su to madoot no og-awoson dan iyan ogboot kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pananglit, to udipon kona no pirmaninti duon to pamilya to agayon din. Di to anak to sikan agayon pirmaninti duon. ");
INSERT INTO msmNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kaling, ko siak no Anak to Diyus iyan ogyuwas iyu, yuwas kow on yagboy to pagkaudipon. ");
INSERT INTO msmNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Namaan a no mgo kaliwat kow ni Abraham, di wada pues to sikan, su to diya ing-anad ku iyu wada now man ibotang duon to ginhawa now. Kaling gustu kow nasi no oghimatoy kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Siak to ogpasabut iyu to pigkita ku duon to atubangan to Amoy ku. Aw sikiyu isab, iyan oghinangon now to nadinog now duon to iyu no amoy.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Eh,” kagi dan, “si Abraham kay to amoy noy.” Kagi ni Jesus, “Ko kaliwat kow pa ni Abraham, ogsunudon now podom to diya mangkadojow no hinang din. ");
INSERT INTO msmNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Di anoy su nang-anad a iyu to matuud no impasabut kanay to Diyus, oghimatajan a now on nasi. Di wada hinang ni Abraham no angod to sikan. ");
INSERT INTO msmNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Iyan nasi ogsunudon now to mgo hinang to tinood now no amoy.” Migtabak dajun sikan mgo otow, “Hoy, kona koy kay no mgo anak to gawas. Iyan da Amoy noy to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Kagi ni Jesus, “Ko iyan pa amoy now to Diyus, oghigugmaon a now podom, su sikandin to napuunan ku, aw sikandin to migpaandini kanay. Wada a puli boboot to pag-andini. ");
INSERT INTO msmNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nokoy no kona kow man ogpakasabut ko og-ikagi a? Ogkailing to sikan su kona kow man ogkaliyag ogpaminog kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Si Satanas yagboy to amoy now, aw to mangkadoot no og-awoson din iyan ogkaliyagan now ogtumanon. Sugud pad to sinugdanan, nanghimatoy on sikandin. Wada yabot din to inggad nokoy no matuud, su ampan man matuud duon kandin. Iyan da hinang din to ogginayu su sikan to ingkaanat din. Gayuon yagboy sikandin aw ogkapuunan to tibo mgo gayu. ");
INSERT INTO msmNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Aw manno mgo sakup kow ni Satanas no gayuon, kona kow ogtuu to sikan matuud no mgo kagi ku. ");
INSERT INTO msmNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hintawa man iyu to ogpakakistigus no sae-an a? Di manno iyan igpang-anad ku to matuud, nokoy no kona kow man gihapun ogtuu kanay? ");
INSERT INTO msmNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Iyan kona now igpaminog kanay su kona kow man no kaning Diyus. Su to tibo matuud no mgo sakup to Diyus ogpaminog to kagi din.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Pagdinog to sikan inila no mgo Hibru to kagi ni Jesus, pig-ikagihan dan sikandin, “Tutuu iyan to diya pig-iling noy no angod ka to taga-Samaria, aw pigbuang ka isab to madoot no ispiritu.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kagi ni Jesus, “Wada madoot no ispiritu no migbuang kanay. Iyan da oghinangon ku to pagpasidongog to Amoy ku, di ogtamajon a now. ");
INSERT INTO msmNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kona no iyan og-apason ku no mapasidonggan a. Di to Diyus iyan ogboot to sikan, aw sikandin to oggapi kanay dow oghukum iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Indani now seini. Inggad hintawa no ogtuman to kagi ku kona gajod ogkamatoy.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Kagi to sikan inila no mgo Hibru, “Na, kuntoon nasiguru noy on no pigbuang ka to madoot no ispiritu. Ngani man si Abraham dow to diya kibali mgo ba-ba to Diyus, di tibo da nangkamatoy. Di sikuna, mig-iling ka no to otow no ogtuman to kagi nu kona gajod ogkamatoy. ");
INSERT INTO msmNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kibali og-iling ka no yabow ka pad ki Abraham dow to diya kibali mgo ba-ba to Diyus no tibo da nangkamatoy. Nokoy man to pagtuu nu ikow? Hintawa ka man?” ");
INSERT INTO msmNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Migtabak si Jesus, “Ko siak pa to ogpasidongog to kaugalingon ku, wada pues to sikan. Di to Amoy ku no og-angkonon now no Diyus now iyan ogpasidongog kanay, ");
INSERT INTO msmNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","di wada kow man ngani kiyaya kandin. Siakon nasi to migkiyaya yagboy kandin, aw ogtumanon ku to tibo igsugu din kanay. Ko og-iling a pa no wada a kiyaya kandin, ogkaangod a isab iyu no gayuon. ");
INSERT INTO msmNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Si Abraham no minuna now migtukhow su mig-iman no ogkitaon a din no og-andini to kalibutan. Tinood iyan no nakitaan a din, aw nalipay sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Kagi to sikan inila no mgo Hibru, “Tuu on man no pigkita nud on si Abraham, wada ka pad ngani abut to kalim-an no tuig!” ");
INSERT INTO msmNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Kagi ni Jesus, “Eh, tinood iyan. Su wada pad i-anak si Abraham, duon ad on.” ");
INSERT INTO msmNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Dajun sikandan pamandawat to batu su ogbatuhon dan si Jesus. Di migyunus sikandin migyuwas duon to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pagpanow ni Jesus, mey otow no pigkita din no ingkabata to pagkabuta. ");
INSERT INTO msmNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Dajun usipa si Jesus to mgo inanad din, “Sir, hintawa man sae to nakailing to pagkabuta to sikan otow sugud to pag-anak kandin? Kandin sae ko ginikanan din?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Migtabak si Jesus, “To pagkabuta din kona no tongod to sae din aw kona isab no tongod to sae to ginikanan din. Di iyan ingkabuta din agun no ogkakita to gahom to Diyus duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mintras aedow pad, kinahangyan no oghinangon ta to igpahinang ita to sikan migpaandini kanay. Ogpaomot ki su ko madukilom on, wadad ogpakatrabahu. ");
INSERT INTO msmNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kotob no dini a pad to kalibutan, siakon to kaawang no ogpakatang-ow to kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Dajun ilob si Jesus duon to pasak aw ohuga to yawoy din. Dajun din ihidhid duon to mata to sikan buta ");
INSERT INTO msmNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","aw ikagihi, “Na, pangiyam-us ka duon to sikan padigusanan no Siloe.” Dajun anduon sikan buta aw pangiyam-us duon to padigusanan no Siloe, no ko ita pa, Impadae. Pagpauli din, nakakita on sikandin. ");
INSERT INTO msmNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pagkita kandin to mgo sumbayoy din hasta to mgo otow no nakaaha kandin no migpalimus, naboyong sikandan aw paman-ikagi, “Iyan kay buwa sikan to diya kanunoy mig-iingkud duon no ogpalimus?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","To duma mig-iling, “Hoo, sikandin man iyan.” Di to duma mig-iling, “Eh, kona. Nakaangod puli to bayhu.” Di sikan otow no naulian mig-iling, “Siakon man iyan to diya buta.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Naamonu no nakakita ka man?” kagi to sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Migtabak sikandin, “Sikan otow no iyan ngadan si Jesus mig-ohug to pasak aw ihidhid to mata ku. Pagkatapus, pigpapangiyam-us a din diya to padigusanan no Siloe. Na, dajun ad nakakita.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nangusip sikan mgo otow, “Andeid man sikandin?” Di nangindoy sikan otow. ");
INSERT INTO msmNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dajun dan daeha diya to mgo Pariseo sikan buta no nadojow on. ");
INSERT INTO msmNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Na, Aedow no Tigpahuway to diya pag-ohug ni Jesus to pasak no piggamit din to pagpakita to sikan buta. ");
INSERT INTO msmNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kaling sikan mgo Pariseo mig-usip isab kandin dow naamonu no nakakita on man sikandin. Kagi to sikan otow, “Pighidhidan din to mata ku to inohug no pasak. Pagpangiyam-us ku, nakakita a dajun.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Migyayalis sikan mgo Pariseo. Kagi to duma, “Kona ogkailing no pigpaandini sikandin to Diyus, su ogyapason din man to Aedow no Tigpahuway.” Di mey isab mig-iling, “Ko sae-an pa sikan no otow, og-amonuhon din man to paghinang to mgo milagru no angod to sikan?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kaling pig-usip dan sikan otow, “Mig-iling ka no nadojow din to mata nu. Na, to paghona-hona nu, hintawa man sikandin?” Kagi din, “Kibali ba-ba sikandin to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Di sikan inila no mgo Hibru wada pad gihapun tuu no tahan sikandin buta. Kaling impadokat dan to mgo ginikanan din ");
INSERT INTO msmNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","aw usipa, “Anak now seini? Ingkaanat din iyan no buta? Nokoy no ogkita on man?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Migtabak sikan mgo ginikanan din, “Hoo, anak noy seini, aw ingkaanat din iyan no buta. ");
INSERT INTO msmNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Di wada koy kamaan dow naamonu no ogpakakita on sikandin kuntoon dow hintawa to nakadojow to mata din. Di madojow ko sikandin to usipon now su insaktu on man to idad din, aw ogpakatabak on sikandin to mgo usip now.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Sikan to tinabakan to mgo ginikanan din su nahaedok to sikan inila no mgo Hibru. Su tahan dan on naujunan no inggad hintawa no og-iling no si Jesus iyan sikan Insaad no Manyuyuwas konad on ogpakapagduma to angod din no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Na, dajun isaba tawaga to sikan mgo inila sikan otow no buta to diya una aw ikagihi, “Namaan koy no makasasaya to diya otow no nakadojow kun to mata nu. Na, ipanapa to ngadan to Diyus no ognangon ka to matuud.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Migtabak sikan otow, “Wada a kamaan dow makasasaya sikandin. Iyan da namaanan ku no buta a, di nakakita ad.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Pig-isab dan sikandin pig-usip, “Pig-amonu ka din no nakakita kad man?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Migtabak sikandin, “Pignangonan kud sikiyu di wada kow paminog. Nokoy no ogkaliyag kow isab ogpaminog to sikan? Basi ogpasakup kow isab kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Dajun dan pigbinusayan sikan otow. Kagi dan, “Hoy, sikuna, inanad ka to sikan no otawa, di sikami, mgo inanad koy ni Moises. ");
INSERT INTO msmNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Su namaan koy no pig-isturyahan si Moises to Diyus to diya una no panahon. Di sikan no otawa, wada koy ngani kamaan dow andei sikandin kapuun.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sikan otow no migkita on mig-iling, “Naboyong a yagboy iyu, su anoy nadojow din to mata ku, og-iling kow pad gihapun to wada kow kamaan dow andei sikandin kapuun. ");
INSERT INTO msmNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Di siakon namaan, su nataga ki no kona ogpaminogon to Diyus to makasasaya. Iyan ogpaminogon din to otow no ogtahud kandin aw ogtuman to pagboot din. ");
INSERT INTO msmNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na, wada pad disti kadinog no meyduon nakadojow to otow no ingkabata no buta. ");
INSERT INTO msmNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kaling ko wada pa sikandin kapuun to Diyus, kona sikandin ogpakahinang to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pagdinog to sikan inila no mgo Hibru to kagi din, mig-iling sikandan, “Sukad to pag-anak ikow, makasasaya kad yagboy. Na, nokoy no ogpatugu ka og-anad kanami?” Dajun dan sikandin pogongi to pagpagduma to angod din no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pagdinog ni Jesus to pighinang dan to sikan otow no nadojow din to mata, pigpamangha din aw usipa, “Ogtuu ka to sikan Anak to Otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Migtabak sikan otow, “Sir, nangoni a dow hintawa sikandin agun makatuu a.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kagi ni Jesus, “Nakakita kad on kandin su sikandin to migpag-isturya ikow kuntoon.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dajun yuhud sikan otow duon to atubangan ni Jesus aw ikagi, “Ginuu, ogtuu ad ikow.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Kagi ni Jesus, “Iyan ing-andini ku to kalibutan agun makiyayahan sikan nangkamaan to Diyus dow sikan wada kamaan kandin. To diya wada kangkamaan to Diyus igkapag-angod to buta. Oggawangon ku sikan pagkabuta dan. Di to diya ogpaman-iling no namaan kun to Diyus, igpakita ku no buta gihapun sikandan.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mey mgo Pariseo duon no nakadinog to kagi ni Jesus aw ikagihi dan, “Sikan pig-ikagi nu, angod to inyakip koy nu to sikan mgo buta.” ");
INSERT INTO msmNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Migtabak si Jesus, “Ko og-angkon kow pa no buta kow su kona ogpakasabut, kona kow ogkailing no sae-an. Di manno og-iling kow no ogpakasabut kow, ogkailing nasi no sae-an kow.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ligdongi now seini,” kagi ni Jesus. “Ko mey otow no ogsed to ayad to mgo karneru no kona ogbaja to yawanganan, ogkamaanan no kawatan sikandin dow tulisan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Di ogkakiyayahan to matuud no tag-karneru su duon sikandin ogbaja to yawanganan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Og-abrihan sikandin to magbantajay to yawanganan, aw to mgo karneru ogkiyaya to tingog din. Ogsabihon din to ngadan to kada sobuuk aw ogpayuwason din. ");
INSERT INTO msmNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pagyuwas dan on tibo, og-una sikan tag-karneru aw ogsunud sikan mgo buhi din su ogkiyayahon dan man to tingog din. ");
INSERT INTO msmNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Di kona sikandan ogduma to yain no otow, nasi no ogyagujan dan su wada dan man kaanadi to tingog.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Seini pananglitan no ing-anad ni Jesus, wada dan kasabuti to kahuyugan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kaling pig-ikagihan din isab sikandan, “Paminog kow to seini su tinood. Siakon to yawanganan no ogbajaan to mgo karneru. ");
INSERT INTO msmNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mahan-in to mgo otow no nakauna kanay no angod to mgo kawatan dow mgo tulisan. Di to mgo karneru wada paminog kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Siakon sikan yawanganan. Inggad hintawa no ogbaja kanay ogkayuwas. Og-atimanon ku sikandan angod to pag-atiman to tag-karneru to buhi din. Masaligon sikandan ko ogyuwas aw ogsed su kona ogkaamonu. ");
INSERT INTO msmNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","To kawatan iyan igsed su ogpangawat dow ogpanghimatoy aw ogpandodoot. Di siak, mig-andini a to pagbogoy to himpit no kinabuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Siak sikan madojow no tag-karneru, su andam a no ogpakimatoy to pagpanalipod kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Di ko meyduon sinuhuyan no ogpabantajon to sikan mgo karneru, og-ojowan din sikandan ko kitaon din on to mangongoon no ogpadodoyog duon. Dajun ogpamoodon to duma no mgo karneru aw ogkangkasuwoy-suwoy to duma. ");
INSERT INTO msmNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Og-ojowan din sikan mgo karneru su sinuhuyan man puli sikandin aw wada pag-oyog din to sikan mgo buhi. ");
INSERT INTO msmNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Siak sikan madojow no tag-karneru. Siakon dow mgo sakup ku, oghihilabi koy ");
INSERT INTO msmNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","angod isab to paghihilabi noy dow to Amoy ku. Kaling ogpakimatoy a agun no mayuwas sikandan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Meyduon pad duma no mgo karneru ku no kona no sakup to seini panon. Oghagokonon ku isab sikandan aw ogpaminogon dan to kagi ku. Na, ogkahinang sikandan tibo no songo panon nanda, aw sobuuk da to ogbantoy kandan tibo. ");
INSERT INTO msmNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“To Amoy ku mighigugma kanay su andam a no ogpakimatoy agun mabuhi a da. ");
INSERT INTO msmNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Wada inggad hintawa no ogpakaboot to kamatajon ku su siak da to ogboot to sikan. Aw meyduon isab katongod ku to pagbanhaw to kaugalingon ku. Sikan no katongod imbogoy kanay to Amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Pagdinog to mgo inila to sikan mgo kagi ni Jesus, nabahin sikandan. ");
INSERT INTO msmNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mahan-in to mig-iling, “Eh, kona kid on ogpaminog kandin su pigbuang to madoot no ispiritu.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Di to duma naman-iling, “Nadinog ta to madojow no pagkaikagi din, aw namaanan ta no nakadojow sikandin to buta. Ko pigbuang pa sikandin to madoot no ispiritu, kona din ogkahinang sikan tibo.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Na, mig-abut to Pista to Paghandom to Paghalad to Bayoy to Diyus. Tinghagsiy to diya no panahon. ");
INSERT INTO msmNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Paghipanow ni Jesus duon to Hoyunganan ni Salomon no nasakup to sikan Bayoy to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","piglibongan sikandin to inila no mgo Hibru aw ikagihi, “Kagan-u koy nu pad man ognangonan dow hintawa ka? Ajaw koy ogbitay-bitaja. Klaruhi koy dow sikuna iyan to diya Insaad no Manyuyuwas.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Dajun tabak si Jesus, “Pignangonan kud sikiyu, di wada kow man tuu. To mgo milagru isab no oghinangon ku pinaagi to katongod to Amoy ku kibali kistigus ku, ");
INSERT INTO msmNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","di kona kow ogtuu su kona kow no sakup to panon to mgo karneru ku. ");
INSERT INTO msmNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ogkiyayahon ku to kanay no mgo karneru. Ogpaminog sikandan to kagi ku aw ogsunud kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Konad yagboy sikandan ogkastiguhon to Diyus su ogbogajan kud on to kinabuhi no wada katapusan. Wada ogpakaagow kandan dini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","To Amoy ku no migbogoy kandan dini kanay, wada ogyabow to pagkagamhanan din. Kaling wada inggad hintawa no ogpakaagow kandan likat to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","To Amoy ku dow siak, iyan da yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Pagdinog to sikan inila no mgo Hibru to pig-ikagi ni Jesus, namudut sikandan to mgo batu su ogbatuhon dan podom. ");
INSERT INTO msmNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Di pig-ikagihan din sikandan, “Mahan-in on to impakita ku iyu no madojow no mgo hinang no impahinang kanay to Amoy ku. Na, andei man dapit to sikan to ogpakaamung to pagbatu now kanay?” ");
INSERT INTO msmNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Migtabak sikandan, “To mgo hinang nu kona no iyan ogkaamungan no ogbatuhon ka, di tongod to pagpasipaya nu to Diyus. Su anoy otow ka puli, ogpagsokod ka to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Kagi ni Jesus, “Ogkadomdoman now buwa to diya kagi to Diyus duon to Kasuyatan din no pigtagonan now no mighisgut bahin to karaan no mgo magmamandu no pig-iling, ‘Og-ilingon ku sikiyu no mgo diyus.’ Aw namaan ki no kona ogkaisab to kagi to Diyus. Na, ko sikan puli mgo otow og-ilingon no mgo diyus agun matahudan sikandan to kaotawan, ");
INSERT INTO msmNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","siak pad man to kona angajan no og-ilingon no Anak to Diyus no pigbogajan to Amoy ku to katongod aw paandiniha to kalibutan! Na, nokoy no og-iling kow man no migpasipaya a to Diyus? ");
INSERT INTO msmNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","To mgo hinang to Amoy ku iyan oghinangon ku. Di ko kona ku hinangon sikan, na, ajaw kow on ogtuu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Di ko sikan to oghinangon ku, kinahangyan mutuu kow tongod to sikan inggad kona now tuuhan to mgo kagi ku. Na, ogkamaanan now yagboy no siakon dow to Amoy ku iyan da.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tongod to sikan pig-ikagi ni Jesus, ogdakopon dan podom, di nakalikoy da sikandin. ");
INSERT INTO msmNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Dajun pauli si Jesus diya to dihipag to Jordan no wohig duon to sikan banwa no duon pamawtismu si Juan to diya una. No migpakamonang pad si Jesus duon, ");
INSERT INTO msmNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nahimunan sikandin to mahan-in no kaotawan. Kagi dan, “Wada iyan nahinang ni mina Juan no mgo milagru, di matuud yagboy to tibo pig-ikagi din bahin ki Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kaling mahan-in to namanuu ki Jesus duon to sikan no banwa. ");
INSERT INTO msmNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Meyduon otow no iyan ngadan si Lazaro no nasakit. Duon sikandin ugpa to baryu to Betania duma to mgo atoboy din no si Maria dow si Marta. ");
INSERT INTO msmNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Si Maria sikan oghudhud to pahomut duon to kobong ni Jesus aw ogpahidan to bubue din. Na, tongod to pagkasakit to sikan maama dan no si Lazaro, ");
INSERT INTO msmNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","pigtugunan dan si Jesus no pig-iling, “Ginuu, nasakit seini pighilabi nu no yagi.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pagdinog ni Jesus to sikan, mig-ikagi sikandin, “Sikan sakit ni Lazaro kona ogsangko to kamatajon, di nailing to sikan agun ikapakita to gahom to Diyus dow ikapakiyaya to pagka-Diyus ku no Anak din.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hinilabi iyan ni Jesus sikan tatoyu no migsusuun, ");
INSERT INTO msmNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","di wada dajun sikandin panggiyu-giyu no makadinog no nasakit si Lazaro. Nasi no migpakamonang pad duon sed to daduwa no aedow. ");
INSERT INTO msmNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tapus to sikan, pig-ikagihan din to mgo inanad din, “Og-andiya kinow to prubinsya to Judea.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Eh Sir,” kagi dan, “ogpauli ka diya no babag-uhay ka pad man podom ogbatuhon to inila no mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Migtabak si Jesus pinaagi to pananglitan. Kagi din, “Sed to songo aedow meyduon sampuyu-tag-duwa no uras to kaawang. Ko aedow to pagpanow to otow, kona sikandin ogpakadugsu su maawang man to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Di ko ogdoyom to otow, ogpakadugsu sikandin su madigyom aw wada kaawang duon kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Migpadajun si Jesus to pag-ikagi diya to mgo inanad din, “Nalipodong si Lazaro no yagi ta. Kaling og-andiya a su ogpukawon ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kagi to mgo inanad din, “Ginuu, madojow ko nalipodong sikandin su ogkaulian da.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iyan podom impasabut ni Jesus no namatoy on si Lazaro, di nailing to boot to mgo inanad din no nalipodong puli. ");
INSERT INTO msmNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kaling pigklaruhan sikandan ni Jesus. Kagi din, “Patoy on si Lazaro. ");
INSERT INTO msmNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Di madojow no wada a diya no mamatoy sikandin su to ogkadeygan to sikan, ogkahogot to pagtuu now kanay. Na, og-andiyaon tad.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Si Tomas no pigdagnajan to Iping mig-iling diya to angod din no mgo inanad, “Na, ogduma kinow agun ogpag-unung ki kandin no oghimatajan.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pagtidow onni Jesus diya to Betania, pignangonan sikandan no upat on no aedow to pagyobong ki Lazaro. ");
INSERT INTO msmNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Sikan no baryu madani da to siyudad to Jerusalem, mgo tatoyu da no ka kilumitru to kadiyu. ");
INSERT INTO msmNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kaling mahan-in to mgo Hibru no taga-Jerusalem no mig-anduon su ogduyug to kaguul ni Marta dow ni Maria no namatajan to maama. ");
INSERT INTO msmNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pagdinog ni Marta no umabutay on si Jesus, pigtagbu din dajun, di si Maria migpakamonang. ");
INSERT INTO msmNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Dajun ikagihi ni Marta si Jesus, “Ginuu, kona ogkamatoy to diya maama ku ko dini ka da pa. ");
INSERT INTO msmNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Di namaan a no inggad kuntoon ogtumanon to Diyus to inggad nokoy no ogbujuon nu kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Kagi ni Jesus, “Ogkabuhi da to maama nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Kagi ni Marta, “Hoo man iyan. Namaan a no ogkabuhi da sikandin ko banhawon on to mgo patoy diya to mahudi no aedow.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Kagi ni Jesus, “Siakon to ogbanhaw to mgo patoy, aw siakon isab to ogkapuunan to kinabuhi no wada katapusan. Inggad hintawa no ogtuu aw ogsalig kanay ogkabuhi da inggad mamatoy sikandan. ");
INSERT INTO msmNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Su to otow no ogsalig kanay meyduon kinabuhi no kona ogkagawang inggad mamatoy to yawa din. Sikuna Marta, ogtuu ka to sikan?” ");
INSERT INTO msmNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Hoo Ginuu,” kagi ni Marta. “Migtuu a no sikuna to diya Insaad no Manyuyuwas. Sikuna to Anak to Diyus no pigpaandini din to kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Dajun uli si Marta aw duguka si Maria no suun din aw hagasi, “Duon on si Sir. Ogpaandiyaon ka din.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Pagkadinog ni Maria to sikan, hinggawan sikandin migtindog aw andiya ki Jesus ");
INSERT INTO msmNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","diya to tawoy to baryu no pigtagbuhan ni Marta kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Na, sikan mgo Hibru no migduyug to kaguul dan, pagkita no hinggawan migpanow si Maria, migpatisunu sikandan su nailing to boot dan no og-andiya sikandin to yobong su ogtiniyahu. ");
INSERT INTO msmNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Na, pagtidow ni Maria duon ki Jesus, migyuhud aw ikagi, “Ginuu, kona ogkamatoy to diya maama ku ko dini ka da pa.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Pagkita ni Jesus to pagtiyahu ni Maria dow to mgo duma din, migdoot to ginhawa din, aw makaginhawa sikandin to mahaba. ");
INSERT INTO msmNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kagi din, “Andei now man iyobong?” Migtabak sikandan, “Ginuu, ogduduma kinow diya agun makakita ka.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dajun panagdu to yuha ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pagkita to mgo otow no pigyuhaan si Jesus, nakaikagi sikandan, “Pighigugma din yagboy to diya namatoy.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Di to duma naman-iling, “Ko nakadojow sikandin to buta, kona din buwa ogkapogongan to kamatajon ni Lazaro?” ");
INSERT INTO msmNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Pagtidow ni Jesus diya to yobong no imbangbang to madayom aw pigyoponan to piglipid no gatung, migdoot on isab to ginhawa din. ");
INSERT INTO msmNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Kagi din, “Ligada now sikan gatung.” Dajun ikagi si Maria no atoboy to sikan namatoy, “E-ay, Ginuu, mabohu on su upat on man no aedow to pagyobong kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kagi ni Jesus, “Domdoma to diya pig-ikagi ku ikow no ko mutuu ka kanay, ogpakakita ka to gahom to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dajun dan ligada sikan gatung. Migyanghag si Jesus aw ampu, “Amoy ku, ogpasalamat a ikow su naminog kad on kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tahan a namaan no kanunoy a nu ogpaminogon. Di og-ampu a ikow kuntoon tongod to seini mgo otow no nahimun kani, agun ko kitaon dan no ogtumanon nu to hangyu ku, ogpakatuu sikandan no sikuna yagboy to migpaandini kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tapus makaampu si Jesus, migtawag sikandin to maagbot, “Lazaro, yogwa ka duon!” ");
INSERT INTO msmNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Dajun yogwa si Lazaro no nalibodan pad to panapton to yawa din dow mgo boyad hasta to mgo kobong, aw to bayhu din nabogkot pad to panyu. Kagi ni Jesus, “Na, badbadi now aw papanawa.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sikan mgo Hibru no migduma ongki Maria, pagkita dan to sikan pighinang ni Jesus, mahan-in kandan to migtuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Di to duma mig-andiya to mgo Pariseo aw nangoni to sikan pighinang ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kaling pighimun to sikan mgo Pariseo dow to yabow no mgo magdudumaya to tinuuhan to duma dan no mgo maghusajay aw hisgut sikandan no mig-iling, “Wada kay nahimu ta to pagpogong to sikan no otawa. Mahan-in on to mgo milagru no ogpanghinangon din. ");
INSERT INTO msmNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ko pabay-anan ta, ogpasakup kandin to tibo kaotawan! Na, og-agawan ki to mgo taga-Roma to seini Bayoy to Diyus dow seini nasyun ta.” ");
INSERT INTO msmNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Dajun ikagi si Caifas no kinayabawan no magdudumaya to tinuuhan to mgo Hibru to sikan no tuig. Kagi din, “Mgo buluk kow tibo. ");
INSERT INTO msmNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nokoy no ogkaontopan kow man? Wada now kasabuti no madojow podom ko songo otow da to mamatoy agun no kona mamatoy to tibo no angod din no mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sikan pig-ikagi ni Caifas wada kapuun to kandin no panghona-hona. Di manno sikandin to kinayabawan no magdudumaya to tinuuhan, impatag-an kandin to Diyus no ogkamatoy si Jesus agun mabuhi to angod din no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Aw kona no sikan da duma din no mgo Hibru, di to tibo mgo anak to Diyus no naman-ugpa diya to yain-yain no mgo banwa, agun no mahinang din sikandan no songo pamilya da. ");
INSERT INTO msmNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Na, sugud to diya no aedow, migplanu sikan mgo inila dow og-amonuhon dan to paghimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kaling wadad si Jesus papajag duon to angod din no mgo Hibru. Nasi no pigduma din to mgo inanad din diya to yunsud to Efraim no nakapadigsey to matahay no banwa, aw duon sikandan pakamonang. ");
INSERT INTO msmNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","No madani on to pista to mgo Hibru no og-ilingon to Pista to Pagyaboy, mahan-in to naman-andiya to siyudad to Jerusalem no likat to yain-yain no mgo banwa su og-unahon dan to pagtuman to tumanon to paghugas. ");
INSERT INTO msmNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Namangha sikandan ki Jesus di wada dan kakita-i. Pagkahimun dan on duon to Bayoy to Diyus, migpauusipay sikandan, “Nokoy man to hona-hona now? Ogpamista buwa si Jesus?” ");
INSERT INTO msmNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Su to yabow no mgo magdudumaya to tinuuhan to mgo Hibru hasta to mgo Pariseo migsugu no ko meyduon mamaan dow andei si Jesus, kinahangyan no maanon sikandan agun no madakop dan. ");
INSERT INTO msmNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Anoy man no onom nanda no aedow og-abut on to Pista to Pagyaboy, mig-andiya si Jesus to Betania no pig-ugpaan ni Lazaro no pigbanhaw din. ");
INSERT INTO msmNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pagtidow ni Jesus duon, mighinaat sikandan to pagkoonan su ig-abi-abi kandin. Si Lazaro sobuuk to diya migpagdunga kandin, aw si Marta to mighonat kandan to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Dajun pudut si Maria to tonga to litru no pahomut no mahal hilabi su pudu nardu. Dajun din hudhudi to kobong ni Jesus to sikan pahomut aw pahidi to bubue din, aw kayokop sikan bayoy to ngadog to sikan pahomut. ");
INSERT INTO msmNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na, si Judas Iscariote no iyan inanad ni Jesus no ogyuib kandin migsawoy to sikan pighinang ni Maria. ");
INSERT INTO msmNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Kagi din, “Abee! Tapat pad ko imbaligja sikan pahomut, aw to linibu no halin ipamogoy to mgo pubri.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Di kona monang no pig-ikagi din sikan su nayuuy to mgo pubri, di tongod to pagkakawatan din. Sikandin man to ogtagon to saepi onni Jesus, di kanunoy din da ogkinuuton. ");
INSERT INTO msmNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Di mig-iling si Jesus, “Pabay-ani seini bohi. Seini pighinang din, angod to pighinaat din on to pagyobong kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","To mgo pubri kanunoy now igpagduma, di siakon, kona a ogkayugoy dini iyu.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na, mahan-in to mgo Hibru no mig-andiya to Betania su nadinog dan no duon si Jesus. Kona no puli sikandan ogtagbu ki Jesus, di gustu dan isab no og-aha ki Lazaro no pigbanhaw din. ");
INSERT INTO msmNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kaling oghimatajan isab podom si Lazaro to yabow no mgo magdudumaya to tinuuhan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Su tongod kandin, mahan-in to angod dan no mgo Hibru no wadad pasakup kandan su ogbalhin on diya ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pagkasunu no aedow, to mahan-in no mgo otow no namista diya to Jerusalem nakadinog no ogtidow on si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Dajun sikandan namudut to mgo paka to palmera aw namanyuwas to siyudad su ogtagbu ki Jesus. Namanguliya sikandan no mig-iling, “Sajaon ta to Diyus! Sajaon seini pigpaandini din no Hari ta no mgo kaliwat ni Israel!” ");
INSERT INTO msmNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dajun ipapudut ni Jesus to nati no asnu aw sakaji din. Seini pighinang din katumanan to diya pig-iling duon to Kasuyatan to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sikiyu no mgo taga-Jerusalem, kona kow on ogkahaedok su oho, sujad on to hari now no migsakoy to nati to asnu.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","To mgo inanad ni Jesus wada pad makasabut no katumanan naan sikan to intag-an duon to Kasuyatan. Ayha dan da kadomdomi no batunon on si Jesus diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Mahan-in to mgo otow no migtagbu kandin su nakadinog sikandan to diya pagbanhaw din ki Lazaro no pigpayogwa din likat to yobong. Su to mgo otow no nasakupan to sikan pagbanhaw ki Lazaro nangnawnangon to duma hangtod no migtangkap sikan no nawnangonon. ");
INSERT INTO msmNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kaling pagkita to mgo Pariseo to sikan mahan-in no mgo otow, mighihimanu sikandan, “Angod kay to wadad ogkahimu ta, su aha ka, angod to ogpasakup on kandin to tibo kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na, meyduon mgo otow no kona no Hibru no namista isab duon to Jerusalem su ogsimba. ");
INSERT INTO msmNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Migduguk sikandan ki Felipe no taga-Betsaida no sakup to Galilea aw hangyu, “Sir, ogkaliyag koy podom ogpag-isturya ki Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Dajun panow si Felipe aw nangoni si Andres. Na, migduduma sikandan diya ki Jesus aw nangoni to hangyu to sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Dajun ikagi si Jesus, “Mig-abut on to panahon no siakon no Anak to Otow ogpasidonggan pinaagi to kamatajon ku. ");
INSERT INTO msmNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ligdongi now seini su ogkaangod a to binhi. To binhi no kona igkayosok duon to pasak ogpabilin no sobuuk da. Di ko ikayosok, angod to ogkamatoy, di oggiti da aw ogpamogas to madogi. ");
INSERT INTO msmNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","To otow isab no og-oyog to kinabuhi din kani to kalibutan, wada ogkaiman din no kinabuhi no wada katapusan. Di to otow no og-unung kanay inggad igkamatoy din nasi ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inggad hintawa no ogtuman kanay kinahangyan no musunud kanay, aw inggad andei a, diya isab sikan suguonon ku. Inggad hintawa no ogtuman kanay ogbayosan to Amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Migpadajun si Jesus to pag-ikagi, “Masakit hilabi to ginhawa ku kuntoon. Og-amonu a man? Oghangyu a buwa to Amoy ku no kona a din ogpabajaon to sikan no mgo antusonon? Kona, su iyan man ing-andini ku to kalibutan agun no mabajaan ku sikan.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Dajun ampu si Jesus no mig-iling, “Amoy ku, pasidonggi to kaugalingon nu.” Dajun meyduon tingog no napuun diya to yangit no mig-iling, “Pigpasidonggan kud to kaugalingon ku, aw ogpasidonggan ku manda.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Na, sikan mahan-in no mgo otow, pagdinog dan to sikan tingog, naman-iling to duma, “Aduy, migyuyugung!” To duma mig-iling, “Mey anghil no mig-ikagi kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kagi ni Jesus, “Sikan nadinog now para iyu, kona no kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kuntoon on to katagahanan no madaogon a kani to seini kalibutan su og-abugon on si Satanas no iyan migmandu hangtod kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Aw siakon, ko itaud a duon to krus aw lindoga, oghimunon ku dini kanay to tibo kaotawan.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pig-ikagi ni Jesus sikan agun no mamaanan dow ogkaamonu to pagkamatoy din. ");
INSERT INTO msmNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","“Eh,” kagi to sikan mgo otow, “mig-iling duon to Kasuyatan to Diyus no kona ogkamatoy sikan Insaad no Manyuyuwas. Na, nokoy no og-iling ka man no kinahangyan no igtaud sikandin duon to krus aw lindoga? Na, hintawa man naan sikan og-ilingon no Anak to Otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Migtabak si Jesus, “Siakon no iyan kaawang, kona a ogkayugoy dini iyu. Kaling paanad kow kanay kuntoon. Maangod kow podom to otow no ogpanow to aedow su unu ko masakpanan kow to kadigyom. Su to otow no ogpanow duon to kadigyoman kona ogkamaan to ogbajaan din. ");
INSERT INTO msmNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Di kotob no siak no kaawang dini pad iyu, kinahangyan no mutuu kow aw pasakup kanay.” Tapus ikagi si Jesus to sikan, migpanow sikandin aw wadad pakita kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Inggad mahan-in to mgo milagru no nahinang ni Jesus duon to atubangan to kaotawan, wada gihapun sikandan tuu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nailing to sikan agun no matuman to diya intag-an ni Isaias no kibali ba-ba to Diyus no pig-iling, “Ginuu, wada ogtuu to ing-anad noy. Wada nakasabut to gahom nu no impakita nud man podom kandan.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sikan kona no pagtuu to mgo otow nasuyat isab ni Isaias duon to Kasuyatan no pig-iling to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Pigbuta ku sikandan agun kona makakita, aw pigyoponan ku to mgo kaisipan dan agun kona makasabut, su unu ko makakita sikandan aw makasabut dow atubang kanay agun mayuwas ku sikandan.” ");
INSERT INTO msmNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ingkatag-an ni Isaias sikan su pigkita din no meyduon da aedow no ogpasidonggan si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Inggad pad to sikan, mahan-in to inila no mgo Hibru no migtuu. Di inghobong dan to pagtuu kandin su nahaedok sikandan to mgo Pariseo, su unu ko pogongan sikandan to pagpagduma to angod dan no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iyan pigpayabi dan to pagsaja kandan to otow, di pigpakob-os dan to pagsaja to Diyus kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na, mig-ikagi si Jesus to maagbot, “Ko ogtuu to otow kanay, kibali pigtuuhan din isab sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","To otow no ogkita kanay, kibali ogkita to sikan migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mig-andini a to kalibutan kibali kaawang agun to mgo otow no ogtuu kanay konad ogpabilin duon to kadigyoman. ");
INSERT INTO msmNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","To otow no ogpaminog to igpang-anad ku aw kona ogtuman to sikan, kona no siakon to oghukum kandin. Su wada a andini to kalibutan to pagkastigu to kaotawan di to pagyuwas kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Di tinood no oghukuman sikan kona ogtuu kanay aw kona isab ogtuman to ing-anad ku, su to mgo kagi ku iyan ogpasikadan to pagkastigu kandan diya to katapusan no panahon. ");
INSERT INTO msmNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Su to impang-anad ku kona no kanay, di kaning Amoy ku no migpaandini kanay, su sikandin to migsugu kanay dow nokoy to og-ikagihon ku. ");
INSERT INTO msmNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Aw namaan a no pinaagi to sugu din ogkaangkon to kinabuhi no wada katapusan. Kaling iyan igpang-anad ku to insugu din kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","No mae-kasem on to Pista to Pagyaboy, namaan on si Jesus no mig-abut on to panahon no ogtalikudan din seini kalibutan su ogpauli diya to Amoy din. Kanunoy pighigugma ni Jesus to mgo inanad din, aw kuntoon igkapakita din kandan dow man-u to gugma din. ");
INSERT INTO msmNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Kaling no madukilom on, migdudunga to pagkoon si Jesus dow mgo inanad din. Sobuuk kandan si Judas no anak ni Simon Iscariote no pigpamajaan on ni Satanas to pagyuib ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Di namaanan ni Jesus no imbogoy on kandin to Diyus to tibo gahom. Namaanan din isab no diya sikandin kapuun to Diyus aw diya isab ogpauli. ");
INSERT INTO msmNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kaling, no namangoon pad sikandan, migtindog si Jesus aw hukasa sikan ing-apid din no kabo aw panapis to tuwalya. ");
INSERT INTO msmNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Dajun sikandin botang to wohig duon to planggana aw sugud to paghugas to kobong to mgo inanad din aw pahidi to sikan tuwalya no pigtapis din. ");
INSERT INTO msmNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Anoy man no kotob on sikandin duon ki Simon no pighingadanan isab ki Pedro, migbalibad si Pedro, “Eh Ginuu, kona no angajan no sikuna to oghugas to kobong ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Di mig-iling si Jesus, “Kona ka pad ogpakasabut dow nokoy seini oghinangon ku, di to kayugajan ogpakasabut ka da.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kagi ni Pedro, “Kona ku yagboy ogpahugasan ikow seini kobong ku.” Di mig-iling si Jesus, “Ko kona ku sikuna hinluan, ogpasabut no wada yabot nu kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","“Na Ginuu,” kagi ni Pedro, “ko mailing to sikan, hugasan nu to kobong ku aw iyakip to boyad dow uyu ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Kagi ni Jesus, “To otow no nakapadigus on iyan nanda oghugasan to kobong, su hinlu on to tibuuk yawa din. Nahinlu kow on, di meyduon kani iyu no kona no hinlu.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Naikagi ni Jesus sikan su tahan din on namaanan dow hintawa to ogyuib kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tapus hugasi ni Jesus to kobong dan, insul-ub din on isab to kabo din aw pauli duon to lamisa. Dajun din usipa sikandan, “Nakasabut kow to seini pighinang ku iyu? ");
INSERT INTO msmNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Iyan igtawag now kanay to Maistru dow Agayon, aw tinood sikan. ");
INSERT INTO msmNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na, manno siak no Maistru dow Agayon now migpaobos to paghugas to kobong now, sikiyu isab paobos aw pahuhugasay kow to kobong now. ");
INSERT INTO msmNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Impakita kud iyu seini agun no meyduon ogkasunudan now. ");
INSERT INTO msmNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Indani now seini. Wada udipon no yabow to agayon din. Wada isab sinugu no yabow to sikan migsugu kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Namaanan now on to ing-anad ku iyu kuntoon. Na, igkadojow now ko tumanon now sikan.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Migpadajun si Jesus to pag-ikagi diya to mgo inanad din, “To diya pig-ikagi ku kona no bahin iyu tibo, su namaanan ku sikiyu no pigpili ku. Di nailing to sikan to pagpili ku agun no matuman to diya pig-iling duon to Kasuyatan to Diyus, ‘Sikan migpagdunga kanay to pagkoon ogkuntra nasi kanay.’ ");
INSERT INTO msmNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tahan kud seini ingnangon iyu agun ko matuman on, ogpakatuu kow no Diyus a yagboy. ");
INSERT INTO msmNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ligdongi now seini. Inggad hintawa no ogdawat to otow no ogsuguon ku kibali ogdawat kanay. Aw inggad hintawa no ogdawat kanay kibali ogdawat to sikan migpaandini kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tapus ikagiha ni Jesus sikan, nasamuk hilabi to ginhawa din, kaling pig-ikagihan din on isab to mgo inanad din, “Oho, paminog kow. Sobuuk iyu kani ogyuib kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Naboyong yagboy sikandan aw makapayoyongyongay su nalibod dow hintawa to ognangonon din. ");
INSERT INTO msmNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na, mey sobuuk no inanad no migsoing ki Jesus no pighilabi din. ");
INSERT INTO msmNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pigsingyasan sikandin ni Pedro no usipon din si Jesus dow hintawa to ognangonon din. ");
INSERT INTO msmNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Dajun padogkot ki Jesus sikan inanad aw usip, “Ginuu, hintawa man?” ");
INSERT INTO msmNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Kagi ni Jesus, “Sikan ogtadwajan ku to pan no igdo-do ku duon to kalduhan iyan ogyuib kanay.” Dajun ido-do ni Jesus to pan aw ibogoy ki Judas no anak ni Simon Iscariote. ");
INSERT INTO msmNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pagkadawat ni Judas to sikan, pigsedan dajun sikandin ni Satanas. Kagi ni Jesus, “Hinanga dajun ko nokoy to oghinangon nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Di to mgo duma dan duon to lamisa wada makasabut to sikan pig-ikagi ni Jesus ki Judas. ");
INSERT INTO msmNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nailing to boot dan no ogpabolihon sikandin to ogkangkagamit to pagtuman to pista ubin meyduon igpabogoy kandin ni Jesus diya to mgo pubri. Iyan ingkahona-hona dan to sikan su si Judas man to ogtagon to saepi dan. ");
INSERT INTO msmNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kaling tapus koona ni Judas to diya pan no imbogoy kandin ni Jesus, dajun sikandin migyuwas. Madukilom on to diya. ");
INSERT INTO msmNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Pagkalius ni Judas, pig-ikagihan ni Jesus sikan mgo inanad din, “Kuntoon ogkapasidonggan a no Anak to Otow pinaagi to ogkangkahitabu kanay. Aw tongod kanay, ogkapasidonggan isab to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Na, ko mapasidonggan to Diyus tongod kanay, kona ogkayugoy siak no Anak to Otow ogpasidonggan din isab. ");
INSERT INTO msmNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mgo pinadajag ku, konad ogkayugoy to pagpagduma ku iyu. Ogpamanghaon a now, di ig-ikagi ku iyu kuntoon to iyan da no pig-ikagi ku diya to inila no angod ta no mgo Hibru no mig-iling a, ‘Kona kow ogpakaduma diya to ogdeygan ku.’ ");
INSERT INTO msmNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na, meyduon bag-u no sugu no igbilin ku iyu. Hinigugmaay kow angod to paghigugma ku iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ko muhinigugmaay kow, ogkamaan to tibo mgo otow no sikiyu mgo inanad ku yagboy.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Dajun ikagi si Pedro ki Jesus, “Ginuu, andei ka man ogdeg?” Kagi ni Jesus, “Kona ka pad ogpakaduma kanay diya to ogdeygan ku, di to kayugajan ogpakayupug ka da.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Mig-ikagi on isab si Pedro, “Ginuu, nokoy no kona a man ogpakaduma ikow kuntoon? Andam ad no ogpakimatoy tongod ikow.” ");
INSERT INTO msmNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mig-usip si Jesus, “Andam kad iyan no ogpakimatoy tongod kanay? Indani seini. Kona pad ogtagauk to manuk gaja, katatoyu a nud iglidung.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kagi ni Jesus duon to mgo inanad din, “Ajaw ogsamuka to ginhawa now. Nasi salig kow to Diyus aw salig kow isab kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Diya to banwa to Amoy ku mahan-in to ogkangkaugpaan. Ko kona pa no matuud seini, kona ku sikiyu ognangonan. Na, og-andiya a su oghinaaton ku to ogkaugpaan now. ");
INSERT INTO msmNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aw ko mahinaat kud to ugpaanan now, ogpauli a dini su ogdokaton ku sikiyu agun no inggad andei a, duon kow isab. ");
INSERT INTO msmNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Namaan kow on to dayan pailing diya to ogdeygan ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Dajun ikagi si Tomas ki Jesus, “Eh Ginuu, wada koy kay kamaan dow andei ka ogdeg. Og-amonuhon noy man to pagkamaan to dayan pailing diya?” ");
INSERT INTO msmNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Migtabak si Jesus, “Siakon to dayan pailing diya to Diyus. Siakon to ogpasabut to matuud bahin to Diyus aw siakon to ogkapuunan to kinabuhi no wada katapusan. Wada ogpakaandiya to Amoy ku gawas ko siak to ogbajaan din. ");
INSERT INTO msmNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ko namaan kow pa kanay, ogkamaan kow isab dow hintawa to Amoy ku. Na, kuntoon namaanan now on sikandin su pigkita now on man.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kagi ni Felipe, “Ginuu, iyan da oghangyuon noy ikow no ipakita nu kanami to Amoy nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Kagi ni Jesus, “Wotey! Nayugoy da to pagpagduma ku iyu, wada ka gihapun kamaan kanay, Felipe. Inggad hintawa no migkita kanay, pigkita din on to Amoy ku. Nokoy no oghangyu ka pad man no ipakita ku ikow to Amoy ku? ");
INSERT INTO msmNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Angod to wada ka tuu no duon a to Amoy ku aw dini isab sikandin kanay su sikami iyan da. To og-ikagihon ku iyu kona no kanay, di to Amoy ku no kani kanay iyan ogpadajun to sikan no mgo hinangonon din. ");
INSERT INTO msmNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Tuuhi now to pig-ikagi ku no siakon dow to Amoy ku iyan da. Di ko kona now tuuhan seini mgo kagi ku, tuu kow nasi tongod to mgo milagru no nahinang ku. ");
INSERT INTO msmNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ligdongi now seini. Inggad hintawa no ogtuu dow ogsalig kanay ogpakahinang to angod to nangkahinang ku aw yabow pad ngani duon, su ogpauli a diya to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Inggad nokoy to ogbujuon now to Amoy ku pinaagi to ngadan ku ogtumanon ku agun no masaja to Amoy ku pinaagi kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ogbalikon ku pag-ikagi no ogtumanon ku to inggad nokoy to ogbujuon now pinaagi to ngadan ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Migpadajun si Jesus to pag-ikagi diya to mgo inanad din, “Ko pighigugma a now, ogtumanon now to mgo sugu ku. ");
INSERT INTO msmNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na, oghangyuon ku to Amoy ku no bogajan kow to Magtatabang no kibali siak no ogpabilin duon iyu hangtod to wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ispiritu Santu sikan, aw sikandin to ogpasabut iyu to matuud. Kona sikandin ogkadawat to mgo otow no kona no sakup ku, su kona dan ogkiyayahon aw kona dan ogkamaanan dow hintawa sikandin. Di sikiyu namaan to Ispiritu Santu su duma sikandin iyu, aw ogsed duon to ginhawa now. ");
INSERT INTO msmNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na, inggad malius ad, kona ku sikiyu og-ojowan angod to mgo minailu su ogpauli a da dini iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kona ogkayugoy, kona ad ogkitaon to mgo otow no kona no sakup ku. Di sikiyu, ogkitaon a now da. Manno wada katapusan to kinabuhi ku, ogbogajan kow isab to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Duon to sikan no panahon, ogkamaanan now no sobuuk koy da yagboy dow Amoy ku, aw sobuuk kinow da isab. ");
INSERT INTO msmNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“To otow no ogpaminog dow ogtuman to igsugu ku, sikandin to oghigugma kanay. Sikan no otow oghigugmaon noy dow Amoy ku, aw ogpakiyaya a kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Si Judas no sangay ni Judas Iscariote mig-usip ki Jesus, “Ginuu, nokoy no sikami da man to ogpakiyayahon nu ikow? Nokoy no kona man igyakip to tibo otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Migtabak si Jesus, “Iyan da oghigugma kanay to otow no ogtuman to mgo kagi ku. Oghigugmaon isab sikandin to Amoy ku aw og-ugpa koy duon kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Di to otow no wada gugma kanay kona ogtuman to mgo kagi ku. Seini mgo kagi ku iyu kona no kanay, di napuun to Amoy ku no migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Seini to impang-anad ku iyu kotob no dini a pad, ");
INSERT INTO msmNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","di og-abut to panahon no to Ispiritu Santu iyan ogpang-anad iyu to tibo, aw igpadomdom din iyu to tibo ing-anad ku. Sikandin no og-ilingon isab to Magtatabang iyan ogpaandinihon iyu to Amoy ku kibali siak. ");
INSERT INTO msmNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Igbilin ku to kalinow duon to ginhawa now. Kona no angod to kalinow no ognangonon to kaotawan kani to seini kalibutan, su seini no kalinow ogkapuun kanay. Kaling ajaw ogsamuka to ginhawa now, aw kona kow isab ogkahaedok. ");
INSERT INTO msmNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nadinog now on to diya pig-ikagi ku iyu no ogpanow a di ogpauli a da dini iyu. Ko pighigugma a now yagboy, ogkalipay kow podom su og-andiya ad to Amoy ku, su yabow pad sikandin kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Impatahan kud iyu seini agun ko matuman on, ogkadigon to pagtuu now. ");
INSERT INTO msmNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Kona kud on oghabaon to pagpag-isturya ku iyu su madani on ogtidow to panguyu to madoot kani to seini kalibutan. Kona a din ogkadaog, ");
INSERT INTO msmNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","di ogtumanon ku to tibo insugu kanay to Amoy ku agun no mamaan to tibo kaotawan no pighigugma ku sikandin. Na, tindog kow on su ogpanow kid.” ");
INSERT INTO msmNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Dajun nangoni ni Jesus to mgo inanad din to pananglitan. Kagi din, “Siakon to tinood no yawa to ubas, aw to Amoy ku iyan og-atiman to sikan no tanom. ");
INSERT INTO msmNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","To tibo mgo sanga ku no kona ogbogas ogpanggawangon din. Di to tibo mgo sanga no ogpamogas oghawanan din agun no mudugang pad to pagpamogas. ");
INSERT INTO msmNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sikiyu angod to mgo sanga no nangkahawanan on tongod to impang-anad ku iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Pabilin kow dini kanay, aw ogpabilin a isab duon iyu. Ko ipananglit ta to mgo sanga, kona sikan ogpakabogas ko masagpu. Sikiyu isab, ko muyuwat kow kanay, kona ogpamogas to pagtuu now. ");
INSERT INTO msmNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Siakon to yawa to ubas aw sikiyu to mgo sanga. Ko mupabilin kow dini kanay aw siakon isab mupabilin duon iyu, ogpakapamogas kow yagboy. Di ko muyuwat kow kanay, kona kow ogpamogas. ");
INSERT INTO msmNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","To otow no kona ogpabilin kanay ogkaangod to nasagpu no sanga no igtimbag. Na, ko magangu on sikan no mgo sanga, oghimunon aw sangaba. ");
INSERT INTO msmNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Di ko mupabilin kow dini kanay aw ko tagonan now to mgo kagi ku, ogtumanon to Diyus to inggad nokoy no ogbujuon now. ");
INSERT INTO msmNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ko kanunoy kow mamogas, ogkasaja to Amoy ku su ogkakiyayahan no mgo inanad ku sikiyu. ");
INSERT INTO msmNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","To gugma ku iyu sahian ka da to gugma to Amoy ku kanay. Na, pabilin kow dini kanay agun no kona kow ogkayuwat to gugma ku. ");
INSERT INTO msmNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ko kanunoy now tumanon to mgo sugu ku iyu, igkadojow now seini gugma ku, angod kanay no ogtuman to mgo sugu to Amoy ku aw igkadojow ku isab to gugma din. ");
INSERT INTO msmNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Pig-ikagi ku iyu sikan agun no bation now to iyan da no kalipay no ogbation ku, su gustu ku no mahimpit to kalipay now. ");
INSERT INTO msmNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Seini to igsugu ku iyu: Hinigugmaay kow angod to paghigugma ku iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Wada gugma no ogpakayabow to gugma to otow no ogpakimatoy agun mabuhi to amigu din. ");
INSERT INTO msmNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Na, og-isipon ku sikiyu no mgo amigu ko tumanon now to mgo sugu ku. ");
INSERT INTO msmNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kona kud sikiyu og-isipon no mgo suguonon, su to suguonon kona ogkamaan to oghinangon to agayon din. Di ing-ikagi kud iyu to tibo ingnangon kanay to Amoy ku. Kaling og-ilingon ku sikiyu no mgo amigu ku. ");
INSERT INTO msmNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wada a now pili-a, di siakon to migpili iyu aw migsugu iyu to pagpangabig to duma agun to pagtuu now meyduon bogas no oghangtod. Na, ko meyduon bujuon now to Amoy ku pinaagi to ngadan ku, ogtumanon din. ");
INSERT INTO msmNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ogbalikon ku seini sugu ku iyu: Hinigugmaay kow.” ");
INSERT INTO msmNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Migpadajun si Jesus to pag-ikagi to mgo inanad din, “Kona now igkatingaya ko kuntrahon kow to mgo otow no kona no sakup ku. Domdoma now no una a pad iyu no pigkuntra dan. ");
INSERT INTO msmNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ko sakup kow dan pa, oghilabihon kow dan podom su angod kow man kandan. Di pagpili ku iyu, pigyain ku sikiyu duon kandan. Kaling ogkuntrahon kow dan. ");
INSERT INTO msmNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Domdoma now to diya pig-iling ku iyu, ‘Wada udipon no yabow to agayon din.’ Ko pigpaantus a dan no agayon now, ogpaantuson kow isab. Ko pigtuman dan pa to kagi ku, ogtumanon dan podom to kagi now. ");
INSERT INTO msmNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Di sikan ogpamanguntra iyu wada kamaan to sikan migpaandini kanay, kaling ogpaantuson kow dan tongod kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ko wada a pa andini to kalibutan aw pang-anada sikandan, kona sikandan ogkasukutan to sae dan to pag-ojow kanay. Di manno mig-andini a, wada ogkahinang dan no balibadan. ");
INSERT INTO msmNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","To otow no ogkuntra kanay, kibali ogkuntrahon din isab to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ko wada pa sikandan kita to mgo hinang ku, kona sikandan ogkasukutan to sae dan to pag-ojow kanay. Di anoy su naaha dan sikan mgo milagru ku no wada yain no ogpakahinang, pigkuntra a dan nasi hasta to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sikan pagkuntra dan kanay katumanan to diya pig-iling duon to Kasuyatan to Diyus, ‘Pigkuntra a dan inggad wada napasikadan.’ ");
INSERT INTO msmNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Di ogpaandinihon ku iyu sikan og-ilingon to Magtatabang no ogkapuun diya to Amoy ku. Ispiritu Santu sikandin no ogpasabut to matuud bahin kanay diya to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aw sikiyu ogkistigus isab su naduduma kinow man sugud pad to sinugdanan.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Migpadajun si Jesus to pagpang-anad to mgo inanad din. Kagi din, “Ingnangon kud iyu seini tibo agun no kona kow ogsibog to pagtuu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Su og-abut to panahon no ogpaantuson kow to mgo otow no ogkuntra kanay. Ogpogongan kow to pagpagduma to mgo angod now, aw ogkailing to boot dan no pagboot to Diyus no himatajan kow dan. ");
INSERT INTO msmNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iyan igpalisodi iyu to sikan mgo otow su wada sikandan kiyaya to Amoy ku hasta isab kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kaling pigpatahanan kud sikiyu to seini tibo, su ko abuton kow to mgo kasakitan, ogkadomdoman now no pig-ikagihan kud sikiyu. “To diya una wada ku sikiyu nangoni to ogkangkahitabu su duma a pad man iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Di kuntoon natingaya a, su anoy madani ad ogpauli diya to sikan migpaandini kanay, wada sobuuk iyu no nangusip bahin to sikan ogdeygan ku. ");
INSERT INTO msmNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Migsakit yagboy to ginhawa now tongod to seini ognangonon ku no ogkangkahitabu. ");
INSERT INTO msmNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Di to matuud, igkadojow now to pagpanow ku. Su ko kona a mupanow, kona og-andini iyu to Ispiritu Santu no og-ilingon to Magtatabang. Di ko mupanow a, ogpaandinihon ku sikandin iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Na, ko dinid on sikandin, ogpasabuton din to kaotawan bahin to sae dow to pagkamatarong hasta isab to paghukum. ");
INSERT INTO msmNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Bahin to sae, igpakiyaya din to kaotawan no makasasaya sikandan su wada a dan tuuhi. ");
INSERT INTO msmNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Bahin to pagkamatarong, igpasabut din kandan no matarong a su ogpakaandiya a to Amoy ku aw kona a now on ogkitaon. ");
INSERT INTO msmNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Bahin to paghukum, igpasabut din no pighukuman on si Satanas no agayon to mgo otow no kona no sakup ku. ");
INSERT INTO msmNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mahan-in pad podom to ignangon ku iyu,” kagi ni Jesus, “di kona kow pad ogpakatogkad. ");
INSERT INTO msmNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Di ko dinid on iyu to Ispiritu Santu no iyan ogpasabut to matuud, sikandin on to oghindu iyu to tibo matuud. Kona no kaugalingon din to ig-anad din, sikan da ogdinogon din duon to Diyus no Amoy. Igpasabut din iyu to ogkangkahitabu diya to umaabut no panahon. ");
INSERT INTO msmNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ogpasidonggan a din su dini man kanay ogkapuun to igpang-anad din iyu. ");
INSERT INTO msmNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ogpakailing a no ogkapuun kanay to tibo no igpang-anad din, su to tibo no kaning Amoy ku, kanay isab.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Kagi ni Jesus, “Konad ogkayugoy, kona a now on ogkitaon. Di kona da isab ogkayugoy, ogkitaon a now da.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Dajun pauusipay to mgo inanad ni Jesus, “Nokoy man to igpasabut to sikan pig-ikagi din no konad ogkayugoy, kona tad sikandin ogkitaon, aw tapus to sikan ogkitaon ta da? Hasta sikan pig-ikagi din no og-uli sikandin diya to Amoy din, nokoy man buwa to igpasabut to sikan? ");
INSERT INTO msmNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Aw sikan pig-ikagi din no ‘konad ogkayugoy,’ kona ki isab ogpakasabut.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Namaan si Jesus no ogkaliyag sikandan og-usip bahin to sikan pig-ikagi din, kaling pig-ikagihan din sikandan, “Migpauusipay kow buwa to diya pig-ikagi ku no konad ogkayugoy, kona a now on ogkitaon di tapus to sikan, kona ogkayugoy ogkitaon a now da. ");
INSERT INTO msmNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Na, paminogi now seini. Ogpakatiyahu kow aw ogpakadegmatoy bahin kanay dongan to pagtukhow to sikan kona no mgo sakup ku. Di kona ogkayugoy, og-ilisan to kalipay sikan kaguul now. ");
INSERT INTO msmNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Igpananglit ku to bohi no og-anak. Ogkasakitan sikandin ko oghajodan pad, di ko og-anak on, ogkalingawan din on to diya no kasakit tongod to kalipay no mey on anak din. ");
INSERT INTO msmNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Angod isab to sikan, ogkaguul kow iyan kuntoon, di ko makikita kinow on isab, og-ilisan sikan kaguul to hilabi no kalipay no konad ogkagawang. ");
INSERT INTO msmNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ko matuman on sikan, konad on ogkinahangyan no ogpangusip kow pad kanay bahin to inggad nokoy. Ligdongi now seini. Inggad nokoy to ogbujuon now to Amoy ku ogtumanon din tongod kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Wada pad on pigbuju now to Diyus pinaagi to ngadan ku. Na, pamuju kow kuntoon aw ogbogajan kow agun ogkahimpit to kalipay now. ");
INSERT INTO msmNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“To pagpang-anad ku iyu impabaja ku to pananglitan, di konad ogkayugoy, ogklaruhon kud to pagnangon iyu bahin to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ko muabut on sikan no panahon, konad no siak to oghangyu to Amoy ku tongod iyu. Sikiyu on mismu to oghangyu kandin pinaagi to ngadan ku, ");
INSERT INTO msmNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","su mismu to Amoy ku mighigugma iyu. Iyan ighigugma din iyu su pighigugma a now man aw migtuu kow no sikandin to migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","To diya pag-andini ku to kalibutan, sikandin to napuunan ku. Aw kuntoon, oglikatan ku seini kalibutan su ogpauli a diya kandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dajun ikagihi si Jesus to mgo inanad din, “Na, bali man no nakasabut koy on yagboy su wada nud ipabaja to pananglitan. ");
INSERT INTO msmNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nasiguru noy on no namaanan nu to tibo, su napaniidan noy no ogkabasa nu to mgo hona-hona noy, su inggad kona koy pad og-usip, ogpakatabak kad. Kaling migtuu koy on no Diyus yagboy to migpaandini ikow.” ");
INSERT INTO msmNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Dajun ikagihi sikandan ni Jesus, “Na, migtuu kow on iyan kuntoon, ");
INSERT INTO msmNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","di aha kow su mig-abut on to panahon no og-ojowan a now. Ogkasuwoy-suwoy kow, aw kada sobuuk iyu og-uli diya to banwa din. Di inggad pad ojowan a now, kona a ogkaawoy su dini man kanay to Amoy ku. ");
INSERT INTO msmNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Pignangonan kud sikiyu to seini tibo agun no malinow to ginhawa now tongod to pagkabogkot now dini kanay. Kani to seini kalibutan og-antus kow, di kona kow ogkahaedok su pigdaog kud to agayon to tibo madoot kani to seini kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pagkaikagi on ni Jesus to sikan, migyanghag sikandin diya to yangit aw ampu no mig-iling, “Amoy ku, seinid on to panahon no pigpaabut ta. Pasidonggi ad no anak nu agun no mapasidonggan kud isab sikuna. ");
INSERT INTO msmNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Su insalig nu kanay to katongod to pagmandu to tibo kaotawan agun no ikabogoy ku to kinabuhi no wada katapusan diya to tibo insalig nu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aw seini to kinabuhi no wada katapusan: to pagkamaan dow pagkahilabi ikow no iyan da matuud no Diyus hasta kanay no si Jesu-Cristo no pigpaandini nu to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Dini to kalibutan pigpasidonggan ku sikuna su natapus kud to tibo impahinang nu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Na kuntoon, Amoy ku, ibalik dini kanay to diya pagkagamhanan no pigtagonan ku no duma a pad ikow to diya wada pad kahinang seini kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Amoy ku, bahin to seini mgo otow no insalig nu kanay no napili nud kani to seini kalibutan, impakiyaya kud sikuna kandan. Ikow on yagboy sikandan, aw sikuna to migsalig kandan kanay. Pigtuman dan to mgo kagi nu kandan, ");
INSERT INTO msmNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","aw namaanan dan on no sikuna to napuunan to tibo kagi dow hinang ku. ");
INSERT INTO msmNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pigdawat dan to impaikagi nu kanay aw nasiguru dan no napuun a ikow. Migtuu isab sikandan no sikuna to migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Iyan ig-ampu ku to diya impansalig nu kanay su mgo sakup nu man sikandan. Kona ku ig-ampu kuntoon to kona no mgo sakup ta. ");
INSERT INTO msmNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","To tibo mgo sakup ku aw to ikow no mgo sakup, tibo ki tag-sakup, aw napasidonggan a pinaagi to pagsalig dan kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na, madani kud oglikatan seini kalibutan su ogpauli a diyan ikow, di seini mgo otow ogkabilin da dini to kalibutan. Balaan no Amoy ku, oghangyu a ikow no bantajan nu sikandan pinaagi to sikan gahom nu no imbogoy nu kanay agun ogkasaboka sikandan angod to pagkasaboka ta. ");
INSERT INTO msmNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kotob no duma a pad kandan, siakon to migbantoy kandan pinaagi to sikan gahom nu no imbogoy kanay. Wada sobuuk no nagawang. Iyan da nakasuwoy sikan sobuuk no angay no ogyagyagon agun no matuman to intag-an duon to Kasuyatan. ");
INSERT INTO msmNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Na, madani ad og-uli diyan ikow. Di kotob no dini a pad to kalibutan, og-ikagihon ku seini agun no bation dan to iyan da no kalipay no ogbation ku. ");
INSERT INTO msmNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Imbogoy kud kandan to mgo kagi nu. Kaling pigkuntra sikandan to mgo otow no kona no sakup ta su naangod sikandan kanay no kona no kalibutanon to panghona-hona. ");
INSERT INTO msmNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kona a oghangyu ikow no gawangon nu sikandan kani to kalibutan, di igatang bantajan nu agun no kona maamonu ni Satanas. ");
INSERT INTO msmNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ogkaangod sikandan kanay no kona no kalibutanon to panghona-hona. ");
INSERT INTO msmNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Na, pinaagi to kagi nu no iyan matuud, yaina sikandan to pagtuman ikow. ");
INSERT INTO msmNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ogsuguon ku sikandan duon to mgo angod dan kani to kalibutan angod da to diya pagsugu nu kanay kani to kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tongod kandan, igbogoy ku to kinabuhi ku agun no ibogoy isab to kaugalingon dan to pagtuman ikow. ");
INSERT INTO msmNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Amoy ku, kona no sikandan da to ig-ampu ku, di ig-ampu ku isab to duma no mgo otow no ogtuu kanay pinaagi to kagi to seini mgo inanad ku. ");
INSERT INTO msmNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Og-ampu a no masaboka sikandan tibo angod to pagkasaboka ta kuntoon su dini ka kanay aw duon a isab ikow. Oghangyu a ikow no masaboka sikandan kani ita agun no mutuu yagboy to kaotawan kani to kalibutan no pigpaandini a nu. ");
INSERT INTO msmNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","To gahom no imbogoy nu kanay imbogoy ku isab kandan agun no masaboka sikandan tibo angod to pagkasaboka ta. ");
INSERT INTO msmNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ogkahimu sikan su duon a kandan aw kani ka kanay agun no masaboka yagboy sikandan. Na, ogkataga to tibo kaotawan no sikuna to migpaandini kanay aw ogkataga no pighigugma nu sikandan angod to paghigugma nu kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Amoy ku, to mgo otow no imbogoy nu kanay, gustu ku no ogpakaduma kanay diya to ugpaanan ku agun no maaha dan to pagpasidongog nu kanay. Su tahan a nu pighigugma no wada pad kahinang seini kalibutan. ");
INSERT INTO msmNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Amoy ku no matarong, wada ka kiyayaha to kahan-inan to mgo otow kani to kalibutan, di migkiyaya a ikow, aw seini mgo sakup ku namaan no sikuna to migpaandini kanay. ");
INSERT INTO msmNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Impakiyaya kud sikuna kandan, aw ogpadajun a pad to pagpakiyaya ikow agun no mahinigugmaay sikandan angod to paghigugma nu kanay, agun isab ogpakamonang a duon to ginhawa dan.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tapus makaampu si Jesus, migyopa sikandin to sapa to Kidron duma to mgo inanad din. Migpadajun sikandan duon to banwa no mey kakajuhan no tinanom. ");
INSERT INTO msmNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na, si Judas no ogyuib ki Jesus namaan to sikan no banwa, su si Jesus dow to mgo inanad din kanunoy man oghihimun duon. ");
INSERT INTO msmNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kaling pigdaya ni Judas to mgo sundayu duon. Migduma isab to mgo magbantajay duon to Bayoy to Diyus no pigsugu to yabow no mgo magdudumaya to tinuuhan dow mgo Pariseo. Migdaya sikandan to mgo ispada dow taepos hasta mgo mitsa dow sayong no sinogaan. ");
INSERT INTO msmNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na, tahan on namaan si Jesus to tibo ogkahitabu kandin. Kaling pigtagbu din sikandan aw usipa, “Hintawa man to tuud now?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kagi dan, “Si Jesus no taga-Nazaret.” (Duma dan si Judas no migyuib ki Jesus.) Kagi ni Jesus, “Siak.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pagdinog dan to sikan kagi din, nakaus-us sikandan aw kangkatuad. ");
INSERT INTO msmNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Mig-usip on isab si Jesus, “Hintawa man yagboy to tuud now?” Migtabak sikandan, “Si Jesus no taga-Nazaret.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Kagi ni Jesus, “Pignangonan kud sikiyu no siakon. Na, ko siak man to tuud now, seini a. Di kona now igyakip seini mgo duma ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Pig-ikagi din sikan agun no matuman to diya ing-ampu din no pig-iling, “Wada sobuuk no nagawang to seini mgo otow no imbogoy nu kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dajun huyabut si Pedro to ispada din aw hambosa si Malco no suguonon to sikan kinayabawan no magdudumaya to tinuuhan to mgo Hibru, aw kasagping to kalintuu no talinga din. ");
INSERT INTO msmNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Di kagi ni Jesus, “Isug-ub sikan ispada nu. Kinahangyan no mabajaan ku to mgo antusonon no igpaantus kanay to Amoy ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Na, pigdakop si Jesus aw gapusa to sikan mgo sundayu binuligan to yabow dan hasta to mgo magbantajay to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Una dan sikandin pigdaya diya ki Anas no ugangan ni Caifas no kinayabawan no magdudumaya to tinuuhan to mgo Hibru to sikan no tuig. ");
INSERT INTO msmNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na, si Caifas to diya migsambag to mgo inila no madojow ko songo otow da podom to mamatoy agun no kona mamatoy to tibo angod din no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na, migyupug ki Jesus si Pedro dow to duma din no songo inanad. Pagtidow dan diya to bayoy to kinayabawan no magdudumaya to tinuuhan, iyan da nakapadajun sikan duma ni Pedro diya to pawa, su kiyaya sikandin to sikan tag-bayoy. ");
INSERT INTO msmNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Di si Pedro nabilin da diya to yuwas. Pagkahina-hina migyuwas sikan duma din aw ikagihi sikan bohi no migbantoy to yawanganan. Dajun din dumaha si Pedro duon to pawa. ");
INSERT INTO msmNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Dajun usipa si Pedro to sikan bohi, “Kona no sobuuk ka man no inanad to sikan otow?” Miglidung si Pedro, kagi din, “Eh, kona.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Na, meyduon mgo suguonon dow mgo magbantajay no migbuhi to kaeju dow panghinadang su mahagsiy to diya no kadukiloman. Migpagsakot si Pedro kandan aw panghinadang isab. ");
INSERT INTO msmNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na, si Jesus no diyad on to sed to bayoy pigpangusip to sikan kinayabawan no magdudumaya to tinuuhan bahin to mgo otow no inanad din hasta to pagpang-anad din. ");
INSERT INTO msmNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Migtabak si Jesus, “To pagpang-anad ku to kaotawan wada lipod-lipod su duon a kanunoy pang-anad to mgo simbahan ta hasta duon to Bayoy to Diyus no oghihimunan to tibo mgo Hibru. Wada a hinobong no nang-anad. ");
INSERT INTO msmNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nokoy no siak man to og-usipon nu? Iyan podom usipon nu to diya namakadinog kanay, su namaan sikandan dow nokoy to ing-anad ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Pag-ikagi ni Jesus to sikan, dajun sikandin sampaluha to sobuuk no magbantajay aw ikagihi, “Mayangub ka! Iyan sikan to igtabak nu to seini kinayabawan no magdudumaya to tinuuhan ta?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pig-ikagihan ni Jesus sikan magbantajay, “Ko madoot to diya pig-ikagi ku, matuuda dow nokoy to madoot duon. Di ko kona no madoot, nokoy no pigsampalu a nu man?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dajun ipadaya ni Anas si Jesus no ginapus gihapun diya ki Caifas no kinayabawan no magdudumaya to tinuuhan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na, si Pedro no migtindog no nanghinadang pad duon to pawa pig-usip to mgo otow duon, “Kona no sobuuk ka man no inanad to sikan otow?” Di miglidung si Pedro no mig-iling, “Eh, kona.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mey suguonon to sikan kinayabawan no magdudumaya no kadumahan to diya pigsagpingan ni Pedro to talinga. Kagi din ki Pedro, “Angod to pigkita ku sikuna ganina no duma ni Jesus diya to kakajuhan.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Miglidung manda si Pedro, aw duon-dajun migtagauk to manuk. ");
INSERT INTO msmNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Saju pad to masem, pigdaya si Jesus likat to bayoy ni Caifas pailing diya to bayoy to gubernadur no taga-Roma. To mgo Hibru wada sed duon su unu ko maligsoman sikandan ojow pa to balaod to tinuuhan dan, aw iyan hinongdan no kona sikandan ogpakakoon to pagkoonan to Pista to Pagyaboy. ");
INSERT INTO msmNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kaling migyuwas si Gubernadur Pilato aw usipa sikandan, “Nokoy man to riklamu now kuntra to seini no otow?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Migtabak sikandan, “Ko kona pa no maaslag to sae din, kona noy ogdaehon dini ikow.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kagi ni Pilato, “Sikiyu to muhukum kandin pinasikad to iyu no balaod.” “Eh, kona ogkahimu,” kagi to sikan mgo Hibru. “Su wada katongod noy to pagpahimatoy to otow.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nailing to sikan agun no matuman to diya pig-ikagi ni Jesus dow ogkaamonu to paghimatoy kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Dajun sed si Pilato duon to bayoy aw sugu no daehon si Jesus duon kandin aw usipa din, “Sikuna iyan to hari to mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Migtabak si Jesus, “Nokoy man to igpasabut nu to sikan og-ilingon nu no hari a? Hari a sumaya to pagsabut nu ubin ko pagsabut to mgo Hibru no mig-ikagi ikow bahin kanay?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Kagi ni Pilato, “Nokoy man to pagtuu nu, Hibru a? To angod nu no mgo Hibru iyan migdaya ikow dini kanay, yakip to yabow no mgo magdudumaya to tinuuhan now. Na, nangoni a dow nokoy to sae nu.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Migtabak si Jesus, “To paghari ku kona no kani to seini kalibutan. Su ko mailing pa to sikan, ogpanalipodan a podom to mgo ginsakupan ku agun kona a madakop to sikan mgo Hibru. Di to paghari ku wada yabot to seini kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dajun usip si Pilato, “Hari ka naan?” Kagi ni Jesus, “Ko hari to igtawag nu kanay, na hala sigi. Iyan ing-andini ku to kalibutan su ogpang-anad a to matuud, aw to tibo mgo otow no ogkaliyag no mamaan to matuud ogpaminog kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Kagi ni Pilato, “Indoy dow nokoy sikan og-ilingon to matuud.” Dajun isab yuwas sikandin aw ikagihi sikan mgo Hibru no nahimun duon, “Wada nakitaan ku no sae din. ");
INSERT INTO msmNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Na, su nabatasan now man no ogpasabukan now to songo prisu panahon to Pista to Pagyaboy, nokoy man, ogkaliyag kow ko iyan pasabukan ku sikan og-ilingon to hari to mgo Hibru?” ");
INSERT INTO msmNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Dajun sikandan kinuliya, “Kona no sikandin! Si Barabas da!” Na, si Barabas, ribeldi. ");
INSERT INTO msmNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dajun palinapdosi ni Pilato si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tapus to sikan, mighinang to mgo sundayu to kuruna to dugihon no gawod aw ikuruna ki Jesus. Pigsul-uban dan isab to mayogdog no kapa. ");
INSERT INTO msmNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Dajun dan sujan-sujana. Pigpinauli dan to pag-iling, “Mabuhi ka, hari to mgo Hibru!” Aw sinampaluha dan isab. ");
INSERT INTO msmNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Migyuwas on isab si Pilato to bayoy din aw ikagihi sikan nahimun no mgo otow, “Oho, ogpaatubangon kud sikandin iyu agun no mamaan kow no wada yagboy nakitaan ku no sae din.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Dajun payuwasa si Jesus no nakurunahan pad to diya dugihon no gawod aw nakasul-ub pad to diya mayogdog no kapa. Kagi ni Pilato, “Na, yongyongi now seini otow.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pagkita ki Jesus to yabow no mgo magdudumaya to tinuuhan dow mgo magbantajay duon to Bayoy to Diyus, migkinuliya sikandan, “Himataji! Iyansang duon to krus!” Kagi ni Pilato, “Na hala, sikiyu to muyansang kandin duon to krus. Su siak, wada nakitaan ku no sae din.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Kagi to sikan inila no mgo Hibru, “Meyduon balaod noy no pigyapas din su mig-angkon no Anak sikandin to Diyus. Kaling kinahangyan no himatajan.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pagdinog ni Pilato to sikan, migdugang to haedok din. ");
INSERT INTO msmNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pigpased din on isab si Jesus to bayoy aw usipa, “Andei ka man yagboy kapuun?” Di wada tabak si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Naboyong si Pilato aw makaikagi, “Abee! Nokoy no kona ka man ogtabak kanay? Wada ka kamaan no mey katongod ku to pagpasabuk ikow aw mey isab katongod ku to pagpayansang ikow duon to krus?” ");
INSERT INTO msmNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Kagi ni Jesus, “Ko wada ka pa bogaji to Diyus to katongod, wada podom katongod nu to paghukum kanay. Kaling yabow to sae to sikan migdata kanay dini ikow su pigtuudan dan to pag-amung-amung kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ogsabukan podom ni Pilato si Jesus, di to inila no mgo Hibru migpadajun to pagkinuliya, “Ko sabukan nu sikandin, ogkadootan sikan yabow no hari. Su ogkuntra kandin to inggad hintawa no ogpahari-hari.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pagdinog ni Pilato to sikan kagi dan, pigpayuwas din si Jesus aw ingkud duon to hukumanan no og-ilingon no Gabata to Hibru no inikagihan, no ko ita pa, Saog no Batu. ");
INSERT INTO msmNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aedow to diya to pagpangandam to Pista to Pagyaboy, aw madani on ogkaugtu. Pag-ingkud ni Pilato duon, pig-ikagihan din to mgo otow, “Na, yongyongi now seini hari now.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Di migkinuliya gihapun sikandan, “Gawangad sikandin! Himatajid! Iyansang duon to krus!” Kagi ni Pilato, “Nokoy man, ogkaliyag kow no igpayansang ku duon to krus seini hari now?” Migtabak sikan yabow no mgo magdudumaya, “Iyan da hari noy sikan yabow no hari diya to Roma.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Dajun idata ni Pilato si Jesus diya kandan agun iyansang duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Dajun ipatiang to mgo sundayu ki Jesus to krus no ogyansangan kandin aw daeha duon to banwa no og-ilingon to Golgota to Hibru no inikagihan, no ko ita pa, banwa to Boboungon. ");
INSERT INTO msmNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Pagtidow dan duon, inyansang dan si Jesus duon to krus aw lindoga. Mey daduwa no ka otow no inyansang isab to mgo krus duon to magdibayuy din. ");
INSERT INTO msmNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Meyduon impasuyat ni Gubernadur Pilato no impataud din duon to krus ni Jesus no pig-iling, “Si Jesus no taga-Nazaret, Hari to mgo Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Insuyat sikan to tatoyu no ka inikagihan: Hibru, Latin dow Grigu. Mahan-in to mgo Hibru no nakabasa to sikan su madani man to siyudad sikan pigyansangan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Dajun andiyaa si Pilato to yabow no mgo magdudumaya to tinuuhan to mgo Hibru aw ikagihi, “Kona no hustu sikan impasuyat nu no pig-iling, ‘Hari to mgo Hibru.’ Madojow podom ko ilisan sikan to yain no og-ilingon, ‘Mig-angkon sikandin no hari to mgo Hibru.’” ");
INSERT INTO msmNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Di mig-ikagi si Pilato, “Sikan impasuyat ku konad og-isabon.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tapus ikayansang si Jesus to mgo sundayu, pigpudut dan sikan hinukas din no mgo kabo aw upata dan no bahin, tag-songo bahin sikandan. Di sikan sobuuk no kabo din wada kasinugpatan. ");
INSERT INTO msmNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kaling mig-uujun sikandan, “Kona ta seini oghigbiton, ogripahon ta nasi. Sikan ogkaripahan iyan ogpakatag-iya.” Duon to sikan, natuman sikan pig-iling duon to Kasuyatan, “Ogbabahinon dan to mgo kabo ku, aw ogripahan dan sikan sobuuk.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na, meyduon mgo bohi no namanindog duon to dani to sikan krus no pigyansangan ki Jesus. To sobuuk inoy din, aw sikan duma, yagina din hasta si Maria no asawa ni Cleopas dow si Maria Magdalena. ");
INSERT INTO msmNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pagkita ni Jesus to inoy din dow sikan sobuuk no inanad no pighilabi din no migtitindog duon, pig-ikagihan din to inoy din, “Isipa no anak nud sikandin.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Dajun din ikagihi sikan inanad din, “Isipa no inoy nud sikandin.” Kaling sugud to sikan no aedow pigpayumun sikan inoy ni Jesus duon to bayoy din. ");
INSERT INTO msmNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pagkahina-hina, namaan si Jesus no natapus on to tibo impahinang kandin. Kaling mig-iling sikandin, “Pig-uhaw a,” agun no matuman to diya intag-an duon to Kasuyatan to Diyus bahin kandin. ");
INSERT INTO msmNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na, meyduon suka duon. Pagdinog to mgo otow to kagi ni Jesus, meyduon migpudut to papasoyopay aw i-oyod duon to sikan suka. Dajun dan itaud duon to yawa to hisupu aw itadwoy diya to ba-ba ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tapus din katimtim, mig-ikagi sikandin, “Natapus on.” Dajun din isalig to umagad din diya to Diyus dongan to naseyngoyngoy to uyu din. ");
INSERT INTO msmNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nahitabu sikan to diya mahapun no og-andamon dan to Aedow no Tigpahuway no nakatapu to pista. Kona ogkaliyag to inila no mgo Hibru no maabutan to Aedow no Tigpahuway sikan impanyansang duon to mgo krus, su mahal yagboy sikan no aedow. Kaling mig-andiya sikandan ki Pilato aw hangyu-a no pamantigon to mgo bitiis to sikan tatoyu no impanyansang duon to mgo krus agun no madali sikandan mamatoy aw ogkagawang to mgo yawa dan duon. ");
INSERT INTO msmNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kaling mig-anduon to mgo sundayu aw pamantigi sikan daduwa duon to magdibayuy ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Di pagduguk dan ki Jesus, naaha dan no patoy on sikandin, kaling wada dan on pantigi. ");
INSERT INTO msmNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Di inyugsak to songo sundayu to tabae din duon to takidingan ni Jesus. Duon-dajun mig-awas to yangosa dow wohig. ");
INSERT INTO msmNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Siakon no migsuyat to seini, namaan a no tinood su mata ku yagboy to migkita. Kaling igsuyat ku seini no hitabu agun no makatuu kow isab. ");
INSERT INTO msmNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nailing to sikan agun no matuman sikan pig-iling duon to Kasuyatan to Diyus, “Wada ogkapantig no bokog din, inggad sobuuk.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Natuman isab sikan pig-iling, “Ogyongyongan dan sikan pigpilak dan.” ");
INSERT INTO msmNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Na, meyduon otow no taga-Arimatea no iyan ngadan si Jose. Sakup sikandin ni Jesus, di wada din imaan su nahaedok to sikan inila no mgo Hibru. Mig-andiya ki Pilato aw hangyu no sikandin to ogyobong ki Jesus. Na, mig-ujun si Pilato, kaling pigpudut ni Jose sikan yawa ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Duma din si Nicodemo no iyan migdoyom diya ki Jesus to diya una. Migdaya sikandin to subra to katluan no kilu no pahomut no og-ilingon to mira no pigsakotan to sikan og-ilingon to aloe. ");
INSERT INTO msmNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pigdaya dan to yawa ni Jesus aw libodi to panapton duma to sikan pahomut, su sikan to nabatasan to mgo Hibru ko mey igyobong dan no patoy. ");
INSERT INTO msmNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Na, duon to dani to sikan pigyansangan ki Jesus meyduon pasak no pigtanoman to yain-yain no mgo tanom. Duon to sikan, meyduon yobonganan no bag-u pad kahinang no wada pad disti kayobongi. ");
INSERT INTO msmNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Duon dan ibotang sikan yawa ni Jesus su madani da. Kinahangyan no dalion dan to pagyobong su mahapun on aw ko masayop on to soga, ogsugud on to Aedow no Tigpahuway to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Madidigyomay pad to masem to Duminggu, mig-andiya si Maria Magdalena to pigyobongan ki Jesus. Pagtidow din, pigkita din no nakapakilid on sikan piglipid no gatung no inyopon. ");
INSERT INTO msmNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kaling dajun sikandin linaguy diya ki Pedro dow sikan sobuuk no inanad ni Jesus no pighilabi din. Kagi din, “Aduy, wadad on to Ginuu ta! Pigpudut buwa. Indoy dow andei daeha.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pagdinog ni Pedro dow sikan duma din to kagi ni Maria, dajun sikandan andiya to yobong. ");
INSERT INTO msmNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Miglinaguy sikandan, di mataksi sikan sobuuk, kaling una no nakatidow. Iyan nahudi si Pedro. ");
INSERT INTO msmNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Mig-obo sikan una no nakatidow aw linghag duon to yobong, di wada sikandin sed. Puli din naaha sikan panapton no inlibod to yawa ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Di pagtidow ni Pedro, migpadajun-dajun sikandin diya to sed. Pigkita din isab sikan panapton ");
INSERT INTO msmNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","hasta sikan panyu no imputus to uyu ni Jesus. Pigyupi sikan aw iyain to pagbotang. ");
INSERT INTO msmNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Na, migsed isab sikan inanad no una no nakatidow. Pagkita din no panapton nanda to nabilin, iyan on pagtuu din no nabanhaw on si Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Di wada dan gihapun kasabuti to mgo sinuyat duon to Kasuyatan to Diyus no ogkabanhaw si Jesus.) ");
INSERT INTO msmNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dajun uli sikan daduwa no mgo inanad. ");
INSERT INTO msmNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Di si Maria Magdalena migtitindog pad duon to yuwas to yobong. Migtitiyahu pad sikandin no mig-obo aw linghag duon. ");
INSERT INTO msmNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Paglinghag din, iyan pigkita din to daduwa no mgo anghil no namangabo to maputi. Naman-ingkud sikandan duon to nabotangan to yawa ni Jesus, to sobuuk duon dapit to uyuhan aw to sobuuk duon dapit to sikadan. ");
INSERT INTO msmNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Dajun dan usipa si Maria, “Iya, nokoy no ogtiyahu ka man?” Migtabak si Maria, “Su pigpudut to yawa to Ginuu ku, aw indoy dow andei daeha.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Dajun sikandin lingi aw pigkita din to otow no migtindog duon. Si Jesus iyan to diya, di wada kiyayaha ni Maria. ");
INSERT INTO msmNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Pig-usip din si Maria, “Iya, nokoy no ogtiyahu ka man? Hintawa man to ogpamanghaon nu?” Nailing to boot ni Maria no sikandin to og-atiman to mgo tanom duon. Kaling mig-ikagi sikandin, “Sir, ko sikuna to migpudut kandin, nangoni a dow andei nu daeha su ogpuduton ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Dajun ikagi si Jesus, “Maria.” Dajun atubanga ni Maria si Jesus aw ikagi to Hinibru, “Raboni!” no ko ita pa, “Maistru.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kagi ni Jesus, “Panabuk kad kanay su wada a pad makauli diya to Amoy ku. Nasi no andiyaa to mgo suun ku aw nangoni no og-andiya a pad to Amoy ku no Diyus no iyan isab Amoy dow Diyus now. ");
INSERT INTO msmNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Dajun andiya si Maria Magdalena to mgo inanad ni Jesus aw nangoni. Kagi din, “Oho, pigkita ku to Ginuu ta.” Dajun din inangon to tibo pig-ikagi ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Duminggu to diya no aedow no mahitabu sikan. Pagkadukilom, nahimun to mgo inanad ni Jesus duon to songo bayoy. Pigtrangkahan to habangan su nahaedok sikandan to inila no mgo Hibru. Puli nakatokow migtitindog on si Jesus duon aw ikagihi sikandan, “Mahusoy podom to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Dajun din ipaaha kandan to mgo pali duon to mgo boyad dow takidingan din. Hilabi nalipay to mgo inanad no kitaon dan to Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Kagi on isab ni Jesus, “Mahusoy podom to ginhawa now. To diya una, pigsugu a to Amoy ku no Diyus. Na, kuntoon ogsuguon ku isab sikiyu.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tapus to pag-ikagi din, pigginhawahan din sikandan aw ikagi, “Dawata now to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Inggad hintawa no ogpasayluhon now to sae din pigpasaylu to Diyus. Inggad hintawa no kona now ogpasayluhon to sae din wada isab kapasaylu to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na, si Tomas no pigdagnajan to Iping, sobuuk sikandin to sikan sampuyu-tag-duwa no mgo inanad ni Jesus. Di to diya no panahon no mupakita si Jesus to duma no mgo inanad, wada duon si Tomas. ");
INSERT INTO msmNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pagnangoni kandin to sikan mgo duma din no si Jesus migpakita kandan, mig-iling sikandin, “Kona a yagboy ogtuu no nabanhaw si Jesus ko kona ku maaha aw ikatugsuk sei tudyu ku duon to mgo boyad din no pigyagbasan to mgo yansang. Kona a isab ogtuu ko kona ku ikakuut seini boyad ku duon to pali to takidingan din.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Na, pagyaboy on to songo simana, nahimun on isab to mgo inanad ni Jesus duma si Tomas. Pigtrangkahan to habangan, di puli nakatokow migtitindog on si Jesus duon kandan. Kagi din, “Mahusoy podom to ginhawa now.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dajun din ikagihi si Tomas, “Ahaa seini mgo boyad ku. Itugsuk to tudyu nu kani aw kuuta isab seini takidingan ku. Kona kad ogduwa-duwa, tuu kad nasi.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kagi ni Tomas, “Sikuna to Ginuu dow Diyus ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Kagi ni Jesus, “Iyan intuu nu kanay su pigkita a nu man. Di iyan madojow to mgo otow no ogtuu kanay inggad kona a dan kitaon.” ");
INSERT INTO msmNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Mahan-in pad to mgo milagru no pighinang ni Jesus no naaha to mgo inanad din no migpakiyaya to gahom din, di wada tibo ikayakip kani to seini libru. ");
INSERT INTO msmNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Di pigpanuyat seini agun no makatuu kow no si Jesus yagboy to diya Insaad no Manyuyuwas no Anak to Diyus. Aw pinaagi to pagtuu dow pagkabogkot now duon kandin, ogkabogajan kow to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tapus to sikan, migpakita on isab si Jesus to mgo inanad din diya to higad to danow to Galilea. Nailing to seini to pagpakita din kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nahimun duon to pitu no mgo inanad ni Jesus: si Pedro, si Tomas no pigdagnajan to Iping, si Natanael no taga-Cana no sakup to Galilea, sikan daduwa no mgo anak ni Sebedeo hasta to daduwa pad no mgo inanad ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kagi ni Pedro, “Ogpamukut a.” “Ogduma koy,” kagi dan. Dajun sikandan sakoy to bangka aw pamukut. Di puli on nabukasan, wada napudut dan no isda. ");
INSERT INTO msmNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pagsilat on to soga, meyduon otow no migtitindog duon to higad. Si Jesus sikan di wada dan kiyayaha. ");
INSERT INTO msmNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Dajun panabi si Jesus kandan, “Honda mgo pinadajag ku, mey napudut now?” Migtabak sikandan, “Ampan.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kagi ni Jesus, “Ituntun sikan pukut now duon dapit to kalintuu to sikan sakajan now agun no makapudut kow to isda.” Dajun dan ituntun sikan pukut dan. Pagbatun dan on, aw ato! Wada dan kadaog tongod to kahan-in hilabi to mgo isda no napukutan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Na, sikan inanad no pighilabi ni Jesus mig-ikagi ki Pedro, “Ginuu ta suja diya to higad.” Pagdinog ni Pedro no Ginuu naan sikan, insul-ub din sikan hinukas din no kabo. Dajun yaksu duon to wohig aw yanguy padeg diya to higad. ");
INSERT INTO msmNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","To mgo duma din migpadajun diya to higad no miggujud to sikan pukut no naponu to isda su mgo kasiaman nanda no mitrus to kadiyu. ");
INSERT INTO msmNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Paghaw-as dan on, migkita sikandan to hinayub no isda duon to baga aw meyduon isab pan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Kagi ni Jesus, “Daya kow dini to pila no buuk no napudut now no isda.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Dajun andiya si Pedro to sakajan aw gujuda sikan pukut no naponu to 153 no mangkaaslag no isda. Inggad mahan-in hilabi to isda, di wada kahigbit sikan pukut. ");
INSERT INTO msmNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Dajun ikagi si Jesus kandan, “Pamahaw kow.” Wada inanad din no nakayangub to pag-usip dow hintawa sikandin su namaanan dan on no si Jesus sikan no Ginuu dan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Dajun padani si Jesus kandan. Migdawat sikandin to pan dow isda aw ibogoy kandan. ");
INSERT INTO msmNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ikatoyu sikan no pagpakita din to mgo inanad din sugud no mabanhaw sikandin. ");
INSERT INTO msmNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tapus sikandan makapamahaw, pig-usip ni Jesus si Simon Pedro, “Simon, anak ni Juan, pighigugma a nu yabow to paghigugma kanay to seini mgo duma nu?” Migtabak si Pedro, “Hoo Ginuu. Namaan ka no pighigugma ku sikuna.” “Na,” kagi ni Jesus, “atimana to nati no mgo karneru ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Dajun usip si Jesus to ikaduwa, “Simon, anak ni Juan, pighigugma a nu?” Migtabak si Pedro, “Hoo Ginuu. Namaan ka no pighigugma ku sikuna.” “Na,” kagi ni Jesus, “atimana to mgo karneru ku.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mig-usip si Jesus to ikatoyu, “Simon, anak ni Juan, pighigugma a nu?” Pag-usip ni Jesus kandin to ikatoyu bahin to gugma din, migsakit to ginhawa ni Pedro aw nakatabak sikandin, “Ginuu, namaanan nu to tibo. Namaan ka no pighigugma ku sikuna.” “Na,” kagi ni Jesus, “atimana to mgo karneru ku. ");
INSERT INTO msmNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ligdongi seini. To diya una no batan-on ka pad, puli ka ogpanimon-timon aw dajun ka ogpanow diya to inggad andei no ogkaliyagan nu ogdeygan. Di ko mamanigaon kad, igpadopa to mgo boyad nu aw ibagkot aw daeha diya to kona nu ogkaliyagan ogdeygan.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pig-ikagi ni Jesus sikan su igpasabut din dow ogkaamonu to pagkamatoy ni Pedro agun mapasidonggan to Diyus. Dajun ikagi on isab si Jesus, “Sunud ka kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Miglingi si Pedro aw pigkita din sikan inanad no pighilabi ni Jesus no migyupug kandan. (Sikandin to diya migsoing ki Jesus no manihapun sikandan aw mig-usip dow hintawa to ogyuib kandin.) ");
INSERT INTO msmNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pagkita ni Pedro kandin, pig-usip din si Jesus, “Ginuu, nokoy man to ogkadeygan din?” ");
INSERT INTO msmNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Kagi ni Jesus, “Ko gustu ku no buhi pad sikandin hangtod no mupauli a dini to kalibutan, nokoy man to yabot nu? Sunud ka puli kanay.” ");
INSERT INTO msmNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tongod to sikan pig-ikagi ni Jesus, meyduon naisturya no migtangkap duon to mgo sakup ni Jesus no kona kun ogkamatoy sikan no inanad. Di to tinood, wada ikagi si Jesus to sikan. Puli sikandin mig-ikagi ki Pedro no “Ko gustu ku no buhi pad sikandin hangtod no mupauli a dini to kalibutan, nokoy man to yabot nu?” ");
INSERT INTO msmNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sikan inanad no ognangonon ni Jesus iyan migkistigus aw migsuyat to seini, aw namaanan no tutuu to mgo kagi din. ");
INSERT INTO msmNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na, mahan-in pad yagboy to nangkahinang ni Jesus no wada igu no ogkasuyatan. Ko tibo pa nasuyat, kona buwa ogka-eg to mgo libru kani to kalibutan.");
INSERT INTO msmNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sir Teofilo, to diya una no insuyat ku, imbatbat ku to sinugdanan to diya tibo nahinang ni Jesus yakip to diya impang-anad din ");
INSERT INTO msmNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","3","kotob to diya pagbatuna kandin diya to yangit. To diya wada pad batuna si Jesus, pighimatajan sikandin di nabanhaw da. Sed to kap-atan no aedow, piglinogwa din sikan pinili din no mgo apustulis. Mahan-in to impakita din kandan no ogmatuud yagboy no nabanhaw sikandin. Imbatbat din isab kandan to paghari to Diyus aw ikagihi pinaagi to Ispiritu Santu to igpahinang kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Songo aedow no migsasayu sikandan to pagkoon, meyduon insugu din kandan no pig-iling, “Tagad kow kani to Jerusalem, su sikan ognangonon ku no Ispiritu Santu no insaad to Amoy ku madani on igbogoy iyu. ");
INSERT INTO msmNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","To diya una no panahon, wohig to imbawtismu ni Juan. Di kona da ogkapilaan, Ispiritu Santu on to igbawtismu iyu.” ");
INSERT INTO msmNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Songo aedow no nahimun to mgo apustulis duon ki Jesus, mig-usip sikandan, “Ginuu, seinid on iyan to panahon no oggawangon nu sikan namanmandu kanami aw tukudon nu manda to gingharian to Israel?” ");
INSERT INTO msmNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Migtabak si Jesus, “Kona kow ogmaanon dow nokoy panahona ubin aedawa to pigbootan to Diyus no Amoy no ogkahitabu sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Di seini da. Ogbogajan kow to gahom ko konsadan kow on to Ispiritu Santu. Na, ignawnangon a now kani to Jerusalem hasta to tibuuk Judea dow diya to Samaria aw inggad diya to kinasangkoan to kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tapus to pag-ikagi ni Jesus to sikan, nabatun sikandin diya to yangit. Namanyanghag sikan mgo apustulis su ogsaepan dan si Jesus, di wada dan on kitaa su nakahobong on sikandin duon to gabun. ");
INSERT INTO msmNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","No namanyanghag pad sikandan, natokawan sikandan to daduwa no ka otow no nangabo to maputi no migtindog duon to topad dan. ");
INSERT INTO msmNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kagi to sikan mgo anghil, “Sikiyu no mgo taga-Galilea, nokoy no aboy kow pad man ogyanghag? Si Jesus no pigbatun duon iyu pailing diya to yangit iyan mismu ogpauli dini to pasak sahian ka da to sikan pagbatuna kandin.” ");
INSERT INTO msmNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Dajun togbang sikan mgo apustulis likat to sikan Kaulibuhan no bubungan su ogpauli diya to Jerusalem no songo kilumitru da to kadiyu. ");
INSERT INTO msmNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pagtidow dan duon, migponhik sikandan duon to ikaduwa no andana to sikan bayoy no pigpaabutan dan. Sikandan si Pedro, si Juan, si Santiago, si Andres, si Felipe, si Tomas, si Bartolome, si Mateo, si Santiago no anak ni Alfeo, si Simon no maunungon to tribu dan, dow si Judas no anak ni Santiago. ");
INSERT INTO msmNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kanunoy sikandan mighihimun, aw to mgo hona-hona dan nasaboka to pag-ampu. Meyduon pad duma no naman-agpot kandan yakip si Maria no inoy ni Jesus dow duma no mgo bohi hasta to mgo suun ni Jesus no mgo yukos. ");
INSERT INTO msmNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Songo aedow meyduon nahimun no 120 no ka otow. Migtindog si Pedro aw ikagihi sikandan, ");
INSERT INTO msmNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Mgo suun ku, kinahangyan no matuman to diya impasuyat to Ispiritu Santu ki David duon to Kasuyatan bahin ki mina Judas. Su sikandin to diya mighindu ki Jesus to sikan namandakop kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Duma noy si Judas to diya una su pinili man isab sikandin ni Jesus to pagtrabahu to seini mgo hinangon noy.” Sikan to pig-ikagi ni Pedro. ");
INSERT INTO msmNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Na, to diya panahon no iyansang si Jesus duon to krus, imboli ni Judas to pasak sikan saepi no insuhue kandin to sikan madoot no hinang din. Duon sikandin kauyug no nakayangkob, migbotu to gotok aw kahakwad to tino-i. ");
INSERT INTO msmNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Sikan nahitabu ki Judas migtangkap diya to Jerusalem, kaling pighingadanan dan sikan pasak to Akeldama, no ko ita pa, Pasak no Nayangosahan. ");
INSERT INTO msmNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na, migpadajun si Pedro to pag-ikagi, “Mgo suun ku, nasuyat duon to Salmo no pig-iling, ‘Maojowan podom sikan pig-ugpaan din. Wadad podom muugpa duon.’ Meyduon isab nasuyat duon no pig-iling, ‘Meyduon podom makailis to katongdanan din.’ ");
INSERT INTO msmNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Kaling,” kagi ni Pedro, “manno wadad on si Judas, ogpili ki to songo otow no ig-ilis kandin. Kinahangyan no sobuuk sikandin to diya nakaduma-duma kanami dow ki Jesus no Ginuu ");
INSERT INTO msmNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","sugud to diya panahon no namawtismu si Juan kotob no batunon on si Jesus, agun makakistigus isab sikandin to pagkabanhaw ni Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Na, migtubuy sikandan to daduwa no ka otow, si Matias dow si Jose no pigngadanan isab ki Barsabas dow ki Justo. ");
INSERT INTO msmNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dajun sikandan ampu, “Ginuu, namaanan nu to inggad nokoy no nakased to ginhawa to tibo mgo otow. Kaling ihindu kanami dow andei to seini daduwa no ka otow to pigpili nud ");
INSERT INTO msmNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","no iyan ig-ilis ki Judas to pagka-apustul. Su pig-ojowan din to katongdanan din aw nakaandiyad to banwa no angay kandin.” ");
INSERT INTO msmNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tapus to pag-ampu, pigripa dan sikan daduwa, aw si Matias to naripahan. Dajun dan sikandin idugang to sikan sampuyu-tag-isa no mgo apustulis ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pag-abut on to sikan pista to mgo Hibru no og-ilingon to Aedow to Pentecostes, tibo to mgo magtutuu nahimun duon to songo bayoy. ");
INSERT INTO msmNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Puli sikandan natokow to dinabohong no napuun diya to yangit no migyokop duon to sed to bayoy. Angod sikan to hinodos to maagbot no kaemag. ");
INSERT INTO msmNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pigkita dan dajun to angod to mgo yogdog to kaeju no migsusuwoy-suwoy aw untud duon to kada sobuuk no nahimun duon. ");
INSERT INTO msmNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Duon-dajun piggahoman sikandan tibo to Ispiritu Santu aw nakaikagi to yain-yain no mgo inikagihan no wada dan anadi no impalituk kandan to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na, duon to sikan siyudad to Jerusalem meyduon isab diyusnon no mgo Hibru no nangkapuun diya to yain-yain no mgo nasyun. ");
INSERT INTO msmNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pagkadinog dan to sikan migsasamuk, natingkag sikandan. Hilabi sikandan natingaya su kada sobuuk nakadinog no nalituk to kaugalingon din no inikagihan. ");
INSERT INTO msmNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Naboyong yagboy sikandan aw pauusipay, “Nokoy man buwa to duon? Kona no mgo taga-Galilea man sikandan? ");
INSERT INTO msmNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Na, naamonu no ogdinogon ta man no og-ikagi sikandan to mgo inikagihan no nabuyatan to kada sobuuk ita? ");
INSERT INTO msmNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Su meyduon seini mgo duma ta no taga-Partia, taga-Media, taga-Elam, taga-Mesopotamia, taga-Judea, taga-Capadocia, taga-Ponto, taga-Asia, ");
INSERT INTO msmNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","taga-Frigia, taga-Pampilia, taga-Ehipto dow to duma no napuun diya to mgo banwa no sakup to Libya no dani to Cirene. Aw meyduon ngani taga-Roma ");
INSERT INTO msmNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","no mgo Hibru hasta kona no mgo Hibru no migpasakup to tinuuhan ta. Meyduon isab mgo taga-Creta dow taga-Arabia. Na, naamonu no ogpakabatbat man sikan mgo taga-Galilea to kabeynganan no mgo hinang to Diyus duon to inikagihan to kada sobuuk ita?” ");
INSERT INTO msmNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kaling hilabi natingaya sikan mgo otow dow nalibod aw pauusipay sikandan, “Nokoy man buwa to igpasabut to seini?” ");
INSERT INTO msmNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Di meyduon namanngingisi to sikan mgo magtutuu. Kagi dan, “Eh, mgo hingow!” ");
INSERT INTO msmNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dajun tindog si Pedro dow sikan duma din no sampuyu-tag-isa no mgo apustulis duon to atubangan to kaotawan, aw ikagi si Pedro to maagbot, “Sikiyu no angod ku no mgo Hibru dow tibo iyu no naman-ugpa kani to Jerusalem, paminog kow aw indani seini. ");
INSERT INTO msmNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nailing buwa to boot now no mgo hingow seini mgo duma ku. Di kona, su alas nuybe pad man to masem. ");
INSERT INTO msmNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Seini no hitabu kuntoon iyan katumanan to diya pigsuyat ni Joel no kibali ba-ba to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Seini to oghinangon ku diya to umaabut no panahon, kagi to Diyus. Igpakonsad ku to Ispiritu Santu duon to tibo yain-yain no kaotawan. To anak now no mgo yukos dow mgo bohi ogpakabatbat to igpaikagi ku. Meyduon igpasailow ku to batan-on no mgo yukos, aw meyduon isab igpatagainop ku to mgo manigaon. ");
INSERT INTO msmNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","To suguonon ku no mgo yukos dow mgo bohi ogpakonsadan ku to Ispiritu Santu diya to umaabut no panahon, su meyduon igpaikagi ku kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Kona pad on og-abut to mahinongdanon dow kabeynganan no aedow no siak no Ginuu oghukum to kaotawan, meyduon igpakita ku no mgo kabeynganan diya to yangit. Ogdigyom to soga, aw to buyan ogkaangod to yangosa to kayogdog. Meyduon isab igpakita ku no mgo kabeynganan dini to pasak no yangosa dow kaeju hasta madamey hilabi no obey. ");
INSERT INTO msmNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Di inggad hintawa no og-ampu kanay no Ginuu dinumahan to pagsalig ogkayuwas.’ ");
INSERT INTO msmNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Na,” kagi ni Pedro, “mgo suun ku no mgo kaliwat ni Israel, paminog kow kanay su igbatbat ku iyu si Jesus no taga-Nazaret. To pagpaandini kandin to Diyus pigmatuud pinaagi to diya mgo milagru dow duma no mgo kabeynganan no impabaja din ki Jesus. Namaan kow to sikan su pigkita now yagboy. ");
INSERT INTO msmNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Namaanan now isab to nadeygan ni Jesus su kibali indata sikandin iyu to Diyus, su tahan din man planu sikan. Na, sikiyu to migdata manda kandin diya to mgo otow no wada Diyus agun iyansang duon to krus. Pigpahimatajan now, ");
INSERT INTO msmNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","di pigbanhaw sikandin to Diyus. Pigyuwas din si Jesus to gahom to kamatajon su kona ogkahimu no tagonan sikandin to sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Su meyduon intag-an ni Hari David to diya una bahin kandin no pig-iling, ‘Kanunoy ku pigkita to Diyus kani to dani ku to pagpanalipod kanay. Kaling kona ogkaamonu to ginhawa ku. ");
INSERT INTO msmNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tongod to sikan, ogtukhow a hilabi. Kona ku ogkapogongan to pagsaja kandin, Su inggad mamatoy to yawa ku, meyduon da ogkaiman ku. ");
INSERT INTO msmNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Su namaan a no kona nu puli og-ojowan to umagad ku diya to banwa to mgo umagad, aw kona nu igtugut no madunut to yawa ku no pinadajag nu. ");
INSERT INTO msmNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pighinduan a nu to dayan pailing diya to matuud no kinabuhi, aw oglipajon a nu hilabi su madani ka man kanay.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Migpadajun si Pedro, “Mgo suun ku, hintawa man sikan ognangonon ni David? Sikandin buwa ko yain? Kona ogkahimu no sikandin. Bantugan iyan si Hari David no minuna, di nayugoy da kamatoy. Hangtod kuntoon ogkitaon ta pad sikan pigyobongan kandin, aw wada duwa-duwa no nadunut on to yawa din. ");
INSERT INTO msmNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Di manno kibali ba-ba to Diyus si David, tahan din on namaanan to panaad to Diyus no ogpaharion to sobuuk no kaliwat din no iyan ogpadajun to pagkahari din. ");
INSERT INTO msmNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Si Cristo yagboy sikan kaliwat ni David no ognangonon din, su sikandin man to pigbanhaw to Diyus. Kaling namaanan ta no wada ojowi to Diyus to umagad ni Jesus diya to banwa to mgo umagad. Sikan yawa din wada isab kadunut. ");
INSERT INTO msmNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Kistigus koy tibo su pigkita noy yagboy tapus sikandin banhawa. ");
INSERT INTO msmNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Na, pigbatun si Jesus diya to yangit aw paingkuda to Diyus duon to kalintuu no takidingan din no pinasidonggan no lugar. Imbogoy kandin to Ispiritu Santu no insaad kandin to Diyus no Amoy, aw ipakonsad din dini kanami kuntoon. Sikan to hinongdan to seini naaha dow nadinog now. ");
INSERT INTO msmNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Meyduon pad sinuyat ni David bahin to sikan pigbatun no pig-iling, ‘Mig-ikagi to Ginuu no Diyus diya to Agayon ku, Ingkud ka kani to kalintuu no takidingan ku kotob no daogon ku yagboy to mgo kuntra nu aw makayuhud duon to atubangan nu.’ Sikan ognangonon ni David kona man ogkailing no sikandin, su wada man sikandin batuna diya to yangit. Si Jesu-Cristo sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kaling sikiyu tibo no mgo kaliwat ni Israel, ligdongi now yagboy seini. Si Jesus no impayansang now duon to krus iyan pighinang to Diyus no Magboboot dow Hari.” ");
INSERT INTO msmNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pagkadinog to sikan mgo otow to wali ni Pedro, angod to pighiwa to ginhawa dan. Kaling nakapangusip sikandan ki Pedro dow to duma no mgo apustulis, “Mgo suun, og-amonu koy on man buwa?” ");
INSERT INTO msmNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Migtabak si Pedro, “Kada sobuuk iyu kinahangyan musosey to sae din aw talikudi. Pabawtismu kow isab to ngadan ni Jesu-Cristo. Na, ogkapasaylu to mgo sae now aw ogbogajan kow to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Su insaad man ni Jesu-Cristo no igbogoy din to Ispiritu Santu duon to kada sobuuk iyu no ogtawagon to Ginuu no Diyus ta, yakip to mgo anak now hasta inggad to mgo otow no naman-ugpa diya to madiyu.” ");
INSERT INTO msmNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nayuyugajan si Pedro to pagwali dow pagkumbinyu to sikan mgo otow. Kagi din, “Likoy kow agun kona kow makayakip to seini balingag no kaotawan kuntoon ko kastiguhon to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Na, migpabawtismu to diya mgo otow no migtuu to kagi ni Pedro. Kaling duon to sikan no aedow, nadugangan to tatoyu no libu sikan mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nasaboka to ginhawa dan. Ogpaminog sikandan to pagpang-anad to mgo apustulis aw og-ampu dow oghandom to kamatajon ni Jesus pinaagi to pagsasayu dan to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mahan-in to mgo milagru dow duma no mgo kabeynganan no pighinang to Diyus no impabaja to mgo apustulis. Kaling nasasakot to haedok dow katingaya to tibo mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kanunoy oghihimun to tibo mgo magtutuu dow ogpasasagapay. ");
INSERT INTO msmNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ko meyduon mgo suun to pagtuu no ogkalisod-lisod, dajun ogpamaligja to duma no mgo magtutuu to inggad nokoy no katigajunan dan agun matabangan to diya oglisod. ");
INSERT INTO msmNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kada aedow oghihimun sikandan duon to Bayoy to Diyus, aw ogsasayu isab to pagkoon duon to mgo bayoy dan. Malipajon sikandan dow mapaobsanon ");
INSERT INTO msmNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","no kanunoy ogsaja to Diyus. Nasaja sikandan to kaotawan, aw kada aedow mey ogkangkayuwas no indugang to Diyus duon kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Songo aedow, migduduma si Pedro dow si Juan diya to Bayoy to Diyus no alas tres to kahapunon no iyan uras no ig-ampu to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pagtidow dan duon to sikan yawanganan to Bayoy to Diyus no og-ilingon to Yawanganan no Madojow Og-ahaon, iyan naaha dan to otow no pulid sugud pad to pagkaotow din. Kada aedow ogdinaehon sikandin aw ibotang duon to dani to sikan yawanganan agun makapalimus sikandin to mgo otow no ogsed duon. ");
INSERT INTO msmNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na, pagkita din ki Pedro dow ki Juan no ogsed duon to Bayoy to Diyus, namuju sikandin to limus. ");
INSERT INTO msmNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pigyongyongan sikandin ni Pedro dow ni Juan, aw ikagi si Pedro, “Yagi, aha ka dini kanami.” ");
INSERT INTO msmNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Migyanghag dajun sikan limusan su nailing to boot din no meyduon iglimus kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","“Eh,” kagi ni Pedro, “wada yagboy saepi ku, di meyduon yain no igkabogoy ku ikow. Tongod to gahom to ngadan ni Jesu-Cristo no taga-Nazaret ogsuguon ku ikow, panow ka!” ");
INSERT INTO msmNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Dajun tagoni ni Pedro to kalintuu no boyad to sikan pulid aw patindoga. Duon-dajun migdoson to mgo kobong dow yoyoatan din. ");
INSERT INTO msmNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Hinggawan sikandin patitindog dow panow-panow aw duma ongki Pedro diya to sed to Bayoy to Diyus. Nakapanow-panow sikandin aw linaksu no migsaja to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pagkita to tibo mgo otow to pagpakapanow din no migsaja to Diyus, ");
INSERT INTO msmNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nadomdoman dan no sikandin naan to diya limusan no kanunoy og-ingkud duon to sikan Yawanganan no Madojow Og-ahaon. Kaling hilabi sikandan natingaya. ");
INSERT INTO msmNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Na, duon to pawa to sikan Bayoy to Diyus meyduon sikan og-ilingon to Hoyunganan ni Salomon. Duon titindog si Pedro dow si Juan hasta sikan bag-u kaulii no otow no aboy nanagon kandan. Mahan-in to mgo otow no namanlinaguy pailing diya kandan su nangkatingaya to pagkaulii to sikan pulid. ");
INSERT INTO msmNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pagkita ni Pedro to sikan mahan-in no mgo otow no nahimun, pig-ikagihan din sikandan, “Mgo suun ku no mgo kaliwat ni Israel, nokoy no naboyong kow man to seini otow? Nokoy no pigyongyongan koy now man? Unu kay ko mailing to ginhawa now no sikami to nakauli to seini no otow tongod to kaugalingon noy no gahom ubin pagkadiyusnon. ");
INSERT INTO msmNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Di kona, su iyan nakauli kandin to Diyus to mgo kaaw-apuan ta no si Abraham, si Isaac dow si Jacob. Pig-iling din to seini agun mapasidonggan sikan Suguonon din no si Jesu-Cristo. Di sikiyu, impadakop now sikandin, aw wada now tuguti si Gubernadur Pilato to pagsabuk kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Balaan si Jesus. Wada yagboy maligsom duon to ginhawa din, di pigsupak now aw hangyu kow no iyan nasi sabukan to kriminal. ");
INSERT INTO msmNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Anoy su si Jesus to ogpakabogoy to kinabuhi, iyan nasi pigpahimatajan now. Di pigbanhaw on sikandin to Diyus. Sikami to kistigus to sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na, nokoy man to nakauli to seini kiyaya now no pulid? Iyan da nakauli to gahom to ngadan ni Jesus dow to pagtuu kandin. Oho, aha kow. Madoson on yagboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mgo suun ku, sikiyu dow to mgo panguyu now migpahimatoy ki Jesus su wada now kamaani dow hintawa yagboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Di nailing to sikan agun matuman to Diyus to diya tahan din impatag-an. To diya tibo kibali mgo ba-ba din mig-iling no ogpaantuson sikan Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Na kuntoon sosey kow. Talikudi to mgo sae now aw iyan on atubangon now to Diyus agun mapapas to mgo sae now. ");
INSERT INTO msmNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ko tumanon now sikan, og-abut to panahon no ogbogajan kow to Ginuu to malinow no kinabuhi, su ogpabalikon din si Jesus no iyan ogpaharion din ita, su sikan man to tahan no planu din. ");
INSERT INTO msmNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Di ogpakamonang pad si Jesus diya to yangit kotob no bag-uhon on to Diyus to tibo agun ogpakaangod to kadojow to diya sinugdanan. Sikan to kagi to Diyus ita no impabaja to diya mgo otow no kibali ba-ba din. ");
INSERT INTO msmNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Su meyduon intag-an ni Moises bahin ki Jesus no pig-iling, ‘Diya to umaabut no panahon, meyduon angod kanay no ogpaandinihon iyu to Ginuu no Diyus now no kibali ba-ba din. Sikan no otow angod tanow da no Hibru. Kinahangyan no suguton now to tibo igsugu din iyu, ");
INSERT INTO msmNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","su tibo to kona ogpaminog kandin oggawangon duon to ginsakupan to Diyus aw ogpuuhon.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kagi manda ni Pedro, “Mgo suun, kona no si Moises da to migtag-an to seini nangkahitabu kuntoon. Su migtag-an isab to tibo kibali ba-ba to Diyus yakip si Samuel dow to diya namakasunu kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sikita to ogpaka-erinsya to sikan intag-an dan hasta isab to diya kasabutan to Diyus diya to mgo kaaw-apuan ta. Su pig-ikagihan din si Abraham no minuna ta no pig-iling, ‘Pinaagi to kaliwatan nu ogkamadojawan to tibo kaotawan kani to babow to kalibutan.’ ");
INSERT INTO msmNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kaling sikita no mgo Hibru iyan una no ogmadojawan to Diyus, su pigpaandini din si Jesus no Suguonon din agun no musosey ki aw ogpatalikudon ki din to mgo sae ta.” ");
INSERT INTO msmNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","No migwali pad si Pedro dow si Juan, meyduon migduguk kandan no mgo Saduseo dow mgo magdudumaya to tinuuhan to mgo Hibru hasta to panguyu to mgo magbantajay duon to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Naboyu sikandan ki Pedro dow ki Juan su nang-anad sikandan no nabanhaw on si Jesus, kaling meyduon isab aedow no ogbanhawon to tibo mgo patoy. ");
INSERT INTO msmNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Pigdakop dan si Pedro dow si Juan, di wada dajun imbistigaha su ogkadukilom on. Puli sikandan pigpakabukasan diya to prisuhan. ");
INSERT INTO msmNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Di inggad pad to sikan, mahan-in gihapun to diya namakadinog to wali dan no namanuu on. Na, to kahan-inan to mgo otow no migpasakup ki Jesu-Cristo mig-abut on to mgo lima no libu. ");
INSERT INTO msmNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pagkabukas, mighihimun duon to Jerusalem to mgo panguyu to mgo Hibru dow to mgo inila hasta to mgo maistru to tinuuhan. ");
INSERT INTO msmNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nakayakip duon si Anas no kinayabawan no magdudumaya to tinuuhan dow to mgo sakup to panimayoy din yakip si Caifas, si Juan, hasta si Alejandro. ");
INSERT INTO msmNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Dajun dan paatubanga si Pedro dow si Juan aw usipa, “Hintawa man gahom dow katongod to piggamit now to pagpapanow to seini pulid?” ");
INSERT INTO msmNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Si Pedro no piggahoman to Ispiritu Santu migtabak, “Tinahud no mgo panguyu dow mgo inila noy no mgo kaliwat ni Israel, ");
INSERT INTO msmNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ko iyan ing-imbistigaha kanami kuntoon tongod to diya madojow no nahinang noy to seini otow no tahan pulid, na, ognangonan ku sikiyu dow naamonu to pagkaulii din. ");
INSERT INTO msmNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Kinahangyan no mamaan kow dow to tibo mgo kaliwat ni Israel no naulian seini otow no migtindog kani to atubangan now tongod to gahom ni Jesu-Cristo no taga-Nazaret. Impayansang now sikandin duon to krus aw kamatoy, di pigbanhaw to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sikandin to diya ognangonon duon to Kasuyatan to Diyus no pig-iling, ‘Sikan batu no pig-ojowan now no mgo pandoy su nailing to boot now no wada pues iyan nasi indigon to bayoy.’ ");
INSERT INTO msmNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Si Jesus da to ogpakayuwas ita, su wada yain dini to babow to kalibutan no imbogoy to Diyus ita agun mayuwas ki.” ");
INSERT INTO msmNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pagkita to sikan mgo panguyu dow mgo inila no masaligon onsi Pedro to pag-ikagi, natingaya hilabi sikandan su namaanan dan no kona sikandan no idukadu, su yanu puli to pagkaotow dan. Di nadomdoman dan no gin-anow nailing to sikan su nakaduma-duma man naan sikandan ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sikan mgo maghusajay wada makatabak to pig-ikagi ni Pedro dow ni Juan. Wada kalidung sikan milagru no nahinang dan, su pigkita dan man yagboy sikan otow no naulian no migtindog duon to topad onni Pedro. ");
INSERT INTO msmNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kaling pigpayuwas dan naa onsi Pedro to sikan husajan. Dajun sikandan hihimanu no mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Og-amonuhon tad man sikan no mgo otawa? Su to tibo mig-ugpa dini to Jerusalem namaan to sikan kabeynganan yagboy no milagru no nahinang dan. Konad sikan ogkalidung. ");
INSERT INTO msmNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Di kinahangyan no konad on ogtangkap sikan igpang-anad dan. Kaling ogpinahan ta sikandan to konad paglituk to ngadan ni Jesus diya to inggad hintawa.” ");
INSERT INTO msmNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Dajun dan manda paseda si Pedro dow si Juan aw pinahi no konad yagboy ogpang-anad ubin og-ikagi bahin ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Di mig-ikagi onsi Pedro, “Nokoy man to hona-hona now? Sikiyu to’g tumanon ko Diyus? ");
INSERT INTO msmNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Di sikami, kona ogkahimu no kona noy ikanawnangon sikan pigdinog aw pigkita noy no mgo hinang dow kagi ni Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dajun dan manda pak pinahi aw sabuki su wada man napasikadan to pagkastigu kandan. Nahaedok isab sikandan to kaotawan, su to tibo mgo otow migsaja to Diyus tongod to pagkaulii to sikan pulid. ");
INSERT INTO msmNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Migdugang yagboy to kabantug to sikan no milagru su subra on to kap-atan no tuig to pagkapulid din. ");
INSERT INTO msmNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","No sabukan on si Pedro dow si Juan, migpadajun sikandan diya to mgo kadumahan dan aw nangoni to pig-ikagi to sikan mgo maghusajay. ");
INSERT INTO msmNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Pagkadinog to mgo magtutuu to sikan, mighihimun sikandan aw ampu, “Ginuu no Magboboot to tibo, sikuna to mighinang to yangit, to pasak, to dagat dow to tibo namakabotang duon. ");
INSERT INTO msmNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Sikuna to mig-ikagi no impabaja ki David no suguonon nu. Minanduan to Ispiritu Santu, mig-iling sikandin, ‘Nokoy no naboyu man sikan kona no mgo Hibru? Nokoy no migyangub man to mgo Hibru to pagsupak to Ginuu? Wada buwa sikandan kamaan no wada pues to sikan? ");
INSERT INTO msmNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mighihimun to mgo hari dow duma no namanmandu kani to kalibutan su ogsupakon dan to Ginuu no Diyus dow sikan ogpaharion din.’ ");
INSERT INTO msmNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Na Ginuu,” kagi dan, “namaan koy no bag-u pad sikan katuman kani to Jerusalem. Su si Hari Herodes dow si Gubernadur Poncio Pilato migpagsaboka to sikan mgo Hibru hasta to diya kona no mgo Hibru su ogsupakon dan sikan Balaan no Suguonon nu no si Jesus no iyan ogpaharion nu. ");
INSERT INTO msmNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Di sikuna Ginuu iyan migboot to sikan pighinang dan agun matuman sikan tahan nud pigplanu pinaagi to gahom nu. ");
INSERT INTO msmNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Na, aha ka Ginuu, su pigpatahanan koy dan. Bogaji koy no mgo sakup nu to buyut agun kona koy mahaedok to pagnawnangon to kagi nu. ");
INSERT INTO msmNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipakita to kaotawan to gahom nu. Maulian podom to mgo masakiton. Mahinang isab podom to mgo milagru dow duma no mgo kabeynganan pinaagi to gahom to ngadan ni Jesus no Balaan no Suguonon nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Pagkatapus to pag-ampu dan, nahojong sikan pighihimunan dan. Dajun sikandan tibo piggahoman to Ispiritu Santu aw wadad haedok no mignawnangon to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nasaboka to tibo mgo magtutuu. Wada og-iling, “Kanay da seini,” ko kona no ogsinagapay sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Piggahoman kanunoy to Diyus to mgo apustulis to pagnawnangon to pagkabanhaw ni Jesus no Ginuu, aw pigtabangan din yagboy to tibo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Wada sobuuk kandan no pigkabusan to kinahangyanon su ko meyduon ogkalisodan, sikan mey pasak dow bayoy ogpamaligja, ");
INSERT INTO msmNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aw to halin igsalig dan diya to mgo apustulis agun iyan ogbahin-bahin sibu to kinahangyanon to kada sobuuk. ");
INSERT INTO msmNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na, si Jose no taga-Cipre sobuuk to sikan mgo magtutuu. Hibru isab sikandin no kaliwat ni Levi. Pigdagnajan sikandin to mgo apustulis ki Bernabe, no ko ita pa, Magdasigay. ");
INSERT INTO msmNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Migbaligja sikandin to pasak aw to halin insalig din diya to mgo apustulis agun ipamogoy. ");
INSERT INTO msmNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Meyduon isab otow no migbaligja to pasak no iyan ngadan si Ananias, aw sikan asawa din si Safira. ");
INSERT INTO msmNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pagkahalin to sikan pasak dan, pig-uujunan dan no mag-asawa no ogsalinan sikan halin ayha ighatod diya to mgo apustulis. Na, pagbogoy ni Ananias to sikan saepi diya to mgo apustulis, ");
INSERT INTO msmNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","pig-ikagihan sikandin ni Pedro, “Eh, nokoy no migpatintal ka man ki Satanas? Nokoy no pigginayuan nu man to Ispiritu Santu? Su namaan a no pighipidan nu to duma no halin to diya pasak nu. ");
INSERT INTO msmNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","No wada nu pad ibaligja sikan pasak, ikow man sikan. Aw pagbaligja nud, to halin ikow man to ogpakaboot. Nokoy no mig-iling ka man no imbogoy nu kanami to tibo halin? Sikami da podom to pigginayuan nu, di yabow no nakaginayu ka to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Pagkadinog ni Ananias to sikan, dajun sikandin natuad aw kabigtawi. Sikan yawa din pigtongos to mgo batan-on no yukos aw daeha diya to yuwas su igyobong. Nangkahaedok to tibo no namakadinog to sikan nahitabu. ");
INSERT INTO msmNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Anoy man no pigtatoyuhan on no uras, migyupug sikan asawa ni Ananias, di wada pad sikandin kamaan to nahitabu to sikan bana din. ");
INSERT INTO msmNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Dajun ipakita kandin ni Pedro sikan saepi no imbogoy to diya bana din aw usipa, “Seini da iyan to tibo halin to sikan pasak no imbaligja now?” Migtabak si Safira, “Hoo, sikan da iyan.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Kaling mig-iling si Pedro, “Nokoy no mig-uujun kow man to pag-anti to Ispiritu to Ginuu? Oho, sujad on to mgo otow no migyobong to bana nu. Sikuna isab ogyayahungan dan diya to yuwas su igyobong. ");
INSERT INTO msmNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Dajun natuad si Safira duon to atubangan ni Pedro aw kamatoy. Pagtidow to sikan mgo batan-on, pigkita dan no patoy on si Safira. Dajun dan yayahungi padeg diya to yuwas aw iyobong duon to topad to bana din. ");
INSERT INTO msmNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hilabi nangkahaedok to tibo mgo magtutuu to sikan nahitabu hasta inggad hintawa no nakadinog. ");
INSERT INTO msmNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Mahan-in to nahinang to sikan mgo apustulis no mgo milagru dow duma no mgo kabeynganan no pigkita to kaotawan. Sikandan dow to tibo duma no mgo magtutuu oghihimun duon to sikan Hoyunganan ni Salomon no duon to pawa to Bayoy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pigtahud sikandan to mgo otow no wada tuu ki Jesus, di wada sikandan yangub to pag-agpot. ");
INSERT INTO msmNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Inggad pad sikan on, kanunoy gihapun mahan-in to mgo yukos dow bohi no migpasakup to Ginuu aw nakadugang to sikan mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tongod to mgo milagru no nahinang to mgo apustulis, mahan-in to mgo masakiton no pigdaya duon kandan. To mgo hibatanan dan duon igbotang to kilid to sikan ogbajaan ni Pedro, su basi da man matopadan sikandan to yambung din ko muyaboy sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mahan-in isab to namantidow likat to kayunsudan duon to nakalibong to Jerusalem no migdaya to mgo masakiton hasta to diya pigpansamuk to madoot no ispiritu. Nangkaulian sikandan tibo. ");
INSERT INTO msmNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Na, sikan kinayabawan no magdudumaya to tinuuhan to mgo Hibru dow to tibo duma din no mgo Saduseo migsilag hilabi to mgo apustulis. ");
INSERT INTO msmNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kaling pigdakop dan aw prisuha. ");
INSERT INTO msmNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Di sikan no kadukiloman, pigyogwa sikan mgo apustulis to anghil to Ginuu. Pig-abri din to mgo pertahan to sikan prisuhan aw payuwasa sikandan. Kagi to sikan anghil, ");
INSERT INTO msmNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Andiya kow to Bayoy to Diyus aw itibo i-anad to mgo otow sikan bag-u no kinabuhi no igbogoy ni Jesu-Cristo.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Kaling pagkabukas, saju to kamasemon, mig-andiya sikandan to Bayoy to Diyus aw pang-anada to kaotawan. Duon to iyan da no kamasemon, sikan kinayabawan no magdudumaya to tinuuhan dow to mgo duma din mighimun to tibo maghusajay to mgo kaliwat ni Israel. Impadokat dan to mgo apustulis duon to prisuhan su ogpaatubangon dan. ");
INSERT INTO msmNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Di pagtidow to sikan mgo sinugu, puli migjopot to pilok dan su wadad on sikan mgo apustulis duon to prisuhan. Dajun sikandan pauli diya to husajan aw ikagi, ");
INSERT INTO msmNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Adoy Sir, wadad on to diya mgo otow! Madigon man to pagkasira to pertahan, aw to mgo magbantajay tibo man duon. Di pag-abri noy, wadad on sikan mgo prisu duon.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Pagdinog to mgo magbantajay to Bayoy to Diyus dow sikan yabow no mgo magdudumaya to tinuuhan, nalibod hilabi sikandan aw nakapauusipay dow nokoy on to ogkadeygan to sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Na, meyduon migtidow no mig-iling, “Oho, sikan mgo otow no pigprisu now gabii, dutun on to pawa to Bayoy to Diyus no nang-anad to mgo otow!” ");
INSERT INTO msmNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Dajun panow sikan panguyu to mgo magbantajay duma to mgo sakup din aw daeha sikan mgo apustulis. Di wada dan amonuha su nahaedok ko batuhon sikandan to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pigpaatubang sikan mgo apustulis duon to mgo maghusajay aw pangabey-i to sikan kinayabawan no magdudumaya to tinuuhan. ");
INSERT INTO msmNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Kagi din, “Pigpinahan noy on sikiyu no kona now on igpang-anad sikan no otawa. Di nasi now on impatangkap sikan impang-anad now kani to Jerusalem. Impasabut now man ngani no sikami to angajan no ogbasuyon to kamatajon din.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Dajun tabak si Pedro dow to duma din no mgo apustulis. Kagi din, “Kinahangyan no iyan ogtumanon noy to sugu to Diyus, kona no otow. ");
INSERT INTO msmNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","To Diyus to mgo kaaw-apuan ta iyan migbanhaw ki Jesus no impayansang now duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Na, kuntoon pigpasoing on sikandin duon to kalintuu no takidingan to Diyus agun mapasidonggan. Pigbogajan sikandin to Diyus to katongod to pagka-Agayon dow pagka-Manyuyuwas agun no musosey ki aw patalikudan din ita no mgo kaliwat ni Israel to mgo sae ta, agun isab mapasaylu ki din. ");
INSERT INTO msmNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sikami to ogmatuud to sikan hasta to Ispiritu Santu no igbogoy to Diyus to diya ogtuman to mgo sugu din.” ");
INSERT INTO msmNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pagdinog to sikan mgo maghusajay to kagi ni Pedro, pigyangotan hilabi sikandan. Kaling oghimatajan dan podom sikan mgo apustulis. ");
INSERT INTO msmNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Di si Gamaliel migtindog su og-ikagi. Songo Pariseo sikandin no maistru to tinuuhan no tinahud to tibo mgo otow. Dajun sikandin sugu no payuwason naa sikan mgo apustulis ");
INSERT INTO msmNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","aw ikagi, “Mgo suun ku no mgo kaliwat ni Israel, kona ki puli ogyagmak to paghukum to sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Basi kay nalingawan now on si Teudas no kunungkun inila. Meyduon nasakup din no mgo upat no gatus no ka otow. Di pighimatajan da sikandin aw to mgo sakup din nasusuwoy-suwoy. Na, nokoy man to nahimu dan? Wada! ");
INSERT INTO msmNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","To diya isab pagsugu to gubernu to pagpalista to mgo otow, meyduon taga-Galilea no iyan ngadan si Judas. Mahan-in to nasakup din, di pighimatajan isab sikandin aw kasusuwoy-suwoy to tibo mgo sakup din. ");
INSERT INTO msmNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kaling mgo suun ku, kona ta oghilabotan sikan no mgo otow, su ko pig-otawan puli to mgo planu dow hinang dan, ogkagawang da. ");
INSERT INTO msmNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Di ko Diyus to napuunan, kona now yagboy sikandan ogkadaog. Unu ko mailing nasi no Diyus naan to og-atuhan now!” Pagdinog to sikan mgo maghusajay to sambag ni Gamaliel, mig-ujun sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Di pigpased dan manda to mgo apustulis aw palinapdosi. Pagkatapus, pigpinahan dan manda no kona dan on yagboy igpang-anad si Jesus. Dajun sikandan sabuki. ");
INSERT INTO msmNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Na, migpanow sikan mgo apustulis no malipajon, su pig-isip dan no dongog to pag-antus to kasikawan su sakup man sikandan ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Migpadajun sikandan to pagnawnangon no si Jesus to diya Insaad no Manyuyuwas. Kada aedow ogpang-anad aw ogpangwali sikandan diya to Bayoy to Diyus hasta diya to kabaejan to mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","To diya no panahon, meyduon daduwa no grupu no mgo magtutuu: mgo Hibru no Grigu to inikagihan, dow nitibu no mgo Hibru. Na, paghan-in on to mgo otow no migpasakup ki Jesus, migbagutbut sikan mgo Hibru no Grigu to inikagihan, su to bayu dan no mgo bujag ogyabay-yabajan to nitibu no mgo Hibru ko ogpamogoy to inaedow-aedow no ogkabuhian. ");
INSERT INTO msmNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Pagkadinog to sikan sampuyu-tag-duwa no mgo apustulis to sikan pagbagutbut, pighimun dan to tibo magtutuu aw ikagihi, “Mgo suun, kona no angajan ko sikami to ogdumaya to pagpamogoy to ogkabuhian to mgo bayu. Iyan ogpayabihon noy to pagwali to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kaling madojow ko mupili kow to pitu no ka yukos duon iyu no maalamon dow togob to Ispiritu Santu. Sikandan to ogsaligan noy to sikan no trabahu ");
INSERT INTO msmNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","agun ogkatibuyus to kanami no hinangonon no pag-ampu dow pagwali.” ");
INSERT INTO msmNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nasajaan to mgo magtutuu to sikan planu to mgo apustulis. Sobuuk no pigpili dan si Esteban no madigon yagboy to pagtuu to Diyus aw togob to Ispiritu Santu. Pigpili dan isab si Felipe, si Procoro, si Nicanor, si Timon, si Parmenas, dow si Nicolas no taga-Antioquia. Si Nicolas kona no Hibru, di migpasakup on tahan to tinuuhan dan. ");
INSERT INTO msmNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pagkatapus to sikan, pigdaya diya to mgo apustulis sikan mgo otow no nangkapili. Dajun ampu sikan mgo apustulis aw bogaji sikan pitu no mgo pinili to katongod pinaagi to pagsampoyong kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","To mgo magtutuu migpadajun to pagnawnangon to kagi to Diyus. Mahan-in to mgo otow diya to Jerusalem no migpasakup ki Jesus yakip to mahan-in no mgo magdudumaya to tinuuhan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na, si Esteban natogob to panalangin to Diyus aw maaslag to gahom no imbogoy kandin. Mahan-in to mgo milagru dow duma no mgo kabeynganan no nahinang din no pigkita to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Di meyduon migsupak kandin no mgo sakup to simbahan to mgo Hibru no og-ilingon to Simbahan to mgo Udipon no Sinabukan. Mgo Hibru sikandan no taga-Cirene, taga-Alejandria, taga-Cilicia dow taga-Asia. Migpagdibati sikandan ki Esteban, ");
INSERT INTO msmNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","di wada dan kadaog tongod to kaalam no imbogoy kandin to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kaling meyduon mgo otow no pigsabut dan to paghapey ki Esteban. Kagi dan, “Iling kow, nadinog noy si Esteban no migpasipaya ki Moises dow to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pigpabuyutan dan to kaotawan dow to mgo maistru to tinuuhan hasta to duma no mgo inila. Dajun dan dakopa si Esteban aw paatubanga diya to husajan. ");
INSERT INTO msmNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Meyduon manda pigsabut dan no pila no ka otow to pagkistigus to gayu. Mig-iling sikandan, “Si Esteban aboy ogpasipaya to seini Bayoy to Diyus hasta to mgo balaod to tinuuhan ta. ");
INSERT INTO msmNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Su pigdinog noy to kagi din no oggobaon kun ni Jesus no taga-Nazaret seini Bayoy to Diyus. Hasta og-isabon din kun to mgo tumanon no imbilin ita ni Moises.” ");
INSERT INTO msmNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pagdinog to sikan mgo maghusajay to sikan ginayu no pagkistigus, pigyongyongan dan si Esteban. Naaha dan no naisab to bayhu din aw naangod on to bayhu to anghil. ");
INSERT INTO msmNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Na, mig-usip ki Esteban sikan kinayabawan no magdudumaya to tinuuhan to mgo Hibru, “Tutuu iyan sikan inriklamu dan kuntra ikow?” ");
INSERT INTO msmNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Migtabak si Esteban, “Talahudon no mgo inila dow mgo suun ku, paminog kow. Namaan kow no si Abraham no minuna ta pigyogwa to gamhanan no Diyus. Duon pad sikandin ugpa to Mesopotamia, wada pad makabalhin diya to Haran. ");
INSERT INTO msmNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Mig-ikagi to Diyus kandin, ‘Ojowi sikan banwa nu dow mgo kasuunan nu aw balhin ka diya to banwa no ighindu ku ikow.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Dajun ojowi ni Abraham sikan banwa din no Caldea aw balhin diya to Haran. Pagkamatoy on to amoy din, pigpabalhin manda sikandin to Diyus kani to seini pig-ugpaan ta kuntoon. ");
INSERT INTO msmNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pagtidow din kani, wada imbogoy kandin to Diyus no pasak, inggad mae-payad da. Di migsaad da sikandin no og-abut to panahon no igbogoy din seini pasak ki Abraham agun ogka-erinsya to mgo kaliwat din, inggad wada pad isab anak din to diya no panahon. ");
INSERT INTO msmNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Meyduon pad pig-ikagi to Diyus kandin no pig-iling, ‘Diya to umaabut no panahon, to mgo kaliwat nu ogkahinang no yampot diya to yain no banwa. Ogkaudipon sikandan duon aw ogdaog-daogon sed to upat no gatus no tuig. ");
INSERT INTO msmNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Di ogkastiguhon ku sikan nasyun no og-udipon kandan. Pagkatapus to sikan, ogyagujan dan sikan no nasyun aw ogpauli dini, aw kani a dan da ogsimbahon.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Migpadajun si Esteban to pag-ikagi, “Insugu to Diyus ki Abraham no tulion to tibo mgo yukos no sakup din yakip to mgo kaliwat din pagpakiyaya no nayakip sikandan to sikan kasabutan to Diyus ki Abraham. Kaling pigtuli ni Abraham si Isaac no anak din no nawayuhan on no aedow. Angod da to pagtuman ni Isaac to sikan no tumanon no maotow si Jacob no anak din. Pigtuman isab ni Jacob sikan duon to sikan mgo anak din no sampuyu-tag-duwa no mgo kaaw-apuan ta. ");
INSERT INTO msmNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Na, si Jose no sobuuk no anak ni Jacob pigsilagan to mgo kakoy din. Kaling imbaligja dan sikandin aw kaudipon diya to nasyun to Ehipto. Di pigdumahan sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pigyuwas din si Jose to tibo mgo kalisod. Su pag-aha to sikan hari to Ehipto to sikan kaalam no imbogoy kandin to Diyus, pigsaja din si Jose aw bogaji to katongdanan to pagka-gubernadur to tibuuk gingharian din. Insalig isab ki Jose to tibuuk panimayoy din. ");
INSERT INTO msmNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Anoy man no nayugoy-yugoy on, mig-abut to maagbot no bontas duon to tibuuk nasyun to Ehipto hasta diya to banwa to Canaan. Hilabi nalisodan to tibo mgo otow, aw sikan mgo kaaw-apuan ta wadad on mgo pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kaling, no makadinog si Jacob no amoy dan no meyduon pagkoon diya to Ehipto, pigsugu din sikan mgo anak din to pag-andiya. Sikan to una no pag-andiya dan to Ehipto to pagboli to pagkoon. ");
INSERT INTO msmNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Duon to ikaduwa no pag-andiya dan to Ehipto, migpakiyaya si Jose to sikan mgo suun din aw nakiyayahan isab to mgo suun din to sikan hari. ");
INSERT INTO msmNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Dajun tuguni ni Jose sikan amoy din no si Jacob to pagbalhin diya to Ehipto hasta tibo to panimayoy din. Kapituan-mey-lima sikandan tibo. ");
INSERT INTO msmNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dajun andiya si Jacob to Ehipto duma to tibo mgo sakup din. Duon sikandin kamatoy hasta sikan mgo anak din no mgo kaaw-apuan ta ");
INSERT INTO msmNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","aw daeha kani to seini banwa dan. Duon sikandan iyobong to sikan yobonganan no kuyba diya to Siquem no naboli ni Abraham likat to mgo kaliwat ni Hamor. ");
INSERT INTO msmNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Na,” kagi isab ni Esteban diya to mgo maghusajay, “no madani on ogtumanon to Diyus to diya insaad din ki Abraham no ogpabalikon to mgo kaliwat din dini to banwa dan, mighan-in on hilabi sikandan diya to Ehipto. ");
INSERT INTO msmNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Duon to sikan no panahon, meyduon bag-u no mig-ingkud to paghari duon to Ehipto no wadad on kamaan ki Jose. ");
INSERT INTO msmNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pigtuntu to sikan hari to mgo kaaw-apuan ta aw daog-daoga dow paojowi to mangkaintok no mgo bata dan agun mangkamatoy. ");
INSERT INTO msmNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“To diya no panahon meyduon ing-anak no kona no puli-puli no bata no iyan ngadan si Moises. Sed to tatoyu no buyan pig-atiman sikandin duon to bayoy to ginikanan din. ");
INSERT INTO msmNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Di mig-abut to panahon no konad on sikandin igkahobong duon to bayoy. Na, iyan ingkadojow su no ikayuwas on sikandin, pigsagop to bohi no anak to hari aw buhi-a din no angod to tinood din no anak. ");
INSERT INTO msmNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Pig-anad sikandin to tibo namaanan to mgo Ehiptuhanon hangtod no nabantug sikandin tongod to pagpang-ikagi din dow mgo hinang. ");
INSERT INTO msmNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Anoy man no kap-atan on no tuig to idad ni Moises, migyouy sikandin to sikan angod din no mgo kaliwat ni Israel. ");
INSERT INTO msmNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pagtidow din, pigkita din to sobuuk kandan no pigdaog-daog to songo Ehiptuhanon. Piggapian din sikan angod din no Hibru aw himataji sikan Ehiptuhanon. ");
INSERT INTO msmNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nailing to boot ni Moises dow ogpakasabut sikan angod din no mgo Hibru no sikandin to pigpili to Diyus to pagyuwas kandan to sikan madoot no kinogdan dan. Di wada man sikandan makasabut. ");
INSERT INTO msmNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pagkasunu no aedow, pigkita ni Moises to daduwa no mgo Hibru no migbubuyow. Oghusajon din podom, kaling mig-ikagi sikandin, ‘Yagi, ajaw kow og-uunoy ogbubuyow su migsusuun kow da.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Di ingwakli si Moises to sikan otow no migyupig to sikan sobuuk aw ikagi, ‘Eh, hintawa ka man no ogmandu dow oghusoy kanami? ");
INSERT INTO msmNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Basi kay ig-angod a nu to paghimatoy nu to diya Ehiptuhanon gabii.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Pagkataga ni Moises no namaanan on to paghimatoy din to diya Ehiptuhanon, migyaguy sikandin aw yampot diya to Midian. Duon to sikan no banwa, naotow sikan daduwa no anak din no mgo yukos. ");
INSERT INTO msmNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Anoy man no migyaboy on manda to kap-atan no tuig, meyduon migyogwa ki Moises no angod to anghil duon to masagkop no kaju no migyogdog duon to sikan matahay no banwa no madani to bubungan to Sinai. ");
INSERT INTO msmNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Pagkita ni Moises to sikan, naboyong sikandin kaling migpadani su ogdeyjawon din og-ahaon. Di no madanihan din on, nadinog din to tingog to Ginuu no mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Siak to Diyus to mgo minuna nu no si Abraham dow si Isaac hasta si Jacob.’ Pagkadinog ni Moises to tingog to Ginuu, migpidpid sikandin tongod to haedok no wadad makayangub to pag-aha. ");
INSERT INTO msmNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Dajun ikagi to Ginuu, ‘Hukasa to sapatus nu su balaan seini pigtindogan nu no pasak, su kani ka yogwaa to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Oho, naaha ku to mapoit no pagpaantus to kaotawan ku diya to Ehipto. Nadinog ku to mgo pag-agoyo dan, kaling migkonsad a su ogyuwason ku sikandan. Na Moises, ogsuguon ku sikuna diya to Ehipto.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na,” kagi manda ni Esteban, “to diya una, si Moises wada iyan dawata to mgo Hibru su mig-iling sikandan, ‘Hintawa ka man no ogmandu dow oghusoy kanami?’ Di sikandin naan to pigsugu to Diyus to pagmandu dow pagyuwas kandan. Pigbuligan sikandin to Diyus no migpabayuy no anghil no migyogwa kandin duon to sikan masagkop no kaju. ");
INSERT INTO msmNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Si Moises to migdae to sikan mgo Hibru no muyaguy sikandan likat to Ehipto. Sikandin isab to mighinang to mgo milagru dow kabeynganan diya to Ehipto aw duon to sikan og-ilingon to Mayogdog no Dagat hasta diya isab to matahay no banwa no makapanow-panow to diya mgo Hibru sed to kap-atan no tuig. ");
INSERT INTO msmNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Si Moises iyan mig-ikagi diya to angod din no mgo kaliwat ni Israel no mig-iling, ‘Diya to umaabut no panahon, meyduon angod kanay no ogpaandinihon iyu to Diyus no kibali ba-ba din. Sikan no otow angod tanow da no kaliwat ni Israel.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Paghihimun to diya mgo kaaw-apuan ta diya to matahay no banwa no duon to Bubungan to Sinai, si Moises to pig-ikagihan to Diyus no migpabayuy no anghil. Duon din isab kadawat sikan kagi to Diyus no ogpakabogoy to kinabuhi, aw ibilin din isab dini ita. ");
INSERT INTO msmNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Di sikan mgo kaaw-apuan ta wada yagboy kaliyag ki Moises. Wada dan suguta to sugu din. Su iyan pighandom dan to kinabuhi diya to Ehipto. ");
INSERT INTO msmNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kaling no nayugoy on si Moises duon to sikan bubungan, pig-ikagihan dan si Aaron, ‘Hinangi koy on to mgo diyus-diyus no iyan ogdae ita. Su indoy dow nokoy on to nadeygan to kani otow no migdaya ita likat to Ehipto.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kaling mighinang sikandan to diyus-diyus no impaaw-angod to nati no baka. Dajun dan haladi to pigtutung dan no mananap aw migkinalipay to pagpahinongod to sikan pighinang dan no diyus-diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kaling pigtalikudan sikandan to Diyus aw pabay-ani no iyan simbahon dan to mgo sumisilat diya to yangit. Sikan to ognangonon to Diyus no impasuyat din to songo otow no kibali ba-ba din no pig-iling, ‘Sikiyu no mgo kaliwat ni Israel, kagi to Diyus, meyduon ig-usip ku iyu. No duon kow pad ugpa to matahay no banwa sed to kap-atan no tuig, siakon buwa to pighaladan now to ogtutungon no mgo mananap? Siakon to pigtuman now? ");
INSERT INTO msmNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kona, su pigdaya-daya now sikan bayoy-bayoy no og-ampuan now ki Moloc. Pigdaya-daya now isab si Repan no impaaw-angod to bituon. Sikan kan mgo diyus-diyus no pighinang now no iyan pigtuman now. Kaling ogbootan ku no bihagon kow aw daeha diya to kaylu pad to Babilonia.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Na, migpadajun si Esteban to pag-ikagi no mig-iling, “No diya pad to mgo kaaw-apuan ta to sikan matahay no banwa, meyduon tulda no simbahan no pigdaya-daya dan no ogpakiyaya no migduma-duma to Diyus kandan. Paghinang dan to sikan, pigsunud dan sikan impakita to Diyus ki Moises. ");
INSERT INTO msmNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Na, pagkamatoy ni Moises, si Josue to mig-ilis kandin to pagdaya kandan kani to seini no banwa. Sikan tulda no na-erinsya dan, pigdaya dan no mailog dan seini pasak to diya una no naman-ugpa kani no pig-abug to Diyus. Duon sikandan simba to sikan tulda kotob to panahon ni Hari David. ");
INSERT INTO msmNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nasajaan to Diyus ki David. Mighangyu sikandin to Diyus no pahinangon sikandin to Bayoy to Diyus no iyan pigsimba ni Jacob no minuna din. ");
INSERT INTO msmNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Di si Salomon no anak ni David iyan nasi nakahinang. ");
INSERT INTO msmNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Di,” kagi ni Esteban, “to Diyus no Yabow to Tibo kona yagboy og-ugpa duon to bayoy no hininang to otow. Su meyduon kibali ba-ba to Diyus no mig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘To yangit iyan trunu ku, kagi to Ginuu, aw to pasak iyan untudanan to kobong ku. Na, man-u da man to bayoy no oghinangon now kanay! ");
INSERT INTO msmNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Su siak to mighinang to tibo yangit dow pasak.’ ");
INSERT INTO msmNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Na mgo suun ku,” kagi ni Esteban, “angod kow da to mgo otow no wada Diyus, su mangkadoson to uyu now. Migmaojow kow to pagpaminog dow pagtuu. Masinupakon kow to Ispiritu Santu angod to diya mgo kaaw-apuan now. ");
INSERT INTO msmNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Hintawa man to igkahindu now no songo otow no kibali ba-ba to Diyus to diya una no wada dan paantusa? Pigpanghimatajan dan man ngani to diya namanag-an to pagtidow to sikan matarong no Suguonon to Diyus no si Jesus. Na, pagtidow din on, pigsunud now to batasan dan su pigyuiban now aw pahimataji. ");
INSERT INTO msmNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anoy su sikiyu to nakadawat to diya mgo balaod to Diyus no impabaja to mgo anghil, wada now hinuun tumana.” ");
INSERT INTO msmNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pagkadinog to sikan mgo maghusajay to kagi ni Esteban, migpangagot to mgo ngipon dan su hilabi pigyangotan. ");
INSERT INTO msmNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Di si Esteban no togob to Ispiritu Santu migyanghag diya to yangit, aw pigkita din to kasiga to Diyus hasta si Jesus no nakatindog duon to kalintuu no takidingan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kagi ni Esteban, “Oho! Aha kow to suja yangit no naabri! Ogkaaha ku si Jesus no og-ilingon no Anak to Otow no migtindog on duon to kalintuu no takidingan to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dajun sikandan namangiyak aw sampongi to mgo talinga dan. Migdodongan sikandan migdagha diya ki Esteban ");
INSERT INTO msmNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","aw gugujuda diya to yuwas to siyudad dow tatabangi dan to pagbatu. To kabo to sikan namanbatu kandin imbilin to songo otow no iyan ngadan si Saulo. ");
INSERT INTO msmNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","No batuhon dan pad si Esteban, mig-ampu sikandin no mig-iling, “Jesus no Ginuu, dawata to umagad ku.” ");
INSERT INTO msmNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Dajun sikandin yuhud aw pangiyak, “Ginuu, ajaw sikandan ogsukuti to seini pighinang dan.” Dajun sikandin kabigtawi. ");
INSERT INTO msmNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Inyobong si Esteban to diyusnon no mgo otow, aw maagbot to pagdegmatoy dan tongod to pag-oyog dan kandin. Sugud to diya paghimataji ki Esteban, mapoit yagboy to pagpaantus to mgo magtutuu diya to Jerusalem. Kaling namanyaguy sikandan aw kangkakanat-kanat diya to mgo prubinsya to Judea dow Samaria. Iyan da migpakamonang to mgo apustulis diya to Jerusalem. Na, si Saulo mig-ujun to diya paghimataji ki Esteban. ");
INSERT INTO msmNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sugud to diya no panahon migpaningkamot sikandin to pagdoot to punduk to mgo magtutuu agun magawang. Pigyogob-yogob din to pagsed to mgo kabaejan aw pandakopa to mgo yukos dow bohi aw ipaprisu. ");
INSERT INTO msmNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na, sikan mgo magtutuu no nangkakanat-kanat diya to yain-yain no mgo banwa mignawnangon to sikan Madojow no Nawnangonon bahin ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Si Felipe no sobuuk kandan mig-andiya to sikan mayow-ag no siyudad duon to Samaria su igwali din si Jesus no Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Pagdinog to mgo taga-Samaria to kagi ni Felipe aw pagkita dan to mgo milagru no nahinang din, tibo yagboy sikandan naminog kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Mahan-in to mgo otow duon no pigsamuk to mangkadoot no ispiritu. Ogpamakapangiyak sikan mgo ispiritu ko og-abugon ni Felipe. Mahan-in isab to nangkaulian no mgo piang dow nangkaparalays. ");
INSERT INTO msmNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kaling migtukhow hilabi to mgo otow duon. ");
INSERT INTO msmNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na, duon to sikan no siyudad meyduon salamangkiru no iyan ngadan si Simon. Nayugoy da no nabeyngan to mgo taga-Samaria sikan mgo hinang din. Pigpatuu din sikandan no gamhanan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","To tibo taga-Samaria, bantugan ko obos, naminog yagboy ki Simon su nayugoy-yugoy on man to diya pagkaboyong dan to sikan salamangka din. Og-angkon no gamhanan sikandin no napuun to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Di no pasabuton ni Felipe sikan mgo otow to sikan Madojow no Nawnangonon bahin to paghari to Diyus dow bahin ki Jesu-Cristo, migtuu sikandan aw pabawtismu, mgo yukos dow bohi. ");
INSERT INTO msmNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ngani man si Simon di migtuu aw pabawtismu. Pagkatapus, migduma-duma sikandin ki Felipe. Hilabi naboyong si Simon no kitaon din sikan mgo milagru dow duma no gamhanan no mgo hinang ni Felipe. ");
INSERT INTO msmNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pagkadinog to mgo apustulis diya to Jerusalem no mahan-in on to taga-Samaria no migtuu to kagi to Diyus, pigpaandiya dan si Pedro dow si Juan. ");
INSERT INTO msmNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pagtidow dan, mig-ampu sikandan no mabogajan podom sikan mgo taga-Samaria to Ispiritu Santu, ");
INSERT INTO msmNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","su wada pad man inggad sobuuk duon kandan no pigkonsadan to Ispiritu Santu. Su to pagpabawtismu dan, ngadan da man ni Jesus no Ginuu to piggamit. ");
INSERT INTO msmNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pagsampoyong ni Pedro dow ni Juan to sikan mgo magtutuu, dajun sikandan nakadawat to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pagkita ni Simon no nakadawat to Ispiritu Santu sikan pigsampoyongan to mgo apustulis, pigbogajan din podom si Pedro dow si Juan to saepi. ");
INSERT INTO msmNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Kagi din, “Bogaji a to sikan no gahom agun no inggad hintawa no ogsampoyongan ku ogpakadawat isab to Ispiritu Santu.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Di mig-iling si Pedro, “Mayagyag ka podom duma to sikan saepi nu! Su nailing to boot nu no ogkaboli sikan igbogoy puli to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wada yabot nu to seini, su maligsom to ginhawa nu duon to atubangan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Na, sosey ka aw talikudi sikan madoot no hona-hona nu aw pangamuju ka to Diyus, su basi da man pasayluhon ka. ");
INSERT INTO msmNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Su namaan a no ponu ka to pagsilag, angod ka to piggapus to sae.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Kagi ni Simon, “Sadangay i-ampu a now to Ginuu agun no sikan kastigu no ognangonon now kona ogkodog kanay.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Tapus to sikan, migpang-anad pad si Pedro dow si Juan to kagi to Ginuu aw pang-ikagi to diya nangkaaha dan no mgo hinang ni Jesus. Pagpauli dan diya to Jerusalem, pigpanghapitan dan pad to mgo kabaryuhan no sakup to Samaria aw inawnangon dan sikan Madojow no Nawnangonon bahin ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Songo aedow mey anghil to Ginuu no migsugu ki Felipe no mig-iling, “Andiya ka to baebagan aw unug ka to sikan dayan no oglikat to Jerusalem pailing diya to Gasa no wada bayoy no ogkabajaan.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Dajun panow si Felipe. Na, meyduon otow no taga-Etiopia no mig-andiya to Jerusalem su ogsimba to Diyus. Impurtanti sikandin no upisyal ni Candace no rayna din su sinaligan sikandin to tibo katigajunan to sikan rayna. ");
INSERT INTO msmNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pag-uli to sikan upisyal no migsakoy to sakajan din, pigbasa-basa din to sinuyat ni Isaias no kibali ba-ba to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pagkita ni Felipe to sikan otow, pig-ikagihan si Felipe to Ispiritu Santu, “Andiya ka aw padanihi sikan sakajan.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Dajun linaguy si Felipe. No madani on sikandin to sikan sakajan, pigdinog din no migbasa sikan upisyal to sikan sinuyat ni Isaias. Dajun din usipa sikan upisyal, “Sir, nasabutan nu sikan pigbasa nu?” ");
INSERT INTO msmNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kagi to sikan upisyal, “Eh, og-amonuhon ku man to pagsabut no wada man ogpasabut kanay?” Dajun din pasakaja si Felipe. ");
INSERT INTO msmNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","To pigbasa to sikan upisyal pig-iling, “Sikan no otow angod to karneru no ogdaehon diya to matansahanan. Angod isab sikandin to nati no karneru no kona ogsamuk ko og-upawan, su mahagtong puli sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pigpakasikawan sikandin su pigkastigu inggad wada sae. Wada ogpakapamatbat to kaliwatan din su majopot da man to kinabuhi din kani to babow to kalibutan.” ");
INSERT INTO msmNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Sikan upisyal mig-usip ki Felipe, “Hintawa man buwa sikan ognangonon kani? Sikan migsuyat, ko yain no otow?” ");
INSERT INTO msmNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Dajun pasabuta ni Felipe sikan upisyal sugud duon to sikan pigbasa din pailing duon to sikan Madojow no Nawnangonon bahin ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Anoy man no migpadajun pad, nakatidow sikandan duon to sikan meyduon wohig. Kagi to sikan upisyal, “Oho, meyduon suja wohig. Nokoy no kona a nu pad man ogbawtismuhan?” ");
INSERT INTO msmNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Dajun pasigkona to sikan upisyal sikan sakajan aw pon-ug sikandan no daduwa aw togbang diya to wohig. Na, pigbawtismuhan ni Felipe sikan upisyal. ");
INSERT INTO msmNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Paghaw-as dan, puli on pigboyong to sikan upisyal si Felipe su pigdaya to Ispiritu to Ginuu. Na, migpadajun sikan upisyal to pagpanow no malipajon. ");
INSERT INTO msmNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Hinuun kamaan si Felipe, diyad on naan sikandin to Asoto. Dajun sikandin panow pailing diya to Cesarea, aw kada yunsud no ogkabajaan din, igwali din sikan Madojow no Nawnangonon bahin ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","To diya no panahon, si Saulo migpadajun to sikan maagbot no pagpaantus din to mgo magtutuu to Ginuu. Kanunoy sikandin nanglinaum to paghimatoy kandan. Songo aedow mig-andiya si Saulo to sikan kinayabawan no magdudumaya to tinuuhan dan no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Mighangyu no bogajan sikandin to mgo suyat no igkapakita din duon to mgo simbahan to mgo Hibru diya to siyudad to Damasco. Sikan to ogmatuud no meyduon katongod din to pagdakop to inggad hintawa no ogtuu ki Jesus, bohi ko yukos. Aw sikan ogpandakopon din ogdaehon din no ginapus diya to Jerusalem. Na, pagkadawat ni Saulo to sikan mgo suyat, dajun sikandin panow. ");
INSERT INTO msmNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","No madani on sikandin duon to Damasco, meyduon masiga hilabi no hinggawan migsimag duon kandin likat to yangit. ");
INSERT INTO msmNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Natuad dajun si Saulo aw makadinog to migtawag no mig-iling, “O Saulo, nokoy no ogpaantuson a nu man?” ");
INSERT INTO msmNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Nangusip si Saulo, “Hintawa ka man?” Pigtabak sikandin no pig-iling, “Siak si Jesus no ogpaantuson nu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na, tindog ka. Padajun ka diya to Damasco su ogpaikagihan ku sikuna to oghinangon nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Natonongan to mgo duma ni Saulo. Nadinog dan sikan tingog, di wada pigkita dan no otow. ");
INSERT INTO msmNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Dajun tindog si Saulo aw buyata to mata din, di konad sikandin ogkita. Kaling man pigpikit sikandin to mgo duma din pailing diya to Damasco. ");
INSERT INTO msmNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sed to tatoyu no aedow wada sikandin kita. Wada isab koon aw inggad pag-inom. ");
INSERT INTO msmNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na, duon to Damasco meyduon magtutuu ki Jesus no iyan ngadan si Ananias. Nasailow din no pigtawag kun sikandin to Ginuu no mig-iling, “Ananias!” Dajun tabak si Ananias, “Seini a Ginuu.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Kagi to Ginuu, “Ananias, andiya ka to sikan karsada no og-ilingon to Matul-id aw pamanghaa to bayoy to songo otow no iyan ngadan si Judas. Pagtidow nu diya, i-usip to otow no taga-Tarso no iyan ngadan si Saulo. Mig-ampu sikandin duon, ");
INSERT INTO msmNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","aw meyduon impakita ku kandin. Nakasailow sikandin to otow no iyan ngadan si Ananias no migduguk kandin aw sampoyongi agun makakita manda.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Di si Ananias migtabak, “Adoy Ginuu, mahan-in da man to nadinog ku bahin to sikan no otow! Pigpaantus din kun to mgo sakup nu diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Aw iyan ing-andini din su pigbogajan kun sikandin to sikan yabow no mgo magdudumaya to tinuuhan to katongod to pagdakop to mgo sakup nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Di to Ginuu mig-ikagi kandin, “Inggad on. Andiyaid su sikandin to pigpili ku no ognawnangon bahin kanay diya to mgo Hibru hasta isab diya to kona no mgo Hibru, yakip sikan ogpamangmandu kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Igpasabut ku kandin no mahan-in to ogkangkabajaan din no mgo antusonon tongod to pagtuman din kanay.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Na, pigtuman ni Ananias sikan insugu to Ginuu. Pig-andiya din sikan pigpaabutan ni Saulo. Dajun sikandin sed aw sampoyongi si Saulo. Kagi din, “Suun Saulo, pigsugu a ni Jesus no Ginuu no migpakita ikow duon to dayan no ogpadeg ka pad dini. Pigpaandini a din agun makakita ka manda aw agun magahoman ka to Ispiritu Santu.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Duon-dajun meyduon angod to mgo hun-ap no nangkatanak likat to mata ni Saulo aw nakakita manda. Migtindog sikandin aw pabawtismu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tapus to sikan, migkoon on aw migdoson. Pagkaulii to mata ni Saulo, diya pad sikandin ugpa to Damasco sed to pila no aedow duma to mgo sakup ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Dajun sikandin andiya to mgo simbahan to mgo Hibru su igwali din no si Jesus Anak yagboy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","To tibo nakadinog kandin nangkaboyong aw naman-usip, “Kona no sikandin man to diya migpaantus to mgo sakup ni Jesus diya to Jerusalem? Kona no iyan man tuud din dini to pagdakop kandan aw paatubanga to sikan yabow no mgo magdudumaya to tinuuhan ta?” ");
INSERT INTO msmNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Di tongod to gahom to Diyus, nasi on naosoyan si Saulo. Madigon to mgo kamatuudan din no si Jesus iyan to diya Insaad no Manyuyuwas, kaling wada ingkatabak to sikan mgo Hibru duon to Damasco. ");
INSERT INTO msmNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Di pagkayugoy-yugoy, meyduon mgo Hibru no migplanu no oghimatajan dan si Saulo. ");
INSERT INTO msmNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aedow dow madukilom migbangan sikandan duon to mgo yawanganan to sikan siyudad, di namaanan ni Saulo sikan planu dan. ");
INSERT INTO msmNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kaling songo kadukiloman, inyuwan sikandin to mgo inanad din duon to baeknan aw tuntuna dan duon to songo bintana to matikang no padir to sikan siyudad. Na, nakalikoy si Saulo. ");
INSERT INTO msmNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Pagtidow ni Saulo diya to Jerusalem, migduguk sikandin to mgo magtutuu ki Jesus su og-agpot podom, di tibo nangkahaedok kandin. Wada sikandan tuu no migpasakup on si Saulo ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Di meyduon sobuuk no sakup ni Jesus duon to Jerusalem no iyan ngadan si Bernabe. Impakiyaya din si Saulo duon to mgo apustulis aw nangoni to diya pagpakita dow pag-ikagihi to Ginuu ki Saulo duon to dayan. Pignangonan din isab sikandan to kabuyut ni Saulo to pagwali bahin ki Jesus diya to Damasco. ");
INSERT INTO msmNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kaling nakaagpot si Saulo kandan. Wada pagkahaedok din to pagyogob-yogob to Jerusalem to pagwali to sikan Madojow no Nawnangonon bahin ki Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kanunoy sikandin ogpaggilaung dow ogpagtabak to mgo Hibru no Grigu to inikagihan. Di wada kayugoy, sikan no mgo otow namangha to paagi to paghimatoy kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Di pagkamaan to mgo magtutuu to sikan planu dan, inghatod dan si Saulo diya to Cesarea aw paandiyaa to siyudad to Tarso. ");
INSERT INTO msmNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Duon to sikan no panahon, miglinow to kaugpa to mgo magtutuu duon to Judea dow Galilea hasta Samaria. Migdugang to kahan-in dan dongan to pagdigon to pagtuu dan tongod to pagtahud dan to Ginuu hasta to tabang to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Na, migyouy si Pedro to mgo magtutuu diya to yain-yain no mgo banwa. Songo aedow mig-andiya sikandin to yunsud to Lida. ");
INSERT INTO msmNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Meyduon otow duon no iyan ngadan si Eneas. Wayu on no tuig no kona sikandin ogpakabangun su naparalays. Pagkita ni Pedro kandin, ");
INSERT INTO msmNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","pig-ikagihan din, “Yagi, naulian kad on ni Jesu-Cristo. Na, bangun kad on aw yukuta sikan pighibatan nu.” Duon-dajun migbangun si Eneas. ");
INSERT INTO msmNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pagkita to mgo taga-Lida dow to naman-ugpa duon to kapatagan to Saron no naulian on sikan otow, tibo sikandan migpasakup ki Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na, meyduon yunsud duon to dani to Lida no og-ilingon to Jope. Duon to sikan no yunsud meyduon bohi no magtutuu no kanunoy ogtabang to mgo otow yabi to mgo pubri. Si Tabita to ngadan din, aw to yain no ngadan din si Dorcas. ");
INSERT INTO msmNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","To diya no panahon, nasakit sikandin aw kamatoy. Sikan patoy no yawa din pigdigus aw kotanga duon to sinabong diya to diatas to bayoy. ");
INSERT INTO msmNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pagkadinog to mgo magtutuu no duon si Pedro to Lida no kona da no madiyu duon to Jope, pigsugu dan to daduwa no ka otow dow paikagihi si Pedro, “Sadangay duma ka dajun kanami.” ");
INSERT INTO msmNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Na, migduma si Pedro kandan. Pagtidow din, pigpaponhik sikandin diya to diatas no pigkotangan ki Tabita. Piglilibongan si Pedro to bayu no mgo bohi no namaniyahu. Impakita dan kandin to mgo kabo no tinohi ni Dorcas no buhi pad sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pigpayuwas sikandan tibo ni Pedro aw yuhud sikandin dow ampu. Dajun din atubanga sikan minatoy aw ikagihi, “Tabita, bangun ka!” Nakabuyat dajun si Tabita. Pagkita din ki Pedro, migbangun sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Dajun tagoni ni Pedro to boyad din aw patindoga. Pigtawag din sikan mgo bayu no bohi hasta to duma no mgo magtutuu aw ipakita din kandan si Tabita no nabuhi. ");
INSERT INTO msmNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Sikan pagkabuhi ni Tabita nabantug duon to tibuuk Jope, kaling mahan-in to migpasakup ki Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Si Pedro duon paabut to bayoy ni Simon no mag-andamay to mgo kindae to mananap. Nayugoy to pag-ugpa din duon. ");
INSERT INTO msmNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Meyduon kapitan to mgo sundayu diya to siyudad to Cesarea no iyan ngadan si Cornelio. Sakup sikandin to panon no og-ilingon to Kasundayuhan no taga-Italia. ");
INSERT INTO msmNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Si Cornelio dow to tibuuk no panimayoy din matinahudon dow matinumanon to Diyus inggad kona sikandan no mgo Hibru. Makawkae-aton si Cornelio to mgo pubri aw mainampuon. ");
INSERT INTO msmNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Songo aedow no alas tres on to kahapunon, meyduon nasailow din. Mapajag hilabi to pag-aha din to sikan anghil no migyogwa kandin aw ikagi, “Cornelio!” ");
INSERT INTO msmNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pigdaitan si Cornelio no migyongyong to sikan anghil. Kagi din, “Nokoy man Sir?” Migtabak sikan anghil, “Wada kalingawi to Diyus to mgo pag-ampu nu dow to pagtabang nu to mgo pubri. ");
INSERT INTO msmNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Na, ipadokat to songo otow diya to Jope no iyan ngadan si Simon no ogngadanan isab ki Pedro. ");
INSERT INTO msmNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Duon sikandin paabut ki Simon no mag-andamay to mgo kindae to mananap. To bayoy din nakapahigad to dagat.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","No boyongon on ni Cornelio sikan anghil, pigtawag din dajun to daduwa no mgo suguonon din dow sobuuk to sundayu no diyusnon no pangabaga din. ");
INSERT INTO msmNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pignangonan din sikandan to tibo no nasailow din aw sugu-a din diya to Jope. ");
INSERT INTO msmNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pagkaugtu to sikan migsunu no aedow, madani on sikandan ogtidow diya to Jope. Na, duon to iyan da no uras, migponhik si Pedro diya to atop to bayoy su og-ampu. Wada sikandin kamaan no meyduon namangha kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pagkahina-hina, pigbontas sikandin. Di no oghikajon pad to paniugtu, meyduon impakita to Diyus kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naabri kun to yangit, aw meyduon pigkita din no angod to mayow-ag no sabanas no pighikotan to upat no ka suyuk. Pigtuntun sikan likat to yangit pailing dini to pasak. ");
INSERT INTO msmNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pigkita din to tibo klasi no mgo mananap duon yakip sikan ogpamangunanap hasta mgo manuk-manuk. ");
INSERT INTO msmNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nadinog ni Pedro to kagi no mig-iling, “Pedro, tindog ka. Himatoy ka to seini aw koona.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Di migtabak si Pedro, “Eh, og-ojow a Ginuu, su wada a pad disti makakoon to inggad nokoy no ig-ojow to tinuuhan noy.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pigdinog din manda to kagi no mig-iling, “Kona ka og-iling no ig-ojow sikan intugut on to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Katatoyu igdaha si Pedro aw katatoyu isab sikandin balibad. Dajun kabatun sikan pigkita din padeg diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nalibod si Pedro to diya pigkita din. No mighona-hona pad sikandin dow nokoy buwa to kahuyugan to diya, migtidow duon to yunsud sikan mgo sinugu ni Cornelio aw usip dow andei to bayoy ni Simon. No duon on sikandan to yawanganan, ");
INSERT INTO msmNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","nanabi sikandan aw pangusip, “Meyduon migpaabut kani no iyan ngadan si Simon no ogngadanan isab ki Pedro?” ");
INSERT INTO msmNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","No diya pad si Pedro to diatas no mighona-hona to kahuyugan to diya pigkita din, pig-ikagihan sikandin to Ispiritu Santu, “Oho, meyduon bag-u tidow no tatoyu no ka otow no namangha ikow. ");
INSERT INTO msmNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pon-ug ka dajun aw kona kad ogduwa-duwa to pagduma, su siak to migpaandini kandan.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Dajun pon-ug si Pedro aw ikagihi din sikan mgo otow, “Siakon to ogpamanghaon now. Nokoy man to tuud now kanay?” ");
INSERT INTO msmNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kagi dan, “Pigsugu koy ni Cornelio no kapitan to mgo sundayu. Matarong sikandin, matinahudon to Diyus aw tinahud yagboy to tibo mgo Hibru. Meyduon anghil to Diyus no migyogwa kandin aw ikagihi no ipadokat ka agun makadinog sikandin to og-ikagihon nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Dajun paseda ni Pedro sikan mgo sinugu ni Cornelio aw duon din pahibata to sikan no kadukiloman. Pagkabukas, migduma si Pedro kandan, aw meyduon isab migduma no pila no ka magtutuu no taga-Jope. ");
INSERT INTO msmNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagkasunu no aedow, migtidow sikandan diya to Cesarea. Pigpaabut sikandan ni Cornelio dow sikan mgo kasuunan din hasta mgo amigu no pighimun din. ");
INSERT INTO msmNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","No ogsed on si Pedro duon to bayoy, pigtagbu sikandin ni Cornelio aw yuhud duon to atubangan din. ");
INSERT INTO msmNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Di pigpatindog sikandin ni Pedro aw ikagihi, “Eh, kona ka ogyuhud su otow a da.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na, pagsed ni Pedro dow ni Cornelio no miggigilaung, naaha ni Pedro sikan mahan-in no mgo otow no nahimun. ");
INSERT INTO msmNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Kagi din, “Namaan kow on no supak to tinuuhan noy no mgo Hibru to pagduma-duma to otow no kona no Hibru, inggad to pagbisita. Di pigpasabut ad to Diyus no wada naan otow no ogpalikajan kanay. ");
INSERT INTO msmNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kaling no ipadokat a ni Cornelio, wada a duwa-duwa to pag-andini. Na kuntoon, nangoni a dow nokoy to impaandini now kanay.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Si Cornelio to migtabak, “Ikaupat on kuntoon no aedow no mig-ampu a to alas tres to kahapunon angod to seini no uras kuntoon. Puli nakatokow nakayogwa to otow no nangabo to makinlow ");
INSERT INTO msmNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","no mig-iling, ‘Cornelio! Pigdinog to Diyus to mgo pag-ampu nu. Wada din kalingawi to mgo pagtabang nu to mgo pubri. ");
INSERT INTO msmNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na, ipadokat nu to songo otow no diya to yunsud to Jope no iyan ngadan si Simon no ogngadanan isab ki Pedro. Duon sikandin paabut ki Simon no mag-andamay to mgo kindae to mananap. To bayoy din nakapahigad to dagat. ");
INSERT INTO msmNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kaling impadokat ku dajun sikuna, aw salamat su mig-andini ka. Iyan ingkahimun noy kani to atubangan to Diyus su ogpaminog koy to tibo no igpaikagi ikow to Ginuu.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Kagi ni Pedro, “Bali no nasabutan kud no wada ogkinawaehon to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Su ogdawaton din to otow no ogtahud kandin dow oghinang to matarong, inggad nokoy to tribu din. ");
INSERT INTO msmNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Sikan Madojow no Nawnangonon ingmaan to Diyus kanami no mgo kaliwat ni Israel agun mamaanan no si Jesus no Magboboot to tibo mgo otow iyan inghusoy ita dow to Diyus agun no ogkahiuli kinow dow to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nadinogan now on buwa to mangkadojow no nahitabu diya to banwa noy no mgo Hibru. Migsugud sikan duon to Galilea tapus makapang-anad aw makapamawtismu si Juan. ");
INSERT INTO msmNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Su to Ispiritu Santu pigpakonsad to Diyus duon ki Jesus no taga-Nazaret aw bogaji sikandin to gahom. Tapus to sikan, piglibut ni Jesus to banwa noy. Nanghinang sikandin to madojow aw pinang-ulian din to pigsamuk to mangkadoot no ispiritu. Nahinang din sikan su pigdumahan man to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Kistigus koy no mgo apustulis to tibo pigpanghinang ni Jesus duon to banwa noy no mgo Hibru yakip to siyudad to Jerusalem. To katapusan, pigpahimatajan si Jesus to mgo Hibru pinaagi to pagyansang duon to krus. ");
INSERT INTO msmNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Di pigbanhaw da sikandin to Diyus duon to ikatoyu no aedow aw payogwaa. ");
INSERT INTO msmNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wada yain no pigyogwa din gawas kanami no pigpili to Diyus to pagkistigus. Nakapagsayu pad man ngani sikandin kanami to pagkoon dow pag-inom. ");
INSERT INTO msmNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pigsugu koy ni Jesus to pagwali dow to pagmatuud no sikandin to ogpahukumon to Diyus to mgo patoy dow mgo buhi. ");
INSERT INTO msmNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Sikandin to pighisgutan to diya tibo mgo otow no kibali ba-ba to Diyus. Mig-iling sikandan no pinaagi kandin, ogkapasaylu to sae to tibo ogtuu dow ogsalig kandin.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Dugaja pad mig-ikagi si Pedro, migkonsad on to Ispiritu Santu duon to tibo naminog to kagi din. ");
INSERT INTO msmNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Nangkaboyong sikan magtutuu no mgo Hibru no duma ni Pedro, su sikan kona no mgo Hibru pigkonsadan isab to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Su pigdinog dan man no namakalituk sikandan to yain no mgo inikagihan no wada dan kasabuti, aw migsaja sikandan to Diyus. Dajun ikagihi ni Pedro sikan Hibru no mgo duma din, ");
INSERT INTO msmNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Seini no mgo otow pigkonsadan to Ispiritu Santu angod to pagkonsadi ita no mgo Hibru. Na, wada yagboy ogpakapogong ko bawtismuhan sikandan.” ");
INSERT INTO msmNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Dajun sugu si Pedro ongki Cornelio no mupabawtismu sikandan to ngadan ni Jesu-Cristo. Tapus sikandan kabawtismuhi, pighangyu si Pedro onni Cornelio no mupakamonang naa sikandan duon sed to pila no aedow. ");
INSERT INTO msmNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na, to duma no mgo apustulis dow mgo magtutuu diya to prubinsya to Judea nakadinog no meyduon kona no mgo Hibru no migtuu isab to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kaling, pagpauli ni Pedro diya to Jerusalem, meyduon mgo Hibru no migsawoy kandin. Sikandan to namogos no to diya ogkahinang no mgo sakup ni Jesus kinahangyan mutuman to mgo tumanon to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Mig-iling sikandan ki Pedro, “Nokoy no migsed ka man duon to bayoy to sikan wada tuman to mgo tumanon ta? Migpagsayu ka man ngani kandan no supak man sikan to tinuuhan ta!” ");
INSERT INTO msmNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pagdinog ni Pedro to kagi dan, pignangonan din sikandan to tibo nahitabu sugud to sinugdanan. ");
INSERT INTO msmNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kagi din, “No diya a to yunsud to Jope, mig-ampu a aw meyduon nasailow ku. Pigkita ku to angod to mayow-ag no sabanas no pighikotan to upat no ka suyuk. Pigtuntun kun sikan likat diya to yangit pailing dini to pasak aw sigkon duon to topad ku. ");
INSERT INTO msmNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Paghiling-hiling ku to sed to sikan, iyan naaha ku to mgo kadlaganon dow binuhi no mgo mananap dow sikan ogpamangunanap hasta mgo manuk-manuk. ");
INSERT INTO msmNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Dajun ku dinoga to kagi no pig-iling, ‘Pedro, tindog ka. Himatoy ka to seini aw koona.’ ");
INSERT INTO msmNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Di migtabak a, ‘Eh, og-ojow a Ginuu, su wada a pad disti makakoon to inggad nokoy no ig-ojow to tinuuhan noy.’ ");
INSERT INTO msmNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Pigdinog ku manda to kagi likat to yangit no mig-iling, ‘Kona ka og-iling no ig-ojow sikan intugut on to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Katatoyu a igdaha, aw dajun kabatun sikan pigkita ku padeg diya to yangit. ");
INSERT INTO msmNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“To diya yagboy no uras, meyduon migtidow no tatoyu no ka otow duon to sikan pigpaabutan ku. Diya sikandan kapuun to Cesarea, aw iyan ing-andiya dan to Jope to pagdokat kanay. ");
INSERT INTO msmNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kona iyan sikandan no mgo Hibru, di pigmanduan a to Ispiritu Santu to pagduma kandan no wada pagpihig. Seini onom no mgo suun ta no taga-Jope migduma kanay diya to Cesarea. Pagtidow noy diya, migsed koy duon to bayoy ni Cornelio. ");
INSERT INTO msmNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Duon koy din nangoni bahin to diya anghil no migyogwa kandin duon to sed to bayoy din aw ikagihi sikandin, ‘Ipadokat nu to songo otow diya to Jope no iyan ngadan si Simon no oghingadanan isab ki Pedro. ");
INSERT INTO msmNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Sikuna dow to panimayoy nu ogpasabuton din dow og-amonuhon no mayuwas kow.’ Sikan to pig-ikagi to sikan anghil ki Cornelio. ");
INSERT INTO msmNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Na, no puli a pad migsugud to pag-ikagi, migkonsad to Ispiritu Santu duon kandan angod da to diya una no pagkonsad din dini ita. ");
INSERT INTO msmNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Dajun ku nadomdoman to diya kagi ni Jesus no Ginuu no pig-iling, ‘Si Juan iyan imbawtismu to wohig, di Ispiritu Santu to igbawtismu iyu.’ ");
INSERT INTO msmNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na,” kagi ni Pedro, “ko gustu to Diyus no ibogoy to Ispiritu Santu to sikan kona no mgo Hibru angod to diya pagbogoy din ita no mutuu kid ki Jesu-Cristo no Ginuu, hintawa a man no ogpogong kandin?” ");
INSERT INTO msmNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","No makadinog sikandan to kagi ni Pedro, migsigkon sikandan to pagsawoy. Nasi no pigsaja dan to Diyus. Kagi dan, “Piggahoman naan to Diyus sikan kona no mgo Hibru agun musosey sikandan aw talikudan to mgo sae dan. Na, ogbogajan sikandan to kinabuhi no wada katapusan.” ");
INSERT INTO msmNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","To diya panahon no himatajan si Esteban, maagbot yagboy to pagpaantus to mgo magtutuu. Kaling nasusuwoy-suwoy sikandan diya to yain-yain no mgo banwa. To duma diya makadeg to sikan madiyu no banwa to Fenicia, diya to Cipre no puyu to dagat, hasta diya to siyudad to Antioquia. Inggad andei sikandan makadoyog, ingnawnangon dan si Jesus, di mgo Hibru da to pignangonan dan. ");
INSERT INTO msmNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Di meyduon isab mgo magtutuu no taga-Cipre dow taga-Cirene no naman-andiya to Antioquia, aw iyan pigwalihan dan to kona no mgo Hibru bahin ki Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Piggahoman yagboy sikandan to Ginuu, kaling mahan-in hilabi to migtuu dow migpasakup kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Namakadinog to mgo magtutuu diya to Jerusalem no meyduon migpasakup ki Jesu-Cristo diya to Antioquia no kona no mgo Hibru. Kaling pigpaandiya dan si Bernabe agun digonon din sikan bag-u no namanuu. ");
INSERT INTO msmNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","24","Na, si Bernabe madojow no otow. Togob sikandin to Ispiritu Santu aw madigon to pagtuu din. Pagtidow din diya to Antioquia, naaha din dow man-u to pagtabang kandan to Diyus, kaling nalipay sikandin. Pignongnong din sikandan no digonon to pagtuu dan aw mupabilin to bug-us no pagtuman to pagboot to Ginuu. Pag-ugpa ni Bernabe duon, migdugang pad to kahan-in to mgo sakup to Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Likat duon to Antioquia, mig-andiya si Bernabe to Tarso su ogpamanghaon din si Saulo. ");
INSERT INTO msmNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","No makitaan din on, pigduma din diya to Antioquia. Sed to songo tuig, kanunoy sikandan migpaghimun to sikan mgo magtutuu, aw pigpang-anad dan to mahan-in yagboy no mgo otow. To mgo magtutuu diya to Antioquia iyan una no pigngadanan no Cristuhanon. ");
INSERT INTO msmNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","To diya no panahon, meyduon mgo taga-Jerusalem no kibali ba-ba to Diyus no mig-andiya to Antioquia. ");
INSERT INTO msmNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","To sobuuk kandan no iyan ngadan si Agabo migtindog duon to atubangan to nahimun no mgo magtutuu su ogtag-an. Pigpaikagi sikandin to Ispiritu Santu no meyduon maagbot no bontas no og-abut kani to tibuuk kalibutan. (Natuman to diya no bontas no si Claudio iyan mighari diya to Roma.) ");
INSERT INTO msmNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Kaling naujunan to sikan mgo magtutuu no ogpadaehan to hinabang to angod dan no mgo magtutuu diya to prubinsya to Judea. Kada sobuuk migbogoy kotob to nahimu din. ");
INSERT INTO msmNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pagkahimun to sikan igtabang dan, impahatod dan ki Bernabe dow ki Saulo diya to mgo panguyu to mgo magtutuu duon to Judea. ");
INSERT INTO msmNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","To diya no panahon, migsugud si Hari Herodes to pagpaantus to pila no mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pigpatampodan din to liog si Santiago no suun ni Juan. ");
INSERT INTO msmNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Pagsabut din no ingkalipay to mgo Hibru sikan pagpahimataji din ki Santiago, impadakop din isab si Pedro. Nakatapu sikan to diya pista to mgo Hibru no og-ilingon to Pista to Pan no Wada Patubu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pagkadakop ki Pedro, impaprisu sikandin aw pabantaji to upat no ka grupu no mgo sundayu no ogsinokoli. Kada grupu tag-upat no ka sundayu. Mighona-hona si Herodes no ko tapus on to pista, ogpaatubangon din si Pedro to kaotawan agun hukuman. ");
INSERT INTO msmNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kaling pigpabantajan din si Pedro diya to prisuhan. Di migpangamuju yagboy to mgo magtutuu no tabangan sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Mae-kasem pad oghukuman si Pedro, sikan no kadukiloman nalipodong sikandin no pigpusasan aw ipusas isab duon to boyad to mgo sundayu. Meyduon isab mgo sundayu no migbantoy duon to pertahan to sikan prisuhan. ");
INSERT INTO msmNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Na, puli nakatokow nakayogwa to anghil to Ginuu, aw katang-awi sikan sinabong to kasiga din. Dajun din dagpi-a si Pedro aw ikagihi, “Bangun ka. Dali ka!” Duon-dajun natangtang to mgo pusas no inggapus to mgo boyad din. ");
INSERT INTO msmNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Kagi to sikan anghil, “Pamagkos ka aw panapatus.” Dajun migtuman si Pedro. Kagi manda to sikan anghil, “Na, aapid ka to kabo aw duma ka kanay.” ");
INSERT INTO msmNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Dajun sunud si Pedro to sikan anghil pailing diya to yuwas. Di wada sikandin kamaan no tinood to pighinang to sikan anghil. Nailing to boot din no puli din nasailow. ");
INSERT INTO msmNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na, pigyabajan dan sikan una no bantoy, dajun duon to ikaduwa hangtod migtidow sikandan duon to yawanganan no pigsirahan to puthow no ogpailing diya to siyudad. Kabeynganan su puli naabri sikan sira no wada mig-abri, dajun sikandan yuwas. Wada pad sikandan makapanow to madiyu, pigboyong on ni Pedro sikan anghil. ");
INSERT INTO msmNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bali no nasabutan din no kona naan no nasailow din puli. Ginhawa din, “Tinood naan no pigpaandinihan a to Diyus to anghil din! Pigyuwas a din to sikan pig-iman ni Herodes hasta to mgo Hibru no ogkahitabu kanay.” ");
INSERT INTO msmNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tapus makapaantoyo si Pedro, migpadajun sikandin diya to bayoy ni Maria no inoy ni Juan no pigngadanan isab ki Marcos. Duon to sikan no bayoy nahimun to mahan-in no mgo magtutuu no naman-ampu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pagtidow ni Pedro duon to bayoy, migtuktuk sikandin. Na, meyduon bohi no suguonon duon no iyan ngadan si Roda. Mig-andiya sikandin aw ahaa dow hintawa to migtidow. ");
INSERT INTO msmNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pagkiyaya din to tingog ni Pedro, migtukhow yagboy sikandin. Dajun sikandin balikid aw linaguy diya to sed, di wada din pad kaabrihi si Pedro. Kagi din, “Duon si Pedro!” ");
INSERT INTO msmNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Di wada tuu sikan mgo duma din. Nasi no mig-iling sikandan, “Eh, nabuang ka kay buwa!” Kagi ni Roda, “Eh, si Pedro iyan.” Di wada gihapun sikandan tuu. Kagi dan, “Anghil din buwa sikan.” ");
INSERT INTO msmNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Di si Pedro wada sigkon to pagtuktuk. No maabri on to sira aw no maaha dan no si Pedro iyan, hilabi sikandan natingaya. ");
INSERT INTO msmNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Di pigsingyasan din sikandan no mupahonok. Imbatbat din dow pig-amonu to Diyus to pagpayuwas kandin to prisuhan. Kagi din, “Nangoni si Santiago dow to duma no mgo suun ta to pagtuu.” Dajun panow si Pedro aw andiya to yain no banwa. ");
INSERT INTO msmNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","No mabukas on, nalibod hilabi aw nahaedok sikan mgo magbantajay su wada dan katagahi dow nakaandeid si Pedro. ");
INSERT INTO msmNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Impapamangha sikandin ni Herodes di wada kakita-i. Kaling pig-imbistiga ni Herodes sikan mgo magbantajay aw pagkatapus, pigpahimatajan. Pagkatapus to sikan, miglikat si Herodes to Judea pailing diya to Cesarea, aw nayugoy-yugoy to pag-ugpa din duon. ");
INSERT INTO msmNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Duon to sikan no panahon, naboyu yagboy si Hari Herodes to mgo taga-Tiro dow taga-Sidon. Kaling naujunan to sikan mgo otow no og-ajum-ajumon dan si Herodes, su diya man sikandan ogpudut to pagkoon to sikan banwa no pigmanduan din. Una dan pigkumbinyu si Blasto no tabangan sikandan su iyan man sinaligan duon to palasyu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na, pag-abut to sikan aedow no nasabutan no og-atubang kandin sikan mgo otow, migpangabo si Herodes to kabo din no kaning hari aw ingkud duon to trunu aw diskursu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tapus to diskursu din, migkinuliya sikan mgo otow no mig-iling, “Diyus kay sikan mig-ikagi, kona no otow puli!” ");
INSERT INTO msmNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Duon-dajun pigkastigu si Herodes to anghil to Ginuu, su wada din sikandan pasabuta no iyan da man og-angodon to sikan to pagsaja ko Diyus. Kaling pig-iyasan to ginhawahan din aw kamatoy. ");
INSERT INTO msmNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","To kagi to Diyus migpadajun to pagtangkap, aw migdugang to kahan-in to mgo otow no migtuu. ");
INSERT INTO msmNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na, pagkatuman to tuud ni Bernabe dow ni Saulo diya to Jerusalem, migpauli sikandan diya to Antioquia. Migduma kandan si Juan no pigngadanan isab ki Marcos. ");
INSERT INTO msmNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Diya to Antioquia, meyduon pigpanghinang to Diyus no kibali ba-ba din dow mgo mag-anaday. Iyan mgo ngadan dan si Bernabe, si Simon no pigdagnajan ki Negro, si Lucio no taga-Cirene, si Manain no sakup to panimayoy ni Gubernadur Herodes to diya una, hasta si Saulo. ");
INSERT INTO msmNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Songo aedow no migsimba sikandan to Ginuu aw migpuasa, pig-ikagihan sikandan to Ispiritu Santu, “Ibahin now kanay si Bernabe dow si Saulo su meyduon igpahinang ku kandan.” ");
INSERT INTO msmNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tapus sikandan puasa aw ampu, pigsampoyongan dan si Bernabe dow si Saulo aw palikata ");
INSERT INTO msmNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","agun mutuman to insugu to Ispiritu Santu. Paglikat ni Bernabe dow si Saulo duon to Antioquia, migtogbang sikandan to Seleucia. Pagtidow dan, migsakoy sikandan to barku no linayagan su og-andiya to sikan maaslag no puyu to dagat no og-ilingon to Cipre. ");
INSERT INTO msmNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Duma dan si Juan no pigngadanan isab ki Marcos no pangabaga dan. Pagtidow dan diya to Cipre, duon sikandan duung to yunsud to Salamina. Dajun dan iwali to kagi to Diyus duon to mgo simbahan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Likat to Salamina, pigbajaan dan sikan puyu to Cipre kotob no migtidow sikandan diya to yunsud to Papos. Duon dan kabaeki to songo Hibru no salamangkiru no iyan ngadan si Bar-Jesus. Pigpatuu din to mgo otow no kibali ba-ba sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Songo upisyal sikandin to sikan gubernadur no iyan ngadan si Sergio Paulo no utokan no otow. Impatawag to sikan gubernadur si Bernabe dow si Saulo su gustu din no ogpaminog to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Di migsupak sikan salamangkiru no pigngadanan isab ki Elimas. Migpaningkamot sikandin to pagbaebag agun kona makatuu ki Jesus sikan gubernadur. ");
INSERT INTO msmNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Di si Saulo no pigngadanan isab ki Pablo, togob to Ispiritu Santu. Pigyongyongan din sikan salamangkiru ");
INSERT INTO msmNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","aw ikagihi, “Sikuna no sakup ni Satanas, malimbungon ka aw mapagustuhon. Kuntra ka to tibo mangkadojow, su og-ilingon nu no gayu sikan matuud no kaning Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Na,” kagi ni Pablo, “ogkastiguhon ka to Ginuu. Ogkabuta ka kotob no padojawan ka din.” Dajun miggagabun to pag-aha ni Elimas hangtod no migdigyom on yagboy. Nakapandamdam sikandin su ogpamangha to otow no ogpikit kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pagkita to sikan gubernadur to nahitabu, migtuu sikandin ki Jesus no Ginuu. Hilabi sikandin natingaya to sikan ing-anad onni Pablo bahin kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Miglikat onsi Pablo duon to Papos aw sakoy to sakajan diya to dagat pailing diya to Perga no sakup to Pampilia. Di pig-ojowan sikandan ni Juan no pigngadanan isab ki Marcos aw uli diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Likat duon to Perga, migpadajun onsi Pablo diya to Antioquia no sakup to Pisidia. Anoy man no Aedow on no Tigpahuway, mig-anduon sikandan to simbahan to mgo Hibru aw paman-ingkud. ");
INSERT INTO msmNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Meyduon migbasa to sinuyat ni Moises dow sinuyat to diya duma no kibali ba-ba to Diyus. Tapus to pagbasa, impausip to mgo panguyu to sikan simbahan si Pablo dow si Bernabe dow meyduon igkawali dan no ogpakadigon to mgo otow duon. ");
INSERT INTO msmNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kaling migtindog si Pablo aw singyasi sikandan agun mupahonok. Kagi din, “Mgo suun ku no mgo Hibru dow sikiyu no kona no mgo Hibru no migtahud isab to Diyus, paminog kow. ");
INSERT INTO msmNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","To Diyus ta no mgo Hibru iyan migpili to diya mgo minuna ta. Aw no muyampot to kaliwatan dan diya to Ehipto, pigpahan-in sikandan to Diyus aw digona. Pinaagi to gahom din, pigpayuwas din sikandan to Ehipto. ");
INSERT INTO msmNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Sed to kap-atan no tuig no makapanow-panow sikandan diya to matahay no banwa, migpadajun to kadojow to Diyus kandan sahian ka da to pag-atiman to ginikanan. ");
INSERT INTO msmNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pagtidow dan duon to banwa to Canaan, impayagyag to Diyus sikan tahan no naman-ugpa duon no pitu no ka tribu aw ibogoy din kandan sikan pasak. ");
INSERT INTO msmNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Upat on no gatus mey kalim-an no tuig to migyaboy. “Tapus to sikan, meyduon mgo datu no pigpamandu to Diyus kandan kotob to panahon ni Samuel no pighinang din isab no kibali ba-ba din. ");
INSERT INTO msmNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Di sikan mgo Hibru nangamuju to Diyus no bogajan sikandan to hari. Kaling pigpahari to Diyus si Saulo no anak ni Kis no sakup to kaliwatan ni Benjamin. Mighari sikandin sed to kap-atan no tuig. ");
INSERT INTO msmNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Tapus to sikan, pighukasan to Diyus si Saulo to pagkahari aw ilisi ki David no anak ni Isai. Kagi to Diyus, ‘Si David ogpakaduyug to ginhawa ku, su ogtumanon din to tibo pagboot ku.’ ");
INSERT INTO msmNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na,” kagi isab ni Pablo, “si David meyduon liwat no Manyuyuwas no imbogoy ita no mgo kaliwat ni Israel. Si Jesus sikan no iyan katumanan to diya insaad to Diyus to mgo kaaw-apuan ta. ");
INSERT INTO msmNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Di no wada pad sugud si Jesus to trabahu din, pigwalihan on ni Juan no Magbawtismuhay to tibo mgo kaliwat ni Israel. Mig-iling sikandin no kinahangyan mupabawtismu sikandan pagpakiyaya no migsosey on sikandan aw migtalikud to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","No madani on ogkatapus sikan impahinang to Diyus ki Juan, pig-ikagihan ni Juan to kaotawan, ‘Basi mailing to boot now no siakon to diya Insaad no Manyuyuwas. Di kona no siakon, su sikan Manyuyuwas ogpakasunu kanay. Obos a da hilabi kandin su ngani man to paghukas ku to sapatus din, di kona a og-angajan.’ ");
INSERT INTO msmNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Migpadajun si Pablo to pag-ikagi, “Mgo suun no angod ku no mgo kaliwat ni Abraham hasta sikiyu no kona no mgo Hibru no migtahud isab to Diyus, kuntoon pigpadaehan ki to Diyus to Madojow no Nawnangonon agun mayuwas ki. ");
INSERT INTO msmNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sikan mgo Hibru diya to Jerusalem yakip to mgo panguyu dan wada kamaan no si Jesus to ogpakayuwas ita. Ogkapaminogan dan no ogbasahon kada Aedow no Tigpahuway sikan sinuyat to diya mgo otow no kibali ba-ba to Diyus. Di wada dan gihapun kasabuti no sikandan naan to diya ognangonon no ogpahimatoy ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Su inggad wada sae no angay igkahimatoy kandin, pighangyu dan si Pilato no pahimatajan sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tapus dan katuman sikan tibo nasuyat no oghinangon dan ki Jesus, pigpudut sikan yawa din duon to krus aw iyobong. ");
INSERT INTO msmNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Di pigbanhaw da sikandin to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Sed to mahan-in no mgo aedow piglinogwa din to diya mgo otow no migduma-duma kandin likat to Galilea pailing diya to Jerusalem. Sikandan kuntoon to ogkistigus bahin ki Jesus diya to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Na, sikami kuntoon,” kagi isab ni Pablo, “mig-andini koy su meyduon madojow no ignawnangon noy iyu. Su to diya insaad to Diyus to mgo kaaw-apuan ta no mgo Hibru ");
INSERT INTO msmNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","natuman on dini ita pinaagi ki Jesus no pigpaandini din on. Su meyduon pig-ikagi to Diyus ki Jesus duon to ikaduwa no Salmu no pig-iling, ‘Anak ku sikuna, aw kuntoon igmaan ku no siakon to Amoy nu.’ ");
INSERT INTO msmNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Namaan ki isab no pigmatuud to Diyus to pagbanhaw din ki Jesus no konad on ogkamatoy su nasuyat on no pig-iling, ‘Ogtumanon ku yagboy duon iyu sikan insaad ku ki David no mgo kadojawan.’ ");
INSERT INTO msmNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Meyduon isab intag-an ni David no nasuyat duon to libru to mgo Salmu no pig-iling, ‘Kona nu igtugut no madunut to yawa ku no pinadajag nu.’ ");
INSERT INTO msmNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Na,” kagi ni Pablo, “hintawa man naan sikan ognangonon no wada kadunut to yawa? Ki David? Kona, su namaan ki no tapus din katuman to diya impahinang kandin to Diyus, namatoy sikandin. To yawa din inyobong duon to topad to mgo kaaw-apuan din aw kadunut. ");
INSERT INTO msmNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Di sikan pigbanhaw to Diyus no si Jesus, wada kadunut to yawa din. ");
INSERT INTO msmNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Mgo suun ku, ognangonan ku sikiyu to sikan agun mamaanan now no ogkapasaylu to mgo sae now tongod to diya pighinang ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Kona no iyan igdawata to Diyus to otow tongod to pagtuman to sikan mgo balaod no imbilin ni Moises, di tongod da to pagtuu dow pagsalig ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kaling bantoy kow no kona ogkahitabu iyu sikan intag-an no insuyat to otow no kibali ba-ba to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Sikiyu no kona ogtuu, paminog kow, kagi to Diyus. Meyduon igpakita ku iyu no oghinangon ku no hilabi now ogkatingaehan. Di ogkamatoy kow gihapun su kona kow man ogtuu no ogkahitabu sikan inggad meyduon ogpasabut iyu.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","No ogpamanyuwas on onsi Pablo, mighangyu sikan namanimba no mupauli da sikandan to sunu no Aedow no Tigpahuway su ogpaanad manda sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","No diyad on sikandan to yuwas to simbahan, namanduma ki Pablo dow ki Bernabe to mahan-in no mgo Hibru hasta sikan puli namanpasakup to tinuuhan to mgo Hibru. Migpaggilaung onsi Pedro kandan aw nongnonga to pagsalig kanunoy to kadojow dow kayuuy to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Anoy man no Aedow manda no Tigpahuway, halus tibo taga-Antioquia nahimun duon to simbahan su ogpaminog to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Di pagkita to mgo Hibru to sikan mahan-in no mgo otow no nahimun duon, migsilag sikandan. Kaling pigtamay dan si Pablo. Pigtalabad dan isab aw yalisa yagboy sikan ingwali din. ");
INSERT INTO msmNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Di nasi on nahinogotan si Pablo dow si Bernabe to pag-ikagi no wada pagkahaedok. Mig-iling sikandan, “Kinahangyan podom no sikiyu no mgo Hibru iyan og-unahan noy ognangonan to kagi to Diyus. Di manno pig-ojowan now, migpasabut sikan no kona kow og-angajan no ogbogajan to kinabuhi no wada katapusan. Kaling diya koy on ogwali to kona no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Su ogtumanon noy to sugu to Diyus no pig-iling, ‘Pighinang ku sikuna no soga diya to kona no mgo Hibru. Sikuna to ogtang-ow to mgo otow inggad diya to kinasangkoan to kalibutan agun makakita sikandan to dayan to kayuwasan.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na, pagdinog to kona no mgo Hibru to sikan kagi ni Pablo, migtukhow hilabi sikandan aw nakaikagi, “Pagkadojow on man to sikan kagi to Diyus!” Dajun migpasakup ki Jesus to tibo mgo otow duon no tahan pigpili to Diyus no ogbogajan to kinabuhi no wada katapusan. ");
INSERT INTO msmNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","To kagi to Diyus migtangkap diya to tibo mgo kabaryuhan no sakup to Antioquia. ");
INSERT INTO msmNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Di sikan mgo Hibru duon to Antioquia, pigpabuyutan dan to inila no mgo bohi no kona no mgo Hibru di migsimba to Diyus. Pigpabuyutan dan isab to inila no mgo yukos. Pigpaantus dan si Pablo dow si Bernabe aw abuga duon to banwa dan. ");
INSERT INTO msmNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kaling pig-ojowan onni Pablo sikan no banwa. Pagyuwas dan on to sikan yunsud, pigpadpad dan to abug to sapatus dan pagpakiyaya no konad on sikandan ogkasukutan ko kastiguhon sikan no mgo otow. Dajun sikandan panow padeg diya to yunsud to Iconio. ");
INSERT INTO msmNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Di namanukhow sikan naliusan dan no namanuu on ki Jesus, aw natogob sikandan to Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pagtidow ni Pablo dow ni Bernabe diya to Iconio, mig-andiya sikandan to simbahan to mgo Hibru no iyan nabatasan dan aw wali. To mgo kagi dan mig-utong yagboy duon to ginhawa to sikan naminog, kaling mahan-in to migpasakup ki Jesu-Cristo no mgo Hibru hasta kona no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Di to mgo Hibru no wada tuu, pigpabuyutan dan to diya kona no mgo Hibru no wada isab tuu agun ogkuntrahon dan to diya namanuu ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Di wada haedok onni Pablo to pagkistigus bahin to kadojow dow kayuuy to Ginuu. Nayugoy gihapun to pag-ugpa dan duon to Iconio. To impang-anad dan pigmatuud to Diyus pinaagi to mgo milagru dow duma no mgo kabeynganan no nahinang dan. ");
INSERT INTO msmNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","To mgo taga-Iconio nabahin. Meyduon miggapi to sikan mgo Hibru no wada tuu ki Jesus, aw meyduon isab miggapi to sikan mgo apustulis. ");
INSERT INTO msmNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Na, meyduon mgo Hibru dow kona no mgo Hibru, yakip to mgo panguyu dan, no migplanu no oghimatajan si Pablo dow si Bernabe. Ogsulungon dan podom aw ogbatuhon kotob no mamatoy. ");
INSERT INTO msmNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Di pagkamaan onni Pablo to sikan oghinangon dan, migyaguy sikandan aw paaput diya to Listra dow Derbe no sakup to Licaonia. ");
INSERT INTO msmNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Diya dan iwali sikan Madojow no Nawnangonon hasta diya isab to mgo kabaryuhan no madani duon. ");
INSERT INTO msmNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Diya to Listra meyduon natae-an dan no pulid no wada yagboy makapanow sugud to pagkaotow din. ");
INSERT INTO msmNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Mig-ingkud sikandin duon su ogpaminog ki Pablo. Na, pagyongyong ni Pablo to sikan otow, nasabutan din no migtuu sikan otow no ogkaulian sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kaling mig-ikagi si Pablo to maagbot, “Tindog ka!” Duon-dajun nakayaksu sikan pulid aw makapanow. ");
INSERT INTO msmNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pagkita to mgo otow to sikan nahinang ni Pablo, namangiyak sikandan aw ikagi to inikagihan dan no pig-iling, “Aduy, migkonsad kay dini ita to mgo diyus no nabayuy no otow!” ");
INSERT INTO msmNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Dajun dan hingadani si Bernabe ki Seus no yabow no diyus dan, aw si Pablo pighingadanan dan ki Herme no songo diyus dan isab, su sikandin man to migwali. ");
INSERT INTO msmNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Na, duon to gawas to sikan yunsud meyduon ampuanan dan ki Seus. Sikan baylan no mig-ugpa duon mig-andiya to yawanganan to sikan ampuanan. Migdaya sikandin to mgo baka no pigpaliotan to buyak su sikandin dow to mgo taga-yunsud ogtuman podom ongki Pablo. ");
INSERT INTO msmNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Di pagsabut onni Pablo to tuud to sikan mgo otow, pighigbit dan to kabo dan pagpakiyaya no nadootan sikandan. Dajun sikandan linaguy diya to kaotawan aw sapadi, ");
INSERT INTO msmNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Hoy, nokoy man sikan oghinangon now? Ajaw now ogpadajuna su angod koy da iyu no mgo otow. Iyan ing-andini noy su meyduon madojow no ignawnangon noy iyu agun talikudan now to mgo hinang no wada pues aw atubangon now sikan buhi no Diyus. Sikandin to mighinang to yangit, to pasak, to dagat, dow to tibo namakabotang duon. ");
INSERT INTO msmNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","To diya una pigpabay-anan din to mgo otow no wada dalimagmagan to Diyus agun matuman dan to inggad nokoy no ogtuuhon dan inggad wada mgo pues. ");
INSERT INTO msmNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Di migpakita gihapun to pagka-Diyus din, su meyduon mgo kadojawan no igpamogoy din ita. Su ogpaudanon din agun abútan ki to panghinanom ta agun ogkaabundahan ki to pagkoon aw ogkalipay ki.” ");
INSERT INTO msmNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Di inggad pad to sikan no mgo kagi onni Pablo, halus kona ogkapogongan sikan mgo otow to paghalad kandan to mananap. ");
INSERT INTO msmNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Na, meyduon migtidow no mgo Hibru no napuun diya to naliusan onni Pablo no Antioquia dow Iconio. Pigkumbinyu dan to mgo taga-Listra to pagkuntra ki Pablo. Dajun dan batuha aw gugujuda diya to yuwas to yunsud su nailing to boot dan no patoy on. ");
INSERT INTO msmNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Di sikan namanuu on ki Jesus nahimun aw lilibongi dan si Pablo. Dajun sikandin bangun aw pauli duon to yunsud. Pagkabukas, mig-andiya si Pablo dow si Bernabe to yunsud to Derbe. ");
INSERT INTO msmNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pagtidow onni Pablo diya to Derbe, ingwali dan sikan Madojow no Nawnangonon. Mahan-in to mgo otow duon no migpasakup ki Jesu-Cristo. Pagkatapus to sikan, pigbalikan dan to diya nangkabajaan dan no mgo yunsud to Listra dow Iconio hasta Antioquia no sakup to Pisidia. ");
INSERT INTO msmNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Duon to kada yunsud, pigdigon dan to mgo magtutuu aw sambagi no padajunon dan to pagsalig ki Jesus. Kagi dan, “Sikita no mgo magtutuu ogpakabaja to mahan-in no mgo kakulian ayha ki ogtidow duon to sikan gingharian to Diyus diya to yangit.” ");
INSERT INTO msmNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Duon to kada grupu to mgo magtutuu, migpili si Pablo dow si Bernabe to mgo panguyu. Dongan to pag-ampu dow pagpuasa, insalig sikandan onni Pablo diya to Ginuu no iyan isab pigsaligan dan. ");
INSERT INTO msmNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tapus to sikan, migpauli si Pablo dow si Bernabe to sikan imbaja dan duon to mgo prubinsya to Pisidia dow Pampilia. ");
INSERT INTO msmNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pagtidow dan duon to yunsud to Perga, ingwali dan to kagi to Diyus. Tapus to pagwali dan duon, migpadajun sikandan diya to yunsud to Atalia ");
INSERT INTO msmNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","aw nanakajan diya to dagat padeg diya to Antioquia no sakup to Siria. Duon sikandan likat to diya una no mig-ampu to mgo magtutuu no tabangan sikandan to Diyus to diya igpahinang din kandan. Na, manno natuman on sikan tibo, mig-uli on sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pagtidow dan diya to Antioquia, pighimun dan to mgo magtutuu aw nangoni to tibo impahinang to Diyus kandan. Ingnangon dan isab no mahan-in to kona no mgo Hibru no pigbogajan on to Diyus to lugar no makatuu on ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nayugoy to pag-ugpa ni Pablo dow ni Bernabe duon duma to mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Na, meyduon magtutuu no mgo Hibru no taga-Judea no migtidow duon to Antioquia su ogpang-anadon dan to mgo magtutuu duon. Mig-iling sikandan, “Ko kona now tumanon to pagtuli no insugu duon to sikan mgo balaod no imbilin ni Moises, kona kow ogkayuwas.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Di si Pablo dow si Bernabe hilabi supak to sikan, kaling pigyalis dan yagboy sikan mgo otow. Na, naujunan no umandiya to Jerusalem si Pablo dow si Bernabe hasta pila no taga-Antioquia no mgo magtutuu. Ogpagmiting sikandan to mgo apustulis dow duma no mgo panguyu to mgo magtutuu su oghusoy to sikan nayayalisan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kaling pigpalikat sikandan to taga-Antioquia no mgo magtutuu padeg diya to Jerusalem. Di nanghapit-hapit sikandan diya to mgo kayunsudan no sakup to Fenicia dow Samaria. Iyan tuud dan to pagnawnangon duon bahin to sikan kona no mgo Hibru no migpasakup on to Ginuu. Kaling migtukhow to mgo magtutuu no namakadinog to sikan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Na, pagtidow onni Pablo diya to Jerusalem, madojow to pag-abi-abi kandan to mgo magtutuu yakip to mgo panguyu dan hasta to mgo apustulis. Dajun ibatbat onni Pablo to tibo pighinang to Diyus no impabaja kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Di meyduon mgo magtutuu no sakup to Pariseo no migpagyalis. Migtindog sikandan aw ikagi, “Sikan mgo magtutuu no kona no Hibru, kinahangyan no tumanon dan sikan tumanon no imbilin ni Moises.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kaling nahimun manda to mgo apustulis dow duma no mgo panguyu to mgo magtutuu su oghusoy to sikan nayayalisan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tapus to mahaba no paghisgut, migtindog si Pedro aw ikagi, “Mgo suun ku, namaan kow no pigpili a to Diyus duon iyu agun ikawali ku sikan Madojow no Nawnangonon diya to kona no mgo Hibru agun makadinog sikandan aw pasakup ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na, to Diyus no namaan to sed to ginhawa to tibo mgo otow migpakiyaya no pigdawat din on sikan namanuu no kona no mgo Hibru. Su pigpakonsad din to Ispiritu Santu duon kandan angod to pighinang din ita to diya una. ");
INSERT INTO msmNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sikan pighinang din kandan wada kayainan ita, su to paggawang din to mgo sae dan tongod da man isab to pagtuu dow pagsalig ki Jesu-Cristo. ");
INSERT INTO msmNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kaling mgo suun, ko pabog-atan now sikandan to pagtuman to mgo tumanon no nabatasan ta, ogpakasupak kow to Diyus. Su ngani man sikita dow to mgo kaaw-apuan ta, di wada makatuman to sikan tibo. ");
INSERT INTO msmNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Na, ko migtuu ki no mgo Hibru no ogkayuwas ki tongod da to kadojow dow kayuuy ita to Ginuu no si Jesus, kinahangyan isab no tuuhan ta no ogkayuwas sikandan to angod da no paagi.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Migpahagtong to tibo nahimun. Naminog yagboy sikandan ki Bernabe dow ki Pablo no mig-ikagi to mgo milagru dow duma no mgo kabeynganan no nahinang to Diyus diya to kona no mgo Hibru no impabaja kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Tapus to pag-ikagi dan, mig-iling si Santiago, “Mgo suun, paminog kow kanay. ");
INSERT INTO msmNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Pignangonan kow on ni Simon Pedro to una no pagpakita to Diyus to kayuuy din diya to kona no mgo Hibru agun meyduon ogkasakup din. ");
INSERT INTO msmNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Katumanan yagboy sikan to pigsuyat to diya kibali mgo ba-ba to Diyus no pig-iling, ");
INSERT INTO msmNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Og-abut to panahon no ogbootan ku, kagi to Ginuu, no ogpauli a aw og-isabon ku ogtukudon to diya nawasa no gingharian ni David. Ogkaangod to ogtul-id a to bayoy no nayugoy da kagoba. ");
INSERT INTO msmNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Og-ilingon ku to sikan agun mamangha kanay to diya kona no mgo Hibru, su meyduon to diya oghinangon ku no mgo sakup. ");
INSERT INTO msmNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sikan to kagi to Ginuu no imaan din to planu din to diya una.’ ” ");
INSERT INTO msmNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Migpadajun si Santiago to pag-ikagi, “Kaling seini to planu ku. Kona ta ogsamukon to kona no mgo Hibru no ogpasakup to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Di madojow ko pasuyatan ta no meyduon ogpalikajan kandan. Kona sikandan ogkoon to igtuman to mgo diyus-diyus. Kona isab sikandan ogkoon to yangosa dow to ogpityokon no mgo mananap, su kona ogpakaawas to yangosa. Hasta kona sikandan oghinang to kayaw-ajan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Seini no mgo balaod igpatuman ta to sikan kona no mgo Hibru agun to angod ta no mgo Hibru kona ogkadootan kandan. Su namaan ki no sugud pad to diya una, impang-anad on sikan mgo balaod ni Moises duon to kada yunsud. Aw hangtod kuntoon ogbasahon sikan duon to simbahan ta no mgo Hibru kada Aedow no Tigpahuway.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kaling to mgo apustulis dow to duma no mgo magtutuu diya to Jerusalem yakip to mgo panguyu dan nahiujun no ogpili sikandan to pila no mgo duma dan no oghatod to suyat diya to Antioquia. Ogduma sikandan ki Pablo dow ki Bernabe. Iyan pigpili dan to daduwa no mgo panguyu dan no si Silas dow si Judas no pigdagnajan ki Barsabas. ");
INSERT INTO msmNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Sikan suyat no impadae kandan pig-iling, “Kumusta kow no kona no mgo Hibru diya to Antioquia dow Siria hasta diya to Silicia no naangod on kanami no magtutuu? Sikami no mgo apustulis dow panguyu to mgo magtutuu, ");
INSERT INTO msmNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","nakadinog koy no meyduon kun duma noy no namansamuk iyu no kona no mgo Hibru aw nalibod kow su yahi sikan impang-anad dan. Di wada noy sikandan sugu-a. ");
INSERT INTO msmNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kaling pig-uujunan noy no ogpili koy to mgo otow no ogsuguon noy diyan iyu. Ogpadumahon noy sikandan ki Bernabe dow ki Pablo no mgo hinilabi ta. ");
INSERT INTO msmNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Maunungon sikandan ki Jesu-Cristo no Ginuu ta inggad nakabaja sikandan to mgo kamuyahanan tongod kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Na, si Judas dow si Silas no ogpadumahon noy ongki Pablo iyan ognangon iyu to seini suyat noy. ");
INSERT INTO msmNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Paghihimun noy, migmandu to Ispiritu Santu no kona kow ogpabog-atan to mgo tumanon. Sikami isab mig-ujun to sikan. Di meyduon sikan ogpalikajan iyu. ");
INSERT INTO msmNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kona kow ogkoon to igtuman to mgo diyus-diyus. Kona kow isab ogkoon to yangosa dow to ogpityokon no mgo mananap, su kona ogpakaawas to yangosa. Hasta kona kow oghinang to kayaw-ajan. Kadojawan now ko likajan now sikan tibo. Sikan da.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Dajun palikata sikan upat no ka otow aw panow sikandan padeg diya to Antioquia. Pagtidow dan, pighimun dan to tibo mgo magtutuu aw ibogoy kandan sikan suyat. ");
INSERT INTO msmNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","No mabasa dan on sikan, migtukhow hilabi sikandan aw migdigon to ginhawa dan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na, si Judas dow si Silas no kibali mgo ba-ba to Diyus nayuyugajan to pagnongnong to sikan mgo magtutuu agun mahogot to pagtuu dan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tapus to pila no simana no pag-ugpa dan duon, pigpalikat sikandan to taga-Antioquia no mgo magtutuu duma to panghinaut no malinow to panow dan. Dajun sikandan pauli duon to sikan migsugu kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Nayugoy pad si Pablo dow si Bernabe duon to Antioquia. Ing-anad dan aw iwali to kagi to Ginuu no pigbuligan to mgo duma dan. ");
INSERT INTO msmNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Songo aedow pig-ikagihan ni Pablo si Bernabe, “Madojow ko youjon ta to mgo suun ta diya to mgo yunsud no pigwalihan ta to kagi to Diyus.” ");
INSERT INTO msmNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Mig-ujun si Bernabe, di gustu din no ogpadumahon si Juan no pigngadanan isab ki Marcos. ");
INSERT INTO msmNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Di nayogda si Pablo su to diya una no panow dan diya to Pampilia, pig-ojowan sikandan ni Marcos. Wada sikandin padajun to pagbulig. ");
INSERT INTO msmNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Sikandin to nakaamung to maagbot no pagyayalis ni Pablo dow ni Bernabe hangtod migsusuwoy sikandan. Si Bernabe migpaduma ki Marcos aw sakoy to barku no linayagan padeg diya to Cipre. ");
INSERT INTO msmNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Si Pablo migpaduma ki Silas. Tapus to pag-ampu to mgo magtutuu no tabangan sikandan to Ginuu, migpanow sikandan ");
INSERT INTO msmNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","no duon baja to mgo prubinsya to Siria dow Cilicia, aw hogota dan to pagtuu to mgo magtutuu no oghihimun diya to yain-yain no mgo banwa. ");
INSERT INTO msmNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Na, migpadajun si Pablo dow si Silas diya to mgo yunsud to Derbe dow Listra. Duon to Listra meyduon magtutuu no iyan ngadan si Timoteo. Hibru to inoy din no sakup ni Jesus, di to amoy din Grigu. ");
INSERT INTO msmNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nasaja si Timoteo to tibo mgo taga-Listra dow taga-Iconio no mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pagkabaeki ni Pablo ki Timoteo, pigduma din. Di no wada pad sikandan likat, impatuli sikandin ni Pablo agun kona madootan to mgo Hibru, su namaan sikandan no Grigu to amoy ni Timoteo aw kona ogtuman to sikan no tumanon to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Na, pigyogob-yogob dan to mgo kayunsudan aw inawnangon dan sikan ogpalikajan to kona no Hibru no migtuu on. Sikan to naujunan to mgo apustulis hasta to mgo panguyu to mgo magtutuu diya to Jerusalem. ");
INSERT INTO msmNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Na, migdigon to pagtuu to mgo sakup to Ginuu, aw kada aedow migdugang to kahan-in dan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Og-andiya podom onsi Pablo to prubinsya to Asia su ogwali to kagi to Diyus, di wada tugut to Ispiritu Santu. Kaling duon sikandan baja to mgo prubinsya to Frigia dow Galacia. ");
INSERT INTO msmNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","No madani on sikandan to prubinsya to Misia, ogsuwoy podom pailing to prubinsya to Bitinia, di wada isab tugut to Ispiritu ni Jesus, no ko ita pa, Ispiritu Santu. ");
INSERT INTO msmNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kaling migbaja sikandan duon to Misia aw togbang diya to yunsud to Troas. ");
INSERT INTO msmNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","To diya no kadukiloman, meyduon taga-Macedonia no otow no nasailow ni Pablo. Migtindog kun sikandin aw pakiyuuy no mig-iling, “Sadangay payahus ka dini to Macedonia aw tabangi koy.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Dajun koy panghimos su nakasabut koy no ogsuguon koy to Diyus to pagwali to sikan Madojow no Nawnangonon diya to prubinsya to Macedonia. ");
INSERT INTO msmNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Na, migsakoy koy to barku no linayagan likat to Troas pailing diya to Macedonia. To una no aedow migpayohus koy diya to sikan puyu to dagat no og-ilingon to Samotracia, aw pagkabukas migpadajun koy diya to yunsud to Neapolis. ");
INSERT INTO msmNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pagduung noy, mighaw-as koy aw panow pailing diya to Filipos no mayow-ag no siyudad duon to sikan distritu to Macedonia. Mahan-in to mgo taga-Roma no mig-ugpa duon, aw migtuman sikandan to mgo balaod dow batasan to Roma. Nayugoy-yugoy koy duon to sikan no siyudad. ");
INSERT INTO msmNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Duon to Aedow no Tigpahuway, migyuwas koy to siyudad aw togbang diya to higad to wohig su basi meyduon oghihimun no mgo Hibru no og-ampu duon. Pagtidow noy, meyduon iyan pigkita noy no mgo bohi no mighihimun. Dajun koy ingkud aw walihi noy sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Songo magsisimba to Diyus no naminog to mgo kagi noy iyan ngadan si Lydia. Taga-Tiatira sikandin no mamaligjaay to mahalon no panapton no bayulit to kulur. Pagdinog din to sikan kagi ni Pablo, pigdugangan to Diyus to pagsabut din hangtod migtuu sikandin ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dajun sikandin pabawtismu dow to tibo panimayoy din. Tapus to sikan, pigpak hinggat koy din. Kagi din, “Ko naaha now no matuud to pagtuu ku to Ginuu, dini kow paabut to bayoy ku.” Na, wada koy makabalibad to hangyu din. ");
INSERT INTO msmNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Songo aedow no ogpadodoyog koy duon to sikan ampuanan noy, nakatagbu koy to udipon no daega no meyduon diwata no ogpanag-an. Sikan mgo tag-udipon nangkasapian tongod to pagpanag-an din. ");
INSERT INTO msmNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Sikan daega migyupug-yupug kanami dow ongki Pablo aw kinuligsik, “Seini no mgo otawa mgo suguonon to Diyus no Yabow to Tibo! Ognangonan kow dan dow og-amonuhon agun mayuwas kow.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Sed to mahan-in no mgo aedow migkinuligsik sikan daega hangtod no naingey on yagboy si Pablo. No wada din on kaantus sikan no kasamuk, piglingi din sikan bohi aw ikagihi sikan migyona kandin, “Tongod to gahom to ngadan ni Jesu-Cristo ogsuguon ku sikuna, yaguji sikan daega!” Duon-dajun migyaguy sikan migyona kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pagkamaan to sikan mgo tag-udipon no natampod to panaepi dan, pigdakop dan dajun si Pablo dow si Silas aw gujuda diya to husajan su ogpaatubangon to mgo huwis. ");
INSERT INTO msmNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Pagtidow dan duon to atubangan to mgo huwis, sikan mgo tag-udipon mig-iling, “Seini no mgo Hibru ogsamuk-samuk dini to siyudad ta. ");
INSERT INTO msmNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Gustu dan no ogdawat aw ogtuman ki to sikan batasan dan no supak to balaod ta no mgo sakup to Roma.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dajun masigsikad to mgo otow no nahimun duon aw hinang to kagubut. Dajun sugu sikan mgo huwis no hukasan si Pablo dow si Silas aw palinapdosi. ");
INSERT INTO msmNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Tapus dan linapdosi to maagbot, pigprisu sikandan. Pigsugu to sikan mgo huwis sikan sinaligan to prisuhan no deyjawon yagboy to pagbantoy kandan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kaling imbotang sikandan diya to kinasoyodan no sinabong aw ipandog to mgo kobong dan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na, duon to sikan prisuhan, si Pablo dow si Silas mig-ampu aw kanta to pagsaja to Diyus, aw to duma no mgo prisu naminog kandan. Anoy man no tonga on to kadukiloman, ");
INSERT INTO msmNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","hinggawan migtiyog to maagbot no migkusu-kusu to sikan pigpasikadan to prisuhan. Dajun kangkaabri to tibo mgo pertahan aw kangkatangtang to gapus to tibo mgo prisu. ");
INSERT INTO msmNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Pagkapukawi to sikan sinaligan to prisuhan, pigkita din no nangkaabri on to mgo pertahan. Nailing to boot din no namanyaguy on to tibo mgo prisu, kaling pighuyabut to ispada din su og-ogot podom. ");
INSERT INTO msmNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Di migbansagon si Pablo, “Hoy! Kona ka’g ogot! Seini koy da tibo!” ");
INSERT INTO msmNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Dajun pasoga-i to sikan sinaligan to sed to prisuhan. Dajun sikandin migpatised aw yuhud no namidpid duon to atubangan ni Pablo dow ni Silas. ");
INSERT INTO msmNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Pigpayogwa din sikandan aw pangusip, “Og-amonu a man agun mayuwas a?” ");
INSERT INTO msmNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Migtabak sikandan, “Tuu aw salig ka ki Jesus no Ginuu agun mayuwas ka yakip to mgo sakup to panimayoy nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Dajun sikandin walihi onni Pablo to kagi to Ginuu hasta to mgo sakup to panimayoy din. ");
INSERT INTO msmNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","To diya no uras to kadukiloman, pighunadan to sikan sinaligan to prisuhan to mgo pali dan. Dajun sikandin pabawtismu yakip sikan mgo sakup din. ");
INSERT INTO msmNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tapus to sikan, pigdae din si Pablo dow si Silas diya to bayoy din aw pakoona. Malipajon sikan sinaligan to prisuhan hasta to mgo sakup din su migtuu on sikandan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pagkabukas, sikan mgo huwis migsugu to mgo pulis no pasabukan si Pablo dow si Silas. ");
INSERT INTO msmNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kaling pignangonan to sikan sinaligan si Pablo, “Ogpasabukan kow to mgo huwis. Na, ogpakayuwas kow on, wadad ogsamuk iyu.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Di pig-ikagihan ni Pablo sikan mgo pulis, “Eh, sikami no mgo sakup to Roma, impayatus koy dan gabii duon to atubangan to kaotawan aw ipaprisu no wada imbistigaha. Kaling nakayapas sikandan to balaod to Roma! Na, pagkakuntoon, ighinobong dan to pagpayuwas kanami. Kona sikan ogkahimu! Kinahangyan no sikandan mismu to umandini aw iyan mupayuwas kanami.” ");
INSERT INTO msmNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Dajun panow sikan mgo pulis aw nangoni to mgo huwis to pig-ikagi ni Pablo. Pagkadinog dan no sakup naan to Roma si Pablo dow si Silas, nangkahaedok sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Kaling mig-andiya to prisuhan aw pamuju to pasaylu ongki Pablo. Dajun dan payuwasa onsi Pablo aw hangyu-a no yagujan sikan siyudad dan. ");
INSERT INTO msmNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","No makayuwas on si Pablo dow si Silas, mig-andiya sikandan to bayoy ni Lydia aw sambagi dan sikan mgo suun dan duon ki Jesu-Cristo no digonon to pagtuu dan. Dajun sikandan panow. ");
INSERT INTO msmNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nakabaja si Pablo dow si Silas to mgo yunsud to Ampipolis dow Apolonia ayha sikandan tidow diya to Tesalonica. Duon to sikan no siyudad, meyduon simbahan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Migsimba si Pablo duon su sikan man to nabatasan din. Sed to tatoyu no Kasabaduhan no iyan Aedow no Tigpahuway to mgo Hibru, migwali sikandin pinasikad to Kasuyatan to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Impasabut din kandan to diya Insaad no Manyuyuwas, aw pigmatuud din no kinahangyan og-antus sikandin aw ogkamatoy aw tapus to sikan, ogkabanhaw da. Kagi ni Pablo, “Si Jesus sikan ognangonon ku no Insaad no Manyuyuwas.” ");
INSERT INTO msmNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pagkadinog to mgo otow to kagi ni Pablo, meyduon mgo Hibru no migtuu ki Jesus aw migpasakup ongki Pablo. Mahan-in isab to mgo Grigu no tahan migsimba to Diyus no migtuu on ki Jesus yakip to inila no mgo bohi. ");
INSERT INTO msmNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Di to duma no mgo Hibru migsilag ongki Pablo. Kaling pighimun dan to buguy no mgo otow no duon da og-ugpa to kadayanan aw ipagubut dan to siyudad. Pigsulung dan to bayoy ni Jason su ogpamanghaon dan si Pablo dow si Silas su ogpaatubangon to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Di manno wada dan katae-i, piggujud dan si Jason dow duma no mgo magtutuu diya to mgo upisyalis to sikan siyudad aw pamanbansagon, “Nakayogob onsi Pablo to paghinang to kasamuk, aw kuntoon nakatidow on dini ita! ");
INSERT INTO msmNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Duon sikandan papaabuta ni Jason to bayoy din. Tibo sikandan migyapas to balaod to sikan yabow no hari diya to Roma, su og-iling no iyan on yabow no hari sikan og-ilingon to Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Pagkadinog to kaotawan dow mgo panguyu dan to sikan riklamu to mgo Hibru, nagubut sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Di si Jason dow to mgo duma din pigsabukan tapus dan papiyansahi. ");
INSERT INTO msmNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pagkadukilom on, si Pablo dow si Silas pigpalikat to sikan mgo suun to pagtuu pailing diya to Berea. Pagtidow dan, migpadajun sikandan diya to simbahan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Na, to taga-Tesalonica ogyupigon to taga-Berea su to mgo taga-Berea nahinangop to pagdawat to sikan ing-anad ni Pablo. Aw kada aedow ogsusihon dan to Kasuyatan to Diyus agun maaha dan dow matuud iyan sikan impang-anad ni Pablo. ");
INSERT INTO msmNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Mahan-in duon kandan to migpasakup ki Jesus yakip to Grigu no mgo yukos dow inila no mgo bohi no Grigu isab. ");
INSERT INTO msmNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Di sikan pagwali ni Pablo to kagi to Diyus diya to Berea pigdinog to diya taga-Tesalonica no mgo Hibru no migsilag ki Pablo, kaling mig-andiya sikandan aw samuka to kaotawan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Duon-dajun pigpalikat si Pablo to mgo magtutuu pailing diya to higad to dagat. Di si Silas dow si Timoteo migpakamonang da duon to Berea. ");
INSERT INTO msmNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Si Pablo imbue-us to pila no ka otow kotob to siyudad to Atenas. Pagtidow dan duon, migpauli sikan mgo duma din diya to Berea no migdaya to tugun ni Pablo ki Silas dow ki Timoteo no padalion da sikandan payupugon. ");
INSERT INTO msmNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","No migtatagad pad si Pablo to pagtidow onni Silas diya to Atenas, hilabi migdoot to ginhawa din su pigkita din no mahan-in hilabi to mgo diyus-diyus no pig-ampuan to mgo taga-duon. ");
INSERT INTO msmNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Duon to simbahan to mgo Hibru, pigwalihan ni Pablo sikan mgo Hibru hasta sikan kona no mgo Hibru no migtahud isab to Diyus. Duon isab to kabaknaan to siyudad ogpaghisgut sikandin kada aedow to mgo otow no ogpakaanduon. ");
INSERT INTO msmNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Meyduon mgo maistru no sakup to Epikurio dow Estoiko no nakapaggilaung ki Pablo. Pagkadinog dan to kagi din, to duma kandan mig-iling, “Nokoy man buwa to igpasabut to sikan kagi din no wada sibli?” Mig-iling isab to duma, “Sikan pighisgutan din angod man to yahi no mgo diyus.” Pig-ikagi dan sikan su iyan ing-anad ni Pablo si Jesus dow to pagkabanhaw. ");
INSERT INTO msmNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dajun dan daeha si Pablo duon to bubungan no og-ilingon to Areopago no mitinganan to mgo inila to sikan siyudad. Dajun dan sikandin ikagihi, “Ogkaliyag koy ogpaminog to sikan bag-u no igpang-anad nu. ");
INSERT INTO msmNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Su bag-u sikan dini kanami, aw gustu noy no makasabut koy to sikan.” ");
INSERT INTO msmNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pigpaikagi dan si Pablo su sikandan no mgo taga-Atenas dow to mgo yampot duon, hilabi ogganahan ogpaminog dow oghisgut-hisgut to inggad nokoy no bag-u no igpang-anad inggad magkahapun. ");
INSERT INTO msmNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Kaling migtindog si Pablo duon to atubangan dan aw ikagi, “Mgo taga-Atenas, nakapaniid a no matinumanon kow yagboy to tinuuhan now. ");
INSERT INTO msmNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Su to paghihipanow ku kani to seini siyudad now, pigkita ku to mgo ampuonon now. Meyduon ngani pigkita ku no haladanan no meyduon sinuyat no pig-iling, ‘Og-ampuon kani sikan diyus no wada noy kamaani.’ Na kuntoon, ignangon ku iyu sikan pigsimba now no wada now kamaani. ");
INSERT INTO msmNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Sikandin to Diyus no mighinang to seini pasak dow to tibo namakabotang kani. Sikandin to ogboot to tibuuk yangit dow pasak. Kaling kona sikandin og-ugpa duon to ampuanan no hininang to otow. ");
INSERT INTO msmNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","To Diyus kona no kinahangyan no og-atimanon, su wada man kuyang kandin. Sikandin man nasi to ogbogoy to tibo kaotawan to kinabuhi hasta to duma no mgo kadojawan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Likat to songo otow, pighinang din to tibo mgo tribu aw ipatangkap kani to tibuuk kalibutan. Tahan din on pigbootan to kada nasyun dow kagan-u din ogtukudon dow kagan-u oggawangon. Pigbootan din isab to ogkangkapanggadan to mgo banwa no og-ugpaan dan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Pig-iling din to sikan agun pamanghaon dan podom sikandin kotob no madamdaman dan aw matae-an. Di to tinood, kona no madiyu ita to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Su meyduon pig-iling, ‘Tongod to gahom din, buhi ki aw ogpakalihok ki.’ Meyduon isab mgo duma now no magbabalak no mig-iling, ‘Sikita mgo anak to Diyus.’ ");
INSERT INTO msmNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Na, manno mgo anak ki to Diyus, kona ki oghona-hona no to Diyus angod to buyawan dow plata hasta batu no nahinang no diyus-diyus tongod to pagboot dow kapandoy to otow. ");
INSERT INTO msmNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Hinuun, wada pad kamaan to otow bahin to Diyus, wada din sikandan kastiguha to angay kandan. Di kuntoon igsugu din on to tibo mgo otow diya to inggad andei no banwa no musosey sikandan aw talikudan dan to mgo sae dan. ");
INSERT INTO msmNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Su meyduon aedow no pigbootan din no oghukuman to tibo kaotawan. Meyduon isab otow no pigpili din to paghukum kandan to minatarong. Pigbanhaw on to Diyus sikan ogpahukumon din pagmatuud no sikandin iyan to oghukum.” ");
INSERT INTO msmNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pagdinog dan to sikan kagi ni Pablo bahin to pagkabanhaw, pigngingisihan sikandin to duma. Di to duma mig-iling, “Og-isab koy da ogpaminog to sikan ognangonon nu.” ");
INSERT INTO msmNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dajun panow si Pablo. ");
INSERT INTO msmNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Na, mey mgo otow duon no migpasakup ki Pablo su migtuu on ki Jesu-Cristo yakip si Dionisio no kunsihal to sikan no banwa dow songo bohi no iyan ngadan si Damaris. ");
INSERT INTO msmNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Miglikat si Pablo to Atenas padeg diya to siyudad to Corinto. ");
INSERT INTO msmNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Duon din ipaghibayak to songo Hibru no taga-Ponto no iyan ngadan si Aquila. Bag-u pad sikandin tidow likat to siyudad to Roma no sakup to Italia duma to asawa din no si Priscila. Nakayaguy sikandan su to tibo mgo Hibru pigpang-abug ni Hari Claudio likat to Roma. Wada kayugoy migpagkita si Pablo kandan diya to bayoy dan. ");
INSERT INTO msmNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Mig-aangod to pangita ni Pablo dow sikan mag-asawa, su tibo sikandan mgo maghinangay to tuldahonon. Kaling migsoyod si Pablo kandan to pag-ugpa agun ogkaduduma sikandan to pagtrabahu. ");
INSERT INTO msmNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kada Aedow no Tigpahuway, og-andiya si Pablo to simbahan to mgo Hibru aw walihi din hasta to kona no mgo Hibru agun madae din sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pagtidow ni Silas dow ni Timoteo likat to Macedonia, wadad yain no pighinang ni Pablo gawas to pagwali to kagi to Diyus. Pigmatuud din diya to mgo Hibru no si Jesus yagboy to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Di wada sikandan tuu, nasi dan on pigdoot-doot si Pablo. Tongod to sikan no pagsupak to mgo Hibru, pigpanghiyab ni Pablo to kabo din pagpakiyaya no wadad on yabot din kandan. Kagi din, “Sae now on ko kona kow mayuwas. Wadad yabot ku iyu. Sugud kuntoon, iyan ogwalihan ku to kona no mgo Hibru.” ");
INSERT INTO msmNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kaling pig-ojowan din sikan mgo Hibru aw andiya to bayoy ni Tito Justo no kona no Hibru di migsimba to Diyus. Sikan bayoy din topad to sikan simbahan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Migpadajun si Pablo to pagpang-anad, aw mahan-in to mgo taga-Corinto no migtuu to Ginuu dow migpabawtismu yakip si Crispo no panguyu to sikan simbahan to mgo Hibru hasta to tibo pamilya din. ");
INSERT INTO msmNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Songo kadukiloman no malipodong si Pablo, nasailow din no mig-ikagi to Diyus kandin, “Kona ka ogkahaedok. Padajuna to pagwali to kagi ku ");
INSERT INTO msmNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","su ogduma a ikow. Wada oghilabot ikow su mahan-in pad to mgo taga-kani no oghinangon ku no mgo sakup.” ");
INSERT INTO msmNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kaling sed to songo tuig tonga, mig-ugpa si Pablo duon aw pang-anad to kagi to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Di pag-ingkud ni Galio to pagka-gubernadur to Grecia, nauujun to mgo Hibru to pagsupak ki Pablo. Pigdakop dan sikandin aw paatubanga ki Gubernadur Galio. ");
INSERT INTO msmNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Inriklamu dan sikandin. Kagi dan, “Seini no otawa nangumbinyu to kaotawan to pagtuman to Diyus to paagi no supak to mgo balaod to tinuuhan noy.” ");
INSERT INTO msmNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Og-ikagi podom si Pablo, di naunahan sikandin ni Galio no mig-iling, “Sikiyu no mgo Hibru, ko nakayapas pa seini otow to balaod to gubernu, maagkap ko mabog-at, ogpaminogon ku to riklamu now. ");
INSERT INTO msmNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Di manno mig-uunoy kow to pagyayalis bahin to sikan iyu no mgo balaod dow to paghiluwas to sikan tinuuhan now, sikiyu to angajan no oghusoy to sikan kasamuk now. Kona a ogpanginyabot.” ");
INSERT INTO msmNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dajun din sikandan abuga duon to husajan. ");
INSERT INTO msmNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Duon-dajun si Sostenes no panguyu to sikan simbahan to mgo Hibru pigdakop to kona no mgo Hibru aw kulataha duon to yuwas to husajan. Di wada lipara si Galio. ");
INSERT INTO msmNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","No nayugoy on to pag-ugpa ni Pablo duon to Corinto duma to mgo magtutuu, migpanow sikandin pailing diya to Siria. Nahiduma si Pablo dow onsi Aquila. Mighapit sikandan duon to yunsud to Cencrea, aw paupow si Pablo pagpakiyaya no meyduon panaad din to Diyus. Dajun sikandan sakoy to barku no linayagan. ");
INSERT INTO msmNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Mighapit isab sikandan duon to siyudad to Efeso. Pagtidow dan duon, migpakamonang da sikan mag-asawa, di si Pablo migpadajun. No wada pad sikandin panow, mig-andiya to simbahan to mgo Hibru aw walihi sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","No oglikat on si Pablo, meyduon mgo taga-Efeso no mighangyu pad podom kandin no mupakamonang naa, di wada sikandin patagon. ");
INSERT INTO msmNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nasi no pig-ikagihan din sikandan no mig-iling, “Ko tugutan a to Diyus, ogpauli a dini iyu.” Dajun panakajan si Pablo duon to dagat likat to Efeso ");
INSERT INTO msmNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","padeg diya to Cesarea no sakup to Siria. Pagduung to sikan pigsakajan din duon to Cesarea, mighaw-as sikandin aw andiya to Jerusalem. Tapus din pangumustaha to mgo magtutuu duon, migpadajun diya to Antioquia, ");
INSERT INTO msmNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","di wada yugoy duon. Migpanow manda sikandin aw duon baja to mgo prubinsya to Galacia dow Frigia aw digona din to mgo magtutuu duon. ");
INSERT INTO msmNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Na, meyduon songo Hibru no taga-Alejandria no migtidow diya to siyudad to Efeso no iyan ngadan si Apolos. Mahan-in to namaanan din bahin to Kasuyatan to Diyus, aw angod to ogpanodosan to mgo otow no ogpaminog kandin. ");
INSERT INTO msmNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tahan sikandin pig-anad bahin to Ginuu no si Jesus, aw namaanan din on to pagpamawtismu ni Juan to diya una. Madasigon sikandin to pagpang-anad. Hustu sikan impang-anad din, di kuyang pad to namaanan din bahin ki Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Na, pagtidow ni Apolos duon to Efeso, migsugud sikandin to masaligon no pagpang-anad duon to simbahan to mgo Hibru. Pagkadinog ni Priscila dow ni Aquila to sikan impang-anad din, pigduma dan diya to bayoy dan aw idedeyjow i-anad kandin sikan impasabut on to Diyus. ");
INSERT INTO msmNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Na, mighona-hona si Apolos no og-andiya to prubinsya to Grecia. Pagkamaan to mgo taga-Efeso no mgo magtutuu to sikan planu ni Apolos, pigdasig dan sikandin to pagpadajun. Pigsuyatan dan man ngani to mgo magtutuu diya to Grecia no abi-abihon dan si Apolos. Dajun sikandin panow. Na, pagtidow din, pigtabangan yagboy sikandin to Ginuu, aw ingkatabang din isab to mgo magtutuu duon. ");
INSERT INTO msmNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tongod to madigon no mgo katarongan din pinasikad to Kasuyatan to Diyus, nayupig din to mgo Hibru duon to atubangan to kaotawan. Su pigmatuud din kandan no si Jesus to diya Insaad no Manyuyuwas. ");
INSERT INTO msmNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","No duon pad si Apolos to Corinto, migpadajun si Pablo to panow din no namaja-baja to mgo kayunsudan diya dapit to didaja to Efeso kotob no nakatogbang sikandin diya to siyudad to Efeso. Duon din ipaghibayak to pila no mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Dajun din usipa sikandan, “Nadawat now on to Ispiritu Santu to diya pagtuu now?” Migtabak sikandan, “Wada koy kamaan to sikan. Iyan pad pagdinog noy to sikan og-ilingon to Ispiritu Santu.” ");
INSERT INTO msmNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Mig-usip si Pablo, “Nokoy man naan to pigtuuhan now to diya pagbawtismuhi iyu?” Migtabak sikandan, “Iyan pigtuuhan noy sikan impang-anad ni Juan no Magbawtismuhay to diya una.” ");
INSERT INTO msmNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Kagi ni Pablo, “To kaotawan pignangonan iyan ni Juan no kinahangyan mupabawtismu pagpakiyaya no migsosey on sikandan aw talikudi to mgo sae dan. Di pig-ikagihan din isab no mutuu sikandan dow musalig to sikan ogpakasunu kandin no si Jesus.” ");
INSERT INTO msmNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Na, pagkadinog to sikan mgo taga-Efeso to kagi ni Pablo, migpabawtismu sikandan to ngadan ni Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pagsampoyongi ni Pablo to uyu dan, dajun sikandan pigsedan to Ispiritu Santu aw nakaikagi to mgo inikagihan no wada dan kasabuti. Naikagi dan isab to igpaikagi to Diyus duon to kandan inikagihan. ");
INSERT INTO msmNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Mgo sampuyu-tag-duwa sikandan no ka otow. ");
INSERT INTO msmNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Na, sed to tatoyu no buyan mig-inandiya si Pablo to simbahan to mgo Hibru aw masaligon no migwali. Naningkamot sikandin to pagpangumbinyu kandan bahin to paghari to Diyus agun madae sikandan. ");
INSERT INTO msmNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Meyduon namanuu, di meyduon isab wada tuu su madoson to uyu dan. Duon to atubangan to mgo otow, pigdoot-doot dan sikan pigtuuhan to mgo sakup ni Jesus. Kaling pig-ojowan sikandan ni Pablo. To diya namanuu migduma kandin, aw kada aedow pigwalihan din to mgo otow duon to mitinganan ni Tirano. ");
INSERT INTO msmNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Migpadajun sikan sed to daduwa no tuig. Kaling migtangkap sikan kagi to Ginuu hangtod no nakadinog to tibo mgo otow duon to prubinsya to Asia, mgo Hibru dow kona no mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Duon to sikan no panahon, kabeynganan yagboy to mgo milagru no pighinang to Diyus no impabaja ki Pablo. ");
INSERT INTO msmNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Inggad panyu da ubin duma no panapton no ogpakadogkot to yawa din, ko ogdaehon diya to mgo masakiton, ogkangkaulian. Ogkangkaabug isab to mangkadoot no ispiritu no ogsamuk to otow. ");
INSERT INTO msmNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Na, meyduon mgo Hibru no ogyogob-yogob to mgo kabaryuhan su ogpang-abug to mangkadoot no ispiritu no ogsamuk to otow. Pig-anti dan piggamit to ngadan ni Jesus no Ginuu. Mig-iling sikandan, “Tongod to gahom to ngadan ni Jesus no ingwali ni Pablo, yogwa ka.” ");
INSERT INTO msmNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Sikan to pigsunud to pitu no mgo anak ni Esceva no songo yabow no magdudumaya to tinuuhan to mgo Hibru. ");
INSERT INTO msmNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Di pagdinog to sikan ispiritu to kagi dan, mig-ikagi sikandin, “Eh, migkiyaya a kay ki Jesus dow ki Pablo. Di sikiyu, hintawa kow man?” ");
INSERT INTO msmNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dajun sikandan yapugada to sikan otow no pigsedan to madoot no ispiritu. Nayupig sikandan to gahom, kaling nangkapalian aw namakalinaguy no nakapahawae-hawae. ");
INSERT INTO msmNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","No makadinog to mgo taga-Efeso to sikan nahitabu, nangkahaedok sikandan tibo, mgo Hibru dow kona no mgo Hibru. Sikan on yagboy to panahon no migdugang to pagtahud to ngadan ni Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Kaling mahan-in to mgo magtutuu no mig-angkon duon to atubangan to kaotawan to madoot no mgo hinang dan su og-ojowan dan on. ");
INSERT INTO msmNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Meyduon isab namanuu on no mgo urasyunan no nandaya to mgo libritu dan aw sangaba duon to atubangan to sikan nahimun no mgo otow. No bilangon to imboli to sikan mgo libritu, bali kalim-an no libu to sikan saepi dan. ");
INSERT INTO msmNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tongod to sikan tibo no nahitabu, migtangkap to kagi to Ginuu no madaogon yagboy duon to sikan no banwa. ");
INSERT INTO msmNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Tapus to sikan no mgo hitabu, migplanu si Pablo no ogbajaan din to mgo prubinsya to Macedonia dow Grecia aw ogpauli diya to Jerusalem. Migplanu isab sikandin no likat to Jerusalem, ogpadajun diya to Roma. ");
INSERT INTO msmNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Dajun din paunaha diya to Macedonia si Timoteo dow si Erasto no daduwa to sikan mgo pangabaga din, di sikandin migpakamonang pad duon to prubinsya to Asia. ");
INSERT INTO msmNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","To diya panahon no mig-ugpa pad si Pablo diya to Efeso, meyduon maagbot hilabi no kagubut no nahitabu kuntra to sikan pigtuuhan to mgo sakup ni Jesus. ");
INSERT INTO msmNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mey otow duon no iyan ngadan si Demetrio no ogpanghinang to mangkaintok no bayoy-bayoy no plata no impaaw-angod to sikan ampuanan ki Diana no diyus dan. To mgo sinuhuyan din nangkasapian tongod to sikan no pangita. ");
INSERT INTO msmNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Songo aedow pighimun ni Demetrio sikan mgo sinuhuyan din dow to duma no angod-angod din to pangita aw ikagihi, “Mgo suun ku, namaan ki no madojow to panginabuhi ta tongod da to seini no pangita. ");
INSERT INTO msmNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Di kuntoon ogpamiligru seini pangita ta. Pigkita now on buwa sikan otow no iyan ngadan si Pablo, aw pigdinog now to oghinangon din. Og-iling sikandin no kona kun no matuud no Diyus sikan oghinangon to otow. Mahan-in on hilabi to mgo otow kani to Efeso hasta tibuuk prubinsya to Asia no nadaya din. ");
INSERT INTO msmNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na, to ogkadeygan to sikan, ogtamajon seini pangita ta aw konad on ogpues sikan ampuanan ta ki Diana. Aw kona no sikan da, su ogkaminusan sikan diyus ta no pigsimba inggad andei dini to Asia hasta to tibuuk kalibutan!” ");
INSERT INTO msmNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pagdinog to sikan mgo otow to kagi ni Demetrio, pigyangotan sikandan no namangiyak, “Gamhanan si Diana no diyus ta no mgo taga-Efeso!” ");
INSERT INTO msmNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Nagubut dajun to tibuuk siyudad. Pigdakop dan si Gayus dow si Aristarco no mgo taga-Macedonia no duma ni Pablo to mgo panow din aw gujuda diya to mitinganan. ");
INSERT INTO msmNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ogsed podom si Pablo su og-ikagi duon to kaotawan, di pigpogongan sikandin to mgo magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Meyduon isab mgo upisyal to sikan prubinsya no mgo amigu ni Pablo no migtugun no kona sikandin ogpasedon duon to sikan pighihimunan to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nagubut hilabi to mgo otow duon. Yain-yain to imbansagon dan, di to kahan-inan kandan wada kalibutan dow nokoy to ingkahimun dan. ");
INSERT INTO msmNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nahaedok yagboy to mgo Hibru duon su unu ko sikandan to oghapoyan to sikan no kagubut, su tinamay man sikandan. Kaling pig-ikagihan dan si Alejandro to igpaikagi dan kandin aw patindoga duon to kabaknaan to sikan nahimun no mgo otow agun magapian din to mgo Hibru. Anoy man no nakatindog on si Alejandro, pigsingyasan din sikan mgo otow no konad ogsasamuk su og-ikagi sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Di no mamaanan dan no Hibru sikandin, migkinuliya on nasi sikandan sed to daduwa no uras no mig-iling, “Gamhanan si Diana no diyus ta no mgo taga-Efeso!” ");
INSERT INTO msmNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Bali no pigsapadan to songo upisyal to siyudad sikan mgo otow no nahimun. Kagi din, “Mgo suun ku no taga-Efeso, nataga to tibo no sikita iyan sinaligan to sikan ampuanan ki Diana no gamhanan no diyus ta. Insalig isab ita sikan balaan no batu no nauyug likat to yangit. ");
INSERT INTO msmNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Wada ogpakalidung to sikan. Kaling sigkon kow to ogkinasamuk. Kona kow puli ogyagmak. ");
INSERT INTO msmNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Pigdaya now seini mgo otow dini, di wada man pigkawat dan duon to sikan ampuanan. Wada man isab mgo kagi dan no pagtamay to sikan diyus ta. ");
INSERT INTO msmNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Na, ko meyduon igkariklamu ni Demetrio dow mgo duma din kuntra to inggad hintawa, meyduon husajan ta dow mgo huwis no ogkariklamuhan dan. Pariklamuha sikandan duon. ");
INSERT INTO msmNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Na, ko kona kow makaangay to hinusajan duon, ipahusoy now panahon to miting to mgo taga-yunsud. ");
INSERT INTO msmNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Di kuntoon, pahonok kow. Su ko padajunon now to pagginubut, basi ikariklamu ki to gubernu to Roma. Na, og-amonu ki kay to pagpanalipod to kaugalingon ta su wada man katarongan ta.” ");
INSERT INTO msmNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Tapus din ikagiha sikan, pigpauli din sikan mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Na, pagsigkon on to kagubut, pighimun ni Pablo to mgo magtutuu aw digona din. Tapus to sikan, migpanumaid sikandin su og-andiya to prubinsya to Macedonia. ");
INSERT INTO msmNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Pigpanghapitan din to mgo kayunsudan no sakup to Macedonia aw digona din yagboy to mgo magtutuu. Pagtidow din duon to prubinsya to Grecia, ");
INSERT INTO msmNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","mig-ugpa sikandin duon sed to tatoyu no buyan. No ogsakoy on podom sikandin to barku no linayagan pailing diya to Siria, pigdinog din no meyduon mgo Hibru no oghimatoy kandin. Kaling mighona-hona sikandin no ogpauli nasi diya to Macedonia no piglikatan din su duon sikandin ogbaja. ");
INSERT INTO msmNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","5","Meyduon mgo otow no migduma kanami dow ki Pablo, di mig-una sikandan aw tagadi koy diya to Troas. Iyan namang-una si Sopater no anak ni Piro no taga-Berea, si Aristarco dow si Segundo no mgo taga-Tesalonica, si Gayus no taga-Derbe, si Tiquico dow si Trofimo no mgo taga-Asia hasta si Timoteo. ");
INSERT INTO msmNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pagkaliwas to sikan pista to mgo Hibru no og-ilingon to Pista to Pan no Wada Patubu, migsakoy koy to barku no linayagan likat to Filipos. Pagyaboy to lima no aedow, natitibo koy diya to Troas, aw mig-ugpa koy duon sed to songo simana. ");
INSERT INTO msmNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Duon to una no aedow to simana, mighihimun koy su ogsasayu koy to pagkoon dow to paghandom to kamatajon ni Jesus. Manno ogpanow on si Pablo pagkabukas, pighaba din to panapus no wali din kotob to tonga to kadukiloman. ");
INSERT INTO msmNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Mahan-in to mgo mitsa duon to sikan pighihimunan noy ");
INSERT INTO msmNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","diya to ikatoyu no andana to sikan bayoy. Na, meyduon batan-on no iyan ngadan si Eutico no mig-iingkud duon to bintana. Mahaba hilabi to wali ni Pablo, kaling nalilipodong sikandin. Aw pagkahikyup din, nauyug diya to pasak. Patoy on no tabangan sikandin to mgo otow. ");
INSERT INTO msmNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Duon-dajun migpon-ug si Pablo aw yangkobi din dow gogoya si Eutico. Kagi din, “Kona kow ogkalimuut su nabuhi da sikandin!” ");
INSERT INTO msmNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Dajun pauli si Pablo diya to diatas aw pagsayu to mgo magtutuu to pagkoon dow paghandom to kamatajon ni Jesu-Cristo. Na, tapus to sikan, migpaggilaung si Pablo kandan kotob no nabukas ayha sikandin panow. ");
INSERT INTO msmNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Di si Eutico inghatod diya to bayoy din, aw nalipay sikandan tibo su nabuhi da. ");
INSERT INTO msmNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na, sikami no mgo duma ni Pablo, una koy no miglikat. Nanakajan koy diya to dagat pailing diya to yunsud to Asos. Ogbajaan noy si Pablo su iyan man sabut noy no ogbaktas sikandin. ");
INSERT INTO msmNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pagtidow noy duon to Asos, pigpasakoy noy sikandin aw padajun koy tibo diya to yunsud to Mitilene. ");
INSERT INTO msmNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","16","Pagkasunu no aedow, sikan pigsakajan noy migpadajun hangtod no nakatopad duon to puyu to Quio. Wada koy hapit duon to siyudad to Efeso no sakup to Asia su tahan man planu ni Pablo no kona koy ogyangan duon to sikan no prubinsya. Apuradu to panow ni Pablo su gustu din no makatidow diya to siyudad to Jerusalem no kona pad og-abut sikan pista no og-ilingon to Aedow to Pentecostes. Kaling man, puli da nabukas, migtidow koy on diya to puyu to Samo, aw to sunu no aedow, migduung koy duon to yunsud to Mileto. ");
INSERT INTO msmNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","No duon on si Pablo to Mileto, impadokat din to taga-Efeso no mgo panguyu to magtutuu. ");
INSERT INTO msmNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Pagtidow dan, pig-ikagihan din sikandan, “Mgo suun ku, namaan kow yagboy to batasan ku sugud to diya pagtidow ku kani to prubinsya to Asia. ");
INSERT INTO msmNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Migtuman a to Ginuu no wada pagpayabi-yabi inggad kanunoy migtagdu to yuha ku, inggad mig-antus a to mgo kalisod tongod to mgo planu to mgo Hibru to pagdoot kanay. ");
INSERT INTO msmNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Namaan kow isab no to pagpang-anad iyu, wada inghobong ku no ogpakadojow iyu. Di nasi no naningkamot a to pagpang-anad duon to mgo mitinganan hasta duon to mgo bayoy now. ");
INSERT INTO msmNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Pignongnong ku to mgo Hibru dow kona no mgo Hibru no musosey sikandan aw talikudan to mgo sae dan hasta mutuu ki Jesus no Ginuu ta. ");
INSERT INTO msmNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Na, kuntoon og-andiya a to Jerusalem su iyan mandu to Ispiritu Santu. Wada ku kamaani dow nokoy to ogkahitabu kanay diya. ");
INSERT INTO msmNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Iyan da namaanan ku no inggad andei a ogdeg, ogpatahanan a to Ispiritu Santu no oglisod a aw ogkaprisu. ");
INSERT INTO msmNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Di baeka on su wada ku oyoga seini kinabuhi ku kani to kalibutan. Nasi no ogpaningkamot a no matapus ku to pagnawnangon to sikan Madojow no Nawnangonon bahin to kadojow dow kayuuy to Diyus ita, su sikan to impahinang kanay ni Jesus no Ginuu. ");
INSERT INTO msmNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Na, sikiyu tibo no nanangonan kud on bahin to paghari to Diyus, kuntoon ogtahomon ku no kona kinow on ogkakikita manda. ");
INSERT INTO msmNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Kaling indani now yagboy seini. Sugud kuntoon, ko meyduon ogpakaimpernu duon iyu, konad no sae ku. ");
INSERT INTO msmNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Su impang-anad ku man iyu to tibuuk no pagboot to Diyus. Wada inghobong ku. ");
INSERT INTO msmNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Bantaji to pagkinabuhi now. Bantaji isab sikan tibo magtutuu no insalig iyu to Ispiritu Santu, su sikandin to migbogoy iyu to katongdanan to pag-atiman to mgo sakup to Diyus no naangkon din pinaagi to kamatajon ni Jesus no Anak din. ");
INSERT INTO msmNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Namaanan ku no ko malius ad, meyduon mgo gayuon no ogpang-anad no ogtidow iyu. Ogkaangod sikandan to mgo mananap no wada kayuuy no ogpamood to mgo buhi su ogdooton dan to pagtuu to sikan mgo sakup now. ");
INSERT INTO msmNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ogkahitabu man ngani no meyduon mgo sakup now no ogpang-anad to gayu agun no maojowan to matuud, aw sikandan nasi to ogsunudon. ");
INSERT INTO msmNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kaling bantoy kow. Kona kow ogkalingow no sed to tatoyu no tuig pignongnong ku sikiyu aedow dow madukilom. Migtagdu man ngani to yuha ku tongod iyu. ");
INSERT INTO msmNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Na kuntoon, mgo suun ku, igsalig ku sikiyu diya to Diyus, su pinaagi to kadojow dow kayuuy din, ogkahogot to pagtuu now. Ogpakadawat kow isab to mgo kadojawan no igbogoy din to diya mgo inabin din. ");
INSERT INTO msmNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“No diyan a pad iyu, wada a silag to saepi, buyawan dow kabo to inggad hintawa. ");
INSERT INTO msmNT_vpl VALUES ("AC20_34","074_20_34","ACT","2